﻿USE sofia;
DROP TABLE IF EXISTS sofia.sbl_vpl;
CREATE TABLE sbl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sbl_vpl WRITE;
INSERT INTO sbl_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","(Kawkanta 1-41) Makalmà ya tawoy ahè anhomonol ha tawtorò nin tawtawoy mangala-et, ahè ampanggawà nin anggaw-en nin mawmakasalanan, boy ahè ampakilamo ha mawmanoya-toyà ha Diyos; ");
INSERT INTO sbl_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","no alwan hay an-ikaliga na ay hay nakaholat ya Halità nin Pangino-on, boy allo yabi nan ampi-awengen. ");
INSERT INTO sbl_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Hay tawoy ombayri ay ayin imbalag ha po-on kayoy intanem ha pingit lanom ya ahè angkapaltan mamonga ha pana-on nin pamonga. Hay bawbolong nin habayti ay ahè angkalaneh maski ka-ingitan; kayà pirmin nalaboyong. Anyaman ya anggaw-en nin ombayri ya tawo, hiya ay ma-in nin kapalindawayan. ");
INSERT INTO sbl_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Piro hay tawtawoy mangala-et ay alwan ombayro, ta hila ay bilang ha apah ya angka-i-alipad nin angin. ");
INSERT INTO sbl_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Kayà ha allon panonosga nin Diyos ay aghila makalibri ha iparosa na konla, boy aghila makapakilamo ha tawtawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Tandà nin Pangino-on ya tawtawoy mangahampat kateng pamimiyay la, boy an-asiwa-en na hila, piro hay tawtawoy ampamiyay ha kala-etan ay mipalako ha kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Antà masyadon ampamahang ya tawtawoy alwan Hodiyo, boy antà ampagplano hila nin ayin kawkakokowintan bagay? ");
INSERT INTO sbl_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Hay aw-arì ha babon lotà boy ampipamo-on ay nititipon ta ampimimiha nin komontra ha Pangino-on Diyos boy ha impangakò nay pinilì na. ");
INSERT INTO sbl_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Kayà ombayri ya hinalità la: “Hay sarili tamo ay alihen tamo ha pamomo-on la; agtamoyna pasakop konla.” ");
INSERT INTO sbl_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Banà bayro ha amplanowen la, hay Pangino-on ya anti ha katatag-ayan ay ampangka-ili konla boy antoya-toya-en na hila. ");
INSERT INTO sbl_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Hapa-eg hay Diyos ay naghalità nin namahang konla. Angkalimo hila banà bayro ha masyadoy pahang na konla, ya wana, ");
INSERT INTO sbl_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Hay Arì ya pinilì ko ay inggawà koyna ha bakil ya an-ingaten Siyon ya masagradoy dogal.” ");
INSERT INTO sbl_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Hay an-ipanogò nin Pangino-on ya hinalità nin Arì ya pinilì ay ombayri: “Hinalità kongko nin Pangino-on, ya wana, ‘Hika ya Anak ko; hapa-eg ay impatnag ko ya hiko ya Tatay mo. ");
INSERT INTO sbl_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Mangawok ka kongko ta kaganawan tawoy alwan Hodiyo ay igwà ko komo kateng kaganawan anti bayri ha babon lotà ay igwà ko komo nin pag-ikon mo. ");
INSERT INTO sbl_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Hika ya mamo-on konla nin ma-in kahigpitan, boy sohitosen mo hila nin bilang kan ampanamek keren.’” ");
INSERT INTO sbl_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Hikawoy aw-arì, pakaronong kawo; hikawo itaman ya ampipamo-on bayri ha babon lotà, mag-atap kawo. ");
INSERT INTO sbl_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Hay Pangino-on ay pagsirbiyan moyo nin ma-in panggogomalang. Pakaliga kawon magsirbi kona emen agna kawo pamahangan. ");
INSERT INTO sbl_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Magmaka-aypà kawon homamba kona emen agna kawo mapahangan boy parosawan nin ikamati moyo, ta hay Pangino-on ay maparan mamahang. Makalmà ya kaganawan tawoy ma-in pamahimalà ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","(Habayti ay hinolat ni Dabid hin pinowayowan na hi Absalom ya anak na) Pangino-on, malakè ya ka-away ko; hay lakè nin angkomontra kongko. ");
INSERT INTO sbl_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Malakè ya ampaghalità nin hay Diyos ay ahè manambay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Piro, Pangino-on, hika ay bilang ha halanggà ya ampakapi-atap kongko; komo ampangibat ya karangalan ko. Hika ya ampamakhaw nin nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Hiko ay andoma-ing ha Pangino-on ya anti ha masagradoy bakil, boy tandà koy anleng-en na ko. ");
INSERT INTO sbl_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ha pamimirà ko boy pangangatoloy ay ampaka-imata ko nin ayin dipirinsya ta amprotiksyonan ako nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Maski liboliboy ka-away ko ya anti ha mamalibot ko ay agko angkalimo. ");
INSERT INTO sbl_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Pangino-on kon Diyos, tandà ko ya anhira-en moy kapangyariyan nin kaganawan ka-away koy mangala-et emen agla ko mapangno; kayà patoloy mo kon ilibri. ");
INSERT INTO sbl_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Hay kalibriyan ay ampangibat ha Pangino-on. Dayi, hay tawtawo mo ay biyan mon kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","(Kanta ni Dabid) Diyos ko ya ma-in kahampatan, tobayen mo dayi ya an-ipakirawat ko. Tinambayan mo ko ha kawkagipitan ko; kayà leng-en moy panalangin ko, ta lalò mo ko dayin ingalowan hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Hikawoy tawtawo, anggan makano moyo ko insoltowen? Anggan makano moyo labiyen ya bawbagay ya ayin kowinta boy homonol ha alwan peteg? ");
INSERT INTO sbl_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Habayti ya tanda-an moyo: imbokod ako nin Pangino-on nin para kona ta ma-in akon panlalabi kona. Anleng-en nin Pangino-on ya an-ipakirawat ko kona. ");
INSERT INTO sbl_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Dapat kawon malimo ha Pangino-on boy itegen moyoy panggawà kasalanan. Mako kawo ha matinek ya dogal ta sori-en moyon mahampat ya sarili moyo. ");
INSERT INTO sbl_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Pahimalà kawo ha Pangino-on, boy hay idolog moyo kona ay nararapat ya pangonsowilowan na. ");
INSERT INTO sbl_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Malakè ya angkalabay nin hila ay magkama-in nin mangaganday bagay. Pangino-on, mangonsowilo ka dayi konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Hay kaligawan ya inggawà mo kongko ay igit et ha kaligawan nin naka-alawah boy nakapilimpeh nin malakè ya pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ha oras nin hiko ay mirà boy matoloy ay ma-in akon katinekan; agko mapangno ta hika, Pangino-on, ya mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","(Kanta ni Dabid) Pangino-on, leng-en moy panalangin ko, boy dayi ma-intindiyan mo ya labay kon totolen ya agko makwan halita-en. ");
INSERT INTO sbl_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Arì ko ya Diyos ko, leng-en mo dayi ya an-ida-ing kon an-ipanalangin komo ya tambay. ");
INSERT INTO sbl_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","No bayombokah ay angkalengè mo ya bosis koy ampanalangin komo; no anhomilà anay allo ay an-anti-en koy tobay mo ha panalangin ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Hika ya Diyos ay ahè angkatowà ha kala-etan, boy agmo ampayagan nin makapakarani komo ya mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Agmo simpri ampayagan nin makapaki-arap komo ya mangahambog, boy angka-inakitan moy kaganawan ampipanggawà nin kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Amparosawan mon apo-en ya ampipagbongkok kateng manga-ilig mamatin tawo boy mangaha-ol. ");
INSERT INTO sbl_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Piro hiko, banà ha masyadoy ingangalo moy ma-in panlalabi ay lomo-ob ako ha masagradoy bali mo ta homamba ko komo nin ma-in panggogomalang. ");
INSERT INTO sbl_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Pangino-on, banà ta ma-in akon kawka-away ay pangonawan mo ko nin kompormi ha kahampatan mo, boy ipatnag mo kongko no anyay labay mon gaw-en ko. ");
INSERT INTO sbl_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Hay anhalita-en nin kawka-away ko ay ahè mapahimala-an, ta hay labay lan bongat ay kahira-an. Hay bebey la ay emen ha abirtoy tinabon ya anhomngaw, ta hay aw-ilgo la ay poro panloloko. ");
INSERT INTO sbl_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Diyos ko, sintinsyawan mo hilan parosawan. Dayi, hay pawplano lay mangala-et ay mipabira konla. Agmo hila payagan nin makapaki-arap komo, ta hila ay masyadon makasalanan boy angkomontra komo. ");
INSERT INTO sbl_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Piro kaganawan dayi nin ampahimalà nin hika ya mangi-atap konla ay paligawen mo; hila dayi ay ayin tegen ha pagkanta banà ha katowa-an la. I-atap mo hila emen lomiga ya ampipanlabi komo. ");
INSERT INTO sbl_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Hika, Pangino-on ay ampamolalag ha tawtawoy mangahampat; hay ingangalo mo ay ampambi konlan protiksyon ta habaytoy pinagkahalanggà la. ");
INSERT INTO sbl_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","(Kanta ni Dabid) Pangino-on, agmo ko ha-aren nin pahang mo, boy agmo ko parosawan no ampamahang ka. ");
INSERT INTO sbl_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Pangino-on, ingalowan mo ko ta makapey ya nawini ko; pakahampaten mo ko ta mabyat ya angkatanam ko. ");
INSERT INTO sbl_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Ombayro simpri ha nakem ko ya masyadon angkagolo. Pangino-on, anggan makano mo ko pa-olayan bayri ha angkatanam ko? ");
INSERT INTO sbl_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Pangino-on, alang-alang ha ingangalo moy ma-in panlalabi, pakarani ka kongko ta ilibri mo ko emen agko mati, ");
INSERT INTO sbl_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","ta no mati ko boy no mipalako ko ha dogal nin nikati, bayro ay ayin mamanemtem komo ni mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Mapagal akoyna ha pan-agol nin banà ha angkatanam ko; kayà yabiyabi, hay pamira-an ko ay angkabahà nin lowà ko. ");
INSERT INTO sbl_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Banà ha panangih ko, hay mata ko ay mabereg ana nin bilang ha mata nin tawoy mato-ayna. Habayti ay kagagaw-an nin kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Pakarayò kawo kongko, hikawoy ampipanggawà nin kala-etan, ta nilengè nin Pangino-on ya an-itangih kon ida-ing kona. ");
INSERT INTO sbl_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Hay da-ing ko kona ay nilengè na, boy ampinto-o ko nin hay pawpanalangin ko ay antobayen na. ");
INSERT INTO sbl_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Dayi, kaganawan ka-away ko ay mareng-eyan boy mikalito. Antimano dayi, hila ay mipagbiran mog-alih nin banà ha kareng-eyan la. ");
INSERT INTO sbl_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","(Habayti ay kanta ni Dabid ya kinanta na ha Pangino-on ay tongkol ha ka-away na ya hi Kos ya inalalak ni Binhamin) Pangino-on kon Diyos, napakarani ko komo ta anti komo ya kalibriyan ko. Ilibri mo ko ha kaganawan nin labay mamadya-dyà kongko, ");
INSERT INTO sbl_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","ta maka gitan la kon gibakgibaken nin ayin imbalag ha anggaw-en nin liyon. No mangyari baytoy ombayro ay ayin mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Pangino-on kon Diyos, no warì ta ma-in akon ginawà ya mala-et ya bilang ha ombayri: no nangwa ko nin alwa kon ikon, ");
INSERT INTO sbl_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","no nagtraydor ako ha amigo ko, o no namayani ko ha ka-away nin ayin bara-nan ");
INSERT INTO sbl_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ay ayin balin kamaten akon dakpen nin kawka-away ko, biha patyen boy ibalag lay bangkay ko ha gabok. ");
INSERT INTO sbl_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Pangino-on, biliwen moy ampangyari kongko; masyadoy pahang kongko nin kawka-away ko. Ipakit mo dayi itaman konla ya pahang mo. Diyos ko, asikasowen mo ko dayin tambayan emen mangyari ya kalabayan moy katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Mamititipon kan malakè ya tawo ta hika ya anti ha katatag-ayan ya mamo-on konla. ");
INSERT INTO sbl_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Hika, Pangino-on, ya manosga nin kaganawan tawo. Kompormi ha kahampatan ko, panosga mo kongko ay paptegan mo konla ya ayin akon mala-et ya ginawà. ");
INSERT INTO sbl_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Dayi, pategenen moy kala-etan nin tawtawoy mangala-et, balè hay tawtawoy mangahampat ay pakatibayen mo ha kahampatan la. Hika ya Diyos ya ma-in kahampatan ya ampakatandà nin nakem boy ka-ihipan nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Diyos ya pinagkahalanggà ko ya ampangi-atap kongko. An-ilibri nay tawtawo ya mahampat ya pagnanakem. ");
INSERT INTO sbl_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Hay panonosga nin Diyos ay makatoynongan; hiya ay pirmin mapahang ha tawtawoy patoloy ha panggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","No hay tawtawo ay ahè maghehe ha kawkasalanan la, hay gaw-en nin Diyos ay ombayri: pataremen nan i-ahà ya kowinta hondang na, ihandà nay kowinta bayì na, ");
INSERT INTO sbl_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","boy hay kowinta yawò nay impabayah ya miha ha kowinta aw-armas nay ampakamati ay nakapatoyò ana konla. ");
INSERT INTO sbl_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Biliwen moyoy mala-et ya tawo ya ampangihip nin manggawà kala-etan; hay amplanowen na ay kagolowan boy panloloko. ");
INSERT INTO sbl_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Hiya ay nangotkot nin malalè ya lobot emen pakarabo-an nin kanayon, piro mismon hiya ya narabò bayro ha lobot ya kinotkot na. ");
INSERT INTO sbl_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Kayà hiyan mismo ya nagdosa ha kala-etan nin gawgawà na; hiya simpri ya nakatanam nin hatoy labay nan ipatanam ha kanayon. ");
INSERT INTO sbl_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Hiko ay magpasalamat ha Pangino-on banà ha kahampatan na, boy magkanta ko nin pamomori ha Pangino-on ya Pinakamakapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","(Kanta ni Dabid) Pangino-on ya Pangino-on nawen, hay kapangyariyan mo ay ampipatnag ha kaganawan dogal ha babon lotà. Hay kagandawan mo ya ahè mapantayan ay nipatnag angga ha katatag-ayan. ");
INSERT INTO sbl_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Hay mangayamò ya aw-anak boy kawkolaw ay ampipagkantan pamomori komo. Banà bayri, hika ay emen ha matibay ya dipinsa ya makapategen nin kawka-away mo. ");
INSERT INTO sbl_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","No ampaninglà ako ha langit ya ginawà mo ta angkakit koy bowan boy bawbito-en ya ingkolokar mo ");
INSERT INTO sbl_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ay an-ihipen ko no anya ya tawo ta ampanemtemen mo boy ampa-alaga-an mo. ");
INSERT INTO sbl_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Balè ginawà mo ya nin ma-aypà ha aw-anghil boy intag-ay mo ya nin pinarangalan nin emen ha arì. ");
INSERT INTO sbl_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Kaganawan bagay ya ginawà mo ay inggawà mo ha hilong kapangyariyan na, ");
INSERT INTO sbl_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","bilang ha tawtopa, bawbakà, aw-ayop ya mangahilib, ");
INSERT INTO sbl_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","mawmanokmanok, kawkonà, boy kaganawan ma-in biyay ya anti ha dagat. ");
INSERT INTO sbl_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Pangino-on ya Pangino-on nawen, hay kapangyariyan mo ay ampipatnag ha kaganawan dogal ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","(Kanta ni Dabid) Pangino-on, hika ay poriyen ko nin leseb ha nakem ko, boy ibabalità ko ya kawkapapa-ispantay bagay ya ginawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Banà komo ay magkanta ko nin ma-in kaligawan. Magkanta ko et nin pamomori komo, Pangino-on Diyos ya Pinakamakapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Hay kawka-away ko, makit la kan bongat ay matombah hilayna anggan mati. ");
INSERT INTO sbl_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Hika ya mahampat ya manonosga ay ampiknò ha trono boy hinosgawan mo ko nin hiko ay ayin ginawà ya mala-et. ");
INSERT INTO sbl_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Sinintinsyawan moy tawtawoy ahè antompel komo boy inapò moy mangala-et; kayà hila ay agana panemtemen anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Hay kawka-away nawen ay pina-anggawan mo; hinirà moy sawsiyodad la, boy hila ay talagan agana panemtemen. ");
INSERT INTO sbl_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Hay pamomo-on balè nin Pangino-on ay anggan makakanoman. Hay trono na ay inhandà na para pikno-an nan manosga. ");
INSERT INTO sbl_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Hay panonosga nin Pangino-on ha tawtawo bayri ha babon lotà ay kompormi ha kahampatan na boy makatoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Hay Pangino-on ay mapahimala-an ya dipinsa; kayà hay tawtawoy angka-apih ay ampakarani kona. ");
INSERT INTO sbl_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Hay nakabalay komo ay ampahimalà komo, ta hika, Pangino-on ay ahè ampama-olay ha ampakarani komo. ");
INSERT INTO sbl_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Magkanta kawon pamomori ha Pangino-on ya anti ha dogal ya an-ingaten Siyon. Hay tongkol ha ginawà na ay ibabalità moyo ha kaganawan tawo ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Hay Pangino-on ay ampamarosa ha namarayà; ampanemtemen nay tawtawoy inapih boy agna ampa-olayan ya an-ipakirawat la kona. ");
INSERT INTO sbl_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Pangino-on, biliwen moy pamadya-dyà kongko nin kawka-away ko; ingalowan mo ko nin ayowen ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Ilibri mo ko emen ko ma-ibalità ha tawtawo ha siyodad ya an-ingaten Siyon ya pamoriyan komo. Bayro ay magtowà ako ha pangilibri mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Hay tawtawoy ahè antompel komo ay kowinta narabò ha malalè ya lobot ya kinotkot la ya para karabo-an nin kanayon, boy hilan mismo ya kowinta nahagep nin bateng ya ingkanà la. ");
INSERT INTO sbl_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Hay Pangino-on ay angkabalayan ha matoynong ya panonosga. Hay tawtawoy mangala-et ay angkahagep ha sarili lan kagagaw-an. ");
INSERT INTO sbl_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Hila ay mipalako ha dogal ya kaparosawan kateng kaganawan tawoy ahè ambomalay ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Hay ampanga-ilangan ay ahè ampa-olayan nin Diyos, boy hay an-asawan nin aw-apih ay magkama-in nin katoparan ta hay pagka-apih la ay ahè manatili anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Pangino-on, pakarani ka kongko, boy agmo payagan nin mangyari ya maski anyay plano nin tawo ya kontra komo. Hika ya manosga ha tawtawoy ahè antompel komo. ");
INSERT INTO sbl_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Biyan mo hila, Pangino-on, nin kalimowan emen la matanda-an ya hila ay tawtawon bongat. ");
INSERT INTO sbl_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Pangino-on, antà pinakarayo-an mo ko, boy antà pina-olayan mo ko ha pana-on nin kawkagipitan ko? ");
INSERT INTO sbl_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Banà ha pagmalhay nin tawtawoy mangala-et ay ampadya-dya-an lay aw-apih; mismon hila dayi ya mahagep nin sarili lan kagagaw-an. ");
INSERT INTO sbl_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Hay mala-et ya tawo ay an-ipaghambog nay kala-etan ya annakemen na. Hiya ay makamkam boy andodosta-en nay Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ha pagmalhay nin mala-et ya tawo ay agna ansikapen nin mabalayan ya Diyos. Hay an-ihipen na boy anhalita-en na ay ombayri: “Agko parosawan nin Diyos boy ayin yan paki-emenan kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Hay gawgawà nin mala-et ya tawo ay panay kala-etan. Agna an-intindiyen ya panonosga nin Diyos boy kaganawan ka-away na ay antoya-toya-en na. ");
INSERT INTO sbl_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Hay anhalita-en na ha sarili na ay ombayri: “Hiko ay manatilin matibay boy agko magkama-in kagolowan.” ");
INSERT INTO sbl_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Hay anhalita-en na ay panay panenebey, kabongkokan, boy pagbabantà. Hay antotolen na et ay poro kagolowan boy kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Hiya ay ampagtagò ha dawdogal ya mangarani ha bawbanowa, ta bayro ya mangabang nin tawtawoy patyen na maski ayin ginawà ya kontra kona. Hiya ay sikriton ampangimaton nin hatoy tawtawoy labay nan patyen. ");
INSERT INTO sbl_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Hiya ay bilang ha liyon ya ampa-ihalimbeng nin ampangabang, ta ampangantì yan mahagep nay ayin pakakaya. Hiya ay bilang simpri ha mangangaho ya ampangibalombon ha bateng na; no nakarakep yayna ay anggitan nan ipakarayò. ");
INSERT INTO sbl_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Banà ha kakhawan na, hay angkahagep nay tawo ya ayin pakakaya ay kowinta angka-ipatombah na. ");
INSERT INTO sbl_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Hay anhalita-en nin mala-et ya tawo ha sarili na ay ombayri: “Agko an-asikasowen nin diyos; kayà agna angkakit ya anggaw-en ko.” ");
INSERT INTO sbl_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Pangino-on kon Diyos, pakarani kan manambay ha ampika-apih; agmo hila dayi pa-olayan. ");
INSERT INTO sbl_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Antà andodosta-en nin mala-et ya tawo ya Diyos? Antà anhalita-en na ha sarili na ya agya parosawan nin Diyos? ");
INSERT INTO sbl_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Piro, Pangino-on, angkakit moy kaganawan; an-asikasowen moy ampipagdanas nin ka-irapan boy kalele-an; kayà amparosawan moy ampipanggawà nin mala-et konla. Hay ayin pakakaya ay ampakopkop komo ta hika ya ampanambay ha ampipanga-ilangan. ");
INSERT INTO sbl_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Pategenen moy mangala-et ha panggawà lan kala-etan; parosawan mo hila ha kaganawan kala-etan ya ginawà la. ");
INSERT INTO sbl_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Hay Pangino-on ay Arì anggan makakanoman. Hay kawka-away nin Diyos ya anhomamba ha alwan peteg diyos ay agana makit ha dogal ya impangakò nin Diyos ha aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Pangino-on, nalengè moyna ya panalangin nin ampika-apih; ampakhawen moy nakem la boy anleng-en moy an-ida-ing la. ");
INSERT INTO sbl_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Andipinsawan moy aw-olila boy ampika-apih emen hay kapara lan tawo ya ma-in simprin kamatyan ay agana makab-in kalimowan konla. ");
INSERT INTO sbl_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","(Habayti ay hinolat ni Dabid) Hay kalibriyan ko ay an-ipahimalà ko ha Pangino-on. Kayà ayin kowinta no halita-en moyo man kongko ya ombayri: “Mog-alih kayna nin bilang ha manokmanok ya anlompad nin mako ha bakil, ");
INSERT INTO sbl_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","ta hay tawtawoy mangala-et ay nakapatoyò anay yawò la, ta pana-en lay tawtawoy mangahampat nin ayin makatandà. ");
INSERT INTO sbl_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Anya ya magawà nin tawtawoy mangahampat no ayin katinekan boy ayin ka-ayosan?” ");
INSERT INTO sbl_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Hay Pangino-on ay anti ha masagradoy bali na, boy hay trono na ay anti ha katatag-ayan ha kama-inan na. An-imatonan nay tawtawo boy tandà nay anggaw-en la. ");
INSERT INTO sbl_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Anhoboken nin Pangino-on ya tawtawoy mangahampat; balè hay tawtawoy mangala-et boy tawtawoy labaylabay ya kagolowan ay talagan angka-inakitan na. ");
INSERT INTO sbl_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Masyadoy iparosa ha tawtawoy mangala-et ta hila ay kowinta oranen nin apoy boy asopri. Hay pahang nin Diyos konla ay emen ha pagka-amot angin ya ampakahirà nin kaganawan. ");
INSERT INTO sbl_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Hay Pangino-on ay mahampat; kayà anlabiyen nay ampipanggawà nin kahampatan, boy hay ampipanhomonol kona ay makakit kona. ");
INSERT INTO sbl_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","(Kanta ni Dabid) Manambay ka, Pangino-on, ta ayin anan natilà ya mahampat ya tawo; ayin ana simprin tawoy tapat. ");
INSERT INTO sbl_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Kaganawan tawo ay ampibobongkokan ana boy hay anhalita-en la ha miha ta miha ay pawpangoto-otò. ");
INSERT INTO sbl_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Pategenen mo dayi, Pangino-on, ba-in ya tawtawoy ampaghalità nin pawpangoto-otò boy kawkabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Hay anhalita-en la ay ombayri: “Maghalità kayi anggan labay nawen, boy ayin nin makapategen konnawen. Ma-in warì makadikta konnawen nin halita-en nawen?” ");
INSERT INTO sbl_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Hapa-eg, hinalità nin Pangino-on, ya wana, “Banà ha pagka-apih boy pandodoma-ing nin ampipanga-ilangan ay pakarani ko konla, ta hay naboyot laynan anhangaren ya protiksyon ay igwà ko konla.” ");
INSERT INTO sbl_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Hay pawpangakò nin Pangino-on ay mapahimala-an, ta habayti ay bilang ha talagan pilak ya kapitoy bisis nin hinobok nin imparaan ha apoy emen mag-in poro. ");
INSERT INTO sbl_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Pangino-on, pirmi mo kayin ilibri boy i-atap ha tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Hay tawtawoy mangala-et ay anti ha maski ayrin dogal bayri ha babon lotà, boy balang miha ay an-ipagmapori ya kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","(Kanta ni Dabid) Pangino-on, bilang mo koynan niliwawan. Anggan makano mo ko nin ahè sisipanowen? Ayin ana nayì angga ya pamakaliwa mo kongko? Anggan makano mo ko pa-olayan? ");
INSERT INTO sbl_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Anggan makano ko te-ehen bayti ya kadya-dya-an ya ampambin kalele-an ha nakem ko nin allo-allo? Anggan makano nin hiko ay pirmin matalo nin ka-away ko? ");
INSERT INTO sbl_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Pangino-on kon Diyos, pakaraniyan mo ko boy tobayen; pakhawen mo ko emen agko mati. ");
INSERT INTO sbl_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","No ombayroy gaw-en mo kongko ay ahè mahalità nin ka-away ko ya tinalo na ko, boy hay ampipanggolo kongko ay ahè mipagtowà ta agla ko nara-eg. ");
INSERT INTO sbl_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Hiko ay ampahimalà ha ingangalo mo ya ma-in panlalabi, boy hay towà nin nakem ko ha pangilibri mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Kantawan koy Pangino-on ha kahampatan na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","(Habayti ay hinolat ni Dabid) Hay tawoy maghalità ha sarili na nin, “Ayin Diyos!” ay talagan tangah. Hay gawgawà nin tawtawoy ombayro ay talagan mala-et boy poro kala-etan; ayin ana konla nin ampanggawà kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Hay Pangino-on ya anti ha katatag-ayan ha kama-inan na ay ampanlonglong nin ampangimaton no ma-in et nin tawtawoy ampaka-intindi boy ampag-apeh nin makatandà nin tongkol ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Kaganawan ay ahè labay pakarani ha Diyos ta ampagpakala-et hila. Ayin ampanggawà nin kahampatan; ayin ni miha. ");
INSERT INTO sbl_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Hay pastang nin Pangino-on ay ombayri: “Kaganawan nayì nin ampanggawà kala-etan ay ayin tinandà? Hay tawtawo ko ay anggaw-an lan mala-et, boy aghila ampakirawat kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Hay mangala-et ay masyadon nikalimo ta hay Diyos ay anti ha tawtawoy ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ampagsistiyan nin mangala-et ya pawplano nin aw-apih, piro hay aw-apih ya ma-in pamahimalà ha Pangino-on ay an-i-atap na. ");
INSERT INTO sbl_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Dayi, hay Pangino-on ay mangilibri nin Aw-israylita. No mambin oman ya Pangino-on nin ka-inomayan ha tawtawo na, hay aw-inalalak ni Hakob ya ayin kanayon no alwan Aw-israylita ay mipagtowà. ");
INSERT INTO sbl_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","(Kanta ni Dabid) Pangino-on, hinoy karapatdapat nin pa-iri ha bali mo? Hinoy karapatdapat nin pa-iri ha masagradoy bakil ya kama-inan mo? ");
INSERT INTO sbl_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Hay karapatdapat nin pa-iri bayro ay ombayri: ayin kapintasan, ampanggawà kahampatan, boy ampaghalità kaptegan nin leseb ha nakem; ");
INSERT INTO sbl_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","ahè ampaghalità nin paninirà nin kanayon, ahè ampanggawà nin mala-et ha aw-amigo na, boy ahè ampangitotoltotol nin tongkol ha kapara na; ");
INSERT INTO sbl_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","angka-inakit ha tawoy mala-et, piro hay ampipanggomalang ha Pangino-on ay amparangalan na; maronong tomopad ha pangakò maski ikalogih na; ");
INSERT INTO sbl_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","ahè ampama-otang nin patobo-an, boy ahè ampasohol para manistigos nin kontra ha ayin kasalanan. Hay anggomawà nin ombayri ay manatilin matibay ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","(Habayti ay hinolat ni Dabid) Pangino-on, i-atap mo ko ta an-ipahimalà ko komo ya kalibriyan ko. ");
INSERT INTO sbl_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ombayri ya hinalità ko ha Pangino-on ko: “Hika ya Pangino-on ko; kaganawan ikahampat nin biyay ko ay ampangibat komo.” ");
INSERT INTO sbl_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Tongkol ha nag-in tawtawo nin Diyos bayri ha babon lotà, hila ay marangal boy ampakapakonsowilo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Hay ampakon homamba ha alwan peteg diyos ay ampahanan lay kalele-an la; kayà agko ma-arì makilamo konla ha pangidolog la, boy agko ma-arì homamba ha alwan peteg diyos ya anhambawan la. ");
INSERT INTO sbl_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Pangino-on, hika ya kaganawan ha biyay ko, boy an-igwà moy kaganawan panganga-ilangan ko; kateng biyay ko ay hika ya ampangoligtan. ");
INSERT INTO sbl_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Hay an-igwà mo kongko ay pagkahampat ya agko makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Amporiyen koy Pangino-on ya ampangitoto kongko; maski yabi ay hiya ya ampanorò ha nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Hay Pangino-on ay pirmi ha nakem ko; banà ta anti ya ha dani ko ay manatili akon matibay kona. ");
INSERT INTO sbl_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Banà bayri, hay nakem ko ay ampagtowà boy hay sarili ko ay ma-in kasigorowan. ");
INSERT INTO sbl_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Hay kalolowa ko ay agmo payagan mipalako ha dogal nin nikati; agmo simpri payagan nin mabolok ya nawini ko ta hiko ay tapat komo. ");
INSERT INTO sbl_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Hika ya mangitorò kongko nin daan ya palako ha biyay ya ayin anggawan; banà ta anti ka bayro, hiko ay magkama-in nin masyadoy kaligawan, boy habayti ya kaligawan ay anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","(Panalangin ni Dabid) Pangino-on, asikasowen mo ko boy leng-en moy an-ida-ing ko komoy makatoynongan. Pakaleleng-en moy panalangin ko ya leseb ha nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ha panosga mo kongko ay paptegan mo dayi ya hiko ay ayin ginawà ya mala-et, ta hika ya magtandà no anyay tamà. ");
INSERT INTO sbl_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Tandà moy nakem ko boy maskin yabi ay ampakarani ka kongko ta an-imatonan mo ko. Hiko ay sinorì mo piro ayin kan nakit ya kala-etan kongko. Ninakem ko ya agko makapagkasalanan ha paghahalità ko. ");
INSERT INTO sbl_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Tongkol ha mala-et ya gawgawà nin tawtawo ay na-i-atap koy sarili ko ha magoloy pamamaraan banà ha hawhalità mo. ");
INSERT INTO sbl_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Hiko ay ampamiyay nin kompormi ha an-itorò mo kongko, boy agko ampa-alilihan bayto. ");
INSERT INTO sbl_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Andoma-ing ako komo, Diyos ko, ta tandà ko ya pirmi mo kon antobayen. Asikasowen mo ko boy pakaleleng-en moy anhalita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Hika ay ampangilibri ta makapangyariyan ka; kayà hay ahè makwan ihipen ya ingangalo moy ma-in panlalabi ay ipatnag mo konnawen nin ampahimalà komo emen agkayi mapangno nin kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","I-atap mo ko nin bilang ha pangi-atap nin mata, boy kopkopen mo ko ");
INSERT INTO sbl_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","emen hay tawtawoy mangala-et boy kawka-away koy nakapalibot kongko ya labay mamati kongko ay ahè makapangno kongko. ");
INSERT INTO sbl_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Hila ay ayin ingangalo boy hay anhalita-en la ay kahambogan. ");
INSERT INTO sbl_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Maski ayri ko mako, hila ay nakapalibot kongko, boy ampaka-i-imatonan la ko ta ampag-aralan la no pangno la ko mapatalo nin ipatombah. ");
INSERT INTO sbl_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Hila ay bilang ha lawliyon ya nakangangaynan mangnga-ngà kongko, boy bilang ha aw-oybon liyon ya ampa-ihalimbeng nin ampangabang. ");
INSERT INTO sbl_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Pakarani ka kongko, Pangino-on, ta harangen mon talowen ya kawka-away ko, boy gamiten moy kowinta hondang mo ha pangilibri mo kongko ha mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Pangino-on, ilibri mo ko nin kapangyariyan mo ha ombayroy tawtawo, ta hila bayto, hay pag-asa la ay bayrin bongat ha babon lotà. Maski ombayro hila, hay panganga-ilangan la ay ampangibat komo. Hay aw-anak la ay ahè ampagkakolang, boy ma-in hilan nakalimpey kamama-in ya para ha aw-anak la. ");
INSERT INTO sbl_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Hiko balè, banà ha kahampatan ya inggawà mo kongko, Pangino-on, pangati ko ta mabiyay akon oman, makit katan bongat arap-arapan ay kontinto koyna. ");
INSERT INTO sbl_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","(Habayti ya kinanta ni Dabid ha Pangino-on hin inlibri ya nin Pangino-on ha ka-away na ya hi Arì Sawol boy ha kanayon et ya kawka-away na.) Pangino-on, anlabiyen kata nin leseb ha nakem ko boy hika ya ampamakhaw kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Hay Pangino-on ay kowinta malhay ya bato ya ampambin protiksyon boy dipinsa kongko; hiya ya ampangilibri kongko. Banà ta kowinta malhay ya bato ya Diyos ko ay hiya ya ampahimala-an ko nin mangilibri kongko. Hiya simpri ya pinagkahalanggà ko. An-idipinsa na ko boy anti kona ya kalibriyan ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Hiko ay ampakirawat ha Pangino-on ya nararapat poriyen; banà ha pamakirawat ko kona ay an-ilibri na ko ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Hay kapapa-hal ko ay dilikado ta hiko ay emen an-akayen nin kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Talagan ampamiligro ko ta bilang akon andomani ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Banà ha ka-irapan ya andanasen ko, hiko ay nakirawat ha Pangino-on; dinoma-ing ako ha Diyos ko nin tambayan na ko. Ha pandodoma-ing ko, hay bosis ko ay nalengè nin Diyos ha kama-inan na, boy nilengè nay inda-ing ko kona. ");
INSERT INTO sbl_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Hapa-eg, hay babon lotà ay na-eyeg ta nanlayon; hay pampatibay nin bawbakil ay nikagalaw, ta hay Diyos ay namahang. ");
INSERT INTO sbl_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ha kapahangan na ay ma-in ahok ya nilomwah ha kowinta balongoh na, boy ha kowinta bebey na ay ma-in anlomyab ya apoy ya nilomwah. ");
INSERT INTO sbl_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Hiya ay nag-aypà nin nangibat ha katatag-ayan ha kama-inan na ya hay antoklowan na ay makodpaw ya leem. ");
INSERT INTO sbl_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Hiya ay bilang anlompad nin mabilis, ta hay ampantan kona ya mihay klasin anghil ya an-ingaten kirobin ay angka-i-alipad nin makhaw ya angin. ");
INSERT INTO sbl_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Hiya ay nahalimbengan nin mareglem ya leem; hay makodpaw ya leem nin oran ay nakapalibot kona. ");
INSERT INTO sbl_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ha arapan na ay ma-in nilomway kilat ya ma-in lamoy yilo boy apoy ya namihahabwag nin hatoy makodpaw ya leem. ");
INSERT INTO sbl_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Hay Pangino-on ay namakorol nin ma-in lamoy yilo boy apoy; hay bosis nin Pinakamakapangyariyan ya Pangino-on ay nalengè. ");
INSERT INTO sbl_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Hay kawka-away na ay kowinta pinanà na anggan hila ay nangapihahabwag, boy nangilat anan nangilat ya nangibalombon konlan nog-alih. ");
INSERT INTO sbl_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Banà bayro, hay dagat ay binomabo, boy hay pampatibay nin lotà ay nipatnag. Ombayroy nangyari, Pangino-on, hin hina-ad mon pahang mo ya kawka-away mo. ");
INSERT INTO sbl_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Hay Pangino-on ya anti ha katatag-ayan ha kama-inan na ay nangilibri kongko ha ka-irapan nin bilang ha tawo ya angkalemeh ha malalè ya lanom. ");
INSERT INTO sbl_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Hiya ya nangilibri kongko ha makapangyariyan ya ka-away ko; inlibri na ko ha kawka-away ko ya ampipag-inakit kongko boy mangakhaw kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Hin anti ko ha kagipitan, hila ay napakarani kongko ta kalabanen la ko, piro Pangino-on ya nangalalay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Hiko ay inalih na ha piligroy dogal ta inggawà na ko ha ma-aliwahway dogal; inlibri na ko ta hiya ay nangonsowilo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Hay pangilibri kongko nin Pangino-on ay kowinta primyo ko banà ha kahampatan ko, boy banà ta ayin yan nakit ya ginawà koy kasalanan ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Hinonol koy an-ipanogò nin Pangino-on, boy agko hinomowawì ha Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Gineperan koy kaganawan nin an-ipanogò na, boy ayin akon ahè hinonol ha an-imanda na. ");
INSERT INTO sbl_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ha tegteg na ay ayin akon kamali-an ta in-atap koy sarili ko ha panggawà nin kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Inlibri ko nin Pangino-on banà ha kahampatan ko, boy banà ta ayin yan nakit ya ginawà koy kasalanan ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Hika, Pangino-on ay tapat ha tawoy tapat, boy ha tawoy ahè ampagkakanwarì nin hiya ay mahampat ay an-ipakit moy kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ha tawoy malinis ya pagnanakem ay an-ipakit moy kalinisan nakem mo; ha tawo balè ya ayin gawà ya mahampat, hay anggaw-en mo kona ay kompormi ha anggaw-en na. ");
INSERT INTO sbl_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Hay tawtawoy apih ay an-ilibri mo, piro hay tawtawoy mapagmalhay ay an-i-aypà mo. ");
INSERT INTO sbl_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Hika, Pangino-on, ya ampambin hawang ha nakem ko; hay anti ha biyay ko ya karegleman ay Pangino-on kon Diyos ya ampambin hawang. ");
INSERT INTO sbl_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Hika simpri ya ampambi kongkon hokaw nin mandawohong nin lomaban ha kawka-away ko; hika et ya ampambi kongko nin kakhawan emen ko mahirà ya dawdipinsa la boy mapatalo ko hila. ");
INSERT INTO sbl_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Hay gawgawà nin Diyos ay ayin kapintasan; napaptegan ko ya hay hawhalità na ay ma-asawan. Hiya ya pinagkahalanggà nin kaganawan ampakarani kona ya ampanga-ilangan nin protiksyon na. ");
INSERT INTO sbl_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Ayin kanayon ya Pangino-on no alwan Diyos; hay Diyos ya kowinta malhay ya bato ay ampambin protiksyon kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Diyos ya ampamakhaw kongko, boy hiya ya ampanambay kongko emen hay gawgawà ko ay ahè mapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Banà ta Pangino-on ya ampangalalay kongko, ha pamomowayo ko nin omiwas ha kawka-away ko, hay kawkorang ko ay sigorado nin bilang ha pamomowayo nin oyha palako ha toktok bakil. ");
INSERT INTO sbl_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ansanayen na ko emen ako mag-in handà ha pamakilaban; ambiyan na kon kakhawan emen hay pinakamatyà ya bayì ay magamit ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Hika, Pangino-on, ya pinagkahalanggà ko ya nambi kongkon kalibriyan. Banà ta hika ya nangalalay kongko ay agko napangno, boy nagkama-in akon ka-inomayan ta pinolalagan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ha pamomowako ko ay ayin anan maka-abalà kongko boy ayin anan makapipatombah kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Hapa-eg, kinamat koy kawka-away ko; agko hila tinegnan anggan agko hila na-apò. ");
INSERT INTO sbl_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Banà ha ginawà ko konla ay aghilayna nin maka-ibangon, ta anti hilayna ha hilong kapangyariyan ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Hika, Pangino-on, ya nambi kongko nin kakhawan ha pamakilaban, boy pinahokò mo kongko ya kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Pinapowayo moy kawka-away ko, boy hay ampipag-inakit kongko ay tinalo ko. ");
INSERT INTO sbl_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Hila ay nangingat nin tambay, piro ayin nangilibri konla; nangingat hila simpri ha Pangino-on, piro agna hila tinobay. ");
INSERT INTO sbl_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Banà ta natalo ko hila, hila ay nipampowayon nog-alih nin bilang ha gabok ya in-alipad nin angin; hila ay niyabokyabok ko nin bilang ha pità ha dawdaan. ");
INSERT INTO sbl_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Inlibri mo ko ha kawka-away ko ha panogod la kongko para kalabanen, boy ginawà mo ko nin mamo-on ha nawnasyon ya hay tawtawo bayro ay agko pon balay piro hapa-eg, hila ay angkasakopan koyna. ");
INSERT INTO sbl_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Pamakalengè lan halita-en ko ay honolen la ko; kateng dawdayowan ay ipasakop lay sarili la kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Hay dawdayowan ay nikadiskorahi; kayà lomwah hilan ampipamegpeg ha ginawà lay dipinsa ya pagkobliyan la. ");
INSERT INTO sbl_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Hay Pangino-on ay angkabiyay; hiya ya kowinta malhay ya bato ya protiksyon ko ay poriyen. Hay Diyos ya nangilibri kongko ay parangalan. ");
INSERT INTO sbl_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Hiya ya Diyos ya ampamaweh ha kawka-away ko ha mala-et ya ginawà la kongko, boy hiya ya ampamahokò nin tawtawo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Hiya simpri ya ampangilibri kongko ha kawka-away ko. Hika, Pangino-on, ya nambi kongkon panalo ha kawka-away ko, boy in-atap mo ko ha tawtawoy mapanggolo. ");
INSERT INTO sbl_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Kayà, Pangino-on, hika ay pasalamatan ko nin malengè nin tawtawo ha nawnasyon, boy magkanta ko nin pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Hay Diyos ay nambin masyadoy pananalo ha ginawà nan arì boy impakit nay ingangalo na ya ma-in panlalabi ha pinilì na ya ayin kanayon no alwan hiko ya hi Dabid boy ha aw-inalalak ko anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","(Kanta ni Dabid) Hay langit ay ampangipatnag nin kagandawan nin Diyos, boy bayro angkakit ya gawgawà na. ");
INSERT INTO sbl_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Balang allo ay ma-in kahonoy yabi; maski allo o yabi, hay bawbagay ya anti ha langit ay ampangipatnag nin tawtinandà ya tongkol ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Maski ahè angkalengè baytoy bawbagay ya anti ha langit, boy ahè ampaghalità, ");
INSERT INTO sbl_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","hay kowinta bosis nin habayto ay an-omabot ha kaganawan dogal ha babon lotà, boy hay kowinta anhalita-en nin habayto ay ampi-abot ha ka-anggawan nin babon lotà. Bayro ha langit ay ma-in kama-inan nin allo ya ginawà nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Hay allo ya anhomilà nin mahambak ay bilang ha lalaki ya ikakahal ya maligan anlomwah ha bali na, boy bilang ha makhaw ya lalaki ya handà anan mowayon makilombà. ");
INSERT INTO sbl_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Habayti ya allo ay anhomilà ha baytan no bayombokah boy anhomlep ha babà no anyomabi ana. Ayin ahè makatanam nin amot nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Hay an-ipanogò nin Pangino-on ay ayin kamali-an; habayti ay ampakabayo nin tawo. Hay kaptegan ya an-ipanogò nin Pangino-on ay mapahimala-an, boy habayti ay ampambin tinandà ha tawtawoy kolang ha karonongan. ");
INSERT INTO sbl_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Matoynong ya an-ipanogò nin Pangino-on boy ampakapaligan kanakeman. Hay pawpanogò nin Pangino-on ay ayin kapintasan boy ampambin kalinawan nin pag-i-ihip. ");
INSERT INTO sbl_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Hay panhomamba ya ma-in panggogomalang ha Pangino-on ay mahampat boy manatilin ayin anggawan. Hay pawpanogò nin Pangino-on ay talagan tamà boy makatoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Mas ma-alagà bayti ha gintò maski ha malakè et ya taganas gintò; habayti ay matam-ih et ha polot maski poro et ya polot. ");
INSERT INTO sbl_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Habayti ya pawpanogò ay ampangitorò kongko ya magsisirbi mo emen agko makapagkasalanan, boy habayti ay mambin ikahampat ko no honolen ko. ");
INSERT INTO sbl_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Ma-irap malili-o nin tawo ya sarili nan kamali-an. Kayà no nakagawà ako nin kawkasalanan ya emen kon an-itagò komo ay linisan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Hiko ya magsisirbi mo ay i-atap mo ha panggawà kawkasalanan emen habayto ay ahè makapangyayari kongko. Ha ombayro, hiko ay ahè magkama-in kapintasan ta talagan ayin akon kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Hika, Pangino-on ay kowinta malhay ya bato ya ampambin protiksyon kongko; hika simpri ya nambeh kongko; dayi, hay anhalita-en ko boy annakemen ko ay makapakonsowilo komo. ");
INSERT INTO sbl_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","(Kanta ni Dabid) Tambayan ka dayin Pangino-on ha pana-on nin kagipitan mo, boy hay Diyos ya pinahimala-an ni Hakob ay mangi-atap dayi komo. ");
INSERT INTO sbl_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Dayi, hiya ay mangipagtan komo nin tambay ya mangibat ha kama-inan na ha bakil nin Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Dayi ay panemtemen nay kaganawan nin an-igwà mo kona, boy tanggapen na dayi ya aw-ayop ya ampatyen mon idolog kona. ");
INSERT INTO sbl_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Dayi, hay anhangaren mo ay igwà na komo, boy pangyariyen na dayi ya kaganawan amplanowen mo. ");
INSERT INTO sbl_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","No mangyari bayto, hikayi ay mipambo-angaw nin magtowà boy magligaliga nin mamori ha Diyos banà ha panalo mo. Dayi, kaganawan andawaten mo ay tobayen nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Hapa-eg, tandà ko ya hiko hi Dabid ya arì ya pinilì nin Pangino-on ay pinapanalo na. Hay Diyos ya anti ha katatag-ayan ha masagradoy kama-inan na ay antombay ha pinilì na, boy ha kapangyariyan na ay inlibri na ya. ");
INSERT INTO sbl_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Hay kanayon ya mamakilaban ay ampahimalà ha sarili lan hokaw ha panggamit la nin kawkarwahi; hay kanayon itaman ay ha panggamit nin kawkabayo. Hikayi balè ay ampahimalà ha kapangyariyan nin Pangino-on nawen ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Hatoy ampipampahimalà ha sarili lan kakhawan ay mikatalo; piro hikayi ya ma-in pamahimalà ha Pangino-on nawen Diyos ay manalo boy manatilin mataghen. ");
INSERT INTO sbl_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","No andomawat kayi ha Pangino-on, hikayi ay antobayen na; kayà papanalowen mo dayi, Pangino-on, ya arì nawen. ");
INSERT INTO sbl_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","(Kanta ni Dabid) Pangino-on, hay towà nin arì ta binyan mo yan kakhawan; hiya ay talagan maliga ha pambi mo kona nin pananalo na. ");
INSERT INTO sbl_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Hay anhangaren na ay inggawà mo kona, boy tinobay moy an-awoken na. ");
INSERT INTO sbl_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Pinolalagan mo ya nin mangahampat ya bawbagay, boy ha pananalo na ay kowinta kinoronawan mo ya nin taganas gintò. ");
INSERT INTO sbl_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Hay inawok na komoy biyay ay inggawà mo kona, ta pinakarà moy biyay na boy binyan mo yan biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Hiya ay nagkama-in nin masyadoy karangalan nin banà ha tambay mo kona, boy ha pamomo-on na ay nag-in yan bantog ha inggawà moy karangalan kona. ");
INSERT INTO sbl_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Hay impolalag mo kona ya kahampatan ay anggan makakanoman. Banà ta anti ka kona, hiya ay talagan maliga. ");
INSERT INTO sbl_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Hay arì ay ampahimalà ha Pangino-on; banà ha ingangalo ya ma-in panlalabi nin Pinakamakapangyariyan ya Pangino-on, hay pagka-arì na ay manatilin matibay. ");
INSERT INTO sbl_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Kaganawan ka-away mo, Pangino-on ay talowen mo, boy mapatalo moy kaganawan ampag-inakit komo. ");
INSERT INTO sbl_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","No pangno manirà ya apoy ay ombayro itaman ya panirà mo ha kawka-away mo panlomateng mo. Ha kapahangan mo, Pangino-on, apo-en mo hila nin hay gamiten mo konla ay apoy. ");
INSERT INTO sbl_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Kaganawan inalalak la ay obohen mon patyen. ");
INSERT INTO sbl_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Maski magplano hila nin mala-et ya kontra komo, habayto ay ahè mangyari. ");
INSERT INTO sbl_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Hay kowinta yawò mo ya inhandà mo nin pamanà konla ay nakapatoyò ana konla; kayà hila ay mipampowayon mog-alih. ");
INSERT INTO sbl_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","An-itag-ay nawen ka, Pangino-on, banà ha kakhawan mo. Magkanta kayi boy mamori komo banà ha kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","(Kanta ni Dabid) Diyos ko, Diyos ko, antà pina-olayan mo ko? Antà pinakarayo-an mo ko nin ahè tinambayan ha pandodoma-ing ko komo? ");
INSERT INTO sbl_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Allo yabi ay ayin tegen ya panalangin ko komo, Diyos ko, piro agmo ko antobayen. ");
INSERT INTO sbl_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ombayroman, hika ay Arì ya ayin kapintasan ya amporiyen nin aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Hay kawka-apo-apowan nawen ay napahimalà komo; ha pamahimalà la komo ay inlibri mo hila. ");
INSERT INTO sbl_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Dinoma-ing hila komo boy inlibri mo hila; hila ay napahimalà komo boy aghila napareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Hiko ay antoya-toya-en boy ampag-inakitan nin tawtawo; agla ko an-itoring nin tawo, no alwan hiko ay bilang bongat owel. ");
INSERT INTO sbl_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Kaganawan nin ampakakit kongko ay ampangka-ilin ampanoya-toyà kongko, boy ampampeyeng nin ampangilbit kongko. ");
INSERT INTO sbl_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Hay anhalita-en la ay ombayri: “Ampahimalà ya ha Pangino-on; kayà helken tamo no ilibri ya nin Pangino-on ya ampangonsowilo kona.” ");
INSERT INTO sbl_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Hin in-anak ako boy mintras ampakalhayen ako, hikay nangi-atap kongko. ");
INSERT INTO sbl_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Napahimalà ako komo boy pa-ibat et hin anak ako ay hikayna ya Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Agmo ko dayi pakarayo-an ha kagolowan ya anlomateng kongko ta ayin manambay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Hiko ay napalibotan nin malakè ya ka-away ya bilang tawtoron bakà; hila ay nakapalibot kongko nin bilang ha mangabayani ya toron bakà ha dogal ya an-ingaten Basan. ");
INSERT INTO sbl_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Hila ay bilang ha ampan-aglem ya lawliyon ya nakangangan mangnga-ngà kongko. ");
INSERT INTO sbl_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Hay kakhawan ko ay na-alih kongko nin bilang ha nabollog ya lanom, boy hay tanam ko ha bawbot-o ko ay emen nangapihihiyay; kayà hay wenek ko. Hay tanam ko ha posò ko ay emen angkatonaw banà ha kalele-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Hay kakhawan ko ay bilang tanan pehà keren ya maparan mangabibi-hil, boy hay dilà ko ay dinomtayna ha ngalo ko; kayà marani koyna ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Hay tawtawoy mangala-et ay nakapalibot kongko nin bilang ha aw-ahoy mangabayani. Hay gawgamet ko boy bawbitih ko ay nilobtan la. ");
INSERT INTO sbl_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Hay bawbot-o ko ay mapatnag ana, boy hay kawka-away ko ay ampamakategteg kongko. ");
INSERT INTO sbl_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Pini-a-atagan lay dolo ko boy pinibobonotan la baytoy dolo koy makarà. ");
INSERT INTO sbl_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Pangino-on, agmo ko pakarayo-an; hika ya ampamakhaw kongko, manandalì kan pakarani kongko ta tambayan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Ilibri mo ko ha hondang ya ma-arì lan gamiten nin pamati kongko, boy ilibri mo ko ha kawka-away ya bilang nin mangabayani ya aw-aho. ");
INSERT INTO sbl_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Ilibri mo ko simpri ha kawka-away ya bilang ha lawliyon ya mangabayani. Tinobay mo ko hin hato, boy inlibri mo ko ha kowinta panowag kongko nin tawtoron bakà ya balang. ");
INSERT INTO sbl_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ibabalità ko ha kapara kon tawo ya ginawà mo, boy hika ay poriyen ko ha arapan nin tawtawoy mititipon. ");
INSERT INTO sbl_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","“Poriyen moyoy Pangino-on, hikawoy ampipanggomalang kona. Kaganawan moyon alalak ni Hakob ay mamarangal ha Pangino-on; talagan dapat kawon homamba kona, hikawoy kaganawan alalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Hay Pangino-on ay ahè ampama-olay ha aw-apih ha andanasen lay kadya-dya-an; agna hila anhalibokotan, no alwan antobayen na hila ha an-ida-ing la kona.” ");
INSERT INTO sbl_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Ha pamititipon nin kaganawan, hika ay poriyen ko banà ha ginawà mo. Bayro ha arapan nin hatoy nititipon ya ampipanggomalang komo ay toparen koy impangakò ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Hay aw-apih ay magpasasà ha pamamangan; hay ampikahabek ha Pangino-on ay mamori kona, boy dayi, hay nakem la ay magkama-in nin ayin anggay kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Kaganawan tawo ha nawnasyon ha kaganawan parti nin babon lotà ay makapanemtem nin pakarani ha Pangino-on boy homamba kona. ");
INSERT INTO sbl_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Hay Pangino-on ay Arì boy hiya ya ampamo-on ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Kaganawan tawoy mangama-in kamatyan ya bilang mangahambog, aw-apih, boy mangakapey ana ay yomokò nin homamba ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Hay kasalokoyan lipì ay magsirbi kona boy mangibalità ha homonoy lipì nin tongkol ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Hila simpri ya mangibalità nin tongkol ha kahampatan nin Pangino-on ha tawtawoy ahè et in-anak, ta kaganawan nin habayti ay gawà nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","(Kanta ni Dabid) Hay Pangino-on ay bilang ha pastol ya ampangasiwà kongko; kayà kaganawan angka-ilanganen ko ay an-igwà na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Hiko ay kowinta anggitan nan ipastol boy ipa-inawa ha kowinta pagpastolan ya ma-in hariwà ya dikot; anggitan na ko et ha kowinta ma-in maganday lanom. ");
INSERT INTO sbl_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ambiyan na kon bayoy kakhawan, boy an-itoto na ko ha tamà ya daan emen ako mag-in mahampat; ha ombayro, hay ngalan na ay maparangalan. ");
INSERT INTO sbl_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Maski hay pagdanan ko ay mareglem ya bilang ha kamatyan ay agko angkalimo ta hika, Pangino-on, ya kalamo ko! Hay kowinta baston mo boy kowinta garoti mo ay ampangitoto kongko boy ampambin dipinsa kongko; kayà maliga ko. ");
INSERT INTO sbl_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Angkakit nin kawka-away ko ya pawpanganga-ilangan koy an-igwà mo kongko. Hay olo ko ay kowinta pinonahan mo nin asiti ha katowa-an mon nananggap kongko. Talagan agko ampagkakolang ha pawpanganga-ilangan ko. ");
INSERT INTO sbl_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Kayà angkasigoro ko ya hay kahampatan mo boy panlalabi mo ay anti kongko nin leleg biyay ko, boy hiko ay anti komo anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","(Kanta ni Dabid) Hay babon lotà kateng kaganawan anti bayri ay ikon nin Pangino-on; talagan hiya ya ma-in ikon nin babon lotà kateng ampipampa-iri bayri. ");
INSERT INTO sbl_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Habayti ya babon lotà ay pinalwa na nin nangibat ha lalè nin lawlanom, ta habayti ay impondasyon na ha lalè nin dawdagat. ");
INSERT INTO sbl_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Hinoy karapatdapat mako ha bakil nin Pangino-on, boy hinoy karapatdapat nin lomo-ob ha masagradoy dogal na? ");
INSERT INTO sbl_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Hay karapatdapat bayro ay tawoy mahampat ya gawgawà, malinis ya pagnanakem, ahè anhomamba ha alwan peteg diyos, boy ahè ampangipilit nin hay malì ay tamà. ");
INSERT INTO sbl_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Hay tawoy ombayro ay makatanggap nin kahampatan ya mangibat ha Pangino-on, boy halita-en nin Diyos ya Mapangilibri ya habaytoy tawo ay ayin ginawà ya mala-et. ");
INSERT INTO sbl_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Hay ombayroy tawtawo ay angkahabek ha Diyos ya pinahimala-an ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Hay polta nin paghambawan ay pakalo-atan emen hay Arì ya ahè mapantayan ay pomahok. ");
INSERT INTO sbl_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Hino bayti ya Arì ya ahè mapantayan? Hiya ay Pangino-on ya makhaw boy makapangyariyan; hiya ay Pangino-on ya makapangyariyan ha labanan. ");
INSERT INTO sbl_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Hay polta nin paghambawan ay pakalo-atan emen hay Arì ya ahè mapantayan ay pomahok. ");
INSERT INTO sbl_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Hino bayti ya Arì ya ahè mapantayan? Hiya ya Pangino-on ya ampama-alà ha kaganawan; hiya ya Arì ya ahè mapantayan. ");
INSERT INTO sbl_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","(Kanta ni Dabid) Pangino-on, ampanalangin ako komo; ");
INSERT INTO sbl_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","ampahimalà ako komo, Diyos ko; kayà agmo dayi payagan nin hiko ay mareng-eyan nin talowen nin kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Hay ampipampahimalà komo ay ahè mipareng-ey, piro hay ampipangkomontra komo ay mipareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Itorò mo kongko ya kalabayan mo, Pangino-on, boy ipatandà mo kongko ya dapat kon gaw-en. ");
INSERT INTO sbl_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Allo-allo ay hika ya ampahimala-an ko nin mangilibri kongko; kayà itorò mo dayi kongko no pangno ko mamiyay nin kompormi ha kaptegan nin Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Pangino-on, panemtemen moy kahampatan mo boy ingangalo moy ma-in panlalabi ya impakit mo kongko pa-ibat hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Banà ha kahampatan mo boy ha ingangalo moy ma-in panlalabi ay panemtemen mo ko dayi, Pangino-on. Patawaren moy kawkasalanan ko boy kawkamali-an ya nagawà ko hin malagò ako et. ");
INSERT INTO sbl_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Hay Pangino-on ay mahampat boy tapat; kayà an-itoto nay mawmakasalanan ha tamà ya pamamaraan emen hila malibri ha kawkasalanan la. ");
INSERT INTO sbl_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Hay tawtawoy manga-aypà ya nakem ay an-itoto na ha tamà ya pamamaraan boy an-itorò na konla ya kalabayan na. ");
INSERT INTO sbl_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Kaganawan anhomonol ha kasondo-an nin Pangino-on boy ha an-ipanogò na ay an-itoto nan ma-in panlalabi boy ma-in katapatan. ");
INSERT INTO sbl_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Maski malakè ya nagawà koy kasalanan ay patawaren mo ko dayi, Pangino-on, emen hay ngalan mo ay maparangalan. ");
INSERT INTO sbl_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Hay tawoy anggomalang ha Pangino-on ay angkatotowan nay tamà ya pamamaraan ha biyay. ");
INSERT INTO sbl_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Hay ombayroy tawo ay mag-inomay boy hay aw-inalalak na ay mamiyay nin ma-in katinekan bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Hay Pangino-on ay ampaki-amigo ha tawtawoy anggomalang kona; an-itorò na konla ya kasondo-an na. ");
INSERT INTO sbl_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Hay pirmi kon an-asawan nin manambay kongko ay Pangino-on, ta hiya ya ampangilibri kongko no hiko ay ampamiligro. ");
INSERT INTO sbl_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Pangino-on, asikasowen mo ko boy ingalowan, ta hiko ay ayin kalamo boy apih ako. ");
INSERT INTO sbl_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Hay kagolowan nin nakem ko ay angkapahanan. Habayti ay alihen mo dayi kongko. ");
INSERT INTO sbl_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Asikasowen moy pagka-apih ko boy kadya-dya-an ya andanasen ko, boy patawaren mo dayi ya kaganawan kasalanan ko. ");
INSERT INTO sbl_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Helken moy kawka-away ko ya kapanlolomakè; hiko ay masyado lan angka-inakitan. ");
INSERT INTO sbl_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","I-atap mo ko, Pangino-on, boy ilibri. Agmo ko pa-olayan nin mipareng-ey ta hika ya ampahimala-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ipakit mo dayi ya kahampatan mo boy katapatan mo ha pangi-atap mo kongko, ta hika ya an-asawan ko. ");
INSERT INTO sbl_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Pangino-on kon Diyos, ilibri moy tawtawo mo ha kaganawan ka-irapan ya andanasen la. ");
INSERT INTO sbl_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","(Kanta ni Dabid) Pangino-on, paptegan mo ya hiko ay ayin ginawà ya mala-et ta hiko ay talagan ampahimalà komo; agko ampagtagaloway nakem. ");
INSERT INTO sbl_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Sori-en mo ko, Pangino-on, boy hoboken; pakahehelken moy pangingihip ko boy nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Hay ingangalo mo ya ma-in panlalabi ay angkahabekan ko, boy talagan labay kon mag-in tapat komo. ");
INSERT INTO sbl_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Agko ampakilamo ha tawtawoy manloloko ni ha mawmagkakanwarì. ");
INSERT INTO sbl_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Angka-inakit ako ha gropon tawtawoy ampagplanon manggawà kala-etan, boy agko labay makilamo konla. ");
INSERT INTO sbl_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Pangino-on, oyahan koy gamet ko bilang tandà nin hiko ay ayin ginawà ya kasalanan, biha ko liboten ya altar mo ha panhohomamba ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Mintras anliboten ko bayti ay magkanta ko nin pasasalamat komo, boy kaganawan ginawà moy kapapa-ispanta ay ibabalità ko. ");
INSERT INTO sbl_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Pangino-on, labaylabay koy paghambawan komo ya kama-inan mo ta anti bayroy kagandawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Agmo ko ilamo ha kaparosawan nin mawmakasalanan; agmo ko simpri ilamo ha kaparosawan nin mawmapamatin tawo ");
INSERT INTO sbl_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","ya pirmin ampanggawà kala-etan boy pirmin nakahandà para pasohol. ");
INSERT INTO sbl_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Hiko ay ayin ginawà ya ombayro ha ginawà la; kayà ilibri mo ko boy ingalowan. ");
INSERT INTO sbl_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Ha tambay nin Pangino-on, hiko ay libri ha pawpangyayari ya alwan maganda; ha pamititipon nin kalak-an, hiko ay mamori ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","(Kanta ni Dabid) Pangino-on ya ampambin hawang kongko boy ampangilibri kongko ha kawka-away ko; kayà agko angkalimo. Hay ampambin dipinsa kongko ay kakhawan nin Pangino-on; kayà agko angkalimo. ");
INSERT INTO sbl_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","No hay mangala-et ya tawtawoy kawka-away ko ay mangalaban kongko ta labay la kon patyen, habaytoy labay lan gaw-en ay ahè mitoloy ta hila ay mikatombah. ");
INSERT INTO sbl_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Maski pagkalalakè hondalò ya mangalaban kongko ay agko malimo, boy maski kalabanen ako nin kawka-away ko ay pahimalà ako simpri ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Mihay bagay bongat ya labay kon dawaten ha Pangino-on: hay labay ko dayi, leleg biyay ko, ha pamakilamo ko kona, hiko ay kowinta pirmiyan nin anti ha bali na ya paghambawan kona emen ko makit ya kagandawan na, boy bayro ko nin lalò ma-intindiyan ya tongkol kona. ");
INSERT INTO sbl_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ha pana-on nin kagolowan, hiko ay i-atap nin Pangino-on do ha kama-inan na, ta bayro ay ma-in dogal ya agko mapangno. Bayro na ko i-atap ta bayro ay ma-in kowinta matag-ay ya bato ya pangigwa-an na kongko. Ha babo nin habaytoy bato ay bayro na ko igwà emen na ko ma-i-atap ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Banà bayri, hay kawka-away koy nakapalibot kongko ay talowen ko. Do ha kama-inan nin Pangino-on ay mangidolog ako boy mambo-angaw ha katowa-an ko. Magkanta koynan magkanta nin pamomori ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Pangino-on, leng-en moy an-ipakirawat ko komo; ingalowan mo ko boy tobayen moy andawaten ko. ");
INSERT INTO sbl_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Hinalità moy pakarani ko komo; kayà ampakarani ko komo, Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Agmo ko dayi pakarayo-an. Hiko ya magsisirbi mo ay agmo dayi pamahangan nin pa-alihen. Hika ya ampanambay kongko; kayà agmo ko dayi alihan boy pa-olayan, ta hika ya Diyos ko ya mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","No warì ta pa-olayan ako nin tatay ko boy nanay ko, hika, Pangino-on ya mangandep kongko. ");
INSERT INTO sbl_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Pangino-on, itorò mo ko ha dapat kon gaw-en; itoto mo ko dayi ha tamà ya pamamaraan ta malakè ya ka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Agmo ko pa-olayan ha kawka-away ko, ta hiko ay ambara-an lan nanggawà nin alwan tamà, boy ampagplano hila no pangno la ko pakakhitan. ");
INSERT INTO sbl_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Angkasigoro ko ya mintras angkabiyay ako ay makit koy kahampatan nin Pangino-on ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Pahimalà ha Pangino-on; magkama-in hokaw nakem; talagan pahimalà ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","(Kanta ni Dabid) Andoma-ing ako komo, Pangino-on, ya kowinta malhay ya bato ya ampambin protiksyon kongko. Leng-en moy an-ida-ing ko, ta no agmo ko leng-en ay mag-in akon kabilang ha anti ana ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Leng-en moy an-ida-ing ko komoy tambay. Ha pandodoma-ing ko komo ha pinakamasagradoy kama-inan mo ay an-itag-ay koy gamet ko ha pamaki-i-ingalo ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Agmo ko dayi ipakilamo ha kaparosawan nin tawtawoy ampanggawà kala-etan; hila bayti ay ampagkakanwarì nin ampaghalità nin ma-in kahampatan, piro hay anti ha nakem la ay kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Parosawan mo hila ha ginawà lay kala-etan; parosawan mo hila nin kompormi ha ginawà la. ");
INSERT INTO sbl_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Hay pawpinalsa nin Pangino-on boy bawbagay ya ginawà na ay agla ampa-alaga-an; kayà parosawan na hilan pa-anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Poriyen ya Pangino-on ta nilengè nay inda-ing ko konay tambay. ");
INSERT INTO sbl_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Pangino-on ya ampamakhaw kongko boy hiya ya pinagkahalanggà ko; ampahimalà ako kona boy antambayan na ko. Kayà hay nakem ko ay angkatowà boy magkanta ko nin pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Pangino-on ya ampamakhaw ha tawtawo na; hiya ya ampangidipinsa boy ampangilibri nin arì ya pinilì na. ");
INSERT INTO sbl_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Pangino-on, ilibri moy tawtawo mo boy biyan mo hilan kahampatan; mag-in kan bilang pastol la boy hika ya mangasiwà konla nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","(Kanta ni Dabid) Poriyen moyoy Pangino-on, hikawoy aw-anghil na; poriyen moyo ya banà ha kagandawan na boy kakhawan na. ");
INSERT INTO sbl_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Igwà moyo ha Pangino-on ya pamomori ya nararapat ha ngalan na; hambawen moyoy Pangino-on ta hiya ay ma-in kagandawan ya ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Hay bosis nin Pangino-on ya bilang ha korol ay angkalengè maski ha dagat; hay Diyos ya ma-in kagandawan ya anti ha dagat, hay bosis na ya bilang ha korol ay angkalengè ha maski ayrin parti nin dagat. ");
INSERT INTO sbl_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Hay bosis nin Pangino-on ya bilang ha korol ay ma-in kakhawan boy ma-in kapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Hay bosis nin Pangino-on ya bilang ha korol ay ampakahirà nin pawpo-on kayo maski et nin matibay ya pawpo-on kayoy an-ingaten sidro ha nasyon Libanon. ");
INSERT INTO sbl_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Banà ha bosis nin Pangino-on ya bilang ha korol, hay bawbakil nin Libanon ay emen ampitatakompaw nin bilang ha oybon bakà, boy hay bakil ya an-ingaten Hirmon ay emen ampagtakompaw nin bilang ha malagò ya toron bakà. ");
INSERT INTO sbl_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Hay bosis nin Pangino-on ya bilang ha korol ay ampangibatan nin kilat ya ma-in lamo ya apoy ya ampakab-in hawang. ");
INSERT INTO sbl_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Hay bosis nin Pangino-on ya bilang ha korol ay ampaka-eyeg nin pawpowiray dogal kateng dogal ya an-ingaten Kadis. ");
INSERT INTO sbl_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Hay bosis nin Pangino-on ya bilang ha korol ay ampakapa-anak nin maboktot ya oyha nin ayin ha oras, boy ampakalagah nin bawbolong kayo. Kaganawan anti ha kama-inan nin Diyos ay ampaghalità nin, “Poriyen ya Diyos!” ");
INSERT INTO sbl_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Hin nagkama-in nin malhay ya lanab ay Pangino-on ya namo-on, boy hiya ya Arì ya ayin anggay pamomo-on. ");
INSERT INTO sbl_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Hay Pangino-on ay ampambin hokaw ha tawtawo na, boy hiya ya ampambin katinekan konla. ");
INSERT INTO sbl_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","(Kanta ni Dabid) Pangino-on, amporiyen kata ha pangilibri mo kongko boy banà ta agmo pinayagan nin talowen ako nin kawka-away ko. Ha ombayro ay aghila magtowà nin mangalgal kongko. ");
INSERT INTO sbl_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Pangino-on kon Diyos, dinoma-ing ako komo nin tambayan mo ko; kayà pinakahampat mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Hiko ay malagayna mako ha dogal nin nikati, piro pinakahampat mo ko et ta pinanatili mo kon angkabiyay. ");
INSERT INTO sbl_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Hikawoy nag-in tawtawo nin Diyos, magkanta kawon pamomori ha Pangino-on, boy magpasalamat kawo ha pamamanemtem moyo kona ya ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Hay pahang nin Pangino-on ay kadodomalì bongat, piro hay kahampatan na ay ayin angga. No ma-in man anlomateng ya kalele-an ay ma-in tampol homagili ya kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Hin nakatanam akon ka-inomayan ay ombayri ya hinalità ko ha sarili ko, “Manatili akon matibay.” ");
INSERT INTO sbl_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Mahampat ka kongko, Pangino-on, ta in-atap mo ko boy ginawà mo kon mataghen nin bilang kataghen bakil. Piro hin pina-olayan mo ko ay nakatanam akon kalimowan. ");
INSERT INTO sbl_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Hiko ay dinoma-ing komo, Pangino-on, nin tambayan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Anyay mapakinabang mo kongko no mati koyna? Warì hay nati ay makapori komo, o ma-ibabalità nay katapatan mo? ");
INSERT INTO sbl_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Pangino-on, leng-en mo ko boy ingalowan. Tambayan mo ko dayi, Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Hay kalele-an ko ay pinahiliyan mo nin kaligawan; kayà hiko ay antomalek ha katowa-an ko; inalih moy kalele-an ko ta pinahiliyan mon kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Kayà agko ma-arì nin ahè magkanta nin pamomori komo. Pangino-on kon Diyos, ayin anggay pasasalamat ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","(Kanta ni Dabid) Pangino-on, ampahimalà ako nin hiko ay protiksyonan mo; kayà maski makano ay agmo payagan nin hiko ay mareng-eyan nin banà ha pamahimalà ko komo. Hika ya ma-in kahampatan ay mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Leng-en mo ko boy tampol mo kon ilibri; hika ya kowinta malhay ya bato ya mambin protiksyon boy mangidipinsa kongko emen ako malibri. ");
INSERT INTO sbl_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Banà ta hika ya kowinta malhay ya bato ya ampambin protiksyon boy ampangidipinsa kongko ay itoto mo ko boy alalayan mo ko alang-alang ha ngalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ilibri mo ko ha kowinta papandakep kongko ya ingkanà nin kawka-away ko ta hika ya ampambin protiksyon kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","An-ipahimalà ko komo ya ispirito ko; hika ya nangilibri kongko, Pangino-on, ta hika ya Diyos ya tapat ha pangakò. ");
INSERT INTO sbl_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Angka-inakitan moy ampipanhomamba ha alwan peteg diyos, piro hiko ay ampahimalà komo, Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Hiko ay lomiga boy matowà ha ingangalo moy ma-in panlalabi, ta angka-asikaso moy kadya-dya-an ya andanasen ko boy tandà moy angkagolowan ko. ");
INSERT INTO sbl_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Agmo pinayagan nin hiko ay marakep nin kawka-away ko, no alwan an-i-atap mo ko boy pinalayà. ");
INSERT INTO sbl_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Ingalowan mo ko, Pangino-on, ta hiko ay anti ha kagipitan. Hay mata ko ay angkabayà ana ha panangih ko; hiko ay ma-in kalele-an boy talagan makapey ana. ");
INSERT INTO sbl_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Hay biyay ko ay ampa-ipeken nin kalele-an ko boy pan-agol ko. Hiko ay makapey ana banà ha kawkasalanan ko, boy hay tanam ko ha bawbot-o ko ay emen anan ampangapihihiyay. ");
INSERT INTO sbl_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Kaganawan ka-away ko kateng kawkarani ko ay ampangka-ili nin ampanoya-toyà kongko. Hay kawkabalay ko ay ahè labay manegteg kongko; no angkakit la ko ha daan ay ampipampowayo hilan pakarayò kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Hiko ay niliwawan layna nin bilang ha nati, boy emen akon bongat ha pehà keren ya ayin alagà. ");
INSERT INTO sbl_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Angkalengè koy pawpaninirà kongko nin malakè ya ka-away ko; hila ay ampagplano nin kontra kongko boy antangka-en la kon patyen. Hay kakalimowan ay nakapalibot kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Piro ampahimalà ako komo, Pangino-on; kayà hinalità ko ya ombayri: “Hika ya Diyos ko.” ");
INSERT INTO sbl_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Hika ya ma-in oligtan nin biyay ko; ilibri mo ko ha kawka-away ko, boy ha tawtawoy labay mamadya-dyà kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Hiko ya magsisirbi mo ay pakitan mo dayi nin kahampatan mo. Banà ha ingangalo moy ma-in panlalabi ay ilibri mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Pangino-on, banà ta andoma-ing ako komo ay agmo dayi payagan nin mareng-eyan ako. Balè hay mawmangala-et, dayi ay mareng-eyan; dayi, hila ay mikati emen hila ay matanà ana ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Hay mangabongkok ay pategenen mo dayi ha paghalità la nin kawkabongkokan; hila bayti ya ampipagmalhay ay ampipandodostà boy ampipaghalità nin kontra ha tawtawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Hay kahampatan mo ya ahè makwan ihipen ay intalakà mo ha tawtawoy ma-in panggogomalang komo; angkakit nin tawtawo bayti ya anggaw-en moy pangilibri nin ampipampahimalà komo. ");
INSERT INTO sbl_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Hila ay an-i-atap mo ta anti ka konla; kayà aghila mapangno ha tawtangkà konla nin tawtawo. Ha kama-inan mo ay bayro mo hila an-i-atap emen aghila yamo-yamo-en nin paghalita-an nin kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Poriyen ya Pangino-on, ta impakit na kongko ya ahè makwan ihipen ya ingangalo nay ma-in panlalabi ta kowinta inggawà na ko ha mapowirsay siyodad ha pangi-atap na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Hiko ay nalimo ta andap ko no agmo koyna payagan pakarani komo, piro hay inda-ing ko komoy tambay ay nilengè mo. ");
INSERT INTO sbl_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Hikawo ya nag-in tawtawo nin Diyos, labiyen moyoy Pangino-on! An-i-atap nin Pangino-on ya tawtawoy tapat; hay mangahambog balè ay mahigpit nan amparosawan. ");
INSERT INTO sbl_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Kaganawan moyon an-omasa ha Pangino-on, hokawen moyoy nakem moyo ta tambayan na kawo. ");
INSERT INTO sbl_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","(Kanta ni Dabid ya pakapowotan aral) Makalmà ya tawoy pinatawad ana ha kawkasalanan nay panhohomombalang ha Diyos; ta hay kawkasalanan na ay nilinisan ana. ");
INSERT INTO sbl_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Makalmà ya tawo ya hay kasalanan na ay pinatawad ana, ta hiya ay imbilang nin Pangino-on nin ayin kasalanan. Hay ombayroy tawo ay ahè ampagkakanwarì. ");
INSERT INTO sbl_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Hin agko et na-ipakikwan tawad ya kawkasalanan ko, hay tanam ko ha bawbot-o ko ay emen anan ampangapihihiyay ta angka-alihan akon hokaw. Ombayroy nangyari ta ayin tegen ya panangih ko. ");
INSERT INTO sbl_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Allo yabi ay ampakatanam ako nin kowinta mabyat ya parosa mo, Pangino-on. Hay kakhawan ko ay na-alih ana nin bilang ha deyang ya napaklang nin amot allo no ka-ingitan. ");
INSERT INTO sbl_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Hapa-eg ay intapat ko komo ya kawkasalanan ko; ayin akon intagò komo ya gawgawà koy alwan tamà. Nagdisisyon akon ipakikwan tawad komo ya kaganawan kasalanan ko ha panhohomombalang ko komo; habayti ay pinatawad mo. ");
INSERT INTO sbl_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Kayà balang miha ya angkahabek komo, Pangino-on ay manalangin komo emen mo ma-ingalowan. Ha ombayro, ma-in man lomateng ya malhay ya lanab ya kowinta panonosga, hila ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Hiko ay ahè mapangno ta anti ka kongko ya ampangi-atap kongko ha kagolowan; banà bayri ay makalengè ako ha mamalibot ko nin kalamo kon ampagkantan makhaw ha pangilibri mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Hinalità nin Pangino-on, “Hiko ya mangitoto boy mangitorò komo ha dapat mon gaw-en; wawaliyan kata boy pirmi katan imatonan. ");
INSERT INTO sbl_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Agka manowad ha kabayo, lalò ha kabayoy mola ya ahè ampaka-intindi boy ka-ilangan et rindawan biha mapahonol.” ");
INSERT INTO sbl_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Malakè ya kalele-an ya lomateng ha tawtawoy mangala-et, piro hay tawtawoy ampahimalà ha Pangino-on ay pirmin makaranas nin ingangaloy ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Hikawoy mangama-in kahampatan ay magtowà boy magpakaliga ha Pangino-on; banà ta leseb ya nakem moyo ha Pangino-on, kaganawan moyo ay mambo-angaw ha pagtowà moyo. ");
INSERT INTO sbl_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Hikawoy mangama-in kahampatan, magtowà kawo ha Pangino-on; nararapat kawon mamori kona, hikawoy leseb ya nakem ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Hay Pangino-on ay poriyen moyo ha panogtog moyo nin alpa, boy magkanta kawon pamomori kona ya kompanyawan moyon istrominto ya di kowirdas. ");
INSERT INTO sbl_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Kantawan moyo ya nin kinomposo ya bayoy kanta, pakahampaten moyoy panogtog moyo, boy magkanta kawo nin ma-in katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Hay halità nin Pangino-on ay talagan peteg, boy kaganawan gawà na ay mapahimala-an. ");
INSERT INTO sbl_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Labaylabay nin Pangino-on ya gawgawà ya mahampat boy matoynong; hay ingangalo nin Pangino-on ya ma-in panlalabi ay an-ipakit na ha maski ayrin dogal bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Hay langit ay pinalsa nin Pangino-on ha halità nan bongat; ombayro simpri ha bawbito-en. ");
INSERT INTO sbl_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Hay lawlanom itaman ay tinipon na ha ginawà nay malalè ya dogal ya an-ingaten dagat; hay lawlanom ay kowinta inlimpeh na bayro ha pinangitiponan na. ");
INSERT INTO sbl_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Dayi, kaganawan tawo bayri ha babon lotà ay gomalang boy homamba ha Pangino-on, ");
INSERT INTO sbl_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","ta hin hinalità na ya magkama-in nin babon lotà ay nangyari boy kaganawan bagay ay nilomwah. ");
INSERT INTO sbl_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Hay pawplano nin tawtawoy ahè antompel ha Diyos ay anhira-en nin Pangino-on; agna ampayagan nin mitoloy ya pawplano la no habayto ay alwan kompormi ha kalabayan na. ");
INSERT INTO sbl_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Piro hay pawplano nin Pangino-on ay talagan mangyari anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Makalmà ya tawtawo ha mihay nasyon ya hay Diyos la ay Pangino-on; makalmà hila ta hila ay pinilì nin Pangino-on nin pag-ikon na. ");
INSERT INTO sbl_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Hay Pangino-on ya anti ha katatag-ayan ha kama-inan na ay ampanlonglong; kayà angkakit nay kaganawan tawo. ");
INSERT INTO sbl_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Bayro ha kama-inan na ay anlonglongan nay kaganawan tawo bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Kona ampangibat ya nakem la; kayà tandà nay kaganawan nin anggaw-en la. ");
INSERT INTO sbl_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ayin arì ya ampanalo nin banà ha kalak-an hondalò na; ayin simprin hondalò ya ampanalo nin banà ha kakhawan na. ");
INSERT INTO sbl_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Hay kabayo ya anggamiten ha gira ay ahè ma-asawan nin makapipanalo, boy hay kakhawan nin habayti ay ahè makapilibri. ");
INSERT INTO sbl_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Balè hay tawtawoy anggomalang ha Pangino-on ay an-asikasowen nan i-atap, ta ampahimalà hila ha ingangalo nay ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","An-ilibri na hila ha kamatyan, ta maski pana-on nin bitil ay ambiyan na hila nin ikabiyay la. ");
INSERT INTO sbl_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","An-omasa kayi ha Pangino-on nin tambayan na kayi boy hiya ya pinagkahalanggà nawen. ");
INSERT INTO sbl_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Hay nakem nawen ay maliga kona ta hikayi ay ma-in pamahimalà ha ayin kapintasan ya ngalan na. ");
INSERT INTO sbl_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Igwà mo dayi konnawen, Pangino-on, ya ingangalo moy ma-in panlalabi nin kompormi ha an-asawan nawen komo. ");
INSERT INTO sbl_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","(Kanta ni Dabid) Hay Pangino-on ay pirmi kon pasalamatan, boy hiya ay ayin tegen kon poriyen. ");
INSERT INTO sbl_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Amparangalan koy Pangino-on ha gawgawà na; dayi, hay aw-apih ya makatandà nin habayti ay magtowà. ");
INSERT INTO sbl_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Makilamo kawo kongko nin mamori ha Pangino-on; dayi ay milalamo tamon mangitag-ay nin ngalan na. ");
INSERT INTO sbl_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Hin nanalangin akon nakirawat nin tambay ha Pangino-on ay nilengè na ko, boy inlibri na ko ha kaganawan angkalimowan ko. ");
INSERT INTO sbl_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Hay inomasa kona ay nilomiga; hila ay agana mareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Hiko ya ayin pag-asa ay dinoma-ing ha Pangino-on boy nilengè na ko; inlibri na ko ha kaganawan angkagolowan ko. ");
INSERT INTO sbl_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Hay anghil ya inhogò nin Pangino-on ay ampagbantay ha ampipanggomalang ha Pangino-on, boy an-ilibri na hila ha kawkapiligrowan. ");
INSERT INTO sbl_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Hoboken moyoy kahampatan nin Pangino-on; makalmà ya tawoy ma-in pamahimalà ha Pangino-on nin hiya ay ilibri na. ");
INSERT INTO sbl_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Igalang moyoy Pangino-on, hikawoy nag-in tawtawo nin Diyos, ta hay ampipanggomalang kona ay ampagkama-in nin pawpanganga-ilangan la. ");
INSERT INTO sbl_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Hay aw-oybon liyon ay ampagkakolang boy angkabitlan, piro hay angkahabek ha Pangino-on ay ahè ampagkakolang ha bawbagay ya mangaganda ya ikahampat la. ");
INSERT INTO sbl_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Hikawoy aw-anak, pakarani kawo kongko ta toro-an katawon gomalang ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Labay moyo nayì nin lomawig ya biyay moyo emen kawo maganawan nin maboyot ha mangaganday bagay? ");
INSERT INTO sbl_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","No ombayro ay tonggen kawon maghalità nin kala-etan boy kawkabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Halibokotan moyoy panggawà kala-etan ta hay gaw-en moyo ay kahampatan, boy lalò moyon pagsikapan nin magkama-in katinekan. ");
INSERT INTO sbl_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Hay tawtawoy mangahampat ay an-asikasowen nin Pangino-on, boy anleng-en nay dawda-ing la. ");
INSERT INTO sbl_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Hay tawtawo balè ya ampipanggawà nin kala-etan ay hosgawan nin Pangino-on emen ayin anan mamanemtem konla bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Hay da-ing nin tawtawoy mangahampat ay anleng-en nin Pangino-on, boy an-ilibri na hila ha kaganawan kagolowan la. ");
INSERT INTO sbl_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Hay Pangino-on ay maheneh boy ampanambay ha angkahirà ya nakem, boy an-ilibri nay ayin anan pag-asa. ");
INSERT INTO sbl_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Hay tawoy mahampat, maski ampagdanas nin malakè ya kagolowan ay an-ilibri nin Pangino-on ha kaganawan kagolowan ya ampangyari kona. ");
INSERT INTO sbl_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Hiya ay talagan an-i-atap nin Pangino-on; kayà ni mihay bot-o na ay ayin nabalì. ");
INSERT INTO sbl_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Hay mangala-et ay angkati nin banà ha panggawà lan kala-etan; hay ampipag-inakit ha mangahampat ay parosawan. ");
INSERT INTO sbl_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","An-ilibri nin Pangino-on ya ampipagsirbi kona, boy hay ampakarani konan pakopkop ay agna parosawan. ");
INSERT INTO sbl_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","(Kanta ni Dabid) Pangino-on, kontrawen mo ya ampipangkomontra kongko; labanan moy ampipangalaban kongko. ");
INSERT INTO sbl_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Gamiten moy kowinta hawhalanggà mo ta tambayan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Gawi-en moy kowinta pikà mo boy kowinta payakol ya anggamiten makigira, ta harangen moy ampipangamat kongko, boy halita-en mo kongko ya hika ya mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Hay ampipagsikap mamati kongko ay matalo dayi boy mipareng-ey. Hay ampipagplanon mala-et ya kontra kongko ay magbira dayin ampikalito. ");
INSERT INTO sbl_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Dayi ay mag-in hila nin bilang ha apah ya ampi-alipad nin angin mintras angkalimoten hilan ipakarayò nin anghil ya inhogò nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Hay andanan la ay mag-in dayin mareglem boy marawonot mintras angkalimoten hila nin anghil nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Maski ayin bara-nan, hila ay nangikanà nin bateng ya pandakep la kongko, boy nangotkot hilan malalè ya lobot ya pakarabo-an ko emen la ko marakep. ");
INSERT INTO sbl_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Dayi, ha agla an-asawan ay lomateng konla ya kadisgrasyawan. Dayi, hay bateng ya ingkanà la ay hilan mismo ya mahagep boy hilan mismo dayi ya marabò ha lobot ya kinotkot la. ");
INSERT INTO sbl_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Hapa-eg hiko ay magtowà ha Pangino-on boy magkama-in akon kaligawan ta inlibri na ko. ");
INSERT INTO sbl_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Ombayri ya halita-en ko ha Pangino-on nin leseb ha nakem ko: “Ayin makapantay komo, Pangino-on. An-ilibri moy aw-apih ha mangakhaw ya ampipangapih konla; ombayro simpri ha ampipanga-ilangan.” ");
INSERT INTO sbl_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Hay tawtawoy mangala-et ay ampanistigos nin kontra kongko; ambinggawan la ko nin bawbagay ya agko tandà. ");
INSERT INTO sbl_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Hay ginawà ko konlay kahampatan ay ginantiyan lan kala-etan; kayà hiko ay nagkama-in nin masyadoy kalele-an. ");
INSERT INTO sbl_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","No ampagmasakit hila ay an-ipakit koy kalele-an ko ha pagholot ko nin mangitit boy makodpaw ya dolo, boy ampagpalta kon mangan. Ha panalangin ko ay an-iyongoh koy olo ko. ");
INSERT INTO sbl_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Masyadoy kalele-an ko nin bilang ha na-alihan nin mihay amigo o patel. Ha kalele-an ko ay inyongoh koy olo ko nin bilang akon ampi-a-anito ha nanay ko. ");
INSERT INTO sbl_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Balè hila ay natowà hin angkagolo ko boy nititipon hila ta pinagsistiyan la ko. Ambinggawan la ko nin bawbagay ya agko tandà, boy ayin tegen ya paghalità la nin paninirà kongko. ");
INSERT INTO sbl_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Hila ay bilang ha mangala-et ya mawmanoya-toyà ya ha ka-inakitan la kongko ay an-et-eten lay ngipen la. ");
INSERT INTO sbl_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Pangino-on, anggan makano mo ko nin ahè asikasowen? Ilibri mo ko ha kadisgrasyawan ya labay lan gaw-en kongko. Ilibri mo ko ha kawka-away ko ya bilang lawliyon. ");
INSERT INTO sbl_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ha ombayro, hika ay pasalamatan ko ha kalak-an tawo; ha arapan nin kalak-an tawoy nititipon ay poriyen kata. ");
INSERT INTO sbl_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Agmo dayi payagan nin mangalgal kongko ya kawka-away ko nin ayin bara-nan. Agmo simpri dayi payagan nin mikikindat ya ampipag-inakit kongko nin ayin bara-nan. ");
INSERT INTO sbl_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Hay paghahalità la ay emen ampikokolpya boy maronong hilan mamigawa-gawà nin hawhalità ya ayin kaptegan ya tongkol ha tawtawoy matinek ha ampa-iriyan la. ");
INSERT INTO sbl_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Hay an-ibo-angaw la ya kontra kongko ay ombayri: “Ah! mismon mata nawen ya nakakit nin ginawà mo.” ");
INSERT INTO sbl_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Pangino-on, nakit mo ya nangyari kongko; kayà ha-aren mo hila. Pangino-on, agmo ko pakarayo-an. ");
INSERT INTO sbl_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Biliwen moy ampangyari kongko boy dipinsawan mo ko, Diyos ko ya Pangino-on ko; ipakit mo dayi kongko ya katoynongan mo. ");
INSERT INTO sbl_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Hika, Pangino-on kon Diyos ya ma-in kahampatan ay paptegan mo ya hiko ay ayin ginawà ya kasalanan; agmo dayi payagan ya kawka-away ko nin mangalgal kongko. ");
INSERT INTO sbl_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Agmo hila dayi payagan nin maghalità ha sarili la nin, “Ah! nangyari ya labay nawen,” o maghalità nin, “Natalo nawen ya.” ");
INSERT INTO sbl_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Dayi, hay ampipangalgal kongko ha andanasen koy kadya-dya-an ay mipareng-ey boy mikalito; dayi, hay ampipaghalità nin hila ay mas mahampat kisa hiko ay mipareng-ey boy ma-alihan dangal. ");
INSERT INTO sbl_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Dayi, hay ampipagtowà banà ta hiko ay napaptegan nin ayin kasalanan ay mipambo-angaw ha katowa-an. Hay pirmi la dayin halita-en ay ombayri: “Hay Pangino-on ay itag-ay ta hiya ay angkatowà nin mambin ka-inomayan ha magsisirbi na.” ");
INSERT INTO sbl_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ibabalità ko ya kahampatan mo, Pangino-on, boy pirmi katan poriyen. ");
INSERT INTO sbl_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","(Kanta ni Dabid ya magsisirbi nin Pangino-on) Tandà nin makasalanan ya hay anti ha nakem na ay poro kala-etan; hay Diyos ay antanggi-an na boy agna an-igalang. ");
INSERT INTO sbl_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Banà ta hay palagay na ha sarili na ay masyadon matag-ay ya ingkatawo na, hay anti ha ihip na ay ahè matanda-an nin Diyos ya kawkasalanan na boy agya maparosawan. ");
INSERT INTO sbl_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Hay anhalita-en na ay kawkala-etan boy kawkabongkokan; alwa yaynan maronong boy ayin yaynan anggaw-en ya kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Maski ampirà yayna para matoloy ay kala-etan et ya amplanowen na. Hay ampag-ogali-en na ay alwan maganda, ta agna antanggi-an ya kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Pangino-on, hay ingangalo moy ma-in panlalabi ay ahè makwan ihipen; ombayro simpri ya katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Hay kahampatan mo ay mataghen nin bilang kataghen nin mangalhay ya bawbakil; hay panonosga mo ay ahè makwan ihipen nin bilang ha malalè ya dagat. Hika, Pangino-on, ya ampangasiwà nin tawtawo boy aw-ayop. ");
INSERT INTO sbl_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Diyos ko, hay ingangalo moy ma-in panlalabi ay masyadon ma-alagà; kayà hay tawtawo ay ampahimalà nin hila ay protiksyonan mon kopkopen. ");
INSERT INTO sbl_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Hila ya ampakaranas nin ingangalo mo ay ma-in sapat ya kowinta pamamangan ya ampangibat komo; ombayro simpri ha kowinta inomen ya ampangibat ha ahè mangaka-anggawan ya kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Hika ya ampambin biyay boy hika ya hawang ya ampakahawang konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Hay nipampakabalay komo ay patoloy mo dayin biyan nin ingangalo moy ma-in panlalabi, boy patoloy mo dayin ipakit ya kahampatan mo ha tawtawoy leseb ya nakem komo. ");
INSERT INTO sbl_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Agmo dayi payagan nin mangalaban kongko ya tawtawoy mangahambog, boy agmo dayi payagan nin mapahlin ako nin tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Habayti ya tawtawoy mangala-et ay nikatombah boy aghilayna maka-ibangon ha pagkatalo la. ");
INSERT INTO sbl_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","(Kanta ni Dabid) Agmo golowen ya nakem mo nin banà ha tawtawoy ampipanggawà nin kala-etan, boy agka ma-inggit ha tawtawoy ampipanggawà nin alwan tamà; ");
INSERT INTO sbl_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","ta hila ay bilang ha dawdikot ya tinabas boy bilang ha malaboyong ya tawtanaman ya tampol mayangoh. ");
INSERT INTO sbl_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Pahimalà ka ha Pangino-on, boy manggawà kan kahampatan emen agka mapangno ha pama-iri mo bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Pakaliga ka ha Pangino-on emen na igwà komo ya annakemen mo. ");
INSERT INTO sbl_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Kaganawan ampangyari ha biyay mo ay ipa-olay mo ha Pangino-on. Pahimalà ka kona, ta hiya ya ba-alà komo. ");
INSERT INTO sbl_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Ha ombayro, hay kahampatan mo ay ipatnag na nin bilang ha hawang, boy ipatnag na et nin bilang ha hilà allo no ogtoy allo ya hika ay ayin kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ipa-olay moy sarili mo ha Pangino-on, boy magpasinsya kan mangantì ha gaw-en na. Agmo golowen ya nakem mo nin tongkol ha tawtawoy ampipag-inomay, o ha tawtawo ya hay pawplano lay mangala-et ay angkagawà la. ");
INSERT INTO sbl_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Tonggen kan mamahang boy agka mag-amot olo; agmo golowen ya nakem mo, ta maka makagawà kan kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Hay tawtawoy mangala-et ay ahè bomoyot ya biyay, balè hay tawtawoy ampahimalà ha Pangino-on ay ahè mapangno ha pama-iri la bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ahè maboyot, hay mangala-et ay ma-alih ana; tikapen mo hila man ay agmo hilayna makit. ");
INSERT INTO sbl_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Piro hay tawtawoy ma-amey ya nakem ay ahè mapangno ha pama-iri la bayri ha babon lotà; hila ay lomiga boy talagan magkama-in hila nin katinekan. ");
INSERT INTO sbl_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Hay mangala-et ya tawtawo ay ampagplano nin kontra ha mangahampat ya tawtawo, boy ha kapahangan la ay an-et-eten lay ngipen la ha pangayeget la. ");
INSERT INTO sbl_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Hay Pangino-on ay ampangka-ili ha tawtawoy mangala-et ta tandà na ya ahè ana maboyot, hila ay mipalakoyna ha kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Hay hondang boy panà nin tawtawoy mangala-et ay an-ihandà lan pamati nin tawtawoy manga-irap boy ampipanga-ilangan; talagan labay lan patyen ya tawtawoy ampamiyay nin mahampat. ");
INSERT INTO sbl_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Habayti ya tawtawoy mangala-et ay mismon sarili lan hondang ya makasaksak konla, boy hay pawpanà la ay mangababalì. ");
INSERT INTO sbl_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Hay amò ya kamama-in nin mahampat ya tawo ay mas ma-alagà kisa ha kayamanan nin malakè ya tawoy mangala-et; ");
INSERT INTO sbl_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","ta hay kakhawan nin tawtawoy mangala-et ay alihen nin Pangino-on, piro hay tawtawoy mangahampat ay an-alalayan na. ");
INSERT INTO sbl_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","An-asiwa-en nin Pangino-on ya tawtawoy leseb ya nakem kona, boy hay kahampatan ya igwà konla nin Pangino-on ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","No ma-in lomateng konla ya pangyayari ya alwan maganda, hay an-asawan lay kahampatan ay matanggap la, boy ha pana-on nin bitil, hila ay magkama-in nin sapat ya panganga-ilangan. ");
INSERT INTO sbl_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Piro hay tawtawoy mangala-et ay mikati; hay kawka-away nin Pangino-on ay bilang ha dawdikot ya antabasen ya maparan mayangoh boy bilang ha ahok ya angkapanew. ");
INSERT INTO sbl_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Hay tawtawoy mangala-et ay ampag-irap; kayà ahè ampakapi-orong nin oram. Balè hay tawtawoy mangahampat ay ma-ingangalowen boy mabibi-iyen. ");
INSERT INTO sbl_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Hay tawtawoy binyan nin Pangino-on nin kahampatan ay ahè mapangno ha pama-iri la bayri ha babon lotà, piro hay inhompà na ay ahè bomoyot ya biyay. ");
INSERT INTO sbl_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Hay tawoy an-itoto nin Pangino-on ay ampag-in matatag ya pamimiyay; ampangonswilo kona ya Pangino-on ha gawgawà na. ");
INSERT INTO sbl_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","No kowinta angkatombah ya ay ampaka-ibangon ya ta Pangino-on ya ampangalalay kona. ");
INSERT INTO sbl_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Hin anak ako et angga hapa-eg ha mato-a koyna ay agko et nakakit nin tawtawoy mangahampat ya pina-olayan nin Pangino-on, o aw-anak la ya nakilimoh nin pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Hay tawtawoy mangahampat ay mabibi-iyen boy ampamaram ha kanayon; banà bayro ha gawgawà la, hay aw-anak la ay ampagkama-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Halibokotan moyoy panggawà kala-etan ta manggawà kawon kahampatan; ha ombayro, hikawo kateng inalalak moyo ay ahè mapangno ha pama-iri moyo bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Hay Pangino-on ay ampanlabi ha tawtawoy ampanggawà nin matoynong, boy agna ampa-olayan ya tawtawo nay tapat kona. Hay pangi-atap na konla ay ayin angga, piro hay inalalak nin mangala-et ay ahè bomoyot ya biyay. ");
INSERT INTO sbl_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Hay tawtawoy mangahampat ay ahè mapangno ha pama-iri la ha dogal ya inggawà konla nin Pangino-on nin pag-ikon la, boy habayto ay pa-iriyan la anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Hay paghahalità nin mahampat ya tawo ay ma-in karonongan boy hay anhalita-en na ay makatoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Hay an-ipanogò nin Diyos ay an-itanem na ha nakem na, boy habayti ay talagan anhonolen na. ");
INSERT INTO sbl_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Hay mangala-et ya tawtawo ay pirmin ampangabang nin mangahampat ya tawtawo ta patyen la. ");
INSERT INTO sbl_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Piro hay mangahampat ay ahè pa-olayan nin Pangino-on ha kapangyariyan nin mangala-et, boy agna hila payagan nin masintinsyawan maski i-arap hila ha hosgado. ");
INSERT INTO sbl_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Omasa ka ha Pangino-on, boy honolen moy an-ipanogò na, ta biyan na kan karapatan nin makapag-ikon nin pa-iriyan mo bayri ha babon lotà. Hay tawtawoy mangala-et ay makit mo ya hila ay ahè bomoyot ya biyay. ");
INSERT INTO sbl_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Nakakit akon mala-et ya tawo ya masyadoy kala-etan nin anggaw-en na ha kapara nan tawo. Hiya ay bilang ha po-on kayoy malaboyong ya hay hawhanga ay nanwalak ta habayti ay ahè ingkambya nin intanem. ");
INSERT INTO sbl_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Ahè naboyot ay nagdaan akon oman bayro piro agko yayna nakit. Hay ginawà ko ay tinikap ko ya, piro talagan ayin ya bayro. ");
INSERT INTO sbl_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Obsirbawan moy tawo ya ma-in kahampatan ya leseb ya nakem ha Pangino-on. Hiya ay ma-in katinekan boy magkama-in yan ma-i-alalak. ");
INSERT INTO sbl_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Piro hay tawtawoy makasalanan ay mika-apò, boy hay inalalak la ay ahè bomoyot ya biyay. ");
INSERT INTO sbl_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Hay tawtawoy mangahampat ay an-ilibri nin Pangino-on, boy an-i-atap na hila ha kawkagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Hila ay antambayan boy an-ilibri nin Pangino-on. An-ilibri na hila ha tawtawoy mangala-et, ta hila ay ampahimalà kona nin i-atap na hila. ");
INSERT INTO sbl_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","(Kanta ni Dabid ya ma-in pamakirawat ha Pangino-on) Pangino-on, agmo ko ha-aren nin pahang mo, boy agmo ko parosawan no ampamahang ka. ");
INSERT INTO sbl_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Hiko ay pinarosawan mon hinogathogatan nin kowinta yawò mo, boy nakatanam ako nin mabyat ya parosa mo. ");
INSERT INTO sbl_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Banà ha pahang mo, hay masakit ya angkatanam ko ha nawini ko ay masyadon mabyat, boy banà ha kasalanan ko, hay tanam ko ha bawbot-o ko ay emen anan ampangapihihiyay. ");
INSERT INTO sbl_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Hay kawkasalanan ko ay talagan kalipoyna, boy habayti ay masyadon biyat nin bilang ha karga ya agkoyna kayan gitan. ");
INSERT INTO sbl_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Hay hawhogat ko ay ampanhayo boy kapaparami-il nin banà ha katangahan ko. ");
INSERT INTO sbl_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Hiko ay nakayoyongoh nin banà ha kalele-an ko, boy ayin tegen ya pami-a-anito ko. ");
INSERT INTO sbl_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Emen akon ampo-olan ha ka-amotan ko, boy hay masakit ya angkatanam ko ha nawini ko ay masyadon mabyat. ");
INSERT INTO sbl_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Hiko ay angkomapey boy agkoyna makayan te-ehen ya kabyatan nin masakit ko; kayà ampan-agol ako ha kagolowan nin nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Pangino-on, tandà moy kaganawan labay ko, boy angkalengè moy an-i-agol ko. ");
INSERT INTO sbl_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Hay posò ko ay pomitogpitog ha kakatogan ko. Angka-alihan akoynan hokaw, boy hay tegteg ko ay ambomereg ana. ");
INSERT INTO sbl_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Hay aw-amigo ko boy kawkalamowan ko ay agana labay pakarani kongko nin banà ha hawhogat ko; kateng pamilya ko ay ampakarayò ana kongko. ");
INSERT INTO sbl_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Hay tawtawoy labay mamati kongko ay nangikanà nin pandakep kongko; hay tawtawo itaman ya labay mamakakhit kongko ay ampagtotol nin ikahirà ko; hay pirmi lan an-ihipen ay panana-ol. ");
INSERT INTO sbl_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Hiko ay bilang ha teek ya ahè nin makalengè boy bilang ha pipih ya ahè makapaghalità. ");
INSERT INTO sbl_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Awò, talagan bilang ako ha tawoy ahè ampakalengè ta agko antombay. ");
INSERT INTO sbl_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Pangino-on, ampahimalà ako komo; tandà koy tobayen mo ko, Pangino-on kon Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Kayà ombayri ya hinalità ko: “Agmo dayi payagan nin galgalan ako nin kawka-away ko, o maghambog hila kongko no hiko ay kowinta natombah ta nakapagkasalanan ako.” ");
INSERT INTO sbl_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Hiko ay magayna matombah, ta hay angkatanam ko ay ahè angka-alih. ");
INSERT INTO sbl_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","An-aminen ko boy ampaghehean ya kawkasalanan koy ampanggolo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Hay kawka-away ko ay mangaganday pawpagnanawini boy mangakhaw; malakè hila boy maski ayin bara-nan ay ampag-inakitan la ko. ");
INSERT INTO sbl_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Hay ampipanggantin kala-etan ha kahampatan ay ampipangkomontra kongko, ta hay ansikapen kon gaw-en ay tamà. ");
INSERT INTO sbl_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Pangino-on kon Diyos, agmo ko pa-olayan boy agmo ko pakarayo-an. ");
INSERT INTO sbl_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Tampol kan pakarani kongko, ta tambayan mo ko, Pangino-on ya Mapangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","(Kanta ni Dabid) Hinalità ko ha sarili ko ya ombayri: “Hiko ay paka-atap ha gaw-en ko boy agko maghalità nin makapakasalanan kongko. Agko maghalità nin maski anya no ma-in mala-et ya tawo ha dani ko.” ");
INSERT INTO sbl_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Kayà agko naghalità maski tongkol ha bawbagay ya kahampatan, piro hay angkatanam ko ay lalò ana ingat nin binomyat. ");
INSERT INTO sbl_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Banà bayri, hay nakem ko ay angkagolo. Mintras an-ohoy-ohoyen ko ay lalò akoyna ingat nin angkagolo. Hin agkoyna mate-eh ay ombayri ya hinalità ko: ");
INSERT INTO sbl_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Pangino-on, ipatandà mo dayi kongko no makano ko mati, boy no pangno kaboyot ya biyay ko. Ibalità mo dayi kongko no makano ma-anggawan ya biyay ko.” ");
INSERT INTO sbl_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Ginawà mon bilang bongat ka-ipek mihan dingan ya biyay ko. Ha ka-ipekan nin biyay ko ay bilang ayin kowinta komo. Talagan hay biyay nin tawo ay bilang bongat angin ya ampagdaan. ");
INSERT INTO sbl_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Hay biyay nin tawo ay bilang bongat anino; kaganawan gawà na ay ayin kowinta. Hay kayamanan ya tinipon na ay agna tandà no hinoy makapag-ikon. ");
INSERT INTO sbl_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Hapa-eg, Pangino-on, anyay ma-asawan kon anti-en? Hay pag-asa ko ay anti komo. ");
INSERT INTO sbl_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ilibri mo ko ha kaganawan kasalanan ko; agmo payagan nin pagsistiyan ako nin tawtawoy tangah ya ma-in kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Agko magtelek nin maghalità ta hika ya ma-in gawà nin habayti ya andanasen ko. ");
INSERT INTO sbl_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Itegen moyna ya pamarosa mo kongko ta hiko ay malagayna mati ha gawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Hay tawo ay anha-aren mon disiplinawan ha kawkasalanan na. Hay labaylabay na ay anhira-en mo nin bilang ha panirà nin anag ha dawdolo. Talagan hay biyay nin tawo ay bilang bongat angin ya ampagdaan. ");
INSERT INTO sbl_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Leng-en moy panalangin ko, Pangino-on, boy hay an-ida-ing ko ay pakaleleng-en mo; tobayen moy an-itangih koy pamakirawat ko komo, ta hiko ay emen bongat nin mihay dayowan bayri ha babon lotà nin bilang ha kaganawan ka-apo-apowan ko hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Ha ombayri ya anggaw-en mo kongko, dayi ay pa-olayan mo koyna emen ako pon makatanam nin kaligawan biha ko mati. ");
INSERT INTO sbl_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","(Kanta ni Dabid) Hiko ay nagpasinsyan nangantì nin tobay nin panalangin ko ha Pangino-on. Hapa-eg ay nilengè nay da-ing ko kona. ");
INSERT INTO sbl_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Kowinta ginoloy na kon in-alawah ha kowinta piligrosoy lobot ya ma-in maraliket ya pità. Gintan na kon inggawà ha kowinta malhay ya bato ta bayro ay angkasigoro na nin hiko ay ahè mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Banà bayro ay impanakem na kongko ya hiko ay magkanta nin bayoy kanta ya pamomori ha Diyos nawen; malakè ya gomalang boy pahimalà ha Pangino-on ya mipampakalengè nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Makalmà ya tawoy ampahimalà ha Pangino-on boy ahè an-omasa ha tawtawoy mangahambog, o ha tawtawoy ampipanhomamba ha alwan peteg diyos. ");
INSERT INTO sbl_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Malakè ana ya ginawà moy pawpapag-ispantawan, Pangino-on kon Diyos, boy malakè simpri ya plano mo ya para konnawen. Habayti ya ombayri ay ayin nakagawà no alwan hikan bongat. No mihamihawen kon halita-en bayti ay ayin pangaka-oboh. ");
INSERT INTO sbl_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Hika ay ahè ampangonswilo ha pambi komo nin tawtawo nin pinati ya aw-ayop, o maski anyay bagay ya idolog komo. Habaytoy aw-ayop ya an-ipo-ol nin idolog komo, boy kanayon et ya bawbagay ya an-igwà komo nin banà ha kasalanan ay ahè ampakapakonsowilo komo. Hay labay mo ay leng-en ka boy honolen. ");
INSERT INTO sbl_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Kayà hinalità ko komo, “Anti ko bayri nin kompormi ha nakaholat ha libroy pinangiholatan nin kawkapanogo-an. ");
INSERT INTO sbl_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Labay kon honolen ya kalabayan mo, Pangino-on kon Diyos. Hay kawkapanogo-an mo ay ahè angka-alih ha nakem ko.” ");
INSERT INTO sbl_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Pangino-on, ha ampititipon ya kalak-an nin tawtawo mo ay an-ibalità ko ya tongkol ha kahampatan mo, boy tandà mo ya agko tonggen mangibalità nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Hay kahampatan mo ay agko sinarili ha nakem ko, no alwan ha ampititipon ya kalak-an nin tawtawo mo ay imbalità ko ya tongkol ha katapatan mo boy pangilibri mo; ombayro simpri ha ingangalo moy ma-in panlalabi boy kaptegan mo. ");
INSERT INTO sbl_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Pangino-on, agmo dayi itegen ya pangingangalo mo kongko; protiksyonan mo ko dayi nin ingangalo moy ma-in panlalabi boy katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Hay kawkadya-dya-an ya andanasen ko nin banà ha kawkasalanan ko ay ahè mabilang, boy habayti ay agkoyna makayan gitanan; kayà halos agkoyna makakit no manegteg ako. Hay kawkasalanan ya anti kongko ay mas malakè kisa ha bilang nin habot ko; banà bayri ay angkomapey anay nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Ilibri mo ko, Pangino-on! Tampol mo ko dayi, Pangino-on, nin tambayan! ");
INSERT INTO sbl_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Dayi, hay ampipaghangad nin mamati kongko ay mikatalo boy mikalito. Hay ampipagtowà nin banà ha pawproblima ya anti kongko ay mipagbiran ampikareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Dayi, hay ampipangalgal kongko ay ma-in biglà lomateng konlay kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Dayi, hay ampikahabek nin makabalay komo ay matowà boy magkama-in kaligawan komo. Hay ampipagpa-alagà ha pangilibri mo ay pirmi dayin maghalità nin, “Hay Pangino-on ay itag-ay!” ");
INSERT INTO sbl_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Maski apih ako boy ampanga-ilangan ay ampanemtemen akon asiwa-en nin Pangino-on. Hika ya Diyos ko ya ampanambay boy ampangilibri kongko; kayà tampol mo ko dayin tambayan. ");
INSERT INTO sbl_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","(Kanta ni Dabid) Makalmà ya tawoy ampangimalasakit nin manga-irap; hiya ay tambayan nin Pangino-on no anti ya ha kagipitan. ");
INSERT INTO sbl_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Hay biyay na ay i-atap nin Pangino-on boy protiksyonan na ya. Hiya ay magkama-in nin ka-inomayan bayri ha babon lotà, boy agya pa-olayan nin Pangino-on ha kapangyariyan nin kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Pangino-on ya manambay kona no magmasakit ya; hay kakhawan ya na-alih kona ay ibira nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Hapa-eg, hinalità ko ya ombayri: “Pangino-on, nagkasalanan ako komo; ingalowan mo ko dayin pakahampaten.” ");
INSERT INTO sbl_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Hay kawka-away ko ay ampipaghalità nin mala-et ya tongkol kongko, ya wanla, “Mati yayna dayi emen yayna maliwawan!” ");
INSERT INTO sbl_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Hay ampipampako nin mamiliw kongko ay alwan leseb ya nakem, no alwan ampanagap hilan bongat nin katowà ya balità ya tongkol kongko biha la ibabalità ha maski ayrin dogal. ");
INSERT INTO sbl_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Kaganawan ampipag-inakit kongko ay ampi-a-ananah nin kontra kongko; hay an-ihipen la ay kala-etan ya tongkol kongko. ");
INSERT INTO sbl_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Hay anhalita-en la ay ombayri: “Agyayna homampat ha mabyat ya masakit na; kayà ayin yaynan pag-asa nin mabiyay.” ");
INSERT INTO sbl_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Maski amigo kon karnal ya ampahimala-an ko ya nakipangan kongko, hapa-eg ay kinomontra kongko. ");
INSERT INTO sbl_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Piro, Pangino-on, ingalowan mo ko; ibira moy kakhawan ya na-alih kongko emen ako makabaweh ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Banà bayri ay natanda-an ko ya ampangonsowilo ka kongko, ta agmo ampayagan nin talowen ako nin kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Tinambayan mo ko banà ha katapatan ko, boy ginawà mo nin hiko ay anti komo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Poriyen ya Pangino-on Diyos ya pinahimala-an nin Aw-israylita; poriyen ya pa-ibat hin ibat anggan makakanoman. Amin! Amin! ");
INSERT INTO sbl_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","(Kantan aw-inalalak ni Kori ya pakapowotan nin aral) No pangno nin angkahabek ya oyha nin minom nin malay-ep ya lanom hapà ay ombayro itaman ya pagkahabek ko komo, Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Angkahabekan kata, Diyos, Diyos ya angkabiyay; makano ko ma-arì omarap komo nin homamba? ");
INSERT INTO sbl_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Allo yabi kon ampanangih boy hay kowinta pamamangan ko ay lowà ko. Hay pirmin ampastangen kongko nin kawka-away ko ay ombayri: “Ayri ya Diyos mo?” ");
INSERT INTO sbl_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Masyadon angkahirà ya nakem ko no angkapanemteman koy nakaraan ya ampakilako ko ha kalak-an tawo nin mako ha bali nin Diyos. Hiko ya ampangona konla, boy mintras ampowako kayi ay maliga kayin ampipagkanta boy ampipambo-angaw ha pamori nawen ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Ombayri ya hinalità ko ha sarili ko: “Antà masyado kon maglelè boy magolo? Hay gaw-en ko ay omasa ko ha Diyos boy poriyen ko yan oman, ta hiya ya Diyos ko ya Mapangilibri kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Angkapanemteman koy Diyos ta ampagdanas akon kalele-an; angkapanemteman ko ya mintras anti ko bayri ha dogal ya marani ha balah nin Hordan. Habayti ay marani ha bakil nin Hirmon boy bakil nin Misar. ");
INSERT INTO sbl_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Hay tonoy nin agoh nin lanom ha haloghog nin balah ay kowinta ampag-ilgo; ombayro simpri ha ampan-agoy lanom ya ampagtata ha behay. Ha kakhawan agoh nin habayti ya lanom ay bilang ha kalipoy kalele-an ya kowinta ampakataphon kongko. ");
INSERT INTO sbl_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Allo-allo ay an-ipakit nin Pangino-on ya ingangalo nay ma-in panlalabi. Yabiyabi ay magkanta ko nin pamomori kona, boy manalangin ako ha Diyos ya nambi kongkon biyay. ");
INSERT INTO sbl_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ombayri ya halita-en ko ha Diyos ya kowinta malhay ya bato ya ampangidipinsa kongko: “Antà niliwawan mo ko? Antà ka-ilangan akon magdanas nin kalele-an nin banà ha pangangapih kongko nin kawka-away ko?” ");
INSERT INTO sbl_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Hay tanam ko ay bilang akon nangababali-an nin bawbot-o ha panoya-toyà kongko nin kawka-away ko ha paghalità lan pirmi kongko nin, “Ayri ya Diyos mo?” ");
INSERT INTO sbl_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Ombayri ya hinalità ko ha sarili ko, “Antà masyado kon maglelè boy magolo? Hay gaw-en ko ay omasa ko ha Diyos boy poriyen ko yan oman, ta hiya ya Diyos ko ya Mapangilibri kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Diyos ko, paptegan mo ya hiko ay ayin ginawà ya kasalanan, boy idipinsa mo ko ha tawtawoy ahè antompel komo. Ilibri mo ko ha tawtawoy manloloko boy ha tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Hika ya Diyos ya ampamakhaw kongko; antà pina-olayan mo ko? Antà ka-ilangan akon magdanas nin kalele-an nin banà ha pangangapih kongko nin kawka-away ko? ");
INSERT INTO sbl_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Dayi, hay hawang mo boy hay katapatan mo ay mangitoto kongko boy mangibira kongko ha bakil nin Siyon ya kama-inan mo ya masagradoy dogal. ");
INSERT INTO sbl_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ha ombayro ay mako ko ha altar mo, Diyos ko, ta hika ya ampambi kongko nin katowa-an boy kaligawan; manogtog akon alpa boy magkanta ko nin pamomori komo, Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Ombayri ya hinalità ko ha sarili ko: “Antà masyado kon maglelè boy magolo? Hay gaw-en ko ay omasa ko ha Diyos boy poriyen ko yan oman, ta hiya ya Diyos ko ya Mapangilibri kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","(Kantan aw-inalalak ni Kori ya pakapowotan nin aral) Pangino-on Diyos, hay ginawà mo hin hato ya kawkapapa-ispanta hin pana-on nin kawka-apo-apowan nawen ay natanda-an nawen ha mawmato-antawo nawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Hay ginawà mo ay ombayri: ha kapangyariyan mo ay impataboy mon pinarosawan ya tawtawoy alwan Israylita ha dogal ya ampa-iriyan la, ta hay impa-iri mo bayro ay Aw-israylita ya kawka-apo-apowan nawen, boy pinayagan mo hilan mikakatak bayron mangokopa nin habaytoy dogal. ");
INSERT INTO sbl_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Habaytoy dogal ay ahè napag-ikon nin Aw-israylita ya tawtawo mo nin banà ha sarili lan kakhawan o panggamit lan aw-armas, no alwan habayto ay napag-ikon la nin banà ha kapangyariyan mo boy kakhawan mo. Nangyari simpri nin hila ay pinolalagan mo emen mo ma-ipakit konla ya panlalabi mo. ");
INSERT INTO sbl_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Hika ya Arì ko boy Diyos ko ya ampambin pananalo ha tawtawo mo ya inalalak ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Banà ha kapangyariyan mo, hay kawka-away nawen ay napatalo nawen, boy banà ta anti ka konnawen, hay ampipangkomontra konnawen ay napahokò nawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Agko ampahimalà nin ma-ilibri ko nin an-ipanà ko o nin hondang ko, ");
INSERT INTO sbl_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","ta hika ya nangilibri boy nambin panalo konnawen ha kawka-away nawen boy ha ampipag-inakit konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Hikayi ay pirmin mamori ha Diyos boy ayin anggay pasasalamat nawen kona. ");
INSERT INTO sbl_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Piro hapa-eg ay pina-olayan mo kayin natalo, ta agmo nilamowan ya hawhondalò nawen ha pamakilaban. ");
INSERT INTO sbl_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Pina-olayan mo kayi ha kawka-away nawen; kayà napapowayo la kayi, biha hay kawkamama-in nawen ay kinwa lan pinag-ikon. ");
INSERT INTO sbl_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Hikayi ay pina-olayan mon patyen nin bilang ha tawtopa ya ampatyen nin karniyen, boy pina-olayan mo kayin mangapihahabwag nin mipalako ha kanayon ya nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Kowinta inlakò moy tawtawo mo nin mayamò ya alagà, boy hay napaglako-an mo ay agmo pinakinabangan. ");
INSERT INTO sbl_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ginawà mo kayin kapapaka-ili ha tawtawo ha nawnasyon ya mamalibot konnawen; kayà antoya-toya-en la kayi boy ansorawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ginawà mo kayin tototolen ha nawnasyon; kayà hay tawtawo ay ampipampeyeng nin manoya-toyà konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Pirmi kon ampipareng-ey boy kalipoyna ya kakareng-eyan ko ");
INSERT INTO sbl_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","ha angkalengè koy tawtotoyà boy aw-insolto nin kawka-away ko ya ampipangkomontra kongko. ");
INSERT INTO sbl_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Pangino-on, kaganawan nin habayti ay ampangyari konnawen maski agnawen ka angkaliwawan ni ginomawà nin labag ha kasondo-an ya ginawà mo ha kawka-apo-apowan nawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Hay nakem nawen ay talagan tapat komo, boy agnawen nilabag ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Ombayroman, hikayi ay pina-olayan mo ha mangabangis ya aw-ayop boy ha masyadoy karegleman ya kowinta kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","No hikayi ay tinonggen ha panhomamba ha Diyos ta nanalangin kayin hinomamba ha alwan peteg diyos, ");
INSERT INTO sbl_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","ahè warì matanda-an nin Diyos ya hay sawsikrito ya anti ha nakem nin tawtawo ay tandà na? ");
INSERT INTO sbl_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Awò, matanda-an na, piro ha kaganawan oras, hikayi ay naka-arap ha kamatyan nin banà ha panhohomonol nawen kona; bilang kayin tawtopa ya papatyen. ");
INSERT INTO sbl_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Pangino-on, antà agmo kayi an-asikasowen? Agmo kayi dayi pa-olayan boy ayin angga dayi ya pangangasikaso mo konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Antà agmo kayi ansisipanowen, boy antà ampa-olayan mo kayi ha andanasen nawen ya kadya-dya-an boy ka-apiyan? ");
INSERT INTO sbl_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Banà ha pagka-apih nawen, hikayi ay ampanlokob ha lotà ya magabok. ");
INSERT INTO sbl_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Pakaraniyan mo kayin tambayan boy banà ha ingangalo moy ma-in panlalabi ay ilibri mo kayi. ");
INSERT INTO sbl_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","(Kantan aw-inalalak ni Kori ya pakapowotan nin aral) Hay nakem ko ay ponò nin mangaganday hahalita-en, boy hay dilà ko ay ayin imbalag ha papanolat ya anggamiten nin magaling ya manonolat. Habayto ya ampangitorò kongko no anyay halita-en ko ha gaw-en koy kanta ya para ha arì. ");
INSERT INTO sbl_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ha kaganawan lalaki ay ayin makapantay ha kagandawan mo. Hika ay ma-osay maghalità; kayà ayin angga ya pamolalag komo nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Itagkeh moy hondang mo, makapangyariyan ya arì; hika ay ma-in karangalan boy kapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ha paninigè mo, hika ya ma-in karangalan ay magkama-in pananalo ha pagdipinsa mo nin kaptegan boy katoynongan. Ha kakhawan mon manggawà nin bawbagay ya kapapa-ispanta ay talagan manalo ka. ");
INSERT INTO sbl_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Hay kowinta yawyawò moy mangatarem ay antomamà ha posò nin kawka-away mo. Banà bayri, hay nawnasyon ay mipahilong ha kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Hay pamomo-on mo, Diyos ko ay anggan makakanoman. Hay pag-a-arì mo ay ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Angkatowà ka ha gawgawà ya mangahampat, piro angka-inakit ka ha gawgawà ya mangala-et. Kayà hay Diyos ya Diyos mo ay pinonò na kan kaligawan, ta hika ay ginawà nan igit ha kawkalamowan mo. ");
INSERT INTO sbl_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Kaganawan nin dolo mo ay pinabangohan nin mira, alowi, boy kasya; ha panlomikol mo ha palasyo moy yarì ha kahika ay ampaligawen ka nin togtog nin istromintoy di kowirdas. ");
INSERT INTO sbl_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Hay bawbabayi ya aw-anak nin aw-arì ay kalamo nin mangarangal ya bawbabayi ya anti bayro ha palasyo. Ha bandan wanan mo ay naka-ireng ya rayna ya nakaholot nin doloy dinikorasyonan nin poron gintò ya na-ibat ha dogal ya an-ingaten Opri. ");
INSERT INTO sbl_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Kakahal nin arì, leng-en mo bayti ya halita-en ko komo: kaganawan nin sarili mon tawowan ay liwawan mo kateng pawpartidos mo. ");
INSERT INTO sbl_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ha kagandawan mo, hay arì ay magkalabay komo; hiya ya pangino-on mo; kayà pasakop ka kona. ");
INSERT INTO sbl_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Hay tawtaga Tiro ay mipagrigalo komo. Ombayro simpri ha mangayaman; hila ay manoyò komo. ");
INSERT INTO sbl_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Hay kakahal nin arì ya anak nin mihay arì ya anti ha palasyo ay pagkagaganda; hay dolo na ay binordawan nin gintò. ");
INSERT INTO sbl_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Hiya ya nakadolon bordado ya hari-harì ya kolor ay anggitan ha arì ya anhonowen nin aw-abay na. ");
INSERT INTO sbl_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Hila ay ampilalamo nin ma-in kaligawan ya ampomahok ha palasyo nin arì. ");
INSERT INTO sbl_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Hika ya arì ay magkama-in malakè ya anak ya lalaki ya pomahili ha kawka-apo-apowan mo; hila ay gaw-en mon mamo-on ha intiron babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Hay ngalan mo ay ipapanemteman ko ha kaganawan lahì; kayà kaganawan tawo ay mamori komo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","(Kantan aw-inalalak ni Kori) Hay Diyos ay dipinsa tamo boy hiya ya ampambi kontamo nin kakhawan. Hiya ay pirmin handà nin manambay ha oras nin kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","3","Maski ma-eyeg ya babon lotà, boy mitapon ha dagat ya bawbakil, domalleg man boy magbola-bolà ya lawlanom ha dagat, boy maski magalaw ya bawbakil nin banà bayro ay agtamo malimo. ");
INSERT INTO sbl_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Ma-in kowinta ampan-agoy balah ya mambin kaligawan ha siyodad nin Diyos ya masagradoy dogal ya kama-inan nin bali nin Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Hay siyodad ya kama-inan nin Diyos ay ayin pagkahirà, ta habayto ay angkahambaken nin Diyos nin tambayan. ");
INSERT INTO sbl_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Hay nawnasyon ay ampagkagolo boy hay kawka-ari-an ay ampipangkomapey. Ha bonghaw bongat nin Diyos, hay babon lotà ay matonaw ana. ");
INSERT INTO sbl_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Hay Pangino-on ya Pinakamakapangyariyan ay anti kontamo; hay Diyos ya pinahimala-an ni Hakob ay ampangidipinsa kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Biliwen moyo ya ginawà nin Pangino-on; helken moyoy ginawà nay panirà nin bawbagay bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Angkapategen na ya gawgira ha intiron babon lotà; anhira-hira-en nay an-ipamanà boy pawpikà, boy hay hawhalanggà ay an-ipo-ol na. ");
INSERT INTO sbl_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Pakatinek kawo ta balayen moyo ya hiko ay Diyos. Hiko ya makapangyariyan ay itag-ay ha kaganawan nasyon ha intiron babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Hay Pangino-on ya Pinakamakapangyariyan ay anti kontamo; hay Diyos ya pinahimala-an ni Hakob ay ampangidipinsa kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","(Kantan aw-inalalak ni Kori) Kaganawan tawo ay magtimpà! Mipambo-angaw kawon ma-in katowa-an ha pamomori moyo ha Diyos! ");
INSERT INTO sbl_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Hay Pangino-on ya Pinakamakapangyariyan ay dapat igalang; hiya ya Arì ya ahè mapantayan ya ampamo-on ha intiron babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Hitamo ya papanalowen na ha tawtawo, boy hay nawnasyon ay igwà na ha pamama-alà tamo. ");
INSERT INTO sbl_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Hiya ya namilì nin dogal ya ampa-iriyan tamo, boy habayti ay ikapori ni Hakob ya ka-apo-apowan tamo ya nilabi na. ");
INSERT INTO sbl_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ha pagbira nin Pangino-on Diyos ha katatag-ayan, hay tawtawo ay mipambo-angaw, boy ma-in kasabay ya tonoy nin tamboyok ha katowa-an la banà ha pananalo la. ");
INSERT INTO sbl_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Magkanta tamon maganday kanta ya pamomori ha Diyos; magkanta tamon pamomori kona ya Arì tamo! ");
INSERT INTO sbl_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Hay Diyos ay Arì ha intiron babon lotà; magkanta tamon maganday kanta ya pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Hay Diyos ya ayin kapintasan ay ampiknò ha trono na nin ampamo-on ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Hay tawtawoy ampipamo-on ha nawnasyon ay ampakitipon ha tawtawo nin Diyos ya pinahimala-an ni Abraham; hay hawhalanggà ya anggamiten nin mawmamakigira ay ikon nin Diyos. Hiya ya dapat itag-ay. ");
INSERT INTO sbl_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","(Kantan aw-inalalak ni Kori) Hay Pangino-on ay ahè mapantayan, boy hiya ay nararapat poriyen ha siyodad nin Diyos tamo ya anti ha masagradoy bakil. ");
INSERT INTO sbl_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Habaytoy bakil ay matag-ay boy maganda. Hay ingat bayro ha bakil ay bakil nin Siyon ya ikon nin Diyos ya Arì ya ahè mapantayan. Habayto ay ampambin kaligawan ha tawtawo bayro. ");
INSERT INTO sbl_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Impakit nin Diyos ya hiya ya dipinsa nin habaytoy siyodad ya kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Hay aw-arì ay nititipon ta lakwen lan lo-oban ya siyodad nin Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Hin nakit lay kagandawan boy kakhawan nin habaytoy siyodad, hila ay nabiglà; kayà nipampowayo hila ha kalimowan la. ");
INSERT INTO sbl_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Hila ay namegpeg ha kalimowan la boy nakatanam hila nin ilab ya bilang angkatanam nin babayi ya ambatowan ta ampanganak. ");
INSERT INTO sbl_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Hay angin ya ampangibat ha baytan ay ginamit nin Diyos nin pinanirà nin bawbarko ya na-ibat ha siyodad nin Tarsis. ");
INSERT INTO sbl_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Nalengè nawen ana ya tongkol ha ginawà nin Diyos hin hato, boy hapa-eg ay nakit nawen ana ya siyodad nin Diyos tamo ya Pangino-on ya Pinakamakapangyariyan; habayti ya siyodad ay i-atap nin Diyos anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Ha lo-ob nin bali mo, Diyos ko, pirmi nawen nin ampanemtemen ya ingangalo moy ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Hika, Diyos ko ay amporiyen nin tawtawo ta nibantog ka ha maski ayrin dogal, ta hay pamomo-on mo ay matoynong. ");
INSERT INTO sbl_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Hay tawtawo ha dogal ya an-ingaten Siyon ay ampipagtowà. Ombayro itaman ha tawtaga Hoda banà ha panonosga mo ya makatoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Liboten moyon owakowen ya bakil nin Siyon ta bilangen moyo ya matag-ay ya pagbantayan ya anti bayro. ");
INSERT INTO sbl_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Asikasowen moyo nin mahampat ya pawpadir nin habaytoy siyodad, boy pakatanda-an moyo no pangno katibay ya dipinsa nin kama-inan nin arì bayro emen moyo ma-ibalità ha homonoy lipì ");
INSERT INTO sbl_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","ya habayti ya Diyos ay Diyos tamo nin ayin angga. Hiya ya mangitoto kontamo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","(Kantan aw-inalalak ni Kori) Balang miha komoyo ay leng-en bayti, boy kaganawan tawo ha maski ayrin dogal ay manlengè nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Ma-aypà man o matag-ay ya pagkatawo, ma-irap man o mayaman ay manlengè nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Maghalità ako nin ma-in karonongan, boy hay ipalwa ko ya anti ha nakem ko ay makab-in pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Intindiyen kon mahampat ya mihay kahalita-an, ta hay labay totolen nin habayti ay ipalinaw ko mintras ampanogtog ako nin alpa. ");
INSERT INTO sbl_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Talagan agko malimo ha lomateng ya ma-anib ya pana-on ya gawà nin mangala-et ya kawka-away ya nakapalibot kongko. ");
INSERT INTO sbl_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Hay ma-in kagagaw-an nin habayto ay tawtawoy mangayaman ya ampipampahimalà ha kayamanan la, boy habaytoy an-ipaghambog la. ");
INSERT INTO sbl_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Ayin tawoy makatbeh nin sarili na ta agna kayan bayaran ha Diyos ya kabliyan nin biyay na. ");
INSERT INTO sbl_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Hay pambeh nin biyay nin tawo ay masyadon mabli. Maski anyay ibayad na ay ahè makasapat ");
INSERT INTO sbl_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","emen hiya ay ahè mati boy mabolok boy mabiyay nin ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Angka-obsirbawan nin kaganawan ya maski maronong ya tawo ay angkati; ombayro simpri ha aw-ayin tinandà boy tawtangah. Hay kayamanan ya tinipon la ay ibalag la ha kanayon. ");
INSERT INTO sbl_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","An-ihipen la nin hay ampa-iriyan la ay manatili nin ayin angga. Ombayro simpri ha homonoy lawlipì la maski ma-in hilan lawlotà hin hato ya an-ingaten la ha sarili lan ngalan. ");
INSERT INTO sbl_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Maski matag-ay ya ingkatawo nin tawo, habayto ay ahè makapi-atap kona ha kamatyan, ta hiya ay mati simpri nin bilang ha ayop. ");
INSERT INTO sbl_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Helken moyoy ampangyari ha tawtawoy ampahimalà ha kayamanan la. Ombayro simpri ya mangyari ha homono konlay lawlipì ya minto-o ha hinalità la. ");
INSERT INTO sbl_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Hay mangayaman ay talagan mati nin bilang ha tawtopa ya anggitan patyen, boy hila ay mipalako ha dogal nin nikati. Pangati la, hay makapangyayari konla ay kamatyan. Ahè maboyot, hay mamo-on konla ay tawtawoy mangahampat. Hay nawnawini nin hatoy mangayaman ay mikabolok ha pinangitabonan konla ya marayò ha ampa-iriyan la hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Piro hiko ay ilibri nin Diyos ta alihen na ko ha kapangyariyan nin kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Agka malimo ha ma-arì gaw-en komo nin tawoy anyomaman maski kateng et pamilya na ay kapanyoyomaman. ");
INSERT INTO sbl_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Hay tawoy mayaman, pangati na ay agna magtan ya kayamanan na ha pangitabonan kona. ");
INSERT INTO sbl_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Maski nin hay tawo ay maligawan ha sarili na mintras angkabiyay ya, boy masyado yan amporiyen banà ha pan-omasinso na ");
INSERT INTO sbl_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","ay mati ya simpri nin bilang ha kawka-apo-apowan na, boy makilamo ya konla ha dogal ya ayin anggay karegleman. ");
INSERT INTO sbl_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Hay tawoy matag-ay ya ingkatawo ya ayin pangingintindi ay mati simpri nin bilang ha ayop. ");
INSERT INTO sbl_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","(Kanta ni Asap) Hay Pangino-on Diyos ya Pinakamakapangyariyan ay naghalità, ta iningat nay kaganawan tawo bayri ha babon lotà pa-ibat ha baytan angga ha babà. ");
INSERT INTO sbl_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Ha dogal ya an-ingaten Siyon ya masyadoy kagandawan ay makit ya kahawangan boy kagandawan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Hay panlomateng nin Diyos tamo ay ahè ma-ipolinged ta ha bandan onawan na ay ma-in manliyobliyob ya apoy, boy ha mamalibot na ay pagkahokaw bagyo. ");
INSERT INTO sbl_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Hay anti ha katatag-ayan boy anti ha babon lotà ay ingaten na nin mangimaton ha panosga na nin tawtawo na. ");
INSERT INTO sbl_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Hay halita-en na ha hawhogò na ay ombayri: “Pititiponen moyo kongko ya nag-in tawtawo ko ya nakisondò kongko ha pangidolog la nin pinati ya aw-ayop.” ");
INSERT INTO sbl_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Hatoy anti ha katatag-ayan ay maghalità nin hay Diyos ay ma-in kahampatan ta hiyan mismo ya manosga. ");
INSERT INTO sbl_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Hikawoy tawtawo ko, leng-en moyo bayti ya halita-en ko; hikoy Diyos ya Diyos moyo ay mamapteg nin kontra komoyon aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Agkatawo anha-aren ha pangidolog moyo kongko nin pinati ya aw-ayop boy ha anggaw-en moyon pirmi ya mamo-ol nin aw-ayop ya para kongko. ");
INSERT INTO sbl_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Alwa kon ka-ilangan ya toron bakà ni toron kanding ya ma-ibat komoyo; ");
INSERT INTO sbl_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","ta kaganawan ayop ay ikon ko kateng liboliboy bakà ya anti ha bawbakilbakil. ");
INSERT INTO sbl_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Kaganawan manokmanok ha bakil ay ikon ko kateng mangama-in biyay ya anti ha lawak. ");
INSERT INTO sbl_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","“No bomitil ako man ay agko halita-en komoyo ta hay babon lotà boy kaganawan nin anti bayro ay ikon ko. ");
INSERT INTO sbl_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Warì mangnà akon karni nin tawtoron bakà boy warì minom ako nin dayà nin tawtoron kanding? ");
INSERT INTO sbl_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","“Hay labay ko ay mangidolog kawo nin leseb ha nakem moyo ha pamasalamat moyo ha Diyos, boy toparen moyoy impangakò moyo kona ta hiya ya Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Hapa-eg, makirawat kawo kongko no ma-in kawon angkagolowan; ilibri katawo boy poriyen moyo ko.” ");
INSERT INTO sbl_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Balè ha mangala-et, hay pastang nin Diyos ay ombayri: “Antà anggamiten moyo ya pawpanogò ko boy ambanggiten ya kasondo-an ko? ");
INSERT INTO sbl_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Hapaliman, angka-inakitan moyo ya tawtorò ko boy agmoyo antanggapen ya an-ipanogò ko. ");
INSERT INTO sbl_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","No ampakakit kawon ampanakaw ay ampaki-emen kawo, boy ampaki-emen kawo ha mawmamabayi boy ha mawmamakilalaki. ");
INSERT INTO sbl_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Hay pirmi moyon anhalita-en ay kala-etan boy agkawo ampag-alangan nin maghalità kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Maski sarili moyon patel ay ambinggawan moyo boy ampanggawà kawon ilgo ya ikahirà la. ");
INSERT INTO sbl_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Habayti ya ginawà moyo ay agko nagtelek; kayà an-ipalagay moyo nin hiko ay bilang komoyo. Piro hapa-eg ay paghalita-an katawo emen moyo ma-intindiyan ya ginawà moyoy kamali-an. ");
INSERT INTO sbl_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Leng-en moyo bayti ya halita-en ko, hikawo ya nakaliwa kongko. No agmoyo leng-en ay disgrasyawen katawo ya ayin mangilibri komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Hay ampambin dangal kongko ay pamasalamat. Hay ampipanhomonol kongko ay ilibri ko.” ");
INSERT INTO sbl_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","(Kanta ni Dabid hin nayarì yan pinaghalita-an ni Propita Natan banà ha pamabayi na koni Batsiba boy banà ha pangipapati nan ahawa ni Batsiba) Banà ha ingangalo moy ma-in panlalabi ay ingalowan mo ko, Diyos ko, boy banà ha masyadoy pangingangalo mo ay alihen moy kawkasalanan ko. ");
INSERT INTO sbl_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Alihen moy kala-etan ko, boy pakalinisen mo ko ha kasalanan ko. ");
INSERT INTO sbl_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","An-aminen ko ya hiko ay mala-et; hay kasalanan ko ay pirmin ampanggolo nin ihip ko. ");
INSERT INTO sbl_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Komo kon bongat nakapagkasalanan, Diyos ko, ta hay ginawà ko ya nakit mo ay talagan an-ibilang mo nin mala-et. Kayà tamà ya hinalità mo kongko boy matoynong ya panonosga mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Agko et in-anak, hiko ay makasalanan ana. ");
INSERT INTO sbl_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Hay labay mo ay tapat ya kanakeman; kayà pon-en moy nakem ko nin karonongan. ");
INSERT INTO sbl_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Alihen moy kasalanan ko emen ako mag-in malinis; pakalinisen moy nakem ko emen ako mag-in nin talagan malinis. ");
INSERT INTO sbl_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Biyan mo ko dayi nin kapatawaran emen ako magkama-in kaligawan boy katowa-an, ta maski kowinta binali-an mo kon bot-o ay magkama-in akon oman nin kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Liwawan moynay kawkasalanan ko, boy alihen moy kaganawan kala-etan ko. ");
INSERT INTO sbl_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Gaw-en mon malinis ya pagnanakem ko, Diyos ko, boy hay nakem ko ay gaw-en mon tapat komo nin bilang hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Agmo ko pa-alihen ha arapan mo, boy agmo dayi alihen ya Ispirito mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ibira mo kongko ya kaligawan nin pangilibri mo kongko, boy biyan mo kon kalabayan nin homonol komo. ");
INSERT INTO sbl_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Hapa-eg ay toro-an koy mawmakasalanan nin tongkol ha paghehe boy no pangno mapatawad ha kasalanan. Ha ombayro ay halibokotan lay kawkasalanan la ta pakarani hila komo. ");
INSERT INTO sbl_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Diyos ya ampangilibri kongko, ilibri mo ko ha ginawà koy kasalanan ya pangipapati. Ha ombayro ay ikanta ko ya kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Pangino-on, paptegan mo ya hiko ay pinatawad mo ha panambay mo kongko no anyay halita-en ko emen ko ma-ibabalità ya pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Agmo labay ya pinati ya aw-ayop ya idolog komo, ta no labay mo ay igwà ko dayi komo; agka simpri ampangonsowilo ha ampo-olan ya aw-ayop ya an-idolog komo. ");
INSERT INTO sbl_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Hay an-idolog ko komo, Diyos ko ay sarili ko ya ampaghehe ha kawkasalanan ya ginawà ko. Diyos ko, antanggapen mo koy anhomokò komo ya angkahirà ya nakem banà ha kasalanan ya ginawà ko. ");
INSERT INTO sbl_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Diyos ko, gaw-an mon mahampat ya dogal ya an-ingaten Siyon. Koloben mon oman nin padir ya siyodad nin Hirosalim. ");
INSERT INTO sbl_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","No mangyari baytoy ombayro, hay an-idolog komo ya aw-ayop ya bilang ha tawtoron bakà ya ampo-olan ha altar mo ay makab-i nin konsowilo komo, ta habayto ay an-igwà komo nin ma-in kahampatan nakem. ");
INSERT INTO sbl_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","(Kanta ni Dabid ya pakapowotan aral hin intraydor ya ni Dowig koni Arì Sawol) Hika ya tawoy makapangyayari, antà an-ipaghambog moy kala-etan ya ginawà mo? Hay ingangalo nin Diyos ya ma-in panlalabi ay pirmin anti ha ampahimalà kona. ");
INSERT INTO sbl_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Piro hika, hay pirmi mon amplanowen ay paninirà ha kanayon, hay dilà mo ay bilang ha matarem ya labahas, boy hay pirmi mon an-ihipen ay panana-ol. ");
INSERT INTO sbl_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Labaylabay moy kala-etan kisa kahampatan, boy labaylabay moy kabongkokan kisa kaptegan. ");
INSERT INTO sbl_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Hika ya tawoy mabongkok, labaylabay mon maghalità nin makahirà nin kapara mon tawo. ");
INSERT INTO sbl_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Banà ha gawgawà mo, hay Diyos ay manggawà nin ayin anggay kahira-an mo; hika ay alihen na ha pamamali mo, boy alihen na ka ha ampa-iriyan nin ampikabiyay. ");
INSERT INTO sbl_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Hay mangahampat ya tawtawo ay makit la bayti ya mangyari komo; hila ay mikalimo boy ka-iliyan la ka, ya wanla, ");
INSERT INTO sbl_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Helken moyo bayti ya tawoy ahè napahimalà ha Diyos, no alwan hay pinahimala-an na ay kayamanan na, boy an-ipalagay na nin hay kala-etan na ay makapidipinsa kona.” ");
INSERT INTO sbl_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Piro hiko ay bilang ha malaboyong ya po-on kayoy olibo ya anti ha danin bali nin Diyos; ayin anggay pamahimalà ko ha ingangalo nin Diyos ya ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Pirmi katan pasalamatan ha ginawà mo, Diyos ko; ha nag-in tawtawo mo ay ibabalità koy kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","(Kanta ni Dabid ya pakapowotan aral) Hay tawoy maghalità ha sarili na nin, “Ayin Diyos!” ay talagan tangah. Hay tawtawoy ombayro ay talagan mala-et, boy hay gawgawà la ay poro kala-etan; ayin ana konla nin ampanggawà kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Hay Diyos ya anti ha katatag-ayan ha kama-inan na ay ampanlonglong ha tawtawo ta an-imatonan na no ma-in et nin tawtawoy ampaka-intindi nin kaptegan, boy no ma-in nin ampag-apeh nin makabalay kona. ");
INSERT INTO sbl_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Kaganawan ay ampakarayò ha Diyos ta ampagpakala-et hila. Ayin ampanggawà nin kahampatan; ayin ni miha. ");
INSERT INTO sbl_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Hay pastang nin Diyos ay ombayri: “Kaganawan nayì nin ampipanggawà kala-etan ay ayin tinandà? Hay tawtawo ko ay anggaw-an lan mala-et ta ombayro ya natoral la, boy aghila ampakirawat kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Hay mangala-et ay masyadon nikalimo maski ayin dapat kalimowan. Hay Diyos ay nangikakatak nin bawbot-o nin nipangalaban komoyo; impareng-ey moyo hila, ta hila ay ahè tinanggap nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Dayi, hay kalibriyan nin Aw-israylita ay mangibat ha dogal ya an-ingaten Siyon ya kama-inan nin Diyos. No mambin oman ya Diyos nin ka-inomayan ha tawtawo nay Aw-israylita ya inalalak ni Hakob, dayi, hila bayti ay mipagtowà. ");
INSERT INTO sbl_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","(Kanta ni Dabid ya pakapowotan aral hin ma-in nangisoplong koni Arì Sawol no ayri ya ampagtago-an na) Diyos ko, ilibri mo ko nin kapangyariyan mo boy paptegan mo ya hiko ay ayin kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Leng-en moy panalangin ko, Diyos ko; pakaleleng-en moy anhalita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Hay dawdayowan ay ampandawohong kongko, boy hay tawtawoy mapangapih ay labay mamati kongko. Habaytoy tawtawo ya ombayro ay ayin kowinta konla ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Tandà ko ya hay ampanambay kongko ay Diyos; hiya ya Pangino-on ya ampangidipinsa kongko. ");
INSERT INTO sbl_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Hay kala-etan ya ginawà kongko nin kawka-away ko ay ombayro dayi ya iparosa konla nin Diyos. Ha katapatan mo, hila ay apo-en mo. ");
INSERT INTO sbl_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Pangino-on, hiko ay ma-in kalabayan nin mangidolog komo. Pasalamatan kata nin banà ha kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Hika ya nangilibri kongko ha kaganawan kagolowan ko, boy nakit koy kawka-away ko ya impatalo mo. ");
INSERT INTO sbl_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","(Kanta ni Dabid ya pakapowotan aral) Diyos ko, leng-en moy panalangin ko, boy agmo dayi halibokotan ya an-ida-ing ko. ");
INSERT INTO sbl_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Leng-en mo ko boy tobayen ta hiko ay mapagal ana ha kahalakan ko. Ampikotoh ya ihip ko ");
INSERT INTO sbl_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","banà ha tawtangkà boy pawpangangapih kongko nin kawka-away koy mangala-et. Ambara-an la kon makasalanan, boy ha kapahangan la kongko ay ampag-inakitan la ko. ");
INSERT INTO sbl_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Hay nakem ko ay nagkama-in nin masyadoy kalele-an boy biglà akon nakatanam nin tanam nin tawoy maraninan mati. ");
INSERT INTO sbl_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Nalimo ko boy namegpeg; ha kalimowan ko ay nakapatalon nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Kayà hinalità ko ya ombayri: “No ma-in akon bongat pakpak nin bilang ha kalapati ay lompad akoynan manikap nin pama-inawawan ko. ");
INSERT INTO sbl_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Lompad akon mako ha marayò ta pa-iri ko ha powiray dogal. ");
INSERT INTO sbl_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Manandalì akon manikap nin mapa-iriyan koy agko mapangno ya marayò ha ampanggolo kongko ya kowinta makhaw ya bagyo.” ");
INSERT INTO sbl_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Pangino-on, hira-en moy pawplano nin mangala-et boy golowen moy aw-ilgo la emen aghila mangapi-i-intindi, ta angkakit koy kagolowan boy pami-a-away ha siyodad. ");
INSERT INTO sbl_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Allo yabi ay anliboten la baytoy siyodad ya hay ampagdanan la ay ha babo nin alal ya padir; habaytoy siyodad ay poro kala-etan boy kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Anti bayro ya kaganawan klasin kala-etan; ayin tegen ya pawpangangapih boy panana-ol bayro. ");
INSERT INTO sbl_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","No ka-away ko dayi ya ampanginsolto kongko ay kaya kon te-ehen; boy no kalaban ko dayi ya ampaghambog kongko ay kaya kon tago-an. ");
INSERT INTO sbl_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Piro alwa, ta hika ya kapariho ko ya kalamolamo ko boy amigo kon karnal. ");
INSERT INTO sbl_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Hin hato ay ampi-ilgo tan ma-in kaligawan boy ampilamo tan makilako ha kalak-an ya ampako ha bali nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Dayi, habayti ya kawka-away ko ay biglà nin latngan nin kamatyan, boy angkabiyay hila dayi ya mataphonan nin lotà ta hay makapangyayari konla ay kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Hiko balè ay makirawat nin tambay ha Pangino-on Diyos boy hiya ya mangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Mahilem, bayombokah, boy ogtoy-allo ay an-omaloloy akon andoma-ing kona, boy tandà ko ya leng-en na ko boy tobayen. ");
INSERT INTO sbl_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ibira na ko nin ahè mapangno ya ma-ibat nin makilaban ha malakè ya ka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Hay Diyos ya ayin anggawan ya pamomo-on ay manlengè kongko boy talowen na hila; banà ta ayin nangyari konla ha mala-et ya gawgawà la ay aghila anggomalang ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Habayti ya da-an kon kalamowan ay ampangalaban nin aw-amigo na; hinirà nay pangakò na. ");
INSERT INTO sbl_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Hay aw-ilgo na ay malahap, piro hay anti ha nakem na ay inakit; hiya ay ma-amalang nin maghalità, piro habaytoy hawhalità na ay ampakakhit nin bilang ha matarem ya hondang. ");
INSERT INTO sbl_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Ipa-olay mo ha Pangino-on ya ampakagolo komo, ta hiya ya mangalalay komo; ta hay tawoy mahampat ay agna pa-olayan nin matalo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Piro hay mawmamatin tawo boy mangabongkok, biha hila mi-abot ha kalagitna-an nin biyay la ay apo-en mo hila, Diyos ko. Hiko balè ay pahimalà komo. ");
INSERT INTO sbl_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","(Habayti ay hinolat ni Dabid hin dinakep ya nin Pawpilistiyo) Diyos ko, ingalowan mo ko ta pirmi kon andawohongen boy ampadya-dya-an nin kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Pirmin ma-in ampandawohong kongko boy hay ampangalaban kongko ay malakè. ");
INSERT INTO sbl_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","No angkalimo ko, Pinakamakapangyariyan ya Diyos, hika ya pahimala-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ampahimalà ako ha Diyos boy amporiyen ko ya ha pawpangakò na. Hiko ay ampahimalà kona; kayà agko angkalimo. No tawon bongat ya kapariho ko ay ahè makapangno kongko. ");
INSERT INTO sbl_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Hay anhalita-en ko ay an-idabò lan mala-et ta habaytoy ampanggolowan la kongko, boy hay pirmi lan an-ihipen ay pakakhitan la ko. ");
INSERT INTO sbl_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Hila ay ampititipon ha matagò ya dogal, ta an-imatonan lay kaganawan anggaw-en ko, boy an-intrisen lay biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Parosawan mo hila, Diyos ko, nin banà ha kala-etan la, boy hay pamatalo mo konla ay pahang mo. ");
INSERT INTO sbl_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","An-ilista moy pantomalà ko boy tawtolò nin lowà ko. Alwa nayì nakalista bayti ha libro mo? ");
INSERT INTO sbl_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","No hiko ay ampakirawat nin tambay ha Diyos, hay kawka-away ko ay ampipampog-alih. Bayro ko angkapaptegan ya hay Diyos ay anti kongkon kakampi ko. ");
INSERT INTO sbl_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ampahimalà ako ha Diyos boy amporiyen ko ya ha pangakò na. Poriyen koy Pangino-on ha pangakò na. ");
INSERT INTO sbl_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ampahimalà ako ha Diyos; kayà agko angkalimo. No tawon bongat ya kapariho ko ay ahè makapangno kongko. ");
INSERT INTO sbl_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Diyos ko, hay impangakò ko komo ay igwà ko. Igwà ko komo ya pamomori ko, ");
INSERT INTO sbl_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","ta inlibri mo ko ha kamatyan boy agmo ko impatalo. Kayà mintras anti ko bayri ha babon lotà ay mamiyay ako nin anti kongkoy Diyos ta ampolalagan na ko. ");
INSERT INTO sbl_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","(Habayti ay hinolat ni Dabid hin tinago-an na hi Arì Sawol ha kowiba) Ingalowan mo ko, Diyos ko; igwà moy ingangalo mo kongko ta hiko ay ampakarani komo emen ako malibri. Kopkopen mo ko anggan malabah ya kawkapiligrowan. ");
INSERT INTO sbl_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ampakirawat ako ha Diyos ya Pinakamakapangyariyan. Hiya ya Diyos ya ampambi kongko nin kaganawan panganga-ilangan ko. ");
INSERT INTO sbl_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Diyos ya mangilibri kongko boy talowen nay ampipandawohong kongko. Ipakit na kongko ya katapatan na boy ingangalo nay ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Hiko ay ampirà ha pibotlayan nin kowinta lawliyon ya nakahandà anan mangidakmà nin tawtawo. Hay ngawngipen nin habayti ay emen pawpikà boy emen yawyawò; hay dawdilà la ay emen ha hawhondang ya matarem. ");
INSERT INTO sbl_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Diyos ko ya ayin kapantay, ipatnag moy kapangyariyan mo ha katatag-ayan; ha babon lotà itaman ay ipatnag moy kahawangan nin kagandawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Hay kawka-away ko ay nangikanà nin kowinta bateng ya pandakep la kongko; kayà halos mapatalo ako nin kalele-an ya angkatanam ko. Nangotkot hila et nin malalè ya lobot ha pagdanan ko, piro hilan mismo ya narabò bayro. ");
INSERT INTO sbl_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Diyos ko, hiko ay talagan ampahimalà komo; kayà magkanta ko nin pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","“Mibangon ka,” wangko ha sarili ko. “Mibangon ka ta manogtog ka nin alpa boy lira.” Mahambak akon mibangon ta mamori ko ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Pasalamatan kata, Pangino-on, ha tawtawo, boy magkanta kon pamomori komo ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Hay ingangalo mo ya ma-in panlalabi ay ahè makwan ihipen; ombayro simpri ha katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Diyos ya ayin kapantay, ipatnag moy kapangyariyan mo ha katatag-ayan; ha babon lotà itaman ay ipatnag moy kahawangan nin kagandawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","(Habayti ay hinolat ni Dabid) Hikawo ya ampipamo-on, tamà nayì ya dawdisisyon moyo? Matoynong nayì ya panonosga moyo? ");
INSERT INTO sbl_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Alwa! Ta hay an-ihipen moyon bongat gaw-en ay kala-etan, boy hay panonosga moyoy alwan tamà ay lalò ampakakhit ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Hay tawtawoy mangala-et ay alwan tamà ya pamamaraan ha biyay ta pa-ibat et hin in-anak hila ay mangabongkok hilayna. ");
INSERT INTO sbl_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Hay kala-etan la ay bilang ha dità nin otan; hila ay bilang ha otan ya makapi ya ahè ampakalengè ta anherengan lay tolih la. ");
INSERT INTO sbl_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Hay ombayroy klasin otan, hay anggaw-en nin magaling ya manggagayoma ay ayin kowinta, ta ahè angkalengè nin hatoy otan ya panggayoma kona. ");
INSERT INTO sbl_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Diyos ko, no pangno angka-alihan powirsa ya mangalagò ya lawliyon ha pangalih nin bangil la ay ombayro dayi, Pangino-on, ya gaw-en mo ha mangala-et ya kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Pa-olayan mo hilan ma-anam nin bilang ha lanom ya inalep-ep nin maklang ya lotà boy bilang ha yawò ya ahè makahogat ta ayin tarem. ");
INSERT INTO sbl_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Hila dayi ay mag-in nin bilang ha sosò ya ha dinanan nin habayto ay angkakit ya angkabalag ya emen laman ya angkatonaw. Hila dayi ay mag-in simpri nin bilang ha kolaw ya natin in-anak ya ahè nakakit hawang. ");
INSERT INTO sbl_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Banà ha pahang nin Diyos konla, hila ay malabah nin bilang ha an-i-ohong ya dawdowih ya tampol angka-opoh ta ansoplawen angin. ");
INSERT INTO sbl_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Hay tawtawoy mangahampat ay mipagtowà no makit lay tawtawoy mangala-et ya amparosawan. Hila ay talagan maligawan ha makit lay kamatyan nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Hay tawtawo ay mipaghalità nin ombayri: “Talagan hay tawtawoy mangahampat ay primyowan, boy talagan ma-in Diyos ya manosga ha tawtawo bayri ha babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","(Habayti ay hinolat ni Dabid hin impabantayan ni Arì Sawol ya bali ni Dabid emen na ya mapati) Diyos ko, ilibri mo ko ha kawka-away ko, boy protiksyonan mo ko ha ampipandawohong kongko. ");
INSERT INTO sbl_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Ilibri mo ko ha ampipanggawà nin kala-etan, boy ha mawmapamatin tawo. ");
INSERT INTO sbl_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Helken mo! Hila ay ampipangabang kongko; hay tawtawo itaman ya mangabagsit ay nititipon nin angkomontra kongko. Pangino-on, habayti ay anggaw-en la kongko maski agko nagkasalanan o nagkamalì. ");
INSERT INTO sbl_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ayin akon nagawà ya kamali-an piro hila ay nakahandà nin mandawohong kongko. Manandalì ka ta asikasowen mo kon tambayan. ");
INSERT INTO sbl_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Hika, Pangino-on Diyos ya Pinakamakapangyariyan ay Diyos ya ampahimala-an nin aw-inalalak ni Israyil. Manandalì ka ta lakwen mon parosawan ya kaganawan nasyon; agmo ingalowan ya mangala-et ya tawtawoy tawtraydor. ");
INSERT INTO sbl_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Hila ay ampipagbira ha banowa no anyomabi ana, boy mintras anliboten la baytoy banowa ay emen hilan aw-aho ya ampibabakbak. ");
INSERT INTO sbl_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Leng-en moy katarasan lan mag-ilgo! Hay hawhalità la ay bilang katarem nin hawhondang. Ombayro man ay ampagpastang hila, ya wanla, “Warì ma-in makalengè konnawen?” ");
INSERT INTO sbl_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Piro hika, Pangino-on ay ampangka-ili konla, boy hay kawka-away ko ya na-ibat ha kanayon ya nasyon ay antoya-toya-en mo. ");
INSERT INTO sbl_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Hika, Diyos ko, ya kakhawan ko boy dipinsa ko ya ampahimala-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Hay Diyos ko ya malabi kongko ay pakarani kongko ta ipakit na kongko no pangno na talowen ya kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Agmo hila nin antimanon patyen emen mag-in aral ha tawtawo ya mangyari konla. Pangino-on ya pinagkahalanggà nawen, pikakataken mo hila nin kakhawan mo emen la matanda-an ya talo mo hila. ");
INSERT INTO sbl_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Hay anhalita-en la ay poro kala-etan; kayà mahagep hila dayi ha kahambogan la. Banà ha pamingga la boy ha kabongkokan la ");
INSERT INTO sbl_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","ay hira-en moy pawplano la ta apo-en mo hila emen ayin anan makit konla. Ha ombayro ay matanda-an nin tawtawo ya hay Diyos ay ampamo-on ha aw-inalalak ni Hakob boy ha kaganawan tawo bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Hila ay ampipagbira ha banowa no anyomabi ana, boy mintras anliboten la baytoy banowa ay emen hilan aw-aho ya ampibabakbak. ");
INSERT INTO sbl_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Hila ay ahè antomanà manikap nin pamamangan la; emen hila ha mabitil ya aw-ahoy ampantawo no ahè mabhoy. ");
INSERT INTO sbl_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Piro hiko ay magkanta nin banà ha kapangyariyan mo ya impatnag mo. Binabayombokah ay ipakakhaw koy pagkanta ko banà ha ingangalo moy ma-in panlalabi. Hika ya dipinsa ko boy kalibriyan ko ha pana-on nin kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Hika ya kakhawan ko; kayà magkanta ko nin pamomori komo. Diyos ko, hika ya dipinsa ko boy hika ya ampambi kongko nin ingangalo ya ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","(Habayti ay hinolat ni Dabid) Diyos ko, hikayi ay tinanggi-an mo boy impatalo; namahang ka konnawen, piro hapa-eg ay ibira moy kakhawan nawen. ");
INSERT INTO sbl_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Hay nangyari konnawen ay ayin imbalag ha lotà ya na-eyeg; kayà napaka. Hapa-eg ay andawaten ko komo ya i-ayos mon oman bayti ya nika-eyeg emen kayi mag-in matibay. ");
INSERT INTO sbl_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Hikayi ya tawtawo mo ay pinaranas mo nin masyadoy kadya-dya-an, ta hikayi ay kowinta pina-inom mo nin alak ya nakalahing konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Hika ay nambin palatanda-an ha ampipanggomalang komo emen la mapa-alilihan ya isintinsya konla. ");
INSERT INTO sbl_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ilibri mo kayi nin kapangyariyan mo; tobayen moy panalangin ko emen hay tawtawoy anlabiyen mo ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Hay Diyos ya anti ha masagradoy bali na ay naghalità nin ombayri: “Hay siyodad nin Sikim ay atag-atagen ko nin ma-in katowa-an kateng patal ya dogal ya an-ingaten Sokot ta igwà ko ha tawtawo ko. ");
INSERT INTO sbl_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Hay pinagdogalan ni Gala-ad boy ni Manasis ay ikon ko. Hay pinagdogalan ni Ipra-im ay kowinta hilmit ko; hay pinagdogalan itaman ni Hoda ay bayro ampangibat ya kawkapanogo-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Hay dogal ya an-ingaten Mowab ya kowinta palanggana ya pag-oyahan ko ay nasakop koyna. Hay dogal itaman ya an-ingaten Idom ay bayro ko inggawà ya sandalyas ko bilang tandà ya habayto ay sasakopen ko. Warì hay tawtawo ha dogal ya an-ingaten Pilistiya ay mibobo-angaw nin magtowà ha pananalo la kongko?” ");
INSERT INTO sbl_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Hinoy mantan kongko ha siyodad ya napalibotan nin dipinsa boy hinoy mangigiya kongkon mako ha dogal ya an-ingaten Idom emen ko masakop bayto? ");
INSERT INTO sbl_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Diyos ko, alwa nayì hika ya tinomanggì konnawen boy agka nakilako ha hawhondalò nawen? ");
INSERT INTO sbl_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Tambayan mo kayin lomaban ha kawka-away nawen, ta hay tambay nin tawo ay ayin kowinta. ");
INSERT INTO sbl_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Hikayi ay manalo ha tambay nin Diyos ta talowen nay kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","(Kanta ni Dabid) Diyos ko, leng-en moy an-ida-ing ko, boy pakaleleng-en mo ya panalangin ko. ");
INSERT INTO sbl_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Hiko ya anti ha marayò ya dogal ay andoma-ing komo nin banà ha kalele-an ko. Gitan mo ko ha ma-in dipinsa ya kowinta malhay ya bato. ");
INSERT INTO sbl_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Hika ya ampambin protiksyon kongko ta hiko ay inggawà mo ha dogal ya agko mapangno nin kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Hay anhangaren ko ay pirmi ko dayi nin anti komo boy labay kon protiksyonan mo ko nin kopkopen. ");
INSERT INTO sbl_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Diyos ko, nalengè moy pawpangakò ko. Hika ya nambi kongko nin kawkahampatan ya an-igwà mo ha ampipanggomalang komo. ");
INSERT INTO sbl_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Hiko ya arì ay pakara-en mo dayi ya biyay emen ako mabiyay nin maboyot ya pana-on. ");
INSERT INTO sbl_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Hika, Diyos ko ay anti dayi kongko boy hay pamomo-on ko dayi ay ayin angga; kayà protiksyonan mo ko nin ingangalo moy ma-in panlalabi boy kaptegan mo. ");
INSERT INTO sbl_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","No mangyarin ombayro ay pirmi kon magkanta nin pamomori komo, boy allo-allo kon igwà komo ya impangakò ko. ");
INSERT INTO sbl_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","(Kanta ni Dabid) Talagan ha Diyos akon bongat ampahimalà; hay kalibriyan ko ay kona ampangibat. ");
INSERT INTO sbl_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Hiya ay kowinta malhay ya bato; hiyan bongat ya ampambin protiksyon kongko boy ampangilibri kongko. Hiya ya dipinsa ko; kayà agko mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Anggan makano moyo kalabanen ya mihay tawo ya labay moyon ipatombah nin bilang ha alal ya ino-inò anan angkatombah? ");
INSERT INTO sbl_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Labay moyon bongat hira-en ya karangalan na; an-ikaliga moyoy pagtotol moyon kabongkokan. No ampaghalità kawo, kanwarì, hikawo ay mahampat, piro hay anti ha nakem moyo ay pawpanlala-et. ");
INSERT INTO sbl_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ha Diyos akon bongat nin ampahimalà boy hay pag-asa ko ay kona ampangibat. ");
INSERT INTO sbl_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Hiya ay kowinta malhay ya bato; hiyan bongat ya ampambin protiksyon kongko boy ampangilibri kongko. Hiya ya dipinsa ko; kayà agko mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Hay kalibriyan ko boy karangalan ko ay anti ha Diyos. Hiya ay kowinta malhay ya bato ya ampamakhaw kongko boy ampambin protiksyon kongko emen agko mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Hikawoy kaganawan tawo, pirmi kawon pahimalà ha Diyos. Ibalità moyo kona ya kawkagolowan moyo ta hiya ya mambin protiksyon kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Hay tawtawo, mag-in ma-aypà o matag-ay ya katongkolan ay parihon ahè mapahimala-an. No pitimbangen mo hila ay pariho hilan ayin kowinta, ta maski pilamowen mo hila ay ma-opaw hila et ha inawawen. ");
INSERT INTO sbl_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Agka pahimalà ha gawgawà ya pangangapih, boy agka omasa nin makinabang ka ha pananakaw. No warì ta mapahanan ya kayamanan mo ay agka omasa bayro. ");
INSERT INTO sbl_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Alwan bongat miminghan kon nalengè ya hinalità nin Diyos ya hay kapangyariyan ay anti ha Diyos, ");
INSERT INTO sbl_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","boy anti kona ya ingangalo ya ma-in panlalabi. Hikan mismo, Pangino-on, ya mambin parosa o primyo ha balang tawo kompormi ha ginawà na. ");
INSERT INTO sbl_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","(Kanta ni Dabid hin anti ya ha powiray dogal ha Hoda) Pangino-on Diyos, hika ya Diyos ko ya an-onawen ko ha biyay ko. Talagan angkahabekan kata boy hay pagkahabek ko komo ay emen akon angka-angan nin bilang ha naklang ya lotà ya ampanga-ilangan nin lanom. ");
INSERT INTO sbl_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Nakit katayna ha tabirnakolo mo boy bayro ko nakit ya kapangyariyan mo kateng kagandawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Hay ingangalo mo ya ma-in panlalabi ay igit et ha biyay; kayà poriyen kata. ");
INSERT INTO sbl_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Leleg kon angkabiyay, hiko ay mamori komo, boy itag-ay koy gamet ko ha panalangin ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Hiko ay mag-in kontinto nin bilang ha tawoy napdà nangan nin makatang ya pamamangan, boy magkanta kon maligay kanta ya pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ha pamimirà ko ay angkapanemteman kata, boy no ma-in akon ampagpoyatan nin bantayan ay hika ya angkahole-lè ko. ");
INSERT INTO sbl_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Banà ta hika ya ampanambay kongko ay magtowà ako ha pangongopkop mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Hiko ay lalò anhomeneh komo, boy agko mapangno ta hika ya ampangalalay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Hay ampipagsikap nin mamati kongko ay mipalako ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Hila ay mikati ha pamakilaban boy hay bawbangkay la ay kona-en nin mangabangis ya aw-ayop. ");
INSERT INTO sbl_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Piro hiko ya arì ay matowà ha Diyos; kaganawan ampagpangakò kongko ya arì ay lomiga, balè hay bawbebey nin mangabongkok ay pepe-en. ");
INSERT INTO sbl_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","(Kanta ni Dabid) Diyos ko, leng-en moy panalangin ko ya an-ida-ing ko komo. I-atap mo ko ha kawka-away ko ta angkalimo ko konla. ");
INSERT INTO sbl_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Protiksyonan mo ko ha tangkà kongko nin tawtawoy mapanggawà kala-etan ta habayto ay pangkat nin mapanggolo. ");
INSERT INTO sbl_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Hay dawdilà la ay kowinta matarem ya hondang, ta hay hawhalità ya anggamiten la ay ampakakhit, boy hay anhalita-en la ay kowinta yawyawò ya nakapapatoyò. ");
INSERT INTO sbl_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Hay mangahampat ya tawtawo ay an-abangan lan pana-en ha matagò ya dogal; hila ay biglà lan pana-en nin ayin kalimowan. ");
INSERT INTO sbl_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Ampi-o-olagyat hila nin gaw-en ya mala-et ya tangkà la, boy ampi-i-ilgowan la no ayri ya matagò ya dogal ya pangikana-an la nin papanosori la, ya wanla, “Ka-ilangan ayin makakit nin habayti ya gaw-en tamo.” ");
INSERT INTO sbl_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Hila ay ampagplano nin kala-etan, boy hinalità la ya ombayri: “Ayos bayti ya pawplano tamo.” Hay nakem boy ka-ihipan nin tawo ay ahè makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Piro hila ay kowinta pana-en nin Diyos; kayà biglà hilan mangahohogatan. ");
INSERT INTO sbl_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Hay anhalita-en nin dawdilà la ya kowinta matarem ya hondang ay mismon habayto ya mandisgrasya konla. Kaganawan nin makakit konla ay mipampeyeng biha mipampog-alih. ");
INSERT INTO sbl_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kaganawan tawo ay mikalimo boy ibabalità la ya habayto ay gawà nin Diyos. Hay tongkol ha ginawà nin Diyos ay pakahohole-le-en la. ");
INSERT INTO sbl_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Hay tawtawoy mangahampat ay mipagtowà boy lalò pahimalà ha protiksyon nin Pangino-on. Kaganawan tawoy ma-in kahampatan ay mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","(Kanta ni Dabid) Pangino-on Diyos, hika ay nararapat paporiyan nin tawtawo ha dogal ya an-ingaten Siyon, boy hay impangakò la ay dapat lan igwà komo. ");
INSERT INTO sbl_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Hika ya ampanlengè nin panalangin, kaganawan tawo ay pakarani komo. ");
INSERT INTO sbl_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Maski masyadoy kasalanan nawen ay ampatawaren mo kayi et. ");
INSERT INTO sbl_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Makalmà ya tawoy pinilì mo ta gitan mon pa-iri ha kama-inan mo. Hikayi ya pinilì mo ay maraygan ha mangaganday bawbagay ya anti ha bali mo ya masagradoy kama-inan mo. ");
INSERT INTO sbl_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Pangino-on Diyos ya Mapangilibri, ha kahampatan mo ay antobayen mo kayi ha pangipakit mo nin kawkapapa-ispantay gawgawà mo. Kaganawan tawo ha babon lotà kateng tawtawoy anti ha dagat ay ayin kanayon ya ampahimala-an no alwan hika. ");
INSERT INTO sbl_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Impakit moy kapangyariyan mo ha panggawà mo nin bawbakil, boy habayti ay pinatibay mo nin kakhawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Hika ya ampamatinek nin dalleg nin dagat boy ogong nin dawdawoyon. Hika simpri ya ampamatinek nin tawtawoy ma-in kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Hay tawtawo ha lawlenek ya dogal ay ampikalimo ha kawkapapa-ispantay gawgawà mo, boy hay allo ay kowinta ampambo-angaw nin ampagtowà pa-ibat ha homilà angga ha homlep. ");
INSERT INTO sbl_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Hay lotà ay an-asiwa-en mon bohbohan emen habayti ay tomabà. Hay bawbalah ay ginawà nin Diyos nin pagpalanom nin tawtawo ha tawtanaman la emen magkama-in hilan malakè ya ma-alawah. Habayti ya ombayri ay talagan gawà nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Hika ya ampambi nin sapat ya oran ha aw-inararoy lotà; ha ombayro ay ampomità ya lotà boy hay tawtanaman ya kapitanem ay tomobò. ");
INSERT INTO sbl_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Banà ha kahampatan mo ay malakè ya angka-alawah. Maski ayri ka mako, hay alawah ay malakè. ");
INSERT INTO sbl_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Hay powiray dogal ya pagpastolan ay antomobò ya dikot ta angka-oran. Ombayro simpri ha bawbakilbakil; habayti ay kowinta ampagtowà. ");
INSERT INTO sbl_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Hay pagpastolan ay ponò nin tawtopa; hay patal ya dogal ay tinamnan nin pali ya hay gandan binongawan. Kayà habayti ay kowinta ampambo-angaw ha katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Kaganawan tawo bayri ha babon lotà ay mibobo-angaw nin mipagtowà ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Magkanta kawon pamomori ha ngalan na, boy biyan moyo yan karangalan ha pamomori moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Hay halita-en moyo ha Diyos ay ombayri: “Masyadon kapapa-ispanta ya gawgawà mo. Banà ha masyadoy kapangyariyan mo, hay kawka-away mo, ha kalimowan la, hila ay homokò komo. ");
INSERT INTO sbl_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Kaganawan tawo ya anti bayri ha babon lotà ay homamba komo; hila ay magkanta nin pamomori komo; magkanta hila nin pamomori ha ngalan mo.” ");
INSERT INTO sbl_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Biliwen moyoy ginawà nin Diyos; masyadon kapapa-ispanta ya ginawà na ya para ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Hay lanom nin dagat ay pinihiyay nin Diyos; ombayro simpri ha lanom nin balah, ta ha kinomlang ya lotà ay bayro nowakon nagdaan ya kawka-apo-apowan tamo. Banà bayro ha ginawà na, hitamo ay nilomiga. ");
INSERT INTO sbl_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Hay pamomo-on nin Diyos ay ayin anggawan, boy ma-in kapangyariyan ya pamomo-on na. An-obsirbawan nay tigè nin nawnasyon; kayà hay dapat ay ayin lomaban kona ta ayin makapatalo kona. ");
INSERT INTO sbl_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Poriyen moyoy Diyos tamo, hikawoy tawtawo ha nawnasyon; ipalengè moyo ya pamomori moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","An-i-atap nay biyay tamo ha kamatyan, boy an-alalayan na tamo emen mowako tamo man ha kowinta marawonot ya daan ay agtamo matombah. ");
INSERT INTO sbl_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Pangino-on Diyos, hikayi ay hinobok mo nin bilang ha pilak ya imparaan ha apoy. ");
INSERT INTO sbl_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Pina-olayan mon mahagep kayi nin kowinta bateng ya ingkanà ta pandakep konnawen, boy hinobok mo kayi nin kowinta pinababah nin mabyat ya karga. ");
INSERT INTO sbl_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Pina-olayan mo kayin natalo nin kawka-away nawen boy hinobok mo kayi ha kowinta apoy boy ha kowinta lanab, piro hapa-eg ay gintan mo kayi ha dogal ya ma-in ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Hiko ay mako ha bali mo ta mantan akon ipo-ol ya idolog komo, boy toparen ko ya pawpangakò ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Igwà ko komo baytoy hinalità ko hin anti ko ha kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Hiko ay mangidolog komo nin mangatabà ya aw-ayop ya po-olan ya bilang ha tawtopa, tawtoron bakà, boy kawkanding. ");
INSERT INTO sbl_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Kaganawan moyon anggomalang ha Diyos, pakarani kawo bayrin manlengè ta ibalità ko komoyoy ginawà nin Diyos ya para kongko. ");
INSERT INTO sbl_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Hiko ay dinoma-ing kona nin tambay boy hiko ay handà nin magkantan pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","No ma-in akon an-itagò ya kasalanan ha nakem ko, manalangin ako man ha Pangino-on ay agna ko leng-en. ");
INSERT INTO sbl_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Piro talagan nilengè ako nin Diyos, ta tinobay nay panalangin ko. ");
INSERT INTO sbl_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Poriyen ya Diyos, ta agna tinanggi-an ya panalangin ko, boy agna intangat kongko ya ingangalo na ya ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Pangino-on Diyos, ingalowan mo kayin biyan kahampatan; dayi ay mangonsowilo ka konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Ha ombayro, hay kalabayan mo ay matanda-an nin tawtawo ha babon lotà, boy hay pangilibri mo ay matanda-an ha kaganawan nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Dayi hay tawtawo ay mamori komo, Pangino-on Diyos; kaganawan dayi nin tawo ay mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Hay tawtawo dayi ha nawnasyon ay mipagtowà nin magkantan ma-in kaligawan, ta hay pamomo-on mo ha tawtawo ay matoynong, boy hika ya ampangitoto nin tawtawo ha nawnasyon bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Dayi, hay tawtawo ay mamori komo, Pangino-on Diyos; kaganawan dayi nin tawo ay mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Hapa-eg hay babon lotà ay magkama-in alawahanen, boy hay Diyos ya Diyos nawen ay mambin kahampatan konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Hikayi ay biyan nin Diyos nin kahampatan, boy hay tawtawo ha kaganawan dogal ha babon lotà ay gomalang kona. ");
INSERT INTO sbl_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Hay Diyos ay manandalì dayi nin pikakataken nay kawka-away na; dayi, hay ampipag-inakit kona ay mipampowayon pakarayò kona. ");
INSERT INTO sbl_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","No pangno nin hay ahok ay angka-i-alipad nin angin ay ombayro ya gaw-en na konla, boy no pangno nin hay ispirma ay angkatonaw no igwà ha apoy ay ombayro dayi apo-en nin Diyos ya tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Piro hay mangahampat ya tawtawo ay magkama-in kaligawan ha arapan nin Diyos boy dayi, hila ay mipagtowà. ");
INSERT INTO sbl_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Kantawan moyoy Diyos; kantawen moyoy pamomori ha ngalan na boy ihandà moyoy pagdanan na. Hiya ay kowinta ma-in anhakyan nin magpalako ha powiray dawdogal. Hay ngalan na ay Pangino-on; magtowà kawo ha arapan na. ");
INSERT INTO sbl_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Hay Diyos ya anti ha masagradoy kama-inan na ay ampangasiwà ha aw-olila boy ampangi-atap ha bawbawoy babayi. ");
INSERT INTO sbl_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Hay Diyos ay ampambin pa-iriyan ha tawoy malelè ta sosolo na ha biyay; hay pawpiriso itaman ya aw-apih ay ampalaya-en na nin ma-in kaligawan, piro hay ampipagribildi ay ampa-olayan nan pa-iri ha ayin kowintay dogal ya ahè ma-arì kabiyayan nin maski anyay klasin tanaman. ");
INSERT INTO sbl_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Pangino-on Diyos, hin pinangonawan moy tawtawo mo ha pamomowako la ha powiray dogal, ");
INSERT INTO sbl_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","hay lotà ay na-eyeg, boy ma-in oran ya nangibat ha katatag-ayan ha panggogomawà mo. Habayti ya pagka-eyeg ay nangyari ha bakil nin Sinay, ta hika ya Diyos ya ampahimala-an nin aw-inalalak ni Israyil ay anti bayro. ");
INSERT INTO sbl_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Hika simpri, Pangino-on Diyos ya nambi nin saganà ya oran emen mabahà ya lotà ya inggawà mo ha tawtawo moy Aw-israylita, ta habayto ay kinomlang. ");
INSERT INTO sbl_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Banà bayro, hay tawtawo mo ay napa-iri bayro; boy ha kahampatan mo, Pangino-on Diyos, hay manga-irap ay ambiyan mon pawpanganga-ilangan la. ");
INSERT INTO sbl_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Hay Pangino-on ay nambin panogò; malakè ya babayi ya nantan nin ombayri ya balità: ");
INSERT INTO sbl_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Hay aw-arì boy hawhondalò la ay nipampowayo; hapa-eg, hay bawbabayi ya ahè nakilakon nakilaban ay ni-a-atag ha kawkagamitan ya nikakwan aw-ahawa la ha kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Maski aghila nakilakon nakilaban ta nabalag hilan nagpastol nin tawtopa, hila ay nag-in nin bilang kapostora nin kalapati ya hay pakpak ay emen pilak boy gintò banà do ha ma-alagà ya kawkagamitan ya pini-a-atagan la.” ");
INSERT INTO sbl_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Habaytoy aw-arì ya nipampowayo ay pinikakatak nin Pinakamakapangyariyan ya Diyos ha bakil nin Salmon boy bayro hilayna nikati; kayà habaytoy bakil ay pinomotì banà ha bawbot-o la. ");
INSERT INTO sbl_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Hay malhay ya bakil ya anti ha Basan ay maganda boy malakè ya tong-oytong-oy. ");
INSERT INTO sbl_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Habayti ya bakil ay kowinta ampanyamo-yamò ha bakil ya pinilì nin Diyos nin pa-iriyan na nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Hay Pangino-on ya nangibat ha bakil nin Sinay ay ma-in kalamoy liboliboy nipagkarwahi ya ampagpalako ha masagradoy dogal na. ");
INSERT INTO sbl_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Hin norong ya ha katatag-ayan ha kama-inan na ay malakè ya kowinta pawpiriso ya gintan na bayro. Hiya ay nananggap nin rawrigalo ya inggawà nin tawtawo kateng tawtawoy rawribildi. Hay Pangino-on Diyos ay pa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Poriyen ya Pangino-on Diyos ya Mapangilibri kontamo, ta maski allo-allo nin ma-in anlomateng kontamo ya pawproblima ay antambayan na tamo. ");
INSERT INTO sbl_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Hay Diyos tamo ay Diyos ya Mapangilibri; hiya ya Pangino-on tamo ya nangilibri kontamo ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Hay kawka-away nin Diyos ay sigoradon peha-en nay aw-olo; hila ya sigisigi ha pagkasalanan ay alihan nan kolon olo. ");
INSERT INTO sbl_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Hinalità nin Pangino-on, ya wana, “Hay kawka-away moyon Aw-israylita ay ibira ko nin mangibat ha Basan; ibira ko hila nin mangibat ha kalale-lale-an dagat ");
INSERT INTO sbl_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","emen pangati la, hay dawdayà la ay hoyhoyen moyon salodsoden, boy hay aw-aho moyo ay manlaklak nin habayto.” ");
INSERT INTO sbl_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Diyos ya Arì ko, hay paninigè mo nin magpalako ha masagradoy dogal mo ay nangyarin nakit nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Hay mawmagkakanta ay anti ha bandan onawan, ha bandan hoyotan itaman ay mawmanonogtog, boy ha mamalibot nin kaganawan ay bawbabayi ya mangalagò ya ampipanogtog nin mihay klasin tambol. Hapa-eg, hay hinalità la ay ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","“Poriyen ya Diyos ha pamititipon nin tawtawo na; hikawoy aw-inalalak ni Israyil, poriyen moyoy Pangino-on.” ");
INSERT INTO sbl_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Ha paninigè nin aw-inalalak ni Israyil nin magpalako ha masagradoy dogal nin Diyos, hay angka-ona ay lipì ni Binhamin ya pinaka-a-amò ya lipì; hay anhomono konla ay malakè ya po-on ha Hoda ya anhonowen itaman nin ampipamo-on ha Sabolon boy ha Niptali. ");
INSERT INTO sbl_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Pangino-on Diyos, ipakit mo dayi ya kapangyariyan mo; hay kakhawan ya inggawà mo konnawen hin hato ay igit et dayi bayro ya igwà mo konnawen hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Hay bali mo ya anti ha siyodad nin Hirosalim ay bayro anggitan nin aw-arì ya rigalo la komo. ");
INSERT INTO sbl_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Hay tawtawo ha nawnasyon ay ha-aren mo dayi, ta hila ay kowinta mangahilib ya aw-ayop ya ampa-iri ha matabon ya dogal ha pawpingit hapà, boy hila ay bilang ha tawtoron bakà ya ampamo-on ha aw-oybon bakà. Hila bayti dayi ay pasakop komo ha pambi la komo nin rigalo lay pilak. Hay tawtawoy labaylabay ya gira ay pikakataken mo. ");
INSERT INTO sbl_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Hay hawhogò ya mangatag-ay ya pagkatawo ay mika-ibat ha nasyon Ihipto; hay tawtaga Itopya ay mipangitag-ay nin gawgamet ha panalangin la ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Kantawan moyo ya Diyos, hikawoy tawtawo ha kaganawan ka-ari-an bayri ha babon lotà; kantawen ya pamomori ha Pangino-on ");
INSERT INTO sbl_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","ya anti ha katatag-ayan ha kama-inan na pa-ibat et hin hato. Hay makhaw ya bosis na ya bilang ha korol ay malengè ya mangibat bayro. ");
INSERT INTO sbl_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Hay Diyos ya makapangyariyan ay ipapteg moyo ha panhohomamba moyo kona; hay kapangyariyan na ay ampangi-atap ha aw-inalalak ni Israyil, boy habayti ay ampipatnag ha langit. ");
INSERT INTO sbl_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Hika, Diyos ay kapapa-ispanta ha masagradoy kama-inan mo; hika simpri ya Diyos ya ampahimala-an nin aw-inalalak ni Israyil, boy hika ya ampambi nin kakhawan boy kapangyariyan ha tawtawo mo. Poriyen ya Diyos! ");
INSERT INTO sbl_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","(Kanta ni Dabid) Ilibri mo ko, Diyos ko, ta hiko ay anti ha kowinta kale-ey ya lanom. ");
INSERT INTO sbl_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Hiko ay kowinta ampitamek ana ha pità ta ayin akon mapagtorakan ya matyà; kayà kowinta angkagtan akon agoh boy marani koynan malemeh. ");
INSERT INTO sbl_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Ha pandawat ko nin tambay, hiko ay makapey ana boy napalgahan ana; kateng mata ko ay halos agana makabalay ha pangantì ko nin tambay mo, Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Hay ampipag-inakit kongko maski ayin bara-nan ay malakè et kisa ha bilang nin habot ko; hay kawka-away ko ay mangakhaw. Hila ay mangabongkok boy labay la kon patyen; labay la kon pabayaren ha bawbagay ya agko kinwa. ");
INSERT INTO sbl_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Hay kasalanan ko ay alwan polinged komo, Diyos ko, boy tandà moy katangahan ko. ");
INSERT INTO sbl_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Pinakamakapangyariyan ya Diyos, dayi, hay ampipampahimalà komo ay agmo payagan mareng-eyan nin banà kongko. Hika ya Diyos ya ampahimala-an nin aw-inalalak ni Israyil, agmo dayi simpri payagan nin hay ampikahabek komo ay mareng-eyan nin banà kongko. ");
INSERT INTO sbl_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Banà komo, hiko ay antoya-toya-en boy napnò akon kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Hay an-ipalagay kongko nin pawpartidos ko ay bilang akon bongat nin dayowan; maski sarili kon pawpatel ay an-ipalagay la nin hiko ay istranghiro. ");
INSERT INTO sbl_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Kaganawan kakayawan ko ay gaw-en ko ha pangimalasakit ko nin bali mo, boy hay paghalità la komo nin kala-etan ay hiko ya ampaghalita-an la. ");
INSERT INTO sbl_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ha pagmaka-aypà ko ay nagpalta kon nangan, piro tinoya-toyà ako nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Nagdolo ko nin makodpaw ta an-ipakit koy kalele-an ko, piro pinagsistiyan la ko. ");
INSERT INTO sbl_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Maski ha dawdaan ay hiko ya ampi-i-ilgowan la, boy hay lawlasinggiro ay ampipangomposo nin kanta ya tongkol kongko. ");
INSERT INTO sbl_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Ombayroman ay manalangin ako komo, Pangino-on, ha tamà ya pana-on. Ha ingangalo mo ya ma-in panlalabi, Diyos ko, habayti ay tobayen mo dayi nin katapatan mo ha pambi mo nin kalibriyan. ");
INSERT INTO sbl_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ilibri mo ko boy agmo ko pa-olayan nin lomdeg ha kowinta malalè ya pità. Ilibri mo ko ha kawka-away ko, boy ha kowinta malalè ya lanom ya kowinta kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Agmo ko pa-olayan mi-anol nin kowinta lanab ya makalemeh kongko, boy no mipalako ko ha kowinta malalè ya lobot ay agmo payagan nin mataphonan ako bayro. ");
INSERT INTO sbl_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Tobayen mo ko, Pangino-on, nin ingangalo moy ma-in panlalabi; banà ha masyadoy ingangalo mo ay pakarani ka kongko. ");
INSERT INTO sbl_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Hiko ya magsisirbi mo ay agmo pakarayo-an; hapa-eg et ay tobayen mo ko ta anti ko ha kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Pakarani ka kongko ta ilibri mo ko ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Tandà mo no pangno ya panoya-toyà kongko, pangipareng-ey, boy pangalih kongko nin dangal ta angkakit moy kaganawan ka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Banà ha pawpanginsolto kongko ay angkahirà ya nakem ko; kayà ayin akoynan magawà. An-asawan ko nin ma-in maka-ingalo kongko piro ayin; ombayro et ha manahaliwa kongko piro ayin simpri. ");
INSERT INTO sbl_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Hin nakatanam akon bitil, hay impakan la kongko ay nila-okan lan aplo, boy hokà ya impa-inom la kongko hin na-angan ako. ");
INSERT INTO sbl_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Mintras ampagligaliga hila ay biglà dayin lomateng konla ya kasosoriyan la. ");
INSERT INTO sbl_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Bowagen mo hila emen aghila makakit, boy hila dayi ay mangabobokot emen komapey ya nawini la. ");
INSERT INTO sbl_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","I-oboh moy pahang mo konla emen aghila makapaglayas. ");
INSERT INTO sbl_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Hay ampa-iriyan la ay alihan la dayi, boy dayi, ni miha ay ayin anan pa-iri ha tawtolda la. ");
INSERT INTO sbl_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Ampadya-dya-an la baytoy pinakakhitan mo; ampi-i-ilgowan la ya tongkol ha andanasen nin hatoy nangahohogatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Parosawan mo hila nin nararapat konla, boy agmo hila ilamo ha igwà moy kalibriyan. ");
INSERT INTO sbl_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Borawen moy ngawngalan la ya nakalista ha listawan nin ampikabiyay, boy agmo hila dayi ilamo ha listawan nin tawtawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Hiko ay apih boy ampakatanam nin ilab; dayi ay ilibri mo ko, Diyos ko, nin alihen ha ombayri ya kapapa-hal. ");
INSERT INTO sbl_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Poriyen koy Diyos ha pagkanta ko, boy itag-ay koy ngalan na ha pamasalamat ko kona. ");
INSERT INTO sbl_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Habayti ay ampakapakonsowilo ha Pangino-on nin igit ha pinati ya toron bakà ya indolog. ");
INSERT INTO sbl_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","No makit bayti nin manga-irap, hila ay matowà, boy hay ampikahabek ha Diyos ay lalò homkaw ya nakem. ");
INSERT INTO sbl_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Anleng-en nin Pangino-on ya ampipanga-ilangan, boy agna ampa-olayan ya tawtawo nay nikapiriso. ");
INSERT INTO sbl_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Dayi, kaganawan nin anti ha langit boy ha babon lotà ay mamori kona kateng dagat boy kaganawan nin anti bayro. ");
INSERT INTO sbl_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Hay dogal ya an-ingaten Siyon ay ilibri nin Diyos, boy ibangon nan oman ya bawbali ha bawbanowa ha Hoda; ha ombayro, hay tawtawo ay bayro nin pa-iri, boy habayto ay pag-ikon la. ");
INSERT INTO sbl_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Hay aw-inalalak nin mawmagsisirbi na ay mipagmana nin habayto; hay ampipanlabi ha Diyos ay pa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","(Kanta ni Dabid ya ma-in pamakirawat) Ilibri mo ko, Diyos ko! Tampol mo ko dayin tambayan, Pangino-on! ");
INSERT INTO sbl_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Dayi, hay ampipaghangad nin mamati kongko ay mikatalo boy mikalito. Hay ampipagtowà nin banà ha pawproblima ya anti kongko ay mipagbiran ampikareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Dayi, hay ampipangalgal kongko ay ma-in biglà lomateng konlay kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Dayi, hay ampikahabek nin makabalay komo ay matowà boy magkama-in kaligawan komo. Hay ampipagpa-alagà ha pangilibri mo ay pirmi dayin maghalità nin, “Hay Diyos ay itag-ay!” ");
INSERT INTO sbl_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Apih ako boy ayin pakakaya; kayà tampol mo kon pakaraniyan, Diyos ko. Hika ya Diyos ko ya ampanambay boy ampangilibri kongko; manandalì ka dayi ha panambay mo kongko, Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Pangino-on, ampahimalà ako komo nin hiko ay idipinsa mo; kayà agko payagan nin mareng-eyan akon matalo. ");
INSERT INTO sbl_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Hika ya ma-in kahampatan, tambayan mo ko nin ilibri; leng-en mo ko dayi boy ilibri. ");
INSERT INTO sbl_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Hika ya kowinta malhay ya bato ay pirmin ampangidipinsa kongko boy nagpangakò kongko nin hiko ay ilibri; ta hika ya kowinta malhay ya bato ya dipinsa ko. ");
INSERT INTO sbl_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Diyos ko, ilibri mo ko ha mangala-et ya tawtawo ta hila ay mangahiblet, boy ma-in hilan kapangyariyan nin manggawà kongkon mala-et. ");
INSERT INTO sbl_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Pangino-on Diyos, hika ya an-asawan ko boy ampahimala-an pa-ibat hin malagò ako. ");
INSERT INTO sbl_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Impahimalà ko komo ya kaganawan ha biyay ko, boy hika ya nangi-atap kongko pa-ibat hin in-anak ako; kayà ayin angga ya pamomori ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Malakè ya ampag-ispanta ha biyay ko, ta agla tandà ya hika ya makhaw ay ampangidipinsa kongko. ");
INSERT INTO sbl_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Mikaka-allo ya pamori ko komo, boy an-ibabalità ko ya karangalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Hapa-eg ha antomo-a koyna ay agmo ko dayi liwawan nin asikasowen; agmo ko dayi pa-olayan no hiko ay makapey ana. ");
INSERT INTO sbl_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Hay kawka-away ko ya labay mamati kongko ay ampi-i-ilgo nin ampagplanon kontra kongko. ");
INSERT INTO sbl_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Hay anhalita-en la ay ombayri: “Hiya ay pina-olayan ana nin Diyos; kayà lakwen tamo yan dakpen ta ayin anan mangilibri kona.” ");
INSERT INTO sbl_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Pangino-on kon Diyos, agka dayi pakarayò kongko; manandalì ka dayin pakarani kongko, Diyos ko, ta tambayan mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Dayi, hay ampipangkomontra kongko ay mikatalo boy mikati; hay labay mamakakhit kongko ay mipareng-ey dayi boy ma-alihan dangal. ");
INSERT INTO sbl_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Piro hiko ay pirmin omasa komo, boy hika ay lalò kon poriyen. ");
INSERT INTO sbl_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Ibabalità koy tongkol ha kahampatan mo, boy mikaka-allo kon ibalità ya tongkol ha pangilibri mo kongko ya agko makwan intindiyen. ");
INSERT INTO sbl_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Pangino-on Diyos, hiko ay makon mangibabalità nin gawgawà moy makapangyariyan; ibabalità ko ya hikan bongat ya ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Pangino-on Diyos, pa-ibat hin malagò ako et ay tinoro-an mo koyna; pa-ibat hin hato angga hapa-eg ay an-ibalità koy kawkapapa-ispantay gawgawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","No mato-a koyna boy obanan ana ay agmo ko pa-olayan, Diyos ko. Dayi ay anti ka kongko ha pangibalità ko nin kakhawan mo boy kapangyariyan mo ha homonoy lawlipì. ");
INSERT INTO sbl_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Hay kahampatan mo, Diyos ko ay ahè makwan ihipen, ta hay ginawà moy bawbagay ay ahè mapantayan. Warì ma-in makaparis komo? ");
INSERT INTO sbl_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Maski pinaranas mo ko nin malakè boy mabyat ya problima ay ibira mo et ya hokaw ko emen agko ma-intoloyan mati. ");
INSERT INTO sbl_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Lalò mo kon biyan dangal boy hahaliwawen mo kon oman. ");
INSERT INTO sbl_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Diyos ko, banà ha katapatan mo ay poriyen kata ha panogtog ko nin alpa. Magkanta kon pamomori komo ya kompanyawan ko nin alpa, hika ya ayin kapintasan ya ampahimala-an nin aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Mambo-angaw ako ha katowa-an ko mintras ampagkanta ko nin pamomori komo ta hiko ay inlibri mo. ");
INSERT INTO sbl_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Hay kahampatan mo ay pirmi kon ibalità ta hay labay mamakakhit kongko ay nikatalo boy nipareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","(Kanta ya para koni Solomon) Pangino-on Diyos, hay arì ay biyan mon tinandà emen hay panonosga na ay matoynong, boy biyan mo yan kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Hiya ya manosga ha tawtawo mo nin ma-in kahampatan, boy hay aw-apih ay hosgawan nan ma-in katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Hay bawbakil ya tinanamanan ay makab-i dayin ka-inomayan ha tawtawo; ombayro simpri ha bawbakilbakil ta hay ampamo-on ay ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Ha pamomo-on nin hatoy arì ay idipinsa nay aw-apih, ilibri nay aw-anak nin manga-irap, boy talowen nay ampipangapih. ");
INSERT INTO sbl_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Hiya ay igalang nin kaganawan lipì bayri ha babon lotà anggan hay allo ay anhomilà; ombayro simpri ha bowan. ");
INSERT INTO sbl_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Habayti ya arì ay mag-in dayi nin bilang ha oran ya ampamohboh nin tinabas ya dawdikot emen manayinghing, boy mag-in dayi simpri nin bilang ha dala-irì ya ampakabahà nin lotà. ");
INSERT INTO sbl_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ha pana-on nin pamomo-on na, hay tawtawoy mangahampat ay mag-inomay, boy magkama-in nin katinekan anggan anhomilà et ya bowan. ");
INSERT INTO sbl_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Hay pamomo-on na ay ampaka-okopa nin intiron babon lotà, ta pa-ibat ha balah nin Iyopratis angga ha ka-anggawan nin babon lotà ay angka-okopawan na. ");
INSERT INTO sbl_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Hay tawtawoy ampa-iri ha powiray dogal ay mipanyomokò nin gomalang kona, boy hay kawka-away na ay mipanlokob ha gabok nin homokò kona. ");
INSERT INTO sbl_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Hay aw-arì nin Tarsis boy aw-arì nin aw-isla ya mangarani bayro ay mipambin rigalo kona kateng aw-arì ha Arabya boy ha Itopya. ");
INSERT INTO sbl_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Kaganawan arì ay yomokò nin gomalang kona, boy kaganawan tawo ha nawnasyon ay magsirbi kona. ");
INSERT INTO sbl_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","An-ilibri nay aw-apih ya andoma-ing kona, kateng ampipanga-ilangan ya ayin ampanambay. ");
INSERT INTO sbl_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Hay mangakapey boy ampipanga-ilangan ay an-ingalowan na; hay ampipanga-ilangan ay an-ilibri na ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","An-ilibri na hila ha ampipangapih boy ha ampipanggawà nin kagolowan, ta hay biyay la ay ma-alagà kona. ");
INSERT INTO sbl_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Dayi, hay biyay nin arì ay bomoyot, boy dayi, hiya ay biyan nin gawgintò ya ma-ibat ha nasyon Arabya. Dayi, pirmi yan ipanalangin nin tawtawo ha pamomo-on na boy poriyen yan ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Dayi, hay babon lotà ay magkama-in nin malakè ya pali angga ha tag-ay bakil. No pangno angkagalaw nin angin ya pawpo-on kayo ha nasyon Libanon ay ombayro itaman ya pawpali. Dayi, hay sawsiyodad ay mapnò nin tawo nin bilang ha lawak ya ponò nin dikot. ");
INSERT INTO sbl_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Hay ngalan nin habayti ya arì ay ahè dayi maliwawan, boy hay kabantogan na ay magpatoloy dayi anggan anhomilà et ya allo. Banà kona, kaganawan nasyon ay magkama-in kahampatan boy hay tawtawo bayro ay mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Poriyen ya Pangino-on Diyos, Diyos ya ampahimala-an nin aw-inalalak ni Israyil, ta hiyan bongat ya ampakagawà nin bawbagay ya kawkapapa-ispanta. ");
INSERT INTO sbl_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Hay kagandawan nin ngalan na ay poriyen nin ayin angga, boy dayi, hay babon lotà ay mapnò nin kagandawan na. Amin! Amin! ");
INSERT INTO sbl_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Angga tana bayri ya pawpanalangin ni Dabid ya anak ni Dyisi. ");
INSERT INTO sbl_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","(Kanta ni Asap) Hay Diyos ay talagan mahampat ha aw-inalalak ni Israyil, lalò ha ma-in malinis ya kanakeman. ");
INSERT INTO sbl_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Ha kakapeyan et nin katetpel ko, hiko ay kowinta ampanga-ampoling matombah, ta hay bitih ko ay kowinta ampiparawonot ");
INSERT INTO sbl_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","banà ha pag-inggit ko ha tawtawoy ampipagmalhay, boy ha angkakit koy pag-inomay nin tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Hila ay ahè ampagmasakit; mangaligha hila boy mangakhaw. ");
INSERT INTO sbl_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Aghila angkagolo nin bilang ha andanasen nin kanayon, boy aghila ampagkadipirinsya nin bilang ha angkatanam nin kanayon ya tawo. ");
INSERT INTO sbl_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Hay pagmalhay la ay pinagkakolinta lan bongat boy pinagkadolo lan bongat ya kabagsitan la. ");
INSERT INTO sbl_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Hay kanakeman la ay panay kala-etan, boy hay pawplano lay mangala-et ya pirmi lan an-ihipen ay sigisigi lan anggaw-en. ");
INSERT INTO sbl_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Hay kanayon ya tawtawo ay antoya-toya-en la boy ampaghalita-an lan kala-etan. Ampagmalhay hila boy ampalimowen lan apiyen ya kanayon. ");
INSERT INTO sbl_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Hay Diyos ya anti ha katatag-ayan ha kama-inan na ay ampaghalita-an lan mala-et; ampagmalhay hilan manogò ha tawtawo bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Kayà hay tawtawo nin Diyos ay anhomonol konla boy ampinto-o ha kaganawan anhalita-en la. ");
INSERT INTO sbl_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Hapa-eg, hay hinalità nin hatoy tawtawo nin Diyos ya hinomonol konla ay ombayri: “Warì ahè tandà nin Diyos bayti ya ampangyari? Warì hay Pinakamakapangyariyan ay ayin tinandà?” ");
INSERT INTO sbl_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Ombayri ya mangala-et: ayin hilan an-ihipen ta kapanlolomakè nin kamama-in la. ");
INSERT INTO sbl_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Piro hiko, hay panatili kon malinis ha agko panggawà nin kasalanan ay emen ayin kowinta. ");
INSERT INTO sbl_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Binabayombokah ay ampakatanggap ako nin parosa, boy pirmi kon ampagdanas nin pawpanobok. ");
INSERT INTO sbl_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","No hinalità koy kaganawan nin anti ha nakem ko ay nag-in akon alwan tapat ha tawtawo mo. ");
INSERT INTO sbl_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Habayti ay pinagsikapan kon intindiyen, piro agko ma-intindiyan ");
INSERT INTO sbl_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","angga hin nilomo-ob ako ha masagradoy bali nin Diyos. Bayro ay na-intindiyan ko no anyay pi-ogotan nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Hila ay talagan gitan mo ha kowinta marawonot ya dogal ta bayro ma-ibat ya kadisgrasyawan la. ");
INSERT INTO sbl_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Antimano, hay agla an-asawan ya kadisgrasyawan la ya mangipalako konla ha kapapalimoy anggawan la. ");
INSERT INTO sbl_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Pangino-on, hila ay bilang bongat ha taynep ya ahè na-etpanan nin hatoy nanaynep no anyay klasi la hin nibangon baytoy nanaynep hin bayombokayna. ");
INSERT INTO sbl_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Hin hato ay nablò ya nakem ko boy masyadon makhit ya natanam ko. ");
INSERT INTO sbl_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Nag-in akon bilang ha tangah ya ahè ampaka-intindi boy emen akon ayop ya an-omarap komo. ");
INSERT INTO sbl_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Ombayroman, hiko ay pirmin anti komo boy hika ay ampangalalay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Hay wawwawali mo ay ampangitoto kongko, boy ha ka-anggawan nin biyay ko ay tanggapen mo ko nin ma-in karangalan. ");
INSERT INTO sbl_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ha katatag-ayan ha kama-inan mo, Diyos ko ay ayin akon kanayon ya ka-ilangan no alwan hika. Ombayro simpri bayri ha babon lotà, ayin akon kanayon ya hinangad no alwan hika. ");
INSERT INTO sbl_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Hay nakem ko boy nawini ko ay angkomapey, piro Diyos ya ampamakhaw kongko boy hiya ya kaganawan ha biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Kaganawan ampakarayò komo ay mipalako ha kaparosawan; ombayro simpri ha alwan tapat komo. ");
INSERT INTO sbl_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Para kongko ay mahampat ya pakarani ha Diyos; Pangino-on Diyos ya ampahimala-an ko nin mangidipinsa kongko, boy ibabalità koy kaganawan nin ginawà na. ");
INSERT INTO sbl_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","(Kanta ni Asap ya pakapowotan aral) Pangino-on Diyos, antà ayin anggay pama-olay mo konnawen? Antà masyadoy pahang mo ha tawtawo mo ya kowinta tawtopa ya ampastolan mo? ");
INSERT INTO sbl_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Panemtemen moy tawtawo mo ya pinilì mon pag-ikon pa-ibat hin hato, ta hila bayti ya tawtawo ya timbeh mo. Panemtemen mo simpri ya bakil nin Siyon ya pina-iriyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Manandalì ka ta biliwen mo bayti ya masyadoy pagkahirà nin siyodad kateng masagradoy bali mo ya hinirà nin kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Hay kawka-away mo, banà ha pananalo la, hila ay ampipambo-angaw do ha lo-ob nin masagradoy bali ya pamititiponan nin ampipanhomamba komo. Hila ay nangigwà nin palatanda-an ya pakatanda-an nin hay bali mo ay na-okopawan layna. ");
INSERT INTO sbl_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Ha paninirà la nin habayto, hila ay emen ha aw-atsiro ya ampamayakol nin antombawen ya kayo. ");
INSERT INTO sbl_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Kaganawan nin kinortiyan ya kayo ha lo-ob nin habayto ay inoboh lan pinayakol boy minaso. ");
INSERT INTO sbl_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Habaytoy bali mo ay pino-olan la; agla inggalang ya dogal ya ampaghambawan komo, ta talagan hinirà la. ");
INSERT INTO sbl_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Hay nangapimimihawan la ay sakopen lay kaganawan nin ampititipon nin homamba komo; kayà pino-olan lay kaganawan nin paghambawan komo bayri ha dogal ya habayti. ");
INSERT INTO sbl_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ayin anan makit ya palatanda-an nin hika ay anti konnawen; ayin anan natilà ya propita, boy ayin magtandà konnawen no anggan makano bayti ya ampangyari konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Anggan makano, Diyos ko, ya panoya-toyà konnawen nin kawka-away nawen? Anggan makano ya panginsolto la nin ngalan mo? ");
INSERT INTO sbl_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Antà agmo kayi tinambayan boy antà agmo kayi inlibri nin kapangyariyan mo? ");
INSERT INTO sbl_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Ombayroman, Diyos ko, pa-ibat hin ibat ay hikayna ya Arì nawen, boy hika ya nambin kalibriyan ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ha kapangyariyan mo ay pinihiyay moy lanom nin dagat, boy hay mangalhay ya aw-ayop bayro ay pineha-pehà moy aw-olo. ");
INSERT INTO sbl_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Habaytoy mangalhay ya aw-ayop ya pineha-pehà moy aw-olo ay inggawà mon kinnà nin ampipampa-iri ha powiray dogal. ");
INSERT INTO sbl_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Hika ya nambi nin hawhobol boy nama-agoh nin hawhapà, boy hika simpri ya namaklang nin bawbalah ya pirmin makhaw ya agoh. ");
INSERT INTO sbl_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Hika simpri ya nanggawà nin allo boy yabi; hika et ya nangikolokar nin allo boy bowan. ");
INSERT INTO sbl_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Hay pawpi-anggawan nin lawlotà ay hika ya nangigwà; hika simpri ya nanggawà nin ka-ingitan boy abagat. ");
INSERT INTO sbl_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Panemtemen mo, Pangino-on, no pangno ka antoya-toya-en nin kawka-away mo, boy no pangno andodosta-en nin mangala-et ya ngalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Agmo pa-olayan ya tawtawo mo ya emen ha kawkalapati ha kawka-away la ya emen ha mangabangis ya ayop, boy agmo hila liwawan nin ilibri ha ampipangapih konla. ");
INSERT INTO sbl_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Panemtemen moy pamakisondò mo konnawen, ta ha kowinta mangareglem ya dawdogal ay ma-in mangahiblet ya tawtawo ya ampipanggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Agmo dayi payagan nin hay aw-apih ay mipareng-ey. Dayi, hay aw-apih boy ampipanga-ilangan ay mamori komo ha tambay mo konla. ");
INSERT INTO sbl_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Pangino-on Diyos, manandalì ka ta idipinsa moy karangalan mo; panemtemen mo no pangno nin hay mangala-et ay pirmin ampanoya-toyà komo. ");
INSERT INTO sbl_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Hay pamibobo-angaw nin kawka-away mo ay sigisigi ha pamakilaban la ha tawtawo mo. Kayà agmo hila payagan ha labay la, no alwan parosawan mo hila nin nararapat konla. ");
INSERT INTO sbl_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","(Kanta ni Asap) Ampasalamat kayi komo, Pangino-on Diyos; ampasalamat kayi ta hika ay maheneh konnawen. Hay kawkapapa-ispantay gawgawà mo ay ibabalità nawen. ");
INSERT INTO sbl_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ombayri ya hinalità nin Diyos: “Hiko ay nangitaning nin pana-on nin panonosga ko boy hay panonosga ko ay matoynong. ");
INSERT INTO sbl_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ha pana-on nin hay babon lotà ay ma-eyeg boy hay tawtawoy ampa-iri bayri ay ayin ka-ayosan ay hiko ya mamatibay nin pinagkapondasyon nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Anhalita-en ko do ha mangahambog ya aghilayna maghambog, boy hay mangala-et ay tonggen ana ha pagpasikat. ");
INSERT INTO sbl_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Anhalita-en ko konla ya itegen laynay pagpasikat boy pagyabang ya kontra ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","7","Hay tawtawo bayri ha babon lotà ay ayin karapatan mangitag-ay nin kapara la, ta Diyos bongat ya ma-arì manosga. Hiya ay ma-in an-i-aypà boy ma-in yan an-itag-ay. ");
INSERT INTO sbl_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Hay Pangino-on ay kowinta ma-in oligtan ya mihay baso ya alak ya anhomboh. Habayti ay matapang ta ma-in inla-ok, boy habayti ya kowinta alak ay an-ibollog nin Pangino-on emen obohen inomen nin mangala-et. Hay ka-alimbawa-an nin habayti ay pahang nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Agko tonggen mangibabalità nin tongkol ha Diyos ya pinahimala-an ni Hakob, boy ayin anggay pagkanta ko nin pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Hiya ya mangalin kapangyariyan nin mangala-et, piro hay kapangyariyan nin mangahampat ay pahanan na. ");
INSERT INTO sbl_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","(Kanta ni Asap) Hay Diyos ay balaybalay ha Hoda, boy hiya ay bantog ha Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Hay kama-inan nay tabirnakolo ay anti ha siyodad nin Hirosalim ha bakil nin Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Bayro na hinira-hirà ya aw-armas nin kawka-away na ya bilang ha pawpanà, hawhalanggà, boy hawhondang. ");
INSERT INTO sbl_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Hika ay ma-in kahawangan boy kagandawan ya igit ha kagandawan nin ayin pagkahirà ya bawbakil. ");
INSERT INTO sbl_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Hay mangatapang ya hawhondalò ay nikati boy hay nikakwa la ay inalih konla. Banà bayro ay ayin anan manggamit nin aw-armas la. ");
INSERT INTO sbl_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Hin hina-ad mo hila, Diyos ya pinahimala-an ni Hakob, hay kawkabayo la ya ampipanggoloy nin kawkarwahi boy hawhakay nin habayto ay nikati. ");
INSERT INTO sbl_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Hika ay talagan dapat igalang! Warì ma-in makapaki-arap komo no ampamahang ka? ");
INSERT INTO sbl_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Hay panonosga mo ay impatandà mo nin nangibat ha katatag-ayan ha kama-inan mo; kayà hay babon lotà ay kowinta nalimo boy tinominek. ");
INSERT INTO sbl_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Ombayroy nangyari hin hay Diyos ay naghandà nin manosga ta ilibri nay kaganawan ampika-apih. ");
INSERT INTO sbl_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Hay pahang nin tawtawo ay ampambin pamoriyan komo. Hay nikatilà ha pamamahang mo ay ampanatili et konla ya pahang mo. ");
INSERT INTO sbl_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Igwà mo ha Pangino-on mon Diyos ya impangakò mo kona; hay tawtawo ha nawnasyon ya mangarani bayri ay magrigalo kona; hiya ya dapat igalang. ");
INSERT INTO sbl_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Hay ampipamo-on ya mangahambog ay ampa-aypa-en nay nakem. Hay anggaw-en na ha aw-arì bayri ha babon lotà ay kapapalimo. ");
INSERT INTO sbl_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","(Kanta ni Asap) Andoma-ing ako ha Diyos nin hay pandoma-ing ko ay an-ipakakhaw koy bosis ko. An-ipakakhaw koy bosis ko nin andoma-ing ha Diyos emen na ko malengè. ");
INSERT INTO sbl_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Hin anti ko ha kagolowan ay ampakirawat ako ha Pangino-on; maski yabi, hay gamet ko ay nakatatag-ay ha panalangin ko, piro agko mahahaliwa. ");
INSERT INTO sbl_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Na-ihipan koy Diyos piro malelè ako simpri; maski pinakahohole-lè ko ay kinomapey ya nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Agko pinayagan nin Diyos nin makakatoloy, boy agko makapaghalità ta angkagoloy nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Angka-ihipan koy nakaraan ya aw-allo; ombayro simpri ha nakaraan ya aw-onay pana-on. ");
INSERT INTO sbl_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Angkapanemteman koy angkantawen ko hin hato no yabi; ha kahohole-lè ko ay pinastang koy sarili ko nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Warì ayin anan anggay pama-olay kongko nin Pangino-on? Agyayna warì mangonsowilo kongkon oman? ");
INSERT INTO sbl_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Warì na-anggawan ana ya ingangalo nay ma-in panlalabi? Agnayna warì toparen ya pawpangakò na? ");
INSERT INTO sbl_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Warì naliwawan ana nin Diyos ya pag-in nan ma-ingangalowen? Banà warì ha pahang na ay agyayna mangingangalo? ");
INSERT INTO sbl_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Hin pinaka-ihip-ihip ko bayti ay napanemteman ko ya hay Diyos ay Pinakamakapangyariyan.” ");
INSERT INTO sbl_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Panemtemen koy gawgawà mo, Pangino-on; awò, panemtemen koy kawkapapa-ispantay gawgawà mo hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Hole-le-en ko boy ihipen ya kaganawan gawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Hay pamamaraan mo, Pangino-on Diyos ay ayin kapintasan. Warì ma-in et nin makapantay komo? ");
INSERT INTO sbl_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Hika ya Diyos ya ampanggawà pawpapag-ispantawan. Hay kapangyariyan mo ay impatnag mo ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Hay tawtawo mo ya aw-inalalak ni Hakob boy ni Hosi ay timbeh mo nin kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ha panggogomawà mo, Pangino-on Diyos, hay lawlanom ay kowinta nalimo ta kateng kalale-lale-an dagat ay kowinta namegpeg. ");
INSERT INTO sbl_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Hay lawleem ay nambin oran, ma-in makhaw ya korol ha langit, boy ma-in kilat ya emen ha yawyawò ya andongket ya pabirabira. ");
INSERT INTO sbl_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Hay heneg nin korol ay angkalengè ha langit, hay hawang itaman nin kilat ay ampakahawang ha babon lotà, boy hay babon lotà ay na-eyeg. ");
INSERT INTO sbl_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ha pangilibri mo nin tawtawo mo, hika ay nanggawà paraan ha pagdaan mo ha malalè ya dagat boy ha malhay ya lanom, piro hay toyot mo ay ahè makit. ");
INSERT INTO sbl_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Hay tawtawo mo ay inggiya mo nin bilang ha anggaw-en nin pastol nin tawtopa. Ha paninigè la, hay nama-alà konla ay hi Moysis boy hi Aron. ");
INSERT INTO sbl_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","(Kanta ni Asap ya pakapowotan aral) Hinalità nin arì, ya wana, hikawoy tawtawo ko, leng-en moyoy an-itorò ko, boy intindiyen moyoy halita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Hay halita-en ko komoyo ay tongkol ha pawpangyayari hin hato ya ahè pon impatandà, piro hapa-eg ay natanda-an ana. ");
INSERT INTO sbl_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Habaytoy pawpangyayari ay nalengè nawen boy natanda-an nawen ta hinalità konnawen nin kawka-apo-apowan nawen. ");
INSERT INTO sbl_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Habayti ay agnawen ipolinged ha aw-anak nawen boy ha homonoy lawlipì. Ibalità nawen konla ya tongkol ha kapangyariyan nin Pangino-on, boy tongkol ha gawgawà nay kaporipori boy bawbagay ya kawkapapa-ispanta ya ginawà na. ");
INSERT INTO sbl_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Hiya ay nambin kawkapanogo-an koni Hakob boy ha Aw-israylita ya aw-inalalak ni Hakob. Immanda na ha kawka-apo-apowan tamo ya habaytoy kawkapanogo-an ay itorò la ha aw-anak la. ");
INSERT INTO sbl_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Ha ombayro, habayti ay matanda-an nin homonoy lawlipì, boy hila ay mangitorò simpri ha aw-anak la. ");
INSERT INTO sbl_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Banà bayri, hila ay pahimalà ha Diyos. Agla maliwawan ya gawgawà nin Diyos boy hila ay homonol ha kawkapanogo-an na. ");
INSERT INTO sbl_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Hila ay ahè manowad ha kawka-apo-apowan la ya mangatyà ya nakem boy nipagribildi. Habaytoy kawka-apo-apowan la ay alwan matibay ya pamahimalà ha Diyos ta aghila nanatilin tapat kona. ");
INSERT INTO sbl_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Hay aw-inalalak ni Ipra-im, maski naka-armas nin pawpanà ay nipampowayon nagbira hin pana-on nin labanan. ");
INSERT INTO sbl_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Agla hinonol ya pamakisondò nin Diyos konla, boy hay kawkapanogo-an na ay talagan agla hinonol. ");
INSERT INTO sbl_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Niliwawan lay ginawà nay pawpapag-ispantawan ya impakit na konla. ");
INSERT INTO sbl_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Habaytoy pawpapag-ispantawan ay ginawà na ha arapan nin kawka-apo-apowan la ha dogal ya an-ingaten Sowan ya sakop nin nasyon Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Pinihiyay nay lanom dagat ta bayro na hila pinaraan; ha mitaligmang nin habaytoy napihiyay ya lanom, hay lanom ay ginawà nan bilang matibay ya padir ya naka-ireng. ");
INSERT INTO sbl_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Ha paninigè la, no allo ay ma-in leem ya inggawà na nin mangigiya konla; no yabi itaman, hay ampangigiya konla ay apoy ya ampakahawang konla. ");
INSERT INTO sbl_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Hin anti hila ha powiray dogal ay binyan na hila nin malakè ya lanom ya ininom la. Habayto ay nilomwah ha pinaka nay bawbato, boy ha kalak-an nin habaytoy lanom, habayto ay bilang nangibat ha kalale-lale-an nin lotà. ");
INSERT INTO sbl_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Hiya ay namalwah nin lanom ha bato, boy habaytoy lanom ay pina-agoh na nin bilang ha balah. ");
INSERT INTO sbl_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Piro hila ay nagpatoloy ha pagkasalanan la ha Diyos, boy mintras anti hila bayro ha powiray dogal ay ampagribildi hila ha Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Antatalawen lan hoboken ya Diyos ha pamilit la kona nin hila ay biyan na nin pamamangan ya angkahabekan la. ");
INSERT INTO sbl_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Hila ay naghalità nin kontra ha Diyos, ya wanla, “Warì mabiyan tamo nin Diyos nin pamamangan bayri ha powiray dogal? ");
INSERT INTO sbl_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Peteg nin hin pinatok nay bato ay ma-in biglà nilomwah ya ampan-agoy lanom, piro makab-i ya warì nin tinapay boy karni ha tawtawo na?” ");
INSERT INTO sbl_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Hin nalengè hila nin Pangino-on ay masyado yan namahang konla. Hila bayti ya aw-inalalak ni Hakob ya an-ingaten et Israyil ay tinatawan na nin manliyobliyob ya apoy boy lalò yan namahang konla, ");
INSERT INTO sbl_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","ta hila ay ahè antompel ha Diyos boy aghila ampinto-o nin ilibri na hila. ");
INSERT INTO sbl_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Ombayroman, hay Diyos ay minandawan nay langit nin hay kowinta pawpolta nin habayti ay maglo-at. ");
INSERT INTO sbl_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Hapa-eg, nama-oran ya nin Mana ya ma-ekan la; habayto ya pamamangan ya inggawà na konla ay nangibat ha katatag-ayan ha kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Nangan baytoy tawtawo nin habaytoy pamamangan ya pamamangan nin aw-anghil, boy binyan hila nin Diyos angga ha labay la. ");
INSERT INTO sbl_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Hapa-eg, nama-angin ya nin nangibat ha baytan, boy ha kapangyariyan na ma-in et angin ya nangibat ha bagatan. ");
INSERT INTO sbl_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Habaytoy angin ay nantan nin kona-en lay mawmanokmanok ya bilang kalakè kapati-an ha ambay dagat. ");
INSERT INTO sbl_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Habaytoy mawmanokmanok ay nikatata ha botlay pinagkampowan la ha mamalibot nin tawtolda la. ");
INSERT INTO sbl_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Nangnà hila nin habayto anggan nabhoy hila, ta binyan hila nin Diyos nin habaytoy pamamangan ya angkahabekan la. ");
INSERT INTO sbl_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Piro mintras angkona-en la et bayto ya kinahabekan la, ");
INSERT INTO sbl_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","hay Diyos ay namahang konla; kayà pinatipati nay mangakhaw ya lawlalaki ya mangalagò ya Aw-israylita. ");
INSERT INTO sbl_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Ha kagmang nin kaganawan nin habayti ya ginawà nin Diyos ya pawpapag-ispantawan ay agla pininto-o, boy patoloy hila et ha pagkasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Kayà pina-anggawan nay biyay la ha pamaranas na konla nin pangyayari ya alwan maganda, ta hay anggaw-en la bayro ha powiray dogal ay ayin kowinta banà ta aghila anhomonol kona. ");
INSERT INTO sbl_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Hin pinati nin Diyos ya kanayon konla, hay nikatilà ay napakarani kona ta naghehe boy inoman lay nakem la. ");
INSERT INTO sbl_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Hapa-eg, napanemteman la ya hay Diyos ay kowinta malhay ya bato ya dipinsa la, boy hiya ya Diyos ya Pinakamakapangyariyan ya Mapangilibri. ");
INSERT INTO sbl_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Piro habaytoy hinalità la ay pangoto-otò bongat boy panay kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Hila ay alwan leseb ya nakem kona, boy alwa hilan tapat ha kasondo-an na. ");
INSERT INTO sbl_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Ombayroman, hay Diyos ay ma-ingangalowen ha tawtawo na; kayà pinatawad nay kawkasalanan la boy agna hila pinati. Malakè ya bisis nin dapat yan mamahang, piro ampendanan nay pahang na. ");
INSERT INTO sbl_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Napanemteman na ya hila ay tawon bongat ya ma-ipek ya biyay nin emen ha angin ya no nakaraan ana ay agana magbira. ");
INSERT INTO sbl_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Hin anti hila ha powiray dogal ay mabetbet hilan magribildi ha Diyos. Habaytoy gawgawà lay ombayro ay ampakab-in kalele-an ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Pi-oman-oman lan anhoboken ya Diyos, ta hiya ya Diyos ya ayin kapintasan ya pinahimala-an ni Israyil ay ampapahangen la. ");
INSERT INTO sbl_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Aglayna napanemteman ya kapangyariyan na boy pangilibri na konla ha kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Aglayna simpri napanemteman ya pangilibri konla nin Diyos hin nanggawà yan pawpapag-ispantawan bayro ha dogal ya an-ingaten Sowan ha nasyon Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Hay lanom nin bawbalah bayro ay ginawà nan dayà; kayà hay tawtaga Ihipto ay ayin ma-inom. ");
INSERT INTO sbl_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Pinalakè nay lawlangoh ya nakataranta konla boy pawpahingà ya nanirà nin pawpaliyan la. ");
INSERT INTO sbl_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Hay Diyos ay nambi nin mipanirà nin tawtanaman la boy dawdoron ya mipanirà nin bawbonga ha pawpaliyan la. ");
INSERT INTO sbl_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Nangahihirà ya tawtanaman ya ampipangayakay boy pawpo-on kayoy igos banà ha yilo ya impa-oran nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Banà bayro ha impa-oran na, hay bawbakà la ay nikati; hay pinamati na itaman nin tawtopa ay kilat. ");
INSERT INTO sbl_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Impatanam nay masyadoy pahang na ha tawtaga nasyon Ihipto ha pangihogò na nin aw-anghil ya mamati konla. ");
INSERT INTO sbl_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Hay Diyos ay ahè nagpendan ha pahang na, boy agna hila inlibri ha kamatyan no alwan nambi yan halot ya pinamati na konla. ");
INSERT INTO sbl_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Kaganawan ponganay ya lalaki nin tawtaga Ihipto ay pinati na. ");
INSERT INTO sbl_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Piro hay Diyos ay nangona ha tawtawo na ha pangi-alih na konla ha nasyon nin Ihipto, boy hiya ya nangasiwà konla ha powiray dogal bilang ha mihay pastol nin tawtopa. ");
INSERT INTO sbl_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Hila ay ahè nalimo boy ahè napangno ta Diyos ya nangona konla; hay kawka-away la balè ay nikatin nikalemeh. ");
INSERT INTO sbl_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Hila ay gintan na ha pi-anggawan nin masagradoy dogal ya ma-in bakil ya ha kapangyariyan na, habayto ay nakwa na nin para konla. ");
INSERT INTO sbl_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Hay tawtawoy ampipampa-iri bayro ay pina-alih na, ta habaytoy dogal ay pini-a-atag nan inggawà ha aw-inalalak ni Israyil, boy bayro na hila pinapa-iri. ");
INSERT INTO sbl_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Piro ampagribildi hila et boy hinobok lay Pinakamakapangyariyan ya Diyos, ta agla anhonolen ya pawpanogò na. ");
INSERT INTO sbl_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Hila ay bilang ha kawka-apo-apowan la, ta hila ay nipagribildi boy alwa hilan tapat. Emen hilan bayì ya alwan ma-ayos; kayà hay yawò ay ampilihis ha dapat tama-an. ");
INSERT INTO sbl_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Hay Diyos ay pinapahang la ha pamako la ha mangatag-ay ya dawdogal nin homamba ha alwan peteg diyos, boy hiya ay pinapanag-ilì la ha panggawà la nin rawribolto. ");
INSERT INTO sbl_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Hin nalengè nin Diyos ya panalangin la ha alwan peteg diyos ay namahang ya konla, boy hila ya aw-inalalak ni Israyil ay talagan agnayna tinanggap nin pinag-ikon. ");
INSERT INTO sbl_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Kayà hay tabirnakolo ya impa-ireng la ha dogal ya an-ingaten Silo ay pina-olayan nin Diyos maski habayto ay pina-iriyan na nin makilamo ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Pinayagan na nin makwa nin kawka-away la ya ba-ol ya kama-inan nin kasondo-an. Habaytoy ba-ol ay ampangipakit nin kapangyariyan boy kagandawan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ha kapahangan na ha tawtawo na, hay malakè konla ay pinayagan nan pinatipati nin kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Hay aw-anakabayo ay nikati ha gira; kayà hay dawdalaga ay agana angkaporin kantawan nin kawkantay para ha kahal. ");
INSERT INTO sbl_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Hay pawparì nin Aw-israylita ay pinatipatin ginamitan nin hondang; hay bawbawo la ay ahè nagawà nin ni-a-anito. ");
INSERT INTO sbl_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Hapa-eg, kowinta nibangon ya Pangino-on nin bilang ha pamibangon nin tawoy kapi-imata, boy emen ha makhaw ya tawoy ampambonghaw gitan kalahingan na. ");
INSERT INTO sbl_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Hay kawka-away na ay kinarakol nan pina-orong, boy ayin anggay kakareng-eyan la nin banà ha pagkatalo la. ");
INSERT INTO sbl_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Tinanggi-an nay aw-inalalak ni Hosi, ta agna pinilì ya lipì ni Ipra-im, ");
INSERT INTO sbl_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","no alwan hay pinilì na ay lipì ni Hoda, ta hay bakil nin Siyon ya ampa-alaga-an na ay anti bayro ha dogal ni Hoda. ");
INSERT INTO sbl_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Bayro na imbangon ya masagradoy pa-iriyan na ha matag-ay ya dogal, boy habayto ay pinatibay na nin bilang ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Hi Dabid ya magpapastol nin tawtopa ay pinilì nin Diyos ta ginawà nan magsisirbi na. ");
INSERT INTO sbl_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Hay anggaw-en ni Dabid hin hato ay ampangasiwà nin tawtopa. Hapa-eg hiya ay ginawà nin Diyos nin pastol ya mangasiwà nin tawtawo nin Diyos ya aw-inalalak ni Hakob ya ayin kanayon no alwan Aw-israylita ya pinag-ikon nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Hay pamama-alà konla ni Dabid ay leseb ha nakem na boy magaling ya ha pangongona na konla. ");
INSERT INTO sbl_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","(Kanta ni Asap) Pangino-on Diyos, hay dogal nin tawtawo mo ay nilo-oban nin tawtawoy alwan Israylita. Hay masagradoy bali mo ay agla inggalang, boy hinira-hirà lay siyodad nin Hirosalim. ");
INSERT INTO sbl_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Hay nag-in tawtawo mo ya mawmagsisirbi mo ay pinatipati la; imbalag lan ahè intabon ya bawbangkay nin habayto ta pina-olayan lan kinnà nin mawmanokmanok boy mangabangis ya aw-ayop. ");
INSERT INTO sbl_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Hay dayà nin tawtawo mo ya pinatipati la ay ampan-agoh ha intiron Hirosalim, boy hay bawbangkay nin habayto ay ayin mangitabon. ");
INSERT INTO sbl_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Hay tawtawo ha nawnasyon ha mamalibot nawen ay ampipanoya-toyà konnawen, boy ampagkaka-iliyan la kayin insoltowen. ");
INSERT INTO sbl_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Anggan makano ya pahang mo konnawen, Pangino-on? Ayin ana nayì angga? Warì hay pahang mo nin banà ha panag-ilì mo ay sigisigi nin bilang ha apoy ya ampakapo-ol? ");
INSERT INTO sbl_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Hay pahang mo ay ipahang mo ha tawtawo nin nawnasyon ya ahè anhomamba komo boy ha ahè ampanalangin komo; ");
INSERT INTO sbl_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","ta kalak-an konnawen nin aw-inalalak ni Hakob ay pinatipati la boy hinirà lay dogal nawen. ");
INSERT INTO sbl_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Agmo kayi parosawan nin banà ha kawkasalanan nin kawka-apo-apowan nawen, no alwan ingalowan mo kayi ta angka-alihan kayinan pag-asa. ");
INSERT INTO sbl_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Tambayan mo kayi, Pangino-on Diyos ya Mapangilibri konnawen, alang-alang ha karangalan mo. Ilibri mo kayi boy patawaren moy kawkasalanan nawen emen ka poriyen nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Antà hay tawtawo ha nawnasyon ay ampanginsolto konnawen nin magpastang nin ombayri: “Ayri ya Diyos moyo?” Ipakit mo konnawen ya pamarosa mo nin tawtawo ha nawnasyon ya namatolò nin dayà nin mawmagsisirbi mo ha pamati la konla. ");
INSERT INTO sbl_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Leng-en moy dawda-ing nin nikapiriso, boy ha kapangyariyan mo ay ilibri mo hila ha kamatyan ya insintinsya konla. ");
INSERT INTO sbl_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Pangino-on, no pangno ya panginginsolto ya ginawà komo nin tawtawo ha kanayon ya nawnasyon ay ombayroy ibira mo konla nin kapitoy bisis. ");
INSERT INTO sbl_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","No ombayroy gaw-en mo, hikayi ya tawtawo mo ya kowinta tawtopa ya an-asiwa-en mo ay magpasalamat komo nin ayin angga; ibabalità nawen ha homonoy lawlipì ya hila man ay mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","(Kanta ni Asap) Leng-en mo kayi, Pastol nin aw-inalalak ni Israyil; hika ya nangona ha aw-inalalak ni Hosi nin bilang pangasiwà nin mihay pastol ha tawtopa. Hika ya anti ha piha-etan nin loway anghil ya an-ingaten kirobin ya anti ha babon ba-ol ha Pinakamasagradoy kowarto nin tabirnakolo ay mangipakit nin kahawangan moy ma-in kagandawan. ");
INSERT INTO sbl_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Hay kapangyariyan mo ay ipakit mo konnawen nin lawlipì ni Ipra-im, Binhamin, boy Manasis; pakaraniyan mo kayi ta ilibri mo kayi ha kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Pangino-on Diyos, ibira mo kayi komo boy ipakit mo dayi konnawen ya hika ay ampangonswilo konnawen. Ha ombayro, hikayi ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Pangino-on Diyos ya Pinakamakapangyariyan, anggan makano ya pahang mo konnawen ta agmo anleng-en ya pawpanalangin nawen? ");
INSERT INTO sbl_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Banà ha pahang mo konnawen, hay angkanen nawen boy an-inomen ay angkatolo-an nin lowà nawen; kayà emen mo kayin ampakanen boy ampa-inomen nin lowà nawen. ");
INSERT INTO sbl_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ginawà mo kayin toya-toya-en nin tawtawo ha nawnasyon ya mangarani konnawen boy ka-iliyan nin kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Diyos ya Pinakamakapangyariyan, ibira mo kayi komo boy ipakit mo dayi konnawen ya hika ay ampangonsowilo konnawen. Ha ombayro, hikayi ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Hikayi ay kowinta po-on nin aw-obas ya inolot mo ha nasyon Ihipto. Pina-alih moy tawtawo ya ahè anhomamba komo ha dogal ya ampa-iriyan la, ta bayro mo kayi nin kowinta intanem. ");
INSERT INTO sbl_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Nilinisan mo baytoy dogal ya pinangitamnan mo; kayà hatoy kowinta intanem mo ay tinomobò nin mahampat, boy kowinta nanyamot nin malalè anggan habayto ay nanwalak ya naka-okopa nin habaytoy dogal. ");
INSERT INTO sbl_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Hay bawbakil bayro kateng mangalhay ya pawpo-on kayoy sidro ay na-anyoyongan nin hawhanga nin hatoy nanwalak ya kowinta intanem mo. ");
INSERT INTO sbl_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Hay hawhanga nin habayto ya kowinta intanem mo ay ni-abot ha dagat nin Miditiranyo ha bandan babà, boy ni-abot ha balah nin Iyopratis ha bandan baytan. ");
INSERT INTO sbl_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Antà hinirà moy alal ha mamalibot nin habayti ya kowinta intanem moy obas? Hekel balang magdaan bayri ay ampamoti nin bonga nin habayti ya kowinta obas. ");
INSERT INTO sbl_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Hay kowinta bawbaboydikot ay ampanyabokyabok nin habayti; hay kanayon itaman ya kowinta aw-ayop ya balang ay ampangan nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Pakaraniyan mo kayin oman, Pinakamakapangyariyan ya Diyos. Pa-ibat ha katatag-ayan ha kama-inan mo ay asikasowen mo kayin ingalowan ya kowinta intanem moy kowinta obas. ");
INSERT INTO sbl_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Habayti ya kowinta obas ya kowinta intanem mo ya pinakhaw mo nin para komo ay i-atap mo dayi boy protiksyonan. ");
INSERT INTO sbl_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Hay kawka-away nawen ay namotohpotoh nin habayti ya kowinta intanem mo boy pino-olan la et. Ipakit mo dayi ya pahang mo konla ha pangapò mo konla. ");
INSERT INTO sbl_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Protiksyonan mo dayi boy i-atap ya tawtawoy pinilì mo ta hila bayti ya pinakhaw mo nin para komo. ");
INSERT INTO sbl_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Hikayi ay agana mangoman nin pakarayò komo; panatiliyen mo kayin angkabiyay ta poriyen nawen ka. ");
INSERT INTO sbl_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Pangino-on Diyos ya Pinakamakapangyariyan, ibira mo kayi komo boy ipakit mo dayi konnawen ya hika ay ampangonsowilo konnawen. Ha ombayro, hikayi ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","(Kanta ni Asap) Ipakakhaw tamoy pagkanta tamo ha katowa-an tamo ha Diyos ya ampambin kakhawan kontamo. Magkanta tamon pamomori ha Diyos ya pinahimala-an ni Hakob ya ka-apo-apowan tamo. ");
INSERT INTO sbl_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Ha pagkanta tamo ay kompanyawan tamo nin pandirita boy maganday togtog nin lira boy alpa. ");
INSERT INTO sbl_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Patnoyen tamoy tamboyok ha pana-on nin pagsilibra tamo nin pista tamo no bayoy bowan boy no kabilogan. ");
INSERT INTO sbl_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Habayti ay panogò ha Aw-israylita. Hay ma-in panogò nin habayti ay Diyos ya pinahimala-an ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Habayti ya panogò ay inggawà nin Diyos ha Aw-israylita hin in-alih na hila ha nasyon Ihipto. Hin anti hila et bayro ay nakalengè hilan bosis ya agla tandà no hinoy ma-in bosis ya ampaghalità nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Hinalità nin Diyos, ya wana, “Inalih koy mabyat ya ambalatayen moyoy baskit ya pinangikargawan moyo nin gawgamit moyo emen mapa-inawawan ya gawgamet moyo. ");
INSERT INTO sbl_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Hin ampadya-dya-an kawo ya nangingat kawo kongko ay inlibri katawo; hin habayto ay anti ko ha korol ya tinombay komoyo, boy hinobok katawo ha lanom nin Miriba. ");
INSERT INTO sbl_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“Hikawoy tawtawo ko, leng-en moyo bayti ya babalà ko komoyo; manlengè kawo dayi, hikawoy aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Agkawo homamba ha alwan peteg diyos ya andiyosen nin dawdayowan. ");
INSERT INTO sbl_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Hiko ya Diyos ya Pangino-on moyo ya nangi-alih komoyo ha nasyon Ihipto; kayà kaganawan panganga-ilangan moyo ay igwà ko komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Piro hay tawtawo ko ya aw-inalalak ni Israyil ay ahè nanlengè boy ahè hinomonol kongko. ");
INSERT INTO sbl_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Kayà ha katya-an nakem la ay pina-olayan ko hilan manggawà nin sarili lan kalabayan. ");
INSERT INTO sbl_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Hay labay ko dayi ay leng-en ako nin tawtawo koy aw-inalalak ni Israyil boy homonol hila dayi kongko. ");
INSERT INTO sbl_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","No ombayroy gaw-en la ay tampol kon talowen ya kawka-away la boy pahoko-en koy ampipangkomontra konla. ");
INSERT INTO sbl_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Hay ampipag-inakit kongko ay mipanyokò ha kalimowan la kongko boy ayin anggay pamarosa ko konla. ");
INSERT INTO sbl_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","No homonol kawo kongko ya aw-inalalak ni Israyil ay pakanen katawo nin pinakamaganday bongan trigo boy polot ya angkakwa ha dogal ya mabato.” ");
INSERT INTO sbl_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","(Kanta ni Asap) No ampititipon nin ampi-i-ilgo ya ampipamo-on ay Diyos ya ampangona ha pami-i-ilgo la, boy hiya ya ampanosga konla. ");
INSERT INTO sbl_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Kayà hinalità na konla, ya wana, “Anggan makano moyo idipinsay kamali-an boy ipakit ya hikawo ay ampomanig ha mangala-et? ");
INSERT INTO sbl_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Idipinsa moyoy karapatan nin manga-irap boy aw-olila; ipaglaban moyoy karapatan nin ampipanga-ilangan boy ampika-apih. ");
INSERT INTO sbl_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Hay mangakapey boy ampipanga-ilangan ay ilibri moyo ha kapangyariyan nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","“Talagan ayin kawon tinandà boy ayin pangingintindi, ta hikawo ay bilang ampowako ha karegleman ta angkomontra kawo ha Diyos; kayà hay babon lotà ay ayin anan ka-ayosan, ta hay panonosga moyo ha tawtawo ay alwan matoynong. ");
INSERT INTO sbl_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Hinalità ko ya hikawo ay ampipamo-on ta anggomawà kawo nin para kongko, boy hikawoy kaganawan ay aw-anak nin Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Ombayroman, maski ampamo-on kawo ay mati kawo ta hikawo ay tawon bongat ya ma-in kamatyan.” ");
INSERT INTO sbl_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Pangino-on Diyos, manandalì kan manosga ha tawtawo bayri ha babon lotà ta hika ya ma-in ikon nin kaganawan nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","(Kanta ni Asap) Pangino-on Diyos, agka dayi magpa-olay no alwan gomawà ka! ");
INSERT INTO sbl_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Helken mo! Hay kawka-away mo ay ampipanggawà kagolowan; hay ampipag-inakit komo ay an-itag-ay lay olo la ha pagmalhay la. ");
INSERT INTO sbl_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Ha kagalingan lan manaktika ay ampagplano hilan kontra ha tawtawo mo, boy ampagtangka-an lay tawtawo moy amprotiksyonan mo. ");
INSERT INTO sbl_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Hay anhalita-en la ay ombayri: “Hali! Milalamo tamon mangapò konlan aw-inalalak ni Israyil emen aghilayna mapanemteman anggan makakanoman.” ");
INSERT INTO sbl_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Hila ay nangapimimiha nin nagplanon maggropo nin komontra komo. ");
INSERT INTO sbl_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Habayti ya nangapimimiha ay lawlipì nili Idom, Ismayil, Mowab, Agar, ");
INSERT INTO sbl_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gibal, Ammon, boy Amalik. Ma-in simprin nakilamo konlay Pawpilistiyo boy tawtaga Tiro. ");
INSERT INTO sbl_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Maski tawtaga Asirya ay nakilamo konla ta tinambayan lay aw-inalalak ni Lot emen lalò homkaw ya powirsa la. ");
INSERT INTO sbl_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Gaw-en mo konla ya bilang ha ginawà mo ha Mawmadyanita boy bilang ha pamati mo koni Sisira boy koni Habin do ha balah nin Kison. ");
INSERT INTO sbl_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Hila ay nati ha dogal ya an-ingaten Indor boy hay bawbangkay la ay nabolok ha lotà. ");
INSERT INTO sbl_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Gaw-en mo ha hawhiniral la ya bilang ha ginawà mo koni Orib boy koni Sib. Talowen moy pawpo-on la nin bilang ha ginawà mo koni Siba boy koni Salmona ");
INSERT INTO sbl_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","ya nigogropon naghalità nin ombayri: “Kowen tamon pag-ikon bayti ya dogal ya ampa-iriyan nin tawtawo ya kowinta ampastolan nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Diyos ko, ikakatak mo hila dayi nin bilang ha gabok boy bilang ha aw-apah ya angka-i-alipad nin angin. ");
INSERT INTO sbl_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","No pangno nin hay apoy ay ampakapo-ol nin bawbinagbag boy ampangopoh nin bawbakil ");
INSERT INTO sbl_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ay ombayro ya gaw-en mo konla. Manggawà kan kakalimowan la ya bilang ha makhaw ya bagyo emen hila mowayon pakarayò. ");
INSERT INTO sbl_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Deng-eyen mo hila, Pangino-on, emen hila magkama-in nin kahabekan nin makabalay komo. ");
INSERT INTO sbl_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Dayi ay talowen mo hila boy biyan mo hila nin ayin anggay kakalimowan; dayi hila ay mati ha kareng-eyan la. ");
INSERT INTO sbl_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Matanda-an la dayi ya hikan bongat ya Pangino-on ya Pinakamakapangyariyan ya Diyos ya ampamo-on bayri ha intiron babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","(Kantan aw-inalalak ni Kori) Pagkagandan bali mo, Pinakamakapangyariyan ya Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Masyado koynan angkahabek nin mako bayro ha bali nin Pangino-on, ta annakemen kon ma-ilobos ko ya pamakilamo ko kona, boy ma-in akon katowa-an nin magkanta ha Diyos ya angkabiyay. ");
INSERT INTO sbl_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Hay pawpipit ay ma-in ampa-iriyan; hay pawpalih itaman ay ampanggawà hayi ya pa-iriyan nin aw-a-akayen la ha danin altar mo, Pinakamakapangyariyan ya Pangino-on ya Arì ko boy Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Makalmà ya ampipampa-iri ha bali mo ya pirmin ampagkanta nin pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Makalmà ya tawtawoy ma-in kakhawan ya ampangibat komo; hila ay angkahabek nin mako ha bakil nin Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Mintras ampagpalako hila bayro ay niparaan hila ha dogal ya an-ingaten Baka ya hay labay totolen ay dogal ya panangihan. Bayro ay nanggawà hila nin libon ya nagkama-in hobol, gawà nin mahambak ya oran. ");
INSERT INTO sbl_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Ha pamomowako la, hila ay kapanhohomkaw anggan mi-abot hila ha Siyon ha arapan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Pangino-on Diyos ya Pinakamakapangyariyan, leng-en moy panalangin ko. Leng-en mo ko, Diyos ya pinahimala-an ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Pangino-on Diyos, bindisyonan moy arì ya pinilì mon pag-arì nawen. ");
INSERT INTO sbl_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Hay mihay allo ya pag-abalà ha lo-ob bali nin Diyos ay mas mahampat kisa liboliboy allo ya pag-abalà ha maski ayrin dogal. Mas labay ko et ya naka-ireng akon bongat nin bilang ha mihay bantay ha pagdanan nin lomo-ob ha bali nin Diyos kisa makilamo nin pa-iri ha ampa-iriyan nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Hay Pangino-on ay kowinta allo ya ampambin hawang, boy hiya ya halanggà nawen ha kawka-away nawen. Hiya simpri ya ampambi konnawen nin kahampatan ingangalo boy dangal. Ayin mahampat ya bagay ya agna igwà ha tawoy ampamiyay nin ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Pinakamakapangyariyan ya Pangino-on, makalmà ya tawoy ampahimalà komo. ");
INSERT INTO sbl_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","(Kantan aw-inalalak ni Kori) Pangino-on, hay dogal mo ay pinolalagan mo, boy pina-inomay mon oman ya aw-inalalak ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Inalih moy kawkasalanan nin tawtawo mo ta pinatawad mo hila, ");
INSERT INTO sbl_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","boy hay masyadoy pahang mo konla ay integen moyna. ");
INSERT INTO sbl_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Pangino-on Diyos ya Mapangilibri konnawen, itegen moy pamahang mo konnawen ta tambayan mo kayin oman nin maghehe ha kawkasalanan nawen. ");
INSERT INTO sbl_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Warì hay pahang mo konnawen ay ayin anan angga, boy warì agmoyna itegen bayti? ");
INSERT INTO sbl_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Hikayi ay kowinta nati; kayà biyayen mo kayin oman emen hikayi ya tawtawo mo ay mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Pangino-on, ipakit mo dayi konnawen ya ingangalo moy ma-in panlalabi, boy igwà mo konnawen ya kalibriyan. ");
INSERT INTO sbl_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Anleng-en ko ya anhalita-en nin Pangino-on Diyos. Impangakò na kontamon nag-in tawtawo na ya magkama-in tamon katinekan no agtamoyna mangoman manggawà nin ayin kowintay bawbagay. ");
INSERT INTO sbl_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Talagan ilibri nay tawtawo ya anggomalang kona, ta hiya ay pirmin anti bayri ha dogal tamo. ");
INSERT INTO sbl_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Hay ingangaloy ma-in panlalabi boy katapatan ay angkapilamo; ombayro simpri ha kahampatan boy katinekan. ");
INSERT INTO sbl_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Hay ka-ilangan nin omiral bayri ha babon lotà ay katapatan ha Diyos emen hiya ya anti ha katatag-ayan ha kama-inan na ay mambin kahampatan na. ");
INSERT INTO sbl_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Talagan igwà nin Pangino-on ya bawbagay ya mangahampat, boy hay dogal tamo ay pangalawahanan nin maganday alawah. ");
INSERT INTO sbl_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Hay Pangino-on ay ma-in kahampatan; kayà hay tawtawoy anhomonol kona ay dapat manowad kona. ");
INSERT INTO sbl_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","(Panalangin ni Dabid) Pangino-on, leng-en mo boy tobayen ya panalangin ko, ta hiko ay makapey ana boy ayin ampanambay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Ilibri mo ko ha kamatyan ta hiko ay tapat komo. Hika ya Diyos ko; ilibri mo ko ya magsisirbi mo ta ampahimalà ako komo. ");
INSERT INTO sbl_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Ingalowan mo ko, Pangino-on, ta pirmi kon andoma-ing komo. ");
INSERT INTO sbl_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Paligawen mo ko dayi, Pangino-on, ya magsisirbi mo ta hay sarili ko ay an-ipakarani ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Pangino-on, hika ay mahampat boy mapamatawad; ponò kan ingangaloy ma-in panlalabi ya para ha kaganawan andoma-ing komo. ");
INSERT INTO sbl_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Pangino-on, leng-en moy panalangin ko; leng-en moy an-ida-ing ko komoy tambay. ");
INSERT INTO sbl_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","No ma-in anlomateng kongkoy kagolowan ay ampangingat ako komo ta ampahimalà ako nin tobayen mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Kaganawan nin an-ingaten diyos bayri ha babon lotà ay ayin nin bilang komo, Pangino-on, boy ayin makagawà nin bilang ha gawgawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Hay tawtawoy pinalsa mo ha kaganawan nasyon ay pakaranin homamba komo, Pangino-on, boy mambi hilan ikapori nin ngalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Ayin kanayon ya Diyos no alwan hikan bongat; makapangyariyan ka boy hay gawgawà mo ay kawkapapa-ispanta. ");
INSERT INTO sbl_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Itorò mo kongko, Pangino-on, ya labay mon ipagawà kongko ta homonol ako komo nin ma-in katapatan. Toro-an mo kon magsirbi komo nin matibolos ya nakem. ");
INSERT INTO sbl_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Pangino-on kon Diyos, matibolos ya nakem kon mamori komo, boy poriyen koy ngalan mo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Hay ingangalo mo kongko ya ma-in panlalabi ay ayin kapantay; hiko ay inlibri mo ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Pangino-on kon Diyos, hay tawtawoy mapagmalhay ay ampipandawohong kongko; hay mangahiblet itaman ay labay mamati kongko. Habayti ya mangahiblet ay ahè ampagrispito komo. ");
INSERT INTO sbl_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Pangino-on, hika ya Diyos ya ma-ingangalowen boy malabi; alwa kan mapapahangen; maba-it ka boy tapat. ");
INSERT INTO sbl_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Asikasowen mo kon ingalowan; pakhawen mo ko boy ilibri, ta hiko ay ampagsirbi komo nin bilang pagsisirbi komo nin nanay ko. ");
INSERT INTO sbl_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Hika, Pangino-on, ya ampanambay boy ampanahaliwa kongko; kayà ipakit mo kongko ya hika ay ampangonsowilo kongko emen hay ampipag-inakit kongko ay mipareng-ey no makit la baytoy ombayro. ");
INSERT INTO sbl_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","(Kantan aw-inalalak ni Kori) Hay pinanggawa-an nin Diyos nin siyodad na ay ha masagradoy bakil. ");
INSERT INTO sbl_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Hay pawpolta nin habaytoy siyodad ya ampagdanan nin ampipampakon homamba kona ay ma-alagà ha Pangino-on nin igit ha kaganawan dogal ya ampa-iriyan nin aw-inalalak ni Hakob. Habayto ay anti ha dogal ya an-ingaten Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Hay hinalità ya tongkol bayri ha siyodad nin Diyos ay bawbagay ya kawkapapa-ispanta. ");
INSERT INTO sbl_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Pangilista ko nin nipampakabalay kongko ay ilamo koy tawtaga Ihipto boy tawtaga Babilonya; ombayro simpri ha tawtaga Pilistiya, tawtaga Tiro, boy tawtaga Itopya. Balang miha konla ay maghalità nin hila ay in-anak ha siyodad nin Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Hay halita-en ya tongkol ha Siyon ay ombayri: “Habayti ya miha boy habayto ay in-anak bayro, boy mismon Pinakamakapangyariyan ya Diyos ya mamakhaw nin habaytoy siyodad.” ");
INSERT INTO sbl_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Pangirihistro nin Pangino-on nin tawtawo ya nika-ibat ha hari-harì ya dogal ay ipatandà na ya hila ay in-anak ha Siyon. ");
INSERT INTO sbl_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Hay ampipagpalako ha Siyon nin homamba ha Diyos ay ampipanogtog boy ampipagkanta boy ampipaghalità nin ombayri: “Kaganawan kaligawan ay bayri ko natompakan.” ");
INSERT INTO sbl_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","(Kantan aw-inalalak ni Kori) Pangino-on Diyos ya Mapangilibri kongko, allo yabi kon andoma-ing komo. ");
INSERT INTO sbl_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Leng-en moy panalangin ko boy tobayen moy an-ida-ing ko komoy tambay. ");
INSERT INTO sbl_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Malakè ya anlomateng kongkoy kagolowan; kayà marani koynan mati. ");
INSERT INTO sbl_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Hiko ay kabilang ana ha tawtawoy malagayna mati, ta hiko ay bilang ha tawo ya na-alihan anan hokaw. ");
INSERT INTO sbl_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Pina-olayan ako nin bilang ha nati ya napati ha labanan, boy intabon ya agmoyna an-asikasowen boy bilang moynan niliwawan. ");
INSERT INTO sbl_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Hiko ay kowinta intapon mo ha pinakamalalè boy pinakamareglem ya lobot. ");
INSERT INTO sbl_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Hay tindi nin pahang mo ay nakapabyat nin tanam ko, ta habayto ay bilang ha mangalhay ya dawoyon ya nagbondag kongko. ");
INSERT INTO sbl_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Impakarayò mo kongko ya mangaheney aw-amigo ko ta ginawà mo kon karami-ilan la; kayà kapagkolongkolong ko tana ha ampa-iriyan ko. ");
INSERT INTO sbl_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ha kalele-an ko nin banà bayri ha andanasen ko, hay mata ko ay ambomereg ana. Allo-allo kon ampanalangin komo, Pangino-on, ya hay gawgamet ko ay nakatag-ay. ");
INSERT INTO sbl_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Warì hay nikati ana ay pakitan mo et nin pawpapag-ispantawan? Warì maka-ibangon hila et nin mamori komo? ");
INSERT INTO sbl_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Warì hay ingangalo moy ma-in panlalabi ay ma-ibabalità ha dogal nin nikati, o warì hay katapatan mo ay ma-ibabalità bayro? ");
INSERT INTO sbl_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Warì bayro ha dogal ya mareglem ay matanda-an ya ginawà moy pawpapag-ispantawan, o bayro ha dogal nin ayin pag-asa ay matanda-an ya kahampatan mo? ");
INSERT INTO sbl_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Maski ahè mangyari bayto, Pangino-on, hiko ay binabayombokan ampakarani komo nin manalangin, ta andoma-ing ako nin tambay. ");
INSERT INTO sbl_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Antà pina-olayan mo ko, Pangino-on, boy ahè an-asikasowen? ");
INSERT INTO sbl_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Pa-ibat hin anak ako, ka-apiyan ana ya andanasen ko ya halos makamati kongko, boy angkomapey anay nakem ko ha kapapalimoy an-iparanas mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Hay tindi nin pahang mo ay bilang nakahalokob kongko boy hay kapapalimoy pahang mo ay malaga makamati kongko. ");
INSERT INTO sbl_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Banà bayro, hiko ay bilang na-alipoteh nin malhay ya lanab, boy emen akon nakobkob nin habayto. ");
INSERT INTO sbl_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Hay aw-amigo ko boy nawnilabi ko ay impakarayò mo kongko; hapa-eg hay kalamo ko tana ay karegleman. ");
INSERT INTO sbl_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","(Kantay pakapowotan aral ya hinolat ni Itan ya inalalak ni Isra) Pangino-on, pirmi kon magkanta nin tongkol ha ingangalo moy ma-in panlalabi, boy ibabalità koy katapatan mo ha kaganawan lipì. ");
INSERT INTO sbl_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Ibalità ko ya hay ingangalo moy ma-in panlalabi ay ayin angga, boy hay katapatan mo ay manatili nin bilang ha bawbagay ya angkakit ha langit. ");
INSERT INTO sbl_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ombayri ya hinalità mo: “Ginawà koynay kasondo-an ha tawoy pinilì ko ya hi Dabid ya magsisirbi ko; hay impangakò ko kona ay ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Ha aw-inalalak mo ay pirmin ma-in mag-arì, boy manatili nin ayin angga ya ka-ari-an mo.’” ");
INSERT INTO sbl_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Pangino-on, hay aw-anghil ya anti ha katatag-ayan ha kama-inan mo ay ampipagkanta nin tongkol ha kawkapapa-ispantay gawgawà mo boy tongkol ha katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Ayin kanayon ha katatag-ayan ha kama-inan mo ya bilang komo, Pangino-on, ni aw-anghil ay ahè makapakipantay komo. ");
INSERT INTO sbl_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Ha pamititipon nin aw-anghil, hika ya Diyos ay talagan anggalangen la, boy kaganawan nin anti ha mamalibot mo ay angkatetegnan komo. ");
INSERT INTO sbl_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Pangino-on Diyos ya Pinakamakapangyariyan, ayin kanayon ya makapangyariyan no alwan hika, Pangino-on, boy pirmin anti komoy katapatan. ");
INSERT INTO sbl_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Banà ta anti ha hilong kapangyariyan mo ya dagat, maski mangalhay ya dawdawoyon ay angkapatinek mo. ");
INSERT INTO sbl_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Hay kakhawan nin nasyon Ihipto ay pina-anggawan mo nin bilang ha tawoy pinati, ta ha kakhawan nin kapangyariyan mo, hay kawka-away mo bayro ay tinalo mo. ");
INSERT INTO sbl_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Hika ya ma-in ikon nin langit boy lotà kateng anti bayro, ta hika ya namalsa nin kaganawan. ");
INSERT INTO sbl_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Hay mayanan boy bagatan ay hika ya ma-in gawà; hay bakil nin Tabor boy bakil nin Hirmon ay kowinta ampagtowà nin ampagkantan pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Talagan makapangyariyan ka boy masyadoy kakhawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Hay pamomo-on mo ay ma-in kahampatan boy makatoynongan; kaganawan anggaw-en mo ay ma-in panlalabi boy katapatan. ");
INSERT INTO sbl_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Makalmà ya tawtawoy anhomamba komo ya ha panhohomamba la ay angkantawan la ka, Pangino-on, boy ampangonsowilowan moy pamimiyay la. ");
INSERT INTO sbl_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Banà komo, hila ay pirmin ampagtowà boy ampamori komo ha kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Komo ampangibat ya karangalan boy kakhawan nawen, boy ha konsowilo mo konnawen, hikayi ay ambiyan mon pananalo. ");
INSERT INTO sbl_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Pangino-on, hika ya dipinsa nawen, boy hika ya ayin kapintasan ya pinahimala-an ni Israyil ya nambi konnawen nin pag-arì nawen. ");
INSERT INTO sbl_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Hin hato ay ma-in kan impakit ha tawtawo moy tapat boy naghalità ka nin ombayri: “Ha tawtawo ay namilì ako nin malagò ya lalaki ya binyan kon karapatan mamo-on boy binyan kon kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Habayti ya pinilì ko ay hi Dabid ya magsisirbi ko, boy hiya ay pinonahan ko nin masagradoy asiti. ");
INSERT INTO sbl_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Hiya ay pirmi kon protiksyonan boy biyan ko yan kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Hiya ay ahè matalo nin kawka-away na boy agya apiyen nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Hay kawka-away na ay pa-anggawan ko, boy hay ampipag-inakit kona ay papatyen ko. ");
INSERT INTO sbl_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Hay katapatan ko boy ingangalo koy ma-in panlalabi ay pirmin anti kona boy pirmi ko yan papanalowen. ");
INSERT INTO sbl_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","“Pa-ibat ha dagat nin Miditiranyo anggan balah nin Iyopratis ay ipasakop ko konan pag-ari-an na. ");
INSERT INTO sbl_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Hay halita-en na kongko ay ombayri: ‘Hika ya Tatay ko boy Diyos ko; hika simpri ya kowinta malhay ya bato ya dipinsa ko boy Mapangilibri kongko.’ ");
INSERT INTO sbl_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Habayti hi Dabid ay gaw-en kon bilang ha anak koy lalaki ya ponganay, boy gaw-en ko yan pinakamatag-ay ya arì bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Panatiliyen ko konay ingangalo koy ma-in panlalabi, boy hay pamakisondò ko kona ay ahè ma-anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ha aw-inalalak na ay ma-in mag-arì nin pirmiyan; hay pamomo-on na ay ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Piro no ahè homonol ha an-ipanogò ko ya aw-inalalak na, ");
INSERT INTO sbl_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ta agla leng-en ya tawtorò ko boy pawpanogò ko ");
INSERT INTO sbl_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ay parosawan ko hila ha kawkasalanan la boy biyan ko hilan para intindi ha kawkamali-an la. ");
INSERT INTO sbl_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Balè hay ingangalo koy ma-in panlalabi koni Dabid ay agko alihen, no alwan mag-in akon tapat kona. ");
INSERT INTO sbl_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Hay pamakisondò ko kona ay agko hira-en, boy ni miha ha pawpangakò ko kona ay agko bawi-en. ");
INSERT INTO sbl_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","“Hiko ya ayin kapintasan ay naghompà nin agko bongkoken hi Dabid. ");
INSERT INTO sbl_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Hiya ay pirmin ma-in inalalak ya ayin anggay pag-arì anggan anhomilà et ya allo. ");
INSERT INTO sbl_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Hay pag-arì na ay pirmiyan nin bilang ha bowan ya tapat nin ampamapteg ha katatag-ayan.” ");
INSERT INTO sbl_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Piro hapa-eg ay ampamahang ka ha arì ya pinilì mo, ta agmo ya tinanggap boy pina-olayan mo ya. ");
INSERT INTO sbl_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Binalawì moy kasondo-an mo ha magsisirbi mo, boy hay korona na ay intapon mo ha gabok. ");
INSERT INTO sbl_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Niyobà moy padir ya pinagkalingling nin siyodad na, boy hinira-hirà moy makhaw ya dipinsa na. ");
INSERT INTO sbl_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Kaganawan ampikahagoy ay ampanakaw nin kawkamama-in na, boy antoya-toya-en yan kawkarani na. ");
INSERT INTO sbl_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Hay kawka-away na ay pinapanalo mo; kayà masyadoy kaligawan la. ");
INSERT INTO sbl_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Hay aw-armas na ay ginawà mon ayin kowinta boy impatalo mo ya ha pamakilaban na. ");
INSERT INTO sbl_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Hay kagandawan boy kapangyariyan nin pagka-arì na ay inalih mo kona boy hinirà moy trono na. ");
INSERT INTO sbl_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Banà ha ginawà mo kona, maski ma-in ya et nin kalago-an ay emen yaynan mato-a, boy hiya ay pinnò mon kareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Pangino-on, ayin ana nayì nin angga ya agmo pangasikaso kongko? Hay pahang mo nayì kongko ay ayin anan angga nin bilang ha apoy ya ampangalatkat? ");
INSERT INTO sbl_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Panemtemen mo ya hay biyay ko ay ma-ipek bongat boy kaganawan tawoy pinalsa mo ay ma-in kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Warì ma-in tawo ya ahè mati? Warì ma-in tawoy makapilibri nin sarili na ha kamatyan? ");
INSERT INTO sbl_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Ayri anay ingangalo mo hin hato ya ma-in panlalabi boy pawpangakò mo koni Dabid ya pinanompa-an mon ma-in katapatan? ");
INSERT INTO sbl_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Pangino-on, agmo liwawan no pangno nin ininsolto ya magsisirbi mo ya ayin kanayon no alwan hiko, boy no pangno ko tine-eh ya pawpanginsolto kongko nin tawtawo ha kaganawan nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Hay kawka-away mo, Pangino-on ay ampanginsolto ha arì ya pinilì mo maski ayri ya mako. ");
INSERT INTO sbl_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Hay Pangino-on ay poriyen anggan makakanoman! Amin. Amin. ");
INSERT INTO sbl_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","(Habayti ay panalangin ni Moysis ya magsisirbi nin Diyos) Pangino-on, pa-ibat ha ka-ona-onawan lipì nawen ay hikayna ya dipinsa nawen. ");
INSERT INTO sbl_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Biha pinalsa ya bawbakil boy biha mo pinalway babon lotà ay Diyos kayna ya ayin pinangibatan boy ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Hay tawo, no nati ana ay an-ibira mon mag-in lotà ya pinangibatan na. ");
INSERT INTO sbl_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Hay maliboy ta-on komo ay bilang bongat kaboyot nin mihay allo ya nalabah, o bilang bongat ka-ipek nin mihay rilibo nin ampiririlibon magbantay no yabi. ");
INSERT INTO sbl_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Hay biyay nin tawo ay ma-ipek; habayti ay an-alihen mo nin bilang ha ampangyari ha bawbagay ya angkadanan nin lanab. Habayti ya biyay ay ayin imbalag ha ma-ipek bongat ya pangatoloy. Habayti ay bilang simpri ha dikot ya anlomaboyong no bayombokah, ");
INSERT INTO sbl_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","piro panlomateng nin mahilem, habayti ay angkalaneh ta angkayangoh. ");
INSERT INTO sbl_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Ha tindi nin pahang mo, hikayi ay bilang angka-opoh boy talagan angkalimo kayi ha masyadoy pahang mo. ");
INSERT INTO sbl_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Hay kawkasalanan nawen ay angkakit mo; kateng kawkasalanan ya an-itagò nawen ay mapatnag komo. ");
INSERT INTO sbl_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Ha kapahangan mo konnawen banà ha kawkasalanan nawen, hay biyay nawen ay tampol angkalabah nin bilang ha an-ihipen ya tampol na-alih ta kanayon ya na-ihipan. ");
INSERT INTO sbl_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Hay karà nin biyay nawen ay ma-arì omabot nin pitompò ya ta-on, balè no makhaw ya nawini nawen ay ma-arì omabot nin walompò. Piro peleg tamon angkabiyay, hitamo ay ma-in kagolowan boy kalele-an; ombayroman, hay biyay tamo ay maparan malabah. ");
INSERT INTO sbl_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Hinoy magtandà nin kapangyariyan nin pahang mo? Maski masyadoy pahang mo ay dapat nawen kan igalang. ");
INSERT INTO sbl_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Banà ha ka-ipekan nin biyay nawen ay toro-an mo kayi emen kayi domonong ha pamimiyay nawen. ");
INSERT INTO sbl_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Pangino-on, anggan makano mo bawi-en ya pahang mo konnawen? Ingalowan mo dayi ya mawmagsisirbi mo. ");
INSERT INTO sbl_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Binabayombokah ay ipatanam mo dayi konnawen ya ingangalo moy ma-in panlalabi emen leleg biyay nawen ay magkanta kayi nin ma-in katowa-an boy kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Biyan mo kayi dayin kaligawan ya bilang kaboyot nin imparanas mo konnawen ya ka-apiyan boy kalele-an. ");
INSERT INTO sbl_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Dayi ay ipakit mo ya kahampatan gawgawà mo konnawen nin mawmagsisirbi mo, boy ha aw-inalalak nawen ay ipakit mo dayi ya kagandawan mo boy kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Diyos ya Pangino-on nawen, pirmi mo kayi dayin polalagan, boy tambayan emen hay gawgawà nawen ay manatilin ma-alagà. ");
INSERT INTO sbl_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Hinoman ya anti ha Pinakamakapangyariyan ay ma-in protiksyon. ");
INSERT INTO sbl_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Mahalità na ha Pangino-on ya ombayri: “Hika ya protiksyon ko, dipinsa ko, boy Diyos ko ya ampahimala-an ko.” ");
INSERT INTO sbl_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Hika ay ilibri na ha kawkapiligrowan ya agmo tandà, boy hika ay ilibri na ha halot ya ampakamati. ");
INSERT INTO sbl_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Hika ay ma-in kalibriyan ha pangangasiwà na komo ta kopkopen na ka. Protiksyonan na ka boy idipinsa ha katapatan na. ");
INSERT INTO sbl_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Hay kawkakalimowan no yabi ay agmo kalimowan, boy no allo, anyaman ya lomateng ya alwan maganday pawpangyayari ay agka simpri malimo. ");
INSERT INTO sbl_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Ma-in man biglà lomateng ya halot no yabi, o alwan maganday pangyayari no allo ay agka malimo ta anti komoy Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Maski malibo katawo ya mati nin halot ha dani mo, o maski mapò et ya libo ay agka mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Hay gaw-en mo ay mangimaton kan bongat emen mo makit ya pamarosa ha mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Banà ta hay Pangino-on ay ginawà mon dipinsa mo boy anti ka ha Pinakamakapangyariyan ");
INSERT INTO sbl_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","ay ayin makapangno komo, ta anyaman ya kadisgrasyawan ay marayò ha ampa-iriyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Hay Diyos ay magmanda ha aw-anghil na nin mangi-atap komo maski ayri ka mako, ");
INSERT INTO sbl_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","boy alalayan la ka emen hay bitih mo ay ahè makhitan nin bato. ");
INSERT INTO sbl_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Maski manyabokyabok ka et nin lawliyon boy aw-otan ya nipagdità ay agka mapangno. ");
INSERT INTO sbl_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Hay hinalità nin Diyos ay ombayri: “Ilibri koy ampanlabi kongko boy i-atap koy ambomalay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Domawat ya kongko ta igwà koy andawaten na. No hiya ay ma-in kagolowan ay anti ko kona; ilibri ko ya boy biyan ko yan karangalan. ");
INSERT INTO sbl_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Pakalawigen koy biyay na boy lano ay ma-in yan kalibriyan ha kaparosawan pan-omarap na kongko.” ");
INSERT INTO sbl_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","(Kanta ya para ha allon pama-inawa) Hay mahampat nin gaw-en ay magpasalamat ha Pangino-on boy magkantan pamomori ha Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Hay mahampat et nin gaw-en no mahambak ay ibabalità ya tongkol ha ingangalo nay ma-in panlalabi; hay tongkol itaman ha katapatan na ay mahampat nin ibabalità no anyomabi ana. ");
INSERT INTO sbl_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Ha pangibabalità nin habayti ay kompanyawan nin istromintoy di kowirdas boy maganday togtog nin alpa. ");
INSERT INTO sbl_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Pangino-on, hay ginawà mo ay nakapaliga kongko; banà ha gawgawà mo ay magkanta kon ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Hay gawgawà mo, Pangino-on ay kawkapapa-ispanta boy hay pangingihip mo ay ahè makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ma-in mihay bagay ya ahè tandà nin tawoy ahè anggamiten ya ihip, boy ahè ma-intindiyan nin tawoy tangah. ");
INSERT INTO sbl_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Habayti ay tongkol ha tawtawoy mangala-et ya tampol an-omasinso nin bilang ha dawdikot ya maparan lomambot, balè hay ogotan la ay ayin anggawan ya kahira-an. ");
INSERT INTO sbl_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Piro hika, Pangino-on ay ahè mapantayan maski makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Hay kawka-away mo, Pangino-on ay sigoradon mikati boy kaganawan ampipanggawà nin kala-etan ay mikatalo. ");
INSERT INTO sbl_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Hiko ay ginawà mon makhaw nin bilang ha toron bakà ya balang, boy ha kahampatan mo ay binyan mo kon kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Nakit koy pagkatalo nin kawka-away ko, boy nalengè koy pami-o-onggok nin tawtawoy mapanggawà kala-etan banà ha pagkatalo la. ");
INSERT INTO sbl_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","No pangno ampanwalak ya po-on kayo ya bilang ha ongot banà ta malambot ay ombayro ya tawtawoy mangahampat; hila ay bilang simpri ha po-on kayoy sidro ya kayo ha Libanon ya maganday pantomobò. ");
INSERT INTO sbl_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Hila ay bilang simpri ha pawpo-on kayo ya intanem ha kolob bali nin Pangino-on. Habayti ay ampanwalak boy ampaka-anyoyong nin bali nin Diyos tamo. ");
INSERT INTO sbl_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Habayti ya tawtawoy mangahampat ay ampakinabangan et maski mangato-ayna, ta hila ay bilang ha po-on kayoy pirmin hariwà boy malaboyong, boy ayin tegen ha pamonga maski hay po-on ay mato-ayna. ");
INSERT INTO sbl_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Habayti ay ampamapteg nin hay Pangino-on ay mahampat; hiya ay kowinta malhay ya bato ya ampambin dipinsa kongko boy ayin kala-etan kona. ");
INSERT INTO sbl_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Hay Pangino-on ay ampamo-on; hiya ay ma-in masyadoy kagandawan boy kakhawan. Hay pinangipondasyonan nin babon lotà ay matibay; kayà maski anyay mangyari, habayti ay manatili. ");
INSERT INTO sbl_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Pangino-on Diyos, hay pamomo-on mo ay matatag ta pa-ibat hin ibat, hika ay hikayna. ");
INSERT INTO sbl_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Pangino-on, hay dawdawoyon ha dagat ay anhomlay; habayti ay ampambin dalleg ya kowinta bosis nin dagat. ");
INSERT INTO sbl_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Mas makapangyariyan ya Pangino-on ya ampamo-on ha katatag-ayan ha kama-inan na kisa kapangyariyan nin dawdawoyon ya anhomlay boy ha kowinta bosis nin dagat. ");
INSERT INTO sbl_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Pangino-on, hay pawpanogò mo ay ahè ma-anggawan, boy hay dapat ha bali ya paghambawan komo ay ayin kapintasan anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Pangino-on Diyos, hika ay ma-in karapatan nin mamarosa; ipatnag mo dayi ya karapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Hika ya ampanosga nin kaganawan tawo, manandalì ka ta hosgawan moy mangahambog nin nararapat konla. ");
INSERT INTO sbl_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Pangino-on, anggan makano mo payagan ya mangala-et ha gawgawà la? Anggan makano? ");
INSERT INTO sbl_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Anggan makano mo payagan ya mawmapanggawà kala-etan nin maghambog boy mangipagyabang nin gawgawà lay mangala-et? ");
INSERT INTO sbl_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Hay tawtawo mo, Pangino-on ay an-ipahilong nin hatoy mangala-et ha kapangyariyan la boy an-apiyen la. ");
INSERT INTO sbl_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Ampapatyen lay bawbawoy babayi, aw-olila, kateng dawdayowan ya ampa-iri ha dogal nawen. ");
INSERT INTO sbl_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Hay anhalita-en la ay ombayri: “Hikayi ay ahè angkakit nin Pangino-on; hay Diyos ya pinahimala-an ni Hakob ay ahè ampangasikaso konnawen.” ");
INSERT INTO sbl_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Hikawoy tawtawoy tangah ya ahè anggamiten ya pangingihip, makano kawo domonong? ");
INSERT INTO sbl_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Hay nanggawà nin tolih tamo boy mata tamo ay ahè warì ampakalengè boy ahè ampakakit? ");
INSERT INTO sbl_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Hay nawnasyon ay anti ha hilong kapangyariyan nin Diyos. Agna warì parosawan ya tawtawo? Hiya ya ampanorò ha tawtawo, ayin ya warì tinandà? ");
INSERT INTO sbl_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Tandà nin Pangino-on ya an-ihipen la; tandà nay ayin kowinta ya pawpangangatoynongan la. ");
INSERT INTO sbl_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Pangino-on, makalmà ya tawoy anwawaliyan mo boy antoro-an mo nin pawpanogò mo, ");
INSERT INTO sbl_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","ta ambiyan mo yan katinekan ha oras nin kagipitan anggan hay mangala-et ay parosawan ha gawgawà lay kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Ahè pa-olayan boy ahè alihan nin Pangino-on ya tawtawoy ikon na. ");
INSERT INTO sbl_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Mangyarin oman nin matoynong ya panonosga, boy habayti ay honolen nin kaganawan tawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Ayin nakikampi kongko nin komontra ha mangala-et; ni miha ay ayin nakikampi kongko nin komontra ha ampipanggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","No agko tinambayan nin Pangino-on ay nati koyna rayi. ");
INSERT INTO sbl_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Hinalità ko ya ombayri: “Marani koynan mati,” piro ha ingangalo mo, Pangino-on, ya ma-in panlalabi ay tinambayan mo kon pinakhaw. ");
INSERT INTO sbl_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Hin masyadon angkagolo ya ihip ko ay hinahaliwa mo kon pinaliga. ");
INSERT INTO sbl_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Hay mangala-et ya ampamo-on ya ampanggawà nin lawlayih ya alwan tamà ay ahè kampiyan nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Hila ay ampimimiha nin komontra ha tawtawoy mangahampat, boy hay ayin kasalanan ay ansintinsyawan lan kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Piro Pangino-on ya mambin protiksyon kongko, ta hiya ya Diyos ko ya kowinta malhay ya bato ya dipinsa ko. ");
INSERT INTO sbl_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Banà ha kawkasalanan la ay parosawan hila boy apo-en hila nin banà ha kala-etan la. Hay mangapò konla ay Pangino-on nawen Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Pakarani tamo ha Pangino-on ta magkanta tamo nin ma-in kaligawan kona; ipakakhaw tamoy bosis tamon mibobo-angaw ha Diyos ya kowinta malhay ya bato ya ampambin protiksyon kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Pakarani tamo kona ta pasalamatan tamo ya; ipakakhaw tamoy bosis tamon magkantan ma-in kaligawan ha pamomori kona, ");
INSERT INTO sbl_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","ta hay Pangino-on ay Diyos ya makapangyariyan. Hiya ya Arì ya makapangyariyan ha kaganawan andiyosen. ");
INSERT INTO sbl_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Hay intiron babon lotà ay anti ha hilong kapangyariyan na pa-ibat ha kalale-lale-an lotà angga ha toktok nin pinakamatag-ay ya bakil. ");
INSERT INTO sbl_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Hay dagat boy lotà ay ikon na ta hiya ya nanggawà. ");
INSERT INTO sbl_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Kayà pakarani tamon yomokò nin homamba kona; manalimokod tamo ha arapan nin Pangino-on ya namalsa kontamo, ");
INSERT INTO sbl_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","ta hiya ya Diyos tamo. Hitamo ya tawtawo ay an-asiwa-en na ta hiya ay bilang ha pastol ya ampangasiwà nin tawtopa. Leng-en moyo hapa-eg ya hawhalità nin Diyos ya hay anhalita-en ay ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Agmoyo patya-en ya nakem moyo nin bilang ha kawka-apo-apowan moyo hin anti hila ha powiray dogal nin Miriba ya an-ingaten et nin Masa. ");
INSERT INTO sbl_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Bayro la ko hinobok maski nakit layna ya gawgawà koy ikahampat la. ");
INSERT INTO sbl_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Lo-ob nin apatapò ya ta-on akon pinapahang nin habaytoy tawtawo; kayà ombayri ya hinalità ko: ‘Hila ay alwan tapat kongko ta aghila anhomonol ha an-ipanogò ko.’ ");
INSERT INTO sbl_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Banà bayro ay namahang ako boy pinanompa-an kon hinalità konla ya aghila makapahok nin pa-inawa ha dogal ya inhandà kon pa-iriyan la.” ");
INSERT INTO sbl_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Kantawan moyoy Pangino-on nin kinomposo ya bayoy kanta; kaganawan tawo ha babon lotà ay magkanta ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Kantawan moyoy Pangino-on; poriyen ya ngalan na. Allo-allo ay ibabalità moyoy tongkol ha pangilibri na. ");
INSERT INTO sbl_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Hay kagandawan na boy gawgawà nay kawkapapa-ispanta ay ibabalità moyo ha kaganawan tawo ha kaganawan nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Hay Pangino-on ay makapangyariyan boy hiya ay nararapat paporiyan. Hiya ay dapat igalang nin igit ha kaganawan andiyosen; ");
INSERT INTO sbl_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","ta kaganawan andiyosen nin tawtawo ha kanayon ya nawnasyon ay alwan peteg diyos, piro hay katatag-ayan ay Pangino-on ya ma-in gawà. ");
INSERT INTO sbl_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Hay kagandawan boy kapangyariyan ay anti kona; ombayro simpri ha masagradoy dogal ya kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Kaganawan tawo bayri ha babon lotà ay homamba ha Pangino-on; poriyen moyoy Pangino-on ha kagandawan na boy kapangyariyan na. ");
INSERT INTO sbl_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Ha panhomamba moyo ha Pangino-on ay igwà moyo kona ya pamomori ya nararapat ha ngalan na; ha pamako moyo ha bali na ay mantan kawon idolog moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Hambawen moyoy Pangino-on ta hiya ay ayin kapintasan boy masyadoy kagandawan na; kaganawan tawo bayri ha babon lotà ay mamegpeg ha arapan na ha panggogomalang kona. ");
INSERT INTO sbl_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Ombayri ya halita-en moyo ha tawtawo ha kaganawan nasyon: “Hay Pangino-on ay ampamo-on; hay babon lotà ay matibay ya pagkapondasyon; kayà habayti ay manatili. Hiya ay manosga ha tawtawo nin ma-in katoynongan.” ");
INSERT INTO sbl_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Dayi, hay langit boy lotà ay kowinta magtowà; ombayro simpri ha dagat kateng anti bayro ay kowinta tomnoy ha katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Dayi, kaganawan nin pananamanan ay kowinta magtowà kateng nin kaganawan bagay ya anti bayro. Ha ombayro, kaganawan po-on kayo ha binagbag ay kowinta mipagkanta nin ma-in katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Habayti ay kowinta mipagkanta ha arapan nin Pangino-on ha lomateng ya. Hiya ay lomateng nin manosga ha tawtawo bayri ha babon lotà; hay panonosga na ay ma-in kahampatan boy matoynong. ");
INSERT INTO sbl_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Hay Pangino-on ay ampamo-on; dayi, kaganawan nin anti ha babon lotà ay mipagtowà; ombayro simpri ha malakè ya isla ya anti ha dawdagat. ");
INSERT INTO sbl_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Hay Pangino-on ay napalibotan nin mareglem ya leem (hin nag-aypà ya ha bakil nin Sinay); hay kahampatan boy katoynongan ay pondasyon nin pagka-arì na. ");
INSERT INTO sbl_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ma-in apoy ya angka-ona kona ya ampamo-ol nin kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Hiya ay ampamakilat ya ampakahawang nin babon lotà; habayti ay angkakit nin kaganawan tawo ha babon lotà boy hila ay ampamegpeg. ");
INSERT INTO sbl_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Ha arapan nin Pangino-on, hay lawlotà nin bawbakil ay matonaw nin bilang ispirma; habayti ay matonaw ha arapan nin Pangino-on ya ampamo-on ha kaganawan ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Hay langit ay ampangipatnag nin kahampatan na boy angkakit nin kaganawan tawo ya kagandawan na. ");
INSERT INTO sbl_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Kaganawan nin anhomamba ha rawribolto ya alwan peteg diyos ya an-ipagmalhay la ha sarili la ay mipareng-ey. Kaganawan anghil ay manalimokod nin homamba ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Hay tawtawo ha dogal ya an-ingaten Siyon ay ampipagtowà. Ombayro simpri ha tawtaga Hoda banà ha panonosga moy makatoynongan, Pangino-on; ");
INSERT INTO sbl_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","ta hika, Pangino-on ay Pinakamakapangyariyan ha kaganawan ha babon lotà; hika simpri ya pinakamatag-ay ha kaganawan andiyosen. ");
INSERT INTO sbl_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Hay ampanlabi ha Pangino-on ay angka-inakit ha kala-etan. An-i-atap nin Pangino-on ya nag-in tawtawo na boy an-ilibri na hila ha kapangyariyan nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Anhawangan nin Pangino-on ya nakem nin tawtawoy mangahampat boy hila ay ambiyan nan kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Hikawoy mangahampat ay magtowà ha Pangino-on boy poriyen moyoy ngalan na ya ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Kantawan moyoy Pangino-on nin kinomposo ya bayoy kanta, ta hay bawbagay ya ginawà na ay kawkapapa-ispanta. Hiya ay ayin kapintasan; ha kapangyariyan na ay ma-in tamon kalibriyan ha panggogomawà na. ");
INSERT INTO sbl_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Impatandà nin Pangino-on ya pangilibri na, boy impatnag nay kahampatan na ha tawtawo ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Hay impangakò nay ingangalo ya ma-in panlalabi boy katapatan na ha aw-inalalak ni Israyil ay gineperan na. Kaganawan tawo ha maski ayrin dogal bayri ha babon lotà ay nakatandà nin kalibriyan ya inggawà nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Hikawoy tawtawo ha kaganawan dogal ha babon lotà, mibobo-angaw kawon magtowà ha Pangino-on. Ha masyadoy kaligawan moyo ay magkanta kawon pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Magkanta kawon pamomori ha Pangino-on ya kompanyawan moyon alpa. Ha panogtog moyo nin alpa ay lamowan moyo nin maganday kanta. ");
INSERT INTO sbl_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Hay tonoy nin trompita boy tonoy nin tamboyok ay sabayan moyo nin pamibobo-angaw ya ma-in katowa-an ha arapan nin Pangino-on ya Arì. ");
INSERT INTO sbl_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Dayi, hay dagat ay kowinta tomnoy kateng kaganawan nin anti bayro; hay babon lotà itaman ay kowinta magkanta; ombayro simpri ha kaganawan ampa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Dayi, hay bawbalah ay kowinta mipagtimpà, boy dayi, hay bawbakil ay kowinta mipagkanta ha katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Dayi, hay bawbakil ay kowinta mipagkanta ha arapan nin Pangino-on, ta lomateng ya nin manosga ha kaganawan tawo ha babon lotà. Ha panonosga na ha tawtawo ay ma-in yan kahampatan boy katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Hay Pangino-on ay ampamo-on; dayi, hay tawtawo ay mipamegpeg ha panggogomalang la kona. Hiya ay ampiknò ha trono na ha piha-etan nin aw-anghil ya an-ingaten kirobin; dayi, hay babon lotà ay ma-eyeg. ");
INSERT INTO sbl_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Makapangyariyan ya Pangino-on ya anti ha dogal ya an-ingaten Siyon; hiya ya ampamo-on ha tawtawo ha kaganawan nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Dayi, hila ay mamori ha ngalan nay makapangyariyan ya ahè makwan ihipen ta hiya ay ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Makapangyariyan ya Arì ya labaylabay ya matoynong. Kaganawan gawà mo ay makatoynongan. Talagan matoynong boy mahampat ya ginawà mo ha aw-inalalak ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Poriyen ya Pangino-on nawen Diyos, boy manalimokod ha arapan na ha panhomamba kona, ta hiya ay ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Hi Moysis boy hi Aron ay kabilang ha pawparì nin Diyos; hi Samwil ay kabilang ha andomawat ha ngalan nin Diyos; hila ay nakirawat ha Pangino-on Diyos boy hiya ay tinombay konla. ");
INSERT INTO sbl_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Hay Pangino-on ya anti ha leem ay naghalità konla; hay pawpanogò ya inggawà na konla ay hinonol la. ");
INSERT INTO sbl_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Pangino-on nawen Diyos, tinobay mo hila boy impakit mo ya hika ay Diyos ya mapamatawad maski pinarosawan mo hila ha kawkasalanan la. ");
INSERT INTO sbl_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Poriyen ya Pangino-on nawen Diyos boy hambawen ya ha masagradoy bakil ya kama-inan na, ta hay Pangino-on ya Diyos nawen ay ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Kaganawan tawo ha babon lotà ay mibobo-angaw nin magtowà ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Magsirbi kawo ha Pangino-on nin ma-in kaligawan, boy magtowà kawon magkanta ha pamakarani moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Tanda-an moyo ya hay Pangino-on ay Diyos; hiya ya namalsa kontamo boy hitamo ay ikon na. Hitamo ay tawtawo na ya an-asiwa-en na nin bilang ha tawtopa ya ampastolan na. ");
INSERT INTO sbl_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Lomo-ob kawo ha poltan kolob nin bali nin Diyos nin ma-in pasasalamat, boy mamori kawo kona ha panlomo-ob moyo bayro. Mambi kawon pasasalamat kona boy poriyen moyoy ngalan na, ");
INSERT INTO sbl_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","ta hay Pangino-on ay mahampat, boy ayin anggay ingangalo nay ma-in panlalabi. Hay katapatan na ay magpatoloy ha kaganawan lipì. ");
INSERT INTO sbl_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","(Kanta ni Dabid) Pangino-on, hay kantawen ko ay tongkol ha ingangalo moy ma-in panlalabi boy tongkol ha katoynongan mo. Magkanta kon pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ogali-en kon mamiyay nin ahè mapintasan. Makano mo ko pakaraniyan? Ipakit ko ha pamilya ko ya hiko ay mamiyay nin ma-in kalinisan nakem. ");
INSERT INTO sbl_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Agko konsintiyen ya kala-etan. Hay gawgawà nin tawtawoy alwan tapat ay angka-inakitan ko. Agko ma-arì nin makilamo konla. ");
INSERT INTO sbl_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Pakatapat ako boy agko mangihip o manggawà nin kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Hay tawoy sikriton ampanirà nin kapara na ay agko konsintiyen; agko simpri konsintiyen ya tawoy mapagmalhay boy mahambog. ");
INSERT INTO sbl_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Hay tawtawo balè ya mapahimala-an ay payagan kon pa-iri ha dogal ya habayti, boy hay talagan tapat ay payagan kon magsirbi kongko. ");
INSERT INTO sbl_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Hay tawtawoy alwan tapat ay agko payagan pa-iri ha bali ko; ombayro simpri ha mangabongkok. ");
INSERT INTO sbl_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Allo-allo, alihen koy kaganawan mangala-et ha dogal ya habayti. Hay ampipanggawà kala-etan ay pa-alihen ko bayri ha siyodad nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Leng-en moy panalangin ko, Pangino-on; leng-en mo dayi ya an-ida-ing ko komoy tambay. ");
INSERT INTO sbl_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Agmo ko pa-olayan no ma-in akon kagipitan. No ampangingat ako komo ay leng-en mo ko ta tampol mo kon tobayen. ");
INSERT INTO sbl_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Hay biyay ko ay emen bongat ha ahok ya angkapanew, boy hay bawbot-o ko ay emen angkapo-olan nin bilang ha bayah ya pagka-a-amot. ");
INSERT INTO sbl_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Banà bayri, hiko ay ayin imbalag ha dikot ya nayangoh; kayà angkaliwawan koyna ya pamangan ko. ");
INSERT INTO sbl_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ha masyadoy pami-a-anito ko ay kakatatkatat ako tana boy kabobot-o. ");
INSERT INTO sbl_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Hiko ay emen ha mihay klasin manokmanok ya malelè ya anti ha powiray dogal, boy hiko ay emen ha bo-ok ya ampagpirmi ha nahirà ya dogal. ");
INSERT INTO sbl_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Maski ampirà ako ay agko makakatoloy; kayà emen akon manokmanok ya malelè ya anti ha toktok nin bobongan. ");
INSERT INTO sbl_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Ayin tegen ya panginsolto kongko nin kawka-away ko; hay ampipamahang kongko ay ampangihompà kongko. ");
INSERT INTO sbl_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Hay pamamangan ko ay nala-okan nin aboh boy hay inomen ko ay nala-okan nin lowà ko. ");
INSERT INTO sbl_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Habayti ay nangyari banà ha masyadoy pahang mo kongko. Pina-inomay mo ko pon biha mo in-aypà ya kapapa-hal ko. ");
INSERT INTO sbl_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Hay biyay ko ay bilang bongat ha anino ya angka-alih no anyomabi ana; hiko ay ayin imbalag ha dikot ya nayangoh. ");
INSERT INTO sbl_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Piro hika, Pangino-on, hay pag-arì mo ay ayin angga; kaganawan lahì ay ahè makaliwa komo. ");
INSERT INTO sbl_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Tandà koy asikasowen mon ingalowan ya nahirà ya dogal ya an-ingaten Siyon, ta nilomateng anay tamà ya pana-on nin ipakit moy pangingangalo mo ha dogal ya habayto. ");
INSERT INTO sbl_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Ma-alagà ha mawmagsisirbi mo baytoy dogal kateng bawbato bayro. Habaytoy dogal ay nag-in gabok; kayà malelè hila ha pagkahirà nin habayto. ");
INSERT INTO sbl_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Hay tawtawo ha nawnasyon ay gomalang ha Pangino-on; kaganawan arì bayri ha babon lotà ay gomalang ha kapangyariyan na. ");
INSERT INTO sbl_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Ha ibangon oman nin Pangino-on nin hatoy nahirà ya dogal ya an-ingaten Siyon ay ipatnag nay kagandawan na bayro. ");
INSERT INTO sbl_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Hay an-ida-ing nin tawtawoy ma-irap ay tobayen na. Talagan leng-en nay an-ida-ing la. ");
INSERT INTO sbl_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Habaytoy gawgawà nin Pangino-on ay iholat para ha homonoy lawlipì emen maski aghila et in-anak hapa-eg, lano ay mamori hila ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Hay Pangino-on ya anti ha kama-inan na ha katatag-ayan ay ampanlonglong ha lotà. ");
INSERT INTO sbl_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Anleng-en nay pami-a-anito nin pawpiriso boy ilibri nay tawtawoy sinintinsyawan patyen. ");
INSERT INTO sbl_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Banà bayri, hay ngalan nin Pangino-on ay ibabalità ha dogal ya an-ingaten Siyon ya ayin kanayon no alwan siyodad nin Hirosalim, boy bayro ya poriyen ");
INSERT INTO sbl_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","pamititipon nin tawtawo bayro kalamoy tawtaga kanayon ya nasyon ha panhomamba la ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Malagò ako et ay pinakapey akoyna nin Pangino-on, boy hay biyay ko ay bilang nan ampa-ipeken. ");
INSERT INTO sbl_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Kayà hinalità ko ya ombayri: “Pangino-on kon Diyos, agmo pon dayi kowen ya biyay ko ta alwa ko et mato-a. “Pangino-on, hay biyay mo ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Hin ka-ona-onawan, hika ya namalsa nin lotà, boy gamet mo ya nanggawà nin langit. ");
INSERT INTO sbl_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Kaganawan nin habayti ay ma-in anggawan, piro hika ay manatili anggan makakanoman. Habayti ya pawpinalsa mo ay doma-an nin bilang ha dolo ya no ayin anan kowinta ay itapon ana ta pahiliyan. ");
INSERT INTO sbl_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Piro hika ay ahè ampangoman, agka tomo-a, boy agka mati. ");
INSERT INTO sbl_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Hay aw-inalalak nin mawmagsisirbi mo ay mamiyay nin ma-in kalibriyan ta hila ay pirmi mon protiksyonan.” ");
INSERT INTO sbl_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","(Kanta ni Dabid) Poriyen koy Pangino-on; hiya ya ayin kapintasan ay poriyen ko nin lobos ha nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Poriyen koy Pangino-on boy agko liwawan ya kaganawan gawà nay mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ampatawaren nay kaganawan kasalanan ko boy ampakahampaten nay kaganawan masakit ko. ");
INSERT INTO sbl_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","An-ilibri na ko ha kamatyan, boy hay masyadoy ingangalo nay ma-in panlalabi ay an-igwà na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Hay biyay ko ay ampon-en nan mangahampat ya bawbagay; ha ombayro, maski mato-a koyna ay mag-in akon bilang malagò ya ma-in kakhawan nin bilang ha kakhawan nin agila. ");
INSERT INTO sbl_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Kaganawan ampika-apih ay ambiyan nin Pangino-on nin kahampatan boy katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Impatandà nin Pangino-on koni Moysis ya pawplano na, boy impakit nay gawgawà na ha aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Hay Pangino-on ay ma-ingangalowen boy anti konay kahampatan. Hiya ay alwan mapapahangen boy ponò yan ingangaloy ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Agya ampagtanem nin irap nakem boy agna ampanatiliyen ya pahang na. ");
INSERT INTO sbl_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Agna tamo binawehan nin pinarosawan nin parosay nararapat ha kawkasalanan tamo, ");
INSERT INTO sbl_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","ta no pangno katag-ay ya langit ha babon lotà ay ombayro ya ingangalo nay ma-in panlalabi ha ampipanggomalang kona. ");
INSERT INTO sbl_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","No pangno karayò ya baytan ha babà ay ombayro karayò ya pangipakarayò nan kawkasalanan tamo ya inalih na kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","No pangno nin hay tatay ay ampangingangalo ha aw-anak na ay ombayro ya pangingangalo nin Pangino-on ha ampipanggomalang kona, ");
INSERT INTO sbl_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","ta tandà nay kakapeyan tamo boy tandà na ya hitamo ay yarì ha lotà. ");
INSERT INTO sbl_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Hay biyay nin tawo ay ma-ipek nin bilang ha dikot boy bilang ha bolaklak nin masitas ya balang ya tampol angkalaneh. ");
INSERT INTO sbl_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Pamakasopla nin angin, habayti ay ampi-alipad boy agana makit. ");
INSERT INTO sbl_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Piro hay ingangalo nin Pangino-on ya ma-in panlalabi ay ayin angga ha ampipanggomalang kona, boy hay kahampatan na ay anti ha kaganawan lipì ");
INSERT INTO sbl_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","ya anhomonol ha kasondo-an na boy ahè ampakaliwa nin homonol ha pawpanogò na. ");
INSERT INTO sbl_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Hay pamomo-on nin Pangino-on ay anti ha katatag-ayan ha kama-inan na boy hiya ya ampamo-on ha kaganawan. ");
INSERT INTO sbl_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Poriyen moyoy Pangino-on, hikawoy mangakhaw boy makapangyariyan ya aw-anghil ya ampipanhomonol ha pawpanogò na boy ampipanlengè ha anhalita-en na. ");
INSERT INTO sbl_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Poriyen moyoy Pangino-on, hikawoy kaganawan nin ampa-iri ha katatag-ayan ya mawmagsisirbi nay ampanggawà kalabayan na. ");
INSERT INTO sbl_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Kaganawan pinalsa nin Pangino-on ha kaganawan dogal ya ampamo-onan na ay dapat mamori kona. Poriyen koy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Poriyen koy Pangino-on; Pangino-on kon Diyos, hika ay masyadon makapangyariyan; ponò kan karangalan boy kagandawan. ");
INSERT INTO sbl_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Hika ay ponò nin kahawangan, boy hay langit ay inwadwad mo nin bilang ha tolda. ");
INSERT INTO sbl_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ha babo nin lawlanom ha katatag-ayan ay bayro mo imbangon ya pa-iriyan mo; hay lawleem ay kowinta karwahi ya anhakyan mo, boy habaytoy lawleem ay angka-i-alipad nin makhaw ya angin. ");
INSERT INTO sbl_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Hay angin ay anggaw-en mon kowinta hogò mo, boy hay kawkilat ay kowinta mawmagsisirbi mo. ");
INSERT INTO sbl_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Hay pinangipondasyonan mo nin babon lotà ay matibay; kayà habayti ay ahè magalaw. ");
INSERT INTO sbl_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Hay dagat ay emen ha dolo ya inwadwad mo ha babon lotà; banà bayro, hay bawbakil ay ahè makit ta nahalipawan nin lanom. ");
INSERT INTO sbl_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Piro hin namakorol ka ha pana-ad mo nin lanom, hay lanom ay biglà nin nog-alih. ");
INSERT INTO sbl_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Habayti ay nan-agoh nin pa-ibat ha bawbakil angga ha manga-aypà ya dawdogal ya inhandà mon pangitiponan nin lanom. ");
INSERT INTO sbl_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Nanggawà kan anggawan nin lanom emen hay babon lotà ay agana mahalipawan oman nin lanom. ");
INSERT INTO sbl_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Hay Pangino-on ay nama-agoh nin lanom ha hawhapà ha piha-etan nin bawbakil. ");
INSERT INTO sbl_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Banà bayri ha ginawà na, kaganawan mangahilib ya ayop kateng aw-asnoy balang ya angka-angan ay ma-in ma-inom. ");
INSERT INTO sbl_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Hay mawmanokmanok ay ampipanayi boy ampipagkanta ha hawhanga nin kawkayo ya marani bayri ha lanom. ");
INSERT INTO sbl_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Hay oran ya ampangibat ha langit ay an-igwà nin Pangino-on emen hay bawbakil ay mabohbohan. Banà bayro, hay babon lotà ay makab-in ikahampat ha panggogomawà na. ");
INSERT INTO sbl_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ampatobo-en nay dawdikot emen ma-in ma-ekan ya aw-ayop, boy hay tawtanaman ya an-itanem nin tawtawo ay ampatobo-en na emen hila ma-in ma-ekan. ");
INSERT INTO sbl_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Bayri ha tawtanaman ay ma-in obas ya ampakakwawan nin inomen ya ampakapaligan nakem nin tawo; ma-in et bayri nin aw-olibo ya ampakab-in kalighawan, boy ma-in tanaman ya ampakakwawan nin pamamangan ya ampakab-in kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Hay kawkayo ya ikon nin Pangino-on ay ambohbohan nan mahampat; habayti ay pawpo-on kayoy sidro ya anti ha Libanon ya intanem na. ");
INSERT INTO sbl_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Hay mangayamò ya mawmanokmanok ay ampipanayi bayro; hay mangalhay balè ya mawmanokmanok ay ampanayi ha kanayon ya klasin kayo. ");
INSERT INTO sbl_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Hay mangatag-ay ya bawbakil ay ampa-iriyan nin kawkanding ya balang; hay kawkonihon bato itaman ay ampa-iri ha bawbato. ");
INSERT INTO sbl_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Hay bowan ya pinalsa mo, Pangino-on ay ampakatanda-an nin pana-on; hay allo itaman ay anhomlep ha tamà ya oras. ");
INSERT INTO sbl_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Hika ya nanggawà nin yabi ya mareglem; no yabi, hay aw-ayop ha binagbag ay antomalà. ");
INSERT INTO sbl_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Hay lawliyon ay ampan-aglem ha panikap lan pamamangan ya an-igwà konla nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","No anhomilà anay allo, hila ay ampagbiran mirà ha pama-imalmalan la. ");
INSERT INTO sbl_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Hay tawtawo itaman, ha ombayroy oras ay ampakon magtrabaho anggan mahilem. ");
INSERT INTO sbl_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Pangino-on, malakè ya ginawà mo, boy kaganawan nin habayti ay ginawà mo ha karonongan mo. Hay babon lotà ay ponò nin pawpinalsa mo. ");
INSERT INTO sbl_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ma-in dagat ya malawang ya hay pawpinalsa moy anti bayro ay mangalhay boy mangayamò ya ahè mabilang. ");
INSERT INTO sbl_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Hay bawbarko ay makori makoro nin ampagdaan bayro, boy hay pinalsa moy masyadon kalhayan ikan ay anti bayron mamaliyawliyaw. ");
INSERT INTO sbl_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Kaganawan nin habayti ya pinalsa mo ay komo an-omasa, Pangino-on. An-omasa hila nin hika ya mambi konla nin pamamangan ha oras nin panganga-ilangan la. ");
INSERT INTO sbl_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Hay an-igwà mo konla ay antiponen la, boy kontinto hila ha mangahampat ya bawbagay ya an-igwà mo konla. ");
INSERT INTO sbl_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","No anhalibokotan mo hila ay angkahlak hila; no bawi-en moy inawawen la ay mati hila, boy mangoman hilan mag-in lotà. ");
INSERT INTO sbl_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Ombayri simpri ya ampangyari ha tawtawo. Piro pangihogò mo nin Ispirito mo ay magkama-in ana et nin bayoy lipì; ha ombayro ay mag-in bayo ya makit ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Hay kagandawan nin Pangino-on ay ayin angga; magtowà ya Pangino-on ha ginawà na. ");
INSERT INTO sbl_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Tegtegen nan bongat ya babon lotà, habayti ay ma-eyeg ana; hay bawbakil ay ampan-ahok no an-aptohen na. ");
INSERT INTO sbl_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Hay Pangino-on ay pirmi kon kantawan, boy leleg kon angkabiyay ay magkanta kon pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Dayi, hay kanta ko ay makapakonsowilo kona mintras angkantawen koy pamomori ko kona nin ma-in katowa-an. ");
INSERT INTO sbl_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Piro hay mawmakasalanan ya mangala-et ay ma-alih dayi ha babon lotà. Hiko ay mamori ha Pangino-on. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Pasalamatan moyoy Pangino-on ha pangingat moyo nin ngalan na; hay gawgawà na ay ibabalità moyo ha tawtawo ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Kantawan moyo ya nin kantay pamomori; ibabalità moyoy kaganawan gawà nay kawkapapa-ispanta. ");
INSERT INTO sbl_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Poriyen ya ngalan nay ayin kapintasan. Dayi, hay ampikahabek nin makabalay ha Pangino-on ay mipagtowà. ");
INSERT INTO sbl_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Pakarani kawo konan makirawat nin kakhawan, boy hay pirmi moyon sikapen ay mamori kona emen ya mangonsowilo komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Hikawoy lipì ni Hakob ya pinilì nin Diyos ya ayin kanayon no alwan aw-inalalak ni Abraham ya magsisirbi nin Diyos, panemtemen moyoy gawgawà nin Diyos ya masyadon kapapa-ispanta boy panonosga na ha kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Hiya ay Pangino-on ya Diyos tamo; hiya ya ampanosga ha kaganawan ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Hay kasondo-an ya ginawà na, anggan makakanoman ay agna anliwawan; ombayro simpri ha pawpangakò na ha liboliboy lipì. ");
INSERT INTO sbl_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Habayti ya kasondo-an ya ginawà na koni Abraham ay impangakò na koni Isak nin toparen na. ");
INSERT INTO sbl_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Habayti ya kasondo-an ya ayin anggawan ay pinaptegan na koni Hakob ya an-ingaten et Israyil ha paghalità na nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“Igwà ko komo bayti ya dogal ya an-ingaten Kana-an nin pag-ikon mo.” ");
INSERT INTO sbl_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Hin hato, hay aw-inalalak ni Abraham ay a-amò et, boy bilang hilan bongat dawdayowan bayro ha dogal ya impangakò konla. ");
INSERT INTO sbl_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Kayà ampikambyakambya hila nin nasyon ya pa-iriyan la. ");
INSERT INTO sbl_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Ombayroman ay ahè pinayagan nin Diyos ya hila ay apiyen, boy ha pangi-atap na konla, hay aw-arì ay anha-aren na ha paghalità na nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Hay tawtawoy pinilì ko boy pawpropita ko ay agmoyo pakakhitan.” ");
INSERT INTO sbl_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Hapa-eg, do ha dogal ya an-ingaten Kana-an ay pinangyari nin Pangino-on nin magkama-in bitil; kayà ayin hilaynan mapangwanan nin pamamangan bayro ha dogal la. ");
INSERT INTO sbl_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Banà bayro, hi Hosi ay inhogò nin Diyos nin pina-ona konla. Hiya ay inlakò ta pag-alilà. ");
INSERT INTO sbl_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Bayro ha dogal ya pinipalakwan na, hay bawbitih na ay nakhitan nin tikalà ya pinamalol kona, boy hay le-ey na ay tinikala-an la nin pahak. ");
INSERT INTO sbl_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Habayti ay panonobok nin Pangino-on koni Hosi anggan nagkapeteg baytoy hinalità ni Hosi hin hato. ");
INSERT INTO sbl_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Banà bayro, hiya ay pinalayà nin arì ya ampama-alà ha tawtawo bayro ha nasyon Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Hi Hosi ay ginawà nan mama-alà ha kawkamama-in na boy ha kaganawan dogal nin habaytoy nasyon. ");
INSERT INTO sbl_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Ha pamama-alà ni Hosi, kaganawan ampipamo-on bayro ay anti ha hilong kapangyariyan na, boy antoro-an nay mangato-a emen domonong. ");
INSERT INTO sbl_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Hapa-eg hi Hakob ya an-ingaten et Israyil kateng aw-anak na ay nakon napa-iri ha nasyon Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Mintras anti hila bayro ay pinalakè hila nin Pangino-on, boy hila ay ginawà nan mas makhaw ha kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Hay tawtaga Ihipto ay pinayagan nin Pangino-on nin mag-inakit boy manloko ha tawtawo nay mawmagsisirbi na. ");
INSERT INTO sbl_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Hapa-eg, inhogò nin Pangino-on hi Moysis ya magsisirbi na boy hi Aron ya pinilì na. ");
INSERT INTO sbl_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Bayro ha nasyon Ihipto ay impakit la ha tawtawo ya gawgawà nin Diyos ya masyadon kapapa-ispanta. ");
INSERT INTO sbl_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Habaytoy dogal ay pinareglem nin Pangino-on; ombayroman, hay tawtaga Ihipto ay ahè simpri hinomonol ha hinalità konla nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Hay lawlanom nin bawbalah bayro ay nag-in dayà, gawà nin Pangino-on; kayà hay kawkonà bayro ay nikati. ");
INSERT INTO sbl_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Habaytoy dogal ay napnò nin pawpahingà kateng kawkowartoy pangatoloyan nin ampipamo-on bayro. ");
INSERT INTO sbl_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Immanda nin Diyos ya magkama-in nin lawlangoh boy kawkotoh; kayà habaytoy dogal ay napnò nin lawlangoh boy kawkotoh. ");
INSERT INTO sbl_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Hiya ay nama-oran nin yilo boy namakilat ha dogal ya habayto. ");
INSERT INTO sbl_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Banà bayro ay nangahihirà ya tawtanaman lay aw-obas boy aw-igos, boy hay kanayon ya pawpo-on kayo bayro ha dogal la ay nangatotombah. ");
INSERT INTO sbl_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Immanda nin Diyos ya magkama-in nin dawdoron; kayà nagkama-in ya ha kalak-an ay ahè mabilang. ");
INSERT INTO sbl_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Kaganawan nin tanaman la bayro ay kinan nin hatoy dawdoron. ");
INSERT INTO sbl_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Kaganawan ponganay ya lalaki nin tawtaga Ihipto ay pinatipati nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Hapa-eg, inalih nin Diyos ha nasyon Ihipto ya Aw-israylita. Hila ay nantan nin pawpilak boy gawgintò ya ikon nin tawtaga Ihipto. Ha pamog-alih la bayro, hilay kaganawan ay mangakhaw boy mangaligha. ");
INSERT INTO sbl_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Hay tawtaga Ihipto ay natowà hin nog-alih anay Aw-israylita ta masyado hilan angkalimo do ha imparanas konla nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Ha paninigè nin Aw-israylita ay ma-in leem ya ampaka-amey konla ya inggawà nin Pangino-on; no yabi ay ma-in apoy ya ampambi konla nin hawang. ");
INSERT INTO sbl_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Hin nangawok hila nin pamamangan ha Pangino-on ay binyan na hila nin pawpoyò, boy pinasasà na hila nin pamamangan ya iningat lan Mana ya nangibat ha katatag-ayan. ");
INSERT INTO sbl_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Hay ginawà et nin Pangino-on ay namalwan lanom ha bato. Habaytoy lanom ay biglà nilomwah ya nan-agoh nin bilang balah ha maklang ya lotà do ha powiray dogal. ");
INSERT INTO sbl_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Hay masagradoy pangakò nin Pangino-on koni Abraham ya magsisirbi na ay agna niliwawan. ");
INSERT INTO sbl_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Hay tawtawo na ya inalih na ha nasyon Ihipto ay ma-in kaligawan; habayti ya pinilì na ay ampipambo-angaw banà ha katowa-an la. ");
INSERT INTO sbl_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Hapa-eg, hay dogal ya an-ingaten Kana-an ya ampa-iriyan pon nin kanayon ya tawtawo ay inggawà nin Pangino-on konlan Aw-israylita. Kayà hay tawtanaman bayro ya pinagpagalan nin kanayon ay hila ya nakinabang. ");
INSERT INTO sbl_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Habayti ay ginawà nin Pangino-on konla emen hila homonol ha pawpanogò na. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Poriyen moyoy Pangino-on. Pasalamatan moyoy Pangino-on ta hiya ay mahampat, boy hay ingangalo nay ma-in panlalabi ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Ma-in warì makapaghalità nin tongkol ha kaganawan nin makapangyariyan ya gawgawà nin Pangino-on, o makapaghalità nin kaganawan pamomori ya nararapat kona? ");
INSERT INTO sbl_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Makalmà ya tawtawo ya hay gawgawà ay matoynong boy pirmin ampanggawà kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Pangino-on, panemtemen mo ko ha panambay mo nin tawtawo mo; ilamo mo ko ha pangilibri mo konla. ");
INSERT INTO sbl_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","No ombayro ay maranasan koy ka-inomayan nin tawtawoy pinilì mo, makapaki-atag ako ha kaligawan la, boy makapakilamo ko ha tawtawo mo nin mamori komo. ");
INSERT INTO sbl_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Nagkasalanan kayi nin bilang ha kawka-apo-apowan nawen, ta nakagawà kayi nin alwan tamà boy masyadoy kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Hay kawkapapa-ispanta ya gawgawà nin Diyos ay ahè inintindi nin kawka-apo-apowan nawen hin anti hila ha nasyon Ihipto; agla simpri pinanemtem ya masyadoy ingangalo nay ma-in panlalabi, no alwan nagribildi hila ha Pinakamakapangyariyan ya Diyos hin anti hila ha Dagat ya Ma-orit. ");
INSERT INTO sbl_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Ombayroman ay inlibri na hila emen ya maparangalan, boy emen na ma-ipakit ya masyadoy kapangyariyan na. ");
INSERT INTO sbl_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Minandawan nay Dagat ya Ma-orit nin komlang; kayà nagkama-in nin piha-etan ya kinomlang ya bilang kaklang nin lotà ha powiray dogal. Hapa-eg, bayro na hila pinaraan nin nagpalako ha kagmang. ");
INSERT INTO sbl_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Inlibri na hila ha kawka-away la ya ampipag-inakit konla. ");
INSERT INTO sbl_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Ni miha ha kawka-away la ya nangamat konla ay ayin natilà ta nikalemeh. ");
INSERT INTO sbl_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Banà bayro, hay Aw-israylita ya tawtawo nin Diyos ay ninto-o ha pawpangakò na; kayà nagkanta hila nin pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Piro tampol lan niliwawan baytoy ginawà nin Diyos boy aghila nakipapano kona. ");
INSERT INTO sbl_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Bayro ha powiray dogal ay hinobok lay Diyos ha pangawok la nin kanayon ya klasin pamamangan ya angkahabekan la. ");
INSERT INTO sbl_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Hay inawok la ay inggawà konla nin Diyos, piro habayto ay ahè nakapakhaw nin pantotompel la, no alwan kinomapey hila ta pinamasakit hila nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Bayro ha powiray dogal ay pinag-inggitan la hi Moysis kateng hi Aron ya imbokod nin Pangino-on nin magsirbi kona. ");
INSERT INTO sbl_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Hi Datan boy hi Abiram kateng pawpamilya la ay in-amon nin lotà, ");
INSERT INTO sbl_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","boy ma-in apoy ya nag-aypà ya namo-ol nin mangala-et ya kalamowan nin hatoy in-amon nin lotà. ");
INSERT INTO sbl_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ha bakil nin Horib, hay Aw-israylita ay nanggawà nin riboltoy oybon bakà ya yarì ha gintò, boy hinomamba hila bayro. ");
INSERT INTO sbl_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Hay kagandawan nin Diyos ay pinahiliyan lan ribolto nin toron bakà ya hay bakà ay ampangan dikot. ");
INSERT INTO sbl_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Naliwawan lay Diyos ya nangilibri konla ha kapangyariyan nin gawgawà na hin anti hila ha nasyon Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Habaytoy gawgawà na bayro ha nasyon Ihipto ay kawkapapa-ispanta; talagan kawkapapa-ispanta ya gawgawà na do ha Dagat ya Ma-orit. ");
INSERT INTO sbl_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Banà ha pamakaliwa la ha Diyos ay hinalità nin Diyos ya papatyen na hila, piro hi Moysis ya pinilì nin Diyos ay namiha-etan nin naki-i-ingalo ha Diyos emen hay pahang na ya papatyen na hila ay agnayna itoloy. ");
INSERT INTO sbl_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Hay maganday dogal ya an-igwà konla nin Diyos ay tinanggi-an la, ta aghila ninto-o ha pangakò konla nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Hay ginawà la ay nagkolong hila ha tawtolda la. Bayro, hila ay ampipagdalamorom ta agla labay homonol ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Kayà hay hompà konla nin Pangino-on ay mati hila ha powiray dogal, ");
INSERT INTO sbl_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","boy hay aw-inalalak la ay pa-olayan nin Diyos, boy pikakataken na hila ha kanayon ya dawdogal boy bayro hilayna mati. ");
INSERT INTO sbl_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Hay Aw-israylita ay nakilamo nin hinomamba ha ribolto ni Ba-al ha bakil nin Biyor, boy bayro hila naki-emen nangan nin pamamangan ya indolog ha andiyosen lay ayin biyay. ");
INSERT INTO sbl_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Banà bayro ha mangala-et ya gawgawà la, hay Pangino-on ay namahang konla; kayà binyan na hila nin kapapalimoy halot ya nakapisti konla. ");
INSERT INTO sbl_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Piro hay ginawà ni Pini-is ya parì ay pinarosawan nay ma-in kasalanan nin habayto; kayà tinonggen ya pisti. ");
INSERT INTO sbl_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Habayti ya ginawà ni Pini-is ya kahampatan ay agana maliwawan anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Hay Pangino-on ay pinapahang nin Aw-israylita hin anti hila ha dogal ya an-ingaten Miriba. Hi Moysis man ay nagkama-in problima nin banà konla. ");
INSERT INTO sbl_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Masyadon nakhitan ya nakem ni Moysis; kayà napalalngatan na hilan pinaghalita-an. ");
INSERT INTO sbl_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Hin ni-abot hila ha dogal ya an-ingaten Kana-an, hay immanda konla nin Diyos ya patyen lay tawtawo bayro ay agla ginawà, ");
INSERT INTO sbl_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","no alwan hay ginawà la ay nakilamo hila konla boy nanowad ha gawgawà la. ");
INSERT INTO sbl_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Habayti ya Aw-israylita ya tawtawo nin Diyos ay hinomamba ha alwan peteg diyos ya anhambawan nin tawtawo bayro. Banà bayri ha ginawà la ay lalò hilan nipakarayò ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Hay aw-anak la ay an-idolog la ha dawdimonyo. ");
INSERT INTO sbl_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Habayti ay ampatyen la pon biha la idolog ha alwan peteg diyos ya andiyosen nin tawtawo bayro ha Kana-an; habaytoy dogal ay dinomemek banà ha dayà nin aw-anak lay pinatipati la. ");
INSERT INTO sbl_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Hilan mismo ya nandemek nin sarili la, ta hay gawgawà la ay masyadon kala-etan boy alwa hilan tapat ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Banà bayro, hay Diyos ay namahang ha tawtawo na boy pinag-inakitan na hila. ");
INSERT INTO sbl_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Hila ay pina-olayan na ha kapangyariyan nin tawtawoy ahè antompel ha Diyos, boy hay mamo-on konla ay kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Hila ay inapih boy sinakop nin kapangyariyan nin kawka-away la. ");
INSERT INTO sbl_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Malakè ya bisis nin inlibri hila nin Pangino-on, piro nilabay lan komontra kona; kayà lalò hilan nagkasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Ombayroman, hin dinoma-ing hila ha Pangino-on ay nilengè na hila boy inasikaso na hila ha kagipitan la. ");
INSERT INTO sbl_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Alang-alang konla ay napanemteman nay kasondo-an na, boy banà ha ingangalo nay ma-in panlalabi ay pinaghehean nay ginawà na. ");
INSERT INTO sbl_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Impanakem nin Pangino-on do ha nipanakop konla ya ingalowan hila. ");
INSERT INTO sbl_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Pangino-on nawen Diyos, ilibri mo kayi boy ibiran pititiponen nin mangibat ha dawdogal ya kama-inan nawen emen nawen mapasalamatan ya ngalan moy ayin kapintasan, boy magkama-in kayin katowa-an ha pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Poriyen ya Pangino-on ya Diyos ya pinahimala-an nin aw-inalalak ni Israyil. Hiya ay poriyen nin ayin angga. Dayi, kaganawan tawo ay maghalità nin “Amin!” Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Pasalamatan moyoy Pangino-on nin banà ha kahampatan na. Hay ingangalo nay ma-in panlalabi ay ahè ma-anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Hay inlibri nin Pangino-on ha kapangyariyan nin kawka-away ay magpasalamat dayi kona ");
INSERT INTO sbl_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","ta hila ay imbira nan pinititipon ha sarili lan dogal nin nangibat ha kanayon ya dawdogal ya anti ha bandan baytan, babà, mayanan, boy bagatan. ");
INSERT INTO sbl_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Hay kanayon konla ay nitala-talà ha powiray dogal ha panikap la nin siyodad ya mapa-iriyan la, piro ayin hilan nakit. ");
INSERT INTO sbl_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Hila ay nabitlan boy na-angan; banà bayro ay na-alihan hilan hokaw. ");
INSERT INTO sbl_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Hapa-eg, hay angkagolowan la ay inda-ing la ha Pangino-on; kayà inlibri hila nin Pangino-on ha kagipitan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Hila ay intoto na ha tamà ya daan ya palako ha siyodad ya pa-iriyan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Dayi ay magpasalamat hila ha Pangino-on ha ingangalo nay ma-in panlalabi, boy ha kapapa-ispantay bawbagay ya ginawà na ha tawtawo; ");
INSERT INTO sbl_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","ta hay ampika-angan ay ampapda-en nan pa-inomen, boy hay ampikabitlan ay ampakanen nan mangaganday bawbagay. ");
INSERT INTO sbl_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Hay kanayon konla ay ampa-iri ha mareglem boy malelè ya dogal nin bilang ha pawpirisoy nakatikalà boy ampag-irap; ");
INSERT INTO sbl_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","ta aghila hinomonol ha kawkapanogo-an nin Diyos, boy angka-inakitan lay wawwawali nin Pinakamakapangyariyan ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Kayà hila ay ginawà nan magmaka-aypà ha pamatrabaho na konla nin tawtrabahoy mangabyat; banà bayro, hila ay nipatombah boy ayin nanandan nin manambay konla. ");
INSERT INTO sbl_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Hapa-eg, hay angkagolowan la ay inda-ing la ha Pangino-on; kayà inlibri hila nin Pangino-on ha kagipitan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Hila ay inalih na ha karegleman boy binoboytò nay tawtikalà ya pinangitikalà konla. ");
INSERT INTO sbl_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Dayi, magpasalamat hila ha Pangino-on ha ingangalo nay ma-in panlalabi, boy ha kapapa-ispantay bawbagay ya ginawà na ha tawtawo, ");
INSERT INTO sbl_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","ta hay pawpoltay tangsò ya poltan siyodad kateng rawrihas ya pahak ay winatakwatak na. ");
INSERT INTO sbl_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Hay kanayon konla ay nag-in tangah banà ha agla panhomonol, boy nagdya-dyà hila banà ha kawkasalanan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Maski anyay klasin pamamangan ay aglayna labay boy marani hilaynan mati. ");
INSERT INTO sbl_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Hapa-eg, hay angkagolowan la ay inda-ing la ha Pangino-on; kayà inlibri hila nin Pangino-on ha kagipitan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ha halità nan bongat, hila ay hinomampat boy inlibri na hila ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Dayi ay magpasalamat hila ha Pangino-on ha ingangalo nay ma-in panlalabi, boy ha kapapa-ispantay bawbagay ya ginawà na ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Dayi, hila ay homamba kona nin ma-in lamoy pasasalamat boy magkanta hila nin ma-in katowa-an ha pamomori la kona banà ha gawgawà na. ");
INSERT INTO sbl_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Hay kanayon konla ay nakahakay ha barko ya ampagbiyahi ha malawang ya dagat ta bayroy ampanikapan lan ikabiyay la. ");
INSERT INTO sbl_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Bayro ha dagat ay nakit lay gawgawà nin Pangino-on boy kawkapapa-ispantay bagay ha lalè nin habayto. ");
INSERT INTO sbl_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Hay angin ay minandawan nin Diyos nin homkaw; kayà hay dawdawoyon ay hinomlay. ");
INSERT INTO sbl_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Banà bayro, hay barko la ay ampitag-ay biha biglà mag-aypà; hila ay ampamiligro boy angka-alihan hilaynan pag-asa. ");
INSERT INTO sbl_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Mamatotompahil hila nin bilang ha tawtawoy lahing; kayà ayin hilaynan magawà ta hay dinonong la ha pamapowayon barko ay aglayna ma-igosar. ");
INSERT INTO sbl_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Hapa-eg, hay angkagolowan la ay inda-ing la ha Pangino-on; kayà inlibri hila nin Pangino-on ha kagipitan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Hay bagyo ay pinategen na boy pinatinek nay dawdawoyon. ");
INSERT INTO sbl_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Hin nagkalmay angin boy dawdawoyon ay nagtowà hila, boy inggiya na hilan nagpalako ha pantalan ya labay lan lakwen. ");
INSERT INTO sbl_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Dayi, magpasalamat hila ha Pangino-on ha ingangalo nay ma-in panlalabi, boy ha kapapa-ispantay bawbagay ya ginawà na ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Dayi, Pangino-on ya itag-ay ha pamititipon nin kalak-an tawo, boy hiya ay poriyen ha arapan nin mangato-ay ampipamo-on. ");
INSERT INTO sbl_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Hay ginawà nin Pangino-on ay pinaklang nay bawbalah nin bilang kaklang nin lotà ha powiray dogal, boy agna pina-agoh ya hawhobol. ");
INSERT INTO sbl_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Hay matabà ya lotà ay ginawà nan ayin kowinta ta pina-alat na banà ha kala-etan nin ampipampa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Hay maklang ya lotà ya powiray dogal ay ampalanoman na ha pama-agoh na bayro nin hawhobol. ");
INSERT INTO sbl_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Hay ampikabitlan ay bayro na anggitan nin manggawà nin siyodad ya pa-iriyan la. ");
INSERT INTO sbl_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Hila ay ampananaman ha pawpaliyan la boy ampananem hila nin aw-obas; habaytoy tawtanaman la ay ampangalawahanan la nin maganday alawah. ");
INSERT INTO sbl_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Hay tawtawo na ay ambiyan nan ka-inomayan. Ampakalak-en nay alalak la; ombayro simpri ha aw-ayop la, boy hay aw-ayop la ay agna ambiyan dipirinsya. ");
INSERT INTO sbl_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Hapa-eg hay tawtawo na ay an-omamò boy ampag-in ma-aypà ya kapapa-hal nin banà ha pagka-apih, kagolowan, boy kalele-an ya anlomateng konla. ");
INSERT INTO sbl_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Hay tawtawoy mangatag-ay ya katongkolan ay anheheen nin Pangino-on, boy an-ikakatak na hilan ipalako ha pawpowiray dogal ya ahè anlakwen nin tawo. ");
INSERT INTO sbl_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Hay ampipanga-ilangan balè ay an-ilibri na ha ka-apiyan boy hay pawpamilya la ay ampakalak-en na. ");
INSERT INTO sbl_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Hay tawtawoy mangahampat ya makakit nin habayti ay mipagtowà, piro hay mangala-et ay ahè makatlek. ");
INSERT INTO sbl_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Hinoman ya maronong ay mangasikaso dayi nin bawbagay ya habayti, boy dayi, hay ingangalo nin Pangino-on ya ma-in panlalabi ay balayen la. ");
INSERT INTO sbl_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","(Kanta ni Dabid) Diyos ko, hiko ay disididon homonol komo; talagan disidido ko. Banà bayri ay i-oboh koy kakhawan ko ha pagkanta kon pamomori komo. ");
INSERT INTO sbl_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","“Mibangon ka,” wangko ha sarili ko. “Mibangon ka ta manogtog ka nin alpa boy lira.” Mahambak akon mibangon ta mamori ko ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Pasalamatan kata, Pangino-on, ha tawtawo, boy magkanta kon pamomori komo ha nawnasyon. ");
INSERT INTO sbl_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Hay ingangalo mo ya ma-in panlalabi ay ahè makwan ihipen; ombayro simpri ha katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Diyos ya ayin kapantay, ipatnag moy kapangyariyan mo ha katatag-ayan; ha babon lotà itaman ay ipatnag moy kahawangan nin kagandawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Ilibri mo kayi nin kapangyariyan mo; tobayen moy panalangin ko emen hay tawtawoy anlabiyen mo ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Hiko ay magtowà ta hay Diyos ya ayin kapintasan ay naghalità boy nagpangakò nin ombayri: “Hay siyodad nin Sikim ay atag-atagen ko kateng patal ya dogal ya an-ingaten Sokot ta igwà ko ha tawtawo ko. ");
INSERT INTO sbl_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Hay pinagdogalan ni Gala-ad boy ni Manasis ay ikon ko. Hay pinagdogalan ni Ipra-im ay kowinta hilmit ko; hay pinagdogalan itaman ni Hoda ay bayro ampangibat ya kawkapanogo-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Hay dogal ya an-ingaten Mowab ya kowinta palanggana ya pag-oyahan ko ay nasakop koyna. Hay dogal itaman ya an-ingaten Idom ay bayro ko inggawà ya sandalyas ko bilang tandà ya habayto ay sasakopen ko. Hiko ay mambo-angaw ha pananalo ko ha tawtaga Pilistiya.” ");
INSERT INTO sbl_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Hinoy mantan kongko ha siyodad ya napalibotan nin dipinsa, boy hinoy mangigiya kongkon mako ha dogal ya an-ingaten Idom emen ko masakop bayto? ");
INSERT INTO sbl_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Diyos ko, alwa nayì hika ya tinomanggì konnawen boy agka nakilako ha hawhondalò nawen? ");
INSERT INTO sbl_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Tambayan mo kayin lomaban ha kawka-away nawen, ta hay tambay nin tawo ay ayin kowinta. ");
INSERT INTO sbl_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Hikayi ay manalo ha tambay nin Diyos ta talowen nay kawka-away nawen. ");
INSERT INTO sbl_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","(Kanta ni Dabid) Diyos ya pirmi kon amporiyen, dayi ay gomawà ka ");
INSERT INTO sbl_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","ta hay tawtawoy mangala-et boy mangabongkok ay ampipaghalità nin kawkabongkokan ya kontra kongko. ");
INSERT INTO sbl_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Hay anhalita-en la kongko ay panay inakit, boy maski ayin bara-nan ay angkalabanen la ko. ");
INSERT INTO sbl_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ha bokotan nin panlalabi ko konla ay angkontrawen la ko, piro an-ipanalangin ko hila simpri. ");
INSERT INTO sbl_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Hay an-ibaweh la kongko ha anggaw-en ko konlay kahampatan ay kala-etan, boy inakit ya an-ibaweh la kongko ha panlalabi ko konla. ");
INSERT INTO sbl_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Mamilì kan mala-et ya tawoy komontra ha ka-away ko; dayi, miha ha kawka-away na ay mamingga kona. ");
INSERT INTO sbl_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Dayi, pamakalitis kona ay lomwah nin hiya ay ma-in kasalanan, boy hay panalangin na ya malibri ya ha kasalanan na ay habayto dayi ya makapipakala-et kona. ");
INSERT INTO sbl_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Dayi, hay biyay na ay pa-ipeken emen ya mapahiliyan nin kanayon ha katongkolan na. ");
INSERT INTO sbl_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Dayi, hay aw-anak na ay ma-olila boy mabawo ya ahawa na. ");
INSERT INTO sbl_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Dayi, hay aw-anak na ay mipantomalà nin makilimoh, boy dayi, hila ay palayasen ha ampa-iriyan lay dogal ya nahirà. ");
INSERT INTO sbl_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Dayi, kaganawan kamama-in na ay imbargowen nin pinangotangan na; dayi, hay pinagpagalan na ay mipalako ha dawdayowan. ");
INSERT INTO sbl_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Dayi, ni miha ay ayin maka-ingalo kona; ombayro simpri ha aw-anak nay ma-olila na. ");
INSERT INTO sbl_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Dayi, kaganawan inalalak na ay mati, boy hay ngawngalan la ay agana mapanemteman nin homonoy lipì. ");
INSERT INTO sbl_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Dayi, hay kawkasalanan nin kawka-apo-apowan na ay ahè maliwawan nin Pangino-on, boy dayi, hay kawkasalanan nin nanay na ay ayin kapatawaran. ");
INSERT INTO sbl_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Dayi, hay kawkasalanan la ay ahè maliwawan nin Pangino-on, boy dayi, hila ay agana mapanemteman bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Habaytoy tawoy mala-et ay ayin ginawà ya kahampatan; hay manga-irap boy ampipanga-ilangan kateng tawtawoy ayin anan pag-asa ay ampapatyen na. ");
INSERT INTO sbl_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ma-ilig yan mangihompà; kayà dapat yan ihompà. Agya ampangingangalo; kayà alwa yan dapat ingalowan. ");
INSERT INTO sbl_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Hay anggaw-en nay pangihompà ay pinagkadolo nayna. Habayti dayi ya pangihompà na ay tom-ep ha nawini na boy ha bot-o na nin bilang ha lanom boy asiti ya anggamiten na. ");
INSERT INTO sbl_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Habayti dayi ay agana ma-alih kona nin bilang ha dolo ya nakaholot kona boy bilang ha sintoron ya nakatatagkeh kona. ");
INSERT INTO sbl_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Ombayri dayi ya pamarosa nin Pangino-on ha kawka-away koy ampipaghalità nin kala-etan ya tongkol kongko. ");
INSERT INTO sbl_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Piro Pangino-on kon Diyos, tambayan mo ko emen hay ngalan mo ay maparangalan; ha kahampatan nin panlalabi mo ay ilibri mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Hiko ay ma-irap boy ampanga-ilangan; habayti ya pa-hal koy ombayri ay angkakhitan ya nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Hay biyay ko ay bilang bongat ha anino ya angka-alih no anyomabi ana, boy bilang bongat ha doron ya angka-i-alipad nin angin. ");
INSERT INTO sbl_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Hay tawto-ol ko ay makapey ana nin banà ha kabitilan ko, boy hiko ay masyadoynan ebeng. ");
INSERT INTO sbl_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Hay kawka-away ko ay ampanoya-toyà kongko boy kaganawan nin ampakakit kongko ay ampipampeyeng nin mangka-ili kongko. ");
INSERT INTO sbl_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Pangino-on kon Diyos, tambayan mo ko; banà ha ingangalo moy ma-in panlalabi ay ilibri mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Pangino-on, ipatandà mo ha kawka-away ko ya hika ya nangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Hila ay ma-arì nin mangihompà kongko, piro hika ay ampangingangalo kongko. Dayi, hay ampamadya-dyà kongko ay mikatalo, balè hiko ya magsisirbi mo ay magtowà. ");
INSERT INTO sbl_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Dayi, hay kawka-away ko ay mapotot nin kakareng-eyan nin bilang ha dolo ya nakaholot ha nawini la. ");
INSERT INTO sbl_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Mambi kon masyadoy pasasalamat ha Pangino-on boy poriyen ko ya ha pamititipon nin tawtawo, ");
INSERT INTO sbl_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","ta hiya ya ampangidipinsa ha tawoy ma-irap boy ampangilibri ha kaparosawan ya an-isintinsya kona nin kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","(Kanta ni Dabid) Hinalità nin Pangino-on Diyos ha Pangino-on ko ya ombayri: “Miknò ka ha bandan wanan ko anggan hay kawka-away mo ay talowen ko boy igwà ko hila ha hilong nin kapangyariyan mo.” ");
INSERT INTO sbl_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Hay Pangino-on ay mambi komon kapangyariyan mamo-on ya mangibat ha dogal ya an-ingaten Siyon. Hika ay mamo-on ha kawka-away mo. ");
INSERT INTO sbl_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ha allo nin labanan moy kawka-away mo, hay tawtawowan moy lawlalaki ay mipagbolontad nin makilamo komo. Hila ay ayin imbalag ha deyang no mahambak nin banà ha kalago-an la, boy hila ay makilamo komo nin mako ha masagradoy bawbakil. ");
INSERT INTO sbl_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Hay Pangino-on ay naghompà nin nagpangakò nin ombayri: “Hika ay parì anggan makakanoman nin bilang koni Milkisidik ya parì hin hato.” ");
INSERT INTO sbl_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Hay Pangino-on ay anti ha bandan wanan mo; hay aw-arì ay talowen na ha allo nin hiya ay mamahang. ");
INSERT INTO sbl_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Hosgawan nay nawnasyon boy hay dawdogal ya ampilalabanan ay datakan nan bawbangkay, ta pahoko-en nay ampipamo-on ha intiron babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Hiya ay minom ha hapà ya anti ha pingit daan; banà bayro, hiya ay homkaw boy talowen nay kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Poriyen moyoy Pangino-on. Hay Pangino-on ay pasalamatan ko nin lobos ha nakem ko ha pamititipon nin tawtawoy ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Hay gawgawà nin Pangino-on ay ahè mapantayan. Habayti ay labay ma-intindiyan nin kaganawan ampangonsowilo bayri. ");
INSERT INTO sbl_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Ponò karangalan boy kagandawan ya gawgawà na boy ayin anggay kahampatan na. ");
INSERT INTO sbl_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Hay kawkapapa-ispantay gawgawà nin Pangino-on ay pirmi nan an-ipapanemteman. Hiya ay mahampat boy ma-ingangalowen. ");
INSERT INTO sbl_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ambiyan nan pamamangan ya ampipanggomalang kona, boy hay ayin anggay kasondo-an na ay agna anliwawan. ");
INSERT INTO sbl_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Impakit nay kapangyariyan nin gawgawà na ha Aw-israylita ya tawtawo na ha pangigwà na konla nin dogal ya an-ingaten Kana-an nin pag-ikon la ya ampag-ikonen pon nin kanayon ya tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Hay gawgawà nin Pangino-on ay ma-in kaptegan boy matoynong; kaganawan an-ipanogò na ay mapahimala-an. ");
INSERT INTO sbl_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Habayti ya an-ipanogò na ay manatili nin ayin angga ta habayti ay ginawà nin ma-in kaptegan boy kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Inlibri nay tawtawo na, boy nanggawà yan ayin anggay kasondo-an konla. Hiya ay ayin kapintasan boy dapat igalang. ");
INSERT INTO sbl_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Hay ona nin gaw-en emen domonong ay igalang ya Pangino-on; kaganawan anhomonol ha an-ipanogò na ay ampagkama-in pangingintindi. Hiya ay dapat poriyen nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Poriyen moyoy Pangino-on. Makalmà ya tawoy anggomalang ha Pangino-on, boy masyado nan an-ikaliga ya panhohomonol na ha an-ipanogò nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Hay aw-inalalak na ay magkama-in ka-inomayan ha dogal la, boy balang lipì nin mahampat ya tawo ay magkama-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Hay pamilya na ay mag-inomay boy yomaman, boy hay kahampatan na ay manatili nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Hay tawoy mahampat ay maba-it boy ma-ingangalowen. Maski ma-in anlomateng ha biyay nay alwan maganday pangyayari ya kowinta karegleman ay angkapahiliyan nin kahampatan ya kowinta kahawangan. ");
INSERT INTO sbl_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Kahampatan ya lomateng ha tawoy mabibi-iyen boy mapama-otang, ta hiya ay ma-in katapatan ha pama-owako nan kapanikapan na. ");
INSERT INTO sbl_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Hay mahampat ya tawo ay manatilin matibay boy mapanemteman ya anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Agya angkalimo no ma-in ya man mabalita-an ya katowà ya balità, ta hiya ay ma-in matibay ya kanakeman ha pamahimalà na ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Banà ta matibay ya kanakeman na ha pamahimalà na ha Pangino-on ay agya angkalimo, boy talagan talowen nay kawka-away na. ");
INSERT INTO sbl_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Hiya ay mabibi-iyen ha manga-irap ya ampipanga-ilangan, boy ayin anggay kahampatan na. Hiya ay parangalan boy igalang. ");
INSERT INTO sbl_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Hay mala-et ya tawo ya makakit nin habayti ya anggaw-en na ay mamahang; ha kapahangan na ay et-eten nay ngipen na anggan magmasakit ya boy mati. Talagan ahè mangyari ya labay nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Poriyen moyoy Pangino-on. Hikawoy mawmagsisirbi nin Pangino-on, poriyen moyoy ngalan na. ");
INSERT INTO sbl_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Hay ngalan nin Pangino-on ay poriyen pa-ibat hapa-eg anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Pa-ibat baytan anggan babà, kaganawan tawo ay mamori ha ngalan nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Hay Pangino-on ay ampamo-on ha kaganawan nasyon; hay kagandawan na ay ayin kapantay. ");
INSERT INTO sbl_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Ayin makapakipantay ha Pangino-on nawen Diyos; hiya ay ampiknò ha trono na ya anti ha katatag-ayan, ");
INSERT INTO sbl_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","boy pa-ibat bayro ay anlonglongan nay langit boy lotà. ");
INSERT INTO sbl_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Hay manga-irap ay an-alihen na ha ka-i-ingaloy kapapa-hal; hay ampipanga-ilangan itaman ay an-itag-ay nay kapapa-hal. ");
INSERT INTO sbl_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Hila ay an-ilamo na ha tawtawo nay ampipamo-on ya mangatag-ay ya pagkatawo. ");
INSERT INTO sbl_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Hay babayi ya ba-og ya ma-in ahawa ay pinaliga nin Pangino-on, ta pinolalagan nan nagkama-in aw-anak. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","2","Hay aw-inalalak ni Hakob ya ayin kanayon no alwan Aw-israylita ay napa-iri hin hato ha nasyon Ihipto ya hay tawtawo bayro ay kahalakoy halità ha halità nin Aw-israylita. Hin nog-alih bayro ya Aw-israylita, hay dogal ya an-ingaten Hoda ay nag-in masagradoy dogal ya kama-inan nin Diyos, boy hay dogal ya an-ingaten Israyil ay ginawà nan pag-ari-an na. ");
INSERT INTO sbl_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Hin kowinta nakit nin Dagat ya Ma-orit ya Aw-israylita ya anlomateng, hay lanom nin hatoy dagat ay napihiyay; ombayro simpri ha lanom nin balah nin Hordan. ");
INSERT INTO sbl_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Hay bawbakil boy bawbakilbakil ay kowinta ampagtakompaw nin bilang ha toron kanding boy bilang ha oybon topa. ");
INSERT INTO sbl_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Antà napihiyay ya lanom nin Dagat ya Ma-orit, boy lanom nin balah nin Hordan? ");
INSERT INTO sbl_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Antà hay bawbakil boy bawbakilbakil ay kowinta ampagtakompaw nin bilang ha toron kanding boy ha oybon topa? ");
INSERT INTO sbl_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Hay babon lotà ay dapat mamegpeg, ta hay Pangino-on ya Diyos ya pinahimala-an ni Hakob ay anti bayro. ");
INSERT INTO sbl_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Hiya ya Diyos ya namahobol nin lanom ha bato, boy pina-agoh nay lanom ya nangibat bayro ha matyà ya bato. ");
INSERT INTO sbl_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Alwan hikayi, Pangino-on, alwan hikayi no alwan hika ya poriyen banà ha ingangalo moy ma-in panlalabi boy ha katapatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Antà hay tawtawo ha nawnasyon ay ampipanginsolto konnawen nin magpastang nin ombayri: “Ayri ya Diyos moyo?” ");
INSERT INTO sbl_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Hay Diyos nawen ay anti ha katatag-ayan ha kama-inan na, boy anggaw-en nay anyaman ya makab-in konsowilo kona. ");
INSERT INTO sbl_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Balè hay andiyosen nin habayti ya tawtawoy ampipagpastang ay alwan peteg diyos ta yarì ha pilak boy gintò ya ginawà nin tawo. ");
INSERT INTO sbl_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Habayti ay ma-in bebey piro ahè makapaghalità; ma-in mata piro ahè makakit. ");
INSERT INTO sbl_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Ma-in tolih piro ahè makalengè; ma-in balongoh piro ahè makara-ep. ");
INSERT INTO sbl_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Ma-in gamet piro ahè makatanam; ma-in bitih piro ahè maka-owako. Ayin nin maski anyay telek ya ma-ibat ha bebey nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Hay nipanggawà nin habayti ay mag-in nin bilang ombayri; ombayro simpri ha kaganawan nin ampahimalà bayri. ");
INSERT INTO sbl_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Hikawoy aw-inalalak ni Israyil, pahimalà kawo ha Pangino-on. Hiya ya manambay boy mangidipinsa komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Hikawoy pawparì ya aw-inalalak ni Aron, pahimalà kawo ha Pangino-on. Hiya ya manambay boy mangidipinsa komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Hikawoy ampipanggomalang ha Pangino-on, pahimalà kawo kona. Hiya ya manambay boy mangidipinsa komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Hay Pangino-on ay ahè ampakaliwa kontamo; hitamo ay biyan nan kahampatan. Hay aw-inalalak ni Israyil kateng pawparì ya aw-inalalak ni Aron ay biyan na simprin kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Ombayro simpri ha ampipanggomalang ha Pangino-on; hay pambi konla nin Pangino-on nin kahampatan na ay pantaypantay, ma-aypà o matag-ay man ya pagkatawo. ");
INSERT INTO sbl_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Dayi, hikawo kateng aw-inalalak moyo ay pakalak-en nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Dayi, hay Pangino-on ya namalsa nin langit boy lotà ay mambi komoyo nin kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Hay katatag-ayan ya kama-inan nin Pangino-on ay hiya ya ma-in ikon, balè hay babon lotà ay inggawà na ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Hay nikati ya agana makapaghalità ay alwan hila ya mamori ha Pangino-on, ");
INSERT INTO sbl_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","no alwan hikayi ya ampikabiyay ya mamori ha Pangino-on, hapa-eg anggan makakanoman. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Anlabiyen koy Pangino-on ta anleng-en na ko ha an-ida-ing ko konay ingangalo. ");
INSERT INTO sbl_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Banà ta anleng-en na ko ay agko tonggen doma-ing kona anggan angkabiyay ako. ");
INSERT INTO sbl_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Hin ampanga-ampoling akon mati ay nagkama-in akon masyadoy kalimowan, ta hay ihip ko ay napatalo nin kagolowan boy kalele-an. ");
INSERT INTO sbl_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Banà bayro ay dinoma-ing ako ha Pangino-on nin ombayri: “Pangino-on, andawaten ko komo ya ilibri mo ko.” ");
INSERT INTO sbl_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Hay Pangino-on ay maba-it boy mahampat; hiya ya Diyos nawen ya ma-ingangalowen. ");
INSERT INTO sbl_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","An-i-atap nay tawtawoy ayin pakakaya. Hin ampamiligro ko ay tinambayan na ko. ");
INSERT INTO sbl_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Hapa-eg ay ma-in akoynan katinekan ha kahampatan nin Pangino-on kongko. ");
INSERT INTO sbl_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Hika, Pangino-on, ya nangilibri kongko ha kamatyan; hay pantolò nin lowà ko nin banà ha kalele-an ko ay pinategen mo, boy agmo ko impatalo. ");
INSERT INTO sbl_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Kayà hay biyay ko ay isirbi ko ha Pangino-on mintras angkabiyay ako bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Hay pamahimalà ko ha Diyos ay ahè na-alih maski hinalità ko ya ombayri: “Hiko ay masyadon angka-irapan.” ");
INSERT INTO sbl_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Banà simpri ha kagolowan ihip ko ay ombayri ya hinalità ko: “Ni mihay tawo ay ayin mapahimala-an.” ");
INSERT INTO sbl_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Pangno ko mabayaran ya otang ya nakem ko ha Pangino-on ha kaganawan kahampatan na kongko? ");
INSERT INTO sbl_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Hay gaw-en ko ay mambi kon ikapori nin Pangino-on boy pasalamatan ko ya ha pangilibri na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Hay impangakò ko ha Pangino-on ay igwà ko kona ha arapan nin kaganawan tawo nay nititipon. ");
INSERT INTO sbl_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Hay pagkamati nin nag-in tawtawo nin Diyos ay ma-alagà ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Pangino-on, hiko ay mapteg ya magsisirbi mo. Pagsirbiyan kata nin bilang ha ginawà nin nanay ko ya magsisirbi mo. Hika ya nangilibri kongko ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Mantan ako nin igwà komo ha pamasalamat ko komo, boy makirawat ako ha ngalan mo, Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Hay impangakò ko ha Pangino-on ay igwà ko kona ha arapan nin kaganawan tawo nay nititipon ");
INSERT INTO sbl_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","bayri ha kolob bali nin Pangino-on ha siyodad nin Hirosalim. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Poriyen moyoy Pangino-on, hikawoy tawtawo ha kaganawan nasyon; kaganawan moyo ay mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Hay ingangalo na kontamo ya ma-in panlalabi ay ahè mapantayan, boy hay katapatan nin Pangino-on ay ayin angga. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Pasalamatan moyoy Pangino-on ha kahampatan na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Dayi, hay aw-inalalak ni Israyil ay maghalità nin ombayri: “Hay panlalabi na ay ayin angga.” ");
INSERT INTO sbl_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Dayi, hay pawparì ya aw-inalalak ni Aron ay maghalità simpri nin ombayri: “Hay panlalabi na ay ayin angga.” ");
INSERT INTO sbl_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Dayi, hay ampipanggomalang ha Pangino-on ay maghalità itaman nin ombayri: “Hay panlalabi na ay ayin angga.” ");
INSERT INTO sbl_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Banà ha kagipitan ko ay dinoma-ing ako ha Pangino-on; tinobay na ko boy inlibri, ta binyan na kon ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Hay Pangino-on ay kalamo ko; kayà agko angkalimo. Warì ma-in tawo ya makapangno kongko? ");
INSERT INTO sbl_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Pangino-on ya kalamo ko; hiya ya ampanambay kongko. Kayà angkasigoro koy pananalo ko ha kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Mas mahampat ya pahimalà ha Pangino-on kisa magkompiyansa ha tawo. ");
INSERT INTO sbl_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Mas mahampat ya pahimalà ha Pangino-on kisa magkompiyansa ha tawtawoy ampipamo-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Hay tawtawo ha kaganawan nasyon ay nakapalibot kongko ta angkalabanen la ko, piro ha kapangyariyan nin Pangino-on, hila ay mapatalo ko. ");
INSERT INTO sbl_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Hila ay nakapalibot kongko, piro ha kapangyariyan nin Pangino-on ay mapatalo ko hila. ");
INSERT INTO sbl_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Bilang hilan panilan ya ni-o-opong kongko, boy hila ay bilang ha nayangoy dawdowih ya ayin ka-ongnon na-opoh nin apoy, ta ha kapangyariyan nin Pangino-on ay mapatalo ko hila. ");
INSERT INTO sbl_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Ayin tegen ya pangalaban la kongko; kayà ampanga-ampoling la kon mapatalo, piro tinambayan ako nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Pangino-on ya ampamakhaw kongko; kayà ampagkanta ko nin pamomori kona. Hiya simpri ya nangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Hay angkalengè ha ampa-iriyan nin tawtawoy mangahampat ay pamibobo-angaw ha katowa-an banà ha pananalo la ya hay an-ibo-angaw la ay ombayri: “Habayti ya pananalo ay ha panggogomawà nin kapangyariyan nin Pangino-on! ");
INSERT INTO sbl_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Hay kapangyariyan nin Diyos ay itag-ay; habayti ya pananalo ay ha panggogomawà nin kapangyariyan nin Pangino-on!” ");
INSERT INTO sbl_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Agko pon mati no alwan mabiyay ako et, ta ibabalità koy ginawà nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Maski masyadoy pamarosa kongko nin Pangino-on ay agna ko et pinayagan nin mati. ");
INSERT INTO sbl_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Hay poltan bali nin Diyos ay pagdanan nin mangahampat ya tawtawo; kayà lo-atan para kongko, ta pomahok akon magpasalamat ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Habayti ya polta nin magpalako ha Pangino-on ay ayin kanayon ya makapahok, no alwan tawtawon bongat ya mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Pasalamatan kata, Pangino-on, ta nilengè mo ko; hika ya nangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Hay bato ya ahè tinanggap nin manggagawà bali ay nag-in pinakama-alagà ya bato. ");
INSERT INTO sbl_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Habayti ay gawà nin Pangino-on; kapapa-ispanta bayti ya angkakit tamo. ");
INSERT INTO sbl_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Habayti ya allo ay inggawà nin Pangino-on; kayà magtowà tamo nin banà bayri. ");
INSERT INTO sbl_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Pangino-on, ilibri mo kayi; biyan mo kayi, Pangino-on, nin ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Bindisyonan nin Pangino-on ya anlomateng ha ngalan nin Pangino-on; hika ay bindisyonan nawen ha bali nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Hay Pangino-on ay Diyos; hiya ya ampambin hawang konnawen. Hay ayop ya papatyen nin idolog ha Diyos ay itakel ha kortin hawhongay ya anti ha altar. ");
INSERT INTO sbl_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Hika ay Diyos ko; kayà magpasalamat ako komo. Hika ay Diyos ko ya an-itag-ay ko. ");
INSERT INTO sbl_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Pasalamatan moyoy Pangino-on ta hiya ay mahampat, boy hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Makalmà ya ampipamiyay nin ayin ma-ipintas konla ta hila ay anhomonol ha pawpanogò nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Makalmà ya ampipanhomonol nin matibolos ya nakem ha an-ipanogò na. ");
INSERT INTO sbl_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Hila ay ahè ampanadyà nin manggawà nin alwan mahampat, ta hila ay ampamiyay nin kompormi ha kalabayan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Inggawà mo konnawen, Pangino-on, ya pawpanogò mo ya dapat nawen nin pirmin honolen nin ma-in katapatan. ");
INSERT INTO sbl_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Mangyari dayi nin mag-in matibolos ya nakem ko nin homonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ha ombayro ay agko mipareng-ey ta anhonolen koy kaganawan panogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Hiko ay mamori komo nin leseb ha nakem ko, ta angka-itoto ko nin mangahampat ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Honolen koy pawpanogò mo; kayà agmo ko pa-olayan. ");
INSERT INTO sbl_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Pangno makapag-atap ya mihay anakabayo emen ya manatilin malinis ha pagka-anakabayo na? Hiya ay manatilin malinis no homonol ya ha Halità nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Sinikap kon napakarani komo nin matibolos ya nakem ko; kayà agmo payagan nin hiko ay mipa-alilih ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Hay Halità mo ay panatiliyen ko ha nakem ko emen agko makapagkasalanan komo. ");
INSERT INTO sbl_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Amporiyen kata, Pangino-on; itorò mo kongkoy an-ipanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Kaganawan panogò ya hinalità mo ay pi-oman-oman kon ibalità ha kanayon. ");
INSERT INTO sbl_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Hay pawpanogò mo ay an-ikaliga kon honolen nin bilang ha kaligawan nin tawoy ma-in masyadoy kayamanan. ");
INSERT INTO sbl_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ampi-awengen koy pawpanogò mo boy habayti ay anhonolen ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","An-ikaliga koy pawpanogò mo boy agko liwawan ya nakaholat ha kaholatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Hiko ya magsisirbi mo ay gaw-an mon mahampat emen bomoyot ya biyay ko. No ombayro ay homonol ako ha nakaholat ha kaholatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Ipatnag mo kongko boy ipa-intindiyan ya mangaldeg ya labay totolen nin nakaholat ha Kaholatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Hiko ay dayowan bongat bayri ha babon lotà; kayà ipatnag moy pawpanogò mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Hiko ay pirmin ma-in ka-apehan nakem nin lalò matanda-an ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Anha-aren moy mangahambog boy an-ihompà moy ampa-alilih ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ipakarayò mo kongko ya ampipanoya-toyà boy ampanginsolto kongko, ta hiko ay hinomonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Maski mititipon ya ampipamo-on nin manahalità kongko, hiko ya magsisirbi mo ay mami-aweng nin pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","An-ikaliga koy pawpanogò mo ta habaytoy ampanwawali kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Hiko ay kowinta ampirà ha gabok banà ha kadiskorahiyan ko, Pangino-on; kayà bayowen moy biyay ko nin kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Intapat ko komo ya kaganawan ampambin kagolowan kongko, boy nilengè mo ko; kayà itorò mo kongko ya an-ipanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Ipa-intindiyan mo kongko ya pawpanogò mo; ha ombayro ay mapi-aweng koy kawkapapa-ispantay gawgawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Hiko ay angkapatalo nin kalele-an ko; banà bayri ay pakhawen mo ko nin kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Hay panana-ol ay alihen mo kongko; ha kahampatan mo ay itorò mo kongko ya panogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Hay pinilì ko ay kaptegan, boy ninakem kon homonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Ampangoligtanan koy an-ipanogò mo, Pangino-on; kayà agmo payagan nin mareng-eyan ako. ");
INSERT INTO sbl_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Pakahonolhonolen koy pawpanogò mo ta habayto ya ampambin pangingintindi kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Pangino-on, itorò mo kongko ya pawpanogò mo, ta ha kaganawan oras ay honolen ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Ipa-intindiyan mo kongko ya pawpanogò mo emen ko mahonol nin leseb ha nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Itoto mo ko ha pawpanogò mo ta habaytoy ampakapaliga kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Biyan mo kon kalabayan nin honolen ya pawpanogò mo kisa kalabayan nin yomaman. ");
INSERT INTO sbl_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Agmo payagan nin ma-ibeg ako ha bawbagay ya ayin kawkakokowinta; kompormi ha pangakò mo ay bayowen moy biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Toparen moy pangakò mo kongko ya magsisirbi mo emen ka igalang. ");
INSERT INTO sbl_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Ipakarayò mo kongko ya tawtotoyà ya angkalimowan kon mangyari kongko, ta hay an-ipanogò mo ay mahampat. ");
INSERT INTO sbl_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Hay pawpanogò mo ay angkahabekan ko. Banà ha kahampatan mo ay bayowen moy biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Pangino-on, dayi ay ipatanam mo kongko ya ingangalo moy ma-in panlalabi ha pangilibri mo kongko kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ha ombayro ay matobay ko ya ampanginsolto kongko ta ampahimalà ako ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Agmo payagan nin ma-intoloyan nin ma-alih kongko ya Halità moy peteg, ta an-omasa ko ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Hay pawpanogò mo ay pirmi kon honolen anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ma-in akon kalaya-an ha pamimiyay ko ta ampagsikap akon homonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Agko mareng-ey nin maghalità nin pawpanogò mo maski ha arapan nin aw-arì. ");
INSERT INTO sbl_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","An-ikaliga ko ya panhohomonol ko ha pawpanogò mo, ta habayti ay ampa-alaga-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","An-igalang ko boy ampa-alaga-an ya an-ipanogò mo, boy habayti ay ampi-awengen ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Panemtemen moy pangakò mo kongko ya magsisirbi mo, ta hika ya nambi kongko nin pag-asa. ");
INSERT INTO sbl_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Hay ampakahahaliwa kongko ha kadya-dya-an ya andanasen ko ay pawpangakò mo ya ampamayo nin biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Hay mangahambog ay masyadon ampanoya-toyà kongko; ombayroman ay agko hinalibokotan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Pangino-on, ampanemtemen koy pawpanogò mo hin hato ya ahè angka-oman, ta habaytoy ampakahahaliwa kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Masyadoy kapahangan ko ha gawgawà nin tawtawoy mangala-et ha panhomombalang la ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Hay pama-iri ko bayri ha babon lotà ay emen akon bongat dayowan; ombayroman ay ma-in akon kaligawan ta hay angkantawen ko ay pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","No yabi ay ampanemtemen kata, Pangino-on, boy anhonolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Hay pirmi kon anggaw-en ay anhonolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Hikan bongat, Pangino-on, ya labay ko. Impangakò ko ya honolen koy hawhalità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ampakarani ko komo nin matibolos ya nakem; ingalowan mo ko nin kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Napag-aralan koy nawnakaraan ha biyay ko; kayà hinalibokotan ko bayto, ta napakarani ko komo nin homonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Agko nag-abalà no alwan nag-aporah kon honolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Maski palibotan akon kaloten nin mangala-et ay agko liwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Maski botlay yabi ay ampibangon ako, ta pasalamatan kata ha mangahampat ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Hiko ay amigo nin kaganawan anggomalang komo, amigo nin kaganawan anhomonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Pangino-on, hay ingangalo moy ma-in panlalabi ay an-ipakit mo bayri ha babon lotà; hay pawpanogò mo ay itorò mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Pangino-on, hiko ya magsisirbi mo ay gaw-an mon mahampat kompormi ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Itorò mo kongko ya tamà ya panonosga, boy biyan mo kon tinandà ta ampinto-o ko ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Hin agko et nakaranas nin kadya-dya-an ay ampitawon ako ha pamimiyay ko, piro hapa-eg ay anhomonol ako ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Hika ay mahampat boy hay anggaw-en mo ay kahampatan. Itorò mo kongko ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Hay mangahambog ay ampamigawa-gawà nin kabongkokan ya kontra kongko. Ombayroman ay matibolos ya nakem kon homonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Habayti ya mangahambog ay mangatyà ya nakem; kayà ayin pangingintindi. Piro hiko, hay pawpanogò mo ay an-ikaliga ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Mahampat ya nagdanas ako nin kadya-dya-an emen ko matotowan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Hay pawpanogò ya inggawà mo ay mas ma-alagà kongko kisa liboliboy pirason pilak boy gintò. ");
INSERT INTO sbl_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Hika, Pangino-on, ya namalsa kongko; biyan mo kon pangingintindi emen ko matotowan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Dayi, hay ampipanggomalang komo ay magtowà pamakakit la kongko, ta hiko ay an-omasa ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Tandà ko, Pangino-on, ya hay an-ipanogò mo ay mahampat, boy ha katapatan mo, hiko ay pinaranas mo nin kadya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Dayi, hay ingangalo mo ya ma-in panlalabi ay manahaliwa kongko kompormi ha pangakò mo kongko ya magsisirbi mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Dayi ay ingalowan mo ko emen ako et mabiyay, ta an-ikaliga koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Dayi, hay mangahambog ya ampamingga kongko nin ayin bara-nan ay mipareng-ey, piro hiko ay mami-aweng nin pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Dayi, hay ampipanggomalang komo ya ampaka-intindi nin pawpanogò mo ay pakarani kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Dayi ay mag-in ako nin ayin kapintasan ha panhohomonol ko ha pawpanogò mo emen agko mipareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Pangino-on, masyado koynan angkahabek ha pangilibri mo, boy an-omasa ko ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Hay mata ko ay angkomeyep ana ha pangantì ko nin pangakò mo; kayà hinalità ko, “Makano mo ko hahaliwawen?” ");
INSERT INTO sbl_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Maski hiko ay ayin kowinta ta bilang akoyna ha katat ya pambiyanan alak ya na-agiwan ana ay agko naliwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Hiko ya magsisirbi mo, anggan makano ko mangantì, boy makano mo parosawan ya ampamadya-dyà kongko? ");
INSERT INTO sbl_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Hay tawtawoy mangahambog ya anhomombalang ha pawpanogò mo ay nangotkot nin lobot ya pakarabo-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Kaganawan panogò mo, Pangino-on ay mapahimala-an; tambayan mo ko, ta hay tawtawo ay ampamadya-dyà kongko maski ayin bara-nan. ");
INSERT INTO sbl_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Ampanga-ampoling la ko nin mapati, piro agko hinalibokotan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Banà ha ingangalo moy ma-in panlalabi ay i-atap moy biyay ko, ta honolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Pangino-on, hay Halità mo ay manatilin ayin angga nin bilang katibay nin kama-inan mo ha katatag-ayan. ");
INSERT INTO sbl_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Hay katapatan mo ay ahè ma-oman angga ha homonoy lawlipì; hika ya nanggawà nin babon lotà; kayà habayti ay manatilin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Kaganawan bagay ay ampanatili nin banà ha pawpanogò mo; habayti ay kowinta ampagsirbi komo ta kaganawan ay anti ha hilong kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","No alwan pawpanogò mo ya ampakapaliga kongko ay nati koyna rayi nin kadya-dya-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Agko liwawan ya pawpanogò mo ta habayto ya ginamit mon pinamayo nin biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ilibri mo ko ta hiko ay ikon mo; ampagsikapan kon honolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Hay mangala-et ay ampangabang nin mamati kongko, piro ampi-awengen ko boy ampangoligtanan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Na-intindiyan ko ya maski anyay bagay ay ma-in anggawan; hay pawpanogò mo balè ay talagan ahè ma-anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Pangino-on, ampa-alaga-an koy pawpanogò mo; kayà mikaka-allo kon ampi-awengen. ");
INSERT INTO sbl_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Hay pawpanogò mo ay pirmin anti kongko; kayà nag-in akon mas maronong kisan kawka-away ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Mas akon ampaka-intindi ha kaganawan ampanorò kongko, ta ampi-awengen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Mas akon ampaka-intindi ha mangato-a, ta anhonolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Agko ampakilako ha anlakwen nin mangala-et emen ko mahonol ya Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Agko hinalibokotan ya pawpanogò mo, ta mismon hika ya nanorò kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Hay pawpangakò mo, no bilang ha pamamangan ay hay tam-in konamkonamen; habayti ay matam-ih et ha polot. ");
INSERT INTO sbl_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Ampagkama-in akon pangingintindi ha pawpanogò mo; kayà angka-inakit ako ha pamamaraan ya alwan tamà. ");
INSERT INTO sbl_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Pangino-on, hay Halità mo ay kowinta hilag ya ampambin hawang boy ampangitoto kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Hay impangakò ko ya honolen koy pawpanogò mo ay talagan geperan ko ta habayto ay mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Masyadon dya-dyà ya dinanas ko; bayowen moy biyay ko, Pangino-on, nin kompormi ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Pangino-on, tanggapen moy panalangin koy pamomori komo, boy itorò mo kongkoy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Maski pirmin andilikadowen ya biyay ko ay agko liwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Hay mangala-et ay nangikanà nin pandisgrasya kongko, piro agko hinalibokotan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Hay pawpanogò mo ay pangoligtanan ko nin ayin angga, ta habayti ay kaligawan nin nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ninakem ko ya talagan honolen koy pawpanogò mo leleg biyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Angka-inakitan ko, Pangino-on, ya tawtawoy ampagloway nakem komo, piro ampa-alaga-an koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Hiko ay ahè mapangno ta anti ka kongko ya ampangi-atap kongko; an-omasa ko ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Hikawoy ampipanggawà kala-etan, pakarayò kawo kongko emen ko mahonol ya pawpanogò nin Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Biyan mo kon kakhawan kompormi ha pangakò mo emen mabiyay ako et; agmo payagan nin mipareng-ey ako ha pan-o-omasa ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Alalayan mo ko emen ako malibri; ha ombayro ay pirmi kon mahonol ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Kaganawan nin ahè anhomonol ha pawpanogò mo ay agmo antanggapen, boy hay pawplano lay panloloko ay ahè mangyari. ");
INSERT INTO sbl_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Kaganawan tawoy mala-et, para komo ay bilang bongat nin takà gintò ya ayin alagà; kayà ampa-alaga-an koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Banà komo, hay tanam ko ay emen angkalimo; kayà an-igalang koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Hay ginawà ko ay mahampat boy matoynong; kayà agmo ko dayi pa-olayan ha ampipangapih kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Ipangakò mo ya tambayan moy magsisirbi mo ya ayin kanayon no alwan hiko; agmo dayi payagan ya mangahambog nin mangapih kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Hay mata ko ay angkomeyep ana ha pangantì ko nin kalibriyan ya impangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Pangino-on, gomawà ka kongko ya magsisirbi mo nin kompormi ha ingangalo moy ma-in panlalabi, boy itorò mo kongkoy an-ipanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Hiko ay magsisirbi mo; biyan mo kon pangingintindi emen ko ma-intindiyan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Pangino-on, pana-on ana nin hika ay gomawà, ta hay tawtawo ay agana anhomonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Hay an-ipanogò mo ay ampa-alaga-an ko nin igit ha gintò maski taganas et gintò. ");
INSERT INTO sbl_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Kayà kaganawan panogò mo ay an-ibilang kon tamà; angka-inakit ako ha malì ya pamamaraan. ");
INSERT INTO sbl_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Hay pawpanogò mo ay kapapa-ispanta; kayà anhonolen ko nin leseb ha nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Hay an-ipatnag moy Halità mo ay ampambin hawang kanakeman boy pangingintindi ha tawoy kolang ha karonongan. ");
INSERT INTO sbl_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ha pagkahabek ko ha an-ipanogò mo, hiko ay kowinta ampan-aboh. ");
INSERT INTO sbl_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Pakaraniyan mo ko boy ingalowan nin bilang ha anggaw-en mo ha ampipanlabi komo. ");
INSERT INTO sbl_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Ha pamimiyay ko ay itoto mo ko nin kompormi ha impangakò mo, boy agmo payagan nin hay kasalanan ay makapangyayari kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Ilibri mo ko ha ampipangapih kongko emen ko mahonol ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Dayi, hiko ya magsisirbi mo ay hawangan moy kanakeman, boy itorò mo kongkoy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Hay lowà ko ay kowinta ampan-agoh nin bilang ha hapà, ta hay pawpanogò mo ay ahè angkahonol nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Pangino-on, hika ay mahampat boy hay pawpanogò mo ay tamà. ");
INSERT INTO sbl_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Hay inggawà moy pawpanogò ay matoynong boy mapahimala-an. ");
INSERT INTO sbl_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Hiko ay pinomagal ha pangimalasakit ko komo, ta hay kawka-away ko ay ahè hinomonol ha Halità mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Hay pawpangakò mo ay talagan peteg ta habayti ay napaptegan ana; kayà hiko ya magsisirbi mo ay ampa-alaga-an ko bayti. ");
INSERT INTO sbl_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Maski ma-aypà ya kapapa-hal ko boy andodosta-en ako ay agko angkaliwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Hay kahampatan mo ay ayin angga boy hay pawpanogò mo ay peteg. ");
INSERT INTO sbl_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Ma-in nilomateng kongkoy kagolowan boy kagipitan, piro hay pawpanogò mo ay nambin kaligawan kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Hay pawpanogò mo ay ayin anggay kahampatan; biyan mo kon pangingintindi emen mabiyay ako et. ");
INSERT INTO sbl_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Leseb ya nakem kon ampakirawat komo; tobayen mo ko, Pangino-on, ta honolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ampakirawat ako komo; ilibri mo ko ta honolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Biha homilà ya allo ay ampibangon akon makirawat komo nin tambay; hiko ay an-omasa ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Managayabi kon ahè angkatoloy emen ko mapi-aweng ya pawpangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Kompormi ha ingangalo mo ya ma-in panlalabi ay leng-en mo ko. Bayowen moy biyay ko, Pangino-on, nin kompormi ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Hay tawtawoy ampagplano nin kala-etan kongko ay ampakarani ana kongko; hila bayti ay ahè anhomonol ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Hika, Pangino-on ay marani kongko boy kaganawan an-ipanogò mo ay peteg. ");
INSERT INTO sbl_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Hin hato ay natoto ko ha pawpanogò mo ya habaytoy pawpanogò mo ay pinanatili mo nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Asikasowen moy kadya-dya-an ya andanasen ko boy ilibri mo ko, ta agko angkaliwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Dipinsawan mo ko boy ilibri; bayowen moy biyay ko nin kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Hay mangala-et ay ampakarayò ha kalibriyan, ta agla anhonolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Masyadoy pangingangalo mo, Pangino-on; bayowen moy biyay ko nin kompormi ha pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Malakè ya ka-away koy ampamadya-dyà kongko, piro patoloy kon anhonolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Anlomelè ako ha angkakit koy tawtawo ya alwan tapat komo, ta agla anhonolen ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Biliwen mo, Pangino-on, no pangno ko ampa-alaga-an ya pawpanogò mo; bayowen moy biyay ko nin kompormi ha ingangalo moy ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Kaganawan Halità mo ay peteg, boy kaganawan panogò mo ay mahampat boy ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Hay ampipamo-on ay ampamadya-dyà kongko maski ayin bara-nan, piro hiko, hay pawpanogò mo ay an-igalang ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","An-ikaliga koy pangakò mo nin bilang ha tawoy nakatompak nin kayamanan. ");
INSERT INTO sbl_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Angka-inakitan ko boy angkasorawan ya kabongkokan, piro hay pawpanogò mo ay ampa-alaga-an ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ha lo-ob mihay allo ay pitoy bisis akon ampamori komo ha kahampatan pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Hay ampipagpa-alagà ha pawpanogò mo ay talagan ma-in katinekan, boy aghila matoksò para makapagkasalanan. ");
INSERT INTO sbl_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","An-omasa ko ha pangilibri mo kongko, Pangino-on, boy anhonolen koy an-ipanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Anhonolen koy pawpanogò mo boy masyado kon ampa-alaga-an. ");
INSERT INTO sbl_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Anhomonol ako ha pawpanogò mo, boy tandà moy kaganawan nin pamimiyay ko. ");
INSERT INTO sbl_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Dayi, leng-en moy dawat ko komo, Pangino-on, boy biyan mo kon pangingintindi kompormi ha pawpangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Dayi, hay andawaten ko ay leng-en mo, boy ilibri mo ko nin kompormi ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Dayi ay pirmi kon mamori komo, ta an-itorò mo kongko ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Dayi, hay kantawen ko ay tongkol ha halità mo, ta kaganawan panogò mo ay mahampat. ");
INSERT INTO sbl_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Dayi, hika ay pirmin handà nin manambay kongko ta honolen koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Angkahabekan koy pangilibri mo, Pangino-on, boy an-ikaliga koy pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Pakalawigen mo dayi ya biyay ko emen kata mapori; dayi, hay pawpanogò mo ay makatambay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Hiko ay bilang ha topa ya nitawon; tikapen mo ko ya magsisirbi mo, ta agko anliwawan ya pawpanogò mo. ");
INSERT INTO sbl_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Hin anti ko ha kagipitan ay dinoma-ing ako ha Pangino-on boy nilengè na ko. ");
INSERT INTO sbl_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Pangino-on, ilibri mo ko ha gawgawà nin mangabongkok boy mawmanloloko. ");
INSERT INTO sbl_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Hikawoy mangabongkok, anyay gaw-en nin Diyos komoyo, boy anyay iparosa na komoyo? ");
INSERT INTO sbl_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Hikawo ay parosawan nan pana-en nin matarem ya yawò, boy parosawan na kawo ha pagka-amot ya pinabayay oling. ");
INSERT INTO sbl_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Hay pamakipa-iri ko komoyo ay bilang akon nakipa-iri ha tawtaga Misik boy tawtaga Kidar ya tawtawoy katowà ya ogalì; kayà hiko ay ka-ingalo. ");
INSERT INTO sbl_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Sobray boyot nin pamakipa-iri ko ha tawtawoy angka-inakit ha katinekan. ");
INSERT INTO sbl_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Hay labay ko ay katinekan, piro no anhalita-en ko konla ya tongkol ha katinekan, hay anhalita-en la itaman ay tongkol ha kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Nanegteg ako ha bawbakil biha ko pinastang ya sarili ko nin ombayri: Ayri mangibat ya tambay kongko? ");
INSERT INTO sbl_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Hay tambay kongko ay mangibat ha Pangino-on ya namalsa nin langit boy lotà. ");
INSERT INTO sbl_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Agna payagan nin hika ay mapangno; hiya ya ampangasiwà komo boy hiya ay ahè ampamitiglep. ");
INSERT INTO sbl_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Talagan hay ampangasiwà nin aw-inalalak ni Israyil ay ahè ampamitiglep o angkatoloy. ");
INSERT INTO sbl_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Pangino-on ya ampangasiwà komo; hiya ay anti ha dani mo para mangi-atap komo. ");
INSERT INTO sbl_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Hay amot nin hilà allo ay ahè makapangno komo; ombayro simpri ha hawang nin bowan no yabi. ");
INSERT INTO sbl_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Ha kaganawan kapiligrowan ay Pangino-on ya mangasiwà komo; hiya ya mangasiwà nin biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Pa-ibat hapa-eg boy anggan makakanoman, Pangino-on ya mangasiwà komo maski ayri ka mako. ");
INSERT INTO sbl_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","(Kanta ni Dabid ya angkantawen mintras ampako ha bali nin Diyos) Hay towà ko hin ma-in naghalità kongko nin ombayri: “Mako tamo ha bali nin Pangino-on.” ");
INSERT INTO sbl_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Hapa-eg ay anti kayi bayri nin ampireng ha polta nin siyodad nin Hirosalim. ");
INSERT INTO sbl_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Hay Hirosalim ay ginawà nin ma-ayos ya siyodad, ta hay bawbali bayri kateng aw-alal ya padir ay in-ayos nin pinikakabit. ");
INSERT INTO sbl_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Bayri anlomakat ya lawlipì ni Israyil nin mamori ha Pangino-on kompormi ha impanogò na konla. ");
INSERT INTO sbl_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Anti simpri bayri ya panosgawan nin aw-arì ha tawtawoy angkasakopan la. Habayti ya aw-arì ay ibat ha pamilya ni Dabid. ");
INSERT INTO sbl_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Emen magkama-in katinekan ya siyodad nin Hirosalim ay manalangin kawo nin ombayri: “Dayi, hay ampipanlabi ha siyodad ya habayti ay magkama-in ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Dayi ay magkama-in katinekan ha lo-ob nin habayti ya siyodad, boy dayi, hay ampa-iriyan nin ampipamo-on ay mag-in matinek.” ");
INSERT INTO sbl_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Alang-alang ha pawpatel ko boy ha aw-amigo, hay halita-en ko ha siyodad nin Hirosalim ay ombayri: “Magkama-in katinekan.” ");
INSERT INTO sbl_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Alang-alang simpri ha bali nin Pangino-on tamon Diyos ay an-ipanalangin koy ka-inomayan nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Pangino-on, ampaninglà ako komo ha katatag-ayan ha kama-inan mo ya ampamo-onan mo. ");
INSERT INTO sbl_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","No pangno nin hay alilà ay pirmin handà ha pangantì na no anyay imanda kona nin amo na ay ombayro itaman ya pangantì nawen anggan ingalowan kayi nin Pangino-on ya Diyos nawen. ");
INSERT INTO sbl_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Ingalowan mo kayi, Pangino-on; ingalowan mo kayi ta hikayi ay masyadon ampag-inakitan. ");
INSERT INTO sbl_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Naboyot kayinan ampagte-eh nin tawtotoyà nin tawtawoy ma-in kaya ha biyay boy tawtawoy mangahambog ya ampipag-inakit konnawen. ");
INSERT INTO sbl_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","3","(Kanta ni Dabid ya angkantawen mintras ampako ha bali nin Diyos) Ma-arì nin ombayri ya halita-en nin aw-inalalak ni Israyil: no agtamo kinampiyan nin Pangino-on hin kowinta dinawohong tamo nin kawka-away tamoy masyadon ampipamayani ay kowinta in-amon la tamoy angkabiyay; ");
INSERT INTO sbl_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","5","boy hin kowinta na-alipoteh tamo nin malhay ya lanab ay nikalemeh tamoyna rayi. ");
INSERT INTO sbl_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Poriyen tamoy Pangino-on ta agna tamo pina-olayan nin mapati nin kawka-away tamo. ");
INSERT INTO sbl_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Hitamo ay bilang ha manokmanok ya naka-alih ha papandakep nin mangangaho, ta hatoy kowinta papandakep ay nahirà; kayà libri tamoyna. ");
INSERT INTO sbl_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Hay tambay kontamo ay mangibat ha Pangino-on ya namalsa nin langit boy lotà. ");
INSERT INTO sbl_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Hay ampipampahimalà ha Pangino-on ay bilang ha Bakil nin Siyon ya ahè ma-eyeg boy manatilin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","No pangno ampambin protiksyon ha siyodad nin Hirosalim ya bawbakil ya nakapalibot bayro ay ombayro itaman ya Pangino-on, ta anti ya ha mamalibot nin tawtawo nay amprotiksyonan na nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Hay mangala-et ay ahè mamo-on nin pirmiyan ha dogal nin tawtawoy mangahampat, ta no pirmin hila ya mamo-on, hay tawtawoy mangahampat ay maka manowad ha kala-etan la. ");
INSERT INTO sbl_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Pangino-on, gaw-an mon kahampatan ya ampipanggawà nin mahampat boy leseb ya nakem nin anhomonol komo. ");
INSERT INTO sbl_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Piro hay ampipamiyay nin alwan tamà ya pamamaraan ay ipakilamo mon parosawan ha ampipanggawà kala-etan. Dayi ay magkama-in katinekan ya aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Hin imbira tamo nin Pangino-on ha dogal ya an-ingaten Siyon, habayto ay nangyari nin bilang bongat ha taynep. ");
INSERT INTO sbl_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Hin habayto, hitamo ay nipangka-ili boy nipagkanta ha katowa-an. Kayà hay tawtawo ha kanayon ya nawnasyon ay naghalità nin ombayri: “Masyadon kapapa-ispantay bawbagay ya ginawà konla nin Pangino-on.” ");
INSERT INTO sbl_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Talagan masyadon kapapa-ispantay bawbagay ya ginawà kontamo nin Pangino-on, boy habayto ay nakapatowà kontamo. ");
INSERT INTO sbl_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Pangino-on, biyan mo kayin oman nin ka-inomayan nin bilang ha pama-oran mo emen magkalanom ya mangaklang ya hawhapà. ");
INSERT INTO sbl_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Hay ma-in kalele-an ya ampipananaman ay mipangalawah nin ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Hay ma-in kalele-an ya ampipantan nin bawbinì ya itanaman, lano ha pagbira na, hiya ay ma-in kaligawan ya ampantan nin na-alawah nay pawpintehan. ");
INSERT INTO sbl_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","(Kanta ni Solomon ya angkantawen mintras ampako ha bali nin Diyos) Hay ampipanggawà bali, no aghila tambayan nin Pangino-on, hay anggaw-en la ay ayin kowinta. Ombayro simpri ha mihay siyodad; no ahè protiksyonan nin Pangino-on, hay ampipagbantay ya anti bayro ay ayin kowinta. ");
INSERT INTO sbl_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Maski ongnoy pagsikap mon magtrabaho ha panikap mon ikabiyay mo ay ayin et bongat no agmo ipahimalà ha Pangino-on. Pangino-on ya ampambin maganday pama-inawa ha tawtawoy anlabiyen na. ");
INSERT INTO sbl_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Hay aw-anak ay an-ipolalag nin Pangino-on; habayti ay bongan posò nin mita-ahawa ya nangibat kona. ");
INSERT INTO sbl_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Hay aw-anak nin mangalagò ya lawlalaki ay emen ha yawyawò ya oligtan nin mamakilaban. ");
INSERT INTO sbl_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Makalmà ya tawo ya hay pambiyanan nan yawò ay pono-ponò nin yawò, ta agya mapareng-ey no ma-ingkwintro nay kawka-away na ha polta nin siyodad. ");
INSERT INTO sbl_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Makalmà ya kaganawan tawoy anggomalang ha Pangino-on boy anhomonol ha an-ipanogò na. ");
INSERT INTO sbl_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Hika ay magkama-in nin ikabiyay ha pagtatarabaho mo; kayà lomiga ka boy magkama-in kan ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Hay ahawa mo ya anti ha bali mo ay mag-in nin bilang ha mabongay obas, boy hay aw-anak mo ay bilang ha mangalagò ya kayoy olibo ya anti ha mamalibot nin lamisawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Ombayro ya kahampatan ya mangyari ha lalaki ya anggomalang ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Dayi, hay Pangino-on ya anti ha siyodad nin Siyon ay mambi komo nin kahampatan; boy dayi, habaytoy siyodad nin Siyon ya an-ingaten et Hirosalim ay makit moy ampag-inomay leleg mon angkabiyay. ");
INSERT INTO sbl_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Dayi ay lomawig ya biyay mo emen mo makit et ya aw-apò mo. Dayi ay magkama-in katinekan ya aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","2","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Dayi, hay halita-en nin aw-inalalak ni Israyil ay ombayri: “Pa-ibat hin malagò ako ay masyado kon pinadya-dya-an nin kawka-away ko, piro agla ko napatalo. ");
INSERT INTO sbl_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Hay bokot ko ay kowinta naboyot lan hinogatan nin bilang nangararon paliyan. ");
INSERT INTO sbl_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Piro hay Pangino-on ay mahampat, ta inlibri na ko ha kowinta pangihe-el kongko nin mangala-et.” ");
INSERT INTO sbl_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Dayi, kaganawan ampag-inakit ha dogal ya an-ingaten Siyon ay mipagbiran ampikareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Dayi, hila ay matowad nin bilang ha dikot ya tinomobò ha bobongan; habayti ay angkayangoh maski ayin et ha pana-on. ");
INSERT INTO sbl_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Kayà ayin ampameteh nin mandipen nin habayti. ");
INSERT INTO sbl_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ni miha ha ampikahagoy ya ampakakit nin habayti ay ayin ampaghalità nin ombayri: “Dayi, hay kahampatan nin Pangino-on ay mipalako komoyo; ha ngalan nin Pangino-on, hay kahampatan na ay mipalako komoyo.” ");
INSERT INTO sbl_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Pangino-on, ha masyadoy kalele-an ya andanasen ko nin banà ha kadya-dya-an ay andoma-ing ako komo. ");
INSERT INTO sbl_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Kayà, Pangino-on, leng-en moy an-ida-ing ko komoy tambay. ");
INSERT INTO sbl_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Pangino-on, no agmo liwawan ya kawkasalanan nawen ta pirmi mon etpanan, ma-in warì konnawen nin makapaki-arap komo? ");
INSERT INTO sbl_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Piro ampatawaren mo kayi; kayà anggomalang kayi komo. ");
INSERT INTO sbl_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Angkahabek ako ha pangantì ko komo, Pangino-on, ta an-omasa ko ha pangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Ha pangantì ko ha Pangino-on ay mas et ha bantay ya panyabi ya ampangantì nin homilà ya allo; talagan mas et ha bantay ya panyabi ya ampangantì nin homilà ya allo. ");
INSERT INTO sbl_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Hikawoy aw-inalalak ni Israyil, omasa kawo ha Pangino-on ta hiya ay ma-in ingangaloy ma-in panlalabi; boy hiya ay pirmin handà nin mangilibri. ");
INSERT INTO sbl_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Hiyan mismo ya mangilibri nin aw-inalalak ni Israyil ha kaganawan kasalanan la. ");
INSERT INTO sbl_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","(Kanta ni Dabid ya angkantawen mintras ampako ha bali nin Diyos) Pangino-on, ayin akon nakem ya mapagmalhay boy alwa kon hambog nin manegteg. Agko ampaki-emen ha mangaldeg ya labay totolen nin bawbagay ya kawkapapa-ispanta ya agko angka-intindiyan. ");
INSERT INTO sbl_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Hiko ay ayin anan angkagolowan ta ma-in akoynan katinekan nin bilang ha mayamò ya anak ya hiniyay ana ha pannonò; talagan bilang akoyna ha mayamò ya anak ya hiniyay ana ha pannonò. ");
INSERT INTO sbl_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Hikawoy aw-inalalak ni Israyil, omasa kawo ha Pangino-on pa-ibat hapa-eg anggan makakanoman. ");
INSERT INTO sbl_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Pangino-on, panemtemen mo hi Dabid ha kaganawan kadya-dya-an ya dinanas na. ");
INSERT INTO sbl_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Panemtemen mo no pangno ya naghompà nin nagpangakò ha Pinakamakapangyariyan ya pinahimala-an ni Hakob. ");
INSERT INTO sbl_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Hay hinalità ni Dabid ay ombayri: “Agko morong nin mirà ha ampa-iriyan ko, ");
INSERT INTO sbl_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","boy agko i-ipleng ya mata ko para matoloy ");
INSERT INTO sbl_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","anggan agko ma-ihandà ya pa-iriyan nin Pinakamakapangyariyan ya Pangino-on ya pinahimala-an ni Hakob.” ");
INSERT INTO sbl_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Hin anti kayi ha banowan Bitlihim ay nabalita-an nawen ya tongkol ha ba-ol ya pinangitago-an nin kasondo-an nin Diyos, boy habayto ay nakit nawen ha makayoy dogal ya an-ingaten Dyar. ");
INSERT INTO sbl_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Hay hinalità nawen ay ombayri: “Mako tamo ha ampa-iriyan nin Diyos ta homamba tamo kona.” ");
INSERT INTO sbl_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Pangino-on, hika ay anti ha dogal ya pama-inawawan mo kateng ba-ol mo ya ampangipatnag nin kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Dayi, hay pawparì mo ay mapnò nin kahampatan mo, boy dayi, kaganawan nag-in tawo mo ay mipagkanta nin ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Nagpangakò ka koni Dabid ya magsisirbi mo; kayà, Pangino-on, agmo ya dayi pakarayo-an ta hiya ya pinilì mon mag-in arì. ");
INSERT INTO sbl_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Hay Pangino-on ay naghompà nin nagpangakò koni Dabid, boy agna bawi-en ya impangakò na. Hay impangakò na ay ombayri: “Ha sarili mon aw-anak ya lawlalaki, hay miha konla ay ipahili ko komon miknò ha trono mo. ");
INSERT INTO sbl_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","No hay aw-anak moy lawlalaki ay homonol ha inggawà koy kasondo-an, boy ha pawpanogò ya intorò ko konla, ha aw-anak la itaman ya lawlalaki ay ma-in mag-in arì anggan makakanoman.” ");
INSERT INTO sbl_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Hay dogal ya an-ingaten Siyon ay pinilì nin Pangino-on boy labay nan pa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Kayà hinalità na ya ombayri: “Habayti ay pama-inawawan ko nin ayin angga, boy labay kon pa-iri bayri. ");
INSERT INTO sbl_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Kaganawan nin panganga-ilangan bayri ay igwà ko boy hay manga-irap ay pabhoyen kon pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Hay pawparì bayri ay paholotan ko nin kowinta kalibriyan, boy hay nipag-in tawtawo nin Diyos bayri ay magkanta nin ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Bayri, hay miha ha aw-inalalak ni Dabid ay gaw-en ko nin makapangyariyan ya arì, boy hiko ya mangi-atap ha arì ya pinilì ko. ");
INSERT INTO sbl_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Hay kawka-away na ay pon-en kon kakareng-eyan, piro hiya ay biyan kon kapalindawayan ha pamomo-on na.” ");
INSERT INTO sbl_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","(Kanta ni Dabid ya angkantawen mintras ampako ha bali nin Diyos) Anyaynan kahampatan boy kagandawan nin makit ya mipapatel ha Pangino-on ya ampilalamo ya ma-in pagmimiha! ");
INSERT INTO sbl_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Hay ka-alimbawa-an nin ombayroy pamilalamo ay bilang ha mabangoh boy ma-alagà ya asitin olibo ya imbollog ha olo ni Aron ya ka-ona-onawan nin pinakamatag-ay ya parì. Habayto ay nandawey ha balbah na palakon kowilyo nin baro na. ");
INSERT INTO sbl_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Hay ka-alimbawa-an et nin ombayroy pamilalamo ay bilang simpri ha deyang ha bakil nin Hirmon boy ha bawbakilbakil nin Siyon. Hay Pangino-on ay nagpangakò nin igwà na bayro ha Siyon ya kahampatan na; hay kahampatan ya impangakò nan igwà na ay biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","(Kanta ya angkantawen mintras ampako ha bali nin Diyos) Poriyen moyoy Pangino-on, hikawoy kaganawan nin magsisirbi na ya pinilì nin magsirbi ha bali na no yabi. ");
INSERT INTO sbl_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Ha lo-ob nin bali na, no ampanalangin kawo ay itag-ay moyoy gamet moyo ha pamomori moyo ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Dayi, hay Pangino-on ya anti ha Siyon ay mambi komoyon kahampatan. Hiya ya namalsa nin langit boy lotà. ");
INSERT INTO sbl_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Poriyen moyoy Pangino-on. Poriyen moyoy ngalan na; poriyen moyo ya, hikawoy mawmagsisirbi nin Pangino-on ");
INSERT INTO sbl_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","ya ampipagsirbi ha bali nin Pangino-on boy ha kolob bali na ya ayin kanayon no alwan Diyos tamo. ");
INSERT INTO sbl_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Poriyen moyoy Pangino-on ta hay Pangino-on ay mahampat. Magkanta kawo ha pamomori moyo nin ngalan na, ta hiya ay maba-it. ");
INSERT INTO sbl_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Hi Hakob ya an-ingaten et Israyil, hay aw-inalalak na ay pinilì nin Pangino-on nin mag-in ikon na. ");
INSERT INTO sbl_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Tandà ko ya hay Pangino-on ay makapangyariyan; talagan makapangyariyan ya Pangino-on tamo nin igit ha kaganawan andiyosen. ");
INSERT INTO sbl_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Ginawà nin Pangino-on ya kaganawan makapakonsowilo kona ha langit boy ha lotà, ha dagat kateng ha kalale-lale-an nin dagat. ");
INSERT INTO sbl_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Hiya ya ampangipatag-ay nin lawleem ya ampangibat bayri ha babon lotà; hiya simpri ya ampambin oran ya ma-in kalamoy kilat; boy hiya ya ampambin angin ya ampangibat ha pangitiponan na. ");
INSERT INTO sbl_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Kaganawan ponganay nin tawtaga Ihipto ay pinati nin Pangino-on; ombayro simpri ha aw-onan anak nin aw-ayop la. ");
INSERT INTO sbl_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Bayro simpri ha nasyon Ihipto ay nanggawà yan pawpapag-ispantawan ya pinamarosa na koni Arì Para-on kateng ha kaganawan tawowan na. ");
INSERT INTO sbl_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Malakè ya nasyon ya hinirà nin Pangino-on, boy pinatipati nay aw-arì ya makapangyariyan ");
INSERT INTO sbl_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","ya bilang koni Sihon ya arì nin Aw-amoriyo, koni Og ya arì nin Basan, boy kaganawan arì nin Kana-an. ");
INSERT INTO sbl_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Hay dawdogal nin habaytoy pinatipati na ay inggawà nan pag-ikon nin tawtawo nay Aw-israylita. ");
INSERT INTO sbl_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Hika, Pangino-on ay Diyos ya ahè ampangoman; kaganawan homonoy lipì ay mamanemtem komo. ");
INSERT INTO sbl_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Dipinsawan nin Pangino-on ya tawtawo na, boy biyan nan ingangalo na ya mawmagsisirbi na. ");
INSERT INTO sbl_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Hay alwan peteg diyos ya andiyosen nin nawnasyon ay yarì ha pilak boy gintò ya ginawà nin tawo. ");
INSERT INTO sbl_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Habayti ay ma-in bebey piro ahè makapaghalità; ma-in mata piro ahè makakit; ");
INSERT INTO sbl_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","ma-in tolih piro ahè makalengè, boy ahè ampanginanawa. ");
INSERT INTO sbl_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Hay nipanggawà nin habayti ay mag-in nin bilang ombayri; ombayro simpri ha ampipampahimalà bayri. ");
INSERT INTO sbl_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Hikawoy aw-inalalak ni Israyil, poriyen moyoy Pangino-on; kateng hikawoy pawparì ya aw-inalalak ni Aron ay mamori ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Poriyen moyoy Pangino-on, hikawoy pawparì ya aw-inalalak ni Libi; hikawoy ampipanggomalang ha Pangino-on, poriyen moyo ya. ");
INSERT INTO sbl_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Poriyen moyoy Pangino-on ya anti ha Siyon ha siyodad nin Hirosalim ya kama-inan na. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Pasalamatan moyoy Pangino-on ta hiya ay mahampat; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Pasalamatan moyoy Diyos ya Pinakamakapangyariyan ha kaganawan andiyosen, ta hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Pasalamatan moyoy Pangino-on ya Pinakamakapangyariyan ha kaganawan ampangino-onen, ta hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Hiyan bongat ya ampanggawà nin masyadoy pawpapag-ispantawan; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Ha karonongan na ay napalsa nay langit; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Pinalwah nay lotà ha babo nin lanom; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Hiya ya nanggawà nin allo boy bowan; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Ginawà nay allo ya mambin hawang no allo; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Hay bowan boy bawbito-en ay ginawà nan mambin hawang no yabi; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Hay pawponganay nin tawtaga Ihipto ay pinatipati na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Hay Aw-israylita ay inalih na ha nasyon Ihipto; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Ha pangi-alih na konla ay ginamit nay kakhawan nin kapangyariyan na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Hay lanom nin dagat ya an-ingaten Ma-orit ay pinihiyay na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Hay Aw-israylita ay bayro na pinaraan ha pinihiyay nay lanom nin dagat; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Piro hi Arì Para-on kateng hawhondalò na ay nilemeh na bayro ha dagat ya an-ingaten Ma-orit; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Pasalamatan ya Pangino-on ta hiya ay nangona ha tawtawo na ha powiray dogal anggan nog-alih hila bayro; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Hay aw-arì ya makapangyariyan ay pinatipati na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Hiya simpri ya namatipati nin bawbantog ya aw-arì; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Hi Sihon ya arì nin Aw-amoriyo ay pinati na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Pinati na simpri hi Og ya arì nin Basan; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Hay dawdogal nin hatoy pinatipati na ay inggawà na ha tawtawo na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Talagan habaytoy dawdogal ay inggawà na ha tawtawo na ya aw-inalalak ni Israyil ya magsisirbi na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Hin ayin kayin magawà banà ha kakapeyan nawen ay agna kayi pina-olayan; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Hitamo ay inlibri na ha kawka-away tamo; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Hiya ay ampambin pamamangan ha kaganawan pinalsa na; hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Pasalamatan ya Diyos ya anti ha katatag-ayan ha kama-inan na, ta hay panlalabi na ay ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Hin anti kayi ha nasyon Babilonya ay niknò kayin nanangih ha danin balah hin napanemteman nawen ya siyodad nin Siyon ya sarili nawen dogal. ");
INSERT INTO sbl_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Hay aw-alpa nawen ay inhab-it nawen ha hawhanga nin kawkayo bayro. ");
INSERT INTO sbl_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Hay nipandakep konnawen ay ampamakanta konnawen; hay an-ipakanta konnawen nin habayti ya ampipamadya-dyà konnawen ay maligay kanta, ya wanla, “Kantawan moyo kayi nin tongkol ha Siyon.” ");
INSERT INTO sbl_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Para konnawen ay ma-irap kayin magkanta nin kantan Pangino-on, ta anti kayi ha alwa nawen sarilin dogal. ");
INSERT INTO sbl_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Dayi ay agkoyna ma-oman nin togtogen ya alpa ko no hay siyodad nin Hirosalim ay maliwawan ko. ");
INSERT INTO sbl_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Dayi ay agkoyna makapagkantan oman no agko panemtemen ya Hirosalim ya ampakab-i kongko nin masyadoy kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Panemtemen mo, Pangino-on, ya ginawà nin tawtaga Idom hin sinakop nin tawtaga Babilonya ya siyodad nin Hirosalim. Hay hinalità nin tawtaga Idom ay ombayri: “Obohen hira-en ya siyodad nin Hirosalim kateng pawpondasyon.” ");
INSERT INTO sbl_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Kompormi ha holà komoyon tawtaga Babilonya, hay nasyon moyo ay talagan hira-en; maliga ya tawoy mamaweh komoyo ha ginawà moyo konnawen, ");
INSERT INTO sbl_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","ta hay kawkolaw moyo ay itapon na ha bawbato. ");
INSERT INTO sbl_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","(Kanta ni Dabid) Matibolos ya nakem kon ampagpasalamat komo, Pangino-on. Hikan bongat ya kantawan ko boy poriyen. ");
INSERT INTO sbl_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ha panhomamba ko komo ay manyokò akon omarap ha bali mo, boy poriyen koy ngalan mo banà ha ingangalo moy ma-in panlalabi boy ha katapatan mo. Anggaw-en ko bayti ta impakit mo ya hay ngalan mo boy halità mo ay igit ha kaganawan bagay. ");
INSERT INTO sbl_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Hin dinoma-ing ako komo ay tinobay mo ko; pinakhaw moy nakem ko ha pambi mo kongkon kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Pangino-on, kaganawan arì ha babon lotà ay mamori komo ta nalengè lay pawpangakò mo. ");
INSERT INTO sbl_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Magkanta hila nin tongkol ha ginawà nin Pangino-on, ta hay kagandawan nin Pangino-on ay ahè makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Maski ahè mapantayan ya Pangino-on ay an-asikasowen nay manga-aypà ya nakem. Hay mangahambog ay ahè makapagtagò kona maski marayò hila kona. ");
INSERT INTO sbl_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Maski anti ko ha kagolowan ay an-i-atap mo ko; anha-aren moy pahang kongko nin kawka-away ko, boy kapangyariyan mo ya ampangilibri kongko. ");
INSERT INTO sbl_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Toparen nin Pangino-on ya impangakò na kongko; hay ingangalo mo, Pangino-on, ya ma-in panlalabi ay ayin angga. Agmo pa-olayan nin ahè yari-en ya gawgawà moy inompisawan mo. ");
INSERT INTO sbl_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","(Kanta ni Dabid) Pangino-on, sinorì mo ko; kayà tandà moy nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Tandà moy kaganawan anggaw-en ko; maski marayò ka ay tandà moy an-ihipen ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ampagtrabaho ko man o ampa-inawa ay angkakit mo ko; kayà tandà moy kaganawan anggaw-en ko boy anlakwen ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Pangino-on, maski agko et antotolen ya hahalita-en ko ay da-an moynan tandà ya halita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ha mamalibot ko, hika ay anti bayro, boy amprotiksyonan mo ko nin kapangyariyan mo. ");
INSERT INTO sbl_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Agko makwan ihipen boy intindiyen ya tinandà mo. ");
INSERT INTO sbl_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ma-in ako warì malako ya ayin ka bayro ya hika ay Ispirito ya anti ha maski ayri? ");
INSERT INTO sbl_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","No mako ko ha katatag-ayan, hika ay anti bayro; no ha dogal itaman nin nikati ya lakwen ko ay anti ka simpri bayro. ");
INSERT INTO sbl_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","No warì ta makalpad ako ta lompad ako ha kababaytanan, o pa-iri ha pinakamarayò ya dogal ha babà, ");
INSERT INTO sbl_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","hika ay anti bayron mangitoto kongko boy manambay kongko. ");
INSERT INTO sbl_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","No mapaki-ilgowan ko man ya karegleman nin mangitagò kongko, o kahawangan ha mamalibot ko nin mag-in yabi, ");
INSERT INTO sbl_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","hay karegleman ay alwan mareglem komo ta hay yabi, para komo ay emen kahawang allo. Karegleman boy kahawangan ay parihon mahawang komo. ");
INSERT INTO sbl_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Kaganawan parti nin nawini ko kateng pawparti ha bandan lalè ay hika ya nanggawà; hiko ay bino-ò mon hinolma ha tiyan nin nanay ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Amporiyen kata, ta nararapat kan igalang ha kapapa-ispantay panggawà mo kongko ya agko makwan ihipen. Habayti ay ampinto-owen ko maski agko angka-intindiyan. ");
INSERT INTO sbl_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Hin sikriton angkabo-ò ya kabwatan nin nawini ko ya bilang ha bawbot-o ko ha tiyan nin nanay ko, habayti ay alwan polinged komo. ");
INSERT INTO sbl_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Biha ko in-anak ay nakit mo koyna, boy kaganawan allo ha biyay ko ay nakalista ha libro mo maski habayti ay ahè et nag-ompisa. ");
INSERT INTO sbl_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Diyos ko, hay pangihip mo kongko ay ampa-alaga-an ko. Alwaynan a-amò ya pangingihip mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","No bilangen ko bayti ay malakè et ha kapati-an. No ampaka-imata ko ha pangangatoloy ko ay anti ko et komo. ");
INSERT INTO sbl_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Diyos ko, dayi, hay mangala-et ya tawo ay patyen mo. Hikawoy mawmapamati, alihan moyo ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Pangino-on, hila ay ampipaghalità nin mangala-et ya bawbagay ya tongkol komo, boy habayti ya kawka-away mo, hay ngalan mo ay anggamiten la ha ayin kapararakan. ");
INSERT INTO sbl_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Pangino-on, hay ampipag-inakit komo ay angka-inakitan ko; ombayro simpri ha ampipangkomontra komo. ");
INSERT INTO sbl_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ha ka-inakitan ko konla ay an-ibilang ko hila nin ka-away. ");
INSERT INTO sbl_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Sori-en mo ko, Diyos ko, emen mo matanda-an ya nakem ko boy pag-i-ihip ko. ");
INSERT INTO sbl_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Helken mo no alwa kon tapat komo, boy itoto mo ko ha daan ya palako ha biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","(Kanta ni Dabid) Pangino-on, ilibri mo ko ha tawtawoy mangala-et, boy i-atap mo ko ha tawtawoy mangabagsit, ");
INSERT INTO sbl_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","ta hay amplanowen la ay kala-etan, boy hay labay lan pirmi ay away. ");
INSERT INTO sbl_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Hay hawhalità la ay kowinta dità nin otan ya ampakamati. ");
INSERT INTO sbl_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","I-atap mo ko, Pangino-on, ha kapangyariyan nin mangala-et boy ha tawtawoy mangabagsit ya labay manirà nin pawplano ko. ");
INSERT INTO sbl_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Hay tawtawoy mangahambog ya labay mandakep kongko ay nangikatkat nin bateng ha pagdanan ko. ");
INSERT INTO sbl_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Hinalità ko ha Pangino-on, ya wangko, “Hika ya Diyos ko.” Leng-en mo, Pangino-on, ya an-ida-ing ko komoy tambay. ");
INSERT INTO sbl_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Pangino-on kon Diyos ya ma-in kapangyariyan mangilibri kongko, hika ya nambin protiksyon kongko ha pamakilaban ko. ");
INSERT INTO sbl_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Pangino-on, agmo igwà ha mangala-et ya anhangaren la, boy agmo payagan nin mangyari ya pawplano la emen aghila makapaghambog. ");
INSERT INTO sbl_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Dayi ay agmo payagan nin mapatalo ko nin kawka-away ko; hay pawplano la ya kontra kongko ay konla dayi mipabira. ");
INSERT INTO sbl_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Dayi, hay iparosa konla ay bilang hilan angkatatawan nin bayan oling boy emen hilan intapon ha apoy, o ha malalè ya lobot ya aghilayna maka-alawah. ");
INSERT INTO sbl_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Dayi, hay tawtawoy mapanirà nin kapara ay ahè omasinso; dayi, hay tawtawoy mangabagsit ay latngan nin kadisgrasyawan. ");
INSERT INTO sbl_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Tandà ko, Pangino-on, ya andipinsawan moy karapatan nin aw-apih boy ampipanga-ilangan. ");
INSERT INTO sbl_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Hay tawtawoy mangahampat ay mamori komo boy hila ay makalamo mo. ");
INSERT INTO sbl_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","(Kanta ni Dabid) Pangino-on, andoma-ing ako komo nin tampol mo kon tambayan. Leng-en moy an-ipakirawat ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Dayi, hay panalangin ko ay ibilang mo nin emen ha kamanyang, boy hay pangitag-ay ko nin gamet ko ha panalangin ko ay ibilang mo nin emen ha an-idolog ha altar no miralemdem. ");
INSERT INTO sbl_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Pangino-on, pendanan mo ko ha paghahalità ko. ");
INSERT INTO sbl_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Dayi ay agmo payagan nin hiko ay magkama-in kalabayan nin manggawà mala-et, boy makilamo ha mangala-et ha panggawà nin kala-etan; dayi, agmo ko payagan nin maki-emen ha anggaw-en lay an-ikakonswilo la. ");
INSERT INTO sbl_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Dayi, hay mamarosa o mana-ad kongko ay tawoy mahampat, ta hay gaw-en na kongko ay ikahampat ko nin bilang ha asiti ya imbollog ha olo ko ya agko tinanggi-an. Hay panalangin ko ay kontra ha gawgawà nin mawmapanggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","No hay ampipamo-on konla ay mikatalo ay ma-intindiyan ana nin tawtawo ya hay hinalità ko ay talagan peteg. ");
INSERT INTO sbl_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Hay bawbot-o la ha dogal nin nikati ay nikakatak nin bilang ha binihbih ya kawkayo. ");
INSERT INTO sbl_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Piro hiko, Pangino-on ay ahè tonggen ha pamahimalà komo. Kayà protiksyonan mo ko, boy agmo payagan nin mapatalo ko nin kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","I-atap mo ko ha papandakep kongko ya ginawà nin tawtawoy mapanggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Dayi, hilan mismo ya mangala-et ya mahagep nin habayti ya papandakep ya ginawà lan para kongko; hiko balè ay ahè mapangno nin magdaan bayro. ");
INSERT INTO sbl_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","(Kanta ni Dabid ya pakapowotan aral hin nagtagò ya ha kowiba) Hiko ay andoma-ing ha Pangino-on; ha pandoma-ing ko kona nin tambay ay an-ipakakhaw koy bosis ko. ");
INSERT INTO sbl_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Hay angkagolowan nakem ko ay an-ipakarani ko konan an-ida-ing. ");
INSERT INTO sbl_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Hin ayin akoynan magawà ay tandà na ya ampangyari kongko. Ha papagdanan ko ay ma-in ingkanà ya papandakep kongkoy nakatagò. ");
INSERT INTO sbl_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Namatag ako ha mamalibot ko ta ampamiliw ako nin ma-arì makatambay kongko, piro ayin akon nakit. Ayin makab-in protiksyon kongko boy ayin mangimalasakit kongko. ");
INSERT INTO sbl_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Pangino-on, andoma-ing ako komo nin tambay. Hikan bongat ya protiksyon ko, boy hika ya kaganawan ha biyay ko bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Leng-en moy an-ida-ing ko komoy tambay, ta masyado kon angkadiskorahi. Ilibri mo ko ha kawka-away ko ya mas makhaw kongko. ");
INSERT INTO sbl_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Alihen mo bayti ya andanasen ko ya gawà nin kawka-away ko ya kowinta nangipiriso kongko emen kata poriyen. Ha ombayro, hay mangahampat ya tawtawo ay mipampakarani kongko banà ha kahampatan mo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","(Kanta ni Dabid) Pangino-on, leng-en moy panalangin ko ya an-ida-ing ko komo. Ha katapatan mo boy kahampatan mo ay tobayen mo ko. ");
INSERT INTO sbl_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Hiko ya magsisirbi mo ay agmo pakahigpitan, ta ha tegteg mo ay ayin tawoy mahampat. ");
INSERT INTO sbl_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Hay ka-away ko ay namadya-dyà kongko boy tinalo na ko. Inggawà na ko ha kowinta mareglem nin bilang ha tawoy naboyot anan nati. ");
INSERT INTO sbl_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Kayà angka-alihan akoynan pag-asa boy angkomapey anay nakem ko. ");
INSERT INTO sbl_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Angkapanemteman koy nakalabah ya aw-allo boy angkahole-lè koy kaganawan ginawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ha panalangin ko komo ay an-itag-ay koy gamet ko; no pangno ampanga-ilangan nin oran ya lotà ya naklang ay ombayro ya pagkahabek ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Pangino-on, tampol mo kon tobayen ta angka-alihan akoynan pag-asa. Agmo ko pakarayo-an emen agko matowad nin bilang ombayro ha nikati ana. ");
INSERT INTO sbl_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Ampahimalà ako komo; kayà mahambak et ay ipatanam moyna kongko ya ingangalo moy ma-in panlalabi. Itoto mo ko ha kahampatan mo ta an-ipahimalà ko komo ya sarili ko. ");
INSERT INTO sbl_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Pangino-on, ilibri mo ko ha kawka-away ko, ta hay sarili ko ay an-ipa-olay ko komo. ");
INSERT INTO sbl_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Itorò mo ko nin gaw-en ya kalabayan mo ta hika ya Diyos ko. Dayi, hay Ispirito mo ya mahampat ay mangigiya kongko ha kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Ilibri mo ko, Pangino-on, nin kompormi ha impangakò mo. Ha kahampatan mo ay alihen moy ampakagolo kongko. ");
INSERT INTO sbl_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Ha ingangalo mo kongko ya ma-in panlalabi, hay kawka-away ko kateng ampipamadya-dyà kongko ay apo-en mo ta hiko ay magsisirbi mo. ");
INSERT INTO sbl_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","(Kanta ni Dabid) Poriyen ya Pangino-on ya kowinta malhay ya bato ya ampambin protiksyon kongko. Hiko ay ansanayen na emen mag-in handà ha pamakilaban. ");
INSERT INTO sbl_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Hiya ya Diyos ko ya ma-in ingangaloy ma-in panlalabi boy ampambin protiksyon kongko; hiya ya dipinsa ko boy ampangilibri kongko. Hiya simpri ya pinagkahalanggà ko ya ampahimala-an kon mangi-atap kongko, boy hay tawtawo ay an-ipasakop na kongko. ");
INSERT INTO sbl_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Pangino-on, anya ya tawo ta an-asikasowen mo boy ampa-alaga-an ya hiya ay tawon bongat? ");
INSERT INTO sbl_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Hay tawo ay bilang bongat inanawa, boy bilang ha anino ya angkalabah. ");
INSERT INTO sbl_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Pangino-on, hay langit ay lo-atan mo ta mag-aypà ka; aptohen moy bawbakil emen man-ahok. ");
INSERT INTO sbl_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Mamakilat ka ta pikakataken moy kawka-away mo; pana-en mo hila emen hila mipampowayo. ");
INSERT INTO sbl_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Pa-ibat ha katatag-ayan ay dowangen mo kon ilibri ha lanom ya malalè; ilibri mo ko simpri ha kapangyariyan nin dawdayowan ");
INSERT INTO sbl_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","ya ahè ampipaghalità kaptegan, ta maski ampipaghompà hila, hay anhalita-en la ay poro kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Diyos ko, kantawan kata nin kinomposo ya bayoy kanta; ha pagkanta ko ay kompanyawan kon alpa. ");
INSERT INTO sbl_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Anggaw-en ko bayti ta hika ya ampambin pananalo ha aw-arì, boy ampangilibri kongko ya magsisirbi mo ya ayin kanayon no alwan hi Dabid. ");
INSERT INTO sbl_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Ilibri mo kon hagepen ha kapangyariyan nin dawdayowan ya ahè ampipaghalità kaptegan, ta maski ampipaghompà hila, hay anhalita-en la ay kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Dayi, hay aw-anak nawen ya lawlalaki ya mangalagò ay mag-in nin bilang ha tawtanaman ya malambot ha pantotomobò, boy dayi, hay aw-anak nawen ya bawbabayi ya mangalagò ay mag-in nin bilang ha pampatibay ya ma-in aw-adorno ya igwà ha dawdoyo nin palasyo. ");
INSERT INTO sbl_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Dayi, hay kawkamalig nawen ay mapnò nin kaganawan klasin pamamangan, boy dayi, hay tawtopa nawen ya anti ha pawpaliyan ay mipanganak emen lomakè boy libolibo ya mipahan. ");
INSERT INTO sbl_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Dayi, hay bawbakà nawen ay ahè mikakwan boy ahè mikatak. Dayi, ha dawdaan nawen ay ayin malengè ya maski anyay klasin palatanda-an nin alwan maganday pangyayari. ");
INSERT INTO sbl_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Makalmà ya tawtawoy ombayri ya kapapa-hal; makalmà ya tawtawo ya hay Diyos la ay Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","(Kanta ni Dabid) Ibabalità ko ya karangalan mo, Diyos ko ya Arì; hay ngalan mo ay poriyen ko nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Allo-allo katan poriyen, boy ayin anggay pamomori ko ha ngalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Marangal ya Pangino-on boy hiya ay nararapat poriyen; hay karangalan na ay ahè makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Hika ay poriyen nin nika-onay lahì ha homonoy lahì nin banà ha gawgawà mo; ibabalità lay gawgawà moy makapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Hole-le-en koy karangalan mo boy kagandawan nin kahawangan mo kateng kawkapapa-ispantay gawgawà mo. ");
INSERT INTO sbl_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Hay tawtawo ay mangibabalità nin tongkol ha kapangyariyan nin kawkapapa-ispantay gawgawà mo; hiko itaman ay mangibabalità ha kaganawan tawo nin tongkol ha karangalan mo. ");
INSERT INTO sbl_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Hila ay mangibabalità boy magkanta nin tongkol ha masyadoy kaba-itan mo boy kahampatan mo. ");
INSERT INTO sbl_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Hay Pangino-on ay malabi boy ma-ingangalowen; hiya ay alwan mapapahangen boy ponò yan ingangaloy ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Mahampat ya Pangino-on ha kaganawan, boy an-ingalowan nay kaganawan pinalsa na. ");
INSERT INTO sbl_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Kaganawan pinalsa mo, Pangino-on ay mamori komo; kateng nag-in tawtawo mo ay mamori simpri komo. ");
INSERT INTO sbl_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Hay nag-in tawtawo mo ay maghalità nin tongkol ha kagandawan nin pamomo-on mo boy tongkol ha kapangyariyan mo ");
INSERT INTO sbl_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","emen kaganawan tawo ay makatandà nin tongkol ha gawgawà moy makapangyariyan, boy tongkol ha pamomo-on mo ya ma-in kagandawan boy kahawangan. ");
INSERT INTO sbl_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Hay pamomo-on mo ay ayin angga boy hika ay mag-arì anggan makakanoman. Hay Pangino-on ay tapat ha kaganawan pangakò na boy malabi ya ha kaganawan pinalsa na. ");
INSERT INTO sbl_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Kaganawan nin ma-in kakapeyan ay ampakhawen na boy kaganawan nin ma-in problima ay antambayan na. ");
INSERT INTO sbl_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Kona an-omasa ya kaganawan pinalsa na, boy hiya ya ampambi nin pamamangan la ha oras nin panganga-ilangan la. ");
INSERT INTO sbl_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Hila ay ambiyan na nin tamà ha panganga-ilangan la; kayà angkapasasà hila. ");
INSERT INTO sbl_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Hay Pangino-on ay mahampat boy ma-ingangalowen ha kaganawan pinalsa na. ");
INSERT INTO sbl_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Hiya ay marani ha kaganawan ampangingat kona nin leseb ha nakem. ");
INSERT INTO sbl_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","An-igwà nay pawpanganga-ilangan nin ampipanggomalang kona; anleng-en nay dawda-ing la boy an-ilibri na hila. ");
INSERT INTO sbl_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","An-i-atap nay kaganawan ampanlabi kona, piro hay mangala-et ay an-apo-en na. ");
INSERT INTO sbl_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Hiko ay mamori ha Pangino-on. Kaganawan pinalsa na, anggan makakanoman ay mamori dayi ha ngalan nay ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Poriyen moyoy Pangino-on. Poriyen koy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Leleg kon angkabiyay ay mamori ko ha Pangino-on. Hiya ya Diyos ko ay kantawan kon pamomori anggan ma-in akon biyay. ");
INSERT INTO sbl_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Agkawo pahimalà ha ampipamo-on, o ha hinoman ya ahè makapilibri komoyo. ");
INSERT INTO sbl_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Pangati la, hay nawini la ay morong mag-in lotà; ha allon habayto, hay pawplano la ay ma-anggawan ana. ");
INSERT INTO sbl_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Makalmà ya tawoy antambayan nin Diyos ya pinahimala-an nin aw-inalalak ni Hakob; makalmà ya ta an-omasa ya ha Pangino-on ya Diyos na. ");
INSERT INTO sbl_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Habayti ya Diyos ya namalsa nin langit, lotà, dagat, boy kaganawan nin anti bayro, boy hiya ya Pangino-on ya tapat ha pawpangakò na. ");
INSERT INTO sbl_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Kahampatan ya an-ihosga na ha ampika-apih boy ambiyan nan pamamangan ya ampikabitil. Hay Pangino-on ay ampamalayà nin pawpiriso. ");
INSERT INTO sbl_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Hay bawbowag ay ampakahampaten na emen makakit, antambayan nay mangama-in problima, boy anlabiyen nay mangahampat ya tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Amprotiksyonan nay dawdayowan, antambayan nay aw-olila boy bawbawoy babayi, boy anhira-en nay pawplano nin mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Hay Pangino-on ay ayin anggay pamomo-on. Hiya ya Diyos ya ampamo-on ha tawtawo na ha dogal ya an-ingaten Siyon boy ha mipanhomono ya lawlahì. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Poriyen moyoy Pangino-on. Hay mahampat nin gaw-en ay magkantan pamomori ha Diyos tamo; tamà boy nararapat nin mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","An-ibangon oman nin Pangino-on ya siyodad nin Hirosalim, boy hay aw-inalalak ni Israyil ya nipalako ha kanayon ya dogal ay an-ibira nan pititiponen bayro. ");
INSERT INTO sbl_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Anhahaliwawen nay ma-in kalele-an boy ampakahampaten nay ma-in dipirinsya. ");
INSERT INTO sbl_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Tandà nay kalak-an nin bito-en boy tandà nay ingat ha balang miha. ");
INSERT INTO sbl_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Marangal ya Pangino-on tamo boy masyadoy kapangyariyan na; hay pangingintindi na ay ahè mahokat. ");
INSERT INTO sbl_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Hay aw-apih ay an-itag-ay nin Pangino-on ya pagkatawo, piro hay pagkatawo nin mangala-et ay an-i-aypà na. ");
INSERT INTO sbl_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Magkanta kawo nin pasasalamat ha Pangino-on; kompanyawan moyon alpa ya kanta moyoy pamomori ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Hay langit ay andatakan nan leem ya ampambin oran ha lotà ya ampakapalambot nin dawdikot ha bawbakilbakil. ");
INSERT INTO sbl_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Hiyay ampambin pamamangan nin aw-ayop boy ha aw-a-akayen ya mamasiyapsiyap. ");
INSERT INTO sbl_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Ahè ampangonsowilo ya Pangino-on ha kakhawan nin kabayo o ha katapangan nin hondalò. ");
INSERT INTO sbl_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Hay ampangonsowilowan na ay tawtawoy anggomalang kona boy an-omasa ha ingangalo nay ma-in panlalabi. ");
INSERT INTO sbl_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Poriyen moyoy Pangino-on ya Diyos moyo, hikawo ya tawtaga Siyon ya sakop nin siyodad nin Hirosalim, ");
INSERT INTO sbl_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","ta hiya ya ampamatibay nin hawharà nin pawpoltan siyodad moyo, boy hiya ya ampambin kahampatan ha tawtawo nin habaytoy siyodad. ");
INSERT INTO sbl_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Hiya simpri ya ampambin katinekan komoyo angga ha pawpi-anggawan nin dogal moyo, boy ampabhoyen na kawo nin maganday klasin pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","No ampagmanda ya Pangino-on, hay mawmanda na ay tampol ampi-abot bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Ampama-oran ya nin yilo ya wamo no kawkapa boy hay pinoy yilo ay an-ikakatak nan emen ha gabok. Habayto ay antomyà banà ha kalay-epan. ");
INSERT INTO sbl_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Ampangikakatak ya simpri nin yilo ya emen kalarikid ya ampangibat ha tag-ay. Habayto ay masyadoy kalay-epan; kayà ayin makatagal. ");
INSERT INTO sbl_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Immanda simpri nin Pangino-on ya mangatotonaw bayto. Hapa-eg, nama-angin ya; kayà hay lawlanom ay nandanoh. ");
INSERT INTO sbl_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Hay hawhalità nin Pangino-on kateng kawkapanogo-an na ay impatnag na ha aw-inalalak ni Hakob ya ayin kanayon no alwan hi Israyil. ");
INSERT INTO sbl_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Habayti ya ginawà konla nin Diyos ay agna ginawà ha kanayon ya nasyon, banà ta agla tandà ya kawkapanogo-an na. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Poriyen moyoy Pangino-on. Hay anti ha katatag-ayan ha kama-inan nin Diyos ay mamori ha Pangino-on; hikawo ya anti bayro ha pinakamatag-ay ya dogal ay mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Poriyen moyoy Pangino-on, hikawoy kaganawan anghil na kateng aw-anghil ya hawhondalò na. ");
INSERT INTO sbl_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Hay allo boy bowan ay mamori ha Pangino-on; ombayro simpri ha bawbito-en ya ampipanhomilà. ");
INSERT INTO sbl_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Hay pinakamatag-ay ya langit boy lawlanom ha tag-ay nin langit ay mamori kona. ");
INSERT INTO sbl_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Dayi, kaganawan nin habayti ay mamori ha Pangino-on, ta ha manda nan bongat, kaganawan nin habayti ay napalsa. ");
INSERT INTO sbl_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Habayti ya bawbagay ay ingkolokar nan mahampat ha pirmaminti ya dogal, boy habayti ay ahè ma-arì nin homombalang kona. ");
INSERT INTO sbl_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Kaganawan nin anti ha lotà ay mamori ha Pangino-on; ombayro simpri ha mangalhay ya ikan kateng kaganawan nin anti ha kalale-lale-an dagat. ");
INSERT INTO sbl_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Kilat man boy yiloy emen kalarikid, boy yiloy wamo no kawkapa, boy leem ay mamori kona, kateng makhaw ya angin ya anhomonol kona ay mamori simpri kona. ");
INSERT INTO sbl_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Hay bawbakil boy kaganawan bakilbakil kateng kawkayo ya ampamonga boy kawkayoy an-ingaten sidro ay mamori simpri ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Ombayro simpri ha aw-ayop ya balang boy ha alwan balang, kaganawan ayop ya ampipandakap kateng mawmanokmanok. ");
INSERT INTO sbl_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Kaganawan arì kateng kaganawan ampipamo-on bayri ha babon lotà ay mamori ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Ombayro simpri ha aw-anakabayo boy dawdalaga, tawtawoy mangato-a kateng aw-anak. ");
INSERT INTO sbl_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Dayi, kaganawan nin habayti ay mamori ha Pangino-on ta hiya ay ahè mapantayan. Hay kagandawan na ay igit ha langit boy ha lotà. ");
INSERT INTO sbl_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Hay nag-in tawtawo nin Diyos kateng aw-inalalak ni Israyil ya maheneh kona ay dapat mamori kona ta biyan na hilan kapangyariyan boy ka-inomayan. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Poriyen moyoy Pangino-on. Ha pamititipon moyon nag-in tawtawo nin Diyos ay kantawan moyoy Pangino-on nin kinomposo ya bayoy kanta ha pamomori moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Dayi, hay aw-inalalak ni Israyil ay magtowà ha namalsa konla; dayi, hay tawtawo ya ampa-iri ha dogal ya an-ingaten Siyon ay magtowà simpri ha Arì la. ");
INSERT INTO sbl_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Dayi ay palamowan moyo nin talek ya pamomori moyo ha ngalan na; manogtog kawo nin pandirita boy alpa ha pamomori moyo kona. ");
INSERT INTO sbl_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Hay Pangino-on ay ampangonsowilo ha tawtawo na; hay ampipagmaka-aypà ay ambiyan nan pananalo. ");
INSERT INTO sbl_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Dayi, hay tawtawo nin Diyos ay magtowà ha pananalo la, boy maski ampa-inawa hilayna ay magtowà hila nin magkanta. ");
INSERT INTO sbl_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Dayi ay ibo-angaw lay pamomori la ha Diyos, boy hay gawgamet la ay ma-in oligtan ya hondang ya mitaligmang ya tarem. ");
INSERT INTO sbl_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Habayti ya pamatalo la nin nawnasyon boy pamarosa la nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Hay aw-arì boy ampipamo-on ay balolen lan tikalà. ");
INSERT INTO sbl_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Ombayro ya iparosa la ha tawtawo ha nawnasyon, ta ombayro ya impagawà nin Diyos ha nag-in tawtawo na. Poriyen moyoy Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Poriyen moyoy Pangino-on. Poriyen ya Diyos ha bali na. Poriyen ya ha pinakamatag-ay ya dogal ya ginawà na ha kapangyariyan na. ");
INSERT INTO sbl_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Poriyen ya banà ha gawgawà nay makapangyariyan; poriyen ya simpri ha masyadoy karangalan na. ");
INSERT INTO sbl_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Mamatnoy nin trompita, alpa, boy lira ha pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Ha pamomori simpri kona ay mamatnoy nin pandirita, tomalek, boy mamatnoy nin alpa boy plawta. ");
INSERT INTO sbl_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Manggamit nin gatsing ha pamomori kona; ipakakhaw ya paggatsing ha pamomori kona. ");
INSERT INTO sbl_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Dayi, hay Pangino-on ay poriyen nin kaganawan ma-in inawawen. Poriyen moyoy Pangino-on.");
INSERT INTO sbl_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Habayti ay kawkahalita-an ni Solomon ya anak ni Arì Dabid ya nag-in arì nin nasyon Israyil. ");
INSERT INTO sbl_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Hay kawkahalita-an ay inholat emen makatambay ha tawtawo nin makatandà karonongan boy mahampat ya tawtorò, boy makapipa-intindi nin hawhalità ya mangaldeg ya labay totolen. ");
INSERT INTO sbl_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Habayti ya kawkahalita-an ay makapitoto no pangno mag-in matalino, mahampat, tapat, boy mag-in parihoy gawgawà. ");
INSERT INTO sbl_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Makab-i bayti nin talino ha mangakapey et ya ka-ihipan, boy makapitoto et bayti ha mangalagò nin tamà ya gaw-en. ");
INSERT INTO sbl_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Habayti ya kawkahalita-an ay makapahan tinandà nin maski tawtawoy mangaronong, boy lalò makapitoto ha mangama-in pinag-aralan ");
INSERT INTO sbl_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","emen la ma-intindiyan ya labay totolen nin mangaldeg ya kawkahalita-an boy aw-alimbawà kateng hawhalità nin mangaronong. ");
INSERT INTO sbl_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Hay ona mon gaw-en emen ka magkama-in karonongan ay igalang moy Pangino-on. Hay tawtawoy tangah ay ahè ampa-alaga-an ya karonongan boy ahè labay matoto. ");
INSERT INTO sbl_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Anak koy lalaki, leng-en moy an-itorò komo nin tatay mo, boy agmo ipag-ayin ba-alà ya anhalita-en komo nin nanay mo; ");
INSERT INTO sbl_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","ta hay tawtorò la komo ay makab-in kahampatan ha pag-o-ogalì mo nin bilang ha korona boy ha kolinta ya anggamiten mon pagpaganda mo. ");
INSERT INTO sbl_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Anak koy lalaki, no ma-in mawmakasalanan ya mangaygay komo ay agka pomayag nin makilako konla. ");
INSERT INTO sbl_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Alimbawà, halita-en la komo ya ombayri: “Kilako ka konnawen ta mangabang tamo nin tawtawoy patyen tamo; maski ayin bara-nan ay mamati tamo. ");
INSERT INTO sbl_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Maligha hila boy mahampat ya makit tamo, piro agla tandà ya biglà hilan mati ha gaw-en tamo konla. ");
INSERT INTO sbl_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","No nati hilayna, hay manga-alagà ya kawkamama-in la ay kowen tamo ta pon-en tamoy bali tamo nin kawkamama-in lay makwa tamo. ");
INSERT INTO sbl_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Hali! Kilako ka konnawen ta hay makwa tamo ay pi-a-atagan tamo.” ");
INSERT INTO sbl_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Anak koy lalaki, agka makilako ha ombayroy tawtawo; pakarayò ka konla. ");
INSERT INTO sbl_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","Hay pirmin anti ha nakem la ay manggawà kala-etan boy pirmi hilan nakahandà nin mamati. ");
INSERT INTO sbl_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Ayin kowintay pangikanà nin hilò no hay manokmanok ya hihilo-en ay nakabantay. ");
INSERT INTO sbl_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Habaytoy tawtawo ya ampipanggawà nin kala-etan ay emen lan anggaw-en ya sarili lan kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Hinoman ya tawoy ampagkama-in ha powirsawan ay angkapowirsa itaman ya kamatyan na. ");
INSERT INTO sbl_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Hay ka-alimbawa-an nin karonongan ay kowinta tawoy ampanorò ya hay tawtorò na ay an-ibolyaw na ha dawdaan boy ha mangatawoy dawdogal. ");
INSERT INTO sbl_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Ampambolyaw ya ha pamihahakbatan nin tawtawo boy maski ayrin dogal ya pamititiponan kateng ha pi-anggawan nin banowa. ");
INSERT INTO sbl_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","Hay an-ibolyaw na ay ombayri: “Hikawoy tawtawo ya ayin tinandà, anggan makano kawo maliwid ha pagka-ayin tinandà? Hikawoy ampanoya-toyà nin karonongan, anggan makano moyo ikaliga ya panoya-toyà? Hikawo ya tawtawoy tangah ya ahè labay matoto, anggan makano kawo matoto ha katangahan moyo? ");
INSERT INTO sbl_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","No leng-en moyo ko ha ampana-aran ko komoyo ay mahampat ya iwawali ko komoyo, boy ipatnag ko komoyo ya tinandà ko. ");
INSERT INTO sbl_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","An-ingaten katawo boy anhagyaten, piro pinagka-ayin moyo ya ingat ko boy hagyat ko komoyo. ");
INSERT INTO sbl_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Hay wawwawali ko komoyo ay agmoyo pina-alaga-an boy agmoyo nilengè ya ha-ad ko. ");
INSERT INTO sbl_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Kayà no ma-in alwan maganday mangyari komoyo ay ka-iliyan katawo; boy no ma-in kawon kagolowan ay galgalan katawo. ");
INSERT INTO sbl_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Habayti ay lomateng komoyo nin ayin imbalag ha bagyo boy emen ha alimpoyopo ya mama-irap boy mamalelè komoyo. ");
INSERT INTO sbl_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","“Ha ombayroy mangyari, hiko ya karonongan ay ingaten moyo piro agko tombay komoyo. Pakatikaptikapen moyo ko piro agmoyo ko matotowan. ");
INSERT INTO sbl_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Hay bara-nan no antà ombayroy mangyari ay banà ta agmoyo labay magkama-in tinandà, boy agmoyo labay gomalang ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Agmoyo labay ya wawwawali ko komoyo boy agmoyo nilengè ya ha-ad ko. ");
INSERT INTO sbl_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Kayà no anyay ginawà moyo ya kowinta intanem moyo ay habaytoy alawahanen moyo, boy sarili moyon gawà ya makapahyab komoyo. ");
INSERT INTO sbl_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Hay tawtawoy mangakapey ya ka-ihipan ay mati banà ta agla labay ya karonongan, boy hay tawtawoy tangah ay mahirà banà ha agla panlengè; ");
INSERT INTO sbl_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","piro hinoman ya ampanlengè kongko ya karonongan ay magkama-in kasigorowan. Agya mapangno boy ayin mag-in bara-nan para hiya ay malimo.” ");
INSERT INTO sbl_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Anak koy lalaki, pag-aralan moy an-itorò ko komo boy agmo liwawan gaw-en ya an-ipanogò ko. ");
INSERT INTO sbl_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Pakaleleng-en mo ya karonongan boy habayti ay paka-ihipen mo emen mo ma-intindiyan. ");
INSERT INTO sbl_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Sikapen mo boy awoken mon magkama-in kan tinandà boy pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","Pakatikaptikapen mo nin bilang kan ampanikap pilak o kayamanan ya nakatagò. ");
INSERT INTO sbl_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","No ombayroy gaw-en mo ay matanda-an mo ya panggogomalang ha Pangino-on Diyos, boy magkama-in kan pagkatandà ya tongkol ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Pangino-on ya ampambi nin karonongan; kona simpri ampangibat ya tinandà boy pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Hiya ya ampambin tambay boy protiksyon ha tawtawoy mangahampat boy tapat. ");
INSERT INTO sbl_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Amprotiksyonan nay tawtawo ya ahè ampamintahi nin kapara, boy an-i-atap nay tawtawoy talagan tapat kona. ");
INSERT INTO sbl_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","No leng-en mo ko ay ma-intindiyan mo no anyay tamà, matoynong, boy no anyay mahampat mon gaw-en. ");
INSERT INTO sbl_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Mag-in kan maronong boy hay tinandà mo ay mambi nin konsowilo komo. ");
INSERT INTO sbl_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Tinandà mo boy pangingintindi mo ya makapi-atap komo, ");
INSERT INTO sbl_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","boy makapipakarayò komo ha panggawà kala-etan. Ma-ipakarayò ka et ha tawtawoy ampakab-in kagolowan ha paghalità la nin bawbagay ya mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Agla labay ya kahampatan ta hay labay la ay karegleman ya kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","An-ikaliga la ya panggawà la nin alwan tamà, boy an-ikatowà la ya panggawà la nin kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Kaganawan gawà la ay ahè ma-asawan boy hila ay ahè mapahimala-an. ");
INSERT INTO sbl_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","No anti komo ya karonongan ay makapag-atap ka ha babayi ya pota ya ampaka-ingganyo ha paghahalità na. ");
INSERT INTO sbl_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Hay ombayroy babayi ay alwan tapat ha ahawa, ta agna hinonol ya masagradoy pinanompa-an na ya anti ha panogò nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","No mako ka ha bali na ay emen kan ampowakon magpalako ha kamatyan. Hay pamako bayro ay bilang ampagpalako ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Hay mako bayro kona ay agana mibira o mi-orong ya da-an biyay na. ");
INSERT INTO sbl_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Piro hika, banà ta maronong ka, hay dapat mon gaw-en ay towaren moy mangahampat ya tawtawo boy manatili kan mamiyay nin ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Hay tawtawoy ma-in kahampatan ay manatilin pa-iri bayri ha babon lotà, ");
INSERT INTO sbl_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","piro hay mangala-et ya tawtawo ay alihen nin Diyos bayri ha babon lotà nin bilang ha tanaman ya an-oloten ha pinangitamnan. ");
INSERT INTO sbl_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Anak koy lalaki, agmo liwawan ya an-itorò ko komo. Pirmi mon panemtemen ya anhalita-en kon gaw-en mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Hay biyay mo ay komarà boy mag-inomay ka no honolen moy tawtorò ko. ");
INSERT INTO sbl_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Agmo payagan nin hay katapatan boy kaptegan ay ma-alih komo. Habayti ay gaw-en mon kowinta kolinta ha le-ey mo, boy itanem mo ha nakem mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","No ombayroy gaw-en mo, hay Diyos kateng tawtawo ay mangonsowilo komo. ");
INSERT INTO sbl_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Pahimalà ka ha Pangino-on nin leseb ha nakem mo, boy agka omasa ha sarili mon pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Ipakipapano mo ha Pangino-on ya kaganawan gaw-en mo, ta itorò na ka ha tamà ya gawà. ");
INSERT INTO sbl_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Agmo ihipen ya hika ay maronong. Igalang moy Pangino-on boy pakarayò ka ha kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","No ombayroy gaw-en mo, habayto ay magsirbi nin bilang ha tambal ya mamaligha komo boy mangalih nin angkatanam mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Pakonsowilowen moy Pangino-on ha pambi mo nin na-alawah mo; hay igwà mo ay kowen mo do ha pinakamaganday na-alawah mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","No ombayroy gaw-en mo, hay kamalig mo ay mapnò nin ma-alawah mo, boy hay pambiyanan mon inomen ay pirmin anhomwà ya laman. ");
INSERT INTO sbl_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Anak koy lalaki, no amparosawan kan toro-an nin Pangino-on ay agmo ipagmala-et, ");
INSERT INTO sbl_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","ta hay anlabiyen nin Pangino-on ay andisiplinawan na nin bilang pandisiplina nin tatay ha anak nay ampangonsowilowan na. ");
INSERT INTO sbl_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Maliga ya tawoy ampagkama-in karonongan ta hiya ay ampagkama-in pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Hay karonongan ay ampakinabangan nin igit et ha pilak boy habayti ay ma-alagà kisa gintò. ");
INSERT INTO sbl_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Hay karonongan ay mas ma-alagà kisa ha aw-alahas. Habayti ay ahè ma-iparis ha anyaman ya anhangaren mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Hay karonongan ay ampakapakarà biyay; habayti ay ampambin kayamanan boy karangalan. ");
INSERT INTO sbl_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Mapalindaway ya tawtawoy ma-in karonongan boy habayti ya makapitoto kona. ");
INSERT INTO sbl_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Maliga ya tawtawoy ma-in karonongan; hay karonongan ay emen ha po-on kayoy ampambi ha tawtawo nin biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Karonongan ya ginamit nin Diyos hin pinalsa nay babon lotà, boy ginamit nay pangingintindi na hin in-ayos nay langit. ");
INSERT INTO sbl_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Karonongan simpri ya ginamit na hin pina-agoh nay lanom ha bawbalah, boy hin hay lawleem ay nambin oran ha lotà. ");
INSERT INTO sbl_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Anak koy lalaki, pangoligtanan moy karonongan boy pangingintindi. Agmo pa-olayan nin ma-alih komo. ");
INSERT INTO sbl_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Habayti ay bilang ha dikorasyon ha le-ey mo ya ampambi komo nin kagandawan, boy habayti ay ampambi komo nin biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Agka mapangno ha paninigè mo boy agka mibatol ha pagdanan mo. ");
INSERT INTO sbl_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Ha pamirà mo nin matoloy ay agka malimo, boy hika ay makakatoloy nin mahampat. ");
INSERT INTO sbl_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Agka malimo ha alwan maganday pangyayari ya biglà lomateng ya kaparosawan ha mangala-et ya tawtawo, ");
INSERT INTO sbl_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","ta hay Pangino-on ya anti komo ay mangi-atap komo ha maski anyay lomateng ya pangyayari ya dilikado. ");
INSERT INTO sbl_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Manggawà kan kahampatan ha ampipanga-ilangan no ma-in kan magawà ya makatambay konla. ");
INSERT INTO sbl_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Agmo halita-en ha ampipanga-ilangan ya, “Nobokayna!” no ma-in kan ma-itambay konla hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Agka mangihip nin manggawà mala-et ha kapara mo, ta hiya ay ampahimalà komo. ");
INSERT INTO sbl_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Agka mangolpya nin kapara mo no ayin bara-nan. ");
INSERT INTO sbl_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Agka mag-inggit ha tawtawoy angkabiyay ha powirsawan boy agka maki-emen ha gawgawà la, ");
INSERT INTO sbl_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","ta hay Pangino-on ay angka-inakit ha mangala-et ya tawtawo, piro ha mangahampat ya tawtawo ay maheneh ya. ");
INSERT INTO sbl_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Hay tawtawoy mangala-et ay an-ihompà nin Pangino-on, piro hay tawtawoy mangahampat ay an-ingalowan nan biyan kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Ahè labay nin Pangino-on ya tawtawoy mapagmatag-ay, piro hay tawtawoy mapagma-aypà ay an-ingalowan na. ");
INSERT INTO sbl_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Hay mangaronong ay ampagkama-in karangalan, piro hay angkatanggap nin tawtangah ay kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Aw-anak koy lalaki, leng-en moyoy an-itorò komoyo nin tatay moyo. Intindiyen moyo emen kawo magkama-in pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Hay an-itorò ko komoyo ay mahampat; kayà pirmi moyon ihipen. ");
INSERT INTO sbl_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Hiko man, hin anak ako et nin bilang komoyo ay nilabi ako nin nanay ko bilang kasiyasiya nan anak. ");
INSERT INTO sbl_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","Ha panonorò kongko nin tatay ko ay ombayri ya hinalità na: “Ihipen moy hinalità ko boy gaw-en moy an-ipanogò ko emen komarà ya biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Emen ka magkama-in karonongan boy pangingintindi, hay hinalità ko komo ay agmo liwawan boy agmo halibokotan. ");
INSERT INTO sbl_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Agmo pa-olayan nin ma-alih komo ya karonongan. Pa-alaga-an mo emen ka ma-in protiksyon boy emen agka mapangno. ");
INSERT INTO sbl_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Pagsikapan mon magkama-in karonongan ta habayto ay pinakama-alagà ha biyay mo, boy hay ka-ilangan mo et ay magkama-in kan pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Pa-alaga-an moy karonongan emen hay pagkatawo mo ay tomag-ay; pangoligtanan mo bayti ta habayti ya mambi komo nin dangal. ");
INSERT INTO sbl_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Habayti ya karonongan ay bilang ha maganday korona ya ampambi komo nin kagandawan.” ");
INSERT INTO sbl_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Anak koy lalaki, leng-en mo ko boy paka-intindiyen moy anhalita-en ko emen komarà ya biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Intorò ko komo no pangno ka magkama-in karonongan boy intorò koyna simpri komo ya pamamaraan no pangno ka magkama-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","No ma-in kan karonongan ay agka mibatol no hika ay ampowako, boy agka mipalokmà no hika ay ampowayo. ");
INSERT INTO sbl_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Pangoligtanan mon mahampat ya natotowan mo. Hay pinag-aralan mo ay agmo pa-olayan ta habayto ay importanti ha biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Agka mako ha anlakwen nin tawtawoy mangala-et boy agka manowad ha gawgawà la. ");
INSERT INTO sbl_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Agmo gaw-en bayto ya ombayro! Pakarayò ka ha kala-etan ta isigi moy panggawà mon kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Hay tawtawoy mangala-et ay ahè makakatoloy anggan aghila makagawà nin kala-etan, boy aghila pa-inawa anggan aghila makagawà nin ikakhit nin kanayon. ");
INSERT INTO sbl_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Kala-etan ya kowinta pamamangan la boy kabayaniyan ya kowinta inomen la. ");
INSERT INTO sbl_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Hay ampagdanan nin tawtawoy mangahampat ay emen kahawang hilà allo ya kapanhohomawang no bayombokah. ");
INSERT INTO sbl_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Hay ampagdanan balè nin tawtawoy mangala-et ay emen kareglem deem. Ampibatol hila ta agla angkakit ya ampibatolan la. ");
INSERT INTO sbl_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Anak koy lalaki, leng-en mo boy intindiyen ya anhalita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Agmo pa-olayan nin ma-alih ha ihip mo, no alwan itanem mo ha nakem mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Habayti ya ombayri ya tawtorò ay ampakab-in biyay boy kalighawan ha hinoman ya ampaka-intindi. ");
INSERT INTO sbl_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Dipenen moy nakem mo boy pangingihip mo ta habayti ya ampangibatan nin kaganawan ha biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Atapan mon maghalità nin kabongkokan, boy agka magtotol nin ayin kaptegan. ");
INSERT INTO sbl_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Ipirmi moy nakem mo ha kahampatan nin bilang ha tawoy kowinta ampowako ya alwan mamalingawlingaw. ");
INSERT INTO sbl_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Pi-awengen mon mahampat ya ampagdanan mo. Ha ombayro, hika ay ampakasigoro ha pamomowako mo. ");
INSERT INTO sbl_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Atapan mon makilamo ha tawtawoy ampanggawà kala-etan, ta manggawà kan kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Anak koy lalaki, leng-en moy tawtorò ko komo ya hay anggamiten ko ay karonongan boy pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Ha ombayro ay matoto kan mag-in mahampat boy ha paghahalità mo ay matanda-an ya ma-in kan tinandà. ");
INSERT INTO sbl_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","No leng-en mo ko ay ayin makatoksò komo. Maski hay alek nin pota ay emen katam-in polot boy hay pag-i-ilgo na ay ampaka-ingganyo, ");
INSERT INTO sbl_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","pangayarì nin kaganawan ay osigen ka nin konsinsya mo nin bilang kan ampangan mapa-it boy emen kan tinoyhok nin matarem ya hondang ya mitaligmang ya tarem. ");
INSERT INTO sbl_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Hay ombayroy babayi ay mipalako ha kamatyan boy ampagpalako ha dogal nin nikati, ");
INSERT INTO sbl_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","ta pina-alilihan nay daan nin magpalako ha biyay ya ayin anggawan; kayà hay ampagdanan na ay tiko-tikò ya agmo tandà no ayri ya pipalakwan na. ");
INSERT INTO sbl_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Hapa-eg, aw-anak koy lalaki, leng-en moyo ko boy agmoyo liwawan ya anhalita-en ko. ");
INSERT INTO sbl_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Balang miha komoyo ay pakarayò ha ombayroy babayi! Agka pakarani ha bali na, ");
INSERT INTO sbl_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","ta no matoksò ka, hay karangalan mo ay ma-alih komo ta mipalako ha kanayon, boy patyen ka nin tawtawoy ayin ingangalo. ");
INSERT INTO sbl_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Hay kayamanan mo ay kowen nin dawdayowan boy hay pinagpagalan mo ay kanayon ya makinabang. ");
INSERT INTO sbl_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Ha bandan hoyot, no marani kaynan mati ay mi-a-anito ka, ta hika ay ombeng anggan mag-in kan kakatatkatat boy kabobot-o, gawà nin masakit ya nakwa mo ha pagkatoksò mo. ");
INSERT INTO sbl_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Banà bayro ay ombayri ya halita-en mo, “Antà agko napatorò boy antà agko nanlengè ha wawwawali kongko? ");
INSERT INTO sbl_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Agko nanlengè ha nipanorò kongko boy agko hila inintindi. ");
INSERT INTO sbl_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Kayà hapa-eg ay anti ko bayrin ka-i-ingalo boy ampipareng-ey ha arapan nin nititipon ya tawtawo.” ");
INSERT INTO sbl_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Anak koy lalaki, hay dapat mon gaw-en ay pakatapat ka ha ahawa mo boy hiyan bongat ya labiyen mo. ");
INSERT INTO sbl_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Agka mamabayi boy agka mag-intris ha kanayon ya babayi. ");
INSERT INTO sbl_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Hay mahampat ya anggaw-en moyon mita-ahawa ay agmo alihan alagà ha pamako mo ha kanayon ya bawbabayi. ");
INSERT INTO sbl_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Pakaliga ka ha babayi ya pinakahalan mo ta anti kona ya kaligawan mo. ");
INSERT INTO sbl_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Hiya ay maganda boy malikhin manige-tigè nin bilang ha oyha. Ha pangangarinyo mo kona ay mag-in kan kontinto emen ka lomiga ha panlalabi na. ");
INSERT INTO sbl_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Anak ko, antà ma-ibeg ka ha babayi ya pota, boy antà labay mo et ya kawkarinyo nin kanayon ya babayi? ");
INSERT INTO sbl_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Kaganawan anggaw-en nin tawo ay angkakit nin Pangino-on ta ambantayan na ya maski ayri ya mako. ");
INSERT INTO sbl_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Hay kawkasalanan nin mala-et ya tawo ay habaytoy mangiparakep kona. No narakep yayna ay mahe-el yayna ha kawkasalanan na. ");
INSERT INTO sbl_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Hiya ay mati ta ayin yan pagpependan ha sarili na. Kamatyan ya lakwen na nin banà ha katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Anak koy lalaki, no ginarantyawan moy kapara mo ha otang na ");
INSERT INTO sbl_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","ay sarili mon halità ya nakapiparakep komo. ");
INSERT INTO sbl_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Hapa-eg, anak ko, no ombayroy nangyari komo ay anti ka ha hilong kapangyariyan nin hatoy ginarantyawan mo. Emen ka makalibri ay ombayri ya gaw-en mo: manandalì kan mako kona ta makitotol kan ilibri na ka. ");
INSERT INTO sbl_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Agka matoloy o mamitiglep anggan agmo magawà. ");
INSERT INTO sbl_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Pa-alilihan moy pinakadakpan komo nin bilang ha pama-alilih nin oyha ha mangangaho boy bilang ha pama-alilih nin manokmanok ha ampanilò kona. ");
INSERT INTO sbl_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Hikay tawo ya matamlad, emen ka domonong ay pag-aralan moy pamamaraan nin aw-ayà. ");
INSERT INTO sbl_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Maski ayin ampamo-on ya ampagmanda konla, ");
INSERT INTO sbl_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","peleg ka-ingitan ay ampagsikap hilan manipon pamamangan ya pangabagat la. ");
INSERT INTO sbl_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Piro hikay tawo ya matamlad, anggan makano kaboyot ya pangatoloy mo, boy makano ka mibangon ha pamimirà mo? ");
INSERT INTO sbl_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Tombay baytoy matamlad, ya wana, “Amò tanay pangatoloy ko boy pamitiglep ko.” ");
INSERT INTO sbl_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","Piro ha pangangatoloy na ay ka-irapan ya biglà lomateng kona nin bilang ha mananakaw ya naka-armas nin manakaw. ");
INSERT INTO sbl_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Hay mala-et boy ayin kowintan tawo ay antomalà nin magtotol kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Hay mata na, bitih, boy gamet ay anggamiten nan pagsinyas na emen ya makaloko, ");
INSERT INTO sbl_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","ta pirmin kala-etan ya anti ha nakem na boy kagolowan ya anggaw-en na. ");
INSERT INTO sbl_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Banà bayri ha gawgawà na ay ma-in biglà lomateng kona ya alwan maganday pangyayari. Hiya ay ahè malibri boy ayin anan rimidyo kona. ");
INSERT INTO sbl_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Ma-in anem ya bagay ya angka-inakitan nin Pangino-on; ah! Alwa kalì anem no alwan pitoy bagay ya ampamahangan na. ");
INSERT INTO sbl_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","Habaytoy pitoy bagay ay ombayri: mapagmatag-ay ha kapara, mabongkok, mapamati nin tawoy ayin kasalanan, ");
INSERT INTO sbl_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","pirmin ampagplanon mala-et, maparan manggawà kala-etan, ");
INSERT INTO sbl_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","manistigos nin kabongkokan, boy mami-a-away. ");
INSERT INTO sbl_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Anak koy lalaki, honolen mo boy agmo liwawan ya an-ipanogò komo nin mawmato-antawo mo. ");
INSERT INTO sbl_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Itanem mo ha nakem mo boy gaw-en mo nin emen ha kolinta, ");
INSERT INTO sbl_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","ta habayto ya mangitoto komo ha pantomalà mo. Ahè ma-alih komo maski angkatoloy ka, boy ha pamimata mo ay mag-in wawali komo. ");
INSERT INTO sbl_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Hatoy tawtorò nin mawmato-antawo mo ay emen hilag ya ampambin hawang komo, boy hay disiplina la ay makapitoto komo ha kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Habayto et ya mangi-atap komo ha babayi ya mala-et boy ha mangalahap ya hawhalità nay pangingganyo komo. ");
INSERT INTO sbl_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Agka mag-intris ha ganda na boy agka ma-ibeg ha tegteg na. ");
INSERT INTO sbl_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Hay babayi ya pota ay angka-arì bayaran nin emen bongat ha alagà nin tinapay, piro hay pamabayi ay ampangibatan nin hay manga-alagà ya bagay ha biyay nin lalaki ay ma-alih. ");
INSERT INTO sbl_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Warì ahè mapo-olan ya dolo nin mihay lalaki no hay pantan nan bawbayah ay ilaret na ha nebneb na? ");
INSERT INTO sbl_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Ahè warì mapilah ya bitih na no mowako ya ha bawbayah? ");
INSERT INTO sbl_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Ombayro kapiligro ya mamabayi nin ahawa nin ma-in ahawa. Hinoman ya manggawà nin ombayro ay ahè ma-arì nin agya parosawan. ");
INSERT INTO sbl_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Ma-arì mapatawad ya nanakaw nin pamamangan no hay bara-nan nin panakaw na nin habayto ay mabitil ya. ");
INSERT INTO sbl_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Piro no narakep ya ay dapat nan i-orong nin kapitoy bisis baytoy tinakaw na. Kayà kaganawan nin ma-in kona ay ma-arì nan ma-obon igwà. ");
INSERT INTO sbl_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Hay ampamabayi ay tangah ta anhira-en nan bongat ya sarili na. ");
INSERT INTO sbl_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Ma-alih ya dangal na, bogbogen ya, boy hay tawtawo ay agana magrispito kona. ");
INSERT INTO sbl_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Hay pangimon ay ampakapapahang. Ahè ma-anggawan ya pahang nin ahawa nin nakilalaki boy ayin anggay pangganti na. ");
INSERT INTO sbl_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Ayin maka-alih nin pahang na maski bayaran ya boy maski anya et ya irigalo kona. ");
INSERT INTO sbl_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Anak koy lalaki, honolen moy anhalita-en ko komo. Etpanan mo bayti emen agmo maliwawan. ");
INSERT INTO sbl_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Honolen moy anhalita-en ko emen homampat ya biyay mo. Paka-atap ka ha panhohomonol mo ha tawtorò ko nin bilang pangi-atap mo nin mata mo. ");
INSERT INTO sbl_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Pangoligtanan moy tawtorò ko boy itanem mo ha nakem mo. ");
INSERT INTO sbl_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Hay karonongan ay itoring mo nin bilang ha patel moy babayi, boy hay pangingintindi ay itowad mo nin bilang ha maheney amigo mo. ");
INSERT INTO sbl_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","No pangoligtanan moy karonongan ay matoto kan mag-atap ha babayi ya mala-et boy agka ma-ingganyo nin hawhalità nay mangalahap. ");
INSERT INTO sbl_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Minghan, hiko ay ampanamolaw ha dorwangan nin bali ko. ");
INSERT INTO sbl_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Ma-in akon nakit ya aw-anakabayo ya hay miha konla ay nalili-o ko ya ayin tinandà. ");
INSERT INTO sbl_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Hiya ay ampowako ha kalsara ya marani ha kanto nin ampa-iriyan nin babayi ya pota. ");
INSERT INTO sbl_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Hin habayto ay ampi-ayoy mahawang boy mareglem ta anyomabi ana. ");
INSERT INTO sbl_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Hapa-eg, ma-in babayi ya napakarani kona ya hay holot ay bilang holot nin babayin pota boy poro panloloko ya annakemen na. ");
INSERT INTO sbl_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Hiya ay malablab, ayin kareng-eyan, boy ahè ampagpirmi ha pamamali. ");
INSERT INTO sbl_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Amò papa-inghan ay anti ya ha kalsara; totongna, anti ya ha plasa; amò papa-inghan ana et ay anti ya ha kanto ta ampangabang nin maloko na. ");
INSERT INTO sbl_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Hapa-eg hatoy anakabayoy ayin tinandà ay na-antì na. Hinagep na ya biha na inalekan, boy pinakategteg na ya ta hinalità na kona, ya wana, ");
INSERT INTO sbl_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Hapa-eg allo ay tinopad koy pangakò ko boy ma-in akon inhandà ya pamamangan; ");
INSERT INTO sbl_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","kayà anti ko bayrin ampanikap komo. Mahampat ta nakit kata. ");
INSERT INTO sbl_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Inapinan koy pamira-an ko nin makodpaw ya doloy di kolor ya ibat ha Ihipto. ");
INSERT INTO sbl_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Pinabangohan ko et nin ma-alagà ya pabangoh ya an-ingaten mira, alowi, boy kanila. ");
INSERT INTO sbl_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Kayà mako kaynari ta magpakaliga ta anggan bayombokah. ");
INSERT INTO sbl_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Hay ahawa ko ay ayin bayri ha bali ta marayò ya tinalà na. ");
INSERT INTO sbl_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Nagbawon yan malakè ya kowalta ta agya morong anggan ahè magkabilogan ya bowan.” ");
INSERT INTO sbl_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Hapa-eg, ha kagalingan nan mag-ilgo ay nagaygay na baytoy anakabayo nin hawhalità nay mangalahap. ");
INSERT INTO sbl_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Antimano, hiya ay hinomono kona nin bilang ha toroy bakà ya gitan patyen, o bilang ha oyha ya an-omarap ha kamatyan ");
INSERT INTO sbl_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","ta hay yawò ay nakapatoyò ha posò na. Emen ya et ha manokmanok ya ampagpalako ha hilò ya agna tandà ya hay biyay na ay ampamiligro. ");
INSERT INTO sbl_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Kayà aw-anak koy lalaki, leng-en moyoy anhalita-en ko boy honolen moyo. ");
INSERT INTO sbl_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Agmoyo ipakilalakoy nakem moyo ha ombayroy babayi. Agkawo makilalako kona. ");
INSERT INTO sbl_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Hiya ay nanirà nin malakè ya lalaki boy agana mabilang ya nati nin banà kona. ");
INSERT INTO sbl_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Hay bali na ay emen ha dogal nin nikati; kayà no lakwen moyo ay emen kawon ampako ha kamatyan moyo. ");
INSERT INTO sbl_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Leng-en moyo! Agmoyo nayì angkalengè ya tongkol ha karonongan ya ampangibat ha Diyos ya kowinta ampangingat komoyo, boy tongkol ha pangingintindi ya kowinta ampambolyaw komoyo? ");
INSERT INTO sbl_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Hay karonongan ay kowinta ampireng ha matag-ay ya dogal ha danin daan, ha kawkanton daan, ");
INSERT INTO sbl_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","boy ha pawpolta nin palako ha siyodad ya ampangibolyaw nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“Hikawoy tawtawo ha babon lotà, balang miha komoyo ay an-ingaten ko. ");
INSERT INTO sbl_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Hikawoy alwa et nin matodtod, magpakatodtod kawo. Hikawoy tawtangah, magnakem kawo. ");
INSERT INTO sbl_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Leng-en moyoy hawhalità koy mangahampat; kaganawan halita-en ko komoyo ay tamà. ");
INSERT INTO sbl_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Hay anhalita-en ko ay kaptegan; hay kabongkokan ay angka-inakitan ko. ");
INSERT INTO sbl_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Kaganawan anhalita-en ko ay kaptegan; agko ampaghalità nin kalawakaw o kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Ha tawoy ma-in pangingintindi, habaytoy hinalità ko ay malinaw para kona, boy matoynong para ha ma-in tinandà. ");
INSERT INTO sbl_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Tanggapen moy tawtorò ko boy tinandà kisa magsikap kan manikap nin pilak boy taganas gintò. ");
INSERT INTO sbl_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","“Hiko ya karonongan ay mas mahampat kisa ha aw-alahas, boy ha kaganawan angka-ibegan mo ay ayin ma-ipariho ha karonongan ya ayin kanayon no alwan hiko. ");
INSERT INTO sbl_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Hiko ya karonongan ay ampambin pangingintindi, boy ma-in akon tinandà nin mangintindi. ");
INSERT INTO sbl_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Hay anggomalang ha Pangino-on ay angka-inakit ha kala-etan. Hiko man ay angka-inakit ha mapagmatag-ay, mahambog, mala-et ya gawgawà, boy ha kawkabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Hiko ya karonongan ay makapagwawali nin mahampat ta ma-in akon pangingintindi boy kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Banà kongko, hay aw-arì ay angkagawà lay pamomo-on la, boy hay ampipamo-on ay ampakagawà nin tamà ya pawpanogò. ");
INSERT INTO sbl_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Ha tambay ko, hay ampipamo-on ha babon lotà ay matoynong ya pamomo-on. ");
INSERT INTO sbl_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Anlabiyen koy ampipanlabi kongko, boy matotowan ako nin ampipagsikap manoto kongko. ");
INSERT INTO sbl_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Hay kayamanan, karangalan, boy ka-inomayan ay hikoy makab-i. ");
INSERT INTO sbl_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Hay makwa moyo kongko ay igit et ha pinakama-alagà ya poroy gintò boy poroy pilak. ");
INSERT INTO sbl_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Hay mananggap kongko ay ampamiyay nin ma-in kahampatan, boy anhomonol ha katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Hay ampipanlabi kongko ay ambiyan kon kayamanan, boy hay bali la ay ampon-en kon kawkamama-in ya manga-alagà. ");
INSERT INTO sbl_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“Biha pinalsa nin Diyos ya kaganawan, hiko ya karonongan ay antina kona. ");
INSERT INTO sbl_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Hin ka-ona-onawan pana-on, ayin et ya babon lotà, hiko ay hikoyna. ");
INSERT INTO sbl_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Hiko ay hikoyna hin ayin et dagat boy ayin et hawhobol ya anlowahan lanom. ");
INSERT INTO sbl_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Biha na-ikolokar ya bawbakil boy bawbakilbakil, hiko ay hikoyna. ");
INSERT INTO sbl_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Hiko simpri ay hikoyna biha ginawà nin Diyos ya babon lotà, lawlawak, o maski anyay klasin lotà. ");
INSERT INTO sbl_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Anti ko kona hin ginawà nin Diyos ya langit boy pi-anggawan nin langit boy lotà, ");
INSERT INTO sbl_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","hin inggawà nin Diyos ya leem ha langit kateng hawhobol ha dagat, ");
INSERT INTO sbl_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","hin minandawan nay dagat nin ahè lomampas ha inggawà nay pi-anggawan, boy hin inggawà nay pampatibay nin lotà. ");
INSERT INTO sbl_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Hiko ay anti ha dani nin Diyos nin bilang mihay arkitikto. Allo-allo, hiko ya ampangibatan nin kaligawan na, boy hay towà ko ta anti ko kona. ");
INSERT INTO sbl_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","An-ikaliga koy babon lotà ya ampa-iriyan nin tawtawo, boy angkatowà ako konla. ");
INSERT INTO sbl_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“Hapa-eg, aw-anak koy lalaki, leng-en moyo ko. Makalmà ya tawtawoy anhomonol kongko. ");
INSERT INTO sbl_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Leng-en moyo boy pa-alaga-an ya an-itorò komoyo. Magpakatalino kawo. ");
INSERT INTO sbl_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Makalmà ya tawoy ampanlengè kongko boy allo-allon anti ha poltan bali ko nin ampangantì kongko. ");
INSERT INTO sbl_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Hinoman ya tawoy makatoto kongko ay magkama-in biyay ya ayin anggawan boy mangonsowilo kona ya Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Balè hinoman ya tawoy ahè makatoto kongko ay ampakakhitan nay sarili na. Hinoman ya ampag-inakit kongko ay kamatyan ya antikapen na.” ");
INSERT INTO sbl_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Hay karonongan ay kowinta nanggawà bali na ya ma-in pitoy tarek. ");
INSERT INTO sbl_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Hiya ay nagpati nin aw-ayop ya ihandà na boy nanimpla yan alak biha na inggawà ha babon lamisa. ");
INSERT INTO sbl_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Hapa-eg, nangihogò yan aw-alilà nay babayi nin mako ha mangatag-ay ya dogal ha banowa ta ombayri ya an-ipabolyaw na konla: ");
INSERT INTO sbl_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Mako kawo bayri, tawtawoy ayin tinandà.” Ha tawtawo itaman ya tangah ay ombayri ya hinalità nin karonongan: ");
INSERT INTO sbl_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Mako kawo bayri ta kanen moyo bayti ya inhandà ko boy inomen moyo bayti ya alak ya tinimpla ko. ");
INSERT INTO sbl_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Mog-alih kawo ha tawtawoy ayin tinandà emen lomawig ya biyay moyo. Mamiyay kawo nin ma-in pangingintindi.” ");
INSERT INTO sbl_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","No korihiren moy tawo ya mapanoya-toyà ay insoltowen na kan bongat. No ha-aren moy mala-et ya tawo ay makhitan kan bongat. ");
INSERT INTO sbl_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Agka mangorihir nin tawoy mapanoya-toyà ta pag-inakitan na ka, piro no hay korihiren mo ay tawoy maronong, hika ay labiyen na. ");
INSERT INTO sbl_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","No toro-an moy maronong ya tawo ay lalò yan domonong. Anyaman ya halita-en mo ha tawoy mahampat ay lalò mapahanan ya pangingintindi na. ");
INSERT INTO sbl_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","No labay mon mag-in maronong ay igalang moy Pangino-on. Magkama-in ka nin pangingintindi no bomalay ka ha Diyos ya ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","No anti komo ya karonongan ay lomawig ya biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Ayin kanayon ya makinabang no alwan hika no anti komo ya karonongan, balè no tanggi-an mo bayti ay anti komoy kalogiyan. ");
INSERT INTO sbl_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Hay ka-alimbawa-an nin katangahan ay ayin imbalag ha babayi ya mala-ab, ayin tinandà, boy ayin kareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Hiya ay ampiknò ha poltan bali na, o ha aw-ikno-an ya anti ha matag-ay ya dogal ha banowa, ");
INSERT INTO sbl_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","ta hay tawtawoy ma-in lalakwen ya ampikalibah bayro ay an-ingaten na, ya wana, ");
INSERT INTO sbl_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Magdaan kawo bayri ya aw-ayin tinandà!” Ha tawoy tangah itaman ay ombayri ya anhalita-en na: ");
INSERT INTO sbl_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Hay lanom ya tinakaw ay malahap boy hay tinapay ya tinakaw ay ma-alinamnam.” ");
INSERT INTO sbl_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Hay tawtawoy angka-ingganyo nin mako ha bali nin habaytoy babayi ay agla tandà ya hay risolta nin pamako la bayro ay kamatyan nin bilang ombayro ha nika-onan nako bayro. ");
INSERT INTO sbl_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Habayti et ya kawkahalita-an ni Solomon: hay maronong ya anak ay ampakab-in kaligawan ha mawmato-antawo na, piro hay anak ya tangah ay kalele-an ya an-igwà na konla. ");
INSERT INTO sbl_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Hay kamama-in ya nakwa ha mala-et ya pamamaraan ay ahè pakinabangan, piro hay katapatan ay makapilibri nin biyay. ");
INSERT INTO sbl_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Ahè payagan nin Pangino-on nin mabitlan ya mangahampat ya tawtawo, boy hay anhangaren nin mangala-et ya tawtawo ay agna ampayagan. ");
INSERT INTO sbl_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Hay tawoy matamlad ay ampag-irap, piro hay mahipeg ay anyomaman. ");
INSERT INTO sbl_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Hay maronong ay ampanipon alawah no pana-on pangalawah, piro hay tawoy kapangakatoloy no pana-on pangalawah ay ampipareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Hay mahampat ya tawo ay ampananggap kahampatan. Hay mala-et ya tawo, ha kagalingan nan maghalità ay angkapaghakban nay kala-etan na. ");
INSERT INTO sbl_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Hay pamamanemtem ha tawtawoy mangahampat ay ampambin kaligawan, balè hay ngalan nin tawtawoy mangala-et ay angkasorawan. ");
INSERT INTO sbl_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Hay tawoy maronong ay anhomonol ha maganday wawali, piro hay tawoy ampaghalità nin kalokowan ay sarili na ya anhira-en na. ");
INSERT INTO sbl_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Hay tawoy tapat ay ampakasigoron ma-in kalibriyan, piro hay tawoy alwan tapat ay angkarakep. ");
INSERT INTO sbl_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Hay tawoy ampaki-ayon ha ampagkasalanan ay ampanggawà kagolowan, piro hay tawoy makhaw ya nakem manita ay ampambin katinekan. ");
INSERT INTO sbl_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Hay hawhalità ya anhalita-en nin mahampat ya tawo ay emen hobol ya ampambin biyay, piro hay mala-et ya tawo, ha kagalingan nan maghalità ay angkapaghakban nay kala-etan na. ");
INSERT INTO sbl_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Hay an-ibonga nin inakit ay kagolowan, piro hay ampanlabi ay ahè ampangasikaso nin kamali-an. ");
INSERT INTO sbl_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Hay tawoy ampaka-intindi ay ampaghalità nin ma-in karonongan, piro hay tawoy tangah ay angkaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Hay tawtawoy mangaronong ay ampangantì nin tamà ya pana-on nin ibalità la ya tinandà la, piro hay anhalita-en nin tawoy tangah ay ampakahirà ta agna ampi-awengen ya anhalita-en na. ");
INSERT INTO sbl_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Hay protiksyon nin mangayaman ay kawkamama-in la; hay ampakahirà ha manga-irap ay ka-irapan la. ");
INSERT INTO sbl_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Hay primyo nin mahampat ya tawo ay biyay ya ayin anggawan, piro hay tawoy mala-et ay lalò ana ingat ampanggawà kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Hay tawoy ampanlengè ha an-isita kona ay lomawig ya biyay, piro hay tawoy ahè ampangamin nin hiya ay nagkamalì ay mitawon. ");
INSERT INTO sbl_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Hay tawoy ampangitagò nin inakit ay mabongkok, boy hay tawoy madaldal ay tangah. ");
INSERT INTO sbl_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Hay tawoy masalità ay ampakapagkasalanan. Hay tawoy maronong ay alwan matlek. ");
INSERT INTO sbl_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Hay hawhalità nin mahampat ya tawo ay ampa-alaga-an nin emen ha poroy pilak, piro hay pangingihip nin mala-et ya tawo ay ayin alagà. ");
INSERT INTO sbl_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Hay hawhalità nin mahampat ya tawo ay pakinabangan nin malakè ya tawo, piro hay tangah ay angkati banà ha kakolangan ha pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Hay tawo ay anyomaman ha kahampatan nin Pangino-on, alwan ha paghakit nan magtrabaho. ");
INSERT INTO sbl_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Hay tawoy tangah ay angkatowà ha panggawà nan kala-etan, piro hay tawoy ampaka-intindi ay an-ikatowà nay karonongan na. ");
INSERT INTO sbl_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Hay angkalimowan nin mala-et ya tawo ay mangyari kona, piro hay mahampat ya tawo ay matanggap nay anhangaren na. ");
INSERT INTO sbl_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Hay tawoy mala-et, no ma-in anlomateng kona ya emen ha bagyo ay kowinta ampi-alipad, piro hay tawoy mahampat ay alwan ombayro ta maski anyay anlomateng kona ay matibay ya nin emen ha nakapondasyon ya bali. ");
INSERT INTO sbl_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Agka mangwan matamlad ya tawo ya patrabahowen mo nin para komo ta masora kan bongat nin bilang ha ngipen mo ya nangilah nin hokà boy bilang ha mata mo ya angka-ahokan. ");
INSERT INTO sbl_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Igalang moy Pangino-on emen bomoyot ya biyay mo. Hay mala-et ya tawo ay angkati nin ayin ha oras. ");
INSERT INTO sbl_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Hay an-asawan nin mangahampat ya tawtawo ay makab-i konla nin kaligawan, piro hay an-asawan nin mangala-et ya tawtawo ay ahè lomateng konla. ");
INSERT INTO sbl_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Hay tawtawoy ayin kasalanan ay an-i-atap nin Pangino-on, piro hay ampipanggawà kala-etan ay ampa-anggawan na. ");
INSERT INTO sbl_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Hay tawtawoy ma-in kahampatan ay ampakasigoron ma-in pagpirmiyan, piro hay tawtawoy mangala-et ay ayin kinapirmiyan. ");
INSERT INTO sbl_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Hay tawtawoy mangahampat ay ampaghalità nin ma-in karonongan, piro hay tawtawoy mangala-et ay ampa-anggawan ha paghalità lan kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Tandà nin tawtawoy ma-in kahampatan no anyay halita-en la ya makapakonsowilo nin kapara lan tawo, piro hay anhalita-en nin tawtawoy mangala-et ay ampakakhit nakem nin kapara lan tawo. ");
INSERT INTO sbl_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Angka-inakitan nin Pangino-on ya tawoy ampanggamit nin titimbangan ya ma-in ha-ol, piro angkatowà ya ha tawoy tapat ya ampanggamit nin titimbangan ya tamà. ");
INSERT INTO sbl_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Hay tawoy mapagmatag-ay ay ampipareng-ey, piro hay tawoy mapagmaka-aypà ay ma-in karonongan. ");
INSERT INTO sbl_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Katapatan ya ampangitoto ha tawoy ma-in kahampatan, piro hay tawoy ahè mapahimala-an, hay ampakahirà kona ay alwa yan tapat. ");
INSERT INTO sbl_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Hay kayamanan mo ay ayin magawà no lomateng anay allon kamatyan mo, piro hay katapatan ay ampakapipa-alilih ha kadisgrasyawan. ");
INSERT INTO sbl_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Hay katapatan ay ampakapa-inomay ha biyay nin mahampat ya tawo, piro hay tawoy mala-et ay angkahirà nin sarili nan kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Hay kahampatan ay ampakapilibri nin tawoy tapat, piro hay tawoy ahè mapahimala-an ay angkahagep ha kahiba-an. ");
INSERT INTO sbl_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Pangati nin mala-et ya tawo, kateng an-asawan na ay ma-anggawan, boy hay an-asawan nay kayamanan bayri ha babon lotà ay ayin. ");
INSERT INTO sbl_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Hay mahampat ya tawo ay an-i-atap ha kagolowan; kayà mala-et ya tawo tana ya anlatngan nin kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Hay tawo ay angkahirà banà ha kala-etan paghahalità nin tawoy ayin katetpel ha Diyos, piro hay karonongan nin mahampat ya tawo ay ampakapilibri. ");
INSERT INTO sbl_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Hay tawtawo ha siyodad ay ampipagtowà no an-omasinso ya tawtawoy mangahampat, piro ampibobo-angaw hilan magligaliga ha pagkamati nin tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Ha gawà nin tawtawoy mangahampat ay an-omasinso ya siyodad, piro hay siyodad ay angkahirà nin hawhalità nin mangala-et ya tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Hay tawoy kolang ha tinandà ay ampanyamo-yamò nin kaparan tawo, piro hay tawoy ma-in pangingintindi ay alwan matlek. ");
INSERT INTO sbl_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Hay tawoy madaldal ay ahè masikritowan, piro hay tawoy mapahimala-an ay angkapagkompiyansawan. ");
INSERT INTO sbl_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Hay tawtawo ha mihay nasyon ay angkatalo no ayin ampangitoto, piro no malakè ya ampagwawali ay sigoradon manalo. ");
INSERT INTO sbl_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Hay tawoy ampagpangakò nin mamayad otang nin agna kabalay ay paghehean na; kayà hay mahampat ay ahè mangakò ha ombayroy tawo. ");
INSERT INTO sbl_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Hay mateptep ya babayi ay an-igalang, piro hay babayi ya ahè ampagpa-alagà ha sarili ay ahè an-igalang. Hay tawoy matamlad ay ahè magkama-in kowalta, piro hay mahipeg ay magkama-in kayamanan. ");
INSERT INTO sbl_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Hay tawoy ma-ingangalowen ay ampanggawà ikahampat nin sarili na, piro hay tawoy mahiblet ay anhira-en nay sarili na. ");
INSERT INTO sbl_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Hay mala-et ya tawo ay ayin angkapakinabang, piro hay ampanggawà kahampatan ay sigoradon ma-in primyo. ");
INSERT INTO sbl_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Hay tawoy ampanggawà kahampatan ay ampagkama-in nin mahampat ya pamimiyay, piro hay tawoy ansomigin manggawà kala-etan ay ampanikap kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Hay tawtawoy ma-in mala-et ya kanakeman ay angka-inakitan nin Pangino-on, piro ampangonsowilowan na ya tawtawoy ampanggawà kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Hay mangala-et ya tawtawo ay sigoradon parosawan nin Pangino-on, piro hay mangahampat ya tawtawo ay malibri. ");
INSERT INTO sbl_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Hay maganday babayi ya ayin mahampat ya gawà ay emen hinghing ya gintò ya anti ha ngohò nin baboy. ");
INSERT INTO sbl_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Hay an-apehen nin mangahampat ya tawtawo ay kahampatan, piro hay mangala-et ya tawtawo, hay ma-antì la ay kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Hay tawoy mabibi-iyen ay lalò ampagkama-in, piro hay tawoy ahè labay mambi nin dapat nan igwà ay lalò angka-ayinan. ");
INSERT INTO sbl_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Hay tawoy mabibi-iyen ay ampomalindaway ya biyay. Manambay ka ha kanayon emen la ka tambayan. ");
INSERT INTO sbl_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Hay tawoy maglalakò boyah ay angkasorawan nin tawtawo no hay boyah na ay an-itagò na ta an-i-antì nan tomag-ay ya prisyo, piro amporiyen lay tawo ya ampaglakò ha pana-on nin panganga-ilangan la. ");
INSERT INTO sbl_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Hinoman ya ampaghangad nin kahampatan ay ampakapakonsowilo, piro hinoman ya ampanikap kagolowan ay habayto ya makit na. ");
INSERT INTO sbl_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Hay tawoy ampahimalà ha kayamanan na ay ayin imbalag ha bolong kayo ya no ka-ingitan ay angkalagah, piro hay mangahampat ya tawtawo ay ayin imbalag ha bolong kayo ya lalò anlomaboyong no abagat. ");
INSERT INTO sbl_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Hay tawoy ampambin kagolowan ha pamilya na, ha bandan hoyot ay ayin malateng kona. Hay tawoy tangah ay mag-in alilà nin maronong. ");
INSERT INTO sbl_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Kaligawan ya an-igwà ha biyay nin tawoy ma-in kahampatan, boy hay ampangipakarani nin tawo ha Diyos ay maronong. ");
INSERT INTO sbl_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","No pangno primyowan nin Diyos ya mangahampat ya tawtawo bayri ha babon lotà ay ombayro na itaman parosawan ya tawtawoy mangala-et boy mawmakasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Hay tawoy labay magkama-in tinandà ay ampananggap sisita no ampagkamalì ya. Katangahan nin tawo ya ahè labay pasita. ");
INSERT INTO sbl_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Hay tawoy mahampat ay ampangonsowilowan nin Pangino-on, piro hay tawoy ampagplanon kala-etan ay anhosgawan na. ");
INSERT INTO sbl_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Hay gawgawà nin mala-et ya tawo ay ahè manatili, piro hay mangahampat ya tawtawo, maski anyay mangyari ay ampanatilin matibay. ");
INSERT INTO sbl_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Hay mahampat ya ahaway babayi ay karangalan boy kaligawan nin ahawa na, piro no hay ahaway babayi ay ampangipareng-ey nin ahawa ay emen ya ha masakit ya ahè matambal ya ampanirà bot-o nin ahawa na. ");
INSERT INTO sbl_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Hay tapat ya tawtawo ay anggomawà kahampatan ha kapara la, piro hay mangala-et ya tawtawo ay labay bongat manloko nin kapara la. ");
INSERT INTO sbl_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Hay hawhalità nin mangala-et ya tawtawo ay kowinta ampakamati ta ampakahirà nin kapara banà ha bawbarà lay alwan peteg, piro hay hawhalità nin mangahampat ya tawtawo ay ampakapilibri nin kapara. ");
INSERT INTO sbl_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Hay mangala-et ya tawtawo ay angka-apò nin ayin na-i-alalak, piro hay lipì nin mangahampat ya tawtawo ay ayin anggawan ya pangalalak. ");
INSERT INTO sbl_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Hay tawoy maronong ay amporiyen, piro hay tawoy tangah ay anyamo-yamo-en. ");
INSERT INTO sbl_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Mas mahampat ya tawoy ma-aypà ya kapapa-hal ya ampagsikap magtrabaho nin para ha kabiyayen na kisa magmamayaman ya ayin ma-ekan. ");
INSERT INTO sbl_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Hay tawoy mahampat ay an-asiwa-en nan mahampat ya aw-ayop na, piro hay tawtawoy mangala-et ay mabagsit ha aw-ayop la. ");
INSERT INTO sbl_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Hay mamaliyan ya ampagmalasakit magtrabaho ay ampagkama-in sapat ya pamamangan, piro hay anggomawà nin ayin kapararakan ay tangah. ");
INSERT INTO sbl_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Hay labaylabay nin mangala-et ya tawtawo ay manggawà nin bawbagay ya mangala-et maski tandà la ya habayto ay makahirà konla, piro hay tawtawoy mangahampat ay ampanatilin matibay ha kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Hay tawoy mala-et ay angkahagep ha sarili nan paghahalità, piro hay mahampat ya tawo ay angka-i-atap nay sarili na ha kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Hay pambin primyo ha tawo ay kompormi ha anhalita-en na boy ha anggaw-en na; tanggapen nay nararapat ya para kona. ");
INSERT INTO sbl_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Ha asa nin tawoy tangah ay tamà ya kaganawan anggaw-en na, piro hay tawtawoy mangaronong ay ampanlengè ha wawwawali. ");
INSERT INTO sbl_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Hay tawoy tangah ay tampol ampamakit nin pahang, piro hay tawoy matalino ay pinagka-ayin nay aw-insolto kona. ");
INSERT INTO sbl_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Hay tawoy ampagtotol nin kaptegan ay ampangipakit kahampatan, piro hay tawoy ampagbongkok ay alwan mahampat ya an-ipakit na. ");
INSERT INTO sbl_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Ma-in tawtawo ya makhit maghalità nin bilang ha hondang ya no makahogat ay malalè. Hay hawhalità nin tawtawoy mangaronong ay ampakapakahampat nin bilang ha tambal. ");
INSERT INTO sbl_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Hay kabongkokan ay ma-in anggawan, piro hay kaptegan ay manatili nin ayin angga. ");
INSERT INTO sbl_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Hay anti ha nakem nin tawtawoy ampagplano nin manggawà kala-etan ay panloloko, piro hay tawtawoy anggomawà nin para ikatinek ay ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Ayin mala-et ya mangyari ha tawtawoy mangahampat, piro hay tawtawoy mangala-et ay ayin tegen ya kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Hay Pangino-on ay ampag-inakit ha tawtawoy mangabongkok, piro ampangonsowilowan na ya tawtawoy mapteg. ");
INSERT INTO sbl_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Ahè an-ipagmalhay nin tawoy maronong ya tinandà na, piro hay tawoy tangah ay an-ipagmalhay nay katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Hay tawoy masikap ha trabaho ay ampag-in mihay mama-alà, piro hay tawoy matamlad ay ahè ampi-asinso no alwan pirmin ampatrabahowen nin mabyat. ");
INSERT INTO sbl_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Hay tawoy pirmin angkahlak ay alwan maliga, piro hay mahampat ya hawhalità ay ampakapakhaw nakem na. ");
INSERT INTO sbl_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Hay tawoy mahampat ay ampangitoto nin kapara nan tawo, piro hay tawoy mala-et ay ampitawon ha kala-etan na. ");
INSERT INTO sbl_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Ahè angkakwa nin matamlad ya tawo ya anhangaren na, piro hay mahipeg ya tawo ay ampagkama-in maganday kakalma-an. ");
INSERT INTO sbl_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Hay tawoy ma-in kahampatan ay ampagkama-in mahampat ya pamimiyay, piro hay kamali-an ay ampakapipalako nin tawo ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Hay anak ya maronong ay ampanlengè ha tawtorò nin tatay na, piro hay anak ya mapagmalhay ay ahè ampanlengè ha pawpanana-ad kona. ");
INSERT INTO sbl_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Hay mahampat ya tawo ay ampagkama-in nin primyo ha kawkahampatan ya anhalita-en na, piro hay tawoy pirmin mala-et ya ka-ihipan ay parosawan banà ha kala-etan nin pagnanakem na. ");
INSERT INTO sbl_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Hay tawoy mapi-aweng ha paghahalità ay angka-i-atap nay sarili na, piro hay tawoy ayin pi-aweng maghalità ay anhira-en nay sarili na. ");
INSERT INTO sbl_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Maski pangnoy paghangad nin matamlad ya tawo nin anyaman ya bagay ya labay na ay talagan agna makwa. Hay masikap magtrabaho ay makwa nay anyaman ya bagay ya labay na. ");
INSERT INTO sbl_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Hay mangahampat ya tawtawo ay angka-inakit ha kabongkokan, piro hay gawgawà nin mangala-et ya tawtawo ay kawkala-etan boy kawkakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Hay gawgawà ya mahampat ay ampakapi-atap nin tawoy tapat, piro hay ampakahirà nin tawoy makasalanan ay kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Ma-in tawoy ampagpanggap mayaman, piro ayin yan maski anyaman. Ma-in itaman tawoy ampagpanggap nin hiya ay ma-irap, piro hiya ay masyadon mayaman. ");
INSERT INTO sbl_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Hay tawoy mayaman ay ma-arì nan pambeh nin biyay na ya kayamanan na ha tawtawoy ampagplanon mamati kona, piro hay tawoy ma-irap ay ayin angkahalakan ya ombayro. ");
INSERT INTO sbl_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Hay tawtawoy mangahampat ay emen ha hawang ya masyadoy kahawangan, piro hay tawtawoy mangala-et ay emen ha kingki ya malaga maparè. ");
INSERT INTO sbl_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Ayin angkapakinabang ya tawoy mapagmalhay no alwan kagolowan, piro hay ampanlengè ha wawwawali ay ampagkama-in karonongan. ");
INSERT INTO sbl_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Hay kayamanan ya nakwa ha maparahan boy ahè pinaghayngetan ay tampol angka-alih ta ahè ampa-alaga-an, piro hay kayamanan ya nakwan amo-amò boy pinagpagalan ay lalò kapampopomahan. ");
INSERT INTO sbl_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","No ahè ampangyari ya an-asawan mo ay makhit ya nakem mo, piro no ampangyari ya anhangaren mo ay ampagkama-in kan masyadoy kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Hay ahè anhomonol ha mahampat ya wawali ay ampanikap kagolowan, piro hay anhomonol ay ampagkama-in pakinabang. ");
INSERT INTO sbl_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Hay tawtorò nin mangaronong ya tawtawo ay ampakab-in tambay nin bilang ha lanom ya ampangibat ha hobol. No honolen mo bayto, hay biyay mo ay marayò ha piligro. ");
INSERT INTO sbl_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Hay tawoy ma-in mahampat ya pangingintindi ay an-igalang, piro hay tawoy ahè mapahimala-an ay makatanam ka-irapan. ");
INSERT INTO sbl_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Hay tawoy maronong, biha na gaw-en ya gawà na ay an-ihipen na pon, piro hay tawoy tangah ay an-ipagparangkisa nay katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Hay alwan mahampat ya hogò ya mantan balità ay ampambin ikagolo nin tawtawo, piro hay mapahimala-an ya hogò ay ampakagawà nin ikatinek. ");
INSERT INTO sbl_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Ka-irapan boy kakareng-eyan ya mapakinabang nin tawoy ahè labay matoto, piro hay ampanlengè ha sisita ay an-igalang. ");
INSERT INTO sbl_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Hay tawo ay ampagtowà no hay anhangaren na ay angkatanggap na, piro hay tawtawoy tangah ay ahè labay mog-alih ha kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Patorò ka ha maronong ya tawo emen ka domonong, piro no makilamo ka ha tawoy tangah ay ampanikap kan ikahirà mo. ");
INSERT INTO sbl_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Hay makasalanan ay ma-in kagolowan maski ayri ya mako, piro hay tawoy mahampat ay ampagkama-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Hay tawoy mahampat ay ma-in angka-ipamana ha aw-apò na, piro hay kamama-in nin mawmakasalanan ay ampipalako ha tawtawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Hay paliyan ya bakanti, no natamnan ay makab-i nin malakè ya pamamangan ya para ha manga-irap, piro ahè labay ipatamnan nin tawtawoy alwan mangahampat ya kanakeman. ");
INSERT INTO sbl_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Hay tawoy ahè ampamarosa nin mandisiplina ha anak na ay agna anlabiyen ya anak na. Hay tawoy ampanlabi ha anak na ay talagan amparosawan nan disiplinawan ya anak na. ");
INSERT INTO sbl_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Hay tawtawoy mangahampat ay ahè angkabitlan ta ma-in sapat ya pamamangan, piro hay tawtawoy mangala-et ay pirmin mabitil ta ampagkakolang ha pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Hay babayi ya maronong ay an-asikasowen nan ayosen ya pamamali na, piro hay pamamali nin babayi ya tangah ay angkahirà banà ha kagagaw-an na. ");
INSERT INTO sbl_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Hay tapat ya tawo ay an-ipatnag nay panggogomalang na ha Pangino-on, piro hay tawoy alwan tapat ay an-ipatnag na ya hay Pangino-on ay agna an-igalang. ");
INSERT INTO sbl_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Hay hawhalità ya an-ipagmalhay nin tawoy tangah ay emen garoti ya andompà ha bokot na, piro hay hawhalità nin tawoy mahampat ay ampakapi-atap kona. ");
INSERT INTO sbl_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","No ayin ayop ya manggoloy araro ay agka maka-alawah nin malakè ya pali, piro banà ha tambay nin aw-ayop ay maka-alawah kan malakè. ");
INSERT INTO sbl_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Hay tapat ya tawoy ampamapteg ay pirmin ampagtotol kaptegan, piro hay tawoy alwan tapat ha pamapteg, hay antotolen na ay poro kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Hay tawoy mapanoya-toyà ay ahè magkama-in karonongan, piro hay tawoy ma-in pangingintindi ay tampol angkatoto. ");
INSERT INTO sbl_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Pakarayò ka ha tawoy tangah ta ayin kan matotowan kona. ");
INSERT INTO sbl_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Hay maronong ya tawo ay tandà nay anggaw-en na, piro hay tawoy tangah, hay malì ya tandà na ay ampakapitawon kona. ");
INSERT INTO sbl_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Hay tawtawoy tangah ay ayin kowinta konla ya pagkasalanan la, piro hay tawtawoy mangahampat ay an-ipakikwa lan tawad ya kawkasalanan ya nagawà la. ");
INSERT INTO sbl_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Ayin makapaki-atag nin kaligawan o kalele-an ya ma-in komo. ");
INSERT INTO sbl_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Hay bali nin tawoy mala-et ay tampol mahirà, piro hay bali nin tawoy mahampat ay manatili. ");
INSERT INTO sbl_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Ma-in daan ya an-ipalagay nin tawo nin habayto ay tamà, piro ha ka-anggawan nin habayto ay kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Hay kalele-an nin tawo ay ma-arì nan itagò ha pangka-ili na, piro pangayarì nin habaytoy ka-ili ay anti et konay kalele-an na. ");
INSERT INTO sbl_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Hay matanggap nin tawtawoy mangala-et ay kompormi ha gawgawà la, piro hay tawtawoy mangahampat, banà ha kahampatan nin gawgawà la ay kahampatan ya tanggapen la. ");
INSERT INTO sbl_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Hay tawoy tangah, kaganawan angkalengè na ay ampinto-owen na, piro hay tawoy maronong ay ampag-aralan na pon no ma-in kaptegan ya angkalengè na. ");
INSERT INTO sbl_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Hay tawoy maronong ay an-i-atap nay sarili na ha kagolowan, piro hay tawoy tangah ay ahè ampag-atap boy pabigla-biglà. ");
INSERT INTO sbl_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Hay tawoy maparan mag-amot olo ay tangah, boy hay tawoy ampagplano nin kala-etan ay angka-inakitan. ");
INSERT INTO sbl_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Hay matanggap nin tawtawoy tangah ay kompormi ha katangahan la, piro ha tawtawoy mangaronong, banà ha karonongan la ay angkapahanan ya tinandà la. ");
INSERT INTO sbl_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Hay tawtawoy mangala-et ay anyomokò boy ampaki-i-ingalo ha tawtawoy mangahampat. ");
INSERT INTO sbl_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Hay tawtawoy manga-irap ay ahè ampa-alaga-an nin kapara lan tawo, piro hay mangayaman ay malakè ya amigo. ");
INSERT INTO sbl_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Hinoman ya ampanyamo-yamò nin kapara nan tawo ay ampagkasalanan, piro hinoman ya ampangingangalo ha manga-irap, hiya ay maliga. ");
INSERT INTO sbl_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Hika ay pahimala-an boy igalang nin tawtawo no hay gawgawà mo ay mahampat, piro no hika ay ampagplano nin kala-etan, hay anggaw-en mo ay kamali-an. ");
INSERT INTO sbl_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Magtrabaho ka emen ka magkama-in ikabiyay ta no kapagkokowinto mon bongat, hay biyay mo ay kapan-o-omirap. ");
INSERT INTO sbl_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Hay karangalan nin tawtawoy mangaronong ay karonongan la, piro hay tawtawoy tangah ay balaybalay ha katangahan la. ");
INSERT INTO sbl_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Hay ampamapteg ya ampaghalità nin kaptegan ay ampakapilibri nin tawtawo ha kamatyan, piro no hay anhalita-en na ay kabongkokan, hiya ay ampangitraydor nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Hay tawoy anggomalang ha Pangino-on kateng pamilya na ay ampagkama-in makhaw ya pamahimalà ha Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Hay panggomalang ha Pangino-on ay ampakab-in tambay nin bilang ha lanom ya ampangibat ha hobol. No gaw-en mo bayto, hay biyay mo ay marayò ha piligro. ");
INSERT INTO sbl_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Banà ha kalak-an tawoy ampag-ari-an nin arì, hiya ay ma-in karangalan. No ayin nin tawtawo ay ayin kowinta ya pag-arì na. ");
INSERT INTO sbl_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Hay tawoy ma-in mahampat ya pangingintindi ay ahè tampol ampamahang, piro hay tawoy maparan mag-amot olo ay an-ipakit nay katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Hay katinekan pagnanakem ay ampakab-in kalighawan, piro hay inggit ay emen ha masakit nin bot-o ya ahè matambal. ");
INSERT INTO sbl_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","No padya-dya-an moy tawtawoy manga-irap ay emen mon an-insoltowen ya Diyos ya namalsa konla, piro no ampanambay ka ha manga-irap ay emen kan ampambin dangal ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Hay ampakahirà nin mangala-et ya tawtawo ay kala-etan nin gawgawà la, piro hay tawtawoy mangahampat, hay ampakapi-atap konla ay kahampatan la. ");
INSERT INTO sbl_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Hay karonongan ay ampanatili ha nakem nin tawoy ma-in pangingintindi, piro hay tawtawoy tangah ay ayin tandà ya tongkol ha karonongan. ");
INSERT INTO sbl_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Banà ha kahampatan gawgawà nin tawtawo, hay nasyon ay ampibantog, piro banà ha kasalanan ya anggaw-en nin tawtawo, hay nasyon ay ampagkama-in kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Hay arì ay ampangonsowilo ha ampipamo-on ya ma-in karonongan, piro ampamahangan nay ahè ampipanhomonol kona. ");
INSERT INTO sbl_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Hay mapanawah ya tobay ay ampaka-alin pahang, piro hay mahngah ya tobay ay ampakapapahang. ");
INSERT INTO sbl_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","No ampaghalità ya tawoy maronong ay anggamiten nay karonongan na, piro hay anhalita-en nin tawoy tangah ay ayin labay totolen. ");
INSERT INTO sbl_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Hay ampangyari ha maski ayri ay angkakit nin Pangino-on; mahampat man o mala-et ya tawo, hay anggaw-en la ay angkakit na. ");
INSERT INTO sbl_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Hay maganday halità ay ampakapaligha, piro hay halità ya makhit ay ampakablò nakem. ");
INSERT INTO sbl_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Hay tawoy tangah ay ahè ampanlengè ha an-itorò kona nin tatay na, piro hay tawoy maronong ay ampa-alaga-an na ya korihir kona nin tatay na. ");
INSERT INTO sbl_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Hay tawtawoy mangahampat ay bastanti ya kamama-in, piro hay angkapakinabang nin tawtawoy mangala-et ay kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Hay mangaronong ya tawtawo ay ampakab-i nin tinandà, piro hay tawtawoy tangah ay ayin angka-igwà ya ombayro. ");
INSERT INTO sbl_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Hay an-idolog ha Pangino-on nin tawtawoy mangala-et ay angka-inakitan nin Pangino-on, piro hay panalangin nin tawtawoy mangahampat ay ampambin konsowilo kona. ");
INSERT INTO sbl_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Hay Pangino-on ay angka-inakit ha gawgawà nin tawtawoy ma-in kala-etan, piro anlabiyen nay tawtawoy ampagsikap nin magkama-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","No manggawà kan alwan tamà ay mabyat ya iparosa komo; no agmo labay manlengè ha torò ay ampanikap kan kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","No tandà nin Pangino-on no anyay anti ha dogal nin nikati ay lalò nan tandà no anyay anti ha nakem nin tawo. ");
INSERT INTO sbl_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Hay tawoy mapanoya-toyà ay ahè labay patorò, boy agna labay ya wawali nin tawoy maronong. ");
INSERT INTO sbl_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Hay tawoy maliga ay makit moy kaligawan ha lopa na, piro hay tawoy malelè ay kalele-an ya makit ha lopa na. ");
INSERT INTO sbl_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Hay tawoy ma-in pangingintindi ay labay matoto, piro hay tawoy tangah ay kontinto ha katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Hay tawoy ma-irap ay pirmin angkahlak, piro hay tawoy maliga ay pirmin ampagkama-in kaligawan ha biyay na. ");
INSERT INTO sbl_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Mas mahampat ya kapapa-hal nin tawoy ma-irap ya anggomalang ha Pangino-on kisa kapapa-hal nin mayaman ya magolo. ");
INSERT INTO sbl_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Maski golay bongat ya ikakan, no hay ampi-a-arap mangan ay ampilalabi ay mas mahampat kisa karnin bakà ya angkona-en no hay ampi-a-arap mangan ay ampi-i-inakitan. ");
INSERT INTO sbl_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Hay tawoy ma-amot ya olo ay maparan maki-away, piro hay tawoy mapasinsya ay ampamisondò nin ampi-away. ");
INSERT INTO sbl_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Hay matamlad, maski ayri mako ay magdanas kadya-dya-an, piro hay tawoy tapat ay mapalindaway. ");
INSERT INTO sbl_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Hay anak ya maronong ay ampakapaliga nin tatay, piro hay anak ya tangah ay ampandodostà nin nanay na. ");
INSERT INTO sbl_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Hay tawoy tangah ay an-ikaliga nay katangahan na, piro hay tawoy ma-in pangingintindi, hay anggaw-en na ay matoynong. ");
INSERT INTO sbl_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Hay tawoy ahè ampanlengè ha wawali ay ayin malateng, piro hay tawoy ampanlengè ha wawali ay mangyari ya anhangaren na. ");
INSERT INTO sbl_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Maligay tawo no hay hinalità na ay tamà boy tamà ha pinanggamitan. ");
INSERT INTO sbl_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Hay kowinta ampagdanan nin tawtawoy mangaronong ay daan ya palako ha biyay ya ayin anggawan, alwan ha daan ya palako ha kamatyan ya kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Hay bali nin mapagmalhay ya tawo ay anhira-en nin Pangino-on, piro hay pi-anggawan nin lotà nin bawoy babayi ay ambiyan nan protiksyon. ");
INSERT INTO sbl_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Hay mala-et ya pangingihip nin tawtawoy mangala-et ay angka-inakitan nin Pangino-on, piro ampangonsowilowan nay hawhalità nin tawtawoy mangahampat ya kanakeman. ");
INSERT INTO sbl_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Hay maha-ol, kateng pamilya na ay ambiyan nan kagolowan, piro hay ahè ampasohol ay ambomoyot ya biyay. ");
INSERT INTO sbl_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Hay mahampat ya tawo ay an-ihipen na pon no anyay itobay na. Balè hay mala-et ya tawo ay tampol antombay, piro hay an-itobay na ay ampambin kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Hay panalangin nin mangahampat ya tawtawo ay anleng-en nin Pangino-on, piro ha mangala-et ya tawtawo ay ampakarayò ya. ");
INSERT INTO sbl_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","No hay lopan ka-ilgo mo ay maliga ay lomiga ka, boy no mahampat ya balità ya angkalengè mo ay lomigha ka simpri. ");
INSERT INTO sbl_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","No pinto-owen mo ya an-isita komo, hika ay mag-in maronong. ");
INSERT INTO sbl_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","No agmo labay patorò ay emen mon andodosta-en ya sarili mo, piro no tanggapen moy an-isita komo ay mag-in kan maronong. ");
INSERT INTO sbl_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Hay panggogomalang ha Pangino-on ay ampambin karonongan. Ka-ilangan magmaka-aypà ka pon biha ka magkama-in karangalan. ");
INSERT INTO sbl_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Hay tawo ay ampakapagplano ha ihip na, piro ayin yan magawà no agya aboloyan Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Kaganawan anggaw-en nin tawo ay an-ihipen nan tamà, piro Pangino-on ya magtandà no anyay annakemen na. ");
INSERT INTO sbl_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Ipahimalà mo ha Pangino-on ya kaganawan anggaw-en mo emen hay plano mo ay magkama-in katoparan. ");
INSERT INTO sbl_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Kaganawan bagay ay pinalsa nin Pangino-on nin ma-in plano. Hay nararapat ha tawtawoy mangala-et ay mipalako ha kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Hay Pangino-on ay angka-inakit ha tawtawoy mapagmalhay; hila ay sigoradon mipalako ha kaparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Pakatibolosen moy nakem mo ha Pangino-on boy pakatapat ka kona emen na patawaren ya kasalanan mo. Igalang moy Pangino-on emen ayin kala-etan ya mangyari komo. ");
INSERT INTO sbl_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","No hay gawgawà nin tawo ay ampambin konsowilo ha Pangino-on, hay kawka-away nin habaytoy tawo ay ipakisondò nin Pangino-on kona. ");
INSERT INTO sbl_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Mas mahampat ya amò ya natikapan no nakwa ha mahampat ya paraan kisa magkama-in malakè ya kayamanan no nakwa ha alwan mahampat ya paraan. ");
INSERT INTO sbl_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Hay tawo ay ampakapagplano nin gaw-en na, piro Pangino-on ya ampangitoto kona. ");
INSERT INTO sbl_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Ha tambay nin Diyos ha arì ay ampag-in tamà ya panonosga nin arì. ");
INSERT INTO sbl_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Labay nin Pangino-on ya hay tawtitimbangan boy hawhohokatan ya anggamiten nin maglalakò ay ayin ha-ol. ");
INSERT INTO sbl_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Hay arì ay ahè labay manggawà kala-etan ta hay pinagkapondasyon nin pamomo-on na ay kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Hay labay leng-en nin arì ay kaptegan, boy hay tawoy ampaghalità nin kaptegan ay anlabiyen na. ");
INSERT INTO sbl_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Hay maronong ya tawo ay ampagsikap nin mamaliga nin arì ta no mamahang ya arì ay ampamati. ");
INSERT INTO sbl_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","No ampangonsowiloy arì, hay biyay nin tawtawoy angkasakopan na ay anlomiga. Habayti ay emen ha leem ya ampambin oran ya ampamabiyay nin tawtanaman. ");
INSERT INTO sbl_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Mas mahampat ya magkama-in pangingintindi boy karonongan kisa magkama-in gintò boy pilak. ");
INSERT INTO sbl_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Hay tawtawoy ma-in kahampatan ay ampa-alilih ha kala-etan; hinoman ya tawoy ampanggawà nin ombayro ay angka-i-atap nay biyay na. ");
INSERT INTO sbl_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Hay ampag-in bonga nin kahambogan ay kahira-an; ombayro simpri ha mapagmalhay. ");
INSERT INTO sbl_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Mas mahampat makilamo ha tawtawoy ma-irap ya ma-in manga-aypà ya nakem kisa maki-atag ha bawbagay ya nakwa nin tawtawoy mapagmalhay ha alwan mahampat ya paraan. ");
INSERT INTO sbl_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Etpanan moy natotowan mo ha Halità nin Diyos emen ka magkama-in kahampatan; pahimalà ka ha Pangino-on emen ka magkama-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Hay tawoy ma-in karonongan ay angkabalayan ha pangingintindi na. Hay aw-ilgo na ay ampaka-ingganyo nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Hay karonongan nin tawoy maronong ay emen ha hobol ya ampambin biyay kona, piro hay tawoy tangah ay ayin kowinta kona ya tawtorò kona. ");
INSERT INTO sbl_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Hay tawoy maronong ay an-ihipen na pon no anyay dapat nan halita-en, boy hay hawhalità na ay ampaka-ingganyo. ");
INSERT INTO sbl_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Hay mahampat ya hawhalità ay emen ha matam-ih ya polot ya ampakapalighan nawini. ");
INSERT INTO sbl_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Ma-in daan ya an-ipalagay nin tawo nin habayto ay tamà, piro hay ka-anggawan nin habayto ay kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Hay trabahdor ay ampagsikap magtrabaho emen agya mabitlan. ");
INSERT INTO sbl_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Hay tawoy mala-et ay ampanikap paraan no pangno na mahirà ya kapara na. Hay aw-ilgo na ay ampakahirà nin emen ha apoy ya ampakapo-ol. ");
INSERT INTO sbl_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Hay tawoy mala-et ay ampamihihirà; hay tawoy madaldal ay ampakahirà nin pami-a-amigo. ");
INSERT INTO sbl_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Hay mapanggolo ay magaling manaktika; kayà ampakagtan yan kapara na nin manggawà nin alwan mahampat. ");
INSERT INTO sbl_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Mag-atap ka ha tawtawoy kanwarì ay mahampat ya tegteg la komo, balè ta hay labay lan gaw-en komo ay kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Hay pinagkaprimyo nin mahampat ya tawo ay makarà ya biyay; hay oban na ay pinagkadangal na. ");
INSERT INTO sbl_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Mas mahampat ya tawoy alwan mapapahangen kisa tawoy ma-in kapangyariyan, boy mas mahampat ya tawoy mapagpendan ha sarili kisa tawoy makapag-ikon nin mihay siyodad. ");
INSERT INTO sbl_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Maski anyay gaw-en nin tawtawo emen la matanda-an no anyay dapat lan gaw-en, Diyos bongat ya makapagdisisyon. ");
INSERT INTO sbl_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Mas mahampat ya mangan nin maski anyay pamamangan ya naba-aw basta ma-in katinekan kisa makipangan ha malhay ya handa-an ha bali ya ma-in kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Hay maronong ya alilà ay ampagkama-in karapatan nin mamo-on ha ayin kowintay anak nin amo na, boy ma-arì yan magkama-in parti ha mamanawen nin mipapatel. ");
INSERT INTO sbl_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Hay pilak boy gintò ay anhoboken ha apoy; hay nakem itaman nin tawo ay anhoboken nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Hay tawoy mala-et ay ampanlengè ha anhalita-en nin kapara nan mala-et. Hay mabongkok itaman ay ampanlengè ha ma-alay ya halità. ");
INSERT INTO sbl_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","No ampanoya-toyà ka nin tawtawoy manga-irap ay an-insoltowen moy Diyos ya namalsa konla, boy hay tawoy angkatowà ha alwan maganday nangyari ha kanayon ay amparosawan. ");
INSERT INTO sbl_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Hay aw-apò ay an-ipagparangalan nin pawpapò la; hay aw-anak itaman ay an-ipagparangalan lay tawtatay la. ");
INSERT INTO sbl_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Hay maganday paghahalità ay alwan bagay ha tawoy tangah; lalò alwan bagay ha ampamo-on ya magbongkok. ");
INSERT INTO sbl_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Ha asa nin tawo, hay sohol ay emen ha ma-alagà ya bato ya ampakagayoma ha tawoy ampasohol ta maski ayri ya parapit, hiya ay ampakinabang. ");
INSERT INTO sbl_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Hay labay nin ampamatawad ha kamali-an nin kapara ay pamilalabi, piro no idaldal na baytoy kamali-an ay ampanirà ya nin pami-a-amigo. ");
INSERT INTO sbl_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Hay tawoy ma-in pangingintindi ay mas angkatoto maski miminghan ha-aren kisa tawoy tangah ya maski magatoy bisis nin barogen ay ahè angkatoto. ");
INSERT INTO sbl_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Hay mala-et ya tawo ay ampagribildi; kayà ma-in ihogò nin mamarosa kona. ");
INSERT INTO sbl_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Mahampat et ya makahakbat nin mihay ayop ya oso ya hay aw-anak na ay inayo kona kisa makahakbat nin mihay tangah ya an-ipakit nay katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Hinoman ya ampanggantin kala-etan ha kahampatan, hay kala-etan ay ahè ma-alih ha pamamali na. ");
INSERT INTO sbl_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Hay away ya na-ompisawan ay ayin imbalag ha dawey nin lanom ya angka-ibat ha diposito ya nalobtan; kayà emen ahè lomagot ay itegen ya pami-a-away. ");
INSERT INTO sbl_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Hay manonosga ya mangilibri nin tawoy nagkasalanan emen ahè maparosawan, boy hay manonosga ya mambin kaparosawan ha tawoy ayin kasalanan ay parihon angka-inakitan nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Ayin kowintan paggastosan ha pag-a-aral ya tawoy tangah ta talagan ahè mipalaman ha nakem na ya an-itorò kona. ");
INSERT INTO sbl_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Hay amigo ay pirmin ampanlabi; hay patel itaman ay ampakiramay ha patel na ya ampagdanas nin kadya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Hay tawoy ayin pangingintindi ay ampagpangakò boy ampaggarantiya ha otang nin kanayon ya tawo. ");
INSERT INTO sbl_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Hay tawoy labaylabay ya kasalanan ay labaylabay ya kagolowan, boy hay tawoy mahambog ay ampanikap kahira-an. ");
INSERT INTO sbl_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Hay tawoy ampangihip nin kala-etan ay ayin ma-antì ya kahampatan, boy hay tawoy ampaghalità nin ma-alay ya halità ay ampag-in alwan maganday kakalma-an. ");
INSERT INTO sbl_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Ahè ampagkama-in kaligawan ya mawmato-antawo nin anak ya tangah. ");
INSERT INTO sbl_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Hay tawoy maligay kanakeman ay pirmin maligha, piro hay ampagkonsimisyon, hay nawini na ay kapanlolomaya. ");
INSERT INTO sbl_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Hay mala-et ya manonosga ay angkasoholan; kayà hay ampangyari ay ahè ampagkama-in katoynongan. ");
INSERT INTO sbl_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Hay tawoy ampaka-intindi ay ampanikap karonongan, piro hay tawoy tangah, hay ihip na ay ayin kinapirmiyan. ");
INSERT INTO sbl_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Hay anak ya tangah ay ampambin kalele-an ha tatay na, boy an-ikalelè nin nanay na ya pangi-anak kona. ");
INSERT INTO sbl_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Alwan tamà nin hay tawoy mahampat ay parosawan, boy alwan tamà nin pa-irapan ya tawoy marangal. ");
INSERT INTO sbl_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Hay tawoy ma-in tinandà ay alwan matlek; hay tawoy ampaka-intindi ay ma-amey ya nakem. ");
INSERT INTO sbl_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Hay tawoy tangah ay angka-ibilang nin maronong boy matalino no hiya ay alwan matlek. ");
INSERT INTO sbl_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Hay tawoy mapagsarili ay ikon naynay ikon na, boy pirmi yan kontra ha tamà ya an-ipalagay nin kaganawan. ");
INSERT INTO sbl_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Ayin kowinta ha tawoy tangah no hiya man ay ayin pangingintindi; hay labay nan bongat ay ma-ipakit na no pangno ya kagaling. ");
INSERT INTO sbl_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Hay tawoy ma-in kala-etan ay angka-inakit ha kahampatan. Panay kakareng-eyan ya ampangyari ha tawoy ahè ampambin dangal ha sarili. ");
INSERT INTO sbl_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Hay anhalita-en nin tawoy maronong ay maldeg ya labay totolen nin bilang ha malalè ya lanom; hay karonongan na ay anlomwah nin emen ha lanom ya ampangibat ha hobol. ");
INSERT INTO sbl_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Alwan tamà nin kampiyan ya tawoy nanggawà nin kala-etan, ta hay ayin kasalanan ay hosgawan. ");
INSERT INTO sbl_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Hay anhalita-en nin tawoy tangah ay ampakab-in kagolowan, boy ampangibatan nin hiya ay pakakhitan. ");
INSERT INTO sbl_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Hay ampakahirà ha tawoy tangah ay mismon anhalita-en na, boy habayto ya ampakahagpan kona. ");
INSERT INTO sbl_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Hay pangidaldal ay maganan leng-en nin tawtawo ta para konla ay emen malahap ya pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Hay tawoy matamlad ay patel nin tawoy mapanirà. ");
INSERT INTO sbl_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Hay ngalan nin Pangino-on Diyos ay bilang ha matibay ya kobliyan; bayro ay ma-arì pa-ikobli ya mahampat ya tawo emen ya malibri. ");
INSERT INTO sbl_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Ha asa nin tawoy mayaman ay ma-ilibri ya nin kayamanan na nin bilang ha mihay siyodad ya napalibotan nin matag-ay ya padir. ");
INSERT INTO sbl_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Hay tawoy mapagmalhay ay hiyan mismo ya ampanirà nin pagkatawo na, piro hay tawoy mapagmaka-aypà ay ampagkama-in karangalan. ");
INSERT INTO sbl_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Hay tawoy antombay ya agna pon an-intindiyen ya pastang kona ay tangah boy ampipareng-ey. ");
INSERT INTO sbl_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Hay kakhawan nakem ay ampakatambay ha tawoy ma-in angkatanam, piro hay makapey ya nakem ay angka-alihan nin pag-asa. ");
INSERT INTO sbl_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Hay tawtawoy mangatalino ay ampagsikap nin mapahanan ya tinandà la. ");
INSERT INTO sbl_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","No labay mon mabalayan ka nin tawoy ma-in matag-ay ya pagkatawo ay mambi ka kona nin rigalo. ");
INSERT INTO sbl_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Hay tawoy onan naghalità ha hosgado, hay hinalità na ay andap mo no tamà anggan hay kalaban na ay ahè et ampagpastang kona. ");
INSERT INTO sbl_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Hay makapategen ha ampi-away ya parihon ma-in pakakaya ay palabonotan. ");
INSERT INTO sbl_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Hay patel ya nakhitan ya nakem ay mas ma-irap mi-orong ya dati kisa mapag-ikon ya mihay makhaw ya siyodad; talagan hay ampi-away ay ma-irap mapisondò. ");
INSERT INTO sbl_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Ayin kanayon ya tombay ha anhalita-en mo no alwan mismon sarili mo. ");
INSERT INTO sbl_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Hay anhalita-en mo ay ma-arì makab-in kamatyan mo o makapilibri nin biyay mo; ka-ilangan tanggapen mo ya mag-in bonga nin anhalita-en mo. ");
INSERT INTO sbl_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Hinoman ya lalaki ya magkama-in ahawa ay mahampat ta habayto ay polalag kona nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Hay paghahalità nin ma-irap ya tawo ay emen ampaki-i-ingalo, piro hay mayaman, no tombay ay mapalalngat. ");
INSERT INTO sbl_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Ma-in mita-amigo ya angkapihirà piro ma-in amigo ya mas et ha patel. ");
INSERT INTO sbl_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Mas mahampat ya tawoy ma-irap ya ampamiyay nin tapat kisa tawoy mayaman ya ampaghalità kabongkokan boy ma-in katangahan. ");
INSERT INTO sbl_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Alwan mahampat ha tawo ya ayin tinandà. Hay tawo itaman ya sobray pag-aporah ay ma-arì makapagkasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Ma-in tawo ya hiyan mismo ya ampanirà nin sarili na ha katangahan na, biha na ihehe ha Pangino-on Diyos. ");
INSERT INTO sbl_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Hay tawoy mayaman ay ampagkama-in nin malakè ya amigo, piro hay tawoy ma-irap ay ampakarayo-an nin aw-amigo na. ");
INSERT INTO sbl_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Hay ampanistigos nin alwan peteg ay angkaparosawan; ombayro simpri ha ampaghalità nin kabongkokan. ");
INSERT INTO sbl_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Malakè ya ampagsikap nin mag-in maheneh ha tawoy mabibi-iyen, boy kaganawan ay ampaki-amigo ha mapagrigalo. ");
INSERT INTO sbl_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Hay tawoy ma-irap ay ahè ampabliyen nin pawpatel na; kayà kateng aw-amigo na ay ampakarayò kona. Maski pangnoy pagsikap nan pakarani konla ay ampakarayo-an la ya. ");
INSERT INTO sbl_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Imalasakit moy sarili mo ha pagsikap mon matoto; etpanan moy natotowan mo emen ka mag-inomay. ");
INSERT INTO sbl_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Hay ampanistigos nin alwan peteg ay angkaparosawan, boy hay ampaghalità nin kabongkokan ay alwan maganday pi-ogotan. ");
INSERT INTO sbl_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Hay ma-inomay ya pagbibiyay ay alwan bagay ha tawoy tangah, boy hay alilà ay alwan bagay mamo-on ha mangarangal. ");
INSERT INTO sbl_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Hay tawoy ma-in pangingintindi ay ahè antimanon ampamahang; no ma-in nakagawà kona nin kamali-an, hay mahampat ay pa-olayan nayna. ");
INSERT INTO sbl_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Hay pahang nin arì ay emen tonoy liyon ya ampamayani; piro hay panlalabi na ay pagkahampat nin emen ha amog ya ampakapalambot nin dawdikot. ");
INSERT INTO sbl_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Hay anak ya tangah ay ampambin ikahirà nin tatay na; boy hay ahaway babayi ya pirmin ampagriklamo ay ayin imbalag ha ampakasoray tonoy nin tolò lanom ya sigisigi ha pantolò. ");
INSERT INTO sbl_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Hay mawmato-antawo ay makapipamana ha anak lay lalaki nin bali boy kayamanan; piro Pangino-on ya makab-i kona nin ahawa ya ma-in pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Hay tawoy matamlad ya kapangakatoloy ay mabitlan. ");
INSERT INTO sbl_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Hay tawoy anhomonol ha an-ipanogò nin Diyos ay angka-i-atap nay biyay na, piro hay tawoy angka-inakit ha pawpanogò ay marani ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Hay tawoy ampaka-ingalo nin tawoy ma-irap ay emen yan nama-otang ha Pangino-on Diyos, ta Pangino-on ya gomanti kona nin kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Disiplinawan moy aw-anak mo mintras malagò hila et boy ma-in ka et nin pag-asan madisiplinawan hila, ta no ahè ay emen mo hilan an-i-akay ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Hay dapat gaw-en ha tawoy maparan mag-amot olo ay pa-olayan maski anyay mangyari kona, ta no tambayan mo ya, hiya ay malomawan boy ka-ilangan moyna et gaw-en oman ya panambay mo kona. ");
INSERT INTO sbl_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Manlengè kan wawwawali boy tanggapen moy tawtorò emen ka mag-in maronong ha hoyot ya allo. ");
INSERT INTO sbl_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Malakè ya amplanowen nin tawo piro kalabayan nin Pangino-on ya mangyari. ");
INSERT INTO sbl_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Hay nararapat ha tawo ay mag-in tapat. Hay ma-irap ya tawo ay mas mahampat kisa mabongkok. ");
INSERT INTO sbl_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Hay panggogomalang ha Pangino-on ay ampakapakarà biyay, ampakapaliga, boy ampakapilibri ha kadisgrasyawan. ");
INSERT INTO sbl_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Hay tawoy matamlad, ha katamlaran na, maski ihohobò nayna ay agna et magawà dampoten. ");
INSERT INTO sbl_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Hay dapat ha tawoy mapanoya-toyà ay parosawan emen mag-in aral ha tawtawoy ayin pangingintindi. Hay tawoy ma-in pangingintindi ay angkatoto no hiya ay an-itorò. ");
INSERT INTO sbl_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Hay anak ya anlomaban ha tatay boy ampangipataboy nin nanay ay mala-et boy ampambin kakareng-eyan. ");
INSERT INTO sbl_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Anak koy lalaki, no agka manlengè ha pangaral komo ay mapa-olayan mo ya tinandà mo. ");
INSERT INTO sbl_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Hay ayin kowintay tistigos ay ahè ampagtotol kaptegan ta agna ampa-alaga-an ya katoynongan. Hay tawtawo itaman ya mangala-et ay hay ganan manggawà kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Hay tawtawoy mapanoya-toyà ay parosawan; hay tawtawo itaman ya tangah ay babarog ya pamarosa. ");
INSERT INTO sbl_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Hay tawoy masyadon minom nin alak ay ampag-in bastos boy mapanggolo. Hinoman ya ampaglahing ay alwan maronong. ");
INSERT INTO sbl_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Hay pahang nin arì ay emen tonoy liyon ya ampamayani; hinoman ya ampamapahang nin arì ay emen nan an-aporawen ya biyay na. ");
INSERT INTO sbl_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Hay tawoy ampa-alilih ha kagolowan ay ma-in karangalan, piro hay tawoy tangah ay ampagpilit maki-away. ");
INSERT INTO sbl_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Hay mamaliyan ya matamlad mangararo nin paliyan na ha tamà ya pana-on ay ampakilimoh ta ayin na-alawah. ");
INSERT INTO sbl_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Hay pangingihip nin tawo ay emen ha lanom ya anti ha malalè ya libon, piro hay tawoy ma-in pangingintindi ay an-ipapabokà nay an-ihipen nin hatoy tawo. ");
INSERT INTO sbl_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Malakè ya tawoy ampaghalità nin hila ay tapat, piro ma-irap kan makakit nin mapahimala-an. ");
INSERT INTO sbl_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","No hay tatay ay tapat, boy no hay anggaw-en na ay kahampatan, hay aw-anak na ay makalmà. ");
INSERT INTO sbl_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Hay arì, no ampiknò ya ha trono na nin manosga ay angkakit na no hino ya mala-et. ");
INSERT INTO sbl_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Ma-in warì makapaghalità nin talagan hay nakem na ay malinis boy hiya ay ayin kasalanan? ");
INSERT INTO sbl_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Hay Pangino-on ay angka-inakit ha anggaw-en nin tawoy ampanggamit titimbangan boy hohokat ya ma-in ha-ol. ");
INSERT INTO sbl_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Maski anak ay mabalayan moy klasi na ha gawgawà na no hay ampag-ogali-en na ay mahampat boy tamà. ");
INSERT INTO sbl_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Hay Diyos ay nambi kontamo nin mata ya gamiten tamo emen tamo makakit, boy binyan na tamo et nin tolih ya gamiten tamo emen tamo makalengè. ");
INSERT INTO sbl_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","No kapangakatoloy mo ay magdanas kan ka-irapan; piro no pakahipeg kan magtrabaho ay magkama-in ka nin malakè ya pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","Hay mawmananaliw ay pirmin ampagriklamo ha kabliyan nin tawtinda, piro no nakatawad hila boy no amporong hilayna ay ampaghambog hila. ");
INSERT INTO sbl_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Ma-alagà ya gintò boy malakè ya alahas, piro mas ma-alagà ya anhalita-en nin tawoy ma-in tinandà. ");
INSERT INTO sbl_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Hinoman ya ampagpangakò nin mamayad otang nin tawoy alwa nan kabalay, hay dapat do ha ampagpangakò ay kowen ya kamama-in na bilang garantiya ha pangakò na. ");
INSERT INTO sbl_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Hay pamamangan ya nakwa mo ha pana-ol ay ampagganawan mon kanen, piro ayin kowinta ta emen kan bongat ampangihobò kapati-an. ");
INSERT INTO sbl_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Dapat kan manlengè ha wawali komo emen ka manalo ha labanan ya amplanowen mo. ");
INSERT INTO sbl_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Hay madaldal ay ahè masikritowan; kayà agka makilamo ha tawoy madaldal. ");
INSERT INTO sbl_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Hinoman ya ampaghalità nin mala-et ha mawmato-antawo na, hay biyay na ay bilang ha kingki ya naparè ya anti ha karegleman. ");
INSERT INTO sbl_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Hay mana ya nakwa ha alwan mahampat ya pamamaraan ay ahè makab-in ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Agka mangganti ha nanggawà nin kala-etan komo, no alwan ipahimalà mo ha Pangino-on ta hiya ya ba-alà komo. ");
INSERT INTO sbl_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Hay Pangino-on ay angka-inakit ha anggaw-en nin tawoy ampanggamit nin titimbangan boy hohokat ya ma-in ha-ol. ");
INSERT INTO sbl_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Pangino-on ya ampagplano no anyay mangyari ha biyay nin tawo; kayà alwa naynan ka-ilangan ihipen no anyay mangyari kona ta agna et bongat ma-intindiyan. ");
INSERT INTO sbl_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Ihipen mo pon nin mahampat biha ka magpangakò nin mambi ha Pangino-on ta maka ha bandan hoyot ay agmo matopad. ");
INSERT INTO sbl_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Hay maronong ya arì ay ansori-en na pon no hinoy ampanggawà mala-et biha na parosawan nin ayin ingangalo. ");
INSERT INTO sbl_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Pangino-on ya nambin pangingihip boy konsinsya kontamo; kayà agtamo ma-itagò ya sarili tamo kona. ");
INSERT INTO sbl_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Hay pamomo-on nin arì ay manatili no hiya ay tapat boy parihoy tegteg ha kaganawan angkasakopan na. ");
INSERT INTO sbl_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Hay karangalan nin mangalagò ay kakhawan la; hay karangalan itaman nin mangato-a ay oban nin habot la. ");
INSERT INTO sbl_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Ma-in tawo ya ahè ampagbayo anggan agya pon magdanas nin kadya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","No pangno nin angka-ipalako ya lanom nin man-agoh ha kanal ay ombayro itaman ha Pangino-on ya no anyay labay nan ipa-ihip ha arì ay habaytoy an-ihipen nin arì. ");
INSERT INTO sbl_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Maski an-ipalagay nin tawo nin tamà ya kaganawan gawà na ay tandà nin Pangino-on no anyay anti ha nakem na. ");
INSERT INTO sbl_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Hay panggawà nin mahampat boy matoynong ay mas ampakapakonsowilo ha Pangino-on Diyos kisa bawbagay ya an-idolog kona. ");
INSERT INTO sbl_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Hay ampakapangyayari ha tawtawoy mangala-et ay kahambogan boy katag-ayan nakem. Habaytoy ombayro ay kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Hay mahampat ya plano nin kapanikapan ay ampambin ka-inomayan; piro hay ahè pon ampami-aweng ay ampagkakolang. ");
INSERT INTO sbl_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Hay kayamanan ya nakwa ha panana-ol ay tampol angkapanew nin bilang ha alinhangaw; hay tawoy nanggawà nin ombayro ay mipalako ha kamatyan. ");
INSERT INTO sbl_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Hay tawtawoy mangala-et ay angkadisgrasya ha sarili lan kagagaw-an ta agla labay manggawà nin matoynong. ");
INSERT INTO sbl_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Hay tawtawoy ma-in kasalanan ay ampamiyay ha alwan tamà ya pamimiyay, piro hay tawtawoy ayin kasalanan ay ampamiyay ha kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Mas mahampat ya pa-iri ha golot ya hawong kisa ha bali no hay babayi ya ahawa ay mariklamo. ");
INSERT INTO sbl_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Hay tawoy mala-et ay labaylabay manggawà mala-et ha kanayon. Agya ampangingangalo ha maski hino. ");
INSERT INTO sbl_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","No hay tawoy manoya-toyà ay parosawan, hay tawoy makapey et ya pangingintindi ay angkatoto. Hay tawoy maronong ay lalò angkatoto ha an-itorò kona. ");
INSERT INTO sbl_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Hay tawoy mahampat ay tandà na no anyay an-ihipen nin tawtawoy mangala-et. Hay kala-etan nin tawtawoy mangala-et ay habaytoy makahirà konla. ");
INSERT INTO sbl_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Hinoman ya ahè ampangasikaso nin an-ida-ing nin tawtawoy manga-irap ay agya itaman asikasowen no hiyay doma-ing. ");
INSERT INTO sbl_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","No ma-in ampamahang komo ay magrigalo ka kona nin ayin magtandà. Ha ombayro ay ma-alih ya pahang na komo. ");
INSERT INTO sbl_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Hay gawà ya matoynong ay an-ikaliga nin tawtawoy ma-in kahampatan; piro an-ikalelè nin tawtawoy ma-in kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Hay tawoy ampaka-intindi nin tamà ya pamimiyay, piro ampa-alilihan nay mahampat ya pangingintindi ay habaytoy bara-nan nin hiya ay tampol mi-abot ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Hay tawoy ma-ilig maggastos nin ayin kapararakan banà bongat ha pansarili nan kaligawan ay an-omirap; hay tawo itaman ya ma-ilig ha alak boy ha mangabli ya pamamangan ay ahè yomaman. ");
INSERT INTO sbl_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Hay tawtawoy ma-in kala-etan ay ampipabira konla ya kala-etan ya labay lan gaw-en ha tawtawoy ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Mas mahampat ya pa-iri ha powiray dogal kisa makilamo ha ahaway babayi ya mariklamo boy pala-away. ");
INSERT INTO sbl_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Hay tawoy maronong, hay bali na ay ma-in manga-alagà ya kahangkapan boy mangalahap ya pamamangan, piro hay tawoy tangah ay sigisigi ya paggastos na. ");
INSERT INTO sbl_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Hinoman ya ampagsikap nin magkama-in kahampatan boy katapatan ay komarà ya biyay, boy magkama-in ya et nin kahampatan boy karangalan. ");
INSERT INTO sbl_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Hay tawoy maronong ay angkahokat nay hokaw nin mihay siyodad boy angkahirà nay padir ya dipinsa nin habayto. ");
INSERT INTO sbl_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","No labay mon mapa-alilihan ya kagolowan ay mag-atap ka ha paghahalità mo. ");
INSERT INTO sbl_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Hay ingat ha tawoy mapagmatag-ay boy mahambog ay manoya-toyà; hiya ay masyadoy kahambogan. ");
INSERT INTO sbl_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Hay tawoy matamlad ya ahè labay magtrabaho ay emen nan ampatyen ya sarili na. ");
INSERT INTO sbl_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Hiya ay ma-i-ibegen, piro hay tawoy mahampat ay mabibi-iyen. ");
INSERT INTO sbl_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Hay Pangino-on ay angka-inakit ha an-idolog kona nin tawoy mala-et; lalò no hay pambi na ay alwan maganday intinsyon na. ");
INSERT INTO sbl_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Hay ampanistigos nin kabongkokan ay ahè anleng-en; piro hay tawoy ampanlengè pon emen na mahalità ya kaptegan ay ampa-alaga-an. ");
INSERT INTO sbl_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Hay tawoy ma-in kahampatan ay ampakasigoro ha sarili, piro hay tawoy ma-in kala-etan ay mapagkakanwarì. ");
INSERT INTO sbl_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Maski ma-in kan donong, pangingintindi, boy galing manwawali ay agmo et matag-ayan ya Pangino-on Diyos. ");
INSERT INTO sbl_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Hay kawkabayo ay an-ihandà para ha allon labanan; piro Pangino-on Diyos ya ampambin pananalo. ");
INSERT INTO sbl_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Mas maganda nin hay tawo ay mabalayan ya hiya ay mahampat ya pitatawo kisa magkama-in kayamanan ya bilang ha pilak boy gintò. ");
INSERT INTO sbl_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Hay mangayaman boy manga-irap ay paripariho ta hilay kaganawan ay pinalsa nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Hay tawoy ma-in pangingintindi ay tandà nay ma-in mangyari ya kala-etan; kayà angka-atapan na. Piro hay tawoy kolang ha pangingintindi ay kapansosomigi ha anggaw-en na anggan matanggap nay kaparosawan ya bonga nin gawgawà na. ");
INSERT INTO sbl_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Hay pagmaka-aypà boy panggogomalang ha Pangino-on ay ampakab-i ha tawo nin kayamanan, karangalan, boy ampakapakarà biyay. ");
INSERT INTO sbl_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","No ampa-alaga-an moy biyay mo ay pa-alilih ka ha kowinta daan ya ma-in kalot ya ampagdanan nin mangala-et ya tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Toro-an mon mahampat ya anak ha dapat nan gaw-en emen maski mato-a yayna ay agna pa-alilihan baytoy natotowan na. ");
INSERT INTO sbl_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Hay tawtawoy manga-irap ay anti ha hilong kapangyariyan nin tawtawoy mangayaman. Hay mangongotang ay anti ha hilong kapangyariyan nin mama-otang. ");
INSERT INTO sbl_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","No hay intanem mo ay kala-etan, hay alawahanen mo ay masyadon dya-dyà nin kaparosawan ya ikahirà mo. ");
INSERT INTO sbl_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Mag-in kan mabibi-iyen boy hay manga-irap ay atagan mon pamamangan mo emen lalò kan mag-in makalmà. ");
INSERT INTO sbl_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Pa-alihen moy tawoy mapanoya-toyà emen mategen ya pamididiskosyon, pami-a-away, boy pangangaboso. ");
INSERT INTO sbl_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Hay tawoy malinis ya kanakeman boy magalang ha pag-i-ilgo ay angkapag-amigo nay arì. ");
INSERT INTO sbl_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Hay tawoy ampanatilin ma-in tinandà ay an-asikasowen nin Pangino-on; piro anhira-en nay plano nin tawoy ma-in kala-etan. ");
INSERT INTO sbl_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Hay tawoy matamlad ay malakè ya anggaw-en ya bara-nan emen bongat agya magtrabaho. Anhalita-en na ya no lomikol ya ay maka ma-in liyon ya mangnà kona. ");
INSERT INTO sbl_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Hay anhalita-en nin babayi ya pota ay kowinta malalè ya lobot. Habayto ay pakarabo-an nin lawlalaki ya ampamahangan nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Hay anak ay talagan ma-in kapilyowan, piro habayto ay ma-alih no toro-an mo ya boy disiplinawan. ");
INSERT INTO sbl_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Hinoman ya ampangapih ha manga-irap emen ya yomaman, o ampagrigalo ha mangayaman, hiya ay sigoradon omirap. ");
INSERT INTO sbl_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Manlengè ka ta itorò ko komo ya anhalita-en nin tawtawoy mangaronong. Pag-aralan mo bayti, ");
INSERT INTO sbl_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","ta habayti ay makab-i komo nin kaligawan no ma-etpanan mo. Ha ombayro ay ma-in kan ibalità ha kanayon. ");
INSERT INTO sbl_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Labay ko nin pahimalà ka ha Pangino-on; kayà anhalita-en ko bayti komo hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Ma-in mangahampat ya bawbagay ya hinolat ko ya para komo. Habayto ay wawwawali boy tawtinandà ");
INSERT INTO sbl_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","ya mangitorò komo nin kaptegan emen mo matobay nin tamà ya tobay ya nangihogò komo. ");
INSERT INTO sbl_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Agka mamintahi ha tawtawoy manga-irap; agka simpri mangapih nin tawtawoy ayin pakakayan maki-asonto, ");
INSERT INTO sbl_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","ta hay mangipaglaban boy mamarosa ha tawtawoy nanggawà nin ombayro ay Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Agka maki-amigo ha tawtawoy mapahang boy ha tawoy maparan mag-amot olo, ");
INSERT INTO sbl_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","ta no manowad ka ha ogalì la ay emen kaynan nakahe-el ha ombayroy pag-o-ogalì. ");
INSERT INTO sbl_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Agka mangakò nin mamayad otang nin kanayon ya tawo ");
INSERT INTO sbl_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","ta no agmo mabayaran, kateng pamira-an mo ay kowen komo. ");
INSERT INTO sbl_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Agmo i-alsay mohon nin pi-anggawan nin lotà nin kawka-apo-apowan mo ya naboyot anan inggawà. ");
INSERT INTO sbl_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Hay tawoy ma-osay magtrabaho ay ampag-in popolar boy ampi-asinso. ");
INSERT INTO sbl_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","No ampaki-arap kan mangan ha tawoy matag-ay ya katongkolan ay sori-en mon mahampat no hino baytoy ka-arap mo. ");
INSERT INTO sbl_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","No angganawan kan mangan ay magpendan ka. ");
INSERT INTO sbl_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Agka pakakhaw mangan nin habaytoy malahap ya pamamangan ya indolot na komo, ta maka habayto ay anggamiten nan bongat nin panaktika komo. ");
INSERT INTO sbl_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Agmo golowen ya ihip mo ha pagpayaman, ");
INSERT INTO sbl_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","ta hay kayamanan ay ma-arì nin biglà ma-alih nin bilang ha agila ya panlompad nin palako ha katatag-ayan ay agmoyna makit. ");
INSERT INTO sbl_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Agka makipangan ha tawoy ma-imot ni ma-ibeg ha mangalahap ya pamamangan na. ");
INSERT INTO sbl_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","Ma-arì nan halita-en komo ya, “Sigi, mangan ka boy minom ka et,” piro hatoy anhalita-en nay ombayro ay maheb-et ha nakem na. ");
INSERT INTO sbl_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Habaytoy pamamangan ya kinan mo ay ihoka mo, boy hay mangaganday hinalità mo kona ay masayang. ");
INSERT INTO sbl_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Agmo sayangen ya pana-on mo nin maki-ilgo ha tawoy tangah, ta hay anhalita-en mo ay ayin alagà kona. ");
INSERT INTO sbl_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Agmo i-alsa ya mohon nin pi-anggawan nin lotà ya naboyot anan inggawà, o sakopen ya lotà nin aw-olila; ");
INSERT INTO sbl_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","ta hay mangipaglaban konla ay makapangyariyan ya Diyos ya nambeh konla. ");
INSERT INTO sbl_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Leng-en mon mahampat ya an-itorò komo boy tanggapen moy tinandà ya an-iwawali komo. ");
INSERT INTO sbl_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Hay anak ay agmo pag-alanganan nin disiplinawan, ta maski garotiyen mo ya ha pandisiplina mo kona ay agna ikamati, ");
INSERT INTO sbl_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","no alwan hiya ay angka-i-atap mo boy agya tampol mipalako ha dogal nin nikati. ");
INSERT INTO sbl_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Anak koy lalaki, no mag-in kan maronong ay ikaliga ko. ");
INSERT INTO sbl_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Maliga ko no angkalengè katay ma-in karonongan ha pag-i-ilgo. ");
INSERT INTO sbl_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Agka mag-inggit ha tawoy makasalanan, no alwan igalang moy Pangino-on ha kaganawan oras. ");
INSERT INTO sbl_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","No ombayroy gaw-en mo, hay kahampatan ya an-asawan mo ay sigoradon lomateng komo. ");
INSERT INTO sbl_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Manlengè ka, anak koy lalaki; pakaronong ka boy ihipen mo no pangno homampat ya biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Agka makilamolamo ha mawmaglalahing boy ha mangahibà, ");
INSERT INTO sbl_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","ta hay ogotan nin mawmaglalahing boy mangahibà, ha bandan hoyot ay mag-irap. No kapangakatoloy mon bongat banà ha pagkalahing mo, hay ogotan mo ay magdolo nin golot. ");
INSERT INTO sbl_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Leng-en moy tatay mo ta hiya ya ma-in anak komo, boy lalò mon igalang ya nanay mo no hiya ay mato-ayna. ");
INSERT INTO sbl_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Pagsikapan mon matotowan ya kaptegan, karonongan, tinandà, boy pangingintindi. Habayti ay pa-alaga-an mo boy agmo pa-olayan nin ma-alih komo. ");
INSERT INTO sbl_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Hay tatay nin mahampat ya anak ay masyadon maliga; hinoman ya ma-in anak ya maronong ay talagan angkatowà. ");
INSERT INTO sbl_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Manggawà kan ikatowà nin mawmato-antawo mo; boy paligawen moy nanay mo ya nangi-anak komo. ");
INSERT INTO sbl_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Manlengè kan mahampat, anak koy lalaki, ta hiko ya gaw-en mon alimbawà ha biyay mo. ");
INSERT INTO sbl_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Pakarayò ka ha pota ta hiya ay ayin imbalag ha malalè ya lobot ya hay tawoy marabò bayro ay mahagep na. ");
INSERT INTO sbl_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Hiya ay emen ha tolisan ya ampangabang. Hay lalaki ya mahagep na ay ampag-in alwan tapat ha ahawa. ");
INSERT INTO sbl_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","30","Hay tawoy masyadon minom alak boy pirmin ampanikap nin hari-harì ya klasin alak ya ma-inom ay ka-i-ingalo, malelè, magolo, mariklamo, angkahogatan ha sarili nan kagagaw-an, boy naka-o-orit ya mata. ");
INSERT INTO sbl_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Agka mangimaton nin an-i-alih ya maski anyay klasin alak, boy agka ma-ibeg ha angkakit moy ampipampinom, ");
INSERT INTO sbl_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","ta no minom ka, ha bandan hoyot ay matanam mo ya bilang kan tinokà nin otan ya nagdità. ");
INSERT INTO sbl_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Hari-harì ya makit mo, agka maka-ihip nin mahampat, boy agka makapag-ilgo nin malinaw. ");
INSERT INTO sbl_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Hay tanam mo ay angka-olaw ta bilang kan anti ha tag-ay nin barko ya angkawegweg nin dawoyon. ");
INSERT INTO sbl_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Banà bayro ay ombayri ya halita-en mo: “Pinakakhitan la ko piro agko napangno; binogbog la ko piro agko natanda-an. Pamaka-imahmah ko ay manikap akoyna et nin kanayon ya ma-inom.” ");
INSERT INTO sbl_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Agka mag-inggit ha tawtawoy mangala-et boy agmo nakemen nin maki-amigo konla; ");
INSERT INTO sbl_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","ta hay pirmi lan an-ihipen ay kagolowan, boy hay anhalita-en la ay tongkol ha panlala-et nin kapara. ");
INSERT INTO sbl_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Hay bali ay angkagawà nin banà ha karonongan boy pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Banà ha tinandà, hay bali ay ampagkama-in nin manga-alagà boy mangaganday kawkahangkapan. ");
INSERT INTO sbl_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Hay tawoy maronong ay mas mahampat kisa ha tawoy makhaw; talagan hay tawoy ma-in tinandà ay mas mahampat kisa ha tawoy ma-in kakhawan. ");
INSERT INTO sbl_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Biha ka makon makigira ay makipapano ka pon ha mangaronong ta hay wawwawali la ay makatambay ha pananalo mo. ");
INSERT INTO sbl_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Hay maldeg ya anhalita-en nin tawoy maronong ay ahè ma-intindiyan nin tawoy tangah. Kayà no ma-in ampi-i-ilgowan ya ma-alagà ya bawbagay, hatoy tawoy tangah ay ayin angkahalità. ");
INSERT INTO sbl_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Hay tawoy pirmin ampagplano nin kala-etan, hay ingat kona ay mapanggawà kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Hay pananaktika ya an-ihipen nin tawoy tangah ay kasalanan. Hay tawtawo ay angka-inakit ha tawoy ampanoya-toyà nin kanayon. ");
INSERT INTO sbl_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","No angkomapey ya nakem mo ha anlomateng komo ya alwan maganday pangyayari ay talagan makapey ka. ");
INSERT INTO sbl_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Agmo pag-alanganan nin ilibri ya tawoy anggitan nin patyen. ");
INSERT INTO sbl_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Ma-arì mon halita-en ya ayin kan paki-emenan, piro tandà nin Diyos no anyay anti ha nakem mo. Ambantayan na ka boy tandà nay kaganawan; kayà tandà nan gantiyen ya gawgawà mo. ");
INSERT INTO sbl_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Anak koy lalaki, mangan kan polot ta habayti ay mahampat. Hay polot panilan ay talagan matam-ih. ");
INSERT INTO sbl_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","No pangno katam-ih bayto ay ombayro itaman ya karonongan ha nakem nin tawo. Kayà pagsikapan mon magkama-in karonongan emen ka magkama-in pag-asa ha kinabokahan. ");
INSERT INTO sbl_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Hika ya tawoy mala-et, agmo nakemen nin panakawan ya tawoy mahampat; agmo simpri hira-en ya ampa-iriyan na; ");
INSERT INTO sbl_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","ta hay tawoy mahampat, maski kowinta natombah nin kapitoy bisis ay maka-ibangon et oman. Piro hay tawtawoy mangala-et ya natombah gitan nin alwan maganday pangyayari ay ayin anan pag-asan maka-ibangon oman. ");
INSERT INTO sbl_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Agmo ikatowà no ma-in mangyari ya alwan maganda ha ka-away mo; ");
INSERT INTO sbl_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","ta no ombayroy gaw-en mo, hay Pangino-on ay ahè mangonsowilo komo boy itegen nay pamarosa do ha ka-away mo. ");
INSERT INTO sbl_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Agmo golowen ya nakem mo nin banà ha tawtawoy ampipanggawà kala-etan, boy agka mag-inggit konla. ");
INSERT INTO sbl_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","Hay mala-et ya tawo ay ayin kinabokahan boy ayin ma-asawan ha pana-on ya an-arapen. ");
INSERT INTO sbl_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Anak koy lalaki, igalang moy Pangino-on Diyos boy arì, boy agka makilamo ha tawtawoy ampipagribildi; ");
INSERT INTO sbl_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","ta hay tawtawoy ampipagribildi ay ma-arì lomateng konlan biglà ya alwan maganday pangyayari. Ayin magtandà no anyay kaparosawan ya ma-arì gaw-en nin Pangino-on Diyos boy arì. ");
INSERT INTO sbl_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Ombayri ya anhalita-en nin tawtawoy mangaronong: Hay panonosga ya ma-in ampanigan ay alwan mahampat. ");
INSERT INTO sbl_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Hay howis ya ampanosga nin tawoy nagkasalanan ya ha panosga na ay halita-en na ya hatoy tawo ay ayin kasalanan, hatoy howis ay an-ihompà boy ampamahangan nin kaganawan tawo. ");
INSERT INTO sbl_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Piro hay hawhowis ya ampambin kaparosawan ha nagkasalanan ay ampag-inomay boy andayawen nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Hay tapat ya pantotombay nin tawo ay palatanda-an nin hiya ay mahampat maki-amigo. ");
INSERT INTO sbl_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Ihandà mo pon ya paliyan mo emen ka ma-in nin sigoradoy pakakitan. Mayarì bayto ay mamangon kayna nin bali mo. ");
INSERT INTO sbl_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Agka manistigos nin kontra ha kapara mo no ayin sapat ya bara-nan, boy agka maghalità nin alwan peteg ya tongkol kona. ");
INSERT INTO sbl_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Agka simpri maghalità nin, “Bawehan ko ya ha ginawà na kongko.” ");
INSERT INTO sbl_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Niparaan ako ha danin paliyan boy ha danin tinamnan obas nin tawoy matamlad ya kolang ha pangingintindi. ");
INSERT INTO sbl_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Habaytoy paliyan ay tinobo-an nin dikot ya nipagdowih boy kanayon et ya klasin dikot, boy hay alal ya bawbato ay niyogmà. ");
INSERT INTO sbl_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Habayto ay pinakabiliw ko boy inihip kon mahampat; kayà nakakwa kon aral. ");
INSERT INTO sbl_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Hay nakwa koy aral bayro ay matoloy amò, mangitiglep amò, makon matoloy, manalikepkep amò, pa-inawan amò, ");
INSERT INTO sbl_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","piro mintras kan angkatoloy, hay ka-irapan ay lomateng komo nin bilang ha mananakaw ya naka-armas. ");
INSERT INTO sbl_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Habayti et ya kanayon ya kawkahalita-an ni Solomon ay kinopya nin tawtawowan ni Isikiyas ya arì ha Hoda. ");
INSERT INTO sbl_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Ambiyan tamon karangalan ya Diyos banà ha bawbagay ya agna impatandà; hay aw-arì itaman ay amparangalan tamo ha pangi-isplikar la. ");
INSERT INTO sbl_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Agmo matanda-an no anyay an-ihipen nin arì, ta hay ka-ihipan na ay emen katag-ay langit boy emen kalalè dagat. ");
INSERT INTO sbl_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Ka-ilangan pon alihen ya la-ok nin pilak emen makagawà nin maganday kahangkapan. ");
INSERT INTO sbl_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Ka-ilangan alihen ya mangala-et ya mawmagwawali nin arì emen hay pamomo-on na ay mag-in matoynong. ");
INSERT INTO sbl_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","No anti ka ha arapan nin arì ay agmo ipakit ya hika ay emen importantin tawo, boy agka pa-ipowisto ha dogal ya para ha mangatag-ay ya pagkatawo. ");
INSERT INTO sbl_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Mas mahampat ya anti-en mo nin hagyaten ka nin pa-ipowisto ha dogal ya para ha mangatag-ay ya pagkatawo kisa pa-alihen ka ta hagiliyan ka nin mas matag-ay ya pagkatawo komo. ");
INSERT INTO sbl_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Agka antimanon manistigos maski nakit moy pangyayari ta maka ma-in kanayon ya manistigos nin alwan ogmà ha panistigos mo. No ombayroy mangyari, anyay gaw-en mo ha bandan hoyot no nipareng-ey ka? ");
INSERT INTO sbl_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","No ma-in kawon ahè mapikanokatan nin kapara mo ay pi-ilgowan moyo boy hay sawsikrito moyo ay agmoyo ibolgar, ");
INSERT INTO sbl_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","ta no ma-in makalengè komoyo ay hahalita-an na kawo boy ayin pangalabah ya kakareng-eyan moyo. ");
INSERT INTO sbl_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Hay halità ya tamà boy tamà ha pana-on ay emen ha gintò ya impababo ha pilak ya magandan patagen. ");
INSERT INTO sbl_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Hay maganday wawali ha maronong manlengè ay mas ma-alagà ha tinggà ya yarì ha gintò, o aw-alahas ya yarì ha poron gintò. ");
INSERT INTO sbl_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Hay mapahimala-an ya ihohogò ay ampakapalay-ep nakem nin nangihogò kona nin bilang ha malay-ep ya lanom ya ampakapaprisko nin tawoy anhalimo-oten no pana-on pangalawah. ");
INSERT INTO sbl_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Hay tawoy ampagpangakò nin mambi piro agna antoparen ya pangakò na ay emen ya ha leem boy angin ya ahè ampambin oran. ");
INSERT INTO sbl_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Hay mapanawah ya pag-ilgo ay ampakabagbag nakem nin tawoy matyà ya kanakeman boy maski ampamo-on ay angkakombinyo. ");
INSERT INTO sbl_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","No mangan kan polot panilan ay agmo pasobrawan ta maka ihoka mo. ");
INSERT INTO sbl_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Agka pakabetbet manambali ta maka kasorawan ka nin antambaliyen mo boy pag-inakitan na ka et. ");
INSERT INTO sbl_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Hay tawoy ampagtotol nin kabongkokan ya kontra ha kapara na ay emen ya ha maso, hondang, boy matolis ya yawò ya anggamiten pamati. ");
INSERT INTO sbl_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Hay ampagkompiyansa ha tawoy ahè mapahimala-an ha pana-on nin panganga-ilangan ay emen ha ma-in dipirinsyay ngipen ya an-ipilit pangnga-ngà o emen ha pilay ya ampowayo. ");
INSERT INTO sbl_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Hay tawoy ampagkantan manahaliwa ha tawoy labis ya kalele-an ay emen ha tawoy ampaglo-hok nin dolo ha pana-on ya malay-ep o emen ha hokà ya nila-okan nin karbonato. ");
INSERT INTO sbl_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","No nabitil ya ka-away mo ay pakanen mo; no angka-angan ya ay pa-inomen mo. ");
INSERT INTO sbl_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","No ombayroy gaw-en mo ay mareng-ey ya nin banà ha ginawà na komoy kala-etan ya ginanti mo nin kahampatan. Ha ombayroy ginawà mo, hay Pangino-on ay mambi komo nin primyo. ");
INSERT INTO sbl_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","No pangno ampantan oran ya angin ya ampangibat ha mayanan ay ombayro itaman ampambin pahang ya paninirà nin kaparan tawo. ");
INSERT INTO sbl_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Mas mahampat ya pa-iri ha golot ya hawong kisa ha bali no hay babayi ya ahawa ay mariklamo. ");
INSERT INTO sbl_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","No pangno ampaka-alin angan ya malay-ep ya lanom ay ombayro itaman ampakapaprisko ya mahampat ya balità ya na-ibat ha marayò ya dogal. ");
INSERT INTO sbl_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Hay mahampat ya tawo ya ampatoksò ha tawoy mala-et ay emen ha nilabeg ya lanom nin hobol o mayangat ya lanom nin libon. ");
INSERT INTO sbl_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Hay sobray pamangan nin polot ay alwan mahampat. Ombayro itaman ha sobray paghangad nin kaporiyan. ");
INSERT INTO sbl_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Hay tawoy ayin pagpendan ha sarili ay emen ha siyodad ya ayin dipinsa ta hay alal ya padir ay nayobà. ");
INSERT INTO sbl_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","No pangno nin hay bagyo ya alwan dapat lomateng no ka-ingitan, o oran no pana-on pangalawah ay ombayro ya tawoy tangah, hiya ay alwan dapat poriyen. ");
INSERT INTO sbl_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Hay hompà ay ahè antomalab no ayin bara-nan ya pangihompà. Habayto ay bilang ha mawmanokmanok ya mamalopadlopad ya ahè an-omogpà. ");
INSERT INTO sbl_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Hay latiko ay para ha kabayo; hay bosal ay para ha asno; hay babarog itaman ay para ha tawoy tangah. ");
INSERT INTO sbl_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","No tobayen moy pastang nin tawoy tangah ay mag-in kan tangah nin bilang kona. ");
INSERT INTO sbl_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","No minghan itaman ay ka-ilangan mon tobayen ya tawoy tangah emen agna ihipen ya hiya ay maronong. ");
INSERT INTO sbl_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Hay tawoy ampangihogò nin tawoy tangah nin mantan balità ay mahampat et ya potohen nay bitih na; hiya ay ampanikap kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Hay kahalita-an ya anhalita-en nin tawoy tangah ay ayin imbalag ha bitih ya pilay ya ahè ma-i-owako. ");
INSERT INTO sbl_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Hay tawoy ampamori ha tawoy tangah ay emen yan nangitakel nin malhay ya bato ha katat tilador ya itilador na. ");
INSERT INTO sbl_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Hay kahalita-an ya anhalita-en nin tawoy tangah ay emen ha lahing ya ampangalih nin dowih ha gamet na ya agna tandà tanamen no ayri banda ya dowih na. ");
INSERT INTO sbl_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","No pangnoy anggaw-en nin mamamanà ya balang malibah ay ampana-en na ay ombayro itaman ya mamatrabaho ya ampananggap nin tawoy tangah o maski hinoy malibah nin opa-an na. ");
INSERT INTO sbl_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","No pangno ambirawen nin aho nin kanen ya hoka na, ombayro itaman ya tawoy tangah ya pa-oman-oman manggawà nin kamali-an na. ");
INSERT INTO sbl_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Hay tawoy ampangipalagay nin hiya ay pagkaronong, hiya ay mas et ha tawoy pagkatatangah. ");
INSERT INTO sbl_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Hay tawoy matamlad ay ahè labay lomikol ha bali nin magtrabaho ta hay ampagbara-nan na ay maka ma-in liyon ha daan ya mangnà kona. ");
INSERT INTO sbl_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","No pangno nin hay polta ay maglo-at boy magharà bongat banà ta nakakabit ha bisagra ay ombayro itaman ya tawoy matamlad ya mama-owad-owad ha pamira-an na. ");
INSERT INTO sbl_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Hay tawoy matamlad, ha katamlaran na, maski ihohobò naynay kanen ay agna et magawà dampoten. ");
INSERT INTO sbl_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Hay an-ipalagay nin tawoy matamlad ha sarili na ay da-eg nay pito katawo ya ampakapagrason nin maganday rason. ");
INSERT INTO sbl_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Hay tawoy ampaki-emen ha away nin kanayon ay emen yan anti ha kalsara ya ampamiyabit tolih nin aho. ");
INSERT INTO sbl_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","19","Hay tawoy ampanloko nin kapara na biha na halita-en ya habayto ay alina nan bongat ay emen ya ha tawoy lokoloko ya ampagdagaw nin aw-armas ya ampakamati. ");
INSERT INTO sbl_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Hay apoy ay angkaparè no kolang ya ohong. Ombayro itaman ha pagdaldal; no ayin magdaldal, hay away ay ahè ansomigi. ");
INSERT INTO sbl_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Hay bayah ay ahè maparè no pahanan mon oling o kayo. Ombayro itaman ha away, hay away ay ahè mategen no ma-in tawoy mapanggawà golo. ");
INSERT INTO sbl_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Hay pagdaldal ay maganan leng-en nin tawtawo ta para konla, habayto ay emen ha malahap ya pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Hay anhalita-en nin tawo ya alwan leseb ha nakem na ay emen ha bangà ya pininon pinalinò ya likol emen mahakban ya magaspang. ");
INSERT INTO sbl_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Hay magkakanwarì ay angka-itagò nay inakit na ha paghalità na nin hawhalità ya mangaganda. ");
INSERT INTO sbl_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Maski anyay ganda nin anhalita-en na ay agkawo minto-o, ta hay nakem na ay pono-ponò nin inakit. ");
INSERT INTO sbl_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Angkapaghakban nay inakit na, piro angkakit nin kaganawan ya kala-etan ya anggaw-en na. ");
INSERT INTO sbl_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Hinoman ya ampanggawà nin alwan maganday bagay ya paniblet nan kapara na ay ampibira kona ya kahibletan na; boy hinoman ya ampangitolid nin bato ha kapara na ay mismon hiya ya angkatoliran. ");
INSERT INTO sbl_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Hay tawoy ampaghalità nin kabongkokan ay ma-in inakit ha tawoy ambongkoken na; kayà ampakakhitan na. Hay tawo itaman ya ampaghalità nin alwan leseb ha nakem na ay ampambin ikahirà. ");
INSERT INTO sbl_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Agmo ipaghambog no anyay gaw-en mo nobokah, ta agmo tandà no anyay mangyari nobokah. ");
INSERT INTO sbl_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Pa-olayan mon poriyen ka nin kanayon ya tawo; alwan hika ya magpopori nin sarili mo. ");
INSERT INTO sbl_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Hay bato ay mabyat; ombayro simpri ya kapati-an, piro mas mabyat ya kagolowan ya kagagaw-an nin tawoy tangah. ");
INSERT INTO sbl_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Mas dilikadoy pangingimon kisa ha masyadoy pahang. ");
INSERT INTO sbl_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Mahampat et ya ha-aren moy amigo mo maski ha arapan nin kalak-an tawo kisa ihipen na nin hiya ay ayin kowinta komo. ");
INSERT INTO sbl_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Mas mahampat ya pakakhit nin amigo kisa alek nin ka-away. ");
INSERT INTO sbl_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Hay tawoy bohoy, maski polot panilan ay agna labay kanen, piro hay tawoy mabitil, maski mapa-it ya bagay ay matam-ih kona. ");
INSERT INTO sbl_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Hay tawoy ampagbalang ay emen ha manokmanok ya nog-alih ha hayi na ya agnayna biniran niyemyeman ya okoy na. ");
INSERT INTO sbl_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Hay asiti boy pabangoh ay ampakapaligha; ombayro itaman ha mita-amigo ya maheney pami-amigo. ");
INSERT INTO sbl_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Agmo pa-olayan ya amigo mo o amigo nin tatay mo. No ma-in pangyayari komo ya alwan maganda ay alwa moynan ka-ilangan nin makon papatambay ha patel mo. Hay makatambay komo ay karani mo kisa patel mo ya anti ha marayò. ");
INSERT INTO sbl_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Anak koy lalaki, pakaronong ka emen ako lomiga. Ha ombayro ay magkama-in akon itobay ha ampamintas kongko. ");
INSERT INTO sbl_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Hay tawoy ma-in pangingintindi ay tandà nay ma-in mangyari ya kala-etan; kayà angka-atapan na. Piro hay tawoy kolang ha pangingintindi ay kapansosomigi ha anggaw-en na anggan matanggap nay kaparosawan ya bonga nin gawgawà na. ");
INSERT INTO sbl_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Hay tawoy magpangakò nin mamayad otang nin alwa nan kabalay ay tangah; kayà hay dapat do ha nagpangakò ay kowen ya kamama-in na bilang garantiya nin pagpangakò na. ");
INSERT INTO sbl_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","No ilawen moy amigo mo nin hay hambak, ta hay pangilaw mo kona ay pabonghaw, hay ombayro ay an-ibilang na nin hompà kona. ");
INSERT INTO sbl_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Hay ahaway babayi ya mariklamo ay emen ha managa-alloy tolò nin lanom ya angka-ibat ha bobongan no ampangoran. ");
INSERT INTO sbl_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Agmo ya pategenen ha pagriklamo nin emen ha angin ya ahè mapategen o asiti ya ahè madampot. ");
INSERT INTO sbl_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","No pangno nin hay pahak ay angkapatarem nin kaparan pahak ay ombayro itaman ya ihip nin tawo ya angkapatalas nin kapara nan tawo. ");
INSERT INTO sbl_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","No alaga-an moy po-on kayoy igos ay maka-ekan kan bonga nin habayto. Ombayro itaman, hay alilà ya ampangasiwà ha amo na ay amparangalan. ");
INSERT INTO sbl_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","No pangno mo angka-aninag ya lopa mo ha lanom ay ombayro itaman, ha nakem mo ay matanda-an mo ya pagkatawo mo. ");
INSERT INTO sbl_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","No pangno nin pirmin ampangantì ya dogal nin nikati nin ma-in mipalako bayro ay ombayro itaman ya tawoy ahè angkaraygan. ");
INSERT INTO sbl_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Hay pilak boy gintò ay anhoboken ha apoy emen makit no talagan poro; hay tawo itaman ay mabalayan ya pagkatawo na no ma-in ampamori kona. ");
INSERT INTO sbl_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Hay tawoy tangah, maski pagbabayoh mo nin bilang ha pali ay ahè ma-alih ya katangahan na. ");
INSERT INTO sbl_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Asiwa-en mon mahampat ya aw-ayop mo, ");
INSERT INTO sbl_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","ta hay kayamanan ay ma-in anggawan; ombayro simpri ha tawtawoy ampipamo-on ya ma-in kapangyariyan nin bilang ha arì. ");
INSERT INTO sbl_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Hay gaw-en mo ay tabasen moy dikot ya nikayangoh ta tiponen mon pamakan nin aw-ayop mo mintras an-anti-en mon tomobò oman baytoy pinanabasan mo. ");
INSERT INTO sbl_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Hay habot nin aw-ayop mo ya bilang ha topa ay ma-arì mon gaw-en dolo ya pagdolo mo; hay kanding itaman ay ma-arì mon ilakò ta hay napaglako-an ay panaliw mon lotà. ");
INSERT INTO sbl_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Hay kanayon ya kanding mo ay ma-arì mon gatasan emen ma-in ma-inom ya pamilya mo kateng aw-alilà moy bawbabayi. ");
INSERT INTO sbl_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Hay tawoy mala-et ay ampowayo maski ayin ampangalimot kona, piro hay tawoy mahampat ay emen katapang liyon. ");
INSERT INTO sbl_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Hay nasyon ay ampanatilin matatag no hay ampamo-on ay ma-in pangingintindi boy ma-in tinandà, piro no hay tawtawo ha mihay nasyon ay ampipagkasalanan, hay ampamo-on ay ahè ambomoyot no alwan tampol angkapahiliyan. ");
INSERT INTO sbl_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Hay tawoy ma-irap ya nagkama-in katongkolan ya ampama-irap ha tawtawoy manga-irap ay emen ha oran ya masyadoy hokaw ya ampakahirà nin tawtanaman. ");
INSERT INTO sbl_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","No agmo ampa-alaga-an ya layih ay an-omawoyon ka ha tawtawoy mangala-et, piro no anhonolen moy layih ay kontra ka ha tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Hay tawtawoy mangala-et ay ahè ampaka-intindi nin katoynongan, piro hay ampipagsikap homonol ha Pangino-on ay ampaka-intindi nin mahampat. ");
INSERT INTO sbl_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Mahampat et ya tawoy ma-irap ya ampamiyay nin tapat kisa tawoy mayaman ya alwan tapat. ");
INSERT INTO sbl_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Hay anak ya anhomonol ha layih ay maronong, piro hay anak ya ampakilamo ha ampipanggawà nin alwan mahampat ay an-ipareng-ey nay tatay na. ");
INSERT INTO sbl_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Hay tawoy anyomaman nin banà ha sobray pagpatobò boy pamintahi ha tawoy ampanga-ilangan, hay kayamanan na ay mipalako do ha tawoy ampangingangalo boy ampanambay ha manga-irap. ");
INSERT INTO sbl_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Hay tawoy ahè anhomonol ha layih, hay pawpanalangin na ay angka-inakitan nin Diyos; kayà agna anleng-en. ");
INSERT INTO sbl_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Hinoman ya ampanggawà kaparanan emen hay mahampat ya tawo ay makagawà kala-etan, mismon hiya ya angkahagep nin sarili nan kagagaw-an. Hay mahampat ya tawo balè ay makatanggap nin kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Hay an-ipalagay nin tawoy mayaman ha sarili na, hiya ay maronong, piro hay tawoy ma-irap ya ma-in pangingintindi ay tandà nay kaptegan ya tongkol do ha tawoy mayaman. ");
INSERT INTO sbl_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","No hay mamo-on ay mangahampat ya tawtawo, kaganawan ay angkatowà, piro no hay mamo-on ay mangala-et ya tawtawo, hay tawtawo ay ampipagtagò. ");
INSERT INTO sbl_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Hay biyay mo ay ahè polalagan no ma-in kan an-itagò ya kasalanan, piro no ihokò moy kasalanan mo ha Diyos boy paghehean mo, hay Diyos ay mangingangalon mamatawad komo. ");
INSERT INTO sbl_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Makalmà ya tawoy pirmi nin anggomalang ha Pangino-on, piro hay tawoy matyà ya nakem ay ma-in lomateng konay pangyayari ya alwan maganda. ");
INSERT INTO sbl_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","No pangno nin ampan-aglem ya liyon boy no pangnoy ayop ya oso ya mabitil ay ombayro ya mala-et ya tawoy ampamo-on ha tawtawoy manga-irap. ");
INSERT INTO sbl_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Hay ampamo-on ya ayin pangingintindi ay ayin ingangalo, piro hay ampamo-on ya ahè labay mana-ol emen makinabang ay ambomoyot ya pamomo-on. ");
INSERT INTO sbl_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Hay mapamatin tawo ay emen nan an-aporawen ya kamatyan na; kayà hay dapat kona ay pa-olayan. ");
INSERT INTO sbl_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Hay tawoy ampamiyay ha kahampatan ay marayò ha kadisgrasyawan, piro hay tawoy ampanggawà nin kala-etan ay marani ha kadisgrasyawan. ");
INSERT INTO sbl_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Hay mamaliyan ya mahipeg magtrabaho ay ampolalagan nin malakè ya pamamangan, piro hay tawoy ampanggawà nin bawbagay ya ayin pakinabang ay talagan mag-irap. ");
INSERT INTO sbl_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Hay tawoy tapat ay pirmin ma-in kaligawan, piro hay tawoy ampag-aporan yomaman ha alwan maganday paraan ay talagan parosawan. ");
INSERT INTO sbl_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Alwan mahampat ha tawo ya ma-in ampanigan, piro ma-in tawo ya mabiyan mon bongat nin maski mayamò ya bagay ay ampanggawà ana nin alwan tamà. ");
INSERT INTO sbl_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Hay tawoy ampag-intris ha alwa nan ikon ay labay nan tampol yomaman, piro agna tandà ya ma-in lomateng konay ka-irapan. ");
INSERT INTO sbl_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","No ha-aren mo ya mihay tawo, ha bandan hoyot, habayto ay mag-in mas ma-alagà kona kisa dayawen mo ya nin pagkakanwarì bongat. ");
INSERT INTO sbl_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Hinoman ya ampangihip nin alwan kasalanan no panakawan nay mawmato-antawo na, hay tawoy ombayro ay kalamo nin tolisan. ");
INSERT INTO sbl_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Hay tawoy makamkam ay ampambin kagolowan, piro hay tawoy ampahimalà ha Pangino-on ay ampolalagan. ");
INSERT INTO sbl_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Hay tawoy ampahimalà ha sarili nan ihip boy kanakeman ay tangah, piro hay tawoy ampamiyay nin ma-in karonongan ay marayò ha kadisgrasyawan. ");
INSERT INTO sbl_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Hay tawoy ampambi ha manga-irap ay ahè ma-ayinan, piro hay tawoy ahè ampaka-ingalo ha manga-irap ay an-ihompà nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","No hay ampipamo-on ay mangala-et, hay tawtawo ay ampipagtagò, piro no hay mangala-et ya ampipamo-on ay ayin ana ha katongkolan, hay mangahampat ya tawo ay anlomakè. ");
INSERT INTO sbl_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Hay tawoy mabetbet ha-aren piro talagan ampagmatyà nakem ay biglà ma-anggawan nin ayin anan rimidyo. ");
INSERT INTO sbl_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","No hay ampamo-on ay mahampat ya tawo, hay tawtawo ay ampagtowà, piro no hay ampamo-on ay mala-et, hay tawtawo ay ampipaglelè. ");
INSERT INTO sbl_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Hay tawoy ampagpa-alagà ha karonongan ay an-ipagparangalan ya nin tatay na, piro hay tawoy ampakilamo ha pota ay ansayangen nay kamama-in na. ");
INSERT INTO sbl_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","No hay pamomo-on nin arì ay matoynong, hay ampag-ari-an na ay ampag-in matatag, piro no ha pamomo-on na ay ampasohol ya ay anhira-en nay nasyon na. ");
INSERT INTO sbl_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Hay tawoy ampagkakanwarì mandayaw nin kapara na ay emen yan ampanggawà nin sarili nan kahira-an. ");
INSERT INTO sbl_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Hay mala-et ya tawo ay angkahagep ha sarili nan kasalanan, piro hay tawoy mahampat ay ampikakanta boy ampagtowà. ");
INSERT INTO sbl_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Hay tawtawoy mangahampat ay tandà lay karapatan nin manga-irap, piro hay tawtawoy mangala-et, hay karapatan nin manga-irap ay ayin kowinta konla. ");
INSERT INTO sbl_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Hay tawtawoy mapanoya-toyà ay ampamagawà nin kagolowan ha tawtawo, piro hay tawtawoy mangaronong ay ampakapimamà nin pahang. ");
INSERT INTO sbl_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","No hay tawoy maronong ay ampakikolpya ha tawoy tangah, hatoy tawoy tangah ay mamahang o mangka-ilin bongat kona. ");
INSERT INTO sbl_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Hay mawmapamatin tawo ay angka-inakit ha tawoy tapat, piro hay tawtawoy mangahampat ay an-i-atap lay biyay nin hatoy tawoy tapat. ");
INSERT INTO sbl_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Hay tawoy tangah ay an-ipakit nay masyadoy kapahangan na, piro hay tawoy maronong ay ampakapagpendan boy agna an-ipahalatà ya pahang na. ");
INSERT INTO sbl_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","No hay ampamo-on ay ampinto-o ha kabongkokan, kaganawan katambay na ha pamomo-on na ay ampag-in mala-et. ");
INSERT INTO sbl_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Hay ma-irap ya tawo boy tawoy ampama-irap nin kapara na ay parihon ma-in mata ya inggawà nin Pangino-on emen hila makakit. ");
INSERT INTO sbl_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Hay arì ya ampangidipinsa nin karapatan nin manga-irap, hay pamomo-on na ay maboyot ya pana-on. ");
INSERT INTO sbl_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Hay pangitoto boy pandisiplina ha anak ay mahampat; no hay anak ay ayin disiplina ay an-ipareng-ey nay mawmato-antawo na. ");
INSERT INTO sbl_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","No hay ampipamo-on ay mangala-et, hay kala-etan ay angkapahanan, piro makit nin mangahampat ya tawo no pangno hila milegleg. ");
INSERT INTO sbl_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Disiplinawan moy anak moy lalaki emen ka magkama-in katinekan; ha ombayro ay mangonsowilo ya nakem mo. ");
INSERT INTO sbl_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Hay tawtawoy ahè ampanlengè ha Halità nin Diyos ay ayin ka-ayosan ta ayin mangigiya konla, piro hay tawoy anhomonol ha kawkapanogo-an nin Diyos ay makalmà. ");
INSERT INTO sbl_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Hay alilà ay agmo ma-itoto ha halità bongat, ta maski angka-intindiyan na ay agna ka leng-en. ");
INSERT INTO sbl_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Mas ma-in pag-asay tangah kisa tawoy ahè pon ampangihip no anyay dapat nan halita-en. ");
INSERT INTO sbl_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","No hay alilà mo, pa-ibat hin malagò ya ay hinonol mo ha kaganawan labay na, ha bandan hoyot, kaganawan ikon mo ay pag-ikon na. ");
INSERT INTO sbl_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Hay tawoy mapahang ay ampanggawà kagolowan, boy hay tawoy ma-amot ya olo ay ampagkasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Hay kahambogan nin tawo ay ampakapilegleg kona, piro hay tawoy mapagma-aypà ay amparangalan. ");
INSERT INTO sbl_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Hinoman ya ampakilamo ha matakaw ay bilang yan angka-inakitan nay sarili na. Angkalengè nay mag-in parosa do ha matakaw piro agya ampagtelek. ");
INSERT INTO sbl_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Agmo golowen ya ihip mo ha an-ihipen nin kanayon ya tongkol komo, no alwan pahimalà ka ha Pangino-on emen ka magkama-in katinekan. ");
INSERT INTO sbl_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Malakè ya ampagsikap nin hay ampamo-on konla ay mag-in mahampat konla, piro hay katoynongan ay ha Pangino-on bongat ampangibat. ");
INSERT INTO sbl_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Hay tawtawoy ma-in kahampatan ay angka-inakit ha tawtawoy mangala-et; hay tawtawo itaman ya mangala-et ay angka-inakit ha tawtawoy ma-in kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Hay hawhalità ni Agor ya anak ni Hakih ya taga Massa ay hinalità na koni Ityil boy koni Okal, ya wana, ");
INSERT INTO sbl_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","“Talagan hiko ay masyadoy katangahan boy ayin pangingintindi nin bilang ha kanayon ya tawo. ");
INSERT INTO sbl_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Agko natoto nin karonongan boy ayin akon tandà ya tongkol ha Diyos ya ayin kapintasan. ");
INSERT INTO sbl_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Warì ma-in tawoy naka-olì ha katatag-ayan ha kama-inan nin Diyos biha nag-aypà oman bayri ha babon lotà? Warì ma-in tawoy nakakemkem nin angin? Warì ma-in tawoy nakapipotot nin lanom ha dolo? Hinoy nambin anggawan nin babon lotà? Hino, boy hinoy anak na no tandà mo? ");
INSERT INTO sbl_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","“Antoparen nin Diyos ya kaganawan pangakò na. Hiya ya kobliyan nin kaganawan tawoy ampahimalà kona boy amprotiksyonan na hila. ");
INSERT INTO sbl_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","No pahalita-en moy Diyos nin agna hinalità ay pamahangan na ka boy lomwah nin hika ay mabongkok.” ");
INSERT INTO sbl_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Pangino-on Diyos, biha ko mati ay loway bagay ya awoken ko pon komo: ");
INSERT INTO sbl_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Ona, tambayan mo ko nin ahè magtotol kabongkokan. Ikalwa, agmo ko payamanen o pa-irapen. Biyan mo ko tanan pamamangan ya tama-tamà ha panganga-ilangan ko; ");
INSERT INTO sbl_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","ta no somobra ay maka halita-en koy alwa katan ka-ilangan. No ma-irap ako itaman ay maka manakaw ako. Ha ombayro ay mabiyan kon kareng-eyan ya Diyos ko. ");
INSERT INTO sbl_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Hay alilà ay agmo hira-en ha amo na, ta no ihompà na ka ay hika ya lomwah nin ma-in kasalanan. ");
INSERT INTO sbl_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Ma-in tawtawoy ampangihompà nin tatay la, boy ahè ampamalay nin otang ya nakem ha nanay la. ");
INSERT INTO sbl_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Ma-in tawtawoy ampagmamalinis piro ha kaptegan, hay nakem la ay maremek. ");
INSERT INTO sbl_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Ma-in tawtawo ya ha asa la ha sarili la ay pagkahahampat la boy ayin hilaynan kapara ha kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Ma-in tawtawo ya masyadon mamintahi ha manga-irap ya hay anggamiten la ay maski anyay pamamaraan emen hila yomaman. ");
INSERT INTO sbl_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","Ma-in lintà ya nanganak nin loway babayi ya hay pirmi lan anhalita-en ay “Biyan mo kayi!”; hila ay ayin imbalag bayri ha apat ya bagay ya ahè angkakontinto: ");
INSERT INTO sbl_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","dogal nin nikati, babayi ya ba-og, lotà ya naklang ya ampanga-ilangan nin oran, boy apoy ya ahè maparè. ");
INSERT INTO sbl_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Hay tawo ya ampanginsolto nin tatay na boy pirmin kontra ha nanay na, hay dapat ha ombayroy tawo ay toka-en nin aw-agila ya mata na, boy hay nawini na ay kona-en nin aw-owak. ");
INSERT INTO sbl_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Ma-in tatloy bagay ya kapapa-ispanta; ah, apat kalì ya bagay ya agko ma-intindiyan: ");
INSERT INTO sbl_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","no pangno anlompad ya agila ha katatag-ayan, no pangno ampandakap ya otan ha babon bato, no pangno nin hay barko ay anlomtaw nin ampowayo ha dagat, boy no pangno ampanlabi ya lalaki ha mihay dalaga. ");
INSERT INTO sbl_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Ombayri itaman ya tawtigè nin babayi ya alwan tapat ha ahawa: makilalaki ya biha na halita-en ya ombayri: “Ayin akon ginawà ya kala-etan.” ");
INSERT INTO sbl_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Ma-in tatloy bagay ya ampakapahyab nin tawtawo bayri ha babon lotà; ah, apat kalì: ");
INSERT INTO sbl_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Hay alilà ya ampag-in arì, hay tawoy tangah ya ampagkama-in nin kaganawan bagay ya labay nan ma-ekan, ");
INSERT INTO sbl_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","hay babayi ya masongit ya nakapag-ahawa, boy hay alilà ya babayi ya ampakapahlin nin amo nay babayi. ");
INSERT INTO sbl_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Ha babon lotà ay ma-in apat ya klasin ayop ya maski pagkayawyamò ay masyadon mangaronong: ");
INSERT INTO sbl_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","aw-ayà ya maski mangakapey, no ka-ingitan ay ampakatipon nin pamamangan; ");
INSERT INTO sbl_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","kawkoniho man ya ma-in kakapeyan ay ampakagawà nin pa-iriyan ha mabatoy dogal; ");
INSERT INTO sbl_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","dawdoron man ya maski ayin arì ay ampigogoropo nin lompad nin ma-ayos; ");
INSERT INTO sbl_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","boy tawtikì ya maski ma-arì kemkemen ha kayamo-an ay ampa-iri ha pawpalasyo. ");
INSERT INTO sbl_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Ma-in tatloy bagay ya disinti boy postoran manige-tigè, ah, apat kalì: ");
INSERT INTO sbl_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","liyon ya pinakamakhaw ha aw-ayop boy ayin angkalimowan; ");
INSERT INTO sbl_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","tatyaw ya pirmin ampamakirkir; toron kanding ya ampagmanada; boy arì ya anti ha arapan nin tawtawowan na. ");
INSERT INTO sbl_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","No nagmatag-ay ka nin banà ha katangahan mo boy ampagplano ka nin mala-et ay mag-ihip-ihip ka. ");
INSERT INTO sbl_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","No weyweyen moy gatas ay lomway mantikilya. Hay balongoh itaman no bontalen ay magdadayà. Hay pahang man ay ampangibatan nin kagolowan. ");
INSERT INTO sbl_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Habayti ya wawwawali koni Limowil ya arì nin Massa ya intorò kona nin nanay na. ");
INSERT INTO sbl_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","“Hika ya sarili kon anak ya anlabiyen ko; in-anak kata nin banà ha pawpanalangin ko. Hapa-eg ay ombayri ya iwawali ko komo. ");
INSERT INTO sbl_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Agmo sayangen ya hokaw mo boy kowalta mo ha bawbabayi, ta hay ombayroy gawgawà ay ampakahirà nin aw-arì. ");
INSERT INTO sbl_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Leng-en mo bayti, Limowil. Hay aw-arì ay alwan dapat minom alak ni maghangad nin minom nin anyaman ya makalahing; ");
INSERT INTO sbl_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","ta no minom hila ay maliwawan lay lawlayih boy agla pa-alaga-an ya karapatan nin manga-irap. ");
INSERT INTO sbl_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Hay tawoy marani anan mati ay ma-arì pa-inomen nin alak. Ombayro simpri ha tawoy angkagoloy nakem nin banà ha kalele-an. ");
INSERT INTO sbl_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Pa-olayan hilan minom emen la maliwawan ya ka-irapan boy kalele-an la. ");
INSERT INTO sbl_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","“Idipinsa moy tawtawo ya ayin pakakaya boy ipaglaban moy karapatan la. ");
INSERT INTO sbl_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Idipinsa moy karapatan nin tawtawoy manga-irap boy ampipanga-ilangan, boy mag-in kan mahampat ha panonosga mo konla.” ");
INSERT INTO sbl_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Ma-irap makakit nin pag-ahaway babayi ya mahampat. Hay ahaway mahampat ay ma-alagà nin igit ha aw-alahas. ");
INSERT INTO sbl_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Hiya ay ampagkompiyansawan nin ahawa na boy banà kona, hay ahawa na ay ahè mag-irap no alwan magkama-in nin ka-inomayan. ");
INSERT INTO sbl_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Leleg biyay na ay agna ampanggaw-an kala-etan ya ahawa na no alwan panay kahampatan. ");
INSERT INTO sbl_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Hiya ay mahipeg mangabel nin dolo ya yarì ha habot topa boy maganday klasin doloy mapotì. ");
INSERT INTO sbl_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Hay ahaway babayi ya mahampat ay ampantan nin pamamangan no angka-ibat ya ha marayò nin bilang anggaw-en nin barko ya ampantan pamamangan. ");
INSERT INTO sbl_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Biha homilà ya allo no bayombokah, hiya ay ampibangon ana ta mangihandà nin pamamangan pamilya na boy an-imanda na no anyay gaw-en nin aw-alilà nay bawbabayi. ");
INSERT INTO sbl_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Hay ahaway babayi ya mahampat, hay natipon nay kowalta ha sarili nan pagsisikap ay panaliw nan lotà ya tanamanan nin obas. ");
INSERT INTO sbl_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Hiya ay masikap magtrabaho, makhaw, boy mahipeg. ");
INSERT INTO sbl_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Ampa-alaga-an nay bawbagay ya anggaw-en na boy maskin yabi ay ampagtrabaho ya. ");
INSERT INTO sbl_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Hiya ay ampanggawà nin hoy-ot ya abelen na nin pagdolo la. ");
INSERT INTO sbl_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Abirtoy gamet na ha manga-irap boy mabibi-iyen ya ha ampipanga-ilangan. ");
INSERT INTO sbl_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Agya angkahlak no lomateng ya pana-on ya malay-ep, ta hay pamilya na ay ma-in doloy panlay-ep. ");
INSERT INTO sbl_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Hiya ay ampanggawà nin mangaganday apin kama boy hay dawdolo na ay mangaganday klasin dolo ya kolor obi. ");
INSERT INTO sbl_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Hay ahawa na ay balaybalay ta miha ha ampipamo-on bayro ha dogal la. ");
INSERT INTO sbl_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Hay mahampat ya ahaway babayi ay ampanggawà nin dawdolo boy sawsintoron ya ilakò na ha nawnigosyanti. ");
INSERT INTO sbl_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Hiya ay makhaw boy kagalanggalang, boy agya angkahlak ha anyaman ya lomateng. ");
INSERT INTO sbl_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Hiya ay maba-it boy hay pag-i-ilgo na ay ma-in karonongan. ");
INSERT INTO sbl_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Mahipeg yan magtrabaho boy pirmi nan an-asikasowen ya panganga-ilangan nin pamilya na. ");
INSERT INTO sbl_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Hiya ay ampa-alaga-an nin aw-anak na, boy amporiyen ya nin ahawa na nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","“Malakè ya mahampat ya babayi ya ma-in ahawa, piro hika ya pinakamahampat konlan kaganawan.” ");
INSERT INTO sbl_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Hay postora ay ampakaloko boy hay kagandawan ay ampangopah, piro hay babayi ya anggomalang ha Pangino-on ay dapat poriyen. ");
INSERT INTO sbl_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Hay ahaway babayi ya mahampat ay dapat igwà kona ya ka-eteban nin ginawà na boy dapat yan poriyen nin kaganawan.");
INSERT INTO sbl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Habayti ya nakalistay ngawngalan nin tawo ya pinangibatan lahì ni Pangino-on Hisokristo ya alalak ni Dabid ya alalak itaman ni Abraham. ");
INSERT INTO sbl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Hay anak ni Abraham ay hi Isak; hay anak ni Isak ay hi Hakob; hay anak ni Hakob ay hi Hoda boy pawpatel na; ");
INSERT INTO sbl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","hay anak ni Hoda koni Tamar ay hi Paris boy hi Sara; hay anak ni Paris ay hi Isrom; hay anak ni Isrom ay hi Aram; ");
INSERT INTO sbl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","hay anak ni Aram ay hi Aminadab; hay anak ni Aminadab ay hi Nason; hay anak ni Nason ay hi Salmon; ");
INSERT INTO sbl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","hay anak ni Salmon koni Rahab ay hi Bowos; hay anak ni Bowos koni Rot ay hi Obid; hay anak ni Obid ay hi Dyisi; ");
INSERT INTO sbl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","hay anak ni Dyisi ay hi Arì Dabid. Hay anak ni Arì Dabid do ha ahawa ni Oriyas ay hi Solomon; ");
INSERT INTO sbl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","hay anak ni Solomon ay hi Robowam; hay anak ni Robowam ay hi Abiyas; hay anak ni Abiyas ay hi Asa; ");
INSERT INTO sbl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","hay anak ni Asa ay hi Hosapat; hay anak ni Hosapat ay hi Horam; hay anak ni Horam ay hi Osyas; ");
INSERT INTO sbl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","hay anak ni Osyas ay hi Hotam; hay anak ni Hotam ay hi Akas; hay anak ni Akas ay hi Isikiyas; ");
INSERT INTO sbl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","hay anak ni Isikiyas ay hi Manasis; hay anak ni Manasis ay hi Amos; hay anak ni Amos ay hi Hosyas; ");
INSERT INTO sbl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","hay anak ni Hosyas ay hi Hikonyas boy pawpatel na ya in-anak hin pana-on nin hay Aw-israylita ay dinakep ta gintan ha Babilonya. ");
INSERT INTO sbl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hapa-eg, hin nagtan anay Aw-israylita ha Babilonya, hi Hikonyas ay nagka-anak. Hay anak na ay hi Salatiyil; hay anak ni Salatiyil ay hi Sorobabil; ");
INSERT INTO sbl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","hay anak ni Sorobabil ay hi Abiyod; hay anak ni Abiyod ay hi Ilyakim; hay anak ni Ilyakim ay hi Asor; ");
INSERT INTO sbl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","hay anak ni Asor ay hi Sadok; hay anak ni Sadok ay hi Akim; hay anak ni Akim ay hi Ilyod; ");
INSERT INTO sbl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","hay anak ni Ilyod ay hi Ilyasar; hay anak ni Ilyasar ay hi Matan; hay anak ni Matan ay hi Hakob; ");
INSERT INTO sbl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","hay anak ni Hakob ay hi Hosi ya ahawa ni Mariya. Hi Mariya ya nangi-anak koni Apo Hisos ya an-ingaten et Kristo. ");
INSERT INTO sbl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ha ombayri, ma-in labin-apat ya lahì pa-ibat koni Abraham angga koni Arì Dabid; boy pa-ibat koni Arì Dabid ay labin-apat et ya lahì angga hin hay Aw-israylita ay dinakep ta gintan ha Babilonya; boy pa-ibat hin nagtan hila ha Babilonya ay nagkama-in et nin labin-apat ya lahì angga hin in-anak hi Pangino-on Hisokristo. ");
INSERT INTO sbl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ombayri ya pangyayari ya tongkol ha pangi-anak koni Pangino-on Hisokristo; hi Mariya ya nanay na ay kaba-an ni Hosi; piro biha hila nilamo, hi Mariya ay da-an anan naboktot ha panggogomawà nin Ispirito nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hi Hosi ya kaba-an ni Mariya ay pirmin ampanggawà kahampatan ta anhonolen nay kawkapanogo-an nin Diyos. Kayà nagdisisyon ya nin hira-en nay pamikaba-an la nin ayin makatandà ta agna labay mipareng-ey hi Mariya. ");
INSERT INTO sbl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Piro mintras an-ihipen bayti ni Hosi, hay mihay anghil nin Pangino-on ay napakit kona ha taynep ya naghalità kona nin ombayri: “Hosi ya alalak ni Dabid, agmo pag-alanganan nin pag-ahawa hi Mariya, ta hay imboktot na ay ha pangogomawà nin Ispirito nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Manganak yan lalaki ya pangalanan mon Hisos, ta habayti hi Hisos ya mangilibri nin tawtawo na ha kawkasalanan la.” ");
INSERT INTO sbl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kaganawan nin habayti ya nangyari ay nagkapeteg ya impaholà nin Diyos ha propita na ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mihay dalagay malinis ta ahè nagalaw nin lalaki ay mamoktot. I-anak nay mihay lalaki ya ingaten Imanwil.” (Hay labay totolen nin Imanwil ay “Anti kontamoy Diyos”.) ");
INSERT INTO sbl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hapa-eg, hin naka-imata hi Hosi ay ginawà na baytoy immanda kona nin hatoy anghil. Nilako na hi Mariya ta pinag-ahawa na. ");
INSERT INTO sbl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piro mintras ahè et in-anak ni Mariya baytoy imboktot na ay nanatili yan malinis ta agya pinakilalayan ni Hosi. Hapa-eg, hin nilomwah baytoy anak ay Hisos ya impangalan kona ni Hosi. ");
INSERT INTO sbl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hi Apo Hisos ay in-anak ha banowan Bitlihim ha probinsyan Hodiya mintras ampag-arì hi Hirodis. Hin habayton pana-on, do ha siyodad nin Hirosalim ay ma-in mangaronong ya lawlalaki ya nakalateng nin na-ibat ha marayò ya dogal ha bandan baytan. Hay an-aralen lan habayto ay tawtigè nin bawbito-en. ");
INSERT INTO sbl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hapa-eg, nagpastang hila, “Ayri,” wanla, “baytoy in-anak ya arì nin Hawhodiyo? Ha bandan baytan ya inibatan nawen ay nakit nawen ya bito-en ya pakatanda-an kona; kayà nako kayi bayri nin homamba kona.” ");
INSERT INTO sbl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hin nabalita-an bayti ni Arì Hirodis ay nagolo ya nakem na kateng kaganawan tawo bayro ha Hirosalim. ");
INSERT INTO sbl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaganawan po-on nin pawparì kateng mawmangitorò nin kawkapanogo-an ya hinolat ni Moysis ay pinatipon ni Arì Hirodis ta pinastang na hila, ya wana, “Ayri dapat i-anak hi Kristo ya impangakò nin Diyos?” ");
INSERT INTO sbl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tinombay hila kona, “Ha banowan Bitlihim,” wanla, “ya angkasakopan nin probinsyan Hodiya ta ombayri ya hinalità nin Diyos ya inholat nin propita: ");
INSERT INTO sbl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tawtawon Bitlihim, ha tegteg nin pawpo-on ha Hoda, hay dogal moyo ay ahè mapantayan, ta komoyo mangibat ya po-on ya mama-alà ha tawtawo koy aw-inalalak ni Israyil.’” ");
INSERT INTO sbl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hapa-eg hatoy mangaronong ya lawlalaki ay sikriton impa-ingat ni Arì Hirodis, ta pinakapapastang na konla no nakano nilomwah baytoy bito-en. ");
INSERT INTO sbl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hin natanda-an na ay inhogò na hila, ya wana, “Mako kawo ha Bitlihim ta pakatikaptikapen moyo baytoy anak. Pamakakit moyo kona ay magbira kawo bayri, ta ibalità moyo kongko emen ako itaman makalako bayro nin homamba kona.” ");
INSERT INTO sbl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ha ombayroy immanda ni Arì Hirodis ay nanigè hilayna. Mintras anti hila ha daan ay nakit layna et baytoy bito-en ya nakit la ha bandan baytan. Habayto ay ampangona konla nin magpalako ha Bitlihim anggan tinonggen ha ogton kama-inan nin hatoy anak. ");
INSERT INTO sbl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Banà bayri ha bito-en ya nakit la ay nagtowà hilan masyado. ");
INSERT INTO sbl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nilomo-ob hila do ha bali ya kama-inan nin hatoy anak kateng nanay na ya hi Mariya. Hin nakit la baytoy anak ay nanlokob hilan hinomamba kona, biha la inabriyan baytoy gawgitan la ta inggawà la kona ya gintò, kamanyang, boy mira. ");
INSERT INTO sbl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hapa-eg, ha taynep nin habaytoy mangaronong ya lawlalaki ay hinalità konla nin Diyos ya aghila magbira koni Arì Hirodis. Kayà nagdaan hila ha kanayon ya daan nin norong ha sarili lan dogal. ");
INSERT INTO sbl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hin naka-alih ana baytoy mangaronong ya lawlalaki, hay mihay anghil nin Pangino-on ay napakit koni Hosi ha taynep ta naghalità kona, “Mibangon ka,” wana, “ta haba-in ya anak kateng nanay na ay ipowayo mon gitan ha nasyon Ihipto. Manatili kawo bayro angga ha halita-en ko komoyoy pagbira moyo, ta haba-in ya anak ay tikapen ana ni Arì Hirodis ta labay nan patyen.” ");
INSERT INTO sbl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kayà nibangon hi Hosi ta habayto et nin yabi ay gintan na baytoy mita-anak nin magpalako ha Ihipto. ");
INSERT INTO sbl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bayro hila napa-iri anggan nati hi Arì Hirodis. Habayti ya nangyari ay nagkapeteg ya impaholà nin Pangino-on ha propita na ya ombayri ya pagkahalità: “Hay anak koy lalaki ay hinagyat kon mog-alih ha Ihipto.” ");
INSERT INTO sbl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hapa-eg, hin natanda-an ni Arì Hirodis ya niloko ya nin hatoy mangaronong ya lawlalaki ay namahang yan masyado. Ha nalengè nay hinalità nin hatoy mangaronong ya lawlalaki no nakano nilomwah baytoy bito-en ay bayro na kinarkola ya idad nin hatoy anak. Hapa-eg, inhogò nay hawhondalò nan mako ha banowan Bitlihim boy ha kaganawan dogal ya marani bayro, ta impapati nay kaganawan anak ya lalaki ya idad loway ta-on boy kolang ha lowa. ");
INSERT INTO sbl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Habayti ya pangyayari ay nagkapeteg ya holà ni propita Hirimiyas ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ha Rama ay angkalengè ya pami-angaw-angaw ya ampi-a-aniton banà ha masyadoy kalele-an. Ampi-a-anitowan ni Rakil ya aw-anak na. Agna labay pahahaliwa ta hay aw-anak na ay nati ana.” ");
INSERT INTO sbl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hapa-eg hin nati ana hi Arì Hirodis, hay mihay anghil nin Pangino-on ay napakit koni Hosi ha taynep hin anti hila et ha Ihipto, boy naghalità kona nin ombayri: ");
INSERT INTO sbl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mibangon ka ta gitan mo ba-in ya anak kateng nanay na nin magbira ha nasyon Israyil, ta nati ana baytoy labay mamati nin haba-in ya anak.” ");
INSERT INTO sbl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kayà nibangon hi Hosi ta kinwa na baytoy anak kateng nanay ta gintan na nin nagbira ha nasyon Israyil. ");
INSERT INTO sbl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piro hin nabalita-an ni Hosi ya hay hinomagilin nag-arì bayro ha probinsyan Hodiya ay hi Arkilawo ya anak ni Hirodis ay nalimo yan magbira bayro. Hapa-eg, impataynep ana et koni Hosi ya agya mako bayro no alwan mako ya ha probinsyan Galiliya. ");
INSERT INTO sbl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kayà napa-iri hila ha banowan Nasarit. Habayti ya ginawà la ay nagkapeteg baytoy holà nin propita ya ombayri ya pagkahalità: “Hiya ay ingaten Nasarino.” ");
INSERT INTO sbl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hin ampa-iri et hili Apo Hisos ha Nasarit, hi Howan Mamiminyag ya anti ha powiray dogal ha probinsyan Hodiya ay nag-ompisan mangaral, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Paghehean moyoy kawkasalanan moyo, ta hay pamomo-on nin Diyos ay maranina.” ");
INSERT INTO sbl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Habayti hi Howan Mamiminyag ya antokoyen hin hato ni propita Isayas hin hinalità nay ombayri: “Ma-in mihay tawoy ampibobolyaw ha powiray dogal nin ombayri: ‘Homandà kawo ha panlomateng nin Pangino-on nin bilang ha ampangihandà nin daan ya kowinta pagdanan na emen ayin maka-abalà kona.’” ");
INSERT INTO sbl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Hay dolo ni Howan ay yarì ha habot nin ayop ya kamel boy hay tagkeh na ay yarì ha katat. Hay pamamangan na ay dawdoron boy polot panilan. ");
INSERT INTO sbl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kaganawan tawo ha siyodad nin Hirosalim ya angkasakopan nin probinsyan Hodiya kateng ha mitaligmang balah nin Hordan ay nako koni Howan. ");
INSERT INTO sbl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kaganawan nangihokò nin kawkasalanan la ha Diyos ay bininyagan ni Howan ha balah nin Hordan. ");
INSERT INTO sbl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Piro hin nakit ni Howan ya malakè ya rilihyoso ya Pawparisiyo boy Sawsadosiyo ya ampako konan pabinyag ay ombayri ya hinalità na konla: “Hikawo ay bilang ha aw-otan ya ampagsikap nin mog-alih ha dawdikot ya angkapo-olan. Warì makalibri kawo ha iparosa komoyo nin Diyos no hay paghehe moyo ay ha halità bongat? ");
INSERT INTO sbl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gaw-en moyoy bawbagay ya makapapteg nin hikawo ay nagheheyna ha kawkasalanan moyo. ");
INSERT INTO sbl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Agmoyo halita-en nin makalibri kawo banà ta hikawo ay aw-inalalak ni Abraham. Anhalita-en ko komoyo ya maskin habayti ya bawbatoy anti bayri ay magawà nin Diyos nin aw-inalalak ni Abraham. ");
INSERT INTO sbl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hay payakol ay naka-a-awag ana nin pamoton po-on kayo. Kaganawan po-on kayo ya ahè ampamonga nin maganda ay ampotohen ta itapon ha apoy. Ombayri ya panonosga komoyo nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Hiko ay ampaminyag komoyo ha lanom ta hikawo ay nipaghehe ha kasalanan, piro ma-in anlomateng ya mas makapangyariyan dinan hiko. Maski mantan sapatos na ay alwa kon karapatdapat. Hiya ya mangibinyag komoyo nin Ispirito nin Diyos, boy manobok komoyo ha pangiparanas na komoyon kadya-dya-an nin bilang ha an-iparaan ha apoy. ");
INSERT INTO sbl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hiya ay bilang ha ampamalohboh ta hay pali ya malinis ana ay ikamalig, piro hay aw-apah ay ipo-ol na ha apoy ya ahè maparè.” ");
INSERT INTO sbl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hapa-eg hi Apo Hisos ya anti ha probinsyan Galiliya ay nako bayro ha balah nin Hordan ta pabinyag koni Howan. ");
INSERT INTO sbl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piro ahè labay gaw-en ni Howan; kayà hinalità na, “Alwan tamà ya hikoy maminyag komo, no alwan hiko ya dapat mon binyagan.” ");
INSERT INTO sbl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piro hinalità kona ni Apo Hisos, “Sigina,” wana, “ta habayti ya paraan emen ta magawà ya kalabayan nin Diyos.” Hapa-eg, hi Apo Hisos ay bininyagan ni Howan. ");
INSERT INTO sbl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hin nabinyagan ana hi Apo Hisos, antimano, hiya ay nilomakat bayro ha lanom. Hay langit ay naglo-at boy nakit nay Ispirito nin Diyos ya ampag-aypà nin bilang kalapati ya an-omogpà kona. ");
INSERT INTO sbl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hapa-eg, ma-in bosis ya nangibat ha katatag-ayan ha kama-inan nin Diyos ya ampaghalità, ya wana, “Habayti ya mimihay Anak koy pinakalabilabi ko ya ampakapakonsowilo kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hapa-eg hi Apo Hisos ay pinangonawan nin Ispirito nin Diyos nin mako ha powiray dogal ta bayro ya tokso-en ni Satanas. ");
INSERT INTO sbl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ha lo-ob apatapò ya allo ni Apo Hisos bayro ay agya nangan; kayà binomitil ya. ");
INSERT INTO sbl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hapa-eg hi Satanas ay napakarani konan naghalità, “No hika,” wana, “ay Anak nin Diyos, habayti ya bawbato ay mandawan mo nin mag-in tinapay.” ");
INSERT INTO sbl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piro tinobay ya ni Apo Hisos, ya wana, “Ha Halità nin Diyos ay nakaholat ya ombayri: ‘Hay tawo ay alwan bongat ha pamamangan mabiyay, no alwan ha balang halità ya anhalita-en nin Diyos.’” ");
INSERT INTO sbl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hapa-eg hi Apo Hisos ay gintan ni Satanas ha masagradoy siyodad nin Hirosalim, ta in-olì na ya ha pinakamatag-ay ya bobongan bali nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“No hika,” wani Satanas, “ay Anak nin Diyos ay magtaboy ka, ta hay nakaholat ha Halità nin Diyos ay ombayri: ‘Ihogò nin Diyos ya aw-anghil nan mangi-atap komo ha kawkadisgrasyawan, boy alalayan la ka emen hay bitih mo ay ahè makhitan nin bato.’” ");
INSERT INTO sbl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tinombay ana et hi Apo Hisos koni Satanas, “Piro ombayri itaman,” wana, “ya nakaholat ha Halità nin Diyos: ‘Agmo hoboken ya Pangino-on mon Diyos.’” ");
INSERT INTO sbl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hapa-eg hi Apo Hisos ay gintan ana et ni Satanas ha pagkatag-ay bakil, ta impakit na konay kaganawan ka-ari-an ha babon lotà kateng mangaganday bawbagay ya anti bayro. ");
INSERT INTO sbl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hinalità ana et kona ni Satanas, “Igwà ko komo,” wana, “ba-in ya kaganawan nin haba-in no manlokob kan homamba kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hapa-eg, tinombay kona hi Apo Hisos, “Mog-alih ka bayri,” wana, “Satanas, ta ombayri ya nakaholat ha Halità nin Diyos: ‘Homamba ka ha Pangino-on mon Diyos boy hiyan bongat ya pagsirbiyan mo.’” ");
INSERT INTO sbl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hapa-eg, nog-alih hi Satanas biha itaman ma-in aw-anghil ya nakalateng nin nangasiwà koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hin nabalita-an ni Apo Hisos ya hi Howan ay impiriso, hiya ay norong ha probinsyan Galiliya. ");
INSERT INTO sbl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Piro agya naboyot ha Nasarit ya sarili nan banowa, ta tampol yan nako nin napa-iri ha banowan Kapirnawom ha ambay Dagat nin Galiliya ya sakop nin dogal ya pina-iriyan ni Sabolon boy Niptali. ");
INSERT INTO sbl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Habayti ay nangyari emen magkapeteg baytoy holà hin hato ni propita Isayas ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Hay dawdogal ya an-ingaten Sabolon boy Niptali ay ha babà Dagat nin Galiliya boy kagmang itaman balah nin Hordan, Galiliya ya ampa-iriyan nin malakè ya alwan Hawhodiyo. ");
INSERT INTO sbl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hay tawtawo bayro ay mareglem ya pagnanakem banà ha kasalanan la. Piro nakit la baytoy nako konlay bilang itaman hawang. Hatoy tawtawo bayro ya anti ha karegleman ya ampambin kamatyan ay nahawangan.” ");
INSERT INTO sbl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hapa-eg pa-ibat hin habayto, hi Apo Hisos ay nag-ompisan nangaral, ya wana, “Paghehean moyoy kawkasalanan moyo, ta hay pamomo-on nin Diyos ay maranina.” ");
INSERT INTO sbl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hin ampagdaan hi Apo Hisos ha ambay Dagat nin Galiliya ay nakit nay mipatel ya manlalapet. Habayti ya mipatel ay hi Andris boy hi Simon ya an-ingaten et Pidro. Hin habayto, hila ay ampaninsoro. ");
INSERT INTO sbl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hinalità konla ni Apo Hisos, “Makilamo kawo kongko,” wana, “ta gaw-en katawon mangipakarani kongko nin tawtawo.” ");
INSERT INTO sbl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Antimano, imbalag lay sinsoro la ta nakilamo hila koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hin nowakoyna et hi Apo Hisos ay nakit na hi Santiyago boy hi Howan ya mipatel. Anti hila ha bangkà kalamo la hi Sibidiyo ya tatay la ta an-ayomawen lay aw-eket la. Hi Santiyago boy hi Howan ay hinagyat ni Apo Hisos nin makilamo kona. ");
INSERT INTO sbl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Antimano, inalihan lay bangkà la kateng tatay la ta nakilamo hila koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hapa-eg hi Apo Hisos ay nako ha kaganawan dogal ha probinsyan Galiliya ta ha hawhimba-an nin Hawhodiyo, hiya ay ampanorò, boy an-i-aral nay Mahampat ya Balità ya tongkol ha pamomo-on nin Diyos. Hiya ay ampamakahampat nin kaganawan klasin masakit boy dipirinsya nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Banà bayri ha gawgawà ni Apo Hisos, hiya ay nibantog ha kaganawan dogal ha probinsyan Sirya. Kayà kaganawan tawo bayro ya ampagdya-dyà nin banà ha mawmasakit boy dawdipirinsya ay gintan koni Apo Hisos. Hilay kaganawan ay pinakahampat na kateng hatoy tawtawoy pinahokan dawdimonyo, tawtogawen, boy pawpolonen. ");
INSERT INTO sbl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Banà bayri, maski ayri ya nako ay hinono yan malakè ya tawoy na-ibat ha probinsyan Galiliya, probinsyan Dikapolis, siyodad nin Hirosalim, boy ha kanayon ya dawdogal bayro ha probinsyan Hodiya, kateng tawtawoy ampa-iri ha baytan balah nin Hordan. ");
INSERT INTO sbl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hin nakit ni Apo Hisos baytoy kalak-an tawo ay nilomakat ya ha bakil ta bayro ya niknò. Hapa-eg hay aw-alagad na ay napakarani kona, ");
INSERT INTO sbl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","boy tinoro-an na hila, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Makalmà ya tawtawoy ma-aypà ya nakem, ta hila ay makapakilamo ha tawtawoy ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Makalmà ya tawtawoy ma-in an-ikalelè, ta hila ay hahaliwawen nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Makalmà ya tawtawoy ma-amey ya nakem, ta tanggapen lay impangakò nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Makalmà ya tawtawoy angkahabek nin gomawà kalabayan nin Diyos, ta sigoradon mapasasà hilan kahampatan. ");
INSERT INTO sbl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Makalmà ya tawtawoy ampangingangalo ha kanayon, ta hila ay ingalowan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Makalmà ya tawtawoy bo-ò ya nakem ha Diyos, ta lano ay makit lay Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Makalmà ya tawtawoy mapamisondò, ta hila ay ingaten nin Diyos nin aw-anak na. ");
INSERT INTO sbl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Makalmà ya tawtawoy ampadya-dya-an nin banà ha panggawà lan kalabayan nin Diyos, ta hila ay makapakilamo ha tawtawoy ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Makalmà kawo no insoltowen kawo boy padya-dya-an nin tawtawo, boy no banà ha panhohomonol moyo kongko ay maghalità hila nin hari-harì ya klasin kabongkokan ya panay kala-etan ya kontra komoyo. ");
INSERT INTO sbl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ombayro ya pamadya-dyà ya ginawà ha pawpropita hin hato. Kayà magtowà kawo boy pakaliga kawo, ta malhay ya primyo ya an-i-antì komoyo ha katatag-ayan ha kama-inan nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Hinalità et ni Apo Hisos, “Hay ka-alimbawa-an moyo,” wana, “ay ahin ya pampalahap nin pamamangan nin tawtawo, ta hikawo ya ampanorò konla no pangno hila mag-in mahampat. Piro no hay ahin ay na-lihan anan alat, pangno et mapa-alat nin oman? Habayti ay ayin anan alagà; kayà an-itapon ana boy antorakan nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hay ka-alimbawa-an moyo et ay hawang ya ampakahawang nin babon lotà. Hay siyodad ya anti ha matag-ay ya dogal ay angkakit nin kaganawan ta angkahawangan. ");
INSERT INTO sbl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Ayin tawoy mamagket nin kingki biha na halokoban nin kalaying, no alwan igwà na ha talagan pangigwa-an emen mahawangan ya kaganawan anti ha lo-ob bali. ");
INSERT INTO sbl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mag-in kawon bilang ombayro ha kingki ya ampakab-in hawang. Dapat kawon magpakahawang ha tawtawo ha pangipakit moyo konla nin gawgawà moyoy mangahampat emen la poriyen ya Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na.” ");
INSERT INTO sbl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Hinalità et ni Apo Hisos, “Agmoyo ihipen nin kayà ako nako bayri ay alihan kon alagà ya kawkapanogo-an ya inggawà ni Moysis boy hinolat nin pawpropita hin hato. Ahè! Hay pamako ko bayri ay emen ko mageperan baytoy kawkapanogo-an. ");
INSERT INTO sbl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tanda-an moyo bayti ya halita-en ko komoyo: maski ayin anay langit boy lotà, hay pinakamayamò parti ha litra nin kawkapanogo-an ay ahè ma-alih anggan ahè mageperan ya kaganawan. ");
INSERT INTO sbl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kayà hinoman ya ahè anhomonol ha maski pinaka-oltimo ya kapanogo-an, boy ombayro et ya itorò na ha kanayon ay hiya ya pinaka-oltimoy tawo ha ampag-ari-an nin Diyos. Piro hinoman ya anhomonol ha kawkapanogo-an boy an-itorò na ha kanayon ay hiya ya lalò ma-in dangal ha ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anhalita-en ko komoyo ya no hay Pawparisiyo boy mawmangitorò nin kawkapanogo-an ay agmoyo ma-igitan ha kahampatan ay agkawo makalako ha dogal ya ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hinalità et ni Apo Hisos, “Nalengè moyoyna,” wana, “bayti ya kapanogo-an ya inggawà hin hato ni Moysis ya ombayri: ‘Agka mamatin kapara mon tawo ta hinoman ya mamatin kapara nan tawo ay i-arap ha hosgado para hosgawan.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piro habayti ya anhalita-en ko komoyo: hinoman ya mamahang ha kapara nan tawo ay i-arap ha hosgado; hinoman ya maghalità ha kapara nan tawo nin ‘Ayin kan kowintan tawo!’ ay i-arap itaman ha hosgado. Hinoman simpri ya maghalità nin ‘Lokoloko ka!’ ha kapara nan tawo ay mipalako ha impirno. ");
INSERT INTO sbl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kayà no anti ka ha kolob bali nin Diyos ta ma-in kan igwà ya para ha Diyos, biha ma-ihipan mo ya ma-in kan patel ya kontra komo ");
INSERT INTO sbl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ay ibalag mo pon bayto ya para ha Diyos ta mako kan makisondò ha patel mo. Pangayarì ay igwà moyna bayto ya para ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“No ma-in tawoy makon mangidimanda komo ay tampol kan makisondò kona mintras ma-in et pana-on, ta no mi-abot kawoyna ha hosgado, maka hay howis ay mangigwà komo ha polis ya mangipahok komo ha pirisowan. ");
INSERT INTO sbl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anhalita-en ko komo: no nakapiriso kayna ay agkayna makalikol anggan agka makabayad nin dapat mon imolta.” ");
INSERT INTO sbl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ombayri et ya kapanogo-an ya inggawà ni Moysis,” wani Apo Hisos: “‘Agka mamabayi o makilalaki.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piro anhalita-en ko komoyo: hinoman ya lalaki ya manegteg ha babayi nin ma-in mala-et ya intinsyon ay bilang ya simprin namabayi. ");
INSERT INTO sbl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","No hay wanan mata mo ay makapipakasalanan komo ay alihen mo ta itapon mo. Mas mahampat et ya ayin kan mihay mata kisa komplitoy nawini mo no itapon ka ha impirno. ");
INSERT INTO sbl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No hay wanan gamet mo ay makapipakasalanan komo ay potohen mo ta itapon mo. Mas mahampat et ya ayin kan mihay gamet kisa komplitoy nawini mo no mipalako ka ha impirno.” ");
INSERT INTO sbl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ombayri et ya kapanogo-an ya hinolat ni Moysis,” wani Apo Hisos: “‘Hinoman ya lalaki ya mangihiyay nin ahawa ay ka-ilangan na yan biyan kaholatan ya kaptegan nin hila ay nihiyay.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piro anhalita-en ko komoyo: hinoman ya lalaki ya mangihiyay nin ahawa ya ahè ampakilalaki ay hiya ya ampambin bara-nan para makapagkasalanan ya ahawa na nin pamakilalaki no mag-ahawa yan oman; boy hinoman ya mag-ahawa do ha ahawa nay inhiyay na ay magkasalanan nin pamabayi.” ");
INSERT INTO sbl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hinalità et ni Apo Hisos, “Miha et ha kawkapanogo-an ya inggawà ni Moysis ay ombayri: ‘Agmo hira-en ya pangakò mo ha Pangino-on, no alwan toparen mon gaw-en ya pinanompa-an moy pawpangakò mo.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Piro anhalita-en ko komoyo: no mangakò ka ay agka maghompà nin, ‘Magonaw man ya langit boy babon lotà no alwan peteg bayti ya anhalita-en ko komo,’ ta hay kama-inan nin Diyos ay ha katatag-ayan langit ya trono na, boy hay lotà ay pagtorakan nin bitih na. Agmo simpri halita-en ya, ‘Mahirà man ya siyodad nin Hirosalim no alwan peteg bayti ya anhalita-en ko komo,’ ta hay Hirosalim ay siyodad nin Arì ya ayin kapantay. ");
INSERT INTO sbl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni olo mo ay agmo gamiten nin maghompà ta agmo magawà nin papoti-en o pangititen ya maski miha ha hawhabot mo. ");
INSERT INTO sbl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Halita-en mon bongat ya, ‘Awò,’ no talagan labay mo. No agmo labay ay halita-en moy, ‘Ahè,’ No maghompà kay mangakò ay alwan mahampat ta hay ombayro ay angka-ibat koni Satanas.” ");
INSERT INTO sbl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ombayri et,” wani Apo Hisos, “ya miha ha kawkapanogo-an ya inggawà ni Moysis: ‘No ma-in nandisgrasyan mata nin kapara nan tawo ay gantiyen simprin disgrasyawen ya mata na; boy no ma-in nangalin ngipen nin kapara nan tawo ay gantiyen ya simpri nin alihan ngipen.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piro anhalita-en ko komoyo: agkawo mamaweh nin kala-etan ha tawoy nakagawà komoyon kala-etan. No ma-in tawoy manampal nin kagmang pingih mo ay i-arap mo et konan ipatampal ya kagmang. ");
INSERT INTO sbl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No ma-in simpri nin mangidimanda komo ta labay nan kowen ya dolo mo ay igwà mo kona kateng alimenmen mo. ");
INSERT INTO sbl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No ma-in mamilit komon mantan karga na nin mihay kilomitroy dayò ay gaw-en mon loway kilomitro ya pantan mo. ");
INSERT INTO sbl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No ma-in simprin makikwa komo ay biyan mo, boy no ma-in mandam komo ay paraman mo.” ");
INSERT INTO sbl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hinalità ana et ni Apo Hisos, “Ha kawkapanogo-an ya inggawà et ni Moysis ay ombayri: ‘Labiyen moy amigo mo boy pag-inakitan moy ka-away mo.’ ");
INSERT INTO sbl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piro habayti ya halita-en ko komoyo: labiyen moy kawka-away mo boy ipanalangin mon ingalowan baytoy ampipamadya-dyà komo. ");
INSERT INTO sbl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No ombayri ya gaw-en mo ay mapaptegan ya hika ay talagan anak nin Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na. Hay Diyos ay parihoy gawà ha kaganawan, ta hay allo ay ampahila-en na para ha tawtawoy mangala-et boy ha mangahampat, boy ampama-oran ya nin para ha mangahampat boy ha mangala-et. ");
INSERT INTO sbl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","No hay anlabiyen mon bongat ay hatoy ampanlabi komo, ma-in ka warì matanggap ya primyo? Maski mawmanininon bo-ih ya mangaha-ol ay ampanlabi ha ampanlabi konla. ");
INSERT INTO sbl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No hay an-ilawen mo ay haton bongat ya amigo mo ay anyay kahampatan ya nagawà moy igit ha nagawà nin kanayon? Maski alwan Hawhodiyo ay ampakagawà nin ombayro. ");
INSERT INTO sbl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hay Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na ay talagan ayin pagkokolang; kayà dapat kawon mag-in ayin pagkokolang nin bilang kona.” ");
INSERT INTO sbl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Hinalità et ni Apo Hisos, “Agkawo,” wana, “manggawà kahampatan ha tegteg bongat nin tawtawo, ta no ombayro ya gaw-en moyo ay agmoyo matanggap ya iprimyo komoyo nin Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kayà no ampambi ka ha tawoy ampanga-ilangan ay agmoyna ibo-angaw ya pambi mo nin bilang ha anggaw-en nin mawmagkakanwarì. No ampambi hila ay an-ibo-angaw la ha lo-ob himba-an nin Hawhodiyo boy ha balang daan, ta ampapori hila ha tawtawo. Anhalita-en ko komoyo, tinanggap laynay pamomori nin tawo; kayà ayin hilaynan matanggap ya primyo ya mangibat ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","No manambay ka ha manga-irap ay isikrito moy pambi mo nin ahè matanda-an nin maski hinoy mahene ya amigo mo emen ma-in kan matanggap ya primyo ya mangibat ha Tatay tamoy Diyos ya ampakatandà nin kaganawan.” ");
INSERT INTO sbl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No manalangin kawo ay agmoyo gaw-en ya bilang ha anggaw-en nin mawmagkakanwarì ya labaylabay mireng nin manalangin ha lo-ob himba-an nin Hawhodiyo boy ha kawkanto nin dawdaan emen hila makit nin tawtawo. Anhalita-en ko komoyo, tinanggap laynay pamomori nin tawo; kayà ayin hilaynan matanggap ya primyo ya mangibat ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piro no manalangin ka ay agmo gaw-en para makit kan bongat nin tawo, no alwan mako ka ha dogal ya ayin makatoksò komo ta manalangin ka ha Tatay tamoy Diyos ya ahè angkakit. Hay Tatay tamoy Diyos ya ampakatandà nin kaganawan anggaw-en mon sikrito ya mambi komon primyo. ");
INSERT INTO sbl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ha panalangin moyo ay agmoyo pi-oman-oman ya panggamit nin halità ya ayin labay totolen nin bilang ha anggaw-en nin tawtawoy ayin pantotompel ha Diyos, ta an-ihipen la ya leng-en hila nin Diyos banà ha kakara-an panalangin la. ");
INSERT INTO sbl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Agkawo manowad konla, ta biha kawo makirawat ha Tatay tamo ay da-an naynan tandà ya angka-ilanganen moyo. ");
INSERT INTO sbl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ombayri ya dapat nin panalangin moyo: ‘Tatay nawen ya anti ha katatag-ayan ha kama-inan mo, hay ngalan mo ya ayin kapintasan ay igalang dayi nin kaganawan. ");
INSERT INTO sbl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Andawaten nawen ya tampol ana dayin lomateng ya pamomo-on mo. Mangyari dayi ya kalabayan mo bayri ha babon lotà bilang ombayro ha katatag-ayan ha kama-inan mo. ");
INSERT INTO sbl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyan mo kayin pamamangan ha allo-allo. ");
INSERT INTO sbl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawaren mo kayi ha kawkasalanan nawen bilang pamatawad nawen ha nakapagkasalanan konnawen. ");
INSERT INTO sbl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Agmo kayi biyan mabiyat ya panobok boy ipakarayò mo kayi koni Satanas.’ ");
INSERT INTO sbl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ha ombayro, no mamatawad kawo,” wani Apo Hisos, “ha nipagkasalanan komoyo ay patawaren kawo itaman nin Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piro no agkawo mamatawad, hay nagawà moyoy kawkasalanan ay ahè itaman patawaren nin Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na.” ");
INSERT INTO sbl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tongkol ha pagpalta moyon mangan ta ma-in kawon an-ipanalangin ay agmoyo towaren baytoy mawmagkakanwarì ya ansadya-en lan palele-en boy papotla-en ya lopa la emen la ma-ipatandà ya hila ay ampangpaltan mangan. Anhalita-en ko komoyo: tinanggap laynay pamomori nin tawo; kayà ayin hilaynan matanggap ya primyo ya mangibat ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","No ampagpalta kan mangan ta ma-in kan an-ipanalangin ay olamehan moy lopa mo boy ayosen moy habot mo ");
INSERT INTO sbl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","emen ahè matanda-an nin kanayon ya hika ay ampagpaltan mangan ta ma-in kan an-ipanalangin. Hay makatandà bongat ay Tatay tamoy Diyos ya ahè angkakit. Hiyay ampakatandà nin kaganawan sikrito, boy hika ay ma-in matanggap ya primyo ya mangibat kona.” ");
INSERT INTO sbl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hinalità et ni Apo Hisos ya ombayri: “Bayri ha babon lotà ay agkawo manipon nin kayamanan ya anhira-en nin anag boy angkalawangen, boy anlo-oban nin takawen, ");
INSERT INTO sbl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","no alwan hay tiponen moyoy kayamanan ya para ha katatag-ayan ha kama-inan nin Diyos ay gawgawà ya mangahampat ta ahè an-anagen, ahè angkalawangen, boy ahè angkatakaw. ");
INSERT INTO sbl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","No hay kayamanan mo ay anti ha babon lotà o anti ha katatag-ayan ha kama-inan nin Diyos ay bayro ya ihip mo.” ");
INSERT INTO sbl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Hinalità et ni Apo Hisos, ya wana, “Hay mata mo ay pinagkahilag nin nawini mo. No ayin dipirinsya ya mata mo ay makit moy kaganawan; ");
INSERT INTO sbl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","piro no ma-in dipirinsya ya mata mo ay mareglem ya tegteg mo. Ombayro itaman ha pangingihip mo. No hay ihip mo ay mahampat, hay gawgawà mo ay panay kahampatan; piro no hay ihip mo ay alwan mahampat, hay gawgawà mo ay talagan alwan mangahampat.” ");
INSERT INTO sbl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ombayri et ya hinalità ni Apo Hisos: “Ayin tawoy makapagsirbi nin sabay ha loway amo; ta no pisabayen na, hay miha ay ma-arì pag-inakitan, piro hatoy miha ay labiyen na; o ma-arì nin mag-in yan tapat ha miha, ta hatoy miha ay kasorawan na. Agmo ma-arì pisabayen nin pagsirbiyan ya Diyos boy kayamanan. ");
INSERT INTO sbl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kayà habayti ya halita-en ko komoyo,” wana et ni Apo Hisos: “Agkawo magolon mangihip nin tongkol ha pagbibiyay moyo no anyay kanen, inomen, boy pagdolo. Alwa nayì nin hay biyay ay mas ma-alagà kisa pamamangan, boy hay nawini ay mas ma-alagà kisa dolo? ");
INSERT INTO sbl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Helken moyoy mawmanokmanok! Aghila ampananem ni ampangalawah nin ikamalig la, piro hay Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na ay ampangasiwà konla. Alwa nayì mas kawon ma-alagà kisa ha mawmanokmanok? ");
INSERT INTO sbl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Warì mapalawig moyoy biyay moyo no anggolowen moyoy ihip moyo? ");
INSERT INTO sbl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Antà angkagolo kawo ha pagdolo moyo? Ihipen moyo no pangno anhomlay ya mawmasitas ya balang. Aghila ampagtrabaho o ampanggawà dolo ya para ha sarili la. ");
INSERT INTO sbl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piro anhalita-en ko komoyo, maski masyadoy kayamanan ni Arì Solomon ay agya nakapagdolon maganda nin bilang ombayro kaganda ha bawbolaklak. ");
INSERT INTO sbl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No hay dawdikot ya angkabiyay hapa-eg ha lawak ay ampagandawen nin Diyos ya nobokah ay tabasen ta ipo-ol, hikawo et warì ya agna padolowan? Talagan kolang ya pantotompel moyo! ");
INSERT INTO sbl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dapat agmoyo golowen ya nakem moyon halita-en ya, ‘Ayri kayi mangwan kanen nawen, inomen nawen, boy pagdolo nawen?’ ");
INSERT INTO sbl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Habayti ya kaganawan bagay ya pirmin anhangaren nin tawtawoy anhomamba ha alwan peteg diyos. Piro hay Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na ya magtandà nin habayti ya bawbagay ya angka-ilanganen moyo. ");
INSERT INTO sbl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hay onawen tamo nin hangaren ay Diyos ya mamo-on kontamo boy mamiyay tamo nin kompormi ha kalabayan na, biha na igwà kontamo ya kaganawan nin habayti ya bawbagay ya angka-ilanganen tamo. ");
INSERT INTO sbl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kayà agkawo magolo nin mangihip no anyay mangyari komoyo nobokah, ta Diyos ya ampakaba-alà komoyo. Hay problima moyo hapa-eg ay agmoyoyna pahanan ha pangihip moyo nin mangyari ha homonoy allo.” ");
INSERT INTO sbl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hinalità ni Apo Hisos, ya wana, “Agkawo manosga emen agkawo hosgawan, ");
INSERT INTO sbl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ta no anyay ihosga moyo ha kanayon ay ombayroy ihosga komoyo. No pangno kalakè ya an-ihosga moyo ha kanayon ay ombayro itaman kalakè ya ihosga komoyo nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hika ya ampanosga, antà angka-asikaso moy kasalanan nin kapara mo ya bilang kayamò nin poling ya anti ha mata na, balè ta agmo angka-asikaso ya sarili mon kasalanan ya bilang kalapad nin tapì ya anti ha sarili mon mata? ");
INSERT INTO sbl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pangno ka ampakaregdeg nin maghalità ha kapara mo nin, ‘Alihen koy poling ha mata mo,’ no ma-in malapad ya tapì ha sarili mon mata? ");
INSERT INTO sbl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hikay magkakanwarì, alihen mo pon ya malapad ya tapì ha sarili mon mata emen mo makit nin mahampat ya pangalih nin poling ha mata nin kapara mo. ");
INSERT INTO sbl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Hay kaptegan ya tongkol ha Diyos ay agmoyo itorò do ha ahè malabay; ta no gaw-en moyo bayto ay bilang kawon ampambi nin manga-alagà ya bawbagay ha aw-aho ya magbira nin mangayat komoyo, boy bilang kawon ampangitapon pawpirlas ha bawbaboy ya ampanyabok bongat nin habaytoy pawpirlas.” ");
INSERT INTO sbl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ombayri et ya hinalità ni Apo Hisos: “Agkawo tonggen manalangin emen moyo matanggap ya an-ipanalangin moyo; agkawo tonggen makirawat emen kawo biyan nin andawaten moyo; agkawo tonggen mangingat ha Diyos emen na kawo tobayen. ");
INSERT INTO sbl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hinoman ya ampanalangin ay makatanggap, hinoman ya ampakirawat ay biyan, boy hinoman ya ampangingat ha Diyos ay tobayen. ");
INSERT INTO sbl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hinoman komoyon tawtatay, biyan mo warì bato ya anak mo no makikwa yan pamamangan komo? ");
INSERT INTO sbl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O biyan mo ya warì nin otan no makikwa yan konà komo? ");
INSERT INTO sbl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hikawo, maski mala-et ya ogalì moyo ay tandà moyon mambi nin mahampat ya bawbagay ha aw-anak moyo. Lalò anay Tatay moyoy Diyos ya anti ha katatag-ayan ha kama-inan na ay mambin mangahampat ya bawbagay ha ampakikwa kona. ");
INSERT INTO sbl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“No anyay labay moyon gaw-en komoyo nin kanayon ay ombayro itaman ya gaw-en moyo. Ha ombayri ay mageperan moyo ya kawkapanogo-an ya inggawà ni Moysis kateng hinolat nin pawpropita.” ");
INSERT INTO sbl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pomahok kawo ha makpit ya pinagkapolta emen agkawo miparaan ha malawang ya pinagkapolta, ta hay lakwen nin habaytoy malawang ya pinagkapolta ay impirno. Banà ta maparan pagdanan bayto ay malakè ya ampagdaan bayro. ");
INSERT INTO sbl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piro banà ta hay pinagkapolta nin magpalako ha katatag-ayan ha kama-inan nin Diyos ay makpit boy ma-irap pagdanan ay a-amò ya ampagdaan bayro.” ");
INSERT INTO sbl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-atap kawo ha ampipanorò nin alwan peteg ta hila ay ampagkakanwarì nin ma-amò ya tawtopa ya pakarani komoyo, piro hay nakem la ay emen nakem tigri. ");
INSERT INTO sbl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","No pangno moyo angkabalayan ya po-on kayo no makit moyoy bonga ay ombayro moyo hila mabalayan ha gawgawà la. Warì hay bilang kinew ya madowih ay ampamonga nin obas o hay kinew ya bilang kokomposà ay ampamonga nin igos? ");
INSERT INTO sbl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Hay po-on kayo ya ayin dipirinsya ay maganday bonga boy ahè mamonga nin ayin kowinta. Piro hay po-on kayoy ma-in dipirinsya ay ayin kowintay bonga boy ahè mamonga nin maganda. ");
INSERT INTO sbl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hay po-on kayoy ampamonga nin ayin kowinta ay anto-alen ta itapon ha apoy. ");
INSERT INTO sbl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ombayro itaman baytoy ampipanorò nin alwan peteg ta angkabalayan hila nin banà ha kala-etan gawgawà la.” ");
INSERT INTO sbl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hinalità et ni Apo Hisos, ya wana, “Alwan kaganawan tawo ya ampangingat kongko nin, ‘Pangino-on, Pangino-on,’ ay makalako ha dogal ya ampag-ari-an nin Diyos, no alwan haton bongat ya anggomawà kalabayan nin Tatay ko ya anti ha katatag-ayan ha kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ha allon panonosga ay malakè ya maghalità kongko nin, ‘Pangino-on, Pangino-on, ngalan moy ginamit nawen ha pangangaral boy ha pama-alih nin dawdimonyo kateng ha panggawà nawen nin malakè ya papag-ispantawan.’ ");
INSERT INTO sbl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piro hay itobay ko konla ay ombayri: ‘Agkatawo balay. Pakarayò kawo kongko ta hay la-et nin gawgawà moyo.’” ");
INSERT INTO sbl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ombayri et ya hinalità ni Apo Hisos: “Hinoman ya ampanlengè ha hawhalità ko boy anhonolen na ay bilang ya ha tawoy maronong ya nangipa-ireng nin bali ya hay pinangipondasyonan nin tawtarek ay matibay ya bato. ");
INSERT INTO sbl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Maski nangoran nin makhaw, nanlanab, boy namagyo ay ahè na-aybà baytoy bali na ta matibay ya batoy pinangipondasyonan nin tawtarek. ");
INSERT INTO sbl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hinoman ya ampakalengè nin hawhalità ko, piro agna anhonolen ay bilang ya ha tawoy tangah ya nangipa-ireng nin bali ha kapati-an. ");
INSERT INTO sbl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hin nangoran nin makhaw, nanlanab, boy namagyo ay natomban nangawawatak baytoy bali na.” ");
INSERT INTO sbl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hin nayarì naghalità hi Apo Hisos ay nipag-ispanta baytoy kalak-an tawo, ");
INSERT INTO sbl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta hay panonorò na ay alwan bilang panonorò nin mawmangitorò nin kawkapanogo-an. Ha panonorò na ay talagan ma-in yan kapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hi Apo Hisos ay nilomohan bayro ha bakil boy anhonowen yan malakè ya tawo. ");
INSERT INTO sbl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hapa-eg, ma-in napakarani konay mihay tawoy ma-in liproso ta nanalimokod ha arapan na nin naghalità, ya wana, “Apo, no kalabayan mo ay mapakahampat mo bayti ya masakit ko emen lominis ya nawini ko.” ");
INSERT INTO sbl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Impaktang ni Apo Hisos ya gamet na ta inaptoh na baytoy lalaki boy hinalità na kona, “Labay ko,” wana; “kayà lominis ka.” Antimano, hay liproso na ay na-alih. ");
INSERT INTO sbl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hapa-eg, hinalità kona ni Apo Hisos, “Habayti ya nangyari komo,” wana, “ay agmo ibalità ha maski hino, no alwan mako ka ha parì ta ipakit moy nawini mo ya ayin anan masakit. Mantan kan idolog mo ha Diyos nin bilang ombayro ha impanogò ni Moysis hin hato ya mamapteg ha tawtawo ya hika ay hinomampat ana.” ");
INSERT INTO sbl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hin ni-abot hi Apo Hisos ha banowan Kapirnawom ay hinakbat ya nin mihay kapitan nin hondalò ya taga Roma, ta naki-i-ingalo ya koni Apo Hisos nin patambay. ");
INSERT INTO sbl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apo,” wana, “hay alilà ko ay masyadon angka-irapan nin banà ha masakit na. Agya maka-ibangon ta agna ma-igalaw ya nawini na.” ");
INSERT INTO sbl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hinalità kona ni Apo Hisos, “Mako ko bayro,” wana, “ta pakahampaten ko ya.” ");
INSERT INTO sbl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piro tinombay kona baytoy kapitan, “Apo,” wana, “hiko ay alwan karapatdapat nin mamalako komo ha bali ko. Halita-en mon bongat ya homampat ya alilà ko ay homampat ya. ");
INSERT INTO sbl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hiko man ay anti ha hilong kapangyariyan nin ampakatag-ay kongko nin katongkolan. Ma-in ako itaman nin hawhondalò ya anti ha hilong kapangyariyan ko. No halita-en ko ha miha ya, ‘Manigè,’ ay manigè ya; no halita-en ko ha miha ya, ‘Mako ka bayri,’ ay mako ya; boy no halita-en ko ha alilà ko ya, ‘Gaw-en mo bayti,’ ay gaw-en na.” ");
INSERT INTO sbl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hin nalengè bayti ni Apo Hisos ay nag-ispanta ya boy hinalità na do ha tawtawoy anhomono kona, “Anhalita-en ko komoyo,” wana, “ha aw-inalalak ni Israyil, ni miha ay ayin ako et nakit ya ombayri ya katetpel. ");
INSERT INTO sbl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Habayti et ya halita-en ko komoyo: malakè ya alwan Hodiyo ya ma-ibat ha kaganawan dogal ay domoyong ha lamisawan kalamo ni Abraham, Isak, boy Hakob ha dogal ya ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piro hay Hawhodiyo ya dapat nin anti ha dogal ya ampag-ari-an nin Diyos, kalak-an konla ay itapon ha likol ha dogal ya pagkareglem. Bayro hila mi-anggaw-angaw boy manget-et nin ngipen la banà ha tanamen lay dya-dyà.” ");
INSERT INTO sbl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hapa-eg, hinalità ni Apo Hisos do ha kapitan, “Morong kayna,” wana. “Banà ha katetpel mo ay mangyari ya andawaten mo.” Habayto et oras ay hinomampat baytoy ampagmasakit ya alilà nin hatoy kapitan. ");
INSERT INTO sbl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hapa-eg hili Apo Hisos ay nako ha bali ni Pidro. Bayro ay nakit nay babayi ya ampò ni Simon Pidro ya naka-irà ta an-amoten. ");
INSERT INTO sbl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inoligtanan ni Apo Hisos ya gamet nin hatoy ampò ni Pidro; kayà natbahan ya. Hapa-eg, nibangon ya boy dinolotan na hili Apo Hisos nin pamamangan. ");
INSERT INTO sbl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hin mahilem ana, hay malakè ya tawoy pinahokan dawdimonyo ay gintan la koni Apo Hisos. Ha halità bongat ni Apo Hisos ay nog-alih baytoy dawdimonyo, boy pinakahampat nay kaganawan ampagmasakit. ");
INSERT INTO sbl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Habayti ya ginawà ni Apo Hisos ay nagkapeteg baytoy holà ni propita Isayas ya ombayri ya pagkahalità: “Hiyay namakahampat nin mawmasakit tamo boy inalih nay dawdipirinsya tamo.” ");
INSERT INTO sbl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hin na-asikaso ni Apo Hisos ya sigisigi ya panlomakè nin tawtawo ha mamalibot na ay hinalità na ha aw-alagad na ya lomipay hila nin mako ha kagmang dagat. ");
INSERT INTO sbl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hapa-eg mihay mangitorò nin kawkapanogo-an ay napakarani koni Apo Hisos ta naghalità, “Apo,” wana, “makilamo ko komo maski ayri ka mako.” ");
INSERT INTO sbl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hinalità kona ni Apo Hisos, ya wana, “Maski nin aw-ayop ya bilang ha lamiran ay ma-in lobot ya ampa-iriyan, boy hay mawmanokmanok ay ma-in ampa-i-aponan; piro hiko ya an-ingaten Anak nin Tawo ay ayin sarilin pa-iriyan ya pama-inawawan bayri ha babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hapa-eg, miha et ha ampipantompel koni Apo Hisos ay napakarani kona ta naghalità, “Apo,” wana, “payagan mo ko pon nin morong emen ko ma-ipatabon ya tatay ko.” ");
INSERT INTO sbl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Piro hinalità kona ni Apo Hisos, “Makilamo kayna kongko hapa-eg,” wana, “ta hay nati ay pa-olayan mon itabon nin tawtawoy ayin biyay ya ayin anggawan.” ");
INSERT INTO sbl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hapa-eg hi Apo Hisos ay hinomakay ana ha bangkà boy hinomonoyna itaman hinomakay ya aw-alagad na ta lomipay hilayna. ");
INSERT INTO sbl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mintras anlomipay hila ay biglà hinomkaw ya angin ta namagyo; hay bangkà la ay angkapalamnan nin lanom ta angkahipwakan nin malhay ya dawoyon, piro hi Apo Hisos ay angkatoloy. ");
INSERT INTO sbl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hapa-eg, pinakaraniyan ya nin aw-alagad na ta pinokaw la ya, “Pangino-on,” wanla, “ilibri mo kayi ta anlomdeg tamoyna.” ");
INSERT INTO sbl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Piro tinombay konla hi Apo Hisos, ya wana, “Antà masyado kawon angkalimo? Warì agkawo antompel kongko?” Hapa-eg, nibangon ya ta minandawan nan tonggen baytoy pagkahokaw angin boy dawdawoyon. Kayà tinonggen ya angin boy hay dagat ay tinominek. ");
INSERT INTO sbl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hay aw-alagad na ay nag-ispanta, ya wanla, “Anyan magkatawowan bayti ta maski angin boy dawoyon ay anhomonol kona?” ");
INSERT INTO sbl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hin ni-abot hili Apo Hisos ha lipay dagat ha dogal nin tawtawoy Gadarino ay hinakbat yan loway lalaki ya pinahokan nin dawdimonyo. Hila ay ampa-iri ha kawkowibay panabonan boy masyado hilan mabayani; kayà ayin makaregdeg nin magdaan bayro. ");
INSERT INTO sbl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hapa-eg, nambo-angaw hila, ya wanla, “Hika ya Anak nin Diyos, antà ampaki-emenan mo kayi? Nako ka nayì bayri para pa-irapan kayi nin ayin et ha pana-on?” ");
INSERT INTO sbl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hapa-eg, bayro ha dani la ay ma-in malakè ya baboy ya ampipamokibok. ");
INSERT INTO sbl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Habaytoy dawdimonyo ya anti bayro ha loway lalaki ay naki-i-ingalo koni Apo Hisos, ya wanla, “No pa-alihen mo kayi ay palakwen mo kayi awod bahen ha bawbaboy.” ");
INSERT INTO sbl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Sigi, mako kawoyna,” wani Apo Hisos konla; kayà nog-alih hila ta nako hilan pinomahok ha bawbaboy. Hatoy bawbaboy ya pinahokan nin dawdimonyo ay nipampowayon nagpalako ha bongaw anggan nipadiritson narabò ha dagat. Bayro hila nati nin nalemeh. ");
INSERT INTO sbl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hapa-eg hay ampipangalagà nin hatoy bawbaboy ay nipampowayon nako ha banowa, ta imbalità lay pawpangyayari kateng hatoy nangyari do ha loway tawo ya pinahokan pon nin dawdimonyo. ");
INSERT INTO sbl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kayà hay tawtawo bayro ha banowa ya nakalengè nin habayto ay nakon hinomakbat koni Apo Hisos, boy naki-i-ingalo hila kona nin mog-alih ya bayro ha dogal la. ");
INSERT INTO sbl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hi Apo Hisos ay hinomakay ana et ha bangkà ta nilomipay nin norong ha sarili nan banowa. ");
INSERT INTO sbl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hapa-eg, ma-in nakalateng ya ongnoy tawoy ampanapwat nin lalaki ya polonen ya naka-irà ha ondayon. Habaytoy polonen ay gintan la koni Apo Hisos. Hin nakit ni Apo Hisos ya ma-in hilan katetpel ay hinalità na do ha polonen, “Hokawen moy nakem mo,” wana, “anak ko, ta hika ay pinatawad ana ha kawkasalanan mo.” ");
INSERT INTO sbl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hapa-eg, ma-in bayron mawmangitorò nin kawkapanogo-an ya hinolat ni Moysis. Hay kanayon konla ay ampag-ilgo ha sarili la nin ombayri: “Ha hinalità nin habayti ya tawo ay emen hiya ya makapatawad nin kasalanan. Haba-in ya ginawà na ay panla-et ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piro hay anti ha nakem la ay talagan tandà ni Apo Hisos; kayà hinalità na konla, ya wana, “Antà nin mala-et ya an-ihipen moyo? ");
INSERT INTO sbl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anyay mas maparan mangyari ya halita-en bayri ha polonen, ‘Napatawad ana ya kawkasalanan mo,’ o ‘Mibangon ka ta mowako ka’? ");
INSERT INTO sbl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ha pamakahampat ko nin habayti ya tawo ay mapaptegan ko komoyo ya hiko ya an-ingaten Anak nin Tawo ay ma-in kapangyariyan bayri ha babon lotà nin mamatawad nin kasalanan.” Hapa-eg, hinalità ni Apo Hisos do ha polonen, “Mibangon ka,” wana, “hapwaten moy pinamir-an mo ta mowako kaynan morong.” ");
INSERT INTO sbl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hapa-eg habaytoy polonen ay nibangon ta norong yayna. ");
INSERT INTO sbl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hin nakit nin hatoy kalak-an tawo baytoy pamakahampat ni Apo Hisos nin tawoy polonen ay nipag-ispanta hila boy pinori lay Diyos, ta babayo hila nakakit nin tawoy ma-in ombayroy kapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hapa-eg, nog-alih bayro hi Apo Hisos boy ha pamowako na ay nakit na hi Matiyo ya manininon bo-ih ya naka-iknò ha pamayaran bo-ih. Hinalità ni Apo Hisos kona, “Makilamo ka kongko,” wana. Hi Matiyo ay nireng ta nakilamo koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hapa-eg hi Apo Hisos kateng aw-alagad na ay anti ha bali ni Matiyo nin ampangan. Malakè ya manininon bo-ih boy kanayon ya tawtawoy alwan mahampat ya pagkatawo ya nakalateng ya naki-arap konlan nangan. ");
INSERT INTO sbl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hay ongnoy Parisiyo ya anti bayro ya nakakit konla ay naghalità ha aw-alagad ni Apo Hisos, ya wanla, “Antà hay mangangaral moyo ay ampakipangan ha mawmanininon bo-ih boy ha tawtawoy alwan mahampat ya pagkatawo?” ");
INSERT INTO sbl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hin nalengè ni Apo Hisos baytoy pastang ha aw-alagad na ay ombayri ya alimbawà ya intobay na: “Hay tawoy ayin masakit ay ahè ampanga-ilangan nin mananambal; hay ampanga-ilangan bongat nin mananambal ay hatoy ma-in masakit. ");
INSERT INTO sbl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ombayro itaman ya pamako ko bayri ha babon lotà. Agko nako bayrin mangingat nin tawtawoy ahè ampangamin nin hila ay makasalanan, no alwan nako ko bayri nin mangingat nin tawtawoy ampangamin nin hila ay makasalanan. Ka-ilangan moyon pag-aralan ya labay totolen nin habayti ya nakaholat ya Halità nin Diyos: ‘Hay mas ma-alagà kongko ay mi-i-ingalo kawo kisa mamati kawon aw-ayop ya ipo-ol moyon idolog kongko.’” ");
INSERT INTO sbl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hapa-eg hay aw-alagad ni Howan Mamiminyag ay nako koni Apo Hisos ta hinalità la kona, ya wanla, “Antà hikayi boy Pawparisiyo ay ampagpaltan mangan, ta hay aw-alagad mo ay ahè ampagpaltan mangan?” ");
INSERT INTO sbl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ombayri ya intobay konla ni Apo Hisos: “Ma-arì warì maglelè boy magpaltan mangan ya tawtawoy kinombida ha banhal mintras anti et konla baytoy kakahal nin babayi? Lomateng ya oras nin alihen konla baytoy kakahal nin babayi, boy ha pana-on ya habayto ay magpalta hilan mangan banà ha kalele-an la.” ");
INSERT INTO sbl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hapa-eg hi Apo Hisos ay nangi-alimbawà et nin ombayri: “Ayin tawoy mangitakop nin bayoy ritaso ha da-an ya dolo, ta no gaw-en na bayto, hay bayoy intakop ay manirà nin hatoy da-an ya dolo; kayà lalò homlay ya ginit. ");
INSERT INTO sbl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ayin simprin tawoy mangipalaman nin kapelhan ampa-ahemen ya basì ha da-an ya katat ya pambiyanan basì; ta no gaw-en na bayto, hay da-an ya katat ay mahirà boy mabollog ya bayoy basì. Hay bayoy basì ay dapat ipalaman ha bayoy pangipalamnan emen parihon bomoyot.” ");
INSERT INTO sbl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mintras anhalita-en et bayto konla ni Apo Hisos ay ma-in nakalateng ya miha ha ampipamo-on ha himba-an nin Hawhodiyo. Hapa-eg, nanalimokod ya ha arapan ni Apo Hisos ta hinalità na ya ombayri: “Hay anak koy babayi ay kapimati; kayà makilako ka kongko ta aptohen mo yan bongat ay mabiyay yan oman.” ");
INSERT INTO sbl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hapa-eg hi Apo Hisos kateng aw-alagad na ay nanigè nin nakilako kona. ");
INSERT INTO sbl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Hin ampowakoyna hili Apo Hisos ay ma-in mihay babayi ya napakarani ha bokotan na. Habaytoy babayi, ha lo-ob labinloway ta-on ay sigisigi ya pantolò nin dayà na ta ma-in yan dipirinsya. Hinalità na ha sarili na, ya wana, “Ma-aptoh kon bongat ya laylay dolo ni Apo Hisos ay homampat ako.” Hapa-eg hay laylay dolo ni Apo Hisos ay na-aptoh na. ");
INSERT INTO sbl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nagpeyeh hi Apo Hisos boy nakit na baytoy babayi biha na hinalità kona, ya wana, “Patel, hokawen moy nakem mo; hay pantotompel mo ya nakapahampat komo.” Kayà hinomampat baytoy babayi hin habayto et nin oras. ");
INSERT INTO sbl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hapa-eg hili Apo Hisos ay ni-abot do ha bali nin hatoy ampamo-on ha himba-an nin Hawhodiyo. Nakit na baytoy ampipanogtog para ha pananabon boy nalengè nay telek nin tawtawoy ampagkagolo. ");
INSERT INTO sbl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hapa-eg, hinalità ni Apo Hisos, “Lomikol kawoy kaganawan!” wana. “Haba-in ya anak ay ahè nati no alwan angkatoloy yan bongat!” Banà bayri ha hinalità ni Apo Hisos ay pinikaka-iliyan la ya. ");
INSERT INTO sbl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Piro hin nilomikol baytoy tawtawo, hi Apo Hisos ay nilomo-ob do ha pinangiborolan nin hatoy anak. Hapa-eg, inoligtanan nay gamet nin hatoy anak boy nibangon baytoy anak. ");
INSERT INTO sbl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Habaytoy pangyayari ay nibahwag ha tawtawoy ampa-iri ha mamalibot nin habaytoy dogal. ");
INSERT INTO sbl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hin nog-alih ana bayro hi Apo Hisos ay hinono yan loway lalaki ya bowag ya ampambolyaw nin ombayri: “Alalak ni Arì Dabid, ingalowan mo kayi.” ");
INSERT INTO sbl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hapa-eg, hin nilomo-ob hi Apo Hisos ha bali ay napakarani kona baytoy loway bowag. Pinastang hila ni Apo Hisos, “Ampinto-o kawo nayì,” wana, “nin mapakahampat koy mata moyo?” “Awò,” wanla, “Apo, ampinto-o kayi.” ");
INSERT INTO sbl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hapa-eg hay mata la ay inaptoh ni Apo Hisos boy hinalità na konla, “Banà,” wana, “ha pantotompel moyo ay homampat kawo.” ");
INSERT INTO sbl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hin habayto et oras ay nakakit hilayna. Inhigpit nin imbibilin konla ni Apo Hisos ya ombayri: “Agmoyo ibalità ha maski hino ya tongkol bayri ha nangyari komoyo.” ");
INSERT INTO sbl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piro hin nog-alih hila, hay tongkol koni Apo Hisos ay imbahwag la ha kaganawan ha angkasakopan nin dogal ya habayto. ");
INSERT INTO sbl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hin ampog-alih baytoy loway lalaki ya bowag pon ay ma-in tawtawo ya nantan nin mihay lalaki koni Apo Hisos. Habaytoy lalaki ay ahè makapaghalità ta pinahokan nin dimonyo. ");
INSERT INTO sbl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hapa-eg, pina-alih ni Apo Hisos baytoy dimonyo; kayà nakapaghalità baytoy tawo. Nag-ispanta baytoy kalak-an tawo, ya wanla, “Hitamoy aw-inalalak ni Israyil, nakakanoman ay ahè et nakakit nin ombayri ha nakit tamo hapa-eg.” ");
INSERT INTO sbl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piro hinalità nin Pawparisiyo, “Hay po-on,” wanla, “nin dawdimonyo ya ampambi konan kapangyariyan nin mama-alih nin dawdimonyo.” ");
INSERT INTO sbl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hi Apo Hisos ay nako ha kaganawan banowa boy baryo. Anlomo-ob ya ha hawhimba-an nin Hawhodiyo nin mangitorò nin Mahampat ya Balità ya tongkol ha pamomo-on nin Diyos, boy ampamakahampat yan tawtawoy ma-in hari-harì ya dipirinsya boy masakit. ");
INSERT INTO sbl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hin nakit na baytoy kalak-an tawo ya ampikagoloy nakem boy ayin ampanambay ay na-ingalowan na, ta hila ay bilang ha tawtopa ya ayin ampagpastol. ");
INSERT INTO sbl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kayà hinalità na ha aw-alagad na, “Malakè,” wana, “ya tawo ya kowinta a-alawahanen ana ya bilang ha pali ya mabonga, piro hay kowinta ampangalawah ay a-amò. ");
INSERT INTO sbl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kayà ipanalangin moyo ha Pangino-on ya ma-in ikon nin kowinta a-alawahanen ya pahanan nay kowinta mangalawah.” ");
INSERT INTO sbl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Hapa-eg, iningat ni Apo Hisos ya labinloway alagad na nin pakarani kona ta binyan na hila nin kapangyariyan mama-alih nin dawdimonyoy pinomahok ha tawtawo, boy binyan na hila et nin kapangyariyan mamakahampat nin kaganawan tawoy ma-in masakit boy dipirinsya. ");
INSERT INTO sbl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Habayti ya ngawngalan nin labinloway pinilì nan pag-alagad na: hi Simon ya an-ingaten et Pidro, hi Andris ya patel ni Pidro, hi Santiyago boy hi Howan ya mipatel ya aw-anak ni Sibidiyo, ");
INSERT INTO sbl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","hi Pilipi, hi Bartolomi, hi Tomas, hi Matiyo ya manininon bo-ih, hi Santiyago ya anak ni Alpiyo, hi Tadyo, ");
INSERT INTO sbl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hi Simon ya mapagmalasakit ha nasyon Israyil, boy hi Hodas Iskaryoti ya nangisapakat koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Habayti ya labinloway alagad ay inhogò ni Apo Hisos boy binibilinan na hila nin ombayri: “Agkawo mako ha dawdogal nin alwan Hawhodiyo boy ha dawdogal nin Sawsamaritano. ");
INSERT INTO sbl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hay lakwen moyon bongat ay kapariho tamon aw-inalalak ni Israyil ya kowinta tawtopay nitawon. ");
INSERT INTO sbl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","I-aral moyo konla ya hay pamomo-on nin Diyos ay maranina. ");
INSERT INTO sbl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakahampaten moyoy ampipagmasakit kateng mangama-in liproso, mamabiyay kawon nati, boy mama-alih kawon dawdimonyoy pinomahok ha tawtawo. Hay kapangyariyan moyon manggawà nin ombayri ay tinanggap moyo nin ayin bayad; kayà agmoyo pabayaren ya tawtawoy matambayan moyo. ");
INSERT INTO sbl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ha panigè moyo ay agkawo mantan gintò, pilak, o tangsò. ");
INSERT INTO sbl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Agkawo simpri mantan pambiyanan pamamangan, dolo ya paghagiliyan, sapatos, o baston. Dapat hay mambin angka-ilanganen moyo ay hatoy matambayan moyo. ");
INSERT INTO sbl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pami-abot moyo ha mihay banowa o baryo ay manikap kawon tawoy an-igalang ya handà mamapa-iri komoyo, ta bayro kawo manatili kona angga ha mog-alih kawo bayro ha dogal ya habayto. ");
INSERT INTO sbl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamakalo-ob moyo ha bali ay pakahampat kawoy maghalità ha tawtawo bayro nin, ‘Magkama-in kawon katinekan.’ ");
INSERT INTO sbl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No mahampat ya pananggap komoyo nin tawtawo ha bali ya habayto ay panatiliyen moyo bayto konlay hinalità moyo, piro no agla kawo tanggapen ay bawi-en moyo baytoy hinalità moyo. ");
INSERT INTO sbl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hinoman ya ma-in bali o ha ayriman ya dogal ta agla kawo tanggapen, pamog-alih moyo ay ikampag moyoy gabok ha bitih moyo emen la matanda-an ya alwan mahampat ya ginawà la komoyo. ");
INSERT INTO sbl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Habayti ya halita-en ko komoyo: ha allon panonosga, maski mangala-et ya tawtawo ha siyodad nin Sodoma boy Gomora ay mas hilay ingalowan nin Diyos kisan hatoy tawtawoy ahè nananggap komoyo.” ");
INSERT INTO sbl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Leng-en moyo!” wana et ni Apo Hisos ha aw-alagad na. “Hay tawtopa ay manga-amò boy ayin kayan lomaban ha mandisgrasya konla. Hikawo ya bilang tawtopa ay an-ihogò kon mako ha tawtawoy inogalì tigri. No pangno kagaling mag-atap ya aw-otan emen aghila mapati boy no pangno ka-amò ya kawkalapati ay mag-in kawo itaman ombayro. ");
INSERT INTO sbl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-atap kawo ha tawtawoy mangi-arap komoyo ha hosgado, ta ha lo-ob himba-an nin Hawhodiyo ay bogbogen la kawo. ");
INSERT INTO sbl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Banà kongko, hikawo ay gitan lan i-arap ha gawgobirnador boy ha kanayon ya ampipamo-on. Ha pangyayari ya habayto, hikawo ay mamapteg nin tongkol kongko ha arapan la boy ha alwan Hawhodiyo. ");
INSERT INTO sbl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pantan la komoyo ha hosgado ay agkawo mahlak no pangno moyo idipinsa ya sarili moyo o no anyay halita-en moyo, ta hay halita-en moyo ha oras ya habayto ");
INSERT INTO sbl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ay ahè mangibat ha sarili moyon ihip, no alwan mangibat ha Ispirito nin Tatay tamoy Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma-in tawo ya mangipapati nin pawpatel nay lalaki, boy ma-in tatay ya mangipapati nin anak na. Ma-in itaman aw-anak ya lomaban ha mawmato-antawo la biha la ipapati. ");
INSERT INTO sbl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Banà ha pamakilamo moyo kongko, hikawo ay pag-inakitan nin kaganawan tawo. Piro hay makatagal ha kadya-dya-an boy ampanatilin antompel kongko angga ha ka-anggawan nin biyay na ay ma-in kalibriyan. ");
INSERT INTO sbl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No padya-dya-an kawo ha mihay banowa ay mowayo kawon mako ha kanayon ya banowa. Anhalita-en ko komoyo ya agmoyo mayarì ya an-ipagawà ko komoyo ha kaganawan dogal ha nasyon Israyil anggan hiko ya an-ingaten Anak nin Tawo ay makabira bayri. ");
INSERT INTO sbl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ayin antoro-an ya makara-eg ha ampanorò kona, boy ayin alilà ya makara-eg ha amo na. ");
INSERT INTO sbl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kayà no anyay ampangyari ha ampanorò ay ombayro itaman ya mangyari ha antoro-an. Ombayro simpri ha alilà. No anyay ampangyari ha amo na ay ombayro itaman ya mangyari kona. Kayà no pangno ya anggaw-en la kongko ya manonorò komoyo ay ombayro simpri ya gaw-en la komoyo. Hiko ay iningat lan Bilsibob. Alwa warì mas mala-et ya i-ingat la komoyo?” ");
INSERT INTO sbl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Agmoyo kalimowan ya tawtawoy ampamadya-dyà komoyo ta ayin nakatagò ya ahè mipatnag, boy ayin sikrito ya ahè mibolgar. ");
INSERT INTO sbl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","No anyay anhalita-en ko komoyo nin sikrito ay halita-en moyon bolgaran ha kaganawan, boy no anyay an-i-ananah komoyo ay halita-en moyon ibo-angaw. ");
INSERT INTO sbl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Agmoyo kalimowan ya mapamati ta nawini moyon bongat ya kaya lan patyen, piro hay kalolowa nin pinati la ay agla mapati; no alwan hay kalimowan moyo ay Diyos ya ma-in kapangyariyan mamati nin nawini boy mantan nin kalolowa ha impirno. ");
INSERT INTO sbl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Alwa nayì nin hay loway pipit ay angka-ilakò nin alagà mihay sintimos bongat? Ombayro man, maski miha konla ay ahè matata ha lotà no ahè payagan nin Tatay tamoy Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Piro hikawo, maski habot moyo ay tandà nin Diyos no ongnoy bilang. ");
INSERT INTO sbl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kayà agkawo malimo ta hikawo ay mas ma-alagà kisa ha malakè ya pipit.” ");
INSERT INTO sbl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hinalità et ni Apo Hisos ya ombayri: “Hinoman ya mamapteg ha tawtawo nin hiya ay ampakilamo kongko, hiko ay mamapteg itaman ha arapan nin Tatay koy Diyos ha katatag-ayan ha kama-inan na nin habaytoy tawo ay ampakilamo kongko. ");
INSERT INTO sbl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piro hinoman ya ampangipogla-oh kongko ha tawtawo nin hiya ay ahè ampakilamo kongko ay paptegan ko itaman ha arapan nin Tatay koy Diyos ha katatag-ayan ha kama-inan na ya habaytoy tawo ay ahè nakilamo kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Maka an-ihipen moyo nin hay bara-nan nin pamako ko bayri ha babon lotà ay emen hay tawtawo ay magkama-in katinekan. Alwan ombayro ta banà kongko, hay tawtawo ay mangapikokontra. Hay kanayon ay homonol kongko; hay kanayon itaman ay mag-inakit kongko. ");
INSERT INTO sbl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Banà ha pamako ko bayri, hay anak ya lalaki ay komontra ha tatay na, hay anak ya babayi ay komontra ha nanay na, boy hay manoyang ya babayi ay komontra ha ampò nay babayi. ");
INSERT INTO sbl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hay mas mahigpit mikokontra ay hatoy anti ha mihay pamilya. ");
INSERT INTO sbl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hinoman ya ampanlabi ha tatay na o ha nanay na nin mas et ha panlalabi na kongko ay alwan karapatdapat mag-in alagad ko; hinoman ya ampanlabi ha anak na nin mas et ha panlalabi na kongko ay alwa ya simprin karapatdapat mag-in alagad ko. ");
INSERT INTO sbl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hinoman ya ahè labay magdanas kadya-dya-an nin bilang ampamalatay koroh nin palako ha kamatyan na, boy ahè labay makilamo kongko ay alwan karapatdapat mag-in alagad ko. ");
INSERT INTO sbl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hinoman ya ampag-atap emen agya mati ay mati et bongat, piro hinoman ya mati nin banà kongko ay ma-in biyay ya ayin anggawan.” ");
INSERT INTO sbl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hinoman ya ampananggap komoyo ay ampananggap kongko, boy hinoman ya ampananggap kongko ay antanggapen na simpri ya Diyos ya nangihogò kongko. ");
INSERT INTO sbl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hay ampananggap ha hogò nin Diyos banà ta hiya ay inhogò nin Diyos ay ma-in yan tanggapen ya primyo ya bilang ombayro ha tanggapen nin hatoy hogò nin Diyos. No tinanggap moy tawoy mahampat nin banà ha kahampatan na ay ma-in kan tanggapen ya primyoy bilang ombayro ha tanggapen na. ");
INSERT INTO sbl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Habayti ya halita-en ko komoyo; hinoman ya mambin inomen ya lanom ya malay-ep ha maski pinaka-oltimo ya alagad ko, ta biyan na ya banà ta hiya ay alagad ko, habaytoy mambi ay makatanggap simpri nin primyo.” ");
INSERT INTO sbl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hin nayarì ni Apo Hisos nin pinalinawan baytoy labinloway alagad na ay nako ya ha bawbanoway mangarani bayro nin manorò boy mangaral. ");
INSERT INTO sbl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hin habayto, hi Howan Mamiminyag ya anti ha pirisowan ay nakalengè nin tongkol ha gawgawà ni Pangino-on Hisokristo. Kayà nangihogò ya nin ongnoy alagad nan makon magpastang koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hin ni-abot hilayna koni Apo Hisos ay pinastang la ya, ya wanla, “Hika nayì baytoy lomateng ya impangakò nin Diyos, o ma-in et kanayon ya anti-en nawen?” ");
INSERT INTO sbl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tinombay konla hi Apo Hisos, ya wana, “Magbira kawoyna koni Howan ta ibalità moyo kona bayti ya angkalengè moyo boy angkakit moyo ya ");
INSERT INTO sbl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","banà kongko, hay bawbowag ay ampakakit ana, hay pawpolonen ay ampaka-owakoyna, hay mangama-in liproso ay hinomampat ana, hay tawteek ay ampakalengè ana, hay nikati ay angkapabiyay oman, boy hay Mahampat ya Balità ay an-i-aral ha manga-irap. ");
INSERT INTO sbl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Makalmà ya tawoy ahè angka-alih ya pantotompel kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hin norong ana baytoy inhogò ni Howan ay hinalità ni Apo Hisos do ha kalak-an tawo ya tongkol koni Howan. “Hin nilako moyo,” wana, “nin biniliw hi Howan do ha powiray dogal, anyay an-asawan moyon makit kona? Mawenek nayì nin bilang ha dikot ya angka-itomba nin angin? ");
INSERT INTO sbl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anyay an-asawan moyon makit kona? Hay ampagholot nin maganday dolo ay hatoy ampa-iri ha palasyo. ");
INSERT INTO sbl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Antà awod nako kawo kona? Nako kawo nayì kona ta an-asawan moyo nin hiya ay propita? Anhalita-en ko komoyo ya igit et ha propita ya nakit moyo; ");
INSERT INTO sbl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ta ha Halità nin Diyos ay ombayri ya impaholat nin Diyos ya tongkol koni Howan: ‘Hay hogò ko ay ihogò kon ma-ona komo nin mangihandà pagdanan mo.’ ");
INSERT INTO sbl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Hapa-eg habayti ya halita-en ko komoyo: ha kaganawan tawoy in-anak bayri ha babon lotà ay ayin makara-eg koni Howan Mamiminyag. Balè ha dogal ya ampag-ari-an nin Diyos, maski pinaka-oltimo ay da-eg hi Howan. ");
INSERT INTO sbl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pa-ibat hin pana-on nin ampangaral hi Howan angga hapa-eg, hay tawtawoy ampag-ari-an nin Diyos ay ampagdanas kadya-dya-an, ta hay tawtawoy mangala-et ay angkomontra ha pamomo-on nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hin hato et, hay tongkol ha pamomo-on nin Diyos ay hinola-an ana nin pawpropita boy inholat ha kawkapanogo-an ni Moysis angga hin nangaral hi Howan. ");
INSERT INTO sbl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hinola-an la ya magbira hi Ilyas ya propita hin hato. No pinto-owen moyo bayto ay tandà moyo ya hiya bayti hi Howan ya hinola-an la. ");
INSERT INTO sbl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hay ka-ilangan moyo ay manlengè mahampat nin habayti ya anhalita-en ko komoyo biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hinalità et ni Apo Hisos, “Anyay pangiparisan ko nin tawtawo hapa-eg pana-on? Hila ay bilang ha aw-anak ya ampipampiknò ha danin palingki ya an-ibolyaw lan halita-en ha kawkaragaw lay, ");
INSERT INTO sbl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Antogtogan nawen kawon togtog ya para ha banhal piro agkawo antomalek. Ampagkanta kayi nin kanta ya para ha pananabon, piro agkawo ampanangih.’ ");
INSERT INTO sbl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hi Howan Mamiminyag ya nako bayri ay mabetbet nin magpaltan mangan boy ahè ampinom nin alak, piro anhalita-en nin tawtawo ya, ‘Hiya ay pinahokan nin dimonyo.’ ");
INSERT INTO sbl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hapa-eg ha hiko ya an-ingaten Anak nin Tawo ya nako bayri ya ahè ampagpaltan mangan boy minom ay anhalita-en nin tawtawo ya ‘Hiya ay mahibà, hiya ay maglalahing, boy hiya ay amigo nin mangaha-ol ya mawmanininon bo-ih boy tawtawoy alwan mahampat ya pagkatawo.’ Ombayro man, hay karonongan nin Diyos ay angkapaptegan ta hay risolta ay angkakit ha gawgawà nin tawtawoy anhomonol kona.” ");
INSERT INTO sbl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hapa-eg hatoy tawtawoy pinanggaw-an ni Apo Hisos nin pawpapag-ispantawan ay ahè nipaghehe ha kawkasalanan. Kayà pinaghalita-an na hilan makhit, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ka-i-ingaloy mangyari komoyon tawtaga Korasin boy tawtaga Bitsayda! No hay pawpapag-ispantawan ya ginawà ko bayri komoyo ay ginawà dayi ha Tiro boy Sidon ya sawsiyodad nin alwan Hawhodiyo, sigoro hay boyot laynan nagholot mangakodpaw boy nagborobod nin aboh emen la ma-ipakit ya pamaghehe la ha kawkasalanan la. ");
INSERT INTO sbl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Habayti ya halita-en ko komoyo: ha allon panonosga, hay tawtaga Tiro boy Sidon ay mas ingalowan nin Diyos kisan hikawo. ");
INSERT INTO sbl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hikawo man ya tawtaga banowan Kapirnawom ya labay mitag-ay nin emen katag-ay langit ay itapon ha impirno ya ayin anggay kaparosawan. No hay pawpapag-ispantawan ya ginawà ko komoyo ay ginawà dayi ha tawtaga Sodoma, sigoro pinaghehean lay kawkasalanan la. Ha ombayro, hay dogal la ay ampanatili et dayin angga hapa-eg ta ahè dayi pino-olan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Habayti ya halita-en ko komoyo: ha allon panonosga, maski mangala-et ya tawtawo ha siyodad nin Sodoma ay mas hilay ingalowan nin Diyos kisan hikawo.” ");
INSERT INTO sbl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hin habayton oras ay nanalangin hi Apo Hisos, ya wana, “Tatay ko ya Pangino-on ha katatag-ayan ha kama-inan mo boy bayri ha babon lotà, ampasalamat ako komo ta hay bawbagay ya insikrito mo emen ahè ma-intindiyan nin mangama-in pinag-aralan ay impa-intindiyan mo ha manga-aypà ya nakem nin bilang ha mangayamò ya aw-anak. ");
INSERT INTO sbl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Salamat, Tatay ko, ta habayti ya ginawà mo ay kalabayan mo.” ");
INSERT INTO sbl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hapa-eg, hinalità ni Apo Hisos ha tawtawo ya ombayri: “Kaganawan bagay ay impahimalà kongko nin Tatay koy Diyos. Hay tongkol kongko ya Anak nin Diyos ay ayin ampakatandà no alwan Tatay koy Diyos, boy hay tongkol ha Tatay koy Diyos ay ayin ampakatandà no alwan hiko ya Anak na boy hatoy labay kon pangipatanda-an. ");
INSERT INTO sbl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hikawo ya ampomagal ta angkabiyatan mangihip ha panhohomonol moyo ha da-an ka-ogali-an, pakarani kawo kongko emen kawo magkama-in katinekan. ");
INSERT INTO sbl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Honolen moyoy an-ipanogò ko, ta payagan moyo kon manorò komoyo emen kawo magkama-in katinekan. Hiko ay ma-aypà ya nakem boy mapanawan manorò. ");
INSERT INTO sbl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mahampat no hikoy honolen moyo ta alwan ma-irap ya bawbagay ya itorò ko komoyo.” ");
INSERT INTO sbl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mihay allon Sabado ya allon pama-inawa nin Hawhodiyo, hili Apo Hisos ya antomalà ay niparaan ha ma-in tawtanaman ya trigo. Hay aw-alagad nay nabitil ay nipanggetè nin trigo ta kinan la. ");
INSERT INTO sbl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hapa-eg, ma-in bayron Pawparisiyo ya nakakit konla. Kayà hinalità la koni Apo Hisos, “Biliwen moy aw-alagad mo,” wanla. “Anggaw-en la ba-in ya ha kawkapanogo-an tamo ay labag gomawà nin ombahen no allon pama-inawa.” ");
INSERT INTO sbl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tinombay hi Apo Hisos, ya wana, “Warì agmoyo et nabaha ya nakaholat ya ginawà ni Dabid hin hato hin binomitil ya kateng kawkalamowan na? ");
INSERT INTO sbl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nilomo-ob ya ha bali nin Diyos ta nangwa yan tinapay ya indolog ha Diyos. Nangan yan hatoy tinapay boy pinakan nay kawkalamowan na maski kontra ha kawkapanogo-an tamo ya mangan nin habayto, ta hay ma-arì bongat mangan nin habayto ay pawparì. ");
INSERT INTO sbl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tandà moyo ya impanogò nin Diyos ya ahè magtrabaho no allon pama-inawa. Nabaha moyo et baytoy impaholat na koni Moysis ya hay pawparì ay dapat gomawà ha bali nin Diyos maski allon pama-inawa. Kayà hila ay ayin kasalanan maski magtrabaho hila ha allon habayto. ");
INSERT INTO sbl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Piro anhalita-en ko komoyo ya hiko ya anti bayri ay mas ma-in katongkolan gomawà kisa hatoy ampipagtrabaho ha bali nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hay nakaholat ha Halità nin Diyos ay ombayri: ‘Hay mas labay ko ay mi-i-ingalo kawo kisa mamati kawon aw-ayop ya ipo-ol nin idolog kongko.’ No na-intindiyan moyo dayin mahampat bayto ay agmoyo hosgawan baytoy nanggawà nin alwan kasalanan. ");
INSERT INTO sbl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hiko ya an-ingaten Anak nin Tawo ay ma-in karapatan maghalità no anyay tamà gaw-en no allon pama-inawa.” ");
INSERT INTO sbl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hapa-eg hi Apo Hisos ay nog-alih bayro ta nako yan nilomo-ob ha miha ha hawhimba-an nin Hawhodiyo. ");
INSERT INTO sbl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bayro ay ma-in mihay lalaki ya hay mihay gamet ay ahè ma-igalaw ta kinomampil. Hapa-eg, ma-in bayron ampanikap nin bara-nan ya pangidimandawan la koni Apo Hisos. Kayà pinastang la ya nin ombayri: “Kompormi ha kawkapanogo-an,” wanla, “tamà nayì mamakahampat nin ampagmasakit no allon pama-inawa?” ");
INSERT INTO sbl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tinombay konla hi Apo Hisos nin ombayri ya alimbawà: “No ma-in kan tawtopa ta hay miha ay natata ha malalè ya lobot ya nitag-on allon pama-inawa, agmo warì i-alawah ha allon habayto ta ilibri mo? ");
INSERT INTO sbl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lalò ana ya tawo, ta hay mihay tawo ay mas ma-alagà kisa ha mihay topa. Kayà alwan kontra ha kawkapanogo-an no manggawà kahampatan no allon pama-inawa.” ");
INSERT INTO sbl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hapa-eg, hinalità ni Apo Hisos do ha lalaki ya kinomampil ya gamet, “Ipaktang mo,” wana, “ya gamet mo.” Hin impaktang na, hay gamet na ay hinomampat ana ta nag-in nin bilang ombayro ha kagmang gamet na. ");
INSERT INTO sbl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hapa-eg hatoy Pawparisiyo ay nog-alih ta pini-i-ilgowan la no pangno la mapati hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hin natanda-an ni Apo Hisos baytoy tangkà la ay nog-alih ya ha dogal ya habayto. Malakè ya tawoy nakihono kona. Kaganawan nin ma-in masakit ay pinakahampat na, ");
INSERT INTO sbl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","boy inhigpit nan imbibilin konla ya agla ibabalità ya tongkol kona. ");
INSERT INTO sbl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bayri napaptegan ya holà ni propita Isayas ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Habayti ya magsisirbi koy pinilì ko; anlabiyen ko ya boy masyado kon ampangonsowilo kona. Igwà ko konay Ispirito ko, boy hiya ya mangibalità nin tongkol ha panonosga ko ha kaganawan tawo. ");
INSERT INTO sbl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Agya makidiskosyon o mambonghaw, ni mambo-angaw nin magdiskorso ha kalsara. ");
INSERT INTO sbl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Agna pa-olayan baytoy mangakapey ya pantotompel, no alwan tambayan nay ma-in amò ya pamahimalà kona. Agya tonggen anggan agna ma-ipanalo ya kaptegan, ");
INSERT INTO sbl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","boy hay kaganawan tawo ay omasa kona.” ");
INSERT INTO sbl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hapa-eg, ma-in nako koni Apo Hisos ya ongno katawoy nantan nin mihay lalaki ya bowag boy ahè makapaghalità banà ha kagagaw-an nin dimonyoy pinomahok kona. Pinakahampat ni Apo Hisos baytoy lalaki; kayà nakakit ya boy nakapaghalità. ");
INSERT INTO sbl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hatoy kalak-an tawoy anti bayro ya nakakit nin ginawà ni Apo Hisos ay nipag-ispanta, ya wanla, “Maka hiyayna baytoy impangakò nin Diyos ya alalak ni Arì Dabid.” ");
INSERT INTO sbl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piro hin nalengè bayti nin Pawparisiyo ay hinalità la, “Ampakapa-alih ya,” wanla, “nin dawdimonyo, ta hay ampambi kona nin kapangyariyan makagawà nin ombayro ay hi Bilsibob ya po-on nin dawdimonyo.” ");
INSERT INTO sbl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tandà ni Apo Hisos no anyay an-ihipen la. Kayà hinalità na konla, “No ma-in arì,” wana, “ya hay ampag-ari-an na ay ampi-a-away ay ahè bomoyot ya pamomo-on na. Ombayro itaman ha mihay banowa o mihay pamilya ya ayin pamimimiha boy ampi-a-away ay mangapihihiyay. ");
INSERT INTO sbl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","No kalabanen ni Satanas ya sarili na, pangno bomoyot ya pamomo-on na? ");
INSERT INTO sbl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No peteg ba-in ya anhalita-en moyo ya ampakapa-alih ako nin dawdimonyo ta binyan akon kapangyariyan ni Bilsibob ya hi Satanas, hapay kawkalamowan moyo, pangno hila ampakapa-alih nin dawdimonyo? Mismon kawkalamowan moyo ya ampamapteg nin hikawo ay talagan malì. ");
INSERT INTO sbl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ispirito nin Diyos ya nambi kongkon kapangyariyan emen ako makapa-alih nin dawdimonyoy pinomahok ha tawtawo. Ha ombayro, angkapaptegan ya nilomateng ana ya pamomo-on nin Diyos komoyo.” ");
INSERT INTO sbl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hinalità et ni Apo Hisos, ya wana, “Hay bali nin makhaw ya tawo ay ayin makalo-ob manakaw nin kawkamama-in na no ahè pon balolen baytoy makhaw ya tawo. ");
INSERT INTO sbl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hinoman ya ahè an-omayon kongko ay kontra kongko. Hinoman ya ahè ampanambay nin mangipakarani kongko nin tawtawo ay ampangikakatak. ");
INSERT INTO sbl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anhalita-en ko komoyo: hay tawtawo ay patawaren ha kaganawan kasalanan ya nagawà la boy hinalità la. Piro hinoman ya ampaghalità nin mala-et ya kontra ha Ispirito nin Diyos ay ayin kapatawaran maski makakano, ta ha ombayro ay an-itowad na nin hay gawgawà nin Ispirito nin Diyos ay gawgawà ni Satanas. ");
INSERT INTO sbl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hinoman ya ampaghalità nin kontra kongko ya an-ingaten Anak nin Tawo ay ma-in kapatawaran, piro ayin kapatawaran ya ampaghalità nin mala-et ya kontra ha Ispirito nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ma-in po-on kayo ya hay an-ibonga ay ma-alagà. Ma-in itaman kanayon ya po-on kayo ya hay an-ibonga ay ayin alagà. Hay kayo ay mabalayan ha bonga. ");
INSERT INTO sbl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ombayro itaman komoyo. Hikawo ay bilang aw-otan ya ma-in dità, ta banà ha kala-etan moyo ay magaling kawon manggawà kala-etan. No anyay anti ha nakem nin tawo ay habaytoy anhalita-en na. ");
INSERT INTO sbl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hay tawoy mahampat ya pagnanakem ay ampaghalità nin kahampatan. Hay tawo balè ya mala-et ya pagnanakem ay ampaghalità nin kala-etan. ");
INSERT INTO sbl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anhalita-en ko komoyo: ha lomateng ya allon panonosga, kaganawan tawoy naghalità nin ayin kowintay halità ay ma-in tobayen ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hay panosgawan komo nin Diyos ay no anyay hinalità mo. No kahampatan ya hinalità mo ay agka parosawan nin Diyos, piro no kala-etan ya hinalità mo ay parosawan ka nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hapa-eg, ma-in ongnoy tawoy mangitorò nin kawkapanogo-an ya hinolat ni Moysis boy ongnoy Parisiyo ya naghalità koni Apo Hisos, ya wanla, “Apo, labay nawen makakit nin papag-ispantawan ya gaw-en mo.” ");
INSERT INTO sbl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hinalità konla ni Apo Hisos, “Masyado,” wana, “nin la-et nin tawtawo hapa-eg pana-on ta inalih lay pantotompel la ha Diyos. Ampanikap kawon papag-ispantawan piro ayin ma-ipakit komoyo, no alwan hatoy nangyari hin hato koni propita Honas. ");
INSERT INTO sbl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hi Honas ay lo-ob tatloy allo boy tatloy yabi nin anti ha lalè tiyan nin malhay ya ikan. Ombayro itaman kongko ya an-ingaten Anak nin Tawo, hiko ay itabon boy manatili ko ha lalè lotà nin lo-ob tatloy allo boy tatloy yabi. ");
INSERT INTO sbl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha allon panonosga, hay tawtaga Ninibi ay magriklamo nin tongkol komoyon tawtawo hapa-eg pana-on, ta pinaghehean lay kawkasalanan la hin nalengè lay in-aral ni Honas. Piro hikawo ay ahè naghehe ha kawkasalanan ya hay ampangaral komoyo hapa-eg ay ayin kanayon no alwan hiko ya mas et koni Honas. ");
INSERT INTO sbl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ha allo nin panonosga, hay rayna ya na-ibat ha bandan bagatan ay magriklamo nin tongkol ha tawtawoy angkabiyay hapa-eg pana-on. Nilibot nay kagitnà nin habayti ya babon lotà ta nako ya bayrin nanlengè nin torò ni Arì Solomon ya maronong, piro anhalita-en ko komoyo ya ma-in bayri hapa-eg nin mas maronong kisa koni Arì Solomon.” ");
INSERT INTO sbl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Hapa-eg, naghalità ana et hi Apo Hisos, ya wana, “No nog-alih ana ya mala-et ya ispirito ha tawoy pinahokan na ay antomalà ya ha lawak nin mamiliw pama-inawawan na. No ayin yan makit ay halita-en na ha sarili na ya ombayri: ");
INSERT INTO sbl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Magbira ko do ha tawoy pina-iriyan ko.’ Kayà nagbira ya ha tawoy pina-iriyan na. Nakit na ya hatoy tawo ay malinis boy ma-ayos, piro ayin kona ya Ispirito nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hapa-eg, nako ya nin nanagyat nin pitoy ispirito ya mas mala-et kisa kona ta mako hila nin pomahok do ha tawo. Kayà hatoy tawo ay lalò niloma-et ya gawgawà kisa hin ona. Ombayro et ya ampangyari hapa-eg ha tawtawoy mala-et ya pag-o-ogalì.” ");
INSERT INTO sbl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mintras ampaghalità hi Apo Hisos do ha tawtawo ay nakalateng ya nanay na boy pawpatel nay lalaki. Anti hila ha likol nin ampangantì ta labay lan mapagka-ilgo hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Miha ha tawtawoy anti bayro ay naghalità koni Apo Hisos, ya wana, “Hay nanay mo kateng pawpatel moy lalaki ay anti ha likol ta labay la kan mapagka-ilgo.” ");
INSERT INTO sbl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tinombay kona hi Apo Hisos, “Hino,” wana, “ya antokoyen mon nanay ko boy pawpatel ko?” ");
INSERT INTO sbl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hapa-eg, intorò na baytoy aw-alagad na boy hinalità na, “Hila bayti,” wana, “ya nanay ko boy pawpatel ko. ");
INSERT INTO sbl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hinoman ya anhomonol ha kalabayan nin Tatay koy anti ha katatag-ayan ha kama-inan na ay hila ya nanay ko boy pawpatel ko.” ");
INSERT INTO sbl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Habayto et allo, hi Apo Hisos ay nog-alih bayro ha bali ta nako yan niknò ha ambay dagat ta bayro ya manorò. ");
INSERT INTO sbl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Banà ha kalak-an tawoy nakitipon kona ay hinomapat ya ha bangkà nin niknò. Hay tawtawo itaman ay ampipampireng ha ambay. ");
INSERT INTO sbl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Malakè ya bagay ya an-itorò konla ni Apo Hisos ya aw-alimbawà. “Ma-in,” wana, “nin mihay lalaki ya nakon nanabwag. ");
INSERT INTO sbl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ha pangihabwag na ay ma-in ongnoy pahì ya natata ha daan; hatoy pawpahì ya natata ha daan ay kinan nin mawmanokmanok. ");
INSERT INTO sbl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma-in itaman pawpahì ya natata ha babon matampiyak ya bato ya ma-in amò ya lotà. Habaytoy pawpahì ay tampol tinomobò ta alwan makodpaw ya lotà ya nakataphon. ");
INSERT INTO sbl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piro hin inomamot ya hilà allo, hatoy tinomobò ay nalaneh anggan nayangoh ta mababo ya pinanyamotan. ");
INSERT INTO sbl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hay kanayon ya pawpahì ay natata ha antobo-an nin ampangayakay ya dawdikot ya madowih. Hin tinomobò baytoy pawpahì ay tinomobò itaman baytoy ampangayakay ya dawdikot ya madowih. ");
INSERT INTO sbl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piro ma-in pawpahì ya natata ha maganday lotà. Habayto ay tinomobò nin mahampat boy namonga. Ma-in pinaka-alawahanan magato; ma-in pinaka-alawahanan anemapò, boy ma-in pinaka-alawahanan tatlompò.” ");
INSERT INTO sbl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hinalità et ni Apo Hisos, “Hay ka-ilangan moyo,” wana, “ay manlengè mahampat nin habayti ya anhalita-en ko biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hapa-eg hay aw-alagad ay napakarani koni Apo Hisos ta pinastang la ya nin ombayri: “Antà aw-alimbawà ya anggamiten mon maghalità ha tawtawo?” ");
INSERT INTO sbl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tinombay konla hi Apo Hisos, “Komoyo,” wana, “inggawà ya pangingintindi nin sawsikrito ya tongkol ha pamomo-on nin Diyos; piro ha kanayon ay ahè impa-intindiyan. ");
INSERT INTO sbl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hay tawoy ampinto-o ha bagay ya an-ipa-intindi kona nin Diyos ay lalò maka-intindi ha an-ipa-intindi kona. Piro hay tawoy ahè ampinto-o ha an-ipa-intindi kona nin Diyos ay alihen et ha nakem na baytoy amò ya na-intindiyan na. ");
INSERT INTO sbl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Habayti ya bara-nan no antà aw-alimbawà ya anggamiten konlay halità, ta ampanegteg hila piro aghila ampakakit, boy ampanlengè hila piro aghila ampakalengè ni ampaka-intindi. ");
INSERT INTO sbl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Angkatopad konlay holà ni propita Isayas ya ombayri ya pagkahalità: ‘Manlengè hila man anan manlengè ay aghila maka-intindi; manegteg hila man anan manegteg ay aghila makakit. ");
INSERT INTO sbl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Habayti ya tawtawo ay matyà ya nakem nin toro-an. Anhenghengan lay tolih la boy an-i-ipleng lay mata la. No alwa dayin ombayro, makakit hila, makalengè boy maka-intindi; boy pakarani hila kongko ta alihen koy kawkasalanan la.’” ");
INSERT INTO sbl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hapa-eg, ombayri et ya hinalità ni Apo Hisos ha aw-alagad na: “Makalmà kawo ta angka-intindiyan moyoy angkakit moyo boy angkalengè moyo. ");
INSERT INTO sbl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anhalita-en ko komoyo ya hin hato ay malakè ya propita boy malakè ya tawoy antompel ha Diyos ya labay makakit nin angkakit moyo, piro agla nakit. Labay la simprin makalengè nin angkalengè moyo, piro agla nalengè.” ");
INSERT INTO sbl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Leng-en moyo,” wani Apo Hisos, “ya labay totolen nin hatoy in-alimbawà ko komoyoy mananabwag. ");
INSERT INTO sbl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hay tawtawoy ampakalengè nin halità ya tongkol ha pamomo-on nin Diyos piro agla angka-intindiyan ay bilang hilan hatoy daan ya kinatatawan nin hatoy pawpahì. Hi Satanas ay anlomateng ta an-alihen na ha nakem nin habaytoy tawtawo baytoy nalengè la. ");
INSERT INTO sbl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Hatoy matampiyak ya bato ya ma-in amò ya lotà ya kinatatawan pawpahì ay bilang ha tawtawo ya nakalengè nin Halità nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piro hay Halità nin Diyos ay ahè nakayamot ha nakem la boy kadodomalì bongat ya pananggap la. No ma-in anlomateng ya angkagolowan ihip la, boy no ampagkama-in hila nin kawkadya-dya-an nin banà ha Halità nin Diyos ay angka-alin antimano ya pantotompel la. ");
INSERT INTO sbl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hatoy lotà ya ma-in ampangayakay ya dawdikot ya madowih ya kinatatawan nin pawpahì ay bilang ha tawtawoy nakalengè nin Halità nin Diyos. Piro banà ha bawbagay ya angkagolowan la ha biyay la, boy banà ha kalabayan la nin yomaman, hila ay kowinta pawpahì ya tinomobò ya napolopotan nin ampangayakay ya dawdikot ya madowih. Kayà hay Halità nin Diyos ya nalengè la ay ahè namonga ha biyay la. ");
INSERT INTO sbl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hatoy maganday lotà ya kinatatawan nin pawpahì ay bilang ha tawtawoy nanlengè nin Halità nin Diyos. Habaytoy nalengè lay Halità nin Diyos ay na-intindiyan la boy nakapibongan kahampatan ha biyay la nin emen ha pawpahì ya ma-in namongan magato, ma-in anemapò boy ma-in namongan tatlompò.” ");
INSERT INTO sbl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Habayti et ya mihay alimbawà ya hinalità konla ni Apo Hisos, “Hay pamomo-on nin Diyos,” wana, “ay i-alimbawà ko ha mihay lalaki ya nako ha paliyan nin nanabwag nin maganday binì ya trigo. ");
INSERT INTO sbl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Piro mihay yabi, mintras angkatoloy ya tawtawo, hay ka-away na ay nilomateng nin nangihabwag bawbongan talotoh bayro ha hinabwagan nin trigo. Hin nayarì nan ginawà bayto ay nog-alih ya. ");
INSERT INTO sbl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hin anhomwak ana baytoy trigo ay nipanlomwayna itaman baytoy dawdikot ya talotoh. ");
INSERT INTO sbl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hapa-eg hay aw-alilà nin hatoy nanabwag trigo ay nako kona ta hinalità la, ‘Apo,’ wanla, ‘alwa nayì nin maganday binì ya trigo ya inhabwag mo? Ayri na-ibat baytoy dawdikot ya talotoh?’ ");
INSERT INTO sbl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tinombay ya konla, ‘Ah!’ wana, ‘habayti ay gawà nin mihay ka-away.’ “‘Labay mo nayì,’ wanla, ‘nin oloten nawen baytoy dawdikot ya talotoh?’ ");
INSERT INTO sbl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ahè,’ wana, ‘ta no oloten moyoy dawdikot ya talotoh ay maka kateng trigo ya ma-olot moyo.’ ");
INSERT INTO sbl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pariho moyoyna pon nin pa-olayan bayto angga ha pangalawah; ta ha oras ya habayto ay halita-en ko ha mawmangalawah ya ombayri: ‘Oloten moyo pon ya dawdikot ya talotoh biha moyo pethen ta ipo-ol; mayarì bayto ay alawahanen moyoy trigo ta igwà ha kamalig ko.’” ");
INSERT INTO sbl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Habayti et ya kanayon ya alimbawà ya hinalità konla ni Apo Hisos, “Hay pamomo-on nin Diyos,” wana, “ay i-alimbawà ko ha bot-o nin mostasa ya intanem nin mihay lalaki ha pananamanan na. ");
INSERT INTO sbl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maski pinakamayamò baytoy bot-o, pantomobò ay anhomlay nin mas et ha kanayon ya po-on gawgolay ta ampag-in nin emen ha po-on kayo. Kayà hay mawmanokmanok ay ampanayi ha hawhanga nin habayto.” ");
INSERT INTO sbl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Habayti et ya alimbawà ya hinalità ni Apo Hisos, “Hay pamomo-on nin Diyos ay bilang ha pampalbag ya kinwa nin babayi ta inla-ok na ha tatloy hokat nin arina. Hapa-eg hatoy arina ya nila-okan nin pampalbag ay nilombag.” ");
INSERT INTO sbl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aw-alimbawà ya anggamiten ni Apo Hisos ha pangitorò na ha kaganawan tawo. Agya ampanorò konla nin ahè ampanggamit alimbawà. ");
INSERT INTO sbl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Habayti ya ginawà na ay nagkapeteg ya holà nin propita ya ombayri ya pagkahalità: “Aw-alimbawà ya gamiten kon mangitorò ha tawtawo. Halita-en ko konlay bawbagay ya sikrito pa-ibat hin pinalsa ya babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hapa-eg, inalihan ni Apo Hisos baytoy tawtawo ta nilomo-ob ya ha bali. Hay aw-alagad na ay nako kona ta hinalità la ya ombayri: “Ibalità mo,” wanla, “konnawen no anyay labay totolen nin hatoy in-alimbawà moy dawdikot ya talotoh ya tinomobò ha paliyan.” ");
INSERT INTO sbl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tinombay konla hi Apo Hisos, ya wana, “Hay lalaki ya nangihabwag nin maganday binì ya trigo ay ayin kanayon no alwan hiko ya an-ingaten Anak nin Tawo. ");
INSERT INTO sbl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hay ka-alimbawa-an nin paliyan ay babon lotà; hay ka-alimbawa-an nin hatoy maganday binì ay tawtawo ya ampag-ari-an nin Diyos; boy hay ka-alimbawa-an nin dawdikot ya talotoh ay tawtawoy ampag-ari-an ni Satanas. ");
INSERT INTO sbl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hay ka-away ya nangihabwag nin hatoy dawdikot ya talotoh ay hi Satanas. Hay ka-alimbawa-an nin pangalawah ay ka-anggawan nin babon lotà, boy hay mipangalawah ay aw-anghil. ");
INSERT INTO sbl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","No pangnoy panipon nin hatoy dawdikot ya talotoh ya ipo-ol, lano ha ka-anggawan nin babon lotà ay ombayro itaman ya mangyari ha tawtawoy mangala-et. ");
INSERT INTO sbl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hiko ya an-ingaten Anak nin Tawo ay mangihogò nin aw-anghil kon manipon nin kaganawan tawoy ampangibatan nin kasalanan boy kaganawan ampipanggawà kala-etan. Hila ay ahè makapakilamo ha tawtawoy ampag-ari-an nin Diyos, ");
INSERT INTO sbl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ta itapon hila ha apoy. Bayro hila mi-angaw-angaw boy manget-et nin ngipen banà ha tanamen lay dya-dyà. ");
INSERT INTO sbl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hapa-eg hay tawtawoy ikon nin Diyos ay homawang nin bilang ha allo do ha dogal ya ampag-ari-an nin Tatay lay Diyos. Hay ka-ilangan moyo ay manlengè mahampat nin habayti ya anhalita-en ko biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Hay pamomo-on nin Diyos,” wana et ni Apo Hisos, “ay i-alimbawà ko ha gintò ya nakatagò ha lalè lotà ya natompakan nin mihay tawo. Habaytoy gintò ay tinagpenan nan oman boy maliga yay norong. Hapa-eg, inlakò nay kaganawan kamama-in na ta hinaliw na baytoy dogal emen na mapag-ikon baytoy gintò. ");
INSERT INTO sbl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hay pamomo-on nin Diyos ay i-alimbawà ko et ha tawoy magninigosyo ya ampanikap nin maganday pirlas ya ma-irap matompakan. ");
INSERT INTO sbl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hapa-eg, hin nakit na ay inlakò nay kaganawan kamama-in na ta hinaliw na baytoy ma-alagà ya pirlas.” ");
INSERT INTO sbl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hay pamomo-on nin Diyos,” wana et ni Apo Hisos, “ay i-alimbawà ko ha eket ya indabò ha dagat ya nakakwa nin hari-harì ya klasin ikan. ");
INSERT INTO sbl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hin napnò anan ikan baytoy eket ay inggoloy nin mawmanlalapet ha lakatan. Hapa-eg, niknò hila ta pinipapapawà lay nakwa la. Hay aw-ikan ya maganday klasi ay impalaman la ha pambiyanan, piro hay ayin kowinta ay intapon la. ");
INSERT INTO sbl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ombayri ya mangyari lano ha ka-anggawan nin babon lotà. Hay aw-anghil ay lomateng ta hay mangala-et ya tawtawo ay ipapawà la ha mangahampat, ");
INSERT INTO sbl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","biha hay mangala-et ay itapon ha apoy. Bayro hila mi-angaw-angaw boy manget-et nin ngipen banà ha tanamen lay dya-dyà. ");
INSERT INTO sbl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Na-intindiyan moyo nayì ya bawbagay ya habayti?” wani Apo Hisos. “Awò,” wanla, “na-intindiyan nawen.” ");
INSERT INTO sbl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hapa-eg, hinalità konla ni Apo Hisos, “Balang mangitorò nin kawkapanogo-an ya nag-in miha ha ampag-ari-an nin Diyos, hiya ay bilang ha tawoy nangilimpeh nin da-an boy bayoy kahangkapan ha pangilimpehan na biha na kowen nin gamiten.” ");
INSERT INTO sbl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hin nayarì nin hinalità ni Apo Hisos baytoy aw-alimbawà ay nog-alih ya ha dogal ya habayto, ");
INSERT INTO sbl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ta norong ya ha Nasarit ya sarili nan banowa. Nako ya ha himba-an nin Hawhodiyo nin manorò. Hay ampipanlengè kona ay ampipag-ispanta, ya wanla, “Ayri nangibat ya ombayri ya karonongan na boy pangno na nagawà bayti ya pawpapag-ispantawan? ");
INSERT INTO sbl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Warì alwan hiya bayti ya anak nin karpintiro? Warì alwan hi Mariya ya nanay na boy hay pawpatel nay lalaki ay hi Santiyago, hi Hosi, hi Simon, boy hi Hodas? ");
INSERT INTO sbl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Warì alwan hay pawpatel nay babayi ay anti bayri? Ayri na natotowan bayti ya kaganawan nin habayti?” ");
INSERT INTO sbl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Habaytoy tawtawoy nipagpastang ay ahè nipananggap koni Apo Hisos. Hapa-eg, hinalità konla ni Apo Hisos, “Hay propita ay an-igalang ha maski ayrin dogal, piro ahè an-igalang ha sarili nan banowa boy agya an-igalang nin sarili nan pamilya.” ");
INSERT INTO sbl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Banà ta hay tawtawo bayro ay ayin katetpel koni Apo Hisos ay amò bongat ya papag-ispantawan ya ginawà na. ");
INSERT INTO sbl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Habayton pana-on, hin nalengè ni Arì Hirodis ya tongkol ha gawgawà ni Apo Hisos ");
INSERT INTO sbl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ay hinalità na ha tawtawowan na, “Hiya,” wana, “hi Howan Mamiminyag ya nabiyay oman; kayà ampakagawà ya nin habayti ya pawpapag-ispantawan.” ");
INSERT INTO sbl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ombayri pon ya pangyayari hin ahè et nati hi Howan Mamiminyag: hi Hirodiyas ay ahawa ni Pilipi ya patel ni Arì Hirodis. Hapa-eg hi Hirodiyas ay inayo ni Arì Hirodis ta pinag-ahawa na. Banà bayri ay hinalità ni Howan Mamiminyag koni Arì Hirodis, “Alwan tamà,” wana, “ya ginawà mo ta inayo mon pinag-ahawa ya ahawa nin patel mo.” Hapa-eg, ha kagagaw-an ni Hirodiyas, hi Howan ay imparakep boy impapiriso ni Arì Hirodis. ");
INSERT INTO sbl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Labay dayin ipapati ni Ari Hirodis hi Howan, piro angkalimo yan maggolo baytoy tawtawo ta ampinto-o hila nin hi Howan ay propita. ");
INSERT INTO sbl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hin na-abot ya impanganak ni Arì Hirodis, hay dalagay anak ni Hirodiyas ay tinomalek ha arapan nin tawtawoy kinombida. Banà ha pantomalek nin hatoy dalaga ay nangonsowilo hi Arì Hirodis. ");
INSERT INTO sbl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kayà nagpangakò ya do ha dalaga nin igwà na konay maski anyay labay na. ");
INSERT INTO sbl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Banà ha dikta nin nanay na ay hinalità na koni Arì Hirodis, “Hapa-eg et,” wana, “hay olo ni Howan Mamiminyag ay igwà mo ha bandihado ta igwà mo kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hay arì ay nilomelè, piro banà do ha pagpangakò na ha arapan nin hatoy tawtawo ay hinonol nay labay nin hatoy dalaga. ");
INSERT INTO sbl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hi Arì Hirodis ay nangihogò nin mako ha pirisowan ta hi Howan ay impapotohan nan olo. ");
INSERT INTO sbl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nayarì bayto, hatoy olo ay impapa-igwà na ha bandihado, biha inggawà do ha dalaga. Hato itaman ya dalaga ya nambi nin hatoy olo do ha nanay na. ");
INSERT INTO sbl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hapa-eg hay aw-alagad ni Howan Mamiminyag ay nako bayron nangwan bangkay na biha la ya intabon; hin nayarì ay imbalità la koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hin nalengè ni Apo Hisos baytoy nangyari koni Howan ay nog-alih ya ha dogal ya habayto. Hinomakay ya ha bangkà ta napa-alilih yan nako ha powiray dogal. Piro hay tawtawoy nakatandà nin dogal ya nilako na ay nog-alih ha bawbanowa la, ta kinomamat koni Apo Hisos nin nowakon nagdaan ha ambay dagat. ");
INSERT INTO sbl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hin nakalombah hi Apo Hisos bayro ha bangkà ay nakit na baytoy kalak-an tawo. Hapa-eg, na-ingalowan na hila boy hay mangama-in masakit ay pinakahampat na. ");
INSERT INTO sbl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hin mahilem ana, hi Apo Hisos ay pinakaraniyan nin aw-alagad na ta hinalità la kona, “Powiray dogal bayti,” wanla, “boy anyomabi ana. Kayà ipakitotol mo konlan habayti ya tawtawo emen hila makalako ha bawbaryo nin manaliw pamamangan la.” ");
INSERT INTO sbl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Piro hinalità konla ni Apo Hisos, “Alwan ka-ilangan,” wana, “nin mog-alih hila; hikawo ya mambi konla nin pamamangan.” ");
INSERT INTO sbl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tinombay hila kona, “Lilimay tinapay,” wanla, “boy loloway ikan bayti ya anti bayri.” ");
INSERT INTO sbl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Gitan moyo bayri kongko,” wani Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hapa-eg, hinalità ni Apo Hisos ha tawtawo ya miknò hila bayro ha dawdikot. Hin nayarì ay kinwà na baytoy limay tinapay boy loway ikan, biha ya naninglà ta habayto ay pinasalamatan na ha Diyos. Hapa-eg, binibi-hil na baytoy tinapay biha na inggawà ha aw-alagad na, ta hilay pinatayak na do ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hilay kaganawan ay nangan boy nabhoy. Hin tinipon lay natilà ya bawbi-hil ay nakapnò et nin labinloway bakol. ");
INSERT INTO sbl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hay kalak-an nipampangan ay mangalimanliboy lalaki powira et ya bawbabayi boy aw-anak. ");
INSERT INTO sbl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hapa-eg, pinahakay ni Apo Hisos ya aw-alagad na ha bangkà ta pina-ona na hilan lomipay ha kagmang mintras ampa-orongen na baytoy tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hin naka-alih baytoy tawtawo ay nagsolo yan nilomakat ha bakil ta bayro ya manalangin. Hin yabi ana, hiya ay anti bayron mimiha na. ");
INSERT INTO sbl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hapa-eg hay aw-alagad na ya anlomipay ay anti ha botlay dagat boy angka-irapan banà ha kalhayan nin dawdawoyon boy kakhawan angin ya anhomalongà konla. ");
INSERT INTO sbl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hin manga-alas kowatroyna nin palbangon, hi Apo Hisos ay ampowako ha babon lanom nin ampagpalako konla. ");
INSERT INTO sbl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hin nakit la yay ampowako ha babon lanom ay nalimo hilan masyado. “Molto!” wanla. Ha kalimowan la ay nambo-angaw hila. ");
INSERT INTO sbl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Piro antimano, nag-ilgo konla hi Apo Hisos, ya wana, “Agkawo malimo ta hiko bayti.” ");
INSERT INTO sbl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hapa-eg, iningat ya ni Pidro, “Pangino-on,” wana, “no talagan hika ba-in ay pa-owakowen mo kon magdaan ha babon lanom nin mako bahen komo.” ");
INSERT INTO sbl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Mako ka bayri,” wani Apo Hisos koni Pidro. Kayà hi Pidro ay nilomombah ha bangkà ta nowako ya ha babon lanom nin magpalako koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piro hin nakit ni Pidro ya mangalhay ya dawoyon ya gawà nin makhaw ya angin ay nalimo ya boy anlomdeg yayna. Kayà nambo-angaw ya, ya wana, “Ilibri mo ko, Pangino-on.” ");
INSERT INTO sbl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Antimano, ginawang ya ni Apo Hisos boy hinalità na kona, “Kolang,” wana, “ya pantotompel mo! Antà ampagdoda ka?” ");
INSERT INTO sbl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hapa-eg, hin hinomapat hila ha bangkà ay nagkalmay angin. ");
INSERT INTO sbl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hatoy aw-alagad ya anti ha bangkà ay hinomamba koni Apo Hisos, ya wanla, “Talagan hika ya Anak nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hapa-eg, hin nakalipay ana hili Apo Hisos ay ni-abot hila ha banowan Hinisarit. ");
INSERT INTO sbl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Banà ta hi Apo Hisos ay nabalayan nin tawtawo bayro ay nangihogò hilan mangibalità ha ampipagmasakit ha mamalibot nin habaytoy dogal. Kayà hay ampipagmasakit ay gintan la koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Impaki-i-ingalo la kona ya maski laylay dolo na ay ma-aptoh nin hatoy ampipagmasakit. Kaganawan hatoy ampipagmasakit ya naka-aptoh nin laylay dolo ni Apo Hisos ay hinomampat. ");
INSERT INTO sbl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hapa-eg, ma-in nakalateng ya Pawparisiyo boy mawmangitorò nin kawkapanogo-an ya na-ibat ha siyodad nin Hirosalim ya nagpastang koni Apo Hisos: ");
INSERT INTO sbl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Antà nin hay aw-alagad mo,” wanla, “ay ahè anhomonol ha kawka-ogali-an ya na-iknawan ha kawka-apo-apowan tamo, ta ampangan hila nin ahè ampag-ibano kompormi ha kawka-ogali-an tamo?” ");
INSERT INTO sbl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tinombay konla hi Apo Hisos, “Antà man hikawo ay anlomabag ha pawpanogò nin Diyos ta hay anhonolen moyo ay kawka-ogali-an ya na-iknawan moyo? ");
INSERT INTO sbl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hinalità nin Diyos ya ombayri: ‘Igalang moy tatay mo boy nanay mo,’ boy ombayri et ya hinalità na: ‘Hinoman ya maghalità nin mala-et ha tatay na o ha nanay na ay dapat patyen.’ ");
INSERT INTO sbl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piro an-itorò moyo ya no ma-in tawoy ma-in itambay ha tatay na o ha nanay na, ta halita-en nay, ‘Habayti ay inggawà ha Diyos,’ ");
INSERT INTO sbl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ay alwa naynan ka-ilangan igalang ya mawmato-antawo na. Ombayri moyo an-alihan alagà ya kawkapanogo-an nin Diyos ha panhohomonol moyo ha sarili moyon kawka-ogali-an. ");
INSERT INTO sbl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hikawoy mawmagkakanwarì! Tamà baytoy holà ni propita Isayas hin hato ya tongkol komoyo ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Habayti ya tawtawo, wanan Diyos ay ampaghalità nin an-igalang la ko, piro marayò ya nakem la kongko. ");
INSERT INTO sbl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ayin kowinta ya panhomamba la kongko, ta hay an-itorò lay pawpanogò nin tawtawo ay anhalita-en la nin habayto ay pawpanogò ko.’” ");
INSERT INTO sbl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hapa-eg, iningat ni Apo Hisos baytoy kalak-an tawo nin pakarani kona ta hinalità na konla, “Manlengè kawo,” wana, “boy intindiyen moyo bayti ya halita-en ko. ");
INSERT INTO sbl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hay ampakapakasalanan ha tawo ay alwan pamamangan ya an-ihobò na, no alwan hay ampakapakasalanan kona ay hatoy anhalita-en na.” ");
INSERT INTO sbl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hapa-eg hay aw-alagad ay napakarani koni Apo Hisos ta hinalità la kona, “Haba-in,” wanla, “ya hinalità mo ay nakakhit nakem nin Pawparisiyo.” ");
INSERT INTO sbl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Piro ombayri ya alimbawà ya intobay konla ni Apo Hisos: “Balang,” wana, “nin tanaman ya ahè intanem nin Tatay koy anti ha katatag-ayan ha kama-inan na ay oloten. ");
INSERT INTO sbl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pa-olayan moyo hila ta hila ay bilang bowag ya mangangakay. No bowag ya ampangakay nin kapariho nan bowag ay pariho hilan matata ha malalè ya lobot.” ");
INSERT INTO sbl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hapa-eg, naghalità hi Pidro, “Ipalinaw mo,” wana, “konnawen no anyay labay totolen nin hatoy alimbawà mo ya tongkol ha ampakapakasalanan.” ");
INSERT INTO sbl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hinalità konla ni Apo Hisos, “Warì kateng hikawo,” wana, “ay ahè ampaka-intindi? ");
INSERT INTO sbl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Warì agmoyo tandà ya anyaman ya an-ihobò ay ampagdiritso ha tiyan biha mipalwah nin ma-alih kona? ");
INSERT INTO sbl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piro hay mala-et ya hawhalità ay ampangibat ha mala-et ya nakem boy ampakapakasalanan ha tawo. ");
INSERT INTO sbl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ha nakem ampangibat ya kala-etan ihip ya bilang ha pamatin tawo, pamabayi, pamakilalaki, panakaw, pamongkok, boy paninirà pori nin kanayon. ");
INSERT INTO sbl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Habayti ya bawbagay ya ampakapakasalanan. Piro hay mangan ya ahè nag-ibano kompormi ha ka-ogali-an nin Pawparisiyo ay ahè ampakapakasalanan.” ");
INSERT INTO sbl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hi Apo Hisos ay nog-alih ha dogal ya habayto ta nako ya ha mihay dogal ya marani ha banowan Tiro boy banowan Sidon. ");
INSERT INTO sbl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bayro ay ma-in ampa-iri ya mihay babayi ya alwan Hodiyo ya nako koni Apo Hisos. Habaytoy babayi ay an-ingaten Kananiya ta alalak ya nin taga Kana-an. Hapa-eg, nambolyaw baytoy babayi, ya wana, “Pangino-on, alalak ni Arì Dabid, ingalowan mo ko, ta hay anak koy babayi ay masyadon ampa-irapan nin dimonyoy pinomahok kona.” ");
INSERT INTO sbl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piro ni mihay halità ay ahè tinombay kona hi Apo Hisos. Hapa-eg, napakarani koni Apo Hisos ya aw-alagad na ta impaki-ilgo la kona, ya wanla, “Gaw-en mo payna ya labay na emen yayna morong ta ampibobo-angaw yay anhomono kontamo.” ");
INSERT INTO sbl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hapa-eg, hinalità ni Apo Hisos do ha babayi, “Hay aw-inalalak ni Israyil,” wana, “ay bilang tawtopa ya nitawon. Hilan bongat ya pinangihogo-an kongko nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piro hatoy babayi ay napakarani koni Apo Hisos ta nanlokob yan naghalità kona, ya wana, “Pangino-on, tambayan mo ko!” ");
INSERT INTO sbl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tinombay kona hi Apo Hisos, “Hay pamamangan,” wana, “ya para ha aw-anak ay ahè itapon ha aw-aho no alwan ipakan ha aw-anak.” ");
INSERT INTO sbl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Peteg bayto, Pangino-on,” wanan hatoy babayi, “piro hay aw-aho ay ampangan nin mawmomo ya angkatata ha hilong lamisawan nin amo la.” ");
INSERT INTO sbl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hapa-eg, hinalità ni Apo Hisos do ha babayi, “Makhaw ya pantotompel mo,” wana; “kayà hay andawaten mo ay igwà komo.” Habayto et oras, hay anak nin hatoy babayi ay hinomampat. ");
INSERT INTO sbl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hi Apo Hisos ay nog-alih bayro ta nako ya ha ambay Dagat nin Galiliya. Hapa-eg, nilomakat ya ha bakil ta bayro ya niknò. ");
INSERT INTO sbl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Malakè ya tawo ya nako kona ya nantan pawpilay, pawpokol, bawbowag, pawpipi, boy malakè et ya tawoy ma-in kanayon ya dawdipirinsya. Habayti ya mangama-in dipirinsya ay inggawà la ha dani ni Apo Hisos ta pinakahampat na hila. ");
INSERT INTO sbl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hapa-eg hatoy tawtawo ay nag-ispanta hin nakit la ya hay pawpipi ay ampakapaghalità ana, hay pawpokol ay nag-in anan alwan pokol, hay pawpilay ay ampaka-owakoyna, boy hay bawbowag ay ampakakit ana. Hapa-eg, pinori lay Diyos ya anhambawan nin aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hapa-eg, iningat ni Apo Hisos ya aw-alagad na ta hinalità na konla, ya wana, “Angka-ingalowan ko bayti ya kalak-an tawo ta tatloy allo layna bayri kontamo, boy ayin hilaynan ma-ekan hapa-eg. Agko hila labay pa-orongen nin ahè nangan, ta maka ma-olaw hila ha daan mintras amporong hila.” ");
INSERT INTO sbl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hinalità kona nin aw-alagad na, “Habayti,” wanla, “ay powiray dogal. Ayri tamo mangwan pamamangan ya magkasya nin ipakan bayri ha kalak-an tawo?” ");
INSERT INTO sbl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pinastang hila ni Apo Hisos, “Ongnoy tinapay ya ma-in komoyo?” wana. “Pitoy tinapay,” wanla, “boy ma-in ongnoy mangayamò ya ikan.” ");
INSERT INTO sbl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hapa-eg hatoy kalak-an tawo ay minandawan ni Apo Hisos nin miknò ha lotà. ");
INSERT INTO sbl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","37","Nayarì bayto ay kinwa na baytoy pitoy tinapay boy hatoy ikan, ta pinasalamatan na ha Diyos biha na binibi-hil. Hapa-eg, inggawà na ha aw-alagad na ta hilay pinatayak na ha tawtawo. Hatoy tawtawoy nipampangan ay nikabhoy boy nakatipon et ya aw-alagad nin natilà ya nakapnò et nin pitoy bakol. ");
INSERT INTO sbl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hay nipampangan ya lawlalaki ay apat ya libo powira et ya bawbabayi boy aw-anak. ");
INSERT INTO sbl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mihay allo, ma-in ongnoy Parisiyo boy Sadosiyo ya nako koni Apo Hisos ta anhoboken la ya. Kayà ampagaw-en la yan papag-ispantawan ya mamapteg nin hiya ay inhogò nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Piro ombayri ya intobay konla ni Apo Hisos, “No anhomlep anay allo,” wana, “ta ma-orit ya langit ay anhalita-en moyo ya ‘Maganday pana-on nobokah.’ ");
INSERT INTO sbl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","No mahambak ta ma-orit boy mabereg ya langit ay anhalita-en moyo ya, ‘Mangoran hapa-eg allo.’ Maronong kawon mambin kahologan nin angkakit moyo ha langit; piro agmoyo tandà ya kahologan nin ampangyari hapa-eg pana-on. ");
INSERT INTO sbl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Masyadon la-et nin tawtawo hapa-eg pana-on ta inalih lay pantotompel la ha Diyos. Ampanikap kawon papag-ispantawan, piro ayin ma-ipakit komoyo no alwan hatoy nangyari hin hato koni propita Honas.” Hapa-eg, inalihan hila ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hin nakalipay ana hili Apo Hisos ay napanemteman nin aw-alagad na ya aghila nagbawon nin tinapay. ");
INSERT INTO sbl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hapa-eg, hinalità konla ni Apo Hisos, “Pag-atapan moyo,” wana, “ya pampalbag nin Pawparisiyo boy Sawsadosiyo.” ");
INSERT INTO sbl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ha ombayroy hinalità ni Apo Hisos ay andap nin aw-alagad no talagan pampalbag tinapay ya labay nan totolen. Kayà ni-i-ilgo hila, ya wanla, “Hinalità na bayto ta agtamo nagbawon tinapay.” ");
INSERT INTO sbl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tandà ni Apo Hisos no anyay ampi-i-ilgowan nin aw-alagad na; kayà hinalità na konla, “Talaga,” wana, “nin kolang ya pantotompel moyo! Antà ampididiskosyonan moyo ya agmoyo pantan tinapay? ");
INSERT INTO sbl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Warì ayin kawon pangingintindi? Warì agmoyo angkapanemteman ya limay tinapay bongat ya pinamakan kon liman libo katawo, boy warì agmoyo et angkapanemteman no ongnoy bakol ya napnò nin natipon moyoy natilà? ");
INSERT INTO sbl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hapa et baytoy pitoy tinapay ya impakan ko ha apat ya libo katawo? Ongnoy bakol ya napnò nin natipon moyoy natilà? ");
INSERT INTO sbl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Antà agmoyo angka-intindiyan ya alwan tinapay ya labay kon totolen? Mag-atap kawo ha pampalbag nin Pawparisiyo boy Sawsadosiyo.” ");
INSERT INTO sbl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hapa-eg, na-intindiyan nin aw-alagad ya alwan pampalbag nin tinapay ya anhalita-en ni Apo Hisos nin pag-atapan la, no alwan hay pag-atapan la ay tawtorò nin Pawparisiyo boy Sawsadosiyo. ");
INSERT INTO sbl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hapa-eg, hin ni-abot hili Apo Hisos ha danin banowan Sisarya Pilipo ay pinastang nay aw-alagad na, ya wana, “Anyay anhalita-en nin tawtawo? An-ihipen la warì no hino ko ya an-ingaten Anak nin Tawo?” ");
INSERT INTO sbl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tinombay hila kona, ya wanla, “Hay kanayon ay ampaghalità nin hika ay hi Howan Mamiminyag; hay kanayon ay ampaghalità nin hika ay hi propita Ilyas; hay kanayon itaman ay ampaghalità nin hika ay hi propita Hirimiyas o kanayon ya propita.” ");
INSERT INTO sbl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Hapa hikawo,” wani Apo Hisos ha aw-alagad na, “an-ihipen moyo nayì no hino ko?” ");
INSERT INTO sbl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tinombay hi Simon Pidro, “Hika,” wana, “hi Kristo ya impangakò nin Diyos boy hika ay anak nin Diyos ya angkabiyay.” ");
INSERT INTO sbl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hinalità kona ni Apo Hisos, “Makalmà ka,” wana, “Simon ya anak ni Honas, ta habayti ya kaptegan ay alwan tawo ya nangipatandà komo, no alwan Tatay koy Diyos ya anti ha katatag-ayan ha kama-inan na. ");
INSERT INTO sbl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Leng-en mo bayti ya anhalita-en ko komo: hika, hay ngalan mo ay Pidro ya hay labay totolen ay bato. Hay pamapteg mo ya tongkol kongko ay kowinta bato ya mag-in pondasyon nin tawtawoy mipantompel kongko. Kayà ayin makatalo konla maski kamatyan. ");
INSERT INTO sbl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Komo ko an-ipatayà ya kowinta sosì nin dogal ya ampag-ari-an nin Diyos, ta hika ya mama-alà ha tawtawo bayro. Hay agmo payagan bayri ha babon lotà ay ahè itaman payagan ha katatag-ayan ha kama-inan nin Diyos. Hay payagan mo bayri ha babon lotà ay payagan itaman ha katatag-ayan ha kama-inan nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hapa-eg, mahigpit nin imbibilin ni Apo Hisos ha aw-alagad na ya agla ibabalità ya hiya hi Kristo ya impangakò nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pa-ibat hin pana-on ya habayto ay inompisawan ni Apo Hisos nin impalinaw ha aw-alagad na ya mangyari kona. “Ka-ilangan akon mako ha siyodad nin Hirosalim,” wana, “ta bayro ko danasen ya masyadoy kadya-dya-an ha mawmato-ay mangama-in katongkolan, pawpo-on nin pawparì, boy ha mawmangitorò nin kawkapanogo-an. Hiko ay patyen piro ha ikatlon allo ay mabiyay akon oman.” ");
INSERT INTO sbl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piro hi Apo Hisos ay impa-alilih ni Pidro ta hinalità na kona ya ombayri: “Pangino-on, habayti ay talagan ahè payagan nin Diyos nin mangyari komo ha ingangalo na.” ");
INSERT INTO sbl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hapa-eg hi Apo Hisos ay nagpeyeh nin inomarap koni Pidro biha na ya pinagtotolan, “Pakarayò ka kongko,” wana, “Satanas. Hika ay hadlang kongko ta hay ka-ihipan mo ay ka-ihipan nin tawo, alwan ka-ihipan ya nangibat ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hapa-eg, hinalità ni Apo Hisos ha aw-alagad na, “Hinoman ya labay makilamo kongko,” wana, “ay agna honolen ya sarili nan kalabayan, no alwan te-ehen nay kadya-dya-an nin bilang ampamalatay koroh nin magpalako ha kamatyan na ta makilamo ya kongko. ");
INSERT INTO sbl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hinoman ya tawoy ampag-atap nin ahè mati ay mati et bongat, piro hinoman ya tawoy mati nin banà kongko ay malibri ta ma-in yan biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Warì ma-in mapakinabang ya tawoy makapag-ikon nin kaganawan kayamanan bayri ha babon lotà no hay kalolowa na ay mipalako ha impirno? No anti yayna ha impirno, ma-in ya warì ma-ipambeh nin sarili na para magkama-in yan biyay ya ayin anggawan? ");
INSERT INTO sbl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hiko ya an-ingaten Anak nin Tawo ay magbira bayri nin ma-in kagandawan ya ahè makwan ihipen ya bilang kagandawan nin Tatay koy Diyos. Kalamo koy aw-anghil nin mako bayri ta hosgawan koy tawtawo kompormi ha gawgawà nin balang miha konla. ");
INSERT INTO sbl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anhalita-en ko komoyo ya kaptegan, ma-in ongno bayri komoyo ya ahè mati anggan agla ko makit ya an-ingaten Anak nin Tawo ya lomateng nin mamo-on.” ");
INSERT INTO sbl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nalabah ya anem ya allo, hi Apo Hisos ay nako ha matag-ay ya bakil. Hay gintan na ay hi Pidro, kateng hi Santiyago boy hi Howan ya mipatel. ");
INSERT INTO sbl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hapa-eg, nakit la ya hay itsora ni Apo Hisos ay na-oman. Hay lopa na ay nag-in bilang kahawang hilà allo, boy hay dolo na ay nag-in pagkapopotì nin bilang ha hawang. ");
INSERT INTO sbl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Totongna, nakit nin hatoy tatloy alagad hi Moysis boy hi Ilyas ya ampaki-ilgo koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hapa-eg, hinalità ni Pidro koni Apo Hisos, “Pangino-on,” wana, “mahampat ya anti tamo bayri. No labay mo ay manggawà akon tatloy pa-ihilongan. Hay miha ay para komo, hay miha ay para koni Moysis, boy hay miha ay para koni Ilyas.” ");
INSERT INTO sbl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mintras ampaghalità et hi Pidro ay ma-in hay hawang leem ya naka-amey konla, boy ma-in hilan nalengè ya bosis bayro ha leem ya ombayri ya hinalità: “Habayti ya mimihay Anak koy pinakalabilabi ko ya ampakapakonsowilo kongko; hiya ya honolen moyo!” ");
INSERT INTO sbl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hin nalengè bayto nin hatoy aw-alagad ay masyado hilan nalimo; kayà nanlokob hila ha lotà. ");
INSERT INTO sbl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hapa-eg hi Apo Hisos ay napakarani konla ta inaptoh na hila boy hinalità na konla, “Mibangon kawo,” wana, “boy agkawo malimo.” ");
INSERT INTO sbl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hin nanegteg hila ay ayin hilaynan nakit ya kanayon no alwan hi Apo Hisos tana. ");
INSERT INTO sbl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Peleg anlomohan hili Apo Hisos ha bakil ay binibilinan na baytoy tatloy alagad na nin ombayri: “Habayti ya nakit moyo ay agmoyo ibabalità ha maski hino anggan hiko ya an-ingaten Anak nin Tawo ay ahèet mati biha mabiyay oman.” ");
INSERT INTO sbl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hapa-eg hi Apo Hisos ay pinastang nin hatoy tatloy alagad na, ya wanla, “Antà anhalita-en nin mawmangitorò nin kawkapanogo-an ya hay ma-onan lomateng ay hi Ilyas ya propita hin hato?” ");
INSERT INTO sbl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tinombay ya konla, “Peteg,” wana, “nin ma-in pon lomateng ya emen koni Ilyas ta ihandà nay kaganawan bagay. ");
INSERT INTO sbl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piro anhalita-en ko komoyo ya hatoy tawo ya emen koni Ilyas ay nakalateng ana, piro agya nabalayan nin tawtawo. Kayà ginawà lay balang labay lan gaw-en kona. Ombayro simpri ya mangyari ha an-ingaten Anak nin Tawo ya ayin kanayon no alwan hiko. Magdanas ako nin kawkadya-dya-an ha gamet la.” ");
INSERT INTO sbl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hapa-eg, na-intindiyan nin aw-alagad ya hatoy hinalità ni Apo Hisos ya lomateng ya hi Ilyas ay ayin kanayon no alwan hi Howan Mamiminyag. ");
INSERT INTO sbl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hin ni-abot hili Apo Hisos do ha kalak-an tawo ay ma-in mihay lalaki ya napakarani kona. Nanalimokod ya ta hinalità na, ");
INSERT INTO sbl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo,” wana, “ingalowan moy anak koy lalaki ya togawen. Masyado yan angka-irapan ta mabetbet yan mihapog ha apoy boy milemlem ha lanom. ");
INSERT INTO sbl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gintan ko ya ha aw-alagad mo piro agla ya mapakahampat.” ");
INSERT INTO sbl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tinombay hi Apo Hisos, ya wana, “Hikawo ya tawtawo hapa-eg ay talagan ayin katetpel ha Diyos boy masyado kawon ampipagkamalì. Anggan makano ya pagte-eh ko komoyo biha kawo tompel kongko?” Hinalità ni Apo Hisos do ha lalaki, “Gitan mo,” wana, “bayri ya anak mo.” ");
INSERT INTO sbl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hapa-eg hatoy dimonyoy pinomahok do ha anak ay minandawan ni Apo Hisos nin mog-alih. Kayà nog-alih baytoy dimonyo boy habayto et oras ay hinomampat baytoy anak. ");
INSERT INTO sbl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hapa-eg hay aw-alagad ni Apo Hisos ay nako kona nin hilahilan bongat ta nagpastang, “Antà,” wanla, “nin agnawen mapa-alih baytoy dimonyo?” ");
INSERT INTO sbl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tinombay konla hi Apo Hisos, “Banà,” wana, “ta kolang ya pantotompel moyo, piro habayti ya halita-en ko komoyo: no ma-in kawon pantotompel ya maski bilang kayamò nin bot-on mostasa, ta halita-en moyo bahen ha bakil ya, ‘Magkambya ka,’ ay magkambya ba-in. Ayin ma-irap ya bagay ya ahè pangyariyen komoyo nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piro habayti ya ombayri ya klasin dimonyo ay agmoyo mapa-alih no agmoyo gaw-en ya magpaltan mangan ta sigisigi ya panalangin.” ");
INSERT INTO sbl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hapa-eg mintras antomalà hili Apo Hisos ha probinsyan Galiliya ay hinalità na ha aw-alagad na, “Hiko ya an-ingaten Anak nin Tawo,” wana, “ay igwà ha tawtawoy mangama-in katongkolan ");
INSERT INTO sbl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ya mangipapati kongko, piro ha ikatlon allo ay mabiyay akon oman.” Hapa-eg hay aw-alagad na ay masyadon nilomelè. ");
INSERT INTO sbl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hin hi Apo Hisos kateng aw-alagad na ay ni-abot ha banowan Kapirnawom, hay mawmanininon bo-ih ya para ha bali nin Diyos ay nakon nagpastang koni Pidro, ya wanla, “Hay mangangaral moyo ay ampamayad nayì nin bo-ih?” ");
INSERT INTO sbl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Awò, ampamayad ya,” wani Pidro. Hapa-eg, hin nako hi Pidro ha bali ay na-onan nagpastang kona hi Apo Hisos, ya wana, “Anyay palagay mo, Pidro? Bayri ha babon lotà, hinoy mamayad bo-ih ha aw-arì? Hato nayì ya tawtawowan la o dawdayowan?” ");
INSERT INTO sbl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Hatoy dawdayowan,” wani Pidro. Hinalità kona ni Apo Hisos, “Hay labay totolen awod,” wana, “ay alwan ka-ilangan mamayad ya tawtawowan la. ");
INSERT INTO sbl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piro emen ahè halita-en nin hatoy mawmanininon bo-ih ya angkomontra tamo konla ay mako ka ha dagat ta mangawil ka. Lo-aten moy bebey nin onan ikan ya makwa mo, ta bayro mo kowen ya sintimos ya tamà nin ibayad ha bo-ih ta.” ");
INSERT INTO sbl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hin oras ya habayto, hay aw-alagad ni Apo Hisos ay napakarani kona nin nagpastang, “Hino,” wanla, “ya pinaka-igit lano ha tawtawo ha dogal ya ampag-ari-an nin Diyos?” ");
INSERT INTO sbl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hapa-eg hi Apo Hisos ay nangingat nin mayamò ya anak, ta pina-ireng na ha arapan la ");
INSERT INTO sbl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","biha na hinalità, ya wanà, “Anhalita-en ko komoyo ya dapat moyon omanen ya pangingihip moyo ta towaren moyoy ka-aypa-an nakem nin aw-anak. No alwan ombayri ya gaw-en moyo ay agkawo mapalamo ha tawtawoy ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hinoman ya magpaka-aypà nakem nin bilang ombayri ha anak ay hiyay pinaka-igit ha tawtawo ha dogal ya ampag-ari-an nin Diyos; ");
INSERT INTO sbl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","boy hinoman ya mananggap boy mangasiwà nin ombayri ya anak ha ngalan ko ay hikoy antanggapen na.” ");
INSERT INTO sbl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hinalità et ni Apo Hisos, “Hinoman,” wana, “ya manggawà nin bara-nan ya pangibatan nin hay mihay anak ya antompel kongko ay makapagkasalanan, mahampat et ya hay le-ey na ay taklan nin malhay ya batoy gigilingan biha ya itapon ha dagat. ");
INSERT INTO sbl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ka-i-ingalo ya tawtawo ta ma-in malakè ya bagay ya pangibatan nin hila ay makapagkasalanan. Talagan mangyari bayti piro lalò ka-i-ingaloy mangyari ha tawoy manonoksò. ");
INSERT INTO sbl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“No hay kagmang gamet mo o kagmang bitih mo ay ampakahirà nin pantotompel mo kongko ay potohen mo ta itapon mo. Mahampat et ya mimihay gamet mo o mimihay bitih mo no hika ay magkama-in nin biyay ya ayin anggawan kisa komplitoy gamet mo boy bitih mo no hika ay itapon ha impirno ya apoy ya ahè angkaparè. ");
INSERT INTO sbl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No hay kagmang mata mo ay ampakahirà nin pantotompel mo kongko ay alihen mo ta itapon mo. Mahampat et ya mimihay mata mo no hika ay magkama-in nin biyay ya ayin anggawan kisa komplitoy mata mo no hika ay itapon ha impirno.” ");
INSERT INTO sbl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hinalità et ni Apo Hisos, ya wana, “Agmoyo yamo-yamo-en ya maski miha ha mangayamò ya aw-anak ya ombayri, ta anhalita-en ko komoyo ya hay aw-anghil ya kalamo lay ampangasiwà konla ay anti ha Tatay koy Diyos ha katatag-ayan ha kama-inan na. ( ");
INSERT INTO sbl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hiko ya an-ingaten Anak nin Tawo ay nako bayri ha babon lotà ta mangilibri nin tawtawoy nitawon emen aghila mipalako ha kaparosawan ya ayin anggawan.) ");
INSERT INTO sbl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“No ma-in tawo ya ma-in nin magatoy topa ya hay miha ay nikatak, anyay gaw-en nin hatoy tawoy ma-in topa? Agna warì ibalag baytoy siyamapò boy siyam bayro ha pagpastolan ha pallig bakil ta lakwen nan tikapen baytoy mihay topa ya nikatak? ");
INSERT INTO sbl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anhalita-en ko komoyo ya pamakakit na nin hatoy mihay topa ya nikatak ay habaytoy mas makab-i kona nin kaligawan kisa hatoy siyamapò boy siyam ya ahè nikatak. ");
INSERT INTO sbl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ombayro ya labay nin Tatay tamo ya anti ha katatag-ayan ha kama-inan na. Agna labay ya maski miha bayri ha mangayamò ya aw-anak ay mipalako ha kaparosawan.” ");
INSERT INTO sbl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Insigi ni Apo Hisos ya paghalità na, ya wana, “No hay kapara mon antompel ha Pangino-on ay nakapagkasalanan komo ay magsolo ka nin mako kona ta ibalità mo kona ya kamali-an na. No leng-en na ka ay mi-orong ya bilang da-an nin pamipatel moyo. ");
INSERT INTO sbl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piro no agya manlengè komo ay maglamo ka nin miha o lowa katawoy kapara mon antompel ha Pangino-on emen hay mapitotolan moyo ay malengè nin hatoy lowa o tatloy tistigos. ");
INSERT INTO sbl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No agya simpri manlengè ay halita-en mo ha gropon kapara mon antompel ha Pangino-on. No agya et manlengè konla ay itoring mo yayna nin ahè antompel ha Pangino-on o bilang miha ha mangaha-ol ya mawmanininon bo-ih. ");
INSERT INTO sbl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Habayti ya halita-en ko komoyo,” wana et ni Apo Hisos, “hay agmoyo payagan bayri ha babon lotà ay ahè itaman payagan ha katatag-ayan ha kama-inan nin Diyos. Hay payagan moyo bayri ha babon lotà ay payagan itaman ha katatag-ayan ha kama-inan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Anhalita-en ko et komoyo ya no ma-in lowa komoyo bayri ha babon lotà ya mapimiha ha anyaman ya bagay ya ipanalangin moyo ay pangyariyen komoyo nin Tatay koy Diyos ya anti ha katatag-ayan ha kama-inan na, ");
INSERT INTO sbl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ta no ayri ya lowa o tatlo ya ampititipon nin banà ha pantotompel ha ngalan ko, hiko ay anti konla.” ");
INSERT INTO sbl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hapa-eg hi Pidro ay napakarani koni Apo Hisos nin nagpastang, ya wana, “Pangino-on, ongnoy bisis kon patawaren ya patel koy ampakapagkasalanan kongko? Kapitoy bisis nayì?” ");
INSERT INTO sbl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Alwan bongat,” wani Apo Hisos, “no alwan pitoy bisis ya manipitompò; ");
INSERT INTO sbl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ta hay ka-alimbawa-an nin pamomo-on nin Diyos ay bilang ha mihay arì ya labay magsita nin pawpa-otang na. ");
INSERT INTO sbl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hapa-eg, hin an-ompisawan naynan gaw-en ay in-arap kona ya mihay tawoy ma-in otang kona nin liboliboy pisos. ");
INSERT INTO sbl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Piro hin ayin yan ma-ibayad ha otang na ay immanda nin hatoy amo nay arì ya ilakò ya, kateng ahawa na boy aw-anak na, boy kaganawan kamama-in na emen mabayaran ya otang na. ");
INSERT INTO sbl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Piro hatoy ma-in otang ay nanalimokod nin naki-i-ingalo do ha pinangotangan na, ya wana, ‘Pagpasinsyawan mo ko pon ta bayaran ko man komo ya kaganawan.’ ");
INSERT INTO sbl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hapa-eg hatoy amo na ya nama-otang kona ay naka-ingalo; kayà agna yayna pinabayad bayro ha otang na. ");
INSERT INTO sbl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Piro hin nanigè ana baytoy alilà ya nagka-otang ay nahakbat nay kapariho nan alilà ya ma-in amò ya otang kona. Hay ginawà na ay nilognah na ya biha na binikhe boy hinalità na kona, ya wana, ‘Bayaran moyna ya otang mo kongko.’ ");
INSERT INTO sbl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hapa-eg hatoy kapariho nan alilà ay nanalimokod nin naki-i-ingalo kona, ya wana, ‘Pagpasinsyawan mo ko pon ta bayaran ko man ya otang ko komo.’ ");
INSERT INTO sbl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piro hatoy nama-otang ay ahè pinomayag. Hay ginawà na ay impapiriso na baytoy ma-in otang kona anggan agya makabayad. ");
INSERT INTO sbl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hin nakit baytoy nangyari nin hatoy kanayon ya kapariho lan aw-alilà ay masyado hilan nilomelè. Kayà kaganawan hatoy pangyayari ay gintan lan imbalità do ha amo la. ");
INSERT INTO sbl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Hapa-eg, iningat nin hatoy amo lay arì baytoy alilà ya ahè namatawad ta hinalità na kona, ‘Hika,’ wana, ‘ya mala-et ya alilà, banà ha pamaki-i-ingalo mo ay pinatawad kata ha kaganawan inotang mo kongko. ");
INSERT INTO sbl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Antà agka nangingangalo ha kapariho mon alilà nin bilang ha pangingangalo ko komo?’ ");
INSERT INTO sbl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hapa-eg hatoy amo ya arì ay masyadon namahang; kayà hatoy alilà ya ahè namatawad ay impapiriso na anggan agna mabayaran baytoy kaganawan otang na. ");
INSERT INTO sbl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ombayro itaman ha balang miha komoyo,” wani Apo Hisos. “Hikawo ay ahè ingalowan nin Tatay tamoy Diyos ya anti ha katatag-ayan ha kama-inan na, no alwan matibolos ya nakem moyon mamatawad ha pawpatel moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hin nayarì bayton intorò ni Apo Hisos ay nog-alih ya ha probinsyan Galiliya, ta nilomipay ya ha balah nin Hordan biha ya nagpahabagatan anggan ni-abot ya ha probinsyan Hodiya. ");
INSERT INTO sbl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Malakè ya tawoy hinomono kona boy bayro na pinakahampat ya mangama-in masakit. ");
INSERT INTO sbl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hapa-eg, ma-in Pawparisiyoy nako koni Apo Hisos ta labay la yan mahagep ya magkamalì ha pagpastang la kona nin ombayri: “Ha kawkapanogo-an nayì,” wanla, “ay ampayagan ya lalaki nin mangihiyay ahawa nin maski anyay bara-nan?” ");
INSERT INTO sbl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tinombay konla hi Apo Hisos, “Warì agmoyo,” wana, “nabaha ha Halità nin Diyos ya hin ka-ona-onawan ay pinalsa nin Diyos ya lalaki boy babayi? ");
INSERT INTO sbl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Banà bayri,’ wana et nin Diyos, ‘hay lalaki ay makihiyay ha mawmato-antawo na ta makilamo ya ha ahawa na boy hilay lowa ay mag-in mimiha.’ ");
INSERT INTO sbl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kayà hila,” wana et ni Apo Hisos, “ay alwaynan lowa no alwan mimihayna. Hay pinilamo nin Diyos ay ahè pihiyayen nin tawo.” ");
INSERT INTO sbl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hapa-eg hi Apo Hisos ay pinastang ana et nin hatoy Pawparisiyo, “Antà man awod,” wanla, “nin impanogò ni Moysis ha kawka-apo-apowan nawen ya hay lalaki ay ma-arì mangihiyay nin ahawa no manggawà ya pon kaholatan nin pamihiyay?” ");
INSERT INTO sbl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tinombay konla hi Apo Hisos, “Pinayagan hila,” wana, “ni Moysis nin mangihiyay ahawa banà ha katya-an nakem lan toro-an. Piro alwan ombayro pa-ibat hin ka-ona-onawan. ");
INSERT INTO sbl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Anhalita-en ko komoyo bayti,” wana et ni Apo Hisos: “hinoman ya lalaki ya mangihiyay nin ahawa ya ahè ampakilalaki ta mag-ahawa nin kanayon ay ampamabayi ya.” ");
INSERT INTO sbl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hay aw-alagad ni Apo Hisos ay naghalità kona, “No masyadon dya-dyà awod,” wanla, “ya mangihiyay nin ahawa ay mas mahampat et ya agana mag-ahawa.” ");
INSERT INTO sbl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tinombay konla hi Apo Hisos, “Alwan kaganawan ay mananggap nin habayti ya ombayri ya torò ya tongkol ha pag-ahawa, no alwan haton bongat ya tambayan nin Pangino-on. ");
INSERT INTO sbl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Malakè ya bara-nan no antà hay lalaki ay ahè makapag-ahawa. Hay kanayon ay ma-in dipirinsya pa-ibat hin in-anak; hay kanayon itaman ay banà ta napakapon; boy hay kanayon ay ansadya-en lan ahè mag-ahawa emen la mahonol nin mahampat ya pangi-aral nin tongkol ha pamomo-on nin Diyos. Hinoman ya makakaya ay mananggap nin habayti ya torò.” ");
INSERT INTO sbl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma-in ongnoy tawoy nantan nin mangayamò ya aw-anak ta dinawat la koni Apo Hisos ya ipababo nay gamet na bayro ha aw-anak boy ipanalangin na hila, piro hatoy tawtawo ay anha-aren nin aw-alagad. ");
INSERT INTO sbl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Banà bayro ay hinalità konla ni Apo Hisos ya ombayri: “Hay aw-anak ay agmoyo ha-aren, no alwan pa-olayan moyo hilan pakarani kongko, ta hay pamomo-on nin Diyos ay anti ha tawtawoy ma-in pamahimalà kona nin bilang ombayri ha pamahimalà nin habayti ya mangayamò ya aw-anak.” ");
INSERT INTO sbl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hapa-eg, impababo ni Apo Hisos ya gamet na do ha aw-anak ta binindisyonan na hila biha ya nog-alih. ");
INSERT INTO sbl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Minghan, ma-in mihay lalaki ya napakarani koni Apo Hisos. “Mangangaral,” wana, “anyay mahampat ya bagay ya dapat kon gaw-en emen ako magkama-in biyay ya ayin anggawan?” ");
INSERT INTO sbl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hinalità kona ni Apo Hisos, “Antà,” wana, “nin ampastangen mo ko nin tongkol ha mahampat? Mimiha ya mahampat; ayin kanayon no alwan Diyos. Honolen moy pawpanogò na no labay mon magkama-in biyay ya ayin anggawan.” ");
INSERT INTO sbl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Anyay pawpanogò?” wanan hatoy lalaki. Tinombay kona hi Apo Hisos nin ombayri: “Agka mamatin tawo, agka mamabayi o makilalaki, agka manakaw, agka manistigos nin ayin kaptegan, ");
INSERT INTO sbl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","igalang moy tatay mo boy nanay mo, boy labiyen moy kapara mon tawo nin bilang ha panlalabi mo ha sarili mo.” ");
INSERT INTO sbl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hay intobay nin hatoy malagò ya lalaki ay ombayri: “Hinonol koyna,” wana, “bayti ya kaganawan panogò. Anya et ya ka-ilangan kon gaw-en?” ");
INSERT INTO sbl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tinombay kona hi Apo Hisos, “No labay mon mag-in ayin kakolangan,” wana, “ay morong ka ta ilakò moy kaganawan kamama-in mo, boy hay napaglako-an ay igwà mo ha mawmanga-irap emen ka magkama-in nin kayamanan ha katatag-ayan ha kama-inan nin Diyos. Pangayarì mon gaw-en bayto ay magbira ka bayri ta makilamo ka kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hin nalengè bayto nin hatoy malagò ya lalaki ay malelè yay nog-alih ta hay kamama-in na ay pagkalalakè. ");
INSERT INTO sbl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hinalità ni Apo Hisos ha aw-alagad na, “Habayti,” wana, “ya anhalita-en ko komoyo: hay tawoy mayaman ay ma-irap mapalamo ha tawtawoy ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Habayti et ya halita-en ko komoyo: mas maparah et ha mihay kamel ya magdaan ha lobot nin karayem kisa ha mihay mayaman ya mapalamo ha tawtawoy ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hin nalengè bayti nin hatoy aw-alagad ay masyado hilan nag-ispanta boy hinalità la, ya wanla, “Hinoman awod ya malibri?” ");
INSERT INTO sbl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Piro tinegteg hila ni Apo Hisos biha na hinalità konla, ya wana, “Ahè ma-ilibri nin tawo ya sarili na, no alwan Diyos ya mangilibri kona ta kaganawan bagay ay ma-arì pangyariyen nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hapa-eg, naghalità hi Pidro, “Helken mo,” wana. “Imbalag nawen ya kaganawan ta nakilamo kayi komo. Anyay matanggap nawen?” ");
INSERT INTO sbl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hinalità konla ni Apo Hisos, ya wana, “Anhalita-en ko komoyo ya kaptegan: ha bayowen ya kaganawan, hiko ya an-ingaten Anak nin Tawo ya ma-in kagandawan ya ahè makwan ihipen ay miknò ha trono. Hikawo ya nakilamo kongko ay miknò itaman ha labinloway trono ta manosga ha labinloway lipì ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hinoman ya mangibalag nin pamamali na, pawpatel na, mawmato-antawo na, aw-anak na, o lotà na banà ha panhomonol na kongko ay matanggap nan kamagatoy bisis nin mi-orong kona baytoy imbalag na, boy magkama-in yan biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Malakè ya ampagmalhay hapa-eg, piro lano ay mag-in hilan pinaka-oltimo ha tawtawoy ampag-ari-an nin Diyos. Malakè itaman ya ampagma-aypà hapa-eg, piro lano ay mag-in hilan matag-ay ha tawtawoy ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Hay pamomo-on nin Diyos,” wani Apo Hisos, “ay i-alimbawà ko ha mihay tawoy ma-in tanaman ya aw-obas. Mahambak et, hiya ay nanagyat nin lawlalaki ya opa-an nan magtrabaho ha tawtanaman nay obas. ");
INSERT INTO sbl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nakisondò ya konla nin bayaran na hila kompormi ha an-i-opà ha lo-ob mihay allon pagtrabaho, biha na hila inhogò magtrabaho do ha tawtanaman nay obas. ");
INSERT INTO sbl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hin mag-a-alas nowibi ana ay nako ya ha danin palingki. Bayro ay nakakit yan ongnoy lalaki ya ayin trabaho. ");
INSERT INTO sbl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kayà hinalità na konla, ‘Mako kawo,’ wana, ‘nin magtrabaho ha tawtanaman koy obas, ta opa-an katawo nin tamà ya opà ha pagtrabaho moyo.’ Hapa-eg, nako hilan nagtrabaho. ");
INSERT INTO sbl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hin ni-ogtoynay allo boy hin alas tris ana ay ombayro simpri ya ginawà na. ");
INSERT INTO sbl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hin mag-a-alas singkoyna nin mahilem ay nako yayna et do ha danin palingki. Bayro ay nakakit yayna et nin ongnoy lalaki ya ampipampireng. Pinastang na hila, ‘Antà,’ wana, ‘nin ansayangen moyoy managa-allo nin ayin anggaw-en?’ ");
INSERT INTO sbl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tinombay hila kona, ‘Ayin,’ wanla, ‘nin mangopà konnawen nin magtrabaho.’ Hinalità na konla, ‘Mako kawo,’ wana, ‘nin magtrabaho ha tawtanaman koy obas.’ ");
INSERT INTO sbl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hin anyomabi ana, hatoy ma-in ikon nin tawtanaman ay naghalità do ha pinaba-alà na, ‘Ingaten moyna,’ wana, ‘ya mawmagtatarabaho ta igwà moynay opà la nin hay onawen mon biyan ay hatoy nikahoyot mon pinatrabaho.’ ");
INSERT INTO sbl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hapa-eg hatoy lawlalaki ya alas singkoyna nin nagtrabaho ay inopa-an na nin opà lo-ob managa-allo. ");
INSERT INTO sbl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hin nilomateng baytoy onan hinagyat nin magtrabaho ay an-asawan lan mas et bayro ya opà la ha in-opà do ha nikahoyot nagtrabaho. Piro ombayro simpri ya in-opà konla. ");
INSERT INTO sbl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mintras antanggapen lay opà la ay ampagriklamo hila do ha namatrabaho konla. ");
INSERT INTO sbl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Hato,’ wanla, ‘ya nikahoyot ay mimihay oras bongat nagtrabaho, piro hay opà la ay impantay mo ha opà nawen ya hikayi ay mikaka-allon nagpagal nin nagtrabaho boy nagte-eh nin amot allo.’ ");
INSERT INTO sbl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Hatoy namatrabaho ay tinombay ha miha konla, ‘Patel,’ wana, ‘agkata nilogi. Agka nayì nakisondò kongko nin hay i-opà ko komo ay tamà ha opà nin magtrabahon mihay allo? ");
INSERT INTO sbl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hapa-eg ay kowen moy opà mo ta morong kayna. Habayti ya nahoyot ay labay kon opa-an nin bilang ha in-opà ko komo. ");
INSERT INTO sbl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Warì ayin akon karapatan gaw-en ya kalabayan ko ha sarili kon kowalta? Ampag-inggit ka nayì ta mabibi-iyen ako?’ ");
INSERT INTO sbl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Kayà,” wani Apo Hisos, “ha tawtawo ay ma-in pangyayari ya hay nika-ona ay emen hilay nahoyot, boy hay nahoyot ay emen nika-ona.” ");
INSERT INTO sbl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mintras ampagpalako hili Apo Hisos ha siyodad nin Hirosalim ay impa-alilih nay aw-alagad na ta hinalità na konla, ");
INSERT INTO sbl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Leng-en moyo bayti ya halita-en ko komoyo. Hitamo ay ampagpalako ha siyodad nin Hirosalim. Bayro, hiko ya an-ingaten Anak nin Tawo ay igwà ha pawpo-on nin pawparì boy ha mawmangitorò nin kawkapanogo-an, ta sintinsyawan la ko nin patyen. ");
INSERT INTO sbl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Igwà la ko ha alwan Hawhodiyo, ta hay gaw-en la nin habayto ay pagsistiyan la ko, barogen, boy ipakò ha koroh. Pangati ko, lomateng ya ikatlon allo ay mabiyay akon oman.” ");
INSERT INTO sbl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hapa-eg, nakalateng ya ahawa ni Sibidiyo kalamo nay loway anak nay lalaki. Napakarani ya koni Apo Hisos ta nanalimokod yan ampangawok kona. ");
INSERT INTO sbl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pinastang ya ni Apo Hisos, “Anya,” wana, “ya labay mon awoken kongko?” Tinombay ya kona, “An-awoken ko komo,” wana, “ya lano do ha dogal ya ampag-ari-an mo, habayti ya loway anak ko ay pa-ikno-en mo ha dani mo, miha ha bandan wanan mo boy miha ha bandan oki mo.” ");
INSERT INTO sbl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hinalità ni Apo Hisos konla, “Agmoyo,” wana, “angka-intindiyan ya an-awoken moyo. Makat-eh kawo warì ha kadya-dya-an ya te-ehen ko?” “Awò,” wanla, “kaya nawen.” ");
INSERT INTO sbl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hapa-eg, hinalità konla ni Apo Hisos, ya wana, “Talagan peteg nin te-ehen moyoy kadya-dya-an ya te-ehen ko. Ombayro man ay alwan hikoy magdisisyon no hinoy miknò ha bandan wanan ko boy ha bandan oki ko. Habaytoy ikno-an ay para ha tawtawoy hinanda-an nin Tatay koy Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hatoy mapò ya alagad ay namahang do ha loway mipatel hin natanda-an la baytoy an-awoken nin nanay nin hatoy mipatel. ");
INSERT INTO sbl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kayà iningat ni Apo Hisos nin pakarani kona ya kaganawan alagad na ta hinalità na konla, ya wana, “Tandà moyo ya hay ampipamo-on ha alwan Hawhodiyo ay an-ipagpalangkà lay pamomo-on la, boy hay kanayon ya ma-in katongkolan ay ampamo-on nin sapilitan. ");
INSERT INTO sbl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Agmoyo gaw-en baytoy ombayro. Hinoman komoyo ya labay maka-igit ay ka-ilangan magsirbi. ");
INSERT INTO sbl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hinoman komoyo ya labay mangona ay ka-ilangan magsirbi nin bilang ha alilà ");
INSERT INTO sbl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ya bilang ombayri ha anggaw-en ko. Hiko ya an-ingaten Anak nin Tawo ay ahè nako bayri ha babon lotà nin sirbiyan, no alwan nako ko bayri nin magsirbi boy mangigwà nin biyay ko nin pambeh nin malakè ya tawo.” ");
INSERT INTO sbl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mintras ampog-alih hili Apo Hisos do ha banowan Hiriko ay hinono yan malakè ya tawo. ");
INSERT INTO sbl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ha pingit daan ay ma-in ampiknò ya loway lalaki ya bowag. Hin nalengè la ya hi Apo Hisos ay ampagdaan bayro ay nambo-angaw hila, ya wanla, “Alalak ni Arì Dabid, ingalowan mo kayi!” ");
INSERT INTO sbl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hinalità konla nin hatoy kalak-an tawo ya aghila magtelek piro lalò hilayna ingat nambo-angaw, ya wanla, “Apo, alalak ni Arì Dabid, ingalowan mo kayi!” ");
INSERT INTO sbl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hin nalengè ni Apo Hisos baytoy bo-angaw ay tinonggen ya ta pinastang na hila, “Anya,” wana, “ya labay moyon gaw-en ko komoyo?” ");
INSERT INTO sbl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Apo,” wanla, “labay nawen dayin makakit!” ");
INSERT INTO sbl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hapa-eg, na-ingalowan hila ni Apo Hisos boy inaptoh nay mata la. Antimano, nakakit hila boy nakilako hila koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hili Apo Hisos ay maranina ha siyodad nin Hirosalim ta anlomateng hilayna ha banowan Bitpahi ya ma-in bakilbakil ya an-ingaten Bakil nin Aw-olibo. Hapa-eg, pina-ona ni Apo Hisos ya loway alagad na boy hinalità na konla, ");
INSERT INTO sbl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ya wana, “Mako kawo bahen ha banowa ha onawan tamo. Pami-abot moyo bahen ay ma-in kawon makit ya nakapotal ya asno boy hay oybon na ay anti ha dani na. Oka-an moyo baytoy asno kateng oybon ta gitan moyo bayri kongko. ");
INSERT INTO sbl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No ma-in mamastang komoyo nin tongkol ha anggaw-en moyo ay ombayri ya halita-en moyo kona, ‘Habayti ay ka-ilangan nin Pangino-on’; ha ombayro, antimano ay payagan na kawon mangwa.” ");
INSERT INTO sbl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Habayti ay nangyari emen magkapeteg baytoy ombayri ya pagkahalità ha holà nin propita: ");
INSERT INTO sbl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Halita-en ha tawtawo ha siyodad nin Siyon ya hay arì la ay anlomateng ya ma-in ka-aypa-an nakem ya nakahakay ha oybon asno.” ");
INSERT INTO sbl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hapa-eg hatoy aw-alagad ya inhogò ni Apo Hisos ay nanigè ana ta ginawà la baytoy impagawà na konla. ");
INSERT INTO sbl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gintan la baytoy asno kateng oybon ta hinapinan lan aw-alimenmen la, biha hinakyan ni Apo Hisos baytoy oybon. ");
INSERT INTO sbl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kalak-an do ha tawtawoy anti bayro ay nag-alih nin alimenmen ta in-aplak la ha pagdanan ni Apo Hisos. Hay kanayon ay namotoh nin bawbolong, ta in-apin la ha pagdanan na emen la ma-ipakit ya pangigalang la kona. ");
INSERT INTO sbl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hay tawtawoy anti ha onawan ni Apo Hisos kateng hatoy anti ha hoyotan na ay ampipambo-angaw banà ha kaligawan la, ya wanla, “Yehey! Poriyen tamoy inalalak ni Arì Dabid. Bindisyonan nin Diyos ya anlomateng ha ngalan nin Pangino-on! Poriyen ya Diyos ya anti ha katatag-ayan!” ");
INSERT INTO sbl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hin nakalo-ob ana hi Apo Hisos ha siyodad nin Hirosalim ay pinagkagolowan ya nin tawtawo bayro boy wanla, “Hino ya raw bayti?” ");
INSERT INTO sbl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tinombay baytoy kalak-an tawo, “Hiya bayti,” wanla, “hi Hisos ya propita ya na-ibat ha banowan Nasarit ha probinsyan Galiliya.” ");
INSERT INTO sbl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hapa-eg hi Apo Hisos ay nako ha bali nin Diyos. Impataboy nay kaganawan anti bayroy ampipaglakò boy ampipanaliw, boy intomba nay lawlamisita nin ampipamahili nin kowalta kateng bawbangkò nin ampipaglakò nin kawkalapati. ");
INSERT INTO sbl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hapa-eg, hinalità na konla, ya wana, “Ha Halità nin Diyos ay ombayri ya nakaholat: ‘Hay bali ko ay ingaten balin panalanginan.’ Piro ginawà moyo,” wani Apo Hisos, “nin kowartil nin tawtolisan.” ");
INSERT INTO sbl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hapa-eg do ha bali nin Diyos ay napakarani koni Apo Hisos ya bawbowag kateng pawpilay. Hila ay pinakahampat na. ");
INSERT INTO sbl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piro hatoy anti bayroy pawpo-on nin pawparì kateng hatoy mawmangitorò nin kawkapanogo-an ay namahang hin nakit lay kawkapapa-ispantay ginawà ni Apo Hisos boy hin nalengè lay aw-anak ya ampipangibolyaw nin, “Poriyen ya alalak ni Arì Dabid!” ");
INSERT INTO sbl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kayà hinalità la koni Apo Hisos, “Angkalengè mo nayì,” wanla, “ya an-ibolyaw nin haba-in ya aw-anak?” “Awò,” wani Apo Hisos. “Angkalengè ko. Warì agmoyo nabaha ha Halità nin Diyos ya ombayri: ‘Hay aw-anak kateng kawkolaw ay pinapori na kona’?” ");
INSERT INTO sbl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hapa-eg, inalihan hila ni Apo Hisos ta nako ya ha banowan Bitanya boy bayro ya natoloy nin habayton yabi. ");
INSERT INTO sbl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ika-ibokah, mintras ampagbira hi Apo Hisos ha siyodad nin Hirosalim ay binomitil ya. ");
INSERT INTO sbl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hapa-eg, do ha pingit daan ay nakakit yan po-on kayoy igos. Hin pinakaraniyan na bayto ay nakit nay ayin bonga no alwan bawbolong bongat; kayà hinalità na do ha po-on kayoy igos, “Maski makakanoman,” wana, “ay agkayna mamonga.” Antimano, hatoy po-on kayoy igos ay nayangoh. ");
INSERT INTO sbl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hin nakit bayto nin aw-alagad ay nag-ispanta hila, ya wanla, “Pangno nayangon tampol ba-in ya po-on kayoy igos?” ");
INSERT INTO sbl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tinombay konla hi Apo Hisos, ya wana, “Anhalita-en ko komoyoy kaptegan: no ma-in kawon pantotompel ta agkawo magdoda ay alwan bongat ombayri ya magawà moyo ha ginawà ko ha po-on kayoy igos, no alwan mahalità moyo et bayri ha bakil ya, ‘Mitapon ka ha dagat,’ habayto ay mangyari. ");
INSERT INTO sbl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Matanggap moyoy kaganawan bagay ya andawaten moyo ha panalangin moyo no tompel kawo.” ");
INSERT INTO sbl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hin nakabira hi Apo Hisos ha bali nin Diyos boy ampanorò ya bayro, hay pawpo-on nin pawparì kateng mawmato-ay mangama-in katongkolan ay nakon nagpastang koni Apo Hisos, “Anya,” wanla, “ya katongkolan mo nin manggawà nin ombayri ya bawbagay bayri ha bali nin Diyos, boy hinoy nambi komo nin ombayroy katongkolan?” ");
INSERT INTO sbl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tinombay konla hi Apo Hisos, ya wana, “Ma-in ako pon nin mihay pastang komoyo. No matbay moyo ay ibalità ko komoyo no hinoy nambi kongkon katongkolan nin manggawà nin ombayroy bawbagay. ");
INSERT INTO sbl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ayri,” wana, “nangibat ya katongkolan ni Howan nin maminyag? Ha Diyos nayì o ha tawo?” Hilahila ay ampididiskosyon boy ma-in ampaghalità nin ombayri: “No halita-en tamo ya nangibat ha Diyos ya paminyag ni Howan ay halita-en na kontamo ya, ‘Antà awod agmoyo pininto-o hi Howan?’ ");
INSERT INTO sbl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piro no halita-en tamo itaman ya nangibat ha tawo ay maka pahangan tamo nin tawtawo, ta kaganawan tawo ay ampipampinto-o nin hi Howan Mamiminyag ay propita nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kayà hay intobay la koni Apo Hisos ay ombayri: “Agnawen,” wanla, “tandà no hinoy nambin katongkolan koni Howan.” Hinalità konla ni Apo Hisos, “Hiko man ay ahè itaman maghalità komoyo no hinoy nambi kongkon katongkolan nin manggawà nin ombayroy bawbagay.” ");
INSERT INTO sbl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hinalità ana et konla ni Apo Hisos, “Anya ha palagay moyo,” wana, “ya tongkol bayri ha halita-en ko komoyoy alimbawà? Ma-in mihay mato-antawoy lalaki ya ma-in loway anak ya parihon lalaki. Nako ya do ha anak nay onantawo ta hinalità na, ‘Anak ko,’ wana, ‘hapa-eg allo ay mako kan magtrabaho ha tanaman tamoy aw-obas.’ ");
INSERT INTO sbl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Agko,’ wanan hatoy anak. Piro nangoman ya ihip na; kayà nako ya simprin nagtrabaho. ");
INSERT INTO sbl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hatoy tatay ay nako do ha ali ta hinalità nay ombayro ha hinalità na ha kakà. ‘Awò,’ wanan hatoy anak piro agya nanigè. ");
INSERT INTO sbl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hino bayri ha loway anak,” wani Apo Hisos, “ya hinomonol ha kalabayan nin tatay la?” Tinombay hila kona, “Simpri,” wanla, “hatoy ona nin inhogò.” Kayà hinalità konla ni Apo Hisos, ya wana, “Anhalita-en ko komoyoy kaptegan, hay mangaha-ol ya mawmanininon bo-ih kateng pawpota ay ma-arì mipalako ha dogal ya ampag-ari-an nin Diyos kisa hikawo; ");
INSERT INTO sbl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ta hi Howan Mamiminyag ay nakon nangitorò komoyo no pangno kawo magkama-in kahampatan piro agmoyo hinonol ya intorò na. Hay mangaha-ol ya mawmanininon bo-ih boy pawpota ay hinomonol kona. Hikawo balè, maski nakit moyo bayti ya pangyayari ay agkawo naghehe boy agkawo ninto-o koni Howan Mamiminyag.” ");
INSERT INTO sbl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Leng-en moyo et bayti ya kanayon ya alimbawà,” wani Apo Hisos. “Ma-in mihay lalaki ya ma-in lotà ya tinanamanan na nin aw-obas. Inalal na boy nangotkot ya ta nanggawà yan pamehpehan nin bawbongan obas, biha ya nanggawà nin matag-ay ya pagbantayan. Hapa-eg, impaba-alà na ha ongnoy tawo ta nako ya ha kanayon ya dogal. ");
INSERT INTO sbl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hin pana-on anan pangalawah nin bawbongan obas ay nangihogò yan aw-alilà na do ha pinaba-alà ta kowen lay atag na ha ma-alawah. ");
INSERT INTO sbl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piro hay ginawà nin hatoy tawtawoy pinaba-alà na ay dinawohong la baytoy aw-alilà ya inhogò. Hay miha ay pinahpah la, hay miha ay pinati la, boy hay miha ay pinagbabato la. ");
INSERT INTO sbl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hapa-eg hatoy ma-in tanaman ay nangihogò ana et nin mas malakè ya alilà nay pakwawen nan atag na, piro ginawà simpri konla ya bilang ombayro ha ginawà do ha nika-ona nin inhogò. ");
INSERT INTO sbl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ha kalalampohan, hatoy ma-in tanaman ay inhogò nay anak nay lalaki ta wana, ‘Sigoradon igalang lay anak ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piro hin nakit nin hatoy pinaba-alà baytoy anak ay ni-i-ilgo hila, ya wanla, ‘Hiya bayti ya mamagmana. Hali! patyen tamo ya emen tamo mapag-ikon ya mamanawen na.’ ");
INSERT INTO sbl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kayà hay ginawà la do ha anak ay dinawohong la, boy intapon ha likol alal nin tawtanaman ya obas biha la ya pinati.” ");
INSERT INTO sbl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Hapa-eg,” wani Apo Hisos, “panlomateng nin ma-in ikon nin hatoy tawtanaman ya aw-obas, ha palagay moyo, anyay gaw-en na do ha pinaba-alà na?” ");
INSERT INTO sbl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tinombay hila kona, ya wanla, “Sigoradon ayin ingangalo nan patyen baytoy mangala-et ya tawtawo, biha hay tawtanaman na ay ipaba-alà na ha kanayon ya tawtawo ya mambi kona nin atag na no pana-on pangalawah.” ");
INSERT INTO sbl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hinalità konla ni Apo Hisos, “Warì agmoyo et,” wana, “nabaha bayti ya nakaholat ha Kaholatan nin Diyos? ‘Hay bato ya ahè tinanggap nin manggagawà bali ay nag-in pinakama-alagà ya bato. Habayti ay gawà nin Pangino-on boy masyadon kapapa-ispanta konnawen.’ ");
INSERT INTO sbl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kayà,” wana et ni Apo Hisos, “anhalita-en ko komoyo: hikawoy Hawhodiyo ay agana pag-ari-an nin Diyos, ta hay pag-ari-an na ay tawtawoy gomawà kalabayan na. ( ");
INSERT INTO sbl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hinoman ya matata bayro ha bato ay matamek, boy bilang ya ha tawoy ampagdanas kadya-dya-an ta ahè naghehe ha kasalanan; boy hinoman ya mabondagan nin habaytoy bato ay matapong, boy bilang ya ha tawoy igwà nin Diyos ha kaparosawan.”) ");
INSERT INTO sbl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hin nalengè nin pawpo-on nin pawparì boy hatoy Pawparisiyo ya aw-alimbawà ni Apo Hisos ay na-intindiyan la ya hila ya antokoyen na. ");
INSERT INTO sbl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kayà ampagsikapan la yan dakpen, piro angkalimo hila do ha kalak-an tawo ya ampipampinto-o nin hi Apo Hisos ay propita. ");
INSERT INTO sbl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Habayti ya alimbawà ya hinalità ana et ni Apo Hisos ha tawtawo, ");
INSERT INTO sbl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hay pamomo-on nin Diyos,” wana, “ay i-alimbawà ko et ha arì ya naghandà pamamangan para ha banhal nin anak nay lalaki. ");
INSERT INTO sbl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hapa-eg, hin ka-orasan anan paghandà ay inhogò nay aw-alilà nan mangalap nin hatoy da-an naynan kinombida, piro hatoy kinombida ay ahè labay mako. ");
INSERT INTO sbl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nangihogò yayna et nin kanayon ya aw-alilà nan mangalap konla ta impabalità na ya ombayri: ‘Kaganawan ay handà ana ta nawotò anay kawkarni nin pinati koy mangatabà ya bawbakà kateng aw-oybon ya ma-arì anan kona-en. Kayà mako kawoyna bayri ta banhal ana nin anak ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piro hatoy kawkinombida ay pinagka-ayin la baytoy hagyat konla. Hay miha ay nakon magtrabaho ha pawpaliyan na, boy hay miha ay nako ha tindawan na. ");
INSERT INTO sbl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hay kanayon ay nipandawohong nin hatoy aw-alilà ya pina-alap, ta pinareng-ey la biha la pinati. ");
INSERT INTO sbl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Banà bayri, hay arì ay masyadon namahang; kayà inhogò nay hawhondalò nan mamati nin hatoy nipamati nin aw-alilà na, biha na impapo-olan ya siyodad la. ");
INSERT INTO sbl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Hapa-eg, hinalità nin hatoy arì ha kanayon ya aw-alilà na, ‘Hay pamamangan,’ wana, ‘ya para ha banhal ay handà ana. Piro hatoy kawkinombida ay alwan karapatdapat ta agla pina-alaga-an ya pangombida konla. ");
INSERT INTO sbl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hapa-eg ay mangalsara kawo ta kaganawan makit moyoy tawo ay kombidawen moyo.’ ");
INSERT INTO sbl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hatoy aw-alilà ay nakoyna ha kawkalsara ta kaganawan tawoy nakit la, mala-et o mahampat ay kinombida la. Kayà habaytoy ampagbanhalan ay napnò tawo. ");
INSERT INTO sbl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Hapa-eg hay arì ay nakon nanlek do ha sawsang-ili na. Bayro ay nakakit yan mihay lalaki ya nakadolo nin alwan para ha banhal. ");
INSERT INTO sbl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Amigo,’ wanan arì, ‘pangno ka nakapahok bayri ya hay dolo mo ay alwan para ha banhal?’ Hatoy lalaki ay ahè tinombay. ");
INSERT INTO sbl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hapa-eg, hinalità nin hatoy arì do ha aw-alilà na, ‘Balolen moyo,’ wana, ‘ya gamet na boy bitih na biha moyo ya itapon ha likol ya mareglem. Bayro ya mi-angaw-angaw boy manget-et ngipen na banà ha tanamen nay dya-dyà.’” ");
INSERT INTO sbl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hinalità et ni Apo Hisos, “Hay Diyos,” wana, “ay nangingat nin malakè ya tawoy pag-ari-an na piro a-amò konla ya pinilì na.” ");
INSERT INTO sbl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hapa-eg hay Pawparisiyo ay nititipon ta ampangihip hilan paraan no pangno la mapahalità hi Apo Hisos nin panagpan la kona. ");
INSERT INTO sbl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nangihogò hilan tawtawowan la boy ongnoy tawowan ni Arì Hirodis nin makon magpastang koni Apo Hisos nin ombayri: “Mangangaral,” wanla, “tandà nawen ya hika ay tapat. Agka ampag-alangan mangitorò nin tongkol ha kalabayan nin Diyos para ha tawtawo, ta hika ay ahè ampamilì nin tawo. ");
INSERT INTO sbl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hapa-eg, tongkol ha pamamayad bo-ih, tamà nayì o alwa ya mamayad kayi nin bo-ih ha ampamo-on konnawen ya hi Arì Sisar ya taga siyodad nin Roma?” ");
INSERT INTO sbl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Banà ta tandà ni Apo Hisos ya kala-etan intinsyon la ay hinalità na konla, “Hikawo,” wana, “ya mawmagkakanwarì, antà anhagpen moyo ko ha pag-i-ilgo ko? ");
INSERT INTO sbl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitan moyo kon kowalta ya ibabayad ha bo-ih.” Hapa-eg, pinantan la yan mihay kowaltay pilak. ");
INSERT INTO sbl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pinastang hila ni Apo Hisos, “Hino,” wana, “ya ma-in lopa nin habayti ya anti bayri, boy hino ya ma-in ngalan nin habayti ya nakaholat bayri?” ");
INSERT INTO sbl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Hi Arì Sisar,” wanla. Hapa-eg, hinalità konla ni Apo Hisos, “Kayà hay para koni Arì Sisar ay igwà moyo kona, ta hay para ha Diyos ay igwà moyo ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hin nalengè lay katalinowan nin pantotombay konla ni Apo Hisos ay nag-ispanta hila boy inalihan la ya. ");
INSERT INTO sbl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma-in mihay gropon Hawhodiyo ya an-ingaten Sadosiyo ya ahè ampinto-o nin hay nikati ay mabiyay oman. Hin habayto et allo, hay ongno konla ay nakon nagpastang koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mangangaral,” wanla, “ombayri ya hinalità ni Moysis ya para kontamo: ‘No ma-in mita-ahawa ya hay lalaki ay nati nin aghila nagka-anak, hatoy bawo ay dapat pag-ahawa nin patel nin hatoy nati, ta no magka-anak hila, hatoy anak ay para do ha patel nay nati.’ ");
INSERT INTO sbl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Konnawen ay ma-in pitoy lalaki ya mipapatel. Hay ponganay ay nag-ahawa, piro nati nin ahè nagka-anak. Hatoy bawo ay pinag-ahawa nin homono ya patel nin hatoy nati. ");
INSERT INTO sbl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ombayro simpri ya nangyari do ha ikalwa, ha ikatlo, angga do ha ikapito ya bongsò lay napag-ahawa nin hatoy bawo piro kaganawan la ay nati nin ahè nagka-anak. ");
INSERT INTO sbl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ha kalalampohan ay nati baytoy babayi. ");
INSERT INTO sbl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hay pastang nawen ay ombayri: no warì ta biyayen oman ya nikati, hino konla ya ma-in ahawa nin hatoy babayi ya kaganawan nin hatoy pitoy mipapatel ay nakapag-ahawa kona?” ");
INSERT INTO sbl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tinombay konla hi Apo Hisos, ya wana, “Ampagkamalì kawo, ta agmoyo angka-intindiyan ya nakaholat ha Kaholatan nin Diyos ya tongkol ha pangabiyay oman, boy agmoyo et angka-intindiyan ya tongkol ha kapangyariyan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hay nikati ya mabiyay oman ay agana mag-ahawa, ta hila ay mag-in anan emen ha aw-anghil ya anti ha katatag-ayan ha kama-inan nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hapa-eg, tongkol ha pangabiyay oman nin nikati, warì agmoyo et nabaha bayti ya para komoyoy hinalità nin Diyos ya ombayri ya pagkahalità: ");
INSERT INTO sbl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Hiko ya Diyos ni Abraham, Diyos ni Isak boy Diyos ni Hakob’? Ampangahologan nin hay nikati ana ya nipantompel ha Diyos ay kowinta angkabiyay; ta hay Diyos ay Diyos nin ampikabiyay, alwan Diyos nin nikati.” ");
INSERT INTO sbl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hapa-eg, nipag-ispanta baytoy kalak-an tawo hin nalengè la baytoy intorò ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hin nalengè nin Pawparisiyo ya hay Sawsadosiyo ay ahè makatlek ha tawtobay konla ni Apo Hisos ay nititipon hila. ");
INSERT INTO sbl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Miha ha Pawparisiyo ya mangitorò nin kawkapanogo-an ay nagpastang koni Apo Hisos ta labay la yan mahagep ha pag-i-ilgo na. ");
INSERT INTO sbl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mangangaral,” wana, “ha kaganawan kapanogo-an, anyay pinakama-alagà?” ");
INSERT INTO sbl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tinombay kona hi Apo Hisos, ya wana, “Hay Pangino-on mon Diyos ay labiyen mo nin bo-ò ha nakem mo, ha biyay mo, boy ha pangingihip mo. ");
INSERT INTO sbl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Habayti ya pinakama-alagà boy pinaka-importantin kapanogo-an. ");
INSERT INTO sbl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hay ikalwan pinakama-alagà ya kapanogo-an ay ombayri: ‘Labiyen moy kapara mon tawo nin bilang panlalabi mo ha sarili mo.’ ");
INSERT INTO sbl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bayri ha loway panogò ya habayti nin nabo-ò ya kaganawan kapanogo-an ya inggawà ni Moysis kateng hatoy intorò nin pawpropita.” ");
INSERT INTO sbl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mintras tipon et baytoy Pawparisiyo ay pinastang hila ni Apo Hisos, ");
INSERT INTO sbl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anya,” wana, “ya an-ihipen moyo tongkol koni Kristo ya impangakò nin Diyos? Hinoy ma-in alalak kona?” “Alalak ya,” wanla, “ni Arì Dabid.” ");
INSERT INTO sbl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pinastang hilayna et ni Apo Hisos, “Antà man awod,” wana, “nin hay Ispirito nin Diyos ay nangipa-ihip koni Arì Dabid nin mangingat ‘Pangino-on’ koni Kristo? Ombayri ya hinalità ni Arì Dabid: ");
INSERT INTO sbl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Hinalità nin Pangino-on Diyos ha Pangino-on ko, Miknò ka ha bandan wanan ko anggan hay kawka-away mo ay talowen ko boy igwà ko hila ha hilong nin kapangyariyan mo.’ ” ");
INSERT INTO sbl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Hapa-eg,” wana et ni Apo Hisos, “no hi Arì Dabid ay nangingat ‘Pangino-on’ koni Kristo ya impangakò nin Diyos, pangno nin hi Arì Dabid ya tawon bongat ay nakapi-alalak ha Pangino-on na?” ");
INSERT INTO sbl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni miha konla ay ayin nakatbay nin habaytoy pastang ni Apo Hisos, boy pa-ibat hin allon habayto ay ayin anan nakaregdeg nin magpastang kona. ");
INSERT INTO sbl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hapa-eg, hinalità ni Apo Hisos do ha kalak-an tawo kateng ha aw-alagad na, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hay mawmangitorò nin kawkapanogo-an boy Pawparisiyo ya binyan katongkolan mangipalinaw nin kawkapanogo-an ya inggawà ni Moysis. ");
INSERT INTO sbl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kayà dapat moyon honolen ya kaganawan bagay ya halita-en la komoyo. Piro agmoyo towaren ya anggaw-en la, ta hay an-itorò la komoyo ay agla anggaw-en. ");
INSERT INTO sbl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hay tawtawo ay ampagaw-en lan malakè ya bagay ya ma-irap honolen, piro hilan mismo ay ahè ampanambay ha panggawà nin ombayro. ");
INSERT INTO sbl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kaganawan bagay ya anggaw-en la ay an-ipakit lan bongat ha tawtawo emen hila poriyen. Hay bawbirsikolo nin Halità nin Diyos ay an-igwà la ha malhay ya pambiyanan ya katat, biha la itakel ha waweng la boy ha braso la; boy hay pawpalamoy nin dolo la ay an-ikarà la. ");
INSERT INTO sbl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","No ma-in okasyon, hay labay lan pamikno-an ay ha dani nin hatoy ma-in pa-okasyon, boy ha lo-ob nin himba-an ay labay lan miknò ha arapan ha pamikno-an nin importantin tawo. ");
INSERT INTO sbl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No ampagpasyal hila ha plasa boy ha arapan nin tawtindawan ay labay lan ilawen boy igalang nin tawtawo, boy labay la et nin ingaten ‘Mangangaral’. ");
INSERT INTO sbl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Piro hikawo ay agkawo pa-ingat nin ombayro. Mimihay Mangangaral moyo boy hikawoy kaganawan ay mipapatel. ");
INSERT INTO sbl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bayri ha babon lotà ay agkawo dapat mangingat nin Tatay ha maski hinoy tawo, ta Diyos ha katatag-ayan ha kama-inan na ya dapat moyon bongat ingaten nin ‘Tatay.’ ");
INSERT INTO sbl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Agkawo pa-ingat nin ‘manonorò’ ta mimihay Manonorò moyo ya ayin kanayon no alwan hiko hi Kristo ya impangakò nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Emen kawo mag-in pinakamalhay ay magmaka-aypà kawon magsirbi. ");
INSERT INTO sbl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hinoman ya ampangipagmalhay nin sarili na ay angka-alihan dangal, boy hinoman ya ampagmaka-aypà ay ampagkama-in dangal.” ");
INSERT INTO sbl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lano ay ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Hay kanayon ya labay pomahok ha dogal ya ampag-ari-an nin Diyos ay agmoyo ampayagan boy mismon hikawo ay ahè malabay pomahok bayro. ( ");
INSERT INTO sbl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lano ay ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo, ta hikawo ay mawmagkakanwarì! Angkowen moyoy kamama-in nin bawbawoy babayi biha kawo mamakit nin masyadon karà panalangin. Banà bayri ha anggaw-en moyo ay lalò bomyat ya iparosa komoyo.) ");
INSERT INTO sbl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Anlomipay kawo ha dagat nin mako ha marayò ya dogal, ta ampanlek kawo nin maski mihay makombinyo moyo. No nakombinyo moyo yayna, hay an-itorò moyo kona ay makapipalako kona ha impirno, boy mag-in yan mas mala-et kisa komoyo. ");
INSERT INTO sbl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ka-i-ingaloy mangyari lano komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo! Hikawo ay bilang bawbowag ya ampangakay ha pangitorò moyo nin ombayri: ‘Ayin kowinta ha hinoman ya magpangakò nin maghompà ha bali nin Diyos, piro hinoman ya magpangakò nin maghompà ha gintò ya anti ha bali nin Diyos ay ahè ma-arì nin agna geperan baytoy pangakò na.’ ");
INSERT INTO sbl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hikawo ay bilang bawbowag ya tawtangah! Warì mas importanti baytoy gintò kisa masagradoy bali nin Diyos? ");
INSERT INTO sbl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","An-itorò moyo et ya ombayri: ‘Ayin kowinta ha hinoman ya magpangakò nin maghompà ha altar ya anti ha bali nin Diyos, piro hinoman ya magpangakò nin maghompà ha indolog nin inggawà ha babon altar ay ahè ma-arì nin agna geperan baytoy pangakò na.’ ");
INSERT INTO sbl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Talagan bilang kawon bawbowag! Warì mas importanti baytoy indolog nin inggawà ha babon altar kisa hatoy masagradoy altar? ");
INSERT INTO sbl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kayà hay tawoy magpangakò nin maghompà ha altar ya anti ha bali nin Diyos ay ampaghompà ya kateng ha kaganawan indolog nin inggawà ha babon altar; ");
INSERT INTO sbl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","boy hay ampagpangakò nin maghompà ha bali nin Diyos ay ampaghompà ya et ha Diyos ya ampa-iri bayro. ");
INSERT INTO sbl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","No hay tawoy ampaghompà nin magpangakò, ta ha paghompà na ay anhabtan nay katatag-ayan ya kama-inan nin Diyos ay ampaghompà ya ha trono ya anti bayro kateng ha Diyos ya ampiknò bayro ha trono. ");
INSERT INTO sbl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Ampambi kawo ha Diyos nin ikamapò parti nin tawtanaman moyoy dikot ya balang ya panrikadon pamamangan. Piro agmoyo anhonolen ya pinaka-importantin bagay ya bilang ha matoynong ya panonosga, pangingangalo, boy katapatan. Talagan dapat moyon igwà ya ikamapò parti nin natikapan moyo, piro agmoyo pa-olayan ya mas importanti ya bagay. ");
INSERT INTO sbl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hikawo ay bilang bawbowag ya mangangakay. Agkawo makaregdeg nin manggawà kasalanan ya bilang kayamò gamogamo piro ampakaregdeg kawon manggawà kasalanan ya bilang kalhay ayop ya kamel. ");
INSERT INTO sbl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Hay likol nin plato boy losa ay ampakalinisan moyon mahampat, piro hay nakem moyo ay ponò kasakiman boy kala-etan. ");
INSERT INTO sbl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hikawoy Pawparisiyo ya bilang bawbowag, ka-ilangan linisan moyo pon ya kanakeman moyo nin bilang ha losa boy plato ya anggamiten moyo. Ha ombayro, kateng gawgawà moyo ay mag-in malinis. ");
INSERT INTO sbl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Bilang kawo ha pantyon ya nilinisan ya likol ta pinapotì, balè ha lalè nin habayto ay poro bot-o nin tawoy nabolok. ");
INSERT INTO sbl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hikawo ay ombayro. Hay kahampatan ay an-ipakit moyon bongat ha tawtawo, piro hay nakem moyo ay pono-ponò pagkakanwarì boy kasalanan.” ");
INSERT INTO sbl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Hinalità et ni Apo Hisos, “Ka-i-ingaloy mangyari komoyon mawmangitorò nin kawkapanogo-an boy komoyon Pawparisiyo ta hikawo ay mawmagkakanwarì! Anggaw-en moyoy pawpantyon nin pawpropita ya pinati nin kawka-apo-apowan moyo, boy an-adornowan moyoy tinabon nin hatoy mangahampat ya tawtawoy pinati la, ya wamoyo, ‘No hikayi dayi ay tawoyna hin pana-on nin kawka-apo-apowan nawen ay agkayi naki-emen ha ginawà la ya namati.’ ");
INSERT INTO sbl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ha paghalità moyo nin habayto ay ampaptegan moyo ya talagan hikawo ay aw-inalalak nin hatoy nipamati nin pawpropita. ");
INSERT INTO sbl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sigi, yari-en moyo baytoy kala-etan ya ahè nayarì nin kawka-apo-apowan moyo. ");
INSERT INTO sbl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Hikawo ay bilang aw-otan ya ma-in dità banà ha kala-etan moyo. Warì mapa-alilihan moyoy kaparosawan ha impirno? ");
INSERT INTO sbl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kayà emen kawo lalò komasalanan ha tegteg nin Diyos ay mangihogò ako komoyo nin pawpropita, tawtawoy mangaronong, boy mawmanonorò. Hay ongno konla ay patyen moyo, boy hay kanayon ay ipakò moyo ha koroh. Hay kanayon ay barogen ha lo-ob nin hawhimba-an moyo boy kamaten hila ha balang banowa ta padya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Banà bayri ay mipalako komoyoy kaparosawan ha pamati nin mangahampat ya tawtawo, pa-ibat koni Abil angga koni Sakariyas ya anak ni Barakiyas. Hi Sakariyas ya pinati moyo ha danin altar ya anti ha arapan nin masagradoy kowarto ha bali nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Habayti ya halita-en ko komoyo: hay tawtawo hapa-eg pana-on ya mananggap kaparosawan ha pamati nin habaytoy pawpropita.” ");
INSERT INTO sbl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hinalità et ni Apo Hisos, ya wana, “Tawtawo ha Hirosalim, hikawo ya ampamati nin pawpropita boy ambatowen moyo baytoy inhogò bahen komoyo. Ongnoy bisis katawon labay kopkopen nin bilang ha pangopkop nin to-an manok ha sawsisiw na, piro agmoyo labay nin pakopkop kongko. ");
INSERT INTO sbl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hapa-eg ay hikawoyna ya ba-alà bahen ha ampa-iriyan moyoy siyodad ta pa-olayan katawoyna. ");
INSERT INTO sbl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anhalita-en ko komoyo ya agmoyo koyna makit oman anggan agmoyo halita-en ya, ‘Makalmà ya anlomateng ha ngalan nin Pangino-on.’” ");
INSERT INTO sbl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mintras ampog-alih hi Apo Hisos ha bali nin Diyos, hay aw-alagad na ay nako kona ta intorò lay bawbali ya anti ha kolob nin bali nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Piro hinalità konla ni Apo Hisos, “Ampag-ispantawan moyo nayì ba-in ya angkakit moyo? Anhalita-en ko komoyoy kaptegan: haba-in ya angkakit moyoy bawbato ya pinibabanto, lano ay ayin matilà ha babo nin kaparihon bato ta kaganawan ay mihabwag.” ");
INSERT INTO sbl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mintras ampiknò hi Apo Hisos ha Bakil nin Aw-olibo, hay aw-alagad na ay napakarani kona nin hilahilan bongat ta hinalità la kona, “Ibalità mo,” wanla, “konnawen no makano mangyari bayto ya hinalità mo ya tongkol ha bawbato, boy no anyay palatanda-an ya mangyari emen nawen matanda-an ya lomateng kayna boy ka-anggawan nin babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tinombay konla hi Apo Hisos, “Mag-atap kawo,” wana, “emen agkawo maloko nin maski hino, ");
INSERT INTO sbl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ta malakè ya tawoy lomwah ya manggamit nin ngalan ko ya maghalità nin ombayri: ‘Hiko hi Kristo ya impangakò nin Diyos.’ Banà bayri ay malakè ya tawoy maloko la. ");
INSERT INTO sbl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Agkawo mataranta ha malengè moyoy telek nin banà ha labanan boy ha bawbalità ya tongkol ha gawgira. Habayti ya ombayri ya bawbagay ay ka-ilangan mangyari, piro alwa et ka-anggawan nin kaganawan. ");
INSERT INTO sbl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hay tawtawo ha mihay nasyon ay lomaban ha kanayon ya nasyon, boy mangapilalaban et ya gawgobirno. Ma-in lomateng ya bitil boy magkama-in nin lawlayon ha maski ayrin dogal. ");
INSERT INTO sbl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Habayti ya kaganawan ay ompisan bongat nin masyadoy kadya-dya-an ya tanamen nin bilang ha ampanganak. ");
INSERT INTO sbl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Banà ha pamakilamo moyo kongko, hikawo ay pag-inakitan nin kaganawan tawo. Dakpen la kawo ta padya-dya-an biha la kawo patyen. ");
INSERT INTO sbl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ha pana-on ya habayto ay malakè ya ma-lihan nin pantotompel kongko, misasapakatan, boy mi-i-inakitan. ");
INSERT INTO sbl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hapa-eg, malakè ya lomwah ya alwan peteg mawmanonorò ta lokowen lay kalak-an tawo. ");
INSERT INTO sbl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Banà ha panlomalò nin kala-etan ay malakè ya lomay-ep ya panlalabi nin miha ta miha. ");
INSERT INTO sbl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piro hay ampanatilin antompel kongko boy makatagal ha kadya-dya-an angga ha ka-anggawan nin biyay na ay ma-in kalibriyan. ");
INSERT INTO sbl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hay Mahampat ya Balità ya tongkol ha pamomo-on nin Diyos ay i-aral ha kaganawan dogal ha babon lotà emen kaganawan tawo ay makalengè. Pangayarì ay ma-anggawan anay babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hinalità et ni Apo Hisos, “Do,” wana, “ha bali nin Diyos ay makit moyoy pangyayari ya hinalità hin hato ni propita Danyil ya hay maninirà ya ayin kapara ha kala-etan ay ampireng ha masagradoy kowarto ya paran bongat ha Diyos. (Dapat intindiyen bayti nin ampamaha.) ");
INSERT INTO sbl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","No ombayroynay mangyari, hay tawtawo bayri ha probinsyan Hodiya ay dapat mowayon mako ha bawbakil. ");
INSERT INTO sbl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hinoman ya anti ha balkon ha bobongan nin bali na ay agana mistil mona-oy nin mangwan kawkamama-in na ya anti ha lo-ob nin bali na. ");
INSERT INTO sbl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hinoman ya anti ha paliyan ay agana mistil morong nin mangwan alimenmen na. ");
INSERT INTO sbl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ha aw-alloy habayto, hay mangaboktot boy nawnanay ya ampipamanonò ay ka-i-ingalo. ");
INSERT INTO sbl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipanalangin moyo ya habayti ya pamowayo moyo ay ahè mangyari no pana-on abagat o no allon pama-inawa. ");
INSERT INTO sbl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ha pana-on ya habayto, hay tawtawo ay makaranas nin kadya-dya-an ya igit ha kadya-dya-an ya dinanas ana pa-ibat et hin pinalsa ya babon lotà. Maski makakano ay agana maranasan baytoy ombayroy kadya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pina-ipek nin Diyos ya aw-allo nin pana-on kadya-dya-an, ta no ahè ay ayin tawoy makalibri ha kamatyan. Banà ha ingangalo na ha tawtawoy pinilì na ay pina-ipek na baytoy pana-on nin kadya-dya-an. ");
INSERT INTO sbl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Hapa-eg no ma-in maghalità komoyo nin, ‘Biliwen moyo, anti bayri hi Kristo ya impangakò nin Diyos!’ o no hay halita-en ay ‘Anti ya bayro!’ ay agmoyo pinto-owen bayto. ");
INSERT INTO sbl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma-in lomwah ya mawmagkakanwarì nin hila hi Kristo, boy ma-in lomwah ya alwan peteg mawmanonorò. Mangipakit hilan masyadoy pawpapag-ispantawan ta no ma-arì, maski tawtawoy pinilì nin Diyos ay lokowen la. ");
INSERT INTO sbl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hinalità koyna komoyo; kayà mag-atap kawo emen agkawo maloko. ");
INSERT INTO sbl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“No ma-in tawoy maghalità komoyo nin, ‘Helken moyo, hi Kristo ay anti bayro ha powiray dogal,’ ay agkawo mako bayro. No halita-en la simpri ya, ‘Hi Kristo ay anti ha kowarto ta ampagtagò,’ ay agkawo minto-o. ");
INSERT INTO sbl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","No pangno nin hay kimat ha langit ay biglà anhomawang nin mangibat ha baytan magpalakon babà ay ombayroy panlomateng ko bayri ya an-ingaten Anak nin Tawo. ");
INSERT INTO sbl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“No ayri ya bangkay ay bayro ampititipon ya aw-owak.” ");
INSERT INTO sbl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hinalità et ni Apo Hisos, “Pangalabah nin habaytoy pana-on, antimano, hay babon lotà ay domeglem ta hay allo boy bowan ay ahè homawang. Hay bawbito-en ay mikatata boy hay kawkapangyariyan ya anti ha langit ay mipampikambya. ");
INSERT INTO sbl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hapa-eg hay palatanda-an nin panlomateng ko ya an-ingaten Anak nin Tawo ay makit ha tag-ay langit, boy kaganawan tawo bayri ha babon lotà ay mi-anggaw-angaw banà ha kalimowan la. Hiko ya Anak nin Tawo ya mangibat ha katatag-ayan ha kama-inan nin Diyos ay lomateng ya anti ha leem. Makit la ko ya ma-in kapangyariyan boy ma-in masyadoy kagandawan ya ahè makwan ihipen. ");
INSERT INTO sbl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ihogò koy aw-anghil ko nin mipanamboyok nin makhaw, ta tiponen lay kaganawan tawoy pinilì koy ma-ibat ha kaganawan dogal bayri ha babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Hay pangwanan moyon alimbawà ay tanaman ya kayoy igos,” wani Apo Hisos. “Tandà tamo ya no ampamayoynan bolong ay marani anay abagat. ");
INSERT INTO sbl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ombayro itaman, no makit moyoy ampangyari ana baytoy kaganawan bagay ya hinalità ko komoyo ay matanda-an moyo ya marani koynan lomateng, bilang akoynan anti ha polta. ");
INSERT INTO sbl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anhalita-en ko komoyoy kaptegan: hay tawtawoy angkabiyay hapa-eg pana-on ay ahè ma-obon mati anggan ahè mangyari ya kaganawan nin habayto. ");
INSERT INTO sbl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hay langit boy lotà ay ma-anggawan piro hay hawhalità ko ay ahè ma-anggawan.” ");
INSERT INTO sbl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hinalità et ni Apo Hisos, ya wana, “Hay magtandà bongat nin allo boy oras nin mangyari bayto ay Tatay koy Diyos. Ahè tandà nin aw-anghil ha katatag-ayan ha kama-inan nin Diyos, ni hiko ya Anak nin Diyos ay ahè magtandà no makano mangyari bayto. ");
INSERT INTO sbl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hay panlomateng ko ya an-ingaten Anak nin Tawo ay bilang ombayro ha pangyayari hin pana-on ni Nowi ya hay tawtawo ay alwan handà, ta masyadoy kala-etan la boy aglayna anlingayen ya Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hin habayton pana-on biha nahalipawan nin lanom ya babon lotà, hay tawtawo ay sigisigi ha pamangan, paglahing, pag-ahawa, boy pamabanhal anggan na-abot ya allo nin hili Nowi ay pinomahok ha barko. ");
INSERT INTO sbl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Habaytoy tawtawo ay ahè nangihip nin ma-in mangyari konla anggan hay babon lotà ay nahalipawan nin lanom ya nakamati konlan kaganawan. Bilang ombayro ya panlomateng ko ya an-ingaten Anak nin Tawo. ");
INSERT INTO sbl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ha allon habayto ay ma-in loway lalaki ya ampilamon ampagtrabaho ha paliyan; hay miha ay kowen, hay miha ay ibalag. ");
INSERT INTO sbl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma-in loway babayi ya ampitambay nin ampanggiling; hay miha ay kowen, hay miha ay ibalag. ");
INSERT INTO sbl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kayà maghandà kawo ta agmoyo tandà ya allon panlomateng ko ya Pangino-on moyo. ");
INSERT INTO sbl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Habayti ya tanda-an moyo: no tandà nin ma-in bali ya oras nin lomateng ya mananakaw ay magbantay ya, ta agna pa-olayan ya hay bali na ay pahoken nin mananakaw. ");
INSERT INTO sbl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kayà hikawo man ay maghandà ta hiko ya an-ingaten Anak nin Tawo ay lomateng ha oras ya agmoyo an-asawan.” ");
INSERT INTO sbl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hinalità et ni Apo Hisos, ya wana, “Pangno mabalayan ya tapat boy maronong ya alilà? Hay tapat boy maronong ya alilà ay ambiyan nin amo na nin karapatan mama-alà ha kawkalamowan nay aw-alilà boy hiya ya mambin pamamangan la ha tamà ya oras. ");
INSERT INTO sbl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Habaytoy ombayroy alilà ay ma-in kakalma-an no malatngan nin amo na ya anggaw-en na baytoy impagawà kona. ");
INSERT INTO sbl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anhalita-en ko komoyo ya kaptegan: habaytoy tapat ya alilà ay paba-ala-en nin amo na ha kaganawan kamama-in na. ");
INSERT INTO sbl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piro no mala-et ya alilà ay halita-en na ha sarili na ya, ‘Maboyot pon biha lomateng ya amo ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kayà ompisawan nan bogbogen ya kapara nan aw-alilà boy magpasasà yan mangan boy makilahingan. ");
INSERT INTO sbl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hapa-eg hay amo nin hatoy alilà ay lomateng ha allo ya agna an-asawan boy ha oras ya agna tandà. ");
INSERT INTO sbl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Habaytoy mala-et ya alilà ay parosawan nin amo na nin mabiyat ya parosa boy ipakilamo na ya ha dogal nin mawmagkakanwarì. Bayro hila mi-anggaw-anggaw nin manget-et ngipen la banà ha tanamen lay dya-dyà.” ");
INSERT INTO sbl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hinalità ana et ni Apo Hisos, ya wana, “Ha allon habayto nin lomateng ako, hay pamomo-on nin Diyos ay bilang ha mapò ya dalaga ya balang miha ay ma-in gitan ya kingki ya andongket nin homakbat ha kakahal ya lalaki. ");
INSERT INTO sbl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hay lima konla ay tangah; hay lima ay maronong. ");
INSERT INTO sbl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hatoy tawtangah ay nantan kingki la piro aghila nantan risilbay pitorolyo. ");
INSERT INTO sbl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hato balè ya mangaronong ay nantan risilba ya para ha kingki la. ");
INSERT INTO sbl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hapa-eg, mintras na-antalà ya panlomateng nin hatoy kakahal ya lalaki, hatoy mapò ya dalaga ay nakakatoloy. ");
INSERT INTO sbl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Piro hin botlay yabi ana ay naka-imata hila ha nalengè lay bolyaw ya ombayri: ‘Anti anay kakahal ya lalaki! Mako kawoyna bayrin homakbat kona!’ ");
INSERT INTO sbl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hapa-eg hatoy mapò ya dalaga ay nipampibangon ta pinaka-osay lay kawkingki la. ");
INSERT INTO sbl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hinalità nin hatoy limay dalaga ya tangah do ha limay maronong, ‘Atagan moyo kayi,’ wanla, ‘nin pitorolyo moyo ta angkaparè anay kingki nawen.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Piro tinombay konla baytoy mangaronong ya dawdalaga, ‘Ahè ma-arì,’ wanla, ‘ta tama-tamà bongat baytin para konnawen; kayà mako kawo ha tindawan nin manaliw nin para komoyo.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hapa-eg hatoy limay dalaga ya tangah ay nakon manaliw nin pitorolyo ya para ha kawkingki la. Mintras ayin hila, hay kakahal ya lalaki ay nilomateng. Hatoy limay nakahandà ay nakapakilamo do ha ikakahal boy nakapakibanhal. Hapa-eg hay polta ya pinahokan la ay inharà ana. ");
INSERT INTO sbl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ahè naboyot, hatoy limay dalaga ya nanaliw pitorolyo ay nakalateng. Hila ay anti ha likol nin ampibobolyaw, ya wanla, ‘Apo, Apo, lo-aten moy polta ta papahoken mo kayi!’ ");
INSERT INTO sbl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piro tinombay baytoy kakahal ya lalaki, ya wana, ‘Anhalita-en ko komoyoy kaptegan ya agkatawo balay.’” ");
INSERT INTO sbl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hapa-eg, hinalità et ni Apo Hisos, “Kayà bay,” wana, “hay ka-ilangan ay pirmi kawon handà ta agmoyo tandà ya allo o oras nin panlomateng ko.” ");
INSERT INTO sbl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hinalità et ni Apo Hisos, “Hay pamomo-on nin Diyos,” wana, “ay i-alimbawà ko et ha mihay tawoy nako ha kanayon ya dogal. Piro biha ya nog-alih ay iningat nay aw-alilà na ta impaba-alà na konlay kawkamama-in na. ");
INSERT INTO sbl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Balang miha ay binyan na nin kompormi ha kaya nan asiwa-en. Hay miha ay binyan nan alagà liman libo, hay miha ay binyan nan alagà lowan libo, boy hay miha ay binyan nan alagà malibo. Hapa-eg hiya ay nanigè ana. ");
INSERT INTO sbl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hatoy alilà ya nananggap nin alagà liman libo ay tampol nan ingkomirsyo baytoy kowalta ya impatayà kona; kayà nakatobò yan alagà liman libo. ");
INSERT INTO sbl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ombayro simpri ya ginawà nin hatoy binalagan alagà nin lowan libo; kayà nakatobò ya itaman nin alagà lowan libo. ");
INSERT INTO sbl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hato balè ya alilà ya binalagan nin alagà malibo ay nangotkot lotà ta intagò na baytoy kowaltay imbalag kona nin amo na. ");
INSERT INTO sbl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nalabah ya malakè ya pana-on, hatoy amo ay nakalateng boy sinita na baytoy kowaltay imbalag na konla. ");
INSERT INTO sbl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hatoy alilà ya binalagan nin alagà liman libo ay nako kona ta gintan na baytoy kowalta kateng natobò na ya alagà liman libo. ‘Binalagan mo ko, Apo,’ wana, ‘nin alagà liman libo. Helken mo! Habayti et ya liman liboy natobò ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Hinalità kona nin hatoy amo na, ‘Maganday ginawà mo, mahampat boy tapat ya alilà. Banà ta mapahimala-an ka ha mayamò ya alagà ay gaw-en katan mama-alà nin malhay ya alagà. Kayà pakarani ka kongko nin makilamo ha kaligawan.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Hato itaman ya alilà ya binalagan nin alagà lowan libo ay nako do ha amo na ta hinalità na kona, ‘Binalagan mo ko, Apo’, wana, ‘nin alagà lowan libo. Helken mo! habayti et ya lowan liboy natobò ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hinalità itaman kona nin hatoy amo, ‘Maganday ginawà mo, mahampat boy tapat ya alilà. Banà ta mapahimala-an ka ha mayamò ya alagà ay gaw-en katan mama-alà nin malhay ya alagà. Kayà pakarani ka kongko nin makilamo ha kaligawan.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Hapa-eg hatoy alilà ya binalagan nin alagà malibo ay nako do ha amo na ta hinalità na kona, ‘Apo,’ wana, ‘tandà ko ya hika ay ma-irap nin pakilamowan, ta ampangalawah ka nin agmo intanem boy ampakinabang ka ha agmo pinagpagalan. ");
INSERT INTO sbl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Angkalimo ko komo; kayà hay kowalta mo ay intagò ko ha lalè lotà. Helken mo! Anti ana bayri bayti ya ikon mo.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hapa-eg, hinalità kona nin hatoy amo na, ‘Hika,’ wana, ‘ya mala-et boy matamlad ya alilà! Tandà mo awod ya ampangalawah ako nin agko intanem boy ampakinabang ha agko pinagpagalan. ");
INSERT INTO sbl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ha ombayro, hay kowalta ko ay indabò mo dayi ha bangko emen habayto ay nibira kongko nin ma-in tobò.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Hapa-eg, hinalità et nin hatoy amo do ha kanayon ya aw-alilà na, ‘Kowen moyo kona,’ wana, ‘ba-in ya kowalta ta igwà moyo do ha ma-in alagà mapò ya libo. ");
INSERT INTO sbl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hay tawoy ma-in ay pahanan et ya ma-in kona, piro hay ayin, no anyaman ya ma-in kona maski a-amò ay alihen kona. ");
INSERT INTO sbl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hay bagay bayri ha ayin pakinabang ya alilà ay itapon ha likol ha dogal ya pagkareglem. Bayro hay tawtawo ay mi-anggaw-angaw boy manget-et nin ngipen la banà ha tanamen lay dya-dyà.’” ");
INSERT INTO sbl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ombayri et ya hinalità ni Apo Hisos, “Hiko,” wana, “ya an-ingaten Anak nin Tawo, pagbira ko bayri ha babon lotà ay ma-in akon kagandawan ya ahè makwan ihipen, boy kalamo koy aw-anghil ko biha ko miknò ha trono koy ma-in kagandawan. ");
INSERT INTO sbl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kaganawan tawo bayri ha babon lotà ay mititipon ha arapan ko ta pipapawa-en ko ha loway gropo nin bilang ha magpapastol ya ampipapawa-en nay tawtopa boy kawkanding. ");
INSERT INTO sbl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hay tawtawoy mangahampat ya bilang ha topa ay igwà ko ha bandan wanan ko; hay tawtawoy mangala-et ya bilang ha kanding ay igwà ko ha bandan oki ko. ");
INSERT INTO sbl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Hapa-eg hiko ya Arì ay maghalità ha tawtawoy anti ha bandan wanan ko, ‘Hikawoy ma-in kahampatan ya inggawà komoyo nin Tatay koy Diyos, mako kawo bayri ta pag-ari-an katawo. Hay pag-arì ko komoyo ay inhandà nin Diyos pa-ibat hin pinalsa ya babon lotà; ");
INSERT INTO sbl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ta hin nabitlan ako ay pinakan moyo ko; hin na-angan ako ay pina-inom moyo ko. Maski agmoyo ko nabalayan ay pinagkahandà moyo ko ha bali moyo. ");
INSERT INTO sbl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hin ayin akon dolo ay pinadolowan moyo ko; hin nagmasakit ako ay inasiwà moyo ko, boy hin napiriso ko ay tinibaw moyo ko.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hapa-eg, tombay kongko baytoy mangahampat ya tawtawo, ‘Pangino-on,’ wanla, ‘nakano nawen ka nakit ya binomitil ya pinakan nawen, boy nakano nawen ka nakit ya na-angan ya pina-inom nawen? ");
INSERT INTO sbl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nakano nawen ka ahè nabalayan ya pinagkahandà nawen, boy nakano ka nanga-ilangan nin dolo ya pinadolowan nawen? ");
INSERT INTO sbl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nakano nawen ka simpri nakit ya nagmasakit o napiriso ya tinibaw nawen?’ ");
INSERT INTO sbl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Hapa-eg hiko ya Arì ay tombay konla nin ombayri: ‘Kaptegan ya anhalita-en ko komoyo; ha panggawà moyo nin ombayri ha miha ha pinaka-oltimo ya kowinta pawpatel ko ay bilang anan kongko moyo ginawà.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Hapa-eg,” wana et ni Apo Hisos, “ombayri itaman ya halita-en ko ha tawtawoy anti ha bandan oki ko: ‘Pakarayò kawo kongko. Hay bagay komoyo ay kaparosawan. Mako kawo ha apoy ya ahè maparè ya inhandà anan para koni Satanas boy ha dawdimonyoy aw-anghil na; ");
INSERT INTO sbl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ta hin binomitil ako ay agmoyo ko pinakan; hin na-angan ako ay agmoyo ko pina-inom. ");
INSERT INTO sbl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hiko ya agmoyo nabalayan ay agmoyo pinagkahandà ha bali moyo; hin ayin akon dolo ay agmoyo ko pinadolowan; hin nagmasakit ako boy napiriso ay agmoyo ko simpri tinibaw.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hapa-eg, tombay hila kongko, ‘Pangino-on,’ wanla, ‘nakano nawen ka nakit ya binomitil, o na-angan, o ahè nabalayan, o ayin dolo, o nagmasakit, o napiriso ya agnawen tinambayan?’ ");
INSERT INTO sbl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hapa-eg hiko ya Arì ay tombay konla nin ombayri: ‘Kaptegan ya halita-en ko komoyo; hay agmoyo panambay ha pinaka-oltimo ya kowinta pawpatel ko ay hiko ya agmoyo tinambayan.’ ");
INSERT INTO sbl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Habayto,” wana et ni Apo Hisos, “ya ombayroy tawtawo ay mipalako ha impirno ya ayin anggay kaparosawan, piro hay mangahampat ya tawtawo ay biyan biyay ya ayin anggawan.” ");
INSERT INTO sbl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hin nayarì intorò ni Apo Hisos baytoy kaganawan ay hinalità na ha aw-alagad na, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tandà moyo ya loway allo tana ya palabahen biha Pistan Pamamanemtem; boy ha allon habayto, hiko ya an-ingaten Anak nin Tawo ay igwà ha tawtawoy mangipakò kongko ha koroh.” ");
INSERT INTO sbl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hapa-eg hay pawpo-on nin pawparì boy mawmato-ay mangama-in katongkolan ay nititipon ha palasyo ni Kaypas ya pinakamatag-ay ya po-on parì, ");
INSERT INTO sbl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta amplanowen la no pangno la ma-isikrito ya pandakep koni Apo Hisos ta patyen la ya. ");
INSERT INTO sbl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Agtamo,” wanla, “gaw-en peleg pista ta maka manggawà nin kagolowan ya tawtawo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hapa-eg hi Apo Hisos ay anti ha banowan Bitanya ha bali ni Simon ya liprosowen pon. ");
INSERT INTO sbl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Peleg ampangan hili Apo Hisos ay ma-in nakalateng ya mihay babayi ya nantan nin pinakamabli ya pabangoh ya nakapalaman ha maganday pambiyanan ya an-ingaten alabastro. Habayto ay imbollog na ha olo ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hin nakit bayto nin aw-alagad ay namahang hila. “Antà,” wanla, “nin sinayang na ba-in ya pabangoh? ");
INSERT INTO sbl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","No na-ilakò dayi ba-in nin malhay ya alagà, hay napaglako-an ay na-igwà dayi ha manga-irap.” ");
INSERT INTO sbl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hatoy anhalita-en la ay alwan polinged koni Apo Hisos; kayà hinalità na konla, “Antà,” wana, “nin ampaki-emenan moyo ya? Hay ginawà na kongko ay kahampatan. ");
INSERT INTO sbl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hay manga-irap ay kalamo moyon pirmi; piro hiko ay ahè magpirmi komoyo. ");
INSERT INTO sbl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hay pangibollog na ha nawini ko nin habayti ya pabangoh ay paghahandà ha pananabon kongko. ");
INSERT INTO sbl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anhalita-en ko komoyo ya kaptegan: maski ayrin dogal bayri ha babon lotà nin ma-i-aral bayti ya Mahampat ya Balità ay mapanemteman bayti ya babayi ta mabanggit ya ginawà na kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hapa-eg hi Hodas Iskaryoti ya miha ha labinloway alagad ni Apo Hisos ay nako ha pawpo-on nin pawparì ");
INSERT INTO sbl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta hinalità na konla, “Anya,” wana, “ya igwà moyo kongko no igwà ko komoyo hi Hisos?” Hapa-eg, binyan la yan tatlompò ya kowaltay pilak. ");
INSERT INTO sbl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pa-ibat hin habayto ay an-ihipen ni Hodas no pangnoy pangisapakat na koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hin primiron allo nin Pistan pamangan tinapay ya ayin pampalbag, hay aw-alagad ni Apo Hisos ay napakarani kona ta pinastang la ya, ya wanla, “Ayri ya labay mon pangihanda-an nawen nin pangaponan tamo ya pamanemteman?” ");
INSERT INTO sbl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tinombay konla hi Apo Hisos, ya wana, “Mako kawo ha siyodad nin Hirosalim ta maki-ilgo kawo ha mihay tawo bayro ya halita-en ko komoyo. Hay halita-en moyo bayro ha tawo ay ombayri: ‘Hinalità nin Mangangaral nawen ya, “Hay ka-orasan nin kamatyan ko ay maranina. Hikayi nin aw-alagad ko ay bayri ha bali mo nin mangapon hapa-eg Pistan Pamamanemtem.”’ ” ");
INSERT INTO sbl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hapa-eg hatoy aw-alagad ay hinomonol ha hinalità konla ni Apo Hisos. Kayà nangihandà hila nin pangaponan la para ha Pistan Pamamanemtem. ");
INSERT INTO sbl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hin yabi ana, hi Apo Hisos kateng labinloway alagad na ay dinomoyong ha lamisawan ta mangan. ");
INSERT INTO sbl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hin ampi-a-arap hilayna nin ampangan ay hinalità konla ni Apo Hisos, ya wana, “Anhalita-en ko komoyoy kaptegan: miha komoyo ya ka-arap kon ampangan ay mangisapakat kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hapa-eg, hatoy aw-alagad ay nilomelè. Mihamiha hilan nagpastang koni Apo Hisos, ya wanla, “Alwa kalì nin hiko bayto, Pangino-on?” ");
INSERT INTO sbl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tinombay konla hi Apo Hisos, ya wana, “Hatoy kalamo kon ampagsawsaw nin tinapay ha yawong ay hiya bayto ya mangisapakat kongko. ");
INSERT INTO sbl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Impaholat nin Diyos ya hiko ya an-ingaten Anak nin Tawo ay talagan mati, piro ka-i-ingaloy mangyari ha tawoy mangisapakat kongko ya an-ingaten Anak nin Tawo. Mas mahampat et dayi ya agyayna in-anak.” ");
INSERT INTO sbl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hapa-eg hi Hodas ya ampangisapakat koni Apo Hisos ay naghalità, “Hiko nayì,” wana, “Apo?” Tinombay kona hi Apo Hisos, “Mismon hikayna,” wana, “ya naghalità.” ");
INSERT INTO sbl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Peleg la et bayron ampangan, hi Apo Hisos ay nandampot nin tinapay ya pinasalamatan na ha Diyos. Binibi-hil na bayto ta impatpel na ha aw-alagad na biha na hinalità, ya wana, “Habayti ay nawini ko; kanen moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hapa-eg, dinampot na et ya mihay baso ya ma-in alak nin obas. Pinasalamatan na bayto ha Diyos biha na inggawà ha aw-alagad na. “Hikawoy kaganawan,” wana, “ay minom nin habayti, ");
INSERT INTO sbl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ta habayti ay dayà ko ya katibayan nin hay Diyos ay ma-in bayoy kasondo-an ha tawtawo. Habayti ya dayà ko ya mantolò para ha kalak-an tawo, boy habayti ya makapatawad nin kawkasalanan. ");
INSERT INTO sbl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anhalita-en ko komoyo ya agkoyna minom nin ombayri ya alak nin obas anggan lano ha mapagkalamo katawo nin minom nin bayoy alak do ha dogal ya ampag-ari-an nin Tatay koy Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hin nayarì hili Apo Hisos nin nagkantan pamasalamat ay nako hila ha Bakil nin Aw-olibo. ");
INSERT INTO sbl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hapa-eg, hinalità ni Apo Hisos ha aw-alagad na, ya wana, “Hikawoy kaganawan ay ma-lihan nin katetpel kongko hapa-eg yabi kompormi ha hinalità nin Diyos ya ombayri: ‘Hay Pastol nin tawtopa ay patyen ko boy mikakatak ya tawtopa.’ ");
INSERT INTO sbl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piro pangabiyay kon oman,” wana et ni Apo Hisos, “ay ma-ona ko komoyo nin mako ha probinsyan Galiliya.” ");
INSERT INTO sbl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hapa-eg, hinalità ni Pidro koni Apo Hisos, ya wana, “Maski ma-lihan nin katetpel ya kaganawan, hiko ay ahè!” ");
INSERT INTO sbl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hinalità kona ni Apo Hisos, “Anhalita-en ko komo ya kaptegan,” wana, “hapa-eg yabi, biha mangkati ya manok ay katatloy bisis mo kon ipogla-oh nin halita-en ya agmo ko balay.” ");
INSERT INTO sbl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tinombay kona hi Pidro, ya wana, “Maski mati ko nin kalamo mo ay agko maghalità nin agkata balay.” Ombayro simpri ya hinalità nin kaganawan alagad. ");
INSERT INTO sbl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hapa-eg hi Apo Hisos kateng aw-alagad na ay nako ha dogal ya an-ingaten Gitsimani. Hinalità na ha aw-alagad na, “Miknò kawo bayri,” wana, “ta mako ko ha banda bayro nin manalangin.” ");
INSERT INTO sbl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hapa-eg, hay gintan ni Apo Hisos ay hi Pidro kateng hatoy loway anak ni Sibidiyo, boy hin habayto ay nakatanam yan masyadoy kalele-an boy angkagolo ya ihip na. ");
INSERT INTO sbl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hapa-eg, hinalità konla ni Apo Hisos, “Emen akon mati,” wana, “nin banà ha masyadoy kalele-an ko. Bayri kawo pon boy makipoyat kawo kongko.” ");
INSERT INTO sbl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hin nipakarayò nin amò hi Apo Hisos ay nanlokob yan nanalangin, ya wana, “Tatay ko, no ma-arì dayi ay alihen mo bayti ya kadya-dya-an ya andanasen ko. Ombayro man ay alwan kalabayan koy mahonol no alwan kalabayan mo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hapa-eg hi Apo Hisos ay nagbira do ha tatloy alagad na boy nalatngan na hilay angkatoloy. Hinalità ni Apo Hisos koni Pidro, “Agmo nayì matagal nin magpoyat nin maski mihay oras? ");
INSERT INTO sbl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Homandà kawo boy manalangin emen agkawo matoksò. Anti ha nakem moyo ya labay moyon homonol, piro ahè makaya nin sarili moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Inalihan hilayna et ni Apo Hisos nin ikalwan bisis ta nako yan nanalangin. “Tatay ko,” wana, “no ahè ma-alih bayti ya kadya-dya-an ya andanasen ko ay kalabayan moy mangyari.” ");
INSERT INTO sbl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hapa-eg, nagbirayna et hi Apo Hisos do ha tatloy alagad na boy nalatngan na hilay angkatoloy ta nitonglò hilayna. ");
INSERT INTO sbl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Inalihan hilayna et oman ni Apo Hisos nin ikatlon bisis ta nako yan nanalangin nin bilang ombayro hin ona. ");
INSERT INTO sbl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hapa-eg ay nagbira yayna et ta hinalità na konla, “Angkatoloy kawo et nayì,” wana, “boy ampa-inawa? Nilomateng anay oras nin hiko ya an-ingaten Anak nin Tawo ay isapakat nin igwà ha gamet nin tawtawoy makasalanan. ");
INSERT INTO sbl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mibangon kawoyna ta anlomateng anay tawoy ampangisapakat kongko. Hakbaten tamo hila.” ");
INSERT INTO sbl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mintras ampaghalità hi Apo Hisos, hi Hodas ya miha ha labinloway alagad na ay nakalateng kalamo nay malakè ya tawoy nipaghondang boy nipagpapatok. Hila bayti ay inhogò nin pawpo-on nin pawparì boy mawmato-ay mangama-in katongkolan. ");
INSERT INTO sbl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Hatoy traydor ya hi Hodas ya ampangiparakep koni Apo Hisos ay naghalità ha kawkalamowan na, ya wana, “Hay alekan ko ay hiya bayto. Dakpen moyo ya ta gitan moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hin nilomateng bayro hi Hodas ay nagdiritso ya koni Apo Hisos boy hinalità na, “Apo,” wana, biha na ya inalekan. ");
INSERT INTO sbl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hinalità kona ni Apo Hisos, “Aporawen mon gaw-en,” wana, “ya bara-nan nin pamako mo bayri.” Hapa-eg hi Apo Hisos ay pinakaraniyan nin hatoy kawkalamowan ni Hodas ta dinakep la ya. ");
INSERT INTO sbl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Miha ha aw-alagad ni Apo Hisos ya anti bayro ay nanganoh nin hondang ta tinabtab nay alilà nin pinakapo-on nin pawparì. Hatoy alilà ya tinabtab ay napongohan nin tolih. ");
INSERT INTO sbl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hinalità ni Apo Hisos, “Igomà moynay hondang mo,” wana, “ta kaganawan ampamati nin hay anggamiten ay hondang ay hondang itaman ya gamiten nin pamati konla. ");
INSERT INTO sbl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Agmo nayì tandà ya no makirawat ako hapa-eg ha Tatay koy Diyos ay ihogò na hapa-eg et ya liboliboy anghil na nin mangasiwà kongko? ");
INSERT INTO sbl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piro no gaw-en ko baytoy ombayro ay pangno matopad baytoy nakaholat ha Kaholatan nin Diyos ya dapat mangyari?” ");
INSERT INTO sbl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hapa-eg hi Apo Hisos ay naghalità do ha kalak-an tawo, ya wana, “Warì tolisan ako ta nakahondang kawo boy nipagpapatok ya mandakep kongko? Allo-allo kon ampiknò do ha bali nin Diyos nin ampanorò ay antà agmoyo ko dinakep? ");
INSERT INTO sbl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kaganawan nin habayti ay ampangyari emen magkapeteg baytoy hinolat nin pawpropita ha Kaholatan nin Diyos.” Hapa-eg hay kaganawan alagad ni Apo Hisos ay nipampowayo ta inalihan la ya. ");
INSERT INTO sbl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hapa-eg hi Apo Hisos ay gintan nin hatoy nipandakep kona ha bali ni Kaypas ya pinakapo-on nin pawparì, ta anti bayron nititipon ya mawmangitorò nin kawkapanogo-an kateng hatoy mawmato-ay mangama-in katongkolan. ");
INSERT INTO sbl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hi Pidro ya ma-in amò ya karayo-an ya anhomono koni Apo Hisos ay ni-abot ha kolob bali nin hatoy pinakapo-on nin pawparì. Nilomo-ob ya bayro nin naki-iknò ha bawbantay ta an-imatonan na no anyay homono ya mangyari. ");
INSERT INTO sbl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hapa-eg hay pawpo-on nin pawparì boy kaganawan ma-in katongkolan ay ampanikap nin manistigos kabongkokan ya kontra koni Apo Hisos emen la ya ma-ipapati. ");
INSERT INTO sbl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piro ayin hilan makit ya bara-nan ya pamatyan la kona maski malakè ya tawoy ampaghalità nin kabongkokan. Ha kalalampohan ay ma-in loway tawo ya napakarani ");
INSERT INTO sbl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ya naghalità nin, “Habayti ya tawo ay naghalità nin, ‘Kaya kon hira-en bayti ya bali nin Diyos ta pangalabah nin tatloy allo ay ibangon kon oman.’” ");
INSERT INTO sbl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hapa-eg, nireng baytoy pinakapo-on nin pawparì ta pinastang na hi Apo Hisos, ya wana, “Ayin ka nayì ma-itobay bahen ha an-ibingga la komo?” ");
INSERT INTO sbl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piro hi Apo Hisos ay ahè nagtelek. Hinalità kona nin hatoy pinakapo-on nin pawparì, “An-imanda ko,” wana, “komo ya ha arapan nin Diyos ya ayin kamatyan ay halita-en mo konnawen no hika baytoy impangakò nin Diyos ya Anak nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tinombay kona hi Apo Hisos, “Mismon hikayna,” wana, “ya naghalità. Piro habayti ya halita-en ko komoyon kaganawan: lano, hiko ya an-ingaten Anak nin Tawo ay makit moyoy ampiknò ha bandan wanan nin Pinakamakapangyariyan ya Diyos. Pagbira ko bayri ay makit moyo ko ya anti ha leem ya mangibat ha katatag-ayan.” ");
INSERT INTO sbl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hapa-eg, ha kapahangan nin hatoy pinakapo-on nin pawparì ay giniwak nay dolo na boy hinalità na, “Haba-in ya tawo,” wana, “ay ampaghalità nin kontra ha Diyos, ta hiya ay tawon bongat piro an-ipantay nay sarili na ha Diyos. Kayà alwa tamoynan ka-ilangan ya tistigos. Bayri ay nalengè moyoynay hinalità na ya kontra ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anyay disisyon moyo?” Tinombay kona baytoy tawtawo, ya wanla, “Hay dapat kona ay patyen.” ");
INSERT INTO sbl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hapa-eg, dinol-an lay lopa ni Apo Hisos boy pinagpoponiti la ya; hay ginawà nin kanayon ay pinerengan lay mata na, biha la ya tinampal ");
INSERT INTO sbl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","boy hinalità la kona, “Banta-an mo pa, Kristo, no hinoy nanampal komo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hi Pidro ay anti ha kolob nin hatoy pinakapo-on nin pawparì nin ampiknò. Hapa-eg mihay babayi ya alilà bayro ay napakaranin naghalità kona, “Kateng hika,” wana, “ay miha ha kawkalamowan ni Hisos ya taga Galiliya.” ");
INSERT INTO sbl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piro ha arapan nin kaganawan, hi Pidro ay nagpogla-oh, ya wana, “Agko tandà ba-in ya anhalita-en mo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hapa-eg hi Pidro ay nagpalako ha polta nin hatoy kolob. Bayro ay nakit yayna et nin kanayon ya babayi ya alilà ya naghalità do ha tawtawoy anti bayro, ya wana, “Haba-in ya tawo ay kalamo ni Hisos ya taga Nasarit.” ");
INSERT INTO sbl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nagpogla-oh ana et hi Pidro, ya wana, “Ampaghompà ako nin haba-in ya tawo ay talagan agko balay.” ");
INSERT INTO sbl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Amò papa-inghan, hay tawtawoy anti bayro ya ampipampireng ay napakarani koni Pidro ta hinalità la kona, “Talagan hika,” wanla, “ay miha ha aw-alagad ya kalamo ni Hisos ta angkahalatà nawen ka ha pag-i-ilgo mo.” ");
INSERT INTO sbl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hapa-eg hi Pidro ay naghompà nin kabongkokan, ya wana, “Parosawan ako nin Diyos no alwan peteg ya hinalità ko ya agko balay ba-in ya tawo.” Antimano ay nangkati ya manok. ");
INSERT INTO sbl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hapa-eg, napanemteman ni Pidro baytoy hinalità kona ni Apo Hisos ya ombayri: “Biha mangkati ya manok ay ipogla-oh mo kon katatloy bisis nin halita-en ya agmo ko balay.” Kayà hi Pidro ay nog-alih bayro ha kolob boy masyadoy pamitangihtangih na. ");
INSERT INTO sbl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hay hambak et nin bayombokah, kaganawan po-on nin pawparì boy mawmato-ay mangama-in katongkolan ay nititipon ana et, ta ampi-i-ilgowan la no pangno la ma-ipapati hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hapa-eg hi Apo Hisos ay binalol la biha la gintan nin inggawà koni Pilato ya gobirnador ya taga Roma. ");
INSERT INTO sbl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hapa-eg hi Hodas Iskaryoti ya nagtraydor koni Apo Hisos ay naghehe ha ginawà na hin nakit nay sinintinsyawan nin patyen hi Apo Hisos. Nako ya ha pawpo-on nin pawparì boy ha mawmato-ay mangama-in katongkolan ta in-orong na baytoy tatlompò ya pilak ");
INSERT INTO sbl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","boy hinalità na konla, “Nagkasalanan ako,” wana, “ha pangisapakat ko nin tawoy ayin kasalanan.” Tinombay hila kona, “Ayin kowinta,” wanla, “konnawen. Ba-alà kayna ha sarili mo.” ");
INSERT INTO sbl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hapa-eg do ha bali nin Diyos ay intapon ni Hodas baytoy kowalta, biha ya nog-alih ta nagbibitay ya. ");
INSERT INTO sbl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hatoy kowalta ay pinowot nin hatoy pawpo-on nin pawparì boy hinalità la, “Agtamo,” wanla, “igwà bayti ha pambiyanan kowalta bayri ha bali nin Diyos, ta kontra ha kawkapanogo-an tamo ya mananggap kowalta ya imbayad ha biyay nin mihay tawo.” ");
INSERT INTO sbl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kayà pini-i-ilgowan lay tongkol bayro ha kowalta. Hapa-eg, nangapimimihawan la ya habayto ay panaliw la nin lotà ha mihay manggagawà keren, ta habaytoy gaw-en lan pangitabonan nin dawdayowan. ");
INSERT INTO sbl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kayà habaytoy dogal ya ginawà lan panabonan ay an-ingaten Dogal Dayà angga hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Habayti ya pangyayari ay natopad baytoy holà hin hato ni propita Hirimiyas ya ombayri ya pagkahalità: “Tatlompò ya pilak ya alagà pandakep nin tawo ta habaytoy alagà nin ibayad ya nangapisosondo-an nin aw-inalalak ni Israyil. ");
INSERT INTO sbl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Habaytoy kowalta ay pinanaliw lan lotà ha mihay manggagawà keren bilang ombayro ha intorò kongko nin Pangino-on.” ");
INSERT INTO sbl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hapa-eg hi Apo Hisos ay anti ha arapan ni Gobirnador Pilato nin ampireng. Pinastang ya ni Pilato, ya wana, “Hika nayì ya Arì nin Hawhodiyo?” Tinombay hi Apo Hisos, “Awò,” wana. “Tamà ba-in ya hinalità mo.” ");
INSERT INTO sbl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Piro hin ambinggawan ana hi Apo Hisos nin hatoy pawpo-on nin pawparì boy hatoy mawmato-ay mangama-in katongkolan ay agya tinombay. ");
INSERT INTO sbl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pinastang yayna et ni Pilato, ya wana, “Agmo nayì angkalengè bayti ya bawbagay ya an-ibingga la komo?” ");
INSERT INTO sbl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piro ni mihay halità ay ahè tinombay hi Apo Hisos; kayà masyadon nag-ispanta hi Pilato. ");
INSERT INTO sbl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ta-onta-on, no Pistan Pamamanemtem, hay gobirnador ay ampamalayà nin mihay piriso ya awoken nin kalak-an. ");
INSERT INTO sbl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hin habayto ay ma-in mihay piriso ya nagngalan Barabas ya bantog ha kala-etan. ");
INSERT INTO sbl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hapa-eg hin nititipon ya tawtawo ay pinastang hila ni Pilato, “Hino,” wana, “ya labay moyon palaya-en ko, hi Barabas o hi Hisos ya an-ingaten Kristo?” ");
INSERT INTO sbl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hay bara-nan nin ombayroy hinalità ni Pilato ay banà ta tandà na ya hi Apo Hisos ay inggawà la kona nin banà ha inggit la. ");
INSERT INTO sbl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mintras ampiknò et hi Pilato do ha panosgawan, hay ahawa na ay namagtan kona nin balità ya ombayri ya pagkahalità: “Agka maki-emen manggawà nin anyaman ya bagay bahen ha tawoy ayin kasalanan, ta masyadon ampikoto ya ihip ko banà ha taynep ko nayabi ya tongkol kona.” ");
INSERT INTO sbl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hapa-eg hatoy pawpo-on nin pawparì boy hatoy mawmato-ay mangama-in katongkolan ay nanolsol ha kalak-an tawo nin hi Barabas ya awoken la koni Pilato nin palaya-en ta hi Apo Hisos ay patyen. ");
INSERT INTO sbl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pinastang hilayna et ni Pilato, “Hino bayri ha lowa,” wana, “ya labay moyon palaya-en ko?” “Hi Barabas,” wanla. ");
INSERT INTO sbl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hinalità konla ni Pilato, ya wana, “Anyaman awod ya gaw-en ko koni Hisos ya an-ingaten Kristo?” Tinombay hilay kaganawan, ya wanla, “Ipakò ya ha koroh!” ");
INSERT INTO sbl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Antà?” wani Pilato, “anyay kala-etan ya ginawà na?” Piro lalò ana ingat nin nambo-angaw ya tawtawo, ya wanla, “Ipakò ya ha koroh!” ");
INSERT INTO sbl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hin nakit ni Pilato ya ayin yan magawà ta anlomalò ya kagolowan ay namakwa yan lanom ta ha arapan nin hatoy kalak-an tawo ay inoyahan nay gamet na boy hinalità na konla, ya wana, “Ayin akon kasalanan ha kamatyan nin habayti ya tawo. Habayti ay kagagaw-an moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hatoy kaganawan tawo ay tinombay, “Mipalako,” wanla, “konnawen boy ha aw-anak nawen ya kaparosawan ha pagkamati na.” ");
INSERT INTO sbl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hapa-eg hi Barabas ay pinalayà ni Pilato. Hi Apo Hisos balè ay impabarog na boy inggawà nan ipakò ha koroh. ");
INSERT INTO sbl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hapa-eg hi Apo Hisos ay gintan nin hatoy hawhondalò nin gobirnador do ha palasyo, biha la tinipon ya kawkakompanya la ta pinalibotan la hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nilo-hokan la hi Apo Hisos biha la ya pinaholotan nin doloy kolor obi ya emen dolon arì. ");
INSERT INTO sbl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nanggawà hilan koronay dowih biha la inggawà ha olo ni Apo Hisos, boy hay wanan gamet na ay pina-oligtanan lan tambò ta hiya kanwarì ay ma-in katongkolan. Hapa-eg, nanalimokod hila ha arapan na ta pinagsistiyan la ya, ya wanla, “Lomawig ya biyay mo, Arì nin Hawhodiyo.” ");
INSERT INTO sbl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nayarì bayto ay dinol-an la ya, biha la kinwa kona baytoy tambò ta impatok la ha olo na. ");
INSERT INTO sbl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hin nayarì la yan pinagsistiyan ay nilo-hok la kona baytoy dolo ya kolor obi, biha la impaholot kona nin oman ya sarili nan dolo. Hapa-eg, hiya ay gintan laynan ipakò ha koroh. ");
INSERT INTO sbl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mintras anti hila ha daan ay nahakbat lay mihay tawoy nagngalan Simon ya taga Sirini. Hi Simon ay pinilit lan pinabalatay nin koroh ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hapa-eg, ni-abot hila ha dogal ya an-ingaten Golgota ya hay labay totolen ay Dogal nin Bongò ta bilang kortin bongò olon tawo. ");
INSERT INTO sbl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bayro la ya ampa-inomen nin alak ya nila-okan aplo, piro hin natawayan na ay agnayna ininom. ");
INSERT INTO sbl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hin na-ipakò layna hi Apo Hisos ha koroh ay inatag-atag lay dolo na ta pinibobonotan la no hino konla ya makapag-ikon. ");
INSERT INTO sbl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hin nayarì bayto ay niknò hila ta ambantayan la hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ha bandan tag-ay nin olo ni Apo Hisos ay inholat lay bingga la kona ya ombayri: “HABAYTI HI HISOS YA ARÌ NIN HAWHODIYO.” ");
INSERT INTO sbl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bayro ay ma-in itaman nin loway tolisan ya kapariho nan impakò ha koroh. Hay miha ay ha bandan wanan na, hay miha ay ha bandan oki na. ");
INSERT INTO sbl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hay tawtawoy angkahagoy koni Apo Hisos ay ampipampeyeng nin ampanginsolto kona, ya wanla, ");
INSERT INTO sbl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Warì alwan hika ya manirà nin bali nin Diyos ta pangalabah nin tatloy allo ay ibangon mon oman? Sigi paraw! No hika ay Anak nin Diyos ay omaypà ka bahen ha koroh ta ilibri moy sarili mo!” ");
INSERT INTO sbl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kateng pawpo-on nin pawparì, mawmangitorò nin kawkapanogo-an, boy mawmato-ay mangama-in katongkolan ay ampanginsolto koni Apo Hisos, ya wanla, ");
INSERT INTO sbl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nangilibri ya nin kanayon piro agna ma-ilibri ya sarili na. Warì alwan hiya ya Arì nin aw-inalalak ni Israyil? No mag-aypà ya bahen ha koroh ay tompel kayi kona. ");
INSERT INTO sbl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ampahimalà ya ha Diyos boy anhalita-en na ya hiya ay Anak nin Diyos. Helken tamo paraw no labayen nin Diyos nin ilibri na ya hapa-eg.” ");
INSERT INTO sbl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kateng hatoy loway tolisan ya kapariho nan impakò ha koroh ay ampanginsolto simpri kona. ");
INSERT INTO sbl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pa-ibat ogtoy allo anggan alas tris nin mahilem, hay babon lotà ay dinomeglem. ");
INSERT INTO sbl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Habayton alas tris nin mahilem, hi Apo Hisos ay nambo-angaw nin pagkahokaw, ya wana, “Ili, Ili, lama sabaktani,” ya hay labay totolen ay, “Diyos ko, Diyos ko, antà pina-olayan mo ko?” ");
INSERT INTO sbl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hin nalengè nin ongnoy tawoy anti bayro baytoy hinalità ni Apo Hisos ay hinalità la, ya wanla, “An-ingaten na hi Ilyas ya propita hin hato.” ");
INSERT INTO sbl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hay miha konla ay nowayon nangwa nin bilang ispongha ta imbahà na ha hokà, biha na inggawà ha tampoh nin tambò, ta impahephep na koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piro hinalità nin kanayon, “Pa-olayan mo ya,” wanla, “ta helken tamo paraw no lakwen yan ilibri ni Ilyas.” ");
INSERT INTO sbl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hapa-eg hi Apo Hisos ay nambo-angaw ana et nin pagkahokaw biha ya naboyto-an nin inawawen. ");
INSERT INTO sbl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hin habayton oras, hay makodpaw ya dolo ya pinagkortina ha lo-ob bali nin Diyos ay nawakwak nin napigitnà pa-ibat tag-ay anggan aypà; hay lotà ay na-eyeg boy hay bawbato ay nangapapaka. ");
INSERT INTO sbl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hay pawpinangitabonan ay nanga-a-abriyan, boy malakè ya nag-in tawtawo nin Diyos hin hato ya nikati ay nabiyay hin nabiyay oman hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hila ay nipampog-alih bayro ha pangitabonan ta nako hila ha Hirosalim ya masagradoy siyodad boy malakè ya tawo ya nakakit konla bayro. ");
INSERT INTO sbl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hatoy hawhondalò kateng kapitan la ya ampipamantay koni Apo Hisos ay masyadon nalimo hin nanlayon boy hin nakit lay kaganawan pangyayari. Hinalità la, “Talagan hiya,” wanla, “ya Anak nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hin habayton oras ha ma-in amò ya karayo-an ay ma-in malakè ya babayi ya ampangimaton no anyay ampangyari koni Apo Hisos. Hila bayto ya nipanhomono boy nipanambay koni Apo Hisos hin na-ibat ya ha probinsyan Galiliya. ");
INSERT INTO sbl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kalamo bayro hi Mariya ya taga Magdala, hi Mariya ya nanay ni Santiyago boy Hosi, kateng nanay nin aw-anak ni Sibidiyo. ");
INSERT INTO sbl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hin anyomabi ana ay nilomateng ya mihay mayaman ya nagngalan Hosi ya taga Arimatiya. Hiya ay miha ha kawkalamowan ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nako ya koni Pilato ta pinastang nan kowen ya bangkay ni Apo Hisos. Hapa-eg, immanda ni Pilato nin igwà koni Hosi baytoy bangkay ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hin nakwa ni Hosi ay pinotot na nin maganday klasin dolo ya mapotì boy malinis. ");
INSERT INTO sbl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Hin nayarì bayto, hay kapigawà ni Hosi ya kowibay bato ya pangitabonan dayi nin sarili na ay bayro na impahok ya bangkay ni Apo Hisos. Hapa-eg, nangitolid yan pagkaholay bato ya pinanarà na nin poltan pinangitabonan biha ya nog-alih. ");
INSERT INTO sbl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hi Mariya ya taga Magdala kateng hatoy mihay Mariya ay anti bayron ampiknò nin naka-arap ha pinangitabonan. ");
INSERT INTO sbl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ika-ibokah nin allon paghahandà para ha allon pama-inawa ya allon Sabado, hay pawpo-on nin pawparì kateng Pawparisiyo ay nako koni Pilato ");
INSERT INTO sbl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta hinalità la, ya wanla, “Apo, na-ihipan nawen ya hin angkabiyay et ba-in ya mabongkok ay hinalità nay ombayri: ‘Pangalabah nin tatloy allo ay mabiyay akon oman.’ ");
INSERT INTO sbl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kayà andawaten nawen komo ya imanda moy bantayan mahampat baytoy pinangitabonan kona anggan malabah ya tatloy allo emen hay aw-alagad na ay ahè makalako bayron manakaw bangkay na biha la halita-en ha tawtawo ya, ‘Hiya ay nabiyay oman.’ No mangyari baytoy ombayro ay mas lomalò bayti ya kabongkokan kisa hin primiro.” ");
INSERT INTO sbl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hinalità konla ni Pilato, “Mako kawoyna,” wana. “Mantan kawon hawhondalò ya pabantayen moyo ta bantayan lan mahampat.” ");
INSERT INTO sbl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kayà nanigè hilayna. Emen hila makasigoro ay impabantayan la, boy hatoy pinanarà la ay binyan lan tandà emen la matanda-an no ma-in nanlo-at o ayin. ");
INSERT INTO sbl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nalabah ya allon pama-inawa ya allon Sabado, hay hambak et nin allon Dominggo, hi Mariya ya taga Magdala kateng hatoy mihay Mariya ay nakon nanlek nin hatoy pinangitabonan koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hapa-eg, biglà nanlayon nin pagkahokaw biha hay anghil nin Pangino-on ay nona-oy ya nangibat ha katatag-ayan ha kama-inan nin Diyos, ta intolid na baytoy bato ya pinanarà nin hatoy poltan pinangitabonan biha ya niknò ha babo nin habaytoy bato. ");
INSERT INTO sbl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hay lopa na ay ampakapolag ta bilang kahawang kimat boy hay dolo na ay pagkapopotì. ");
INSERT INTO sbl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ha kalimowan nin hatoy bawbantay ya nakakit nin hatoy anghil ay nipamegpeg hila boy nikatomba ta nika-alomati. ");
INSERT INTO sbl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hapa-eg hatoy anghil ay naghalità do ha bawbabayi, “Agkawo malimo,” wana. “Tandà ko ya hay antikapen moyo ay hi Apo Hisos ya impakò ha koroh. ");
INSERT INTO sbl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hiya ay ayin bayri ta nabiyay yan oman nin bilang ombayro ha hinalità na. Mako kawo bayri ta biliwen moyo ya pinangigwa-an kona, ");
INSERT INTO sbl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","biha kawo manandalì nin mako ha aw-alagad na ta halita-en moyo konla ya ombayri: ‘Hiya ay nabiyay anan oman, boy hapa-eg hiya ay ma-ona komoyo nin mako ha probinsyan Galiliya; bayro moyo ya makit.’ Habayti ya hinalità ko komoyo ay tanda-an moyo.” ");
INSERT INTO sbl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hapa-eg hatoy bawbabayi ay midyo nalimo piro napnò hilan kaligawan. Nanandalì hilan nowayon mako ha aw-alagad, ta ibalità la baytoy impabalità konla nin hatoy anghil. ");
INSERT INTO sbl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ha pamowayo la ay biglà lan nahakbat hi Apo Hisos ya naghalità konla nin, “Magkama-in kawon katinekan,” wana. Napakarani hila kona ta tinomakeh hila ha bitih na boy hinomamba hila kona. ");
INSERT INTO sbl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hinalità konla ni Apo Hisos, “Agkawo malimo,” wana. “Manigè kawoyna ta ibalità moyo ha pawpinatel ko ya mako hila ha probinsyan Galiliya ta bayro la ko makit.” ");
INSERT INTO sbl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mintras anti ha daan baytoy bawbabayi, hay ongno do ha ampipagbantay nin hatoy tinabon ay nako ha siyodad nin Hirosalim, ta imbalità la ha pawpo-on nin pawparì baytoy kaganawan nin nangyari. ");
INSERT INTO sbl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hatoy pawpo-on nin pawparì ay pinatipon lay mawmato-ay mangama-in katongkolan, ta ni-i-ilgo hila nin soholan la baytoy hawhondalò. Kayà binyan lan malhay ya alagà ");
INSERT INTO sbl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","boy hinalità la, ya wanla, “Halita-en moyo ya hay bangkay ni Hisos ay tinakaw nin aw-alagad na hin yabi hin angkatoloy kawo. ");
INSERT INTO sbl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Maski malengè bayti nin gobirnador ay ayin kawon dapat ihipen ta hikayi ya ba-alà nin makitotol kona.” ");
INSERT INTO sbl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hapa-eg hatoy kowalta ya sohol ay tinanggap nin hatoy nipagbantay boy hinalità la baytoy impahalità konla. Angga hapa-eg ay ombayro et ya tototolen nin Hawhodiyo. ");
INSERT INTO sbl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hapa-eg hatoy labimmihay alagad ay nakoyna ha probinsyan Galiliya do ha bakil ya hinalità ni Apo Hisos nin lakwen la. ");
INSERT INTO sbl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hin nakit la hi Apo Hisos ay hinomamba hila kona maski ma-in ongno konla ya nagdoda nin hiya ay alwan hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hi Apo Hisos ay napakarani konla nin naghalità, ya wana, “Na-igwà ana kongko ya kaganawan kapangyariyan ha katatag-ayan ha kama-inan nin Diyos boy bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kayà manigè kawoyna nin mako ha kaganawan dogal, ta hay tawtawo ay toro-an moyo nin tompel kongko emen hila mag-in aw-alagad ko. Ha ngalan nin Tatay boy Anak boy Ispirito nin Diyos ay binyagan moyo hila, ");
INSERT INTO sbl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","boy toro-an moyo hilan homonol ha kaganawan bagay ya immanda ko komoyo. Tanda-an moyo: hiko ay pirmi komoyo angga ha ka-anggawan nin babon lotà.”");
INSERT INTO sbl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ombayri ya ompisa nin Mahampat ya Balità ya tongkol koni Pangino-on Hisokristo ya Anak nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Habayti ya hinalità nin Diyos ha Anak na ay inholat hin hato ni propita Isayas ya ombayri: “Hay hogò ko ay pa-onawen ko komo, ta hiya ya mangihandà nin para ha panlomateng mo. ");
INSERT INTO sbl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hiya bayto ya ampibobolyaw ha powiray dogal nin ombayri: ‘Homandà kawo ha panlomateng nin Pangino-on nin bilang ha ampangihandà nin kowinta daan ya pagdanan na emen ayin maka-abalà kona.’” ");
INSERT INTO sbl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Habayti ya inholat ni Isayas ay natopad ana, ta do ha powiray dogal, hi Howan ay anti ana bayro nin ampaminyag boy ampangaral. Hay an-i-aral na ay ombayri: “Maghehe kawo ha ginawà moyoy kawkasalanan boy pabinyag kawo emen kawo patawaren nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hapa-eg, kaganawan tawo ha siyodad nin Hirosalim ya sakop nin probinsyan Hodiya kateng tawtawo ha kaganawan dogal ya sakop et nin habaytoy probinsya ay nako koni Howan. Kaganawan nangihokò nin kawkasalanan la ha Diyos ay bininyagan ni Howan ha balah nin Hordan. ");
INSERT INTO sbl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hay dolo ni Howan ay yarì ha habot nin ayop ya kamel boy hay tagkeh na ay yarì ha katat. Hay pamamangan na ay dawdoron boy polot panilan. ");
INSERT INTO sbl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hapa-eg, hay an-i-aral ni Howan ha tawtawo ay ombayri, “Ma-in tawoy lomateng ya angkahoyot kongko. Hiya ay mas makapangyariyan dinan hiko, ta maski mangokà nin sintas sapatos na ay alwa kon karapatdapat. ");
INSERT INTO sbl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bininyagan katawo ha lanom piro hiya, hay ibinyag na komoyo ay Ispirito nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hin habayton pana-on, hin ampaminyag hi Howan, hi Apo Hisos ya na-ibat ha banowan Nasarit ha probinsyan Galiliya ay nako bayro koni Howan nin pabinyag. Hiya ay bininyagan ni Howan bayro ha balah nin Hordan. ");
INSERT INTO sbl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hin tinomwah hi Apo Hisos ha lanom ay nakit nan antimanoy langit ya naglo-at, boy hay ampag-aypà nin mako kona ya Ispirito nin Diyos ay bilang kalapati. ");
INSERT INTO sbl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hapa-eg, ma-in bosis ya nangibat ha katatag-ayan ha kama-inan nin Diyos ya ampaghalità, ya wana, “Hika ya mimihay Anak koy pinakalabilabi ko ya ampakapakonsowilo kongko.” ");
INSERT INTO sbl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hapa-eg hi Apo Hisos ay pinalakon antimano nin Ispirito nin Diyos ha powiray dogal. ");
INSERT INTO sbl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ha lo-ob nin apatapò ya allo ni Apo Hisos bayro, hiya ay antokso-en ni Satanas piro agya natoksò. Ma-in et bayro nin mangabangis ya aw-ayop, piro hay aw-anghil nin Diyos ay anti bayro nin ampangasiwà koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hapa-eg, hin impiriso hi Howan, hi Apo Hisos ay nako ha probinsyan Galiliya ta bayro na in-aral ya Mahampat ya Balità ya nangibat ha Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ombayri ya hinalità ni Apo Hisos, “Pana-on ana,” wana. “Marani anan matopad baytoy holà hin hato ya tongkol ha pamomo-on nin Diyos ha nakem nin tawtawo. Kayà paghehean moyoynay kawkasalanan moyo boy minto-o kawo ha Mahampat ya Balità.” ");
INSERT INTO sbl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Hin ampagdaan hi Apo Hisos ha ambay dagat nin Galiliya ay nakit nay mipatel ya manlalapet ya hi Simon boy hi Andris. Hin habayto, hila ay ampaninsoro ha dagat. ");
INSERT INTO sbl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hinalità konla ni Apo Hisos, “Makilamo kawo kongko,” wana, “ta gaw-en katawon mangipakarani kongko nin tawtawo.” ");
INSERT INTO sbl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Antimano, imbalag lay sinsoro la ta nakilamo hila koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hin naka-owako hi Apo Hisos nin ma-in amò ya distansya ay nakit na hi Santiyago boy hi Howan ya mipatel ya aw-anak ni Sibidiyo. Hila ay anti ha bangkà ta an-ayomawen lay aw-eket la. ");
INSERT INTO sbl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Antimano, hila ay hinagyat ni Apo Hisos nin makilamo kona. Hapa-eg, imbalag lay tatay la ya anti ha bangkà kateng hatoy tawtawoy inopa-an la nin mipanambay konla nin manlapet, ta nakilamo hila koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hapa-eg hili Apo Hisos ay nakalateng ha banowan Kapirnawom. Lomateng ya Sabado ya allon pama-inawa nin Hawhodiyo, banà ta Hodiyo hi Apo Hisos ay nilomo-ob ya ha himba-an nin Hawhodiyo ta bayro ya nanorò. ");
INSERT INTO sbl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hay panorò na ay ampag-ispantawan nin tawtawo, ta hay panonorò na ay alwan bilang ha panonorò nin mawmangitorò nin kawkapanogo-an. Ha panonorò na ay talagan ma-in yan kapangyariyan. ");
INSERT INTO sbl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Bayro ha lo-ob nin himba-an, mintras ampanorò et hi Apo Hisos ay biglà nambo-angaw ya mihay lalaki ya napahokan nin mala-et ya ispirito. “Hisos ya taga Nasarit,” wana, “anyay paki-emenan mo konnawen? Nako ka nayì bayri para hikayi ay apo-en ana? Tandà ko no hino ka; hika ay nangibat ha Diyos boy ayin kan kapintasan!” ");
INSERT INTO sbl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hay ginawà ni Apo Hisos ay minandawan na baytoy mala-et ya ispirito, ya wana, “Agka pakatlek boy mog-alih ka bahen ha tawo!” ");
INSERT INTO sbl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ha kagagaw-an nin hatoy mala-et ya ispirito, hatoy lalaki ay hinomwag boy nambo-angaw biha nog-alih kona baytoy mala-et ya ispirito. ");
INSERT INTO sbl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaganawan tawoy nakakit nin hatoy ginawà ni Apo Hisos ay nipag-ispanta. Kayà nipapastang hila, ya wanla, “Anyaraw bayti? Kanayon ya torò bayti! Habayti ya tawo ay ma-in kapangyariyan ta angkamandawan nay maski mangala-et ya aw-ispirito boy anhomonol hila kona.” ");
INSERT INTO sbl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Habaytoy ginawà ni Apo Hisos, antimano ay nibahwag ha kaganawan dogal ha probinsyan Galiliya. ");
INSERT INTO sbl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hapa-eg, hin nog-alih hili Apo Hisos bayro ha himba-an nin Hawhodiyo ay nako hila ha bali ni Pidro boy Andris. Nakilako konla hi Santiyago boy hi Howan. ");
INSERT INTO sbl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hin habayto itaman, hay babayi ya ampò ni Pidro ay naka-irà ta an-amoten. Antimano, imbalità la koni Apo Hisos ya hay ampò ni Pidro ay ampagmasakit. ");
INSERT INTO sbl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hapa-eg, napakarani hi Apo Hisos do ha babayi, ta inoligtanan nay gamet na biha na ya inibangon. Hapa-eg, natbahan ya boy dinolotan na hili Apo Hisos nin pamamangan. ");
INSERT INTO sbl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Haton mahilem, hin hinomlep anay allo, gintan nin tawtawo koni Apo Hisos ya kaganawan ampipagmasakit boy pinahokan dawdimonyo. ");
INSERT INTO sbl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaganawan tawo ha banoway habayto ay nititipon ha polta nin bali ya kama-inan ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Malakè ya tawoy ma-in hari-harì ya masakit ya pinakahampat ni Apo Hisos. Malakè simpri ya dimonyo ya pinomahok ha tawtawo ya pina-alih na, piro agna hila pinayagan maghalità ta balay la ya. ");
INSERT INTO sbl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Malalè et ya palbangon, hi Apo Hisos ay nako ha powiray dogal ta bayro ya nanalangin. ");
INSERT INTO sbl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hapa-eg hi Simon boy kawkalamowan na ay ampanoto koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hin nakit la ya ay hinalità la kona, ya wanla, “Kaganawan ay ampanikap komo.” ");
INSERT INTO sbl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hinalità konla ni Apo Hisos, ya wana, “Mako tamoyna ha kawkarani ya baryo emen ako itaman makatorò bayro, ta habayti ya bara-nan nin pamako ko bayri ha babon lotà.” ");
INSERT INTO sbl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kayà hi Apo Hisos ay nako ha kaganawan dogal ha probinsyan Galiliya, ta ha hawhimba-an nin Hawhodiyo ay anlomo-ob ya nin mangaral, boy hay dawdimonyoy pinomahok ha tawtawo ay ampa-alihen na. ");
INSERT INTO sbl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hapa-eg hi Apo Hisos ay nilako nin mihay tawoy ma-in liproso. Habaytoy tawo ay ampitatalimokod nin maki-i-ingalo koni Apo Hisos, ya wana, “No kalabayan mo ay mapakahampat mo bayti ya dipirinsya ko emen lominis ya nawini ko.” ");
INSERT INTO sbl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ha ingangalo ni Apo Hisos ay impaktang nay gamet na ta inaptoh na baytoy lalaki boy hinalità na, “Labay ko,” wana; “kayà lominis ka.” ");
INSERT INTO sbl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Antimano, hay liproso na ay na-alih; kayà malinis anay nawini na. ");
INSERT INTO sbl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hapa-eg, pinadandalì ni Apo Hisos nin pina-alih baytoy lalaki boy mahigpit na yan binibilinan, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Agmo ibalità ha maski hinoy tawo ya tongkol ha nangyari komo. Hay gaw-en mo ay mako ka ha parì ta ipakit moy nawini mo ya ayin anan dipirinsya. Mantan kan idolog mo ha Diyos nin bilang ombayro ha impanogò ni Moysis hin hato ya mamapteg ha tawtawo nin hika ay hinomampat ana.” ");
INSERT INTO sbl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piro hin nog-alih baytoy tawo ay imbabalità na baytoy ginawà kona ni Apo Hisos. Banà bayri, hi Apo Hisos ay agana makabastabastan makalako ha banowa, no alwan ampagpirmi ya tana ha powiray dawdogal. Ombayro man, hiya ay anlakwen nin tawtawo ya ampika-ibat ha maski ayrin dogal. ");
INSERT INTO sbl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nalabah ya ongnoy allo, hi Apo Hisos ay nagbira ha banowan Kapirnawom. Nabalita-an nin tawtawo ya hiya ay anti ha bali ya ampa-iriyan na. ");
INSERT INTO sbl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ha kalak-an tawoy nako bayron nititipon ay ayin anan pa-iriyan maski ha polta ya pagdanan lomo-ob bayro ha bali. Peleg ampangi-aral hi Apo Hisos konla nin Halità nin Diyos ");
INSERT INTO sbl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ay ma-in nakalateng ya tawtawoy nantan nin mihay lalaki ya polonen ya gitan la bayro koni Apo Hisos. Apat konla nin hatoy nakalateng ya ampanapwat nin hatoy polonen. ");
INSERT INTO sbl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Habaytoy polonen ay agla ma-ipakarani koni Apo Hisos banà ha kalak-an tawo. Hay ginawà la ay nolì hila ha bobongan ta nilo-atan la ya ogto ni Apo Hisos. Bayro la imparaan nin in-aypà baytoy polonen ya naka-irà ha pinanapwatan kona. ");
INSERT INTO sbl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hin nakit ni Apo Hisos ya ma-in hilan katetpel ay hinalità na do ha tawoy polonen, “Anak ko,” wana, “hika ay pinatawad ana ha kawkasalanan mo.” ");
INSERT INTO sbl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hapa-eg hatoy anti bayron ampiknò ya ongnoy mangitorò nin kawkapanogo-an ay ombayri ya anti ha nakem la, ");
INSERT INTO sbl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ha hinalità nin habayti ya tawo ay emen hiya ya makapatawad nin kawkasalanan. Haba-in ya ginawà na ay panla-et ha Diyos, ta Diyos bongat ya makapatawad nin kawkasalanan.” ");
INSERT INTO sbl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piro habaytoy anti ha nakem la ay talagan tandà ni Apo Hisos; kayà hinalità na konla, ya wana, “Antà nin ombahen ya an-ihipen moyo? ");
INSERT INTO sbl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Anyay mas maparan mangyari ya halita-en bayri ha polonen, ‘Napatawad ana ya kawkasalanan mo,’ o ‘Mibangon ka ta hapwaten moy pinamir-an mo biha ka mowako’? ");
INSERT INTO sbl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ha pamakahampat ko nin habayti ya tawo ay mapaptegan ko komoyo ya hiko ya an-ingaten Anak nin Tawo ay ma-in kapangyariyan bayri ha babon lotà nin mamatawad kawkasalanan.” Hapa-eg, hinalità ni Apo Hisos do ha polonen, ");
INSERT INTO sbl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mibangon ka,” wana, “hapwaten moy pinamir-an mo ta mowako kaynan morong.” ");
INSERT INTO sbl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hapa-eg, nireng baytoy polonen. Antimano, hinapwat nay pinamir-an na biha ya nog-alih bayro. Nakit nin kaganawan ya panapwat na nin pinamir-an na boy nakit la yay nog-alih. Banà bayro ha nakit la ay nag-ispanta hila boy pinori lay Diyos. “Nakakanoman,” wanla, “ay agtamo et nakakit nin ombayri ya pangyayari.” ");
INSERT INTO sbl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hapa-eg hi Apo Hisos ay nakon oman ha ambay dagat nin Galiliya, boy malakè ya tawoy nako bayron nakitipon kona. Habaytoy tawtawo ay tinoro-an na. ");
INSERT INTO sbl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hin nayarì bayto ay nanigè ana et hi Apo Hisos boy niparaan ya ha opisina ya pamayaran bo-ih. Hi Matiyo ya anak ni Alpiyo ay nakit ni Apo Hisos ya naka-iknò bayro ha pamayaran bo-ih. Hinalità ni Apo Hisos kona, “Makilamo ka kongko,” wana. Hi Matiyo ay nireng ta nakilamo koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hapa-eg hi Apo Hisos kateng aw-alagad na ay anti ha bali ni Matiyo nin ampangan. Malakè ya mawmanininon bo-ih kateng kanayon ya tawtawoy alwan mahampat ya pagkatawo ay kalamo lan ampangan. Hila bayti ay nipampakihono koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hin nakit nin ongnoy Parisiyo ya mawmangitorò nin kawkapanogo-an ya hi Apo Hisos ay ampakipangan ha mawmanininon bo-ih boy ha tawtawoy alwan mahampat ya pagkatawo ay hinalità la ha aw-alagad ni Apo Hisos, ya wanla, “Antà ampakipangan hi Hisos bahen ha ombahen ya pawpagkatawo?” ");
INSERT INTO sbl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hin nalengè ni Apo Hisos baytoy pastang la ha aw-alagad na ay ombayri ya alimbawà ya intobay na konla, “Hay tawoy ayin masakit ay ahè ampanga-ilangan nin mananambal. Hay ampanga-ilangan bongat nin mananambal ay hatoy ma-in masakit. Ombayro itaman ya pamako ko bayri ha babon lotà. Agko nako bayrin mangingat nin tawtawoy ahè ampangamin nin hila ay makasalanan, no alwan nako ko bayri nin mangingat nin tawtawoy ampangamin nin hila ay makasalanan.” ");
INSERT INTO sbl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Minghan, hin nagpaltan nangan ya aw-alagad ni Howan Mamiminyag kateng Pawparisiyo banà ha panhohomonol la ha ka-ogali-an nin Hawhodiyo, hi Apo Hisos ay pinakaraniyan nin ongnoy tawo ta hinalità la kona, ya wanla, “Antà hay aw-alagad ni Howan boy aw-alagad nin Pawparisiyo ay ampagpaltan mangan, ta hay aw-alagad mo ay ahè ampagpaltan mangan?” ");
INSERT INTO sbl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ombayri ya intobay konla ni Apo Hisos: “Ma-arì warì nin magpaltan mangan ya tawtawoy kinombida ha banhal mintras anti et konla baytoy kakahal nin babayi? Mintras anti et konla baytoy kakahal nin babayi ay aghila magpaltan mangan. ");
INSERT INTO sbl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piro lomateng ya oras ya alihen konla baytoy kakahal nin babayi; ha allon habayto ay magpalta hilan mangan.” ");
INSERT INTO sbl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hapa-eg hi Apo Hisos ay nangi-alimbawà et nin ombayri: “Ayin tawoy mangitakop nin bayoy ritaso ha da-an ya dolo, ta no gaw-en na bayto, hay bayoy intakop ay manirà nin hatoy da-an ya dolo; kayà lalò homlay ya ginit. ");
INSERT INTO sbl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ayin simprin tawoy mangipalaman nin kapelhan ampa-ahemen ya basì ha da-an ya katat ya pambiyanan basì, ta no gaw-en na bayto, hay bayoy basì ay manirà nin da-an ya katat. Hapa-eg hay basì ay masayang boy hay katat ay mahirà. Hay bayoy basì ay dapat ipalaman ha bayoy katat ya pambiyanan.” ");
INSERT INTO sbl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mihay allon Sabado, allon pama-inawa nin Hawhodiyo, mintras ampowako hili Apo Hisos, hila ay niparaan ha ma-in tawtanaman ya trigo. Hay aw-alagad na ay nipanggetè nin trigo. ");
INSERT INTO sbl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hapa-eg, ma-in bayron Pawparisiyo ya nakakit konla. Kayà hinalità la koni Apo Hisos, “Biliwen moy aw-alagad mo,” wanla, “antà anggaw-en la ba-in ya ha kawkapanogo-an tamo ay labag gomawà nin ombahen no allon pama-inawa?” ");
INSERT INTO sbl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ombayri ya hinalità konla ni Apo Hisos, “Warì agmoyo et nabaha ya nakaholat ya ginawà ni Dabid hin hato hin binomitil ya kateng kawkalamowan na ta na-obohan hila nin pamamangan? ");
INSERT INTO sbl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nilomo-ob ya ha bali nin Diyos ta nangwa yan tinapay ya indolog ha Diyos. Nangan yan hatoy tinapay boy pinakan nay kawkalamowan na maski kontra ha kawkapanogo-an tamo ya mangan nin habayto, ta hay ma-arì bongat mangan nin habayto ay pawparì. Hay pinakapo-on nin pawparì hin habayto ay hi Abiyatar ya pinomayag nin hi Dabid ay mangwa nin habaytoy tinapay.” ");
INSERT INTO sbl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hinalità et ni Apo Hisos ha Pawparisiyo, “Hay allon pama-inawa ay inggawà nin Diyos para ikahampat nin tawo; agna pinalsa ya tawo nin para ha allon pama-inawa. ");
INSERT INTO sbl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kayà hiko ya an-ingaten Anak nin Tawo ay ma-in karapatan maghalità no anyay tamà gaw-en no allon pama-inawa.” ");
INSERT INTO sbl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hapa-eg hi Apo Hisos ay nakon oman ha himba-an nin Hawhodiyo. Bayro ay ma-in mihay lalaki ya hay mihay gamet ay ahè ana ma-igalaw ta kinomampil. ");
INSERT INTO sbl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hi Apo Hisos ay ampaka-i-imatonan nin tawtawoy kontra kona no ha habayton allo ya allon pama-inawa ay pakahampaten na baytoy lalaki, ta ampanikap hilan bara-nan ya pangidimandawan la koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hinalità ni Apo Hisos do ha lalaki ya kinomampil ya gamet, “Mako ka bayri ha arapan,” wana. ");
INSERT INTO sbl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hapa-eg, pinastang ni Apo Hisos baytoy tawtawoy kontra kona, ya wana, “Kompormi ha kawkapanogo-an ya tongkol ha allon pama-inawa, anyay tamà gaw-en? Tambayan nayì ya tawoy anti ha kadya-dya-an o pa-olayan? Tambayan ya nayì emen ya mabiyay o pa-olayan emen ya mati?” Aghila nakatbay koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ha katya-an pagnanakem la ay nablò ya nakem ni Apo Hisos. Hapa-eg, pinalibotan na hilan tinegteg nin ma-in pahang, biha na hinalità do ha lalaki ya kinomampil ya gamet, “Ipaktang moy gamet mo,” wana. Hapa-eg, impaktang nin hatoy lalaki ya gamet na ta hinomampat ana. ");
INSERT INTO sbl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hin habayto, hatoy Pawparisiyo ay nilomikol do ha himba-an nin Hawhodiyo, ta nako hilan antimano ha tawtawowan ni Arì Hirodis. Bayro la ampi-i-ilgowan no pangno la mapati hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hapa-eg hi Apo Hisos kateng aw-alagad na ay nog-alih, ta nako hila ha ambay dagat nin Galiliya. Pagkalakè tawoy nakihono konla. Ma-in taga bayro ha probinsyan Galiliya. Ma-in na-ibat ha probinsyan Hodiya, ");
INSERT INTO sbl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kateng ha siyodad nin Hirosalim ya sakop nin habaytoy probinsya. Ma-in itaman na-ibat ha probinsyan Idomiya, ma-in simprin na-ibat ha kagmang balah nin Hordan, boy ma-in et na-ibat ha mamalibot nin banowan Tiro boy banowan Sidon. Habayti ya malakè ya tawo ay nako koni Apo Hisos ta nabalita-an lay kaganawan gawà na. ");
INSERT INTO sbl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hapa-eg, hinalità ni Apo Hisos ha aw-alagad na ya pangihandà la ya nin mihay bangkà ya hakyan na emen agya mangapipepetpetan nin habaytoy kalak-an tawo. ");
INSERT INTO sbl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Banà ta namakahampat ya nin malakè ya ampipagmasakit ay malakè ya ampakipapaletpet nin makon mangaptoh kona emen hila homampat ha masakit la. ");
INSERT INTO sbl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hay tawtawoy napahokan nin mangala-et ya aw-ispirito, hin nakit la hi Apo Hisos ay nipanlokob hila ha arapan na boy nan-angaw, ya wanla, “Hika ya Anak nin Diyos!” ");
INSERT INTO sbl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piro inhigpit ni Apo Hisos nin hinalità do ha mangala-et ya aw-ispirito ya agla ibalità ya hiya ay Anak nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hapa-eg hi Apo Hisos ay nilomakat ha bakil kalamo nay tawtawoy iningat na. Hila ay napakarani kona. ");
INSERT INTO sbl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bayro konla ay namilì ya nin labinloway lalaki ya paglamolamo na boy ihogò nan mangaral. ");
INSERT INTO sbl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Hila ay binyan nan kapangyariyan nin mama-alih nin dawdimonyoy pinomahok ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Habayti ya tawtawoy pinilì ni Apo Hisos ay hi Simon ya pinangalanan et ni Apo Hisos nin Pidro, ");
INSERT INTO sbl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","boy loway anak ni Sibidiyo ya hi Santiyago boy hi Howan ya pinangalanan nin Bowanirgis ya hay labay totolen ay aw-anak nin korol. Ombayroy impangalan konla ta hila ay mapabiglà. ");
INSERT INTO sbl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Hay pinilì na et ay hi Andris, hi Pilipi, hi Bartolomi, hi Matiyo, hi Tomas, hi Santiyago ya anak ni Alpiyo, hi Tadyo, hi Simon ya mapagmalasakit ha nasyon Israyil, ");
INSERT INTO sbl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","boy hi Hodas Iskariyoti ya nangisapakat koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hapa-eg, hin naka-orong hili Apo Hisos ay nilako la yayna et pini-o-opongan nin malakè ya tawo. Kayà hi Apo Hisos kateng aw-alagad na ay aglayna angka-arap nin mangan. ");
INSERT INTO sbl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hin nabalita-an nin pawpartidos ni Apo Hisos ya tongkol ha anggaw-en na ay nilako la yan kowen, ta ma-in tawtawo ya ampaghalità nin lokoloko ya. ");
INSERT INTO sbl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma-in ongnoy mangitorò nin kawkapanogo-an ya nika-ibat ha siyodad nin Hirosalim ya nipaghalità, “Hi Bilsibob,” wanla, “ya po-on nin dawdimonyo ay pinomahok bahen koni Hisos; kayà ampakapa-alih ya nin dawdimonyo ya pinomahok ha tawtawo.” ");
INSERT INTO sbl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","24","Hapa-eg, iningat ni Apo Hisos nin pakarani kona baytoy tawtawoy anti bayro ta hinalità na konla, ya wana, “Warì ma-arì pa-alihen ni Satanas ya sarili na?” Ombayri et ya hinalità ni Apo Hisos konla ya kawka-alimbawa-an: “No ma-in arì,” wana, “ta hay ampag-ari-an na ay mi-a-away ay ahè bomoyot ya pamomo-on na; ");
INSERT INTO sbl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","boy no ampi-a-away ya tawtawoy ampa-iri ha mimihay bali ay ahè bomoyot ya pamilalamo la. ");
INSERT INTO sbl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No kalabanen ni Satanas ya sarili na, hay kapangyariyan nan mamo-on ay ahè bomoyot ta tampol ma-anggawan. ");
INSERT INTO sbl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hay bali nin makhaw ya tawo ay ayin makalo-ob nin manakaw nin kawkamama-in na no agna pon balolen baytoy makhaw ya tawo. Ha ombayro, hay bali na ay ma-arì anan panakawan. ");
INSERT INTO sbl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Habayti ya tanda-an moyo: hay tawtawo ay patawaren ha kaganawan kasalanan la boy pawpanla-et ya anhalita-en la, ");
INSERT INTO sbl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","piro hinoman ya ampaghalità nin mala-et ya kontra ha Ispirito nin Diyos ay ayin kapatawaran maski makakano, ta ha ombayro ay an-itowad na nin hay gawgawà nin Ispirito nin Diyos ay gawgawà ni Satanas. Habaytoy kasalanan na ay manatili kona anggan makakanoman.” ");
INSERT INTO sbl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Habayti ay hinalità ni Apo Hisos ta anhalita-en nin hatoy mawmangitorò nin kawkapanogo-an ya hiya ay pinahokan nin mala-et ya ispirito. ");
INSERT INTO sbl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hapa-eg hay nanay ni Apo Hisos kateng pawpatel nay lawlalaki ay nakalateng. Hila ay ampireng ha likol bali boy impa-ingat la hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ha mamalibot ni Apo Hisos ay malakè ya tawoy ampipampiknò. Hinalità la kona, ya wanla, “Hay nanay mo boy pawpatel moy lawlalaki ya ampanikap komo ay anti ha likol.” ");
INSERT INTO sbl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tinombay konla hi Apo Hisos, “Hino,” wana, “ya antokoyen moyon nanay ko boy pawpatel ko?” ");
INSERT INTO sbl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hapa-eg, tinegteg na baytoy tawtawoy ampipampiknò ha mamalibot na biha na hinalità, “Hila bayti,” wana, “ya nanay ko boy pawpatel ko, ");
INSERT INTO sbl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ta hinoman ya anhomonol ha kalabayan nin Diyos ay hila ya nanay ko boy pawpatel ko.” ");
INSERT INTO sbl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hapa-eg hi Apo Hisos ya antin oman ha ambay dagat ay nag-ompisayna et nin manorò. Banà ha kalak-an tawoy nakitipon kona ay hinomapat ya ha bangkà ta bayro ya niknò nin manorò. Hay tawtawo itaman ay anti ha lakatan nin ampanlengè. ");
INSERT INTO sbl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Malakè ya bagay ya an-itorò konla ni Apo Hisos ya aw-alimbawà. ");
INSERT INTO sbl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Hinalità konla ni Apo Hisos, “Leng-en moyo!” wana. “Ma-in mihay lalaki ya nakon nanabwag. ");
INSERT INTO sbl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ha pangihabwag na ay ma-in ongnoy pahì ya natata ha daan. Hatoy pawpahì ya nikatata ha daan ay kinan nin mawmanokmanok. ");
INSERT INTO sbl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma-in itaman pawpahì ya nikatata ha babon matampiyak ya bato ya ma-in amò ya lotà. Habaytoy pawpahì ay tampol tinomobò, ta alwan makodpaw ya lotà ya nakataphon. ");
INSERT INTO sbl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hapa-eg, hin inomamot ya hilà allo, hatoy pawpahì ya tinomobò ay nalaneh anggan nayangoh ta mababoy pinanyamotan. ");
INSERT INTO sbl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hay kanayon ya pawpahì ay nikatata ha antobo-an nin ampangayakay ya dawdikot ya madowih. Hin tinomobò baytoy pawpahì ay tinomobò itaman baytoy ampangayakay ya dawdikot ya madowih. Kayà ahè nakabonga baytoy pawpahì ya tinomobò ta napolopotan nin hatoy ampangayakay ya dawdikot ya madowih. ");
INSERT INTO sbl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Piro ma-in pawpahì ya nikatata ha maganday lotà. Habaytoy pawpahì ay tinomobò nin mahampat boy namonga. Ma-in pinaka-alawahanan tatlompò, ma-in pinaka-alawahanan anemapò, boy ma-in pinaka-alawahanan magato. ");
INSERT INTO sbl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hay ka-ilangan moyo,” wana et ni Apo Hisos, “ay manlengè mahampat nin habayti ya anhalita-en ko biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hapa-eg, hin ayin ana baytoy malakè ya tawo, hi Apo Hisos ay pinastang nin labinloway alagad na kateng hatoy kanayon ya kawkalamowan na no anyay labay totolen nin hatoy aw-alimbawà na. ");
INSERT INTO sbl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hinalità konla ni Apo Hisos, “Komoyo,” wana, “inggawà ya pangingintindi nin sawsikrito ya tongkol ha pamomo-on nin Diyos; piro ha kanayon ya tawtawo, kaganawan bagay ya itorò konla ay i-alimbawà emen matopad bayti ya holà hin hato: ");
INSERT INTO sbl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Manegteg hila man anan manegteg ay aghila makakit. Manlengè hila man anan manlengè ay aghila maka-intindi; ta no angka-intindiyan la ay pakarani hila ha Diyos. Hay Diyos itaman ay mambi konla nin kapatawaran.’” ");
INSERT INTO sbl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hapa-eg, hinalità ni Apo Hisos ha aw-alagad na, ya wana, “Warì agmoyo na-intindiyan baytoy hinalità koy alimbawà? No agmoyo angka-intindiyan bayto ay pangno moyo man awod ma-intindiyan ya maski anyay alimbawà? ");
INSERT INTO sbl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hay Halità nin Diyos ay kowinta inhabwag nin mananabwag. ");
INSERT INTO sbl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hay ka-alimbawa-an nin hatoy daan ya kinatatawan nin pawpahì ay tawtawoy nakalengè Halità nin Diyos, piro tampol inalih ni Satanas ha nakem la baytoy nalengè lay Halità nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hatoy matampiyak ya bato ya ma-in amò ya lotà ya kinatatawan nin pawpahì ay bilang ha tawtawo ya nakalengè nin Halità nin Diyos. Hin nalengè la bayto, antimano, tinanggap la nin ma-in kaligawan. ");
INSERT INTO sbl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piro hay Halità nin Diyos ay ahè nakayamot ha nakem la boy kadodomalì bongat ya pananggap la. No ma-in anlomateng ya angkagolowan ihip la, boy no ampagkama-in hila nin kawkadya-dya-an nin banà ha Halità nin Diyos ay angka-alin antimano ya pantotompel la. ");
INSERT INTO sbl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Hatoy lotà ya ma-in ampangayakay ya dawdikot ya madowih ya kinatatawan nin pawpahì ay bilang simpri ha tawtawoy nakalengè nin Halità nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Piro banà ha bawbagay ya angkagolowan la ha biyay la, ha kalabayan la nin yomaman, boy ha paghangad la nin kanayon ya bawbagay, hila ay kowinta pawpahì ya tinomobò ya napolopotan nin ampangayakay ya dawdikot ya madowih. Kayà hay Halità nin Diyos ya nalengè la ay ahè namonga ha biyay la. ");
INSERT INTO sbl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hatoy maganday lotà ya kinatatawan nin pawpahì ay bilang ha tawtawo ya nanlengè nin Halità nin Diyos. Habaytoy nalengè lay Halità nin Diyos ay pininto-o la, boy nakapibongan kahampatan ha biyay la nin emen ha pawpahì ya ma-in namongan tatlompò, ma-in anemapò, boy ma-in namongan magato.” ");
INSERT INTO sbl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hi Apo Hisos ay naghalità ana et konla, ya wana, “Warì hay kingki ya andongket ay anhalokoban nin kalaying o an-itagò ha hilong katri? Warì ahè an-igwà ha talagan pangigwa-an? ");
INSERT INTO sbl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ayin nakatagò ya ahè mipatnag, boy ayin sikrito ya ahè mibolgar. ");
INSERT INTO sbl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hay ka-ilangan moyo,” wana et ni Apo Hisos, “ay manlengè mahampat nin habayti ya anhalita-en ko biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hinalità ana et ni Apo Hisos, “Pakaleng-en moyon mahampat,” wana, “ya an-itorò ko, ta no leng-en moyo, hay Diyos ay mambi komoyo nin pangingintindi boy lalò nan ipa-intindi komoyo. ");
INSERT INTO sbl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hay tawoy ampinto-o ha bagay ya an-ipa-intindi kona nin Diyos ay lalò maka-intindi ha an-ipa-intindi kona. Piro hay tawoy ahè ampinto-o ha an-ipa-intindi kona nin Diyos ay alihen et ha nakem na baytoy amò ya na-intindiyan na.” ");
INSERT INTO sbl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ombayri et ya alimbawà ni Apo Hisos: “Hay pamomo-on nin Diyos ay bilang ha lalaki ya nanabwag nin binì. ");
INSERT INTO sbl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hin nayarì nan inhabwag ay patoloy yan magtrabaho nin allo-allo. No yabi ay matoloy ya. Habayti ya inhabwag na ay agna tandà no pangno anlomhì boy no pangno antomobò. ");
INSERT INTO sbl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hay lotà ya ampakapatobò boy ampakapabonga nin hatoy intanem, ta hay ampangyari ay ombayri: tomobò pon biha homwak, bayo manlaman ya pawpahì. ");
INSERT INTO sbl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No mato-ayna ay alawahanen ana nin hatoy lalaki ya nanabwag.” ");
INSERT INTO sbl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Anya et,” wani Apo Hisos, “ya pangiparisan tamo nin pamomo-on nin Diyos boy anya et ya pangi-alimbawa-an tamo? ");
INSERT INTO sbl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hay pamomo-on nin Diyos ay ayin imbalag ha bot-on mostasa ya pinakamayamò ya bot-o ha kaganawan an-itanem. ");
INSERT INTO sbl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","No na-itanem ana, maski pinakamayamò bayto, pantomobò ay anhomlay nin mas et ha kanayon ya po-on gawgolay. Kayà hay mawmanokmanok ay ampipanayi ha mangalhay ya hawhanga nin habayto.” ");
INSERT INTO sbl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hay Halità nin Diyos ya an-i-aral konla ni Apo Hisos ay anggamitan na nin bilang ombayri ya alimbawà kompormi ha kaya lan intindiyen. ");
INSERT INTO sbl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Panay alimbawà ya anggamiten na ha pangi-aral na konla; piro no hilahilan bongat nin aw-alagad na ay an-ipalinaw na konla ya labay totolen nin habaytoy aw-alimbawà na. ");
INSERT INTO sbl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lomateng ya mahilem nin habayton allo, hinalità ni Apo Hisos ha aw-alagad na, “Lomipay tamo,” wana. ");
INSERT INTO sbl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hapa-eg, hay aw-alagad ay hinomapat do ha bangkà ya anhakyan ni Apo Hisos. Inalihan la baytoy kalak-an tawo ta nanigè hilayna, boy ma-in et ongnoy bangkà ya anhakyan nin tawtawoy nakilako konla. ");
INSERT INTO sbl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mintras anlomipay hili Apo Hisos ay biglà hinomkaw ya angin. Hay bangkà la ay halos lomdeg ana ta angkahipwakan nin mangalhay ya dawoyon. ");
INSERT INTO sbl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hin habayto, hi Apo Hisos ya anti ha bandan hoyotan nin bangkà ay naka-onan ya angkatoloy. Pinokaw ya nin aw-alagad na, ya wanla kona, “Pangino-on, lomdeg tamoyna, ayin nayì kowinta komo ya mati tamo?” ");
INSERT INTO sbl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nibangon hi Apo Hisos ta minandawan nay angin nin tonggen boy hinalità na ha dagat, “Pakatinek ka!” wana. Hapa-eg, tinonggen baytoy pagkahokaw angin boy hay dagat ay tinominek. ");
INSERT INTO sbl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hinalità ni Apo Hisos ha aw-alagad na, ya wana, “Antà angkalimo kawo? Warì ayin kawo et katetpel?” ");
INSERT INTO sbl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hay limo lan masyado boy hay ispanta la; kayà hinalità la ha miha ta miha, “Anyan magkatawowan bayti ta maski angin boy dawoyon ay anhomonol kona?” ");
INSERT INTO sbl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hapa-eg hili Apo Hisos ay ni-abot ha lipay dagat nin Galiliya ya dogal nin tawtawoy Girasino. ");
INSERT INTO sbl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hin nakalombah hi Apo Hisos ha bangkà ay hinakbat ya nin mihay lalaki ya na-ibat ha kawkowibay panabonan. ");
INSERT INTO sbl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Habaytoy lalaki ay ampa-iri ha panabonan ta pinahokan ya nin mala-et ya ispirito. Maski tikalà ya pamalol kona nin tawtawo ay agla yayna makayan balolen. ");
INSERT INTO sbl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mabetbet la ya pon ambalolen nin tikalà boy amposasan nin pahak, piro angkaboytò nay tawtikalà boy angkawatak nay pahak ya an-iposas kona. Ayin makasopil kona banà ha kakhawan na. ");
INSERT INTO sbl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allo yabi ay antomalà ya ha tawtinabon boy ha bawbakil. Ampambo-angaw ya boy hay nawini na ay anhogathogaten na nin bawbato. ");
INSERT INTO sbl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hapa-eg, hin natamolawan na hi Apo Hisos ha marayò ay nowayo yan hinomakbat ta nanalimokod ya nin hinomamba koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hinalità ni Apo Hisos do ha mala-et ya ispirito ya pinomahok do ha tawo, “Hikay mala-et ya ispirito, mog-alih ka ha tawoy habayti,” wana. Hapa-eg, nambo-angaw baytoy lalaki boy hinalità na koni Apo Hisos, “Hisos ya Anak nin Diyos ya Pinakamakapangyariyan, antà ampaki-emenan mo ko? Alang-alang ha Diyos ay agmo ko pa-irapan.” ");
INSERT INTO sbl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hapa-eg, pinastang ya ni Apo Hisos, “Anyay ngalan mo?” wana. Tinombay baytoy mala-et ya ispirito, ya wana, “Hay ngalan ko ay ‘Kawan’ ta malakè kayi.” ");
INSERT INTO sbl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hapa-eg, ampaka-awok-awoken nin hatoy mala-et ya ispirito koni Apo Hisos ya agna hila dayi ipalako ha marayò ya dogal. ");
INSERT INTO sbl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ha marani bayro ay ma-in kawan baboy ya ampipamokibok ha pallig bakil. ");
INSERT INTO sbl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hapa-eg, ombayri ya impaki-i-ingalo nin hatoy mangala-et ya aw-ispirito koni Apo Hisos, “Palakwen mo kayi bahen ha bawbaboy ta pomahok kayi konla.” ");
INSERT INTO sbl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pinayagan hila itaman ni Apo Hisos. Hapa-eg hatoy mangala-et ya aw-ispirito ay nog-alih bayro ha lalaki, ta nako hilan pinomahok do ha mangalowan liboy baboy. Hatoy bawbaboy ya pinahokan nin mangala-et ya aw-ispirito ay nipampowayon nagpalako ha bongaw anggan nipadiritso hilan narabò ha dagat. Bayro hila nati nin nalemeh. ");
INSERT INTO sbl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hapa-eg hay ampipangalagà nin hatoy bawbaboy ay nipampowayo, ta habaytoy pangyayari ay imbabalità la ha tawtawo ha mangarani ya bawbaryo anggan banowa. Hin nalengè bayto nin tawtawo ay nako hilan namiliw nin habaytoy pangyayari. ");
INSERT INTO sbl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hin ni-abot hila bayro koni Apo Hisos ay nakit la baytoy tawo ya pinahokan pon nin kawan dimonyo. Hiya ay ampiknò ya nakadoloyna boy matinò ana ya pag-i-ihip na. Banà bayro ha nakit nin hatoy tawtawo ya pangyayari, hila ay nikalimo. ");
INSERT INTO sbl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hapa-eg, hatoy tawtawoy nipampakakit do ha ginawà ni Apo Hisos ay nangibabalità ha tawtawoy kapilateng nin tongkol ha nangyari do ha lalaki ya pinahokan nin dawdimonyo boy tongkol do ha bawbaboy. ");
INSERT INTO sbl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hay tawtawoy anti bayro ay naki-i-ingalo koni Apo Hisos nin mog-alih ya bayro ha dogal la. ");
INSERT INTO sbl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hapa-eg, hin anhomakay ana hi Apo Hisos ha bangkà, hatoy lalaki ya pinahokan pon nin dawdimonyo ay napakarani ta ampaki-i-ingalo nin makilako koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piro ahè pinomayag hi Apo Hisos no alwan hinalità na kona, “Morong ka komoyo,” wana, “ta ha pawpartidos mo boy ha aw-amigo mo ay ibalità mo no anyay ginawà komo nin Pangino-on boy no pangnoy pangingangalo na komo.” ");
INSERT INTO sbl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hapa-eg, hatoy lalaki ay nanigè anan nako ha probinsya ya an-ingaten Dikapolis ya hay labay totolen ay mapò ya banowa. Bayro na imbabalità ya ginawà kona ni Apo Hisos. Kaganawan tawo bayro ay nipag-ispanta. ");
INSERT INTO sbl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hapa-eg hili Apo Hisos ay hinomakay ana ha bangkà ta lomipay hila. Hin nakalipay hilayna, do ha ambay ay pini-o-opongan hi Apo Hisos nin malakè ya tawo. ");
INSERT INTO sbl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hapa-eg hi Hayro ya ampamo-on ha miha ha hawhimba-an nin Hawhodiyo ay nilomateng bayro. Nanlokob ya ha danin bitih ni Apo Hisos ");
INSERT INTO sbl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","biha ya naki-i-ingalo, ya wana, “Hay anak koy dalagita ay malagayna mati. Mako ka dayi bayro ta aptohen mo ya emen ya homampat.” ");
INSERT INTO sbl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hi Apo Hisos ay nakilako koni Hayro boy malakè et ya tawoy nakilako konla; kayà ampangapipepetpetan la hi Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hapa-eg, ma-in bayron mihay babayi ya ha lo-ob labinloway ta-on ay sigisigi ya pantolò dayà na ta ma-in yan dipirinsya. ");
INSERT INTO sbl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ha kaboyotan pamatambal na ay lalò yan angka-irapan boy kaganawan kamama-in na ay na-oboh naynan imbayad ha nipanambal kona. Agya hinomampat no alwan lalò ana ingat nilomalà ya angkatanam na. ");
INSERT INTO sbl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hin nalengè nin hatoy babayi ya tongkol koni Apo Hisos ay nakipaletpet ya bayro ha kalak-an tawo nin nako ha bokotan ni Apo Hisos, biha na inaptoh ya dolo ni Apo Hisos, ");
INSERT INTO sbl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ta wana ha sarili na, “Ma-aptoh kon bongat ya dolo na ay homampat ako.” ");
INSERT INTO sbl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hin na-aptoh nay dolo ni Apo Hisos ay tinonggen ya pantolò nin dayà na boy natanam na ha nawini na ya hinomampat yayna ha dipirinsya na. ");
INSERT INTO sbl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Antimano, natanda-an ni Apo Hisos ya ha kapangyariyan na ay ma-in hinomampat. Kayà nagpeyeh ya nin inomarap do ha kalak-an tawo biha ya nagpastang, “Hino,” wana, “ya nangaptoh nin dolo ko?” ");
INSERT INTO sbl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hinalità kona nin aw-alagad na, “Angkakit moy malakè ya tawoy ampakipaletpet komo; antà ampastangen mo no hinoy nangaptoh nin dolo mo?” ");
INSERT INTO sbl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piro hi Apo Hisos ay ampanegteg ha mamalibot na ta ambiliwen na no hinoy nangaptoh nin dolo na. ");
INSERT INTO sbl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tandà nin hatoy babayi ya nangyari kona hin inaptoh nay dolo ni Apo Hisos. Ha kalimowan na ay ampamegpeg yay napakarani koni Apo Hisos, boy nanlokob ya ha danin bitih ni Apo Hisos ta hinalità nay kaptegan. ");
INSERT INTO sbl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hapa-eg, hinalità ni Apo Hisos do ha babayi, ya wana, “Patel, hay pantotompel mo ya nakapakahampat komo. Morong kayna nin ma-in katinekan ta mahampat kayna.” ");
INSERT INTO sbl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mintras ampaghalità et hi Apo Hisos do ha babayi ay ma-in ongnoy tawoy nilomateng ya na-ibat ha bali ni Hayro. Hinalità la koni Hayro, “Hay Mangangaral,” wanla, “ay agmoyna abala-en nin palakwen bayro ta nati anay anak mo.” ");
INSERT INTO sbl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piro hatoy hinalità la ay ahè pinansin ni Apo Hisos, no alwan hinalità na koni Hayro, “Agka malimo,” wana, “basta tompel ka kongko.” ");
INSERT INTO sbl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hapa-eg hay kanayon ya tawo ay ahè pinayagan ni Apo Hisos nin makilako kona, no alwan hay pinakilako nan bongat ay hi Pidro, boy hatoy mipatel ya hi Santiyago boy hi Howan. ");
INSERT INTO sbl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hin ni-abot hila ha bali ni Hayro ay nakit ni Apo Hisos ya hay tawtawo bayro ay angkagolo. Ma-in ampipanangih boy ma-in ampi-a-anito. ");
INSERT INTO sbl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hin nakalo-ob hi Apo Hisos bayro ha bali ay hinalità na do ha tawtawo, “Antà,” wana, “nin angkagolo kawo boy ampanangih? Haba-in ya anak ay ahè nati no alwan angkatoloy yan bongat.” ");
INSERT INTO sbl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hin nalengè la baytoy hinalità ni Apo Hisos ay pinikaka-iliyan la ya. Hapa-eg kaganawan tawo ya anti bayro ay pinalikol ni Apo Hisos. Hay agnan bongat pinalikol ay tatay boy nanay nin hatoy anak kateng hatoy tatloy alagad na. Hila ya kalamo nan nilomo-ob do ha pinangiborolan nin hatoy anak. ");
INSERT INTO sbl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hapa-eg, inoligtanan ni Apo Hisos ya gamet nin hatoy anak biha na hinalità, “Talita komi,” wana, ya hay labay totolen ay, “Ninì, mibangon ka!” ");
INSERT INTO sbl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Antimano, nibangon baytoy anak biha ya nowako; habaytoy anak ay idad anan labinloway ta-on. Hay mawmato-antawo nin hatoy anak ay masyadon nag-ispanta. ");
INSERT INTO sbl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Inhigpit nin imbibilin konla ni Apo Hisos ya habaytoy pangyayari ay agla ibabalità ha maski hinoy tawo, boy hinalità et konla ni Apo Hisos ya biyan lan pamamangan baytoy anak. ");
INSERT INTO sbl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hapa-eg hi Apo Hisos ay nog-alih bayro ha dogal ya habayto ta norong ya ha Nasarit ya sarili nan banowa. Hay aw-alagad na ay nakilako kona. ");
INSERT INTO sbl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hin nilomateng ya allon pama-inawa, hi Apo Hisos ay nilomo-ob ha himba-an nin Hawhodiyo ta bayro ya nanorò. Hay malakè ya tawoy anti bayroy nakalengè kona ay nipag-ispanta, ya wanla, “Ayri nangibat ya pangingihip nay ombahen? Anyan karonongan ba-in ya inggawà kona? Pangno ya ampakagawà nin bawbagay ya pawpapag-ispantawan? ");
INSERT INTO sbl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Warì alwan hiya ya karpintiro ya anak ni Mariya boy hay pawpatel nay lalaki ay hi Santiyago, hi Hosi, hi Hodas, boy hi Simon? Warì alwan kateng pawpatel nay babayi ay anti bayri?” Habaytoy tawtawoy nipagpastang ay ahè nipananggap koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hapa-eg, hinalità konla ni Apo Hisos, “Hay propita ay an-igalang ha maski ayrin dogal, piro ahè an-igalang ha sarili nan banowa, boy agya an-igalang nin sarili nan partidos boy sarili nan pamilya.” ");
INSERT INTO sbl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kayà hi Apo Hisos ay ahè nakagawà bayro nin pawpapag-ispantawan ha sarili nan dogal, no alwan hay gamet na ay impababo na ha ongnoy tawoy ampagmasakit ta pinakahampat na hila. ");
INSERT INTO sbl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hay ispanta ni Apo Hisos ta hay tawtawo ha dogal ya habayto ay ayin katetpel. Hili Apo Hisos ay nako ha bawbaryo nin nangi-aral Halità nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hapa-eg, iningat ni Apo Hisos nin pakarani kona baytoy labinloway alagad na ta inhogò na hila nin manilowalowa, boy binyan na hilan kapangyariyan nin mama-alih nin mangala-et ya aw-ispirito ya pinomahok ha tawo. ");
INSERT INTO sbl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Immanda na konla ya ha pamowako la ay baston bongat ya gitan la. Aghila mantan pamamangan ni sopot o kowalta. ");
INSERT INTO sbl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pinayagan na hilan magsapatos, piro agna hila ampagtanen nin doloy paghagiliyan la. ");
INSERT INTO sbl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hinalità et konla ni Apo Hisos, “Makihandà kawo ha hinoman ya ma-in bali ya mananggap komoyo, boy manatili kawo bayro angga ha mog-alih kawo ha dogal ya habayto. ");
INSERT INTO sbl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No ma-in kawon malakoy dogal ya agla kawo tanggapen o agla kawo leng-en ha an-i-aral moyo ay mog-alih kawo bayro. Piro biha kawo mog-alih ay ikampag moyoy gabok ha bitih moyo emen moyo ma-ipakit ya hay Diyos ay ma-in pahang konla banà ha agla pananggap komoyo.” ");
INSERT INTO sbl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hapa-eg, nanigè ana baytoy aw-alagad ni Apo Hisos. An-i-aral la ha tawtawo ya dapat lan paghehean ya kawkasalanan la. ");
INSERT INTO sbl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Malakè ya dimonyoy pinomahok ha tawtawo ya pina-alih la, boy malakè ya tawoy ampipagmasakit ya pinonahan lan asiti boy pinakahampat la. ");
INSERT INTO sbl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hi Apo Hisos ay nibantog nin banà ha gawgawà na. Kayà nalengè ni Arì Hirodis ya hinalità nin tawtawo ya tongkol koni Apo Hisos. Ma-in ongnoy tawo ya naghalità nin, “Hiya hi Howan Mamiminyag ya nabiyay oman. Kayà ampakagawà ya nin habayti ya pawpapag-ispantawan.” ");
INSERT INTO sbl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piro hinalità nin kanayon, “Hiya hi Ilyas ya propita hin hato.” Hay hinalità itaman nin kanayon, “Hiya ay propita ya bilang ha pawpropita nin Diyos hin hato.” ");
INSERT INTO sbl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piro hin nalengè ni Arì Hirodis baytoy tongkol koni Apo Hisos ay hinalità na, “Hiya,” wana, “hi Howan Mamiminyag ya impapotohan kon olo ya nabiyay oman.” ");
INSERT INTO sbl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hay pangyayari no antà impapati hin hato ni Arì Hirodis hi Howan ay ombayri: inayo ni Arì Hirodis nin pinag-ahawa hi Hirodiyas ya ahawa nin patel na ya hi Pilipi. Hapa-eg, hinalità ni Howan Mamiminyag koni Arì Hirodis, “Alwan tamà,” wana, “ya ginawà mo ya pinag-ahawa moy ayro mo.” Banà bayro, hi Howan ay imparakep ni Arì Hirodis ta impapiriso na ya. ");
INSERT INTO sbl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hi Hirodiyas itaman ay nagkama-in nin irap nakem koni Howan; kayà labay na yan patyen. Piro agya pinayagan ni Arì Hirodis. ");
INSERT INTO sbl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hi Howan ay an-igalang ni Arì Hirodis, ta tandà na ya hi Howan ay mahampat ya tawoy anhomonol ha Diyos; kayà indipinsa na ya. Hay tawtorò ni Howan ay nalabayan ni Arì Hirodis nin leng-en maski habayto ay ampakagolo nin nakem na. ");
INSERT INTO sbl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hin na-abot ya allon impanganak ni Arì Hirodis ay namapahandà ya nin pamamangan ya para ha kaganawan kombidado nay mangatag-ay ya katongkolan, pawpo-on hondalò, kateng aw-importantin tawo ha probinsyan Galiliya. Hapa-eg hi Hirodiyas ay nagkama-in paraan nin ma-ipapati na hi Howan ");
INSERT INTO sbl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","hin tinomalek bayro ya anak nay dalaga. Hay talek nin habaytoy dalaga ya anak ni Hirodiyas ay nakapakonsowilo koni Arì Hirodis kateng do ha kawkombidado na. Kayà hinalità ni Arì Hirodis do ha dalaga, “Maski anya,” wana, “ya awoken mo kongko ay igwà ko komo.” ");
INSERT INTO sbl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naghompà yan nagpangakò do ha dalagay tinomalek, ya wana, “Anyaman ya awoken mo kongko, maski kagitnà nin kamama-in ko ay igwà ko komo.” ");
INSERT INTO sbl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hapa-eg, nilomikol baytoy dalaga ta pinastang nay nanay na, “Nanay,” wana, “anyay labay mon awoken ko?” Tinombay baytoy nanay na. “Hay awoken mo,” wana, “ay olo ni Howan Mamiminyag.” ");
INSERT INTO sbl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hapa-eg hatoy dalaga ay nanandalì nagbira koni Arì Hirodis ta hinalità na kona, “Hay an-awoken ko,” wana, “nin igwà mo kongko hapa-eg et ay olo ni Howan Mamiminyag. Hay olo na ay igwà ha bandihado biha igwà kongko.” ");
INSERT INTO sbl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hapa-eg, hi Arì Hirodis ay masyadon nilomelè nin banà bayro ha inawok kona, piro banà ta naghompà yan nagpangakò do ha dalaga ya nalengè nin kawkombidado na ay agya napa-agko. ");
INSERT INTO sbl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kayà antimano, nangihogò ya nin mihay hondalò na nin mako ha pirisowan nin mamoton olo ni Howan Mamiminyag. Habaytoy hondalò ay nakoyna. Hapa-eg, pinotoh nay olo ni Howan Mamiminyag, ");
INSERT INTO sbl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","biha na inggawà ha bandihado ta gintan na do ha dalaga. Hay ginawà itaman nin hatoy dalaga ay inggawà na ha nanay na. ");
INSERT INTO sbl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hin nabalita-an bayto nin aw-alagad ni Howan ay nilako lan kinwa ya bangkay ni Howan ta intabon la. ");
INSERT INTO sbl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hapa-eg hatoy aw-alagad ni Apo Hisos ay nipagbira kona ta kaganawan ginawà la boy intorò la ay imbalità la koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hinalità konla ni Apo Hisos, “Mako tamo,” wana, “nin pa-ipapawà ha powiray dogal emen tamo makapa-inawan amò.” Hinalità bayto ni Apo Hisos banà ta malakè ya tawoy ampako konla; banà bayro aglayna angka-arap ya pamangan la. ");
INSERT INTO sbl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hapa-eg, hinomakay hila ha bangkà nin magpalako ha powiray dogal. ");
INSERT INTO sbl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Malakè ya nakakit nin pamog-alih nili Apo Hisos boy nabalayan hila. Kayà ha balang banowa bayro ay malakè ya tawoy nipampowayo nin na-onan nako ha dogal ya lalakwen nili Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hin nakalombah hi Apo Hisos ha bangkà ay nakit na baytoy malakè ya tawoy nititipon bayro. Na-ingalowan na baytoy tawtawo ta bilang hila nin tawtopa ya ayin ampagpastol. Banà bayro ay malakè ya bagay ya intorò na konla. ");
INSERT INTO sbl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lomateng ya mahilem, hi Apo Hisos ay pinakaraniyan nin aw-alagad na ta hinalità la kona, ya wanla, “Habayti ay powiray dogal boy mahilem ana. ");
INSERT INTO sbl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Halita-en mo ha tawtawo ya mog-alih hilayna emen hila makalako ha bawbaryoy mangarani bayri nin manaliw pamamangan la.” ");
INSERT INTO sbl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piro tinombay konla hi Apo Hisos, “Hikawo,” wana, “ya mambi konla nin pamamangan.” Hinalità la koni Apo Hisos, ya wanla, “Ha kalak-an nin habayti ya tawo, hay ka-ilangan ya kantidad nin panaliw ipakan konla ay alagà waloy bowan ya sowildo nin miha katawo. Labay mo nayì nin mako kayin maggastos nin ombayro kalakè ya panaliw tinapay para ipakan konla?” ");
INSERT INTO sbl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pinastang hila ni Apo Hisos, “Ongnoy tinapay ya anti bahen? Helken moyo,” wana. Hin nakit la no ongno ay hinalità la koni Apo Hisos, “Limay tinapay,” wanla, “boy loway ikan.” ");
INSERT INTO sbl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hapa-eg, hinalità ni Apo Hisos ha aw-alagad na ya pa-ikno-en la baytoy kaganawan tawo nin gropogropo ha dawdikot. ");
INSERT INTO sbl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hin naka-iknò hila ay ma-in gawgropo ya manimagato katawo boy ma-in gawgropo ya manilimampò katawo. ");
INSERT INTO sbl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hapa-eg hatoy limay tinapay boy loway ikan ay kinwa ni Apo Hisos biha ya naninglà, ta habayto ay pinasalamatan na ha Diyos. Hin nayarì ay binibi-hil na baytoy tinapay biha na inggawà ha aw-alagad na ta hila ya nangitayak ha tawtawo. Ombayro et ya ginawà na do ha loway ikan. ");
INSERT INTO sbl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hilay kaganawan ay nangan nin habayto boy nikabhoy. ");
INSERT INTO sbl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hapa-eg hay aw-alagad ay nakatipon et nin natilà ya bawbi-hil nin hatoy tinapay boy ikan ya nakapnò et nin labinloway bakol. ");
INSERT INTO sbl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hay lawlalaki ya nipampangan bayro ay liman libo. ");
INSERT INTO sbl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hapa-eg, pinahakay ni Apo Hisos ya aw-alagad na ha bangkà, ta pina-ona na hilan lomipay ha kagmang nin mako ha banowan Bitsayda. Hiya itaman ay nagkabalag ta ampa-orongen na baytoy tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hin naka-alih ana baytoy tawtawo, hi Apo Hisos ay nilomakat ha bakil ta bayro ya nanalangin. ");
INSERT INTO sbl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hin yabi ana, hay bangkà ya anhakyan nin aw-alagad na ay ni-abot ana ha botlay dagat ya anlipayan la. Hi Apo Hisos balè ya nagsolo ay anti et bayro ha bakil. ");
INSERT INTO sbl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Angkatamolawan na ya hay aw-alagad na ay angka-irapan magsagwan ta angkahalongà lay angin. Hin manga-alas kowatroyna nin palbangon hi Apo Hisos ay ampowako ha babon lanom nin anhomono konla. Hin marani yayna konla ay libahan na hila dayi. ");
INSERT INTO sbl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Piro hin nakit nin aw-alagad ya ma-in ampowako ha babon lanom ay nambo-angaw hila ta andap la no molto. ");
INSERT INTO sbl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hilay kaganawan ay nalimo bayro ha nakit la. Kayà antimano, nag-ilgo hi Apo Hisos, ya wana, “Agkawo malimo ta hiko bayti.” ");
INSERT INTO sbl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hapa-eg hi Apo Hisos ay hinomapat do ha bangkà ya anhakyan la boy nagkalma ya angin. Masyadon pinag-ispantawan hi Apo Hisos nin aw-alagad na, ");
INSERT INTO sbl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ta maski nakit lay ginawà ni Apo Hisos do ha tinapay ay agla na-intindiyan no hino hi Apo Hisos banà ha katya-an nin nakem la. ");
INSERT INTO sbl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hapa-eg, hin nakalipay ana hili Apo Hisos bayro ha banowan Hinisarit ay impondo lay bangkà la. ");
INSERT INTO sbl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hin nakalombah hila ha bangkà, antimano, hi Apo Hisos ay nabalayan nin tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Habaytoy tawtawo ay nipampowayon nilibot baytoy intiron dogal, ta hay mangama-in masakit ay anhapwaten lan gitan koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maski ayri ya nakon bawbanowa, bawbaryo, o ha maski ayrin dogal ya ma-in bali, hay mangama-in masakit ay inggawà la ha plasa, biha la impaki-i-ingalo koni Apo Hisos ya maski laylay dolo na ay ma-aptoh nin hatoy ampipagmasakit. Kaganawan hatoy ampipagmasakit ya naka-aptoh nin laylay dolo ni Apo Hisos ay hinomampat. ");
INSERT INTO sbl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hapa-eg hay Pawparisiyoy na-ibat ha siyodad nin Hirosalim kalamo ya ongnoy mangitorò nin kawkapanogo-an ay nako koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakit la ya hay ongno ha aw-alagad ni Apo Hisos ay nangan nin ahè nag-ibano kompormi ha ka-ogali-an nin Hawhodiyo. ");
INSERT INTO sbl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hay Hawhodiyo lalo-lalò anay Pawparisiyo ay ahè mangan anggan agla pon honolen baytoy ka-ogali-an ya na-iknawan la ha kawka-apo-apowan la ya tongkol ha pag-ibano. ");
INSERT INTO sbl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No kapi-ibat la ha palingki ay aghila pon mangan anggan agla malinisan ya nawini la. Malakè et ya anggaw-en lay kawka-ogali-an ya na-iknawan la ya tongkol ha pangongoyah nin pawpaminoman la, kawkeren la, boy kanayon et ya kawkahangkapan ya tangsò. ");
INSERT INTO sbl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Banà bayri, hi Apo Hisos ay pinastang nin hatoy Pawparisiyo boy mawmangitorò nin kawkapanogo-an nin ombayri: “Antà nin hay aw-alagad mo,” wanla, “ay ahè anhomonol ha kawka-ogali-an ya na-iknawan ha kawka-apo-apowan tamo, ta ampangan hila nin ahè ampag-ibano kompormi ha kawka-ogali-an tamo?”. ");
INSERT INTO sbl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tinombay konla hi Apo Hisos, ya wana, “Tamà baytoy holà ni propita Isayas hin hato ya tongkol komoyon mawmagkakanwarì ya ombayri ya nakaholat: ‘Habayti ya tawtawo, wanan Diyos ay ampaghalità nin an-igalang la ko; piro marayò ya nakem la kongko. ");
INSERT INTO sbl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ayin kowinta ya panhomamba la kongko, ta hay an-itorò lay pawpanogò nin tawtawo ay anhalita-en la nin habayto ay pawpanogò ko.’” ");
INSERT INTO sbl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Hay panogò nin Diyos,” wani Apo Hisos, “ay pina-olayan moyo, ta hay bawbagay ya anhonolen moyo ay hatoy kawka-ogali-an ya na-iknawan moyo.” ");
INSERT INTO sbl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Naghalità ana et hi Apo Hisos, ya wana, “Talagan hay galing moyon magparaan emen moyo mapa-olayan ya pawpanogò nin Diyos. Anggaw-en moyo baytoy ombayro emen moyo mahonol ya kawka-ogali-an ya na-iknawan moyo. ");
INSERT INTO sbl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hay inggawà komoyo ni Moysis ay panogò nin Diyos ya ombayri: ‘Igalang moy tatay mo boy nanay mo,’ boy ombayri et: ‘Hinoman ya maghalità nin mala-et ha tatay na o ha nanay na ay dapat patyen.’ ");
INSERT INTO sbl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piro an-itorò moyo ya no ma-in tawoy ma-in itambay ha tatay na o ha nanay na ta halita-en nay ‘Korban,’ ya hay labay totolen ay inggawà ha Diyos ");
INSERT INTO sbl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ay agmoyo yayna ampayagan nin manambay ha tatay na o ha nanay na. ");
INSERT INTO sbl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Banà bayro ha antowaren moyoy kawka-ogali-an ya na-iknawan moyo ay an-ipakit moyo ya ayin alagà komoyo ya kawkapanogo-an nin Diyos. Malakè et ya bagay ya bilang ombayro ya anggaw-en moyo.” ");
INSERT INTO sbl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hapa-eg, iningat oman ni Apo Hisos ya tawtawo nin pakarani kona ta hinalità na konla, “Kaganawan moyo,” wana, “ay manlengè boy intindiyen bayti ya halita-en ko: ");
INSERT INTO sbl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","hay ampakapakasalanan ha tawo ay alwan pamamangan ya an-ihobò na, no alwan hay ampakapakasalanan kona ay hatoy anhalita-en na. ");
INSERT INTO sbl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hay ka-ilangan moyon gaw-en ay manlengè mahampat nin habayti ya anhalita-en ko komoyo biha moyo honolen.” ");
INSERT INTO sbl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hapa-eg, hin nog-alih hi Apo Hisos do ha tawtawo ta nilomo-ob ya ha bali ay pinastang ya nin aw-alagad na no anyay labay totolen nin hatoy hinalità nay alimbawà ya tongkol ha ampakapakasalanan. ");
INSERT INTO sbl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hinalità konla ni Apo Hisos, “Warì kateng hikawo,” wana, “ay ahè ampaka-intindi? Hay pamamangan ya inhobò nin tawo ay alwan habaytoy ampakapakasalanan kona, ");
INSERT INTO sbl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ta hay inhobò na ay ahè ampipahok ha nakem na no alwan ampagdiritso ha tiyan na, biha mipalwa nin ma-alih kona.” (Hay labay totolen nin habayti ya hinalità ni Apo Hisos ay an-ipayag nan kanen ya maski anyay pamamangan.) ");
INSERT INTO sbl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hinalità et ni Apo Hisos, “Hay ampakapakasalanan ha tawo,” wana, “ay hatoy ampangibat ha nakem na, ");
INSERT INTO sbl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ta ha nakem ampangibat ya kala-etan ihip, pamaki-ahawa ha maski hino, panakaw, pamatin tawo, pamabayi boy pamakilalaki, ");
INSERT INTO sbl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","panibà, panggawà nin kala-etan, pana-ol, panggawà nin ka-alayan, inggit, panggawà ikahirà nin kanayon, pagmalhay, boy katorpiyan. ");
INSERT INTO sbl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaganawan habayti ya mala-et ya gawgawà ya ampakapakasalanan nin tawo ay ampangibat ha nakem na.” ");
INSERT INTO sbl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hapa-eg hi Apo Hisos ay nog-alih ta nako ya ha mihay dogal ya marani ha banowan Tiro boy banowan Sidon. Hiya ay nakihandà ha mihay bali bayro. Agna dayi labay nin hay tawtawo bayro ay makatandà nin anti ya bayro, piro natanda-an simpri. ");
INSERT INTO sbl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bayro ay ma-in mihay babayi ya ma-in anak ya dalagita ya pinahokan nin mala-et ya ispirito. Hin nalengè nin hatoy babayi ya anti bayro hi Apo Hisos ay nako yan nanlokob ha danin bitih ni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Naki-i-ingalo ya koni Apo Hisos nin pakahampaten baytoy anak nay pinahokan nin dimonyo. Habaytoy babayi ay alwan Hodiyo boy hiya ay in-anak ha dogal ya an-ingaten Pinisya ya sakop nin probinsyan Sirya. ");
INSERT INTO sbl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hapa-eg, ombayri ya alimbawà ya hinalità kona ni Apo Hisos, “Hay pamamangan,” wana, “ya para ha aw-anak ay dapat ipakan konla. Ahè kowen nin itapon ha aw-aho.” ");
INSERT INTO sbl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ombayri itaman ya intobay nin hatoy babayi, “Peteg bayto, Pangino-on,” wana, “piro hay aw-aho ay ampangan nin mawmomo ya angkatata nin aw-anak ha hilong nin lamisa.” ");
INSERT INTO sbl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hinalità kona ni Apo Hisos, “Banà bahen ha hinalità mo,” wana, “ay morong kayna ta hay dimonyo ay nog-alih ana ha anak mo.” ");
INSERT INTO sbl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hin ni-abot baytoy babayi do ha bali na ay nakit nay anak nay naka-irà boy hay dimonyo ay ayin ana kona. ");
INSERT INTO sbl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hapa-eg hin nog-alih hi Apo Hisos bayro ha dogal ya sakop nin banowan Tiro ay nagdaan ya ha banowan Sidon boy ha probinsyan Dikapolis biha ya nako ha ambay Dagat nin Galiliya. ");
INSERT INTO sbl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bayro ay ma-in ongnoy tawoy nantan koni Apo Hisos nin mihay lalaki ya teek boy alwan malinaw ya pag-ilgo. Impaki-i-ingalo la koni Apo Hisos ya pababowan nan gamet na baytoy tawo ya ma-in dipirinsya emen homampat. ");
INSERT INTO sbl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Habaytoy lalaki ay impa-alilih ni Apo Hisos do ha kalak-an tawo biha na impahok ya tamorò na ha tolih nin hatoy tawo. Nilawayan na et ya tamorò na biha na in-aptoh ha dilà nin hatoy tawo. ");
INSERT INTO sbl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hapa-eg, naninglà hi Apo Hisos boy nanginanawa nin malawig, biha na hinalità do ha lalaki, “Ipata.” Hay labay totolen nin “ipata” ay “Makalengè ka!” ");
INSERT INTO sbl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Antimano, hatoy lalaki ay nakalengè ana boy na-alih ya dipirinsya nin dilà na. Kayà malinaw anay pag-ilgo na. ");
INSERT INTO sbl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hapa-eg, hinalità ni Apo Hisos do ha tawtawo ya agla ibabalità ha maski hino baytoy nakit lay pangyayari. Piro mintras binawalan na hila ay lalò layna ingat imbabalità baytoy nakit la. ");
INSERT INTO sbl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaganawan hatoy nakalengè ay nipag-ispanta boy hinalità la, ya wanla, “Anyaynay hampat nin kaganawan anggaw-en na! Angkagawà nan makalengè ya teek boy angkapa-ilgo nay ahè ampakapaghalità!” ");
INSERT INTO sbl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hin nalabah ya ongnoy allo ay malakè ya tawoy nakitipon oman koni Apo Hisos. Hin ayin hilaynan ma-ekan ay iningat ni Apo Hisos ya aw-alagad na ta hinalità na konla, ya wana, ");
INSERT INTO sbl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Angka-ingalowan ko bayti ya kalak-an tawo ta tatloy allo layna bayri kontamo boy ayin hilaynan ma-ekan hapa-eg. ");
INSERT INTO sbl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No pa-orongen ko hila nin mabitil ay ma-olaw hila ha daan, ta hay kanayon konla ay marayò ya orongen.” ");
INSERT INTO sbl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tinombay baytoy aw-alagad na, ya wanla, “Habayti ay powiray dogal. Ayri tamo mangwan pamamangan ya magkasya nin ipakan bayri ha kalak-an tawo?” ");
INSERT INTO sbl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pinastang hila ni Apo Hisos, “Ongnoy tinapay ya ma-in komoyo?” wana. “Pito,” wanla. ");
INSERT INTO sbl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hapa-eg hatoy kalak-an tawo ay minandawan ni Apo Hisos nin miknò ha lotà. Hin naka-iknò hilayna, hatoy pitoy tinapay ay kinwa ni Apo Hisos ta pinasalamatan na ha Diyos biha na binibi-hil. Habayto ay inggawà na ha aw-alagad na nin ipatpel ha tawtawo. Ginawà itaman bayto nin aw-alagad. ");
INSERT INTO sbl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma-in hila simprin ongnoy ikan ya mangayamò. Pinasalamatan bayto ni Apo Hisos biha na immanda ha aw-alagad na ya ipatpel bayto ha tawtawo. ");
INSERT INTO sbl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hatoy tawtawoy nipampangan ay nikabhoy boy nakatipon et ya aw-alagad nin natilà ya bawbi-hil ya nakapnò et nin pitoy bakol. ");
INSERT INTO sbl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hay nipampangan ay manga-apat ya libo katawo. Hin pina-orong ana ni Apo Hisos baytoy tawtawo, ");
INSERT INTO sbl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","hiya boy aw-alagad na ay hinomakay ha bangkà nin nagpalako ha dogal ya an-ingaten Dalmanota. ");
INSERT INTO sbl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hapa-eg hin ni-abot hilayna, hay Pawparisiyo ay nako bayro nin mandiskosyon koni Apo Hisos. Ampagaw-en la ya nin papag-ispantawan ya mamapteg nin hiya ay inhogò nin Diyos. Ombayroy an-ipagawà la kona ta anhoboken la ya. ");
INSERT INTO sbl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Banà bayro, hi Apo Hisos ay nanginanawan malawig biha na hinalità konla, ya wana, “Antà hay tawtawo hapa-eg pana-on ay ampamagawà nin papag-ispantawan? Anhalita-en ko komoyoy kaptegan: agkatawo pakitan nin papag-ispantawan.” ");
INSERT INTO sbl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hapa-eg hi Apo Hisos kateng aw-alagad na ay nog-alih bayro ha tawtawo. Hinomakay hilan oman ha bangkà ta nilomipay hila. ");
INSERT INTO sbl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliwawan nin aw-alagad ni Apo Hisos nin magbawon tinapay. Hay tinapay ya anti ha bangkà la ay mimiha. ");
INSERT INTO sbl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hapa-eg, hinalità konla ni Apo Hisos, ya wana, “Pag-atapan moyo ya pampalbag nin Pawparisiyo boy ni Arì Hirodis.” ");
INSERT INTO sbl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ha ombayroy hinalità ni Apo Hisos ay andap nin aw-alagad no talagan pampalbag tinapay ya labay totolen ni Apo Hisos. Kayà ni-i-ilgo hila, ya wanla, “Hinalità na bayto ta agtamo nagbawon tinapay.” ");
INSERT INTO sbl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Piro tandà ni Apo Hisos no anyay ampi-i-ilgowan nin aw-alagad na; kayà pinastang na hila, ya wana, “Antà ampididiskosyonan moyo ya agmoyo pantan tinapay? Warì ayin kawon pangingintindi? Warì talagan matyà anay nakem moyo? ");
INSERT INTO sbl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma-in kawon mata; warì agkawo ampakakit? Ma-in kawon tolih; warì agkawo ampakalengè? Naliwawan moyoyna nayì ");
INSERT INTO sbl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","hin binibi-hil ko baytoy limay tinapay ya impakan ko ha liman libo katawo? Ongnoy bakol ya napnò nin natipon moyoy tilà ya bawbi-hil?” “Labinloway bakol,” wanla. ");
INSERT INTO sbl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hinalità et ni Apo Hisos, ya wana, “Hin binibi-hil ko bayto ya pitoy tinapay ya impakan ko ha apat ya libo katawo, ongnoy bakol ya napnò nin natipon moyoy tilà ya bawbi-hil?” “Pitoy bakol,” wanla. ");
INSERT INTO sbl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hinalità ni Apo Hisos, “Agmoyo et nayì angka-intindiyan?” ");
INSERT INTO sbl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hapa-eg hili Apo Hisos ay nilomateng ha banowan Bitsayda. Bayro ay ma-in mihay lalaki ya bowag ya gintan koni Apo Hisos. An-ipaki-i-ingalo la koni Apo Hisos ya aptohen na baytoy bowag emen makakit. ");
INSERT INTO sbl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hapa-eg hatoy bowag ay inakay ni Apo Hisos nin inlikol ha banowa. Nandolà hi Apo Hisos ta habaytoy dolà ay inggawà na ha mata nin hatoy bowag biha na ya pinastang, ya wana, “Ampakakit kayna nayì?” ");
INSERT INTO sbl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hin nanegteg ya ay hinalità na, ya wana, “Ampakakit akoyna nin tawtawo ya emen pawpo-on kayo piro ampowako.” ");
INSERT INTO sbl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inapton oman ni Apo Hisos ya mata nin hatoy bowag. Hapa-eg, malinaw anay tegteg na ta angkakit naynay kaganawan. ");
INSERT INTO sbl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pina-orong ya ni Apo Hisos boy imbibilin na kona, ya wana, “Agkayna magbira ha banowa.” ");
INSERT INTO sbl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hapa-eg hi Apo Hisos kateng aw-alagad na ay nagpalako ha bawbaryo ya mamalibot banowan Sisarya Pilipo. Peleg la ha daan, hi Apo Hisos ay nagpastang ha aw-alagad na, ya wana, “Anyay anhalita-en nin tawtawo? An-ihipen la warì no hino ko?” ");
INSERT INTO sbl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tinombay hila kona, “Hay kanayon,” wanla, “ay ampaghalità nin hika ay hi Howan Mamiminyag. Hay kanayon ay ampaghalità nin hika ay hi propita Ilyas. Hay kanayon itaman ay ampaghalità nin hika ay miha ha pawpropita.” ");
INSERT INTO sbl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pinastang na hila, “Hapa hikawo,” wana, “an-ihipen moyo nayì no hino ko?” Tinombay hi Pidro, “Hika,” wana, “hi Kristo ya impangakò nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hapa-eg, hinalità konla ni Apo Hisos ya habayto ay agla ibabalità ha maski hino. ");
INSERT INTO sbl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hapa-eg, inompisawan ni Apo Hisos nin intorò ha aw-alagad na ya hiya ya an-ingaten Anak nin Tawo ay ka-ilangan magdanas nin masyadoy kadya-dya-an, boy ahè tanggapen nin mawmato-ay mangama-in katongkolan, pawpo-on nin pawparì, boy mawmangitorò nin kawkapanogo-an. Hinalità et konla ni Apo Hisos ya hiya ay patyen, piro lomateng ya ikatlon allo ay mabiyay yan oman. ");
INSERT INTO sbl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hay mangyari kona ay impakapapalinaw na ha aw-alagad na. Banà bayro ha hinalità ni Apo Hisos ay impa-alilih ya ni Pidro ta hina-ad na ya. ");
INSERT INTO sbl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hapa-eg, inarap ni Apo Hisos ya aw-alagad na biha na pinagtotolan hi Pidro, ya wana, “Pakarayò ka kongko, Satanas! Hay ka-ihipan mo ay ka-ihipan nin tawo, alwan ka-ihipan ya nangibat ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hapa-eg, iningat ni Apo Hisos ya kalak-an tawo kateng aw-alagad na ta hinalità na konla, “Hinoman ya labay makilamo kongko,” wana, “ay agna honolen ya sarili nan kalabayan, no alwan te-ehen nay kadya-dya-an nin bilang ampamalatay koroh nin magpalako ha kamatyan na ta makilamo ya kongko. ");
INSERT INTO sbl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hinoman ya tawoy ampag-atap nin ahè mati ay mati et bongat, piro hinoman ya tawoy mati nin banà kongko boy banà ha Mahampat ya Balità ay malibri ta ma-in yan biyay ya ayin anggawan. ");
INSERT INTO sbl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Warì ma-in mapakinabang ya tawoy makapag-ikon nin kaganawan kayamanan bayri ha babon lotà no hay kalolowa na ay mipalako ha impirno? ");
INSERT INTO sbl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","No anti yayna ha impirno, ma-in ya warì ma-ipambeh nin sarili na emen ya magkama-in biyay ya ayin anggawan? ");
INSERT INTO sbl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hinoman ya ampangikareng-ey kongko boy ha hawhalità ko hapa-eg ha pana-on nin malakè ya tawoy mangala-et boy ahè ampangigalang nin Diyos, hiko ya an-ingaten Anak nin Tawo ay mangikareng-ey itaman kona pagbira ko bayri nin kalamo ko ya aw-anghil nin Diyos. Pagbira ko bayri ay ma-in akon kagandawan ya ahè makwan ihipen ya bilang kagandawan nin Tatay koy Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hapa-eg, insigi ni Apo Hisos ya paghalità na, ya wana, “Anhalita-en ko komoyo ya kaptegan, ma-in ongno bayri komoyo ya ahè mati anggan agla makit ya kapangyariyan nin pamomo-on nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nalabah ya anem ya allo, hi Pidro, hi Santiyago, boy hi Howan ay gintan ni Apo Hisos ha tag-ay bakil. Hilahilan bongat ya anti bayro. Hapa-eg, nakit la ya hay itsora ni Apo Hisos ay na-oman. ");
INSERT INTO sbl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hay dolo na ay pagkapopotì ya ampangilimkilim. Ha kapoti-an ay ayin mapangiparisan bayri ha babon lotà. ");
INSERT INTO sbl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hapa-eg, nakit nin hatoy tatloy alagad hi Ilyas ya propita hin hato kateng hi Moysis ya ampaki-ilgo koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hinalità ni Pidro koni Apo Hisos, “Apo,” wana, “mahampat ya anti tamo bayri. Manggawà kayi nin tatloy pa-ihilongan, hay miha ay para komo, hay miha ay para koni Moysis, boy hay miha ay para koni Ilyas.” ");
INSERT INTO sbl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ha kalimowan la ay ayin ha nakem ni Pidro ya anhahalita-en na. ");
INSERT INTO sbl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hapa-eg hilay kaganawan ay na-ameyan nin leem boy ma-in hilan nalengè ya bosis bayro ha leem ya ombayri ya hinalità: “Habayti ya mimihay Anak ko ya pinakalabilabi ko; hiya ya honolen moyo!” ");
INSERT INTO sbl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Antimano, hatoy tatloy alagad ay nanlek ha mamalibot la, piro ayin hilan nakit ya kanayon no alwan hi Apo Hisos tana. ");
INSERT INTO sbl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Peleg anlomohan hili Apo Hisos ha bakil ay binibilinan na baytoy tatloy alagad na ya hatoy nakit la ay agla ibabalità ha maski hino anggan hiya ya an-ingaten Anak nin Tawo ay mati biha mabiyay oman. ");
INSERT INTO sbl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hinonol la baytoy bibilin konla ni Apo Hisos, piro ampi-i-ilgowan la no anyay labay totolen nin hatoy hinalità na ya tongkol ha pangabiyay oman. ");
INSERT INTO sbl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hapa-eg, pinastang nin hatoy tatloy alagad hi Apo Hisos, ya wanla, “Antà nin anhalita-en nin mawmangitorò nin kawkapanogo-an ya hay ma-onan lomateng ay hi Ilyas ya propita hin hato?” ");
INSERT INTO sbl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tinombay konla hi Apo Hisos, “Peteg,” wana, “nin ma-in pon lomateng ya emen koni Ilyas ta ihandà nay kaganawan bagay. Piro nakaholat itaman ya hinalità nin Diyos ya tongkol kongko ya hiko ya an-ingaten Anak nin Tawo ay magdanas nin masyadoy kawkadya-dya-an boy agla tanggapen. ");
INSERT INTO sbl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ombayro man ay anhalita-en ko komoyo ya hatoy tawo ya emen koni Ilyas ay nakalateng ana. Ginawà lay balang labay lan gaw-en kona bilang ombayro ha impaholat nin Diyos ya labay lan gaw-en koni Ilyas.” ");
INSERT INTO sbl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hin anlomateng hi Apo Hisos kateng hatoy tatloy alagad na do ha kama-inan nin hatoy kanayon ya aw-alagad ay nakit lay aw-alagad na ya napalibotan nin tawtawo, boy ma-in ongnoy mawmangitorò nin kawkapanogo-an ya ampandiskosyon bayro ha aw-alagad. ");
INSERT INTO sbl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hin nakit nin tawtawo ya anlomateng hi Apo Hisos ay nag-ispanta hila. Habaytoy tawtawo ay nipampowayon hinomakbat nin nangilaw koni Apo Hisos. ");
INSERT INTO sbl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pinastang ni Apo Hisos baytoy aw-alagad na, “Anya,” wana, “ya ampakidiskosyonan moyo bahen ha mawmangitorò nin kawkapanogo-an?” ");
INSERT INTO sbl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mihay lalaki ya anti bayro ha kalak-an tawo ay tinombay, ya wana, “Apo, hay anak koy lalaki ay gintan ko bayri ta agya makapag-ilgo, gawà nin mala-et ya ispirito ya pinomahok kona. ");
INSERT INTO sbl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maski ayri ya sompongan ay angkatomba ya, ampagbola-bolà ya bebey na, ampangayeget ya, boy ampamakdey. Impaki-ilgo ko ha aw-alagad mo ya pa-alihen la baytoy pinomahok kona, piro agla kayan pa-alihen.” ");
INSERT INTO sbl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hapa-eg, hinalità ni Apo Hisos, “Hikawo ya tawtawo hapa-eg,” wana, “talagan ayin kawon katetpel ha Diyos. Anggan makano ko dapat manatili nin kalamo moyo? Anggan makano katawo pagte-ehan? Gitan bayri kongko ba-in ya anak.” ");
INSERT INTO sbl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hapa-eg hatoy anak ay gintan la koni Apo Hisos. Hin nakit hi Apo Hisos nin hatoy mala-et ya ispiritoy pinomahok ha anak ay pinahwag na baytoy anak. Hapa-eg hatoy anak ay natomba ha lotà biha nipatolidtolid boy nagbola-bolà ya bebey na. ");
INSERT INTO sbl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pinastang ni Apo Hisos ya tatay nin hatoy anak, “Nakano et,” wana, “nag-ompisa bayti ya ansomompong kona?” Tinombay ya tatay nin hatoy anak, “Pa-ibat et,” wana, “hin mayamò ya. ");
INSERT INTO sbl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ha kagagaw-an nin mala-et ya ispirito ay mabetbet yan mihapog ha apoy boy mipadlep ha lanom emen ya mati. Piro no ma-in kan magawà ay ingalowan mo kayi boy tambayan.” ");
INSERT INTO sbl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tinombay hi Apo Hisos, ya wana, “Anyay labay mon totolen ha hinalità mo no ma-in akon magawà? Kaganawan bagay ay mangyari no hay tawo ay ma-in pantotompel ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hapa-eg, nambo-angaw ya tatay nin hatoy anak, ya wana, “Ma-in akon pantotompel, piro alwan sapat. Pahanan moy pantotompel ko komo.” ");
INSERT INTO sbl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hin nakit ni Apo Hisos ya malakè et ya tawoy anlomateng bayro ay minandawan na bayto ya mala-et ya ispirito ya anti do ha anak, “Hika ya mala-et ya ispirito ya ampakateek boy ampakamemel nin tawo, mog-alih ka bahen ha anak boy agkayna pomahok konan oman.” ");
INSERT INTO sbl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hapa-eg hatoy anak ay pina-angaw nin hatoy mala-et ya ispirito boy pinahwag nan pinakehegkeheg biha ya nog-alih do ha anak. Hapa-eg, nakit nin tawtawo ya hatoy anak ay emen anan bangkay. Kayà anhalita-en la nin hiya ay natina. ");
INSERT INTO sbl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piro inoligtanan ni Apo Hisos ya gamet nin hatoy anak ta inibangon na ya. Kayà nireng baytoy anak. ");
INSERT INTO sbl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hapa-eg, nilomo-ob hili Apo Hisos ha bali. Hin hilahila tana nin aw-alagad na ay pinastang la ya, ya wanla, “Antà agnawen mapa-alih baytoy mala-et ya ispirito?” ");
INSERT INTO sbl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tinombay hi Apo Hisos, ya wana, “Habaytoy ombayroy mala-et ya ispirito ay ahè mapa-alih no ahè ipanalangin nin matibolos ya nakem ha Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hapa-eg, nanigè hili Apo Hisos nin nog-alih bayro ta nagdaan hila ha probinsyan Galiliya. Ahè labay ni Apo Hisos nin matanda-an nin tawtawo no ayri ya ");
INSERT INTO sbl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta antoro-an nay aw-alagad na. Hinalità na konla, “Hiko,” wana, “ya an-ingaten Anak nin Tawo ay igwà ha tawtawoy mangama-in katongkolan ya mangipapati kongko. Piro pangati ko, ha ikatlon allo ay mabiyay akon oman.” ");
INSERT INTO sbl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Habaytoy hinalità ni Apo Hisos ay ahè na-intindiyan nin hatoy aw-alagad, piro angkalimo hilan magpastang kona no anyay labay totolen nin habayto. ");
INSERT INTO sbl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hapa-eg hili Apo Hisos ay nilomateng ha banowan Kapirnawom. Hin anti hilayna ha lo-ob bali ay pinastang nay aw-alagad na, ya wana, “Anyay ampididiskosyonan moyo nangon ha daan?” ");
INSERT INTO sbl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piro aghila tinombay ta angkareng-ey hila, ta hay ampididiskosyonan la ay no hino konlan aw-alagad ya ampaka-igit. ");
INSERT INTO sbl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hapa-eg, niknò hi Apo Hisos ta iningat nan pakarani kona baytoy labinloway alagad na. Hinalità na konla, “Hinoman komoyo,” wana, “ya labay maka-igit ha kanayon ay ka-ilangan yan magmaka-aypà nin magsirbi ha kaganawan tawo.” ");
INSERT INTO sbl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hapa-eg hi Apo Hisos ay nangwa nin mayamò ya anak ta pina-ireng na ha arapan nin aw-alagad na. Hinapwat na baytoy anak biha na hinalità konla, ");
INSERT INTO sbl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hinoman ya mananggap boy mangasiwà nin ombayri ya anak ha ngalan ko ay hikoy antanggapen na; boy hinoman ya ampananggap kongko ay alwan bongat hikoy antanggapen na no alwan antanggapen na et ya nangihogò kongko.” ");
INSERT INTO sbl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hapa-eg, hinalità ni Howan koni Apo Hisos, “Apo,” wana, “ma-in kayin nakit ya lalaki ya ha ngalan mo ay ampama-alih yan dawdimonyo ya pinomahok ha tawo. Binawalan nawen ya ta alwa tamo yan kagropo.” ");
INSERT INTO sbl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piro hinalità kona ni Apo Hisos, “Agmoyo ya bawalan,” wana, “ta no ma-in nin ampanggawà nin kapapa-ispantay gawà ha ngalan ko ay agya bastabasta maghalità nin kontra kongko; ");
INSERT INTO sbl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ta hinoman ya tawoy alwan kontra kontamo ay kakampi tamo. ");
INSERT INTO sbl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anhalita-en ko komoyoy kaptegan: hinoman ya mambin inomen ya lanom komoyo ha ngalan ko banà ta hikawo ay ikon ni Kristo ya ayin kanayon no alwan hiko ay ma-in matanggap ya primyo ya igwà kona nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hapa-eg, wana et ni Apo Hisos ha aw-alagad na, “Hinoman,” wana, “ya manggawà nin bara-nan ya pangibatan nin hay mihay anak ya antompel kongko ay makapagkasalanan, mahampat et ya hay le-ey na ay taklan nin malhay ya gigilingan ya bato biha ya itapon ha dagat. ");
INSERT INTO sbl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No hay kagmang gamet mo ay ampakahirà nin pantotompel mo kongko ay potohen mo. Mahampat et ya mimihay gamet mo no hika ay magkama-in biyay ya ayin anggawan, kisa komplitoy gamet mo no hika ay itapon ha impirno ya apoy ya ahè angkaparè. ");
INSERT INTO sbl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Bayro ay ma-in aw-owel ya ahè angkati ya ampangnà laman nin tawo, boy hay apoy bayro ay ahè angkaparè. ");
INSERT INTO sbl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“No hay kagmang bitih mo ay ampakahirà nin pantotompel mo kongko ay potohen mo. Mahampat et ya mimihay bitih mo no hika ay magkama-in nin biyay ya ayin anggawan kisa komplitoy bitih mo no hika ay itapon ha impirno. ");
INSERT INTO sbl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Bayro ay ma-in aw-owel ya ahè angkati ya ampangnà laman nin tawo, boy hay apoy bayro ay ahè angkaparè. ");
INSERT INTO sbl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“No hay kagmang mata mo ay ampakahirà nin pantotompel mo kongko ay alihen mo. Mas mahampat et ya mimihay mata mo no hika ay mipalako ha dogal ya ampag-ari-an nin Diyos kisa komplitoy mata mo no hika ay itapon ha impirno. ");
INSERT INTO sbl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bayro ay ma-in aw-owel ya ahè angkati ya ampangnà laman nin tawo boy hay apoy bayro ay ahè angkaparè. ");
INSERT INTO sbl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Apoy ya kowinta an-i-ahin ha balang tawoy antompel kongko ya hay labay totolen ay paranasen hila nin masyadoy kadya-dya-an emen tomibay ya pantotompel la kongko. ");
INSERT INTO sbl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ma-alagà ya ahin ta pampalahap nin pamamangan. No na-lihan anan alat ya ahin, pangno mo mapa-alat et nin oman? Dapat mag-in kawon emen ahin ya ampakapalahap emen ma-in katinekan ya pamilalamo moyo.” ");
INSERT INTO sbl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hi Apo Hisos ay nog-alih ha probinsyan Galiliya, ta nako ya ha probinsyan Hodiya. Hapa-eg, nilomipay ya ha balah nin Hordan. Hin ni-abot ya ha kagmang ay malakè ya tawoy nakitipon kona. Banà ta naka-ogali-an nay manorò ay ombayroy ginawà na. ");
INSERT INTO sbl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bayro ay ma-in ongnoy Parisiyo ya napakarani koni Apo Hisos. Labay la yan hagpen ha pag-i-ilgo na; kayà nagpastang hila kona nin ombayri: “Ha kawkapanogo-an nayì ay ampayagan ya lalaki nin mangihiyay nin ahawa na?” ");
INSERT INTO sbl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pastang itaman ya intobay konla ni Apo Hisos, ya wana, “Anyay immanda komoyo ni Moysis ya tongkol ha pangihiyay nin ahawa?” ");
INSERT INTO sbl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Hay lalaki,” wanla, “ay pinayagan ni Moysis nin mangihiyay ahawa, piro biha na ihiyay ya ahawa na ay manggawà ya pon nin kaholatan.” ");
INSERT INTO sbl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hinalità konla ni Apo Hisos, “Hay bara-nan,” wana, “nin panolat ni Moysis nin habayti ya kapanogo-an ay banà ha katya-an nin nakem moyo. ");
INSERT INTO sbl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piro hin ka-ona-onawan pana-on, hin pinalsa nin Diyos ya kaganawan ay namalsa yan lalaki boy babayi; ");
INSERT INTO sbl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","boy hinalità na, ya wana, ‘Hay lalaki ay makihiyay ha mawmato-antawo na ta makilamo ya ha ahawa na, ");
INSERT INTO sbl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","boy hilay lowa ay mag-in mimiha.’ Ha ombayro,” wana et ni Apo Hisos, “hila ay alwaynan lowa no alwan mimihayna. ");
INSERT INTO sbl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kayà hay pinilamo nin Diyos ay ahè pihiyayen nin tawo.” ");
INSERT INTO sbl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hin anti ana ha bali hili Apo Hisos, hay aw-alagad na ay nagpastang et kona nin tongkol ha pamihiyay nin mita-ahawa. ");
INSERT INTO sbl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hinalità na konla, “Hinoman ya lalaki,” wana, “ya mangihiyay nin ahawa ta makikahal ha kanayon ya babayi ay ampagkasalanan ya ha ahawa na ta ampamabayi ya. ");
INSERT INTO sbl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ombayro itaman, hinoman ya babayi ya makihiyay ha ahawa ta makikahal ha kanayon ya lalaki ay ampagkasalanan ya ha ahawa na ta ampakilalaki ya.” ");
INSERT INTO sbl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hapa-eg, ma-in tawtawoy nipantan nin mangayamò ya aw-anak ta ipa-aptoh la koni Apo Hisos emen mabindisyonan, piro anha-aren nin aw-alagad. ");
INSERT INTO sbl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hin nakit ni Apo Hisos baytoy aw-anak ya anha-aren nin aw-alagad nin pakarani kona ay pinamahangan nay aw-alagad na, ya wana konla, “Hay aw-anak ay agmoyo ha-aren no alwan pa-olayan moyo hilan pakarani kongko, ta hay pamomo-on nin Diyos ay anti ha tawtawoy ma-in pamahimalà kona nin bilang ombayri ha pamahimalà nin habayti ya mangayamò ya aw-anak. ");
INSERT INTO sbl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anhalita-en ko komoyoy kaptegan: hinoman ya ahè ampananggap nin pamomo-on nin Diyos nin bilang ha mayamò ya anak ay ahè mapalamo ha tawtawoy ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hapa-eg, inampon ni Apo Hisos nin mihamiha baytoy aw-anak ta inaptoh na hilan binindisyonan. ");
INSERT INTO sbl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hin ampanigè ana hili Apo Hisos ay ma-in lalaki ya nowayon nakon nanalimokod ha arapan ni Apo Hisos ta nagpastang, ya wana, “Mahampat ya mangangaral, anyay dapat kon gaw-en emen ako magkama-in nin biyay ya ayin anggawan?” ");
INSERT INTO sbl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tinombay kona hi Apo Hisos, ya wana, “Antà an-ingaten mo kon mahampat? Ayin kanayon ya mahampat no alwan Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tandà moy pawpanogò nin Diyos: ‘Agka mamatin tawo; agka makilalaki o mamabayi; agka manakaw; agka manistigos nin ayin kaptegan; agka mana-ol; boy igalang moy tatay mo boy nanay mo.’” ");
INSERT INTO sbl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hatoy lalaki ay tinombay koni Apo Hisos, ya wana, “Mangangaral, kaganawan nin habayti ay anhonolen koyna pa-ibat hin anak ako et.” ");
INSERT INTO sbl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hapa-eg, tinegteg ni Apo Hisos baytoy lalaki ta nilabi na ya boy hinalità na kona, ya wana, “Ma-in et mihay bagay ya ka-ilangan mon gaw-en. Morong ka ta ilakò moy kaganawan kamama-in mo, ta hay napaglako-an ay igwà mo ha mawmanga-irap emen ka magkama-in nin kayamanan ha katatag-ayan ha kama-inan nin Diyos. Pangayarì mon gaw-en bayto ay magbira ka bayri ta makilamo ka kongko.” ");
INSERT INTO sbl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hin nalengè nin hatoy lalaki baytoy hinalità ni Apo Hisos ay inomahem ya lopa na. Malelè yay norong ta hay kamama-in na ay pagkalalakè. ");
INSERT INTO sbl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hapa-eg hi Apo Hisos ay nanegteg ha mamalibot na biha na hinalità ha aw-alagad na, “Hay tawoy mayaman,” wana, “ay ma-irap mapalamo ha tawtawoy ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Habaytoy hinalità ni Apo Hisos ay pinag-ispantawan nin aw-alagad na. Hapa-eg, hinalità nan oman konla, “Aw-anak,” wana, “hay tawo ay talagan ma-irap mapalamo ha tawtawoy ampag-ari-an nin Diyos. ");
INSERT INTO sbl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas maparah et ha mihay kamel ya magdaan ha lobot nin karayem, kisa ha mihay mayaman ya mapalamo ha tawtawoy ampag-ari-an nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hay aw-alagad ni Apo Hisos ay masyadon nag-ispanta do ha hinalità na; kayà nagpastang hila, ya wanla, “No ombayro, hinoman awod ya malibri?” ");
INSERT INTO sbl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tinegteg hila ni Apo Hisos boy wana konla, “Ahè ma-ilibri nin tawo ya sarili na, no alwan Diyos ya mangilibri kona, ta kaganawan bagay ay ma-arì pangyariyen nin Diyos.” ");
INSERT INTO sbl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hapa-eg, hinalità ni Pidro koni Apo Hisos, ya wana, “Imbalag nawen ya kaganawan ta nakilamo kayi komo.” ");
INSERT INTO sbl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Hinalità konla ni Apo Hisos, ya wana, “Anhalita-en ko komoyo ya kaptegan: hinoman ya mangibalag nin pamamali na, o pawpatel na, o mawmato-antawo na, o aw-anak na, o lotà na nin banà kongko boy banà ha pangi-aral na nin Mahampat ya Balità ");
INSERT INTO sbl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay matanggap nan kamagatoy bisis ha pana-on ya kasalokoyan. Magkama-in ya nin bawbali, pawpat