﻿USE sofia;
DROP TABLE IF EXISTS sofia.sbk_vpl;
CREATE TABLE sbk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sbk_vpl WRITE;
INSERT INTO sbk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ishitabu ishashikholo isha Yesu Klisiti umwana wa Daudi, umwana wa Ibrahimu. ");
INSERT INTO sbk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","U Ibrahimu ahali yise wa Isaka, Uisaka ahali yise wa Yakobo, u Yakobo ahali yise wa Yuda na bhaholo bhakwe. ");
INSERT INTO sbk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","U Yuda ahali yise wa Peresi nu Sera hwa Tamari, Peresi yise wa Hezeroni, u Hezeroni yise wa Ramu. ");
INSERT INTO sbk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","U Ramu ahali yise wa Aminadabu, u Aminadabu ahali yise wa Nshoni, u Nashoni yise wa Salimoni. ");
INSERT INTO sbk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","U Salimoni ahali yise wa Boazi hwa Rahabu, u Boazi yise wa Obedi hwa Ruth, U Obedi yise wa Yese, ");
INSERT INTO sbk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","u Yese ahali yise wa mfalume u Daudi. U Daudi ahali yise wa Sulemani hwa nshi wa Uria. ");
INSERT INTO sbk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Usulemani ahali yise wa Rehoboamu, u Rehoboamu yise wa Abiya, u Abiya yise wa Asa. ");
INSERT INTO sbk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","U Asa ahali yise wa Yehoshafati, u Yehoshafati yise wa Yoramu, u Yoramu yise wa Uzia. ");
INSERT INTO sbk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","U Uzia ahali yise wa Yothamu, u Yothamu yise wa Ahazi, u Ahazi yise wa Hezekia. ");
INSERT INTO sbk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","U Hezekia ahali yise wa Manase, u Manase yise wa Amoni u Amoni yise wa Yosia. ");
INSERT INTO sbk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","U Yosia ahali yise wa Yekonia na kaka bhakwe lwebhahegwaga abhale hu Babeli. ");
INSERT INTO sbk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baada ya hwegwe abhale hu Babeli, u Yekonia ahali yise wa Shatieli, u Shatieli ahali mwizukulu wa Zerubabeli. ");
INSERT INTO sbk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","u Zerubabeli ahali yise wa Abiudi, u Abiudi yise wa Eliakimu, u Eliakimu yise wa Azori. ");
INSERT INTO sbk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","U Azori ahali yise wa Zadoki, u Zadoki yise wa Akimu u Akimu yise wa Eliudi. ");
INSERT INTO sbk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","U Eliudi ahali yise wa Elieza, u Elieza yise wa Matani u Matani yise wa Yakobo. ");
INSERT INTO sbk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","U Yakobo ahali yise wa Yusufu unume wa Mariamu, yehwamwene u Yesu ahapapwilwe, yahwitwa Klisiti. ");
INSERT INTO sbk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Impapo zyonti afume hwa Ibrahimu hadi hwa Daudi zyahali impapo kumi na nne, afume hwa Daudi hadi hwegwe abhale hwa Babeli impapo kumi na nne, na afume ahwegwe afume hu Babeli hadi hwa Klisiti impapo kumi na nne. ");
INSERT INTO sbk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Apapwe hwa Yesu Klisiti hwahali ishi. Unyina wakwe u Mariamu, ahazinjiwilwe nu Yusufu, ishi shebhasili alolane ahaloleshe aje alinivyanda hwa mpepo umfinjile. ");
INSERT INTO sbk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Unume wakwe u Yusufu, ahali muntu wi lyoli zaga ahauzaga hukenyesye hubhantu. Ahamuye ahwimilisye husili. ");
INSERT INTO sbk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nahasibhaga ahusu amamba iga, uwantumi uwa ngumbhi ahamfumiiye hunjozi, ahaga, “Yusufu mwana wa Daudi, usahogope humweje u Mariamu unshi waho pipo ulwanda lwali nalwo lufumiline nu Mepo umfinjile. ");
INSERT INTO sbk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Abhapape umwana unsahala ubhalunkwize itawa lyakwe yu Yesu, papo anzahubhokole abhantu bhakwe ni dhambi zyabho.” ");
INSERT INTO sbk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gonti gahafumiye aje nkezibhombeshe zyezyayangwile nu gosi hwidala lya kuwa aje, ");
INSERT INTO sbk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Enya, u bikira ahayibha ni vyanda ahayipapa umwana uwishilume itawa lyakwe abhahukwizye yu Imanueli” — imaana yakwe, “Ungulubhi ali natwi.” ");
INSERT INTO sbk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","U Yusufu ahadamushe mutulo na bhombe ndeshe abhantumi ngosi she bhahamuzizye na ahamwejile unshi wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hata shinisho, sagahagonile nawo mpaka lwahapapa umwana uwishilume ahankwizya itawa lyakwe yu Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baada ya Yesu apapwe Mubethelehem iya Huuyahudi hu nsiku izya mwene u Herode, abhantu bhebhazizye afume humashariki iya patali bhahafishile hu Yerusalemu bhahaga, ");
INSERT INTO sbk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ali hwoshi yapapilwe umwene wabhayahudi? Tahayilolile inzota ya humashariki nati tinzile humpute.” ");
INSERT INTO sbk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Umwene u Herode la ahumvwa iga ahalalamushe ni Yerusalemu youti peka nu mwene. ");
INSERT INTO sbk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uherode ahabhabhunginye agosi bhaadimi bhonti na asimbi bha bhantu, ahabhabhuzya, “Klisiti abhapapwe hwi?” ");
INSERT INTO sbk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhamuzya, “Hu Bethelehemu iya Huyahudi, ishi sheyahasimbilwe na akuwa, ");
INSERT INTO sbk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Naawe Bethelehemu, munsi iya Yuda, siga ndodo peka na alongozi abha hu Yuda, pipo afume huliwe abhahwinze umwene yahayibhadima abhantu bhani abha Israeli.” ");
INSERT INTO sbk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Isho u Herode ahabhakwizizye bhala abhazyi hu siri na hubhabhuzye aje habhalilizyo bhuli inzota iloleshe. ");
INSERT INTO sbk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ahabhatuma hu Bethelehemu, ahaga, “Bhalaji na hwenyelezye mumwanze umwana ya papilwe. Nkemwanola mundetele ihabari aje nani nkininze humpute.” ");
INSERT INTO sbk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baada ya manye aje bhamwimvwizye umwene bhahendeliye ashule, ni mota ila yebhahayilolile humashariki yahabhalongoleye mpa lweyahimilila pala pa mwanya umwana ahapapilwe pansi yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lwe bhahayilola inzota bhahashiye hani. ");
INSERT INTO sbk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhahinjiye munyumba nahunole umwana yapapilwe nu Mariamu unyina wakwe. Bhamwinamiye na humpute. Bhahiguye ivintu vyabho nahumfumizye izawadi zyabho izahabu nu uvumba ni manemane. ");
INSERT INTO sbk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","U Ngulubhi ahabhasoshile mndoto aje bhasahawele hwa Herode, kwa hiyo bhahasoguye abhale hunsi yabho hwidala ilyinji. ");
INSERT INTO sbk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baada ya sogole abhantumi bha Ngulubhi bhahamfumiye u Yusufu hunjozi ahadamushe, “Ua, humweje umwana nu nyina wakwe nu mwana na ahashimbiliye hu Misri. Mukhale hunuhwo mpaka lwe nahayibha bhuzya pipo u Herode ahumwana ili agoje. ");
INSERT INTO sbk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nunsiku u Yusufu ahadamusha na humweje umwana nu nyina wakwe ashimbilile Humisri. ");
INSERT INTO sbk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ahakhiye uhwo mpa u Herode nahafwa. Izi zyahafishiye shila Ungulubhi shahayinje ashilile hwa nkuwa, “Afume humisri inkwizizye mwana wani.” ");
INSERT INTO sbk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","U Herode, laahalola bhansufizye na bhantu abhazya, ahavitilwe hani. Ahalajizizye agoje abhana na bhonti abhishilume bhebhahali hu Bethelehemu na bhonti bhebhali pala ahwaudile amaha gabhili ahwishe pansi afume shebha yinje abhazyi. ");
INSERT INTO sbk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pe twalibhombile izwi lila lyelyaha yangwilwe nukuwa u Yeremia, ");
INSERT INTO sbk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Izi lyahimvwiha hu Ramah, impungo na zonde hani, u Raheli ahabhalililaga abhana bhakwe, na ahakhanile apumilizwe pipo abhana nabhamo.” ");
INSERT INTO sbk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","U Herode lwa hafwa abhantumi bha Ngulubhi bhahamwinziye u Yusufu mutulo uhwo hu Misri na yanje. ");
INSERT INTO sbk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bhuha umweje umwa nu nyina wakwe mubhale hunsi iya hu Israeli pipo bhahanzaga uwumi wa mwana aje bhasahagoje.” ");
INSERT INTO sbk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","U Yusufu ahimiliye, amwega umwana nu mayi wakwe, ahinza munsi iyamu Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ishi la ahwumvwa aje u Arikelau ahali mwini wa hu Yuda pala pa yise wakwe u Herode, ahogope abhale uhwo. Baada ya Ngulubhi hunsoshe mutulo, ahasogoye abhale humukoa ugwa hu Galilaya, ");
INSERT INTO sbk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ahabhalile akhale munsi yihwitwa Nazareti. Ili lyahatimiye hu zila zyezyahayangwilwe hwi dala lya kuwa aje bhasiakwizye Mnazareti. ");
INSERT INTO sbk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Munsiku zila u Yohana Umwozyo ahinzile alumbilile hunyika iya hu Yuda ahaga, ");
INSERT INTO sbk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mulambe pipo ubhumwini uwahumwanya bhusojeliye.” ");
INSERT INTO sbk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pipo unu yahayangwilwe nukuwa u Isaya ahaga, “Izwi lya muntu ya kwizya afume hujangwani; 'mubhishe tayari idala lya gosi, mugagoloshe amashilo gakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ishi Uyohana ahakwite amasepe agingamia ni lamba ilyingozi musana wakwe, ishalye shakwe shahali nzije nu woshi uwa mwisengo. ");
INSERT INTO sbk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Habhili Muyerusalemu, Iyuda yonti, ni sehemu yonti yeyahazyangulile isoho Iyordani bhahabhala hukwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhahozewaga nawo mwisoho mu Yordani bhalambaga hwangwubhi imbibhi zyabho. ");
INSERT INTO sbk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lwahabhalola abhinji abhamafalisayo na masadukayo lwebhahwuzya, “Amwe mwimpapo izyi nzoha izyi sumu wenu yabhasoshile huyishimbile inkuni yihwinza? ");
INSERT INTO sbk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mupape amadondo gegahwanziwa alaabe. ");
INSERT INTO sbk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mgandi asibhe na ayanjizanye hulimwe mwe, 'Tulinawo u Ibrahimu ye yise witu.' Pipo imbabhuzya aje Ungulubhi angamwimishizya u Ibrahimu abhana afumilane na mawe iga. ");
INSERT INTO sbk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Intemu iliho ibhihwile hunzizi ugwi kwi. Ishi ikwi lyolyonti lyesalipapa amadondo lidumulwa na tajilwe mu mwoto. ");
INSERT INTO sbk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ihubhozya na manzi hunongwa ya lambe. Ishi umwene yahwinza badala yani ngosi kuliko ani. Nanisihwanziwa abhusye iyilyatu vyakwe. Umwene asibhozye hwa mpepo umfinjile na humwoto. ");
INSERT INTO sbk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na ulupapike lwakwe lulimunyobhe zyakwe lupepeta nziila na hwozye na abhunganye ingano zyakwe mushanga. Nantele abhapembe amakapi mumwoto wesebhuzimiha. ");
INSERT INTO sbk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nantele u Yesu ahinza afume hu Galilaya mpaka mwisoho Iyorodani ahwozewe nu Yohana. ");
INSERT INTO sbk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Uyohana ahandaga akhane aje, “Asahamwozye pipo u Yesu gosi ashile u Yohana?” ");
INSERT INTO sbk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","U Yesu ahayanga ahaga, “Nini ihurusu awe unozye, maana ihwanziwa aje inkamilisye ilyoli yonti.” U Yohana pa ahamwozya u Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baada ya hwozewe u Yesu ahafumile muminzi ahenya imwaaya zyahamwigushiye, nantele ahanola umpepo wa Ngulubhi ahwiha hushifwani shinjibha na ahwimilile pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Izwi, lyahafumile humwanya lyahaga, “Unu mwana wani uganwa. Indi ni insungwo nawo hani.” ");
INSERT INTO sbk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","U Yesu ahalongozowilwe nu Mpepe mpaka hujangwa ili ajelwe nu setano. ");
INSERT INTO sbk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ahafunjile insiku arobaini nunsanya na nunsiku ahali ni nzala. ");
INSERT INTO sbk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uwinjelo ahinza ahamuzya, “Ahaga awe ukewe mwana wa Ngulubhi ugobhuzye amawe iga gabhe makati.” ");
INSERT INTO sbk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lelo u Yesu ahaga ahamuzya, “Iyandihwilwe, 'Umuntu sangakhala munsi umu alyanje gamakati gini, hata hwizwi lyolyonti lyelifuma hwa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Habhili usetano ahantwalile mpaka munsi nyinza na humishe pamwanya hani pinyumba iyishibhanza, ");
INSERT INTO sbk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na humuzye, hujenkushe awe uli mwana wa Ngulubhi, yidomosye mpaka pansi, pipo isimbilwe bhakwe bhinze bhatone nantele bhasibhusye humakhono gabho nkusahabumile mu mawe.” ");
INSERT INTO sbk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","U Yesu ahambula, “Ahaga habhili ahaga, 'Uganje hunjele u Ngulubhi waho.” ");
INSERT INTO sbk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Habhili, usetano ahamwega na huntwale pigamba pamwanya hani ahanolesya insi zyontiinyinza. ");
INSERT INTO sbk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ahaga, “Inzahupele ivintu vyonti ivi nkewaninamila na humpute ani.” ");
INSERT INTO sbk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","U Yesu ahabhula, “Sogolaga uyepe ipa, setano! Pipo isimbilwe ihwanziwa humpute Ungulubhi waho, umombele yuyo mwimi.” ");
INSERT INTO sbk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Usetano ahaneha, nahabhalola, abhantumi bhahinza humpute na humbhombele. ");
INSERT INTO sbk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","U Yesu naahanvwa aje u Yohana akhitwe, ahasoguye mpaka hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ahasoguye Hunazareti ahabhalile akhale Hukapernaumu, yilimunshinji mu bahari ya Hugalilaya, mumpaha mmajimbo ga Zabuloni nu Naftali. ");
INSERT INTO sbk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ili lyahafumiye aje likamiliswe lyelyahayangwile nu kuwa u Isaya, ");
INSERT INTO sbk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Munsi iya Zabuloni na munsi iya Naftali, abhale munsumbi mwisyila ilya Huyorodani, Hugalilaya iya hubhinsi! ");
INSERT INTO sbk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abhantu bhebhakhiye muhisi bhabhulolile umwanga ungosi hawi, na bhala bhebhahakhiye mwidala ilyifwe pamwanya ulukhozyo lukhozizye.” ");
INSERT INTO sbk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Afume ahabhalilizyo iho u Yesu ahandile alumbilile aje, “Mulambe pipo ubhumwini uwahumwanya bhusojeliye.” ");
INSERT INTO sbk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lwahajendaga mushinji munsunbi iya Hugalilaya, ahabhalola aholo bhabhili, u Simoni yebhahakwizyaga yu Petro, nu Andrea ukaka wakwe, bhahatega inyavu mwusumbi pipo bhahasukulaga inswi. ");
INSERT INTO sbk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","U Yesu ahabhabhula ahaga, “Inzaji munfwate, imbabhabhishe mubhebhasukule abhantu.” ");
INSERT INTO sbk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pinipo bhahaluleha ulwelo bhaufwata u Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","U Yesu lwahajendelelaga afume ipo ahabhalola aholobbhabhili abhamwabho, Yakobo umwana wa Zebedayo, nu Yohana ukaka wakwe. Bhahali mwitoli peka nu Zebedayo uyise wabho bhahasonaga ulwelo lwabho. Ahabhakwizwa, ");
INSERT INTO sbk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","pinipo bhahalileha itoli nu yise wabho bhope bhahanfuata. ");
INSERT INTO sbk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","U Yesu ahabhalile Mugalilaya yonti, ahamanyizyaga mu Masinagogi gabho, ahalumbililaga ibhangili ubhumuini aponye impungo ni mbina zyonti zya bhantu. ");
INSERT INTO sbk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Inongwa zyakwe zyahayeshile Isiria yonti na abhantu bhahaleta abhabhinu bhebhali ni inpungo zinyinji, bhebhahali ni mpepo izyi shifafa na bhebhapoozizye. U Yesu ahabhaponizye. ");
INSERT INTO sbk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Impuga ya bhantu yahali ngosi abhantu bhebhafuataga afume hu Galilaya, na Dekapoli, na Huyerusalemu na Huyahudi na afume mwisyila ilya hu Yorodani. ");
INSERT INTO sbk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","U Yesu lwahayilola impuga, ahasoguye abhale hwigamba. Lwahakhiye pansi asambilizyi bhakwe bhalinza. ");
INSERT INTO sbk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ahigula ilomu lyakwe ahabhamanyizya, ahaga, ");
INSERT INTO sbk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hwashi abhapina bhi mwoyo pipo ubhumwini uwahumwanya wabho. ");
INSERT INTO sbk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hwashi abhaswimilizu pipi bhahayisubhizwa. ");
INSERT INTO sbk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hwashi abhapole, bhahayibha bhapyani bhi insi. ");
INSERT INTO sbk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hwashi abhinzala ni shumwilwa shilyoli pipo bhahayikuta. ");
INSERT INTO sbk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hwashi abhirehema pipo bhayibha ni rehema. ");
INSERT INTO sbk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hwashi abhimwoyo umwinza pipo bhayinola Ungulubhi. ");
INSERT INTO sbk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hwashi akundanyi, pipi bhabhabhe bhana bha Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hwashi bhebhayimba kwa ajili yi lyoli pipo ubhumwini uwahumwanya wabho. ");
INSERT INTO sbk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Hwashi amwi yemuligwa na bhantu ua yimbe na yangwe hwilenga ubhibhi kwa ajili yani. ");
INSERT INTO sbk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mushanje ua lulutile pipo amasombo ginyu magosi hwa Ngulubhi. Pipo abhantu abhahwande bhahabha yimvizye akuwa bhebhali kabla yinyu. ");
INSERT INTO sbk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Amwi libheya lyinsi ishi ibheya nkelitezizye uwinza wakwe selibhabhe libhe ya habhili? Selingabha lyinza habhili hu hantu hohonti, hulitaje hunzi ua akhanywe ni vinama vya bhantu. ");
INSERT INTO sbk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Amwi lukhozyo lwinsi. Ikhaya yizengwilwa pamwanya pi gamba sihuyifisa. ");
INSERT INTO sbk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Abhantu sebhahwansya itala nahuyibhishe pansi yishikapu, ila bhabhiha pamwanya imuliha bhonti bhebhali muhati munyumba. ");
INSERT INTO sbk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Muleshe ulukhozyo lwinyu lukhozye hwilongolela hwa bhantu ihwanziwa huje abhantu bhagalole amatendo ginyu aminza na huutime u Ngulubhi uwahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Msahaje ininzile ananganye indajizyo wa akuwa. Sininzile ananganye ininzile atomizye. ");
INSERT INTO sbk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Amba lyoli ihumbabhuzya huje mpaka imwanya ninsi zyonti zishile nimo iyodi yeka wala inukuta yeka iyi sheria seyahayiyepa kila hantu lwehayibha tiyari. ");
INSERT INTO sbk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ishi wowonti yavunza iamuli indodo mojawapo yi amli izi na hubhamanyizye abhanji abhombe isho ahwitwa ndodo hubhumwini uwahumwanya. Lakini yeyote azishikaye na kuzifundisha ataitwa mkubwa katika ufalme wa mbinguni. ");
INSERT INTO sbk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pipo ihumbabhuzya ihaki yinyu nkeseyabhashila abhaandishi ya Mafalisayo, shoshonti shila semwahayiyinjila humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mwinvwizye yahayangwilwe imandi aje, “usahagoje”'wowonti yagoga ahayilongwa.' ");
INSERT INTO sbk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ishi ihumbabhuzya wowonti yahumvitwa uholo wakwe ahayilongwa. Na yeyote amwambiaye ndugu yake kuwa, 'Wewe ni mtu uisyefaa!' atakuwa katika hatari ya baraza. Na yeyote asemaye, 'Wewe mjinga!' atakuwa katika hatari ya moto wa jehanamu. ");
INSERT INTO sbk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nkufumya isadaka yaho pashiputo ukumbuha huje uholo waho alininongwa nawe, ");
INSERT INTO sbk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yileshe isadaka paushiputo ubhale ukundane nawo uholo waho nkuyinze ufumye isadaka yaho. ");
INSERT INTO sbk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kundana nu unongwi waho lubhilo lulipeka nawo mwidala lwemubhala humahakama, mukundane ili usahakungwe mwigereza. ");
INSERT INTO sbk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mwitishe ihumbabhuzya semwahayibha ahinza mpaka musombe amalando gemlongwa. ");
INSERT INTO sbk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mwinvwizye aje iyandihwilwe, 'Usahazini.' ");
INSERT INTO sbk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lelo ihubhabhuzya wowonti ya humwenya unshi hwahunsungwe uyo azinile nawo mumoyo wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nki ilinso lyaho ilya hulilo lihusababisya abumile ulikunye ulitaji apatali nawe. Pipo hwashi ishilungo sheka mumbili waho shinanjishe kuliko ubili ngwonti gubhale hujehanamu. ");
INSERT INTO sbk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na nkushe inyobhe yaho indilo isababisya aje ubumile, udumule yoonti uyitajle apatali nawe. Pipo hwashi ishilungo sheka shinanjishe kuliko ubili gwonti gubhale hujehanamu. ");
INSERT INTO sbk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Isimbilwe wowonti ya huminga unshi wakwe ampele italaka.' ");
INSERT INTO sbk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lelo ani ihumbabhuzya wowonti yahuneha unshi wakwe hunongwa yizanaa uyo amishile aje muzinzi. Na wowonti yahumwega unshi uyo wope uzinzi. ");
INSERT INTO sbk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tena, mwinvwizye aje yahayangwilwe hubhala abhimandi, 'Musaha lape ilenga lelo muntwalile Ungulubhi ilape hwinyu.' ");
INSERT INTO sbk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lelo ihumbabhuzya musahalape hata hadodo hata hwimwanya pipo imwanya enzi ya Ngulubhi; ");
INSERT INTO sbk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wala hunsi pipo mahali pakwe pabhishe itengo ilyakhanyile ivinama vyakwe, wala hwa Yerusalemu, maana khaya yamwini ugosi. ");
INSERT INTO sbk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Usahalape hwitwe lyaho maana sungabhomba ulusisi lweka lubhe zeru au lwiru. ");
INSERT INTO sbk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lelo inongwa zyinyu zibhanje, 'Ena, ena, Ndali, ndali.' Pipo nkegonjela ipo gafuma hwa nugu. ");
INSERT INTO sbk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mwinvwizye aje iyangwilwe aje, “Jicho kwa jicho, na jino kwa jino.' ");
INSERT INTO sbk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lelo ani ihumbabhuzya mugandi atolane nu muntu umibhi; Lelo umuntu nkahukhoma imbuguzi iya hulilo umpele ni lya humongo. ");
INSERT INTO sbk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nu muntu wowonti yasungwa abhale nawe humahakama na afyula inkanzu yaho neshele ni joho lyaho. ");
INSERT INTO sbk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wowonti yahulazimisya ibhale umaili yeka bhala umaili zibhili. ");
INSERT INTO sbk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wowonti yahulabha umpele, yakhopa khopele. ");
INSERT INTO sbk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mwinvwizye iyangwile ugane, 'Umpalamani waho, unvitwe unugu waho.' ");
INSERT INTO sbk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lelo imbabhuzya mubhagane alugu bhinyu mubhaputile bhebhalubhavisya, ");
INSERT INTO sbk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nkemubhe bhana bha daada uwahumwanya. Pipo alamya isaya likholo hwabhibhi na bhinza, imvula itonya hwa bhabhibhi na bhinza. ");
INSERT INTO sbk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nkemwabhagana bhebhabhaganile amwi, mubhapate faida nshii? Mbona bhebhasongozya insoho sebhabhomba isho. ");
INSERT INTO sbk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nke mwabhalamuha aholo bhinyu bhini mubhapa ahenu ashile abhanji? Ishi!, abhantu bhinsi sebhabhomba isho? ");
INSERT INTO sbk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ishi ihwanziwa huje mubhe bhagolosu ndeshe Udada winyu uwahumwanya shali golosu. ");
INSERT INTO sbk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Uyenyaje ungandi abhombe imbo inyinza hubhantu ili huyilolesye, subhapate ifaida hwa Dada uwahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ishi nufumya isadaka usahayitufye sana usahabhe ndeshe abhanafiki shebhabhomba mumasinagogi na mumitaa, nkaabhantu bhabhatime semubhapae ifaida nkiimo. ");
INSERT INTO sbk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lelo awe lufumya ukhona gwaho ugwa humongo gusahamanye sheshibhombeha hundilo, ");
INSERT INTO sbk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ili huje isadaka yaho ufumye hu siri. Nkhu Udada waho yalola muhati abhalupele ithawabu yaho. ");
INSERT INTO sbk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na luputa usahabhe, udeshe anafiki, pipo abhene bhasungwa ahwimilile na pute, mumasinagogi na mukona izya mukhaya zyabho nka abhantu bha bhenye. Lelo ihumbabhuzya bhapite ithawabu yabho. ");
INSERT INTO sbk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Awe luputa injila hu hati ufunje ulwiji upuute hwa Daada uwamumwoyo udaada ya lola muhati asipele ithawabu yaho. ");
INSERT INTO sbk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nu puta ungandi pyanile inongwa zyesezili ni maana, ndeshe abhamunsi shebhabhomba pipo bhasibha abhantu bhabhahubhiuvwe pipo bhayanga inongwa inyinji. ");
INSERT INTO sbk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ishi usahabhe ndeshe abhene pipo uDada aminye uhwanza henu shusile alabhe hukwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Uputaje ishi: Dada witu uwahumwanya itawa lyaho lyimishilwaje. ");
INSERT INTO sbk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ubhumwini waho winze, ulugano lwaho lubhombeshe pansi na humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utipele ishalye shitu insiku zyonti. ");
INSERT INTO sbk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utukhobhoshele amalando gitu, ndeati shetihubhakhobhoshela abhimalando bhitu. ");
INSERT INTO sbk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usahatipe injelo, utidime nu setano. ");
INSERT INTO sbk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nkemwabhakhobhoshela abhantu amalando gabho, Udada winyu uwahumwanya abhahubhakhobhoshele namwi. ");
INSERT INTO sbk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nkushe mubhabhakhobhoshele abhantu Udada abhabhakhobhoshele makosa ginyu. ");
INSERT INTO sbk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Hu gonti, lufunga usahalolesye uzugunizu humaso ndeshe abhanafiki shebhabhomba bhazugumila humiso nke abhantu bhamanye aje bhafunjile. Lyooli ihubhuzya bhapite ithawabu yabho. ");
INSERT INTO sbk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lelo, lufunga pahala amafuta hwitwe lyaho uyoje hunaso. ");
INSERT INTO sbk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Subhaloleshe humaso gabhantu aje ufunjile, u Ngulubhi mweene yabhamanye Udada yamanya muhati abhahupele ithawabu yaho. ");
INSERT INTO sbk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Usahabhishe amali gaho munsi umu zinanjiha na bhole na bhibha bhahwibha. ");
INSERT INTO sbk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Badala yakwe, abhishe amali gaho hwa Ngulubhi, sibhahwibha, sigabhola wa segananjiha. ");
INSERT INTO sbk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pipo amali gaho pegali umwoyo waho pebhubhabhe. ");
INSERT INTO sbk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ilinso lukhozyo lwi bili. Nkushele, ilyinso lyaho lyumi ubili wonti, bhubhabhe nulukhozyo. ");
INSERT INTO sbk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nkushele ilyinso lyaho lifwiye, ubili waho wonti bhuli hisi haani. Ishi nkulukhozyo lweluli muhati muliwe hisi ahagosi ndeshe bhuli! ");
INSERT INTO sbk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Numo nka weka yangabha na lume bha bhili, pipo abhahunvitwe unu na hugane uwinji lumo abhahwepe hwunu abhahu sufye uwinji. Hamuwezi kumtumikia Mungu na mali. ");
INSERT INTO sbk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ishi ihuhabhe nu sanje ahusu amaisha gaho aje ubhalyeshi, ubhamweleshi, ahusu ubili waho ubhakwate shi! Amaisha se haani yi shalye ubili haani yi meenda? ");
INSERT INTO sbk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Enya inyonyi zyezipuluha humwanya. Saazitota sazivunza sazibhunganya na bhishe mushanka, lelo Udada uwahumwanya ahuzilisya. Je amwisemulibhi maana hani kuliko inyonyi? ");
INSERT INTO sbk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Weemu hulimwe uwahuyitamye ankayonjezya idhiraa yeka huwomi wimaisha gakwe? ");
INSERT INTO sbk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ye enu mubha musaga aje yibhakwate nshi? Msubhilile amaua mmashamba shegabha segabhomba imbombo segahuyikwatizya. ");
INSERT INTO sbk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bado ihumbabhuzya hata yu Sulemani nu tuntumu wakwe saga ahakwatiziwilwe mojawapo yiga. ");
INSERT INTO sbk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nkushele Ungulubhi ahugakwatizya amasole agamumagunda, gegakhala isiku lyeka ni ndabhi gatagwa mumwoto je bhulibhuli angabhakwatizya amwi mwemuli nulwitiho uludodo? ");
INSERT INTO sbk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eshi musahasaje aje, 'Je tibhalyeshi?' au “Je tibhamweleshi?” au “Je tibhakhwate menda bhuli?” ");
INSERT INTO sbk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pipo abhinsi bhahuganza amambo iga, nu Dada winyu uwahumwanya aminye aje muhuganza igo. ");
INSERT INTO sbk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ishi nasuti mwanze ubhumwini wakwe ni lyoli yakwe nigo gonta gabhahwonjeleshe huliwe. ");
INSERT INTO sbk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ishi usahalole usahasaje kwa ajili yi ndabhi, pipo indabhi zibhamanyishe hunuhwo. Isiku lyolyonti likwiliye hwi tatizizo lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nkulonga, nawe wahayilongwa. ");
INSERT INTO sbk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Alonje shuloonga nawe wahayilongwa na shuhubhapimila abhantu nawe wahayi pimilwa shinisho. ");
INSERT INTO sbk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yeenu uhwenya ishipande shikwi sheshili mwilyinso holo waho suminye ishipande shikwi shesheli mwilyinso lyaho ikwi liliho mwilyinso lyaho? ");
INSERT INTO sbk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Unganda bhuli ayanje hwa holo waho aje ambaihwefwe ishipande sheshili mwilinso lyaho, wakati nawe wayo ulinasho mwilinso lyaho? ");
INSERT INTO sbk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ulinilenga awe; kwanza uyefwe ishipande sheshili mwilinso lyaho, nkubhahwefwe ahinza ishipande isha mwilinso lyaholo waho. ");
INSERT INTO sbk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Usahazipele imbwa ivintu ivyinza usahazisumbile ungurubhi ishalye ishinza zinzananganye na khanye ni vinama habhili bhanza hulye nawe. ");
INSERT INTO sbk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Labha ubhaposhele. Anza, nawe ubhapate. Khoma ihodi, anzahuhwigulile. ");
INSERT INTO sbk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pipo ya labha aposhela, na wowonti yahwanza aposhela. Umuntu yakhoma ihodi, ahumwigulila. ");
INSERT INTO sbk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aliho humwinyu umuntu umwana wakwe nkalabha umukate ahupela iwe? ");
INSERT INTO sbk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au nkanabha isamaki ahupela inzoha? ");
INSERT INTO sbk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nkushele, mubhimbibhi muminye hubhapele abhana bhinyu ivintu ivyinza, Je! Ungulubhi wenyu uwahumwanya sangabhapela hanii ivyinza bhebha hunabha umweene? ");
INSERT INTO sbk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ishi shuhwanza huje ubhombelwe na bhanji, nawe shubhombaje hwamwinyu, pipo izyo ndajizyo zya kuwa. ");
INSERT INTO sbk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mwinjile mulwiji unyeela. Pipo ulwiji lugosi idala ligosi lyelilongozya humwoto abhantu bhinji bhebhabhala idala ilyo. ");
INSERT INTO sbk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ulwiji unyeela lwa huwomi, abhantu bhadodo bhebhahwinjila umwo. ");
INSERT INTO sbk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Muyenyaje na kuwa abhilenga, bhebhahwinza bhakwite ikwembe ilyingole, lakini muhati mbwa londe ihali. ");
INSERT INTO sbk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mubhabhamanye amadondo gabho. Je abhantu bhangatungula amadondo muminvwa, au mwikwi humbeyu iyi mbaruti? ");
INSERT INTO sbk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ishi ikwi lyolyonti, ilyinza lipapa amadondo aminza, lakini ikwi ibhibhi lipapa amadondo amabhibhi. ");
INSERT INTO sbk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ikwi ilyinza salingapapa amadondo amabhibhi, wala ikwi ibhibhi selingapapa amadondo aminza. ");
INSERT INTO sbk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ikwi lyolyonti lyesagalipapa amadondo aminza litemwa na pembele umwoto. ");
INSERT INTO sbk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Abhantu abha bhibhi ubhabhamanye amadondo gabho. ");
INSERT INTO sbk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Siga muntu wowonti yayiga, 'Ngurubhi, Ngulubhi,' yahayiyinjila hubhumwini uwahumwanya, ila yuyula yabhomba inyinza zya Ngulubhi uwahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Abhantu abhinji isiku ilyo bhahayiyiga 'Ngulubhi, Ngulubhi, twahafumizye ukuwa hwitawa lyaho, hwitawa lyaho twahabhombile amambo minji aminza amagosi?' ");
INSERT INTO sbk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","U Ngulubhi ahayibhabhu aje, 'simbaminye mwepe! Ipa amwe, mubhabhomba imbibhi!' ");
INSERT INTO sbk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ishi kila muntu yahwinvwa amazwi gani na hugitishe alingana nu muntu uwihekima yazenjile inyumba yakwe pamwanya pa mawe. ");
INSERT INTO sbk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Invura yatonya, awinzi gamema ahanvulungwe hinza hayikhoma inyumba iyo seya, gwa pansi pipo yahazengwilwe pamwanya pamawe. ");
INSERT INTO sbk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lelo umutu wowonti yahwunvwa uzwi lyani lyani sahulyitiha uyo abhafane nu muntu umpumbavu yazenga inyumba yakwe pamwanya pansanga. ");
INSERT INTO sbk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Invula yinza, na minzi gamema na hamvulungwi hinza hayikhoma inyumba iyo yagwa na malishe pepala.” ");
INSERT INTO sbk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","U Yesu lwa hamala ayanje amazwi iga, abhantu bhahaswijile lwa hamanyizyaga. ");
INSERT INTO sbk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pipo ahamanyizyaga ndeshe umuntu uwimamlaka siyo ndeshe asimbi bhabho. ");
INSERT INTO sbk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","U Yesu lwahiha pansi afume mwigamba, impuga ya bhantu yahasojeliye. ");
INSERT INTO sbk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Umukoma umo ahasugamiye hwilongolela lyakwe ahaga gosi inlabha umponye.” ");
INSERT INTO sbk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","U Yesu agolosyaa inyabhe yakwe ankhata amponya apona unkoma wepa. ");
INSERT INTO sbk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Uyesu amuuzya aga, “Usahayanje hwa muntu wowonti. Bhalaga uyilolesye hwa mputi ufumye ni sadaka ye u Musa ahalajizizye ajili yiushuhuda hubhabhinu bhebhaponile mbina” ");
INSERT INTO sbk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","U Yesu lwahafiha hu Kapernaumu, un'gosi umo ahinza ahamuuzya ");
INSERT INTO sbk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ahaga, “Gosi uwimbombo wani agonile hukhaya apoozizye ivinama vibhabha haani.” ");
INSERT INTO sbk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","U Yesu aga ishi, “Imbahwinze humponye.” ");
INSERT INTO sbk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ugosi ayanga aga, 'Yesu, ani si ndinithamani mapaka uyinjile muhati munyumba yani yanga izwi lwene uwimbombo abhapone. ");
INSERT INTO sbk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pipo ani indi na mamlaka, indina sikari bhebhali pansi yani. Nkenaga bhala 'nkenaga inza ahwinza nuuwimbo wani abhomba shinisho.' ");
INSERT INTO sbk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","U Yesu lwaahinvwa iga, ahaswijile nahubha bhuzye bhala bhebhahafwataga, “Lyoli ihumbabhuzya sindolile nkalumo umuntu uwilwitiho mu Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ihubhabhuzya, bhinji bhahayiyinza afume humashariki na humagharibi, bhabhakhale pameza peka nu Abrahimu, Isaka, nu Yakobo, hu bhumwini uwahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lelo abhana bhibhumwini bhahayitagwa huhisi ha hunzi, hwehwaha yibha na lile na sye amino.” ");
INSERT INTO sbk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","U Yesu ahamuzya ugosi, “Bhalaga! ndeshe shuyitishe zibhombeshe shinisho huliwe uwimbombo ahaponile isaa yiyila. ");
INSERT INTO sbk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","U Yesu lwahafiha hukhaya hwa Petro, ahanola umayivyala wakwe wa Petro agonile abhinile inzegema. ");
INSERT INTO sbk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","U Yesu ahakhata inyobhe yakwe ni nzegema yepa apona. Adamuha ahande humpute hubhombele imbombo. ");
INSERT INTO sbk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lwe hwabha lyabhela, bhahabhaleta hwa Yesu abhantu abhimpepo. Abhaputila impepo zyepa bhapona. ");
INSERT INTO sbk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pepinipo gahaloleshe gala gegahayangwilwe nu ukuwa u Isaya aje, “U Yesu ahejile inpungo zyitu na ahazibhusizye imbina zyitu” ");
INSERT INTO sbk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","U Yesu lwahalola abhantu bhabhungine bhanzyunguliye, ahajile bhabhale uupande uwinji uwi nsumbi iya hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Unsimbi ahinza hwa Yesu ahaga, “Mwalimu, imbahufwate poponti pubhala.” ");
INSERT INTO sbk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","U Yesu amuzya imbweha zilina mina ni uyonyi zilinivyanswi, lakini u Yesu sali ni nyumba na pagone na pamo.” ");
INSERT INTO sbk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Umwanafunzi uwamwabho ahamwuzya ahaga, “Gosi ilabha uruhusa imbale insyile uyise wani.” ");
INSERT INTO sbk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini u Yesu ahamuzya ahaga, “Unifwate, bhaleshe abhafwe bhasyilane bhibho.” ");
INSERT INTO sbk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","U Yesu na ahinjila mwitooli, abhanafunzi bhakwe bhahinjiye mwitooli. ");
INSERT INTO sbk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aminzi, gaha yingana munsumbi mpaka itooli lyahagubishilwe na minzi, lakini u Yesu ahagonile. ");
INSERT INTO sbk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abhanafunzi bhakwe bhahinza hudamusye bhahaga twokole tihwanda afwe!” ");
INSERT INTO sbk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","U Yesu ahaga, “Muhwogopanshi, mubhilwitiho uludodo?” Ahadamuha na huyikhajile impepo ni nsumbi pamandi hwabha myee, ");
INSERT INTO sbk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","abhalume bhahaswijile bhaga, “Umuntu unu alibhulibhuli huje ni mpepo izya munsumbi zihumwitiha umwene?” ");
INSERT INTO sbk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","U Yesu lwa ahinza hunsi iya Magadala, abhalume bhabhili bhahali ni mpepo bhahakhomana nawo. Bhahafumiye humbipa bhahali bhakhali haani numo umuntu wahashilaga idala lila. ");
INSERT INTO sbk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bhahakholile na jeishi, tilinahenu nawe mwana wa Ngulubhi? Uyinzile ipa hutiyinvye ahabhalilizyo she hasili?” ");
INSERT INTO sbk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ishi hwahali impuga ingosi iyingurubhi lyahadimaga sepahali patali hani pebhahali, ");
INSERT INTO sbk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","impepo zyahalilaga hwa Yesu naje, “Tifume titwale mumpuga yingurubhi.” ");
INSERT INTO sbk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","U Yesu ahazibhuzya impepo ahaga, bhalaji mungurubhi. Impepo zila lwezyahinjila mungurubhi, ingurubhi zyahashimbiliye munsumbi afume, mwigamba zyahafwila muminzi. ");
INSERT INTO sbk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abhalume bhebhahadimaga ingurubhi bhashimbiye. Lwe bhahala humujini bhahayinje zyonti zyezyahafuniye hwa alume bhebhahali nimpepo. ");
INSERT INTO sbk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ikhaya yonti yahinza atangane nu Yesu. Lwe bhahanola u Yesu bhahamuzya aje ayepe mumpaha zyabho. ");
INSERT INTO sbk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","U Yesu ahinjila mwitoli, ahafwimila ahafiha hunsi ya hakhalaga. ");
INSERT INTO sbk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bhahanetela, umuntu ya polile ubili agonile pashitala. Lwahahulola ulwitiho lwabho u Yesu ahamuzya umuntu yapolile, “Mwanawi ushanje, ukhombhosheye imbibhi zyaho.” ");
INSERT INTO sbk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abhalimu bhamo abhilenga bhahayanjizanya bhibho hu bhibho, “Umuntu unu alinindigo” ");
INSERT INTO sbk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","U Yesu ahamanya insibho zyabho naje yeenu musibha imbibhi mumyoyo ginyu? ");
INSERT INTO sbk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Henu hehinza aje ikhobhosheye, 'Imbibhi zyaho na aje, 'imililila ujende?' ");
INSERT INTO sbk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ishi mumanye aje wa Adamu alini nguvu izyahubhakhobhoshele imbibhi.” ahayanjile izi hwula yapolile, “Imilila, uyitwinshe igodoro lyaho ubhale hukhaya yaho” ");
INSERT INTO sbk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Umuntu ula ahimilila nasogole abhale hukhaya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Impuga ya bhantu lwe bhahalola igo, bhahaswijile na huntime u Ngulubhi, yabhapiye inguvu izyo abhantu. ");
INSERT INTO sbk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","U Yesu lwahashilaga afume ipo ahanola umuntu yahwitwa itawa Mathayo, yahakhiye pebhafumizya insoho. Wope ahabhabhuzya, “Munfuate ani” Wope ahimilila ahafwata. ");
INSERT INTO sbk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","U Yesu lwahakhiye alye ishalye munyumba, bhahinzi bhebhafumya insoho bhabhinji na bhantu abhimbibhi bhahaliye peka ishalye nu Yesu peka abhasunde bhakwe. ");
INSERT INTO sbk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afalisayo lwe bhahalola isho bhahabhabhuzya abhasende bhakwe, yeenu u Yesu alya ishalye na bhantu abhafumya insoho na bhantu abhimbibhi?” ");
INSERT INTO sbk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","U Yesu lwa ahivwa igo, wope ahayanga “Abhantu bhesebhabhinile sebhahwanza unganga, ila bhebhabhinile. ");
INSERT INTO sbk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ihwanziwa huje mubhale mumanyile imaana yakwe, “Insungwa irehema siga izabihu” Pipo senahinzile hubhantu abhimbibhi. ");
INSERT INTO sbk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Abhasunde bha Yohana bhahinza hukwakwe na aje, “Yeenu ati na mafalisayo tifunga, lakini abhasunde bhaho sebhafunga?” ");
INSERT INTO sbk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","U Yesu ahabhabhuzya ahaga, Je abhalolezi bhi weji bhangaswimalwe bhali peka nu gosi wiweji? Lakini insiku zihwinza insiku ugosi wi weji ahayisogola pebhahayifunga. ");
INSERT INTO sbk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nuumo umuntu yabhiha ishipande shimwenda umpya humwenda uwimandi, ishulaka shibhadebushe afume humwenda na abazushe haani hubhafumile. ");
INSERT INTO sbk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nabhamo abhantu bhebhabhiha ihombwa mushombo ishihombwa inkuulu, nkushele bhabhomba, ingozi ibhadebushe ihambwa ibhafume na nanjishe. Badala yakwe, ubhiha ihombwa impya mungozi impya vyonti vibhabha salama. ");
INSERT INTO sbk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","U Yesu lwahabhabhuzya amambo iga, ahali, ugosi umo ahamwinamila mwilongolela lyakwe ahaga, “Unindu wani afwiye shinishi inza umponye abhapone abhabhe mwoomi. ");
INSERT INTO sbk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","U Yesu ahimilila na huusojelele na bhasunde bhakwe. ");
INSERT INTO sbk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ahali, ushi yahafumaga idanda amaha kumi na mbili ahasojelela pipi nu Yesu ahayikhata inkanzu ya Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pipo ahayile, “Nkushele na bhukhata umweudo wa Yesu imbapone.” ");
INSERT INTO sbk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","U Yesu ahagaluhana na humwenye na humuuzye, “Ninda uyipele umwoyo, nu ulwitiho lwaho lubhombile aje upone,” Ahabhalilizyo hiniho unshi ula ahapona. ");
INSERT INTO sbk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","U Yesu lwahafiha hukhaya ya gosi, ahabhalola bhebhakhoma ifilimbi na impuga ya bhantu yahakhomaga ahalanga. ");
INSERT INTO sbk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wope ahaga, “Epi ipa, unindu saafwiye agonile. Lelo abheene bhahanseshile haani. ");
INSERT INTO sbk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Abhantu bhala lwebha fuma hunzi, wope ahinjila huhati na hunkhate inyobhe unindu ahadamuna. ");
INSERT INTO sbk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inongwa zyahayeha insi yonti. ");
INSERT INTO sbk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","U Yesu lwahashilaga afume pala, abhalume bhabhili bhesebhahwenya amaso bhahausejelela. Bhahendeliye akhole bhahaga, “Tilabha utiponye, Mwana wa Daudi.” ");
INSERT INTO sbk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","U Yesu lwahafishile hukhaya, bhala bhesabhahwenya amaso bhahinza hukwake. U Yesu ahabhabhuzya, “Muhwitiha huje ingabhaponya?” Bhope bhahaga “Ena, Gosi” ");
INSERT INTO sbk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","U Yesu ahakhata amaso gabho naje zibhombeshe isho hulimwe ndeshe ulitiho lwinyu sheluhi” ");
INSERT INTO sbk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na amaso gabho gahanda ahwenye. Pe Yesu ahakhajilizya hunguvu na yanje “Mwenyaje umuntu wowonti asahamanye ijambo ili.” ");
INSERT INTO sbk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lelo abhantu bhabhili bhahasogoye alumbilile ahusu amambo iga isehemu zyonti izyinkhaya. ");
INSERT INTO sbk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pe pinipo abhalume bhala bhabhili lwe bhahasogolaga, ahali, umuntu umo aliyububu impepo zyahamwinjiye bhahaletwa hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Impepo lwezyahamwepa umuntu ububu ahanda ayanje. Impuga yahaswiga naje setilolile nkalumo amambo iga gegafumiye mu Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lelo afalisayo bhayangaga hwa gosi wi impepo ahugabhinga amapepo.” ");
INSERT INTO sbk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","U Yesu ahabhalile ikhaya zyonti ni vijiji vyonti. Ahendeliye amanyizye mumasinagogi, alumbilile izwi ilyibhumwene na ponye impungo zyonti nu bhuzaifu wonti. ");
INSERT INTO sbk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lwa ahenya impuga, ahabhaloleye inkumbu, pipo bhahayimbile navunzishe mumwoyo. Bhahali ndeshi ingole zyesazili nu udimi. ");
INSERT INTO sbk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wope ahabhabhuzya abhasunde bhakwe ahaga, “Amavuno minji, abhabhomba mbombo bhadodo. ");
INSERT INTO sbk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ishi lubhilo tinabhe ugosi wi mavuno, nke huje atume abhabhomba mbombo mugunda gwakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","U Yesu abhakwizya abhanafunzi bhakwe kumi na bhabhele peka nahupele amamulaka juu yimpepo imbibhi, hubha khalipile na habhadigizye na ponyle iayina zyonti zimagonjwa ni ayina zi mpongo. ");
INSERT INTO sbk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amatawa kumi na gabhele gatumwa. Lyawhande u Simeoni (ambaye tena agiziwaga yu Petro), nu Andrea ukolo wakwe, u Yakobo umwana wa Zebedayo, nu Yohana ukolo wakwe: ");
INSERT INTO sbk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","U Philipo, nu Bartelemayo, Thomaso, nu Mathayo usonkolezya uwushuru, u Yakobo umwana wa Alfayo, nu Tadeo, ");
INSERT INTO sbk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","U Simoni mkananayo, nu Yuda Iskariote, walisaliti. ");
INSERT INTO sbk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ebha kumi na bhabhele u Yesu abha sontelezezye. Nape abhaelekezezye ayanjile “Msahabhale isehemu uhabhakhala amataifa na msahinjile mizikhaya zya Bhasamalia. ");
INSERT INTO sbk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Badala yakwe, mubhale hungole zizitejile ziyumba yi Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na lwamubhala lumbililaji na yanje uwumwene wa humwanya upalamiye.' ");
INSERT INTO sbk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bhaponylaji abhabhinu, zyosyaji abhafwe, safisyaji bhiukoma na digizye impepo. Mposheleye wene fumyaji wene. ");
INSERT INTO sbk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Usaheje iwe lihela, ialmasi au ishaba mumpogoso zyenyu. ");
INSERT INTO sbk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Usaheje imbugulu katika isafari yenyu, au amenda giziada, vilyato au endesa, afatanaje umombi ahanziwa ishalye shakwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ikhaya yoyonti au ishijiji shamwayihijila, anzi wahubhafaa na mukhale epo hadi lwamwayisogola. ");
INSERT INTO sbk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lwamwayihinjila munyumba lamubhi, ");
INSERT INTO sbk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","nkesho inyumba ifaa, uwinza wenyu u syale epo, ila nkesho inyumba sigiifwa, uwinza wusogole peka namwe, ");
INSERT INTO sbk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na whabhala bhasaga bhahubhaposhela amwe au atejelezye amazu genyu, isala zyamusogola hunyumba au hukhaya eyo, jipukuti masuto gilwayo lwenyu pamahali epo. ");
INSERT INTO sbk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lyoli ihumbawozya, gayibha gajimbe hani amiji gi Sodoma ni Gomorah whisiku lilongwe kuliko umuji ago. ");
INSERT INTO sbk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Enyi, ihubhatuma hansi ingole pakasi yimbwalonde, eshi bhanje nuwelewa hansi inzoha na bhapomakati hansi enjebha. ");
INSERT INTO sbk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mubhanje bhenyelezi na bhantu bhanza hubhatwale humabaraza, na hubhakhome muvibhanza. ");
INSERT INTO sbk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mwayiletwa whilongolela lyabha gosi na bhamwene husabu yane, hansi usimisizyo humwawo na humataifa. ");
INSERT INTO sbk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hubala lwabhayituhumu, musahabhe niwasiwasi shinamunawele shayanje, afwatanaje ishintu shayanje mwayipewa husala eyo. ");
INSERT INTO sbk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Afwatanaje sagamwemwe mwayiyanga, ila Upepo wa Baba wenyu ayiyanga muhanti yenyu. ");
INSERT INTO sbk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Uholo ayihumwinushila uholo wakwe hugoje, baba whamwana wakwe. Abhana bhayiwhemelela dhidi ya pafi, na hubasababisizye ufwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namwe mwanyivitilwa na kila muntu husabu yitawa lyane. Ila wowonti wayijimbilila hadi humwisho umuntu oyo ayiauliha. ");
INSERT INTO sbk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Isala yabhahubhatesa katikaikhaya ene, shembelelaji ikhaya yifatila, lyoli ihabhawozya, zyonti zi Israeli kabla ya mwana wa Adamu sagawelile. ");
INSERT INTO sbk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Umwanafunzi saga gosi ashile umwalimu wakwe, wala umutumwa walihumwanya ya Gosi wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Itosya wha mwanafunzi aje abhe hansi umwalimu wakwe, nu mutumishi hansi u Gosi wakwe. Nkesho bhan'kwizizye Ugosi winyumba Belzabuli, hushiasi wele hani bhanzahubha kashifu bhinyumba yakwe! ");
INSERT INTO sbk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Esho basi musawogope abhene, afwatanaje hamuna ijambo lyasagalyayi kwinkuliwa, nalimo lilifishe lyasagalyaimanyiha. ");
INSERT INTO sbk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Shila shihubhawozya muhisi, shiyangaji umuzelu na shamushevwa huulayini mumakutu genyu mshitangazye lwamuli pamwanya yinyumba. ");
INSERT INTO sbk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mubawogope bhala bhabhagogo obele ila sagabhalinuwuwezo wagoje umwoyo. Badala yakwe, mogopaji ola wawezya ahangamizye ubele nu moyo hula whilongo. ");
INSERT INTO sbk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Eshi ikaziwa husenti indodo? Hata shesho enemo yiwezya agwe pansi bila ubaba wenyu amanye. ");
INSERT INTO sbk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ila hata iidadi yinsisi zyenyu zi bhaziwilwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mugaje abhe niwoga, afwatanaje mlinithani hani kuliko ikasuku inyinji. ");
INSERT INTO sbk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Esho basi kila weka wayihuneteha whilongolela lya bhantu, nane tena nayihumweteha whilongolela lya Baba wane walihumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ila uwene wayihukhana whilongolela lya bhantu, nane tena nayihukhana whilongolela lya Baba wane walihumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Musasebhe aje enenzele alete uwinza panse. Saganahenzele aete uwinza, ila ipanga. ");
INSERT INTO sbk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Afwatanaje nahenzele ahumehse umuntu ashindane nubaba wakwe, nu mwale dhidi ya maye wakwe, ukhoyi dhidi ya khoyi wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Umibhi wa muntu bhanzabhe bhabhala bha munyumba yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Uwene wagene ubaba au umaye hani kuliko ane oyo saga ahufhaa. Nu wene wagene ovwele au umwale hani kuliko ane oyo sagaahufhaa. ");
INSERT INTO sbk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uwene wasaga bhawhangate ikhobhehanyo na hufhate ane saga ahufhaa. ");
INSERT INTO sbk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uwene wayiwhanza ukhalo ayihugatezya. Ila uwene wayitezya ukhalo kwa ajili yane ayihwuwaga. ");
INSERT INTO sbk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Uwene wayihubhakaribisya ankalibisizye nene, nu mwene wayihunkalibisya ane ankalibisizye iwene wantumile ane. ");
INSERT INTO sbk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu mwene wayihunkalibisya ukuwe kwa sababu kuwe ayiposhela ithawabu ya kuwe. Nuwene wayihunkalibisya uwihaki kwa sababu muntu wihaki ayiposhela isawabu ya muntu wi haki. ");
INSERT INTO sbk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wowonti ayihupela weka wa dodo ebha, hata ishikombe shimenze gamwele gagakhateye, kwa sababu uwene yumwanafunzi, lyoli ihumbawozya, uwene sagayiwezya akose whidala lyolyonti ithawabu yakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yabha baada ya Yesu amale hubhaelekezye abhanafunzi bhakwe kumi na bhabhele asogoye hu plae abhale amanyizye na lombelele katika ikhaya zyawo, ");
INSERT INTO sbk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","nu Yohana lwali mwigereza lwahevwezye lwalihumwanya yimbombo zya Klisiti, atumile uwujumbe abhilile abhanafunzi bhakwe, ");
INSERT INTO sbk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na bhamozelezya, “Awe yoyola wawhenza au huliuwamwawo tiwhanziwa humwenyelezye?” ");
INSERT INTO sbk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","U Yesu ajibu na yanje humwawo “Bhaji mumozye u Yohana gala gamuhugalola na gala gamuhugevwa. ");
INSERT INTO sbk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abhantu bhasabhalola, bhapata alole, iviwete bhajenda, abhakoma bhatakasiha, abhantu bhasaga bhawhevwa bhahevwa tena, abhantu bhabhafwiye bhazyoswa apate uwomi, na abhantu bhabhanza bhalombelewa ihabari inyinza. ");
INSERT INTO sbk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na asayiwilwe ola wasagalola amashaka juu yane. ");
INSERT INTO sbk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Humuda abhantu ebha lwabhasogola, u Yesu ahandile ayanje ni mpoga juu ya Yohana, “Mwabhulile awhenye iyenu whijangwa __itete liyinzanywa ninkongu? ");
INSERT INTO sbk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ila yenu mwabhalile awhenye__ umuntu wakwete amenda amalayini? Lyoli, bhala bhabhakwata amenda amalaini bhakhala munyumba zishimwene. ");
INSERT INTO sbk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","10","Ila mwasogoye alole iyenu- Ukuwe? Ee, ihumbwawozya ni zaidi ya Kuwe. Ono yuyo wasimbiwilwe, 'Enya, ihutuma ujumbe wane whilongolela yimaso gakwe, wayi andaa idala iyaho whilongolela lyaho. ");
INSERT INTO sbk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ane ihumbawozya ilyoli, kati ya bhapapwilwe na bhashe nomo waligosi kuliko u Yohana umozyaji. Ila walidodo katika umwene wa humwanya gosi ashile umwene. ");
INSERT INTO sbk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Afume insiku zya Yohana umozyaji hadi isalezi, umwene wa humwanya wuli wengovo, na bhantu bhabhali bhengovo, bhahuwega hongovo. ");
INSERT INTO sbk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Afwatanaje akuwe ni ndajizyo, bhakuwilwe hadi wha Yohana. ");
INSERT INTO sbk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na nkesho mulitayari awheteshe, ono yu Eliya, ola wawhenza. ");
INSERT INTO sbk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wali na makutu gawhevwe nayevwaje. ");
INSERT INTO sbk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Endanganisye ni yenu ishi papo eshi? Shi fano shabhana bhabhawhanga mumaeneo gisoko, bhabhakhala na kwizanye ");
INSERT INTO sbk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","na yanje, 'Tabhakhomeye izomari na sagamwahanjile. Talilile na sagamwakholile.' ");
INSERT INTO sbk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Afwataje u Yohana ahenzele bila alye amabumunda au amwele ihombwa, na bhabha bhayanga, 'Ali ni pepo.' ");
INSERT INTO sbk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Umwana wa Adamu ahenzele alya na mwele na bhayanga 'Enya, muntu unylavi na ukholwe, rafiki wa sonkola uwushuru na bhimbibhi!' Ila injele iloleha humbombo zyakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","U Yesu ahandile huyikhalipile ikhaya ambamo baadhi yimbombo zyakwe zimayele zyatendebhe, afwatanaje bhuli sagabhutubule, ");
INSERT INTO sbk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ahele waho, Kolazini, Ole waho Bethsaida! Nkesho imbombo ingosi gngwawombeshe hu Tiro na Husidoni gala gagawombeshe epa, andi bhatubule hale whakwate amagunila na hujipashe amalota. ");
INSERT INTO sbk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ila yayibha ujivwi hu Tiro ni Sidoni isiku lilongwi kuliko hulliwe. ");
INSERT INTO sbk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aise, Kapernaum, ubheshele wayiwosewa hadi humwanya? Ndadi wayiwhiswa hadi pansi whilongo. Hansi hu Sodoma hungawombeshe matendo amagosi, hansi gagawombeshe huliwe andiileho hadi ilelo. ");
INSERT INTO sbk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eshi iyanga huliwe aje yayibha vyepesi honse yi Sodoma awhemelele whisiku lilongwi kuliko awe. ");
INSERT INTO sbk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Katika humuda ogo u Yesu ayanjile, “Ihutema awe, Baba, Gosi wahumwanya na panse, husababu wabhafisile amambo ega bhinjele vwelewa, na hugagubule whabhasaga bhali ni elimu, hansi abhana abhadodo. ");
INSERT INTO sbk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Baba afwatanaje yasongozewelwe esho pamaso gaho. ");
INSERT INTO sbk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Amambo gonti impewilwe ane afume wha Baba. Na nomo wamenye u Baba ila umwana, na wowonti ambaye umwana ali ni hamu ya hugubulile. ");
INSERT INTO sbk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Enzi huline, amwe mwenti mumuyemba na wuwonelwa na mazigo amamwamu, nane imbahubhatozye. ");
INSERT INTO sbk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jiponyaji ijoko lyane na mumanyilaje afume huline, afwatanaje ane niwawhishe na mpole wimoyo na munza pate ulotoyo lwi nafsi zyenyu. ");
INSERT INTO sbk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Afwatanaje ijoko lyane lilayini na izigo lyane lipoposu. ");
INSERT INTO sbk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Umuda ogo u Yesu abhalile isiku litoyo ashilile humagonda. Abhanafunzi bhakwe bhali ni nzala na bhanda avunze amansale na hugalye. ");
INSERT INTO sbk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ila Amafarisayo lwabhalola ego, bhamozya u Yesu “Enya abhanafunzi bhaho bhavunza indajizyo bhawomba isiku zasagagaluhusiwilwe isiku lilutoyo.” ");
INSERT INTO sbk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ila u Yesu abhawozya, “Sagamubhazizye u Daudi shawombile, umuda lwali ni nzala, pamoja na bhantu bhalinawo? ");
INSERT INTO sbk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Shahinjiye muhati yinyumba ya Ngulubhi nalye amabumunda gilulolesyo, ambago sagayahali halali hukwakwe alye nabhala bhalinawo, ila halali whadimi? ");
INSERT INTO sbk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bado saga mubhazizye katika indajizyo, aje katika isiku lilutuyo ndimi muhati yishibhanza bhahuyinanganya ilutoyo, ila sagabhali ni hatiya? ");
INSERT INTO sbk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ila iyanga humwenyu aje wali gosi kuliko ishibhanza aleho epa. ");
INSERT INTO sbk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nkesho mwamenya eli lijulisya iyenu; iwhanza irehema na saga insayo; andisagamwalonjile bhasaga bhali ni hatiya, ");
INSERT INTO sbk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Afwatanaje Umwana wa Adamu ndiyo Gosi wilutoyo.” ");
INSERT INTO sbk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tena Uyesu asogola pala abhala hushibhanza shawo. ");
INSERT INTO sbk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Enya whali nu mundu wapolile inyobhe. Amafarisayo bhamozelezya u Yesu, bhayanga. “Eshi, sawa aponyile isiku lilutoyo?” ili aje bhawezye hunshitaki wha wombe imbibhi. ");
INSERT INTO sbk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","U Yesu abhawozya, “Yunanu pakasi yenyu, wali ni ngole yeka, neyo ingole yagwa mhati yishimo isiku lilutoyo, sagabhahuyileme na huyefwe hongovo muhati yishimo? ");
INSERT INTO sbk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eshi, shipimo shishili shithamani, hani huje, saga hani yingole! Eshi shinza awombe aminza ibiku lilutoyo.” ");
INSERT INTO sbk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tena u Yesu amozya ola umuntu, “Nyosya inyobhe yaho” Ayinyosya napate uwinza hansi ela iyamwawo. ");
INSERT INTO sbk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ila Amafarisayo bhafuma honze bhapanga inamuna shahunteketezye bhabhalile honze apanje hushinyume shakwe. Bhawhanzaga inamuna yahugoje. ");
INSERT INTO sbk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","U Yesu lwahelewa elyo asogoye epo. Abhantu abhinji bhafwatile, na abhaponyila bhonti. ");
INSERT INTO sbk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Abhalajizizye bhasahafanye afahamishe hubhamwawo, ");
INSERT INTO sbk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","aje ikamilishe ela ilyoli, yaya yangwilwe nukuwe u Isaya, ayanjile, ");
INSERT INTO sbk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Enya, mombi wane wisaluye, ugonwe wane, katika uwene inafusi yane isongwezwe. Imbabhoshe umpepo wane humwanya yakwe, na abhatangazye ulongwe humataifa. ");
INSERT INTO sbk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sagaayihangayiha wala alile hungovo; wala waliwowonti awhevwe isauti yakwe mumitaani. ");
INSERT INTO sbk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sagaayihulibudala itete lilialushe, sagayizimanya uwutambi wowonti wuwufumya ilyosi, hadi lwayileta ulongwe lwamena. ");
INSERT INTO sbk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na Mataifa bhayibha udandamazu mwitawa lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Umuntu omo ukipofu nu bubu, wachanganyishiwilwe ni pepo aletilwe whilongolela lya Yesu. Aponilwe, pamoja namatokewo gaje umuntu ububu ayanjile na lole. ");
INSERT INTO sbk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amakutano wonti bhaswijile na yanje, “Awezya umuntu ono abhe mwana wa Daudi?” ");
INSERT INTO sbk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ila umuda Amafarisayo lwabhahevwa amayele ega, bhayanjile, “Ono umuntu sagaafumya impepo hungovo zyakwe yuyo ila hongovo zya Belzebuli, ugosi wimpepo. ");
INSERT INTO sbk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","“Ila u Yesu lwamunya insewo zyawo na hubhawozye, “Kila umwene wuwugabhanyishe uwene wunanjiha, na kila ikhaya au inyumba yigabhanyiha yene sagayayihemelela. ");
INSERT INTO sbk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nkesho Usetano, abhahumwefwe Usetano, bhasi ahujikhana hunafsi yakwe mwene. ");
INSERT INTO sbk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni namuna wele uwomwene wakwe ubhawhemelele? Na nkesho ifumya ipepo hongovo zya Belizabuli, abhafwasi bhenyu bhafumya whidala wele? Wheli bhayibha bhalonzanyi bhenyu. ");
INSERT INTO sbk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na nkesho bhafumya ipepo hongovo zya Mpepo wa Ngulubhe, eshi umwene wa Ngulubhi wenzele humwenyu. ");
INSERT INTO sbk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nu muntu abhawezye wele awhinjile muhati yinyumba yewe ngovo na whibhe, bila hupinye wengovo kwanza? Epo panzawhibhe intabhalo zyakwe afume muhati yinyumba. ");
INSERT INTO sbk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wowonti wasagaali pamoja nane ali shinyume shane, nape wasaga awonganya pamoja nane uyo asambazya. ");
INSERT INTO sbk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eshi iyanga humwenyu, kila imbibhi ni kufuru abhantu bhayisamehewa, ila ahukufuru Umpepo ufinjile sagabhayisamehewa. ");
INSERT INTO sbk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na wowonti wayanga izu shinyume cha Mwana wa Adamu, elyo ayisamehewa. Ila wowonti wayanga shinyume nu Mpepo ufinjile, oyo sagayisamehewa, honse ene na wala ela yiwhenza. ");
INSERT INTO sbk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Au liwombe ikwi abhe linza nitunda lyakwe linza, au linanganye ikwi ni tunda lyakwe, afatanaje ikwi limanyiha whitunda lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amwe bhimpapo bhi nzoha, amwe mulibhabhibhi, muwezizye ayanje amambo aminza? Afatanaje ilomu liyanga afume mumbeho gagali mumoyo. ");
INSERT INTO sbk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umuntu umwinza humbeho inyinza yahumoyo gwakwe afumya inyinza, na umuntu umibhi humbeho imbibhi yimoyo gwakwe, afumya shishili shibhibhi. ");
INSERT INTO sbk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ihumbawozya whisiku li longwi abhantu bhayifumya ihesabu yikila izu lyasaga lili ni mana lyabhayanjile. ");
INSERT INTO sbk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Afwatanaje humazu gaho ayibhaziwa ihaku na humazu gaho wayilongwa.” ");
INSERT INTO sbk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tena baadhi ya simbi na Mafarisayo bhajibule u Yesu bhayanjile “Mwalimu, tasongwezye alole iishara afume huliwe.” ");
INSERT INTO sbk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ila Uyesu ajibule na hubhawozye, “Ishipapo ishibhibhi na shiumulala shiwhanza iishara. Ila nemo iishara yifafumwe humwawo ila ela iishara ya Yona ukuwe. ");
INSERT INTO sbk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hansi shila u Yona shahali muhati yivyanda vinswe ingosi hunsiku zitatu shasenya na nusiku, esho shesho Umwana wa Adamu shanzabhe muhati gwimoyo gwense hunsiku zitatu shasenya na nu siku. ");
INSERT INTO sbk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Abhantu bhi Ninawi bhayihemelela whilongolela pamoja nishipapo sha bhantu ebha na bhayihushilonga. Afwatanaje walitubu humalombelelo ga Yona, na enya, umuntu omwugosi wizaidi ya Yona aleho epa. ");
INSERT INTO sbk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Umalikiya wahukusini aiwhemelela hulongwe peka na bhantu bhishi papo eshi nahushilonje. Ahenzele afume humwisho wense ahenze atejelezye injele ya Selemani, na enya, umuntu omo ugosi ashile u Selemani aleho epa. ");
INSERT INTO sbk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Umuda ipepo ibhibhi lwalihufuma umuntu, lishilila isehemu yasagaili na menze liwhanza patoye, ila sagilihupalola. ");
INSERT INTO sbk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tena ayanga, 'Imbawele hunyumba yane yinfumile.' Lwawela ahuyaga ela inyumba ifanyiwilwe uwusafi na ili tayali. ");
INSERT INTO sbk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tena abhala na hubhalete abhanje impepo imbibhi saba zizilimbibhi hani ashile iyene, bhahenza akhale wonti pala. Ni hali yakwe ya humwisho ibha mbibhi azidi iyawhande. Esho shasho shayayibha hushipapo eshi ishibhibhi. ");
INSERT INTO sbk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Umuda Uyesu lwazyongolaga ne mpoga enya, umaye wakwe na holo bhakwe bhahemeleye honze, bhahanzaga ayanje nawo. ");
INSERT INTO sbk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Umuntu weka amozya, “Enya umaye waho na aholo bhaho bhemeleye honze, bhawhanza ayanje nawe”. ");
INSERT INTO sbk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ila u Yesu ajibule na hubhawozye wamozezye, “Umaye wane yu nanu? Na aholobhane bhananu?” ");
INSERT INTO sbk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nape anyosizye inyobhe yakwe whabhanafunzi na yanje, “Enya, ebha bhamaye naholo bhane! ");
INSERT INTO sbk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Afwatanaje wowonti wawomba amagano ga Baba wane wali humwanya, umuntu oyo ndiyo holo wane, uyilombo wane numaye wane.” ");
INSERT INTO sbk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Whisiku lila u Yesu asogoye munyumba na khale hunshenje yibahavi. ");
INSERT INTO sbk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Empoga ingosi yiwongene whahu zyongole, ahinjiye mkasi yitoli nakhale mhati yakwe. Empoga yonti yahemeleye hunshenje yibahari. ");
INSERT INTO sbk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tena u Yesu ayanjile amazu aminji hushifwani, ayanjile, “Enya, utote abhalile atote. ");
INSERT INTO sbk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lwatotaga baadhi yimbeyu zyagwiye hunshenje yidala ni nyonyi zyahenzele zyajobile. ");
INSERT INTO sbk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imbeyu izyamwawo zyagwiye pamwanya yipakhome, ambazyo saga zyapatile ilongo lyakwelane. Gafla zyamelile afwatanaje ilongo sagalya li nishimo. ");
INSERT INTO sbk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tena isenya lwalyatukula zyapembwilwe kwa sababu sagazuali namazi zyahoma. ");
INSERT INTO sbk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeyu izyamwawo zyagwiye muhati yimakwi gimivwa. Amakwi gimivwa gatalimpine humwanya gaziziba. ");
INSERT INTO sbk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imbeyu izyamwawo zyagwiye mwilongo ilinza na pape imbeyu, zimo mara mia moja hani, zimo sitini ni zyamwawo thelasini. ");
INSERT INTO sbk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wali namakutu ayevwaje. ");
INSERT INTO sbk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhanafunzi bhahenzele nahumozye u Yesu, “Yenu uyanga numukutano hushifwani?” ");
INSERT INTO sbk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","U Yesu abhajibu abhawozya, “Mupewilwe uganilizi wa manye isiri ziumwene wahumwanya, ila humwao sagabhapewilwe. ");
INSERT INTO sbk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ila wowonti walinasho, whamwene anzahonjezewe hani, na ayipata ifaida ingosi. Ila wasagaalinasho hata shila shali nasho ayifyolwa. ");
INSERT INTO sbk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Esho alihizya anawo hushifwani husababu hata bhalola, sagabhalola lyoli. Na hata bhahevwa sagabhahevwa wala ahelewe. ");
INSERT INTO sbk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ukwe wa Isaya wutimiye humwawo, wula wuwuyanga, “Iwamuhevwa sagamuhevwa, ila hunamuna yoyonti ela sagamumanya. ");
INSERT INTO sbk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na moyo gabhantu ebha galihisi, shikhome ahevwe, na bhagubishe amaso gawo, ili bhasawezye alole humaso gawo, au ahovwe humakutu gawo, au amanye humoyo gawo, esho bhangewushilaga tena, nenzagahubhaponyle.' ");
INSERT INTO sbk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ila amambo genyu gasayiwilwe, afwatanaje galola, namakutu genyu afwatanaje gawhevwa. ");
INSERT INTO sbk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lyoli iwhumbawozya akuwe abhinji na bhantu bhihaki bhali ni hamu yalole amambo gala gamuhu galola, sagabhawezizye hugalole. Bhasongwelwe awhevwe amambo gula gamuhugevwa, sagabhagevwelwe. ");
INSERT INTO sbk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Eshi tejelezi umufano gwatote. ");
INSERT INTO sbk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Isala yeyonti lwahevwa izu liumwene na asalyelewe, epo umibhi awhenza nahushifwampe shishi malishe atotwe muhati yimoyo gwakwe. Ene mbeyu ela yitotilwe hunshenje yidala. ");
INSERT INTO sbk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uwene watolile mukhome yoyola ahulyevwa izu na huliposhele whadigane hulusongo. ");
INSERT INTO sbk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bado sagaalinamazi muhati yakwe, ila ajimbilila humuda ufupi uwakati amashida au mayemba lwagafumila kwa sababu yizu abomela gafla. ");
INSERT INTO sbk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Watotile mhati yimivwa, ono yoyola wahevwa izu ila amatatizo gense nu gobezi wi utabhazi guhulifuniha lila izu lisahapape amatunda. ");
INSERT INTO sbk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Watotilwe mwilongo ilinza, ono yoyola wahulyevwa izu na hulyelewe ono yoyola wapapa amatunda na whendelele apape lyeka hani yimala mia, ilyamwowo sitini, iyamwawo thelathini.” ");
INSERT INTO sbk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","U Yesu abhapiye usifwani ishamwawo. Ayanga, “Umwene wa humwanya ulenganiswa nu muntu watotile imbeyu inyinza mugonda gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ila abhantu lwabhasinzila, umibhi wakwe ayenza nape atota amagogo mhati yingano tena abhala mweene. ");
INSERT INTO sbk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pamande ingano lwayamela na fumye amazawo gakwe, nape amagogo gajitokezyezye. ");
INSERT INTO sbk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na awombi bhamwenesho gonda bhahenza bhamozya, 'Gosi, sagawatotile imbeyu inyinza mogonda gwaho? Iliwele eshi lili namagogo? ");
INSERT INTO sbk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Abhawozya, umibhi awombile eli.' Awombi bhamozezye, “Eshi uwhanzaje tibhale tigasenye?” ");
INSERT INTO sbk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","We gonda ayanjile, 'Ndadi, umuda gwamusenya amagogo munzasenye pamo ni ngano. ");
INSERT INTO sbk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Galeshi gakule pamo hadi umuda gwa vune. Isala zimavuno nayiyanga whavunaji, 'Kwanza senyi amagogo nagapinyi mpoga mpoga nahugapembe, ila kusanyi ingano mwighala lyane.” ");
INSERT INTO sbk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tena u Yesu abhafumizizye ishifani ishawawo. Ayanga, uwumwene wa humwanya ulengene ni mbeyu yiharadali ambayo umuntu ahejile na huyitote mogonda gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeyu ene huwuhakika ndodo ashile imbeyu izyamwawo zyonti. Ila nkayamela ibha ngosi ashile amakwi gonti gamubustani, libha likwi, ikiasi aje inyonyi zya humwanya ziwhenza na zenje vitenjeli mmatawi gakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Abhawozya ishifani ishamwawo tena, “Uwumwene wahumwanya hansi usafu wula yiyegwiwilwe noshe nahuyisanganye huvipimilo vitatu huwusu hadi vitute. ");
INSERT INTO sbk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ego gonti u Yesu gayanjile whempoga yabhantu hushifwani. Na nila shifwani sagayanjile shoshonti humwawo. ");
INSERT INTO sbk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eli lyali aje shila shashamalishe ayangwe ashilile akuwe shiwezye atimile, pala payangaga, “Nayiwhasama ilomu lyane hushifwani. Nayiyanga amambo gala gagaleho gafisiwilwe afume umusingi gwense.” ");
INSERT INTO sbk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tena u Yesu abhaleshile amakutano na bhale kukhaya. Abhanafunzi bhakwe bhamaliye nayanje, “Tifafabulile ishifani shimagogo gahugonda.” ");
INSERT INTO sbk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","U Yesu ajibu nayanje, “Watolile imbeyu inyinza yumwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ugonda anse; ni mbeyu inyinza, ebha bhana bhiemwene. Amagogo bhana bhola umibhi, numibhi wazitotile yusetano. ");
INSERT INTO sbk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na mavuno mwisho wense, na wavunaji yuntumi. ");
INSERT INTO sbk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hansi shila amagogo shagakusanywa na pembwe mmoto, asho shesho shayayibha pamwisho wense. ");
INSERT INTO sbk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Umwana wa Adamu ayihusontelezya untumi wakwe, na wonganye afume umwene wakwe amambo gonti gagasababisizye imbibhi na bhala bhabha womba imbibhi. ");
INSERT INTO sbk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bhayihubhataga wonti mwitanulu li moto, ambaho whayibha iholo nasye amino. ");
INSERT INTO sbk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Epo abhantu bhi haki lwabha yizelupa hansi isenya mwiwumwene wa Baba wawo. Umwene wali namakutu na ayevwaje. ");
INSERT INTO sbk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Umwene wahumwanya ulihansi ihazina yifisiwilwe mugonda. Umuntu ayilola nahuyifise. Katika ulusongo lwakwe abhala akazye vyonti vyalinavyo nakale ogonda. ");
INSERT INTO sbk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tena, uwumwene wa humwanya uli hansi umuntu wawomba ibiashara ahanza ilulu yi thamani. ");
INSERT INTO sbk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Umuda gwayilola ela yi thamani, abhala akazya kila hantu shali nasho na huyikale. ");
INSERT INTO sbk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Uwomwene wa humwanya ulihansi ulwego wauli muhati yibahari, naluwonganya iviwumbe vinamuna yonti. ");
INSERT INTO sbk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwalwamema ulwego bhaluvutiye pamwanya. Tena bhakhala pansi bhawonganya ivintu ivinza muhati yivyombo, ila vyasaga vili ni thamani vyatagwilwe uhutali. ");
INSERT INTO sbk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yayibha inamuna ene humwisho wense. Antumi bhayihenza nahubhatenje abhantu abhabhibhi afume mu myongoni mubhihaki. ");
INSERT INTO sbk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na tagwe muhati yitanuli limoto, uho whayibha akhole nasye amino. ");
INSERT INTO sbk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mumenye amambo gonti ega? Bhanafunzi bhajibule, “Ee.” ");
INSERT INTO sbk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tena u Yesu abhawozya, “Kila simbi wali mwanafunzi wiwumwene alengene numwenebho nyumba wafumya muhazina yakwe ivintu ivipya nivihale.” ");
INSERT INTO sbk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Baada ya Yesu lwamala amifano gonti ego, asogola isehemu eyo. ");
INSERT INTO sbk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tena u Yesu afiha humukowa gwakwe nahubhafundizye abhantu mwishibhanza. Amatokeo gajwe bhaswijile nayanje, “Hoshi umuntu ono whapatile injele ene na mayele ega? ");
INSERT INTO sbk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Umuntu ono saga mwana wa Seremala? Umariamu saga mayewakwe? Na aholo bhakwe saga yu Yakobo, Yusufu, Simoni nu Yuda? ");
INSERT INTO sbk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na ayilombo bhakwe filinabho penepa pamwetu? Eshi umuntu ono agaje whi ega gonti?”. ");
INSERT INTO sbk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Abhavisizye, ila u Yesu abhawozezye, “Ukuwe sagakosa abhe ninshinshi ila humwawo na honse yawo. ");
INSERT INTO sbk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na sagawezizye awombe amayele aminji kwa sababu sagabhali nolweteho anawo. ");
INSERT INTO sbk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Husala ezyo, Uherode ahevwezye ihabari ya Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Abhawozya ahoyi bhakwe, “Ono yu Yohana Umozyaji azyoshele afume whazimu. Eshi engovo ezyo zili hukwakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Afwatanaje u Herode ali anemile u Yohana apinya na hutaje mwijela husababu ya Herodia, oshe wa Filipo okolo wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Afwatanaje u Yohana amozezye, “Sagashinza ahumweje umwene abhe shee wakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","U Herode andiagojile ila ahogope abhantu husababu bhanolile u Yohana aje kuwe. ");
INSERT INTO sbk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ila isala ninsiku zya papwe u Herode lwazyafiha umwale wa Herode ahanjile pakasi ya bhantu nahasongwezye u Herode. ");
INSERT INTO sbk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Katika ajibu shila shasobhe zezye hundapo aje anzahupele shoshonti shanzalabhe. ");
INSERT INTO sbk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Baada yashauliwe nu maye wakwe, ayanjile, “Mpele ane epa pikombe itwe lya Yohana Umozi.” ");
INSERT INTO sbk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Umwene ali na masikitiho humalawo gamwale, ila kwa ajili yindapo zyakwe, afwatanaje wonti bhabhaleho pashalye pamo numwene ayanjile aje lifanyishe. ");
INSERT INTO sbk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Atumile u Yohana aletwe afume whigeleza, ");
INSERT INTO sbk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ili atemwe itwe lyakwe na litemwe pamwanya yisinia na apewe umwale na alitwale whamaye wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tena abhanafunzi bhakwe bhenza awheje gula ombele na syele, baada yeli bhabhalile humozye u Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nape Uyesu lwahevwa ega, ajitenga afume isehemu ela azubha mukasi yimashua abhala esehemu yijitenjile. Umuda empoga lwayanya whali, bhafwatile lwimanama afume humijini. ");
INSERT INTO sbk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tena u Yesu ahenzele whilongolela lyawo alola empoga ingosi. Abhalolela enkombo na hubhaponyle impongo zyawo. ");
INSERT INTO sbk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ishalyabhela yakamiliha, abhanafunzi bhahenza hukwakwe na yanje, “Ene sehemu yijangwa ni siku tayari lishilile. Bhatabhanye amakutano ili bhabhale muvijiji ni bhakale ishalye kwa ajili yawo. ");
INSERT INTO sbk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ila Yesu ayanjile, “Sagabhali ni haja yabhalebhewo. Bhapeli amwe ishalye” ");
INSERT INTO sbk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bhamozya, “Epa tilinago amabumunda gasanu neswe zebhele tu.”' ");
INSERT INTO sbk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","U Yesu ayanga, “Galeti huline.” ");
INSERT INTO sbk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tena u Yesu ayiwozya empoga akhale pansi yimasole. Ayega amabumunda gasanu neswe zebhele. Ayenya humwanya, asaya nabudulanye amabumunda abhapela abhanafunzi. Abhanafunzi bhayipela empoga. ");
INSERT INTO sbk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhalya wonti bhihuta. Tena bhavikusanya ivipande vyonti vishalye nameme iviseje kumi navibhele. ");
INSERT INTO sbk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bhala bhabhaliye bhabhakadiliya aje abhalume elfu zisanu bila yabhazye abhashe na bhana. ");
INSERT INTO sbk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mara heka abhawozya abhanafunzi bhinjile mukasi yimashuwa, isala ezyo umwene abhalaga empoga bhabhaje bhewo. ");
INSERT INTO sbk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lwabhalaga empoga bhabhala bhene, azubha pamwanya yigamba apute mwene. Isala lwayali yilyabhela alihoho mwene. ");
INSERT INTO sbk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ila eshi imashua lwayali pahati yibahari yayumbaga husababu yimawimbi kwani inkongu yali yimpisho. ");
INSERT INTO sbk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Katika uusiku wi zamu ya nne u Yesu abhasojeleye ajenda pamwanya yemenze. ");
INSERT INTO sbk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Isala abhanafunzi bhakwe lwabhanola ajenda pamwanya yi bahari, bhahogope nayanje, “Yuzimu ka,” na zuvye isauti katika ihali yiwoga. ");
INSERT INTO sbk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","U Yesu abhawozya heka, ayanga, “Jipelaji umoyo! Nene! mugajihogope.” ");
INSERT INTO sbk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","U Petro anjibu whayanje, “Gosi, nkesho wewe, mbozye enenze huliwe pamwanya yimenze.” ");
INSERT INTO sbk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","U Yesu ayanga, “Enza.” Esho Upetro afuma mukasi yimashua na ajenda pamwanya yimenze abhale wha Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ila u Petro lwalola amawimbi, ahogope, na whande adwine, pansi, akwizya husauti nayanje, “Gosi, nokole!” ");
INSERT INTO sbk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Digana Yesu anyosya inyobhe yakwe amosya u Petro, na humozye, “Awe wilweteho udodo, yenu ulinamashaka?” ");
INSERT INTO sbk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Epo u Yesu nu Petro bhahinjiye mumashua, inkongu yaleshile avugule. ");
INSERT INTO sbk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Abhanafunzi mmashua bhansayile u Yesu na yanje, “Lyoli awe wamwana wa Ngolobhi.” ");
INSERT INTO sbk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na lwabhafwemela, bhafishile panse yi Genesareti. ");
INSERT INTO sbk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na bhantu bhi sehemu ela lwabhamanya u Yesu, bhatumile uujumbe kila sehemu zipembeni nahunete kila wabhinile. ");
INSERT INTO sbk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhamozezye aje bhawezye aguse ikunjo limwenda gwakwe, na bhinji bhabhagubile bhaponilwe. ");
INSERT INTO sbk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na Amafarisayo na asimbi bhahenzele wha Yesu afume Huyerusalemu. Na yanje, ");
INSERT INTO sbk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Yenu abhanafunzi bhananganya amalisizi gazehe? Afwatanaje sagabhanawa inyobhe zyawo lwabhalya ishalye.” ");
INSERT INTO sbk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","U Yesu abhajibu nahubhawozya, “Namwe__ yenu munanganya indajizyo ya Gosi kwa ajili yamalisizi genyu? ");
INSERT INTO sbk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Afwatanaje o Ngolobhi ayanjile, 'Ubheninshinshi wha baba waho nu maye waho; na 'Wayanga imbibhi wha baba wakwe na whamaye wakwe, na hakika afwe.' ");
INSERT INTO sbk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ila amwe muyanga, na wahumozya ubaba wakwe nu maye wakwe, “Kila ulwavwe ambalo andapatile afume huline eshe mpesya afume wha Ngolobhi,” ");
INSERT INTO sbk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Umuntu oyo sagaalinihaja yabheninshinshi wha baba wakwe. Katika inamuna ene mubadilisizye izulya Ngolobhi kwa ajili yimalisizi genyu. ");
INSERT INTO sbk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amwe bhanafiki, shinza hansi u Isaya shakuwilwe pamwanya yenyu shayanjile, ");
INSERT INTO sbk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Abhantu ebha bhahwfpanyila inshinshi ane humalomu gawo, ila amioyo gawo galihutali nane. ");
INSERT INTO sbk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bhahunsaya wene, kwa sababu bhafundizya amamanyizyo agali malajizyo gabhanadamu.” ");
INSERT INTO sbk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Epo abhakwizizye ikusanyiho na hubhawozye, “Tejelezi na mumanye__ ");
INSERT INTO sbk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nahamo ahantu hahahinjila mwilomu lya muntu nahumombe ubhibhi. Ila, shila shishifuma mwilomu eshi shesho shimomba umuntu abhe mibhi.” ");
INSERT INTO sbk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Epo abhanafunzi bhamalila nayanje nu Yesu, “Eshi!, Uwhele Amafarisayo lwabhalyevwa lila izu bhavisiwilwe?” ");
INSERT INTO sbk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","U Yesu abhajibu na yanje, “Kila likwi lwasagatotile ubaba wane wahumwanya lyayisenywa. ");
INSERT INTO sbk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bhaleshi bhene, abhene bhalongozi bhivipofu. Hansi umuntu shipofu abhahunongozye ushipofu uwamwawo, wonti bhabhele bhanzagwe mwilende.” ");
INSERT INTO sbk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Upetro ajibu na humozye u Yesu, “Tiwozye umfano ogu hulite, ");
INSERT INTO sbk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","U Yesu ajibu, “Namwe bado sagamuhelewa? ");
INSERT INTO sbk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Namwe sagamuwhenya aje shila shishi bhala mwilomu shishilila muvyanda na bhale muchoho? ");
INSERT INTO sbk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ila ivintu vyonti vivifuma mwilomu vifuma mhati yimoyo. Shesho ivintu vihumeha umuntu ubhibhi. ");
INSERT INTO sbk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Afwatanaje katika umoyo gafuma amawazo amabhibhi, ugoji, uumalaya, uashelati, uwibha, uashuda wilenga ni ndigo. ");
INSERT INTO sbk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ega gamambo gahumeha umuntu ubhibhi. Ila alye bila anawe inyobhe sagahuumomba umuntu abhe mibhi.” ");
INSERT INTO sbk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Epo u Yesu ayepa isehemu ela nahujisegusye aeleshela uhupande wi miji gi Tiro ni Sidoni. ");
INSERT INTO sbk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Enya ayenza onshe Umkanani afume uwupande owo. Azuvya isauti ayanga, “Ndolele inkombo, Gosi, Mwana wa Daudi; umwale wane ayemba hani ni mpepo.” ");
INSERT INTO sbk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ila u Yesu sagaajibule izu. Abhanafunzi bhakwe bhenza bhanabha bhayanga, “Mwefwe abhaje ulwakwe, maana ahutikhomela ihalanga.” ");
INSERT INTO sbk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","U Yesu abhajibule nayanje, Saganatumwile wha muntu wowonti ila whingole zizitejile zinyumba yi Israeli.” ");
INSERT INTO sbk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ila ahenzele na whiname whilongolela lyakwe, ayanga, “Gosi navwe.” ");
INSERT INTO sbk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ajibule na yanje, “Sagashinza awheje ishalye shabhana na huzitajile embwa.” ");
INSERT INTO sbk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ayanga, “Eshi, Gosi, hata esho embwa indodo zilya ishalye shishigwa pameza pa Gosi wawo.” ");
INSERT INTO sbk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Epo u Yesu ajibu na yanje “Anshe, ulweteho lwaho gosi.” Na ifanyishe huliwe hansi shuwhanza.” Nu mwale wakwe ali aponile husala yeyo. ");
INSERT INTO sbk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","U Yesu asogoye isehemu ela nabhale karibu ni bahari yi Galilaya. Tena abhala humwanya yigamba na khale oho. ");
INSERT INTO sbk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Empoga ingosi yahenza hukwakwe. Na hunetele bhasaga bhajenda avipofu, abubu, bhishilema na bhanje vinji, bhabhali bhabhinile. Bhabhabheshele pamanama ga Yesu abhaponyla. ");
INSERT INTO sbk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na bhene empoga bhaswijile lwabhalolile amabubu bhayanga, ni vilema bhabhewha womi, aviwete bhajenda, nivipofu bhalola. Bhatemele Ongolobhi wi Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","U Yesu abhakwizizye abhanafunzi bhakwe nayanje, “Imbaloleye inkombo impoga, husababu bhali nane hinsiku zitatu bila alye ahantu hohonti, sigimbahubhalaje bhabhale humwawo bila alye, bhasa hazimile mwidala.” ");
INSERT INTO sbk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abhanafunzi bhakwe bhamozya, “Tibhawezye apate amabumunda gatosye epa pinyiha awhigutizye empoga ingosi eshi?” ");
INSERT INTO sbk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","U Yesu abhawozya, “Muli na mabumunda galenga?” Bhayanga, “Saba, neswe indodo ndodo.” ");
INSERT INTO sbk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U Yesu ayiwozya empoga ikhale pansi. ");
INSERT INTO sbk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ahejile gala amabumunda saba neswe, na baada ya husalifwe, agamensula na hubhapele abhanafunzi. Abhanafunzi bhabhapela empoga. ");
INSERT INTO sbk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abhantu bhonti bhalya natosewe. Bwawonganya gagasyalile ivipande vivyalye vya vyasageye vipande vipande, vyamemile iviseje saba. ");
INSERT INTO sbk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wonti bhabhaliye bhali alume elfu zene bila abhashe na bhana. ");
INSERT INTO sbk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tena u Yesu alaga empoga bhabha bhewo na ayinjila mkasi yi mashua na bhale isehemu zi Magadani. ");
INSERT INTO sbk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amafalisayo na Masadukayo bhamwenzeye na hunenje u Yesu abhalolesye iishara yifuma humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ila u Yesu abhajibule na hubhawozye aje “Nkayabha lyabhela muyanga aje ihali yihewa nyinza, afwatanaje ianga lishamamu. ");
INSERT INTO sbk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ni shapwi muyanga ihali yihewa yilelo saganyinza afwatanaje ianga lishamamu na mabhengo galigubishe ianga lyonti, mumenye afasiri uloleho wianga, ila sagamuwezya afasiri iishara zimusala. ");
INSERT INTO sbk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ishizazi ishibhibhi nishi umalaya shiwhanza iishara ila nemo ishara yoyonti shashaipewa, ila ela ya Yona. Na tena u Yesu abhaleha nasogole ulwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abhanafunzi bhenza uwupande wabhele, ila bhahewelwe aheje amabumunda. ");
INSERT INTO sbk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","U Yesu abhawozya “Shebhaji na mubhanje shinza nusafwe Wimafarisayo na Masadukayo.” ");
INSERT INTO sbk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhanafunzi bhayangana mwikundi lyawo na yanje. “Afwatanaje saga tahejile amabumunda.” ");
INSERT INTO sbk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","U Yesu alimanya elyo nayanje, “Amwe mwelweteho udodo, yenu msebhele nayangane mkati yenyu nayanje aje kwasababu sagatahejile amabumunda? ");
INSERT INTO sbk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Eshi bado sagamutambula wala saga mukomboha gala amabumunda gasanu hubhantu elfu zisanu nivitondo vilenga vyamwa wonganyenye? ");
INSERT INTO sbk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Au amabumunda saba huabhantu elfu zene ni vitondo vielenga mwawonganyenye? ");
INSERT INTO sbk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iliwele hata sagamuhelewa yabhe nalisigiyanganamwe pamwanya yimabumunda? Jitunzaji na shebhaji nu safwe Wimafarisayo na Masadukayo.” ");
INSERT INTO sbk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tena bhamanya aje alisagayanga pamwanya yashebhe na mabumunda gagali nu safu ila ashebhe amamanyizyo gi Mafarisayo na Masadukayo. ");
INSERT INTO sbk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isala u Yesu lwafishile sehemu zi Kaisaria yi Filipi, abhawozelezya abhanafunzi bhakwe, ayanga, “Abhantu bhayanga umwana wa muntu yu nanu?” ");
INSERT INTO sbk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhayanga, “bhamo bhayanga aje yu Yohana Umozi; bhamo, yu Eliya; na bhamo, yu Yeremia, au wiweka na kuwa. ");
INSERT INTO sbk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Abhawozya, amwe muyiga ane ni nanu? ");
INSERT INTO sbk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ajibu, Usimoni Petro ayanga, “Awe wa Klisiti wamwana wa Ngulubhi wali momi.” ");
INSERT INTO sbk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","U Yesu ajibu na humozye, “Usayiwilwe awe, Simoni Bar Yona, afwatanaji idanda ni nyama sagavyafunuliye eli, ila Ubaba wane wali humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nane tena ihuwozya aje awe wa Petro, na pamwanya yikhome ogu nayihulizenga ishi bhanza shane. Amalyango gawhilongo sagagayi hulishinda. ");
INSERT INTO sbk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nayihupela awe infwungulo zi umwene wahumwanya. Shoshonti shawayishigalila panse shayibhashi galililwe humwanya, na shoshonti shawayihungula panse shayibha shuguliwilwe humwanya.” ");
INSERT INTO sbk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tena u Yesu abhawozya abhanafunzi bhasamozye umuntu wowonti aje umwene ali yu Klisiti. ");
INSERT INTO sbk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Afume isala ezyo u Yesu ahandile hubhawozye abhanafunzi aje lazima abhale Huyerusalemu, ayembe humambo aminji hunyobhe zya zehe na abhagosi bhadimi na simbizi, agoywe na zyoshe isiku lya tatu. ");
INSERT INTO sbk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tena u Petro amwega u Yesu hunshenje, nahukhalipile whayanje, “Ijambo eli nalibhe hutali nawe, ugosi, eli lisatokele huliwe. ");
INSERT INTO sbk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ila u Yesu agewushe na humozye u Petro, “Wela whisalo lgane setano! awe ulishipingimizi huline, kwasabu sugusaga amambo ga Ngolobhi, ila amambo gabhanadamu.” ");
INSERT INTO sbk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tena u Yesu abhawozya abhanafunzi bhakwe, “Nkesho umuntu wowonti nkawanza hufwate ane, lazima ajikhane umene mwene, ayeje ikhobhehanyo lyakwe, na afwate. ");
INSERT INTO sbk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Afwatanaje wawhanza agokole amakhalo gakwe ayihugatezya, na whawowonti wahugatezya amakhalo gakwe kwa ajili yane ayihugokola. ");
INSERT INTO sbk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eshi! Faida wele yayi huyipata umuntu nkapata ense yonti ila atezya amakhalo gakwe? Je! Ni kitu gani atakachotoa mtu katika kubadilishana na maisha yake? ");
INSERT INTO sbk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Alenganaje umwana wa Adamu ayinza katika utuntumu wa Baba wakwe. Nape ayihunipa kila mutnu alengane ni mbombo yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lyoli imbawozya huli baadhi yenyu mu mweleye epa ambao sagabhayilenga ufwe hadi lwabhayihunola umwana wa Adamu lwayihenza katika umwene wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Insiku sita pamande u Yesu abhajile wonti nu Petro, nu Yakobo, nu Yohana uholo wakwe, na abhega hadi humwanya yigamba itali bhewo bhene. ");
INSERT INTO sbk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ageusiwa whilongolela lyawo isola yakwe yan'gaa hansi isenya, na menda gakwe yaloleshe gagang'aa hansi umwanga. ");
INSERT INTO sbk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Enya, pala bhaloleshe u Musa nu Eliya bhayanga nawo. ");
INSERT INTO sbk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","U Petro ajibule na humozye u Yesu, “Gosi, shinza hulite abhe penepa. Nkesho unyonywa, imbazenje ivyegu vitatu sheka shaho, na sheka kwa ajili ya Musa, na sheka kwa ajili ya Eliya.” ");
INSERT INTO sbk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Isala yayangaga, enya ibhengo izelu lyabhabheha inzunda, na enya, yafumile isauti afume humabhengo, iyanga, “Oyo mwanawane uganwe wiganwa nawo. Mwivwi umwene.” ");
INSERT INTO sbk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abhanafunzi lwabhahevwa ego, bhagwiye shigubama na bhahogope hani. ");
INSERT INTO sbk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tena u Yesu ahenza na hubhaguse na yanje, “Woshi wala mugaje ahogope.” ");
INSERT INTO sbk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nape bhahinuye isola zyawo humwanya ila sagabhanolile umuntu ila u Yesu mwene. ");
INSERT INTO sbk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na lwabhahihaga mwigamba, u Yesu abhalajizya, ayanga, “Musahafumye infumi zimaono ega hadi umwana wa Adamu lwaizyoha afume whazimu.” ");
INSERT INTO sbk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhanafunzi bhakwe bhamozelezya, bhayanga, “Yenu asimbi bhayanga aje u Eliya ayihenza kwanza? ");
INSERT INTO sbk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","U Yesu abhajibu na yanje, “U Eliya ayihenza lyoli na wezye amambo ganti. ");
INSERT INTO sbk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ila ihumbawozya amwe, u Eliya ayenzele tayali ila sagabhamenye. Badala yakwe, bhamombeye amambo gabhawhanza abhene. Nesho shesho umwana wa Adamu shanzayembwe katika inyobhe zyawo.” ");
INSERT INTO sbk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Epo abhanafunzi bhagundula aje ayanga habari zya Yohana umozi. ");
INSERT INTO sbk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lwabhafiha pakasi yempoga ya bhantu, umunt weka amaliye, akhama amafugamo whilongolela lyakwe, na humozye, ");
INSERT INTO sbk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Gosi, ukhowoshele umwana wane, kwa sababu aliningwa nayembe hani. Afwatanaje hahinji agwa mmoto au mmenze. ");
INSERT INTO sbk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inetile wha bhanafunzi bhaho, ila sagabhawe/i/ye huponye. ");
INSERT INTO sbk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","U Yesu ajibu ayanga, “Amwe ishizazi shasagashiwheteha na shishinanjishe naikhula pamo namwa hadi ndii? Imbajivwanye namwe hadi ndii? Neti epa huline.” ");
INSERT INTO sbk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","U Yesu akhalipiye, na impepo yafumile. Usahala aponwa afume isala yeyela. ");
INSERT INTO sbk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tena abhanafunzi bhamaliye u Yesu hu siri na humozelezye, “Yenu sagatawezizye uhudigizye?” ");
INSERT INTO sbk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","U Yesu abhawozya, “Kwa sababu ulweteho lwenyu dodo. Lyoli ihumbawozya, nkesho munzabhe nulweteho hata udodo hansi ipunje yimbeyu yiharadali mubhawezye huliwozye igamba eli, sama afume epa, ubhale hula, nape libhasame na saguhabhabhe na hantu hohonti haha bhashindihane humwenyu. ");
INSERT INTO sbk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Simisizya: Amazu gimusitari wi 21 “Ila, iayina ene yimpepo sigiwezehana afume, ila hunsayo na galile” Sagagaloleha humasamizyo aminza gihale). ");
INSERT INTO sbk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Isala zyabhali bado Hugalilaya, u Yesu abhawozya abhanafunzi bhakwe, “Umwana wa Adamu abhabheshwe munyobhe zya bhantu. ");
INSERT INTO sbk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na bhanzahugoje, ni siku lya tatu ayizyoha.” Abhanafunzi bhazugumiye hani. ");
INSERT INTO sbk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nape lwabhafiha Hukapernaumu, abhantu bhabhawonganya ikodi yinusu shekeli bhamalila u Petro na yanje, “Aje umwalimu wenyu alipa ikodi yinusu shekeli?” ");
INSERT INTO sbk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ayanga, “Ee” Ila u Petro lwayinjila mukasi yinyumba, u Yesu ayanga nu Petro kwanza na yanje, “Usebhelelanshi Simoni? Amwene bhense, bhaposhela ikodi au uwushuru afume whananu? Whabhala bhahubhatabhala afume wha bhajenu? ");
INSERT INTO sbk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ni sala u Petro lwayangaga, “Afume whajenu” U Yesu amozya esho bhabhatabhalwa bhefiwilwe kati alipe. ");
INSERT INTO sbk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ila tisabhawombe asonkolezya ikodi bhawombe imbibhi bhala mbahari taga udobhani na uyeje ila eswe yewhenza kwanza. Baada ya hugule ilomu lyakwe ubhahuyaje omo asonkolezya ikodi kwa ajili yane na we. ");
INSERT INTO sbk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Isala zezyo zezyo abhanafunzi bhenza wha Yesu na humozye, “Yu nanu waligosi huwo mwene wa humwanya?” ");
INSERT INTO sbk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","U Yesu akwizya umwana udodo, ameha pakasi yawo, ");
INSERT INTO sbk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na yanje, “Lyoli ihumbawozya, nkagamtubu na bhe hansi abhana abhadodo sagamwayiweza hawhinjile huwomwene wa Ngolobhi. ");
INSERT INTO sbk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nesho wowonti wawhiha hansi umwana udodo, umuntu hansi oyo gosi huwomwene wa humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na wowonti wahuposhele umwana udodo whitawa lyane ahumposhela nene. ");
INSERT INTO sbk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ila wowonti wasababisya uwana kati ya weka abha bhabhahuneteha asaliti, yayibha shinza wha muntu oyo iwe igosi lya syela lipinywe msingo yakwe, na hudwinizye mwidimi li bahari. ");
INSERT INTO sbk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aheli honse husababu yisala izya viswe huje saga hulini budi husala ezyo awhenze, ila ahele whakwe muntu ola isala ezyo zibhawhenze kwa ajili yamwene! ");
INSERT INTO sbk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nkesho inyobhe yaho au inama lyaho nkalyasabisizya aviswe lidumule na litaje uhuli nawe. Shinza hani whaho awe ahinjile huwomi luli bila nyobhe au shilema, kuliko atagwe mwimoto wiwila uli ni nyobhe zyonti au amanama gonti. ");
INSERT INTO sbk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nkesho iliso lyaho livisizye, lisenye na ulitaje uhutali nawe. Shinza hani huliwe awe uinjile huwoni ni liso lyeka kuliko ataywe mumoto wiwila ali na maso gonti. ");
INSERT INTO sbk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Enyi aje msanzalau weka wabha dodo ebha. Kwa maana ihumbabhawozya aje humwanya huli antumi abhene insiku zyonti bhawhenya sha Baba wane wali humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Simisizya: Amazu gagaloleha hansi gimsitali gwa 11, “Kwa kuwa umwana wa Adamu ahenzele awhaule shila shasha tejile” Sagagaloleshe mnakala nyinza zihale). ");
INSERT INTO sbk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Msabhanshi? Nkesho umuntu alini ngole mya moja, na yeka yawo yatega, eshi sagabhahuzileshe tisini na tisa mwigamba na abhale afwate yeka yitejile? ");
INSERT INTO sbk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na nkayaga, lyoli ihumbawozya, asongwa kuliko zila tisini na tisa zyasaga zitejile. ");
INSERT INTO sbk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Shesho shesho, saga lugano lwa Baba wenyu wa humwanya aje weka wa dodo ebha ateketele. ");
INSERT INTO sbk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nkesho uholo waho avisizye, bhalaga, unolesye ishida yeleho awe numene lyali mwene. Nkabhahutejelezye, unzabhe umwezizye uholo waho. ");
INSERT INTO sbk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ila nkasagabhahutejelezye, mweje, uholo weka au uwabhele hani pamo nawe, humalomu gasimisizi bhabhele au bhatatu kila izu liwezizye asimisizwe. ");
INSERT INTO sbk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na nkasholonya ahubhatejelezye wozi ishibhanza iswala elyo, nkesho asholanya tena ashitejelezye ishibhanza, eshi na abhe hansi umuntu upagani na unsonkolozya kodi. ");
INSERT INTO sbk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Lyoli ihumbawozya, shoshonti shila shamwayipinya panse na humwanya shayipinywa. Na shoshonti shamwa yisatula panse na humwanya shayisatulwa. ");
INSERT INTO sbk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eshi ihumbawozya aje abhantu bhabhele pakashi yenyu nkabhetehana pamwanya yiswala lyo lyonti panse lya bhasaya, elyo u Baba wane wahumwanya ayihuliwomba. ");
INSERT INTO sbk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nkabhabha bhabhele au bhatatu wawongene peka whitawa lyane, ene endi pakasi yawo. ");
INSERT INTO sbk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tena u Petro ayenza nahumozye Yesu, “Gosi, halenga uhole wane avwisye nane insamehe? Hata mala saba?” ");
INSERT INTO sbk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","U Yesu amozya, “Sigiehuwozya mala saba, ila hata sabini mala saba. ");
INSERT INTO sbk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa sababu eyo awomwene wa humwanya ni sawa nu mwene omo wahanzaga asahihi sye ihesabu afume whaboyi bhakwe. ");
INSERT INTO sbk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lwahanda asahihisye ihesabu, uboyi weka bhaneta whamwene wali ahudayi italanta elfu kumi. ");
INSERT INTO sbk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Afwatanaje sagaali ni dala lyalipe, ugosi wakwe alajizizye akazwe, onse wakwe pamo na bhana bhakwe na hantu honti hali naho, na malipo gafanyishe. ");
INSERT INTO sbk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Esho uboyi agwiye, akhoma amafugamo whilongo lela lyakwe ayanga, 'Gosi, ubhe na golele pamo nane, na imbahulipe kila hantu.' ");
INSERT INTO sbk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Esho ugosi wola uboyi, afwatanaje asukumwi we hani ninkombo, anesheye na husamehe iliga elyo. ");
INSERT INTO sbk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ila uboyi ola asogoye na humwaje weka kati ya boyi bhakwe, wali ahudayi idinali mia. Akwesa, abida whimilo na humozye, 'Ndipe shila shihudai. ");
INSERT INTO sbk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ILa ola uboyi uwamwawo agwiye nahu nsisitizye hani, ayanjile, 'Ubhe nugolele nane, imbahulipe.' ");
INSERT INTO sbk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ila uboyi ola wawhande akhanile. Hubadala yakwe, abhalile na huntaje mwijela, hadi lwayihunipa shila shahudayi. ");
INSERT INTO sbk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na lwabhalola aboyi bhamwawo shila shishifumiye. Bhasononeshwe hani. Bhahenzele na humozye, ugosi wawo shila hantu hatokeye. ");
INSERT INTO sbk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ndiyo ola ugosi wa boyi ola akwizizye, na humozye, awe boyi mibhi nasamehile ane iliga lyane lyonti kwa sababu wandabhile hani. ");
INSERT INTO sbk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ashi! Sagawahanziwaga abhe ninkombo wha boyi abhamwenyu, hansi ane shanaloleye enkombo awe? ");
INSERT INTO sbk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ugosi wakwe avitilwe na humeshe whabhala bhabhayemva hadi lwailipa ishipimo shonti shadayiwaga. ");
INSERT INTO sbk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Esho shesho Ubaba wane wa humwanya shaihubhawombela, nkesho kila weka wenyu saga ayihusamehe uholo wakwe afume mmoyo genyu.” ");
INSERT INTO sbk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hafumiye abhazyo u Yesu lwemalile amazu ego, asogoye Hugalilaya, na abhalile mu mpaho mwi Yudea whilongolela yisoho li Yordani. ");
INSERT INTO sbk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Impoga ingosi yafwatile, na abhaponwe oho. ");
INSERT INTO sbk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afalisayo bhamaliye, bhanenjele, bhamozya, “Eshi halali wha muntu huneshe oshe wakwe husababu yoyonti?” ");
INSERT INTO sbk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","U Yesu abhajibu na yanje, “Sagamwabhazizye, aje uwene wabhawombele hulwawhande abhawombele unume noshe? ");
INSERT INTO sbk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na tena ayanjile, 'Hu sababu ene u nume ayihuneha ubaba wakwe nu maye wakwe na aungane nubhe wakwe, newo bhabhele bhayibha bele gweka?' ");
INSERT INTO sbk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Esho saga bhabhele tena, ila bele gweka. Eshi, hala haunganisizye o Ngolobhi, umuntu wowonti asalehanye.” ");
INSERT INTO sbk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bhamozya, “Eshi yenu u Musa atiwozezye afumye ihati yitalaka na huneshe?” ");
INSERT INTO sbk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Abhawozya, “Hukhome wimoyo genyu u Musa abharuhusile ahubhaleshe abhashe bhenyu, lakini afume lwawhande sagayali esho. ");
INSERT INTO sbk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ihumbawozya, aje wowonti wahuneha oshewakwe, ila husabu yiumalaya, na humweje uwamwawo, afanya umalaya. Nu nume wanzahumweje oshe walewhilwe awomba umalaya.” ");
INSERT INTO sbk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Abhanafunzi bhamozya u Yesu, “Nkashenesho whanume na whunshe wake sagashinza awheje.” ");
INSERT INTO sbk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ila u Yesu abhawozya, “Saga kila muntu awezya aposhele amamanyizyo ega, ila whabhale tu bhaluhusiwilwe aposhele. ");
INSERT INTO sbk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ila bhaleho agomba bhapapwilwe afume mu vyanda vya maye wawa. Na shesho bhaleho agomba bhafanyiwilwe na bhantu. Na bhaleho agomba kwa ajili yiwu mwene wa humwanya. Wawezya aposhele amamanyizyo ega na agaposhele.” ");
INSERT INTO sbk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tena bhanetela abhana bhamo abhadodo ili abhabheshele inyobhe humwanya yawo na pute, ila abhanafunzi bhakwe bhabhakhalipiye. ");
INSERT INTO sbk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ila u Yesu ayanjile, “Bhaleshi abhana abhela, wala mungaje hubhakhane awhenze huline, afwatanaje umwene wa humwanya wibhantu hansi ebha. ");
INSERT INTO sbk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nepe abhabheshela inyobhe zyakwe pamwanya yawo, natena asogola pala. ");
INSERT INTO sbk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Enya umuntu weka ayenza wha Yesu na yanje, “Mwalimu, hantu wele ahinza hihanziwa awombe ili impate uwomi wiwila?” ");
INSERT INTO sbk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","U Yesu amozya, “Yenu uhombozelezya aje hantu wele ahinza? Aleho weka mwene umwinza, ila nkuwhanza apate uwomi, lema indajizyo zya Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ula umuntu amozelezya, “Ndajizyo ziwhi?” U Yesu amozya, “Usahagoje, usahibhe, usawombe uwumalaya, usahasimisizye ilenga, ");
INSERT INTO sbk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ubhanje nishishi wha baba waho na whamaye waho, na ugane wapashenje yaho hansi umoyo gwaho.” ");
INSERT INTO sbk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umuntu ola amozya, “Amambo ego gonti ingakhete. Igolelanshi? ");
INSERT INTO sbk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“U Yesu amozya, “Hansi nkuwhanza abhe golosu, bhalaga, ukazye vyuli navyo, na ubhapele apena ubhabhe nihazina humwanya. Eshi inzaga ufwate.” ");
INSERT INTO sbk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ILa usahala ola lwahevwa gala u Yesu gamozezye, asogoye whazugumile, kwa sababu alikuwa na amemiliki mali nyingi. ");
INSERT INTO sbk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","U Yesu abhawozya abhanafunzi bhakwe, “Lyoli ihubhawozya, shikhome wha muntu utabhazi awhinjile huwo mwene wahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tena ihumbawozya, lahisi hungamia ashile mwishimo lisindani, kuliko wha muntu utabhazi awhinjile huwomwene wawha Ngolobhi” ");
INSERT INTO sbk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abhanafunzi lwabhahevwa esho bha swijile hani na yanje, “Yu nanu wayipenduha?” ");
INSERT INTO sbk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","U Yesu abhenya nayanje, “Whabhanadamu elyo sagaliwezehana ila wha Ngolobhi gonti gawezehana.” ");
INSERT INTO sbk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tena u Petro ajibu na humozye, “Enya, tileshile vyonti na hufwate awe. Hantu wele hataipata?” ");
INSERT INTO sbk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","U Yesu abhawozya, “Lyoli ihumbawozya, umwene wafwatileane, huu papo upya wakati umwana wa Adamu lwaikhala pitengo liumwene lituntumu wakwe, namwe mwaikhala pamwanya yimatengo kumi na gabhele giumwene, hubhalonje amakabela kumi na gabhele gi Israeli. ");
INSERT INTO sbk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kila weka wenyu waleshile inyumba, onkolo, uyilombo, ubaba, umaye, abhana, au ugonda kwa ajili yitawa lyane ayiposhela mala mia na pyane uwomi wiwila. ");
INSERT INTO sbk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ILa abhinji bhabhali bhawhande isalezi, bhayibha bha humwisho, na bhabhali bhamisho bhayibha bhahande. ");
INSERT INTO sbk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hwa huje uumwene wa humwanya ulengene yalinugunda yadamuye ishandawe napwi, awale aweshe awawomba mbombo huugonda gwankwe lwa mizabibu. ");
INSERT INTO sbk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Baada ya huentehana na awawomba mbombo dinari yeka hwisiku, ahawatuma awale hugonda gwankwe gwa mizabibu. ");
INSERT INTO sbk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ahawalo antele lwagashila amasala gatatu eshi ahawalola awawomba mbombo awamwao wahahemeleye bila mbombo husokoni. ");
INSERT INTO sbk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Awawozyo, 'Amwe walaji hugonda wa mizabibu, hahonti hahali sawa imbalahuwapele.' Newowahavyala awombe imbombo. ");
INSERT INTO sbk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ahawala nantele lwagashila amasala sita ahawomba sheesho na masala tisa. ");
INSERT INTO sbk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ahawalilo awhamwao nantele mumasala gakumi na moja, akhawala ahawanga awantu awhamwao wemeleye bila mbombo. Ahawawozya, 'Shonu mwemeleye epa bila mbombo yuyonti husiku lyonti? ");
INSERT INTO sbk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wahamuonzya aje numo umuntu wowonti yatipelile imbombo. Ahawawozya, 'Amwe namwe walanji hugonda ugwi mizabibu.' ");
INSERT INTO sbk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Amasala giliewela lwagaia, umwenesho gonda gwi mizabibu ahamozya umwemelizi wakwe, wakwunzye awawomba mbombo uwasombe umshahala, uyande uwa mwisho mpaka uwahwande.' ");
INSERT INTO sbk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lwawafiha wala wamasala ga kumi na moja, shilaweka ahaposheye idinari. ");
INSERT INTO sbk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lwawafiha owawomba mbombo awagwande wahasewele aje wazaposheye dinari yeka kila muntu. ");
INSERT INTO sbk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lwawaposhela amalipo gao, waha nalamishila umwenesho gonda. ");
INSERT INTO sbk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wahayanga, 'Ewa awawomba mbombo wa mwisho wejile isala lyenka wene kaliko awombe imbombo, lakini atifananisizye nate, ate linyumoye izigo hwisiku lyonti, nawine ni lyonto.' ");
INSERT INTO sbk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Eshi umwenesho goda ahajibu weka wao, 'Kundanu, sagaimbombile ijambo lwiwi. Je! sagalahentehene nane idinari yeka? ");
INSERT INTO sbk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ega hahali haho halali sogolaga. Ane ishiye huwapele ewa awawomba mbombo wimbagwelezizye humwisho sawa sawa nawe. ");
INSERT INTO sbk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Je! Sagagolosu huliwe awombe shihwanza ni maliyane? Au ilisolyaho li wiwi aje ane indi minza? ");
INSERT INTO sbk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eshi uwamwisho anzawe wa hwande na uwahwande azawe wa humwisho.” ");
INSERT INTO sbk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","U Yesu lwahazuwa awale Huyerusalemu, awawenjile awanafunzi wakwe kumi na wawele pambembe mwidala ahawawozya, ");
INSERT INTO sbk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Enyi tiwala Huyerusalemu, na umwana wa Adamu wanzahumeshe mnyowe inzya wagosi wa Amakuhani na awandisi. Wanzahunonje afye, ");
INSERT INTO sbk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","wanzahufumye hwa wantu wa munsi na munsi ili wasonsye, washente, na hukhowehenye. Lakini isiku ilya tatu ahaizyoha.” ");
INSERT INTO sbk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eshi umanye wa wana wa Zebedayo ahezele hwa Yesu na wana wakwe. Ahasugamila amafugamo hwitangalila lyankwe ahanawa ahantu afume hwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","U Yesu ahamozya, “Uhulanzashi?” Ahamozya, “Lajizwa aje ewa awana wane wawele wakhale, weka hukhono waho wa hunelo na weka hukhono waho wa humwongo huu umwene waho.” ");
INSERT INTO sbk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Walakini u Yesu ahayanga na humuozye, “Saga umenye ahantu hulawa. Je! Uwajie amwelele ishikombe shinza mwelele?” Wamuozya, “Tuwajie.” ");
INSERT INTO sbk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Awawawuzya, “Ishikombe shane lioli munza mwelele. Lakini akhale ukhono gwane wahunelona ukhona gwane ugwa humongo, sanga mbombo yane huwapele, lakini Udada wane awaweshe wala yawamenye.” ");
INSERT INTO sbk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Awanafunzi awamwawo kumi lwawovya esho, wahazungumila hani na wala awahola wawele. ");
INSERT INTO sbk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lakini u Yesu ahawakwizya wawewo ahawa wozya, “Mmenye aje awalawala wa munsi wahongofya na awagosi wao wawomba amamlaka ganu mwanya yao. ");
INSERT INTO sbk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini isahawye esho humwenyu ishinyumw shakwe. Wowonti yahwazawe gosi hulimwe awe lazima amwe muwomba mbombo wenyu. ");
INSERT INTO sbk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na yanzawe wa hwanda hulimwe amwe lazima awye muomba mbombo wenyu. ");
INSERT INTO sbk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nanzi umwana wa Adamu sagaahezele awombelwe imbombo bali awombe imbombo hulimwe amwe, na afumye uwomi wakwe uwe ukombolewa huwinchi.” ");
INSERT INTO sbk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lwawahepanga Huyeriko, ikundi igosi lyahafuatile. ");
INSERT INTO sbk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wahawalolile wawabadiye amaso wawele wakheye mumbembe mubarabara. Lwawonvwa aje u Yesu wa shilaga, waha wajile ishogo na yanje, “Bwana mwana wa Daudi utusajile.” ");
INSERT INTO sbk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lakini ikundi lyahawadamie na huwawozye wapume niyie. Hatesho awene wahabwajile ishongo, hani nayanje, “Bwana, mwana wa Daudi, utusanjile.” ");
INSERT INTO sbk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Epo u Yesu akhemelela na huwakwinzye na huwawuzye, “Mhwanza aje imbawombele iyenu?” ");
INSERT INTO sbk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wahayanga, “Bwana amaso gentu gafumbulilwe.” ");
INSERT INTO sbk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Epo u Yesu avutwa awasajila, wapalamasya amaso gao, waposhela pepo ingovu ya lole wahafyenta. ");
INSERT INTO sbk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","U Yesu na wanafunzi wakwe bhahafia karibu Huyerusalemu na wakhawala mpaka Bethfage, hwi gamba ilya mizeituni, nantele u Yesu akhabhawonzya awanafunzi wawele, ");
INSERT INTO sbk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akhawawozya, “Walaji hushijiji shishili hwilongolela isala zyezi munza huyanje idogobhi ipinyilwe pala, inyanadango yakwe. Mubhaule na huwalete huline. ");
INSERT INTO sbk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nkha muntu wowonti ahuwawozya lioliontu ahusu elyo, munza, `U Bwana ahubhanza, ` umuntu unyo hani hani anza huwenteshe ahwenze nayo” ");
INSERT INTO sbk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijambo elyo lyahafumie lilila lyakhayangwilwe na watumi lazima lifumile. Shakhabhawozezye, ");
INSERT INTO sbk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Bhawozye abhalendu bhahusayuni, enyhi uumwene wakho hu za humwenyu umwololo akhangaliye idogobhi umwana dogobhi unume, umwana dogobhi umembha. ");
INSERT INTO sbk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nantele awanafunzi bhahasogola nawombhe nanzi u Yesu shabhalajizizye. ");
INSERT INTO sbk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakhanetela idogobhi nu mwana dogobhi nawhesha amenda gao humwanya yao, nape u Yesu ahakhala pala. ");
INSERT INTO sbk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Whinchi bhakhawongeni wakhala amenda gao mwidala, na awamo bhahadumuye amadhanzala afume mumakwi bhahalile mubalabala. ");
INSERT INTO sbk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Awhinchi bhabhahatagaliye u Yesu bhala bhabhahafuatile u Yesu bhahabhanjile bhahayanga, “Hosana umwana wa Daudi! Usayhiwilwe uyezela hwitawa lya Bwana. Hosana humwa hani!” ");
INSERT INTO sbk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","U Yesu lwahafia Huyerusalemu, umji ghonti gwakhongopa nayanje aje, “Uno yu nanu? ");
INSERT INTO sbk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Awhichi wakhayanga, “Onho yu Yesu utumwa, afume Hunazareti ya Hugalilaya.” ");
INSERT INTO sbk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nantele u Yesu ahinjila hushiwanza sha Ngolobhe ahawamanyizya hoze wunti bhahakalaga na kazye mshiwanza. Antele ahagwisizye imeza zya bhahakalananga ihela ni vinti vyakhabhakazianga iunda. ");
INSERT INTO sbk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akhawawozya, “Isimbwilwe, “Inyumba yane inzakwiziwe nyumba ya puutile, `eshi amwe muyiweshele lipaho lya hupele.” ");
INSERT INTO sbk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naulele bwawabadiye bhakhalemeye bhahamalila hushibhanza nape akhabhaponizye. ");
INSERT INTO sbk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lakini awagosi wishiwanzya na abhasimbi lwabhakhalola amayele gawombile, na lwabhahovya awana bhabwanga ishongo mshibhaza na ayanje, “Hosana amwana wa Daudi,” bhakhakhatwilwe ni lioyo. ");
INSERT INTO sbk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakhamuozezye, uyumvyezye shabhayanga ewa abhantu?” U Yesu akhabhawozya, “Eee! inovyezye, lakini sagamuwahile abhazye afume humalomo gabhana na awasanga bhabhahoha muli indombo kamili?” ");
INSERT INTO sbk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nantele u Yesu akhawaleha akhawala honze yikhaya huu Bethania na ahagona khuho. ");
INSERT INTO sbk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ishandabhe lwakhawelanga humjini akhali ni nzala. ");
INSERT INTO sbk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akhalola ikwi pambembe yi barabara. Akhawala, lakini sagaahapente ahantu humwanya yankwe ila amatundu. Akhaliwozezye, “Usahabhe namadondo wila wila nantele.” Amasala gengo ikwi lila lyahoma. ");
INSERT INTO sbk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abhansukulu lwabhakhalola, bhakhaswinjile na yanje, “Yabhawele ikwi lyomele sheshi sheshikhani?” ");
INSERT INTO sbk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","U Yesu akhabhajimbu akhabhawozya lyoli ihumbawozya aje khamli nu lwetekho bila uwonga, sangamzawombe shishiwhumbeshe hwikwi tu, lakini mnzahuwhuzye hata elugamba lyengwe na hulitanje mwidimi igosi na inzawombeshe. ");
INSERT INTO sbk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lyolyonti lyamza labhe na punte nkhamli nulweuteho munzaposhele.” ");
INSERT INTO sbk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","U Yesu lwakhafika mshibhanza awagosi bha makuhani na bhagogolo bha bhantu wakhamalila lwahamanyizianga, na wakhamozya, “Hungovu wele uwomba amambo enga? Na yu nanu apiye ingovu enzi?” ");
INSERT INTO sbk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","U Yesu ahawajibu na hubhawozye, “Nane ihumba whuzya iswali lyekha. Nkhamuhubozya anje anane iwombo enga hungovu ya nanu. ");
INSERT INTO sbk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uwhoziwa wa Yohana- wakhafumile hwii, humwanya au hwa wantu?” Bhanayangana wene, aje, nkhatiyanje whakhafumile humwanya, `anzahutiwhozye shonu sangamwaha mweteshe? ` ");
INSERT INTO sbk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nantele nkhatiyanje whakhafumile hwabhantu, `tihuwongopa wishiwaza, sababu whunti bhahunola u Yohana aje yutumi.” ");
INSERT INTO sbk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nantele bhahajibu u Yesu, “Sagatimanye” Akhabhawozya nape nane sangaihumbawhuzya hungovu wele iwhomba amambo ega. ");
INSERT INTO sbk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Eshi msebha yenu? Umuntu yalinawana wawele. Akhabhala hwa weka akhamozya, `Mwanawane, bhala uwombe imbombo hugonda gwi mizabibu, ");
INSERT INTO sbk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ilelo. `Umwana ahajibu na yan sangaimbala, Lakini pamande akhabadilisya isewho zyakwe akhabhala. ");
INSERT INTO sbk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na umuntu ula akhabhala hwamana wabhile humuozye shishila. Umwana ola ahajibu na yanje aje imbala, gosi,' lakini sagawabhala. ");
INSERT INTO sbk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yunanu kati ya wana bhabhile yawhombiole shahwanza uudada wakwe? Bhakhamuzya, “Umwana uwahuande.” U Yesu akhabhawonganya ikondi na bhamalaya bhahaiinjila hwa mwene hwa Ngolobhe shamsele amwe ahwinjile. ");
INSERT INTO sbk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Huje u Yohana akhenzele hulimwe hwidala liligoloshe, lakini amwe sagamwahaposheye, eobha whunga nya ikodi na bhamalaya bhakhaposheye. Amwe, iwamwakhalola elyo liwhombeha sangamwakha lambihe aje pamande mposhele. ");
INSERT INTO sbk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tejelezi ufyana ungwamwao. Hwakhali umuntu, umuntu yalini sehemu ingosi iyinsi. Ahatotile amizabibu akhaga wesheye imbanga ahagombile ishombo sha nkhamile idivai, ahazenga iboma lyawalizi, ahapanjizya bhabhalimilila umuzabibu. Ahasongola akhawala insi inyamwao. ");
INSERT INTO sbk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uwakati wavune imizabibu lwabhafiha ahabhalajizya abhawomba mbombo hwabhalima amizabibu ahweje amizabibu gankwe. ");
INSERT INTO sbk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lakini bhabhalima amizabibu bhahawenga abhawomba mbombo wakwe, bhahakhoma weka bhabuda uwamwao bhakhoma weka na mawe. ");
INSERT INTO sbk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nantele ugosi ahatuma abhawomba mbombo abhamwao, winchi hani ashile wala abhahuande, bhabhalima amizabibu bha khawobile shishila. ");
INSERT INTO sbk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Baada yepo ugosi ula akhatuma umwana wakwe, ahaga, 'Wazahutinishe umwana wane.' ");
INSERT INTO sbk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini bhabhalima amizabibu lwabhanola usahala ula, bhakhayangana, “Onu yu mrithi, Inzaji, tibude na tenye urithi.' ");
INSERT INTO sbk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","`Basi bhahatanga hunze mugonda gwi mizabibu na hubude. ");
INSERT INTO sbk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jee ugosi wigonda wa mizabibu lwanza ahwenze anza huwawombe wele bhabhalima imizabibu?” ");
INSERT INTO sbk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhakhamuozya, “Anzahubhananganye ewho awantu abhabhibhi, hwidala ikhali hani, na anza panjizye ugonda gwi mizabibu hwa bhakulima abhamwawo wamizabibu, awantu bhabhaza sombe kwajili ya mizabibu lwagazatone.” ");
INSERT INTO sbk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","U Yesu akhabhawozya, “Aje sangamubhazizye amaandiko, iwe lwabha akhanile awazenje lyabha liwe ligosi lya msingi. Eli kyakhafumile hu Bwana, lishwizisya pamaso gentu?” ");
INSERT INTO sbk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Eshi ihumbawhuzya, u Umwene wa Ngolobhe unzahungwe agume humwenyu, wanzapelwe bhamunsi bhabhasnga amadondu gankwe. ");
INSERT INTO sbk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Whowhitu yazangwe humwanya yi iwe elyo anzabuduhane buduhane. Lakini whowhunti yalinzahugwele linzahusye.” ");
INSERT INTO sbk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Abhagosi wishiwanza na Amafarisayo lwawhonvya ishifano shakwe, bhakhamanya aje ahubhayanga wewo. ");
INSERT INTO sbk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lakini lwabhanzaga agolosye inyobhe hwa mwene, bhahogope awashibhaza, awantu bhakhamwenyizye aje mtumi. ");
INSERT INTO sbk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","U Yesu akhayanga anao nantele hushifano, ahaga, ");
INSERT INTO sbk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uumwene wa humwanya ulingana nu mwene yayandaile isikulukulu ya weji ya mwana wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akhatuma abhawomba mbombo wakwe huwakaribisye bhabhahanilwe ahuenzi hushi kulukulu yi weji, lakini sagabhaheza. ");
INSERT INTO sbk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Umwene akhabhatuma nantele abhawomba mbombo abhamwao aje bhabhawozye wonti, bhabhahanilwe, enyi inandaile, ishalye bhawolile ni ndama yane nyinonile, na mambo gonti gali tayari, Inzaji hushukulukulu yiweji.” ");
INSERT INTO sbk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini abhantu sagabhahovyezye shiza inyanwa yakwe. Abhamo bhakhabhalile humagonda na abhamo bhakhawelile humbombo zyao zya kazye ibiashala. ");
INSERT INTO sbk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abhamo bhakhabhavitililwe abhawomba mbombo wa mwene na hubhasosye na hubhabude. ");
INSERT INTO sbk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lakini umwene akhavitilwe. Akhatumile abhalungu wakwe akhabhabuda bhala abhabudi na hubhalongolezye nu moto peka ni khaya yao. ");
INSERT INTO sbk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nantele akhabhawozya abhawomba mbombo bhakwe, “Uwenji uli tayari, lakini bhabhahanilwe sagawasajie. ");
INSERT INTO sbk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eshi bhalaji humadala amagosi mubhane abhantu winchi, wonti bhabhanza loleshe, wenze hushukulukulu yiwenji.” ");
INSERT INTO sbk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abhawomba mbombo bhakhawala mumadala amagosi, hubhakalibisye abhantu wonti bhabhakhoneha, awinza na abhawiwi. Isebule yiweje ikhamema abhajenu. ");
INSERT INTO sbk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lakini umwene lwawinjila huwenye abhajenu, akhanola umuntu weka yasanga akhali numwenda gwiweji! ");
INSERT INTO sbk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Umwene akhamozyo, 'Miya ufishile wele mhanti umu bila mwenda gwiweji?' Nu muntu ula saga akhajibu nalimo. ");
INSERT INTO sbk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Shesho umwene akhabhawozya abhawomba mbombo bhakwe mpinyi umuntu uno inyobhe namanama, mtaje khonze hunkisi ukhohulikhole na asye amino. ");
INSERT INTO sbk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Huje abhantu bhinchi wakwiziwa, lakini bhabhasalulwa, wadodo.” ");
INSERT INTO sbk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Epo Amafarisayo bhakhasogola bhakhapanga isha hukhate u Yesu hunjango yakwe yuyo. ");
INSERT INTO sbk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bhakhabhatuma abhana wisukulu abhawo peka na Bhaherode. Na bhakhamuzya u Yesu, “Mwalimu, timenye aje awe uli munti wanalyoli naje umanyizya gahuanza Ungolobhe angalyoli. Sagausanga inongwa zya upendelelo hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eshi tiwozye usebha yenu? Je, shinza husheria asombe ikondi hwa Kaisari au sagashinza?” ");
INSERT INTO sbk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","U Yesu akhamenye ubwibwi wao akhabhawozya, shuno mulugela amwe mubwilenkha? ");
INSERT INTO sbk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mbonesi ihela yamsombela ikondi pabhahanetela impeya. ");
INSERT INTO sbk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","U Yesu akhabhawozya, “Isura ni tawa eli vyananu?” ");
INSERT INTO sbk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakhajibu, “Vya Kaisari.” Pepo u Yesu akhabhawozya mpeli Ukaisari ivintu vyakwe na ivya Ngolobhe mpele u Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lwawovya esho bhakhasyinjile. Nantele bhakhenekha bhakhasogola swe. ");
INSERT INTO sbk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Isiku Amasadukayo abhamo bhaheza hwa Yesu, wala bhabhayanga aje azyoshe nahumo awafye, bhakhamuozya. ");
INSERT INTO sbk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wakhayanga, “Mwalimu, Umusa ahajile, nkashe umuntu afyiye bila apape umwana, uhholao wakwe amurithi uyo ushe apele umwana uholo wakwe uyo. ");
INSERT INTO sbk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bhakhali abhaholo saba. Uwahuande ahejile nantele akhafya bila apape ubhana. Akhabha leshela mshe ukholowakwe. ");
INSERT INTO sbk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nepe ukholo wakwe uwabwile akhawomba shesho, nuwatatu, ihabha shesho hadi ula uwa saba. ");
INSERT INTO sbk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lwabhawombesho wonti, ula ushi nape wafwa. ");
INSERT INTO sbk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eshi uwakati wazyoshe uno ushe anzawe ashe wananu huwaholo ewa saba? Kwa maana wonti bhakhamwejile.” ");
INSERT INTO sbk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lakini u Yesu akhayanga nahubhawozye, “Mkosele sanga mgamenye amazyi wala ingovu izya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Shazili azyoshe, abhantu saga bhahuenga wala ahungwe. Shazibha aje abhantu bhawaje watumi wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini ahusu azyosye ufye sanga muwahile abhazye shila Ungolobhe shayenje hulimwe, ahayenje, ");
INSERT INTO sbk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ane ni Ngolobhe wa Ibrahimu, Ngolobhe wa Isaka, na Ngolobhe wa Yakobo? Ungolobhe saga yu Ngolobhe wa bhabhafyiye, bali yu Ngolobhe wa bhaliwomi.” ");
INSERT INTO sbk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Awashiwanza lwabhahovyo elyo bhakhashijile imanyizyo zyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lakini Amafarisayo lwabhahovwa aje u Yesu abhapumezezye Amasadukayo, bhakhawongene wene peka. ");
INSERT INTO sbk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Weka ahali mwanasheria, akhamunzya ishwali lialuyele. ");
INSERT INTO sbk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwalimu, indajizyo yili ngosi ashile zyonti musheria nyihwi?” ");
INSERT INTO sbk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","U Yesu akhabhajibu, “Lazima ugana Ubwana hu moyo gwaho gonti, hupepo yaho yonti hujele ziaho zyonti. ");
INSERT INTO sbk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ene ndiyo ndajizyo ingosi na yahuande. ");
INSERT INTO sbk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na iyabwile ifwana neyo- Lazima ugane upalamani waho nazishuhuigana awe. ");
INSERT INTO sbk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Isheria zyonti na Abhakuwa itegemela indajizyo enzi zibwile.” ");
INSERT INTO sbk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na Amafarisayo bhakhalisha bhawongene peka, u Yesu akhabhawozya ishwali. ");
INSERT INTO sbk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Akhabhawozya, “Je!, Msebha yenu ahusu Ukrisiti? Umwene mwana wa nanu?” Nape bhajibu mwana wa Daudi.” ");
INSERT INTO sbk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","U Yesu akhabhajibu, “Ni kwa namna wele u Daudi humpepo ufijile ahukwinzya Bwana, ahumuozya, ");
INSERT INTO sbk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Bwana akhamuozezye u Bwana wane, “Nkhala hukhonogwana ugwa hunelo, mpaka pinzahubhaweshe abhabwibwi bhaho bhakhale pasi yi manama goho?” ");
INSERT INTO sbk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nkishe u Daudi ahukwinzya Uklisiti “Bwana,” Inzabhe wele mwana wakwe?” ");
INSERT INTO sbk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hakuna yabhajiye hujibu izyi nantele na nomuo yajelile nantele humuozye amashwali hani ahwande isiku ilyo na hundelelee. ");
INSERT INTO sbk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pamande ahizizye nu wungano wa bhantu paka na bhanafunzi bhakwe akhayanga, ");
INSERT INTO sbk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abhasimbi na Mafarisayo bhakhalila itengo ilya Musa. ");
INSERT INTO sbk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eshi lyolyonti lyabhalajizya wombaji, muwombaje nuhu mubhanajizyaje. Lakini msahinjile mmbhiwi zyao, maana awene bhayanga amambo ngasanga bhawomba. ");
INSERT INTO sbk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lyoli, awene wapinya amazingo amamwamu gasanga bhabhajie ayumule alafu bhahuwatwiha abhantu muvipungo vyao. Lakini awene sagabhayembezya hata hayobhe anyumule. ");
INSERT INTO sbk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imbombo zyao zyonti bhawomba ili abhantu. Bhabhenye maana awene. Wahovyezya amabokosi gao na bhahonjezya ungosi wao na menda gao. ");
INSERT INTO sbk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Awene wasongwa akhale isehemu inyinza yi shikulukulu, humatengo gishishi mvibhanza, ");
INSERT INTO sbk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","na alamshilwe hushishi isehemu yakazizye na akwiziwe “Mwalimu” na bhantu. ");
INSERT INTO sbk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini amwe sangamhwaziwa akwiziwe “Mwalimu” Mli nu mwalimu weka, amwe wonti mli kholo. ");
INSERT INTO sbk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Msakha kwinzye umuntu wowonti munsi umu Daada wenyu maana mlinu Daada weke, tu nape ali humwanya. ");
INSERT INTO sbk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nantele msahakwiziwe 'mwalimu.' maana mli nu mwalimu weka napo yu Klisiti. ");
INSERT INTO sbk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Eshi yali gosi kati yenyu anzavye muwomba mbombo wenyu. ");
INSERT INTO sbk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wowonti yahuisomba anza hulishe na wowonti yazahwishe anzazuwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lakini mwashela amwe awasimbi na Amafarisayo, awilenkha! Muhubhagalilila abhantu umwene wa humwanya. Amwesangamubhajie huwinjile na sangamuhubha ruhusu bhabhahuaza hwinjile. ");
INSERT INTO sbk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Enya: Usitari ugwa 14 sagaulolekha isimbo inyiza izikhale, izimo isimbo zikhovyezya umstari ugu ugwa 12. Umsitari ugwa 14 “Mwashela amwe mubhasimbi na Mafarisayo muwilenkha amwe muhubhamila abhafyele”). ");
INSERT INTO sbk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mwashela amwe mubhasimbi na Mafarisayo, muwilenkha! Mfwemela hwisyela yi idimi igosi na humwombe umuntu weka awenu lwentekho hwagala mmanyizya, na lwabha na zimwe, Mhumwombela mala hawile abhe mwana wa hujehanamu nazi amwe shamlekho. ");
INSERT INTO sbk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mwashela amwe mubhalongozi mbadiye amwe mumuyanga, wowonti yalapa hushi bhanza sagahuli nazimo. Lakini yalapa hwiwye lihela yishibhanza apinyilwe na lapa hwankwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Amwe mubadiye wapumbavu, shenu ishi gosi ashile isha mwao iweilihela au ishibhanza, liliweshilwe tayari iwyelihela hwa Ngolobhe? ");
INSERT INTO sbk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wowonti ya lapa apafinjile, hamna ahatu, ila yalapa husadaka yili humwanya yakwe, apinyilwe ni ndopo yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amwe mubhantu mubadiye shenu ishi gosi ashile isha mwao, isadaka au apafinjile papali tayari afumizye isadaka hwa Ngolobhe? ");
INSERT INTO sbk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eshi, uumwene yalapa pashifinjile alapa hwisho ni vintu vyonti vivili pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nape yalapa pashibhanza, alapa hulepo, nuyoakheye pakhanti yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nape yalapa humabhengo, alapa hwitengo lgosi lya Ngolobhe na hwamwene yakhenye pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mwashela amwe mubhasimbi na Mafarisayo, Mubhilenka! Msomba izaka zya bizali, mnamwamu ingindajizyo, ingi haki, isanjilo, ni ulwenlekho. Lakini enga muhwaziwa mugawombe, siyohugaleshe agamo bila hugawombe. ");
INSERT INTO sbk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amwe mubhalongozi mubadiye, amwe myunga utududu utudondo lakini mumila idogobhi! ");
INSERT INTO sbk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mwashela amwe mubhasimbi na Mafarisayo, bhilenkha! Aje mkhozya honzya ishikombe na honze nyi mbakuli, lakini mkhanti mumemile imbhiwi sangamli nu wonga. ");
INSERT INTO sbk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amwe Mafarisayo mubadiye, ozyaji ahuande mukhanti yishikombe na mukhanti yimbakuli, na uupande wakhonzi nape ubhe zeru. ");
INSERT INTO sbk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mwashela amwe, mubhasimbi na Mafarisayo, Mubhilenkha! Mlinifyano yimakaburi gagapashilwe ichokaa, khoze gawhonekha miza lakini mukhanti gamemile amafupa gabhafyinye na shila khanti hintavu. ");
INSERT INTO sbk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Shishesho namwe, namwe honze muwhonekha winza hwilongolela lya bhantu, lakini mukhanti mumemile ilenkha nu walangani. ");
INSERT INTO sbk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mwashela amwe, mubhasimbi na Mafarisayo, Mubhilenkha! Mzenga amakaburi ya wakuwa nahugapambe amakaburi gabhagolosu. ");
INSERT INTO sbk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Namwe muyanga, aje mngakheye isiku izya waadadawenyu, indisanga muwombile peka akhinte ianda ilya wakuwa. ");
INSERT INTO sbk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Amwe muhuyanga muwyene aje amwe muli bhana bhewo bhabhakhabha budile awakuwa. ");
INSERT INTO sbk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nantele amwe mumalezezya amenye isehemu yihwanziwa imbibhi izyabhadaada wenyu. ");
INSERT INTO sbk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Amwe mzokha, bhana wimazokha, mwidala wele munza kwepe idongwa ya hujehanamu? ");
INSERT INTO sbk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eshi, enyi ihumbatuma aawakuwa hulimwe, abhantu winjele, na waasimbi, abhamo munza hubhabude ua hubhakhobhekhanye. Na abhamo munza hubhashente muhanti yivibhanza vyenyu na hubhadaje afume mkhaya yeka hadi iyamwao. ");
INSERT INTO sbk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hakhanza fumilepo hulimwe pazafumile idada zyonti izya wagolofu zyazyahitilwe munsi, ahuande idada lya Habili ugolosu, mpaka idanda ilya Zakaria umwana wa Barakia, yamwahabudile pahanti yapafinjile na pashibhanza. ");
INSERT INTO sbk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lyoli ihumbawhuzya, amambo enga gonti gakhaibhanga ishikholo eshi. ");
INSERT INTO sbk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalemu, Yerusalemu, awe uhuwabuda abhakuwa na uhubhakhoma na mawe wala bhabhatumwilwe huliwe! khalenga imba whunganyenye abhana bhakho peka nanzi shila inkuku shiwhunganya inyana zyakwe pasi yi maapamikho agakwe, lakini sagahuentekha! ");
INSERT INTO sbk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Enya inyumba yakho isangeye wene. ");
INSERT INTO sbk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nane ihuwozya, ahuande isala enzi nahundelele sangaunza hudole, mpaka lwahaiyanga, 'Asayiwilwe umwene yahwenze hwitawa ilya Bwana.” ");
INSERT INTO sbk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","U Yesu akhafuma mshibhanza na akhasogola. Abhanafunzi bhakwe bhakhamalila na hunolesye inyumba yishibhanza. ");
INSERT INTO sbk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lakini akhajibu na hubhawhunzye, “Je, muhungolola amambo enga gonti? Lyoli ihumbawhozyo nalimo Iwe lyalyahisagala humwanya yilya mwawho bila abomolewe.” ");
INSERT INTO sbk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na pakhakheye mwingamba li Mizeituni, awanafunzi wakwe bhakhamalila, “Pambembe, Tiwhuzye amambo enga gahaifumila ndii? Hantu wele khakhaiwonekha ahwenze huliwe na humwisho wa munsi?” ");
INSERT INTO sbk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","U Yesu akhabhajibu, akhabhawozya, “Msimisizyaje aje umuntu asakhabhatezye. ");
INSERT INTO sbk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maana winchi wanzahwenze hwi tawa lyane. Wanzayanje, 'Ane nene Klisiti,' na wanza huwatezye winchi. ");
INSERT INTO sbk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Munza akhovye ulugo ni kholo yi lugo Enyanji musakhawye nii wonga, maana amambo engo lazima gafumile; lakini ula umalishilo unzabhe usele. ");
INSERT INTO sbk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hwamaana insi ni insi uwamwao zibhalalwe na umwene na umwene uwamwao. Hunzabhe inzala na nanyinje insi isehemu izimo zimo. ");
INSERT INTO sbk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lakini amambo enga gonti gahunde tu uchungu wa pape. ");
INSERT INTO sbk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ndipo wanza hubhafumye wapate amalabha na hubhabude. Mnza vitilwe na bhamnsi wonti husababu yi tawa lyane. ");
INSERT INTO sbk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Epo winchi bhanza bomele na zilane navitilanwe bhewokwa bhewo. ");
INSERT INTO sbk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Awakuwa winchi bhilenkha bhakhaifumila na hubhakhopela bhinchi. ");
INSERT INTO sbk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Epo imbibhi ziahainyonjelela, ulugano ulwawinchi wahaipola. ");
INSERT INTO sbk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini yakhaijimba mpaka mumalishilo ahaiokolewa. ");
INSERT INTO sbk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eli inzwi ilya umwene lyakhailumbelelwa monti abhe ushaihidi mubha munsi mwonti. Epo owhavmalishilo unzahwenze. ");
INSERT INTO sbk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Eshi, lwamwalilola ichukizo ilya nanganye, liliyangwile na u Danieli lyemeleye amahali pafinjile Yabhazya amanye, ");
INSERT INTO sbk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","epo bhabhali huayunda washembelele humagamba. ");
INSERT INTO sbk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nula yali pamwanya panyumba asahajezye ahwishe pansi ahueuje ahantu hakhonti afume mkhanti yi nyumba yakwe, ");
INSERT INTO sbk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nape yalekho hugonda asakha wele ahuenje umwenda gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Washelile ewo bhali na bhana bhala bhabhakhosya husiku izyo! ");
INSERT INTO sbk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lawanji aje ashmbele hwenyu husakhabhe wakati wisasa, wala lisiku lya sabato. ");
INSERT INTO sbk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwa kuwa hwaibha ishinda ingosi, yasanga iwahile afumile ahuande awhumbwe insi hadi isala enzi, na sagaikhaibha nantele. ");
INSERT INTO sbk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Insiku izyo nkhasanga hupungoshe numo uyo angonkokho. Lakini hwa bhala bhabhasalulilwe isiku zyaipungukha. ");
INSERT INTO sbk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nantele nkhashe umuntu wowonti anzahubhawozye 'Enya, Klisiti alekho epa! au, 'Uklisiti alekho hula msakhakheteshe inongwa eyo. ");
INSERT INTO sbk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maana Amaklisiti wilenkha na abhatumi wilenkha bhanza huenze, na bhanza lolesye amayele amagosi nagashinjisye, hwilengo iliyatenzye, bhabhajie hata bhabhasalulilwe. ");
INSERT INTO sbk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enyanji, imbasundile shangasele amambo enga afumile. ");
INSERT INTO sbk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kwa huje khabhanza hubhawhunzye, “Uklisiti alihumbuga,' msahabhale ukho humbuga. Au, 'Enyaji, alimuhanti munyumba,' musakhakheteshe inongwa eyo. ");
INSERT INTO sbk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nanzi shila ilandi shinglala afume humashariki nakhoye hadi humaghalibi shishesho shanza huenze umwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Poponti papali uwozu, ukho pabhawhungana impanga. ");
INSERT INTO sbk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Insiku zila amalabha amagosi nkhageza, isenya lyahaiwehwa ahinsi, nu mwenzi sangagwakha ifumya ukhozya wakwe, inzonto zyingwa afume humwanya, na ingovo izya humwanya zyakhaiyinga. ");
INSERT INTO sbk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Epo amayele ga Mwana wa Adamu gakhailolekha humwanya, na amakabila gonti gamunsi gakhaikhola. Bhakhainola umwana wa Adamu ahuenze humabhengo gahumwanya hungonvu nu tunndumu ungosi. ");
INSERT INTO sbk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Akhaimatuma abhatumi bhakwe ni isauti ingosi yi tarumbeta, ewho bhanza hubha whuganye peka abhasalulwe bhakwe afume ipane zinne izya munsi, afume humalishilo weka wahumwanya, hadi ungwamwao. ");
INSERT INTO sbk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Manyizyaji isunkulu afume hwikwi. Lwalimela lifumya amatundu ni samba mumanya aje shisenya shikalibiye. ");
INSERT INTO sbk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nantele lwamzalole amambo gonti enga, muhuanzia amanye aje akalibiye, alikalibu munjango. ");
INSERT INTO sbk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ihumbawhunzya, ishikholo eshi sangashishila, hadi amambo ganti enga ganzabhe gafumiye. ");
INSERT INTO sbk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Imwanya ninsi zizashile, lakini izwi liane sangalishila kamwe. ");
INSERT INTO sbk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lakini isiku elyo ni saa inyo numo ya menye, hata abhatumi bhahumwanya wala umwana, yudaada mweene. ");
INSERT INTO sbk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nanzi shikhali isiku izya Nuhu, shinzabhe ahwenza umwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Isiku izyo shisele igalika, abhantu walinga, na bhamwelanga bheganga na huengwe, hadi isiku lila u Nuhu ahwinjile musafina, ");
INSERT INTO sbk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","sangabhakha menye ahantukhahonti khakhazafumile hadi egalika lwayenza na hubhazyole wonti - shinzabhe shesho lwakhaiyenza umwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Abhantu bhabhile bhahaibha humagonda- weka akhaiyengwa na weka akhailehwa hwisinda. ");
INSERT INTO sbk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Abhashe bhabhile bhahaiwa asye peka - weka akhaiyengwa na weka akhaisagala. ");
INSERT INTO sbk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sanga mumenye isiku lyahaiyeza U Bwana wenyu kwa hiyo khalaji maso. ");
INSERT INTO sbk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mumanye aje umwenesho nyumba angamenye isala ya hwenze umwibha indi alimaso andasaga aleshile inyumba yakwe bha mwinjilile. ");
INSERT INTO sbk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Shesho ihuanziwa abhe tayari, isala musangamuimenye umwana wa Adamu akhaiyenza. ");
INSERT INTO sbk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Eshi yunanu aligolosu, umuwomba mbombo yali nijele, leyo ubwana wake apinye ugosi abhapelaje ishalye bhabhali muyumba yakwe husala yifaa? ");
INSERT INTO sbk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Asayiwilwe umuwomba mbombo uyo, aje ubwana wakwe anzahumwaje awomba esho uwakati uuhuenza. ");
INSERT INTO sbk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lyoli ihumbawozya ubwana wakwe anzahumeshe humwanya kila hatu khalinakho. ");
INSERT INTO sbk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini nkashe umuwomba mbombo umibhi anzayanje mumoyo gwake, 'Ubwana wane akheye,' ");
INSERT INTO sbk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na waanda hubhakhome abhawomba mbombo wakwe na alie kholwe amakholwa. ");
INSERT INTO sbk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","UBwana wa bhawomba mbombo uyo anzahuenze hwisiku lyasanga alimeye ni sala yasanga amenye. ");
INSERT INTO sbk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","UBwana wakwe anza hudumlanye ivipande vibhile na humeshe inafasi yeka na abhilenkha, ewo bhanza lile nasie amino. ");
INSERT INTO sbk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Umwene wa humwanya ulinishifano wabhalende kumi bhahejile itala zyao na sogoke abhale huposhele ubwana wenji. ");
INSERT INTO sbk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bhasanu khanti yao bhakhali bhapumbavu na abhamwao bhasanu bhahali ni nejele. ");
INSERT INTO sbk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhalendu abhapumbafu bhahejile itara zyao, sangabhahejile amafuta gogonti. ");
INSERT INTO sbk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Abhalundu bhinjele ivyombo vimafuta peka ni tara zyao. ");
INSERT INTO sbk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Uwakati ubwana weji achelewa afishe, whunti bhakhakhatwa nutulo na bhagona. ");
INSERT INTO sbk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lakini uwakati wa nusiku pakhanti khahali ni shingo, 'ENyi, ubwana weji! Fumi khonze mposhele.' ");
INSERT INTO sbk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ndipo ewho abhalendu bhakhadamula na khonzye itala zyao. ");
INSERT INTO sbk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bhala abhapumbavu bhabhawhuzya bhala bhinjele, 'Mtipele isehemu yi mafuta genyu ate itala zyetu zizima.' ");
INSERT INTO sbk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini bhala bhinjele bhakhayanga na hubhawhuzye, 'Huje sanganganza hutikwele ate namwe, eshi bhalaji hwabhakazya mkale madodo gagenyu.' ");
INSERT INTO sbk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lwabhabhala ukho akale, Ubwana wenji akhafikha, whunti bhabhakhali tayari bhakhabhala nao husikulukulu ya wenji, na uniango bhakhagalila. ");
INSERT INTO sbk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pamande bhala abhalendu abhamwao bhakhafikha, na yanje, 'Bwana, bwana tungulile.' ");
INSERT INTO sbk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini bhakhabhawozya, ane sangaimba meye.' ");
INSERT INTO sbk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eshi enyanji, aje sagamumenye isiku wala isaa. ");
INSERT INTO sbk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Fuandi sawa nu muntu yahuanza shola abhala hunsi iyamwao. Ahabhakwinzizye abhawomba mbombo bhakwe na hubhaleshele uutajili wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Weka akhapinye italanta zisanu, uwamwao akhapinye zibhile, ula umuntu akhashola akhasogola weee. ");
INSERT INTO sbk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ula yakhaposhea italanta zisanu akhasongoye ishandabhe abhale husiwhombele, na ziakhapapa italanta iziamwao zisanu. ");
INSERT INTO sbk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nape yakhaposheye italanta zibhile ziakhapapa italanta iziamwao zibhile. ");
INSERT INTO sbk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini umuomba mbombo yakhaposheye italanta yeka, akhasongoye akhabana igondi pasi, akhazieshela ihela ya bwana wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Gwa hashila umuda utali, ula bwana wa bhawombambombo ahawela na akhagomba amahesabu anao. ");
INSERT INTO sbk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ula umuombambombo yahaposheye italanta zisanu akhenzele na lente italanta iziamwao zisanu, akhamuozya, 'Ubwana ukhampelile italanta zisanu. Enya, impente ifaida italanta iziamwao zisanu.' ");
INSERT INTO sbk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ubwana wakwe akhamuozya, 'Eshee, muwomba mbombo mwinza na uligolosu! Uligolosu huvinti ividodo. Inzahupele atabhale ivintu vinchi vya pamwanya. Injila ashe nu bwana whakho.' ");
INSERT INTO sbk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Umuwombambombo yahaposheye italanta zibhele ahenzele na yanje, 'Bwana, ukhampinye italanta zibhile. Enya, impente ifaida italanta iziamwao zibhile,' ");
INSERT INTO sbk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ubwana wakwe akhamuozya, 'Ehee, muomba mbombo mwinza na ugolosu! uligolosu huvintu vinchi vya pamwanya. Injila ashe nu bwana wakho.' ");
INSERT INTO sbk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pamande yakhaposheye italanta yeka ahezele na yanje, 'Bwana, imenye aje awe ulimuntu khali. Uyibhila vyasanga utotile, na uhwenga vyasanga uweshele. ");
INSERT INTO sbk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ane nakhogope, nakhasogola ane nafisa italanta yakho pilongo. Enya, enepa yukhapiye yiliyakho.' ");
INSERT INTO sbk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lakini ubwana wake akhayanga na humuozye, 'Awe muomba mbombo mibhi na molo, ukhamenye aje iyibhila pasangaintontile na pasanga imbeshele. ");
INSERT INTO sbk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ihela yane uhuaziwilwe uwapele abhantu bhi benki, wakati wawele ane naposhelaga ela yahuline ni faida peka. ");
INSERT INTO sbk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Eshi muopi eyo italanta na mpele ula umuomba mbombo yalini talanta kumi. ");
INSERT INTO sbk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Shila muntu yalinasho anzahojelezewe zaidi- hata azidishibhe sana. Walakini wowonti yasanga alina hantu, hata hala khali nasho anzahupwe. ");
INSERT INTO sbk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Taji khonze muhinsi uyo umuomba mbombo umibhi yasangafaa, ukho hwahusabhe alile nasie amino.' ");
INSERT INTO sbk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Umwakati umwana wa Adamu lwakhaiyeza nu sisya wakwe, na abhatumi wonti peka numwene, panza akhale pamwanya yitengo lyakwe isisya. ");
INSERT INTO sbk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abhamunsi wonti bhahaiwongangana hwitagalila lyakwe, nape ahaibagula abhantu nanzi undimi shabagula ingole ni mbuzi. ");
INSERT INTO sbk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Anza hubhabheshe ingole ukhono gwake wa hunelo, bali imbuzi anza hubhabheshe ukhono wahumongo. ");
INSERT INTO sbk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nantele umwene anzahubhabhuzya wala bhabhali ukhono wahunelo, 'Nnzaji, mumusaiwilwe nu Daada wenyu, murithi uumwene uulekho kwa ajili yenyu ahuande huwandilo wa munsi. ");
INSERT INTO sbk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lwanahali ni nzala mwakha mpelile ishalye; lwanakhali jenu mwahakalibisizye; ");
INSERT INTO sbk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Lwanakhali bwinda, mwakhankwatizizye amenda; Lwanakhali minu mwakhanenyizye; Lwanakhafungwilwe mwakhezele.' ");
INSERT INTO sbk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ndipo abhagolosu bhahaiyanga na humuonzye, “Bwana, ndi lwatahalolile uli ni zala, lakhapela ishalye? Au uyumele ntakhapela amenze? ");
INSERT INTO sbk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na ndii takhalolile ulijenu takhakalibisya? Au uli bwindu takhakwatizya amenda? ");
INSERT INTO sbk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ndii takhalolile uli minu, au ufungwilwe na twahenza? ");
INSERT INTO sbk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na uumwene akhaiyanga na hubhawonzye, 'Lyoli ihumbawhuzya lyamuwombile epa hwakholowane udodo weka, mumbombeye nene.' ");
INSERT INTO sbk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Panza hubhawhuzye bhabhali ukhono gwakwe gwa humongo, 'Epanji huline mkhanilwe bhalaji hwanguli umoto wa wilawila uuweshelwe kwa ajili ya usietano ni impepo imbibhi, ");
INSERT INTO sbk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ane nakhali ni zala lakini sagumwakhampiye ishalye; nakhomele lakini sagamwakhampiye amenze; ");
INSERT INTO sbk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nakhali fenu sangamwahankalibisizye; Nakhali bwinda sanga mwakha mpinye amenda; nakhali minu na nakhapinyilwe, lakini sangamwakhanenyizye.' ");
INSERT INTO sbk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ewo nape bhaimuozya na yanje, 'Bwana, ndi twakhalolile uli ni zala, au uyumele, au ulijenu au uli bwinda au uliminu, au ufungwilwe sangatakhasajiye? ");
INSERT INTO sbk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Epo akhaiyanga na hubhawuozye, 'Lyoli ihumbawuozya, shila sanga mwahawombile hwaweka hwa bhadodo ewo, sangamwakhambombeye nene.' ");
INSERT INTO sbk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ebha bhakhabhala humalabha giwilawila bali abhagolosu huwomi wa wilawila.” ");
INSERT INTO sbk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","U Yesu lwabhamala ayanje inongwa ezyo zyonti, akhabhawozizye abhanafunzi wakwe, ");
INSERT INTO sbk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mumenye aje baada yisiku zibhile huzabhe ishikulukulu ishi pasaka na umwana wa Adamu bhanza hufumye hukhobhehanye.” ");
INSERT INTO sbk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pamande abhagosi wi makuhani nabhagogolo bha bhantu, bhakhatangeni peka hwakhala ukukhani ugosi yakhakwiziwanga Kayafa. ");
INSERT INTO sbk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhahali peka bhakhapanga ishahukhate u Yesu husiri na hubude. ");
INSERT INTO sbk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bhakhajili isakhawombeshe uwakati wa sikulukulu, aje isahafumile ivurugu hwabhantu.” ");
INSERT INTO sbk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","U Yesu lwahali Hubethania hunyumba ya Simoni mkoma, ");
INSERT INTO sbk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","lwahaigolosizye pameza, ushi weka akhezele akhanyumuye umkembe wahali na mafuta igi samani ingosi, akhanyunyulizya pitwe lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lakini abhanafunzi wakwe lwabhalola ijambo elyo bhakhavitilwe nayanje, “Yenu ihasala ine? ");
INSERT INTO sbk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ega tahabhajie ishiasi shigosi tibhapele abhapena.” ");
INSERT INTO sbk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lakini u Yesu, akhamenye eli, akhabhawuzya, “Shunu muhunavya ushe uno? Maana awombile ishintuishinza huline. ");
INSERT INTO sbk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abhapena mlinao isiku zyonti, lakini sangamzabhe peka nane wila. ");
INSERT INTO sbk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hwapashile amafuta mpele gwana, awombile esho kwa ajili ya sielwe ane. ");
INSERT INTO sbk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lyoli ihumbawozya, poponti izwi eli linzalimbelelwe munsi mwonti, ishitendo shawombile ushe uno, nantele shinzayangwa kwa ajili ya kumboshe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Weka wa bhala kumi na bhabhile, yahakwiziwanga Yuda Iskariote, akhabhalile huwagosi bha makuhani ");
INSERT INTO sbk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na yange, “Mnza hupeleshi nkisalinti?” Bhakhapimila u Yuda ivipande selathini ivihela. ");
INSERT INTO sbk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ahwande umuda ugo ahazile inafasi yahusaliti. ");
INSERT INTO sbk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hata isiku iliahuande makate gasanga gaweshelwe ichachu, abhanafunzi bhahamalila u Yesu na yanje, “Uhwanza hwi tiweshele ishalye shi Pasaka?” ");
INSERT INTO sbk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Akhabhawozya, “Bhalaji humjini hwa muntu fulani na mumwonzye, Umwalimu ayinga, “Umuda gwakwe ukalibiye. Ahwanza huimalezye ipasaka peka na bhanafunzi wakwe hu nyumba yakho.” ");
INSERT INTO sbk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abhanafunzi bhakhawomba nazi u Yesu shabhalajizizye, na bhakhandaile ishalye ishi Pasaka. ");
INSERT INTO sbk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lwayafika iliewela, akhakheye alye ishalye peka na bhanafunzi wakwe kumi na bhabhile. ");
INSERT INTO sbk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lwabhalianga ishalye ahabhawonzya, “Lyoli ihumbawozya aje weka kati yunyu anzahusaliti.” ");
INSERT INTO sbk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhakhazungumiye sana, weka weka bhahandile humwonzye, “Je, saga nene, Bwana?” ");
INSERT INTO sbk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ahabhawozya, “Ula yanzatobhele inyobhe yakwe peka nane humbakuli yanza husaliti. ");
INSERT INTO sbk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Umwana wa Adamu azasogole, nanzi shisimbililwe. Lakini umuntu yanza husaliti umwana wa Adamu! Indishinza hwa muntu uyo nkasanga ahapapwilwe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","U Yuda, ula ahali msaliti akhayanga, “Je!, Nene Rabi?” U Yesu ahamonzya, “Uyanjile ijambo elyo awe wewe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lwabhalianga ishalye, u Yesu ahenjile ikate, alisaya na akhamenya. Ahabhapela abhanafunzi wakwe akhayanga, “Eji mlye. Ungu bele gwane.” ");
INSERT INTO sbk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ahenga ishikombe ahasalipya, ahabhapela na yanje, “Mwelaji mwenti hweshi. ");
INSERT INTO sbk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ene danda yaindagano yane, yihwitikha kwa ajili ya winchi hubhasajile imbibhi zyao. ");
INSERT INTO sbk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lakini ihumbawhozya sanganahimwela antele amadondu ga mizabibu ega, hadi namwe huumwene wa Daada wane.” ");
INSERT INTO sbk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lwabhamalezya ahwembe ulwembo, bhakhasogola abhle hwigamba ilya mizeituni. ");
INSERT INTO sbk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nantele u Yesu akhawozya usiku uwhu amwe mwonti vitwe kwa ajili yane, kwa kuwa iyandihulilwe, Inzahukhome umchungaji ngole bhanza tabhanyishe. ");
INSERT INTO sbk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini lwanazyokha ane nakhaibhata ngalila abhale Hugalilaya.” ");
INSERT INTO sbk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lakini u Petro akhamwonzya, “Hata nkawonti bhakhane humambo gaganza hu hwaje, ane sangainza hukhane.” ");
INSERT INTO sbk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","U Yesu akhamwonzya, “Lyoli ihuwonzya, usiku uwhu shisele ihanda akunte, anzahukhane mara hatatu.” ");
INSERT INTO sbk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","U Perto akhamwozya, “Hata nkimbajie afye nawe, sangaimbala hukhane.” Na bhanafunzi wonti bhayanga shishesho. ");
INSERT INTO sbk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pamande u Yesu ahabhala nao amahali papahwetwa Gethsemane na akhabhawonzya abhanafunzi bhakwe, “Khali epa wakati ane imbala ukho alabhe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akhamwenga u Petro na abhana bhabhile wa Zebedayo na akhanda azungumile na sononoshe. ");
INSERT INTO sbk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nantele akhawonzya, “Umpepo ufinjile wane izungumie pangosi sana, hata ihwanza afye. Lakini epa mubhe masopeka nane.” ");
INSERT INTO sbk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akhabhala pilongolela hadondo, angwa gubama na alabhe. Akhayanga, “Daada wane, nkashe bhajie ishikombe eshi shinepe. Isakhabhe shihwanza ane bali nanzishuhwanza awe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akhabhabhalila abhanafunzi ahaweje bhagonile utulo, akhabhawozya Petro, “Shunu sangamlimaso nane hata isala lyeka? ");
INSERT INTO sbk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kesyanji na labhe ili msahahinjili mumajaribu. Iroho ili radhi, lakini ubele niwolo.” ");
INSERT INTO sbk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akhabhala wee imala ya bhele na labhe, akhayanga, “Daada wane, ijambo eli sagalibhajie hunepe ni lazima imwelele ishikombe eshe, amapenzi gakho gatimile.” ");
INSERT INTO sbk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akhawela nantele akhabhaga wagonile utulo, amasogakho gakhali mamwamu. ");
INSERT INTO sbk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nantele akhabhalekha akhabhala akhalabha amara ya utatu akhayanga inongwa zizila. ");
INSERT INTO sbk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pamande u Yesu akhabhabhalila abhanafunzi wakwe na hubhawhuzye, “Mulisha mgonile tu natozye? Enyanji isaa ilikaribu, na umwana wa Adamu akhatwa mumakhono mwabha bhibhi. ");
INSERT INTO sbk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Damulaji, tisongolanje. enyi ula yahusalinti akaribiye.” ");
INSERT INTO sbk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lwakhali bado ayanga, u Yuda weka wa bhala kumi na bhabhile akhenza namapanga ni ndungu. ");
INSERT INTO sbk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nantele umuntu wahusaliti u Yesu akhabhapelile ishara, ahayenje, ula yinza hubusu, ndiyo yuyo. Khante.” ");
INSERT INTO sbk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Papepo akhezele hwa Yesu akhayanga, “Salamu, Mwalimu!” Na akhabusu. ");
INSERT INTO sbk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","U Yesu akhamwozya, “Kondani, liwhombe lila ulinalyo lililetile.” Ndipo bhahenza, nagolosye inyobhe hwa Yesu na hukhante. ");
INSERT INTO sbk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Enyi, umuntu weka yakhalipeka nu Yesu, akhagolosesye inyonbhe yakwe, akhachomola ipanga lyakwe, akhakhoma umuomba mbombo wa kuhani ugosi, na hudumule ikutu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ndipo u Yesu akhamuozya, wezya ipanga lyakho puyejile, kwa kuwa wonti bhabhatumila ipanga bhanza hwangamile ni panga. ");
INSERT INTO sbk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Myinga sangaimbajie hukwinzye udaada wane, nape angantumila abhalugu zaidi ya kumi na bhabhile ya awatumi? ");
INSERT INTO sbk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eshi shihwaziwa atokele ili amandiko katimile hwidala elyo?” ");
INSERT INTO sbk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Uwakati whuwho u Yesu akhabhawuzyo bhabhawungene, “Je! Mwenzele namapanga nidungu hukhante nazi yahupa? Kila lisiku nakhakheye namwe mshibhanza, nabhamayizyanga sanga mwakha kheute! ");
INSERT INTO sbk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini gonti enga gawombeshe ili amaandiko ga watumi gatimile.” Ndipo abhanafunzi wakwe bhakhanekha bhakhashembela. ");
INSERT INTO sbk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhala bhabhakhate u Yesu bhakhatwala hua Kayafa, ukuhani ugosi, amahali epo abhasimbi na agogolo bhahawongene peka. ");
INSERT INTO sbk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lakini u Petro akhafuatle hwisinda huhutali mpaka hushumba sha kuhani ugosi. Ahinjila mhanti akhakhala peka nu ninzi alole shashinza fumile. ");
INSERT INTO sbk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basi abhagosi bha makuhani ni baraza lyonti liahazanga uushaidi wileukha juu ya Yesu, ili bhapate hubude. ");
INSERT INTO sbk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bhakhafumie amashaidi winchi, lakini sangabhahayeje imbibhi yoyuti. Lakini pamandi amashahidi bhabhile bhakhafumila hwilongolela ");
INSERT INTO sbk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na bhayanga, “Umuntu uno akhayenje, “Imbajiye agwisye ishibhaza isha Ngolobhe na hushizenje nantele husiku zitatu.” ");
INSERT INTO sbk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ukuhani ugosi ahemelela na humwonzye, “Saga ujibu? Ewa bhahuwhuzya wele juu yakho?” ");
INSERT INTO sbk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini u Yesu akhapuma mye. Ukuhani ugosi ahamwozya, “Nanzi uNgolobhe shakhala ihulazimisya utawhuzye, awe wewe Klisiti, Umwana wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","U Yesu ahabhawuzya, “Awe wewe uyanjele ijambo elyo. Lakini ihuwozyo, ahwande eshi nahwendelele, unza hunole Umwana wa Adamu akheye ukhono unelo uulinigovo, na ahuenza humawengo gahumwanya.” ");
INSERT INTO sbk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndipo ukuhani ugosi akhazebula amenda gakwe nayanje, “Akhanile! Je, tihwanza washi nayanje uushahidi? ");
INSERT INTO sbk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Je! Msebhashi bhayanga nahumwozye, “Ahuanziwa afye.” ");
INSERT INTO sbk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nantele bhakhashelela amate humasona hukhome ingumi na huchete amakofi ni nyobhe zyao, ");
INSERT INTO sbk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na bhakhamuozya, “Yanga, wewe Klisiti. Yunanu yachapile?” ");
INSERT INTO sbk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Isala izyo u Petro ahakheye huoze huu kumbi, umuomba mbombo wishishi ahamalila nahumuozye, “Awe nawe ulipeka nu Yesu wa Galilaua.” ");
INSERT INTO sbk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini ahakhanile hubele yao wonti, ahanga sangaimenye ahantu huyanga.” ");
INSERT INTO sbk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lwabhala hunze huniango, umuomba mbombo uwamwao wishishi ahanola na hubhawhuzyebhabhahali epo, “Umuntu uno nope alipeka nu Yesu wa Nazareti.” ");
INSERT INTO sbk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Akhakhana tena na lape, ana sangaimenye umuntu uno.” ");
INSERT INTO sbk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Umuda kidogo pamande, wala bhabhahemeleye karibu, bhakhamalila nahumuozye u Petro, “Na lyoli awe nawe ulipeka nao, hata njango yakho ilolesya.” ");
INSERT INTO sbk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pahandile akhana na lape, ane sanga imenye umuntu uno,” papepo ihanda ikhakuta. ");
INSERT INTO sbk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","U Petro ahakumbukha inongwa yakhamuozezye u Yesu, kabla yihanda isele akute unza hukhane mara hatatu.” ");
INSERT INTO sbk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Amasala gishandabhe akhafikha, khabhagosi wonti bha makuhani na bhazee bha bhantu bhakhaliye injama juu ya Yesu wapate hubude. ");
INSERT INTO sbk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhakhapinya, bhakhanongozya, bhafishia hwa liwali u Pilato. ");
INSERT INTO sbk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nantele u Yuda, yahali msaliti, akhalolile aje u Yesu tayari alomgwile, akhazungumie wawezya ivipande selasini ivi hela, hwabhagosi wa makuhani na bhazee, ");
INSERT INTO sbk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","na akhayanga, “Imbombile imbibhi ya huisaliti idada yisanga ilimbibhi.” Lakini bhakhamonzya, “lihutuhusu lyenu ate? Genyaye ego wewe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nantele wavitanga pasi vila ivipande vinhela hwishibhanza, na ahasogola na huiyoje mwene. ");
INSERT INTO sbk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ugosi wa makuhani ahavyenga vila ivipande vi hela na ahayanga, “Sagashiza kuibheshe ihela ine mhazina, kwa sababu yi danda.” ");
INSERT INTO sbk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bhakhayangana peka ihela itumishe akalile ugonda gwa whumbile azyeshele abhajenu. ");
INSERT INTO sbk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwa sababu eyo ugunda ugwa likwiziwa “Guda gwi danda” hadi ilelo eshe. ");
INSERT INTO sbk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nantele ela inongwa yikhayangwile na abhatumii u Yeremia liahatimila, aje, “Bhakhejile ivipande selasini ivi hela, ibeyi yihapangwilwe na bhantu bha Israeli hwa ajili yakwe, ");
INSERT INTO sbk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bhakhatumie ugonda gwa muwhumbaji nazi u Bwana shakhelezezye.” ");
INSERT INTO sbk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Eshi u Yesu ahemeleye hwilongolela lya Liwali na uliwali akhamwozya, “Je! Awe uli mwene wa Wayahudi?” U Yesu akhajibu, “Awe uyejesho.” ");
INSERT INTO sbk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini lwawasitakiwa na bhagosi wa makuhani na bhazee, saga ahajibu lyolyonti. ");
INSERT INTO sbk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nantele u Pilato akhamuozya, “Sagauyuvyezye amashitaka gonti agakho?” ");
INSERT INTO sbk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini sanga akhajibu ineno hala lyenka akhaswinga uliwali. ");
INSERT INTO sbk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hwisiku zisikulukulu ihali kawaida uliwali humungulile yapimyilwe weka yasalulilwe na winchi. ");
INSERT INTO sbk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Uwakati uwo bhahali nuyoapinyilwe wimatata ilawa lyakwe yu Baraba. ");
INSERT INTO sbk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lwabhawungene peka upilato akhabha wuzya yunanu yamuhunza imungulile kwa ajili yunyu?” Ubaraba au Uyesu yahwetwa Klisiti?” ");
INSERT INTO sbk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Maana akhamenye aje tayari bhakhe kwa sababu bhavitililwe. ");
INSERT INTO sbk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wakati akheye hwitengo ililonzi, ushe wakwe akhatwalila ineno aje, “Usakawombe lyolyonti hwa muntu uyo yasanga alini mbibhi. Yaani indawile hani ilelo mundonto kwa ajili yakwe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ndipo abhagosi wa makuhani na bhazee bhakhabhakondelezya amakutano aje bhanabhe u Baraba, u Yesu afye. ");
INSERT INTO sbk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Uliwali akhabhawuzya, “Yunani kati ya bhabhile yamuhwa nza amwe ineshele?” Bhakhayanga, “Ubaraba.” ");
INSERT INTO sbk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","U Pilato ahawawuzya, “Imombe wele u Yesu yahwetwa Klisiti?” Wonti bhahamuozyo, “Amayembe” ");
INSERT INTO sbk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nape ahayanga, “Shunu likosashi awombile?” Lakini bhahojelela apwaje isauti hata humwanya hani, “Ayembe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Epo Upilato lwa saga awajiye awombe lyolyonti, ivurugu ziahandile ahenga amenze ahazuguzila inyobhe zyakwe hwilogolela ilya winchi, na yanje aje, “Ane sagandi ninogwa juu yi danda iya muntu uno yasanga alinibibhi. Genyanji ega mwe mwemwe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Awanti wonti bhahayanga, “Idanda lyakwe liwe juu yetu na bhana wetu.” ");
INSERT INTO sbk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Epo ahamungulila u Baraba wao, lakini ahakhoma amijeledi u Yesu na ahabhapela awene abhale hukhobhehanye. ");
INSERT INTO sbk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nantele abharugu bha liwali bhahamwenga u Yesu mpaka Praitorio ni kundi igosi lya bhalongu wonti bhakhamunganila. ");
INSERT INTO sbk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhahavula amenda gwakwe na hukwatizye igololeli langi ishamamu. ");
INSERT INTO sbk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tena bhahagomba itaji yi mivwa na bhaiwehe hwitwe lyakwe na hususye, bhahayanga, “Salamu, Wamwene wa Wayahudi?” ");
INSERT INTO sbk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na bhaswelela amate, na bhahenga imwanzi na hukhome hwitwe. ");
INSERT INTO sbk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wakati bhahususya bhakhavulile igolole na hukwatizye amenda gakwe, na hunogole abhale hukhobhehanye. ");
INSERT INTO sbk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lwabhafuma hoze, bhahanola umuntu afume ilawa Krene ilawa likwa yu Simeoni, uyo bhakhanazimisya abhale nao ili anyumule ishikhomehayo shakwe. ");
INSERT INTO sbk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lwabhafikha pala Pagaligotha, imaana yakwe, “Ieneo lya ifupa litwe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bhakhapela siki yabhasnganyenye ni nyongo amwele. Lakini lwawonga saga ahamwela. ");
INSERT INTO sbk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lwabha khomehanya, bhahagabhana amenda gakwe bhahahoma ikura. ");
INSERT INTO sbk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na bhahakhala na humwenye. ");
INSERT INTO sbk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hwitwe lya Yesu bhahaweshele inongwa yakwe ihabhaziwanga, “Uno yu Yesu, umwene wa Wayahudi.” ");
INSERT INTO sbk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bhabhahupa bhabhile bhahakhobhe nywepeka numwene, weka ahali upande wa nelo wakwe na uwamwao wa humongo. ");
INSERT INTO sbk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhala bhabhashilanga bhasosyanga bhahayizianga amatwe gao ");
INSERT INTO sbk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na humozya, “Awe wawazaga anaganye ishibhanza na azenye husiku zitatu uyokole wewe! Nkuli mwana wa Ngulubhe, ikha pasi uyepe mumalabha!” ");
INSERT INTO sbk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Katika ihali yiyela abhagosi wa makuhani bhasosyanga peka na abhasimbi na abhazee, na humuozye, ");
INSERT INTO sbk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ahokoye abhanche. Yu mwene wa Wayahudi. Na ayishi pasi afume mumalabha, epo tinza humweteshe. ");
INSERT INTO sbk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ahasobhenye Ungulobhe. Lekha Ungolobhe amwokole eshi nkashele ahuanza, nkashele ahuanza, nkashila ahayenje, 'Ane nene mwana wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na wala bhabhahupa bhabhakhomagenywe peka nu Yesu nape bhahayenje hususye. ");
INSERT INTO sbk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Eshi afume msaa sita hwahali ahinsi munsi yonti hata saa tisa. ");
INSERT INTO sbk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lwayafiha saa tisa, u Yesu ahalila husauti ingosi, “Eloi, Eloi, lama thabakithan?” Imana yakwe, “Ngolobhe wane, Ngolobhe wane mbona undeshile?” ");
INSERT INTO sbk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Uwakati uwo bhahali awamo bhemeleye pala bhahovya lwayanga, “Ahukwinza u Eliya.” ");
INSERT INTO sbk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Haraka weka ahashembela ahwenje isifongo na huimyeme isha mwele ishikhali, ahaibhiha huwanya yikwi na hupele ili amwele. ");
INSERT INTO sbk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nape bhabhahasageye bhahayanga, “Neshe mwene, leshe tenye u Eliya nkahwenza humwokole.” ");
INSERT INTO sbk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nantele u Yesu ahalila husauti ingosi aifumya iloho yakwe. ");
INSERT INTO sbk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Enya, ipazia lya mshibhanza lyahazembukha isehemu zibhile, afume humwanya mpaka pasi. Na insi ihayingile, na amawe gahabazushe vipande. ");
INSERT INTO sbk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amakaburi gahugushe amabele gabhagolosu wichi bhabhahagonile utulo bhahazyoshile. ");
INSERT INTO sbk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bhahafumile mumakaburi lwawazyoha, bhahawinjila umji ugolosu, na bhahakhoneha na winchi. ");
INSERT INTO sbk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Basi ula uakida na walabhahamwenyaga u Yesu bhahalola itetemeko na amambo gagahafumiye, bhahabha nuwongo sana nayanji aje, “Lyoli onu ahali mwana wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Awashe winchi bhahafuatile u Yesu afume Hugalilaya ili humwombele bhahali pala humwenye afume hulali. ");
INSERT INTO sbk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mhati yao bhahali, Umariam Magdarena, Umariamu umaye wa Yakobo na Josefu, na umaye wa wana wa Zebedayo. ");
INSERT INTO sbk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lwayafiha ilyebhela umuntu utajili afume Arimathayo, yahetelwa u Yusufu, nantele ahali mwanafunzi wa Yesu. ");
INSERT INTO sbk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ahamalila u Pilato hunabhe ubele gwa Yesu. Upilato ahalajizya bhapele. ");
INSERT INTO sbk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Uyusufu ahawejile ubele ahaupinya na menda gi sufi inzeru, ");
INSERT INTO sbk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ahaugonya mwikaburi lyakwe ipya lyalyahachonjilwe mwiwe, alafu ahawungulusya iwe igosi lyahazinga uniongo gwi kaburi ahasogolo. ");
INSERT INTO sbk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Umariamu Magdalena na Umariamu uweche bhahali pala, bhahenye pikaburi. ");
INSERT INTO sbk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Isiku lilyahafuata lyahali lisiku lya maandalizi, abhagosi wa makuhani na Mafarisayo bhahawungeni peka hwa Pilato. ");
INSERT INTO sbk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bhahamuozya, “Bwana, tuzushe aje ula wilenkho lwahali momi ahajile, 'Baada yi siku zitatu anzazyoshe.' ");
INSERT INTO sbk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eshi lajizya aje ikaburi bhalinde sallama mpaka isiku ilyatatu. Nkasanga shisheshe abhanafunzi wakwe bhanza hweze humwibhe na wazayanje hwa wantu aje azyoshele afume mfye, na ilenkha ilyamwisho linzabhe libhibhi ashile ilyahwande.” ");
INSERT INTO sbk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","U Pilato ahabhawuozya, “Eji abhalizi. Bhalaji muweshe usalama shamulolile.” ");
INSERT INTO sbk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basi bhahabhalile aweshe usalama hwikaburi iwe lyahahomwa umuhuri naweshe abhalinzi. ");
INSERT INTO sbk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pamande ilyewele isiku ili Sabato, isenye lwalyaswanga awale isiku ilyahuande ijuma, Umariamu Magdalena, nula Umariamu uweche bhahawalile ahwenye ikaburi. ");
INSERT INTO sbk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bhenya hwahali itetemeko igosi, maana ukuwa wa Bwana ahishile huliwungu lushe iwe lila, alafu ahali khalila. ");
INSERT INTO sbk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Isura yakwe ihalije umeme na amenda gakwe gahali mazelu aje choka. ");
INSERT INTO sbk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhala abhalizi bhahamema uwonga bhabhaje wofyinye. ");
INSERT INTO sbk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ola ukuwa akhabhalanganyizwa wala awashe akhabhawozya bhasahahongope maana imenye aje muhumwanza u Yesu, yahakhomayenywe. ");
INSERT INTO sbk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Numo epa, lakini azyoshele nanzi shakhabhawuzezye. Inzaji mwenye pabhakhagonezye u Bwana. ");
INSERT INTO sbk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bhalaji nalinali hubhawuzye abhanafunzi wakwe, 'Azyoshile afume hwabhafwe, enyi abhatagaliye Hugalilaya. Ukho hwamuzahunole.' Anya ane imbawozezye.” ");
INSERT INTO sbk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bhala abhashe bhakhasongola pale pikaburi nalinali shabhali nuwoga na bhahashiye sana, bhakhashembele hubhabhuzye abhanafunzi wakwe. ");
INSERT INTO sbk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Enya u Yesu ahatangana nao ahangaa, “Salamu.” Bhala abhashe bhahenza na hukhante amanama gakwe, nantele bhahapunta. ");
INSERT INTO sbk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nantele u Yesu ahabhabhuzya, “Musakhahongope, bhalaji mubhawuzye abhaholo bhane bhalongolele Hugalilaya. Ukho bhaza hundele. ");
INSERT INTO sbk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wakati wala awashe bhabhalaga enya abhamo abhalinzi bhahabhala humjini na hubhabhuzye abhagosi wamakuhani amambo gonti gagafumiye. ");
INSERT INTO sbk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nepe amakuhani twabhahatangana na bhazee, nayangane ijambo elyo peka nao, bhahafumizye ishiasi ishigosi shi hela lwabhala abhalogo ");
INSERT INTO sbk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na hubhabhuzye, “Yangaji hwabhamwao aje, 'abhanafunzi wa Yesu bhahezele nusuku ahwibhe ubele gwa Yesu lwatigonile ante.' ");
INSERT INTO sbk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ihabali ene nkifishile uliwali, ate linza hubebelezye na hubhefuezye amwe amashaka gonti.” ");
INSERT INTO sbk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bhala abhalugu bhahazienga ihela zila nawombo shabhawuzewelwe. Ihabari ikheneyesana hwabhayahudi ilekho mpaka ilelo. ");
INSERT INTO sbk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lakini bhala abhatumi kumi na moja bhahabhalile Hugalilaya, hula hwigamba hwakhabhawuzezye. ");
INSERT INTO sbk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lwabhahanola bhakhaputile. Walakini abhamo bhakhalola ishaka. ");
INSERT INTO sbk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akaja akawambia akisema, “Nimepewa mamlaka yote duniani na mbinguni. ");
INSERT INTO sbk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eshi bhalaji mubhabheshe abha munsi wonti abhe bhanafunzi, wuoziaji hwitawa lya Daada nalya mwana nilya upepo ufijile. ");
INSERT INTO sbk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mubhamanyizye nabhenishishi humambo gonti gimbalajizizye, eye ane indipeka namwe wilawila, hata mumalishilo wa munsi. ");
INSERT INTO sbk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ugu wandilo uwanlumbilile izya Yesu uKilisiti. ");
INSERT INTO sbk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nishi pihasi mbilwe nukuwa Isaya, “Enya, ituma umuntu wani witazi lwaho, uumo uwandale idala lwaho. ");
INSERT INTO sbk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sauti ya muntu uwakhola wipoli, “Kamiliswaji idala lwa Bwana; zigolosuaji amdala gakwe.” ");
INSERT INTO sbk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","U Yohana ahinza, ahanzhele awonzwa wipoli nalumbelele ulwozwo ulwawiyiswe sameshe imbivhi. ");
INSERT INTO sbk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Inzi yunti iya Yudaa na wantu bhudi wa Yelusalemu bhala yawamwene bhanga bhawozewa numwene isoho yo ndani bhasangamaga imbi zyao. ");
INSERT INTO sbk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","U Yohana ahali akwata amenda gimoya gingamiya nukanda ngui nkwembe musana gwakwe, alwanga ikhopha nu woonshi wa wipoli. ");
INSERT INTO sbk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Alumhelelaga nayaje, “Ajwele omo aweza palene ya nikhonsana ani sayaiwezwa, sasga imbajile awishe pansi nawaule inyao zya malato gakwe. ");
INSERT INTO sbk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anle ihabhabhozyaga humhenze, lelo umwene aibhozya humheze huhala Uzelu Umuiza.” ");
INSERT INTO sbk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lihafumila isikulimo insiku izyo huje uYesu ahizele afume hu Nazareti ya wiGalilaya, ahozewa nu Yohana wisoho Yorodani, ");
INSERT INTO sbk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Epou uYesu pauha afumemeze, ahalola imwanya awihiha pamwanya pa mwene nishi injibha. ");
INSERT INTO sbk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Isauti ihafuma amwanya, “Awe uli Mwana Wani. Niphendeziwe sana nawe.” ");
INSERT INTO sbk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Shisho uhala alazima hwa awale wipoli. ");
INSERT INTO sbk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ali wipoli insiku amarogo ganhi, shajelwa nuSetano. Hali pandwemo na makhanu gamwipoli, abhandumi bhambela. ");
INSERT INTO sbk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ahishi afume Yohana akhatwe, Yesu ahiza hu Galilaya alumbelila inongwa zya Ngulubhi, ");
INSERT INTO sbk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ahayanga, “Abhalilo na utawala wa Ngulubhi mbhelile lambi nahwenteshe nishi alumbhelele”. ");
INSERT INTO sbk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ashizanya mushenje mushejenje ya Galilaya, halola uSimoni nu Andeleya uholowakwe usimoni bhaponya inyavu zwao mu nsumbi, pipo bhahali bhabhalobha. ");
INSERT INTO sbk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","U Yesu ahabhabhuli, “Ajeiza, nhizaji, dangaji izabhambeshe walolombe samantu.” ");
INSERT INTO sbk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nahazileha inyavu zyao na hunfwate. ");
INSERT INTO sbk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","U Yesu pajendanga apatali hashe, ahabola u Yakobo umwana wa Zebedayo na Yohana uholo wakwe; bhali mwitori bhalinganya lyavu. ");
INSERT INTO sbk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Abhakuga bhope bhafuta bhahaleha inyise wao za Zebedayo wahaleha mhati mwitori natumishi abhanji abhakondilwe, wahafuta. ");
INSERT INTO sbk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pa bhahafiha Kaperinaumu, isiku ku Lwatuye, uYesu ahinjila aputile nawamanyizye. ");
INSERT INTO sbk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bhaswiga asunde wakwe, alingane aje asundaga nishi umntu ulwali ni amuli nikama bhabhamanyizya na abhabhasimba. ");
INSERT INTO sbk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Npepo umunda gwogwa ahali umuntu wahijila paputilepao ali ni pepo ichafu, naakholaihalo, ");
INSERT INTO sbk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ayanga, “Tuli na henu ahabhombe nawe, uYesu wa Nazaleti? Uyinzile watwangamizye? Imenye uli winanu. Awe uuli mwaushe ulihovhe umwana wa Ngulubhi!” ");
INSERT INTO sbk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","U Yesu aidamila ipepo nayanje, “Bhuma na hufume muhati!” ");
INSERT INTO sbk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na iloho ibhibhi vhiihagwisya paka pazhi nafume wa mwene lwulwo shalila wisa utisana ya pamwanya. ");
INSERT INTO sbk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Awantu bhunti wa haswingaa, bhahabhuzanya na shila muntu, “Ili lwenu? Izinsundo phaa ilwali amuli? Hata ipepo azyamlila ipepo zyope zimwiente haa!” ");
INSERT INTO sbk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Inongwa afumilane numwene zyahenela uwakati bhobho mhati yikowa Galilaya. ");
INSERT INTO sbk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ishi lelo bada yafume huzi panyi poto, bhahinjila khaya wa Simoni nu uAndeleya bhali nu Yakobo nu Yohana. ");
INSERT INTO sbk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ishi ukhoyi wakwe uSimoni ali agonile bhinu alinihoma, mala yiyo bhahabhula uYesu ihali zyakwe. ");
INSERT INTO sbk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bhisho aheza, ahakata ukhata ukhono, na ubhisye humwanya; homa ihaleha wa mwene, handa wabhele. ");
INSERT INTO sbk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ulwebhe labhobho isanyapa liswile, bhaletelawa mwene abhali wa winu amabhasanyishilwe ni pepo. ");
INSERT INTO sbk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ikaya yundi ibhongana pandwimo mundwango. ");
INSERT INTO sbk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ahabhonwa bhundhi abhali bhanwinzeele ibhungo zinyinji, nakemele ipepo haga lehanga ipepo huje zhi yangaje pipo zwamenye. ");
INSERT INTO sbk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Abhuha na sha pwii sana, wali shahuli siku habhala pasa pabhoneha alabhanga uhwo. ");
INSERT INTO sbk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","U Simoni na bhunti bhala abhalibhunthi bhahaza humwaze. ");
INSERT INTO sbk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bhahumwaga handa bhule, “Bhunti bha huwanza” ");
INSERT INTO sbk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Abhabhula, “Salitubhale apanji nnzi yunti izyungula ili bhope oubho indumbilile. Shashisho inzile ipa.” ");
INSERT INTO sbk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ahala ajenda mugali ya mwunti, abha azyugula mnyipoto zyabho mwunti nakemele vhepele ipepo. ");
INSERT INTO sbk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uwikoma ahezawamwene. Ali ahulamba; ahafugamila amafugamo agabhala, “Khashele uwanza ugawezaa mbeshe mwinza.” ");
INSERT INTO sbk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Abuwagwa ni phana uYesu hagolozya ukhono gwakwe nahukhate habhala, “Nina. Uwe safi.” ");
INSERT INTO sbk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hashe lwene ukoma bhuhamwepa, ahabhasa safi. ");
INSERT INTO sbk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","U Yesu ahasunda hukhali shilaga shaulilo, ahabhola, ");
INSERT INTO sbk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Uhakiswaje saga unyama muntu yaya hyanyunti, lelo shilaga, uwibhonesye wa puti, natowe dhabihu hunoyaje u Mose alajizye shasha awi yozye isha manyishe wane.” ");
INSERT INTO sbk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lelo abhala aubhula kila muntu na wenezye ineno sana hata uYesu haga ayendela abhale humujini huwa bhuushe. Hivho pa falanga nabhantu abha heza wamwene abha bhafume wunti. ");
INSERT INTO sbk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ahabhuya Kaperinaumu husiku indolwene ihuvhewa hujeinsiku nyishe lwene alihukhaya. ");
INSERT INTO sbk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Abhantu wabhinji sana waliwha bhunghine pala ha gahali shinafani mwakwe atieleile ya pala mu ndwango, nu Yesu ahayanga izwo wa bhene. ");
INSERT INTO sbk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Abhantu bhashe bhahinza wa mwene bhahata umuntu uwa polile; abhantu bhantenine. ");
INSERT INTO sbk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lelo pahakunwa hufishile alengane yau winji wantu bhahefwa bhasanyangulanya humwanya yinyuma pipo awantu walivhinji. Wakununwaga palitubhulailina bahiswa ishitandashila bhanyemulile umtu wa polile ali agonile. ");
INSERT INTO sbk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Halola umwoyo gwa mbanago, Yesu alibhule mutu ulayapolile, “mwanawani, ibhimbi zwaho zihombashilwe.” ");
INSERT INTO sbk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lelo bhamo abhasimbi bhala khale bhawitosa humoyo gawo, ");
INSERT INTO sbk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bhahayanga moyo gao awezizye bhule ayanje eshi? Aliligaa! Bhaga umuntu huje awa uweefe idhambi isipokuwa Ungulubhi mwene mwene yawezya?” ");
INSERT INTO sbk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","U Yesu awimenye amwo gwakwe izyabhasibhaga kati yabho. Abhabhula bhebho, “Lelo yenu mushebhabhisho moyo nginyu? ");
INSERT INTO sbk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lwenu iphuphusho sana aayanje wa muntu uwapolile, 'Aje imbibhi zyaho usajilwe' ama ayanje' Imelila, ega ishigonelo nishitala shaho, ujenda jee?' ");
INSERT INTO sbk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lelo ili bhapate amanye aje Mwana wa Muntu ani uwamuzi uwa huhoshele umuntu imbibhizyaho zihoshilwe ahabhulau uwahobhushile uwapolile, ");
INSERT INTO sbk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ibhula awe, bhuha, ega ishigonelo shaho, ubhalaje huliwe.” ");
INSERT INTO sbk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ahemenlila phepo naweje ishigonelo shakwe, ahanje nda munyumba yashala muntu, esho bhundhi bhaswinga nahusalifwe Ungulubhi usisya, bhayanga “Shikulu, satulole inongwa na shiine.” ");
INSERT INTO sbk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ahashila andhele munshinje munshije idimi nikundi ilwa bhantu bhundhi bhala gawa mwene abhansunda. ");
INSERT INTO sbk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aliashizanya alola uLawi mwana Alfayo akhele isehemu yakusanya isongo abhula, ahaga “Nfhatanje.” Ahimenlhila nahudaje. ");
INSERT INTO sbk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uwakati uYesu alwangai ishale munyumba ya Lawi bhabhuganyaga na wantu imbibhi bhaha bha bhalwanga nu Yesu nasudwe bhakwe, phepo phipo bhalibhinji bhali bhahudaga. ");
INSERT INTO sbk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ulwo asimbi, abhahali, Mafalisayo pabhahalola uYesu alwa na mbibhi adhele bhahunganya isongo, bhahabhula asunda abhakwe, “Lelo yenu anabhunganya isengo nata nabhomba imbibhi?” ");
INSERT INTO sbk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","U Yesu pahuvha isho ayanga, “Ishi awantu ahali bhiza amhele gao hawaziwa husiphitali; bhatu abhinu tuu bhabha waza saga ize. Awanzea bhiza abhihaki, lelo abhibhi.” ");
INSERT INTO sbk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Asudwa awa Yohana na Amafalisayo wali haga bhalwa. Wamo bhalila bhabhulile henu asundwa abha Yohana na mafalisayo habhaleha alwe, lelo asundwa bhaho bhala habha ngalila? ");
INSERT INTO sbk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","U Yesu ahabhula, “Ishi uwa tanjile hushahe agawezya agalilaje alwe uwakati bhobho umwani sha nabhene? Khashele umwani shikukukulu shali pepo nao? Lelo walwalwunthi umwa khashele bhalinabho hawezihujefunje.” ");
INSERT INTO sbk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Insiku ziwhiza alo ubwana nashikulukulu paishila nhipopo bhaifunga. ");
INSERT INTO sbk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Numo umuntu uwamama umwenda ukulu mumwenda upha mu mwenda ukulu kulu, pakashinzavhe shashe piletu, nazembushe uluwiwi afumine ni lwolizaduhane shibhibhi. ");
INSERT INTO sbk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Numo umuntu uwaponya ihobwa ipha muvhilhelo ivilazu, lelo ihobwa sibhavibazulanye vhonti vibhele nai hombwa navivho vibhabazushe nateje. Amana gakwe, nhviha imbwa ephwa muvilo ivipha.” ");
INSERT INTO sbk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Isiku limo uYesu ahashizanya pisiku ilwantu ye humagunda gamo gamo enya afundiwa bhakwe handa bhamo bhamo bhanda alwe amazhali ingingano. ");
INSERT INTO sbk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Amafarisayo bhabhabhula, “Enya, yenu bhamba gasa ganghigo ahandhu hasa haho inje yitalatibu pisiku ituye Sabato?” ");
INSERT INTO sbk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Habhabhula, “Sagamumanyile hala habhomba u Daudi pahazaga palini nizala— umwene nabhala ali nao umwene? ");
INSERT INTO sbk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ishahabho munyumba ya Ngulubhi ulwa Abiathari pali puti ugosi ahalwa ibhumnda ilwa bhiewelwa pitazi— ilwa shali shizyonga ishitalatibu wamuntu wabhodhi ila waputu—-apele ga vimo vimo wabhala bhali nabho?” ");
INSERT INTO sbk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","U Yesu ayaga, “Sabato ihabhombilwe kwa ajili ya mwanadamu, saga wamwanadamu kwa ajili ya Sabato. ");
INSERT INTO sbk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Isho Umwana wa Adamu ni Bwana, hata wi Sabato.” ");
INSERT INTO sbk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Antele ahijila muhati mwaputile muka mwali nu muntu uwikono ugwaupolile. ");
INSERT INTO sbk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abhantu bhamo bhadagaga muphiphi huje bhenye khashele azahuponyeisi kuli Sabato aje bhatake. ");
INSERT INTO sbk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","U Yesu ahabhula umuntu uwikhono ugwagupolile bhuha imilila pahati iyibhugaine.” ");
INSERT INTO sbk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ishihabhala abhantu, “Jee shinza abho iliza lwaponwe pisiku li Sabato au ilwa joje; ulwa sikeli, au gasa?” Gawaziwa aponwe agoje. ");
INSERT INTO sbk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bhamamhee ahabhenya wilwoyo asononoha pipoiliyaukhame wimoyo gao ahabhula muntu, “Goloswa ukhono gwaho.” Augoloswa nu Yesu aguponwa ukho gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mafalisayo bhafumahuzi bhahabhomba zimozimo nu Mahelode aziade umwene nahugoje. ");
INSERT INTO sbk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Phipo uYesu, nasandwa bhakwe bhashila hunzumbi, ni mbhuga nhingosi iyabhantu ihabhadagaga ihafumaga hu Galilaya na Uyahudi ");
INSERT INTO sbk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na fume Yelusalemu nafume indumaya na witanzi yi Yolodani na vhelane yitilo ni Sidoni, imbhuga ingosi, phihuvhwa shila hantu ahaga ahabhomba, bhabhiza wa mwene. ");
INSERT INTO sbk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ahabhamhula asundwa bhakwe atayalisye itulyi idodo kwa ajili ya mwene phipo imbhuga, ili bhangaje husoje. ");
INSERT INTO sbk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pipo abhapo mwaga winji, ilikila mntu uwali na malamba anihu hufishile ili apata manzwe. ");
INSERT INTO sbk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Paphunti ipepo ichafu panwalolaga zywa gwaga paka panzi witanzilwa kwe nalile, bhayangaga, “Awa uli Mwana wa Ngulubhi”. ");
INSERT INTO sbk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Abhamlila abhasimisizya agamde awubhushe. ");
INSERT INTO sbk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abhala pamwanya pigamba, abhakuda abhanzaga, mbahabhala wa mwene. ");
INSERT INTO sbk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Abhasalula ilongo limo na bhantu bhabhili(abhakaga atumwa), ili bhambe palushimo nu mwene ili awe zywaje atume alu bhilile, ");
INSERT INTO sbk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na bhamlila azywefhe iphepo. ");
INSERT INTO sbk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Abhasalula ilongo nabhaji bhabhile uSimoni iyapela itawa ilya Petulo, ");
INSERT INTO sbk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo umwana wa Zebedayo, nu Yohana uholo wakwe uYakobo, apelilwe itawa ilwahuje Bonagesi, ibho ni bhana awungume, ");
INSERT INTO sbk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Andeleya, Filipo, Bartholomayi, Mathayo, Tomaso, Yakobo, umwana wa Alfayo, thadato, Simoni Mkananayo, ");
INSERT INTO sbk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na uYuda Iskariote, ambaye asambushila. ");
INSERT INTO sbk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nhipo ahabhala khaya, mbhuga ya bhantu bhahinzha bhunti nabho nanthele, saga bhahawezywa na hulwe imbumunda. ");
INSERT INTO sbk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abhana bhakwe pabhuvha ahapango mhiho, bhahabhala hukhute leloinjele, zyakwe zulushile, “Amerukwa na akili”. ");
INSERT INTO sbk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Asimbi bhahenza afume mu Yelusalemu bhayanga, “Asangi ne Beelzebuli,” uwa tawali ni phepo awefwa amapepo”. ");
INSERT INTO sbk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu abhakuga wamwene nana yanje navho hushifwani, “Haga pauli uSetano aha mwefya Setano? ");
INSERT INTO sbk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Utawala khaugabhanishe bhuwo, utawa uwo ungimilila. ");
INSERT INTO sbk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inyumba khigabhanishe yiyo i nyumba iyosigawezya awemelele. ");
INSERT INTO sbk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngashele uSetano ainushe shinje ishashivhi yuyo na gabhanishe, hangi mivhila, na azabhe afishile hu mwisho wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lelo nomo uwagawezya hata umo awinjile muhati nyumba iya muntu uwikone nawivhe ivintu vhakwe bila hupinye umwanikhone nasoti khasha abhunga nyaje ivya nyumba. ");
INSERT INTO sbk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Lyoli imbabhula ibhivhi zyunthi izywa bhanabha bhantu zyai hobhoshelwa, naligo gawayanga, ");
INSERT INTO sbk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lelo uwiliga uhala uzelu hagaihoshe lwa na mwaha anu lozi uwimbivhih uwawila nawila.” ");
INSERT INTO sbk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu alilisema hili kwa sababu walikuwa wakisema, “Ana roho chafu”. ");
INSERT INTO sbk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pepo anyina naholo bhakwe bhahenza na bhemelele huzi. Bhahatuma umuntu, hukuje. ");
INSERT INTO sbk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Abhantu bhali bhinji bhalipepe numwene bhabhula, “unyina waho naholo bhaho bhali hunzi, bhahu waza awe”. ");
INSERT INTO sbk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Abhanjibula, “Yu nanu inyina wani na holo bhani?” ");
INSERT INTO sbk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ahabhenya bhali bhakhele bhazyungulele, ahayanga, “Enya, ibha bhamaibhani na holo bhani! ");
INSERT INTO sbk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngunthi mapezi gakwe Unguluvhi, umuntu uyo holo wani, nanyirumbu wani na yumayi wani.” ");
INSERT INTO sbk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ahanda abha manyizywe mu shinjhe izhumbi. Ni bhunga ingosi ihubhungana ihazyhungula, ahinjila muhati inyitu li musumbi, ahakhala. Ibhuga yunthi ihali izywungulile mushinje munsumbi mu fukweni. ");
INSERT INTO sbk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Abhamanyizhwa inongwa inyinji huvifwani, ayanga wa bhene hunsundo zyakwe. ");
INSERT INTO sbk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Uvhi ikopba ihabhalile atote. ");
INSERT INTO sbk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pali atota, zimo imbeyu zyalagala mwidala, inyonyizywahinza zywalya. ");
INSERT INTO sbk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imbeyu zimo zywalaga mumwala, pasipali ninzhi inyinji iyaye. Mara zikanyauka, kwa sababu hazikuwa na udongo wakutosha. ");
INSERT INTO sbk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lelo isanya palyahatukula, zywatenguha, lelo pheposazywali na kholo zyahumaa. ");
INSERT INTO sbk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imbeyu zimo zywalagala pahati pamivhwa. Amivhwagazi puta, saga zhwasiga indundu zywa zwunthi. ");
INSERT INTO sbk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imbeyu izwenje zhwalagala munzhi inyinza zhwapa indundu pazi wonjelela, zimo zihasagala along gatatu sana, zimo malogo tanda, na zimo malogo mia.” ");
INSERT INTO sbk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ahayanga, “Wabhunti uwi makutu agahuvhwe, naayuvhaje!” ");
INSERT INTO sbk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","U Yesu pahavha mwene, bhala habha phiphi nu mwene bhala ilongo nabhantu bhantu bhahabhuzywa ehusu ivifwani. ");
INSERT INTO sbk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ahayanga wavhene, “Amwe mpewilwe utawala uwa Nguluvhi. Lelo bhala abhalihunzi shila hatu wayanje nivifwani, ili gawenya, ena wenya, ");
INSERT INTO sbk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","lelo hawenya, phepo pahuvhwa, lelo sahuvhwa wawenya, lelo sawenya wala hawe lewa nahuvhe, lelo gabhe bhagaluhananga Ungulubhi abhahoshelanga.” ");
INSERT INTO sbk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ahayanga wabhene, “Ishi samuwelewa ivifwani ivhi? Mugawezwa bhuli awelewe ifwani ivhinje? ");
INSERT INTO sbk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ikopha itotile izyo. ");
INSERT INTO sbk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lelo bhala bhalagala mushinjhe mwidala, papizywa lwatotilwe. Pala pabhahuvha, pepo uSetano ahiza naweje izywo lila lwatotilwe muhati yao. ");
INSERT INTO sbk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na bhamo bhala bhatwa mumwala palyuvha izywa, shalubhilo shalulo bhalipola huwaushe. ");
INSERT INTO sbk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sabhanakholo gangunthi muhahati yao, lelo vhajimba humuda ufupi. Amayimba na yushe wao paviweza hunongwa yizyo vhafiha bhambumila. ");
INSERT INTO sbk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bhamo vhala bhatotwa kati yimivha bhahuvha izywo, ");
INSERT INTO sbk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lelo ayimba agamunzhi akhopelwe nishuma nivinyonya zwa mambo aganji, huhuwaingia nasupe izywo na limenwa apape amadudu. ");
INSERT INTO sbk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na bhawili abhabhatotilwe munzhi inyinza. Bhalwuvha izywo nali pashele bhapapa amandundu: bhamo malongo gatatu bhamo malongo tanda bhamo mia moja.” ");
INSERT INTO sbk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","U Yesu abhambula, “Je unaleta ta ndani ya nyumba nakuweka panzhi ishitundu, au pansi pashitala? Uleta muhati na bhishe pamwanya pakinara. ");
INSERT INTO sbk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na hami hahabhajile afise asahagabhoneha, nahakuna siri iyasiga abhapazeru. ");
INSERT INTO sbk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Khawele uwimakutu gahuvhe ayuvhwaje!” ");
INSERT INTO sbk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akawaambia, “Mubhanje maso na hala amuhuvhwa, alingane ishipimo shila ishampima ndio shisho shamwapimilwa shayonjelezewa hulimwe. ");
INSERT INTO sbk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Afutane aje uhula uwanao ayejelela vinji tee, ulakwasanao afume wamwe ene vyayegwa navila uvya navyo.” ");
INSERT INTO sbk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ayanga, “Utawala uwa Ngulubhi ufananasiwa nu muntu uwa vyala imbeyu mwilongo. ");
INSERT INTO sbk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pahagona adamula na shabwi imbeyu zyatiuha nakule, ikiwa haga hamanya shifumile. ");
INSERT INTO sbk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Izhi ifumia imbeyu yiiyo asoti amatundu baada yipo uwezya, nanthele imbeyu izyazikhomile. ");
INSERT INTO sbk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lelo imbeyu ya payakho ma atwala inhengo, pipo avune hufishile.” ");
INSERT INTO sbk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ayaanga, “Tufwananiswe utawala wa Ngulubhi nahanthushi, au tumile hanthuuli amatumile hanthu uwuli awelezyezye? ");
INSERT INTO sbk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ili nishi imbeyu yiladai, lelo pihatotwaga hali hadodo sana kuko imbeyu zywunthi munshi. ");
INSERT INTO sbk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hata lula ulwitothilwe igosi sana kuliko vhu nthi ivha vitotilwe mubusitani ivheha inzamba ingosi nazi inyenji ziwezya akhale nabheshe ivhansu ali nganaje inzunda yakwe.” ");
INSERT INTO sbk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Amafano aminji amanyizywe ayanjile inongwa wa bhene, shinza ishabhawezizye awelewe, ");
INSERT INTO sbk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","haga ayangaga anabho bila fwano. Lelo lula ulimwene, ahabha bhula asundwa bhakwe shila hantu. ");
INSERT INTO sbk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lelo isiku ilwo ulwe vhela pawafishile, ayanga wabhene, ");
INSERT INTO sbk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","“Sanli upande uwa bhili”. Pipo bhaileha ibhuga, bhahamwenga uYesu, uwakati bhuwo ahavha mwituli. Amatuli aganji galipandwimo numwene. ");
INSERT INTO sbk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ihala ihali ihavhulungwe amawimbi gahijilaga muhati mwintuli na ituli nagamimile. ");
INSERT INTO sbk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lelo uYesu yuyo alikuwa kwenye shetri, ali agonelile mwisoho. Bhahadamusya, bhayanga, “Wamwalimo, hangu saga ati tufwa?” ");
INSERT INTO sbk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Abhuha audamila ihala aibhula inzumbi, '“Ibhe shinza, huwaushe”. Ihala ihaleha, wahavha miee sana. ");
INSERT INTO sbk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ayanga wa bhene, “Yenu mu hwogopa? Samulinima bado?” ");
INSERT INTO sbk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bhahabha nihofu moyo gabho bhayangana vhene kwa vhene, “Unu yunanu antele, hata ihula ihumwogopa?”. ");
INSERT INTO sbk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bhabhiza upande uwinje uwinsumbi ukowa ungwa hu Gelasi ");
INSERT INTO sbk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Gafula uwakati uYesu afumaga hunzhi iyituli, umuntu uwipepi ichafu anhiza wa mwene afume wazili inghugwa. ");
INSERT INTO sbk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Muntu uyo akhalaga wazili inghughwa. Numo untu uwa zigaga zaidi, numo hata hu manyololo. ");
INSERT INTO sbk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Apinyilwe ahabhalilo ahinji apinyilwe namanyololo. Alikata minyololo naphingo adadulaga ipbingo na gamanyololo gambuduhaga. Na numo uwanga nikhone nahu mene. ");
INSERT INTO sbk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Usiku nusanya shali hu ngungwa na huagamba, alilaga na wivhale na mawe amakhali. ");
INSERT INTO sbk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pahalola uYesu litali, anyililile wa mwene naundame witazi wa mwene. ");
INSERT INTO sbk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ahalila usauti igozi, “Uwaza ibhombele yenu, uYesu, Umwana wa Ngulubhi uwali Humwanya sana? Ihuwiniha wa Ngulubhi yuyo, ungandedavhwe.” ");
INSERT INTO sbk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pipo ali abholile, “Huje ufume mwa muntu bhunu, awe wipepo imbivhi.” ");
INSERT INTO sbk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wope abhuzya, “Itawa lwaho wi nanu?” Wope ajibule, “Itawa lwani Legion, pipo tuli bhinji.” ");
INSERT INTO sbk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Amwiniha sana sana angande hutwale hunzi yikowa. ");
INSERT INTO sbk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ishi ikundi igosi ilinguluvhe zywa lwanga pamwanya paha gamba, ");
INSERT INTO sbk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","nabha mwiniha, bhayanga, “Tutume huguluvhe; tinjile muhati yavho.” ");
INSERT INTO sbk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bhalisiwa; aroho achafu bhahafuma nawinjile muhati mungulivhi, bhape bhahanyilapanzipa gamba paka munsumbi zyabhezya afishe elufu zibhili bhatumbushila munzumbi. ");
INSERT INTO sbk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na bhala bhali bhaziliswa igumi bhatumbaga nafumine italifa abafumile ikhaya ni nsi pipo bhuhafwa abhale awenye ahahafumile. ");
INSERT INTO sbk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Epo bhahinza wa Yesu na bhahalola umuntu uwayinjililwe namapepo—uwali ni jeshi—akhele panzi, bhakwatizye, abhoneha huhakili zyakwa halali bhope bhahogopa. ");
INSERT INTO sbk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhala bhalole hafumile wa muntu uwa hinjililwe ni pepo bhahabhula hafumile wa mwene ahafumile ahusu inguluvhi. ");
INSERT INTO sbk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bhope bhada humwinishe ayepe mkoa gwao. ");
INSERT INTO sbk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pali pawinjila muhati mwintoli umuntu uwahinjililwe nipepo amwiniha huje bha shilaje bhudhi nu mwene. ");
INSERT INTO sbk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lelo haga amwitishile, lelo habhala, “Shilaga hunumba yaho nawabhantu bhao na bhabhule uwabhombile Bwana, iphana ilowapile.” ");
INSERT INTO sbk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Isho ahashila atanganza amambo amagosi uYesu agabhombile wamwene hu Dekapoli, ula muntu aswijile. ");
INSERT INTO sbk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Umuda uYesu palobhoa upande uwinje muhati mwituli ibhunga inyinji ihazywungulaga pati mushinje munsumbi. ");
INSERT INTO sbk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Uumo uwali longozi wasinagogi, ahitwaga Yailo, ahizile, pali alole, angwile pamagaga agamwene. ");
INSERT INTO sbk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Amwinishe sana amwiniha sana sana, ayanga, “Ulindu wani udodo abhezywa afwe. Ihulamba unyinze ubhishe amakhono pamwene apate ihafya hulamba.” ");
INSERT INTO sbk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Isho habhala nawo na ibhuga ingosi sana ihada gana bhavhelaga mpepe vhahunzwungula. ");
INSERT INTO sbk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wali nu shi uli afuma ama danda amaha ilongo limo na maha gavhili. ");
INSERT INTO sbk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Alavhile sana waganga abhinji atumila kila hatu anaho hutaisho sashahavha na hamo. Hata hivyo hakusaidika kwa chochote, lelo pipo ali ihali mbivhi. ");
INSERT INTO sbk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ahuvwa ihali huje uYesu. Aheza khosi wa mwene na pajendaga muhati mubhuga, apala zwa umwenda gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pipo alyanjile, “Khanapela nvuzywa amenda agakwe lwe, izavhe mwumi.” ");
INSERT INTO sbk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pahakhata, afume wakwe idanda iha leha awiyuvwa hula alavhewakwe huleha afume humalabha gakwe. ");
INSERT INTO sbk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mala Yesu agundua ndani yake mwenyewe huje ikhone lwa fuma. Agaluhana uhu nuhu mu phuga mwa bhantu navhuzye, “Yunanu uwagusa umwenda gwani?” ");
INSERT INTO sbk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Asudwa bhakwe bhabhulile ulola ibhunga izywungulile nawe uyiga 'Yu nanu uwa ngusa?”' ");
INSERT INTO sbk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lelo uYesu ahenya wondi wondi uwa bhombileili. ");
INSERT INTO sbk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ushi, palole ilili fumile afume wa mwene ahogopa nateteme. Aheza nagwe pansi witazi lwakwe nahu bhute izywaziwili zyunti. ");
INSERT INTO sbk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ayanga wa mwene, “Lendu, awamini waho huponizywe avhemwumi. Shilaga hu himani upone uponywe afume huvhinu waho.” ");
INSERT INTO sbk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pali aliayanga, bhamo avhatu bhahinza afume walongozi uwi Sinagogi, bhayangaga, “Ulindu waho afwile. Henu uhumbula umwalimo?” ");
INSERT INTO sbk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","U Yesu pahuvha avhyanga, ahabhula ulongozi uwi Sinagogi, “Unganje awogope. Aminiangatu.” ");
INSERT INTO sbk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Haga alusu yayunti alongozanye nawo, ila uPetulo, uYakobo, nu Yohana, uholo wakwe Yakobo. ");
INSERT INTO sbk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bhahiza khaya walongozi wi Sinagogi wope ahalola ivhujo akhole sana nalile. ");
INSERT INTO sbk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pahinza khaya, abhabhulile, “Henu musiliha antele yenu mlila? Umwahaga afwile ila agonile.” ");
INSERT INTO sbk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bhaseshile, lelo umwene, abhafumya huzi, amwega uYisu wa mwana nunyina nabhala bhabhali palishimo numwene, ahijila muhati mwali umwana. ");
INSERT INTO sbk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ahega ukhono ugwa mwana ahabhula, “Talitha koum,” ambayo huwayanje, “Lindu umwana bhuha.” ");
INSERT INTO sbk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Umda ufupi umwana adamula na ajende (pipo alina maha ilogo limo naganji gavhili). ");
INSERT INTO sbk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gafula bhahakhatwa nushanga ougosi. Numo yayunthi uyiwaziwa amanye wili. Abha bhula peli ulendu ula ishalye. ");
INSERT INTO sbk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na ahepa ipo nabhale humuji ni wabho asundwa abhakwe bhahadaga. ");
INSERT INTO sbk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ulutuyo palwahafiha, ali anza amanyizywe mwi Sinagogi. Abhantu abhinji bhahamuvhaga. Naswijiziwe bhahayaga, “Azwajile wihiizi izywa manyizwa?” “Liphana ashi ili ilwapewilwe?” “Abhomba amanjele iga humakhono gakwe?” ");
INSERT INTO sbk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Ishi unu sawa selemala, umwana wa Maria uholo wabho aYakobo, Yose, Yuda na Simoni? Je adada bhakwe tukhalanabho mumu nanthi?” Hakufulaisha nu Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","U Yesu abhabhula, “Ukuwa haga akosa awogopwe, ilakati yikhaya yakwe na mubhamo muholo bhakwe na munyumba mwakwe.” ");
INSERT INTO sbk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hagawezyaga abhombe amanjele epo, lelo abheha amakhono abhini bhashe abhaponwa. ");
INSERT INTO sbk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ahaswiga sana pasaga wamini wabho. Ajendelela ikhaya izywapalamani ahamanyizya. ");
INSERT INTO sbk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ahabha kuga asudwa bhakwe ilongo limo nabhantu bhabhili ahanda atume bhabhili bhabhili. Apela amulaka juu yipepo ichafu, ");
INSERT INTO sbk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","na bhamulile bhaanganje aweje hahunti pabhajenda ila ulusansotu bhanganda aweje ibumunda wala ifhulushi wala ihela pahosi; ");
INSERT INTO sbk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","lelo bhakwataje ishilato, lelo siyo amakanzu gabhili. ");
INSERT INTO sbk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ahabhabhula, “Nyumba yayundti iyamunza winjile, khalanji upa pamwaishila. ");
INSERT INTO sbk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ikhaya yayundti iyasi habhejela wala abhuvhe, shilaji pabhene, kunyu ntaji amakundi agamagaga genyu, bhawiloleje abene.” ");
INSERT INTO sbk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nabhope bhahashila bhatangazwa abhantu bhalambaje imbivhi zyabho. ");
INSERT INTO sbk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhanyi ipepo inyinji, na bhapahaga amafuta abhinu bhaponaga. ");
INSERT INTO sbk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Utawala uHalode pahuvhwa ingo, afutane itawa lwa Yesu lwamanyishe sana. Bhamo bhayanga, “U Yohana uyabhozwa azyushile pipo isho inkuniimaanjele ibhomba imbombo mhati yakwe.” ");
INSERT INTO sbk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bhamo bhahayanga huje, “Unu yu Eliya,” Lelo bhamo bhayanga, “Unu yukuwa, uwali nishi bhala akuwa abhimandi.” ");
INSERT INTO sbk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lelo uHalode pahuvhaigo ahayanga, “Ahaga uYohana, uwihandumule itwe azywushile.” ");
INSERT INTO sbk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Lelo Helode yuyo alajizwe huje uYohana akhatwe ahapinya nahubhishe mwigeleza hunongwa Herodia (ushi wa kuluwakwe Filipo) pipo lelo umwene ali agojile. ");
INSERT INTO sbk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Lelo uYohana ali abhulile uHerode, “Sagashizha aweje ushi uwa khulubho.” ");
INSERT INTO sbk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lelo uHerodia ahanda huvhitililwe na azaga ahugoje, lelo haga awezizwe, ");
INSERT INTO sbk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","lelo uHerode amwogupe uYohana; amenye muntu wana lwoli nzhelu ahaleha huwinza, pahendelela hu mwuvhe. Asulumana sana lelo ahamoga hutejelezywe. ");
INSERT INTO sbk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Po uhafi uwakati uwene pabhelaga isiku ilwa papwe Herode abhandalila atalamu abhakwe ishelehe, na adadamu nalongozi ami Galialaya. ");
INSERT INTO sbk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Phipo ulendu wa Herodia ahinjila nacheze witazi wabhene, afulaiswa uHarode na jenyu abhakhile uwakati uwishalwe shalwevhela. Epo utawala abhula ulendu, “Undavhe hahondti uwaza nani izahupele.” ");
INSERT INTO sbk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Alapilizya huje, hahudi hubha ndavhe, izahupele, ahata inusu iyitala wani.” ");
INSERT INTO sbk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Afuma huzi avhuzya anyina wakwe, “Indavhe yenu?” Abhula, “Itwe ilwa Yohana uwa Wonza.” ");
INSERT INTO sbk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Shisho ahinjila watawala ahanda ayanje, “Iwaza muhati musahani, itwe lwa Yohana uyawozwa.” ");
INSERT INTO sbk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Utawala aswiga sana, lelo ululapo ulwalapile na ajenyi, haga hawezywa hukhanile ilwa labhile. ");
INSERT INTO sbk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Isho, mutawala ahatuma asinjala abha gulaga abhalajizywe abhale alilete itwelwa yahanaulizi abhatile adumule wijela. ");
INSERT INTO sbk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ahaleta itwe kwenye sahani na hupele ulindu ulindu apela unyina wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Asundwa bhakwe pabha huvha isho, bhahabhala abhale aweje ubhilyi gwakwe bhala asywile hunghugwa. ");
INSERT INTO sbk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Atumwa bha bhungana witazi wa Yesu, bhabhula gunthi agabhombile na gabhamanyizyaga. ");
INSERT INTO sbk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wope abhabhula, “Izaji mwemwe pasili tutuye hashe.” Abhantu abhinji bhali bhahweza nashile wala habhapata inafusi iyolye. ");
INSERT INTO sbk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bhinjila mumashuwa bhala amahali pasili bhene. ");
INSERT INTO sbk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lelo bhahabha lola pabhashila bhahabhamanya abhahanyila lwimagaga upaka humiji guthi, bhope bhafiha shavhasili abhene. ");
INSERT INTO sbk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pahafiha pwani, bhalola ibhuga ingosi bhahabhasajila, pipo bhali nishi ingole izwasazili nu ndimii. Ahanda abha manyizye amambo aminji. ");
INSERT INTO sbk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Abhazyo pahedelela sana, asudwa abhahemwizila bhaha bhula,”Ipa tuli mahali pisili umuda gubhalile. ");
INSERT INTO sbk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ubhalaje bhashilaje aweze ishalye humiji hujiji ivipipi.” ");
INSERT INTO sbk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lelo abhajibhula ayanga, “Bhapeli amwe ishalye.” Tugawezwa awepe nakale amabumunda angisamani na mimbili tubhapele hahalye?” ");
INSERT INTO sbk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ahabhabhula,” Muna amabumunda galinga? Mubhale mwenye.” pabhavhaga bhahabhula, “Amabumunda gasanu ni samaji nsivhile.” ");
INSERT INTO sbk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bhahamuliswa abhantu bhakhale mumasole amolo. ");
INSERT INTO sbk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bhaha khazywa makundi; makundi mamia na amhamsini. ");
INSERT INTO sbk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ahenga amabumunda gasanu na samaki zibhili, na wenye humwanya, ahasanya aha pela asudwa waweke mbele ya umati. Bhabhishe nasamaki zibhili, na zitatu wabhathu bhuthi. ");
INSERT INTO sbk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhahalya bhuthi bhayile. ");
INSERT INTO sbk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bhabhunganya amabumuda sangile, Vyaha mema ivitundu vhibhele, nivindumushila ivisamaki. ");
INSERT INTO sbk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bhali alume elufuzisanu abhalile amabunda. ");
INSERT INTO sbk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Abhabhula huje bhande mashua bhabhale isemu iyinji, Bethsaida, uwakati abhalaga ulubhungano. ");
INSERT INTO sbk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pabha habha bhashila, abhala wi gamba alavhe. ");
INSERT INTO sbk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pawahahavha shalyevhela na mashua yabho ulwo ili pahati pazhumbi alimwene panzi inyumu. ");
INSERT INTO sbk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ahalola bhatamiwa akhome makasiapipo ihala ihapingaga. Pahuhabha hupambazuha nashaphii abha bhalila, ajendaga amizi ahazaga ashizanye. ");
INSERT INTO sbk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lelo pahalola ajenda amwanya iyimeze, bhapata uwasi wasi bhagazimu hata bhakhola. ");
INSERT INTO sbk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pipo bhahalola vhahijila ishaka. Ahagana yanje anabho abhabhula, “Mubhanje bhadadamu! nene! Mganje abhe nihofu.” ");
INSERT INTO sbk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ahinjila muhati mumashua, na ihala ihaleha avungume na haswiga kabisa. ");
INSERT INTO sbk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Haga bhahelewa imana iyagala amabumunda. Injele zhwabho zyalidodo. ");
INSERT INTO sbk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bhope pali bhaloushe isyila bhafiha insi ya Genesareti mashua ikati nanga. ");
INSERT INTO sbk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pabhahaguma huzi iye mashua, bhahatabula. ");
INSERT INTO sbk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bhahanyila atangazwe mkowa gwundhi bhahandu abhalete avhinu mzego mzega, shila pahuvhaga huje awiza. ");
INSERT INTO sbk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pundi pahinjilaga huvijiji, au mumiji, au munzhi, bhabhihaga avhinu pasoko, bhalamba huje bhapala mazhwaje amenda gakwe. Na bhundti abhakhete bhaponile. ");
INSERT INTO sbk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo nabhamo asimbi ambao bhafumila hu Yelusalemu bhahabhungana huzhwongule umwene. ");
INSERT INTO sbk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bha hulolie bhamobhamo huje asunda bhakwe bhalile ibumunda humakhono amachafu; saga gahoziwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(wa Mafalisayo na Yahudi bhundti sabhalya upaka bhozizye amakhono gao shishinza; bhakhatila utamanduni agosibhabho. Huwakati ");
INSERT INTO sbk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amafalisayo pabhabhuya afume mahali pasoko, sabhalya paka bhoje kwanza na huli ishelia zimo zimo abhuzywo bhazida gakabisa, ikiwa abhozye ivikombe, amafulila, ivhombo ivhishaba, na hata amatengo agatuniha uwakati uwishalye.) ");
INSERT INTO sbk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amafalisayo na asimbi bhalihubhuzye uYesu, “Kwa nini asudwa bhaho sabhakhala afatane nagosi, bhao bhalwaibunda nabila asungusule amakhono?” ");
INSERT INTO sbk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lelo umwene ahabhabhabhula, “Isaya ahakuwashinza huje amwe mulibhivhi, asimba, 'Aje abhantu ibha bhanogopa humalo mu golo, lelo amoyo ga bho gali hutaloi nani. ");
INSERT INTO sbk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bhabhombela inyiputoizywaswazya zyizyo izyasazi welewelewewa sazimuhimu bhamanyiziwa italabu izywa bhanadamu gabha poshala agao.' ");
INSERT INTO sbk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Muleshile iatalatibu izywa Nguluvhi namuzywejile izishibinadamu ugatwaposhile.” ");
INSERT INTO sbk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ahayanga wa bhene muzikhanile amuli izwa Nguluvhi ishilaisi ili muziute izyinyu! ");
INSERT INTO sbk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lelo pipo uMose ayajile, umwogopaje udada waho nunyina waho,' uwayanga amavhivhi wa dada au wamai wakwe lywoli aifwa.' ");
INSERT INTO sbk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lelo amwe, 'muyanga huje umuntu akhayanga wadada wakwe au mai, “Usada gwagwunti gula ugwa hunda mwe jelela je afume hulini iyo mbuta yinyiputo,”' (ubho wayanje huje ifumile wa Ngulubhi') ");
INSERT INTO sbk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","isho ahuruhusu abhombe ijambo lwa lwunti alibhombe kwaajili ya dada au ya mai wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Muyi bheha amuli Nguluvhi huje yilwene alete inyiho zywinyu. Na mambo aminji aga gali isho angamuomba.” ");
INSERT INTO sbk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Abhakujile amakutano andthele nabhabhule, “Huje munuvhaje ane, amwe mwindhe, namu nelewe. ");
INSERT INTO sbk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nahamo hahunti huziwa muntu hahuchafula mtu kiingiapo kwake. Bali ni kile kimtokacho mtu ndicho kimchafuacho. ");
INSERT INTO sbk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Azingatile: usitali ugu, “khamba umuntu amakutu agahuvhwe ayuvhaaje” nashimo munakili izihalyi). ");
INSERT INTO sbk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","U Yesu ahagaleha amakutano abhala khaya, asundwe bhahabhuzwa ufwano ugwo. ");
INSERT INTO sbk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","U Yesu ahayanga, “Namwe nantele saga muwelewa? Samulola hahunti ahahumwinjila umuntu hawezwa huchafule, ");
INSERT INTO sbk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","pipo sahabhala huwoyo gwakwe, lelo ishashiwinjila muvhanda vhakwe shishizanya nabhale hucho.” Hu ma elezo iga uYesu abhiha ivhalwe vhunti abhe vinza. ");
INSERT INTO sbk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ayanjile, “Shila isha shihufuma umuntu shashi huchafula. ");
INSERT INTO sbk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pipo hafuma muhati mwa muntu, huzihu mwoyo gafuma amawazo amachafu, akwesane, uwibha, agoje, ");
INSERT INTO sbk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amabhibhi iga gunti hutamani ishibhibhi, ubhibhi uwaswovhe, akwesane, uwivu aphuyile, awivune, nulema. ");
INSERT INTO sbk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amabhibhi iga gunti gafuma muhati, gaga huchafula umuntu.” ");
INSERT INTO sbk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Abhuha afume pala nashile ukowa wa Tiro na Sidoni. Ahainjila muhanti haga ahazaga umuntu yayundhe amanyaje huje aliipo, lelo haga ihazehana hufise. ");
INSERT INTO sbk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lelo ghafla ushi, ula umwana wakwe udodo ani roho ichafu, ahuvha ihabali hakwe, ahiza, naha gwa magaga agakwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ushi uyo Muyunani, wikambela ilwa Kifoeniki. Alambile umwene anyizhwe ipo afume wa lyindu wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","U Yesu ahabhula ushi, “Bhateshe abhana bhaliziwaje huje sashili aweje ibumunda ilwabhana azitajile ibwa.” ");
INSERT INTO sbk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lelo ushi ajibule nayanje, “Ena Bwana, ibwa panzi yimeza ivhavhi sagala ivhalye vha bhana.” ");
INSERT INTO sbk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Abhula, “Ahuje pepo uyanjile ishi, uli mwaushe ashile. Iphepo ifumile ulindu waho.” ");
INSERT INTO sbk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ushi ahabhuya khaya yakwe ahamwaga ulindu wakwe agonile pashitala, iphepo ali afumile. ");
INSERT INTO sbk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","U Yesu afumile inje yikowa wa Tiro na ashizanije Sidoni abhalile hunsumbi ya Galilaya pakakanda ya Dikapolisi. ");
INSERT INTO sbk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bhahaleta umuntu uya sahuvha uyasawezya ayanje shishiza, bhalambile uYesu huje abhishe amakhono pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ahumwefwa hunzhi ikundi shisili abhiha inyovhe makutu gakwe, bada ya aswe amate apala manzywa ulumili lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ahenyizhwe humwanya amaso ahutuya na hubhule, “Efata,” isuo wa huyanje “fuguha!” ");
INSERT INTO sbk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Umuda gwagula amakutu gahiguha, nahala ahazijile awezywa ayanjeshishinza. ");
INSERT INTO sbk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Abhamulila bhaganje hubhele umuntu wabhunti. Lelo pali abhamulila bhanje hubhule umuntu pabha zidile ayanje ibhahalileizyo zinyijii. ");
INSERT INTO sbk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lyoli bhashijizhiwe, nayanje, “Abhombile shila hantu shishinza. Hata abhombile abhasa bhahuvha amakutu ahuvhe na bhabubu ayanje.” ");
INSERT INTO sbk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lele inzhiku izyo, paliiibuga ingosi, salinishalwe. U Yesu abhakuga asundwa bhakwe ahabhula, ");
INSERT INTO sbk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Injisajila ibuga ini bhendelile abhe nani inzhiku zitatu na sani shalye. ");
INSERT INTO sbk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Khimba nyaphanye huje bhabhuye huzinyumba zyabho bila alye bhagazimila mwidala nizala. Mhati yabho bhamo bhafuma hutali sana.” ");
INSERT INTO sbk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Asundwa bhakwe bhajibula, “Tubhagaje wii amabumunda agabhaye bhutnthi ibha nabha kutizye abhantu ibha ineo ilyaleshilye?” ");
INSERT INTO sbk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ahabhabhuzya, “mulini vipande vhilinga ivhimabumunda?” Bhayanga, “Saba.” ");
INSERT INTO sbk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Awamulila ibhuga bhakhale panzi. Ahega amabumunda saba, ahasalifya Ungulubhi, na budulanye. Abhapela asunda bhakwe bhagabhishe witanzi lyabho, bhahagahiha witanzi libhuga. ");
INSERT INTO sbk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bhope bhali ni samaki zindodo nyishe, na bada yahusalifye, abhamulila asudwa bhakwe bhaganyiivhi vhope. ");
INSERT INTO sbk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na bhahalya naye. Nabhabhunganya ipande ivhisangele ivitundu, ivigasi saba. ");
INSERT INTO sbk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bhelega abhantu elufu zine. Aheleha bhashalaje. ");
INSERT INTO sbk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mara ahinjila mashua nasundwa bhakwe, nabhashila katika ukanda wa Dalmanuta. ");
INSERT INTO sbk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amafalisayo bhafumahuzina wande adalisanye nawo. Bhazaga ishimanyilo afume humwanya, bhajelaga. ");
INSERT INTO sbk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Asebha sana mmwoyo gwakwe ayanga, “Yenu ishizazi ishi shiwaza imanyilo? Imbabhula amwe lyoli, na shimo ishimanyilo ishashaifuma hushi zazi ishi.” ");
INSERT INTO sbk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ipo ahambaleha, ahinjila muhati mmashua anthele ahashila awelekele upauwenje. ");
INSERT INTO sbk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Umuda ugwo asudwa bhahi wilwe aweje amabumunda. Sagabhali nishipande shashundhi ishibumunda hata shimo ishali mashua. ");
INSERT INTO sbk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Abhonya hayanje, “Mubhanje maso na witunze ishilela aluzu iya Mafalisayo na haluzu aHarode. ");
INSERT INTO sbk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Asundwa bhayangana bhene wabhene, “Pipo sagatuli namabumunda.” ");
INSERT INTO sbk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","U Yesu ahamanya ili nabhabhula, “Yenu muyangana pasamuli namabumunda? Hamuminye bado? Hagamuwelewa? Amoyo ginyu mapupusu? ");
INSERT INTO sbk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amaso hamulola? Munakutu, sagamuhuvhwa? Hagaamukumbuha? ");
INSERT INTO sbk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pihagabhaya amabumunda gasanu wa bhantu elufu zisanu, mwahejile ivitundu vhilyinga ivhavimemile amabumunda?” Bhahajibula “ilongo navhele.” ");
INSERT INTO sbk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Pahagabhanya amabumunda saba huelufu ine, muhega ivitundu vhilinga?” ");
INSERT INTO sbk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bhahayanga, “Saba.” Ahabhabhula, “Bado haga muwelewa?” ");
INSERT INTO sbk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bhajiza Bethsaida. Abhantu ibho bhahuleta wa Yesu umuntu uwafyile amaso bhahalamba uYesu akhate. ");
INSERT INTO sbk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","U Yesu ahukhata nukhano ola uwafyile amaso nahulongole huzi ishijiji ahaswa amante pamwanya yimaso nagolosye amakhono pamwanya yakwe, ahabhuzwa, “Uhalola hahunte?” ");
INSERT INTO sbk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ahenyizywe humwanya nayanje, “Imbalola abhantu bhabhoneha nishi amapishi gajenda.” ");
INSERT INTO sbk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ipo ahagolosya amakono gakwe pa mwanay iyimaso gakwe, umuntu ola gafunguha amaso gakwe, ahalola nanhele, ahalola shilahandu shishiza. ");
INSERT INTO sbk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","U Yesu ahaleha ashila akhaya yakwe nahabhula, “Unganje aeinjile hujini.” ");
INSERT INTO sbk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","U Yesu ashila nasundwa bhakwe huvijiji ivha Kaiseria ya Filipi. Bhali mwidala abhabhuzwa asundwa, “Abhantu bhayiga ni nanu?” ");
INSERT INTO sbk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhahajibula bhahayanag, “Yohana uwabhozwa. Bhamo bhayanga, 'Eliya' na bhamo, 'Muntu umo Nakuwa.” ");
INSERT INTO sbk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ahabhabhuzwa, “Lelo amwe muiga ane ninanu?” Petulo ahabhula, “Awe wi Kristi.” ");
INSERT INTO sbk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","U Yesu abhula bhanje hibhule umuntu yayunti uwahusu umwene. ");
INSERT INTO sbk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ahanda abhamanyinzye huje umwene Mwana wa Adamu lazima alavhe humambo aminji, ayikanwa nalongozi na achungaji agosi nasimbi, na gagwe bada yinsiku zitatu aizyuuha. ");
INSERT INTO sbk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aliyanjile iga apazelu. Epo uPetulo ahamwega paka pashinje anda hudamile. ");
INSERT INTO sbk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lelo uYesu agaluhana na bhenye asundwa bhakwe na ahadamila uPetulo nayanje, “Sahinzanya huhosi yane Setano! Haga usaga amambo aga Ngulubhi, ila amambo agabhantu.” ");
INSERT INTO sbk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ipo ahakuga ibuga nabhasundwa abhakwe palishimo, nabhabhule, “Kama huli umuntu uya wanza afwuate awikhane nyuyo, ayegaje ishikhovhehanyo shakwe na afhunte. ");
INSERT INTO sbk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wahuje wabhunti uya wanza awokole amaisha gakwe aigatenzwa nauyantezywa amaisha gakwe kwa ajili ya lini na kwa ajili izyo ayokola. ");
INSERT INTO sbk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aipata yenu umuntu khapate inzhi yunthi wa pante ihasala akahle wakwe? ");
INSERT INTO sbk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Umuntu agawezya afumwe yenu badala yaifumwe ubhumi wakwe? ");
INSERT INTO sbk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Uwaindolela inshoni ninogwa zywani ishizazi ishinishi zazi ishabhivhivhi, Umwana wa Adamu ayilolela inshoni paiyinza nubhutawala uwa dada wakwe palishimo naa wandumi azelu. ");
INSERT INTO sbk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ayanjile wabhene, “Lwoliiyanga hulimwi bhawili abhanthu abhabhimilile epha ambao hagabhaibhoja ufye shausilye utawala uwa Ngulubhi pawayinza wikhone.” ");
INSERT INTO sbk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na bada yinshikutanda, uYesu abhega aPetulo, Yakobo na Yohana palishimo numwene wigamba, bhene. Ndipo ahandile agaluhane mbele yao. ");
INSERT INTO sbk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amenda gakwe gaga luhana gana amulishe alabhe sana nabhe mazelu zaidi uzeluuwasa bhulavha wabhonthi munthi. ");
INSERT INTO sbk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Phepo aEliya pamoja nu Mose bhahafumila witazi lwabho, bhali bhayanga nu Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","U Petulo ajibula uYesu, “Umwalimo, shinza ati akhale epa, shimo shaliwe, shimo kwa ajili ya Mose na isha mwabhosha Eliya.” ");
INSERT INTO sbk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Haga amenye ahawaziwa ayanje, bhahogopha sana.) ");
INSERT INTO sbk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ibhingo lwa fumila nabha kwi shile. Ipo isauti ihafuma mwibhingo ihayanga, “Unu mwana wane uwingine. Mutejele zyaje yuyo.” ");
INSERT INTO sbk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ghafla, pali bha wenya sabha halola uyalinao palishimo, ila uYesu mwene. ");
INSERT INTO sbk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pali bhahwiha afume wigamba, amulila huje bhasaheze hubhele umuntu numo gala gunti agabha galolile, paka Umwana wa Adamu piizhyuha afume wabhafwe. ");
INSERT INTO sbk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ipo paha ga uta amambo bhibho. Lelo bhayangana bhene kwa bhene lwenu imana yakwe “azyushe afume wa bhafwe” ");
INSERT INTO sbk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhaha bhuzya uYesu,”Yenu abhandishi bhaiga uEliya ayize nasonti?” ");
INSERT INTO sbk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Abhabhula, “lwoli Eliya sagabhiza afume ivhintu vhunti. Yenu isimbilwe Mwana wa Adamu lazima apate amalabha gaminji navhitililwe? ");
INSERT INTO sbk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lelo iyanga hulimwi lelo uEliya ahezele, bhahabhomba shabhayingine nishishila shaiganile, nishi amasimbo shaga yanga ahusu umwene.” ");
INSERT INTO sbk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pabha habhuya wasudwa, bhaha ilola imbunga ingosi izyungulile na Masadukayo bhabisanyaga ahabho bhabisanyaga anabho. ");
INSERT INTO sbk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pala pahalola, ibhunga yunti bhahashyiga nahunyilile hulamushe. ");
INSERT INTO sbk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Abha bhuzywa asundwa abhakwe, “Mubisanya nao kuhusu iyenu?” ");
INSERT INTO sbk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Umuntu umo muhati yabho ahajibula, “Mwalimo ihale ta umwana wane huliwe; ana iroho iyithavu ihubhomba huje anganda yayanje, ");
INSERT INTO sbk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ihu fanya aje atete mamanje na hugwisye panzi, nafume ipofu mwilomu nasye amino naga gandane. Ihabhalabhile asundwa bhaho humwefye, lelo hagabhawezizwe. ");
INSERT INTO sbk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Abhajibu, “Ishizazi ishasa shiwamini izakhale namwe humuda bhuli? Izawejelane namwe paka lii leti hulini? Mleteni kwangu.” ");
INSERT INTO sbk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhaleta umwana wakwe. Iroho inhavhu palalala uYesu, gafla ihapela ateteme. Usahala agwile paka panzi naafumhe ipovhu wilomu. ");
INSERT INTO sbk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","U Yesu ahabhuzya uyise, “Ihali ine ili awande muda ulyi?” Uyise ayanjile, “Aje afume uwana wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mumomumo itwala humwoto au mumenze naije la humwanga mizywe, kama uwezwa abhombe hahunthi utuhulumile natusaidile.” ");
INSERT INTO sbk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","U Yesu abhulyile, “Akhashele uli tayali? Hala hantu hawezeha na waya yunthi uya wamini.” ");
INSERT INTO sbk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ghafla uyise wa mwana ahalila nayanje huje, “Iwamini! Nisaidie asinte awamini wane.” ");
INSERT INTO sbk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Uwakati uYesu pahalola imbuga inyila abhale wabhene, ayikemela iroho inthavu nayanje, “awenohobubu uwasaga uhuvha, ihuwamuruleshe, usahinjile wamwene nanthele.” ");
INSERT INTO sbk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ahalila wikhone na huhangaisye umwana na iroho ihafumile. Umwana abhoneha uga afyile, Ipo abhinji bhayanjile, “Aje afyile,” ");
INSERT INTO sbk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lelo uYesu amwega nukhono abhusywa, umwana ahimelila. ");
INSERT INTO sbk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lula uYesu pahinjila muhatyi, asundwa bhakwe bhahabhuzya shisili, “Yenu satawezizye humwefye?” ");
INSERT INTO sbk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Abhabhulile, “pipo ini haga iwepa ila pwavhile.” ");
INSERT INTO sbk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bhahepa pala najendele wi Galilaya. Haga ahazanga umuntu yayuthi amanye pawilyi, ");
INSERT INTO sbk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pipo amanyizywaga asudwa bhakwe. Abhabhulile, “Umwana wa Adamu atwalya makhono mwa bhantyu, nahugoje. Paivha afwile, baada yinsiku tatu aizyuha nanthele.” ");
INSERT INTO sbk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lelo haga bhaha mwelewa agawelezya iza, bhahogopa hubhuzywe. ");
INSERT INTO sbk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ipo vhahafiha Karperinaumu. Wakati uhuo pali muhanthi nyumba abhuzizye, “Mwayanga naga yenu mwidala”? ");
INSERT INTO sbk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lelo bhaha puma mie. Yani bisanya mwidala huje yunanu uwazabhe gosi zaidi. ");
INSERT INTO sbk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ahakhala pansi abhakuga ilongo na bhamo bhabhilye pamo, ayanga nabho, “Umuntu khawaza abhe wa kwanza, nilazima abhe wa malishilo na wabhatumishile bha bhunthi.” ");
INSERT INTO sbk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ahamwanya umwana udodo abhiha pahati yabho. Amwega makhono gakwe, ayanga, ");
INSERT INTO sbk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wabhodthi nishi unu witawa lyane, oyaabha amboshile ninengashele umuntu aposha, saga aphola nene tu, lelo nayula uwantumile.” ");
INSERT INTO sbk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","U Yohana abhula, “Umwalimu tulolile umuntu kwa wefya iphepo witawa lwaho tuhathubhila, pepo haga atidaga anti.” ");
INSERT INTO sbk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lelo uYesu ayanga, “Munganda hukhane pipo numo uwaibhomba imbombo ingosi witawa lwani na ipi pamandi ayanje injango imbivhi lwa lyunti. ");
INSERT INTO sbk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wa bhuntyi uwasagali tofauti natwe ali hu pande witu. ");
INSERT INTO sbk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wabhuntyi uya yipela ishikombe iminzye agamwele pipo uli Kilisite, lyoli imba bhala hagaitezya usahala gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wa bhuntyi uyakosezwa hawa bhali bhali bhadodo abhanamini anye, wali shinza wa mwene apinyilwe inganga ilwasyele huzhingo natagwe muzhumbi. ");
INSERT INTO sbk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Khamba ukhono gwaho kha hukosela gundumulaje. Hubha washi awinjile huwomi bila khono kwiko awinjile kwenye hulozi ulinamakhono gutyi. Mula mumwoto “ugwasaguzimiha”. ");
INSERT INTO sbk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Inatila: Ulutanani ulu, “Pamahali ambapo intofyi sazifwa numwoto ugwasazimiha.” saga uwili katika nakala zakale). ");
INSERT INTO sbk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Igaga khashele likosezywa, lidumula. Je shiza huliwe awijile huwumi khalilema, kuliko atagwe hulozi namagaga gavhili. ");
INSERT INTO sbk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Inatila: Ulutanani ulu, “Amahali itofi hazifwa numwoto usiyoweza azimishe hagagu wili nakala izihali). ");
INSERT INTO sbk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kama iliso lwaho khahukosezwa lisenyaje shinza hwilwe awinjile Utawala uwa Ngulubhi uli niso limo, kuliko kwingia ukiwa maso guntyi ulaje huje mwoto. ");
INSERT INTO sbk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pala apali nintafyi izya sazifya, numwoto ugwa saguzimia. ");
INSERT INTO sbk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Lelo phipo shila muntyu aifyula numwoto. ");
INSERT INTO sbk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Umwonyi mwinza, lelo umwonyi khagutezye uwiza wakwe, gubhabhombe bhuli uwinza bhuye nathyena? Munje mwonyi muhatyi yinyu, na uwaushe wa shila umo.” ");
INSERT INTO sbk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","U Yesu ashila amali pala na habhala katika ukowa ugwa Huyahudi ni eneo ilya witanzi ili Soho Yorodani, amakutano gadagaga na tyena. Abhamanyizwe tyena, nishi pibha kawaida yamwene abhombe. ");
INSERT INTO sbk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na Amafalisayo bhaheza hujele bhahabhuzwa, “Ni halali wa muntu ulume aleha nushi awakwe?” ");
INSERT INTO sbk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","U Yesu abhajibula, “U Mose amulile yenu?” ");
INSERT INTO sbk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhayanga, “Mose aruhusu ahusimbile ikalata iyalene nahunyizywe ushi.” ");
INSERT INTO sbk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Pipo amoyo nginyu makhome shashisho abhasimbila ishalia ini, “U Yesu ahabhala. ");
INSERT INTO sbk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Afume huwandilo wiumbaji, 'Ungulubhi aumba ulume nushi.' ");
INSERT INTO sbk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Inamuna ini ulume aileha uyise wakwe nu nyina wakwe aibhungana nushi wakwe, ");
INSERT INTO sbk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na eo bhabhili bhaibhabhili gumo; Pipo saga bhabhiatyele, lelo bhali bili gumo. ");
INSERT INTO sbk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kwa hiyo abhunganisye Ungulubhi, umwanadamu anje alehanye.” ");
INSERT INTO sbk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pali muhati inyumba, asundwa bhakwe bhahahuzywa nantyena asuili. ");
INSERT INTO sbk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Abhabhula, “Ula uwileha ushi wakwe na weje uwinji uyo abhomba malaya pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na ushi wope khaila ulume wakwe na wegwe nulume uwinji, abhomba malaya.” ");
INSERT INTO sbk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bhope bhahuleta abhana adodo akhate, lelo asimbi bhakwe bhahabha damila. ");
INSERT INTO sbk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lelo uYesu pahamanya ilwo, haga amojelela nalwo kabisa abhabhula, “Bhalesheli abhana adodo bhinze hulini, munganjebhazije, pipo abhabhalinishi ibha utawala uwa Ngulubhi wabhene. ");
INSERT INTO sbk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lyoli imbaula, yayunti uwa saposhela utawala wa Ngulubhi nishi abhana adodo lyoli haga aiwezywa awinjile utawala wa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ipo abhega abhana makhono agakwe abhasaya nabhabhishe akhono panya yabho. ");
INSERT INTO sbk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pahanda isafali yakwe umuntu umo anyililila ahafugamila amafuugamo witazi lwakwe, abhuzwa, “Mwalimu Umwinza, imbombe yenu ili bweze erithi uwomi uwa wilawila?” ");
INSERT INTO sbk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","U Yesu ayanga, “Unguga mwema? Numo ulimwema ila yu Ngulubhi mwene. ");
INSERT INTO sbk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uziminye imuli: 'Uganje agoje, unganje afunye umalaya, unganda awibhe ungande ande ilenga unganje akhopele, uheshimwaje uyese waho nu nyina waho'.” ");
INSERT INTO sbk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Umutyu ulo ahayanga, “Mwalimo, iganguntyi awande uwana wanhe.” ");
INSERT INTO sbk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","U Yesu amwenya nahugane. Abhula, “Upungushilwe ahatyu hamo. Uwaziwa ukazye uvhili navho nabhapele apina, uhaibha ni mbuto humwanya. Khasha winzaje andaje.” ");
INSERT INTO sbk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lelo akatile itama hunongwa iyaheleziwe iga; aliondoka akiwa mwenye huzuni, ahepa nusumane phepo alimale nyinji. ");
INSERT INTO sbk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","U Yesu ahenya upande bhutyi abhabhula asundwa bhakwe, “Nishi bhuli ishashashilyi pakhome utajili awinjile hutawala uwa hu mwanya! ");
INSERT INTO sbk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Asundwa bhaswijiziwa humaneno iga. Lelo uYesu abhabhula nantyele, “Bhana, ni jinsi bhule ishili shikhome awinjile utawala Ungulubhi! ");
INSERT INTO sbk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Laisi wingamia ashizanye mwilina lisindano, pakuliko umutyu utajili awinjile hufalume uwa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bhaswijiziwa sana nayangana bhene, “Esho yunanu uwa yokolewa” ");
INSERT INTO sbk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","U Yesu abhenya nayayanje, “Wabinadamu hagaiwezehana, lelo saga wa Ngulubhi. Wavhavhuthi wa Ngulubhi shiwezehana wa Ngulubhi shiwezehana.” ");
INSERT INTO sbk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","“Petulo handa ayanje nabho, “Enya tuleshile vhutyi tudajile.” ");
INSERT INTO sbk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","U Yesu ayanga, “Lyolyi imbabhula amwe, numouwaila inyumba, au ukulu, au uilumbu, au unyina, au uyise, au abhana, au ugunda, kwa ajili yangu, na kwa ajili ya lumbelele, ");
INSERT INTO sbk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","uwaha gaiposhela mala mia zaidi yisalaini ipa pansi: inyumba, ukulu, uyilumbu, au unyina, au abhana, au uinsi, humalabha, ulimwengu ugwa guweza, uwumi uwawila na wila. ");
INSERT INTO sbk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lelo vhinji avhali wanda bhaibhabhahumalishilo abhali bhahumalishilo bhawanda.” ");
INSERT INTO sbk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pabhabha mwidala, bhabhala Yelusalemu, uYesu abhatangulila witanzi lyabho. Asundwa bhasyijile, nabhala abhali bhafuta khosi yabho bhahogopa. Ipo uYesu abhefa pashinje antele bhala ilongo nabhabhili ahanda abhabhule hala hazafumile ishi papipi: ");
INSERT INTO sbk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Enya, tushila hula hu Yelusalemu, nu Mwana wa Adamu anzafisiwe wachungaji agosi nasimbi. Bhanzahulonje afwe bhanza humwefwe wa Bhapanzi. ");
INSERT INTO sbk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bhanza hulyeule, bhanza huswile amate, bhanzahukhome nusanzo, nahugaje. Lelo bada yinsiku zitatu azyuha.” ");
INSERT INTO sbk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","U Yakobo nu Yohana, abhana bha Zebedayo, bhahinza wamwene nayanje, “Mwalimu, tuwanza tubhombele hahundi atuhulabha.” ");
INSERT INTO sbk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ahagamuyiga, “Imbabho mbele yenu?” ");
INSERT INTO sbk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhahayanga, “Turuhusu tukhale nae husisya waho, umo hukhona ugwahulilo umo hukhono gwa humongo.” ");
INSERT INTO sbk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lelo uYesu abhajibula, “Sagammenye ilyamulabha. Mugawezya amwelele ishikombe ishimwela ane au ajimbe au uwoziwa uwi woziwa?” ");
INSERT INTO sbk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhaha bhala huje, “Tuwezya” uYesu abhabhula, “Ishikombe ishimwela mgawezya, amwe mwelele. Na ulyozyo ambao ininoziwe, mnzajimbilile. ");
INSERT INTO sbk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lelo uwakale ukhono ugwa hulilo au uugwa humongo saga nini uwafumwe, lelo wabhala ambao wavhene bhala ibhahandaliwe.” ");
INSERT INTO sbk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhala asundwa bhamo ilongo pahahuvhaiga bhaha vitililya aYakobo nu Yohana. ");
INSERT INTO sbk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","U Yesu abhakuga wamwene nayanje, “Mumenye ahuje bha abhasivhililwa bhatabhalwa bhabhatyu abhapansi bhatabhala, nabhantyu avhikhapho bhalanga mamlaka pamwanya yabho.” ");
INSERT INTO sbk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lelo saga iwanziwa avhe ishi muhati yinyu. Wabhundi uwanza abhe gosi kati yinyu atumishilaje abhanji, ");
INSERT INTO sbk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na wabhutyi uwawaza abhewanda pahati lazima abhanje watumishe wabhuntyi. ");
INSERT INTO sbk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wahuje Umwana wa Adamu hagaahiza atumishilwe bali atumishe nafume maisha gakwe abhvhe lisombo wa vhinji.” ");
INSERT INTO sbk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhahinza Yeriko. Pahali ashilaga Yeriko nasundwa bhakwe ni mbuga ingosi, umwana wa Timayo, Batimayo, uwafwile amaso, uwalabha mashinje insumbi. ");
INSERT INTO sbk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pahavha huje yu Yesu Mnazareti, ahanda akhole nayanje, “Yesu, Mwana wa Daudi, hulumile!” ");
INSERT INTO sbk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abhinji bhahadamila ula uyafumile amaso, bhabhulaga phumaa. Lelo alilaga husauti sana, “Mwana wa Daudi, hulumile!” ");
INSERT INTO sbk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","U Yesu ahima nahumula mulile akugwe. Bhahakuga ula uyafwile amaso, bhahayanga, “Huje shuja! Bhuha! U Yesu ahukuga.” ");
INSERT INTO sbk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ataga ikoti lwakwe hushinji ahanyila sana, na winze wa Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","U Yesu ahajibu nayanje, “Uwanza huje ibhombele yenu?” Ula ulume uwafwile amaso ahajibu, “Mwalimo, iwanza alole.” ");
INSERT INTO sbk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","U Yesu ahabhula, “Bhalanga. Awamini waho huponizye.” Pepo amaso gakwe gahalola; ahadaga uYesu wibalabala. ");
INSERT INTO sbk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ulyo ulya bha hizaga hu Yelusalemu, pabha hyela ga Besthfage na Bethania, wi Gamba ilya Mizeituni, uYesu abhatuma bhabhili muhati umwo mwa sundwa bhakwe ");
INSERT INTO sbk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","abhabhula, “Bhalaji hushijiji isha shi bhelana natyi. Pamu winjila umwo munzayaje idogovhi iya siinjilwe. Muyaule muilete hulini. ");
INSERT INTO sbk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nakhashele yayutyi uwabhula, 'Huje yenu mu bhomba ishi?', mubhajile ayanje ishi, 'U Bwana amwanza khashele abhuzwa ipa.'” ");
INSERT INTO sbk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhabhalile nayaje idovhi ipinyile huzi hulyango uta ugwaguliwaza, bhayabhulila. ");
INSERT INTO sbk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bhamo abhantu bhalivhimile pala bhaha bhabhula, “Mubhomba yenu, ayaulile idogovhi ini?” ");
INSERT INTO sbk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bhabha bhulile nishi uYesu ishabhulele, na abhanya bhaleha bhashila. ");
INSERT INTO sbk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Asundwa bhabhili bhahaleta idogovhi wa Yesu bhahalanga amenda gao pamwa yakwe ili uYesu awezyaje awinjile. ");
INSERT INTO sbk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abhantu ibhinji bhahalaga amenda mwibalabala, nabhamo bhalanga amasamba agabhatemile afume humagunda. ");
INSERT INTO sbk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bhala abhabha bhatile witanzi lwakwe na bhala abhadajile bhakhoma kelele, “Hosana! Asayiwe nuyahweza witawa ilwa Bwana. ");
INSERT INTO sbk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Usaiwe hutawala bhuwinza wayise witu Daudi! Hosana bhunu uli humwanya” ");
INSERT INTO sbk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Epo uYesu ahinjila hu Yelusalemu abhala hukanisa ahenya shila hantu. Ishi uwakati wali bhubhalile ahabhala hu Bethania bhala ilongo na bhabhili. ");
INSERT INTO sbk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Isiku ilyalya fwata pali bha bhuya afume hu Bethania, ali ni nzala. ");
INSERT INTO sbk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Alola ikwi ilya mtini amantyundu shahutali, abhala awenye huje agawezwa ahaje hahundti mwanya yakwe. Uwakati ula bhalaga wilyo, haga ahaga hahuthi ila amatundu, pipo hawali wakati mitini. ");
INSERT INTO sbk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Alibhula, “Numo yayuthi uwa ilwa udundu afume huliwe nathele”. Asundwa bhahuvha. ");
INSERT INTO sbk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bhahinza hu Yelusalemu, wope ahinjila mushibhanza anda afumwe huzi abha kazwa nabhagula muhati iyikanisa. Agaluzanya imeza tana nwa nihela namatengo gabhala abhali bhakazwa injibha. ");
INSERT INTO sbk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Haga aluhusu ya yunthi anyemule hahuthi mukanisa ahali hakaziwa. ");
INSERT INTO sbk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abhamanyizywa nayanje, “Lelo haga isimbilwe, 'nyumba yane ihaitwa ya labhe wabha panzi bhudti'? Lelo muvhishile ligwenyo lya bhafyula”. ");
INSERT INTO sbk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Achungaji agosi hasimbi vhahuvha ishali ayanjile ilwa hugoje. Hata isho bhamwogopa pipo imbuga ihaswijiziwe namanyizye wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Shila wakati nishalyevhela pihafihaga, bhashilaga hujini. ");
INSERT INTO sbk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pali bhajenda nashaphi, bhalilola ikwi ili mutini lyumile paka pamakholo gakwe. ");
INSERT INTO sbk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","U Petulo ahinzuha nayanje, “Mwalimu! Enya, ikwiimitini ilyuhalilanile lyumile”. ");
INSERT INTO sbk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","U Yesu ajibule, “Mubhanje ni imani lelo mwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mwini imbabhula mubhanje ni imani ushili bhula igambaili, 'Epa, liwitaje lyilyo munsumbi khashele huli mashaka mmwoyo gwakwe lelo awamini ishayanjile shaibhoneha, isho shawanza Ungulubhi shawanza. ");
INSERT INTO sbk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lelo imbabhula: shila hatyu isha mushilavha nishamubhuzwa kwaajili yumwene, mwaminilaje huje poshala vhape vhwibhe vinyu. ");
INSERT INTO sbk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pala pamuwimilila na labhe, muwaziwa abhahumile hahundi amunaho ashizanye wabhene ashele hahuntyi ili uyise winyu uwali humwanya ambhahoshele amwe pia izwa mutulile. ");
INSERT INTO sbk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bhahafiha hu Yelusalemu nandele. Hata pali ajenda mushibhaza, bhaha bhalila agosi bhachungaji na asimbi na ashigosi. ");
INSERT INTO sbk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhahabhula, “Mamulaka bhuli ubhomba amambo iga?” Wope yunanu uwa pelile ama mulaka huje ugabhombaje?” ");
INSERT INTO sbk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","U Yesu abhabhula, “Imbabhuzwa limo. Namwe mujibu khimba bhule huje nihumamulaka ashi ingabhomba iga. ");
INSERT INTO sbk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ulwozyo ulwa Yohana lwa hafuma humwanya au wabhanadamu? Ntabulili.” ");
INSERT INTO sbk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhayangana bhene wa bhene bhahayanga, “Khashele khatuje, 'Wafumile humwanya', abhayanje, 'Mbona basi haga mwamwamini?' ");
INSERT INTO sbk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lelo khatuje wabhaha fuma wa bhanadamu,'....” Ibhahogopa abhantu, mana abhantu bhalolile uYohana huje kuwa kamili. ");
INSERT INTO sbk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bhahajibu uYesu bhayanga, “Hagatumenye. U Yesu abhula, “Wala ane simba bhula amwe humamulaka ashi ibhomba iga. ");
INSERT INTO sbk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ipo uYesu ahanda abhamanyizye huvhi fwani. Ayanga, “Umuntu atotile hugunda amizabibu, azyunguzwa ulubhaga, ahadiba ilina ilwa khandile ahamwele. Ahazenga ahantu atali bada yipo apanjizywa ugunda ugwimizabibu ashula isafali iya hutali. ");
INSERT INTO sbk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uwakati pawahafika hatu ma utumishi walimi imizabibu aposhele afume wabhene vimo ivimadudu gahugunda igimizabibu. ");
INSERT INTO sbk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lelo bhakata, bhakhoma nahanyizywa bila haiduhahutde. ");
INSERT INTO sbk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Atuma utumishi uwinji bhavhahwalazywa mwitwe na hubhombele amambo agisoni. ");
INSERT INTO sbk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bado atuma uwinji, unuuwinji bha goga bhahabhombela abhinji amambo kama gigo, bhakoma bhamo bhabha goga. ");
INSERT INTO sbk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Alisile umuntu umozaidi uwahutume, umwana uyangenwe. Wope aliwamwisho uwatumilwe wabhene. Ayanga, “Bhaza huheshimuu mwana wane”. ");
INSERT INTO sbk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lelo apangaji bhayanga na bhene kwa bhene, “Unu yuyo uwaliyhi. Izaji, natugoje, uhu ulithi uzabhewetu.” ");
INSERT INTO sbk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bhahavhamila, bhahagoga nahutaje huzi iyigunda gwa mizabibu. ");
INSERT INTO sbk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Isho, Lelo ayibhomba bhuli utawala uwi gunda ili mizabibu? Ayinza na vhangamizywe abhalinza amizabibu na aipela abhanji ishamba ili mizabibu wa bhantu abhanji. ");
INSERT INTO sbk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hapete amanyile isimbo ili? “Iwe ilwa zenji bhalikhanile, lihabha liwe lwa nshinje. ");
INSERT INTO sbk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ili lihafuma wa Bwana, na liswizywa pamaso gityu.” ");
INSERT INTO sbk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bhahanza hukhate uYesu, Lelo bha hogopa umbungano. Pipo vhaminye huje bhayanjile ishifwano zaidi yao. Isho bhahaleha wabho. ");
INSERT INTO sbk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pipo bhahatuma bhamo na mahelodia wa mwene ili huteje hunongwa. ");
INSERT INTO sbk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pabhahafiha, bhahabhula, “Huje Mwalimo, tuminye huje haga usaga inzibho zhwazyunti haga ubhonesya apendelele pahati iya bhantu. Umanyizwa idala ilwa Ngulubhi pamwana lyoli. Lelo haki afumwe ikodi wakali sali au haa? ");
INSERT INTO sbk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lelo uYesu amenye aje bhalyeula na abhabhula, “Yenu munjela? Mbheli ihela injenye.” ");
INSERT INTO sbk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nabhayileta imo wa Yesu, Abhabhula, “Isura yana nu asimbo agagaliipa gananu? Bhayanga, “Ya Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","U Yesu abhabhula, “Panji u Kaisari ivintu ivha Kaisari vavha Ngulubhi panji Ungulubhi.” Bhahaswiga. ");
INSERT INTO sbk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ipo Amasadukayo, abhayanga nahumo azywoshe, bhahabhalila. Bhabhuzya, bhahaga, ");
INSERT INTO sbk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimo, uMose atusimbile huje, 'Gashele uholo uwa muntu khafwile aleshile ushi khosi yakwe, lelo haga aleshile umwana, mutu ayimwenga ushi uwaholo, nawipatile abhana kwajili yaholo wakwe.' ");
INSERT INTO sbk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wali na holo saba, uwa wandilo ahamwega ula ushi afwa, haga ahaleha abhana. ");
INSERT INTO sbk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Antele wope uwabhili amwega wope afwa, aleha abhana. Uwatatu wope shisho. ");
INSERT INTO sbk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nawa saba afwa bila aleshe abhana. Hu mwisho wakwe wope ushi ahafwa. ");
INSERT INTO sbk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Uwakati uzyushe, pabhaizyuha nandtele, Ishi ayibhawananu? Maana bhala aholo bhunthi saba bhundthi bhali bhalume bhakwe.” ");
INSERT INTO sbk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","U Yesu abhabhula, Lelo! Ili sagalila huje mukhopilwe, pipo samuminye amasimbo wala ikhone ilwa Ngulubhi?” ");
INSERT INTO sbk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Uwakati uwazyushe uwafume bhabhafile, haga bhayenga wala awinjile mundowa ila bhaibha na sha awandumi ahumwanya. ");
INSERT INTO sbk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lelo, ahusu abhafwe abhaizyuha, Lelo! Samwamanyila afume mushitabu isha Mose, ihabali ziha poli, shila Ungulubhi isha yanga abhula, 'Ani ni Ngulubhi uwa Ibulahimu, nani Ngulubhi Isaka, nani Ngulubhi uwa Yakobo?' ");
INSERT INTO sbk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Umwene sa Ngulubhi uwa bhafwa, ila wali bhumi. Lili wazi atejile.” ");
INSERT INTO sbk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","uwa bhawasimbi ahenza ahuvha izyabhayangaga inongwa zyabho; alola huje uYesu abhajibule shinza. Ahabhuzya, “Lelo! amuli ishi ili mana ishilizywe zyunti?” ");
INSERT INTO sbk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","U Yesu ahajibula, “Ilimana yayini, “Uvha Israeli, U Bwana Ungulubhi uwetu, Bwana umo. ");
INSERT INTO sbk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ilazimiha hugane uBwana Ungulubhi uwaho, hunwoyo hwaho gwundti, huroho yaho yundti hunjele zyaho zyundti nawikhone lwaho lyundti.' ");
INSERT INTO sbk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iamuli iyabhili yayini, 'Iwanziwa ugane upalamani waho nishi amuli iyinje ingosi zaidi yizi.” ");
INSERT INTO sbk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Usimbi ayanga, “Shinza Mwalimo! Uyanjile lyoli huje Ungulubhi aliumo na huje numo, uwinji zaidi yamwene. ");
INSERT INTO sbk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ugane umwene humwoyo gwundti, nahugane upalamani nishi puwiga ne wewe, nimuhimu mno kuliko uvifumwa nadhahibu izya lungulizye.” ");
INSERT INTO sbk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ulya Yesu pala pahalola ahafumwa ijibu ilinza, ayanga, “Awe haga ulihutali nu tawala uwa Ngulubhi.” Pipo numo hata umo uwa ajela hubhuzwe uYesu amaswali gagundti. ");
INSERT INTO sbk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","U Yesu ahajibu, lula uli amanyizya mushi vhanza ayanga, “Lelo! Asimbi bhayigabhuli huje uYesu Kilisiti ni mwana wa Daudi? ");
INSERT INTO sbk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi yuyo katika Roho Uuzelu, ayanjile, 'Bwana' ayanjile Bwana wane, khala kati yikho gwani hukhono ugwishulume pakaimbabhombe alugo pansi iyi magagagaho.' ");
INSERT INTO sbk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","U Daudi ahukuga Kilisiti, 'Bwana' Lelo! mwana wa Daudi nishi uli pugaishi gosi shimojile?” ");
INSERT INTO sbk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Amanyizywe wakwe uYesu ayanga, “Muwiyenyeje nasimbi abhasugwa ajende ni kazu intali nalamuwe musokoni ");
INSERT INTO sbk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na khale humatengo aga gosi umwaputile namu shikulukulu humaeneo agashigosi. ");
INSERT INTO sbk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Natena bhalwa nyumba inzwainzwafwile bhala bha amaombi amatali sana abhantu khabha bhenyaje. Ibha abhantu bhaipaulozi uwa uli gosi.” ");
INSERT INTO sbk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pala uYesu akhala panzi apalamane ni phogoso isadaka muhati inyi shi bhaza. Ali abhenya abhenya abhandtu abhafumiga panyanga indalama muphogoso. Abhandtu abhinji atajili bhahabhehanyishe huwinji uwindalama. ");
INSERT INTO sbk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ushi ufwile umaskini ahenza naponye ivipande vibhili thamani yasenti. ");
INSERT INTO sbk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ipo abhakuga asundwa wakwe na bhabhule, “Amini imbabhula, ushi unu ufwile afumizwe agosi zaidi ya bhundti bhala amalizizizye apanye mpongoso iyisa ndaka. ");
INSERT INTO sbk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwani bhundthi bhaponyizye elingananje huwinji uwivhi pato vhavho. Lelo ushiuda ufwile unu, afume humasikini wakwe, afumwa idalama yundti amabyo iziwanga.” ");
INSERT INTO sbk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","U Yesu pajendaga afume hushi bhaza, umo kati yabho asunda bhakwe ahabhuza, “Mwalimo, enya amawe gahunswisywa na mayumba!” ");
INSERT INTO sbk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Abhula, Mugalola ayumba amagosi? Nalimo ilyalya isangala hatalimo pamwanya yilyenje ilyasa lya igwisiwa paka pansi”. ");
INSERT INTO sbk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nawope pali akhele pamwanya yi Gamba ilyi Mizaituni khosi ishibhanzu, Petulo, na Yakobo, Yohana nu Andeleya bhabhuzya husili, ");
INSERT INTO sbk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tubhule, amambo igagaibhali? Na henu atenyeje amambo paga ifumila?” ");
INSERT INTO sbk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","U Yesu anda abhabhule, “Mubhanje maso umuntu yayundti asabhatezye. ");
INSERT INTO sbk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bhinji bhainza witawalwa ni bhaiyanga, 'Ane nene', na bhai bhatezya abhinji. ");
INSERT INTO sbk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pamwayuvha ivita na itetesi ili vita, mundawogope; amambo igalazima afumile, lelo umwisho gusili. ");
INSERT INTO sbk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Insi iyifuma alye ninsi iyinje, utawala akhomane nutawala uwinji. Wayibha antezywa mwunti mwunti munsi, waibha ni zala. Uwo mwanzo wichungu. ");
INSERT INTO sbk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Namwi munje maso. Munafisi nzyinyu maana bhai bhatwala amwe humabalaza nahusinagosi. Mwaikhomwa namwimwayegwa witanzi wa maliwali na watawala kwa ajili yalini, abheshuhuda wa bhene. ");
INSERT INTO sbk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lelo izyo lazima alumbililye wa pansi bhunti. ");
INSERT INTO sbk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Paibhakata nabha vitwililye, munganje awogope huje munzayanje ayenu. Uwakati uwo, mungandasibhe izya munzayanje uwakati uwo pabhuzya saga mwimwe umzayanje ilyanza bhapele uwakati bhula; liyangaji maana sa mweme mwamuyanga yu Roho Uzelu. ");
INSERT INTO sbk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uholo aitaka uhola wakwe huje bhagoje nubaba nu mwana. Umwana ayepaasu ayise bhabho nabhagoje. ");
INSERT INTO sbk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mwayegwa nashila muntu hasababu iyitawa lyani. Lelo uwaijimba paka pamalishilo, umuntu uyo aipona. ");
INSERT INTO sbk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pailola ilyavitililye lyiwima pasaliwaziwa awime (imanyila amanyaje), epo abhali muhati iya Yuda bhanyilaje humagamba, ");
INSERT INTO sbk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wope uyali wigulu anganda wishe aweje ivhapansi nyumba au aweje hahunti hali hunzi, ");
INSERT INTO sbk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","naulihugunda angandaa bhuye aweje umwenda gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lelo ole wabho abhashi abhikhanda nabhabha wonzya kati yisiku inzyo! ");
INSERT INTO sbk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mulabhaje huje ingandafumile uwakati uwisasa. ");
INSERT INTO sbk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maana waibha na malabha amagosi gala gasa gawahile afumile awande Ungulubhi paumbaga insi, pakaishi, na hamo wala haifumila andtele. ");
INSERT INTO sbk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bwana ugabhe haga azipunguzwaga insiku nanumo uwaponaga, lelo kwa ajili yate uliwa, azifupizye insiku izyo. ");
INSERT INTO sbk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Umuda ugwo umuntu yayunti uwayibhabhula, Enyi, uKilisti ali ipa!' au 'Enyi, pala!' mungandawamini. ");
INSERT INTO sbk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maana Akilisti abhilenga nakuwa abhilenga bhaifumila nabhaifumila ivhawenye na hajabu, ili amwe bhabhakhopele, yamukini nateuliwa. ");
INSERT INTO sbk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mubhanje maso! Imalishe imba bhulile igagundti kabula yu wakati. ");
INSERT INTO sbk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lelo bada yimaimba iginsiku izyo, isanya lwaibhewa ikhisi, umwezi hagwaifumia umwanga gwakwe, ");
INSERT INTO sbk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","intontwe zyaigwa afume humwanya, nikhone izywazi lihumwanya zyaiyinga. ");
INSERT INTO sbk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pailola Umwana Adamu pawinza mabhingo nikhone igosi nusisya. ");
INSERT INTO sbk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ipo paituma awandumi bhakwe aibhabhunganya pandimo nateliwa bhakwe ipande zyunti ingosi nzene izinsi, afume humwisho uwidunia upaka umwisho uwimwanya. ");
INSERT INTO sbk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Munyilaje wipishi ulusamba lubhi ha amatundu gakwe, pamwanya huje ulusanya lulipiphi. ");
INSERT INTO sbk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Isho shashili, pailola amambo igapagafumila, mumanye ahuje alipipe, mundwango. ");
INSERT INTO sbk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lyoli, imbaula, ishizazi sashisizanya hutali kabula ya mambo hagafumile. ");
INSERT INTO sbk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Imwanya ninsi zyainsinzanya, lelo amazyo gani haga insizanya na mwaha. ");
INSERT INTO sbk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lelo ahusu isiku au isaa, numo uwaminye, hata awandumi ahumwanya, hata Umwana, ila Uyise. ");
INSERT INTO sbk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Munje maso, Pipo sagamumuminye mudashi gaifumila. ");
INSERT INTO sbk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ishifwani shakwe shili nishi umuntu uwanza asafili: aileshile inyumba yakwe, apela atumwa bhakwe iamuli, nashila muntu imbombo ayakwe. Amula andalyango bhagonaje maso. ");
INSERT INTO sbk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bhanji masolelo! Piposaminye painza ubwana uwinyumba huje ulwebhela au usiku umanane, au pazikuga ihanda au ushaphii. ");
INSERT INTO sbk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Asahinze mundunyu abhaje shamugonile. ");
INSERT INTO sbk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ili ilimbabula amwe imbabhula mwindti: Bhajimaso”! ");
INSERT INTO sbk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zyali nsiku zibhili afume iPasaka nama Bumunda gasa gaponyeziwe Amila. Achungaji agosi nsimbi wabha hanzaga isha hukhate uYesu huhila nahugoje. ");
INSERT INTO sbk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pipo bhayanjile, “Haga wabhuuwishi kulukulu, abhantu bhasihinze elete itaka.” ");
INSERT INTO sbk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ulyo uYesu pali Bethania hukhaya wa Simoni umukoma, palije awelekela pameza, ushi umo ahenza wa mwene nisupa malashi ya nardo amiza agigalama ingosi sana, abojola isupa nasulule pamwanya iyitwe lyakwe. ");
INSERT INTO sbk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lelo kati yabho bhavitwa. Bhabhulana bhibho wabhibho bhahayanga, “Nayenu isababu uwateje uhuu? ");
INSERT INTO sbk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Manukato iga gewezyanga eguziwe winali miazitatu twabha panag asikini.” Na hadamila. ");
INSERT INTO sbk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lelo uYesu ahayanga, “Leshi yuyo mwene. Yenu musubula? Abhombile linza hu lini. ");
INSERT INTO sbk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Isiku zyunti amasikini munabho, umuda gwa gundti pamusungwa mugawenza abhombe aminza wabhene, lelo saga munzabhe nane uwakati waundti. ");
INSERT INTO sbk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambombile shila ishawezya: abhombe agupashile ubhili gwani amafuta kwa ajili yasyile. ");
INSERT INTO sbk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lyoli imbabhula, shila mahali izyo palumbililwa insi yundti, lila ilibhambile ushi unu shaiyangwa akubhuwe wakwe. ");
INSERT INTO sbk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pipo uYuda Iskariote, umo uwabhala ilongo na bhabhili, abhalile wagosi uwachungaji ili apate hutwale wa bhene. ");
INSERT INTO sbk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uwakati agosi Abhachungaji pabha hu vha isho, bhamojile bhahaidi hupele ihela. Andile awanze inafasi iyapele abhene. ");
INSERT INTO sbk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isiku ilya wande ilibumunda ilyasaliponyeziwe imila, uwakati uwabhafumia inyama ingole ipasaka, wanafunzi wake walimwambia, “Unataka twende wapi tukaandae ili upate kula mlo wa Pasaka?” ");
INSERT INTO sbk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Atuma asundwa bhakwe bhabhili nabhabhule, “Aje bhalaji hujini, na ulume uwanza tangane namwi akhente ulusai lyiminzi. Dagaji. ");
INSERT INTO sbk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Inyumba yanza winjile, dagaji nahubhule umwani nyumba iyo, 'Mwalimo ayanga, “Shi ibuba ishajenyu ailye iPasaka umwo pandwimo na asundwa bhakwe?” ");
INSERT INTO sbk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wope yuyo abhalanje igolofa ingosi isimbilwe tayali. Umwo tayalisyaji.” ");
INSERT INTO sbk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Asundwa bhahabhala hujini; bhaga kila handu haisha yangaga, bhatayalisya iPasaka. ");
INSERT INTO sbk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pawahafiha ulyebhela, ahinza na bhala humi na bhabhili. ");
INSERT INTO sbk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pabhanga bhaibhelela imeza naje bhalye uYesu ayanga, “Lyoli imbaula, umo kati yenyu abhanenelele.” ");
INSERT INTO sbk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bhanda asononeshe, bhaha bhala umo umo, “Lelo nine?” ");
INSERT INTO sbk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","U Yesu ahajibu ihubhula, “Ali umo ulilongo nabhabhili muhati yinyu, umo ambaye ishi atovhela uluntonji mubhakuli palushimo nane. ");
INSERT INTO sbk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pipo Umwana wa Adamu abha bhale nishi amasimbo ishaga yanag pamwanya yakwe. Lelo ole wa mwene umuntu ula uwanza hu nenelele Umwana wa Adamu washinza! umuntu uyo gabhe haga apapwaga.” ");
INSERT INTO sbk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pali bhalya, uYesu ahega ibumunda, alisaya na limesule. Apela nayanje, “Chukueni. Ugu ubile gwani. ");
INSERT INTO sbk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ahega ishikombe, akasarifwa, apela, bhamwelela. ");
INSERT INTO sbk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Abhabhulile, “Ili idada lyane ililagana, idada ilya liwitiha kwaajili yabhinji. ");
INSERT INTO sbk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lyoli imbabhula, sigaihamwela nantele paka pisiku lila paimwala ipha hutawala ula uwa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pabha habha bhamalile atele ulyimbo, bhahashilainje Igamba ili Mizeituni. ");
INSERT INTO sbk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","U Yesu abhabhula, “Amwe mwinthe munza wibangule huhutari kwaajili ya yane, phepo isimbilwe, 'Aikhoma umchungaji naingole zinza nyabhane.' ");
INSERT INTO sbk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lelo baada yazyushe wani, aibha tangula witazi lyinyu wi Galilaya.” ");
INSERT INTO sbk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo ahabhula, “Hata kama bhundti bhaileha, aani sihaileha.” ");
INSERT INTO sbk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","U Yesu abhabulile, “Lyoli ihubhula, usiku hubhu ihanda shazili akuje habhili, uhanile mala hatatu.” ");
INSERT INTO sbk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lelo u Petulo ayanjile, “Ibhadazimisye afwe nawesaga imba hu lyije bhunti bhafumia ihadi ile ile. ");
INSERT INTO sbk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhahinzele kwenye ieneo ilyaitwaga Gethsemane, uYesu ahabhula asundwa bhakwe, “Khalaji ipa uwakati ilabha.” ");
INSERT INTO sbk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Abhega Petulo, Yakobo, na Yohana pandwemo nawo, nahanda asononeshe hata miwe sana. ");
INSERT INTO sbk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ahabhula, “Inafsi yani yani isoneneha sana, hata afwe. Sagalaji phepa nabhemaso.” ");
INSERT INTO sbk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","U Yesu abhala witanzi hashe, ahagwa paka panzi, ahalabha, ghashiwezena, huje isaili linepushe. ");
INSERT INTO sbk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ahayanga, “Aba, Baba, Amambo gunte huliwe gawezehana. Unefenzwe ishikombe ishi. Lelo saga hu mapenzi gane, ila amapenzi gaho.” ");
INSERT INTO sbk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abhuya abhaga shabha gonile, abhula aPetro, “Simoni, we ulishugonile? Hagauwezizya abhe maso hata isaa hatalimo? ");
INSERT INTO sbk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Khalaji maso mulabhaje musahenze. Agwile mujelo. Lyoli roho ili tayali, lelo ubhele dhaifu.” ");
INSERT INTO sbk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ahashila nantele alabhe, atumila zinongwa zyazila. ");
INSERT INTO sbk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ahenza nantele ahega shagonile, pipo amaso goo galimamwamu nahamenye henu ahabhule. ");
INSERT INTO sbk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ahenza mala hatatu shabhabhula, “Muli sha mugonile na tuyaji? Muyile! Saa ifishile. Enya! Mwana wa Adamu bhanza hutake wilenga makhono agabhibhivhi. ");
INSERT INTO sbk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bhuhaji, sali. Enya, ola uwantake wilenga alipipi.” ");
INSERT INTO sbk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Enya alishanga uYuda uwalipadwimo na abhilongo na bhabhile, afiha, nimbuga ingosi afume wagosi bhachungaji, asimbi agosi napanga na madugu. ");
INSERT INTO sbk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Umuda gwugwo uhutake wilenga wakwe ali apile ishimanyilo, ayagaula uhbinza hununile yuyo khataji nahutwale nabhe chini alidwaje.” ");
INSERT INTO sbk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lelo uYuda pahafiha, moja kwa moja ahabhala wa Yesu nayanje, “Mwalimo!” Anunila. ");
INSERT INTO sbk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pipo uwaponye panzi yagulye nahukhatwe. ");
INSERT INTO sbk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lelo umo muhati yao amenlela paphephe nao achomola ipanga lyakwe akhoma utumishi uwa chunga ugosi nahudumule ikutu. ");
INSERT INTO sbk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","U Yesu abhabhulile, “Mwenzele ahate namapanga nadugu nishi uwafula? ");
INSERT INTO sbk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Uwakati shilasiku nabha namwe shimbamanyizya, mushibhanza. Sagamwahataga. Lelo ili libhobishe ili amasimbo gatimile. ");
INSERT INTO sbk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bhala bhunti bhali nu Yesu bhaleha nahunyile. ");
INSERT INTO sbk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Usaha umo ahakunya, uwali akwite ishuka lyene awikwishile hu zyugule; bhakhata lelo ");
INSERT INTO sbk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","apulumuha alileha ishuka pala ahanyila bhululu. ");
INSERT INTO sbk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bhahalongola uYesu wachungaji ugosi pala paungene padwemo nao nabha chungaji agosi bhunti nashi gosi nasimbi. ");
INSERT INTO sbk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","U Petulo wope ahadaga uYesu shahutali, awelekele wizyala wachungaji ugosi. Akhala pandwemo nabhagula bhali bheline numwoto bhahotaga ili apate ilyoto. ");
INSERT INTO sbk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Umuda ugwo achungaji agosi bhunti ni balaza lyundti bhanzaga uketi zaidi ya mwene uYesu ili bhapate hugoje. Lelo habhamwaga. ");
INSERT INTO sbk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Huje abhantu ambinji bha haleta ilenga ashile umwene, lelo uketi wabho hawalinganaga. ");
INSERT INTO sbk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bhamo bhahemelye lyanelete uketi uwilenga ashe wa mwene; bhayanga, ");
INSERT INTO sbk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tumamwuvha ayanag, 'Iha inanganya ishibhanza ishi ilyaliganiziwe humakhono, nahuku zitatu ihaizenga ilyta mwao ilyasa linganiziwe humakhono.”' ");
INSERT INTO sbk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lelo hata uketi wao hali nganaga. ");
INSERT INTO sbk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Uchungaji ugosi amelila pahati yao abhuzwa uYesu, “We, hagaulinijibu? Aa hantu ibha bhayanga yenu kwaji yaliwe?” ");
INSERT INTO sbk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lelo ahapuma mee hagajibula nalimo. Pipo uchungaji ugosi ahabhuzya nantele awe wi Kilisti, umwana Uwasaiwa?” ");
INSERT INTO sbk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","U Yesu ayanje, “Huje ani nini. Uhailola Umwana wa Damu akhele hukhono ulilo ugwikhone awinza na mabhingo aga humwanya.” ");
INSERT INTO sbk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Uchungaji ugosi azembula amenda gakwe nayanje, “Lelo tuli shatu wanza aketi? ");
INSERT INTO sbk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muhuvha amatusi. Uwamuzi winyu vhulihu?” Na bhunti vhalongaga nishi iyabhajile ufwe. ");
INSERT INTO sbk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bhamo bhahanda huswile amate nahu kwishile amaso nahukhome nahu bhule, “Loto!” Maafisa bhamwega na hukhome. ");
INSERT INTO sbk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","U Petulo pahali bado panzi pizyala, utumishi umo uwalindu uwa chungaji ugosi ahizile wamwene. ");
INSERT INTO sbk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ahalola uPetulo pahiminlele awota umwoto, ahamwenya nahubhelele. Ipo ahayanga na wewe uhali nawa Mnazareti, uYesu”. ");
INSERT INTO sbk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lelo akhana, ayanga, “Saga imenye wala siwelewa ahusu hala uhuyanga!” Ipo ahepa abhala huzi wizyala ihada ihakuga. ");
INSERT INTO sbk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lelo utumishi uwishishi pala, ahalola ahandile hubhule na dtele bhala abha bhalivhimile pala, “Umuntu unu alipamoja anao!” ");
INSERT INTO sbk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lelo akhana natele ndtele pamandi hashe bhala abha hali himilile pala bhali bhahubhula uPetulo, lyali awe ulipamoja anao, “Maana na wewe uli mu Galilaya” ");
INSERT INTO sbk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lelo ahandile awibhishe pansi ishigune nawande alape, “Saga imenye umuntu unu uwanuhuyanga.” ");
INSERT INTO sbk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ipo ihanda ihakuga ulwabhilye. Ipo Petulo ahizuha izya yangaga gala uYesu agali ahubhula: “Shasili ihanda shisili akuje malahabhili, uzahane mala hatatu.” Ahagwa paka pansi nalile. ");
INSERT INTO sbk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nashaphi shausili agosi abhachungaji bhatangana pandwimo nagosi na simbi na bhibalaza sha lyundti ilyangosi. Kisha wakamfunga Yesu wakampeleka kwa Pilato. Pilato akamwuliza, “wewe ni Mfalme wa Wayahudi?” ");
INSERT INTO sbk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","“Ahabhajibu, “Awe unjele isho.” ");
INSERT INTO sbk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Agosi abhachungaji bhahelezya amashitaka gaminji ju ya Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","U Pilato abhuzya nanthele, “Haga ujibu hahundte? Haga ulola ishabha hukata humambo aminji? ");
INSERT INTO sbk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lelo uYesu haga ahajibu uPilato, ilya lya syizwa. ");
INSERT INTO sbk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nishi ikawaida uwakati uwishikulukulu awigulilya ufungwa omo, ufunga uwalabhile. ");
INSERT INTO sbk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wali atulanongwa wijela, palushimo nabha goga muhati bhali asawogopa. Abhatumishila ulozi wao. Ahali umuntu umo uya witwa Barnaba. ");
INSERT INTO sbk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ibuga ihenza wa Pilato, na hulavhe abhombe ishabhombaga uwo khosi. ");
INSERT INTO sbk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","U Pilato abha jibu nayanje, “Munza imba fungulile Utawala uwa Yahudi?” ");
INSERT INTO sbk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pepo amenye pipo hunongwa ikelo agosi bhachungaji bhakata uYesu nahutwale wamwene. ");
INSERT INTO sbk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lelo agosi bha chungaji bhansonjelezya ibunga akhome iholo usauti uje ayigulilye Baranaba bada yamwene. ");
INSERT INTO sbk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","U Pilatoi abhajibu andtele nayanje, “Ibhombe bhuli Utawala Uyahudi? ");
INSERT INTO sbk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bhaha bwaga nandtele, “Musulibishe!” ");
INSERT INTO sbk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","U Pilato ayanga, “Abhombile lijambo nshi?” Lelo bhahazida akhome ikelele zaidi na zaidi “Musulubishe.” ");
INSERT INTO sbk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","U Pilato ahanza abhalizisye ibuga, abhigula Baraba. Akhama uYesu nujalindi afumia ili asulubiwe. ");
INSERT INTO sbk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Askali bhahalogola hadi muhanti izyala (bhula uwali muhati ikambi) bhabhungene pandwemo ishikundi ishasikali. ");
INSERT INTO sbk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakwatizya uYesu ikhanzu iyilangi izambarau, bhapota inginga imivhwabha kwatizya. ");
INSERT INTO sbk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhanda hulyeule nayanje, “Mwagona, Mutawala uwa Yahudi!” ");
INSERT INTO sbk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakhoma witwe namenda nahuswile amanti. Bhaha fugama amafugamo witanzi lyakwe huheshimu. ");
INSERT INTO sbk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Paka pahali bhalyeule, bhahaula ikhanzu ilangi izambarau, nahukwatizye amena gakwe, bhahafumila hunzi abhale husulubisye. ");
INSERT INTO sbk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bhalazimisya ajende idala humwavhe, uwa winjila hujini afume hu gunda. Uyawitwa Simoni Mkirene(uyise wakwe Iskanda na Rufo); bhalazimisya anyemule ishikhovhehanyo isha Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Asikali bhahatwala uYesu apawitwa Goligotha (amana gakwe itafsiri ine, mahali ipo yi fuvulitwe). ");
INSERT INTO sbk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhapela ihobwa isangine ni manemane, lelo haga amwela. ");
INSERT INTO sbk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bhasubisya bhahagabhana amenda gakwe, bhagakhomela ikula awamule ishi pande ishabha pante shila sikali. ");
INSERT INTO sbk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ibhanga ibhala saa tatu nashaphi pabha sulubisyaga. ");
INSERT INTO sbk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhabhiha pamwanya yakwe ulubao ululyasibilye ishitaka “Mutawala wa Yahudi.” ");
INSERT INTO sbk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhasulubisya pandwimo na majambazi bhabhili, umo hukhono ulilo uwinji hukhono ugwa hu mongo gwakwe. ");
INSERT INTO sbk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bhope pali bhajenda bhaligaga bhayizyaga, amatwe gao bhayangaga, “Aha! awe bhuhajile uhaibomola ishibhaza hunsiku zitatu, ");
INSERT INTO sbk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wiyokole bhumwene iyish pansi afume pashi khovhe hanyo!” ");
INSERT INTO sbk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inamuna yila agosi bhachungaji bhalyeula bhayangana, pandwimo nasimbi nayanje, “Ahupaga abhanji, Lelo hagawezya awiyupe yuyo. ");
INSERT INTO sbk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kilisiti Mtawala wa Israeli, iha panzi ishi fuma pashikhovhehanyo, ilituwezye alole na waamini.” Na bhala abhasulubisye pamoja anao bhalye. ");
INSERT INTO sbk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pihafiha isantanda, ikisi ihenza pamwanya insi yundti paka musatisa. ");
INSERT INTO sbk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pahafi itisa, uYesu ahakhoma ikelele husauti ingosi, “Eloi, Eloi, lama sabaktani?” ihabhanga namana “Ngulubhi wani, Ngulubhi wani, yenu undeha?” ");
INSERT INTO sbk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bhamo abhahimilyile pahuvha bhayanga, “Enya, ahuku ga Eliya.” ");
INSERT INTO sbk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umuntu umo anyila, amemia siki mu sponji nabhi she amwanya mwipishi ili la lanzi, ahapela ili mwele. Umuntu umo ahayanga, “Gula tulole khashele Eliya kama awinza humwisye pansi.” ");
INSERT INTO sbk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Phepo uYesu ahalila nu sauti ingosi afwa. ");
INSERT INTO sbk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ipazia lishibhanza lyalyaganiha tupande tubhili afume humwanya hadi panzi. ");
INSERT INTO sbk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Afisa umo uwahemelele abhelelaga wa Yesu, pahalola huje afile hunamuna ila, ayanjile, “Lyoli unu umuntu ali Mwana wa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhanga pipo abhashibhali wenya shahutali muhati yao umo ahali. Umaliamu Magdalena, uMaliya (unyina wakwe Yakobo udodo wakwe Yose), na Salome. ");
INSERT INTO sbk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Uwakati pahali Galialaya bhadajile nahutumishile. Abhashi bhamo abhanji bhambatana nao hadi uYelusalemu. ");
INSERT INTO sbk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pawabha lyebhela, pipo lyali wiyandale, isiku kabula isiku Lyatule, ");
INSERT INTO sbk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","U Yusufu wa Arimathaya ahizile pala. Alijumbe uwi Balaza uwaheshimiwaga umuntu uwatalajila utawala wa Ngulubhi husajili abhala wapi ahabhala wa Pilato, ugulabhe ubili ugwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","U pilato asyiga huje lyoli tayali uYesu afwile ahakuga ola afisa aha bhuzya huje lyoli uYesu afwile. ");
INSERT INTO sbk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pawaga uwanalyoli wa afisa aluhusu uYusufu agweje ubili. ");
INSERT INTO sbk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","U Yusufu ali akalile umwenda. Amwisya afume pashikho bhehanyo. Apinya numwenda nahubhishe muhati mukhungwa ilyandibilye mumwamba. Ipo augulusya ingaga pahali pa mahali pakhugwa. ");
INSERT INTO sbk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","U Maliya Magdalena na Maliya unyina wakwe uYose bhahalola amahali pasyilwa uYesu. ");
INSERT INTO sbk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Uwakati ulutoyo palyafiha, Maliya Magdalena na Maliya unyina wakwe u Yakobo, na Salome, bhahakala anukato aminza, bhahenza nagupashe amafuta ubinle ugwa Yesu pipo bhaza syele. ");
INSERT INTO sbk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nashaphi naizashi pisiku ilya wandilo ililungo, bhaha bhala awenye igugwa uwakati isanya shalisile atukule. ");
INSERT INTO sbk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bhayangana bhene kwa bhene, “Yunanu uwanza libhungulusye ingaga kwaajili yalitni ili tinjile mungugwa?” ");
INSERT INTO sbk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pala pali bhawenya bhahalola umuntu aliungulusye ingaga, ilyali gosi sana. ");
INSERT INTO sbk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bha hinjila mukhugwa bhahalola usahala usahala akwete ijoho izelu, akhele upande uwililo, bhasyijiziwa. ");
INSERT INTO sbk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Abhabhula, “Mungandawogope. Muhumwanza yu Yesu, wa Nazareti, uwabhasulubisye. Azyushele! Numo ipa. Enya pala palibhabhishile. ");
INSERT INTO sbk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bhalaji, mubhabhule asundwa bhakwe na Petulo huje abhatangulile abhale Galialaya. Uwo munzahulole, nishi paulaga.” ");
INSERT INTO sbk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bhashila nanyile awepe pangugwa bhatetema nasyije hagabhayanga nazimo wa muntu wawundti pipo bhahogopa ntee. ");
INSERT INTO sbk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wope pazyuha nashaphii pisiku ilyawande ilungu, afumila asonti u Maliya Magdalene, ula uwabha mwefizye iphepo saba. ");
INSERT INTO sbk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Uyo akhata idala ahanda abhabhule inongwa bhala abhali pamoja nu mwene, bhope bhalishazinda nalile. ");
INSERT INTO sbk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lelo ibho pabhahuvha huje ali mwume, wophe alolile sagahamini. ");
INSERT INTO sbk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baada yisho, abhafumila abhandtu bhabhili kati yao anuwaji uwinji, bhope khete idala ilya bhal ehugunda. ");
INSERT INTO sbk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bhope ibho bhahashila na habhabhula inongwa bhala abhanji, bhope ibhoha gabhahamini. ");
INSERT INTO sbk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pamandi abhoneha nabhala ilongo nomo palibhalya, abhadamila hula asinte nawamini wabho ukhome wimoyo gabho, pipo sahamini bhala abhalolile pazyuha. ");
INSERT INTO sbk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Abhabhula, “Uje bhalaji mnsi yundti, mulubhelaje inyo wa shila shiumbe. ");
INSERT INTO sbk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uya wamini na woziwe aipona uwasiga awa mini ailogwa. ");
INSERT INTO sbk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ishi bhoneshelo ishi zyaidagana nebho abhayamini witawa lyani bhayefha iphepo. Bhayanga ijango iphaa. ");
INSERT INTO sbk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bhaikhata azhoha hata mwele ahantu hazholo vhisya, hagabhaithuliha kabisa bhaivhiha amakhono pavhinu bhaibhani hafya.” ");
INSERT INTO sbk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na uBwana Yesu, baada ya njenao, ahegwa humwanya wingo, akhala hukhono ugwishilume ugwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bhope bhala bhahepa bhalumbilila wundti, Bwana abhomba nao imbombo nao nazyusyelila ineno nivibhoneshelo ivha bhahena nalyo. ");
INSERT INTO sbk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Afwanaje abhantu abhinji bhabheshela amakhono asebhe eshe tukalibu owe nongwa nelwe mombia gula gagu timiziwe pahati yetu, ");
INSERT INTO sbk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Neshe bhala shubhatihudithiga bhala bhabhahali bhashahidi bhagalolaga. na bhula atumishi abhalila izu elyufume ahwande. ");
INSERT INTO sbk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Endolile shinza ane nane, afwanaje ehwiyanzie ulwilyoli amambo ega gonti afume huwandilo husimbire hupanjililo Theafilo hwutukfu. ");
INSERT INTO sbk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Opate amanye elyoli emambo gala gohasambelezewe. ");
INSERT INTO sbk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Umwaha gwa Herode, umwene uwa Yudea, palino kohani omo itawa lyakwe Zakaria, uwa tandilane no Abya. No she wakwe bhulibhabhebho ya Haruni, itawa lyakwe Elizabeti. ");
INSERT INTO sbk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na hwonti bhabhele bhali bhelyoli hwitagalila elya NGOLOBHE; bhahendeleye ne ndajizwo zwonti ezwa gosi ne ndajizwo lyakwe bila eyaune. ");
INSERT INTO sbk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bhape sebhali no mwana eshi Elizabethi ali gomba, na bhonti bhabhule bhali bhagogolo tee. ");
INSERT INTO sbk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Basi nashi nabhombaga embombo eye ukuhani uwa taratibu uwa tandilane hwakwe hwitagalila elyu NGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Neshe shashahali ekawaida yao eye Ukuhani, ekora ehangweleye ahwinjile mshibhanza esha gosi ili kufukizo uvumba. ");
INSERT INTO sbk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na mabungano gonti ega bhantu bhali puta hwonze esaa ya kufukiza uvumba. ");
INSERT INTO sbk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wafumilya no malaika uwa gosi ayemeleye upani uwendelo paluputo ya kufukiza. ");
INSERT INTO sbk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria nawalola adhugumiye owoga wamwinjiye. ");
INSERT INTO sbk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lelo ula umalaika wabhola uganje, “Awogope Zakaria, eshi apute hwaohwo vwehwe. Na ushe waho Uzabeth aihupapila umwana. Olume na itawa lyakwe wayihumweta Yohana. ");
INSERT INTO sbk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nawe wabha nolunzongwo na shangwe nabhantu abhinji bhayihusongwa apapwa hwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwasababu ayibha gosi hwitagalile gosi sagayimwela idivai wala akholwe wape aimemezewe. ");
INSERT INTO sbk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Upepo umwololo hata afume mvyanda mwanyi wakwa Na abhini abha Israeli aibhaweziye hwa gosi UNGOLOBHE wao. ");
INSERT INTO sbk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wapa aitangulila hwitalilo lyakwe ne roho ye hwa Eliya. Enguvu zwakwe ili agagalusye amoyo gabhuise igabhalile abhana, na abhabheshela bhabhatejile enjele ezye bhelyoli na hubheshele ugosi tayali abhantu bhabhalenganyinziwe.” ");
INSERT INTO sbk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria abholele malaika, “Naimayawele izu ulyo eshi endigogolo na ushe wane gogolo wensiku nyinji.” ");
INSERT INTO sbk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Umalaika wagalula wabhozya, “Ane ne Gabrieli, nenemeleye, hwitagalalilo lya NGOLOBHE. Nane entunuwilye anjanje nawe, na hubhole lenongwa ezi enyinza. ");
INSERT INTO sbk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na nyenye, ubhabhe bubu, sobhayanje, mpaka isiku lila nayayibhombeha. Ego kwasababu sewahovwezye enongwa zyane gape gayitimila huwakati wakwe.” ");
INSERT INTO sbk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nabhala abhantu bhalibhahugolela uZakaria. Bhaswiga akhalilihwakwe mla mshibhanza. ");
INSERT INTO sbk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nawafuma alisagawezya, ayanje nao bhamenye aje. alolile amaono mhati mshibhanza. Wape ahendeleye abhalolesya akhale abhebubu. ");
INSERT INTO sbk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zyabha ensiku ezye utumishi wakwe nuzyafiha abhalile akhaya yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Huta ensiku zila ushe wakwe ulizabethi apate evyanda wabha na amezi gasanu. Nawayanga, “ ");
INSERT INTO sbk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Eshi shambombeye UGOSI ensiku zila zyanenyizya esoni yane hwitagalilo elyabhantu.” ");
INSERT INTO sbk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Umwezi uwa tanda umalaika uGabrieli asontezywe no NGOLOBHE abhalile mpaka mji wa hu Galilaya, itawa lyakwe Nazareti, ");
INSERT INTO sbk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hwa rendu ubikira ya pabhiliwa no muntu itawa lyakwe Yusufu. Wa hutali hwa Daudi, na itawa lyakwe ubikira uyo yu Mariamu. ");
INSERT INTO sbk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ahinjila munyumba yakwe wayanga, “Mwagona, upewewe eneema! no GOSI alipandwemo nawe.” ");
INSERT INTO sbk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wapa ashelile tee afwatana nenongwazyakwe. Asebha humwoyo endamuho ene yeshe. ");
INSERT INTO sbk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Umalaika abhola, “Ugaje hogope, Mariamu, afwanaje upate eneema afume hwa NGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Enya ubhahweje, uyanda na pape umewna ulume, na itawa lyakwe ubha hwumwete u 'Yesu.' ");
INSERT INTO sbk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Oyo aibha GOSI abhahwetwe mwana yali humwanya uGOSI UNGOLOBHE alihupela itengo elye umwene u Daudi use wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Abhaitawale ekhaya eya Yakobo wilawila na umwene wakwe sewayibha no umalisholo. ");
INSERT INTO sbk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","UMariamu wabhola umalaika, zibhabhe wele enongwa ezi, afwanaje semenye ulume? ");
INSERT INTO sbk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","UMalaika wajibu wabhola, “Upepo Uselu abhahumwenzele pamwanya yaho, na engulu zyakwe yalipamwanya zibhahu vwenwsye. Neshe izyongozi afwatanaje oyo yayipapwa ayibha zelu mwana wa NGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Antele, enye uholo waho Elizabeti wape apete ulyanda ulya mwana ulume. ");
INSERT INTO sbk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Afwatanaje nalimo izu lyasagaliwezehala hwa NGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","UMariamu wayanga, “Waga, enye ane endi wembombo wa GOSI. Ebhehuline neshe shoyajele.” Antele umalaika wasogola wabhala hwamwahale. ");
INSERT INTO sbk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Basi u Mariamu wasogola ensiku ezyo wabhola hata ensi ya humagamba nanali mpaka ensi emo ya hwa Yudea. ");
INSERT INTO sbk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Winjelo munyumba mwa Zekaria walamuha u Elizabeti. ");
INSERT INTO sbk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yabha, Elizabeti nahwovwa hula alamushe kwakwe uMariamu, ahana ahela handa ahwanje mvyanda vyakwe, Elizabeti wamema opepo Uzelu. ");
INSERT INTO sbk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wakhola hwizu elyemaha wanyaga usayilye, “Hwabhashe bhonti nawe empapwo yaho esaiwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Unfumiye izu eli, hata omaye uwu GOSI wane anenzelene? ");
INSERT INTO sbk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nenshe izu ilyalamusha gane ahana ahela hanga hasongwelwe mhati mvyanda vyane. ");
INSERT INTO sbk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wape nafu yayovyezye neshe naga itimila gabholelwe no GOSI.” ");
INSERT INTO sbk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Omariamu wayanga, omwoyo gwane gwamwenye ONGOLOBHE, ");
INSERT INTO sbk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Roho yane esongwezye ONGOLOBHE yanauye ane. ");
INSERT INTO sbk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Afwanaje agwenyizye unyonge uwe mbombo wakwe. Eshe, enyaga ahwandileshi evikholo vyonti vyayikwizya osayilwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Afwatanaje owemaha ambombeye amagasi, lyape itawalyakwa lizelu. ");
INSERT INTO sbk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ERehema zyakwe zidela evikholo ne vikholo hwebho bhahahuputa. ");
INSERT INTO sbk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Abhombile amaha uhukhono gwakwe; abhanyampenye abhemashento afume masebho ezye moyo gabho. ");
INSERT INTO sbk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhagwisizye agosi mmatengo gabho ageshimwene na nyonge abhabhosezye. ");
INSERT INTO sbk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abhenzala abhakutizizye aminza, bhape abhemali abhefwizye makhono wene. ");
INSERT INTO sbk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amwavwizye u Israeli uwembombo wakwa ili ahwizushe rehema zyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Neshe shubhabhozezye ababa bhetu) Ibrahimu empapwo yakwe mpaka welawila.” ");
INSERT INTO sbk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","UMariamu wakhala nawo mpaka amezi gatatu nantele wawela abheale akhayayakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Zyabha ensiku ezya pape hwakwe u Elizabeti nazya timila, wapapa umwana lume. ");
INSERT INTO sbk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bhahovwezye ajirani na mwabho bhakwe, aje GOSI amwonjezyezye erehema bhasongwa pandwemo nao. ");
INSERT INTO sbk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lyabha isiku elya nane wakati wa kutahiri omwana. Bhahanza hupele itawa elyayise, “Zakaria,” ");
INSERT INTO sbk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Unyino wakwe wagalula wayanga, “Nkashele; seshasho basi ayibha yo Yohana.” ");
INSERT INTO sbk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhabhola sepali amuntu afume hwamwenyu bhaho akwiziwe itawa elya Yohana. ");
INSERT INTO sbk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bhamwanya usewakwe sabhu hwmwete. ");
INSERT INTO sbk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wanza ahabampa wasimba aje, “itawa lyakwe yo Yohana.” Bhaswijitie bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pepo na pepo ilomu lyakwe liguha numele lyakwe antele wanda ayaje. Nautelele ONGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bhinjilwa nowoga bhonti bhali bhakheye pandwemo, na. mambo ego gonti gatangazezwe ensi yonti yammagamba mgamba e Yudea. ");
INSERT INTO sbk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na bhonti bhabhagovwezye bhagabheha humoyo gabho, bhayanga, “Umwana uno ayibha wefwane hwele?” Afwaneje ukhono ogwa GOSI gwali pandwemo no mwane. ");
INSERT INTO sbk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","UZakaria uyise wamema opepo ozelu, wakuwawanyanga, ");
INSERT INTO sbk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Abhosewe OGSI, ONGOLOBHE wa Israeli, afwanaje abhenzeye abhantu bhakwe na bhaule. ");
INSERT INTO sbk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atemelesezye empeta eyataule afume mlyango ugwa Daudi, uwe mbombo wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nenshe ayanjile afume huwandilo hwilumu elyakuwe akuwe bhakwe azelu. ");
INSERT INTO sbk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tisatulwe na bhibhi bhentu na mma khono gabho bhonti bhabhativitwa ");
INSERT INTO sbk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ili abhabhombele aminza ababa bhetu na hwizushe ipatano lyakwe izelu, ");
INSERT INTO sbk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ishilapo shalapiye Ibrahimu uyise wetu. ");
INSERT INTO sbk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Afwanaje anzatavwilizya ate taushe nimakhono gabhibhi bhetu na humpute bila woga. ");
INSERT INTO sbk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nazelu nelyoli hwitagalilo lyakwe ensiku zyonti. ");
INSERT INTO sbk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nawe, womwana wahwetwa, ukuwe ukuwe wakwe yalimwanya, afwaneje awa wayitangulila hwita galila humaso ega GOSI ulenga nyizizye amadala gakwe, ");
INSERT INTO sbk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Obhabhozye abhantu bhakwa usatule aje asajilwe embibhi zyabho. ");
INSERT INTO sbk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hwidala elye rehema lya NGOLOBHE wetu, afwatanaje hwezyo okhozyo lwalufumile amwanya lutifishiye, ");
INSERT INTO sbk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Abhakhozye bhabhakhala hukisi hunzunda eyenfwa. nagalongozwa unamana getu hwidala ilinza.” ");
INSERT INTO sbk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ula, mwana wakula wonjelela amaha roho wakhala humapoli hata hwisiku elye fumila hwakwe u Israeli. ");
INSERT INTO sbk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Enku zila endajizyo zyafumile hwa Kaisari Agusto ya je esimbwe eye matawa aga bhantu wonti mnsi. ");
INSERT INTO sbk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hii ilikuwa ene ebabhe ya hwande yehasimbwilwe epo Krenio nali liwali wa hushamu. ");
INSERT INTO sbk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Abhantu wonti bhabhalile ahwinsimbisizye shila muntu amwao. ");
INSERT INTO sbk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","UYusufu wape asogoye hu galilaya afume hushijiji sha hu Nazareti azubhile abhale huu Yudea hadi humji ugwa Daudi, gukwiziwa Bethelehemu, afwatanaje umwahale wahutayari namwao abhahwa Daudi. ");
INSERT INTO sbk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ili asimbwe pandwemo no Mariamu, ushe wakwe bhapabhiliye wape ano lwanda. ");
INSERT INTO sbk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Shabha katika akhale ohwo ensiku zyakwe ezya pape zya fishile. ");
INSERT INTO sbk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wapapa umwana wakwe uwahwande, wavwenesya amenda agubha na wagonia mwitori mwanzilela eng'ombe, afwanaje sebhapete enafsi munyumba ezya jenyi. ");
INSERT INTO sbk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na ensi yeyela, bhahali adimi bhakhalaga mwipoli na linde ikundi lwao bhatandilunaga nosiku. ");
INSERT INTO sbk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Umalaika wa GOSI abhafumiye, nanali uzelu wa GOSI wabhakhozizye epande zyonti, bhinjilwa nowoga ogosi. ");
INSERT INTO sbk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Umalaika abhabholele, “Mganje ahigope, afanaje ane embaletela enongwa enyinza eya she engosi yayayibho hwabantu wonti. ");
INSERT INTO sbk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Eshe sanyono mnsi eya Daudi! apepwe kwa jili eyahulimwe uwataule wape yu Kristo GOSO! ");
INSERT INTO sbk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ene ndiyo ndago hwilimwe, mbhahu mwaje umwa umwela bhavwenesyezye amenda ageshiwela agonile mwitori mwelela eng'ombe. ");
INSERT INTO sbk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nantele bhahali pandwemo nayo omalaika abhinji ajeshi abhamwanya bhahutelela ONGOLOBHE, na ya je, ");
INSERT INTO sbk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ Ayemehwaje ONGOLOBHE amwanya, na pansi ehwe amani hwabhantu bhabhagalile.” ");
INSERT INTO sbk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Shabha, omalaika ebho na bhasogola abhule hwabho amwanya bhala udimi bhabholene, “Eshe sali mpaka Bethlehemu, tilirole elwo lwali bhombeshe lyati bhonezyezye ONGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bhabhalile nanali, bhamwanjile oMariamu no Yusufu, nola umwana umwela agonile mwitori. ");
INSERT INTO sbk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na walipomwona bhafumizye enongwa yabhabholelwe afwatone nomwana oyo. ");
INSERT INTO sbk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wonti bhabhahovwezye bhaswijile hwago gabhobholelwe na dimi. ");
INSERT INTO sbk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lelo o Mariamu wazibhaha humwoyo gwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhala adimi bhawelile ohu bhahusomba ONGOLOBHE na hutelile humombo gonti gabhovwezye na galale eshe shabhabholelwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hata nazyafishele ensiku nana ezya hutahiri ahetelwe tawa lwakwe Yesu, neshe nahetelwe no malaika sasele abhe lwanda. ");
INSERT INTO sbk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Alafu nazyafishele ensiku hwabho, neshe sheri endogo ya anusa bhabhalile nao mpaka Yerusalemu bhabheshele OGOSI. ");
INSERT INTO sbk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Neshe nshesibwilwe mdogo ya GOSI, “Shila mwana ulume wali lwanda ulwahwanda hwanyinawakwe akwiziwaje Golosu wa GOSI.” ");
INSERT INTO sbk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bhafumye sadaka neshe sheyajile katika endogo eya GOSI, “Enko nda bhabhele au makind abhenjebha bhabhele.” ");
INSERT INTO sbk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Enya, pala payerusalemu palinomntu itawa lyakwe akwiziwaga Simoni. Umuntu ono alihwelyoli na humpute ONGOLOBHE. Umwahole agolaga ya zizya wa Israeli, na upepo uzelu ali pamwana yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yali imalishe abhoneshewe hwakwe ahilile hupepo uzelu aje umwahale saga ehenzaga afwe bila hulole Kristi wa GOSI. ");
INSERT INTO sbk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Isikulimo ahenzele mhatimwibhaiza alongozehwe no pepo uzelu. ambapo ayise bhakwe bhaletile umwana oYesu hubhombele gala gagahanziwuga mkawaida eye ndogo, ");
INSERT INTO sbk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eshi o Simioni aposheye mmakhono gakwe na hulimbe ONGOLOBHE na yanje, ");
INSERT INTO sbk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Eshi nduhusu nemtumwa waho embale mshinza alengane nizu lyaho. ");
INSERT INTO sbk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Afwatanaje amaso gane gahalile uwaule waho, ");
INSERT INTO sbk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Afwanaje uonesha humaso gabhantu bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Umwahale rukhozyo mataifa na bhe zelu wabhantu bhakwe Israeli.” ");
INSERT INTO sbk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","UYise nonyine wakwe bhali bhaswiga ego gagayangwilwe juu yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","OSimoni wabhasaila abhabhola Mariamu unyina wakwe, “Eye ono abhehwelwe wagwe na bhoshe abhinji bhabali kati Israeli na bhe mbonesyo zyazya yiyangwa. ");
INSERT INTO sbk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nawe hwehwe imaje lwaijila humwoyo gwaho ilizibhoneshe esebho ezya moyo aga bhinji.” ");
INSERT INTO sbk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ahali ukuwa ushe itawa lyakwe Ana uledu wa Fanueli wa shikholo sha Asheri. Nu umri wakwe alina maha minji. Akheye nolume amaha saba baada eyelendu wakwe, ");
INSERT INTO sbk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wape fwele owemaha amarongo nane na mahaganne. Sasogolo mwibhanza ila aputa usiku no sanya na funje na labhe. ");
INSERT INTO sbk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oyo afumele sala yeyo asalifizye ONGOLOBHE. Na wonti bhali bhahwenyelezya eshahwaulwe katika Yerusalemu abhafumizyo enongwa zyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Basi nabhamala gonti gagalajiziwe aga mndongozi eya GOSi, bhahwelile hu Galilaya, mpaka iboma lwao, Nazareti. ");
INSERT INTO sbk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ola umwana wakula, na hwonjele amahaa amemile enshinshi, na neema ya NGOLOBHE yali juu yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Basi ayise bhakwe bhabhala hu Yerusalemu shila mwaha uwakati uweshikurukuru ya Pasaka. ");
INSERT INTO sbk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na fishiye umri wakwe amaha kumi na gabhle bhazubhile neshe sheli emila eye shikurukuru. ");
INSERT INTO sbk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nabhamalila ensiku wakati uwahwele hwabhoola umwana uYesu asageye hwisaro ohwo hu Yerusalemu na bhayise bhakwe sebhalolene. ");
INSERT INTO sbk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhape bhamenyeje bhalipandwemo mshora, bhabhalile enjendo uwisiku lyonti bhanda humwanza mwa mwabho. ");
INSERT INTO sbk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nu sebhamwanga bhahwelile hu Yerusalemu ohu bhahumwanza. ");
INSERT INTO sbk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yabha na zyafiha ensiku zitatu, bhalola mwibhinza, akheye pahati ya manyizi, abhatejelezya nabhabhozye amaswali. ");
INSERT INTO sbk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wape wonti bhabhamwovwaga bhanswijile uwelewa wakwe na amajibu gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na bhalolile, bhanswijile. Nonyina wakwe wabhola, “Mwana wane, mbone otibhombeye eshi? enye, uyise waho nane talili humwanza uzugumie” ");
INSERT INTO sbk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wabhabhola, “Yenu mnanza sagamwamenye aje ehwanziwa akhale munyumba eya yise wane? ");
INSERT INTO sbk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Unape sebhalyelewe izu elyo lyabha bhozezye. ");
INSERT INTO sbk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hwiho pandwemo nabho mpaka hu Nazareti wape ali abeshimu, onyina agabheshele ego gonti humwoyo gwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Wape uYesu wazidi ahwonjelele katika hekima kimo, wapendezya ONGOLOBHE na bhantu. ");
INSERT INTO sbk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Umwaha, ugwa kumi na tano owalongozye hwakwe Kaisari Tiberia, Pantio Pilato nali liwali owayahudi, na Herode omwene owa Galilaya, no Filipo oholo wakwe omwene uwa Iturea nensi eya Trakoniti, na Lisania no mwene owa Abilene, ");
INSERT INTO sbk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wakati owa kohani ogosi owa anasi no Kayafa, izu elya NGOLOBHE lya fishiye oYohana omwana owa Zakaria, mwipoli. ");
INSERT INTO sbk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Afishele mnsi yonti yelikaribu ne Yordani, alombeleye owoziwa owa lete usajilwa olwa hwefwe embibhi. ");
INSERT INTO sbk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Neshe shahwasimbilwe chuo eshe mazu aga kuwe Isaya, “Izu ya mntu wali mwipoli, “Lilenganyi idala elya GOSI, gagalosyaji omwashile hwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Entebha yonti yayimema nigamba nagamba hayisiwa, papatejile payibha pagoloshe papakwanyushe paile nganiha. ");
INSERT INTO sbk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bhonti abhebele bhayihulo owaule owa NGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Basi, abhabholele amabongano bhala bhabhaliye ili abhoziwe amwe mpapwo wenzoha wenu yabhasundile amwe ayinjile enkuni yehayenza? ");
INSERT INTO sbk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Basi fumyaje amadondo gagahwanziwa ulusajilo, wala mgajeahwanza ayanje mmoyo genyu, “Tilinawo udada uIbrahimu eshi embabhola yaje amawe ega, ONGOLOBHE abhajiye ahwubhosrzye uIbrahimu abhana. ");
INSERT INTO sbk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Neshi etwanga tayari ebhehwelwe pamashinshi age makwi. Basi, kila likwi lya sagalipapa amadondo aminza, lidumlwa nalitaje mmwoto. ");
INSERT INTO sbk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amabungano gabhozya, “Tikhozye wole eshi?” ");
INSERT INTO sbk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wabhajibu wabhabhozya, “Yali na magolola gabhele na apele yasaga aunigolola yali nevyalye wape abhombe eshoshesho.” ");
INSERT INTO sbk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bhabhasonjezya bhape bhenza ahwoziwe, bhabhozya,”Manyiziji, tubhombe yenu ate? ");
INSERT INTO sbk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wabhabhola, “Mgaje sonjezye ahantu zaidi ya hata hahapangwilwe. ");
INSERT INTO sbk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asikali bhape bhabhozya bhayanga, “ate nate tibhombe wele? Wabhabhole msafwele omntu wala msashitake ilenka antele myanje no mshahara gwenyu.” ");
INSERT INTO sbk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Basi, abhantu nabhali bhabhagola gaganzafumile, wonti bhasega sebhaga mmoyo gabho enongwa ezya Yohana nkashe umwene Kristi. ");
INSERT INTO sbk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","UYohana wagalula wabhabhozya bhonti lyoli ane embozya namenze lelo ahwenza ohwemaha ashile ane sembwezizye ayengezye olwabho olye vilato vyakwe. omwahale ayibhoziwa hupepo ozelu no mwoto. ");
INSERT INTO sbk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Afwanaje ubheto lwakwa lulimakho no wape ayozya tee mhati yakwe na bhonganye engano yakwe. Mshanga, antele amapetelo aigapemba mmwoto gwa sagaguzima. ");
INSERT INTO sbk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Basi hurusundo hugamwabho aminji, abhalombeleye abhantu. ");
INSERT INTO sbk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lelo omwene oHerode akhalipiwe nomwe kwajili ya Herode, ushe wa holo wakwe, namabhibhi gonti gabhombile o Herode. ");
INSERT INTO sbk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ahonjezye eli neli afunjile oyohani mwijela. ");
INSERT INTO sbk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bhabhantu wonti bhabhamaushe ahinziwe no Yesu wape ahoziwe wape alabhile emwanya zya higushe. ");
INSERT INTO sbk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Upepo uzelu ahishile pamwanya yakwe hufwano ongwebelebele, neshe enjebha izu lya fumile amwanya, “Awe wemwana wane wegene. Ensogwezewe nawe.” ");
INSERT INTO sbk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","No Yesu yoyo nahandile amanyizye, ali apate umri wakwe neshe amaha salathini. ategemelwa ajemwana wa Yusufu, wa Eli, ");
INSERT INTO sbk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Wo Mathati, walawi, wa MeIki, wayana wa Yusufu, ");
INSERT INTO sbk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Wa Matathia, wa Amosi, wa Nahumu, wa Esli, wa Nagai, ");
INSERT INTO sbk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wa Maati, wa Matathia, wa Semeini, wa Yusufu, wa Yuda, ");
INSERT INTO sbk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wa Yohana, wa Rese, wa Zerubabeli, wa SheaItieli, wa Neri, ");
INSERT INTO sbk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","MeIki, wa Adi, wa Kosamu, wa Elmadamu, wa Eri, ");
INSERT INTO sbk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Wa Yoshua, wa Eliezeri, wa Yorimu, wa Matathi, wa Lawi, ");
INSERT INTO sbk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Wa Simioni, wa Yuda, wa Yusufu, wa Yonamu, wa Eliyakimu, ");
INSERT INTO sbk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Wa Melea, wa Mena, wa Matatha, wa nathani, wa Daudi, ");
INSERT INTO sbk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Wa Yese, wa Obedi, wa Boazi wa Salmoni, wa Nashoni, ");
INSERT INTO sbk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Wa Abinadabu, wa Aramu, wa Hesroni, wa Peresi, wa Yuda, ");
INSERT INTO sbk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Wa Yakobo, wa Isaka, wa Ibrahimu, wa Tera, wa Nahori, ");
INSERT INTO sbk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wa Seruig, wa Ragau, wa Pelegi, wa Eberi, wa Sala, ");
INSERT INTO sbk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Wa Kenani, wa Arfaksadi, wa Shemu, wa Nuhu, wa Lameki, ");
INSERT INTO sbk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Wa Methusela, wa Henoko, wa Yaredi, wa Mahalalei, wa Kenani, ");
INSERT INTO sbk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Wa Enoshi, wa Sethi, wa Adamu, wa NGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","UYesu amemile upepo uzelu, ahwelile afume hu Yordani, alongoziwe no pepo omuda ohwe nsiku arobaini mwipoli. ");
INSERT INTO sbk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Apete amalabha no shetani. Nensiku ezyo sagalyanga ahantu mpaka nazyamalishe alolile enzala. ");
INSERT INTO sbk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Oshetani wabholankoli, “Mwana wa NGOLOBHE, libhole ihwe eli wahe libumnga.” ");
INSERT INTO sbk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","UYesu agalula, “isimbwilwe: 'eyaje umntu sagaikhala hwibumunda tu.'” ");
INSERT INTO sbk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wizavwa pamwanya wabhonesya emilki zyonti ezyensi hudaka emo. ");
INSERT INTO sbk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Oshetani wabhola, “Embahupele ahweenzi ene yonti, nefahari yakwe. Afanaje ehweli makhono gane, nane ehupele yayonti neshe shensongwele. ");
INSERT INTO sbk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Basi ahwe nkoni namile hwitagalila lyane gonti ganzabhe gahuliwe.” ");
INSERT INTO sbk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","UYesu wagalula wabhola isimbwilwe, “omwinamile, “OGOSI ONGOLOBHE waho ompute omwahale mwene.” ");
INSERT INTO sbk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Walongozya mpaka Yerusalemu wabheha pamwanya yemnala eshe shibhanza,” wabhola nkashile olimwana wa NGOLOBHE hwiponye pasi. ");
INSERT INTO sbk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","afwanaje esimbwilwe”, abhahwu lajizizye amalaika bhakwe bhalinde, ");
INSERT INTO sbk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na fwanaje, makhono gabho bhanzahumweje, osije ogabomula inama, lwaho mwiwe.” ");
INSERT INTO sbk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","OYesu wagalula, “Wabhashole, “eyagwilwe oganje hulenje GOSI ONGOLOBHE waho.” ");
INSERT INTO sbk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Basi nawamala kila esha hulenje oshetani walehe wabhala humuda. ");
INSERT INTO sbk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","OYesu awelile humaha age opepo ozelu, wabhala hu Galilaya enongwa zyakwe zyazyambanile ensi zyonti ezya msheje msheje. ");
INSERT INTO sbk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wape asambelezyaga katika mmabhanza gabho ashimihwagwa nabhantu bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wabhala hu Nazareti, epo pasongwelwe na isiku elye lutozyo hwinjila mwabhonza neshe sehali edeesturi yakwe wemelela ili abhazye. ");
INSERT INTO sbk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bhapela chuo esha akuwa Isaya, hwigula echuo, wanza papa simbwilwe, ");
INSERT INTO sbk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Opepo owa GOSI au pamwanya yane afwatanaje amponyizye amafuta abhalombelele apena enongwa enyinza, antumile abhatangazizye bhabhapi nyilwe abhaule hwabho. Avipofu bhalolaje nantele abhaleshe bhashe huru bhabhabhonelwe. ");
INSERT INTO sbk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na tangazya omwaha ogwa GOSI gwagweteshehwe. ");
INSERT INTO sbk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Washigalilo echuo, wahwezezya amtumishi wakhala, na bhantu bhonti bhabhahali mwisinagogi bhalangulila. ");
INSERT INTO sbk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wanda abhabhole sanyono ensimbo,”Ezi zitimiliye mmakutu genyu.” ");
INSERT INTO sbk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bhalola bhonti bhaswiga amazu age neema gagafumile mwilomu lyakwe, bhayanga ono semwana wa Yusufu? ");
INSERT INTO sbk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Abhabhola, “bila shaka mbhambole eshilale eshi,” Ganga, hwiponye omwoyo gwaho, amambo gonti gatovwezye aje gabhombeshe hu Kapernaumu, gabhombeshe nepa na ntele katika ensi yaho wewe.” ");
INSERT INTO sbk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wayanga, “Amina embabhola aje nomo okuwa yabhahweteshewe mnsi ya kwa yoyo,” ");
INSERT INTO sbk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lelo lyoli embabhola bhahali afwele bhalibhinji katika ensi eya Israeli amaha aga Eliya, wakati amabhengo gafugwilwe amaha gatatu na miezi sita, enzala engosi yahinjiye ensi yonti. ");
INSERT INTO sbk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wala oEliya sagasontezyewe hwebho, ila hwafwele omo owa Sarepta katika ensi eya Sidoni. ");
INSERT INTO sbk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Antele, bhahali abheukoma bhinji mwi Israeli omwaha wa kuwa Elisha, wala nomo yaponi ila oNaamani omntu wa Siria. ");
INSERT INTO sbk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhamemile ilyoyo bhonti bhabhahali mwibhanza nabhovwa ego. ");
INSERT INTO sbk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bhasogola bhafumya hwonze eye boma bhantwala mpaka mshenje eyigamba, afanaje ekhaya yao enzegwilwe pamwanya yakwe, ili bhapate hutaje pansi. ");
INSERT INTO sbk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lelo omwahale ashilile pahati yao wabhola. ");
INSERT INTO sbk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hwiha mpaka hu Kaeernaumu, iboma elya Galilaya. Wabha asambelezwa isiku elya tunzye. ");
INSERT INTO sbk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bhanswiga nantele hunsambelezyo zyakwe, afwanaje izu lyakwe lili namaha. ");
INSERT INTO sbk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na mhati mwibhanza, mwoli omntu yali ne roho embibhi walila hwizu igosi, ");
INSERT INTO sbk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ Wayanga leha, endineye awe, u Yese wa Nazareti? uyenzele atitezye? Emenye aje hwewenu! wogolosu wa NGOLOBHE!” ");
INSERT INTO sbk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","QYesu wadamila, “Wayanga, biba ilomu mwepe ndipo lila!”Ipepo lya gwisya pahati, lyafuma asimbhombe nkahamo. ");
INSERT INTO sbk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bhakhatwa naswije bhont, bhayangana, bhayanga lizu hwele eli, afwatanaje, “abhatanga amapepo abhibhi huwezo na maha bhape bhafuma.” ");
INSERT INTO sbk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Enongwa, zyakwe zyazyambona hwonti munsi ela. ");
INSERT INTO sbk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wafuma mwibhanza winjila munyumba ya Simoni. Wape, okhoi wakwe oSimoni onyina washe wakwe, akhetwe nensugusa ekhali bhalabha kwajili yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hwemelela, papepe nao, waidamila ela ensugasa, yaleha mara eyo wapona wabhabhombela. ");
INSERT INTO sbk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na isanya nalya swanga, wonti bhali nabhinu abhe mpongo shahashaha bhabhaletile hwamwahale. Wabhabheha amakhon gakwe pamwanya ya shila mntu wabhaponia. ");
INSERT INTO sbk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ipepo bhape bhafumela mwabhantu abhinji bhakhoma ibwago nayanje, “Awe uli mwana wa NGOLOBHE!” Wabhadamila sagaleshile aje bhayangaje, kwasababu bhamanye aje yo Krisi. ");
INSERT INTO sbk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na hwasha, asogoye abhalile humo hwasehulina bhantu. Amabongano bhabha bhahumwanza bhafihahwamurahale bhazaga huzubhile agajesogola hwabhahale. ");
INSERT INTO sbk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wabhabhola, “Ehwanziwa alombelele enongwa enyinza ezya mwene uwa NGOLOBHE katika amaboma agamwabho nantele, afwanaje ensotelezewe. ");
INSERT INTO sbk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","“Basi ali alombelela katika amabhanza aga hu Uyahudi. ");
INSERT INTO sbk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yabha amabongono bhasonshezya alitejelezye izu elya NGOLOBHE, omwahule ali ayemeleye panshenje eye eyi dimi lya Genezareti. ");
INSERT INTO sbk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Walola evyelelo vibhele vikheye panshenje eyi dimi. Lelo bhabhahwonza bhafumile bhahwozya enyavu zyabho. ");
INSERT INTO sbk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Winjila mshelelo shimo, esho shakwe oSimoni, wamwanza ashibhesha hutali hashe neshe. Wakhala wabhamanyinzya mambongano ohu alimshelelo. ");
INSERT INTO sbk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hata nawamala ayanje, abholile oSimoni, “Isya mpaka pansi tee mwisye enyavuzyenyu mwonze esamaki.” ");
INSERT INTO sbk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","OSimoni wagalula wabhola, Gosi, tibhombile embombo eyalisye nosiku wonti setipete nkahamo, lelo hwizu lyaho ehwisya enyavu. ");
INSERT INTO sbk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Basi nabhabhomba esho bhazyajile esamaki ziminji tee enyavu zyao zya hundile adumushe. ");
INSERT INTO sbk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bhabhapunjila okhono amwabho bhali mshombo esha bhele. bhenze abhavwe bhenzu bhavimemya vyonti vibhele hata nyahandile andwine. ");
INSERT INTO sbk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","OSimoni oPetro, na walola ego, agwiye pamafugamo ga Yesuwanyanga sogala hwiline, “Afwatanaj, ane endi mntu uwembibhi GOSI.” ");
INSERT INTO sbk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Afwanaje akhetwe nenswigo, umwahale nabhonti bhabhali pa ndwemo nawo kwa sababu eyewinji uwesamaki wabhazyajili. ");
INSERT INTO sbk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Antele Yakobo no Yohana bha Zebedao, bhali pandwemo no Simoni. O Yesu wabhola Simoni, “ogaje hwogope, afume eshi obhabha wahwonza abhantu.” ");
INSERT INTO sbk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hata nabhali bhavisagamishe pwani, evyelelo vyabho bhavileha vionti bhabhenjelela. ");
INSERT INTO sbk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yabha nahali humiongo ye maboma gala enya, palinomntu amemile ukoma, wape nawalola oYesu, agwiye dumbula walabha waga, GOSI,” nkohwanza owezizye anozye.” ");
INSERT INTO sbk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kisha Yesu alinyoosha mkono wake na kumugusa, akisema, “Nataka. Takasika.” Na saa ileile ukoma ukamwacha. ");
INSERT INTO sbk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","“Wakhana agaje hubhole omuntu, ila bhalaga ahwibhonesya hwa kohani, “ufumye, kwajili eya pone hwaho neshe oMusa shabhabholele ebhe ushuda, hwabhahale.” ");
INSERT INTO sbk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lelo enongwa zyakwa zyazida abwaje bhatangene amabongono aminji bhatejelezye na pone empungo zyabho. ");
INSERT INTO sbk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ilelo omwahale ali ahwiyefwa wabhala pasepali bhantu walabha. ");
INSERT INTO sbk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yabha isiku lila limo ali asambelezya na amafarisayo na amanyizi abhe ndongo bhali bhakheye epo, bhabhafumile kila shijiji eshe Galilaya na Yudea, na hu Yerusalemu. Na amaha aga GOSI wahali apate aponie. ");
INSERT INTO sbk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na enya, bhenza abhantu bhanyatiye mshitanda omntu yapoozile, bhahanzaga hutwale mhati na hubheshe hwitagalila lyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hata nabhakosile enafsi eyahutwale mhati kwali eya mabungano ege bhantu bhazubhile hwigolo bhagefwa amatofali agapamwanya bhaswisya umwahale neshi tande shakwe pahati hwitagalila hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wape nalolile olweteho lwabho abhhdde, “Ee rafiki, usajilwe embibhi zyaho.” ");
INSERT INTO sbk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Basi bhala asimbi na Mafarisayo bhada ayangane, “Aje wenu ono yayanga amazu agalije? Wenu yagasajila embibhi aliyo NGOLOBHE mwene?” ");
INSERT INTO sbk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na o Yesu, omenye onongwa zyabho wabhagalula wabhabhole, mhwibhozya yenu lumoyo genu? ");
INSERT INTO sbk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lyalili lyalolo lyalilihu, 'Aje usajilwe embibhi zyaho au aje sogola ubhale?' ");
INSERT INTO sbk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lelo mpate amanye aje omwana wa Adamu anazyo endajizo pansi epa ezya sajile embibhi, abholele, 'Ola ya poozile sogolahwitweshe eshitanda shaho bhalaga akhaya yaho.' ");
INSERT INTO sbk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Shesho wemelela hwitagalila lyabho wahwitwehe shhila shagoneye wabhala akhaya yakwe ohwo wa mwembela ONGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wonti bhakhetwa na nswije bhateleye ONGOLOBHE. Bhamemele nowoga, bhayanga, “Sanyono tilolile amambo age ajabu.” ");
INSERT INTO sbk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baada yego wafuma walola yasonjezya esonga, itawa lyakwe yolawi akheye forodhani, wabhola nbejezye.” ");
INSERT INTO sbk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Walehe vyonti wasogola wabheni ezya. ");
INSERT INTO sbk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Lawi wabhombela eshikurunkuru eshigosi mnyumba yakwe hwali abungono ogosi, owa sonjezye esonga na bhuntu abhamwabho bhali bhakheye pashalye pandwemo nawo. ");
INSERT INTO sbk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yabha afarisayo na simbi bhabho bhabha bhabha una asambilizi wa bhakwe baje mbona mlyana mwele pandwemo nabhabhasonjezya esonga na bhubhali nembibhi?” ");
INSERT INTO sbk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","OYesu agalula wabhabhola, “Bhabhali bhinza sebhani nehaja eyaponywe, ila bhala bhabhinile. ");
INSERT INTO sbk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Senahenzele abhakwinzye abhelyoli bali bhahali nembibhi bhapato alambe.” ");
INSERT INTO sbk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bhape bhabhola, “Asambelewa abha Yohana bhafunga maranyinji, na labhe eputo bhpe asambelewa abha Farisayo bhafunga. Lelo asambelewa bhaho bhalya nu mwele.” ");
INSERT INTO sbk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","LelooYesu abhubholele, “Mwagaga mgabhabhambo aje bhafunje bhabha anilye huhweji wakati ahweli ogosi owehweji pandwemo nao? ");
INSERT INTO sbk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lelo ennsiku zihwenza nayepe ogosi owehweje epo pabha ifunga ensiku ezyo.” ");
INSERT INTO sbk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wabhabhola eshilale. “Nomo yazembula shilakaeshi omwenda opya nabheshe mmwenda okolo na nkashile abheshele lila ipya. Na shila ishiraka sha omwenda opya, selilenganya na gula omwenda okolo. ");
INSERT INTO sbk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wala, nomo omntu yaponya edivai empya katika evyelelo evikolo. Na nkashile waponya ela, edivai empya ebha vibazule vila evyenlelo, edivai enyahale ebhahwitishe na vyelelo nibhanachishe. ");
INSERT INTO sbk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lelo edivai epya uwinza uwaponye katika evye lelo evipya. ");
INSERT INTO sbk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wala nomo yamwela edivai eyemwaha alafu ayisongwe epya, atafanaje ayanga ela eya mwaha, 'Yenyiza.” ");
INSERT INTO sbk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lyabha isiku elyatozye limo ali ashila katika mmagonda, asambelezyewabhakwe bhali bhadenya amasale na galye bhabhabhapalula mmakhono gabho. ");
INSERT INTO sbk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Basi bhamo afarisayo bhabhabholo, “Mbona mbhomba lya selinza isiku elyatozye”? ");
INSERT INTO sbk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","OYesu, wabhagalula, wabhabhola, “Semwabhazizye hata lwelyo lyabhomile oDaudi nali nenzala, omwahale na bhala bhali nabho? ");
INSERT INTO sbk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jinsi shahinjiye katika enyumba eye NGOLOBHE, wega amabumunda gala agalanjizye wagalya, wabhapela nebho amwabho wakati seshinza agalye ila hwa Kuhani bene basi.” ");
INSERT INTO sbk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wabhabhola, “Amwana uwa Adamu yayoyo OGOSI owa tofye.” ");
INSERT INTO sbk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yabha isiku elyatozye elyamwabho ahinjiye mwisingogi wamanyizya na mwali omntu ambaye okho. Ogwakwe ogwendelo upozile. ");
INSERT INTO sbk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na simbi na bhafarisayo bhali bhauzijila ili balole aje abhaponie isiku elyatozye, li bhazyaje enongwa zyautake. ");
INSERT INTO sbk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lelo omwahale wagamanya gabhasebha wabhola ola yapoozile okhono, “Sogola, emelela pahati wasogola.”wemelela. ");
INSERT INTO sbk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eshi OYesu wabhabhola, “Embabozya amwe eshi, shinza isiku elyatozya abhombe aminza au abhombe amabhibhi, aponie omwoyo au atezye, ");
INSERT INTO sbk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","“Walangulila amaso wonti.”Epande zyonti wabhola ola omntu, golozya okhono gwaho wagolozya akhono gwakwe gwabha gwinza natele. ");
INSERT INTO sbk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lelo bhamemile nenkuni bhaynyana bhebho hwa bhebho bhabhombe we le Oyesu. ");
INSERT INTO sbk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yali ensiku zila asogoye abhalile mwigamba ili alabha. Ahendeleye osiku wonti hulabhe ONGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nayali sampwiti, abhakwizizye asambelezewe bhakwe, hwumwahale na abhasaluye kumi na bhabhele kati yabho bhebho nantele abhakwizizye “Bhamwa.” ");
INSERT INTO sbk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Amatawa gabhala atumwa gali oSimioni (ambaye antele akwizizye yo Petro) no Andrea no holo wakwe, oYakobo, oYohana, oFilipo, oBartolomayo, ");
INSERT INTO sbk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","OMathayo, oTomaso, no Yakobo omwa wa Alfayo, oSimioni, ola okwiziwaga yo Zelote, ");
INSERT INTO sbk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","OYuda omwana wa Yakobo na oYuda oIskariote, ola yali goji. ");
INSERT INTO sbk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nantele oYesu ahishile pandwemo nabho afume hwigamba na hwemelele papali ntebha. Idadi engosi eyasambelezewa bhakwe (walikuwa huko, pamoja naidadi kubwa ya watu kutoka Uyahudi na Yerusalemu, na kutoka pwani ya Tiro na Sidoni.) ");
INSERT INTO sbk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na bhala bhabhalebhile ni mpepo embibhi. Bhaponizye. ");
INSERT INTO sbk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Shila omo bhabhali pibhongano arenjele hu palamasye afwatanaje nguvu ezyaponye zyali zifuma mhati yakwe na aponizye bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Esho wabhenya amnyiziwa bhakwe, na yanje, “Msayilwe amwe mwemli bhapene, afwatanaje umwene owa NGOLOBHE wenyu. ");
INSERT INTO sbk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Msayilwe amwe mwemli nenzala eshi, afwanaje mwakuta msayilwe mwemlila eshi. Afwanaje mwayiseha. ");
INSERT INTO sbk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Msayilwe amwe ambao abhantu na yibhavitwa na bhahagule na bhalongonye amwe aje mlibhabhibhi kwajili ya omwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Shanji katika isiku elyo na rushe rushe nashe afwatanaje lyoli mwayibha ne thawabu egosi amwanya, afwanaje aise bhabho bhabhabhombeye shesho akuwa. ");
INSERT INTO sbk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lelo hele amwe mwemli bhatakili! Afwatanaje mmalishe ahweje ensombo zyenyu. ");
INSERT INTO sbk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aheli amwe mwemkute eshi! afwanaje mwayilola enzala hwitagalila. Aheli amwe mwemseha eshi! Afwanaje mwayizonda naline hwitagalila. ");
INSERT INTO sbk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aheli amwe, na mwasombwa nabhantu wonti! Afwanaje aYise bhabho bhabhabhombeye akuwa abhilenka shesha. ");
INSERT INTO sbk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lelo eyanga hwilimwe amwe mwemn tejelezya, bhagani abhibhi bhenyu na bhabhombele aminza bhabhavitwa. ");
INSERT INTO sbk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bhasayilaji bhala bhabhaswita amwena bhalabhilaji bhala bhabhabonela. ");
INSERT INTO sbk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hwamwahale ola yahukhoma imbuguzi limo, ugalusizyaje elyabhele. Neshe omntu ahufyola igolole lyaho opanje nelyabhele. ");
INSERT INTO sbk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Opanje shila ya hulabha. Neshe omntu nkahufyola ahantu ambaho hahuliwe uganje alabha aje awezyezye. ");
INSERT INTO sbk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nenshe samsongwa abhantu aje sabhabhabhombele, namwe mubhombaje shesho. ");
INSERT INTO sbk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nkashe mubhaganaabhantu bhabhaibhaga na amwe tu, esho ihawobu shi hwilimwe? Afwanaje hata bhabhibhi bhabha gana bhala bhabhagana. ");
INSERT INTO sbk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nkashile mubhabhombela bhala bhabhabhombela amwe aminza esho abhabhe thawabu nshi hwilimwe? Afwanaje hata bhabhibhi bhabhombashesho. ");
INSERT INTO sbk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nkashile mkhopezya evintu hwabhantu ambabho mpambamala aje bhanza abhawezyezye, eyo thawabu ushi hwilimwe? Hata bhabhibhi bhabhakhopela abhibhi, na bhapambamala ahwejelele kiasi shesho nantele. ");
INSERT INTO sbk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lelo bhagani abhibhi bhenyu na bhabhombele aminza. Bhakhopelaji mgaje ahogepe ahusu awezyewe, na ethawabu yenyu yayibha ngosi. Mwaibha bhana abha yalimwanya afwanaje, umwahale yoyo mwinza hwabhantu bhasebhali nesombe. ");
INSERT INTO sbk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bhanji no lusajilo, neshe oYise hwenyu shali no lusajilo. ");
INSERT INTO sbk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mganje alonje, namwe semwayilongwa. Mgajerani, namwe semwayilaniwa. Sajilaji, namwe mwajisajilwa. ");
INSERT INTO sbk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bhapanji abhanje, namwe mwaipewa. Ekias eshe pyana - shashidinyiliwe, na tabhetabha na hwitishe hwitishe - mmafugamo genyu. Afwanaje eshi pimo sheshonti shamtumila, apimile shesho shayitumiha abhapimile amwe.” ");
INSERT INTO sbk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Antele wabhabhola ofano. “Aje omntu yali shinsinzilu agalongozya ohwenje yali shinsinzilu? Nkashile bhabhombile esho, bas wonti bhaga dumbushila, mwilende? ");
INSERT INTO sbk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yasambelela sabha gosi ashile ya bhasambelezya, lelo shila mntu nkawasambelewa shinza abhaneshe osambelezi wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yenu bas nkabhenye ahantu hahali mhati mwiliso elya holo waho, na ahantu hali mhati ya mwiliso lyaho sohwenya? ");
INSERT INTO sbk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Obhahubhole hwele oholo waho, 'Holo, ehulabha enefwe ahantu hahali mhati yeliso lyaho,'nawe sohwenya aantu hahali mwiliso lyaho wewe? Olinafiki awe! Ahwande oyefwe ahantu mwiliso awe, ndipo nkobhalole shinza ahwefwe ahantu mwiliso elya holo waho. ");
INSERT INTO sbk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Afwanaje nalimo ikwi ilinza lyalipa amadonda amabhibhi, antele nalimo ikwi ibhibhi lyalipapa amadondo aminza. ");
INSERT INTO sbk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Afwanaje shila likwi limanyiha humadondo gakwe. Afwanaje abhantu sebhayabhila etini afume mumivwa, antele sebhayabhila ezabibu afume mmichongoma. ");
INSERT INTO sbk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omntu omwinza alishanga eshinza humwoyo gwakwe afumya gagaliminza, na omntu obhibhi alishanga eshibhibhi humwoyo gwakwe gafuma gagali mabhibhi. Afwanaje ilomu lyakwe liyanga gala gagamemile humwoyo gwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yenu mnkwizya,'GOSI, GOSI', antele semgabhomba gala gegyanga? ");
INSERT INTO sbk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Shilo mntu yahwenza hwiline na zyovwe enongwa zyane na bhombele embombo embabhalanje ejinsi shahweli. ");
INSERT INTO sbk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Alengana no mntu yazenga enyumba yakwe, omwahale abana pansi, tee nazenje omsingi owenyumba pamwanya eyemwala imara. Amakoshi nagahenzele, na majenje agemenze gaikhomile enyumba, lelo segayizizye afwanaje yaze dwilwe shinza. ");
INSERT INTO sbk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lelo yayonti yahwovwa enongwa zyane sazitii; ofwano gwakwe yayola omntu yozenga enyumba pamwanya ma masanga pasepaliomsingi, amakoshi nagahishile humaha, enyumba ela yaseadilwe yonti. ");
INSERT INTO sbk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nawamala onongwa zyakwe zyonti mmakutu gabhantu ahinjiye, hupapernaumu. ");
INSERT INTO sbk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na obhambhambo wakwe oakida, omo ali bhinu tee alipapepe nefwa, wape alimntu yagene tee. ");
INSERT INTO sbk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nahovwezye enongwa ezye Yesu, asonte zyezye agosi abhayahudi, hwamwahale hulabhe aje aponie obhombambombo wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bhope nabhafishile hwa Yesu, bhalabhile tee bhajile abhajiye, “Ono ombombele anongwa ezi, ");
INSERT INTO sbk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Afanaje aligene itaifa lyetu, wape atizenjeye isinagogi.” ");
INSERT INTO sbk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Basi oYesu abhalile pandwemo. Nabho nasagalihutali nenyumba, eyola oakida asontezyezye orafiki hwamwahale wabhola. 'GOSI, ogaje ahwiluvye afwanaje ane sefaa aje ewe oyinjile pansi pigalo lyane. ");
INSERT INTO sbk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eshi ehwilolile aje sefaa nene ahwinze hwaho, lelo panga izu tu obhombambo wane abhapone. ");
INSERT INTO sbk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Afwanaje nane endi muntu nembehwelwe pansi eye ulongozi, endina sikari pansi yane, nkebholele ono bhala abhala na ono “enza” ahwenza, na obhomba mbombo, “Wane” bhomba eshi, abhomba.” ");
INSERT INTO sbk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","OYesu namwovwa ego aswijire, wagugalushila, obngano gwagwabhinjelelaga wanyaga.” Embabhola, hata bha Israeli, sendilolile olyweteho ogosi neshe olu. ");
INSERT INTO sbk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na bhala bhabhatumwilyu nabhahwela okhaya bhamwaga ola obhombambombo mwinza. ");
INSERT INTO sbk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Napamande hashe, abhalile hwiboma limo lyakwiwaga Naini. Asambelezye wa bhakwe bhabhenjelezenye nalwo pandwemo no bongona ogosi. ");
INSERT INTO sbk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nawafiha apalamile nolwango ogwi boma eye, omntu yafyiye au anyetulwe, na mwana weka hwa nyina wakwe. Yali fwele, na mabungano wabhantu afume hwiboma bhali pandwemo nawo. ");
INSERT INTO sbk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","GOSI nawalola aloleye husajile wabhala, “Laha lile.” ");
INSERT INTO sbk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wasojela walipalamasya ijeneza bhala bhabanyetuye bhahemeleye, wayanga sahala ehubhala “imelela” ");
INSERT INTO sbk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ola ofwe wemelela. Wakhala wanda aje wapela onyina wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Owoga wabhakhata wonti. Bhasomba ONGOLOBHE bhayanga okuwa “OGOSI afumiye hwilite” na “ONGOLOBHE abhenyizye abhantu bhakwe” ");
INSERT INTO sbk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Enogwa zyakwe ezi zyazyambanile huyudea hwonti na ensi zyonti zyazili mshe mshe. ");
INSERT INTO sbk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Asambelezyewa abha Yohana bhaletela enogwa zyego gonti. ");
INSERT INTO sbk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Esho oYohana wabhakwizya bhabhele asombeleziwa bhakwe wabhasondelezya hwa Yesu abhozye “Awe wewe ola yayenza, au timwenyelezyaje owenje? ");
INSERT INTO sbk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wape nabhafiha hwamwahale bhayanjile, “oYohana ya hwozya atisondezyezye hwiliwe aganjile aje awe, 'Wewe ola yahwenza au timwenyelezyaje owenje?” ");
INSERT INTO sbk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ne sala yeyo abhaponizye abhinji abhinu bhabho na efwa, eye mpepo embibhi, na avipofu abhinji bhalolile. ");
INSERT INTO sbk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eshi nkawagalula. Wabhabhola, bhalaji mubhale oYohana ega gamgalolilena govwe. avipofu bhalola alema bhajenda, abheukoma bhapona, adinda makutu bhahwovwa, bhabhafwiye bhazyoba, apena bhalombelelwa enongwa enyinza. ");
INSERT INTO sbk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wape heri omntu yeyonti yasavisiwa nane.” ");
INSERT INTO sbk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Basi eshi asontelezewe bha Yohana na bhasogola, ahandile abhabhole amabongono enongwa ezya Yohana, “Mwafumile abhale mwipoli ahwenye yenu, isole wauyiziwa nehala? ");
INSERT INTO sbk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eshi mwafumile abhale ahwenye yenu, omntu yakwatiziwe amenda aminza? mmanye abhantu bhabhali namwenda ageu tukufu bhabhalya raha bhali mnyumba ezye shimwene. ");
INSERT INTO sbk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eshi mwafumile abhale ahwegegenu okuwa, Antele? Embabhole, na yali zaidi ya okuwa. ");
INSERT INTO sbk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Oyo yayo asimbiliwa, “Ega, enya ehusontelezya ojumbe wane hwitagalila elye maso gaho, yabhalenganya idala lyaho hwitagalila lyaho, ");
INSERT INTO sbk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nane embabhola, neshi bhala bhapepwe na bhashe, nomo yaligosi neshe oYohana, lelo yalidodo humwene owa NGOLOBHE GOSI ashile omwene.” ");
INSERT INTO sbk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Abhantu bhonti bhabhasonjezya esonga nabhahovwezye ego bhaheteshe, elyoli ya NGOLOBHE afwanaje bhoziwe. Huwoziwa uYohana. ");
INSERT INTO sbk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lelo abhafarisayo na bhana sheria bhali khene isunde elya NGOLOBHEhwabhene afwanaje sebhohoziwe nomwene. ");
INSERT INTO sbk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","OGOSI wayanga embalenganisye neye abhantu abheshikho eshi? bhape bhalengene neyenu? ");
INSERT INTO sbk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhalengene nabhana bhakheye pasokoni, na kwizanye nabhayanga, 'tabhakhomeye efilimbi antele semwahanjile, tazondile antele semwalilile.' ");
INSERT INTO sbk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Afwanaje oYohana owahozye ahenzele salya ibumnda wala samwela divai, namwa myanga myiga “Ano pepo obhibhi. ");
INSERT INTO sbk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Omwana owa Adamu ayenzile alya na mwele, namwe myanga, enye, lyavi ono, na mwezi owe divai, rafiki wabho asonjezya! ");
INSERT INTO sbk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Neshinshi ebhoneshe aje elinelyoli hwabhana bhakwe bhonti.” ");
INSERT INTO sbk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Omntu omo owa mafarisayo amwanile alye eshalye hwamwene. Winjila mnyumba yakwe ofarisayo, wakhala pashalye. ");
INSERT INTO sbk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Enya oshe omo owiboma lila wali wemabhibhi. Nazyoyile enongwa aje akheye pashalye panyumba eyola ofarisayo, aletile insupa marimari yeli nemaruhamu. ");
INSERT INTO sbk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wemelela hwisalo papepe na manama gakwe nawalila. Wanda hulagazizye mmagaga gakwe amansozi gakwe, na syomwole ni sisi elyamwitwe lyakwe, na humyante myante mmagaya gwakwe, na pashe gala amaruhamu. ");
INSERT INTO sbk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Basi ola ofarisayo yamwanile nawolola shila wanyanga humwoyo gwakwe, omntu ono khashile alikuwe, “Handamenye oshe ono yahupalamasyasya, wenu wape aliwelewele yaje wemabhibhi. ");
INSERT INTO sbk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","OYesu wagamla wabhozya, “Simoni endine nongwa mbahubhole. “Wayanga” “sambilizi yanga!” ");
INSERT INTO sbk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wayanga “Omntu omo yakhopezya alinabhe madeni bhabhele, omo adagaya ehela miatano nowabhele amsini. ");
INSERT INTO sbk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhape nabhali sebhalinahahuripe, abhasajiye wonti. bhabhele neshe bhabhele yo nanu yayihugana tee? ");
INSERT INTO sbk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni wagalula wayanga, “Amenyeje yayola yasajiye enyinji.” Wabhola oyamliye lyoli.” ");
INSERT INTO sbk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wagarushila ola oshe wabhola Simoni, “Walota oshe. Ono nahinjiye mnyumba yaho. Sohampiye amenze mmagagagane, eshi ono andayazyezye amansozi mmagagagane, na syomwole nisisi elya mwitwe lyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Awe sohanjayiye, lelo ono, awande pana hinjiye sagaleshile njayile tee mmagaga gane. ");
INSERT INTO sbk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sagapashile mwitwe lyane amafuta, eshi ono ampeshe amagaga gane amaruhamu. ");
INSERT INTO sbk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Afwanaje nago, ehubhozya asajiye embibhi zyekwe zyazyalinjili, afwanaje asongwezye tee. Lelo yasajilya hasheoyo asongwelye hashe.” ");
INSERT INTO sbk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eshi abholele oshe, “Osajilye embibhi zyaho zyonti” ");
INSERT INTO sbk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Esho bhala bhabhakheye pandwemo nawo bhahandile ayanje humoyo gabho wenu ono yasajilo embibhi?” ");
INSERT INTO sbk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wabhola ola oshe, “Olweteho lyaho lumwauye. Bhalaga hulweteho lwaho” ");
INSERT INTO sbk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yabha baada yego ali azyongola azyongola mmaboa namvijiji ali alombelela, na tungazye enongwa enyinza ezye umwene owa NGOLOBHE na bhala athenashara bhali pandwemo nawo, ");
INSERT INTO sbk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na abhashe bhamo bhamo bhali ne mpepo embibhi nepongo abhaponyizye bhape yo Mariamu yakwiziwa magdalena yazya fumile epepo saba. ");
INSERT INTO sbk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na Yohana oshe wa kuza owakili wakwe oHerode, Susana, na bhamwabho bhabhinji, bhabhatenganyaga huvintu vyao. ");
INSERT INTO sbk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ubungano ogosi na watangene, na bhala bhabha fumile shila liboma bhabhaliye ayanjile hufano. ");
INSERT INTO sbk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ompanzi afumile abhale atote embeyu, yakwe wape nali atota, zimo zyalagashiye papepe nidara, zyakhanyilye enyonyi. ");
INSERT INTO sbk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zimo zyalageye pamwalo na zyahandile amele zyahomele afwanaje zyaha kosa orutubo. ");
INSERT INTO sbk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zimo zyalageye mmivwa na amivwa gahamela pandwemo zyazyo ya zisonga. ");
INSERT INTO sbk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Zimo zyalageye pilongo elinza ayunga ego atatushe izu waganga yalinamakutu agahwovwa na ayovwaje.” ");
INSERT INTO sbk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abhanafunzi bhakwe bhabhozya yenu ene omafano ogwo, ");
INSERT INTO sbk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wayanga, “Amwe apewewe azimanye esiri ezya mwene ONGOLOBHE, eshe bhamo humfwano, aje nkabhenye bhaganje alole nankabhovwe bhagale amanye.' ");
INSERT INTO sbk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na ogwo omfano. Emana yakwe ya yene embeyBhala lizu lya ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bhala bhabhali papepe ni dala bhabhala bhahovwa, antele ahwenza oshetani alyefwa elyo izu mmoyo yaho, bhasibhe bhalyeteha na hwaulwe. ");
INSERT INTO sbk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na bhala abhapamwala bhabhala ambao nkabhovwa bhaliposhela lila izu sabhashiye, wape sebhana malandazi bhahweteha humda hashe, naufiha owa lengwe, bhahwibagula. ");
INSERT INTO sbk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zyazilagaliye pamivwa bhabhala bhabhovwenzwe, abhale hwabho bhosohwa ne shughuli no utabhazi na owalangani owemaisha ega, sebhatonia lyalyonti. ");
INSERT INTO sbk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na zila ezya pilongo elinza bhabala bhabhali no mwoyo ogwinza ogwa lyovwe izu, na likhate, esho lipapa amadondo esha jimbilizwe. ");
INSERT INTO sbk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nomo, omntu yahwasya, okhozyo na kwishile neshelelo. Au abheshe hwinzongo bali bhayibheha pamwanya pameza ili bhabhahwisya njila bhapataje alole okhizyo lwakwe. ");
INSERT INTO sbk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Afwanaje nalimo izu lyalyobhele lyasagalya yibhoneha, antele lyalyobhele elyaje selyayi manyiha na fumile hwelele. ");
INSERT INTO sbk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hwiyenyi basi enamna shamhovwa afwanaje yalinahantu. Abhapewe na ola, yasanahantu abhafyolwe atahala, habhoneha aje anaho.” ");
INSERT INTO sbk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bhabhalila onyina wakwe na holo bhakwe bhashindwa abhapapepe afanaje amabungano. ");
INSERT INTO sbk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bhatwalile enongwa wabhola, “Onyina waho na holo bhaho bhemeleye hwonze bhahwanza alolane nawe. ");
INSERT INTO sbk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wagalula, wayanga “omaye wane naholo bhane bhabhebha bhabhahovwa izu elya NGOLOBHE na bhombe.” ");
INSERT INTO sbk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yabha ensiku zila wapanda mshelelo omwahale na sambelezyewa bhakwe, wabhabhola, “Nantele tilo woshe hadi hwisyela eyeidimi. “Bhasogola na matanga. ");
INSERT INTO sbk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bhape nabhali bhabhala, agonile otulo, yahishile etofani pamwanya eyidimi, eshelelo shahandile ameme ameze bhabha mhatari. ");
INSERT INTO sbk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bhabhalila bhadamuzya bhaga, “GOSI wa gosi! GOSI wa gosi! litega wabhoha!” Waidamila ehala na vwadangana ameze hwaleha hwabha hwinza. ");
INSERT INTO sbk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wabhabhola, “Olweteho lyenyu lulihwi?” Bhogope, bhaswiga, bhayango bhebho hwa bhebho,”Yenu ene paka, adamila ehalana menze gape gahumwogopa?” ");
INSERT INTO sbk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bhafiha mpwani mnsi ya bha wa Gerasini ye paramila hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wape na hishile hupwani, atangene nomntu omo owe boma, ola yaline mpepo, sagakwete amenda ensiku zinyinji, antele sagakheye pakhaya ila hamagwela. ");
INSERT INTO sbk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nalolile oYesu akholile eholo, agwiye hwitagalila lyakwe. Waganga hwizu igosi endi neyenu nawe, Yesu womwana wa NGOLOBHE yalimwanya? Ehulabha, ugajendavye” ");
INSERT INTO sbk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Afanaje alidamiye lile ipepo ichafu limwepe omntu ola, afanaje apagewe wape mara nyinji, nantele bhalidaga mshifungo na apinyilye na manyolo ne mpengo, adumlaga gala amanyolo, ashembezyewaga mwipoli ne nguvu ezya lila ipepo. ");
INSERT INTO sbk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","OYesu wabhozya, “Itawa lyaho wewenu?” Wayanga, “Itawa lyane endijeshi” Afwanaje pepo bhinji bhamwinjiye. ");
INSERT INTO sbk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bhalabha asabhadamila aje bhafume abhale mwilende. ");
INSERT INTO sbk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eshi epo pali ikundi elye engorobhe enyinji bhadimazyaga mwigamba. Galabha agapele oruhusa ahwinjile zila, wagapele aruhusa. ");
INSERT INTO sbk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pepo bhafuma mwamntu ola bhinjila mgorobhe, lyape ikundi lyahishile mwigenge nanali, bhinjila mwidimi, bhafwa mmenze. ");
INSERT INTO sbk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Adimi nabhalola lyalifumiye bhashembeye na zyambanye enongwa hwiboma, na mavueni. ");
INSERT INTO sbk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Abhantu afumile abhale ahwenye gaga fumiye, bhabhalila oYesu bhalola omntu ola mwagafumile akwete amenda anenjele zyakwe, bhahogope. ");
INSERT INTO sbk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na bhala bhabhalolile bhabhabholele shasha hali shaponiziwe ola ya pageweni pepo. ");
INSERT INTO sbk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na mwabho abhantu abhensi ya bhagevasi yeli pasheje sheje bhalabhile aje asogole hwabhahale afwanaje bhali nowoga ogosi esho winjila mshelelo wawela. ");
INSERT INTO sbk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","No mntu ola yalya fumile ipepo alabhile oruhusa aje alondozyaje wape, lelo omwahale walaga wayanga, ");
INSERT INTO sbk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wela amwenyu arombelele gagali mago ONGOLOBHE gabhombeye”Abhala, alombelele iboma lyonti, shangali magosi amambo ga bhombelwe no Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Eshi oYesu namwawela, obongano gwa karibizizye, esha seshelele afwanaje bhali bhahugolela wonti. ");
INSERT INTO sbk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Enya omntu omo wenza itawa lya vwa yo yairo, wape mntu gosi owe shibhanza, wagwa pamagaga ga Yesu walabha iyinjile mnyumba yakwe, ");
INSERT INTO sbk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Afwanaje elendu wakwe abhinile tee apalamila afwe, afwanaje mwana weka mwene, oumri wakwe alinamaha kumi na gabhele, wakati abhala obungano gwasonjile. ");
INSERT INTO sbk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Noshe omo ambaye afumaga idanda omda ogwe maha kumi na gabhele, ali anankenye eshoma shakwe shonti abhapele aganga bila opone, nomntu yoyonti, ");
INSERT INTO sbk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Abhalile hwisalo lyakwe wapalamazya opindo ohwemwenda gwakwe, mara elyo afume hwkwe idanda hwapoma. ");
INSERT INTO sbk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","OYesu wayanga, “Wenu ya mpalamasyezye?” Basi abhantu bhonti nabhakhana oPetro abholele, GOSI mgosi, amabonyano ega gahuzyongala na husonje.” ");
INSERT INTO sbk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","OYesu wayanga, “Omntu ampalamasyezye, afwanaje elola aje amaha gafumile.” ");
INSERT INTO sbk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ola oshe nawalola yaje sawezizye ahwobhe wenza ayinga, wagwa hwilagalila lyakwe, wabhola hwitagalila elya bhantu bhonti esababu eyahupalamasye nasha ponile nantele. ");
INSERT INTO sbk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wabhola, “Rendu, olyeteho lwaho luponizye. Bhalaga umwe no lweteho.” ");
INSERT INTO sbk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nali ayangaga ego ahenzele, omntu afume hukhaya eya ola ogosi, owe shibhanza, “Wabhola orendu waho afwiye. Ogajehuyanzyosambelezi.” ");
INSERT INTO sbk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lelo oYesu nawovwa, ego, wagalula ugajebhe, “Nowoga. Ateha awe wape, abhapone.” ");
INSERT INTO sbk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nawafiha mnyumba, sagaleshile omntu aje ayinjile hata omo, ila oPetro, no Yohana no Yakobo, no Yise wole, omwana no nyina. ");
INSERT INTO sbk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na bhantu bhonti bhali bhalilaga na zonde, wayanga, “Majelile safwiye, ono, eshi aganile tulo wene.” ");
INSERT INTO sbk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bhaseshile tee, afanaje bhamenye aje afwiye. ");
INSERT INTO sbk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wakhata, okhono, wakhola hwizu, wayanga, “sahala, bhoha” ");
INSERT INTO sbk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","URoho yakwe yawela, wape mara eyo wemelela. Wabhabhola wapele eshalye. ");
INSERT INTO sbk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","AYise bhakwe bhaswijile, tee lelo wabhakhana bhagaje hubhole omntu lyelifumiye. ");
INSERT INTO sbk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wabhakwizya bhala Thenashara, wabhapela owezo na mamlaka agahwefwe pepo bhonti na ponie empongo. ");
INSERT INTO sbk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wabhasontezya bhaulombelele oumwene owa NGOLOBHE na abhaponie empongo. ");
INSERT INTO sbk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wabhabhola, “Mganje hweje ahantu msafari yenyu endesa, wala echola, wala ibumnda, wala ehela wala omo wenye asahabhe na magolole gabhele. ");
INSERT INTO sbk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na enyumba yuyonti yamwayinjila, mkhalaje omwo anzaji omwo. ");
INSERT INTO sbk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na bhala bhasebhabhakalibizizye, na mfuma mwiboma omwo, kunyuntaji hata mankondi aga mmagaga egenyu abhe ushuda hwabhahale.” ");
INSERT INTO sbk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bhabhala bhasyongola shila shijiji, bhalombelela izu na abhunie abhantu shila mahali. ");
INSERT INTO sbk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nao Herode, omwene, wovwa enongwa zyonti zyazibhombeshe, wazugumila afwanaje abhantu bhamo bhayanjile eyejo oYohana azyoshele afume afwe, ");
INSERT INTO sbk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na bhamo bhagaga oEliya abhoneshe na bhamo, bhagaga bhabhala akuwa abhe mwaha azeyoshele. ");
INSERT INTO sbk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lelo oHerode wayanga, “OYohana, nadumuye itwe eshi wenu ono wehovwa amambo gakwe? Ahanzaga hulole. ");
INSERT INTO sbk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eshi bhala atumwa, nabhawelile bhabholele amambo gonti gabhabombile. wabhega wabhalanabho pa faragha paka piboma limo likwiziwa Bethsadia. ");
INSERT INTO sbk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Namabongono nabhanya bhalondoleye wabhakari bizya, wabha ayanga nabho enongwa zya umwene owa NGOLOBHE, wabhaponia bhala bhabhali neshida eya pone. ");
INSERT INTO sbk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na isanyo lyahandile aswe, bhabhalila bhala Athenashara, bhabhola ulaje obongano ili bhabhale hushijiji na mmagondo aga mnshenje bhapaje apagone na evyalye afwanaje epa patihweli pigona wene.” ");
INSERT INTO sbk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wabhabhola, “Bhapeli amwe eshalye.”bhayaga” Seti na hantu zaidi eye mabumnda gasanu ne sanaki zibhele kasetibhala tibhakalile abhantu ebhabhonti evyalye.” ");
INSERT INTO sbk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Afwanaje alume bhali elfu zisanu. Na wabhabhola asambelezewa bhakwe. “Bhakhazi abhantu shikundi shila shikundi bhantu hamsini. ");
INSERT INTO sbk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bhabhamba esho bhabhakhazya bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wega gala amabumnda gasanu na zila esamaki zibhele wenya amwanya humbunguni, wavi sayila, wavimensula wabhapela, asambelezewe bhakwe ili bhabhapele abungano. ");
INSERT INTO sbk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhalya bhakuta bhonti, na eshi vila evimensushilo vyavyasageye bhabhongenye evitondo kumi na vibhele. ");
INSERT INTO sbk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yabha na putaga hufalagha, amanyiwa bhakwe bhahari pandwemo nawo, wabhabhozya, eshi amabongano ebhabha bhayiga ane neweni? ");
INSERT INTO sbk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhagalula, bhayanga, “oYohana yahwozya, lelo bhamo bhayiga yo Eliya, nabhamwabho bhayiga mojawapo mwa kuwa abhemwaha azyoshele.” ");
INSERT INTO sbk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wabhabhola, “amwe myiga ane newenu?” OPetro wagalula wayanga, “awe we kristi wa NGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wabhasunda, wabhakhana bhagaje hubhole omntu enongwa ezyo, ");
INSERT INTO sbk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wayanga ahwanziwa omwana owa Adamu agaje amalabha aminji nakhanwe na zee na gosi abhe makohani na simbi na gakwe na isiku elya tatu lya zyoshe. ");
INSERT INTO sbk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wabhabhola wonti omntu yeyonti, “Yahwanza ambejezye na ahwikhane yoyo, ahwitweshe ikhobhehanyo lyakwe shila lisiku, andondolezyaje. ");
INSERT INTO sbk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Afwanaje omntu yahwanza aponie enafsi yakwe ayiyitezya, na omntu yayitezye enafsi kwajili yane, esho ayiyiponya. ");
INSERT INTO sbk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Afwanaje henu habhajiye omntu, azyagaezya mnsi omo zyonti, nkeshe wahwitezya yoyo na hwiyanganuzye? ");
INSERT INTO sbk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Afwanaje shila yayindolela asoni ane na mazu gane, omwana owa Adamu wape ayihulole esoni omntu oyo nayenza no winza wakwe, no wayise no wa malaika abhinza. ");
INSERT INTO sbk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nane embabhola elyoli, bhahweli bhabhemeleye epa, ambao sebhayilenga efwa tee hata paka bhaulole oumwe owa NGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Afume amazu ego zyashilile ensiku nane abhejile oPetro, no Yohana, no Yakobo, wazubha mwigamba ili alabhe. ");
INSERT INTO sbk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yabha katika apute hwakwe esheni, esha hu maso gakwe shagaluhana, na amenda gakwe gabha mazelu gameta meta. ");
INSERT INTO sbk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na enya, abhantu bhabhele bhali bhayanga nawo! Bhape yo Musa no Eliya, ");
INSERT INTO sbk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bhabhoneshe huwinza. Bhayanga enongwa ezya fwe hwakwe, nayikamilisya hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","OPetro na bhala bhali pandwemo nabho bhali bhalemewe notulo. Lelo nabhadamla, bhalole owinza wakwe nabhala bhabhele bhabhemeleye pandwemo nabho. ");
INSERT INTO sbk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yabha ebho nabhahwibagula nawo, oPetro wabhila oYesu, GOSI, wabhagosi, shinza atee abhepa na tilenganye amahenje gatatu. Shimo shahwiliwa shimo shamusi esha mwabho sha Musa, no Eliya.” Esho ali samenye lyayanga. ");
INSERT INTO sbk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nali ayanga ego, lyafumiye ibhengo lyabhapola izunda bhogopa nabhinji mwibhengo elyo. ");
INSERT INTO sbk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Izu lyafumile mwibhengo lyayanga, “Ono mwana wane teule. Wane mwovwaji omwahale.” ");
INSERT INTO sbk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na izu elyo nalyamaliha, Yesu abhoneshe ali mwene, bhape bhapona kati, sebhatangazya hwa mntu ensiku zila lyalyoli lilo gabhagalolile. ");
INSERT INTO sbk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yabha isiku, elya bhele yakwe nabhiha hwigamba, abugano ogosi watangene nawo. ");
INSERT INTO sbk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na enye, omntu omo katika obongano akholile hwiizu ayanjile, sambilizi, “Ehulabha mwenye omwana wane, afwanaje omwahale mwana wane mwene. ");
INSERT INTO sbk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na enye ipepo lihukhata wape akhoma ibwago, antele lihupela eshifapa, olu afuma itatafura wa sahuleha ila humalabha ohwikoyola koyola. ");
INSERT INTO sbk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Embalabhile asambelezewe bhaho bhamwefe sebhawezizye.” ");
INSERT INTO sbk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","OYesu wagalula wayanga, “Amwe mshikholo mwase mlinolyeteho, mtejile embakhale nani we nahwejeshelane paka ndii? Rete omwana wa ho epe.” ");
INSERT INTO sbk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na ali ahubhalila, ipepo lyalagazya pansi. wapela eshifafa, oYesu wadamila ipepo ibhibhi, waponia omwana wawezyezya oYise. ");
INSERT INTO sbk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bhonti bhaswiga nabhaulola ogosi owa NGOLOBHE. Bhape nabhali bhaswiga amambo gonti gabhambile, abhabholele amanyiziwa bhakwe, ");
INSERT INTO sbk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ Gakhataji amazu ega mmakutu genyu, ufwanaje omwana owa Adamu abhala akhatwe mmakhono gabhantu.” ");
INSERT INTO sbk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lelo sebhalimenye izu lila, lyatisilwe hwabhale sebhalimenye, bhahogope hubhozye ofwano gwakwe gwenu izu elyo. ");
INSERT INTO sbk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bhahandile ayungane wenu yabhabhe gosi kati yabho. ");
INSERT INTO sbk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wape oYesu nawamanya esebho ezye moyo gabho, wamwega omwana ododo, wabhaha papepe no mwahale, ");
INSERT INTO sbk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wabhabhola, “yayonti yabhahuwejelele omwana ono hwitawa lyane anejeleye nene na yoyonti, yabhanejelele ane, abhabhe amwejeleye omwahale yasontezyezyeafwanaje yali mwana miongoni mwenyu mwenti oyo ndiye yo gosi” ");
INSERT INTO sbk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","OYohana wagalulawabhola, “Bwana, wogosi tilolile omntu afumya ipepo hwitawa lyaho tikhene, afwanaje salongozanyu natee.” ");
INSERT INTO sbk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","OYesu wabhola, “Mganje, hukhane afwanaje omwahale ambaye salilne mbibhi natee aliupande owahulite” ");
INSERT INTO sbk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yabha ensiku, ezya sogole nazyaparamiye afishe, omwahale alanguliye amaso gakwe abhale hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wasontezya abhajumbe atagalile hwita, galila elye maso gakwe, bhabhala bhinjila mshijiji esha bhasamaria ili kulengunyizye mahali. ");
INSERT INTO sbk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lelo akhaya sabhakaribizizye, afanaje shahenyizye amaso gakwe, abhale hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Asambeleziwa bhakwe oYakobo no Yohana nabhalolile, ego bhayanjile, “GOSI ohwanza tirajizye (neshe oEliya wape shabhombile)?” ");
INSERT INTO sbk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wabhagalushila wabhasunda -(wayanga, semmenye eroho yeli hwelewele yamlinayo) ");
INSERT INTO sbk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Apwanaje omwana owa Adamu sega henzele azitezye roho zya bhantu eshi azyaule, bhasogala bhabhala hushijiji esha mwabho. ");
INSERT INTO sbk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bhape nabhali bhabala mwidala, omntu omo abholele, “Embahulondolele hwohwonti hwobhale.” ");
INSERT INTO sbk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","OYesu wabhola, “Embela bhana magwenya, enyonyiabheangani bhane vitele, lelo omwana owa Adamu sali na pagone itwe lyakwa.” ");
INSERT INTO sbk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wabhola owa mwabho, “Ombenjelele.” Wayanga,”GOSI, pele oruhusa nasoti embale esyele oYise wane,” ");
INSERT INTO sbk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wabhala bhaleshe bhabhafwiye, “Bhaseyele naje abhafwe bhebho, eshi awe bhalagaolombelele aumwene owa NGOLOBHE. ");
INSERT INTO sbk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Omntu owamwabho. “Nantele wabhola, GOSI, embahubhenjezye lelo mpele oruhusa nasoti embalaje abhantu bhapa khaya yane.” ");
INSERT INTO sbk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","OYesu wabhola umntu, yabheshele okhono gwakwe alima antele wagaluha hwisalo sahwanziwa humwene owa NGOLOBHE.” ");
INSERT INTO sbk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Eshi baada eyego, GOSI abheshera na bhamwabho sabini wabhasontezya, bhabhele bhabhele bhatagalile bhale shila boma shila hwintu hwapambameye abhale yoyo. ");
INSERT INTO sbk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wabhabhola, “Eviyabho vinji, lelo abhombambo bhadodo. Eshi labhi hwu GOSI owe viyabho, utwale abhombamba mbombo mviyabho vyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bhalaji. Enyaji, embasotezya nesheje bhana ngole mmahanyanga. ");
INSERT INTO sbk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mgaje ahweje ifuko wala echola, wala evilato, wala mgaje hulamushe omntu mwidala. ");
INSERT INTO sbk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ekhaya yoyonti yambahahwinjele, yanji na soti, 'Amani ebhanje mnyumba omu. ");
INSERT INTO sbk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nkashile ahweli omwana owe amani, eamani yenyu ebhawele hwilimwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eshi khalaji pakhaya peepo, mlyonje na mwene evyabhahale, afanaje, obhombo mbombo ahwanziwa hupele omshahara gwakwe. Mgaje asame same afume ekhaya ene abhale ekhaya eyamwabho. ");
INSERT INTO sbk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na ibima lya lyonti, lyamuhwinjile, nkabhakaribizya lyanji elyalye vyabhabheshele hwitagalila lyenyu, ");
INSERT INTO sbk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bhaponyaji abhinu bhabhaliomwo. bhabholaji, 'Oumwene owa NGOLOBHE upalamiye' ");
INSERT INTO sbk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na iboma lyonti lyambhahwinjile, bhape sebhabhakaribizyo, fumaji omwo namwe nkamwashila katika idala lyakwa yangaji, ");
INSERT INTO sbk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Itata mankonji age boma lyenyu ggakhatene na mmanama getu tigasanyata gasagalaje hwilimwe! Lelo mmanye eli yaje, omwene owa NGOLOBHE upalamiye.' ");
INSERT INTO sbk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Embahla eyaje isiku ila ayibharahisi zaidi eSodoma ajimbe amarabha gakwe ahile iboma eli. ");
INSERT INTO sbk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ehele awe Korazini, ehele awe Bethsaida! Afwanaje nkashile amajabu ega gagabhombeshe wilimwe gagabhombeshe katika Tiro na hu Sidoni, handa bhalabhile aje bhasajilwe afume epoohu nakhale na menda age magunila na malota. ");
INSERT INTO sbk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lelo ensiku elya longwe yayibha rahisi Tiro ne Sidoni ajimbe amalabha gakwe ashile amwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nawe Kapernaumu, je! obhahwikuzye hata amwanya? Bhahwisiwe, paka hwazimu. ");
INSERT INTO sbk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yabhovwa amwe anvwezye nene, wape yabhakhana amwe ahene nene, wape yahenene akhene ola ya mntu” ");
INSERT INTO sbk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Esho bhala sabini bhawelile nasesherere, bhayanga, “GOSI, na epepo zitogopa hwitawa lyaho.” ");
INSERT INTO sbk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wabhabhola, “Naloli oshetsni nagwa afume amwanya eneshe oumeme. ");
INSERT INTO sbk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Enya, embapiye endajizyo ezya khanye enzohane nge, na maha goni golo oadui, wala na hamo ahantu hahayibha vwalazya. ");
INSERT INTO sbk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lelomgaje shime shilo amapepo nagabhopa, eshishimaji afwatanaje amatawa genyu gasimbilwe amwanya.” ");
INSERT INTO sbk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Esaa yeyo yeyo ashanjiliye hupepo ozelu, wayanga, “Ehusalifya, wo Baba, wo GOSI owa mwanya na owa pansi, afwanaje amambo ega obhafisile bhabhali neshinshi ne njele, obhalanjile abhanaabhela, ena, Baba, afwanaje shashesho shosongwelwe.” ");
INSERT INTO sbk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wayanga empewelwe vyonti na Baba wane, wala nomo yamenye omwana na yeyonti ambaye omwana asongwe hulanje.” ");
INSERT INTO sbk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wabagalushila asambelezewa bhakwe, wayanga nabho hufaragha, “Heri amaso gagalola gamgalola amwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Afwanaje embabhola, ya je akuwa abhinji na mwene bhatamanile agalola gamgalola amwe sebhagalole, navgowe gamgavwazye amwe sebha govwezye.” ");
INSERT INTO sbk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na enya, olonzi omo ahemeleye aenje wayanga, sambelezi, “Embombe, yenu ili egale owomi owa hanihani?” ");
INSERT INTO sbk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wabhola, “Esibwilwe yenu mtorati? Obhazya wele?” ");
INSERT INTO sbk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wagalula wayanga, “Ogane OGOSI ONGOLOBHE waho humwoyo gwaho gwonti, na huroho yaho yonti, na hamaha gaho gonti, na hunjele zyaho zyonti, no jirani waho neshe nafsi yaho.” ");
INSERT INTO sbk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wabhola, “Ujibule shinza. Bhommba shesho nawe ubhakhale.” ");
INSERT INTO sbk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wape ahanzaga, ahwibhonesye ehaki, wabhozya, oYesu, “No jirani wane wenu?” ");
INSERT INTO sbk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oyesu wagalula wayanga, “Omntu omo ahishile afume hu Yerusalemu abhale hu Yeriko. Wagwela mwabhabhafepla wamwaula, amenda bhavwalazya bhahwibhalila bhaleha papepe nefwa. ");
INSERT INTO sbk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwa bahati okohani omo ahishile hwidala alila na walola washila pashenje. ");
INSERT INTO sbk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na mlawi wape, shesho nawafiha pala walola washila pashenje. ");
INSERT INTO sbk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lelo oMsamaria omo, katika asafiri, hwakwe wafiha epo pahali. Na walola asajiye. ");
INSERT INTO sbk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wakaribila wapinya amalonda gakwe, waponya amafuta ne divai wamwinjizya pahamu wakwe. watwara mpaka kunyumba eya jenyi bhalela. ");
INSERT INTO sbk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hata isiku elyabhele wafumia dinari zibhele, wapela omwanesho nyumba eya jenyi, 'Wayanga orere ono na hahonti hobhatumile zaidi, ane nanayiwela nayisomba.' ");
INSERT INTO sbk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Olola wele awe katika ebho bhatatu, wenu, wali jirani wakwe ola yagweleye mmakhona bhabhafyola?” ");
INSERT INTO sbk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wayanga, “Ya yono yaloleye husajile. “oYesu wabhola, “Bhalaga nawe obhombe shesho” ");
INSERT INTO sbk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Shabha katika abhale hwabho, winjira mshijiji shimo, oshe omo itawa lyakwe yo Martha wakarihizya akhaya yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wape ali no mwana kwabho wakwe akwiziwa Mariamu, yakheye pamagaga ga Yesu atejezyaga amazu gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lelo o Martha ali ahangayiha huteleshere oYesu. Wabhalila wayanga, “GOSI, solola shibhibhi oholo wane? Shandishile etelehe nemwene? ");
INSERT INTO sbk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Eshi bhole anavwe.” OGOSI wagalula wabhola, “Martha, Martha, ohwitamasya na sononeshe kwajili eye vintu evinji, ");
INSERT INTO sbk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lelo shihwanziwa ahantu hamo wane. No Mariamu asaluye ifungu lyali linza, ambalo sagayefwezyewe.” ");
INSERT INTO sbk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yabha nali humo humo alabhaga na wamala, omo wasambelezewa bhakwe abhole, “GOSI, umanyizye ate apute neshe shila oYohana shabha manyizizya asambelezewa bhakwe.' ");
INSERT INTO sbk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wabhabhola na mputa, yangaji, semeni, 'Baba, hwetu woli mwanya. Itawa lyaho lisaiwaje. Umwene waho wenze, amapenzi gaho gatimizi waje, epa padunia neshe ohwo amwanya. ");
INSERT INTO sbk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otipele isiku hwi siku eriziki yetu. ");
INSERT INTO sbk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Otisajile embibhi zyetu, afwanaje nate ate tibhasajira shila yativisya. Na ogaje ati ponye mmalabha.” (lelo otaule nalo obhibhi) ");
INSERT INTO sbk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wabhabhola, “Wenu hwilimwe yali no rafiki, wabhalila nosiku, owe manane na hubhole, Rafiki wane hopele amabumnda gatatu. ");
INSERT INTO sbk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Afwanaje orafiki wane afishile hwiline afamile msafari, nane sendi nahantu eshabheshe hwitagalila lyakwe.' ");
INSERT INTO sbk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na ola owa mhati galula ayanje, uganjenja zye, olyango engaliye nate tiganile nashitala ane na bhana bhane, sebwezizya abhoshe aje epele. ");
INSERT INTO sbk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Embabhale yaje, ata nkashile bhoha apele afwanaje rafiki wakwe, lele shila shasaleha hulabhe, bhaso gale na hupele, kadli eyehaja yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nane embabhola, Labhaji, mbhapewe; anzaji, namwe mbhalole, ganezyaje, nemwa mbhahwalwe. ");
INSERT INTO sbk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Afwanaje shila yalabha apewa, wape ya hwanza alola, wape yadaliha ahwaulwa. ");
INSERT INTO sbk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Eshi wenu hwalimwe, yali Yise wenyuyaje omwana wukwe, nkalabhe ibumnda ahupela iwe ");
INSERT INTO sbk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","au samaki badala ya samaki ahupela enzoha? ");
INSERT INTO sbk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eshi, ekiwa amwe mwemli bhibhi mmenye abhapele abhana bhenyu evintu evinza, eshi oBaba warimwanya sabhazide abhapele opepo ozelu bhala bhabhalabha?” ");
INSERT INTO sbk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wape ali, ahwefwa ipepo, ibubu. lyabha ipepo nalyepa, ola obubu wayanga, mabongano bhaswiga. ");
INSERT INTO sbk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bhamo bhayanga, ahwefwa pepo, Beelzebul, gosi we pepo. ");
INSERT INTO sbk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhamo bhalenga bhamwanza ishala yefuma amwanya. ");
INSERT INTO sbk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wape azimenye esebho zyabho, wabhabhola, shila umwene wauvisenye wowo kwa wowo, ubhombeha sheukwa, nekhaya juu yekhaya egwa. ");
INSERT INTO sbk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eshi nkebhe Oshetani avisenye juu ye nafsi yakwe, umwene wakwa ubhahwemelele wele, afanaje amwe mjile ane ehwefwa mapepo hwa Belzebuli. ");
INSERT INTO sbk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eshi nkashile ane ehwefwa pepo Belzebuli, je abhana bhenu, mbhabhefwe hwananu, afwanaje, ebho bhabhayibhalonga. ");
INSERT INTO sbk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lelo, nkashele ane efumya amapepo hushidole sha Ngolobhe, eshu umwene owa Ngolobhe ubhenzeye. ");
INSERT INTO sbk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Omntu yali namaha ahwipinyile endoso zyakwe, nalinda ekhaya yakwe, evintu evyakwa vilishinza. ");
INSERT INTO sbk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lelo omntu yali namaha ashile omwahale na bhahubhalile nahumene, na hufyole endoso zyakwe zyasobheye, na gabhanye amateka gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Omntu ambaye salipandwemo nane, oyo alishinyume nane na omntu yasabhonganya pandwemo nane anyapanya. ");
INSERT INTO sbk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Opepo ochafu nafuma hwamntu, ashililila pasepali menze. Ahwanza apatoye sapalela, ayanga. ");
INSERT INTO sbk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Embayiwelele enyumba yane mwefumele. ");
INSERT INTO sbk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hata nafiha nkawalola eyoselye na yipambe esho abhala ayeje pepe abhamwabho saba bhali bhabhibhi ashile elyahale lyelyo, ginjila na khale omwo, omntu oyo ehali yakwe eya humalisholo ebhambibhi shile eyahwande. ");
INSERT INTO sbk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yabha nawayanga amazu ego, oshe om katika obongano akholile hwizu lyakwe, wabhola heri evyanda vyavyapepe, na mabhele gohoshile. ");
INSERT INTO sbk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lelo omwahale ayanjile, nafu, aheli bhahwovwa izu elya Ngolobhe na likhate. ");
INSERT INTO sbk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na mabongano nabhali bhahubhonganila, ahandile ayanje, eshikholo eshi shikholo eshibhibhi. Shihwanza ishala, wala seshayipewa ishara ila ishara eya Yona. ");
INSERT INTO sbk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Eshi, nkasile shila o Yona shari ishara hwa bhaninawi, shesho shayibha omwana owa Adamu hushikholo eshi. ");
INSERT INTO sbk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Omalkia owa hukusini ayisogola isiku ilyalongwe pandwemo na bhantu abheshikholo eshi wape aibhalonga aje mnamakosa afatanaje omwahale ahenzele afume ncha ezye ensi ayovwe ehekimu eya Solomoni, na epa pali o gosi ashera Osolomoni. ");
INSERT INTO sbk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Abhantu Bhaninawi bhayemelela isiku elya longwe pandwemo nesikholo eshi bhape bhayishilongu aje shikosile afwanaje abhahale bhasajilwe hundomelelo ezya Yona, nepa pali ogosi ashile o Yona. ");
INSERT INTO sbk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nomo omntu yahwasya okhozyo nabhesha pa pafisishe au pansi pameza, eshi ibhehwa pamwanya eye meza, ili bhabhahwinjila bhalolaje okhozyo. ");
INSERT INTO sbk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Okhozyo olwebele liso. Eshi iliso lyaho nkalibhe shinza, obele gwao gwonti gubhabhelukhozyo. Lelo nkalibhe libhibhi obele gwaho gubhabhe nkisi. ");
INSERT INTO sbk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Enya eshi olukhozyo lwalimhati yaho osije ogabha nkisi. ");
INSERT INTO sbk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eshi nkashile okhozyo guzyambanile mubele gwaho gwonti, wala segunesehemu eye nkisi, esho obele gwaho gwonti gubhabhe nokhozyo, nkashile lula okhozyo nkaukhozye obele gwaho gwonti gubhabhe no mwanga.” ");
INSERT INTO sbk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nali ayanga, o Falisayo omo akwizizye abhale hwamwahale alye ehsalye, winjila, wakhala pa shalye. ");
INSERT INTO sbk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisayo oyo nalolile, aswijile afwanaje saganawile sasele alye. ");
INSERT INTO sbk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ogosi wabhola, “Amwe mwafalisayo mhwozya eshikombo ne sahani wonze lelo mhati yenyu mmemile afyole no ubhibhi. ");
INSERT INTO sbk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Amwe mwalema yabhombile evya hwonza seyoyo yabhombile evya mhati antele? ");
INSERT INTO sbk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ulo fumyaji esadaka vila evya mhati ne enya, vyonti vibhovinza hwilimwe. ");
INSERT INTO sbk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lelo ole wenyu Mwafarisayo, afwatanaje mfumia ezaka za mnanaa ne zebwa na shila vilembe na ohu mleshile amamba age adili na lugane olya Ngolobhe. Mwanziwaga abhombe ego agahwande bla agalishe ego agabhele. ");
INSERT INTO sbk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ole wenyu Mwafarisayo, afwanaje msongwa akhale hwitagalila elye mabhanza na lamhane msokoni. ");
INSERT INTO sbk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ole wenyu, afwanaje mlengene na makabuli gasegabhone amago abhantu nabhashilla juu yakwe sebhali nehabari nago.” ");
INSERT INTO sbk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Omntu omo katika abhanasheria wagalula, wabhalola sambelezi, ayanje esho otilajiye ate natee. ");
INSERT INTO sbk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wayanga, namwe mbhanasheria, ole wenyu afwanaje mbhatweha abhantu amazigo gasega nyeruha wala amwe bhenyewe semgapalamasya amazigo ego hata huvidole vyenyu shimo. ");
INSERT INTO sbk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ole wenyu afwanaje mzenga maziala aga kuwa na ayise bhenyu afwanaje bhabhagojile. ");
INSERT INTO sbk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Eshi mshuhudila na zyetishe embombo ezya yise bhenyu, afwanaje bhahale bhabhagojile namwe mbhazenjela amaziala. ");
INSERT INTO sbk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na afwanaje esho ehekima eya Ngolobhe ihayanjila, enya, embasontezye hwabhahale akuwa na tumwa, bhape bhayibhagoga bhamo na bhutanje. ");
INSERT INTO sbk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ili hupapwa ene liwahwenze idanda elya kuwa wonti, yehitishe afume azengwe omsingi ogwensi. ");
INSERT INTO sbk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Afume idanda elya Abeli hata idanda elya Zakaria, yagongwilye kati ya pampto eya pashibhanza. Nantele embabhola eyaje ebhahwanzye humpapo ene. ");
INSERT INTO sbk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ole wenyu amwe mbhana sheria afwanaje muwefwizye efukuro eye marifai mwemwe semwahinji yei nabhala bhabhahinjilaga mbhazubhiye.” ");
INSERT INTO sbk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nawafuma omwo asimbi na Mafalisayo bhandile husonje shibhibhi na husinjizye humaswali gaminji. ");
INSERT INTO sbk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bhahuzijila ili bhapata enongwa zya zifuma mwilumu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wakati owo amabungano nabhatangene elfu elfu hata bhakhanyanaga, ahandile abhabhole asambe leziwa bhakwe nantele, “Hwilindi ne chachu eya Mafarisayo ambayo unafiki.” ");
INSERT INTO sbk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lelo nalimo izu lyalifisishe lyasalyaibhonaha wala lyalifisilye lyaselyayi julihana. Eshi gagonti gamuyanjile hunkisi gabhahwovwehwe pawelele. ");
INSERT INTO sbk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na gamuyanjile mmakutu mwa bhantu katika mpanda ezya mhati gayitu mbele wa pamwanya eye golu. ");
INSERT INTO sbk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nane ambabhola amwa rafiki bhane, mgaje bhaogapa ebho bhabhagoga oele afwanaje baada eyeso sebhanowezo abhombe zaidi. ");
INSERT INTO sbk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lelo embabhasunda owahumwogope. Mwogopaji ola ambaye nkashele wagoga omntu anakwezo huponye hujehanamu. Antele embabhola mwogapaji oyo. ");
INSERT INTO sbk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nkashe mshomolo gasanu segakatiwa husenti zibhele? Wala sebhahwewehwa hata om hwitagalila elya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lelo hata lisisi eya mwi atwa genyu zibhaziwe zyonti, mganje ahwa gape esho. Nafu amwe ashile amashomolo gaminji. ");
INSERT INTO sbk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nane embabhola, nkashele yayineteha hwitagalile elya bhantu, omwana owa Adamu wapa ayihumweteha hwitagalila elya malaika owa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wape wahana hwitagalila elya bhantu, oyo ayikhanwa hwitagalila elya malaika owa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na shila mntu yayiyanga enongwa juu ya omwana wa Adamu, ayisajilwa, nkashele yayihuliga opepo uzelu sagayisajilwa. ");
INSERT INTO sbk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nabhayibhatwala amwe hwitagalila elye mabhanza, na hwaliwali na hwaongozi, msazugumile asebhe enongwa zyenyu shamwayigalula au ayanje, ");
INSERT INTO sbk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","afwanaje opepo ozeru ayibhasambelezya, esaa zyezyo zyazihwaziwa aziyanje.” ");
INSERT INTO sbk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Omntu omo katika mabungano wabhola, “Sambelezi bhole oholo wane angabhile vulithi wetu.” ");
INSERT INTO sbk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wabhola, womntu awe, wenu yambeshele ane aje endi watazanye au wagabhanya juu yenyu? ");
INSERT INTO sbk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wabhabhola enyaji, hwilindaji no wimi afwanaje owomi wamntu sauhuvintu evinji evya mntu vyu unavyo.” ");
INSERT INTO sbk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wabhabhola eshilale wayanga ogonda ogwa mntu omo otajili lyali lipepe tee, ");
INSERT INTO sbk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wanda asebhe humwoyo gwakwe, wayanga, embombo wele, afwanaje sendi nupabheshe eshanga eshe viyabho vyane? ");
INSERT INTO sbk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wayanga embabhombe eshi, embabozolanye evyanga vyane, ezenje eshamwabho eshi gosi tee, nomwo embabheshe evyelewa vyane vyonti nevintu vyane. ");
INSERT INTO sbk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nantele, nayihwibhozya, awe womwoyo gwane olinevintu evinza vinji vyo hwibheye mbuto humaha gaminji. Toyo eshi, alye, omwele, osongwe.” ");
INSERT INTO sbk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lelo Ongolobhe wabhozya, olilema awe, osiku ou owasanyono bhahwanza owomi waho, nevintu vyohwibhesheye vibhabhe vyananu? ");
INSERT INTO sbk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Shesho shali omntu yahwibheye omwoyo gwakwe mbuto, asahwitajilisye hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wabhabhola asambelezwa bhakwe, afwatana nesho embabhozya mgaje ahwihangayishile amayisha genyu__mbhalya yenu wala amabele genyu mbhakwate yenu. ");
INSERT INTO sbk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Afwanaje amayisha gazaidieyeshu lya nobele zaidi yemenda. ");
INSERT INTO sbk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bhasebhaji enkogolo eyaje sebhato tuwala sebhayabhila, seline shanga wa eshitala, no Ngolobhe abhalisya, mrinafu amwe shila enyonyi! ");
INSERT INTO sbk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yonanu hwilimwe yabhajiye ahwi ngayisye nawezye ahwiyonjezye otali wakwe hata okhono gumo? ");
INSERT INTO sbk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eshi nkashele semwezizye hata lizu lyalili lidodo, yenu mhwiyazya kwajili yegamwabho? ");
INSERT INTO sbk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gasebhelaji amawowa ejinsi shamela segahuhambo embombo wala segabhilinga, neane embubhola yaje hata Osulemani katika efahali yakwe yonti saga kwatiziwe shinza kama neshe eyego, ");
INSERT INTO sbk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Eshi nkebhe Ongolobhe akwatizya eshi amasole agamwipali, gagali sanyo no na sandabho gatagwa papepe. Je sagayibhabhombela amwe? Enyi amwe mwemli imani endodo! ");
INSERT INTO sbk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amwe msahwanza shamwayilya wala shamwaimwele wala mgaje abhombe nowoga. ");
INSERT INTO sbk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Afwanaje egogonti ebhamnsi omu. Lelo o yise wenyu amenye aje mganza ego. ");
INSERT INTO sbk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eshi anzaji omwene owa NGOLOBHE, nego mwayonjezewa, ");
INSERT INTO sbk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mganje hwogope, amwe mwikundi idodo, afanaje oYise wenyu alolile shinza abhapele ula oumwene. ");
INSERT INTO sbk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kazi vyamlinavyo mfumye sadaka, hwibheshalaji amafuko yasagalala—embuto yasepogoha, humwanya pasaga afiha omwibha wala no ndo sana nkaya. ");
INSERT INTO sbk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Afanaje embuto yenyu, pehweli pagayibha gahweli na moyo genyu. ");
INSERT INTO sbk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Amasana genyu gabhe gapinyilya nehozyo, zyenyu zibhe zihwaha, ");
INSERT INTO sbk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Namwe bhanji neshe abhantu bhabhahugolezya OGOSI wabho naiwela afume huweji, ili na hwenza na khome ehodi bhamwigulile. ");
INSERT INTO sbk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nafu asontezewa bhala, ambao OGOSI wabho nayenza ayibhaga bhagonezezye. Eteshi embabhola abhahwipinye nabhakaribizye pa shalye, ayenza nabhavwe. ");
INSERT INTO sbk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nankayenze olyondizanyo olwa bhele, au nkayenza olwandiznyo olwatatu nabhaje eshi, nafu ontezewa ebho. ");
INSERT INTO sbk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lelo mmanye, izu eli, aje omwane sho nyumba agamenye esaa ya bhahwenze omwibha, handa agone zyezye, wala handa sagaleshele enyumba yakwe ebozolwe. ");
INSERT INTO sbk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Namwe hwibhehaji tayari afwanaje esaa yasagammenye shesho sha hwenza omwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","OPetro wabhola, “GOSI, eshilale esho otibholele tele wene, au abhantu bhonti antele? ");
INSERT INTO sbk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","OGOSI wayanga, “Wenu eshi yali mtunzaji mwinza yali nebusara ambaye ogosi wakuwe abhahubheshe bhombambombo wakwe wonti, abhapele abhantu eposho huwakati wakwe? ");
INSERT INTO sbk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nafu osontezi ola, ambaye gosi wakwe nahwenza awahumwaje abhomba esho. ");
INSERT INTO sbk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lyoli embabhola abhahubheshe juu yevintu vyakwe vyonti. ");
INSERT INTO sbk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lelo osontelezewa ola nkayanje humwoyo gwakwe, “OGOSI wane wakhala ahwenze wanda; abhakhome aholo bhakwe, alume na bhashe, alya na mwele na kholwe, ");
INSERT INTO sbk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ogosi wakwe otumwa oyo ayenza isiku lyasategemeye nesaa yasayimenye, abhahudumranye evipande vibhele nahubheshe ifungu lyakwe pandwemo na bhasaga bhalino lyeteho' ");
INSERT INTO sbk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","No tumwa, ola yagamenye omapenzi ga gosi wakwe, sahwibhe tayari wala agabhombe amapenzi gakwe, ayikhomwa tee. ");
INSERT INTO sbk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","No ola yasagamenye wape abhombile gagahwanziwa akhomwe, akhomwa hashe. Na shila yapewewe evinji, hwamwahale oyo bhanza wanze vivinji, wape wabhesheye amana evintu evinji hwamwahale oyo wabhanza ahwanze zaidi. ");
INSERT INTO sbk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Enenzere aponye omwoto pansi, na nkashile gwandue ahwanshe lyenu lyehwanza zaidi, ");
INSERT INTO sbk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lelo endi no wonzwe wauhwanziwa ahwoziwe, nene endi namalabha neshe eyenu ili gatimizwe! ");
INSERT INTO sbk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Eshi! mwadhani eyaje enenzele alete eamani? Pansi, embabhola, la seshashesho eshi Mafarakano. ");
INSERT INTO sbk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Afwanaje afume eshi enyumba emo bhayibha abhantu bhasanu bhavisenye, bhantu hwabhabhele, bhabhele hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bhayivisanya, oYise no mwana no mwana no Yise wakwe, onyino no lendu wakwe, khoyi wakwe, okhamwana no khamwana wa mntu. ");
INSERT INTO sbk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wabhabhola amabungano nantele, “Shila namlola ibhengo nkalifumile oupanda wa magharibi tiyanga, evula ehwenza, ibha shesho, ");
INSERT INTO sbk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na shila nevugula hukuskazini, liyanga, hubhabhe nilyoto, na shashi hweli. ");
INSERT INTO sbk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amwe mwanafiki, mmenye atambule amaso agensine mwanya, shiliwele eshi abhe semumenye atambule amajira ega? ");
INSERT INTO sbk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Na mbona amwe mwemwe hunafsi zyenu semu hwamla gagali gelyoli? ");
INSERT INTO sbk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eshi namulongozenye no mshitaki waho abhale hwa lonzi, epo pidala bhomba ebidii akondane nawo, asabhe agaburuzya mpaka hwitagalila elya lonzi, ola olonzi wakhata mmakhono gakwe, hwamwenesho yagalipizya nola owalipizye asije agafunga mwijela. ");
INSERT INTO sbk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ehubhola, sofuma omwo nkahashe hata omale asombe esenti eya mwisho. ");
INSERT INTO sbk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na wakati ou na ou, bhahali abhantu bhabhabholele enongwa eya Bhagalilaya bhala ambabho oPilato asangenye idanda lyabho na dhabihu zyabho. ");
INSERT INTO sbk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wabhagagula wabhabhola, “Eshi msebhe eyaje Agalilaya ebho bhali bhabhibhi ashile Agalilaya wonti hata gabhajile amambo ego gonti? ");
INSERT INTO sbk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Embabhola, siyo, lelo nkashile semlamba amwe mwenti mwaitega shesho. ");
INSERT INTO sbk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au bhala kumi na nane bhabhagwelewe no mnara ohwo hu Siloamu wabhagojile msebha eye je abhahale ali bhakosaji ashile abhantu bhonti bhabhakheyee hu Yerusalemu? ");
INSERT INTO sbk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Embabhola, siyo lelo nkashile semlamba amwe mwenti mwaitega shesho. ");
INSERT INTO sbk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wayanga ofwano ogu, “Omuntu omo ali nikwi lyatotilwe mgonda gwakwe elya mizabibu wabhala awanze amadondo juu yakwe sewa gaga. ");
INSERT INTO sbk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wabhola omtunzaji owe gonda elye mazabibu enya amaha gatatu ega nenza ahwanze amadondo juu ye yikwi eli. Senahajile ahantu. Oudumre mbona hata ensi enachicha? ");
INSERT INTO sbk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wagalula wabhola ogosi oureshe omwaha ogu gwape, 'hata egufugutile enguponyezye eburi. ");
INSERT INTO sbk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lyape ugapapa amadodo pamande, shinza; nkashile sewaipapa ndipo odumraje!”' ");
INSERT INTO sbk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Isiku elya tozye ali asambelezya msjiabhanza eshamwabho. ");
INSERT INTO sbk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na enya, pali noshe yali ni pepo lye udhaifu omda ogwe maha kumi naminane wape agolombene sawezizye ahwigolozye tee. ");
INSERT INTO sbk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","O Yesu nawalola akwizizye, wabholo, Maye, oyauliwe katika oudhaifu waho.” ");
INSERT INTO sbk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wabheha amakhono gakwe juu yakwe wape wagoroha pepo watukuzya Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eshi ogosi oweshibhanza avitilwe afwanaje oYesu aponizye omntu isiku elyatozye agalura wabhobhola mabongano zihweli esiku sita zyazihwaziwa abhombe embombo. Basi enzaji mponywe msiku ezyo wala siyo mnsiku ezyatoye. ");
INSERT INTO sbk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lelo Ogosi wagalula wayanga amwe, “wanafiki! Shila omo wenyu je sahwigulika eng'ombe yakwe isiku elyatoye mwigoma abhale nayo amwelezye? ");
INSERT INTO sbk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vono oshe yali shikholo sha Ibulahimu, ambaye oshetani apinyile amaha kumi na minane ega, sehwanziwa aje ayaulwe evifungo evi isiku elya toye?” ");
INSERT INTO sbk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nawayanga ego bhasauhana wonti bhadalihanaga nabho amabongano wonti bha shimo afwanaje eye mambo aminza gagabhombeshe no mwehale. ");
INSERT INTO sbk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Esho ayanjile oumwene owa Ngolobhe ulengene ne yenu, nane embulenganisye ne yenu? ");
INSERT INTO sbk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulengane ne punje eye haradali yayejile omntu wasasa mgonda gakwe yamela yabha likwii enyonyi ezya mwanya zakhala msamba zyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wayanga olya bhele engulenganisye neyenu oumwene owa Ngolobhe? ");
INSERT INTO sbk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ulengane ne chachu yahejile oshe wayifisa mhati eye pishi zitatu ezye usu hatgwasapa gwonti nantele.” ");
INSERT INTO sbk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wope ali shila mmaboma nu mvijiji asambelezya esafari yakwe eyabhale hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Omntu omo wabhozya eshi, “Gosi, abhantu bhabhahwaulwa bhadodo?” Wabhola, ");
INSERT INTO sbk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hwitahidi ahwinjile mlyango gula onyela, afanaje embabhola eyaje abhinji bhayanza ahwinjile bhayipotwa. ");
INSERT INTO sbk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wakati omwanesho nyumba nayemelela na galile olyango namwe mwayanda ahwemelele hwonze nakhome ehodi palyango, na yanje ee Gosi, tigulile omwahale abhagalule na bhabhole sembamenye hwamufuma.' ");
INSERT INTO sbk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Esho mwayanda ayanje, Taliye na mweele hwitagalile lyaho nawe wasambelezyezye idala elyetu.” ");
INSERT INTO sbk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wape abhayanje embabhola, `sembamenye hwamfumele sogalaji hwiline amwe mwenti mwemuli bhabhomba!' ");
INSERT INTO sbk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Esho shashabha shililo nasye amino namwanyihulo oIbulahimu no Isaka, no Yakobo na khakuwa wonti abhe umwene owa Ngolobhe namwe mwemwe mponyezyewe hwonze. ");
INSERT INTO sbk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wope bhayenza abhantu afume hu Mashariki, na hu Magharibi, nafume hu Kaskazini na hu Kusini, wape bhayikhara pashalye pa umwene owa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na enya, wahweli bhali bhamwisho bhayibha bhahwanda na abha hwanda bhayibha bha mwisho.” ");
INSERT INTO sbk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Esaa yeyo Amafarisayo bhamo bhamo bhabhariye, “Bhabhola fuma epe, obhale pamwabho, afwanaje oHerode ahwanza hugoje.” ");
INSERT INTO sbk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wabhabhola, “Bhalaji mbhore ola ombela, `Enya, sanyono na sandabho efumila epepo na ponye empongo, isiku elyatatu ekamiliha. ");
INSERT INTO sbk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pandwemo nego enanziwe akhate idala lyane sanyono na shendabho na renda sandabho, afwanaje sehwaziwa aje okuwa atejele hwonze eye Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ee Yerusalemu, u Yerusalemu, wogoga abhakuwa na bhakhome na mawe bhabhasontezyewe, mara halenga enanzile abhabhonganye abhana bhaho nenshe shila ekuku nebhoganya evyana vyakwe pansi eya mapiho gakwe, wala semwahanzile. ");
INSERT INTO sbk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enyaji, mreshewe enyumba yenyu. Nane embabhola, se mwailondola nante na mwaha, hata namwayiyanga asalwe yalwenza hwitawa elya Gosi.” ");
INSERT INTO sbk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yabha nawinjila mhati mnyumba eya mntu omo mmiongoni mwagosi abhe Mafarisayo isiku elyatoye, alye eshalye bharibhahuzijira. ");
INSERT INTO sbk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Enya, hwitagalila lyakwe hwalimntu obhino owe safura. ");
INSERT INTO sbk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","O Yesu wagalula wabhabhola abhane sheria na Farisayo, “Eshi, shinzi apome isiku Elyatoye, au seshasho?” ");
INSERT INTO sbk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Abhahale bhapoma wakhata waponia, waruhusu abharaje omwene. ");
INSERT INTO sbk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wabhabhora wenu kati yenyu ambaye engombe yakwe au edogomi yakwe etumbushiye mwilende wenu yasaga agavumbula isiku elyatoye?” ");
INSERT INTO sbk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wape sebhawezizye galule enongwa ezi. ");
INSERT INTO sbk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Abhabhola ofwano bhala bhahanilwe, nalolile nabhasalula amatengo aga hwitangalila wayanga, ");
INSERT INTO sbk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nkoyanilwe no muntu hu harusi, oganje akhala amatengo aga hwitagalila, ogajebhe aje oyanilwe omntu yaheshimiwa ashile awe. ");
INSERT INTO sbk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wenza ola yabhanile awe nomwene, nahubhole osegulishe ono esho shobhahwande abhenesoni awene itengo elya hwisalo. ");
INSERT INTO sbk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ila nkoyanwe bhalaga okhala pitengo elya hwisalo, nkashile ola yamwanile abhole, `Rafiki wane, enzaga hwitagalila.” esho pobhabhe nehema hwitagalila elya bhantu wonti bhakheye pandwemo nawe. ");
INSERT INTO sbk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Afanaje kila wahwikuzya ahwisiwa wape wahwiyisya azuviwa. ' ");
INSERT INTO sbk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wabhola ola ya mwanile nobhomba eshalye esha pasanya au esha nandwebhela, uganje abhakwizye arafiki bhaho wala aholo bhaho wala amwenyu bhaho wala ajirani bhaho bhabhalineshoma wape bhasahenze bhamwana awe wapata alipe. ");
INSERT INTO sbk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Eshi nobhomba eshikurukuru bhakwizye apena, alema, na viwete avipofu, ");
INSERT INTO sbk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nawe obhabhe nafu afwanaje ebhoselinahahulipe afwanaje wayilipwa nawayi owazyoshe owelyoli.” ");
INSERT INTO sbk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nawe nawovwa ego omo owabhala bhakheye pashalye pandwemo nawo abholele, “Nafu ola yabhalye ibumunda katika Oumwene owa Ngolobhe!” ");
INSERT INTO sbk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wabhola omntu omo abhombile eshikurukuru eshigosi, ahanile abhantu abhinji. ");
INSERT INTO sbk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wasontezya obhomba mbombo wakwe esala eyeshalye abhabhole bhala bhabhanilwe, `'Enzaji, afwanaje evintu vyonti vibhehwelwe tayari.' ");
INSERT INTO sbk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bhahandile bhonti, afumye audhuru hunia emo. Owahwande abholele, 'Enkarile ogonda, ehwanzaje embale endwenye. Ehulabha onsajile.' ");
INSERT INTO sbk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Owamwabho wayanga, `'Enkarile eng'ombe, ejozi zisanu embala azilenje ehulabha onsajile.' ");
INSERT INTO sbk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Owamwabho wayanga, 'Enejile oshe, afwatanesho sebwezizye ahwenze.' ");
INSERT INTO sbk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ola osontelezi wabhala wabhola ogosi wakwa enongwa zye mambo ego. Basi ola omwanesho nyumba wavitwa, `'Wabhola osontizi wakwe fuma nanali obhale mwidara igosi na mvichochoto evi boma obhalete epa apena, na lema na vipofu na viwete.” ");
INSERT INTO sbk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Osontizi wayanga, `Gosi ego golajizizye gamalishe abhombeshe, hata sheshi nemo enafasi.' ");
INSERT INTO sbk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ogosi wabhola osontezi, 'Fuma hwonze obhale hubalabala na mpaho obhashurutishe ahwinjile mhati, enyumba yane ebhe ememile. ");
INSERT INTO sbk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eshi embabhola yaje katika bhala bha bhahanilwe sahweli hata omo yabhayilenje eshikurukuru shane. ' ");
INSERT INTO sbk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Amabongano aminji nabhali bhahubhenjeya wape, agalushe wabhabhola, ");
INSERT INTO sbk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","'Nkashele omntu nkayeze hwiline wape sahuvitu oyise wakwe, no nyine wakwe, noshe wakwe, na bhana bhakwe, na holo bhakwe abheshilume na bhesheshe- nantele hata enafsi yakwe yoyo sawezizye abha mwanafunzi wane. ");
INSERT INTO sbk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Omntu yoyonti yasayeji eshikhobhohanyo shakwe nahwenzi hwisalo lyane sawezizye abha mwanafunzi wane. ");
INSERT INTO sbk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Eshi wenu kati amwe, nkashile ohwanza azenje omnara yasakhala nasoti na bhazye egharama aje alinavyo evyamalelezye? ");
INSERT INTO sbk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Asibhe wamenwa amale baada eyazenje omsingi abhantu wonti bhabhalola bhaganda huseshe, ");
INSERT INTO sbk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bhayanga, Omntu ono ahandile azenje wabha salinamaha aga malezyenje.' ");
INSERT INTO sbk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Au huli no mwene wele, nkahwanza abhale alwe no mwene owenje yasakhala nsoti na abhombe ajehane, aje omwahale pandwemo na bhantu elfu kumi agawezya atangane nola yahwenza juu yakwe na bhantu elfu ishilini? ");
INSERT INTO sbk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na nkashile walola sewezizye asontezya oujumbe ogwahwanza eamani omntu ola salihutari. ");
INSERT INTO sbk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Shila omo wenyu yasaleshile vyonti vyalinavyo sawezizye abhe mwanafunzi wane. ");
INSERT INTO sbk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Omwoni hantu ahinza, lelo omwoni nkashile gunanjishe oponyeye nu ili gukhole? ");
INSERT INTO sbk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Seguhwanziwa mnsi wala jaa abhantu bhaitaga hwonze. Yali namakutu agatejezye, na ayovwe.” ");
INSERT INTO sbk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Basi asonjezya abhesonga bhonti na bhala abhibhi bhali bhahukaribira bhamwovwe. ");
INSERT INTO sbk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Afalisayo na simbi bhauna bhayanga, “Omuntu ono abhakaribizya abhe mbibhi nantele alya nabho.” ");
INSERT INTO sbk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wabhabhola omfano ogu wayanga ");
INSERT INTO sbk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wenu hwilimwe yali nengole mia nkatejire emo yasagazileha zira tisini na tisa mwipoli, abhale ayanze ele yetejile hata eyilore? ");
INSERT INTO sbk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wape nkashile walola ahubheha mmapongo gakwe ashimile. ");
INSERT INTO sbk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nafiha akhaya yakwe, abhakwizya arafiki bhakwe na jirani bhakwe abhabhore shimaji pandwemo nane, afwanaje enjajile engore yane yehatejire.' ");
INSERT INTO sbk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","embabhola shesho hwanyibha ashime amwanya kwajili ya bhibhi omo yaramba ashile abhinza tisini na tisa ambao sebhalamba ");
INSERT INTO sbk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nu hulino she wele yali nesilinje kumi nkawatezya esilinje emo, sahwasya okhozyo n ahwose mnyumba na hwanze hubidii hata ayilole? ");
INSERT INTO sbk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na nkashile ayilole abhakwizya arafiki bhakwa na jirani bhakwe abhabhola shimaji pandwemo nane afwanaje enjajile esilinje ela yehatejire. ");
INSERT INTO sbk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Embabhola shesho hulisongwe hwitagalila elya kuwa abha Ngolobhe kwajiri yola obhibhi omo yaramba.” ");
INSERT INTO sbk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wayanga, “Omntu omo alinabhana bhabhele ");
INSERT INTO sbk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ola ododo wabhola oyise, Baba mpele eshemu eye shoma yegwela. Wabhagabhila evintu vyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hata pitagalila ensiku senyinji ola ododo wabhonganya vyonti wasogora abhale ensi eya ohutari wanankanya eshoma shakwe ohwo humaisha ege uhuni. ");
INSERT INTO sbk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nawabha anankenye eshoma shonti enzala egosi ehinjiye mnsi ela omwahale wape wanda ahwanze. ");
INSERT INTO sbk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wabhala wakhata nokhaya omo owensi ela, wape atwaliile hugonda gwakwe arere engorobhe. ");
INSERT INTO sbk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wabha atamari alya amakhondo gazyalyanga egorobhe wala nomo omntu yapanga ahantu. ");
INSERT INTO sbk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nawasebhelela humwoyo gwakwe ayanjila bhali bhalenga abhomba mbomba hwa babawane bhabhalya eshalye nasagazye nane epa efwa nenzala! ");
INSERT INTO sbk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Embasogole embabhale hwa baba wane na hubhole, “Baba enkosile juu eye mwanya na hwitagalila lyaho. ");
INSERT INTO sbk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sehwanziwa akwiziwe mwana waho nantele; mbombo neshe abhombambo bhabho.” ");
INSERT INTO sbk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wasogola wabhala hwa yise. Nalisa hutali oyise wakwe alolile walolela husajire wabhala sashembela wagwele msingo wayayila tee. ");
INSERT INTO sbk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ola omwana wabhola, 'oyise enkosile juu yemwanya na hwitalila lyaho sehwanziwa akwiziwa mwana waho nantele.' ");
INSERT INTO sbk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lelo oyise abhabholele abhombambombo bhakwe, 'leti nanali omwenda gawguli gwinza, mkwenesye peli nepete mshidole na virato. ");
INSERT INTO sbk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Reti endama ela yenonile msizile nate tilye nashime. ");
INSERT INTO sbk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Afwanaje ono omwana wane ali afwiye wape azyoshele. Ali atejira wape abhoneshe bhanda ashanjilile. ");
INSERT INTO sbk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Basi ola omwana wakwe ogosi ali hugonda. Nali ahwenza napalamile pakhaga ahovwezye amazu ege ngoma na shawa hwanga. ");
INSERT INTO sbk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wakwizya obhomba mbombo omo wabhozya amambo ego geyenu? ");
INSERT INTO sbk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wabhola oholo waho ayenzele no yise waho asinziye endama yenonile apwanje amwajile nantele ali mwomi.' ");
INSERT INTO sbk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wavitwa wakhana ahwinjile mhati basi oyise wafumire hwonze walabha. ");
INSERT INTO sbk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wagalula oyise wakwe wayanga, 'Enya ane ebhombeye amaha galenga ega wala senkosile endajizyo zyaho wakati wawonti, lelo sompiye ane enya na ye mbuzi embombe ashime na rafiki bhane. ");
INSERT INTO sbk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lelo nawenza ono omwana waho yaliye vintu vyaho pandwemo na malaya asinziye omwahale endama yenonile. ");
INSERT INTO sbk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wabhola, 'Mwana wane, awe olipandwemo nane ensiku zyonti vyendi navyo vya huliwe. ");
INSERT INTO sbk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Antele abhombe ashima ne shangwe ehali yelazima afwanaje; ali atejile wape abhoneshe.” ");
INSERT INTO sbk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Antele abhabholele asambelezwe bhakwe, “Pali no mntu omo alitakiri alino wakili wakwe, ono atakwilwe hwamwahale anankanya eshoma shakwe. ");
INSERT INTO sbk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wakwizya wabhola, “Nongwa wele ezi zyehwovwa juu ya hwiliwe? Fumia ehesabu eye owakili waho afwanaje sowezizye abhe wakili nantele.' ");
INSERT INTO sbk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ola owakili wayanga mumwoyo gwa kwao, Embombe wele, nkashere ogosi wane anefwa ouwakili? Alime sebwezizye alabhe, elola esoni. ");
INSERT INTO sbk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Endimenye lyembabhombe ili nabhanefwe huwakili bhankaribizyaje mkhaya zyabho. ");
INSERT INTO sbk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wabhakwizya bhabhakhopile amadeni aga gosi wakwe shila omo wabhora owhwande, 'odayiwa nogosi wane?' ");
INSERT INTO sbk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wayanga eshipimo mia eshe mafuta wabhora 'ege ehati yaho simba hamsini.' ");
INSERT INTO sbk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","antele wabhora owamwaho na we odaiwa?' wayanga 'makanda mia age ngano wabhoro ega ehati yaho simba themanini.' ");
INSERT INTO sbk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ola gosi wasomba owakili dhalimu shashila shabhombile hubusara. Afwanaje abhana abhensi ene katika epapo yabho bhebho bhabha ne busara ashile abhana abhe lukhozyo. ");
INSERT INTO sbk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nane embabhola bhombelaji abhe rafiki weshoma eshe udhalimu ili nehaibhanemo bhabhakaribizyaje hukhaya eye umilele. ");
INSERT INTO sbk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yali mwamini lyalili lidodo tee abhamwamini hwi gosi nantele. na yali dhalimu hwidolo abhabhe dhalimu hata hwigosi nantele. ");
INSERT INTO sbk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Basi nkashile amwe semwali bhaminifu hushoma eshe udhalimu wenu wabhapele amana eshoma eshelyoli? ");
INSERT INTO sbk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na nkashile semwali bhaminifu hushoma esha mntu owenje wenu yabhabhapele yeli yahulimwe mwemwe? ");
INSERT INTO sbk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nomo obhombambo yabhabhambele agosi bhabhele, afwanaje abhahuvitwe ono nahusongwe ono, au abhakhatane nono na hudhalau ono. Sawezizye hutumishile Ongolobhe ne shoma.” ");
INSERT INTO sbk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Basi Mafarisayo, abhene bhebho bhasogwa ehela bhahovwezye ago gonti bha dhihaki. ");
INSERT INTO sbk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wabhabhola, “Mwe mwemwe mhwidai elyoli hwitagalila elya bhantu, lelo Ongolobhe abhamenye amoyo genyu afwanaje lyalisobwa hwa bhanadamu uhuvisya hwitagalila elya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Etorati na kuwa vyahali mpaka Yohani afume. Ouwakati wowo enongwa enyinza ezye umwene owa Ngolobhe zitangaziwa, na shila mntu ahwiyinjizya humaha. ");
INSERT INTO sbk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lelo nafu zaidi emwanya nensi vyepe ashile aje etanguliwe enukta emo eye torati. ");
INSERT INTO sbk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Shila yahuleha oshe wakwe na humweje oshe owenje azini wape yahumwega yalehwilye nolume wakwe anazini. ");
INSERT INTO sbk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pali ono mntu takili akwete nu menda ege rangi ye zambarau na kitani nyinza na lye ensiku zyonti kwa anasa. ");
INSERT INTO sbk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No pena omo itawa lyakwe yo Lazaro abhehwelya palyango gwakwe ali na malonda gaminji. ");
INSERT INTO sbk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wape ali akitamani akutiziwe amambo gagalagaliye pameza eyola otakiri hata embwa zyeza zya guna amaronda gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yabha ola opena wagwa wegwano malaika paka pashifiwa esha Ibulahimu ola otakiri wape wafwa wa syelwa. ");
INSERT INTO sbk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Basi ohula huzimu abhosezye amaso gakwe nali pamarabha walola Ibulahimu sahutari no Lazaro pashifua shakwe. ");
INSERT INTO sbk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Walila wayanga, 'Ee baba Ibulahimu, sajire osontezye oLazaro atobhezye echa eye shidole shakwe mmenze, aluburudishe omele lwane; afwanaje elabha mu mwoto omu. ");
INSERT INTO sbk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ibulahimu wayanga, 'Mwanawane kumbuhaga eyaje awe waposheye amambo aminza gahuliwe katika amaisha gaho, no Lozaro shesho apete amabhibhi na eshi omwahale aliepa afarijiwa na awe ovwalala. ");
INSERT INTO sbk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na zaidi yego kati yetu ate na mwe libhehwelwe irende igosi, ili bhala bhabhafuma ohwo abhale hwilimwe bhagajeshile wala abhantu abhahwilimwe bhagaje shile ahwenze hwititi.' ");
INSERT INTO sbk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wayanga, 'Basi Baba ehulabha, osontezye akhaya hwa baba wane ");
INSERT INTO sbk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","afwanaje endi na holo bhasanu ili abhashudile bhasije bhape nantele bhafihe mahali epa pamalabha. ' ");
INSERT INTO sbk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibulahimu wayanga, 'Bhalinabho oMusa na kuwa. Na bhabhovwe ebho. ");
INSERT INTO sbk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wayanga, 'la, Baba Ibrahimu, lelo nkashile abhabhabhalile omntu yafuma hwa bhafwa bhanzarambe.' ");
INSERT INTO sbk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wabhola nkashele sebhabhowa aMusa nu kuwa sebhanzashawishiwe hata omntu nkashile azyoshe afume wabhafwe. ");
INSERT INTO sbk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wabhabhola asambelezewa bhakwe, “evisyo sevi nebudi ahwenze lelo ole wakwe omntu ola ambaye gahwenza afwatane nomwahale! ");
INSERT INTO sbk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yakhondeye zaidi omntu oyo iwe elyasyole lipinyeve msingo yakwe aponywe mwidimi, ashile abhavisye miongoni mwadodo ebha. ");
INSERT INTO sbk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hwirindi. Nkashile ohoro waho nkakoseye sunde, nkarambe sajire. ");
INSERT INTO sbk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nankashile akosire mara saba katika isiku limo, nawele hwiliwe mara saba nkayanje, 'erabha,' sajire!” ");
INSERT INTO sbk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atumwa bhabhola Gosi, “Tonjezye oweteho.” ");
INSERT INTO sbk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ogosi wayanga, “nkashele mgari no lweteho ekiasi eshe chembe eye haradali, mwezaga alibhole iko eli senyeha, 'utotwe mwidimi,' wope ungewaheshimu. ");
INSERT INTO sbk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lelo wenu hwilimwe, omwanesho obhomba yalima au yadima ing'ombe, yabhalubho nawera afume hugonda, 'Enzaa epa nanali khara olye eshalye? ");
INSERT INTO sbk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Je sabhahulobhe mbombele tayari eshalye endwe, hwipinye ombombele hata endwe na mwele. Nawe pobhalya na mwele? ");
INSERT INTO sbk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Je abhahupere emwasalipa ola obhomba mbombo afwanaje abhombile galajiziwe? ");
INSERT INTO sbk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Shesho namwe namwayibha mumari abhombe gonti gamlajiziwe yangaje 'Ate tili bhasontezewa bhasebhali ne faida. Tibhombile wene gaganziwaga tibhombe.' ");
INSERT INTO sbk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yabha nabhali mwidara nabhala hu Yerusalemu, ali ashira mhati eye Samaria na Galilaya. ");
INSERT INTO sbk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nawinjira mshijiji shimo, atangene nu bhantu kumi bhali no ukoma. Bhemelela sahutari ");
INSERT INTO sbk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakhora humaza bhayanga “Ee Yesu, Gosi owa Gosi otisajire.” ");
INSERT INTO sbk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nawabhalola wabhabhola, “Eshi bhalaji mhwibhonezye hwa kohani.” yabha nabhali bhabhale bhahozyewe. ");
INSERT INTO sbk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na omo miongoni mwabho nawalola aje aponile awelile, ohuu ahutukuzya Ongolobhe hwizu igosi. ");
INSERT INTO sbk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wagwa fugamila pamagaga gakwe na husalifwe wapa ali msamaria. ");
INSERT INTO sbk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","O Yesu wagalura, wayanga, “Sebhatakasyewe wonti kumi? Bhala tisa bhalihwi? ");
INSERT INTO sbk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Eshi sebhabhonesha bhabhawelile hupele Ongolobhe, outukufu ila ojenyi ono?” ");
INSERT INTO sbk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wabhora, “Imelela walaga wewe olweteho lwaho lumwauye.” ");
INSERT INTO sbk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nabhozyewaga na mafarisayo umwene owa Ngolobhe wayenza ndii, Aglula wabhabhola, “Umwe owa Ngolobhe seuhwenza agodezyegozye. ");
INSERT INTO sbk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala sebhayiyanga, 'Enya uhweli ohwo!' au, 'Hula!' afwanaje enya umwene owa Ngolobhe uhweli mhati yenyu.” ");
INSERT INTO sbk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wabhabhola asambeleziwa bhakwe, “Ensiku zihwenza namwitamani alole isiku limo katika ensiku zyakwe Omwana wa Adamu, samwaizilola. ");
INSERT INTO sbk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Antele bhayibhabhola, 'Enyi, ohu! Mganje, sogole pala!' Paruhweli wala msabharondozye, ");
INSERT INTO sbk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","afwanaje neshe shila oumeme shaukhozya hata upande ou owensi eye mwanya. Esho shashayiha Omwana owa Adamu katika ensiku zyakwe. ");
INSERT INTO sbk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lelo ahwanda sali nebudi apate marabha aminji na khanwe neshikholo. ");
INSERT INTO sbk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ila nkashele shashahali ensiku ezya Nuhu, esho shashayibha katika ensiku zyakwe Omwana owa Adamu. ");
INSERT INTO sbk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bhali bhalya na mwele na hweje na hwegwe hata isiku ila o Nuhu yahinjile katika mwisafina amakhoshi gahishile gabhangamizizye wonti. ");
INSERT INTO sbk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na nkashile shahali katika ensiku zya Lutu, bhali bhalya na mwele, wali bhakala na kazye, bhatotaga nazenje. ");
INSERT INTO sbk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lelo isiku lila Lutu yafumile Msodoma, gwahishile omwoto neshibiriti afume amwanya gwabhatezizye wonti. ");
INSERT INTO sbk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Esho shashayibha isiku lila lyayibhonesyewa owa Omwana owa Adamu. ");
INSERT INTO sbk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Katika isiku lila yali juu yogoro na evyelelo vyakuwa vili mhati eyenyumba agaje hwishe ili ayeje. Nantele yali hugonda ga jewele hwisalo. ");
INSERT INTO sbk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Izuhaji oshe wa Lutu. ");
INSERT INTO sbk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Omntu yoyonti yabhaponje enafisi yakwe abhayitezye nayoyonti yayitezye, abhayiponie. ");
INSERT INTO sbk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wabhabhola, osiku owo abhantu bhabhele bhayibha ishitara shimo. Omo ayegwe omo ayilehwa. ");
INSERT INTO sbk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abhashe bhabhele bhayibha bhasya pandwemo, omo ayegwe omo ayilehwa.” Abhantu bhabheke bhayibha hugonda omo ayegwa omo ayirehwa.” ");
INSERT INTO sbk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bhagalula bhabhozya, “Woshi, Gosi?” Wabhabhola, “Peli efwe nyene pepo pabhayitanganila enyonyi.” ");
INSERT INTO sbk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wabhabhora omfano yaje ehwanziwa hulabhe Ongolobhe ensiku zyonti wala mgajekate etama. ");
INSERT INTO sbk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","wayanga, 'Pali no lozi katika iboma limlimo sahuputa Ongolobhe wala sahwogapa abhantu. ");
INSERT INTO sbk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na katika iboma elyo pali noshe ofwele ali ahubhaliila bhalila, ayanga, 'Pele ehaki na adui bhane.' ");
INSERT INTO sbk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wapa humda akhene antele wayanga humwoyo gwakwe, iwapo sehuputa Ongolobhe wala sehwogopa abhantu, ");
INSERT INTO sbk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lelo afwanaje ofwele ono avisya ambahupe ehaki yakwe asayenza andisye anenzele tee.” ");
INSERT INTO sbk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ogosi wayanga tejerezi gayanga ola olozi odhalimu. ");
INSERT INTO sbk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","No Ngolobhe je Sabhabhapele elyoli bhaala bhateulie bhakwe bhabhahuli lila osaya no siku? wape jivi hwabhahale? ");
INSERT INTO sbk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Embabhora ayibhapera ehaki nanali. Lelo nayenza Omwana owa Adamu je ayiyilola imani pa dunia? ' ");
INSERT INTO sbk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wabhabhora ofano ogu abhantu bhabhahwikinalile eyaji abhabhare bhalinelyoli bhabhasolanya abhanje wonti, ");
INSERT INTO sbk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","'Abhantu bhabhele bhazumile mwibhanza apute: Omo Farisayo owabhele asonjezya esonga. ");
INSERT INTO sbk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ola oFarisayo wemelela arabhe eshi humwoyo gwakwe, 'Ee Ngolobhe, ehusalifwa afwanaje ane sendi neshe abhantu abhanje, bhabhafyala, adhalimu, ahuni, wala neshe ono yasonjezya esonga. ");
INSERT INTO sbk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ane efunga habhele hurungo. Efumia ifungu elyakumi katika amapato gane gonti. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lelo ola yasonjezya esonga ahemeleye sahutari, wala gagawezizye hata huhwenye amaso gakwe amwanya esho ahwikhamile khonile pashifubha ayanga, 'Ee Ngolobhe, osajile ane endibhibhi.' ");
INSERT INTO sbk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Embabhola, ono ahishile abhara akhaya yakwe abhaziwe elyoli ashile ola afwanaje kila wa hwinyunula adhiriwa wape ajidhiliye abhakuziwe. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bhatwalila abhana abhere ili abhapalamasye, lelo asambelezewa bhakwe, nabhabhalola bhabhadamile. ");
INSERT INTO sbk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Esho oYesu wakiwzya bhale hwamwe hale wayanga, 'Bhareshi abhana adodo bhenze hwiline wala msabhagomele afwanaje abhantu neshe ebho oumwene owa Ngolobhe wabho. ");
INSERT INTO sbk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Eteshi embabhola, omntu yeyonti ya sahwejelela oumwene owa Ngolobhe nenshe omwana ododo sagaayinjila nantele. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Antale omntu ogosi omo abhozezye ayanjile sambelezi mwinza embombe wele ili empewe agale owomi owa hanihani?' ");
INSERT INTO sbk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","O Yesu wabhabhora, 'Eshi mnkwizya mwimza? Nomo omwinza ila aliomo wape yo Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ozimenye endijizwo- ogajebhe huni, ogajegoje, ogaje ahwibhe, ogaje ayanje ilenka obhaheshimu oYise waho no nyina waho. ");
INSERT INTO sbk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wayanga ege gonti engakhete afume huwana wane.' ");
INSERT INTO sbk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","O Yesu nawovwa ego abhorale, “Apongoshewe izu limo osele. Kazya vyolinavyo vyonti obhagabhile apena nawe abhabhe nembuto amwanya nantele enze ondodore. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lelo nahovwezye ego akongobheye tee, afwanaje alineshoma shiminji. ");
INSERT INTO sbk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","O Yesu nawalola shila wayanga, 'Hushida wele abheshoma bhayinjila oumwene owa Ngolobhe! ");
INSERT INTO sbk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Afwanaje shororo engamia ashile pitundo elye shindano ashile otakili ahwinjile oumwene owa Ngolobhe. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhape bhabahovwe bhayanjile wenu eshi yagaulwe?' ");
INSERT INTO sbk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wayanga, 'Gasegawezeha wabhanadamu gawezehana hwa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","O Petro wayanga, 'Enya, ate tivileshire evintu vyetu vyonti na hurondorere. ");
INSERT INTO sbk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Wabhabhora, Lyoli embabhora nomo omntu yayireshire enyumba yakwe, au oshe, au ohoro, au apafi, au abhana, kwajili eye Umwene owa Ngolobhe, ");
INSERT INTO sbk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yasagayiposhera hahinji katika amaha ega, na katika ensi yihayinza no womi hanihani. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wabhega bhala thenashara, wabhabhora, 'Enyi, tizubha abhale hu Yerusalemu, amambo gonti gawatimiziwe Omwana owa Adamu gasibwililwe na kuwa. ");
INSERT INTO sbk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Afwanaje abhakhatwe mmakhono age bha Mataifa aibhombelwa edhahaka, abhabhombelwe azyongolwe nu huswele amate. ");
INSERT INTO sbk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wape bhayihukhoma namajeredi esho bhayihugoga, isiku elyatatu ayizyoha. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lelo sebhahelewa enongwa ezyo atahashe, ejambo elyo lyafisilwe hwabhahale, wala sebhamenye gagayagwilwe. ");
INSERT INTO sbk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yabha na apalamie hu Yeriko, omntu omo kipofu ali akheye pashenje ye dara alabhaga esadaka, ");
INSERT INTO sbk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","na wovwa mabongano na bhashila wabhozya huliyenu. ");
INSERT INTO sbk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhabhola oYesu owa hu Nazareti ashira. ");
INSERT INTO sbk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wakhora ehoro wayanga, Yesu Mwana wa Daudi, osajire.' ");
INSERT INTO sbk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","basi bhala bhatagaliye bhadamila ili apome, lelo umwahara ahonjezezye sana apayushe izu, 'Ee Mwana wa Daudi, osajire. ");
INSERT INTO sbk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","O Yesu wemerela wamurisya atwarwe hwamwahare nu paramiye abhozezye, ");
INSERT INTO sbk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","'Ohwanza ebhombele yenu?' Wayanga, 'Gosi, empate alole.' ");
INSERT INTO sbk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","O Yesu wabhora, 'Opewe alole. Olweteho olweho luponizye. ' ");
INSERT INTO sbk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mara eyo wapata alore, wabhenjezye ohu ahusifu Ongolobhe. Na bhantu bhonti na bhalori ego bhasifure Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wape nahunjiye hu Yeriko ashirile pahati yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na enya pali no mntu ityawa lyakwe Zakayo. Gosi hwabha sonjezya esonga wape takiri. ");
INSERT INTO sbk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ono ahanzaga hulore oYesu mntu yali welewele sagawezizye afwatane no winji wabhantu eshi fupi wekimo. ");
INSERT INTO sbk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Watangulira sashembera winjira amwanya mwiko ilipate hurole afwanaje abhahwenze shilire idara lila. ");
INSERT INTO sbk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na oYesu ashilile esehemu ela, ehenyizye amwanya wabhora, 'Zakayo, iha nanali, afwanaje sanyono ehwanziwa alenda mnyumba yaho.' ");
INSERT INTO sbk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wabhomba nanali, wiha wakaribizya ohu ashiye. ");
INSERT INTO sbk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hata bhantu nabhavolire bhaunire wonti, bhayanga, 'Ayinjiye akhare hwa mntu owe mbibhi.' ");
INSERT INTO sbk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo wemerela wabhora Gosi, Enya Gosi enusu eye shoma shane embapera apena nkashera efyelere omntu ahantu huhila ehuwezezya mara zinne. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","O Yesu wabhora sanyono owaule ufishire mnyumba omu afwanaje ono wape mwana wa Ibrahimu. ");
INSERT INTO sbk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Afwanaje Mwana wa Adamu ahenzere ahwanze na hwaule shila shashitejire. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nabhahovwezye ego, ahonjeye ayanje omfano afwanaje aripapepe ne Yerusalemu, bhape bhasebhere aje oumwene owa Ngolobhe ubhonesha nunari. ");
INSERT INTO sbk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Basi wayanga, 'Omntu omo kabaila asafiriye abhare ensi yahutari ili ahwipere oumwene na were. ");
INSERT INTO sbk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wabhakwizya abhantu kumi katika asontezi bhakwe awapera amafungu kumi agehela wabhabhora bhombaji ebiashara hata nehayenza.' ");
INSERT INTO sbk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lelo abhantu abhe boma lyakwa bhavititwe bhasontezyezye oujumbe hurondore na yanje setihumwanza ono atilongozye.' ");
INSERT INTO sbk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yabha nawawela apete oumwene wakwe wamuru bhakwizizwe bhala atumwa bhabhapiye ehela, ili amanye efaida yapete shila mntu huchuruzi wakwe. ");
INSERT INTO sbk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wenza owahwande wayanga, `Gosi, ifungu liretire efaida eye fungu kumi zaidi. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wabhora, Shinza mtumwa mwinza hwashila sholi mwaminifu hunongwa endodo obhe na mamlaka amafungu juu ya maboma kumi. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wenza owabhele wayanga, 'Gosi, ifungu lyaho liretire amafungu gasanu efiada.' ");
INSERT INTO sbk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wabhora ono wape awe owe juu eye maboma gasanu.' ");
INSERT INTO sbk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wenza owamwabho wayanga, `Gosi eli lifungu lyaho ambalo nabheshere mbuto mreso.' ");
INSERT INTO sbk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","afwanaje namwogope afwanaje oli mntu okhome ohwefu husobheshere okhome, ohwefu hasobheshere okonga hasaga ototire. ");
INSERT INTO sbk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wabhora ambahulonje hwiromu lyaho wotumwa wobhibhi awe wamenye aje endi mntu khome. Nehwefwe hasembeshere na ekonga husetolile. ");
INSERT INTO sbk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Basi, eshi sohabheshere ehela yane hwa bhafumia eriba ili nehwenza enjagaje pandwemo nefaida yakwe? ");
INSERT INTO sbk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wabhabhola bhabhemeleye papepe fyori elyo ifungu mpere ola yali namafungu kumi.' ");
INSERT INTO sbk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhabhora, `Gosi, anago amafungu kumi. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Embabhora, shila yali nahantu abhapewe lelo ola yasalinahantu bhafyolwe hata halinaho. ");
INSERT INTO sbk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Antele bhala adui bhane bhadebhahwanza aje embalongozye bhareti epa mbhabhole hwitagalila lyane.” ");
INSERT INTO sbk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nawamala ayanje ego atanguliye hwitagalila wazubha abhare hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yabha na paramiye pa Bethfage na Bethania, hwigamba lyalihwetwa Mizeituni, asontezyezye bhabhele katika bhala asambeleziwa, ");
INSERT INTO sbk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wayanga: `Bhalaji mpaka nshijiji shila shashili papepe omwana-dogomi apinyilwe ambaye sawayile ahwinjilwe no mntu yoyonti asele mwauli mrete epa. ");
INSERT INTO sbk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na nkashile omntu abhabhozye eshi mhumwalayanji eshi Ogosi ane shida nawo.” ");
INSERT INTO sbk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na bhala bhasontezywe bhalile bhalolile ne nshe shabhabholele. ");
INSERT INTO sbk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nabhali bhahumwaula omwana-dogomi abhanesho bhabhabhozya mbona mhwaula edogomi?' ");
INSERT INTO sbk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhayanga, `Ogosi aline shida nawo. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhatwala hwa Yesu bhara amenda gabho juu ya mwana dogomi bhamwinjizya oYesu. ");
INSERT INTO sbk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na hali abhala bhabhambshe amenda gabho mwidara. ");
INSERT INTO sbk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hata nali aparamiye ahwishe mwigamba elya Mizeituni, ikundi lyonti elyasambelezewa wakwe bhahandira ashime na husifu Ongolobhe humazu amagosi eye mambo gakwe age mahaa gabhagalolile, ");
INSERT INTO sbk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","bhayanga, 'Ndiye yasayilwe mwene yahwenza hwitawa elya Gosi! Amani amwanya na utukufu ohwo amwanya!' ");
INSERT INTO sbk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bhamo Afarisayo bhabhahari pabongano bhabhora, Sambelezi obhakhane asambelezi wa bhaho. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wagalula wayanga embabhora amwe nkabhapome kati ebhe amawe gabhohomere ohoro. ' ");
INSERT INTO sbk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nawafiha papepe walilola iboma walilillaa, ");
INSERT INTO sbk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wayanga, lelo ogamenye hata awe katika isiku eli gagawanziwa amani! Lelo eshi gafisilye pamaso gaho. ");
INSERT INTO sbk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Afwanaje isiku zyayenza adui bhaho nabhayihuzenjela boma, lizyongole bhaihuzyongola epande zyonti. ");
INSERT INTO sbk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bhayihugwisya pansi nabhana bhaho mhati yaho. Bhasiteshere iwe juu iwe, afwanaje sohamanyaga amajira agahwenzele hwaho'. ");
INSERT INTO sbk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Winjita mwibhanza wanda abhafumie bhala bhabhabhombaga ebiashara, ");
INSERT INTO sbk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","abhabhola, “Isimbwilwe, 'Enyumba yane ebhabhe nyumba ye mputo.' lelo amwe muyibhombile abhe ligwenya lyo bhafyola”. ");
INSERT INTO sbk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wape wabha asambelezya shila lisiku mwibhanza. Lelo Gosi Abhakohani na simbi na agosi abhabhantu bhali bhahwanza idara elya hutezye, ");
INSERT INTO sbk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","sebhalilora elya bhombe afwanaje abhantu bhonti bhahwandamano nawo bhahutejezya. ");
INSERT INTO sbk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yabha isiku limo, ali asambelezya abhantu Mwibhanza na alombelele enongwa enyinza, agosi abhe makuhani na Simbi pandwemo na zehe bhabhaliye nanali. ");
INSERT INTO sbk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bhabhora, bhayanga, 'Tibhore obhomba amambo ego humaha ganu nantele yonu yapiye amaha ege?” ");
INSERT INTO sbk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wagalula wabhabhora, 'Nane ambabhobhozye amwe enongwa zimo mbori ");
INSERT INTO sbk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","owoziwa owa Yohana. Je, wapumile amwanya au wabhantu? ' ");
INSERT INTO sbk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bhagamzanya bhebho hwa bhebho, wayanga, 'Nkashere, `Tije ufumile amwanya, ayanje, ` Basi, mbona semwamwetesha?' ");
INSERT INTO sbk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nkatije tiyanje aje ufumire hwa bhantu; abhantu bhonti bhanzatikhome na mawe afwanaje bhamweteshe oYohana aje kuhwe. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bhagalula aje sagatimenye hwa ufumere. ");
INSERT INTO sbk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","O Yesu wabhabhola, “'Wala ane sembhabhola amwe humaha gananu gebhomba amambo ega.” ");
INSERT INTO sbk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wanda abhabhore abhantu hufwa no ogu, “Omntu omo atotira ogonda ogwe mazabibu, wapanjizya bhabhalima, wabhara wakhala hunsi eyamwabho humuda ogwinji. ");
INSERT INTO sbk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na wakati owakonje asontezyezye owe mbombo owamwabho bhakhoma ono wape bhakenyesya bhatunga mmakhono aliwene. ");
INSERT INTO sbk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wasontezya newembombo owa mwabho bhakhama wape bhakenyesya bhatanga namakhono- wene. ");
INSERT INTO sbk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wasonteleya no watatu ono wape bha vwalazya bhataga hwonze. ");
INSERT INTO sbk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Basi ogosi owe gonda ogwe mizabibu ayanjile, embombewele? Embahusontezye omwana wane wegene ane. Olwenje bhagamwogopa omwene. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lelo bhala abhalima nabhalorile bhashauliyene bhene hwe bhene bhayanga ono wagare eshi tigoje ili agalo ubhe wetu. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhataga hwonze hugonda ogwe mizabibu bhagoga. Basi ogosi owe gonda elye mzabibu abhabhabhombe wele? ");
INSERT INTO sbk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Awahenze nabhatezye bhabhalima bhala nogonda gula ogwe mizabibu, anzabhapele abha mwabho nabhovwa ego bhayanga, 'Basi gasafumire ega' ");
INSERT INTO sbk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wabhalangulila amaso wayanga emana yakwe yenu eshi izu eli lyalisibwilwe, iwe lyabhalikhene wa ashi elyo liwe igosi lyalishenje'? ");
INSERT INTO sbk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nkashele kila muntu yayigwela piwe elyo abhabudushe walyayihugwela lyayihusya tee. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bhape asimbi na gosi makuhani bhahanzile hukhate esula yeyo, bhabhogopa abhantu afwanaje bhamenye aje ofwano ogu abhayanjire bhebho. ");
INSERT INTO sbk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bhazijira zijira bhasontezya owa pelelezye bhahwibhesheye aje bhantu bhelyoli ili bhatonele afumire nenjango zyakwe bhapute hubheshe katika enzi eye utawala owa liwali. ");
INSERT INTO sbk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bhabhozya bhayanga sambilezi timenye eyaje oyanga na sambelezye gagali gelyoli wala sojali echeo eshamntu bali osambelezya idara elyo Ngolobhe elyelyoli. ");
INSERT INTO sbk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Eshi je harari tipile o Kaisari esonga au seshashesho?” ");
INSERT INTO sbk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lelo omwene amenye azyongora hwabho wabhabhora, ");
INSERT INTO sbk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mbonesi edinari. Eno waje namandi gananu?” Bhagalula, “Ya Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wabhabhora, 'Basi, evya Kaisari mpele oKaisari, nevya Ngolobhe mpeleje Ongolobhe.' ");
INSERT INTO sbk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wala sagabhawezizye ahutake hunongwa zyakwe hwitagalila elya bhantu. Bhaswiga amajibu gakwe bhapoma. ");
INSERT INTO sbk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yabha bhamo bhamo Masaduayo bhabhalila, bhala bhabhayanga yaje na humo azyoshe bhabhozya, ");
INSERT INTO sbk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bhayanga, “Sambelezi, oMusa atisimbiye eyaje omntu nkafwelwe noholo wakwe ali noshe lelo salinomwa na amweje ono oshe apapile oholo wakwe abhana. ");
INSERT INTO sbk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Basi bhali ahola saba owahwande ahejele oshe wafwa sali na mwana, ");
INSERT INTO sbk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","na owabhele(wamwega ola oshe wafwa sali no mwana). ");
INSERT INTO sbk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hata owatatu wamwega na bhamwabho wonti saba, bhafwa sebhaleshile abhana. ");
INSERT INTO sbk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Humalisholo wafwa ola oshe wape. ");
INSERT INTO sbk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Basi katika azyoshe ayibha she wananu? Afanaje ahegwilwa nabho wonti saba. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O Yesu wabhora, “Abhana abhe ulimwengu ogu bhahwega nahwegwe. ");
INSERT INTO sbk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lelo bhala bhabhabhaziwa emwanya ela na hula azyoshe hwabhabhafwiye sebhahwega wala sebhahwegwe. ");
INSERT INTO sbk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wala sebhawezizye afwa nantele afwanaje mlengana wene na malaika bhape bhana bha Ngolobhe, shila shabhali bhazyoshe. ");
INSERT INTO sbk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lelo eyaje abhafwa bhayizyoha hata yo Musa alangwilwe owaje owe sazo epo payanjile Ogosi aje yo Ngolobhe owa Ibrahimu na Ongolobhe owa Isaka na Ongolobhe owa Yakobo. ");
INSERT INTO sbk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wape se Ngolobhe owabhafwe bali bhabhali bhomi, afwanaje wonti bhakhara hwamwahale.” ");
INSERT INTO sbk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Asimbi bhamo bhagalula bhabhola, 'Sambezi, oyanjile shinza. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wala sebhawezizye hubhuzye enongwa baada eye go. ");
INSERT INTO sbk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wabhabhora abhantu bhayanga wele aje oKristi mwana wa Daudi? ");
INSERT INTO sbk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Afwanaje oDaudi yoyo ayanga mchuo esha Zaburi: Ogosi abholele Gosi wane: Okhale okhono gwane ogwendelo, ");
INSERT INTO sbk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hata embabheshe adui bhaho abha litengo elya bheshe amagaga. ' ");
INSERT INTO sbk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Basi Daudi ahukwizya 'Gosi', shili wele mwana wa Daudi?” ");
INSERT INTO sbk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na bhantu bhonti nabhali bhahutejezya abhabhorele asambeleziwe bhakwe, ");
INSERT INTO sbk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","'Hwilindaji na simbi bhasongwa ajende bhakwete amenda amatari na lamhana msokoni na khale hwitagalila elye mabhunza na khara amatego agahwitagalila pashikurukuru. ");
INSERT INTO sbk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mlya enyumba ezyafwele na hunafiki bhaputa eputo entali. Ebho bhayipata alongwa eshi gosi. ' ");
INSERT INTO sbk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wabhosya amaso gakwe wabhalola atakili bhaponya esadaka zyabho mwibogosi elye mbuto. ");
INSERT INTO sbk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Walola ofwele omo pena aponya mla esenti zibhele. ");
INSERT INTO sbk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wayanga embabhora ono ofwele opena aponyizye zaidi ashile mwenti. ");
INSERT INTO sbk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Afwanaje ebho bhonti bhaponyizye esadaka eshoma shashonjelezye zaidi bali ono hupena wakwe aponyizye vyonti vyali navyo.” ");
INSERT INTO sbk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na bhantu bhamo bhamo nabhali bhayanga enongwa ezya shimanza ejinsi shari pambwilwe humawe aminza ne salama ezya bhantu ayanjire, ");
INSERT INTO sbk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ega gamgalola, insiku zyayenza ambapo selyaisagala iwe juu eiwe ambalyo salyaibozolwa.” ");
INSERT INTO sbk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bhabhozya bhayanga, “Sambelezi, amambo ega gayibha ndii? Gape yenu ishara yakwe eyaje amabo ego gali papepe afumire?” ");
INSERT INTO sbk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wayanga, “Enyaji msije mgakhopelwa. Afwanaje bhinji bhayenza hwitawa lyane, bhayanga, 'Ane nene, 'antele 'Owakati uparamiye basi msabhabhenjezye ebho. ");
INSERT INTO sbk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Namwe namwayovwa enongwa ezye ibho nefitina, mgajetishiwe, afwanaje ego segali n ebudi afumire nasoti lelo ula oumalishoro seuhwenza nanali.” ");
INSERT INTO sbk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Esho abhabhorere, “Itaifa lyaisogola akhomane ni taifa, na umwene na khomane no mwene. ");
INSERT INTO sbk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hwayibha na matesya amagosi agensi ne nzala ne tauni hwonti na mambo agatisye ne ishara engosi afume amwanya. ");
INSERT INTO sbk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lelo sagasele ego gonti afumire bhayibhakhata na bhavisye, bhayibhatwala hwitagalila eye mabhanza na bhaponye mwijela, natwalwe hwitagalila elya mwene na maliwali kwajili eyitawa lyane. ");
INSERT INTO sbk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na ego gayibha ushuda hwilimwe. ");
INSERT INTO sbk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Basi kusudiri humoyo genyu asinte asebhe sebhe asoti shambhajibu, ");
INSERT INTO sbk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","afwanaje ane embabhapele ilomu ne hekima ambaya atisi bhenyu bhonti sebhayiwezya abhashinde yape wala ayipinje. ");
INSERT INTO sbk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Namwe bhayibhalavya ayise bhenyu na horo bhenyu, na mwenyu ma rafiki bhenyu, wape bhayifisya bhamo bhamo. ");
INSERT INTO sbk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Namwe bhayibhavitu abhantu bhonti kwajili eyitawa lyane. ");
INSERT INTO sbk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lelo selyayite hata lisisi limo elye mmatwe genyu. ");
INSERT INTO sbk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Namwe gagole hwenyu mwayiziponia enafisi genyu. ");
INSERT INTO sbk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Lelo epo namwayilola iboma elye Yerusalemu lizyongolelwe na bhanajeshi esho mmanyaje eyaje anachishe hwakwe huparamiye. ");
INSERT INTO sbk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Esho bhabhali huyahuda na bhabhali pahati yakwe bhashembelelaje hwonze, na bhabhali humaganda bhaganjehujinjile. ");
INSERT INTO sbk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Afwanaje isiku ezyo zyazyo ezye shizanye ili gatinuziwe gonti gage. ");
INSERT INTO sbk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ole wabho abhe lwanda na bhabhahwosya katika ensiku ezyo afwanaje hwabha eshida nyinji mnsi nae ihasira juu ye taifa eli. ");
INSERT INTO sbk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bhayigwa hukhali owipanga wape bhayitekwa nyara na hwege katika amataifa gonti na eYerusalemu yayikhanywa na mataifa hata amajira age mataifa nagaitimiziwa. ");
INSERT INTO sbk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Antale hwaibha ishara hwisanya no mwezi ne ntondwe na mnsi amalabha aga mataifa, bhaiswiga huvumi owe nongwa na maklabha labha gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abhantu bhaivunjiha amoyo huwoga na ahwenyelezye amambo gehagaga ensi. Afwanaje amaha aga mwanya zyayinga. ");
INSERT INTO sbk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Epo esho pabhayihulola Umwana owa Adamu nahwenza mwibhengo pandwemo na maha no utukufu ogwinji. ");
INSERT INTO sbk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Basi amambo ego nagahwanda afumire changamhaji mbhosyaje amatwe genyu, afwanaje owaule wenyu uparamie.” ");
INSERT INTO sbk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wabhabhora ofwano, “Lyenyi ikwii na makwii agenje gonti. ");
INSERT INTO sbk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wakati nalimaliha apongore mlola na manye mwemwe yaje amajira oga konje gamalishe abha papepe. ");
INSERT INTO sbk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Namwe shesho namlola amambo ega gahwanda afumire manyaji yaje umwene owa Ngolobhe uli papepe. ");
INSERT INTO sbk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Amini, embabhora, eshikholo eshi seshashira hata ega gonti gatimile. ");
INSERT INTO sbk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Emwanya nensi zyaishila lelo amazu gane segaishira na mwaha. ");
INSERT INTO sbk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Eshi hwiyinyaji amogo genyu isibhe egalemewa no ulyavi, no ulevi, namasumbufu ege maisha ega. Isiku lila lyabhenzera nanari neshe atego shahwonza ");
INSERT INTO sbk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","afwanaje esho. Shashayibhenzara abhantu bhonti bhabhakhara pamaso gedunia yonti. ");
INSERT INTO sbk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eshi gonezyaji amwe shila wakati mlabhaje, ili mpate ahwaulwe katikaa ego gonti gagaifumira na hwemilele hwitagalila elya Mwana owa Adamu.” ");
INSERT INTO sbk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Esho shira pasanya abhanga asambelezya maibhanza na nosiku abharaga agone mwigamba lyalihwetwa Mizeituni. ");
INSERT INTO sbk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na bhantu bhonti bhali hadamla khasha bhabhara mwibhanza ili hutejezye. ");
INSERT INTO sbk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bhapamila shikulukulu eye makati yeseponyezewe echachu yehwetwa shukulukulu eye pasaka. ");
INSERT INTO sbk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na gosi abhemakohani na simbi bhali bhahwanza idara elya hugoje, afwanaje bhali bhabhogopa abhantu. ");
INSERT INTO sbk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oshetani wamwinjila o Yuda yakwiziwa Iskariote, wape wamwo na bhala ethenashala. ");
INSERT INTO sbk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wasogola wabhata wayanga na gosi abha makuhani na jemedari ejinsi sha bhawezye hubheshe mmakhono gabho. ");
INSERT INTO sbk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bhasongwa, bhetehana nawo hupele ehela. ");
INSERT INTO sbk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Weteha wanza enafasi eya husaliti hwabhahale pasepali obongono. ");
INSERT INTO sbk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yafishili isiku lye makati gasegaponyezeyea we echachu, ambayo yahanziwaga asinze epasaka. ");
INSERT INTO sbk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Wabhasontezya o Petro no Yohana, wayanga bhalaji mtilenganyizye epasaka tipata alye.” ");
INSERT INTO sbk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhabhola, “Uhwanza tibhale hwi?” ");
INSERT INTO sbk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wabhabhola, “Enya, nambhahwinjile mwibomba mbhatangane ulume akhete esonta owe menze. Mrundozyaje mbhahwinjile enyumba yabhahwinji omwahale. ");
INSERT INTO sbk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na mbhahubhula omwanesho nyumba, “Osambelezi ahubhola, ili hwii empanda eyajenyi, empate alye Epasaka omwo pandwemo na manyiziwa bhane?” ");
INSERT INTO sbk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wape abhabhalanje empanda engosi orufani, shimalishe asimbwe, lenganyi omwo.” ");
INSERT INTO sbk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wabhala, bhalola neshe shabhabholele bhayilenganya Epasaka. ");
INSERT INTO sbk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hata sala nayafiha akheye pashalye omwahale na bhala mitume pandwemo nawo. ");
INSERT INTO sbk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wabhabhola, “Entanianile tee ayilye epasaka ene pandwemo namwe sesele alabha hwane. ");
INSERT INTO sbk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Afwanaje embabhola eyaje sendya nantele hata nehaitimizya oumwene owa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yabha o Yesu wega shikombe, nawamala asaligwe wayanga, eji eshi na mgabhane, je mwemwe hwamwe. ");
INSERT INTO sbk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Afwanaje embabhola, sembamwele nantele papo eye mzabibu, mpaka umwene owa Ngolobhe nawayenza.” ");
INSERT INTO sbk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Esho wega ibumunda nali amalile asalifye waumesula, nabhele, wayanga, ogu ni bele gwane ambao ufumiziwe kwajili eyahuumwe. Bhombaji eshi anizushe ane.” ");
INSERT INTO sbk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wega eshikombe shesho shesho nabhalya eshaye esha nosiku wayanga, eshikombe ndagano epya ezya danda lyane ambalyo litishe kwa ajili yahulimwe. ");
INSERT INTO sbk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lelo enyaji ola yansaliti alipandwemo, nane pameza. ");
INSERT INTO sbk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Afwanaje mwana owa Adamu lyoli abhabhale neshe shekusudiwe lelo, Ole wakwe omntu ya husaliti!” ");
INSERT INTO sbk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bhandile abhozye bhebho hwa bhebho wenu miongoni mwabho ambaye agabhomba ijambo eli. ");
INSERT INTO sbk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Esho wafumila adalihane bhebho bhene aje wenu wase bhelelwe abhe gosi ashile bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wabhabhola, “Amwene abhabhantu abhemataifa bhana ugosi juu yabho na bhala bhabhali namamlaka juu yabho bhakwiziwa bhaheshimiwa bhalongozi. ");
INSERT INTO sbk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lelo sewanziwa abhesho hwilimwee amwe, ebadala yakwe leha ola ambaye gosi kati yahwilimwe abhe neshe ododu. Na ola yali wa mbimu tee abhe nenshe otumwa. ");
INSERT INTO sbk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Afwanaje yayolihu ogosi ola yakhala pameza nola yabhomba embombo? Eshi seyayola yakheye pameza? Na ane esele kati yenyu ane netumiaha. ");
INSERT INTO sbk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lelo amwe mwemwe mwendeleye abhanane kati amalabha gane au (alengwe). ");
INSERT INTO sbk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Embapela amwe umwene neshe shla Ubaba shampiye ane umwene, ");
INSERT INTO sbk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","je mpate alye na mwele pameza yane huumwene wane. Na mwikhala mmatengo age enzi mwaizilonga evikholo kumi na zibhele ezya Israeli. ");
INSERT INTO sbk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni, manya aje, Shetani alabhile abhaje ili abhapete nenshe engano. ");
INSERT INTO sbk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lelo embalabhiye, yaje olyeteho lyaho lugaje munwe, nawe nohaya ulya obhazenje oholo bhaho.” ");
INSERT INTO sbk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wabhola, “Gosi, nendi pandwemo nawe, ana endi tayali abhale mwijela au hata hufwe.” ");
INSERT INTO sbk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wayanga, “Ehubhola Petro, ehanda sebhakuje sanyono, sosele awe ahane mala hatatu eyaje somenye.” ");
INSERT INTO sbk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wabhabhozya eshi epo, nehabhasontezyezye semwali nifuko walu omkoba wala evilato, mwapongoshewe na hantu?” Bhayanga “Haa.” ");
INSERT INTO sbk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wabhabhola, lelo eshi yali nifuko ayeje wape yali nomkoba ayeje, wape yasagali ni panga, na akazye ijoo lyakwe akale. ");
INSERT INTO sbk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Afwanaje embabhola, ega gagasimbiwiwe segali ne budi atimiziwe hwiline, eyaje abhaziwe pandwemo nebho bhanankanya, afwanaje ewasiwa gali nomalishilo wakwe.” ");
INSERT INTO sbk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhayanga, “Gosi, enya! Epa gahwili amapanga gabhele.” Wene. ");
INSERT INTO sbk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wafuma wabhala mpaka mwigamba elya Mzietuni enshe ekawaida yakwe, asambeleziwa bhakwe bhape bhalongozanya nawo. ");
INSERT INTO sbk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nawafiha pala abhabholele, labhaji aje mganji ahwinji mndengo. ");
INSERT INTO sbk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Omwahale wahwibagula nabho nenshe kias esha ponye iwe, wafugamila amafugamo watabha, ");
INSERT INTO sbk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ayanga, “Ee Baba, nkashele mapenzi gaho, onefwezye eshikombe eshi lelo senapenzi gane, eshi gahuliwe gabhombeshe.” ");
INSERT INTO sbk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Omalaika afume amwanya wafumila wapela amaha. ");
INSERT INTO sbk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wape shila shali mmalabha, wonjezya alabhe tee, ehali yakwe yabha nenshe amalavula age danda galagala pansi. ");
INSERT INTO sbk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nawasogola hula alabhe hwakwe wabhalila asambelezewa bhakwe, wabhaga bhagonile otulo ogwa kogobhale, ");
INSERT INTO sbk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","wabhabhora, yenu mgonile otulo? Ogoli, mlabhe msahabha ahwinjile mndengo.' ");
INSERT INTO sbk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Basi nahali katika ayanje, enya obongano wa bhantu, nola yakwiziwa Yuda, ambaye ni moja yabhala mitume abhatagali hwitagalila wapalamila hwa Yesu ili ayayile. ");
INSERT INTO sbk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","o Yesu wabhola, “Yuda, wamsaliti omwana owa Adamu esha huyayile?” ");
INSERT INTO sbk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na bhala bhabhali papepe nawo nbhalola gagafumila, bhayanga, “Gosi, tibhakhoma na mapanga”? ");
INSERT INTO sbk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Omo wabho wakhoma obhomba mbombo wa kuhani gosi, wadumla ikutu elya hulero. ");
INSERT INTO sbk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","U Yesu wagalula woyanga, “Bhanji hulu hweli. Wapalamasya ikutu waponia. ");
INSERT INTO sbk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","U Yesu wabhabhola agosi bhemakuhani, na maakida abhibhanza, nazee bhebhenzele juu yakwe, “Eshi mwenzele mweli na mapanga nu ndugu nensheje mkhata ya fyola? ");
INSERT INTO sbk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Shila lisiku nali pandwomo namwe mwibhanza semwasontezyezye amakhono lelo ene ndiyo sala yenyu. Lakini hii ni saa yako, na mamlaka age nkisi. ");
INSERT INTO sbk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bhakhata, bhamwega, bhabhala nawo munyumba eya kuhani ogosi. Nu Petro alondolelaga sahutali. ");
INSERT INTO sbk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nabhamalile ahwasya omwoto pahati eye shibhanja bhakheye pandwemo, wape u Petro akheye nabho. ");
INSERT INTO sbk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ndipo obhomba mbombo omo walola akheye papalabha, walangulila amaso wayanga nono ali pandwemo nawo. ");
INSERT INTO sbk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wakhana, wayanga, ee, she, semenye. ");
INSERT INTO sbk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pamanda hashe, omuntu owamwabho alolile wayanga, Petro wanyanga, “Ee mntu, se nene.” ");
INSERT INTO sbk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Antele lyashita isala limo, omntu owamwabho wakasa ayanje, “Lyoli ono ali pandwemo nawo afwanaje omwahale nantele Mgalilaya.” ");
INSERT INTO sbk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petro wayanga, “Ee mntu, sendimenye lyo yanga.” Na pepo, pepo nali katika ayanje, ehanda ahakujile. ");
INSERT INTO sbk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gosi wagaluha wamwenya u Petro. U Petro walizuha lila izu elya Gosi, ejinsi shabholele, “Sanyono sesele akuje ehanda obhahane mala hatatu.” ");
INSERT INTO sbk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wafuma hwonze waula humansai. ");
INSERT INTO sbk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na bhala bhantu bhali bhahukhata u Yesu, bhabhombile edhihaka bhakhoma. ");
INSERT INTO sbk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhavwenesya amaso, bhanda hubhozye, bhozye bhayanga, kuwa wenu yakhonule?” ");
INSERT INTO sbk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bhafumizya nengwa mwabho nyinji gahuliji. ");
INSERT INTO sbk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hata nahwashiye, bhatangene amwabho abheshi gosi, na gosi abhe makuhani nusimbi bhateta mwikoloti lyabho bhayanga, ");
INSERT INTO sbk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","nkashile, “Awe wa Klisiti, tibhole.” Wabhabhola ewapo embabhola, semuwezizya ahweteshele tee, ");
INSERT INTO sbk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nkashele mbabhozye sembhagalule.” ");
INSERT INTO sbk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lelo ahwanda eshi na hwendele, Omwana owa Adamu abhabhe akheye okhono ondelo ogwe maha aga Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhonti bhayanga, “Eshi awe oli Mwana wa Ngolobhe?” Na Yesu wabhabhola, “Amwe myanjile ane nene.” ");
INSERT INTO sbk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bhayanga, “Yesnu tihwanza nantele oushahidi afwanaje ate tete tovwezya afume mwilomu lyakwe yoyo.” ");
INSERT INTO sbk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bhemelela obungano gwonti, bhatwala hwa Pilato. ");
INSERT INTO sbk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhandile hutake, bhayanga, “Tilolile ono natezya itaifa lyetu na bhazubhile abhantu bhagaje hupele Okaisari, esonga ayanjile eyaje omwhale yoyo ni Klisiti, Mwene.” ");
INSERT INTO sbk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato wabhozya, wayanga, “Awe wewe omwene Owayahudi?” Wagalula wabhabhola, “Awe wayanga.” ");
INSERT INTO sbk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato wabhola agosi abhemakohani na mabungono, “Sendilola izu lyalili libhibhi hwa mntu ono”. ");
INSERT INTO sbk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wape bhahwikazile sana, bhayanga, “Abhasonje sonje abhantu, amanyizyaga evyahudi yonti, afume Galilaya mpaka ohu.” ");
INSERT INTO sbk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","U Pilato nawovwa ego abhozyezye nkashele ono mntu wa Hugalilaya? ");
INSERT INTO sbk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na apete enongwa eyaje alichini wa Herode, atwalile wa Herode, afwanaje omwahale wape ahali hu Yerusalemu ensiku ezyo. ");
INSERT INTO sbk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na Herode nalolile u Yesu ashimile tee afwanaje ali ahwanza tee hulole afume ensiku nyinji. Afwane nesho ayovwezye enongwe zyakwe, wasobhela alole ishala yebhambilwe nomwahale. ");
INSERT INTO sbk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wabhozya enongwa nyinji omwahale sewagalulo lyalyonti. ");
INSERT INTO sbk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Agosi abhemakuhani na simbi bhimelela bhataka humaha gonti. ");
INSERT INTO sbk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Basi Herode wabhombo lema, pandwemo na sikali bhakwe, wasolanya na wakwalizye amenda amenza, esho wawezye hwa Pilato. ");
INSERT INTO sbk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Basi isiku lila Herode na Pilato bhakonde ne abhe lafiki afwanaje epo ahwanda bhali bhavisenye bhebho hwe bhebho. ");
INSERT INTO sbk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Pilato wabhatanya agosi wa makuhani na gosi na bhantu, ");
INSERT INTO sbk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Wabhola, “Mntu ono mletile hwiline nensheje atezyo abhantu nane enyaa, enamuye amambo gakwe hwitagalila lyenyu, ka sendilolile hwamwahale ikosa lyalyonti katika enongwa zya mtakile. ");
INSERT INTO sbk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala, hata o Herode, nkashile awezizye hwilite basi enyua, sagalilole enongwa yayonti lyabhombile lyali hwanziwa aje afwanje. ");
INSERT INTO sbk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Esho basi embahuwelele nahumwalule. ");
INSERT INTO sbk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Esho, Pilato yukazimisizye humwaulile ofungwa omo isiku elye esikulukulu). ");
INSERT INTO sbk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bhahwaga ibwago wonti pandwemo bhayanga, “Mwefwe ono, otuulile o Baraba!” ");
INSERT INTO sbk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wape mntu watagwelwe mwijele kwaji fitina efumile hwiboma, kwajili yengoga. ");
INSERT INTO sbk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Basi Pilato wayanga nabho mala habhele hushila shanzaga humwaulile u Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lelo bhabwaga ibwago, bhayanga, “Msulubishe, msulubishe.” ");
INSERT INTO sbk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wabhola emala eyatatu, afwane wele, ono abhombile mabhibhi wele, sendolile hwamwahale enongwa zyazihwanziwa aje afwe, basi nkashele na welela embahumwaile.” ");
INSERT INTO sbk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lelo bhafumia amazu hunguvu zyonti, bhabhabha asulubiwe. Amazu gabho gamena. ");
INSERT INTO sbk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato walonga aje gabhahwunza gubhombeshe. ");
INSERT INTO sbk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wamwaula ola yabhatajile mwisela kwajili eyefilina nu negoga, ola yabhamwanzaga wafumia o Yesu bhabhombele shabhahwanza. ");
INSERT INTO sbk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nabhalai bhahusogotya, bhakhatu omntu omo, o Simoni Omkirene, ali afumile hugonda bhalweha ikhobhanyo aweje hwikhosi lyakwe u Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Obungano ogosi owabhantu bhalondolela na bhashe bhabhali bhahikhoma evifubha na huzundelele. ");
INSERT INTO sbk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","U Yesu wabhagulushila wayanga amwe mwalendu abhahu Yerusalemu, msuhandilele ane, shwililasi enafsi zyenu na bhana bhenyu. ");
INSERT INTO sbk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Eshi, enyi ensiku zihwenze nabhayinga hafu bhabhuli bhagumba nufyanda vyao vyase vipapa na mabhelo ga segahwosya. ");
INSERT INTO sbk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Esho nabhayanda agabhozye amagamba tigweleli notugamba tigubekayi. ");
INSERT INTO sbk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Afwanaje nkashile bhabhomba amambo ega hwikwi ilyoro, ebhabhe wele hwilyo?” ");
INSERT INTO sbk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bhatwala bhabhele abhamwabho abhe makasa bhabudwe pandwemo nuwo. ");
INSERT INTO sbk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nabhafishile pamopame papa kwiziwa Fuvu litwe, epo pasulubisizye omwahale panda wemo ba bhemakosa omo oupande owendelo omo opande omongo. ");
INSERT INTO sbk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","U Yesu waga, “Baba, ubhasajile afwanaje sebhemenge lyabhabhomba bhagabhanya amenda gakwe, bhakhoma ekora. ");
INSERT INTO sbk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abhantu bhemelela bhenye bhala agosi bhape bhabhombela ezalau, bhayanga, “Ahauye abhanje. Ahwiyu ule yoyo nkashile yu Klisiti owa Ngolobhe oteule wakwe.” ");
INSERT INTO sbk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bhala asikali bhape bhazalale bhabhalila nu huletele esiki, ");
INSERT INTO sbk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ohu bhayanga nkashile awe oli mwene owa yahudi, hwiyaule umwene” ");
INSERT INTO sbk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pamwanya yakwe pali amandishi, “ONO NDIYO MWENE WA MWENE WAYAHUDI.” ");
INSERT INTO sbk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nomo owabhala owikosa yabhakhomeleye aujile, wayanga, “Eshi awe sagawe Klisiti? Hwiyaule enafsi yuho nute.” ");
INSERT INTO sbk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lelo ula owabhele wagalula waidamila wayanga, “Awe sohwumwogopa hata Ongolobhe, nawe olimundongo zyezyo? ");
INSERT INTO sbk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gape gelyoli hwaliti atee, afwanaje tipewa oshahara gwetu, gwaguhwanziwa humamba getu. Eshi ono sabhombile lyalyonti lyasaga ufaa.” ");
INSERT INTO sbk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Basi wayanga, “Yesu, onizushe nawayinjila humwene waho.” ");
INSERT INTO sbk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","U Yesu wabhola, “Eteha, ehubhola, sanyono eshi onzubha pandwemo nane Paradiso.” ");
INSERT INTO sbk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Epo yuli efishile esala eya saa sita, yabha nkisi juu ya pasi ponti hadi saa tisa, ");
INSERT INTO sbk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","esanya lipongoshe okhozyo lwakwe, elyenda elye shibhanza lyazembuha paha. ");
INSERT INTO sbk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","U Yesu walila hwizu igosi, wayanga, “Baba makhono gaho, enjibheha eroho yane,” Na wamala ayanje ego wadumula eroho. ");
INSERT INTO sbk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ula Oakida nuwalula gagafumie atukuzizye Ongolobhe, wayanga, “Lyoli omntu ono aliwelyoli.” ");
INSERT INTO sbk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na mubungano gonti ega bhantu bhabhali bhabhungene ahwenye amambo ego nabhalolile gagabhombeshe bhabhala amwabho bhahwi khoma khoma evifubha. ");
INSERT INTO sbk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nabhonti bhamanye nawo na bhala abhashe bhalongozenye nawo afume Hugalilaya, bhemelela sahutuli, bhahwenga amambo ego. ");
INSERT INTO sbk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na enya wafumila omntu omo itawa lyakwe yo Yusufu, ambaye mntu wa hwikolo ti, omntu, omwinza owe lyoli, ");
INSERT INTO sbk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Wala saga alyeteshe ishauli lyabho), wape mntu wa Armathaya, iboma elya yahudi, antele awenyelezya umwene owa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Omntu oyo abhalile huwa Pilato, ahanzaga apewa obele gwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wagwisya wagubwenesya esanda yakitani waubhaha mwakaburi lyalibenwe paka pansi, lyelyali sabhe hwelwe omntu mhati yakwe. ");
INSERT INTO sbk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na isiku lila lyali lisiku elye mandalizi, elyatoye lyanda ahwinjile. ");
INSERT INTO sbk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nabhala abhashe, bhahenzele nawo afume Hugalilaya bhalondoleye, bhayilola inkongwa na bele gwakwe sagwabhehwelwe. ");
INSERT INTO sbk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bhawela bhabhomba tayali anukato na marashi. Ni siku elyatoye bhamile neshi shabhamuye. ");
INSERT INTO sbk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hata isiku elyahwanda elye longo, nalyahandaga asha, bhabhalile hunkongwa bhatwali amanukato gabhabheshele tayali. ");
INSERT INTO sbk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhalyaga ula iwe liungulusiwe patali ne nkongwe. ");
INSERT INTO sbk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bhinjila sebhagulola obele gwa Gosi o Yesu. ");
INSERT INTO sbk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yabha napali bhakongobhala kwajili eizu elyo, enya, abhantu bhahemeleye papepe nabho, bhakwete amenda galangasala ngasa. ");
INSERT INTO sbk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bhape nabhinjila nowoga bhinama kifudifudi hata pamankondi, ebho bhabhabholele, yenu mhumwanza yali mwomi hwabhafwe? ");
INSERT INTO sbk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nomo epa, azyoshele! izuhaji shayanjile namwe nali ahweli Hugalilaya, ");
INSERT INTO sbk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ayanjile aynziwe omwana owa Adamu akhatwa namakhono ga bhala abhe dhambe na asulubiwe, na zyoshe isiku elya tatu.” ");
INSERT INTO sbk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bhagizuha amazu gakwe, ");
INSERT INTO sbk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bhasogola hunkongwa bhawela bhabhabhola bhala kumi na bhumwabho bhonti enongwa ezye mambo ego gonti. ");
INSERT INTO sbk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bhape yo Maria Magdalena, no Joana, no Maria onyina Yakobo, na bhala abhashe bhamwabho bhabhali pandwemo nabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ebho bhabhabholele asontezewa enongwa eye mambo ego, enongwa zyabho zyabhoneshe ajezye walangani hwabhahee wala sebhabhetesheye. ");
INSERT INTO sbk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lelo o Petro asogoye abhalile sashembela paka hunkongwa, waundama wagodezya mhati, wavilola vila evitambala evya sanda vyene. Wahwibhali saswiga gagafumie. ");
INSERT INTO sbk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na enya, isiku lilila abhantu bhabhele miongoni mwabho bhali bhabhala hu shijiji shimo itawa lyakwe Emmau, sha shali hutali ne Yerusalemu neshe ajende amasala gabhele. ");
INSERT INTO sbk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wape bhali bhayanga bhebho hwa bhebho enongwa ezye amambo ego gonti gagafumie. ");
INSERT INTO sbk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yabha katika ayanje na bhozanye hwabho, u Yesu yoyo wapalamila walongozanya nabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amaso gabho gafumbwa sebhamanya. ");
INSERT INTO sbk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Wabhabhola, “Nongwa wele ezi zyamuyanga eshi namjenda?” Bhemelela bhapinta humaso gabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","wagalula omo wabho, itawa lyakwe yo Kleopa, wabhola, “Je awe umwene olijenyi pa Yerusalemu hata sogamenye gagafumiye omwo ensiku ezi? ");
INSERT INTO sbk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","U Yesu wabhozya, “Mambo genu?” bhabhola, “Mambo aga Yesu owa Hunazareti, yali mntu kuwa, yalinowezo abhombe na yanje hwitagalila elya Ngolobhe nahwabhantu bhonti. ");
INSERT INTO sbk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nantele ejinsi agosi abhe makuhani na gosi abhabhantu shabhakhete na hulonje aje afwe bhasulubisya. ");
INSERT INTO sbk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nate halititegemele lyaje omwahale yabhabhe wabhaule Israeli. Zaidi eyego gonti sanyono elya tatu afume nagabhombesha amambo ago. ");
INSERT INTO sbk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Antele abhashe bhamo bhamo abhamwetu bhatisitusizye, bhabhalile hunkonge wa sapwiti khasha. ");
INSERT INTO sbk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sabhagulolile obele gwakwe, bhenza bhayanga yaje abhatokeye omalaika bhabhayanjile aje mwomi. ");
INSERT INTO sbk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na bhamwabho bhabhali pandwemo natee bhabhala hunkongwa bhalola shesho nenshe bhala abhashe shabhayanjile. Aje omwahale sebhalolile. ");
INSERT INTO sbk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wabhabhola, “Amwe mwesemmanya mwemli na moyo amamwamu aga hweteshe gonti gabhayanjile akuwa. ");
INSERT INTO sbk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eshi seyanziwaga Klisiti apate amalabha ego na hwinjile katika oufukufu wakwe?” ");
INSERT INTO sbk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wanda afume wa Musa na kuwa bhoonti, wabhabhola mnsimbo gonti amambo gagahuhusu omwahale yoyo. ");
INSERT INTO sbk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bhapalamila shila eshijiji shabhabhalaga, wape abhombile nenshe aje ahwanza ahwendele hwitagalila. ");
INSERT INTO sbk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bhayanga nawo, “Khala pandwemo nate, afwanaje isanya liswiye na usanya umalishe winjilo mhati akhale nabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yabha nawakhula nabho pashalye, wega ikati, wasaya, waumesula, wabhapela. ");
INSERT INTO sbk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Gadamla amaso gabho bhamanya, esho watega hwitagalila lyabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhabholana, “Je amoyo getu seguhashile mhati yetu, ipo nali ayanga nate mwidala, natigulile ensimbo?” ");
INSERT INTO sbk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bhasogola esaa yeyo, bhawela Huyerusalemu. bhabhaga bhale kumi na moja bhatangene abhahale bhala bhali pandwemo nabhahale, ");
INSERT INTO sbk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bhayanga, “Ogosi azyoshele lyoli lyoli, wape abhoneshe hwa Simoni.” ");
INSERT INTO sbk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bhape bhabhapela enongwa ezye mambo aga mwidala ne jinsi shamanyishe abho katika amesule ikati. ");
INSERT INTO sbk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na bhali katika ayanje enongwa zyo yoyo mwenyewe ahemeleye pahati yabho, wabhabhola, “Amani ebhe namwe.” ");
INSERT INTO sbk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhasituha bhogopa tee, bhaseha aje bhalola roho. ");
INSERT INTO sbk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wabhabhola, mbona mkogobhala? Na yenu mlola ewasiwasi humoyo genyu? ");
INSERT INTO sbk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Enyi amakhono gane na manama gone, yaje nene mwenyewe, hatikati, mlole afwanaje eroho seli nobele wa amafupa nenshe namundova ane aje endi nagwo.” ");
INSERT INTO sbk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Na wayanga ego wabhalanga amakhono gakwe na magaga gakwe. ");
INSERT INTO sbk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Basi nabhali sebhetesheye ashe, ohubhaswiga, abhabholele, mli neshalye shashonti epe? ");
INSERT INTO sbk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","wapela eshipande eshe samaki wa kuokwa. ");
INSERT INTO sbk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wege, walya hwitagalila lyabho. ");
INSERT INTO sbk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Esho wabhabhola, “Ego gagego amazugane gahabhabholele nanali endipandwemo namwe, eyaje ni lazima gatimile gonti gehasibwilwe katika torati eya Musa na ga kuwa ne Zaburi.” ");
INSERT INTO sbk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Esho wabhalanga enjele zyabho bhapate ahwelewe ensimbo. ");
INSERT INTO sbk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wabhabhola, “Shasho shahasimbwilwe, eyaje Klisiti lazima ateseke, na fufushe isiku elya tatu. ");
INSERT INTO sbk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naje amataifa gonti gailombelelwa hwitawa lyakwe enongwa ezye tebona hwefwezyewe edhambi ahwanda afume Myerusalemu. ");
INSERT INTO sbk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Namwe mwemli bhashahiji abhe mambo ega. ");
INSERT INTO sbk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na enya, embaletela juu yenyu ehadi eya Baba wane, lelo khalaji omu mwiboma, hata mvwenehwe oweza afume amwanya. ");
INSERT INTO sbk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Walongozya mpaka Bethania. Wabhosya amakhono gakwe wabhasayila. ");
INSERT INTO sbk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yabha katika abhasayile, wahwibagula nabho, wegwa amwanya ambinguni. ");
INSERT INTO sbk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bhaputa, esho bhawela Huyerusalemu bhabhali nashime ohu gosi. ");
INSERT INTO sbk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bhape bhali bhakheye mhati mwibhanza, na husifu Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hula ahwande hwa hali izu lyali pamo no Ngolobhe, izu ali yo Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eli, Ezu, Nalya handaga lyali pamo no Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Evintu vyonti vyabhombeshe ashilile omwene, asibhe omweje na hamo ata hantu hamo hahabhombeshe. ");
INSERT INTO sbk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Muhati yakwe mwali no womi, na wope owomi wali lukhozyo lwa bhantu bhonti. ");
INSERT INTO sbk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Olukhozyo lwakholaga munkisi, enkisi yapotilwe aluzimye. ");
INSERT INTO sbk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pahali omuntu watumwilwe afume hwa Ngolobhe, ola itawa lyakwe ali yo Yohana. ");
INSERT INTO sbk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ahanzele nanshi keeti ahakikisye ahusu olukhozyo, aje bhonti nkabhapate ahweteshele ashilile hwamwene. ");
INSERT INTO sbk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","O Yohana sagali lukhozyo, ila ahenzele nkahakikisye ahusu lula olukozyo. ");
INSERT INTO sbk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Esho alilukhozyo lwelyoli lula lwalwahenzaga munsi lyope lwapanga shila muntu. ");
INSERT INTO sbk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","munsi, na ensi yabhombwelwe ashilile omwahale, na ensi seyamenye. ");
INSERT INTO sbk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ahaenzele hwabhantu bhakwe, na awantu wakwe na abhantu wakwe sebhaposheye. ");
INSERT INTO sbk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ila hwabhala abhinji bhabhaposheye, bhabhahetesheye itawa lyakwe, nebho abhapiye elyoli eyaje bhana bha Ngolobhe, ");
INSERT INTO sbk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bhabhapepwe, se hwidanda, wala hulusongwo lwe bele, sio olusongwo lwa muntu, ila lwa Ngolobhe yoyo. ");
INSERT INTO sbk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lyope izu lyabhoshe lwebele na lyakhala muhati yeetu, tiulolile oumwamu wakwe, oumwamu nashi wa muntu mwene wahenzele afume hwa Daada, amemile uwene ne lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O Yohana ahakikizye ahusu omwene, na afumizye izu ayanje, “Ono yayola wanayanjile enongwa zyakwe najile, “Ola wayenza pamande yane yo gosi ashile ane, afuatanaje ahali kabla yaline.” ");
INSERT INTO sbk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Afuatanaje ashilile oluu golosu lwake, ate tenti tiposheye wene eshipawa baadaye shipawa. ");
INSERT INTO sbk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Afuatanaje endajizo zyaliletilwe ashilile oMusa. Ewene ne lyoli vyahenzele ashilile oYesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nomo omuntu walolile Ongolobhe omuda gwagwonti. Omuntu mwene ambayo yo Ngolobhe, walipashifubha sha Daada, abhombile aje omwene amanyishe. ");
INSERT INTO sbk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na olu luhakikisyo lwa Yohana lula adimi na lawi bhabhatumwilwe hwa mwene na Yahudi ahubhozye, “Aje awe wenanu?” ");
INSERT INTO sbk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bila asyoshe syoshe saga akhene, aje “Anesene Kilisiti.” ");
INSERT INTO sbk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Esho bhabhaozyezye, “eshi awe we nanu esalezi?” We Eliya? Ajile, “Ane see yayoyo.” Wajile we kuwaa? Ajile,” Hagha.” ");
INSERT INTO sbk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Antele bhabhozya, “Wee nanu, aje nkati bhapele ijibu bhabhatitumile”? Uhwihakikisya bhole wewe humwene?” ");
INSERT INTO sbk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Waga, “Ane ne lizu lyakwe walila mwipoli: 'Golosyaji idala lya Ngolobhe,' na okuwa oIsaya shayanjile.” ");
INSERT INTO sbk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Eshi bhahali abhantu bhatumwile na Mafalisayo. Bhabhozyezya aje, ");
INSERT INTO sbk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Yenu ohwozya eshi nkashewe Kilisiti wala see we Eliya okuwaa?” ");
INSERT INTO sbk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O Yohana abhabhozyezye ajile, “Embozya hu menze. Ata sheshi mhati yenyu ahwemelela omuntu wa semumenye amwe. ");
INSERT INTO sbk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Onu ndiyo wanzahwenze pamande yaline. Ane sihwanziwa alegezye ekamba zye vilato.” ");
INSERT INTO sbk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Enongwa ezi zyabhombeshe ohwo hu Bethania, hwisyela lye Yordani, esehemu ambayo oYohana alihwozya. ");
INSERT INTO sbk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Isiku lyalyafwatile oYohana alolile uYesu ahwenza hwa mwene ajile, “Enya mwanangole wa Ngolobhe wahwega embibhi zya munsi! ");
INSERT INTO sbk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ono yayola wana yanjile enongwa zyakwe najile, “Omwene wayenza hwi akhosi yane yo gosi ashile ane, afwatanaje ali hwitazi lyaline.' ");
INSERT INTO sbk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Senamenye omwene, ila shabhombeshe esho aje nkobheneshe mu Israeli, aje nahenzele nabhozyaga na menze.” ");
INSERT INTO sbk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","O Yohana ahakikisizye, “Aje nalolile Ompepo ahwiha afume amwanya ofwana ngwe njebha, yasageye pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ane senamenye ila omwene wantumile aje enozyaje na menze ambozyezye, 'ola wobhalole empempo ehwiha na khale pamwanya yakwe, Oyo waibhozya hwo Mpepo Ofinjile.' ");
INSERT INTO sbk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Endolile na ehakikisizye aje ono Mwana wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nantele isiku lyalyafuatile oYohana ali ayemeleye pandwemo na bhanafunzi bhakwe bhabhele, ");
INSERT INTO sbk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bhalolile oYesu ajenda no Yohana ajile, “Enyaji, Omwana ngole wa Ngolobhe!” ");
INSERT INTO sbk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","bhabhele bhamwonvwezye oYohana nayanga ega bhafuatile oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nantele oYesu agalushe na bhalole abhanafunzi bhala bhahulondolela, nabhabhozye, “Mhwanza yenu?” Bhajile, “Labi, (emaana yakwe 'mwalimu,' ukhala hwii?” ");
INSERT INTO sbk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wabhabhozya, “Enzaji mulole.”Nantele bhabhalile alole pale pakhalaga; bhakheye pamo nawo isiku elyo, afwatanaje yali efishile saa kumi eshi. ");
INSERT INTO sbk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Omomo wa bhala bhabhele bhabhamwonvwezye oYohana nayanga nantele bhafwatile oYesu ali yo Andeleya, oholo wakwe oSimoni Petulo. ");
INSERT INTO sbk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Alolile oholo wakwe oSimoni omwana nahubhozye, “Tipete Omasihi” (maana yakwe Kilisiti). ");
INSERT INTO sbk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bhaleta hwa Yesu. O Yesu amwezi na ajile, “Awe we Simoni omwana wa Yohana” obhakwiziwe Kefa,” (maana yakwe 'Petulo'). ");
INSERT INTO sbk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Isiku lyalyafuatile oYesu lwahanzaga asogole abhale huGalilaya, amwajile oFilipo na hubhozye, “Nfwate ane.” ");
INSERT INTO sbk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Filipo ali khaya wa hu Bethsaida, ekhaya ya Andrea no Petulo. ");
INSERT INTO sbk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O Filipo amwajile o Nathanaeli na hubhozye aje timwajile ola oMusa wa handishe enongwa zyakwe mu ndajizyo na Kuwaa. O Yesu omwana wa Yusufu, afume hu Nazareti. ");
INSERT INTO sbk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","O Nathanaeli abhozyezye, “Aje ahantu ahinza hawezizye afumile hu Nazareti?” O Filipo abhozezye, Aje enzaga olole.” ");
INSERT INTO sbk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","U Yesu walola oNathanaeli ahwenza hwa mwene wayanga, “Waga oyenye Omwisraeli welyoli lyoli wasaga ali nilenka muhati yakwe!” ");
INSERT INTO sbk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","O Nathanaeli wabhozya, “Amenyebhole ane?” O Yesu wabhozya, “Salisele oFilipo ahukwizye nawahali pansi yikwi.” ");
INSERT INTO sbk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","O Nathanaeli wayanga, “Waga Mwalimu awe oli Mwana wa Ngolobhe! Awe oli mwene we Wisraeli”! ");
INSERT INTO sbk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O Yesu wayanag wabhozya, “Aje afuatanaje nabhozezye 'nalilolile pansi yikwi aje ohweteshele obhalole embombo engosi ashile ezi.” ");
INSERT INTO sbk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","O Yesu wabhabhozya aje eteshile etesheli embabho lya mubhazilole emwonya zihwiguha, mubhabhalole ahalozelu wazubha na hwishe amwanya hwa Mwana wa Adamu.” ");
INSERT INTO sbk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baada ye nsiku zitatu, hwa ne harusi ohwo hukana ye Galilaya no nyina wakwe oYesu ali ohwo. ");
INSERT INTO sbk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","O Yesu na bhanafunzi bhakwe bhali bhalihwe hu harusi. ");
INSERT INTO sbk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lwabhamali shelwe ne divai, onyina wakwe oYesu abhozezye, “Sebhali ne divai.” ");
INSERT INTO sbk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","O Yesu ajile, “Oshe oyo ego ane gahusu yenu ane? Ensiku zyane anezilisele afishile.” ");
INSERT INTO sbk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Onyina wakwe abhabhozezye atumwa, “Hahonti hanzabhabhozye bhombaji.” ");
INSERT INTO sbk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Eshi hwali ne nsonta sita zye mawe pala pabhele pa nawe munsikulukulu zya Yahudi, shila muntu ali noumemuwe nzio zibhele zitatu. ");
INSERT INTO sbk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O Yesu wabhawozya, “Zimemyi amenze ensonta mawe.” Bhamemeya bhamememya paka pamwanya. ");
INSERT INTO sbk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nantele wabhabhozya bhala aboyieji, “Hashe esalezi mtulwe hwa bhabhahudumu agosi bhe meza.” Bhabhomba nanshi shalibhalajiziwe. ");
INSERT INTO sbk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ohudumu ogosi abhonjile gala amenze gagali gabadilishe abhe divai, ila sagamenye hwagafumaga (ila atumwa watapaga amenze bhagamenye hwa gafumaga). Pamande bhakwizya omwene harusi na ");
INSERT INTO sbk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hubhozye, “Kila muntu ahwanda abhahudumile abhantu edivai ila sebhagamenye. Abhapele bhabhapiye edivai yasaga nyinza” ");
INSERT INTO sbk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Oujiza ogugwa hu Kana ya Galilaya, gwali gwa hwande gweshimanyilo uujiza gwa bhombile oYesu, akwinkule oumwamu wakwe, esho abhanafunzi bhakwe bhamwetesheye. ");
INSERT INTO sbk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baada yene, oYesu, onyina wakwe, aholo wakwe na wanafunzi bhakwe bhabhalile hunsi ye Kaperanaumu na bhakheye ohwo ensiku ndodo. ");
INSERT INTO sbk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Epasaka ya Bhayahudi yali epalamiye afishe, oYesu abhalile hu Yelusalemu. ");
INSERT INTO sbk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Abhajile bhabhakazya eng'ombe, engole ne njebha Mshibhanza. Nantele na wabadilisha fedha walikuwa wameketi ndani ya Hekalu. ");
INSERT INTO sbk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","akatengeza mjeledi wenye vifundo, akawatoa wote walikuwemo katika hekalu, ikijumuisha ng'ombe na kondoo. Nabhavunzilanaga ehela na zigaluzanye emeza zyabho. ");
INSERT INTO sbk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bhabhakazya enjebha abhabhozezye, “Efwi evintu vyenye bheshi hutali nepa, leshi abheshe ibhanza lya Ngolobhe pakazizye.” ");
INSERT INTO sbk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abhanafunzi bhakwe bhakomboha aje ehandihwe, “Owivu we nyumba yaho waindya.” ");
INSERT INTO sbk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Agosi bheshi Yahudi bhajile, shimanyilo bhole shawaiilanga alengane nambo ega gebhomba?” ");
INSERT INTO sbk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","O Yesu wayanga, libomoli ibhanza eli nane embalizenje hunsiku zitatu.” ");
INSERT INTO sbk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Agosi bha Yahudi bhayanga, “Wagatabhombile amah alobaini na sita awe oiga ubhazenje hunsiku zitatu?” ");
INSERT INTO sbk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Japo, omwa ayanjile iwanza ayanjilaga obele gwakwe. ");
INSERT INTO sbk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Esho pamande nkawafufuha afume hwa bhafwe, abhanafunzi wakwe bhakomboha aje ayanjile esho, weteshela izu ne njango ene o Yesu yatanguliye ayanje. ");
INSERT INTO sbk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lwa hali hu Yelusalemu owakati wa Pasaka, owakati we shikulukulu abhantu abhinji bhalyetesheye itawa lyakwe, na bhaloliwe embembo zya bhombaga. ");
INSERT INTO sbk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ila oYesu saga abheteshe afuatanaje abhamanye awantu bhonti. ");
INSERT INTO sbk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sagahanzaga omuntu wawonti ahubhozye alengane ne shabhali awantu afuatanaje amenye hahali muhati yabho. ");
INSERT INTO sbk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hwa hali omuntu oFalisayo itawa aliyo Nikodemo, wali jumbe mwibaraza lya Yahudi. ");
INSERT INTO sbk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Omuntu abhaliye Ogosi oYesu na hubhozye nabi timenye aje awe oli mwalimwa afume hwa Ngolobhe, afuataje nomo umuntu wagabhombe ezi zyo bhomba awe paka abhanje nawe.” ");
INSERT INTO sbk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O Yesu ajile, “Atesheli, atesheli, umuntu sawezizye ahwinjile amwanya paka apapwe emara yabhele.” ");
INSERT INTO sbk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O Nikodemo ajile, “Agapapwa bhole wakati endi gogolo? Sawezizye ahwinjile muvianda mwa nyina wakwe emara ya bhele, na papwe shigabha?” ");
INSERT INTO sbk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","O Yesu ajile etesheli etesheli umuntu nkasaga papwe humenze na hu Mpepo, sawazizye ahwinjile hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hahapepwe hubele hubele, hahapepwe husi Loho heshiroho. ");
INSERT INTO sbk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ungaje aswije shanabhozezye, 'lazima apape emara ya bhele.' ");
INSERT INTO sbk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ehala evugula hwahonti hwehwanza abhale izu lyakwe mliovwa, ila semuhwelewa hwefuma wala ata hwebhala sashili ehali ya wantu bhabhapepwe hushiroho. ");
INSERT INTO sbk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","O Nikodemo ajile, nayanje, Enongwa iziu ziwezehena?” ");
INSERT INTO sbk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","O Yesu ajile, “Awe oli mwalimwa we Israeli, sogamenye amambo ega? ");
INSERT INTO sbk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eteshela, eteshela, ehubhozya hala hati hamenye tihayanga hwa hala hatihalolile. Ila semwaposhenje olweteshelo wetu. ");
INSERT INTO sbk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nkashe embabho zezye enongwa zyepa pansi na semuhweteshele nkanaibhabhozya ezya mwanya? ");
INSERT INTO sbk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Afuatanaje nomo wazubhile humwanya mbinguni ila omwahale ahishile, Omwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nansi shila oMusa shabhosezye enzoha mwipoli, shesho shesho Omwana wa Adamu abhosewe, ");
INSERT INTO sbk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aje bhonti bhabha yetesha wapataje owomi wewila wila. ");
INSERT INTO sbk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Hunamna ene Ongolobhe aigene insi, paka afumizye omwana wakwe waje umuntu wowonti wai humweteha aganje teje mowomi we wila wila. ");
INSERT INTO sbk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ongolobhe sagatumile mwana wakwe munsi aje alonje ensi, ahenzele aje ensi efyolwe no mwahale. ");
INSERT INTO sbk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wahumweteshela omwahale sagailongwa. Umwene wasagahumweteshela alongwile tayali sababu salyeteshela itawa lya Mwana wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ene yenongwa eyalongwe, aje olukhozyo lwenzele munsi, awantu wasongwelwe enkisi ashile olughozyo alengane embombo zyabho zya mbibhi. ");
INSERT INTO sbk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","omntu wowonti wabhomba embibhi aluvitwa olukhozyo wala sahwenza mulokhozyo aje embombo zyakwe zigabhoneha wene. ");
INSERT INTO sbk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Omwene, wabhomba zyelyoli ahwenza hulukhozyo aje embombo zyakwe zibhoneshe aje ziwoombwa hulunyenyekelo lwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Badala yego, oYesu pamo na bhanafunzi bhakwe bhabhalile hunsi ye Yudea. Ohwo akheye muda pamo nabho ali abhozya. ");
INSERT INTO sbk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","O Yohana aliahwozyaohwo hu Ainea pepe na Salim afutanaje hwaliamenze minii hula. Abhantu bhahenzaga hwa mwahale ahwozewe, ");
INSERT INTO sbk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","afuatanaje oYohana alisaponyiziwe mwijela. ");
INSERT INTO sbk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hwafumiye amadali abhanafunzi bha Yohana na Myahudi ahusu evikulukulu vya hwiyozye. ");
INSERT INTO sbk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bhabhalile hwa Yohana bhabhabhozezye aje, “Rabi, omwene wohali nawo hwisyela Lisoho Yordani, omwene wahahakikisizye enongwa zyakwe, enya, obhozya awantu bhonti bhabhala bhahulondolela.” ");
INSERT INTO sbk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","O Yohana ajile omuntu sagaposhela hantu haonti ila nkashe apewilwe afume amwanya. ");
INSERT INTO sbk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amwe mwemwe muhakikisizye aje nayanjile aje, 'ane sene Kilisiti', pamande yakwe nayanjile, 'aje entumwilwe hwitazi lyakwe.' ");
INSERT INTO sbk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Omwene wali no bibi harusi yo mweji we harusi. Eshi manyani wa mweji we harusi, wahwemelela na tejizye asongwa tee afutanaje izulya bwana harusi. Ene esalezi lusongwo lwane lwalukamilishe. ");
INSERT INTO sbk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ahwanziwa ahwonjelele na ehwanziwa apongoshe. ");
INSERT INTO sbk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Omwene wafuma humwanya, ali hugonti omwene wali wa munsi afuma munsi na ayanga enongwa zyeshi ngolobhe. Omwene wafuma humwana ali pamwanya pagonti. ");
INSERT INTO sbk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Omwene wayanga gala gagalolile nagomvwe, nomo waposhela enongwa zyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Omwene waposheye enongwa zyakwe ahakikisizye aje Ongolobhe welyoli. ");
INSERT INTO sbk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Afuatane naje omwane watumwilwe no Ngolobhe ayanga enongwa zya Ngolobhe. Afatanaje sahupela Ompepo eshipimo. ");
INSERT INTO sbk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Odaada ahugana Omwana na apiye evintu vyonti mumakhono gakwe. ");
INSERT INTO sbk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Omwane ne humweteha oYesu ali no womi we wilawila, ila hwola wasa humwogopa oYesu sagaiulola owomi, ila khatana pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","O Yesu na wamanya aje aMafalisayo bhomwezye aje amemile na bhozye ashile oYohana, ");
INSERT INTO sbk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(japokuwa oYesu yoyo ali sahwonzya ila awanafunzi bhakwe), ");
INSERT INTO sbk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","afumile hu Yudea na bhale hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Esho hwali muhimu ashilile hu Samaria. ");
INSERT INTO sbk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na afishile hunsi ye Samalia, yehwetwagasi Sikari, karibu no sehemu ela o Yakobo yapiye mwanawakwe oYusufu. ");
INSERT INTO sbk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eshi sima sha Yakobo shali epo. O Yesu ali alitile alengane ne safari na akhala karibu ne shi sima. Gwali muda wa gwa pasanya. ");
INSERT INTO sbk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Oshe oSamalia ahenzele atape menze, no Yesu abhozye, “Mpele amenze emwele.” ");
INSERT INTO sbk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Afuatanaje abhanafunzi bhakwe abhafunzi bhali bhabhalile hujini akale esholye. ");
INSERT INTO sbk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ola oshe abhozya, “Shibha bhole awe wo Myahudi, kuniomba mimi mwanamke Msamaria, andabhe amenze ga mwele?” Afuatanaje Ayahudi sebhasangana na Samaria. ");
INSERT INTO sbk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","O Yesu wayanga, “Ogamenye ashipawa sha Ngolobhe, nola wahubhozya aje, 'Mpele menze, 'handawalabhile, handapiye amenze ge womi.” ");
INSERT INTO sbk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oshe ayanga, “'Gosi sagoli nidebe lya tapile, na eshisima shitali. Obhawapate hwi Amenze ge womi? ");
INSERT INTO sbk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aje awe oli gosi, ashile odaada wetu oYakobo, ola watipiye eshi sima eshi, na yeye mwenyewe na watoto wake pamoja na mifugo yake wakanywa maji ya kisima hiki?” ");
INSERT INTO sbk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O Yesu wayanga, “Wawonti amwelile amenze obhapate eshomelwa nantele, ");
INSERT INTO sbk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ila omwene wenzahupele amenze ega sagaibha neshomelwa nantele. Baadaye menze gembahupele ganzabhe chemichemi yebubujiha wila wila.” ");
INSERT INTO sbk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ola oshe wabhozya, “Ogosi, engalabha amenze ego nkengaje olole eshomelwa, na enganje alabhe ahenze epa atape menze.” ");
INSERT INTO sbk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","O Yesu wabhozya, “bhala kwizye olume waho, nantele uyenzaje.” ");
INSERT INTO sbk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oshe wabhozya wage, “Sendi nolume.” O Yesu wayanga, “Aje oyajile sawa, 'Aje sendi nolume;' ");
INSERT INTO sbk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","afuatanaje oli nalumo wa sanu, mo wope wolinawo esalaze se lume waho. Hweli oyanjile lyoli!” ");
INSERT INTO sbk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Oshe wabhozya, “Ogosi aje elole ajewe oli kuwa. ");
INSERT INTO sbk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yise bhetu bhaputile pigamba amwe mwiga aje Yerusalemu ndiyo sehemu ambayo awantu bhahwanzia waapute.” ");
INSERT INTO sbk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","O Yesu ajile, “Weshe, niteshele, ensiku zihwenza nasemwaihuputa Daada huigamba eli au hu Yelusalemu. ");
INSERT INTO sbk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amwe mubhantu muputa hasemuhamanye, afuatanaje ofyilwe ufuma hwa Yaudi.” ");
INSERT INTO sbk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hata sheshi, ensiku zihwenza, neshi zihweli epa, nabhaihuputa Daada hu shiroho ne lyoli, afuatanaje oDaada abhanza abhantu bhabhali esho aje abhantu bhakwe bhabhahuputa. ");
INSERT INTO sbk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ongolobhe weshi Roho, bhabhahuta bhahwanziwa bhaputaje hushiroho ne lyoli, afuatanaje odaada abhanza abhantu ebho bhabhahupata.” ");
INSERT INTO sbk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Oshe ola abhozya, “Emenye aje Yesu ohwenza, (wohwetwa Kilisiti). Ono nayenza aitibhozya gonti.” ");
INSERT INTO sbk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","O Yesu abhozya, “Ane woyanga nane nene.” ");
INSERT INTO sbk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Insiku ezyo abhanafunzi bhakwe bhawela. Bhope bhaswigaga yenu ali ayanga noshe, ila nomo walenjele ahubhozye, “Ohwanza yenu?” au “Yenu ayanga nawo?” ");
INSERT INTO sbk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Esho oshe ola ayileha ensonta yakwe abhalile husokoni abhabhozye abhantu, ");
INSERT INTO sbk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Enzaji mwenye omuntu wambozezye enongwa zyane zyonti zyebhomba, aje egawezehana aje agabhayo Kilisiti?” ");
INSERT INTO sbk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bhafumile hu sokoni bhenza hwamwene. ");
INSERT INTO sbk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pasanya abhanafunzi bhakwe bhalambile wajile, “Mwalimu alya eshalye.” ");
INSERT INTO sbk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ila omwene abhabhozezye, “Ane endi nashalye shasemushimenye amwe.” ");
INSERT INTO sbk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Abhanafunzi bhabhozanya, nomo waleteye ahantu hahonti alye,” Aje bhaletile?” ");
INSERT INTO sbk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","O Yesu abhabhozya, “Eshalye shane hubhombe ensongwo zyakwe omwene wantumile nakamilisye embombo yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aje, semuyanga, 'Bado mezi gasanu emvuna ebhabhe tayari?” Embabho enyaji amagonda shagali tayari hu mvuna! ");
INSERT INTO sbk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Omwene wavuna aposhela na wonganye amatunda gewomi we wila wila, ili aje omwane watota na wope wavuna bhasongwe pandwemo. ");
INSERT INTO sbk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Afuatanaje enjango ene ye lyoli, 'Omomo atotile awamwabho ayawila.' ");
INSERT INTO sbk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nabhatumile avune hasemwambeleye, Wamo bhabhombile embombo namwe mwinjiehulishimo lwe mbombo yabho.” ");
INSERT INTO sbk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamaria abhinji munsi ela bhamwetesheye afwatane ne taarifa ele yashe wayangaga enongwa zyonti zyanabhombile.” ");
INSERT INTO sbk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Shesho Asamaria bhahenzele bhahenzebhalambile aje akhale pamo na bhahale ahakhala hwa bhene ensiku kuni na mbili. ");
INSERT INTO sbk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abhinji bhonti bhamweteshela alengane ni izu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhabhozya ola oshe, “Tihweteshela sio aje hunongwa zyaho, afuatanaje ate tete tomvwezye, na esauti tihwelewa aje lyoli ono fyozi we nsi.” ");
INSERT INTO sbk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Baada ye nsiku ezyo zibhele, asogoye na bhale hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Afuatanaje omwane yoyo atangazezye aje okuwaa saline heshima munsi yakwe yoyo. ");
INSERT INTO sbk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nahenzele afume hu Galilaya, Bhahu Galilaya bhakaribisizye bhali bhalolile embombo zyonti zyabhombile hu Yelusalemu hwahwali eshikulukulu, afwataneje abhene bhahuruliye hushi kulu kulu. ");
INSERT INTO sbk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ahenzele nante hu Kana ye Galilaya ohwo hwaguzenye amenze abhe divai. Pali no afisa ambaye omwana wakwe ali winu ohwo hu Kaperanaumu. ");
INSERT INTO sbk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na homvezye aje oYesu afumile hu Yudea na abhalile hu Galilaya, abhalile hwa Yesu na hulambe aishe aponye omwana wakwe, wakati ali karibu afwe. ");
INSERT INTO sbk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","O Yesu nkabhozya, “Amwe nkasemloli ehalama na mahajabu semuwezizye ahweteshele. ");
INSERT INTO sbk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Olongozi ahayanga, “Gosi iha pansi omwana wane sali seele nafwe.” ");
INSERT INTO sbk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O Yesu ahabhozya, “Bhalaga omwana waho mwomi.” Ola omuntu aheteshela izu lyayanjile oYesu wabhala wahwisogolela. ");
INSERT INTO sbk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lwali ahwiha, abhomba mbombo bhakwe bhaposheye na hubhozye omwana waho ali mwomi. ");
INSERT INTO sbk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Esho wabhabhozya muda nshi ou nafuu. Bhajibu, “Igamo umuda gwesa saba ehoma ehamalishe.” ");
INSERT INTO sbk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eshi ogosi bhakwe ahamanya aje umuda gwagula oYesu gwayanjile, “Mwana waho mwomi.” Esho omwene ne familia yakwe bhaheteshela. ");
INSERT INTO sbk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ene yali halama yabhele yabhombile oYesu afumile hu Yudea abhale hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baada yepo hwali neshikulukulusha Yahudi no Yesu alizubhile abhale hu Yelusalemu. ");
INSERT INTO sbk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hula hu Yelusalemu hwali ni birika pandyango gwe ngole, lyalyalihwetwa hu lugha yeShiabrania hu Bethzatha, lyape lili na matao gasanu. ");
INSERT INTO sbk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Abhantu bhinji abhinu bhahali, ampofu, avewete, bhabhahomele bhali bhagonile mumatao ego. {Khatililaga: Amazu ge sitali 3 segabhoneha mu nakala enyinza zi mwaha. “Bhagolezezye amenze avwalanganye.”') Hwa hali owakati umo ohalozelu muhati ya Gosi na vwalanganye menze. ");
INSERT INTO sbk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ola wa hali wa kwanza ahwinjile muhati amenze nagavwalanganywa oyo abhanga mwomi afumilane na hahonti hahali ha khetwe omuda ogwo. ");
INSERT INTO sbk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","No muntu wali abhinile humaha thelathini na nane wli mhati ye matao. ");
INSERT INTO sbk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","O Yesu nalolile agonile mhati ye matao nawamanya aje agonile pala omuda gwinji oYesu abhozya, “Ajile ohwanza abhe mwomi?” ");
INSERT INTO sbk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ola abhinu ajile, “Gosi sendi no muntu wambeshe mwi birika omuda amenze nagavwalanganywa. Lwelenga ahwinjile omuntu owenje antangulila.” ");
INSERT INTO sbk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O Yesu wabhozya, “Bhoha ayeje igodolo lya ho obhalaje.” ");
INSERT INTO sbk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Omuntu ola wapona, wega eshitala shakwe na wabhala. Isiku elyo lyali lisiku lye Sabato. ");
INSERT INTO sbk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ayahudi bhabhozya omuntu ola waponyiziwe, “Sanyono lisiku lya Sabato, solohusiwa abebe igodoro lyaho.” ");
INSERT INTO sbk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Omwene ajile waponiziwe yayoyo wambozezye, “Ege igodoro lyaho bhalaga.” ");
INSERT INTO sbk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bhabhozezye, “Wenu wabhozyezye 'Ege igodoro lyaho bhalaga?'” ");
INSERT INTO sbk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Haha nkashe ola waponile sagamenye, afwatanaje oYesu ali asogoye shi siri. Afuatanaje hwali awantu winji esehemu eyo. ");
INSERT INTO sbk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pamande yakwe oYesu amweje ola umuntu mshibhanza na hubhozye, “Enya, aponole! “Uganje abhombe mbibhi nantele ogakhomana ni jambo ibhibhi sana.” ");
INSERT INTO sbk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Omuntu ola abhalile abhabhozye Ayahudi aje oYesu wamponezye. ");
INSERT INTO sbk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eshi, afuatanaje amambo ego Ayahudi bhayemvezye oYesu, afuatanaje abhombile amambo ega isiku lye Sabato. ");
INSERT INTO sbk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","O Yesu wabhabhozya, “Odaada wane abhomba embombo paka esalezi nane ebhomba embombo.” ");
INSERT INTO sbk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hunamuna eye Ayahudi bhahendeleye azidi bhahanzaga aje sababu yanankanye eSabato, ila hukwizye Ongolobhe oDaada wakwe, alihweshele sawa no Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","O Yesu ajile, “Etesheli, etesheli, Omwana sagabhomba ahantu hahonti ila hala halolile Oise wakwe abhomba, afuatanaje hahonti habhomba Oise haheho hanzabhombe Omwana. ");
INSERT INTO sbk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afuatanaje oDaada agene Omwana, na ahulanga kila hantu habhomba na ahaulanga amambo amagosi ashile ega ili nkamuswigage.” ");
INSERT INTO sbk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afuatanaje nanshi shila oDaada nafufula awafwe na abhapele owomi, sheshesho Omwana wope ahupele wowonti wagene. ");
INSERT INTO sbk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Afuatane naje oDaada sahulonga wowonti, ila apiye Omwana alonje hwonti ");
INSERT INTO sbk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili bhonti bhamwogope Omwana sebhahu mwogopa oDaada. Umwene wasihumwogopa Omwana sahamwogope no Daada wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Eteshela, eteshela, omwene wahonvwa izu lyane na humweteshele wantumile ali no womi we wilawila na sagailongwa. Yaani ashilile afume hunfwa ahwinjile huwomi. ");
INSERT INTO sbk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eteshela, eteshela, embabhozya ensiku zihwenza na zihweli lula abhafwe nabhayovnwa izu lyakwe Omwana wa Ngolobhe, na bhonti bhabhayonvwa waikhala. ");
INSERT INTO sbk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nanshi shila oDaada shali nowomi mhati yakwe yoyo, ");
INSERT INTO sbk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","shesho apiye Omwana abhe no womi wope oDaada apiye Omwana amamlaka ili aje alongaje afuatanaje Mwana wa Adamu. ");
INSERT INTO sbk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Munganje shangale hweli afuatanaje zihwenza ensiku abhafwe hbonti bhabhali mumakaburi bhayonvwa izu lyakwe ");
INSERT INTO sbk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na bhope bhaifuma hunze: hwabhabhombaga enyinza ulyovyosyolwe womi, bhabhabhombaga embibhi oluvyosnsyo lwa longwe. ");
INSERT INTO sbk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sengabhomba ahantu hahonti afume huline nene. Nanshi shehovwa, shesho shelola alonje na alonje hwane hwe lyoli afuatanaje sehwanza she songwa ane, ila shasongwa omwane wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nkashe ehwihakikisya nene, luhakikisyo lwane selwabhanga lwe lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ahweli wamwabho wahakikisya ahusuane emanya aje lyoli uluhakikisho lwa hakikisizya ane we lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mutumile hwa Yohana wope ahakikisizye lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hata sheshi ulihakikisyo lwenduposhela selufuma hwa bhantu. Ninayasema haya ili kwamba mweze kuokolewa. ");
INSERT INTO sbk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O Yohana ali lukhozyo lwalwa hahaga, na khozye mwahali tayari aisongwe huu muda ododo olukhozyo lwakwe. ");
INSERT INTO sbk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ulwetesho lwendi nalwo gosi ashile lula lwa Yohana, humbombo zila Odaada yza mpiye azikamilisye, anzyo embombo zyezibhomba zibhonesya aje Odaada antumile. ");
INSERT INTO sbk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Odaada wantumile yoyo ahakikisizye ahusu ane. Semuwaile ahomvwe izu lyakwe au alole obele gwakwe omuda gwagwonti. ");
INSERT INTO sbk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Semulinalyo izu lyakwe nkalikhale muhati afuatanaje semwamwetesheye omwene wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mugenyelezya amazu msewa aje muhati yakwe muli owomi wewila wila, gego amazu gahakikisya ehabari zyane ");
INSERT INTO sbk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","semuhwanza ahwenez huline nkampate owomi wewilawila. ");
INSERT INTO sbk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Siposhela huhwhiyonvwe afume hwa wantu, ");
INSERT INTO sbk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ehwelewa aje nalumo olugano lwa Ngolobhe muhati yenyu. ");
INSERT INTO sbk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Enenzele hwitawa lya Daada wane, semwamposheye. Nkashe owenje ayenze hwitawa lyakwe handamwaposheye. ");
INSERT INTO sbk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aje mwahenzaga ahweteshele amwe mwamposhela esifa afume hwa kila muntu wenyu ila semuhwanza esifa yefuma hwa Ngolobhe mwene? ");
INSERT INTO sbk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Msagaje ane embabhatake hwitazi lya Daada. Wabhataka amwe yo Musa, ambayo mubheshele ategemele hwa mwa hale. ");
INSERT INTO sbk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mugali aje mhumweteshele oMusa, handamunetesheye nane afuatanaje ahaandishe ahusu ane. ");
INSERT INTO sbk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nkase muhwetehsele bhole amazu gane? ");
INSERT INTO sbk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Baada ye enongwa ezi, oYesu abahlile hu Bahari ye Galilaya nantele huhweta isombe lye Tiberia. ");
INSERT INTO sbk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Obhongano ogosi gwali guhufuata afuatanaje bhalolile ealama zyabhombile hwa bhala bhabhali bhawinu. ");
INSERT INTO sbk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O Yesu azubhile pamwanya hadi sehemu ya pamwanya hwigamba na akhaye ohwo na bhanafunzi bhakwe ");
INSERT INTO sbk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Epasaka, ye shikulukulu sha Yahudi yali efishile). ");
INSERT INTO sbk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","O Yesu abhosezye amaso amwanya nalole owinji wa bhantu bhahwenza hwamwene, wabhozya oFilipo, “Tibhala hwii akale amabumunda aje ebhankabhapate alye”? ");
INSERT INTO sbk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ila oYesu agayanjile ega hwa Filipo apimaga pima afuatanaje omwene yoyo amenye haibhomba). ");
INSERT INTO sbk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","O Filipo ajile, “Ata mabumunda hela hata dinari mia mbili seganzatosye shila muntu apate hashe hashe.” ");
INSERT INTO sbk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","O Andrea, omo webhanafunzi bhakwe ohoho wakwe oSimoni Petro abhozyezye ");
INSERT INTO sbk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","O Yesu, “Ahweli osahala epa ali na mabumunda gasanu ne samaki zi bhele, eshi ene ekhondeye yenu hwa bhantu abhinji enamuna ene?” ");
INSERT INTO sbk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","O Yesu abhozya, “Aje bhakhazyi abhantu pansi” (kulikuwa na nyasi nyingi mahali pale). Hivyo wanaume wapata elfu tano wakakaa chini. ");
INSERT INTO sbk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pamande oYesu wega amabumunda gasanu wasombwezye wabhagabhila bhala bhabhakheye. Shesho wabhagabhila esamaki alengane shabha hanzaga. ");
INSERT INTO sbk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Abhantu nabhahakuta, abhabhozya abhanafunzi bhakwe, “Bhonganyi evigalizi vyavisageye aje nkaviganje ateje vyovyonti.” ");
INSERT INTO sbk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bhabhonganya na memwe evitondo kumi ne vibhele, evipande vye mabumunda visanu vyavyasageye na bhala bhabhalyanga. ");
INSERT INTO sbk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pamande abhantu na bhalola embombo zya bhombile bhajile, “Lyoli ono yayola okuwaa wahwenza munsi.” ");
INSERT INTO sbk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","O Yesu nagunduye aje bhahwanza ahukhate ili aje bhabheshe aje mwene wabho, ahwitenjile, nantele abhalile hwigamba omwene mwene. ");
INSERT INTO sbk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nahwali lyabhela, abhanafunzi bhakwe bhalushile abhale hwidimi idodo. ");
INSERT INTO sbk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhapandile mwitoli bhali bhalobhoha abhale hu Kaperanaumu. (Enkisi yali eyenyiye no Yesu ali sele sayenzele hwabhene). ");
INSERT INTO sbk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Eshipindi esho ehala engosi yali evugula, ne nsombe yali ehwendelela achafushe. ");
INSERT INTO sbk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nantele abhanafunzi bhakwe na bhali wakhomile emakasia kama shilini natano au thelathini wahalola oYesu ajenda pamwanya ye somba azuwilile itoli, wahogopa. ");
INSERT INTO sbk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ila wabhabhozya, “Nene mganjehwogope.” ");
INSERT INTO sbk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Antele bhalitayali ahunyemle mwitoli, itoli nalyafihoa insi ya bhalaga. ");
INSERT INTO sbk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Isiku lyalyafuatile, obhongano gwa hemeleye oupande wensombe bhalolaga aje nalimo itoli lya mwabho ila lila ambalyo oYesu na bhanafunzi bhakwe bhali sebhalipandile ila abhanafunzi bhakwe bhali bhahwibhaliyee bhebho. ");
INSERT INTO sbk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Japokuwa hwa hali amitoli gamo gafumaga hu Tiberia peepe ne sehemu hwabha lyanga amabumunda baada ya Gosi afumwe ulusalifyo). ");
INSERT INTO sbk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Omuda embongano na bhamanya aje se yo Yesu wala sebhanafunzi bhakwe bhali hula, abhene bhebho wapende mwitoli bhabhala hu Kaperanaumu bhalondola oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na bhahapata esehemu ya mwabho ye oimi dodo bhabhozya, “Mwalimwa ohenzele ndii ohu?” ");
INSERT INTO sbk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","O Yesu ayanga, abhabhozya, Etisheli, etisheli, munaanza ane, sio aje mwazilolile embombo ila afuatanaje mwaliye amabumunda nakute. ");
INSERT INTO sbk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Leshi ashibhombela embombo eshalye shashi na nchiha, ila mshibhombele embombo eshalye shashikhala wilawila shila omwana wa Adamu shaibhapela, afuatanaje Ongolobhe Odaada abheshele omuhuri pamwanya yakwe.” ");
INSERT INTO sbk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pamande bhabhozya, “Hantu hahwanziwa abhombe aje abhombe embombo ya Ngolobhe?” ");
INSERT INTO sbk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O Yesu ajibu, “Ene ye mbombo ya Ngolobhe: aje mwenteshe omwene wa ntumile.” ");
INSERT INTO sbk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhabhozya, “Aje alama anshi zyobhabhombe, aje tibhazilole na humweteshele? Obhabhombe bhole? ");
INSERT INTO sbk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Adaada bhetu bhaliye emanna mwipoli, nanshi sheyaandihwe, “Abhapiye amabumunda afume amwanya nkabhalye.” ");
INSERT INTO sbk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O Yesu abhabhozya, “Etisheli, etisheli, sio yo Musa abhapiye amabumunda afume amwanya, bali Baba yangu ndiye awapaye mkate wa kweli kutoka mbinguni. ");
INSERT INTO sbk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Afuatanaje ibumunda lya Ngolobhe lyalila lyalihwiha afume amwanya naipele ensi owomi. ");
INSERT INTO sbk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eshi bhabhozya, “Bhaga Gosi tipelaje amabumunda wilawila.” ");
INSERT INTO sbk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","O Yesu ahaga, “Ane endi libumunda lye womi, omwene wa hwenza huline sagailola enzala omwene wane teshela sagaichisila enzara omwene waneteshela sagaichisila na mwaha eshomelwa.” ");
INSERT INTO sbk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ijapokuwa embabhozezye aje, mundolile, lakini semuhweteshela. ");
INSERT INTO sbk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhonti oDaada wampiye bhanzahwenze huline, na wawonti wahwenza huline senaihutaga honze kabisa. ");
INSERT INTO sbk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Afwatanaje enishile afume amwanya, sehwahubhombe olusongwo lwane, ila ulusongwo lwa wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No olu lwo lusongwo lwakwe wantumile, aje nsatezye hata muntu omo bhala bhombiye, ila ehaibhazyosya isiku lya mwisho. ");
INSERT INTO sbk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Afuatanaje ega gasongwa Odaada wane, aje wawonti wa humwenya Omwana na humweteshele apate owomi wewila wila; wenu wanaihuzyonsya isiku elya mwisho. ");
INSERT INTO sbk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pamande ayahudi walalamishila ahusu omwene afuatanaje ayanjile, “Ane endi libumunda lyalihwiha afume amwanya.” ");
INSERT INTO sbk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhayanga, “Ono seyo Yesu omwana wa Yusufu, odaada wakwe no nyina wakwe timenye? Shili bhole esalezi aiga, 'Enishile afume humwanya`?” ");
INSERT INTO sbk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","O Yesu ahayanga, ajile, “Muganje alalamishalane mhati yenyu mwemwe. ");
INSERT INTO sbk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nomo omuntu wahwenza huline nkashe savutilwe no Daada wane wantumile, nane naihuvyonsya isiku elya mwisho. ");
INSERT INTO sbk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Afuatanaje eyandihwe hwa kuwaa, 'Bhanzasambelezewe no Ngolobhe.' Shila wayomvwezya asambeleye afume hwa Daada, ahwenza huline. ");
INSERT INTO sbk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sio aje ahweli omuntu walolile Odaada, ila omwene wafuma hwa Ngolobhe- alolile Odaada. ");
INSERT INTO sbk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eteha, eteha omwene wanetesheye ali no womi wewilawila. ");
INSERT INTO sbk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ane endi libumunda lye womi. ");
INSERT INTO sbk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","adaada bhetu bhaliye emanna mwipoli, bhahafwa. ");
INSERT INTO sbk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eli ndiyo libumunda lyalihwiha afume amwanya, ili omuntu alye nkaganje afwe. ");
INSERT INTO sbk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ane endi libumunda lyalikhala lyalilishile afume amwanya. Nanshi omuntu wawonti nkalye ibumunda eli, aihwizya wilawila. Ibumunda lye mbefumye bele gwane alengane no womi ensi.” ");
INSERT INTO sbk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayahudi bhavitwa bhebho hu bhebho bhanda abisanye bhaiga, “Omuntu ono awezizye bhole atipele obele gwakwe tiilye?” ");
INSERT INTO sbk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nantele oYesu wabhbhozya, “Etesheli, etesheli, nkashe semwailya obele gwa Mwana wa Adamu na mwele idanda lyakwe, semwaibha nowomi muhati yenyu. ");
INSERT INTO sbk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wawonti wailya obele gwane na mwele idanda lyane ali no womi wewilawila, nane naihuvyonsya isiku lya mwisho. ");
INSERT INTO sbk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Afwatanaje obele gwane shalye she lyoli, ni danda lyane shimwelo she lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Omwe wagulya obele gwane na mwele idanda lyane akhala muhati yane, nane mhati yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nanshi Odaada we womi shantumile, nanshi shakheye alengane no Daada, wakwe no mwene aikhala alengangane. ");
INSERT INTO sbk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eli libumunda lyali hwihaafume amwanya, sio nanshi shila Adaada wenyu bhaliye bhafwa. Omwene wanzalye ibumunda eli ayikhala wilawila. ");
INSERT INTO sbk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","O Yesu ayanjile enongwa ezi mshibhanza nahali afundizya hu Kaperanaumu. ");
INSERT INTO sbk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Abhinji abhanafunzi bhakwe bhahomvweze ega, bhayanjile, “Eli lifundizyo likhone wenu wawezizye aliposhele?” ");
INSERT INTO sbk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","O Yesu afuatanaje amenye aje abhanafunzi bhakwe bhalalamiha iswali eli libhavisya, akawambia je jambo hili linawakwaza? ");
INSERT INTO sbk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eshi shaibha na waihulola omwana wa Adamu naihwiha afume hwahweli kabisa? ");
INSERT INTO sbk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yo Mpempo yayoyo wafumya owomi. Obele saguhwavwa nkahamo. Amazu ge njanjile hulimwe ga mpempo no womi. ");
INSERT INTO sbk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bhahweli abhantu hulimwe bhasebhahweteshela.” afuatanaje oYesu amenye fume hale ola wasaga hweteshela na ola omwene wanzahusyonshele. ");
INSERT INTO sbk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wabhabhozya, aje shasheshi nabhabhozezye aje nomo omuntu wayenza huline ila apewilwe no Daada.” ");
INSERT INTO sbk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baada yega abhanafunzi bhakwe wonti wawela akhosi na khatane nawo nantele. ");
INSERT INTO sbk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","O Yesu wabhabhozya bhala kumi na bhabhele, “Aje namwe muhwanza asogole?” ");
INSERT INTO sbk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","O Simoni oPetulo wayanga, “Gosi tibhale hwa nanu afatanaje awe oli ni izu lya womi wewilawila, ");
INSERT INTO sbk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","natetesheye na manye aje awe oligolosu wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","O Yesu wayanga, “Aje ane senabhachaguye amwe, na omo wenyu yo setano? ");
INSERT INTO sbk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Eshi aliayanga ahusu oYuda, omwana wa Simoni Iskariote, afwatanaje ali yoyoyo ali pamo na bhala kumi na bhabhele, ambaye wasyonsheye oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pamande ye mambo ega oYesu asafiliye eshi hu Galilaya, afuatanaje sagaasongwelwe abhala huu Yahudi afwatanaje huuyahudi wapangaga ahubude. ");
INSERT INTO sbk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eshi eshikulukulu sha Yahudi, eshi kulukulu ye Vibanda, ya pepee. ");
INSERT INTO sbk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aholo wakwe nkabhozya, “Sogala apantu epa obhale hu Yahudi, abhanafunzi bhaho bhagalole amambo gobhomba. ");
INSERT INTO sbk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nomo wabhomba lyolyonti hu shi siri nkashe omwene yoyo ahwanza ajulihane pazelu. Nkashe obhomba ega, hwilanje wewe hwabha munsi.” ");
INSERT INTO sbk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata bhaholo bhakwe sebhamwetesheye. ");
INSERT INTO sbk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","O Yesu nkabhabhozya, “Insiku zyane sezifishile bado, ila ensiku zyenyu kila muda zihweli. ");
INSERT INTO sbk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abhamunsi sebhawezizye abhavitwe amwe, ila bhamvitwa ane afuatane embahakikisya aje ambombo zyao mbibhi. ");
INSERT INTO sbk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zubhaji abhale hu shikulukulu; ane sembala hu shikulukulu afuatanaje omuda gwane guli seele afishe.” ");
INSERT INTO sbk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nayanga enongwa izyo hwa bhahala, asageye hu Galilaya. ");
INSERT INTO sbk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hata sheshi, aholo bhakwe na bhabhalile hushikulukulu wope nkahabhala, sio apazelu bali pasirisiri. ");
INSERT INTO sbk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayahudi bhali bhahufuata hushikulukulu naje, “Ali hwii?” ");
INSERT INTO sbk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hwali no luyangano lwinji muhati mlubhongano ahusu omwene. Wamo bhajile, “Muntu mwinza.” Bhamwabho wajile, “Ndadi abhatezya olubhongano.” ");
INSERT INTO sbk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hata sheshi nomo wayanjile pazelu ahusu omwahale afuatanaje bhabhogope Ayahudi. ");
INSERT INTO sbk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ensiku zye shikulukulu nazyahali katikati, oYesu azubhile abhale mshibhanza na hwande asambelezye. ");
INSERT INTO sbk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayahudi bhaswigaga na nayanje, “Huu namna wele omuntu amanye enongwa enyinji? Sasambeleye nkahashe.” ");
INSERT INTO sbk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","O Yesu ayanga naje, “Emanyizyo zyane se zyaline, ila zyoola wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nkashe wawonti anzasongwe abhombe olusongwo lwakwe omwene, anzamanye emanyizyo ezi, aje zifuma hwa Ngolobhe, au aje eyanga afume huline nene. ");
INSERT INTO sbk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Shila wayanga gagafuma hwa mwene yoyo ahwenza umwamu wakwe, na shila wahwanza oumwamu wakwe omwene wantumile, omuntu omuntu oyo we lyoli, na muhati yakwe nahumo abhombeshe zye malenka. ");
INSERT INTO sbk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","O Musa sagabhapiye amwe endajizyo? Ila nomo hata weka hulimwe wabhomba endajizyo. Yenyu muhwanza ambude? ");
INSERT INTO sbk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Amabhongano gayanga, “Aje oli na mapepo. Wenu wahanza ahubude?” ");
INSERT INTO sbk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","O Yesu wayanga wagaa, “Ombombile embombo yeeka, namwe mwenti muswijile afuatanajenesho. ");
INSERT INTO sbk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O Musa abhapiye etohara (sio aje efuma hwa Musa, ila efuma hwa daada), na hu Sabato mhutahiri omuntu. ");
INSERT INTO sbk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nkashe omuntu anzaposhele etohara hwi siku lye Sabato aje endajizyo zya Musa zinganje nankanywe, yeenu munvitwa ane afwatanaje ebheshele omuntu abhe mwinza kabisa hu Sabato? ");
INSERT INTO sbk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mganje alonje alengane sha mlola, ila alonje hulyoli. ");
INSERT INTO sbk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bhamo bhamo uYelusalemu bhaga, “Seyayono wabhahu mwanza ahude? ");
INSERT INTO sbk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Enya, oyanga pazelu, na sebhayanga hahonti alengane no mwene. Sawezizye aje egabha aje alongozi bhamenye elyoli aje ono yo Kilisiti, ewezizye abhe? ");
INSERT INTO sbk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Timenye aje omuntu ono afumila hwii. O Kilisti lwayenza, atasheshii, nomo wailola aje afuma hwii.” ");
INSERT INTO sbk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","O Yesu afumiaga izu lyakwe mwibhanza, asambele zyaga naje, “Amwe mwenti mumenye ane na mumeenye hwe fuma. Senamenye hubele gwane, ila omwene wantumile welyoli, semumenye omwene. ");
INSERT INTO sbk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Emenye omwene afuatanaje enfumile hwa mwene na antumile.” ");
INSERT INTO sbk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bhalenga ahaate, ila nomo ata omo wabhosezye okhono gwakwe ahusu omwene afuatanaje esaa yakwe yaali seele afishe. ");
INSERT INTO sbk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hata sheshi bhinji mubhongano bhamwetesheye. Bhajile, “Kilisiti lwa yeenza, aibhomba embombo nyinji ashile zyabhombile omuntu ono?” ");
INSERT INTO sbk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amafarisayo bhabhonvwezye amawongano wakwepelena enongwa ezi eshi oYesu, na agosi bha dimi na Mafarisayo bhatumile amaafisa aje ahukhate. ");
INSERT INTO sbk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","O Yesu nkayanga, “Ali seele insiku ndodo embabhe pandwemo namwe, napamande naibhala hwa mwene wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Munanza ila semubhandole; hula hwembala, semubhawezye ahwenze.” ");
INSERT INTO sbk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Abhayaudi bhayangama bhene hu bhene, “Omuntu ono anzabhale hwii aje tipotwe ahulole? Anzabhale hwa bhabhanyampene mhati ya yunanu bhamanyinzye Ayunani? ");
INSERT INTO sbk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nongwa bhole ene yayanjile, 'Mwainanza nantele semwainaga; hula hwembala semwaiwezya ahwenze'?” ");
INSERT INTO sbk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Esalezi hunsiku zya mwisho, isiku igosi lye shikulukulu, pYesu ahemeleye azurizwe izu ajile, “Nkashe wa wonti ali ne sshomelwa, ayenze huline amwele. ");
INSERT INTO sbk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Omwene waneteshe ane, nanshi amazu shagayanjile, afume mhati yakwe ganza hwiteshe amasoho gemenze gewomi.” ");
INSERT INTO sbk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ila ayanji ega alengane hushi Roho, afuatanaje bhala bhabhamwetesheye bhayihuposhela; Ompempo ali seele safumiziwe alengane naje oYesu ali samwamihwe. ");
INSERT INTO sbk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bhamo bhelubhongano, nabhahomvwezye enongwa eezi, bhajile, “Yoli ono kuwaa.” ");
INSERT INTO sbk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bhamo bhayanjile, “Ono Kilisiti.” Ila bhamo bhamo bhajile, “yenu, oKilisiti awezya afume hu Galilaya? ");
INSERT INTO sbk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Amaazu segayanga aje oKilisiti aifuma hushikholo sha Daudi na afume hubenselehemu, hushi jiji shahali oDaudi? ");
INSERT INTO sbk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Shesho, pala pabhoha olugabhano mhati yelubhongamo alengane no mwahale. ");
INSERT INTO sbk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhamo mhati yabho handabhakhete, ila nomo wagolosezye okhono gwakwe hwa mwene. ");
INSERT INTO sbk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bhala ofisa bhawela hwa gosi adimi na Mafarisayo, bhope bhabhabhozya, “Yenu semletile?” ");
INSERT INTO sbk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Amaofisa bhajile, “Nomo omunti wawayile ayanje nanshi ono haani.” ");
INSERT INTO sbk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amafarisayo nkabhahaga, “Namwe nantele mtejile? ");
INSERT INTO sbk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ahweli omuntu wawonti hwa gosi wahumweteha, au wawonti hwa Mafarisayo? ");
INSERT INTO sbk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ila ebha amabhongano bhasebhemenye endwajizyo - wapete amakhosi.” ");
INSERT INTO sbk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","O Nikodemo abhabhozya (omwene wabhaliye oYesu imwaha, ali pamo na Mafarisayo), ");
INSERT INTO sbk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aje endajizyo zyetu ziholonga omuntu ila atejezewe na soti na amanye habhomba?” ");
INSERT INTO sbk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bhayanjile na hubhozye, “Ivi nawe ofumila hu Galilaya? Anza na oyenye aje nomo okuwaa wafumila hu Galilaya.” ");
INSERT INTO sbk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pamande shila munti ahabhala akhaya yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","O Yesu abhalile hwigamba lye Mzeituni. ");
INSERT INTO sbk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Khasha shampwiti ahenza nantele hushibhanza, na abhantu bhonti bhabhalila; ahakhala bhasambeleyezye. ");
INSERT INTO sbk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abhandishi na Mafarisayo bhaletela oshe wa khetwe humbombo yehuni. Bhabheha pahati. ");
INSERT INTO sbk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Epo nkabhabhalila oYesu, “Mwalimu, oshe ono akhetwe mu huni, mumbombo lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Esalezi, endajizyo, zya Musa atilajizizye awapole na mawe abhantu nanshi ebho, oyigabhole hwego? ");
INSERT INTO sbk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bhanyanjile ega ahutejesezye aje nkabhabhe ne nongwa ya hutake, ila oYesu au ndeme mpansi ahaandiiha mwinkondi hwa dole hakwe. ");
INSERT INTO sbk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na bhahendeleye ahubhozye, ahemeleye na bhabhozye, “Omwene wasali nembibhi mhati yenyu, abhe wahwande ahupole amawe.” ");
INSERT INTO sbk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Waundama nantele pansi, wadola mwinkondi hushidole shakwe. ");
INSERT INTO sbk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nabhahonvwa ego, bhasogoye omo baada ya wamwabho ahwande waliigogolo hata. Owamalishile wabho mwene, paamo no she waali pahati yabho. ");
INSERT INTO sbk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","O Yesu ahemeleye na nahubhozye wee shee wewe, bhabhatakile bhali hwii? Nomo ata weka walonjile?” ");
INSERT INTO sbk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wagaa, “Nomo ata weka Gosi.” O Yesu waaga, “Hata nene sihulonga. Bhalaga hwi dala lyaho; ahwande esalezi na hwendelele oganje abhombe embibhi nantele.” ");
INSERT INTO sbk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nantele oYesu ayanga na bhantu waga, “Ane endi lukhozyo lyensi; omwene wanzandondolele saganzajende munkisi ila anzabhe nolukhozyo lwe womi.” ");
INSERT INTO sbk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amafarisayo bhabhozye, “Ohwihakikisya wewe; oluhakikisyo lwaho see lwe yooli.” ");
INSERT INTO sbk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","O Yesu ayanga ahaga, “Hata nkashe ehwihakikisya neen oluhakikisyo lwane, lwe yooli. Emenye hwe nfumile na hwe mbala, ila amwe semumenye hwe nfumile wala hwembala. ");
INSERT INTO sbk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amwe mulonga shibele; ane sehulonga wawonti. ");
INSERT INTO sbk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ane hata nkashe elonje, endonga yane ye lyoli afuatanaje sendi nemwene, endi paamo no daada wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ena, hundajizyo zyenyu iyandihwe aje oluhakikisyo lwa bhantu bhabhelilwe lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ane ne hwihakikisye, no Daada wantumile ahakikisya.” ");
INSERT INTO sbk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bhabhozya, “Odaada waho ali hwii?” O Yesu ahaaga, “ane semumenye hata Odaada wane semumenye, mgali aje mumenye ane handa mmenye Odaada wane wope.” ");
INSERT INTO sbk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ayanjile enongwa ezi alipepe no lubhutilo nali asambelezya mshibhanza, na ali nomo ata weka wakhete afuatanaje esaa yakwe yaali seele afishe. ");
INSERT INTO sbk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Eshi abhabhozya nantele, “Nahwisogolela mwainanza na mwaifwela mumbibhi zyenyu. Hula hwe mbala semuwezizye ahwenze.” ");
INSERT INTO sbk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Abhayahudi bhajile, “Obhahwibude humwene, omwene wayanjile, 'hula hwe mbala semuwezezye ahwenze'?” ");
INSERT INTO sbk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","O Yesu abhabhozye, “Mufuma pansi; ane efuma amwanya. Amwe muli bha munsi omu; ane sendi wa munsi omu. ");
INSERT INTO sbk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eshi eshi, nabhabhozezye aje mwaifwa mumbibhi zyenyu. Labuda mweteshele aje ANE NENE, mwaifwa mu mbibhi zyenyu”. ");
INSERT INTO sbk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eshi bhabhozya, “Awe we nanu?” O Yesu wabhabhozya, Gala ganabhabhozezye ahwande huwandilo. ");
INSERT INTO sbk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Endi ne nongwa nyinji ezya yanje nalonje ahusu amwe. Hata sheshi, omwene wantumile we lyoli ne nongwa zyamwonvwezye afume hwa mwene, enongwa ezi nayanga hwa bha Munsi.” ");
INSERT INTO sbk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sebhamwelewe aje ali ayanga nabho ahusu Odaada. ");
INSERT INTO sbk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","O Yesu ajile, Namu bhahubhosye amwanya Omwana wa Muntu, nkamwailola aje NENE, naje sebhomba lyalyonti nemwene. Nanshi Odaada shansambelezezye, ayanga enongwa ezi. ");
INSERT INTO sbk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Omwane wantumile ali pamo nane, na omwene sandeshile nemwene, alenganaje shila muda ebhomba gala gasongwa.” ");
INSERT INTO sbk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","O Yesu lwayangaga enongwa ezyo bhinji bhamweteshe. ");
INSERT INTO sbk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","O Yesu ayange hwa Yahudi bhala bhabhamweteshe, “Nkashe mubhakhale mwizu lyane, epo mubhabhe bhanafunzi bhane lyoli, ");
INSERT INTO sbk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","namwe mubhaimanya elyoli, na elyoli ebhabhabheshe bhaushe.” ");
INSERT INTO sbk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhajile, Ate tili shi kholo sha Ibulahimu na mwaha setiwayile abhebhaboyi bha muntu wawonti; obhayanje bhole aje, “Tibhabhe bhauusu?” ");
INSERT INTO sbk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O Yesu wabhabhozya, “Etesheli, etesheli, embebhozya, wawonti wabhomba embibhi boyi we mbibhi. ");
INSERT INTO sbk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Boyi sakhala pakhayo omuda gwonti; omwana akhala nsiku zyonti. ");
INSERT INTO sbk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eshi eshi, nkashele Omwana aibhabheha bhausu, mwaibha bhausu lyoli.” ");
INSERT INTO sbk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Embamenye aje amwe mlishikholo sha Ibulahimu; muhwanza angoje alengane ni izu lyane selili no khalo mhati yenyu. ");
INSERT INTO sbk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eyanga enongwa zyenzilolile pamo na Daada wane, namwe pia mubhomba enongwa zya mwahonvwezye hwa daada wenyu.” ");
INSERT INTO sbk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhayanjile na hubhozye, “Odaada wetu yo Abulahamu.” O Yesu abhabhozya nkashe mungali bhana bha Ibulahimu, handamubhomba embombo zyakwe o Ibulahimu. ");
INSERT INTO sbk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hata sheshi munanza hungoje, omuntu walenjele elyoli aje ehomvwezye afume hwa Ngolobhe. O Ibulahimu sagabhombile esho. ");
INSERT INTO sbk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mubhomba mbombo ya daada wenyu.” Bhabhozya, “Setapepwe muuhuni, tili Odaada omo, yo Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","O Yesu abhabhozya, “Nkashe Ongolobhe yo Daada wenyu, handa mungene ane, afuatanaje handa mungene ane, afuatanaje enfumile hwa Ngolobhe; wala sehenzele hubeele gwane ila hwa mwene wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yenu semgelewa amazu gane? Afuatanaje semuwezizye avumilile agatejezye amazu gane. ");
INSERT INTO sbk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amwe mli bha Daada wenyu, osetano na mhwanza abhombe oluziliho lya Daada wenyu. Aligoji ahwande huwando na sawezizye ahwemelele mlyoli afuatanaje elyoli nemo mhati yakwe. Nkayanga ilenka, ayanga afume mmwoyo gwakwe afuatanaje wilenka na Odaada wilenka. ");
INSERT INTO sbk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hata sheshi, afuatanaje eyanga zye lyoli, semueteshela. ");
INSERT INTO sbk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wenu hulimwe wahakikisye aje endine mbibhi? Nkashe eyanga zye lyoli, yenu semuneteshela? ");
INSERT INTO sbk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Omwene wali wa Ngolobhe ateje zya amazu ga Ngolobhe; afwatanaje semulibha Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayahudi wayanjile na hubhozye, setiyanjile yoli aje awe oli Samaria na oli ni pepo?” ");
INSERT INTO sbk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O Yesu ajile, sendi ni pepo; ila ehumwogopa Odaada wane, amwe semunogopa. ");
INSERT INTO sbk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sehwanza oumwamihwe; waline ali weka wahwanza na lonje. ");
INSERT INTO sbk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Etesheli, etesheli, embabhozya, nkashe wawonti ayilikhata izu lyane, sagailola enfwa na mwaha.” ");
INSERT INTO sbk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayahudi bhabhozya, “Esalaze tamanya aje oli ni pepo. O Abulahamu na kuwaa bhafwiye; oiga, “Nkashe omuntu akhate izu lyaho, saganzabhonje enfwa'. ");
INSERT INTO sbk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Awe soli gosi ashile odaada wetu oAbulahamu bhafwiye shenje? Akuwaa bhope bhafwiye. Awe ohwibheha we nanu?” ");
INSERT INTO sbk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O Yesu ajile, “Nkashe ehwizuvya nemwene, oumwihwe wane bure; yo Daada waline wanzuvya - ola wa muhuyanga aje Ngolobhe wenyu. ");
INSERT INTO sbk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Amwe semumenye omwahale, ila ane emenye omwene. Nkashe embaje, 'semenye,' embabhe nanshi amwe, wilenka. Hata sheshi, engaemenyeamazu gakwe engakhete. ");
INSERT INTO sbk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Odaada wenyu oAbulahamu asongwelwe na walilola isiku lyane na aalilolile na asongwelwe.” ");
INSERT INTO sbk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayahudi bhabhozya,”Sofisizye omuri we maha amusini bado, nawe ololile o Ibulahimu?” ");
INSERT INTO sbk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O Yesu abhabhozya, “Etesheli, etesheli, embabhozya, o Ibulahimu salibado apapwe, ANE EHWENDI.” ");
INSERT INTO sbk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nkabhatola amawe aje bhakhome, O Yesu ahobhele ahafuma honzehu shibhanza. ");
INSERT INTO sbk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","O Yesu nali ashile alolile omuntu okipofu ahwande apapwe hwamwehale. ");
INSERT INTO sbk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abhanafunzi bhakwe bhabhozezye, “Mwalimu, “Wenu wabhombile embibhi, omuntu ono au yo yise no nyina paka apapwa mpofu?” ");
INSERT INTO sbk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","O Yesu ayanga, “Se yayono omuntu wala aise wakwe no nyina wakwe aje bhabhabhombila embibhi, yaani embombo zya Ngolobhe zikwinkushe ashilile hwa mwene. ");
INSERT INTO sbk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tihwanziwa abhombe embombo zyakwe shahuli pasanya. Osiku uhwenza pasetaiwezya abhombe embombo. ");
INSERT INTO sbk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Omuda gwendi munsi, ane endi lukhozyo.” ");
INSERT INTO sbk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O Yesu nayaanga amazu ega, aswiye mwinkondi, abhombele itotoo huu mate, na wapaha ola omuntu amaso na lila itope. ");
INSERT INTO sbk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wabhozya, bhalaga oyoje mwidimi lye Siloamu (Yebhoneha aje 'watumilwe').” Eshi omuntu abhalile anawe na wawela alola. ");
INSERT INTO sbk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ajilani bhakwe ola omuntu bhabhalolile hula ahwande aje labizi bhajile, Aje! ono wenje ola omuntu wakhalaga na labhizye?” bhamo bhajile, Na yoyo.” ");
INSERT INTO sbk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na bhamo bhamo bhajile, ndadi ono alengane nabho.” Ila ali ayaanga, NENE.” ");
INSERT INTO sbk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bhabhozya, “Esalezi amaso gaho gafunkushe bhole?” ");
INSERT INTO sbk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ajibuye, omuntu wahwetwa Yesuu abhombele itoto na pashe mmaso gane na mbozye, 'Bhalaga Siloamu unawe.' Esheshi nabhalile na nanawile nanapete alole.” ");
INSERT INTO sbk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhabhozezye, “Ali hwii?” Ajile, “Maanyi.” ");
INSERT INTO sbk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bhatwalile ola omuntu wawaile abhe mpofula hwa Mafarisayo. ");
INSERT INTO sbk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lyope lyali lisiku lye Sabato oYesu lwa lengeye amatoto na hwigule amaso gakwe. ");
INSERT INTO sbk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Amafarisayo bhabhozya ahandile bhole alole. Abhabhozya, “Abheshele itole mumaso gane, nanawile, neshi elola.” ");
INSERT INTO sbk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bhamo Amafarisayo bhajile, “Omuntu ono safumile hwa Ngolobhe afwatanaje saikhete eSabato.” Bhamo bhamo bhajile egawezehana wole omuntu we mbibhi abhombe embombo nanshi ezyo hwa wantuna gabhanyisha mhati yabho. ");
INSERT INTO sbk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nkabhabhozya ola ompofila nantele oyiga bhole ahusu omwahale afuatane naje ahiguye amaso gaho?” Ompofu wagaa, “Kuwaa.” ");
INSERT INTO sbk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hata isinku ezi Ayahudi sebhamweteshe aje ali mpofula wope apete alole paka pabhabhakwizizye oise no nyina wapete alole. ");
INSERT INTO sbk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhabhobhozezye aise no nyina, Aje, ono mwana wenyu wamuyiga apepwe mpofu? awezizye bhole alole esalezi?” ");
INSERT INTO sbk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aise no nyina bhajile, “Timenye aje ono mwana wetu na aje apepwe mpofula. ");
INSERT INTO sbk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Shili bhole esalezi alola, setimenye no ola wamwiguye amaso setimenye. Bhozezi yoyo. Muntu gosi. Anzahwiyelezye yoyo.” ");
INSERT INTO sbk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aise no nyina bhayanjile enongwa ezi afuatanaje bhahogope Ayahudi. Shila Ayahudi bhahetehene aje nkashe wawonti ayeteha aje oYesu oKilisti, aitengwa Wibhanza. ");
INSERT INTO sbk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hunamuna ene, oise no nyina wakwe bhajile, “Omuntu gosi, bhozyaji yoyo.” ");
INSERT INTO sbk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hu mara ya bhele, bhakwizizye ola omuntu wawaile abhe mpofula na hubhozye, “Pele Ongolobhe oumwamihwe. Timenye aje omuntu ono muntu we mbibhi.” ");
INSERT INTO sbk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ola omuntu ahayanga, “Abhe we mbibhi, ane sehwelewa. Ahantu hamo hemenye nali mpofula: esalezi ehwenya.” ");
INSERT INTO sbk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eshi nkabhabhozya, “Abhombeye yenu? Ahiguye amaso gaho?” ");
INSERT INTO sbk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ajile, “Embabhozezye ila amwe semuhwonvwa! Yenu mhwanza ahonvwe nantele? Amwe semuhwanza abhe bhanafunzi bhakwe nantele? ");
INSERT INTO sbk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bhalijile naje, “Awe oli mwanafunzi wakwe, ikla ate tili bhanafunzi bha Musa. ");
INSERT INTO sbk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Timenye aje Ongolobhe ayanjile no Musa, ila hwomo omuntu, seti menye hwafuma.” ");
INSERT INTO sbk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ola omuntu ayanga na bhahozye, “Yenu, enongwa ezi zyaswije, aje semumenye hwafuma, na ayiguye amaso gane. ");
INSERT INTO sbk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Timenye aje Ongolobhe sabhonvwa abhembibhi, nkashe omuntu wawonti ahuputa Ongolobhe na abhombe olusongwo lwakwe, Ongolobhe mwonvwa. ");
INSERT INTO sbk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ahwande peyandile Insi ene sewaile abhoneshe omuntu aiguye amaso gamuntu wapepwe mpofula. ");
INSERT INTO sbk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Egalije omuntu ono safumile hwa Ngolobhe, handasabhombile hahonti.” ");
INSERT INTO sbk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bhayanjile na hubhozye, “Uhapepwe mumbibhi mhaani, awe atisambelezya ate?” Nkabhabhenga mshibhanza shabho. ");
INSERT INTO sbk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","O Yesu ahonvwezye aje bhamwefizye mshibhanza. Amweje na hubhozye, “Aje ohumweteha Omwana wa Muntu?” ");
INSERT INTO sbk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ayanjile naje, “Wenu, Gosi, aje nkemweteshe?” ");
INSERT INTO sbk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O Yesu abhozya, “Uloolile, woyanga nawo yayoyo.” ");
INSERT INTO sbk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ola omuntu ayanga, “Gosi ehweteshela epo nkafugamiye. ");
INSERT INTO sbk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","O Yesu ayanga, “Alonje enenzele Munsi omu aje bhala bhasebhahwenya bhapete ahwenye nabhala bhabhahwenya bhabhe mpofula.” ");
INSERT INTO sbk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bhamo Amafarisayo bhalipamo nawo bhahonvwa amazu ege nahubhozye, “Nate eshi tili mpofula?” ");
INSERT INTO sbk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","O Yesu abhabhozya, “Nkashe mgali bha mpofu, handasemli ne mbibhi. Hata sheshi muyiga, 'Tilola,' embibhi zyenyu zikheye.” ");
INSERT INTO sbk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Etesheli, Etesheli embabhozya, ola wasahwinjila ashilile mundyango gwi goma lye ngole, ila azubha hwidala lya mwabho, omuntu oyo mwibha na fyozi. ");
INSERT INTO sbk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Omwane wa hwinjila mundyango yodimi we ngole. ");
INSERT INTO sbk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hwa mweme olinzi we dyango ahwigulilwa. Engolezolyonvwa izu lyakwe na azikwi zya engole zyakwe hu matawa gabho na zifumye honze. ");
INSERT INTO sbk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Naizifumya honze ezye zyazili zyakwe azitangulila ne Ngolobhe zihulondolela, afuatanaje bhalimenye izu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sezinzahumwanze ojenyu ila zinza hupemushile, afuatane sezigamenye amazu ga jenyu.” ");
INSERT INTO sbk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Yesu ayanga ofwana ogu hwabhene, ila sebhazyelewe enongo ezi zyali ayanag hwa bhene. ");
INSERT INTO sbk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O Yesu ayanga nabho nantele, “Etesheli, etesheli, embabhozya, Ane endi ndiango gwe ngole. ");
INSERT INTO sbk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhonti bhabhatanguliye bhibha na bhafyozi, ila engole zibhonvwa. ");
INSERT INTO sbk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ane endi ndiango. Wawonti wahwinjila ashilile huline, aifyoliwa ainjila muhati na fume, wope aipata edyo. ");
INSERT INTO sbk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Omwibha sahwenza ila ahwibhe, agoje, natezye, enenzele nkawepate owomi bhabhe nawo winji. ");
INSERT INTO sbk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ane endi dimi mwinza. Odimi omwinza afumya owomi wakwe huu ngole. ");
INSERT INTO sbk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oboyi wabhehwelwe, nasio aje dimi, ola engole se vyoma vyakwe, azilola embwa zihwenza na azileha na zishembele. ");
INSERT INTO sbk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ne mbwa zikhata na nyampanye. Zishembela afuatanaji oboyi wabhe hwelwe sazisajila engole. ");
INSERT INTO sbk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ane endi dimi mwinza embamenye bhabhali bhahuline, wope wamenye ane. ");
INSERT INTO sbk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Odaada amenye, nane emenye Odaada, nane eufumwa owomi wane hungole. ");
INSERT INTO sbk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Endi nazyo engole zimo zyasaga zya mwigoma eli ezyo zyope ehwanziwa azilete, zyope zinzahonvwe izu lyane zibheligoma limo no dimi omo. ");
INSERT INTO sbk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ene ndiyo maana Odaada angene: Eeufumye owomi wane alafu nantele aweje. ");
INSERT INTO sbk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nomo wawega afume huline, ila eufumya nene. Endi waamuzi gwa ufumye na endi waamuzi ogwagwefwe nantele. Endiposheye elajizyo eli afume hwa Daada.” ");
INSERT INTO sbk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Olwaganyishe lwafuma afume hwa yahudi afuatana na maazu ega. ");
INSERT INTO sbk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abhinji bhabho wahaga, “Ali ni pepo ndii na pelusu yenu muhumwonvwa?” ");
INSERT INTO sbk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bhamo bhayanga, “Ege semazu gamuntu wali ni pepo. Ipepo ligamwigula amaso ompofu?” ");
INSERT INTO sbk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nkashahenza Eshikulukulu Shabhehwe Wakifu hu Yelusalemu. ");
INSERT INTO sbk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hwali shipindi shi sasa, oYesu ali ajenda mushibhanza muukumbi wa Sulemani. ");
INSERT INTO sbk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayahudi nkabhazyongola na hubhozye, “Paka ndii waibheha nsebho? nkashe awe we Kilisiti, tibhozye peupe. ");
INSERT INTO sbk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","O Yesu ajile, “Embabhozezye ila semuhweteshela. Embombo zyenzibhomba witawa lya Daada wane, ezyo zihakikisha pamwanya yane. ");
INSERT INTO sbk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ata sheshi ahweteshela alenganaje amwe semuli ngole zyane. ");
INSERT INTO sbk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Engole zyane zihonvwa izu lyane; Enzimenye, zyope zinanza ane. ");
INSERT INTO sbk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Embapiye owomi wewilawila sebhatega na mwaha, nomo hata weka waibhafyola afume mukhono gwane. ");
INSERT INTO sbk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Odaada wane, wampiye ebho, yo Gosi ashile bhamwabho bhonti, na nomo hata weka wali no uwezo wa fyole mukhono gwa Daada. ");
INSERT INTO sbk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ane no Daada tili hantu hamo.” ");
INSERT INTO sbk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bhanyemla amawe aje nkabhapole nantele. ");
INSERT INTO sbk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","O Yesu abhabhozya, “Embalanjile embombo enyinji enyinza afume hwa Daada. Hu mbombo zyalihu kati yezyo zyamuhwanza ampole na mawe?” ");
INSERT INTO sbk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayahudi bhahaga, “Setihupola na mawe hu mbombo yayonti yeli nyinza, ila okufuru awe wo muntu ohwibheha aje oli Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O Yesu abhabhozya, “Seya handihwe mundajizyo zyenyu, 'Nayanjile, “'Amwe muli mangolobhe'”?” ");
INSERT INTO sbk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nkashe abhakwizizye mangolobhe, hwa bhala Izu lya Ngolobhe lya bhenzeye (na Maazu segawezi abudwe), ");
INSERT INTO sbk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","muyanga ahusu ola Odaada afumizye na husontezye munsi, 'Osalanya,' alengane naje nayanjile, 'ane endi Mwana wa Ngolobhe'? ");
INSERT INTO sbk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Nkashe sebhomba embombo zya Daada wane, mungaje aneteshele. ");
INSERT INTO sbk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ata sheshi, nkashe ezibhomba, ata nkasemuneteshela, zyetesheli embombo aje muwezye amanye na hwelewe aje Odaada ali muhati yane nane muhati ya Daada.” ");
INSERT INTO sbk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bhalenga na hu khate oYesu, ahwisogoleye afume mumakhono gabho. ");
INSERT INTO sbk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O Yesu ahwibhalila hwi syelelye Yordani esehemu hula oYohana hwahozyaga ahwande, ahakhala ohwo. ");
INSERT INTO sbk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abhantu abhinji bhahenza hwa Yesu. Bhahendeleye ayanje, “O Yohana lyoli sagabhombile eishara yoyonti, ila enongwa zyonti zyayanjile Yohana ahusu omuntu ono zye yoli.” ");
INSERT INTO sbk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Abhantu abhinji bhamweteshela oYesu epo. ");
INSERT INTO sbk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Omuntu omo itawa lyakwe ali yo Lazalo ali bhinu. Afumiye hu Bethania, eshijiji sha Mariamu na odaada wakwe oMasa. ");
INSERT INTO sbk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ali yo Mariamu yayola wapeshe Ogosi Amarhamu na hufute amagaga gakwe hwii sisi lyakwe, ola oholo wakwe oLazalo wali bhinu. ");
INSERT INTO sbk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ailombo ebha bhatumile oujumbe hwa Yesu na yanje, “Gosi, enya ola wogene abhawa.” ");
INSERT INTO sbk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","O Yesu na honvwa ajile, “Empongo ene se yafwe, ila, baada yeshoye umwamihwe wa Ngolobhe aje Omwana wa Ngolobhe apate amwamihwe ashilile hwenyo empongo.” ");
INSERT INTO sbk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","O Yesu agene oMasa no dada wakwe no Lazalo. ");
INSERT INTO sbk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lwa honvwezye aje oLozalo bhinu, oYesu akheye insiku izbhele ashizanye pala pahali. ");
INSERT INTO sbk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Eshi baada yelyo abhabhozya abhanafunzi bhakwe, “Saali huu Yahudi nantele.” ");
INSERT INTO sbk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abhanafunzi bhabhozya, “Mwalimu, Ayahudi bhali bhalenga ahupole na mawe, na aweohonza awele hwohwo nantele?” ");
INSERT INTO sbk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","O Yesu ayanga, “Esala zya pasanya sezili kumi ne zibhele? Omuntu ajenda pasanya sawezizye abomele, afuatanaje alola hulukhozyo lwa pasanya. ");
INSERT INTO sbk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ata sheshi nkashe anzajende no siku, anzabomele afuatanaje olukhozyo nalumo muhati yakwe.” ");
INSERT INTO sbk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","O Yesu ayanga enongwa ezi, baada ye nongwa ezi, abhabhozya, “Owamwetu oLazalo agonile, ila embala aje empate ahubhosye afume mutulo.” ");
INSERT INTO sbk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Abhanafunzi bhabhozya, “Gosi, nkashe agonile, anzabhoshe. ");
INSERT INTO sbk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ensiku izyo oYesu ali ayanga ahusu enfwa ya Lazalo, ila abhene bhamenye aje ayanga ahusu agone otulo. ");
INSERT INTO sbk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","O Yesu nkayanga na bhene pazelu pazelu, “O Lazalo afwiye. ");
INSERT INTO sbk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lusongwo lwendiinalwo hulimwe aje senahali hula aje mubhe no lweteshelo. Saali hwa mwene.” ");
INSERT INTO sbk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","O Tomaso wa hetwaga Pacha, abhozya abhanafunzi amwabho, “Nate saalitifwe pamo no Yesu.” ");
INSERT INTO sbk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","O Yesu lwa henzaga amweje oLazalo akheye mwilende insiku zine. ");
INSERT INTO sbk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yope e Bethania yaali pepe ne Yelusalemu nanshi ekilometa arubaini ne zisanu eshi. ");
INSERT INTO sbk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abhinji kati ya Yahudi bhahenzele hwa Masa no Mariamu abhazinde alengane no holo wabho. ");
INSERT INTO sbk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","O Masa ahonvwa aje oYesu ahwenza, abhalile akhomane nawo, ila oMariamu ahendeleye akhale pakhaya. ");
INSERT INTO sbk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","O Masa abhozya oYesu, “Gosi, nkashe ogabhiye epa, okolo wane handa safwiye. ");
INSERT INTO sbk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ata sheshehwelewa aje lyalyonti lyobhalabhe afume hwa Ngolobhe, anzahupele.” ");
INSERT INTO sbk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","O Yesu abhozya, okolo waho anzavyoshe nantele.” ");
INSERT INTO sbk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","O Masa abhozya, emenye aje anzavyonshe huu vyoho wi siku lya mwisho.” ");
INSERT INTO sbk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O Yesu abhozya, “Ane endi luvionsyono womi; omwane waneteshela, ata nkashe aifwa, hata sheshi aibha ahwizya; ");
INSERT INTO sbk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","no mwene wahwizya na netehsele ane saga ifwa. Uhweteshela eli?” ");
INSERT INTO sbk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wabhozya aje, “'Sawa, Gosi ehweteshela aje awe oli Kilisiti, Mwana wa Ngolobhe, omwene wa hwenza munsi.” ");
INSERT INTO sbk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nahamala ayanje eli, abhalile ahukwizye odada wakwe oMariamu hufaraga. Ajile, “Omwalimu ali epa nantele ahukwizya.” ");
INSERT INTO sbk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","O Mariamu na hovwezye ega, abhoshele nanali na bhale hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wope oYesu ali sayenzele aliseele muhati ye shijiji, aliseele lwa khomanaga no Masa. ");
INSERT INTO sbk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ayahudi bhabhali no Maliamu munyumba na bhala bhabhli wahuzinda, bhabhoshele nanali na afume honze, bhalondoleye; bhamenye aje abhala hwi kaburi aje alile ohwo. ");
INSERT INTO sbk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","O Mariamu, ahafiha pala oYesu palolaga na agwiye pansi pamagaga gakwe na hobhozye, “Gosi, nkashe ogahali epa, oholo wane hande sagaafwiye.” ");
INSERT INTO sbk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","O Yesu nalola alila, na Ayahudi bhahenzele pamo nawo bhali bhalila huu moyo gabho na sebhelele; ");
INSERT INTO sbk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ajile, “Mugonizye hwii? Bhabhozye, Gosi, enza oyenye.” ");
INSERT INTO sbk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","O Yesu alilile. ");
INSERT INTO sbk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayahudi nkabhayanga, “Oyenye sha gene oLazalo!” ");
INSERT INTO sbk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bhamo muhati yabho bhajile, “Sio yayono, omuntu wabhombile amaso gola wali mpofu, sagabhombile ono muntu aje agaje afwe?” ");
INSERT INTO sbk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","O Yesu alilaga humwoyo gwakwe nantele, abhalile hwi lende. Hwali ligwenya, niiwe libhehwele pamwanya lyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O Yesu ajile, “Lyefwi iwe.” O Masa, oilombo wakwe oLazalo, omwene wafwiye, abhozya oYesu, “Gosi, hu muda ogu, obele gubhabhe gu bholile, alenganaje ali fwee ensiku zine.” ");
INSERT INTO sbk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","O Yesu abhozya, “Ane senabhozezye aje, nkashe ohweteshela, obhaulole oumwamu wa Ngolobhe?” ");
INSERT INTO sbk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nnkabhalyefwa iwe. O Yesu abhosya amaso gakwe amwanya naje, “Daada, ehusombezya afuatanaje onomvwa. ");
INSERT INTO sbk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Namenye aje ononvwa omuda gwonti, ila alengane no lubhongano lwalwe meleye anzongole aje enjanjile ega, aje bhapate ahweteshele aje awe ontumile.” ");
INSERT INTO sbk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Naayanga ega, alilile hwizu igosi, “Lazalo, fuma honze!” ");
INSERT INTO sbk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ofwe afumile honze apinyilwe amakhono na magaga husanda zyakhatile, na amaso gakwe apinyilwe ne shitambala.” O Yesu abhabhozya, “Mwigulili muleshele abhalaje.” ");
INSERT INTO sbk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Oyahudi abhinji bhabhahenzele hwa Mariamu nalole oYesu habhombaga, bhamweteshela; ");
INSERT INTO sbk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","bhamo bhabhalile hwa Mafarisayo na bhabhozye enongwa zyazibhombile oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agosi bha dimi na Mafarisayo bhabhongene pandwemo mwi baraza na yaanje, “Tibhabhombe yenu? Omuntu ono abhoembombo enyinji. ");
INSERT INTO sbk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nkashe tibhahuleshe eshi mwene, bhonti bhanza humweteshe; Alumi bhayenza na hweje vyonti evyetu ni taifa lyetu.” ");
INSERT INTO sbk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hata omuntu omuntu muhati yabho, oKayafa, waali dimi Ogosi omwaha ogwo, abhabhozya, “Semumenye hahonti. ");
INSERT INTO sbk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sahusebhelela aje ehwanziwa aje omuntu omo afwe esababu ya bhanje ashile itaifa lyonti na litega.” ");
INSERT INTO sbk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eege sohagayanjile afuatanaje no mwene, mhati yakwe, ali dimi ogosi omwaha gula, ayanjile aje oYesu aifwa sababu ya bha munsi; ");
INSERT INTO sbk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na se huje hwabha munsi bhene ila oYesu apate abhabhonganye abhana bha Ngolobhe bhabha nyanpene hutali hutali. ");
INSERT INTO sbk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Eshi ahwandile isiku elyo na hwendelela bhapanjile ahugoje oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","O Yesu sagajendile apazelu pazelu hwa Yahudi, ila asogeye epa na bhale ensi yelipeepe ni poli hunsi yehwetwa Efraimu. Epo akheye nabhanafunzi. ");
INSERT INTO sbk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Epasaka ya Yahudi yali pepe, na bhinji bhazubhile abhale hu Yelusalemu honze yensi sheli sele ePasaka nkabhahwiyozye bhebho. ");
INSERT INTO sbk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bhali bha humwanza oYesu, na ayanje kila muntu na bhali bhemeleye mshibhanza, “Musebha yenu? Aje saga ayenza mushi kulukulu?” ");
INSERT INTO sbk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Owakati ou ogosi wa dimi na Mafarisayo bhali bhafumizye endajizyo aje nkashe omo aimanya oYesu hwali, ahwanziwa afumye etaarifa aje nkabhapate ahukhate. ");
INSERT INTO sbk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Isiku ilya sita selisele ePasaka, oYesu abhalile hu Bethania, hwa hali oLazalo, omwene wali avyonshele afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bhalenganyizya eshalye shana ndabhela owho, no Martha abhombelaga owakati owo oLazaro ahali pamo na bhale bhabhakheye pashalye pandwemo no Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pamande oMariamu ahege eratli ye manukato gagalenganyiziwe hu nardo enyinza, gagali ne maana engosi, wapaha oYesu mumagaga, na husyomole hwi sisi lyakwe; enyumba yonti yamemile nunsi gwe manukato. ");
INSERT INTO sbk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","O Yuda Iskariote, omo we bhanafunzi bhakwe, ambaye wanzahugalushe oYesu, ajile, ");
INSERT INTO sbk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Yenu amanukato ega segagalu ziwanyaga huu mpeya mia zitatu na bhapele apena?” ");
INSERT INTO sbk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wope ayanjile ego, sio aje hubhasajile apena, afuatanaje ali mwibha: omwene ali wa bheshe ehela na ali ahwega zimo zyazibhelwe omwo zya mwene yoyo. ");
INSERT INTO sbk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","O Yesu ajile, “Leshi abheshe hali naho alengane ni siku lya syelwe hwane. ");
INSERT INTO sbk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Apena mwaibha nabho ensiku zyonti ila ane semwaibha nane ensiku zyontii.” ");
INSERT INTO sbk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Owinji ogosi wa Yahudi bhapete amanye aje oYesu ali ohwo bhopebhenza, sio aje yo Yesu tu ila bhalole no Lazaro ola oYesu wavyonsezye afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bhope agosi bhayangene aje wagoje oLazaro; ");
INSERT INTO sbk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","alengane no mwale abhinji katika Wayahudi walienda zao bha bhalile ahumweteshela oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na isiku ila bhele uwinji gosi wali hushikulukulu bhahonvwezye aje oYesu ahwenza hu Yelusalemu, ");
INSERT INTO sbk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","bhahejile amasamba ge mikwige mitende na afume hoze na abhale ahumwejelele na bhakhomile ekelele, “Hosana! Asailwe wahwenza hwitawa lya Gosi, Omwene we Israeli.” ");
INSERT INTO sbk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","O Yesu ayeje enyana-ye punda ayipandale; nanshi shila shehandihwe, ");
INSERT INTO sbk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Oganje ahwogope, lendu Sayuni; enya, Omwene waho ahwenza, apende enyana-ye punda.” ");
INSERT INTO sbk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Abhanafunzi bhakwe sebhagelee amambo ega epo ahwande; ila oYesu na mwamihwe, nkabhakomboha aje amambo ega gahandihwe na huje abhombile amambo ega hwa mwene. ");
INSERT INTO sbk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lila ikundi lyalya pandwemo no Yesu lula lwa kwizyaga oLazaro afume mwilende, bhahakikisya hwabhanje. ");
INSERT INTO sbk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yali alengane neshi aje uwinji wa bhantu bhabhalile ahuposhele alenganaje bhahomvwezye aje abhombole embo eyo. ");
INSERT INTO sbk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amafarisayo bhakwepelana bhene hwa bhene, “Enya, esalezi semuwezizey abhombe lya lyonti; enya, ensi ebhalile hwa mwene.” ");
INSERT INTO sbk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bhamo Ayunani bhali pandwemo na bhala bhabhalile apute hushikulukulu. ");
INSERT INTO sbk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ebhabhaliye oFilipo, wafumile Betsaida ye Galilaya, bhalabha bhaga, “Gosi, ate tiziliha ahulole oYesu.” ");
INSERT INTO sbk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O Filipo ahabhala abhozya o Andrea; Andrea no Filipo bhabha ahubhozye oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","O Yesu ayanga ahaga, “Esala efishile hwa Mwana wa Adamu amwamihwe. ");
INSERT INTO sbk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Etesheli, etesheli, embabhozya, abhenyu he ngano nkase hagwiye pansi hafwa, hakhala shesho hene; ila nkahafwa, hana pape endondo zinyinji. ");
INSERT INTO sbk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Omwane wasongwa owomi wakwe anzautezye; ila ola wauvitwa owomi wakwe munsi omu anzaugolosye hata womi wewila wila. ");
INSERT INTO sbk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Omuntu wawonti wanza ambombele ane, andondolelaje; nane pehwendi omuntu wane paibha. Omuntu wawonti wabhombela ane anzanogope. ");
INSERT INTO sbk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Esalezi omwoyo gwane guhwalangana: nane enje bhole? 'Odaada, anfyozye esala ene'? Ndio maana enjifishiye esala ene. ");
INSERT INTO sbk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Odaada, alimwamishe itawa lyaho.” Izu ilinza afume humwanya na huje, “Endimwamisha nantele embali mwamishe nantele.” ");
INSERT INTO sbk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Olubhongano lwalwahemeleye peepe nawo bhahonvwa, bhayanga aje huli omungurumo. Bhamo bhajile, “Ohalo ozelu ayanjile nawo.” ");
INSERT INTO sbk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","O Yesu abhabhoyza naje, “Izu ili selya henzele huline, ila hwalimwe. ");
INSERT INTO sbk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Esalezi oulonje wensi ene ehweli: Esalezi ogosi wensi aitagwa honze. ");
INSERT INTO sbk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nane nkemwamihwe munsi, embarute bhonti huline.” ");
INSERT INTO sbk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wayanjile ego abhonesyaga aje enfwa bhole ya mwaifwa. ");
INSERT INTO sbk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Olubhongano lwaga, “Ate tonvwezye hundajizyo aje oKillisiti aibha wilawila. Awe oiga bhole, 'Omwana wa Adamu amwamihwe pamwanya'? Ono Omwana wa Muntu wenu?” ");
INSERT INTO sbk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","O Yesu abhabhozya, “Olukhozyo luhweli pandwemo namwe omuda ododo. Bhalaji afuatane naje mlinalyo olukhozyo, aje enkisi nkepotwe aitole. Omwene wabhala munkisi samenye hwabhala. ");
INSERT INTO sbk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Muli nalwo olukhozyo, lweteshelaji olukhozyo olwo nkamubhe bhana bhelukhozyo.” O Yesu ayanjile ega ahwisogolela ahobha bha salole. ");
INSERT INTO sbk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Japo oYesu abhombile eishara nyinji witazi lyabho, ila sebha mwetesheye ");
INSERT INTO sbk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","lifishe izu lya kuwaa oIsaya, lyayanjile: “Gosi, wenu waizyeteshela enongwa zyetu? Okhono gwa Gosi gwiguliwe wenu?” ");
INSERT INTO sbk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndio maana abhene sebhahetesheye, alengane naje oIsaya ayanjile nantele, ");
INSERT INTO sbk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Abhadiye amaso, na agabheshele makhome amoyo gabho, bhageteha engabhaponia.” ");
INSERT INTO sbk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","O Isaya ayanjile enongwa ezi afuatanaje alolile oumwamu wa Yesu na ayanjile enongwa zyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ila, hata bhagosi abhinji bhamweteshe oYesu; ila alengane na Mafarisayo, sebhaheteha bhahogope atengwe msibhanza. ");
INSERT INTO sbk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bhasongwelwe ahwilole hwa bhantu ahwilole ahwilole hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","O Yesu afumizye izu lyakwe naje, “Omwene waneteshela ane, saneteshela nene wene ila nola wantumile ane, ");
INSERT INTO sbk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","omwane wambonela ane ahubho ane ahubhonela yayola wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ane nahenzele nanshi olukhozyo munsi aje shila muntu waneteshela aganje akhale munkisi. ");
INSERT INTO sbk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nkashe omuntu wawonti anzahonvwe amazu gane sagakhata, ane sehulonga; afuatanaje sagahenzele ailonje insi ila injifyole insi. ");
INSERT INTO sbk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Omwene wananza ane nkasage teha amazu gane, ali nawo wahulonga: izu ilyo lyenjenjile lyalyaihulonga isiku lya mwisho. ");
INSERT INTO sbk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Afwanaje ane senayanjile hunafsi yane. Ila yo Daada wantumile, omwene yoyo andajizizye lye mbalombelele na yanje. ");
INSERT INTO sbk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ane emenye aje endajizyo zyakwe zye womi wewilawila; ila ego gelombelela ane - nanshi Odaada shambozezye, shashesho shelombelela hwa bhene.” ");
INSERT INTO sbk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Isalezi seliseele eshikulukulu ye pasaka, afuatanaje oYesu amenye aje esala ya efishile eyaje aifuma munsi omo abhale hwa daada, endwemo abhagene abhantu bhakwe bhabhali munsi, abhagene oupeo. ");
INSERT INTO sbk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Osetano abhehwelwe haani humwoyo gwa Yuda Iskariote, omwana wa simoni, ahushitushile oYesu. ");
INSERT INTO sbk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","O Yesu amenye aje odaada abheshele evintu humakhono gakwe naje afumile hwa Ngolobhe nantele ali abhala hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Abhoshele pashalye na ahalile pansi omwenda gwa honze. Ahejile itaulo ahwifunjile yoyo. ");
INSERT INTO sbk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nkahaponya amenze mumbakuri na wanda abhozye amagaga abhanafunzi bhakwe na bhapugute ni taulo lya hwifunjile yoyo. ");
INSERT INTO sbk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ahenza hwa Petro, na oPetro ahabhozya, “Gosi, uhwanza anazye amagaga gane?” ");
INSERT INTO sbk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","O Yesu ayanga na hubhozye, “Lyebhomba solimenye esalezi ila eshi obhahwelewe pamande.” ");
INSERT INTO sbk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","O Petro abhozya, “Sobhanozye amagaga gane na mwaha.” O Yesu ajile, “Nkashe sembahumwezye sobhabhe ne sehemu pandwemo nane.” ");
INSERT INTO sbk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","O Simoni Petro abhozya, “Gosi, onganjenozye amagaga gane wene, ila namakhono ni twe lyane.” ");
INSERT INTO sbk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","O Yesu abhozya, “Wawonti wayojile sahwanziwa ahwoje ila amagaga gakwe, nahuje mwinza obele gwakwe gwonti; amwe muli bhinza, ila se mwenti.” ");
INSERT INTO sbk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","O Yesu amenye ola wanzahugalushile; ndio maana ajile, semwenti mli bhinza.” ");
INSERT INTO sbk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","O Yesu lwali abhozizye amagaga gabho na wega omwenda gwakwe na khale nantele, abhabhozya, “Aje Muhwelewa hale hembabhombela? ");
INSERT INTO sbk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukwizya ane “Mwalimu” nantele myiga Gosi ene yoli, afuatanaje endi shesho. ");
INSERT INTO sbk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nkashe ane ne Gosi ne mwalimu, embozizye amagaga genyu, amwe namwe ehwanziwa abhozye amwenyu amagaga. ");
INSERT INTO sbk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Embapiye ofwana aje amwe mubhombe nanshi ane zyanabhombile hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Etesheli, Etesheli, embabhozya, oboyio segosi ashile ogosi wakwe; wala yule ambaye ametumwa ni mkuu kuliko yule aliye mtuma. ");
INSERT INTO sbk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nkashe ozimenye enongwa ezi osaiwaje nkobhazibhombe. ");
INSERT INTO sbk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Seyanga aje amwe mwenti, afuatanaje embamenye bhala bhembachaguye - eyanga ezi ili aje amazu gawezye akamilishe: 'Omwene walya ibumunda lyane ambasesezye ikhaata lyakwe.' ");
INSERT INTO sbk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Embabhozya izii esalezi shalilisele afume aje nkalyaifumila, mwawezye ahweteshele aje ane NENE. ");
INSERT INTO sbk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Etesheli, etesheli, embabhozya, wamposhela ane ahuposhela yayola wantumile mimi.” ");
INSERT INTO sbk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","O Yesu lwa yangaga ega, ayanzihwe hu mwoyo, ahakikisizye na yanje, “Etesheli, etesheli, embabhozya aje omo wenyu aingaluha.” ");
INSERT INTO sbk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Abhanafunzi bhakwe bha henyanya, bhahuswiga aje wenu wahuyanga. ");
INSERT INTO sbk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hwali ne meza, omo we bhanafunzi bhakwe ahagamiye musifubha mwa Yesu ola oYesu wagene. ");
INSERT INTO sbk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","O Simoni oPetro abhozezye omwanafunzi ono na huje, “Tibho wenu wahuyanga.” ");
INSERT INTO sbk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Omwanafunzi ola wahagamiye mshifubha mwa Yesu na hubhozye, “Gosi, yonanu?” ");
INSERT INTO sbk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","O Yesu ajile, “Wemba tobhezye ishipande shi bumunda na hhupele.” Shesho nali atobhezezye ibumunda, apiye oYuda omwana wa Simoni Iskariote. ");
INSERT INTO sbk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Baada yi bumunda, Osetano amwinyiye. O Yesu ahabhozya, “Haala howanza abhombe habhombe nanali.” ");
INSERT INTO sbk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nomo omuntu pameza wamenye emaana ya Yesu ayanje enongwa ezi hwa mwahale. ");
INSERT INTO sbk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bhamo bhasebhele aje afuatanaje oYuda ekhete ifuko lye mpeya, oYesu abhozya, “Kala evintu vyatihwanza vye shikulukulu,” au aje ahwanziwa afumye evintu hwa peena. ");
INSERT INTO sbk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","O Yuda na hejelela ibumunda, ahafuma honze nanali; hwali sikuu. ");
INSERT INTO sbk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","O Yuda lwali asogoye, oYesu ayanjile, “Eshi omwana wa Adamu amwamihwe, no Ngolobhe amwamihwe hwa mwehale. ");
INSERT INTO sbk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ongolobhe anzahumwamishe hwa mwene yoyo, na anza humwamishe nanali. ");
INSERT INTO sbk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bhana mwadodo, ehwendi pamo namwe omuda dodo. Mubhananze, nkashe shanabhabhozizye Ayahudi, 'Hwembala, semuwezizye ahwenze.' esalaze embabhozya amwe, nantele. ");
INSERT INTO sbk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Embapiye endizyo empya, aje mganane nanshi ane shehabhagene amwe, shesho shesho namwe ehwanziwa aganane mwemwe hu mwemwe. ");
INSERT INTO sbk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Afuatanaje neli awantu bhanzamanye aje amwe muli bhanafunzi bhane, nkashe muli no lugano shila omo no wamwabho.” ");
INSERT INTO sbk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","O Simoni Petro abhozezye, “Gosi, ubhala hwii?” O Yesu ayanga, “Apantu pe haibhala esalezi sobhawezye anfuate, ila obhananze pamande. ");
INSERT INTO sbk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O Petro abhozya, “Gosi, yenu ensafuate hata salezi? Ane embafumwe olwizyo lyane huliwe.” ");
INSERT INTO sbk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","O Yesu ajile, “Aje obhafumwe olwizyo shauli ya huline? Etesheli etesheli ehubhozya, ehanda sebhakuje bila haana mara hatatu.” ");
INSERT INTO sbk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Oganje aguleshe omwoyo gwaho abhe ahwalangane. Ohumweteshela Ongolobhe neteshele nane. ");
INSERT INTO sbk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu nyumba ya Daada wane muli mabhombo minji agakhale; nkashe semugali esho hande ebhozezye, afuatanaje embala abhalenganyizye apakhale awe. ");
INSERT INTO sbk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nkashe embale nabhalenganyizye nayenza nantele abhakaribizye hwa line, aje pendi ane namwe mubhanje. ");
INSERT INTO sbk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mumenye idala hwembala.” ");
INSERT INTO sbk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","O Tomaso abhozezye oYesu, “Gosi, setimenye hwobhala; Aje! Tibhalimanye bhole idala? ");
INSERT INTO sbk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","O Yesu abhozezye, “Ane endili dala, lyoli, no womi; nomo wagenza hwa Daada ila ashilile huline. ");
INSERT INTO sbk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nkashe mugamenye ane, handamumenye no Daada wane nantele; ahwande esalezi na hwendelele muhamanya na mulolile omwane.” ");
INSERT INTO sbk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","O Philipo abhozya oYesu, “Gosi, tilanje Odaada, esho shibhabhe shitiyiye.” ");
INSERT INTO sbk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","O Yesu abhozya, “Sendi pandwemo namwe hu muda otali, no oliseele somenye ane, Philipo? Wawonti wandolile ane alolile Odaada; shili bhole oyanga, 'Tilanje Odaada'? ");
INSERT INTO sbk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Semuhweteshela aje ane endi muhati ya Daada, oDaada ali muhati yane? Amazu geyanga hulimwe seyanga kulengana nane nene; baadala yakwe, Odaada wa hwizya mhati yane abhomba embombo yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Neteshele ane, aje ehwendi muhati ya Daada, no Daada ahweli mhati yane; shesho neteshe ane afutane nembombo zyane eshi. ");
INSERT INTO sbk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Etesheli, etesheli, embabhozya, omwane waneteshela, ane embombo zila zyebhomba, aibhomba embombo ezyo wope nantele na aibhomba hata embombo engosi afuatanaje embala hwa Daada. ");
INSERT INTO sbk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hahonti hamulabha hwitawa lyane, embabhombe aje Odaada nkamwamihwe hwa Mwana. ");
INSERT INTO sbk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nkashe mulabhe ahantu hahonti hwi tawa lyane, eho embabhombe. ");
INSERT INTO sbk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nkashe mubhangane, mubhazighate endajizyo zyane. ");
INSERT INTO sbk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nane embahulabhe Odaada, Wope anzabhapele omwavwi wamwabho aje abhe pandwemo namwe wilawila, ");
INSERT INTO sbk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ompempo we lyoli. Ensi sewezizye ahuposhele omwane afuatana naje seuhulola, au humemwe omwene, ata sheshi amwe mumenyo omene, afuatane na aibha muhati yenyu. ");
INSERT INTO sbk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Senaibhaleha mubhene; Naiwela hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hu nsiku endodo, ensi seyayindola nantele, ila amwe mundola. Afuatane naje ahwizya namwe mwaizya nantele. ");
INSERT INTO sbk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hwi siku elyo mwaimanya aje ane ehwendi muhati ya Daada, naje amwe muli muhati yane, naje ane endi muhati yenyu. ");
INSERT INTO sbk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wawonti wakhata endajizyo na zibhombe, yayola omo wangene ene na wangene ane; na wangene ane aiganwa no Daada wane, naihugana na naihwibhonesya ane nene hwa mwene.” ");
INSERT INTO sbk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O Yuda (siyo Iskariote) abhozya oYesu, “Gosi, Aje! Yenu yebha fumile aje obhahwibhonesye wewe? ");
INSERT INTO sbk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O Yesu ayanjile ajile, “Nkashe wawonti wangene, abhakhate izu lyane. Odaada wane anza hugane, na tibhahwenze hwa mwene na tibhabheshe okhalo gwetu pandwemo no mwahale. ");
INSERT INTO sbk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wawonti wasangene ane, sakhata amuzu gane. Izu lya mhonvwa se lya line ila Daada wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Enjanjile enongwa ezi hwalimwe, omuda gwe hwizya pandwemo namwe. ");
INSERT INTO sbk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ata sheshi, Mfariji, Ompepo Ofinjile, lyane Odaada aihutuma hwitawa lyane, aibhasambelezya enongwa zyonti na aibhabheha aje mkoboshe gonti gehayanjile hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Olusongwo embapele olusongwo lwane amwe. Sembapele na ensi sepela. Muganje abheshe amoyo genyu abhe no walangano, no bhonga. ");
INSERT INTO sbk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwahonvwezye shila shehabhabhozezye, esogola nantele naiwela hulimwe.' Nkashe mugangene ane, mwenzabhe no losongwo afuatanaje embala hwa Daada, afuatanaje Odaada gosi ashile ane. ");
INSERT INTO sbk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Esalezi yanje namwe amazu gaminji, afuatanaje ogosi wensi ene ahwenza omwene saali ne nguvu pamwanya yane. ");
INSERT INTO sbk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sembayanje namwe amazu gaminji, afuatanaje ogosi wensi ene ahwenza omwene saali ne nguvu pamwanya yane, ");
INSERT INTO sbk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","aje ensi epate amanye aje egene Odaada, ehomba hala Odaada handajizya ane, nanshi shila shampiye endajizyo. Bhoshi, tifume apantu epa. ");
INSERT INTO sbk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ane endi mzabibu ogu gwe lyoli, odaada wane omwene mkulima we mzabibu. ");
INSERT INTO sbk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Isamba lya salipapa endondo, elyefwa ila isamba lya lipapa endondo alyefwa ili aje nkali papaje tee. ");
INSERT INTO sbk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amwe muli bhinza alengane ne nongwa yembabhozezye. ");
INSERT INTO sbk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mukhale muhati yane na muhati yenyu. Nanshi isamba seligapapa lyene nkaselili mumuzabibu, shesho namwe, nkase mukhala muhati yane. ");
INSERT INTO sbk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ane endi mzabibu; amwe muli nsamba. Wakhala muhati yane nane muhati yakwe, omuntu ono apapa endondo zinyinji, afuatanaje bila ane amwe simuwezizye abhombe embombo yayonti. ");
INSERT INTO sbk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nkashe omuntu wawonti wasaga abhakhale muhati yane, abhatagwe nanshi osamba na hwome; abhantu bhabhonganya amasamba na agataje humwoto, na galongolela. ");
INSERT INTO sbk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nkashe mubhakhale muhati yane, na nkashe amazu gane ganzakhale muhati yenyu, labhaji lyalyonti lya mubhahwanze, namwe mubhabhombelwe. ");
INSERT INTO sbk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hweli odaada amwamihwe, naje mupapa endondo zinyinji naje bhanafunzi bhane. ");
INSERT INTO sbk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nkashe odaada wane shangene ane, ane nane embagene amwe, khalaji mulugano lwane. ");
INSERT INTO sbk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nkashe mubhakhate endajizyo zyane, mubhakhale mulugano lwane nashi shehete endajizyo yza daada wane na khale mulugano lwakwe. ");
INSERT INTO sbk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Enjanjile enongwa ezi hulimwe aje olusongwo lwane lubhe muhati yenyu na aje olusongwo lwenyu lubhombeshe abhe golusu. ");
INSERT INTO sbk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Olu lulajizyo lwane aje mganane amwe hu mwemwe nanshi sembagene amwe. ");
INSERT INTO sbk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nomo omuntu waali nolugano ogosi ashile ou aje afumwe olwizo lwakwe eshauli ya bhanje. ");
INSERT INTO sbk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amwe muli bha mwetu nkamubhabhombe gala gembalajizya. ");
INSERT INTO sbk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sembakwizyabhaboyi, afuatanaje oboyi samanya kila habhomba ogosi wakwe. Embakwizya amwe bhamwetu, alenganaje embabhozezye enongwa zyonti zyenonvwezye afume hwa Daada. ");
INSERT INTO sbk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Semwansaluye ane ila ane nabhasaluye amwe na bhabheshe aje mubhalaje apape endondo, na endondo zyenyu zipate akhale. Eli lili eshi aje hahonti hamulabha hwa Daada hwi tawa lyane, anzabhapele. ");
INSERT INTO sbk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Enongwa ezi embalajizya aje mganane shila muntu nowamwabho. ");
INSERT INTO sbk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nkashe ensi enzabhavitwe, mumanye aje ebhanvitwe nene sheli seele abhavitwe amwe. ");
INSERT INTO sbk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nkashe mugali bha munsi, ensi handa ebhagene nanshi bha mwabho; Afuatanaje amwe semuli bha munsi na afwatanaje senabhachaguye afume munsi, afuatane neshi insi ebhavitwa. ");
INSERT INTO sbk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Komboshi izu lyana bhabhozezye, 'Oboyi se gosi ashile ogosi wakwe.' Nkashe bhanjenvezye ane, bhaibhaye nvya lyane, handabhakhete iklyalimwe lyape. ");
INSERT INTO sbk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bhaibhabhombela amambo ega gonti alengane ni tawa lyane alengane sebhamenye ola wantumile. ");
INSERT INTO sbk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nkashe engalisenenzele na bhabhozye handasabhabhombile embibhi, ila esalezi sebhali noudhuru hu mbibhi zyabho. ");
INSERT INTO sbk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wanvwitwa ane ahuvitwa yo Daada nantele. ");
INSERT INTO sbk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nkashe sembombile embombo muhati yabho enganomo omo wabho waibhombile, handasebhali ne mbibhi; ila esalezi wabhombile gonti gabhele bhalolile na bhvitilwe ane no Daada wane. ");
INSERT INTO sbk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ene efumila aje izu likamilishe lyalyandihwe mundajizyo: 'Zyabhowanvitwa ane bila li kosa.' ");
INSERT INTO sbk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Wazinda ayenzele, wembahufume hulimwe afume hwa Daada, ono yayono, Ompepo we lyoli, wafuma hwa Daada, aihakikisizya. ");
INSERT INTO sbk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Amwe mhakikisizya afuatanaje muuli pandwemo nane afume ahwande. ");
INSERT INTO sbk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Embabhozya enongwa ezi aje mganje avisye. ");
INSERT INTO sbk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bhaibhafumya mwonze mumabhanza; lyoli esala ehwenza shila waibhabuda aisebha aje abhomba mbombo enyinza hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bhaibhabhomba enongwa ezi alengane sebhamanye Odaada wala sebhamenye ane. ");
INSERT INTO sbk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Embabhozezye enongwa ezi aje ensiku nkazyafiha zyafumile mwaiwezya agakomboshe na shila shanabhabhozezye muwezye bhene. Sembhabhozezye alengane ne nongwa ezi ahwande huwandilo alenganaje nali pandwemo namwe. ");
INSERT INTO sbk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Japo esalezi, embala hwola wantumile; ia nomo omo wenyu wambozezya, “Obhala hwii?” ");
INSERT INTO sbk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Alengane enjanjile enongwa ezi hulimwe, ozungumizu umemile muoyo genyu. ");
INSERT INTO sbk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ata shesho, embabhozya elyoli: shinza hulemwe nkanasogola; afuatanaje wabhazinzya sagayenza hulimwe; ila nkanabhala naihutuma hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nkawenza oyo wabhazinzya aiyomezya ensi ahusiane ne mbibhi, ahusiane ne lyoli na ahusiane nolonzi. ");
INSERT INTO sbk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ahusiane ne mbibhi, alenganaje sebhaneteshe ane, ");
INSERT INTO sbk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ahusiane ne lyoli, afuatanaje embala hwa Daada na semwaindola nantele; ");
INSERT INTO sbk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ahusiane no lonzi alenganaje ogosi we nsi ene alongwilwe. ");
INSERT INTO sbk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Endinago minji gabhabhozye, ila semubhagelewe esalezi. ");
INSERT INTO sbk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ila, omwene, Ompepo welyoli, nkawenza aibhalongozya mulyoli yonti; afuatanaje sagaiyanga hu sababu yakwe yoyo; ila wawonti ganzagonvwe anzagayanje amambo ego; na aigabhonesya hulimwe amambo gagayenza. ");
INSERT INTO sbk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Omwene aimwamiha ane, alenganaje aigayanga mambo gane na agatangazye hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Evintu vyonti vyalinavyo oDaada vyaline; eshi eshi, enjanjile aje Ompepo ayaga amambo gane na gabhonesye hulimwe. ");
INSERT INTO sbk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bado ensiku ndodo, semwaindola nantele; baada ye muda ododo nantele, mwaindola.” ");
INSERT INTO sbk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bhamo awanafunzi bhakwe bhabhozanya, “Ye yenu yatibhozya, “omuda ododo, na semwaindola nantele,' no omuda ododo nantele,' mwaindola,' alengane embale hwa Daada?” ");
INSERT INTO sbk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Eshi eshi bhayanga, “Hantu nshi hayanga, 'Bado omuda odod'? Setimenye zyayanga.” ");
INSERT INTO sbk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","O Yesu alolile aje wazilishe ahubhozezye, wope ayanga, “Muhubhozezya mubhene ahusu eli, shenjanjile, 'Bado omuda ododo, semwaindola nantele; baada ye muda ododo mwaindola'? ");
INSERT INTO sbk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Etesheli, etesheli, embabhozya, mwalila na hwilombozye, ila ensi yayisongwa, mwazugumile, ila ensi enzugumila yenyu yaigaluha lusongwo. ");
INSERT INTO sbk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Oshe abhazugumizu lula lwa bhano uchungu alengane naje omuda gwa pape gufishile; ila nkawa papa omwana, sakomboha nantele ambabha, afuatanaje no lusongwo lwakwe aje omwana apepwe munsi. ");
INSERT INTO sbk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Amwe nantele muzugumiye esalezi, ila naibhalola nantele; na moyo genyu gaisongwa na nomo waiwezye abhefwezye olusongwo lwenyu. ");
INSERT INTO sbk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Isiku elyo semwaimbozya enongwa. Etesheli, etesheli, Embabhozya nkamulabhe lyalyonti hwa Daada, aibhapela hwi tawa lyane. ");
INSERT INTO sbk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paka semulabhile lyalyonti witawa lyane; labhaji mubhaposhele aje olusongwo lwenyu lukamilishe. ");
INSERT INTO sbk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Enyanjile namwe hunjango yasemanyiha, ila esala ehwenza senaiyanga hujango yasemanyiha baada yesho naibhabhoyza papa zelu ahusu Odaada. ");
INSERT INTO sbk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Isiku elyo mwailabha hwitawa lyane, sembabhozya aje nailabha hwa Daada husababu yenyu; ");
INSERT INTO sbk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Afuatanaje Odaada yoyo abhagene alenga mungene ane na afuatanaje muneteshe aje enfumile hwa Daada. ");
INSERT INTO sbk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nafumile hwa Daada na enenzele munsii; nantele, esogola munsi na embala hwa Daada”. ");
INSERT INTO sbk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abhanafunzi bhakwe bhabhozya, “Oloola, esalezi oyanga papazelu na sotumila amalibho. ");
INSERT INTO sbk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Esalezi, timenye aje amenye amambo gonti, na sohwanza omuntu wawonti abhozezye enongwa. Afutanaje tihweteshela aje ofuma hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","O Yesu ajile, “Esalezi eneteshe?” ");
INSERT INTO sbk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Enya, esala ehwenza, yoli nalyoli ifishile, mwainuha kila muntu amwabho mwaindeha nene. Ila sendi nemwene afuatanaje oDaada ahweli nane. ");
INSERT INTO sbk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Embabhozya amambo ega aje muhati yane mubhe na songwe. Munsi muli amashida, ila hwipeli omwoyo, enjitolile ensi. ");
INSERT INTO sbk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","O Yesu ayanjile amambo ega; nantele abhozya amaso gakwe ahwenyelezye amwanya na yanje, “Daada, esala efishile; mwamishe omwana waho ili omwana wope nkamwamishe awe - ");
INSERT INTO sbk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","nashi shila shopiye enguvu huu vyonti vyavili nobele aje abhapele owomi wewilawila bhonti wopiye. ");
INSERT INTO sbk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ou wowomi wewilawila: aje bhamanye awe, Ongolobhe we lyoli na woli humwene, nolo wotumile, oYesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Namwamishe epa pansi, naimalezye embombo yohampiye aje enjibhombe. ");
INSERT INTO sbk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Esalaezi, Daada, omwamishe ane pamoja nawe wewe huumihwe uula wendi nowo pandwemo nawe sheti seele abhombwe ensi. ");
INSERT INTO sbk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nalikwinkuye itawa lyaho hwa bhantu bhompiye epa pansi. Bhali bhantu bhaho; ila wampiye ane. na bhope bhalikhete izu lyaho. ");
INSERT INTO sbk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Esalezi ohwelewa aje shila hantu hompiye ane hafumile huliwe, ");
INSERT INTO sbk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","hu mazu gala gompiye ane— Embapelile abhahale amazu ego. Wagejeleye nantele na wamanya aje ane enfumile huliwe, na bheteshela aje awe wontumile. ");
INSERT INTO sbk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Embaputila abhahale. Senjiputila ensi ila bhala bhompiye afuatanaje abhahale wahuliwe. ");
INSERT INTO sbk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Evintu vyonti evyahuline vyahuliwe na vila vyolinavyo vyahuline nane emwamihwa hwevyo. ");
INSERT INTO sbk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ane sehwendi nantele munsi, ila bhahale bhahweli munsi, nane esalezi ehwenza huliwe. Daada Wozelu, omwoyo obhasonje hwi tawa lyaho lila bhabhe nolwonvano nanshi shila ane nawe shatili no lwonvwano. ");
INSERT INTO sbk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nanali nabho, nabhasonjele hwitawa lyompiye; Nawasonjele, na nomo mhati yabho watejile ila omwana otezu, amazu nkagatimile. ");
INSERT INTO sbk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Esalezi ehwenza huliwe; ila eyanga ega munsi aje olusongwo lwane lugoloshe muhati yabho bhebho. ");
INSERT INTO sbk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Embapiye izu lyaho; embavitilwe aje abhene sebha munsi, nanshishi ane shasendi wa munsi. ");
INSERT INTO sbk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sembaputila aje obhefwe munsi ila obhasonje nola obhibhi. ");
INSERT INTO sbk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Abhene sebhamunsi nanshi shila ane shasenali wa munsi. ");
INSERT INTO sbk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ubhabheshe bhagolosu huliwe wewe mu lyoli; izu lyahaho ye lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wantunile munsi, naane embafumile munsi. ");
INSERT INTO sbk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Alengane nabhene ane neene ehwifumya huliwe aje wope nkabhahwifumyaje huliwe hwela elyoli. ");
INSERT INTO sbk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sio aje ebha bhene bhembaputila na bhala bhabha yeteshela ishilile izu lyaho ");
INSERT INTO sbk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","aje bhope ebho bhabhe no lwonvwano nanshi shila awe Daada, sholi muhati yane nane muhati yaho. Embaputila aje abhene bhawezye abhe muhati yetu ili ensi nkeyeteshele aje awe wontumile. ");
INSERT INTO sbk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Omwamihwe ula wompiye ane - nane embapiye abhehali, aje bhawezye abhe no lwonvwano nanshile ate shatili no lwonvwano - ");
INSERT INTO sbk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ane muhati yabho wope muhati yane, aje nkabhawezye akamilisiwe huu, aje ensi nkemanye aje yooli awe wontumile, na abhagane, nanshi shila awe shongene, ane. ");
INSERT INTO sbk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Daada hala hompiye ane - Eziliha aje abhene wope bhawezye abhe pandwemo nane apantu pehwendi wawezye alole oummwamihwe wane, ula wompiye: afuatanaje awe ohangane ane shagelisele misingi gensi. ");
INSERT INTO sbk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Daada welyoli, ensi seyamenye awe, ila ane namenye awe; na bhamenye aje ohantumile. ");
INSERT INTO sbk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nabhashele aje itawa lyaho limanyishe hwa bhene, embalibheshe limanyishe aje olwonvwano olwo lwo hangene ane luwezye abhe muhati yabho, nane embezye abhe muhati yabho.” ");
INSERT INTO sbk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","O Yesu nayanga enongwa ezi, asogoye na bhanafunzi bhakwe ahwenyezye entebha ye Kidron, hwa hwali ne bustani, huula omwene na bhanafunzi bhakwe bhahinjila muhati yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Esheshi ola oYuda, wahanzaga ahugalushe, wope aimenye eshemu eyo, afuatanaje oYesu abhalaga husehemu ela mara hahinji abhalaga na bhanafunzi bhakwe. ");
INSERT INTO sbk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wope oYuda, nawapata ikundi lya sikari na maofisa afume hwa gosi adimi bhahenza ne tala, ikurunzi ne silaha. ");
INSERT INTO sbk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wope oYesu, ohu amenye shila hantu hahali habhombeha zaidi yakwe ahwifumizye hwitazi na abhabhozya, “Wenu wamuhumwanza?” ");
INSERT INTO sbk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wope wajile, oYesu Mnazareti.” O Yesu abhabhozya, “Ane nene” Wope oYuda wagalushe oYesu ahali ayemeleye na asikari bhala. ");
INSERT INTO sbk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eshi eshi embabhozya, “Ane nene” bhawela shingunga bhagwa pansi. ");
INSERT INTO sbk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wabhabhozya nantele, “Wenu wa muhumwanza? Bhope waga nantele “oYesu Munazareti.” ");
INSERT INTO sbk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","O Yesu wabhobhozya, “Embabhozezye aje ana nene; eshi nkashe munaanza ane, bhaleshi ebha abhnje bhabhalaje.” ");
INSERT INTO sbk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ega gali esho aje lila izu likamilishe; pala nayangaga; hwa bhala bhohampiye, senatezizye hata weka.” ");
INSERT INTO sbk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","O Simoni Petro, waali ni panga, wega nahudumule ikutu lya hundeelo oboyi wa Dimi ogosi. Ni tawa lyakwe oboyi ola ali yo Malko. ");
INSERT INTO sbk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","O Yesu abhozya oPetro, “Wezya ipanga lyaho hu ala yakwe. Yenu ensamwelee eshikombe shila shampiye oDaada?” ");
INSERT INTO sbk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eshi lila ikundi lya skari na jemedari, na boyi bha Yahudi, bhakhata oYesu na hupinye. ");
INSERT INTO sbk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wope walongola nasoti pa hwa Anasi, amwane ali khoi wa Kayaafa, ola wali wa Dimi ogosi omwaha ogwo. ");
INSERT INTO sbk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kayafa wabhapiye oushauri Ayahudi yahanziwaga aje omuntu omo afwe husababu ya bhantu. ");
INSERT INTO sbk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","O Simoni oPetro alondoleye oYesu, na shesho omwanafunzi wamwabho. Nola omwanafunzi ali afamahamiha hwa dimi ogosi, wope ahinjila pandwemo no Yesu mwibehewa ilya Chungaji ogosi; ");
INSERT INTO sbk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","o Petro ali ayemeleye honze hu ndiango. Ola omwanafunzi wa manyishe hwa dimi ogosi, afumile honze abhala ayanje nola oshe oboyi waalindaga ondiango na humwinjizye oPetro. ");
INSERT INTO sbk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ola oboyi walindaga ondiango, abhozezye oPetro, “Aje awe solo pandwemo na bhantu bha muntu ono?” Wope ajile, “Ane wenje.” ");
INSERT INTO sbk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na bhala aboyi bha gosi bhahemeleye apantu pala; bhapembile omwoto afuatanaje hwali isasa, na shesho bhali bhahwota omwoto aje apate ilyoto. Wope oPetro ali nabho, ahwote omwoto ali ayemeleye. ");
INSERT INTO sbk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Odimi ogosi abhozezye oYesu ahusu abhanafunzi bhakwe ne nsambelezyo zyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O Yesu ajile, “Enjebho zyezye pazelu ensi; Ane na sambelezezye wilawila mshibhanza na pantu pala Ayahudi pabhabhonganaga. Nane senayanjile lyalyonti. ");
INSERT INTO sbk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yenu mwabhozezyaga? Bhabhozyaji ahusu hala hanayanjile. Ebha abhantu bhamenye amambo gananjile. ");
INSERT INTO sbk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","O Yesu nahayanga ezyo, omo wa gosi ali ayemeleye wa khoma oYesu hu khono ogwakwe na pamande waga, “Esho, shashi hwanziwa ahugamule odimi ogosi?” ");
INSERT INTO sbk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wope oYesu ajile, “Nkashe enjanjile enongwa zyazyonti embibhi obhe keti hwego amabhibhi, na nkashe egomoye shinza yenu ekhomwa? ");
INSERT INTO sbk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","O Anasi atwala oYesu hwa Kayafa hwa chungaji ogosi ali afungulwe. ");
INSERT INTO sbk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","O Simoni oPetro ali ayemeleye wahwikosya ilyoto yoyo. Bhala abhantu bhabhozya. “Aje, awe nawe soli pandwemo na bhanafunzi bhakwe?” Wakhana waga, “Ane weenje.” ");
INSERT INTO sbk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Omo omo waboyi bhachungaji ogosi, waali holo wa lume waadulwe ikutu, ajile, “Se wewe elolile hula hu bustani?” ");
INSERT INTO sbk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","O Petro akhana nantele, na Ehanda ahekuga. ");
INSERT INTO sbk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bhahamwega oYesu afume hwa Kayafa paka hu Praitorio. Hwali shapwiti na mazansha. Abhene bhebho sebhahinjiye ePraitorio bhasiye ahwiyonvwe ailye epasaka. ");
INSERT INTO sbk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","O Pilato abhabhalilia ahayanga. “Ahaga listako bhole lyalihuhusu omuntu ono?” ");
INSERT INTO sbk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bhayanga na hubhozye, “Nkashe ono muntu agalisebhomba mbibhi, handa setiletile huliwe.” ");
INSERT INTO sbk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","O Pilato abhabhozya, “Mweji amwe mwemwe, mulonje alengane nendijizyo zyenyu bhope.” Ayahudi bhabhozya, “Endajizyo sezitibhozya abude omuntu wawonti.” ");
INSERT INTO sbk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bhayanjile ezi aje izu lya Yesu likamilishe izu lya ayanjile ahusu enfwa yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","O Pilato ahinjila nantele hu Praitorio akwizya oYesu; ahabhozya, “Aje, awe oli mwene wa Ayahudi?” ");
INSERT INTO sbk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","O Yesu ajile, “Aje, awe ombozya ni swali eli ohwanza amanye au afuatanaje bhatumile aje ombozye ane?” ");
INSERT INTO sbk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wope oPilato ajile, “Ane sendi Yahudi, aje seshashesho?” Ikabela lyenyu no chungaji ogosi ebho bhabhaletile huline; awe obhombile yenu? ");
INSERT INTO sbk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O Yesu ajile; oumwene wane sewamu omu, nkashe oumwene wane ugaali wa munsi omu aboyi bhane handa bhahomaniye waganje anfume hwa Yahudi. Lyoli oumwene wane seufuma epa” Pansi ");
INSERT INTO sbk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","O Pilato abhozya, “Aje awe eshi oli mwene?” O Yesu ajile, “awe shili shoyanga aje ane endi mwene, afuatana neshi napepwe alenganeshi ane enenzele munsi aje embe keti weela elyoli. Wawonti waali neyo elyoli elitejezya izu lyane. ");
INSERT INTO sbk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","O Pilato abhozya, “Elyoli yenu?” Wope nayanga ego ahabhala hwa Yahudi na bhabhozye “Selola nkahamo hwa muntu ono. ");
INSERT INTO sbk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amwe mulinoutamaduni wamubhomba emwegulile ofungwa omo owakati we Pasaka. Aje muhwanza aje embigulile omwene wa Yahudi.” ");
INSERT INTO sbk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bhahomile ekelele bhaile, sio ono, tigulile oBaraba.” Wope oBaraba alifyozi. ");
INSERT INTO sbk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","O Pilato amwejile oYesu na hushete. ");
INSERT INTO sbk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bhala asikari bhapotile aminvwa nalenganye taji. Bhaibheha pitwe lya Yesu na hukwatizye amenda ge rangi ye nshamwamu nshamwamu. ");
INSERT INTO sbk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhamwenzela na aje, “Awe mwene wa Yahudi! na hukhome hu makhono gabho. ");
INSERT INTO sbk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","O Pilato afumile honze na bhabhozye abhantu, “Enyaji embaletela ono omuntu hulimwe aje mumanye ane senalilolile ibhibhi lyalyonti muhati yabho.” ");
INSERT INTO sbk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eshi oYesu afumile honze; ali akwete etaji ye minvwa na menda amashamwamu. O Pilato ayanga, “Enyaji abhozya mwenyi omuntu ono epa!” ");
INSERT INTO sbk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Omuda ochungaji ogosi wa gosi nabhahalola oYesu, bhakhoma ekelele bhaga, “Yenvyaji, yenvyaji.” O Pilato abhabhozya, “Mwenji amwe mwemwe muyenvyaje, afuatanaje ane sendilola akosa muhati yakwe.” ");
INSERT INTO sbk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayahudi bhabhozya oPilato, “Ate tili ne ndajizyo, na hundajizyo yeeyo ehwanziwa afwe afuatanaje omwene ahwilola aje mwana wa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","O Pilato nahonvwa enongwa ezyo azidile ahwogope, ");
INSERT INTO sbk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ahinjila Mpraitorio nantele na hubhozye oYesu, “Awe ofuma hwii? Ata sheshi, oYesu sagayanjile. ");
INSERT INTO sbk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nantele iPilato abhozya, “Aje, awe soyanga nane? Aje, awe somenye aje ane endi nouwezo wa humwigugulile no uwezo wa huyemvye?” ");
INSERT INTO sbk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O Yesu ajile, “Ogali ne nguvu ashile ane ogalisopewilwe afume amwanya. Eshi, omuntu wanefwizye huliwe ali ne mbibhi engosi.” ");
INSERT INTO sbk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Afumilane ni jibu eli, oPilato ahanzaga ahuleshe weene, ila Aayahudi wahakhoma ekelele bhaga, “Nkashe obhahuleshe wene awe soli wamwabho oKaisari: Shila wahwibheha aje mwene ayanga shingunga sha Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","O Pilato na honvwa enongwa aleta oYesu honze nantele ahakhala pitengo lye lonzi pala papamanyi she aje sakafu, ila hushiEbrania, Gabhatha. ");
INSERT INTO sbk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Isiku lye maandalizi ge pasaka nalyafishile, omuda gwe saa tanda. O Pilato abhozya Ayahudi, “Enyaaji omwene wenyu ono epa!” ");
INSERT INTO sbk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bhakhoma ekelele, “Sogozi, sogozi, muyenvye!” O Pilato abhabhozya, “Aje eyenvye omwene wenyu?” Wope Ochungaji ogosi ajile, “Ate setili no mwene ila o Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","O Pilato nkafumya oYesu hwabhene aje ayenvewe. ");
INSERT INTO sbk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wope bhamwega oYesu, wope wafuma, ohu anyemuye eshikhobhe hanyo shakwe yoyo paka hula hufuvu litwe, hu Shiebrania bhaiga hu Golgota. ");
INSERT INTO sbk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nkabhayenvya oYesu na bhala alume bhabhele, omo oupande ou owamwabho oupande ou, no Yesu pahati yabho. ");
INSERT INTO sbk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O Pilato ahandiha eshimanyilo na bheshe pamwanya pashi khobhehanyo. Epo pahandihwe: YESU WENAZALETI, OMWENE WA YAHUDI. ");
INSERT INTO sbk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Abhinji bha Yahudi bhabhazya eshimanyilo esho pantu pala pabhayenvezye oYesu pali pepe ne khaaya. Eshi manyilo esho shahandihwe hushi Ebrania, hushi Rumi na hushi Yunani. ");
INSERT INTO sbk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ogosi bha dimi bha Yahudi bhabhozya oPilato, “Sio hwandishe, 'Omwene wa Yahudi; ila omwene ajile ane endi mwene Wayahudi.” ");
INSERT INTO sbk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Wope oPilato ajile, “Genandishe enandishe.” ");
INSERT INTO sbk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Askari nabhayenvya oYesu, bhahega amenda gakwe na gagabhanye vilondo viine, shila sikari ilondo limo, Shesho inkanzu, lila selyalilisonilwe ila lyali litabhilwe lyonti afumile pamwanya. ");
INSERT INTO sbk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bhakwepelana bhebho hu bhebho, “Tinganje alipasule ila tikhome yekola aje libhe lyananu.” Eli lyafumiye aje lila izu likamilishe, lila lyalyajile bhagabhenye amenda gane, no ninkanza lyane bhakhomeye ekola.” ");
INSERT INTO sbk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Asikari bhabhombile embombo ezi. Onyina wakwe oYesu, no dada wa nyina wakwe, oMariamu oshe wa Kleopa no Mariamu Magedelena - abhashe ebha bhali bhemeleye pepe neshi khobhehanyo sha Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","O Yesu nalolile onyina wakwe pamonola omwanafunzi wagene bhemeleye peepe, abhozye onyina wakwe, “Wee shee, enya, lola omwana waho ono epa!” ");
INSERT INTO sbk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Abhozya omwanafunzi, “Enya, ono epa onyina waho. “Afume esala eyo ola omwanafunzi amwega abhale akhaya yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Baada yelyo, o Yesu amenye aje gonti gamalishe gamalishiye aje akamilisye amaazu, ajile, “Elola eshomelwa.” ");
INSERT INTO sbk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eshelelo shashilimemile shali shibhehwelwe pala, bhabheha esifongo yememile Isiki pamwanya ye ufito we hisopo, bhabheshela mwilomu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wope oYesu naibhonga ezyo, ajile, “Emalishe.” Pamande aundamiha itwe lyakwe, aibheha eroho yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Afwatanaje waali wakati wahwiyandaale, afuatanaje amabele segahanziwaga asagale pashikhobhehanyo owakati we Sabato (afuatanaje eSabato yaali ye muhimu), ayahudi bhalabhile oPilato aje amagaga gabho bhala bhabhali bhayenvezewa gabudulwe, naje na mabeele gabho bhagisye. ");
INSERT INTO sbk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Osikari ahenza abudule amagaga gamuntu owa kwanza no wa bhele ali ayonvewa pandwemo no Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nabhafishila oYesu, bhamweje afwiye eshieshi sebhabudula amagaga gakwe. ");
INSERT INTO sbk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ata sheshi omo wa sikari alese oYesu hu mbazu ne mpalala, gahafuma amenze gidanda. ");
INSERT INTO sbk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wope walolile eli afumwizye olweteho no lweteho lwakwe lwe lyoli. Omwene amenye hayanjile he lyoli aje namwe mweteshele. ");
INSERT INTO sbk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Enongwa ezi zyahali aje lila izu lyalya ya ngwilwe nkalifishile, “Nomo hata omo wamwene waibudulwa.” ");
INSERT INTO sbk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nantele izu lyamwabho liyiga, “Bhahumwenya omwene wabhalese” ");
INSERT INTO sbk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baadaye nongo ezi oYusufu we Arimathaya, afuatanaje ali mwanafunzi wa Yesu, ila shi siri abhogope Ayahudi, alabhile oPilato aje agweje obele gwa Yesu. Wope oPilato apiye oluhusa. O Yusufu ahenza agwefwe obele gwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Wope o Nikodemo ola olwahwande wafwatile oYesu no siku wope ahenzele. Omwene aletile osangano manemane no udi, oumwamuwe latili mia e yeeka. ");
INSERT INTO sbk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bhahega obele gwa Yesu bhagupinya mumpongoso ye shitani pandwemo na gala amafuta, nanshi shahali ekawaida ya Yahudi omuda gwa syele. ");
INSERT INTO sbk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Apantu oYesu pabhayenvezye pali nee bustani; muhati yela ebustani mwali ni kaburi ipya sayahali omuntu wawaile asyelwe omwo. ");
INSERT INTO sbk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Afuatanaje lyali lisiku lye maandalizi hwa Yahudi, na afuatanaje lila ikaburi lyali peepe, bhahagoni oYesu muhati yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Khasha isiku lya hwande lya mulwa sanu, shahuli nkisi, oMariamu Magederena ahenzele hwi kaburi; ahalola lila lila iwe lyepile pikaburi. ");
INSERT INTO sbk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ahashembela abhale hwa Simoni oPetro na hwola omwanafunzi wamwabho ola oYesu wagene, nkabhabhozya, “bhamwejile Ogosi mwikaburi, na setihwelewa hula hwabhagonizye.” ");
INSERT INTO sbk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","O Petro no mwanafunzi ola wamwabho bhahafuma abhale hwi kaburi. ");
INSERT INTO sbk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhonti bhanyilile pandwemo; ola omwanafunzi wamwabho anyililiye tee ashile oPetro nagishe hwi kaburi abhe wa hwande. ");
INSERT INTO sbk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ahemelela na hwenye ikaburi; alola ela empogoso egonile, ila sagaahinjiye muhati. ");
INSERT INTO sbk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wope oSimoni oPetro wope ahafiha ahinjila muhati yi kaburi. Wailola ela empogoso egonile pala ");
INSERT INTO sbk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nela eleso yayali hwitwe lyakwe seyali ogonile pandwemo ne mpogoso yayagonile panshenje yakwe. ");
INSERT INTO sbk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ola omwanafunzi wamwabho wope ahunjiye muhati yi kaburi; walola na hweteshele. ");
INSERT INTO sbk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Afuatanaje paka owakati owo bhaali seele sebhagamenye amaazu aje yalazimishe oYesu afufushe nantele hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Abhanafunzi wahala nantele mukhaya zyabho. ");
INSERT INTO sbk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","O Mariamu ali ayemeleye pi kaburi alila, aali ahwendelela alile ahemeleye ahenya mwikaburi. ");
INSERT INTO sbk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ahabhalola ahalo ozelu bhabhele bhabhali no waje ozelu bhakheye omo hwitwe owa mwabho hu magaga apantu oYesu paali agonile. ");
INSERT INTO sbk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhope bhabhozya, “Oshe, yeenu olila?” Wope afuatanaje bhamwejile Ogosi wane, naane seehwelewa hwa bhabheshele.” ");
INSERT INTO sbk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nahayanga ego, agalushe na hulole oYesu ali ayemeleye. Ila sagamenye aje ali yo Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wope oYesu abhozya, “Maye yenu olila? Ohumwanza wenu?” Wope ohumwenyu yayola walenganya ebustani abhozya, “Gosi, nkashe wewe womwejile, mboozye, hwoobheshele nane embahumweje.” ");
INSERT INTO sbk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","O Yesu abhozya, “O Mariamu.” Wope agaluha yoyo na hubhozye hu Shiaramu, “Raboni,” esho hwahuje, “Mwalimu.” ");
INSERT INTO sbk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","O Yesu abhozya, “Oganje nguse, afuatane naje senzubhile abhale hwa Daada; ila obhale hwa holo bhane obhabhozye aje embazubhe abhale hwa Daada wane ola waali Daadi wenyu, Ongolobhe wane no Ngolobhe wenyu.” ");
INSERT INTO sbk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","O Mariamu oMagedelena ahenza abhabhozya abhanafunzi, “Elolile Ogosi,” naje abhozezye amambo ega. ");
INSERT INTO sbk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na hwahali ndyabheela, isiku elyo, isiku lya hwande lya mulwasanu, na mandiango gaali gafungwilwe pala abhanafunzi pabhahali hubhogope Ayahudi, oYesu ahenzele na hwemelele pahati yabho n abhabhozye, “Olusongwo lubhe hulimwe.” ");
INSERT INTO sbk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na hayanga ego abhalanga amakhono gakwe no bhazu lwakwe. Wope abhanafunzi nabhalolile Ogosi bhasongwelwe. ");
INSERT INTO sbk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","O Yesu abhabhozya nantele, “Olusongwo lubhe namwe. Nanshi Odaada shantumile ane, shesho shesho nane nabhafumile amwe.” ");
INSERT INTO sbk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","O Yesu nayanga ego, abhavuvia abhabhozya, Posheli Ompempo Ofinjile. ");
INSERT INTO sbk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wawonti wamuhusajila embibhi, bhasajilwe; na bhala bhamwaibhafunjila bhaifunjilwa.” ");
INSERT INTO sbk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","O Tomaso, omo wa bhala kumi na bhabhele, wahetwaga Didimasi, sagali na bhanafunzi amwabho oYesu lwa henzaga. ");
INSERT INTO sbk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bhala abhanafunzi amwabho bhabhozya pamande, “Tilolile Ogosi.” Wope abhozya, “Nkashe sembalole eshimanyilo she nsumari mumakhono gakwe, nabheshe evidole vyane hwesho eshimanyilo, nantele abheshe amakhono gane hubhazu lwakwe sembahweteshele.” ");
INSERT INTO sbk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na zyashila ensiku nane abhanafunzi bhali ampande nantele, wope oTomaso ali pandwemo nabho. A andiango nagafungwa oYesu ahemeleye pahati yabho. Na ayanjile, “Olusongwa lubhe namwe.” ");
INSERT INTO sbk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ahabhozya oTomaso, leeta eshidole shaho na alole amakhono gane; leeta eepa amakhono gaho obheshe pabhazu lwane; oganjebhe wasaahweteshela obhee wa hweteshela.” ");
INSERT INTO sbk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wope oTomaso ayanga ahaaga, “Gosi wane nantele Ngolobhe wane.” ");
INSERT INTO sbk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","O Yesu abhozya, Afuatanaje waandola, oyetesheye. Bhasailwe bhala bhabhahweteshela, bilaalole.” ");
INSERT INTO sbk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","O Yesu abhombile ezyaswije nyinji hwitazi lya bhanafunzi, zyasagaziwaile ahwandihwe mushitabu eshi; ");
INSERT INTO sbk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ezi zyandihwe aje nkamweteshe laje aje oYesu yo Kilisiti, mwana wa Ngolobhe, aje namu hweteshela mubhe no womi hwitawa lyakwe. ");
INSERT INTO sbk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baada ye nongwa ezyo oYesu ahwibhonesya nantele hwa bhanafunzi hunsombe ye Tiberia; eshi sha sheshi shahwibhonesezye yooyo: ");
INSERT INTO sbk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","O Simoni o Petro alipandwemo no Tomaso wa kwiziwa Didimas, o Nathanaeli wa hu kana ye Galilaya, abhana bha Zebedayo na bhanafunzi bhamwabho bhabhele bha Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","O Simoni Patro abhozya, “Ane embala ahwonze ensamaki.” Bhope bhabhozya, “Ate nate tibhala nawe.” Wahabhala bhahinjila mwi toli, ila nusiku owo bhonti sebhapete hahonti. ");
INSERT INTO sbk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Shapwinti na hwahasha, oYesu ahemeleye hufukweni, wope abhanafunzi sebhamanyaga aje aali yo Yesu. ");
INSERT INTO sbk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O Yesu abhabhozya, “Bhavijana, muli hahonti ahalyee?” Bhope bhayanga bhaga, “Hamuna.” ");
INSERT INTO sbk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wabhabhozya, “Isyii owavu oupande wendeelo witoli, namwe munzapate hashee, “Bhahisya owavu bhope sebhawezizye aakuunye nantele afuatanaje esamaki zyali nyinji. ");
INSERT INTO sbk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ola omwanafunzi oYesu wagene wabhozya Petro, “Yo Gosi.” Wope oSimoni Petro lwa honvwa aje yo Gosi, wahwipinya omwenda gwakwe (afuatanaje sagaakwete shinza), pamande wahwiponya mwinsombe. ");
INSERT INTO sbk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bhala abhanafunzi bhamwabho wahenza mwotori (sebhali hutali ne pwani, yali mita mia yeva afume ufukweni), bhope bhali bhakunya zila enyavu zyali zimemile ensamaki. ");
INSERT INTO sbk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na bhafiha hufwekweni, wagulola omwoto gwe kaala pala pamwanya yakwe pali ne nsamaki pandwemo na mabumunda. ");
INSERT INTO sbk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","O Yesu abhabhozya, “Leeti zimo ensamaki zyamwonzile esalezi eshi.” ");
INSERT INTO sbk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","O Simoni Petro waazubha aguvute gula owavu gwagwali gumemile ensamaki engosi, esamaki zyali 153; hata nkashe zyali nyinji, ula owavu sewazembushe. ");
INSERT INTO sbk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","O Yesu abhabhozya, “Enzaji mupate vigulilo ilomu.” Nomo ata weka hwa bhanafunzi walenjele ahubhozye, “Awe we weenu?” Bhamenye aje ali yo Gosi. ");
INSERT INTO sbk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","O Yesu ahenza, ahega lila ibumunda, pamande abhapela, abhomba shesho huunsamaki zila. ");
INSERT INTO sbk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ene yaali mara tatu oYesu hwa bhanafunzi bhakwe baada ya ovyionshe afume hwabhafwe. ");
INSERT INTO sbk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baada ya hwigule ilomu, oYesu abhozya oSimoni Petro, “Simoni mwana wa Yohana aje, ongene ane ashile ebha?” O Petro ahaga, “Ena, Gosi; “Awe omenye aje ane agene.” O Yesu abhozya, “Lisya awanangole bhane.” ");
INSERT INTO sbk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Abhabhozya emara ya bheele, “Simoni mwana wa Yona, aje, ongeene?” O Petro ahaga, “Ena, Gosi; awe omenye aje ane egene. “O Yesu ahaga, “Dima engole zyane.” ");
INSERT INTO sbk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Abhozya nantele emara ya tatu, “Simoni, mwana wa Yohana, Aje ongene?” Wope oPetro azugumila huu shila shabhozezye mara hatatu, “Aje awe ongene?” Wope ahaga, “Gosi, omenye gonti; omenye aje egene.” O Yesu ahaga, Lisya engole zyane. ");
INSERT INTO sbk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Eteshela, eteshela, ehubhozya, nawahali kijana wamanyene akwate amenda weewe na abhale hwa hwonti hwo hwanza; ila nawaibhagoogolo waigolosya amakhono gaho, no weenje aihukwatizya amenda na hutwale hwa sohwanza abhale.” ");
INSERT INTO sbk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","O Yesu ayanjile ega aje abhonesye aje nfwa bhole o Petro yagamwamishe Ongolobhe. Nayanga ega, abhozya oPetro, “Onfwate.” ");
INSERT INTO sbk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","O Yesu agalushe na hulole ola omwanafunzi ola oYesu wagene wabhalondola- Ono yayola wahagamiye pashifubha sha Yesu omuda gwe shalyee sha na ndabhela na hubhozye, “Gosi, wenu wanzahugalushe?” ");
INSERT INTO sbk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","O Petro alolile nantele wabhozya oYesu, “Gosi, Ono omuntu anzabhombe eyenu?” ");
INSERT INTO sbk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","O Yesu ahaga, “Nkashe ehwanza aje asagale paka lwanayenza, elyo lihusu yenu?” Nfwaate.” ");
INSERT INTO sbk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Enongwa ene yaahendelela mhati mwa bhala aholo, aje omwanafunzi ono sagaifwa. Ila oYesu sagabhozezye oPetro aje omwanafunzi oyo faafwa, “Nkashe ehwanza aje omwene asagale paka lwanayenza gahuhusu yenu?” ");
INSERT INTO sbk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ono yo mwanafunzi wafumya oluhakikisyo lwe enongwa ezi na timenye aje oluhakikisyo lwakwe lwe lyoli. ");
INSERT INTO sbk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gahweli amambo gamwabho gaminji oYesu gabhombile. Zigadolilwe zyonti elola aje ensi ene seyahenzaga aye avibheshe evitabu vyavigadolilwe. ");
INSERT INTO sbk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Eshitabu shila eshikulu nasimbile, Theofilo, nahayanjile zyonti zyahandile uYesu abhombe na manyizye, ");
INSERT INTO sbk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka isiku uYesu lyahejelewe humwanya. Eli lyabhombeshe uYesu nawafumya eamri ashilile hwa Umpepo Ufinjile hwa atumwe bhakwe bhabhasaluye. ");
INSERT INTO sbk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Baada ye mayemba agateswe, abhoneshe ali mwomi ne mbonesyo nyingi zyazyabhoneshe. Hunsiku amalongo gane ahwibhonesezye hwa bhantu bhakwe nayanje ezyeumwe zya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na patangene nabho abhalajizizye aje bhasahasogole mu Yelusalemu, lelo bhagule edagano zyayanjile, “Zyamwahumvwaga neyanga afume huline ");
INSERT INTO sbk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","aje uYohana abhozya naminzi lelo ane embabhozye nu Mpepo Ufinjile nkazyashila ensiku zishe.” ");
INSERT INTO sbk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nabhakhomene pandwimo bhahabhuzya, “Aje eshi jibha lwubhabhagomoshezye oumwene a Izraeli?” ");
INSERT INTO sbk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Umwene ahaga se shinza hulimwe amanye ezyahwibhesheye umwene Ungulubhi.” ");
INSERT INTO sbk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lelo mubhaposhe ikhone nawinza hulimwe Umpepo Ufinjile, namwe mwaibha bhaketi bhane, mu Yelusalemu, mu Uyahudi mu Samaria, na humalishilo uwensi.” ");
INSERT INTO sbk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nawayanga ezyo uYesu wabhuha wanyamulwa humwanya nabhamwenya, ibhengo lyakwinshila watega sebhalola na maso gabho. ");
INSERT INTO sbk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nulwabhahwenya humwanya kwa makini akienda, ghafula, abhantu bhabhili bhemelela pahati yabho bhakwite amenda amazelu. ");
INSERT INTO sbk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bhaga, “Mwe bhantu bha hu Galilaya, yenu mwimeleye epa?” Muhwenya abhala humwanya? Unu uYesu yamuhulola abhala humwanya ahwenza shesho sha muhulola abhala. ");
INSERT INTO sbk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nabhanvwa isho bhaela afume hwigamba lye mizeituni, abhale hu Yerusalemu humwendo wa Sabato. ");
INSERT INTO sbk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nabhafiha bhahabhala hwigulu amatawa gabho bhabhebha. Petro, Yohana, Yakobo, Andrea, Filipo, Thomaso, Batholomayo, Mathayo, Yakobo Omwana wa Alfayo, Simoni Zelote nu Yuda Umwana wa Yakobo. ");
INSERT INTO sbk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bonti ebho bhabhungene neshi umuntu umo, bhahendelela ne mputo. Bhali na abhashe, uMariamu unyina wa Yesu, nailumbu bhakwe. ");
INSERT INTO sbk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ensiku zila uPetro ahimilie pahati pa holo bhala bhahali abhantu 120, ahaga, ");
INSERT INTO sbk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mwe bhantu ehali huje enongwa zya Ngulubhi zitimile, zyayanjile Umpepo Ufinjile hwilomu lya Daudi zyazyayanjile uYuda, yabhalongole bhaala bhabhakete uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Umwene ali pamo nate aposhile ifungu lyakwe elye faida humbombo ene.” ");
INSERT INTO sbk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Neshi umuntu unu akalile ugunda huhela ila eye mbibhi zyakwe nepo ahagwiye abazuhu ivyanda na maula gahafuma na hwitishe. ");
INSERT INTO sbk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bhonti bhabhakhalaga hu Yerusalemu bhuhumvwizye na ieneo elyo hahalyeta itawa hunjango yabho “Akeldama” ugwo “gunda gwi danda.”) ");
INSERT INTO sbk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Mushitabu eshe Zaburi shijile, 'Ambe ugunda gwakwe gubhe lisami asahakhale umuntu nkumo;' tikunde, 'Umuntu uwinje ayeje enafasi yakwe eyelongozi.' ");
INSERT INTO sbk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Elyo lye muhimu aje ulume umoyajendaga pandwimo nate lula uYesu nalihulite nahinjilaga nafume, ");
INSERT INTO sbk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ahwande lila uYohana na hozyaga abhantu mpaka isiku lila uYesu nahabhushile abhale humwanya, lazima abhe keti we luzyuho pandwimo nate. ");
INSERT INTO sbk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","“Bhabhala hwitagalila alume bhabhili, uYusufu yahetelwe Barnaba, itawa elya mwabho ali yu Yusto, nu Mathiya. ");
INSERT INTO sbk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Abene bhalabha bhaga, “Awe, Ngolobhe umenye amoyo gabhantu bhonti tilaaba abhantu yusaluye ");
INSERT INTO sbk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ahweje enafasi ya Yuda yabhombile embibhi nasogole hulite.” ");
INSERT INTO sbk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bhakhoma ekula ekula yagwila uMathiya yabhehwelwe pandwemo na bhaala atumwe ilongo nu weka. ");
INSERT INTO sbk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nalyahafiha isiku elye Pentekoste, bhonti bhabhongene pandwemo. ");
INSERT INTO sbk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gwahabhafumila ungulumo afume humwanya neshi ugwihala ehali. Gwamema munyumba yonti mwabhakheye. ");
INSERT INTO sbk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Zyahabhafumila emele neshi, zigabhanyishe nabhe pamwanya ya shila muntu (pitwe). ");
INSERT INTO sbk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bhonti bhapata Umpepo Ufinjile bhahanda ayanje enjango ezyenje neshi Umpepo shasungwilwe umwene. ");
INSERT INTO sbk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bhahali ayahudi bhabhakhalaga mu Yelusalemu bhabhaputaga bhabhafuma shila nsi pansi. ");
INSERT INTO sbk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ungulumo gula nabhahunvwa abhantu bhahabhungana ahwenze atejelezye bhahabha ne wasiwasi shila muntu ahumnwizye bhayanga hunjango yakwe yuyo. ");
INSERT INTO sbk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","bhonti bhahaswiga bhahaga ebha bhonti se bha hu Galilaya bhabha yanga epa? ");
INSERT INTO sbk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yeenu ate tibhumvwa hunjango yetu yatapipwe nayo? ");
INSERT INTO sbk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Waparthia na Waamedi na Waelamu, nebho bhabhakhala hu Mesopotamia, no Uyahudi, na Kapadokia, no hu Ponto nu hu Asia, ");
INSERT INTO sbk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","hu Frigia, Pamfilia, no hu Misri, na hula hu Libya paka hu Kirene, na bhajenu bhonti bhabhafumile hu Rumi, ");
INSERT INTO sbk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayahudi na bhaongofu, Abhakrete bhonti tubhomvwa nazyo bhatambula embombo engosi Ungulubhi zyabhomba.” ");
INSERT INTO sbk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bhonti bhaswiga sebhahazyaganya mwitwe; hahanda abhuzanye bhene, “Eshi hwa huje yeenu?” ");
INSERT INTO sbk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lelo bhamo bhahatanila bhahaga, “Ebha bhakholilwe.” ");
INSERT INTO sbk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lelo uPetro ahimilila pandwemo na bhala ilongo na woka nabhabhule huje mwe mubhantu mwenti mwa mukhala hu Yudea namwe mwenti mwamukhala epa pa Yerusalemu, muntejelezye enongwa zyane muzizingatizye humoyo genyu. ");
INSERT INTO sbk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abhantu ebha sebhakholilwe neshi shamuibha, esala ezi saa tatu zyashampwiti. ");
INSERT INTO sbk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lelo mumanye huje ezi zyazila zyazyayangwilwe no ukuwe uYoeli; ");
INSERT INTO sbk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Zyaibha ensiku ezya humalishilo; ayanga Ungulubhi, naibhitila Umpepo Ufinjile abhantu bhonti. Abhana bhenyu asahala na lendu bhaikuwa, abhana bhenyu bhailola embonesyo, na gogolo bhailota enjozi. ");
INSERT INTO sbk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nantele abhomba mbombo bhane abhashe ehaibhitila Umpepo wane bhope bhaikuwa. ");
INSERT INTO sbk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Naibhalanga enswijizyo humwanya ne mbonesyo pansi pa dunia, idanda, umwoto, na tukusye elyosi. ");
INSERT INTO sbk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ni sanya lyaigaluha hisi no mwezi abhe lidanda, salisele ahwinze isiku Igosi lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ehaibha shila muntu yailikwizya itawa la Ngulubhi ayokoha.' ");
INSERT INTO sbk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mubhantu mubhi Israeli, umvwi enongwa ezi: U Yesu wa hu Nazareti, Ungulubhi yabhasaluliye na hulete hulimwe ne mbombo engosi Ungulubhi zyabhombile ashilile hwa mwene, namwe mwazilolile namwe muzimenye zyonti zyabhombile- ");
INSERT INTO sbk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lelo hunongwa ya mapango gakwe gapanjile afume hale nenjele zyakwe Ungulubhi, aje aihufumya humakhono ga bhantu aabhibhi ananzi, namwe mwahabuda, ");
INSERT INTO sbk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ungulubhi umwene ahazyusya ahayefwa enfwa muhati yakwe kwa sababu seyaweze hene aje enfwa etabhaale. ");
INSERT INTO sbk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","U Daudi ayanjile ajile, 'Nahalolile Ugosi wane hwitagalila lyane, umwene ali hukhono gwane ulilo sembahwogope. ");
INSERT INTO sbk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Umwoyo gwane gwahasungwa nu mele gwane gwasungwilwe. Gwope ubili gwane gwaikhala ni khone. ");
INSERT INTO sbk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Subhaguleshe umwoyo gwane gubhale hwazimu, nantele subhahuleshe ubhomba mbombo waho alole uvunzu. ");
INSERT INTO sbk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Awe umbunisizye idala elye womi; ubhandeshe ememe uluseshelo humaso gaho.' ");
INSERT INTO sbk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bhaholo, bhane enjanje ezya ise wetu u Daudi: umwene afwiye asyelelwe nenkungwa yakwe ehweli hulite mpaka asanyunu eshi. ");
INSERT INTO sbk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Umwene ali kuwe na amenye huje Ungulubhi alapile hundapo zyakwe huje ahaihubhiha umo umwana wakwe hwitengo lyakwe elye umwene. ");
INSERT INTO sbk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Eli alilolile shansele, nantele ayanjile huje aizyuha uYesu Kilisiti, 'sigalehwilwe hwazimu nu bili gwakwe sigagwavundile.' ");
INSERT INTO sbk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Unu uYesu - Ungulubhi azyusizye, nate tili bhaketi bhakwe. ");
INSERT INTO sbk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eshi uYesu ali hukhono ulilo ugwa Ngulubhi, nantele ayejeleye ulaganyo ulwa Umpepo Ufinjile afume hwa Yise wakwe, asuhinye ululagano olu hulite neshi shamulola na hwumvwe. ");
INSERT INTO sbk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Umwene uDaudi sigalushile abhale humwanya, lelo ajile, 'OGOSI (Ungulubhi) wane ayanjile hwa Gosi wane, ");
INSERT INTO sbk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“khala hukhono gwane ulilo, mpaka nehaibhabheha elyakhalile na khanyena manama gaho. ");
INSERT INTO sbk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aisraeli bhonti bhamanye huje uYesu unu yabhabudile Ungulubhi abhishile aje abhe Gosi ashile Agosi bhonti abhamunsi.” ");
INSERT INTO sbk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nabhumvwa isho enongwa zyabhalasa humwoyo gabho, bhabhabhuzya aPetro na bhamwabho tikhonzye wili eshi?” ");
INSERT INTO sbk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","U Petro waga, “Mulambe mwoziwe, shila muntu hwitawa lya Yesu Kristi muposhele ulusajilo ulwe mbibhi zyenyu, namwe mubhaposhe Umpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Olu olulagano lwenyu na bhana bhenyu na bhantu bhabhali uhutali na bhaala bhonti bhabhaikwiziwa nu Ngulubhi aje bhinze.” ");
INSERT INTO sbk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hunongwa ezya mwabho ajile hwi ponii na bhantu bhensiku ezi abhe mbibhi.” ");
INSERT INTO sbk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abhantu bhazyeteha enongwa zila bhoziwa abhantu elfu zitatu(3000) ikanisa lyahonjelela. ");
INSERT INTO sbk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bhahendelela adiile mumanyizyo zya atumwe bha Yesu bhali nu umoja, bhalyanga pandwimo na puute pandwimo. ");
INSERT INTO sbk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uwoga wahabhinjila abhantu ne mbombo ezyaswijizye zyahabhoneha Ungulubhi zyabhombile ashilile hwa tumwe bhakwe. ");
INSERT INTO sbk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bhonti bhabhahitishie izu lya Ngulubhi bhahakhalaga pandwimo ne vintu vyabhali navyo vyali vya bhonti, ");
INSERT INTO sbk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","evintu vyabhali navyo bhakazyaga bhagabhilaga shila muntu shahanzaga. ");
INSERT INTO sbk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ensiku zyonti bhali nu mwoyo gumo mushibhanza, bhamensulaga amabumunda mukhaya nalye eshalye shobho nuluseshelo nu mwoyo ugolosu; ");
INSERT INTO sbk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bhalumbaga Ungulubhi bhakonde lwe na bhanti bhonti. Shila lisiku abhantu bhahonjelelelaga mushibhanza bhaala bhabhahokahaga. ");
INSERT INTO sbk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","U Petro nu Yohana bhabhalaga hushibhanza apuute, yahali saa tisa. ");
INSERT INTO sbk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Umuntu umo alinanchisi manama afume shapipwe, bhahanyemulaga shila lisiku bhabhehaga mundyango ugweshibhanza, gwagwahitwaga gwinza, aje abhalabhaje abhantu bhabhahwinjila mushibhanza. ");
INSERT INTO sbk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nawabhalola aPetro nu Yohana bhazubhula aje bhinjile mushibhanza, wabhalaabha esadaka. ");
INSERT INTO sbk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","U Petro nu Yohana bhamwenya hu maso bhaga,”tenye ate.” ");
INSERT INTO sbk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ula unanjisu manama wabhenya, wasubhila apelwe ahantu hahonti afume hwabhene. ");
INSERT INTO sbk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Umwene uPetro waga ane sendi ne, “hela wala edhahabu, lelo hendi naho hehupela. Hwitawa elya Yesu Kilisiti wa Nazareti, emelela.” ");
INSERT INTO sbk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","U Petro wakhata ukhono ulilo wabhusya, amafugamo gakwe gapata ikhone. ");
INSERT INTO sbk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Umuntu ula wimilila najende na rusherushe winjila mushibhanza nu Petro nu Yohana ohu ajenda yuyo ohu ahulumba Ungulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abhantu bhonti nabhalola ajenda bhalumba Ungulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhamanya huje yayula yalinanjisu manama yalabhaga esadaka pandyango gweshibhanza; abhantu bhahaswiga embombo Ungulubhi zyabhombile hwa muntu ula. ");
INSERT INTO sbk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Abhantu nabhalola umuntu ula abhomiliye aPetro nu Yohana, bhashimbila muukumbi wawahetelwe wa Sulemani, bhahaswijile tee. ");
INSERT INTO sbk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","U Petro nawalola isho, wabhabhu ula abhantu bha Israeli, yeenu muswiga? Nantele mutenya ate aje ate tetimwemelesizye umuntu unu hwi khone lyetu?” ");
INSERT INTO sbk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ungulubhi wa Ibulahimu, Ungulubhi wa Isaka, nuwa Yakobo, Ungulubhi wa Yise bhetu, amwemeshe utumishi wakwe uYesu. Unu amwe mwahakhanile hwa Pilato, nantele uPilato, ahanzaga huleshele wene. ");
INSERT INTO sbk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwahakhene Umfinjile wa Ngulubhi umuntu Umwinza, mwahamwanza abhigulile unyambuda aleshelwe wene. ");
INSERT INTO sbk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Amwe mwabudile umwene uwi womi, lelo Ungulubhi azyusya afume hwabhafwe - Ate tili bhaketi bhakwe. ");
INSERT INTO sbk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eshi, ulweteho hwitawa lya Yesu, unu lwalupiye ikhone elyajendele umuntu unu yamuhulola na kujua, alifanywa kuwa na nguvu. Imani ambayo inapitia kwa Yesu imempa yeye afya hii kamilifu, mbele yenu ninyi nyote. ");
INSERT INTO sbk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Eshi, Bhaholo, bhane elola mwabhombile esho hunongwa yelema, atubhalongozi bhenyu shabhabhombile. ");
INSERT INTO sbk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lelo enongwa zya yanjile Ungulubhi ashilile akuwe bhakwe aje uYesu ailabha zibhombishe eshi. ");
INSERT INTO sbk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eshi mulabhe na galushe, nke mbibhi zyenyu zyepe nkazyenze ensiku ezya sungwe naseshelele nayenza umwene uYesu; ");
INSERT INTO sbk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aitumwa uYesu yasalulwe nu Ngulubhi hulimwe. ");
INSERT INTO sbk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Umwene yayuyo emwanya lazima zimwejelele mpaka evintu vyonti navyaigaluha, vyayanjile Ungulubhi ashilile akuwe bhakwe afinjile. ");
INSERT INTO sbk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lyoli uMusa ayanjile, 'Huje Ugosi Ungulubhi aja aihubhiha ukuwe neshi ane afume hwa holo bhenyu. Mwaihumwonvwelezya shila hantu haibhabhuula amwe. ");
INSERT INTO sbk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ihaibha aje shila muntu yasagaa ihutejelezya okuwe uyo aibhengwa ayepe pabhamwabho.' ");
INSERT INTO sbk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Lyoli, akuwe bhonti ahwandile hwa Samueli na bhaala bhabhapyanie pamwene bhatangazizye naziyanje ensiku ezi. ");
INSERT INTO sbk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Amwe mulibhana bhakuwe neilagano Ungulubhi lyalagine na gogolo bhetu abhemande neshi shayayanjile nu Ibrahimu, 'Aje abhana bhe mpapo yaho abhantu bhonti bha munsi bhaisaiwa.' ");
INSERT INTO sbk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ungulubhi pa wamwimiha uYesu waleta hulimwe nasoti huje abhasaye amwe nkamwagaluha nahuzileshe embibhi zyenyu.” ");
INSERT INTO sbk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","U Petro nu Yohana nabhayangaga na bhantu agosi abheshibhanza na linzi beshibhanza na masadukayo bhahabala. ");
INSERT INTO sbk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhavitilwe tee sababu uPetro nu Yohana bhabhamanyizyaga abhantu huje uYesu azyushile afume hwabhafwe. ");
INSERT INTO sbk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bhabhakhete nabhafunje mwijela bhahadila mumwo paka shandao lwakwe maana hwali lyabhela. ");
INSERT INTO sbk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Abhantu bhinji bhabhahunvwizye izu lya Ngulubhi bhalyeteshe; humbazyo bhaali abhantu elfu zisanu 5000. ");
INSERT INTO sbk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Isiku ilyashandano lwakwe azehe na simbi, bhahabhungana pandwimo hu Yelusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","U Anasi ugosi uwishibhanza, nu Kayafa, nu Yohana, nu Iskanda, bhonti bhabhali bhaholo bha anasi ugosi wishibhanza. ");
INSERT INTO sbk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bhabhabhunganila aPetro nu Yohana bhabhabhiha pahati, bhabhabhuzya, “Hwikhone wili nahwitawa lya nanu mubhomba ezi?” ");
INSERT INTO sbk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","U Petro, pamememile Umpepo Ufinjile wabhabhuula, “Waga amwe mubhazee na mubhantu, mwenti, ");
INSERT INTO sbk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","eshite sanyunu tibhuziwa hwijambo elinza lyalibhombishe hwa muntu ula ubhinu huje aponile? ");
INSERT INTO sbk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Eshi mulimanye elyo na hwabhantu bhonti abha Israeli, huje hwitawa elya Yesu uwa Nazareti amwe yamwabudile Ungulubhi umwene azyusize afume hwabhafwe, hwitawa lyakwe umuntu unu ayemeleye namwe muhulola. ");
INSERT INTO sbk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","U Yesu Kilisti liwe elyapanjenje amwe mwajenzi mwalikhanile. Namo uwokovu hwa muntu uwenje yayonti ula. ");
INSERT INTO sbk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Na umo uwokovu hwa muntu uwenje yayonti. Nalimo itawa elyamwabho lyatipewilwe tibhantu pansi epa lyatibhajiye ahwokolewe.” ");
INSERT INTO sbk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bhaala agosi nabhalola uPetro nu Yohana, sebhasaga nahamo nantele bhaali bhantu bhekawaida wene ata eelimu sebhali nayo, bhahaswiga, bhahamanya huje abhantu ebha bhali nu Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bhalolile umuntu ula yaali nanjisu manama ayemeleye nabho sebhali nezyayanje nazimo. ");
INSERT INTO sbk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lelo nabhahabhuula atumwe bha Yyesu huje sogoli pa bhungano, bhahanda abhuzanya bheene. ");
INSERT INTO sbk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tibhombe wile na bhantu ebha? Lyalibhombishe na bhene setibhajiye alikhane abhantu bhonti bhalilolile bhoonti bhabhakhala mu Yerusalemu; hatuwezi kulikataa hilo. ");
INSERT INTO sbk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eshi, amba tibhakhane bhasayanje nantele hwitawa eli elilya libhombishe lisahanyampane esahumvwe ensi yonti. ");
INSERT INTO sbk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bhabhakwizya uPetro nu Yohana bhaga musayanje nantele hwitawa eli musabhuyile amanyizye hwitawa eli. ");
INSERT INTO sbk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lelo uPetro nu Yohana bhahagamula bhahaga nkasheshinza abhumvwe amwe tileshe ahumwumvwe Ungulubhi yanji mwemwe lelote setibhajiye aleshe. ");
INSERT INTO sbk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ate setibhanje aleshe ayanje zyatizilolile na zyumvwe.” ");
INSERT INTO sbk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nabhabhakhana uPetro nu Yohana, bhabhaleha bhasogole. Maana sebhazilolie ezyamwabho ezyabhatake nantele abhantu bhonti bhazilolile zyazyabhombishe umuntu yalifwemanama ajenda. ");
INSERT INTO sbk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Umuntu ula yalifwemanama amaha gakwe agapapwe gali amaha amalongo gane. ");
INSERT INTO sbk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","U Petro nu Yohana nabhawela hwa bhamwabho bhabhabhulazyonti zyabhabhulilwe na gosi bhala. ");
INSERT INTO sbk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nabhahumvwisho bhahapuuta hwa Ngulubhi palishimo bhali Ngulubhi awe wuhabhumbile ensi nemwanya ne vyonti vyavili umwo, ");
INSERT INTO sbk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ngulubhi witu hu Mpepo waho Ufinjile, uhayanjile nu ise witu uDaudi, mtumishi wako, huje, “Yeenu apagani bhaleta efujo, nantele bhasibha embibhi? ");
INSERT INTO sbk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhamwene na bhabhatawala bhahwipanjile shibhibhi hwa Gosi na hwa Yesu.” ");
INSERT INTO sbk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Lyoli, uHerode nu Pontio Pilato, na pagani na bhaIsraeli, bhahitihine abhombe embibhi hwa gosu uwitu uYesu yupashile amafuta. ");
INSERT INTO sbk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bhabhungine bhonti pandwimo bhahaibhomba zyonti zyuhayanjile afume hale aje zyaibhombe ha ata shazisele abhombeshe. ");
INSERT INTO sbk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eshi awe Gosi, witu taanwe tabhomba mbombo bhaho utipeele ikhone tiyangaje enongwa zyaho nkahwogope nazimo ");
INSERT INTO sbk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ugolosye ukhono gwaho Ngulubhi ubhombe ezyaswijizye abhantu ashilile hwitawa lya Yesu Ugosi witu.” ");
INSERT INTO sbk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nabhamala apute pala pabhakheye payinga bhaliyanga izu lya Ngulubhi nahwogope Umpepo Ufinjile abhapiye ikhone. ");
INSERT INTO sbk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bhaala bhontu bhabhalyeteshe izu bhakhiye pandwimo evintu vyonti vyabhali navyo basanginye vyahabha vyabho bhonti numo yajile eha hanimwene; badala yake walikuwa na vitu vyote shirika. ");
INSERT INTO sbk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hwikhone igosi atumwe bha Yesu bhayangaga natangazye embombo engosi zyabhombile uYesu nahuje uYesu azyushile na eneema engosi ehali pamo nabho. ");
INSERT INTO sbk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Numo umuntu yahishilwaga maana bhabhali neviwaja na magunda bhakazyaga ihela zyonti bhaziletaga hwatumwe bha Yesu atumwe bhazigabhanyaga ");
INSERT INTO sbk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kuviweka chini ya miguu ya mitume. Na mgawanyo ulifanywa kwa kila muumini, kulingana na shila muntu apelwaga afuatane ne shida yakwe sheli. ");
INSERT INTO sbk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","U Yusufu, umulawi, afumile hu Kipro, apewilwe itawa bhahakwizya yu Barnabasi na mitume (emaana yakwe mwana we lusubhilo). ");
INSERT INTO sbk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Akazizya ugunda ehela zyonti azileta hwatumwe bha Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Umuntu, umo itawa ali yu Anania, nushi wakwe uSafira bhakazizye eshuma, ");
INSERT INTO sbk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ehela zimo bhafisa wope ushe azimenye zyabhabhombile, waleta zyazyasagiye hwatumwe. ");
INSERT INTO sbk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","U Petro wabhuzya, “U Anania, yeenu ushetani agumemizye umwoyo gwaho uyanga ilenga hwu Mpepo Ufinjile na fise ihelu zyasisagiye muziletile epa? ");
INSERT INTO sbk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Navyahali hulimwe sevyali vyenyu? nuhalisile akazya suhali namaamuzi navyo yeenu uhasibhile abhombe ezi? Nukhopiya muntu ukhopiyo Ungulubhi.” ");
INSERT INTO sbk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ahumvwaje esho, u Anania wagwa pansi wafwai abhantu bhonti bhayeta bhabhomvwizye ezi. ");
INSERT INTO sbk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na avijana(Asahala) bhanyatula bhabhala asyeele. ");
INSERT INTO sbk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Amasala nagafiha gatatu ushiwakwe wope afiha samanyile zyazimwajile ulume wakwe. ");
INSERT INTO sbk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","U Petro wabhuzya ugunda gwamukazizye ehela zyazyezi nyene u Safira waga ee zyazyezyo.” ");
INSERT INTO sbk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","U Petro waga yeenu mupatene hukhopele ilenga Umpepo Ufinjile? Angalia, miguu ya wale waliomzika mme wako iko mlangoni, na watakubeba na kukupeleka nje.” ");
INSERT INTO sbk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wope wagwa wope wafwa avijana bhabhala bhasyela pabhasyilile ulume wakwe. ");
INSERT INTO sbk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ikanisa lyonti lyogopa na bhantu bhonti bhabhahumvwizye. ");
INSERT INTO sbk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Embonesyo nyinji ezyashangazye zyabhombishe hwa bhantu ashilile humakhono gatumwe bhahali bhonti muukumbi wa Sulemani. ");
INSERT INTO sbk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Numo umuntu uwinji yasangine nabho abhantu bhabhashinshime nabhapele eheshima engosi tee. ");
INSERT INTO sbk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ikanisa lyahonjelela alume na bhashe bhabhaposhelaga uYesu, ");
INSERT INTO sbk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","abhantu bhanyemulaga abhinu nabhabheshe mwidala, aje u Petro nashila inzyogozi lyakwe libhashilile. ");
INSERT INTO sbk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nantele abhantu, afume munshenje ye Yerusalemu bhabhaletile abhinu na bhabhali na mashetani, bhonti bhaponile ");
INSERT INTO sbk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lelo ugosi wishibhanza na bhala bhabhamwavwaga embombo (abhemadhehebu ga masadukayo); bhaali nu kero ");
INSERT INTO sbk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","bhahabhakhata atumwe bhabhafunjila mwiijela lya bhonti. ");
INSERT INTO sbk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nu siku umalaika wenza wigula amandyango gijela wabhalongola hwonze, ");
INSERT INTO sbk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Waga bhalaji mwemelele mwikanisa mubhabhuule abhantu enongwa ezye Womi owu.” ");
INSERT INTO sbk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nabhumvwa isho bhabhala mwikanisa nahuhenga bhabhamanyizya abhantu okuhani(ugosi weshibhanza) na bhaalabhali nabho bhakwizanya ibalaza lyonti bhabhatuma hubhakwizye atumwe mwijela. ");
INSERT INTO sbk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nabhafiha hwijela bhahega atumwe nabhamo mwijela bha bhala bhabhapeela etharifa, ");
INSERT INTO sbk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Bhaga tejile abhantu nabhamo mwijela, na mandyango gonti gafungwilwe sheshinza nalinzi bhahweli mundyango nitigula tejile afungwe enabhamo muhati.” ");
INSERT INTO sbk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Usikari ugosi we hekalu na bhagosi bhahayetile sana pabhu mvwa huje afungwe nabhamo bhasiibha bhaga tibhabhombe wile ni jambo eli. ");
INSERT INTO sbk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Umuntu umo wenza wabhabhula huje abhantu bhaala bhamwabhapinyile bhali hwa mwabho bhemeleye bhamanyizya.” ");
INSERT INTO sbk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Usikari nabhantu abhanje bhabhala bhabhega shashinza bila fujo, bhahogope abhantu huje bhagabhakhoma na mawe. ");
INSERT INTO sbk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nabhabhaleta bhabhabheha pi baraza. Ugosi weshibhanza wa bhabhuuzya ");
INSERT INTO sbk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","tabhakhine amanyizye hwitawa lya muntu ula muyimemizye eYerusalemu emanyizyo zyenya musungwa alete idanda lya muntu ula hulite.” ");
INSERT INTO sbk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lelo uPetro natumwe bhaga, “Lazima timwumvwe Ungulubhi ashile abhumvwe abhantu. ");
INSERT INTO sbk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ungulubhi waise bhetu azyusizye uYesu yamwabudile na hulembezye mwikwi. ");
INSERT INTO sbk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ungulubhi amwimishe hukhono gwakwe ulilo, abheshele abhe Gosi abhe mwokozi, hwa Israeli, nkabhalambe embibhi abhasajila. ");
INSERT INTO sbk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ate tilibhaketi bhega gonti, nu Mpepo Ufinjile, Ungulubhi yabhapelile bhaala bhabhahumwitiha.” ");
INSERT INTO sbk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ajumbe bhi baraza nabhumvwa isho elyoyo lyabhakhata bhaga bhabhabude atuwe. ");
INSERT INTO sbk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ufarisayo umo itawa lyakwe yu Gamalileli, ali mwalimu we sheria, yahemehwaga sana na bhantu waga abhantu ebo bhafume panze nasoti. ");
INSERT INTO sbk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Halafu wabhabhuula waga amwe, “Mubhalume mubha Israeli, mwenye sana zyamulwabhombe na bhantu ebha. ");
INSERT INTO sbk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ahali umuntu itawa yu Theuda ahwibheshele huje muntu gosi, sana abhantu mia nne bhafutile. Umuntu uyo bhahabuda bhonti bhabhafuataga bhanyampine nategane. ");
INSERT INTO sbk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ahali uwamwabho ali yo Yuda wa hugalilaya, lwabhahabhazyaga abhantu(esensa) wope atejile na bhantu bhakwe bhonti bhanyampene. ");
INSERT INTO sbk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eshi embabhuula abhantu ebha bhaleshi embombo ene nkayabhantu ebhateje yene. ");
INSERT INTO sbk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lelo nkashele ya Ngulubhi, semubhajiye aiwezye; musahabhoneshe huje mulwa nu Ngulubhi.” Bhamweteshela zyayanjile. ");
INSERT INTO sbk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bhabhakwizya bhinjila munyumba bhabhakhoma, nabhabhuule huje musahayanje nante hwitawa eli elya Yesu, bhabhaleha bhasogola. ");
INSERT INTO sbk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bhasogola shabhashiye aje tikhomwa hunongwa yitawa elya Yesu nazalauliwe. ");
INSERT INTO sbk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ensiku nzyonti mwikanisa bhalumbililaga na manyizye abhantu aje uYesu yu Kilisti nu mwokozi. ");
INSERT INTO sbk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ikanisa palyahonjelelaga akule abhantu bhahabha bhinji, gahanda abhe amalulumwo hwa shirika Ayahudi abheshi Yunani bhabhalulumwaga aba Ebrania, huje afwele bhabho sebhabhagabhilaga shinza eshalye bhabhewaga. ");
INSERT INTO sbk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Atumwe bhabhakwizya ashirika bhonti, bhahaga seshinza ate alileshe izu lya Ngulubhi na bhatenganye amwe humambogeshalye. ");
INSERT INTO sbk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eshi salulii abhantu saba abhinza bhabhali nu Mpepo Ufinjile tibhabhishe humbombo ene. ");
INSERT INTO sbk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nate tibhakhale na deele mwizu lya Ngulubhi na puute.” ");
INSERT INTO sbk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ezyo enongwa zyabha nyinza bhasalula u Stefano, umuntu uwelweteshelo nu Mpepo Ufinjile, nu Filipo, Prokoro, Nikanori, Timoni, Parmena, na Nikolao, wa hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhabhaleta hwa tumwe, abhantu ebha, bhabhapuutila na bhabhabheleshela amakhono gabho. ");
INSERT INTO sbk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Izu lya Ngulubhi lyavwambana na ashirika bhonjelela mu Yelusalemu bhope agosi bheshibhanza bhabhinji bhalyeteshe izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nu Stefano, muntu yali ne neema nikhone abhombaga amambo minji aga Ngulubhi agaswijizye hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lelo bhahinza abhantu abhe Sinagogi lyalihwefwa Mahuru, nelya Bhakirene nelya Waeskanderia, na bhahukilikia na hu Asia. Abhantu ebha bhabisaniaga nu Stefano. ");
INSERT INTO sbk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lelo, sigabhawezizye ashindane nu Stefano umwene ali ne hekima nu Mpepo Ufinjile yayangaga mwa Stefano. ");
INSERT INTO sbk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Abhantu ebho bhayanga na bhantu bhabhasuliha bhaga, “Mugaje uStefano aligaga uMusa nu Ngulubhi tumviwizye tete.” ");
INSERT INTO sbk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bhabhabuula azee, nasimbi, bhabhala bhakhata uStefano, bhaleta hwi baraza. ");
INSERT INTO sbk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","bhabhaleta aketi abhilenga, bhaga, “umuntu unu sigaleha ayanje embibhi epa apa tuntumu ahuliga wu Ngulubhi nesheria ya Musa. ");
INSERT INTO sbk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tumvwizye nayanga huje bhashi uYesu abhapananganye esheria zyetu ezyeshikhaya zyatapelilwe nu Musa.” ");
INSERT INTO sbk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Shila muntu yaali pibaraza amaso gakwe gamwenya hulineshi umalaika. ");
INSERT INTO sbk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ugosi we shibhanza waga,”ezi enongwa zye lyoli”? ");
INSERT INTO sbk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","U Stefano wagamula waga, “Bhaholo bhane na bhaise bhane ntejelezi zyeyanga: Ungulubhi yabhunishie uise wetu u Ibulahimu nahali hu Mesopotamia, sasele asamile ensi ene eye hu Harani,' ");
INSERT INTO sbk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ungulubhi ahabhuula ahagu epa awe munsi ene usame ubhale hunsi yembahulanje'. ");
INSERT INTO sbk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Wasogola wasama hunsi ya Hukardayo wakhala hu Harani, afume epo, uise wakwe nawafwiwa, Ungulubhi waleta munsi ene yabhakhala eshi. ");
INSERT INTO sbk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sigapiya nahamo ahagale, siga alinapo ata pibhishe eshinama. Lelo Ungulubhi alaginye u Ibulahimu sasele apate umwana huje aipelwa ensi ene aje aiigala nabhana bhakwe. ");
INSERT INTO sbk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ungulubhi ayanjile nawo eshi abhana bhaho hunsi eyeshijinyi na akhaya bhaibhabhiha bhaboyi bhabho(bhafubhilwa) nantele bhaibhabhomba embibhi humahaemia zine 400. ");
INSERT INTO sbk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ungulubhi ahaga naibhalonga abhantu bhabhaibhabhombela embibhi abhe ensi eyo, abhantu bhane naibhagalusya bhayenza ampuute ane munsi ene.' ");
INSERT INTO sbk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wapela uIbulahimu ilagano lye tohara, u Ibulahimu wabha ise wa Isaka watahiri isiku elya nane; u Isaka wabha ise wa Yakobo, uYakobo wabha yise wa yise bhetu ilongo na bhabhili. ");
INSERT INTO sbk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Aise bhetu bhalolela ukero(umwone) uYusufu bhakazya hu Misri, Ungulubhi ali pandwimo nawo, ");
INSERT INTO sbk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ungulubhi aponizye na malabha gonti, Ungulubhi wapela ineema, ne hekima hwa Farao, uFarao wabhiha aje abhe gosi munsi yonti na munyumba yakwe. ");
INSERT INTO sbk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Enzala ihagwiye hunsi yonti eya hu Misri ba hu Kanani, abhantu bhapiite amalabha sana abhaise bhetu sebhali neshalye. ");
INSERT INTO sbk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","U Yakobo nawumvwa huje hu Misri, hulineshalye, abhatumile aise bhetu ulwahwande. ");
INSERT INTO sbk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nabhabhalile ulwabhili uYusufu ahwibhonisizya hwa holo bhake aholo bha Yusufu bhamanyiha hwa Farao. ");
INSERT INTO sbk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","O Yusufu wabhatuma aholo bhakwe bhabhale humweje uise wabho na bhanji bhakhalaga nabho bhonti bhaali amalongo saba na bhasanu 75. ");
INSERT INTO sbk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","U Yakobo wiha hunsi ya hu Misri, umwene wafwa naise bhetu bonti. ");
INSERT INTO sbk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bhabhega mpaka hushekemu bhasyelwa munkungwa yakalile uIburahimu ne hela hwa bhana bha Hamori hula hu Shekemu. ");
INSERT INTO sbk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ululagano lula Ungulubhi lwalaginne nu Ibulahimu na lwapalamila, abhantu nabhonjelela uwinji hula hu Misri, ");
INSERT INTO sbk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","aheenza umfumu uwamwabho hu Misri, abhasuliha abhantu aje bhabhavitwe abha Israeli, nabude abhaana adodo aje bhasahonjelele apapane. ");
INSERT INTO sbk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Umfumu uyo abhakhopela abhantu nabhasulishe, bhabhabhombile embibhi aise bhetu nataje abhana bhabho aje bhasahabhe bhoomi. ");
INSERT INTO sbk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ulwo uMusa aapepwe; ali mwinza hwa Ngulubhi, walelwa amezi gatatu muntumba ya ise. ");
INSERT INTO sbk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Unyina watabhila ahatundu wazyema ne lami wabhala wataga umwale wa Farao wabhala watola walela neshi unyina. ");
INSERT INTO sbk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","U Musa wafundiziwa enfunizyo zyonti ezyeshi Misri; ali nikhone munongwa na bhombe. ");
INSERT INTO sbk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nawafisya amaha amalongo gane (40), wasiibha humwoyo aje ashuule hwa holo bhakwe abhana bha Israeli. ");
INSERT INTO sbk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Walola uholo wakwe abhone lwa nu Mmisri watanjila wakhoma ula Umsri wabuda: ");
INSERT INTO sbk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","umwene asibhile huje aholo bhakwe bhabhaje ayinzele atokole Ungulubhi atumile fwanii aholo bhakwe sebhasibhile isho. ");
INSERT INTO sbk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Isiku ilya mwabho wabhaga abha Israeli bhalwa bheene; walenga abhamulanye waga amwe mulibhaholo yeenu mulwa mubhene? ");
INSERT INTO sbk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ulayalwanga nuwamwabho wabunshila hula wabhuula waga wenu yabhishile awe aje ubhe tanzanyi wetu? ");
INSERT INTO sbk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uhwanzaje ungoje neshi uhagojile Ummisri ula igamo?” ");
INSERT INTO sbk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","U Musa washimbila ahwumvwe isho; wabhala hu Midiani, uhwo wabha yise wa bhana bhabhili. ");
INSERT INTO sbk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Amaha amalongo gane nagashila, umalaika ahajendela hwijangwa mwatatango hahahaga umwoto. ");
INSERT INTO sbk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","U Musa ahaswiga ajawalola atatango hahwaha umwoto, lelo sehalungulila, nawalinga ahazubhilile, wumvwa izu liyanga, ");
INSERT INTO sbk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Ane ne Ngulubhi wa yise bhaho, uIbulahimu, nu Isaka, nu Yakobo'. U Musa wogopa nayinje se hwenye. ");
INSERT INTO sbk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ungulubhi wabhuula waga satula evilato vyaho, puyimiliye epa nsintuntumu. ");
INSERT INTO sbk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Engalolile amalabha gabhantu bhane na mayemba gabhali nago hu Misri; Ane enishile abhavwe; eshi enza etume, ubhale hu Misri.' ");
INSERT INTO sbk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Unu uMusa yabhakhine yabhajile wenu yabhishile awe ubhe gamulanyi wetu?'- Ungulubhi yatumile abhookole afumiye mumwoto atatango nahahahaga. ");
INSERT INTO sbk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","U Musa abhalongozizye afume hu Misri ashilile hwijangwa Ungulubhi abhombile amambo minji agaswijizye hu Misri ashilile hwa Musa bhalobhoshe ebahari abhalongozizye humaha amalongo nane'. ");
INSERT INTO sbk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yu Musa yunu yabhabhuulile abhantu huje Ungulubhi aibhaletela ukuwe yali neshane afume hulimwe'. ");
INSERT INTO sbk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Unu muntu yaali hubhungano, hula hwijangwa nu malaika yayanjile nawo hwigamba lya Sinai. Unu yayula yaali na ise bhetu, unu yayula ahe eleye izu elyomi natipele ate. ");
INSERT INTO sbk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Unu yayula aise bhetu bhahakhanile, bhabunshiye uhutali na humoyo gabho bhagalushe hu Misri. ");
INSERT INTO sbk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eshipindi esho bhahabhuula u Haruni.'bhahaga tilenganyizye ungulubhi(mangulubhi) atilongozye uMusa manyi zyazimwajile uhwo. ");
INSERT INTO sbk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bhagomba(bhalinganya) endama hunsiku izyo bhafumyia ne sadaka hundama bhaisungwa embombo ye makhono gabho. ");
INSERT INTO sbk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ungulubhi ahavitwa ahabhaleha bhapuute entondwe sazyasimbilwe eshakuwe aje mwamfumizizye ane esadaka ezyevyuma hwijangwa humaha amalongo gane amwe bha Israeli? ");
INSERT INTO sbk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Muyetesha ihema elyatanganile elya Moleki ne ntondwa ya Ungulubhi refani, ne shifwani shamulingenye na puute hwa bhene: eshi embabhabhenje embabhatwale ohutali ashile hu Babeli.' ");
INSERT INTO sbk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aise bhetu bhaali ni hema elyatanganile, Ungulubhi shayanjile nu Musa huje alenganye neshi lila shalilolile. ");
INSERT INTO sbk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eli lihema aise bhetu, ojoshwa pabhaletaga ensi ene Ungulubhi pabhabhenjele akhaya aise bhetu sabhasile ahwinze ensi ene ezi zya esho mpaka ensiku ezya Daudi, ");
INSERT INTO sbk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","umwene ahetehwe nu Ngulubhi,' na alabhile ahwanze ukkhalo hwa Ngulubhi wa Yakobo. ");
INSERT INTO sbk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lelo u Sulemani azenjeye Ungulubhi enyumba. ");
INSERT INTO sbk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Eshi umwene Ungulubhi sigaakha munyumba zyazizengwilwe namakhono neshi ukuwezya yanjile, ");
INSERT INTO sbk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Emwanya litengo lyane elye ufumu na ensi pabhishe amanama gane. Mubhanzenjele nyumba wili?, ayanga Ungulubhi: na apatuye ane paposhi?' ");
INSERT INTO sbk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ukhono gwane segwagwogu gwabhombile ezi zyonti?' ");
INSERT INTO sbk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Amwe mubhensingo ehome mwasigamtahiliwe amoyo na makutu, mwamuhupinga Umpepo Ufinjile,' mubhomba neshi shabhabhombaga aise benyu. ");
INSERT INTO sbk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kuwe wili hwa kuwe bhonti aise bhenyu bhasiga bhabhatesile? Bhabhabudile akuwe bhonti bhabhakuwaga ahwenze hwa ula Umuntu Umwinza,'neshi mulumenye na hubude, ");
INSERT INTO sbk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","amwe mwamwaposhiye esheria ela yamwalajiziwe nantele semwahanzaga aikhate.” ");
INSERT INTO sbk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ajumbe nabhonvwa enongwa ezyo zyabhavwalazya humwoyo bhamwenya eshibhibhi e Stefano. ");
INSERT INTO sbk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lelo umwene, uStefano abhe amemile Umpepo Ufinjile wenya amaso gakwe humwanya waulola utuntumu wa Ngulubhi,' nu Yesu akhiye hukhono ulilo gwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U Stefano waga, “Enzilola emwanya zigushe nu Yesu ayimiliye hukhono ulilo gwa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lelo abhantu abhi baraza bhabwaga ibwago, igosi bhadinda amakutu gabho bhashimbilila bhakhata, ");
INSERT INTO sbk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bhapanya hwunzi ye khaya bhakhoma na mawe” naketi bhasatula amenda gabho bhabhiha pamanama gasahala umo itawa yu Sauli. ");
INSERT INTO sbk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nabhahwendelela ahupuule na mawe umwene wenya amaso gakwe humwanya waga Yesu, ejelela eroho yane,'. ");
INSERT INTO sbk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wafugamila wakwizya hwizu igosi waga gosi wane Yesu usabhabhazizye embibhi ezi zyabhabhomba. “Nawayanga isho wapuma wafwa. ");
INSERT INTO sbk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","U Sauli ahali nabhohitihanaga ahubude u Stefano. Wope u Sauli na ahandile abhatese bhonti akristi habhahali mu Yerusalemu na bhonti bhabhanyampine bhaali humajimbo ga Yudea na hu Samaria, bhasagiye bha mitume bhene. ");
INSERT INTO sbk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Abhantu bha Ngulubhi bhasyela uStefano bhazondiye enzondo engosi tee. ");
INSERT INTO sbk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lelo uSauli alitesile sana ikanisa. Ashilaga shila nyumba abhakhate na bhakwesanjile hwunze nabhaponyezya mulumande(mwijela) abhashe na bhalume, na kuwatupia gerezani. ");
INSERT INTO sbk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bhaala bhabhanyampine abheene bhalumbililaga izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","U Filipo ahishiye hu Samaria alumbililaga izu elya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ubhungano nabhalola zyazibhombeha nu Filipo; bhazibheha humoyo gabho nahwitishile. ");
INSERT INTO sbk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Abhantu bhabhali bhabhinu bhaponile amipepo mabhibhi gabhafumile abhantu uhu bhakholaawa na bhaala afwemanama bhaponile. ");
INSERT INTO sbk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ensi ela bhasungwile sana. ");
INSERT INTO sbk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ahali umuntu umo itawa lyakwe ali yu Simoni umuntu uyo alini tunga ashangazyaga tee ensi ya bha Samaria, umuntu uyo agaga umwene gosi saana bonti bhatimihaje. ");
INSERT INTO sbk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abhasamaria bhonti bhahatejelezya ahwande umwa paka agosi abhantu bhaga umuntu unu ezi zyabhomba zifuma hwa Ngulubhi.” ");
INSERT INTO sbk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bhatejelezya maana abhaswijizizye tee nsiku nyinji ni tuunga lyakwe. ");
INSERT INTO sbk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nabhahatejelezya uFilipo nalumbililaga uumwene uwa humwanya ni tawa lya Ngulubhi lyalyaponyaga abhantu ashilile hwitawa lya Yesu bhahoziwe alume na bhashe. ");
INSERT INTO sbk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wope uSimoni aheteshe ahoziwe nalileshe itunga lyakwe, ahendelela alongozanye nu Filipo; aswijile sana nahazilola Ungulubhi ashilile hwa Filipo zyazibhombeha ngosi tee. ");
INSERT INTO sbk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Atume nabhahumvwa aje abhahu Samaria bhalyeteshe izi lya Ngulubhi, bhahabhatuma uPetro nu Yohana. ");
INSERT INTO sbk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nabhafiha hula bhabhapuutila aje bhaposheele Umpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ensiku zyonti izyo baalisile ahuposhele Umpepo Ufinjile bhonti lelo bhahoziwe hwitawa lya Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","U Petro nu Yohana bhabhabhishila amakhono bhabhapuutila, bhope baposhela Umpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","U Simoni nawalola abhantu bhahuposhela Umpepo Ufinjile nabhabheshilwa amakhono na atume wanza aje abhapele ihela, ");
INSERT INTO sbk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Waga, “Mpeli nane ouwezo, owo aje shila muntu yehubhishila amakhono aposhelaje Umpepo Ufinjile.” ");
INSERT INTO sbk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","U Petro wabhuula waga ihela zyaho nawe wayo mtejele uhwo ubhishile aje ekarama ya Ngulubhi tipelwa ni hela. ");
INSERT INTO sbk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Suli ni hama hwu mbombo ene umwoyo gwaho segugoloshe hwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eshi laamba hwa Ngulubhi ulwinje abhahusajile ensebho zyaho embibhi ezyo. ");
INSERT INTO sbk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Elola umwoyo gwaho segulishinza hunanchishe gupinyilwe ne mbibhi.” ");
INSERT INTO sbk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","U Simoni waga ilabha mumpuutile hwa Ngulubhi ezi zyamuyanjile zisahanaje. ");
INSERT INTO sbk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","U Petro nu Yohana pabhawelaga afume uhwo bhalumbiliye muvijiji vivinja evya Samaria pamande bhawela hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Umalaika wa Ngulubhi wayanga nu Filipo waga sogola ushilile idala elya ntende(hu kusini) lwalihwishila hu Yerusalemu abhalile hu Gaza.” (Idala eli lili mwijangwa). ");
INSERT INTO sbk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","U Filipo wabhala. Walola umuntu uwa hwi Ethiopia, afumle apuute hu Yerusalemu umuntu unu ali hasule ali gosi hu nyumba ya malkia wa hwi Ethiopia. ");
INSERT INTO sbk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Akhiiye mwi gari lyakwa abhazyaga ibhangili lya Isaya igari palijenda abhale amwabho. ");
INSERT INTO sbk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Umpepo wabhuula uFilipo zubhilila hwi gari elyo upalamane nalyo. ");
INSERT INTO sbk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","“U Filipo walishimbilila igari lila wamwunvwa ula umuntu abhazya mwibhangili elya Isaya wabhuzya uzyiliwe zyubhazya umwo?” ");
INSERT INTO sbk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Umuntu ula uMwiethiopia waga embahwelewe wili umuntu nkasiga andongozye? Wakhope lezya uFilipo aje ainjile mwigari lyakwe bhakhale bhonti. ");
INSERT INTO sbk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ibhangili lyabhazyaga pasimbilwe eshi alongoziwe neshi engole nabhabhalanayo asinze; apumile myee neshi engole, sigahiguye ilomu lyakwe: ");
INSERT INTO sbk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Azugumile hwakwe alongwe hwakwe hwa hepile: Weenu yaiyanga eshizazi shakwe(empapo yakwe)? amaisha gakwe gepile munsi.” ");
INSERT INTO sbk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ula uhasule mwithiopia wabhuuzya uFilipo unu umuntu yebhazya umu enongwa ezi zyakwe yuyo awe zya muntu winji”? ");
INSERT INTO sbk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","U Filipo wamwandila mwumwo munongwa zyabhazyaga mwibhangili lya Isaya hulumbilile izu lya Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nabhandelela abhale bhafiha papali na menze ula uhasule wabhuzya uFilipo enya amenze ega epa henu hahansinti zya ahwoziwe? ");
INSERT INTO sbk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","u Filipo waga nkuyitishe ebhajiye ula Umwithiopia waga eneteshe huje uYesu mwana wa Ngulubhe, ula Umwithiopia wimiliha igari lyakwe. ");
INSERT INTO sbk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Bhiha bhonti mwigari bhatumbushila mumenze, uFilipo nu mwithiopia uFilipo wamwozya(wabhatizya). ");
INSERT INTO sbk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nabhazubha afume muminzi bhonti Umpepo wanyatula uFilipo wasagala yu Mwithiopia mwene Umwithiopia wasogola nigari lyakwe abhalile shashiye humwoyo. ");
INSERT INTO sbk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lelo uFilipo abhuinishe hu azoto alumbililaga muvijiji na mujini mpaka afishile hu Kaisaria. ");
INSERT INTO sbk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lelo uSauli, ahindiliye atiisye abhantu bha Ngulubhi bhabhamwitishe uYesu, abhalile hwa Gosi uwishibhanza ");
INSERT INTO sbk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","alabhiile ekarata yesimbilwe alabhe abhakhate bhaala bhoonti abhidala eli bhabhali mumasinagogi abhalume nabhashe, abhapinye na bhale hub Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na hendelelaga ashuule apalanila afishe hu Dameski ulukhozyo lwahakhozya afume humwanya lwazyungula ponti', ");
INSERT INTO sbk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","uSauli wagwa pandi wumvwa izu lihukwizya liyiga Sauli, Sauli, yeenu ohumnvisya?” ");
INSERT INTO sbk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","U Sauli wagamu waga awe wenanu Gosi? Ugosi waga, “Ane ne Yesu wumnvisya nantese; ");
INSERT INTO sbk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lelo bhuuha ubhale hujini hwa wabhalaga ubhalabhuulwe ezyabhombe ");
INSERT INTO sbk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abhantu bhabhashuulile nu Sauli bhahapuma kati bhahumnvwa izu lelo umuntu yayanga sebhalolile. ");
INSERT INTO sbk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","U Sauli wabhuuha pansi ahalinga ahwenye ahega amaso segalola, bhakhata ukhono bhaleta paka hu Dameski. ");
INSERT INTO sbk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ensiku zitatu saa lya sigaamwela, siga ahwenya. ");
INSERT INTO sbk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ahali umanyile(umwanafunzi) hu Dameski itawa yu Anania, u Yesu wayanga nawo Anania. U Anania waga ane epa, Gosi. ");
INSERT INTO sbk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Ugosi waga bhuuha ubhale ushilile hwidala lyalihwitwa Nyofu, uyinjile munyumba ya Yuda ubhuzye aje umuntu yafumile hu Tarso umuntu uyo ali salaabha(alisapuuta); ");
INSERT INTO sbk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","alolilo humbonesyo umuntu itawa lyakwe yu Anania ahubhishila lyakwe yu Anania ahubhishila amakhono pitwe aje alole amaso. ");
INSERT INTO sbk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","U Anania wagamula uYesu waga inumnvwizye hwa bhantu bhinji embibhi zya bhabhombiye abhantu bhaho uhwo hu Yerusalemu; ");
INSERT INTO sbk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Epa pope ali ne kalata yefumile hwa Gosi weshibha, abhakhate bhonti bhabhalikwizya itawa lyaho. ");
INSERT INTO sbk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lelo Ugosi uYesu waga bhalaga awe, umuntu uyo esaluye alyeje itawa lyane hwapagana hwamfumu bensi na hwa aIsraeli. ");
INSERT INTO sbk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Embahulolesye amambo minji gaiteswa hunongwa yi tawa lyane”. ");
INSERT INTO sbk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","U Anania wabhala winjila munyumba mula wamwaga uSauli wabheshela amakhono waga wee Sauli, Ungulubhi ula yutangene nawo na winzaga ohu antumile upone ulole amaso na umposhele Umpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nawabheshela amakho, vyalagala evintu neshi amakhonda afume humaso amaso giguhawanda alole, wimilila, bhwoziwa; walya eshalye wapata ikhone. ");
INSERT INTO sbk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wakhala natumwe ohwo hu Dameska ensiku nyinji. ");
INSERT INTO sbk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ulwo wabha ahulumbillia uYesu huje Mwana wa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abhantu bhonti bhaswiga bhaga seeyayunu yalavyaga abhantu bhahalikwizyaga itawa eli hula hu Yerusalemu? Ata hwohu ahenzeye mbombo yeyo aje abhakhate nabhatwale hwa gosi hu Yerusalemu.” ");
INSERT INTO sbk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","U Sauli apeete anguvu ezyalumbilile Ayahudi bhabhakhala hu Dameski bhachanganyikiwe nahulole huje uYesu aje lyoli yu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ensiku nazyashila zinyinji, Ayahudi bhetehana huje bhabude usauli. ");
INSERT INTO sbk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lelo uSauli wamanya bhamwubhilaga mundyango pasanya nu siku aje bhabude. ");
INSERT INTO sbk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bhaala bhabhamanyizyaga usauli bhahafumizya mwidirisha bhahapinyila eshitundu nulugalabho bhahamwisya ansoso. ");
INSERT INTO sbk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","U Sauli nawafiha hu Yerusalemu, ahalinga asangane nabha Kilisiti amwabho, lelo abhene bhase guhaga, sigabhahitishiye aje uSauli apendushe amweteshe uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","U Barnaba wamwega na hutwale hwa mitume nabhabhuule shapendushe nesha tangine nu Yesu mwidala na bhala hu Dameski, neshalumbilye hu Dameski nkahwogope. ");
INSERT INTO sbk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Atangine nabho nabhahinjilaga nafume mu Yerusalemu. Wayanga nkahwogope itawa lya Yesu, ");
INSERT INTO sbk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","abhuzanyaga na Ayahudi abheshi Yunani bhalingaga shila lisiku ahubude. ");
INSERT INTO sbk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aholo bhakwe nabhamanya ezyo bhatolosya bhatwala hu Kaisaria, aje abhale hu Tarso. ");
INSERT INTO sbk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eshi ikanisa elya Uyahudi na hu Samaria na hu Galilaya lya hatengaana lyahagwizya umwoyo nu Mpepo Ufinjile ahabhatenganya ikanisa lyahonjelela uwinji. ");
INSERT INTO sbk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","U Petro pazyungulaga ohu wuihwo alumbilile ibhangili ahafiha hu Lida abhajendea Kilisiti bhabhali uhwo. ");
INSERT INTO sbk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ohwo walola umuntu umo itawa lyakwe yu Ainea, ubili gwakwe alizilisu humaha nane; maana alikuwa amepooza. ");
INSERT INTO sbk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","U Petro wabhuula waga, “Ainea, uYesu Kilisti ahuponya bhuhapugonile, U Ainea wapona wa bhuha. ");
INSERT INTO sbk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abhantu bhonti bhabhakalaga hu Lida nahu Sharoni nabhahalola umuntu uyo bhahapenduha bhahamweteha uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ahali umwanafunzi umo hu Yafa itawa yu Tabitha, emaana yakwe hwa huje “Dorkasi” Ushi unu abhabhombelaga enyinza abhantu apiina. ");
INSERT INTO sbk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lumo ahabhina empuungo ahafwa bhahamwozya bhahagonia hwigulu. ");
INSERT INTO sbk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","E Lida sigayali hutali ne Yafa, bhatuma abhanafunzi hwa Petro abhantu bhabhili bhabhuula uPetro bhaga usahakhabhie saali hu mwitu”. ");
INSERT INTO sbk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","U Petro wabhuuha walongozanya nabho. Nabhafiha bhatwala hwigulu, abhashe abhafwile bhalanga amakoti na menda gabhasonelaga u Dorkasi nahali sha mwomi. ");
INSERT INTO sbk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","U Petro wabhafumia panzi bhonti nabhafuma uPetro wafugamila wapuuta, wapuutila uDorkasi wadamula amaso walola uPetro, wakhala pansi. ");
INSERT INTO sbk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","U Petro wakhata ukhono wabhusya wabhakwizya bhaala abantu bhabhafumizye hwunzi na bhinjila wabapela umuntu wabho ali mwomi ");
INSERT INTO sbk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ezi zyazibhombishe zyamanyiha hu Yafa hwonti abhantu bhabhinji bhapenduha bhagalushila uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","U Petro ahakhiye ensiku zye nyinji hu Yafa nu muntu umo itawa yu Simoni, yalinganyaga insungwa. ");
INSERT INTO sbk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ahali umuntu umo hunsi ya hu Kaisaria, itawa ali yu Kornelio, ali gosi weshipuga eshe Kiitalia. ");
INSERT INTO sbk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ali muntu wa Ngulubhi na afumiaga esadaka zinyinji abhapelaga abhantu, aputaga hwa Ngulubhi ensiku zyonti. ");
INSERT INTO sbk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yahali saa tisa ezya pasanya ahalola embonesyo ahalola umalaika ahwenza hwa mwene ula umalaika wabhuula u “Kornelio! ");
INSERT INTO sbk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U Kornelio wamwenya tee ula umalaika, wayeta tee waga huliyenu gosi? Umalaika waga esadaka zyaho ne mpuuto zyaho zifishile hwa Ngulubhi na zilizyahwizushe.” ");
INSERT INTO sbk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bhatume abhantu hu Yafa bhakwizye uPetro. ");
INSERT INTO sbk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Akhala hwa Simoni yalinganya ensunga enyumba yakwe eli munsenje ye bahari.” ");
INSERT INTO sbk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ula umalaika nawasogola, u Kornelio wabhakwizya aboyi bhakwe bhabhili nu sikari umo yaputaga nawo nahubhombele embombo. ");
INSERT INTO sbk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U Kornelio wabhabhuula zyonti zyazilolile wabhatuma hu Yafa. ");
INSERT INTO sbk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nabhaapulamila afishe hujini, u Petro wazubha hwigulu apuute. ");
INSERT INTO sbk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nantele enzala yalumile tee nabhali ateleshe walola embonesyo, ");
INSERT INTO sbk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","walola emwanya eyigushe walola ahantu hali neshumwenda hahwiha pansi ne nshenje zine. ");
INSERT INTO sbk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Muhati yakwe vyahali evintu vyonti evyomi vyaviliwa manama gane, ne vyavihwavula nevyaviluha humwanya. ");
INSERT INTO sbk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wumnvwa izu liyanga lyaga Petro sinza ulye”. ");
INSERT INTO sbk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","U Petro waga sigaembwahile alya evintu evichafu. ");
INSERT INTO sbk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","U Petro wumvwa nantele ulwabhili izu liyiga vyazijozizye Ungulubhi uganje ayanje huje vibhibhi. ");
INSERT INTO sbk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eli lyabhombisha hatatu hala ahombo hazubha humwanya nantele. ");
INSERT INTO sbk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","U Petro nasibha embonesyo izyo, abhantu bhabhatumwilwe nu Kornelio bhabhabhafishile bhemeleye mundyango bhabhuzilizya enyumba yali uPetro. ");
INSERT INTO sbk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhabhuuzilizya aje uSimoni yahwetwa Petro nkakhala omu. ");
INSERT INTO sbk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","U Petro pali seebhe embonesyo zila Umpepo Ufinjile wabhuula huja abhantu bhatatu bhahuhwanza hwonze. ");
INSERT INTO sbk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bhuha iha panji ulongozanye nabho embatumile weene leha ahwogope.” ");
INSERT INTO sbk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","U Petro wabhaga bhimiliye wabhabhuzya mwenzeye yeenu? Nene nemunanza?” ");
INSERT INTO sbk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Atitumile umuntu umo gosi weshipuga muntu puuti, abhuulelwe nu malaika aje ubhale akhaya yakwe ayumvwe zyuli nazyo.” ");
INSERT INTO sbk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","U Petro wabhakaribisya munyumba, shampwiti yakwe bhasogola bhonti, u Petro wabega abhantu abhahu Yafa bhashe bhalongozanya nawo. ");
INSERT INTO sbk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Shandabho yakwe bhafiha hu Kaisaria. Bhamwaga uKornelio abhaguulila abhunginye ajirani bhakwe na bhaala bhonti bha munyumba yakwe. ");
INSERT INTO sbk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","U Petro nawafiha u Kornelio wabhala huposhe waundamila mmanama gakwe abhonesye huje atinishe. ");
INSERT INTO sbk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","U Petro wabhusya waga ane nanee endi muntu neshiawe.” ");
INSERT INTO sbk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","U Petro naliyanje nawe ayinjila anyumba wega abhantu bhabhungine bhabhinji. ");
INSERT INTO sbk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wabhabhuula huje amwe mwemwe mulolile huje ate namwe setisangana. Lelo Ungulubhi andamiye aje usahabhakwizye abhantu bhembozizye ane aje bhachafu. ");
INSERT INTO sbk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ndiyo maana ewenzele eshi muyanje zyamunkwizizizye.” ");
INSERT INTO sbk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","U Kornelio wagamula waga ensiku zine zyashilile esala neshi ezi nalipuute munyumba yane, umuntu winza akwite amenda amazelu, ");
INSERT INTO sbk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wambula waga “Kornelio empuuto zyaho ne sadaka zyaho zifishile humwanya hwa Ngulubhi nazili zyahwizushe hwa mwene. ");
INSERT INTO sbk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eshi tuma umuntu hu Yafa ukwizya uSimoni yahwitwa Petro akhala hwa muntu yahwitwa Simoni yalinganya ensunga enyumba yakwe eli munshenje ye bahari. ");
INSERT INTO sbk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nabhahwinze umwene abhayanje namwe. ");
INSERT INTO sbk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","U Petro wayanga waga lyoli neteha huje Ungulubhi siga ali no upendeleo. ");
INSERT INTO sbk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Umuntu yayonto yahumwitiha umwene wope Ungulubhi ahumweteha umuntu uyo. ");
INSERT INTO sbk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Enongwa zyayangaga na bha Israeli zyali zya bhantu abhe mataifa gonti ashilile hwa Yesu Kilisti- ");
INSERT INTO sbk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","namwe bhayo mumenye lyalya fumiye hu Yudea hwonti na lyahandiye hu Galilaya u Yohana nawatangazya ahwoziwe. ");
INSERT INTO sbk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lila lyalyabhombehaga nu Yesu Ungulubhi apishe amafuta aga Umpepo Ufinjile ni khone abhalaga aponile abhantu bhabhayembaga nu shetani Ungulubhi ali pandwemo nawo. ");
INSERT INTO sbk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ate tilibhaketi bha mambo gonti gagabhombishe hunsi zya Uyahudi na hu Yerusalemu-unu uYesu yabhabudile na hulembezye mwikwi. ");
INSERT INTO sbk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Unu umuntu Ungulubhi azyusizye isiku elyatatu na manyihane, ");
INSERT INTO sbk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","siga hwa bhantu bhonti umwene abhonishe hwa abhantu bhakwe bhabhasaluye, ate tetalyanga nawo na mwele nawo nawazyuha afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atilajizizye alumbilile hwa bhantu bhonti aje unu yabhehwelwe nu Ngulubhi aja abhe gamulanyi wa bhafwe na bhomi. ");
INSERT INTO sbk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na akuwe bhakuwilwe, huje shila muntu yaihumwitiha aisajilwa embibhi zyakwe ashilile hwitawa lyakwe.” ");
INSERT INTO sbk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","U Petro nahendelelaga ayanje Umpepo Ufinjile wabhinjila abhonti bhabhali munyumba mula bhabhatejelezyaga. ");
INSERT INTO sbk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bhaala bhahenzele nu Petro bhabhatahiriwe- bhaswijile tee huje bhope amataifa(apagani) Ungulubhi abhapeela Umpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bhabhahumvwizye bhayanga injango ezyenje na hulumbilile Ungulubhi. U Petro waga, ");
INSERT INTO sbk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ahweli umuntu yayonti yabhajiye akhane aje abhantu bhasahoziwe bhabhaposhiye Umpepo Ufinjile neshi ate?” ");
INSERT INTO sbk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","U Petro wabhabhuula huje bhoziwe hwitawa lya Yesu Kilisti. Pamande bhalaabha uPetro huje akhale na bhene hunsiku kazaa. ");
INSERT INTO sbk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Atume na bhamwabho bhabha uhwo hu Yudea bhahumvwizye huje apagani(amataifa) bhope bhalye jeleye izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","U Petro pawawela hu Yerusalemu abhamwabho bhahanda husale, ");
INSERT INTO sbk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bhaga usangine na pagani nantele uliye nabho!” ");
INSERT INTO sbk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lelo uPetro wayanga zyazyamwajile, ");
INSERT INTO sbk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nahali hula hu Yafa, nahali apuute nahalola embonesyo naahalola ahantu hamwiha afume humwanya hali neshi umwenda hahwiha huline. ");
INSERT INTO sbk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nahenyizye haala ahantu, nahalola evintu muhati vyavisugwa evyamwigona evyamumenze, ne hwavula pansi. ");
INSERT INTO sbk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Numvwa izu liyinga evyo vyalye sinza ulye!” ");
INSERT INTO sbk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ane naga sembwahile alye evintu evibhibhi nantele vichafu” ");
INSERT INTO sbk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lila izu evintu vyavyozizye Ungulubhi uganje avyeete aje vibhibhi awe vichafu, ");
INSERT INTO sbk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Zyabhombeha esho hatatu hala ahantu hazubha nantele humwanya. ");
INSERT INTO sbk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Abhantu bhatatu bhahimiliye mundyango bhabhafumile hu Kaisaria ahwinze huline. ");
INSERT INTO sbk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Umpepo wambuula waga longozanya nabho leha ahwogope ebha alume tanda tabhalile tenti takhiye mwa muntu umo. ");
INSERT INTO sbk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Atibhuulile huje umalaika ajile tume umuntu abhale hukwizye uPetro hu Yafa. ");
INSERT INTO sbk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Abhayanje enongwa zya Ngulubhi nawe ubhahwokoshe nabhantu bhonti bha munyumba yaho.” ");
INSERT INTO sbk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Panahandile ayanje nabho, Umpepo Ufinjile wabhinjila nesha atinjiye ate. ");
INSERT INTO sbk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nahizushe zyayanjile uYesu huje uYohana ahozyaga abhantu na minzi lelo amwe mubhahwoziwe nu Mpepo Ufinjile.” ");
INSERT INTO sbk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eshi Ungulubhi nkashele abhapiye Umpepo Ufinjile abhantu abhanje neshi atipiye ate, ane nenanu embakhane? ");
INSERT INTO sbk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nabhumvwa sebhayanga nkazimo, bhaluumba Ungulubhi bhaga Ungulubhi unu abhapiye abhantu umwoyo ugwalambe bhabhali bhapagani” ");
INSERT INTO sbk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Amalabha gagahandile pafwiye u Stefano abhaKilisti bhanyampana afume hu Yerusalemu bhafishile mpaka hu Foinike, Kipro na hu Antiokia. Ohwo hwonti bayangaga bhayahudi bhene abhanje sigabhabhabhuulaga. ");
INSERT INTO sbk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lelo abhanji bhafumile hu Kipro na hu Kirene, bhabhalumbiliye ayunani izu lya Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ukhono gwa Ngulubhi gwali na bhene, abhantu bhabhinji bhapendushe bhagalushila uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Enongwa zyabho zyafiha mumakutu ga Kilisti bhabhali hu Yerusalemu: bhatuma uBarnaba abhale hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","U Barnaba nawafiha asungwilwe tee abhagwizizye umwoyo aje bhadulaje mwa Yesu mumoyo gabho. ");
INSERT INTO sbk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ali muntu mwinza tee nantele ali muntu wimpyana nu Mpepo Ufinjile ali muhati yakwe nulwitishilo, abhantu bhabhinji bhonjelela hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pamande u Barnaba ahasogola ahabhala hu Tarso humwenye u Sauli. ");
INSERT INTO sbk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nawa mwaga bhabhala bhonti hu Antiokia, bhakhala umwaha gumo bhahamanyizya abhantu bhabhinji na abhanafunzi bhahitwa bha Kilisti ulwahwande hula hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ensiku ezyo bhahishile akuwe afume hu Yerusalemu paka hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Umo ali yu Agabo uyo abhuulilwe(asenshiye) huje enzala engosi ebhalagwe ensi yonti. Enzala iyo ihagwiye na tabhalile u Klaudio. ");
INSERT INTO sbk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Abhanafunzi bhahasanguzanya shila muntu hapiite bhabhatwalila abhamwabho bhabhali hu Uyahudi. ");
INSERT INTO sbk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ihela izyo; bhabhapelile a Barnaba nu Paulo huje bhatwale. ");
INSERT INTO sbk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Umfumu u Herode ahandile abhatese aKristo. ");
INSERT INTO sbk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ahabudile uYakobo uholo wa Yohana ni panga. ");
INSERT INTO sbk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nawalola huje Ayahudi bhasungwa wakhata nu Petro. Esho shali shipindi she mabumunda gasiga bhaponyizye ehamila. ");
INSERT INTO sbk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nawakhata uPetro wafunga mulumanti amapunga gane aje bhadime aje nayashila Epasaka atwale hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Akristo bhamwaba nabhamvwa huje uPetro akhetwe na fungwe bhabhungana bhetehana bhonti apuute na hupuutile tee hwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Isiku sasile uHerode humeje uPetro mwijela nu siku ahenzele umalaika humwefwe u Petro mwijela, alinzi bhazyungulile uPetro na mundyango bhaali abhasikali. ");
INSERT INTO sbk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Umalaika winza wakhozya mwijela umalaika wadamuzya u Petro waga bhuuha nanali amanyololo gabhapinyiye gagwagepa mumakhono na mumanama. ");
INSERT INTO sbk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Umalaika waga kwata evilato vyaho wa menda gaho saali ndondozyanje ane.” ");
INSERT INTO sbk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","U Petro walondozya uMalaika bhafuma hwunzi. U Petro sigaaloline aje ezyo zili lyoli agagajibha alota njozi. ");
INSERT INTO sbk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bhashila undyango ugwa hwande bhashila nugwabhili bhafuma hundyango ugosi ugwabhalile humujini, ugwo gwali gwimajela gwahigushe gwene bhasogola bhafiha apatali, uMalaika waleha uPetro waga eshi bhalaga. ");
INSERT INTO sbk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","U Petro nawamanya huje zililyolo siganjozi waga Ungulubhi atumile Umalaika wakwe huje anefwe mwijela nensubhizyo zya ayahudi.” ");
INSERT INTO sbk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","U Petro wafiha munyumba ya Mariamu unyina wa Yohana yahwitwa Marko; mwabhabhangine Akristo nabhapuutaga. ");
INSERT INTO sbk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nawakhoma ehodi mundyango wabhala humwigulile ulendu umo itawa yu Roda. ");
INSERT INTO sbk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nawamanya huje yu Petro, sigawigula undyango; washimbila wabhala abhabhuule munyumba huje yu Petro yakhoma ehodi. ");
INSERT INTO sbk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Abhamunyumba bhabisya bhagasiga yuyo umwene wakhasya huje yuyo bhaga yu malaika wakwe.” ");
INSERT INTO sbk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","U Petro wabhasagonga undyango pamandi bhamwigulila na bhalola bhaswiga tee. U Petro wabhapumizyia wabhalatila zyonti umalaika zyabhombile shafumizye mwijela, ");
INSERT INTO sbk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Wababhuula huje mubhuule u Yakobo na holo abhamwabho, wasogola wabhala uhwamwabho. ");
INSERT INTO sbk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nawasha askali bhala bhazugumiye tee hunongwa ya Petro huje afumile wele. ");
INSERT INTO sbk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","U Herode nawabhala humweje siga amwajile wabhabhuuzya alinzi, u Herode wamula abhabude alinzi bhaala, wasogola wabha hu Kaisaria akhale. ");
INSERT INTO sbk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","U Herode ali ne lyoyo na bhantu abhahu Tiro na hu Sidoni. Bhabhala bhonti palishimo. Bhakundana nu saidizi wa mfumu, bhalabha ulwetehano, ensi yabho ehapataga eshalya afume hunsi ya mfumu. ");
INSERT INTO sbk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Isiku limo umfumu u Herode ali nu mbungano nawakhala pitengo lyakwe elyeufumu, wayanga na bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Abhantu bhabwaga bhaga eli lizu lya Ngulubhi sigalizu lya muntu!” ");
INSERT INTO sbk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Umalaika wakhoma amachango galya muvyanda wafwa ");
INSERT INTO sbk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lelo izu lya Ngulubhi lyanyampana hwa bhanti bhabhinji. ");
INSERT INTO sbk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","A Barnaba nu Paulo nabhala bhabhala hu Yerusalemu bhamwega nu Yohana yahwitwa Marko elyo lyapipwe nalyo. ");
INSERT INTO sbk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Eshi hwi kanisa lya hu Antiokia, bhahali akuwe na bhaalimu. Bhahali bha Barnaba, Simeoni itawa (elya mwao ali Nigeri). Lukio uwahu Kirene, Manaeni( yali mwanakwao nu Herode ulongozi we mkoa), nu Sauli. ");
INSERT INTO sbk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lwabhaputaga na funje, Umpepo Ufinjile wayanga, “Nabhaala akristi waga nefwezi a Paulo nu Barnaba bhabhale humbombo yembasaluliye(Yembakwzizizye).” ");
INSERT INTO sbk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ikanisa palyabapuutila bhabhiha amakono pitwe lyabho, bhabhaleha bhabhalaje. ");
INSERT INTO sbk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","U Barnaba nu Paulo bhamwitishe Umpepo Ufinjile bhahasogola bhahafiha huseleukia afume uhwo, bhahashula bhashila muminzi mpaka hu Kipro. ");
INSERT INTO sbk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na bhahali hu Salami, bhahalumbilila izu elya Ngulubhi mumasinagogi ga Yahudi bhahali nu Yohana (U Marko) yabhavwaga. ");
INSERT INTO sbk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nabhabhalile hushisiwa sha Pafo bhahamwajile umuntu umo itawa yu Bar Yesu umuntu uyo ali ni tuunga nantele ali kuwe wilenga. ");
INSERT INTO sbk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Umuntu unu ahavwanwaga nu ugosi we Wilaya u Sergion Paulus, ali umuntu wi njele umwene abhakwizizye a Paulo nu Barnaba ahanzaga atejelezye izu elya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lelo u Elima “ula uwitunga sigahanzaga huje ula uliwali (ugosi we wilaya) atipinjile tete ahanzaga hugaluzanye hahitishile zyabhayanga a Paulo nu Barnaba. ");
INSERT INTO sbk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lelo uSauli yahitwaga Paulo, walangulila amaso amemile Umpepo Ufinjile, akamkazia macho ");
INSERT INTO sbk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","waga awe wumwana wa shetani wupenga shila hantu ahinza aha Ngulubhi, ugaluzanya idala lya Ngulubhi lyaligulushe ubhaliwezye? ");
INSERT INTO sbk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eshi enya, ukhono gwa Ngulubhi guli nawe ubhabhefwe maso, subhalilole isanya, nawayanga isho pepo walola enkisi amaso gafa, walabha abhantu abhahukhate ukhono aje bhalongozye. ");
INSERT INTO sbk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ula uli wali alolaje esho walyeteha izu lya Ngulubhi aswijile tee zila zyazyabhombishe hwuula uwitunga. ");
INSERT INTO sbk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","U Paulo wa bhamwabho bhasogola bhafiha hu Pafo bhafiha na hu Pafo bhafiha a hu Perge hu Pamfilia. U Yohana(U Marko) wabhaleha umwene wawela hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","U Paulo nu wamwabho bhashula afume hu Perge bhafiha hu Antiokia yahu Pisidia. Uhwo bhahinjila mwisinagogi isiku elya Sabato(eleye lutuyo). ");
INSERT INTO sbk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nabhabhazya esheria na kuwe, alongozi bhe sinagogi bhabhatuma abhantu huje kabhanga mlinezyayanje muyanje na bhantu.” ");
INSERT INTO sbk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","U Paulo wabhuha wayanga waga mubhalume namwe mwamuhumwitiha Ungulubhi tejelezi(umwumi). ");
INSERT INTO sbk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ungulubhi wa bhantu ebha abha Israeli abhasaluye abhaise bhetu na huje bhanyame bhabhe bhinji pabhakhiye hunsi ya Misri, nu khono gwakwe abhalongozizye. ");
INSERT INTO sbk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Humaha amalongo gane (40) hwijangwa. ");
INSERT INTO sbk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nabhagananganya amataifa saba aga hu Kaanani, abhapiiye abhaise betu ensi yabho aje ebhensi yabho aise bhetu. ");
INSERT INTO sbk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ezi zyonti zyabhombishe humaha zaidi ye maha emia zine na mashomi gasanu nazya shila ezi zyonti, Ungulubhi abhapeelile abhameli mpaka u Samweli Ukuwe. ");
INSERT INTO sbk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pamande abhaiisraeli bhahalabha umfumu, Ungulubhi abapela uSauli umwana wa kishi uwishikholo sha Benjamini, alongozizye amaha amalongo gane(40). ");
INSERT INTO sbk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ungulubhi pawamwefwa uSauli, wabhiha uDaudi aje abhe mfumu wabho. Ungulubhi ahile uDaudi agukhondezizye zyonti zyenziganile ane.' ");
INSERT INTO sbk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Afume mushikholo sha Daudi Ungulubhi atiletiye ugombozi uYesu Kilisti, neshi shatilaginye aje aibhomba. ");
INSERT INTO sbk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Shasile ahwenze uYesu ahinzile uYohana nasoti umwene atangazizye uwozyo uwalaambe hwa bhantu bhonti abhaIsraeli. ");
INSERT INTO sbk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wope uYohana nawamala embombo yakwe abhabhuuzya abhantu huje amwe muiga ane ne nanu? Ane sendi yayula, umvwi ahwinza umwene yampyanila ane uyo anesiga embajiye ata husatule evilato vyakwe.' ");
INSERT INTO sbk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abheshikholo sha Ibulahimu mwa mupuuta hwa Ngulubhi, unuu Yesu atinziye tete. ");
INSERT INTO sbk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Hwa bhaala bhabhakhala hu Yerusalemu, na gosi bhabho sigabhaminye uYesu ata nongwa ezya akuwe zyabhabhazya shila lutuyo(Sabato); bhitimilizizye enongwa zya akuwe nabhahabudile uYesu. ");
INSERT INTO sbk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nantele sigabhazyajile embibhi ezyahugoje uYesu pabhalabhile u Pilato huje agoje. ");
INSERT INTO sbk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nabhamalizya zyonti zyasimbililwe bhahamwisya mwikwi bhahagonia munkungwa. ");
INSERT INTO sbk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lelo Ungulubhi ahazyusya afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nawazyuha ahajenda na bhantu bhakwe ensiku zinyinji nabhaala abhantu eshi bhaketi bha bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Eshi tibhaletela enongwa enyinza ezye ndaganyo zya bhapewilwe agogolo betu. ");
INSERT INTO sbk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ungulubhi abhishile endaganyo ezi hulite, tibhana bhabho Ungulubhi azyusizye apiye uwomi wane nantele. Ezi zyasimbilwe mu Zaburi eya bhili: 'Awe uli Mwana wane, ane endi Yise waho' ");
INSERT INTO sbk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ungulubhi azyusizye afume hwa bhafwe aje ubili gwakwe gusahananjishe nu lusayo lwa lyoli ulwa Daudi' ");
INSERT INTO sbk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Neshi shayanjile muzaburi apamwabho, subhahuleshe, ufinjile waho alole uvunzu.' ");
INSERT INTO sbk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","U Daudi nawabhombela Ungulubhi embombo yakwe ne mpapo yakwe, agonile(afwiye), bhahagonizye pandwimo na bhaise bhakwe aulolile uvunzu, ");
INSERT INTO sbk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Umwene yazyusiwe nu Ngulubhi siga aulolile uvunzu. ");
INSERT INTO sbk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Eshi mumanye mwenti huje ashilile hwa muntu unu ulusajilo lwe mbibhi lulombelelwe hulimwe. ");
INSERT INTO sbk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ashilile hwunu tisajilwe naganje gonti gaala gehapotilwe esheria ya Musa atipele. ");
INSERT INTO sbk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Eshi mukhalaje maso aje zyazyayangwilwe nakuwe zisahafumile hulimwe: ");
INSERT INTO sbk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Eshi, amwe mwamudhalau, muswije nantele muyaje; ebhomba embombo hunsiku zyenyu, sigamuzyeteha ata umuntu abhabhuule.” ");
INSERT INTO sbk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","U Paulo nu Barnaba pabhasogola abhantu bhabhabhuula huje enongwa ezi mugayanjile mwisiku lye tuyo(Sabato) yehwenza. ");
INSERT INTO sbk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ubhungano ugwamwi sinagogi nagwamaliha Ayahudi na bhaongofu bhabhalondola aPaulo nu Barnaba, bhayanga nabho mukhalaje mwibhangili lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mulutuyo ulwamwabho nalwenza abhantu bhabhungine bhabhinsi ahwenze atejelezye izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayahudi nabhalola uwinji wa bhantu bhabhatejelezya aPaulo bhabha nu kero, bhayanga enongwa embibhi na hubhalije. ");
INSERT INTO sbk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A Paulo nu Barnaba bhayanga nkahwogope bhaga izu lya Ngulubhi tulubhiliye hulimwe nasoti amwe mulibunshiye uhutali eshi ate tibhala hwa bha Mataifa. ");
INSERT INTO sbk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Neshi Ugosi shatibhuulile huje embabhishile amwe huje mubhe lukhozya munsi yonti mubhatwalile uwausha abhantu bhonti abha munsi.” ");
INSERT INTO sbk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abhamataifa nabhumvwa isho bhasha(basungwa) tee nalilumbilile izu lya Ngulubhi. Nabhalabhabhasalulwe hu womi uwawila bhahitishe. ");
INSERT INTO sbk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Izu lya Ngulubhi lanyampana hwonti. ");
INSERT INTO sbk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lelo ayahudi bhabhavitilwe aPaulo nu Barnaba bhabhabhinga aje bheepe mumpaho yensi yabho. ");
INSERT INTO sbk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","U Paulo nu Barnaba bhabhakunyitila amankowi ga mumanama gabho bhasogola bhabhala hu Ikonia. ");
INSERT INTO sbk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Amanyili (abhanafunzi) bhahali nuluseshelo nu Mpepo Ufinjile. ");
INSERT INTO sbk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hula hwi Ikonio u Paulo nu Barnaba bhahinsiye mwisinagogi lya Bhayahudi bhahayanga Ayahudi na Ayunani shabhalyeteshe izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lelo Ayahudi bhasiga bhalyeteha izu bhabhasulishe abhamataifa huje musahazyeteshele ezyabhayanga aPaulo nu Barnaba nabhavitwe. ");
INSERT INTO sbk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bhahakhiye uhwo ensiku zyenyinji, bhayangaga izu lya Ngulubhi, hwikone lya Gosi uYesu abhapiye huje bhabhombaje amambo minji agaswijizye hwitawa lya Yesu aPaulo nu Barnaba. ");
INSERT INTO sbk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Esehemu engosi ye muji gula abhantu bhahagabhanyiha bhamo bhahabha na Yahudi, bhamo bhahabha na bhatume. ");
INSERT INTO sbk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayahudi na bhamataifa bhabhasulishe alongozi bhabho huje bhabhabhombe embibhi na bhakhome na mawe aPaulo nu Barnaba, ");
INSERT INTO sbk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","a Paulo wuwamwabho bhazimanya, bhashimbilila hu Likaonia, Listra na hu Derbe nu humwaohunshenje yakwe, ");
INSERT INTO sbk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","uhwo bhalumbilila izu la Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uhwo hu Listra ahali umuntu yaali nanjisu manama sigaje ndaga afume papwe hwakwe. ");
INSERT INTO sbk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Umuntu unu ahamwumvwizye uPaulo palumbilila. U Paulo wa mwenya, walola ali wu lweteho humwoyo. ");
INSERT INTO sbk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Wayanga hwizu igosi, emelela na manama gaho ula umuntu watomoha wimilila wanda ajende. ");
INSERT INTO sbk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ipuga lya bhantu, na lyalola zyabhombile uPaulo, bhabwaga hwizu igosi hunjango yeshi Kilikaonio, “amangulubhi gatishiye humabili gabhantu.” ");
INSERT INTO sbk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhamwita uBarnaba “Zeu,” nu Paulo “Herme” umwene yaali yuyanzi ugosi. ");
INSERT INTO sbk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ukuhani wa Zeu, eshibhanza shakwe shali hwonze aletile ehampako, na usanga ulwimaua waleta mpaka mundyango gwekhaya, umwene na bhantu gwekhaya, umwene na bhantu bhakwe bhonti bhaga bhafumye esadaka. ");
INSERT INTO sbk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Atumwe uPaulo nu Barnaba nabhunvwa bhasatula amenda gabho nanali bhabha hwitagalila ohu, bhalila ");
INSERT INTO sbk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","bhaga, “Mwebhantuu yeenu, mubhomba ezii, natee tilibhantu neshi amwe, tisebha neshi amwe. Tisebha neshi amwe, tibhaleteye enongwa enyinza huje mugalushile Ungulubhi, mupendushe muzileshe ezi zyamubhomba mugalushile unu mwanya ne vintu vyonti vyavihweli. ");
INSERT INTO sbk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Emande Ungulubhi abhaleshile amataifa bhajendaje mmadala gabho bhibho. ");
INSERT INTO sbk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lelo sigaabhaleshile, ahwibhonesizye abhatonyezyaga emvula abhapelaga evyalye mumagunda na hobhoshe” ");
INSERT INTO sbk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nabhayanga enongwa ezi, aPaulo nu Barnaba bhabhakhanizya abhantu zyabhahanzaga abhombe, abhafumizye esadaka. ");
INSERT INTO sbk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lelo Ayahudi bhabhafumile hu Antiokia na hu Ikono bhahinzile na bhasulishe abhantu. Bhahakhoma uPaulo wamae bhadendemula bhafumya hwonze ye khaya yabho bhasibha huje afwiye. ");
INSERT INTO sbk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amanyili(abhanafunzi) bhahimiliya papipi, wabhuha winjila humujini. Isiku elyabhili bhahabha hu Derbe nu Barnaba. ");
INSERT INTO sbk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nabhamanyizya uhwo abhantu bhinji bhapendushe, abhene bhahawela hu Listra, na bhahafiha hu Ikonia mu na hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bhahendelela abhazinzye abhanafunzi amoyo huje tihwinjila hwa Ngulubhi na mayemba gaminji.” ");
INSERT INTO sbk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bhabhasalula azee bheshibhanza bhabhapuutila nafunje bhabhaleha mumakhono ga Yesu yabhamwitishe. ");
INSERT INTO sbk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bhashila hu Pisidia, bhafiha hu Pamfilia. ");
INSERT INTO sbk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nabhayanga enongwa hu Perga, bhiha hu Atalia. ");
INSERT INTO sbk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Afume uhwo binjila mumeli bhabala hu Antiokia hwabhwifumizye huje bhabhombe embombo eshi embombo ela emalishe. ");
INSERT INTO sbk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabhafiha hu Antiokia, bhabhabhunganya akristo pandwimo bhabhabhuula zyonti Ungulubhi zyabhombile hwa bhene, neshabhiguliye undyango gwe lweteho hwa bhantu bhe Mataifa. ");
INSERT INTO sbk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakhiye ensiku zyenyinsi na bhanafunzi. ");
INSERT INTO sbk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abhantu bhamo hahishile afume hu Uyahudi bhabhamanyizyaga aje nkasiga mutahiriwa sigamubhajie ahwokoshe esheria ya Musa heyanjile.” ");
INSERT INTO sbk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","U Paulo nu Barnaba pabhali adalisanye na bhantu ebho bhalabhabhabhuulwaga ezyo bhabhatuma aPaulo, nu Barnaba, nabhanje bhamo aje bhabhale hu Yerusalemu bhabhuuzye hwa mitume nazee bheshibhanza. ");
INSERT INTO sbk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bhaala bhabhatumwilwe bhashiliye hu Foinike na Samaria alumbilile huje amataifa bhagalushiye Ungulubhi. Bhaletile uluseshelo lugosi hwa bhantu, ");
INSERT INTO sbk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nabhafiha hu Yerusalemu atume nazee bhabhakalibizya bhope bhabhabuula zyontu zya bhombile Ungulubhi humakhono gabho. ");
INSERT INTO sbk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bhabhabhula na huje akristo bhabhafumile ohu bhabhamanyizya aKristo, abhamataifa huje nkasigamutahiriwa, nazikhate esheria zya Musa semubhajiye ahwokoshe.” ");
INSERT INTO sbk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Atume wazee bhakhala nalise bhelele ijambo eli. ");
INSERT INTO sbk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ijambo eli bhakhiiye tee walyo pamande uPetro wimilila wayanga, “Awe bhayaa muhwizuha huje utagalila sheshi Ungulubhi antumile aje hilomu lyane Amataifa bhuumvwe izu lya Ngulubhi nalyeteshe. ");
INSERT INTO sbk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ungulubhi, yahwenya amoyo ayanga nabho nabhapele Umpepo Ufinjile, neshi atipiye ate; ");
INSERT INTO sbk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","siga alelegenye ate na bheene abhalintinye amoyo aje gabe minza, nu lweteho. ");
INSERT INTO sbk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yeenu tihulenga Ungulubhi nabhatwinshe ijoko lyabhapotilwe aise bhetu natibhayotipotilwe nayo? ");
INSERT INTO sbk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lelo tihwitiha aje tihwokoha hu Neema ya Yesu neshi shashili.” ");
INSERT INTO sbk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ubhungano gwonti gwapumile kati, aPaulo nu Barnaba pabhayangaga ezyabhombile Ungulubhi ingosi ne zyaswijezye hwa mataifa. ");
INSERT INTO sbk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nabhaleha ayanje, uYakobo wope wimilila wayanga, “Wagabhamwitu ntejelezi. ");
INSERT INTO sbk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","U Simoni ayanjile Ungulubhi shatumile nezyabhombile Ungulubhi hwa bhantu ebha hwitawa lya Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Enongwa zya akue zihwitihana nezi shazisimbilwe. ");
INSERT INTO sbk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Ihaiwela naizenje nantele enyumba ya Daudi, yehagwiye pansi ihaipalinganya papananjishe, ");
INSERT INTO sbk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","aje abhantu bhabhasagiye bhamwanze Ungulubhi na bhaMataifa bhabhasalulwe nu Ngulubhi.' ");
INSERT INTO sbk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eshi shayanga Ugosi yabhombize ezi zyazimanyishe ahwande hali ");
INSERT INTO sbk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ane enjiga tisabhatamansye abhantu bha Mataifa bhabhagalushile Ungulubhi; ");
INSERT INTO sbk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","lelo tibhasimbile huje bhasegushe(bhapehane) nevifwani nenfwa nyewe, ni danda nu umalaya. ");
INSERT INTO sbk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Afume empapo eya kuulu bhahweli abhantu shila muji bhabhalumbilila nahubhaazye uMusa mumasinagogi shila Lutuyo.” ");
INSERT INTO sbk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eshi ezyo enongwa zyabhoneha nyinza hwa bhantu bhonti bhabhasalula, u Yuda yahetwaga Barsaba, nu Silas, bhabhabhalongozi bhi kanisa bhabhatuma hu Antiokia nu Paulo nu Barnaba. ");
INSERT INTO sbk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bhasimbile eshi, “Atume, nazee naholo, hwa holo betu akristo Amataifa bhabhali hu Antiokia, hu Shamu nahu Kilikia, tibhalamuha. ");
INSERT INTO sbk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tumvwizyu huje bhenzele abhantu bhafumile ohu bhasigatibhatumile ate bhabhaleteye emanyizyo, zyazibhayanzizye, mumoyo genyu. ");
INSERT INTO sbk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ate tilolile shinza aje tibhatume abhamwetu pandwemo na Paulo nu Barnaba, ");
INSERT INTO sbk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","abhantu bhabhahwisuulile amoyo gabho hunongwa yitawa lya Yesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tabhatumile aYuda nu Sila, bhabhabhuule zyonti ezyo zyatisimbile. ");
INSERT INTO sbk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Esho shizungwizye Umpepo Ufinjile, huje tisabhatwinshe izigo imwamu ashile gaalaga singwa Ungulubhi: ");
INSERT INTO sbk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","aje mugalushe afume huvifwani, ni danda, ne vyaviniongwile nu umalaya. Nkamubhasegushe nevii shabhabhe shinza hulimwe. Kwa helini.” ");
INSERT INTO sbk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Esho bhaabhalile hu Antiokia; bhatwala ekalata, bhabhabhuunganya bhonti. ");
INSERT INTO sbk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nabhabhaazizya ekalata ila bhasungwilwe tee, amoyo gabho gashiiye. ");
INSERT INTO sbk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","U Yuda nu Sila, na kuwe bhabhagwizizye umwoyo. ");
INSERT INTO sbk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nabhakhala uhwo pamante bhahasogola humwoyo ugwinza afume hwabhatumwilwe. ");
INSERT INTO sbk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lelo shabhoneha shinza uSila huje asagale uhwo ");
INSERT INTO sbk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","U Paulo na bhanji bhakhiiye hu Antiokia bhalumbililaga na manyizye izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nabhakhala ensiku zyenyinji uPaulo wabhuula uBarnaba, “Huje salii tibhajendele mwonti mwatalumbililaga tibhenye shabhahwendelela. ");
INSERT INTO sbk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","U Barnaba ahanza humweje u Yohana(Marko). ");
INSERT INTO sbk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","U Paulo siga asungwilwe humwe uMarko, yabhaleshile siga alongozenye nabho abhaleshile hu Pamfilia na hukuendelea nao katika kazi. ");
INSERT INTO sbk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bhahadalisanya tee pamande bhalehana, u Barnaba wamwega uMarko na shuule nawo, bhinjila mumeli bhabhala hu Kipro, ");
INSERT INTO sbk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","U Paulo wamwega, u Sila nasogole nawo. ");
INSERT INTO sbk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bhabhalile hu Shamu nahu Kilikia azeenje amoyo gabhaala bhabhalyeteshe izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","U Paulo pahinzile hu Derbe na hu Lystra; epo ahali ukijana umo yalyeteshe izu itawa yu Timotheo, ni Kijana aliyezaliwa na unyina ali Yahudi uise ali Giriki. ");
INSERT INTO sbk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abhantu bha Lystra nahu Ikonia bhahayanjile shinza. ");
INSERT INTO sbk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","U Paulo wanza asogole nawo, wamwega watahiili maana Ayahudi bhaaminyu huje uise wa Timotheo huje Giriki. ");
INSERT INTO sbk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Wabhasogolaga bhishiliye humiji bhabhalajizya huja bhazikhataje zyazisimbilwa natume hula hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Amakanisa gakhala shinza wa bhantu bhahinji bhonjelela apendushe hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","U Paulo nu wamwao bhabhala hu Filigia na hu Galatia, Umpepo wa Ngulubhi abhakhanile alumbilile izu hwijimbo lya hu Asia. ");
INSERT INTO sbk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nabhapalamila hu Misia, bhahalinga abhale hu Bithinia, lelo Umpepo wa Yesu wabhakhana. ");
INSERT INTO sbk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Shashila hu Misia bhabha hu Troa. ");
INSERT INTO sbk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nusiku uPaulo walola embonesyo umuntu wa hu Makedonia abhakwizya aiga mwenzemutavwe ohu.” ");
INSERT INTO sbk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","U Paulo nawalola embonesyo ezyo bhamanya huju Ungulubhi abhakwizizye huje bhabhale hu Makedonia, alumbilile izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tasogola afume hu Troa, tabhala hu Samothrake, shandao lwakwe tafiha hu Neapoli. ");
INSERT INTO sbk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Afume uhwo tafiha hu Filipi eya hu Makedonia, gwali muji gosi hu wilaya yabhatawalile Arumi uhwo takhiye hashe. ");
INSERT INTO sbk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Isiku elyelutuyo tahabhalile hwonze ye ndyango gwe muji tajendile idala elyahwisoho tagaga kabhanga tigapaga apapuutilw, tahakha pansi tayanga na bhashi bhamo bhabhahinzile uhwo. ");
INSERT INTO sbk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ushi umo itawa yu Lidia, yakazyaga amasukwa(usukwa), afumile hu Tiatira, atitejelezizye, Ungulubhi amwiguye umwoyo nahuzibhishe humwoyo zyaziyangwilwe nu Paulo. ");
INSERT INTO sbk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nawoziwa uumwene na bha munyumba yakwe watilabha aje tikhale pakhaya yakwe atilambile tee. ");
INSERT INTO sbk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Natabhalaga apuute, ulinouumo yali ne Mpepo embibhi ezyelaguzi takhomine nhwo, ulinduuyo apelaga efaida Ugosi, wakwe hulaguzi wakwe. ");
INSERT INTO sbk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ushi unu alondozizye u Paulo naje ebha bhantu bha Ngulubhi ula ugosi yabhabhalumbilila amawe idala elye wokovu”. ");
INSERT INTO sbk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Abhombile isho ensiku zyenyinji, lelo u Paulo avitilwe tee u Paulo pawagaluha hwisalo walidimila lila ipepo, “Waga awe wu mpepo embibhi epa mwunu usogole hwi tawa lya Yesu empepo embibhi yafuma. ");
INSERT INTO sbk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Agosi bhakwe ulenduula bhabhakhata aPaulo nu Sila bhabhadenemula musokoni na aviongozi bhahenyaga. ");
INSERT INTO sbk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na bhafisya hwalonzi bhaga abhantu ebha Bhayahudi bhaleta ibwango munsi yetu. ");
INSERT INTO sbk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhamanyizya enongwa zyasentihwanziwa akhate nazifute neshi Arumi.” ");
INSERT INTO sbk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ipuga lya bhantu bhabhakhata aPaulo nu Sila, alonzi bhabhasatula amenda gabho naje bhakhomwe ne nsanzo(bhashetwe) ");
INSERT INTO sbk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nabhashetwa nensanzo zye nyinji bhabhaponya mwijela na bhabhuule alinzi aje bhabhalinde shinza. ");
INSERT INTO sbk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bhaala alinzi nabhaposhela eamri, bhabhafunga aPaulo wusila ahati nyene bhabhapinya namanyoro mumanama. ");
INSERT INTO sbk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nu siku nyene aPaulo nu Sila bhapuuta natele eng'oma ezya hulumbe Ungulubhi ohu afungwe abhanje bhatejelezya, ");
INSERT INTO sbk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lyahafumila itensia lyayinzya ensi amandyango gigereza giguha na manyoro gafungwe gayembela. ");
INSERT INTO sbk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Olinzi wi Gereza wabhuha ahwenya eshi amandyango gu gereza gigushe wayeta wega ipanga wanzaje ahwibhole agagajibha afungwe bhonti bhaselenjile, ");
INSERT INTO sbk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","U Paulo wakhoola hwizu igosi waga usahwibude ate tenti tihweli epa”. ");
INSERT INTO sbk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Walabha amakhozyo walavya uhu ayetile wa yinje, wabhagwila aPaulo nu Sila, ");
INSERT INTO sbk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","wabhafumya hwunzi yi gereza waga mwebha gosi embombe wili nanii enokoshe?” ");
INSERT INTO sbk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhabhuula bhaga mwitishe uYesu nawee ubhahwokoshe na bhantu bhonti bhabhali munyumba yaho.” ");
INSERT INTO sbk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bhayanga izu lya Ngulubhi na bhantu bhakwe bhabhali munyumba yakwe, ");
INSERT INTO sbk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ulinzi wi gereza wabhega nu siku lwulwo(wuwo), wabhozya mwabhavwaliye umwene na bhantu bhonti abha munyumba yakwe bhoziwa. ");
INSERT INTO sbk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wabhaleta akhaya yakwe wabhapeela ishalye. Wabhanoluseshelo na bhantu bhonti abha munyumba. ");
INSERT INTO sbk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pasanya alonzi, bhatuma umuntu huje bhabhuule, ulinzi wi gereza abhefwe abhantu bhaala bhasogolaje”, ");
INSERT INTO sbk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ulinzi wi gereza wabhuula uPaulo huje alonzi bhajile embefwe musogolaje mubhalaje amwenyu.” ");
INSERT INTO sbk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","U Paulo wabhabhuula huje batikhomile nativwalazye pabhantu tatili Bharumi nkatilonje eshi bhalwatefwe shisili ate seetifuma bhenze bhatifumye bhibho”. ");
INSERT INTO sbk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ulinzi wabhabhuula alonzi enongwa zya Paulo nu Sila alonzi bhayeta ahwumvwe huje aPaulo nu Sila Bharumi. ");
INSERT INTO sbk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Alonzi bhenza abhefwe na bhabhafumya bhabhalaabha huje bhepe munsi yabho. ");
INSERT INTO sbk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","A Paulo nu Sila bhafuma mwigereza bhabhala hu khaya ya Lidia. U Paulo nabhabhalola abhamwabho bhabhagwizya umwoyo, pamade bhasogola bhepa munsi iyo. ");
INSERT INTO sbk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nabhafiha hu Amfipoli na hu Apolonia, bhafiha hu Thesalonike uhwo hwali nisinagogi lya Bhayahudi. ");
INSERT INTO sbk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","U Paulo azobheleye abhale amwabho ensiku zitatu ezyelutuyo adalisanyaga nabho mwibhangili. ");
INSERT INTO sbk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Abhabhuulaga ezyazisimbilwe mwibhangili huje yaasimbilwe yu Yesu aje ailabha, aifwa nantele aizyuha afume hwa bhafwe yayunu yembabhuula enongwa zyakwe” ");
INSERT INTO sbk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ayahudi bhamo na Giriki nabhasai bhabhinji bheteha bhafwata uPaulo. ");
INSERT INTO sbk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lelo Ayahudi bhamo bhabhasuliha abhantu bhabhinji a bhahusokoni bhaalole ukero, bhaivamila enyumba ya Jason, aje bhabhakhate aPaulo nu Sila aje bhabhalete hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Naseebhabhaga bhakhata u Jasoni na bhanji bhabhatwala hwa ofisa bhe muji bhaga abhantu bhabhagaluzinye ensi bhafishile nuhuli, ");
INSERT INTO sbk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Abhalume ebha uJasoni abhakaribizizye bhananganya esheria ya Kaisari, bhaiga ahweli umfumu uwamwabho ahwitwa yu Yesu” ");
INSERT INTO sbk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ipuga lya maofa nabhahumvwa isho bhasingana umwoyo. ");
INSERT INTO sbk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nabhega hela zye ulinzi hwa Jasoni bhabhaleshela aje basogolaje. ");
INSERT INTO sbk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nu siku bhatuma uPaulo nu Sila hu Beroya. Nabhafiha hula bhahinjila mwisinagogi lya Bhayahudi. ");
INSERT INTO sbk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abhantu bhaala bhaali wenjele bhatejelezyaga zyabhayanga, a Paulo nu Sila, nazichunguzye aje zyazisimbilwe zyezyo. ");
INSERT INTO sbk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abhinja bhahitishe na bhashi abheshi Giriki bhabhali nulusuliho nalume bhahinji. ");
INSERT INTO sbk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ayahudi bha hu Thesalonike bhahumvwizye huje aPaulo nu Sila bhali uwho bhazumbilila bhabhafuatile nalete efujo hwabhantu. ");
INSERT INTO sbk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","U Paulo bhasogozya nanali hwidala lye idimi igosi, lelo u Barnaba nu Timotheo bhasagala pala. ");
INSERT INTO sbk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aholo bhala bhatwalile uPaulo hu Athene, u Paulo wabhalajizya huje uSila nu Timotheo bhenze nanali. ");
INSERT INTO sbk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","U Paulo avitilwe tee mumwoyo gwakwe shalolile evifwa vinji munsi ela. ");
INSERT INTO sbk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","U Paulo adalisanyaga nabho ayahudi shila lisiku mwisinagogi na husokoni. ");
INSERT INTO sbk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Lelo Abhefalsafa abha Waepikureo na Waestoiko bhabhalila na bhanje bhabhinji. Bhaga unu umuntu ayanga zyenu uduvya bhamo bhaga, abhoneha alumbilila ezya Ngulubhi ujeni,” alumbilila ezya Yesu nu luzyuho. ");
INSERT INTO sbk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bhamwega uPaulo bhaleta hwa Areopago, bhaga, “Tibhajiye azimanye emanyizyo zyaho ezyo empya zyumanyizya? ");
INSERT INTO sbk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Uletile amambo amapya mumakutu getu. Tihwanzaje timanye nate zili neshi wili?” ");
INSERT INTO sbk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Abhantu bha hu Athene bhasungwa atejelezye enongwa empya.) ");
INSERT INTO sbk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","U Paulo wimilila hwa bantu bha Aeropago na huje amwe mubhantu mwahu Athene, muli bhe dini zye shila namna, ");
INSERT INTO sbk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nanashilaga uhwo humadhebu genyu endolile musimbile “HWA NGULUBHI YASIGA”. Eshi ane embaletela enongwa zyakwe uyo yamupuuta nahumanyee. ");
INSERT INTO sbk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ungulubhi yabhuumbile ensi ne mwanya ne vintu vyonti siga akhala munyumba ezyapuutile zyazizengwilwe na makhono ga bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nantele siga abhombelwa namakhono umwene yatipela uwomi nevyenje vyonti. ");
INSERT INTO sbk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ashilile hwa muntu umo abhabhisaiye abhantu outaratibu abheshele usiku na pasanya, eshisuku ne shisanya abhabhishiye ne mpaho mwamukhala. ");
INSERT INTO sbk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Eshi, bhahwanziwa huje bhamwanze Ungulubhi, nahumwaje umwene sigahutali nate. ");
INSERT INTO sbk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Hwa mwene tijenda, tilya nabhe nu womi wetu, neshi shayanjile uteeli umo aje ate tili bhapapwe bhakwe.' ");
INSERT INTO sbk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eshi, ate nkashele tilibhapapwe nu Ngulubhi setihwanziwa hulinganye Ngulubhi, nedhahabu, ne shaba, au nevifwani vyabhapunza vyavilingine wa bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Emande abhanga aje siga azilola, eshi alajizya hwa bhantu bhonti huje bhalambe. ");
INSERT INTO sbk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Eshi umwene abhishile isiku lyaibhalonga abhantu bhonti bila hubhonele umuntu Ungulubhi afumizye uYesu huje abhantu bhamwitishe uyazyusizye afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Abhantu bhahu Athene nabhuumvwa huje abhafwe bhazyuha, bhamo bhazihaki u Paulo bhagatitejelezye hani zyuyanga ezyo” ");
INSERT INTO sbk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pamande uPaulo wabhaleha. ");
INSERT INTO sbk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lelo bhamo bhahitiha, bhahamwitiha uYesu ahali u Dionisio Mwareopago, nushi itawa yu Damari na bha mwabho. ");
INSERT INTO sbk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pamande, u Paulo ahasogola hu Asene ahabhala hu Korintho. ");
INSERT INTO sbk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ulwo bhamwaga umuntu umo itawa yu Akwila ikabila lyakwe lyali bha Ponto, ushi wakwe ali Prisila bhahinzila afume hu Italia, maana u Klaudia ajile Ayahudi bhonti bhasogole hu Roma; u Paulo ahabhalile hwabhamu ibha; ");
INSERT INTO sbk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","u Paulo wakhala amwabho abhomba imbombo zyazilingine ne zabho bhalinganyaga amahema. ");
INSERT INTO sbk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","U Paulo ayanga nabho mwisinagogi shila lisiku elyetuyo abhasulihaga Ayahudi na Giriki. ");
INSERT INTO sbk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","U Sila nu Timotheo pabhinza u Paulo abhuulwa nu Mpepo abhabhule Ayahudi huje uYesu yu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ayahudi nabhakhana na hutanile, u Paulo wakunyuta umenda gwakwe wabhabhuula, huje idanda lyenyu libhe pamatwe genyu, mwemwe ane sigaihailongwa, ahwande eshi ane embala hwa bhantu bha Mataifa”. ");
INSERT INTO sbk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wasogola epo wabhala lwa Tito Yusto, Umuntu yaali puti hwa Ngulubhi. Enyumba yakwe yapalamineni sinagogi. ");
INSERT INTO sbk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","U Krispo, ulongozi wisinagogi ahapenduha umwene na bhantu bhakwe bhakhala nabho, abhantu bhabhinji abhahu Korintho bhahitishiye izu lya Ngulubhi na hwoziwe. ");
INSERT INTO sbk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ugosi wayanga nu Paulo humbonesyo nusiku waga usahogope awe yangaga wene usahapume. ");
INSERT INTO sbk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ane endipandwimo nawe, nuumo yabhahuvwalazye ane endi na bhantu bhinji humuji ogu”. ");
INSERT INTO sbk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","U Paulo wakhala umwaha gumo na mezi tanda, wamanyizya izu lya Ngulubhi hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lelo ugalio pabhihwa aje abhelongozi hu Akaya, Ayahudi bhahanda alete amalabha hwa Paulo batwala hwalonzi bhikoloti aje alongwe, ");
INSERT INTO sbk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bhaga, “Umuntu unu amanyizya abhantu shaseshihwanziwa hu sheria”. ");
INSERT INTO sbk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","U Paulo nahanzaga aje ayanje, u Gailo owabhabhuula Ayahudi, “Huje ugali nanzi wenje ane handa embalonga. ");
INSERT INTO sbk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Eshi mundetela enongwa ezye matawa ne sheria zyenyu. Ezi enongwa longaji mwemwe ane sigaihwanza abhe lonzi wezii.” ");
INSERT INTO sbk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","U Gailo wabhabhinga aje bhasogole hwitengo elye lonzi, ");
INSERT INTO sbk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bhakhata, u Sosthene, ulongozi wi sinagogi bhakhoma. Lelo u Gailo sigaasaganya zyonti zyabhabhombile. ");
INSERT INTO sbk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","U Paulo nawakhala ensiku zyenyinji pala wabhaleha abhamwabho umwene wasogola abhale hu Siria wa mwega u Prisila nu Akwila. Sabhasile asogole ahwinjile mumeli uPaulo wasyengula isisi maana afingine hwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nabhafiha hu Efeso, wabhaleha aPrisila nu Akwila umwene winjila mwisinagogi ayanje na Yahudi. ");
INSERT INTO sbk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nabhabhuula uPaulo akhale nabho ensiku zinyinji umwene akhiine. ");
INSERT INTO sbk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Waga ihaiwela hulimwe nkaligane lya Ngulubhi”. wasogola ne meli afume hu Efeso. ");
INSERT INTO sbk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","U Paulo nawiha hu Kaisaria, wazubha abhale alamushe Ikanisa lya hu Yelusalemu, nantele wiha abhale hwi kanisa lya hu Antiokia. ");
INSERT INTO sbk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nawakhala hashe uhwo wabhala hu Galatia na hu Frigia na bhazinzye umwoyo amanjili bhonti. ");
INSERT INTO sbk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","U Yahudi umo itawa yu Apolo, ahinzile hu Efeso. Alimenye shinza izu lya Ngulubhi namanyizye. ");
INSERT INTO sbk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U Apolo amanyiziwe imanyizyo ezya hwa Yesu. Alikhalaganu amanyile amanyizyaga shinza izu lya Yesu, lelo aumanyile wuwozyo wa Yohana wene. ");
INSERT INTO sbk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U Apolo ayangaga shinza mushibhanza. U Prisila nu Akwila bhahuuda na nawo, bhabhuula izu lya Ngulubhi shabhaliminye abhene. ");
INSERT INTO sbk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nawanza aje asogole bhasimbila ikalata iyaje bhamwejelele shinza hula hu Akaya pawafiha abhavwizye tee akristo abhuuhwo. ");
INSERT INTO sbk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","U Apolo alini khone abhamenile Ayahudi pawinji, abalengaga mwibhangili huje uYesu yu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","U Apolo nali hu Korintho, u Paulo ashilile hunsi izya pamwanya afishile hu Efeso atangine na manyili yhwo. ");
INSERT INTO sbk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U Paulo wabhabhuzya, “Huje, mwamposhiye Umpepo Ufinjile pamwahitishe?” Bhaga, “Ha' aa, atahuhwumvwe siga tahumvwizye huje huli Umpepo Ufinjile.” ");
INSERT INTO sbk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","U Paulo wabhabhuuzya, “Eshi mwahoziwe?” Wozyonshii, “Abheene bhaga uwozyo wa Yohana. ");
INSERT INTO sbk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","U Paulo waga, “U Yohana abhozizye huwozyo wa alambe. Abhabhuulile bhaala aje bhamwitishe uyo yahwinza pamande uYesu.” ");
INSERT INTO sbk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Abhantu nabhuumvwa enongwa ezi bhoziwa hwitawa lya Yesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","U Paulo nawabhabhishila amakhono pitwe Umpepo Ufinjile wabhishila bhanda ayanje enjango empya nakuwe. ");
INSERT INTO sbk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bhahali alume ilonga na bhabhili. ");
INSERT INTO sbk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","U Paulo ahinjila mwisinagogi amezi gatatu. Alongozyaga enjangano na bhavute abhantu hwa Yesu nu uumwene uwa humwanya. ");
INSERT INTO sbk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lelo Ayahudi bhamo bhahali na mampuli sigabhahitihaga, bhaligaga nabhayangaga ezya Yesu. U Paulo wabhefwa aKtilisti wabhala nabho muukumbi wa Tirano abhamanyizye. ");
INSERT INTO sbk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ahindiliye isho humaha gabhili bhonti bhabhakhalaga hu Asia bhahumvwizye izu lya Ngulubhi Ayahudi na Ayunani(Agriki). ");
INSERT INTO sbk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ungulubhi abhombaga amambo amagosi hukhono gwa Paulo, ");
INSERT INTO sbk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","abhabhinu bhaponaga ata utuleso na menda gagafumile mubili gwa Paulo bhabhapalamansiaga nago bhaponaga ne Mpepo embibhi zyahepaga mwabhantu. ");
INSERT INTO sbk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bhahali Ayahudi bhamo bhaali bhemazimu, bhahanzaga alitumile itawa lya Yesu hu faida yabho, bhabhabhuulaga abhantu bhabhali ne Mpepo embibhi epa hwitawa lya Yesu ula yalumbililwa nu Paulo.” ");
INSERT INTO sbk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhabhabhombaga isho bhali saba bhahali bhanabha sikewa yahali Gosi wishibhanza sha Yahudi, Skewa. ");
INSERT INTO sbk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Zila Impepo embibhi zyabhabhuula zyaga, “U Paulo timinye nu Yesu wope timinye amwe mwenanuu?” ");
INSERT INTO sbk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Zila empepo zyabhatomoshela zya bhamena ikhoni, zyabhavwalazya. Bhashimbila shabhali welele afume munyumba mula. ");
INSERT INTO sbk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ijambo eli lyamanyiha hwa bhantu bhonti, Ayahudi na Giriki, bhogopa itawa lya Yesu lyatinihwa na bhantu. ");
INSERT INTO sbk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Akristo bhinji bhenza alambe, bhazibhonesya embibhi zabhabhomba. ");
INSERT INTO sbk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Abhantu bhabhatumilaga evitabu alagulile bhahaleta evitabu vyabhobhavipemba nu mwoto, bhabhazizye egalama yakwe yahali evipanda vyehala elfu amalongo gasanu. ");
INSERT INTO sbk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Izu lya Ngulubhi lyanyampana hwonti. ");
INSERT INTO sbk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","U Paulo nawamala imbombo yakwe hula hu Efeso Umpepo walongozya abhale hu Yerusalemu ashilile hu Makedonia na hu Akaya; Waga na nakhala uhwo nehaibhala hu Rumi.” ");
INSERT INTO sbk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","U Paulo wabhatuma amanyili bhakwe bhabhili, u Timotheo nu Erasto, bhabhamwavwize. Lelo umwene ahasagala hu Asia. ");
INSERT INTO sbk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Hula hu Efeso abhantu bhaletile efujo husababu yidala liila. ");
INSERT INTO sbk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Umuntu umo ali Sonara itawa ali yu Demetrio, alinganya ga utufwanitwihela ufwa Ungulubhi u Diana, aletile ebiashara yakwe hwa fundi. ");
INSERT INTO sbk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wabhabunganya afundi bhonti abhimbombo iyo, wabhabhuula huje, “Mumenye ebiashara ene huja etipela ehela zyinyinji. ");
INSERT INTO sbk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Siga hu Efeso hwene, nahu Asia hwonti eshi unu uPaulo abhasulihenye abhantu aiga numo Ungulubhi yalinginywe namakhono. ");
INSERT INTO sbk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nantele ehweli ehatali iyaje ebiashara yetu sihaihwanziwa, sigayibiashara nyene nu Ngulubhi ushiwi tu ugosi uDiana abhazalauliwe netezye ougosi waluwe, nantele abha Asia bhonti bhahupuuta nensi yonti. ");
INSERT INTO sbk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nabhahumvwa isho bhahabwaga wikhatwe ni lyoyo, bhahaga, “uDiana wa bha Efeso gosi.” ");
INSERT INTO sbk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Umuji gwonti gwabha nefujo abhantu binjila muukumbi wiyango. Bhabhakhate bhabhashulaga nu Paulo, u Gayo nu Aristariko, bhabhafumile hu Makedonia. ");
INSERT INTO sbk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","U Paulo ahanzaga ahwinjile mwabhali muukumbi, lelo amanyili bakwe bhaha khanizyu. ");
INSERT INTO sbk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Amaafisa abhe mkoa bhabhali bhakundane nu Paulo bhatumile uujumbe huje asahinjile muukumbi uwinyango. ");
INSERT INTO sbk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Abhantu bhachanganyikine sigabhaminye ne zyabhayanga, bhamo bhaiga eshi bhamo shila. ");
INSERT INTO sbk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayahudi bhaleta u Iskanda hwabhabhungine abhantu bhabhiha hwitagalila. U Iskanda ahabhapumya abhantu aje ayanje na bhantu, afumye amaelezo. ");
INSERT INTO sbk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Abhantu nabhamanya huje Iskanda Yahudi bhabwaga ibwago amasala gabhili bhaga uDiana gosi wa bha Efeso.” ");
INSERT INTO sbk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Usimbi we muji nawabhapumya ubhungano gula waga amwe mubhalume mubha Efeso wenu yasiga aminye huje umuji ogu gwa Efeso gwagutunza eshibhanza sha Diana ugosi nela epicha yehagwiye afume humwanya? ");
INSERT INTO sbk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Eshi poomi nasoti, ezi sigatibhomba nanali, musabhombe nahamo. ");
INSERT INTO sbk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Eshi mubhaletile abhantu ebha palonzi sigabhiibha nantele sigabhalijile Ungulubhi wetu ushe. ");
INSERT INTO sbk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Eshi u Demetrio na bhamwabho nafundi bhakwe nkashele bhali na mashitako gagonti numuntu yayonti ikoroti lihweli wazi bhaletwe palonzi. ");
INSERT INTO sbk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lelo nkashele uhwanza amambo aganji tibhagalonje sheshinza. ");
INSERT INTO sbk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tili muhatari iyalongwe uefujo ezi nantele sigatibhajiye azigolosye enongwa ezi. ");
INSERT INTO sbk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nawayanga isho wabhanyampanya abhantu. ");
INSERT INTO sbk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nazyamaliha efujo zila uPaulo wabhakwizya amanyili wabhazinzya amoyo wabhalaga wabhala hu Makedonia. ");
INSERT INTO sbk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nawashila amikoa ego abhazinzya amoyo amanyili wabhala hu Yunani. ");
INSERT INTO sbk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pawakhala amezi gatatu zyahapangwa embibhi na Wayahudi napalamilaga ashuule hwidala lya muminzi, abhale hu Shamu, sigawabhala uhwo washilila hu Makedonia. ");
INSERT INTO sbk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bhashulile nabho paka hu Asia bhahali bha Sopatro, mwana wa Pirho yafumile hu Berea; Aristariko nu Sekundo, bhonti bhafumile hwa akristi bha hu Thesalonike; Gayo wa hu Derbe; u Timotheo; Tikiko nu Trofimo bhafumile hu Asia. ");
INSERT INTO sbk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Lelo abhantu ebha bhatagaliye bhatihulaga hula hu Troa. ");
INSERT INTO sbk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Hwidala ilya minzi afume hu Filipi nazyashila ensiku ezye mabumunda gasi gabhaponyizye ehamila isiku ilya sanu tafiha hu Troa. Taakhiye uhwo ensiku saba. ");
INSERT INTO sbk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Isiku ila muhungu patabhuungine alye amabumunda, u Paulo alumbiliye na Waamini. Alikuwa akipanga kuondoka kesho yake, hivyo akaendelea kuongea tee paka nu siku uwapahati. ");
INSERT INTO sbk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Zyahali ihozyo zinyinji hwatakhiye hwigulu. ");
INSERT INTO sbk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","U kijana umo itawa lyakwe yu Utiko, akhiitwe nu tulo akhiiye ambali pidilisha pamande walagala pansi afume igulu ilya tatu na bhabhala hutole bhega afwiye. ");
INSERT INTO sbk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lelo uPaulo wope wiha pansi, wa hwigolosya puula ufwe wabhabhuula waga musahiile umwoyo unu mwomi.” ");
INSERT INTO sbk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Wazubha hwigulu antele wamensula ibumunda walya nawayanga nabho paka ninzansha wasogola. ");
INSERT INTO sbk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bhaleta ukijana ula shamwomi bhasungwa tee. ");
INSERT INTO sbk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ate tatagaalila ne meli tabhala hu Aso, tapanjile humweje uPaulo, umwene ajendile hunsi inyoomu shapanjile umwene. ");
INSERT INTO sbk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Natatangana nawo Aso, tapashila mumeli tabhala nawo hu Mitilene. ");
INSERT INTO sbk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ate tasogola afume uhwo isiku ilya bhili tafiha hu kisiwa she Kio. Isiku ilyamwabho tafiha hu kisiwa she Samo, shandao lwakwe tafiha hu Mileto. ");
INSERT INTO sbk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","U Paulo ahamuya ashuulile ashilile hu Efeso, siga ahanzaga atumile umuda gwagwonti uhwo, ali nu piliganu uwabhale hu Yerusalemu hu shikulukulu she Pentekoste. ");
INSERT INTO sbk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Afume hu Mileto atumile abhantu hu Efeso nabhakwizye azee bhi kanisa. ");
INSERT INTO sbk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nabhafiha wabhabhuula huje mwe mumenye ahwande pihandiye ulwahwande ahwinze ipa pa Asia shanahali hulimwe ensiku zyonti. ");
INSERT INTO sbk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Imbombile imbombo ya Ngulubhi huunyenyekevu wonti na hwiyisye na humansozi na malabha gaganajile hwa Yahudi. ");
INSERT INTO sbk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mumenye shanali mwigushe hulimwe, ihabhabhuulaga shila hantu, sigana bhafishile nahamo najendaga shila nyumba abhamanyizye. ");
INSERT INTO sbk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mumenye shanabhadamilaga Ayahudi na Yunani, aje bhalambe na humwitishe Ungulubhi bhabhe nu lwitiho hwa Yesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Enyii eshi ane shehumweteha Umpepo Ufinjile aje embale hu Yerusalemu nantele sigaaenzimenye zyazibhanaje uhwo, ");
INSERT INTO sbk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","pipo Umpepo Ufinjile ambuula shila muji gwimbala huje empengo zihuguula, na malabha. ");
INSERT INTO sbk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lelo ane siga insibiliye amaisha gane huje gali ne thamani ani ihwanza aje imale imbombo yakwe sheshinza yamahejeliya huwa mwene uYesu Kilisti naiyanje ineema ya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Eshi, enyaa, bhaala bhonti, bhanabha bhuulile izu lya Ngulubhi sigamwaindola amaso gane nantele. ");
INSERT INTO sbk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Embabhuula eshi huje sigana iongwa hushauli yenyu. ");
INSERT INTO sbk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ane sigahwizu wiliye abhabhuule izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Eshi mubhanje maso mubhene hwa mubhene nalila ipuga Ungulubhi lya bhapiiye aje mulidimaje, mulyenyaje ipuga lya Yesu lyalikalile hwidanda lyake yuyo. ");
INSERT INTO sbk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Iminye huje ane nanasogola enkanyaga zyayinza sigazyaibhasajila. ");
INSERT INTO sbk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Iminye huje bhamo mulimwe mwomu bhaibha bhabhaibhatezya aje mubhalondozyoje abhene. ");
INSERT INTO sbk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","mubhe maso. Ane siganaleshile abhamanyizye shila muntu nabhamanyizizye usiku na pasanya. ");
INSERT INTO sbk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Eshi ane embabhiha hwa Ngulubhi na hwizu elyelusajilo lwakwe lyalibhajiye abhzenje nabhapele ugaali nabhabhishe bhafinje hwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Siga nazilishe ihela, edhahabu na menda. ");
INSERT INTO sbk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mumenye huje amakhono gane gampeliile vyanahanzaga nabhombaga imbombo nabhavwe abhanji bhabhali pamo nanee. ");
INSERT INTO sbk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nabhamanyizizye abhombe imbombo nabhavwe bhasigabhajiye abhombe embombo, ne manyizyo zya Yesu izyaje shinza afumye ashile aposhele.” ");
INSERT INTO sbk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nawayanga nabho wafugamila amafugamo uuta nabho. ");
INSERT INTO sbk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bhonti bhalila bhagwila uPaulo munsingo bhabusu. ");
INSERT INTO sbk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bhazugumiye tee payanjile huje siga mwaindo nantele amaso gane, bhalolela mumeli. ");
INSERT INTO sbk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Natalehana nabho, tishuula mubahari tafiha hu kosi, shaudabho lwakwe tafiha hu Rodo, natafuma uhwo tafiha hu muji gwa Patara. ");
INSERT INTO sbk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Natapata emeli yelobhola hu Foinike, tinjila tashuula nayo. ");
INSERT INTO sbk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Natafiha hu kisiwa cha hu Kipro, taileha hukhono umongo, tashuula tafiha hu Siria, tabhila enanga hu muji gwa hu Tiro, uhwo emeli yahanziwaga ahwisye amazigo. ");
INSERT INTO sbk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Natabhalola amanyili, takhala uhwo ensiku saba. Amanyili ebha bhasunda uPaulo ashilile hu Mpepo Ufinjile huje usahakhanye ulwayo hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Natamalizya ensiku zila, tasogola. Bhatilolezya bhonti nabhashi bhabho na bhana bhabho hwatabhalaga natafiha munshinji ye bahari tafugamila mafugamo tapuuta, nkalatagana nabho. ");
INSERT INTO sbk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ate tiinjila mumeli, bhope bhawele amwabho. ");
INSERT INTO sbk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Natamalizya esafari yetu afume hu Tiro, tafiha hu Tolemai. Pala tabhalamuha aholo takhala isiku limo. ");
INSERT INTO sbk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Shandabho lwakwe tasogola tafiha hu Kaisaria. Ate tinjile munyumba ya Filipo, yaali lombeleli wi izu lya Ngulubhi, aali na bhaale saba. ");
INSERT INTO sbk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Omuntu unuaali na bhaale bhane abhaale ebho bhakuwaga. ");
INSERT INTO sbk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Natakhala uhwo, ahika ukuwe umo afume hu Uyahudi itawa yu Agabo. ");
INSERT INTO sbk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ahinzile hulite, wega ilampa lya Paulo wahwipinya amakhono na manama, waga Umpepo Ufinjile aiga. umwanisholilampa eli bhabhahumpiye Ayahudi bha hu Yerusalemu, na hutwale mumakhono ga bhantu bha mataifa.” ");
INSERT INTO sbk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Natumvwa enongwa izyo ate na bhantu bhabhakhala pala tabhuula u Paulo huje asahishe abhale hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","U Paulo wabhabhuula, waga mulila yeenu, mbona muntengula umwoyo ane enditayari apinywe, siyo apinywe tu nafwe hwayo, hu shauli yitawa ilya Yesu ugosi wane.” ");
INSERT INTO sbk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pipo uPaulo sigaahanzaga asundwe ate taaleha, taga Ungulubhi abhombe zyazigine.” ");
INSERT INTO sbk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nazyashila ensiku ezi, ate teega amafuko getu, taabhala hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amanyili bhamo bhabhafumile hu Kaisaria bhahalongozanya nate. Bhalete umuntu umo oMunasoni, elyo litawa lyakwe ali wa hu Kipro ali manyili kuulu yatakhiyenawo. ");
INSERT INTO sbk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Natafiha hu Yerusalemu aholo bhetu bhatejeliye shinza tee na hulugano. ");
INSERT INTO sbk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Shandao lwalwe u Paulo tabhalile tenti hwa Yakobo, na bhazee bhonti bhahali. ");
INSERT INTO sbk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nawabhalamuha, abhabhuulile zyonti zyabhombile Ungulubhi hwa mataifa ashilile hu makhono gakwe. ");
INSERT INTO sbk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nabhuumvwa enongwa izyo bhalumba Ungulubhi, bhabhuula uPaulo walola, elufu zilinga zya Yahudi. Bhabhitishe abhene bhahwanza hukhate ye sheria. ");
INSERT INTO sbk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bhabhuulilwe huje awe umanyizya Ayahudi abhahumataifa aje mugande akhate esheria ya Musa, nantele muganje abhatahiri abhana bhenyu nantele musahagilondozye emila zyetu enkuulu. ");
INSERT INTO sbk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Eshi tikhonzye wili? Nantele bhabhahwumvwe huje uli ohu. ");
INSERT INTO sbk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Eshi ubhombe shila shatihubhuula eshi: tili na bhantu bhane bhabhahwifinjile. ");
INSERT INTO sbk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bheje abhantu ebha uhwiyozye nabho, ubhasombele eghalama zyabho nkabhasyengule amatwe gabho. Nkabhamanye huje nawe ufuata esheria. ");
INSERT INTO sbk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lelo hwakristo abhamataifa tabhasimbiye huje musalalye evintu vyabhafumizye sadaka huvifwani, neviniongwe ni danda, nu umalaya.” ");
INSERT INTO sbk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","U Paulo wabhega alume ni isiku ilyabhili wahwiyozya yuyo nabhaala bhantu, winjila mushibhanza, watandazya ensiku ezyahwiyozye, paka esadaka bhafumye hwa bhonti. ");
INSERT INTO sbk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ensiku saba nazyapalamila amalishe Ayahudi bhabhafumile hu Asia bhalola uPaulo mushibhanza, bhavitwa tee, bhasontezya na makhono. ");
INSERT INTO sbk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bhakhoola iholo abhaIsraeli enzi intuavwe ulamuntu ayinzile yamanyizya abhantu zyasigazihwanziwa mu mushibhanza ahwanza apachafule apafinjile epa.” ");
INSERT INTO sbk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ulwahwande uPaulo bhalolile nu Trofimo uwa hu Efeso bhagagajibha aletile mushibhanza. ");
INSERT INTO sbk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Umuji gwonti gwagunduha abhantu bhashimbila bhakhata u Paulo. Bhafumya hwunzi afume mushibhanza amandyango gafungwa. ");
INSERT INTO sbk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nabhahanzaga hubude, ugosi wikeya lya alinzi bhe Yerusalemu huje yonti elifujo yeene. ");
INSERT INTO sbk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wega askari nu jemedari bhashimbilila pa bhantu, abhantu nabhabhalola asikari bhaaleka hukhone uPaulo. ");
INSERT INTO sbk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ugosi wikeya wapalamila uPaulo wakhata bhapinya na manyoro gabhili. Wabhuzya awe, wenanu ubhombile yeenu. ");
INSERT INTO sbk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Abhantu bhabwagaga ibwago siga ahumvwaga nazimo zyabhayanga wabhabhuula asilari huje mwinjizi muhati mwingome. ");
INSERT INTO sbk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nabhafiha pangazi(pandandalilo) usikari wamwega, efujo zyali ngosi. ");
INSERT INTO sbk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ipuga lya bhantu lyalondozyaga naje mwefwi uyo!” ");
INSERT INTO sbk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nabhaleta uPaulo mungome, u Paulo wabhuula ugosi wi keya ibhuule ahantu?” Ugosi wi keya waga uyanga shi Yunani? ");
INSERT INTO sbk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Awe siga yayula uMisri yalongozizye unanzi ahijile agaidi elufu zine mwisengo?” ");
INSERT INTO sbk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","U Paulo waga ane endi Muyahudi wa hu Tarso iya hu Kilikia. Ilaba munduhusu enjanje na bhantu.” ");
INSERT INTO sbk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ugosi hawakunda u Paulo wimilila pa ndandalilo wabhagolosezya amakhono gakwe. Abhantu abhapuuma, wayanga nabho hushi Ebrania. Akasema, ");
INSERT INTO sbk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Bhaholo na bhaise bhane, ehwiyuumile hulimwe.” ");
INSERT INTO sbk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ubungano nabhuumvwa uPaulo ayanga eshiebrania, bhonti bhapuma kati. Wayanga waga, ");
INSERT INTO sbk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ane endi muyahudi, empepwe hu Tarso ieneo lya hu Kilikia, ihapite elimu humuji ogu, omwalimu wane ali yu Gamalieli. Ihamanyije idala lyaligolushi elya bhaise bhetu. Ane endi khalaganu hwa Ngulubhi, neshi shamundola. ");
INSERT INTO sbk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nabhalavizye nabhapinyaga alume na bhashe na bhafunje mwijela. ");
INSERT INTO sbk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ugosi wishibhanza nazee bhabhajiye ayanje, huje nahajile ekalata yabhala nayo hu Dameski, aje bhakhate nabhalete hu Yerusalemu abhantu abhidala lila aje bhalongwe. ");
INSERT INTO sbk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Panabhalaga hu Dameski, lwanapalamiye, ulukhozyo lwafumile humwanya lwahozya. ");
INSERT INTO sbk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nahumvwa izu liyiga, 'Sauli, Sauli yeenu ohumvisya?' ");
INSERT INTO sbk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Waga ane ne Yesu, Munazareti wu mvisya.' ");
INSERT INTO sbk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bhaala bhabhali nane bhahumvizye izu lelo sigabhalolile umuntu yayangaga nane. ");
INSERT INTO sbk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nabhuuzya waga, ihonzye wili Gosi?' Wambuula waga imilila bhalaga hu Dameski uhwo ubhabhuulwe izyuhwanziwa abhombe.' ");
INSERT INTO sbk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Amaso gane gabadiye ulukhozyo lula lwali lukhali, bhaala bhabhali nane bhahata ukhono bhantwala hu Dameski. ");
INSERT INTO sbk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Uhwo natangana nu muntu umo, itawa yu Anania, uyo atinihwaga na Yahudi bhonti bhabhali uhwo, umuntu uyo akhite tee isheria. ");
INSERT INTO sbk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Winza huline wimilila hwitagalila lyane waga holo wane Sauli, amaso gaho galole' Papaala nalola. ");
INSERT INTO sbk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Waga, 'Ungulubhi waise bhetu asaluye awe uzilole ezyasungwa umwene na hwumvwe izu lyaufuma mwilomu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Eshi awe ubhabhe keti wakwe zyuzilolile na hwumvwe. ");
INSERT INTO sbk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eshi leha akhaabile emelela? Uyoziwe uyozye embibhi zyaho, ulikwizye itawa lyakwe.' ");
INSERT INTO sbk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Nanawela hu Yerusalemu, nabhala mushibhanza apuute, nalola embonesyo. ");
INSERT INTO sbk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nalola ambuula aiga sogola hu Yerusalemu abhantu sigabhabhazyitishe enongwa zyaho nuhainjanga ane.' ");
INSERT INTO sbk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ane naga abhene bhaminye huje nabhafungaga mwijela bhabhalikwizyaga itawa lyaho mumasinagogi. ");
INSERT INTO sbk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ni danda lya Stefano uketi waho anehimiliye papipi nenalindaga amenda gabho bhabhabudaga u Stefano.' ");
INSERT INTO sbk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lelo ambuulile, 'Huje ihutuma uhutali hwabhantu bhamataifa.'” ");
INSERT INTO sbk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Abhantu bhaga womo ayanje enongwa ezi. Pamande nantele bhabwaga bhage sogozyi umuntu unu pansi siga ahwanziwa aje abhe mwomi.” ");
INSERT INTO sbk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nabhabwaga bhaponya amenda nalusye amankondi humwanya, ");
INSERT INTO sbk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ujemedari ugosi wamwinjizya uPaulo mungome. Bhabhuzya ahu bhahusheta ni nsanzo aje amanje huje yeenu abhantu bhahubwajila ibwago. ");
INSERT INTO sbk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","U Paulo nawakhomwa wabhuuzya uakida yapalamine nawo, “Eshi shinza hukhone umuntu yali Murumi samusile hulonje?” ");
INSERT INTO sbk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U Akida wabhala hwa jemedari waga umuntu unu Murumi.” ");
INSERT INTO sbk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ujemedari wabhala wabhuuzya waga awe uli Murumi?” U Paulo waga, “Ena.” ");
INSERT INTO sbk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ujemedari waga, “Ane nakalile ni hela oulaia.” U Paulo waga ane endi Murumi wapapwe.” ");
INSERT INTO sbk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bhabhahanzaga hubhuuzye bhasogola lwulwo. Wope ujemedari wogopa nahumvwa huje uPaulo ali Murumi na huje afunjile. ");
INSERT INTO sbk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Shandabho lwakwe ujemedari ahanzaga amanye zyabhashitakiye u Paulo. Wabhakwizya agosi bheshibhanza nalonzi bhibalaza bhonti wamwaula inyabho uPaulo waleta, wabhiha pahati. ");
INSERT INTO sbk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","U Paulo wabhenya alonzi bhi baraza waga bhaholo bhane ane ihiye mwa Ngulubhi nu mwoyo ugwinza paka asanyunu ishi.” ");
INSERT INTO sbk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ugosi wishibhanza wabhabhuula huje bhakhome ilomu lyakwe. ");
INSERT INTO sbk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","U Paulo wagamula waga Ungulubhi abhahukhome nawe, ulubhuumba lwa bhapishe ichokaa(uloongo). Ukhiye andonje, nahuje ihomwe wenee?” ");
INSERT INTO sbk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhaala bhabhahimiliye nawo bhaga esho shuhuliga ugosi wishibhanza sha Ngulubhi?” ");
INSERT INTO sbk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","U Paulo waga, “munsajile sigaiminye huje gosi neshi shisimbilwe huje usahayanje shibhibhi ugosi wa bhantu bhaho.” ");
INSERT INTO sbk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","U Paulo nawalola huje bhamo bhali na Sadukayo na bhamwabho bhali na Farisayo, wayanga huje ane endi Farisayo mwana wa Farisayo. Eshi esubhila uluzyuho lwa bhafwe na bhahoma husababu iyo nalongwe.” ");
INSERT INTO sbk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nawayanga shila, bhanda adalisanye bheene, ubhungano gwagabhanyiha. ");
INSERT INTO sbk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Abheene aSadukayo bhaiga nalumo uluzyuho, antumi roho, lelo Afarisayo bhahwitiha izyo zyonti. ");
INSERT INTO sbk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ulwumvwano lwabha nalumo asimbi bhabhali na Farisayo, bhaga ate sigati lilolile ibhibhi nalimo hwa muntu unu eshi untumi, nu Mpepo nkayanjile nawo?” ");
INSERT INTO sbk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Uludalisanyo na lwabha lugosi ugosi wikeya wabhatuma abhikeya huje bhamweje u Paulo ahogope huje bhabhahuzembulanje, bhabhakwizya abhikeya huje bhinze, abhikeya bhinza nanali bhamwega u Paulo nahutwale hu ngome. ");
INSERT INTO sbk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nu siku Ugosi wayanga nu Paulo waga uganje hwogope unjanjile hu Yerusalemu eshi ubhanjanje na hu Roma.” ");
INSERT INTO sbk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nahwasha, Ayahudi bhamo bhahitiline bhafinga huje sigatibhaalye wala amwele nkahamo paka tigoje uPaulo. ");
INSERT INTO sbk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bhahali abhantu amalongo gane(40) bhabhahitihine hwizyoo. ");
INSERT INTO sbk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhabhala hwa gosi wishibhanza na bhazee huje tihwibhishile humakhosi sigatilya na mwele paka tibude u Paulo. ");
INSERT INTO sbk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Eshi alonzi bhabhuule ujemedari amweje uPaulo alete palonzi. ate tibhahubude shasile nahwinze epa.” ");
INSERT INTO sbk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lelo umwana wa yilumbu wakwe uPaulo wumvwa zyabhapanjile wabhala mungoma wabhuula uPaulo. ");
INSERT INTO sbk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","U Paulo wakwizya uakida waga twale umwana unu hwa jemedari, alinenongwa ezyayanje. ");
INSERT INTO sbk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","U akida wamwega umwana ula watwala hwa jemedari ugosi wabhuula waga, “u Paulo ula yamufunjile ankwizizye ahanzaga huje iletele, ukijana unu bhashi ali ne nongwa izyahubhuule.” ");
INSERT INTO sbk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ula ujemedari wakhata ukhono wa bhala nawo panshinje, wabhuugya waga nongwa wili zyuhwanza ambuule?” ");
INSERT INTO sbk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ula ukijana waga Ayahudi bhapatine huje bhalaabha awe utwale u Paulo hwibaraza shandao, nu haibhamwidala uhutwala, abhene bhaihumwubhila bhaihubuda uPaulo. ");
INSERT INTO sbk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bhapatine abhantu amalongo gane bhahwipinyile mufinje ulwa mumakhosi huje sigabhabhalye, siga bhabhamwele paka bhabude, eshi awe usahitishe esala ezi bhahugula awe huje uyitishe hutwale.” ");
INSERT INTO sbk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ula ujemedari waleha ula ukijana abhalaje wasunda huje asahabhuula umuntu uwinji huje umbulile ezi.” ");
INSERT INTO sbk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wabhakwizya abhaakida bhabhili wabhalajizya mweje asikari emyazibhili, bhabhale hu Kaisaria na bhala asikari bhabhapanda efarasi amalongo saba, nabhimpalala imya zibhili, mubhasogole nu siku. ");
INSERT INTO sbk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wabhabhuula huje bhaibhishe ifarasi yabhapande uPaulo abhe salama paka hwa Feliki Ugavana. ");
INSERT INTO sbk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Wasimba ikalata yeiga, ");
INSERT INTO sbk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio Lisia hwa Liwali utuntumu u Feliki, ehulamuha. ");
INSERT INTO sbk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Umuntu unu akhiitwe na yahudi bhahandile hubude, nabhala ni puga lya asikari humwokole, nanapata ehabari huje umuntu unu wa hu rumi. ");
INSERT INTO sbk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ihanzaga amanyezyabhakhatiye na hulonje natwala hwibalaza. ");
INSERT INTO sbk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nalola bhahushitaka hu mambo ge sheria zyabho nantele nalimo ikosa elyalongwe huje afwe na fungwe. ");
INSERT INTO sbk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nantele zyamanyiha huje bhali na njama nu Paulo nalola huje ilete huliwe nanali nkabhalinizya hulonje bhalete amshataka huliwe. Bhalagana.” ");
INSERT INTO sbk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bhala asikari bhayeteha endajizyo: bhatwala u Paulo nu siku hu Antipatri. ");
INSERT INTO sbk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Shandabho lwakwe bhabhaleha asikari bhaala bhabhapinde ifarasi bhabhale nawo u Paulo, abhene bhawela hu ngomeni. ");
INSERT INTO sbk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bhaala bhabhapinde efarasi bhafiha ahu Kaisaria, nu Paulo bhapela uliwali ela ekalata bhabhiha u Paulo hwitagalila lyakwe. ");
INSERT INTO sbk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Uliwali pawabhazya ila ikalata wabhuuzya u Paulo afuma lijimbo wili; nawamanya huje afuma hu Kilikia, ");
INSERT INTO sbk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","waga, “Embahutejelezye nkashele bhinza bhabhahushitaki,” watwala hwikulu ya Herode. ");
INSERT INTO sbk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nazyashila ensiku zisanu, Anania ugosi we shibhanza, nazee nu wayanje itawa lyakwe Tertulo, bhabhala pala. Abhantu ebha bhaletila amashitaka gabha hushitaki u Paulo hwa gavana. ");
INSERT INTO sbk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo nawimilila hwa gavana, Tertulo wanda hushitaki nayanje hwa gavana, “ate tilinulutengano nawe uletile enyizya ezyalinganye ensi yetu; ");
INSERT INTO sbk_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","eshi hulusalifyo lwonti tiposhela shila hantu hubhomba, tihuposhela shila hantu hubhomba, tihulamuha, Wugosi Feliki. ");
INSERT INTO sbk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lelo insahalisye, elabha untejelezye enongwa endodo wene. ");
INSERT INTO sbk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Timwajile umuntu unu korofi, yasababisya Ayahudi bhonti bhabhe bhakorofi nasinte nahwumvwanwe munsi. Nantele longozi we mathehebu ga Nazarayo. ");
INSERT INTO sbk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nantele alinjile ananganye eshibhanza shetu, ate takhata ");
INSERT INTO sbk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nkashele ubhuzye uPaulo yuyo ubhamanye zyatishitakiye.” ");
INSERT INTO sbk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayahudi bhope bhashitaki u Paulo, bhaga ezyo zililyoli. ");
INSERT INTO sbk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","U Liwali nawasontela ukhono uPaulo aje ayanje, u Paulo ahagamula, “Ane imenye huje amaha minji uligamulanyi wi taifa eli, nantele ensungwilwe ayanje huliwe. ");
INSERT INTO sbk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ubhajiye ahakikisye wewe huje sigazishilile ensiku ilongo ne zibhili ahwande panabhaliye apuute hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nabhanajile mushibhanza, ane siganadalisinye nu muntu yayonti nantele siganaletile yayonti, nantele siganaletile efujo yayonti mubhungano wala mwisinagogi wala pamuji; ");
INSERT INTO sbk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","na sigabhabhajiye ahakikisye zyabhanshiyakila ane. ");
INSERT INTO sbk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila iyanga ezyelyoli huliwe huje hwidala lila abhene lyabhaiga lidhehebu, hwilyo nane ihubhombela imbombo Ungulubhi waise bhetu. Ane endi mwaminifu hunsimbozye sheria wakuwe. ");
INSERT INTO sbk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Endi nu oujasiri wulawula, abhene wabhangula bhope, uluzyuho lwa bhafwe abinza na bhasigabhinza; ");
INSERT INTO sbk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","hweli ibhomba imbombo iya huje embe nu mwoyo gwasiga gwalongwe hwa Ngulubhi na hwa bhantu ashilile hu mambo gonti. ");
INSERT INTO sbk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Eshi nagashila amaha gaminji ane enenzele alete umusaada hwitaifa lyane ne zawadi eye hela. ");
INSERT INTO sbk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nanabhombaga isho Ayahudi bhabhafumila hu Asia bhanaga musikulukulu ye lwozyo mushibhanza, bila efuj yayonti nantele bila lipuga lyabhantu. ");
INSERT INTO sbk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Abhantu ebha bhahwanziwa aje bhenze epa bhayanje nkashele bhali ne nongwa zyazyonti nane. ");
INSERT INTO sbk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bhayanje bhibho nabhandolile nihimiliye pibaraza lya bhayahudi embibhi zyabhazilolile; ");
INSERT INTO sbk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ila ahantu hamo hamayanjile panahimiliye pahati yabho, najile hunongwa ye luzyuho lwabhafwe mundonga.” ");
INSERT INTO sbk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","U Feliki abhulilwe ahusu idala lila na akhomola ubungano. Waga, “Lisia jemedari nayenza afume hu Yerusalemu ane yaamula amashitaka genyu.” ");
INSERT INTO sbk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Epo wamula huje uakida uPaulo, na huje asahabhe umuntu uwabhakhane aholo bhakwe humwavwe na hujendele. ");
INSERT INTO sbk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ensiku nazyashila, uFeliki wawela nu Drusila ushi wakwe yaahali Muyahudi watuma abhantu hukwizye uPaulo watejelezya enongwa zya lutengano lwalufuma hwa Yesu Kristi. ");
INSERT INTO sbk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","U Paulo nahayagaga nawo amambo ge ulonzi wa Ngulubhi hwa bhantu uFeliki wogopa waga bhalaga nana ipate enafasi naihukwizya nantele.” ");
INSERT INTO sbk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Omuda gwugwo apambamiye huje uPaulo abhahupele ihela, akwizyaga wilawila ayanje nawo. ");
INSERT INTO sbk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Amaha gabhili nagashila u Porkio Festo ahabha Liwali pyanili wa Feliki, u Feliki umwene ahanzaga ahwipendehezye hwa Yahudi, aleshile uPaulo hwa abhlinzi. ");
INSERT INTO sbk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","U Festo winjila hwi jimbo elyo isiku elya tatu abhalile afume hu Kaisaria paka hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ugosi weshibhanza na Yahudi bhaletile amalulumwo hwa Festo, na bhanjile hwikhone hwa Festo. ");
INSERT INTO sbk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bhalabhile uFesto huje uPaulo abhale hu Yerusalemu aje nkaabhabude mwidala. ");
INSERT INTO sbk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lelo uFesto ajile uPaulo afungwilwe hu Kaisaria, lelo umwene ahayinza uhwo nanali. ");
INSERT INTO sbk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ajile “Bhaala bhabhajiye, tibhajenye abhale nabho. Nkashele zihweli embibhi zyazyonti hwe muntu unu mubhajiye hutake.” ");
INSERT INTO sbk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nawakala ensiku nane nezyamwabho wagaluha hu Kaisari. Shandabho yakwe wakhala pitengo elyalonjele wakwizya uPaulo huje ayinze. ");
INSERT INTO sbk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nawafiha, Ayahudi bhabhafumile hu Yerusalemu bhaleta amashitaka amwamu gasigabhabhajiye ahakikisye. ");
INSERT INTO sbk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","U Paulo wahwitetela waga, 'Siga imbombile embibhi hwa Yahudi, hushibhanza hwa Kaisari, siga entulile nahamo.' ");
INSERT INTO sbk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lelo uFesto ahanzaga ahwipendekezye hwa Yahudi wabhuuzya uPaulo huje uhwanzaje tibhale alonjele hu Yerusalemu enongwa ezi?' ");
INSERT INTO sbk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","U Paulo waga ane enemeleye epa pitengo elyalongwe elya Kaisari pehwanziwa alongwe. Sembahoseye Ayahudi, neshi shulolile. ");
INSERT INTO sbk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ane nkashele nihweli zyenkosiye ezyalongwe huje enfwe, sigakhana afwe. Lelo nkanazimo numo umuntu yabhajiye antwale uhwo ehulabha u Kaisari. ' ");
INSERT INTO sbk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","U Festo nawayanga ni baraza waga uhulabha uKaisari; ubhabhale hwa Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nazyashila ensiku zinyinji umfumu u Agripa nu Bernike bhahafihile hu Kaisaria hujendele uFesto. ");
INSERT INTO sbk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nabhakhala ensiku zyenyinji uFesto aletile engongwa zya Paulo hwa mfumu; Waga, 'Umuntu umo alehwilwe epa umuntu unufungwe. ");
INSERT INTO sbk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nihali hu Yerusalemu agosi bheshibhanza nazee bha Yahudi bhaletile enongwa huline na bhabhuuzizya eshalonje enongwa eyo. ");
INSERT INTO sbk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ane nabhabhulile huje siga deestuli yetu hulonje umuntu nu upendelelo, umuntu yalongwa abhane nafasi eyahwitetele hwa bhantu bhabhahulonga. ");
INSERT INTO sbk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nabhahinzile palishimo ana siganagulile, shandabho lwakwe, nahakhiye pitengo elyalonjele nahaga umuntu uyo ayinze muhati. ");
INSERT INTO sbk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bhala bhabhashitakile nabhaletaga amashitaka gabho, nahagaga jibha nagamo amashitaka amagosi gagaletilwe. ");
INSERT INTO sbk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nahalola bhadalisanya nawo, amambo ge dini yabho na mambo ega Yesu ula yafwiye uPaulo yaiga alishamwomi. ");
INSERT INTO sbk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ane napotilwe eshalilonje iswala eli nabhuuzya huje abhajiye abhale hu Yerusalemu huje bhalonjele uhwo enongwa zyabho ezi. ");
INSERT INTO sbk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lelo uPaulo nahaletwa abhihwe pansi ye ulinzi aje ayamule umfumu naga abhihwe paka panaihutwala hwa Kaisari. ' ");
INSERT INTO sbk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","U Agripa ayanjile nu Festo, “huje ingasungwilwe nane huje itejelezye umuntu unu.” U Festo, waga, “uhaihutejelezya shandabho.” ");
INSERT INTO sbk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Shandao lwakwe, uAgripa nu Bernike bhafishile ne shikulukulu sheshinji bhahinzile ne muukumbi nebhiheya na abhogopwe abhe muji. U Festo waga aletwe uPaulo hwibho. ");
INSERT INTO sbk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","U Festo waga, “wee Mfumu na bhantu bhonti bhabhali epa, muhulola umuntu unu ejumuiya yonti eya Yahudi uhwo hu Yerusalemu nepa, bhahwaje embalinganye abheene bhabwaga bhaga afwe sigatihwanza aje akhale. ");
INSERT INTO sbk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ane siga nalilolile elyahuje afwe eshi pepo akwizizye Umfumu ane etwalile hwa mwenee. ");
INSERT INTO sbk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lelo siga endinizyasimbe hwa Mfumu. Ane shi iletile huliwe awe Mfumu Agripa, aje embenazyasimbe munongwa ene. ");
INSERT INTO sbk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","endolile nemo emaana hulete ufungwe nkanongwa ezya hulonjele nazyo. ");
INSERT INTO sbk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","U Agripa wabhuula uPaulo, `Uruhusiwe ahwitetele. 'U Paulo wabhusya ukhono gwakwe wahwitetela. ");
INSERT INTO sbk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ehwilola endi nu luseshelo, wu Mfumu Agripa, alole enongwa yane elongwa nawe hwibha bhabhandonga Ayahudi. ");
INSERT INTO sbk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nantele awe uli taalamu hu destuli zya Ayahudi na maswali eshi elabha untelejezye. ");
INSERT INTO sbk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Lyoli Ayahudi bhaminye shanakhiye afume huwana wane hwitaifa lyane hula hu Yerusalemu. ");
INSERT INTO sbk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bhaminye ahwande hali nantele bhahwanziwa ahwitishe huje ane nali Farisayo, idhahabu lyalili nu msimamo ukhali hu dini yetu. ");
INSERT INTO sbk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Eshi inemeleye epa elongwa hu sababu lulagano lwabhaise bhetu lwabhalagine nu Ngulubhi aliifanya na baba zetu. ");
INSERT INTO sbk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Olulagano olu lwemakabila getu ilongo nazibhili, bhasubhila nkashele bhaihuputa Ungulubhi humwoyo gwonti usiku na pasanya, nongwa yelusubhilo olu Ayahudi bhandonga na nshitaki wu mfumu Agripa. ");
INSERT INTO sbk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Eshi amwe yeenu sigamusibha huje Ungulubhi azyusya abhantu bhabhafwiye? ");
INSERT INTO sbk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Lumo isibha huje ingabhombile zimo hwitawa lya Yesu wa hu Nazareti. ");
INSERT INTO sbk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nabhombile ezi hu Yerusalemu; Nabhafunjile mwijela, nahali ne mamlaka afume hwa gosi bheshibhanza abhombe isho; nabhabhabudaga nabhakhomiye ekura aje bhabudwe. ");
INSERT INTO sbk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nabhapiye eadhabu mumasinagogi gonti nantele nabhasababisizye huje bhakhane ulwitiho lwabho, naali ni lyoyo nabho, nabhabhinjile ata hu jenyi. ");
INSERT INTO sbk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","isho, nabhalile hu Dameski, endi na mamlaka afume hwa gosi bheshibhanza; ");
INSERT INTO sbk_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","nahwabha pasanya, Mfumu, nahalulola ulukhozyo ulukhali ashile ulwisanya, lwahatizyungula tenti. ");
INSERT INTO sbk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tenti tahagwa pansi ane nahumvwa izu lifuma humwanya liyiga Sauli, Sauli! Yeenu uhumvisya? Awe sigaubhajiye apane neteke elimvwa. ");
INSERT INTO sbk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ane nabhuuzya, 'Awe nanu, Ngosi?' Umwene waga, 'Ane ne Yesu wuntesa. ");
INSERT INTO sbk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Eshi imilila na manama gaho; ane embonishe huliwe, isaluye huje ubhe bhomba mbombo wanena, ubhe keti wane hugaala gugalolile na gamwabho gembahulanje pamande; ");
INSERT INTO sbk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ane Embahuhwokole na bhantu, abhantu bha huula hwa Mataifa hwehutuma, ");
INSERT INTO sbk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","bhigushe amaso bhepemunkisi bhenze hulukhozyo bhepe hwikhone lya shetani bhagalushile Ungulubhi; ili bhaposhele uusajile wawe mbibhi na bhaposhele ugaale wembabhishiye bhala bhembasaluye hulwitiho lwaluli huline. ");
INSERT INTO sbk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Eshi, awe mfumu Agripa, ane siga imbajiye akhane embonesyo ezya humwanya, ");
INSERT INTO sbk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","bhaala bhabhli hu Yerusalemu na hunsi yonti eya hu Yudea, na huula hwa bhantu bha mataifa aganji, nabhalumbiliye huje bhabhombe enyinza zyazibhoneha huje bhalambile. ");
INSERT INTO sbk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hwilyo Ayahudi bhahata mushibhanza, bhalinga ambude. ");
INSERT INTO sbk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Eshi Ungulubhi amavwizye paka enfishile epa, eshi ihwimilila nayanje hwa bhantu bhekawaida na hwabhaala agosi ayanje zilazyabhayanjile akuwa nu Musa bhayanjile huje zyaifumila ne siyo eshenje; ");
INSERT INTO sbk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","huje uKilisti ailabha na aibha wa hwande azyushe afume hwa bhafwe na tangazye ulukhozyo hwa Yahudi na hwa bhantu abha mataifa. ");
INSERT INTO sbk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","U Paulo nawamala ahwitetele, u Festo wabhula, 'u Paulo, huje awe ulipelusu embazyo zyaho zibhishile huje ubhe pelusu. ");
INSERT INTO sbk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lelo uPaulo waga ane siga endipelusu ane eyanga ezyelyoli wene. ");
INSERT INTO sbk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Umfumu umwene azimenye ezi; ane eyanga nuwaushe wonti ane emenye huje nalimo lyalyubhile hwamwene ega gonti sigagabhombishe panshenje. ");
INSERT INTO sbk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Eshi awe Mfumu ubhitiha akuwa lelo emenye huje ubhitiha. ' ");
INSERT INTO sbk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","U Agripa wabhuzya uPaulo, 'Sheshi nanali ubhajiye ambishe nanii huje imbe Mkristo? ");
INSERT INTO sbk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","U Paulo waga, “'Ibhesheshi awe patalii ihulaabha Ungulubhi huje amwe mwenti mubhe neshi ane, lelo siga ilaabha huje mupinywe neshi ane na manyoro ga mwijela. ");
INSERT INTO sbk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Umfumu wimilila, nu liwali, nu Bernike na bhamwabho bhonti bhabhali nabho, ");
INSERT INTO sbk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","nabhasogola bhayangana bheene bhaga, 'Umuntu unu sigatulile enongwa zya huje afwe wala afungwe.' ");
INSERT INTO sbk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","U Agripa wabhuula uFesto, “Huje umuntu tenzaga huleshele handasiga akasile ulufaa hwa Kaisari.” ");
INSERT INTO sbk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nabhayanga huje tihwanziwa abhale hu Italia, u Paulo nafungwe bhamwao wapelwa uafisa umo uwishi Roma itawa lyakwe yu Julio, uwipuga lya Agustani. ");
INSERT INTO sbk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tapanda imeli afume hu Adramitamu, yahanziwaga huje ijende munshenje ye pwani ya Asia. Tinjila mubahali. Alistaka afume hu Tesalonike ya hu Makedonia tabhala nawo. ");
INSERT INTO sbk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Isiku elya shandabho lwake tebhiha inaga hu Sidoni, u Julio abhombiye shinza uPaulo waruhusu abhale hwa Kilisti amwabho aje ayeje umusaada. ");
INSERT INTO sbk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Afume ipo tinjila mubahali, tazyungula eshisiwa sha hu Kipro shashazijile ihaala, maana ihaala ngosi. ");
INSERT INTO sbk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Natalola huje tijendile muminzi gagali pipi nahu Kilikia na Pamfilia, tinza hu Mira, muji gwa Lisia. ");
INSERT INTO sbk_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Paala uafisa wikeya eye shi Roma, wa yaanga emeli yayanziwaga abhale hu Italia. Yehafumile hu Alexandria watinjizya umwo. ");
INSERT INTO sbk_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Natalola huje tijendile hashehashe ensiku zinyinji, tafishile na malabha tee hu Kinidas, ihaala yahatiziga huje tisahendelele na shuule hwidala ilyo, tashuula munshinje ye Krete aizije ihaala, apalamane ne Salmone. ");
INSERT INTO sbk_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tashuulile munshinje ya pwani humalabha tee paka tahafiha pamo papahitwaga Fari Haveni yahapalamine ne muji gwa hu Lasi. ");
INSERT INTO sbk_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tashuulile ensiku nyinji tee, umufungo gwa Yahudi gwashilile, eshi yaahali hatari ahwendelele ashuule. U Paulo watisunda, ");
INSERT INTO sbk_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","waga, “Amwe bhalume, elola esafali ene hwatibhalila, eli shibhibhi siyo huje gamazigo ne meli zyene lelo na maisha getu gope. ");
INSERT INTO sbk_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ula uafisa wikeya eyeshi Roma, umwene atejelezyaga umwanisho meli ila, ashile zyazyayangwaga nu Paulo. ");
INSERT INTO sbk_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ebandari yapaala seyalishinza akhale eshipindi eshisasa, bhaala abaharia bashauli bhaga, tishuule shisho tifishe hubandari ya hu Fionike, tikhale paala eshipindi eshisasa, ebandari iyo eli hu Krete, ihwenya nu kaskazini mashariki na hukusini mashariki. ");
INSERT INTO sbk_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ihaala ya hu kusini ihanda avugule wolowolo abaharia bhagajibha bhapite shabhanzaga. Bhefwa engana tanda ashuule munshinji ye Krete apalamane ne pwani. ");
INSERT INTO sbk_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Natashuula hashe wene ihaala ehali yahanda avugule yehetwaga haala ye kaskazini mashariki ihatikhoma afume hwisyela lye shisiwa. ");
INSERT INTO sbk_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Emeli yetu nayapotwa alwe ne haala tenti titihana huje tibhalaje hwibhala ihaala ne meli. ");
INSERT INTO sbk_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ihaala yatishimbizya afume uupande wishisiwa shashazigaga ihaala shashi hwitwa Kauda; taahokola itoli humalabha. ");
INSERT INTO sbk_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nabhaikwesanga emeli ne nyabho, bhahogope huje bhasahabhale hwaguli usanga eshi bhihisya enanga. ");
INSERT INTO sbk_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Edhoruba yahatikhomile tee, bhaala abaharia bhahande ataje amazigo afume mumeli esiku elyabhili. ");
INSERT INTO sbk_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Isiku elya tatu abaharia bhahanda ahwite aminzi na makhono gabho. ");
INSERT INTO sbk_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Isanya ne ntondwe sigazyakhozizye edhoruba yahali halii tee tahwisuula huje eshi tibhala hufwe. ");
INSERT INTO sbk_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Pabhakhala tee muminzi bila shalye, u Paulo wabhabhuula huje mugantejelezizye ane panajile tisahasogole hu Krete, ega gonti handa siga gatajile ne mali ene handa sigatihuusile. ");
INSERT INTO sbk_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Eshi muzinde umwoyo nuumo umuntu yabhafwe, yemeli nyene ibhanajishe. ");
INSERT INTO sbk_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nu siku Ungulubhi atamile untumi wakwe unu Ungulubhi yehupuuta untumi wakwe ahumiliyo pashinji yaane ");
INSERT INTO sbk_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ajile, “Usahogope Paulo. Uhwanziwa ahwimilile hwa Kaisari, enya, ebha bhonti apiiye huje ushuule nabho. ");
INSERT INTO sbk_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Eshi amwe bhalume jinjili umwoyo zyonti zibhabhe neshi shambuulile Ungulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lelo tibhavwalale natibhashile huvisiwa.” ");
INSERT INTO sbk_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nawafiha usiku wilongo nazine, natazyungulaga ohu nu hwo mubhahari ye Adratik, nusiku wa pahati, abhabahana bhasibhile huje kabhanga tipalamiafishe hunsi enyomu. ");
INSERT INTO sbk_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bhapima idimine biligi bhazyaga emita amalongo gatatu ne tanda, tabhala hwitagalila hashe bhapima nantele bhazyaga emita amalongo gabhili na saba. ");
INSERT INTO sbk_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bhahogope huje bhagabumizya emeli mwilyalawe, bhiisya enanga zine afume pabhahwisizya enanga, bhahalabhaga huje hushe nanali. ");
INSERT INTO sbk_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bhaala abaharia bhahanzaga idala lya ileshe emeli, aje bhiisye utuboti utwa hwokolele abhantu, bhafwana huje bhalwa ahwisye enange hwitagalila lye tuboti. ");
INSERT INTO sbk_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","U Paulo wabhabhuula asikari, “Huje siga mubhajiye ahwokoshe muhwanziwa asagale mwamumeli.” ");
INSERT INTO sbk_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bhaala asikali bhadumula inyabho ezye boti, bhailaha ebhala na minzi. ");
INSERT INTO sbk_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Shampwitu isanya nalitukula uPaulo wabhabhuula abhantu huje bhalye ishalye waga eli lisiku lya ilongo na zine nalye nkahamoo. ");
INSERT INTO sbk_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Eshi eji ishaalye shishe mulye, aje musahafwe ane enjiga hata hasisi ha mwitwe lyanyu sigahabhateje. ");
INSERT INTO sbk_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","U Paulo nawayanga wega ibumunda wamensula wapuutila wanda alye. ");
INSERT INTO sbk_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Abhantu bonti bhasungwa bhope bhega ishalye. ");
INSERT INTO sbk_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tahali abhantu emia zibhili na malongo saba, ni tanda 276 mu meli. ");
INSERT INTO sbk_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nabhalye bhakuta bhatega engano muminzi, imeli ihabha mpoposu. ");
INSERT INTO sbk_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nahwasha, sigabhapaminye pabhahali bhailola ensi yeinjiye muminzi eli nu sanga gugwinji. Bhajadililana aje nkashele bhabhajilye ajenzye emeli aitwale pala. ");
INSERT INTO sbk_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bhazilejezya enanga bhazileha mubahari. Umuda gwugwo bhazilejezya inyabho ezye tanga, bhabhusya hwitagalila ahwenyezye hwefuma ihaala, bhabhala hula hwaguli usanga gwugwinji. ");
INSERT INTO sbk_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bhafiha pagatanganila amadila ge menze, emeli yabhala musanga yakwama(yamilia) yasinta ahwepe hwitagalila emeli yaande abudushe amawimbi gaali magosi. ");
INSERT INTO sbk_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asikari bhaala bhaali nu mpango ugwabhabude afungwe bhonti aje bhasahatoloshe. ");
INSERT INTO sbk_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ula usikari weshi Roma ahanzaga humwokole uPaulo, wabhakhaana bhaala asikari nu mpango gwabo; na wabhabhuula abhantu huje yaminye ahwonjelele aluhanje afume mumeli ayojelelaje abhale hunsi inyomu. ");
INSERT INTO sbk_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Esho alume bhamo bhabhafuate, bhamobhamo muvipande pa vintu evyenje evya mumeli natibhabhombe eshi tenti tibhapone, tibhafishe shinza hunsi inyomu. ");
INSERT INTO sbk_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Natafiha shinza tamanya huje tili hushisiwa shashihwitwa Malta. ");
INSERT INTO sbk_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Akhaaya bha paala bhaali bhinza, bhatipiye ishalye, bhatipembiye nu mwoto tahotile umwoto maana isasa ne mvula ya hali nyinji. ");
INSERT INTO sbk_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lelo u Paulo aletile izigo lye nkwi nawabhiha mumwoto, inzuha yesumu yafuma munkwi yahwizinga mukhono gwa Paulo. ");
INSERT INTO sbk_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Akhaaya nabhalola inzoha ilembeela mukhono gwa Paulo bhaga umuntu unu alije nyambuda yeenu inzoha ifwatile. ");
INSERT INTO sbk_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Umwene uPaulo waikunyuntila mumwoto siga apite abhabhwe paponti. ");
INSERT INTO sbk_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Abheene bhagaga jibha abhavimbe au abhagwe nafwe nabhaakhala hahinji bhahwega sangunduha nantele sigaa vwaliye napamo pamande bhaga unu ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ugosi wi shisiwa shatahali watikaribisya akhaya yakwe, atipiye ishalye eshensiku zitatu. ");
INSERT INTO sbk_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Uise wa Pablio, u Pablio ugosi wishisiwa ahabhina. U Paulo wapuutila nabhiishe amakhono gakwe pitwe uise wa Pablio wapona. ");
INSERT INTO sbk_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nalyafumila lila abhantu bhabhali na bhinu bhabhalete abhinu bhabho hwa Paulo bhonti bhapona. ");
INSERT INTO sbk_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Abhantu bhatitiniha entiniho ingosi natahanzaga asogole bhatibiye evyalye vya vinji. ");
INSERT INTO sbk_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nagashila amezi gatatu taashulile ne meli ya Iskanda emeli eyo ihakhomwilwe ni sasa pashisiwa paala alongozi bhe meli eyo bhaali mapasa bhabhili. ");
INSERT INTO sbk_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Natafiha hu Sirakusa, tahakhiye ipo ensiku zitatu. ");
INSERT INTO sbk_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Afume ipo tafiha hu Regio. Nalyashila isiku limo ihaala iyahu kusini yahavugula, nazyafiha ensiku zibhili tafiha hu Putoli. ");
INSERT INTO sbk_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Uhwo tabhajile aholo bhetu, bhaatikaribisizye tikhale nabo ensiku saba, hwidala eli tafiha hu Rumi. ");
INSERT INTO sbk_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Afume uhwo bhaala aholo habhuumvwa ihabari zyetu bhahinzile atejelela uhwo husokoni ya Apias na hu Hoteli zitatu. U Paulo na wabhalola bhaala aholo asungwilwe tee agwizizye umwoyo. ");
INSERT INTO sbk_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Natafiha hu Roma, uPaulo aluhusiwe akhala mwene nu sikali yalindaga. ");
INSERT INTO sbk_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nazyashile ensiku zitatu, uPaulo wabhakwizya, alume bhabhaali bhalongozi hwa Yahudi. Nabhinza ahaga pamoja huje siga entulile na hamo hwa bhantu ebha, na huje embombile shenje ne taratibu zyaise bhetu bhabhatitagaliye hu Yerusalemu hadi ohu humakhono ga Bharumi. ");
INSERT INTO sbk_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nabhambuzya bhahaziliha andeshele wene, sigabhailolile esababu yehwanziwaje ane endongwe afwe. ");
INSERT INTO sbk_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lelo Ayahudi nabhayanjile eshenje ane nalazimishe akate ulufaa hwa Kaisaria, lelo siyo nailetaga mashata ensi yaane, au itaifa lyane. ");
INSERT INTO sbk_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Aje enkete elufaa, ndiyo maana embakwizizye aje injanje namwe, aje aIsraeli alinuujasiri zyabhanfunjila. ");
INSERT INTO sbk_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Abheene bhaga sigatiwahile aposhele ekalata yayonti yefumile hu Yudea yehuyanga awe nantele nuumo umuntu yayonti yatilitiye enongwa zyaho. ");
INSERT INTO sbk_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Eshi tihwanzaje tumvwe afume huliwe ahusu ikundi lya bhantu ebha bhabhayanga shenje shila mahali. ");
INSERT INTO sbk_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nabhalibhaguye isiku elyayanje nawo, abhantu bhinji tee bhahinzile pakhalaga. Ayanjile lila lyabhafunjiye na yanje ezye uumfumu uwa humwanya, alinjile abhabhuule zyazihusu uYesu humadala gonti gabhili hu sheria ya Musa, na hwakuwe, ahwande shampwiti paka andyabhela. ");
INSERT INTO sbk_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bhamo bhahitiha bhamo bhahakhana. ");
INSERT INTO sbk_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nabhapotwa ahwitihane bheene, bhahasogola u Paulo nahayanga ijambo limo, Umpepo Ufinjile ayanjile ashilile wakuwe uIsaya hwaise bhetu. ");
INSERT INTO sbk_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ubhale hwa bhantu ebha uje, whwumvwe mubhahumvwe humakutu genyu, lelo sigamubhazimanyihanye nazimo; Na humaso genyu mubhahwenye lelo sigamubhahwelewe. ");
INSERT INTO sbk_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Hwa moyo gabhantu abha mamwamu, amakutu gabho segahumvwa shinza na masogolo gabho segahumvwa shinza na maso gabho; gazijile seegalola aje bhasahalole humaso gabho bhatambule, na hwumvwe humakutu gabho, bhelewa na hugalushile ungulubhi abhaponie.”' ");
INSERT INTO sbk_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Eshi mumanyaje huje ou uwokovu wubhalile hwa bhantu abha Mataifa, ebho bhabhatejelezye na hwitishe.” ");
INSERT INTO sbk_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","U Paulo akhiye munyumba yakwe ya panjile humaha gabhili, abhakaribizizye bhonti bhabhahinzaga hwamwene. ");
INSERT INTO sbk_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Alumbililaga uufumu wa Ngulubhi na manyizye amambo ga Yesu Kilisti Ugosi wetu hwikhone lyonti nantele nuumo umuntu uwahukhane. ");
INSERT INTO sbk_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","O Paulo, otumwi owa Yesu Kilisiti, yakwiziwe abhe tumi, nabagulwe hu ndommbelelo ezya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Eene yayela endombelelo ya yiyanjile huhale ashilile hwakuwa bhakwe hunsimbo enza. ");
INSERT INTO sbk_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Huje Omwana wakwe, yapepwe afumehushi kholo sha Daudi hwidala lwembile. ");
INSERT INTO sbk_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Omwene atangaziwe aje Mwana wa Ngolobhe hunguvu Ofijili omwinza hu zyoho olwabhafwe, uYesu oKilisiti Ogosi wetu. ");
INSERT INTO sbk_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ashilile omwene tambilile owene netumi ezyeshishi enyinza hwabhala bhasebha puta bhoti hwitawa lyakwe. ");
INSERT INTO sbk_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Huje bhasebhaputa ebha, namwe nantele mukwiziwe abhe bha Yesu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ebaluwa ene eli hwa bhantu bhonti bhabhali hu Lumi, aganwe no Ngolobhe, bhakwiziwe abhe wene ewene ebhehulimwe. Nowiza afume ha Ngolobhe Obaba wetu Ogosi oYesu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nantele, ehesovya Ongolobhe wane ashilile oYesu Kilisiti hulimwe mweti hubhe owinza wenyu, enongwa ziyangwa esi yoti. ");
INSERT INTO sbk_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nantele Ongolobhe shaidi wane, wehubhe mbela hu mwoyo gwane hu ndombelelo zya Mwana wakwe she dela abhasumule. ");
INSERT INTO sbk_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nantele elabha huje emputo zyane aje hwidala lwalwoti emanye omwisho wakwe abhe namiji eshi hulugano olwa Ngolobhe abheze bhenyu. ");
INSERT INTO sbk_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nantele esongwa abhalole, nkembapele nashi amwenyubha bhonti endole syo ezyefijili emanye abhakhazyeshinza. ");
INSERT INTO sbk_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yani, ehwenyezye azizwe omwoyo mwenti namwe hunyiza ezya weka owetu, agenyu nagalini. ");
INSERT INTO sbk_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Eshi mwaholo, sagehwanza mukose amanye aje, hinji ede njela ahwenze hulimwi, lakini ezijilwe nantele eshi ananzaga aje mubhenama dondolo hulimwena shisehweli hwa bhantu bha sebhaputa. ");
INSERT INTO sbk_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Edaiwa na Yunani na jenyi nantele, na sovunalema. ");
INSERT INTO sbk_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Huje hulini, ane endihani ayanje endombelelo hulimwe mwali hu Loma. ");
INSERT INTO sbk_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nantele saga enzilolela esoni edombelelo huje uwezo wa Ngolobhe wauta owaule hwa yayoti yahweteha, ha Muyahudi kwanza na kwa Muyunani nantele. ");
INSERT INTO sbk_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Nantele enyiza zyazyonti ezya Ngolobhe zibhoneshe afume hunyinza nenyiza, “Owenyiza adela hunyiza.” ");
INSERT INTO sbk_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nantele ilyoyo elya Ngolobhe lilipazelu afume humwanya humbibhi ba bhibhi woti owatu, waufisa eyoli. ");
INSERT INTO sbk_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ene huje goti gagali gabho neha hwa Ngolobhe galipazelu hwa bhena huje Ongolobhe abha lanjile. ");
INSERT INTO sbk_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Huje enongwa zyakwe ziganje abhoneshe shinza gali pazelu ahwande sayabhombwelwe esi. Gabhonehana ashilile huvitu huvitu vyavibhombwelwe. Enongwa ezi zili hunguvu zyakwe ezye siku zyoti asili eyeshi ngolobhe. Afume hwakwe, abhutu ebha sagabhaulwe. ");
INSERT INTO sbk_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ene huje, hata bhamenye huje Ongolobhe, subhatutumuye aje Ngolobhe, nantele sagabhapiye ensalifyo. Nantele aje bhali bhapambafu ashele husebho zyabho, na moyo gabho ageshilema gali mukisi. ");
INSERT INTO sbk_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bhahwibhushele aje bhasovu, nantele bha bhalema. ");
INSERT INTO sbk_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bhagalu zenye otuntu musu wa Ngolobhe asagali mamabhibhi nashi hushifwani esha bhantu bhabhali nembibhi, nashi enyonyi ehanu zyazili namagaya gane evya mwabho evibhombe vyavijendala evyanda. ");
INSERT INTO sbk_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nantele Ongolobhi abhaleshile bhalondole idala elwe nyonyo zya moyo gabho hu chafu, humbele yabho hu gakenyesya hwa mwabho. ");
INSERT INTO sbk_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bhebho bhaigaluzenye elyoli ya Ngolobhe abhelilenga. Lyabhaliputanga navi tumishile elanganyo bhaleshile Yabhombi, yasombwa esikuzyonti. Amina. ");
INSERT INTO sbk_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nantele eshi, Ongolobhe abhaleshile bhalondole enyonyo zyabho ezye nsoni, hwahubhe abhashe bhabho bhagalulenye amabhombelo gabho ageshikulilo gala gagaloleha shinguga neshikulile. ");
INSERT INTO sbk_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bhope, alume nantele bhaleshile embumbelo ezyeshi kulilo hwa bhashe nabhene nyonyo zyabho bhene. Ebha bhali bhalume bhabha bhombile nalume amwabho gaseganaziwaga, na bhabha hambilila evisyo zyazya hanzilwe humbibhi zyabho. ");
INSERT INTO sbk_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nantele bhakhanile abhe no Ngolobhe hunjele zyabho, abhale shila bhale hunjele zyabho, hwanziwa azibhombele embombo zila zyasezi hwanziwa. ");
INSERT INTO sbk_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bhamemile embibhi bhoti, obhibhi, ne nyonyo no bhibhi. Bhamemile wivu, ogoji, ibho, akhopele na husebhele embibhi. ");
INSERT INTO sbk_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bhope nantele bhanalibho, abhomezi, navililwe Ongolobhi. Bhali na vulungu, neshi bhuli, nahwivune. Abhene bhahwada amabhibhi bhase bhaneshishi hwaisebhabho. ");
INSERT INTO sbk_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Abhene sagabhali nenjele; bhasebha hwaminihwa, sebhanaminza ageshikulilo sagali bhali nensajilo. ");
INSERT INTO sbk_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bhahwelewa ekanuni ezya Ngolobhi, nantele aje abhatu bhabhomba nashiego bhahwanziwa afwe nantele saga bhabhomba ego. Abhene bhahwetehana na bhala bhabha bhomba embombo ezwo. ");
INSERT INTO sbk_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nantele sagauhwiuzizye, awe wologa eshi hwagala golonga owenje ahwibheshele mnyobho mnyabho mwene. Huje awe wolonga obhomba enongwa zizila. ");
INSERT INTO sbk_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nantele timenye huje olonzi owa Ngolobhe welyoli hwa bhala bhabha bhomba aminza gabho. ");
INSERT INTO sbk_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Eshi awe sebha eli wolongo bhala bhabha bhomba enongwa nashi ezye nawe obhomba embombo zyezyo. Eshi obhohwiyefwe hulonzi wa Ngolobhe? ");
INSERT INTO sbk_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Huje osebha hashesana huwiji we winza wakwe, akhabhile humayemba gakwe naji mbizye hwakwe? Eshi saga omenye aje owinza wakwe uhwanzi wa hulanganyizye hu ndambo? ");
INSERT INTO sbk_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nantele shohweli okhome wemwoyo gwaho ogaje lole edambo ohibhishela wewe eshanga eshemayemba hwisikulila elyemaye mba, nantele, isiku lila elye kwinkule owelenzi owelyoli wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Omwene aihuposhezya kila mtu eshipimilo eshalengane ne mbombo zyakwe: ");
INSERT INTO sbk_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","hwa bhala bhabhali lyoli hu mbombo enyinza nanganyishe bhaibhapela owomi wewilawila. ");
INSERT INTO sbk_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nantele hwabhala bhali bhene, bhaseyogopa elyoli nantele bhayogopa ezuluma, ilyoyo nekuni ehali ehainya. ");
INSERT INTO sbk_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ongolobhe aitaleta etabu na malabha hu kila nafusi zya bhatu yabhombila amabhibhi, hwa Muyahudi owahwande no Muyunani nantele. ");
INSERT INTO sbk_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Eshi ensombo, neshishi no winza waihwenza kwa shila mtu yabhomba enyinza, hwa Muyahudi hwande na hwa Muyunani nantele. ");
INSERT INTO sbk_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Huje nahumo apendelele hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Huje nashi abhinji bhabhalulila pasepali ne shelia bhanzateje pasepali ne shelia, nantele nashi abhinji bhabhatulile alengane ne shelia bhailongwa hu shelia. ");
INSERT INTO sbk_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Huje sebhahovwa edajizyo bhali nelyoli hwitagalila lwa Ngolobhe, nantele bhabhala bhabhaibhomba edajizyo bhaibhaziwa hu haki. ");
INSERT INTO sbk_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Huje abhatu bhase Bhaputa bhaseli nedajizyo, bhabhomba hushikalilo embombo ezye ndajizyo zyabho, bhagalushe ndajizyo humoyo gabho, nantele abhene sagabhali nedajizyo. ");
INSERT INTO sbk_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Hweli balolesya aje embombo zyazi hwanziwa hu mijibu owe ndajizyo zisimbwilwe muhati mmoyo gabho. Ezamili zyabho zisumula aje, ne jele zyabho bhibho aje bhashitakiwa au zibhalinda abhene bhebho ");
INSERT INTO sbk_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","nantele hwa Ngolobhe. Ega gafumila hwi siku elya Ongolobhe paizilonga esili ezya bhatu bhoti, sawasawa nedombelelo zyane, hwi tawa elya Yesu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tiyanje aje ohwikwizya wewe Muyahudi, yakheye yu dajizyo, shima ahwisombe hwa Ngolobhe, ");
INSERT INTO sbk_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","manya ogane wakwe, na genye gala gase gabhalilana nago, baada yala jiziwenendajizyo. ");
INSERT INTO sbk_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Eshi tiyanye aje olijivi wewe hu mwenee olilongozi wabhasebhalola apazelu hwabhala bhabahli hukisi, ");
INSERT INTO sbk_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","yasahihiswa alema, omwalimu wabhana nahuje oliyo huje edajizyo ezyemanyizu awe lyoli. ");
INSERT INTO sbk_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Awe basi, wuhugajila aweje, sahwimanyizya wewe? Wulombelela aje mugaje hwibhe awe sohwibha? ");
INSERT INTO sbk_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Awe oiga, muganjebhebhegu? Awe, wovitwa eshilolesyo eshi, ohwibha mwi kanisa? ");
INSERT INTO sbk_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Awe wohwisovya hu ndajizyo, eshi sokenyensyewa na Ngolobhe huje onagenye endajizyo? ");
INSERT INTO sbk_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Hwa huje “itawa elya Ngolobhe likenyesewa hwa bhatu bhasebhaputa ashile hulimwe,” nashisesibwilwe. ");
INSERT INTO sbk_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Awe atahilwe lyoli shinza nkoyogope edajizyo nantele nkashile awe oligalugalu wedajizyo, atahilwe hwaho hubhaje sotahiliwe. ");
INSERT INTO sbk_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Eshi, nkashele, omtu yasagatahilwe ahwendelela akhate amazu age dajizyo, eshi asintetahiliwe kwakwe sehwaiye jelwa huje atahiliwe? ");
INSERT INTO sbk_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Wope yasatahiliwe hushikulilo sagadahulonje nkashele abhatimizye edajizyo? Ene hwa huje olinesimbo zyazisimbwilwe ne tohala huje osele ali galuhani hudajizyo! ");
INSERT INTO sbk_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nantele omwene saga Muyahudi yali huhali eya hwonze; hubhe hutahilwe sagahwahula wahuli hwahwonze wene hu humbele. ");
INSERT INTO sbk_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nantele omwene Muyahudi yalimhati, ne tohala eyaha muvoyo, hu fijili. Saga hunsimbo esombo ezya mtu owe sho sagafumila hwa bhatu gafuma hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Huja faida wele yalinayo o Muyahudi? Nantele efaida gatalilwe yenuu? ");
INSERT INTO sbk_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Shinza sana hwidala. Hwaga goti, Ayahudi bha hambilila okwi kule afume hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Eshi, ebhabhe wiele nkashele bhamo bhamo sagabhali no winza huje asinte hweteshele hwabhene hubhalenganye owinza wa Ngolobhe aje mbibhi? ");
INSERT INTO sbk_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ha aa. Nantele hwakwe, leshe Ongolobhe abhoneshe aje lyoli hatankashile kila mtu ali ni lenga. Afume shayahali yasimbwilwe, “Huja awezye abhoneshe aje omwene alinehaki hunongwa zyaho, aje owezye ashi dane potoha hulonzi.” ");
INSERT INTO sbk_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nantele nkashile obhibhi wetu ulanga elyoli ya Ngolobhe, tiyanje yenu? Ongolobhe saga mwalangani pafumya ilyoyo lyakwe, huje ali esho? Eyanga alengane ne nongwa ezya bhantu. ");
INSERT INTO sbk_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ha aa! Shabha wele Ongolobhe aiilonga esi? ");
INSERT INTO sbk_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nantele nkashile lyoli eya Ngolobhe ashilile hwile ga lyane efumya esombo zinyiji hwa mwene, yenu nkashele esele elongwa nashi yali nembibhi? ");
INSERT INTO sbk_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yenu tisiyanje, aje bhatandile wena nashi abhaje bhabhabhoneha aje bhayanga, “Tibhombe ebibhi ili aminza genze”? Olonzi hubhene we lyoli. ");
INSERT INTO sbk_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yenu eshii? Tilamba tibhene? Nemo kabisa. Hwa huje ate tayali tibhadiye Ayahudi na Yunani bhoti pamoja, aje bhali pasi ye mbibhi. ");
INSERT INTO sbk_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Eli nashi salisimbwilwe: “Nomo yali ne haki hata omo. ");
INSERT INTO sbk_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nomo omtu yali ahwelewa. Nomo omtu gahamwanza Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bhoti bhagalushe. Bhene hwa bhoti bhali sebhane maana. Nomo yabhomba aminza, la, hata omo. ");
INSERT INTO sbk_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Amakhalo gabho nkonywayeli nyazi. Emele zyabho zikhopelwe. Esumu eyenzoha eli mmalomu gabho. ");
INSERT INTO sbk_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Amalomu gabho gamemile oyejelo no bhawe. ");
INSERT INTO sbk_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Amanama gabho gashebela ahwite edanda. ");
INSERT INTO sbk_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Onankanye na mayemba gahweli ashilile mwidala lyabho. ");
INSERT INTO sbk_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Abhatu ebha sagabhali menye idala ilinza. ");
INSERT INTO sbk_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Sagabhali nowaga wo Ngolobhe hwitagalila lye maso gawo.” ");
INSERT INTO sbk_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Eeshi limenyu huje hahonti edajizyo naziyanga eyangana bhala bhabhali pasi pendajizyo. Eshi hubhe shila lilomu limimanywe, nantele huje esi yoti eweze aajibishe hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Eshi huje nagumo obele ngwa gwa bhaziwa lyoli hu mbombo eye ndajizyo hwitangalila hu maso gawe. Hwa huje ashele ne endajizyo zihwenza enjele ezebibhi. ");
INSERT INTO sbk_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Huje eshi bila yendajizyo, ehaki ya Ngolobhe emanyisho. Eyajilwe hudajizyo ezyakuva, ");
INSERT INTO sbk_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","eyo haki ya Ngolobhe, ashele enyinza ezwa Yesu Kilisiti hwa bhala bhoti bhabha humweteha. Mana nemo tofauti. ");
INSERT INTO sbk_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Hwa huje bhoti mbile embibhi napongoshelwe na tutumu wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bhabhaziwe ehaki eyewene huwene wakwe huje hwidala elye fwozi wali ashilile Kilisiti oYesu. ");
INSERT INTO sbk_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Huje nantele Ongolobhe afumizye oKilisiti oYesu abhe patanyi hwidala elinza ashele hu danda yakwe. Afumizye oKilisiti abhe shahidi owe haki yakwe huje azileshe owehaki yakwe huje azileshe embibhi zyazishelelile ");
INSERT INTO sbk_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","aje ajimbizye hwakwe. Ega gonti gafumiye alolosye ehaki yakwe husiku ezyeshi eli lyali aje bhahwibheshe pazelu yoyo abhe haki, na lanje aje hubhazizye elyoli omtu yayoti hu nyinza shelele oYesu. ");
INSERT INTO sbk_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Huli hwi ahwisavye? Hubagulwe humusingi gwalihuu? Omusingi gwe mbombo? Adii, eshi omusingi ogwe nyinza. ");
INSERT INTO sbk_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Eshi timalezya aje omtu abhaziwa elyoli hu nyiza pase pali nembombo ezye ndajizyo. ");
INSERT INTO sbk_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Aje Ongolobhe huje Ngolobhe wa Yahudi bhene? Eshi omwene saga Ngolobhe woti bhase Bhaputa bhope? Ena, bhase bhaputa bhope. ");
INSERT INTO sbk_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Nkashile lyoli Ongolobhe ali omo, aibha bhazizya elyoli bha bhali bhelohala enyinza, nabhasebhatahilwe hwidala elye nyinza. ");
INSERT INTO sbk_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Aje ate uyu galulenye edajizyo hunyinza ndali eshingu eshego ate tizibheshele pazelu endajizyo. ");
INSERT INTO sbk_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Taiganga hwele nantele huje o Ibulahimu, yise wetu hwidala elye bele, apatihene? ");
INSERT INTO sbk_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nantele nkashele u Ibulahimu abhaziwa elyoli hu mbombo, hangali nenangwa ezyahwisovye, nantele saga hwitagalila lya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Eshi ensimbo zigawele? “Abulahamu amwetesheye Ongolobhe, na bhaziwe hwakwe huje alinelyoli.” ");
INSERT INTO sbk_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Eshi hwa mtu yawombe embombo eposhenzi zyakwe sezibhaziwa huje hee wenee, hwa huje eshi lideni. ");
INSERT INTO sbk_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nantele hwa mtu yasaga abhomba embombo nkashele ahumweteha omwene yali ahubhazizya elyoli yasagali bhatamu, enyinza zyakwe umtu oyo zibhaziwe huje lyoli. ");
INSERT INTO sbk_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","O Daudi wope ayanga esalifyo hwa mtu yali Ongolobhe abhazizizye elyoli pasepali nembombo. ");
INSERT INTO sbk_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ayajile, “Bhasalifiwe bhala bhabhali embibhi zyabho zisajilwe nabhala abhezambe zyabho zyazikwishilwe. ");
INSERT INTO sbk_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Asalifiwe omtu ola nkashele Ogosi sabhazizizye ezambe.” ");
INSERT INTO sbk_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Eshi huje ensalifyo zyabhala bhabhatahiliwe bhene, huje nabha sebhatahiliwe? Eshi tiyanga, “huje o Ibulahimu enyinza zyakwe zyabhaziwe huje lyoli.” ");
INSERT INTO sbk_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Huje yabhaweweleshi? Shila o Ibulahimu ali hu tohala, nantele sasele atahilwe? Sagayali hu tahilwe, eshi ashele tahilwe. ");
INSERT INTO sbk_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","O Ibulahimu ahambilile ehalama yatahilwe. Ogu gwali muhuli gwela ehaki enyinza yalinayo hani sasele atahilwe. Efumizyo ezyandolesyo ene huja abhombeshe abhe baba wa bhoti bhabhahweteha. Atankashile bhahweli bhabhali atahilwe. Eshi hwahuje ehaki yaibhaziwa hwabhene. ");
INSERT INTO sbk_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ene yope yamisizye aje o Ibulahimu abhombeshe baba we tohala saga hwabhala bhabhafumila mutohala aje nabhala bhabhazilondola enyayo zya baba wetu o Ibulahimu. Huje ene nyinza yalinayo hwabhatahilwe. ");
INSERT INTO sbk_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Hwa huje sanayahali hudajizyo aje eahadi ehafumiziwe hwa Ibulahimu ne papo yakwe, eahadi ene eyaje bhaibhabhagali bhesi huje ehaliashelenle ehaki eyenyinza. ");
INSERT INTO sbk_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Huje eshi nashi bhala bhe ndajizyo huje bhagali, enyinzizili nahamo, ne ahadi egalu zenywe. ");
INSERT INTO sbk_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Huje eshi edajizyo zileta ilyoyo, huje pala pasepali nedajizyo, nahumo huje huli eshishi. ");
INSERT INTO sbk_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Hwa huje eli sagalyafumie hunyinza, aje ebheye wene. Amafumilo gakwe, eahadi elipazelu hu mpapo yoti. Na zawa ebha sagaje bhala bhabhamenye edajizyo, huje bhala bhali nenza ezya Ibulahimu. Huje omwene isewetu ate tenti, ");
INSERT INTO sbk_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","nashi sesibwilweli, “Ebheshele awe abhe baba wensi enyiji.” O Ibulahimu ali hweli hwola ya menye yaani Ongolobhe yasaga abhapiye abhafwe owomi na kwizye enongwa zyanazimo ajezibhe. ");
INSERT INTO sbk_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Hata zibhe zyoti zya hwoze, Abulahamu abhejivi amawaminiye Ongolobhe hu siku zyazihwenza. Eshi abha baba wesi enyinji alengane nahala hahagajilwe,”... Esho shayaibha empapo yaho.” ");
INSERT INTO sbk_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Omwene sagali bhinu hunyinza. Abulahamu aheteshe aje obele gwakwe yoyoo gumalishe afwe - ali no umuli wesiku amaha emia emo. Nantele ahetehene nehali eyafwe eyevyanda uya Sala. ");
INSERT INTO sbk_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Eshi alengane ne ahadi eya Ngolobhe, o Ibulahimu sagasitile ahumweteshe. Nantele, apewilwe eguvu hunyinza nantele asombele Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ali amenye loli aje hala hahali Ongolobhe haaidiye ali nouwezo owa hakamilisye. ");
INSERT INTO sbk_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Hweli lyope lyabhaziwe humwene abha haki. ");
INSERT INTO sbk_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Eshi sagayasimbwilwe wene hufaida yakwe, aje yabhaziwe hwa mwene. ");
INSERT INTO sbk_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Yasimbwilwe huliti nantele, hwa bhabhishewe abhaziwe atetatili tihweteha aje omwene azyozyeze Ogosi wetu oYesu afume hwa bhafwe. ");
INSERT INTO sbk_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ono yayola yalifumiziwe hu mbibhi zetu nazyosewe aje tipate abhaziwe ehaki. ");
INSERT INTO sbk_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Hwa hubhe tibhaziwe ehaki hwidala eleyeminza, tili nitumaini no Ngolobhe hwidala lya Gosi wetu oYesu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ashelile omwene nate eshitili nefulusa hwidala wauli muhati mwa mwene tihwemelela. Tishima hujivi watipela Ongolobhe hwaajili yapamade, ojivi owo taishiliki huu tatumusi wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Saga eli tu, huje eshi tishima humayemba getu. Timenye huje amayemba gapapa ovumilizu. ");
INSERT INTO sbk_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ovumilizu papa ahwetehwe, na ahwetehwe papa ojivi hujili yapamande. ");
INSERT INTO sbk_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ojivi sagauli nenvubhi, huje ogano olwa Ngolobhe lwitilwe hu moyo getu ashelile Ofijili Omwinza, yali afumiziwe huliti. ");
INSERT INTO sbk_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Hwatali tilibhabhinu, husiku zila oKilisiti afwiye hwajili yabhibhi. ");
INSERT INTO sbk_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Hwa huje pakhome omo afwe hwajili ya mtu yali nehaki eshi huje. Pamo omtu alenje afwe hwajili ya mtu omwinza. ");
INSERT INTO sbk_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nantele Ongolobhe ahakikisizye olugano lwakwe yuyo huliti, huje lala patali tili nezambe, oKilisiti afwiye hwaajili yetu. ");
INSERT INTO sbk_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Eshi zaidi yagoti, eshi hwahubhe tibhaziwe ehaki hu danda yakwe, tibhafwolwe hweyo afume hwi lyoyo lyo Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Hwa huje, lula patali tizile netapanyiziwe no Ngolobhe hwidala elyafwe omwana wakwe tee nantele palitiliti malishe apatanisiwe, taifiolwa hunsiki zyakwe. ");
INSERT INTO sbk_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Saga esho tu, nantele limo ga hwa Ngolobhe ashilile Ogosi oYesu Kilisiti, ashilile omwene aje eshi tambiliye akondanyo ogu. ");
INSERT INTO sbk_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Eshi basi, nkashile ashilile hwa mtu omo embibhi zyahenzele hwidala eli efwa ehenzele hwidala elye mbibhi. Nantele afwa hwanyampa na hwatu woti, huje bhoti bhabhombile embibhi. ");
INSERT INTO sbk_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Hwa hubhe huje edajizyo, embibhi zyali msi, eshi embibhi sagazibhaziwa nkashele nemo edajizyo. ");
INSERT INTO sbk_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Hata eshi, afwa hwatabhalile afume Ahadamu no Musa, hata hwabhala bhasebhabhombile mbibhi nashi asitebhe neshishi hwa Hadamu, yalishilolesyo esha mwene yahenzaga. ");
INSERT INTO sbk_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nantele hata eshi, opezi owewe ne sagaje hutule nkashele atule limo bhiji bhabhafwiye nantele sana owene owa Ngolobhe pezi owene hwantu omo, oYesu Kilisiti, ezidile ahwanjelele hwa bhiji. ");
INSERT INTO sbk_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Hwa hubhe opezi sagaguli nashi efumilo ezio la yali abhombile embibhi. Hwa huje hudwemo humo olonzi owilyoyo wahenzele hutuli yalile omtu omo. Nantele hudwemo humo eshipawa eshewene shashifuma aje obhaziwe ehaki yahenzele pamaade ye makosa aminji. ");
INSERT INTO sbk_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Hwa huje, nkashele ikosa elya omo, afwe hwatabhalile ashelele hwomo, nantele hani bhala bhabahi yambilila owenee owiji neshipawa eshelyoli bhaitabhala ashilile akhale hwa omo, oYesu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Eshi basi, nkashe shilila etulo ezaomo wetu bhoti bhahenzele hulonzi huje ashilile huntulo emo hwu henzele abhanziwe elyoli eyesiku ezabhantu bhoti. ");
INSERT INTO sbk_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Hwa hubhe aje shilile asinte abhe neshishi hwa mtu omo bhinji bhabhombilwe aje bhali nembibhi, eshi ashilile hushishi eya omo bhinji bhaibhombwa aje bhali nelyoli. ");
INSERT INTO sbk_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Nantele edajizyo zyahijiye pamo ajeikosa liwezye ahwenele. Nantele palapapali embibhi yazidile abhenyiji, ewenee yahonjeleya tee. ");
INSERT INTO sbk_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ene yafumiye huje, eshi nashi embibhi sazyatabhalile hufwa, shashesho hata owene uwezi atabhale shilile hulyoli hwajili yadele esikunesiku shilile oYesu Kilisiti Ogosi wetu. ");
INSERT INTO sbk_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tiyanje yenu eshi? Lendelele humbibhi huje owene wanjelele? ");
INSERT INTO sbk_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Haa. Ata tatifwiye hu mbibhi tibhawezye ntele adele hwenyo? ");
INSERT INTO sbk_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Huje semumenye aje bhala bhabhahojile hwa Kilisiti bhahojile hufwa yakwe? ");
INSERT INTO sbk_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Taliti syelelwe tetinomwene ashilile owoziwa hufwa. Eli lyabhombwilwe aje eshi huje shila oKilisiti shabhosewe afume hufwa ashilile otutumusu owa Baba, aje eshi natetiwezye ajende huu pya owa dele. ");
INSERT INTO sbk_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Eshi nkashile tikhomenywe peka nawo hushifwani eshefwa yakwa, nantele taikhomanyiziwa hufwa yakwe. ");
INSERT INTO sbk_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ate timenyu eshi, outu wetu owehale wakhobhehenywe pamo nawo, aje eshi obele ogwe mbibhi gunankanye. Eli lyafumile aje neshi tisihwendelele bhatumwa bhe mbibhi. ");
INSERT INTO sbk_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Omwene yali afwiye abhombwilwe wehaki alengane nezambe. ");
INSERT INTO sbk_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Eshi nkashele tifwiye pamo no Kilisiti, tihwamini aje tidela pamo nomwene nantele. ");
INSERT INTO sbk_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Timenye aje oKilisiti azyozyelwe afume hwabha fwe saga fwe nantele efwa saga ehutabhala nantele. ");
INSERT INTO sbk_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hwa huje eshi ejango eyafwe shafwiye humbibhi, afwiye limo hwajili ya bhoti hata eshi edelo zyadela adela hwajili ya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hwi dala lyelyo, namwe huje muhwanziwa ahwibhazye aje bhafwe hu mbibhi, aje bhomi hwa Ngolobhe hwa Kilisiti oYesu. ");
INSERT INTO sbk_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Hwa huje esho esiluhusu ezambe etabhale ombele gwaho aje obhene shishi hu nyonyo zyakwe. ");
INSERT INTO sbk_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Osihwefwe esehemu ezyembele gwaho humbibhi nashi evyombo vyasaga viline haki. Eshi hwifumi mwemwe hwa Ngolobhe. Nashi bhali bhomi afume hufwe eshi zifumi esehemu ezye mabele genyu abhe vyombo vyehaki hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mganje aileshe zambe ebha tabhale hwa huje sagamli pasi yendajizyo, huje pasi wene. ");
INSERT INTO sbk_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yenu eshi tibhombe embibhi hwa huje sutihweli pansi ye ndajizyo, huje pasi ayewene? Ha aa. ");
INSERT INTO sbk_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Semmenye aje hwamwene yuoyo yali muhwifumya mwemwe nashi atumwi mwamuli mwemwe mubhabhe bhatumi bhakwe omwene, yahwanziwa humwogope? Eshi lyoli hata nkashile amwemuli bhatumwa bhezambe eyo yebha twalila hufwa naje bhatumwa mwa bheshishi wauwatwalila huhaki. ");
INSERT INTO sbk_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Hwa huje asalifiwe Ongolobhe! Huje mwali bhatumwa bhe mbibhi, eshi mwahogope afume humwoyo ela yeli yefudizyo zyamwapewilwe. ");
INSERT INTO sbk_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mbhombwilwe wene afume mbibhi na mbhombwilwe ubhe bhatumwa bhi haki. ");
INSERT INTO sbk_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Eyanga nashi je mtu owe sababu ye mabhine age mabele getu huje nashi shila shamwahefwizye eviungo evyambelegwenyu abhe bhatumwa bhe chafu ne mbibhi zya zili nashi ezyo, eshifumi eviungo evye mabelegenyu aje mulibhatumwa bhe haki hu wozwo. ");
INSERT INTO sbk_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Hwa hubhe pamwali bhatumwa bhembibhi mwali wene huje nelyoli. ");
INSERT INTO sbk_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Hu siku ezyo, mwali nidodolo lyali hu hunongwa gali geshi mulola esoni hwego? Hwa huje efumilo yenongwa eyo hufwe. ");
INSERT INTO sbk_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Hwa hubhe eshi mubhombwilwe wene shibhala ne mbibhi na mubhombeshe abhe bhatumwa bha Ngolobhe, mli nidodola huajili yewozye. Afume huwoni owewila. ");
INSERT INTO sbk_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Hwa huje emposhezi ye mbibhi hufwe eshiopezi owu wene wilawila owa Ngolobhe huje womi owe wilawila hwa Kilisiti oYesu Ogosi wetu. ");
INSERT INTO sbk_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Aje semmenye, mwaholo bhane (hwa habhe eyanga na bhatu bhabhaimenye edajizyo), aje edajizyo ehatabhala omtu pali mwomi? ");
INSERT INTO sbk_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Hwa huje oshe yayegwilwe afungwilwe nedajizyo hwola olume wakwe pali mwomi nantele huje olume nkawafwa abhabhe abhehwilwe wene afume hundajizyo eye ndowa. ");
INSERT INTO sbk_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Eshi basi, husiku olumu wakwe nkali sadela, huje adela no lume owenje tiigahuni nkashe. Je olume wakwe afwiye aliwene hundajizyo, esho sagabhabhe huni nkashele adela nalume owenje. ");
INSERT INTO sbk_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Hwelyo, mwaholo bhane, amwe eshi mwabhombwilwe bhafwe bhe ndajizyo hwidala elye mbele gwa Kilisiti. Eli eshi aje tiuganisiwe noweje hwamwene yuoyu yali azyosyelwe afume hwabhafwe aje tiwezye hupapile Ongolobhe amadodolo. ");
INSERT INTO sbk_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Huje patali tili shi bele, enyonyo ezye mbibhi zya damuziwe hu viungo vyetu hwidala elyedajizyo naipapile efwa amadondolo. ");
INSERT INTO sbk_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nantele ehi tipinyilwe afume hudajizyo. Tiifweleye ela yayli etikhomile. Aje ate tipate atumishe hu hali empya ye Fijili, nate huhaliye made ye nsimbo. ");
INSERT INTO sbk_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tiyajewele eshi? Endajizyo aje mbibhi? Haa. Hata eshi, senezagai manye embibhi, hangasaya hali hwidala lye ndajizyo. Aje saganaheza gama asangwe aje ndajizyo hangasaga eyanjile, “Osinyonye.” ");
INSERT INTO sbk_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Huje embibhi yapate nafwasi hwela eemuli nalete muhati mulini shila aina eyensongwo. Huje embibhi pasagapali endajizyo efwiye. ");
INSERT INTO sbk_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nane ehali mwomi epo olwahwande bila ndajizyo, eshi pehenza ela eamuli embibhi yapete owomi, nane nafwa. ");
INSERT INTO sbk_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ela eamuli yayali elete owomi yagalushe abhe fwa hulini. ");
INSERT INTO sbk_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Hwa huje embibhi yapete enufwa si hwela eamuli nantele yahopeye. Ashilile hwela eamuli, yangojile. ");
INSERT INTO sbk_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Eshi edajizyo ntufye, yope ela eamuli ntufye, yelyoli na nyinza. ");
INSERT INTO sbk_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Eshi basi elayeli nyinza yalifwa hulini ane. Eganjebhe sho kabisa huje embibhi yaloleshe abhe mbibhi hani ajedele hwela enyinza ehaletile efwa muhati mlini. Eneyali aje huje ajendele hwela eamuli embibhi zyonje lele abhe mbibhi tee. ");
INSERT INTO sbk_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Hwa huje timenye yahuje endejizyo shikulilo shakwe shahumwoyo eshiane endimtu webele. Enkaziwe pasi patumwe owembibhi. ");
INSERT INTO sbk_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Aje lye bhomba saga, edimanya shinza. Aje lila lyedigene abhombe saga edibhomba nalila lyendivitwa lyebhomba. ");
INSERT INTO sbk_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Aje shi nkembalibhombe lila lyasaga endigene ehwetehana nedajizyo eya je edajizyo nyinza. ");
INSERT INTO sbk_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Huje eshi saga nene humwoyo gwane nebhomba elyo, huje yoyela embibhi yekhala muhati mlini. ");
INSERT INTO sbk_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Hwa huje emenye aje muhati mlini aje muhati mbele, gwana sezikhala enongwa. Enyenza hwa hubhe enyonyo eyeliza eli muhati mulini, aje sebhomba. ");
INSERT INTO sbk_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Hwa huje lila elinza lyendigene saga edibhamba huje lila ibhibhi lyasaga edigene lyebhomba. ");
INSERT INTO sbk_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Eshi khashele ebhomba lila lyasaga edigene saga nene binafusi nebhomba huje yayela embibhi yeli muhati mulini. ");
INSERT INTO sbk_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Emenye, nantele ehweli ekanu ni muhati mulini ya hwanze abhombe lyalili linza eshi embibhi lyoli zihweli muhati mulini. ");
INSERT INTO sbk_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Hwa huje ejisongwelwe edajizyo yo Ngolobhe hu utu owa muhati. ");
INSERT INTO sbk_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Eshi ejilola ekanuni yeli payo huviungo vyavili mble gwane. Ekho mana ibho huzidi ya kanuni empya hujele zyane. Embomba ane abhekhatwe hukanuniye mbibhi mbibhi yeli huviungo vyavili mubele. ");
INSERT INTO sbk_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ane edi mtu we sago wenu gadafyole no mbele oguuogwe fwe? ");
INSERT INTO sbk_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Eshi salifi hwa Ngolobhe owa Yesu Kilisiti Ogosi wetu! Aje eshi ane nene hunjele zyune enjitumishila endajizyo ya Ngolobhe. Aje hubele ejitumishila kanuni yenzambe. ");
INSERT INTO sbk_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Eshi hwe lyo basi na umo olozi owi lyoyo hwabhene bhabhali bha Kilisiti Yesu. ");
INSERT INTO sbk_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Hwa huje ekanuni eya Finjili owe womi ula wauli hwa Yesu Kilisti embombile ane abhe mwaule hutali ne kanuni ye mbibhi nefwa. ");
INSERT INTO sbk_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Hwa huje hala hahali edajizyo ya menilwe abhombe huje yali nzaifu humbele, Ongolobhe abhombile. Atumile Omwana wa kwa owalimwene kushifwani webele we mbibhi abhe sadaka ya mbibhi, na iilonga embibhi humbele. ");
INSERT INTO sbk_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Abhombile eshi aje amalajizyo age ndajizyo gatimilishe muhati yetu, ate tasagabhala alondole enongwa ye bele, eshi bhala bhabhalo ndola Ofijili enongwa ya Fijili. ");
INSERT INTO sbk_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bhala bhabhalondola ombele bhasebha enongwa ezyembe, eshi bhala bhabhalondola Ofijile bhasebha enongwa eya Fijile. ");
INSERT INTO sbk_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Hwa huje enia ye mbele hujefwa, aje enia eyefijile womi no winza. ");
INSERT INTO sbk_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ene hujeela enia ye bele eli evisene no Ngolobhe, huje sagaeli neshishi hudajizyo ya Ngolobhe, nantele saga ewezya ayogope. ");
INSERT INTO sbk_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bhala bhagulondola obele sagabhawenzya ahugana Ongolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hata eshi, saga mlinu bele mli hwa Fijile, nkashile lyoli huje Ofinjile wa Ngolobhe ukhala mhati mulimwe. Nantele nkashele mtu sagali no Finjile owa Kilisiti, omwene sagawakwe. ");
INSERT INTO sbk_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nkashe Kilisiti ali muhati yenyu obele yufwiye hunongwa eye mbibhi, aje finjila ali mwami hunongwa eye lyoli. ");
INSERT INTO sbk_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Nkashele Ofinjile wa ola yazwosyenzye oYesu afume hwabhafwe akhala muhati mulimwe, omwene ola yazwozyezye Kilisiti afume hubhafwe aigapela amabele genyu agafwe owomi hwidala elye Finjili wakwe, yadela muhati mulimwe. ");
INSERT INTO sbk_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Eshi huje, mwaholo bhane, ate tilini deni, lakini saga hubele huje tikhale hu jisi yebele. ");
INSERT INTO sbk_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Aje nkashele mudela hujisi ye mbele mlipepe afwe, nkashe hwa Finjile mugoga embombo ezyebele namwe mubhakhale. ");
INSERT INTO sbk_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Eshi hwa huje nashi abhinji bhabhalongozewa no Finjile owa Ngolobhe, ebha bhana bha Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Hwa hubhe sagamwahambilile Ofinjile owetumwa nantele hata mwogope. Badala yakwe, mwahambilile ofinjile eya bhombwe aje bhana bhabhali hwelyo tilila, “Abba, Baba!” ");
INSERT INTO sbk_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ofinjile yuywo ayanjile pamo nefinjile zyetu aje tili bhana bha Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nkashele tili bhana, huje tili bhagalinaje bhagali bha Ngolobhe. Nate tili bhagali pamo no Kilisiti, nashele hu lyolli tiyemba no mwene aje tipate otutumusi pamo nomwene. ");
INSERT INTO sbk_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Hwa huji ghabazya amayemba age siku ezi abhe saga hatu nkeleganisya notutumu wawaikwi nkwinkulwu huliti. ");
INSERT INTO sbk_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Hwa huje evibhombe vyoti eshi vihwenyeze hu shahuku enyinji akwinkuliwe hwa bhana bha Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Hwa huje obhombaji wope wa hogofyewe pasi yeshishi sagahwi gane lyakwe, ila husabu yakwe omwene yuoyo yahogofye. Zye hwitumaini ");
INSERT INTO sbk_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","huje obhombi wene wope wa ibhehwa wene nafumiziwe hutumwa owenankanye, na hwijizye huwene we tuntumu wa bhana bha Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Hwa huje timenye eyaje obhombi obho wope ubhina nayembe hu chungu pamo hata eshi. ");
INSERT INTO sbk_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Saga eshotu, nate tete tatiliu na malibuko age Finjile - tete nate tibhina hunafusi zyetu, tigolela abhombwe bhana yaani ofyozi owe mabele getu. ");
INSERT INTO sbk_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Hwa huje hwi talaja eli tatifyolelwe. Eshi hatu hahaihwenza nkahabhoneha nahumo asobhele nantele, hwa huje wenu yasobhela hala hahalola? ");
INSERT INTO sbk_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Aje nkatisobhela ahatu hasaga tihalola, tihagolela husabuli. ");
INSERT INTO sbk_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hu jisi yeyela, Ofinjile wope ata vwa hubhine wetu. Hwa huje sagatimenye alabhe she hwanziwa, eshi Ofinjile yuoyo atilabhila hubhine hwasaga hwawezye atambulwe. ");
INSERT INTO sbk_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","No mwene ya hwenya moyo aimanya enjele eya Finjile, huje alabha huniaba yabho bhabheteshe alengane nogane wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ate timenye ya huje hwa bhonti bhabha genwe na Ngolobhe, omwene abhomba enongwa zyonti pamo hu winza, wa bhala bhonti bhabhakwizilwe husini yakwe. ");
INSERT INTO sbk_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Hwa huje eshi bhala bhonti bhabha bhamenye ahwande huhale, eshi abhasalunye awande huhale, bhalenganyiziwa neshifwani sha Mwana wakwe, aje omwene abhe papwa wa hwande pandwemo naholo abhinji. ");
INSERT INTO sbk_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Na bhala bhabha salunye afume ehale ebho abhakwizizye nantele. Na bhala bhabhakwizizye ebho abha bhazizye ehaki. Na bhala bhabha bhazizye ehaki ebho nantele abhatutumusizye. ");
INSERT INTO sbk_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tiyanje yenu eshi pamwanya yenongwa ezi? Ongolobhe nkali oupande wetu, wenu yalipamwanya paliti? ");
INSERT INTO sbk_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Omwene yasaga husebhanya omwana wakwe yuoyo aje afumizye hwa jili yetu atetenti abhakosa wela ati kulimi nenongwa zyonti pamo nawo? ");
INSERT INTO sbk_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Wenu yandabhatake ateule bha Ngolobhe? Ongolobhe yuoyo omwene yandabhazizye ehaki. ");
INSERT INTO sbk_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Wenu yaibhalonjela ilyoyo? O Kilisiti oYesu yuoyo afweye hwajili yetu, nantele wega omwene wope azyosyewe. Wope atabhala pamo no Ngolobhe pala pali neshishi nantele yayo yoo yatilabhila ate. ");
INSERT INTO sbk_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yu nanu yabhatibagule nogane wa Kilisiti? Amalabha, aje, eshida, aje amayemba, aje enzala, aje oteowalele, aje ehatali, aje ipanga? ");
INSERT INTO sbk_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nashi isesimbwilwe, “Hu faida yaho tigogwa osagawo. Ntitibhaziwe nashi ngolo ezya sinzye.” ");
INSERT INTO sbk_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nashi enongwa ezi zyonti ate tili sana ya bhashila hwa mwene yatigene. ");
INSERT INTO sbk_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Hwa huje emalishe asohwe aje huje, ofwe, owomi, huje ahala ozelu, huje amamulaka, huje evitu vya vihweli, huje evitu vyavihwenza, huje eguvu, ");
INSERT INTO sbk_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","huje galipamwanya huje vyavilipansi huje, eshibhombwa shashonti shila, seshibha wezye atibagule nogana wa Ngolobhe yali yo Kilisiti oYesu Ogosi wetu. ");
INSERT INTO sbk_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Eyanga elyoli hwa Kilisiti. Seyangailenga, humwoyo gwene eshudila pandwemo nane hwidala Opepo Ofinjile, ");
INSERT INTO sbk_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","huje huli azugumile ohogosi abhawe hwa saga humaliha muhati yemwoyo gwane. ");
INSERT INTO sbk_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nezagazilishe ane nemwene alogwe abhehwe hutali nu Kilisiti huje aholo bhane, bhala abheshikholo shane ashilile obele. ");
INSERT INTO sbk_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Abhene bha Israeli. Bhabhehwelwe huje bhana, abhe tufiwe ayangane, ezawadi eya logwe, hupute Ongolobhe, na malagano. ");
INSERT INTO sbk_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ebhene bhabhatagalizizye ohwo Kilisiti ahenzele enshinshi akwate obele oguu - huje oyo uo Ngolobhe wa bhoti. Wope ayeme hwaje wilawila. Amina. ");
INSERT INTO sbk_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Sehuje amalagano ga Ngolobhe hujezikunilwe afishe. Sehuje kila mutu wali Israeli nasebha Israeli bhebho. ");
INSERT INTO sbk_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Sehuje bhoti bhali bhana bha Abulahamu huje bhali bhana bhakwe bhebho. Lakini, “naashilile u Isaka abhana bhaho waikwiziwa.” ");
INSERT INTO sbk_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Hweli hwahuje, abhana abha mbele sagabhana bha Ngolobhe. Lakini abhana abhe ahadi bhahwenyezewa huje ebha ndabhana. ");
INSERT INTO sbk_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Elilizuu elyahadi: “Nane majira ego naye hweza, nu Sala aipata omwana.” ");
INSERT INTO sbk_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Sagalyalyeli tu, lakini pamaade u Lebeka abhapate evyanda hwa mtu omo, o Isaka udaada wetu- ");
INSERT INTO sbk_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","hwahuje abhana bhali nsele apapwe na alibado abhombe ijambo lyolyonti elinza au ibhibhi, huje ikusudi elya Ngolobhe alengane nachagule lyemelele, wala sehuje humiza, lakini sehwahuje yola wahukwizya. ");
INSERT INTO sbk_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Lyayagwilwe huje, “Ogosi abhahutumishile ododo.” ");
INSERT INTO sbk_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Nashi sashili huje lyahandihwe: “U Yakobo nagene, lakini u Esau navitilwe.” ");
INSERT INTO sbk_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Hwa huje tiyanje yenu? Huje lihweli ilenga hwa Ngolobhe? Huje dadi ");
INSERT INTO sbk_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Hwa huje eyaanga ahusu oMusa, “embabhe neisajilo hula wembahusajile, na ebhabhe ne sajilo hwola wembahusajile.” ");
INSERT INTO sbk_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Hwa huje bhasi, saga yuyo oyo wabhahwanze, wala sagayuyo oyo wanyila, lakini hwa huje yu Ngolobhe, hwa huje abhonesha asajile. ");
INSERT INTO sbk_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Hwa huje aamazu gayanga hwa Falao, “Hwa huje ega goti galinsini ambuinule, huje ebhoneshe aguvu zyane ashilile wewe, nahuje iitawa lyane lirumbelelwe ensi yoti.” ");
INSERT INTO sbk_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Huje bhasi, Ongolobhe abhane sajilohwa wowoti wagene, nahwola wahugana, ahubheha abhe hali. ");
INSERT INTO sbk_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Nantele ubhayanje hwalini, “Yenu alola ikosa? Yo lihu wagamalile agajimbile amambo gakwe?” ");
INSERT INTO sbk_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ahosi yakwe, omwanadamu, awewe nanu woyanga kinyume nu Ngolobhe? Huhweli aweze hane lyolyoti lya hahabhombelwe hayanga hwula wahabhombele, “Huje yenu wambombele eshi ane?” ");
INSERT INTO sbk_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Je wabhomba sagali nehaki hwilongo elyaleganyizye evyombo humatumizi gega hweli afumilane nuvilima ulaula, ne shombo esha mwabho shibha na matumizi kila siku? ");
INSERT INTO sbk_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Wole nashi Ongolobhe, umwene alitayali wabhonesye enkuni yakwe naabhombe amaha gakwe amanyishe, ajimbile navumilile huiye evyombo evya enkumi vyevibhehwelwe kwajili ya goje? ");
INSERT INTO sbk_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Woole nkashile abhombile enga abhonesye ohwinji we utukufu wakwe hu vyombo evya rehema, avibeshele tayali kwajili yeutukufu? ");
INSERT INTO sbk_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Wole kashile abhombile eli, je hulitu, hwa huje nate alitwizizye sagahuje afume Wayahudi, nantele afume nahwa bhantu bha Mataifa? ");
INSERT INTO sbk_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nashi sayanga mwa Oseya: “Embabhakwizye abhantu bhane bhabhali saga bhantu bhane, nuula wagene natele nuula wasaga agenwe. ");
INSERT INTO sbk_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na abhabhe huje pala palyayagwilwe hwa bhene, 'amwesagamlibhantu bhane,' pala bhezekwiziwe 'abhana bha Ngolobhe wali mwomi.”' ");
INSERT INTO sbk_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","O Isaya alila ashilile nebha Israeli, “Huje abhazye abhana bha Israeli engelinashi usanga gwa mbahali, ebabhe nashi bhebhasageye bhazabhe nashi bhabhahwokolewe. ");
INSERT INTO sbk_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Hwa huje Ogosi abhahweje izuu lyakwe hwumwanya na pansi, sasele nahwa utimilifu. ");
INSERT INTO sbk_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nashi oIsaya sayanjile ehale, “Nashi Ogosi owemanjeshi sagatilesheye akhosi ouzao kwaajili yaliti, angatili nashi e Sodoma, nangatibhombilwe nashi e Gomora. ");
INSERT INTO sbk_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tibhayanje genu lelo? huje abhantu abhe Mataifa huje bhahali sagabhahwanza elyoli bhapente elyoli, elyoli huimani. ");
INSERT INTO sbk_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Lakini abha Israeli, bhahazile ikalata elyelyoli, sagayiifishie. ");
INSERT INTO sbk_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Yenu yalyesho? Hwa huje sagabhaiyazile huimani, bali huu matendo. Wabomele pamwanya yiwee na bhabomelee, ");
INSERT INTO sbk_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","nashi seyagwilwe enyenye, endigonizye iee elya abomelee, hu Sayuni nahuje owakose. Omwene wahuposhela hwelii sagabhakenyesewe. ");
INSERT INTO sbk_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Mwaholo, esebho ezya mwoyo gwane napu tehwane hwa Ngolobhe nihwajili yabhene, ne hwaajili yahwokoshe hwabho. ");
INSERT INTO sbk_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Hwa huje embashuhudila huje bhahwituma hwaajili ya Ngolobhe, lakini sehuje njelezyabho. ");
INSERT INTO sbk_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Hwa huje sebhaimenye elyoli ya Ngolobhe, nabhahwanza azije elyoli yabho bhebho. Saga bhahwisyaga hulyoli ya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Hwa huje iKilisiti yuyo watimizye isheliya eyelyoli huje omtu wahuposhela. ");
INSERT INTO sbk_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Hwa huje uMusa ahwandiha ahusu elyoli eyo ehwenza ashilile ne eshelia: “Umutu wabhomba elyoli mshelia abhakhale hwa lyoli ene.” ");
INSERT INTO sbk_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lakini elyoli yetumilana nashilile olweteho luyanga eshii, “Ogajeyanje humwoyo gwaho, 'Yonanu wabhabhale humwanya?'(Ohu hulete uKilisiti pansi). ");
INSERT INTO sbk_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Na ogajeyaje, 'Yonanu abhahwishe mwilende?” (Ane, huleta uKilisiti humwanya afume hwabhafwe). ");
INSERT INTO sbk_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Lakini liyanga yenu? “Izu lipapepe nawe, afume mwilomu lyaho na afume humwoyo gwaho.” Elyo lizu elya luseshelo, elyo lya tiliyanga. ");
INSERT INTO sbk_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Hwa huje kashile hwilomu lyaho ohweteha oYesu huje Ugosi, na huposhele humwoyo gwaho huje Ongolobhe afyosezye afume hwa abhafye, ubhahwokoshe. ");
INSERT INTO sbk_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Hwa huje humwoyo omuntu ahumweteha napate elyoli, nahwilomu ahweteha napate opute. ");
INSERT INTO sbk_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Hwa huje izu liyanga, “Kila wahuposhela saga abhakenyesewe.” ");
INSERT INTO sbk_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","hwa huje naumo olengano nu Yahudi nu Muyunani. Hwa huje Ugosi yoyola Ugosi wa bhoti naweshoma hwa bhoti bhabha hukwizya. ");
INSERT INTO sbk_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Hwa huje kila walikwizya itawa elya o Ugosi abhahokoshe. ");
INSERT INTO sbk_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Hwa huje bhole uwezizye hukwizye ola wasaga mwamweteshe? Bhagakhozya bhole ilibhawezye huposhele nashi oyo sagabhamwovyezye? Na bhezehozye hwoole pasipo uwalumbelele? ");
INSERT INTO sbk_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Bhezewezye bhole alumbelele, akashile sebhatumwilwe? - Nashi sagasimbilwe hwa huje owinza wemagaga gabhala bhabhatangazya enogwa enyinza izye mambo aminza!” ");
INSERT INTO sbk_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lakini bhoti sagabhatejelezezye amazu. Huje oIsaya ayanga, “Ogosi, yunanu wahovyezye otumwa wetu?” ");
INSERT INTO sbk_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Huje ulweteho luhweza afumilane natejezye na hwovye hwizu elya Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lakini eyanga, “Huje sagabhahovyezye?” nalyoli kabisa. “Amazu gabho gamalishe afume hwoze nahunsi yoti, nenogwa zyabho zibhalile paka humwisho gwe dunia.” ");
INSERT INTO sbk_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ashile goti, Eyanga, “Huje Abhaisraeli sagabhamenye?” Kwanza uMusa ayanga, “Embabhadizye embabheshele uwivu hwa bhantu bhasaga bhe taifa. Hwidala elitaifa lyasaga lyahwelewe, embabhachochele paka mvitwe.” ");
INSERT INTO sbk_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nu Isaya anilyomi sana naayanga, “Natangene navala bhasaga bhanazile. Nabhoneshe mhwavala hwa sagabhananzaga.” ");
INSERT INTO sbk_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lakini hwa Bhaisraeli bhayanga, “Ensiku zwoti nagolosezye amakhono gane hwa bhasagabhahwiyisizye nahwa bhantu aakhomee.” ");
INSERT INTO sbk_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Huje eyanga, huje, Ongolobhe abhakhanine abhantu bhakwe? Hata hashe. Hwa huje nane ne Mwiisraeli, wa mshikolo sha Abulahamu, hwi kabela lya Benyamini. ");
INSERT INTO sbk_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ongolobhe zagabhakhene abhantu bhakwe abhamanye afume huwandilo. Je sagamenye izuu liyanga yenu ahusu o Eliya, jinsi sabholele Ongolobhe humwanya ye Israeli? ");
INSERT INTO sbk_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Ogosi, bhabhagojile ankoha bhaho, bhope bhabomoye pashiputo paho. Nene nimwene esagalye, bhope bhahwaza owomi wane.” ");
INSERT INTO sbk_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Lakini ijibu elya Ngolobhe liyanga yenu huliwe? “Embeshele kwaajili yalini abhantu elfu saba ebho sagabhayikhomela amafu gamo Baali.” ");
INSERT INTO sbk_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hata eshi, wakati ou esalezi bhahweli bhabhasagaliye ashilile ouchaguzi wiwenee. ");
INSERT INTO sbk_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Lakini kashile huweene, sehuje hwu matendo. Kashile weene sagaibhabhe nantele weene. Yeni bhasi? ");
INSERT INTO sbk_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ahantu ambaho Eisraeli yaliehwaza, sagahajile, huje bhabha chaguliwe bhahajile, nabhamwabho bhabhehwele bhamwamu. ");
INSERT INTO sbk_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nashi sagasimbilwe: “Ongolobhe abhapie opepo ogwasajilwe, amaso huje bhasilole, na makutu huje bhasiyovwe, epaka sanyono eeshii.” ");
INSERT INTO sbk_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Wope o Daudi ayanga, “Leha emeza zyabho nazibhe nyavu, tengo sehemu yaabomelee nalipizye eshisasi hwa bhene bhebho. ");
INSERT INTO sbk_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Leha amaso gabho gabhehwe akisi huje bhagajelole. Ubhaundamishe amasana gabhowila.” ");
INSERT INTO sbk_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Basi eyanga, “Huje bhabomelee hata bhagwile egajebhe?” Esho na mwaha. Badala yakwe, amenwe hwabho, olokole ufishe hwa Mataifa, ili bhebho bhene bhabhe nu wivu. ");
INSERT INTO sbk_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Nkashile amenwe hwabho hutabhale evya paulimwengu, nakashile hasalayabho atabhale wa mataifa, nazibhabhe zilenga enyinji akamilishe hwabho? ");
INSERT INTO sbk_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Na esalezi eyanga namwe mubhantu bhe Mataifa. Hwa huje enditumwa wa bhantu abhe Mataifa aganje, ehwivunira huduma yane. ");
INSERT INTO sbk_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Labda engabhabhehe owivu gwambele pandwemo nanene. Nkanga tigabhokola bhabha hweli bhamo. ");
INSERT INTO sbk_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Maana huje akhanile hwabho bhapatene ne dunia, aposhelelwe hwabho haibhawole ila uwomi afume hwaabhafwe? ");
INSERT INTO sbk_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Nkashire amadondo agapawandilo akiba, shesho sashihweli hwibhomba elye ousu. Nkashile amazi gope akiba, esamba zyope shesho. ");
INSERT INTO sbk_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Lakini nkashile zihweli esamba zyazidumulwe, nashi wewe, isamba lya mwipoli elya mzeituni, watotilwe pandwemo nabho, na nkashile wali pandwemo nabjo namumazi age otabhalo hwa mzeituni, ");
INSERT INTO sbk_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","oganje hwintutumule amwanya yemasamba. Lakini nkashile uhwintutumula, nasaga wewe ohwavya mumazi, bali amazi gahumwavya awe. ");
INSERT INTO sbk_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Basi ubhayanje, “Amasamba gadumulwe huje epate atotwe mwilende.” ");
INSERT INTO sbk_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ego gali lyoli. Husababu yakutowiteshe hwabho bhadumule, lakini awe wahemeleye shinza husababu yelweteho lwaho. Ugaje hwise bhelele umwene huhaliyamwanya sana, heli ogopaga. ");
INSERT INTO sbk_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kwa maana nkashile Ongolobhe hagagalesheye amasamba amakolo, sagabhahusajile nawe shesho. ");
INSERT INTO sbk_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Hwiyenye, basi, amadala amiza nuhali wa Ngolobhe. Na hudwemo humo, okhali wahenzele amwanya ya Ayahudi ebho bhagwiye. Lakini nahudwemo uwamwabho, owiza wa Ngolobhe guweza amwanya yaho, nkashile obhakhale mumiza gakwe. Shoshoti nawe amanye obhatagwe hutali. ");
INSERT INTO sbk_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Natele, nkashile sagabhezehwendelele mlweteshelo lyakwe, bhezatotwe natele. Maana Ongolobhe alinagwo ouwezo ogwa totele natele. ");
INSERT INTO sbk_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Hwa huje amwekashile mwadumulwe hwoze ashilile huhale omzeituni ogwamwipoli, na kinyume shakwe ehale mwa vyalilwe mu mzeituni omwieza, sehuje hwenje sana hwebha Ayahudi, sawa nahuje masamba amakolo gowezya agavyale natele muhati ye mzeituni gabho bhebho? ");
INSERT INTO sbk_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Hwa huje mwaholo sehwaza huje msimanye afyatane nesiri ene, huje msibhe ne eshinshi nashi asebhanye hwenyu mwemwe. Esiri ene huje okhome guifumilene na Israeli, hadi akamilisye hwa mataifa nahwayiyenza. ");
INSERT INTO sbk_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Epo aIsraeli yote bhaihwokoha, nashi sagasimbilwe afume: “Afume hu Sayuni ayihwenza Owakhokole. Ayihwefya oubhibhi afume hwa Yakobo. ");
INSERT INTO sbk_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Neli lyayibha malagano gane pandwemo nabhene, ensiku ezyo naihwefye embibhi zyabho.” ");
INSERT INTO sbk_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ahusuhudwemo humo ashilile iizuu, bhavitilwa hwu sababu yenyu. Hudwemo ohwamwabho ashilile nasalule hwa Ngolobhe, bhagenwe husababu ya amaamaa. ");
INSERT INTO sbk_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Hwa huje ezawadi nakwiziwe hwa Ngolobhe sagahugaluhana. ");
INSERT INTO sbk_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Hwa huje ehale amwee mwalimleshile Ongolobhe, lakini esalezi muiposheye ewene hwusababu ya aleshe hwabho. ");
INSERT INTO sbk_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Hwidala lyelyo esalezi, ebha Ayahudi bhaleshile. Afumilane nego huuje nesanjilo zya mlinazyo amwe bhawezizye bhope aposhele ewene. ");
INSERT INTO sbk_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Maana Ongolobhe abhankonjele abhantu woti ashilile huleshe, huje awezizye abhasajile bhoti. ");
INSERT INTO sbk_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Shahuhweli outabhalo nenshinshi nenjele eya Ngolobhe! Zagapimwapimwa naloonje hwakwe, namadala gakwe sagazimanyiha! ");
INSERT INTO sbk_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Maana yonanu walimenye ilengo lya Gosi? Au yonanu waliyanzi wakwe? ");
INSERT INTO sbk_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Au yonanu owakwanza hupele ahantu Ongolobhe, huje alipwe nantele?” ");
INSERT INTO sbk_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Hwa huje afume hwakwe, nahwidala lyakwe nahwamwene, evitu vyoti vihweli. Hwa mwene obhe golonsu wilawila. Amina. ");
INSERT INTO sbk_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Eshi hwego embasunda, mwaholo, hwusanjilo zyakwe Ongolobhe, gafumii amabele genyu ebhe dhabihu yeli enyomi, ezelu humwoyo yeposhelelwa hwa Ngolobhe. Ene ibada yenyu eye lyoli. ");
INSERT INTO sbk_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Wala mgajehwazizye amambo gepa pansi epa, huje tigaluzanyiwe abhehwe bhapya esebho zyetu. Bhombaji eshi mposhele amanye olugano lwa Ngolobhe gagali miza, agahukhodele na humalishilo. ");
INSERT INTO sbk_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Eshi eyanga, hwusababu yewene yepebhilwe, huje kila muntu wahweli pandwemo namwe sahwaziwa asebhe natele humwanya yakwe yuyo ashile sashihwaziwa asebhe. Huje, hahahwaziwa asebhaje hwunshinshi huje nashi Ongolobhe abhapiye kila omo hashe ahantu hee lweteho. ");
INSERT INTO sbk_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Hwa huje tine vintu vinji ashilile mbele gumo, lakini sevintu vyoti vine mbombo emo. ");
INSERT INTO sbk_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Shesho ate, tetilibhinji tilibele gumo ashilile uKilisiti, na evikhatazizyo kila omo hwawa mwabho. ");
INSERT INTO sbk_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tiline kalama zyezili mjinjinyinji hwuwene yetipewilwe. Kebhabhe kalama eyamuntu okuwa, na ebhombeshe hwuwezo gwe lweteho lwakwe. ");
INSERT INTO sbk_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kebhabhe ekalama ya muntu huduma, na abhombaje. Nkebhahe owenje ane kalama eyafundizye, hwa huje afudizyaje. ");
INSERT INTO sbk_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Nkebhabhe kalama eyamuntu falaja, hwa huje, abhafaliji. Nkebhabhe kalama eyamuntu hufumwe, abhombaje esho humwoyo gwoti. Nkebhabhe kalama ya muntu hulongozye, nalibhobheshe huwinza. Nkebhabhe ekalama ya mntu hubhoneshe esajilo, na ebhombeshe huhuseshelelo. ");
INSERT INTO sbk_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Aganane husibhe hwilenga. Vitwaji embibhi; mnkhatilile aminza. ");
INSERT INTO sbk_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Ahusu aganane hwaholo, mgananaje mwemwe hwa mwemwe. Ahusu nshinshi, enshinshi ebhehulimwe hwa hulimwe mubhene. ");
INSERT INTO sbk_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ahusu ubhomvi, mganjebhe bhayuzu. Ahusu ompepo, mbhanje muhusogwa. Ahusu Ogosi, hwitumaji. ");
INSERT INTO sbk_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Shanji hwidandi lyamlinalyo ahusu ensiku zyezihwenza. Mubhe nagolele ashilile amayemba genyu. Mkhalaje apuute. ");
INSERT INTO sbk_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Mubhavaje ashile amashida agalokole. Azaji idala elya bhoneshe oluganano. ");
INSERT INTO sbk_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Bhalabhilaji aminza woti bhabha bhayevya amwe; mubhaputilaye aminza na mgaje bhaputile alogwe. ");
INSERT INTO sbk_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Shanji pandwemo nabhabha shaa, lilaji pandwemo nabhabha lila. ");
INSERT INTO sbk_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mubhe nesebho zimo mwemwe hwa mwemwe mgajesebhe hwa hwilole, lakini bhetehaji abhantu abhehali eyapansi. Mubhanje nenshinshi humwanya yesebho zyenyu mbhene. ");
INSERT INTO sbk_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Msihusovye omuntu wowoti ibhibhi hwi bhibhi. Bhombaji aminza humaso gabhantu bhoti. ");
INSERT INTO sbk_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Nkashile ewezehana, nashi sashibhe shelwe hulimwi, mubhe neluseshele nabhantu bhoti. ");
INSERT INTO sbk_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Bheluganano, ugajelipizye eshisasi umwene, lakini ileshi ehasila ya Ngolobhe. Huje eyandihwe, “'eshisasi sha Ngolobhe; Nene embasombe,' ayanga Ugosi.” ");
INSERT INTO sbk_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“Lakini nkashile obhibhi waho ane zala, pele. Nkashile ayomele, mwelezye. Huje nkobhombo esho, ubhahumwoholele amakala age mwoto amwanya yitwe lyakwe.” ");
INSERT INTO sbk_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ogaje mwemwe nuubhibhi, heli oumene au bhibhi hwuminza. ");
INSERT INTO sbk_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kila nafsi naibhe nahwishe hwa bhabhali pamwanya, hwahuje nomoo awemelelele hwahuje efumile hwa Ngolobhe. Ne mamlaka zyezihweli zibhehwelwe no Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Hwola waikhana emamlaka eyo akhana ndapizyo zya Ngolobhe; na bhala bhabhayikhana bhenzeyiposhele aloongwe humwanya yabho bhebho. ");
INSERT INTO sbk_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Hwa huje alongozi sebhatisizya hwabhala bhabhabhomba aminza, huje hwabhala bhabhabhomba embibhi. Huje oziliha kutohwogope abhe mamlaka? Bhombaga gagali miza, na bhenze huntufyee hwego. ");
INSERT INTO sbk_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Hwa huje ulitumwa wa Ngolobhe waho hwaajili yemiza. Nkashile obhabhombe gagali mabhibhi, ogopa; hwa huje sagabeba ipanga bila sababu. Hwa huje ulitumwa wa Ngolobhe, owalipe eshisasi hwikuni humwanya yola wabhomba embibhi. ");
INSERT INTO sbk_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Hwe lyo ohwaziwa ahwiyishe, sehwisababu yekuni, huje nahwe sababu yesebho. ");
INSERT INTO sbk_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Hwaajili yega olipa ekodi. Hwa huje bhebhali ne mamlaka bhatumwa bha Ngolobhe, ebho bhabha hwedelesha abhombe embombo ene. ");
INSERT INTO sbk_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Bhapeli kila omo hala habhadayi: nkakodi hwu kodi; nkaushuli hwaziwa ushulu; nkawoga uwaziwa waaga; nkanshinshi ehwaziwa nshinshi. ");
INSERT INTO sbk_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Mgajedaiwe no mutu ahantu hohoti, hahahwaziwa oluganano mwemwe hwa mwemwe. Hwa huje olawagene oparamani wakwe amalile ikalata. ");
INSERT INTO sbk_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Hwa huje, “Sagaobhabhombe umalaya, sagaobhagoje, sagaobhahwibhe, sagaobhazilishe,” na kashile ehweli endajizo eyamwabho yope, emanyishe ashilile eli: “Obhahugane oparamani waho nashi wewe umwene.” ");
INSERT INTO sbk_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","OLugano sagabhibhi hwa paramani hwa muntu. Hwelyo ulugano malishilo hwe nkalata. ");
INSERT INTO sbk_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Hwu sababu yeli, mmenye uwakati, huje hufishile wakati wafume muntulo. Huje olokole wetu ufishile papepe nu wakati wula owelweteshelo olwewandilo. ");
INSERT INTO sbk_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Nusiku hwendeleye, nusanya upalamiye. Tibheshe ashenje amadala agenkisi, tikwate esilaha ezye lukhozyo. ");
INSERT INTO sbk_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Nativalaje shinza shinza, nashi mlukhozyo saganashi eshikulukulu eshembibhi nashi akholwe. Natigajebhale humbibhi nashi azilishe saga ugawezya aimale, nashi ashilile uwivu ne jela. ");
INSERT INTO sbk_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Huje tikwale Ogosi oYesu Kilisti, natiga jebheshe idala ashilile obele, huzilisyo zyakwe. ");
INSERT INTO sbk_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Poshelaji wowoti olaobhinu hwelweteho, mganje huloonje ahusu esebho zyakwe. ");
INSERT INTO sbk_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Omuntu omo ali nulweteho ogwalye hohoti, uwamwabho ono yizu alya enyanyu zyene. ");
INSERT INTO sbk_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Omntu walyakila hantu aganje humwisije ola wasagalya kila hantu. Nula wasagalya kila hantu asiloonje owamwabho walyakila hantu. Hwa huje Ongolobhe tayali aposheye. ");
INSERT INTO sbk_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Awe we nanu, awe hwohuloonga otumwa wa muntu owenje? Ila hwagosi wakwe huje ahwemelela au agwa. Lakini abhabhosehwe, hwa huje Ogosi awezya hubhombele huje ayemelele. ");
INSERT INTO sbk_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Omuntu omo alimwene isiku limo siyo elya mwabho. Owa mwabho alola ensiku zyotizili sawasawa. Eshi kila muntu ahwizilisye hu njele zyakwe mwene. ");
INSERT INTO sbk_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ola wakhata insiku, akhata hwaajili ya Gosi. Hwa huje ahupela Ongolobhe asalifye. Ola wasagalya ahwiziga kutoalye hwaajili ya Gosi. Wope afumwa asalifye hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Hwa huje numo wakhala hwu nafsi yakwe, na numo omwinza hwaajili yamwene yuyo. ");
INSERT INTO sbk_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Hwa huje nkashile tihwizya, tihwizya hwaajili ya Gosi. Nakashile fifwa fifua hwaajili ya Gosi. Huje nkashile tihwizya au tifwa tilimali ya Gosi. ");
INSERT INTO sbk_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Hwa huje hwunsini eli uKilisti afwiye nahwizye nantele, huje abhe Gosi wabhoti abhafwe na bhabha hwendelela ahwizye. ");
INSERT INTO sbk_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Lakini awe, huyenu ohuloonga oholo waho? Nawe huyenu ohumwisha oholo waho? Hwa huje ateteti tihwemelela hwitagalila elitengelya loogwe elya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Hwa huje lisimbilwe, “Nashi sehwizya,” ayanga Ogosi, “Hulini kila lifugamo lyaifugamila nakashile melee lwaifumwa atofye hwa Ngolobhe.” ");
INSERT INTO sbk_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Huje bhasi, kila omo wetu aifumwa abhazye hwakwe mwene hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Hwegoo, tisiyendelele natele aloongane, lakini badala yakwe aamula sanyona, huje numo wabhabheshe eshikwanzo au otego hwaholo wakwe. ");
INSERT INTO sbk_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Na emenye na esogwelwe hwa Gosi oYesu, huje nahamo ahantu hahali nanjisi hene. Nihwayuyo tu ahwisebhanya huje hohoti najisi, hwa huje hwa mwene lyoli najinsi. ");
INSERT INTO sbk_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Nkashile hwusababu yeshalye oholo waho azugumila, sagaojena natele mwidala lye luganano. Osinakanye hweshalye shaho omuntu hwaajili yakwe oKilisiti afwiye. ");
INSERT INTO sbk_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Hwesho mgaje hweteshele amadala genyu aminza gasababisye abhantu abhashente. ");
INSERT INTO sbk_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Hwa huje umwene owa Ngolobhe sehwaajili yefyalye nevyamwele, huje hwaajili yelyoli, olweteho nesogwe ashilile Opepo Ofinjile. ");
INSERT INTO sbk_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Hwa huje ola wahutumishila uKilisiti hwidala eli ayeteshelwe hwa Ngolobhe na ayeteshelwe hwa bhantu. ");
INSERT INTO sbk_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Hwa huje bhasi, natibhale humambo gelweteho neega gegahuzenga omuntu nuwamwabho. ");
INSERT INTO sbk_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Usinankanye embombo ya Ngolobhe hwusababu yeshalye. Evintu vyoti hwahuje vinza, lakini vibhibhi hwa muntu ola walya vihusababisha yuyo abumele. ");
INSERT INTO sbk_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Shinza kutolye enyama, wala amwele edivai, wala hohoti hweho oholo waho hahuvisya. ");
INSERT INTO sbk_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ezyo zyelweteho natele zyohi nazyo, zibheshe awe umwene nu Ngolobhe. Anutabhalo ola wasahwilonga mwene nashi hala haheteshela afume humwoyo. ");
INSERT INTO sbk_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Wali newasiwasi aloogwilwe nkashile alya, hwusababu sagashifumilana ne lweteho. Na hohonti hesahafumilana ne lweteho, nahohonti hesahafumilana ne lweteho ezyo mbibhi. ");
INSERT INTO sbk_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Eshi atee tetili nedadi tihwaziwa ahweje ulembezu wabhala alembezu, satihwaziwa ahwilole tete. ");
INSERT INTO sbk_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Kila omo wetu asogwaje upalamani wakwe hweli ega minza, hwidala lya hulengange. ");
INSERT INTO sbk_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Hata oyo Kilisiti saga ahwilolaga yuyo mwene. Hwa huje alinashi sagasimbilwe, “Esnundo zyabhala bhabhalijile ganajile nene.” ");
INSERT INTO sbk_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Hwa hohonti hahatagaliye asimbwe, hasimbilwe hwutilogozye, hwa huje ashilile ajimbe naashilile apelwe umwoyo nendajizyo angatili nelyomi. ");
INSERT INTO sbk_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Eshi Ongolobhe umwene wajimbe nawatipele omwoyo naabhapele abhe nensebho sawa nahwakila omo alengane nu Yesu uKilisti. ");
INSERT INTO sbk_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Awezizye abhombe eshi husebho emo muwezye humwinyile hwiilomu limo Ongolobhe nu baada hwa Gosi wetu uYesu Kilisti. ");
INSERT INTO sbk_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Hweeli posheli kila oomo, nashishila uKilisti nabhaposheye, hwatafihwe hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Huje eyanga huje uKilisti abhehwelwe tumwahwa tohala hwidala elilyoli hwa Ngolobhe. Abhombile eshi huje awezye abhonesye endajizyo zye zyafumile hwa madaada, ");
INSERT INTO sbk_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","na hwa mataifa humwembele Ongolobhe hwuwenee yakwe. Nashi salyandihwe, hwa huje embafumwe esifa huliwe nalengane nabhe mataifa nahwembe esifa ashilile itawa lyakwe.” ");
INSERT INTO sbk_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Nantele eyanga, “Shanji, amwee mubhatu bhemataifa, pandwemo na bhantu bhakwe.” ");
INSERT INTO sbk_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Nantele, “Mtofyaje Ogosi, amwe mmataifa mwetileshi bhemataifa; goti bamwinulaje umwe.” ");
INSERT INTO sbk_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Nantele oIsaya ayanga, “Hwaibha izii elya Yese, na oomo aibhomba atabhale amwanya yemataifa. Amataifa bhaibha nulusobhelo ashilile omwene.” ");
INSERT INTO sbk_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Eshi Ongolobhe owe sobhezyo abhamemwe nashee hwoti nulweteho hwa mweteshele, huje muwezye ahojelele ashilile esobhezyo, hwidandi elya Ompepo Ofinjile. ");
INSERT INTO sbk_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Nene nimwene evutililwe namwe, mwaholo bhane. Evitulilwe namwe mmemile uwinza, mmemile enjele zyonti. Evutililwe huje amwe muwenza apelane kila oomo nuwamwabho. ");
INSERT INTO sbk_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Lakini ewandiha hwelyomi nsini hulimwi humwanya yemambo gagahweli huje ebhakomboshe nantele, husababu yeshipawa shepewilwe nu Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Eshipawa eshishali huje embetumwa wa Yesu Kilisti watumwilwe hwa mataifa, ahwifumwe nashi oodimi we bhangili lya Ngolobhe. Nezagawezye abhombe eshi ahwifumwe hwane hwamataifa hubhe hukondelwe, nahubhehwelwe hu Ngolobhe hwidala lya Opepo Ofinjile. ");
INSERT INTO sbk_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Huje ashee hwane huli mwidala lya Kilisti nu Yesu nashilile hwa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Huje sembwezizye alombelele wala ayanje lyolyonti huje uKilisti andengenye ashilile hwane ahwishe hwa mataifa. Eega amambo gamalishe hwizuu nidala, ");
INSERT INTO sbk_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","hwilyomi ololesyo wemagosi, nahwilyomi elya Ompepo Ufinjile. Eli lyali hufume hu Yelusalemu, na zyogolele ohutali nashi iliriko, ebwezye ahweje hwoze humalisho wibhangili lya Kilisti. ");
INSERT INTO sbk_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Hwidala eli, esebhozyane elilumbelele ibhagili, lakini sepala uKilisti pamanyishe hwitawa, huje esiwezye azenje pamwanya yesingi gwa muntu owamwabho. ");
INSERT INTO sbk_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nashi sagasimbilwe: “Eebho hwamwene sebhali nalyolyoti lyamwene ahenzele bhaihulola, nabhala bhasagabhamwovwezye bhenzehumanye.” ");
INSERT INTO sbk_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Hweli naliezigwilwe marahaminji ahwenze mwenyu. ");
INSERT INTO sbk_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Lakini esalezi, sendinesehemu yoyoti ashile amikoa egaa, naendiieziliha hwumaha minji ahweze hwulimwi. ");
INSERT INTO sbk_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Huje mara zyoti nkembale Hispania etegemela abhalole nkeshile, etwalwe hwidala lyane namwe, baada yasogwe akhale namwe humdaa. ");
INSERT INTO sbk_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Lakini esalezi embala hu Yelusalemu abhalishe aumini. ");
INSERT INTO sbk_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maana bhasogwelwe abhantu bha hu Makedonia na bha hu Akaya abhombe osanguzi welyoli hwabhala bhabhasagali nahantu bhamobhamo mwaumini ohwo hu Yeslusalemu. ");
INSERT INTO sbk_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Lyoli, lwalilugano lwabho, nalyoli bhalinebha madeni gabho. Maana nkashile amataifa bhashilikile ashilile amambo gabho age mpepo, bhanamadeni bhope natele nabhalishe evitu vyesagabhali navyo. ");
INSERT INTO sbk_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Eshi, natele amalezyezye evi nabhene nayerane humandodo ega hwabhene, anenaibhala mwidala padwemo namwee ooho hu Hispania. ");
INSERT INTO sbk_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Emenye huje, nantele nkenenze hulimwi, naihweza ekamilishe hwuwinji wa Kilisti. ");
INSERT INTO sbk_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Esalezi embasunda, bhaholo, hwa Gosi wetu uYesu Kilisiti, nahwigane lya Umpepo, huje mubhe padwemo nane ashirile apute hwenyu hwa Ngolobhe hwa ajili yalini. ");
INSERT INTO sbk_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Putaji huje epone afume hwa bhene bhasaga bhane nshinshi ashilile hu Yudea, na huje embombo yane ohwo hu Yelusalemu ewezye aposhelelwe nalokole. ");
INSERT INTO sbk_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Putaji huje engenza hulimwi seshiye ashilile huwinza wa Ngolobhe, na huje embepadwemo namwe, embwezye antoye. ");
INSERT INTO sbk_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Nu Ngolobhe owewene abhe padwemo namwe mwentii. Amina. ");
INSERT INTO sbk_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Eembapela hulimwi o Fibi oilombo wenyu, oyoo tumwa webhanza lyelili ohwo Kenkrea, ");
INSERT INTO sbk_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ili huje muwezizye huposhele ashilile hwa Gosi. Bhombaji eshi ashilile itawa elye tabhalo elyabhoziwa, na mwemelele padwemo nu mwene ashilile lyolyoti lyabhabhe hwanza umwene. Maana umwene yuyo aalintumwa wa bhinji, nahwaajili yalini nemwene. ");
INSERT INTO sbk_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Mlamshe Priska nu Akila, wabhomba embombo nane ashilile uKilisiti uYesu, ");
INSERT INTO sbk_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ebhoo hutubhalo yane bhahandilefwe na huntabhalo yabho bhene. Na efumiya asalifwe hwabhene, nasaga nene nimwene, nahwabhala humabhanza goti age mataifa. ");
INSERT INTO sbk_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Lilamshi ibhanza lyalili mnyumba yabho. Lamshi Epanieto omwinza wane, oyowepapwe wahwade hwa Kilisti ashilile hu Asia. ");
INSERT INTO sbk_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Lamshe u Maliamu abhombile embombo hwilyomi hwaajili yalimwii. ");
INSERT INTO sbk_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mlamshe Androniko nu Yunia, bhamwetu, nabhabhapinyilwe padwemo nane. Nabhapapepe padwemo natumwa, bhabhatagaliye humanye uKilisti sesele aane. ");
INSERT INTO sbk_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mlamshe Ampliato, omwinza wane ashilile Ogosi. ");
INSERT INTO sbk_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mlamshe Urbano, ubhomba mbombo padwemo nane ashilile uKilisti nu Stakisi omwinza wane. ");
INSERT INTO sbk_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mlamshe Apele, umwene ahweteshelwa ashile uKilistii. Bhalamshi bhoti bhabhali mnyumba ya Aristobulo. ");
INSERT INTO sbk_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Mndamshile Helodioni, ono wa mwentu. Mndamshile bhoti bhabhali mnyumba ya Narkiso, bhabha hweli ashilile Ogosi. ");
INSERT INTO sbk_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Mndamshile Trifaina nu Trifosa, bhabhabhomba eembombo hwilyomi ashilile Ogosi. mlamshe Persisi omwinza wabhombile embombo shinza hwa Gosi, ");
INSERT INTO sbk_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Mndamshile o Rufo, wasalulilwe ashilile Ogosi inunyina wakwe nu walini. ");
INSERT INTO sbk_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Mlamshe Asinkrito, Flegoni, Herime, Patroba, Herima, na hola bhoti bhabhali padwemo nabhene. ");
INSERT INTO sbk_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Nisalimie Filologo na Yulia, Nerea na dada yake, na Olimpa, na waumini wote walio pamoja nao. ");
INSERT INTO sbk_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Mndamshile omoomo hubusu ifinjile. Amabhanza goti ashilile uKilisti gabhalamhaa. ");
INSERT INTO sbk_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Salezi embasunda, mwaholo, asebhanye amwanya yebho bhabhasababisha anyapane nyapane nazijilwe. Bhabhala shenje nendajizyo zyebhalajiziwe. Galushi mfume hwa bhene. ");
INSERT INTO sbk_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Hwa huje abhantu nashebha sebhatumwa bha Kilisiti Ogosi, bhalisha amavyanda gabho bhebho. Hunogwa zyabho enyololo nasalifye hwilega bhabhakhopela omoyo gasaga galogwe. ");
INSERT INTO sbk_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Hweli elenjesya hunshinshi yenyu muhufishila kila omo. Huje, esoywelwe humwanya yenyu, lakini embaza aamwe mubhenagolele ashilile na minza, namgajebhe nalogwe hwitagalila lye mbibhi. ");
INSERT INTO sbk_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ongolobhe owewinza sagabhakhale hugoje usyetano pansi yenyayo zyenyu. Ewene eya Gosi uYesu Kilisti ebhe padwemo namwe. ");
INSERT INTO sbk_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotheo, obhomba mbombo nane, abhalamha nu Lukio, Yasoni nu Sospeter, bhamwetu bhane. ");
INSERT INTO sbk_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Nene, Tertio, nahandishe ikalata elii, embalamuha ashilile itawa lya Gosi. ");
INSERT INTO sbk_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayo, aandelile nahwibhanza lyoti, libhalamhaa. Erasto, wakhata evintu vye shijiji, abhalamhaa, padwemo nu Kwarto wali holo. ");
INSERT INTO sbk_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Esalezi hwamwene yuyo wali nikhone agabhomba huje mwemelele alengane ne bhangili namamanyisizyo ya Yesu Kilisti, alengane nalolesewe husili yefisilwe humahaminji, ");
INSERT INTO sbk_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","lakini esalezi gamalishe nagaloleshe nabhehwe apazelu nagagasimbilwe nakhohwa alengane nadame hwa Ngolobhe uwewilawila hunshinshi eyelweteho lumo lwebhamataifa goti? ");
INSERT INTO sbk_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Hwa Ngolobhe mwene uwe nshinshi, ashilile uYesu Kilisti, hubhe neutukufu ugwe wilawila yoti. Amina ");
INSERT INTO sbk_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","U Paulo, wakiziwilwe nu Kristi Yesu abhe sontezwi whimagano ga Ngolobhe, nu Sosthene wholo wetu, ");
INSERT INTO sbk_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","whishibhanza sha Ngolobhe lyalyaleho hu Korintho, whabhala ambao bhabhe whelwe hushiputo wha Yesu Kristi bhabhali bhakwiziwe abhe bhantu bhasafi. Tihubhasimbila pia bhala bhonti bhabhahulikwizwa itawala lwa Gosi wetu uYesu Kristi kati amahali ponti, Ugosi wawo nu wetu. ");
INSERT INTO sbk_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ineema nuwinza ibhe humwenyu afume wha Ngolobhe baba wetu nu Gosi wetu uYesu Kristi. ");
INSERT INTO sbk_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Insiku zyonti uhunsalifwa Ongolobhe wane kwa ajili yenyu, afwatanaje ni neema ya Ngolobhe ambayo uKristi uYesu abhapiye. ");
INSERT INTO sbk_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Abhawombile abhe bhatabhazi katika kila idala, katika ayanje pamoja ni njele zyonti. ");
INSERT INTO sbk_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Abhawombile atabhazi, hansi usimishizi ahusu uKristi aje ahakikizwe abhe lyoli peka nawo. ");
INSERT INTO sbk_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Eshi sagamopongoshewa ikalama zishimoyo, hansi shamuli ni hamu ya golele ugubulwe wa Gosi wetu uYesu uKristi. ");
INSERT INTO sbk_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ayihubhaimalisya amwe pia hadi humwisho, ili musalaumiwe isiku lya Gosi wetu uYesu Kristi. ");
INSERT INTO sbk_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ungolobhe golosu wabhakwizizye amwe katika uwushirika wa mwanawakwe, uYesu kristi Ugosi wetu. ");
INSERT INTO sbk_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Eshi ihubhalabha nkulo nuyilombo bhane, ashilile widala lay Gosi wetu uYesu uKristi, abhe wonti bheteshe, na kwamba husahabhe ulugabhanyo mmiongoni mwenyu. Ihubhalabha aje mulemane mwenti nahuniya yeka na whikusudi lyeka. ");
INSERT INTO sbk_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Huje abhantu bha munyumba ya Kloe bhambozezye aje huli amalehano gagahendela mumiongoni mwenyu. ");
INSERT INTO sbk_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Indi ni maana ene: Kila weka mwikundi lyenyu ayanga, “Ane ni wa Paulo,” au “Ane ni wa Apolo”, au “Ane niwa Kefa” au “Ane niwa Kristi”. ");
INSERT INTO sbk_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Je! uKristi agabhanyishe? Je! uPaulo ayambele kwa ajili yenyu? Je! mwahozewelwe whitawa lya Paulo? ");
INSERT INTO sbk_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ihusalifwa Ungolobhe aje saga na mozizye wowonti, ila u Krispo nu Gayo. ");
INSERT INTO sbk_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ene yali huje hamuna wowonti wayanje aje mwahozewelwe whitawa lyane. ");
INSERT INTO sbk_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Na nawozizye bha munyumba ya Stephania. Hani yepo, sigihelewa aje namozizye umuntu uwenje wowonti). ");
INSERT INTO sbk_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Afwatanaje U Kristi sagwantumile ahozye ila alombelele ibhangili. Sagaantumile alombelele hunongwa zinjele yishibinadamu, ili aje engovo yikhobhehanyo lya Kristi lisahefwewe. ");
INSERT INTO sbk_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Afwatanaje intumi yikhobhehanyo walangani whabhala bhabhafwa. Ila whabhala ambao Ongolobhe ahubhaokoa, ngovo wha Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Afwatanaje isimbililwe, “Nayihuyinanganya injele yibhibusala. Nayiunganya uwelewa wibhi njele.” ");
INSERT INTO sbk_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Awhi umuntu winjele? awhi winsukulu? awhi wayanje washawishi wense ene? Aje, Ungolobhe sagaayigeuzizye injele yense ene abhe ukwelengusu? ");
INSERT INTO sbk_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Afume ense ileho katika injele yakwe sagayamenye Ongolobhe, yasongwezye Ongolobhe katika ukwelengusu wawo walambele ili whuwaule bhala bhabhawheteha. ");
INSERT INTO sbk_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Whubhayahudi bhawozelezya iishara zimayele na Abhayunani bhawhanza ihekima. ");
INSERT INTO sbk_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Eshi tilombelela uKristi wayembele, wahali visyo wha Bhayahudi na kwelengusu wha Bhayunani. ");
INSERT INTO sbk_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Lakini whabhala ambawo bhakwiziwe no Ngolobhe, Abhayahudi tihunobhelela uKristi hansi engovo ninjele ya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Abhe ukwelengusu wa Ngolobhe uli ninjele ashele abhanada, na uwuzowofu wa Ngolobhe whuline ngovo hani ya bhanadamu. ");
INSERT INTO sbk_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Enyi ukwiziwe wa Ngolobhe humwanya yenyu, kolo nu yelombo bhane. Sagabhinji bhenyu mwapapwilwe katika uwugosi. ");
INSERT INTO sbk_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ila Ungolobhe asaluye ivintu ivekwelengusu vyense ili huvisosye vivilininjele. Ungolobhe asaluye shili zohofu panse hushisosye shishili nengovo. ");
INSERT INTO sbk_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ungolobhe asaluye shila shishili shihali ya pansi na shizalaulilwe panse. Asaluye hata ivintu ambavyo sagavya bhaziwilwe abhe hantu, whuvibheshe saga hantu ivintu vivileho ni thamani. ");
INSERT INTO sbk_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Awombile eshi ili asahabhe wowonti wali ni sababu wahujinule whilongolela lyakwe. ");
INSERT INTO sbk_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Husababu yishila Ungolobhe shawombile, isalezi muli muhati ya Kristi uYesu, wafanyishe njele kwa ajili yetu wha Ngolobhe. Aleho haki yetu, golosu na waule. ");
INSERT INTO sbk_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Hansi amatokeo, hansi iizu shaliyanga, “Wahujipala, ajipale wha Gosi.” ");
INSERT INTO sbk_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Lwanahenzele humwenyu kolo nu yilombo bhane, saganahenzele namazu giushawishi ni njele hansi ahusu Ungolobhe. ");
INSERT INTO sbk_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Nahamuye asagamanye shoshonti lwanahelo namwe ila wha Yesu uKristi, numwene wateseshe. ");
INSERT INTO sbk_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Nalinamwe whuu dhowofu, huwogo na katika ayinje hani. ");
INSERT INTO sbk_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Niizu lyane lyalombelele huline sagawhaleho whumazu giushawishi ni njele. Badala yakwe, gali katika hufunule uPepo ne ngovo, ");
INSERT INTO sbk_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","aje olweteho lwenyu lusabhe katika injele yabhanadamu, ila katika engovo ya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Eshi tihuyiyanga injele mumiongoni mwa bhantu abhagosi, lakini saga hunjele yense ene au yabhatabhala bhinyakati ezi, ambawo bhashila. ");
INSERT INTO sbk_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Badala yakwe, tihuyiyanga injele ya Ngolobhe katika ilyoli lilifisishe, injele yifisishe ambayo Ungolobhe ayisaluye kabla yinyakati ziutuntumu wetu. ");
INSERT INTO sbk_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Nomo wowonti wa bhatabhala bhinyakati ezi wayemenye injele ene, nkabhayimenye katika inyakati zila, andisaga bhanyenvega uGosi wituntumu. ");
INSERT INTO sbk_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ishi hansi shayasimbwilwe, amambo ambayo nalimo iliso lililolile, nalimo ikuta lyalyahevwezye ensewo sagazyasebhele, amambo ambayo Ongolobhe aga andayile kwa ajili yabhala bhagene umwene.” ");
INSERT INTO sbk_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ege mambo gagali Ongolobhe agakwinkuye humwetu ashilile uMpepo, afatanaje uMpepo achunguzya shila hantu hata amambo gamuhati yakwe. ");
INSERT INTO sbk_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Afwatanaje wenu amenye ensewo zyamntu, isipokuwa roho ya mtu ndani yake? Hivyo pia, hakuna mambo ya ndani ya Mungu, ila Mpepo wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Eshi sagataposheleye umoyo gwense, eshi uMpepo wafuma wha Ngolobhe, ili aje tiwezye amanye whiwaushe amambo gatapewilwe no Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Tiyanje amambo ega whimazu gagali njele, whamuntu sagawezya amanyizye, ila uMpepo awhutimanyizya. Umpepo ahugabadilinsa amazu gahumoyo hunjele yi shimoyo. ");
INSERT INTO sbk_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Umuntu wasaga wishimoyo sagaposhela amambo gagali ga Mpepo wa Ngolobhe, afwatanaje ego giwalangani hukwakwe sagawezya hugamanye afwatanaje gamanyiha shimoyo. ");
INSERT INTO sbk_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Hola wishimoyo alonje amambo gonti. Ila alongwa na bhanje. ");
INSERT INTO sbk_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Yunanu awezya amanye ensewo zya Gosi, wawezya humanyizye?” Ila tilinensewo zya Kristi. ");
INSERT INTO sbk_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Nane, kolo nuyilombo bhane, saga nayanjile namwe hansi abhantu bhishimoyo, hansi abhantu bhebhele. Hansi abhana abhadodo wha Kristi. ");
INSERT INTO sbk_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Nabhamwelezezye izibha sagenyama, afwatanaje sagamwali tayali alye inyama. Nahata isalezi sagamulitayali. ");
INSERT INTO sbk_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Afwatanaje amwe musele mlibhebele. Afwatanaje uwivu na madiho galoleha mmiongoni mwenyu. Eshi sagamukhala alengane nobele, nahuje, sagamujenda hansi ikawaida yishibinadamu? ");
INSERT INTO sbk_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Afwatanaje weka ayanga, “Ihumwanza u Paulo” Uwamwawo ayanga,” ihumwanza u Apolo,” sagamukhala hansi abhanadamu? ");
INSERT INTO sbk_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","U Apolo yunani? nu Paulo yunanu? Bhatumi bhola wamwa mweteshe, whola wowonti ugosi apelile ijukumu. ");
INSERT INTO sbk_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ane natolile, u Apolo aponyizye amenze, ila Ongolobhe akuzizye. ");
INSERT INTO sbk_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Eshi, watolile na waponyizye amenze saga shoshonti. Ila Ungolobhe wakuzya. ");
INSERT INTO sbk_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Eshi watota na waponya amenze wonti hantu heka, na kila weka aiposhela umushahala gwake alengane ni mbombo yakwe. ");
INSERT INTO sbk_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Afwatanaje ate tilibhawomba mbombo bha Ngolobhe, amwe muli bustani ya Ngolobhe, lijengo lya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Alengane ni neema ya Ngolobhe yimpewilwe hansi uzenji ugosi, naubheshele umusingi, nu wamwawo azenga pamwanya yakwe. Ila umuntu abhe shinza lwazenga pamwanya yakwe. ");
INSERT INTO sbk_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Alenganaje nomo uwamwawo wawezya azenje umusingi uwamwawo hani yaguguzengwilwe, ambago yu Yesu Kristi. ");
INSERT INTO sbk_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Isalezi, nkesho weka wenyu azenga pamwa yakwe whiwelihela, ihela, amawe gisamani, amkwi, amasole, au amatondo, ");
INSERT INTO sbk_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","imbombo yakwe yayibhawazi, huzelu wishasenya wayihulolesya. Afwatanaje yailolesewa numoto. Umoto gwailenga uwinza wimbombo yakila weka shawombile. ");
INSERT INTO sbk_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Nkesho shoshonti umuntu shazenjile shaisyala, umwene aiposhela izawadi. ");
INSERT INTO sbk_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Nkesho imbombo ya muntu yayiteketela humoto, ayipata ihasala. Ila umwene yoyo ayiwawuliwa, hansi shila ayepile mumoto. ");
INSERT INTO sbk_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Saga mumenye aje amwe mlishibhanza sha Ngolobhe naje uMpepo wa Ngolobhe akhala muhati yenyu? ");
INSERT INTO sbk_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Nkesho umuntu ahuli nanganya ishibhanza sha Ngolobhe, Ongolobhe uyihunanganya umuntu ola. Afwatanaje ishibhanza sha Ngolobhe shinza, nesho namwe. ");
INSERT INTO sbk_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Untu asajikhopele mwene, nkesho wowonti mwikundi lenyu asebha aje ali ninjele katika uwakati owu, abhe hansi “ukwelengusu” ndiyo abhabhe ninjele. ");
INSERT INTO sbk_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Afwatanaje injele yensene ukwelengusu whilongolela lya Ngolobhe, Afwatanaje isimbiwilwe, “Bhakhata abhenjele huhila zyawo” ");
INSERT INTO sbk_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Na tena “Ugosi azimenye ensewo bhinjele nuubatili.” ");
INSERT INTO sbk_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Esho umuntu asajituntumulile abhanadamu! Afwatanaje ivintu vyonti vyenyu. ");
INSERT INTO sbk_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Nke yu Paulo, au yu Apolo au yu Kefa, au anse, au khalo, au afwe, au vintu vivileho, au vyavyaibha. Vyonti vyenyu, ");
INSERT INTO sbk_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","namwe ni wa Kristi nu Kristi wa Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Eshi umuntu aliwazwe ante aje wawomba mbombo wa Kristi wemelezi hwa siri zya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Hueli shashihwaziwa huwemelezi huje wawe wasuwelwa. ");
INSERT INTO sbk_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ila huline ane hantu hadodo hani aje ilongwa namwe, au indongwa ya awantu. Aje sagaihujilonga ane nimwene. ");
INSERT INTO sbk_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Saga ihujilonga ni mwene ane sagaje ane indi nuugolosu yu Bwana yahundonga. ");
INSERT INTO sbk_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Eshi msahatamshe liolionti ilya lonje shagasele amasala gahwezye uBwana. Ahaigalete apazeru amambo gagafisilwe mhinsi na hugaweshe pazelu gahumoyo. Wekaweka ahaiposhela imbombo zyakwe afume hua Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Eshi muasahala muwalendu wane ane ni mwene nu Apolo inshilie idala eli kwaajili yenyu. Aje afume humwetu muwajie amanyile injango usahawale hanii shazyandihwe, “Huje nomo hataweka yali na malingo hwa wamwawo. ");
INSERT INTO sbk_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Eshi yunanu yahwenye payo nu wamwao? Henu ulinaho awe, saga uhaposheye wene? Nkuhaposheye nkasanga mwahawombile esho? ");
INSERT INTO sbk_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Shatayari mlinavyo vyonti vyamwanzanga! Shatayari mliwakami! Shamwandile atawale-aje mkhente haani ashile ate! Lioli, ihuwalawila mkhate uwinza aje tikhante peka namwe. ");
INSERT INTO sbk_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Isewa aje Ungolobhe atiweshele ate awe watume hutuloleshie uumalishilo usitari wa makutanilo aje wantu wawalongwilwe abudye. Tilije watamasha munsi, awatumihwawantu. ");
INSERT INTO sbk_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Ate lilinje walema hwa Kristi, lakini ninyi ni wenye hekima katika Kristo. Tu wanyonge, lakini amwe mlini naha mlinishishima, lakini ate watisyosyezye. ");
INSERT INTO sbk_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Hata isala ezi tihinizala na tumele, sagatilina menda, tukhomwa, sagatuli napakhale. ");
INSERT INTO sbk_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Tuwomba imbombo hani hu nyowezyetu tetete. Watisosyezye, tihuwasaya. ");
INSERT INTO sbk_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Lwatilawa tujimba. Lwatilingwa tupoma myee. Tileho, wahutiwazizya aje sagatuleho munsi tilitakataka humambo gonti. ");
INSERT INTO sbk_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Sagaihwandia amambo ego huwasosye ila huwagomosye amwe avye wana wane wimbaganile. ");
INSERT INTO sbk_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Hata nkhamli wafundizi winchi hwa Kristi, sagamlina wadaada winchi. Ane indi daada wenyu hwa Yesu Ukristi ashilile inzwi. ");
INSERT INTO sbk_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Eshi ihumbalawa mfuante ane. ");
INSERT INTO sbk_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Esho shanahazanga aje itume uTimotheo humwenyu yigene ane mwana ugolosu hwa Bwana. Anza huwawuzisye amadala gane hwa Yesu nanzi shimanyizya iviwanza vivileho ponti. ");
INSERT INTO sbk_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Eshi awamo walinamalingo wawomba aje sangainza humwenyu. ");
INSERT INTO sbk_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ane ihuenza humwenyu shishi uBwana nkasongwe. Hwinzamanye aje sanganjango zyao wene wawalina malingo, imbalahuzyenye ingovu zyao. ");
INSERT INTO sbk_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Umwene wa Ngolobhe sangaulini njago wene uwene uliwi ngovu. ");
INSERT INTO sbk_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mhwanza yenu? Inenze nu desa au inenze nu ulugano wa Ipepo inyinza iya pumu? ");
INSERT INTO sbk_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Tumvyezye inongwa aje muwamo mli wa malaya, mlinumalanya wasanga uleho hata huwantu wa Munsi. Tumvyozye aje umo agona nushi wa udaada wakwe. ");
INSERT INTO sbk_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Namwe mhuitutumla! Badala ya zungumile? Ola yawombile esho ahwanziwa mumwefye awe mwene. ");
INSERT INTO sbk_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Sangatipeka ishibile ishimpepo tilipeka inonjile umwene yawombile isho, aje nahali namwe. ");
INSERT INTO sbk_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Lwamtangama peka hwitawa lya Bwana Yesu nu Umpepo wane ileho epa ingobu izya Bwana Yesu, inonjile umtu oyo. ");
INSERT INTO sbk_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Umuntu uyo itwaliye usietano aje ubele gwakwe unanjishe, impepo yakwe iyokolewe isiku ilya Bwana. ");
INSERT INTO sbk_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Amampoli genyu sagahantu hinza. Sagammenye intavu ndondo inanganya idonge lionti? ");
INSERT INTO sbk_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Myonzyaje mwemwe muwene intavu inzimande, aje muvye donge lipya aje muwe lindazi lisagalisapile hua Kristi, Umwana Ngole wetu ishikulukulu awolilwe. ");
INSERT INTO sbk_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Huje twangaje ishikulukulu sagohuutavu imande, intavu imbiwi, ate tishanje ni indazi lisanga liweshelwa intavu wa ishishi ya nalioli. ");
INSERT INTO sbk_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Nahandishi ikalata yane aje msahasangane na amamalaya. ");
INSERT INTO sbk_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Sagaiyanga aje awamalaya wa Munsi umo msahakhale nao munsi wawahopa, wawaputa uzimu, indi mwepile munsi. ");
INSERT INTO sbk_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ane ihumbasimbila aje msahasangane na wawonti ya kwiziwa sahala nendu hwa Yesu alafu malaya yanyonywa, yahopa yaputa uzimu yalinga yaholwa, hatashale msahalye nao umuntu yalio esho. ");
INSERT INTO sbk_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Inzahuwalonje wele wawali honzi yishwanza? Amwe sangamhuwalonga wawali msihi wanza? ");
INSERT INTO sbk_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Eshi Ungolobhe ahuwalonga wawali honze. “Mwefyanji umntu umiwi yali humwenyu” ");
INSERT INTO sbk_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Umtu weka lwawa ni shinda nu wamwao awala hushitaki hwibaraza lya wasagawaputa? ");
INSERT INTO sbk_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Sagammenye aje wawaputa wanzahulo uje awamunsi? Mzahuwalonje wa munsi, sangamngawezya akata amambo yasagalisawa? ");
INSERT INTO sbk_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Sanga mmenye aje tinzahuwalonje awatumi? shipimo wele hanii shantingawezya ahuamle amambo gi maisha ega? ");
INSERT INTO sbk_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Tingawezya alonje amambo gi maisha ega, shonu mhwanza hugatwale inongwa hwawasaga wemelenye hushiwanza? ");
INSERT INTO sbk_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Iyanga ega hu soni yenyu. Nomo yali ninjele pahati yunyu yakwelenye aweshe amambo shinza pahanti ya waholo na waholo? ");
INSERT INTO sbk_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Eshi shileho umputi weka awala hubalaza dhidi ya mputi uwamwao ni nongwa iwehwa hwilongolela lya nonzi yasanga aputa! ");
INSERT INTO sbk_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Lioli aje hulishida hwawa Kristi gagaletie amalawa humwenyu. Shonu msahalawe na mawiwi? Shonu mhwetehe ahopelwe? ");
INSERT INTO sbk_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Lakini muwombile imbiwi na ahopelwe awamo ewo wawasahala, na walendu awenyu! ");
INSERT INTO sbk_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Sanga mmenye aje wasaga wawomba inyinza saga wahaipata uumwene wa Ngolobhe? Msahahweteshe ilenka. Awabeshe, wawaputa isanamu, awamalaya, awafilaji, awalawiti, ");
INSERT INTO sbk_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","awiwa, uchoyo, wawakhola, wawahopa, wawaliga, numo katiyenyu yahaipata uumwene wa Ngolowe. ");
INSERT INTO sbk_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Ewo wahali kati yenyu amwe eshi tayari moziwe. Nantele tayari moziwe tayari mbaguliwe hwa Ngolobhe, nantele muwombwilwe walioli hwilongolela lya Ngolobhe hwitawa lya Bwana Yesu Ukristi nu Umpepo wa Ngolowe wentu. ");
INSERT INTO sbk_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“Ivintu vyonti vilisawa”, lakini saga vyonti vilinifaida. “Ivintu vyo vilisawa huline,” lakini sanganitawaliwa hata na heka kati yenyo. ");
INSERT INTO sbk_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Ishalye ni kwa ajili ya vyanda na ivyanda ni kwa ajili ya shalye,” lakini Ungolobhe ahaivyefwa vyonti. Ubele saga uwombwilwe kwa ajili ya umalaya, badala yakwe, ubele wa Bwana, na Ubwana ananza huwombele ubele. ");
INSERT INTO sbk_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Ungolowe ahazyoshenzye uBwana nate shesho ahaitizyosya hu ngovu zyankwe. ");
INSERT INTO sbk_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Saga mmenye aje amabele genyu gawungene nu Kristi? Nantele hutwale hwa wamalaya? Sagaiwajie! ");
INSERT INTO sbk_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Sagamamenye aje yawongana nu malaya ali beli gwenka nao? Nanzi izwi shaliyangaga, “Wawele wazawe bele gweka.” ");
INSERT INTO sbk_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Lakini yawongana nu Bwana awa mpepo nu mwene. ");
INSERT INTO sbk_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Ishembelaji izinaa! “Umuntu yawomba imbiwi hubele gwakwe mwene. Lazima zinaa, mtu hutenda dhambi dhidi ya mwili wakwe mwenyewe. ");
INSERT INTO sbk_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Sanga mumenye aje amabele genyu mlishiwanza sha Umpepo Ufinjile, yakhala mhanti yunyu, ola yamwahapewilwe afume hwa Ngolobhe? Sanga mmenye aje sanga mwemwe muwene? ");
INSERT INTO sbk_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Aje mwahakalilwe hugalama eshi tukuzyanji Ungolobhe hu mabele genyu. ");
INSERT INTO sbk_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ahusu amambo ngamsimbiye: Huli isala aje shinza unume asahag'one nushe wakwe. ");
INSERT INTO sbk_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Walakini eshi injelo nyinchi iya zinaa shila ashe awe nu nume wakwe, na shila ashe awe nu nume wakwe. ");
INSERT INTO sbk_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Unume ahwanziwa apele ushi ihaki yakwe iiyahwengama, shishila ushi nape hwanume. ");
INSERT INTO sbk_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Saga yushi yatawala ubele gwakwe, nume. Na shishila unume nape sagatawala ubele gwake ila ushialinao. ");
INSERT INTO sbk_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Mngaje ahwimane lwamgona peka, maana mwentehene masala gengo. Muwombaje shesho nkamzahugaje amasala gapute. Epo mzawezye awelelano nantele peka, aje usietono asahahwezye huwapele ingelo nkhasanga muwe ni kiasi. ");
INSERT INTO sbk_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Walakini iyanga ega amambo ninene sagaje malajizyo. ");
INSERT INTO sbk_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Inyonywa aje shila muntu angahali nazine shindeho. Eshi shila weka alinishipaji shakwe afume hwa Ngolobhe. Ono alinishipaji eshi, ola alinishipaji eshi. ");
INSERT INTO sbk_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Hwawasaga wengwilwe na awafyelwe inyanga aje shinza aje wasangale bila ahwengwe, nanzi sindehone. ");
INSERT INTO sbk_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Walakini nkasangawawajie huizijile wahuanziwa ahwengwe. Aje aheri ahwengwe kuliko anyonywe. ");
INSERT INTO sbk_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Eshi hwawala wa wegwilwe ihimbapela indajizyo, saga nene ila yu Bwana. “Ushi asahalehane nu nume wakwe.” ");
INSERT INTO sbk_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Eshi nkanza alehane afume hwa nuwene asangale shesho asahahwenge, au nkasangashesho akondane nunumeo na unume asahapele.” ");
INSERT INTO sbk_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Walakini wawasangee iyanga- ane, saga yu Bwana- aje nkaholo wowonti ali nushi yasanga aputa ayetesha akhale nao, sagahwaziwa huneshe. ");
INSERT INTO sbk_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Nkashee alinunume yasagaputa na ahwenteha ahale nao asahaneshe. ");
INSERT INTO sbk_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Hwa nume yasanga aputa ahoziwa nola yalinu lweteho ushi wakwe. Na ushi yasanga aputa ahoziwa nola unume yalinulweteho. Nkasanga sishesho awana wwenyu indisaga wazelu, walakini ulioli wozilwe. ");
INSERT INTO sbk_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Umpenzi yasagaputa nkasongola asongalaje. Hunamna eyo, usahala nendu sagawapinywa ni ndopo yao. Ungolobhe atikwizizye akhale huamani. ");
INSERT INTO sbk_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Umenye wele aje ushi angakombola unumeo? Au umenye wele aje unume angakombola ushi wakwe? ");
INSERT INTO sbk_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Shila weka ahale amaisha hwa Bwana shawagawiye, shila wweka nanzi Ungolobhe shakwizizye awene. Owu longozi wane huviwanza vyonti. ");
INSERT INTO sbk_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Aleho yahaleho atahiliwe ahakwizi welwe akombolewe? Asijaribu kuondoa alama ya tohara yake. Yupo yeyote aliyeitwa katika imani hajatahiriwa? Sanga ahwaziwa atahiliwe. ");
INSERT INTO sbk_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Hueli indola atahiliwa au sanga atahiliwe nagamo amatatizo. Shashili na matatizo hu tii iagizo lya Ngolobhe. ");
INSERT INTO sbk_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Shila weka asagale shakwizizye Ungolobhe na hukombole. ");
INSERT INTO sbk_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Uhali muwomba mbombo amasala Ungolobhe lwahakwizizye? Usahasaje ahusu elyo. Nkashele uwajie awe huru wombanga shesho. ");
INSERT INTO sbk_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Hwa weka yahakwiziwilwe nu Bwana aje muomba mbombo uyo umntu huru hwa Bwana. Nazi shila weka yali huru lwahakwiziwilwe akombolewe awe muomba mbombo wa Kristi. ");
INSERT INTO sbk_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Amwe mkalililwe hu hung'alama hije msahawe waomba mbombo hwa wantu. ");
INSERT INTO sbk_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Wasahala na walendu wane, humaisha gonti shila weka ahakwiziwilwe akombolewe tusagale shishesho ");
INSERT INTO sbk_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Eshi wala wonti wagawejile kamwe sanga indi ni ndajizyo afume hwa Bwana. Ila ihumbapela iseo zyane nazi shindeho. Husanjilo zya Bwana, zizihuaminiha ");
INSERT INTO sbk_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Kwa hiyo, isewa eshohunongwa ya malawa, shinza unume asagale nazi shaleho. ");
INSERT INTO sbk_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Upinyilwe nushi nishiapo sha hwengane? Usahahanze uuhuru afume hwelyo. Uli nu huru wafume hwashe au saganyegwilwe? Usahahanze ushi. ");
INSERT INTO sbk_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Walakini nku yenje sanga uwombile imbiwi. Wasele wala wawahwengana wahugaga amalawa gagali mbalimbali nane ihwanza aje embepuzye ego. ");
INSERT INTO sbk_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Eshi iyanga ishi awasahala na walendu wane amasala mafupi. Ahwande eshi nahuendelele, walaw wawali na hawashe wakhale aje sagawali na washe. ");
INSERT INTO sbk_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Wonti wawazungumie wawenje saga wazungumie na wonti wawashiye wahalije sagawashinye, na wonti wawakala ivintu vyovyonti waweje sanga watawala shoshonti. ");
INSERT INTO sbk_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Na wonti wawawomba imbombo zya munsi waweje sanga washunghuliha liohonti. Yaani amatindo ga munsi idujile humalishilo wakwe. ");
INSERT INTO sbk_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ihwanza unume yalihura humalawa gonti. Unume yasaga ayejile ahwihusisha ni vintu vivihumsu uBwana, isha hupendezye umwene. ");
INSERT INTO sbk_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Lakini unume ya yejile ahuihusisha na mambo ya dunia, namna ya hupendezye ushi wakwe, ");
INSERT INTO sbk_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","abaguhene ushi yasagaayegwilwe au unende ahuihusisha ni vintu kuhusu Bwana, inamna ya huibagula hu bele na mpepo. Lakini ushi yayengwilwe ahuihusisha ahusu ivintu vya munsi namna ya hufulaisye unume wakwe. ");
INSERT INTO sbk_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Iyanga ishi hufaida yenyu, mwemwe na sanga imbeha umtengo humwenyu. Iyanga eshi nalioli aje muwajie huiweshe tayari hwa Bwana bila azigwe nashashonti. ");
INSERT INTO sbk_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Lakini umntu nkasewa apotilwe humuombele ishishi umwanamwali wakwe, huu seo zwake zili ni ngovu hani leha wegane nao nanzishahwanzya. Sanga mbiwi. ");
INSERT INTO sbk_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Lakini awombile shahuanza saga ahwenga nemo ihaja ya ulazima, nkawajiye atawale ihamu yakwe anzawombe shinza nkasanga ahwenga. ");
INSERT INTO sbk_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Oyo yahumwenga umwana mwali wakwe awombe shinza, wowonti ola yasaluye sagaahwenga anza wombe shinza hani. ");
INSERT INTO sbk_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Ushi apinyilwe nu nume wakwe uwakati wa ali momi. Lakini nkuleshe unume afyiye ali huru ahwengwe na wowonti yagene, lakini katika Bwana tu. ");
INSERT INTO sbk_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Bado katika ahwamle hwane anza songwe hani nkahale nazi shaleho. Na isewa aje nane pia indi nu Mpepo ufinjile. ");
INSERT INTO sbk_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Eshi ahusu evyalyae vyavifumizwe sadaka huvifwani(sanamu): timenye huje “ate tenti tili na maarifa.” Amaarifa galeta amadiholelo ulugano luzenga. ");
INSERT INTO sbk_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Nkashele umuntu aiga emenye ijambo fulani, umuntu uyo samenye shashihwanziwa amanye. ");
INSERT INTO sbk_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Nkashe umuntu umo ageewe Ungulubhi, umuntu uyo amanyihene nawo. ");
INSERT INTO sbk_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Alengane nevyalye vyabhafumizye sadaka huvifwani: ate timenye huje “evifwani sehantu pansi epa,” nahaje huumo Ngulubhi uwamwao ali umo owene.” ");
INSERT INTO sbk_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Maana bhahweli bhabhahwetwa bangulubhi bhiinji nkapansi au humwanya neshi shabhali aNgulubhi binji naagosi bhinji.” ");
INSERT INTO sbk_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","“Lelote hulite Ungulubhi ali uumo tu uyo yuise witu, ne vintu vyonti vyafumile hwa mwene, na hwa mwene nate tihweli.” ");
INSERT INTO sbk_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ezi sebhantu bonti bhazimenye maana bhamo bhahavwanaga abhombe emputo ezyeshifwani ata eshi evyalye evi vyabhalya bali shabhaiga sadaka zyeshifwani. Amoyo gabho gatejile gali madhifu. ");
INSERT INTO sbk_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Ishalye sigashaitibhonesya hwa Ngulubhi. Siyo huje tibhabhibhi tee nkasigatilya nantele siyo huje tibhinza tee nkatilya. ");
INSERT INTO sbk_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Lelo mubhe maso nelii peponjajile esho musahauisanye hunongwa ye vyalye na dhifu bhe lweteho. ");
INSERT INTO sbk_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Aweseebha tenye umuntu nkalolile ulya vyamukhenwe umuntu uyo gwavitwa umwoyo gwakwe sewewe wananlanya? ");
INSERT INTO sbk_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Awe nkumenye evintu evinza nevibhibhi usajilaje uwa nuwenyu asahateje hunongwa ya amanye hwaho wope uyo uYesu afweleye. ");
INSERT INTO sbk_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Namubhomba iyavisye abhanje muhuvisya yu Yesu namuvwalazya amoyo gabhantu muhuvwalazya yu Yesu. ");
INSERT INTO sbk_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Lelo eshalye nkashele shisababisya envitwo hwawenje embashileshe eshalye esho ili ensaavisye uholo wane neshalye shane, nashele ulweteho. ");
INSERT INTO sbk_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ane sendi mwaushe? Ane sendi tumwe? Ane sehalolile uYesu Ugosi witu? Amwese mfumozye mbombo yane hwa Yesu? ");
INSERT INTO sbk_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Nkasiga enditume hwabhinje lelo hulimwe enditumwe amwe uhakika wetumwe wane hwa Yesu. ");
INSERT INTO sbk_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Ane ehwiyumila hwa bhala bha bhawiini(bhabhanenya) ane. ");
INSERT INTO sbk_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Eshi ate setili ne haki alye na mwelee? ");
INSERT INTO sbk_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Setili ne haki ahumweje ushe pandwemo nate yali mweteshee neshishabhabhomba atumwe abhanje na holo bha Yesu nu Kefa? ");
INSERT INTO sbk_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Awe nene ne mwene nu Barnaba tasetihwanziwa abhombe embombo? ");
INSERT INTO sbk_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Awe sikali wele yabhomba embombo hugalama zyakwe yuyo? Wenu yalima eviyabho yasiga alya evyamgunda gwakwe? Wenu yasuga eng'ombe yasaamwela amazibha ge ng'ombe zyakwe? ");
INSERT INTO sbk_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Eyanga ezi enongwa zya bhantu? Sheria nayo haisemi haya? ");
INSERT INTO sbk_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Mu sheria zya Musa, zigile usaizije ilomu eng'ombe nepula eviyabho eshi epo izuliyanga mambo ge ng'ombe? ");
INSERT INTO sbk_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Eshi jibha sayanga zya hulite enongwa ewzyo zitiyanga tete, umuntu yalima, alima asuhila huje ehailya wope yavuna avuna ohu asobhela huje embalye vyevuna. ");
INSERT INTO sbk_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Eshi ate nkashele tabhatutiye evya mmwoyo yabha nongwa ate nkatinune evintu vyenyu evyamubele? ");
INSERT INTO sbk_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Eshi abhanje nkashele mubhapela evintu, eshi ate handasetipeliwa ashile ebho, lelo ate tapumile tavumiliye zyonti aje tisananganye izu lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Eshi semumenye aje bhabhabhomba embombo mwikanisa bhalya evya mwikanisa? Shila muntu alyapa mbombo yakwe madhabahuni hupata sehemu ya kile kilichotolewa madhabahuni? ");
INSERT INTO sbk_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Ugusi uYesu ayanjile aje umuntu yalumbilila izu lya Ngulubhi bhalyanje humbombo iyo. ");
INSERT INTO sbk_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Lelo ane sembamelile evi vyonti. Sigaesimba ega ehwanza aje amambo ega gabhombeshe shinza hunongwa yane ahelu ane enfwe, ashile umuntu aje agaluzanye ahwisumbe hwane. ");
INSERT INTO sbk_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Nkashele elumbilila izu sewzilola ezyahwilumbe, lazima embombo eshi. Palwane ane nkasiga elumbilila izu! ");
INSERT INTO sbk_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Nkembombe eshi hwigane lyane endi thawabu. Atasagahwigane lyane bado endinezyabhombe aje embe mwemeleli. ");
INSERT INTO sbk_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Eshi ethawabu yane yenu huje endumbilile izu hugalama zyane nene niliyonayo katika injili. ");
INSERT INTO sbk_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Hata endimwaushe hwa bhonti, nahali boyi hwa bhonti, ili emba abhantu abhinjitee. ");
INSERT INTO sbk_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Hwa Bhayahudi nali neshi Ayahudi, ili embaje Ayahudi. Hwa bhaala bhabhalinesheria nali nesheria, bhabhali nesheria ili embaja bhabhalinesheria. Nilifanya hivyo ingawa mimi binafsi sikuwa chini ya sheria. ");
INSERT INTO sbk_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Hwa bhaala basigabhane ne sheria, bhope nalinginebho iliembaje bhasebhane sheria ya Ngulubhi, enga ane senalihwonze ne sheria ya Musa, nahali ne sheria ya Kristi ili embaje bhonti. ");
INSERT INTO sbk_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Hwa bhololo nali mwololo ili embaje abhololo. Nahali isho hwa bhantu bhonti ili embokole abhantu. ");
INSERT INTO sbk_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Nane ebhomba amambo gonti hunongwa yizyu, ili nane enshiriki ulusayo. ");
INSERT INTO sbk_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Eshi semumenye aje bhabhashindana ashembele bhabha bhabhinji lelo yapata isombo abha muntu umo? Namwe shembelaji ili mupate isombo elye womi. ");
INSERT INTO sbk_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Bhabhomba enyango sebhabhomba embombo eyenje na bali amanyile. Ebho bhabha esho ili bhapate isombo lyali nanjiha, lelo ate tishembela ili tupate isombo lyasigalinanjiha. ");
INSERT INTO sbk_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Nanee siga eshembela wene au akhome engumi, neshi ya khoma umwoyi. ");
INSERT INTO sbk_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Eshi nane ehwilavya ubili gwane nagubhombe neshi uboyi, ebhomba esho huje nanabhalumbilila abhanje nane ensabhe muntu wakhanwe. ");
INSERT INTO sbk_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Ehwanzaje mumanye bhaholo bhane, bheshilume na bheshishe, aje aise bhetu bhali pansi pi bhengo, bhonti bhashilile munsumbi. ");
INSERT INTO sbk_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Bhonti bhahoziwe bhabhe bha Musa muhati munsumbi, ");
INSERT INTO sbk_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","na bhonti bhahaliye eshalye shishila esha umpepo. ");
INSERT INTO sbk_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Bhonti bhamwelile eshamwele shishila esha umpepo. Maana bhamwelile afume mwiwe elya umpepo yabhalondolaga, na iwe lila ali yu Yesu Kristi. ");
INSERT INTO sbk_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Lelo Ungulubhi siga asungungweziwe nabho bhamo na abhantu abhafwe bhanyampene shaha mwijangwa. ");
INSERT INTO sbk_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Ega amambo gali shifani hulite aje tisahazilishe neshi bhaala. ");
INSERT INTO sbk_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Nantele musahabhe bhaputibhe vifwani neshishabhabhombile bhaala. Neshi shazisimbilwe huje, “Abhantu bhahakheye pansi bhalye na mwele, nabhahabhuha ahwanji hu nziliho ye mapenzi.” ");
INSERT INTO sbk_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Tisahabhombe oumalaya neshishabhabhombile abhanje. Bhahafwiye isikulimo abhantu amalongo gabhili elufu na bhantu batatu hunongwa iyo. ");
INSERT INTO sbk_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Tusahalinje Ungulubhi neshi shabhalenjele abhanje bhahalumwilwwe ne nzoha. ");
INSERT INTO sbk_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Nantele tisalulumwe neshi shabalulumwe abhanje, umalaika uwinfwa ahabhabudile. ");
INSERT INTO sbk_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Eshi amambo ega gabhombishe gabheshifani hulite aje tisahabhombe ezyo zyaitaga zya zyabhajile abhanje. ");
INSERT INTO sbk_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Shila muntu yahwilola aje ayemeleye ayenye asahagwwe. ");
INSERT INTO sbk_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Nazimo enjelo zyazibhajile amwe, lyasiga lyekawaida pandwemo nenjelo ezyo Ungulubhi mwinza siga abhabhaleshe abhabhapele undyango ugwafumile mwezyo enjelo. ");
INSERT INTO sbk_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","bhaholo oshane shembelaji emputo ezyeshifwani. ");
INSERT INTO sbk_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Eyanga namwe mulibhantu bhenjele muzigamule mwemwe zyeyanga. ");
INSERT INTO sbk_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Eshikombe shila sheshisayo shatishisaya se ushirika widanda lya Kristi? Na mabumunda gaala gatmensuka se ushirika gwebele gwa Kristi? ");
INSERT INTO sbk_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Hwa hubhe ibiimunda liilimo, nate tetilibhinji tilibele gumo tenti tihwejelela libumunda limo palishimo. ");
INSERT INTO sbk_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Bhenyaji abhantu bha Israeli: Eshi bhaala bhabhalya evya pashiputo sebhashirika bha pashiputo? ");
INSERT INTO sbk_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Enjanjeshi? Aje eshifwa hantu? au eshalya shabhafumizye hushifwani hantu? ");
INSERT INTO sbk_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Evintu vyonti vyabhafumya apagani bhafumya huma Ngulubhi na masyetano, ane segaehwanza amwe abungawe na masyetano na shirikiane nago. ");
INSERT INTO sbk_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Semuwezizye amwelele eshikobe sha Gosi uYesu neshikombe shemasyetani. Semubhaji ye asanganye emeza yagosi uYesu nemeza ya masyetano. ");
INSERT INTO sbk_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Au tihubheshela uGosi ukelo? Au tii nikhone ashile umwene? ");
INSERT INTO sbk_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“Evintu vyonti vinza lelose vyonti vyavihwanziwa. “Nantele sevyonti vyavibhalenganya abhantu. ");
INSERT INTO sbk_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Numo umuntu nkumo yahwanza enyinza zyakwe. Shila muntu handa ahwanza enyinza ezyawamwabho. ");
INSERT INTO sbk_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Mulyanje vyonti vyabhakazya musokoni muganje abhuzizye. ");
INSERT INTO sbk_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Ensi yonti mali ya Ngulubhi, nevintu vyonti.” ");
INSERT INTO sbk_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Nu umuntu nkashele abhaanile mulyanje vyonti vya bhapela bila bhuzilizye. ");
INSERT INTO sbk_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Nkashele abhabhulile huje evi envifumizye hushapagani musahalye. Hii ni kwa ajili yake aliyewaambia na kwa ajili ya dhamiri. ");
INSERT INTO sbk_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Lelo ane siyanga ezamiri zyenyu, eyanga ezamiri ya muntu uwinji. Eshi yenu uwaushe wane ulongwe nu muntu uwenje. Maana kwanini uhuru wangu uhukumiwe na dhamiri ya mtu mwingine? ");
INSERT INTO sbk_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Eshi ane nkemputiye eshalye shane, yenu umuntu uwinje andogaje hushalye shane shemputiye? ");
INSERT INTO sbk_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Eshi hahonti hamubhomba habha hulye awe humwele bombaji zyonti hwitawa lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Musabhavisye Ayahudi awe Ayunani, awe ikanisa(eshibhanza) lya Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Lengaji neshi ane shelenga asungwizye abhantu bhonti humambo gonti. Sehwanza efaida yane nene lelo ehwanza iya bhanje abhinji. Nane eshi aje wokoshe(bhaulwe). ");
INSERT INTO sbk_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Mufuate ani ndeshe ani shihufuata UKristi. Ishi imbatima pipo muhunkumbuha humambo ganti. ");
INSERT INTO sbk_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Imbatima mugakhata amaposhelo ndeshe shingaletile humwinyu. ");
INSERT INTO sbk_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Ishi ihwanza mumanye aje uKristi litwe lya kila nume, wope yenume litwe lya kila nshi, na huje Ungulubhi litwe lya Kristi. ");
INSERT INTO sbk_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kila nume yaputa afumye ubhunabii itwa lyakwe libhanje ligubibashe na ahulikenyensya itwe lyakwe. ");
INSERT INTO sbk_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Kila nshiyalabha au afumye uunabii abhanje agubishe itwe lyakwe nkesaga agubiha itwe ahulikenyensya itwe lyakwe. Pipo alisawa nu muntu yasyenkuye isisi. ");
INSERT INTO sbk_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Nke unshi agubishe itwe lyakwe asyenkule insinsi zyakwe ziwe mfupi. Maana zyinso umuntu unshi asyenkule insisi zyakwe au akatwe basi azigubishe itwe lyakwe. ");
INSERT INTO sbk_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Si hwanziwa unume agubishe itwe lyakwe, pipo umwene shifani ishi tuntumu uwa Ngulubhi. Lakhini tuntumu uwanume. ");
INSERT INTO sbk_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Unume sagahafumile hwa nshi ila unshi ahafumiline nu nume. ");
INSERT INTO sbk_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Unume saga abhumbilwe kwajili ya nnshi. Ila unshi ahabhumbilwe kwajili ya nume. ");
INSERT INTO sbk_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ndyo maana unshi ahwanziwa abhe ishala na mamlaka hwitwe lyakwe kwa sababub ya malaika. ");
INSERT INTO sbk_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Hata shimisho hwa Gosi, unshi nuno bila nume au unume nila nshi, unume numo. ");
INSERT INTO sbk_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Maana ndeshe unshi nkahafumile hwa nume, shishila unume ahafumiline nu nshi. Ni vintu vyonti vifuma hwa Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Muyilonje mwimimwi: Lyoli! unshi apute Ungulubhi bila agubishe itwe lyakwe? ");
INSERT INTO sbk_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Afume imandi sebhamanyizya iya huje unume nkabha ni nsisi intali tuntumhukwakwe? maana apewilwe zila insisi intali ndeshe umwanda wakwe? ");
INSERT INTO sbk_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Je afume imandi sebhamanyizya huje unshi nkabha ni nsisi intali tuntumu wakwe? ");
INSERT INTO sbk_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Maana apewilwe zila insisi intali ndeshe umwenda wakwe. Nku umuntu wowonti ahwanza adalisye wala ishibhanza sha Ngulubhi. ");
INSERT INTO sbk_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Hundajizyo zyezihwinza, ani sihubhatima. Maana amwi lwe mubhungana se hwi faida ila huhasala. ");
INSERT INTO sbk_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Maana ihumvwa, huje lwe mubhungana mshibhanza, huli nu lugabhanyo kati yinyu nani hadodo ihwitiha. ");
INSERT INTO sbk_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Kwa ihwanziwa zibhe intaamyo kati yinyu aje bhabhaala, bhebhitihwilwe bhamanyishe hulimwe. ");
INSERT INTO sbk_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Maana lemubhungana shemulya seshalye sha Gosi. ");
INSERT INTO sbk_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Lwe mulya kila muntu alya ishalye shakwe yuya kabla ya bhanji sebhaliye. hata unu ali ni nzala, unu akholilwe. ");
INSERT INTO sbk_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Je semuli ni nyumba iyalile na mwelele? Je mzarabhunye ishibhanza sha Ngulubhi na hubhapele insoni bhesebhali na Hantu? Njanje henu hulimwe? Imbatime? Simbatuma hwi ili! ");
INSERT INTO sbk_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Maana nahaposhile afume hwa Gosi shila shimbapiye amwi aje Ugosi uYeesu, usiku alongwa ahejile ikati. ");
INSERT INTO sbk_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Baada ya salifye, abhuvunzile naje ubhu wembili wani, “Ubhu we mbili wani, wewili kwaajili yinyu. Mubhombe ishi hunkumbushe ani.” ");
INSERT INTO sbk_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Nashinishi ahejile inshikombe baada yalye, naje “Ishikombe ishi ndajizyo midanda lyani.” Mbhombe ishi hahinji kila le mumwela hwa hunkumbushe ani.” ");
INSERT INTO sbk_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Uwakati wowonti lemulya ishalye ishi na hushimwelele ishikombe, mlumbilila ufwewa Yesu mpaka lwa hayiyinza. ");
INSERT INTO sbk_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kwa hiyo wowonti ya lya ishalye au hushimwelele ishikombe isho isha Yesu sheyihwanziwa, abhabhe ayipiye ubhibhi wimbili ni danda lya Yesu. ");
INSERT INTO sbk_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Umuntu ayibhuzilizye yuyo asuti, nkalyanje ishalye na mwelele ishikombe. ");
INSERT INTO sbk_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Maana yalya na mwele bila asubhilile ubili alya na mwele alongwe hwakwe yuyo. ");
INSERT INTO sbk_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Nduyo maana abhantu abhinji bhabhinu bhamo bhafwiye. ");
INSERT INTO sbk_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Lakhini nke twayenya timti setahayilongwa ishibhakaka. ");
INSERT INTO sbk_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Ila lyetilongwa nu Yesu, tiwelwa ili huje tisahalongwe peka ni nnsi. ");
INSERT INTO sbk_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Ishi, bhakaka na dada bhani, lwe mubhungama mpate alye, mugulilane. ");
INSERT INTO sbk_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Umuntu nkani nzala alye hukhaya yakwe hujelwe mubhungana peka nsahabhe hulongwi humambo aganjige msimbile naibhabhuzya lyenayiyinza. ");
INSERT INTO sbk_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ahusu ikalama izyamumwoyo, aka na dada bhani sihwanza musahamanye. ");
INSERT INTO sbk_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Muminye lwe mwahai bhapanzi mwahalongozewilwe afwate humadala gogo gesagamwalongoze wizyo nago. ");
INSERT INTO sbk_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Ishi ihwanza huje mumanye aje numo wowonti yayanga hu Mpepo wa Ngulubhi ayanga aje “U Yesu alaniwilwe.” Numo wowo yayiyanga, “UYesu yu Bwana,” ila hwa Mpepo Umfinjile. ");
INSERT INTO sbk_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Ishi naziliho ikalama tofauti, ila Umpepo yeyula. ");
INSERT INTO sbk_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Na kuna huduma tofauti tofauti, bali Bwana ni yeye yule. ");
INSERT INTO sbk_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Huli iaina mbali mbali, izyi mbombo, lakini Ungulubhi yeyula yazibhomba imbombo hubhonti. ");
INSERT INTO sbk_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Ishi kila muntu apewa uufunuo uwampe hufaida ya bhonti. ");
INSERT INTO sbk_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Maana umuntu weka apewa inzwi nu Umpepo uwihekima, nu winji izwi lyi maarifa uMpepo yuyula. ");
INSERT INTO sbk_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Hwa winji ahumpela ulwitiho hu Mpepo yeyula, na hwa winji ikalama iya uponyaji hwa Mpepo weka. ");
INSERT INTO sbk_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Hwa winji amatendo aginguvu, nu winji ukuwa. Na hwa winji uuwezo uwa pambanule umpepo, nu uwi aina mbalimbali izyi lugha na hwawinji itafasili zyi lugha. ");
INSERT INTO sbk_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Lakhini uMpepo yuyula yabhomba imbombo izi zyonti ahumpela, kila muntu ikalama ndeshe shachagula umweene. ");
INSERT INTO sbk_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Ndeshe shila umbili weka, wope umbili huli ni vilungo ivyinji, vyonti vyimbili bhubhulashi shanisho nu Kilisiti. ");
INSERT INTO sbk_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Kwa maana hu Mpepo weka hamna Abhayahudi au Bhayunani, huje twebhatumwa au huru na tentitahamwelile uMpepo weka. ");
INSERT INTO sbk_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Kwa maana umbili sashiungo sheka ila vyinji. ");
INSERT INTO sbk_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Nkushe inama libhayanje, “aje ani siganyobhe, nani wayo indi sehemu ya mbili,” iyo seyibhubhomba aje husahabhe mu yi mbili. ");
INSERT INTO sbk_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Na nkeshele ibhutwi libhanje anisindi linso ani sehemu yi mbili, “iyo lyo seyihuyibhomba aje saga sehemu yimbili. ");
INSERT INTO sbk_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Nkushele numbili wonti bhubhabhe maso, handi hulihwoshi ubhahwumvwe? Nkushele ubili wonti bhubhe likutwi, Wenu uwanunsye? ");
INSERT INTO sbk_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Lakini Ungulubhi ahabhishile kila shilungo isha mbili amahali pakwe ndeshe shapanjile yuyo. ");
INSERT INTO sbk_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Nankushele vyonti vyahali ishilungo sheka, umbili hunibhuli hwi? ");
INSERT INTO sbk_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ishi ivulungo vyinji, lakini umbili gweka. ");
INSERT INTO sbk_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Ilyinso selingubhuzya unkhono, “sindinuhaja nawe.” Wa itwe selinga vibhuzya ivinama sindi ni haja nawe.” ");
INSERT INTO sbk_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Lakini ivilungo ivyi mbihi vyevilo leha aje vili ni heshima hadodo vihwanziwa hani. ");
INSERT INTO sbk_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Ni vilungo ivyi mbili vyulola aje vili ni heshima hadodo tuvipela iheshima hani ni virungo vyitu vyesevili nu mvuto vilinuwinza hani. ");
INSERT INTO sbk_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Ni shi ivirungo vyitu vyesavili nu mvuto sevili ni haj