﻿USE sofia;
DROP TABLE IF EXISTS sofia.sbe_vpl;
CREATE TABLE sbe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sbe_vpl WRITE;
INSERT INTO sbe_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ZTeina ta Yesu Keliso kana kulutubuwao. Abelahama unai ye hetubu ye dobi Dawida iya wasawasa, na kabo ye dobi ede Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abelahama natuna Isako, Isako natuna Yakobo, Yakobo natuna Yuda ma kana kahao. ");
INSERT INTO sbe_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda natunao Pelesi yo Sela, sinadi ede Tamala. Pelesi natuna Heselona, Heselona natuna Lama. ");
INSERT INTO sbe_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama natuna Aminadaba, Aminadaba natuna Nasona, Nasona natuna Salamona. ");
INSERT INTO sbe_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamona natuna Bowasi, na sinana ede Lahaba. Bowasi natuna Obedi, sinana ede Luti. Obedi natuna Yese, ");
INSERT INTO sbe_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese natuna Dawida, iya ede wasawasa. Dawida natuna Solomona, sinana ede Bateseba, iya meta Ulaiya kwabulina. ");
INSERT INTO sbe_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona natuna Lehobowama, Lehobowama natuna Abiya, Abiya natuna Asa. ");
INSERT INTO sbe_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natuna Yehosapata, Yehosapata natuna Yeholama, Yeholama natuna Usiya. ");
INSERT INTO sbe_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya natuna Yotama, Yotama natuna Ahasa, Ahasa natuna Hesekiya. ");
INSERT INTO sbe_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya natuna Manase, Manase natuna Amona, Amona natuna Yosiya. ");
INSERT INTO sbe_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya natuna Yekoniya ma kana kahao. Siya yodi huya unai Babiloni yona tauꞌiyala se laoma Yudeya tanona tamowaidiyao se haidi se laeidi Babiloni. ");
INSERT INTO sbe_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na muliyena kabo Yekoniya natuna Seyalatiyela, Seyalatiyela natuna Selubabela. ");
INSERT INTO sbe_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Abiuda, Abiuda natuna Eliyakima, Eliyakima natuna Asowa. ");
INSERT INTO sbe_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asowa natuna Sadoka, Sadoka natuna Akima, Akima natuna Eliuda, ");
INSERT INTO sbe_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eleyasala, Eleyasala natuna Matana, Matana natuna Yakobo, ");
INSERT INTO sbe_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo natuna Yosepa. Yosepa mwanena Maliya. Maliya natuna ede Yesu, iya ta katai ede Keliso. ");
INSERT INTO sbe_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Unai, Abelahama kana isimulitao ye dobi Dawida unai meta isi saudoudoi-hasi (14), yo Dawida unai ye dobi huyana se laeidi Babiloni, isidiyao meta saudoudoi-hasi (14), na kabo ye dobi Keliso unai meta hinage isi saudoudoi-hasi (14). ");
INSERT INTO sbe_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keliso huyalabasina wasana ede doha teina: Maliya Yesu sinana se hededehepatulaei Yosepa unai, na sola nige se miyakesega, na ye masalaha na kabina se kata meta Maliya ye diyaka Yaluwa Tabuna logulogunaena. ");
INSERT INTO sbe_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na Yosepa meta tamowai namwanamwana na nige ye henuwa Maliya ye hemwadine tamowai matadiyena. Unai yona nuwatu ye ginauli bena wadawadamyena ye inawasei. ");
INSERT INTO sbe_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sola ye nuwanuwatu, na Guiyau yona anelu ye laoma kenosuwaiyena ye hededelau unai ye wane, “Yosepa, Dawida natuna, tabu ku matausi na Maliya ku tawasolai. Iya natuna meta Yaluwa Tabuna unai ye tubuma. ");
INSERT INTO sbe_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iya kabo natuna loheya ye labasi, na hesana kabo ku tole Yesu, matawuwuna iya boda Isalaela yodi yababa udiyedi kabo ye gilihaidi.” ");
INSERT INTO sbe_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginauli maudoidi ta se tubu bena Guiyau yona hedehedede peloweta kawanaena ye hededenonohaiyako wa ye hemamohoiyei: ");
INSERT INTO sbe_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hasala nuwanuwasupuna kabo ye diyaka, na kabo natuna loheya ye labasi. Iya kabo hesana se tole ede Emanuwela.” Emanuwela kaniyona ede Yaubada maiyada. ");
INSERT INTO sbe_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosepa ye kenotolo ede Guiyau yona anelu yona hedehedede wa ye lauwatani na Maliya ye woyaiyama yona magaiyena ye kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Na sola Maliya ma nuwanuwasupuna ye lau ee kana siga natuna ye labasi. Na hesana Yosepa ye tole ede Yesu. ");
INSERT INTO sbe_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yudeya magaina gagilina hesau hesana Betelehema unai Yesu se labasi, Heloda yona huyawasawasa unai. Na tamowai sibasibadiyao kipwala taukitahekasadi teha kaluwabu unai se laoma ee Yelusalema unai se lage, ");
INSERT INTO sbe_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na se henahenamai se wane, “Komiu Dius yomi wasawasa hauhauna se labasiyako wa, iya ede haedi? Yona huyalabasi kipwalana teha kaluwabu unai ye sae ka kita, ede ka laoma ta bena iya ka tabaꞌohui.” ");
INSERT INTO sbe_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Heloda wasawasa hedehedede ta ye lapui meta ye siliyata, unai nuwana ye modekalili, yo Yelusalema tamowaidi maudoidi hinage. ");
INSERT INTO sbe_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi ye yogagogoidima na ye henamaiyeidi, “Haedi kabo Keliso se labasi?” ");
INSERT INTO sbe_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na se wane, “Yudeya magaina Betelehema unai, matawuwuna ede peloweta ye kulinonohaiyako ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na kowa, Betelehema Yudeya tanona unai, kowa nige ku dobikalili Yudeya magaidiyao udiyedi, matawuwuna kowa kalimyena kabo tauwoyawoya ye laoma na yogu tamowai Isalaela ye kitahetetedi.’” ");
INSERT INTO sbe_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na kabo Heloda tamowai sibasibadiyao wa ye yogahesuwaladi na ye henamaiyeidi kipwala wa yona huyamasalaha mayadaina mamohoina bena kabina ye kata. ");
INSERT INTO sbe_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na kabo ye hetamalidi se lau Betelehema yo ye wane, “Kwa lau wawaya ta kwa loyanamwanamwaei. Ena kwa lobai kabo kwa uyoma yogu kwa hedehededenamwanamwa, na kabo yau hinage ya laowa unai ya tabaꞌohu.” ");
INSERT INTO sbe_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wasawasa wa kalinana se lapui na kabo se lau, na kipwala ye woyaꞌuseidima wa se kitaꞌuyoi meta se gwauyalakalili. Na ye kedabagunaidi ye lau wawaya wa yona kabamiya wa unai. ");
INSERT INTO sbe_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Se mwalaesae numa kalona wa unai na wawaya wa ma sinana Maliya se kitadi, se tulibono yo wawaya wa unai se tabaꞌohu. Yodi kainauya se haidi na se kainauyaidi, gole yo inisenisi yo mulo. ");
INSERT INTO sbe_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na kabo kenosuwaiyena Yaubada ye hededelau udiyedi tabu se uyo Heloda unai. Ede keda hesau se hai na se uyo yodi magai. ");
INSERT INTO sbe_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tamowai sibasibadiyao wa se dalahaiko, na kabo Guiyau yona anelu kenosuwaiyena ye taumasalaha Yosepa unai ye wane, “Ku tolo wawaya ta ma sinana ku woyaidi kwa wasabu kwa lau Aikupito. Menai kabo kwa miya ye lau ee kana siga ya hededelaowaꞌuyo. Matawuwuna Heloda wawaya ta ye wasewasenei bena ye unui.” ");
INSERT INTO sbe_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ede boniyaina ne unai Yosepa ye tolo na wawaya wa ma sinana ye wasabuyeidi se lau Aikupito. ");
INSERT INTO sbe_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Unai se miya ye lau ee Heloda ye boita. Teina unai Guiyau yona hededepeloweta saha ye hededenonohaiyako wa ye laoma ye mamohoi: “Aikupito unai natugu tau ya yoganeiꞌuyoiyama.” ");
INSERT INTO sbe_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heloda wasa ye lapui meta tamowai sibasibadiyao wa iya se lupoi, unai ye kouyalayalakalili. Ede yona tauꞌiyala ye hetamalidi se lau Betelehema maudoina unai wawayao tatao yodi bolimai labui sola nige se haidi maudoidi se unuidi. Matawuwuna ede tausibasiba wa ye henamaiyeidi na kipwala yodi huyakitana wa unai ye laoma meta sola nige bolimai labui ye lobai. ");
INSERT INTO sbe_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Teina unai peloweta Yelemaiya saha ye hededeyako wa ye laoma ye mamohoi, ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kalina lakilakina Lama unai ye laoma, nuwayababa yo doulakilaki daguguna. Lahela natunao sabidi ye dou na nige ye henuwa nuwana se hededehetalu, matawuwuna ede natunao se boitako.” ");
INSERT INTO sbe_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heloda yona boita mulinaena, Aikupito unai Guiyau yona anelu kenosuwaiyena ye taumasalaha Yosepa unai ");
INSERT INTO sbe_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ye wane, “Ku tolo wawaya ta ma sinana ku woyaidi kwa uyo Isalaela tanona unai, matawuwuna wawaya ta bena tauꞌunuina wa se boitako.” ");
INSERT INTO sbe_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Unai Yosepa ye tolo wawaya wa ma sinana ye woyaidi na se uyo Isalaela. ");
INSERT INTO sbe_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na wasa ye lapui meta Heloda natuna Alekelau iya tamana lauhedamaina Yudeya yodi wasawasa, unai ye matausikalili na nige ye henuwa ye lau Yudeya. Na kenosuwaiyena hededehesibasiba ye haidi, unai ye lau Galili ");
INSERT INTO sbe_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na magai hesau hesana Nasaleta unai se miya. Unai peloweta yodi hedehedede hesau hinage ye laoma ye mamohoi: “Iya kabo hesana se katai Nasaleta tauna.” ");
INSERT INTO sbe_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bolimai hisa se lau mulidi ne unai Yowane Babatiso Yudeya balabalanaena ye hetubu ye lauguguya ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kwa nuwabui! Matawuwuna ede Galewa basileiyana ye hanahanaumako!” ");
INSERT INTO sbe_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowane meta iya tamowaina ede Aisaiya peloweta ye hededehemasalahaꞌusei wa ye wane, “Tamowai hesau balabala unai ye yogayoga ye wane, ‘Guiyau yona keda kwa kabinonohai, yo yona kabalau kwa hedudulai!’” ");
INSERT INTO sbe_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowane kana kaleko meta kamela wiyana unai se ginauli, na kana dagilolo meta suisui hesau dahina, na kana kai ede mwadimwadi yo kamwakamwa. ");
INSERT INTO sbe_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yelusalema, Yudeya yo Yolidani tehana maudoina tamowaidiyao se laoma iya kalinawai ");
INSERT INTO sbe_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na yodi yababa se hededehemasalahadi, ede Yowane ye hebabatisoidi Yolidani sagasagana unai. ");
INSERT INTO sbe_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kabo Paliseya yo Sadusiya tamowaidiyao gwaudi se laoma Yowane unai babatiso hesabana. Ye kitadi ede ye dilaidi ye wane, “Komiu mwata natunao! Kaiteya ye hededelaowa bena kabo Yaubada yona hekamkamna kwa yabubugabaei? ");
INSERT INTO sbe_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bena nuwabui kaniyona kwa miyahemasalahadi! ");
INSERT INTO sbe_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na tabu kwa nuwatui meta kabo kwa bom kwa hemauliꞌuyoigomiu na kwa wane, ‘Kama kulutubu meta Abelahama!’ Ya hededelaowa, Yaubada gonowana weku ne udiyedi Abelahama kana isimulitao ye ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kilam meta ye nonohaiyako na kaiwa wuwuna unai ye tole. Ena kaiwa hesau nige ye kaniyonamwanamwa meta kabo ye koigabaei yo ye gabalaei kaiwa kalakalasina luwanaena. ");
INSERT INTO sbe_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yau waila unai ya hebabatisoigomiu, yomi nuwabui kabakitana. Na tamowai hesau ede sola kabo ye laoma. Iya yona gigibwali meta ye saekalili na kabo yau. Yau nige ya namwakalili taba iya kana sendolo ya baheidi. Iya kabo Yaluwa Tabuna yo kaiwa kalakalasina udiyedi ye hebabatisoigomiu. ");
INSERT INTO sbe_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yona kabahesuhesuluisini kaikaiwana iya nimanaena, na kabo witi ye hesuluisinidi yo ye hinelidi. Na kabo kaniyodi ye toledi sanalaena, na mosomosodiyao kabo ye gabudi kaiwa kalakalasina nige yona kababoso unai.” ");
INSERT INTO sbe_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kabo Yesu Galili unai ye laoma Yolidani sagasagana unai, bena Yowane unai babatiso ye hai. ");
INSERT INTO sbe_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na Yowane ye kaipate bena Yesu ye hededehekaiyawasi ye wane, “Idohagi to kowa ku laoma yau kaliguyena? Ye namwa mo taba kowa ku hebabatisoigau!” ");
INSERT INTO sbe_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na Yesu ye hededebui ye wane, “Nige, teina mahana ta unai meta kowa bena ku hebabatisoigau. Taba Yaubada yona nuwatu mo ta lauwatani.” Ede Yowane ye talam na Yesu ye hebabatisoi. ");
INSERT INTO sbe_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ye hebabatisoi ye gehe kabo Yesu waila ne unai ye gayo ye saesae, na mahanana ne unai galewa ye tasoke, na Yesu Yaubada Yaluwana ye kita ye dobima doha bunebune na ye talu iya unai. ");
INSERT INTO sbe_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na kalina hesau galewa ne unai ye wane, “Teina yau Natugu. Iya ya gadosisiyei, yo ya gwauyalakalili iya unai.” ");
INSERT INTO sbe_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na kabo Yaluwa Tabuna Yesu ye laei balabalaena bena diyabolo iya ye nohoi. ");
INSERT INTO sbe_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Menai ye kaihudi ye lau mayadai 40 yo boniyai 40, ede ye hasali. ");
INSERT INTO sbe_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na taunohonoho wa ye laoma kalinaena ye wane, “Ena kowa Yaubada Natuna, ku hededelau weku ta udiyedi se hemala pwalawa.” ");
INSERT INTO sbe_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Na Yesu ye wane, “Yaubada kalinana unai ta hasili ye wane, ‘Tamowai taba nige pwalawa mo unai ye maumauli, na Yaubada yona hedehedede maudoidi udiyedi hinage ye maumauli.’” ");
INSERT INTO sbe_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na kabo diyabolo wa Yesu ye laei magai lakilakina tabuna unai na ye saei Numa Tabuna kewana tehana saesaekalilina unai ye hetolo, ");
INSERT INTO sbe_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na ye hededelau unai ye wane, “Ena kowa Yaubada Natuna, kabo ku kamposidobi. Matawuwuna buka tabuna unai se kuli se wane, ‘Yaubada kabo ye hededelau yona anelu udiyedi na se kitahetetego, kabo nimadiyena se kabisinigo, na taba nige gonowana kaem ne ku koiyedi weku udiyedi.’” ");
INSERT INTO sbe_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Yesu ye hededebui ye wane, “Na hinage buka tabuna unai ta hasili meta ye wane, ‘Tabu Guiyau yom Yaubada ku lautonogi.’” ");
INSERT INTO sbe_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na kabo diyabolo wa Yesu ye laei kuduli saesaekalilina unai na tanoubu ta basileiyana maudoidi yodi namwanamwa saesaedi ye hekita ");
INSERT INTO sbe_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","na ye wane, “Ena ku tulibono yo ku tabaꞌohu kaliguwai, kabo ginauli maudoidi ta ya haidiwa.” ");
INSERT INTO sbe_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na Yesu ye wane, “Satani, ku tausuwala! Matawuwuna buka tabuna unai ye wane, ‘Guiyau yom Yaubada ye bom mo ku hekasisiyei, yo iya ye bom mo unai ku tabaꞌohu.’” ");
INSERT INTO sbe_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ede diyabolo wa Yesu ye laugabaei, na anelu se laoma Yesu se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Huya hesau Yesu wasa ye lapui meta Yowane se haiyako na numatutugudu unai se tole. Ede Yudeya ye laugabaei na ye uyo Galili. ");
INSERT INTO sbe_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nige ye uyo yona magai Nasaleta, na ye lau Kapelenauma unai ye miya, Galili Gabwana dedekanaena, meta Sebulona yo Napatali tehadiyena. ");
INSERT INTO sbe_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Unai saha Aisaiya peloweta ye hededeyako wa ye hemamohoiyei: ");
INSERT INTO sbe_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulona tanona yo Napatali tanona, tanodiyao udiyedi keda ye dobi gabwa, tano Galili Gabwana dedekanaena, Yolidani sagasagana hali sanakawasina, Galili tanona dagela tamowaidiyao yodi kabamiya, ");
INSERT INTO sbe_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","siya masigili unai taumiya wa meta mala lakilakina se kita, yo mwaloi logulogunaena taumiya kalidiyena mala ye sina.” ");
INSERT INTO sbe_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tenem huyana ne unai Yesu ye hetubu ye lauguguya ye wane, “Kwa nuwabui, matawuwuna ede galewa basileiyana ye hanahanaumako.” ");
INSERT INTO sbe_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Huya hesau Yesu ye yona ye laulau Galili Gabwana dedekanaena ede tauyamayama labui ye kitadi yodi hinaya udiyedi se yamayama. Tamowaidiyao ede Simona – hesana hesau ede Petelo – ma kana kaha Andeleya. ");
INSERT INTO sbe_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na ye yogadobi udiyedi ye wane, “Kwa saema kwa hemuliwatanigau, na kabo ya hekatagomiu tamowai tauyamayamaidi.” ");
INSERT INTO sbe_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ede mahanana ne unai yodi hinaya wa se laugabaeidi na se saema se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Se tausigilau, na kabo Sebedaiyo ma natunao Yamesi yo Yowane ye kitadi yodi waga unai, yodi hinaya se polapolaidi. Na Yamesi ma kana kaha Yowane ye yoganeidi. ");
INSERT INTO sbe_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mahanana ne unai tamadi yo yodi waga wa se laugabaeidi, na Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili maudoina ye tauhetakikili na yodi sunago udiyedi ye lauhekata. Yaubada yona basileiya wasana namwanamwana ye hededehemasalaha, yo hinage tamowai kadi kasiyebwa udoiꞌudoi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesu wasana Galili tehana maudoina ye tauhetakikili, yo hinage ye lau ee Siliya tanona maudoina unai. Na tamowai kadi kasiyebwa udoiꞌudoi se laedima Yesu unai, kasiyebwa doha taukamkamna, yo yaluwa yabayababadi tamowai se luwuidi, yo taukikikikiwasi, yo hinage taubunibuni, na ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na teha Galili, Dekapolisi, Yelusalema, Yudeya, yo Yolidani sagasagana hali sanakawasina udiyedi bodalakilaki se laoma Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na Yesu boda wa ye kitadi se laolaoma, ede maiyanao hekahekatao se sae kuduli hesau unai. Kabo ye tuli ");
INSERT INTO sbe_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na ye hetubu ye hekatadi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kaiteyadi se kitalau Yaubada yona sagu unai, siya gonowana se gwauyala, matawuwuna galewa basileiyana meta siya yodi. ");
INSERT INTO sbe_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kaiteyadi se doudou yo se nuwanuwayababa, siya gonowana se gwauyala, matawuwuna ede Yaubada kabo nuwadi ye hededehetaludi. ");
INSERT INTO sbe_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kaiteyadi se nuwatalu, siya gonowana se gwauyala, matawuwuna ede tanoubu maudoina ta kabo siya yodi. ");
INSERT INTO sbe_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kaiteyadi laulau namwanamwadiyao se henuwakaliliyeidi, siya gonowana se gwauyala, matawuwuna saha se henuwa wa kabo se lobai. ");
INSERT INTO sbe_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kaiteyadi tamowai hekadiyo se katekamkamnaeidi, siya gonowana se gwauyala, matawuwuna Yaubada kabo ye katekamkamnaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kaiteyadi nuwadi udiyedi se aꞌa, siya gonowana se gwauyala, matawuwuna ede Yaubada kabo se kita. ");
INSERT INTO sbe_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kaiteyadi siya tamowai tauhenuhenuwadaumwalidi, siya gonowana se gwauyala, matawuwuna ede Yaubada kabo ye kawanatuyeidi. ");
INSERT INTO sbe_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kaiteyadi siya laulau namwanamwadi debadiyena se hekamkamnadi, siya gonowana se gwauyala, matawuwuna ede galewa basileiyana meta siya yodi. ");
INSERT INTO sbe_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ena tamowai se dilamataigomiu yo se hekamkamnagomiu yo hededelupolupo yabayababadi udoiꞌudoi udiyedi se hededeheyababagomiu yau debaguyena, meta gonowana kwa gwauyala. ");
INSERT INTO sbe_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nuwamiu bena se namwa yo kwa gwauyala matawuwuna ede yomi kainauya ye lakikalili galewa ne unai. Kaniyona ede peloweta bagubagunadiyao wa se hekamkamnadi gonogonowana doha se hekamkamnagomiu ta.” ");
INSERT INTO sbe_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Komiu tanoubu ta kalitana ede. Taba kalita ne kamnana ye gehe, meta nige gonowana ta hekalitaꞌuyoi, yo nige kana paisowa hesau. Unai kabo se inigabae na tamowai se sae se dobi na se utuꞌutui. ");
INSERT INTO sbe_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Komiu tanoubu ta malana ede. Magai lakilakina hesau kuduli kewanaena malana nige gonowana se tolewadam. ");
INSERT INTO sbe_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yo hinage taba lampa ta hekalasi, meta nige gonowana gulewa unai ta hebilikoi. Na ta tolesaei lampa kabatolena unai na numakalo ne unai tamowai maudoidi dawayana ne se kita. ");
INSERT INTO sbe_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Unai bena tamowai yomi laulau namwanamwadi se kitadi doha mala wa, yo tamamiu galewa ne unai se hedebasaei.” ");
INSERT INTO sbe_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tabu yomi nuwatu ya laoma ta laugagayo yo peloweta yodi hedehedede wa bena ya hekaiyawasidi. Nige! Na ya laoma ta bena ya hemamohoiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya hededemamohoi kalimiuyena: Galewa yo tanoubu kabo se gehe, na Yaubada yona laugagayo se kulidiko wa nige gonowana kulikulidi gagilina hesau ye taukwadalele, kana siga laugagayo hedehededena maudoidi se laoma se mamohoi. ");
INSERT INTO sbe_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ena tamowai hesau laugagayo ta gagilina hesau ye utusi yo tamowai hekadi ye hekatadi bena laugagayo ta se utusi, Yaubada kabo iya ye tolehemulita galewa basileiyana unai. Na ena kaiteya laugagayo ta ye miyamiyaei yo tamowai hekadi ye hekatadi na se miyawatani, Yaubada kabo iya ye tolehebaguna galewa basileiyana unai. ");
INSERT INTO sbe_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya hededelaowa kalimiuyena: Yomi laulau bena se dudulai yo se namwakalili na kabo siya Paliseya yo laugagayo taulauhekataedi. Ena nige, meta nige gonowana kwa lusae galewa basileiyana unai.” ");
INSERT INTO sbe_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kwa lapuiyako meta Mose ye hededelau kada mumugao udiyedi ye wane, ‘Tabu ku kaiunu’, yo hinage, ‘Ena tamowai hesau ye kaiunu meta iya kabo se laei tautolehedudulai tamowaidiyao udiyedi na se hekamkamna.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na yau ya hededelaowa, ena hesau kana kaha ye kouyalayalaei meta iya taba se helauhetala. Na ena tamowai hesau kana kaha ye kawayauyaulei ye wane, ‘Kulum ne nige kaniyona!’, meta iya taba se laei Sunedeli bodana unai na se hekilaino. Na taba hesau kana kaha ye hededeheyababa ye wane, ‘Kowa tamowai yauyaulekalilina, yo Yaubada kana waiunu mamohoi!’, meta iya kabahekilainona ede kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Unai, ena kowa yom kainauya ku baheiyamako bena ku kaitalasamyei na nuwamyena ye saema meta kowa yom yababa hesau kam kaha hesau unai na ye kouyalayalaego, ");
INSERT INTO sbe_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yom kainauya wa ku laugabaei kaitalasam kabagabuna dedekanaena, na ku lau kam kaha wa unai yom teha ku tolehedudulai na kabo ku uyoma yom kainauya wa ku kaitalasamyei. ");
INSERT INTO sbe_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ena kam hagahaga debanaena na kam waiunu ye koipiliyeigo na ye laego bena ku lauhetala, meta bena yomi lau ne unai na maidam kwa tolehedudulaimwamwayauyei. Ena nige, kabo ye laego tauhelauhetala unai. Yo tauhelauhetala wa kabo ye moselaego yona taupaisowa unai na ye tolego numatutuguduyena. ");
INSERT INTO sbe_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya hededemamohoi: Taba nige se hepesago ye lau ee kana siga kam hagahaga monina gagilina gehegehena ku hemaisagabaei.” ");
INSERT INTO sbe_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kwa lapuiyako meta beyabeyana Mose yona laugagayo unai ye wane, ‘Tabu ku ganawali.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na ya hededelaowa kalimiuwai: Ena kaiteya waihiu hesau ye kita na nuwanaena ye gadosisiyei bena taba maidana se keno, meta iya nuwana ne unai ye ganawaliko. ");
INSERT INTO sbe_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ena matakahatum ye woyalaego yababa unai, ku lamohai na ku gabaei. Ye namwa mo taba yaum hesau nigele na kabo taum maudoudoina ye lau kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yo hinage ena nimakahatum ye woyalaego yababa unai meta ku bolihai ku gabaei. Ye namwa mo taba yaum hesau nigele na kabo taum maudoudoina ye lau kaiwa kalakalasina unai.” ");
INSERT INTO sbe_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mose ye wane, ‘Ena tamowai hesau mwanena bena ye inawasei meta kabo inawase pepwana ye kuli na ye mosei.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na yau ya hededelaowa: Ena tamowai hesau mwanena nige ye ganawali na ye inawasegaibui, meta iya waihiu ne ye heganawali. Na ena tamowai hesau waihiu inaꞌinawasena ye tawasolai, meta iya hinage ye ganawali.” ");
INSERT INTO sbe_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Doha hinage kwa lapuiyako meta Mose ye hededelau kada mumugao udiyedi ye wane, ‘Tabu yom hededekaigwala hesau ku utusi, na yom kaigwala ku hededediko Yaubada unai meta bena ku ginauliwatanidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na yau ya hededelaowa: Tabu ku kaigwala! Tabu galewa hesanaena ku kaikaigwala, matawuwuna galewa meta Yaubada yona kabatuli. ");
INSERT INTO sbe_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yo tabu ku kaikaigwala tanoubu hesanaena, matawuwuna tanoubu ta iya Yaubada kaena kabatolena. Yo tabu ku kaikaigwala Yelusalema hesanaena, matawuwuna Yelusalema meta wasawasa saesaena yona magai. ");
INSERT INTO sbe_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tabu ku kaikaigwala kulum ne unai, matawuwuna nige gonowana kulum ne maiyawana hesau ku heposiposi o ku hedubaduba. ");
INSERT INTO sbe_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ye namwa mo taba ku talam ku wane ‘Aa’, o ku uhala ku wane ‘Nige’. Ena saha hesau ku hededehagahagaiꞌuyoi meta tauyababa unai ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yo hinage kwa lapuiyako yomi taulauhekata se wane, ‘Ena matam kesega se koihegibu, kabo hinage taukoihegibuna ne matana kesega ku koihegibu, yo ena mwakam kesega se koihuhuhai hinage taukoihuhuhaina ne mwakana kesega ku koihuhuhai.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na yau ya hededelaowa: Tabu yababa tauginaulina ku laukwatakwataei. Ena tamowai hesau papalikahatum ne unai ye koi meta ku tolobui na teha hesau ne unai hinage ye koi. ");
INSERT INTO sbe_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ena tamowai hesau ye laego kwa lauhetala na kam luwuluwu nimakubwakubwana ne ye hai meta hinage kam luwuluwu nimalohalohana ku mosei. ");
INSERT INTO sbe_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ena iyala tamowaina hesau ye lauheliligo bena yona gogo ku baheidi keda kubwakubwana mo, meta bena ku baheidi ku lau kedalohaloha. ");
INSERT INTO sbe_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ena tamowai hesau saha ye kaibwadai kalimyena meta bena ku mosei. Na ena tamowai hesau saha kalimyena ye sagenahagahagai meta tabu ku nuwahi, na bena ku mosei.” ");
INSERT INTO sbe_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yo hinage kwa lapuiyako yomi taulauhekata se wane, ‘Keham ku gadosisiyei na kam waiunu ku hewaiunu.’ ");
INSERT INTO sbe_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Na yau ya hededelaowa kalimiuyena: Kami waiunu kwa gadosisiyeidi yo hinage tauhekamkamnagomiu yodi kwa tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Teina laulau ta unai kabo kwa hemala tamamiu galewa ne unai natunao mamohoidi, matawuwuna ede mahana ye hesina tamowai yabayababadi yo tamowai namwanamwadi udiyedi, yo hinage nabu ye hetalu tamowai namwanamwadi yo tamowai yabayababadi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ena taugadosisiyeigomiu se bom mo kwa gadosisiyeidi, kabo kaniyona ede saha? Takisi tautanotano hinage se gadogadosisihineli. ");
INSERT INTO sbe_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ena kehamiyao mo se bom kwa lautokihinelidi meta idohagi, bena yomi laulau ne se namwa na kabo tamowai hekadiyo ne? Matawuwuna dagela tamowaidiyao teina miya ta hinage se miyamiyaei. ");
INSERT INTO sbe_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yomi miyamiya ne udiyedi bena kwa namwa yo kwa dudulaikalili, doha tamamiu galewa ne unai iya ye namwa yo ye dudulaikalili.” ");
INSERT INTO sbe_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Bena kwa kitanamwanamwa, tabu tamowai matadiyena yomi laulau namwanamwadi kwa ginaginaulidi bena kabo se kitahenamwagomiu. Ena yomi laulau doha teina, meta tamamiu galewa ne unai taba nige kainauyana ye haiyawa. ");
INSERT INTO sbe_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Unai ena yomi kainauya kwa moseidi deha tamowaidiyao udiyedi meta tabu bwagigina kwa yuhi doha taukailupolupo yodi laulau sunago yo keda udiyedi, yodi kainauya se moseidi tamowai matadiyena bena kabo se kitadi yo se nokoedi. Ya hededemamohoi kalimiuyena: Siya yodi kainauya maisana ede se haiyako. ");
INSERT INTO sbe_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ena yom kainauya ku mosei deha tamowaina hesau unai meta tabu ku hededeꞌuyoigo kam kaha hesau unai na bena kabim ye kata. ");
INSERT INTO sbe_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na yom kainauya meta bena ku mosewadam. Na Tamam ginauli wadawadamdi taukitadi, iya kabo ye kainauyaigo.” ");
INSERT INTO sbe_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na ena kwa tapwalolo, tabu yomi laulau doha taukailupolupo. Se henuwa bena kabo tamowai se kitadi, unai sunago kalodiyena yo hinage keda dedekadiyena se tolo na se tapwatapwalolo. Ya hededemamohoi kalimiuyena: Siya yodi tapwalolo maisana ede se haiyako. ");
INSERT INTO sbe_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na ena ku tapwalolo, meta ku mwalae yom numa kalonaena, keda ku gudu na ku tapwalolo Tamam unai, iya ede teha wadawadamnaena yo teha maudoidi udiyedi taumiya. Na Tamam ginauli wadawadamdi taukitadi, iya kabo ye kainauyaigo. ");
INSERT INTO sbe_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na ena kwa tapwalolo, tabu yomi hedehedede kwa laulaubodaiꞌuyoidi, doha Yaubada nige kabina taukata yodi tapwalolo. Siya yodi nuwatu meta bena tapwalolo se heloha, na kabo yodi yaubada ye lapuidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Unai komiu yomi tapwatapwalolo tabu doha siya, matawuwuna ede ginauli sahasahadi udiyedi kwa deha ne Tamamiu kabidi ye katako na kabo kwa kaibwadaidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Unai taba komiu kwa tapwalolo doha teina: ‘Tamamai galewa ne unai! Kowa hesam ka hededetausaei. ");
INSERT INTO sbe_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yom basileiya bena ye laoma. Yom nuwatu bena ka ginauliwatanidi tanoubu ta unai, doha galewa ne unai yom nuwatu se ginauliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mayadai ta kaina ku leyama. ");
INSERT INTO sbe_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yoma yababa ku nuwatugabaeidi, doha hinage kai tauheyababagai yodi yababa ka nuwatugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bena ku kitahetetegai na taba nige ka lulau noho luwanaena, na tauyababa yona nuwatu udiyedi ku gilihaigai.’” ");
INSERT INTO sbe_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tapwalolo wa ye hekatadi ye gehe kabo ye hedehededeꞌuyo ye wane, “Tauheyababagomiu yodi yababa bena kwa nuwatugabaeidi, kabo Tamamiu galewa ne unai hinage yomi yababa ye nuwatugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Na ena yodi yababa nige kwa nuwatugabaeidi meta hinage Tamamiu galewa ne unai taba nige yomi yababa ye nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ena kwa kaihudi, tabu kami kao doha taukailupolupo yodi laulau. Siya kadi kao se heyababadi bena tamowai se kitadi meta se kaihudi. Ya hededemamohoi kalimiuyena: Siya yodi kainauya ede se haidiko. ");
INSERT INTO sbe_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na kowa huyana ku kaihudi meta bena ku matakabi, kulum ne ku heyausi yo ku suwali. ");
INSERT INTO sbe_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Unai kabo tamowai hekadi nige gonowana se kitalobaigo meta ku kaihudi, na Tamam teha wadawadamyena taumiya, iya ye bom mo kabim ye kata. Na Tamam ginauli wadawadamdi taukitadi, iya kabo ye kainauyaigo.” ");
INSERT INTO sbe_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tanoubu ta unai tabu kwa kaipate bena taba kwa gogokalili. Gogo ne kabo se pwasa yo se tatagwaligwali, yo hinage taukaiwahali kabo se kaiwahalidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Na taba kwa kaipate bena galewa ne unai kwa gogokalili. Temenai nige gonowana sulasula se kapulapaidi yo taba nige masi ye heyababadi, yo hinage taukaiwahali taba nige se kaiwahalidi. ");
INSERT INTO sbe_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Matawuwuna ede kaiteya teha unai yom gogo se miyamiya, meta nuwam ede temenai. ");
INSERT INTO sbe_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matada meta siya tauda ta malana ede. Ena matada se dawaya meta kabo tauda maudoina ta ye dawaya. ");
INSERT INTO sbe_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ena matada se yababa meta tauda maudoina ta kabo ye masigili. Na ena ku nuwatui meta mala ede nuwamyena, na mala ne meta ye masigili, masigilina ne meta ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nige gonowana tamowai hesau tanuwaga labui yodi ye paisowa. Hesau kabo ye subu na hesauna wa kabo ye henuwa. O nuwana bagubagunana wa yona nuwatu ye ginauliwatanidi ma nuwakohihaina, na hesauna wa ye kitadobidobiyei. Unai nige gonowana Yaubada yo moni yodi kwa paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Unai ya hededelaowa kalimiuyena: Tabu kwa nuwanuwatukalili yomi mauli hesabana, bena saha kabo kwa kai yo kwa numa, yo taumiu ta hesabana, saha kabo kwa likwa. Mauli ye saekalili na kabo kai, yo taumiu ta ye saekalili na kabo kaleko! ");
INSERT INTO sbe_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hage, manuwa ne sola kwa kitadi, siya nige se kumakuma, yo nige se kelikeli, na nige kadi kai se tole sanalaena, na Tamamiu galewa ne unai, iya ye hekahekaidi. Na komiu meta kwa saekalili na kabo manuwa ne. ");
INSERT INTO sbe_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Luwamiu ne unai kaiteya ye nuwanuwatukalili na unai gonowana kabo mahana kesega ye tolelaei yona mauli ne unai na ye helohaꞌuyoi? ");
INSERT INTO sbe_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na idohagi to kaleko kwa nuwanuwatukaliliyeidi? Sola koya pasadiyao ne kwa kitadi. Nige se paipaisowa yo nige kaleko se laulauginauli. ");
INSERT INTO sbe_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ya hededelaowa kalimiuyena: Solomona yona wasawasa kalekodiyao nige hesau kana kao yona didiga doha tenem pasa ne. ");
INSERT INTO sbe_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ena Yaubada lagau ne kadi kao ye henamwadi, siya ede wau se lala na malaitom se wowoya na se gabudi se kalasi, meta iya gonowana kabo kaleko namwanamwadi udiyedi komiu ye hekalekogomiu. Komiu sunuma gagilidi tamowaidiyao! ");
INSERT INTO sbe_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tabu nuwamiu se mode na kwa wane, ‘Malaitom kabo saha ka kai? O saha ka numa? Yo saha ka likwa?’ ");
INSERT INTO sbe_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Matawuwuna nige Yaubada tausunumaeina, siya meta kai yo gogo se henuwakaliliyeidi, na kami henuhenuwa maudoidi ta tamamiu galewa ne unai kabidi ye katako. ");
INSERT INTO sbe_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na komiu bena Yaubada yona basileiya nuwanuwatuna kwa tolebagunai yo hinage yona miyamiya dudulaidi kwa miyamiyaidi, na kabo ginauli maudoidi ta hinage ye haidiwa. ");
INSERT INTO sbe_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Unai tabu malaitom modena unai kwa nuwanuwatukalili, matawuwuna malaitom kabo ye bom modena ye modeꞌuyo. Mayadai kesega kesega ye bom mo polohena.” ");
INSERT INTO sbe_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tabu kitahekasa ku ginauli o kowa hinage kabo kam hekasa ku lobai. ");
INSERT INTO sbe_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Matawuwuna Yaubada kabo ye hineligo doha tamowai hekadi ku hinelidi ne, na laugagayo saha ku hepaisowa kalidiyena wa kabo hinage Yaubada ye hepaisowa kalimwai. ");
INSERT INTO sbe_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ye saha to kam kaha matana mukalina ku kaikaikewai, na kowa matam ne unai kaiwa mwayana ne nige ku modei? ");
INSERT INTO sbe_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Idohagi to ku hededelau kam kaha unai bena matana mukalina ku haigabaei, na matam ne unai kaiwa mwayana ede sola ma miyana? ");
INSERT INTO sbe_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kowa taukailupolupo mamohoi, matam ne unai kaiwa mwayana ne ku haigabaeibagunai na matam ne ye nega, kabo kam kaha matana mukalina ne ku kitanamwanamwaei na ku haigabaei. ");
INSERT INTO sbe_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ginauli tabudi tabu kwa moselaeidi kedewa udiyedi yo yomi giniuba tabu kwa gabalaeidi puwaka udiyedi. Ena ku gabalaeidi, kabo puwaka wa giniuba ne se utukalakalateidi bwatano ne unai, yo kedewa wa kabo se gelobui na se kalasigomiu.” ");
INSERT INTO sbe_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kwa kaibwada Yaubada unai, kabo saha kwa kaibwadai wa ye leyawa. Kwa wase, na kabo saha kwa wasewasenei wa Yaubada ye saguigomiu na kwa lobai. Yo hinage keda guduna unai kwa koikoi, kabo keda ye sokeyawa. ");
INSERT INTO sbe_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Matawuwuna ede taukaikaibwada saha se kaibwadai wa kabo se hai, yo tauwasewase saha se wasenei wa kabo se lobai, yo taukoikoi ne kalinawai meta keda kabo ye soke. ");
INSERT INTO sbe_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Komiu sina yo tama, ena natumiu ye kaibwada pwalawa kabo weku kwa mosei? ");
INSERT INTO sbe_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ena ye kaibwada yama, kabo mwata kwa mosei? ");
INSERT INTO sbe_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Komiu tamowai yabayababadi, iyamo gonowana kabo ginauli namwanamwadiyao kwa moseidi natumiyao udiyedi. Na tamamiu galewa ne unai ye nonohakalili kabo kainauya namwanamwadi ye moseidi taukaibwada ne udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Unai, laulau sahasahadi kwa henuwadi bena tamowai se ginaulidi kalimiuyena meta komiu hinage kwa ginaulidi siya kalidiwai. Teina ta Mose yo peloweta yodi lauhekata maudoina kaniyona ede.” ");
INSERT INTO sbe_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kawakeda gagilina unai kwa lusae. Matawuwuna keda ye lau kabakamkamna magaina unai meta ye masalaha yo kawakedana ye laki, unai tamowai se bado keda ne se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Na mauli kedana meta ye giligili yo kawakedana ye gagili, unai tamowai hisa mo se lobai na unai se lau.” ");
INSERT INTO sbe_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kwa kitanamwanamwakalili pelowetalupolupo udiyedi. Mamoe kadi kaoyena se laowa kalimiuyena, na iyamo kadi kao mamohoina meta siya doha kedewanukula kaikaikalasidiyao. ");
INSERT INTO sbe_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Siya laulau saha se miyamiyaedi ne udiyedi kabo kwa kitalobaidi. Nige gonowana tamowai hesau maimaina gwaligwalina unai wine kaniyona ye gigi, yo hinage nige gonowana kaiwa gwaligwalidi udiyedi bosibosi kaniyona ye gigi. ");
INSERT INTO sbe_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yo hinage kaiwa yababana kaniyona meta kaikailewa, na kaiwa namwanamwana kaniyona meta kaikaina. ");
INSERT INTO sbe_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaiwa namwanamwana unai taba nige kaiwa yababana kaniyona ta lobai, yo hinage kaiwa yababana unai taba nige kaiwa namwanamwana kaniyona ta lobai. ");
INSERT INTO sbe_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ena taba kaiwa hesau kaniyona nige se namwa meta kabo se koigabaei na se tulaei kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unai kaiwa kabakitalobaina ede kaniyona udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tamowai se bado se hededelaoma kaliguwai se wane, ‘Guiyau, Guiyau!’, na iyamo nige gonowana maudoidi se lusae galewa basileiyana, na tamagu galewa ne unai yona nuwatu kaiteyadi se ginauliwatanidi, siya se bom mo kabo se lusae. ");
INSERT INTO sbe_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hekasa mayadaina ne unai meta boda kabo se wane, ‘Guiyau, Guiyau, hesamyena ka hededepeloweta, yo hesamyena demoni ka hededehepesadi, yo hinage hesamyena laulau gigigigibwalidi ka ginaulidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kabo ya hededelau kalidiyena ya wane, ‘Nige kabimiu ya kata, kwa tausuwala, komiu yomi laulau se yababakalili.’” ");
INSERT INTO sbe_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Unai, kaiteya yogu hedehedede ta ye lapuidi na ye miyawatanidi meta iya doha tamowai sibasibana weku kewanaena ye kabinuma. ");
INSERT INTO sbe_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na kabo nabu ye talu, kabaita ye didi, yo hinage yaumai ye towa na numa wa ye nukunuku, na nige ye guli, matawuwuna ede numa wa weku kewanaena ye hetolo. ");
INSERT INTO sbe_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na kaiteya yogu hedehedede ta ye lapuidi na nige ye miyawatanidi meta iya doha tamowai yauyaulena, malanaganagaliyena yona numa ye hetolo. ");
INSERT INTO sbe_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na kabo nabu ye talu, kabaita ye didi yo yaumai ye towa ede numa wa ye nukuheguli yo ye tatagwaligwali.” ");
INSERT INTO sbe_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu yona lauhekata maudoidi wa gehediyena meta boda wa se noko, ");
INSERT INTO sbe_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","matawuwuna ede yona lauhekata wa meta ma gigibwalina, nige doha laugagayo taulauhekataeina tamowaidiyao. ——————— ");
INSERT INTO sbe_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu kuduli wa unai ye lauhekatagehe ede maiyana hekahekatao se lidi se dobi na boda se laoma se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na kabo tamowai hesau lepela kalinawai ye laoma ye tulibono na ye hededelau Yesu unai ye wane, “Guiyau, ena ku henuwa, kabo yom gigibwali unai gonowana ku heꞌaꞌagau.” ");
INSERT INTO sbe_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na Yesu ye kabilau tamowai wa unai na ye wane, “Ya henuwa, ku aꞌa!” Mahanana ne unai lepela wa ye ulugehe na tamowai wa ye aꞌa. ");
INSERT INTO sbe_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kabo Yesu ye hededelau unai ye wane, “Tabu tamowai hesau yona ku hedehedede! Na ku lau, yom kaitalasam ku hai doha Mose yona laugagayo unai ye hededeyako wa na ku bahelaei taukaitalasam unai ku mosei yo hinage ye kitago, unai kabo tamowai se kitalobai meta ku namwanamwako.” ");
INSERT INTO sbe_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Huyana Yesu ye lage Kapelenauma unai meta Loma yodi iyala taubagunaena tamowaina hesau ye laoma Yesu unai ye kaibwadasagu ");
INSERT INTO sbe_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ye wane, “Guiyau, yogu taupaisowa hesau meta ye kasiyebwa na tauna meta se kamkamnakalili nige gonowana tauna ye hetetelidi, iya ede numaena ye kenokeno.” ");
INSERT INTO sbe_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ede Yesu ye wane, “Kabo ya laowa ya henamwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na iyala taubagunaena tamowaina wa ye wane, “Guiyau, nige ya namwa na bena ku laoma yogu numaena. Na taba ku hedehedede mo kabo yogu taupaisowa ne ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Matawuwuna yau hinage meta kagu tanuwaga yona gigibwali gunina unai, yo yau hinage tauꞌiyala tauwoyaidi. Ya hededelau hesau unai ya wane, ‘Ku lau’, meta ye lau. Na hesau unai ya wane, ‘Ku laoma’, meta kabo ye laoma. Yo ya hededelau yogu heyayai tauhaina unai ya wane, ‘Paisowa ne ku ginauli’, meta ye ginauli.” ");
INSERT INTO sbe_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu hedehedede wa ye lapuidi meta ye nokokalili. Na ye hededelau tauhemuliwatanina bodana wa udiyedi ye wane, “Mamohoikalili, ya hededelaowa kalimiuyena, Isalaela unai nige tamowai hesau ya kita yona sunuma bayabayaona doha teina! ");
INSERT INTO sbe_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na ya hededelaowa kalimiuyena, teha bolime yo teha yalasi udiyedi boda kabo se laoma na Abelahama, Isako yo Yakobo maiyadiyao se tuli galewa basileiyana kaikaigogona unai. ");
INSERT INTO sbe_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na galewa basileiyana ne Yaubada ye kabinonohai meta Isalaela tamowaidiyao hesabadi, na iyamo tamowaidi kabo ye tolelaeidi masigili magaina unai. Temenai kabo se doudou yo kawadi se kapuyahisidi.” ");
INSERT INTO sbe_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na Yesu kabo ye hededelau iyala taubagunaena wa unai ye wane, “Yom sunuma ne debanaena yom taupaisowa ne kabo ye namwanamwa, na ku lau yom magai.” Mahanana ne unai yona taupaisowa wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na kabo Yesu ye lau Petelo yona numa unai na Petelo bwasiyana sinebada ye kita meta tauna se gwagwama yo ye kasiyebwa na ye kenokeno. ");
INSERT INTO sbe_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ye kabilau sinebada wa nimana unai meta kasiyebwa wa ye gehe na sinebada wa ye namwanamwa, ede ye kabinonoha na Yesu ye haitalai. ");
INSERT INTO sbe_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Meimeilahina ne unai mahana ye dui na kabo tamowai yaluwa yabayababadi se tanuwagaidi wa se woyaidima na yaluwa yabayababadi wa ye hededehepesadi. Yo taukasiyebwa maudoidi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Teina laulau gigigigibwalidi ye ginaulidi ta unai meta Yaubada kalinana peloweta Aisaiya ye hededediko wa ye hemamohoiyeidi doha ye wane, “Iya meta yoda basabasa maudoidi ye haigabaeidi na kada kasiyebwa ye henamwanamwadi.” ");
INSERT INTO sbe_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu boda wa ye kita meta ye laki ye laulau, unai ye hededelau yona hekahekatao wa udiyedi meta bena se kawasilau Galili Gabwana hali sanakawasina ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na kabo laugagayo taulauhekataena hesau ye laoma Yesu unai na ye wane, “Taulauhekata, yom kabalau maudoidi udiyedi yau kabo ya hemuliwatanigo.” ");
INSERT INTO sbe_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na Yesu ye hededebui ye wane, “Kedewa nukula yodi duha, yo hinage manuwa yodi noi, na Tau Natuna nige yona kabakaiyawasi mamohoina hesau.” ");
INSERT INTO sbe_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na tauhemuliwatanina hesau ye hededelau Yesu unai ye wane, “Guiyau, taba gonowana ya uyo magai na tamagu toletoletauna ya kitabagunaei?” ");
INSERT INTO sbe_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na Yesu ye hededelau unai ye wane, “Kowa ku hemuliwatanigau, na kaiteyadi se boitako meta siya bena kehadi tauboita ne se lae bwayabwaya unai se tole.” ");
INSERT INTO sbe_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na kabo Yesu maiyana hekahekatao se dobi wagaena se gelu na Galili Gabwana wa unai se kawasi. ");
INSERT INTO sbe_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yesu waga wa unai ye kenoko na makesega kabo wowoli ye lage na waga wa bagodu se iniꞌinipuluhi. ");
INSERT INTO sbe_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Unai yona hekahekatao wa iya se hanoi na se wane, “Guiyau, ku hesaguhaida! Nige bayaona kabo ta yoli!” ");
INSERT INTO sbe_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na Yesu ye hededelau udiyedi ye wane, “Idohagi to kwa matausi? Yomi sunuma taki se gagili!” Ede ye tolo na ye hededebayao yaumai yo bagodu wa udiyedi, meta yaumai wa ye kaiyawasi na gabwa wa ye daumwali. ");
INSERT INTO sbe_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Unai yona hekahekatao wa meta se nokokalili na se wane, “Teina meta tamowai sahasahana? Ede yaumai yo bagodu, iyamo iya se kawakabiyei.” ");
INSERT INTO sbe_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kabo Yesu ye dunasae Gadala tamowaidiyao yodi teha unai. Tenem teha ne unai meta tamowai labui, yaluwa yabayababadi siya se luwuidi. Yodi laulau se yababakalili ede nige gonowana tamowai hesau ye lau temenai. Yodi kabamiya meta tamowai yodi kabatoletoledi duhadiyao, udiyedi se pesa se laoma Yesu se hailobai. ");
INSERT INTO sbe_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Se yogalau unai se wane, “Yaubada Natuna, saha ku henuwa kalimaiyena? Yaubada yona kaisunuwa mayadaina meta sola nige ye lage, na ku laoma ta bena ku hekamkamnanonohaigai?” ");
INSERT INTO sbe_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na tehalaudi wa unai meta puwaka yawoina se dumudumuli. ");
INSERT INTO sbe_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ede demoni wa se wane, “Ena ku hededehepesagai, taba gonowana ku hetamaligai na ka lau puwaka ne udiyedi ka luwu?” ");
INSERT INTO sbe_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Unai Yesu ye hededelau demoni wa udiyedi ye wane, “Kwa lau!” Ede tamowai wa se pesagabaeidi na puwaka wa udiyedi se luwu. Kabo puwaka wa padipadi wa unai se heloigogoi se dobi Galili Gabwana wa unai se mwaloigogoi. ");
INSERT INTO sbe_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na puwaka wa taukitahetetedi se wasabu se lau Gadala magaina lakilakina unai na saha ye tubu wa yo hinage tamowai labui wa wasadi se hedehededeidi. ");
INSERT INTO sbe_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ede magai wa tamowaidiyao maudoidi se laoma Yesu unai. Na huyana iya se kita meta se kaibwadai bena taba yodi magai tanona ne ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu waga hesau unai ye gelu na ye kawasiꞌuyo yona magai Kapelenauma. ");
INSERT INTO sbe_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Menai tamowai hekadiyo tau hesau bunibunina diyadiyali unai se baheiyama iya unai. Yesu yodi sunuma ye kita na ye hededelau taubunibuni wa unai ye wane, “Natugu! Ku nuwabayao, yom yababa ya nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na laugagayo taulauhekataedi hekadiyo se bom se gadigadigugu se wane, “Teina tamowai ta meta Yaubada ye hededeheyaheyababa.” ");
INSERT INTO sbe_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yodi nuwanuwatu wa Yesu kabidi ye kata ede ye hededelau udiyedi ye wane, “Idohagi na nuwanuwatu yababadi kwa nuwanuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hedehedede sahasahana ye biga ede, ya wane, ‘Yom yababa wa ya nuwatugabaeidi’, o, ya wane, ‘Ku tolo na ku laulau’? ");
INSERT INTO sbe_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ya henuwa bena kabina kwa kata meta Tau Natuna iya kaiyaulina ta unai yona gigibwali gonowana yababa ye nuwatugabaeidi.” Ede ye hededelau taubunibuni wa unai ye wane, “Ku tolo, yom dam ne ku bahei na ku lau yom numa.” ");
INSERT INTO sbe_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ede tamowai wa ye tolo na ye lau yona magai. ");
INSERT INTO sbe_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Laulau saha ye tubu wa boda se kita meta se siliyata na Yaubada se hedebasaei, matawuwuna gigibwali wa ye mosei tamowai udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu magai wa ye laugabaei ye laulau, na takisi tautanotano hesau hesana Mataiyo ye kita takisi kabatanotano numana unai ye tutuli. Ye hededelau unai ye wane, “Ku hemuliwatanigau.” Ede Mataiyo ye tolo na ye hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na muliyena ede se lau Mataiyo yona numa unai na se kaikai. Na takisi tautanotano bodadi yo hinage yababa tamowaidi hekadiyo se laoma Yesu yo yona hekahekatao wa maiyadiyao se kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Paliseya tamowaidiyao se kitadi ede yona hekahekatao wa se henamaiyeidi, “Idohagi to tauhekatagomiu ne takisi tautanotano yo yababa tamowaidi ne maidanao se kaikaigogoi?” ");
INSERT INTO sbe_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yodi hedehedede wa Yesu ye lapui na ye hededebui ye wane, “Taukasikasiyebwa mo se henuwa doketa, na tamowai namwanamwadi meta nige. ");
INSERT INTO sbe_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na kwa lau teina hedehedede ta kaniyona kwa wasenei: ‘Katekamkamna mo ya henuwa, na nige kaitalasam.’ Yogu laoma ta meta nige tamowai yodi miyamiya dudulaidi hesabadi, na yababa tamowaidi bena ya yogaisinidi.” ");
INSERT INTO sbe_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na kabo Yowane Babatiso yona hekahekatao se laoma Yesu se henamaiyei, “Idohagi to kai yo Paliseya tamowaidiyao ka kaikaihudi, na tauhemuliwatanigo nige se kaikaihudi?” ");
INSERT INTO sbe_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ye hededebui ye wane, “Idohagi to tautawasola kana taumana yona tawasola kaikaigogona unai bena se nuwadubu? Iyamo sola mayadaina kabo ye laoma tautawasola kabo kalidiyena se laeihesuwala na kehanao ne kabo se kaihudi. ");
INSERT INTO sbe_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nige gonowana tamowai hesau kaleko hauhauna tupwana unai kwama beyabeyana ye polai, matawuwuna kaleko hauhauna tupwana ne kabo kwama beyabeyana ne ye tabepulisi na tapulisina ne meta kabo ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yo hinage tamowai nige gonowana waina hauhauna se ini waina pakuna beyabeyana unai. Taba waina hauhauna se ini paku beyabeyana unai, kabo paku ne ye tapulisi, na waina wa kabo ye bwalili. Unai waina hauhauna ta ini waina pakuna hauhauna unai, kabo se namwanamwalabulabui.” ");
INSERT INTO sbe_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu sola ma hedehededena, na magai wa yodi sunago badana hesau ye laoma Yesu matanaena ye tulibono na ye wane, “Natugu waihiu kaboina ta ye boita, na ku laoma nimam ku tolesae iya kewanaena, kabo ye mauli.” ");
INSERT INTO sbe_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ede Yesu yo yona hekahekatao wa se tolo na maiyadi se lau. ");
INSERT INTO sbe_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Se laulau, na kabo sinebada hesau kwasina ye miyamiyagabaei bolimai saudoudoi-labui, iya Yesu dagelana ne unai ye laoma na kana kwama sinosinona ye kabitonogi. ");
INSERT INTO sbe_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yona nuwanuwatu unai ye wane, “Taba kana kwama mo ya kabitonogi, kabo ya namwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na Yesu ye kitabui sinebada wa ye kita ede ye hededelau unai ye wane, “Natugu, nuwam ye bayao! Yom sunuma ta ye henamwanamwago.” Na mahanana ne unai waihiu wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sunago badana wa yona numa unai se lage ede tauhigohigo yo taudoudou bodadi se kitadi, ");
INSERT INTO sbe_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","na Yesu ye hededelau udiyedi ye wane, “Kwa pesa! Sinekuku me nige ye boita, na ye keno mo.” Na se talatalawasiyei. ");
INSERT INTO sbe_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Boda wa ye hetamalidi se pesagehe kabo Yesu ye mwalae sinekuku wa yona kabakeno wa unai na ye kabilau nimana wa unai, ede ye tolo. ");
INSERT INTO sbe_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na wasana wa ye lau tenem teha ne maudoina unai. ");
INSERT INTO sbe_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu sunago badana yona numa wa ye laugabaei ye laulau na taumatagibugibu labui se tolo na se hemuliwatani na se yogayoga se wane, “Dawida natuna! Ku katekamkamnaegai!” ");
INSERT INTO sbe_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na ye mwalaesae yona kabamiya numana unai na taumatagibugibu wa se laoma iya unai. Na ye henamaiyeidi ye wane, “Kwa kawamamohoi meta gonowagu ya henamwanamwagomiu?” Se wane, “Guiyau, ka kawamamohoi!” ");
INSERT INTO sbe_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kabo matadi ye kabitonogidi na ye wane, “Saha kwa kawamamohoiyei wa kabo ye tubu kalimiuyena.” ");
INSERT INTO sbe_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ede matadi wa se lala. Na Yesu ye laugagayoidi ye wane, “Tabu tamowai hesau yona kwa hedehedede!” ");
INSERT INTO sbe_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na iyamo muliyena se lau ede Yesu wasana wa se helaki tenem teha maudoina ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Taudi labui wa se hetubu se dalahai, na tatao hekadi kadi kaha hesau se woyaiyama Yesu unai. Yaluwa yabayababana meta ye luwu tamowai wa unai, ede ye unaꞌuna. ");
INSERT INTO sbe_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na Yesu yaluwa yabayababana wa ye hededehepesa, ede tamowai unaꞌunana wa ye hedehedede. Na boda se noko se wane, “Nige sola laulau hesau doha teina ka kita Isalaela unai!” ");
INSERT INTO sbe_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Na Paliseya tamowaidiyao se wane, “Yaluwa yabayababadi kadi tanuwaga yona gigibwaliyena yaluwa yabayababadi ye hededehepesadi.” ");
INSERT INTO sbe_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kabo Yesu ye lau magai lakilakidi yo kasa gagilidi ye tauhetakikilidi. Na ye lauhekata yodi sunago udiyedi yo Yaubada yona basileiya wasana namwanamwana ye wasaduwaiyei, yo hinage tamowai kadi kasiyebwa udoiꞌudoi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na boda wa ye kitadi ede ye katekamkamnaedi, matawuwuna pilipili udoiꞌudoi se hekalodi na nige tausaguidi, kadi kao doha mamoe nige taukitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na ye hededelau yona hekahekatao wa udiyedi ye wane, “Koya ne ye masulikalili, na taupaisowa meta nige se bado. ");
INSERT INTO sbe_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Unai kwa kaibwadalau masuli guiyauna unai na kabo koya ne taupaisowaina ye hetamalidima.” ");
INSERT INTO sbe_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu yona hekahekatao saudoudoi-labui wa ye yogagogoidima na gigibwali ye moseidi bena yaluwa bikibikidi se hededehepesadi yo tamowai kadi kasiyebwa udoiꞌudoi se henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Taupaisowa ye hetamalidi wa hesadiyao ede teina: Bagubagunana ede Simona, hesana hesau meta Petelo, yo kana kaha Andeleya. Yamesi Sebedaiyo natuna, yo kana kaha Yowane. ");
INSERT INTO sbe_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo yo Batolomaiyo, Tomasi yo Mataiyo, iya takisi tautanotano, Yamesi Alepaiya natuna, yo Tadaiyo, ");
INSERT INTO sbe_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona Tauhaikabi, yo Yudasi Isakaliyota, Yesu kana tauwalohai. ");
INSERT INTO sbe_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tatao saudoudoi-labui wa Yesu ye guguyaidi na ye hetamalidi ye wane, “Tabu kwa laulau dagela tamowaidiyao yo Samaliya tamowaidi yodi magai udiyedi, ");
INSERT INTO sbe_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","na kwa lau Isalaela tamowaidiyao mo udiyedi, siya doha mamoe gegegegediyao. ");
INSERT INTO sbe_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kwa lau na kwa wasaduwai kwa wane, ‘Galewa basileiyana ye hanahanaumako.’ ");
INSERT INTO sbe_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Taukasikasiyebwa kwa henamwanamwadi, tauboiboita kwa hemauliꞌuyoidi, taulepelepela kwa heꞌaꞌadi, yo yaluwa yabayababadi kwa hededehepesadi. Kainauya ta kwa haimoei nige maisana, unai kwa kainauyaei, tabu maisana. ");
INSERT INTO sbe_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Tabu moni gole o siluba o kopa kwa baheidi, yo tabu tobwa, kwama, buti, yo tuke kwa laulaubaheidi yomi lau ne unai. Matawuwuna taupaisowa yona dudulai ede taba tamowai iya se sagui kai yo gogo udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ena magai hesau unai kwa lage meta tamowai namwanamwana hesau kwa wasenei na yona numa unai kwa miya kana siga kwa dalahai. ");
INSERT INTO sbe_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Huyana kwa mwalaesae numa ne unai meta yomi lautoki kwa mosei kwa wane, ‘Nuwadaumwali kwa hai!’ ");
INSERT INTO sbe_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ena numa ne tamowaidiyao se namwa, meta yomi nuwadaumwali ne kwa tole kalidiyena. Ena nige se namwa, meta yomi nuwadaumwali ne kwa haiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ena magai hesau nige se yogaisinigomiu o se lapulaowa kalimiuyena, meta kaemiu mukalidi kwa koinihinihiyeidi na numa o magai ne kwa laugabae. ");
INSERT INTO sbe_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya hededemamohoi kalimiuyena: Yaubada yona hekasa mayadaina ne unai meta kadi hekamkamna se lakikalili, na kabo Sodoma yo Gomola.” ");
INSERT INTO sbe_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ya hetamaligomiu ta kami kao doha mamoe se lulau kedewa kaikaikalasidiyao udiyedi. Unai bena kwa sonoga doha mwata, yo tabu yababa hesau kalimiuyena, doha bunebune. ");
INSERT INTO sbe_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bena kwa kitakitanamwanamwa, tamowai kabo se laegomiu magai babadadiyao udiyedi, yo sunago udiyedi kabo se pidiligomiu. ");
INSERT INTO sbe_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yau debaguyena kabo se haigomiu na se laegomiu gabana yo wasawasa matadiyena, bena kwa hemala galewa basileiyana wasana tauhededehemasalahana siya yo dagela tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na huyana se haigomiu na se helauhetalagomiu meta tabu kwa mode bena saha yo idohagi kabo yomi hedehedede. Huyana ne unai kabo hedehedede se masalaha. ");
INSERT INTO sbe_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Matawuwuna hedehedede kwa hedededi ne meta nige komiu, na Tamamiu Yaluwana ye hemasalahadi kalimiuyena na kwa hedededi. ");
INSERT INTO sbe_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tamowai kabo yona saeya kana ye walohai, yo tama kabo natuna kana ye walohai. Natu kabo se tolo na sinadiyao yo tamadiyao se hewaiunudi na se mosegabaeidi na se unuhemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tamowai maudoidi kabo se subugomiu yau debaguyena. Na kaiteya ye miyatahitahi kana siga gehena unai, iya kabo mauli ye lobai. ");
INSERT INTO sbe_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ena magai hesau unai se hewaiunugomiu meta kwa yabubu kwa lau magai hesau. Hedehedede ta meta mamohoi, yo hinage ya hededelaowa meta nige gonowana Isalaela magaidiyao kwa lauhegehedi na kabo Tau Natuna ye uyoma. ");
INSERT INTO sbe_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nige gonowana wawaya hesau ye saekalili na kabo tauhekatana. Yo hinage nige gonowana taupaisowa ye saekalili na kabo kana tanuwaga. ");
INSERT INTO sbe_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ena wawaya ye sonoga doha tauhekatana meta ye namwa, yo ena taupaisowa se kabi doha kana tanuwaga, meta ye namwa. Ena numa tanuwagana se hedede meta iya yaluwa yabayababadi kadi tanuwaga Belesebulu, kabo yona numa tamowaidiyao ne hinage se hededeheyababakaliliyeidi.” ");
INSERT INTO sbe_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Unai, tabu kwa matausiyeidi! Ginauli wadawadamdi maudoidi meta kabo se masalaha, yo nuwanuwatu wadawadamdi maudoidi Yaubada kabo ye tolehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Boniyaiyena saha ya hedededi wa kabo kwa hededeꞌuyoidi mayadaiyena, yo saha beyamiuyedi ya hededegadigadiguguyedi wa kabo numa kewadi udiyedi kwa hededehelakidi. ");
INSERT INTO sbe_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tabu buluma tauhemwaloina kwa matausiyeidi, na siya nige gonowana yaluwa se hemwaloi. Na Yaubada mo bena kwa matausiyei, matawuwuna iya gonowana buluma yo yaluwa ye unuhemwaloidi kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pene kesega unai gonowana pekopeko labui ta hemaisadi. Iyamo Tamamiu galewa ne unai, iya ye nuwatukaliliyeidi. Taba hesau ye beku, meta kabina ye kata. ");
INSERT INTO sbe_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yo hinage kulumiu maiyawadi meta ye hasilidiko. ");
INSERT INTO sbe_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Unai tabu kwa matausi. Komiu kwa saekalili na kabo pekopeko yawoina. ");
INSERT INTO sbe_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kaiteya ye hededehemasalahaꞌuyoi tamowai matadiyena meta iya tauhemuliwatanigau, kabo yau hinage ya hededehemasalaha Tamagu galewa ne unai matanaena meta iya yogu tamowai. ");
INSERT INTO sbe_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na kaiteya ye uhalaegau boda udiyedi, kabo hinage yau ya uhalaei Tamagu galewa ne unai matanaena. ");
INSERT INTO sbe_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tabu yomi nuwatu bena ya laoma ta nuwadaumwali ya laeiyama kaiyaulina ta unai. Nige! Na ya laoma ta meta kelepa ya baheiyama. ");
INSERT INTO sbe_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya laoma ta bena ‘tau kabo tamana ye hewaiunu, sine kabo sinana ye hewaiunu, yo sinehelam kabo lawana ye hewaiunu. ");
INSERT INTO sbe_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamowai kana waiunu ede kabo yona numakalo tamowaidiyao.’ ");
INSERT INTO sbe_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ena kaiteya tamana yo sinana ye gadosisikaliliyeidi na kabo yau, iya nige gonowana yau yogu. Yo ena kaiteya natuna tau o sine ye gadosisikaliliyeidi na kabo yau, iya nige gonowana yau yogu. ");
INSERT INTO sbe_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yo kaiteya nige ye henuwa yona sataulo ye bahei yo ye hemuliwatanigau meta iya nige gonowana yau yogu. ");
INSERT INTO sbe_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kaiteya yona mauli tanoubu ta unai ye nuwatukaliliyei meta kabo yona mauli nige kana siga ye kabisapuli. Na kaiteya yona mauli tanoubu ta unai ye mosegabaei yau debaguyena, iya kabo mauli nige kana siga ye lobai. ");
INSERT INTO sbe_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kaiteya ye yogaisinigomiu, yau hinage ye yogaisinigau. Yo kaiteya ye yogaisinigau meta tauhetamaligau wa hinage ye yogaisini. ");
INSERT INTO sbe_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaiteya peloweta hesau ye yogaisini matawuwuna iya peloweta, yona kainauya kabo gonogonowana doha peloweta. Yo kaiteya tamowai dudulaina hesau ye yogaisini matawuwuna iya tamowai dudulaina, iya yona kainauya kabo gonogonowana doha tamowai dudulaina yona kainauya. ");
INSERT INTO sbe_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yo hinage ena tamowai hesau yona sagu gagilina doha waila kaputina ye mosei tamowai dobidobina hesau ta unai, matawuwuna iya tauhemuliwatanigau, ya hededemamohoi: Iya yona kainauya kabo ye hai.” ");
INSERT INTO sbe_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu yona hekahekatao saudoudoi-labui wa ye hededehasahasaidi ye gehe, na kabo ye dalahai ye lau Galili magaidi udiyedi ye lauhekata yo ye lauguguya. ");
INSERT INTO sbe_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Yowane Babatiso meta numatutugudu unai, na Keliso yona paisowa wa wasana ye lapui na ye nuwalabulabui. Ede yona hekahekatao ye hetamalidi se lau Yesu unai ");
INSERT INTO sbe_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bena se henamaiyei se wane, “Mamohoina kowa Kelisona ede ka nayanayai wa, o sola tamowai hesau ka nayanayai kabo ye laoma?” ");
INSERT INTO sbe_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ye hededebui ye wane, “Kwa uyo na saha kwa lapuidi yo kwa kitadi wa Yowane yona kwa hedehedede, ");
INSERT INTO sbe_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","meta taumatagibugibu matadi se lala, taubunibuni se laulau, taulepelepela se namwanamwa, taubeyakolakola se lapulapui, tauboiboita se toloꞌuyo, yo taudehadeha wasa namwanamwana se lapulapui. ");
INSERT INTO sbe_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na kaiteya nige ye nuwalabulabuiyeigau, meta iya gonowana ye gwauyala.” ");
INSERT INTO sbe_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yowane yona hekahekatao wa se dalahai se lau, na kabo Yesu ye hetubu Yowane hedehededena ye hedehededei boda wa udiyedi, ye wane, “Ginauli saha hesabana kwa lau balabala ne unai bena kwa kita? Nuwana didiyali yaumai ye yuhisaei yo ye yuhidobiyei? ");
INSERT INTO sbe_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ena nige meta saha hesabana kwa lau bena kwa kita? Yomi nuwatu bena tamowai hesau yona kaleko wasawasadi kwa kita? Nige! Kaiteyadi kaleko wasawasadi se likwalikwadi, siya wasawasa yodi numa udiyedi se miyamiya. ");
INSERT INTO sbe_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","O nuwana kwa lau bena peloweta hesau kwa kita? Mamohoi, ya hededelaowa Yowane meta ye saekalili na kabo peloweta. ");
INSERT INTO sbe_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iya tamowaina ede wasana peloweta Malakai ye kulinonohaiyako buka tabuna unai: ‘Kabo yogu tautauwasa ya hetamali bena ye kedabagunaego. Iya kabo yom keda ye kabinonohai.’ ");
INSERT INTO sbe_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya hededemamohoi kalimiuyena: Tanoubu ta tamowaidi maudoidi luwadiyena meta nige hesau ye saekalili na kabo Yowane Babatiso. Na tamowai hesau galewa basileiyana unai ye dobikalili, meta tamowaina ne ye saekalili na kabo Yowane. ");
INSERT INTO sbe_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yowane yona huyaena ye hetubu ye laoma teina huya ta meta galewa basileiyana wa ye laki ye lau ma bayaona, na tamowai se bado se kaipatekalili bena se lusae basileiya ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mose yona laugagayo yo peloweta maudoidi ye lau ee Yowane yona huyaena, siya Galewa basileiyana wasana se hedehededei. ");
INSERT INTO sbe_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ena taba yodi hedehedede wa kwa kawamamohoiyeidi, kabo kwa nuwatulobai meta Yowane iya ede Eliya se hededeyako meta kabo ye laoma. ");
INSERT INTO sbe_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na Yesu yona hedehedede ye tubei ye wane, “Teina isi ta tamowaidiyao, saha unai kabo ya hekaigonogonowaidi? Siya doha wawayao bakubakuyena se tutuli na se yogayogalau kadi kahao udiyedi se wane, ");
INSERT INTO sbe_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Higo ka yuhidi, na nige kwa sobu. Siyayau wanadi ka wanaidi, na nige kwa dou.’ ");
INSERT INTO sbe_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yowane ye laoma na ye kaihudi na numanuma bayabayaodi nige ye numadi, na se wane, ‘Yaluwa yabayababana hesau meta iya kalinawai.’ ");
INSERT INTO sbe_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tau Natuna ye laoma ede ye kaikai yo waina ye numanuma, na se wane, ‘Sola kwa kita, ye kaimuyomuyou yo ye numanumayauyaule! Yo iya takisi tautanotano yo yababa tamowaidiyao kadi kaha!’ Na iyamo Yaubada yona sibasiba kabahemamohoiyeina ede tamowai yona laulau dudulaidi.” ");
INSERT INTO sbe_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na Yesu Isalaela magaidiyao hekadiyo ye dilaidi, matawuwuna ede laulau gigigigibwalidi se bado udiyedi ye ginaulidi, na nige se nuwabui. Ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ahani mo komiu, Kolasini tamowaidiyao! Ahani mo komiu Betesaida tamowaidiyao! Yababa lakilakina kabo kwa hekalo. Laulau gigigigibwalidi ya ginaulidi kalimiuyena wa, taba ya ginaulidi magai yabayababadi Taiya yo Sidona udiyedi, meta tamowaidiyao ne kabo se nuwabuiko, na yodi nuwabui ta unai meta kabo nuwadubu kalekodiyao se luwuidi yo taudi maudoidi se hekahusadi. ");
INSERT INTO sbe_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Unai ya hededelaowa kalimiuyena: Yaubada yona hekasa mayadaina ne unai kamkamna lakilakina kabo kwa lobai, na kabo Taiya yo Sidona tamowaidiyao. ");
INSERT INTO sbe_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na komiu Kapelenauma tamowaidiyao, bena kabo Yaubada ye lausinigomiu kwa sae galewa ne? Taba nige! Kabo kwa dobi Hade unai! Laulau gigigigibwalidi ya ginaulidi kalimiuyena wa, taba ya ginaulidi Sodoma unai, meta teina mayadai ta unai kabo Sodoma sola ma miyana. ");
INSERT INTO sbe_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Unai ya hededelaowa kalimiuyena: Yaubada yona hekasa mayadaina ne unai kamkamna lakilakina kabo kwa lobai, na kabo Sodoma tamowaidiyao.” ");
INSERT INTO sbe_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mahanana ne unai Yesu ye gwauyala na ye tapwalolo Tamana unai ye wane, “Tamagu, kowa galewa yo tanoubu Guiyauna. Ya hedebasaego matawuwuna ginauli maudoidi ta ku tolewadamdi na tausonoga yo tausibasiba nige gonowana se nuwatulobaidi. Na tamowai supusupudi udiyedi ginauli ta ku tolehemasalahadi na se nuwatulobaidi. ");
INSERT INTO sbe_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mamohoi, tamagu, teina ta yom nuwatu mamohoina yo yom kabagwauyala ede.” ");
INSERT INTO sbe_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na kabo ye hededelau boda wa udiyedi ye wane, “Tamagu meta tanuwaga gigibwalina maudoina ye leyama kaliguwai. Iya ye bom mo kabigu ye kata, na yau ya bom mo tamagu kabina ya kata, yo hinage yogu kaisunuwa tamowaidi udiyedi tamagu ya hededehemasalaha na kabina se kata.” ");
INSERT INTO sbe_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kabo Yesu ye hededelau udiyedi ye wane, “Yomi taulauhekata laugagayo bayabayaodi se hekatagomiu, na laugagayo ne miyawatanidi meta doha bahebahe polopolohedi. Ena kwa kaikaipatekalili bena laugagayo ne kwa miyawatanidi na unai kamnamiu se yababa, meta kwa laoma kaliguwai, kabo kabakaiyawasi kwa lobai. ");
INSERT INTO sbe_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yau ya nuwabiga yo ya nuwadobidobi, unai yogu lauhekata kwa haidi na kwa miyawatanidi, kabo nuwamiu se talu, ");
INSERT INTO sbe_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","matawuwuna yogu lauhekata ne ye biga, yo kabo bahebahe malamalaena ya leyawa kwa bahei.” ");
INSERT INTO sbe_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabati hesau unai Yesu maiyana hekahekatao se laulau kabo witi koyana hesau se tauduwaduwali se lau. Na se hasali ede se hetubu witi kaniyodiyao se huhudi na se kaidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na Paliseya tamowaidi hekadi se kitadi ede se hededelau Yesu unai se wane, “Ku kita ne! Yom hekahekatao meta Sabati laugagayona se utusi!” ");
INSERT INTO sbe_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na Yesu ye hededelau udiyedi ye wane, “Huyana Dawida ma kana hewahewaliyo se hasali na saha ye ginauli wa wasana kwa hasili o nige? ");
INSERT INTO sbe_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye lusae Yaubada yona Logulogu Tabuna unai na pwalawa hetahetabudi ye haidi ede se kaidi. Unai laugagayo se utusi matawuwuna ede iya yo kana hewahewaliyo maidanao wa pwalawa tabudi ta se kaidi, na taukaitalasam mo gonowana se kaidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yo Mose yona laugagayo kwa hasili o nige? Ye hedede meta taukaitalasam Numa Tabuna unai Sabati maudoina yodi paisowa se ginaginauli na unai Sabati laugagayona se utusi, na iyamo nige kadi gilu. ");
INSERT INTO sbe_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Unai ya hededelaowa kalimiuyena: Tamowai hesau iya ede inai meta ye saekalili na kabo Numa Tabuna laugagayona. ");
INSERT INTO sbe_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada yona hedehedede ye wane, ‘Katekamkamna mo ya henuwa, na nige kaitalasam.’ Taba hedehedede ta kaniyona kabina kwa kata, meta nige gonowana tamowai ta kwa hegilugaibuidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Matawuwuna ede Tau Natuna iya Sabati guiyauna ede.” ");
INSERT INTO sbe_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tenem teha ne ye laugabae kabo ye lau na ye mwalaesae yodi sunago unai. ");
INSERT INTO sbe_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Menai meta tamowai hesau nimana ye giligili yo ye basabasa. Na Paliseya tamowaidiyao wa se kaipate bena Yesu se hegilu, unai iya se henamaiyei se wane, “Taba Sabatiyena tamowai hesau ta kabihenamwanamwa, kabo laugagayo ta utusi o nigele?” ");
INSERT INTO sbe_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ye hededelau udiyedi ye wane, “Ena taba luwamiuyena hesau yom mamoe kesega, na mayadai Sabati unai ye bekudobi duhaena, kabo ku lau ku tabeisiniꞌuyoi o nige? ");
INSERT INTO sbe_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na tamowai meta ye saekalili na kabo mamoe! Unai ye namwa mo taba Sabatiyena laulau namwanamwana ta ginauli.” ");
INSERT INTO sbe_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na kabo ye hededelau tamowai wa unai ye wane, “Nimam ku tuuhedudulai!” Ede nimana wa ye tuuhedudulai, na ye namwanamwa doha nimana hesauna wa. ");
INSERT INTO sbe_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ede Paliseya tamowaidiyao wa se pesa na se koitalaliu taba idohagi na Yesu bena se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu yodi nuwatu wa kabina ye kata, unai magai wa ye laugabaei. Bodalakilaki iya se hemuliwatani na yodi taukasikasiyebwa maudoidi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na ye guguyaidi bena tabu se hedehededehemasalaha meta iya kaiteya. ");
INSERT INTO sbe_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Teina unai Yaubada kalinana peloweta Aisaiya ye hedededi wa se laoma se mamohoi, doha ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Teina ta yogu kaisunuwa tamowaina, yo iya yogu heyayai tauhaina tamowaina ede. Iya ya gadosisiyei, yo ya gwauyalakalili kalinawai. Yaluwagu kabo ya mosei iya unai na yogu kabihemauli wasana kabo ye hededehemasalaha dagela tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iya taba nige ye haikawayagala, yo taba nige ye kalinalakilaki. Hinage tamowai keda udiyedi nige gonowana kalinana se lapui. ");
INSERT INTO sbe_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tamowai basabasadi taba nige ye heyababadi, yo yodi sunuma gagilidi taba nige ye haigabaeidi kana siga yodi dudulai ye moseidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kabo tamowai maudoidi yodi sunuma se tole iya hesanaena.” ");
INSERT INTO sbe_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na kabo tamowai hesau se woyaiyama Yesu unai. Tamowai wa matagibugibuna yo unaꞌunana, matawuwuna yaluwa yabayababana iya ye luwui. Na Yesu ye henamwanamwa, kabo ye hedehedede yo matana se lala. ");
INSERT INTO sbe_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na boda wa se siliyata na se henahenamaiꞌuyoidi se wane, “Teina ta nuwana Dawida Natuna?” ");
INSERT INTO sbe_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na huyana Paliseya boda yodi hedehedede wa se lapui ede se wane, “Teina tamowai ta meta nige yona gigibwali, na yaluwa yabayababadi kadi tanuwaga Belesebulu ye bom mo yona gigibwaliyena yaluwa yabayababadi ye hededehepesadi.” ");
INSERT INTO sbe_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na Yesu yodi nuwanuwatu wa kabina ye kata ede ye hededelau udiyedi ye wane, “Taba basileiya hesau ye bom ye lulululuꞌuyoi, meta taba nige yona namwa hesau ye lobai. Yo taba magai hesau o numa hesau tamowaidiyao se bom se haihaitoledagelaꞌuyoidi, meta taba nige se tolokesega. ");
INSERT INTO sbe_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Taba Satani yona taupaisowa yaluwa yabayababadi ye hepesadi, meta iya ye bom ye hewahewaiunuꞌuyoi na yona basileiya kabo idohagi na ye tolobayao? ");
INSERT INTO sbe_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ena taba yau Belesebulu yona gigibwaliyena yaluwa yabayababadi ya hededehepesadi, meta tauhemuliwatanigomiu kabo kaiteya yona gigibwaliyena yaluwa yabayababadi se hededehepesadi? Unai siya kabo se hegilugomiu meta kwa laupwano. ");
INSERT INTO sbe_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na ena yau Yaubada Yaluwana yona gigibwaliyena yaluwa yabayababadi ya hededehepesadi, meta Yaubada yona basileiya ye laomako. ");
INSERT INTO sbe_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yo hinage nige gonowana taukaiwahali hesau ye mwalae tamowai yasiyasiyalana yona numa unai na yona gogo ye haigaibuidi. Yasiyala wa bena ye paibagunai, na kabo gonowana yona gogo wa ye kaiwahalidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kaiteya nige ye hemuhemuliwatanigau, iya meta tauhewaiunugau. Yo kaiteya nige ye saguigau na tamowai ka woyagogoidima, iya meta tauhetatagwaligwali. ");
INSERT INTO sbe_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Unai ya hededelaowa, Yaubada kabo yababa maudoidi yo hinage Yaubada hededeheyababana maudoidi ye nuwatugabaeidi, na ena tamowai hesau Yaluwa Tabuna ye hededeheyababa, taba nige yababa ne nuwatugabaena. ");
INSERT INTO sbe_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hinage ena kaiteya Tau Natuna ye hededeheyababa, Yaubada kabo yona yababa ne ye nuwatugabaei. Na ena kaiteya Yaluwa Tabuna ye hededeheyababa, meta taba nige yona yababa ne nuwatugabaena teina huya ta unai yo huya kabo se laoma ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kaiwa namwanamwana meta kaniyona namwanamwadi, yo kaiwa yababana meta kaniyona yababadi. Kaiwa kabakitalobaidi ede kaniyodi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Komiu meta doha mwata yabayababadi! Idohagi to bena hedehedede namwanamwadi kwa hedededi? Matawuwuna nuwanuwatu saha nuwada ne unai ye mwayau meta kabo kawadaena ta hededegabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamowai namwanamwana nuwana meta nuwanuwatu namwanamwadi udiyedi ye mwayau, unai iya yona hedehedede yo yona kabikabi kabo se namwa. Yo tamowai yababana nuwana ne meta nuwanuwatu yababadi udiyedi ye mwayau, unai iya yona hedehedede yo yona kabikabi kabo se yababa. ");
INSERT INTO sbe_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na ya hededelaowa, Yaubada yona hekasa mayadaina ne unai kabo tamowai maudoidi se tolo Yaubada matanaena na yodi hedehedede yabayababadi saha se hededediko wa maudoidi kabo se hededehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yomi hedehedede ne udiyedi kabo ye hegilugomiu, yo yomi hedehedede ne udiyedi kabo yailihai kwa lobai.” ");
INSERT INTO sbe_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na kabo Paliseya tamowaidiyao yo laugagayo taulauhekataena hekadiyo se laoma Yesu unai se wane, “Taulauhekata, ka henuwa bena laulau gigigigibwalina hesau ku ginauli na ka kita.” ");
INSERT INTO sbe_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na Yesu ye hededebui ye wane, “Teina isi ta tamowaidiyao se yababa na Yaubada nige se sunumaei na se henuwa bena hekihekinoi hesau ya hekitadi. Na taba nige hekihekinoi hesau se kita, na hekihekinoi kesega mo, kabo unai kwa kitalau ede peloweta Iyona hekihekinoina. ");
INSERT INTO sbe_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iya meta mayadai haiyona yo boniyai haiyona yama lakilakina boganaena ye miyamiya. Doha hinage Tau Natuna kabo mayadai haiyona yo boniyai haiyona bwayabwayaena ye miya. ");
INSERT INTO sbe_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yaubada yona hekasa mayadaina ne unai Ninewa tamowaidiyao kabo se tolo na teina isi ta tamowaidiyao se hegiludi, matawuwuna ede Iyona yona lauguguyaena Ninewa tamowaidiyao wa se nuwabui. Na mayadai ta unai tamowai hesau ye saekalili na kabo Iyona, iya ede maidamiu ta. ");
INSERT INTO sbe_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hekasa mayadaina ne unai magai Siba yodi wasawasa waihiuna kabo hinage ye tolo na teina isi ta tamowaidiyao ye hegiludi, matawuwuna kedalohalohaena ye laoma bena Solomona yona hededesonoga ye lapuidi. Na tamowai hesau iya ede inai, ye sonogakalili na kabo Solomona.” ");
INSERT INTO sbe_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kabo Yesu yona hedehedede ye tubei ye wane, “Huyana yaluwa bikibikina tamowai hesau ye pesagabaei meta ye lau balabalagaibuyena na yona kabakaiyawasi ye wase, na nige hesau ye lobai. ");
INSERT INTO sbe_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kabo ye wane, ‘Hage, ya uyo numa ya laugabaeiꞌusei wa unai.’ Ye lageꞌuyo numa wa ye kita meta se kuyaheꞌaꞌa yo se gwaugogonamwanamwaei, na nige taumiyaina. ");
INSERT INTO sbe_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kabo ye lau yaluwa yabayababadi haligigi-labui ye woyaidima. Siya se yababakalili na kabo iya, na numa wa unai se lusae na se miya. Ede tamowai wa yona mauli ye yababakalili na kabo yona mauli bagubagunana wa. Teina isi yababana ta yodi mauli kabo hinage gonogonowana doha tenem.” ");
INSERT INTO sbe_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Numakaloyena, Yesu sola ma hedehededena boda wa udiyedi, na sinana yo kana kahao se laoma ede dagela wa unai se nayanayai, bena kabo iya maiyadi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na tamowai hesau ye hededelau Yesu unai ye wane, “Sinam yo kam kahao ede dagela ne unai, se henuwa bena se kitago.” ");
INSERT INTO sbe_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kabo Yesu ye hededelau tauhedehedede wa unai ye wane, “Kaiteya iya sinagu, yo kaiteyadi kagu kahao ede?” ");
INSERT INTO sbe_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ye nimahelelelau yona hekahekatao udiyedi na ye wane, “Ku kitadi, teina sinagu yo kagu kahao ede. ");
INSERT INTO sbe_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Matawuwuna kaiteya Tamagu galewa ne unai yona nuwatu ye miyawatani meta iya kagu kaha, lougu, yo sinagu ede.” ");
INSERT INTO sbe_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mayadai kesekesegana ne unai Yesu numa wa unai ye pesa ye dobi Galili Gabwana dedekanaena ye tuli. ");
INSERT INTO sbe_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kabo bodalakilaki se tupagogoima iya unai, ede ye gelu waga hesau unai na ye tuli, na boda maudoidi se totolo nagali wa unai. ");
INSERT INTO sbe_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na kabo ginauli gwaudi heyaheyasoniyena ye hedededi. Ye wane, “Tamowai hesau ye lau yona witi koyana unai na witi likena tumadiyao ye hesulu. ");
INSERT INTO sbe_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye hesuhesulu ede like wa hekadi se bekudobi kedaena. Na manuwa se laoma ede se kaidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Like wa hekadi se beku tano maladebadebana unai. Tano wa nige ye buluma, unai like wa se kinimwamwayau. ");
INSERT INTO sbe_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na mahana ye dalasae na gigibwalina wa unai ede like wa se wowoya, matawuwuna like wa lamdi nige se dobi. ");
INSERT INTO sbe_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hekadi se beku lagau gwaligwalidi luwadiyena. Lagau wa se kini ede like wa se yahaidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yo hinage hekadi se beku bwatano namwanamwana unai, ede like wa se kini yo se kaniyo, hekadi kaniyodi badodi 100, hekadi 60, yo hinage hekadi 30. ");
INSERT INTO sbe_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Muliyena kabo Yesu yona hekahekatao se laoma iya se henamaiyei se wane, “Idohagi to heyaheyasoni ku hepaisowadi na ku hedehededelau tamowai udiyedi?” ");
INSERT INTO sbe_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Unai Yesu ye hededelau udiyedi ye wane, “Galewa basileiyana nuwanuwatuna saesaedi ya hededehemasalahadi komiu kalimiuyena, na siya meta nige ya hedededi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kaiteyadi yogu lauhekata ta se lapulobaidi, siya galewa basileiyana nuwatulobaina kalidiyena kabo ye lakikalili. Na kaiteyadi yogu lauhekata nige se lapulobaidi meta saha se lapui wa kabo se nuwaluluhiyei yo ye gehe kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Heyaheyasoni yogu hepaisowadi kalidiyena kaniyona ede ‘se kaikaikewa, na nige saha se kitalobai, yo se lapulapui, na nige se lapulobai.’ ");
INSERT INTO sbe_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yodi laulau ta udiyedi meta peloweta Aisaiya yona hedehedede wa ye laoma ye mamohoi, doha ye wane, ‘Yogu hedehedede kabo kwa lapulapuidi, na taba nige kwa lapulobaidi. Yogu kabikabi kabo kwa kitadi, na taba nige kwa kitalobaidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Matawuwuna tamowai ta nuwadiyao meta se kwailolokalili, yo beyadi se kolakola, yo matadi se gibu. Na taba matadi se lala, kabo se kitalobai, yo taba beyadi se malapai, kabo hedehedede se lapulobaidi, yo taba nuwadi se masalaha, kabo se nuwatulobai, iyamo nigele. Unai nige gonowana se nuwabui na ya henamwanamwadi.’ ” ");
INSERT INTO sbe_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kabo Yesu yona hedehedede wa ye tubei ye wane, “Na komiu meta gonowana kwa gwauyala matawuwuna matamiyao udiyedi kwa kaikaikewa na beyamiyao udiyedi kwa lapulapui. ");
INSERT INTO sbe_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya hededemamohoi kalimiuyena: Huya bagubagunana unai, peloweta yo laulaududulai tamowaidi se henuwakalili saha kwa kitadi ta bena se kitadi, yo saha kwa lapuidi ta bena se lapuidi, na iyamo nige se kitadi yo nige se lapuidi.” ");
INSERT INTO sbe_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kwa lapulapui, teina ta like tauhesuhesulu heyaheyasonina wa kaniyona ede: ");
INSERT INTO sbe_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kaiteyadi galewa hedehededena ta se lapui na nige se nuwatulobai, kabo tauyababa ye laoma na saha namwanamwana nuwadiyena wa ye haigabaei. Siya nuwadi kadi kao meta doha keda kalona. Tuma wa se bekudobi unai na manuwa se laoma ede se kaidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Maladebadeba unai like se hesulu wa kaniyona ede tamowai hedehedede wa ye lapui na ye haimoei ma gwauyalana. ");
INSERT INTO sbe_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iyamo like ne nige lamna, unai yona miya nige ye loha. Na huyana pilipili yo hewahewaiunu ye hekalodi yogu hedehedede ta debanaena meta ye nuwagwagwama na ye lausuwala. ");
INSERT INTO sbe_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na tamowai hesau hedehedede wa ye lapui na kaiyaulina ta nuwamodemodena udoiꞌudoi yo gogo gadosisidi nuwana ne se hemwayau, ede hedehedede wa kalinawai nige kaniyona. Iya meta doha tano lagau gwaligwalina luwanaena na tuma se bekudobi unai. ");
INSERT INTO sbe_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na like hekadi se bekutalu bwatano namwanamwana unai na kabo hekadi kaniyodi tumadiyao 100 se toledi, hekadi 60, yo hekadi 30. Teina meta doha tamowai hesau hedehedede wa ye lapui yo ye nuwatulobai, ede kaniyona se masalaha.” ");
INSERT INTO sbe_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu heyaheyasoni hesau ye hededeꞌuyoi ye wane, “Galewa basileiyana meta doha tamowai hesau yona koya unai witi likena namwanamwadi ye hesuludi. ");
INSERT INTO sbe_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na boniyaiyena tamowai maudoidi se kenoko, na kana waiunu ye laoma ede lagau likedi ye hesuludi like namwanamwadi wa luwadiyena, na koya wa ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Huyana like namwanamwadi wa se kini na se hetubu se kaniyo meta lagau wa hinage se kini. ");
INSERT INTO sbe_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Koya tanuwagana yona taupaisowa se laoma unai na se wane, ‘Tanuwaga, like namwanamwadi ku kumaidi yom koya ne unai, na lagau ne haedi se laoma ede se kini ne?’ ");
INSERT INTO sbe_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ede koya tanuwagana wa ye wane, ‘Waiunu lagau me ye hesulu, ede se kini.’ Yona taupaisowa wa se wane, ‘Gonowana ka lau lagau ne ka upadi?’ ");
INSERT INTO sbe_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na koya tanuwagana wa ye wane, ‘Taba nige, matawuwuna ena lagau ne kwa upadi, kabo witi ne kwa upahaikesegaidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kwa toledi na se kinigogoi kana siga kelikeli kana huya, kabo ya hedede na witi tautanogogoidi lagau ne se tanobagunaeidi se kuinidi na se gabudi, na kabo witi ne se tanogogoidi na se baheidima yogu sanalaena se toledi.’” ");
INSERT INTO sbe_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu heyaheyasoni hesau ye hededeꞌuyoi tamowai wa udiyedi ye wane, “Galewa basileiyana meta doha kaiwa tumana gagilina tamowai hesau ye hai na yona koyaena ye kumai. ");
INSERT INTO sbe_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Like maudoidi ne udiyedi iya meta tuma gagilikalilina, na ena ye kini koyaena meta iya kabo ye hemala kaiwa lakilakina, na manuwa se laoma lagana ne udiyedi se kabinoi.” ");
INSERT INTO sbe_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hinage Yesu heyaheyasoni hesau ye hededeꞌuyoi ye wane, “Galewa basileiyana meta doha yisti gagilina. Waihiu hesau yisti ne ye hai na pwalawa disina lakilakina unai ye yebwali kabo yisti ne pwalawa maudoina wa ye hesese.” ");
INSERT INTO sbe_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ginauli maudoidi ta ye hedededi boda wa udiyedi meta heyaheyasoni udiyedi ye hedehededeidi. Na nige hedehedede dudulaidiyao udiyedi ye hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kaniyona ede peloweta hesau yona hedehedede wa ye hemamohoiyei, “Kabo kawaguyena heyaheyasoni ya hedededi. Yo hinage kaiyaulina yona huyatubu unai na ye laoma, hedehedede saha Yaubada ye tolewadamdi wa kabo ya hemasalahadi.” ");
INSERT INTO sbe_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu boda wa ye laugabaeidi na ye mwalae numakaloyena. Na yona hekahekatao wa se laoma iya unai se wane, “Witi koyana unai lagau heyaheyasonina wa kaniyona ku hededehemasalaha kalimaiyena.” ");
INSERT INTO sbe_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ye wane, “Like namwanamwana tauhesuluna, iya ede Tau Natuna. ");
INSERT INTO sbe_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na witi koyana meta kaiyaulina, na like namwanamwadi ede Yaubada yona basileiya tamowaidiyao, na lagau meta tauyababa yona tamowai, ");
INSERT INTO sbe_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na waiunu ede diyabolo iya meta lagau likena tauhesuluna. Na kelikeli huyana meta kaiyaulina kana siga, na taukelikeli meta Yaubada yona anelu. ");
INSERT INTO sbe_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lagau ta se upadi na se gabudi meta kabo doha kaiyaulina yona huyagehe unai. ");
INSERT INTO sbe_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tau Natuna yona anelu kabo ye hetamalidi se lau yona basileiya unai, na tamowai kadi kahao se woyalaeidi yababa unai, yo yababa tauginaulidi maudoidi se haigabaeidi, ");
INSERT INTO sbe_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kabo se tuudobiyeidi kaiwa kalakalasina gigigigibwalikalilina unai. Temenai kabo se doudou yo kawadi se kapuyahisidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na siya taukawamamohoi yo yodi laulau se dudulai kadi kao kabo se namanamali doha mahana, Tamadi yona basileiya unai. Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Galewa basileiyana meta doha ginauli wasawasana hesau se tolewadam koyaena. Na tamowai hesau ye lobai bwatano luwanaena, ede ye puluhiwadamꞌuyoi, na ma gwauyalana ye lau yona gogo maudoidi ye lokunegabaeidi na monina wa unai tano wa ye hemaisahai. ");
INSERT INTO sbe_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yo hinage galewa basileiyana meta doha gogo taulokulokune tamowaina hesau giniuba matapoudi namwanamwadi ye wasewase. ");
INSERT INTO sbe_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ena giniuba matapouna namwanamwakalilina hesau ye lobai, kabo ye lau yona gogo maudoidi ye lokunegabaeidi na monina wa unai giniuba matapouna wa ye hemaisahai.” ");
INSERT INTO sbe_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hinage galewa basileiyana meta doha hinaya se galaei gabwaena, na yama kadi kao udoiꞌudoi se hekonadi. ");
INSERT INTO sbe_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hinaya wa yama ye mwayau ede tauyamayama hinaya wa se gayosaei salagomgom wa unai na yama wa se hekasadi, namwanamwadi se usaidi bosaena na yababadi se gabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kaiyaulina kana siga kabo doha teina: Anelu kabo se dobima tamowai yodi miyamiya dudulaidiyao luwadiyena tamowai yababadi se tolehesuwaladi. ");
INSERT INTO sbe_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na baꞌaya tamowaidiyao kabo se tuudobiyeidi kaiwa kalakalasina gigigigibwalikalilina unai. Temenai kabo se doudou yo kawadi se kapuyahisidi.” ");
INSERT INTO sbe_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu yona hekahekatao wa ye henamaiyeidi ye wane, “Teina ginauli maudoidi ya hedededi ta kwa nuwatulobaidi?” Se wane, “Aa, ka nuwatulobaidi.” ");
INSERT INTO sbe_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ye hededelau udiyedi ye wane, “Unai, ena laugagayo taulauhekataena tamowaina hesau, na galewa basileiyana lauhekatana ye haidi, meta iya kana kao ede doha numa hesau tanuwagana yona gogo wasawasadi hauhaudi yo hinage beyabeyadi ye bahehepesadima na ye toledi tamowai matadiyena.” ");
INSERT INTO sbe_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu heyaheyasoni wa udiyedi ye lauhekatagehe ede magai wa ye laugabaei ");
INSERT INTO sbe_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na ye lau yona magai mamohoina Nasaleta. Na yodi sunago unai ye lauhekata ede tamowai wa se siliyata na se wane, “Teina tamowai ta yona sibasiba ta haedi ye hai? Yo yona gigibwali ne haedi ye hai na laulau gigigigibwalidi ye ginaulidi?” ");
INSERT INTO sbe_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na hinage se wane, “Iya kabina ta katako meta kapenta Yosepa natuna, na sinana ede Maliya, yo kana kahao ede Yamesi, Yosepa, Simona, yo Yuda. ");
INSERT INTO sbe_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na lounao maudoidi, siya ede maiyadao ta miyamiya! Na haedi sonoga ta ye haidi?” ");
INSERT INTO sbe_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Unai Yesu se kouyalayalaei. Na ye hededelau udiyedi ye wane, “Magai maudoidi kabo peloweta se hekasisiyei, na yona magai mamohoina yo yona numa tamowaidiyao meta taba nige se hekasisiyei.” ");
INSERT INTO sbe_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na Yesu laulau gigigigibwalidi hisa mo ye ginaulidi, matawuwuna tamowai wa nige se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Huyana ne meta Heloda Antipasi yona huyawasawasa Galili unai. Yesu yona paisowa wasana ye lapuidi ");
INSERT INTO sbe_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ede ye hededelau yona taupaisowa udiyedi ye wane, “Teina meta Yowane Babatiso boita unai ye toloꞌuyoma, unai ede gigibwali kalinawai na laulau gigigigibwalidi ye ginaulidi ta.” ");
INSERT INTO sbe_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Heloda meta kana kaha Pilipo mwanena Helodiyasi ye kwayai. Na Yowane ye hedehededelau unai ye wane, “Kowa laugagayo ku utusi, taba tabu kam kaha mwanena ne ku tawatawasolai!” Ede Heloda ye hedede na Yowane se hai se pai na se tole numatutuguduyena. ");
INSERT INTO sbe_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ye henuwa bena ye unuhemwaloi, na Yudeya tamowaidiyao ye matausiyeidi, matawuwuna ede se hedede meta iya peloweta. ");
INSERT INTO sbe_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na Heloda yona huyalabasi mayadaina henuwaisinina kaikaigogona unai, ede Helodiyasi natuna waihiu meta Heloda ma kana taumana kadi ye sobu. Yona sobu wa unai Heloda nuwana ye namwakalili ");
INSERT INTO sbe_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ede ye hededekaigwala unai ye wane, “Ena kaliguyena ginauli saha hesau ku kaibwadai meta kabo ya haiyawa.” ");
INSERT INTO sbe_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na sinana iya ye guguyaiyako, ede ye hededelau Heloda unai ye wane, “Ya henuwa Yowane Babatiso kulukuluna ku usai gaeba unai na ku haiyama.” ");
INSERT INTO sbe_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heloda ye nuwayababa, na iyamo kana taumana matadiyena ye hededekaigwalako. Unai waihiu wa yona nuwatu ye ginauli ");
INSERT INTO sbe_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ede ye hedede na Yowane Babatiso gadona se boli, ");
INSERT INTO sbe_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","na kuluna wa se usai gaebaena na se baheiyama se mosei hasala wa unai, ede ye bahelaei sinana wa unai. ");
INSERT INTO sbe_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yowane yona hekahekatao se laoma ede sinalena wa se hai na se laei bwayabwayaena se tole. Na saha ye tubu wa wasana Yesu yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu Yowane wasana wa ye lapui ede ye dobi wagaena ye gelu na ye kawasi ye lau balabala hesau unai, matawuwuna ye henuwa bena siya se bom mo. Magai maudoidi tamowaidiyao wa Yesu yona kabalau wasana se lapui ede se hemuliwatani na se yona se lau. ");
INSERT INTO sbe_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na huyana Yesu ye dunasae meta bodalakilaki ye kitadi se nayanayaei. Na boda wa ye katekamkamnaedi ede taukasikasiyebwa maudoidi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ye hetubu ye meimeilahi ede Yesu yona hekahekatao se laoma iya unai se wane, “Teina meta balabalagaibuyena, yo mahana ye laoko. Boda ta ku hetamalidi se lau magai udiyedi kadi se lokune.” ");
INSERT INTO sbe_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Yesu ye wane, “Taba nige kwa hetamaligwaligwalidi, na komiu kai kwa moseidi se kai.” ");
INSERT INTO sbe_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ede se wane, “Teina kalimaiyena ta meta pwalawa haligigi yo yama labui mo.” ");
INSERT INTO sbe_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ede Yesu ye wane, “Kwa baheidima kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na ye hedede boda wa se tuli lagau wa unai. Pwalawa haligigi yo yama labui wa ye haidi ede ye kitasae galewa ne na ye lautoki Yaubada unai, kabo pwalawa wa ye kihidi na ye moseidi yona hekahekatao wa udiyedi, na yona hekahekatao pwalawa yo yama wa se soiyedi boda wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tamowai maudoidi wa se kaikai meta bogadi se sese. Na kaitole wa se tanogogoidi meta bosa saudoudoi-labui se hemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Taukaikai bodana wa unai meta tatao badodi 5,000, na sinesineo yo wawayao nige se hasilikesegaidi. ");
INSERT INTO sbe_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na kabo Yesu yona hekahekatao wa ye hegelumwamwayauyeidi se baguna se lau hali sanakawasi ne, na iya boda wa ye hetamaligwaligwalidi. ");
INSERT INTO sbe_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Se dalahaigwaligwali, na kabo iya ye bom ye sae kuduliyena bena ye tapwalolo. Na ye meimeilahi meta iya ye bom mo menai. ");
INSERT INTO sbe_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waga wa meta gabwa duwaduwalinaena na yaumai se taumatai ede bagodu waga wa se koikoinuwahi. ");
INSERT INTO sbe_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Malatomtom gagilina sola ma masimasigilina Yesu ye dobi gabwa ne, na gabwa kewanaena ye laulau ye lau yona hekahekatao wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yona hekahekatao wa iya se kita gabwa kewanaena ye laolaoma hesabadi meta se matausikalili, ma matausidi na se yogahi se wane, “Aiyoi! Teina ta yaluyaluwa.” ");
INSERT INTO sbe_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na Yesu ye yogalau udiyedi ye wane, “Kwa nuwabayao! Yau Yesu! Tabu kwa matausi!” ");
INSERT INTO sbe_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ede Petelo ye hededelau iya unai ye wane, “Guiyau, ena mamohoina kowa, ku hedede na gabwa ta unai ya laowa kalimwai.” ");
INSERT INTO sbe_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ye wane, “Ku laoma!” Kabo Petelo waga wa unai ye pesa na gabwa wa unai ye laulau ye lau Yesu hesabana. ");
INSERT INTO sbe_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ye laulau na yaumai yo bagodu wa ye kitadi ede ye matausi na ye hetubu ye yoli, ede ye yogalau ye wane, “Yesu, ku saguigau!” ");
INSERT INTO sbe_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na Yesu nimana ye helelelaei na Petelo ye kabihekahini, na ye hededelau unai ye wane, “Yom sunuma taki ye gagili! Idohagi to ku nuwalabulabui?” ");
INSERT INTO sbe_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na se laoma waga wa unai se gelu meta yaumai wa ye motu. ");
INSERT INTO sbe_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ede taumiyamiya waga wa unai Yesu se kaihelahui yo se wane, “Mamohoikalili, kowa Yaubada Natuna!” ");
INSERT INTO sbe_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na kabo se kawasi se lau Genesaleta unai se duna. ");
INSERT INTO sbe_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Magai wa tamowaidiyao Yesu se kitalobai ede wasa se hetamali ye lau magai maudoidi wa udiyedi. Ede taukasikasiyebwa maudoidi se laedima Yesu unai, ");
INSERT INTO sbe_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na se kaibwadakatekamkamna taba kana kwama sinosinona mo se kabitonogi. Na kana kwama taukabitonogina maudoidi se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Paliseya yo laugagayo taulauhekataena hekadiyo Yelusalema unai se laoma na Yesu se henamaiyei se wane, ");
INSERT INTO sbe_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Idohagi to yom hekahekatao kada kulutubu yodi kabikabi laugagayona se utusi? Nimadiyao meta nige se deulidi na se kaikai.” ");
INSERT INTO sbe_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ye hededelau udiyedi ye wane, “Na idohagi to komiu kami kulutubu yodi kabikabi debanaena Yaubada yona laugagayo kwa utusi? ");
INSERT INTO sbe_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Doha Mose yona laugagayo unai Yaubada ye wane, ‘Tamam yo sinam ku hekasisiyeidi.’ Yo ye wane, ‘Ena kaiteya tamana yo sinana ye hededeheyababadi meta bena kwa unuhemwaloi.’ ");
INSERT INTO sbe_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Na komiu kwa hedede kwa wane, ‘Gonowana tamowai hesau ye hededelau tamana yo sinana udiyedi ye wane, “Yogu kainauya bena ya haiyawa kabasaguigomiu wa meta ya talamyeiyako Yaubada unai.” ’ ");
INSERT INTO sbe_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kabikabi ta kwa talamyei, na tama yo sina hekasisidi meta nige! Yomi lauhekata ta unai kwa laupwanokalili. Kami kulutubu kabikabidiyao debadiyena ede Yaubada yona laugagayo wa kwa tolebasiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Komiu taukailupolupo! Komiu hedehededemiu Aisaiya ye hededenonohaiyako wa meta mamohoi, doha ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Teina tamowai ta sopagaibudi mo udiyedi se hekasisiyeigau na nuwamamohoidiyao udiyedi meta Yaubada nuwanuwatuna nigele. ");
INSERT INTO sbe_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Se kaihelahuigau meta nige kaniyona, matawuwuna tamowai yodi laugagayo meta se laulauhekataeidi.’” ");
INSERT INTO sbe_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kabo Yesu boda wa ye yogagogoidima na ye hededelau udiyedi ye wane, “Kwa lapulapui na saha ya hedededi ta bena kwa nuwatulobaidi. ");
INSERT INTO sbe_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ginauli saha kawamyena ku kai na ye dobi meta iya nige gonowana ye hebikigo, na saha luwam ne unai ye saema kawam ne unai ye pesa meta kabo ye hebikigo.” ");
INSERT INTO sbe_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kabo Yesu yona hekahekatao se laoma iya unai se wane, “Yom hedehedede ta unai meta Paliseya bodadi se kouyalayalakalili.” ");
INSERT INTO sbe_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ede Yesu ye hededelau udiyedi ye wane, “Tamagu galewa ne unai taumiya, iya kaiwa sahasahadiyao nige ye kumaidi meta kabo ma lamdi ye suluhihaidi. ");
INSERT INTO sbe_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kwa laugabaeidi se miyawa, siya tauwoyawoya matagibugibudiyao. Ena taba taumatagibugibu hesau yona hali taumatagibugibu ye woyai, meta kabo se bekulabulabuidobi duhaena.” ");
INSERT INTO sbe_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na Petelo ye hededelau Yesu unai ye wane, “Taba gonowana kabahebikida heyaheyasonina wa kaniyona ku hededehemasalaha kalimaiyena?” ");
INSERT INTO sbe_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ede Yesu ye hededelau udiyedi ye wane, “Idohagi, sola ma nuwapwanopwanomiu? ");
INSERT INTO sbe_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nige kwa nuwatulobai? Saha kawada ta unai ta kai meta ye dobi bogada ne unai na kabo ta miyagabaei. ");
INSERT INTO sbe_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na hedehedede saha kawamiuyena se pesama meta nuwamiuyena se masalahama, teina ta tauhebikigomiu ede. ");
INSERT INTO sbe_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Matawuwuna ede nuwada ta udiyedi kabo nuwatu yabayababadi se masalahama, doha kaiunu, ganawali, laulau bikibikidi udoiꞌudoi, kaiwahali, hedehededelupolupo, yo hinage tamowai hededeheyaheyababana. ");
INSERT INTO sbe_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Teina laulau ta, siya tamowai tauhebikina ede. Na ena nimamiu ma bikidi na kai kwa hai kwa kai meta nige gonowana ye hebikigomiu.” ");
INSERT INTO sbe_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kabo Yesu teha Galili ye laugabaei na ye sae teha Taiya yo Sidona udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na Kanana waihiuna hesau temenai taumiya ye laoma Yesu unai ye kaibwadalakilaki ye wane, “Guiyau, Dawida natuna, ku katekamkamnaegau! Yaluwa yababana hesau meta ye luwu natugu sinesinekukuna unai na ye hekasiyebwakaliliyei.” ");
INSERT INTO sbe_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Na Yesu nige saha hesau ye hedede waihiu wa unai. Kabo yona hekahekatao wa se wane, “Waihiu ta ku hetamali ye tausuwala, matawuwuna ede ye dahikwatakwatakalili.” ");
INSERT INTO sbe_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ede Yesu ye hedehedede ye wane, “Tamagu ye hetamaligauma ta meta Isalaela mo tamowaidi hesabadi, siya doha mamoe se laulau kadi heyababa hesabana.” ");
INSERT INTO sbe_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kabo waihiu wa ye laoma ye tulibonodobi Yesu matana wa unai na ye kaibwada ye wane, “Guiyau, ku saguigau!” ");
INSERT INTO sbe_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ye hededebui ye wane, “Nige ye dudulai bena wawayao kadi kai ta haidi na ta gabalaedi kedewa udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na waihiu wa ye wane, “Guiyau, mamohoi, na iyamo kedewa kadi tanuwaga yona hatahataena kana kai mapuladi se bekudobi meta kabo kedewa ne se laoma se kaidi.” ");
INSERT INTO sbe_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Unai Yesu ye hededelau unai ye wane, “Waihiu, yom sunuma meta ye lakikalili! Unai saha ku kaibwadai meta kabo ye masalaha.” Mahanana ne unai waihiu wa natuna sinekuku wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu teha Taiya yo Sidona ye laugabaeidi na ye uyo Galili, na Galili Gabwana dedekanaena ye yona ye lau. Kabo ye sae kuduli gagilina hesau unai na ye tuli. ");
INSERT INTO sbe_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kabo bodalakilaki se laoma na taukasikasiyebwa se laeidima, kasiyebwa doha taubunibuni, taumatagibugibu, tamowai kae yo nima yabayababadiyao, unaꞌunadi yo taukasikasiyebwa hekadi hinage se laeidima Yesu unai, ede maudoidi ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Unai boda wa se nokokalili, matawuwuna ede matadiyena tauꞌunaꞌuna se hedehedede, taubunibuni ye henamwanamwadi, tamowai kae yabayababadiyao se laulau yo taumatagibugibu matadiyao se lala na se kaikewa. Na Isalaela yodi Yaubada se hedebasaei. ");
INSERT INTO sbe_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu yona hekahekatao wa ye yogagogoidima na ye hededelau udiyedi ye wane, “Tamowai ta ya katekamkamnaedi, matawuwuna ede mayadai haiyona inai maiyadao na nige sola kai hesau se kai, unai nige ya henuwa ma hasalidi na ya hetamalidi se lau. Taba ma hasalidi na se lau kabo kedaena hasahasali ye haidi na se guli.” ");
INSERT INTO sbe_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na se hededebui se wane, “Teina balabalagaibu ta unai kabo haedi kai ta hai na bodalakilaki ta ta hekaidi?” ");
INSERT INTO sbe_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ye henamaiyeidi ye wane, “Pwalawa hisa kalimiuyedi?” Ede se wane, “Pwalawa haligigi-labui yo yama habuhabuludiyao hisa ede teinai.” ");
INSERT INTO sbe_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ede ye hededelau boda wa se tulidobi bwatano wa unai. ");
INSERT INTO sbe_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kabo pwalawa yo yama wa ye haidi na ye hededelautokisae Yaubada unai, ye kihidi na ye moseidi hekahekatao wa kalidiyena, na se soiyedi boda wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boda wa se kaikai meta maudoidi bogadi se sese. Na kadi kaitole wa hekahekatao wa se tanoi na se usagogoi meta bosa haligigi-labui se hemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Taukaikai bodana wa unai meta tatao badodi 4,000, na sinesineo yo wawayao nige se hasilikesegaidi. ");
INSERT INTO sbe_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kabo Yesu boda wa ye hetamaligwaligwalidi. Na yawalana ye lau kabo waga hesau unai ye gelu na se lau teha Magadani. ");
INSERT INTO sbe_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Paliseya yo Sadusiya tamowaidiyao hekadi se laoma Yesu unai bena se lautonogi. Na se kaibwadai taba bena galewa hekihekinoina hesau ye ginauli se kita. ");
INSERT INTO sbe_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ye hededelau udiyedi ye wane, “Meimeilahiyena kwa wane, ‘Huya kabo ye namwa, matawuwuna ede mahana ye dui na yada ne ye pululu.’ ");
INSERT INTO sbe_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na malatomtomyena kwa wane, ‘Mayadai ta kabo huya ne ye yababa, matawuwuna ede mahana ye dalasae na yada ne ye pululu yo huya ne ye toleyaloyalohi.’ Huya kadi kao gonowana kwa hededehemasalahadi, na idohagi to teina saha se tubutubu ta meta nige gonowana kaniyodi kwa nuwatulobaidi. ");
INSERT INTO sbe_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Komiu yomi nuwanuwatu se yababa na Yaubada nige kwa kawamamohoiyei, na kwa henuwa bena taba hekihekinoi hesau kwa kita. Na taba nige hesau kwa kita, na kesega mo kabo ya hekitagomiu, iya ede saha ye tubu Iyona peloweta unai wa.” Kabo Yesu ye laugabaeidi na ye lau. ");
INSERT INTO sbe_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Galili Gabwana unai se kawasi se lau na Yesu yona hekahekatao wa se nuwaluluhi ede nige pwalawa se bahei. ");
INSERT INTO sbe_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ye hededelau udiyedi ye wane, “Paliseya yo Sadusiya yodi yisti udiyedi bena kwa kitakitanamwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hekahekatao wa se bom nuwatu wa se hetahetala se wane, “Yona hedehedede ta kaniyona ede nige pwalawa ta bahei.” ");
INSERT INTO sbe_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Saha se hetahetala wa meta Yesu kabina ye kata ede ye hededelau udiyedi ye wane, “Idohagi to yomi sunuma se gagili na kwa bom pwalawa hedehededena kwa hedehededei? ");
INSERT INTO sbe_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nuwana sola nige kwa nuwatulobai? Hage, pwalawa haligigi wa kwa nuwatuidi, ya soiyeidi boda 5,000 se kai na kadi kaitole kwa tanoi na kwa usagogoidi meta bosa badona hisa? ");
INSERT INTO sbe_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yo hinage taba pwalawa haligigi-labui wa kwa nuwatuidi! Ya soiyeidi boda 4,000 se kai na kadi kaitole kwa tanoi na kwa usagogoidi meta bosa hisa? ");
INSERT INTO sbe_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Idohagi to nige kwa nuwatulobai meta yau nige pwalawa ya hetahetala? Na bena Paliseya yo Sadusiya yodi yisti unai komiu kwa kitaheteteꞌuyoigomiu.” ");
INSERT INTO sbe_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Unai kabo se nuwatulobai meta iya nige pwalawa kadi yisti ye hetahetala, na Paliseya yo Sadusiya yodi lauhekata udiyedi bena se kitakitanamwanamwakalili. ");
INSERT INTO sbe_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu maiyana hekahekatao se lage wasawasa Pilipi yona magai Sisaliya unai, kabo yona hekahekatao wa ye henamaiyeidi ye wane, “Tamowai se hedede Tau Natuna meta iya kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ede se wane, “Hekadi se hedede meta kowa Yowane Babatiso, hekadi se wane kowa Eliya, hekadi se wane kowa Yelemaiya, yo hekadi se wane kowa peloweta hesau.” ");
INSERT INTO sbe_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na Yesu ye henamaiyeidi ye wane, “Na komiu? Kwa hedede ede yau kaiteya!” ");
INSERT INTO sbe_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ede Simona Petelo ye hededelau unai ye wane, “Kowa meta Keliso, Yaubada maumaulina natuna.” ");
INSERT INTO sbe_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kabo Yesu ye hededelau unai ye wane, “Simona, Iyona natuna, kowa gonowana ku gwauyala! Teina nuwatu ta meta kowa nige ku bom yom sonoga unai ye laoma, na nuwatu ta meta tamagu galewa ne unai ye hemasalaha kalimwai. ");
INSERT INTO sbe_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Unai ya hededelaowa, kowa meta Petelo, na teina weku ta kewana ne unai kabo yogu dubu ya kabi. Na boita nige gonowana ye hekaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gigibwali ya leyawa na bena Yaubada yona tamowai ku kedabagunaidi. Laulau sahasahadi ku laugagayoidi tanoubu ta unai, meta Yaubada hinage ye laugagayoidi galewa ne unai. Na laulau sahasahadi ku kitahenamwadi, meta Yaubada hinage ye kitahenamwadi.” ");
INSERT INTO sbe_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kabo ye hededelau yona hekahekatao wa udiyedi ye wane, “Tabu tamowai hesau yona kwa hedehedede meta yau Kelisona ede.” ");
INSERT INTO sbe_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Huyana ne unai Yesu ye hetubu yona hekahekatao ye hekatadi na ye hededehemasalaha meta bena taba ye lau Yelusalema. Temenai Dius babadadiyao yo taukaitalasam tauwoyaidi yo laugagayo taulauhekataena kabo iya se hekamkamna kabikabi udoiꞌudoi udiyedi yo kabo se unuhemwaloi, na mayadai hehaiyonana unai kabo Yaubada iya ye hetoloꞌuyoi na ye mauli. ");
INSERT INTO sbe_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kabo Petelo Yesu ye woyahesuwala na ye hededebayao unai ye wane, “Guiyau, teina ginauli ta taba tabu se tubutubu kalimyena.” ");
INSERT INTO sbe_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu ye kitabui Petelo ye kaikewai na ye hededelau unai ye wane, “Ku tausuwala, kowa Satani! Kowa ku hemala yau yogu kabakalabesibesi. Kowa nige Yaubada yona nuwanuwatu ku nuwatuidi, na tamowai mo yodi nuwanuwatu udiyedi ku nuwanuwatu.” ");
INSERT INTO sbe_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na kabo Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Ena taba hesau ye henuwa bena ye hemuliwatanigau, meta iya bena ye bom ye nuwagabaeꞌuyoi na yona sataulo ye bahei na ye hemuliwatanigau. ");
INSERT INTO sbe_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaniyona ede ena hesau ye henuwa bena yona mauli ye bom ye kitahetete, meta kabo yona mauli ye kabisapuli. Na ena debaguyena hesau yona mauli ye nuwagabaei, kabo yona mauli ye lobaiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yo ena tamowai hesau tanoubu ta maudoudoina bena iya yona, na ye bom yaluwana ye unui, kabo saha namwanamwana ye hai? Saha unai kabo yaluwana ne ye hemaisahaiꞌuyoi? ");
INSERT INTO sbe_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Matawuwuna ede Tau Natuna kabo ye uyoma Tamana yona didigaena, maidanao yona anelu. Huyana ne unai tamowai kesega kesega yona mauliyena saha ye ginauliyako wa unai kabo maisana ye mosei. ");
INSERT INTO sbe_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya hededemamohoi: Hekadiyo inai tautotolo ta meta taba nige se boita ye lau ee Tau Natuna se kita ye laoma iya wasawasa yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mayadai haligigi-kesega mulidiyena kabo Petelo, Yamesi, yo Yamesi kana kaha Yowane, Yesu ye woyaidi se sae kuduli kewana saesaena hesau unai. Menai se bom mo, ");
INSERT INTO sbe_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","na matadiyena Yesu kana kao ye bui ye namanamali doha mahana yo kana kaleko se posi yo se dawayakalili. ");
INSERT INTO sbe_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mahanana ne unai menai Mose yo Eliya se taumasalaha na Yesu maiyadi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na Petelo ye hededelau Yesu unai ye wane, “Guiyau, ye namwa mo taba inai ta miya. Ena ku henuwa, kabo inai gwau haiyona ya kabidi, hesau kowa yom, hesau Mose yona, yo hesau Eliya yona.” ");
INSERT INTO sbe_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sola ma hedehededena, na kabo yalohi dawadawayana ye laoma ye gawuidi, na kalina hesau yalohi wa unai ye wane, “Teina yau Natugu ya gadosisiyei. Iya unai ya gwauyalakalili. Kwa lapulapulau unai!” ");
INSERT INTO sbe_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hekahekatao wa hedehedede ta se lapui ede se guliyaboyabomdobi bwatano wa unai ma matamatausidi. ");
INSERT INTO sbe_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na Yesu ye laoma ye kabilau udiyedi na ye wane, “Kwa tolo. Tabu kwa matausi.” ");
INSERT INTO sbe_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Se tamaisima na se kaikewasae meta nige tamowai hesau se kita, na Yesu ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kuduli wa unai se lidi se dobidobi na Yesu ye hededelau udiyedi ye wane, “Saha kwa kita wa meta tabu tamowai hesau yona kwa hedehedede, kana siga Yaubada Tau Natuna boita unai ye hetoloꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na hekahekatao wa Yesu se henamaiyei se wane, “Idohagi to laugagayo taulauhekataena se hedede meta taba bena Eliya yona uyoma ye baguna na kabo Keliso?” ");
INSERT INTO sbe_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ye wane, “Mamohoi, Eliya ye uyoma kabo ginauli maudoidi ye tolehedudulaiꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na ya hededelaowa kalimiuyena: Eliya ede ye laomako, na nige se kitalobai. Na yodi nuwatu saha se henuwa iya unai se ginauli meta se ginaulidiko. Teina kabikabi ta gonogonowana unai kabo Tau Natuna se hekamkamna.” ");
INSERT INTO sbe_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kabo hekahekatao wa se nuwatulobai meta Yesu Yowane Babatiso ye hetahetala. ");
INSERT INTO sbe_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Huyana se dobima boda luwadiyena kabo tamowai hesau ye laoma Yesu unai na ye tulibonodobi matana wa unai ");
INSERT INTO sbe_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ye wane, “Guiyau, natugu tau ku katekamkamnaei. Ye kikikikiwasi, na kasiyebwa ta unai ye kamkamnakalili. Na huya hekadi ye bekudobi kaiwa kalakalasidi kewadiyena yo waila kalodiyena hinage. ");
INSERT INTO sbe_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya laeyama yom hekahekatao udiyedi na nige gonowana se henamwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na Yesu ye hededelau udiyedi ye wane, “Komiu nige yomi sunuma, yo nuwatu yabayababadi tamowaidiyao! Kabo ya miyaꞌuyo lohana doha saha kalimiuyena? Kwa kamnayabayababa! Wawaya me kwa baheiyama kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu yaluwa yabayababana wa ye hededehepesa, ede demoni wa wawaya wa ye pesagabaei. Mahanana ne unai wawaya wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Muliyena kabo hekahekatao wa se bom se laoma Yesu unai se henamai se wane, “Matawuwuna saha to kai nige gonowana yaluwa yababana wa ka hededehepesa?” ");
INSERT INTO sbe_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ye hededebui ye wane, “Nige gonowamiu matawuwuna yomi sunuma se gagilikalili. Ya hededemamohoi kalimiuyena: Taba yomi sunuma lakina doha kaiwa tumana gagilina, gonowana kabo kwa hededelau kuduli ne unai, ‘Ku sigi ku lau menai!’, gonowana kabo ye lauwatani. Nige gonowana ginauli hesau kalimiuyena paisowana ye laki.” ");
INSERT INTO sbe_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Se laomagogoi Galili unai na Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Tau Natuna kabo kana se walohai na tamowai yabayababadiyao kabo iya se hai. ");
INSERT INTO sbe_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kabo se unuhemwaloi, na mayadai hehaiyonana unai kabo Yaubada iya ye hetoloꞌuyoi na ye mauli.” Ede yona hekahekatao wa se nuwayababakalili. ");
INSERT INTO sbe_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu maiyana hekahekatao se lage Kapelenauma, na kabo Numa Tabuna takisina tautanotano se lau Petelo unai se wane, “Kami tanuwaga hinage takisi ye toletole o nige?” ");
INSERT INTO sbe_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ye wane, “Aa, takisi ye toletole.” Petelo ye uyo numa ede Yesu ye hededebagunalau unai ye wane, “Simona, hage, yom nuwatu idohagi? Tanoubu ta wasawasadiyao kaiteyadi udiyedi takisi se tanotano? Se bom yodi magai tamowaidiyao udiyedi, o hali magai tamowaidiyao udiyedi?” ");
INSERT INTO sbe_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petelo ye wane, “Tamowai hekadiyao udiyedi.” Na Yesu ye hededelau unai ye wane, “Unai yodi magai tamowaidiyao meta taba nige takisi se tole. ");
INSERT INTO sbe_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na takisi tautanotano wa bena tabu ta henuwapilipilidi. Unai ku lau gabwa ne unai ku huku. Yama bagubagunana ku katuni meta kawana ne ku gasi, kabo unai moni kesega lakina ede dalakama hasi ku lobai. Ku hai na kowa yo yau yoda takisi monina ku tole.” ");
INSERT INTO sbe_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Huyana ne unai hekahekatao wa se laoma Yesu unai se henamai se wane, “Galewa basileiyana unai meta kaiteya ye saekalili?” ");
INSERT INTO sbe_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu wawaya gagilina hesau ye yoganeiyama na luwadi wa unai ye hetolo, ");
INSERT INTO sbe_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na ye wane, “Ya hededemamohoi kalimiuyena: Nige gonowana kwa lau galewa basileiyana unai kana siga kwa buigomiu kwa hemala doha wawaya gagilina ta. ");
INSERT INTO sbe_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Unai, kaiteya ye nuwadobidobi doha wawaya ta meta iya ye saekalili galewa basileiyana unai. ");
INSERT INTO sbe_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na ena tamowai hesau wawaya gagilina doha teina wawaya ta ye yogaisini yau hesaguyena meta ye yogaisinigau. ");
INSERT INTO sbe_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na ena tamowai hesau teina tausunumaegau tamowaidi dobidobidi ta hesau ye woyalaei yababa unai, meta ye namwa mo taba weku lakilakina gadona ne unai se paihekahini na se tuudobiyei gabwatum ne unai ye yoli. ");
INSERT INTO sbe_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ahani mo siya tanoubu ta tamowaidiyao, kabo kamkamna se hekalo, matawuwuna ede tamowai se woyahesuwalalaeidi yababa unai. Huya maudoina noho se laolaoma, na ahani mo siya noho ne yodi kabalaoma tamowaidiyao ne, kabo se kamkamnakalili. ");
INSERT INTO sbe_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ena nimam o kaem ye woyahesuwalalaego yababa unai, taba ku bolihai na ku gabaei. Ye namwa mo taba ku bunibuni o nimam o kaem kesekesega unai na ku lau ku mauli, na kabo ma tauꞌudoꞌudoim na ku lau kaiwa kalakalasina nige kana siga. ");
INSERT INTO sbe_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na ena matam ye woyalaego yababa unai, ku lamohai na ku gabaei. Ye namwa mo taba matakesekesegam unai ku lau ku mauli, na kabo ma matalabulabuim na se gabalaego kaiwa kalakalasina unai.” ");
INSERT INTO sbe_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Na kabo Yesu ye hedede ye wane, “Tamowai dobidobidi ta, tabu kwa kitadobidobiyeidi. Ya hededehemasalaha kalimiuyena meta galewa ne unai yodi anelu, siya huya maudoina yodi se kaikaibwada Tamagu unai. ");
INSERT INTO sbe_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yomi nuwatu idohagi? Taba tamowai hesau yona mamoe badodi handele kesega, na hesau ye taukwadalele, kabo hekadiyo wa ye tolenamwanamwaedi kuduli wa udiyedi na ye lau kesega ye taukwadalele wa ye wasenei, e nige? ");
INSERT INTO sbe_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya hededemamohoi kalimiuyena: Ena ye lobai, kabo kesega ta gwauyalana ye lakikalili, na kabo mamoe 99 maidanao wa. ");
INSERT INTO sbe_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gonogonowana doha, Tamamiu galewa ne unai nige ye henuwa bena taba tamowai dobidobidi ta hesau ye taukwadalele yababa unai.” ");
INSERT INTO sbe_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ena kam kaha saha hesau yababana ye ginauli kalimyena, meta ku lau unai na kowa yo iya yomi labui mo matamiuyena yona laupwano ne ku hededehemasalaha. Ena ye lapulaowa kalimwai, meta yababa yona teha unai ku gilihaiyako. ");
INSERT INTO sbe_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na ena nige ye lapulaowa kalimwai, kabo tamowai kesega o labui ku haidi na maidamwao kwa lau iya unai. Unai kabo yom hedehedede maudoidi se hemamohoiyedi, doha Buka Tabuna ye hekatada ye wane, ‘Pilipili maudoidi tolehedudulaidi udiyedi meta tamowai labui o haiyona yodi hemamohoi ne unai kabo ta tolehedudulaidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ena nige ye henuwa ye lapulau udiyedi, kabo kwa laei dubu bodana udiyedi. Na ena nige ye lapulau udiyedi, meta iya kabo kwa kabi doha dagela tamowaina o yababa tauginaginaulina o takisi tautanotano yomi kabikabidi. ");
INSERT INTO sbe_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hedehedede ta meta mamohoi, na hedehedede hesau ya hededeꞌuyoi kalimiuyena: Laulau saha kwa kawanamwanamwaei tanoubu ta unai, Yaubada kabo hinage ye kawanamwanamwaei, na laulau saha kwa kitaheyababadi, Yaubada hinage ye kitaheyababadi. ");
INSERT INTO sbe_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yo ya hededeꞌuyo kalimiuyena doha teina: Ena yomi labui tanoubu ta unai saha kwa talamyei na kwa kaibwadai, Tamagu galewa ne unai kabo ye ginauli yomiu. ");
INSERT INTO sbe_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Matawuwuna, ena tamowai labui o haiyona se laomagogoi yau hesaguyena, meta yau ede siya luwadiyena.” ");
INSERT INTO sbe_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kabo Petelo ye laoma Yesu unai ye henamai ye wane, “Guiyau, ena kaliguyena kagu kaha hesau yababa saha hesau ye ginauli, kabo ma hisa yona yababa ne ya nuwatugabaei? Ma kesega o ma haligigi-labui o ma hisa?” ");
INSERT INTO sbe_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ye hededebui ye wane, “Ya hededelaowa, nige bena ma haligigi-labui (7) mo, na bena ma 77. ");
INSERT INTO sbe_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Matawuwuna galewa basileiyana kana kao ede doha teina: Wasawasa hesau yona taupaisowa siya yona gogo taukitahetetedi ye yogagogoidi na ye henuwa bena yodi paisowa kaniyodi se tolehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yona hekasa ye hetubu ede moni baikidi 10,000 taukabihagahagaina tamowaina se woyaiyama kalinawai. ");
INSERT INTO sbe_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nige gonowana ye hemaisa, ede wasawasa wa ye hedede bena taba tamowai wa ma mwanena yo natudiyao maudoidi, yo yona gogo maudoidi se lokunegabaeidi na monina wa unai kana hagahaga wa se hedudulaidi. ");
INSERT INTO sbe_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tamowai wa ye tulibonodobi matana wa unai na ye kaibwadabigabigalau unai ye wane, ‘Ku katekamkamnaegau, na kagu hagahaga ta maudoidi kabo ya hedudulaiꞌuyoidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wasawasa wa tamowai wa ye katekamkamnaei ede kana hagahaga wa ye hededegabaeidi na ye kabigabaei ye lau. ");
INSERT INTO sbe_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Na huyana tamowai wa ye pesa ye lau ede yona hali heyayai tauhaina hesau ye kita kana hagahaga meta nige ye lakikalili. Gadona unai ye kabihekahini ye nukugwadagwadai na ye hededekasokaso ye wane, ‘Kam hagahaga kaliguwai wa ku hedudulaiyama!’ ");
INSERT INTO sbe_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kana kaha wa ye tulibonodobi matana wa unai na ye kaibwadakatekamkamna ye wane, ‘Ku katekamkamnaegau, na kagu hagahaga ta kabo ya hemaisaꞌuyoidiwa.’ ");
INSERT INTO sbe_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nige ye kitalau tamowai ne yona kaibwada wa unai, na ye laei ye hedede se tole numatutuguduyena kana siga kana hagahaga maudoidi wa ye hedudulaihegehedi. ");
INSERT INTO sbe_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kana kahao hekadi se kita meta se nuwayababakalili, ede se lau wasawasa wa unai na saha ye tubu wa yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kabo wasawasa wa taukaihagahaga kalinaena tamowaina wa ye yoganeiꞌuyoi na ye hededelau unai ye wane, ‘Kowa tamowai yabayababana! Ku kaibwadalaoma kaliguwai, unai kam hagahaga maudoina ya hededegabaei. ");
INSERT INTO sbe_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Idohagi to nige gonowana kam kaha ne ku katekamkamnaei doha yau ya katekamkamnaego wa?’ ");
INSERT INTO sbe_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wasawasa wa ye kouyalayalakalili ede tamowai wa ye moselaei numatutugudu taukitahetetena udiyedi na se tole numatutugudu unai na se hekamkamna ye lau ee kana hagahaga maudoidi ye hedudulaidi. ");
INSERT INTO sbe_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ena nige nuwamiu mamohoidi udiyedi kami kahao yodi yababa kwa nuwatugabaeidi, meta kabo Tamagu galewa ne unai yona kabikabigomiu ede doha teina.” ");
INSERT INTO sbe_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu yona hedehedede ta se gehe, kabo Galili ye laugabaei na ye lau Yudeya ye lage Yolidani sagasagana hali sanakawasina unai. ");
INSERT INTO sbe_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na bodalakilaki se hemuliwatani, na menai ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na Paliseya tamowaidiyao hekadi se laoma bena Yesu se lautonogi, na se henamaiyei se wane, “Gonowana taba tamowai hesau mwanena nuwatu saha hesau debanaena ye inawasei, o ye inawasegaibuimoei?” ");
INSERT INTO sbe_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ye hededebui ye wane, “Buka Tabuna unai kwa hasili meta tanoubu huyahetubuna unai Tauginaulida ‘tau yo sine ye ginaulidi’ , o nige kwa hasili? ");
INSERT INTO sbe_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na ye hedede ye wane, ‘Teina debanaena kabo tau tamana yo sinana ye laugabaeidi na ye lau mwanena maidana se miyakesega. Na kabo taudi labui se hemala buluma yo kwasina kesega.’ ");
INSERT INTO sbe_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Unai siya nige tamowai labui, na se hemalako tamowai kesega. Unai, Yaubada saha ye tubeikesegai meta tabu tamowai hesau ye hetatagwaligwali.” ");
INSERT INTO sbe_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kabo Paliseya wa se wane, “Matawuwuna saha to Mose ye hedede meta gonowana tau hesau inawase pepwana ye kuli na ye mosei mwanena unai na ye hetamali ye lau?” ");
INSERT INTO sbe_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ye wane, “Mose ye talamyeigomiu bena kwa inawase matawuwuna ede kwa nuwakwailolokalili. Na iyamo tanoubu yona huyatubu unai meta nige doha teina. ");
INSERT INTO sbe_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya hededelaowa kalimiuyena: Ena tau hesau mwanena yona tawasola miyana ye kabinamwanamwaei na nige ye ganawali, na iyamo ye inawasegaibui na waihiu hesau ye tawasolai, meta tau ne ye ganawali.” ");
INSERT INTO sbe_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ede yona hekahekatao wa se hededelau unai se wane, “Ena teina ta tawasola miyamiyana ede, ye namwa mo taba tabu ta tawatawasola.” ");
INSERT INTO sbe_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ye hededebuiꞌuyo ye wane, “Teina hedehedede ta meta nige gonowana tamowai maudoidi se miyawatani, na siya kaiteyadi Yaubada ye hebayaodi meta kabo hedehedede ta se miyawatani. ");
INSERT INTO sbe_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tatao hekadi nige se tawasola matawuwuna se labasidi meta kobokobosidi, na hekadiyo meta tamowai siya se hekobosidi, na hekadiyo meta yodi talam se ginaulidi Yaubada yona paisowa unai, debanaena ede nige gonowana se tawasola. Unai kaiteyadi gonowana hedehedede ta se hai meta bena se hai.” ");
INSERT INTO sbe_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tamowai hekadi wawayao se laedima Yesu unai bena nimana ye tolesae kewadiyena yo yodi ye tapwalolo. Na yona hekahekatao tamowai wa se hededehekaiyawasidi bena tabu Yesu se hemohemode. ");
INSERT INTO sbe_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na Yesu ye wane, “Wawayao me bena se laoma kaliguyena, na tabu kwa hededeguduguduidi. Matawuwuna ede tamowai yodi sunuma kadi kao doha teina wawayao ta meta galewa basileiyana siya yodi.” ");
INSERT INTO sbe_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ede nimana ye tolesaedi wawayao wa kewadiyena yo ye hededehenamwadi. Kabo magai ne ye laugabaei ye lau. ");
INSERT INTO sbe_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kabo tamowai hesau ye laoma Yesu unai ye henamai ye wane, “Taulauhekata, taba laulau saha namwanamwana ya ginauli kabo mauli nige kana siga ya lobai?” ");
INSERT INTO sbe_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na Yesu ye hededelau tamowai wa unai ye wane, “Idohagi to laulau namwanamwadiyao hesabadi ku henamaiyeigau? Yaubada ye bom mo ye namwa. Ena ku henuwa bena mauli nige kana siga ku hai, meta laugagayo ku miyawatanidi.” ");
INSERT INTO sbe_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na hewali wa ye henamai ye wane, “Laugagayo sahasahadiyao?” Ede Yesu ye wane, “Tabu ku kaiunu, tabu ku ganawali, tabu ku kaiwahali, tabu tamowai hesau ku hegilugaibui ");
INSERT INTO sbe_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yo tamam yo sinam ku hekasisiyeidi, hinage kam kaha hesau ku gadosisiyei doha kowa ku bom ku gadosisiyeiꞌuyoigo.” ");
INSERT INTO sbe_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hewali wa ye hededebui ye wane, “Laugagayo maudoidi ta meta ya miyawatanidiko, na saha hesau bena nige sola ya miyawatani?” ");
INSERT INTO sbe_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ede Yesu ye wane, “Ena ku henuwa bena ku dudulai meta ku lau yom gogo maudoidi ku lokunegabaeidi na monidiyao ku moseidi taudehadeha udiyedi, na galewa ne unai kabo yom wasawasa gogodiyao ku lobaidi. Na kabo ku laoma ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na hewali wa hedehedede ta ye lapui ede ye nuwayababa na ye dalahai, matawuwuna yona gogo meta se badokalili. ");
INSERT INTO sbe_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Unai kabo Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Ya hededemamohoi kalimiuyena meta tamowai gogogogodiyao yodi lusolalau galewa basileiyana unai meta ye pilipilikalili. ");
INSERT INTO sbe_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na ya hededeꞌuyo kalimiuyena: Ye masalahakalili meta kamela nige gonowana ye lusola diu duhana unai. Gonogonowana doha, tamowai gogogogona hinage nige gonowana ye lusolalau Yaubada yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu yona hekahekatao wa hedehedede wa se lapui meta se siliyata ede se henamai se wane, “Kaiteya kabo gonowana mauli nige kana siga ye hai?” ");
INSERT INTO sbe_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ye kitadudulailau kalidiyena na ye wane, “Tamowai se bom mo nige gonowana mauli se lobai, na Yaubada unai ginauli maudoidi meta gonowana.” ");
INSERT INTO sbe_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kabo Petelo ye hededelau unai ye wane, “Kai meta hemuliwatanigo ta unai ede yoma ginauli maudoidi ka laugabaeidiko. Na saha meta kabo iya yomai?” ");
INSERT INTO sbe_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuyena: Ginauli maudoidi huyahehauhauꞌuyoidi mayadaina ne unai kabo Tau Natuna yona telona saesaena unai ye tuli, meta komiu tauhemuliwatanigau ta kabo hinage telona badodi saudoudoi-labui udiyedi kwa tuli na Isalaela tamowaidiyao boga saudoudoi-labui ta kwa kitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yo kaiteyadi siya yodi numa, kadi kahao, loudiyao, tamadiyao, sinadiyao, natudiyao yo yodi tano se laugabaeidi yau debaguyena, meta kabo se haiꞌuyoidi se laki yo se badokalili, yo hinage mauli nige kana siga meta kabo siya yodi. ");
INSERT INTO sbe_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na tamowai se bado ta kitahesaeꞌuseidi wa meta kabo se laoma se dobi, na tamowai se bado ta kitadobidobiyeiꞌuseidi wa meta kabo se laoma se sae.” ");
INSERT INTO sbe_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na Yesu ye wane, “Galewa basileiyana heyaheyasonina hesau ede doha teina: Koya tanuwagana hesau malatomtomyena ye lau yona taupaisowa ye haidi se laoma bena yona wine koyana unai se paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yona talam ye ginauli kalidiyena meta mayadai kesega paisowana ne unai kabo ye hemaisadi denalikesega. Kabo ye hetamalidi se lau se paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mahana 9 kiloki tehana unai ye uyo kabalokulokune bakubakuna wa unai. Menai tamowai hekadi ye kitadi se totologaibu nige kadi paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ye hededelau udiyedi se lau yona wine koyana wa unai se paisowa yo kalidiyena ye wane, ‘Maisa dudulaina unai kabo ya hemaisagomiu.’ Ede se lau se paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mayamayadailaki unai yo 3 kiloki meimeilahi unai hinage ye uyo na laulau kesekesegana wa ye ginauliꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Meimeilahi 5 kiloki unai ye uyo na tamowai hekadi ye lobaiꞌuyoidi se totologaibu. Ede ye henamaiyeidi ye wane, ‘Idohagi to mayadai udoꞌudoina ta inai kwa totologaibu na nige saha hesau kwa ginauli?’ ");
INSERT INTO sbe_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Se wane, ‘Matawuwuna ede nige tamowai hesau ye haigai bena taba yona ka paisowa.’ Kabo ye wane, ‘Komiu hinage kwa lau yogu wine koyana unai taupaisowa ne kwa paisowasaguidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Huyapaisowakaiyawasi mahanana unai koya tanuwagana wa ye hededelau yona taupaisowa kadi tanuwaga wa unai ye wane, ‘Yogu taupaisowa maudoidi ku yogagogoidima na yodi paisowa maisana ku moseidi. Taupaisowamulita udiyedi ku hetubu ku lau ee taupaisowabaguna udiyedi ku kaiyawasi.’ ");
INSERT INTO sbe_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Taupaisowamulita awa kesega mo se paisowa wa se laoma ede maisadi denali kesega se hai. ");
INSERT INTO sbe_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na taupaisowa ye haibagunaiꞌuseidi wa yodi nuwatu meta bena kabo siya maisa lakilakina se hai, na iyamo maudoidi wa meta hinage denali kesega se hai. ");
INSERT INTO sbe_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Maisadi wa se haidi na se kitadi meta denali kesega kesega ede se hetubu se hetalapili koya tanuwagana wa unai, ");
INSERT INTO sbe_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","se wane, ‘Teina tamowai ta ku haimulitaꞌuseidi ta meta se paisowa awa kesega mo, na kai meta ka paisowa mahana gigibwalina wa unai yo paisowa lakilakina ka ginauli mayadai udoꞌudoina wa unai, na iyamo ku hemaisadi meta gonogonowana doha kai ku hemaisagai ta.’ ");
INSERT INTO sbe_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Na koya tanuwagana wa ye hededelau kadi kaha hesau unai ye wane, ‘Kehagu, nige hekasa yababana hesau ya ginauli o ya kaolupolupo kalimwai. Wau ku yali meta kabo denali kesega paisowana ku paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Maisam ta ku hai na ku lau, yogu hekasa ya ginauliyako meta kabo taupaisowamulita maisadi ya moseidi doha kowa taupaisowa bagubagunana maisam ta. ");
INSERT INTO sbe_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Teina moni ta yau yogu, unai yogu dudulai gonowana saha ya hekasa meta kabo ya ginauli. O nuwana ku kaikalomagigiliyeidi matawuwuna ede ya kabinamwanamwaeidi?’ ” ");
INSERT INTO sbe_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu yona hedehedede wa gehena unai ede ye wane, “Tamowai ta kitadobidobiyeiꞌuseidi wa meta kabo se laoma se sae, na tamowai ta kitahesaeꞌuseidi wa meta kabo se laoma se dobi.” ");
INSERT INTO sbe_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Huyana Yesu maiyana hekahekatao saudoudoi-labui wa se saesae Yelusalema meta keda wa unai ye woyahesuwaladi na ye hededelau udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kwa lapulapuinamwanamwa! Teina yoda sae Yelusalema ta unai meta Tau Natuna kabo se mosegabaei taukaitalasam tauwoyaidi yo laugagayo taulauhekataena udiyedi. Siya kabo se hegilu yo se hetamalilaei ye boita. ");
INSERT INTO sbe_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yo kabo se moselaei dagela tamowaidiyao udiyedi kabo se talatalawasiyei, se pidili yo se laei se hesataulo. Na mayadai hehaiyonana unai kabo Yaubada iya ye hetoloꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na kabo Sebedaiyo natunao ma sinadi se laoma Yesu unai na sinadi wa ye tulibonodobi na ye hededelau Yesu unai taba gonowana yona kaibwada ye ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ye wane, “Yom kaibwada ede saha?” Sinebada wa ye wane, “Taba gonowana ku hededenonohai meta yom basileiya unai kabo natuguwao labui ta hesau tehatutum ne unai ye tuli yo hesau tehaseuseulim ne unai ye tuli.” ");
INSERT INTO sbe_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ye hededelau udiyedi ye wane, “Saha kwa kaikaibwadai ta meta nige kabina kwa kata! Keyaka unai kabo ya numa meta gonowamiu kabo unai kwa numa?” Ede se wane, “Kai gonowamai.” ");
INSERT INTO sbe_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na Yesu ye hededelau udiyedi ye wane, “Kagu keyaka ta kabo komiu hinage unai kwa numa, na bena tehatutugu o tehaseuseuliguyena kwa tuli meta yau nige gonowana ya hekasa. Teina kabatuli ta meta tamagu ye kabinonohaidiko yona kaisunuwa tamowaidiyao siya yodi.” ");
INSERT INTO sbe_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yamesi yo Yowane yodi hedehedede wa hekahekatao hekadiyo wa se lapui ede se kouyalayala. ");
INSERT INTO sbe_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ede Yesu ye yogagogoidima na ye hededelau udiyedi ye wane, “Kabina kwa kata meta dagela tamowaidiyao yodi tauwoyawoya tamowaidi lakilakidiyao yodi loina gigibwalina yo bayabayaona unai yodi tamowai se loinaedi. ");
INSERT INTO sbe_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Na komiu yodi laulau ta tabu kwa laulauyeidi. Na ena hesau luwamiuyena ye henuwa bena hesana ye sae yo ye laki meta iya bena ye hemala heyayai tauhaina tamowaina. ");
INSERT INTO sbe_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yo luwamiuyena kaiteya ye henuwa bena ye baguna, meta iya taba ye hemala yomiu taupaisowa tamowaina. ");
INSERT INTO sbe_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Doha ede Tau Natuna ye laoma nige bena tamowai iya yona se paisowa, na iya bena tamowai yodi ye paisowa yo kabo yona mauli ye mosegabaei na unai tamowai maudoidi ye hemaisahaidi na se mauli.” ");
INSERT INTO sbe_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Huyana Yesu maiyana hekahekatao Yeliko se laugabaei meta bodalakilaki se hemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Keda wa dedekana unai meta taumatagibugibu labui se tutuli. Wasa se lapui meta Yesu kabo keda ne unai ye laoma ye lau, ede kalinalakilaki unai se yogayoga se wane, “Guiyau, Dawida Natuna, ku katekamkamnaegai.” ");
INSERT INTO sbe_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na boda wa taumatagibugibu labui wa se dilaidi se wane, “Kwa taumodimodiya, kwa kaiyawasi!” Na nige se modelau udiyedi, na se yogahilakilakiꞌuyo se wane, “Guiyau, Dawida Natuna ee, ku katekamkamnaegai!” ");
INSERT INTO sbe_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kalinadi wa Yesu ye lapui ede ye kaiyawasi na ye yoganeidi na ye henamaiyeidi ye wane, “Saha kwa henuwa bena yomiu ya ginauli?” ");
INSERT INTO sbe_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ede se hededelau iya unai se wane, “Guiyau, ka henuwa bena matamai ta se lala yo ka kaikewa.” ");
INSERT INTO sbe_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ye katekamkamnaedi ede ye kabilau matadiyao wa udiyedi, na mahanana ne unai matadiyao wa se lala yo se kaikewa, na se tolo ede Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Huyana se laoma Yelusalema se hanahanawui na se lage Betepage Olibe koyana unai, kabo Yesu yona hekahekatao labui ye hetamalidi se lau ");
INSERT INTO sbe_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ye hededelau udiyedi ye wane, “Kwa lau magai matamiu ne unai. Menai kabo donki ma natuna se paihekahinidi kwa kitadi. Kwa yailihaidi na kwa laedima kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ena tamowai hesau saha ye hedede kalimiuyena, meta kwa hededelau unai kwa wane, ‘Guiyau ye henuwadi.’ Kabo mahanana ne unai ye talamgabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Teina laulau ta ye tubu bena peloweta saha ye hededenonohaiyako wa ye laoma ye mamohoi. ");
INSERT INTO sbe_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ye wane, “Kwa hededelau Saiyona natunao udiyedi, ‘Kwa kita, yomi wasawasa ye laolaoma kalimiuwai, ye nuwadobidobi yo donki unai ye gelu, na donkina ne meta donki natuna.’” ");
INSERT INTO sbe_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hekahekatao labui wa se lau ede saha Yesu ye hedede kalidiyena wa se ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donki wa ma natuna se laedima kabo kadi kwama se haigabaeidi na se yesedi donki wa kewadiyena kabo Yesu ye tulisae donki natuna wa kewana ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bodalakilaki kadi kwama se haigabaeidi na se yesedi keda wa unai yo hekadi se lau kaiwa lagadiyao gagigagilidi ma lugulugudi se bolihaidi na se laoma keda wa unai se yesedi. ");
INSERT INTO sbe_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kabo bodalakilaki wa se baguna yo se mulita na se heyoheyoga se wane, “Hosana, Dawida Natuna!” “Ka hedebasaego, kowa Guiyau hesanaena ku laoma!” “Hosana saesaekalilina!” ");
INSERT INTO sbe_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Huyana Yesu ye mwalaesae Yelusalema meta magai wa tamowaidiyao maudoidi se siliyata na se henahenamaiꞌuyoidi se wane, “Teina kaiteya tamowai ina?” ");
INSERT INTO sbe_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Boda wa se hededelau udiyedi se wane, “Teina ta Yesu, iya peloweta, Nasaleta tamowaina, Galili unai ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ye lusae Numa Tabuna bakubakuna unai na taulokulokunegabae yo tauhemahemaisa ye henakuhepesadi yo moni taulaulauhedudu yodi hatahata ye buikahalaidi yo bunebune taulokulokunegabaedi yodi kabatuli ye buikahalaidi. ");
INSERT INTO sbe_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ye hededelau udiyedi ye wane, “Peloweta Yaubada kalinana se kulihemasalahayako meta, ‘Yogu numa kabo hesana se katai ede kabatapwalolo numana’ , iyamo yomi kabikabina ta meta doha ‘taukaiwahali yodi duha.’ ” ");
INSERT INTO sbe_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Taumatagibugibu yo tamowai kaediyao yabayababadi se laoma Numa Tabuna wa unai na Yesu ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na Numa Tabuna bakubakuna wa unai wawayao Yesu se nokonokoei se wane, “Hosana Dawida Natuna!” Na taukaitalasam tauwoyaidi yo laugagayo taulauhekataena laulau gigigigibwalidi yo namwanamwadi Yesu ye ginaulidi wa se kitadi yo wawayao yodi hedebasae wa se lapui meta se kouyalayalakalili. ");
INSERT INTO sbe_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Se henamaiyei se wane, “Wawayao ta saha se hedehedede ta ku lapui, o nige?” Yesu ye wane, “Aa, na komiu sola nige kulikuli tabuna unai kwa hasili? Doha ye wane, ‘Wawayao yo wawayao bedabedalidi ku hepaisowadi na kabo sopadiyena kowa se nokoeigo yo se hedebasaego.’” ");
INSERT INTO sbe_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kabo boda wa ye laugabaeidi na magai lakilakina wa ye pesagabaei ye lau Betaniya unai ye kenokwaduwali. ");
INSERT INTO sbe_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Malatomtom gagilina unai Yesu yona seuyo magai lakilakina wa hesabana na keda wa unai ye tauhasahasali. ");
INSERT INTO sbe_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na kaiwa hesau hesana ede bosibosi keda wa dedekanaena ye totolo ye kita ede ye lau kaiwa wa unai na ye kita meta kaiwa wa lugugaibuna ye kuyawa na nige kaniyona. Ede ye hededelau kaiwa wa unai ye wane, “Kowa taba nige huya hesau ku kaniyoꞌuyo.” Mahana ne unai kaiwa wa ye wowoya. ");
INSERT INTO sbe_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yona hekahekatao saha ye tubu wa se kita meta se nokokalili. Se henamai se wane, “Idohagi na kaiwa ta ye wowoyamwamwayau?” ");
INSERT INTO sbe_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ye hededebui ye wane, “Ya hededemamohoi kalimiuyena: Ena kwa sunuma na nige unai kwa nuwalabulabui, kabo laulau saha kaiwa ne unai ye tubu ta hinage gonowana kwa ginauli. Nige ye bom mo, na hinage gonowana kwa hededelau kuduli ne unai kwa wane, ‘Ku tuudobiyeiꞌuyoigo gabwa ne unai!’, meta gonowana kabo ye tubu. ");
INSERT INTO sbe_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ena kwa kawamamohoi, kabo ginauli sahasahadi tapwaloloyena kwa kaibwadaidi ne meta kabo kwa haidi.” ");
INSERT INTO sbe_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ye seuyo Numa Tabuna wa unai na bakubakuna unai ye hetubu ye lauhekata, na taukaitalasam tauwoyaidi yo magai babadadiyao se laoma iya se henamaiyei se wane, “Gigibwali sahasahana unai teina laulau ta ku ginaulidi, yo kaiteya yom dudulai ne ye haiyawa?” ");
INSERT INTO sbe_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ye hededelau kalidiyena ye wane, “Yau hinage kabo henamai hesau ya henamaiyeigomiu. Ena yogu henamai ta kwa bui, kabo ya hededehemasalaha kalimiuwai kaiteya yona gigibwaliyena teina laulau ta ya ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hage, Yowane yona hebahebabatiso paisowana meta haedi ye laoma, o kaiteya ye mosei? Yaubada ye mosei o tamowai se mosei?” Se bom kalidiyena se hetahetala se wane, “Taba ta wane, ‘Yaubada unai ye laoma’, kabo iya ye wane, ‘Idohagi to nige kwa kawamamohoiyei?’ ");
INSERT INTO sbe_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ena taba ta wane, ‘Tamowai udiyedi ye laoma’, meta boda ta ta matausiyeidi matawuwuna ede siya se kawamamohoi meta Yowane iya peloweta.” ");
INSERT INTO sbe_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Unai ede se hededelau Yesu unai se wane, “Nige kabina ka kata.” Unai ye hededelau udiyedi ye wane, “Kabo yau hinage taba nige yomiu ya hedehedede gigibwali saha unai na laulau ta ya ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kabo Yesu ye hedehededeꞌuyo babadao wa udiyedi ye wane, “Hage kwa nuwatuhekasa, taubada hesau meta natunao labui. Huya hesau kabo ye hededelau taubaguna wa unai ye wane, ‘Natugu, ku lau yoda wine koyana unai ku paisowa.’ ");
INSERT INTO sbe_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ye wane, ‘Taba nige ya lau.’ Iyamo muliyena nuwana ye bui ede ye lau ye paisowa. ");
INSERT INTO sbe_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kabo tamadi wa ye lau natuna helabuina wa unai ye wane, ‘Ku lau yoda wine koyana unai ku paisowa.’ Natuna wa ye wane, ‘Aa, tamagu, kabo ya lau.’ Na iyamo nige ye lau.” ");
INSERT INTO sbe_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kabo Yesu ye henamaiyeidi ye wane, “Natunao labui ne udiyedi, kaiteya iya tamana yona nuwatu ye lauwatani?” Se wane, “Natuna taubaguna wa.” Ede Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuyena: Yababa tamowaidi doha takisi tautanotano yo sinesineo taudiyao se lokulokunegabaeidi moni hesabana, siya kabo se lusolabagunalau Yaubada yona basileiya unai na kabo komiu. ");
INSERT INTO sbe_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Matawuwuna Yowane ye laoma kalimiuyena mauli dudulaina kamwasana ye hekitagomiu, na nige kwa kawamamohoiyei, na takisi tautanotano yo sinesineo taudiyao se lokulokunegabaeidi moni hesabana, siya se bom mo se kawamamohoiyei. Yodi nuwabui ta kwa kita, na iyamo nige kwa nuwabui yo kwa kawamamohoi.” ");
INSERT INTO sbe_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kabo Yesu yona hedehedede babadao wa udiyedi ye tubei ye wane, “Teina hinage heyaheyasoni hesau ta kwa lapui. Tano hesau tanuwagana yona wine koyana ye kumai, ye ganahetakikili, yo yona wine kaniyodi kabatamtam yo koya yona kabayaiyaiwaina numana ye ginaulidi. Kabo yona wine koyana wa ye moselaei tamowai hekadiyo udiyedi bena se kitahetete, na ye lau ye kadau. ");
INSERT INTO sbe_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wine huyagigidi nawalaina ye lage ede yona heyayai tauhaidi ye hetamalidi se lau wine koyana taukitakitahetetena wa udiyedi bena koya tanuwagana yona lausoisoi se haidi. ");
INSERT INTO sbe_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na koya taukitahetetena wa heyayai tauhaidi wa se kabihekahinidi, hesau se bibigwadagwadai na hesau se koihemwaloi yo hesau se hekalaweku ede ye mwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Koya tanuwagana wa yona heyayai tauhaidi katubadodi ye hetamalidi se lau, na koya taukitahetetena wa hinage laulau kesekesegana wa se ginauli kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Unai gehegehena meta iya ye bom natuna ye hetamalilaei kalidiyena, na ye wane, ‘Natugu ta kabo se hekasisiyei na yoma lausoisoi dudulaina se mosei.’ ");
INSERT INTO sbe_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Huyana koya taukitakitahetetena wa koya tanuwagana natuna wa se kita meta se wane, ‘Teina tau ta meta iya tamana lauhedamaina ede, kwa laoma ta unuhemwaloi na yona gogo maudoidi ta haidi ta tanuwagaidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ede se hai na koya ganana wa unai se gabahepesa na se koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Unai hage kwa nuwatui, ena wine koyana tanuwagana ye uyoma meta kabo saha ye ginauli wine koyana taukitahetetena ne udiyedi?” ");
INSERT INTO sbe_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Boda wa se wane, “Teina tamowai ta yodi laulau yabayababadi ta kabo ye haidi na ye unuhemwaloidi. Na wine koyana ne kabo ye mosehekawalaei taukitakitahetete hekadiyo udiyedi. Ena wine kaniyodi huyagigidi nawalaina ye lage, siya kabo gonowana wine kaniyodi wa yona teha se moselaei koya tanuwagana wa unai.” ");
INSERT INTO sbe_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu ye hededelau udiyedi ye wane, “Kulikuli tabudiyao udiyedi teina hedehedede ta kwa hasili o nige? ‘Taukabinuma weku se subuꞌusei wa meta ye hemala kabakabinuma wekuna namwanamwana yo saesaekalilina. Teina ta meta Yaubada ye ginauli, na matadaena kitakitana meta ye namwakalili.’ ");
INSERT INTO sbe_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Unai ya hededelaowa kalimiuyena: Yaubada yona basileiya meta kabo kalimiuyena ye haigabaei na ye moselaei tamowai hekadiyo udiyedi, siya kabo se paisowai na kaniyo namwanamwadi se masalaha. ");
INSERT INTO sbe_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ena hesau ye bekudobi weku ne unai kabo ye talugodugodu, na ena weku ne ye bekudobi tamowai hesau kewanaena meta kabo ye kaihesolusolu.” ");
INSERT INTO sbe_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Taukaitalasam tauwoyaidi yo Paliseya tamowaidiyao Yesu yona heyaheyasoni wa se lapuidi ede kabina se kata meta siya kadi hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Unai kamwasa se wase kabo taba idohagi na Yesu se hai, na iyamo boda wa se matauseidi matawuwuna ede siya se hedede meta iya peloweta. ");
INSERT INTO sbe_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kabo Yesu heyaheyasoni hesau ye hededeꞌuyoi tamowai lakilakidiyao wa kalidiyena ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Galewa basileiyana kana kao ede doha wasawasa hesau natuna yona tawasola kabinonohana ye kabinonoha. ");
INSERT INTO sbe_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kabo yona heyayai tauhaina ye hetamalidi se lau kana taumana udiyedi na se hededelau udiyedi bena se laoma tawasola kaikaigogona ne unai, na iyamo se laukwatakwata. ");
INSERT INTO sbe_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ede yona heyayai tauhaina hekadiyo hinage ye hetamalidi se lau na ye wane, ‘Kwa hededelau taulaoma ne kalidiyena meta kai yo yogu bulumakau sinisinibudi namwanamwadiyao ya ligadi yo ya kabinonohaidiko. Unai bena taba kwa laoma hetahetawasola kaikaigogona ta unai.’ ");
INSERT INTO sbe_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Na taumana ne nige se lapulau tautauwasa wa udiyedi na se bom mo yodi nuwatu se lauwatanidi, hekadi se lau yodi koya na hekadi se lau yodi sitowa. ");
INSERT INTO sbe_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yo hekadiyo heyayai tauhaidi wa se kabihekahinidi na se bibidi yo se koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na wasawasa wa saha ye tubu wa wasana ye lapui meta ye kouyalayalakalili. Unai yona tauꞌiyala tamowaidiyao ye hetamalidi se lau taukaiunu wa se koihemwaloidi yo yodi magai wa se gabu. ");
INSERT INTO sbe_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kabo wasawasa wa ye hededelau yona heyayai tauhaidi wa udiyedi ye wane, ‘Hetahetawasola kaina wa se kabinonohaiyako, na taumana ya hededelau udiyedi wa nige se mode, unai ede nige se laoma. ");
INSERT INTO sbe_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Unai kwa lau yoda magai ta kedana udiyedi na tamowai kwa kitadi ne meta kwa hededelau udiyedi bena se laoma hetahetawasola kaikaigogona ta unai.’ ");
INSERT INTO sbe_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kabo heyayai tauhaidi wa se lau magai lakilakina kedana maudoidi udiyedi tamowai namwanamwadi yo yabayababadi maudoidi se woyagogoidima ede kabahetahetawasola numana wa se hemwayau. ");
INSERT INTO sbe_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Na kabo wasawasa wa ye laoma ye mwalae numa wa unai bena taumana wa ye kitadi, na luwadiyena tamowai hesau ye kita meta nige hetahetawasola kwamana ye likwa. ");
INSERT INTO sbe_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ede ye henamaiyei ye wane, ‘Kehagu, idohagi to ku laoma teinai na hetahetawasola kwamana nige ku likwa?’ Na tamowai wa nige saha hesau ye hedede. ");
INSERT INTO sbe_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kabo wasawasa wa ye hededelau yona heyayai tauhaina hekadiyo udiyedi ye wane, ‘Tamowai ta nimana yo kaena kwa paidi na kwa gabahepesa masigili ne unai, temenai kabo ye doudou yo gadigadina ye kapuyahisidi.’” ");
INSERT INTO sbe_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu yona hedehedede wa ye hegehe ye wane, “Yaubada tamowai ye yoganeidi wa se bado, na hisahisadi mo se talam ede se laoma.” ");
INSERT INTO sbe_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na kabo Paliseya bodana wa se laomagogoi na se koitalaliu bena taba idohagi na kabo Yesu se lupoi na yona hedehededeyena ye laupwano, na unai kabo se hegilu. ");
INSERT INTO sbe_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kabo Paliseya bodana kadi hewahewaliyo yo Heloda kana boda tamowaidiyao se hetamalidi se lau Yesu unai, se wane, “Taulauhekata, kabina ka kata meta kowa laulaududulai tamowaina yo mamohoi yo dudulaiyena Yaubada yona laulau miyamiyadi ku laulauhekataedi, matawuwuna tamowai maudoidi ku hekasisigogoidi na nige ku modelau kadi kao yo yodi laulau udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hage, ku hedede kalimaiyena yom nuwanuwatu ede saha: Gonowana takisi ka tole Sisa unai, o nige?” ");
INSERT INTO sbe_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na yodi nuwatu yababana wa Yesu kabina ye katako ede ye hededelau udiyedi ye wane, “Komiu taukailupolupo tamowaidiyao. Idohagi to kwa kaipate bena kwa lupohaigau? ");
INSERT INTO sbe_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hage, takisi kabahemahemaisana monina hesau kwa hekitagau.” Ede denali kesega iya se hekita. ");
INSERT INTO sbe_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na ye henamaiyeidi ye wane, “Teina kaiteya kana kao tautauna yo hesana?” ");
INSERT INTO sbe_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Se wane, “Sisa.” Kabo ye hededelau udiyedi ye wane, “Saha Sisa yona meta kwa mosei Sisa unai, na saha Yaubada yona meta kwa mosei Yaubada unai.” ");
INSERT INTO sbe_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu yona hedehedede wa se lapui meta se nokokalili. Na kabo se laugabaei se lau. ");
INSERT INTO sbe_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mayadai kesekesegana ne unai Sadusiya bodana se laoma Yesu unai. Sadusiya tamowaidiyao meta boita toloꞌuyona nige se kawamamohoiyei. Na se henamaiyei se wane, ");
INSERT INTO sbe_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Taulauhekata, Mose ye hedede meta ena tamowai hesau ye tawasola na nige natuna na ye boita, meta kana kaha kabo kwabuli ne ye tawasolai. Na ena natuna kabo se hedede ede iya meta kana kaha wa natuna. ");
INSERT INTO sbe_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sinebada hesau natunao tatao badodi haligigi-labui. Taubaguna ye tawasola nige natuna, na ye boita, ede kana kaha helabuina kwabuli wa ye tawasolai. ");
INSERT INTO sbe_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Laulau kesekesegana ta ye tubu kalinawai ye lau hehaiyonadi wa unai ye lau ye dobi ee gehena hehaligigi-labuidi wa unai, ");
INSERT INTO sbe_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","kabo waihiu wa hinage ye boita. ");
INSERT INTO sbe_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Unai hage ku hedede na ka lapui: Toloꞌuyo unai meta waihiu ta kaiteya mwanena ede? Matawuwuna ede tatao haligigi-labui wa waihiu ta se tawasolai.” ");
INSERT INTO sbe_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ye hededelau udiyedi ye wane, “Yomi nuwanuwatu ne ye helaupwanogomiu, kaniyona ede kulikuli tabudi yo Yaubada yona gigibwali meta nige kabidi kwa kata. ");
INSERT INTO sbe_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matawuwuna ede toloꞌuyo huyana unai meta taba nige tamowai se tawasolaꞌuyo, yo taba nige natudiyao se hetawasolaꞌuyoidi, na tautoloꞌuyo meta siya kabo kadi kao ede doha galewa aneludiyao. ");
INSERT INTO sbe_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na boita toloꞌuyona hedehededena unai meta Yaubada kalinana kulikuli tabudi udiyedi kwa hasilidi e nige, ");
INSERT INTO sbe_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","doha ye wane, ‘Yau meta Abelahama yona Yaubada, Isako yona Yaubada, yo Yakobo yona Yaubada hinage.’ Tenem huyana ne unai tamowai haiyona ta buluma unai se boitako. Na Yaubada meta nige tauboiboita yodi Yaubada, na iya taumaumauli yodi Yaubada. Unai ye masalaha meta tamowai haiyona ta siya ede sola se maumauli Yaubada matanaena.” ");
INSERT INTO sbe_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yona lauhekata hedehedededi boda wa se lapuidi meta se siliyatakalili. ");
INSERT INTO sbe_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Paliseya bodadi se lapui meta Sadusiya bodana wa Yesu ye hededehemwanoudiko ede se laomagogoi, ");
INSERT INTO sbe_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","na luwadi ne unai hesau meta iya laugagayo kabina taukatakalili na ye henuwa bena henamai hesau unai Yesu ye lupoi. ");
INSERT INTO sbe_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ede ye wane, “Taulauhekata, laugagayo sahasahana meta iya laugagayo lakilakikalilina ede?” ");
INSERT INTO sbe_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ye hededelau unai ye wane, “Guiyau yom Yaubada ku gadosisiyei ma nuwam maudoina, yaluwam maudoina, yo yom nuwanuwatu maudoina hinage. ");
INSERT INTO sbe_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Teina meta iya laugagayo bagubagunana yo lakilakikalilina ede. ");
INSERT INTO sbe_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yo helabuina ede doha bagubagunana ne: Kam kaha hesau ku gadosisiyei doha kowa ku bom ku gadosisiyeiꞌuyoigo. ");
INSERT INTO sbe_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose yona laugagayo yo peloweta yodi kulikuli maudoidi wuwudi ede teina laugagayo labui ta.” ");
INSERT INTO sbe_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesu Paliseya wa ye kitadi se totolo ede ye henamaiyeidi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yomi nuwatu ede saha, Keliso meta iya kaiteya? Yo iya kaiteya natuna?” Se wane, “Iya meta Dawida natuna.” ");
INSERT INTO sbe_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu ye hededelau udiyedi ye wane, “Idohagi to Yaluwa Tabuna yona gigibwaliyena Dawida ye hedehedede na Keliso ye kawaguiyauyei? Doha ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Guiyau ye hededelau yogu guiyau unai ye wane, “Nimatutugu unai ku tuli kana siga kam waiunu ya toledi kaem guninaena se hemala kaem kabatoledi.” ’ ");
INSERT INTO sbe_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ena taba Dawida ye kawaguiyauyei, idohagi to bena iya Dawida natuna?” ");
INSERT INTO sbe_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nige gonowana hesau ye hededebui Yesu unai, na tenem mayadaina ne unai na ye lau meta nige tamowai hesau ye nuwabayao na henamai hesau unai bena Yesu ye lupoiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na kabo Yesu ye hededelau boda yo yona hekahekatao wa udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Laugagayo taulauhekataena yo Paliseya bodana, siya meta Mose yona kulikuli tabudiyao taukitahekasanamwanamwaedi yo taulauhekataedi. ");
INSERT INTO sbe_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Unai saha se hedededi ne bena kwa miyawatanidi, na laulau saha se ginaulidi meta tabu kwa laulauyeidi, matawuwuna ede saha se laulauhekataeidi meta nige se miyamiyawatanidi. ");
INSERT INTO sbe_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Laugagayo bayabayaodi se ginaulidi bena taba tamowai se miyawatanidi, siya meta doha bahebahe polopolohedi se tolesaedi tamowai kewadiyena na se baheidi, iyamo siya nige gonowana nimadi se helelelaedi bena se saguidi. ");
INSERT INTO sbe_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ginauli maudoidi se ginaulidi meta bena kabo unai tamowai se kitahenamwadi. Laugagayo hedehededediyao kulikulidi kabaꞌusaidi ne se helakigaibuidi na se paihepatudi debadi yo nimadi udiyedi, yo kadi kwama sinosinodi se helohagaibuidi, ");
INSERT INTO sbe_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","yo kaikaigogo lakilakidiyao yo sunago udiyedi meta se henuwa bena kabatuli namwanamwadi udiyedi se tuli. ");
INSERT INTO sbe_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na ena se lau kabalokulokune bakubakudi udiyedi meta se henuwa bena tamowai se laoma ma hekasisidi se lautokiyeidi na se kawayauwedo yo se kawatanuwaga udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Na komiu tabu se kawatanuwaga kalimiuyena, matawuwuna kami tanuwaga kesega ede yau, na komiu meta doha boga kesega. ");
INSERT INTO sbe_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tabu tanoubu ta tamowaina hesau kwa katai meta iya tamamiu, matawuwuna tamamiu kesega ede galewa ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yo hinage komiu tabu hesamiu se katai meta taulauhekata, matawuwuna tauhekatagomiu kesega ede Keliso. ");
INSERT INTO sbe_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kaiteya luwamiuyena ye saekalili meta iya bena ye hemala yomi heyayai tauhaina. ");
INSERT INTO sbe_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kaiteya ye bom ye hesaeꞌuyoi meta Yaubada kabo ye toledobiyei, na kaiteya ye nuwadobidobi meta Yaubada kabo iya ye toleisini.” ");
INSERT INTO sbe_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Kabo Yesu ye wane, “Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Kabo kamkamna lakilakina kwa hekalo! Tamowai yodi lulau galewa basileiyana meta kwa gudukaliliyei. Komiu taba nige kwa lulau galewa basileiyana, na kaiteyadi se henuwa bena se lusolalau meta kwa hekahekaiyawasidi. ");
INSERT INTO sbe_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Kabo kamkamna lakilakina kwa hekalo! Kwa lau teha maudoina kwa tauhetakikilidi bena tamowai kwa nuwakoidi, na ena hesau ye nuwabui na ye hemala kami kaha hesau, yona laulau kabo se yababakalili na kabo komiu, na iya kabo ye lau kaiwa kalakalasina doha komiu. ");
INSERT INTO sbe_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ahani mo komiu, tauwoyawoya matagibugibudi! Kwa hedede kwa wane, ‘Ena tamowai hesau ye kaigwala Numa Tabuna ne unai meta yona kaigwala ne nige mamohoina, na ena tamowai hesau ye kaigwala Numa Tabuna golena ne unai meta nige gonowana ye buiꞌuyoi.’ ");
INSERT INTO sbe_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Komiu taumatagibugibu yo tamowai yauyaulediyao! Ginauli saha meta ye saekalili, gole ne o Numa Tabuna? Matawuwuna Numa Tabuna debanaena ede gole ne ye aꞌa. ");
INSERT INTO sbe_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yo hinage kwa hedede kwa wane, ‘Ena tamowai hesau ye kaigwala kaitalasam kabagabuna ne unai meta nige mamohoi, na ena tamowai hesau ye kaigwala kaitalasam udiyedi meta yona kaigwala ne nige gonowana ye buiꞌuyoi.’ ");
INSERT INTO sbe_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Komiu tamowai matagibugibudiyao! Kaitalasam gogodiyao kabahetabudi ede kaitalasam kabagabuna. Unai kaitalasam kabagabuna ye saekalili na kabo kaitalasam gogodiyao. ");
INSERT INTO sbe_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Unai ede ena tamowai hesau ye kaigwala kaitalasam kabagabuna ne unai, meta hinage ye kaigwala ginauli maudoidi kewana ne unai se toledi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na ena kaiteya ye kaigwala Numa Tabuna ne unai, meta hinage ye kaigwala Yaubada unai, iya meta Numa Tabuna ne unai taumiya. ");
INSERT INTO sbe_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yo ena kaiteya ye kaigwalasae galewa ne unai meta ye kaigwala Yaubada yona telona unai, yo hinage telona ne unai tautuli ne. ");
INSERT INTO sbe_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Laugagayo lakilakidi kwa tolehesuwaladi, na laugagayo gagigagilidi kwa toleisinidi. Doha yomi koya uwaꞌuwadi gagilidiyao udiyedi yomi taiti kwa toledi, na laugagayo nuwanuwatudi lakilakidi nige kwa lauwatanidi, siya ede laulaududulai, katekamkamna, yo sunuma. Taba laugagayo gagilidi ne tabu kwa nuwaluluhiyeidi na hinage laugagayo lakilakidi ta bena kwa miyawatanidi. ");
INSERT INTO sbe_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Komiu tauwoyawoya matagibugibudiyao! Kami waila udiyedi nabugala kwa hekonagabaeidi na iyamo kamela meta kwa tonoli. ");
INSERT INTO sbe_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Kami keyaka yo gaeba dageladiyao kwa deulinamwanamwaedi, na kalodiyao ne udiyedi meta mahimahihi yo nuwatuꞌuyo se mwayau. ");
INSERT INTO sbe_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Komiu Paliseya matagibugibudiyao! Kami keyaka yo gaeba kalodiyao ne kwa deulibagunaeidi na dageladiyao ne kabo hinage se aꞌa. ");
INSERT INTO sbe_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Matawuwuna ede kami kao meta doha bwayabwaya dagelana se deuliheꞌaꞌa na se pokahuheposiposi na iyamo kalona ne unai meta boha yo tauboiboita siliyadi yo ginauli bikibikidi udoiꞌudoi ye mwayau. ");
INSERT INTO sbe_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Unai, komiu kami kao ede doha bwayabwaya ne: Tamowai se kitagomiu meta bena komiu miyamiya dudulaidi tamowaidiyao, na iyamo nuwakalomiuyena meta laulaulupolupo yo nuwatu yabayababadiyao se mwayau. ");
INSERT INTO sbe_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ahani mo komiu, Mose yona laugagayo taulauhekataena bodana yo Paliseya bodana, komiu meta taukailupolupo tamowaidiyao! Peloweta bwayabwayadi kwa kabinamwanamwaeidi yo hekihekinoidiyao kwa hetolodi, yo laulaududulai tamowaidiyao bwayabwayadi kwa hepasanamwanamwaeidi. ");
INSERT INTO sbe_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na kwa wane, ‘Taba kama kulutubu maidamaiyao ka miya meta peloweta yodi hekamkamnadi ne unai taba nige ka kabisagusaguidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yomi hedehedede ta unai kwa bom kwa hededehemasalahaꞌuyoigomiu meta komiu peloweta taukoihemwaloidi wa kadi isimulitao ede. ");
INSERT INTO sbe_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kulutubumiyao laulau yababadi saha se ginaulitoledi wa, taba kwa laedi kwa hegehemolosiyeidi! ");
INSERT INTO sbe_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Komiu mwata yo mwata yabayababadi natudiyao! Idohagi kabo Yaubada yona hekamkamna magaina kwa wasabugabaei? ");
INSERT INTO sbe_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Unai kabo peloweta yo tamowai sibasibadiyao yo taulauhekata ya hetamalidiwa kalimiuwai. Hekadi kabo kwa koihemwaloidi yo kwa hesataulodi, na hekadi kabo sunago kalodiyena kwa sapidi yo kwa henakuhepesadi se lau teha udoiꞌudoi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Teina laulau ta debanaena laulaududulai tamowaidiyao kaiyaulina ta unai se unuidi wa kwasinadi giludi kabo se dobima kewamiuyena, laulaududulai tamowaina Abela kwasinana unai ye hetubu ye dobima ee Belakiya natuna Sakaliya unai, iya ede kabakaitalasam yo Numa Tabuna duwaduwalidiyena kwa koihemwaloiꞌusei wa. ");
INSERT INTO sbe_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya hededemamohoi kalimiuyena: Ginauli maudoidi ta giludi kabo se dobima kewamiuyena na kamkamna lakilakina kabo kwa lobai.” ");
INSERT INTO sbe_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kabo Yesu ye wane, “Ae Yelusalema! Yelusalema ee! Kowa peloweta taukoihemwaloidi yo tamowai Yaubada ye hetamalidi kalimyena meta ku hekalawekudi. Huya maudoina meta ya henuwa bena natumwao ya kabigogoidima doha kamkam sinadi natunao ye kabigogoidi pepenao gunidiyena, na iyamo komiu nige kwa henuwa. ");
INSERT INTO sbe_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Unai sola kwa kita, ‘Yaubada kabo yomi magai ye nuwagabaei na nige tamowaina.’ ");
INSERT INTO sbe_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na ya hededelaowa kalimiuwai ta, nige gonowana kwa kitaꞌuyoigau kana sigana ee kwa wane, ‘Ka hedebasaego, kowa Guiyau hesanaena ku laoma!’ ” ");
INSERT INTO sbe_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Numa tabuna bakubakuna wa unai Yesu ye dalahai ye laulau na yona hekahekatao wa se laoma ede se yogahekaiyawasi na se hededelau unai se wane, “Sola Numa Tabuna yo numana hekadiyo ne yodi kabikabidi yo kadi wawali ne ku kitadi!” ");
INSERT INTO sbe_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na ye hededelau udiyedi ye wane, “Ginauli maudoidi ta kwa kitadiko. Ya hededemamohoi kalimiuyena: Taba nige weku hesau ye miya yona hali weku kewanaena, na maudoidi meta kabo se ulugwaligwali.” ");
INSERT INTO sbe_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Se lau Olibe koyana unai se lage, ede Yesu ye lau ye tuli na yona hekahekatao wa se bom se laoma iya unai na se henamaiyei se wane, “Taba yomai ku hedehedede, kaiuyana kabo laulau ku hedededi wa se tubu, na yom uyoma yo tanoubu yona huyagehe hekihekinoidi ede saha?” ");
INSERT INTO sbe_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ye hededelau udiyedi ye wane, “Bena matamiyao se nega na tabu tamowai hesau ye lupohaigomiu. ");
INSERT INTO sbe_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tamowai se bado kabo hesaguyena se laoma na se hedehedede meta siya Keliso, na tamowai se bado kabo se lupohaidi. ");
INSERT INTO sbe_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Iyala wasadiyao yo hinage iyala wasalupolupodiyao kabo kwa lapuidi, na tabu udiyedi kwa matausi. Ginauli doha teina kabo se tubu na nige gonowana ta kaihaleidi, na iyamo tanoubu ta yona huyagehe meta sola. ");
INSERT INTO sbe_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magai hesau bodana yo magai hesau bodana kabo se haihewahewaiunuꞌuyoidi. Basileiya hesau yo basileiya hesau kabo hinage se iyaꞌiyalaꞌuyoidi. Yo hinage hasahasali lakilakidi yo mwanikuniku kabo se tubu teha udoiꞌudoi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ginauli saha se tubu ne meta ginauli nuwamatamatausidiyao sola kabo se laoma ne yodi kabahetubu ede. ");
INSERT INTO sbe_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Na kabo se hekamkamnagomiu yo se unuhemwaloigomiu, yo magai maudoidi bodadiyao kabo se subugomiu yau debaguyena. ");
INSERT INTO sbe_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tenem huyana ne unai boda hekana kabo Guiyau sunumana se laugabaei, ede kadi kahao se hewaiunudi yo kadi se walohai. ");
INSERT INTO sbe_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pelowetalupolupo se bado kabo se masalaha na bodalakilaki kabo se lupohaidi. ");
INSERT INTO sbe_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yababa udoiꞌudoi se lakikalili, debanaena tamowai kadi kahao gadosisidi nuwadiyena kabo se gagili yo se gehe. ");
INSERT INTO sbe_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na ena kaiteya ye tolobayao ye lau ee pilipili maudoidi sigadi ne unai, meta Yaubada kabo ye hemauli. ");
INSERT INTO sbe_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na basileiya wasana namwanamwana se lauguguyaei kaiyaulina teha maudoina unai na tamowai maudoidi se lapui, na kabo huya gehegehena ye laoma. ");
INSERT INTO sbe_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na Numa Tabuna unai kabo ginauli nuwamatamatausina kwa kita ye totolo, iya magai tauheyababana, na iya ede peloweta Daniyela ye hededehemasalahaꞌusei wa – lausoisoi ta tauhasilina meta kaniyona bena ye nuwatulobai. Na huyana ginauli ne ye tubu ");
INSERT INTO sbe_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kabo kaiteyadi teha Yudeya unai taumiya bena se yabubu se sae kuduli ne. ");
INSERT INTO sbe_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tabu tamowai hesau numa kewana unai na ye pesadobi yona numa kalona unai gogo saha hesau ye hai na ye wasabu. ");
INSERT INTO sbe_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yo ena tamowai hesau yona koya unai meta tabu ye uyo magai kana kwama nimalohalohana hesabana. ");
INSERT INTO sbe_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na sinesineo diyadiyakadi yo sinesineo labalabahauhaudi ya nuwanuwatuidi, matawuwuna tenem mayadaina ne kabo ye pilipilikalili kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Na kwa tapwalolo Yaubada unai yomi huyawasabu meta tabu huyagwagwama o Sabatiyena. ");
INSERT INTO sbe_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Matawuwuna kamkamna ye tubu ne kabo ye lakikalili, nige doha beyabeyana tanoubu yona huyatubu unai ye laoma teina huya ta, yo mulina ne unai hinage taba nige ye tubuꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ena Yaubada tenem mayadaidi ne nige ye hekubwadima, meta nige gonowana tamowai hesau mauli ye lobai. Na iyamo yona kaisunuwa tamowaidi debadiyena tenem huya ne ye hekubwadi. ");
INSERT INTO sbe_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tenem huyana ne unai, ena tamowai hesau ye hededelaowa kalimiuwai ye wane, ‘Kwa kitalaoma, Keliso ede inai!’, o hesau ye wane, ‘Iya ede temenai!’, meta tabu kwa kawakawamamohoiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kabo keliso lupolupodi yo pelowetalupolupo udoiꞌudoi se masalahama na laulau gigigigibwalidi yo kabanoko saesaedi se ginaulidi bena kabo tamowai se lupohaidi. Yo hinage se kaipate bena Yaubada yona kaisunuwa tamowaidiyao se lupohaidi, na iyamo nige gonowadi. ");
INSERT INTO sbe_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Teina ta meta ya hededehesibasibanonohaigomiu. ");
INSERT INTO sbe_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Unai, ena tamowai hesau ye hededelaowa meta Keliso ede balabalagaibu ne unai, tabu kwa laulau menai. Yo ena ye hededelaowa meta bena iya ede numa hesau dahalana wadawadamna unai, tabu kwa kawakawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Matawuwuna Tau Natuna yona laoma doha namanamali, ye sili teha kaluwabu ne unai na dawayana gonowana ye masalaha teha yalasi unai. ");
INSERT INTO sbe_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gonogonowana doha, kaiteya teha unai suisui boiboitana panena, kabo manuwa kaikaitaudi se lagegogoi menai. ");
INSERT INTO sbe_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nuwadubu mayadaidi ne se gehe na nige bayaona ‘kabo mahana ye masigili yo waikena kabo nige ye dawaya, galewa ne kipwaladi kabo se beku, yo galewa ginaulidi yodi kabamiya Yaubada kabo ye nukuidi.’ ");
INSERT INTO sbe_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na kabo huyagehena ne unai Tau Natuna yona laoma hekihekinoidi kabo se taumasalaha galewa ne unai, yo tanoubu tehana maudoina tamowaidiyao se dousiyasiyayau, na kabo Tau Natuna se kita ye lagema galewa yadana udiyedi ma gigibwalina yo ma didigana saesaena. ");
INSERT INTO sbe_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na bwagigi kabo se yuhi na daguguna ne unai kabo yona anelu ye hetamalidi se lau bena teha hasi yaumaidi yodi kabatowalaoma udiyedi yo tanoubu ta maudoina unai yona kaisunuwa tamowaidiyao se laedima.” ");
INSERT INTO sbe_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu ye hededeꞌuyo ye wane, “Kwa kitalau kaiwa ne unai, iya heyaheyasonina ta kabo ye hekatagomiu: Ena lagadi ne udiyedi lugudi hauhaudi se kini meta kabina kwa kata ede huyamahamahana ye hanahanauma. ");
INSERT INTO sbe_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gonogonowana doha huyana ginauli maudoidi ta kwa kitadi se tubu, kabo kabina kwa kata meta Tau Natuna ye hanahanaumako, iya ede kawakeda ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya hededemamohoi kalimiuwai: Teina isi ta taba nige ye gehe ye lau ee ginauli maudoidi ta se tubu. ");
INSERT INTO sbe_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Galewa yo tanoubu kabo se gehe, na yogu hedehedede meta taba nige se gehe.” ");
INSERT INTO sbe_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kabo Yesu ye wane, “Tau Natuna yona huyaꞌuyoma mayadaina yo mahanana nige hesau kabina ye kata, galewa aneludi hinage nige kabina se kata, Natuna hinage nige kabina ye kata, na Tamana iya ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tau Natuna yona laoma ne meta gonogonowana doha beyabeyana Nowa yona huya mayadaidi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Huyana sola nige dibwaliꞌutuꞌutu ye tubu meta tamowai se kaikai yo se numanuma, yo hinage tatao yo sinesineo se tawatawasola ye lau ee kana siga Nowa ma natunao se mwalaesae waga wa unai. ");
INSERT INTO sbe_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tamowai wa nige se nuwatulobai saha kabo ye tubu kalidiyena kana siga dibwaliꞌutuꞌutu wa ye dididobima ede ye yaluhaidi. Na Tau Natuna yona huyaꞌuyoma kana kao kabo doha tenem mayadaidi ne. ");
INSERT INTO sbe_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Huyana ne unai tatao labui se paipaisowa koya kesega unai. Yaubada kabo kesega ye hai na kesega kabo ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sinesineo labui witi kabagiligiliyena se paipaisowalabulabui meta hesau kabo Yaubada ye haigabaei, na hesau kabo ye miya. ");
INSERT INTO sbe_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Unai bena kwa silasilawa yo kwa nonoha matawuwuna ede yomi Guiyau yona uyoma mayadaina meta nige kabina kwa kata. ");
INSERT INTO sbe_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ginauli kesega ye masalahakalili: Ena taba numa tanuwagana kabina ye kata boniyaiyena mahana saha unai kabo taukaiwahali ye laoma bena ye kaiwahali, kabo ye silasilawa yo yona numa ye kitahetete na taukaiwahali tabu ye lusae yona numaena. ");
INSERT INTO sbe_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Unai komiu hinage bena kwa nonoha, matawuwuna Tau Natuna yona uyoma mahanana kabo ye hesiliyatagomiu.” ");
INSERT INTO sbe_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Hage, heyayai tauhaina laulaududulaina yo sibasibana yona kabikabi kwa nuwatuidi. Kana tanuwaga iya ye kaisunuwai yona numa kalonawai heyayai tauhaidi maudoidi taukitahetetedi yo kadi kai ye mosemoseidi kaikai mahanana dudulaina unai. Na kabo kana tanuwaga ye dalahai ye lau ye kadau. ");
INSERT INTO sbe_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yona huyaꞌuyoma unai, ena yona heyayai tauhaina wa ye lobai yona paisowa unai ye paipaisowanamwanamwa, kabo heyayai tauhaina ne gonowana ye gwauyala. ");
INSERT INTO sbe_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya hededemamohoi kalimiuyena: Heyayai tauhaina ne kabo ye hai na ye tole yona gogo maudoidi taukitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Na taba heyayai tauhaina ne yona nuwanuwatu se yababa na ye wane, ‘Kagu tanuwaga taba nige ye lagemwamwayauma’, meta idohagi? ");
INSERT INTO sbe_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nuwana ye hetubu yona hali heyayai tauhaidi wa ye kabihenayaidi yo hinage numanuma bayabayaodi taunumanumadi maiyanao se kaikai yo se numanuma. ");
INSERT INTO sbe_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kana tanuwaga ne kabo ye lageꞌuyoma na yona heyayai tauhaina wa kabo ye siliyata, matawuwuna kana tanuwaga yona uyoma mayadaina yo mahanana meta nige ye nuwatui. ");
INSERT INTO sbe_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tanuwaga wa yona heyayai tauhaina wa ye hekamkamnakaliliyei yo ye hai ye tolelaei taukailupolupo yodi kabakamkamna magaina unai kabo ye doudou yo gadigadina ye kapuyahisidi.” ");
INSERT INTO sbe_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu yona hedehedede wa ye tubei ye wane, “Galewa basileiyana heyaheyasonina hesau ede doha teina: Hasahasalao saudoudoi yodi lampa se haidi na se lau tautawasola tamowaina se launayanayai bena se hailobai. ");
INSERT INTO sbe_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Taudi haligigi meta naganagadi na hinage taudi haligigi meta se sibasiba. ");
INSERT INTO sbe_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Naganagadiyao wa yodi lampa se baheidi na nige yodi kelesini hetulanidi se baheidi. ");
INSERT INTO sbe_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na sibasibadiyao wa yodi lampa se baheidi yo yodi kelesini initoledi hinage. ");
INSERT INTO sbe_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tautawasola tamowaina wa yona laoma ye pahili ede hasahasalao maudoidi wa kamnadi se yababa yo matadi se kenokeno ede se keno. ");
INSERT INTO sbe_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Boniyai duwaduwalina unai tamowai hesau ye heyoheyoga ye wane, ‘Tautawasola tamowaina wa ye lagemako, kwa laoma kwa hailobai!’ ");
INSERT INTO sbe_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hasahasalao saudoudoi wa se kenotolo ede yodi lampa se nukutonogidi. ");
INSERT INTO sbe_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kabo naganagadiyao wa se hededelau sibasibadiyao wa udiyedi se wane, ‘Kelesini teuna unai kwa saguigai! Yoma lampa ta bena se boso.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na sibasibadiyao wa se wane, ‘Nigele, yoma kelesini ta gonogonowamai, nige gonowana ka saguigomiu. Na kwa lau kabalokulokune unai yomi kelesini kwa hemaisadi.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Naganagadiyao haligigi wa se lauko bena yodi kelesini se hemaisadi, na kabo tautawasola tamowaina wa ye lage. Ede sibasibadiyao haligigi se nonohako wa maidanao se lau hetahetawasola kaikaigogona unai. Se lusae, na kabo keda taukitahetetena keda wa ye gudui. ");
INSERT INTO sbe_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muliyena kabo hasahasalao hekadi wa se lage ede se yogalau tautawasola tamowaina wa unai se wane, ‘Taubada, taubada, keda ku soke na ka mwalaewa!’ ");
INSERT INTO sbe_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na ye hededelau udiyedi ye wane, ‘Ya hededemamohoi: Nige kabimiu ya kata.’” ");
INSERT INTO sbe_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na Yesu ye hededehasahasaidi ye wane, “Unai bena kwa silasilawa, matawuwuna ede Tau Natuna yona laoma mayadaina yo mahanana meta nige kabina kwa kata.” ");
INSERT INTO sbe_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","15","Yo hinage Yesu heyaheyasoni hesau ye hedede ye wane, “Galewa Basileiyana meta doha tamowai hesau bena ye kadau ye lau kedalohaloha, na yona heyayai tauhaidi ye yogagogoidima na kesega kesega yona paisowa kana kaoyena yona moni ye soiyeidi kalidiyena. Heyayai tauhaina tamowaina bagubagunana unai moni baikidi haligigi ye mosei, helabuina moni baikidi labui ye mosei, na hesau unai moni baikidi kesega ye mosei. Unai yodi paisowa ye moseidi na yona kabakadauyena ye kadau. ");
INSERT INTO sbe_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Heyayai tauhaina bagubagunana wa yona moni baikidi haligigi wa ye hepaisowa na ye helakiꞌuyoi ede baikidi haligigi ye lobaiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na taupaisowa hesau yona moni baikidi labui ye hai wa ye lau ye hepaisowa na ye helakiꞌuyoi ede baikidi labui ye lobaiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na heyayai tauhaina hesau wa yona moni baikidi kesega wa ye hai na ye lau, bwatano unai duha ye sala na kana tanuwaga yona moni wa ye tolewadam. ");
INSERT INTO sbe_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Huyalohaloha mulinaena heyayai tauhaidi kadi tanuwaga wa ye uyoma na ye yogagogoidima na ye henamaiyeidi idohagi yona moni wa yodi hepahepaisowadi. ");
INSERT INTO sbe_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kabo moni baikidi haligigi tauhaina wa ye laoma ye wane, ‘Guiyau, moni baikidi haligigi ku haidima wa ya hepaisowadi ede hinage hagahagana baikidi haligigi ya lobai.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kana tanuwaga wa ye wane, ‘Kowa heyayai tauhaina namwanamwana, ya sunumaego matawuwuna moni gagilina gonowana ku kitahetete. Unai kabo ya tolego ginauli lakilakidi ku kitahetetedi. Ku laoma yo yogu gwauyala ta unai ta gwauyalakesega.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kabo moni lakina baikidi labui tauhaina wa hinage ye laoma ede ye wane, ‘Guiyau, moni baikidi labui ku haidima wa ya hepaisowadi ede hinage hagahagana baikidi labui ya lobai.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kana tanuwaga ye wane, ‘Kowa heyayai tauhaina namwanamwana, ya sunumaego, matawuwuna moni gagilina gonowana ku kitahetete. Unai kabo ya tolego ginauli lakilakidi ku kitahetetedi. Ku laoma yo yogu gwauyala ta unai ta gwauyalakesega.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Na kabo moni lakina baikidi kesega tauhaina wa ye laoma ede ye wane, ‘Guiyau, kabim ya kata meta kowa tamowai yona laulau yabayababana, matawuwuna ede haedi nige saha hesau ku kumai meta kabo unai ku kelikeli, yo haedi nige witi likena ku hesulu meta kabo unai kaniyona ku tanogogo. ");
INSERT INTO sbe_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Unai ya matausi ede ya lau bwatanoyena yom moni wa ya puluhiwadam, unai saha kowa yom wa meta iya ede teina.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ede kana tanuwaga wa ye hededelau unai ye wane, ‘Kowa tamowai yababana yo miyamiyagaibuna! Ku hedede meta kabigu ku kata ena haedi nige saha hesau ya kumai meta unai ya kelikeli, yo haedi nige witi likena ya hesulu meta udiyedi kaniyodi ya tanotanogogo? ");
INSERT INTO sbe_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Idohagi to yogu moni ne nige ku lau ku tole moni taukitakitahetetedi udiyedi na yogu uyoma ta unai kabo ya haiꞌuyoi yo hagahagana hinage?’ ");
INSERT INTO sbe_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kabo ye hededelau yona heyayai tauhaidi hekadiyo udiyedi ye wane, ‘Moni ne kalinawai kwa haigabaei na kwa moselaei moni baikidi saudoudoi tauhaina ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaiteyadi saha kalidiyena meta kabo se koihepwataꞌuyoidi na ginauli saha kalidiyena wa kabo ye lakikalili. Na kaiteyadi nige saha kalidiyena meta kabo ginauli saha gagilina kalidiyena ne se haigabaei.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na ye wane, ‘Teina tamowai ta, iya heyayai tauhaina yababakalilina, kwa gabahepesadobiyei masigili ne unai! Menai kabo ye doudou yo gadigadina ye kapuyahisidi.’” ");
INSERT INTO sbe_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Huyana Tau Natuna kabo ye uyoma ma didigana yo ma namanamalina, yo yona anelu maudoidi maidanao, meta kabo yona telona wasawasana yo saesaekalilina unai ye tuli yo ye hemala wasawasa. ");
INSERT INTO sbe_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na basileiya maudoidi tamowaidiyao kabo se laomagogoi kalinawai na tamowai wa ye hekasadi, doha suisui taukitahetetedi yona suisui ye hekasadi, mamoe teha hesau unai ye toledi yo gouti teha hesau unai. ");
INSERT INTO sbe_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mamoe kabo ye toledi tehatutuna unai, yo gouti ye toledi tehaseuseulina unai. ");
INSERT INTO sbe_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na kabo wasawasa wa ye hededelau nimatutuna tamowaidiyao wa udiyedi ye wane, ‘Kwa laoma, komiu tamagu yona hededehenamwa tamowaidiyao! Huyana sola nige tanoubu ye tubu meta tamagu galewa basileiyana ye ginaulinonohaiyako komiu hesabamiu. Kwa laoma na unai kwa miya. ");
INSERT INTO sbe_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Huyana ya hasali meta kai kwa haiyama ya kai, yo gadogu ye magu meta waila kwa haiyama ya numa, na yau laolaoma, iyamo kwa yogaisinigau yomi numaena. ");
INSERT INTO sbe_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Huyana nige yogu kaleko meta kaleko yogu kwa haidima, ya kasiyebwa meta kwa kitahetetegau, yo hinage numatutuguduyena se tolegau meta kwa laoma kwa kaitaumanaigau.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kabo miyamiyadudulai tamowaidiyao wa se hededelau unai se wane, ‘Guiyau, kaiuyana ka kitago ku hasali na kai ka haiyawa, gadom ye magu na waila ka haiyawa ku numa? ");
INSERT INTO sbe_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yo kaiuyana ka kitago kowa laolaoma na ka yogaisinigo, yo nige yom kaleko na kaleko yom ka haidiwa? ");
INSERT INTO sbe_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hinage kaiuyana ka kitago ku kasiyebwa o numatutuguduyena na ka laowa ka kaitaumanaigo?’ ");
INSERT INTO sbe_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wasawasa wa kabo ye hededebui kalidiyena ye wane, ‘Mamohoi, na ya hededeꞌuyo kalimiuyena: Ena teina laulau ta hesau kwa ginauli kagu kahao dobidobidi ta hesau unai meta kwa ginauli yau kaliguwai.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kabo ye hededelau tehaseuseulina unai tautolo wa udiyedi ye wane, ‘Kwa tausuwala kaliguwai, komiu tamagu yona hededeheyababa tamowaidiyao. Kwa lau kaiwa kalakalasina nige yona kababoso ne unai, tamagu ye kabinonohai diyabolo yo yona anelu hesabadi. ");
INSERT INTO sbe_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Matawuwuna ede ya hasali na nige kai kwa haiyama ya kai, gadogu ye magu na nige waila kwa haiyama ya numa. ");
INSERT INTO sbe_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yau laolaoma na nige kwa yogaisinigau, nige yogu kaleko, na nige kwa hekalekogau, ya kasiyebwa yo numatutuguduyena se tolegau na nige kwa laoma kwa kaitaumanaigau.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na kabo se wane, ‘Guiyau, kaiuyana ka kitago ku hasali, gadom ye magu, kowa laolaoma, nige yom kaleko, ku kasiyebwa, yo se tolego numatutuguduyena, na nige ka saguigo?’ ");
INSERT INTO sbe_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ede ye hededelau udiyedi ye wane, ‘Ya hededemamohoi kalimiuyena: Ena nige laulau ta hesau kwa ginauli tamowai dobidobidi ta hesau unai meta hinage nige saha hesau kwa ginauli yau kaliguwai.’ ");
INSERT INTO sbe_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kabo se lau kamkamna nige yona kabagehe unai, na miyamiyadudulai tamowaidiyao wa kabo se lau mauli nige kana siga unai.” ————————— ");
INSERT INTO sbe_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu yona lauhekata hedehedededi wa mulidi ne unai kabo ye hededelau yona hekahekatao wa udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kabina kwa kata meta mayadai labui mo na kabo Taukiuli Henuwaisinina, na tenem mayadaidi ne udiyedi Tau Natuna kabo se mosegabaei na se hesataulo.” ");
INSERT INTO sbe_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na taukaitalasam tauwoyaidi yo magai wa babadadiyao se lagegogoima taukaitalasam saesaena hesana Kaiyapasi yona numa unai, ");
INSERT INTO sbe_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na se koitalaliu idohagi kabo lupo hesau se ginauli na unai kabo Yesu se hai na se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na se wane, “Nige teina Taukiuli Henuwaisinina huyana ta unai, matawuwuna ede boda ta yo kita kalidaena kabo hetalagegagega lakilakina ye tubu.” ");
INSERT INTO sbe_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Huya hesau Betaniya unai, Yesu meta tamowai hesau hesana Simona yona numaena. Simona hesana hesau ede Taulepela. ");
INSERT INTO sbe_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yodi huyakaikai unai meta waihiu hesau yausi panena namwanamwana yo maisana lakilakina ye bahei na ye laoma ede Yesu kuluna kewanaena ye ini. ");
INSERT INTO sbe_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yona hekahekatao wa se kita meta se kouyalayala yo se hetalapili, se wane, “Idohagi to yausi ta ku kaiheyagaibui. ");
INSERT INTO sbe_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Teina yausi ta taba ta lokunei kabo moni lakilakina ta hai na ta mosei deha tamowaidiyao udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yodi nuwatu wa Yesu kabina ye kata ede ye hededelau udiyedi ye wane, “Idohagi to waihiu ta kwa hemohemode. Teina ta meta laulau namwanamwana ye ginauli kaliguyena. ");
INSERT INTO sbe_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Deha tamowaidiyao kabo huya maudoina maidamiyao, na yau meta nige gonowana huya maudoina maidamiu. ");
INSERT INTO sbe_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Taugu ta ye heyausi meta ye kabinonohaigau toletoletau hesabana. ");
INSERT INTO sbe_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya hededemamohoi: Kaiyaulina maudoina ta unai, ena haedi wasa namwanamwana ta se lauguguyaei, meta waihiu ta saha ye ginauli ne wasana kabo hinage se hasili iya kabahenuhenuwaisinina.” ");
INSERT INTO sbe_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tenem huyana ne unai kabo saudoudoi-labui wa luwadiyena hesau hesana Yudasi Isakaliyota ye lau taukaitalasam tauwoyaidi ");
INSERT INTO sbe_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ye henamaiyeidi ye wane, “Moni lakina saha kabo kwa haiyama, ena Yesu ya mosegabaeiyawa kalimiuyena?” Unai moni siluba badona ede 30 se mosei. ");
INSERT INTO sbe_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huyana ne unai ye lau meta ye hetubu ye kaikewasipwa na taba kamwasa saha unai kabo Yesu ye mosegabaei kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pwalawa Nige Yistina Henuwaisinina mayadaina bagubagunana unai, hekahekatao wa se laoma Yesu se henamaiyei se wane, “Kaiteya tupwa ku henuwa kabo unai Taukiuli kaina ka kabinonohai?” ");
INSERT INTO sbe_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ede ye hededelau udiyedi ye wane, “Kwa lau magailaki ne unai tamowai hesau ya hededeyako kalimiuyena wa kabo kwa lobai. Kwa hededelau unai kwa wane, ‘Taulauhekata ye wane, “Yogu huya ye hanahanauma. Unai yau yo yogu hekahekatao kabo yom numaena Taukiuli kaikaigogona ka kai.” ’” ");
INSERT INTO sbe_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Unai hekahekatao wa se lau na saha Yesu ye hedede wa se ginauliwatani na Taukiuli Henuwaisinina kaina wa se kabinonohai. ");
INSERT INTO sbe_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ye meimeilahi ede Yesu yo yona hekahekatao saudoudoi-labui wa se laomakesega na se kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yodi kaikai wa unai Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuyena: Kesega luwamiu ta unai kabo kagu ye walohai.” ");
INSERT INTO sbe_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yona hedehedede wa unai nuwadiyao se yababakalili ede kesega kesega ye henahenamailau Yesu unai ye wane, “Guiyau, yau, e nigele?” ");
INSERT INTO sbe_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ye hededebui ye wane, “Yoda kaikaigogo ta unai luwamiuyena kaiteya nimanaena pwalawa ye hai na ye hedakwadobiyei kada gaeba ta unai meta iya kabo kagu ye walohai.” ");
INSERT INTO sbe_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hinage ye wane, “Tau Natuna yona boita kulikuli tabuna unai se kulinonohaiyako wa meta kabo ye laoma ye mamohoi. Na ahani mo tauwalohai tamowaina ne, kabo kamkamna lakilakikalilina ye hekalo. Taba ye namwa mo sinana iya tabu ye labasi.” ");
INSERT INTO sbe_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ede Yudasi iya kabo Yesu kana ye walohai wa ye wane, “Labi, ku nuwatui meta yau, e nige?” Na Yesu ye hededelau unai ye wane, “Kowa ku bom ku hededeꞌuyoigo.” ");
INSERT INTO sbe_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yodi kaikaigogo wa unai, Yesu pwalawa ye hai, ye lautoki, ye kihi, na ye mosei yona hekahekatao wa udiyedi na ye wane, “Kwa hai kwa kai, teina ta yau taugu.” ");
INSERT INTO sbe_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Waina keyakana ye hai, ye lautoki, na ye mosei yona hekahekatao wa udiyedi na ye wane, “Maudoimiu ta kwa numa. ");
INSERT INTO sbe_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Teina ta yau kwasinagu, na unai kabo Yaubada yona talam hauhauna ye ginauli kalimiuwai. Kwasinagu ta kabo ye didi tamowai maudoidi yodi yababa nuwatugabaedi hesabana. ");
INSERT INTO sbe_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya hededelaowa kalimiuyena, taba nige wine kaniyona masina ta ya numaꞌuyoi kana sigana ee Tamagu yona basileiya unai komiu yo yau kabo ta numaꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yodi kaikaigogo gehena wa unai wanalautoki hesau se wanai na kabo se pesa se lau Olibe koyana unai. ");
INSERT INTO sbe_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na Yesu ye hededelau udiyedi ye wane, “Teina boniyai ta unai saha kabo ye tubu kaliguyena debanaena maudoimiu kabo kwa wasabugabaeigau, kaniyona ede kulikuli tabuna unai se kulinonohaiyako ye wane, ‘Mamoe taukitahetetedi kabo ya unuhemwaloi, na yona mamoe yawoina kabo se wasabugwaligwali.’ ");
INSERT INTO sbe_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na yogu toloꞌuyo mulina ne unai kabo ya bagunalau Galili na kwa laowa kabo menai ta hailobai.” ");
INSERT INTO sbe_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petelo ye hededebui ye wane, “Ena kagu kahao ta maudoidi se laugabaego, iyamo yau taba nige.” ");
INSERT INTO sbe_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ede Yesu ye hededelau unai ye wane, “Ya hededemamohoi kalimyena: Teina boniyai ta unai sola nige kamkam hakiyana ye dou, na ma haiyona kowa kabo ku uhalaeigau.” ");
INSERT INTO sbe_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na kabo Petelo ye hedehededeꞌuyo ye wane, “Ena kowa to yau bena kabo ta boita, iyamo yau taba nige ya uhalaeigo!” Hinage hekahekatao hekadi wa yodi hedehedede meta gonogonowana. ");
INSERT INTO sbe_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na kabo Yesu maiyana hekahekatao wa se lau Getesemani. Menai ye hededelau udiyedi ye wane, “Inai kwa babawa na yau ya lau temenai ya tapwalolo.” ");
INSERT INTO sbe_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ede Petelo yo Sebedaiyo natunao labui ye woyaidi na se lau. Menai kabo Yesu ye hetubu ye nuwakamkamna yo ye nuwanuwatukalili. ");
INSERT INTO sbe_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na kabo ye hededelau udiyedi ye wane, “Nuwagu ta ye kamkamnakalili gonowana kabo unai ya boita, unai inai kabo komiu yo yau ta silasilawa.” ");
INSERT INTO sbe_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu ye tausigilau kabo ye guliyaboyabomdobi tano ne unai na ye tapwalolo ye wane, “Tamagu, taba gonowana teina kamkamna keyakana ta kaliguyena ku haigabaei. Na tabu yau yogu nuwatu ya lauwatani, na kowa yom nuwatu mo bena ya lauwatani.” ");
INSERT INTO sbe_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ye uyoma meta yona hekahekatao wa ye lobaidi se kenoko, ede ye hededelau Petelo unai ye wane, “Kagu kahao, idohagi to nige gonowana komiu yo yau ta silasilawa awa kesega? ");
INSERT INTO sbe_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kwa silasilawa yo kwa tapwatapwalolo, kabo taba nige noho kwa hekalo na unai kwa beku. Yaluwamiu ta se talam, na iyamo taumiu ta se basabasa.” ");
INSERT INTO sbe_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Helabuina ye uyo ye tapwalolo ye wane, “Tamagu, ena nige kamwasa hesau unai bena kamkamna keyakana ta ku haigabaei, na ku henuwa bena ya numa, takiyede yom nuwatu kabo ya lauwatani.” ");
INSERT INTO sbe_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ye uyoma ye lobaiꞌuyoidi ma kenodi, matawuwuna ede matadiyao wa se kenokenokalili. ");
INSERT INTO sbe_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ede ye laugabaeidi na ye uyo na huya hehaiyonana ye tapwalolo, yona tapwalolo wa meta hedehedededi kesekesegadi udiyedi ye tapwaloloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ye uyo yona hekahekatao wa udiyedi na ye hededelau udiyedi ye wane, “Komiu sola kwa kenokeno yo kwa kaikaiyawasi? Kwa kita, mahanana ede ye hanahanaumako, na Tau Natuna kabo se moselaei yababa tamowaidiyao nimadiyena. ");
INSERT INTO sbe_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kwa tolo na ta lau, kagu tauwalohai wa ye lageko.” ");
INSERT INTO sbe_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu sola ma hedehededena, na Yudasi ye lage, iya meta saudoudoi-labui wa hesauna. Bodalakilaki maiyanao se laoma ma kelekelepadi yo yodi kepata hinage se baheidi. Boda ta meta taukaitalasam tauwoyaidi yo magai babadadiyao se hetamalidima. ");
INSERT INTO sbe_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na tauwalohai wa meta maiyadi se koitalaliuko kabo hekihekinoi saha ye ginauli na tamowaina ne unai se kitalobai na se hai, ye wane, “Kaiteya tamowai ya sumtai ne meta iya bena kwa haiꞌusei ede.” ");
INSERT INTO sbe_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudasi ye laududulai ye lau Yesu unai na ye wane, “Labi, yauwedo!” na kabo ye sumtai. ");
INSERT INTO sbe_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ye hededelau unai ye wane, “Kehagu, saha hesabana ku laoma ta meta ku ginauli!” Kabo boda wa se lau Yesu se hai. ");
INSERT INTO sbe_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Temenai Yesu kana kahao wa hesau yona kelepa ye hai ede taukaitalasam saesaena yona heyayai tauhaina tamowaina hesau beyana ye bolihai. ");
INSERT INTO sbe_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu ye hededelau unai ye wane, “Yom kelepa ne ku toleꞌuyoi yom kabahaina ne unai, matawuwuna ede kaiteyadi kelepa se hepaisowa unai se lulu meta kabo hinage kelepaena se boita. ");
INSERT INTO sbe_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nige ku nuwatulobai meta gonowana ya yogasae Tamagu unai na anelu bodadiyao saudoudoi-labui ye hetamalidima? ");
INSERT INTO sbe_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na idohagi kabo kulikuli tabudi hedehededediyao se laoma se mamohoi, matawuwuna se hededenonohai meta teina laulau ta kabo ye tubu.” ");
INSERT INTO sbe_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mahanana ne unai Yesu ye hededelau boda wa udiyedi ye wane, “Ma kelekelepamiu yo kepata kwa baheidi na kwa laoma, kana kao doha bena taukaiunu kwa kelebesi. Huya maudoina meta Numa Tabuna bakubakuna unai ya laulauhekata na nige kwa kabihekahinigau. ");
INSERT INTO sbe_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na teina ginauli maudoidi se tubu ta udiyedi meta Peloweta yodi kulikuli kabo se laoma se mamohoi.” Na kabo hekahekatao wa Yesu se wasabugabaei. ");
INSERT INTO sbe_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Boda wa Yesu se hai na se laei taukaitalasam saesaena hesana Kaiyapasi yona numaena. Menai meta laugagayo taulauhekataena yo magai babadadiyao se laomagogoiko na se nayanaya. ");
INSERT INTO sbe_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Petelo meta Yesu yo taulaeina wa ye hemuliwatanidi kana siga se lage taukaitalasam saesaena yona numa bakubakuna unai. Ye mwalaesae na heyayai tauhaidi hekadi maidanao se tuli, na Petelo ye kaikaikewa kabo saha ye tubu Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taukaitalasam tauwoyaidi yo Sunedeli tamowaidi maudoidi, siya Yesu kana mata se wasenei na hedehedede lupolupodiyao udiyedi se hegilu na unai bena kabo se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na tauhededelupolupo se bado yodi hedehedede se hedededi, na iyamo nige kana mata hesau se lobai kabo unai se hegilu. ");
INSERT INTO sbe_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Na gehena ne unai kabo tauhedehedede labui se wane, “Teina tamowai ta ye wane, ‘Yaubada yona Numa Tabuna yau gonowana ya hetatagwaligwali na mayadai haiyona unai kabo ya kabiꞌuyoi.’” ");
INSERT INTO sbe_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na kabo taukaitalasam saesaena wa ye tolo na ye hededelau Yesu unai ye wane, “Kabo hedehedede saha hesau ku hedede o nige? Teina tamowai ta kam hedehedede maudoidi se hedededi ta mamohoidi o nige?” ");
INSERT INTO sbe_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na Yesu nige saha hesau ye hedede. Ede taukaitalasam saesaena wa ye hededelau Yesu unai ye wane, “Yaubada maumaulina hesanaena ku kaigwala na ku hededelaoma kalimaiyena: Kowa Keliso, Yaubada Natuna, o nige?” ");
INSERT INTO sbe_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu ye talam ye wane, “Aa, saha ku hedede ne meta mamohoi, na ya hededelaowa maudoimiu kalimiuyena, huya matada ne unai kabo Tau Natuna kwa kita Yaubada Saesaekalilina nimakahatuna unai ye tutuli na galewa yadana kewanaena ye laolaoma.” ");
INSERT INTO sbe_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kabo taukaitalasam saesaena wa ye bom kana kwama ye pulisidi na ye wane, “Teina tamowai ta meta Yaubada ye hededeheyababa! Taba nige tamowai hesau ta waseneiꞌuyoi na bena tamowai ta hedehededena hesau ye hededeꞌuyoi. Yona hededeheyababa meta kwa lapuidiko. ");
INSERT INTO sbe_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Unai yomi hineli ede saha?” Boda wa se wane, “Ye namwa mo taba ye boita.” ");
INSERT INTO sbe_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na kabo debana wa se kaikaisoi yo nimadiyena se biteli, yo hekadi se laupapali ");
INSERT INTO sbe_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na se wane, “Keliso, ku hededepeloweta kalimaiyena, kaiteya ye biteligo?” ");
INSERT INTO sbe_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Petelo meta ye tutuli bakubaku wa unai, kabo heyayai tauhaina waihiu hesau ye laoma iya unai na ye wane, “Kowa hinage Yesu Galili tamowaina tauhemuliwatanina hesau.” ");
INSERT INTO sbe_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na boda wa matadiyena ye uhala ye wane, “Saha ku hetahetala me nige kabina ya kata.” ");
INSERT INTO sbe_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ede ye lau gana kedana wa unai, na menai heyayai tauhaina waihiuna hesau Petelo ye kita na ye hededelau tamowai hekadi udiyedi ye wane, “Teina tamowai ta meta Yesu Nasaleta tauna tauhemuliwatanina hesau.” ");
INSERT INTO sbe_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na kabo ye kaigwala na ye uhalaꞌuyo ye wane, “Temeta tamowai ne meta nige kabina ya kata.” ");
INSERT INTO sbe_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yawalana ye lau na temenai tautotolo wa se lau Petelo unai na se wane, “Yom hedehedede daguguna meta doha Galili tamowaina, unai kabina ka kata meta kowa kadi kaha hesau.” ");
INSERT INTO sbe_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kabo Petelo ye bom ye hededeheyababaꞌuyoi yo ye kaigwala na ye wane, “Ena ya uhalalupolupo meta giluna Yaubada kabo ye tole kaliguyena. Temeta tamowai me nige kabina ya kata!” Na mahanana ne unai kamkam hakiyana ye dou. ");
INSERT INTO sbe_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ede Petelo Yesu yona hedehedede wa ye nuwatuidi ye wane, “Sola nige kamkam hakiyana ye dou na ma haiyona kabo ku uhalaeigau.” Unai nuwana wa ye yababakalili na ye pesa ye lau dagela wa unai ye doumwalomwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Malatomtom gagilina unai taukaitalasam tauwoyaidi maudoidi yo magai babadadiyao yodi hineli se ginauli bena kabo idohagi na Yesu se mosegabaei se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ede se pai na se woyai se lau na se moselaei Gabana Pilato unai. ");
INSERT INTO sbe_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Huyana ne unai Yesu kana tauwalohai Yudasi ye kita meta Yesu kabo se unuhemwaloi, ede ye nuwakuhali na moni siluba badona 30 wa ye moseꞌuyoidi taukaitalasam tauwoyaidi yo magai babadadiyao wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na ye wane, “Mamohoi, laupwano ya ginauli, matawuwuna ede tamowai ta nige kana mata hesau na kana ya walohai.” Se hededelau unai se wane, “Nige ka modeigo, temeta kowa yom pilipili.” ");
INSERT INTO sbe_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Unai Yudasi moni wa ye tuusaedi Numa Tabuna kalona wa unai na ye dalahai ye lau ede ye gadosoha. ");
INSERT INTO sbe_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Taukaitalasam tauwoyaidi moni wa se haidi na se wane, “Yoda laugagayo unai ye hedede meta nige gonowana moni ta ta usaidi moni kabatoledi unai, matawuwuna ede moni ta tamowai kwasinana maisana.” ");
INSERT INTO sbe_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Se koitalaliu na moni wa se hai ede walata taulaulauginauli yona tano se hemaisa na ye hemala laolaoma tamowaidiyao yodi bwayabwaya. ");
INSERT INTO sbe_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tenem debanaena ede huyana ne unai na ye laoma ee teina mayadai ta meta tano wa hesana se tole ede Kwasina Tanona. ");
INSERT INTO sbe_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ede Peloweta Yelemaiya yona hedehedede wa ye laoma ye mamohoi, ye wane, “Moni siluba badona 30 Isalaela tamowaidiyao se talamyei tamowai maisana, ");
INSERT INTO sbe_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","se hai na walata taulaulauginauli yona tano se hemaisa. Saha se ginauli ta unai meta Yaubada saha ye hedede kaliguwai wa ye laoma ye mamohoi.” ");
INSERT INTO sbe_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu se woyalaei Gabana Pilato unai na ye henamaiyei ye wane, “Kowa Dius yodi wasawasa?” Ede Yesu ye wane, “Aa, saha ku hedede ne mamohoi.” ");
INSERT INTO sbe_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na kabo taukaitalasam tauwoyaidi yo magai babadadiyao yodi hedehedede udiyedi se hegilukaliliyei, na iyamo nige saha hesau ye hedede. ");
INSERT INTO sbe_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na Pilato Yesu ye henamaiyei ye wane, “Teina kam hedehedede maudoidi ta ku lapuidi, o nige?” ");
INSERT INTO sbe_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na iyamo Yesu nige saha hesau ye hedede, unai Pilato ye siliyata yo ye nokokalili. ");
INSERT INTO sbe_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na bolimai kesega kesega, Taukiuli Henuwaisinina unai, gabana yona kabikabi meta numatutuguduyena taumiya tamowaina hesau kabo Dius tamowaidiyao se kaisunuwai na ye yailigabaei. ");
INSERT INTO sbe_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tenem huyana ne unai wasalaulau tamowaina hesau hesana Balabasi numatutuguduyena ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na huyana boda wa se laomagogoi ede Pilato ye henamaiyeidi ye wane, “Kaiteya tamowai kwa henuwa kabo ya yailigabaei, Balabasi o Yesu, iya hesana kwa katai ede Keliso?” ");
INSERT INTO sbe_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Matawuwuna Pilato kabina ye kata meta kaikalomagigili debanaena na Yesu se moselaei iya kalinawai. ");
INSERT INTO sbe_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na Pilato tauhelauhetala yona kabatuli unai ye tutuli na mwanena wasa ye hetamalilaei unai ye wane, “Tamowai me nige kana gilu hesau, unai tabu saha hesau ku ginauli kalinawai. Matawuwuna boni iya ya kenosuwaiyei, na kenosuwaigu wa unai ya matausikalili.” ");
INSERT INTO sbe_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na taukaitalasam tauwoyaidi yo magai babadadiyao bodadi wa se nuwakoidi na se kaibwada Pilato unai taba Balabasi ye yailigabaei na Yesu se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na Gabana boda maudoidi wa ye henamaiyeidi ye wane, “Teina taudi labui ta, kaiteya kwa henuwa kabo ya yailigabaei?” Ede se wane, “Balabasi.” ");
INSERT INTO sbe_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ede Pilato ye henamaiyeidi ye wane, “Na saha kabo ya ginauli Yesu unai, iya hesana hesau ede Keliso?” Na boda wa se yogasae se wane, “Ku hesataulo.” ");
INSERT INTO sbe_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ye henamaiyeidi ye wane, “Kana mata saha, o yababa saha ye ginauli?” Na boda wa ma kalinalakilakidi se wane, “Ku hesataulo.” ");
INSERT INTO sbe_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na Pilato ye nuwatulobai meta nige gonowana dudulai hesau ye lobai, na boda wa se hetubu se hetalagegagega. Unai waila gaebana ye hai na boda wa matadiyena ye nimadeuli na ye wane, “Tamowai ta kwasinana giluna meta yau nige kagu gilu. Na polohena maudoina meta komiu kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na boda wa se wane, “Kwasinana giluna meta kai ma natumaiyao kewamaiyena.” ");
INSERT INTO sbe_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ede Pilato Balabasi ye yailigabaei na ye hededelau tauꞌiyala tamowaina hesau wipiyena Yesu ye pidili na kabo se laei bena se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na kabo gabana wa yona iyala tamowaidiyao Yesu se hai se laei yodi kabamiya numana lakilakina unai. Kabo tauꞌiyala bodana maudoina se yogagogoidima na Yesu se tolohetakikili. ");
INSERT INTO sbe_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kana kwama se haigabaeidi na wasawasa kwamana pulupululuna se heluwui. ");
INSERT INTO sbe_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na kabo kaiwa gwaligwalina laganao se heidi doha kolona na se tolesaei kuluna ne unai, yo kaikaiwa se mosei nimatutuna ne unai ye kabi, na se tulibono matanaena na se talatalawasiyei se wane, “Yauwedo, Dius yodi wasawasa!” ");
INSERT INTO sbe_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yo hinage se kaikaisoi na kaikaiwa wa se hai na kuluna wa unai se koikoiyei. ");
INSERT INTO sbe_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Se talatalawasiyei ye gehe, kabo kwama pulupululuna wa se haigabaei na iya kana kwama wa se heluwuiꞌuyoi. Na kabo se woyalaei bena se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yelusalema bena kabo se pesagabaei na Sailini tamowaina hesau hesana Simona se lobai, na se lauhelili ede Yesu yona sataulo wa ye bahei. ");
INSERT INTO sbe_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Se lau magai hesau hesana Golagota unai se lage. Golagota kaniyona ede mwayalu magaina. ");
INSERT INTO sbe_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Temenai waina yo mulamula nisanisana se hebwali na se mosei Yesu bena ye numa. Na ye numatonogi ede nige ye henuwa ye numa. ");
INSERT INTO sbe_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na kabo Yesu se hesataulo, na mulina ne unai kana kwama wa se kaiheyaidi na se soiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kabotaki se tuligogoi na Yesu se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kabahegiluna hedehededena se kuli molumolu hesau unai na kulubawana ne unai se tutuhepatu, ye wane, “TEINA TA YESU, DIUS YODI WASAWASA.” ");
INSERT INTO sbe_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Laulau yabayababadi tauginaginaulidi labui maidanao se hesataulodi, hesau tehatutuna unai na hesau tehaseuseulina ne unai. ");
INSERT INTO sbe_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tamowai se sae se dobi meta se kulukulukwade na se hagahagasiyei yo se wane, ");
INSERT INTO sbe_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Kowa Numa Tabuna bena ku hetatagwaligwali na mayadai haiyona unai kabo ku kabiꞌuyoi, hage, ku hemauliꞌuyoigo. Ena kowa Yaubada Natuna, sataulo ne unai ku pesadobima!” ");
INSERT INTO sbe_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Taukaitalasam tauwoyaidi, laugagayo taulauhekataedi, yo magai babadadiyao hinage hedehedede wa kesekesegana unai se hagahagasiyei. ");
INSERT INTO sbe_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Se wane, “Tamowai hekadiyo ye saguidi na nige gonowana iya ye bom ye saguiꞌuyoi. Na ye hedede bena iya kita Isalaela yoda wasawasa! Taba sataulo ne unai ye pesadobima kabo ka kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yona mauli maudoina unai Yaubada ye sunumaei, na hinage ye wane, ‘Yau Yaubada Natuna.’ Na ena mamohoi Yaubada iya ye gadosisiyei meta taba ye hesaguhai!” ");
INSERT INTO sbe_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na laulau yabayababadi tauginaginaulidi labui wa hinage Yesu se hagahagasiyei. ");
INSERT INTO sbe_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mayamayadailaki unai magai wa maudoina ye masigili ye lau ee meimeilahi awa hehaiyonana unai. ");
INSERT INTO sbe_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tenem mahanana ne unai Yesu ye yoga ma kalinalakilakina ye wane, “Eloi, eloi, lama sabatani?” Kaniyona ede, “Yogu Yaubada, yogu Yaubada, idohagi to ku nuwagabaeigau ta?” ");
INSERT INTO sbe_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na temenai tautotolo hekadiyo kalinana wa se lapui ede se wane, “Eliya ye yogayoganei.” ");
INSERT INTO sbe_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dedekana ne unai tautotolo wa yona hedehedede ta se lapupwanoli, ede hesau ye heloi ye lau balo ye hai, ye hedakwa winega unai na ye paihepatu kaikaiwa hesau unai na ye helelesaei Yesu bena ye numa. ");
INSERT INTO sbe_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na maudoidi wa se wane, “Ku laugabaei! Hage ta kita, kabo Eliya ye laoma ye sagui?” ");
INSERT INTO sbe_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kabo Yesu ye yogaꞌuyo ma kalinalakilakina, na yawasina ye mosegabaei. ");
INSERT INTO sbe_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tenem mahanana ne unai meta Numa Tabuna woyona kalekona ye taigalilabuiyei kewa unai ye dobi guni, yo tano ye tabutabubu yo weku se taigali. ");
INSERT INTO sbe_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bwayabwaya se tasoke na Yaubada yona tamowai se boitako wa meta se bado se toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kadi bwayabwaya se pesagabaeidi na Yesu yona toloꞌuyo mulina ne unai se lusae Yelusalema na se taumasalaha tamowai gwaudi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Huyana iyala taubagunaena tamowaina yo yona tauꞌiyala maidanao Yesu se kitakitahetete wa mwanikuniku yo ginauli saha se tubu wa se kitadi ede se matausikalili na se wane, “Mamohoi, iya Yaubada Natuna!” ");
INSERT INTO sbe_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sinesinebadao bodana kedalohalohawai se totolo na se kaikaikewa. Siya ede sinesineo maiyadi Yesu Galili unai se laoma wa, na yona paisowa ne unai saha udiyedi ye deha, kabo udiyedi se sagui. ");
INSERT INTO sbe_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bodadi wa unai meta Maliya Magadala waihiuna, yo Maliya Yamesi yo Yosepa sinadi, yo hinage Sebedaiyo natunao sinadi. ");
INSERT INTO sbe_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ye hetubu ye meimeilahi ede Yosepa Alimatiya tamowaina, iya tau gogogogona yo Yesu tauhemuliwatanina hesau, ");
INSERT INTO sbe_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ye lau Pilato ye kaibwadai taba Yesu sinalena ye hai na ye tole bwayabwayaena. Ede Pilato ye hedede na sinale wa se mosei Yosepa unai. ");
INSERT INTO sbe_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ede Yosepa sinale wa ye hai na kaleko posiposina hauhauna unai ye suma, ");
INSERT INTO sbe_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na yona bwayabwaya hauhauna weku unai ye salanonohaiyako wa unai ye tole. Na kabo weku lakilakina ye builaei bwayabwaya wa kedana ye buigudui na ye laugabai. ");
INSERT INTO sbe_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bwayabwaya wa tehalauna ne unai Maliya Magadala waihiuna yo Maliya hesauna wa se tutuli na se kaikaikewa. ");
INSERT INTO sbe_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na kabinonoha mayadaina mulina ne unai mala ye tom kabo taukaitalasam tauwoyaidi yo Paliseya tamowaidiyao se lau Pilato unai ");
INSERT INTO sbe_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na se wane, “Tanuwaga, teina taukailupolupo ta yona hedehedede hesau ka nuwatui. Huyana sola ma maumaulina meta ye hedede ye wane, ‘Mayadai haiyona mulidi ne unai kabo ya toloꞌuyo.’ ");
INSERT INTO sbe_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Unai ku hededelau yom tauꞌiyala tamowaidiyao udiyedi bena bwayabwaya ne se kitahetetenamwanamwaei kana siga mayadai hehaiyonana ne unai, madai yona hekahekatao se laoma na sinalena ne se hai se laei na se hededelau tamowai udiyedi meta bena ye toloꞌuyoko. Na yodi kailupolupo mulimulitana ne kabo ye yababakalili na kabo bagubagunana wa.” ");
INSERT INTO sbe_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ede Pilato ye talam ye wane, “Tauꞌiyala tamowaidi kwa haidi na kwa lau bwayabwaya ne se kitahetetenamwanamwaei.” ");
INSERT INTO sbe_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Unai se lau bwayabwaya wa kawamatana buiguduna wa se dedeligudugudui na tauꞌiyala tamowaidiyao se toledi bwayabwaya wa se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabati mayadaina wa ye gehe na mayadaina bagubagunana unai mala ye hetubu ye uyali na Maliya Magadala waihiuna maiyana Maliya hesauna wa se lau bena bwayabwaya wa se lohei. ");
INSERT INTO sbe_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mahanana ne unai meta mwanikuniku lakilakina, na Guiyau yona anelu galewa ne unai ye dobima na bwayabwaya buiguduna wekuna wa ye buihesuwala na kewana ne unai ye tuli. ");
INSERT INTO sbe_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kana kao meta ye namanamali na yona kaleko se posiposikalili. ");
INSERT INTO sbe_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tauꞌiyala tamowaidiyao bwayabwaya se kitakitahetete wa se matausi ede se tabutabubu na se gulidobi doha tauboiboita. ");
INSERT INTO sbe_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anelu wa ye hededelau sinesinebadao wa udiyedi ye wane, “Tabu kwa matausi! Kabina ya kata meta Yesu se hesatauloꞌusei wa kwa wasewasenei. ");
INSERT INTO sbe_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iya nige inai, na Yaubada iya ye hetoloꞌuyoiyako, doha saha ye hededeyako wa. Kwa laoma kabatolena ne kwa kita. ");
INSERT INTO sbe_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na kwa laumwayamwayau na kwa hededehemasalaha yona hekahekatao udiyedi meta iya boita unai ye toloꞌuyoko, na kabo ye baguna ye lau Galili na menai kabo iya kwa kita. Teina yomi wasa ya haiyawa ede.” ");
INSERT INTO sbe_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ede sinesinebadao wa se lau ma matamatausidi na iyamo ma gwaugwauyaladi, na se heloi se lau bena anelu yona wasa wa se hededegabaei hekahekatao wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Se laulau na kamwasa wa unai Yesu ye hailobaidi na ye lautokiyedi ye wane, “Yauwedo!” Ede se laoma iya unai, se tulibonodobi, se kabilau kaena wa udiyedi na se tabaꞌohui. ");
INSERT INTO sbe_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kabo Yesu ye hededelau udiyedi ye wane, “Tabu kwa matausi! Na kwa lau kwa hededelau kagu kahao ne udiyedi na se lau Galili, kabo menai se kitagau.” ");
INSERT INTO sbe_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sinesinebadao wa sola ma laudi na tauꞌiyala bwayabwaya taukitahetetena wa hekadi se baguna se lau Yelusalema na saha yo saha se tubu wa taukaitalasam tauwoyaidi yodi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ede taukaitalasam tauwoyaidi yo magai babadadiyao se laomagogoi se koitalaliu ede tauꞌiyala tamowaidiyao wa monilakilaki unai se hemaisadi ");
INSERT INTO sbe_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na se hededelau udiyedi se wane, “Kabo kwa hedede kwa wane, ‘Boniyaiyena ka kenoko na yona hekahekatao wa se laoma ede Yesu sinalena wa se kaiwahali se laei.’ ");
INSERT INTO sbe_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ena teina wasa ta Gabana ye lapui kabo ka lausabilauyeigomiu na taba nige ye hekamkamnagomiu.” ");
INSERT INTO sbe_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Unai tauꞌiyala tamowaidiyao wa moni wa se hai na hedehedede saha unai se guguyaidi wa se hededewatanidi. Na teina wasalupolupo ta ye lau Dius tamowaidiyao maudoidi udiyedi, na teina mayadai ta unai sola se hedehededei. ");
INSERT INTO sbe_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na kabo Yesu yona hekahekatao saudoudoi-kesega wa se lau Galili, na kuduli Yesu ye hedede wa se lau unai. ");
INSERT INTO sbe_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Menai se kita ede se tabaꞌohui, na iyamo hekadi se nuwalabulabui. ");
INSERT INTO sbe_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ye laoma udiyedi na ye wane, “Gigibwali maudoina galewa yo tanoubu ta unai meta Tamagu ye haidimako kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Unai kwa lau basileiya maudoidi udiyedi tamowai kwa guguyaidi na se hemala yogu hekahekatao. Kwa hebabatisoidi Tamana, Natuna yo Yaluwa Tabuna hesadiyena, ");
INSERT INTO sbe_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","yo ginauli maudoidi ya hedehededeidi kalimiuyena wa bena kwa hekatadi na se miyawatanidi. Na mamohoikalili, yau kabo huya maudoina maidamiu, ye lau ee tanoubu ta yona huyagehe.” ");
INSERT INTO sbe_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Keliso Yaubada Natuna wasana namwanamwana ye hetubu doha teina: ");
INSERT INTO sbe_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yaubada yona hedehedede wa Aisaiya peloweta yona buka unai, ye wane, “Kabo yogu tautauwasa ya hetamali bena ye kedabagunaego. Iya kabo yom keda ye kabinonohai.” ");
INSERT INTO sbe_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Tamowai hesau balabala unai ye yogayoga ye wane, ‘Guiyau yona keda kwa kabinonohai, yo yona kabalau kwa hedudulai!’” ");
INSERT INTO sbe_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Unai Yowane ye laoma. Balabala unai ye miyamiya na ye hebahebabatiso. Ye laulauguguya bena tamowai se nuwabui na babatiso se hai, yodi yababa nuwatugabaedi hesabana. ");
INSERT INTO sbe_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Teha Yudeya yo magai Yelusalema udiyedi taumiya maudoidi se lau iya unai. Yodi yababa se hededehemasalahadi na Yolidani sagasagana unai ye hebabatisoidi. ");
INSERT INTO sbe_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowane kana kwama kamela wiyana unai se ginauli na kana dagilolo meta suisui dahina. Na kana kai meta mwadimwadi yo kamwakamwa. ");
INSERT INTO sbe_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ye hededehemasalaha ye wane, “Tamowai hesau kabo ye mulitama. Iya ye saekalili na kabo yau. Na nige gonowagu taba ya dunedobi iya kana sendolo mainadi ya yailidi. ");
INSERT INTO sbe_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau waila unai ya hebabatisoigomiu, na iya kabo Yaluwa Tabuna unai ye hebabatisoigomiu.” ");
INSERT INTO sbe_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tenem huyana ne unai Yesu teha Galili magaina hesau hesana Nasaleta unai ye laoma ede Yowane ye hebabatisoi Yolidani sagasagana unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Waila wa unai ye gayo ye sae na ye kitasae ede galewa ye kita ye taigali, na Yaluwa Tabuna kana kao doha bunebune ye dobima iya kewana ne unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na kalina hesau galewa ne unai ye laoma na ye wane, “Kowa Natugu! Ya gadosisikaliliyeigo, yo nuwagu ku henamwakaliliyei!” ");
INSERT INTO sbe_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mahanana ne unai Yaluwa Tabuna Yesu ye hetamali ye lau balabala unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mayadai 40 balabala unai suisui kaikaikalasidi luwadiyena ye miya. Na Satani Yesu ye laukita, na kabo anelu iya se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Huya hesau Heloda wasawasa Yowane ye gudui numatutugudu unai. Kabotaki Yesu ye lau Galili na Yaubada wasana namwanamwana ye lauguguyaei, ");
INSERT INTO sbe_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ye wane, “Huyana ye lagemako, Yaubada yona basileiya ye hanahanaumako. Nuwamiu kwa buidi yo wasa namwanamwana ta kwa kawamamohoiyei.” ");
INSERT INTO sbe_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Huya hesau Yesu Galili Gabwana dedekana wa unai ye yona ye laulau ede tauyamayama labui ye kitadi, Simona ma kana kaha Andeleya, yodi hinaya unai se yamayama. ");
INSERT INTO sbe_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na kabo ye yoganeidi ye wane, “Kwa saema kwa hemuliwatanigau, na kabo ya hekatagomiu tamowai tauyamayamaidi.” ");
INSERT INTO sbe_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na mahanana ne unai yodi hinaya wa se laugabaeidi na Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ye taulau na kabo Sebedaiyo natunao labui Yowane yo Yamesi ye kitadi yodi waga unai yodi hinaya se polapolaidi. ");
INSERT INTO sbe_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na ye yogalau yodi labui wa udiyedi ede waga wa se pesagabaei na tamadi Sebedaiyo ma kana hewahewaliyo se laugabaeidi na Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kabo Yesu yona hekahekatao maiyanao se lau se lage Kapelenauma unai, na kabo Sabati unai ye mwalaesae sunago unai na ye hetubu ye lauhekata. ");
INSERT INTO sbe_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yona lauhekata wa se nokoei, matawuwuna ye hededehasahasaidi ma gigibwalina, nige doha laugagayo taulauhekataena tamowaidi. ");
INSERT INTO sbe_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yodi sunago wa kalonawai tamowai hesau yaluwa bikibikina iya ye luwui na ye yogayoga ");
INSERT INTO sbe_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ye wane, “Saha ku henuwa kalimaiyena, Yesu Nasaleta tamowaina? Ku laoma bena ku heyababagai? Kabim ya kata kowa kaiteya: Kowa Tabuna Yaubada unai ku laoma.” ");
INSERT INTO sbe_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na Yesu ye hededebayao iya unai ye wane, “Ku mwanou na tamowai me ku pesagabaei!” ");
INSERT INTO sbe_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yaluwa bikibikina wa tamowai wa ye nukui na ye yogahi yo ye pesagabaei. ");
INSERT INTO sbe_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Siya maudoidi se noko na se henahenamaiꞌuyoidi se wane, “Teina ta saha? Teina ta meta lauhekata hauhauna yo ma gigibwalina! Ye hededelau yaluwa bikibikidi udiyedi, na se kawakabiyei!” ");
INSERT INTO sbe_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nige bayaona iya wasana ye lau Galili maudoina ye hetakikili. ");
INSERT INTO sbe_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sunago wa unai se pesa se lau Simona ma kana kaha Andeleya yodi numa unai se mwalae, Yamesi yo Yowane maiyadiyao. ");
INSERT INTO sbe_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona bwasiyana sinebada tauna se gwagwama yo ye kasiyebwa na ye kenokeno, na wasana se hededelau Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ede ye laoma na ye kabilau nimana unai na ye kabihetolo. Na sinebada wa ye namwanamwa, ede ye tolo na ye haitalaidi. ");
INSERT INTO sbe_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mahana wa ye dui kabo taukasikasiyebwa gwaudi yo hinage tamowai yaluwa yabayababadi siya se luwuidi wa se woyaidima Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Magai tamowaidiyao bodalakilaki se lagegogoi numa kawamatana wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tamowai kadi kasiyebwa udoiꞌudoi ye henamwanamwadi. Yo yaluwa yabayababadi gwaudi ye hededehepesadi na ye hededehekaiyawasidi tabu se hedehedede, matawuwuna ede iya kabina se katako. ");
INSERT INTO sbe_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Malatomtom gagilina, huyana sola ma masimasigilina, na Yesu numa wa ye laugabaei na ye lau balabala hesau unai ye tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na Simona ma kana kahao se lau iya se wasenei. ");
INSERT INTO sbe_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yesu se lobai ede se hededelau unai se wane, “Tamowai maudoidi se wasewaseneigo!” ");
INSERT INTO sbe_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Na ye hededelau udiyedi ye wane, “Taba ta lau magai hekadiyo udiyedi hinage ya lauguguya, matawuwuna teina hesabana ede ya laoma ta.” ");
INSERT INTO sbe_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galili se tauhetakikili na Yesu ye lauguguya sunago udiyedi, yo hinage yaluwa yabayababadi ye hededehepesadi. ");
INSERT INTO sbe_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na temenai tamowai hesau kana kasiyebwa meta lepela. Ye laoma Yesu unai ye tulibono na ye kaibwadakatekamkamna ye wane, “Ena ku henuwa, kabo gonowana ku heꞌaꞌagau.” ");
INSERT INTO sbe_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu tamowai wa ye katekamkamnaei na nimana ye helelelaei ye kabilau unai, na ye hededelau unai ye wane, “Ya henuwa, ku aꞌa.” ");
INSERT INTO sbe_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na mahanana ne unai kasiyebwa lepela wa ye ulugehe na tamowai wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kabo Yesu ye hededebayao iya unai ye wane, ");
INSERT INTO sbe_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tabu tamowai hesau yona ku hedehedede. Na ku lau taukaitalasam unai ku hemasalahago na ye kitasipwaigo. Na kabo heꞌaꞌa kaitalasamdi Mose ye hedede wa ku ginaulidi, na kabo tamowai se kitalobai meta ku namwanamwako.” ");
INSERT INTO sbe_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Na tamowai wa ye pesa ede ye lau wasana wa ye hededehemasalaha yo ye helaki. Unai Yesu nige gonowana ye taumasalaha magai udiyedi, na balabalagaibu udiyedi ye miya. Na teha maudoina tamowaidi se laoma iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mayadai hisa se lau, na kabo Yesu ye uyo Kapelenauma. Wasana se lapui ede ");
INSERT INTO sbe_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tamowai gwaudi se laoma Yesu yona kabamiya unai. Na numa wa nige solasolana hesau, gonogonowana doha hinage dagela ne. Na Yesu Yaubada wasana ye lauguguyai udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na tamowai hasi se laoma taubunibuni hesau se baheiyama Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Boda ye lakikalili to nige gonowana se sae Yesu unai. Ede gatowa se bolilapai na taubunibuni wa ma diyadiyalina se hedalolodobiyei Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu tamowai wa yodi sunuma ye kita, unai ye hededelau taubunibuni wa unai ye wane, “Natugu, yom yababa ya nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na laugagayo taulauhekataena hekadiyo se tutuli temenai na se bom se nuwanuwatu se wane, ");
INSERT INTO sbe_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tamowai ne tabu tenem doha ye hedehedede! Yaubada ye hededeheyaheyababa! Yaubada ye bom mo gonowana yababa ye nuwatugabaeidi!” ");
INSERT INTO sbe_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na Yesu saha se nuwanuwatui wa kabina ye kata, unai ye hededelau udiyedi ye wane, “Idohagi na teina nuwanuwatu ta nuwamiu ne udiyedi kwa nuwanuwatuidi? ");
INSERT INTO sbe_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hedehedede sahasahana ye biga kabo ya hedede taubunibuni ta unai, ya wane, ‘Yom yababa ya nuwatugabaeidi’, o ya wane, ‘Yom dam ku bahei na ku laulau’? ");
INSERT INTO sbe_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ya henuwa bena kwa nuwatulobai meta Tau Natuna yona gigibwali kaiyaulina ta unai meta gonowana yababa ye nuwatugabaedi.” Na ye hededelau taubunibuni wa unai ye wane, ");
INSERT INTO sbe_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ku tolo, yom dam ne ku bahei na ku lau yom numa.” ");
INSERT INTO sbe_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mahanana ne unai ye tolo na yona dam wa ye bahei na maudoidi matadiyena ye dalahai ye lau. Ede maudoidi wa se nokoei yo Yaubada se hedebasaei se wane, “Teina laulau ta sola nige huya hesau ta kita!” ");
INSERT INTO sbe_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ye uyo Galili Gabwana dedekana unai, na bodalakilaki se lagegogoma iya unai, na ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ye gehe na ye taulau ede Lewi Alepaiya natuna ye kita ye tutuli takisi kabatanotano numana unai. Kabo ye hededelau iya unai ye wane, “Ku hemuliwatanigau!” Ede Lewi ye tolo na Yesu ye hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kabotaki Yesu maiyana hekahekatao se kaikai Lewi yona numa unai. Na takisi tautanotano yo yababa tamowaidi gwaudi Yesu se hemuliwatani wa maiyanao se kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Laugagayo taulauhekataena tamowaidi hekadiyo, siya Paliseya tamowaidi, Yesu se kita yababa tamowaidi yo takisi tautanotano ne maiyadi se kaikaigogo, na se hededelau yona hekahekatao udiyedi se wane, “Iya idohagi to takisi tautanotano yo yababa tamowaidiyao maidanao se kaikaigogoi?” ");
INSERT INTO sbe_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu yodi hedehedede wa ye lapui na ye hededelau udiyedi ye wane, “Tamowai namwanamwadi doketa nige se nuwatuidi, na tamowai kasikasiyebwadi mo. Yau ya laoma nige tamowai yodi miyamiya dudulaidi hesabadi, na yababa tamowaidi bena ya yogaisinidi.” ");
INSERT INTO sbe_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Huya hesau Yowane Babatiso yona hekahekatao yo Paliseya yodi hekahekatao se kaihudi. Mayadaina ne unai tamowai hekadiyo se laoma Yesu unai se wane, “Yowane yona hekahekatao yo Paliseya yodi hekahekatao se kaikaihudi. Na kowa yom hekahekatao idohagi to nige se kaihudi?” ");
INSERT INTO sbe_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ye henamaiyeidi ye wane, “Huyana tautawasolahauhau ma kana taumanao se miyamiya, kabo se kaihudi e nige? Nige! Huyana ne unai taba nige se kaihudi. ");
INSERT INTO sbe_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na mayadaina kabo ye lagema, iya kabo se laehesuwala. Tenem mayadaina ne unai kehanao kabo se kaihudi. ");
INSERT INTO sbe_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nige gonowana tamowai hesau kaleko hauhauna tupwana ye hai na kwama beyabeyana tapulisina unai ye polai. Taba tenemdohagi ye polai, kabo kaleko hauhauna ne kwama beyabeyana ye tabepulisi na tapulisina wa kabo ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hinage nige tamowai hesau waina hauhauna ye ini waina pakuna beyabeyana kalona unai. Taba doha temeta, waina hauhauna kabo waina pakuna ye hesese na ye tapulisi, yo waina wa ye bwalili. Na waina hauhauna mo ye ini waina pakuna hauhauna ne unai.” ");
INSERT INTO sbe_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati mayadaina hesau unai Yesu maiyana hekahekatao witi koyana hesau se tauduwaduwali se lau, na yona hekahekatao wa ma laulaudi na se hetubu witi kaniyodi se huhudi. ");
INSERT INTO sbe_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kabo Paliseya tamowaidi se hededelau Yesu unai se wane, “Ku kita ne! Idohagi to mayadai Sabati laugagayona se utusi?” ");
INSERT INTO sbe_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na ye hededelau udiyedi ye wane, “Huyana Dawida ma kana hewahewaliyo se hasali na saha ye ginauli wa wasana kwa hasili o nige? ");
INSERT INTO sbe_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyata iya taukaitalasam saesaena, na yona huya unai Dawida ye lusae Yaubada yona Logulogu Tabuna unai pwalawa hetahetabudi wa ye kaidi, na hekadi hinage ye moseidi kana kahao se kaidi. Tenem pwalawa ne meta kai tabuna, na nige tamowai hesau yona dudulai bena ye kai, na taukaitalasam se bom mo kabo se kai.” ");
INSERT INTO sbe_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kabo ye wane, “Yaubada Sabati ye ginauli tamowai yodi namwanamwa hesabana. Tamowai nige Sabati yona. ");
INSERT INTO sbe_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Unai Tau Natuna iya Sabati guiyauna ede.” ");
INSERT INTO sbe_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabati hesau Yesu ye mwalaesae sunago unai, na tamowai hesau nimana basabasana temenai. ");
INSERT INTO sbe_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Paliseya tamowaidiyao hekadi Yesu kana mata se wasenei, unai iya se kitasipwainamwanamwaei, kabo Sabati unai tamowai ne ye henamwanamwa e nige. Ena ye henamwanamwa, kabo unai se hegilu. ");
INSERT INTO sbe_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kabo Yesu ye hededelau tamowai nimabasabasana wa unai ye wane, “Ku toloma tamowai matadiyena.” ");
INSERT INTO sbe_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na ye henamaiyeidi ye wane, “Laulau saha ye namwa ede mayadai Sabati unai: namwa ta ginauli o yababa, ta kabihenamwanamwa o ta kaiunu?” Maudoidi wa se mwanouhai. ");
INSERT INTO sbe_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ye kitahetakikilidi, na ye kouyalayala yo nuwana ye yababa, matawuwuna ede se nuwakwailolokalili. Na ye hededelau tamowai wa unai ye wane, “Nimam ku tuuhedudulai.” Kabo nimana wa ye tuuhedudulai, ede ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na mahanana ne unai kabo Paliseya tamowaidi se lau Heloda kana bodao maiyadiyao se koitalaliu idohagi Yesu bena kabo se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na kabo Yesu maiyana hekahekatao se dalahai se lau Galili Gabwana unai, na Galili yo Yudeya tamowaidi gwaudi se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yesu saha ye ginauli wa wasana se lapui meta bodalakilaki teha Yudeya yo Yelusalema yo Idumeya yo Yolidani teha kaluwabu udiyedi yo hinage Taiya yo Sidona magaidi udiyedi se laoma iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Boda ye lakikalili unai madai Yesu se dudukahalai, ede Yesu ye hededelau yona hekahekatao udiyedi bena waga gagilina se kabinonohai, unai bena kabo ye gelu. ");
INSERT INTO sbe_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na taukasiyebwa gwaudi ye henamwanamwadiko, unai kabo tamowai kasikasiyebwadi maudoidi se dudu se lau bena se kabilau Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na tamowai yaluwa bikibikidi kalidiyena wa iya se kita ede se gulidobi talanuwana unai, na yaluwa bikibikidi wa se yogayoga se wane, “Kowa Yaubada Natuna ede!” ");
INSERT INTO sbe_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Na Yesu ye guguyaidi tabu se hededehemasalaha iya kaiteya. ");
INSERT INTO sbe_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ye sae kuduli hesau unai. Temenai kaiteyadi ye henuwadi wa ye yoganeidi na se laoma iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na saudoudoi-labui ye kaisunuwaidi na ye kataidi apostolo. Bena maiyanao se miya, yo bena kabo ye hetamalidi se lau se lauguguya. ");
INSERT INTO sbe_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na gigibwali ye mosei siya udiyedi, kabo bena yaluwa yabayababadi se hededehepesadi. ");
INSERT INTO sbe_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Teina saudoudoi-labui ye yoganeidi wa hesadi ede: Simona, hesana hesau ye tole Petelo, ");
INSERT INTO sbe_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yamesi ma kana kaha Yowane, Sebedaiyo natunao, hesadi ye tole Bowanele, meta kaniyona ede tulutululu natunao, ");
INSERT INTO sbe_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","yo Andeleya, Pilipo, Batolomaiyo, Mataiyo, Tomasi, Yamesi Alepaiya natuna, Tadaiyo, Simona Tauhaikabi, ");
INSERT INTO sbe_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yo Yudasi Isakaliyota, iya ede Yesu kana tauwalohai. ");
INSERT INTO sbe_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kabo Yesu ye mwalaesae numa hesau kalona unai, na hinage bodalakilaki se lagegogoma. Na iya maiyana hekahekatao nige yodi solasola bena se kaikai. ");
INSERT INTO sbe_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na Yesu kehanao wasana se lapui meta Yesu nige ye kaikai, unai se lau iya bena se woyahai, matawuwuna ede se nuwatui se wane, “Iya bena ye bwadebwade!” ");
INSERT INTO sbe_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Laugagayo taulauhekataena hekadi Yelusalema unai se dobima se wane, “Belesebulu iya ye tanuwagai! Yaluwa yabayababadi ye hededehepesadi kadi tanuwaga yona gigibwaliyena.” ");
INSERT INTO sbe_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu ye yoganeidi na heyaheyasoni hekadi ye hedededi kalidiwai, ye wane, “Satani kabo idohagi na Satani ye hededehepesa? ");
INSERT INTO sbe_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Taba basileiya kesega se haitoledagela, kabo basileiya ne nige gonowana ye tolobayao. ");
INSERT INTO sbe_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Taba numa hesau tamowaidiyao se haitoledagela, kabo numa ne nige gonowana se tolobayao. ");
INSERT INTO sbe_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Taba Satani yona taupaisowa yaluwa yabayababadi ye hewaiunudi, kabo nige gonowana ye tolobayao, na ye kaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nige gonowana tamowai hesau ye mwalae tamowai yasiyasiyalana yona numa unai yona gogo ye haidi. Tamowai yasiyasiyalana wa taba ye paibagunai, na kabo yona numa gogodi ye haidi. ");
INSERT INTO sbe_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya hededemamohoi: Yababa maudoidi yo Yaubada hededeyababaina Yaubada kabo ye nuwatugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na taba tamowai hesau Yaluwa Tabuna ye hededeheyababa, kabo yona yababa wa taba nige ye nuwatugabaei. Kana gilu kabo ye bawahai ye lau ee nige kana siga.” ");
INSERT INTO sbe_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu yona hedehedede ta matawuwuna ede se wane, “Yaluwa bikibikina ye luwu iya unai.” ");
INSERT INTO sbe_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na Yesu sinana yo kana kahao se lagema dagela wa unai se totolo, na tamowai hesau se hetamali ye sae bena ye woihai. ");
INSERT INTO sbe_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Boda Yesu se tulihetakikili wa se hededelau iya unai se wane, “Sinam yo kam kahao yo loumwao, siya ede dagela ne unai na se henuwago.” ");
INSERT INTO sbe_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na ye henamai ye wane, “Sinagu kaiteya? Yo kagu kahao kaiteyadi?” ");
INSERT INTO sbe_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tamowai iya se tulihetakikili wa ye kaikewaidi na ye wane, “Sinagu yo kagu kahao ede teina! ");
INSERT INTO sbe_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaiteya Yaubada yona nuwatu ye ginauliwatani meta iya kagu kaha ede, lougu ede, yo sinagu ede.” ");
INSERT INTO sbe_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na Yesu ye uyo Galili Gabwana dedekana unai na ye lauhekata. Bodalakilaki se lagegogoma iya unai, ede Yesu waga hesau unai ye gelu, na ye kahaisuwala musamusana, na boda wa nagali unai se totolo. ");
INSERT INTO sbe_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na kabo ginauli gwaudi ye hekatadi heyaheyasoni udiyedi. Yona lauhekata wa unai ye wane, ");
INSERT INTO sbe_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kwa lapulapui! Tamowai hesau ye lau yona koya, bena witi likena tumadiyao ye hesuludi. ");
INSERT INTO sbe_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na ye hesuhesulu ede hekadi se bekudobi keda kalonawai, na manuwa se laoma ede se kaidi. ");
INSERT INTO sbe_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Hekadi se bekudobi tano maladebadebanawai na nige bayaona se kini. Na mahana ye dalasae ede ye sinahewowoyadi, matawuwuna bwatano ye yaloyalo na lamdi nige se dobikalili. ");
INSERT INTO sbe_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hekadi se bekudobi gwaligwali luwadiwai. Gwaligwali kabo se kinipuluhidi, ede tuma wa nige se kininamwanamwa, unai nige se kaniyo. ");
INSERT INTO sbe_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tuma hekadi hinage se bekudobi bwatano namwanamwana unai, na se kini yo se kaniyo: Witi kewa kesega kesega hekadi kaniyodi badodi 30, 60 o 100.” ");
INSERT INTO sbe_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na Yesu ye hededelau udiyedi ye wane, “Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Boda wa se tatagwaligwali, na mulina ne unai yona hekahekatao saudoudoi-labui yo tamowai hekadiyo Yesu maiyanao se tuligogoi, na palabole kaniyona se henamaiyei iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na Yesu ye hededelau udiyedi ye wane, “Yaubada yona basileiya nuwanuwatuna saesaedi kabo ya hemasalahadi kalimiuwai. Na kaiteya Yaubada yona basileiya dagelanawai, kabo palabole mo udiyedi ya hekatadi, ");
INSERT INTO sbe_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","to bena ‘se kitakita, na taba nige se kitalobai, se lapulapui, na taba nige se lapulobai, madai nuwadi se buidi, na Yaubada yodi yababa kabo ye nuwatugabaeidi.’” ");
INSERT INTO sbe_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na Yesu ye hededelau udiyedi ye wane, “Ena palabole ta nige kwa nuwatulobai, kabo idohagi na palabole hekadi ne bena kwa nuwatulobaidi? ");
INSERT INTO sbe_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tuma tauhesuhesulu meta Yaubada wasana ye hesulu. ");
INSERT INTO sbe_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tamowai hekadi nuwadi kadi kao doha keda kalona tuma se bekudobi unai. Yaubada yona hedehedede se lapui, na mahanana ne unai Satani ye laoma ede hedehedede wa ye haigabaei. ");
INSERT INTO sbe_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tamowai hekadi nuwadi doha maladebadeba tuma se bekudobi unai. Hedehedede wa se lapui yo se hai ma nuwanamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na hedehedede wa nige ye dobi nuwadi ne udiyedi, unai ede yodi sunuma se basabasa. Na huyana pilipili yo hewahewaiunu se hekalo yogu hedehedede ta debanawai, meta se nuwagwagwama na se lausuwala. ");
INSERT INTO sbe_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tamowai hekadi nuwadi doha gwaligwali tuma se bekudobi udiyedi. Siya hedehedede wa se lapuimoei. ");
INSERT INTO sbe_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Na kaiyaulina ta nuwamodemodena yo gogobadobado nuwadi se kaidi yo ginauli hekadi gadosisidi udiyedi hedehedede wa se kinipuluhidi na nige ye kaniyo. ");
INSERT INTO sbe_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na hekadiyo nuwadi doha bwatano namwanamwana tuma se bekudobi unai. Hedehedede wa se lapui na se kawamamohoiyei, kabo se kaniyo, hekadi 30, 60 o 100.” ");
INSERT INTO sbe_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na Yesu yona hedehedede ye tubei ye wane, “Taba lampa ta gabu, kabo gulewa unai ta buikasini o kabakeno guninaena ta tole? Nige! Ta tolesae kabatolena unai. ");
INSERT INTO sbe_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gonogonowana doha hinage Yaubada yona basileiya ginaulina wadawadamdi maudoidi kabo ye hemasalahadi, yo ginauli maudoidi Yaubada ye toletolewadamdi wa kabo hinage ye tolehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na kabo ye wane, “Saha kwa lapui ta bena kwa lapunamwanamwaeidi. Ena kwa lapulapuinamwanamwa, kabo kwa nuwatulobainamwanamwaei. Na kabo Yaubada yomi sibasiba ye helakidi. ");
INSERT INTO sbe_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaniyona ede kaiteya yogu lauhekata udiyedi ye lapulapuinamwanamwa, kabo yona sibasiba ye helaki. Na kaiteya nige ye lapulapuinamwanamwa, saha gagilina ye lapulobaiyako wa kabo ye nuwaluluhiyei.” ");
INSERT INTO sbe_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na Yesu ye wane, “Yaubada yona basileiya meta doha teina: Tamowai hesau witi tumana ye hesulu yona koya unai. ");
INSERT INTO sbe_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Boniyai huyadi ye keno, na mala ye tom ye tolo, meta nige ye mode na tuma wa se bom se kini kabo se tubu. Tuma yodi kinikini meta tamowai wa nige ye nuwatulobai idohagi. ");
INSERT INTO sbe_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na bwatano ye bom ye hekinidi: se kinibaguna, kabo se kinilakilaki yo se kaniyo. ");
INSERT INTO sbe_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Witi wa kaniyodi se suna, kabo tamowai wa ye bolidi, matawuwuna ede masuli wa ye lage.” ");
INSERT INTO sbe_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ye wane, “Yaubada yona basileiya kana kao kabo idohagi yoda hedehededena? O palabole saha unai kabo ta hekaigonogonowaei? ");
INSERT INTO sbe_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Basileiya ne doha kaiwa hesau tumana ye gagilikalili tuma maudoidi udiyedi. Tumana ta kumai bwatano unai, kabo ye kinilakilaki na kabo koya kaiwadi hekadiyo. Lagana lakilakidi se kini, na manuwa kabo se kabinoi loguloguna ne unai.” ");
INSERT INTO sbe_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yona lauhekata maudoidi udiyedi palabole unai ye hekatadi yodi nuwatulobai gonogonowana unai. ");
INSERT INTO sbe_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Palabole mo ye hepaisowadi yona lauhekata udiyedi. Na yona hekahekatao maiyanao se bom mo, kabo palabole kaniyodi wa ye hemasalahadi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Meimeilahina ne unai, Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Ta kawasilau hali sanakawasi ne.” ");
INSERT INTO sbe_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na tamowai maudoidi wa se laugabaeidi, na Yesu yona hekahekatao waga wa unai hinage se gelu na Yesu maiyanao se lau, yo waga hekadi hinage se hemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kabo yaumai lakilakina ye lotalu yo bagodu se iniꞌinisae waga wa kalona unai, na musamusana kabo se yoli. ");
INSERT INTO sbe_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na Yesu waga yiuna wa unai kunuwa unai ye kenokeno. Na se hanoi se hededelau unai se wane, “Taulauhekata, kabo ta mwaloi, na idohagi to nige ku mode?” ");
INSERT INTO sbe_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ye tolo ede ye hededelau yaumai yo bagodu wa udiyedi ye wane, “Kwa kaiyawasi yo kwa daumwali!” Kabo yaumai yo bagodu wa se kaiyawasi na ye daumwalikimkim. ");
INSERT INTO sbe_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na ye hededelau yona hekahekatao wa udiyedi ye wane, “Idohagi to kwa matausi? Sola nige yomi sunuma?” ");
INSERT INTO sbe_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na se siliyata yo se matausikalili, unai se henahenamaiꞌuyoidi, “Teina tamowai ta tamowai sahasahana? Yaumai yo bagodu hinage iya se kawakabiyei!” ");
INSERT INTO sbe_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Siya kabo se dunasae hali sanakawasi wa unai, Gelasa tamowaidi yodi tano unai. ");
INSERT INTO sbe_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu waga wa ye pesagabaei, na bwayabwaya unai tamowai hesau ye laoma Yesu ye hailobai. Yaluwa bikibikina tamowai wa ye luwui ");
INSERT INTO sbe_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","na bwayabwaya duhadi udiyedi ye miyamiya, yo tamowai hekadi nige gonowana seniyena se paihekahini. ");
INSERT INTO sbe_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Huya hekadi iya nimana yo kaena seni udiyedi se paidi, meta ye utusidi, na nige gonowana se hekaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mayadai yo boniyai bwayabwaya wa unai yo kuduli udiyedi ye sae ye dobi na ye yogayogahi, yo sapakila ye haidi na tauna wa ye sasagwadagwadaidi. ");
INSERT INTO sbe_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu sola kedalohawai na tamowai wa iya ye kita ede ye heloi ye lau ye tulibono talanuwana wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ye yogahilakilaki ye wane, “Yesu, Yaubada Saesaekalilina natuna, saha ku henuwa kaliguyena? Yaubada hesana unai ya kaibwadaigo tabu ku hekamkamnagau.” ");
INSERT INTO sbe_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Matawuwuna ede Yesu ye hededelauko iya unai ye wane, “Yaluwa bikibikina, kowa tamowai me ku pesagabaei.” ");
INSERT INTO sbe_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na kabo Yesu ye henamai ye wane, “Hesam ede saha?” Na ye hededebui ye wane, “Yau hesagu ede Legiyona, kaniyona ede ka bado.” ");
INSERT INTO sbe_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na ye kaibwadakalili ye wane, “Tabu ku hetamaligai ka lau kedalohaloha.” ");
INSERT INTO sbe_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kuduli hesau papalina unai meta puwaka yawoina lakilakina se dumudumuli. ");
INSERT INTO sbe_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yaluwa yababadi wa se kaibwadalau Yesu unai se wane, “Ku hetamaligai ka lulau tenem puwaka ne yawoina ne udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ye talamyeidi ede yaluwa bikibikidi wa kabo se pesa na se lulau puwaka wa udiyedi. Na se heloilidilidi padipadi wa unai se dobi ede se bekudobi gabwa wa unai se yoligogoi na se mwaloi. Na puwaka wa badodi ede nuwana 2,000. ");
INSERT INTO sbe_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Puwaka wa taukitahetetedi kabo se wasabu se lau, wasa wa se helaki magai lakilakina yo tenem teha ne kasadi gagilidi udiyedi. Magai wa tamowaidiyao kabo se lau bena laulau wa se kita. ");
INSERT INTO sbe_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Se lage Yesu unai na tamowai yaluwa yabayababadi legiyona se luwuiꞌusei wa se kita ye tulitautaubigai, ma kalekalekona yo ma nuwanamwanamwana. Unai se matausi. ");
INSERT INTO sbe_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na ginauli maudoidi wa taukitadi meta taulaoma yodi se hedehedede, saha ye tubu tamowai wa unai, yo puwaka wasadi hinage. ");
INSERT INTO sbe_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Siya kabo se kaibwadalau Yesu unai bena yodi magai tanona ne ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu waga wa unai ye gelu, na tamowai yaluwa yababadi se luwuiꞌusei wa ye kaibwadalau bena iya maiyana se lau. ");
INSERT INTO sbe_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu nige ye henuwa na ye hededelau iya kalinawai ye wane, “Ku lau yom magai yo kehamwao udiyedi na Guiyau yona katekamkamna yo yona gigibwali ye hemasalahadi kowa kalimwai wa, wasana yodi ku hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iya kabo ye lau Dekapolisi tehana unai Yesu saha ye ginauli iya unai wa ye hewasa, ede tamowai maudoidi se nokokalili. ");
INSERT INTO sbe_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ye gelu waga wa unai na ye uyo hali sanakawasi wa. Ye duna kabo ye pesa nagali wa unai, na bodalakilaki temenai se tupagogoima iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kabo sunago badana hesau, hesana ede Yailo, iya ye laoma na Yesu ye kita ede ye gulidobi talanuwanawai. ");
INSERT INTO sbe_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Na ye hededekatekamkamnalau iya unai, ye wane, “Natugu waihiu gagilina ye kasiyebwakalili. Taba gonowana ku laoma ku kabilau unai to bena ye namwanamwaꞌuyo na ye mauli.” ");
INSERT INTO sbe_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Unai Yesu maiyana se lau, na bodalakilaki wa se hemuliwatanidi na yodi lau wa unai meta Yesu unai se heduheduna. ");
INSERT INTO sbe_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Waihiu hesau temenai, kana kasiyebwa meta kwasina ye miyamiyagabaei bolimai saudoudoi-labui. ");
INSERT INTO sbe_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bolimai ne luwadiyena doketa maudoidi yodi sagu kalinawai meta nige gonowana, na waihiu wa meta ye kamkamnakalili. Na hemaisadi mo udiyedi yona moni maudoina ye hegehe, na kana kasiyebwa wa kabo ye helahelaki mo ye lau. ");
INSERT INTO sbe_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iya Yesu yona laoma wasana ye lapui ede boda luwadiyena ye laoma Yesu dagelana unai na kana kwama ye kabitonogi, ");
INSERT INTO sbe_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","unamo ede yona nuwatu ye wane, “Taba kana kwama mo ya kabitonogi, kabo ya namwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mahanana ne unai kwasina kasiyebwana wa ye kaiyawasi, na tauna kamnana ye lapui meta kasiyebwa wa ye kaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na Yesu kamnana ye lapui meta gigibwali ye pesagabaei, unai ye kitabui boda wa udiyedi na ye henamai ye wane, “Kaiteya kagu kwama ta ye kabitonogi?” ");
INSERT INTO sbe_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yona hekahekatao se hededelau unai se wane, “Boda wa ku kitadi se heduheduna kalimwai, na ye saha to ku henamai ku wane, ‘Kaiteya ye kabilaoma kaliguwai?’” ");
INSERT INTO sbe_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Yesu ye kaikewatakikili taba bena laulau ne tauginaulina wa ye kita. ");
INSERT INTO sbe_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Waihiu wa ye nuwatulobai saha ye tubu iya kalinawai wa, unai ye matausitabutabubu. Kabo ye laoma ye gulidobi Yesu talanuwana wa unai na saha ye ginauli wa ye hededehemasalaha. ");
INSERT INTO sbe_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kabo ye wane, “Natugu, yom sunuma ta ye henamwanamwago. Ku lau ma nuwadaumwalim, kam kasiyebwa ye kaiyawasiko.” ");
INSERT INTO sbe_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu sola ma hedehededena na sunago badana Yailo yona numa unai tamowai hekadi se laoma na se hededelau iya unai se wane, “Natum waihiu wa meta ye boitako! Taulauhekata me tabu ku hemohemode.” ");
INSERT INTO sbe_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yodi hededegadigadigugu wa Yesu ye lapui na ye hededelau sunago badana wa unai ye wane, “Tabu ku matausi, na ku kawamamohoiyeigau mo.” ");
INSERT INTO sbe_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na kabo boda wa ye hededenuwahidi, na Petelo yo Yamesi ma kana kaha Yowane mo se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Se lage sunago badana wa yona numa unai na tamowai se lapuidi se doudou numakalo wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ye mwalaesae numakalo wa unai na ye hededelau udiyedi ye wane, “Saha kwa doudouyei? Wawaya me nige ye boita na ye kenokeno.” ");
INSERT INTO sbe_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na siya Yesu se talawasiyei. Yesu kabo ye hedede se pesa dagelawai, na kabo wawaya wa tamana yo sinana ye woyaidi na maiyana hekahekatao haiyona wa se lusae wawaya wa yona bili unai. ");
INSERT INTO sbe_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kabo Yesu ye kabilau sinekuku wa nimana unai na ye hededelau unai ye wane, “Talita koum!”, kaniyona meta, “Wawaya waihiu, ku tolo!” ");
INSERT INTO sbe_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ede wawaya wa ye tolo na ye laulau. Wawaya wa yona bolimai ede saudoudoi-labui. Na kabikabi ne taukitana meta se siliyata. ");
INSERT INTO sbe_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na kabo Yesu ye guguyaedi tabu saha ye ginauli wa se hewahewasa, na ye hededelau udiyedi bena wawaya wa kai se mosei ye kai. ");
INSERT INTO sbe_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu tenem tupwa ne ye laugabaei kabo maiyana hekahekatao se uyoma yona magai Nasaleta unai. ");
INSERT INTO sbe_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati mayadaina unai kabo ye hetubu ye lauhekata yodi sunago unai. Na boda ye laki yona hedehedede se lapui ede se nokoei. Se henahenamaiꞌuyoidi se wane, “Nuwanuwatu ta meta haedi ye haidi? Yo yona sibasiba ta haedi ye hai, to laulau gigigigibwalidi hinage ye ginaulidi? ");
INSERT INTO sbe_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iya meta kapenta yo hinage Maliya natuna, na kana kahao ede Yamesi, Yosepa, Yudasi yo Simona. Na lounao hinage maiyadao ta miyamiya.” Unai ede se kouyalayalaei. ");
INSERT INTO sbe_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Yesu ye hededelau udiyedi ye wane, “Magai maudoidi peloweta se hekasisiyei, iyamo yona magai tamowaidi yo kana bogao yo kehanao nige se hekasisiyei.” ");
INSERT INTO sbe_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ede magai wa unai nige gonowana laulau gigigigibwalina hesau ye ginauli, na nimana ye tolesae tamowai kasikasiyebwadi hisa mo udiyedi na se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Yesu ye nokokalili, matawuwuna ede yona magai tamowaidi nige se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Na Yesu ye lau magai gagilidi udiyedi tamowai ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na kabo Saudoudoi-labui wa ye yogagogoidima bena labui labui ye hetamalidi. Gigibwali ye moseidi bena yaluwa bikibikidi se hededehepesadi. ");
INSERT INTO sbe_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na kabo ye guguyaidi ye wane, “Tabu ginauli hesau kwa laubahei yomi kabalau ne unai, na tuke mo. Tabu kami kai, yomi tobwa, yo moni kwa bahebaheidi. ");
INSERT INTO sbe_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na gonowana mo buti kwa likwadi, na tabu kami kwama hagahagadi kwa baheidi.” ");
INSERT INTO sbe_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na ye hededeꞌuyo ye wane, “Kaiteya numa unai se yoganeigomiu na kwa mwalaesae, meta unai kwa miya ye lau ee magai me kwa laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ena magai hesau nige se yogaisinigomiu yo yomi hedehedede nige se lapuidi, meta kwa laugabaei na kaemiu mukalidi mo kwa koinihinihiyedi. Temeta ye hemala magai ne yodi kabakitalobai meta Yaubada kabo ye hekamkamnadi.” ");
INSERT INTO sbe_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu yona hekahekatao wa se pesa se lau se lauguguya bena tamowai nuwadi se buidi. ");
INSERT INTO sbe_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yaluwa yabayababadi gwaudi se hededehepesadi, na bunama unai taukasikasiyebwa gwaudi se heyausidi yo se henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heloda wasawasa Yesu wasana ye lapui, matawuwuna Yesu hesana wa tamowai maudoidi kabina se kata. Hekadi se wane, “Nuwana Yowane Babatiso iya boita unai ye toloꞌuyoma, unai ede gigibwalina ne kalinawai na laulau gigigigibwalidi ye ginaginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hekadi se wane, “Nuwana Eliya”, yo hekadi se wane, “Nuwana peloweta hesau, yo doha peloweta bagubagunadi wa hesau.” ");
INSERT INTO sbe_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na huyana Heloda wasa wa ye lapui meta ye wane, “Yesu meta Yowane. Iya gadona ya boliyako, na boita unai ye toloꞌuyoma.” ");
INSERT INTO sbe_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yowane yona boita wasana ede teina: Heloda meta kana kaha Pilipo mwanena ye tawasolai, na Yowane ye hedehedede ye wane, “Kowa laugagayo ku utusi, taba tabu kam kaha mwanena ku tawatawasolai!” Na Heloda ye henuwa bena Helodiyasi nuwana ye henamwa, unai ye hedede na Yowane se hai se pai na se tole numatutugudu unai. ");
INSERT INTO sbe_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na Helodiyasi Yowane ye kouyalayalakaliliyei, na ye henuwa bena ye unuhemwaloi. Iyamo nige gonowana, ");
INSERT INTO sbe_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","matawuwuna Heloda kabina ye kata meta Yowane tamowai dudulaina yo Yaubada yona taupaisowa, na ye hekasisiyei. Yowane yona hedehedede debadiwai Heloda nuwagwali ye hai, ede nuwana ye haikabi, na iyamo huya maudoina ye lapulapulau Yowane yona hedehedede udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nige bayaona kabo Helodiyasi yona nuwatu wa mayadaina ye lage. Heloda yona huyalabasi mayadaina unai kaikaigogo ye ginauli maiyanao tamowai lakilakidi yo iyala babadadi yo Galili babadadi. ");
INSERT INTO sbe_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Helodiyasi natuna waihiu kabo ye laoma na siya matadiwai ye sobu. Heloda yo kana taumana wa nuwadi se namwakalili, unai ye hededelau hasala wa unai, ye wane, “Kowa kam henuhenuwa saha kabo ya leyawa.” ");
INSERT INTO sbe_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na ye hededekaigwala ye wane, “Ginauli saha ku kaibwadai meta kabo ya leyawa yom. Gonogonowana doha yogu basileiya ta tehana, ena ku henuwa.” ");
INSERT INTO sbe_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hasala wa kabo ye lau sinana unai ye henamai ye wane, “Saha kabo ya kaibwadai?” Helodiyasi ye wane, “Yowane Babatiso kulukuluna.” ");
INSERT INTO sbe_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ede ye laumwamwayau ye uyo wasawasa wa unai na ye kaibwadalau unai ye wane, “Yau yogu kaibwada ede teina: Mahana ta unai Yowane Babatiso kulukuluna ku usai gaeba unai na ku haiyama.” ");
INSERT INTO sbe_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wasawasa wa nuwana ye yababakalili, na nige saha hesau ye hedede, matawuwuna kana taumanao yona hededekaigwala wa se lapuiyako. ");
INSERT INTO sbe_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Unai wasawasa wa taukaiunu ye yoganei na ye hedede bena Yowane kulukuluna ye bolihai na ye baheiyama. Ede ye lau numatutugudu unai na Yowane gadona ye boliꞌutusi ");
INSERT INTO sbe_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na kulukuluna wa gaeba unai ye usaei na ye baheiyama ye mosei hasala wa unai, na ye bahelaei sinana wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Huyana Yowane yona hekahekatao wasa se lapui ede se laoma, taugaibuna mo se bahei se laei bwayabwaya unai se tole. ");
INSERT INTO sbe_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo wa yodi paisowa wa unai se uyoma na se lagegogoima Yesu unai na yodi paisowa yo yodi lauhekata wa wasadi yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na tamowai se badokalili se hemohemode, unai nige gonowana bena se kaikai. Ede Yesu ye wane, “Kwa laoma, kita ta bom ta lau teha hesau unai. Temenai kabo ta kaiyawasi huyakubwakubwa.” ");
INSERT INTO sbe_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na kabo se bom waga unai se gelu se lau balabala hesau unai. ");
INSERT INTO sbe_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yodi kabalau ne meta tamowai se kitayako na tamowai gwaudi se kitalobaidi. Unai magai maudoidi tamowaidi se tolo na se heloi se lau na se lagebaguna Yesu yona kabalage wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu kabo ye dunasae na bodalakilaki ye kitadi ede ye katekamkamnaedi, matawuwuna siya doha mamoe nige taukitahetetedi. Unai kabo ye hetubu nuwatu se bado ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mahana ye talukeo, ede yona hekahekatao wa se lau iya unai na se wane, “Teina ta balabalagaibuyena, yo mahana ye laukalili. ");
INSERT INTO sbe_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Taba ku hetamalidi se lau dedekawai kasa gagilidi yo magai udiyedi na kadi kai se hemaisadi.” ");
INSERT INTO sbe_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Yesu ye hededelau udiyedi ye wane, “Komiu kadi kai kwa moseidi.” Kabo se henamaiyei se wane, “Haedi kabo denali 200 ka hai na kadi kai ka hemaisadi yo ka hekaidi?” ");
INSERT INTO sbe_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Unai kabo ye wane, “Hage, kwa kita, pwalawa hisa kalimiuyena?” Apostolo kabo se lau pwalawa se wase na se lobaidi ede se uyoma Yesu unai na se wane, “Pwalawa haligigi yo yama labui.” ");
INSERT INTO sbe_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kabo ye hededelau udiyedi ye wane, “Tamowai maudoidi kwa hedede bena se hebodahegahegagili na se tulidobi lagau ne unai.” ");
INSERT INTO sbe_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kabo se tulinamwanamwa, boda hekadi 100 yo boda hekadi 50. ");
INSERT INTO sbe_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu kabo pwalawa haligigi yo yama labui wa ye haidi, ye kitasae galewa unai, na Yaubada ye lautokiyei. Na kabo pwalawa ye kihihegahegagilidi na ye moseidi yona hekahekatao kalidiwai. Siya kabo se soiyei tamowai wa kalidiwai. Na hinage yama labui wa ye kihihegahegagilidi na ye moseidi se kai. ");
INSERT INTO sbe_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na maudoidi se kaikai yo bogadi se sese. ");
INSERT INTO sbe_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yesu yona hekahekatao pwalawa yo yama kaitoledi wa se tanogogoidi, meta bosa saudoudoi-labui se hemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na taukaikai badodi meta 5,000. ");
INSERT INTO sbe_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kabo Yesu yona hekahekatao ye hegelumwamwayauyeidi bena se kawasibaguna se lau Betesaida, na iya kabo boda wa ye hetamalidi se lau. ");
INSERT INTO sbe_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na kabo ye sae koya tupina hesau unai ye tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Boniyaina ne unai meta waga wa sola Galili Gabwana duwaduwalina unai ye laulau, na Yesu ye bom mo tano wa unai ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na ye kitadi wose unai se kabikabiꞌuseidi, matawuwuna ede yaumai ye bayao yo hinage se wosematai. Malatomtom gagilina Galili Gabwana kewana ne unai ye laulau na ye lau udiyedi, na bena kabo ye laugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Na huyana se kita gabwa kewanaena ye laolaoma hesabadi meta yodi nuwatu bena yaluyaluwa na se yogahi, ");
INSERT INTO sbe_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","matawuwuna se matausikalili. Na ye hededelau udiyedi ye wane, “Kwa nuwabayao! Doha yau Yesu! Tabu kwa matausi!” ");
INSERT INTO sbe_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na kabo ye gelusae waga wa unai maiyanao, na yaumai wa ye kaiyawasi. Siya kabo se nokokalili, ");
INSERT INTO sbe_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","matawuwuna pwalawa haligigi laulauna wa nige se nuwatulobai, na nuwadi se kwailolo. ");
INSERT INTO sbe_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Se kawasilau ede se duna Genesaleta unai, na menai yodi waga se lowoni. ");
INSERT INTO sbe_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huyana waga se pesagabaei meta tamowai hekadi Yesu se kitalobai, ");
INSERT INTO sbe_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ede magai wa maudoina se tauhetakikili na taukasikasiyebwa se baheidima diyadiyali udiyedi, na ena Yesu wasana se lapui yona kabalau haedi meta kabo se laedi temenai. ");
INSERT INTO sbe_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu yona kabalau maudoidi ne udiyedi, magai gagilidi yo magai lakilakidi udiyedi, tamowai kasikasiyebwadi se toledi yodi magai bakubakudiyao udiyedi. Se kaikaibwadai bena kana kwama sinosinona se kabitonogi, na taukabitonogina maudoidi wa se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Paliseya tamowaidi yo laugagayo taulauhekataena hekadiyo Yelusalema unai se laoma na se lagegogoma Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yona hekahekatao hekadi se kitadi ma nimabikibikidi na se kaikai, na nige se nimadeuli doha kadi kulutubu yodi kabikabi mamohoina unai. ");
INSERT INTO sbe_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Paliseya tamowaidi yo Dius tamowaidi maudoidi kadi kulutubu miyamiyadi se hekasisiyeidi, unai taba nige se kaikai kana siga nimadi se deulidi doha kulutubu yodi kabikabi mamohoina unai. ");
INSERT INTO sbe_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ena yodi kabalokulokune unai se uyoma meta se nimadeulibaguna na kabo se kaikai. Kulutubu yodi kabikabi yo laugagayo se bado bena se hekasisiyeidi. Hinage kabikabi hekadi doha kaputi yo waila kabayaiyai yo gulewa deudeulidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Unai Paliseya tamowaidi yo laugagayo taulauhekataena wa Yesu se henamaiyei se wane, “Idohagi to kowa yom hekahekatao kulutubu miyamiyadi nige se miyawatanidi, na ma nimabikibikidi se kaikai?” ");
INSERT INTO sbe_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na Yesu ye hededelau udiyedi ye wane, “Komiu taukailupolupo hedehededemiu Aisaiya ye hededepelowetai wa meta mamohoi, doha ye kuliyako ye wane, ‘Teina tamowai ta kawadi mo udiyedi se hekasisiyeigau, na nuwamamohoidiyao udiyedi meta Yaubada nuwanuwatuna nigele. ");
INSERT INTO sbe_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yodi kaihelahuigau meta nige kaniyona, matawuwuna tamowai yodi laugagayo mo se hekahekatadi.’ ");
INSERT INTO sbe_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yaubada yona laugagayo kwa tolehesuwaladi, na tamowai yodi laugagayo kwa kabihekahinidi.” ");
INSERT INTO sbe_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na kabo ye wane, “Komiu laugagayo tolebuina unai kwa katakalili! Yaubada yona laugagayo kwa tolehesuwala na komiu kami kulutubu kabikabidiyao mo kwa lauwatanidi. ");
INSERT INTO sbe_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose ye hededeyako ye wane, ‘Tamam yo sinam ku hekasisiyeidi.’ Yo ye wane, ‘Ena hesau tamana yo sinana ye hededeheyababadi, iya kabo kwa unuhemwaloi.’ ");
INSERT INTO sbe_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iyamo komiu kwa wane, Ena tamowai hesau sinana yo tamana yodi kainauya ye kabinonohai na nige ye mosei udiyedi na ye mosei Yaubada unai, ");
INSERT INTO sbe_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kwa hedede temeta laulau ne bena ye dudulai. ");
INSERT INTO sbe_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Unai komiu kami kulutubu kabikabidiyao mo kwa lauwatanidi na Yaubada yona laugagayo kwa tolehesuwala. Yo Yaubada yona laugagayo hekadi hinage kwa tolebuidi gonogonowana doha teina.” ");
INSERT INTO sbe_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na kabo Yesu boda wa ye yogagogoidima na ye hededelau udiyedi ye wane, “Komiu maudoimiu, yogu hedehedede ta kwa lapunamwanamwaei yo bena kwa nuwatulobai. ");
INSERT INTO sbe_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tamowai saha ye kai na ye dobi bogana luwanawai meta nige ye hebiki Yaubada matanawai. Na ginauli saha nuwanawai ye pesama meta iya ye hebiki ede.” ");
INSERT INTO sbe_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kabo Yesu maiyana hekahekatao boda wa se laugabaeidi na se mwalaesae numa hesau unai, na kabo palabole kaniyona wa se henamaiyei. ");
INSERT INTO sbe_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iya ye hededelau udiyedi ye wane, “Idohagi to nige kwa nuwatulobai? Komiu taba kabina kwa kata saha tamowai ye kai na ye dobi bogana luwanawai meta nige gonowana ye hebiki. ");
INSERT INTO sbe_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kana kao ede nige ye dobi nuwana unai, na ye dobi bogana luwanawai, na kabo ye miyagabaei.” Teina hedehedede ta unai Yesu ye hededehemasalaha meta kai maudoidi se aꞌa. ");
INSERT INTO sbe_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kabo ye wane, “Saha tamowai nuwanawai ye pesama meta iya ye hebiki ede, ");
INSERT INTO sbe_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","matawuwuna saha nuwanawai se pesama wa, siya ede teina: nuwatu yabayababadi, laulaubikibiki, kaiwahali, kaiunu, ");
INSERT INTO sbe_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ganawali, samagogo, henunu, kailupolupo, matabado, kaikalomagigili, monunu, nuwasaesae, yo walobayao. ");
INSERT INTO sbe_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Teina ginauli yabayababadi maudoidi ne meta tamowai nuwana unai se laoma yo siya tauhebikina ede Yaubada matanawai.” ");
INSERT INTO sbe_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Temenai kabo Yesu ye dalahai ye lau Taiya tehana unai. Na ye mwalaesae numa hesau kalona unai. Yona nuwatu meta bena tabu iya se kita. Na iyamo nige gonowana ye tauwadam. ");
INSERT INTO sbe_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Magai wa unai waihiu hesau, iya dagela waihiuna teha Siliya tupwana Penisiya unai ye laoma. Natuna sinekuku meta yaluwa bikibikina ye luwu iya unai. Na waihiu wa Yesu wasana ye lapui ede ye laoma ye tulibono iya talanuwana unai na ye kaibwada Yesu unai taba yaluwa bikibikina wa natuna wa unai ne ye hededehepesa. ");
INSERT INTO sbe_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Yesu ye hededelau iya unai ye wane, “Sola wawayao ya hekaibagunaedi, matawuwuna nige ye dudulai bena wawayao kadi kai ta haidi na ta gabalaedi kedewa udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Waihiu wa ye hededebui ye wane, “Guiyau, mamohoi! Na iyamo wawayao saha se kaidi na mapuladi se bekudobi hatahata gunina ne unai meta kedewa kabo se kaidi.” ");
INSERT INTO sbe_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na kabo Yesu ye hededelau unai ye wane, “Yom hedehedede ta ye namwakalili. Unai ku lau yom numa. Yaluwa yabayababana wa natum ye pesagabaeyako.” ");
INSERT INTO sbe_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Waihiu wa kabo ye uyo numa. Metai natuna wa ye kita ye kenokeno, na yaluwa yabayababana wa ye pesagabaeyako. ");
INSERT INTO sbe_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Taiya kana sigasiga ye laugabaei na ye lau Sidona yo ye dobi Galili Gabwana, na kabo ye lage Dekapolisi tehanawai. ");
INSERT INTO sbe_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Temenai tamowai beyakolakolana yo ye unaꞌuna se woyaiyama Yesu unai. Na se kaibwada Yesu unai bena nimana ye tolesae iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boda wa luwadiyena Yesu tamowai wa ye woyahesuwala. Kabo ye kabilau beyana duhadi udiyedi, yo ye kaiso nimana unai na ye kabilau memenana unai. ");
INSERT INTO sbe_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ye kitasae galewa ne unai na katekamkamna nuwana ne ye hemwayau, na ye hededelau tamowai wa unai ye wane, “Epata!”, kaniyona ede, “Ku malapai!” ");
INSERT INTO sbe_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mahanana ne unai beyana se malapai yo memenana unai gonowana ye hedehededenamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu boda wa ye guguyaidi tabu wasana se hededehelaki. Iyamo nige gonowana se lapulau unai, na huya maudoina hedehededena wa se helaki mo ye lau. ");
INSERT INTO sbe_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tamowai maudoidi se nokokalili se wane, “Ginauli maudoidi ye ginaulidi meta se namwa. Tamowai beyakolakoladi beyadi ye hemalapaidi, yo tamowai unaꞌunadi ye saguidi na se hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Huya hesau boda se tupagogoiꞌuyoma na nige kadi kai. Ede Yesu yona hekahekatao ye yoganeidi na ye hededelau udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Bodalakilaki ta ya katekamkamnaedi, matawuwuna mayadai haiyona maiyaguwao ka miyamiya na nige kai hesau kalidiwai bena taba se kai. ");
INSERT INTO sbe_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ena taba ma hasalidi na ya hetamalidi, meta kabo keda ne unai matadi se kamumu na se guli, matawuwuna hekadiyo kedalohaloha udiyedi se laoma.” ");
INSERT INTO sbe_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na yona hekahekatao se hededelau unai se wane, “Teina balabalagaibu. Haedi kabo kai ta hai na boda ta ta hekaidi?” ");
INSERT INTO sbe_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ye henamailau udiyedi ye wane, “Kalimiuyena pwalawa hisa?” Siya se wane, “Haligigi-labui.” ");
INSERT INTO sbe_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na ye hedede boda wa se tuli bwatano unai. Na kabo pwalawa haligigi-labui wa ye haidi na Yaubada ye lautokiyei, na kabo ye kihidi na ye moseidi yona hekahekatao udiyedi, na se soiyeidi boda wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yo hinage yona hekahekatao yama gagilidi hekadi kalidiwai. Ede Yesu ye lautoki hesabadi, na kabo ye moseidi na se soiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Maudoidi se kaikai na bogadi se sese. Kabo Yesu yona hekahekatao kaitole wa se tanogogoidi, meta bosa haligigi-labui se hemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Taukaikai wa badodi ede nuwana 4,000. Na kabo ye hetamalidi se lau. ");
INSERT INTO sbe_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na yona hekahekatao wa maiyanao se gelumwamwayau se lau magai Dalemanuta tehana unai. ");
INSERT INTO sbe_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kabo Paliseya tamowaidi se laoma na se hetubu Yesu maiyadi se haikawayagala. Se henuwa bena Yesu se lautonogi, unai se kaibwadai bena galewa hekihekinoina hesau ye ginauli na se kita. ");
INSERT INTO sbe_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu nuwana ye kamkamna na ye wane, “Matawuwuna saha to teina isi ta hekihekinoi se kaibwadai? Ya hededemamohoi: Taba nige hekihekinoi hesau ya ginauli teina komiu kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na kabo ye laugabaeidi na waga wa unai ye geluꞌuyo na ye lau hali sanakawasi ne. ");
INSERT INTO sbe_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu yona hekahekatao nuwadi se luluhi na nige kai se bahei, na pwalawa kesega mo waga wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu ye guguyaidi ye wane, “Kwa nanabuꞌuyoigomiu! Tabu Paliseya yo Heloda yodi yisti udiyedi se lupohaigomiu!” ");
INSERT INTO sbe_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na siya se bom yodi se hedehedede se wane, “Doha teina ye hedehedede matawuwuna ede nige pwalawa ta bahei.” ");
INSERT INTO sbe_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yodi hedehedede wa Yesu ye lapui ede ye wane, “Idohagi to kwa wane, ‘Nige pwalawa ta bahei’? Nuwana sola nige kwa kitalobai yo nuwamiu sola nige se masalaha? Idohagi to kwa nuwakwailolo? ");
INSERT INTO sbe_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Idohagi to matamiu udiyedi nige kwa kita yo beyamiu udiyedi nige kwa lapui? Taba saha ye tubutubu wa kwa nuwatui! ");
INSERT INTO sbe_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Huyana pwalawa haligigi ya kihidi na tamowai 5,000 ya hekaidi meta kaitoledi wa bosa badona hisa kwa usahemwayaudi?” Siya se wane, “Saudoudoi-labui.” ");
INSERT INTO sbe_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Yo pwalawa haligigi-labui ya kihidi na tamowai 4,000 ya hekaidi, na kaitoledi wa meta bosa hisa kwa usahemwayaudi?” Se wane, “Haligigi-labui.” ");
INSERT INTO sbe_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kabo Yesu ye hededelau udiyedi ye wane, “Unai yisti hedehededena wa taba kwa nuwatulobai!” ");
INSERT INTO sbe_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na kabo Yesu maiyana hekahekatao se lage Betesaida. Temenai tamowai hesau matagibugibuna se woyaiyama Yesu unai na se kaibwadai bena ye kabilau iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu tamowai matagibugibuna wa nimana unai ye kabi na ye woyalae magai dagelana unai. Na kabo ye kaisolau tamowai wa matana unai na nimana ye tolesae unai na ye wane, “Saha hesau ku kita e nige?” ");
INSERT INTO sbe_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tamowai wa ye kaikewatakikili na ye wane, “Tamowai ya kitadi kadi kao doha kaiwa se taitaihileꞌusi.” ");
INSERT INTO sbe_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu nimana ye tolesaeꞌuyoi tamowai wa matana unai. Na matana wa se lala yo se nega. Ede kabo ginauli maudoidi ye kitanamwanamwaedi. ");
INSERT INTO sbe_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na Yesu tamowai wa ye hetamali ye lau yona magai na ye wane, “Tabu ku uyo magai ne unai.” ");
INSERT INTO sbe_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na kabo Yesu maiyana hekahekatao se lau wasawasa Pilipi yona magai Sisaliya dedekana magaidiyao udiyedi. Yodi kabalau ne unai Yesu ye henamaiyeidi ye wane, “Tamowai se hedede yau meta kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Siya Yesu kalinana se bui se wane, “Hekadi se wane kowa bena Yowane Babatiso, na hekadi se wane, Eliya, yo hekadi se wane bena kowa peloweta hesau.” ");
INSERT INTO sbe_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na kabo Yesu ye henamaiyeidi ye wane, “Na komiu? Kwa hedede meta yau kaiteya!” Na Petelo ye wane, “Kowa meta Keliso.” ");
INSERT INTO sbe_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ede Yesu ye hededebayao udiyedi bena tabu tamowai hesau yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na kabo Yesu ye hetubu yona hekahekatao ye hekatadi meta Tau Natuna kabo hekamkamna udoiꞌudoi udiyedi ye kamkamna. Na Dius babadadiyao yo taukaitalasam tauwoyaidi yo laugagayo taulauhekataena iya kabo se subu yo se unuhemwaloi, na mayadai haiyona mulidiwai kabo ye toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu yona hedehedede wa ye masalahakalili, unai Petelo Yesu ye woyahesuwala na ye hetubu hedehedede bayabayaodi udiyedi ye hededehekaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na Yesu ye tolobui ye kitalau yona hekahekatao wa udiyedi na ye hededebayao Petelo unai ye wane, “Ku tausuwala, kowa Satani. Kowa nige Yaubada yona nuwanuwatu ku nuwatuidi, na tamowai mo yodi nuwanuwatu udiyedi ku nuwanuwatu.” ");
INSERT INTO sbe_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na kabo boda wa ye yoganeidi se laoma yona hekahekatao maiyadiyao na ye hededelau udiyedi ye wane, “Ena hesau ye henuwa bena ye hemuliwatanigau, meta taba ye bom ye nuwagabaeꞌuyoi na yona sataulo ye bahei na ye hemuliwatanigau. ");
INSERT INTO sbe_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ena yona nuwatu bena yona mauli tanoubu ta unai ye kabihekahini, meta yona mauli mamohoina kabo ye hetaukwadalele. Na ena tanoubu ta maulina ye nuwagabaei yau yo wasa namwanamwana debamaiyena, kabo mauli nige kana siga ye lobai. ");
INSERT INTO sbe_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Taba tamowai hesau tanoubu ginaulidi maudoidi ye haidi, na ye bom yaluwana ye heyababaꞌuyoi, meta yona namwa saha? ");
INSERT INTO sbe_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Saha namwanamwana unai kabo yaluwana ne ye haiꞌuyoi? ");
INSERT INTO sbe_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ena hesau teina isi ganaganawalina yo yabayababana ta matadiwai ye mwadineigau yo yogu hedehedede ta ye mwadineidi, Tau Natuna hinage kabo ye mwadinei huyana Tamana yona didiga unai ye uyoma maiyana yona anelu tabudiyao.” (9:1) Na kabo Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi: Hekadi inai taba nige se boita kana siga Yaubada yona basileiya se kita ye lagema ma gigibwalina.” ");
INSERT INTO sbe_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","2","Mayadai haligigi-kesega se lau, na kabo Petelo, Yamesi, yo Yowane Yesu ye woyaidi se sae kuduli lakilakina hesau kewanawai. Siya se bom mo menai. Hekahekatao matadiwai na Yaubada Yesu kana kao ye bui. ");
INSERT INTO sbe_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na kana kwama ye bui ye posi na ye namanamalikalili, yona posiposi ne nige gonowana tamowai hesau ye deulilobai kaiyaulina ta unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na kabo Eliya maiyana Mose se taumasalaha na Yesu maiyadi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kabo Petelo ye hededelau Yesu unai ye wane, “Labi, ye namwakalili to kita inai. Unai taba gwau haiyona ka kabidi, hesau kowa yom, hesau Mose yona, yo hesau Eliya yona.” ");
INSERT INTO sbe_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hedehedede wa ye hedede matawuwuna taudi haiyona wa se matausikalili, unai nige kabina ye kata saha dudulaina kabo ye hedede. ");
INSERT INTO sbe_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na kabo yada ye taumasalaha ede ye sumadi. Na yada wa unai kalina hesau se lapui ye laoma ye wane, “Teina yau Natugu ya gadosisiyei. Kwa lapulau iya unai!” ");
INSERT INTO sbe_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nige bayaona na se kaikewatakikili meta Mose yo Eliya nige se kitadi, na Yesu ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yesu maiyadi kuduli wa unai se lidi se dobidobi na ye guguyaidi ye wane, “Saha wau kwa kita wa tabu tamowai hesau yona kwa hedehedede ye lau ee kana siga Tau Natuna boita unai ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Siya se bom hedehedede wa se nuwanuwatui yo hinage se hedehededei se wane, “Boita toloꞌuyona meta kaniyona ede saha?” ");
INSERT INTO sbe_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na kabo se henamaiyei se wane, “Matawuwuna saha to laugagayo taulauhekataena se wane, Eliya taba ye uyomabaguna?” ");
INSERT INTO sbe_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ye hededelau udiyedi ye wane, “Mamohoi, Eliya ye laomabaguna na ginauli maudoidi ye kabinonohaidi. Yo hinage Buka Tabuna unai se kuliyako meta Tau Natuna kabo ye kamkamnakalili yo tamowai iya se laukwatakwataei. ");
INSERT INTO sbe_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na ya hededelaowa, Eliya ye laomako, na saha yababadi se nuwatuidi na se henuwadi wa tamowai se ginaulidiko iya unai, doha iya wasana unai se kuliyako.” ");
INSERT INTO sbe_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na kabo se lage hekahekatao hekadiyo wa udiyedi. Na bodalakilaki se kitadi meta kadi kahao wa se tolohetakikilidi, yo hinage laugagayo taulauhekataena hekadi maiyadiyao se haihaikawayagala. ");
INSERT INTO sbe_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na tamowai wa Yesu se kita meta kaluwadi se loi na se heloi se lau iya se lautokiyei. ");
INSERT INTO sbe_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na Yesu ye henamaiyeidi ye wane, “Komiu saha kwa haihaikawayagalaei?” ");
INSERT INTO sbe_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Boda wa luwadiwai tamowai hesau ye wane, “Tanuwaga, natugu ya woyaiyama kalimwai. Yaluwa yabayababana iya ye luwui, unai nige gonowana ye hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ena yaluwa yabayababana iya ye hai, kabo ye gabadobiyei bwatano ne unai, na kawana ne unai kabo gwasapulo se pesa, yo hinage kawana ye kapuyahisi yo tauna se todi. Yom hekahekatao ya kaibwadaidi bena yaluwa yababana ne se hededehepesa, na nige gonowadi.” ");
INSERT INTO sbe_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na kabo Yesu ye hededelau udiyedi ye wane, “Komiu isi ta meta nige yomi sunuma! Kabo ya miyaꞌuyo lohana doha saha kalimiuyena? Kwa kamnayabayababa! Wawaya me kwa baheiyama kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na kabo wawaya wa se woyalae Yesu unai. Huyana yaluwa yabayababana Yesu ye kita ede wawaya wa ye gulidobi bwatano unai na ye tapitapipili yo gwasapulona se pesa. ");
INSERT INTO sbe_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu gama wa tamana ye henamaiyei ye wane, “Kaiuyana teina kasiyebwa ta ye tubu iya unai?” Tamana wa ye wane, “Ma gagilina unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huya se bado iya ye gabadobiyei kaiwa kalakalasina yo waila unai bena kabo ye unuhemwaloi. Na ena kowa gonowam, kabo ku katekamkamnaegai yo ku saguigai.” ");
INSERT INTO sbe_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ye wane, “Ye saha to ku wane, ‘Ena kowa gonowam’? Ginauli maudoidi kabo se masalaha taukawamamohoiyeigau unai.” ");
INSERT INTO sbe_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na gama wa tamana ma kalinalakilakina ye hededebui ye wane, “Ya kawamamohoiyego! Na yogu sunuma gagilina ta unai ku saguigau.” ");
INSERT INTO sbe_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na Yesu boda wa ye kitadi se heloi se laoma iya unai, ede ye hededebayao yaluwa bikibikina wa unai ye wane, “Yaluwa beyakolakolana yo unaꞌunana, yau ya hededelaowa, wawaya me ku pesagabae na tabu ku luwuꞌuyo iya unai.” ");
INSERT INTO sbe_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na yaluwa yababana wa ye yogahi ede wawaya wa ye nukui na ye laugabaei. Na gama wa kana kao doha tamowai boiboitana, unai boda wa yodi nuwatu bena ye boitako. ");
INSERT INTO sbe_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Yesu ye kabilau wawaya wa nimana unai ye kabihetolo, ede ye tolo. ");
INSERT INTO sbe_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na kabo Yesu maiyana hekahekatao se mwalaesae numa kalona unai. Metai siya se bom na se henamaiyei se wane, “Matawuwuna saha to nige gonowamai wawaya ne unai yaluwa yababana ne ka hededehepesa?” ");
INSERT INTO sbe_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ye hededelau udiyedi ye wane, “Yaluwa kana kao doha teina ta, meta tapwalolo mo unai kabo kwa hededehepesa.” ");
INSERT INTO sbe_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kabo Yesu maiyana hekahekatao magai wa se laugabae na Galili unai se laulau. Yesu nige ye henuwa bena tamowai kabina se kata meta siya ede haedi, ");
INSERT INTO sbe_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","matawuwuna yona hekahekatao wa ye hekatadi. Ye hededelau udiyedi ye wane, “Tamowai hesau kabo Tau Natuna kana ye walohai na ye moselaei tamowai hekadi nimadiwai na se unuhemwaloi. Kabo ye boita, na mayadai haiyona mulidiwai kabo ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na Yesu saha ye hedehededeidi ta meta yona hekahekatao wa nige se nuwatulobai. Iyamo nige se henamaiyei, matawuwuna ede se matausi. ");
INSERT INTO sbe_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na kabo se lage Kapelenauma unai. Siya numa hesau kalona unai, na Yesu ye henamaiyeidi ye wane, “Komiu saha kwa hetahetala keda ne unai?” ");
INSERT INTO sbe_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Siya nige kalinadi, matawuwuna keda wa unai se bom se henahenamaiꞌuyoidi luwadi ne unai kaiteya ye saekalili. ");
INSERT INTO sbe_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ye tulidobi na Saudoudoi-labui wa ye yogagogoidima na ye wane, “Yaubada matanaena kaiteya tamowai ye henuwa bena ye baguna, taba ye lau ye mulitamolosi, yo ye hemala tamowai maudoidi yodi heyayai tauhaina.” ");
INSERT INTO sbe_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na kabo Yesu ye kabilau wawaya gagilina hesau nimana unai. Ye kabihetolo matadiyena na ye labasiyama na ye wane, ");
INSERT INTO sbe_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Taba kaiteya wawaya gagilina hesau doha teina ye yogaisini yau hesaguwai, meta yau ye yogaisinigau. Yo kaiteya ye yogaisinigau meta nige yau mo ya bom ye yogaisinigau, na tauhetamaligau wa ye yogaisini.” ");
INSERT INTO sbe_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na Yowane ye hededelau Yesu unai ye wane, “Taulauhekata, tamowai hesau ka kita hesamyena yaluwa yababadi tamowai udiyedi ye hededehepesadi. Na ka hededelau unai taba ye kaiyawasi, matawuwuna iya nige kada kaha hesau.” ");
INSERT INTO sbe_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ye wane, “Tabu kwa hekahekaiyawasi, matawuwuna kaiteya laulaugigibwali ye ginauli yau hesaguwai, iya taba nige gonowana ye tolobuimwamwayau na ye hededeheyaheyababagau tenem huyana ne unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kaiteya nige ye guduguduida, iya meta tausaguida hesau. ");
INSERT INTO sbe_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya hededemamohoi: Kaiteya waila kaputina ye leyawa yau hesaguwai matawuwuna kowa Keliso yona, meta unai maisana kabo ye hai.” ");
INSERT INTO sbe_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tausunumaegau tamowaina dobidobina hesau, ena tamowai hesau iya ye woyahesuwala na yababa ye ginauli, meta ye namwa mo taba weku lakilakina gadonawai se kau na se tuudobiyei gabwawai. ");
INSERT INTO sbe_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ena nimam hesau ye woyahesuwalago na yababa ku ginauli, ku bolihai. Ye namwa mo taba nimam kesega unai mauli nige kana siga ku hai, na kabo ma nimalabulabuim na ku lau kaiwa kalakalasina nige yona huyaboso unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Yo ena kaem hesau ye woyahesuwalago na yababa ku ginauli, meta ku bolihai. Ye namwa mo kaem kesega unai mauli nige kana siga ku hai, na kabo ma kaelabulabuim na Yaubada ye gabalaego kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yo hinage ena matam hesau ye woyahesuwalago yababa unai, ku lamohai na ku gabaei. Ye namwa mo taba matam kesega na Yaubada yona basileiya unai ku lage, na kabo ma matalabulabuim na Yaubada ye gabalaego kaiwa kalakalasina unai, ");
INSERT INTO sbe_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘temenai mwatamwata buluma taukaikaidi taba nige se mwaloi, yo kaiwa nige yona kababoso.’ ");
INSERT INTO sbe_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yaubada kabo ye hekalitagomiu kaiwa kalakalasina unai. ");
INSERT INTO sbe_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kalita meta ye namwa, na taba ye tomatoma, kabo idohagi na ye kalitaꞌuyo? Nige gonowana! Taba kalita kalimiuwai yo kwa hainuwakesega na kwa miya.” ");
INSERT INTO sbe_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ye dalahai ye lau Yudeya tehana hesau unai ye lage, iya ede Yolidani sagasagana hali sanakawasina ne unai. Na kabo Yolidani wailana unai ye kawasi. Temenai hinage bodalakilaki se lagegogoma Yesu unai na ye hekatadi. Iya yona laulau doha tenem. ");
INSERT INTO sbe_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Huyana ne unai Paliseya tamowaidi hekadi se laoma iya unai bena se laukita ede se henamaiyei se wane, “Taba tamowai hesau mwanena ye inawasei, meta ye dudulai?” ");
INSERT INTO sbe_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na Yesu ye henamaiyeidi ye wane, “Mose yona laugagayo sahasahana ye leyawa?” ");
INSERT INTO sbe_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Se wane, “Mose ye talam bena tamowai ye inawase, na ye wane bena inawase pepwana ye kulibagunai, kabo gonowana mwanena ye hetamali ye lau.” ");
INSERT INTO sbe_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na Yesu ye hededelau udiyedi ye wane, “Teina laugagayo ta Mose ye kuli komiu yomiu, matawuwuna nuwamiu se kwailolokalili. ");
INSERT INTO sbe_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Huyana Yaubada tanoubu ta ye hetubu meta loheya yo waihiu ye ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Unai ede loheya kabo tamana yo sinana ye laugabaeidi na ye patulau mwanena unai, ");
INSERT INTO sbe_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na siya taudi labui se hemala buluma kesega. Unai siya nige tamowai labui, na se hemala tamowai kesega. ");
INSERT INTO sbe_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Unai Yaubada saha ye tolekesegai meta tabu tamowai hesau ye hetatagwaligwali.” ");
INSERT INTO sbe_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Huyana se uyo numa kalona unai ede yona hekahekatao Yesu yona hedehedede wa se henamaiyei. ");
INSERT INTO sbe_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na ye hededelau udiyedi ye wane, “Kaiteya tamowai mwanena ye inawasei na waihiu hesau ye tawasolai, meta iya ye ganawali. ");
INSERT INTO sbe_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yo kaiteya waihiu iya mwanena ye inawasei na loheya hesau ye tawasolai, meta iya hinage ye ganawali.” ");
INSERT INTO sbe_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Huya hesau, tamowai hekadi wawayao gagilidi se woyalaedi Yesu unai bena kabo ye kabilau udiyedi yo ye hededehenamwadi. Na yona hekahekatao wa tamowai wa se hededehekaiyawasidi. ");
INSERT INTO sbe_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ye kitadi na ye koipili ede ye hededelau yona hekahekatao wa udiyedi ye wane, “Wawayao gagilidi ne bena se laoma kaliguwai, na tabu kwa guduguduidi, matawuwuna tamowai yodi sunuma doha teina wawayao ta meta Yaubada yona basileiya ne siya yodi. ");
INSERT INTO sbe_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya hededemamohoi: Tamowai nige gonowana ye lusola Yaubada yona basileiya unai kana siga yona sunuma doha wawaya gagilina ta.” ");
INSERT INTO sbe_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na kabo wawayao wa ye labasidi na nimana ye tolesaedi kewadiwai na ye hededehenamwadi. ");
INSERT INTO sbe_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ye hetubu bena ye dalahai, na tamowai hesau ye heloi ye laoma ye tulibono Yesu talanuwana wa unai na ye henamaiyei ye wane, “Taulauhekata namwanamwana, taba saha ya ginauli kabo mauli nige kana siga ya hai?” ");
INSERT INTO sbe_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ye hededelau unai ye wane, “Ye saha to ku wane yau ya namwa? Nige tamowai hesau ye namwa, na Yaubada ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Laugagayo kabidi ku kata: Tabu ku kaiunu, tabu ku ganawali, tabu ku kaiwahali, tabu lauhetala unai ku hededelupolupo, tabu tamowai hesau ku lupohai, yo hinage tamam yo sinam ku hekasisiyeidi.” ");
INSERT INTO sbe_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tamowai wa ye wane, “Taulauhekata, ma gagiligu unai ye laoma teina meta laugagayo maudoidi ta ya miyawatanidi.” ");
INSERT INTO sbe_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ye kitalau ma gadosisina na ye wane, “Ginauli kesega mo sola nige ku ginauli. Yom gogo maudoidi ku lokunegabaeidi, na monidi ne ku moseidi taudehadeha yodi, na kabo galewa ne unai ku wasawasa. Na kabo ku laoma ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hedehedede wa ye lapui ede ye siliyata na ye dalahai ye lau ma nuwakamkamnana, matawuwuna ede ye gogokalili. ");
INSERT INTO sbe_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kabo Yesu yona hekahekatao ye kitahetakikilidi na ye hededelau udiyedi ye wane, “Tamowai gogogogodi bena se lusola Yaubada yona basileiya unai meta ye pilipilikalili.” ");
INSERT INTO sbe_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yona hedehedede wa unai se siliyata. Na ye hededeꞌuyo ye wane, “Natuguwao, Yaubada yona basileiya lusolana meta ye pilipilikalili. ");
INSERT INTO sbe_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Doha kamela nige gonowana diu duhanawai ye lusola, gonogonowana doha tamowai gogogogona meta iya hinage nige gonowana ye lusola Yaubada yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu yona hekahekatao wa kabo se siliyatakalili na se henahenamaiꞌuyoidi se wane, “Kaiteya kabo mauli nige kana siga ye hai?” ");
INSERT INTO sbe_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ye kitalau udiyedi na ye wane, “Tamowai kalidiwai nige gonowana, na Yaubada gonowana tamowai ye haidi se lau yona basileiya unai. Matawuwuna Yaubada ginauli maudoina gonowana ye ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Petelo ye hededelau Yesu unai ye wane, “Kai kabo idohagi? Yoma gogo maudoidi ka laugabaeidiko na ka hemuliwatanigo.” ");
INSERT INTO sbe_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi: Kaiteya yona numa, kana kahao, lounao, tamana, sinana, natunao, yo yona koya ye laugabaedi yau debaguwai yo wasa namwanamwana debanawai, ");
INSERT INTO sbe_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","teina huya ta unai Yaubada kabo ginauli maudoidi udiyedi ye kainauyakaliliyei, yona numa, kana kahao, lounao, sinana, natunao, yo yona koya kabo se badokalili. Yo hinage pilipili kabo ye hekalodi, na malaitom huya kabo mauli nige kana siga ye hai. ");
INSERT INTO sbe_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na tamowai ta kitahesaeꞌuseidi meta se bado kabo se laoma se dobi, na tamowai ta kitadobidobiyeiꞌuseidi wa meta se bado kabo se laoma se sae.” ");
INSERT INTO sbe_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu yona hekahekatao ye bagunaedi se laulau Yelusalema. Yona hekahekatao wa se siliyata yo tauhemuliwatanina hekadiyo wa se matausi. Iya kabo yona hekahekatao wa ye woyahesuwaladi na ye hededehemasalaha udiyedi saha kabo ye tubu iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ye wane, “Kwa lapulapuinamwanamwa! Teina ta saesae Yelusalema. Na temenai kabo tamowai hesau Tau Natuna kana ye walohai taukaitalasam tauwoyaidi yo laugagayo taulauhekataena udiyedi. Kabo se koitalaliu na se hekasa bena se unui, na kabo se moselaei dagela tamowaidiyao kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na siya kabo iya se talatalawasiyei yo se kaikaisoi yo se pidili yo kabo se unuhemwaloi. Na mayadai hehaiyonana unai kabo ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedaiyo natunao Yamesi yo Yowane se laoma Yesu unai se wane, “Tanuwaga, saha ka kaibwadai ne, ka henuwa bena ku ginauli yomai.” ");
INSERT INTO sbe_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ye henamaiyeidi ye wane, “Komiu saha kwa henuwa bena ya leyawa?” ");
INSERT INTO sbe_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na se wane, “Ku hededehesunumagai taba yom basileiya unai kai tauma labui kabo teha saesaena unai ka tuli, hesau kowa nimakahatum na hesau seuseulim unai.” ");
INSERT INTO sbe_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na Yesu ye hededelau udiyedi ye wane, “Komiu saha kwa kaikaibwadai ta meta nige kabina kwa kata. Keyakana yau kabo unai ya numa ne, gonowamiu kabo kwa numa? Yo hinage babatiso kabo ya hai ne gonowamiu kabo kwa hai?” ");
INSERT INTO sbe_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na se wane, “Kai gonowamai.” Na Yesu ye wane, “Mamohoi! Komiu kabo kagu keyaka ne unai kwa numa, yo yogu babatiso ne unai kabo kwa babatiso. ");
INSERT INTO sbe_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Na yau nige gonowana ya hineli kaiteya kabo kahatugu unai ye tuli yo kaiteya seuseuligu unai ye tuli. Teina kabatuli ta tamagu ye hinelinonohaidiko kaiteyadi kabo udiyedi se tuli.” ");
INSERT INTO sbe_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yamesi yo Yowane yodi hedehedede wa hekahekatao hekadiyo wa se lapui ede se koipili. ");
INSERT INTO sbe_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kabo Yesu ye yogagogoidi na ye wane, “Komiu kabina kwa kata meta dagela tamowaidi yodi wasawasa yodi loina bayabayaona unai yodi tamowai se tanuwagaidi, yo idohagi yodi tauwoyawoya yodi gigibwali unai se loinaedi. ");
INSERT INTO sbe_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na komiu tabu doha tenem. Kaiteya ye henuwa bena yomi bada, iya taba yomi heyayai tauhaina. ");
INSERT INTO sbe_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yo kaiteya ye henuwa bena ye baguna luwamiuyena, meta iya tamowai maudoidi yodi heyayai tauhaina. ");
INSERT INTO sbe_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Matawuwuna Tau Natuna ye laoma nige bena tamowai iya yona se paisowa, na iya bena tamowai yodi ye paisowa na yona mauli ye mosegabaei na unai tamowai maudoidi ye hemaisahaidi na se mauli.” ");
INSERT INTO sbe_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yodi kabalau wa unai kabo se lage Yeliko unai. Na Yesu maiyana hekahekatao yo bodalakilaki maiyadiyao magai wa se laugabae, na tamowai matagibugibuna hesau hesana Batimaiyo, Timaiyo natuna, keda dedekanawai ye tutuli na ye kaikaibwada moni. ");
INSERT INTO sbe_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na huyana Batimaiyo wasa ye lapui meta Yesu Nasaleta tamowaina ye laolaoma dedekana ne unai, kabo ye yogalau unai ye wane, “Yesu, Dawida Natuna, ku katekamkamnaegau!” ");
INSERT INTO sbe_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na tamowai gwaudi iya se dilai se wane, “Ku mwanou!” Na iya kabo ye yogalakilaki na ye wane, “Dawida Natuna, ku katekamkamnaegau!” ");
INSERT INTO sbe_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ede Yesu ye talutolo na ye hededelau yona hekahekatao wa udiyedi ye wane, “Tamowai ne kwa yoganeiyama.” Ede se yogalau unai se wane, “Nuwam ye talu na ku tolo! Yesu ye yoganeigo!” ");
INSERT INTO sbe_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Taumatagibugibu wa kana kwama ye haigabaei na ye kamposi na ye lau Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu iya ye henamaiyei ye wane, “Saha ku henuwa bena ya ginauli kalimwai?” Tamowai matagibugibuna wa ye wane, “Labi, ya henuwa taba matagu ku helaladi.” ");
INSERT INTO sbe_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ye hededelau unai ye wane, “Ku lau, yom sunuma debanawai ku namwanamwa.” Na mahanana ne unai tamowai wa matana se lala ede Yesu ye hemuliwatani na keda wa unai se lau. ");
INSERT INTO sbe_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu ma kana bodao Yelusalema se hanahanawui, na se lage Betepage yo Betaniya dedekadiwai, Olibe koyana unai. Na kabo yona hekahekatao labui ye hetamalidi se lau ");
INSERT INTO sbe_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na ye hededelau udiyedi ye wane, “Kwa lau na magai ne unai kabo donki natuna kwa kita se paihekahini duu unai, sola nige tamowai hesau ye tulisae unai. Kwa yailihai na kwa woyaiyama. ");
INSERT INTO sbe_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ena tamowai hesau ye henamaiyeigomiu ye wane, ‘Saha temeta kwa ginaginauli?’, kabo kwa wane, ‘Guiyau ye henuwa na mahana kubwakubwa mo unai kabo ye hetamaliꞌuyoiyama.’” ");
INSERT INTO sbe_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Se lau ede donki natuna wa se kita duu unai se paihekahini. Se yaiyaili, ");
INSERT INTO sbe_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na tamowai hekadi temenai se totolo se hededelau kalidiwai se wane, “Ye saha to donki natuna ne kwa yaili?” ");
INSERT INTO sbe_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesu saha ye hedede kalidiwai wa gonogonowana hinage se hedede udiyedi ede suisui wa se talamyei. ");
INSERT INTO sbe_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Donki natuna wa se woyai se laeyama Yesu unai. Na kadi kwama se tolesaedi kewana ne unai, na Yesu ye tulisae unai. ");
INSERT INTO sbe_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tamowai hekadi kadi kwama se yesedi keda wa unai, na hekadi hinage kaiwa lagadi se bolidi na keda wa unai se yesedi. ");
INSERT INTO sbe_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kaiteyadi se baguna yo se mulita na Yesu maiyadi se laulau meta se heyoheyoga se wane, “Hosana!” “Ka hedebasaego, kowa Guiyau hesanawai ku laoma!” ");
INSERT INTO sbe_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ka hedebasaego, kowa kama kulutubu Dawida kana isimulita. Ku laoma ku tanuwagaigai!” “Hosana saesaekalilina!” ");
INSERT INTO sbe_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na kabo Yesu ye lusae Yelusalema na ye mwalae Numa Tabuna bakubakuna unai na ginauli maudoidi ye kitasipwaidi. Na ye hetubu ye meimeilahi, unai Numa Tabuna bakubakuna wa ye pesagabae, na maiyana hekahekatao se uyo Betaniya. ");
INSERT INTO sbe_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mala ye tom kabo Betaniya se laugabae se laulau na Yesu ye tauhasahasali. ");
INSERT INTO sbe_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kedalohawai ye kitalau bosibosi hesau ye kita, ede kaniyona hesabana ye lau. Na ye kita wa meta lugugaibuna, matawuwuna kaiwa wa nige yona huyakaniyo. ");
INSERT INTO sbe_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ede Yesu kaiwa wa ye kawagulaiyei ye wane, “Taba nige tamowai hesau kaniyom ye kaiꞌuyoi.” Yona hekahekatao hedehedede wa se lapui. ");
INSERT INTO sbe_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na kabo se lage Yelusalema ede Yesu ye mwalae Numa Tabuna bakubakuna unai. Na ye hetubu taulokulokune yo tauhemahemaisa ye henakudi se pesa. Yo hinage moni taulaulauhedudu yodi hatahata yo kaitalasam bunebunediyao taulokunedi yodi kabatuli ye buikahalaidi. ");
INSERT INTO sbe_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na ye laugagayoidi tabu tamowai hesau lokune ye bahei na ye mwalae Numa Tabuna bakubakuna unai. ");
INSERT INTO sbe_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yona lauhekata wa unai ye hededelau udiyedi ye wane, “Se kuliyako se wane, ‘Yogu numa meta tamowai maudoidi yodi kabatapwalolo numana.’ Iyamo komiu kwa hai ye hemala taukaikaiwahali yodi duha.” ");
INSERT INTO sbe_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Taukaitalasam tauwoyaidi yo laugagayo taulauhekataena hekadi yona hedehedede se lapui ede keda se wase bena taba idohagi kabo se unui. Na Yesu se matausiyei, matawuwuna ede tamowai gwaudi yona lauhekata wa se nokoei. ");
INSERT INTO sbe_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ye meimeilahi ede Yesu maiyana hekahekatao Yelusalema se laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malatomtomyena se uyo Yelusalema na se laulau ede kaiwa wa se kita meta ye wowoya yo ye pogi. ");
INSERT INTO sbe_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Saha ye tubu wa Petelo nuwana ne unai ye sae ede ye hededelau Yesu unai ye wane, “Labi, ku kitalau! Lahi kaiwa wa ku kawagulaiyei wa ye pogi.” ");
INSERT INTO sbe_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kabo Yesu ye hededelau udiyedi ye wane, “Yaubada kwa sunumaei. ");
INSERT INTO sbe_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya hededemamohoi: Ena hesau ye hededelau teina kuduli ta unai ye wane, ‘Ku tuudobiyego gabwa ne unai’, na nige ye nuwalabulabui, na ye sunuma mo bena yona kaibwada ne Yaubada kabo ye ginauli, meta kabo ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Unai ya hededelaowa, tapwalolo unai saha kwa kaibwadai na kwa sunumaei meta kwa hai, kabo Yaubada ye leyawa. ");
INSERT INTO sbe_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Na yomi huyatapwalolo unai, na ena yomi pilipili kami kahao hekadi udiyedi, bena kwa nuwatugabaeidi, metai kabo tamamiu galewa ne unai yomi yababa hinage ye nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kabo se lageꞌuyo Yelusalema unai na Yesu Numa Tabuna bakubakuna unai ye taitaihile ede taukaitalasam tauwoyaidi yo laugagayo taulauhekataena yo tamowai lakilakidi se laoma iya unai ");
INSERT INTO sbe_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na se henamaiyei se wane, “Gigibwali sahasahana unai teina laulau ta ku ginaulidi, yo kaiteya yom dudulai ne ye haiyawa?” ");
INSERT INTO sbe_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ye hededebui ye wane, “Kabo hinage henamai kesega ya henamaiyeigomiu. Na ena yogu kwa hedehedede, kabo hinage ya hededehemasalaha gigibwali sahasahana unai teina ginauli ta ya ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yowane yona gigibwali haedi ye hai na ye hebahebabatiso? Yaubada unai o tamowai udiyedi? Hage, yogu kwa hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Siya se bom se henahenamaiꞌuyoidi se wane, “Taba ta wane, ‘Yaubada unai ye hai’, iya kabo ye wane, ‘Ede ye saha to nige kwa kawamamohoiyei?’ ");
INSERT INTO sbe_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O taba ta wane, ‘Tamowai udiyedi’, kabo boda se heyababada.” Na boda se matausiyeidi, matawuwuna maudoidi Yowane se kitayako meta iya peloweta mamohoina. ");
INSERT INTO sbe_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Unai kabo se hededelau Yesu unai se wane, “Nige kabina ka kata.” Ede Yesu ye wane, “Unai yau hinage taba nige yomiu ya hedehedede gigibwali sahasahana unai ginauli ta ya ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na kabo Yesu ye hetubu ye hededepalabole tamowai lakilakidiyao wa kalidiwai ye wane, “Tamowai hesau wine koyana ye kumai, na ye ganahetakikili, wine kaniyodi kabatamtam ye ginauli, yo kabayaiyaiwa numana ye kabi. Na kabo yona wine koyana ye mosei taukitakitahetete hekadiyo kalidiwai na ye lau magai hesau keda lohaloha unai. ");
INSERT INTO sbe_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wine yona huyakaniyo ye lage ede yona heyayai tauhaina hesau ye hetamali ye lau taukitakitahetete wa kalidiwai bena koya tanuwagana yona wine kaniyodi ye haidi. ");
INSERT INTO sbe_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Taukitakitahetete wa heyayai tauhaina wa se kelebesi yo se pidili, na se hetamali ye uyo ma nimagaibuna. ");
INSERT INTO sbe_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Heyayai tauhaina hesau ye hetamaliꞌuyoi. Iya kuluna se koilapai yo se kabihenayaikaliliyei. ");
INSERT INTO sbe_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hinage hesau ye hetamaliꞌuyoi. Iya se koihemwaloi. Na gwaudi kabo ye hetamalidi se lau, meta hekadiyo se pidilidi yo hekadiyo se koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Laulau ta ye lau ee iya natuna tahunuwana ye bom mo maiyana se miyamiya. Na ye hetamalimulitai na ye nuwatui ye wane, ‘Yau natugu, unai kabo se hekasisiyei.’ Na ye lau. ");
INSERT INTO sbe_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Taukitakitahetete wa se kita ye laolaoma ede se koitalaliu se wane, ‘Teina ta koya tanuwagana natuna tahunuwana. Kwa laoma ta koihemwaloi, na yona gogo kabo ta hai yoda.’ ");
INSERT INTO sbe_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na se kelebesi yo se koihemwaloi na se gabadikwaei gana dagelana wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Koya tanuwagana kabo saha ye ginauli? Iya kabo ye laoma koya taukitakitahetetena wa ye unuhemwaloidi, na kabo wine koyana wa ye moselaei tamowai hekadi se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Komiu taba kabina kwa kata Buka Tabuna unai saha se kuli wa, ‘Taukabinuma weku se subuꞌusei wa meta ye hemala kabakabinuma wekuna namwanamwana yo saesaekalilina. ");
INSERT INTO sbe_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Teina ta meta Guiyau ye ginauli, na matadaena kitakitana meta ye namwakalili.’ ” ");
INSERT INTO sbe_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu yona palabole wa Dius yodi tamowai lakilakidiyao wa se nuwatulobai meta siya kadi hedehedede, unai bena se kabihekahini. Iyamo boda wa se matausiyeidi, unai ede se laugabaei. ");
INSERT INTO sbe_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kabo Paliseya tamowaidi yo Heloda yona tamowai hekadi se hetamalidi se lau Yesu unai yona hedehedede unai bena se hekalabesibesi. ");
INSERT INTO sbe_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Se lage iya unai kabo se wane, “Taulauhekata, kabina ka kata meta kowa ku dudulai. Tamowai nige ku matausiyeidi, matawuwuna tamowai nige ku hekasisigaibuidi. Na Yaubada yona keda mamohoina mo ku lauhekataei. Ye dudulai kabo takisi ka mosei Sisa unai o nige? ");
INSERT INTO sbe_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kabo ka tole o tabu ka toletole?” Yodi kailupolupo Yesu ye kita na ye wane, “Idohagi to bena kwa lautonogigau? Hage, denali hesau kwa leyama ya kita.” ");
INSERT INTO sbe_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ede denali hesau se mosei Yesu unai. Ye kaikewai na ye wane, “Teina kaiteya kana kao yo hesana?” Se wane, “Sisa.” ");
INSERT INTO sbe_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kabo Yesu ye hededelau udiyedi ye wane, “Saha Sisa yona, kwa mosei Sisa unai, na saha Yaubada yona, kwa mosei Yaubada unai.” Hedehedede wa se lapui ede se nokoeikaliliyei. ");
INSERT INTO sbe_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusiya tamowaidi yodi nuwatu tauboiboita taba nige se toloꞌuyoma. Na se laoma Yesu se henamaiyei se wane, ");
INSERT INTO sbe_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Taulauhekata, Mose yona kulikuli unai ye wane, ena tamowai hesau ye boita, na mwanena ye miyamiya, na nige natunao, meta bena kana kaha hesau kwabulina ne ye tawasolai na natunao ye labasidi, kabo se hemala kana kaha wa natunao. ");
INSERT INTO sbe_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Huya hesau tamowai hesau natunao loheloheyao badodi haligigi-labui. Taubaguna ye tawasola, nige natunao, na ye boita. ");
INSERT INTO sbe_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kana kaha helabuina kwabuli wa ye tawasolai. Iya hinage nige natunao, na ye boita. Na hehaiyonadi ye tawasolai wa gonogonowana. ");
INSERT INTO sbe_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yodi haligigi-labui waihiu kesegana wa se tawasolai, na nige natudiyao. Waihiu wa kabo hinage ye boita. ");
INSERT INTO sbe_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Unai yoma henamai ede teina: Badodi haligigi-labui wa meta waihiu wa se tawasolai, na toloꞌuyoma unai waihiu wa kabo kaiteya mwanena?” ");
INSERT INTO sbe_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ye hededelau udiyedi ye wane, “Komiu kwa nuwapwanopwanokalili matawuwuna kulikuli tabudi yo Yaubada yona gigibwali nige kabidi kwa kata. ");
INSERT INTO sbe_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Huyana tauboiboita se toloꞌuyoma taba nige se tawasola yo taba nige se hetahetawasola. Na siya kadi kao kabo doha galewa aneludiyao. ");
INSERT INTO sbe_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na tauboiboita yodi toloꞌuyoma Mose yona buka unai saha ye kuli wa kwa hasili e nige? Temenai, Yaubada ye taumasalaha kaiwa hesau unai na kana kao doha kaiwa ye kalapulupululu. Na ye hededelau Mose unai ye wane, ‘Yau Abelahama yona Yaubada, yo Isako yona Yaubada, yo Yakobo yona Yaubada.’ ");
INSERT INTO sbe_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaubada ta iya nige tauboiboita yodi Yaubada, na iya taumaumauli mo yodi Yaubada. Komiu nuwamiu se pwanopwanokalili.” ");
INSERT INTO sbe_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na laugagayo taulauhekataena hesau ye laoma ede saha se hetahetaladi wa ye lapuidi. Ye nuwatulobai meta Yesu hedehedede namwanamwadi ye hedededi udiyedi, ede ye henamai Yesu unai ye wane, “Mose yona laugagayo maudoidi udiyedi meta sahasahana ye baguna ede?” ");
INSERT INTO sbe_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ye wane, “Teina laugagayo saesaekalilina ede: ‘Isalaela tamowaidi, kwa lapulapui! Guiyau yoda Yaubada, iya Guiyau kesega mo. ");
INSERT INTO sbe_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guiyau yom Yaubada ku gadosisiyei ma nuwam maudoina, ma yaluwam maudoina, yom nuwanuwatu maudoina unai, yo ma bayaom maudoina.’ Teina ta laugagayo bagubagunana. ");
INSERT INTO sbe_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Helabuina ede teina: ‘Kowa helem taumiya tamowaina ku gadosisiyei, doha ku bom ku gadosisiyeigo.’ Teina laugagayo labui ta se saekalili na kabo hekadi wa.” ");
INSERT INTO sbe_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na kabo laugagayo taulauhekataena wa ye wane, “Tanuwaga, saha ku hedede wa meta ye dudulai. Ye mamohoikalili meta Yaubada kesega mo, na nige Yaubada hesau, iya ye bom mo Yaubada. ");
INSERT INTO sbe_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yaubada bena ta gadosisiyei ma nuwada maudoina, yo ma sonogada maudoina, yo ma bayaoda maudoina. Yo heleda taumiya tamowaina bena ta gadosisiyei, doha ta bom ta gadosisiꞌuyoida. Teina laugagayo ta se saekalili ede, na kabo kaitalasam gabugabudi yo kaitalasam hekadi.” ");
INSERT INTO sbe_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu ye kita meta tamowai wa ye sibasiba, unai ye wane, “Kowa Yaubada yona basileiya ku hanahanawuiyako.” Mulina ne unai nige hesau ye nuwabayao bena kalinawai henamai hesau ye henamaiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kabo Yesu Numa Tabuna bakubakuna unai ye laulauhekata na ye henamaiyeidi ye wane, “Matawuwuna saha to laugagayo taulauhekataena se hedede bena Keliso meta Dawida natuna? ");
INSERT INTO sbe_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yaluwa Tabuna yona gigibwali unai Dawida ye hedede ye wane, ‘Guiyau ye hededelau yogu guiyau unai ye wane, “Nimatutuguyena ku tuli ye lau ee kam waiunu ya toledi kaem guninaena na se hemala kaem kabatoledi.” ’ ");
INSERT INTO sbe_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawida Keliso hesana ye katai Guiyau. Na komiu yomi nuwatu saha, idohagi na iya hinage Dawida natuna?” Bodalakilaki wa se lapui meta nuwadi se namwa. ");
INSERT INTO sbe_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yona lauhekata wa unai Yesu hinage ye wane, “Laugagayo taulauhekataena bena kwa kitanamwanamwaedi. Yodi taitaihile udiyedi se henuwa bena kwama lohalohadi se luwuidi yo kabalokulokune bakubakudi udiyedi bena tamowai se lautokiyeidi ma hekasisidi, ");
INSERT INTO sbe_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","yo hinage sunago yo kabakaikaigogo udiyedi kabatuli saesaedi se henuwadi. ");
INSERT INTO sbe_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na kwabukwabuli yodi numa se lupohaidi, yo yodi tapwalolo se helohadi bena kabo tamowai se nokoeidi. Tamowaidiyao ne Yaubada kabo ye hekamkamnakaliliyeidi.” ");
INSERT INTO sbe_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kabo Yesu ye tuli moni kabaꞌusaꞌusa dedekadiwai na ye kaikaikewa na boda se monimonitole. Tamowai monimonidi yodi moni lakilakidi se usaidi kabaꞌusaꞌusa wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na kabo kwabuli dehadehana hesau ye laoma, na pene gagilidi labui ye usaidi. Pene labui wa lakidi meta se gagilikalili. ");
INSERT INTO sbe_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu yona hekahekatao ye yoganeidima na ye hededelau udiyedi ye wane, “Ya hededemamohoi: Teina kwabuli dehadehana ta kainauya lakilakikalilina ye tole, na kabo maudoidi ne. ");
INSERT INTO sbe_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Matawuwuna ede siya yodi moni lakilakidi udiyedi na kabo hisa mo se haidi na se toledi, na iya yona deha unai yona moni maudoina kalinawai wa ye tolehegehe.” ");
INSERT INTO sbe_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu maiyana hekahekatao Numa Tabuna unai se pesa, na yona hekahekatao wa hesau ye hededelau unai ye wane, “Tanuwaga, numa lauyahidi ne wekudi woiyawaꞌudoidi ne sola ku kitadi yo hinage numa namwamuyomuyoudi ne!” ");
INSERT INTO sbe_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ye wane, “Teina numa yo woyo lakilakidi maudoidi ta kwa kitadi. Taba nige weku hesau ye kaitalae yona hali weku kewanaena na maudoidi ne kabo se ulugwaligwali.” ");
INSERT INTO sbe_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Muliyena kabo Olibe koyana unai Yesu maiyana hekahekatao se tutuli na Numa Tabuna se kaikaikewalaei. Na Petelo, Yamesi, Yowane yo Andeleya se bom se laoma Yesu unai na se henamaiyei se wane, ");
INSERT INTO sbe_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Taba yomai ku hedehedede, teina ginauli ta kaiuyana kabo se tubu, yo hekihekinoidi saha udiyedi bena ka kitalobai meta kabo se masalaha?” ");
INSERT INTO sbe_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ye wane, “Kwa kitakitanamwanamwa! Tabu tamowai se lupohaigomiu. ");
INSERT INTO sbe_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tamowai se bado kabo hesaguyena se laoma na se wane, ‘Yau Keliso ede,’ na tamowai gwaudi se lupohaidi. ");
INSERT INTO sbe_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Huyana iyala wasadiyao yo hinage iyala wasalupolupodiyao kwa lapuidi, tabu kwa matausi. Teina ginaulidi ta kabo se tubu, na tanoubu ta yona huyagehe meta sola. ");
INSERT INTO sbe_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Boda hesau kabo boda hesau se lulululuꞌuyoidi, basileiya hesau yo basileiya hesau kabo se haiꞌiyaꞌiyalaꞌuyoidi. Yo mwanikuniku teha udoiꞌudoi udiyedi yo hasahasali hinage. Hekihekinoi ta yodi tubutubu meta kana kao doha sine diyadiyakana ye hetubu bena ye labalaba. ");
INSERT INTO sbe_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Komiu kwa kitakitanamwanamwaegomiu! Tamowai kabo se laegomiu magai babadadiyao udiyedi, yo sunago kalodiyena kabo se pidiligomiu. Yau debaguwai kabo se woyalaegomiu kwa tolo gabana yo wasawasa matadiyena, na bena kabo Yaubada yona basileiya wasana kwa hededehemasalaha siya kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na bagubaguna teina wasa namwanamwana ta bena kwa lauguguyaei basileiya maudoidi udiyedi, na kabo tanoubu yona huyagehe. ");
INSERT INTO sbe_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na huyana se kabihekahinigomiu yo se laegomiu kabalauhetala udiyedi, meta tabu kwa nuwanuwatu kabo hedehedede saha udiyedi kwa hedehedede, na saha Yaubada ye leyawa ne unai kwa hedehedede, matawuwuna komiu taba nige kwa bom yomi nuwanuwatuyena kwa hedehedede, na Yaluwa Tabuna kabo ye hekatagomiu na kwa hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tamowai kabo yona saeya kana ye walohai, yo tama kabo natuna kana ye walohai. Natu kabo se tolo na sinadiyao yo tamadiyao se hewaiunudi na se mosegabaeidi tauꞌunuhemwaloidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tamowai maudoidi kabo se subugomiu yau debaguwai. Na kaiteya ye tolobayao ye lau ee pilipili ne sigadi unai, Yaubada iya kabo ye hemauli.” ");
INSERT INTO sbe_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na kabo Yesu ye wane, “Ginauli hesau nuwamatamatausina, iya magai tauheyababana, kabo kwa kita ye totolo nige yona kabatolo mamohoina unai – kulikuli ta tauhasilina bena ye nuwatulobai! Huyana ne unai teha Yudeya unai taumiya taba se wasabu se lau kuduli udiyedi se kenowadam. ");
INSERT INTO sbe_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kaiteya yona numa kewana unai na ye pesadobi bena ye yabubu meta tabu ye mwalaesae numa kalona unai bena gogo hesau ye hai. ");
INSERT INTO sbe_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hinage kaiteya yona koya unai ye paipaisowa, tabu ye uyo yona numa unai kana kwama hesabana. ");
INSERT INTO sbe_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tenem huyana ne unai sinesineo diyadiyakadi yo labalabahauhaudi ya katekamkamnaedi matawuwuna kabo ye pilipilikalili kalidiwai! ");
INSERT INTO sbe_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Na taba kwa tapwatapwalolo bena yomi huyawasabu ne tabu huyagwagwama unai. ");
INSERT INTO sbe_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Matawuwuna tenem mayadaidi ne udiyedi kabo kamkamna lakilakina ye tubu. Yaubada tanoubu yona huyaginaulina wa unai na ye laoma ee teina nige kamkamna hesau doha tenem, yo hinage taba nige ye tubuꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tenem mayadaidi ne, ena Guiyau nige ye hekubwadi, taba nige tamowai hesau gonowana mauli ye lobai. Na yona kaisunuwa tamowaidi hesabadi kabo huya ne ye hekubwadi. ");
INSERT INTO sbe_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tenem huyana ne unai, ena tamowai hesau ye hededelaowa kalimiuwai ye wane, ‘Kwa kaikewa inai! Keliso ede teinai!’, o ‘Kwa kaikewalau, Keliso ede temenai!’, yona hedehedede ne tabu kwa kawakawamamohoiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Matawuwuna ede Keliso lupolupodi yo peloweta lupolupodi kabo se masalahama. Siya kabo hekihekinoi yo laulau gigigigibwalidi se ginaulidi na udiyedi bena tamowai se lupohaidi, yo hinage se kaipate bena Yaubada yona kaisunuwa tamowaidi se lupohaidi, iyamo nige gonowadi. ");
INSERT INTO sbe_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Unai kwa kitakitanamwanamwa! Ginauli maudoidi ta ya hededenonohaidiko kalimiuwai, unai kwa lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Na kabo Yesu ye wane, “Kamkamnalakilaki mayadaidi ne gehedi ne unai ‘kabo mahana ye masigili yo waikena kabo nige ye dawaya, ");
INSERT INTO sbe_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","galewa ne kipwaladi kabo se beku, yo galewa ginaulidi yodi kabamiya Yaubada kabo ye nukuidi.’ ");
INSERT INTO sbe_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na tamowai maudoidi kabo Tau Natuna se kita yada ne unai ye laoma ma gigibwalina yo ma didigana. ");
INSERT INTO sbe_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iya yona anelu kabo ye hetamalidi se lau yaumai hasi yodi kabalaoma udiyedi, yo tanoubu yo galewa kadi sigasiga udiyedi kabo yona kaisunuwa tamowaidi se woyagogoidima.” ");
INSERT INTO sbe_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na kabo Yesu ye wane, “Bosibosi heyaheyasonina hedehededena ne kwa kitalau unai, kabo ye hekatagomiu. Huyana lagadi ne udiyedi se bwagu, kabo lugudi se laukaladi, meta kabina kwa kata ede yaikini huyana ye hanahanauma. ");
INSERT INTO sbe_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Doha hinage, huyana teina ginauli maudoidi ta kabo kwa kitadi se tubu, meta kwa nuwatui yo kabo kabina kwa kata meta Tau Natuna ye hanahanaumako, iya ede kawakeda ne unai. ");
INSERT INTO sbe_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya hededemamohoi: Teina isi ta taba nige ye gehe ye lau ee teina ginauli maudoidi ta se tubu. ");
INSERT INTO sbe_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Galewa yo tanoubu kabo se gehe, na yogu hedehedede ta taba nige se gehe.” ");
INSERT INTO sbe_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Na kabo Yesu ye wane, “Mayadaina yo mahanana ne nige hesau kabina ye kata. Galewa aneludi yo Natuna hinage nige kabina se kata, na Tamana ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Komiu bena kwa kitanamwanamwa yo kwa nonononoha, matawuwuna Yaubada yona kaisunuwa mahanana ne nige kabina kwa kata. ");
INSERT INTO sbe_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iya ede doha teina: Tamowai hesau yona numa ye laugabaei ye lau magai kedalohaloha unai. Yona heyayai tauhaidi ye toledi yona numa se kitahetete. Hesau to hesau yodi gigibwali yo yodi paisowa ye moseidi, na keda taukitahetetena ye hededelau unai bena ye silasilawa. ");
INSERT INTO sbe_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Unai bena huya maudoina kwa silasilawa, matawuwuna numa tanuwagana yona huyaꞌuyoma nige kabina kwa kata, nuwana kabo meimeilahi, o boniyai duwaduwalina, o pwaole se doudou, o malatomtom gagilina unai. ");
INSERT INTO sbe_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yona uyoma ne unai tabu bena ye lobaigomiu kwa kenokeno. ");
INSERT INTO sbe_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hedehedede ta ya hedede kalimiuwai yo tamowai maudoidi udiyedi ya hededelau ya wane, ‘Bena kwa silasilawa yo kwa nonononoha!’” ");
INSERT INTO sbe_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mayadai labui mo na kabo Taukiuli yo Pwalawa Nige Yistina Henuwaisinidi, na taukaitalasam tauwoyaidi yo laugagayo taulauhekataena keda se wasenei meta kailupolupo sahasahana unai kabo Yesu se hai bena se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na se wane, “Tabu henuwaisini mayadaidi ne udiyedi, madai boda se luluida.” ");
INSERT INTO sbe_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tenem huyana ne Yesu Betaniya unai. Simona hesana hesau Taulepela yona numa unai se kaikaigogo. Na waihiu hesau ye laoma yausi panepanena pakuna alabasata unai se ginauli ye bahei. Yausi panepanena wa nadi unai se ginauli yo maisana ye lakikalili. Waihiu wa yausi pakuna wa kabo gadona ye kesihai na yausi wa ye ini Yesu kuluna unai. ");
INSERT INTO sbe_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na tamowai hekadi se koipili, unai se gadigadigugu se wane, “Idohagi to yausi ne ye kaiheyai? ");
INSERT INTO sbe_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Taba ye lokunei, denali badodi 300 ye haidi, kabo ye moseidi tamowai dehadehadi yodi.” Na waihiu wa se dilai. ");
INSERT INTO sbe_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na Yesu ye wane, “Waihiu me kwa kitagabaei! Ye saha to kwa kitaheyababa? Iya laulau namwanamwana ye ginauli kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Huya badobado tamowai dehadehadi kabo maiyamiu, unai huya hekadi kabo kwa nuwatuidi na kwa kainauyaidi. Na yau meta huya badobado taba nige maiyamiu. ");
INSERT INTO sbe_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Laulau saha gonowana ye ginauli meta ye ginauli, na ye namwa. Taugu ye heyausi meta ye kabinonohaigau yogu huyaboita hesabana. ");
INSERT INTO sbe_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya hededemamohoi: Kaiyaulina maudoina ta unai, ena haedi wasa namwanamwana ta se lauguguyaei, meta waihiu ta saha ye ginauli ta wasana kabo hinage se hedehededei, iya kabanuwanuwatuina.” ");
INSERT INTO sbe_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na Yudasi Isakaliyota, iya Saudoudoi-labui wa hesau, kabo ye lau taukaitalasam tauwoyaidi udiyedi bena Yesu kana ye walohai. ");
INSERT INTO sbe_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yona hedehedede se lapui meta se gwauyala, na se hededehesunuma kabo moni se mosei. Unai kabo Yudasi ye hetubu keda ye wase idohagi kabo Yesu ye moselaei kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na kabo Pwalawa Nige Yistina Henuwaisinina mayadaina bagubagunana unai Dius yodi laulau bena Taukiuli mamoena se kaitalasamyei, unai Yesu yona hekahekatao se henamaiyei se wane, “Haedi ku henuwagai bena kabo kada Taukiuli kaina ka kabinonohai?” ");
INSERT INTO sbe_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Unai yona hekahekatao labui ye hetamalidi se lau Yelusalema, na ye hededelau udiyedi ye wane, “Kwa lau magailaki ne unai, kabo loheya hesau ye lobaigomiu, iya waila pakuna ye bahei. Tamowai ne kwa hemuliwatani ");
INSERT INTO sbe_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ee ye mwalaesae numa hesau unai. Temeta numa ne tanuwagana kabo kwa henamaiyei kwa wane, ‘Tanuwaga taumana dahalana ye henamaiyei bena unai maiyana hekahekatao Taukiuli kaina se kai.’ ");
INSERT INTO sbe_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iya kabo numa heisi helabuina unai dahala lakilakina hesau ye hekitagomiu. Dahala ne unai ginauli maudoidi ede nonohadi. Temenai kada kai kwa kabinonohai.” ");
INSERT INTO sbe_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yona hekahekatao wa se lau magai wa unai se lage, na Yesu saha ye hedededi wa meta se lobaidi gonogonowana. Unai kabo Taukiuli kaina se kabinonohai. ");
INSERT INTO sbe_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Meimeilahina ne unai Yesu maiyana Saudoudoi-labui wa se lagelau numa wa unai. ");
INSERT INTO sbe_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Siya sola ma kaikaidi na Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuwai: Luwamiu ta unai hesau maiyagu ka kaikaikesega, iya kabo kagu ye walohai.” ");
INSERT INTO sbe_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kabo se nuwayababakalili na kesega kesega Yesu se henamaiyei se wane, “Nuwana yau?” ");
INSERT INTO sbe_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na ye hededelau udiyedi ye wane, “Iya meta Saudoudoi-labui ta luwamiu ne unai. Tamowaina ede maiyagu kama pwalawa ka hedakwadobiyei gaeba kesega unai. ");
INSERT INTO sbe_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tau Natuna kabo ye boita doha se kuliyako wa. Na yababa mo kabo ye talu Tau Natuna kana tauwalohaina ne unai. Taba ye namwa mo iya tabu se labasi.” ");
INSERT INTO sbe_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sola ma kaikaidi na Yesu pwalawa ye hai, Yaubada ye lautokiyei, na kabo ye kihi na ye moseidi yona hekahekatao kalidiwai na ye wane, “Kwa hai na kwa kai! Teina ta yau taugu.” ");
INSERT INTO sbe_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na kabo waina keyakana hinage ye hai, Yaubada ye lautokiyei, na ye mosei kalidiwai. Na maudoidi unai se numa. ");
INSERT INTO sbe_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na Yesu ye wane, “Teina ta yau kwasinagu ye didi tamowai maudoidi hesabadi. Kwasinagu unai Yaubada yona talam hauhauna ye hemamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya hededelaowa kalimiuyena: Wine kaniyona masina taba nige ya numaꞌuyoi ye lau ee Yaubada yona basileiya unai kabo waina hauhauna ya numaꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kabo wanalautoki hesau se wanai, na kabo se dalahai se lau Olibe koyana unai. ");
INSERT INTO sbe_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kabo Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Maudoimiu kabo kwa laugabaegau, matawuwuna Buka Tabuna unai se kuliyako, ‘Mamoe taukitahetetedi kabo ya unuhemwaloi, na yona mamoe yawoina kabo se wasabugwaligwali.’ ");
INSERT INTO sbe_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na yogu toloꞌuyo mulina ne unai kabo ya bagunaegomiu ya lau Galili.” ");
INSERT INTO sbe_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na Petelo ye hededelau Yesu unai ye wane, “Nuwana maudoidi kabo se laugabaego, na yau taba nige.” ");
INSERT INTO sbe_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ye hededelau unai ye wane, “Ya hededemamohoi: Teina boniyai ta unai kabo ku uhalaegau ma haiyona, na kabo pwaole hakiyana ye dou helabuina.” ");
INSERT INTO sbe_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na Petelo ye hedehededebayao ye wane, “Ena yau maiyam kabo ta boita, iyamo taba nige ya uhalaego.” Na yona hekahekatao maudoidi wa yodi hedehedede kesega. ");
INSERT INTO sbe_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na kabo se lage teha hesau unai hesana ede Getesemani, na Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Teinai kwa babawa, na ya lau ya tapwalolo.” ");
INSERT INTO sbe_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na Petelo, Yamesi yo Yowane ye yoganeidi na maiyanao se lau, na kabo ye hetubu ye nuwakamkamna yo nuwana ye dagugu ");
INSERT INTO sbe_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na ye wane, “Nuwagu ta ye kamkamnakalili gonowana kabo unai ya boita. Teinai kwa miyamiya na kwa silasilawa!” ");
INSERT INTO sbe_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu ye tausigilau na ye guliyaboyabomdobi bwatano unai na ye tapwalolo taba kamkamna mahanana ne tabu ye hekalo. ");
INSERT INTO sbe_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na ye wane, “Aba, Tamagu, kowa gonowam ginauli maudoidi ku ginaulidi. Teina kamkamna keyakana ta ku laehesuwala. Iyamo yogu nuwanuwatu ta tabu ku ginauli, na kowa yom nuwanuwatu mo ku ginauli.” ");
INSERT INTO sbe_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na kabo Yesu ye uyoma na ye lobaidi meta se kenoko. Na ye hededelau Petelo unai ye wane, “Simona, nige gonowana awa kesega ku silasilawa? ");
INSERT INTO sbe_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kwa silasilawa yo kwa tapwatapwalolo, na taba nige noho kwa hekalo na unai kwa beku. Yaluwamiu ta se talam, na iyamo taumiu ta se basabasa.” ");
INSERT INTO sbe_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu kabo ye uyo ye tapwalolo na yona kaibwada wa kesekesegana mo. ");
INSERT INTO sbe_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na ye uyoma ye lobaiꞌuyoidi ma kenodi, matawuwuna ede kamnadi se yababakalili na nige kabina se kata kabo saha se hedede iya unai. Kabo Yesu ye uyo ye tapwaloloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na hehaiyonana unai Yesu ye uyoma na ye hededelau udiyedi ye wane, “Komiu sola kwa kenokeno yo kwa kaikaiyawasi? Nabada! Mahana ye lageko! Tau Natuna kana tauwalohai kabo iya ye moselaei yababa tamowaidiyao nimadiyena. ");
INSERT INTO sbe_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kwa tolo na ta lau! Kagu tauwalohai meta ye lageko.” ");
INSERT INTO sbe_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu sola ma hedehededena, na Yudasi, iya Saudoudoi-labui wa hesau, ye laoma na bodalakilaki maiyanao. Siya taukaitalasam tauwoyaidi yo laugagayo taulauhekataena yo magai babadadiyao se hetamalidi se lau ma kelekelepadi yo yodi kepata se baheidi. ");
INSERT INTO sbe_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bagubaguna, tauwalohai wa hekihekinoi ye hededehesibasibanonohaidiko ye wane, “Tamowai ya simtai ne meta iya yomi tamowai. Kwa hai na kwa kitahetete na kwa woyahesuwala.” ");
INSERT INTO sbe_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudasi kabo ye dudulai ye lau Yesu unai na ye wane, “Labi!”, na ye simtai. ");
INSERT INTO sbe_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na kabo boda wa Yesu se hai. ");
INSERT INTO sbe_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na tamowai hesau Yesu maiyana se totolo wa kelepa ye niusi na ye heguli ede taukaitalasam saesaena yona heyayai tauhaina hesau beyana ye bolihai. ");
INSERT INTO sbe_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu ye hededelau boda wa udiyedi ye wane, “Yau doha taukaikaigahu, na kelebesigau hesabana kwa laoma meta ma kelekelepamiu yo kepata kwa baheidi? ");
INSERT INTO sbe_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mayadai badobado yau maiyamiu ta miyamiya yo Numa Tabuna bakubakuna unai ya laulauhekata, na nige kwa kabihekahinigau. Na saha se kuliyako Buka Tabuna unai, taba ye laoma ye hemamohoiyei.” ");
INSERT INTO sbe_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na Yesu yona hekahekatao maudoidi wa se laugabaei na se wasabugwaligwali. ");
INSERT INTO sbe_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hewali hesau temenai, kaleko maisa lakilakina ye likwa na iya Yesu ye hemuhemuliwatani. Iya hinage bena se kabihekahini, ");
INSERT INTO sbe_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na kana kaleko wa nimadiwai se kabikabi, na iya ma taugaibuna ye wasabu. ");
INSERT INTO sbe_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na kabo Yesu se woyalaei taukaitalasam saesaena yona numa unai. Menai taukaitalasam tauwoyaidi, tamowai lakilakidi yo laugagayo taulauhekataena maudoidi se koigogo. ");
INSERT INTO sbe_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Boda wa dageladi unai Petelo ye laoma ede ye mwalaesae taukaitalasam saesaena yona numa wa bakubakuna unai. Menai taukaitalasam saesaena yona taupaisowa tamowaidi maiyanao se tuligogoi na se kaimwaiga. ");
INSERT INTO sbe_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na kabo taukaitalasam tauwoyaidi yo Sunedeli tamowaidi maudoidi Yesu kana mata se wasenei na bena se unuhemwaloi. Iyamo nige kana mata saha hesau se lobai. ");
INSERT INTO sbe_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tamowai se bado se hededelupolupo na Yesu se hegilu, na yodi hedehedede wa nige kesega. ");
INSERT INTO sbe_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na kabo hekadi se tolo Yesu kana gilu se hededelupolupo na se wane, ");
INSERT INTO sbe_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Iya doha teina ye hedede na ka lapui ye wane, ‘Teina Numa Tabuna tamowai nimadiyena se ginauli ta, yau kabo ya koigwaligwali, na mayadai haiyona unai kabo hesau ya hetoloꞌuyoi, iya nige tamowai nimadiyena se ginauli.’” ");
INSERT INTO sbe_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na iyamo yodi hedehedede wa nige gonogonowadi. ");
INSERT INTO sbe_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na kabo taukaitalasam saesaena wa ye tolo duwaduwalidiwai na Yesu ye henamaiyei ye wane, “Nige gonowana ku hededebui? Teina tamowai ta kam hedehedede maudoidi se hedededi ta mamohoidi o nige?” ");
INSERT INTO sbe_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na Yesu ye mwanomwanou na nige saha hesau ye hedede. Taukaitalasam saesaena kabo ye henamaiꞌuyo ye wane, “Kowa Keliso, Saesaekalilina natuna?” ");
INSERT INTO sbe_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kabo Yesu ye hededebui ye wane, “Yau Kelisona ede. Na Tau Natuna kabo kwa kita Yaubada Saesaekalilina nimatutuna unai ye tutuli yo hinage galewa yadadi udiyedi ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kabo taukaitalasam saesaena wa ye bom kana kwama ye pulisidi na ye wane, “Taba nige tamowai hesau ta waseneiꞌuyoi na bena ye hedehedede teina tamowai ta hesabana! ");
INSERT INTO sbe_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yona hededeheyababa kwa lapuidiko. Na yomi hineli doha saha?” Na maudoidi se talam meta iya yababa ye ginauli, unai taba ye boita. ");
INSERT INTO sbe_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na kabo hekadi iya se kaikaisoi yo matana se suma kabo nimadi se nokudi na se biteli na se wane, “Hage, ku hededehemasalaha kaiteya ye biteligo?” Na kabo taukaitalasam saesaena yona taupaisowa Yesu se hai na hinage se biteli. ");
INSERT INTO sbe_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petelo sola numa bakubakuna wa unai na taukaitalasam saesaena yona heyayai tauhaina waihiuna hesau ye laoma. ");
INSERT INTO sbe_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na Petelo ye kita ye kaikaimwaiga ede ye kitanamwanamwaei na kabo ye hededelau unai ye wane, “Kowa hinage Yesu Nasaleta tamowaina wa maiyam.” ");
INSERT INTO sbe_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na Petelo ye uhala ye wane, “Saha ku hedehedede me nige kalikalili kabina ya kata.” Na kabo ye sigilau gana kawamatana dedekanawai. Na pwaole hakiyana ye dou. ");
INSERT INTO sbe_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na temenai heyayai tauhaina waihiuna wa ye kitaꞌuyoi ede ye hededelau tautotolo wa udiyedi ye wane, “Teina tamowai ta meta siya kadi kaha hesau.” ");
INSERT INTO sbe_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na iya ye uhalaꞌuyo. Huyakubwakubwa mo kabo tautotolo temenai wa se hededelau unai se wane, “Mamohoi, kowa kadi kaha hesau, matawuwuna kowa Galili tamowaina.” ");
INSERT INTO sbe_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petelo kabo ye bom ye hededeheyababaꞌuyoi na ye kaigwala ye wane, “Temeta tamowai me yau nige kabina ya kata.” ");
INSERT INTO sbe_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na kabo pwaole hakiyana ye dou helabuina. Mahanana ne unai Yesu yona hedehedede wa Petelo nuwana ne unai ye sae, doha teina, “Sola nige kamkam hakiyana ye dou ma labui, na kowa kabo ku uhalaeigau ma haiyona.” Unai nuwana ye kamkamnakalili na ye doumwalomwaloi. ");
INSERT INTO sbe_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Malatomtom gagilina unai kabo taukaitalasam tauwoyaidi maiyadi tamowai lakilakidi yo laugagayo taulauhekataena yo Sunedeli maudoidi yodi hineli se ginauli. Na kabo Yesu nimana se paidi na se woyai se lau na se moselaei Pilato unai. ");
INSERT INTO sbe_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Yesu ye henamaiyei ye wane, “Kowa Dius tamowaidi yodi wasawasa?” Yesu ye hededebui ye wane, “Aa, saha ku hedede ne mamohoi.” ");
INSERT INTO sbe_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na kabo taukaitalasam tauwoyaidi yodi hedehedede udoiꞌudoi udiyedi Yesu se hegilukaliliyei. ");
INSERT INTO sbe_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Unai Pilato Yesu ye henamaiꞌuyoi ye wane, “Kowa nige kalinam? Siya hedehedede udoiꞌudoi udiyedi se hegilugo.” ");
INSERT INTO sbe_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu nige saha hesau ye hedede, unai Pilato ye nokokalili. ");
INSERT INTO sbe_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bolimai badobado Taukiuli Henuwaisinina huyana unai Pilato yona laulau meta taba Dius tamowaidi numatutugudu tamowaina hesau se kaibwadai, kabo ye yailigabaei. ");
INSERT INTO sbe_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tenem huyana ne unai taukaiunu hesau hesana Balabasi numatutugudu unai ye miyamiya. Iya ma kana kahao maiyadi gabemani se haikabi, na tamowai hekadi se koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bodalakilaki se lagegogoi Pilato unai na se kaibwadai bena Taukiuli Henuwaisinina unai na laulau saha ye ginaginauli wa bena ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ye henamaiyeidi ye wane, “Kwa henuwa bena Dius yodi wasawasa ya yailigabaei kalimiuwai?” ");
INSERT INTO sbe_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na ye henamaiyeidi, matawuwuna ye nuwatulobaiyako meta taukaitalasam tauwoyaidi wa Yesu se kaikalomagigiliyei na debanawai se moselaei iya unai. ");
INSERT INTO sbe_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Taukaitalasam tauwoyaidi boda se henuwasaedi na se kaibwada Pilato unai bena Balabasi ye yailigabaei. ");
INSERT INTO sbe_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na Pilato ye henamaiyeidi ye wane, “Saha kabo ya ginauli teina tamowai ta unai, iya kwa katai ede Dius yomi wasawasa?” ");
INSERT INTO sbe_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na se yogasae se wane, “Ku hesatauloyawa!” ");
INSERT INTO sbe_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kabo ye henamaiꞌuyo ye wane, “Matawuwuna saha? Yababa sahasahana ye ginauli?” Siya kabo se yogalakilaki se wane, “Ku hesatauloyawa!” ");
INSERT INTO sbe_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ye henuwa bena boda wa ye henuwanamwadi, unai Balabasi ye yailigabaei. Na kabo ye hedede yona iyala tamowaidi Yesu se pidili wipi unai na mulinaena kabo ye moselaei na se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na kabo iyala tamowaidi Yesu se woyalaei Pilato yona numa bakubakuna unai na kadi kahao se yogagogoidima. ");
INSERT INTO sbe_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Siya kabo kwama pulupululuna kana kao doha wasawasa kana kwama se baheiyama na Yesu se heluwui na kaiwa gwaligwalina laganao se heidi doha kolona na se henabai. ");
INSERT INTO sbe_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na se laulautokiyei se wane, “Dius yodi wasawasa miyamiyahaina, yauwedo!” ");
INSERT INTO sbe_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kuluna ne didiyali unai se pidili yo se kaikaisoi, na se tulibono iya talanuwana ne unai na se talatalawasiyei. ");
INSERT INTO sbe_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Se talawasikaiyawasi kabo kwama pulupululuna wa se haigabaei na kana kwama wa se helikwaꞌuyoidi. Na kabo se woyalaei Yelusalema dagelanawai bena se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yelusalema se hetubu bena se laugabaei na tamowai hesau hesana Simona se lobai koya unai ye uyoma. Iya Sailini tamowaina, Alekisenda yo Lupuso tamadi. Iyala tamowaidi wa Simona se lauhelili ede Yesu yona sataulo ye bahei. ");
INSERT INTO sbe_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu se woyai se laei teha hesau hesana Golagota, kaniyona ede mwayalu magaina. ");
INSERT INTO sbe_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kabo mulo yo waina se hebwalikesegaidi na se mosei bena ye numa, na ye laukwatakwata. ");
INSERT INTO sbe_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na kabo se hesataulo. Tauhesataulona wa Yesu yona kaleko se hinelidi na se kaiheyaidi kaiteya kabo yona saha ye hai. ");
INSERT INTO sbe_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Malatomtom awa hehaligigi-hasina unai Yesu se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yodi kabahegiluna hedehededena wa se kuli molumolu hesau unai na se pawatisae kulubawana wa unai. Kulikuli wa doha teina, “DIUS YODI WASAWASA.” ");
INSERT INTO sbe_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Laulau yabayababadi tauginaginaulidi labui se hesataulodi iya maiyanao, hesau kahatuna unai na hesau seuseulina unai. ");
INSERT INTO sbe_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Keda unai tamowai se sae yo se dobi na se hagahagasiyei yo se kulukulukwadei na se wane, “Amokisa! Kowa bena Numa Tabuna tauhetatagwaligwalina, na mayadai haiyona unai kabo ku hetoloꞌuyoi wa! ");
INSERT INTO sbe_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hage, ku hemauliꞌuyoigo na sataulo me unai ku pesadobima!” ");
INSERT INTO sbe_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yo hinage taukaitalasam tauwoyaidi yo laugagayo taulauhekataena iya se talatalawasiyei se wane, “Tamowai hekadi ye saguidi, na nige gonowana ye bom ye saguꞌuyoi! ");
INSERT INTO sbe_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ye hedehedede bena iya Keliso, yo kita Isalaela yoda wasawasa. Taba sataulo ne unai ye pesadobima, kabo ka kita yo ka kawamamohoiyei.” Tamowai labui maiyanao se hesataulodi wa Yesu hinage se hagahagasiyei. ");
INSERT INTO sbe_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mayamayadailaki unai magai wa maudoina ye masigili ye lau ee meimeilahi awa hehaiyonana unai. ");
INSERT INTO sbe_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mahanana ne unai Yesu ye yoga ma kalinalakilakina ye wane, “Eloi, eloi, lama sabatani?”, kaniyona ede, “Yogu Yaubada, yogu Yaubada, idohagi to ku nuwagabaegau ta?” ");
INSERT INTO sbe_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na dedekana unai tautotolo hekadi kalinana se lapui ede se wane, “Kwa lapui! Iya Eliya ye yogayoganei.” ");
INSERT INTO sbe_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kabo tamowai hesau ye heloi ye lau balo ye hedakwa winega unai, na ye paihepatu didiyali unai, na kabo ye helelesae Yesu unai bena ye numa, na ye wane, “Hage ta kita, kabo Eliya ye laoma na sataulo unai ye haigabaei.” ");
INSERT INTO sbe_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ye yoga ma kalinalakilakina, na kabo yawasina ye pito. ");
INSERT INTO sbe_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tenem mahanana ne unai meta Numa Tabuna woyona kaleko ye taigalilabuiyei kewa unai ye dobi guni. ");
INSERT INTO sbe_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iyala taubagunaena tamowaina Yesu yona sataulo dedekana ne unai ye totolo, na huyana kalinana ye lapui yo ye kita idohagi ye boita meta ye wane, “Mamohoi, teina tamowai ta iya Yaubada Natuna!” ");
INSERT INTO sbe_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waiwaihiuwo hekadi kedalohawai se kitakitalau. Luwadi ne unai meta Maliya, Magadala waihiuna, yo Maliya Yamesi gagilina maiyana Yose sinadi, yo Salome. ");
INSERT INTO sbe_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Huyana Yesu Galili unai meta se hemuliwatani yo se kitahetete. Yo sinesineo gwaudi Yesu maiyanao se saema Yelusalema wa, siya hinage temenai. ");
INSERT INTO sbe_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yelusalema unai Alimatiya tamowaina hesau hesana Yosepa. Iya Sunedeli kadi boda saesaena hesau yo Yaubada yona basileiya ye nayanayai. Yesu yona huyaboita mayadaina ne meta kabinonoha mayadaina, na mulina ne unai kabo Sabati. Mahana ye duitalu na sola kabo Sabati hekasisina ye hetubu na Yosepa ma nuwabayaona ye lau Pilato unai na Yesu tauna ye kaibwadai. ");
INSERT INTO sbe_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesu yona boita wa wasana Pilato ye lapui meta ye siliyata na nige ye kawamamohoi. Unai iyala taubagunaena tamowaina wa ye yoganei na ye henamaiyei. ");
INSERT INTO sbe_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato hedehedede wa ye lapui meta mamohoi, unai Yesu tauna ye talamgabaei kabo Yosepa ye hai. ");
INSERT INTO sbe_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosepa kabo kaleko posiposina ye hemaisa na kabo ye lau Yesu tauna ye taluhidobiyei na kaleko wa unai ye suma, na ye tole bwayabwaya unai. Na kabo weku lakilakina ye builae bwayabwaya duhana wa ye buigudui. ");
INSERT INTO sbe_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadala waihiuna maiyana Maliya Yose sinana se kita haedi Yosepa Yesu tauna ye tole. ");
INSERT INTO sbe_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabati mayadaina gehena unai Maliya Magadala waihiuna, Maliya Yamesi sinana, yo Salome se lau yausi panepanedi se hemaisadi bena kabo Yesu se heyausi. ");
INSERT INTO sbe_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sabati hauhauna ne mayadaina bagubagunana unai, malatomtom mahana ye dalasae kabo se dalahai se lau Yesu bwayabwayana unai. ");
INSERT INTO sbe_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na se bom se henahenamaiꞌuyoidi se wane, “Bwayabwaya kawamatana unai kabaguduna wekuna wa kabo kaiteya ye buihesuwala?” ");
INSERT INTO sbe_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na bwayabwaya wa unai se lage na se kitalau ede bwayabwaya guduna weku lakilakina wa se kita meta kawamata wa dedekanawai. ");
INSERT INTO sbe_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na kabo se lusae bwayabwaya kalona wa unai na hewali hesau se kita, meta se matausi. Kana kwama posiposina na ye tutuli tehakahakahatu unai. ");
INSERT INTO sbe_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na ye hededelau udiyedi ye wane, “Tabu kwa matausi! Yesu Nasaleta tamowaina se hesatauloyako wa kwa wasewasenei. Yaubada ye hetoloꞌuyoiyako. Sola kabatolena wa kwa kita, iya nige inai. ");
INSERT INTO sbe_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na kwa lau yona hekahekatao yo Petelo yodi kwa hedehedede kwa wane, ‘Yesu kabo ye baguna ye lau Galili. Temenai kabo iya kwa kita doha ye hededenonohaiyako.’” ");
INSERT INTO sbe_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Waiwaihiuwo wa se matausikalili yo se tabutabubu, unai bwayabwaya wa se pesagabae na se wasabu se lau. Na nige tamowai hesau yona se hedehedede, matawuwuna ede se matausikalili. ");
INSERT INTO sbe_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sabati wa mayadaina bagubagunana malatomtom gagilina unai Yesu ye toloꞌuyo na ye taumasalahabaguna Maliya Magadala waihiuna unai. Huya bagubagunana unai yaluwa yabayababadi haligigi-labui Yesu ye hededehepesadi waihiuna ne unai. ");
INSERT INTO sbe_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya kabo ye lau Yesu yona hekahekatao wa yodi ye hedehedede. Siya meta sola ma nuwadubudi yo ma doudoudi. ");
INSERT INTO sbe_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na wasa wa se lapui meta Yesu ye mauliꞌuyoko na Maliya iya ye kitayako, na iyamo nige se kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na kabo Yesu kana kao udoi unai ye taumasalaha tauhemuliwatanina labui udiyedi huyana se laulau magai hesau unai. ");
INSERT INTO sbe_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Siya kabo se uyo Yelusalema unai kadi kahao wa yodi se hedehedede, na hinage nige se kawamamohoiyeidi. ");
INSERT INTO sbe_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na huyana Saudoudoi-kesega wa ma kaikaidi kabo Yesu ye taumasalaha udiyedi. Na ye dilaidi, matawuwuna se nuwakwailolo yo nige se kawamamohoi taukitana wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na ye hededelau udiyedi ye wane, “Kwa lau magai maudoidi kaiyaulina ta unai na wasa namwanamwana ta kwa lauguguyaei tamowai maudoidi kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kaiteya ye kawamamohoiyeigau yo babatiso ye hai meta Yaubada kabo iya ye hemauli. Na kaiteya nige ye kawamamohoiyeigau, Yaubada kabo ye hekamkamna. ");
INSERT INTO sbe_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Taukawamamohoiyeigau ne kabo teina laulau ta se ginaulidi Yaubada yona gigibwali unai: Yau hesaguwai kabo yaluwa yabayababadi se hededehepesadi tamowai udiyedi. Yo kalina hekadi nige kabidi se kata kabo udiyedi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Siya kabo mwata kaikaikalasidi nimadi udiyedi se haidi, yo ena kaikailewa se numa, taba nige se boita. Yo ena nimadi se tolesaedi taukasikasiyebwa udiyedi, kabo se namwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guiyau Yesu yona hedehedede gehena unai meta kabo Yaubada iya ye hai ye saei galewa. Temenai Yaubada nimatutuna unai ye tuli. ");
INSERT INTO sbe_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesu yona hekahekatao kabo se lau magai maudoidi se tauhetakikilidi na se lauguguya tamowai maudoidi kalidiwai. Na Guiyau maiyadi, yo yodi lauguguya ye hemamohoiyedi laulau gigigigibwalidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Taubada Teopilo! Tamowai gwaudi se kaipate bena ginauli Yaubada ye ginaulidi luwadaena wa se kulidobiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Saha se kuli wa meta iya ede huya bagubagunana unai ginauli maudoidi taukitadi wa se wasaduwaiyei na se hekawa ye dobima kalidaena. ");
INSERT INTO sbe_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na yau ginauli maudoidi ta ya kitahekasadiko, kabahetubu unai ye lau gehena. Unai ya nuwatui ye namwa mo taba yau hinage wasa ta ya kulihekasa kowa yom, taubada saesaekalilina, ");
INSERT INTO sbe_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","to bena kabina ku kata ginauli saha se hekatago wa meta se mamohoikalili. ");
INSERT INTO sbe_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heloda yona huyawasawasa Yudeya tanona unai meta taukaitalasam hesau hesana Sakaliya. Iya meta taukaitalasam kadi boda gagilina hesana Abidiya tamowaina hesau. Sakaliya ma mwanena Elisabeta kadi mumuga ede Aloni. ");
INSERT INTO sbe_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Taudi labui wa yodi miyamiya se dudulai Yaubada matanaena, yo Guiyau yona laugagayo yo kabikabi maudoidi se miyawataninamwanamwaedi. ");
INSERT INTO sbe_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na nige natudi, matawuwuna Elisabeta ye kobosi yo ye sinesinebadako, yo hinage Sakaliya ye tautaubadako. ");
INSERT INTO sbe_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Huya hesau Sakaliya kana boda yodi huyapaisowa Numa Tabuna unai, na iya kaitalasam paisowana ye ginauli Yaubada matanaena. ");
INSERT INTO sbe_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Taukaitalasam wa kadi kulutubu kabikabina unai yodi kaisunuwa se ginaginauli, ede Sakaliya ye hai bena kabo ye lusae Guiyau yona Numa Tabuna kalona ne unai na inisenisi ye gabu. ");
INSERT INTO sbe_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na inisenisi huyagabuna unai bodalakilaki Numa Tabuna bakubakuna wa unai se tapwatapwalolo. ");
INSERT INTO sbe_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na Guiyau yona anelu ye taumasalaha iya unai, na inisenisi kabagabuna tehakahatuna unai ye totolo. ");
INSERT INTO sbe_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Huyana Sakaliya anelu wa ye kita meta ye siliyata yo ye matausikalili. ");
INSERT INTO sbe_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na anelu wa ye hededelau unai ye wane, “Sakaliya, tabu ku matausi! Yaubada yom tapwalolo ye lapuidiko. Unai mwanem Elisabeta kabo natumiu loheya ye labasi, na kabo hesana ku tole Yowane. ");
INSERT INTO sbe_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iya kabo nuwam ye henamwakaliliyei, na yona huyalabasi ne debanaena kabo tamowai gwaudi se gwauyala, ");
INSERT INTO sbe_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","matawuwuna iya meta ye saekalili Guiyau matanaena. Iya nige gonowana waina yo numanuma bayabayaodi ye numadi. Sola nige se labasi na Yaluwa Tabuna iya ye hemwayau. ");
INSERT INTO sbe_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na Isalaela tamowaidi bodalakilaki kabo ye woyaidi se uyoma Guiyau yodi Yaubada unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na Yaubada yaluwana yo yona gigibwali kabo Yowane unai gonogonowana doha Eliya, na unai kabo Guiyau yona keda ye bagunaei. Yona paisowa meta kabo tamadiyao ye henuwabuidi na se kitalau natudiyao udiyedi, yo kaiteyadi Yaubada taukawayagalaena kabo ye henuwatulobaidi na se lapulau tamowai dudulaidi yodi nuwatu sibasibadi udiyedi. Teina laulau ta ye ginaulidi bena tamowai gwaudi ye nonohaidi Guiyau yona laoma hesabana.” ");
INSERT INTO sbe_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya ye hededelau anelu wa unai ye wane, “Idohagi na kabo kabina ya kata meta teina ta mamohoi? Yau meta ya tautaubadako, yo mwanegu meta ye sinesinebadako.” ");
INSERT INTO sbe_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelu wa ye hededebui ye wane, “Yau Gabileli, Yaubada matanaena ya totolo, na ye hetamaligau ya laoma bena wasa namwanamwana ta yom ya hedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na kowa meta kalinagu nige ku kawamamohoiyeidi, unai kabo ku mwanou na nige gonowana ku hedehedede, kana siga yogu hedehedede ta se laoma se mamohoi yodi huya dudulaina unai.” ");
INSERT INTO sbe_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mahanana ne unai boda wa Sakaliya se nayanayai yo se nuwapwanopwano idohagi to ye miya huyalohaloha Numa Tabuna wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yona huyapesa ne unai meta nige gonowana ye hedehededelau udiyedi. Se nuwatulobai meta Yaubada tautau hesau ye hekitayako Numa Tabuna kalona ne unai. Hekihekinoi nimana udiyedi ye ginaulidi, na nige saha hesau ye hedede. ");
INSERT INTO sbe_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaliya yona paisowa mayadaidi wa se gehe ede ye uyo yona magai. ");
INSERT INTO sbe_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mulina ne unai kabo Elisabeta ye diyaka, na yona numa kalona ne unai ye miya nawalai haligigi, ");
INSERT INTO sbe_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","na ye wane, “Teina ta Guiyau ye ginauli kaliguyena! Teina huya ta unai yona kabinamwa unai ye kitagau na kagu mwadine tamowai matadiyena ne ye haigabaei.” ");
INSERT INTO sbe_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta yona diyaka nawalaina haligigi-kesega (6), kabo Yaubada yona anelu hesana Gabileli wa ye hetamali ye lau teha Galili magaina hesau, hesana ede Nasaleta. ");
INSERT INTO sbe_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Temenai hasala hesau nuwanuwasupuna. Iya se hededehepatuyako bena kabo tamowai hesau hesana Yosepa ye tawasolai, iya Dawida kana isimulita hesau. Hasala nuwanuwasupuna wa hesana ede Maliya. ");
INSERT INTO sbe_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anelu wa ye lau iya unai ye wane, “Yauwedo! Guiyau ede maiyam yo yona kabinamwa ye lakikalili kalimwai.” ");
INSERT INTO sbe_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya nuwana ye dagugukalili yona hedehedede wa unai, yo ye nuwanuwatu lautoki ta kaniyona ede saha. ");
INSERT INTO sbe_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na anelu wa ye hededelau unai ye wane, “Maliya, tabu ku matausi! Yaubada yona kabinamwa unai ye kaisunuwaigo. ");
INSERT INTO sbe_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kabo ku diyaka na natum loheya ku labasi, na hesana ku tole Yesu. ");
INSERT INTO sbe_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iya kabo ye saekalili yo se katai Yaubada Saesaekalilina Natuna. Na Guiyau Yaubada kabo iya kana kulutubu Dawida yona kabatuli saesaena ye mosei, ");
INSERT INTO sbe_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","na kabo Yakobo kana isimulitao ye kitahetetedi ye lau ee nige kana siga, yo yona basileiya nige yona kabagehe.” ");
INSERT INTO sbe_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya ye henamai anelu wa unai ye wane, “Teina ta kabo idohagi? Yau meta waihiu nuwanuwasupuna, sola nige loheya hesau maiyagu ka hailobai.” ");
INSERT INTO sbe_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na anelu wa ye wane, “Yaluwa Tabuna kabo ye laowa kalimyena, yo Yaubada Saesaekalilina yona gigibwali kabo ye helogulogugo. Unai wawaya ku labasi ne meta iya Tabuna, yo iya kabo se katai Yaubada Natuna. ");
INSERT INTO sbe_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Keham Elisabeta ku kita! Iya ye sinesinebadako na iyamo ye diyaka na kabo natuna loheya ye labasi. Tamowai se hedede meta iya bena ye kobosi, na iyamo ye diyaka yona nawalai haligigi-kesega. ");
INSERT INTO sbe_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Matawuwuna nige saha hesau ye bayao Yaubada kalinawai.” ");
INSERT INTO sbe_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kabo Maliya ye wane, “Yau Guiyau yona heyayai tauhaina. Saha ku hedede me bena ye tubu kaliguyena.” Na kabo anelu wa ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nige bayaona na Maliya ye kabinonoha na ye laumwamwayau ye lau teha Yudeya magaina hesau unai, iya ede teha kudukudulina unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Temenai ye mwalae Sakaliya yona numa unai na Elisabeta ye hailobai. ");
INSERT INTO sbe_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Huyana Elisabeta Maliya yona lautoki ye lapui meta wawaya wa bogana luwanaena ye teteli. Yaluwa Tabuna Elisabeta ye hemwayau, ");
INSERT INTO sbe_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na ma kalina lakilakina unai ye wane, “Sinesineo maudoidi luwadiyena kowa meta Yaubada ye hededehenamwakaliliyeigo, yo natum bogam luwanaena ne Yaubada ye hededehenamwa! ");
INSERT INTO sbe_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na yau yogu namwa saha, na yogu Guiyau sinana ye laoma ye kaitaumanaigau! ");
INSERT INTO sbe_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Huyana yom lautoki wa ya lapui ede wawaya bogagu luwana unai ye teteli ma gwauyalana. ");
INSERT INTO sbe_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kowa gonowana ku gwauyala, matawuwuna ku kawamamohoi meta Yaubada yona hedehedede kalimyena wa kabo ye hemamohoiyeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Maliya ye wane, “Nuwagu ta unai Guiyau ya hedebasaei ");
INSERT INTO sbe_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na yaluwagu ta ye gwauyala Yaubada taugilihaigau debanaena, ");
INSERT INTO sbe_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","matawuwuna Yaubada iya yona heyayai tauhaina ta ye kita meta ya dobikalili. Huya ta yo huya matada ne unai tamowai maudoidi kabo se hedede meta yau gonowana ya gwauyala, ");
INSERT INTO sbe_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","matawuwuna Yaubada Gigigigibwalina ginauli saesaedi ye ginaulidi yau kaliguyena. Iya tabuna. ");
INSERT INTO sbe_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Isina to isina udiyedi yona katekamkamna ye hemasalaha tauhekasisiyeina udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iya yona gigibwaliyena ginauli saesaedi ye ginaulidi, na kaiteyadi se nuwasaesae meta ye hetatagwaligwalidi. ");
INSERT INTO sbe_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wasawasa saesaedi yodi kabatuli udiyedi ye toledobiyeidi, na tamowai dobidobidi ye lausinidi. ");
INSERT INTO sbe_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tauhasahasali nimadi ye hemwayaudi ginauli namwanamwadi udiyedi, na taugogogogo ye hetamalidi se dalahai ma nimagaibudi. ");
INSERT INTO sbe_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yona heyayai tauhaidi, siya ede Isalaela tamowaidi, ye saguidi, na yona hededehesunuma kada kulutubu kalidiyena ye nuwatui meta yona katekamkamna kabo ye hemasalaha kada mumuga Abelahama yo kana isimulita maudoidi udiyedi ye lau ee nige kana siga.” ");
INSERT INTO sbe_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya Elisabeta maiyana se bawa nawalai haiyona, na kabo ye uyo yona magai. ");
INSERT INTO sbe_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na Elisabeta yona huyalabalaba mayadaina ye lage, ede natuna loheya ye labasi. ");
INSERT INTO sbe_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dedekadiyena taumiya yo kehanao se lapui meta Guiyau yona katekamkamna lakilakina unai Elisabeta ye sagui, na maiyadi se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wawaya wa ye labasi sabati kesega ye lau kabo se laoma bena se hepelitome. Na se henuwa bena hesana se tole Sakaliya, tamana yona heliyam. ");
INSERT INTO sbe_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na sinana ye wane, “Nige! Hesana ede Yowane.” ");
INSERT INTO sbe_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Se hededelau Elisabeta unai se wane, “Kehamwao udiyedi nige hesau hesana Yowane!” ");
INSERT INTO sbe_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ede hekihekinoi se ginaulidi tamana wa unai na se henamaiyei kabo wawaya ne hesana saha ye henuwa bena ye tole. ");
INSERT INTO sbe_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaliya ye kaibwada bena kabakulikuli se mosei na ye kuli, “Hesana ede Yowane.” Na maudoidi wa se siliyata. ");
INSERT INTO sbe_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mahanana ne unai Yaubada Sakaliya kawana ye soke na ye hedehededeꞌuyo, na Yaubada ye hedehedebasaei. ");
INSERT INTO sbe_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na dedekadiyena taumiya maudoidi se siliyatakalili, na Yudeya teha kudukudulina maudoina unai taumiya ginauli maudoidi ta se hetahetaladi. ");
INSERT INTO sbe_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wasa wa taulapuina maudoidi nuwadi udiyedi se nuwanuwatuidi na se henahenamaiꞌuyoidi se wane, “Wawaya ne ye tubusae kabo iya tamowai sahasahana?” Matawuwuna se kita meta Yaubada yona gigibwali ede iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yowane tamana Sakaliya Yaluwa Tabuna ye hemwayau na ye hededepeloweta, ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Guiyau ta hedebasaei, iya Isalaela yoda Yaubada! Matawuwuna ede ye laoma yona tamowai ye gilihaida. ");
INSERT INTO sbe_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Taugilihaida gigigigibwalina ye haiyama, iya ede yona heyayai tauhaina Dawida kana isimulita hesau. ");
INSERT INTO sbe_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Teina ta ye hededehemasalahayako yona peloweta tabudiyao udiyedi huya bagubagunana unai na se hededepelowetaiyako. ");
INSERT INTO sbe_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kabo ye gilihaida kada waiunu udiyedi, yo tauhewaiunu maudoidi nimadiyena ye saguhaida. ");
INSERT INTO sbe_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Laulau ta ye ginaulidi meta yona katekamkamna ye hemasalaha kada mumuga udiyedi yo yona talam tabuna ye nuwatui, ");
INSERT INTO sbe_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","iya ede yona kaigwala kada mumuga Abelahama unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Ye kaigwala kabo kada waiunu nimadiyena ye gilihaida, yo ye hebayaoda bena ma nuwaꞌaꞌada yo miyamiya dudulaidi udiyedi iya ta tabaꞌohui yoda mauli mayadaidi maudoidi udiyedi, na nige gonowana ta matausi. ");
INSERT INTO sbe_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na kowa, natugu, kabo se kataigo Yaubada Saesaekalilina yona peloweta, matawuwuna kabo Guiyau ku kedabagunaei bena yona kamwasa ku kabinonohai, ");
INSERT INTO sbe_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","yo yona tamowai ku hekatadi meta Yaubada yona kabagilihaidi kedana ede yodi yababa nuwatugabaedi unai. ");
INSERT INTO sbe_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yona katekamkamna nuwabigabigana debanawai Yaubada kabo ye saguida na Mesaiya galewa ne unai ye hetamaliyama kalidawai doha malatomtom unai mahana ye dalasae, ");
INSERT INTO sbe_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na mala ye hesina kaiteyadi masigili unai taumiya yo boita taumatausiyeina kalidiyena, na ye woyaida nuwadaumwali unai.” ");
INSERT INTO sbe_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wawaya wa ye tubusae yo yaluwa unai ye bayao, na balabalagaibuyena ye miya kana siga ye taumasalaha Isalaela udiyedi ye lauguguya. ");
INSERT INTO sbe_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tenem mayadaidi ne udiyedi Sisa Agastasi hekasa ye ginauli meta bena hasiliyawasi se ginauli Loma yodi kabatanuwaga magaina maudoina unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tenem meta hasiliyawasi bagubagunana. Yodi huyahaina ne unai meta Kiliniusi iya yona huyatanuwaga teha Siliya unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na tamowai maudoidi se uyo yodi magai mamohoidi udiyedi na hesadi se mosemoseidi hesa taukuliyawasidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ede Yosepa maiyana Maliya hinage se dalahai na teha Galili magaina Nasaleta se laugabae se lau teha Yudeya magaina Betelehema unai. Matawuwuna Yosepa iya Dawida kana isimulita hesau, yo Betelehema iya ede wasawasa Dawida yona kabalaoma. ");
INSERT INTO sbe_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Se lau menai bena Maliya maiyana hesadi se kulidi hasiliyawasi bukana unai. Na Maliya meta se hededehepatuyako Yosepa unai, iyamo sola nige se tawasola, na iya meta ye diyakako. ");
INSERT INTO sbe_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sola menai ma miyamiyadi na wawaya wa huyalabasina mayadaina ye lage, ");
INSERT INTO sbe_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","na natuna taubaguna ye labasi meta loheya. Kaleko udiyedi ye suma na suisui yodi kabakaikai hesau unai ye hekeno, matawuwuna nige dahala hesau ye miyagaibu numa wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mamoe taukitakitahetetedi hekadi se miyamiya magai wa dedekanaena, na yodi mamoe se kitakitahetetedi boniyaina wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na Guiyau yona anelu ye taumasalaha udiyedi na Guiyau didigana dawayana ye sinahetakikilidi, ede se matausikalili. ");
INSERT INTO sbe_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na anelu wa ye hededelau udiyedi ye wane, “Tabu kwa matausi. Wasa namwanamwana ya baheiyama kalimiuyena, iya kabo tamowai maudoidi ye hegwauyalakaliliyedi. ");
INSERT INTO sbe_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mayadai ta unai Dawida yona magai ta unai taugilihaigomiu se labasi, iya ede Keliso, yomi Guiyau. ");
INSERT INTO sbe_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wawaya ne yomi kabakitalobaina ede kabo kwa lobai kaleko udiyedi se suma na suisui yodi kabakaikai unai ye kenokeno.” ");
INSERT INTO sbe_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na makesega galewa aneludi se taumasalaha anelu bagubagunana wa maiyadi. Yaubada se hedebasaei se wane, ");
INSERT INTO sbe_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hedebasae maudoina ye lau Yaubada galewa ne unai, yo tanoubu ta unai nuwadaumwali ye lau yona gadosisi tamowaidiyao udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anelu wa se laugabaeidi se uyo galewa, na kabo mamoe taukitakitahetete wa se bom se hedehedede se wane, “Kwa laoma ta lau Betelehema, na saha ye tubu na Yaubada yoda ye hedehedede wa ta kita.” ");
INSERT INTO sbe_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na se laumwamwayau se lau, Maliya yo Yosepa se lobaidi yo wawaya wa se kita suisui yodi kabakaikai unai ye kenokeno. ");
INSERT INTO sbe_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wawaya wa se kita na mulinawai hedehededena anelu ye hedededi wa se hededehemasalahadi, ");
INSERT INTO sbe_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","na wasa wa taulapuina maudoidi se noko yodi hedehedede wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ginauli maudoidi wa Maliya nuwana ne unai ye toledi na ye nuwanuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na mamoe taukitakitahetete wa se uyo yodi mamoe udiyedi. Yaubada se hededetausae yo se hedehedebasae, matawuwuna ginauli maudoidi se lapuidi yo se kitadi wa meta gonogonowana doha saha anelu ye hedededi wa. ");
INSERT INTO sbe_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sabati kesega mulinaena kabo wawaya wa huyahepelitomena mayadaina, na hesana se tole Yesu. Hesa ta anelu ye mosei sinana unai na kabo ye diyaka. ");
INSERT INTO sbe_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Maliya yona lauheꞌaꞌa kaitalasamna huyana ye laoma ede Yosepa yo Maliya Yesu maiyadi se lau Yelusalema, bena Yesu se mosei Guiyau unai, yo Maliya yona lauheꞌaꞌa kaitalasamna se ginauli. Kabikabi ta udiyedi Guiyau yona laugagayo se ginauliwatani, ye wane, “Natumiyao loheloheyao bagubagunadi, siya bena Guiyau yona.” Yo hinage ye wane, “Ena waihiu hesau ye labalaba kabo bunebune labui o gabubu labui” ye baheidima Numa Tabuna unai na yona lauheꞌaꞌa kaitalasamna ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Huyana ne unai meta tamowai hesau hesana Simiyona Yelusalema unai ye miyamiya. Iya meta laulaududulai tamowaina yo Yaubada yona laugagayo taulauwatanidi, yo Isalaela saguhaina ye nayanayai, yo Yaluwa Tabuna iya maiyana. ");
INSERT INTO sbe_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Yaluwa Tabuna ye hemasalahayako iya unai meta taba nige ye boita kana siga Guiyau yona kaisunuwa tamowaina ye kita. ");
INSERT INTO sbe_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yaluwa yona woya unai Simiyona ye lusae Numa Tabuna bakubakuna unai. Na Maliya yo Yosepa natudi wa se baheiyama Numa Tabuna unai bena laugagayo kabikabina se ginauli iya hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kabo Simiyona wawaya wa ye hai ye labasi na Yaubada ye lautokiyei ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Guiyau, yom hededehesunuma yom heyayai tauhaina unai wa ye masalahako. Unai gonowana kabo ya boita ma nuwadaumwaligu. ");
INSERT INTO sbe_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Matawuwuna ede teha maudoina tamowaidiyao matadiyena yom kabihemauli ku kabinonohai wa meta yau matagu ta udiyedi ya kitayako: ");
INSERT INTO sbe_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iya dawayana kabo yom nuwatu ye hemasalaha dagela tamowaidiyao udiyedi, yo kam bodao Isalaela hekasisidi ye helaki tamowai matadiyena.” ");
INSERT INTO sbe_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wawaya hedehededena wa sinana yo tamana se lapui meta se noko. ");
INSERT INTO sbe_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na Simiyona ye hededehenamwadi na ye hededelau Maliya Yesu sinana unai ye wane, “Wawaya ta Yaubada ye kaisunuwai bena iya debanaena Isalaela tamowaidiyao se bado kabo Yaubada se laugabaei, yo se bado kabo se uyoma Yaubada unai. Iya Yaubada yona hineli tauhededehemasalahadi, iyamo tamowai kabo se laukwatakwataei. ");
INSERT INTO sbe_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Teina unai ede tamowai yodi nuwanuwatu wadawadamdi kabo ye hemasalahadi. Na nuwakamkamna kana kao doha kelepa matamatana kabo kowa nuwam ne ye gwali.” ");
INSERT INTO sbe_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Temenai hinage peloweta hesau sinesinebadana, hesana ede Ana, Penuweli natuna, na Penuweli kana kulutubu ede Asa. Ana meta ye tawasola na ma mwanena se miya bolimai haligigi-labui (7), na kabo mwanena ye boita, ");
INSERT INTO sbe_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","na ye kwabuli ye miya ye lau yona bolimai 84. Iya Numa Tabuna nige ye laulaugabaei, na mayadai yo boniyai Yaubada ye hedehedebasaei kaikaihudi yo tapwalolo udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yosepa yo Maliya siya sola menai na Ana ye laoma kalidiwai. Yona lautoki ye mosei Yaubada unai, na wawaya wa hedehededena ye hedehededei tamowai maudoidi, siya kaiteyadi Yelusalema tauyailigabaeina se nayanayaei wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Huyana Yosepa yo Maliya ginauli maudoidi Guiyau yona laugagayo ye hedehededeidi wa se ginaulihegehedi meta se uyo yodi magai Nasaleta teha Galili unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wawaya wa ye tubusae yo ye bayao, yo sibasiba ye hemwayau. Na Yaubada yona kabinamwa meta iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bolimai kesega kesega Yesu tamana yo sinana se laulau Yelusalema Taukiuli Henuwaisinina hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Huyana Yesu yona bolimai 12, ede kadi kulutubu kabikabina wa unai iya maiyadi se lau henuwaisini ne hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Taukiuli Henuwaisinina mayadaidi se gehe ede tamana yo sinana se dalahai bena se uyo yodi magai, na nige kabina se kata meta wawaya wa ye babawa Yelusalema unai. ");
INSERT INTO sbe_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yodi nuwatu bena iya kadi kahao wa maiyanao se lau. Mayadai lohaloha se lauyei, na kabo se hetubu kehadiyao yo kadi kahao udiyedi se wasenei. ");
INSERT INTO sbe_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na nige se lobai, ede se uyo Yelusalema na temenai se wasenei. ");
INSERT INTO sbe_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mayadai hehaiyonana unai Yesu se lobai Numa Tabuna bakubakuna unai taulauhekata maiyanao se tutuli, na ye lapulapulau udiyedi yo ye henahenamaiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Taulapulapui maudoidi wa se siliyata yona nuwatulobai yo yona hededebui wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Huyana tamana yo sinana iya se lobai meta se nokokalili. Sinana ye hededelau unai ye wane, “Natugu, idohagi to teina doha ku ginauli kalimaiyena? Tamam yo yau meta ka nuwanuwatukalili yo ka wasewaseneigo.” ");
INSERT INTO sbe_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na Yesu ye wane, “Matawuwuna saha to kwa wasewaseneigau? Bena kabina kwa kata meta yau taba Tamagu yona numaena.” ");
INSERT INTO sbe_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na yona hedehedede wa kaniyona nige se nuwatulobai. ");
INSERT INTO sbe_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na kabo Yesu tamana yo sinana maiyanao se uyo Nasaleta, na yona kawakabi wa se miyakesegaidi. Na Yesu saha ye ginaulidi yo ye hedededi wa meta sinana nuwana ne unai ye nuwanuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu ye tubusaema bayao yo sibasiba udiyedi na Yaubada yo tamowai iya se kitahenamwa. ");
INSERT INTO sbe_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Loma yodi Sisa Taibiliyasi yona huyawoyawoya bolimaina 15 ye lagema, iya ede huyana Pontiusi Pilato iya teha Yudeya yodi gabana, yo Heloda iya wasawasa teha Galili unai, yo kana kaha Pilipo iya wasawasa Ituliya yo Talakoniti tehadi udiyedi, yo Lisaniyasi meta teha Abilene yodi wasawasa, ");
INSERT INTO sbe_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Dius yodi taukaitalasam saesaedi ede Anase yo Kaiyapasi. Tenem huyana ne unai Yowane Sakaliya natuna balabalagaibu unai ye miyamiya na Yaubada ye hededelau iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ede ye lau Yolidani sagasagana tehana maudoina ye tauhetakikili na ye lauguguya meta tamowai bena se nuwabui na babatiso se hai, yodi yababa nuwatugabaedi hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Doha Aisaiya peloweta yona buka unai ye kulinonohaiyako ye wane, “Tamowai hesau balabalagaibu unai ye yogayoga ye wane, ‘Guiyau yona keda kwa kabinonohai! Yona kabalau kwa kabihedudulaidi. ");
INSERT INTO sbe_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gonu maudoidi kwa hemwayaudi, yo kuduli maudoidi kwa kelihedudulaidi. Keda youyoudi bena kwa hedudulaidi, yo keda tupitupidi kwa hesapusapudi. ");
INSERT INTO sbe_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na tamowai maudoidi kabo Yaubada yona kabihemauli se kita.’” ");
INSERT INTO sbe_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bodalakilaki se lage Yowane unai bena ye hebabatisoidi, na ye hededelau udiyedi ye wane, “Komiu mwata natunao! Kaiteya ye hededelaowa bena kabo Yaubada yona hekamkamna kwa yabubugabaei? ");
INSERT INTO sbe_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Taba nuwabui kaniyona kwa miyahemasalahadi! Na tabu kwa wane, ‘Kama kulutubu meta Abelahama.’ Yomiu ya hedehedede: Yaubada gonowana weku ne udiyedi Abelahama kana isimulita ye hetubudi. ");
INSERT INTO sbe_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na kilam ye nonohaiyako na kaiwa wuwuna unai ye tole. Ena kaiwa hesau nige ye kaniyonamwanamwa kabo ye koigabaei na ye tulaei kaiwa kalakalasina unai.” ");
INSERT INTO sbe_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Boda wa Yowane se henamaiyei se wane, “Saha kabo ka ginauli?” ");
INSERT INTO sbe_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yowane ye hededebui ye wane, “Ena hesau kalimwai lulu labui meta bena hesau ku mosei tamowai hesau iya nige yona lulu unai. Yo ena kai kalimyena bena hinage ku kainauya.” ");
INSERT INTO sbe_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi tautanotano hekadi hinage se laoma Yowane unai bena se babatiso. Na se henamai se wane, “Taulauhekata, saha kabo ka ginauli?” ");
INSERT INTO sbe_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yowane ye hededelau udiyedi ye wane, “Tabu tamowai udiyedi takisi kwa tanotanodikwa.” ");
INSERT INTO sbe_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na kabo tauꞌiyala hekadiyo hinage iya se henamaiyei se wane, “Na kai kabo saha ka ginauli?” Na ye wane, “Tabu tamowai kwa hegilugaibuidi na kwa lauhelilidi bena moni se haidiwa, na nuwamiu mo se namwa maisamiu ne unai.” ");
INSERT INTO sbe_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tamowai maudoidi wa Keliso yona huyalaoma se nayanayakaliliyei, na se hetubu se nuwanuwatu nuwana Yowane iya Keliso ede. ");
INSERT INTO sbe_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na Yowane ye hededelau maudoidi wa udiyedi ye wane, “Yau waila unai ya hebabatisoigomiu. Na tamowai hesau kabo ye laoma, iya yona gigibwali ye saekalili na kabo yau, na yau nige yogu namwa gonogonowana bena kana sendolo mainadi ya yailidi. Iya kabo Yaluwa Tabuna yo kaiwa kalakalasina udiyedi ye hebabatisoigomiu. ");
INSERT INTO sbe_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yona kabahesuhesuluisini kaikaiwana meta iya nimanaena, bena witi ye hesuluisinidi yo ye hinelidi. Kaniyona kabo ye toledi sanalaena, na mosomosodiyao kabo ye gabudi kaiwa kalakalasina unai nige yona kababoso.” ");
INSERT INTO sbe_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hedehedede kadi kao udoiꞌudoi udiyedi Yowane ye guguyaidi yo wasa namwanamwana ye duwai tamowai udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yo wasawasa Heloda ye dilai, matawuwuna kana kaha mwanena Helodiyasi ye kwayai, yo yababa hekadi ye ginaulidi wa debadiyena. ");
INSERT INTO sbe_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na Heloda yona yababa kabahelakidi ede Yowane ye tole numatutugudu unai. ");
INSERT INTO sbe_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tamowai se bado Yowane ye hebabatisoidi, yo hinage Yesu ye hebabatisoi. Huyana ne unai Yesu ye tapwatapwalolo na galewa ye tasoke ");
INSERT INTO sbe_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Yaluwa Tabuna ye dobima kewana ne unai kana kao doha bunebune, yo kalina hesau galewa ne unai ye dobima ye wane, “Kowa Natugu! Ya gadosisikaliliyeigo yo nuwagu ku henamwakaliliyei!” ");
INSERT INTO sbe_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Huyana Yesu yona paisowa ye hetubu meta yona bolimai 30 ye hanahanawui. Na tamowai yodi nuwatu ede Yesu iya Yosepa natuna. Na Yosepa tamana ede Heli. ");
INSERT INTO sbe_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tamana ede Matati, Matati tamana ede Lewi, Lewi tamana ede Meleki, Meleki tamana ede Yanai, Yanai tamana ede Yosepa, ");
INSERT INTO sbe_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepa tamana ede Matatiyasi, Matatiyasi tamana ede Amosi, Amosi tamana ede Nahuma, Nahuma tamana ede Esili, Esili tamana ede Nagai, ");
INSERT INTO sbe_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tamana ede Mati, Mati tamana ede Matatiyasi, Matatiyasi tamana ede Semeina, Semeina tamana ede Yoseki, Yoseki tamana ede Yoda, ");
INSERT INTO sbe_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda tamana ede Yowanani, Yowanani tamana ede Lesa, Lesa tamana ede Selubabela, Selubabela tamana ede Seyalatiyela, Seyalatiyela tamana ede Neli, ");
INSERT INTO sbe_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli tamana ede Meleki, Meleki tamana ede Adi, Adi tamana ede Kosam, Kosam tamana ede Elimadam, Elimadam tamana ede Elu, ");
INSERT INTO sbe_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Elu tamana ede Yosuwa, Yosuwa tamana ede Eliyesa, Eliyesa tamana ede Yolim, Yolim tamana ede Matati, Matati tamana ede Lewi, ");
INSERT INTO sbe_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi tamana ede Simiyona, Simiyona tamana ede Yuda, Yuda tamana ede Yosepa, Yosepa tamana ede Yonam, Yonam tamana ede Eliyakima, ");
INSERT INTO sbe_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakima tamana ede Meleya, Meleya tamana ede Mena, Mena tamana ede Matati, Matati tamana ede Natani, Natani tamana ede Dawida, ");
INSERT INTO sbe_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawida tamana ede Yese, Yese tamana ede Obedi, Obedi tamana ede Bowasi, Bowasi tamana ede Salamona, Salamona tamana ede Nasona, ");
INSERT INTO sbe_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasona tamana ede Aminadaba, Aminadaba tamana ede Lam, Lam tamana ede Heselona, Heselona tamana ede Pelesi, Pelesi tamana ede Yuda, ");
INSERT INTO sbe_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda tamana ede Yakobo, Yakobo tamana ede Isako, Isako tamana ede Abelahama, Abelahama tamana ede Tela, Tela tamana ede Nahola, ");
INSERT INTO sbe_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahola tamana ede Seluga, Seluga tamana ede Leu, Leu tamana ede Pelega, Pelega tamana ede Ebeli, Ebeli tamana ede Sela, ");
INSERT INTO sbe_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela tamana ede Kainani, Kainani tamana ede Apasada, Apasada tamana ede Sema, Sema tamana ede Nowa, Nowa tamana ede Lameka, ");
INSERT INTO sbe_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameka tamana ede Metusela, Metusela tamana ede Enoka, Enoka tamana ede Yaledi, Yaledi tamana ede Mahalalela, Mahalalela tamana ede Kenani, ");
INSERT INTO sbe_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani tamana ede Enosi, Enosi tamana ede Seta, Seta tamana ede Adama, na Adama tamana ede Yaubada. ");
INSERT INTO sbe_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Yaluwa Tabuna ye hemwayau, na Yolidani sagasagana ye laugabaei na Yaluwa Tabuna iya ye woyalaei balabalagaibuyena. ");
INSERT INTO sbe_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na temenai mayadai 40 luwadiyena diyabolo Yesu ye laukita. Mayadaidi ne udiyedi meta nige saha hesau ye kai, na mulina ne unai ye hasali. ");
INSERT INTO sbe_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na diyabolo ye hededelau Yesu unai ye wane, “Ena kowa Yaubada Natuna, ku hededelau weku ta unai bena ye hemala pwalawa.” ");
INSERT INTO sbe_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na Yesu ye hededebui ye wane, “Buka tabuna unai se kuliyako meta tamowai nige gonowana pwalawa mo unai ye maumauli.” ");
INSERT INTO sbe_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na kabo diyabolo Yesu ye woyasaei kuduli hesau unai na mahana kubwakubwa unai tanoubu ta yona basileiya maudoidi ye hekita. ");
INSERT INTO sbe_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na ye hededelau unai ye wane, “Yau kabo wasawasa gigibwalina yo didigana ya lediwa kalimyena na basileiya maudoidi ta ku kitahetetedi. Matawuwuna ginauli maudoidi ta Yaubada ye ledimako yau yogu, na gonowana ya mosegabaedi yogu kaisunuwa tamowaina unai. ");
INSERT INTO sbe_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ena ku tabaꞌohu kaliguwai, kabo ginauli maudoidi ta kowa yom.” ");
INSERT INTO sbe_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ye hededebui ye wane, “Buka tabuna unai se kuliyako meta, ‘Guiyau yom Yaubada ye bom mo ku hekasisiyei, yo iya ye bom mo unai ku tabaꞌohu.’” ");
INSERT INTO sbe_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na kabo diyabolo Yesu ye woyalaei Yelusalema. Na Numa Tabuna isuna saesaekalilina unai ye hetolo na ye hededelau unai ye wane, “Ena kowa Yaubada Natuna, kabo inai ku kamposidobi. ");
INSERT INTO sbe_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Matawuwuna Buka Tabuna unai se kuli se wane, ‘Yaubada kabo ye hededelau yona anelu udiyedi na se kitahetetego. ");
INSERT INTO sbe_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kabo nimadiyena se kabisinigo, na nige gonowana kaem ku koiyedi weku udiyedi.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Yesu ye hededebui ye wane, “Buka Tabuna ye wane, ‘Tabu Guiyau yom Yaubada ku lautonogi.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diyabolo laukita maudoidi ta ye hegehedi ede Yesu ye laugabaei na huya namwanamwana hesau ye nayanayai. ");
INSERT INTO sbe_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yaluwa Tabuna yona gigibwali Yesu ye hemwayau na ye uyo Galili. Na Yesu wasana magai maudoina wa ye hetakikili. ");
INSERT INTO sbe_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na ye lau yodi sunago udiyedi ye lauhekata na boda maudoina iya se hededetausaei. ");
INSERT INTO sbe_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu ye lau yona kabatubusae magaina Nasaleta na yona kabikabi unai Sabatiyena ye lusae sunago unai na ye tolo bena Buka Tabuna ye hasili. ");
INSERT INTO sbe_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na peloweta Aisaiya yona buka se mosei na ye soke ede kulikuli ta ye lobai: ");
INSERT INTO sbe_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Guiyau yaluwana, iya ede yau kaliguyena, matawuwuna iya ye kaisunuwaigau yo ye heyausigau bena wasa namwanamwana ya hededehemasalaha taudehadeha udiyedi. Ye hetamaligau bena yailihai hedehededena ya hedehededei kaukau tamowaidiyao udiyedi, yo taumatagibugibu yodi ya hedehedede meta matadi bena se lala, yo tamowai se kabihenayaidi bena ya gilihaidi, ");
INSERT INTO sbe_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","yo bena ya hededehemasalaha meta Guiyau yona katekamkamna bolimaina ede ye lageko.” ");
INSERT INTO sbe_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu buka wa ye noku na ye moseꞌuyoi sunago taukitahetetena wa unai na ye tuli. Sunago wa unai tamowai maudoidi matadiyao meta se tolekesegaidi iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na Yesu ye hededelau udiyedi ye wane, “Kulikuli ya hasili kwa lapui wa meta mayadai ta unai ye masalaha matamiuyena.” ");
INSERT INTO sbe_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Maudoidi wa iya se hededehenamwa yo yona hedehedede namwanamwadi wa udiyedi meta se siliyata yo se nokokalili na se henahenamaiꞌuyoidi se wane, “Iya Yosepa natuna o nige?” ");
INSERT INTO sbe_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na Yesu ye hededelau udiyedi ye wane, “Ya nuwatui kabo hededesonoga kwa hedede kaliguwai kwa wane, ‘Doketa, ku henamwanamwaꞌuyoigo!’ Kabo hinage kwa hededelaoma laulau saha ya ginaulidi wasadi kwa lapuidi Kapelenauma unai wa, bena hinage ya ginaulidi teina yogu magai mamohoina ta unai.” ");
INSERT INTO sbe_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na Yesu ye wane, “Ya hededemamohoi kalimiuyena: Peloweta yona magai mamohoina unai nige gonowana se hailobai. ");
INSERT INTO sbe_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mamohoi, peloweta Eliya yona huya unai meta kwabukwabuli se badokalili Isalaela unai. Tenem huyana ne unai meta nige nabu ye talu bolimai haiyona yo tehana, na Isalaela maudoina hasalilakilaki se hekalo. ");
INSERT INTO sbe_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na iyamo Yaubada nige Eliya ye hetamali ye lau Isalaela yodi kwabuli hesau unai, na ye lau dagela waihiuna hesau kwabukwabulina unai, iya teha Sidona magaina Salepata unai ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yo hinage peloweta Elisa yona huyaena meta Isalaela unai taulepelepela se bado, iyamo nige hesau ye henamwanamwa, na Naman iya teha Siliya tamowaina ye bom mo.” ");
INSERT INTO sbe_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Huyana sunago unai na tamowai maudoidi hedehedede wa se lapui meta se koipilikalili. ");
INSERT INTO sbe_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Se tolo ede Yesu magai wa unai se hepesa na se woyalae kuduli padipadina unai bena se gabadobiyei. ");
INSERT INTO sbe_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Na iya meta boda wa luwadiyena ye solahai ede ye laugabaeidi na ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na kabo ye dobi Galili magaina hesau hesana Kapelenauma. Na Sabatiyena ye lau sunago unai na tamowai ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yona lauhekata wa unai meta se nokokalili, matawuwuna yona gigibwali unai ye hedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sunago wa luwana ne unai meta tamowai hesau, yaluwa bikibikina iya ye luwui, na kalina lakilakina unai ye yogahi ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aiyoi! Saha ku henuwa kalimaiyena, Yesu Nasaleta tamowaina? Ku laoma bena ku heyababagai? Kabim ya kata kowa kaiteya: Kowa Tabuna, Yaubada unai ku laoma.” ");
INSERT INTO sbe_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Yesu ye hededebayao yaluwa bikibikina wa unai ye wane, “Ku mwanou na tamowai me ku pesagabaei!” Ede yaluwa bikibikina tamowai wa ye tuudobiyei boda wa luwadiyena na ye pesagabaei, na nige ye hekamkamna. ");
INSERT INTO sbe_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tamowai maudoidi wa se noko na se bom yodi se hedehedede se wane, “Teina hedehedede ta kaniyona ede saha? Yona gigibwali yo yona bayao unai ye hededelau yaluwa bikibikidi udiyedi, ede se pesa.” ");
INSERT INTO sbe_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na Yesu wasana meta magai maudoina wa ye tauhetakikili. ");
INSERT INTO sbe_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu sunago wa ye laugabaei na ye lau Simona yona numa unai. Na Simona bwasiyana sinebada ye kasiyebwakalili, tauna meta se gwagwama. Na Yesu se kaibwadai bena ye henamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ede ye lau kalinawai na ye dunedobi na ye hedede meta gwagwama wa ye pesagabaei, na kasiyebwa wa ye gehe. Na mahanana ne unai ye tolo ede ye haitalaidi. ");
INSERT INTO sbe_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mahana wa ye dui na mulina ne unai tamowai maudoidi kehadiyao kasiyebwa udoiꞌudoi tauhaidi se woyaidima Yesu unai. Na Yesu nimana ye tolesaedi kesega kesega kewana ne unai na maudoidi wa ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yo hinage tamowai se bado udiyedi yaluwa yabayababadi se pesapesa na se yogayogahi se wane, “Kowa Yaubada Natuna.” Na Yesu ye dilaidi na ye hededehekaiyawasidi tabu se hedehedede, matawuwuna kabina se kata iya meta Keliso. ");
INSERT INTO sbe_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Malatomtomyena Yesu magai wa ye laugabaei na ye lau balabala hesau unai. Na boda wa se hetubu se loyai. Huyana se lobai meta se hededelau unai bena tabu ye laulaugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na Yesu ye hededelau udiyedi ye wane, “Taba hinage Yaubada yona basileiya wasana namwanamwana ta ya lauguguyaei magai hekadi udiyedi, matawuwuna Yaubada ye hetamaligau ne kaniyona ede.” ");
INSERT INTO sbe_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ede Galili ye laugabae na ye lau Yudeya unai yodi sunago udiyedi ye lauguguyatakikili. ");
INSERT INTO sbe_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Huya hesau Yesu ye totolo Galili Gabwana dedekana unai na boda se haiyahiyahiꞌuyoidi bena Yaubada wasana se lapui. ");
INSERT INTO sbe_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na tauyamayama yodi waga labui ye kitadi se hetausinidi salagomgom wa unai na se pesagabaeidiko na se lau yodi hinaya se deudeulidi. ");
INSERT INTO sbe_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu waga wa hesau unai ye gelu, iya meta Simona yona. Na ye hededelau iya unai bena waga wa ye hesigidobiyei. Na kabo ye tuli waga wa unai na boda wa ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yona hedehedede wa ye gehe ede ye hededelau Simona unai ye wane, “Yom waga ta ku hesigidobiyei gabwagabwatumna ne unai, na ma kam kahao yomi hinaya kwa gabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Simona ye hededebui ye wane, “Tanuwaga, boniyai lohaloha ka kaipatekalili na nige saha hesau ka hinayai, na yom hedehedede unai kabo hinaya ne ya gabadobiyeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hinaya wa se gabadobiyeidi na yama se hekonadi. Na se badokalili ede hinaya wa se hetubu bena se tapulisi. ");
INSERT INTO sbe_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Unai kadi kahao waga hesau unai wa se nimakoidi se laoma se saguidi. Na waga labui wa yama unai se hemwayaudi, ede se yoliyolisapuli. ");
INSERT INTO sbe_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Huyana Simona Petelo laulau wa ye kita meta ye gulidobi Yesu talanuwana unai na ye wane, “Guiyau, ku laugabaegau, yau yababa tamowaina.” ");
INSERT INTO sbe_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Matawuwuna Petelo ma kana kahao yama wa se hinayai na yona bado wa se kita meta se siliyatakalili, ");
INSERT INTO sbe_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","gonogonowana doha Yamesi yo Yowane, Sebedaiyo natunao, siya Simona kana kahao yodi yamayama paisowana unai. Na Yesu ye hededelau Simona unai ye wane, “Tabu ku matausi, mayadai ta unai na ye lau ne kabo tamowai ku hinayaidi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ede waga wa ma gogodi se niulisinidi nagali wa unai se laugabaeidi na Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Huyana Yesu magai hesauna unai meta tamowai hesau ye laoma, iya tauna lepela se hemwayau. Tamowai wa Yesu ye kita ede ye guliyaboyabomdobi iya talanuwana unai na ye kaibwada ye wane, “Guiyau, ena ku henuwa, kabo gonowana ku heꞌaꞌagau.” ");
INSERT INTO sbe_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ede nimana ye helelelaei tamowai wa ye kabitonogi na ye wane, “Ya henuwa. Ku aꞌa.” Mahanana ne unai kasiyebwa wa ye ulugehe. ");
INSERT INTO sbe_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kabo Yesu ye hedehededelau unai ye wane, “Tabu tamowai hesau yona ku hedehedede, na ku lau taukaitalasam unai ku hemasalahago, na heꞌaꞌa kaitalasamdi Mose ye hedededi wa ku ginaulidi. Kabo tamowai se kitalobai meta ku namwanamwako.” ");
INSERT INTO sbe_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na iyamo Yesu wasana wa ye laki ye lau, ede bodalakilaki se laoma bena yona lauhekata se lapuidi yo bena kadi kasiyebwa ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Na huya se bado Yesu ye dalahaigabaedi na ye bom ye lau balabalagaibu udiyedi na ye tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mayadai hesau Yesu ye laulauhekata, na Paliseya yo laugagayo taulauhekataena tamowaidiyao hekadi dedekana wa unai se tutuli. Siya meta Yudeya yo Galili magaidiyao maudoidi udiyedi se laoma, yo Yelusalema unai taulaoma siya hinage menai. Na Guiyau yona gigibwali ede Yesu kalinawai bena taukasikasiyebwa ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tenem huyana ne unai meta tamowai hekadi tamowai hesau bunibunina diyadiyali unai se baheiyama na se kaipate bena se bahehemwalae numa kalona ne unai na se tole Yesu talanuwana unai. ");
INSERT INTO sbe_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na boda wa ye lakikalili ede nige gonowadi, unai se mwalaesae numa wa kewanaena, gatowa wa unai duha se ginauli na taubunibuni wa ma diyadiyalina se hedalolodobiyei boda wa luwadiyena Yesu talanuwana ne unai. ");
INSERT INTO sbe_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yodi sunuma Yesu ye kita ede ye hededelau taubunibuni wa unai ye wane, “Kagu kaha, yom yababa ya nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Laugagayo taulauhekataena yo Paliseya wa se bom se nuwanuwatu se wane, “Teina tamowai ta meta kaiteya na Yaubada ye hededeheyaheyababa? Yaubada ye bom mo gonowana yababa ye nuwatugabaedi!” ");
INSERT INTO sbe_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yodi nuwanuwatu wa Yesu kabidi ye kata ede ye henamaiyeidi ye wane, “Idohagi na teina nuwanuwatu ta nuwamiu ne udiyedi kwa nuwanuwatuidi? ");
INSERT INTO sbe_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hedehedede sahasahana ye biga, kabo ya hedede taubunibuni ta unai ya wane, ‘Yom yababa ya nuwatugabaedi’, o ya wane, ‘Ku tolo na ku laulau’? ");
INSERT INTO sbe_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ya henuwa bena kwa nuwatulobai meta Tau Natuna yona gigibwali kaiyaulina ta unai gonowana yababa ye nuwatugabaedi.” Na ye hededelau taubunibuni wa unai ye wane, “Ku tolo, yom kabakeno me ku hai na ku lau yom numa!” ");
INSERT INTO sbe_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mahanana ne unai matadiyena ye tolo na yona kabakeno wa ye hai ede ye lau yona magai na Yaubada ye hedehedebasaei. ");
INSERT INTO sbe_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tamowai maudoidi se nokokalili na Yaubada se hedebasaei. Yo Yaubada hekasisina ye hemwayaudi na se hedehedede se wane, “Mayadai ta unai meta kabikabi saesaekalilidi ta kitadi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mulina ne unai Yesu ye dalahai ye lau na takisi tautanotano hesau hesana ede Lewi ye kita ye tutuli takisi kabatanotano numana unai. Na ye hededelau unai ye wane, “Ku hemuliwatanigau!” ");
INSERT INTO sbe_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ede Lewi ye tolo, yona paisowa gogodi maudoidi ye laugabaeidi na Yesu ye hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kabo Lewi yona numa unai kai lakilakina ye ginauli Yesu hesabana. Na takisi tautanotano bodalakilaki yo tamowai hekadiyo maiyadiyao se kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Paliseya kadi bodao wa luwadi ne unai laugagayo taulauhekataena hekadi, na Paliseya hekadiyo maiyadiyao se laoma se hetalapili Yesu yona hekahekatao wa udiyedi se wane, “Idohagi to takisi tautanotano yo yababa tamowaidiyao ne maidamiyao kwa kaikaigogoi?” ");
INSERT INTO sbe_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu yodi bui ye moseidi ye wane, “Tamowai namwanamwadiyao nige se henuwa doketa, na tamowai kasikasiyebwadi mo. ");
INSERT INTO sbe_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yogu laoma ta nige tamowai yodi miyamiya dudulaidi hesabadi, na yababa tamowaidi ya yoganeidi bena se nuwabui.” ");
INSERT INTO sbe_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kabo se hededelau Yesu unai se wane, “Yowane yona hekahekatao se kaikaihudi yo se tapwatapwalolo, gonogonowana doha Paliseya yodi hekahekatao hinage, na yom hekahekatao ne se kai yo se numa, na nige se kaikaihudi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na Yesu ye hededelau udiyedi ye wane, “Tawasola kaikaigogona unai, ena tautawasola maiyadi, meta kabo kana taumana se kaihudi o nige? ");
INSERT INTO sbe_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Na mayadaina ye lage kabo tautawasola se haigabaei, na kabo kehanao ne se kaihudi.” ");
INSERT INTO sbe_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na kabo Yesu teina heyaheyasoni ta ye hedede udiyedi ye wane, “Nige gonowana tamowai hesau kaleko hauhauna tupwana ye pulisihai na kaleko beyabeyana tapulisina unai ye polai. Taba ye ginauli, meta kaleko hauhauna kabo ye heyababa, na kaleko hauhauna tupwana wa maiyana kaleko beyabeyana wa taba nige kadi kao ne gonogonowadi. ");
INSERT INTO sbe_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nige gonowana tamowai hesau waina hauhauna ye ini waina pakuna beyabeyana unai. Taba ye ginauli, kabo waina pakuna wa ye tapulisi, matawuwuna waina hauhauna kabo ye sese. Kabo waina wa ye bwalili, na pakuna wa kabo ye yababa. ");
INSERT INTO sbe_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waina hauhauna bena ta ini waina pakuna hauhauna unai. ");
INSERT INTO sbe_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ena tamowai hesau waina beyabeyana ye numatonogi, kabo waina hauhauna nige ye henuwa, na ye wane, ‘Waina beyabeyana meta ye namwa ede.’” ");
INSERT INTO sbe_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabati hesau unai Yesu maiyana hekahekatao se laulau kabo witi koyana hesau se tauduwaduwali se lau. Ede yona hekahekatao wa witi kaniyodi se gigidi na nimadi udiyedi se kutudi na se kaikai. ");
INSERT INTO sbe_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na Paliseya tamowaidi hekadiyo se hededelau udiyedi se wane, “Idohagi to Sabati laugagayona kwa utusi?” ");
INSERT INTO sbe_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Yesu ye hededelau udiyedi ye wane, “Huyana Dawida ma kana hewahewaliyo se hasali na saha ye ginauli wa wasana kwa hasili o nige? ");
INSERT INTO sbe_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ye lusae Yaubada yona Logulogu Tabuna unai na pwalawa hetahetabudi ye haidi ye kaidi, na hekadi ye moseidi kana hewahewaliyo wa se kaidi. Tenem unai meta laugagayo se utusi, matawuwuna pwalawa ne nige gonowana tamowai gaibu se kai, na taukaitalasam se bom mo kabo se kai.” ");
INSERT INTO sbe_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yesu yona hedehedede ye tubei ye wane, “Tau Natuna iya Sabati guiyauna ede.” ");
INSERT INTO sbe_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabati hesau unai ye lusae sunago unai ye lauhekata. Na temenai tamowai hesau nimakahakahatuna ne ye basabasa na nige gonowana ye hepaisowa. ");
INSERT INTO sbe_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Laugagayo taulauhekataena yo Paliseya tamowaidi meta yodi kabahegiluna se wasewasenei, unai Yesu se kaikewakaliliyei, mamohoi kabo Sabati unai tamowai ne ye henamwanamwa o nige. ");
INSERT INTO sbe_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yodi nuwanuwatu wa Yesu kabina ye kata, unai ye hededelau tamowai nimabasabasana wa unai ye wane, “Ku saema na matadi ne unai ku tolo.” Ede matadi wa unai ye tolo. ");
INSERT INTO sbe_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kabo Yesu ye hededelau Paliseya tamowaidi wa udiyedi ye wane, “Ya henamaiyeigomiu: Laulau saha ye dudulai ede mayadai Sabati unai: namwa ta ginauli o yababa, tamowai yona mauli ta sagui o ta heyababa?” ");
INSERT INTO sbe_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na ye kaikewatakikili maudoidi wa kalidiyena na kabo ye hededelau tamowai wa unai ye wane, “Nimam ne ku tuuhedudulai!” Tamowai wa nimana ye tuuhedudulai ede ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na Paliseya yo laugagayo taulauhekataena wa meta se koipilikalili, ede se bom yodi se koitalaliu saha kabo se ginauli Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tenem mayadaidi ne udiyedi Yesu ye lau kuduli hesau unai bena ye tapwalolo. Menai ye bawa ye lau mala ye tom, na ye tapwatapwalolo Yaubada unai. ");
INSERT INTO sbe_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Malatomtomyena yona hekahekatao ye yogagogoidi se laoma iya unai na luwadiyena badodi 12 ye kaisunuwaidi na ye kataidi apostolo. Hesadi ede teina: ");
INSERT INTO sbe_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simona, iya hesana ye tole Petelo, yo kana kaha Andeleya, yo Yamesi, Yowane, Pilipo, Batolomaiyo, ");
INSERT INTO sbe_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataiyo, Tomasi, Yamesi Alepaiya natuna, Simona, iya se katai Tauhaikabi, ");
INSERT INTO sbe_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudasi Yamesi natuna, yo Yudasi Isakaliyota, iya ye hemala Yesu kana tauwalohai. ");
INSERT INTO sbe_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu yona hekahekatao maiyanao kuduli wa unai se dobiꞌuyoma na malakotana unai se totolo, na tauhemuhemuliwatanina bodalakilaki wa menai, yo hinage tamowai hekadi bodalakilaki, siya ede Yudeya yo Yelusalema tamowaidiyao, yo Taiya yo Sidona teha gabwa udiyedi taulaoma. ");
INSERT INTO sbe_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Siya se laoma bena Yesu yona lauhekata se lapui, yo bena ye henamwanamwadi kadi kasiyebwa udiyedi. Yo kaiteyadi yaluwa bikibikidi udiyedi se kamkamna, meta hinage ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Maudoidi se kaipate bena Yesu se kabitonogi, matawuwuna iya unai gigibwali ye pesapesama na maudoidi wa ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ye kitalau yona hekahekatao udiyedi na ye hededelau udiyedi ye wane, “Komiu kaiteyadi taudehadeha meta gonowana kwa gwauyala, matawuwuna Yaubada yona basileiya komiu yomiu. ");
INSERT INTO sbe_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Komiu mayadai ta unai tauhasahasali, meta gonowana kwa gwauyala, matawuwuna kabo kwa bogasese. Komiu mayadai ta unai taudoudou, meta gonowana kwa gwauyala, matawuwuna kabo nuwamiu se namwa. ");
INSERT INTO sbe_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ena Tau Natuna debanaena na tamowai se subugomiu yo se tolehesuwalagomiu yo se hededeheyababagomiu yo se hedede bena kwa yababa, meta gonowana kwa gwauyala. ");
INSERT INTO sbe_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yomi kamkamna mayadaina ne unai bena kwa nuwanamwa yo gwauyala sobuna kwa sobu, matawuwuna yomi kainauya galewa ne unai kabo ye lakikalili. Tamowai wa saha se ginaulidi kalimiuwai meta gonogonowana doha kadi kulutubu se ginaulidi peloweta udiyedi wa. ");
INSERT INTO sbe_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Na ahani mo komiu taugogogogo, matawuwuna yomi miya namwanamwana meta kwa haiyako. ");
INSERT INTO sbe_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ahani mo komiu bogamiu se sesekalili, matawuwuna kabo kwa hasali. Ahani mo komiu mayadai ta unai taugwaugwauyala, matawuwuna kabo kwa nuwadubu yo kwa dou. ");
INSERT INTO sbe_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ahani mo komiu, ena tamowai maudoidi se hededehenamwagomiu, matawuwuna kadi kulutubu hinage pelowetalupolupo se hededehenamwadi.” ");
INSERT INTO sbe_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Na kabo Yesu ye wane, “Komiu taulapulapui, ya hededelaowa kalimiuyena doha teina: Kami waiunu bena kwa gadosisiyeidi, yo kaiteyadi se subugomiu bena yomi laulau se namwa kalidiyena, ");
INSERT INTO sbe_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yo kaiteyadi se kawagulaiyeigomiu meta kwa hededehenamwadi, yo taukabihenayaigomiu yodi kwa tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ena kaiteya papalim ne unai ye koi, meta ku tolobui na teha hesau ne unai hinage ye koi. Ena kaiteya kam lulu nimalohalohana ye hai, meta kam lulu nimakubwakubwana hinage ku mosei. ");
INSERT INTO sbe_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ena tamowai hesau kalimyena ginauli hesau ye kaibwadai, meta bena ku mosei, na ena tamowai hesau yom ginauli hesau ye hai, meta tabu ku hetalaꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yomi laulau tamowai udiyedi taba gonogonowana doha kwa henuwa bena se ginauli kalimiuyena. ");
INSERT INTO sbe_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ena taugadosisiyeigomiu se bom mo kwa gadosisiyeidi, unai kabo kainauya saha hesau kwa lobai, e nige? Taba nige, matawuwuna yababa tamowaidiyao hinage taugadosisiyeidi se gadosisiꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na ena tamowai hesau yona laulau se namwa kalimiuyena, na ye bom mo unai yomi laulau se namwa, unai kabo kainauya saha hesau kwa lobai, e nige? Taba nige, matawuwuna yababa tamowaidiyao teina miya ta hinage se miyamiyaei. ");
INSERT INTO sbe_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ena tamowai hesau moni unai ku sagui na yom nuwatu ede kabo ye hemaisaꞌuyoi, unai kabo kainauya saha hesau kwa lobai, e nige? Taba nige, matawuwuna yababa tamowaidiyao hinage moni se mosei yababa tamowaidiyao hekadiyo udiyedi na yodi nuwatu ede yodi moni ne dudulaina kabo se hemaisaꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na kami waiunu bena kwa gadosisiyeidi, yo yomi laulau bena se namwa kalidiwai, yo yomi sagu kwa mosei udiyedi, na tabu yomi nuwanuwatu bena maisana kwa haiꞌuyoi kalidiyena. Na kabo yomi kainauya ye lakikalili, na komiu kabo Yaubada Saesaekalilina natunao, matawuwuna iya yona laulau se namwa nige taulaulautokiyeina yo yababa tamowaidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bena katekamkamna kalimiuyena, doha Tamamiu iya taukatekamkamna.” ");
INSERT INTO sbe_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu yona hedehedede ye tubei ye wane, “Tabu tamowai kwa hekasadi, kabo Yaubada taba nige ye hekasagomiu. Tabu tamowai kwa hegiludi, kabo Yaubada taba nige ye hegilugomiu. Tamowai yodi yababa kalimiuyena kwa nuwatugabaedi, kabo Yaubada yomi yababa ye nuwatugabaedi. ");
INSERT INTO sbe_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kwa kaikainauya, kabo Yaubada ye kainauyaigomiu. Kana kao doha kabanowonowoi kaputina ye hemwayau na kewana ne unai ye inihepwataꞌuyoi na ye sae ye mwayaubwalibwalili na ye lediwa kalimiuyena. Matawuwuna nowonowoi sahasahana kwa hepaisowa tamowai udiyedi meta Yaubada kabo ye hepaisowa kalimiuyena.” ");
INSERT INTO sbe_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu heyaheyasoni hesau ye hedede kalidiyena, ye wane, “Nige gonowana taumatagibugibu hesau yona hali taumatagibugibu ye woyai. Ena ye woyai, kabo se bekulabulabuidobi duhaena. ");
INSERT INTO sbe_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Lauhekata tauhaina meta nige hesau ye sonogakalili na kabo tauhekatana ne. Na ena hesau lauhekata maudoina ye hai, meta yona taulauhekata ne maiyana kabo gonogonowadi. ");
INSERT INTO sbe_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ye saha to kam kaha matana mukalina ku kaikewai, na matam ne unai kaiwa mwayana nige ku modei? ");
INSERT INTO sbe_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Idohagi na ku hededelau kam kaha unai ku wane, ‘Kagu kaha, ku laoma matam mukalina ya haigabaei,’ iyamo kaiwa mwayana matam ne unai nige ku kita? Kowa taukailupolupo mamohoi! Matam ne unai kaiwa mwayana ku haigabaeibagunai na matam ne ye nega, kabo kam kaha matana mukalina ku kitanamwanamwaei na ku haigabaei!” ");
INSERT INTO sbe_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Na Yesu yona hedehedede ye tubei ye wane, “Kaiwa namwanamwana nige gonowana kaniyona yababadi ye toledi, yo kaiwa yababana nige gonowana kaniyona namwanamwadi ye toledi. ");
INSERT INTO sbe_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaiwa kesega kesega kaniyona unai ta kitalobai. Nige gonowana bosibosi kaniyodi ta gigidi kaiwa gwaligwalidi udiyedi, yo wine kaniyodi nige gonowana ta gigidi maimaina gwaligwalidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tamowai namwanamwana nuwana meta nuwanuwatu namwanamwadi udiyedi ye mwayau, unai iya yona hedehedede yo yona kabikabi kabo se namwa. Yo tamowai yababana nuwana meta nuwanuwatu yababadi udiyedi ye mwayau, unai iya yona hedehedede yo yona kabikabi kabo se yababa. Matawuwuna tamowai nuwana ne unai saha ye miyamiya, meta kawana ne unai kabo ye hedehededei.” ");
INSERT INTO sbe_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kabo Yesu ye wane, “Kwa kataigau ‘Guiyau, Guiyau!’, na idohagi to yogu hedehedede nige kwa ginauliwatanidi? ");
INSERT INTO sbe_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kaiteya ye laoma kaliguyena na ye lapulapulaoma yo yogu hedehedede ye kawakabiyedi, iya kana kao kabo ya hededehemasalaha kalimiuyena: ");
INSERT INTO sbe_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iya doha taukabinuma bwatano ye sala ye dobi na numa sowona ye hetolo weku kewanaena. Huyana kabaita ye didima na numa ne ye koiyei, meta nige gonowana ye nukui, matawuwuna numa wa ye ginaulinamwanamwaei. ");
INSERT INTO sbe_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na kaiteya kalinagu ye lapui na yogu hedehedede nige ye miyawatanidi, iya meta doha taukabinuma nige ye saladobi, na bwatano kewagaibuna unai yona numa ye hetuli. Huyana kabaita numa ne ye koiyei meta ye koiheguli na ye hetatagwaligwalikaliliyei.” ");
INSERT INTO sbe_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu boda wa udiyedi ye lauhekata ye gehe na ye lusae Kapelenauma. ");
INSERT INTO sbe_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Temenai Loma yodi iyala taubagunaena tamowaina hesau, na yona heyayai tauhaina hesau ye gadosisikaliliyei meta ye kasiyebwa sabi boitana. ");
INSERT INTO sbe_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iyala taubagunaena tamowaina wa Yesu wasana ye lapui ede Dius yodi tamowai lakilakidi hekadiyo ye hetamalidi se lau Yesu unai se kaibwadai bena ye laoma na yona heyayai tauhaina wa ye henamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Se laoma Yesu unai na se kaibwadabayabayao se wane, “Teina tamowai ta ye namwa mo ku sagui,matawuwuna iya tamowai namwanamwana. ");
INSERT INTO sbe_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kita Dius tamowaidiyao ye gadosisiyeida, yo hinage yoda sunago ye ginauli.” ");
INSERT INTO sbe_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ede Yesu maiyanao se lau. Numa wa se hanahanawuiyako na iyala taubagunaena tamowaina wa kana kahao hekadiyo ye hetamalidi se lau Yesu unai bena kalinana se hedede. Se wane, “Guiyau, tabu ku mode, matawuwuna nige ya namwa na bena ku laoma yogu numaena. ");
INSERT INTO sbe_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Temeta debanaena ede yau hinage nige gonowana bena ya laowa kalimyena. Na taba ku hedehedede mo, kabo yogu taupaisowa ne ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Matawuwuna yau hinage kagu tanuwaga yona gigibwali gunina unai, yo yau tauꞌiyala tauwoyaidi. Ya hededelau hesau unai ya wane, ‘Ku lau!’, meta kabo ye lau. Yo hesau unai ya wane, ‘Ku laoma!’, meta kabo ye laoma. Na ya hededelau yogu heyayai tauhaina unai ya wane, ‘Paisowa ne ku ginauli!’, meta ye ginauli.” ");
INSERT INTO sbe_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu hedehedede wa ye lapui meta ye nokokaliliyei. Ede ye tolobui na ye hededelau boda se hemuhemuliwatani wa udiyedi ye wane, “Ya hededelaowa, sola nige sunuma hesau doha teina ya lobai Isalaela tamowaidiyao udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na tautauwasaina wa se uyo iyala taubagunaena tamowaina yona numa, na yona heyayai tauhaina wa se kita meta ye namwanamwako. ");
INSERT INTO sbe_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nige huyana ye loha, na Yesu ye lau magai hesau hesana Naina unai, na yona hekahekatao yo bodalakilaki maiyanao se lau. ");
INSERT INTO sbe_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Magai wa ganana kedana ye hanahanawui na tauboita hesau se bahehepesa. Tauboita wa meta sinebada hesau natuna loheya kesega mo, na sinebada wa meta kwabukwabulina. Na magai wa bodana iya maiyanao. ");
INSERT INTO sbe_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Huyana Guiyau sinebada wa ye kita meta ye katekamkamnaei na ye wane, “Tabu ku doudou!” ");
INSERT INTO sbe_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na ye lau diyadiyali wa ye kabilau unai, ede taubaheina wa se talutolo. Na ye wane, “Hewali, ya hededelaowa, ku tolo!” ");
INSERT INTO sbe_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na hewali wa ye tolo ye tuli na ye hetubu ye hedehedede. Ede Yesu ye moseꞌuyoi sinana wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Maudoidi wa se nokokalili na Yaubada se hedebasaei, se wane, “Peloweta saesaena hesau ye taumasalaha luwadaena!” Yo hinage se wane, “Yaubada ye laoma bena yona tamowai ye saguidi.” ");
INSERT INTO sbe_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu yona kabikabi ta wasana ye lau Yudeya tehana maudoina ye hetakikili yo dedekana ne unai teha hekadiyo hinage. ");
INSERT INTO sbe_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yowane Babatiso yona hekahekatao ginauli maudoidi Yesu ye ginaginaulidi wa yona se hedehedede. Unai ede yona hekahekatao labui ye yoganeidi ");
INSERT INTO sbe_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na ye hetamalidi bena se lau Guiyau unai se henamai se wane, “Mamohoina kowa Kelisona ede ka nayanayai wa, o sola tamowai hesau ka nayanayai kabo ye laoma?” ");
INSERT INTO sbe_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Taudi labui wa se lau Yesu unai se lage ede se hededelau unai se wane, “Yowane Babatiso ye hetamaligai ka laoma ka henamaiyeigo: ‘Mamohoina kowa Kelisona ede ka nayanayai wa, o sola tamowai hesau ka nayanayai kabo ye laoma?’” ");
INSERT INTO sbe_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mahanana ne unai Yesu tamowai se badokalili kadi kasiyebwa udoiꞌudoi ye henamwanamwadi, yo yaluwa yabayababadi ye hededehepesadi, yo hinage tamowai matagibugibudi matadi ye helaladi. ");
INSERT INTO sbe_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Unai ye hededebui ye wane, “Kwa uyo na saha kwa lapuidi yo kwa kitadi wa Yowane yona kwa hedehedede, kwa wane, Taumatagibugibu matadi se lala, taubunibuni se laulau, taulepelepela se namwanamwa, taubeyakolakola se lapulapui, tauboiboita se toloꞌuyo, yo taudehadeha wasa namwanamwana se lapui. ");
INSERT INTO sbe_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na kaiteya nige ye nuwalabulabuiyeigau, iya gonowana ye gwauyala!” ");
INSERT INTO sbe_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yowane yona tautauwasa wa se dalahai, na kabo Yesu ye hetubu Yowane hedehededena ye hedehededei boda wa udiyedi, ye wane, “Ginauli saha hesabana kwa lau balabala ne unai bena kwa kita? Nuwana didiyali yaumai ye yuhisaei yo ye yuhidobiyei? Nige! ");
INSERT INTO sbe_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O yomi nuwatu bena tamowai hesau yona kaleko wasawasadi kwa kita? Nige! Na tamowai kadi leli didididigadi yo nonohana unai se miyamiya, siya meta wasawasa yodi numa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","O nuwana kwa lau bena peloweta hesau kwa kita? Mamohoi, Yowane iya peloweta hesau. Na ya hededelaowa meta ye saekalili na kabo peloweta hekadiyo. ");
INSERT INTO sbe_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yowane iya tamowaina ede kulikuli tabuna unai se hetahetala se wane, ‘Kabo yogu tautauwasa ya hetamali bena ye kedabagunaego. Iya kabo yom keda ye kabinonohai.’ ");
INSERT INTO sbe_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ya hededelaowa kalimiuyena: Tamowai tanoubu ta unai se labasi meta nige hesau ye saekalili na kabo Yowane. Iyamo Yaubada yona basileiya unai, tamowai hesau, ena ye dobikalili, meta tamowaina ne ye sae na kabo Yowane.” ");
INSERT INTO sbe_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Huyana tamowai maudoidi yo hinage takisi tautanotano Yesu yona hedehedede se lapui, ede se hedede meta Yaubada yona hineli se dudulaikalili, matawuwuna siya meta Yowane yona babatiso se haiyako. ");
INSERT INTO sbe_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Na Paliseya yo laugagayo taulauhekataena Yaubada yona nuwanuwatu siya hesabadi wa se laukwatakwataei, matawuwuna nige Yowane unai babatiso se hai. ");
INSERT INTO sbe_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kabo Yesu ye hedehededeꞌuyo ye wane, “Teina isi ta tamowaidiyao kabo saha unai ya heyaheyasoniyedi? Kadi kao kabo doha saha? ");
INSERT INTO sbe_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Siya doha wawayao, kabalokulokune bakubakuna unai se tuli na se yogayogalau kadi kahao udiyedi se wane, ‘Higo ka yuhidi, na nige kwa sobu. Siyayau wanadi ka wanaidi, na nige kwa dou.’ ");
INSERT INTO sbe_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yowane Babatiso ye laoma ye kaihudi yo nige waina ye numanuma na kwa hedede bena yaluwa yabayababana iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na Tau Natuna ye laoma meta ye kaikai yo waina ye numanuma na kwa wane, ‘Sola kwa kita, ye kaimuyomuyou yo ye numayauyaule! Yo iya takisi tautanotano yo yababa tamowaidiyao kadi kaha!’ ");
INSERT INTO sbe_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na Yaubada yona sibasiba ye dudulaikalili. Kabakitalobaina ede taulauwatanina yodi miyamiya udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Paliseya tamowaina hesau Yesu ye yogaisini bena maiyana se kaikaigogoi. Ede Yesu ye lau tamowai wa yona numa unai ye mwalae na ye kenodobi kabakaikai hatana unai bena ye kaikai. ");
INSERT INTO sbe_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Magai ne unai meta waihiu hesau mauli yabayababana unai ye miyamiya. Na wasa ye lapui meta Yesu Paliseya tamowaina wa yona numa unai ye kaikai, ede yausi panepanena botolona ye baheiyama. ");
INSERT INTO sbe_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ye mwalaesae na ye tolo Yesu kaena dedekadi udiyedi na ye doudou. Matasuluna se dididobi na Yesu kaena se heduwabwadi, na waihiu wa kuluna ne unai Yesu kaena wa ye saudi yo ye sumtaidi, na yausi wa unai ye heyausidi. ");
INSERT INTO sbe_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Paliseya tamowaina Yesu tauyogaisinina laulau wa ye kita ede ye bom yona ye hedehedede ye wane, “Ena teina tamowai ta iya peloweta, kabo kabina ye kata meta taukabitonogina ne iya kaiteya yo waihiu sahasahana. Iya meta waihiu yababana!” ");
INSERT INTO sbe_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Yesu ye hededelau unai ye wane, “Simona, ya henuwa bena ginauli hesau ya hedede kalimyena.” Ye talam ye wane, “Taulauhekata, yogu ku hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na Yesu ye wane, “Tamowai labui se kaihagahaga tamowai monimonina hesau unai. Hesau kana hagahaga meta denali 500, na hesau 50. ");
INSERT INTO sbe_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Taudi labui nige gonowadi moni wa se hedudulaiꞌuyoidi, ede moni tanuwagana kadi hagahaga wa ye nuwatugabaeidi. Na yodi labui ne, kaiteya kabo moni tanuwagana wa ye gadosisikaliliyei?” ");
INSERT INTO sbe_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Simona ye hededebui ye wane, “Ya nuwatui meta kaiteya kana hagahaga ye lakikalili ne ye nuwatugabaei.” Yesu ye wane, “Yom nuwatu ne ye dudulai.” ");
INSERT INTO sbe_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na kabo ye kaikewabui waihiu wa unai na ye hededelau Simona unai ye wane, “Waihiu ta ku kita? Huyana ya mwalaema yom numa ta unai meta nige waila ku haiyama kaegu kabadeulidi. Na iya matasuluna udiyedi kaegu ye deulidi yo kuluna unai ye saudi. ");
INSERT INTO sbe_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kowa nige sumta unai ku lautokiyeigau, na iya kaegu sumtaidi nige ye hekaiyawasi yogu mwalaesaema ta unai. ");
INSERT INTO sbe_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kowa nige kulugu ku heyausi, na iya kaegu ye heyausidi yausi panepanena unai. ");
INSERT INTO sbe_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Unai ya hededelaowa: Yona yababa se badokalili na ya nuwatugabaeidiko, unai ede ye gadosisikaliliyeigau. Na kaiteya yona yababa gagilina ya nuwatugabaei meta yona gadosisi kaliguwai ne ye gagili.” ");
INSERT INTO sbe_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kabo ye hededelau waihiu wa unai ye wane, “Yom yababa ya nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Taukaikai hekadiyo se hetubu se bom yodi se hedehedede se wane, “Teina tamowai ta meta kaiteya na yababa ye nuwatugabaedi?” ");
INSERT INTO sbe_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Yesu ye hededelau waihiu wa unai ye wane, “Yom sunuma ye hemauligo. Ku lau ma nuwadaumwalim.” ");
INSERT INTO sbe_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mulina ne unai Yesu ye lau magai lakilakidi yo gagilidi udiyedi na Yaubada yona basileiya wasana namwanamwana ye laulauguguyai. Yona hekahekatao saudoudoi-labui wa maiyanao, ");
INSERT INTO sbe_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","yo hinage sinesineo hekadi yaluwa yabayababadi yo kasiyebwa udiyedi ye henamwanamwadi wa: Maliya, iya se katai Magadala waihiuna, na unai meta yaluwa yabayababadi badodi haligigi-labui Yesu ye hededehepesadi, ");
INSERT INTO sbe_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","yo Yowana, iya ede Heloda yona numa taukitahetetena hesana Kusa mwanena, yo Susana, yo sinesineo hekadi hinage. Siya meta se bom yodi gogo se hepaisowadi na Yesu maiyana hekahekatao wa se saguidi. ");
INSERT INTO sbe_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bodalakilaki se lageko na magai udoiꞌudoi udiyedi tamowai hekadiyo sola se laolaoma Yesu unai, na heyaheyasoni ta ye hedede, ");
INSERT INTO sbe_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ye wane, “Koya taupaisowaina hesau ye lau yona koyaena witi likena tumadiyao ye hesuludi. Na hekadi se bekudobi kedaena. Tamowai yodi kabalau udiyedi se lau ede se utuꞌutuidi, yo manuwa se laoma se kaidi. ");
INSERT INTO sbe_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Like hekadi tano maladebadebana unai se talu na se kini. Iyamo se wowoya, matawuwuna bwatano ne ye pitalikalili. ");
INSERT INTO sbe_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Like hekadi se bekudobi maimaina gwaligwalidi luwadiyena. Se kinilabulabui na maimaina wa se yahaidi. ");
INSERT INTO sbe_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na hekadi se bekudobi bwatano namwanamwana unai. Se kinilakilaki na se kaniyo, meta kewa kesega unai kaniyona badodi 100.” Na Yesu yona hedehedede gehena unai ye wane, “Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu yona hekahekatao wa se henamaiyei meta heyaheyasoni wa kaniyona ede saha. ");
INSERT INTO sbe_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na ye hededebui udiyedi ye wane, “Yaubada yona basileiya nuwanuwatuna saesaedi kabo ya hededehemasalahadi kalimiuyena. Na tamowai hekadiyo ya hededelau udiyedi meta heyaheyasoni mo udiyedi, unai kabo ‘se kaikaikewa, na taba nige se kitalobai, yo se lapulapui, na taba nige se nuwatulobai.’ ");
INSERT INTO sbe_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Heyaheyasoni wa kaniyona ede teina: Like kaniyona ede Yaubada wasana. ");
INSERT INTO sbe_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tamowai hekadi nuwadi kadi kao doha keda. Wasa wa se lapui, na kabo diyabolo ye laoma na nuwadi wa unai ye haigabaei, bena tabu se kawamamohoi yo Yaubada ye hemaulidi. ");
INSERT INTO sbe_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tamowai hekadi nuwadi kadi kao doha tano maladebadebana. Huyana Yaubada wasana se lapui meta se hai ma gwaugwauyaladi, na iyamo hedehedede wa nige ye miya nuwadi ne unai, matawuwuna nige lamna. Huyakubwakubwa mo Yaubada se sunumaei, na huyana laukita se hekalo meta se beku. ");
INSERT INTO sbe_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tamowai hekadi nuwadi kadi kao doha tano maimaina gwaligwalidi luwadiyena. Wasa wa se lapui, na kabo tanoubu maulina nuwanuwatuna yo tanoubu gwauyalana yo gogona meta wasa wa se taugudugudui, na nige gonowana ye kaniyo. ");
INSERT INTO sbe_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na tamowai hekadi nuwadi kadi kao doha bwatano namwanamwana, siya ede tamowai namwanamwadi yo nuwadi mamohoidi. Hedehedede wa se lapui na nuwadi udiyedi se toledi na se tolokesegai ma taubigadi na kabo se kaniyo.” ");
INSERT INTO sbe_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kabo Yesu heyaheyasoni hesau ye hedede ye wane, “Tamowai lampa se gabu meta taba nige walata unai se buikasini o kabakeno guninaena se tole. Bena lampa kabatolena unai se tole, to tamowai se mwalai kabo gonowana dawayana se kita. ");
INSERT INTO sbe_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gonogonowana doha hinage Yaubada yona basileiya ginaulina wadawadamdi maudoidi kabo ye hemasalahadi, yo ginauli maudoidi toletolewadamdi wa kabo hinage ye tolehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Unai bena kwa kitanamwanamwa yomi lapulapui udiyedi, matawuwuna kaiteyadi nuwatulobai saha kalidiyena, Yaubada yodi nuwatulobai ne kabo ye helakiꞌuyoidi. Na kaiteyadi se nuwatui bena nuwatulobai kalidiyena, na iyamo nige, Yaubada kabo yodi nuwatulobai gagilina ne ye haigabaei.” ");
INSERT INTO sbe_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu sinana yo kana kahao se laoma bena se kita, na nige gonowana se lau unai matawuwuna boda ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ede tamowai hesau ye hededelau Yesu unai ye wane, “Sinam yo kam kahao ede dagela ne unai se totolo bena se kitago.” ");
INSERT INTO sbe_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na Yesu ye hededebui ye wane, “Sinagu yo kagu kahao ede kaiteyadi Yaubada yona hedehedede se lapui yo se lauwatani.” ");
INSERT INTO sbe_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mayadai hesau unai Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Ta kawasilau hali sanakawasi ne unai.” Ede wagaena se gelu na se hetubu se kawasi. ");
INSERT INTO sbe_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yodi kadau ne unai Yesu ye kenodobi ede ye keno. Na kabo yaumai bayabayaona ye yuhidobima Galili Gabwana unai. Na bagodu se iniꞌinidikwa waga wa unai na yababa lakilakina se hekalo. ");
INSERT INTO sbe_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hekahekatao wa se lau Yesu se hanoi na se wane, “Tanuwaga! Tanuwaga! Nige bayaona kabo ta yoli!” Kabo Yesu ye tolo na ye hededelau yaumai yo bagodu wa udiyedi meta se kaiyawasi, ede ye daumwali. ");
INSERT INTO sbe_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na kabo ye hedehededelau yona hekahekatao wa udiyedi ye wane, “Yomi sunuma, o nige?” Na se matausi yo se nokokalili na se bom se henahenamaiꞌuyoidi se wane, “Teina tamowai ta meta kaiteya? Ye hededelau yaumai yo bagodu udiyedi na se kawakabiyei.” ");
INSERT INTO sbe_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu maiyana hekahekatao Galili Gabwana unai se kawasilau Gelasa tehana unai, iya ede Galili tanona teha kawasina ne unai. ");
INSERT INTO sbe_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Huyana Yesu waga wa ye pesagabaei na ye gayosae nagali wa unai meta magai wa tamowaina hesau ye laoma iya unai. Tamowai wa meta yaluwa yabayababadi se luwui na huyalohaloha meta ma taugaibuna yo nige numaena ye miyamiya, na bwayabwaya duhadi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Huyana Yesu ye kita meta ye dou na ye gulidobi kaena wa unai na kalinalakilaki unai ye hedehedede ye wane, “Yesu, Yaubada Saesaekalilina natuna, saha ku henuwa kaliguyena? Ya kaibwadaigo, tabu ku hekamkamnagau.” ");
INSERT INTO sbe_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hedehedede ta ye hedede matawuwuna Yesu ye hededelauko yaluwa bikibikina ne unai bena ye pesa. Yaluwa ne kana paisowa huya badobado meta tamowai wa ye tanutanuwagai, kabo nimana yo kaena seni unai se paipaihekahekahinidi na se kitahetete, iyamo seni wa ye utusidi na yaluwa yabayababana iya ye woyawoyai ye lau balabalagaibuyena. ");
INSERT INTO sbe_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ye henamaiyei ye wane, “Hesam ede saha?” Na ye wane, “Hesagu ede Legiyona.” Matawuwuna yaluwa yabayababadi meta se badokalili se luwu iya unai. ");
INSERT INTO sbe_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na yaluwa yabayababadi wa se kaikaibwadalau Yesu unai se wane, “Tabu ku hetamaligai ka laulau ebisi unai.” ");
INSERT INTO sbe_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na puwaka yawoina meta se dumudumuli kuduli dedekana ne unai. Ede yaluwa yabayababadi wa se kaibwadalau Yesu unai bena taba ye hetamalidi se lau udiyedi se luwu, na ye talamyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na yaluwa yabayababadi tamowai wa se pesagabaei ede se lau se luwu puwaka wa udiyedi, na maudoidi padipadi wa unai se heloigogoi se dobi ede gabwa wa unai se yoli. ");
INSERT INTO sbe_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Huyana puwaka taukitakitahetetedi saha ye tubu wa se kita meta se wasabu se lau magai lakilakina yo magai gagilidi dedekanawai na tamowaidiyao yodi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na tamowai wa se lau saha ye tubu wa bena se kita. Se laoma se lage Yesu unai meta tamowai yaluwa yabayababadi se pesagabaeiꞌusei wa se kita Yesu kaena dedekana unai ye tutuli ma kalekalekona, yo yona nuwanuwatu se dudulai. Na maudoidi wa se matausi. ");
INSERT INTO sbe_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ginauli maudoidi taukitadi meta tamowai yodi se hedehedede idohagi na ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kabo Gelasa tehana ne unai taumiya maudoidi se hededelau Yesu unai taba ye laugabaedi, matawuwuna se matausikalili. Ede Yesu wagaena ye gelu na ye dalahai. ");
INSERT INTO sbe_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tamowai yaluwa yabayababadi se pesagabaei wa ye kaibwada Yesu unai bena maiyana se lau. Na Yesu iya ye hetamali, ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ku uyo yom magai na saha Yaubada ye ginauli kalimyena wa ku hededehemasalaha.” Ede tamowai wa ye lau magai na saha Yesu ye ginauli iya unai wa ye hewasa tamowai maudoidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Huyana Yesu ye uyo Galili tehana unai ye lage meta boda se hailobai, matawuwuna maudoidi wa iya se nayanayai. ");
INSERT INTO sbe_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na kabo tamowai hesau hesana Yailo ye laoma. Iya sunago badana hesau. Ye gulidobi Yesu talanuwanawai na ye kaibwadai bena maiyana se lau yona numa, ");
INSERT INTO sbe_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","matawuwuna natuna waihiu kesega mo, yona bolimai 12, iya meta sabi boitana. Na Yesu yona lau ne unai meta boda ye lakikalili na se haihaiyahiyahiꞌuyoidi Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Luwadi ne unai sinebada hesau ye kasiyebwa bolimai 12, kwasina ye miyamiyagabaei, na nige tamowai hesau gonowana kabo ye henamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yesu dagelana wa unai ye saema na kana kwama sinosinona ye kabitonogi. Mahanana ne unai kana kasiyebwa wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ede Yesu ye henamai ye wane, “Kaiteya ye kabitonogigau?” Maudoidi se uhala. Na Petelo ye wane, “Tanuwaga, tamowai maudoidi meta se hetakikiligo na se kaiyahiyahi.” ");
INSERT INTO sbe_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na Yesu ye wane, “Tamowai hesau ye kabitonogigau, matawuwuna kamnana ya hai meta gigibwali ye pesagabaegau.” ");
INSERT INTO sbe_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na sinebada wa ye nuwatui meta Yesu kabo kabina ye kata, ede ye sae ma tabutabubuna na ye gulidobi Yesu talanuwana wa unai. Na boda maudoidi matadiyena ye hededehemasalahaꞌuyoi, matawuwuna saha to Yesu kana kwama ye kabitonogi, yo idohagi na kana kasiyebwa wa ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kabo Yesu ye hededelau unai ye wane, “Natugu, yom sunuma ta ye henamwanamwago. Ku lau ma nuwadaumwalim.” ");
INSERT INTO sbe_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu sola ma hedehededena na sunago badana wa yona numa unai tamowai hesau ye laoma ede ye hededelau unai ye wane, “Natum waihiu wa ye boitako, na tabu taulauhekata ne ku hemohemode.” ");
INSERT INTO sbe_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Na Yesu hedehedede wa ye lapui ede ye hededelau Yailo unai ye wane, “Tabu ku matausi, na ku kawamamohoiyeigau, na kabo natum ne ye namwanamwa.” ");
INSERT INTO sbe_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Huyana se lage numa wa unai, Yesu nige ye henuwa bena tamowai hesau maiyana se mwalae, na Petelo, Yowane, Yamesi, yo sinekuku wa tamana yo sinana mo. ");
INSERT INTO sbe_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Boda temenai meta se doudou yo se nuwanuwadubu wawaya wa hesabana. Na Yesu ye wane, “Tabu kwa doudou! Wawaya ne nige ye boita, na ye kenokeno.” ");
INSERT INTO sbe_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ede boda wa Yesu se talawasiyei, matawuwuna kabina se kata meta sinekuku ne ye boitako. ");
INSERT INTO sbe_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na Yesu sinekuku wa nimana unai ye kabi na ye hededelau unai ye wane, “Natugu, ku tolo!” ");
INSERT INTO sbe_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ede yawasina ye uyoma na ye tolo. Na Yesu ye hededelau udiyedi bena kai se mosei ye kai. ");
INSERT INTO sbe_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana yo sinana wa se siliyata. Na Yesu ye hededelau udiyedi meta saha ye tubu wa tabu tamowai hesau yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu yona hekahekatao badodi 12 wa ye yogagogoidima na bayao yo gigibwali ye moseidi bena kabo yaluwa yabayababadi maudoidi se hededehepesadi yo kasiyebwa maudoidi se henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na ye hetamalidi se lau bena Yaubada yona basileiya wasana se duwai yo taukasikasiyebwa se henamwanamwadi, ");
INSERT INTO sbe_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","na ye guguyaidi ye wane, “Yomi lau ne unai tabu saha hesau kwa bahei, nige tuke, nige tobwa, nige moni, nige kai, yo nige lulu hagahagana. ");
INSERT INTO sbe_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ena numa hesau unai kwa mwalaesae meta numa me unai kwa miya ye lau ee kana siga magai me kwa laugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na ena magai hesau tamowaidiyao nige se yogaisinigomiu, magai me kwa laugabaei na kaemiu mukalidi kwa koinihinihiyedi, ye hemala yodi kabakitalobai meta Yaubada kabo ye hekamkamnadi.” ");
INSERT INTO sbe_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ede hekahekatao wa se dalahai se lau magai kesega kesega udiyedi wasa namwanamwana se duwai yo taukasikasiyebwa se henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heloda Antipasi, iya Galili yodi wasawasa, ginauli maudoidi se tubutubu wa wasadi ye lapuidi meta ye nuwapwanopwanokalili, matawuwuna tamowai hekadi se hedede bena Yowane Babatiso boita unai ye toloꞌuyo, ");
INSERT INTO sbe_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","na hekadi se hedede meta Eliya ye taumasalaha, yo hekadiyo yodi nuwatu bena nabada wa unai peloweta hesau ye toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Heloda ye hedede ye wane, “Yowane Babatiso gadona ya boliꞌutusiyako, na teina tamowai ta meta kaiteya, wasana ya lapulapui ta?” Na ye henuwakalili bena Yesu ye kita. ");
INSERT INTO sbe_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolo wa se uyoma na yodi paisowa maudoina wasana Yesu yona se hedehedede. Kabo ye woyaidi se lau magai hesau hesana Betesaida, bena se bom mo menai se miyasuwala. ");
INSERT INTO sbe_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na yodi kabalau wasana wa boda se lapui ede se hemuliwatanidi. Yesu ye kitadi ede ye yogagogoidima na Yaubada yona basileiya wasana yodi ye hedehedede, yo kaiteyadi se kasiyebwa meta ye henamwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na mahana wa ye hetubu bena ye dui ede yona hekahekatao 12 wa se laoma iya unai se wane, “Tamowai ta ku hetamalidi se lau kasa dedeka ta udiyedi yo magai hekadiyo udiyedi na kai yo kabakeno se wase, matawuwuna kita balabalagaibuyena.” ");
INSERT INTO sbe_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na Yesu ye hededelau udiyedi ye wane, “Komiu kai kwa moseidi se kai.” Na se wane, “Kalimaiyena meta pwalawa haligigi yo yama labui mo. Na ku henuwa bena ka lau kai ka hemaisadi boda ta hesabadi?” ");
INSERT INTO sbe_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Boda ne meta loheloheyao nuwana badodi 5,000. Na Yesu ye hededelau yona hekahekatao udiyedi ye wane, “Kwa hededelau udiyedi se tuligogoi, boda kesega kesega luwadi ne unai badodiyao 50.” ");
INSERT INTO sbe_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hekahekatao wa yona hedehedede wa se ginauliwatani ede maudoidi se tuli. ");
INSERT INTO sbe_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na Yesu pwalawa haligigi yo yama labui wa ye haidi na ye kaikewasae galewa ne, na Yaubada ye lautokiyei. Na kabo ye kihidi na ye moseidi yona hekahekatao wa udiyedi, na se moselaeidi boda wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Maudoidi se kaikai meta bogadi se sese. Na hekahekatao kaitole wa se tanogogoi, meta bosa badona 12. ");
INSERT INTO sbe_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Huya hesau Yesu ye tapwatapwalolo na yona hekahekatao se bom mo maiyanao, na ye henamaiyeidi ye wane, “Tamowai se hedede meta yau kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Se wane, “Hekadi se hedede meta kowa Yowane Babatiso, hekadi se hedede bena kowa Eliya, yo hekadiyo se wane, nuwana nabada wa unai peloweta hesau boita unai ye toloꞌuyoma.” ");
INSERT INTO sbe_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na kabo Yesu ye henamaiyeidi ye wane, “Na komiu? Kwa hedede meta yau kaiteya!” Kalinana wa Petelo ye bui ye wane, “Kowa Keliso, Yaubada yona kaisunuwa tamowaina!” ");
INSERT INTO sbe_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na Yesu hedehedede bayabayaona ye moseidi bena tabu tamowai hesau yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na hinage ye hedehededelau yona hekahekatao wa udiyedi ye wane, “Tau Natuna kabo ye kamkamna kabikabi udoiꞌudoi udiyedi. Dius babadadiyao yo taukaitalasam tauwoyaidi yo laugagayo taulauhekataena kabo se subu, yo se unuhemwaloi, na mayadai hehaiyonana unai kabo Yaubada iya ye hetoloꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na kabo ye hedehededelau boda maudoidi wa udiyedi ye wane, “Ena kaiteya ye henuwa ye hemuliwatanigau, meta iya bena ye bom ye nuwagabaeꞌuyoi yo mayadai badobado yona sataulo ye bahei na ye hemuliwatanigau. ");
INSERT INTO sbe_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Matawuwuna kaiteya ye henuwa bena ye bom yona mauli tanoubu ta unai ye kitahetete, meta kabo yona mauli nige kana siga ne ye kabisapuli. Na kaiteya yona mauli tanoubu ta unai ye nuwagabaei yau debaguyena, iya kabo yona mauli nige kana siga ne ye kabihekahini ede. ");
INSERT INTO sbe_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kaniyona ede, ena tamowai hesau tanoubu ta yona namwa maudoina ye hai, na unai ye bom ye heyababaꞌuyoi o yona mauli ye gabagaibui, meta ginauli maudoidi ne udiyedi nige gonowana sagu ye lobai. ");
INSERT INTO sbe_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ena kaiteya ye mwadineigau yo yogu hedehedede ye mwadineidi, meta hinage Tau Natuna kabo iya ye mwadinei yona huyaꞌuyoma ne unai. Huyana ne unai kabo ye laoma ye bom yona didiga yo tamana yo anelu tabudi yodi didiga udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ya hededemamohoi kalimiuyena: Tamowai hekadiyo inai se totolo ta meta taba nige se boita ye lau ee Yaubada yona basileiya se kita.” ");
INSERT INTO sbe_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hedehedede wa mulidiyena mayadai haligigi-haiyona se lau, na kabo Petelo, Yowane, yo Yamesi, Yesu ye woyaidi se sae kuduli hesau unai bena menai ye tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Huyana Yesu ye tapwatapwalolo meta kana kao ye bui, na yona kaleko se buidi se posi yo se sidosidoli. ");
INSERT INTO sbe_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Na tamowai labui, siya ede Mose yo Eliya, ma didididigadi se taumasalaha na Yesu maiyadi se hedehedede. Na Yesu tanoubu yona laugabaeina hedehededena se hedehededei, iya ede Yesu kabo ye hemamohoiyei Yelusalema unai. ");
INSERT INTO sbe_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petelo ma kana kahao wa matadiyao se kenokenokalili. Na se kenotoloꞌuyo meta Yesu ma didigana se kita, yo tatao labui maiyanao se totolo. ");
INSERT INTO sbe_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tatao wa se daladalahai na Petelo ye hededelau Yesu unai ye wane, “Guiyau, ye namwa mo taba inai ta babawa. Taba logulogu haiyona ka ginaulidi, hesau yom, hesau Mose yona, yo hesau Eliya yona.” Na iyamo nige kabina ye kata saha ye hedehededei. ");
INSERT INTO sbe_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sola ma hedehededena na yada ye laoma na ye sumadi, ede se matausi. ");
INSERT INTO sbe_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na yada ne unai kalina hesau ye masalaha ye wane, “Teina yau Natugu, yogu kaisunuwa tamowaina. Kwa lapulau iya unai!” ");
INSERT INTO sbe_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kalina wa ye kaiyawasi, na mahanana ne unai meta Yesu ye bom mo se kita. Na mayadaidi ne udiyedi hekahekatao haiyona saha se kita wa nige se hededehemasalaha tamowai hesau unai. ");
INSERT INTO sbe_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mala ye tom na Yesu yona hekahekatao haiyona wa maiyanao kuduli wa unai se lidi se dobi ede bodalakilaki se lobaidi. ");
INSERT INTO sbe_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boda wa luwadi ne unai tamowai hesau ye yogalau Yesu unai ye wane, “Taulauhekata, ya kaibwadaigo bena natugu loheya ta ku kita! Iya natugu kesega mo. ");
INSERT INTO sbe_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yaluwa hesau kana paisowa iya ye luwui na ye yogahi, yo ye kikikikiwasi na kawana ne unai gwasapulo se pesapesa. Yaluwa yabayababana wa wawaya ne nige ye laulaugabaei na ye hekamkamnakaliliyei. ");
INSERT INTO sbe_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yom hekahekatao ya kaibwadaidi bena se hededehepesa, na nige gonowadi.” ");
INSERT INTO sbe_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ye wane, “Komiu isi ta meta nige yomi sunuma, yo nuwatu yabayababadi tamowaidiyao. Kabo ya miyaꞌuyo lohana doha saha kalimiuyena? Kwa kamnayabayababa! Na natum me ku woyaiyama!” ");
INSERT INTO sbe_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Loheya wa ye laolaoma na yaluwa bikibikina iya ye tuudobiyei bwatano wa unai na ye kikikikiwasi. Yesu ye hededebayao yaluwa bikibikina wa unai na loheya wa ye henamwanamwa na ye moseiꞌuyoi tamana unai. ");
INSERT INTO sbe_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Na boda maudoidi wa se nokokalili Yaubada yona gigibwali saesaena wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Tamowai wa sola ma nokonokodi Yesu yona laulau maudoidi udiyedi, na Yesu ye hededelau yona hekahekatao udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yogu hedehedede ta kwa lapunamwanamwaedi: Tamowai hesau kabo Tau Natuna kana ye walohai na ye moselaei tamowai nimadiwai.” ");
INSERT INTO sbe_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na hedehedede wa kaniyona nige se nuwatulobai, matawuwuna Yaubada ye tolewadam kalidiyena, na tabu se nuwatulobai. Na se matausi, ede nige se henamaiyei. ");
INSERT INTO sbe_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huya hesau Yesu yona hekahekatao se bom se haihaikawayagalaꞌuyoidi, matawuwuna ede luwadi ne unai kaiteya ye saekalili. ");
INSERT INTO sbe_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na yodi nuwanuwatu wa Yesu kabidi ye katako, ede wawaya hesau ye hai na dedekana wa unai ye hetolo. ");
INSERT INTO sbe_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na ye hededelau udiyedi ye wane, “Ena kaiteya wawaya gagilina ta ye yogaisini yau debaguyena, meta yau ye yogaisinigau. Yo kaiteya ye yogaisinigau, meta hinage tauhetamaligau ye yogaisini. Luwamiu ne unai kaiteya se kitadobidobiyei, meta iya ye saekalili Yaubada matanawai.” ");
INSERT INTO sbe_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowane ye hedehedede ye wane, “Tanuwaga, tamowai hesau ka kita hesamyena yaluwa yabayababadi ye hededehepesadi, na ka hededehekaiyawasi, matawuwuna iya nige kada kaha hesau kada boda ta unai.” ");
INSERT INTO sbe_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na Yesu ye wane, “Tabu kwa hededehekaiyawasi, matawuwuna ena kaiteya nige ye haikabi kalimiuyena, meta iya tausaguigomiu hesau.” ");
INSERT INTO sbe_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu yona sae galewa mayadaina ye hanahanau ede nuwana ye tolekesegai na ye dalahai ye lau Yelusalema. ");
INSERT INTO sbe_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na tautauwasa hekadiyo ye hetamalidi se baguna se lau Samaliya magaina hesau unai bena ginauli maudoidi se nonohaidi iya hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na magai wa tamowaidi Yesu nige se yogaisini, matawuwuna ye laulau Yelusalema hesabana. ");
INSERT INTO sbe_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yona hekahekatao Yamesi yo Yowane saha ye tubu wa se kita ede Yesu se henamaiyei se wane, “Guiyau, ku henuwa bena ka yogasae galewa ne unai kaiwa kalakalasina ye dobima ye heyababadi?” ");
INSERT INTO sbe_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Na Yesu ye tolobui ede ye hededebayao kalidiyena na ye hekaiyawasidi, ");
INSERT INTO sbe_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","na kabo se dalahaiꞌuyo se lau magai hesau. ");
INSERT INTO sbe_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Keda wa unai se laulau, na tamowai hesau ye hededelau Yesu unai ye wane, “Yom kabalau maudoidi udiyedi yau kabo ya hemuliwatanigo.” ");
INSERT INTO sbe_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ye hededebui ye wane, “Kedewa nukula yodi duha, yo hinage manuwa yodi noi, na Tau Natuna nige yona kabakaiyawasi mamohoina hesau.” ");
INSERT INTO sbe_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu ye hededelau tamowai hesau unai ye wane, “Ku hemuliwatanigau!” Na tamowai wa ye wane, “Guiyau, taba gonowana ya uyo magai na tamagu toletoletauna ya kitabagunai.” ");
INSERT INTO sbe_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Yesu ye wane, “Kaiteyadi se boitako meta siya bena kehadi tauboita ne se lae bwayabwaya unai se tole, na ku lau Yaubada yona basileiya wasana ku hededehemasalaha.” ");
INSERT INTO sbe_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yo hinage tamowai hesau ye wane, “Guiyau, kabo ya hemuliwatanigo, na taba ya uyo kagu bodao ya laukaiyoniyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ye hededebui unai ye wane, “Kaiteya ye hetubu ye paisowa na sola ye kitakitabui, meta nige gonowana Yaubada yona basileiya paisowana ye ginauli.” ");
INSERT INTO sbe_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mulina ne unai Guiyau tauhemuhemuliwatanina hekadiyo badodi 72 ye kaisunuwaidi na ye hetamalidi labui labui se bagunalau yona kabalau ne magaidiyao lakilakidi yo gagilidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ye hededelau udiyedi ye wane, “Koya ye masulikalili, na taupaisowa meta nige se bado. Unai kwa kaibwadalau koya tanuwagana unai kabo taupaisowa ye hetamalidima. ");
INSERT INTO sbe_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kwa lau, na bena kwa kitakitanamwanamwa! Ya hetamaligomiu ta kana kao doha mamoe se lau kedewa nukula kaikaikalasidi luwadiyena. ");
INSERT INTO sbe_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tabu moni tobwana, yomi tobwa, yo kami buti kwa bahebaheidi, yo tabu mahana kwa gabagabai kedaena tamowai hailobaidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Huyana kwa mwalaesae numa hesau unai meta yomi hedehedede bagubagunana kwa wane, ‘Taba Yaubada nuwadaumwali ye tole numa ta unai!’ ");
INSERT INTO sbe_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ena numa me unai tamowai hesau nuwadaumwali ye henuwa, kabo nuwadaumwali kwa mosei wa ye miyamiya iya unai. Ena nige, meta nuwadaumwali ne kabo ye uyowa kalimiuyena. ");
INSERT INTO sbe_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ena se yogaisinigomiu, meta numa ne unai kwa miya na saha se haiyawa meta kwa kai yo kwa numa. Matawuwuna taupaisowa yona dudulai ede taba yona paisowa maisana ye hai. Na tabu kwa lau numa hesau yo hesau unai. ");
INSERT INTO sbe_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ena magai hesau unai kwa lage na se yogaisinigomiu na kai saha se haiyawa meta kwa kai. ");
INSERT INTO sbe_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Magaina ne unai taukasikasiyebwa kwa henamwanamwadi yo kwa hededelau udiyedi kwa wane, ‘Yaubada yona basileiya ye hanahanaumako kalimiuyena.’ ");
INSERT INTO sbe_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na ena magai hesau unai kwa lage na nige se yogaisinigomiu meta kwa lau magai ne kedana unai na kwa wane, ");
INSERT INTO sbe_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yomi magai mukalidi se kalapatu kaemaiyao udiyedi kabo ka saugabaedi, ye hemala yomi kabakitalobai meta Yaubada kabo ye hekamkamnagomiu. Na iyamo bena kabina kwa kata meta Yaubada yona basileiya ye hanahanaumako.’ ");
INSERT INTO sbe_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya hededelaowa kalimiuyena: Yaubada yona hekasa mayadaina ne unai tausubugomiu ne kabo ye hekamkamnakaliliyeidi, na kabo Sodoma tamowaidiyao. ");
INSERT INTO sbe_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ahani mo komiu Kolasini tamowaidiyao! Ahani mo komiu Betesaida tamowaidiyao! Yababa lakilakina kabo kwa hekalo! Laulau gigigigibwalidi ya ginaulidi kalimiuyena wa, taba ya ginaulidi magai yabayababadi Taiya yo Sidona udiyedi, meta tamowaidiyao kabo se nuwabuiko, na yodi nuwabui ta unai meta kabo nuwadubu kalekodiyao se luwuidi yo taudi maudoidi se hekahusadi. ");
INSERT INTO sbe_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yaubada yona hekasa mayadaina ne unai kabo kwa kamkamnakalili na kabo Taiya yo Sidona. ");
INSERT INTO sbe_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na komiu Kapelenauma tamowaidiyao, yomi nuwatu bena kabo Yaubada ye lausinigomiu kwa sae galewa? Taba nige! Kabo kwa dobi Hade unai. ");
INSERT INTO sbe_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kaiteya ye lapulaowa kalimiuyena meta ye lapulaoma kaliguyena. Yo kaiteya ye subugomiu meta ye subugau. Na kaiteya ye subugau meta hinage tauhetamaligau ye subu.” ");
INSERT INTO sbe_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesu tauhemuhemuliwatanina badodi 72 wa se uyoma ma gwaugwauyaladi, se wane, “Guiyau, huyana hesamyena ka hedehedede meta yaluwa yabayababadi hinage se kawakabiyegai.” ");
INSERT INTO sbe_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kabo Yesu ye hededelau udiyedi ye wane, “Satani galewa ne unai ye bekudobima ya kita kana kao doha namanamali. ");
INSERT INTO sbe_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kwa lapui, gigibwali ya haiyawa ede gonowana mwata yo gigidonadona kewadiyena kwa utu, yo hinage waiunu yona gigibwali maudoina kwa saedikwai. Na nige gonowana saha hesau ye heyababagomiu. ");
INSERT INTO sbe_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Iyamo tabu kwa gwauyala matawuwuna yaluwa yabayababadi se kawakabiyeigomiu. Na bena kwa gwauyala matawuwuna Yaubada hesamiyao ye kulidiko galewa ne unai!” ");
INSERT INTO sbe_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tenem mahanana ne unai Yaluwa Tabuna Yesu ye hegwauyalakaliliyei na ye hededelau tamana unai ye wane, “Tamagu, kowa galewa yo tanoubu Guiyauna, ya hedebasaego matawuwuna ginauli maudoidi wa ku tolewadamdi na tausonoga yo tausibasiba nige gonowana se nuwatulobaidi. Na tamowai supusupudi udiyedi ginauli ta ku tolehemasalahadi na se nuwatulobaidi. Mamohoi, tamagu, teina ta yom nuwatu mamohoina yo yom kabagwauyala ede. ");
INSERT INTO sbe_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tamagu tanuwaga gigibwalina maudoina ye leyama kaliguwai, na iya ye bom mo natuna kana kao kabina ye kata, na natuna ye bom mo tamana kana kao kabina ye kata, yo kaiteyadi natuna ye kaisunuwaidi bena tamana kana kao ye hemasalaha siya udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na Yesu ye tolobui yona hekahekatao udiyedi na se bom yodi ye hedehedede ye wane, “Komiu gonowana kwa gwauyala matawuwuna ginauli maudoidi ta kwa kitadi. ");
INSERT INTO sbe_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na ya hededelaowa kalimiuyena: Huya bagubagunana unai, peloweta yo wasawasa se badokalili ginauli saha kwa kitadi ta se henuwa bena se kitadi, yo saha kwa lapuidi ta hinage bena se lapuidi. Na iyamo siya nige gonowana se kitadi yo se lapuidi.” ");
INSERT INTO sbe_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laugagayo taulauhekataena hesau ye henuwa bena Yesu ye lautonogi, ede ye henamaiyei ye wane, “Taulauhekata, taba saha ya ginauli, kabo mauli nige kana siga ya hai?” ");
INSERT INTO sbe_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ye hededebui ye wane, “Laugagayo bukana unai saha se kuli? Yom nuwatulobaina kana kao doha saha?” ");
INSERT INTO sbe_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ede tamowai wa ye hededebui ye wane, “Kulikuli tabuna unai se kuliyako ede, ‘Guiyau yom Yaubada ku gadosisiyei ma nuwam maudoina, ma yaluwam maudoina, yom bayao maudoina yo yom nuwanuwatu maudoina unai’ , yo hinage: ‘Kowa helem taumiya tamowaina ku gadosisiyei kana kao doha ku bom ku gadosisiꞌuyoigo.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ye wane, “Ku hedededudulai, na teina laulau ta ku miyawatanidi, kabo mauli nige kana siga ku hai.” ");
INSERT INTO sbe_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na laugagayo taulauhekataena wa ye henuwa bena ye bom ye hededehesaeꞌuyoi meta iya laulaududulai tamowaina, ede Yesu ye henamaiyei ye wane, “Helegu taumiya tamowaina ede kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ye hededebui ye wane, “Huya hesau unai tamowai hesau Yelusalema unai ye dobidobi Yeliko na taukaiwahali se kabihekahini, yona kaleko se pulisihaidi, se biteliyababai na se laugabaei ye miyamiya sabi boitana. ");
INSERT INTO sbe_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Keda kesekesegana unai taukaitalasam hesau ye dobi na huyana tamowai wa ye kita meta ye kawasilau keda wa dedekana hesau unai ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Keda kesekesegana wa unai hinage Lewi tamowaina hesau ye dobima ye lau na tamowai wa ye kita meta keda wa teha hesau ye hai na ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na Samaliya tamowaina yona kabalauyena ye lage tamowai wa unai na ye kita meta ye katekamkamnaei. ");
INSERT INTO sbe_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ye lau unai, olibe yausina yo waina ye inidobiyedi kana gai wa udiyedi na ye sumadi. Na kabo tamowai wa ye hetulisaei yona donki unai na ye laei taukadau yodi kabakeno numana hesau na menai ye kitahetete. ");
INSERT INTO sbe_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mala ye tom ede denali labui ye haidi na ye moseidi numa wa taukitakitahetetena unai na ye wane, ‘Tamowai ta ku kitahetete na yom gabae saha iya unai, yogu uyoma ne unai kabo ya hedudulai.’” ");
INSERT INTO sbe_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na Yesu laugagayo taulauhekataena wa ye henamaiyei ye wane, “Yodi haiyona ta udiyedi meta kaiteya yona kabikabi taukaiboita ne unai doha iya helena taumiya tamowaina?” ");
INSERT INTO sbe_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Laugagayo taulauhekataena wa ye wane, “Taukatekamkamnaena wa.” Ede Yesu ye wane, “Ku lau na laulau gonogonowana ne ku ginauliwatani!” ");
INSERT INTO sbe_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu maiyana hekahekatao se dalahai se lau ee magai hesau unai se lage. Na sinebada hesau hesana Maleta Yesu ye yogaisini yona numa wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kana kaha hesana Maliya, iya ye tulidobi Guiyau kaena dedekanawai na ye lapulapulau yona hedehedede wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maleta ye modekalili kana taumana wa kana kai kabinonohaina hesabana. Ede ye laoma Yesu unai ye wane, “Guiyau, idohagi to nige ku mode meta kagu kaha ye kitagabaegau na paisowa maudoidi ne ya bom ya ginaulidi? Ku hedede na ye laoma ye saguigau!” ");
INSERT INTO sbe_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Guiyau yona bui ye mosei ye wane, “Maleta, Maleta, kowa meta ku nuwanuwatu yo ku nuwamodemodekalili ginauli se badokalili udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Na ginauli kesega mo ye saekalili ede Maliya ye kaisunuwai ta, na taba nige gonowana ya haigabaei kalinawai!” ");
INSERT INTO sbe_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mayadai hesau Yesu ye tapwatapwalolo teha hesau unai. Huyana ye tapwalolo ye gehe ede yona hekahekatao wa hesau ye hededelau unai ye wane, “Guiyau, tapwalolo kabikabina ku hekatagai, gonogonowana doha Yowane yona hekahekatao ye hekatadi.” ");
INSERT INTO sbe_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na Yesu ye hededelau udiyedi ye wane, “Yomi huyatapwalolo unai meta kwa hedede kwa wane, Tamamai, Kowa hesam ka hededetausaei. Yom basileiya bena ye laoma. ");
INSERT INTO sbe_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mayadai kesega kesega kaina kamai ku ledima. ");
INSERT INTO sbe_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yoma yababa ku nuwatugabaedi matawuwuna kai hinage tauheyababagai yodi yababa ka nuwatugabaedi. Bena ku kitahetetegai na taba nige ka lulau noho luwanaena.” ");
INSERT INTO sbe_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na Yesu yona hedehedede wa ye tubei ye wane, “Nuwana boniyai duwaduwalina unai na ku lau kam kaha yona numa unai na ku wane, ‘Kagu kaha, gonowana pwalawa tupi haiyona ku haidima? ");
INSERT INTO sbe_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kehagu hesau yona kabakadau unai ye lagema yogu numaena, na nige kai hesau kaliguyena kabo ya mosei.’ ");
INSERT INTO sbe_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nuwana kabo numa kalona unai kam kaha ne ye hededebui ye wane, ‘Tabu ku hemohemodegau. Keda ya guduiyako na yau yo natuguwao meta ka kenokeno. Nige gonowana ya tolo na saha hesau ya haiyawa.’ ");
INSERT INTO sbe_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na ya hededelaowa kalimiuyena: Nuwana kam kaha ne nige ye henuwa bena ye tolo na saha hesau ye leyawa kawakeha debanaena. Iyamo hesana hekasisina debanaena ede kabo ye tolo na saha ku kaibwadai wa kabo ye leyawa. ");
INSERT INTO sbe_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ede ya hededelaowa kalimiuyena: Kwa kaibwada Yaubada unai, kabo saha kwa kaibwadai wa ye leyawa. Kwa wase, na kabo saha kwa wasewasenei wa Yaubada ye saguigomiu na kwa lobai. Yo hinage keda guduna unai kwa koikoi, kabo keda ye sokeyawa. ");
INSERT INTO sbe_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Matawuwuna ede taukaikaibwada saha se kaibwadai wa kabo se hai, yo tauwasewase saha se wasenei wa kabo se lobai, yo keda kabo ye soke kaiteyadi taukoikoi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kowa kaiteya tama, ena natum loheya ye kaibwada yama, kabo mwata ku mosei? ");
INSERT INTO sbe_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ye kaibwada pou, kabo gigidonadona ku mosei? ");
INSERT INTO sbe_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Komiu tamowai yabayababadi, na iyamo kabina kwa kata meta ginauli namwanamwadi bena kwa moseidi natumiyao udiyedi. Na Tamamiu galewa ne unai meta ye namwakalili, unai kabo Yaluwa Tabuna ye mosei siya kaiteyadi taukaikaibwadaina udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Huya hesau Yesu tamowai unaꞌunana unai yaluwa yabayababana ye hededehepesa, na huyana ye pesa meta tamowai unaꞌunana wa ye hedehedede. Boda wa se nokokalili, ");
INSERT INTO sbe_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","na iyamo tamowai hekadi se hedede se wane, “Yaluwa yabayababadi kadi tanuwaga Belesebulu yona gigibwaliyena yaluwa yabayababadi ye hededehepesadi.” ");
INSERT INTO sbe_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na hekadiyo se henuwa bena Yesu se lautonogi, unai se kaibwadai bena galewa hekihekinoina hesau ye ginauli se kita. ");
INSERT INTO sbe_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Na yodi nuwanuwatu wa Yesu kabidi ye kata. Unai ye hededelau udiyedi ye wane, “Taba basileiya hesau ye bom ye lulululuꞌuyoi, meta kabo se heyababaꞌuyoidi. Yo taba numa hesau tamowaidiyao se bom se haitoledagelaꞌuyoidi, kabo se bom se hetatagwaligwaliꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Taba Satani yona taupaisowa yaluwa yabayababadi ye hewaiunudi, meta yona basileiya kabo idohagi bena ye tolobayao? Doha teina ya hedede, matawuwuna kwa wane bena Belesebulu yona gigibwaliyena yaluwa yabayababadi ya hepesadi. ");
INSERT INTO sbe_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na yomi nuwatu saha, ena yau Belesebulu yona gigibwaliyena ya hepesadi, meta tauhemuliwatanigomiu kabo kaiteya yona gigibwaliyena se paisowa? Unai siya kabo se hegilugomiu meta kwa laupwano. ");
INSERT INTO sbe_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na ena Yaubada yona gigibwaliyena yaluwa yabayababadi ya hededehepesadi, meta Yaubada yona basileiya ye laomako kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Na taba tamowai bayabayaona yona iyala gogodi ye nonohaidi na yona numa ye kitahetete, meta yona gogo maudoidi kabo se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Na taba tamowai hesau bayabayaokalilina ye lagema maiyana se lulu na numa tanuwagana wa ye saedikwai, ede numa tanuwagana yona iyala gogodi ye sunumaeidi bena kabo se sagui wa ye haigabaeidi yo yona gogo maudoidi ye soiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kaiteya nige ye hemuhemuliwatanigau, iya meta tauhewaiunugau. Yo kaiteya nige ye saguigau na tamowai ka woyagogoidima, iya meta tauhetatagwaligwali. ");
INSERT INTO sbe_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Huyana yaluwa bikibikina tamowai ye pesagabaei, meta kabo ye lau balabalagaibuyena yona kabakaiyawasi ye wasenei, na nige hesau ye lobai. Kabo ye wane, ‘Ya uyo numa ya laugabaeiꞌusei wa unai.’ ");
INSERT INTO sbe_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ye lageꞌuyo numa wa ye kita meta se kuyaheꞌaꞌa yo se gwaugogonamwanamwaei. ");
INSERT INTO sbe_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kabo ye lau yaluwa yabayababadi haligigi-labui ye woyaidima. Siya se yababakalili na kabo iya, na numa wa unai se lusae na se miya. Ede tamowai wa yona mauli ye yababakalili na kabo yona mauli bagubagunana wa.” ");
INSERT INTO sbe_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ye hedehededegehe ede sinebada hesau boda wa unai ye yogalau Yesu unai ye wane, “Sinam taulabasigo yo tauhesusugo, iya gonowana ye gwauyala!” ");
INSERT INTO sbe_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na Yesu yona bui ye mosei ye wane, “Nigele! Na kaiteyadi Yaubada kalinana se lapui yo se kawakabiyei, meta siya gonowana se gwauyala.” ");
INSERT INTO sbe_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Boda wa ye laki ye lau na Yesu se tolohetakikili na ye hedehedede ye wane, “Teina isi ta meta isi yabayababana. Se henuwa bena hekihekinoi ya ginauli se kita yodi kabahemamohoiyeigau. Na taba nige hekihekinoi hesau se kita, na Iyona hekihekinoina mo ye bom. ");
INSERT INTO sbe_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iyona meta Ninewa tamowaidiyao yodi hekihekinoi, na gonogonowana doha Tau Natuna teina isi ta yodi hekihekinoi. ");
INSERT INTO sbe_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yaubada yona hekasa mayadaina ne unai magai Siba yodi wasawasa waihiuna kabo ye tolo na teina isi ta tamowaidiyao ye hegiludi, matawuwuna kedalohaloha unai ye laoma bena Solomona yona hededesonoga ye lapuidi. Na tamowai hesau iya ede inai, ye sonogakalili na kabo Solomona. ");
INSERT INTO sbe_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hekasa mayadaina ne unai Ninewa tamowaidiyao kabo hinage se tolo na teina isi ta tamowaidiyao se hegiludi, matawuwuna ede Iyona yona lauguguyaena Ninewa tamowaidiyao wa se nuwabui. Na mayadai ta unai tamowai hesau ye saekalili na kabo Iyona, iya ede maidamiu ta.” ");
INSERT INTO sbe_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kabo Yesu ye wane, “Nige tamowai hesau lampa ye gabu na ye tolewadam o walata unai ye buikasini, na lampa kabatolena unai ye tole, to tamowai se mwalai kabo gonowana dawayana se kita. ");
INSERT INTO sbe_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matada meta siya tauda ta malana ede. Ena matada se nega meta kabo tauda maudoina ta ye dawaya. Na ena matada se yababa meta tauda maudoina ta kabo ye masigili. ");
INSERT INTO sbe_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bena kwa kitanamwanamwa meta dawaya ne kalimiuyena, na tabu masigili. ");
INSERT INTO sbe_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ena taum maudoina ne dawaya ye hemwayau, na nige teha hesau ye masigili, meta kabo dawaya lakilakina kalimyena, doha lampa dawayana ye talu kalimyena.” ");
INSERT INTO sbe_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Huyana Yesu ye hedehededegehe meta Paliseya tamowaina hesau ye kaibwadai ye lau maiyana se kaikai. Ede ye mwalae na ye kenodobi kabakaikai hatana unai bena ye kaikai. ");
INSERT INTO sbe_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Paliseya tamowaina wa ye kita meta Yesu nige nimana ye deulibagunaeidi doha kadi kulutubu yodi kabikabi mamohoina unai. Ede ye siliyata. ");
INSERT INTO sbe_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na Guiyau ye hededelau iya unai ye wane, “Komiu Paliseya tamowaidiyao kami keyaka yo gaeba dageladiyao ne kwa deuliheꞌaꞌadi, na luwamiyao ne meta mahimahihi yo miyamiya yabayababadi se mwayau! ");
INSERT INTO sbe_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Komiu meta kwa yauyaulekalili! Yaubada taumiu ye ginaulidi wa, iya nuwamiu hinage ye ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ginauli saha yomi gaeba ne udiyedi, kwa kainauyaidi taudehadeha udiyedi, na kabo nuwamiu yo taumiu se aꞌa Yaubada matanaena. ");
INSERT INTO sbe_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ahani mo komiu Paliseya tamowaidiyao, matawuwuna yomi koya udiyedi lugulugu gagilidi kai kabahepahepanedi udiyedi taiti kwa toletole, na laulau dudulaidi yo Yaubada gadosisina nige kwa modelau udiyedi. Taba laugagayo maudoidi kwa miyawatanidi, yo hinage laulau namwanamwadi hekadi wa tabu kwa kitagabaedi. ");
INSERT INTO sbe_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ahani mo komiu Paliseya tamowaidiyao. Matawuwuna sunago udiyedi kabatuli saesaedi kwa henuwadi, yo kwa henuwa bena tamowai se lautokiyeigomiu ma hekasisidi kabalokulokune udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ahani mo komiu. Komiu kami kao doha bwayabwaya nige udiyedi hekihekinoi se toledi, na kewadiyena tamowai se sae se dobi na nige kabina se kata meta saha luwadi ne udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Laugagayo taulauhekataena tamowaina hesau ye hededelau Yesu unai ye wane, “Taulauhekata, yom hedehedede ne udiyedi kai hinage ku hededeheyababagai!” ");
INSERT INTO sbe_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu ye hededebui ye wane, “Na komiu laugagayo taulauhekataena tamowaidiyao, ahani mo komiu. Matawuwuna laugagayo se badokalili kwa moseidi tamowai udiyedi. Kadi kao doha bahebahe polopolohekalilidi, na nige gonowana se lauwatanidi. Na komiu nige yomi sagu gagilina unai kwa saguidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ahani mo komiu. Matawuwuna peloweta bwayabwayadi kwa kabinamwanamwaedi yo hekihekinoidiyao kwa hetolodi, na kami kulutubuwao siya se unuidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Laulau ta unai kwa hemasalaha meta kami kulutubuwao maidamiyao nuwamiu kesega. Siya peloweta wa se unuidi, na komiu kwa saguidi na bwayabwayadi hekihekinoidiyao kwa ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Unai ede Yaubada yona sibasiba unai ye hedede ye wane, ‘Kabo peloweta yo apostolo ya hetamalidi se lau kalidiyena. Hekadi kabo se unuhemwaloidi na hekadi se hewaiunudi!’ ");
INSERT INTO sbe_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Unai Yaubada teina isi ta ye hegiludi peloweta kwasinadi maudoidi tamowai se hebwalilidi wa debadiyena, tanoubu yona huyahetubu unai ye laoma ye lau ee teina mayadai ta, ");
INSERT INTO sbe_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","yo Abela kwasinana unai ye hetubu na ye laoma ye lau ee Sakaliya, iya ede kabakaitalasam yo Numa Tabuna duwaduwalidiyena se koihemwaloiꞌusei wa. Mamohoi, yomiu ya hedehedede, yababa maudoidi ta giludi meta huya ta tamowaidi kabo se bahei. ");
INSERT INTO sbe_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ahani mo komiu laugagayo taulauhekataena. Matawuwuna ede sonoga kabahaina kedana wa kwa gudui na kana kii kwa haigabaei. Komiu nige kwa henuwa bena kwa mwalaei na sonoga kwa hai, na kaiteyadi se henuwa bena se mwalae meta kwa hekaiyawasidi.” ");
INSERT INTO sbe_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Huyana Yesu numa wa ye laugabae ede Paliseya yo laugagayo taulauhekataena tamowaidi se hetubu iya se hewaiunukaliliyei, yo henamai udoiꞌudoi udiyedi se lautonogi ");
INSERT INTO sbe_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","taba idohagi na yona hededebui unai ye hededepwano na unai kabo se hegilu. ");
INSERT INTO sbe_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Paliseya yo laugagayo taulauhekataena tamowaidi yodi henahenamai wa sola se laulau na boda lakilakikalilina se lagegogoi meta se haiheduhedunaꞌuyoidi. Iyamo Yesu ye hedehededebaguna yona hekahekatao udiyedi ye wane, “Bena kwa kitanamwanamwa Paliseya yodi yisti udiyedi, teina ta meta yodi kailupolupo kabikabidi. ");
INSERT INTO sbe_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ginauli wadawadamdi maudoidi meta kabo se masalaha, yo nuwanuwatu wadawadamdi maudoidi Yaubada kabo ye tolehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saha boniyaiyena kwa hedehededei meta kabo mayadaiyena se hededehemasalaha, na numakalo unai saha tamowai beyadi udiyedi kwa gadigadigugulau meta kabo boda matadiyena se hededehemasalahadi.” ");
INSERT INTO sbe_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Na Yesu yona hedehedede ye tubei ye wane, “Kagu kahao, ya hededelaowa, tabu buluma tauhemwaloina kwa matausiyeidi, na nige gonowana saha hesau se ginauliꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na kabo yomiu ya hedehedede meta kaiteya bena kwa matausiyei: Yaubada bena kwa matausiyei. Iya gonowana ye kaiunu yo hinage yona gigibwali gonowana unai ye gabalaegomiu kaiwa kalakalasina unai. Ya hededelaowa kalimiuwai: Yaubada bena kwa matausiyei! ");
INSERT INTO sbe_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hage, ta nuwatulau pekopeko udiyedi. Maisadi se gagilikalili, na badodi haligigi meta se lokuneidi moni gagilidi labui mo udiyedi. Na iyamo Yaubada nige hesau ye nuwaluluhiyei. ");
INSERT INTO sbe_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yo hinage kulumiu maiyawadi meta ye hasilidiko. Unai tabu kwa matausi. Komiu kwa saekalili na kabo pekopeko yawoina.” ");
INSERT INTO sbe_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kabo Yesu ye wane, “Ya hededelaowa kalimiuyena: Kaiteya boda matadiyena ye hededehemasalahaꞌuyoi meta iya tauhemuliwatanigau, Tau Natuna hinage kabo ye hededehemasalaha Yaubada yona anelu udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na kaiteya ye uhalaegau boda matadiyena meta hinage kabo ya uhalaei Yaubada yona anelu matadiyena. ");
INSERT INTO sbe_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ena kaiteya Tau Natuna ye hededeheyababa meta Yaubada kabo yona yababa ne ye nuwatugabaei. Na ena kaiteya Yaluwa Tabuna ye hededeheyababa meta Yaubada taba nige yona yababa ne ye nuwatugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Huyana se woyalaegomiu sunago babadadiyao yo magai tanuwagadiyao yo tamowai lakilakidi hekadiyo udiyedi bena se helauhetalagomiu, meta tabu kwa mode kabo idohagi yodi bui kwa moseidi o saha kwa hedede, ");
INSERT INTO sbe_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","matawuwuna mahanana ne unai Yaluwa Tabuna kabo ye hekatagomiu na saha kwa hedede.” ");
INSERT INTO sbe_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kabo tamowai hesau boda wa luwadiyena ye hededelau Yesu unai ye wane, “Taulauhekata, ku hededelau kagu kaha ne unai taba gonowana tamamai yona gogo ye boitagabaeidi wa ye hekasadi na yogu ye haidima.” ");
INSERT INTO sbe_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu ye hededebui ye wane, “Kehagu, teina gogo ta udiyedi yau nige yomi tauhekasa o tautolehedudulai.” ");
INSERT INTO sbe_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na ye hededelau maudoidi kalidiyena ye wane, “Kwa kitahetetenamwanamwaegomiu na mahimahihi kabikabidi udoiꞌudoi bena kwa kaihaleidi. Matawuwuna mauli kaniyona mamohoina meta nige yomi gogo badobadodi ne udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na kabo Yesu palabole hesau ye hedede udiyedi ye wane, “Taubada hesau gogogogona yona tano unai meta witi masulina ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ye nuwanuwatu na ye wane, ‘Yogu witi masulina maudoina ta nige yogu kabagwaugogoina. Saha kabo ya ginauli?’ ");
INSERT INTO sbe_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na ye bom yona ye hedehedede ye wane, ‘Teina doha kabo ya ginauli: Kabo yogu like kabagwaugogoina bagubagunadi wa ya haigabaeidi na lakilakidi ya ginaulidi. Na udiyedi kabo yogu witi masulina ta yo yogu gogo namwanamwadi maudoidi ya gwaugogoidi. ");
INSERT INTO sbe_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na kabo ya bom ya hedede ya wane, “Taubada gogogogona, yom kabagwaugogo udiyedi meta ginauli namwanamwadi ku gwaugogoidi, na kabo ku hepaisowadi bolimai lohaloha. Unai kabo paisowa maudoidi udiyedi ku kaiyawasi, na ku kai, ku numa, yo ku gwauyala mo.” ’ ");
INSERT INTO sbe_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Na Yaubada ye hededelau kalinawai ye wane, ‘Kowa yauyaule! Teina boniyai ta unai kabo yom mauli ya haigabaei, na yom gogo ku gwaugogoidi kowa hesabam ta kabo kaiteya ye haidi?’” ");
INSERT INTO sbe_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kabo Yesu ye hedede ye wane, “Teina laulau ta kabo se tubu kaiteyadi yodi gogo se gwaugogoidi siya se bom hesabadi, na nige gogo siya ede Yaubada kalinawai se saekalili wa se gwaugogoidi.” ");
INSERT INTO sbe_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kabo Yesu ye hededeꞌuyo yona hekahekatao wa udiyedi ye wane, “Unai ya hededelaowa kalimiuyena: Tabu kwa nuwanuwatukalili yomi mauli hesabana, bena saha kabo kwa kai, yo taumiu ta hesabana, saha kabo kwa likwa. ");
INSERT INTO sbe_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mauli ye saekalili na kabo kai, yo taumiu ta ye saekalili na kabo kaleko! ");
INSERT INTO sbe_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hage, aoꞌao kwa nuwatuidi: Nige se kumakuma, yo nige se kelikeli, yo nige yodi sanala o kabagwaugogo numadi. Na Yaubada ye hekahekaidi. Na komiu meta kwa saekalili na kabo manuwa! ");
INSERT INTO sbe_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Luwamiu ne unai kaiteya ye nuwanuwatukalili na unai gonowana kabo mahana kesega ye tolelaei yona mauli ne unai na ye helohaꞌuyoi? ");
INSERT INTO sbe_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na komiu nige gonowana teina ginauli gagilina ta kwa ginauli, unai ede tabu kwa nuwamodemode ginauli hekadiyo ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Taba pasa gagilidi kwa nuwatuidi idohagi yodi kinikini. Nige se paisowa, nige kadi kwama se ginaulidi, na ya hededelaowa kalimiuyena: Solomona yona wasawasa kalekodiyao nige hesau kana kao ye didiga doha tenem pasa ne. ");
INSERT INTO sbe_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ena Yaubada lagau ne kadi kao ye henamwadi, siya ede wau se lala na malaitom se gabudi se kalasi, meta iya gonowana kabo kaleko namwanamwadi udiyedi komiu ye hekalekogomiu. Mamohoi, komiu sunuma gagilidi tamowaidiyao! ");
INSERT INTO sbe_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Unai huya maudoina nuwamiu tabu kwa hemodedi kabo saha kwa kai o kwa numa, yo tabu udiyedi kwa nuwanuwatukalili. ");
INSERT INTO sbe_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Teina ginaulidi ta meta Yaubada nige tausunumaena tanoubu ta unai se henuwakaliliyeidi. Na kami henuhenuwa maudoidi ta tamamiu kabidi ye katako. ");
INSERT INTO sbe_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na komiu bena Yaubada yona basileiya nuwanuwatuna kwa tolebagunai, na kabo ginauli maudoidi ta hinage ye lediwa kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kabo Yesu ye wane, “Komiu yogu hekahekatao bodana gagilina ta, tabu kwa matausi. Matawuwuna tamamiu ye henuwakalili bena yona basileiya unai maiyamiu kabo kwa tanuwaga. ");
INSERT INTO sbe_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yomi gogo kwa lokuneidi na monidi kwa moseidi taudehadeha udiyedi. Ena doha teina kwa ginauli meta yomi wasawasa galewa ne unai kwa helakidi, na nige gonowana se beyabeya yo se pwasa. Teina wasawasa ta taukaiwahali nige gonowana se kaiwahalidi yo sulasula nige gonowana se kaidi. ");
INSERT INTO sbe_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Matawuwuna ede kaiteya teha unai yomi wasawasa se miyamiya, meta nuwamiu ede temenai.” ");
INSERT INTO sbe_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu yona hedehedede ye tubei ye wane, “Yomi kaleko bena kwa likwadi na kwa nonoha paisowa hesabana yo yomi lampa bena se kalakalasi. ");
INSERT INTO sbe_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kami kao doha heyayai tauhaidi kadi tanuwaga tawasola kaikaigogona unai ye uyoma na se nayanayai. Na huyana ye lage na yona numa kawakedana unai ye koikoi, siya kabo gonowana keda se sokemwamwayauyei. ");
INSERT INTO sbe_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Heyayai tauhaidi ena kadi tanuwaga ye lobaidi se silasilawa yona huyalagema ne unai, meta kabo gonowana se gwauyala. Ya hededemamohoi kalimiuwai: Kadi tanuwaga kabo kaleko ye likwadi doha heyayai tauhaina na ye yoganeidi se laoma se tuli na ye hekaidi. ");
INSERT INTO sbe_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Taba boniyai duwaduwalina o malatomtom gagilina unai ye lageꞌuyoma na heyayai tauhaidi kadi tanuwaga ne ye lobaidi meta se silasilawa kabo gonowana se gwauyala. ");
INSERT INTO sbe_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ginauli kesega ye masalahakalili: Ena taba numa tanuwagana kabina ye kata mahana saha unai kabo taukaiwahali ye laoma meta kabo ye silasilawa na taukaiwahali nige gonowana ye lusae yona numa unai. ");
INSERT INTO sbe_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Unai komiu hinage bena kwa nonononoha, matawuwuna Tau Natuna yona lage mahanana ne nige kabina kwa kata.” ");
INSERT INTO sbe_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kabo Petelo Yesu ye henamaiyei ye wane, “Guiyau, palabole hedehededena ta kai ka bom kama hedehedede o tamowai maudoidi?” ");
INSERT INTO sbe_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Guiyau ye hededebui ye wane, “Hage, numa taukitahetetena sibasibana kwa nuwatui. Kana tanuwaga iya ye sunumaei na ye tole bena yona heyayai tauhaidi maudoidi mahana dudulaidi udiyedi kabo kadi kai ye moseidi. ");
INSERT INTO sbe_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kana tanuwaga yona huyaꞌuyoma ne unai, ena yona heyayai tauhaina ta ye lobai yona paisowa wa ye ginaginauli, meta iya gonowana kabo ye gwauyala. ");
INSERT INTO sbe_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya hededemamohoi kalimiuyena: Kana tanuwaga yona gogo maudoidi kabo ye moseidi bena ye kitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Na ena heyayai tauhaina wa ye bom yona ye hedehedede na ye wane, ‘Kagu tanuwaga yona lageꞌuyoma ye pahilikalili,’ na ye hetubu heyayai tauhaidi hekadi wa sinesineo yo tatao ye kabihenayaidi na ye kai yo ye numa yo ye numayauyaule, ");
INSERT INTO sbe_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","meta kana tanuwaga kabo ye uyoma na mayadaina yo mahanana meta yona heyayai tauhaina wa nige kabidi ye kata. Na kabo ye hekamkamnakaliliyei na ye tolelae Yaubada nige tausunumaena yodi teha wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ena heyayai tauhaina hesau kana tanuwaga yona nuwanuwatu kabina ye kata, na nige ye nonohawatani yo nige ye ginauli, meta kana tanuwaga kabo iya ye hekamkamnakaliliyei. ");
INSERT INTO sbe_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na ena kana tanuwaga yona nuwanuwatu nige kabidi ye kata, na ginauligaibu ye ginaulidi, kabo kana tanuwaga nige gonowana iya ye hekamkamnakaliliyei. Kaiteyadi Yaubada ye kainauyaidi na yona hedehedede se nuwatulobainamwanamwaeidi meta ye henuwakalili bena se ginauliwataninamwanamwaeidi. Na kaiteyadi ye kainauyakaliliyeidi meta ye henuwa bena yona hedehedede se ginauliwataninamwanamwakaliliyeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ya dobima ta bena kaiwa ya yuhi tanoubu ta unai, na ya henuwakalili bena iya ede ye kalakalasi. ");
INSERT INTO sbe_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kamkamna lakilakikalilina kabo ya lulau unai na ya nuwanuwatukalili ye lau ee kana siga yogu kamkamna ne ye gehe. ");
INSERT INTO sbe_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yomi nuwatu bena nuwadaumwali ya baheiyama tanoubu ta unai? Nige! Ya hededelaowa kalimiuwai meta haitolebilibili ya baheiyama. ");
INSERT INTO sbe_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mayadai ta unai ye hetubu na ye lau meta numa kesega unai tamowai badodi haligigi kabo se haihaitolebilibiliꞌuyoidi yau debaguwai, taudi haiyona kabo labui se hewaiunudi yo labui kabo haiyona se hewaiunudi. ");
INSERT INTO sbe_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tama kabo natuna loheya ye hewaiunu, yo loheya kabo tamana ye hewaiunu. Sina kabo natuna waihiu ye hewaiunu, yo waihiu kabo sinana ye hewaiunu. Na sina kabo natuna loheya mwanena ye hewaiunu, yo waihiu kabo lawana ye hewaiunu.” ");
INSERT INTO sbe_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu yona hedehedede wa ye tubei na boda wa udiyedi ye wane, “Ena yalohi kwa kita teha yalasi ne unai ye saesaema, kwa wane, kabo nabu ye talu, na ye talu. ");
INSERT INTO sbe_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yo ena yawana ye lotalu kamnana kwa lapui meta kwa wane, kabo ye gigibwali, na mamohoi kabo ye tubu. ");
INSERT INTO sbe_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Komiu taukailupolupo! Tanoubu yo yada kadi kao gonowana kwa kitalobaidi. Na idohagi to saha se tubutubu teina mayadai ta udiyedi nige gonowana kwa kitalobaidi? ");
INSERT INTO sbe_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Idohagi to nige gonowana kwa bom kwa kitahekasa meta saha ye namwa yo ye dudulai teina huya ta unai? Hage, teina heyaheyasoni ta kwa nuwatui: ");
INSERT INTO sbe_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ena tamowai hesau kam hagahaga debanawai bena ye woyalaego kabalauhetala unai, meta keda ne unai kwa laulau na ku kaipatebayao bena yom teha ku hedudulai. Ena nige, kabo ye woyalaego tauhelauhetala matanawai. Na tauhelauhetala wa kabo ye tolelaego yona taupaisowa unai, na iya kabo ye tolego numatutugudu unai. ");
INSERT INTO sbe_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya hededemamohoi: Taba nige se hepesago ye lau ee kana siga kam hagahaga maudoidi ku hedudulaihegehedi.” ");
INSERT INTO sbe_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Huyana ne unai tamowai hekadiyo se laoma Yesu unai na Galili tamowaidi hekadi wasadi yona se hedehedede. Siya yodi kaitalasam se ginauli Numa Tabuna unai, na Pilato yona tauꞌiyala se koihemwaloidi ede kwasinadiyao se bwalilidobi yodi kaitalasam suisuidi kwasinadi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu ye hededebui ye wane, “Galili tamowaidi ta se kamkamna doha tenem na unai yomi nuwatu idohagi, bena siya se yababakalili na kabo Galili tamowaidi hekadiyo? ");
INSERT INTO sbe_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na ya hededelaowa kalimiuyena, teina ta nige! Na ena nige nuwamiu kwa buidi, komiu hinage kabo kwa boita. ");
INSERT INTO sbe_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na huyana Silowama unai numa kewana saesaena ye guli na tamowai badodi 18 ye koihemwaloidi meta nuwanuwatudi doha saha? Yomi nuwatu bena siya se yababakalili na kabo Yelusalema unai taumiya maudoidi? ");
INSERT INTO sbe_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya hededelaowa kalimiuyena, teina ta nige! Na ena nige nuwamiu kwa buidi, kabo komiu hinage kwa boita.” ");
INSERT INTO sbe_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na kabo Yesu teina palabole ta ye hedede kalidiyena: “Tamowai hesau yona wine koyana, na unai meta bosibosi ye kumai. Na ye lau kaniyona ye loya na nige kaniyona hesau ye lobai. ");
INSERT INTO sbe_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ede ye hededelau koya taupaisowaina wa unai ye wane, ‘Bolimai haiyona ya laolaoma inai kaiwa ta kaniyona ya tautaulalakaidi na nige kaniyona hesau ya lobai. Unai ku koiheguli. Nige gonowana bwatano ye hepahepaisowagaibui.’ ");
INSERT INTO sbe_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na koya taupaisowaina wa ye wane, ‘Tanuwaga, taba gonowana ku kitagabaei bolimai kesega, na yau kabo wuwuna ne ya kelihetakikili na bwatano kabahemasulina ya tole. ");
INSERT INTO sbe_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ena bolimai hesau ne unai na ye kaniyo meta ye namwa, ena nige, kabo gonowana ku koigabaei.’” ");
INSERT INTO sbe_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na Sabati mayadaina hesau unai Yesu ye lau sunago hesau unai ye lauhekata. ");
INSERT INTO sbe_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na temenai meta sinebada hesau yaluwa yabayababana ye hebunibuni bolimai 18, yo dagelana ye you na nige gonowana ye tolodudulaiꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Huyana Yesu sinebada wa ye kita ede ye yoganeiyama na ye wane, “Kam kasiyebwa ne unai ya yailihaigo.” ");
INSERT INTO sbe_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na nimana ye tolesaedi iya kewana unai na mahanana ne unai ye tolodudulai na Yaubada ye hedebasaei. ");
INSERT INTO sbe_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sunago wa badana ye koipili matawuwuna mayadai Sabati unai Yesu henamwanamwa paisowana ye ginauli, ede ye hedehededelau tamowai wa udiyedi ye wane, “Sabati kesega unai mayadai badona haligigi-kesega udiyedi gonowana ta paisowa. Tenem mayadaidi ne udiyedi bena kwa laoma henamwanamwa kwa lobai, na nige Sabati unai.” ");
INSERT INTO sbe_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Guiyau ye hededebui iya unai ye wane, “Komiu sunago babadadiyao meta taukailupolupo. Mamohoi, komiu nige Sabati mayadaina unai yomi bulumakau yo donki yodi kabamiya udiyedi kwa yailihaidi na kwa woyalaedi waila se numa? ");
INSERT INTO sbe_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na teina sinebada ta meta Abelahama kana isimulita hesau, na bolimai 18 Satani ye kabikabihekahini kana kasiyebwa unai. Na idohagi to ku hekaiyawasigau tabu Sabati unai iya kana kaukau unai ya yailihai?” ");
INSERT INTO sbe_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na yona hedehedede ta unai meta kana waiunu maudoidi ye hemwadinedi. Na bodalakilaki wa se gwauyalakalili laulau namwanamwadi maudoidi ye ginaulidi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na Yesu ye henamai ye wane, “Yaubada yona basileiya meta kana kao doha saha? Saha unai kabo ya hekaigonogonowai? ");
INSERT INTO sbe_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iya kana kao doha kaiwa tumana gagilina tamowai hesau ye hai na yona koyaena ye kumai. Like ne kabo ye kini ye hemala kaiwa lakilakina, kabo manuwa se laoma lagana ne udiyedi se kabinoi.” ");
INSERT INTO sbe_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu ye hedehededeꞌuyo ye wane, “Saha unai kabo Yaubada yona basileiya ya hekaigonogonowai? ");
INSERT INTO sbe_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iya ede doha waihiu hesau yisti ye hai na pwalawa disina lakilakina unai ye hebwali. Kabo yisti ne pwalawa maudoina wa ye hesese.” ");
INSERT INTO sbe_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ye laulau Yelusalema hesabana na magai lakilakidi yo gagilidi udiyedi ye laulauhekata. ");
INSERT INTO sbe_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na tamowai hesau iya ye henamaiyei ye wane, “Guiyau, tamowai hisahisadi mo kabo mauli nige kana siga se hai?” Ede Yesu ye hededebui ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kwa kaipatebayao bena kawakeda gagilina unai kwa lusae, matawuwuna tamowai se bado kabo se kaipate bena se lusae na iyamo nige gonowadi. ");
INSERT INTO sbe_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Huyana numa tanuwagana ye tolo na ye lau keda ye gudui, komiu kabo dagela ne unai kwa tolo na kwa koikoi yo kwa kaikaibwada kwa wane, ‘Tanuwaga, keda ku sokeyama na ka mwalaewa!’ Kabo ye hededelaowa kalimiuyena ye wane, ‘Nige kabimiu ya kata o haedi kwa laolaoma.’ ");
INSERT INTO sbe_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na kabo kwa hededelau kwa wane, ‘Kowa yo kai ta kaikai yo ta numagogoi, yo yoma magai kedadiyao udiyedi ku lauhekata.’ ");
INSERT INTO sbe_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na kabo ye hedehededeꞌuyo kalimiuyena ye wane, ‘Nige kabimiu ya kata o haedi kwa laolaoma. Kwa tausuwala, komiu maudoimiu laulau yabayababadi tauginaulidi!’ ");
INSERT INTO sbe_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Huyana Abelahama, Isako yo Yakobo yo peloweta maudoidi kwa kitadi Yaubada yona basileiya unai, na komiu dagela ne unai, meta kabo kwa dou yo kawamiu kwa kapuyahisidi. ");
INSERT INTO sbe_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamowai kabo teha bolime, teha yalasi, teha yawana, yo teha bwauli udiyedi se laoma na se tuli Yaubada yona basileiya kaikaigogona unai. ");
INSERT INTO sbe_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mamohoi! Hekadi mayadai ta unai se mulita kabo se baguna, na hekadi mayadai ta unai se baguna meta kabo se mulita.” ");
INSERT INTO sbe_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Huyana ne unai Paliseya tamowaidi hekadiyo se laoma Yesu unai na se hededelau unai se wane, “Bena magai ta ku laugabaei na ku lau teha hesau, matawuwuna Heloda ye henuwa bena ye unuhemwaloigo.” ");
INSERT INTO sbe_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ye hededebui ye wane, “Kwa lau kwa hededelau teina kedewa nukula ta unai: Madai yo malaitom kabo yaluwa yabayababadi ya hededehepesadi yo tamowai ya henamwanamwadi, na mayadai hehaiyonana ne unai kabo yogu paisowa ya hegehe. ");
INSERT INTO sbe_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iyamo madai, malaitom yo itenai meta yogu keda ta unai ya laulau Yelusalema hesabana, matawuwuna nige gonowana peloweta hesau Yelusalema dagelana ne unai se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusalema, Yelusalema! Kowa peloweta taukoihemwaloidi yo tamowai Yaubada ye hetamalidiwa kalimyena meta ku hekalawekudi. Huya maudoina meta ya henuwa bena natumwao ya kabigogoidima doha kamkam sinadi natunao ye kabigogoidi pepenao gunidiyena, na iyamo komiu nige kwa henuwa. ");
INSERT INTO sbe_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Unai sola kwa kita, Yaubada yomi magai kabo ye nuwagabaei na nige tamowaina. Na ya hededemamohoi kalimiuyena: Nige gonowana kwa kitaꞌuyoigau kana siga kwa wane, ‘Ka hedebasaego, kowa Guiyau hesanawai ku laoma!’” ");
INSERT INTO sbe_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabati hesau unai Yesu ye lau Paliseya tamowaina saesaena yona numa unai se kaikai, na temenai Paliseya tamowaidiyao yo laugagayo taulauhekataena hekadi iya se kaikewasipwanamwanamwaei. ");
INSERT INTO sbe_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na tamowai hesau kasikasiyebwana meta kaena yo nimana se loloni, na ye laoma Yesu talanuwana unai ye tolo. ");
INSERT INTO sbe_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu Paliseya tamowaidi yo laugagayo taulauhekataedi ye henamaiyeidi ye wane, “Gonowana kabo tamowai sabati unai ta henamwanamwa o nige?” ");
INSERT INTO sbe_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na se mwanomwanou. Unai Yesu tamowai wa ye kabilau unai, na ye henamwanamwa na ye hetamali ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kabo ye henamaiyeidi ye wane, “Ena kowa hesau natum o yom bulumakau mayadai Sabati unai ye bekudobi wailakeli duhana unai, kabo ku laumwamwayau ku tabeisini o nige?” ");
INSERT INTO sbe_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na nige gonowana yona henamai wa se bui. ");
INSERT INTO sbe_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Huyana ne unai Yesu ye kitalobai meta taumana hekadi kabatuli namwanamwadi se kaikaisunuwaidi, ede teina palabole ta ye hedede udiyedi na ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Huyana tamowai hesau ye kaibwadaigo ku lau hetahetawasola kaikaigogona unai, tabu kabatuli saesaena unai ku tuli, madai tamowai hesau saesaena ye kaibwadaiyako na kabo kowa. ");
INSERT INTO sbe_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ena mamohoi, kabo tauyogaisinigo wa maiyana kana taumana saesaena se laoma na ye hededelaowa kalimwai ye wane, ‘Teina tamowai ta yom kabatuli me ku mosei unai ye tuli.’ Kowa kabo ma mwadimwadinem na kabatuli dobidobina unai ku tuli. ");
INSERT INTO sbe_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Na huyana se yogaisinigo na kabatuli dobidobina ku hai, tauyogaisinigo wa kabo ye laowa ye hededelaowa kalimwai ye wane, ‘Kehagu, ku tulisae kabatuli namwanamwana ne unai.’ Na tenem unai tauyogaisinigo wa ye hekasisiyeigo taumana maudoidi matadiwai. ");
INSERT INTO sbe_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ya hededelaowa kalimiuwai: Kaiteya ye bom ye hesaeꞌuyoi, Yaubada kabo ye henuwadobidobiyei, yo kaiteya ye nuwadobidobi, Yaubada kabo ye hesaei.” ");
INSERT INTO sbe_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kabo Yesu ye hededelau tauyogaisinina wa unai ye wane, “Huyana mayadailaki kaina o boniyai kaina ku ginauli, meta tabu yom labini o kam kahao o kehamwao o helem taumiya gogogogodiyao ku kaikaibwadaidi. Ena doha teina ku yogaisinidi, nuwana siya hinage kabo se kaibwadaigo, na teina unai kabo se hemaisago. ");
INSERT INTO sbe_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na huyana kaikaigogo lakilakina ku ginauli, meta taudehadeha, taubunibuni, kaeyabayababa yo taumatagibugibu ku yogaisinidi. ");
INSERT INTO sbe_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Unai kabo gonowana ku gwauyala, matawuwuna siya nige gonowana yom kainauya buina se haiyawa, na tamowai laulaududulaidi yodi huyatoloꞌuyo mayadaina ne unai Yaubada kabo yom kainauya buina ye haiyawa.” ");
INSERT INTO sbe_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Taumana hesau Yesu maiyana se tutuli wa yona hedehedede ta ye lapui ede ye hededelau unai ye wane, “Siya kaiteyadi Yaubada yona basileiya kaikaigogona ne unai se kaikai meta gonowana kabo se gwauyala.” ");
INSERT INTO sbe_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kabo Yesu palabole ta ye hedede udiyedi ye wane, “Tamowai hesau kaikaigogo lakilakina ye kabinonohai, na tamowai gwaudi ye kaibwadaidi. ");
INSERT INTO sbe_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kaikaigogo mahanana ye lage, ede tamowai wa yona heyayai tauhaina ye hetamali ye lau kaiteyadi ye kaibwadaidi wa hesabadi na ye hededelau udiyedi ye wane, ‘Kwa laoma, ginauli maudoidi se kabinonohaidiko.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na hesau to hesau yona kabatolo unai ye hedehedede. Tamowai bagubagunana ye wane, ‘Yau tano kaboina ya hemaisa, na bena ya lau ya kita. Yauwedo! Unai taba nige ya laowa.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na hesau ye wane, ‘Kaboina bulumakau badodi saudoudoi ya hemaisadi, na bena ya lau ya kitadi na ya lautonogidi. Yauwedo! Unai taba nige ya laowa.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na hinage hesau ye wane, ‘Yau kaboina ta ya tawasola, tenem unai taba nige ya laowa.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Heyayai tauhaina wa ye uyoma na kana tanuwaga yona ye hedehedede, ede numa tanuwagana wa ye koipilikalili na ye hededelau yona heyayai tauhaina wa unai ye wane, ‘Ku laumwamwayau ku lau keda lakilakidi yo gagilidi magailaki ta udiyedi meta tamowai dehadehadi, taubunibuni, taumatagibugibu, yo kae daedaelodi ku woyaidima.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Heyayai tauhaina wa ye lau, na ye uyoma ede ye wane, ‘Tanuwaga, saha ku hedededi wa ya ginaulidiko, na iyamo yom numa sola nige ye mwayau.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kabo numa tanuwagana ye hededelau yona heyayai tauhaina wa unai ye wane, ‘Ku lau magailaki ta dagelana udiyedi keda lakilakidi yo gagilidi, metai tamowaidiyao ku hededebayao kalidiyena bena se laoma, to yogu numa ne ye mwayau. ");
INSERT INTO sbe_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya hededelaowa, siya kaiteyadi ya kaibwadabagunaidi wa taba nige yogu kaikaigogo unai se kaikai.’” ");
INSERT INTO sbe_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu maiyanao bodalakilaki se laulau, na ye tolobui na ye hededelau udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ena tamowai hesau ye henuwa bena ye hemuliwatanigau, na iyamo tamana, sinana, mwanena, natunao, kana kahao yo lounao, yo hinage yona mauli ye nuwatukaliliyeidi, kabo iya nige gonowana yogu hekahekata. ");
INSERT INTO sbe_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yo kaiteya nige yona sataulo ye bahei na ye hemuliwatanigau, meta iya nige gonowana yogu hekahekata. ");
INSERT INTO sbe_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Taba ku henuwa bena numa kewana saesaena ku ginauli, bagubaguna ku tulibigabiga na maisana lakina ku kaimasiyei meta gonowana kabo numa ne ku hegehe. ");
INSERT INTO sbe_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Taba numa ne ku hetubu ku ginauli na nige gonowana ku hegehe, siya kaiteyadi numa ne taukitana kabo se talatalawasiyeigo ");
INSERT INTO sbe_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","se wane, ‘Teina tamowai ta ye hetubu numa ne ye kabi, na nige gonowana ye hegehe.’ ");
INSERT INTO sbe_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Taba wasawasa hesau bena wasawasa hesau ye iyalai, bagubaguna ye tulibigabiga na ye kitasipwaiꞌuyoi meta yona iyala tamowaidi badona 10,000 ne kabo gonowana wasawasa hesauna yona tauꞌiyala badona 20,000 ne ye iyalaidi, o nige. ");
INSERT INTO sbe_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ena nige gonowana, na wasawasa hesauna wa sola kedalohalohawai, kabo yona tautauwasa ye hetamalidi bena nuwadaumwali se kaibwadai. ");
INSERT INTO sbe_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gonogonowana doha teina, komiu kaiteyadi nige yomi gogo maudoidi kwa nuwagabaedi meta nige gonowana kwa hemala yau yogu hekahekatao. ");
INSERT INTO sbe_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kalita meta ye namwa, na taba kamnana ye gehe, taba nige gonowana kamnana ye haiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Unai ede nige gonowana ta hepaisowa bwatano unai o tano kabahenamwana unai, na iya kabo se gabaei. Kaiteyadi gonowana se lapulapui bena se lapulapuinamwanamwa!” ");
INSERT INTO sbe_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisi tautanotano yo baꞌaya tamowaidi se laomagogoi bena Yesu saha ye hedededi wa se lapuidi. ");
INSERT INTO sbe_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Paliseya yo laugagayo taulauhekataena tamowaidi se gadigadigugu se wane, “Teina tamowai ta yababa tamowaidi ye hailobaidi yo maiyanao se kaikai.” ");
INSERT INTO sbe_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ede Yesu teina palabole ta ye hedede kalidiyena ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Taba luwamiu ne unai tamowai hesau yona mamoe badodi 100 na kesega ye taukwadalele, kabo 99 wa tenem teha ne unai ye laugabaedi na kesega ye taukwadalele wa ye wasenei kana siga ye lobai. ");
INSERT INTO sbe_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na huyana ye lobai meta ye gwauyalakalili na ye tolesae dabayalona unai ");
INSERT INTO sbe_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na ye lau magai. Kabo kehanao yo helena taumiya ye yogagogoidi na ye hededelau kalidiwai ye wane, ‘Kwa laoma ta gwauyalagogoi, matawuwuna yogu mamoe ye taukwadalele wa ya lobaiyako.’ ");
INSERT INTO sbe_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya hededelaowa kalimiuwai: Gonogonowana doha, ena baꞌaya tauginaulina kesega ye nuwabui, meta galewa ne unai gwauyalalakilaki, na kabo laulaududulai tamowaidi badodi 99, siya nige bena taba se nuwabui ne kalidiyena.” ");
INSERT INTO sbe_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu yona hedehedede ye tubei ye wane, “Yo taba sinebada hesau yona moni meta siluba saudoudoi, na kesega ye taukwadalele, kabo saha ye ginauli? Lampa ye gabu na yona numa ne ye kuya na ye wasetautaubigai kana siga ye lobai. ");
INSERT INTO sbe_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ena ye lobai kabo kana kahao yo helena taumiya ye yogagogoidima na ye hededelau udiyedi ye wane, ‘Kwa laoma ta gwauyalagogoi, matawuwuna yogu moni kesega ye taukwadalele wa ya lobaiyako.’ ");
INSERT INTO sbe_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ya hededelaowa kalimiuwai: Gonogonowana doha, ena baꞌaya tauginaulina kesega ye nuwabui, meta galewa ne unai Yaubada yona anelu se gwauyalakalili.” ");
INSERT INTO sbe_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na Yesu yona hedehedede wa ye tubei ye wane, “Tamowai hesau natunao loheloheyao labui. ");
INSERT INTO sbe_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Natuna taumulita wa ye hededelau tamana unai ye wane, ‘Tamagu, yom gogo maudoidi udiyedi yogu tupwa ku leyama.’ Ede yona gogo wa ye soiyei natunao wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mayadai hisa se lau na kabo taumulita wa yona gogo maudoidi ye lokunegabaeidi, na monidi wa ye haidi ede magai wa ye laugabaei ye lau magai hesau kedaloha unai. Menai kabo yona moni wa ye hepaisowagaibuidi laulau yabayababadi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yona moni maudoina ye hepaisowahegehe, na kabo hasahasali lakilakikalilina ye lage tenem magai ne ye haihegehe. Tenem huyana ne unai meta nige saha hesau kalinawai. ");
INSERT INTO sbe_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ede ye lau magai wa tamowaina hesau yona ye paisowa. Tamowai wa ye hetamali ye lau yona puwaka ye kitakitahetetedi yo ye hekahekaidi. ");
INSERT INTO sbe_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ye henuwa bena puwaka wa kadi kai ne ye kaidi, iyamo nige tamowai hesau ye talamyei taba saha hesau ye kai. ");
INSERT INTO sbe_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Huyana nuwatusibasiba ye uyoma kalinawai ede ye wane, ‘Tamagu yona taupaisowa meta kadi kai se kaitoledi, na yau teinai ya hasalikalili nige bayaona kabo ya boita. ");
INSERT INTO sbe_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Unai kabo ya dalahai ya uyo tamagu unai, na ya hededelau unai ya wane, “Tamagu, ya baꞌaya Yaubada matanaena yo kowa hinage matamyena. ");
INSERT INTO sbe_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yau nige ya namwa bena ku kataꞌuyoigau yau natum, na taba ku kabigau doha yau yom taupaisowa hesau.” ’ ");
INSERT INTO sbe_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Unai ye dalahai ye uyo tamana unai. Iya sola kedalohaloha unai ye laolaoma na tamana wa ye kitalau natuna ye kita meta nuwana ye kamkamnakalili. Na ye heloi ye lau natuna wa hesabana, ede ye haitalagadoi yo ye sumtai. ");
INSERT INTO sbe_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na natuna wa ye hededelau tamana unai ye wane, ‘Tamagu, ya baꞌaya Yaubada matanaena yo kowa hinage matamyena. Yau nige ya namwa bena ku kataꞌuyoigau natum.’ ");
INSERT INTO sbe_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na tamana wa ye yogalau yona heyayai tauhaidi udiyedi ye wane, ‘Mwamwayau! Kaleko namwanamwana kwa baheiyama kwa helikwa, na nimana unai lin kwa tole, yo hinage buti kwa helikwa. ");
INSERT INTO sbe_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na kwa lau bulumakau natuna sinisinibuna ne kwa koihemwaloi na ta gwauyala yo ta kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Matawuwuna natugu ta kana kao doha ye boitako, na mahana ta unai ye mauliꞌuyo, ye taukwadalele na ta lobaiꞌuyoi.’ Ede yodi gwauyala lakilakina wa se ginauli. ");
INSERT INTO sbe_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tenem mahanana ne unai natuna taubaguna wa koya unai ye paipaisowa. Huyana ye uyoma numa dedekanawai meta tamowai se wana yo se sobusobu dagugudi ye lapui. ");
INSERT INTO sbe_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ede heyayai tauhaina hesau ye yoganei ye laoma na ye henamaiyei meta teina saha ye laulau. ");
INSERT INTO sbe_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Heyayai tauhaina wa ye hededebui ye wane, ‘Kam kaha wa ye uyoma magai. Ede tamam bulumakau natuna sinisinibuna wa ye koihemwaloi, matawuwuna natuna ye uyoma ma namwanamwana.’ ");
INSERT INTO sbe_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Na taubaguna wa ye koipili na nige ye henuwa ye mwalaesae. Ede tamana ye pesa ye lau na ye kaibwadai bena maiyana se mwalaesae. ");
INSERT INTO sbe_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na taubaguna wa ye hededelau tamana unai ye wane, ‘Ku kita ne! Bolimai hisa yom ya paipaisowa doha yom heyayai tauhaina hesau yo sola nige huya hesau ya kawagabaeigo. Na iyamo nige gouti natuna ku leyama bena unai kagu kahao maiyaguwao ka kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na teina natum ta yom moni ye gabagaibuidi sinesineo yabayababadi udiyedi, na ye uyoma magai, ede bulumakau natuna sinisinibuna ku koihemwaloi iya hesabana.’ ");
INSERT INTO sbe_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na tamana ye hededelau unai ye wane, ‘Natugu, huya maudoina kowa maidagu, yo yogu gogo maudoidi meta kowa yom. ");
INSERT INTO sbe_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Na teina kam kaha ta kana kao doha ye boitako na mahana ta unai ye mauliꞌuyo, ye taukwadalele na ta lobaiꞌuyoi. Unai ye namwa mo taba ta kaikaigogoi yo ta gwauyala.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Tamowai gogogogona hesau iya yona gogo taukitakitahetetena se hegilu meta yona gogo ye kaiheyagaibuidi. ");
INSERT INTO sbe_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Unai tamowai gogogogona wa yona taukitakitahetete ye yoganei na ye hededelau unai ye wane, ‘Na wasam ya lapui ta meta mamohoi? Tenem unai ya henuwa bena yogu moni kitakitahetetena bukadi ku ledima na ya kitadi, matawuwuna nige gonowana kitakitahetete paisowana ta ku ginauliꞌuyoi.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kabo taukitakitahetete wa ye bom yona ye hedehedede ye wane, ‘Saha kabo ya ginauli? Kagu tanuwaga yogu paisowa ta unai kabo ye hepesagau, na yau nige yogu bayao gonowana kabo bwatano ya keli, yo kaibwada hinage kagu mwadimwadine. ");
INSERT INTO sbe_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kabina ya kata saha kabo ya ginauli na tenem unai tamowai gonowana kabo se yogaisinigau yodi numa udiyedi, huyana paisowa ta unai kagu tanuwaga ye hepesagau.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Unai ede kana tanuwaga yona gogo udiyedi taukaihagahaga kesega kesega ye yoganeidi. Na bagubagunana wa ye henamaiyei ye wane, ‘Kowa kam hagahaga lakina doha saha kagu tanuwaga unai?’ ");
INSERT INTO sbe_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tamowai wa ye wane, ‘Kagu hagahaga meta olibe bunamana lakina ede 3,000 lita.’ Na taukitakitahetete wa ye wane, ‘Yom hagahaga pepwana ku hai, mwamwayau ku tuli na 1,500 lita ku kulidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na tamowai helabuina ye henamaiyei ye wane, ‘Na kowa kam hagahaga hisa?’ Ede taukaihagahaga wa ye wane, ‘Kagu hagahaga meta witi baikidi badodi 100.’ Taukitakitahetete wa ye wane, ‘Yom hagahaga pepwana ku hai na baiki badodi 80 ku kulidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Unai tanuwaga wa yona taukitakitahetete nige dudulaina wa ye hededehenamwa yona kabikabi sonosonogadi wa debadiwai. Ya hededelaowa kalimiuwai: Tanoubu ta tamowaidiyao yodi kabikabi tamowai hekadi udiyedi meta se sonogakalili, na kabo Yaubada yona mala unai taumiyamiya yodi kabikabi. ");
INSERT INTO sbe_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Unai taba tanoubu ta gogodiyao kwa hepaisowanamwanamwaedi na udiyedi tamowai kwa saguidi, na siya kabo se hemala kehamiyao. Na huyana yomi wasawasa ne se gehe meta kabo se yogaisinigomiu na maiyamiyao kwa miya. ");
INSERT INTO sbe_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iya kaiteya ginauli gagilidi ye kitahetetenamwanamwaedi meta hinage ginauli lakilakidi kabo ye kitahetetenamwanamwaedi. Yo kaiteya ginauli gagilidi nige ye kitahetetenamwanamwaedi meta hinage ginauli lakilakidi nige gonowana ye kitahetetenamwanamwaedi. ");
INSERT INTO sbe_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ena komiu tanoubu ta ginaulidiyao udiyedi yomi kitakitahetete nige se dudulai, kaiteya kabo ye sunumaeigomiu na wasawasa mamohoidi ye lediwa bena kwa kitahetetedi? ");
INSERT INTO sbe_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yo ena tamowai hesau yona gogo nige kwa kitahetetenamwanamwaei, kaiteya kabo ye sunumaeigomiu na gogo ye mosegabaeidi kalimiuyena? ");
INSERT INTO sbe_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Heyayai tauhaina meta nige gonowana tanuwaga labui yodi ye paisowa. Hesau kabo ye subu na hesauna wa kabo ye henuwa, o bagubagunana wa yona nuwatu ye ginauliwatanidi ma nuwakohihaina, na hesauna wa ye kitadobidobiyei. Unai nige gonowana Yaubada yo moni yodi kwa paisowa.” ");
INSERT INTO sbe_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Paliseya tamowaidi, siya moni taugadosisiyeidi, hedehedede ta se lapui meta Yesu se kaoyababaei. ");
INSERT INTO sbe_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu ye hededelau udiyedi ye wane, “Tamowai matadiyena kwa hededehesaeꞌuyoigomiu meta komiu laulaududulai tamowaidi, na Yaubada nuwamiu kabidi ye katako. Ginauli saha tamowai se kitahesaekaliliyeidi meta Yaubada matanawai se yababakalili.” ");
INSERT INTO sbe_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu ye hededetubei ye wane, “Mose yona laugagayo yo peloweta yodi hedehedede wa se wasaduwaiyeidi ye lau ee Yowane ye laoma. Muliyena Yaubada yona basileiya wasana namwanamwana yau ya hededehemasalaha, na tamowai maudoidi ya kaibwadakaliliyeidi bena se lusae basileiya wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Galewa yo tanoubu ta kabo se taukwadalele, na Mose yona laugagayo maudoidi udiyedi taba nige kulikuli gagilina hesau ye taukwadalele. ");
INSERT INTO sbe_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Doha hinage inawase laugagayona ta nige gonowana ta bui: Ena loheya hesau mwanena ye inawasei na waihiu hesau ye tawasolai, meta ye ganawali. Na ena loheya hesau waihiu inaꞌinawasena ye tawasolai, meta iya hinage ye ganawali.” ");
INSERT INTO sbe_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tamowai gogogogona hesau iya meta kaleko maisa lakilakidi ye likwadi yo huya badobado meta nige saha hesau ye wasenei na ye gwaugwauyala mo. ");
INSERT INTO sbe_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na yona numa kawamatana unai meta taukaikaibwada tamowaina hesau se tole, hesana ede Lasalo, iya meta tauna bonu se laugilihai ");
INSERT INTO sbe_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","yo ye henuwakalili bena tamowai gogogogona wa yona hatahata unai kana kai mapuladi se beku wa ye kaidi. Na kedewa se laoma meta bonuna wa se namosidi. ");
INSERT INTO sbe_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Huyana taukaikaibwada wa ye boita meta anelu se bahelaei se hetuli Abelahama dedekanawai. Tamowai gogogogona wa hinage ye boita ede bwayabwaya unai se tole. ");
INSERT INTO sbe_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na iya Hade luwana unai meta ye kamkamnalakilaki, na matana ye tuusaedi meta Abelahama ye kita kedalohawai maiyana Lasalo se tutuli. ");
INSERT INTO sbe_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Unai ye yogasae kalinawai ye wane, ‘Tamagu Abelahama, ku katekamkamnaegau na Lasalo ku hetamali ye lau waila unai nimagigina ye hedakwa na memenagu ye hegwagwama, matawuwuna kaiwa ta unai ya kamkamnakalili.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Na Abelahama yona bui ye mosei ye wane, ‘Natugu, ku nuwatui, yom mauli mayadaidi udiyedi yom ginauli namwanamwadi ku haidiko, na Lasalo ginauli yababadi ye haidi, na mayadai ta unai kamnana se namwa na kowa ku kamkamnakalili. ");
INSERT INTO sbe_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yo hinage kowa yo kai duwaduwalida ne unai meta duha lohalohana, unai ede nige gonowana kabo hesau inai ye kawasilaowa metai yo nige gonowana hesau metai ye kawasilaoma kalimaiwai.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ede tamowai gogogogona wa ye wane, ‘Tamagu, ya kaibwadaigo, Lasalo ku hetamali ye lau yogu numa bodana udiyedi, ");
INSERT INTO sbe_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kagu kahao haligigi ne ye hededebayao udiyedi, na taba nige se laoma kabakamkamna magaina ta unai.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abelahama yona bui ye mosei ye wane, ‘Mose yo peloweta bukadi wa siya ede temenai, na taba yodi hedehedede ne udiyedi se lapulau.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na tamowai gogogogona wa ye wane, ‘Nige! Tamagu Abelahama, taba tamowai hesau boita unai ye toloꞌuyo na ye dobi udiyedi, kabo se nuwabui.’ ");
INSERT INTO sbe_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ye hededelau unai ye wane, ‘Ena nige se lapulapulau Mose yo peloweta udiyedi, meta tamowai hesau boita unai ye toloꞌuyo wa taba nige gonowana ye henuwabuidi.’” ");
INSERT INTO sbe_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Mamohoi, tamowai yodi kabakalabesibesi kabo se hekalodi, na ahani mo iya kalabesibesi tauhetubudi ne. ");
INSERT INTO sbe_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ye namwa mo taba iya gadona ne unai weku lakilakina se pai na se heyoli gabwa ne unai, na nige ye namwa taba teina tamowai dobidobidi ta hesau ye woyasapuli na yababa ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Unai kwa kitahetetenamwanamwaeigomiu. Ena kam kaha o loum baꞌaya ye ginauli, ku guguyai. Ena ye nuwabui, yona baꞌaya kalimwai ku nuwatugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ena mayadai kesega unai yababa ye ginauli kalimwai ma haligigi-labui, yo ma haligigi-labui ye uyoma ye wane, ‘Ya nuwabui’, meta taba yona baꞌaya kalimwai ne ku nuwatugabaeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolo wa se hededelau Guiyau unai se wane, “Yoma sunuma ku helakidi.” ");
INSERT INTO sbe_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Guiyau ye hededebui ye wane, “Taba yomi sunuma se gagili doha kaiwa tumana gagilikalilina meta gonowana kabo kwa hededelau kaiwa ne unai, ‘Ku suluhihaigo na gabwa ne unai ku kumaigo’, kabo ye kawakabiyeigomiu. ");
INSERT INTO sbe_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Taba komiu luwamiuyena hesau yona heyayai tauhaina koya ye paipaisowai o mamoe ye kitakitahetetedi na ye uyoma magai, meta kana tanuwaga taba nige ye hededelau unai ye wane, ‘Ku laoma ku tuli na ku kaikai!’ ");
INSERT INTO sbe_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na ye hededelau unai ye wane, ‘Ku dui ku kabinonoha na kabo kagu kai ku nonohai na ku suwayama ya kaikai yo ya numa. Muliyena kabo hinage ku kaikai yo ku numa.’ ");
INSERT INTO sbe_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Saha ye hedededi ne yona heyayai tauhaina wa ye ginauliwatanidi, iyamo kana tanuwaga taba nige ye lautokiyei. ");
INSERT INTO sbe_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gonogonowana doha komiu hinage, ena ginauli maudoidi Yaubada ye hedededi wa kwa ginaulidi, kabo kwa wane, ‘Kai meta heyayai tauhaidi dobidobidi mo, na kama paisowa mo ka ginaulidi.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na Yesu yona lau Yelusalema ne hesabana meta Samaliya yo Galili kadi sigasiga duwaduwalina ye tauwatani na ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na huyana ye lusae magai hesau unai, meta lepela tamowaidi badodi saudoudoi iya se hailobai. Na yodi kabatolo ne meta musamusana ye loha ");
INSERT INTO sbe_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na se yoga ma kalinalakilakidi Yesu unai se wane, “Yesu, Tanuwaga, ku katekamkamnaegai!” ");
INSERT INTO sbe_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ye kitalau na ye kitadi meta ye wane, “Kwa lau yo kwa hemasalahaꞌuyoigomiu taukaitalasam tamowaidi udiyedi.” Na se laulau taukaitalasam hesabadi na keda wa unai se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na kadi kaha hesau ye kita meta ye namwanamwako, ede ye uyo na kalinalakilaki unai Yaubada ye hedebasaei. ");
INSERT INTO sbe_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na ye guliyaboyabomdobi Yesu kaena udiyedi na ye lautokiyei. Na iya meta Samaliya tamowaina. ");
INSERT INTO sbe_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ye hedede ye wane, “Taudi saudoudoi se namwanamwa. Na haligigi-hasi wa meta haedi? ");
INSERT INTO sbe_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Idohagi to nige tamowai hesau ye laoma bena Yaubada ye lautokiyei, na teina laolaoma tamowaina ta ye bom mo?” ");
INSERT INTO sbe_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kabo ye hededelau kalinawai ye wane, “Ku tolo na ku lau, yom sunuma wa ye henamwanamwago.” ");
INSERT INTO sbe_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mayadai hesau unai Paliseya hekadi Yesu se henamaiyei se wane, “Kaiuyana kabo Yaubada yona basileiya ye laoma?” Yesu ye hededebui ye wane, “Yaubada yona basileiya yona laoma ne meta nige gonowana matamiuyena kwa kita, ");
INSERT INTO sbe_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","yo nige gonowana tamowai hesau ye wane, ‘Kwa kita, iya ede teina,’ o ‘Iya ede tenem!’ Matawuwuna Yaubada yona basileiya meta ye laomako luwamiuyena.” ");
INSERT INTO sbe_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kabo Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Huyana ye laolaoma kabo kwa henuwakalili bena Tau Natuna yona tanuwaga mayadaina hesau kwa kita, na iyamo nige gonowana kwa kita. ");
INSERT INTO sbe_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamowai kabo yomiu se hedehedede se wane, ‘Iya ede temenai!’ o ‘Iya ede teinai!’ Na tabu kwa lau kwa hemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Matawuwuna Tau Natuna yona huyaꞌuyoma mayadaina ne unai meta doha namanamali ye sili na dawayana meta yada ne maudoina kabo ye hedawaya. ");
INSERT INTO sbe_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na bagubaguna kabo ginauli hekadi udiyedi ye kamkamna yo teina isi ta iya kabo se subu. ");
INSERT INTO sbe_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tau Natuna yona laoma ne meta gonogonowana doha Nowa yona huya mayadaidi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tamowai se kaikai, se numanuma yo se tawatawasola ye lau ee kana siga Nowa ye mwalaesae ake wa unai. Kabo dibwaliꞌutuꞌutu ye laoma yo tamowai maudoidi wa ye unuhemwaloihegehedi. ");
INSERT INTO sbe_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na hinage gonogonowana doha Lota yona mayadai wa unai. Tamowai se kaikai yo se numanuma, se hemahemaisa yo se kunekune, se kumakuma yo se kabikabinuma. ");
INSERT INTO sbe_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na mayadaina Lota Sodoma ye laugabaei meta kaiwa yo salpa kalakalasidi galewa ne unai se taludobima na tamowai maudoidi wa se kalamwaloigehe. ");
INSERT INTO sbe_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gonogonowana doha Tau Natuna yona huyataumasalaha ne unai. ");
INSERT INTO sbe_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tenem mayadaina ne unai tamowai yona numa kewana unai taba nige ye pesadobi yona numa kalonawai bena yona gogo ye haidi. Gonogonowana doha, tamowai yona koya unai ye paipaisowa meta taba nige ye uyo yona numa, yona gogo hesabadi. ");
INSERT INTO sbe_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hage, Lota mwanena kwa nuwatui! ");
INSERT INTO sbe_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kaiteya yona mauli tanoubu ta unai ye nuwatukaliliyei meta nige gonowana mauli nige kana siga ye lobai. Na kaiteya yona mauli tanoubu ta unai ye nuwagabaei yau debaguyena, iya kabo mauli nige kana siga ye lobai. ");
INSERT INTO sbe_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya hededelaowa kalimiuwai: Tenem boniyaina ne unai tamowai labui kabakeno kesega unai se kenokeno. Yaubada kabo hesau ye hai na hesau ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Waiwaihiuwo labui meta witi se giligililabulabui. Yaubada kabo hesau ye hai na hesau ye laugabaei.” ");
INSERT INTO sbe_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yona hekahekatao wa se henamaiyei se wane, “Guiyau, teina ta meta kabo haedi se tubu?” Yodi bui ye moseidi ye wane, “Hage, manuwa kaikaitaudi kwa nuwatuidi. Siya gonowana suisui sinaledi se lobaidi na temenai kabo se lagegogoi. Gonogonowana doha, komiu hinage kabo kwa kitalobai meta teina ginaulidi ta haedi se tubu ne.” ");
INSERT INTO sbe_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kabo Yesu yona hekahekatao udiyedi palabole hesau ye hedede, unai ye hemasalaha kalidiwai meta huya maudoina bena se tapwatapwalolo, na tabu se nuwabasabasa. ");
INSERT INTO sbe_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ye wane, “Magai hesau unai meta tauhekasa hesau, iya Yaubada nige ye matausiyei yo tamowai hinage nige ye hekasisiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na magaina ne unai meta kwabuli hesau, huya badobado ye laolaoma kalinawai yo ye wane, ‘Kagu waiunu ne unai ku saguigau na yogu dudulai ku leyama.’ ");
INSERT INTO sbe_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Huya lohaloha yona kaibwada wa meta nige ye modei, na mulinawai kabo ye bom yona ye hedehedede ye wane, ‘Yaubada nige ya matausiyei yo tamowai nige ya hekasisiyeidi, ");
INSERT INTO sbe_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","na teina kwabuli ta huya maudoina ye hemohemodegau, unai yona dudulai kabo ya mosei. Ena nige, kabo yona kaibwadamuyomuyou ta unai kamnagu ye heyababa!’” ");
INSERT INTO sbe_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ede Guiyau ye wane, “Tauhekasa nige dudulaina wa yona hedehedede kwa nuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na ena Yaubada yona kaisunuwa tamowaidi mayadai yo boniyai yodi kaibwada se tole iya kalinawai meta kabo yodi dudulai ye moseidi o nige? Kabo yodi kaibwada ne ye hehuhehuyalaei? ");
INSERT INTO sbe_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya hededelaowa kalimiuwai: Iya kabo mwamwayau yodi dudulai ye moseidi. Na huyana Tau Natuna ye uyoma, kabo kaiyaulina ta unai tausunuma hekadi ye lobaidi o nige?” ");
INSERT INTO sbe_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tamowai hekadi yodi nuwatu bena yodi miyamiya se namwakalili, ede tamowai hekadiyo se kitadobidobiyeidi. Yesu kabo kadi heyaheyasoni hesau ye hedede ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamowai labui se lusae Numa Tabuna unai se tapwalolo, hesau Paliseya tamowaina yo hesau takisi tautanotano. ");
INSERT INTO sbe_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Paliseya tamowaina wa ye tolo na ye bom yona ye tapwalolo ye wane, ‘Yaubada, ya lautokiyeigo! Yau meta nige doha tamowai hekadi ne, siya ede taukaikaiwahali, yababa tauginaginaulidi, tauganaganawali tamowaidi – yo doha takisi tautanotano ne. ");
INSERT INTO sbe_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sabati kesega unai meta ma labui ya kaihudi, yo yogu gogo maudoidi udiyedi meta taiti ya leyawa.’ ");
INSERT INTO sbe_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na takisi tautanotano wa kedalohawai ye tolo. Nige gonowana ye kaikewasae galewa, na nuwapouna unai ye koi na ye wane, ‘Yaubada, ku katekamkamnaeigau, yau tamowai baꞌabaꞌayana.’ ");
INSERT INTO sbe_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ya hededelaowa kalimiuwai: Teina takisi tautanotano ta yona baꞌaya meta Yaubada ye nuwatugabaeidi na ye uyo yona numa. Na Paliseya tamowaina yona baꞌaya nige ye nuwatugabaeidi. Matawuwuna siya kaiteyadi se hededetausaeꞌuyoidi meta kabo Yaubada ye toledobidobiyeidi, yo siya kaiteyadi se nuwatudobidobiyeiꞌuyoidi meta kabo Yaubada ye hesaedi.” ");
INSERT INTO sbe_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Huya hesau tamowai hekadi wawayao gagilidi se baheidima Yesu unai bena nimana ye tolesaedi kewadi ne udiyedi na ye hededehenamwadi. Na huyana yona hekahekatao tamowai wa se kitadi meta se dilaidi. ");
INSERT INTO sbe_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na Yesu wawayao wa ye yoganeidi se laoma iya kalinawai na ye wane, “Wawayao gagilidi bena se laoma kaliguwai, na tabu kwa hekahekaiyawasidi, matawuwuna tamowai yodi sunuma doha teina wawayao ta meta galewa basileiyana siya yodi. ");
INSERT INTO sbe_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya hededemamohoi kalimiuwai: Tamowai nige gonowana se lusola Yaubada yona basileiya unai kana siga yodi sunuma doha wawaya gagilidi ta.” ");
INSERT INTO sbe_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dius yodi tauwoyawoya hesau Yesu ye henamaiyei ye wane, “Taulauhekata namwanamwana, saha kabo ya ginauli unai kabo mauli nige kana siga ya lobai?” ");
INSERT INTO sbe_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ye hededebui ye wane, “Idohagi to ku kataigau meta yau ya namwa? Nige tamowai hesau ye namwa, na Yaubada ye bom mo. ");
INSERT INTO sbe_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laugagayo kabidi ku kata: ‘Tabu ku ganawali, tabu ku kaiunu, tabu ku kaiwahali, tabu ku hededelupolupo, yo tamam yo sinam ku hekasisiyeidi.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tamowai wa ye wane, “Huyana yogu huyatubusaema unai meta laugagayo ta ya lauwatanidi.” ");
INSERT INTO sbe_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Huyana Yesu hedehedede wa ye lapui ede ye hededelau unai ye wane, “Ginauli kesega mo sola nige ku ginauli. Yom gogo maudoidi ku lokunegabaeidi na monidi ne ku moseidi tamowai dehadehadiyao udiyedi, na kabo galewa ne unai ku wasawasa. Na kabo ku laoma ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Huyana tauwoyawoya wa Yesu yona hedehedede ye lapui meta nuwana ye yababakalili, matawuwuna iya tamowai gogogogona. ");
INSERT INTO sbe_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ye kaikewalau unai na ye wane, “Tamowai gogogogodi bena se lusola Yaubada yona basileiya unai meta ye pilipilikalili. ");
INSERT INTO sbe_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Doha kamela nige gonowana diu duhana unai ye lusola, gonogonowana doha tamowai gogogogona meta iya hinage nige gonowana ye lusola Yaubada yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hedehedede ta taulapuidi se wane, “Unai kaiteyadi kabo gonowana mauli nige kana siga se hai?” ");
INSERT INTO sbe_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu yodi bui ye moseidi ye wane, “Saha tamowai nige gonowana se ginaulidi meta Yaubada gonowana ye ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Petelo ye hededelau Yesu unai ye wane, “Kai kabo idohagi? Yoma gogo maudoidi ka laugabaeidiko na ka hemuliwatanigo.” ");
INSERT INTO sbe_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuwai: Ena tamowai hesau yona numa o mwanena o kana kaha o sinana yo tamana o natunao ye laugabaedi Yaubada yona basileiya debanawai ");
INSERT INTO sbe_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","meta iya teina huya ta unai yona gogo se badokalili kabo ye haidi yo huya matada ne unai kabo mauli nige kana siga ye hai.” ");
INSERT INTO sbe_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu yona hekahekatao saudoudoi-labui wa ye woyahesuwaladi na ye hededelau udiyedi ye wane, “Kwa lapulapuinamwanamwa! Ta saesae Yelusalema, na ginauli maudoidi peloweta se kulidiko Tau Natuna hesabana wa kabo se tubu. ");
INSERT INTO sbe_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iya kabo se moselaei dagela tamowaidiyao udiyedi. Siya kabo se kabihenayaei, se talatalawasiyei, yo se kaikaisoi, ");
INSERT INTO sbe_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yo kabo wipi unai se pidili, yo se unuhemwaloi. Na mayadai hehaiyonana unai kabo ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na yona hekahekatao wa teina hedehedede ta unai nige saha hesau se nuwatulobai. Hedehedede wa kaniyona Yaubada ye tolewadam kalidiwai ede saha Yesu ye hedehededeidi ta nige kabidi se kata. ");
INSERT INTO sbe_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Huyana Yesu Yeliko magaina lakilakina ye hanahanawui meta menai tamowai hesau matagibugibuna keda dedekanawai ye tutuli na ye kaikaibwada. ");
INSERT INTO sbe_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Boda wa se laulau na kalikalinadi ye lapuidi ede ye henamaiyeidi ye wane, “Saha ye laulau?” ");
INSERT INTO sbe_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yona se hedehedede se wane, “Yesu Nasaleta tamowaina wa ye laoma ye lau.” ");
INSERT INTO sbe_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kabo ye yogalakilaki ye wane, “Yesu, Dawida Natuna, ku katekamkamnaegau!” ");
INSERT INTO sbe_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na kaiteyadi keda unai se bagubaguna wa se dilai bena ye mwanou. Iyamo ye yogalakilakikalili ye wane, “Dawida Natuna, ku katekamkamnaegau!” ");
INSERT INTO sbe_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ye talutolo na ye hedede bena tamowai wa se woyalaeiyama kalinawai. Huyana ye lage iya dedekanawai ede ye henamaiyei ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Saha ku henuwa bena yom ya ginauli?” Taumatagibugibu wa ye wane, “Guiyau, ya henuwa bena matagu ta ku helaladi.” ");
INSERT INTO sbe_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ye hededelau unai ye wane, “Matam kabo se lala. Yom sunuma ne ye henamwanamwago.” ");
INSERT INTO sbe_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mahanana ne unai matana wa se lala ede Yesu ye hemuliwatani, yo Yaubada ye hedebasaei. Huyana tamowai maudoidi saha ye tubu wa se kita meta hinage Yaubada se hedebasaei. ");
INSERT INTO sbe_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ye lage Yeliko na magai duwaduwalina unai ye laulau. ");
INSERT INTO sbe_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tamowai hesau menai hesana ede Sakiusa. Iya meta takisi tautanotano kadi tanuwaga saesaena, yo tamowai gogogogona. ");
INSERT INTO sbe_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ye henuwa bena Yesu ye kita, Yesu meta tamowai sahasahana. Iyamo saliyana meta ye kubwa, unai nige gonowana boda luwadiyena Yesu ye kita. ");
INSERT INTO sbe_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ede ye heloibaguna ye lau kaiwa hesana sikamona ye mwalaei bena kabo Yesu ye kita, matawuwuna Yesu kabo tenem teha ne unai ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na huyana Yesu ye lage yona kabamwalae wa unai ede ye tamaisi na ye hededesae kalinawai ye wane, “Sakiusa, ku pesamwamwayauma. Matawuwuna teina mayadai ta kabo ya laowa yom numa ne unai ya hemala kam taumana.” ");
INSERT INTO sbe_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Unai ye pesamwamwayau na Yesu ye hailobai ma gwauyalana. ");
INSERT INTO sbe_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamowai maudoidi saha ye tubu wa se kita na se hetubu se gadigadiguguyei se wane, “Iya baꞌaya tamowaina, na Yesu ye lau kalinawai ede ye hemala kana taumana.” ");
INSERT INTO sbe_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na Sakiusa ye tolo ede ye hededelau Guiyau unai ye wane, “Guiyau! Yogu gogo tehana kabo ya moseidi tamowai dehadehadi udiyedi, yo ena ginauli hesau tamowai hesau unai ya kabihagahagai meta kabo ma hasi maisana ne ya koihepwatalaei.” ");
INSERT INTO sbe_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kabo Yesu ye hededelau unai ye wane, “Teina mayadai ta, gilihai ye laoma teina numa ta unai, matawuwuna teina tamowai ta meta hinage Abelahama natuna. ");
INSERT INTO sbe_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Matawuwuna Tau Natuna ye laoma bena tamowai gegegegedi ye waseneidi yo ye gilihaidi.” ");
INSERT INTO sbe_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tamowai wa sola se lapulapui Yesu yona hedehedede wa udiyedi na heyaheyasoni hesau ye hedede kalidiyena, matawuwuna ede Yelusalema ye hanahanawui na tamowai yodi nuwatu ede huyana ye lage Yelusalema, kabo Yaubada yona basileiya ye masalaha. ");
INSERT INTO sbe_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ede ye wane, “Tamowai saesaena hesau ye lau magai hesau kedalohalohawai bena wasawasa gigibwalina ye hai na kabo ye uyoma yona tamowai yodi wasawasa. ");
INSERT INTO sbe_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Unai yona heyayai tauhaidi luwadiyena saudoudoi ye yogagogoidima na kesega kesega denali 100 ye moseidi. Na ye hededelau kalidiwai ye wane, ‘Teina moni ta kwa hepaisowadi na kwa helakidi ye lau ee kana siga ya uyoma.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na yona magai tamowaidi meta iya se subu na tautauwasa se hetamalidi se hemuliwatani se lau magai ne unai na se wane, ‘Tamowai ta nige ka henuwa bena yoma wasawasa!’ ");
INSERT INTO sbe_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Na iyamo tamowai wa wasawasa gigibwalina ye hai na kabo ye uyo yona magai. Yona heyayai tauhaidi saudoudoi wa ye yoganeidi bena moni yodi hepahepaisowana na hisa unai se lobai wa ye henamaiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bagubagunana ye laoma ye wane, ‘Guiyau, yom denali 100 unai meta denali 1,000 ya lobaidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kana tanuwaga ye hededelau kalinawai ye wane, ‘Ye namwakalili! Kowa meta yogu heyayai tauhaina namwanamwana! Ginauli gagilina unai yom kitakitahetete ye namwa, unai kabo ya tolego magai lakilakidi saudoudoi ku tanuwagaidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Helabuina ye laoma ye wane, ‘Guiyau, yom denali 100 wa unai meta denali 500 ya lobaidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kana tanuwaga wa ye wane, ‘Kowa kabo magai lakilakidi haligigi ku tanuwagaidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kabo heyayai tauhaina hesauna wa ye laoma ye wane, ‘Guiyau, yom denali 100 wa siya ede teina. Kaleko teuna unai ya suma na ya tolewadam se miyamiya, ");
INSERT INTO sbe_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kaniyona ede ya matausiyeigo, matawuwuna kowa tamowai kabiyabayababana. Ginauli saha nige ku toledi meta ku haidi, yo like saha nige ku kumaidi meta ku tanogogoidi.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kana tanuwaga ye wane, ‘Kowa heyayai tauhaina yababana! Yom hedehedede ta unai kabo ya hekasago! Kabina ku kata meta yau tamowai kabiyabayababana, ginauli saha nige ya toledi meta ya haidi, yo like saha nige ya kumaidi ne meta ya tanogogoidi. ");
INSERT INTO sbe_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ye saha to yogu moni nige ku tole banka unai? Na huyana ya uyoma kabo yogu moni ya haiꞌuyoi yo hagahagana ne hinage.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kabo ye hededelau yona heyayai tauhaidi siya menai tautotolo wa udiyedi ye wane, ‘Moni iya kalinawai ne kwa haigabaei na kwa mosei iya denali 1,000 tauhaina ne kalinawai.’ ");
INSERT INTO sbe_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na se wane, ‘Guiyau, iya denali 1,000 ye haidiko!’ ");
INSERT INTO sbe_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na kadi tanuwaga yodi bui ye moseidi ye wane, ‘Ya hededelaowa kalimiuwai: Kaiteyadi saha se haiyako na se hepaisowanamwanamwaei meta kabo yodi gogo ya helakidi. Na kaiteyadi saha se haiyako na nige se hepaisowanamwanamwaei meta saha yodi wa kabo ya haigabaei. ");
INSERT INTO sbe_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na kagu waiꞌunuwao, siya nige se henuwagau yodi wasawasa ne, meta kwa woyaidima inai na mataguyena kwa koihemwaloidi.’” ");
INSERT INTO sbe_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu yona hedehedede ta mulidiwai kabo ye bagunaidi se sae Yelusalema. ");
INSERT INTO sbe_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Magai Betepage yo Betaniya se hanahanawuidi na kuduli hesau hesana Olibe Kudulina unai se lage. Temenai kabo yona hekahekatao labui ye hetamalidi ");
INSERT INTO sbe_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ye wane, “Kwa lau magai matamiu ne unai, na huyana kwa lagelau meta kabo donki natuna se paipaihekahini kwa kita, sola nige tamowai hesau ye tulisae kewana ne unai. Kwa yailihai yo kwa woyaiyama inai. ");
INSERT INTO sbe_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ena tamowai hesau ye henamaiyeigomiu ye wane, ‘Ye saha to kwa yaiyaili?’, kwa wane, ‘Guiyau ye henuwa.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Se lau na saha ye hedededi wa se lobaidi. ");
INSERT INTO sbe_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Donki natuna mainana se yaiyaili, na tanuwaganao se henamaiyeidi se wane, “Ye saha to donki natuna me kwa yaiyaili?” ");
INSERT INTO sbe_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yodi bui se moseidi se wane, “Guiyau ye henuwa.” ");
INSERT INTO sbe_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kabo se woyai se laei Yesu unai, na kadi kwama se tolesaedi donki natuna wa kewanaena na Yesu ye tulisae unai. ");
INSERT INTO sbe_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iya ye laulau na tamowai kadi kwama se yesedi keda wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Huyana Olibe Kudulina kedana kabalidilididobina ye hanahanawui kabo yona hekahekatao bodalakilaki wa se gwauyala yo kalinalakilaki unai Yaubada se hedebasaei laulau gigigigibwalidi maudoidi se kitadi wa debadiwai, se wane, ");
INSERT INTO sbe_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Yoma wasawasa, ka hedebasaego, Guiyau hesanawai ku laoma!” “Yaubada nuwadaumwali ye leyama kalidawai yo hedebasae maudoina ye lau Yaubada Saesaekalilina unai!” ");
INSERT INTO sbe_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na Paliseya hekadi boda wa luwadiwai se hededelau Yesu unai se wane, “Taulauhekata, yom hekahekatao ne ku dilaidi!” ");
INSERT INTO sbe_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na ye hededebui ye wane, “Yomiu ya hedehedede: Ena se mwanomwanou, kabo weku ne se yogayogahi!” ");
INSERT INTO sbe_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu Yelusalema ye hanahanawui na magai lakilakina wa ye kita ede sabina ye dou, ");
INSERT INTO sbe_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na ye wane, “Taba bena kowa hinage teina mayadai ta unai ku nuwatulobai meta idohagi kabo nuwadaumwali ku hai. Na Yaubada nuwadaumwali matamiu ne udiyedi ye tolewadam. ");
INSERT INTO sbe_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Huyadi se laolaoma kabo kam waiunu gana lakilakina yo bayabayaona se ginauli na ye hetakikiligo teha maudoina udiyedi, na yom kabapesa maudoidi se guduidi. ");
INSERT INTO sbe_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Siya kabo se hetatagwaligwalihegehego yo hinage yom taumiyamiya ma natudiyao se unuhemwaloidi. Na taba nige weku hesau kabo ye miyamiya yona hali weku kewanaena, matawuwuna Yaubada ye laomako bena ye gilihaigomiu, iyamo gilihai mahanana ta nige kwa kitalobai.” ");
INSERT INTO sbe_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kabo Yesu ye mwalaesae Numa Tabuna bakubakuna unai na taulokulokune ye henakuhepesadi. ");
INSERT INTO sbe_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ye hededelau kalidiwai ye wane, “Kulikuli tabuna unai se kuliyako se wane, ‘Yogu numa meta kabatapwalolo numana’ , na komiu kwa hai ye hemala ‘taukaikaiwahali yodi duha’ .” ");
INSERT INTO sbe_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na kabo mayadai kesega kesega Numa Tabuna wa unai ye laulauhekata. Na taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi yo Dius yodi babadao se henuwa bena se unui. ");
INSERT INTO sbe_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Na iyamo nige keda hesau se lobai kabo unai se unui, matawuwuna tamowai maudoidi meta yona hedehedede wa se henuwadi. ");
INSERT INTO sbe_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mayadai hesau Yesu Numa Tabuna bakubakuna unai ye laulauhekata yo wasa namwanamwana ye laulauguguyaei tamowai udiyedi. Na taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi tamowaidi yo magai babadadiyao maiyadiyao se laoma ");
INSERT INTO sbe_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na se hedehededelau Yesu unai se wane, “Yomai ku hedehedede: Gigibwali sahasahana unai teina laulau ta ku ginaulidi, yo kaiteya yom dudulai ye haiyawa?” ");
INSERT INTO sbe_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ye hededebui udiyedi ye wane, “Kabo yau hinage ginauli hesau ya henamaiyeigomiu na yogu kwa hedehedede: ");
INSERT INTO sbe_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yowane yona dudulai ye hebahebabatiso ne meta Yaubada unai ye laoma o tamowai udiyedi ye laoma?” ");
INSERT INTO sbe_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na se hetubu se bom se henahenamaiꞌuyoidi se wane, “Saha kabo ta hedede? Taba ta wane, Yaubada unai ye laoma, kabo ye wane, ‘Na idohagi to nige kwa kawamamohoiyei?’ ");
INSERT INTO sbe_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na taba ta wane, tamowai udiyedi, meta boda maudoidi ta kabo se hekalawekuda, matawuwuna ede yodi nuwatulobai meta Yowane iya peloweta.” ");
INSERT INTO sbe_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ede se wane, “Nige kabina ka kata haedi ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Unai Yesu ye hededelau udiyedi ye wane, “Kabo yau hinage taba nige ya hededehemasalaha haedi yogu gigibwali yo yogu dudulai ta ya haidi na laulau ta ya ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kabo Yesu teina palabole ta ye hedede tamowai udiyedi ye wane, “Tamowai hesau wine koyana ye kumai na kabo ye moselaei taukitakitahetete udiyedi na ye lau ye kadau huyalohaloha. ");
INSERT INTO sbe_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wine huyagigidi nawalaina ye lage ede yona heyayai tauhaina hesau ye hetamali ye lau wine koyana taukitakitahetetedi wa udiyedi kabo wine gigigiginonohadi wa udiyedi koya tanuwagana yona lausoisoi bena ye haidi. Na taukitakitahetete wa heyayai tauhaina ne se biteli na se hetamali ma nimagaibuna ye uyo. ");
INSERT INTO sbe_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ede yona heyayai tauhaina hesau ye hetamali, na hinage taukitakitahetete wa se biteli yo se kabihenahenayai na se hetamali ma nimagaibuna ye uyo. ");
INSERT INTO sbe_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ede yona heyayai tauhaina hehaiyonana ye hetamaliꞌuyoi. Na taukitakitahetete wa se hekaiboita na se tuuhepesa. ");
INSERT INTO sbe_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ede koya tanuwagana wa ye wane, ‘Kabo saha ya ginauli? Natu kesekesegagu ya gadosisikaliliyei ta ya hetamali. Nuwana kabo se hekasisiyei.’ ");
INSERT INTO sbe_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na huyana taukitakitahetete wa natuna se kita meta se bom yodi se hedehedede se wane, ‘Teina ta meta koya tanuwagana lauhedamaina. Kwa laoma ta koihemwaloi, na yona gogo ne kabo yoda!’ ");
INSERT INTO sbe_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ede koya wa unai se tuuhepesa na se koihemwaloi.” Na Yesu ye henamai ye wane, “Koya tanuwagana kabo saha ye ginauli taukitakitahetete wa udiyedi? ");
INSERT INTO sbe_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kabo ye laoma ye koihemwaloidi na koya ne ye moselaei tamowai hekadi udiyedi.” Na taulapulapui wa se wane, “Teina ta taba tabu ye tubu!” ");
INSERT INTO sbe_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ye kaikewalau udiyedi na ye wane, “Unai hage, kulikuli tabudiyao udiyedi teina hedehedede ta kabina kwa kata o nige? ‘Taukabinuma weku se subuꞌusei wa meta ye hemala kabakabinuma wekuna namwanamwana yo saesaekalilina.’ ");
INSERT INTO sbe_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ena hesau ye bekudobi weku ne unai kabo ye talugodugodu, na ena weku ne ye bekudobi tamowai hesau kewanaena meta kabo ye kaihesolusolu.” ");
INSERT INTO sbe_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Laugagayo taulauhekataedi yo taukaitalasam tauwoyaidi wa se nuwatulobai meta palabole ta siya kadi hedehedede. Na tenem mahanana ne unai se henuwakalili bena Yesu se hai se kabihekahini, na boda wa se matausiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na kabo Yesu se kaikewasipwanamwanamwaei na taukaikewasipwa se hetamalidi se lau na kadi kao se ginaulidi doha siya tamowai dudulaidi. Yodi nuwatu bena Yesu se hekalabesibesi yona hedehedede udiyedi, na unai kabo se moselaei Loma yodi gabana yona tanuwaga gigibwalina unai. ");
INSERT INTO sbe_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na se henamaiyei se wane, “Taulauhekata, kabina ka kata meta saha ku hedehededeidi yo yom lauhekata meta se dudulai. Yo hinage kabina ka kata meta tamowai nige ku gadosisihinelidi, na mamohoiyena laulau saha Yaubada ye henuwa bena ta miyawatanidi meta ku lauhekataedi. ");
INSERT INTO sbe_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Unai ka henamaiyeigo na yomai ku hedehedede: Ye dudulai kabo takisi ka mosei Sisa unai o nige?” ");
INSERT INTO sbe_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yodi kailupolupo Yesu ye kita na ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Hage, denali hesau kwa leyama ya kita. Teina kaiteya kana kao yo hesana?” Se wane, “Sisa.” ");
INSERT INTO sbe_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ye hededelau udiyedi ye wane, “Saha Sisa yona meta kwa mosei Sisa unai, na saha Yaubada yona meta kwa mosei Yaubada unai.” ");
INSERT INTO sbe_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na tenem unai nige gonowana iya se hekalabesibesi yona hedehedede udiyedi boda matadiwai. Na yona hededebui unai se siliyatakalili, ede se mwanouhai. ");
INSERT INTO sbe_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusiya tamowaidi yodi nuwatu tauboiboita taba nige se toloꞌuyoma. Na se laoma Yesu se henamaiyei se wane, ");
INSERT INTO sbe_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Taulauhekata, Mose yona kulikuli unai ye wane, ‘Ena tamowai hesau ye boita, na mwanena ye miyamiya, na nige natunao, meta bena kana kaha hesau kwabulina ne ye tawasolai na natunao ye labasidi, kabo natudi loheya taubaguna ye hemala kana kaha wa natuna.’ ");
INSERT INTO sbe_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Huya hesau meta tamowai hesau ma kana kahao, badodi haligigi-labui. Taubaguna ye tawasola, nige natunao, na ye boita. ");
INSERT INTO sbe_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na kana kaha helabuina kwabuli wa ye tawasolai, na hinage ye boita. ");
INSERT INTO sbe_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na kabo hinage kana kaha hehaiyonana iya ye tawasolai. Laulau wa kesekesegana ye tubu badodi haligigi-labui wa udiyedi. Nige natudiyao na se boita. ");
INSERT INTO sbe_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gehegehena kwabuli wa hinage ye boita. ");
INSERT INTO sbe_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Badodi haligigi-labui wa meta waihiu wa se tawasolai, na toloꞌuyoma unai waihiu wa kabo kaiteya mwanena?” ");
INSERT INTO sbe_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ye hededelau udiyedi ye wane, “Tanoubu ta tamowaidiyao se tawasola yo natudiyao se hetawasoladi. ");
INSERT INTO sbe_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Na kaiteyadi Yaubada ye kitahenamwadi meta boita unai se toloꞌuyo na huya matada ne unai kabo se miyamiya, kabo taba nige se tawasola o se hetawasoladi. ");
INSERT INTO sbe_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Siya kabo doha anelu yo nige gonowana se boita. Siya Yaubada natunao, matawuwuna ede boita unai se toloꞌuyoko. ");
INSERT INTO sbe_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose hinage ye hededehemasalaha meta tauboiboita kabo se toloꞌuyo. Matawuwuna huyana Guiyau ye taumasalaha kalinawai kaiwa kalakalasina wa unai, meta ye katai, ‘Abelahama yona Yaubada, yo Isako yona Yaubada, yo Yakobo yona Yaubada.’ ");
INSERT INTO sbe_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yaubada ta iya nige tauboiboita yodi Yaubada, na iya taumaumauli mo yodi Yaubada. Matawuwuna iya kalinawai tamowai maudoidi se maumauli.” ");
INSERT INTO sbe_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na laugagayo taulauhekataedi hekadiyo se talam se wane, “Taulauhekata, yom hedehedede me se namwakalili!” ");
INSERT INTO sbe_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na nige hesau ye nuwabayao bena ye henamaiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na kabo Yesu ye hededelau udiyedi ye wane, “Idohagi to se hedede meta Keliso iya Dawida natuna? ");
INSERT INTO sbe_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Na Dawida meta Same bukana unai ye kulihemasalahayako ye wane, ‘Guiyau ye hededelau yogu Guiyau unai ye wane, “Nimatutuguyena ku tuli ye lau ee kam waiunu ya toledi kaem guninaena na se hemala kaem kabatoledi.” ’ ");
INSERT INTO sbe_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawida meta Keliso ye kawaguiyauyei. Idohagi na iya bena Dawida natuna?” ");
INSERT INTO sbe_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tamowai maudoidi wa sola ma lapulapuidi Yesu unai, na ye hededelau yona hekahekatao wa udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bena kwa kitanamwanamwa laugagayo taulauhekataedi udiyedi. Yodi taitaihile udiyedi se henuwa bena kwama lohalohadi se luwuidi yo kabalokulokune udiyedi bena tamowai siya se laulautokiyeidi ma hekasisidi, yo hinage sunago yo kabakaikaigogo udiyedi kabatuli saesaedi se henuwadi. ");
INSERT INTO sbe_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na kwabukwabuli yodi numa se lupohaidi, yo yodi tapwalolo se helohadi bena kabo tamowai se nokoeidi. Tamowaidiyao ne Yaubada kabo ye hekamkamnakaliliyeidi.” ");
INSERT INTO sbe_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu sola Numa Tabuna unai, na ye kaikewasae ede tamowai gogogogodi ye kitadi yodi moni se toletoledi moni kabaꞌusaꞌusa wa kalodi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yo hinage kwabuli hesau dehadehana ye kita meta pene gagilidi labui ye usaidi. ");
INSERT INTO sbe_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na ye wane, “Ya hededemamohoi kalimiuyena: Teina kwabuli dehadehana ta kainauya lakilakikalilina ye tole na kabo maudoidi ne. ");
INSERT INTO sbe_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Matawuwuna ede siya yodi moni lakilakidi udiyedi na kabo hisa mo se haidi na se toledi, na iya yona deha unai yona moni maudoina kalinawai wa ye tolehegehe.” ");
INSERT INTO sbe_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu yona hekahekatao hekadi Numa Tabuna lauyahina wekudi taditadidi yo kabahepasadi tamowai se moseidi Yaubada unai wa meta se hetahetaladi. Na Yesu ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mahanana ye laolaoma, kabo ginauli maudoidi kwa kitadi ta se ulugwaligwaligehe, na taba nige weku hesau kabo ye miyamiya yona hali weku kewanaena.” ");
INSERT INTO sbe_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kabo Yesu se henamaiyei se wane, “Taulauhekata, kaiuyana kabo laulau ne se tubu, na yodi huyatubu ne hekihekinoidi saha?” ");
INSERT INTO sbe_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ye wane, “Kwa kitakitanamwanamwa! Tabu tamowai se lupohaigomiu. Tamowai se bado kabo se laoma hesaguyena se hedehedede se wane, ‘Yau ede iya,’ yo se wane, ‘Mahanana ye hanahanaumako.’ Na tabu kwa hemuhemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Huyana iyala yo haikabi wasadi kwa lapuidi meta tabu kwa matausi. Matawuwuna ginaulidi ta kabo se tububaguna, na mulinawai tanoubu yona huyagehe taba nige ye laumwamwayauma.” ");
INSERT INTO sbe_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na yona hedehedede ye tubei ye wane, “Boda hesau kabo ye tolo boda hesau ye iyalai, yo basileiya hesau kabo basileiya hesau ye hewaiunu. ");
INSERT INTO sbe_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kabo mwanikuniku lakilakidi, hasahasali yo kasiyebwa teha udoi udoi udiyedi, yo kabikabi nuwamatamatausidi, yo hekihekinoi saesaedi galewa ne unai se masalaha. ");
INSERT INTO sbe_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Teina ginaulidi ta sola nige se tubu, na tamowai se haigomiu na se hekamkamnagomiu. Na kabo se woyalaegomiu yodi sunago babadadiyao udiyedi na se tolegomiu numatutugudu udiyedi. Yo se woyalaegomiu wasawasa yo gabana matadiyena, matawuwuna yomi sunumaegau ne debanawai. ");
INSERT INTO sbe_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na tenem mahanana ne kabo yomi huya namwanamwana bena kwa hededehemasalahagau kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na yomi nuwahineli kwa ginaulidi meta taba nige kwa nuwamode saha kabo kwa hedede tauhegilugomiu ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Matawuwuna ede, hedehedede yo sibasiba kabo ya haidiwa, unai kami waiunu nige gonowana se tolobayao na se hededebui. ");
INSERT INTO sbe_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sinamiyao yo tamamiyao, kami kahao yo loumiyao yo kehamiyao kabo kamiu se walohai na se moselaegomiu tauhekilaino udiyedi na hekamiu kabo se unuhemwaloigomiu. ");
INSERT INTO sbe_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamowai maudoidi kabo se subugomiu yau debaguyena. ");
INSERT INTO sbe_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na iyamo nige gonowana kulumiu ne maiyawana kesega ye taukwadalele. ");
INSERT INTO sbe_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yomi tolobayao ne unai kabo mauli nige kana siga kwa hai.” ");
INSERT INTO sbe_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Huyana kabo kwa kita iyala tamowaidiyao Yelusalema se tolohetakikili, ede kabina kwa kata meta nige bayaona kabo hetatagwaligwalina mayadaina ye lage. ");
INSERT INTO sbe_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na kaiteyadi teha Yudeya unai se miyamiya, bena se wasabu se lau kuduli udiyedi. Na kaiteyadi magailaki ta unai taumiya bena se pesahai se laugabaei. Yo kaiteyadi magailaki ta dagelana unai se miyamiya, tabu se lusaema. ");
INSERT INTO sbe_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tenem huyana ne meta hekamkamna huyana. Ede saha kulikuli tabuna unai se kuliyako wa kabahemamohoiyena. ");
INSERT INTO sbe_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ahani mo kaiteyadi taudiyadiyaka yo kaiteyadi natudiyao se hesuhesusudi tenem mayadaidi ne udiyedi! Matawuwuna pilipili lakilakina kabo ye laoma teina tano maudoina ta unai na Yaubada yona kouyalayala lakilakina kabo ye talu teina tamowai maudoidi ta udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kabo iyala kelepana unai se unuhemwaloidi o se haidi na se woyalaedi dagela tamowaidiyao yodi basileiya maudoidi udiyedi. Na Yelusalema kabo dagela tamowaidiyao se saedikwai na se tanuwagai ye lau ee kana siga dagela tamowaidi wa yodi huya ye lau ye gehe.” ");
INSERT INTO sbe_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hekihekinoi kabo se tubu mahana, waikena yo kipwala udiyedi. Yo tanoubu ta unai tamowai gabwa dagugudi yo bagodu balamumudi udiyedi se matausikalili. ");
INSERT INTO sbe_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamowai nuwadi se pwanopwanokalili saha kabo ye tubu tanoubu ta unai, na se matausikalili, ede se guli. Matawuwuna Yaubada galewa ginaulidi yodi kabamiya kabo ye nukuidi. ");
INSERT INTO sbe_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tenem mahanana ne unai kabo Tau Natuna se kita yada luwanawai ye laolaoma ma gigibwalina yo ma didigasaesaekalilina. ");
INSERT INTO sbe_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Huyana teina ginauli ta se tubu meta bena kwa tolo ma nuwabayaomiu, matawuwuna yomi yailihai mayadaina meta ye hanahanaukaliliko.” ");
INSERT INTO sbe_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kabo teina palabole ta ye hedede udiyedi ye wane, “Hage, kwa kitalau bosibosi yo kaiwa maudoidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Huyana lugudi se kini kabo kwa kitadi yo kabina kwa kata meta gigibwali huyana ye hanahanauma. ");
INSERT INTO sbe_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gonogonowana doha, huyana teina ginaulidi ta se tubutubu na kwa kitadi, kabo kwa nuwatulobai meta Yaubada yona basileiya ye hanahanauma. ");
INSERT INTO sbe_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya hededemamohoi kalimiuyena: Teina isi ta taba nige ye gehe kana siga teina ginauli maudoidi ta se tubu. ");
INSERT INTO sbe_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Galewa yo tanoubu kabo se gehe, na yogu hedehedede ta meta nige gonowana se gehe.” ");
INSERT INTO sbe_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kwa kitaheteteꞌuyoigomiu! Nuwamiyao taba tabu se lau gwauyala yabayababadi, numayauyaule yo teina tanoubu ta nuwamodemodedi udoiꞌudoi udiyedi. Madai tenem mayadaina ne ye hesiliyatagomiu doha sipwasipwa. ");
INSERT INTO sbe_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Matawuwuna mayadaina ne kabo tanoubu ta taumiyaidi maudoidi ye hesiliyatadi. ");
INSERT INTO sbe_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bena huya badobado kwa nonoha yo kwa tapwatapwalolo meta tenem ginauli maudoidi kabo se tubu ne kwa wasabugabaeidi na Tau Natuna matanawai kabo gonowana kwa tolo.” ");
INSERT INTO sbe_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mayadai kesega kesega Yesu Numa Tabuna unai ye laulauhekata, yo boniyai kesega kesega ye pesa ye lau kuduli hesana Olibe Kudulina unai. ");
INSERT INTO sbe_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yo malatomtom gagilidi udiyedi tamowai maudoidi se laoma kalinawai bena yona lauhekata wa se lapuidi Numa Tabuna bakubakuna wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pwalawa Nige Yistina Henuwaisinina mayadaina ye hanahanauma, mayadaina bagubagunana ede Taukiuli Henuwaisinina. ");
INSERT INTO sbe_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi keda se wasewase bena Yesu se unuhemwaloi. Iyamo boda wa se matausiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kabo Satani ye luwu Yudasi unai. Iya saudoudoi-labui wa hesau, yo hesana hesau ede Isakaliyota. ");
INSERT INTO sbe_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudasi ye lau taukaitalasam tauwoyaidi yo Numa Tabuna yona polisi kadi tanuwagao maiyanao se koitalaliu idohagi kabo Yesu kana ye walohai yo ye moselaei udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Siya nuwadi se namwa yo yali se ginauli meta kabo moni se mosei unai. ");
INSERT INTO sbe_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasi yodi nuwanuwatu wa unai ye yali, ede ye hetubu keda ye wase bena Yesu ye moselaei kalidiyena huyana boda wa nige temenai. ");
INSERT INTO sbe_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kabo Pwalawa Nige Yistina Henuwaisinina mayadaina bagubagunana ye lage, unai kabo Dius tamowaidi Taukiuli mamoena se unuidi se hemala yodi kaitalasam. ");
INSERT INTO sbe_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kabo Petelo yo Yowane ye hetamalidi ye wane, “Kwa lau Taukiuli kaina kada kwa kabinonohai.” ");
INSERT INTO sbe_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Se henamaiyei se wane, “Haedi kabo ka kabinonohai?” ");
INSERT INTO sbe_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ye hededelau kalidiyena ye wane, “Huyana magailaki ne unai kwa lage, loheya hesau waila pakuna ye bahebahei kabo ye lobaigomiu. Kwa hemuliwatani na numa saha unai ye mwalaesae ne meta unai kwa mwalaesae ");
INSERT INTO sbe_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yo kwa hededelau numa tanuwagana ne unai kwa wane, ‘Taulauhekata ye henamai: Taumana dahalana meta haedi na kabo yogu hekahekatao maiyaguwao Taukiuli kaina ka kai?’ ");
INSERT INTO sbe_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iya kabo numa heisi helabuina unai dahala lakilakina hesau ye hekitagomiu. Dahala ne unai ginauli maudoidi ede nonohadi. Temenai kada kai kwa kabinonohai.” ");
INSERT INTO sbe_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Se lau na saha ye hedededi wa meta se lobaidi. Ede unai Taukiuli kaina se kabinonohai. ");
INSERT INTO sbe_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mahanana ye lage ede Yesu maiyana apostolo wa se laoma na se tulidobi kabakaikai hatana dedekana wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na ye hededelau udiyedi ye wane, “Ya henuwakalili bena Taukiuli kaina ta komiu yo yau ta kai, na mulina ne unai kabo ya kamkamna. ");
INSERT INTO sbe_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Teina yomiu ya hedehedede ta: Taba nige ya kaiꞌuyoi ye lau ee kana siga Taukiuli kaina kaniyona kabo ye laoma ye mamohoi Tamagu yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kabo waina keyakana ye hai, ye lautoki yo ye wane, “Teina ta kwa hai na maudoimiu unai kwa numa. ");
INSERT INTO sbe_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya hededelaowa ta taba nige wine kaniyona masina ya numaꞌuyoi, ye lau ee kana siga Yaubada yona basileiya ye lagema.” ");
INSERT INTO sbe_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yo pwalawa ye hai ye lautoki na kabo ye kihi na ye moseidi udiyedi na ye wane, “Teina ta meta yau taugu ya mosegabaei hesabamiu. Teina kwa ginauli meta kabahenuhenuwaisinigau.” ");
INSERT INTO sbe_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Se kaikaigehe, na gonogonowana doha, waina keyakana wa ye hai na ye wane, “Teina ta yau kwasinagu kabo ye didi hesabamiu, na unai kabo Yaubada yona talam hauhauna ye ginauli kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iyamo kaiteya kabo kagu ye walohai ne meta maiyagu hatahata ta unai. ");
INSERT INTO sbe_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tau Natuna kabo ye boita doha Yaubada ye nuwatunonohaiyako, na ahani mo kana tauwalohai tamowaina ne!” ");
INSERT INTO sbe_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ede se bom se henahenamaiꞌuyoidi meta luwadi ne unai kaiteya kabo doha teina ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na kabo siya se bom se haikawayagala meta luwadi ne unai kaiteya kabo ye saekalili. ");
INSERT INTO sbe_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na Yesu ye hededelau udiyedi ye wane, “Dagela tamowaidi yodi wasawasa meta yodi gigibwali bayabayaona unai yodi tamowai se tanuwagaidi, na se kataiꞌuyoidi taukitahetete namwanamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Na komiu meta tabu doha tenem. Kaiteya ye saekalili luwamiu ne unai meta iya taba ye hemala doha taumulita, yo kaiteya iya tanuwaga meta taba ye hemala doha heyayai tauhaina. ");
INSERT INTO sbe_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kaiteya ye saekalili, hatahata unai taukaikai, o heyayai tauhaina? Iya hatahata unai taukaikai ne meta ye saekalili. Na yau luwamiu ta unai meta yomi heyayai tauhaina. ");
INSERT INTO sbe_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Komiu huya badobado maiyaguwao kagu noho maudoidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tamagu basileiya ye leyamako yogu, na yau kabo ya leyawa yomiu, ");
INSERT INTO sbe_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","unai yogu basileiya unai komiu kabo yogu hatahata unai kwa kaikai yo kwa numanuma yo telona udiyedi kwa tuli na Isalaela tamowaidiyao boga saudoudoi-labui ta kwa hekasadi. ");
INSERT INTO sbe_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simona, Simona, ku kitanamwanamwa! Satani ye kaibwadakalili bena maudoimiu ta ye lautonogigomiu doha witi se koinihinihiyei. ");
INSERT INTO sbe_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Na Simona, yom ya tapwaloloko bena yom sunuma tabu ye basabasa. Na huyana ku uyoma kaliguwai kabo kam kahao ku hebayaodi.” ");
INSERT INTO sbe_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na Petelo ye hededebui ye wane, “Guiyau, yau ya nonohakalili kabo ya hemuliwatanigo ta lau numatutugudu unai yo ta lau ta boita.” ");
INSERT INTO sbe_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ye wane, “Petelo, ya hededelaowa: Teina boniyai ta unai sola nige kamkam hakiyana ye dou, na ma haiyona kowa kabo ku hedede meta nige kabigu ku kata.” ");
INSERT INTO sbe_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na Yesu yona hekahekatao ye henamaiyeidi ye wane, “Huyana ya hetamaligomiu kwa lau, na nige moni tobwana o yomi tobwa kwa baheidi o buti kwa likwadi meta saha hesau unai kwa deha o nige?” Se wane, “Nige!” ");
INSERT INTO sbe_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ye wane, “Na teina huya ta doha teina bena kwa ginauli: Ena yom moni tobwana kalimwai, bena ku bahei, yo ena yom tobwa kalimwai, bena hinage ku bahei. Na ena nige yom iyala kelepana, bena kam kwama ku lokunegabaei na iyala kelepana ku hemaisa. ");
INSERT INTO sbe_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ya hededelaowa kalimiuwai: Kulikuli tabuna unai se kuliyako se wane, ‘Iya se kita meta iya hinage laugagayo tauꞌutuꞌutusidi tamowaina hesau,’ na teina hedehedede ta kabo ye laoma ye masalaha kaliguwai. Hedehededegu kulikuli tabuna unai wa meta hemamohoiyeina mahanana ye lagemako.” ");
INSERT INTO sbe_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ede yona hekahekatao wa se wane, “Guiyau, ku kita, iyala kelepadi labui ede teina.” Na ye hededelau kalidiwai ye wane, “Kwa hekaiyawasi. Nabada!” ");
INSERT INTO sbe_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kabo Yesu Yelusalema ye laugabaei na ye lau Olibe Kudulina unai doha huya badobado yona laulau wa, na yona hekahekatao wa iya se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Huyana temenai se lage ede ye hededelau kalidiwai ye wane, “Kwa tapwalolo meta taba nige noho kwa hekalo.” ");
INSERT INTO sbe_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na ye laugabaeidi ye tausigilau lohana doha weku ta tuu, ye tulibonodobi na ye tapwalolo ye wane, ");
INSERT INTO sbe_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamagu, ena ku henuwa, teina kamkamna keyakana ta ku laehesuwala kaliguwai. Na nige yogu nuwatu, na kowa yom nuwatu bena se tubu kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kabo anelu galewa ne unai ye taumasalaha kalinawai na ye hebayao. ");
INSERT INTO sbe_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iya nuwana meta ye kamkamnakalili na ye tapwalolobayaokalili, ede hamumuna wa doha kwasina bwasidi se talutaludobi bwatano ne unai. ");
INSERT INTO sbe_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Huyana ye tapwalolokaiyawasi kabo ye tolo na ye uyo yona hekahekatao wa udiyedi, na ye lobaidi meta se nuwakamkamnakalili na se kenokeno. ");
INSERT INTO sbe_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ede ye hededelau kalidiwai ye wane, “Saha kenona? Kwa tolo na kwa tapwalolo meta taba nige noho kwa hekalo.” ");
INSERT INTO sbe_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu sola ma hedehededena na bodalakilaki se lage. Yudasi, iya saudoudoi-labui wa hesau, ye kedabagunaidi na ye sae Yesu ye sumtai. ");
INSERT INTO sbe_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Na Yesu iya ye henamaiyei ye wane, “Yudasi, idohagi to teina sumta ta unai Tau Natuna kana ku walohai?” ");
INSERT INTO sbe_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu yona hekahekatao se kita kabo Yesu se unui, ede se wane, “Guiyau, iyala kelepadi ta bena ka hepaisowadi?” ");
INSERT INTO sbe_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kabo hekahekatao wa hesau yona kelepa wa ye hekwade na taukaitalasam saesaena yona heyayai tauhaina beyakahatuna ye bolihai. ");
INSERT INTO sbe_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Yesu ye wane, “Nabada! Tabu saha hesau ku ginauliꞌuyoi!” Na ye kabilau tamowai wa beyana unai ede ye henamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Boda wa maidadiyao meta hinage taukaitalasam tauwoyaidi yo Numa Tabuna yona polisi yo babadao hekadi se laoma Yesu hesabana. Kabo Yesu ye hededelau kalidiwai ye wane, “Idohagi, yau tauhaihaikabi, to kelepa yo kepata kwa baheidi na kwa laoma hesabagu? ");
INSERT INTO sbe_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mayadai kesegakesega yau meta maidamiu Numa Tabuna bakubakuna wa unai, na nige kwa kabilaoma kaliguwai. Iyamo yomi huya ede teina. Iya ede masigili gigibwalina yona huyatanuwaga.” ");
INSERT INTO sbe_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kabo Yesu se hai na se woyalaei taukaitalasam saesaena yona numa unai. Na Petelo meta dagela wa unai ye hemuhemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na taupaisowa hekadi kaiwa se yuhi numa wa bakubakuna duwaduwalina unai na se tulihetakikili, na Petelo hinage ye tulidobi maiyanao. ");
INSERT INTO sbe_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Heyayai tauhaina waihiuna hesau iya ye kita kaiwa kalakalasina dawayana unai ye tutuli. Ye kitanamwanamwaei na ye wane, “Teina tamowai ta meta hinage iya maiyana.” ");
INSERT INTO sbe_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na Petelo ye uhala ye wane, “Waihiu, temeta tamowai me meta nige kabina ya kata.” ");
INSERT INTO sbe_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yawalana wa ye lau kabo tamowai hesau iya ye kita na ye wane, “Kowa meta kadi kaha hesauna.” Na Petelo ye wane, “Taubada, yau nige!” ");
INSERT INTO sbe_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na awa kesega ye lau kabo tamowai hesau ye hededebayao kalinawai ye wane, “Mamohoi, teina tamowai ta meta iya maiyana, matawuwuna iya hinage Galili tamowaina.” ");
INSERT INTO sbe_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Petelo yona bui ye mosei ye wane, “Taubada, saha ku hetahetala me nige kabina ya kata!” Sola ma hedehededena na pwaole hakiyana ye dou. ");
INSERT INTO sbe_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Guiyau ye kitabui yo ye kaikewalau Petelo unai, na Petelo Guiyau yona hedehedede wa ye nuwatuidi doha ye wane, “Teina boniyai ta unai sola nige kamkam hakiyana ye dou na ma haiyona kowa kabo ku uhalaeigau.” ");
INSERT INTO sbe_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ede Petelo ye pesa dagela wa unai na ye doukalikalili. ");
INSERT INTO sbe_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tamowai Yesu se kitakitahetete wa iya se talatalawasiyei yo se biteli. ");
INSERT INTO sbe_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na matana se suma yo se henahenamaiyei se wane, “Ku hededepeloweta! Kaiteya ye biteligo?” ");
INSERT INTO sbe_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yo hinage hedehedede yabayababadi hekadiyo udiyedi se hededeheyaheyababa. ");
INSERT INTO sbe_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mala ye tom kabo Dius tamowaidi yodi babadao se koigogo maiyadiyao taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi. Na kabo Yesu se woyalaeiyama kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na se henamaiyei se wane, “Ena kowa Kelisona ede, hage, yomai ku hedehedede.” Yesu yodi bui ye moseidi ye wane, “Ena yomiu ya hedehedede, komiu taba nige kwa kawamamohoiyeigau, ");
INSERT INTO sbe_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","yo ena ya henamaiyeigomiu, komiu taba nige yogu bui kwa leyama. ");
INSERT INTO sbe_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na teina mayadai ta unai yo ye lau ne, Tau Natuna kabo Yaubada Gigibwalikalilina nimakahatuna unai ye tuli.” ");
INSERT INTO sbe_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Maudoidi se henamaiyei se wane, “Unai kowa meta Yaubada Natuna?” Yodi bui ye moseidi ye wane, “Kwa hededemamohoi meta yau ede iya.” ");
INSERT INTO sbe_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kabo se wane, “Taba nige kabahegiluna hesau ta waseneiꞌuyoi. Iya ye bom yona hedehedede ne unai ta lapuiyako.” ");
INSERT INTO sbe_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kabo Sunedeli bodana maudoidi wa se tolo na Yesu se woyalaei Pilato unai ");
INSERT INTO sbe_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","na se hetubu se hegilu, se wane, “Tamowai ta ka lobai meta kai Dius ye woyapwanoligai bena tabu Sisa unai takisi ka toletole yo ye hededehemasalahaꞌuyoi meta iya Keliso yo iya wasawasa.” ");
INSERT INTO sbe_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Unai Pilato Yesu ye henamaiyei ye wane, “Kowa Dius tamowaidi yodi wasawasa?” Yesu yona bui ye mosei ye wane, “Aa, saha ku hedede ne mamohoi.” ");
INSERT INTO sbe_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kabo Pilato ye hededelau taukaitalasam tauwoyaidi yo boda wa udiyedi ye wane, “Teina tamowai ta nige yona yababa hesau ya lobai kabo unai ya hegilu.” ");
INSERT INTO sbe_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Na se muyoukalili se wane, “Iya yona lauhekata udiyedi meta Yudeya teha maudoina tamowaidi ye woyapwanolidi. Galili unai ye hetubu na ye lau ee ye lagema inai.” ");
INSERT INTO sbe_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato hedehedede wa ye lapui, ede ye henamaiyeidi ye wane, “Teina tamowai ta meta iya Galili tamowaina?” ");
INSERT INTO sbe_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yona se hedehedede meta Yesu Heloda yona kabatanuwaga unai ye laoma, ede ye hetamali ye lau Heloda kalinawai. Tenem huyana ne unai iya hinage Yelusalema unai ye miya. ");
INSERT INTO sbe_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Huyana Heloda Yesu ye kita meta nuwana ye namwakalili, matawuwuna huyalohaloha ye henuwakalili bena ye kita. Iya wasana ye lapuiyako na ye henuwa bena laulau gigigigibwalidi hekadi ye ginaulidi na ye kitadi. ");
INSERT INTO sbe_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Unai Heloda henamai udoiꞌudoi ye henamaiyei, na Yesu nige saha hesau ye hedede. ");
INSERT INTO sbe_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taukaitalasam tauwoyaidi yo laugagayo taulauhekataedi siya hinage temenai na Yesu se hegilukaliliyei. ");
INSERT INTO sbe_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kabo Heloda maiyanao iyala tamowaidi iya se talatalawasiyei na kwama didididigana se heluwui doha iya wasawasa hesau, na se hetamali ye uyo Pilato unai. ");
INSERT INTO sbe_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tenem mayadaina ne unai Heloda yo Pilato se kawakeha, na huya bagubagunana unai meta se haihewahewaiunuꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kabo Pilato taukaitalasam tauwoyaidi, tauwoyawoya yo magai wa tamowaidiyao ye yogagogoidima, ");
INSERT INTO sbe_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na ye hededelau kalidiwai ye wane, “Teina tamowai ta kwa woyaiyama kaliguwai na kwa hegilu meta tamowai ye woyawoyapwanolidi. Matamiuyena ya henamaiyeiyako, na yomi kabahegiluna wa unai meta nige gilu hesau ya lobai kalinawai. ");
INSERT INTO sbe_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Doha hinage Heloda nige kana mata ye lobai, unai ye hetamaliꞌuyoiyama kalidawai. Ye masalaha meta teina tamowai ta nige saha hesau yababana ye ginauli kabo unai ye boita. ");
INSERT INTO sbe_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Unai kabo se sapi na ya hetamali ye lau.” ");
INSERT INTO sbe_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na bodalakilaki wa se yogalau se wane, “Teina tamowai ta ku unui! Na Balabasi ku yailihaiyama!” ");
INSERT INTO sbe_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi meta numatutugudu unai se tole, matawuwuna ma kana kahao magailakilaki wa unai maiyadi gabemani se haikabi, na tamowai hekadi ye koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ye henuwa bena Yesu ye yailigabaei, unai boda wa ye henamaiꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Na kabo se yogahilakilaki se wane, “Ku hesatauloyawa! Ku hesatauloyawa!” ");
INSERT INTO sbe_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hehaiyonana unai ye hededelau udiyedi ye wane, “Ye saha? Baꞌaya saha ye ginauli? Nige kana gilu hesau ya lobai kabo unai ye boita. Unai kabo yogu taupaisowa ya hededelau udiyedi na wipi unai se sapiheyababakaliliyei, na kabo se hetamali ye lau.” ");
INSERT INTO sbe_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na kabo se yogahi ma kalinalakilakidi bena Yesu ye hesataulo, na se muyoukalili. ");
INSERT INTO sbe_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ede yodi kaibwada wa unai Pilato yona yali ye ginauli ");
INSERT INTO sbe_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","na tamowai se kaibwadaꞌusei wa ye yailigabaei. Iya ede numatutugudu unai se tole matawuwuna ma kana kahao maiyadi gabemani se haikabi na tamowai hekadi ye koihemwaloidi wa. Na Yesu ye moselaei yona iyala tamowaidi kalidiyena bena boda wa yodi nuwatu se ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iyala tamowaidi Yesu se woyai se laulau kabahesataulona magaina hesabana, na Simona, iya Sailini tamowaina, koya unai ye uyoma, na se lauhelili ede sataulo wa se tolesae dabayalona unai na Yesu ye hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bodalakilaki iya se hemuhemuliwatani, na sinesineo hekadi luwadi wa udiyedi meta sabina se nuwadubu yo se doudou. ");
INSERT INTO sbe_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ede Yesu ye tolobui na ye hededelau udiyedi ye wane, “Yelusalema natunao sinesineo, tabu sabigu kwa doudou, na komiu kwa bom sabimiu yo natumiyao sabidi kwa dou. ");
INSERT INTO sbe_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Matawuwuna huya yababakalilidi kabo se laoma, na udiyedi kabo kwa kamkamnakalili na kwa wane, ‘Waiwaihiuwo kobokobosidi, yo siya kaiteyadi nige se labalaba, yo siya nige se hesuhesusu, meta gonowana se gwauyala.’ ");
INSERT INTO sbe_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kabo tamowai se hededelau koya tupidi udiyedi se wane, ‘Kwa bekudobima kewamai ne udiyedi.’ Yo koya tupidi gagilidi udiyedi se wane, ‘Kwa puluhigai.’ ");
INSERT INTO sbe_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Matawuwuna tamowai se kabiyababaigau doha teina, na yau doha kaiwa kidakidaina. Na komiu ede doha kaiwa pogipogina. Unai yodi kabigomiu ne kabo ye yababakalili.” ");
INSERT INTO sbe_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tamowai yabayababadi labui siya hinage se woyalaedi Yesu maiyadi bena se unuhemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na se lage kabahesataulona Mwayalu Magaina unai. Temenai iya yo tamowai yabayababadi labui wa se hesataulodi, hesau nimakahatuna unai yo hesau nimaseuseulina unai. ");
INSERT INTO sbe_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Yesu ye wane, “Tamagu, yodi yababa ne ku nuwatugabaeidi, matawuwuna nige kabina se kata saha se ginaginauli.” Kabo yona kaleko se tolehekasadi na se kaiheyaidi na se soiyeidi. ");
INSERT INTO sbe_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Boda wa se totolo na se kaikaikewa, na tanutanuwagao wa Yesu se talatalawasiyei se wane, “Tamowai hekadi ye hemaulidi. Ena iya Keliso, Yaubada yona kaisunuwa tamowaina, meta taba ye bom ye hemauliꞌuyoi!” ");
INSERT INTO sbe_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iyala tamowaidi hinage se saema na se talatalawasiyei. Yo winega se mosei bena ye numa ");
INSERT INTO sbe_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na se wane, “Ena kowa Dius yodi wasawasa, hage, ku bom ku hemauliꞌuyoigo.” ");
INSERT INTO sbe_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yo kulubawana wa unai kulikuli hesau se kuli doha teina: “TEINA TA DIUS YODI WASAWASA.” ");
INSERT INTO sbe_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tamowai yabayababadi labui menai se kabakabasi wa hesau Yesu ye hededeheyababa ye wane, “Kowa Keliso, e nige? Hage, ku hemauliꞌuyoigo yo ku hemauligai!” ");
INSERT INTO sbe_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na hesauna wa kana kaha ye dilai ye wane, “Yaubada nige ku matausiyei? Kowa hinage meta iya maidam kabo kwa boita. ");
INSERT INTO sbe_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kita yoda boita ta meta ye dudulai, matawuwuna yoda laulau yabayababadi maisana ta hai. Na teina tamowai ta meta nige yababa hesau ye ginauli.” ");
INSERT INTO sbe_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kabo ye wane, “Yesu, huyana ku lau yom basileiya unai meta ku nuwatuigau.” ");
INSERT INTO sbe_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu yona bui ye mosei ye wane, “Ya hededemamohoi kalimwai: Teina mayadai ta kowa kabo maidagu paladaisi unai.” ");
INSERT INTO sbe_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Mayamayadailaki unai meta mahana ye sinakaiyawasi na masigililakilaki ye laoma na teha maudoina ye sumapwaiki ye lau ee meimeilahi tili (3) koloki unai. Kabo Numa Tabuna woyona ye taigalilabuiyei. ");
INSERT INTO sbe_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na Yesu ye yogahi ma kalinalakilakina, ye wane, “Tamagu, yaluwagu ta ya tolegabaei nimamyena.” Yona hedehedede wa gehena ne unai kabo yawasina ye pito. ");
INSERT INTO sbe_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iyala taubagunaena tamowaina saha ye tubu wa ye kita meta Yaubada ye hedebasaei na ye wane, “Mamohoi, iya meta tamowai dudulaina.” ");
INSERT INTO sbe_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tamowai se bado se laoma bena hesataulona wa se kaikewai. Na huyana saha ye tubu wa se kita, ede se nuwamasalaha na nuwapoudi udiyedi se koikoi na se uyo yodi magai. ");
INSERT INTO sbe_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Yesu kabina taukata yo sinesineo siya Galili unai se hemuliwataniyama wa, kedalohawai se totolo na ginauli saha se tubutubu wa se kaikaikewalaedi. ");
INSERT INTO sbe_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na menai meta tamowai hesau, hesana ede Yosepa, iya Dius yodi tauhelauhetala bodana saesaena tamowaina hesau yo yona laulau meta se namwa yo se dudulai. ");
INSERT INTO sbe_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Teha Yudeya magaina Alimatiya unai ye laoma. Iya Yaubada yona basileiya ye nayanayai. Na huyana Sunedeli bodana yodi yali se ginauli kabo Yesu se unui, meta iya nige ye talam yodi nuwatu yo kabikabi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iya ye lau Pilato unai na Yesu sinalena ye kaibwadai. ");
INSERT INTO sbe_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kabo sinalena wa ye taluhidobiyei, na kaleko posiposina unai ye suma na ye tole bwayabwaya unai. Bwayabwaya wa meta weku duhana na se tadi, na unai meta sola nige tamowai hesau se tole. ");
INSERT INTO sbe_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na teina ta meta Sabati kabinonohana mayadaina, na nige bayaona kabo Sabati hekasisina ye hetubu. ");
INSERT INTO sbe_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Waiwaihiuwo Yesu maiyadi Galili unai se laoma wa Yosepa se hemuliwatani se lau bwayabwaya wa unai na idohagi sinalena yodi toletolena wa se kita. ");
INSERT INTO sbe_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kabo se uyo magai na yausi panepanediyao udoiꞌudoi se kabinonohaidi. Na Sabati unai yodi laugagayo hekasisina debanaena ede se kaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabati ne mayadaina bagubagunana malatomtomna gagilina unai sinesineo ginauli panepanedi se kabinonohaidiko wa se baheidi na se lau bwayabwaya wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na se kita meta bwayabwaya wa kabaguduna wekuna wa se buihesuwala, ");
INSERT INTO sbe_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","na se mwalaesae meta Guiyau Yesu sinalena wa nige se kita. ");
INSERT INTO sbe_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Siya ma nuwanuwatudi na ma kesega loheloheyao labui kadi kwama namanamalidi se taumasalaha na dedekadi wa unai se totolo. ");
INSERT INTO sbe_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Waiwaihiuwo wa se matausi ede se dunedobi bwatano unai, na loheloheyao labui wa se hededelau kalidiwai se wane, “Matawuwuna saha to tamowai maumaulina kwa wasewasenei tauboiboita luwadiwai? ");
INSERT INTO sbe_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iya nige inai, na Yaubada iya ye hetoloꞌuyoiyako! Huyana iya maiyamiu Galili unai, na saha ye hedededi kalimiuwai wa kwa nuwatuidi: ");
INSERT INTO sbe_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tau Natuna kabo se moselaei tamowai baꞌabaꞌayadi nimadiwai bena se hesataulo, na mayadai hehaiyonana unai kabo ye toloꞌuyo.’ ” ");
INSERT INTO sbe_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kabo sinesineo wa yona hedehedede wa se nuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Huyana bwayabwaya wa se laugabaei na se uyo meta teina ginauli maudoidi ta se hededehemasalahadi yona hekahekatao saudoudoi-kesega yo tauhemuliwatanina hekadiyo wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Waiwaihiuwo wa siya ede Maliya iya Magadala waihiuna, Yowana, Maliya Yamesi sinana yo sinesineo hekadi, siya maiyadiyao meta teina ginaulidi ta se hedededi apostolo wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na apostolo sinesineo yodi hedehedede wa nige se kawamamohoiyeidi, matawuwuna yodi hedehedede ta kadi kao doha hedehededegaibu. ");
INSERT INTO sbe_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na Petelo ye tolo na ye heloi ye lau bwayabwaya wa unai. Ye dunedobi na ye kaikewalau meta kaleko posiposina tupwatupwadiyao lohalohadi wa se balabala ye kitadi, na ye uyo, na saha se tubu wa ye nuwanuwatuidi. ");
INSERT INTO sbe_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na tenem mayadai kesekesegana ne unai Yesu tauhemuliwatanina labui se laulau magai hesau hesana Imausa hesabana. Yelusalema na ye lau magai wa meta lohana ede kilomita saudoudoi-kesega (11). ");
INSERT INTO sbe_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Siya ginauli maudoidi se tubu wa udiyedi yodi se tautauhedehedede. ");
INSERT INTO sbe_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na se bom teina ginaulidi ta udiyedi se hedehedede yo se hetahetaladi, na Yesu ye laoma kalidiwai ede maiyanao se lau. ");
INSERT INTO sbe_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na matadi wa Yaubada ye gawuidi ede iya nige se kitalobai. ");
INSERT INTO sbe_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kabo Yesu ye henamaiyeidi ye wane, “Yomi kabalau ta unai meta saha kwa hetahetala?” Ede se talutolo na kadi kao wa meta se nuwadubu. ");
INSERT INTO sbe_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na taudi labui wa hesau, hesana Kilipasi, ye henamaiyei ye wane, “Nuwana Yelusalema unai taumana maudoidi luwadiyena kowa ku bom mo nige kabina ku kata saha se tubu mayadai hisa se laoko wa udiyedi ne?” ");
INSERT INTO sbe_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ye henamaiyeidi ye wane, “Ginaulidi ne meta saha?” Taudi labui wa se hededebui se wane, “Yesu Nasaleta tamowaina wasana. Iya peloweta na yona hedehedede yo yona kabikabi se gigibwalikalili Yaubada yo tamowai maudoidi matadiyena. ");
INSERT INTO sbe_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na taukaitalasam tauwoyaidi yo kama tanutanuwagao se mosegabaei. Se helauhetala na se hekasa meta kabo ye boita, ede se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na ka nuwatui meta iya Isalaela tauyailigabaeidi ede. Na ginauli maudoidi se tubu wa meta mayadai haiyona se lauko wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yo hinage sinesineo hekadi kama boda ta unai meta se hesiliyatagai. Malatomtom gagilina unai se lau bwayabwaya wa unai, ");
INSERT INTO sbe_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","na iya sinalena wa nige se lobai, ede se uyoma na yomai se hedehedede bena anelu tautaudi se kitadi, na se hedede meta iya ye mauliꞌuyoko. ");
INSERT INTO sbe_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kabo kama kahao hekadi se lau bwayabwaya wa na saha sinesineo se hedehededei wa meta se lobai gonogonowana, na iya nige se kita.” ");
INSERT INTO sbe_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kabo Yesu ye hededelau udiyedi ye wane, “Komiu yauyaule, yo yomi nuwatulobai ne se pahili, ede peloweta yodi hedehedede maudoidi nige kwa kawamamohoiyeidi! ");
INSERT INTO sbe_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Se hededenonohaiyako meta teina ginaulidi ta udiyedi Keliso kabo ye kamkamna, na kabo ye seuyo yona didiga ye haiꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na kabo Mose unai ye hetubu na ye lau peloweta maudoidi udiyedi na iya hedehededena saha se kuliyako kulikuli tabudi udiyedi wa meta ye hededehemasalahadi siya kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yodi kabalau magaina se hanahanawui, na Yesu kana kao ye ginauli doha bena ye taukalili ye lau. ");
INSERT INTO sbe_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na se hededenuwahi se wane, “Ku laoma, kabo inai ta keno. Matawuwuna ye meimeilahikaliliko yo nige bayaona kabo ye masigili.” Ede Yesu ye hemuliwatanidi se lau yodi numa. ");
INSERT INTO sbe_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kabo huyana se tuli na se kaikai meta Yesu pwalawa ye hai, ye lautoki, ye kihi, na ye moseidi kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kabo matadi wa se lala yo se kitalobai meta iya Yesu, na matadiyena ye tauwadam. ");
INSERT INTO sbe_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kabo se bom yodi se hedehedede se wane, “Huyana iya maiyada keda wa unai na yoda ye hedehedede na kulikuli tabudi ye hededehemasalahadi kalidawai meta nuwakamnana ta haiyako. Iyamo nige ta kitalobai!” ");
INSERT INTO sbe_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kabo se dalahai na se laumwamwayau se uyo Yelusalema. Temenai hekahekatao saudoudoi-kesega yo kaiteyadi maiyadiyao wa se lobaidi se hebodakesegaidiko. ");
INSERT INTO sbe_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hekahekatao wa se hededelau taudi labui wa udiyedi se wane, “Mamohoi! Guiyau meta ye toloꞌuyoko yo ye taumasalaha Simona unai.” ");
INSERT INTO sbe_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kabo taudi labui wa saha ye tubu keda wa unai meta yodi se hedehedede, yo idohagi Yesu se kitalobai huyana pwalawa ye kihi wa unai. ");
INSERT INTO sbe_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Siya saha se tubu wa sola unai se hedehedede na Yesu ye taumasalaha kalidiwai na ye hededelau udiyedi ye wane, “Nuwadaumwali kwa hai!” ");
INSERT INTO sbe_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na se siliyata yo se matausi, matawuwuna yodi nuwatu bena yaluyaluwa se kita. ");
INSERT INTO sbe_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu ye hededelau udiyedi ye wane, “Idohagi to kwa matausi, yo idohagi na kwa nuwalabulabui? ");
INSERT INTO sbe_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ede doha yau! Sola nimagu yo kaegu ta kwa kitadi. Kwa kabitonogigau yo kwa kita. Yaluyaluwa meta nige bulumana yo siyadana, na kwa kita yau meta bulumagu yo siyadagu.” ");
INSERT INTO sbe_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ye hedehededekaiyawasi, na kabo nimana yo kaena ye hekitadi. ");
INSERT INTO sbe_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na siya meta sola nige se kawamamohoi, matawuwuna se gwauyala yo se nokokalili, unai Yesu ye wane, “Kai saha kwa kabinonohai e nige?” ");
INSERT INTO sbe_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ede yama gabugabuna tehana se mosei, ");
INSERT INTO sbe_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","na ye hai ede matadiyena ye kai. ");
INSERT INTO sbe_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na kabo ye hededelau udiyedi ye wane, “Teina hedehedede ta ya hededediko kalimiuwai huyana sola yau maiyamiu: Hedehededegu maudoidi se kulidiko Mose, peloweta yo Same bukadi udiyedi wa bena se tubu yo se masalaha.” ");
INSERT INTO sbe_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kabo kulikuli tabudi wa ye hededehemasalahadi na unai nuwadi se masalaha. ");
INSERT INTO sbe_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yodi ye hedehedede ye wane, “Teina ta meta saha se kuliyako wa: Keliso kabo ye kamkamna yo mayadai hehaiyonana unai kabo ye toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Na iya hesanaena kabo wasa ye lau tamowai maudoidi udiyedi meta gonowana se nuwabui, yodi baꞌaya nuwatugabaedi hesabana. Na komiu teina ginaulidi ta tauhedehededeidi ede. Yelusalema unai kwa hetubu na kwa laei tanoubu maudoina udiyedi. ");
INSERT INTO sbe_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yau kabo Yaluwa Tabuna ya hetamaliyawa kalimiuwai. Iya ede Tamagu ye hededehesunumayako wa. Na komiu bena magai lakilakina ta unai kwa miyakesegai kana siga galewa ne unai Yaluwa Tabuna yona gigibwali ye taludobima kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kabo Yesu yona hekahekatao ye woyahepesadi se lau Betaniya kana siga unai, na nimana ye lausinidi na ye hededehenamwadi. ");
INSERT INTO sbe_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na yona hededehenamwa wa sola ye laulau na Yaubada ye kabisini ye sae galewa. ");
INSERT INTO sbe_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ede se kaihelahui na se uyo Yelusalema ma gwauyalalakilakidi. ");
INSERT INTO sbe_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mayadai badobado se lau Numa Tabuna bakubakuna wa unai na Yaubada se hedehedebasaei. ");
INSERT INTO sbe_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ginauli maudoidi huyahetubudi unai Yaubada yona Hedehedede wa ye miyamiya, yo Hedehedede wa Yaubada maiyana, yo Hedehedede wa ede Yaubada. ");
INSERT INTO sbe_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ginauli maudoidi huyahetubudi wa unai Hedehedede wa meta Yaubada maiyana. ");
INSERT INTO sbe_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ginauli maudoidi Yaubada ye hetubudi wa iya maiyana se hetubudi, yo Hedehedede wa meta ginauli maudoidi tauhetubudi. ");
INSERT INTO sbe_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iya mauli yona kabalaoma ede, na mauli ne ye hemala tamowai yodi mala. ");
INSERT INTO sbe_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na mala wa ye sina masigili unai, na masigili nige gonowana ye saedikwai. ");
INSERT INTO sbe_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yaubada tamowai hesau ye hetamaliyama, hesana ede Yowane. ");
INSERT INTO sbe_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iya ye laoma meta mala wa tauhededehemasalahana. Na yona hedehedede debanawai tamowai maudoidi bena se kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iya nige mala wa, na ye laoma mala wa ye hededehemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na mala mamohoina kabo ye laoma tanoubu ta unai, na Yaubada kana kao mamohoina ye hededehemasalaha tamowai maudoidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iya Yaubada maiyana tanoubu se hetubu, yo ye miya tanoubu ta unai, na iyamo tanoubu ta tamowaidiyao nige se kitalobai. ");
INSERT INTO sbe_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ye laoma yona tanoubu ye ginauliꞌusei wa unai, na iyamo yona tamowai wa nige se hailobai. ");
INSERT INTO sbe_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Na kaiteyadi iya se hailobai yo hesana se sunumaei, meta dudulai ye moseidi se hemala Yaubada natunao. ");
INSERT INTO sbe_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na nige tamowai yodi labalaba unai, o tamowai yodi gadosisiwai o maitawasola loheya yona nuwatuwai, na Yaubada yona hineli unai se hemala Yaubada natunao. ");
INSERT INTO sbe_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hedehedede wa ye hemala tamowai, na maiyamai ka miya. Yo kana kao saesaena mamohoina ka kitayako, iya ede Yaubada natukesekesegana mo kana kao saesaena mamohoina. Natu ta meta Tamana Yaubada unai ye laoma yo kalinawai kabinamwa yo mamohoina se mwayau. ");
INSERT INTO sbe_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowane ma kalina lakilakina ye hededehemasalaha ye wane, “Tamowaina ede teina lahinaidi ya hededehemasalahayako wa, ‘Iya ede dagelagu ne unai kabo ye laoma, iya meta ye saekalili na kabo yau, matawuwuna iya ye tububaguna.’” ");
INSERT INTO sbe_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iya kalinawai kabinamwa ye mwayau. Na iya unai kita maudoida kabinamwa ta haidi na sola ta haihaiꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mose unai laugagayo wa se laoma, na Yesu Keliso unai kabinamwa yo mamohoina se laoma. ");
INSERT INTO sbe_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sola nige tamowai hesau Yaubada ye kita, na natukesekesegana ye bom mo. Iya meta Yaubada, yo Tamana maiyana se kawakeha, yo iya Tamana ye hemasalahayako kalidawai. ");
INSERT INTO sbe_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dius tauwoyaidi Yelusalema unai taumiyamiya wa, taukaitalasam yo Lewi tamowaidiyao se hetamalidi se lau Yowane unai na se henamaiyei iya meta kaiteya. Teina ta meta Yowane yona hededehemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iya nige ye uhala na ye hededehemasalahaꞌuyoi ye wane, “Yau nige Keliso.” ");
INSERT INTO sbe_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na se henamaiyei, “Ena kowa nige Keliso, meta kowa kaiteya? Kowa Eliya?” Ede ye wane, “Yau nige.” “Nuwana kowa peloweta ka nayanayaiꞌusei wa?” Na ye wane, “Nige.” ");
INSERT INTO sbe_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Na kabo se wane, “Na kowa kaiteya? Yoma henamai ta buina ku leyama, na kabo ka uyo tauhetamaligai wa yodi ka hedehedede. Taba ku bom ku hededehemasalahaꞌuyoigo meta kowa kaiteya.” ");
INSERT INTO sbe_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ede Aisaiya peloweta yona hedehedede unai Yowane ye hededebui ye wane, “Yau tamowaina ede tauyogayoga balabala ne unai ya wane, ‘Guiyau yona keda kwa kabinonohai.’” ");
INSERT INTO sbe_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kabo Paliseya tamowaidiyao hekadi se hetamalidima wa ");
INSERT INTO sbe_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yowane se henamaiyei se wane, “Ena kowa nige Keliso, nige Eliya, yo nige tenem peloweta ne, matawuwuna saha to ku hebahebabatiso?” ");
INSERT INTO sbe_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yowane ye wane, “Waila unai ya hebahebabatiso. Na tamowai hesau meta nige kabina kwa kata ye totolo luwamiu ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iya ede muligu ne unai kabo ye laoma, na yau nige ya namwakalili kabo gonowagu kana sendolo mainadi ya yailidi.” ");
INSERT INTO sbe_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Teina laulau maudoidi ta se tubu Yowane yona kabahebahebabatiso Betaniya, Yolidani sagasagana hali sanakawasina unai. ");
INSERT INTO sbe_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na mayadai hesauna unai Yowane Yesu ye kitalaei ye laolaoma hesabana ede ye wane, “Kwa kitalau, Yaubada yona mamoe natuna ye laolaoma. Iya tanoubu yona baꞌaya tauhaigabaeina. ");
INSERT INTO sbe_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Teina iya ede lahinaidi ya hedehededei wa ya wane, ‘Tamowai hesau yau dagelagu unai kabo ye laoma meta ye saekalili na kabo yau, matawuwuna iya ye tububaguna.’ ");
INSERT INTO sbe_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yau nige ya kitalobai meta iya Keliso. Na ya laoma ya hebabatisoigomiu waila unai meta bena iya ya hemasalaha Isalaela tamowaidiyao kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kabo Yowane ye hededehemasalaha ye wane, “Yaluwa Tabuna ya kita doha bunebune galewa ne unai ye dobima na ye talu iya kewana ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Iyamo iya meta nige ya kitalobai, na Yaubada ye hetamaligau ya laoma waila unai ya hebahebabatiso na ye hededelaoma kaliguwai ye wane, ‘Tamowai hesau kabo ku kita Yaluwa kabo ye dobima na kalinawai ye talu meta iya Yaluwa Tabuna unai kabo ye hebahebabatiso.’ ");
INSERT INTO sbe_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ya kitayako yo ya hemamohoiyei meta iya Yaubada Natuna.” ");
INSERT INTO sbe_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mayadai hesauna unai Yowane maiyana hekahekatao labui se totolo Yowane yona kabahebahebabatiso magaina wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na Yowane ye kaikaikewalau Yesu ye kita ye laulau ede ye wane, “Kwa kita, tenem meta Yaubada yona mamoe natuna!” ");
INSERT INTO sbe_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yona hekahekatao labui wa yona hedehedede se lapui ede Yesu se hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na Yesu ye kaikewabui ye kitadi se hemuhemuliwatani, ede ye henamaiyeidi ye wane, “Saha kwa henuwa?” Se hededelau unai se wane, “Labi, haedi ku miyamiya?” (Labi meta kalina Hebelu na kaniyona ede Taulauhekata.) ");
INSERT INTO sbe_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kabo ye hededelau udiyedi ye wane, “Kwa laoma na kabo kwa kita!” Unai se lau yona kabamiya wa se kita. Na yodi huyalau ne meta meimeilahi mahanana 4 kiloki unai. Na tenem mayadaina ne unai iya maiyadi se miya. ");
INSERT INTO sbe_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Simona Petelo kana kaha Andeleya, iya Yowane yona hekahekatao labui wa hesauna, na Yowane yona hedehedede wa ye lapui ede Yesu ye hemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na kabo Andeleya ye lau kana kaha Simona ye lobai na yona ye hedehedede ye wane, “Mesaiya wa ka lobaiyako.” (Mesaiya Giliki kalinadi unai kaniyona ede Keliso.) ");
INSERT INTO sbe_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ede ye woyaiyama Yesu unai. Yesu ye kitalau iya unai na ye wane, “Kowa Simona, Yowane natuna. Kabo hesam se katai Kipasi.” (Na kalina Giliki unai se wane Petelo.) ");
INSERT INTO sbe_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mayadai hesauna unai Yesu nuwana ye hineli bena kabo ye lau Galili. Na Pilipo ye lobai ede ye hededelau unai ye wane, “Ku laoma ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo meta Betesaida unai ye miyamiya doha hinage Andeleya yo Petelo. ");
INSERT INTO sbe_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo ye lau Natanaela ye lobai na yona ye hedehedede ye wane, “Kulikuli tabuna unai Mose yo peloweta tamowai se hetahetalaꞌusei wa ka lobaiyako. Hesana ede Yesu, Nasaleta tamowaina, iya Yosepa natuna.” ");
INSERT INTO sbe_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na Natanaela ye henamai ye wane, “Mamohoi Nasaleta tamowaina? Ginauli saha namwanamwana kabo Nasaleta unai ye laoma?” Pilipo ye wane, “Ku laoma na ku kita.” ");
INSERT INTO sbe_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Huyana Yesu Natanaela ye kita ye laolaoma ede iya ye hededehemasalaha ye wane, “Teina tamowai ta meta Isalaela tamowaina mamohoina, iya nige gonowana tamowai hesau ye lupoi.” ");
INSERT INTO sbe_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kabo Natanaela ye henamai ye wane, “Idohagi na kabigu ku kata?” Yesu ye hededebui ye wane, “Huyana kaiwa guninawai ku miyamiya meta ya kitagoko, na kabo Pilipo ye yoganeigo.” ");
INSERT INTO sbe_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ede Natanaela ye hededelau unai ye wane, “Labi, kowa Yaubada Natuna, Isalaela yoma wasawasa.” ");
INSERT INTO sbe_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ye wane, “Yom kawamamohoi ne matawuwuna ede ya hededelaowa kalimwai meta ya kitago kaiwa guninawai ku miyamiya. Na sola kabo ginauli saesaedi ku kitadi na kabo teina.” ");
INSERT INTO sbe_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu yona hedehedede ye tubei ye wane, “Ya hededemamohoi kalimiuwai: Kabo galewa kwa kita ye tasoke, na Yaubada yona anelu se dobidobima Tau Natuna unai yo se seuseuyo.” ");
INSERT INTO sbe_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mayadai labui mulidiwai, teha Galili unai magai hesau hesana Kana unai tawasola kaikaigogona se ginauli. Yesu sinana meta iya menai, ");
INSERT INTO sbe_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","yo hinage Yesu maiyana hekahekatao se kaibwadaidi se laoma tawasola kaikaigogona ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huyana waina ye gehe ede Yesu sinana ye hededelau iya unai ye wane, “Kadi waina wa ye gehe.” ");
INSERT INTO sbe_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ye hededebui ye wane, “Sinagu, idohagi to ku hededelaoma kaliguwai? Sola nige yogu huya ye lagema.” ");
INSERT INTO sbe_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na sinana wa ye hededelau heyayai tauhaidi udiyedi ye wane, “Saha ye hedededi ne meta bena kwa ginauliwatanidi.” ");
INSERT INTO sbe_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Numa ne unai waila pakuna haligigi-kesega. Paku ne weku unai se tadidi, na hekadi gonowana waila 80 lita yo hekadi 120 lita unai se hemwayaudi. Na waila wa se hepaisowadiko Dius yodi kaidui yo yodi kaikai gogodiyao kaideulidi kabikabidi hesabadi. ");
INSERT INTO sbe_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na Yesu ye hededelau heyayai tauhaidi wa udiyedi ye wane, “Paku ne waila unai kwa hemwayaudi”, ede se inihemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kabo ye wane, “Kabo gagilina kwa yaihai na kwa bahelaei kaikaigogo tauloinaena unai.” Siya kabo se bahelaei ");
INSERT INTO sbe_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","na waila ye hemala waina wa ye numatonogi. Yodi kabayaina meta nige kabina ye kata, na yona heyayai tauhaidi mo se bom kabina se kata. Kabo kaikaigogo tauloinaena wa tautawasola loheyana ye yoganeiyama ");
INSERT INTO sbe_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na ye hededelau unai ye wane, “Yoda kabikabi kabina ku katakalili, meta waina namwanamwana ta mosebagunai taumana udiyedi. Na huyana se numa se lau na nige gonowana ginauli hesau kamnana se lapulobai kabo waina maisana gagilina ta moseidi. Na idohagi to waina namwanamwakalilina ta ku hemulitayama?” ");
INSERT INTO sbe_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Teina ta meta laulau gigigigibwalina bagubagunakalilina teha Galili unai magai hesana Kana unai Yesu ye ginauli. Na teina laulau ta unai iya kana kao saesaena mamohoina ye hemasalaha, unai yona hekahekatao iya se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tawasola kaikaigogona mulinawai Yesu ma sinana, kana kahao yo yona hekahekatao wa se dobi Kapelenauma, na menai se miya mayadai hisa mo. ");
INSERT INTO sbe_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kabo Dius tamowaidi yodi Taukiuli Henuwaisinina huyana ye hanahanauma, ede Yesu ye sae Yelusalema. ");
INSERT INTO sbe_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na Numa Tabuna bakubakuna unai tamowai hekadi ye lobaidi siya bulumakau, mamoe yo bunebune se lokulokuneidi, yo siya moni taulaulauhedudu meta hatahata kabatulidi udiyedi se tutuli. ");
INSERT INTO sbe_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu kabo maina udiyedi wipi ye ginauli na kabo Numa Tabuna bakubakuna wa unai tamowai, bulumakau yo mamoe maudoidi wa ye henakuhepesadi. Moni taulaulauhedudu yodi moni ye kuyaheꞌuludi yo yodi hatahata ye buidi. ");
INSERT INTO sbe_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na ye hededelau bunebune taulokulokuneidi wa udiyedi ye wane, “Manuwa ta kwa bahehepesadi! Idohagi to tamagu yona Numa Tabuna ta kwa hai ye hemala kabalokulokune numana!” ");
INSERT INTO sbe_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na kabo yona hekahekatao kulikuli tabuna beyabeyana se nuwatui doha ye wane, “Yom Numa Tabuna ya gadosisikaliliyei, na unai kabo se heyababagau.” ");
INSERT INTO sbe_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na Dius tauwoyaidi se hededelau Yesu unai se wane, “Laulau gigigigibwalina saha kabo ku ginauli kalimaiwai, na unai kabo kabina ka kata yom tanuwaga gigibwalina ta meta Yaubada unai ye laoma?” ");
INSERT INTO sbe_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ye hededebui ye wane, “Numa tabuna ta kwa lopagwaligwali, na mayadai haiyona unai kabo ya ginauliꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na kabo Dius tauwoyaidi wa se hededebui se wane, “Teina Numa Tabuna ta meta bolimai badona 46 unai se ginauli. Idohagi to bena mayadai haiyona unai kabo ku ginauliꞌuyoi?” ");
INSERT INTO sbe_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na Numa Tabuna Yesu ye hetahetalaꞌusei ta meta iya ye bom tauna. ");
INSERT INTO sbe_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Unai huyana Yesu ye boita na ye toloꞌuyo meta yona hekahekatao saha ye hededediko wa se nuwatuidi, ede kulikuli tabuna yo Yesu yona hedehedede wa se kawamamohoiyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Huyana Yesu iya Yelusalema unai Taukiuli Henuwaisinina hesabana na menai laulau gigigigibwalidi ye ginaulidi wa meta tamowai gwaudi se kitadi, ede iya hesana unai se sunuma. ");
INSERT INTO sbe_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na Yesu nige ye sunumaeidi, matawuwuna tamowai maudoidi nuwadi kabidi ye katakalili. ");
INSERT INTO sbe_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bwagana Tamowai yodi nuwanuwatu nige se hededehemasalahadi Yesu unai, iyamo kadi kao kabidi ye katako. ");
INSERT INTO sbe_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yelusalema unai meta Paliseya tamowaina hesau, hesana ede Nikodemo, na iya hinage Sunedeli bodana tamowaina hesau. ");
INSERT INTO sbe_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Boniyai hesau unai ye lau Yesu kalinawai na ye wane, “Labi, kabim ka kata meta kowa taulauhekata Yaubada unai ku laoma. Laulau gigigigibwalidi ku ginaulidi wa nige tamowai hesau gonowana ye ginaulidi. Teina unai ye hemasalaha meta Yaubada iya maiyam.” ");
INSERT INTO sbe_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ye hededebui ye wane, “Ya hededemamohoi kalimwai: Ena tamowai hesau nige labasi helabuina ye hai, meta nige gonowana Yaubada yona basileiya ye kita.” ");
INSERT INTO sbe_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na Nikodemo ye hededelau Yesu unai ye wane, “Idohagi kabo tamowai tautaubadana ye luwuꞌuyo sinana bogana unai na labasi helabuina ye hai?” ");
INSERT INTO sbe_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ye hededelau unai ye wane, “Ya hededemamohoi kalimwai: Ena tamowai hesau nige labasi helabuina ye hai waila yo Yaluwa udiyedi, meta taba nige ye lusolalau Yaubada yona basileiya unai. ");
INSERT INTO sbe_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tamowai wawayao se labasidi buluma unai meta buluma mo maulina unai se miya, na Yaluwa meta gonowana mauli nige kana siga ye mosei kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kowa taba nige yogu hedehedede ta udiyedi ku siliyata doha wau ya wane, ‘Taba labasi helabuina kwa hai.’ ");
INSERT INTO sbe_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yaumai ye towama kabo yasasana mo ta lapui, na nige kabina ta kata haedi ye laolaoma o haedi kabo ye laulau. Unai gonogonowana doha siya Yaluwa unai labasi helabuina tauhaina ne.” ");
INSERT INTO sbe_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ye henamaiꞌuyo ye wane, “Teina ta meta idohagi?” ");
INSERT INTO sbe_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na Yesu ye wane, “Kowa meta Isalaela tamowaidiyao yodi laugagayo taulauhekataena, na idohagi to teina nuwanuwatu ta nige ku nuwatulobaidi? ");
INSERT INTO sbe_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya hededemamohoi kalimwai: Saha kabidi ka kata meta ka hedehededeidi, yo saha ka kitadi meta ka hededehemasalahadi kalimiuwai. Na iyamo yoma hedehedede ta nige kwa haidi. ");
INSERT INTO sbe_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tanoubu ginaulidi ya hedehededeidi kalimiuwai, na nige kwa kawamamohoiyeigau. Na idohagi kabo kwa kawamamohoiyeigau taba galewa ginaulidi ya hedehededeidi? ");
INSERT INTO sbe_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nige tamowai hesau ye sae galewa, na kesega mo galewa ne unai ye dobima, iya ede Tau Natuna. ");
INSERT INTO sbe_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Doha Mose mwata ye lausini balabalagaibu unai wa, meta gonogonowana doha tenem kabo Tau Natuna hinage se lausini, ");
INSERT INTO sbe_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","na unai tausunumaena maudoidi kabo mauli nige kana siga se lobai. ");
INSERT INTO sbe_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Matawuwuna Yaubada tanoubu ye gadosisikaliliyei, ede natukesekesegana ye mosegabaei. Unai kaiteya iya ye sunumaei, meta taba nige hekamkamna ye lobai, na mauli nige kana siga kabo ye hai. ");
INSERT INTO sbe_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaubada Natuna ye hetamaliyama nige bena tanoubu ta tamowaidi ye hekilainodi, na bena ye gilihaidi. ");
INSERT INTO sbe_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ena kaiteya Yaubada Natuna ye sunumaei, meta Yaubada taba nige ye hegilu. Na kaiteya nige ye sunumaei, meta Yaubada iya ye hegilunonohaiyako, matawuwuna Yaubada natukesekesegana hesanawai nige ye sunuma. ");
INSERT INTO sbe_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yaubada yona hekasa nuwanuwatuna ede doha teina: Mala wa ye laomako tanoubu ta unai, na tamowai yodi laulau meta se yababakalili, unai masigili se henuwakaliliyei na kabo mala. ");
INSERT INTO sbe_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na kaiteyadi yodi laulau se yababa meta mala wa se subu, yo taba nige se laoma mala ne unai, matawuwuna nige se henuwa bena yodi baꞌaya se hemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na kaiteyadi yodi laulau se dudulai meta se laoma mala ne unai. Na kabo tamowai maudoidi se kitadi meta saha se ginaulidi ne Yaubada ye henuwadi.” ");
INSERT INTO sbe_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na kabo Yesu maiyana hekahekatao Yelusalema se laugabae se lau Yudeya magaina hesau unai. Menai se miya huyana ye katuloha, na Yesu ye hebahebabatiso. ");
INSERT INTO sbe_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na Yowane meta teha hesau unai hinage ye hebahebabatiso. Na iya Aenona unai Salim dedekanawai, matawuwuna temenai waila lakilakina yo tamowai se bado se laolaoma bena se babatiso. ");
INSERT INTO sbe_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tenem huyana ne unai Yowane sola nige se tole numatutugudu unai. ");
INSERT INTO sbe_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yowane yona hekahekatao yo Dius tamowaina hesau Dius yodi lauheꞌaꞌa kabikabina debanaena se haikawayagala. ");
INSERT INTO sbe_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ede se laoma Yowane unai na se wane, “Labi, tamowai wa maiyam Yolidani hali sanakawasina unai na ku hededehemasalahaꞌusei wa meta hinage ye hebahebabatiso, na tamowai maudoidi se laulau iya kalinawai.” ");
INSERT INTO sbe_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yodi hedehedede wa unai Yowane ye hededebui ye wane, “Nige gonowana tamowai hesau paisowa ye haigaibui, na paisowa ye hai ne meta Yaubada ye mosei. ");
INSERT INTO sbe_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yogu hedehedede wa komiu kwa lapuidiko na gonowana kwa hemamohoiyeidi doha ya wane, ‘Yau nige Kelisona ede, na yau meta Yaubada ye hetamalibagunaigau ya laoma.’ ");
INSERT INTO sbe_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tautawasola waihiuna meta iya tautawasola loheyana yona. Na tautawasola loheyana tausaguina meta ye nayanaya yo ye lapulapui. Na huyana tautawasola loheyana kalinana ye lapui meta ye gwauyalakalili. Tenem gwauyala ne meta yau yogu, matawuwuna tautawasola loheyana ede ye masalahako. ");
INSERT INTO sbe_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iya hesana meta bena ye saekalili, na yau hesagu bena ye dobi. ");
INSERT INTO sbe_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iya galewa ne unai ye dobima wa meta tamowai maudoidi ye saedikwaidi. Na kaiteya tanoubu ta unai ye tubuma meta tanoubu ta yona, yo yona hedehedede doha tanoubu ta tamowaina. Na galewa ne unai taudobima wa meta tamowai maudoidi ye saedikwaidi. ");
INSERT INTO sbe_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Saha ye kitadi yo ye lapuidi wa ye hededehemasalahadi. Na iyamo nige hesau ye lapulau yona hedehedede wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na kaiteyadi yona hedehedede wa se hai meta se hemamohoiyei ede Yaubada yona hedehedede wa ye mamohoi. ");
INSERT INTO sbe_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Matawuwuna Yaubada Keliso ye hetamaliyama yo Yaluwa Tabuna unai iya ye hemwayaukaliliyei, ede Yaubada yona hedehedede ye hededehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana meta Natuna ye gadosisiyei, unai ginauli maudoidi ye tolegabaeidi iya nimanawai. ");
INSERT INTO sbe_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na kaiteya iya Natuna ne ye kawamamohoiyei meta mauli nige kana siga ye hai, na kaiteya iya Natuna ne ye subu, taba nige mauli nige kana siga ye hai na Yaubada yona kouyalayala unai ye miya.” ");
INSERT INTO sbe_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Paliseya tamowaidi wasa se lapui meta Yesu iya yona hekahekatao se bado ye haidi yo ye hebabatisoidi, na kabo Yowane. Na iyamo mamohoina ede Yesu nige ye hebahebabatiso, na yona hekahekatao mo se hebahebabatiso. Huyana Yesu wasa ye lapui meta Paliseya tamowaidiyao yona kabikabi wa kabina se kata, ede Yudeya ye laugabae na ye uyo Galili. ");
INSERT INTO sbe_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na yona lau ne unai meta ye lau teha Samaliya unai ");
INSERT INTO sbe_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","na ye lage Samaliya magaina lakilakina hesana Saeka unai. Na menai tano gagilina hesau beyabeyana Yakobo ye mosei natuna Yosepa unai. ");
INSERT INTO sbe_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na temenai meta Yakobo kana wailakeli. Na Yesu yona taihile wa unai kamnana ye yababa, ede ye tuli na ye kaiyawasi wailakeli wa dedekanawai. Na mahanana wa meta mayamayadailaki yona tupwa unai. ");
INSERT INTO sbe_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Na yona hekahekatao se lauko magai wa unai bena kadi kai se hemaisa. Na kabo Samaliya waihiuna hesau ye laoma bena waila ye yai, na Yesu ye hededelau unai ye wane, “Waihiu, taba gonowana waila ku haiyama ya numa?” ");
INSERT INTO sbe_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kabo Samaliya waihiuna wa ye hededelau unai ye wane, “Kowa Dius tamowaina, na yau meta Samaliya waihiuna, na idohagi to ku kaibwadaigau bena waila ya leyawa ku numa?” Yona henamai wa kaniyona ede Dius tamowaidiyao nige gonowana Samaliya tamowaidi maidadiyao se hebodakesega. ");
INSERT INTO sbe_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kabo Yesu ye hededebui ye wane, “Ena taba Yaubada yona kainauya kabina ku kata yo taukaibwadawaila kalimwai ta ku kitalobai, kabo gonowana ku kaibwadaei na waila maumaulina ye leyawa.” ");
INSERT INTO sbe_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na waihiu wa ye wane, “Taubada, nige kam waila kabayaiyaina, na wailakeli ne duhana ye dobikalili. Na haedi kabo waila maumaulina ta ku hai? ");
INSERT INTO sbe_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bena kowa ku saekalili na kabo tamamai Yakobo? Iya wailakeli ta tauleyamana ede. Na iya yo natunao yo yona suisui maudoidi hinage unai se numanuma.” ");
INSERT INTO sbe_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na Yesu ye hededelau unai ye wane, “Kaiteya teina waila ta ye numa, meta kabo gonowana ye gadomaguꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Na kaiteya waila ya mosei ne ye numa, meta taba nige gonowana ye gadomaguꞌuyo. Waila ya mosei ne kabo ye hemala bonobonowasi kalinawai na ye miya ye lau yo mauli nige kana siga ye mosei.” ");
INSERT INTO sbe_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kabo waihiu wa ye hededelau unai ye wane, “Taubada, waila ta ku leyama, to taba nige ya gadomaguꞌuyo yo hinage taba nige ya uyoma inai waila ya yaiyai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ye wane, “Ku lau mwanem ku woihai na kwa laoma inai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Waihiu wa ye hededebui ye wane, “Yau nige mwanegu.” Kabotaki Yesu ye wane, “Ku hedededudulai ede ku wane, ‘Yau nige mwanegu.’ ");
INSERT INTO sbe_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mamohoi, yom hedehedede ne ye dudulai. Na iyamo kowa mwanemwao haligigi ku haidiko, na loheya maiyam ne meta iya nige mwanem.” ");
INSERT INTO sbe_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kabo waihiu wa ye hededelau unai ye wane, “Taubada, ya nuwatulobai meta kowa peloweta. ");
INSERT INTO sbe_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kama mumugao teina kuduli ta unai Yaubada se tabatabaꞌohui, na komiu Dius tamowaidi kwa wane, ‘Kabatabaꞌohu mamohoina ede Yelusalema unai.’” ");
INSERT INTO sbe_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ye hededelau waihiu wa unai ye wane, “Waihiu, saha ya hedehededeidi ta taba ku kawamamohoiyeidi. Huyana kabo ye laolaoma meta taba nige Tamamai kwa tabaꞌohui teina kuduli ta unai o Yelusalema unai. ");
INSERT INTO sbe_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Na komiu Samaliya tamowaidiyao kaiteya kwa tabaꞌohui ne meta nige kabina kwa kata, na kai Tamamai kabina ka kata na ka tabaꞌohui, matawuwuna ede kabihemauli meta kai Dius kalimaiwai ye laoma. ");
INSERT INTO sbe_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Huyana sola ye laolaoma yo iya ede ye laomako na tautabaꞌohu mamohoidi kabo Tamamai se tabaꞌohui yaluwa yo hedehededemamohoi udiyedi, matawuwuna tautabaꞌohu doha tenem meta Tamamai iya ye henuwaꞌuseidi ede. ");
INSERT INTO sbe_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada meta iya yaluwa, unai tautabaꞌohuina bena yaluwa yo hedehededemamohoi udiyedi se tabaꞌohui.” ");
INSERT INTO sbe_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na waihiu wa ye wane, “Kabina ya kata meta Mesaiya kabo ye laoma. Hinage hesana se hedede ede Keliso. Na huyana ye laoma meta ginauli maudoidi kabo ye hededehemasalahadi kalidawai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na kabo Yesu ye hededehemasalahaꞌuyoi ye wane, “Yau ya hedehededelaowa ta meta yau Kelisona ede.” ");
INSERT INTO sbe_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na huyana yona hekahekatao wa se uyoma meta se kita waihiu hesau maiyana se hedehedede, ede se siliyata. Na nige hesau bena ye henamaiyei ye wane, “Saha ku henuwa waihiu ne unai?” o, “Idohagi to waihiu ne maiyam kwa hedehedede?” ");
INSERT INTO sbe_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kabo waihiu wa kana waila pakuna wa ye laugabaei na ye uyo magai wa unai, na tamowai maudoidi yodi ye hedehedede ");
INSERT INTO sbe_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ye wane, “Kwa laoma ta lau tamowai hesau kwa kita. Ginauli maudoidi ya ginaulidiko wa meta ye hededehemasalahadi. Nuwana iya Keliso?” ");
INSERT INTO sbe_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na kabo tamowai gwaudi magai wa unai se laoma na se lau Yesu hesabana. ");
INSERT INTO sbe_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Waihiu wa ye lauko, na kabo Yesu yona hekahekatao wa se hededelau unai se wane, “Labi, taba kai hesau ku kai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na ye hededelau udiyedi ye wane, “Yau kagu kai meta komiu nige kabina kwa kata.” ");
INSERT INTO sbe_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Unai se bom se henahenamaiꞌuyoidi se wane, “Nuwana tamowai hesau kai ye moseiyako ye kai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ye wane, “Kagu kai ede bena tauhetamaligau yona nuwatu ya ginauliwatanidi na yona paisowa ya ginaulihegehedi. ");
INSERT INTO sbe_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yomi hedehedede hesau meta doha teina kwa wane, ‘Nawalai hasi mo na kabo witi huyabolina ye lage.’ Yau ya hededelaowa ya wane, kwa kaikewalau koya ne udiyedi! Witi ye sunako yo ye posiposi, na huyabolina ede ye lageko. ");
INSERT INTO sbe_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na witi tautanogogoina kabo yona paisowa maisana ye hai yo witi ye tanogogoi. Witi ne meta siya ede tamowai se laoma mauli nige kana siga se hai. Unai bena witi tumana tauhesuluna yo witi tautanogogoina kabo se gwauyalakesega. ");
INSERT INTO sbe_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Teina unai hedehedede ta, ‘Hesau ye hesulu na hesau ye tanogogoi’ meta mamohoi. ");
INSERT INTO sbe_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya hetamaligomiu bena kwa lau witi nige kwa hesuludi wa kwa tanogogoidi. Tamowai hekadiyo paisowa lakilakina se ginauliyako, na komiu kabo yodi paisowa wa yona namwanamwa kwa hai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaliya tamowaidi gwaudi magai lakilakina unai taumiya wa Yesu se sunumaei matawuwuna waihiu wa yona hedehedede se lapui ye wane, “Ginauli maudoidi ya ginaulidiko wa meta ye hededehemasalahadi kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Se laoma Yesu unai na se kaibwadai taba menai sola maiyadi se miya, ede ye miya mayadai labui. ");
INSERT INTO sbe_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na Yesu yona hedehedede debanawai ede tamowai hekadiꞌuyo se laoma se hemala tausunumaena. ");
INSERT INTO sbe_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na se hededelau waihiu wa unai se wane, “Huya bagubagunana unai meta yom hedehedede wa debanawai ka sunuma. Na mahana ta unai meta kai ka bom yona hedehedede ta ka lapuidi, unai kabina ka kata meta kita tanoubu ta tamowaidi Tauhemaulida mamohoina ede iya.” ");
INSERT INTO sbe_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mayadai labui wa mulidiwai Yesu ye dalahai ye sae Galili. ");
INSERT INTO sbe_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na Yesu ye hededehemasalahayako meta peloweta yona magai tamowaidiyao iya nige gonowana se hekasisiyei, na iyamo ye sae Galili. ");
INSERT INTO sbe_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Huyana ye lage Galili, meta Galili tamowaidi iya se hailobai, matawuwuna ede Taukiuli Henuwaisinina mayadaidi wa udiyedi siya Yelusalema unai na saha ye ginaulidi wa maudoidi se kitadiko. ");
INSERT INTO sbe_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kabo Yesu ye uyo magai gagilina hesana Kana, Galili tehana unai. Magai ta unai meta lahinaidi waila ye bui ye hemala waina. Na Galili unai magai hesau hesana Kapelenauma, na temenai gabemani yodi tamowai lakilakina hesau, natuna loheya meta ye kasiyebwakalili. ");
INSERT INTO sbe_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na huyana tamowai wa Yesu wasana ye lapui meta Yudeya unai ye saemako Galili, ede ye lau unai na ye kaibwadai bena taba ye laoma Kapelenauma na natuna ne ye henamwanamwa. Wawaya ne meta boita ye hanahanawui. ");
INSERT INTO sbe_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ye hededelau unai ye wane, “Idohagi, kowa yo tamowai maudoidi, ena nige hekihekinoi yo laulau gigigigibwalidi kwa kitadi meta nige gonowana kwa kawamamohoi!” ");
INSERT INTO sbe_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na gabemani yodi tamowai lakilakina wa Yesu ye kaikaibwadai ye wane, “Guiyau, ku laoma ta lau, madai natugu ne ye boita.” ");
INSERT INTO sbe_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na Yesu ye hededelau unai ye wane, “Ku uyo yom magai. Natum ne kabo ye namwanamwa.” Tamowai wa Yesu yona hedehedede ye sunumaei ede ye uyo. ");
INSERT INTO sbe_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sola ma laulauna na yona heyayai tauhaidi hekadi se laoma ede yona se hedehedede meta natuna loheya wa ye namwanamwako. ");
INSERT INTO sbe_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na ye henamaiyeidi ye wane, “Mahana saha unai ye namwanamwa?”, na se wane, “Lahi meimeilahi mahanana 1 kiloki unai taugwagwama wa ye laugabaei.” ");
INSERT INTO sbe_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kabo loheya wa tamana wa nuwana ne unai ye sae meta tenem mahanana ne unai Yesu ye wane, “Natum ne kabo ye namwanamwa.” Ede tamowai wa yo yona numa tamowaidi maudoidi Yesu se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Huyana Yesu Yudeya ye laugabae na ye uyo Galili, meta teina ta yona laulau gigigigibwalina helabuina ede. ");
INSERT INTO sbe_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mayadai hisa mulidiwai kabo Yesu ye sae Yelusalema Dius yodi kaikaigogo hesau hesabana. ");
INSERT INTO sbe_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Yelusalema unai meta waila kipuna hesau keda hesau hesana Mamoe Kedana dedekanawai. Kipuna wa hesana kalina Alamaiki unai se katai Beteseta. Na kabalaulauna numadi haligigi meta waila kipuna wa se tauhetakikili. ");
INSERT INTO sbe_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Temenai meta taukasikasiyebwa doha taumatagibugibu, kae yabayababadi yo taubunibuni bodadi se kenokeno na waila hekahekasina ne se nayanayai. ");
INSERT INTO sbe_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Matawuwuna huya hekadi anelu hesau ye dobi kabo waila kipuna ne ye hekasihetakikili, na ena taukasiyebwa hesau ye gayodobibaguna waila hekahekasina ne unai kabo ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Temenai tamowai hesau ye kasiyebwa bolimai badona 38. ");
INSERT INTO sbe_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu taukasiyebwa wa ye kita ye kenokeno na ye nuwatulobai meta ye kasiyebwa huyalohaloha, ede ye henamaiyei ye wane, “Kowa ku henuwa bena ku namwanamwa?” ");
INSERT INTO sbe_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na tamowai wa ye wane, “Taubada, huyana anelu waila ne ye hekasihetakikili na ya kaipate bena ya gayodobi meta tamowai hesau ye gayodobibagunako, matawuwuna ede nige tausaguigau hesau.” ");
INSERT INTO sbe_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Na Yesu ye hededelau unai ye wane, “Ku tolo yom lauwese ne ku bahei na ku laulau.” ");
INSERT INTO sbe_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tenem mahana ne unai tamowai wa ye namwanamwa, na yona lauwese wa ye noku, ye bahei na ye hetubu ye laulau. Na teina laulau gigigigibwalina ta mayadai Sabati unai ye tubu. ");
INSERT INTO sbe_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ede Dius tauwoyaidi hekadi se hededelau taunamwanamwa wa unai se wane, “Teina mayadai ta meta Sabati, na laugagayo ye hedede meta tabu yom lauwese ku bahei na ku taitaihileꞌusi.” ");
INSERT INTO sbe_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na tamowai wa ye hededebui ye wane, “Tauhenamwanamwagau ye hededelaoma kaliguwai ye wane, ‘Yom lauwese ne ku bahei na ku lau.’” ");
INSERT INTO sbe_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Unai se henamaiyei se wane, “Kaiteya ye hedede bena ku bahei na ku lau?” ");
INSERT INTO sbe_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Taunamwanamwa wa nige kabina ye kata, matawuwuna ede temenai boda wa luwadiyena Yesu ye luwukwadaleleko. ");
INSERT INTO sbe_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na muliyena Yesu iya ye lobai Numa Tabuna unai, ede ye hededelau unai ye wane, “Kowa ku namwanamwako, na tabu yababa ku ginauliꞌuyoi, madai yababalakilaki kabo ku hekalo.” ");
INSERT INTO sbe_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tamowai wa Yesu ye laugabaei na ye lau Dius tauwoyaidi wa yodi ye hedehedede meta tauhenamwanamwana wa Yesu. ");
INSERT INTO sbe_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mayadai Sabati udiyedi Yesu laulau gigigigibwalidi wa ye ginaginaulidi, unai Dius tauwoyaidi se hetubu se hewaiunu. ");
INSERT INTO sbe_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na Yesu ye hededelau udiyedi ye wane, “Tamagu meta mayadai badobado ye paipaisowa ye laoma ee teina, unai yau hinage bena ya paipaisowa.” ");
INSERT INTO sbe_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Unai Dius tauwoyaidi wa se kaipatebayaokalili bena se koihemwaloi, matawuwuna ede mayadai Sabati laugagayona ye utuꞌutusi, yo hinage ye hedede meta tamana ede Yaubada. Na teina hedehedede ta unai ye hemasalaha meta maiyana Yaubada gonogonowadi. ");
INSERT INTO sbe_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ede Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuwai: Natu nige gonowana saha ye bom ye ginauli, na saha Tamana ye ginauli ye kita kabo ye ginauliwatani. Matawuwuna Tamana ginauli saha ye ginauli, Natuna hinage kabo ye ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamana iya Natuna ye gadosisiyei, unai ginauli maudoidi ye ginaulidi meta ye hekita. Mamohoi, Tamana ginauli saesaekalilidi kabo ye hemasalahadi Natuna unai, na kabo teina saha ye ginaulidi ta. Unai kabo kwa noko. ");
INSERT INTO sbe_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamana tauboiboita ye hetoloꞌuyoidi yo mauli ye moseidi, gonogonowana hinage Natuna mauli ye moseidi kaiteyadi ye henuwadi ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamana nige hekasa hesau ye ginauli, na kitahekasa maudoina ye moseiyako Natuna unai, ");
INSERT INTO sbe_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","matawuwuna ye henuwa bena tamowai maudoidi Natuna se hekasisiyei doha hinage Tamana se hekasisiyei. Kaiteya Natuna nige ye hekasisiyei meta hinage Tamana nige ye hekasisiyei, na iya Natuna ta tauhetamaliyamana. ");
INSERT INTO sbe_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ya hededemamohoi kalimiuwai: Kaiteya yogu hedehedede ta ye lapuidi yo tauhetamaligau ye sunumaei, iya meta mauli nige kana siga ye hai, yo Yaubada yona hekasa taba nige ye hekalo. Na boita yona tupwa ye laugabaeyako na mauli nige kana siga kabo ye lobai. ");
INSERT INTO sbe_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya hededemamohoi kalimiuwai: Huyana sola ye laolaoma yo iya ede ye laomako kabo tauboiboita Yaubada Natuna kalinana se lapui. Na kalinana taulapuina ne kabo se mauli. ");
INSERT INTO sbe_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamana iya mauli wuwuna ede, na mauli wa ye mosehekawayako Natuna unai, ede iya hinage ye hemala mauli wuwuna. ");
INSERT INTO sbe_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yo hinage gigibwali ye mosehekawayako iya unai kabo kitahekasa ye ginauli, matawuwuna iya meta Tau Natuna. ");
INSERT INTO sbe_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Teina unai tabu kwa siliyata. Huyana ye laolaoma kabo bwayabwaya udiyedi taukenokeno maudoidi Yaubada Natuna kalinana se lapui ");
INSERT INTO sbe_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na se pesahaima. Na laulau namwanamwadi tauginaulidi kabo se toloꞌuyo na se mauli. Na laulau yabayababadi tauginaulidi kabo hinage se toloꞌuyo, na se lau kamkamna nige kana siga unai. ");
INSERT INTO sbe_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yau nige gonowana ya bom saha hesau ya ginauligaibui. Na saha ya lapui, kabo unai ya hekasa. Na yogu hekasa ne meta ye dudulai, matawuwuna nige yau yogu nuwatu, na tauhetamaligau yona nuwatu ya lauwatani.” ");
INSERT INTO sbe_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ena taba ya bom ya hededehemasalahaꞌuyoigau, meta yogu hededehemasalaha ne nige kaniyona. ");
INSERT INTO sbe_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na Tamagu, iya hinage tauhededehemasalahagau ede, na kabina ya kata meta yona hedehedede ne mamohoidi. ");
INSERT INTO sbe_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Komiu tamowai hekadi kwa hetamalidi se lau Yowane unai bena se henamaiyei. Na yau kagu kao mamohoina ye hededehemasalaha kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tamowai yodi hededehemasalaha nige ya henuwadi, iyamo Yowane yona hededehemasalaha wa ya hedededi kalimiuwai, bena udiyedi kabo mauli kwa lobai. ");
INSERT INTO sbe_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowane kana kao meta doha lampa ye kalakalasi, na komiu dawayana ne unai bena kwa gwauyala huyakubwakubwa mo. ");
INSERT INTO sbe_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na kabahemasalahagau hesauna kaliguwai, iya meta ye saekalili na kabo Yowane yona hedehedede wa, iya ede yogu paisowa Tamagu ye ledima bena maudoidi ya ginaulidi. Kabo yogu paisowa ne se hemamohoiyeigau meta Tamagu ede tauhetamaligau. ");
INSERT INTO sbe_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yo hinage Tamagu tauhetamaligau meta ye hemamohoiyeigauko. Na komiu nige gonowana kalinana kwa lapui yo kana kao kwa kita, ");
INSERT INTO sbe_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","yo yona hedehedede nige se miya nuwamiu ne udiyedi, matawuwuna ede yau Yaubada ye hetamaliꞌuseigau wa nige kwa sunumaeigau. ");
INSERT INTO sbe_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Na komiu meta kulikuli tabuna kwa hasilinamwanamwakaliliyei, matawuwuna yomi nuwatu ede unai kabo mauli nige kana siga kwa lobai. Mamohoi, kulikuli tabuna wa hinage ye hededehemasalahagau. ");
INSERT INTO sbe_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Na iyamo nige kwa henuwa bena taba kwa laoma kaliguwai na mauli kwa hai. ");
INSERT INTO sbe_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yau tamowai yodi hedebasae meta nige ya henuwadi. ");
INSERT INTO sbe_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na kabimiu ya kata meta Yaubada gadosisina kalimiuwai nigele. ");
INSERT INTO sbe_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yau Tamagu hesanawai ya laoma, na iyamo nige kwa lapulaoma kaliguwai. Na nuwana taba tamowai hesau ye bom hesanawai ye laoma, kabo kwa lapulau unai. ");
INSERT INTO sbe_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Maidamiu kwa hedehedebasaeꞌuyoigomiu, na Yaubada, iya ye bom Yaubada, yona kitahenamwa meta nige kwa henuwa. Idohagi na kabo kwa sunumaeigau? ");
INSERT INTO sbe_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tabu yomi nuwatu bena Tamagu matanawai kabo yau ya tolo na ya hegilugomiu. Tauhegilugomiu ede Mose, na komiu yomi nuwatu ede bena iya unai kabo sagu kwa lobai. ");
INSERT INTO sbe_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ena taba Mose kwa kawamamohoiyei, yau hinage bena kwa kawamamohoiyeigau. Matawuwuna wasagu wa Mose ye kuliyako. ");
INSERT INTO sbe_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na ena saha ye kuli wa nige kwa kawamamohoiyei, meta idohagi kabo yau kwa kawamamohoiyeigau?” ");
INSERT INTO sbe_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mayadai hisa se laoko mulidiwai Yesu ye gelu waga hesau unai na Galili Gabwana unai ye kawasi ye lau hali sanakawasina unai. (Na teina waila ta hesana hesau ede Tibeliya Gabwana). ");
INSERT INTO sbe_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na yona kabalau maudoidi ne udiyedi meta bodalakilaki se hemuhemuliwatani, matawuwuna ede laulau gigigigibwalidi ye ginaulidi taukasikasiyebwa udiyedi wa se kitadiko. ");
INSERT INTO sbe_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kabo Yesu ye sae kuduli hesau unai, na temenai yona hekahekatao maiyanao se tuli. ");
INSERT INTO sbe_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na Dius yodi Taukiuli Henuwaisinina huyana meta ye hanahanaumako. ");
INSERT INTO sbe_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na Yesu ye kaikewalau meta bodalakilaki ye kitadi se laolaoma hesabana, ede Pilipo ye henamaiyei ye wane, “Haedi kabo pwalawa ta hemaisa na boda ne ta hekaidi?” ");
INSERT INTO sbe_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na yona henamai ta unai meta bena Pilipo ye laukita, na kabina ye katako meta saha kabo ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo ye hededebui ye wane, “Taba moni lakina denali 200 unai pwalawa ta hemaisa, meta nige gonowana kabo tamowai kesega kesega kana teha gagilina mo ye hai.” ");
INSERT INTO sbe_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na kabo yona hekahekatao wa hesauna hesana Andeleya, Simona Petelo kana kaha wa, ye hededelau Yesu unai ");
INSERT INTO sbe_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ye wane, “Wawaya loheya hesau inai, na bali pwalawadi haligigi yo yama gagilidi labui ede kalinawai. Na idohagi udiyedi kabo bodalakilaki ta ta hekaidi?” ");
INSERT INTO sbe_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Menai meta lagaulakilaki ye kini na kabatulidi se namwakalili, ede Yesu ye wane, “Kwa hededelau tamowai ne udiyedi na se tulidobi lagau ne unai.” Na tautuli ne bodana wa luwadi ne unai meta loheloheyao badodi ede 5,000. ");
INSERT INTO sbe_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kabo Yesu pwalawa wa ye haidi na ye lautoki Yaubada unai, na ye soiyeidi taututuli wa udiyedi. Yo hinage yama wa ye haidi na ye soiyeidi. Na yodi nowonowoiyena kadi pwalawa yo yama se haidi, na maudoidi wa kabo kai lakilakina se kai. ");
INSERT INTO sbe_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Se kaikai ye lau ee kadi siga bogadi wa se sese. Kabo Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Kaitole maudoina ne kwa tanogogoi, na tabu kwa gabagabagaibuidi.” ");
INSERT INTO sbe_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Unai pwalawa haligigi wa taukaidi wa udiyedi kaitole maudoina se tanogogoi, ede bosa badona saudoudoi-labui se hemwayaudi. ");
INSERT INTO sbe_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na laulau gigigigibwalina Yesu ye ginauli tamowai wa se kita ede se wane, “Mamohoi, peloweta ta nayanayaꞌusei bena kabo ye laoma tanoubu ta unai wa, iya ede teina.” ");
INSERT INTO sbe_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu ye nuwatulobai meta kabo se muyowui bena se hetolo yodi wasawasa, unai ye laugabaedi na ye bom ye sae kuduli wa tehana hesau unai. ");
INSERT INTO sbe_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ye meimeilahi ede yona hekahekatao se dobi Galili Gabwana unai, ");
INSERT INTO sbe_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","na waga hesau unai se gelu bena se kawasilau Kapelenauma. Ye masigiliko, na Yesu sola nige ye laoma udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yaumai lakilakina ede ye towatowa, unai gabwa wa ye wowoli. ");
INSERT INTO sbe_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na se yale se lau keda lohana doha maela haiyona o hasi, na kabo Yesu se kita Gabwa wa kewana unai ye laolaoma waga wa hesabana. Ede se matausikalili. ");
INSERT INTO sbe_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Na ye hededelau udiyedi ye wane, “Tabu kwa matamatausi. Yau Yesu.” ");
INSERT INTO sbe_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Unai se henuwa bena taba ye gelu waga wa unai, na nige bayaona na waga wa ye dunasae yodi kabalau magaina wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mala ye tom ede boda se laugabaeꞌuseidi Galili Gabwana hali sanakawasina ne unai wa se nuwatulobai meta meimeilahi wa unai waga kesega mo se kita menai, na Yesu yona hekahekatao se bom mo waga wa unai se gelu se lau, na Yesu nige maiyadi. ");
INSERT INTO sbe_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kabo waga hekadi magai Tibeliya unai se laoma na se dunasae Guiyau yona lautoki kabaginaulina yo boda pwalawa yodi kabakaina magaina wa dedekanawai. ");
INSERT INTO sbe_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na huyana boda wa se nuwatulobai meta Yesu maiyanao hekahekatao wa nige menai, ede waga wa udiyedi se gelu na se lau Kapelenauma Yesu se wasenei. ");
INSERT INTO sbe_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na Gabwa hali sanakawasina wa unai se lobai ede se henamaiyei se wane, “Labi, kaiuyana ku laoma?” ");
INSERT INTO sbe_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yodi henamai wa Yesu ye bui ye wane, “Ya hededemamohoi kalimiuwai: Kwa wasewaseneigau ta meta nige laulau gigigigibwalidi kwa kitadi wa debadiwai, na pwalawa kwa kaidi na bogamiu se sese wa debadiwai. ");
INSERT INTO sbe_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tabu kwa paisowa kai pwasapwasana mo hesabana, na bena hinage kwa paisowa kai miyatahitahina hesabana. Iya kabo mauli nige kana siga ye leyawa. Teina kai ta kabo Tau Natuna ye leyawa, matawuwuna Tamana Yaubada gigibwali ye moseyako kabo gonowana kai ta ye leyawa.” ");
INSERT INTO sbe_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na kabo se henamaiyei se wane, “Idohagi na kabo Yaubada yona paisowa ka ginauli?” ");
INSERT INTO sbe_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ye hededebui ye wane, “Yaubada saha ye henuwagomiu bena kwa ginauli ede teina: Yona lauhetamali tamowaina ne kwa sunumaei.” ");
INSERT INTO sbe_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Na se henamaiꞌuyo se wane, “Laulau gigigigibwalina saha ku ginauli ka kita na unai kabo ka kawamamohoiyeigo? Saha kabo ku ginauli? ");
INSERT INTO sbe_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kama kulutubuwao meta balabala wa unai ‘mana’ se kai doha kulikuli tabuna unai se kuliyako se wane, ‘Iya meta galewa pwalawana ye moseidi se kai.’ ” ");
INSERT INTO sbe_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuwai: Galewa pwalawana meta Mose iya nige ye leyawa, na Tamagu iya galewa pwalawana mamohoina tauleyawana ede. ");
INSERT INTO sbe_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaiteya galewa ne unai ye dobima na mauli ye mosei tanoubu ta udiyedi, iya meta pwalawa Yaubada unai ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kabo se wane, “Taubada, pwalawa ta bena huya badobado kamai ku haihaiyama.” ");
INSERT INTO sbe_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ede Yesu ye hededelau udiyedi ye wane, “Yau mauli pwalawana ede. Na kaiteya ye laoma kaliguwai meta taba nige ye hasali, yo kaiteya ye sunuma kaliguwai taba nige gadona ye magu. ");
INSERT INTO sbe_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na ya hededeyako kalimiuwai meta laulau gigigigibwalidi ya ginaulidi wa kwa kitadiko, na iyamo nige kwa kawamamohoiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na kaiteyadi tamagu ye ledima, siya kabo se laoma kaliguwai. Na taulaoma kaliguwai ne, meta taba nige ya subudi. ");
INSERT INTO sbe_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Matawuwuna yau galewa ne unai ya dobima, meta nige bena yau yogu nuwatu ya ginauli, na Tamagu tauhetamaligau yona nuwatu mo bena ya ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na tauhetamaligau yona nuwatu ede teina: Kaiteyadi ye ledima kaliguwai, meta tabu hesauna ya hetaukwadalele, na hekasa mayadaina unai maudoidi kabo boita unai ya hetoloꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na Tamagu yona nuwatu ede bena siya kaiteyadi taukitalau Natuna unai yo se sunumaei, meta mauli nige kana siga kabo se lobai, yo hekasa mayadaina unai kabo ya hetoloꞌuyoidi.” ");
INSERT INTO sbe_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Teina unai Dius tamowaidi hekadi se hetalapili, matawuwuna Yesu ye wane, “Yau pwalawa mamohoina ede galewa ne unai ya dobima.” ");
INSERT INTO sbe_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ede se wane, “Teina tamowai ta, iya meta Yesu, Yosepa natuna, tamana yo sinana meta kabidi ta kata. Na idohagi to ye wane, ‘Yau galewa ne unai ya dobima’?” ");
INSERT INTO sbe_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ye hededelau udiyedi ye wane, “Saha ya hedededi ta udiyedi tabu kwa hetahetalapili. ");
INSERT INTO sbe_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taba nige tamowai hesau ye laomagaibu kaliguwai, na Tamagu tauhetamaligau kabo ye laeyama kaliguwai, na huyagehena ne unai kabo ya hetoloꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Doha peloweta hesau ye kuliyako ye wane, ‘Yaubada kabo tamowai maudoidi ye hekatadi.’ Na kaiteyadi se lapulau Tamagu unai yo se nuwatuwatani, kabo se laoma kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nige tamowai hesau Tamagu ye kita, na Yaubada unai taudobima ta, iya ye bom mo Tamana ye kita. ");
INSERT INTO sbe_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya hededemamohoi kalimiuwai: Kaiteya ye sunuma kaliguwai meta iya mauli nige kana siga ye hai. ");
INSERT INTO sbe_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau mauli pwalawana ede. ");
INSERT INTO sbe_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kami kulutubuwao balabala unai wa mana se kai, na iyamo maudoidi se boitageheko. ");
INSERT INTO sbe_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na yau pwalawana ede galewa ne unai ya dobima, na kaiteya pwalawa ta ye kai meta taba nige ye boita. ");
INSERT INTO sbe_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yau pwalawa maumaulina ede, galewa ne unai ya dobima. Ena tamowai hesau teina pwalawa ta ye kai, mauli nige kana siga kabo ye hai. Teina pwalawa ta iya ede yau bulumagu ta, kabo ya mosegabaei tanoubu ta tamowaidiyao yodi mauli hesabana.” ");
INSERT INTO sbe_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na kabo Dius tamowaidi se hetahetalapiliꞌuyoidi se wane, “Idohagi na kabo teina tamowai ta bulumana ye leyama ta kai?” ");
INSERT INTO sbe_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu ye hededelau udiyedi ye wane, “Ya hededemamohoi kalimiuwai: Ena Tau Natuna bulumana nige kwa kai yo kwasinana nige kwa numa, taba nige mauli kwa hai. ");
INSERT INTO sbe_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na kaiteya bulumagu ye kai yo kwasinagu ye numa, iya meta mauli nige kana siga ye hai na huya gehena unai yau kabo ya hetoloꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Matawuwuna yau bulumagu ta, iya kai mamohoina yo kwasinagu ta numanuma mamohoina ede. ");
INSERT INTO sbe_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na kaiteya bulumagu ye kai yo kwasinagu ye numa, iya kabo ye miyakesegai yau kaliguwai, yo yau kabo ya miya iya kalinawai. ");
INSERT INTO sbe_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu tauhetamaligau wa, iya mauli wuwuna na iya unai yau ya maumauli, na kaiteya bulumagu ne unai ye kaikai yo kwasinagu ne unai ye numanuma, kabo ye mauli yau debaguwai. ");
INSERT INTO sbe_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na pwalawa ta galewa ne unai ye dobima iya ede yau. Teina pwalawa ta meta udoikalili, nige doha kami mumugao se kaiꞌusei wa. Siya mana se kai, na iyamo se boita. Na kaiteya teina pwalawa ta ye kai kabo mauli nige kana siga ye hai.” ");
INSERT INTO sbe_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu hedehedede maudoidi ta ye hedededi huyana Kapelenauma unai sunago kalonawai ye lauhekata. ");
INSERT INTO sbe_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yona hekahekatao gwaudi hedehedede wa se lapui ede se wane, “Teina lauhekata ta ye pilipilikalili. Kaiteya gonowana ye miyawatani?” ");
INSERT INTO sbe_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kabina ye kata meta yona hekahekatao wa se hetahetalapili, ede ye hededelau udiyedi ye wane, “Teina hedehedede ta se hetausiꞌolologomiu? ");
INSERT INTO sbe_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na yomi nuwanuwatu kabo doha saha, ena taba Tau Natuna kwa kita ye seuyo yona kabalaoma ne? ");
INSERT INTO sbe_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yaluwa Tabuna iya mauli tauleyawana ede, buluma nige gonowana mauli ye leyawa. Na hedehedede ya hedededi kalimiuwai ta, meta Yaluwa mauli tauleyawana unai se laoma na mauli se leyawa. ");
INSERT INTO sbe_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Na komiu luwamiu ne unai hekadi meta nige se sunumaeigau.” Yesu ye hedede doha tenem matawuwuna huya bagubagunana unai na ye laoma meta kabidi ye katako kaiteyadi kabo nige se sunumaei yo hinage kaiteya kabo kana tauwalohai ede. ");
INSERT INTO sbe_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kabo Yesu ye hedehededeꞌuyo ye wane, “Tamowai hekadiyo meta nige yodi sunuma, unai ede ya hededelaowako kalimiuwai meta nige gonowana tamowai se bom yodi nuwanuwatuyena na se laoma kaliguwai, kana sigana ena Tamana ye talamyeidi kabo se laoma kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Teina hedehedede ta mulidiwai meta yona hekahekatao gwaudi se kaiyawasi na nige se hemuliwataniꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kabo Yesu ye hededelau yona hekahekatao saudoudoi-labui wa udiyedi ye wane, “Na komiu hinage kwa henuwa bena kwa laugabaegau?” ");
INSERT INTO sbe_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ede Simona Petelo ye hededebui ye wane, “Guiyau, kabo ka lau kaiteya unai? Kowa ku bom mo mauli nige kana siga hedehedededi wa kalimwai. ");
INSERT INTO sbe_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ka kawamamohoiyeigo yo kabim ka kata meta kowa Tabuna, Yaubada unai ku laoma.” ");
INSERT INTO sbe_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na Yesu ye hededebui ye wane, “Komiu saudoudoi-labui ta ya kaisunuwaigomiu, na iyamo luwamiu ne unai meta kesega iya diyabolo yona taupaisowa.” ");
INSERT INTO sbe_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Teina unai Yesu meta Simona Isakaliyota natuna Yudasi ye hetahetala. Iya saudoudoi-labui wa hesau, na muliwai kabo iya Yesu kana ye walohai. ");
INSERT INTO sbe_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Saha se tubu ta mulidiwai kabo Yesu ye tautakikili Galili magaidiyao udoiꞌudoi udiyedi. Yona nuwatu bena tabu ye laulau Yudeya, matawuwuna temenai Dius tauwoyaidi iya se nayanayaei bena kabo se unui. ");
INSERT INTO sbe_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na Dius yodi Gwau Miyaidi Henuwaisinina huyana ye hanahanauma, ");
INSERT INTO sbe_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ede Yesu kana kahao se hededelau unai se wane, “Kowa taba ku lau Yudeya, na temenai laulau gigigigibwalidi kabo ku ginaulidi na yom hekahekatao se kitadi. ");
INSERT INTO sbe_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ena tamowai hesau ye henuwa bena tamowai maudoidi iya kabina se kata, meta saha ye ginaginaulidi ne taba nige ye ginauli wadawadamyena. Ena kowa laulau gigigigibwalidi ku ginaginaulidi, bena ku hemasalahaꞌuyoigo na tamowai maudoidi se kitago.” ");
INSERT INTO sbe_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yodi hedehedede wa kaniyona ede iya nige se kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na Yesu ye hededelau udiyedi ye wane, “Yau yogu huya sola nige ye lage bena taba ya lau. Na komiu meta huya maudoina udiyedi gonowana kwa lau. ");
INSERT INTO sbe_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tanoubu ta tamowaidiyao taba nige gonowana se subugomiu, na yau meta se subugau, matawuwuna laulau saha se ginaulidi wa, ya hededehemasalahadi meta laulau ta se yababa. ");
INSERT INTO sbe_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Komiu kwa lau gwauyala ne unai, na yau taba nige ya lau, matawuwuna yogu huya dudulaina sola nige ye lage.” ");
INSERT INTO sbe_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Teina doha ye hedehedede na ye miyamiya teha Galili unai. ");
INSERT INTO sbe_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iyamo huyana kana kahao wa se laoko gwauyala ne hesabana, kabo iya hinage ye lau, na yona lau ne unai meta tamowai nige kabina se kata. ");
INSERT INTO sbe_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na gwauyala ne unai Dius tauwoyaidi Yesu se wasewasenei na se henahenamai se wane, “Tamowai wa, iya ede haedi?” ");
INSERT INTO sbe_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Boda maudoidi iya se hetahetalagadigadiguguyei. Hekadi se wane, “Iya tamowai namwanamwana.” Na hekadi se wane, “Nigele! Iya boda taulupolupoidi.” ");
INSERT INTO sbe_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na iyamo nige tamowai hesau ye bom yona nuwanuwatu ye hededehemasalahadi boda kalidiwai, matawuwuna ede siya Dius tauwoyaidi wa se matausiyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yesu ye miyamiya wadawadamyena ye lau ee gwauyala mayadaidi duwaduwalidi unai, na kabo Yesu ye mwalaesae Numa Tabuna bakubakuna unai na ye hetubu ye lauhekata. ");
INSERT INTO sbe_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ede Dius tauwoyaidi se noko na se wane, “Teina tamowai ta kulikuli tabudi nige se hekata. Na idohagi to kabidi ye katakalili?” ");
INSERT INTO sbe_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu ye hededebui ye wane, “Yogu lauhekata ta nige yau ya bom yogu nuwatu, na tauhetamaligau yona nuwatu. ");
INSERT INTO sbe_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ena tamowai hesau ye henuwa bena Yaubada yona nuwatu ye miyawatani, kabo gonowana yogu hedehedede ta ye nuwatulobaidi meta ya bom yogu lauhekata o Yaubada yona lauhekata. ");
INSERT INTO sbe_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ena tamowai hesau ye bom yona nuwanuwatu unai ye hedehedede, meta ye henuwa bena taba tamowai iya se hededetausaei. Na yau yogu nuwatu ede bena tauhetamaligau wa tamowai se hededetausaei. Unai ya hedehededemamohoi, na nige ya kaikailupolupo. ");
INSERT INTO sbe_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose laugagayo ye leyawa, na nige tamowai hesau luwamiuyena laugagayo ta maudoidi ye miyawatanidi. Na ye saha to kwa henuwa bena kwa unuhemwaloigau?” ");
INSERT INTO sbe_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Boda wa se hededebui se wane, “Yaluwa yabayababana ye luwuigo. Kaiteya ye henuwa bena ye unuhemwaloigo?” ");
INSERT INTO sbe_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu ye hededelau udiyedi ye wane, “Laulau gigigigibwalina kesega ya ginauli Sabati mayadaina unai na maudoimiu kwa siliyata. ");
INSERT INTO sbe_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sola pelitome kabikabina kwa nuwatui: Mose pelitome kabikabina ye hekatagomiu, na kabina kwa kata meta nige Mose unai ye laoma, na kada mumugao udiyedi ye laoma. Na komiu Mose yona lauhekata wa kwa ginauliwatani meta huya hekadi mayadai Sabati unai kwa hepehepelitome. ");
INSERT INTO sbe_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mayadai Sabati unai tamowai kwa hepelitomedi, na yomi nuwatu bena tabu Mose yona laugagayo kesega kwa utusi. Na yau meta mayadai Sabati unai tamowai hesau yaluwana yo tauna ya henamwanamwadi. Na ye saha to kwa koipiliyeigau? ");
INSERT INTO sbe_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tabu ginauli kadi kao mo udiyedi kwa kitadi na yomi hekasa kwa ginaginaulidi, na yomi hekasa bena se dudulai.” ");
INSERT INTO sbe_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na Yelusalema tamowaidiyao hekadi se hedede se wane, “Teina tamowai ta meta se wasewasenei bena taba se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na ye laoma ede boda matadiwai ye hedehedede, na idohagi to tauwoyaeda nige saha hesau se ginauli kalinawai? Nuwana kabina se kata meta iya Keliso? ");
INSERT INTO sbe_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na teina tamowai ta yona kabalaoma meta kabina ka katako. Taba iya Keliso meta yona kabalaoma nige gonowana tamowai hesau kabina ye kata.” ");
INSERT INTO sbe_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu sola Numa Tabuna bakubakuna wa unai ye laulauhekata na ye kalinalakilaki ye wane, “Kabigu kwa katako yo yogu kabalaoma hinage kabina kwa katako. Iyamo ya laoma ta meta nige yau ya bom yogu nuwatuwai, na tauhetamaligau ne meta iya mamohoina. Na iya nige kabina kwa kata, ");
INSERT INTO sbe_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","na yau meta kabina ya kata, matawuwuna ede iya unai ya laoma yo iya hinage ye hetamaligau.” ");
INSERT INTO sbe_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kabo Yesu bena se kabihekahini, na iyamo nige tamowai hesau ye kabilau unai, matawuwuna yona huya sola nige ye lage. ");
INSERT INTO sbe_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na boda wa luwadi ne unai meta tamowai gwaudi Yesu se sunumaei na se wane, “Huyana Keliso ye lagema meta yona laulau gigigigibwalidi ne se bado na kabo teina tamowai ta? Nigele! Nuwana teina iya Keliso ye lagemako ede.” ");
INSERT INTO sbe_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bodalakilaki wa Yesu yona gigibwali wa se hetahetala, na Paliseya tamowaidiyao yodi hedehedede wa se lapui ede maiyadiyao taukaitalasam tauwoyaidi kabo Numa Tabuna yona polisi hekadi se hetamalidi se lau bena Yesu se hai na se laeyama kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu yona lauhekata ye tubei ye wane, “Huyakubwakubwa mo yau kabo maiyamiu na kabo ya uyo tauhetamaligau wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Komiu kabo kwa waseneigau, na taba nige kwa lobaigau, yo komiu nige gonowana kwa laoma yogu kabamiya ne unai.” ");
INSERT INTO sbe_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dius tauwoyaidi se bom se henahenamaiꞌuyoidi se wane, “Teina tamowai ta kabo haedi ye laulau, unai taba nige ta lobai? Nuwana kabo ye lau kehadao se haimiyamiyaidi Giliki tamowaidiyao luwadiyena wa udiyedi, na menai kabo Giliki tamowaidiyao ye hekatadi? ");
INSERT INTO sbe_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yona hedehedede ta kaniyodi ede saha? Doha ye wane, ‘Komiu kabo kwa waseneigau, na taba nige kwa lobaigau. Yo komiu nige gonowana kwa laoma yogu kabamiya ne unai.’” ");
INSERT INTO sbe_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gwau Miyaidi Henuwaisinina mayadaina gehegehena yo saesaena unai kabo Yesu ye tolo na kalinana lakilakina unai ye wane, “Ena tamowai hesau gadona ye magu, meta bena ye laoma kaliguwai kabo waila ye numa. ");
INSERT INTO sbe_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Doha peloweta hesau kulikuli tabuna unai ye kuliyako ye wane, ‘Ena kaiteya ye sunuma kaliguwai, kabo iya unai waila maumaulina ye bonobonowasima.’” ");
INSERT INTO sbe_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Teina hedehedede ta, “waila maumaulina”, meta Yesu Yaluwa Tabuna hedehededena ye hedehededei. Na kaiteyadi Yesu se sunumaei kabo Yaluwa ne se hai. Huyana ne unai meta Yaluwa wa sola nige se hai, matawuwuna ede Yesu kana kao saesaena mamohoina Yaubada sola nige ye hemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Boda wa teina hedehedede ta se lapui, ede hekadi se wane, “Mamohoi, teina tamowai ta meta iya Peloweta wa.” ");
INSERT INTO sbe_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hekadi se wane, “Teina Keliso wa”, na hekadi se wane, “Nige! Kabina ka katako meta Keliso taba nige Galili unai ye laoma. ");
INSERT INTO sbe_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na kulikuli tabuna unai ye hemasalaha meta Keliso ne, iya wasawasa Dawida kana isimulita hesau na Dawida yona magai Betelehema unai kabo ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Unai tamowai wa se hebodalabuiyedi Yesu debanaena. ");
INSERT INTO sbe_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Na hekadi se henuwa bena se kabihekahini, na iyamo nige tamowai hesau ye kabilau Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Numa Tabuna yona polisi wa Yesu yona hedehedede wa se lapuidi ede se uyo taukaitalasam tauwoyaidi yo Paliseya tamowaidiyao wa udiyedi. Kabo tauwoyawoya wa se henamailau udiyedi se wane, “Matawuwuna saha to iya nige kwa hai na kwa woyaiyama?” ");
INSERT INTO sbe_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Numa Tabuna yona polisi wa se hededelau udiyedi se wane, “Sola nige tamowai hesau yona hedehedede ka lapui doha iya.” ");
INSERT INTO sbe_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Paliseya tamowaidiyao wa se hededelau udiyedi se wane, “Nuwana komiu hinage ye lupohaigomiu? ");
INSERT INTO sbe_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tauwoyawoya maudoidi yo hinage kai Paliseya meta nige hesau tamowai me ye sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nigekalikalili! Na teina boda ta meta Mose yona laugagayo nige kabina se kata, unai Yaubada yona hededeheyababa kabo ye talu kalidiwai.” ");
INSERT INTO sbe_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na Nikodemo, iya nabada wa unai ye lau Yesu ye kita wa yo iya tauwoyawoya ne kadi kaha hesau, iya ye hededelau udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yoda laugagayo ye hedede meta taba nige tamowai hesau ta hegilugaibui, na bena ta lapulau unai yo saha ye ginauli wa wasana ye hedede ta lapubagunaei, na kabo ta nuwatuhekasa.” ");
INSERT INTO sbe_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ede se hededebui se wane, “Nuwana kowa hinage Galili unai ku laoma? Kulikuli tabuna bena ku hasilinamwanamwaei, na kabo unai ku lobai meta taba nige peloweta hesau Galili unai ye laoma.” ");
INSERT INTO sbe_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na kabo maudoidi wa se dalahaigwaligwali se lau yodi numa. ");
INSERT INTO sbe_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na Yesu ye lau Olibe kudulina unai ye keno, ");
INSERT INTO sbe_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","na malatomtom gagilina hesauna unai ye uyo Numa Tabuna bakubakuna wa unai. Temenai tamowai gwaudi se tupagogoima iya unai, ede ye tuli na ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na laugagayo taulauhekataedi yo Paliseya tamowaidiyao waihiu hesau se woyaiyama. Iya meta se lobai maiyana loheya hesau se ganawali. Na boda matadiwai se hetolo. ");
INSERT INTO sbe_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kabo se hededelau Yesu unai se wane, “Taulauhekata, teina waihiu ta meta ka lobai maiyana loheya hesau se ganawali. ");
INSERT INTO sbe_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na Mose yona laugagayo unai ye wane sinesineo doha teina meta bena ta lauwekuidi. Na kowa kabo saha ku hedede?” ");
INSERT INTO sbe_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Teina henamai ta se tole meta iya kabalaukitana, na saha ye hedede kalidiwai unai kabo iya se hegilu. Na Yesu ye dunedobi na nimagigina unai bwatano wa unai ye hetubu ye kulikuli. ");
INSERT INTO sbe_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na se henamai se muyomuyou, ede ye toloꞌuyo na ye wane, “Kaiteya nige baꞌaya hesau kalimwai kabo weku ku hai na ku tuubagunaei waihiu ne unai.” ");
INSERT INTO sbe_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na ye dunedobi ye kulikuliꞌuyo bwatano wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waihiu tauhegiluna wa Yesu yona hedehedede se lapui ede se hetubu se dalahai, kesega kesega tautaubadao se baguna ye lau ee maudoidi se dalahaigehe, na Yesu yo waihiu wa se bom se laugabaedi boda wa luwadiyena. ");
INSERT INTO sbe_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na kabo Yesu ye dunetoloꞌuyo, na ye henamailau waihiu wa unai ye wane, “Waihiu, maudoidi wa haedi? Hesau ye hegilugo o nige?” ");
INSERT INTO sbe_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Waihiu wa ye wane, “Guiyau, nige hesau.” Ede Yesu ye hededelau unai ye wane, “Yau hinage nige ya hegilugo. Ku lau na tabu ku baꞌabaꞌayaꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na kabo Yesu ye hedehededeꞌuyo boda wa udiyedi ye wane, “Yau tanoubu ta malana ede. Ena tamowai hesau ye hemuliwatanigau, taba nige masigili unai ye laulau, na iya kabo mauli malana unai ye laulau.” ");
INSERT INTO sbe_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Paliseya tamowaidiyao se hededebui se wane, “Yom hedehedede ta udiyedi meta kowa ku bom ku hededehemasalahaꞌuyoigo, unai yom hedehedede ta meta nige mamohoidi.” ");
INSERT INTO sbe_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ye hededebui ye wane, “Mamohoi, yau ya hededehemasalahaꞌuyoigau, na iyamo hedehededegu ta meta mamohoidi. Matawuwuna ede kabina ya kata haedi ya laoma yo hinage haedi kabo ya lau. Na teina nuwanuwatu ta meta komiu nige kabidi kwa kata. ");
INSERT INTO sbe_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Komiu tamowai yodi sonoga udiyedi kabo tamowai kwa kitahekasadi, na yau meta nige tamowai hesau ya kitahekasa. ");
INSERT INTO sbe_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na ena yau tamowai ya kitahekasadi meta yogu hekasa ne se dudulai, matawuwuna ede yau nige ya bom ya kitahekasadi, na Tamagu tauhetamaligau wa meta maiyagu. ");
INSERT INTO sbe_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na komiu yomi laugagayo unai ye hededehemasalaha ye wane, ‘Tamowai labui nuwatu kesega se hededehemasalaha na se yaliyei meta hedehedede ne mamohoina.’ ");
INSERT INTO sbe_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na yau ya bom ya hededehemasalahaꞌuyoigau yo Tamagu tauhetamaligau wa iya hinage ye hededehemasalahagau.” ");
INSERT INTO sbe_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ede se henamaiyei se wane, “Kowa tamam ede haedi?” Yesu ye hededebui ye wane, “Komiu nige yau kabigu kwa kata yo hinage tamagu nige kabina kwa kata. Ena taba yau kabigu kwa kata meta hinage Tamagu kabina kwa kata.” ");
INSERT INTO sbe_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Huyana ne unai Yesu Numa Tabuna bakubakuna unai na moni kabaꞌusaꞌusa kabatolena dedekanawai ye laulauhekata na teina hedehedede ta ye hedededi. Na iyamo iya nige se kabihekahini, matawuwuna ede yona huya meta sola nige ye lage. ");
INSERT INTO sbe_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na kabo yona hedehedede wa ye hededeꞌuyoidi kalidiwai ye wane, “Yau kabo ya laugabaegomiu, na kabo kwa wasewaseneigau, na yomi baꞌaya debadiwai kabo kwa mwaloi. Yau yogu kabalau ne meta komiu nige gonowana unai kwa lau.” ");
INSERT INTO sbe_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Teina unai Dius tauwoyaidi se henahenamaiꞌuyoidi se wane, “Idohagi, tamowai ta kabo ye bom ye unuiꞌuyoi? Nuwana teina unai ede ye wane, ‘Yogu kabalau ne meta komiu nige gonowana unai kwa lau’?” ");
INSERT INTO sbe_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kabo Yesu yona hedehedede wa ye tubei ye wane, “Komiu tehadobidobi ta unai kwa laoma na yau galewa ne unai ya laoma. Komiu tanoubu ta unai kwa laoma, na yau meta nige tanoubu ta unai ya laoma. ");
INSERT INTO sbe_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ya hededeyako kalimiuwai meta yomi baꞌaya debadiwai kabo kwa boita. Ena nige kwa kawamamohoiyeigau meta Yau ede Iya, mamohoikalili yomi baꞌaya debadiwai kabo kwa mwaloi.” ");
INSERT INTO sbe_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ede se henamaiyei se wane, “Na kowa meta kaiteya?” Ye wane, “Yau huya badobado ya hededehemasalahaꞌuseigau wa. ");
INSERT INTO sbe_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yau kaliguwai meta hedehededemiu se bado kabo udiyedi ya hegilugomiu. Na tauhetamaligau wa meta mamohoina, yo saha ya lapuhaidi kalinawai meta ya hededegabaedi tanoubu tamowaidiyao kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na iyamo nige se nuwatulobai meta iya Tamana ye hetahetala. ");
INSERT INTO sbe_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ede Yesu ye wane, “Huyana Tau Natuna kwa lausini, metai kabo kwa kitalobai meta Yau ede Iya, yo yau nige saha hesau ya bom yogu nuwatu ya lauwatani na ya ginauli, na Tamagu saha ye hekatagau wa kabo ya hedededi. ");
INSERT INTO sbe_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na tauhetamaligau wa meta iya maiyagu. Iya taba nige ye laugabaegau, matawuwuna ede huya badobado laulau sahasahadi iya nuwana se henamwa meta ya ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Teina doha Yesu ye hedehedede na tamowai gwaudi iya se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kabo Yesu ye hededelau Dius tamowaidi siya tausunumaena wa udiyedi ye wane, “Ena komiu yogu lauhekata ta kwa miyawatanidi, komiu meta yogu hekahekatao mamohoidi, ");
INSERT INTO sbe_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","na mamohoina kabo kabina kwa kata yo mamohoina ne unai kabo yailihai kwa hai.” ");
INSERT INTO sbe_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Se hededebui se wane, “Kai Abelahama kana isimulitao, yo sola nige tamowai hesau ye haigai ka hemala yona heyayai tauhaina. Idohagi to kowa ku wane, ‘Komiu kabo yailihai kwa hai’?” ");
INSERT INTO sbe_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ye hededeꞌuyo ye wane, “Ya hededemamohoi kalimiuwai: Baꞌaya tauginaginaulidi maudoidi siya meta baꞌaya yona heyayai tauhaidi. ");
INSERT INTO sbe_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Heyayai tauhaina meta iya nige kana tanuwaga yona numa ne bodana unai taumiyatahitahi, na numa ne tanuwagana natuna loheya meta iya numa ne bodana unai taumiyatahitahi ede. ");
INSERT INTO sbe_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Unai, ena Natuna ye yailihaigomiu, komiu kabo yailihai mamohoina kwa hai. ");
INSERT INTO sbe_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kabimiu ya kata meta komiu Abelahama kana isimulitao. Iyamo kwa nonohakalili bena kwa koihemwaloigau, matawuwuna yogu lauhekata ta meta nige yodi kabamiya nuwamiu ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yau saha ya kita Tamagu unai ede ya hededehemasalahadi kalimiuwai, na komiu tamamiu saha ye hedehedededi kalimiuwai wa kwa ginaginauliwatanidi.” ");
INSERT INTO sbe_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na se hededelau unai se wane, “Kai tamamai meta Abelahama.” Yesu ye hededebui ye wane, “Taba ena komiu Abelahama natunao, saha ye ginaulidi wa kabo kwa ginauliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iyamo kwa henuwa bena kwa koihemwaloigau, na yau hedehedede mamohoidi Yaubada unai ya lapuidi wa ya hedehededeidi kalimiuwai. Abelahama nige gonowana Yaubada yona tamowai hesau ye koihemwaloigaibui. ");
INSERT INTO sbe_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Komiu meta tamamiu yona laulau kwa ginaginauliwatanidi.” Ede se hededelau unai se wane, “Kai nige ka tubusaema doha lobalobai, na tamamai kesega mamohoina ede Yaubada.” ");
INSERT INTO sbe_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kabo Yesu ye hededelau udiyedi ye wane, “Ena taba Yaubada komiu tamamiu mamohoina, kabo kwa gadosisiyeigau. Matawuwuna ede yau Yaubada unai ya laoma na ya dobima teinai ya miyamiya. Nige ya bom yogu nuwatuwai ya dobima, na iya ye hetamaligauma. ");
INSERT INTO sbe_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Matawuwuna saha to yogu hedehedede nige kwa lapulobaidi? Kaniyona ede yogu lauhekata ta nige gonowamiu bena kwa lapulau udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Komiu tamamiu ede diyabolo, yo yona nuwatu yabayababadi kwa henuwa bena kwa ginauliwatanidi. Iya taukaiunu huyabagubaguna unai na ye laoma ee teina, yo iya hinage taukailupolupo, matawuwuna ede mamohoina wa nige kalinawai. Huyana ye hededelupolupo, meta iya kana kao mamohoina ye hemahemasalaha, matawuwuna ede iya taulaulaulupolupo, yo laulaulupolupo maudoidi tamadi ede iya. ");
INSERT INTO sbe_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na komiu nige kwa kawamamohoiyeigau, matawuwuna ede yau hedehedede mamohoidi ya hedehededeidi. ");
INSERT INTO sbe_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hage, komiu luwamiu ne unai kaiteya gonowana ye hegilugau meta ya baꞌaya? Na ena hedehedede mamohoidi ya hedehededeidi, ye saha to nige kwa kawamamohoiyeigau? ");
INSERT INTO sbe_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na Yaubada yona tamowai meta saha Yaubada ye hedededi kabo ye lapuidi. Na komiu saha Yaubada ye hedededi meta nige kwa lapuidi, matawuwuna ede komiu nige iya yona tamowai.” ");
INSERT INTO sbe_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kabo Dius tamowaidiyao wa se hededelau Yesu unai se wane, “Na kai ka hedede ta meta ye dudulai ka wane, kowa Samaliya tamowaina yo yaluwa yababana hesau ye luwu kalimwai.” ");
INSERT INTO sbe_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ye hededebui ye wane, “Yaluwa yabayababana nige kaliguwai, na yau meta Tamagu ya hekasisiyei, na iyamo komiu nige kwa hekasisiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yau nige hedebasaegau ya wasenei, na hesau meta hedebasaegau ne ye henuwa, na iya meta tauhekasa ede. ");
INSERT INTO sbe_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya hededemamohoi kalimiuwai: Ena kaiteya yogu hedehedede ye miyawatani, meta iya taba nige boita ye hekalo.” ");
INSERT INTO sbe_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Teina unai Dius tamowaidiyao se hededelau unai se wane, “Teina unai kabim ka kata meta yaluwa yababana luwam ne unai. Abelahama ye boitako doha hinage peloweta maudoidi, na iyamo ku hedede ku wane, ‘Ena kaiteya yogu hedehedede ta ye miyawatani, meta taba nige boita ye hekalo.’ ");
INSERT INTO sbe_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na idohagi? Kowa bena ku saekalili na kabo tamamai Abelahama? Iya ye boitako, yo peloweta maudoidi hinage se boitako. Na yom nuwatu meta bena kowa kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ye hededebui ye wane, “Ena taba ya bom ya hedebasaeꞌuyoigau, meta yogu hedebasaeꞌuyoigau ne nige kaniyona, na tauhedebasaegau ede Tamagu. Na Tamagu ede kwa hedehedede meta komiu yomi Yaubada. ");
INSERT INTO sbe_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Na iyamo iya nige kabina kwa kata, na yau kabina ya kata. Yo ena taba ya wane bena iya nige kabina ya kata meta yau taulaulaulupolupo doha komiu. Yau meta kabina ya kata yo yona hedehedede ya miyawatanidi. ");
INSERT INTO sbe_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamamiu Abelahama ye henuwa bena yogu laoma mayadaina ne ye kita, na ye kitayako, ede ye gwauyalakalili.” ");
INSERT INTO sbe_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kabo Dius tamowaidiyao wa se hededelau unai se wane, “Kowa sola nige yom bolimai 50, na idohagi to ku hedede bena Abelahama ku kitayako?” ");
INSERT INTO sbe_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na Yesu ye wane, “Ya hededemamohoi kalimiuwai: Abelahama sola nige ye tubu na yau meta Yaubada maiyagu.” ");
INSERT INTO sbe_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Teina debanawai weku se haidi na Yesu bena se lauwekui, na ye taukenokenowadam na Numa Tabuna wa ye pesagabaei na ye lau. ");
INSERT INTO sbe_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Huyana Yesu kedawai ye laulau meta tamowai hesau matagibugibuna ye kita. Tamowai ta huyalabasina unai meta matagibugibuna. ");
INSERT INTO sbe_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yona hekahekatao se henamaiyei se wane, “Labi, kaiteya yona baꞌaya debanawai na tamowai ta matana se gibu? Iya o tamana yo sinana yodi baꞌaya debadiwai?” ");
INSERT INTO sbe_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ye hededebui ye wane, “Teina tamowai ta o tamana yo sinana siya nige yodi baꞌaya debadiwai. Na huyalabasina unai meta matagibugibuna, bena unai kabo Yaubada yona kabikabi ye hemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tauhetamaligau yona paisowa mayadaiyena bena ta ginaulidi. Nige bayaona kabo ye masigili, na masigili ne unai nige gonowana tamowai hesau ye paisowa. ");
INSERT INTO sbe_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tanoubu ta unai yogu miya ta unai meta yau tanoubu ta malana ede.” ");
INSERT INTO sbe_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu ye hedehededegehe ede ye kaisodobi bwatano ne unai na bwatano gagilina ye hebigabiga, na kabo ye hai na ye sausae taumatagibugibu wa matana wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kabo ye hededelau unai ye wane, “Ku lau Silowama wailana kipuna unai matam ne ku deulidi.” (Silowama kaniyona ede hetamali.) Kabo tamowai wa ye lau matana wa ye deulidi, na ye uyoma meta matana wa se lalako. ");
INSERT INTO sbe_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tamowai wa dedekanaena taumiya tamowaidiyao yo tamowai hekadi, huyabagubagunawai se kitayako meta iya taukaikaibwada, ede se henahenamaiꞌuyoidi se wane, “Tamowai ta, iya lahinaidi ye tutuli na ye kaikaibwadaꞌusi wa, o udoi?” ");
INSERT INTO sbe_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na hekadi se wane, “Iya tamowaina ede.” Na hekadi se wane, “Nige! Kana kao ne meta doha iya.” Na iya ye bom mo ye hedehededehemasalahaꞌuyoi ye wane, “Yau tamowaina ede.” ");
INSERT INTO sbe_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ede iya se henamaiyei, se wane, “Idohagi na matam ne se lala?” ");
INSERT INTO sbe_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na ye hededelau udiyedi ye wane, “Tamowai hesau hesana ede Yesu ye kaiso bwatano ne unai, ye hebigabiga, ye hai na ye sausae matagu ta udiyedi, na ye hededelaoma ede ya lau Silowama wailana kipuna unai ya deulidi. Unai ya lau matagu ta ya deulidi ede se lala.” ");
INSERT INTO sbe_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kabo se henamaiyei se wane, “Tamowaina ede haedi?” Na ye wane, “Nige kabina ya kata.” ");
INSERT INTO sbe_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kabo huyabagubaguna unai tamowai matana se gibuꞌusi wa se woyalae Paliseya tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mayadaina Yesu bwatano ye hebigabiga na ye sausae tamowai matana udiyedi na se lala wa meta Sabati unai. ");
INSERT INTO sbe_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na Paliseya tamowaidiyao se henamaiyei se wane, “Idohagi na matam ne se lala?” Tamowai wa ye hededebui ye wane, “Bwatano ye hai ye hesau matagu ta udiyedi na ya deulidi, ede se lala.” ");
INSERT INTO sbe_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Paliseya tamowaidi hekadi se wane, “Tamowai ne nige Yaubada unai ye laoma, matawuwuna iya mayadai Sabati nige ye hekasisiyei.” Na hekadi se wane, “Idohagi to baꞌaya tamowaina laulau gigigigibwalidi doha teina ye ginaulidi?” Ede menai Paliseya wa se hekasalabuiyedi, hekadi yodi nuwanuwatu udoi, yo hekadi yodi nuwanuwatu udoi. ");
INSERT INTO sbe_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kabo Paliseya tamowaidiyao wa tamowai wa se henamaiyeiꞌuyoi se wane, “Tamowai kowa matam ne ye helaladi wa, ku hededehemasalaha kalimaiyena meta iya kaiteya! Hage, yom nuwanuwatu saha?” Tamowai wa ye wane, “Iya meta peloweta hesau.” ");
INSERT INTO sbe_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na mahana ne unai Dius tauwoyaidi wa sola nige se kawamamohoi bena huya bagubagunana unai tamowai ne matana se gibu na muliyena kabo se lala, ede tamana yo sinana se tauwasaidima ");
INSERT INTO sbe_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na se henamaiyeidi se wane, “Mamohoina teina tamowai ta iya natumiu? Na komiu kwa hedede bena huyalabasina unai meta matagibugibuna. Na idohagi to matana se lala?” ");
INSERT INTO sbe_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamana yo sinana wa se hededebui se wane, “Kabina ka kata meta iya kai natumai, yo hinage huyalabasina unai meta iya matagibugibuna. ");
INSERT INTO sbe_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Na idohagi na matana se lala yo kaiteya matana ne ye helaladi meta nige kabina ka kata. Na iya tamowai lakilakina, unai kwa henamaiyei kabo yomiu ye hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana yo sinana doha teina se hedehedede matawuwuna ede Dius tauwoyaidi se matausiyeidi. Matawuwuna tauwoyawoya wa se hededeyako meta kaiteya Yesu ye hededehemasalaha iya Keliso, kabo sunago unai se hepesa. ");
INSERT INTO sbe_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Teina debanawai ede tamana yo sinana se wane, “Iya tamowai lakilakina, unai gonowana kwa henamaiyei!” ");
INSERT INTO sbe_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ede tamowai matana se lalako wa se yogaꞌuyoiyama na se hededelau unai se wane, “Bena Yaubada ku hekasisiyei na ku hededemamohoi! Kai kabina ka kata meta tamowai wa iya baꞌaya tamowaina.” ");
INSERT INTO sbe_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na ye wane, “Yau nige kabina ya kata meta iya baꞌaya tamowaina o nige. Na saha kabina ya kata ede huyabagubaguna unai matagu se gibu, na teina huya ta meta matagu se lalako.” ");
INSERT INTO sbe_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ede se henamaiyei se wane, “Saha ye ginauli kalimwai? Idohagi na matam ne ye henamwanamwadi?” ");
INSERT INTO sbe_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na ye hededebui ye wane, “Teina ta ya hededeyako kalimiuwai, na nige kwa lapulau yogu hedehedede wa udiyedi. Matawuwuna saha to bena kwa lapuꞌuyoidi? Kwa henuwa bena kwa hemala iya yona hekahekatao?” ");
INSERT INTO sbe_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kabo se hededeheyaheyababa se wane, “Kowa teina tamowai ta yona hekahekata, na kai meta Mose yona hekahekatao. ");
INSERT INTO sbe_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kai kabina ka kata meta Yaubada ye hedehededelau Mose unai, na teina tamowai ta yona kabalaoma nige kabina ka kata.” ");
INSERT INTO sbe_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kabo tamowai wa ye hededelau udiyedi ye wane, “Idohagi to komiu kwa nuwapwanopwano? Iya matagu ye helaladi, na iyamo nige kabina kwa kata meta haedi ye laoma. ");
INSERT INTO sbe_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kita kabina ta kata meta Yaubada nige ye lapulapulau baꞌaya tamowaidiyao udiyedi, na ye lapulapulau tautabaꞌohuina yo yona nuwatu tauginaulidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Huyabagubaguna unai ye laoma ee teina sola nige wasa hesau ta lapui meta tamowai hesau se labasi matagibugibuna na gonowana matana ne tamowai hesau ye kabihelalaꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ena taba teina tamowai ta nige Yaubada unai ye laoma, taba nige gonowana laulau gigigigibwalidi doha teina ye ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yona hedehedede wa udiyedi ede se wane, “Huyana se labasigo ye laoma ee teina meta kowa yababa tamowaina, na idohagi to bena ku hekatagai?” Ede iya sunago unai se hepesa. ");
INSERT INTO sbe_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu wasa ye lapui meta tamowai wa sunago unai se hepesa, ede ye lau ye kita na ye henamaiyei ye wane, “Tau Natuna ku sunumaei?” ");
INSERT INTO sbe_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tamowai wa ye henamai ye wane, “Guiyau, Tau Natuna ede kaiteya? Taba ku hekitagau, kabo ya sunumaei.” ");
INSERT INTO sbe_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ye hededelau unai ye wane, “Tamowaina ede ku kitayako. Iya ede teina maidam kwa hedehedede ta.” ");
INSERT INTO sbe_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tamowai wa ye hedede ye wane, “Guiyau, ya sunuma!”, na Yesu ye tabaꞌohui. ");
INSERT INTO sbe_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na kabo Yesu ye wane, “Hekasa hesabana ya laoma tanoubu ta unai, bena kaiteyadi matadi se gibu, kabo matadi se lala, na kaiteyadi matadi se lala, kabo matadi se gibu.” ");
INSERT INTO sbe_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Paliseya tamowaidi hekadi siya Yesu dedekanawai na yona hedehedede ta se lapui, ede se henamaiyei se wane, “Idohagi? Saha ku hedede? Kai matamai ta nige se gibu.” ");
INSERT INTO sbe_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ye hededebui ye wane, “Taba ena komiu matamiu se gibu, kabo nige yomi baꞌaya. Na komiu kwa hedede kwa wane, ‘Matamai se lala,’ unai yomi baꞌaya meta sola kalimiuwai.” ");
INSERT INTO sbe_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu yona hedehedede ye tubei ye wane, “Ya hededemamohoi kalimiuwai: Ena tamowai hesau mamoe yawoina ganana nige ye mwalae kawakedana unai, na tupwa hesau unai ye mwalaedikwa, meta iya taukabigaibu yo taukaiwahali. ");
INSERT INTO sbe_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaiteya kawakeda ne unai ye mwalaesae iya meta mamoe taukitahetetedi mamohoina ede. ");
INSERT INTO sbe_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kawakeda taukitahetetena kabo kawakeda guduna ye soke mamoe taukitahetetedi hesabana, yo mamoe ne se lapulapulau taukitahetetedi ne kalinana unai. Iya yona mamoe hesadi ye kataidi na ye woyahepesadi. ");
INSERT INTO sbe_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huyana yona mamoe ne ye woyahepesadi, meta ye bagunaedi na iya se hemuliwatani, matawuwuna iya kalinana kabina se katakalili. ");
INSERT INTO sbe_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Taba nige tamowai udoi se hemuliwatani, na se wasabugabaei, matawuwuna ede kalinana nige kabina se kata.” ");
INSERT INTO sbe_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Teina palabole ta Yesu ye hededegabaei, na kaniyona saha bena ye hekatadi wa meta nige se nuwatulobai. ");
INSERT INTO sbe_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Unai Yesu ye hededeꞌuyo ye wane, “Ya hededemamohoi kalimiuwai meta yau Yaubada yona mamoe yodi kawakeda ede, unai kabo se mwalaesae Yaubada yona mamoe yawoina ganana unai. ");
INSERT INTO sbe_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kaiteyadi se bagunama wa meta siya taukabigaibu yo taukaiwahali, na mamoe ne nige se lapulau udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau kawakedana ede. Kaiteyadi se laoma yau kaliguwai kabo se lusolalau Yaubada yona basileiya unai na mauli se lobai. Yo yodi kabalau maudoina udiyedi kabo Yaubada ye kitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Taukaiwahali ye laoma ye kaiwahali, ye kaiunu yo ye heyababagomiu, na yau ya laoma bena mauli kwa hai na mauli mamohoina maudoina kwa haihegehe. ");
INSERT INTO sbe_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yau Yaubada yona mamoe taukitahetetedi namwanamwana ede. Taukitahetetedi namwanamwana ta yona mauli kabo ye mosegabaei yona mamoe hesabadi. ");
INSERT INTO sbe_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Taupaisowa maisa tauhaihaina meta iya nige mamoe ne taukitahetetedi mamohoina, na huyana kedewanukula hesau ye kita ye laoma mamoe ne hesabadi meta kabo ye wasabugabaedi. Na kedewanukula ne kabo mamoe ne ye henakudi, ye kalasidi na ye hetatagwaligwalidi. ");
INSERT INTO sbe_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Taupaisowa maisa tauhaihaina wa ye wasabu, matawuwuna iya taupaisowa mo, unai nige ye modekalili mamoe ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yau mamoe taukitahetetedi namwanamwana ede, yo yogu mamoe kabidi ya kata yo siya hinage kabigu se kata, ");
INSERT INTO sbe_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","doha Tamagu kabigu ye kata yo hinage iya kabina ya kata. Yo yau yogu mauli kabo ya mosegabaei yogu mamoe hesabadi. ");
INSERT INTO sbe_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yau yogu mamoe hekadiyo hinage, siya meta nige teina yawoi ta unai, na bena taba ya woyaidima kabo hinage se lapulaoma kaliguwai. Kabo se hemala yawoi kesega yo hinage taukitahetetedi kesega. ");
INSERT INTO sbe_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamagu ye gadosisiyeigau, matawuwuna yogu mauli kabo ya mosegabaei bena kabo ya haiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nige gonowana tamowai hesau yogu mauli ye haigabaei, na yau ya bom yogu nuwayaliwai kabo ya mosegabaei. Yau yogu gigibwali unai ya mosegabaei yo yogu gigibwali gonowana kabo ya haiꞌuyoi. Teina ta meta Tamagu ye hedede bena ya ginauli.” ");
INSERT INTO sbe_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Teina lauhekata ta udiyedi ede Dius tamowaidiyao wa luwadiyena meta nuwanuwatu labui. ");
INSERT INTO sbe_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bodalakilaki se wane, “Yaluwa yababana ye luwu kalinawai, ede ye bwadebwade. Idohagi to ta lapulapulau unai?” ");
INSERT INTO sbe_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na hekadi se wane, “Taba yaluwa yababana ye luwu tamowai unai, teina hedehedede ta nige gonowana ye hedededi. Yo yaluwa yababana nige gonowana taumatagibugibu matana ye helala.” ");
INSERT INTO sbe_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na kabo Dius yodi Numa Tabuna Hetabuꞌuyoina Henuwaisinina Yelusalema unai se ginauli. Tenem huyana ne meta huyagwagwama. ");
INSERT INTO sbe_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na Yesu Numa Tabuna teha hesauna hesana Solomona yona Logulogu unai ye taitaihile. ");
INSERT INTO sbe_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na Dius tauwoyaidi Yesu se tolohetakikili na se henamaiyei se wane, “Huya lohana doha saha kabo ku henuwanuwatugai? Ena kowa Keliso, meta ku hededehemasalaha.” ");
INSERT INTO sbe_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ye hededebui ye wane, “Ya hededelaowako kalimiuwai, na nige kwa kawamamohoi. Na saha ya ginaginaulidi tamagu hesanawai, siya se hemasalahagau. ");
INSERT INTO sbe_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Na komiu nige kwa kawamamohoiyeigau, matawuwuna ede komiu nige yau yogu mamoe. ");
INSERT INTO sbe_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yau yogu mamoe se lapulau kalinagu unai, yo kabidiyao ya kata, yo hinage se hemuliwatanigau. ");
INSERT INTO sbe_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yau mauli nige kana siga ya moseidi, unai taba nige se lau yababa unai na se boita, yo tamowai hesau nige gonowana nimagu ta unai se haigabaedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamagu meta mamoe ne tauledima ede, iya ye saekalili na kabo tamowai yo ginauli maudoidi. Unai Tamagu nimanawai nige gonowana se haigabaedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tamagu maidagu kai meta kesega.” ");
INSERT INTO sbe_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na Dius tauwoyaidi wa weku se haidi bena Yesu se lauwekui. ");
INSERT INTO sbe_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na Yesu ye hededelau udiyedi ye wane, “Yau Tamagu yona kabikabi namwanamwadi gwaudi ya hemasalahadiko kalimiuwai. Na kabikabi sahasahana debanawai bena kwa lauwekuigau ta?” ");
INSERT INTO sbe_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dius tauwoyaidi wa se hededebui se wane, “Kai nige bena ginauli namwanamwadi ku ginaulidi ne debadiwai ka lauwekuigo, na matawuwuna ede Yaubada ku hededeheyaheyababa. Kowa tamowaimolosi na ku hedede meta kowa Yaubada.” ");
INSERT INTO sbe_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu ye hededebui ye wane, “Na yomi kulikuli tabuna unai Yaubada ye hedede ye wane, ‘Komiu yaubada.’ ");
INSERT INTO sbe_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kulikuli tabuna nige ye lupo, na kulikuli ne unai ta hasili meta Yaubada yona hedehedede tauhaidi ne ye kataidi siya yaubada. ");
INSERT INTO sbe_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na yau ya hedede ya wane, yau Yaubada Natuna. Na matawuwuna saha to kwa hegilugau meta Yaubada ya hededeheyaheyababa? Tamagu ye kaisunuwaigau yogu paisowa ta hesabana na ye hetamaligau ya laoma tanoubu ta unai. ");
INSERT INTO sbe_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ena yau nige Tamagu yona paisowa ya ginaulidi, tabu kwa kawamamohoiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na ena Tamagu yona paisowa ya ginaulidi, na iyamo nige kwa kawamamohoiyeigau, takiyede saha ya ginaginaulidi ne udiyedi kwa kawamamohoi. Teina unai kabo kabina kwa kata yo kwa nuwatulobai meta Tamagu iya ede kaliguwai yo yau ede Tamagu kalinawai.” ");
INSERT INTO sbe_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ede se kaipateꞌuyo bena se kabihekahini, na ye wasabugabaedi. ");
INSERT INTO sbe_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na kabo Yesu ye lau Yolidani sagasagana ye kawasi ye lau teha hesauna ne unai, iya ede lahinaidi Yowane yona kabahebahebabatiso bagubagunana wa, na temenai ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na tamowai gwaudi se laoma iya unai. Na se bom yodi se hedehedede se wane, “Yowane nige laulau gigigigibwalidi ye ginaulidi, na teina tamowai ta hedehededena maudoidi Yowane ye hededehemasalahadi wa meta mamohoidi.” ");
INSERT INTO sbe_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ede tenem teha ne unai tamowai gwaudi Yesu se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betaniya tamowaina hesau hesana Lasalo ye kasiyebwa. Betaniya meta Maliya ma kana kaha Maleta yodi magai. ");
INSERT INTO sbe_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliya ta iya ede yausi panepanena tauꞌinina Guiyau unai, na kuluna unai kaena ne ye saudi wa. Na iya louna Lasalo ye kasiyebwa. ");
INSERT INTO sbe_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kabo Maliya ma kana kaha kalina se hetamali ye lau Yesu unai se wane, “Guiyau, tamowai ku gadosisiꞌusei wa ye kasiyebwa.” ");
INSERT INTO sbe_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Huyana Yesu wasa wa ye lapui ede ye wane, “Teina kasiyebwa ta taba nige ye lau ee boita, na Yaubada kabo kana kao saesaena mamohoina ye hemasalaha, na bena unai Yaubada Natuna kana kao saesaena mamohoina hinage ye hemasalaha.” ");
INSERT INTO sbe_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu iya Maleta ma kana kaha Maliya yo loudi Lasalo ye gadosisiyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iyamo huyana wasa ye lapui meta Lasalo ye kasiyebwa kabo sola mayadai labui ye miyaꞌuyo yona kabamiya wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na kabo Yesu ye hededelau yona hekahekatao wa udiyedi ye wane, “Kwa laoma ta uyo Yudeya.” ");
INSERT INTO sbe_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yona hekahekatao wa se wane, “Labi, lahinaidi Dius tauwoyaidi bena se lauwekuigo. Idohagi na bena ta uyo temenai?” ");
INSERT INTO sbe_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ye hededebui ye wane, “Mayadai kesega kesega unai mala yona sina meta mahana saudoudoi-labui. Ena tamowai hesau mayadai unai ye laulau, taba nige ye kalabesibesi, matawuwuna ede tanoubu ta dawayana wa unai ye laulau. ");
INSERT INTO sbe_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Na ena tamowai hesau boniyai unai ye laulau kabo ye kalabesibesi, matawuwuna ede dawaya wa nige kalinawai.” ");
INSERT INTO sbe_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Teina hedehedede ta mulinawai Yesu ye wane, “Kada kaha Lasalo ede ye kenokeno, na yau ya lau kabo ya hanoi.” ");
INSERT INTO sbe_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yona hekahekatao wa se hededelau unai se wane, “Guiyau, ena ye keno, kabo ye namwanamwaꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu yona hedehedede ne kaniyona ede, meta Lasalo ye boitako, na yona hekahekatao yodi nuwatu meta Yesu ye wane, iya ye kenokeno. ");
INSERT INTO sbe_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ede Yesu ye hededehedudulai ye wane, “Lasalo meta ye boitako. ");
INSERT INTO sbe_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na komiu debamiuwai meta ya gwauyala. Ye namwakalili ede yau nige temenai. Unai kabo kwa kawamamohoi. Na kwa laoma ta lau.” ");
INSERT INTO sbe_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ede Tomasi (hesana hesau Didimasi, kaniyona ede godegode) ye hededelau yona hali hekahekatao wa udiyedi ye wane, “Kwa laoma ta lau, kabo iya maiyada ta boita.” ");
INSERT INTO sbe_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na huyana Yesu ye lage ede wasa ye lapui meta Lasalo se toleyako bwayabwaya unai, na mayadai hasi se laoko. ");
INSERT INTO sbe_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya meta Yelusalema dedekanawai, na kedana lohana meta doha maela labui. ");
INSERT INTO sbe_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na Dius tamowaidiyao gwaudi Yelusalema unai se laoma Maleta yo Maliya udiyedi bena loudi yona boita nuwayababana wa unai nuwadiyao se hededehetaludi. ");
INSERT INTO sbe_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Huyana Maleta wasa ye lapui meta Yesu ye laoma, ede numa wa ye pesagabaei na ye lau ye hailobai, na Maliya ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maleta ye hededelau Yesu unai ye wane, “Guiyau, taba kowa bena inai, lougu ta taba nige ye boita. ");
INSERT INTO sbe_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na kabina ya kata meta saha ku kaibwadai Yaubada unai, kabo ye leyawa.” ");
INSERT INTO sbe_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ye wane, “Loum ne kabo boita unai ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ye wane, “Kabina ya kata ede huya mulimulitana unai boita toloꞌuyona unai kabo ye toloꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kabo Yesu ye hededelau unai ye wane, “Yau toloꞌuyona yo maulina ede. Kaiteya ye sunuma kaliguwai, kabo boita unai ye toloꞌuyo na ye mauli. ");
INSERT INTO sbe_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na kaiteya ye maumauli na ye sunuma kaliguwai, taba nige boita helabuina ye hekalo, na mauli nige kana siga kabo ye hai. Yogu hedehedede ta ku kawamamohoiyei?” ");
INSERT INTO sbe_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ede Maleta ye hededebui ye wane, “Aa! Guiyau, yom hedehedede ne ya kawamamohoiyei. Yo hinage ya kawamamohoi meta kowa Keliso, Yaubada Natuna, iya ede ye dobima tanoubu ta unai.” ");
INSERT INTO sbe_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na teina hedehedede ta mulinawai ede ye uyo numa na kana kaha Maliya ye yogahesuwala na ye wane, “Taulauhekata wa, iya ede teinai na ye henuwa bena ye kitago.” ");
INSERT INTO sbe_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliya hedehedede ta ye lapui ede ye tolomwayamwayau ye lau Yesu unai. ");
INSERT INTO sbe_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Yesu sola nige ye lagelau kasa wa unai, iya meta Maleta yona kabahailobaina wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dius tamowaidiyao se laoma bena Maliya ma kana kaha nuwadiyao se hededehetaludi wa, meta siya Maliya maiyadi numa wa unai. Na huyana Maliya se kita ye tolomwayamwayau ye pesa ye lau, ede se hemuliwatani. Yodi nuwatu bena kabo ye lau bwayabwaya wa unai ye doudou. ");
INSERT INTO sbe_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Huyana Maliya ye lage Yesu unai na ye kita, ede matana wa unai ye tulibonodobi na ye wane, “Guiyau, taba kowa teinai, lougu ta nige gonowana ye boita.” ");
INSERT INTO sbe_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na Maliya yo tauhemuliwatanina wa Yesu ye kitadi se doudou, meta nuwana ye kamkamnakalili, ");
INSERT INTO sbe_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","na ye henamaiyeidi ye wane, “Haedi iya kwa hekeno?” Se hededebui se wane, “Ku laoma ta lau na kabo ka hekitago.” ");
INSERT INTO sbe_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kabo Yesu ye dou. ");
INSERT INTO sbe_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ede Dius tamowaidiyao wa se wane, “Kwa kita ne, iya ye gadosisikaliliyei.” ");
INSERT INTO sbe_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na hekadi se bom se hedehedede se wane, “Na teina tamowai ta taumatagibugibu wa matana ye helala. Na idohagi to nige saha hesau ye ginauli kabo unai Lasalo taba nige ye boita?” ");
INSERT INTO sbe_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu sola ma nuwakamkamnana na ye laoma ye lage bwayabwaya wa unai. Bwayabwaya wa meta weku duhana, na weku lakilakina hesau unai kawamatana wa se buigudui. ");
INSERT INTO sbe_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ye wane, “Buigudu wekuna ne kwa hesigihesuwala.” Na Maleta, iya tauboita wa louna, ye wane, “Guiyau, lougu ye boitako na mayadai hasi se laoko, debanawai kabo panena ye yababa.” ");
INSERT INTO sbe_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na Yesu ye hededelau unai ye wane, “Idohagi, nige ku lapui meta ya hededeyako kalimwai, ena taba ku sunuma, Yaubada kana kao saesaena mamohoina kabo ku kita.” ");
INSERT INTO sbe_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ede weku wa se buihesuwala, na Yesu ye kaikewasae galewa ne na ye wane, “Tamagu, ya lautokiyeigo, matawuwuna ede kowa ku lapulapulaoma kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kabina ya kata meta kowa huya maudoina ku lapulapulaoma kaliguwai, na teina ya hededehelaki ta tautolohetakikiligau ta hesabadi, unai kabo se kawamamohoi meta kowa tauhetamaligau ede.” ");
INSERT INTO sbe_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Teina hedehedede ta mulinawai Yesu kalinalakilakina unai ye yoga ye wane, “Lasalo, ku pesama!” ");
INSERT INTO sbe_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ede tamowai boiboitana wa ye pesama, nimana yo kaena meta kaleko tupwadiyao lohalohadi udiyedi se sumadi yo kuluna hinage kaleko hesau unai se suma. Yesu ye hededelau tamowai wa udiyedi ye wane, “Tauna sumadi ne kwa yailihaidi na ye laulau.” ");
INSERT INTO sbe_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dius tamowaidiyao Maliya maiyadi taulau wa Yesu yona kabikabi wa se kita ede gwaudi iya se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Na hekadi se lau Paliseya tamowaidiyao udiyedi, na Yesu saha ye ginauli wa wasana yodi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ede taukaitalasam tauwoyaidi yo Paliseya tamowaidi Sunedeli koigogona se heyoga. Se laomagogoi na se henahenamaiꞌuyoidi se wane, “Teina tamowai ta meta laulau gigigigibwalidi gwaudi ye ginaulidi. Na saha kabo ta ginauli? ");
INSERT INTO sbe_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ena taba ta kitagabaei doha teina meta tamowai maudoidi kabo iya se sunumaei. Unai kabo Loma tamowaidi yoda Numa Tabuna yo yoda basileiya ta se heyababa.” ");
INSERT INTO sbe_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na luwadi wa unai hesau hesana ede Kaiyapasi, iya tenem bolimai ne unai meta taukaitalasam saesaena, na ye wane, “Komiu nige saha hesau kabina kwa kata. ");
INSERT INTO sbe_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na nuwamiu ne nige se masalaha. Ye namwakalili taba tamowai kesega ye boita tamowai maudoidi hesabadi, na kabotaki basileiya maudoina ta se heyababa.” ");
INSERT INTO sbe_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiyapasi tenem nuwatu ne nige ye hededegaibui, na tenem bolimai ne unai meta iya taukaitalasam saesaena, unai ede ye hededepeloweta meta Yesu kabo ye boita Dius tamowaidiyao hesabadi. ");
INSERT INTO sbe_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na nige bena Dius se bom hesabadi, na Yaubada natunao se tatagwaligwali teha udoiꞌudoi udiyedi wa hinage hesabadi. Teina unai kabo Yaubada natunao maudoidi se hemala boda kesega. ");
INSERT INTO sbe_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ede tenem mayadai ne unai ye lau meta yodi hineli se ginauli taba idohagi na Yesu kabo se koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Unai Yesu nige ye taumasalahalauꞌuyo Dius tamowaidiyao udiyedi, na ye dalahai ye lau teha hesau balabalana dedekanawai, na menai magai gagilina hesau hesana Epelaima unai maiyanao hekahekatao wa se miya. ");
INSERT INTO sbe_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na Taukiuli Henuwaisinina huyana ye hanahanauma, ede Dius tamowaidi gwaudi teha udoiꞌudoi udiyedi taumiya se sae Yelusalema bena yodi lauheꞌaꞌa kabikabidi se ginaulibagunaidi, na kabo Taukiuli Henuwaisinina. ");
INSERT INTO sbe_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na Yesu se wasewasenei, na Numa Tabuna bakubakuna unai se totolo na se henahenamaiꞌuyoidi se wane, “Kwa nuwatui meta kabo ye laoma gwauyala ta unai, o nige?” ");
INSERT INTO sbe_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na taukaitalasam tauwoyaidi yo Paliseya tamowaidi meta hedehedede se toleyako tamowai maudoidi udiyedi, ena taba hesau Yesu ye kita, kabo ye laoma tauwoyawoya ne ye hekatadi, na kabo Yesu se kabihekahini. ");
INSERT INTO sbe_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mayadai haligigi-kesega mo matadi ne unai na kabo Taukiuli Henuwaisinina huyana, na Yesu ye lagelau Betaniya, teina meta Lasalo boita unai ye hetoloꞌuyoi wa yona magai. ");
INSERT INTO sbe_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ede temenai kaikaigogo gagilina se ginauli Yesu hesabana. Maleta meta kadi haitala wa ye kabinonohai, na Lasalo maiyanao Yesu ma kana bodao wa se kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na Maliya yausi panepanena pakuna ye hai ede ye ini Yesu kaena ne udiyedi na kuluna ne unai ye sauhepitalidi, na panena meta numa wa ye laugilihai. Na yausi ne nadi unai se ginauli, lakina ede lita kesega tehana, na maisana ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na Yudasi Isakaliyota, iya Yesu yona hekahekata wa hesau na iya kabo kana tauwalohai, iya ye wane, ");
INSERT INTO sbe_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Idohagi to teina yausi panena namwanamwana ta nige ku lokunei? Kabo maisana denali 300 ku hai, na monina ne kabo ye lau taudehadeha udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasi saha ye hedede ta meta nige taudehadeha ye nuwatukaliliyeidi, na matawuwuna ede iya taukabikabigaibu. Iya meta yodi moni tobwana taukitahetetena, na yona laulau ede moni tobwana ne unai hekadi ye haihaigaibuidi. ");
INSERT INTO sbe_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu ye hededebui ye wane, “Waihiu ne ku kitagabaei! Saha ye ginauli ne meta yau kabo se tolegau bwayabwaya ne unai kabinonohana. ");
INSERT INTO sbe_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Huya badobado taudehadeha kabo maiyamiyao, na yau meta taba nige huya badobado maiyamiu.” ");
INSERT INTO sbe_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na Dius tamowaidiyao bodalakilaki wasa se lapui meta Yesu iya ede Betaniya unai. Ede se lau temenai bena Yesu se kita, na nige Yesu ye bom mo, na Lasalo hinage, iya ede ye boita na Yesu ye hetoloꞌuyoiꞌusei wa. ");
INSERT INTO sbe_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Unai ede taukaitalasam tauwoyaidi wa yodi hineli se ginauli meta bena kabo Lasalo hinage se koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Matawuwuna Lasalo yona toloꞌuyo ne debanawai, Dius bodalakilaki yodi tauwoyawoya wa se laugabaedi na se lau Yesu se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mayadai hesauna kabo Yesu ye lau Yelusalema. Tenem mayadaidi ne udiyedi bodalakilaki teha maudoidi udiyedi se laoma Yelusalema Taukiuli Henuwaisinina hesabana. Boda wa Yesu wasana se lapui meta ye laolaoma ");
INSERT INTO sbe_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ede tutube bagadi se baheidi na se lau se hailobai yo se heyoheyoga se wane, “Hosana!” “Ka hedebasaego, kowa Guiyau hesanawai ku laoma.” “Ka hedebasaego, kowa Isalaela yoma wasawasa.” ");
INSERT INTO sbe_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu donki saehauna ye lobai ede ye gelusae unai, doha peloweta hesau ye kuliyako ye wane, ");
INSERT INTO sbe_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saiyona tamowaidi, tabu kwa matausi! Kwa kitalau! Yomi wasawasa wa donki saehauna unai ye tutuli na ye laolaoma.” ");
INSERT INTO sbe_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na tenem huyana ne unai hekahekatao wa nige se nuwatulobai meta kulikuli ta Yesu hedehededena. Na muliyena, huyana Yesu ye toloꞌuyo yo ye sae galewa ne unai na yona hekahekatao wa kana kao saesaena mamohoina se kita, kabo se nuwatulobai meta kabikabi maudoidi ta siya ede hedehedede maudoidi kulikuli tabudi udiyedi se kulinonohaidiko wa. ");
INSERT INTO sbe_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na huyana Yesu Lasalo ye yogahepesa bwayabwaya unai yo boita unai ye hetoloꞌuyoi wa meta bodalakilaki maiyanao. Na saha ye ginauli wa se kita meta sola se hewahewasa. ");
INSERT INTO sbe_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na tamowai gwaudi laulau gigigigibwalina ye ginauli wa wasana se lapui, ede se lau Yesu se hailobai. ");
INSERT INTO sbe_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na Paliseya tamowaidi se bom yodi se hedehedede se wane, “Sola kwa kita! Nige gonowana saha hesau kabo ta ginauli kalinawai. Kaniyona ede tanoubu maudoina iya se hemuhemuliwatani.” ");
INSERT INTO sbe_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na tausae Yelusalema Taukiuli Henuwaisinina unai tautabaꞌohu wa luwadi ne unai meta Giliki tamowaidi hekadi. ");
INSERT INTO sbe_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na se lau Pilipo unai, iya meta magai Betesaida teha Galili ne tamowaina, na se hededelau unai se wane, “Taubada, ka henuwa bena Yesu ka kita.” ");
INSERT INTO sbe_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ede Pilipo ye lau Andeleya yona ye hedehedede, na kabo taudi labui se lau Yesu yona se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na Yesu ye hededebui ye wane, “Mahanana wa ye lageko, Tau Natuna kabo kana kao saesaena mamohoina ye masalaha. ");
INSERT INTO sbe_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya hededemamohoi kalimiuwai: Ena witi tumana nige ye beku bwatano ne unai na ye mwaloi, kabo ye miyamiya mo. Na ena ye bekudobi na ye mwaloi, meta kabo kaniyona gwaudi ye hetubudi. ");
INSERT INTO sbe_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na kaiteya yona mauli tanoubu ta unai ye gadosisiyei, kabo ye kabisapuli. Na kaiteya yona mauli tanoubu ta unai ye nuwagabaei, kabo mauli nige kana siga ye hai. ");
INSERT INTO sbe_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ena tamowai hesau ye henuwa bena yogu ye paisowa, meta bena ye hemuliwatanigau. Yau haedi ya miya meta yogu heyayai tauhaina hinage kabo temenai. Na yogu heyayai tauhaina ne meta kabo Tamagu iya ye hekasisiyei. ");
INSERT INTO sbe_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mahana ta unai yau meta nuwagu ta unai ya hekohekoidada, na kabo saha ya hedede? Taba gonowana ya kaibwada Tamagu unai ya wane, ‘Mahana ta unai ku gilihaigau’? Taba nige! Ya dobima ta meta bena kamkamna matagu ne unai ya hekalo.” ");
INSERT INTO sbe_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na kabo ye wane, “Tamagu, hesam ku hesaekaliliyei.” Kabo kalina hesau galewa ne unai ye dobima ye wane, “Yau hesagu ya hesaeyako na kabo ya hesaeꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na bodalakilaki temenai se totolo wa kalina ta se lapui ede yodi nuwatu bena tulutululu. Na hekadi se wane, “Nuwana anelu hesau ye hedehededelau Yesu unai.” ");
INSERT INTO sbe_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na Yesu ye hededebui ye wane, “Tenem kalina ne meta komiu hesabamiu, yau nige. ");
INSERT INTO sbe_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na teina mahana ta unai Yaubada kabo tanoubu ta ye hekasa, yo tanoubu ta yodi wasawasa yona gigibwali kabo ye hetatagwaligwali. ");
INSERT INTO sbe_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na huyana se lausinigau, kabo tamowai maudoidi ya yogagogoidi se laoma kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu ye hedede doha teina meta bena yona boita kana kao ye hededehemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ede boda wa se henamaiyei se wane, “Kai laugagayo unai ka lapui meta Keliso kabo ye miya ye lau ee huya nige kana siga. Na idohagi to ku wane, ‘Tau Natuna kabo se lausini’? Na teina Tau Natuna ta meta kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na kabo Yesu ye hededelau udiyedi ye wane, “Mala ta kabo maidamiu kwa miya huyakubwakubwa mo. Na mala maidamiu ta unai ne bena kwa laulau, na tabu masigili ye taukasinigomiu. Na kaiteya masigili unai ye laulau meta nige kabina ye kata haedi ye laulau. ");
INSERT INTO sbe_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na mala maidamiu ta unai ne bena kwa sunumaei, ede kabo kwa hemala mala natunao.” Teina hedehedede ta mulinawai ye laugabaeidi na ye lau ye kenowadamyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu laulau gigigigibwalidi gwaudi ye ginaulidi Dius tamowaidiyao matadiwai, na iyamo nige se kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Teina ta meta Aisaiya peloweta yona hedehedede wa ye hemamohoiyei, doha ye wane, “Guiyau, yoda wasa wa kaiteya ye kawamamohoiyei? Na kaiteya unai Yaubada yona gigibwali ye hemasalaha?” ");
INSERT INTO sbe_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na Dius tamowaidiyao wa nige gonowana se kawamamohoi, matawuwuna ede teha hesau unai peloweta Aisaiya wa ye hedede ye wane, ");
INSERT INTO sbe_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Guiyau tamowai matadiyao ye hegibugibudi, yo nuwadiyao ye hekwailolodi, unai taba nige matadi udiyedi se kita, yo taba nige nuwadi udiyedi se nuwatulobai, yo taba nige nuwadi se buidi na unai kabo ya henamwanamwadi.” ");
INSERT INTO sbe_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya teina ye kulihemasalaha, matawuwuna Yesu kana kao saesaena mamohoina ye kita, na Yesu hedehededena ye hedehededei. ");
INSERT INTO sbe_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na iyamo tamowai gwaudi Yesu se sunumaei, luwadi ne unai hekadi meta Dius tauwoyaidi. Iyamo Paliseya tamowaidi debadiwai ede yodi sunuma wa nige se hemasalaha, kaniyona ede se matausi madai sunago unai se hepesadi. ");
INSERT INTO sbe_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Matawuwuna se henuwakalili taba tamowai se hededetausaeidi, na Yaubada yona kitahenamwadi ne nige se nuwatukaliliyei. ");
INSERT INTO sbe_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na kabo Yesu kalinana lakilakina unai ye wane, “Kaiteya ye sunumaeigau, meta nige yau ya bom mo ye sunumaeigau, na hinage tauhetamaligau wa ye sunumaei. ");
INSERT INTO sbe_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yo kaiteya ye kitagau, meta tauhetamaligau wa ye kita. ");
INSERT INTO sbe_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yau ya dobima tanoubu ta yona mala, unai kaiteyadi se sunumaeigau taba nige masigili unai se miya. ");
INSERT INTO sbe_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na ena tamowai hesau yogu hedehedede ta ye lapuidi na nige ye miyawatanidi, taba nige yau yona ya hekasa. Matawuwuna yau ya dobima ta nige bena tanoubu ta ya kitahekasa, na bena ya hemauli. ");
INSERT INTO sbe_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tausubugau yo yogu hedehedede nige taukabihekahinidi, tauhekasadi nonohana ede ye miya. Hedehedede ya hededediko wa, siya kabo kabahegiludi huyagehena ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Matawuwuna yau nige ya bom yogu nuwatu unai ya hedehedede, na Tamagu iya tauhetamaligau wa ye hekatagau saha kabo ya hedede yo idohagi kabo ya hedededi. ");
INSERT INTO sbe_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na kabina ya kata meta yona hedehedede ne kabo mauli nige kana siga ye leyama. Unai teina saha ya hedededi ta meta gonogonowana doha saha Tamagu ye hedededi kaliguwai wa bena kabo ya hededehemasalahadi.” ");
INSERT INTO sbe_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mayadai kesega mo na kabo Taukiuli Henuwaisinina mayadaina, na Yesu kabina ye kata meta yona huya ye lagemako kabo tanoubu ta ye laugabaei na ye seuyo Tamana unai. Yesu yona hekahekatao siya tanoubu ta unai, meta huya maudoina ye gadosisiyeidi, na tenem huyana ne unai meta yona gadosisi lakilakikalilina ye hekitadi. ");
INSERT INTO sbe_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Meimeilahi kaina se kabinonohaiyako, na diyabolo yona nuwatu meta ye toleyako Yudasi Isakaliyota, Simona natuna unai, iya kabo Yesu kana ye walohai. ");
INSERT INTO sbe_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na Yesu kabina ye kata meta ginauli maudoidi Tamana ye tolediko iya yona gigibwali unai, yo iya Yaubada unai ye laoma na kabo ye seuyo Yaubada unai. ");
INSERT INTO sbe_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ede kabakaikai hatahatana wa ye tologabaei, na yona likwakewa kwamana ye haigabaei, na sauwela ye hai ede duwaduwalina wa unai ye pai. ");
INSERT INTO sbe_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na kabo waila ye ini disi hesau unai, na ye hetubu yona hekahekatao wa kaediyao ye deulidi, na duwaduwalina unai sauwela ye pai wa unai ye saudi. ");
INSERT INTO sbe_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Huyana ye laoma Simona Petelo unai, ede Petelo ye hededelau unai ye wane, “Guiyau, kabo kaegu ta hinage ku deulidi?” ");
INSERT INTO sbe_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ye hededebui ye wane, “Saha ya ginaginauli ta sola nige ku nuwatulobai, na mulinawai kabo ku nuwatulobai.” ");
INSERT INTO sbe_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petelo ye wane, “Tabu kaegu ta ku deudeulidi!” Yesu ye hededebui ye wane, “Na ena taba kaem ne nige ya deulidi, meta kowa nige gonowana yogu tamowai.” ");
INSERT INTO sbe_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kabo Simona Petelo ye wane, “Guiyau, besi, nige kaegu ta se bom, na nimagu yo kulugu hinage ku deulidi.” ");
INSERT INTO sbe_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ye hededebui ye wane, “Kaiteya ye duiko meta tauna maudoina ne se aꞌako, unai taba nige ye duiꞌuyo, na kaena se bom mo taba ye deulidi. Komiu maudoimiu ne kwa aꞌako, na kesega mo meta nigele.” ");
INSERT INTO sbe_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kabina ye kata meta kaiteya kabo kana ye walohai, ede ye hedede ye wane, “Komiu maudoimiu ne kwa aꞌako, na kesega mo meta nigele.” ");
INSERT INTO sbe_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu kaediyao wa ye deulidi ye gehe, ede yona kwama wa ye luwuiꞌuyoi na ye uyo yona kabakaikai wa unai, na ye henamaiyeidi ye wane, “Saha ya ginauli ta kwa nuwatulobai e nige? ");
INSERT INTO sbe_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Komiu hesagu kwa katai Taulauhekata yo Guiyau. Meta ye dudulaikalili. Temeta kagu kao ede. ");
INSERT INTO sbe_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na ena yau, yomi Guiyau yo Taulauhekata, kaemiyao ta ya deulidi, bena komiu hinage kami kahao kaedi kwa deulidi yo siya hinage kaemiu se deulidi. ");
INSERT INTO sbe_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Saha ya ginauli ta meta yomi kabakitahai. Unai saha ya ginauli kalimiuwai ta, hinage bena kwa ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya hededemamohoi kalimiuwai: Heyayai tauhaina nige ye saekalili na kabo kana tanuwaga. Yo wasa taulaena nige ye saekalili na kabo tauhetamalina. ");
INSERT INTO sbe_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na komiu teina nuwatu ta kabidi kwa katako, na ena kwa ginaulidi, meta kabo gonowana kwa gwauyala. ");
INSERT INTO sbe_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yau nige komiu maudoimiu ta ya hetahetalagomiu. Kaiteyadi ya kaisunuwaidi meta kabimiu ya kata. Na teina ta meta bena kulikuli tabuna ye hemamohoiyei, doha ye wane, ‘Na kaiteya maiyagu pwalawa kesega ka kai, meta kabo ye hemala kagu waiunu.’ ");
INSERT INTO sbe_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Teina ta ya hededenonohaidi, na kabo se tubu. Na huyana se tubu, unai kabo kwa kawamamohoi meta Yau ede Iya. ");
INSERT INTO sbe_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya hededemamohoi kalimiuwai: Ena tamowai hesau ya hetamali na se yogaisini meta yau se yogaisinigau. Yo kaiteya ye yogaisinigau meta iya tauhetamaligau wa ye yogaisini.” ");
INSERT INTO sbe_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu teina ye hedede na mulinawai nuwana ye pilipili, ede ye hedede ye wane, “Ya hededemamohoi kalimiuwai: Luwamiu ta unai hesau kabo kagu ye walohai.” ");
INSERT INTO sbe_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yona hekahekatao wa se haibaibaiwaꞌuyoidi yo nuwadi se dagugu teina meta kaiteya hedehededena. ");
INSERT INTO sbe_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu yona hekahekata hesau iya ye gadosisikaliliyei wa meta dedekanawai ye kenokeno. ");
INSERT INTO sbe_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ede Simona Petelo nimana unai hekahekata wa ye sikwatagu na ye hededelau unai ye wane, “Ku henamaiyei, kaiteya hedehededena.” ");
INSERT INTO sbe_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kabo ye duihasalilau Yesu unai na ye henamaiyei ye wane, “Guiyau, kabo kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu ye hededebui ye wane, “Teina pwalawa ta kabo ya hedakwa disi ne unai na ya mosei tamowai hesau unai meta iya tamowaina ede.” Na kabo pwalawa tehana wa ye hedakwa na ye mosei Yudasi Isakaliyota unai, iya Simona natuna. ");
INSERT INTO sbe_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Huyana Yudasi pwalawa wa ye hai meta Satani ye luwu kalinawai. Ede Yesu ye hededelau unai ye wane, “Saha bena ku ginauli ne ku ginaulimwamwayauyei.” ");
INSERT INTO sbe_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Taututuli yodi kabakaikai wa unai nige hesau kabina ye kata idohagi to Yesu doha tenem ye hedede kalinawai. ");
INSERT INTO sbe_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na hekadi yodi nuwatu bena Yesu yona hedehedede ta kaniyona ede, “Ku lau na saha gwauyala ta unai ta henuwadi kabo ku hemaisadi.” Na hekadi yodi nuwatu bena ye lau taudehadeha yodi ye kainauya. Matawuwuna Yudasi meta iya yodi moni tobwana taukitahetetena ede. ");
INSERT INTO sbe_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi pwalawa wa ye kai na mulinawai ede ye pesa ye lau. Na tenem mahanana ne meta ye tauhemasigiliyako. ");
INSERT INTO sbe_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi ye laoko, na Yesu ye wane, “Yaubada Tau Natuna kana kao saesaena mamohoina bena ye hemasalaha, yo saha kabo ye tubu Tau Natuna kalinawai ne, meta unai kabo Yaubada kana kao saesaena mamohoina ye hemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Natuna Yaubada kana kao saesaena mamohoina ye hemasalahahegehe, kabo Yaubada yona kabikabi unai hinage Natuna kana kao saesaena mamohoina ye hemasalaha, na taba nige ye pahili. ");
INSERT INTO sbe_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natuguwao, huyakubwakubwa mo yau maiyamiu kabo ta miya. Na komiu kabo kwa wasewaseneigau. Na Dius tauwoyaidi meta yodi ya hedehededeko, na komiu hinage teina yomiu ya hedehedede: Yau yogu kabalau ne meta komiu taba nige gonowana unai kwa lau. ");
INSERT INTO sbe_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Teina ta laugagayo hauhauna ya leyawa: Bena kwa haigadogadosisiꞌuyoigomiu, doha yau ya gadosisiyeigomiu ne. Unai komiu bena kwa haigadogadosisiꞌuyoigomiu. ");
INSERT INTO sbe_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ena komiu kwa haigadogadosisiꞌuyoigomiu, kabo tamowai maudoidi kabina se kata meta komiu yau yogu hekahekatao.” ");
INSERT INTO sbe_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petelo Yesu ye henamaiyei ye wane, “Guiyau, kowa kabo haedi ku lau?” Yesu ye hededebui ye wane, “Yogu kabalau ne meta teina mahana ta unai nige gonowana ku hemuliwatanigau, na muliwai kabo ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petelo ye henamaiyei ye wane, “Guiyau, idohagi to teina mahana ta unai taba nige gonowana ya hemuliwatanigo? Yau meta ya nonohako kabo ya boita kowa hesabam.” ");
INSERT INTO sbe_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na kabo Yesu ye hededebui ye wane, “Mamohoi, kabo ku boita yau hesabagu? Ya hededemamohoi kalimwai: Teina boniyai ta unai pwaole hakiyana sola nige ye dou, na kabo ku uhalaeigau ma haiyona.” ");
INSERT INTO sbe_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Tabu kwa nuwadubu, Yaubada kwa sunumaei yo yau hinage kwa sunumaeigau. ");
INSERT INTO sbe_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tamagu yona numa unai meta dahala gwaudi. Ena taba teina ta nige mamohoi, meta nige gonowana ya hedede bena ya lau temenai kabo yomi dahala ya kabinonohaidi. ");
INSERT INTO sbe_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ena ya lau yomi dahala ya kabinonohaidi, kabo hinage ya uyoma ya haigomiu, na yau haedi yogu kabamiya meta komiu hinage kabo temenai. ");
INSERT INTO sbe_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yo idohagi kabo kwa lau magaina ne unai meta kedana kabina kwa katako.” ");
INSERT INTO sbe_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi ye hededelau Yesu unai ye wane, “Guiyau, yom kabalau ne nige kabina ka kata. Idohagi kabo kedana kabina ka kata?” ");
INSERT INTO sbe_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ye hededebui ye wane, “Yau kedana ede, yo yau mamohoina ede, yo yau maulina ede. Nige gonowana hesau ye bom ye lau Tamagu unai, na yau ya bom mo kedana ede. ");
INSERT INTO sbe_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ena taba mamohoi komiu kabigu kwa kata, komiu hinage tamagu kabo kabina kwa kata. Teina mayadai ta unai ye lau ne meta iya kabina kwa kata yo hinage kwa kitayako.” ");
INSERT INTO sbe_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo ye wane, “Guiyau, taba tamam ku hekitagai, na kabo takiyede.” ");
INSERT INTO sbe_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ye hededebui ye wane, “Pilipo, huyalohaloha yau maiyamiu ta miyamiya. Na idohagi to nige kabigu ku kata? Kaiteya ye kitagau meta Tamagu ye kita. Na idohagi to ku wane, ‘Taba tamam ku hekitagai’? ");
INSERT INTO sbe_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kana kao doha nige ku kawamamohoi meta yau ede Tamagu unai, yo Tamagu ede yau kaliguwai. Hedehedede maudoidi ya hedehedededi ne meta nige yau ya bom yogu hedehedede, na Tamagu kaliguwai ye miya ta meta iya yona paisowa ne tauginaulidi ede. ");
INSERT INTO sbe_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bena kwa kawamamohoi meta yau ede Tamagu unai, yo Tamagu ede yau kaliguwai. Ena nige gonowana yogu hedehedede ta kwa kawamamohoiyeidi, takiyede, na laulau gigigigibwalidi ya ginaulidiko wa debadiwai kwa kawamamohoiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya hededemamohoi kalimiuwai: Kaiteya ye sunuma kaliguwai kabo saha ya ginaulidiko wa hinage ye ginaulidi. Yo kabikabi hekadi ye ginaulidi kabo se saekalili na kabo saha yau ya ginaulidi wa. Matawuwuna ede yau meta ya laulau Tamagu unai. ");
INSERT INTO sbe_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na saha kwa kaibwadaidi yau hesaguwai, kabo ya ginaulidi. Tenem unai kabo Tamagu hedebasaena ya helaki. ");
INSERT INTO sbe_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mamohoi, yau hesaguwai ginauli saha kwa kaibwadaidi, kabo ya ginaulidi.” ");
INSERT INTO sbe_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ena kwa gadosisiyeigau, bena yogu laugagayo kwa kawakabiyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na yau kabo Tamagu ya kaibwadai na kami sagu hesau ye hetamaliyawa, na iya kabo maiyamiu ye lau ee huya nige kana siga. ");
INSERT INTO sbe_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iya ede hedehedede mamohoina Yaluwana. Tanoubu ta tamowaidiyao nige gonowana iya se hai, matawuwuna ede nige se kita yo nige kabina se kata. Na komiu iya kabina kwa kata, matawuwuna ede iya maiyamiu na huya matada ne unai kabo nuwamiu ne unai ye miya. ");
INSERT INTO sbe_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yau taba nige ya laugabaegomiu doha dabudabule, na kabo ya uyoma kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Huyakubwakubwa mo na mulinawai tanoubu ta kabo taba nige se kitagau, na komiu kabo kwa kitagau. Yau ya mauli, unai komiu hinage kabo kwa mauli. ");
INSERT INTO sbe_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tenem mayadaina ne unai komiu kabo kwa nuwatulobai meta yau ede Tamagu unai, yo komiu ede yau kaliguwai, yo yau ede komiu kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kaiteya yogu laugagayo ye hai yo ye kawakabiyei meta iya taugadosisiyeigau ede. Na kaiteya ye gadosisiyeigau, Tamagu kabo iya ye gadosisiyei, yo yau hinage kabo ya gadosisiyei yo ya hemasalahagau iya kalinawai.” ");
INSERT INTO sbe_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na kabo Yudasi (iya nige Yudasi Isakaliyota) ye wane, “Guiyau, matawuwuna saha to bena ku hemasalahago kai ka bom kalimaiwai na nige bena tanoubu maudoina kalidiwai?” ");
INSERT INTO sbe_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na Yesu ye hededebui ye wane, “Ena tamowai hesau ye gadosisiyeigau, iya kabo yogu lauhekata wa ye kawakabiyeidi. Tamagu kabo ye gadosisiyei, yo Tamagu maiyagu kabo ka laoma iya maiyamai ka miya. ");
INSERT INTO sbe_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na kaiteya nige ye gadosisiyeigau, taba nige yogu lauhekata wa ye kawakabiyedi. Na yogu lauhekata meta nige yau yogu, na Tamagu iya tauhetamaligau wa yona lauhekata. ");
INSERT INTO sbe_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yau teina sola ma miyagu maidamiu ta na ginauli maudoidi ta ya hedededi kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na yau hesaguwai Tamagu kabo kami sagu ye hetamaliyawa. Iya ede Yaluwa Tabuna. Iya kabo ginauli maudoidi udiyedi ye hekatagomiu yo ginauli maudoidi ya hededediko wa kabo nuwamiu ne udiyedi ye henuhenuwaisinidi. ");
INSERT INTO sbe_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nuwadaumwali ya tole kalimiuwai, yogu nuwadaumwali ta ya leyawa. Yau nuwadaumwali ya leyawa ta nige doha tanoubu ye leyawa ne. Tabu nuwamiyao kwa hepilipilidi yo kwa matausi. ");
INSERT INTO sbe_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Saha ya hedededi wa komiu kwa lapuidiko doha ya wane, ‘Ya laugabaegomiu, na kabo ya uyoma kalimiuwai.’ Ena taba kwa gadosisiyeigau, kabo kwa gwauyala meta ya laulau Tamagu unai, matawuwuna iya ye saekalili na kabo yau. ");
INSERT INTO sbe_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Saha kabo se tubu meta ya hededenonohaidiko kalimiuwai. Na huyana se tubu kabo kwa sunumaeigau. ");
INSERT INTO sbe_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yau taba nige gonowana ya hedehededekalili kalimiuwai, matawuwuna ede tanoubu ta kana tanuwaga ye laolaoma. Iya nige yona gigibwali gonowana bena kabo ye saedikwaigau. ");
INSERT INTO sbe_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na tanoubu maudoina bena kabina se kata meta yau Tamagu ya gadosisiyei, unai ede Tamagu saha ye hedededi wa ya ginauliwatanidi. Kwa laoma, ta pesa ta lau.” ");
INSERT INTO sbe_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yau wine mamohoina ede, na Tamagu iya wine ta taukitahetetena. ");
INSERT INTO sbe_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ena laga hesau kaliguwai na nige ye kaniyo meta kabo ye bolihai. Na laga kanikaniyodi ne ye boliyawasidi kabo se kaniyonamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na komiu kwa aꞌako yogu hedehedede ya hedededi kalimiuwai wa debadiwai. ");
INSERT INTO sbe_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kwa miyatahitahi kaliguwai, na kabo ya miyatahitahi kalimiuwai. Taba laga hesau ye miyasuwala, meta taba nige kaniyona. Na bena ye miya wine ne unai, kabo ye kaniyo. Gonogonowana doha komiu bena kwa miyatahitahi kaliguwai, kabo kwa kaniyo. ");
INSERT INTO sbe_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yau winena ede na komiu meta laganao. Ena tamowai hesau ye miyatahitahi kaliguwai na yau iya unai, kabo ye kaniyo namwanamwakalili. Ena nige kwa patu kaliguwai, meta taba nige kwa kaniyo. ");
INSERT INTO sbe_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ena tamowai hesau nige ye miyatahitahi kaliguwai, iya meta kabo doha wine lagana se gabaeihesuwala na ye pogi. Wine lagadi pogipogidi ne kabo se tanogogoidi na se gabalaedi kaiwa kalakalasina unai na se kalasi. ");
INSERT INTO sbe_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ena komiu kwa miyatahitahi kaliguwai yo yogu hedehedede se miya kalimiuwai, meta saha kwa henuwadi na kwa kaibwadaidi, Tamagu kabo ye lediwa. ");
INSERT INTO sbe_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ena komiu kwa kaniyonamwanamwa, unai kabo kwa hemasalahaꞌuyoigomiu meta komiu yogu hekahekatao mamohoidi. Teina unai kabo Tamagu hedebasae lakilakina ye hai. ");
INSERT INTO sbe_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamagu ye gadosisiyeigau, gonogonowana doha yau hinage ya gadosisiyeigomiu. Bena yogu gadosisi ne unai kwa miyatahitahi. ");
INSERT INTO sbe_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ena komiu yogu laugagayo ta kwa kawakabiyeidi, komiu kabo yogu gadosisi ne unai kwa miyatahitahi, doha hinage yau Tamagu yona laugagayo ya kawakabiyeidi na yona gadosisi ne unai ya miyatahitahi. ");
INSERT INTO sbe_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Teina hedehedede ta ya hedededi kalimiuwai matawuwuna ya henuwa bena yogu gwauyala kabo ye miya kalimiuwai na yomi gwauyala ne meta kabo ye lakikalili. ");
INSERT INTO sbe_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yogu laugagayo ede teina: Bena kwa haigadogadosisiꞌuyoigomiu doha ya gadosisiyeigomiu ta. ");
INSERT INTO sbe_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gadosisi lakilakikalilina kabahemasalahana ede bena taba tamowai hesau ye boita kehanao hesabadi. ");
INSERT INTO sbe_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ena yogu hedehedede ta kwa ginauliwatanidi, meta komiu kehaguwao mamohoidi. ");
INSERT INTO sbe_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yau taba nige huya hesauꞌuyo ya kataigomiu yogu heyayai tauhaidi, matawuwuna ede heyayai tauhaina nige kabina ye kata saha kana tanuwaga ye ginaginaulidi ne. Na ya kataigomiu kehaguwao, matawuwuna ede ginauli maudoidi Tamagu unai ya lapuidi wa meta ya hemasalahadiko kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Komiu nige kwa kaisunuwaigau, na yau ya kaisunuwaigomiu, bena kwa lau kaniyomiu kwa toledi, na kaniyomiu ne kabo se miyahai. Yo ya kaisunuwaigomiu bena saha kwa kaibwadai yau hesaguwai ne, Tamagu kabo ye leyawa. ");
INSERT INTO sbe_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Teina ta yau yogu laugagayo ede: Bena komiu kwa haigadogadosisiꞌuyoigomiu.” ");
INSERT INTO sbe_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Na Yesu yona hedehedede wa ye tubei ye wane, “Ena tanoubu tamowaidiyao ta se subugomiu, kabo kwa nuwatui meta yau se sububagunaegauko. ");
INSERT INTO sbe_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ena taba komiu tanoubu ta yona, kabo ye gadosisiyeigomiu doha iya yona mamohoidi. Na komiu meta nige tanoubu ta yona, na tanoubu ta unai ya kaisunuwaigomiu. Debanawai tanoubu ta ye subugomiu. ");
INSERT INTO sbe_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hedehedede ya hedededi kalimiuwai wa bena kwa nuwanuwatuidi, doha ya wane, ‘Heyayai tauhaina meta nige ye saekalili na kabo kana tanuwaga.’ Ena se hekamkamnagau, meta komiu hinage kabo se hekamkamnagomiu. Ena yogu lauhekata se kawakabiyeidi, hinage komiu yomi lauhekata kabo se kawakabiyeidi. ");
INSERT INTO sbe_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yau hesagu debanawai kabikabi ne kabo se ginaulidi kalimiuwai, matawuwuna ede tauhetamaligau nige kabina se kata. ");
INSERT INTO sbe_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taba ena nige ya dobima yo ya hededelau kalidiwai, siya yodi baꞌaya taba nige giluna kalidiwai. Na ya dobima yo ya hededelau kalidiwai, ede siya nige gonowana yodi baꞌaya ne se kaihalei. ");
INSERT INTO sbe_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na kaiteya ye subugau, iya hinage Tamagu ye subu. ");
INSERT INTO sbe_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yau laulau gigigigibwalidi ya ginaulidi doha nige tamowai hesau gonowana ye ginaulidi. Na ena taba nige ya ginaulidi kalidiwai, kabo siya yodi baꞌaya taba nige giluna kalidiwai. Na laulau gigigigibwalidi ta se kitadiko, iyamo yau yo Tamagu se subugai. ");
INSERT INTO sbe_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na se subugau, ede Dawida saha ye kuli yodi kulikuli tabudi udiyedi wa meta se hemamohoiyei, doha ye wane, ‘Siya yodi subugau ne meta nige kaniyona.’ ");
INSERT INTO sbe_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yau kabo kami sagu Tamagu unai wa ya hetamaliyama kalimiuwai. Iya ede hedehedede mamohoina Yaluwana, kabo Tamagu unai ye dobima. Iya kabo kagu kao maudoina tauhemasalahana. ");
INSERT INTO sbe_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na komiu hinage bena kwa hededehemasalahagau tamowai kalidiwai, matawuwuna yogu paisowa huyahetubuna unai ye laoma teina meta komiu maidaguwao. ");
INSERT INTO sbe_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Teina ginauli maudoidi ta ya hedededi kalimiuwai, to taba nige ginauli saha hesau debanaena na sunuma kwa lausuwalaei. ");
INSERT INTO sbe_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dius tamowaidi kabo sunago udiyedi se hepesagomiu. Yo hinage huyana ede ye laolaoma kabo se koihemwaloigomiu. Na laulau ta tauginaulina meta kabo yodi nuwatu bena unai Yaubada se kaihelahui. ");
INSERT INTO sbe_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na ginauli yababadi ta se ginaulidi, matawuwuna ede Tamagu yo yau nige kabimai se kata. ");
INSERT INTO sbe_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Teina nuwatu ta ya hededediko kalimiuwai, na huyana se tubu kabo kwa nuwatulobai meta ya hededediko kalimiuwai. Huya bagubagunana unai ye laoma ee teina meta nuwatu ta nige ya hedededi kalimiuwai, matawuwuna yau ede sola maidamiu.” ");
INSERT INTO sbe_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kabo Yesu ye wane, “Nige bayaona kabo ya laugabaegomiu na ya lau tauhetamaligau wa unai, na iyamo komiu nige hesau bena ye henamaiyeigau ye wane, ‘Kowa kabo haedi ku laulau?’ ");
INSERT INTO sbe_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa nuwadubukalili, matawuwuna ede teina nuwatu ta ya hededediko kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na yau meta hedehedede mamohoina ya hedede: Ya laugabaegomiu ne meta komiu yomi namwanamwa hesabana. Taba ena yau nige ya laugabaegomiu, kami sagu meta nige gonowana ye laoma. Na ena yau ya lau, kabo kami sagu ne ya hetamaliyama. ");
INSERT INTO sbe_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Huyana ye laoma kabo tamowai maudoidi tanoubu ta unai nuwamasalaha ye moseidi na baꞌaya yo miyamiyadudulai yo hekasa se nuwatulobaidi. ");
INSERT INTO sbe_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Baꞌaya unai kabo ye hemasalaha kalidiwai meta yodi baꞌaya mamohoina ede nige se kawamamohoiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Miyamiyadudulai unai kabo ye hemasalaha kalidiwai meta yau miyamiya dudulaina tamowaina, matawuwuna ede yau ya lau Tamagu unai, yo taba nige gonowana kwa kitaꞌuyoigau. ");
INSERT INTO sbe_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yo Yaubada yona hekasa unai kabo ye hemasalaha kalidiwai meta Yaubada kabo hinage tamowai ye hekasadi, matawuwuna ede tanoubu ta yona wasawasa ye hekasayako. ");
INSERT INTO sbe_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yau kaliguwai nuwanuwatu se bado bena kabo ya hedededi kalimiuwai. Na se badokalili, unai nige gonowana maudoidi kwa nuwatuhekahinidi. ");
INSERT INTO sbe_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na huyana hedehedede mamohoina Yaluwana ne ye laoma, iya kabo hedehedede mamohoidi maudoidi udiyedi ye henuwatulobaigomiu. Iya taba nige ye bom yona nuwatuwai ye hedehedede, na saha Yaubada unai ye lapuidi kabo ye hedededi, yo saha kabo se tubu matada ne udiyedi ye hekatagomiu. ");
INSERT INTO sbe_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Saha ya hedededi hedehedede mamohoina Yaluwana kalinawai, kabo ye hemasalahadi kalimiuwai. Tenem unai kabo hedebasaegau ye helaki. ");
INSERT INTO sbe_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ginauli maudoidi Tamagu kalinawai ne meta yau yogu. Unai ede ya wane, ‘Yaluwa ne kabo kaliguwai yogu hedehedede ye haidi na ye hemasalahadi kalimiuwai.’” ");
INSERT INTO sbe_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Na Yesu yona hedehedede wa ye tubei ye wane, “Huyakubwakubwa mo mulinawai taba nige kwa kitagau, yo huyakubwakubwa mo na mulinawai kabo kwa kitaꞌuyoigau.” ");
INSERT INTO sbe_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yona hekahekatao hekadiyo se henahenamaiꞌuyoidi se wane, “Teina yona hedehedede ta kaniyodi saha? Doha ye wane, ‘Huyakubwakubwa mo mulinawai taba nige kwa kitagau, yo huyakubwakubwa mo na mulinawai kabo kwa kitaꞌuyoigau.’ Yo hinage ye wane, ‘Matawuwuna ya laulau Tamagu unai.’” ");
INSERT INTO sbe_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Siya sola se henahenamaiꞌuyoidi se wane, “Teina hedehedede ta ‘Huyakubwakubwa mo’ meta kaniyona ede saha? Saha ye hedehedededi ne nige ka nuwatulobaidi.” ");
INSERT INTO sbe_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ye kitadi meta se henuwa bena se henamaiyei ede ye wane, “Kabina ya kata meta yogu hedehedede ta kwa hetahetaladi, doha ya wane, ‘Huyakubwakubwa mo mulinawai taba nige kwa kitagau, yo huyakubwakubwa mo na mulinawai kabo kwa kitaꞌuyoigau.’ Yo kwa henuwa kaniyona bena kabina kwa kata. ");
INSERT INTO sbe_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya hededemamohoi kalimiuwai: Kabo kwa dou yo kwa nuwadubu, na tanoubu ta tamowaidiyao kabo se gwauyala. Komiu kabo kwa nuwadubukalili, na iyamo yomi nuwadubukalili ne kabo ye bui na ye hemala yomi gwauyala. ");
INSERT INTO sbe_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Waihiu diyadiyakana bena ye labalaba meta kabo ye kamkamnakalili, matawuwuna yona labalaba mahanana ye lage. Na huyana natuna ye labasi meta yona kamkamna wa ye nuwaluluhiyei, matawuwuna ede natuna wa ye labasiyamako tanoubu ta unai. Teina ta meta ye hemala yona gwauyala. ");
INSERT INTO sbe_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Doha hinage komiu: Teina ta meta yomi nuwadubulakilaki huyana. Na huya hesau kabo ya kitaꞌuyoigomiu. Kabo kwa gwauyala, na yomi gwauyala ne taba nige hesau ye haigabaei kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tenem mayadaina ne unai komiu taba nige saha hesau kwa kaibwadaiꞌuyoi kaliguwai. Ya hededemamohoi kalimiuwai: Saha kwa kaibwadai Tamagu unai yau hesaguwai kabo ye leyawa. ");
INSERT INTO sbe_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na ye laoma ee teina, komiu sola nige saha hesau kwa kaibwadai yau hesaguwai. Kwa kaibwada Yaubada unai, kabo kwa hai, unai kabo kwa gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ye laoma ee teina hedehedede palabole udiyedi ya hedede kalimiuwai. Na mayadaina ede ye laolaoma unai taba nige ya hededepalaboleꞌuyo, na unai kabo Tamagu ya hededehemasalahamamohoiyei kalimiuwai. ");
INSERT INTO sbe_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tenem mayadaina ne unai yau hesaguwai kabo kwa kaibwada. Nige ya wane, kabo yau ya kaibwada Tamagu unai komiu hesabamiu. ");
INSERT INTO sbe_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taba nige! Tamagu iya ye gadosisiyeigomiu, matawuwuna ede komiu kwa gadosisiyeigau yo kwa kawamamohoi meta yau Yaubada unai ya laoma. ");
INSERT INTO sbe_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mamohoikalili, yau Yaubada unai ya laoma, na ya laomako tanoubu ta unai. Na tanoubu ta kabo ya laugabaei ya uyo Tamagu unai.” ");
INSERT INTO sbe_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kabo Yesu yona hekahekatao wa se wane, “Teina yom hedehedede ta meta se masalahakalili, nige doha palabole udiyedi ku hedehedede. ");
INSERT INTO sbe_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na ka nuwatulobai meta kowa ginauli maudoidi kabidi ku katakalili. Unai nige gonowana kai taba bena henamai hesau unai ka henamaiyeigo. Teina debanawai ka kawamamohoi meta kowa mamohoi Yaubada unai ku laoma.” ");
INSERT INTO sbe_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ye hededelau udiyedi ye wane, “Na kabotaki kwa kawamamohoi! ");
INSERT INTO sbe_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na huyana ede ye laolaoma, na iya ede ye lagemako, na unai kabo kwa tatagwaligwali, hesau hesau ye lau yona kabamiya unai. Kabo kwa laugabaeigau na yau ya bom. Na iyamo yau nige ya bom, na Tamagu meta iya ede maidagu. ");
INSERT INTO sbe_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Teina nuwanuwatu ta ya hedededi kalimiuwai, unai kabo nuwadaumwali kwa hai yau kaliguwai. Tanoubu ta unai komiu kabo pilipili kwa hekalodi. Na nuwamiu se bayao! Matawuwuna yau tanoubu ta wasawasana ya saedikwaiyako.” ");
INSERT INTO sbe_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Teina hedehedede ta mulidiwai Yesu ye kaikewasae galewa ne unai na ye tapwalolo ye wane, “Tamagu, huyana wa ye lagemako. Natum kana kao saesaena mamohoina ku hemasalaha, na unai kabo Natum hinage kam kao saesaena mamohoina ye hemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kowa gigibwali ku leyama, unai ya hemala tamowai maudoidi kadi tanuwaga. Kaniyona ede mauli nige kana siga bena kabo ya moseidi tamowai maudoidi ku ledima wa kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Teina meta mauli nige kana siga ede: Kowa ku bom Yaubada mamohoina yo yau, Yesu Keliso, yom hetahetamali tamowaina, bena kabida se kata. ");
INSERT INTO sbe_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Paisowa ku ledima wa ya ginaulihegehediko. Na teina paisowa ta udiyedi kam kao saesaena mamohoina ya hemasalaha tanoubu ta unai. ");
INSERT INTO sbe_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Huyana tanoubu sola nige ye tubu, meta yau maidam na yogu kabaloina saesaena wa kaliguwai. Unai ya kaibwadaigo huyana ya lage kowa kalimwai bena yogu kabaloina saesaena wa ku haiꞌuyoiyama kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tamagu, tanoubu ta unai tamowai hekadi ku kaisunuwaidi bena yogu tamowai. Siya kowa yom tamowai, na ku ledima kaliguwai, na yom hedehedede se kawakabiyedi. Siya kalidiwai meta kowa kam kao mamohoina ya hemasalaha. ");
INSERT INTO sbe_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kabina se kata meta ginauli maudoidi ku ledima wa, siya kowa kalimwai se laoma. ");
INSERT INTO sbe_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Matawuwuna hedehedede ku ledima wa ya moseidi kalidiwai na se haidi. Yo kabina se katakalili meta kowa kalimwai ya dobima. Yo se kawamamohoi meta kowa ku hetamaligau. ");
INSERT INTO sbe_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Siya yodi ya tapwalolo. Nige tanoubu ta maudoina yodi ya tapwalolo, na siya kaiteyadi ku ledima wa yodi, matawuwuna ede siya kowa yom. ");
INSERT INTO sbe_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Siya maudoidi kaliguwai ne kowa yom, yo maudoidi kalimwai ne meta yau yogu. Na yodi miyamiya ne udiyedi kagu kao saesaena mamohoina se hemasalaha tamowai kalidiwai. ");
INSERT INTO sbe_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yau kabo tanoubu ta ya laugabaei, na ya laolaowa kalimwai, na siya meta kabo sola tanoubu ta unai se miyamiya. Tamagu, kowa tabuna. Hesam ku leyama wa debanaena ede ta nuwakesega. Na ya kaibwadaigo bena yom gigibwali unai yodi ku laugudugudu, to se nuwakesega doha kowa yo yau. ");
INSERT INTO sbe_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Huyana yau maiyadi meta yababa udiyedi ya tolotaunidi yo ya kitahetetenamwanamwaedi hesa ku leyama wa unai. Nige hesau ya hetaukwadalele, na iya hekamkamna tauhekalona ne ye bom mo. Teina unai ede kulikuli tabuna wa ye hemamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yau meta ya laolaowa kalimwai, na sola tanoubu ta unai ma miyagu, na teina nuwatu ta ya hedededi kalidiwai, na bena yogu gwauyalalakilaki unai se miya. ");
INSERT INTO sbe_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yau yom hedehedede wa ya moseidiko kalidiwai, na tanoubu tamowaidi meta siya se subudi, matawuwuna siya nige tanoubu ta yona doha yau nige tanoubu ta yona. ");
INSERT INTO sbe_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yau nige ya kaibwadaigo bena tanoubu ta unai ku haigabaeidi, na ya kaibwadaigo bena tauyababa yona gigibwali unai kowa ku lauguduguduidi. ");
INSERT INTO sbe_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Siya nige tanoubu ta yona, doha yau nige tanoubu ta yona. ");
INSERT INTO sbe_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taba hedehedede mamohoina unai ku saguidi na se hemala yom tamowai mamohoidi. Kowa yom hedehedede meta hedehedede mamohoina ede. ");
INSERT INTO sbe_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kowa ku hetamaligau ya dobima tanoubu ta, unai yau hinage ya hetamalidi se lau tanoubu ta unai. ");
INSERT INTO sbe_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Siya debadiwai ede yau ya mosegabaeiꞌuyoigau kowa kalimwai, unai bena siya kabo hinage ya moseidi kalimwai na siya mamohoi yom tamowai.” ");
INSERT INTO sbe_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tamagu, yogu kaibwada ta nige yogu hekahekatao se bom hesabadi, na hinage wasa ta yodi hewasana unai na kaiteyadi se kawamamohoiyeigau meta yodi ya kaibwada. ");
INSERT INTO sbe_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na ya kaibwadaigo meta maudoidi kabo se nuwakesega, doha kowa ede kaliguwai yo yau ede kalimwai. Siya hinage bena kalidawai, unai tanoubu maudoidi kabo se kawamamohoi meta kowa ku hetamaligau. ");
INSERT INTO sbe_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yogu kabaloina saesaena gigibwalina maudoina ku haiyama wa ya hekawalaei kalidiwai. Tenem unai bena siya se nuwakesega doha kita meta kesega. ");
INSERT INTO sbe_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ede yau kalidiwai yo kowa ede kaliguwai. Taba siya se nuwakesegamamohoi, na unai bena tanoubu maudoina kabina se kata meta kowa ku hetamaligau, yo ku gadosisiyeidi gonogonowana doha yau ku gadosisiyeigau. ");
INSERT INTO sbe_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamagu, ya henuwa bena tamowai ku ledima wa maidaguwao yogu kabamiya ne unai, to yogu kabaloina saesaena wa se kita. Yogu kabaloina saesaena wa ku leyama, matawuwuna ku gadosisibagunaegau na kabo tanoubu ta ye tubu. ");
INSERT INTO sbe_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamagu, kowa ku dudulaikalili. Tanoubu ta kowa nige kabim se kata, na yau kabim ya kata, yo siya tausunumaegau kabina se kata meta kowa ku hetamaligauma. ");
INSERT INTO sbe_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ye laoma teina ede kam kao ya hemasalaha kalidiwai, na sola kabo ya hemahemasalahaꞌuyoigo kalidiwai, na unai ede bena se haigadogadosisiꞌuyoidi doha kowa ku gadosisiyeigau, yo yau kabo kalidiwai.” ");
INSERT INTO sbe_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Huyana Yesu ye tapwalologehe maiyana hekahekatao se dalahai na Kidilona gonuna unai se taukawasi se lau teha hesau unai. Na temenai meta olibe yaowana hesau, ede maiyana hekahekatao wa se lulau unai. ");
INSERT INTO sbe_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasi iya Yesu kana tauwalohai wa meta tenem teha ne kabina ye kata, matawuwuna ede Yesu maiyana hekahekatao huya hekadi temenai se laolaomagogoi. ");
INSERT INTO sbe_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ede ye laoma na tauꞌiyala bodadi yo taukaitalasam tauwoyaidi yo Paliseya yodi taupaisowa hekadi maiyanao. Na osili, lampa yo kabaꞌiyala gogodi se baheidi, na ye woyaidi se lau se lage tenem olibe yaowana ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ginauli maudoidi kabo se tubu Yesu kalinawai ne kabidi ye katako, ede ye lau na ye henamaiyeidi ye wane, “Kaiteya hesabana kwa laoma?” ");
INSERT INTO sbe_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Se hededebui se wane, “Yesu Nasaleta tamowaina wa.” Yesu ye wane, “Yau tamowaina ede.” Na Yesu kana tauwalohai Yudasi meta menai maiyanao se totolo. ");
INSERT INTO sbe_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Huyana Yesu ye wane, “Yau tamowaina ede,” taulaoma wa se mulisigisigi yo se gulidobi bwatano wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu ye henamaiꞌuyoidi ye wane, “Kaiteya hesabana kwa laoma?” Ede se wane, “Yesu Nasaleta tamowaina wa.” ");
INSERT INTO sbe_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ye wane, “Ya hededeyako kalimiuwai meta yau tamowaina ede. Ena yau ya bom kwa wasewaseneigau, yogu tamowai ta kwa kabigabaeidi se lau.” ");
INSERT INTO sbe_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Teina ye tubu meta iya yona hedehedede wa ye hemamohoiyei, doha ye wane, “Tamowai ku ledima wa ya kitahetetenamwanamwaedi na nige hesau ya hetaukwadalele.” ");
INSERT INTO sbe_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na Simona Petelo iya yona kelepa kalinawai ye lausini ede taukaitalasam saesaena yona heyayai tauhaina beyakahatuna ye boliꞌutusi. Heyayai tauhaina wa hesana ede Malakasi. ");
INSERT INTO sbe_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kabo Yesu ye hededelau Petelo unai ye wane, “Yom kelepa ne ku toleꞌuyoi kabahaina ne unai! Matawuwuna ede kamkamna keyakana Tamagu ye leyama ta, taba unai ya numa.” ");
INSERT INTO sbe_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na kabo tauꞌiyala bodadi maiyadi kadi tanuwaga yo Dius tauwoyaidi yodi taupaisowa wa Yesu se hai yo nimana se paidi. ");
INSERT INTO sbe_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na bagubaguna meta se woyalaei Kaiyapasi bwasiyana Anase unai. Kaiyapasi iya taukaitalasam saesaena tenem bolimaina ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na iya ede ye hededelau Dius tauwoyaidi udiyedi ye wane, “Ye namwakalili taba tamowai kesega ye boita tamowai maudoida hesabada.” ");
INSERT INTO sbe_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petelo yo hekahekata hesau Yesu se hemuliwatani. Na hekahekata hesau wa Yesu ye hemuliwatani se mwalae taukaitalasam saesaena yona bakubaku ne unai, matawuwuna taukaitalasam saesaena wa tenem hekahekata ne kabina ye kata. ");
INSERT INTO sbe_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na Petelo meta dagela ne unai ye nayanaya, ede hekahekata hesau wa iya taukaitalasam saesaena kabina ye kataꞌusi wa ye uyo kawakeda wa na ye hededelau kawakeda taukitahetetena waihiuna kalinawai bena taba Petelo ye mwalae. ");
INSERT INTO sbe_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Waihiu kawakeda taukitahetetena wa Petelo ye henamaiyei ye wane, “Na kowa hinage Yesu yona hekahekata hesau?” Iya ye hededebui ye wane, “Yau nige.” ");
INSERT INTO sbe_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Huyana ne meta huyagwagwama, ede heyayai tauhaidi hekadi yo tauwoyawoya yodi taupaisowa wa kaiwa se yuhi na se tolohetakikili se kaikaimwaiga. Na Petelo hinage ye tololau ede maiyadi se kaimwaiga. ");
INSERT INTO sbe_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na kabo taukaitalasam saesaena Yesu yona hekahekatao yo yona lauhekata debadiwai ede ye henamaibuibui. ");
INSERT INTO sbe_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ede Yesu ye hededebui ye wane, “Yau huya badobado sunago yo Numa Tabuna udiyedi ya laulauhekata. Menai kita Dius yoda tamowai se laolaomagogoi, na ya laulauguguyamasalaha tamowai maudoidi kalidiwai. Nige ginauli hesau ya hededewadawadamyei. ");
INSERT INTO sbe_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Idohagi to ku henamaiyeigau? Yogu hedehedede taulapuidi ne ku henamaiyeidi. Yogu hedehedede meta kabidi se katakalili.” ");
INSERT INTO sbe_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na taukaitalasam saesaena wa yona taupaisowa hesau Yesu dedekanawai ye totolo na yona hededebui wa ye lapui ede nimanawai ye laupapali, na ye wane, “Idohagi to taukaitalasam saesaena unai ku hedede doha teina?” ");
INSERT INTO sbe_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ye hededebui ye wane, “Ena taba hedehedede ta ya hedede ne unai ya laupwano, yogu laupwano saha bena ku hededehemasalaha. Na taba saha ya hedededi ne mamohoi, ye saha to ku laupapaligau?” ");
INSERT INTO sbe_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesu meta nimana sola ma paipaidi, na Anase iya ye hetamalilae taukaitalasam saesaena Kaiyapasi unai. ");
INSERT INTO sbe_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Petelo ye tolo na ye kaikaimwaiga, na taukaimwaiga hekadi wa se henamaiyei se wane, “Kowa hinage yona hekahekatao wa hesauna?” Petelo ye uhala ye wane, “Yau nige.” ");
INSERT INTO sbe_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na tamowai beyana Petelo ye boliꞌutusiꞌusei wa kehana hesau iya hinage taukaitalasam saesaena yona heyayai tauhaina, ye hededebayao ye wane, “Ya nuwatui meta kowa ya kitago Yesu maiyam olibe yaowana wa unai.” ");
INSERT INTO sbe_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na Petelo ye uhalaꞌuyo, na mahanana ne unai meta pwaole hakiyana ye dou. ");
INSERT INTO sbe_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na kabo Dius tauwoyaidi wa Yesu maiyadi Kaiyapasi yona numa se pesagabaei na se lau Loma yodi gabana yona kabaloina numana lakilakina unai. Mala ye tom na malatomtom gagilina unai, na Dius tauwoyaidi nige se mwalae Loma yodi gabana yona numa wa unai, matawuwuna Dius yodi laugagayo meta ena se mwalae numa ne unai kabo ye hebikidi Yaubada matanawai. Na nige se mwalae, matawuwuna ede se henuwa bena Taukiuli kaina se kai. ");
INSERT INTO sbe_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ede Gabana Pilato ye pesa ye laoma kalidiwai na ye henamaiyeidi ye wane, “Yababa saha unai teina tamowai ta kwa hegilu?” ");
INSERT INTO sbe_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na se wane, “Ena taba iya nige laugagayo hesau ye utusi, taba nige ka woyaiyama kalimwai.” ");
INSERT INTO sbe_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ye hededelau udiyedi ye wane, “Kwa hai na kabo yomi laugagayo ne unai kwa bom kwa hekasa.” Dius tauwoyaidi wa se hededelau unai se wane, “Komiu Loma tamowaidi yomi laugagayo kwa tole meta kai nige gonowana tamowai hesau ka hekasa na ka unuhemwaloi.” ");
INSERT INTO sbe_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Teina ye tubu ta meta Yesu yona boita kana kao ye hededehemasalahayako wa ye laoma ye hemamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na kabo Pilato ye mwalaeseuyo yona kabaloina numana lakilakina wa unai na Yesu ye yoganei ye lau unai na ye henamaiyei ye wane, “Kowa Dius tamowaidi yodi wasawasa?” ");
INSERT INTO sbe_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ye henamailau unai ye wane, “Teina ta kowa ku bom yom henamai, o tamowai hekadi se hededehemasalahagauko kowa kalimwai?” ");
INSERT INTO sbe_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ye hededebui ye wane, “Yau nige Dius tamowaina. Yom tamowai yo taukaitalasam tauwoyaidi se woyaigo na kwa laoma kaliguwai. Yababa saha ku ginauli?” ");
INSERT INTO sbe_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ye wane, “Yau yogu basileiya ne nige tanoubu ta yona. Ena taba tanoubu ta yona, yogu taupaisowa maudoidi ne kabo yogu se laugudugudu, na Dius tamowaidi ne taba nige gonowana se haigau. Na yogu basileiya ne meta iya teha hesau yona.” ");
INSERT INTO sbe_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na Pilato ye hededelau iya unai, ye wane, “Unai kowa meta wasawasa!” Yesu ye hededebui ye wane, “Kowa ku hedede meta yau wasawasa. Mamohoikalili, se labasigau yo ya dobima tanoubu ta unai bena hedehedede mamohoina ya hemasalaha tamowai udiyedi. Na kaiteyadi hedehedede mamohoina se henuwa, siya kabo se lapulaoma kaliguwai.” ");
INSERT INTO sbe_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ede Pilato ye henamai ye wane, “Mamohoina bena saha?” Teina unai ye pesa ye lau Dius udiyedi na ye wane, “Nige kabahegiluna saha hesau ya lobai. ");
INSERT INTO sbe_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na komiu yomi laulau meta bolimai badobado Taukiuli Henuwaisinina huyana unai kabo numatutugudu unai taumiya tamowaina hesau kwa kaibwadai bena ya yailigabaei. Unai hage, kwa henuwa bena Dius yodi wasawasa ne ya yailigabaei?” ");
INSERT INTO sbe_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na maudoidi se yogahilakilaki se wane, “Nige, iya nige! Balabasi iya ku yailigabaeiyama ede.” Na Balabasi iya meta Loma gabemani unai tauhaikabi tamowaina. ");
INSERT INTO sbe_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na kabo Pilato Yesu ye hai ye moselaei tauꞌiyala udiyedi na wipi unai se sapiheyababakaliliyei. ");
INSERT INTO sbe_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na kabo kaiwa gwaligwalina laganao se heidi doha kolona na se tole Yesu kuluna unai, yo kwama pulupululuna se hai se heluwui. ");
INSERT INTO sbe_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na se sae kalinawai na se talatalawasiyei se wane, “O Dius yodi wasawasa, ka hedebasaego.” Yo nimadiwai se laupapali. ");
INSERT INTO sbe_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ye pesaꞌuyo na ye hededelau Dius tauwoyaidi wa udiyedi ye wane, “Kwa lapui, kabo ya woyaiyama na bena kabina kwa kata meta iya kalinawai nige kabahegiluna hesau ya lobai.” ");
INSERT INTO sbe_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na Yesu kabo ye pesama, na maimaina gwaligwalina se heihepoꞌopoꞌo wa kuluna ne unai yo tauna ne unai meta kwama pulupululuna. Ede Pilato ye hededelau udiyedi ye wane, “Tamowai wa iya ede teina!” ");
INSERT INTO sbe_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Huyana taukaitalasam tauwoyaidi yo yodi taupaisowa lakilakidi Yesu se kita meta se yogahilakilaki se wane, “Ku hesataulo! Ku hesatauloyawa!” Na Pilato ye hededelau udiyedi ye wane, “Komiu kwa hai na kwa hesataulo. Yau nige kabahegiluna hesau ya lobai.” ");
INSERT INTO sbe_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na Dius tauwoyaidi se hededebui se wane, “Kai meta yoma laugagayo hesau, na laugagayo ne debanawai iya taba ye boita, matawuwuna ede ye hedede meta bena iya Yaubada Natuna.” ");
INSERT INTO sbe_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Huyana Pilato teina hedehedede ta ye lapui meta ye matausikalili. ");
INSERT INTO sbe_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kabo ye mwalaeseuyo numa lakilakina wa unai, na iya Yesu ye henamaiyei ye wane, “Kowa haedi ku laoma?” Na Yesu nige kalinana. ");
INSERT INTO sbe_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ede Pilato ye henamaiꞌuyo ye wane, “Idohagi to nige kalinam? Nuwana kowa nige kabina ku kata meta yau yogu gigibwali gonowana kabo ya yailihaigo o ya hesataulogo?” ");
INSERT INTO sbe_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ye hededebui ye wane, “Yau yom tanuwaga gigibwalina ta unai ya miyamiya matawuwuna ede yom gigibwali ne Yaubada ye leyawa. Unai tamowai ne ye mosegabaeigau kalimwai ta, iya yona yababa ye lakikalili na kabo kowa.” ");
INSERT INTO sbe_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Teina hedehedede ta unai ede Pilato ye kaipatekalili bena Yesu ye yailigabaei, na Dius tauwoyaidi se yogalau unai se wane, “Ena taba teina tamowai ta ku yailigabaei meta kowa nige Sisa yona taupaisowa namwanamwana. Teina tamowai ta ye hedede bena iya wasawasa, na teina hedehedede ta ye hemasalaha meta Sisa unai ye haikabi.” ");
INSERT INTO sbe_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato teina hedehedede ta ye lapui ede Yesu ye woyahepesadobiyei hekasa kabaginaulina bakubakuna unai, na ye tuli hekasa kabaginaulina kabatulina unai. Teha ta hesana kalina Alamaiki unai ede Gabata, kaniyona ede weku unai se matui. ");
INSERT INTO sbe_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Teina saha se tubu ta meta Taukiuli kaina kabinonohana mayadaina mayamayadailakina unai. Kabo Pilato ye hededelau Dius tauwoyaidi wa udiyedi ye wane, “Yomi wasawasa wa iya ede teina.” ");
INSERT INTO sbe_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na siya se yogalau unai se wane, “Ku laehesuwala! Ku laehesuwalayawa! Ku hesatauloyawa!” Pilato ye henamaiyeidi ye wane, “Kwa henuwa bena yomi wasawasa ne ya hesataulo?” Taukaitalasam tauwoyaidi se yogabui se wane, “Yoma wasawasa kesega ede Sisa! Kai nige yoma wasawasa hesau!” ");
INSERT INTO sbe_vpl VALUES ("JN19_16a","073_19_16a","JHN","19","16a","16a","Na kabo Pilato Yesu ye moselaei tauꞌiyala tamowaidi kalidiwai bena se hesataulo. ");
INSERT INTO sbe_vpl VALUES ("JN19_16b","073_19_16b","JHN","19","16b","16b","Ede Yesu se woyaei se laei. ");
INSERT INTO sbe_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na Yesu kana sataulo ye bom ye bahei na ye lau tupwa hesauna unai hesana ede Mwayalu Magaina. Kalina Alamaiki unai se wane, Golagota. ");
INSERT INTO sbe_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Temenai Yesu yo tamowai labui maiyanao se hesataulodi. Yesu se heduwaduwali na tehakahatuna ne unai hesau yo tehaseuseulina ne unai hesau. ");
INSERT INTO sbe_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato hededehemasalaha kubwakubwana ye kuli na se tutuhepatu sataulo wa kewanawai. Ye kuli ye wane, “YESU NASALETA TAMOWAINA, DIUS YODI WASAWASA.” ");
INSERT INTO sbe_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dius tamowaidi gwaudi kulikuli wa gonowana se hasili, matawuwuna ede yodi kabahesataulona ne meta magailaki wa dedekanawai. Na hededehemasalaha wa meta kalina Alamaiki, Latini yo Giliki udiyedi ye kuli. ");
INSERT INTO sbe_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na Dius yodi taukaitalasam tauwoyaidi se hededelau Pilato unai se wane, “Tabu ku kuli ku wane, ‘Dius tamowaidi yodi wasawasa,’ na taba ku kuli ku wane, teina tamowai ta ye hedede ye wane, ‘Yau Dius tamowaidi yodi wasawasa.’” ");
INSERT INTO sbe_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na Pilato ye hededebui ye wane, “Saha ya kuli ne meta temeta ya kuli ede!” ");
INSERT INTO sbe_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yesu se hesataulo, na kabo tauꞌiyala tamowaidi wa taudi hasi, siya kana kwama se haidi na se bolidi na se soiyeidi se bom mo kalidiwai, na kana likwaguni kwamana wa nige se boli, matawuwuna teina kwama ta meta kewana unai ye dobi guni ne meta se halukesegai mo, nige kababoditubeina hesau. ");
INSERT INTO sbe_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ede tauꞌiyala wa se bom se hedehedede se wane, “Tabu kwama ta ta igaꞌigali. Ta tole na ta kaiheyai kabo kaiteya ye hai.” Teina ye tubu ta meta kulikuli tabuna ye hemamohoiyei doha ye wane, “Yogu kwama se soiyeidi kalidiwai, yo yogu likwaguni kwamana daisi unai se kaiheyai.” Na teina laulau ta ede tauꞌiyala tamowaidi wa se ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu yona sataulo dedekanawai meta iya sinana, sinana kana kaha, Maliya iya Kolopasi mwanena yo Maliya Magadala waihiuna se totolo. ");
INSERT INTO sbe_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Huyana Yesu ye kaikewadobi na sinana ye kita yo yona hekahekata ye gadogadosisiꞌusei wa dedekana unai ye totolo, ede ye hededelau sinana wa unai ye wane, “Sinebada! Temeta me kowa natum.” ");
INSERT INTO sbe_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na yona hekahekata wa unai ye wane, “Kowa sinam ede temeta.” Tenem huyana ne unai ye lau meta yona hekahekata wa Yesu sinana wa ye woyai ye laei yona numa na ye kitahetete. ");
INSERT INTO sbe_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na Yesu kabina ye kata meta yona paisowa maudoidi wa ye hegehediko. Ede ye wane, “Yau gadogu ye magu.” Na teina unai kulikuli tabuna kabo ye hemamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Winega ma pakuna meta temenai, ede tauꞌiyala hesau balo ye hai ye hedakwa winega wa unai na hisopa lagana unai balo wa ye gwalihekahini na ye helelesae Yesu kawana ne unai. ");
INSERT INTO sbe_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu winega wa ye numa, na kabo ye wane, “Yogu paisowa maudoidi wa ya hegehediko.” Na kabo kuluna ye laudobiyei na yawasina ye mosegabaei. ");
INSERT INTO sbe_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na tenem meta Dius yodi Sabati kabinonohana mayadaina wa unai, yo mayadai hesauna ne kabo Sabati. Na tenem mayadaina ne meta mayadai saesaena. Na Dius tauwoyaidi nige se henuwa bena sinale ne se kabakabasi sataulo ne udiyedi ye lau ee Sabati ye lobai. Ede Pilato se kaibwadai na tamowai wa kaedi bena se yatugodudi yo sinaledi ne se haigabaeidi. ");
INSERT INTO sbe_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ede tauꞌiyala tamowaidi se lau tamowai labui Yesu maiyanao se hesataulodi wa kaedi se yatugodudi. ");
INSERT INTO sbe_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na huyana se lau Yesu unai na se kita meta ye boitako, ede nige kaena wa se yatugodudi. ");
INSERT INTO sbe_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Na tauꞌiyala tamowaina hesau wamali unai Yesu lisilisina ye gwalilapai, na kwasina yo waila se didipesama. ");
INSERT INTO sbe_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yau wasa ta taukulina na teina saha se tubu ta ya kitadi na ya kulihemasalahadi. Na saha ya kulihemasalahadi ta meta mamohoidi. Kabina ya kata meta ya hededemamohoi. Na ya kulihemasalaha bena komiu hinage unai kabo kwa kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Teina saha se tubu ta bena kulikuli tabuna se hemamohoiyei, doha ye wane, “Nige siyadana hesau kabo se yatugodu.” ");
INSERT INTO sbe_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yo kulikuli tabuna teha hesau unai ye wane, “Iya lisilisina se gwalilapai wa, kabo se kitalau unai.” ");
INSERT INTO sbe_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Teina saha se tubu ta mulidiwai, Yosepa, iya Alimatiya tamowaina, ye kaibwadalau Pilato unai bena Yesu sinalena ye hai. Yosepa meta iya Yesu tauhemuliwatanina wadawadamna hesau na nige ye hemasalahaꞌuyoi, matawuwuna ede Dius tauwoyaidi hekadiyo wa ye matausiyeidi. Pilato yona yali wa unai ede Yosepa ye lau Yesu sinalena ye hai, ");
INSERT INTO sbe_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","iya maiyana Nikodemo. Na Nikodemo, iya ede boniyaiyena Yesu taukaitaumanaena wa, iya meta yausi panepanena ye bahei, polohena doha 33 kilo. ");
INSERT INTO sbe_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Siya taudi labui Yesu sinalena wa se hai se heyausi na kaleko posiposina tupwadi lohalohadi udiyedi se suma. Teina ta meta Dius tamowaidi yodi toletoletau kabikabidi. ");
INSERT INTO sbe_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu yodi kabahesataulona wa dedekanawai meta koya hesau, na unai bwayabwaya hauhauna sola nige tamowai hesau unai se tole. ");
INSERT INTO sbe_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tenem mayadai ne Dius yodi Sabati kabinonohana mayadaina yo bwayabwaya wa meta kabahesataulona wa dedekanawai, ede temenai Yesu se tole. ");
INSERT INTO sbe_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabati hesauna mayadaina bagubagunana unai, malatomtom gagilina sola ma masimasigilina, kabo Maliya Magadala waihiuna wa ye lau bwayabwaya wa na ye kita meta kana gudu wekuna wa se buihesuwalayako. ");
INSERT INTO sbe_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ede ye heloi ye lau Simona Petelo yo hekahekata hesauna Yesu iya ye gadosisiꞌusei wa udiyedi na yodi ye hedehedede ye wane, “Guiyau sinalena wa bwayabwaya wa unai se haigabaei na nige kabina ka kata haedi se toleyako!” ");
INSERT INTO sbe_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kabo Petelo yo hekahekata hesauna wa se heloi se lau bwayabwaya wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Taudi labui se heloi na hekahekata hesauna wa Petelo ye heloigabaei na ye lagebaguna bwayabwaya wa unai. ");
INSERT INTO sbe_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ye dunedobi ye kitalau kaleko posiposidi tupwadi lohalohadi wa ye kitadi se bawabawa, na nige ye lusae kalo ne. ");
INSERT INTO sbe_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Na Simona Petelo ye mulitama wa ye lage meta ye lusae kalo wa na suma kaleko tupwadi wa ye kitadi se bawabawa, ");
INSERT INTO sbe_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yo hinage Yesu kuluna kana suma kalekona wa ye kita meta nokunokuna, na sinale kana suma kalekodi wa tupwa hesau unai na kuluna kana suma wa hinage tupwa hesau unai. ");
INSERT INTO sbe_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na kabo hekahekata hesauna taulagebaguna wa hinage ye lusae bwayabwaya wa unai. Na ginauli maudoidi wa ye kitadi ede ye kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Na siya sola nige kulikuli tabuna se nuwatulobai meta Yesu kabo boita unai ye toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kabo hekahekatao wa se uyo yodi numa. ");
INSERT INTO sbe_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na Maliya iya bwayabwaya wa dagelana unai ye totolo na ye doudou. Iya ye doudou na ye dune ye kitalau bwayabwaya kalona wa unai, ");
INSERT INTO sbe_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na anelu labui ye kitadi. Kadi kwama posiposidi, na se tutuli Yesu yodi kabahekenona wa unai, hesau kulubawa unai ye tuli na hesau kaegigi unai ye tuli. ");
INSERT INTO sbe_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Maliya se henamaiyei se wane, “Waihiu, matawuwuna saha to ku doudou?” Maliya ye wane, “Yogu guiyau se hai se laehesuwala, na nige kabina ya kata haedi se tole.” ");
INSERT INTO sbe_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Teina hedehedede ta mulina ne unai Maliya ye tolobui, meta Yesu ye kita ye totolo, na nige ye kitalobai meta iya Yesu. ");
INSERT INTO sbe_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ye wane, “Waihiu, saha sabina ku doudou? Yo kaiteya ku wasewasenei?” Maliya yona nuwatu bena koya taupaisowaina, ede ye wane, “Taubada, ena ku hai na ku tolehesuwala meta taba ku hededehemasalaha haedi ku tole, na kabo gonowana ya lau ya hai.” ");
INSERT INTO sbe_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu ye hededelau unai ye wane, “Maliya.” Ede ye kitalau Yesu unai na ye wane, “Laboni!” Kalina Alamaiki unai kaniyona ede taulauhekata. ");
INSERT INTO sbe_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ye hededelau unai ye wane, “Tabu ku kabikabilaoma kaliguwai, matawuwuna yau sola nige ya sae tamagu unai. Na ku lau kagu kahao yodi ku hedehedede meta yau ya seuseuyo Tamagu iya ede Tamamiu, yo yogu Yaubada iya ede hinage yomi Yaubada unai.” ");
INSERT INTO sbe_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya Magadala waihiuna ye lau ede hekahekatao wa yodi ye hedehedede ye wane, “Guiyau wa ya kita!” Yo saha Yesu ye hedededi kalinawai wa hinage ye hedededi. ");
INSERT INTO sbe_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tenem mayadaina ne sabati luwana ne unai mayadai bagubagunana, na boniyaina ne unai kabo hekahekatao wa se tupagogoi numa hesau unai na kawakeda se gudui, matawuwuna ede Dius tauwoyaidi se matausiyeidi. Na Yesu ye laoma ede luwadi wa unai ye tolo na ye wane, “Nuwadaumwali kwa hai!” ");
INSERT INTO sbe_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ye hedede, na mulinawai kabo nimana yo lisilisina wa ye hekitadi. Yona hekahekatao wa yodi Guiyau se kita meta se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu ye hedehededeꞌuyo ye wane, “Nuwadaumwali kwa hai! Yau Tamagu ye hetamaligauma, unai komiu hinage kabo ya hetamaligomiu.” ");
INSERT INTO sbe_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na kabo ye yahuwalau udiyedi na ye wane, “Yaluwa Tabuna kwa hai. ");
INSERT INTO sbe_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ena tamowai hesau yona baꞌaya kwa nuwatugabaei, kabo nuwatugabae ne ye hai, na ena tamowai hesau yona baꞌaya nige kwa nuwatugabaei, taba nige nuwatugabae ne ye hai.” ");
INSERT INTO sbe_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Tomasi, hesana hesau Didimasi yo iya saudoudoi labui wa hesauna, huyana Yesu ye taumasalaha wa iya nige maiyadi. ");
INSERT INTO sbe_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ede hekahekatao hekadi wa se hededelau unai se wane, “Kai Guiyau ka kita!” Na Tomasi ye hededelau hekahekatao hekadiyo wa udiyedi ye wane, “Ena yau nige nimana udiyedi pawati gaidi ne ya kitadi, yo nimagigigu nige ya tole pawati gaidi ne udiyedi, yo nimagu nige ya tole iya lisilisina gaina ne unai, meta taba nige ya kawamamohoi.” ");
INSERT INTO sbe_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sabati kesega mulinawai, hekahekatao wa numa wa unai se tupagogoiꞌuyo na Tomasi meta maiyadi. Keda wa se guduyako, iyamo Yesu ye laoma luwadi wa unai ye tolo na ye wane, “Nuwadaumwali kwa hai!” ");
INSERT INTO sbe_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kabo ye hededelau Tomasi unai ye wane, “Nimagigim ne inai ku tole na nimagu gaidi ta ku kabitonogidi. Yo nimam ne ku heleleyama na lisilisigu ta unai ku kabi. Na tabu ku nuwalabulabui na ku sunuma mo.” ");
INSERT INTO sbe_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi ye hededelau unai ye wane, “Kowa yogu Guiyau yo yogu Yaubada.” ");
INSERT INTO sbe_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ede Yesu ye hededelau unai ye wane, “Ku kitagau, na unai ede ku kawamamohoi. Kaiteyadi nige se kitagau na iyamo se kawamamohoi, siya gonowana se gwauyala.” ");
INSERT INTO sbe_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu laulau gigigigibwalidi gwaudi ye ginaulidi yona hekahekatao wa matadiwai, na teina buka ta unai nige maudoidi ya kulidi. ");
INSERT INTO sbe_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Na saha ya kulidi ta, udiyedi bena kabo kwa kawamamohoi meta Yesu iya Keliso, iya Yaubada Natuna. Na yomi sunuma debadiwai kabo iya hesanawai mauli kwa hai. ");
INSERT INTO sbe_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Teina saha se tubu wa mulidiwai Yesu ye taumasalahaꞌuyo yona hekahekatao wa udiyedi Tibeliya Gabwana dedekanawai. Na yona masamasalaha wa ede doha teina: ");
INSERT INTO sbe_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petelo, Tomasi, hesana hesau ede Didimasi, Natanaela, iya meta magai Kana teha Galili ne tamowaina, Sebedaiyo natunao yo hekahekatao labui hinage, maudoidi ta meta se miyagogoi. ");
INSERT INTO sbe_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na Simona Petelo ye hededelau udiyedi ye wane, “Ya lau ya yama.” Na hekadiyo wa se talam se wane, “Ye namwa, kabo ta lau.” Ede se dobi se lau yodi waga unai se gelu, na tenem boniyaina ne unai meta se yamakasaya. ");
INSERT INTO sbe_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Malatomtom gagilina kabo Yesu nagali wa unai ye totolo, na yona hekahekatao wa nige se kitalobai. ");
INSERT INTO sbe_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu ye yogadobi udiyedi ye wane, “Natuguwao, yama e nige?” Na se hededebui se wane, “Nige saha hesau ina!” ");
INSERT INTO sbe_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ye wane, “Yomi hinaya ne kwa gabalaei waga teha kateyani unai, kabo yama hekadi kwa hekonadi.” Na hinaya wa se gabaei meta nige gonowana se tabeisini, matawuwuna ede yama wa meta se badokalili. ");
INSERT INTO sbe_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na hekahekata Yesu iya ye gadosisikaliliyeiꞌusei wa ye hededelau Petelo unai ye wane, “Iya Guiyaunem!” Huyana Simona Petelo ye lapui meta tenem ne Guiyau, na iya meta taugaibuna, ede yona likwakewa kalekona ye hai ye likwa na ye kausihiyei na ununa ye hesabwayahisi kana dagilolo unai, na ye kamposidobi gabwa unai. ");
INSERT INTO sbe_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na hekahekatao hekadi waga unai wa se hemuliwatani, na hinaya ma yamana wa se niuli se sae, matawuwuna ede siya nagali wa dedekanawai, lohana meta doha nimakala 50. ");
INSERT INTO sbe_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na huyana se lage nagali wa unai meta kaiwa ye kalakalasi se kita. Unai yama, yo dedekanawai meta pwalawa hinage. ");
INSERT INTO sbe_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu ye hededelau udiyedi ye wane, “Yama kwa galaidi wa hekadi kwa baheidima.” ");
INSERT INTO sbe_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ede Simona Petelo ye gelusae na hinaya wa ye tabeisae salagomgom wa unai. Hinaya wa meta yama lakilakidi se hemwayau badodi ede 153. Yama wa se badokalili, na iyamo hinaya wa nige se pulisi. ");
INSERT INTO sbe_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu ye hededelau udiyedi ye wane, “Kwa laoma kwa kaikai!” Na hekahekatao wa nige se nuwabayao bena se henamaiyei se wane, “Kowa kaiteya?” Matawuwuna kabina se kata meta iya yodi Guiyau wa. ");
INSERT INTO sbe_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu ye laoma pwalawa yo yama ye haidi na kadi ye moseidi. ");
INSERT INTO sbe_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu yona toloꞌuyo na mulinawai teina ta meta huya hehaiyonana ye taumasalaha yona hekahekatao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Se kaikaigehe kabo Yesu ye hededelau Simona Petelo unai ye wane, “Simona, Yowane natuna, kowa mamohoi ku gadosisikaliliyeigau, na kabo kam kahao ta?” Petelo ye wane, “Mamohoi, Guiyau, kabina ku kata meta ya gadosisiyeigo.” Kabo Yesu ye wane, “Yogu mamoe ne ku hekaidi.” ");
INSERT INTO sbe_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu ye hededeꞌuyo ye wane, “Simona, Yowane natuna, kowa mamohoi ku gadosisiyeigau?” Iya ye hededebui ye wane, “Mamohoi, Guiyau, kabina ku kata meta ya gadosisiyeigo.” Yesu ye wane, “Yogu mamoe ku kitahetetedi.” ");
INSERT INTO sbe_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hehaiyonana unai Yesu ye wane, “Simona, Yowane natuna, kowa ku gadosisiyeigau?” Petelo nuwana ye kamkamna, matawuwuna ma haiyona meta Yesu iya ye henamaiyei ye wane, “Kowa ku gadosisiyeigau?”, na ye wane, “Guiyau! Ginauli maudoidi kabidi ku kata, yo kabina ku katakalili meta ya gadosisiyeigo.” Yesu ye wane, “Yogu mamoe ku hekaidi. ");
INSERT INTO sbe_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ya hededemamohoi kalimwai: Yom huyahewali unai meta ku bom ku hekalekogo na ku bom yom nuwatu udiyedi ku sae ku dobi. Na yom huyatautaubada unai kabo nimam ku lausinidi na ku heleledi, na tamowai hesau kabo ye hekalekogo na ye woyalaeigo kabalau nige ku henuwa ne unai.” ");
INSERT INTO sbe_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Teina unai Yesu ye hededehemasalaha meta idohagi kabo Petelo ye boita, na yona boita ne unai kabo hedebasae lakilakina ye mosei Yaubada unai. Na kabo Yesu ye wane, “Ku hemuliwatanigau!” ");
INSERT INTO sbe_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na Petelo ye kitabui na hekahekata Yesu iya ye gadosisiꞌusei wa ye kita ye hemuhemuliwatanidi. (Teina hekahekata ta iya kaiteya tauduihasalilau Yesu unai huyakaikaigogo wa unai, na ye wane, “Guiyau, kabo kaiteya kam ye walohai?”) ");
INSERT INTO sbe_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na Petelo tauhemuliwatanidi wa ye kita ede Yesu ye henamaiyei ye wane, “Guiyau, na iya kabo idohagi?” ");
INSERT INTO sbe_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ye hededelau unai ye wane, “Ena ya henuwa bena ye miyamiya ye lau ee kana siga ya uyoma, tabu ku nuwanuwatulau unai. Na kowa bena ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Teina unai ede wasalupolupo ye tadada ye lau kadi kahao se lapui meta bena teina hekahekata ta taba nige ye boita. Iyamo Yesu nige ye wane taba nige ye boita, na ye wane, “Ena ya henuwa ye miyamiya ye lau ee kana siga ya uyoma, tabu ku nuwanuwatulau unai.” ");
INSERT INTO sbe_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Teina hekahekata ta, iya ede yau. Ginauli maudoidi ta ya hededehemasalahadi yo ya kulidobiyeidi. Na kabina ta kata meta yogu hedehedede ta mamohoidi. ");
INSERT INTO sbe_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu meta ginauli gwaudi hinage ye ginaulidi. Ena ginauli maudoidi se kulidobiyeidi, ya nuwatui meta tanoubu maudoina ta lakina nige gonowana bena unai buka maudoidi ne kabatoledi ta lobai. ");
INSERT INTO sbe_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Taubada Teopilo, yogu buka bagubagunana unai ginauli maudoidi Yesu ye ginaulidi yo ye lauhekataedi wa ya kulidobiyeidiko, meta huyana Yesu yona paisowa ye hetubu ");
INSERT INTO sbe_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ye lau ee mayadaina Yaubada iya ye hai na ye sae galewa. Sola nige ye sae galewa, na Yaluwa Tabuna yona gigibwaliyena hededehesanapu ye moseidi yona kaisunuwa tamowaidiyao udiyedi, siya ede yona apostolo. ");
INSERT INTO sbe_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yona boita mulina ne unai Yesu ye taumasalaha yona apostolo udiyedi na kabikabi udoiꞌudoi udiyedi ye hemamohoiyei meta boita unai ye toloꞌuyo na ye mauli. Mayadai 40 solasoladi ne unai ye tautaumasalaha udiyedi na Yaubada yona basileiya hedehededena ye hedehededei. ");
INSERT INTO sbe_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Huya hesau se lagegogoi na yodi kaikaigogo luwana ne unai ye hededelau udiyedi ye wane, “Sola tabu Yelusalema kwa laulaugabaei, na kwa nayanaya ye lau ee tamagu yona hededehesunuma kainauyana ye leyawa kalimiuyena. Doha yau hinage yomiu ya hedehededeko, ");
INSERT INTO sbe_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","meta Yowane waila unai ye hebahebabatiso, na mayadai hisa mo kabo Yaubada Yaluwa Tabuna unai ye hebabatisoigomiu.” ");
INSERT INTO sbe_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Huya hesau kabo Yesu yona apostolo maiyanao yodi lagegogoi gehegehena Olibe kudulina unai na se henamaiyei, “Guiyau, teina mayadai ta unai gonowana ku hemala Isalaela yoma wasawasa, doha beyabeyana yoma wasawasa bagubagunadi?” ");
INSERT INTO sbe_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na Yesu yodi bui ye moseidi ye wane, “Mayadaina yo mahanana meta komiu nige gonowana kabina kwa kata, na tamagu yona gigibwaliyena ye hineliyako. ");
INSERT INTO sbe_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na Yaluwa Tabuna yona huyadobima unai kabo yona gigibwaliyena ye hebayaogomiu. Na komiu kabo tauwasaduwaiyeigau Yelusalema unai, yo Yudeya yo Samaliya udiyedi, yo tanoubu teha maudoina udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu yona hedehedede wa ye hedededi na kabo Yaubada iya ye hai na matadiyena ye sae galewa na yada unai ye tauwadam. ");
INSERT INTO sbe_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iya ye laoko na sola se kaikaikewasae. Nige bayaona na tamowai labui kadi kwama posiposidi se taumasalaha udiyedi ");
INSERT INTO sbe_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","na se wane, “Galili tamowaidi, idohagi to temetai kwa totolo na kwa kaikaikewasae yada ne unai? Yaubada Yesu ye hai ye saeko galewa, na kabo ye dobiꞌuyoma doha yona saesae galewa ne.” ");
INSERT INTO sbe_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na kabo apostolo wa Olibe kudulina se laugabaei se uyo Yelusalema, meta nige kedaloha. ");
INSERT INTO sbe_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yodi kabamiya numana unai se lage kabo se mwalaesae numa wa heisi helabuina unai. Teina hesadiyao ede: Petelo, Yowane, Yamesi, Andeleya, Pilipo, Tomasi, Batolomaiyo, Mataiyo, Yamesi Alepaiya natuna, Simona Tauhaikabi yo Yuda Yamesi natuna. ");
INSERT INTO sbe_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maudoidi ne nuwadi kesega na huya maudoina se miyagogoi na se tapwatapwalolo, na sinesineo hekadi maiyadiyao, yo Maliya Yesu sinana, yo hinage Yesu kana kahao. ");
INSERT INTO sbe_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tenem mayadaidi ne udiyedi kabo yodi koigogo hesau unai taukawamamohoi badodi 120 se laomagogoi, kabo Petelo ye tolo na ye hedehedede ");
INSERT INTO sbe_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ye wane, “Kagu kahao, huyana ye lohakalili na Yaluwa Tabuna nuwatu ye mosei Dawida unai na ye hedede meta Yudasi kabo Yesu tauhaina ye woyaidi. Na iya hedehedede wa ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iya meta kada kaha hesau yo tauhaisagusagu yoda paisowa ta unai. ");
INSERT INTO sbe_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na iyamo yababa wa ye ginauli. Na yababa wa maisana monina ye hai na unai tano hesau ye hemaisa. Temenai ye beku ede bogana ye talupulisi na sinaena ye tatapesa. ");
INSERT INTO sbe_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yelusalema unai taumiya maudoidi wasana wa se lapui ede tano wa hesana se tole Akeledama, kaniyona ede ‘kwasina tanona’. ");
INSERT INTO sbe_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Same bukana unai Dawida ye kuliyako, ‘Taba yona numa ne nige tamowaina, yo nige gonowana hesau unai ye miya,’ yo hinage, ‘Yona paisowa kabo tamowai hesau ye hai.’ ");
INSERT INTO sbe_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Unai taba tamowai hesau ta kaisunuwai. Tamowaina ne bena maiyada huya maudoina, yo Guiyau Yesu maiyada ta sae yo ta dobi, ");
INSERT INTO sbe_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","meta huyana Yowane Yesu ye hebabatisoi unai ye hetubu, ye lau ee Yaubada Yesu ye hai ye sae galewa. Kabo iya yo kita ta hemala Yesu yona toloꞌuyo tauhededehemasalahana.” ");
INSERT INTO sbe_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kabo tamowai labui se hetolodi ede Yosepa hesana hesau Basabasi (yo hinage se katai Diyasitasi), yo Mataiyasi, ");
INSERT INTO sbe_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","na se tapwalolo se wane, “Guiyau, tamowai maudoidi nuwadi kabidi ku katakalili. Unai tamowai labui ta udiyedi kaiteya ku kaisunuwai na ku hemasalahayama. ");
INSERT INTO sbe_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","To iya ye hemala apostolo hesau Yudasi lauhedamaina, matawuwuna ede Yudasi yona paisowa ye laugabaei, na ye lauko yona kababawa unai.” ");
INSERT INTO sbe_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Unai tamowai labui wa se kaisunuwaidi ede kaisunuwa wa ye lau Mataiyasi ye hai. Unai kabo iya apostolo saudoudoi-kesega (11) wa kadi kaha hesau. ");
INSERT INTO sbe_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na kabo Pentekosi mayadaina ne unai meta taukawamamohoi maudoidi se lagegogoi numa kesega unai. ");
INSERT INTO sbe_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Makesega na dagugu lakilakina galewa ne unai ye dobima doha yaumailakilaki ye lotalu. Yodi kabamiya numana wa meta dagugu ye hemwayau. ");
INSERT INTO sbe_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na ginauli hesau se kita kana kao doha kaiwa kalapulupululuna ye dobima na ye tatagwaligwali ede ye talu tamowai kesega kesega unai. ");
INSERT INTO sbe_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na Yaluwa Tabuna maudoidi wa ye hemwayaudi na yona gigibwaliyena se hetubu kalina udoiꞌudoi udiyedi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na Pentekosi mayadaina hesabana ede tanoubu teha udoiꞌudoi udiyedi Dius tamowaidi se laoma Yelusalema, meta siya yodi laugagayo taumiyawatanidi ma nuwamaudoidi. ");
INSERT INTO sbe_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Huyana dagugu wa se lapui meta bodalakilaki se lagegogoi na tausunuma wa yodi hedehedede se lapulapuidi meta se nuwapwanopwano, matawuwuna ede taulaoma maudoidi kalinadi udoiꞌudoi udiyedi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Siliyata yo nuwapwanopwanoyena se wane, “Teina tauhedehedede ta Galili tamowaidiyao. ");
INSERT INTO sbe_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Idohagi to maudoida ta lapulobai meta kalinada mamohoidi udiyedi se hedehedede? ");
INSERT INTO sbe_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kita meta Patiya, Mediya yo Elama, Mesopotamiya, Yudeya yo Kapadosiya, Pontasi yo Eisiya, ");
INSERT INTO sbe_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pilidiya, Pampiliya yo Aikupito tamowaidiyao. Hekadiyo Libiya tehana Sailini dedekanaena se laoma. Hekadi meta taumana Loma unai se laoma, ");
INSERT INTO sbe_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","siya meta Dius yo hinage dagela tamowaidiyao se nuwabui na se patulau Dius bodadi udiyedi. Na hekadi meta Kiliti bwanabwanaluwana yo Alabiya tamowaidiyao. Na iyamo yodi hedehedede ta lapuidi meta kalinada udiyedi Yaubada yona laulau namwanamwadi se hededehemasalahadi.” ");
INSERT INTO sbe_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na se noko, yo nuwadi se pwanopwano, na se bom se henahenamaiꞌuyoidi, “Teina meta kaniyona ede saha?” ");
INSERT INTO sbe_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na hekadiyo meta taukawamamohoi wa se talatalawasiyeidi se wane, “Tamowai ta nuwana se numayauyaule!” ");
INSERT INTO sbe_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na kabo Petelo yo apostolo hekadiyo saudoudoi-kesega wa se tolo na kalinalakilaki unai Petelo ye hedehedede ye wane, “Yogu hali Dius, yo Yelusalema unai taumiya, kwa lapulapui na ginauli maudoidi ta kaniyodi kabo ya hededehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Teina tamowai ta meta nige se numayauyaule matawuwuna ede teina ta meta sola ma malatomtomna. ");
INSERT INTO sbe_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Saha se masalaha kwa kitadi ta meta peloweta Yoela ye hededediko, ");
INSERT INTO sbe_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Yaubada ye wane, “Mayadai gehegehediyao udiyedi kabo Yaluwagu ya inidobiyei tamowai maudoidi udiyedi. Natumiyao loheloheyao yo sinesineo kabo se hededepeloweta. Yomi hewahewaliyo kabo tautau tabudi se kitadi. Yomi tautaubadao meta kabo kenosuwai tabudiyao se kenosuwaiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yo hinage kabo Yaluwagu ya inidobiyei yogu heyayai tauginaulidi tatao yo sinesineo udiyedi na kabo se hededepeloweta. ");
INSERT INTO sbe_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Yada ne unai kabo laulau gigigigibwalidi se masalaha. Mahana kabo ye masigili na nawalai kabo ye bui doha kwasina. Na kaiyaulina unai kabo hekihekinoi se masalaha, meta kwasina, kaiwa, yo kasu lakilakina. Mulina ne unai Guiyau yona mayadai wasawasana yo didididigana kabo ye lage. ");
INSERT INTO sbe_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na kaiteyadi se yogasae Guiyau unai, meta kabo ye gilihaidi.” ’” ");
INSERT INTO sbe_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petelo yona hedehedede wa ye tubei ye wane, “Isalaela tamowaidiyao, kwa lapulapui! Komiu kabina kwa kata meta Yesu Nasaleta tamowaina laulau gigigigibwalidi ye ginaulidi kalimiuyena. Laulau wa udiyedi Yaubada ye hemasalaha yo ye hemamohoiyei meta iya Yesu ye hetamaliyama. ");
INSERT INTO sbe_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Teina tamowai ta meta Yaubada ye hineli yo ye kaisunuwanonohaiyako na ye mosegabaei kalimiuyena. Na komiu yomi nuwatuyena dagela tamowaidiyao kwa haidi na maidamiyao kwa hesataulo, na ye boita. ");
INSERT INTO sbe_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Na Yaubada iya ye gilihai boita unai na ye hetoloꞌuyoi, matawuwuna boita nige gonowana Yesu ye kabihekahini. ");
INSERT INTO sbe_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawida hinage Yesu hedehededena ye hedehedede ye wane, ‘Huya maudoina Guiyau ya kitakita. Iya nimatutuguyena, unai nige gonowana ya matausi. ");
INSERT INTO sbe_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Unai nuwagu ye namwakalili, na ya hedehedede meta ma gwauyalagu, yo taugu ta kabo hinage sunuma yo nuwabayao unai ye miya, ");
INSERT INTO sbe_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","matawuwuna nige gonowana yaluwagu ta ku nuwagabaei Hade unai, yo taba nige yom tamowai tabuna ku talamyei na bwayabwayaena ye pwasa. ");
INSERT INTO sbe_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mauli kedana wa ku hekitagauko, na yau dedekamyena, kabo ku hegwauyalakaliliyeigau.’ ");
INSERT INTO sbe_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kagu kahao, kabina ta katakalili meta kada kulutubu Dawida ye boita na se tole, na mayadai ta unai bwayabwayana ede yoda magai ta unai. ");
INSERT INTO sbe_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawida meta peloweta, na kabina ye kata Yaubada saha ye hededehesunuma yo ye kaigwala, meta kana isimulita tamowaina hesau kabo ye hemala wasawasa doha iya. ");
INSERT INTO sbe_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ginauli saha kabo se tubu Dawida matana ne unai wa ye kitadi, na Keliso yona toloꞌuyo hedehededena ye hedede meta Yaubada nige iya ye nuwagabaei Hade unai, yo tauna nige se pwasa bwayabwayaena. ");
INSERT INTO sbe_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yaubada Yesu ye hetoloꞌuyoi boita unai, na kai maudoimai meta tauhemamohoiyena ede. ");
INSERT INTO sbe_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na iya ye seuyoko Yaubada nimatutunaena ye tuli, na tamana yona hedehededehesunuma Yaluwa Tabuna ye hai na ye inidobiyeiyama kalimaiyena. Iya ede wau teina kwa kita yo kwa lapui ta. ");
INSERT INTO sbe_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kaniyona ede Dawida meta nige ye sae galewa, na iyamo ye hedede ye wane, ‘Guiyau Yaubada ye hededelau yogu guiyau unai, “Nimatutuguyena ku tuli, ");
INSERT INTO sbe_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ye lau ee kam waiunu ya toledi kaem guninaena, se hemala kaem kabatoledi.” ’ ");
INSERT INTO sbe_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Unai, Isalaela tamowaidiyao, maudoimiu bena kwa nuwatulobainamwanamwai, Yesu kwa hesatauloꞌusei wa meta Yaubada iya ye hetolo Guiyau yo Keliso.” ");
INSERT INTO sbe_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hedehedede wa se lapuidi ede se nuwagwali na se henamai Petelo yo apostolo hekadiyo wa udiyedi se wane, “Kama kahao, saha kabo ka ginauli?” ");
INSERT INTO sbe_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kabo Petelo ye hededelau udiyedi ye wane, “Kesega kesega bena ku nuwabui yo ka hebabatisoigo Yesu Keliso hesanaena, unai kabo Yaubada yom yababa ye nuwatugabaeidi, yo yona kainauya Yaluwana Tabuna kabo ku hai. ");
INSERT INTO sbe_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Teina hedehededehesunuma ta Yaubada ye haiyawa komiu yo natumiyao yo dagela tamowaidi, yo kaiteyadi siya hinage Guiyau yoda Yaubada kabo ye yoganeidi meta siya yodi.” ");
INSERT INTO sbe_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na kabo Petelo hedehedede hekadiyo udiyedi ye guguyaidi ye wane, “Kwa nuwabui yo Yesu kwa sunumaei, kabo teina tamowai yabayababadiyao ta udiyedi ye gilihaigomiu.” ");
INSERT INTO sbe_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mayadaina ne unai meta bodalakilaki Petelo yona hedehedede wa unai se kawamamohoi na siya se hebabatisoidi, na badodi ede 3,000 se lusae ekalesiya bodana unai. ");
INSERT INTO sbe_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Se patulau taukawamamohoi wa udiyedi na se hebodakesega. Se lapulapui apostolo yodi lauhekata wa udiyedi yo se koikoigogoi, yo Guiyau yona kaikaigogo henuwaisinina unai se kaikaigogoi, yo se tapwatapwalologogoi. ");
INSERT INTO sbe_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolo wa laulau gigigigibwalidi yo hekihekinoi kadi kao udoiꞌudoi se ginaulidi. Unai tamowai maudoidi Yaubada se matausiyei yo se hededetausaei. ");
INSERT INTO sbe_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Taukawamamohoi wa se lagelagegogoi na yodi gogo se kaikainauyaꞌuyoidi. ");
INSERT INTO sbe_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yodi gogo yo yodi tano hekadiyo se lokunegabaeidi na monidiyao se haidi na kadi boda wa unai tamowai hekadiyao se saguidi. ");
INSERT INTO sbe_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mayadai kesega kesega se lagelagegogoi Numa Tabuna bakubakuna unai. Yo hinage yodi numa udiyedi Guiyau yona kaikaigogo henuwaisinina se ginauli, yo se kaikaigogoi ma gwaugwauyaladi yo ma nuwamaudoidi, ");
INSERT INTO sbe_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","yo Yaubada se hedehedebasaei. Na boda maudoidi taukawamamohoi wa se kitahenamwadi. Na mayadai badobado Guiyau tamowai ye gilihaidi na ye tolelaedi taukawamamohoi bodana wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mayadai hesau meimeilahi yona tehaena tapwalolo mahanana ne unai Petelo yo Yowane se lau Numa Tabuna unai. ");
INSERT INTO sbe_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na Numa Tabuna kawamatana hesana “Keda Namwanamwana” unai meta taubunibuni hesau. Iya sinana ye labasi meta bunibunina, na mayadai maudoina tamowai ta se baheiyama se hetuli kawamata wa unai na ye kaikaibwadamoni taumwalamwalae wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Huyana Petelo yo Yowane bena se mwalae na ye kitadi ede hinage udiyedi ye kaibwadamoni. ");
INSERT INTO sbe_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Taudi labui wa se kitalau iya unai, na Petelo ye wane, “Sola ku kitalaoma kai kalimaiyena.” ");
INSERT INTO sbe_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ede tamowai wa ye kitalau udiyedi, na yona nuwatu bena kabo yona kainauya saha hesau se mosei. ");
INSERT INTO sbe_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Na Petelo ye hededelau unai ye wane, “Yau nige moni hesau kaliguyena, na saha kaliguyena ta meta kabo ya leyawa. Yesu Keliso Nasaleta tamowaina hesanaena ya hededelaowa, ku tolo na ku laulau.” ");
INSERT INTO sbe_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na Petelo ye kabilau tamowai wa nimatutuna unai na ye kabihetolo. Mahanana ne unai kaena tubeidiyao wa se bayao, ");
INSERT INTO sbe_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ede ye tolomwamwayau na ye hetubu ye laulau. Na maiyadi se lusae Numa Tabuna wa unai na ye laulau yo ye kamkamposi na Yaubada ye hedehedebasae. ");
INSERT INTO sbe_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na boda wa iya se kita ye laulau yo Yaubada ye hedehedebasaei ");
INSERT INTO sbe_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na se kitalobai meta iya taukaikaibwada Numa Tabuna kawamatana unai ye tutuli wa, meta se siliyata yo se nokokalili. ");
INSERT INTO sbe_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na kabo taubunibuni se henamwanamwaꞌusei wa Petelo yo Yowane maidanao se hainimakabi na Numa Tabuna wa unai se pesa se lau teha hesauna hesana “Solomona yona Logulogu” unai. Na boda maudoidi saha se tubu wa se kita yo wasana se lapui ede se siliyata na se heloigogoi se lau udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petelo ye kitadi ede ye hededelau udiyedi ye wane, “Isalaela tamowaidiyao, idohagi to kwa siliyatakalili? Yo idohagi to kwa kaikewaigai kana kao doha ka bom yoma gigibwali yo yoma laulau namwanamwana debanaena tamowai ta ye laulau. ");
INSERT INTO sbe_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abelahama, Isako, Yakobo yo kada kulutubu maudoidi yodi Yaubada yona taupaisowa Yesu ye lausini na kabatuli didididigana unai ye tuli. Huyana Yesu sola tanoubu ta unai meta komiu iya kwa mosegabaei na se unuhemwaloi. Pilato ye henuwa bena ye yailigabaei, na komiu kwa hedede meta Yesu nige kwa henuwa. ");
INSERT INTO sbe_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tamowai tabuna yo dudulaina kwa subu na kwa kaibwada bena taba taukaikaiunu wa ye yailigabaei. ");
INSERT INTO sbe_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mauli wuwuna tamowaina kwa unui, na boita unai Yaubada iya ye hetoloꞌuyoi, na tauhemamohoiyena ede kai. ");
INSERT INTO sbe_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tamowai maiyada ta totolo ta kwa kitalobai meta iya taubunibuni wa. Na Yesu iya ye hebayao matawuwuna ede Yesu ka sunumaei. Mamohoi, yoma sunuma Yesu unai debanaena tamowai ta ye namwanamwa matamiuyena. ");
INSERT INTO sbe_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Na kehaguwao, kabina ya kata meta komiu yo tauwoyaigomiu Yesu nige kabina kwa kata meta iya Keliso ede, unai iya kwa unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na teina laulau ta udiyedi meta Yaubada kalinana peloweta se hededenonohaidiko wa se laoma se mamohoi, doha ye wane Keliso meta kabo ye kamkamna. ");
INSERT INTO sbe_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Unai taba kwa nuwabui na kwa lau Yaubada unai, na yomi yababa kabo ye deuligabaedi yo yaluwamiu ye hehauhaudi ");
INSERT INTO sbe_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na yona kaisunuwa tamowaina Keliso ye hetamali ye uyowa kalimiuyena, tamowaina ede Yesu. ");
INSERT INTO sbe_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Na Yesu sola kabo ye miya galewa ne unai kana siga Yaubada ye hetubu bena ginauli maudoidi ye hehauhauꞌuyoidi, doha beyabeyana ye hedehededehesunuma yona peloweta tabudiyao yodi hedehedede udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Doha peloweta Mose ye hedede ye wane, ‘Guiyau Yaubada kabo luwamiuyena peloweta hesau ye kaisunuwai doha yau. Kwa lapulapulau yona hedehedede maudoidi udiyedi! ");
INSERT INTO sbe_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ena kowa kaiteya nige ku lapulapulau peloweta ne unai meta kabo Yaubada yona tamowai luwadiyena ye boligabaego na ye tolehesuwalakaliliyeigo.’ ");
INSERT INTO sbe_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yo hinage Samuwela unai ye hetubu ye laoma meta peloweta maudoidi ginauli sahasahadi se tubutubu mayadai ta udiyedi meta se hededebagunaidiko. ");
INSERT INTO sbe_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yo hinage Yaubada yona talam ye ginauli na ye hededehesunuma Abelahama unai ye wane, ‘Kam isimulita kabo tanoubu ta tamowaidiyao yodi kabanamwa.’ Peloweta yodi hedehedede wa yo Yaubada yo Abelahama yodi talam wa kaniyodi tauhaidi ede komiu kadi isimulita. ");
INSERT INTO sbe_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Huyana Yaubada yona heyayai tauhaina ye hetolo meta ye hetamalibagunaiyawa komiu Dius tamowaidiyao kalimiuyena, na unai ye henuwa bena ye hededehenamwagomiu yo ye saguigomiu bena yomi miyamiya kwa buidi na yomi laulau yabayababadi kwa hekaiyawasidi.” ");
INSERT INTO sbe_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petelo yo Yowane sola ma hedehedededi boda wa udiyedi na taukaitalasam hekadi yo Numa Tabuna yona polisi kadi tanuwaga yo Sadusiya tamowaidiyao hekadi se lage. ");
INSERT INTO sbe_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Se koipilikalili matawuwuna apostolo labui wa se lauguguya na se lauhekata tamowai wa udiyedi meta Yesu boita unai ye toloꞌuyoko, yo tauboiboita kabo hinage boita unai se toloꞌuyo. ");
INSERT INTO sbe_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Se haidi, na mahana ye laoko ede se toledi numatutuguduyena ye lau ee mala ye tom. ");
INSERT INTO sbe_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na iyamo Petelo yona lauguguya wa taulapuina tamowaidiyao gwaudi meta se kawamamohoi. Na loheloheyao taukawamamohoi maudoidi badodi ye sae ede nuwana 5,000 ye lobai. ");
INSERT INTO sbe_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mala wa ye tom meta Dius tauwoyaidi yo tamowai lakilakidiyao yo laugagayo taulauhekataena tamowaidi se lagegogoi Yelusalema unai. ");
INSERT INTO sbe_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Luwadi ne unai meta taukaitalasam saesaena Anase, yo Kaiyapasi, Yowane, Alekisenda yo taukaitalasam saesaena kehanao tatao hekadiyo. ");
INSERT INTO sbe_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Se hedede meta Petelo yo Yowane se woyaidima na se hetolodi duwaduwali wa unai, na se henahenamaiyeidi se wane, “Kaiteya yona gigibwali yo hesana unai laulau ta kwa ginauli?” ");
INSERT INTO sbe_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yaluwa Tabuna Petelo ye hesibasiba ede ye hededebui ye wane, “Tauwoyawoya yo babadao! ");
INSERT INTO sbe_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kwa helauhetalagai laulau namwanamwana ka ginauli taubunibuni wa debanaena. Na kwa henuwa bena kabina kwa kata idohagi na ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Unai bena ya hemasalaha kalimiuyena yo Isalaela maudoidi udiyedi: Tamowai ta matamiuyena ye totolo ta, iya Yesu Keliso Nasaleta tamowaina yona gigibwaliyena ye namwanamwa. Yesu meta kwa hesataulo na ye boita, na Yaubada iya ye hetoloꞌuyoi boita unai. ");
INSERT INTO sbe_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na kulikuli tabuna unai Yesu hedehededena ta hasili ye wane, ‘Iya meta weku taukabinuma se subuꞌusei wa, na iyamo ye hemala kabakabinuma wekuna namwanamwana yo saesaekalilina.’ ");
INSERT INTO sbe_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nige tamowai hesau gonowana ye hemaulida, matawuwuna kaiyaulina ta unai Yaubada nige hesa hesau ye leyama unai kabo gonowana ye gilihaida.” ");
INSERT INTO sbe_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tauwoyawoya wa Petelo yo Yowane se kitadi se hedehedede ma nuwabayaodi, yo hinage kabina se kata meta siya tamowaigaibu nige se sonoga, meta se siliyata. Na se nuwatulobai meta taudi labui wa Yesu tauhemuhemuliwatanina. ");
INSERT INTO sbe_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na nige gonowana saha hesau se hedede, matawuwuna ede tamowai se henamwanamwaꞌusei wa Petelo yo Yowane maiyadi se totolo. ");
INSERT INTO sbe_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na se hededelau udiyedi Sunedeli numana wa se pesagabaei se lau dagela, na kabo se bom se koitalaliu ");
INSERT INTO sbe_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","se wane, “Kabo saha ta ginauli tatao ta udiyedi? Yelusalema maudoina unai meta laulaugigibwali saesaena se ginauli wa kabina se katako, na nige gonowana ta uhalaei. ");
INSERT INTO sbe_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na sunuma ta hedehededena bena ta hekaiyawasi tabu ye laki ye lau boda udiyedi. Unai kabo ta hededebayao yodi labui ta udiyedi tabu Yesu hesanaena se hedehededeꞌuyo tamowai hesau unai.” ");
INSERT INTO sbe_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na kabo se yoganeiꞌuyoidima na se hededelau udiyedi bena tabu Yesu hesanaena se hedehedede yo se laulauhekata. ");
INSERT INTO sbe_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Na Petelo yo Yowane se hedede se wane, “Komiu kwa bom kwa hineli saha ye dudulai Yaubada matanaena, yomi hedehedede ta ka lauwatani o Yaubada? Taba Yaubada mo ka kawakabiyei! ");
INSERT INTO sbe_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Unai nige gonowana ka mwanomwanou, na ginauli namwanamwadi ka kitadi yo ka lapuidi wa kabo ka hededehemasalahadi.” ");
INSERT INTO sbe_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na kabo tatao lakilakidiyao wa apostolo wa se hededehemahematausidi na se hetamalidi se lau. Na nige keda hesau se lobai taba unai kabo se hekamkamnadi, matawuwuna laulau saha ye tubu wa unai ede tamowai maudoidi Yaubada se hedehedebasaei. ");
INSERT INTO sbe_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yodi hedehedebasae kaniyona ede taubunibuni se henamwanamwaꞌusei wa yona bolimai meta 40 ye laugabaeiyako. ");
INSERT INTO sbe_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Huyana Petelo yo Yowane se hededegabaedi ede se uyo kadi boda wa udiyedi, na taukaitalasam tauwoyaidi yo tamowai lakilakidiyao yodi hedehedede wa se hededehemasalahadi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na wasa wa se lapui ede taukawamamohoi maudoidi ma nuwakesegadi se tapwalologogoi se wane, “Guiyau saesaekalilina, kowa galewa, tanoubu, gabwa, yo ginauli maudoidi tauginaulidi. ");
INSERT INTO sbe_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yaluwa Tabuna yona hekata unai yom heyayai tauhaina kama kulutubu Dawida ye hedede ye wane, ‘Idohagi to dagela tamowaidiyao se koipilikalili, yo boda lakilakidiyao nuwanuwatu yabayababadi se koitalaliugaibuidi? ");
INSERT INTO sbe_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tanoubu wasawasadiyao se nonoha, yo tauwoyawoya se lagegogoi bena Guiyau se lului yo se haikabi yona kaisunuwa tamowaina unai.’ ");
INSERT INTO sbe_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ye mamohoikalili, Heloda yo Pontiusi Pilato yo Isalaela yo dagela tamowaidiyao maudoidi se tupagogoi magai ta unai bena yom heyayai tauhaina tabuna Yesu unai se haikabi. Iya ede yom kaisunuwa tamowaina. ");
INSERT INTO sbe_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Saha se ginauli wa meta yom gigibwaliyena beyabeyana ku hinelinonohaiyako meta kabo ye tubu. ");
INSERT INTO sbe_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Unai ede ka kaibwadaigo, Guiyau, bena yodi hedehededehemahematausi wa ku nuwatuidi na yom taupaisowa ta ku hebayaodi bena wasam se duwai ma nuwabayaodi. ");
INSERT INTO sbe_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimam ku heleledobiyeiyama na ku hegigibwalidi to taukasiyebwa se henamwanamwadi yo laulau gigigigibwalidi se ginaulidi yom heyayai tauhaina tabuna Yesu hesanaena.” ");
INSERT INTO sbe_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tapwalolo wa ye gehe meta yodi kabakoigogo numana wa ye nukunuku na Yaluwa Tabuna ye hemwayaudi, na kabo se lau Yaubada wasana se duwai ma nuwabayaodi. ");
INSERT INTO sbe_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Taukawamamohoi maudoidi wa nuwadi kesega. Yodi gogo wa udiyedi meta se haihaisagusaguꞌuyoidi, na nige hesau ye hedede bena ye bom mo yona gogo. ");
INSERT INTO sbe_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na apostolo wa Guiyau Yesu yona toloꞌuyo boita unai wasana se hedehededehemasalaha ma gigibwalidi. Na Yaubada yona kabinamwa meta taukawamamohoi maudoidi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taukawamamohoi wa udiyedi nige hesau ye deha, matawuwuna ede kaiteyadi yodi tano yo numa, meta se lokuneidi ");
INSERT INTO sbe_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na monidiyao wa se baheidima na se moseidi apostolo wa udiyedi, kabo se soiyeidi kaiteyadi se deha wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Taukainauya hesau meta Yosepa. Iya Lewi kana isimulita hesau, Saipulusi bwanabwanaluwana unai ye laoma. Na apostolo wa hesana se tole ede Banaba, kaniyona ede tauhedehededehebayao. ");
INSERT INTO sbe_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iya yona tano hesau ye lokunegabaei na monina wa ye baheiyama na ye mosegabaei apostolo wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ekalesiya bodadi wa luwadiyena tamowai hesau hesana Ananiya, yo mwanena Sapila. Siya hinage yodi tano tehana se lokunegabaei. ");
INSERT INTO sbe_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mwanena maiyana yodi nuwatu kesega ede monina tehana se kabinuwahi na kabitolena wa se baheiyama se mosei apostolo wa udiyedi. Ede Ananiya ye lau Petelo unai na ye hedede bena moni maudoina ye baheiyamako. ");
INSERT INTO sbe_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na Petelo ye wane, “Ananiya, idohagi to Satani nuwam ne ye hemwayau, na Yaluwa Tabuna ku lupoi bena moni maudoina ede ku baheiyama ta, na iyamo moni wa tehana ede ku kabinuwahiyako. ");
INSERT INTO sbe_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tano ne meta kowa yom, na yom nuwatuyena ku lokunei. Ku lokunei na monina ne hinage kowa yom, ku kabihekahini o ku kainauyaei. Idohagi to nuwamyena ku hineli na ku kailupolupo? Ku hedede bena moni maudoina ku baheiyama ta. Nige tamowai udiyedi ku kailupolupo, na Yaubada unai.” ");
INSERT INTO sbe_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Hedehedede wa ye lapui ede ye gulidobi meta ye boita. Na kabo hewahewaliyo hekadi se laoma ede sinalena wa se suma na se lau se tole bwayabwaya unai. Wasa wa taulapuina maudoidi meta se siliyata yo se matausi. ");
INSERT INTO sbe_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Awa haiyona mulidiyena kabo Sapila ye mwalaesaema, na mwanena wa unai saha ye tubu meta nige kabina ye kata. ");
INSERT INTO sbe_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Petelo ye henamaiyei ye wane, “Yogu ku hedehedede, teina te kowa yo mwanem yomi tano wa maisana kwa hai wa lakina ede?” Ye talam ye wane, “Aa, teina lakina ede.” ");
INSERT INTO sbe_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petelo ye wane, “Ye saha to kowa yo mwanem nuwamiu kesega na Guiyau Yaluwana kwa lupoi? Mahana te unai meta mwanem wa tautolena siya ede kawakeda ne unai, kowa hinage kabo se bahelaeigo.” ");
INSERT INTO sbe_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mahanana ne unai ye gulidobi Petelo matana wa unai na ye boita. Hewahewaliyo wa se mwalaesaema na se kita meta ye boitako, ede se bahehepesalae na mwanena dedekanaena se tole. ");
INSERT INTO sbe_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na saha ye tubu wa unai meta taukawamamohoi bodadi yo wasana taulapuina maudoidi hinage se matausikalili. ");
INSERT INTO sbe_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolo wa laulau gigigigibwalidi se ginaulidi se badokalili tamowai luwadiyena. Taukawamamohoi maudoidi se lagelagegogoi Numa Tabuna tehana hesau hesana Solomona Yona Logulogu unai. ");
INSERT INTO sbe_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Magai tamowaidiyao maudoidi meta se kitahenamwakaliliyeidi, iyamo nige hesau ye nuwabayao bena taba ye lusae boda wa luwadiyena, matawuwuna Dius yodi tauwoyawoya wa se matausiyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na iyamo bodalakilaki, sinesineo yo tatao, se kawamamohoi Guiyau unai, ede se patulau taukawamamohoi bodadi wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Apostolo wa yodi paisowa debanaena ede Yelusalema tamowaidiyao yodi taukasikasiyebwa se baheidima keda wa udiyedi se hekenodi diyadiyali yo dam udiyedi. Se henuwa bena Petelo ye henamwanamwadi, o taba Petelo ye laulau na loguloguna tautauna ye kabikitadi na se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yo hinage magai hekadiyo Yelusalema dedekanaena udiyedi boda se laoma, yodi taukasikasiyebwa se baheidima yo kaiteyadi se kamkamna yaluwa bikibikidi udiyedi, meta maudoidi se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na taukaitalasam saesaena ma kana bodao Sadusiya tamowaidiyao, siya se kaikalomagigilikalili. ");
INSERT INTO sbe_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ede apostolo wa se haidi se toledi numatutuguduyena. ");
INSERT INTO sbe_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na boniyaina ne unai Guiyau yona anelu hesau numatutugudu wa kamwasadiyao ye sokedi na apostolo wa ye woyahepesadi na ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kwa lau kwa mwalae Numa Tabuna bakubakuna ne unai kwa tolo na mauli hauhauna wasana maudoina kwa duwai tamowai udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mala ye tom kabo apostolo wa se mwalaesae Numa Tabuna bakubakuna wa unai se tolo na se hetubu se lauguguya. Na taukaitalasam saesaena ma kana bodao se lage Sunedeli numana unai. Ede Sunedeli tamowaidiyao yo Isalaela yodi babadao maudoidi se yogagogoidi. Na kabo wasa se hetamalilaei bena apostolo wa se woyaidima. ");
INSERT INTO sbe_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na Numa Tabuna yona polisi se lau numatutugudu wa unai meta apostolo wa se dalahaiko, ede se uyo kadi tanuwaga yo taukaitalasam tauwoyaidi yodi se hedehedede ");
INSERT INTO sbe_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","se wane, “Numatutugudu wa guduguduna, yo taukitakitahetetena se totolo, na keda wa ka soke meta nige tamowai hesau ka kita.” ");
INSERT INTO sbe_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Numa Tabuna yona polisi kadi tanuwaga yo taukaitalasam tauwoyaidi wasa wa se lapui meta se nuwapwanopwano yo se nuwanuwatu saha kabo ye tubu. ");
INSERT INTO sbe_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na kabo tamowai hesau ye laoma ede ye wane, “Numatutugudu unai tamowai kwa guduidi wa, meta siya ede Numa Tabuna ne unai se laulauguguya boda udiyedi!” ");
INSERT INTO sbe_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ede polisi kadi tanuwaga wa maiyadi se lau apostolo wa se woyaidima, na nige se kabihenayaidi, matawuwuna ede se matausi tamowai wa udiyedi madai se hekalawekudi. ");
INSERT INTO sbe_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apostolo wa se woyaidima Sunedeli unai se hetolodi na taukaitalasam saesaena wa ye henamaiyeidi ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ka laugagayoigomiu bena tabu Yesu hesana unai kwa laulauhekata, na iyamo yomi lauhekata wa Yelusalema ye hemwayauyako. Yo hinage tamowai ne yona boita giluna bena kwa tole kalimaiyena.” ");
INSERT INTO sbe_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petelo yo apostolo wa se wane, “Nige gonowana tamowai ka kawakabiyeidi, na Yaubada mo ka kawakabiyei. ");
INSERT INTO sbe_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Komiu Yesu kwa hekabasi sataulo unai na ye boita, na boitaena tamadao yodi Yaubada iya ye hetoloꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaubada iya ye hai na ye tole nimatutuna unai. Ye hemala wasawasa yo tauhemahemauli, bena Isalaela ye saguidi na se nuwabui na yodi yababa kabo Yaubada ye nuwatugabaedi. ");
INSERT INTO sbe_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ginauli ta tauhemamohoiyedi ede kai yo hinage Yaluwa Tabuna. Iya ede Yaubada yona kainauya taukawakabiyena udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hedehedede wa se lapui ede se koipilikalili na se henuwa bena se koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na Sunedeli unai Paliseya tamowaina hesau hesana Gamaliyela, iya meta laugagayo taulauhekataena saesaena hesau tamowai maudoidi se hekasisikaliliyei. Iya ye tolo na ye hedede bena mahana kubwakubwa mo tatao ne se hepesadi dagela ne unai. ");
INSERT INTO sbe_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Na kabo ye hetubu ye hedehedede, ye wane, “Isalaela tataodi, bena kwa nuwanuwatunamwanamwa saha bena kwa ginauli tatao ne udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bolimai hisa se lauko Tudasi ye taumasalaha na ye hedede bena iya tamowai lakilakina hesau, ede tamowai badodi 400 se hemuliwatani. Na Loma yodi tauꞌiyala iya se unui na tauhemuliwatanina wa se hailauyedi. Ede yona woyawoya wa nige kaniyona. ");
INSERT INTO sbe_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iya mulinaena, hasiliyawasi huyana ne unai, Yudasi Galili tamowaina ye tolosaema na boda ye woyaidi bena Loma tamowaidiyao se iyalaidi. Na iya hinage se unui, na tauhemuliwatanina wa hinage se hailauyedi. ");
INSERT INTO sbe_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Unai ya hekatagomiu: Tabu saha hesau kwa ginauli taulauhetala ne udiyedi. Kwa kabigabaeidi na se lau. Taba yodi nuwatu yo yodi paisowa ne tamowaigaibu hesau yona nuwatu, kabo ye kaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na ena Yaubada unai ye laoma, meta nige gonowana kwa hekaiyawasidi, na ena kwa hekaiyawasidi meta komiu Yaubada unai tauhaikabi.” (40) Yona hedehedede wa se lauwatani ");
INSERT INTO sbe_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","na apostolo wa se yoganeidi se mwalae. Na se hededelau yodi taupaisowa udiyedi na wipi unai se pidilidi. Na kabo hedehedede bayabayaona se moseidi tabu huya hesau Yesu hesanaena se lauguguyaꞌuyo. Na kabo se kabigabaedi na se lau. ");
INSERT INTO sbe_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolo wa Sunedeli unai se dalahai ma gwaugwauyaladi, matawuwuna Yaubada ye kitahenamwadi na Yesu hesanaena se kamkamna. ");
INSERT INTO sbe_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mayadai badobado Numa Tabuna bakubakuna unai yo hinage taukawamamohoi yodi numa udiyedi yodi lauhekata wa nige ye kaiyawasi yo wasa namwanamwana se duwaduwai meta Yesu iya Yaubada yona kaisunuwa tamowaina ede. ");
INSERT INTO sbe_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mayadaidi ne udiyedi tauhemuliwatani kadi boda wa ye laki ye lau. Luwadiyena, hekadiyo meta Dius tamowaidiyao taukalina Giliki, yo hekadiyo siya taukalina Hebelu. Mayadai kesega kesega meta kai se giyagiyahi, na taukalina Giliki yodi wabuwabu wa se soisoihemulidi. Unai taukalina Giliki wa se hetalapili taukalina Hebelu wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ede apostolo saudoudoi-labui wa tauhemuliwatani maudoidi se yogagogoidi na se wane, “Nige ye namwa bena Yaubada kalinana paisowana ka hekaiyawasi na ka kitalau kai giyahina unai. ");
INSERT INTO sbe_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Unai, kagu kahao, bodamiu ta udiyedi tamowai haligigi-labui kwa kaisunuwaidi, siya meta bena tamowai maudoina yodi hekasisi tamowaidiyao, yo tamowai sibasibadiyao, yo hinage Yaluwa Tabuna ye hemwayaudi. Paisowa ne kabo ka moselaei udiyedi, ");
INSERT INTO sbe_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","na kai apostolo kabo ka kitalau tapwalolo yo wasaduwai mo unai.” ");
INSERT INTO sbe_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Boda maudoina apostolo yodi nuwatu wa se kawanamwanamwaei. Unai ede Setepano se kaisunuwaei, iya tausunumabayao yo Yaluwa Tabuna ye hemwayau. Na kabo Pilipo, Polokolasi, Nikenowa, Timona, Palamenasi, yo Nikolasi. Na Nikolasi iya Antiyoka tamowaina nabada wa unai ye nuwabui ye hemala Dius. ");
INSERT INTO sbe_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kabo tamowai wa se laedi apostolo wa udiyedi, na nimadi se tolesaedi kewadiyena na yodi se tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kabo Yaubada wasana wa ye laki ye lau, na Yelusalema unai Yesu tauhemuliwatanina boda wa ye laki ye lau, yo hinage taukaitalasam bodana lakilakina Yesu se sunumaei yo se kawakabiyei. ");
INSERT INTO sbe_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na Yaubada yona kainauya ye mosei Setepano unai meta ye hegigibwali, ede laulau gigigigibwalidi saesaedi ye ginaulidi boda luwadiyena. ");
INSERT INTO sbe_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na tamowai hekadi maidadi Setepano se haikawayagala, siya meta sunago hesau tamowaidiyao, na sunago wa hesana ede “Yailihai Tamowaidiyao”. Tauhaikawayagala wa yodi kabalaoma ede Sailini yo Alesandiliya yo teha Silisiya yo teha Eisiya. ");
INSERT INTO sbe_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yodi haikawayagala wa unai nige gonowana Setepano se saedikwai matawuwuna ede Yaluwa Tabuna ye hesibasiba. ");
INSERT INTO sbe_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kabo nuwatuwadawadamyena tamowai hekadiyo se nuwakoidi bena kabo se hedede se wane, “Setepano yona hedehedede ka lapui meta Mose yo Yaubada ye hededeheyababadi.” ");
INSERT INTO sbe_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na kabo boda yo yodi tamowai lakilakidiyao, yo hinage laugagayo taulauhekataena nuwadiyao se hesaedi, na Setepano se kabihekahini na se woyalaei Sunedeli unai. ");
INSERT INTO sbe_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na tamowai hekadiyo se woyaidima na hedehededelupolupo maudoidi se hedededi, se wane, “Teina tamowai ta meta huya maudoina Numa Tabuna yo hinage Mose yona laugagayo ye hedehededeheyababadi. ");
INSERT INTO sbe_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Matawuwuna ede yona hedehedede ka lapui meta ye wane, Yesu Nasaleta tamowaina kabo Numa Tabuna ta ye hetatagwaligwali na kabikabi beyabeyadi Mose ye haidima wa kabo ye buidi.” ");
INSERT INTO sbe_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na Sunedeli yona koigogo unai taututuli wa se kaikewadudulai Setepano se kita, na kana kao se kita meta doha anelu. ");
INSERT INTO sbe_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na taukaitalasam saesaena Setepano ye henamaiyei, “Hedehededem ta meta mamohoi?” ");
INSERT INTO sbe_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na Setepano ye wane, “Kagu kahao yo tamaguwao, kwa lapulapui. Yoda Yaubada didididigana ye taumasalaha kada kulutubu Abelahama unai huyana sola ye miyamiya Mesopotamiya unai, nige sola ye dalahai ye lau Halana. ");
INSERT INTO sbe_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yaubada ye hededelau unai ye wane, ‘Kam bodao yo yom magai ku laugabaedi na ku lau magai hesau kabo ya hekitago.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kabo teha Mesopotamiya yo yona magai wa ye laugabaei na ye lau Halana unai ye miya, kana siga Abelahama tamana ye boita. Na kabo Yaubada ye hetamali ye laoma teina yoda magai ta unai ye miya. ");
INSERT INTO sbe_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Na Yaubada nige tano hesau ye mosei Abelahama, nige bena teuna. Na ye hededehesunumamoei meta kabo tano ne ye mosei iya yo kana isimulitao udiyedi. Na huyana ne unai sola nige Abelahama natuna. ");
INSERT INTO sbe_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yo hinage Yaubada ye hededenonohai meta Abelahama kana isimulita kabo se lau tamowai hekadiyo yodi magai unai se miya na menai kabo se hemala laolaoma. Temenai kabo se hemala magai ne tamowaidiyao yodi heyayai tauhaidi na se kabihenayaidi bolimai 400. ");
INSERT INTO sbe_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Na kabo Yaubada yona hedehedede ye tubei ye wane, ‘Magai ne tamowaidiyao kabo ya hekamkamnadi, na mulina ne unai kabo kam isimulita magai ne se laugabaei na se laoma teina teha ta unai kabo se tabaꞌohu kaliguwai.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na kabo pelitome ye mosei Abelahama, meta yodi talam wa se hemamohoiyei. Na kabo Abelahama natuna Isako ye labasi, na mayadai hehaligigi-haiyonana (8) unai ye hepelitome. Na kabo Isako iya natuna Yakobo ye labasi, na iya natunao ede tamadao saudoudoi-labui, na maudoidi se hepelitomedi. ");
INSERT INTO sbe_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yakobo natunao wa kadi kaha Yosepa se kaikalomagigiliyei na se lokunegabaei ye lau Aikupito na ye hemala yodi heyayai tauhaina. Na Yaubada meta iya maiyana ");
INSERT INTO sbe_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na ye gilihai yona pilipili maudoidi udiyedi, yo hinage ye hesonoga. Ede Aikupito yodi wasawasa Palao kabo Yosepa ye tolesae ye hemala Aikupito maudoina yo hinage wasawasa wa yona numa kadi tanuwaga. ");
INSERT INTO sbe_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na kabo hasahasali ye tubu Aikupito yo Kanana udiyedi meta kamkamna lakilakina, na tamadao meta nige gonowana kai se lobai. ");
INSERT INTO sbe_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na Yakobo wasa ye lapui meta Aikupito unai sola kai maudoina, ede kada kulutubu iya natunao ye hetamalidi se lau menai bena kai se hemaisa. ");
INSERT INTO sbe_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yodi huyakaitaumana helabuina unai Yosepa ye hededehemasalahaꞌuyoi kalidiyena meta iya kadi kaha. Menai kabo Palao Yosepa kana bodao kabidi ye kata. ");
INSERT INTO sbe_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na kabo Yosepa kalina ye hetamali tamana Yakobo yo kana bodao maudoidi se laoma Aikupito, badodi meta 75. ");
INSERT INTO sbe_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ede Yakobo ma kana bodao se lau Aikupito unai se miya. Temenai Yakobo ye boita, na kabo tamadao hinage se boita. ");
INSERT INTO sbe_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tauboita wa sinalediyao se baheidi se uyo Sekema magaina unai. Temenai, Abelahama beyabeyana Hamala natunao udiyedi duha hesau ye hemaisa, yona bwayabwaya. Unai kabo se toledi.” ");
INSERT INTO sbe_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Na kabo Setepano ye hedehedede ye wane, “Mayadaina ye hanahanau Yaubada yona hededehesunuma Abelahama unai kabo ye hemamohoiyei meta kabo tano ye mosei kana isimulita udiyedi, ede kada boda Aikupito unai wa meta ye laki ye lau. ");
INSERT INTO sbe_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na kabo wasawasa hesau ye tolo Aikupito ye kitahetete. Na iya meta nige Yosepa kabina ye kata. ");
INSERT INTO sbe_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Teina wasawasa ta kada bodao wa ye lupoidi yo ye hekamkamnadi, na ye lauhelilidi natudiyao labahauhaudi numa dageladi udiyedi se toledi na bena kabo unai se boita. ");
INSERT INTO sbe_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Huyana ne unai Mose se labasi, na iya meta wawaya namwanamwana Yaubada matanaena. Nawalai haiyona udiyedi tamana yona numaena se kitahetete. ");
INSERT INTO sbe_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Huyana Mose se tolehesuwala dagelaena Palao natuna sine ye lobai na ye hai ye kabihelaki ye hemala natuna. ");
INSERT INTO sbe_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose meta Aikupito yodi sonoga yo yodi sibasiba maudoidi se hekata na ye haidi, na ye hemala taukulukulu namwanamwana. ");
INSERT INTO sbe_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Huyana Mose yona bolimai 40, meta nuwana ye hineli bena yona hali Isalaela tamowaidiyao ye kitadi. ");
INSERT INTO sbe_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mayadaina ne unai Mose matanaena Aikupito tamowaina hesau ye tolo na Isalaela tamowaina ye kabihenayai. Ede ye gilihai na Aikupito tamowaina wa ye koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose yona nuwatu bena kana bodao wa kabo se kitalobai meta Yaubada iya ye hepaisowa na kabo ye gilihaidi. Iyamo nige se kitalobai. ");
INSERT INTO sbe_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mayadai hesauna kabo Isalaela tamowaidi labui ye kitadi se haihaikabi, ede ye hededelau udiyedi bena nuwadi ye hededehetaludi ye wane, ‘Tatao, teina ta ma kam kaha. Tabu kwa hewahewaiunuꞌuyoigomiu!’ ");
INSERT INTO sbe_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Na hesauna, kana kaha ye kabihenayaiꞌusei wa, Mose ye kabitepanei na ye hededelau unai ye wane, ‘Kaiteya ye hetologo kama tanuwaga yo tautolehedudulaigai? ");
INSERT INTO sbe_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bena ku koihemwaloigau, doha lahi Aikupito tamowaina ku koihemwaloi wa?’ ");
INSERT INTO sbe_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose hedehedede wa ye lapui ede ye wasabu na Aikupito ye laugabaei ye lau Midiyana unai ye miya, meta ye hemala laolaoma. Menai ye tawasola na natunao loheloheyao labui ye labasidi. ");
INSERT INTO sbe_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bolimai 40 se lau, na Mose meta balabala hesau unai Sinai kudulina dedekanaena. Na anelu ye taumasalaha kaiwa hesau unai, na kana kao doha kaiwa ye kalapululu. ");
INSERT INTO sbe_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose kaiwa wa ye kita ede ye siliyata. Ye sigilau dedekana wa unai bena ye kitanamwanamwaei, na Yaubada kalinana ye lapui ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yau meta kam kulutubu yodi Yaubada, Abelahama, Isako, yo Yakobo yodi Yaubada.’ Mose ye matausi yo ye tabutabubu, na nige ye henuwa ye kaikewalau. ");
INSERT INTO sbe_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na Guiyau ye hededelau unai ye wane, ‘Kam sendolo ne ku haigabaeidi, matawuwuna ede teina meta tano tabuna. ");
INSERT INTO sbe_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kagu bodao ya kitadi meta se kamkamnakalili Aikupito unai. Yodi dou ya lapuidi na ya dobima bena ya gilihaidi. Unai, Mose, kabo ya hetamaligo ku uyo Aikupito.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mose iya tamowaina ede Isalaela tamowaidi se hededehesuwala se wane, ‘Kaiteya ye hetologo kama tanuwaga yo tautolehedudulaigai?’ Na Yaubada yona anelu ye taumasalaha kaiwa kalakalasina wa unai, na Mose ye hetamali ye uyo Isalaela bodadi kadi tanuwaga yo taugilihaidi. ");
INSERT INTO sbe_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iya Aikupito unai Isalaela bodana wa ye woyahaidi, meta laulau gigigigibwalidi ye ginaulidi Aikupito unai yo Gabwa Pulupululuna unai yo hinage balabalaena bolimai 40 luwadiyena. ");
INSERT INTO sbe_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Teina Mose ta, iya ede tamowaina ye hededehemasalaha Isalaela udiyedi ye wane, ‘Yaubada kabo peloweta hesau ye hetamaliyama doha yau. Iya meta kada boda ta unai kabo ye tubusaema.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yo iya tamadao bodadi maiyadi se miya balabalagaibuyena, yo hinage anelu maiyana se hedehedede Sinai kudulina unai. Anelu wa hedehedede maumaulina ye mosei Mose unai bena kabo ye hekawadima kalidaena. ");
INSERT INTO sbe_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Na kada kulutubu nige se henuwa Mose se kawakabiyei, na iya se subu na nuwadi se uyo Aikupito. ");
INSERT INTO sbe_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ede se hededelau Aloni unai se wane, ‘Yoda yaubada ku ginaulidi kabo se kedabagunaida, matawuwuna teina Mose ta Aikupito unai ye woyahaida ta, nige kabina ta kata saha ye tubu kalinawai.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mayadaidiyao ne udiyedi koitau se ginauli kana kao doha bulumakau natuna, na unai se kaitalasam, yo nimadi unai saha se ginauli wa meta unai se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ede Yaubada ye miyasuwalaedi na ye mosegabaedi na mahana, nawalai, yo kipwala udiyedi se tabaꞌohu. Doha peloweta yodi buka unai se kulihemasalahayako: ‘Isalaela tamowaidi, balabalaena kwa sae kwa dobi bolimai 40, na yau kaliguyena kwa kaitalasam e nige? ");
INSERT INTO sbe_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moleki yona kabatabaꞌohu kwa lausini, yo yomi yaubada Lepani yona kipwala hinage, meta koitau kwa bom kwa ginaulidi bena kwa tabaꞌohu udiyedi. Unai kabo ya hetamaligomiu kwa lau Babiloni unai kabo kwa miya.’ ");
INSERT INTO sbe_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Balabalaena tamadao yodi kabalau maudoina unai meta Yaubada kabatabaꞌohuina tentina se bahei maiyadi. Kabatabaꞌohu wa Mose ye ginauli meta tautau Yaubada ye hekita wa unai ye ginauliwatani. ");
INSERT INTO sbe_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Na tamadao Yaubada kabatabaꞌohuina wa se bahei na Yosuwa ye woyaidi se laoma inai na tano ta tamowaidiyao Yaubada ye henakuhepesadi na siya tano ta se hai. Na Yaubada kabatabaꞌohuina wa inai se hepaisowa ye lau ee Dawida yona huyaena. ");
INSERT INTO sbe_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na Dawida meta Yaubada yona nuwanamwa tamowaina, na ye kaibwada Yaubada unai taba ye talam na Yakobo yona Yaubada yona kabamiya numana ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Na numa wa tauginaulina ede Solomona. ");
INSERT INTO sbe_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na iyamo Yaubada saesaekalilina taba nige tatao nimadiyena numa se ginauli unai ye miya. Doha peloweta ye hededeyako ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Yaubada ye hedede ye wane, “Yogu kabatuli ede galewa, na kaegu kabatolena ede tanoubu. Unai numa sahasahana bena ku ginauli yogu kabamiya? Yo haedi bena yogu kabakaiyawasi? ");
INSERT INTO sbe_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Matawuwuna ginauli maudoidi ta tauginaulidi ede yau.” ’” ");
INSERT INTO sbe_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kabo Setepano yona hedehedede wa ye tubei ye wane, “Komiu nuwamiu se kwailolokalili! Nuwamiu yo beyamiu nige kwa hepelitomedi. Komiu doha tamamiyao wa: Huya maudoina Yaluwa Tabuna kwa laukwatakwataei. ");
INSERT INTO sbe_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tamamiyao wa meta peloweta maudoidi se hewaiunudi yo Tamowai Dudulaina yona laoma tauhededehemasalahana tamowaidiyao se unuhemwaloidi. Na komiu hinage Keliso kana kwa walohai na kwa unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Komiu Yaubada yona laugagayo tauhaina ede. Anelu udiyedi ye laoma, na nige kwa kawakabiyei.” ");
INSERT INTO sbe_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Setepano yona hedehedede wa unai Sunedeli numana unai taumiya wa se koipilikalili na kadi kao se heyababadi. ");
INSERT INTO sbe_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na Yaluwa Tabuna Setepano ye hemwayau, na ye kaikewasae galewa ne meta Yaubada yona didiga ye kita, yo Yesu ye totolo Yaubada nimatutuna wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na ye wane, “Kwa kaikewasae, galewa kamwasana ne meta sokesokena, na Tau Natuna ya kita ye totolo Yaubada nimatutuna ne unai.” ");
INSERT INTO sbe_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Setepano yona hedehedede wa unai se yogahigudugudui na beyadiyao se kabiguduguduidi. Na maudoidi nuwadi kesega, se heloi se lau hesabana ");
INSERT INTO sbe_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","na se tabehepesalaei magai wa dagelana unai, na se hetubu se hekalaweku. Na taulauhegilulupolupo wa kadi kwama se haigabaedi na se toledi hewali hesau hesana Saulo kaena wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tatao wa Setepano se hekahekalaweku na ye tapwalolo, “Guiyau Yesu, yaluwagu ta ku hai!” ");
INSERT INTO sbe_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kabo ye tulibono na kalinalakilakiyena ye wane, “Guiyau, tatao ta yodi yababa ta unai tabu ku hegiludi.” Na ye gulidobi ede ye boita. (8:1) Na Saulo Setepano yona boita ye kawanamwanamwaei. ");
INSERT INTO sbe_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mayadaina ne unai Dius tamowaidiyao se hetubu taukawamamohoi bodana wa Yelusalema unai se hekamkamnadi. Ede maudoidi se wasabugwaligwali se lau Yudeya yo Samaliya magaidi udiyedi, na apostolo wa se bom mo se bawabawa. ");
INSERT INTO sbe_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na tausunuma namwanamwadi hekadi se laoma Setepano se bahei se lau se toletoletau yo sabina se dou. ");
INSERT INTO sbe_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na Saulo taukawamamohoi bodadi wa ye hetubu ye kabihenayaidi. Ye lau numa kesega kesega unai tatao yo sinesineo ye tabehepesadi na numatutugudu unai ye toledi. ");
INSERT INTO sbe_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Taukawamamohoi Yelusalema se wasabugabaei wa Yesu wasana se duwaduwai yodi kabalauyena. ");
INSERT INTO sbe_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na Pilipo ye dobi magai lakilakina Samaliya unai, na wasa ye hededehemasalaha meta Yesu Yaubada yona kaisunuwa tamowaina ede. ");
INSERT INTO sbe_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Boda wa laulau gigigigibwalidi ye ginaulidi se kitadi ede se lapulapuinamwanamwa yona hedehedede wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tamowai gwaudi udiyedi yaluwa bikibikidi se pesa na se douyogayogahi, yo hinage tamowai bunibunidi se bado se namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Unai magai maudoina wa se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tamowai hesau hesana Simona Samaliya unai ye bawabawa. Iya taukobakoba hesau, na tamowai maudoidi iya se nokoei. Na ye bom ye hededehesaeꞌuyoi bena iya tamowai lakilakina hesau. ");
INSERT INTO sbe_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samaliya tamowaidi maudoidi yodi nuwatu se lau iya unai, hekadi tamowaigaibu, hekadi tamowai saesaekalilidi, na se hedede se wane, “Iya meta Yaubada yona gigibwali, iya ede ta wane gigibwali lakilakina.” ");
INSERT INTO sbe_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Huya lohalohakalili yona laulau gigigigibwalidi debadiyena se noko, unai se hemuhemuliwatani. ");
INSERT INTO sbe_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na huyana Pilipo Yaubada yona basileiya yo Keliso Yesu wasana namwanamwana ye hedehededei kabo sinesineo yo tatao wa se kawamamohoiyei, na kabo Pilipo ye hebabatisoidi. ");
INSERT INTO sbe_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona hinage ye kawamamohoi ede ye babatiso. Na kabo Pilipo ye hemuhemuliwatani, na Pilipo laulau gigigigibwalidi ye ginaulidi ye kitadi meta ye nokokalili. ");
INSERT INTO sbe_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kabo apostolo Yelusalema unai wasa se lapui meta Samaliya tamowaidi Yaubada wasana se kawamamohoiyei, ede Petelo yo Yowane se hetamalidi se lau kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Apostolo labui wa se lage magai ne unai, ede taukawamamohoi yodi se tapwalolo bena Yaluwa Tabuna kabo se hai. ");
INSERT INTO sbe_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kaniyona ede Yaluwa Tabuna sola nige ye dobima kalidiyena, na Guiyau Yesu mo hesanaena se babatiso. ");
INSERT INTO sbe_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petelo yo Yowane se tapwalolo ye gehe, kabo nimadi se tolesaedi taukawamamohoi wa udiyedi, ede Yaluwa Tabuna se hai. ");
INSERT INTO sbe_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na Simona apostolo wa ye kitadi nimadi se tolesaedi tamowai wa kuludi udiyedi na Yaluwa Tabuna se hai, ede ye hededelau apostolo wa udiyedi bena kabo gigibwali wa ye hemaisa moniyena, ");
INSERT INTO sbe_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na ye wane, “Hinage gigibwali ne kwa haiyama, na kabo nimagu ta ya tolesae tamowai kewadi ne udiyedi na Yaluwa Tabuna se hai.” ");
INSERT INTO sbe_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Na Petelo ye wane, “Idohagi to yom nuwatu bena Yaubada yona kainauya moni unai ku hemaisa. Unai yom moni ne ku hai na ye namwa mo ku mwaloi! ");
INSERT INTO sbe_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nige yom tupwa hesau teina paisowa ta unai, matawuwuna ede Yaubada matanaena nuwam ne nige ye dudulai. ");
INSERT INTO sbe_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ku nuwabui yo yom nuwatu yabayababana ne ku hekaiyawasi, na Yaubada unai ku tapwalolo taba yom nuwatu yabayababana wa ye nuwatugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na ya kitago meta kaikalomagigili ye nuhuligo, yo yababa ye kabihekahinigo.” ");
INSERT INTO sbe_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ede Simona ye hedehededelau Petelo yo Yowane udiyedi ye wane, “Yogu kwa kaibwada Guiyau unai, na ginauli saha kwa hetahetaladi wa kabo taba nige se tubu kaliguyena.” ");
INSERT INTO sbe_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kabo Petelo yo Yowane Guiyau wasana se guguyaei yo se hededehemasalaha magai lakilakina Samaliya unai, na huyana se gehe kabo se dalahai se uyo Yelusalema, na yodi kabalauyena Yaubada wasana se duwai magai hekadiyo udiyedi teha Samaliya unai. ");
INSERT INTO sbe_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kabo Guiyau yona anelu hesau ye hededelau Pilipo unai ye wane, “Ku lau tupwa yawana balabala ne unai na keda ye lau Yelusalema unai na ye dobi Gasa ku lobai.” ");
INSERT INTO sbe_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Unai Pilipo ye dalahai ye lau. Keda wa unai Itiyopiya tamowaina hesau ye lobai. Iya meta yunika, na iya tamowai lakilakina yo gigigigibwalina hesau, Itiyopiya yodi wasawasa sinena Kendeisi yona moni yo gogo hekadi taukitahetetedi. Ye lauko Yelusalema unai Yaubada ye tabaꞌohui, ");
INSERT INTO sbe_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na ye uyoꞌuyo yona magai, meta yona kaliyota unai ye gelu ye laulau na peloweta Aisaiya yona buka ye hasihasili. ");
INSERT INTO sbe_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na Yaluwa Pilipo yona ye hedehedede ye wane, “Ku lau tenem kaliyota ne dedekana ne unai.” ");
INSERT INTO sbe_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ede Pilipo ye heloi ye lau kaliyota wa dedekana ne unai, na tamowai wa kalinana ye lapui peloweta Aisaiya yona buka ye hasihasili. Ede ye henamai ye wane, “Saha ku hasihasili ne nuwam ne unai ye masalaha?” ");
INSERT INTO sbe_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na tamowai wa ye wane, “Idohagi na kabo kabina ya kata? Kabo kaiteya ye hededehesibasibagau?” Ede Pilipo ye kaibwadai na ye mwalaesae kaliyota wa unai maiyana se tuli. ");
INSERT INTO sbe_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na buka ye hasili wa ede teina: Iya se woyai se laei se unui doha mamoe, na ye mwanomwanou doha mamoe natuna ye mwanomwanou na wiyana se bolihai, nige saha ye hedede. ");
INSERT INTO sbe_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iya se toledobiyei, nige yona dudulai hesau se mosei. Nige kana isimulita hesau, matawuwuna yona mauli tanoubu ta unai se hekaiyawasi. ");
INSERT INTO sbe_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yunika wa ye henamai Pilipo unai ye wane, “Taba gonowana yogu ku hedehedede? Peloweta ne meta iya ye bom ye hetahetalaꞌuyoi o tamowai hesau?” ");
INSERT INTO sbe_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na Pilipo Aisaiya yona kulikuli wa unai ye hetubu na Yesu wasana namwanamwana yona ye hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Yodi kabalau wa unai waila kipuna hesau unai se lage. Na yunika wa ye hedehedede ye wane, “Waila ede teina. Taba gonowana ku hebabatisoigau?” ");
INSERT INTO sbe_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kabo ye hedede kaliyota wa se hekaiyawasi. Na se dobi waila wa unai ede Pilipo iya ye hebabatisoi. ");
INSERT INTO sbe_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Waila wa unai se gayosae ede Guiyau Yaluwana Pilipo ye haigabai. Yunika wa Pilipo nige ye kitaꞌuyoi, na iyamo yona kabalau wa unai meta ma gwaugwauyalana. ");
INSERT INTO sbe_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Pilipo ye bom ye taumasalaha Asotasi unai na ye dalahaiꞌuyo Sisaliya hesabana na yona kabalau wa unai Yesu wasana namwanamwana ye wasaduwaiyei magai wa udiyedi. Ye lauguguya ye lau ee Sisaliya unai ye lage. ");
INSERT INTO sbe_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yelusalema unai Saulo sola Guiyau tauhemuliwatanina wa ye hededehemahematausidi bena ye koihemwaloidi. Ye lau taukaitalasam saesaena unai ");
INSERT INTO sbe_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na ye kaibwadai taba yona talam ye ginauli na leta ye kuli na ye mosei Saulo kabo ye laei Damaseko Dius tamowaidiyao ye hekitadi, na ena menai Guiyau tausunumaena hekadi ye lobaidi meta kabo ye haidi ye laedi Yelusalema na ye toledi numatutugudu unai. ");
INSERT INTO sbe_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo ye dalahai ye lau Damaseko hesabana. Magai wa ye hanahanawui, na makesega mala lakilakina galewa ne unai ye sinadobima Saulo kewana ne unai. ");
INSERT INTO sbe_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ede ye gulidobi bwatano wa unai na kalina hesau ye lapui ye wane, “Saulo! Saulo! Idohagi to ku hekamkamnagau ta?” ");
INSERT INTO sbe_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo ye wane, “Guiyau, kowa kaiteya?” Na kalina wa ye hedehededeꞌuyo ye wane, “Yau ede Yesu ku hekamkamnagau ta. ");
INSERT INTO sbe_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ku tolo na ku lau Damaseko, menai kabo tamowai hesau ye hededelaowa saha bena kabo ku ginauli.” ");
INSERT INTO sbe_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo kana bodao wa se siliyatakalili na nige gonowana saha hesau se hedede, matawuwuna kalina wa daguguna se lapui na tamowaina nige se kita. ");
INSERT INTO sbe_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo se kabihetolo na matana ye helaladi, iyamo nige gonowana saha hesau ye kita. Ede se kabinimai na se woyai se lau Damaseko. ");
INSERT INTO sbe_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Menai mayadai haiyona unai nige gonowana saha hesau ye kita, nige kai ye kai, yo nige waila ye numa. ");
INSERT INTO sbe_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaseko unai Yesu tauhemuliwatanina hesau hesana Ananiya. Kenosuwaiyena Guiyau ye hedehededelau unai ye wane, “Ananiya!” Na Ananiya ye wane, “Guiyau, yau ede teina.” ");
INSERT INTO sbe_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na Guiyau ye wane, “Ku tolo! Keda Dudulaina unai ku lau Yudasi yona numa, na menai kabo Tasusi tamowaina hesau hesana Saulo ku kita. Iya ede menai ye tapwatapwalolo. ");
INSERT INTO sbe_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulo yona tapwaloloyena na tautau hesau ya hekita meta tamowai hesau hesana Ananiya kabo ye lau iya unai na nimana ye tolesaedi kewana ne unai, kabo matana wa se namwanamwaꞌuyo.” ");
INSERT INTO sbe_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na Ananiya ye wane, “Guiyau, tamowai se bado udiyedi hedehedede ya lapuidi meta teina tamowai ta Yelusalema unai laulau yabayababadi udoiꞌudoi ye ginaulidi yom tamowai kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na taukaitalasam tauwoyaidi udiyedi gigibwali ye hai na ye laoma Damaseko bena hesamyena tauyogayogasaewa maudoidi kabo ye haidi na ye toledi numatutugudu unai.” ");
INSERT INTO sbe_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Guiyau ye hedehededelau Ananiya unai ye wane, “Ku lau, matawuwuna ede yau yogu kaisunuwa tamowaina ede iya, kabo wasagu ta ye laei dagela tamowaidiyao yo yodi wasawasa udiyedi, yo hinage Isalaela tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na iya kabo ya hekita meta hesagu ta debanaena kabo ye kamkamna.” ");
INSERT INTO sbe_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ede Ananiya ye lau Yudasi yona numa unai ye mwalae na nimana ye tolesaedi Saulo kewanaena na ye wane, “Kagu kaha Saulo! Guiyau Yesu, yom laoma wa unai ye taumasalaha kalimyena wa, iya ye hetamaligau ya laoma kalimwai ta, kabo matam ta se namwanamwaꞌuyo yo hinage Yaluwa Tabuna kabo ye hemwayaugo.” ");
INSERT INTO sbe_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mahanana ne unai ginauli hesau kana kao doha yama konahidi Saulo matana wa udiyedi se bekuhai, na gonowana ye kaikewaꞌuyo. Ede ye tolo na ye babatiso. ");
INSERT INTO sbe_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ye kaikai kabo yona bayao ye haiꞌuyoi. Kabo Damaseko unai Yesu tauhemuliwatanina wa maidadi Saulo se miya mayadai hisa, ");
INSERT INTO sbe_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","na Saulo ye hetubu ye lauguguya sunago udiyedi ye wane, “Yesu meta iya Yaubada Natuna.” ");
INSERT INTO sbe_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Taulapulapui maudoidi wa se siliyata yo se nuwapwanopwano na se wane, “Teina tamowai ta meta Yelusalema unai taukawamamohoi Yesu unai ye kabikabihenayaidi, yo hinage ye laoma inai bena Yesu tauhemuliwatanina ye haidi na ye laedi taukaitalasam tauwoyaidi udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na Saulo yona guguya ye bayao ye lau, na ye hededehemasalahanamwanamwaei meta Yesu iya Yaubada yona kaisunuwa tamowaina. Ede Dius Damaseko unai taumiya wa nuwadiyao se pwanopwano na nige gonowana kalinana se bui. ");
INSERT INTO sbe_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saulo ye babawa huyalohaloha, na kabo Dius tamowaidiyao se koitalaliu bena iya se koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Na iya yodi talaliu wasana ye lapui. Mayadai yo boniyai magai wa kedadiyao se kaikaikewaguduidi bena unai kabo Saulo se unuhemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ede boniyai hesau unai Saulo tauhemuliwatanina hekadiyo se hededelau iya unai na bosaena ye gelu. Kabo magai wa ganana windona unai se hedalolodobiyei na ye dalahai ye lau Yelusalema. ");
INSERT INTO sbe_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo ye lage Yelusalema na ye kaipate bena ye lusae tauhemuliwatani wa udiyedi, iyamo se matausei matawuwuna ede nige se kawamamohoiyei meta iya tauhemuliwatani hesau. ");
INSERT INTO sbe_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na Banaba Saulo ye woyaiyama apostolo wa udiyedi yo ye hededehemasalaha kalidiyena meta Damaseko kedana unai Saulo Guiyau ye kita yo Guiyau ye hededelau iya unai. Yo hinage ye hededehemasalaha meta Damaseko unai Yesu hesanaena ye lauguguya ma nuwabayaona. ");
INSERT INTO sbe_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ede Saulo maiyadi se miya. Na Yelusalema magaina maudoina ye tauhetakikili, na Guiyau hesanaena ye laulauguguya. ");
INSERT INTO sbe_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yo hinage Dius hekadi taukalina Giliki maiyanao se haikawayagala. Na se koitalaliu bena se koihemwaloi. ");
INSERT INTO sbe_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na taukawamamohoi hedehedede wa se lapui ede se woyai se laei Sisaliya na menai se hetamali ye lau yona magai Tasusi. ");
INSERT INTO sbe_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kabo Yudeya, Galili yo Samaliya udiyedi ekalesiya meta nuwadiyao se talu na daumwaliyena se miya. Yaubada yodi sunuma wa ye hebayaodi. Na Guiyau matausina unai se miya yo Yaluwa Tabuna ye henuwabayaodi, ede kadi boda wa ye laki ye lau. ");
INSERT INTO sbe_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na Petelo ye taihile ye lau teha maudoina udiyedi taukawamamohoi ye kaitaumanaidi. Yona taihile wa unai ye lage magai hesau hesana Lida, unai Guiyau yona tamowai ye kitadi. ");
INSERT INTO sbe_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na temenai tamowai hesau bunibunina ye lobai hesana ede Eneyasi. Bolimai haligigi-haiyona (8) unai nige gonowana yona kabakeno ye pesagabaei. ");
INSERT INTO sbe_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petelo ye hededelau Eneyasi unai ye wane, “Yesu Keliso ye henamwanamwago. Ku tolo na yom kabakeno ne ku gwaugogoi.” Mahanana ne unai ye namwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Unai boda maudoidi Lida yo Salona udiyedi taumiya Eneyasi se kita ede se kawamamohoi Guiyau unai. ");
INSERT INTO sbe_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yopa unai tauhemuliwatani sinena hesau hesana ede Tabita (kalina Giliki unai ta wane Dolekasi). Huya maudoina yona laulau se namwa tamowai udiyedi yo taudehadeha ye sagukaliliyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na ye kasiyebwa ede ye boita. Na sinalena wa se deuli na se tole numa wa heisi helabuina bilina hesau unai. ");
INSERT INTO sbe_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida meta Yopa dedekanaena. Na tauhemuliwatani wa wasa se lapui meta Petelo iya Lida unai, ede tatao labui se hetamalidi se lau Petelo unai se wane, “Ku laoma ta laumwamwayau!” ");
INSERT INTO sbe_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ede Petelo maiyadi se lau se lage meta se woyaei se sae bili wa unai. Na wabuwabu hekadi Petelo se tolohetakikili na se doudou yo kadi kwama yo kaleko hekadi Dolekasi ye ginaulidi wa se hekita. ");
INSERT INTO sbe_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petelo maudoidi ye hetamalidi bili wa se pesagabaei, na ye tulibono na ye tapwalolo. Kabo ye kaikewalau Dolekasi unai na ye wane, “Tabita, ku tolo!”, na sinebada wa matana ye helaladi na Petelo ye kita ede ye tolo na ye tuli. ");
INSERT INTO sbe_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kabo Petelo ye kabilau nimana wa unai na ye kabihetolo, na taukawamamohoi yo wabuwabu wa ye yoganeidi se mwalae na se kita meta Dolekasi boita unai ye toloꞌuyoko na ye mauli. ");
INSERT INTO sbe_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yopa unai taumiya maudoidi wasa wa se lapui na tamowai se bado se kawamamohoi Guiyau unai. ");
INSERT INTO sbe_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Petelo kabo Yopa unai ye miya, Simona yona numa unai. Simona kana paisowa ede suisui dahidiyao se kopadi na se moseidi iya ye heꞌaꞌadi yo ye kabinonohaidi. ");
INSERT INTO sbe_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaliya unai tamowai hesau hesana Koniliyasi. Iya meta Loma yodi tauꞌiyala bodana Italiya unai taulaoma yodi sentuliyo hesau. ");
INSERT INTO sbe_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koniliyasi yo yona numa tamowaidiyao Yaubada se hekasisiyei ma nuwakohihaidi. Yona kaikainauya se lakikalili taudehadeha udiyedi, na ye tapwatapwalolo Yaubada unai. ");
INSERT INTO sbe_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mayadai hesau meimeilahi yona tehaena Koniliyasi yona nuwanuwatu unai Yaubada tautau hesau ye hemasalaha unai, meta Yaubada yona anelu hesau ye taumasalaha na ye wane, “Koniliyasi!” ");
INSERT INTO sbe_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na Koniliyasi ye kitalau anelu wa unai meta ye matausi na ye wane, “Guiyau, idohagi?” Anelu wa ye wane, “Yom kainauya taudehadeha udiyedi yo yom tapwalolo se hemala kabahenuhenuwaisini Yaubada matanaena. ");
INSERT INTO sbe_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Unai tatao hekadi ku hetamalidi se lau Yopa unai tamowai hesau hesana Simona Petelo se woyaiyama. ");
INSERT INTO sbe_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iya maiyana heliyam Simona se miyamiya. Simona hesauna ne meta suisui dahidi taupaisowaidi, na yona numa meta gabwa dedekanaena.” ");
INSERT INTO sbe_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anelu wa ye dalahai, kabo Koniliyasi yona tauꞌiyala tamowaina, iya meta tausaguina yo Yaubada tausunumaena hesau, yo hinage yona heyayai tauhaidi labui ye yoganeidi. ");
INSERT INTO sbe_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Saha se tubu wa yodi ye hedehedede na ye hetamalidi se lau Yopa. ");
INSERT INTO sbe_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mayadai helabuina mayamayadailakiyena tatao wa Yopa se hanahanawui. Mahanana ne unai Petelo ye mwalaesae numa kewana ne unai ye tapwalolo. ");
INSERT INTO sbe_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na ye hasali ede ye kaibwada bena kana kai se mosei na ye kai. Kai wa se kabikabinonohai na Yaluwa Tabuna Petelo ye taukasini. ");
INSERT INTO sbe_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ede ye kita meta galewa ye tasoke na ginauli hesau kana kao doha kabobo lakilakina isu hasi ne unai se kabi na se hedalolodobiyeiyama tanoubu ta hesabana. ");
INSERT INTO sbe_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Luwana ne unai meta mwata yo manuwa yo hinage suisui kaekaediyao hasi kadi kao udoiꞌudoi. ");
INSERT INTO sbe_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na kalina hesau ye hededelau unai ye wane, “Petelo, ku tolo! Suisui ta ku koihemwaloidi, ku ligadi na ku kaidi.” ");
INSERT INTO sbe_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na Petelo ye wane, “Taba nige, Guiyau! Yogu mauliyena sola nige suisui bidabidana yo siusiuna hesau ya kai.” ");
INSERT INTO sbe_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na kalina wa ye hedehededeꞌuyo ye wane, “Saha Yaubada ye heꞌaꞌadiko meta tabu ku kawayabayababaedi.” ");
INSERT INTO sbe_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hedehedede wa ye tubu ma haiyona, na kabo kabobo wa se tabehai ye seuyo galewa. ");
INSERT INTO sbe_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petelo sola ye nuwanuwatu tautau wa kaniyona ede saha, na Koniliyasi tamowai ye hetamalidi wa Simona yona numa se lobai ede se lage numa wa kawamatana unai. ");
INSERT INTO sbe_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na se yogasae na se henamai se wane, “Simona, hesana hesau ede Petelo, teina numa ta unai ye miyamiya?” ");
INSERT INTO sbe_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petelo sola ma nuwanuwatuna, na Yaluwa Tabuna ye hededelau unai ye wane, “Simona, tatao haiyona se wasewaseneigo. ");
INSERT INTO sbe_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ku pesa ku dobi na tabu ku kitahinelidi, na maiyamwao kwa lau, matawuwuna ede yau ya hetamalidima.” ");
INSERT INTO sbe_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petelo ye pesa ye dobi na ye hededelau udiyedi ye wane, “Tamowai kwa wasewasenei wa, iya ede yau. Na saha hesabana kwa laoma?” ");
INSERT INTO sbe_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Se wane, “Sentuliyo Koniliyasi ye hetamaligai ka laoma hesabam. Iya meta tamowai namwanamwana Yaubada tauhekasisiyena, yo Dius tamowaidi maudoidi se kitahenamwakaliliyei. Yaubada yona anelu hesau ye hededelau Koniliyasi unai bena taba ye yoganeigo na ku lau yona numa unai, na bena saha ku hedededi na ye lapuidi.” ");
INSERT INTO sbe_vpl VALUES ("AC10_23a","074_10_23a","ACT","10","23a","23a","Ede Petelo tamowai wa ye yogaisinidi. ");
INSERT INTO sbe_vpl VALUES ("AC10_23b","074_10_23b","ACT","10","23b","23b","Mala ye tom ede Petelo maiyadi se dalahai se lau, na Yopa unai taukawamamohoi hekadiyo se hemuliwatanidi. ");
INSERT INTO sbe_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na mayadai helabuina wa unai se lage Sisaliya. Na Koniliyasi kehanao yo kana kahao hekadiyo ye yogagogoidi na yona numa unai Petelo se nayanayai. ");
INSERT INTO sbe_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petelo ye lage ede Koniliyasi ye laoma ye hailobai, na ye tulibono yo ye tabaꞌohu Petelo unai. ");
INSERT INTO sbe_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na Petelo ye kabilau ye kabihetolo na ye wane, “Ku tolo, yau meta tamowai doha kowa.” ");
INSERT INTO sbe_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petelo maiyana Koniliyasi se hedehedede na se mwalai numa kalona wa unai meta bodalakilaki temenai. ");
INSERT INTO sbe_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na Petelo ye hededelau udiyedi ye wane, “Komiu kabina kwa katakalili kai Dius yoma laugagayo meta nige gonowana dagela tamowaidi ka kaitaumanaidi yo maiyamai ka hebodakesega. Na Yaubada ye hekatagau meta tabu tamowai hesau ya kawayabayababaei. ");
INSERT INTO sbe_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Unai huyana wasa ku hetamaliyama meta nige ya laukwatakwata. Na bena ya henamaiyeigo matawuwuna saha to ku yoganeigau ya laoma ta.” ");
INSERT INTO sbe_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ede Koniliyasi ye wane, “Mayadai hasi se lauko huyana ne unai yogu numaena ya tapwatapwalolo meimeilahi yona tehaena, na makesega tamowai hesau kana kwama namanamalina ye taumasalaha matagu wa unai ye totolo ");
INSERT INTO sbe_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na ye wane, ‘Koniliyasi! Yom tapwalolo wa Yaubada ye lapuidi yo yom kaikainauya taudehadeha udiyedi wa ye kitadiko. ");
INSERT INTO sbe_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Unai tamowai hesau ku hetamali ye lau Yopa bena Simona, hesana hesau ede Petelo, ye woyaiyama. Iya ede ye miyamiya Simona suisui dahidi taupaisowaidi yona numa unai. Yona numa ne meta gabwa dedekanaena.’ ");
INSERT INTO sbe_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ede kalina ya hetamalimwamwayauyeiyawa hesabam, na ye namwakalili to ku laoma. Mahana te unai meta maudoimai Yaubada matanaena, na ginauli saha Guiyau ye hedededi kalimyena bena ku hedededi ka lapuidi.” ");
INSERT INTO sbe_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kabo Petelo ye hetubu ye hedehedede ye wane, “Mamohoi ya nuwatulobai meta Yaubada nige ye gadosisihineli. ");
INSERT INTO sbe_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Teha udoiꞌudoi udiyedi tautabaꞌohu Yaubada unai yo yodi laulau se dudulai meta ye henuwadi. ");
INSERT INTO sbe_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Wasa namwanamwana Yaubada ye hetamaliyama Isalaela tamowaidiyao udiyedi wa kabina kwa katako, meta nuwadaumwali kedana ede Yesu Keliso. Iya meta tamowai maudoidi yodi Guiyau. ");
INSERT INTO sbe_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yowane kabina kwa kata meta babatiso hedehededena ye hedehededei. Yo yona huyalauhekata ye lau ye gehe mulina ne unai ginauli sahasaha se tubu Galili yo Yudeya maudoina unai hinage kabina kwa kata: ");
INSERT INTO sbe_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Idohagi Yaubada Yesu Nasaleta tamowaina ye hemwayau Yaluwa Tabuna yo gigibwali unai, yo idohagi Yesu ye takikili na laulau namwanamwadi ye ginaulidi yo tamowai diyabolo yona gigibwali unai taukamkamna wa ye henamwanamwadi, matawuwuna Yaubada iya maiyana. ");
INSERT INTO sbe_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sahasaha ye ginaulidi Dius yodi tano yo Yelusalema unai tauhemamohoiyedi ede kai. Se hekabasi kaiwaena na se koihemwaloi, ");
INSERT INTO sbe_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","na mayadai hehaiyonana unai Yaubada iya ye hetoloꞌuyoi boita unai na ye hetaumasalaha. ");
INSERT INTO sbe_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nige ye taumasalaha tamowai maudoidi udiyedi, na Yaubada yona kaisunuwa tamowaidiyao siya se bom mo iya se kita yo se hemamohoiyei. Tamowaidiyao ede kai, yona toloꞌuyo mulina ne unai iya maiyamai ka numa yo ka kaikaigogoi. ");
INSERT INTO sbe_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na ye hededelaoma bena ka lauguguya tamowai udiyedi yo bena ka hemamohoiyei meta iya Yaubada yona kaisunuwa tamowaina, bena tausilasilawa yo tauboiboita tauhinelidi yo tautolehekasadi. ");
INSERT INTO sbe_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peloweta maudoidi se hededehemasalaha meta Yesu taukawamamohoiyeina maudoidi kabo yodi yababa ye nuwatugabaedi iya hesanaena.” ");
INSERT INTO sbe_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petelo sola ma hedehededena, na Yaluwa Tabuna ye taludobi wasa wa taulapuina maudoidi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dius tamowaidiyao siya taukawamamohoi Petelo maiyanao se laoma wa, se siliyata meta Yaubada yona kainauya Yaluwa Tabuna hinage ye inidobiyei dagela tamowaidi udiyedi, ");
INSERT INTO sbe_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","matawuwuna ede se lapui meta Yaluwa yona hekataena kalina udoiꞌudoi udiyedi se hedehedede yo Yaubada se hedehedebasaei. Kabo Petelo ye hededelau yona hali Dius wa udiyedi ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yaluwa Tabuna se haiyako gonogonowana doha kita. Unai nige gonowana tamowai hesau ye hededenuwahidi tabu babatiso waila unai se haihai.” ");
INSERT INTO sbe_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ede ye hedede se hebabatisoidi Yesu Keliso hesanaena. Na kabo Petelo se kaibwadai maiyadi se miya mayadai hisa. ");
INSERT INTO sbe_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolo yo taukawamamohoi hekadi Yudeya unai taumiya wasa se lapui meta dagela tamowaidi hinage Yaubada wasana se hai. ");
INSERT INTO sbe_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na huyana Petelo ye seuyo Yelusalema meta taukawamamohoi hekadi, siya pelitome tauhaidi, maidadi Petelo se haikawayagala ");
INSERT INTO sbe_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","se wane, “Kowa idohagi to ku lau dagela tamowaidiyao udiyedi na yodi numaena maidamwao kwa kaikai.” ");
INSERT INTO sbe_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Na Petelo ye hetubu ginauli maudoidi ye hededehemasalahanamwanamwaedi kalidiyena, ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Magai Yopa unai ya tapwatapwalolo na Yaluwa ye taukasinigau, ede Yaubada tautau ye hekitagau. Ginauli lakilakina hesau ya kita kana kao doha kabobo lakilakina, isu hasi ne unai se kabi na galewa ne unai se hedalolodobiyeiyama kaliguwai. ");
INSERT INTO sbe_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ya kitalau luwana ne unai meta suisui kaekaediyao hasi kadi kao udoiꞌudoi, suisui kaikaikalasidiyao, yo hinage mwata yo manuwa ya kitadi. ");
INSERT INTO sbe_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na kabo kalina hesau ya lapui ye hedehededelaoma ye wane, ‘Petelo, ku tolo. Ku koihemwaloidi ku ligadi na ku kaidi.’ ");
INSERT INTO sbe_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ya hededebui ya wane, ‘Taba nige, Guiyau! Yogu mauliyena sola nige suisui bidabidana yo siusiuna hesau ya kai.’ ");
INSERT INTO sbe_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kalina wa galewa ne unai ye hedehededeꞌuyo ye wane, ‘Saha Yaubada ye heꞌaꞌadiko meta tabu ku kawayabayababaedi.’ ");
INSERT INTO sbe_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hedehedede wa ye tubu ma haiyona, na kabo kabobo wa se tabehai ye seuyo galewa. ");
INSERT INTO sbe_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mahanana ne unai tamowai haiyona Sisaliya unai se hetamalidima se laoma ee se lage yogu kabamiya numana wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Yaluwa Tabuna ye hededelaoma kaliguyena bena tabu ya kitahinelidi na maiyaguwao ka lau. Na teina kada kahao haligigi-kesega ta hinage maidamaiyao ka lau, na taudi haiyona wa tauhetamalidima yona numa unai ka mwalae. ");
INSERT INTO sbe_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na yomai ye hedehedede idohagi anelu hesau ye taumasalaha yona numa ne unai na ye wane, ‘Kalina ku hetamali ye lau Yopa, Simona, hesana hesau ede Petelo, iya bena ye laoma. ");
INSERT INTO sbe_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iya kabo yom wasa ye leyawa, unai kabo kowa yo kam bodao maudoidi mauli kwa lobai.’ ");
INSERT INTO sbe_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ya hetubu ya hedehedede, na Yaluwa Tabuna ye taludobi udiyedi, doha huya bagubagunana unai ye laoma kalidawai wa. ");
INSERT INTO sbe_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na kabo Guiyau yona hedehedede wa nuwaguyena ye sae, doha ye wane, ‘Yowane waila unai ye hebahebabatiso, na komiu kabo Yaluwa Tabuna unai kwa babatiso.’ ");
INSERT INTO sbe_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Unai, ena Yaubada yona kainauya ye mosei dagela tamowaidi udiyedi doha ede kita taukawamamohoi Guiyau Yesu Keliso unai, meta yau kaiteya na bena Yaubada yona paisowa ya gudugudui?” ");
INSERT INTO sbe_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hedehedede wa se lapui meta yodi haikawayagala wa se hekaiyawasi, na Yaubada se hedebasaei se wane, “Ye masalaha ede Yaubada yona talam ye ginauli meta dagela tamowaidi hinage gonowana se nuwabui yo se mauli.” ");
INSERT INTO sbe_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Huyana Setepano se hekalaweku mulina ne unai hewahewaiunu ye tubu, ede taukawamamohoi wa se hailauyedi. Na hekadi se lau teha Penisiya, hekadi Saipulusi bwanabwanaluwana, yo hekadi se lau magai Antiyoka, na Yesu wasana se duwai Dius mo udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Na hekadiyo, siya Saipulusi yo Sailini tamowaidiyao, se lau Antiyoka na se hetubu Giliki tamowaidiyao udiyedi hinage Guiyau Yesu wasana namwanamwana se lauguguyaei. ");
INSERT INTO sbe_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Guiyau yona gigibwali wa maiyadi, ede bodalakilaki se kawamamohoi yo se nuwabui Guiyau unai. ");
INSERT INTO sbe_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Saha ye tubu wasana wa ye lau ekalesiya Yelusalema unai se lapui. Ede Banaba se hetamali ye lau Antiyoka. ");
INSERT INTO sbe_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Iya meta tamowai namwanamwana. Yaluwa Tabuna iya ye hemwayau, yo yona sunuma ye bayao. Ye lage na ye kitalobaidi meta Yaubada ye hemaulidiko, ede ye gwauyala na ye hededehebayaodi bena se tolobayao ma nuwakohihaidi. Na bodalakilaki se patulau Guiyau unai. ");
INSERT INTO sbe_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na Banaba ye lau Tasusi bena Saulo ye loyai, ");
INSERT INTO sbe_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","na ye lobai ede ye woyai se lau Antiyoka. Na bolimai kesega menai se miya na ekalesiya boda lakilakina maiyadiyao se koikoigogo na se hekatadi. Na Antiyoka unai tamowai se hetubu kabo Guiyau tauhemuliwatanina hesadi se katai Kilisitiyani. ");
INSERT INTO sbe_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Huyadi ne unai peloweta hekadiyo Yelusalema unai se dobima Antiyoka. ");
INSERT INTO sbe_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hesauna hesana Agabasi ye tolo na Yaluwa Tabuna yona gigibwaliyena ye hededenonohai meta hasahasali lakilakina kabo ye tubu Loma yodi kabaloina magaidiyao udiyedi. Hasahasali ne ye tubu meta Loma yodi wasawasa Kolodiyasi yona huyaloina unai. ");
INSERT INTO sbe_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","30","Hasahasali huyana wa unai tauhemuliwatani Antiyoka unai yodi nuwatu se ginauli bena heledi taukawamamohoi Yudeya unai taumiya se saguidi. Na kesega kesega yona bayaoyena saha ye lobai meta yona kainauya ye tole. Kabo Banaba yo Saulo se hetamalidi na kainauya wa se bahelaei Yelusalema na se mosegabaei ekalesiya yodi tamowai lakilakidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Huyana ne unai Heloda wasawasa ekalesiya tamowaidiyao hekadiyo ye haidi bena kabo ye hekamkamnadi. ");
INSERT INTO sbe_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ye hededelau yona tauꞌiyala udiyedi na Yowane kana kaha Yamesi se koihemwaloi kelepa unai. ");
INSERT INTO sbe_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ye kita meta saha ye ginauli wa Dius tamowaidiyao se kitahenamwa, ede hinage Petelo ye hai. Yona huyahaina meta Pwalawa nige Yistina Henuwaisinina unai. ");
INSERT INTO sbe_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na Petelo ye pai na ye tole numatutugudu unai. Na tauꞌiyala boda hasi ye hetolodi, yo udiyedi tatao hasi hasi, na iya se kitakitahetete. Heloda yona nuwatu bena Taukiuli Henuwaisinina mulina ne unai Petelo ye woyahepesa na ye helauhetala boda matadiyena. ");
INSERT INTO sbe_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Unai Petelo numatutugudu unai ye miyamiya, na ekalesiya wa yona se tapwatapwalolo Yaubada unai ma nuwakohihaidi. ");
INSERT INTO sbe_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sola nige lauhetala mayadaina ye lage, na boniyaina ne unai meta Petelo nimana labui ne seni udiyedi se paidi na iyala tamowaidiyao labui duwaduwalidiyena ye kenokeno, yo hinage iyala tamowaidiyao hekadi bili wa kedana se tologudui. ");
INSERT INTO sbe_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Makesega kabo Guiyau yona anelu ye taumasalaha, na mala ye sina bili wa unai. Anelu wa Petelo lisilisina ye koitagu na ye hanoi, ye wane, “Ku tolomwamwayau!” Ede Petelo nimana udiyedi seni wa se bekuhai. ");
INSERT INTO sbe_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na anelu wa ye hededelau unai ye wane, “Kam dagilolo me ku paimomosi yo kam sendolo ku likwadi!” Na Petelo ye ginauliwatanidi. Kabo anelu wa ye wane, “Kam kwama ku likwa, na ku hemuliwatanigau.” ");
INSERT INTO sbe_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petelo anelu wa ye hemuliwatani na numatutugudu wa se pesagabaei. Na saha ye tubutubu wa yona nuwatu bena tautaugaibu ye kita, na nige mamohoina. ");
INSERT INTO sbe_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na keda bagubagunana yo helabuina tautologuduidi wa se laugabaeidi ede keda ye lau magai wa kedana guduna bayabayaona unai se lage. Na ye bom ye tasoke ede se pesa na se sigilau, kabo anelu wa ye tauwadam. ");
INSERT INTO sbe_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kabo saha ye tubu wa Petelo nuwana wa unai ye sae, na ye wane, “Kabo ya nuwatulobai meta mamohoi Guiyau yona anelu ye hetamaliyama na ye gilihaigau Heloda yona gigibwali yo Dius tamowaidiyao yodi nuwatu yababadi maudoidi udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mulina ne unai ede ye lau Yowane sinana Maliya yona numa unai. Yowane hesana hesau se katai Maleko. Na numa wa unai bodalakilaki se lagegogoi na se tapwatapwalolo. ");
INSERT INTO sbe_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petelo numa ganana guduna wa unai ye koikoi ede heyayai tauhaina sinena hesau hesana Loda ye lau keda wa unai na ye henamai ye wane, “Kowa kaiteya?” ");
INSERT INTO sbe_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na Petelo kalinana wa ye lapulobai meta ye gwauyalakalili. Yona gwauyala wa debanaena ede nuwana ye luluhi na keda wa nige ye soke, na ye heloi ye uyo tamowai hekadi wa yodi ye hedehedede ye wane, “Petelo ede dagela ne unai!” ");
INSERT INTO sbe_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Na se hededelau waihiu wa unai se wane, “Ku yauyaulekalili!” Na iyamo ye hedehededeꞌuyo ye wane, “Ya hededemamohoi!” Kabo se wane, “Nuwana Petelo yona anelu meta.” ");
INSERT INTO sbe_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na Petelo sola ma koikoina. Keda wa se soke ede iya se kita meta se siliyata. ");
INSERT INTO sbe_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na Petelo nimana ye lausini ede se mwanou. Na kabo yodi ye hedehedede idohagi Guiyau yona woyawoyahepesana numatutugudu wa unai. Na ye wane, “Saha ye tubu ta bena Yamesi yo kada kahao hekadiyo yodi kwa hedehedede.” Na kabo ye dalahai ye lau teha hesau. ");
INSERT INTO sbe_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mala ye tom meta nuwapwanopwano lakilakina tauꞌiyala tamowaidiyao wa udiyedi, matawuwuna Petelo unai saha ye tubu wa nige kabina se kata. ");
INSERT INTO sbe_vpl VALUES ("AC12_19a","074_12_19a","ACT","12","19a","19a","Na Heloda ye hedede bena se loyanamwanamwaei, iyamo nige gonowana Petelo se lobai. Unai taukitakitahetetena wa ye henamaibuibuidi, na ye hedede meta kabo se koihemwaloidi. ");
INSERT INTO sbe_vpl VALUES ("AC12_19b","074_12_19b","ACT","12","19b","19b","Muliyena Heloda Yudeya ye laugabaei ye lau Sisaliya unai ye miya. ");
INSERT INTO sbe_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heloda meta Taiya yo Sidona tamowaidiyao ye koikoipiliyeidi. Na magai labui wa tamowaidiyao se hebodakesega na se kaipate bena Heloda se kita na se kaibwadai bena nuwadaumwali unai se miya, matawuwuna kadi kai wa iya yona kabaloina unai se laolaoma. Na se lau Heloda yona taupaisowa lakilakina Balasitasi se kita ede ye saguidi na mayadai ye tole kabo se lau wasawasa wa se kita. ");
INSERT INTO sbe_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Yodi kaisunuwa mayadaina wa unai Heloda kana kwama wasawasadi ye likwadi na yona kabatuli unai ye tuli, na ye hedehededelau magai labui wa tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kabo kalinalakilakiyena se hededeyogayogahi se wane, “Teina ta meta yaubada hesau, na nige tamowaigaibu!” ");
INSERT INTO sbe_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mahanana ne unai Guiyau yona anelu Heloda ye koiheguli na mwatamwata se kai na ye mwaloi, matawuwuna nige Yaubada ye hekasisiyei. ");
INSERT INTO sbe_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na huya maudoina Yaubada wasana wa ye laki ye lau. ");
INSERT INTO sbe_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba yo Saulo yodi paisowa Yelusalema unai ye gehe ede maiyadi Yowane, hesana hesau Maleko, se uyo Antiyoka. ");
INSERT INTO sbe_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiyoka unai ekalesiya luwadi wa unai peloweta yo taulauhekata hekadiyo: Banaba, Saulo, Simiyona, iya se katai Duba, Lusiyasi Sailini tamowaina, yo Manaen, iya Heloda wasawasa maiyana se tubusae. ");
INSERT INTO sbe_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Huyana se tabatabaꞌohu Guiyau unai yo se kaikaihudi meta Yaluwa Tabuna ye wane, “Yogu kaisunuwa tamowaidiyao Banaba yo Saulo kwa hetamalidi se lau na yogu paisowa ya moseidiko wa se ginauli.” ");
INSERT INTO sbe_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Se kaihudi yo yodi se tapwalolo na nimadi se tolesaedi taudi labui wa udiyedi na se hetamalidi se lau. ");
INSERT INTO sbe_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaluwa Tabuna Banaba yo Saulo ye hetamalidi ede se dalahai se dobi Selusiya na se gelu se lau Saipulusi bwanabwanaluwana unai. ");
INSERT INTO sbe_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na Yowane meta maiyadi na yodi paisowaena ye saguidi. Se lage Saipulusi magaina hesau hesana Salamisi, na Yaubada wasana se wasaduwaiyei Dius yodi sunago udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Taudi haiyona wa kabo bwanabwanaluwa maudoina se tauhetakikili ye lau ee se lage Paposi. Temenai meta Dius tamowaina hesau se lobai hesana ede Bala-Yesu. Iya meta taukobakoba yo pelowetalupolupo, ");
INSERT INTO sbe_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","yo gabana maiyana se miya. Gabana wa hesana ede Segiusi Paulo, na iya tausonoga hesau. Ye henuwa bena Yaubada wasana ye lapui, unai yona taupaisowa hesau ye hetamali ye lau Banaba yo Saulo hesabadi. ");
INSERT INTO sbe_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na Elimasi – hesa te meta Bala-Yesu hesana kalina Giliki unai, kaniyona ede taukobakoba – ye hededeguduguduidi yo ye kaipate bena gabana ye hekaiyawasi tabu Yesu ye kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na Saulo, meta kalina Giliki unai hesana ede Paulo, Yaluwa Tabuna iya ye hemwayau ede ye kaikewadudulai Elimasi unai na ye wane, ");
INSERT INTO sbe_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Kowa diyabolo natuna, yo laulaududulai maudoidi tauhewaiunudi. Laulaulupolupo maudoidi kalimyena se mwayau. Idohagi to nige ku kaiyawasi na Guiyau yona nuwatu dudulaidi ku toletolebuidi? ");
INSERT INTO sbe_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Unai Guiyau kabo ye hekamkamnago, na matam ne ye hegibudi mahana kubwakubwa, meta nige gonowana mahana dawayana ku kita.” Mahanana ne unai matana se kamumu nige gonowana saha hesau ye kita, na ye kabikabidada taba tamowai hesau ye kabilobai to nimana ne unai ye kabi na ye woyai. ");
INSERT INTO sbe_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Na gabana wa ye nokokalili Guiyau hedehededena wa unai, na saha ye tubu wa ye kita, ede ye kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ma kana kahao Paposi unai se gelu se lau Pega teha Pampiliya unai. Menai, Yowane ye laugabaeidi na ye uyo Yelusalema. ");
INSERT INTO sbe_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na Banaba yo Paulo Pega unai se dalahai na se luwu se sae Antiyoka teha Pisidiya magaina unai. Na Sabatiyena kabo se mwalae Antiyoka yodi sunago unai na se tuli. ");
INSERT INTO sbe_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na tamowai hekadiyo se tolo na Mose yona laugagayo yo peloweta yodi buka se hasilidi ye gehe ede sunago wa babadadi wa yodi taupaisowa se hetamali ye lau Paulo yo Banaba udiyedi na ye wane, “Kama kahao, ena yomi hededehaisagusagu hesau tatao ta udiyedi, gonowana kabo kwa hedehedede.” ");
INSERT INTO sbe_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Unai Paulo ye tolo na nimana ye lausini na kabo ye hedehedede ye wane, “Isalaela tamowaidiyao yo komiu dagela tamowaidiyao Yaubada tauhekasisiyeina, kwa lapulapui. ");
INSERT INTO sbe_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kita Isalaela tamowaidiyao yoda Yaubada, iya tamadao ye kaisunuwaidi. Na huyana kadi isimulitao siya laolaoma Aikupito unai, Yaubada ye kitahetetedi ede kadi boda ye tadada. Na yona gigibwaliyena Aikupito unai ye woyahepesadi ");
INSERT INTO sbe_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","na bolimai 40 balabala wa unai yodi laulau yabayababadi ye nuwakasinidi. ");
INSERT INTO sbe_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanana unai meta basileiya haligigi-labui tamowaidiyao ye unuhemwaloidi na yodi tano ye mosei yona tamowai wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Saha se tubutubu ta meta bolimai badona 450. Mulina ne unai kabo Yaubada yodi tautolehedudulai ye moseidi ye lau ee Samuwela yona huyapeloweta. ");
INSERT INTO sbe_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Na kabo se kaibwada bena yodi wasawasa, ede Yaubada Saulo ye moseidi, Kisa natuna, iya meta Beniyamina kana isimulita hesau, na ye woyaidi bolimai 40, ");
INSERT INTO sbe_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","kabo Yaubada Saulo ye haigabaei. Mulina ne unai Dawida ye kaisunuwaei ye hemala yodi wasawasa. Yaubada Dawida ye hededehemasalaha ye wane, ‘Ya kita meta Dawida, Yese natuna, iya tamowai namwanamwana yau ya henuwa ede. Yogu nuwatu maudoidi kabo ye ginaulidi.’ ");
INSERT INTO sbe_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dawida kana isimulita hesau Yaubada ye kaisunuwai bena Isalaela taugilihaidi, iya ede Yesu. Teina unai Yaubada yona hededehesunuma ye hemamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sola nige Yesu ye laoma na Yowane Babatiso ye lauguguya Isalaela tamowaidiyao udiyedi bena se nuwabui yo se babatiso. ");
INSERT INTO sbe_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na huyana Yowane yona paisowa bena ye gehe kabo ye wane, ‘Yomi nuwatu bena yau kaiteya? Yau nige tamowaina kwa nayanayaiꞌusei wa. Na iya meta muliguyena kabo ye laoma, na yau nige gonowagu taba kana sendolo mainadi ya yailidi.’ ");
INSERT INTO sbe_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kagu kahao, komiu Abelahama natunao yo hinage komiu dagela tamowaidiyao Yaubada unai tautabaꞌohu, bena kwa lapulapui, kabihemauli wasana ta meta ye laoma kita kalidawai. ");
INSERT INTO sbe_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tamowai maudoidi Yelusalema unai taumiya yo yodi tauwoyawoya nige se nuwatulobai meta Yesu ede Yaubada yona kaisunuwa tamowaina, na iyamo peloweta yodi hedehedede Sabati kesega kesega udiyedi se hasihasilidi wa se hemamohoiyeidi na iya se hegilu yo se hekamkamna. ");
INSERT INTO sbe_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nige kana mata hesau se lobai kabo unai se unuhemwaloi, na iyamo se kaibwada Pilato unai taba Yesu ye talamgabaei na ye boita. ");
INSERT INTO sbe_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yesu hedehededena maudoidi peloweta se kulidi wa se hemamohoihegehedi, kabo sataulo unai se haigabaei na se tole bwayabwayaena. ");
INSERT INTO sbe_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Na boita unai Yaubada Yesu ye hetoloꞌuyoi ");
INSERT INTO sbe_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na mayadai 40 solasoladi ne unai ye tautaumasalaha kaiteyadi iya maiyanao Galili unai tausaema Yelusalema wa udiyedi. Unai siya tauhemamohoina ede kada boda Isalaela udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na kai yoma laoma inai meta wasa namwanamwana ta ka leyawa kalimiuyena: Yaubada yona hededehesunuma kama kulutubu udiyedi wa ");
INSERT INTO sbe_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ye hemamohoiyei kadi isimulita kita kalidaena meta Yesu ye hetoloꞌuyoi boita unai. Doha Same helabuina unai se kuli, ‘Kowa yau natugu, mayadai ta unai ya hemala tamam.’ ");
INSERT INTO sbe_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yaubada yona hededehesunuma meta boita unai kabo ye toloꞌuyo nige gonowana ye pwasa bwayabwayaena. Hedehedede ta buka tabuna unai ye hededeyako, ye wane, ‘Yogu hededehesunuma mamohoidiyao ya hededehesunumadi Dawida unai wa kabo ya lediwa kalimiuyena.’ ");
INSERT INTO sbe_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na Same hesau unai ye hemasalaha ye wane, ‘Taba nige yom tamowai tabuna ku talamyei na bwayabwayaena ye pwasa.’ ");
INSERT INTO sbe_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Teina ta meta nige Dawida hedehededena, matawuwuna ede Dawida yona huyaena Yaubada yona nuwatu maudoina ye ginauli ye gehe kabo ye boita, na kana kulutubu bwayabwayadi unai se tole na tauna wa ye pwasa. ");
INSERT INTO sbe_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Na tamowai Yaubada ye hetoloꞌuyoi boita unai wa, iya tauna nige ye pwasa. ");
INSERT INTO sbe_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Unai, kagu kahao, ya henuwa bena kabina kwa kata meta Yesu debanaena ka wasaduwai kalimiuyena meta Yaubada yababa ye nuwatugabaedi. ");
INSERT INTO sbe_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mose yona laugagayo nige gonowana yoda yababa ye haigabaedi. Na kaiteyadi se kawamamohoi iya unai meta se dudulai na nige kabahegiludi hesau. ");
INSERT INTO sbe_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Unai, bena kwa kitakitanamwanamwa saha peloweta se hedehededei wa tabu se tubu kalimiuyena: ");
INSERT INTO sbe_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Komiu tautalatalawasi, kwa kitanamwanamwa, kabo kwa siliyata na kwa boita, matawuwuna yomi huyaena kabo ya hekamkamnagomiu, na taba tamowai hesau yogu nuwatu ta ye hededehemasalaha kalimiuyena, meta nige gonowana kwa kawamamohoiyei.’” ");
INSERT INTO sbe_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sunago wa unai Paulo yo Banaba se daladalahai na tamowai wa se wane, “Ka henuwa bena Sabati hesau taba kwa uyoma hedehedede ta hekadiyo kwa hededeꞌuyoidi.” ");
INSERT INTO sbe_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Koigogo wa ye gehe kabo Dius bodadiyao yo dagela tamowaidiyao Yaubada taukawamamohoiyena maiyadiyao se lau. Na Paulo yo Banaba boda wa se nuwakoidi bena Yaubada yona kabinamwa unai se miyakesegai. ");
INSERT INTO sbe_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabati hesau unai magai wa bodana se lagegogoi bena Guiyau wasana se lapui, na hisahisadi mo se miyasuwala. ");
INSERT INTO sbe_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Huyana Dius tamowaidiyao boda wa se kitadi meta se kaikalomagigili na Paulo se hededeheyababa yo saha ye hedede wa se kawalupolupoei. ");
INSERT INTO sbe_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Na Paulo yo Banaba se hedehededebayao se wane, “Komiu Dius tamowaidiyao, ye namwa mo Yaubada wasana namwanamwana ta yomiu ka hedehededebaguna. Iyamo nige kwa henuwa, na kwa bom kwa toledobiyeiꞌuyoigomiu na mauli nige kana siga kwa laukwatakwataei. Unai kabo ka lau dagela tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Matawuwuna Guiyau yomai ye hedehededeko ye wane, ‘Ya tolego dagela tamowaidiyao yodi dawaya, kalimyena kabo tanoubu tehana maudoina mauli nige kana siga se lobai.’” ");
INSERT INTO sbe_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Dagela tamowaidiyao hedehedede wa se lapui meta se gwauyala yo Yaubada kalinana wa se nokoei yo se kawanamwanamwaei. Na kaiteyadi Yaubada ye kaisunuwaidi bena mauli nige kana siga tauhaina, meta siya se kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na Yaubada wasana wa Antiyoka tehana maudoina ye hetakikili. ");
INSERT INTO sbe_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na Dius tamowaidiyao wa se tolo ede magai wa unai sinesinebadao saesaedi Yaubada tausunumaena yo magai wa babadadiyao se henuwasaedi na Paulo yo Banaba se hekamkamnadi na se hetamalidi magai wa tehana maudoina se laugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ede Paulo yo Banaba kaedi mukalidi se koinihinihiyedi, na magai wa se laugabaei se lau Ikoniya. ");
INSERT INTO sbe_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na Antiyoka Pisidiya magaina unai tauhemuliwatani wa Yaluwa Tabuna ye hemwayaudi yo se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniya unai hinage Paulo yo Banaba se lau Dius yodi sunago unai na yodi hedehedede wa se namwakalili, ede Dius yo dagela tamowaidiyao meta bodalakilaki se kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na Dius hekadiyo, siya nige taukawamamohoi Yesu unai, kabo se tolo na magai wa unai taumiya tamowaidi nige se sunuma Yaubada unai meta se henuwasaedi na taukawamamohoi Yesu unai wa se koipiliyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na apostolo wa menai se bawa huyalohaloha na Guiyau wasana se duwai ma nuwabayaodi. Na Guiyau yona kabinamwa wasana wa ye hemamohoiyei meta gigibwali ye mosei udiyedi na laulau gigigigibwalidi se ginaulidi. ");
INSERT INTO sbe_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na Ikoniya tamowaidiyao maudoidi wa se bom se hebodalabuiyedi, ede hekadi se lau Dius na hekadi se lau apostolo wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na dagela tamowaidiyao hekadi yo Dius tamowaidiyao yodi tauwoyawoya maiyadiyao nuwatu se ginauli bena Paulo yo Banaba se hekamkamnadi yo se hekalawekudi. ");
INSERT INTO sbe_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na taudi labui yodi koitalaliu wa wasana se lapui ede se wasabu se lau Likeoniya magaidiyao Lisitila yo Debi udiyedi. Na magaidiyao wa maudoina se tauhetakikili ");
INSERT INTO sbe_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","na wasa namwanamwana se laulauguguyaei. ");
INSERT INTO sbe_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na Lisitila unai tamowai hesau sinana ye labasi meta kaeyabayababana na nige gonowana ye laulau. ");
INSERT INTO sbe_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ye tutuli na ye lapulapui Paulo yona lauguguya wa unai. Paulo ye kitalau unai ede ye kitalobai meta Yesu ye sunumaei gonowana kabo ye henamwanamwa. ");
INSERT INTO sbe_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na kalinalakilakiyena ye hededelau unai ye wane, “Ku tolo!” Ede tamowai wa ye tolomwamwayau na ye hetubu ye laulau. ");
INSERT INTO sbe_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Paulo saha ye ginauli wa boda wa se kita meta se yogahi na kalina Likeoniya unai se hedehedede se wane, “Yoda yaubadao wa se hemala doha tamowaimolosi na se dobima kalidaena!” ");
INSERT INTO sbe_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banaba hesana se tole Suus, na Paulo Hemesi, matawuwuna ede iya meta tauhedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Suus yona numa tabuna meta magai wa ganana dagelana ne unai. Yona taukaitalasam bulumakau ye woyaidima yo pasa heiheigogoidiyao ye baheidima magai wa kawamatana unai na boda wa maiyanao se henuwa bena yodi kaitalasam se ginaulidi apostolo wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Apostolo labui Banaba yo Paulo yodi nuwatu wa wasana se lapui kabo yodi kaleko se pulisidi na se heloi se dobi ede se lulau boda wa udiyedi na se yogahi se wane, ");
INSERT INTO sbe_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kama bodao, idohagi to doha teina kwa ginauli? Kai meta tamowaigaibu doha komiu. Na wasa namwanamwana ka leyama yo ka hededelaowa bena yomi laulau nige kaniyodi ta kwa tolehesuwaladi na kwa nuwabui Yaubada maumaulina unai. Galewa yo tanoubu yo gabwa yo hinage ginauli maudoidi udiyedi se bawa, ginauli maudoidi ta tauginaulidi ede iya. ");
INSERT INTO sbe_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Beyabeyana meta boda maudoina ye kabigabaedi na se bom nuwadi se lauwatanidi. ");
INSERT INTO sbe_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Na iyamo kabahemasalahana tanoubu ta unai, meta yona kabinamwa ye hekitada, iya ede galewa ne unai nabu ye hetaluyama na yomi koya ye hekinidi, yo kai ye haidiwa na nuwamiu ye henamwadi.” ");
INSERT INTO sbe_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hedehedede ta udiyedi se kaipatebayaokalili boda wa udiyedi, ede se hekaiyawasidi tabu se kaikaitalasamlau kalidiyena. ");
INSERT INTO sbe_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kabo Dius tamowaidiyao hekadi Antiyoka yo Ikoniya unai se laoma ede boda wa se nuwakoidi na Paulo se hekalaweku. Na yodi nuwatu bena ye boitako, ede magai wa unai se niulihepesa se lae dagela. ");
INSERT INTO sbe_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na tauhemuliwatani wa se laoma Paulo se tolohetakikili, na ye tolo ede ye uyo magai wa unai. Mala ye tom kabo Paulo yo Banaba se lau Debi. ");
INSERT INTO sbe_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Debi unai Paulo yo Banaba wasa namwanamwana se lauguguyaei, na tauhemuliwatani bodalakilaki se haidi. Na mulina ne unai se uyo Lisitila, Ikoniya yo Antiyoka teha Pisidiya unai ");
INSERT INTO sbe_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","na magai maudoidi udiyedi tauhemuliwatani wa se hededehebayaodi bena yodi sunuma se tolekesegai Yaubada unai, se wane, “Pilipili yo yababa udoiꞌudoi udiyedi ta kamkamna, na kabo ta lusae Yaubada yona basileiya unai.” ");
INSERT INTO sbe_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na kabo dubu kesega kesega udiyedi Guiyau tausunumaena tamowaidiyao hekadi se kaisunuwaidi yodi tauwoyawoya, na se kaihudi yo yodi se tapwalolo Guiyau unai kabo ye kitahetetedi. ");
INSERT INTO sbe_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kabo teha Pisidiya se laugabaei se uyo teha Pampiliya. ");
INSERT INTO sbe_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wasa namwanamwana wa Pega unai se lauguguyaei na kabo se lau Ataliya. ");
INSERT INTO sbe_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ataliya unai se gelu se uyo Antiyoka teha Siliya magaina wa. Huyana Antiyoka unai yodi kadau wa se hetubu meta ekalesiya tauwoyaidi Paulo yo Banaba yodi se tapwalolo Yaubada unai bena kabo ye kitahetetedi na kabo se lau paisowa wa se ginauli, ye lau ye gehe ede se uyoma. ");
INSERT INTO sbe_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Se lage Antiyoka unai, kabo ekalesiya bodadi wa se yogagogoidima na paisowa maudoidi Yaubada yona gigibwaliyena se ginaulidi wa se hededehemasalahadi, yo idohagi sunuma kedana ye soke dagela tamowaidiyao udiyedi na se kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na menai tauhemuliwatani wa maiyadiyao se miya huyalohaloha. ");
INSERT INTO sbe_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Paulo yo Banaba sola Antiyoka unai na tamowai hekadi Yudeya unai se laoma na se hetubu se lauhekata ekalesiya wa udiyedi se wane, “Nige gonowana Yaubada ye gilihaigomiu kana siga pelitome kwa hai Mose yona kabikabi unai.” ");
INSERT INTO sbe_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na yodi lauhekata wa unai Paulo yo Banaba tamowai wa maiyadiyao se haikawayagalakalili. Debanaena ekalesiya Antiyoka unai Paulo yo Banaba maiyadiyao taukawamamohoi hekadiyo se kaisunuwaidi bena se lau Yelusalema apostolo yo tamowai lakilakidiyao se henamaiyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dubu wa ye hetamalidi se lau Yelusalema ede yodi lau ne unai Penisiya yo Samaliya magaidiyao udiyedi ekalesiya yodi se hedehedede meta dagela tamowaidiyao se nuwabui. Na wasa wa se lapui ede se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Huyana se lage Yelusalema kabo dubu tamowaidiyao, apostolo yo tamowai lakilakidi se hailobaidi, na paisowa maudoidi Yaubada yona gigibwaliyena se ginaulidi wa se hededehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kabo taukawamamohoi hekadi, siya Paliseya kadi boda, se tolo na se wane, “Dagela tamowaidi ne taba se pelitome yo Mose yona laugagayo se miyawatanidi.” ");
INSERT INTO sbe_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ede apostolo yo tamowai lakilakidiyao se lagegogoi na pilipili wa se hetalahedudulai. ");
INSERT INTO sbe_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Se hedehedede huyalohaloha, na kabo Petelo ye tolo ede ye wane, “Kagu kahao, kabina kwa kata meta luwamiu ne unai beyabeyana Yaubada ye kaisunuwaigau kabo dagela tamowaidiyao udiyedi wasa namwanamwana ya lauguguyaei se lapui na se kawamamohoi. ");
INSERT INTO sbe_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yaubada, iya tamowai nuwadiyao kabidi taukata, meta dagela tamowaidi ye haidi na Yaluwa Tabuna ye moseidi gonogonowana doha ye leyama kita kalidaena. ");
INSERT INTO sbe_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Iya nige ye hinelidi, siya yo kita gonogonowada. Na yodi sunuma debanaena nuwadi ye deuliheꞌaꞌadi. ");
INSERT INTO sbe_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Unai, idohagi to Yaubada kwa laukita na bena tauhemuliwatani ne Mose yona laugagayo polohena kwa hebaheidi? Taba nige! Polohe ta kada kulutubu yo kita nige gonowada ta bahei. ");
INSERT INTO sbe_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Na ta kawamamohoi meta yoda Guiyau Yesu yona kabinamwa unai mauli ta lobai, gonogonowana doha siya.” ");
INSERT INTO sbe_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kabo boda wa se mwanou na se lapulapui Paulo yo Banaba udiyedi na se hedehedede idohagi Yaubada yona gigibwali unai laulau gigigigibwalidi hekihekinoidi se ginaulidi dagela tamowaidiyao udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Se hedehededegehe ede Yamesi ye tolo na ye wane, “Kagu kahao, kwa lapulapui. ");
INSERT INTO sbe_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simiyona ye hededehemasalahayako idohagi Yaubada huya bagubagunana unai dagela tamowaidiyao ye nuwatuidi na udiyedi hekadi ye haidi yona tamowai. ");
INSERT INTO sbe_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na Petelo yona hedehedede ta meta peloweta yodi hedehedede unai se hemamohoiyei, doha se kulinonohaiyako se wane, ");
INSERT INTO sbe_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Muliyena kabo ya uyoma na Dawida yona numa ye guli wa ya hetoloꞌuyoi. Ye tatagwaligwali wa kabo ya ginauli yo ya hebayaoꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Debanaena kabo tamowai hekadiyo bena Guiyau se loyai, yo dagela tamowaidiyao kaiteyadi hesagu ya moseidi bena Guiyau se wasenei. Teina ta meta Guiyau kalinana. Iya ginauli maudoidi ta tauginaulidi, ");
INSERT INTO sbe_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","doha ye hededehemasalahadiko nabada wa unai.’” ");
INSERT INTO sbe_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Na Yamesi yona hedehedede wa ye tubei ye wane, “Unai yogu hineli ede teina: Dagela tamowaidiyao se nuwabui Yaubada unai, tabu ta henuwapilipilidi Mose yona laugagayo maudoina unai. ");
INSERT INTO sbe_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Na taba ta kulikulilau udiyedi bena laugagayo hisahisadi mo se lauwatanidi, meta tabu koitau kaitalasamdi kaidiyao se kaikaidi kaniyona ede kai ne se biki, ganaganawali tabu se miyamiyaedi, ena suisui gadona se sipwakiki na ye mwaloi meta tabu se kaikai, yo suisui kwasinadiyao tabu se numanumadi. ");
INSERT INTO sbe_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ye namwa mo laugagayo ta se lauwatanidi, matawuwuna ede huya bagubagunana unai ye laoma yoda huya ta unai Sabati kesega kesega Mose yona laugagayo se hasihasili yo se lauguguyaei magai maudoidi yodi sunago udiyedi.” ");
INSERT INTO sbe_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kabo apostolo yo tamowai lakilakidiyao maiyadiyao dubu maudoina wa se hineli bena se bom yodi tamowai hekadi se kaisunuwaidi na se hetamalidi maiyadi Paulo yo Banaba se lau Antiyoka. Tamowai labui se kaisunuwaidi ede Yudasi (hesana hesau ede Basabasi) yo Sailasi, siya meta tauwoyawoya taukawamamohoi luwadiyena. ");
INSERT INTO sbe_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na leta se kuli na se mosei udiyedi, se wane, “Kai kami kahao apostolo yo tamowai lakilakidiyao yomiu ka kulikuli. Yoma lautoki ka leyawa dagela tamowaidi tausunuma Antiyoka, Siliya yo Silisiya udiyedi taumiya kalimiuyena. ");
INSERT INTO sbe_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ka lapui meta tamowai hekadiyo kalimaiyena se laowa na yodi hedehedede wa unai nuwamiu se hepilipilidi. Tamowai ne kai nige ka hetamalidiwa, na se bom yodi nuwatuyena se laowa. ");
INSERT INTO sbe_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Unai maudoimai yoma talam ka ginauli na tamowai hekadiyo ka kaisunuwaidi na ka hetamalidiwa yoma gadosisi tamowaidiyao Banaba yo Paulo maiyadiyao. ");
INSERT INTO sbe_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Taudi labui ta yodi mauli se talamgabaeidi yoda Guiyau Yesu Keliso yona paisowa debanaena. ");
INSERT INTO sbe_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yoma kaisunuwa tamowaidiyao ede Yudasi yo Sailasi. Ka hetamalidiwa kabo kawadiyena wasa ka kulikuli ta hedehededena yomiu se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yaluwa Tabuna yona nuwatu yo kai yoma nuwatu meta tabu polohe hagahagadi ka hebahebaheigomiu, na ye namwa mo taba laugagayo lakilakidiyao ta kwa miyawatanidi: ");
INSERT INTO sbe_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tabu koitau kaitalasamdi kaidiyao kwa kaikaidi, tabu suisui kwasinadiyao kwa numanumadi, tabu suisui gadona se sipwakiki na ye mwaloi kwa kaikai, yo tabu kwa ganaganawali. Taba laugagayo ta kwa miyawatanidi meta ye namwa. Kaiyoni.” ");
INSERT INTO sbe_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na se dalahai se dobi Antiyoka, na kabo ekalesiya bodadi se yogagogoidima na leta wa se moselaei udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ekalesiya bodana leta wa se hasili na ye henuwabayaodi, ede se gwauyalakalili. ");
INSERT INTO sbe_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasi yo Sailasi siya meta hinage peloweta. Yodi hededehaisagusagu maudoidi udiyedi ekalesiya bodana wa se hebayaodi. ");
INSERT INTO sbe_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Mayadai hisa se lau, na kabo taukawamamohoi wa Yudasi yo Sailasi se lautokiyeidi na se hetamalidi ma nuwadaumwalidi na se uyo tauhetamalidima wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na Paulo yo Banaba Antiyoka unai se miyamiya na siya maiyadiyao tamowai hekadi Guiyau wasana se lauhekataei yo se laulauguguyaei. ");
INSERT INTO sbe_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yodi bawa Antiyoka unai wa mayadai hisa se lau na kabo Paulo ye hededelau Banaba unai ye wane, “Taba yoda kadautakikili helabuina ta ginauli. Ta uyo lahinaidi Guiyau wasana yoda kabalauguguyaena magaidiyao wa udiyedi, na kada kahao wa ta kitadi.” ");
INSERT INTO sbe_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba ye talam na ye henuwa bena Yowane maiyadi, hesana hesau ede Maleko. ");
INSERT INTO sbe_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Na Paulo ye nuwatui nige ye namwa taba iya maiyadi, matawuwuna lahinaidi Pampiliya unai nige ye saguidi, yodi paisowa wa sola ye laulau na ye laugabaeidi. ");
INSERT INTO sbe_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Se haikawayagalakalili ede se hebodalabuiyei. Banaba Maleko ye hai, ede maidana se gelu se lau Saipulusi, ");
INSERT INTO sbe_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","na Paulo yona kaisunuwa tamowaina ede Sailasi. Antiyoka unai taukawamamohoi wa Paulo yo Sailasi yodi se tapwalolo bena Guiyau ye kitahetetedi, na kabo se dalahai ");
INSERT INTO sbe_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","se lau Siliya yo Silisiya magaidiyao udiyedi ekalesiya bodadiyao wa se hededehebayaodi. ");
INSERT INTO sbe_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Se lau Debi, na kabo se lage Lisitila. Temenai Yesu tauhemuliwatanina hesau hesana Timoti. Iya sinana meta Dius sinena yo Yesu taukawamamohoiyena hesau, na tamana meta Giliki tamowaina. ");
INSERT INTO sbe_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Taukawamamohoi Lisitila yo Ikoniya udiyedi Timoti se kawanamwanamwaei. ");
INSERT INTO sbe_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo ye henuwa Timoti bena maiyadi se lau se kadau, ede Timoti ye hepelitome, matawuwuna Dius tamowaidiyao tenem teha ne unai taumiya Timoti tamana kabina se kata iya meta Giliki tamowaina. ");
INSERT INTO sbe_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Se dalahai se lau magai lakilakidiyao maudoidi wa udiyedi, na apostolo yo dubu babadadiyao Yelusalema unai yodi hineli leta unai se kuli wa se hededegabaedi taukawamamohoi wa udiyedi bena se kawakabiyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Unai ekalesiya tamowaidiyao wa yodi sunuma unai se bayao, yo mayadai badobado kadi boda wa ye laki ye lau. ");
INSERT INTO sbe_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo ma kana kahao se kadau se lau teha Pilidiya yo teha Galatiya magaidiyao udiyedi, matawuwuna Yaluwa Tabuna ye hekatadi taba nige se lau se wasaduwai teha Eisiya unai. ");
INSERT INTO sbe_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Se lage teha Misiya unai na se henuwa bena se sae teha Bitiniya, na Yesu Yaluwana ye hekatadi tabu se sae temenai. ");
INSERT INTO sbe_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Unai se uyo Misiya na se lau se dobi Tolowasi magaina. ");
INSERT INTO sbe_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yodi huyalage Tolowasi unai boniyaina ne unai Paulo yona nuwanuwatu unai Yaubada tautau hesau ye hemasalaha unai meta Masedoniya tamowaina hesau ye kita ye totolo na ye hededelau Paulo unai ye kaibwada ye wane, “Ku laoma Masedoniya na ku saguigai.” ");
INSERT INTO sbe_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Unai ka nuwatulobai meta Yaubada ye yoganeigai bena ka lau Masedoniya Yesu wasana namwanamwana ka wasaduwaiyei udiyedi. Ede ka kabinonoha na ka gelu. ");
INSERT INTO sbe_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tolowasi unai ka gelu na ka dudulai ka lau Samotelesi. Na mayadai helabuina unai kabo ka lage Niyapolisi. ");
INSERT INTO sbe_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Temenai waga wa ka pesagabaei na ka yona ka lau Pilipi. Pilipi meta magai lakilakina Loma tamowaidiyao se hetubu, yo Loma yodi kabatanuwaga magaina teha Masedoniya ne unai. Pilipi unai ka miya mayadai hisa, ");
INSERT INTO sbe_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","na Sabatiyena magai wa ka pesagabaei ka lau sagasaga dedekanaena. Yoma nuwatu meta tenem teha ne unai kabo Dius tamowaidiyao yodi kabatapwatapwalolo. Ka lobai ede ka tulidobi na ka hetubu ka hedehededelau sinesineo hekadi se lagegogoima wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taulapulapui wa hesau hesana ede Lidiya, iya meta Tiyatila waihiuna. Kana paisowa ede kaleko namwanamwadi ye lokulokuneidi. Lidiya meta Yaubada taukaihelahuina, na Yaubada iya nuwana ye hemasalaha, ede ye lapulapuinamwanamwa yo ye kawamamohoi Paulo yona lauguguya wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iya ma kana bodao ka hebabatisoidi, na kabo ye kaibwadaigai bena ka lau yona numa, ye wane, “Ena kwa kawamamohoiyeigau yau Guiyau tausunumaena, kabo kwa laoma yogu numa unai kwa miya.” Ye kaibwadaigai ede ka lau yona numa wa unai ka miya. ");
INSERT INTO sbe_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mayadai hesau ka laulau kabatapwalolo magaina wa unai na heyayai tauhaina waihiuna hesau ye lobaigai. Yaluwa yabayababana waihiu ne unai ye luwu na ye hesonoga, na kana paisowa ede saha sola nige se tubu meta ye hedehededehemasalahadi. Na paisowa ne unai kana tanuwagao yodi moni lakilakina ye ginauli. ");
INSERT INTO sbe_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Waihiu wa Paulo maidamai ye hemuhemuliwatanigai na ye heyoheyoga ma kalinalakilakina ye wane, “Teina tamowai ta Yaubada saesaekalilina yona taupaisowa. Siya kabo se hedehededehemasalaha kalimiuyena idohagi na kabo mauli kwa lobai.” ");
INSERT INTO sbe_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mayadai badobado waihiu wa yona hedehedede kesekesegana. Unai Paulo ye tausiꞌololo yo ye kouyalayalakalili, ede ye hededelau yaluwa yabayababana wa unai ye wane, “Yesu Keliso hesanaena ya hededelaowa, waihiu ta ku pesagabaei.” Mahanana ne unai yaluwa yabayababana waihiu wa ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Waihiu wa kana tanuwagao wa se nuwatulobai meta yodi gogo kabahaidi kamwasana se heyababa, unai Paulo yo Sailasi se haidi se laedi kabalokulokune unai, gabemani tamowaidiyao udiyedi bena se helauhetaladi. ");
INSERT INTO sbe_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na kabo se hededelau tautolehedudulai tamowaidiyao udiyedi se wane, “Teina Dius tamowaidiyao ta debadiyena yoda magai ta tamowaidiyao maudoidi se hetalagegagega! ");
INSERT INTO sbe_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Siya laulau se lauhekataedi ta meta kita Loma tamowaidiyao yoda laugagayo unai nige gonowana ta kawanamwanamwaedi yo ta ginaulidi!” ");
INSERT INTO sbe_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bodalakilaki waihiu kana tanuwagao wa se saguidi na Paulo yo Sailasi se hegiludi, unai tautolehedudulai tamowaidiyao se hedede kadi luwuluwu se haigabaisinasinakalaedi na se sapidi. ");
INSERT INTO sbe_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Se sapidi ye gehe kabo se laedi numatutugudu unai se toledi na se hededelau numatutugudu wa taukitahetetena unai bena ye kitahetetenamwanamwaedi na tabu se wasawasabu. ");
INSERT INTO sbe_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ede Paulo yo Sailasi ye haidi numatutugudu luwamolosina unai ye toledi na kaedi se koiyahisihekahinidi kaiwa tehadiyao polopolohedi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Boniyai duwaduwalina unai taudi labui wa se tapwalolo yo se wanawana yo Yaubada se hedehedebasae, na numatutugudu wa unai kadi kahao wa meta se lapulapui. ");
INSERT INTO sbe_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mahanana ne unai mwanikuniku lakilakina, na numatutugudu wa yona kabatolo ye nukunuku. Makesega keda gududi maudoidi se tasoke na numa wa unai tamowai maudoidi kaedi yo nimadi senidiyao se bekuhai. ");
INSERT INTO sbe_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Numatutugudu taukitahetetena wa ye kenosiliyatama na ye kaikewadobi meta keda gududiyao wa se tasokeko, ede ye siliyatakalili na yona nuwatu bena Paulo ma kana kahao wa se wasabuko. Unai yona kelepa ye hai bena ye bom ye unuhemwaloiꞌuyoi. ");
INSERT INTO sbe_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na Paulo ye yogalau iya unai ye wane, “Tabu ku unuꞌunuhemwaloiꞌuyoigo! Kai maudoimai ede teinai!” ");
INSERT INTO sbe_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ede numatutugudu taukitahetetena wa ye yoga ede osili se baheiyama na ye dobi, na ma matausina ye tulibono Paulo yo Sailasi talanuwadi wa unai. ");
INSERT INTO sbe_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na kabo ye woyahepesadi na ye henamaiyeidi ye wane, “Tautaubadao, taba saha ya ginauli kabo ya mauli?” ");
INSERT INTO sbe_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Se hededelau iya unai se wane, “Guiyau Yesu ku kawamamohoiyei yo ku sunumaei na kabo ku mauli, kowa yo yom numa tamowaidiyao maudoidi hinage.” ");
INSERT INTO sbe_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na kabo Paulo yo Sailasi Guiyau wasana se hededehemasalaha iya yo yona numa tamowaidiyao wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Boniyaina ne unai ye haidi ye laedi, taudi gaidiyao wa ye deulidi, na kabo Paulo yo Sailasi numatutugudu taukitahetetena wa yo yona numa tamowaidiyao maudoidi se hebabatisoidi. ");
INSERT INTO sbe_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kabo Paulo yo Sailasi ye woyalaedi yona numa unai na kai ye moseidi se kai. Iya yo yona numa tamowaidiyao maudoidi wa se gwauyalakalili, matawuwuna se nuwabui yo Yaubada se kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mala ye tom kabo tautolehedudulai tamowaidiyao wa yodi taupaisowa se hetamalidi se lau numatutugudu taukitahetetena wa unai se hededelau kabo Paulo yo Sailasi ye hepesadi. ");
INSERT INTO sbe_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Numatutugudu taukitahetetena wa Paulo yona ye hedehedede ye wane, “Tautolehedudulai tamowaidiyao wa se hedede meta kabo ya yailigabaegomiu. Unai kwa pesa na daumwaliyena kwa lau.” ");
INSERT INTO sbe_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na Paulo ye hededelau tautolehedudulai yodi taupaisowa wa udiyedi ye wane, “Kai meta Loma yona laugagayo logulogunaena taumiya. Unai nige gonowana se sapigai boda matadiyena yo se tolegai numatutugudu unai, na nige kama mata hesau se lobai. Na bena wadawadamyena se hetamaligai ka lau. Taba nige! Siya taba se laoma na se woyahepesagai!” ");
INSERT INTO sbe_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tautolehedudulai tamowaidiyao yodi taupaisowa wa se uyo na se hededelau udiyedi meta Paulo yo Sailasi Loma yodi laugagayo logulogunaena taumiya. Hedehedede wa se lapui meta se siliyatakalili. ");
INSERT INTO sbe_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Unai se laoma Paulo yo Sailasi udiyedi yodi hededehedudulai se ginauli. Ye gehe kabo se woyahepesadi se laedi na se hededebigabigalau udiyedi taba magai ne se laugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Na Paulo yo Sailasi se lau Lidiya yona numa unai na taukawamamohoi wa se kitadi ede se hededehebayaoꞌuyoidi, na kabo se dalahai se lau. ");
INSERT INTO sbe_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Se dalahai ede se lau Ampipolisi. Na mala ye tom kabo se lau Apoloniya se laugabae, na kabo se lau Tesalonika unai se lage. Temenai meta Dius yodi sunago hesau. ");
INSERT INTO sbe_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo yona miyamiya unai mayadai Sabati haiyona udiyedi ye lau sunago wa unai ye mwalae, na Dius tamowaidiyao maidanao kulikuli tabudi kaniyodi wa se hedehededeidi. ");
INSERT INTO sbe_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ye hededehemasalaha meta Yaubada yona hineli unai Keliso ye kamkamna yo ye toloꞌuyo, yo ye wane, “Yesu ya hetahetalaꞌusei ta, iya ede Keliso.” ");
INSERT INTO sbe_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Dius tamowaidi hekadi nuwadiyao se haidi, yo Giliki tamowaidiyao siya Yaubada taukaihelahuina yo sinesinebadao lakilakidi gwaudi hinage se patulau Paulo yo Sailasi udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Na Dius tamowaidiyao wa Paulo yo Sailasi se kaikalomagigiliyeidi. Unai taulaulaugaibu yo tauwalobayabayao hekadi se yogagogoidima, na se kabiboda yo magai tamowaidiyao maudoidi se hekoipilidi. Kabo se lau Yasona yona numa unai Paulo yo Sailasi se waseneidi bena se woyaidima boda wa udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Na nige se lobaidi ede Yasona yo taukawamamohoi tamowaidiyao hekadi se tabekokokokolidi se laedi magai wa taukitahetetena lakilakidiyao udiyedi, na se heyoheyoga se wane, “Paulo yo Sailasi tanoubu maudoina tamowaidiyao se hekouyalayaladiko yo hinage se laomako inai, ");
INSERT INTO sbe_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Yasona iya tauhemiyadi ede. Teina maudoidi ta siya Sisa yona laugagayo tauꞌutuꞌutusina matawuwuna se wane tamowai hesau meta iya wasawasa, hesana ede Yesu.” ");
INSERT INTO sbe_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hedehedede wa se lapui ede boda wa yo magai taukitahetetena tamowaidiyao wa meta se kouyalayalakalili ");
INSERT INTO sbe_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","na se hedede Yasona ma kana kahao wa moni lakilakina se tole kabahematausidi, na kabo se kabigabaedi se lau. ");
INSERT INTO sbe_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Boniyaina ne unai taukawamamohoi wa Paulo yo Sailasi se hetamalidi se lau Beleya. Se lage menai kabo se lau Dius yodi sunago unai se lauguguya. ");
INSERT INTO sbe_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na Dius tamowaidiyao Beleya unai taumiya wa meta se lapulapuinamwanamwakalili Paulo yo Sailasi udiyedi, na kabo siya Tesalonika unai taumiya wa. Mayadai badobado kulikuli tabudiyao se kitahekasadi, Paulo yo Sailasi saha se lauguguyaei wa meta mamohoi o nige. ");
INSERT INTO sbe_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na se lobai meta yodi lauguguya wa mamohoina, unai Dius tamowaidiyao gwaudi Yesu se kawamamohoiyei, yo Giliki tamowaidiyao, siya sinesineo hekahekasisidi yo hinage tatao hekadi. ");
INSERT INTO sbe_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Na Dius Tesalonika unai taumiya wa wasa se lapui meta Paulo ede Beleya unai Yaubada wasana ye laulauguguyaei. Unai kabo se laoma boda maudoidi wa se henuwasaedi bena Paulo se hewaiunu. ");
INSERT INTO sbe_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Unai taukawamamohoi tamowaidiyao wa kadi kahao hekadiyo maiyadi Paulo se hetamalidi se dobi gabwa. Na Sailasi yo Timoti meta Beleya unai se miyamiya. ");
INSERT INTO sbe_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na taudobi wa se lulage se dobi na waga hesau unai se gelu se lau Ateni. Ateni unai se lage kabo Paulo ye hededelau maidanao taulau wa udiyedi bena taba se uyo na Sailasi yo Timoti se hetamalimwamwayauyeidi se laoma iya unai. ");
INSERT INTO sbe_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo Ateni unai kana kahao wa ye nayanayaidi, na ye kita meta magai wa unai koitau se badokalili, ede ye nuwayababakalili. ");
INSERT INTO sbe_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Unai ye lau sunago unai ye hedehededelau Dius yo dagela tamowaidiyao Yaubada taukaihelahuina udiyedi. Yo hinage mayadai maudoina ye lau kabalokulokune unai na ye hedehededelau tautupagogoi wa udiyedi, ");
INSERT INTO sbe_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","meta Yesu yo yona toloꞌuyo wasana namwanamwana ye wasaduwaiyei. Unai tausonoga tamowaidiyao Paulo maiyanao se hedehedede yo yodi kawamamohoi wa se hetala. Tausonoga wa meta boda labui tamowaidiyao. Hekadi ede Epikulasi kana bodao, yo hekadi Sitoiko bodadiyao. Hekadi se wane, “Teina tauhedehededegaibu ta saha bena ye lauhekataei?” Na hekadi se wane, “Teina kana kao doha magai hekadi yaubadadiyao lauhekatadi unai bena ye hekatada.” ");
INSERT INTO sbe_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ede Paulo se hai se laei Aliyopagasi unai na se hededelau unai se wane, “Taba gonowana yom lauhekata hauhauna wa ku hededehemasalaha kalimaiyena. ");
INSERT INTO sbe_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Matawuwuna yom hedehedede hauhaudi te ka lapuidi, unai ka henuwa bena kaniyodi kabidi ka kata.” ");
INSERT INTO sbe_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateni tamowaidiyao maudoidi yo magai hekadi tamowaidiyao menai taumiya mayadai maudoina kadi paisowa ede hedehedede hauhaudi se lapulapuidi yo udiyedi se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na Paulo ye tolo yodi koigogo wa unai na ye hededelau udiyedi ye wane, “Ateni tataodiyao! Ya kita meta yomi tabaꞌohu unai kwa taubigakalili. ");
INSERT INTO sbe_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Yogu taihile unai yomi kabatabaꞌohu ginaulidi ya kaikewaidi na kabakaitalasam hesau ya kita unai teina kulikuli ta ye masalaha: YE LAU YAUBADA NIGE KABINA KA KATA UNAI. Na saha kwa tabaꞌohui ta nige kabina kwa kata, unai kabo ya hededehemasalaha kalimiuyena. ");
INSERT INTO sbe_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yaubada kaiyaulina yo ginauli maudoidi tauginaulidi, iya galewa yo tanoubu Guiyauna. Unai numa tamowai nimadiyena se ginaulidi, meta iya nige udiyedi ye miyamiya. ");
INSERT INTO sbe_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yo tamowai nige gonowana se sagui matawuwuna nige ginauli hesau unai ye deha, na iya tamowai maudoidi yodi mauli yo yawasidi yo ginauli maudoidi ye moseidi. ");
INSERT INTO sbe_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tamowai kesega ye ginaulibagunai, na unai boda udoiꞌudoi ye ginaulidi, na siya bena tanoubu maudoina se miyahemwayau. Na yodi huya yo yodi teha ye hinelidi udiyedi bena se miya. ");
INSERT INTO sbe_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yaubada ginauli maudoidi ta ye ginaulidi na ye henuwa tamowai bena iya se wasenei na yodi kaikaipate unai bena iya se lobai, matawuwuna iya maudoida dedekadaena. ");
INSERT INTO sbe_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Doha hinage yomi taukulikuli hekadiyo se hedede se wane, ‘Iya unai ta miya, ta sae yo ta dobi yo ta maumauli.’ Yo hinage se wane, ‘Kita iya natunao.’ ");
INSERT INTO sbe_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mamohoi, kita Yaubada natunao. Unai taba nige ta nuwatui meta iya kana kao doha koitau, tamowai yodi sonogaena se ginauli gole o siluba o weku unai. ");
INSERT INTO sbe_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Beyabeyana tamowai wa Yaubada nige kabina se kata na iyamo yodi nuwapwanopwano wa unai iya nige saha hesau ye ginauli. Na teina huya ta unai ye hededelau teha maudoidi tamowaidiyao maudoidi udiyedi bena se nuwabui. ");
INSERT INTO sbe_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Matawuwuna mayadai ye toleyako unai kabo yona kaisunuwa tamowaina tanoubu maudoina ye hinelidi, na yona hineli ne kabo dudulai unai. Teina ye hemamohoiyei tamowai maudoidi udiyedi matawuwuna Yesu boita unai ye hetoloꞌuyoi.” ");
INSERT INTO sbe_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tauboiboita yodi toloꞌuyo hedehededena wa se lapui ede hekadiyo Paulo se talatalawasiyei, na hekadiyo se wane, “Ka henuwa bena huya hesau hedehedede ta ku hededeꞌuyoi ka lapui.” ");
INSERT INTO sbe_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na teina unai kabo Paulo koigogo wa ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na tamowai hekadi se patulau Paulo unai na Yesu se kawamamohoiyei. Kadi boda wa unai Daiyanisiyasi, iya meta Aliyopagasi unai taukoikoigogo wa tamowaina hesau, yo hinage waihiu hesau hesana Damalisi, yo hinage tamowai hekadi. ");
INSERT INTO sbe_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Na kabo Paulo Ateni ye laugabaei na ye lau Kolinito. ");
INSERT INTO sbe_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Temenai Dius tamowaina hesau hesana Akuila. Iya Pontasi tamowaina, na beyabeyana ye lau teha Italiya magaina lakilakina Loma unai ye miya. Na Loma kadi tanuwaga saesaena Sisa Kolodiyasi ye hedede meta Dius tamowaidiyao maudoidi Loma se dalahaigabaei. Unai Akuila ma mwanena Pilisila se lau Kolinito unai se miya. Nige bayaona na Paulo ye lage, na yona taihile unai ye lobaidi. ");
INSERT INTO sbe_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akuila ma mwanena kadi paisowa ede tenti se laulauginauli, na Paulo hinage paisowa wa kabina ye kata. Unai maiyanao se miya na se paisowagogoi. ");
INSERT INTO sbe_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na Sabati badobado Paulo ye lau sunago unai, na Dius yo Giliki tamowaidiyao maiyanao se hedehedede, na Paulo ye kaipate bena Yesu kabina se kata yo se sunumaei. ");
INSERT INTO sbe_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Na huyana Sailasi yo Timoti teha Masedoniya unai se laoma, kabo Paulo tentiginauli paisowana wa ye hekaiyawasi na huya maudoina ye laulauguguya. Dius tamowaidiyao udiyedi ye hededehemasalaha meta Yesu iya Keliso ede. ");
INSERT INTO sbe_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ye lau ee Dius tamowaidiyao wa Paulo se hewaiunu yo se kawalupolupoi, kabo kana kaleko ye koinihinihiyeidi, na ye hededelau udiyedi ye wane, “Kwasinamiu giluna komiu kwa bom kalimiuyena! Yau nige kagu gilu hesau. Unai kabo ya laugabaegomiu na ya lau dagela tamowaidiyao udiyedi ya lauguguya.” ");
INSERT INTO sbe_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Na kabo Paulo sunago wa unai ye pesa na ye lau tamowai hesau hesana Titiyasi Diyasitasi yona numa unai ye lauguguya. Iya meta Yaubada taukaihelahuina hesau, na yona numa wa meta sunago dedekanaena. ");
INSERT INTO sbe_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na sunago wa badana Kilipasi ma kana bodao maudoidi se kawamamohoi Guiyau unai. Yo hinage Kolinito tamowaidiyao gwaudi Yesu wasana se lapui yo se kawamamohoiyei, ede Paulo ma kana kahao tamowai wa se hebabatisoidi. ");
INSERT INTO sbe_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Boniyai hesau unai Paulo yona nuwanuwatu unai Yaubada tautau hesau ye hemasalaha unai, meta Guiyau ye hededelau iya unai ye wane, “Tabu ku matausi, na yom lauguguya ne bena ye laulau! Tabu ku mwanomwanou, ");
INSERT INTO sbe_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","matawuwuna yau ede maidam. Nige gonowana tamowai hesau ye hewaiunugo yo ye hekamkamnago. Kana kao ede magai ta unai yogu tamowai se bado.” ");
INSERT INTO sbe_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Na bolimai kesega yo tehana Paulo Kolinito unai ye miya, na huya maudoina Yaubada yona hedehedede unai tamowai wa ye hekatadi. ");
INSERT INTO sbe_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Huyana wa unai Galiyo yona huyatanuwaga teha Akaiya unai. Na Dius tamowaidiyao se hebodakesega na Paulo se hewaiunu, na se hai se laei Galiyo yona kabahelahelauhetala unai. ");
INSERT INTO sbe_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na se hegilu se wane, “Teina tamowai ta boda ye hekatadi Yaubada tabaꞌohuina kabikabina hauhauna unai, meta laugagayo ye utusi.” ");
INSERT INTO sbe_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo bena kabo ye hedehedede, na Galiyo ye hededelau Dius tamowaidiyao wa udiyedi ye wane, “Dius tamowaidiyao! Taba tamowai ta laulau yababana o yababa lakilakina hesau ye ginauli, kabo gonowana ya lapulau yomi hetalapili ta unai. ");
INSERT INTO sbe_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Na iyamo hedehedede kaniyodi yo tamowai hesadiyao yo yomi laugagayo debadiyena kwa haikawayagala ta, unai komiu kwa bom kwa tolehedudulaiꞌuyoigomiu. Yau taba nige nuwatu ta ya tolehedudulaidi.” ");
INSERT INTO sbe_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kabo ye hedede kabalauhetala numana wa unai se hepesadi. ");
INSERT INTO sbe_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na kabo boda maudoidi sunago badana Sositenisi se hai na se bibigwadagwadai kabalauhetala numana wa unai. Na Galiyo nige ye modelau udiyedi. ");
INSERT INTO sbe_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Na Paulo sola ye miyamiya Kolinito unai huyalohaloha. Na kabo kana kahao wa ye laugabaeidi na Pilisila yo Akuila maiyanao se dobi Senkiliya. Temenai Paulo yona hedehededekaigwala ye ginauliyako wa debanaena ede iya kuluna wa se yaligabae. Na kabo se gelu bena se lau Siliya. ");
INSERT INTO sbe_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Yodi kadau wa unai Epeso unai se duna, ede Pilisila yo Akuila temenai se miya. Na Paulo meta mayadai hisa mo menai ye miya. Yona miya wa unai ye lau sunago unai na Dius tamowaidiyao maiyanao se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na se kaibwada bena maiyadi se babawa, na nige ye henuwa. ");
INSERT INTO sbe_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na yona huyagelu mayadaina unai ye hededelau udiyedi ye wane, “Ena Yaubada yona nuwatuyena, kabo ya uyoma.” Na kabo wagaena ye gelu na Epeso ye laugabaei. ");
INSERT INTO sbe_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Se kadau se lau ee Sisaliya unai se duna. Na Paulo ye pesa ye sae Yelusalema unai ekalesiya bodadi ye hailobaidi. Na kabo ye dobi Antiyoka. ");
INSERT INTO sbe_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiyoka unai mayadai hisa ye miya, na kabo ye dalahaiꞌuyo ye lau Galatiya yo Pilidiya magaidiyao ye kaitaumanaidi na Yesu tauhemuliwatanina maudoidi wa ye hededehebayaodi. ");
INSERT INTO sbe_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Huyana Paulo sola ma kadauna, na Alesandiliya tamowaina hesau hesana Apolosa ye laoma Epeso. Iya Dius tamowaina tausonoga hesau, na kulikuli tabudi kabidi ye katakalili, ");
INSERT INTO sbe_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","yo Guiyau wasana hinage kabina ye kata. Ye hedehedede ma nuwakohihaina yo Yesu wasana ye lauhekatanamwanamwaei. Na iyamo Yowane yona hebahebabatiso mo kabina ye kata, na babatiso Yesu hesanaena nigele. ");
INSERT INTO sbe_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Iya ye hetubu ye hedehedede ma nuwabayaona sunago unai. Na Pilisila yo Akuila yona hedehedede wa se lapui ede se kaibwadai ye lau yodi numa unai, na Yesu wasana unai se hededehasahasai na se hekatanamwanamwaei idohagi Yaubada tamowai ye hemaulidi. ");
INSERT INTO sbe_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Huya hesau kabo Apolosa ye henuwa bena ye lau Akaiya, tausunuma bena ye saguidi. Ede tausunuma Epeso unai iya se hededehebayao na leta se kuli ye lau tauhemuliwatani Akaiya unai taumiya wa udiyedi, bena iya se hailobai. Ye lage ede Yaubada yona kabinamwa unai taunuwabui wa ye sagukaliliyeidi. ");
INSERT INTO sbe_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Meta tamowai maudoidi matadiyena ye hededebayaokalili Dius tamowaidiyao udiyedi na kulikuli tabudi udiyedi ye hemamohoiyei meta Yesu iya Keliso ede. ");
INSERT INTO sbe_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Huyana Apolosa Kolinito unai ye babawa, kabo Paulo Pilidiya ye laugabaei na ye dobi Epeso unai ye lage. Temenai tauhemuliwatani hekadi ye lobaidi ");
INSERT INTO sbe_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na ye henamaiyeidi ye wane, “Huyana kwa kawamamohoi, Yaluwa Tabuna kwa hai, o nige?” Na se wane, “Nige! Yaluwa Tabuna nige kabina ka kata, yo sola nige wasana ka lapui.” ");
INSERT INTO sbe_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Unai Paulo ye wane, “Na babatiso sahasahana unai se hebabatisoigomiu?” Se wane, “Yowane yona hebahebabatiso.” ");
INSERT INTO sbe_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Na Paulo ye wane, “Yowane yona hebahebabatiso meta nuwabui babatisona. Iya ye hededelau boda wa udiyedi meta tamowai hesau kabo ye mulitama, bena iya unai se kawamamohoi. Tamowaina ede Yesu.” ");
INSERT INTO sbe_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hedehedede wa se lapui ede Paulo ye hebabatisoidi Guiyau Yesu hesanaena. ");
INSERT INTO sbe_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na huyana Paulo nimana ye tolesae kuludi wa udiyedi meta Yaluwa Tabuna ye hemwayaudi, na kalina udoiꞌudoi udiyedi se hedehedede, yo hinage Yaubada yona nuwatu ye moseidi na se hededehemasalahadi. ");
INSERT INTO sbe_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Na taubabatiso wa nuwana badodi ede saudoudoi-labui (12). ");
INSERT INTO sbe_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nawalai haiyona Paulo ye laulau sunago unai na ma nuwabayaona ye laulauguguya. Na maiyanao se hedehedede yo Yaubada yona basileiya se hetahetala, na yona hedehedede wa unai Dius tamowaidi wa se nuwamasalaha na se nuwabui na Yesu se kawamamohoiyei. ");
INSERT INTO sbe_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Na hekadiyo se nuwakwailolokalili, na nige se henuwa bena se kawamamohoiyei, na boda matadiyena Guiyau wasana se hededeyababaei. Unai Paulo sunago wa ye laugabaei, na tauhemuliwatani maidanao se lau Tailenasi yona kabalauhekata numana unai se koikoigogo. Na mayadai badobado taulaoma maiyanao se hedehedede. ");
INSERT INTO sbe_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Teina paisowa te ye lau ee bolimai labui. Na Dius yo Giliki tamowaidi maudoidi teha Eisiya unai taumiya Guiyau wasana se lapui. ");
INSERT INTO sbe_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yaubada Paulo ye hepaisowa na laulau gigigigibwalikalilidi ye ginaulidi, ");
INSERT INTO sbe_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ede hinage Paulo yona hagesi yo kaleko hekadi ye hepaisowadiko wa se haidi se laedi taukasikasiyebwa udiyedi se hesaudi, ede se namwanamwa, yo hinage yaluwa yabayababadi tamowai se pesagabaedi. ");
INSERT INTO sbe_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dius tamowaidiyao hekadi kadi paisowa se lau magai hekadi udiyedi yaluwa yabayababadi tamowai se luwuidi wa se hededehepesadi, na se kaipate bena Guiyau Yesu hesana se hepaisowa, na se wane, “Paulo Yesu ye lauguguyaei wa, iya hesanaena ya hededelaowa: Tamowai ta ku pesagabaei!” ");
INSERT INTO sbe_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Boda wa luwadiyena meta Siba natunao tatao haligigi-labui (7). Tamadi meta Dius yodi taukaitalasam tauwoyaidi hesau. Taudi haligigi-labui ta tenem kabikabi ne se hepahepaisowa. ");
INSERT INTO sbe_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Na huya hesau yaluwa yabayababana ye hededelau udiyedi ye wane, “Yesu kabina ya kata, yo hinage Paulo kabina ya kata. Na komiu meta kaiteyadi?” ");
INSERT INTO sbe_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na t