﻿USE sofia;
DROP TABLE IF EXISTS sofia.sav_vpl;
CREATE TABLE sav_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sav_vpl WRITE;
INSERT INTO sav_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ŋ camba, Kooh fer eel ci na kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kehƴi nikee hulang, wa nikka ɓarang. E ñuus muuree masma, te Fuuɗsiŋ Kooh seree ŋ ɗafuk wa. ");
INSERT INTO sav_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kooh woosa ne : « Wa wiisaat ! » Wa wiissa. ");
INSERT INTO sav_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","A hotta ne siñaari baahiɗ, a nistohha siñaari na ñuusi. ");
INSERT INTO sav_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A teekka siñaari \"noh\", a teekka ñuusi \"wek\". Niin raakka, ɓaaɓ raakka, wa nikka mbeha ɗeɓ. ");
INSERT INTO sav_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Wa weem coot, Kooh woosa ne : « Raɗsuk raakaat ŋ harmban masuɓ ci, ne wa nistoh masuɓ na masuɓ. » ");
INSERT INTO sav_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","A haɓiɗta raɗsuki. A nistohha masmi ŋ ooɓ raɗsuki na masma ŋ ɗafka. Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A teekka raɗsuki \"eel ci\". Niin raakka, ɓaaɓ raakka, wa nikka mbeha kanakɗoh. ");
INSERT INTO sav_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ŋ finho ineem, Kooh woosa ne : « Masmi ŋ ooɓ eel ci nangɗukohaat ɗisik yino po keheƴ suyiɗ pul. » Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A teekka ɓaki suyɗi \"keheƴ\", a teekka masmi nangɗukohɗi \"cookom\". A hotta ne wa baahiɗ. ");
INSERT INTO sav_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ngaŋ woo keem, Kooh woyissa ne : « Kehƴi riifaat na in ci na paare : paangiici ɓay tisoh, na kidig ci na ñamse, kidig nu nik na rimiŋ wa na tisohiŋ wa ŋ ɗooƴi, ŋ findi mandohaaɗiŋ wa, ŋ kehƴi. » Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kehƴi paarra paangi ɓayiɗ tisoh findi mandohaaɗ ciŋ ca, kidig ci na rime findi mandohaaɗ ciŋ ca, waa nu nik na tisohiŋ wa. A hotta ne wa baahiɗ. ");
INSERT INTO sav_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Niin raakka, ɓaaɓ raakka, wa nikka mbeha kaahayɗoh. ");
INSERT INTO sav_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Wa mbeheem coot, Kooh woosa ne : « Ngaŋ raɗsukiŋ eel ci, wa raakaat in ci raak siñaar, ne ca nistoh noh na wek, ca teeɓoh jamano na mbeh na kiis. ");
INSERT INTO sav_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ŋ raɗsukiŋ eel ci, ca nikaat siñaar ne ca siñaariɗ kehƴi. » Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kooh haɓiɗta siñaar kanak yakak, wi yakki ne wa adgoh noh, wi ƴini ne wa adgoh wek. A haɓiɗta yit hor ci. ");
INSERT INTO sav_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","A seriɗta ca ŋ raɗsukiŋ eel ci ne ca siñaariɗ kehƴi, ");
INSERT INTO sav_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ne ca adgoh noh na wek, ca nistoh siñaar na ñuus. A hotta ne wa baahiɗ. ");
INSERT INTO sav_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Niin raakka, ɓaaɓ raakka, wa nikka mbeha nikiisɗoh. ");
INSERT INTO sav_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ŋ woo keem, Kooh woyissa ne : « Ngaŋ masuɓ ci, cuurund na inaama wiiriis aastiɗohaat, sel pundaat ŋ eel ci, ŋ ɗafuk kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ŋ ineem, a ferra ɗoopaat ci yakak ci ŋ cookmi, na inaamaaci na huƴe, ca weƴee jen ŋ ɗooƴ masuɓ ci. A ferra ca ŋ findi mandohaaɗ ciŋ ca. A ferra yit in ci raak paɓ jen, findi mandohaaɗ ciŋ ca. A hotta ne wa baahiɗ. ");
INSERT INTO sav_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","A barke'iɗta ca, an : « Nikaat ɓasloh, rimaatɗohaat, riifɗaat masmiŋ cookmi, te yit, sel ci rimaatɗoh ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Niin raakka, ɓaaɓ raakka, wa nikka mbeha yatuusɗoh. ");
INSERT INTO sav_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Wa weem coot, Kooh woosa ne : « Kehƴi pulɗaat inaama findi mandohaaɗ ciŋ ca, ɗoopaat ci raakan heɗ, na ci raakanɗi heɗ, na inaama ƴin findi mandohaaɗ ciŋ ca. » Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","A ferra ɗoopaat ci raakanɗi heɗ findi mandohaaɗ ciŋ ca, a ferra ci raakan heɗ findi mandohaaɗ ciŋ ca, a ferra inaamaaci ƴin ci ŋ kehƴi jen findi mandohaaɗ ciŋ ca. A hotta ne wa baahiɗ. ");
INSERT INTO sav_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ngaŋ woo keem, a woyissa ne : « Ɓoo haɓɗaat ɓo' ŋ ñaamaariŋ ɓoo, findi mandohaaɗiŋ ɓoo, ne ɓa adgoh cuurund ciŋ cookmi, na sel ciŋ eel ci, na ɗoopaat ci, ne ɓa adgoh kehƴi jen, na in ci na yoonde ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kooh ferra ɓo' ŋ ñaamaariŋ ɗe. Ngaŋ ñaamaariŋ Kooh, a ferra ɓa, ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","A barke'iɗta ɓa, a woosa ɓa ne : « Ɓaslaat, rimaatɗohaat, riifɗaat kehƴi, minaat kehƴi jen, adgohaat cuurund ciŋ cookmi, na sel ciŋ eel ci, na in ci na yoonde ŋ kehƴi jen. » ");
INSERT INTO sav_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kooh dokkissa, woosa ɓa ne : « Ɓayaat, ŋ on ɗu paangi nu nik ne weɗi ŋ kehƴi jen, na kidig nu amboh rim na tisohiŋ wa ɗah. Ca nik pesohaaciŋ ɗu. » ");
INSERT INTO sav_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kooh woosa ne : « Ɗoopaat ciŋ kehƴi, sel ci na punde, in ci na yoonde ŋ kehƴi, in ci na iike jen, ŋ on ca ne, ca pesoh paangi iiri. » Te wa nikohha ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kooh hotta in ci a ƴut haɓiɗ jen, ca baahha lool. Niin raakka, ɓaaɓ raakka, wa nikka mbeha yasna-yino'ɗoh. ");
INSERT INTO sav_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Eel ci na kehƴi, na in ci ñimniɗ ci tumu nga, reehoh feru ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ŋ mbeha yasna-kanakɗoh, Kooh iɗsiɗukka, raak ɗe mitɗiɗ pangkaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Weɗ tah po Kooh barke'iɗta mbehi yasna-kanakɗoh, a hooliɗtaa wuu ce, laam a iɗsiɗuk nga, wi a ƴut fer in ci jen. ");
INSERT INTO sav_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Naandsukiŋ feriŋ eel ci na kehƴi weɗi weem. Wa Nikiɗi Kooh feree kehƴi na eel ci, ");
INSERT INTO sav_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ali kidig raakeeɗi paaɗ ŋ bilaf fi, te ali paangi puleeɗi ndoom, laam raak Nikiɗi Kooh toɓɗi ŋ kehƴi, te ɓo' raakeeɗi ne a guur merhey mi. ");
INSERT INTO sav_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Hondohɗi masuɓ puleeɗa ŋ kehƴi te wa iiri'ɗeeɗa kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ŋ jamanoonaam, Nikiɗi Kooh mahha ɓo' na merhey miŋ kehƴi, a fuuɗissa ngaŋ kiñin kaŋ ɗe iik kipes, jaarra a nikka pesoh. ");
INSERT INTO sav_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Raak, Nikiɗi Kooh haɓɗeen nguuk, ŋ pulohaaɗ-noh, ngaŋ Eden, a ɓekka ɓoya a mahee nga. ");
INSERT INTO sav_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","A paariɗta kidig nu nik ŋ merhey ma, ca moɗta ŋ has, ca neɓpa ñamu, te ngaŋ leernaŋ nguuka, a paariɗta kidgaŋ kipes ki na kidgaŋ inhisoh baahiɗ na baahaaɗi. ");
INSERT INTO sav_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Cul puleeɗa ŋ Eden, wa iiri'ɗeeɗa nguuka, wa pulohee ndeem, wa salla sal nikiis. ");
INSERT INTO sav_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sala ɗeɓ teeksee Pison, wa wileen ŋ kur kaŋ Hawiilaa jen, ɗiska urus raake ; ");
INSERT INTO sav_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ursaŋ kur keem, wa nikee koceet, ndeem raakee makndi eeñɗohaani na woyse badoolah na pemeeni na woyse sooham. ");
INSERT INTO sav_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sala kanakɗoha teeksee Gihon, wa wilee wil kur kaŋ Kuus jen. ");
INSERT INTO sav_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sala kaahayɗoha teeksee Tigar, wa nupɗee ŋ pulohaaɗ-nohaŋ Assuur. Sala nikiisɗoha nikka Ewfaraat. ");
INSERT INTO sav_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ŋ ineem, Nikiɗi Kooh ɓayya ɓoya, a tummba ɗe guuroh na niiɗohaŋ nguukaŋ Eden. ");
INSERT INTO sav_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","A huflukka ɗe ne : « Fu miniɗ ñam rim ciŋ kidig ciŋ nguuki jen. ");
INSERT INTO sav_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Waaye kidgiŋ inhisoh baahiɗ na baahaaɗi, fu heyɗi ñame nga, laam mbaɗna fu ñaman nga ɗah, fu hey kaane fut ! » ");
INSERT INTO sav_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Wa weem coot, Nikiɗi Kooh woosa ne : « Ɗaay kiik ce baahɗi ngaŋ ɓo'. Ŋ hey ɗe haɓɗiɗe ɓaatɗohoh yi min kerhiɗoh na ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ŋ ineem, raak Nikiɗi Kooh maheen na merhey ɗoopaat ci jen, na sel ci pundoh ci jen, a kommba ɓoya ca, ne a kerah findi yeem teekan ca ; yaa nu nik hey ɓeeɗkasse findi ƴaara na hee ɗe teeke. ");
INSERT INTO sav_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Wa a kom ɓoya ca, ɓoya feriɗta ca tiik jen, ɗoopaat ciŋ kahan ci, sel ci pundoh ci, na ɗoopaat ciŋ nduufi. Waaye a yi, a hotiɗɗi haf ce ɓaatɗohoh yi min kerhiɗoh na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ŋ ineem, Nikiɗi Kooh pani'iɗta ɓoya, a neehha neeh nooɗiɗ. A nihissa ƴoh yino ngaŋ lah-fisaaraŋ ɗe, a rannga ɗiska na neh. ");
INSERT INTO sav_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nikiɗi Kooh ɓayya ƴoha a nihsoh ŋ ɓoya weem, a mahha ɓitiɓ naa, a kommba ɓoya ɗe. ");
INSERT INTO sav_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Wa ɓoya hot ɗe, a ƴeella, a woosa ne : « Waasii, yii a ƴohiŋ ƴoh ciŋ ngo na nehiŋ nehiŋ ngo ! Ɓoyii teeksan ɓo' ɓitiɓ, laam a kooɗohu ŋ ɓo' ƴaar. » ");
INSERT INTO sav_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Wa taamboh ɗaa po, ƴaar hey saɓsukohe na yaay na baab, a ŋoɗ ŋ ɓitiice, ɓa nik faan yino. ");
INSERT INTO sav_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Te wa nikka ne ɓeɗ ɓi kanak ceem, ƴaara na ɓitiice, ɓa nikee faan ɓarang te ɓa supkeeɗi nga. ");
INSERT INTO sav_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Waam, e iiñ uupee ñaañ ŋ ɗoopaat ciŋ nduufi Nikiɗi Kooh fere ; iiña woosa ɓitɓa ne : « Andi wa keeh ne, e Kooh woo ne, ɗu joyɗi ñam ali rim kidig, ŋ kidig ci ŋ ɗooƴ nguuki ? » ");
INSERT INTO sav_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɓitɓa loffa ɗe ne : « Ɓoo miniɗ ñam rim ciŋ kidig ci ŋ nguuki. ");
INSERT INTO sav_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Waaye ini kaɗ ŋ rim ciŋ kidgi ŋ leerniŋ nguuki, Kooh woo ne ɓoo kanaat ca ñam, ɓoo kanaat ca sah reɓ wala ɓoo hey kaane fut. » ");
INSERT INTO sav_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Iiña loffa ɗe ne : « Muk, ɗu heyɗi kaane. ");
INSERT INTO sav_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kooh inah inah ne, ɗu ñama ɗah, liiɓohaaciŋ ɗu hey rangsuke, ɗu hey inhisohe baahiɗ na baahaaɗi findiice. » ");
INSERT INTO sav_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ɓitɓa marakka rim caŋ kidga, a hotta ne ca moɗiɗ ŋ has, ca mandiɗ na ini neɓ, te ca maɗaah ñamu ne ca rangis liiɓoha. A ɓeennda nga, a ñammba, a nammba eɗ ƴaar ce raak ɗe nga, yeem ñammba. ");
INSERT INTO sav_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ŋ ɗiska ɗiska liiɓohaacaŋ ɓa rangsukka, weɗ ɓa inhiskoh kotii ne ɓa tas ɓarang ; ɓa ɓayya ɓi saaf mbaɗet, ɓa tokɗohha ca, ɓa kenukka ca. ");
INSERT INTO sav_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Wa noha soos po puuɗsa ef-efɗeeɗa, ɓoya na ɓitiice kerahha Nikiɗi Kooh wileeɗa ŋ nguuka, ɓa ɗembeeɗa ɗe ŋ kidig ca. ");
INSERT INTO sav_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nikiɗi Kooh ɓeeɗukka ɓo', a woosa ɗe ne : « Fu ŋ nde ? » ");
INSERT INTO sav_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A loffa ɗe ne : « Ŋ kerah ɗa kerah ŋ ɗooƴ nguuki, ŋ tiitta, weɗi ŋ ɗasɗukoh ɗa laam ŋ tas ɓarang. » ");
INSERT INTO sav_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nikiɗi Kooh woosa ɗe ne : « Moo, ya ɓa woo ɗa ne fu tas ɓarang ? Fu ñam ŋ kidgi ŋ sangohee ɗa e ? » ");
INSERT INTO sav_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ɓoya woosa ɗe ne : « E ɓitɓi fu ambsoh ho na ɗe, a yi eɗ to ŋ rim ciŋ kidgi, ŋ ñammba. » ");
INSERT INTO sav_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nikiɗi Kooh woosa ɓitɓa ne : « Wee ɓek ɗa ŋ ineem ? » Ɓitɓa woosa ɗe ne : « E iiñi ñaañoh ho po ŋ ñammbaa. » ");
INSERT INTO sav_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nikiɗi Kooh woosa iiña ne : « Ŋ ini fu tum weem, ŋ alkiɗ ɗa ngaŋ ɗoopaat ciŋ kahan ci na ciŋ bilaf fi jen, fu na hee hey faske te fu genan melemsuk ŋ muniŋ merhey mi ngaŋ kipes kiŋ ɗa jen. ");
INSERT INTO sav_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ŋ hey ɓeke sangtiɗoh ŋ harmban fu na ɓitɓi na harmban ɓi na hee rimkohe nga ɗa na ɓiŋ ɗe. Ɓi rimkohan nga ɗe hey pooke hafiŋ ɗa te fu ɗoɓan ɓa ŋ patang kot. » ");
INSERT INTO sav_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A nammba woo ɓitɓa ne : « Ŋ hey tume po, fu nik rook ɗah, fu laay miskiɗ, te fu ɓaslan ngaŋ miskiɗ. Fu hey ɗiiɗke ŋ ƴaar fu, waaye a yi yilfan ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A hannda woo ƴaara ne : « Fu kerhiɗ woo kiŋ ɓitiifu po fu ñamiɗ ŋ kidgi ŋ sangohee ɗa, fu tahiɗ po merhey mi alkuuɗ, ŋ kipes kiŋ ɗa jen fu hey yaaɓe ne fu han raak pesoha ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Wa hey paare ñapir na paangi raakiɗ rup te fu na hee hey guure kotii ne fu ñam. ");
INSERT INTO sav_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Fu pesohan opiŋ ɗa po mbaɗna fu dokkan ŋ kehƴi fu puloh. Laam fu haɓɗohu merhey te fu dokkan ŋ merhey mi. » ");
INSERT INTO sav_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ŋ ineem ƴaara teekka ɓitiice Aawa (pesohi). Laam a yi yaayiŋ ɓooɓi na pese jen. ");
INSERT INTO sav_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nikiɗi Kooh haɓɗiɗta Aadama na ɓitiice kulɓa und, a ɓekiɗta ɓa ca. ");
INSERT INTO sav_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","A woosa ne : « Ŋ ɗiski wa nik ndii, ɓo' inhisohiɗ baahiɗ na baahaaɗi findi ɓoo ; a joyɗi ɓeen kotii ŋ rim ciŋ kidgi na onohe kipes, a joyɗi ca ñam po kipes kiŋ ɗe kee nika po faw. » ");
INSERT INTO sav_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nikiɗi Kooh puliɗta ɗe ŋ nguuka ŋ Eden ne a guur merhey mi a mahohu. ");
INSERT INTO sav_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Wa a aañ ɓo', a ɗaakka ŋ pulohaaɗ-nohaŋ nguuka, niiɗoh ci na woyse seruben na ndang yongkaah wi na mbiliirke ɓak nu ɓak ne ɓa sangoh waasa kaɗ ŋ kidga na onohe kipes. ");
INSERT INTO sav_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ŋ finho ineem Aadama hunnda na ɓitiice Aawa, yeem ammba rook po a ɓasilla, a teekka kuɓka Kayin. A yi Aawa, a woosa ne : « Ŋ ɓaatɗohiŋ Nikiɗi ŋ raakiɗ ɓo' ƴaar. » ");
INSERT INTO sav_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","A raakissa kuɓu ƴaar wiiriis teeku Abel, taambɗoh Kayin. Abel nikka niiɗoh, Kayin nikka guuroh. ");
INSERT INTO sav_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Wa kaɗoh kaɗoh po Kayin ɓayya ŋ in ca a guure, a puliɗta seeƴkaah wuu Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel nammba ɓay ŋ saaw caŋ gat caŋ ɗe, a puliɗta seeƴkaah ngaŋ sepet caŋ mbaal ca uupee fayum. Ŋ ineem Nikiɗi neɓuusa ŋ Abel, a teyɗukka ina a eɗoh, ");
INSERT INTO sav_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","waaye a neɓuuɗi ŋ Kayin na ina a eɗoh. Ineem ɓekka Kayin aay-keeñ miskiɗ, a ñuusɗukka. ");
INSERT INTO sav_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nikiɗi meekissa ɗe ne : « Fu ayruk ye po fikiiriŋ ɗa mannda an ? ");
INSERT INTO sav_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tumohaaɗiŋ ɗa baah ɗah, fu hey teyɗukɗasse ; fu tumɗi baahiɗ ɗah, bakaaɗi weɗi wii raɗukka ŋ nguɓu tuuƴ fu na sekee ɗa, ne wa yilif ɗa, te ya fu joya min. » ");
INSERT INTO sav_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Waaye, Kayin woosa taambɗoh ce ne ɓa kaɗ yohon ca. Wa ɓa nik ŋ yohon ca, Kayin soonnga Abel, a appa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ɗekka po Nikiɗi meekissa ɗe ne : « Kayin, a nde taambɗoh fu Abel ? » A loffa ɗe ne : « Ŋ inahɗi kat, ñam na niiɗee ɗe haa. » ");
INSERT INTO sav_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nikiɗi woosa ɗe ne : « Fu haɓiɗ ye an ? Ŋ kerhiɗ ñif miŋ taambɗoh fu looƴkohha kehƴi po nga so ne wa wirndukɗu. ");
INSERT INTO sav_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Fu alkuuɗ po merhey mi faɗiɗ ɗa, laam ya fu aniɗa ñif miŋ taambɗoh fu fu aam. ");
INSERT INTO sav_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Fu guuris merhey mi ɗah, wa eɗissanɗi ɗa in. Fu na hee hey wiltiɗohe ŋ kehƴi, fu genanɗi ɗisik yino. » ");
INSERT INTO sav_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayin woosa Nikiɗi ne : « Ini fu deg go ɓitootiɗ lool po ŋ antalɗaa. ");
INSERT INTO sav_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Woti fu aañiɗ to ŋ merhey mi an e ? Ŋ hotiɗ ne ŋ hey ɗa use, mi na hee hey wiltiɗohe ŋ kehƴi, ŋ genanɗi ɗisik yino po ɓo' nu hot to ɗah, a ap po. » ");
INSERT INTO sav_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nikiɗi woosa Kayin ne : « Kon, ɓo' nu ap ɗa ɗah, fu hey wirndukɗasse waas yasna-kanak. » A waakiɗta Kayin inhisoha, ne ɓo' nu hot ɗe ɗah, a apuu ɗe. ");
INSERT INTO sav_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Wa taambohha ɗaa, Kayin kaɗta gena kur ka na woyse Nood, ŋ pulohaaɗ-nohaŋ Eden, a ussa Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayin hunnda na ɓitiice, yeem ammba rook po a ɓasilla, a teekka kuɓka Henok. Kayin yippa kur-taah, a teekkaa ngaŋ kuɓkiŋ ɗe Henok. ");
INSERT INTO sav_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok nikka baabiŋ Irad, Irad nikka baabiŋ Mehuya'el, Mehuya'el nikka baabiŋ Metusa'el, Metusa'el nikka baabiŋ Lemek. ");
INSERT INTO sav_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","A yi Lemek, a ɓayya ɓitiɓ kanak, yi koc na woyse Aada, yi kanakɗoh, Silla. ");
INSERT INTO sav_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada a yi rim Yabal, baab-caaciŋ ɓi na gene ŋ ɗiip ci, niiɗe gat ci. ");
INSERT INTO sav_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Taambɗoh ce ƴaar, ya teekse Yuubal, a yi baab-caaciŋ halmoh ci na mbiiɓoh ci. ");
INSERT INTO sav_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla, ɓitɓiŋ ɗe yinoora, rimmba Tubal-Kayin, sisɓi na tiɓe moos na tiwiñ. Tubal-Kayin raakeen taambɗoh ɓitiɓ teeku Naama. ");
INSERT INTO sav_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemek woosa ɓitiɓ ciŋ ɗe ne : « Ee, ɗu ɓi ɓitiɓ ciŋ ngo, Aada na Silla, Sikɗukaat woo kiŋ ngo. Heeh, sikɗukaat to, ɗu ɓi ɓitiɓ ciŋ Lemek. Ƴaar gaañiɗ to, ŋ appa ɗe, Komaaki ɓuurra so, ŋ boommba ɗe. ");
INSERT INTO sav_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Te nik ne e Kayin na hee wirndukɗasse waas yasna-kanak ne a apu ɗah, cam ! Lemek na hee wirndukɗasse waas ndaŋkiyaah-yasna-kanak na yasna-kanak (77) ! » ");
INSERT INTO sav_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aadama hunisseen na ɓitiice, a ambissa rook, a raakka kuɓu ƴaar, Aawa teekka ɗe Set, laam a woyee ne : « Kooh oniɗ to kuɓu wiiriis, yi na hee namsiɗe Abel, yi Kayin ap. » ");
INSERT INTO sav_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nammba raak kuɓu, a teekka ɗe Enos. Ŋ jamanoocaam, weɗ ɓa camboh ɓeeɗkoh Kooh ŋ tiikiŋ Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Inii weɗ naandsuku ŋ Aadama na ɓi rimkoh nga ɗe. Wa Kooh na fere ɓo', a fer ɓa ŋ mandohaaɗiŋ ɗe haf ce. ");
INSERT INTO sav_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A yi Kooh a ferra ɓa ƴaar na ɓitiɓ a barke'iɗta ɓa, a teekka ɓa ɓo' ŋ noha mbaɗi. ");
INSERT INTO sav_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Wa Aadama pes kiis teemet na kiis ndaŋkiyaah-kaahay (130), a raakka kuɓu ƴaar ya ɓay mandohaaɗaŋ ɗe na ñaamaaraŋ ɗe, a teekka ɗe Set. ");
INSERT INTO sav_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ŋ finho raakuukaŋ Set, Aadama pesiɗ kiis teemet-yasna-kaahay (800) te a raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah-kaahay (930). ");
INSERT INTO sav_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Wa Set pes kiis teemet na kiis yatuus (105), a raakka kuɓu ƴaar, a teekka ɗe Enos. ");
INSERT INTO sav_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ŋ finho raakuukaŋ Enos, Set pesiɗ kiis teemet-yasna-kaahay na kiis yasna-kanak (807). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah na kiis kanak (912). ");
INSERT INTO sav_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Wa Enos pes kiis ndaŋkiyaah-yasna-nikiis (90), a raakka kuɓu ƴaar, a teekka ɗe Kenan. ");
INSERT INTO sav_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ŋ finho raakuukaŋ Kenan, Enos pesiɗ kiis teemet-yasna-kaahay na kiis ndaŋkiyaah na kiis yatuus (815). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","A kaan wa a raak kiis teemet-yasna-nikiis na kiis yatuus (905). ");
INSERT INTO sav_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Wa Kenan pes kiis ndaŋkiyaah-yasna-kanak (70), a raakka kuɓu ƴaar, a teekka ɗe Mahalal'el. ");
INSERT INTO sav_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ŋ finho raakuukaŋ Mahalal'el, Kenan pesiɗ kiis teemet-yasna-kaahay na kiis ndaŋkiyaah-nikiis (840). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah (910). ");
INSERT INTO sav_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Wa Mahalal'el pes kiis ndaŋkiyaah-yasna-yino na kiis yatuus (65), a raakka kuɓu ƴaar, a teekka ɗe Yered. ");
INSERT INTO sav_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ŋ finho raakuukaŋ Yered, Mahalal'el pesiɗ kiis teemet-yasna-kaahay na kiis ndaŋkiyaah-kaahay (830). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","A kaan wa a raak kiis teemet-yasna-kaahay na kiis ndaŋkiyaah-yasna-nikiis na kiis yatuus (895). ");
INSERT INTO sav_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Wa Yered pes kiis teemet na kiis ndaŋkiyaah-yasna-yino na kiis kanak (162), a raakka kuɓu ƴaar, a teekka ɗe Henok. ");
INSERT INTO sav_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ŋ finho raakuukaŋ Henok, Yered pesiɗ kiis teemet-yasna-kaahay (800). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah-yasna-yino na kiis kanak (962). ");
INSERT INTO sav_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Wa Henok pes kiis ndaŋkiyaah-yasna-yino na kiis yatuus (65), a raakka kuɓu ƴaar, a teekka ɗe Matusalem. ");
INSERT INTO sav_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok hunee na Kooh. Ŋ finho raakuukaŋ Matusalem, a pessa ŋ ineem kiis teemet-kaahay (300). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ina a pes jen wa kiis teemet-kaahay na kiis ndaŋkiyaah-yasna-yino na kiis yatuus (365). ");
INSERT INTO sav_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok hunee na Kooh po a hotissuuɗi laam Kooh rapiɗ ɗe rapiɗ ŋ serooce. ");
INSERT INTO sav_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Wa Matusalem pes kiis teemet na kiis ndaŋkiyaah-yasna-kaahay na kiis yasna-kanak (187), a raakka kuɓu ƴaar, a teekka ɗe Lemek. ");
INSERT INTO sav_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ŋ finho raakuukaŋ Lemek, Matusalem pesiɗ kiis teemet-yasna-kanak na kiis ndaŋkiyaah-yasna-kaahay na kiis kanak (782). A raakisseen ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah-yasna-yino na kiis yasna-nikiis (969). ");
INSERT INTO sav_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Wa Lemek pes kiis teemet na kiis ndaŋkiyaah-yasna-kaahay na kiis kanak (182), a raakka kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A teekka ɗe Noohin te a woosa ne : « Ŋ alki Nikiɗi aluk kehƴi wii, yii a yi na hee eɗfiɗe coonaaniŋ ɓoo ŋ pangki. » ");
INSERT INTO sav_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ŋ finho raakuukaŋ Noohin, Lemek pesiɗ kiis teemet-yatuus na kiis ndaŋkiyaah-yasna-nikiis na kiis yatuus (595). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","A kaan wa a raak kiis teemet-yasna-kanak na kiis ndaŋkiyaah-yasna-kanak na kiis yasna-kanak (777). ");
INSERT INTO sav_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Wa Noohin pes kiis teemet-yatuus (500), a raakeen kuɓu kaahay, Sem na Haam na Yaafet. ");
INSERT INTO sav_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wa ɓo' ci camb ñimin ŋ adinaani, te ɓa raakka ɓi komaaki cafaƴ, ");
INSERT INTO sav_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","safaal ca hotta ne cafaƴ caŋ ɓo' ca moɗiɗ, ɓa ɓayya ɓitiɓ ngaŋ ɓi neɓ ɓa nga ɓa. ");
INSERT INTO sav_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ŋ ineem, Nikiɗi woosa ne : « Ŋ heyɗi faɗisse ɓo' a maañ na iiki ŋ tum nga ɗe, laam a huf dong. Hutiiniŋ kipes kiŋ ɗe hey nike kiis teemet na kiis ndaŋkiyaah-kanak (120). » ");
INSERT INTO sav_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ŋ jamanoocaam, wa raakeen ɓi puŋkal ŋ kehƴi, te ɓa raakisseen. Ɓeem ɓeɗ nikee jalmbaaca ɗeɓgaan te tiik ciŋ ɓa kerhuuɗ. Ɓa rimkohee ngaŋ safaal ca na cafaƴ ca. ");
INSERT INTO sav_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nikiɗi hotta ne ɓooɓa nikee ŋ kehƴi uupee nga uup añaand, te keeñ caŋ ɓa genee ɓa yurhiɗ ngaŋ in moɗaaɗi. ");
INSERT INTO sav_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","A raakka aay-keeñ nga, inwaaso ammba ɗe ŋ feri a fer ɓo' ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A woosa ŋ haf ce ne : « Ŋ hey ɗumbe ɓooɓi ŋ fer, ŋ hooliɗ ɓa ŋ kehƴi, ŋ faɗanɗi sah ɗoopaat ci, yakak na ƴin, po sel ci ; laam inwaaso ambiɗ to ŋ feri ŋ fer ca. » ");
INSERT INTO sav_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Waaye Nikiɗi baahoheen Noohin. ");
INSERT INTO sav_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Inii weɗ naandsuku ŋ Noohin. Noohin a nikee ɓo' yurhiɗ ngaŋ ɓooɓaŋ jamanoonaŋ ɗe, te a hunee na Kooh. ");
INSERT INTO sav_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noohin raakeen kuɓu ƴaar kaahay, Sem, Haam, na Yaafet. ");
INSERT INTO sav_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ɓooɓa genee ŋ kehƴi nikee yahrukohiɗ, te wa muuƴeeɗi Kooh, te ɗisik nu ɗisik raakeen tumohaaɗ moɗaaɗi. ");
INSERT INTO sav_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kooh marakka, a hotta ne kehƴi yahrukohiɗ laam, e pesiɗ ci hotkang jen nikee tumoh in moɗaaɗi. ");
INSERT INTO sav_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ineem tahha po Kooh woosa Noohin ne : « Ŋ ambiɗ ne ŋ hey ɗumbe ɓooɓi jen sagu riifɗi ɓa riifiɗ Adina na tumohaaɗ moɗaaɗi. Ŋ hey ɓa ɗumbe na kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Waaka kidig ndengiɗ, fu haɓɗiɗ haf fu in mand na wahnde yakak, wa min teembeer findi gaal. Wa raakaat ɓi tuuƴ, fu reefa godirong ŋ ɗooƴi na finhoori. ");
INSERT INTO sav_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Fu na hee wa haɓɗohe an : Hutiiniŋ wa nikaat saangal teemet na saangal ndaŋkiyaah-yatuus (150), angiini nik saangal ndaŋkiyaah-kanak na saangal yatuus (25) te njooliini nik saangal ndaŋkiyaah na saangal yatuus (15). ");
INSERT INTO sav_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Fu heya waakɗe kunoha, harmban wa na gaali nikaat suung yino. Fu heya haɓɗiɗe yahndeer ŋ hambuusiŋ wa, gaali raak nikoha kaahay, ŋ yoorɗi, ŋ leerni na ɗafki. ");
INSERT INTO sav_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ini kaɗ nga so, ŋ hey bembe kehƴi na masuɓ ne ŋ ap in nu na iike nga ɗah ; in nu nik ngaŋ kehƴi ɗah, a hey kaane. ");
INSERT INTO sav_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Waaye ŋ hey ambtiɗohe na ɗa. Fu hey aase ŋ ɗooƴ gaali na ɓitiifu na kuɓuuciŋ ɗa kaahay ci na ɓitiɓ ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Fu hey name ɓek ŋ gaali heet ɗoopaat nu nik ngaŋ kehƴi ɗah, naar yino na riɓ yino ne ca min muc na ɗa. ");
INSERT INTO sav_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Heet ciŋ ɗoopaat ci hey haye kanak kanak, sel ci na ɗoopaat ciŋ kehƴi, yakak na ƴin jen hey haye, ne ca min muc. ");
INSERT INTO sav_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Fu nak, ɓayndoha kañam nu nik, fu ɓek nga, fu raak pesoha, fu na ca. » ");
INSERT INTO sav_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noohin haɓɗohha in ceem jen ɗaa, findi Kooh nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Wa ineem raak, Nikiɗi woosa Noohin ne : « Aasa ŋ ɗooƴ gaali, fu na ɓi kahan fu laam, ŋ hot ɗa dong yurhiɗ ngaŋ ɓooɓiŋ jamanooniŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ɓayndoha ŋ ɗoopaat ci hooliɗ ci, riɓ yasna-kanak na naar yasna-kanak, na ci hoolaaɗiici, riɓ yino na naar yino, ");
INSERT INTO sav_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","na sel ci, riɓ yasna-kanak na naar yasna-kanak ; ne cuuɓ ciŋ ca min ris ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Laam, ndii na neeh yasna-kanak, ŋ hey toɓe toɓ yakak, ini ree neeh ndaŋkiyaah-nikiis (40). Ŋ ɗumb in ci ŋ fer na iike ŋ kehƴi jen. » ");
INSERT INTO sav_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noohin tumohhaa ɗaa, findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wa Noohin raak kiis teemet-yasna-yino (600), weɗ masuɓ riifɗoh kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","A aaseen ŋ ɗooƴ gaala, a yi na ɓitiice na kuɓuuciŋ ɗe kaahay ci na ɓitiɓ ciŋ ɓa, ne ɓa muc ŋ masma. ");
INSERT INTO sav_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ɗoopaat ci hooliɗ ci na ci hoolaaɗiici, sel ci na in ci ƴin ƴin ci na iike ŋ kehƴi jen, ");
INSERT INTO sav_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ca raakeen Noohin ŋ gaala kanak kanak, naar na riɓ, findi Kooh woyohee wa. ");
INSERT INTO sav_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Wa neeh ca yasna-kanak ca coot, masma cammba naaf kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Weɗ kiis ka Noohin raakoh kiis teemet-yasna-yino (600), wa caɓna kanakɗoha raak neeh ndaŋkiyaah na neeh yasna-kanak (17). Mbaɗi, masma laayohngaana nikee ŋ ɗooƴ kehƴi, pookkaa ŋ ɗisik laayiɗ, wa baliɗta. Eel ci rangsukka, ca nameeɗa juur masuɓ ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","A toɓeeɗa noha na weka, ini ree neeh ndaŋkiyaah-nikiis (40). ");
INSERT INTO sav_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mbaɗi, raak Noohin ŋ ɗooƴ gaala, na kuɓuuciŋ ɗe ƴaar ci Sem, Haam na Yaafet, na ɓitiice na ɓitiɓ ciŋ kuɓuuciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ɓa nikka ŋ ɗooƴ gaala na cuuɓ ciŋ ɗoopaat ci jen ; ciŋ bilaf fi na ciŋ kahan ci, in ci ƴin ƴin ci na iike ŋ kehƴi na sel ci. ");
INSERT INTO sav_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","In ci na iike jen raakka Noohin ŋ gaala kanak kanak, ");
INSERT INTO sav_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","naar na riɓ, findi Kooh woyohee wa. Ƴutta, Nikiɗi rannga buntaanaŋ gaala. ");
INSERT INTO sav_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Toɓa yuurkeeɗa noha na weka ini ree neeh ndaŋkiyaah-nikiis (40). Masma uupeeɗa nga rap po, wa meeɓpa gaala. ");
INSERT INTO sav_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wa ɓaatkeeɗa po, gaala teembeerra ŋ jola. ");
INSERT INTO sav_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Wa uupeeɗa nga ɓaatuk po, wa onnda tangooca uupee ɗafuk jen. ");
INSERT INTO sav_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Masma mirndohha kaɗ po, wa onnda tangooca ini ree saangal yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","In nu nik ne a iikeen ŋ kehƴi suyɗi ɗah, a kaaniɗ nga ; sel ca, ɗoopaat caŋ kahan ca na caŋ bilaf fa na in ca ƴin ƴin ca iikee ŋ kehƴi jen, kaaniɗ na ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","In nu nik ne a heɗ kiñin ŋ kehƴi suyɗi ɗah, a kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","In ca iikee ŋ kehƴi jen ceɗ Nikiɗi ambsoh, a ɗumbiɗta ca ; ɓo', ɗoopaat, in ca ƴin ƴin ca na sel ca. A faɗee Noohin dong na ɓa nikee na ɗe ŋ ɗooƴ gaala. ");
INSERT INTO sav_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Wa ineem raak, masma rissa oniɗ kehƴi ini ree neeh teemet na neeh ndaŋkiyaah-yatuus (150). ");
INSERT INTO sav_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ina masma na raake neeh teemet na neeh ndaŋkiyaah-yatuus (150) ŋ kehƴi jen, Kooh ɗaakkoheen Noohin nof, a yi na ɗoopaat ca nikee na ɗe ŋ gaala. Weɗ a puuɗsoh ŋ kehƴi, masma haawsukeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Wa pulohee ŋ ɗooƴ kehƴi na wa juurkohee ŋ eel ci, ca tufukka ; toɓa seekka. ");
INSERT INTO sav_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Masma cooteeɗa ƴin ƴin ; ŋ finho neeh teemet na neeh ndaŋkiyaah-yatuus ceem (150), wa haawsukka kotii. ");
INSERT INTO sav_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mbaɗi, caɓna yasna-kanakɗoh raakee neeh ndaŋkiyaah na neeh yasna-kanak (17) ; gaala gaƴca ŋ tangooca ŋ Ararat. ");
INSERT INTO sav_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Masma uupeeɗa nga haawsuk po ngaŋ mbeha koc ŋ caɓna ndaŋkiyaahɗoh, tangooca hotkeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Wa degga neeh ndaŋkiyaah-nikiis (40), Noohin rangissa palaŋteera a haɓɗiɗee gaala. ");
INSERT INTO sav_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A tuuƴca ngaak-suur ŋ hara, yeem kaɗeeɗa hayeeɗa, po findi masma ŋiisoh. ");
INSERT INTO sav_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noohin nammba tuuƴ hoɗ ne a inah andi masma ŋiisiɗ. ");
INSERT INTO sav_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Waaye a raakɗi ɗiski a yongan laam kehƴi riifeen na masuɓ, a dokukka. Noohin puliɗta yaah a ammba ɗe, a ɓekka ɗe ŋ ɗooƴ gaala. ");
INSERT INTO sav_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A sekissa neeh yasna-kanak, a tuuƴissa hoɗa. ");
INSERT INTO sav_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Na niina, a hayya na saaf oliiw as ŋ nguɓiŋ ɗe. Noohin inahha kotii ne masma haawsukiɗ ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A ɓaatta sek neeh yasna-kanak a tuuƴissa hoɗa, yeem taalndiɗta, a dokkisɗi nga ɗe. ");
INSERT INTO sav_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kiis ka Noohin raakoh kiis teemet-yasna-yino na kiis yino (601), ŋ caɓna koc nga, ŋ mbeha adug nga, raak masma reehiɗ ŋ kehƴi. Noohin kunissa gaala, a marakka, a hotta ne kehƴi suyiɗ. ");
INSERT INTO sav_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Wa caɓna kanakɗoh raak neeh ndaŋkiyaah-kanak na neeh yasna-kanak (27), raak kehƴi suyiɗ kong, ");
INSERT INTO sav_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","weɗ Kooh woyoh Noohin ne : ");
INSERT INTO sav_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Pula gaali, fu na ɓitiifu na kuɓuuciŋ ɗa na ɓitiɓ ciŋ ɓa ; ");
INSERT INTO sav_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","fu puliɗ cuuɓ ciŋ ɗoopaat ci nik na ɗa, ciŋ kahan ci na ciŋ bilaf fi, sel ci na in ci ƴin ƴin ci jen ; ca pasarkohaat, ca nikaat ɓasloh, ca rimaatɗohaat laayiɗ ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noohin pulla gaala, na ɓitiice, na kuɓuuciŋ ɗe ƴaar ci, na ɓitiɓ caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ɗoopaat ca jen, na sel ca na in ca ƴin ƴin ca ; ca puleeɗa gaala cuuɓ cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ƴutta, Noohin haɓiɗta seeƴkiɗoha haf ce ŋ Nikiɗi, a ɓayya ŋ ɗoopaat ca hooliɗ ca na ŋ sel ca hooliɗ ca, a hoomiɗta ca nga. ");
INSERT INTO sav_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Wa eeñɗeem ree ŋ Nikiɗi, a neɓuusa nga, a woosa ŋ ɗooƴ ce ne : « Ŋ heyɗi alkisse kehƴi muk sagu ɓo'. Wa keeh ne ŋ kikomaakiikaŋ ɓa, weɗ keeñ ciŋ ɓa na cambohee ɓa hiir ŋ in moɗaaɗi ; ŋ heyɗi ɗumbɗisse in ci na pese ŋ kehƴi muk ŋ findi ŋ tumoha an. ");
INSERT INTO sav_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Feeh kehƴi wii nga ɗah, in cii kurkohanɗi nga : sok na nguɗ, doh na soos, yuk na reh, noh na wek. » ");
INSERT INTO sav_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ŋ ineem, Kooh barke'iɗta Noohin na kuɓuuciŋ ɗe, a woosa ɓa ne : « Nikaat ɓasil, rimaatɗohaat po ɗu riifiɗ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ɗiski wa nik ndii ɗoopaat ciŋ kehƴi na sel ci na in ci ƴin ƴin ci ŋ kehƴi na cuurund ci, ca hey ɗu neƴƴohe laam, ŋ hey ca dege ŋ yaah ciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Findi kidig ci, in ci na pese te ca yoonde, ŋ eɗiɗ ɗu ca jen, ca kañam nga ɗu kotii. ");
INSERT INTO sav_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Waaye ɗu heyɗi ñame sepet na kipes kiŋ wa, weɗ ne, na ñif miŋ wa. ");
INSERT INTO sav_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ñif miŋ ɗu, weɗ nam nik kipes kiŋ ɗu ; weɗ tah ɗoopaat mbaa ɓo' nu aam ñif ɓo' ɗah, ŋ hey ɗa wa taambe ; yaa nu aam ñif miŋ morom fu ɗah, ŋ hey ɗa wa meekse. ");
INSERT INTO sav_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ɓo' nu aam ñif ɓo' ɗah, wiŋ ɗa hey aamse ; laam Kooh fer ɓo' ŋ ñaamaariŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nikaat ɓasloh, rimaatɗohaat po ɗu riifiɗ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kooh woyissa Noohin na kuɓuuciŋ ɗe ne : ");
INSERT INTO sav_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Mi yii ambtiɗoh na ɗu na ɓi na hee rimkohe nga ɗu, ");
INSERT INTO sav_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na in ci na pese na ɗu jen, findi sel ci na ɗoopaat ciŋ kahan ci na ciŋ bilaf fi, ceɗ ci pul na ɗu ŋ gaali na in ci na hee pese ŋ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ambtiɗohiŋ ngo na ɗu, wa na hee nikohe an : Ŋ heyɗi boomisse kipes na masuɓ laayiɗ te masuɓ laayiɗ ɗumbissanɗi kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","A hannda deg nga ne : « Inii weɗ na hee teeɓohe ambtiɗohiŋ ngo na ɗu, ɗu na in ci na pese na ɗu, gomal nu gomal. ");
INSERT INTO sav_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ŋ tumiɗ ñaangi-ñaangiiniŋ ngo ŋ eel ci weɗ ini na hee teeɓohe ambtiɗohiŋ ngo na ɓi kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ŋ nangɗoh eel ci ŋ ɗafki te ñaangi-ñaangiini pul ɗah, ");
INSERT INTO sav_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ŋ hey naandsuke harmban ndo na ɗu na cuuɓ ciŋ ɗoopaat ci jen. Masuɓ laayiɗ ɗumbissanɗi heɗ kiñin ci. ");
INSERT INTO sav_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ŋ hot ñaangi-ñaangiini puliɗ ɗah, ŋ naandsuk ambtiɗohi ŋ ambtiɗoh po faw na in ci na pese ŋ kehƴi jen. » ");
INSERT INTO sav_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kooh woyissa Noohin ne : « Ini teeɓoh ambtiɗohiŋ ngo na ɓi kehƴi, weɗi weem. » ");
INSERT INTO sav_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kuɓuuciŋ Noohin ɓa puloh ŋ gaala nikee Sem na Haam yi baabiŋ Kanaan, na Yaafet. ");
INSERT INTO sav_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ɓeɗ ɓi kaahay cii, ɓeɗ caacuuciŋ ɓooɓiŋ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noohin nikka guuroh, a yi koc guur reseñ. ");
INSERT INTO sav_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wa raakka mbeh, a annda ŋ biiñaŋ wa po a laarra, a wolsukka po a hoolla ŋ ɗooƴ ɗiipaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haam, baabiŋ Kanaan, hotta ɗe tas-ɓarang ; a woosa taambɗoh caŋ ɗe kanak ca nikee ŋ hara wa. ");
INSERT INTO sav_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ŋ ineem, Sem na Yaafet ɓayya uuf, ɓa deggaa ŋ yuug caŋ ɓa, ɓa tiindeeɗa paa finho po ɓa reesa, ɓa ulla ɗe wa. Ɓa yurhiɗkoheeɗi na baab ɓa laam ɓa waaɗeeɗi ɗe hot tas-ɓarang. ");
INSERT INTO sav_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wa Noohin laarsuk, a inahha ini kuɓkiŋ ɗe ƴini tum, ");
INSERT INTO sav_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","a woosa ne : « Kanaan nikaat ñaami uup heefu ŋ ñaam ciŋ ɓaah ciŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A ɓaatta nga ne : « Nikiɗi Koohiŋ Sem, a yakɗaah ! Kanaan nikaat ñaamiŋ Sem ! ");
INSERT INTO sav_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kooh ɓaataat saangniŋ Yaafet te a gen na Sem ŋ jam ŋ genohaacaŋ yeem. Kanaan namaat nik ñaamiŋ Yaafet. » ");
INSERT INTO sav_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ŋ finho toɓa yakka Noohin pesisiɗ kiis teemet-kaahay na kiis ndaŋkiyaah-yatuus (350). ");
INSERT INTO sav_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A kaan wa a raak kiis teemet-yasna-nikiis na kiis ndaŋkiyaah-yatuus (950). ");
INSERT INTO sav_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Inii weɗ naandsuku ŋ kuɓuuciŋ Noohin : Sem, Haam na Yaafet na ɓi rimkoh nga ɓa. Ŋ finho masma ɗumbee kehƴi, ɓa raakeen ɓi kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ɓi rimkoh ŋ Yaafet nikee : Goomeer, Maagoog, Maaday, Yaawaan, Tubaal, Mesek na Tiiraas. ");
INSERT INTO sav_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Askenas na Riifat na Toogarma, ɓa puloh ŋ Goomeer. ");
INSERT INTO sav_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Eliisa, Tarsis, Kitiim na Doodaanim pulohha ŋ Yaawaan. ");
INSERT INTO sav_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ɓi puloh nga ɓa, ɓeɗ genee huntiɗkohiɗ na cookmi, ɓa ɓaatkeeɗa. Ɓaa nu ɓaaheen peɗeem ɗah, ɓaahha kur ; ɓa gennda cuuɓ cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ɓi rimkoh ŋ Haam nikee : Kuus, Misrayim, Puut na Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Sebaa, Hawiilaa, Sabtaah, Ra'amaa na Sabtekaa puloh ŋ Kuus. Sabaa na Deedaan nammba puloh ŋ Ra'amaa. ");
INSERT INTO sav_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuus a yi nam rim Nimrood, ƴaara koc nik jalmba kerhuuɗ ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","A nikee kaalsukoh yakak ŋ fiki Nikiɗi, po ɓa meeɗ woo ne : « Kaalsukoh yakak ŋ fiki Nikiɗi findi Nimrood. » ");
INSERT INTO sav_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kur-taah ca koc ŋ nguuraŋ ɗe ceɗ Baabel, Erek, Akkad na Kalne ngaŋ Sinyaar. ");
INSERT INTO sav_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrood puloh kur keem, a kaɗta Assuur a yippa kur-taah cii : Niniw, Rehobotiir, Kaalah ");
INSERT INTO sav_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Resen, kur-taaha yakka ŋ harmban Niniw na Kaalah. ");
INSERT INTO sav_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Luud, Anaam, Lehaab, Naftuh, Patarus, Kasluh na Kaftoor puloh ŋ Misrayim. Ɓi puloh ŋ Kasluh, ɓeɗ rim Filistiici. ");
INSERT INTO sav_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan saawkoh Sidoon, a degga Het nga. ");
INSERT INTO sav_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Het a yi caaciŋ Yebuus ci, Amoor ci, Girgaas ci, ");
INSERT INTO sav_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiw ci, Arkaaci, Sin ci, ");
INSERT INTO sav_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaad ci, Semaar ci na Hamaat ci. Ŋ mirndaani ɓi puloh ŋ Kanaan pasarkohha cuuɓ-cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ɓeɗ genee ini amboh Sidoon na ɓak Gerar po ŋ Gasaa ; na Sodom, Gomor, Atma na Seboyim, kaɗeeɗa po Leesa. ");
INSERT INTO sav_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ɓeem ɓeɗ ɓi puloh ŋ Haam. Ɓaa nu ɓaaheen peɗeem ɗah, ɓaahha kur ; ɓa gennda cuuɓ-cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem yi yakak Yaafet nameen raak ɓi kuɓu ƴaar, a yi caaciŋ Eber na ɓi puloh nga ɗe jen. ");
INSERT INTO sav_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ɓi rimkoh ŋ Sem nikee : Elaam, Assuur, Arpaksad, Luud na Aram. ");
INSERT INTO sav_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Uus, Huul, Geter na Maas pulohha ŋ Aram. ");
INSERT INTO sav_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad nikka baabiŋ Selah, Selah nikka baabiŋ Eber. ");
INSERT INTO sav_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber raakka kuɓu ƴaar kanak, yinoora teeksee Peleg laam a raaku ŋ jamanoona kehƴi paysohu. Taambɗoh ce teeksee Yaktaan. ");
INSERT INTO sav_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ɓii ɓeɗ puloh ŋ Yaktaan : Almodaad, Seelef, Hasarmaawet, Yeera, ");
INSERT INTO sav_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraam, Usaal, Diklah, ");
INSERT INTO sav_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaal, Abima'eel, Sabaa, ");
INSERT INTO sav_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawiilaa na Yoobaab ; ɓii jen ɓa puloh ŋ Yaktaan. ");
INSERT INTO sav_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ɓa genee ŋ harmban Messa na tangoocaŋ Sefaar, ŋ pulohaaɗ-noh. ");
INSERT INTO sav_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ɓeem ɓeɗ ɓi puloh ŋ Sem. Ɓaa nu ɓaaheen peɗeem ɗah, ɓaahha kur ; ɓa gennda cuuɓ-cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Cuuɓ ceem ceɗ puloh ŋ kuɓuuciŋ Noohin, findi ɓa ɓaahoh na findi ɓa genoh. Ɓi kur ci pasarkoh ŋ Adina jen puloh nga ɓa, ŋ finho ɗumbuukaŋ kehƴi na masuɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bala ɓa pasarkohan ɗah, ɓooɓiŋ kehƴi jen jombee peɗeem yino ");
INSERT INTO sav_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","po ŋ jamanoona ɓa kurkoh pulohaaɗ-noh. Ɓa kaɗoh kaɗoh po ɓa reesa ŋ oon angiɗ ŋ kur ka na woyse Sinyaar, ɓa yippa nga. ");
INSERT INTO sav_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ɓa woosa ŋ harmban ɓa ne : « Ɓoo muulaat, ɓoo ut ca. » Ɓa ɓayee muul findi atoh taɓahoha na godirong findi simong. ");
INSERT INTO sav_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ɓa woyissa ne : « Ɓoo haɓɗaat kur-taah, ɓoo taɓah nga taɓah jimimim po wa maangee ŋ eel ca, wa hey tahe po ɓoo raak tiik te ɓoo heyɗi pasarkohe ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Weɗ Nikiɗi ruhsoh ne a marak kur ka na taɓaha ɓooɓi ŋ kehƴi tufkiɗe. ");
INSERT INTO sav_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A woosa ŋ haf ce ne : « Findi ɓa camboh an, ɓa nikka cuuɓ yino, ɓa ɓaahha peɗeem, ali in wooñissanɗi ɓa ŋ in nu ɓa waaɗ tum ɗah. ");
INSERT INTO sav_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mbaa ɗah, ɓoo ruhsaat, ɓoo ɗalohiɗ woo ciŋ ɓa po ɓaa nu nga ɗah, kerhuu peɗmi ɓinooɓi na woye. » ");
INSERT INTO sav_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nikiɗi pasarohha ɓa ŋ kehƴi jen ; kur ka ɓa taɓahee toppa ndaam. ");
INSERT INTO sav_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Weɗ tah ɓa teekkaa Baabel laam, ŋ ndaam weɗ Nikiɗi ɗalohiɗ peɗeem ci, a pasarohha ɓooɓi ngaŋ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Inii weɗ naandsuku ŋ Sem na ɓi rimkoh nga ɗe. Wa Sem pes kiis teemet (100), a raakka kuɓu ƴaar, a teekka ɗe Arpaksad, raak toɓa yakka cootiɗ po wa tummba kiis kanak. ");
INSERT INTO sav_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ŋ finho raakuukaŋ Arpaksad, Sem pesiɗ kiis teemet-yatuus (500). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Wa Arpaksad pes kiis ndaŋkiyaah-kaahay na kiis yatuus (35), a raakka kuɓu ƴaar, a teekka ɗe Selah. ");
INSERT INTO sav_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ŋ finho raakuukaŋ Selah, Arpaksad pesiɗ kiis teemet-nikiis na kiis kaahay (403). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Wa Selah pes kiis ndaŋkiyaah-kaahay (30), a raakka kuɓu ƴaar, a teekka ɗe Eber. ");
INSERT INTO sav_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ŋ finho raakuukaŋ Eber, Selah pesiɗ kiis teemet-nikiis na kiis kaahay (403). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Wa Eber pes kiis ndaŋkiyaah-kaahay na kiis nikiis (34), a raakka kuɓu ƴaar, a teekka ɗe Peleg. ");
INSERT INTO sav_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ŋ finho raakuukaŋ Peleg, Eber pesiɗ kiis teemet-nikiis na kiis ndaŋkiyaah-kaahay (430). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Wa Peleg pes kiis ndaŋkiyaah-kaahay (30), a raakka kuɓu ƴaar, a teekka ɗe Reyu. ");
INSERT INTO sav_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ŋ finho raakuukaŋ Reyu, Peleg pesiɗ kiis teemet-kanak na kiis yasna-nikiis (209). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Wa Reyu pes kiis ndaŋkiyaah-kaahay na kiis kanak (32), a raakka kuɓu ƴaar, a teekka ɗe Serug. ");
INSERT INTO sav_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ŋ finho raakuukaŋ Serug, Reyu pesiɗ kiis teemet-kanak na kiis yasna-kanak (207). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Wa Serug pes kiis ndaŋkiyaah-kaahay (30), a raakka kuɓu ƴaar, a teekka ɗe Nahor. ");
INSERT INTO sav_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ŋ finho raakuukaŋ Nahor, Serug pesiɗ kiis teemet-kanak (200). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Wa Nahor pes kiis ndaŋkiyaah-kanak na kiis yasna-nikiis (29), a raakka kuɓu ƴaar, a teekka ɗe Tera. ");
INSERT INTO sav_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ŋ finho raakuukaŋ Tera, Nahor pesiɗ kiis teemet na kiis ndaŋkiyaah na kiis yasna-nikiis (119). A nameen raak ɓi kuɓu ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera raakeen kuɓu ƴaar kaahay, Ibram, Nahor na Haaraan, wa a raak kiis ndaŋkiyaah-yasna-kanak (70). ");
INSERT INTO sav_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Inii weɗ naandsuku ŋ Tera na ɓi rimkoh nga ɗe ; Tera a yi baabiŋ Ibram na Nahor na Haaraan yi rim Loot. ");
INSERT INTO sav_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraan yeem a kaanoh kur ɓa, ŋ kur-taaha na woyse Uur ŋ Babilon, raak baab ɓa peseeɗa. ");
INSERT INTO sav_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ɓiti Ibram teeksee Saraay, yiŋ Nahor nikka Milka, kuɓkiŋ Haaraan. Haaraan a yi namee nik baab ɓi Iska. ");
INSERT INTO sav_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Waaye, Saraay mineeɗi raak kuɓu, a jaasiree jaasir. ");
INSERT INTO sav_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Wa raakka mbeh, Tera kurkohha Uur ŋ Babilon a toorkeeɗa Kanaan. A ɓayndohha kuɓkiŋ ɗe Ibram, na setiŋ ɗe Loot kuɓkiŋ Haaraan. A nammba ɓayndoh payum ce Saraay ɓiti Ibram. Ɓa kaɗoh kaɗoh po ŋ waas, ŋ kur-taaha na woyse Haaraan, ɓa yippa nga. ");
INSERT INTO sav_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera kaanohha ndaam raak ɗe pesiɗ kiis teemet-kanak na kiis yatuus (205). ");
INSERT INTO sav_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ɓi kahan Tera, ɓeɗ gen ŋ Haaraan po wa raakka mbeh, Nikiɗi woosa Ibram ne : « Faɗa kur ki fu genoh, fu faɗ ɓaah ciŋ ɗa, fu nam faɗ ɓi kahan baabiŋ ɗa ; fu yurah ŋ kur ka maa hee ɗa teeɓe. ");
INSERT INTO sav_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ŋ hey ɗa barke'ɗe, ŋ pulɗoh cuuɓ angiɗ nga ɗa, ŋ yakiɗ tiikiŋ ɗa te fu nik camboha barke. ");
INSERT INTO sav_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ɓooɓi waaɗɗan ɗa moɗiɗ, ŋ barke'iɗ ɓa, te ɓo' nu waaɗiɗ ɗa moɗaaɗi ɗah, ŋ aluk ɗe. Cuuɓ ciŋ kehƴi jen raakohan barke saguufu. » ");
INSERT INTO sav_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ŋ finho inaam, Ibram kaɗta findi Nikiɗi woyoh ɗe wa. Loot, kuɓkaŋ taambɗoh ce, hunee na ɗe. Wa Ibram na kurke ŋ Haaraan waam tel ɗe raakiɗ kiis ndaŋkiyaah-yasna-kanak na kiis yatuus (75). ");
INSERT INTO sav_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A ɓayndohha ɓitiice Saraay, na Loot, yi kuɓu nga ɗe, na in ca ɓa raakoh ŋ Haaraan jen na ñaam caŋ ɓa. Ɓa pulla, ɓa kaɗeeɗa po ɓa reesa Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Wa Ibram ree, raak ɓi Kanaan geniɗ ŋ kur ka, a taammbaa ŋ leerna po kidga yakka ŋ Moore ngaŋ Sisem. ");
INSERT INTO sav_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ŋ ndaam Nikiɗi teeɓukka ɗe, woosa ɗe ne : « Kur kii jen ŋ hey wa eɗe ɓi rimkohan nga ɗa. » Ibram haɓiɗta seeƴkiɗoha haf ce ŋ Nikiɗi, laam a yi teeɓuk ɗe nga. ");
INSERT INTO sav_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Wa a ƴuta haɓiɗ, a kurukka, a yurahha tangooca lak Betel pulohaaɗ-noh ; a yippa ɗiipaŋ ɗe ŋ harmban Betel na Ay. Betel lakkaa muyohaaɗ-noh, Ay pulohaaɗ-noh. Ŋ ndaam a haɓiɗta seeƴkoha, a gidimmba Nikiɗi na ñaamuk. ");
INSERT INTO sav_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Wa a puloh nga, a yongsukeeɗa ƴin ƴin ŋ ɓak Negef. ");
INSERT INTO sav_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Waam, aɗ raakeen ŋ kur ka, Ibram kaɗta Misra ne a nikohaah nga laam aɗa miskeen. ");
INSERT INTO sav_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wa a kaɗ po a heeɗa aase Misra, a woosa ɓitiice Saraay ne : « Sikɗuk ko, ŋ inhiɗ ne fu moɗiɗ lool, ");
INSERT INTO sav_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ɓi Misra hot ɗa ɗah, ɓa hey woye ne fu ɓitiiso te ɓa hey yo ape fu tas. ");
INSERT INTO sav_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ngalla ɓoo ree ɗah, fu na woye ne ɓoo taambɗoh taambɗoh ; ineem hey tahe po ɓa taambkoh ho saguufu, te fu hey tahe po, ŋ pes. » ");
INSERT INTO sav_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Wa Ibram ree kur ka, ɓi Misra hotta ne ɓitiice moɗiɗ lool. ");
INSERT INTO sav_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Huntoh caŋ Firawnaana, buuraŋ Misra nammba ɗe hot, ɓa laasukka ɗe ŋ fikiice, a yi Saraay a ɓayuusa kahan Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","A tahha po Ibram taambkohuusa moɗoɗ, Firawnaana onnda ɗe ɓi gat : pe', mbaal, inoh, mbaam, naar na riɓ na ngeelemb, na ɓi ñaam, ƴaar na ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Waaye Nikiɗi ruhsiɗta naamo miskiɗ ŋ Firawnaana na ɓi kahan ce sagu Saraay ɓiti Ibram. ");
INSERT INTO sav_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Weɗi Firawnaana ɓeeɗkoh Ibram woosa ɗe ne : « Ini fu haɓiɗ to wii nak ! Wa ye tah po fu wooɗi so ne a ɓitiifu ? ");
INSERT INTO sav_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Wa ye tah fu woosa ne ɗu taambɗoh ? Wa tahha po ŋ ɓayya ɗe ɓitiɓ. Ɗiski wa nik ndii, ɓitiifu a yi, ɓayaa ɗe te fu coot. » ");
INSERT INTO sav_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firawnaana nakka huntoh caŋ ɗe ne ɓa pulɗaat Ibram na ɓitiice, na ina a raak jen ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Wa Ibram na pulɗasse Misra na ɓitiice, na raak-raakaŋ ɗe jen, a gurdeeɗa Negef, Loot nikangee na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibram raakeen lool, a amboheen ɓi gat yakoh na yakoh, na haalis na urus laayoh na laayoh. ");
INSERT INTO sav_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A pulohha Negef, a yongsukeeɗa ƴin-ƴin po Betel ŋ ɗiska a kocee ndut ŋ harmban Betel na Ay. ");
INSERT INTO sav_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A ɓeeɗkohha Kooh ŋ tiikiŋ Nikiɗi ŋ seeƴkohaana a ɗeɓee haɓiɗ ŋ ndaam. ");
INSERT INTO sav_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loot, yi hunee na ɗe, nameen raak ɓi gat pe', mbaal na inoh, na ɗiip ca ɓooɓaŋ ɗe nikohe. ");
INSERT INTO sav_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ɓa haɓisseeɗi ŋ kur ka, laam raak-raakaŋ ɓa laayeen po ɓa minisseeɗi gen ŋ ɗisik yino ; ");
INSERT INTO sav_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","te yit, Peris ca na Kanaan ca namee gen nga. Ayrukoh raakka ŋ harmban niiɗoh caŋ Ibram na ɓaŋ Loot. ");
INSERT INTO sav_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Weɗi Ibram woyoh Loot ne : « Ngalla, ayrukoh kanaat raak ŋ harmban mi na ɗa, na harmban niiɗoh ciŋ ɓoo, laam e ɓoo ɓaah. ");
INSERT INTO sav_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kon mbaa ɗah, ɓoo saɓsukohaat, marka inii jen ŋ kur ki, fu kooɗ ŋ yaah-sing ɗah, ŋ kooɗ ŋ yaah-ñaahum ; fu kooɗ ŋ yaah-ñaahum ɗah, ŋ kooɗ ŋ yaah-sing. » ");
INSERT INTO sav_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Wa Loot marak kehƴa wil kalaŋ Yurdan, a hotta ne wa iiri po Sowar, weem raak Nikiɗi ɗumbɗi Sodom na Gomor ndoom, wa mandee na nguukaŋ Eden, findi kehƴiŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loot waɗukka kehƴaŋ Yurdan, a yongsukka ŋ pulohaaɗ-noh ; ɓa saɓsukohoh ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibram gennda ŋ Kanaan, Loot kaɗta ndutta ŋ sero kur caŋ Yurdan, a yippa ɗiip caŋ ɗe ŋ ɓak Sodom. ");
INSERT INTO sav_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ɓi Sodom nikee aƴaarkiɗ, bakaaɗoh yakak ŋ fiki Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Wa Ibram paysukoh na Loot, Nikiɗi woosa ɗe ne : « Marka baahiɗ ŋ fikiifu, na finhoofu na yaah-sing, na yaah-ñaahum, ");
INSERT INTO sav_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","laam kur ki fu na hote wii jen, ŋ hey ɗa wa one po faw, fu na ɓi na hee rimkohe nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ŋ hey ɓaate ɓi na hee rimkohe nga ɗa po ɓa mand na merhey miŋ kehƴi, ɓo' minanɗi ɓa kind, findi ɓo' minohɗi kind merhey miŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kurka, fu taambiɗ kur ki jen ŋ hutiiniŋ wa na angiiniŋ wa, laam maa hee ɗa wa one. » ");
INSERT INTO sav_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ƴutta, Ibram ɗoffa ndutaŋ ɗe, a kaɗta, a yippa ŋ kidig ca yakak caŋ Mamre ŋ ɓak Hebron, ŋ ndaam a haɓiɗta seeƴkoha wuu Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wa nikee wa Amrafel nikoh buuraŋ Sinyaar, Aryok nikka yaŋ Elasaar, Kedorlamer yaŋ Elaam na Tidyal yaŋ Goyim ; ");
INSERT INTO sav_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ɓa hunnda na ɓooɓaŋ ɓa, ɓa hiñoheeɗa na Bera buuraŋ Sodom na Birsa yaŋ Gomor, Sinyab yaŋ Atma, Semeber yaŋ Seboyim na yaŋ Bela, weɗi Sowar. ");
INSERT INTO sav_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ɓeɗ ɓi yatuus cii, ɓeɗ ambsukohee ŋ oonaŋ Sidim weɗi Cookmiŋ-Meɗaami woti-woti. ");
INSERT INTO sav_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Raak wa tumeen kiis ndaŋkiyaah na kanak (12) ca fu inah ne, e Kedorlamer a yi adgiɗee ɓa, waaye ŋ kiis ka taamb nga ɓa sannga inaam. ");
INSERT INTO sav_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Wa tummba kiis kotii, tahha po, Kedorlamer na buur ca hunee na ɗe heeɗa nga ɓa. Ɓa kocca laɓ Refay ca ngaŋ Asterot-Karnayim, Sus ca ngaŋ Ham, Em ca ngaŋ jooraŋ Kirsatayim, ");
INSERT INTO sav_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hoor ca ngaŋ tangoocaŋ ɓa teeku Seyiir. Ɓa ngekeeɗa ɓa, po ŋ El-Paran ŋ sero kehƴa hulanga. ");
INSERT INTO sav_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ɓa pulohha nga, ɓa gurdohha En-Mispat, weɗi Kades ; ɓa degga kur kaŋ Amalek ca jen yaah. Ƴutta ɓa nammba keen Amoor ca genee Hasason-Tamaar. ");
INSERT INTO sav_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Wa ɓa juuɓee Sodom na Gomor na Atma na Seboyim na Bela, wi Sowar, buur caŋ kur cii puliɗta jalmbaacaŋ ɓa ; ɓa kaɗta hiñoha ŋ oonaŋ Sidim ");
INSERT INTO sav_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","na Kedorlamer buuraŋ Elaam, Tidyal yaŋ Goyim, Amrafel yaŋ Sinyaar na Aryok yaŋ Elasaar ; buur yatuus cohha na buur nikiis. Yatuus ca minuusa, ɓa saandoheeɗa. ");
INSERT INTO sav_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Wa buur caŋ Sodom na Gomor saandohee, raak woong koltaar laayeen ŋ oonaŋ Sidim, ɓum keennda nga ca. Ɓi raawɗi kaan kaɗta ɗemmba ŋ tangooca. ");
INSERT INTO sav_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ɓi ngekee ɓa guridda, ɓayya in ca Sodom na Gomor ambohee jen findi raak-raak na pesoha, ɓa cootta na ca. ");
INSERT INTO sav_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loot yi kuɓu ŋ Ibram nameen ɓayndohu na ina a raakee jen, laam raak ɗe ŋ Sodom. ");
INSERT INTO sav_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Yino ŋ ɓi fusee kaɗta, woosa Ibram wa, yi ɓaah ngaŋ Heber ci ; raak ɗe yip ngaŋ kidig ca yakak caŋ Mamre, yi ɓaah ngaŋ Amoor ci. Mamre raakeen taambɗoh kanak, Eskol na Aner. Ɓeɗ ɓi kaahay ceem ɓa langee na Ibram. ");
INSERT INTO sav_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Wa Ibram kerah ne Loot, kuɓkaŋ taambɗoh ce ambuuɗ, a cohɗohha ɓa min hiñoh ŋ ƴaaɓa rimohu kahan ce ; ɓa nikee teemet-kaahay na ndaŋkiyaah na yasna-kaahay (318). Ɓa, na ɓi langee na ɓa, taambiɗta buur ca po ŋ Daan. ");
INSERT INTO sav_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ibram paysohha ƴaaɓaŋ ɗe, ɓa keennda ɓa na weka, ɓa laɓpa ɓa, ɓa ngekeeɗa ɓa po ŋ Hobah, ŋ finho Damas. ");
INSERT INTO sav_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A naaffa in ca ɓa raak jen, a naafndohha Loot na raak-raakaŋ ɗe na ɓitiɓ ca na ɓa ambsee ñaam jen. ");
INSERT INTO sav_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wa Ibram laɓ Kedorlamer na langtoh caŋ ɗe po a gurdeeɗa, buuraŋ Sodom pulla kaɗta coha na ɗe ŋ oonaŋ Sawe, wa na woyse Oonaŋ-Buur. ");
INSERT INTO sav_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek, buuraŋ Salem, nammba hay na mbuuru na biiñ, a yi seeƴkiɗohi na seeƴkiɗohe wuu Kooh yi ŋ ɗafka ɗafka. ");
INSERT INTO sav_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A kiimiɗta Ibram barke an : « Kooh yi ŋ ɗafka ɗafka, yi fer eel ci na kehƴi, barke'ɗaat Ibram ; ");
INSERT INTO sav_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kooh yi ŋ ɗafka ɗafka, yi amboh ɗa po fu minnda ɓa fu hiñohee na ɓa, a yakɗaah yakɗu. » Ibram eɗta ɗe ŋ in ca a naafee, ndaŋkiyaah nu nik ɗah, winooraŋ wa. ");
INSERT INTO sav_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Wa ɓa coh ŋ oonaŋ Sawe, buuraŋ Sodom nammba woo Ibram ne : « Eɗ to ɓooɓi te fu ɓay raak-raaki. » ");
INSERT INTO sav_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ibram loffa ɗe ne : « Mi yii meeɓ yaah ŋ giñ Nikiɗi, Kooh yi ŋ ɗafka ɗafka, yi fer eel ci na kehƴi ne : ");
INSERT INTO sav_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","in hend na caas mbaa liiɓ ñafaɗ, ŋ heyɗi wa ɓaye ŋ ini fu raak, po fu minanɗi woo ne, e ñam tah Ibram raak. ");
INSERT INTO sav_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ŋ waaɗɗi ali in nga, nikɗi in ci ƴaaɓi raaw ñam ɗah, na ɓakiŋ langtoh ciŋ ngo, Aner na Eskol na Mamre, ɓi fu inah ne, ɓa raakiɗ waɗ nga. » ");
INSERT INTO sav_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ŋ finho coha na buur ca, in hayɗohha Ibram findi heeƴ. A Nikiɗi woyee na ɗe an : « Ka neƴƴoh ali in Ibram, laam e ñam na hee ɗa ɗipe, te aafiŋ ɗa hey yake lool. » ");
INSERT INTO sav_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ibram loffa ne : « An fu na hee so ye one Heɗ ɓoo Nikiɗi ? Te ŋ raakɗi kuɓu po Eliyeser yiŋ Damas yii, a yi laman raak-raak kiŋ ngo ! ");
INSERT INTO sav_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Fu onɗi so kuɓu po jaambri rimkoh ŋ kahan ndo a yi na hee so lame ! » ");
INSERT INTO sav_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nikiɗi loffa ɗe ne : « Muk, a yi lamohiŋ ɗa haa, waaye a kuɓki fu rimoot ŋ ñif miŋ ɗa, a yi na hee ɗa lame. » ");
INSERT INTO sav_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nikiɗi puliɗta ɗe ŋ hara, a woosa ɗe ne : « Taaknuka, fu kind hor ci ne fu miniɗa ɗah. Fu hotiɗ findi ca laayoh e ? Ɓi rimkohan nga ɗa hendan ɗaa. » ");
INSERT INTO sav_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibram kossa, weɗ tah Nikiɗi ammba ɗe ɓo' yurhiɗ. ");
INSERT INTO sav_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","A woyissa ɗe ne : « E ñam Nikiɗi yi pulɗoh ɗa Uur ŋ Babilon, ne ŋ on ɗa kur kii, fu raakoota. » ");
INSERT INTO sav_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A loffa ɗe ne : « Heɗ ɓoo Nikiɗi ŋ min inhoh na ne kur kii e ñam raakana ? » ");
INSERT INTO sav_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nikiɗi woosa ɗe ne : « Ɓayiɗ to inoh yu' na pe' yu' na mbaal naar, yaa nu nga ɗah raakaat kiis kaahay, na hoɗ na banuut ƴin. » ");
INSERT INTO sav_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibram ɓayya ɗoopaat ceem. A appa ca, yaa nu nga ɗah, a nguɗta ɗe ŋ leerni po tassa sel ca. A yurhiɗohha nguɗ nu nga ɗah na wa ɓaat nga. ");
INSERT INTO sav_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Suur ca yipkeeɗa ŋ fiɗaaf caŋ ca. Ibram aannja ca. ");
INSERT INTO sav_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wa noha na muye, Ibram pani'uusa, pani nooɗiɗ. Neƴƴoh miskiɗ huniɗ na ñuus tuɗ aassa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Weɗi Kooh woyoh ɗe ne : « Inhaa ne set ciŋ ɗa hey nike jaambur ŋ kur ka ɓa raakɗi, ɓa tumu ñaam nga, ɓa torhiɗu kiis teemet-nikiis (400). ");
INSERT INTO sav_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Waaye ŋ hey atte'e ɓi kur ka ɓa tumohu ñaam, po ɓa puloh nga na raak-raak laayiɗ. ");
INSERT INTO sav_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ŋ ini kaɗ nga ɗa nak, fu hey raake kipes hutiɗ, neɓiɗ, fu kuruk nga moɗoɗ, fu uumbu ŋ jam. ");
INSERT INTO sav_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E set ciŋ ɗa, ŋ finho kiis teemet-nikiis ceem (400), na hee dokkisse ŋ ndii ; laam aƴaarkiŋ Amoor ci uupɗi yaah ndoom. » ");
INSERT INTO sav_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Wa noha muy, wa ñuussa tuɗ, ɗekka po njahha ɗuukeeɗa hunnda na kocom kaɓiɗ, ca taammba ŋ harmban nguɗ caŋ sepet ca. ");
INSERT INTO sav_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mbaɗi, Nikiɗi ambtiɗohha na Ibram. A woosa ɗe ne : « Ɓooɓi pulohan nga ɗa, ɓeɗ maa hee eɗe kur kii ; ina nguɗoh ŋ kalaŋ Misra po ŋ Ewfaraat, kala yakka. ");
INSERT INTO sav_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Wa nikka kur kiŋ Ken ci na Kenis ci na Kadmon ci ");
INSERT INTO sav_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Hit ci na Peris ci na Refay ci ");
INSERT INTO sav_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Amoor ci na Kanaan ci na Girgaas ci na Yebuus ci. » ");
INSERT INTO sav_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraay yi ɓiti Ibram, a raakɗeeɗi ɗe kuɓu, waaye a raakeen ñaam teeku Haajara pulohee Misra. ");
INSERT INTO sav_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraay ɓooffa po a woosa Ibram ne : « Fu hotiɗ ne Nikiɗi hondohiɗ to raak kuɓu, huna na Haajara. Wa miniɗ nik a raak kuɓu, yi nikan yiŋ ngo. » Wa a woo Ibram ineem, a teyɗukka. ");
INSERT INTO sav_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saraay, ɓiti Ibram, ɓayya ñaamiŋ ɗe pulohee Misra, Haajara, eɗta ƴaar ce Ibram ɗe, a tummba ɗe ɓitiɓ. Weem, raak Ibram tumiɗ kiis ndaŋkiyaah ŋ Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Wa a hun na ɗe, a ammba rook. A inahha ne a ɓarang haa, a yappa ɓoyaŋ ɗe Saraay. ");
INSERT INTO sav_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","A yi Saraay a woosa Ibram ne : « In ci jen ya fu ɓek ca ; e ñam deg Haajara ŋ yaah ciŋ ɗa, waaye ina a amboh rook poyi, a kerhiɗisɗi so. Nikiɗi teeɓohaat yi nik ŋ keeh ŋ harmban mi na ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ibram loffa ɗe ne : « Haajara deey, a ris ñaamiŋ ɗa poyi, in na neɓ ɗa ɗah, fu miniɗ ɗe wa tum. » A camboh ɗe iifiɗ ɗaa, a tumeeɗa ɗe in miskiɗ po a saandohha. ");
INSERT INTO sav_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","A kaɗoh kaɗoh po a nikka ŋ sero laaha ŋ waas Suur, ŋ keheƴ hulang ; malaakaaniŋ Nikiɗi raakka ɗe nga, ");
INSERT INTO sav_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","a woosa ɗe ne : « Haajara, ñaamiŋ Saraay, fu kurkoh nde ? Fu na kaɗe nde ? » A loffa ɗe ne : « Mi na nupe ɓoyiŋ ngo Saraay. » ");
INSERT INTO sav_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaakaaniŋ Nikiɗi woosa ɗe ne : « Wiirka ŋ ɓoyiŋ ɗa, Saraay, fu ree ɗah, ruhsiɗa haf fu ŋ fikiice. » ");
INSERT INTO sav_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","A woyissa ɗe ne : « Ŋ hey tume ɓi rimkohan nga ɗa laay po ɓo' minuu ɓa kind. » ");
INSERT INTO sav_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A ɓaatiɗta ɗe nga ne : « Ɗiski fu nik ndii, fu ɓarang haa ; fu hey raake kuɓu ƴaar, teekaa ɗe Ismaayla (Kooh kerhiɗ) laam Nikiɗi kerhiɗ miskiɗiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kuɓkiŋ ɗa pesan na haf ce findi mbaam sif raakaaɗi heɗ, a heyɗi kerhiɗohe na ɓooɓa, ɓooɓa kerhiɗohanɗi na ɗe. A genan saɓsukohiɗ na ɓaah ciŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Haajara teekka Nikiɗi woyee na ɗe \"Ata-El-Roy\" (Kooh yi na hote), laam a woo ne : « Moo ŋ hotiɗ Yi na hotee so e ? » ");
INSERT INTO sav_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ineem tahha po laaheem teekuusa \"Lahay-Roy\" (Pesɗi na hotee so) ; wa ɗaa ŋ harmban Kades na Bered. ");
INSERT INTO sav_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ŋ finho ineem, Haajara raakka kuɓu, Ibram teekka ɗe Ismaayla. ");
INSERT INTO sav_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ibram raakeen kiis ndaŋkiyaah-yasna-kaahay na kiis yasna-yino (86), wa Haajara raakiɗ ɗe Ismaayla. ");
INSERT INTO sav_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wa Ibram raak kiis ndaŋkiyaah-yasna-nikiis na yasna-nikiis (99), wa raakka mbeh, Nikiɗi teeɓukka ɗe, a woosa ɗe ne : « E mi Koohi Min, pesa findi ŋ waaɗoh, fu nik yurhiɗ. ");
INSERT INTO sav_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ŋ hey ambtiɗohe na ɗa te ŋ hey ɗa tume ɓasil. » ");
INSERT INTO sav_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Wa a kerah woo keem, Ibram ƴekka po pukiŋ ɗe reesa kehƴi, Kooh taalndiɗta woyeeɗa na ɗe, ");
INSERT INTO sav_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","a woosa ɗe ne : « Ambtiɗohiŋ ngo na ɗa, wa na hee tufkohe an : Fu hey nike baabiŋ ɓi cuuɓi cuuɓ, ");
INSERT INTO sav_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","te fu teekissuuɗi Ibram (baab yakɗuuɗ) waaye Ibrahiima (baabiŋ ɓi laayiɗ), laam ŋ hey ɗa tume caaciŋ ɓi cuuɓ laayiɗ. ");
INSERT INTO sav_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ŋ hey ɗa tume ɓasil, ɓi cuuɓi cuuɓ hey pulohe nga ɗa, ɓi buur sah hey rimkohe nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ŋ hey ambtiɗohe na ɗa, fu na ɓi na hee rimkohe nga ɗa, gomal nu nik, wa hey nike po faw. Ŋ ineem ŋ hey nike Koohiŋ ɗa na ɓi na hee rimkohe nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te kur ki fu nikoh jaambur wii, wa nikka Kanaan, ŋ hey ɗa wa one jen, fu na ɓi na hee rimkohe nga ɗa, ɗu raakoota po faw ; te ñam na hee nike Koohiŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ŋ finho ineem, Kooh woyissa Ibrahiima ne : « E fu na hee taambkohe ɓakiŋ ɗa ŋ ambtiɗohiŋ ngo na ɗa, fu na ɓi na hee rimkohe nga ɗa, gomal nu nik. ");
INSERT INTO sav_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Taambkohohaat ambtiɗohiŋ ngo na ɗu, fu na ɓi na hee rimkohe nga ɗa, an : Ƴaar nu nik nga ɗu ɗah, joyiɗ nguɗuk, ");
INSERT INTO sav_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","nguɗkeem weɗi na hee teeɓohe ambtiɗohiŋ ngo na ɗu. ");
INSERT INTO sav_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Komaaki ƴaar nu raak neeh yasna-kaahay ɗah, a joyiɗ nguɗuk ; na, gomal nu a min ɓaahoh ɗah, yi rimohu ŋ kahan fu po yi romohu ŋ jaambra ɓaahɗi ŋ cuuɓiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ɓa jen ɓa joyiɗ nguɗuk, a nik ñaami rimkoh ŋ kahan fu mbaa yi fu rom na koporiŋ ɗa. Te nguɗki na hee nike ŋ faan ciŋ ɗu, weɗ ini na hee teeɓohe ambtiɗohiŋ ngo na ɗu po faw. ");
INSERT INTO sav_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ƴaar nu nguɗukɗi, te nik ne a sang sang ɗah, a hey pulɗasse ŋ cuuɓiŋ ɗe laam raakan ɗe nguɗiɗ ambtiɗohi ŋ tufkiɗ. » ");
INSERT INTO sav_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ŋ ineem Kooh woosa Ibrahiima ne : « Ŋ ini kaɗ ŋ ɓitiifu, a teekissuuɗi Saraay ; waaye tiikiŋ ɗe wa Saarata kotii. ");
INSERT INTO sav_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ŋ hey ɗe barke'ɗe, ŋ on ɗa kuɓu ƴaar na ɗe, ŋ hey ɗe barke'ɗe, po a nikan caaciŋ ɓi cuuɓi cuuɓ ; ɓi buur sah hey pulohe nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahiima ƴekissa po pukaŋ ɗe reesa kehƴi ; a ƴennda, a woosa ŋ ɗooƴ ce ne : « Moo ƴaar na kiis teemet (100) minisiɗ raak kuɓu e ? Te Saarata yii, na kiis ciŋ ɗe ndaŋkiyaah-yasna-nikiis (90) cii, hey raake kuɓu e ? » ");
INSERT INTO sav_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A woosa ne : « A' ! Te fu amb ŋ Ismaayla rek ! » ");
INSERT INTO sav_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kooh woosa ɗe ne : « Ŋ woo ne hee, Saarata hey raake kuɓu ƴaar yi fu na hee teeke Isaahha, ŋ hey ambtiɗohe na ɗe po faw, a yi na ɓi na hee rimkohe nga ɗe. ");
INSERT INTO sav_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ini kaɗ ŋ Ismaayla, ŋ kerhiɗ woo kiŋ ɗa, ŋ hey ɗe barke'ɗe, ŋ tum ɗe ɓasil, e kilifa ndaŋkiyaah na kanak (12) puloh nga ɗe te a fer cuuɓ angiɗ. ");
INSERT INTO sav_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Waaye ambtiɗohiŋ ngo na ɗa nak, ŋ hey wa tufkiɗe na Isaahha, kuɓki Saarata na hee raake maas. » ");
INSERT INTO sav_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wa Kooh ƴut woo na Ibrahiima, a faɗta ɗe ndaam, a cootta ŋ ɗafka. ");
INSERT INTO sav_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Weɗi Ibrahiima ɓayoh kuɓkiŋ ɗe Ismaayla na ƴaaɓa rimohu kahna na ɓa a romoot na koporaŋ ɗe, ƴaar ca nikee ŋ kahan ce jen, a nguɗta ɓa ŋ noha mbaɗi ; findi Kooh woyoh ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wa Ibrahiima na nguɗke raak ɗe raakiɗ kiis ndaŋkiyaah-yasna-nikiis na yasna-nikiis (99). ");
INSERT INTO sav_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kuɓkiŋ ɗe Ismaayla nameen raak kiis ndaŋkiyaah na kaahay (13) wa a na nguɗke. ");
INSERT INTO sav_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ŋ noha mbaɗi, Ibrahiima na kuɓkiŋ ɗe Ismaayla nguɗukka. ");
INSERT INTO sav_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ƴaar caŋ kahan ce jen nammba nguɗuk na ɗe mbaɗi, ɓa rimohu nga, na ɓa a rome. ");
INSERT INTO sav_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Wa nikee ŋ noh damiɗ, Nikiɗi teeɓukka Ibrahiima ŋ kidig ca yakak caŋ Mamre, raak ɗe ɓoofiɗ ŋ nguɓu ɗiipaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A jaɗtuk jaɗtuk, a hotta ɓo' kaahay ŋ fikiice, Ibrahiima kurukka ŋ ɗiska a ɓoofe, a arra kaɗ coha na ɓa. Wa a ree, a ƴekiɗta ɓa, ");
INSERT INTO sav_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","a woosa ne : « Kilifaani, kana so taamboh an, mi yii kiim ɗa wa, wela ŋ kahni, ");
INSERT INTO sav_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ɓa on ɗu masuɓ ɗu naawis kot ciŋ ɗu, ɗu iɗsiɗuk ŋ saangni, ");
INSERT INTO sav_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ŋ ɓayiɗ ɗu mbuuru ƴissuut ɗu ɓaatuk hatil, ɗu han coot ; taambiŋ ɗu ŋ ɓoyi joy ɗu taambkoh nikuu ɓarang ɓarang. » Ɓa woosa ɗe ne : « Ee, tuma findi fu woyoh. » ");
INSERT INTO sav_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrahiima nuppa, a aassa ŋ ɗooƴ ɗiipa, a woosa Saarata ne : « Ara ɓay andaar mun kaahay ŋ wi uup baah, fu siiɓa, fu haɓiɗ mbuuru. » ");
INSERT INTO sav_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ibrahiima nupissa ŋ gat ca, a ɓayya ɗoon faymiɗ, a eɗta ɗe ƴaar ŋ ñaam caŋ ɗe, a arra ɗe haɓiɗ. ");
INSERT INTO sav_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wa sepet ca non, Ibrahiima deƴiɗta ɓa ca na miis gundiɗ na miis kal ; ɓa ñameeɗa ŋ saangna, a tufukka ne a taambkoh ɓa. ");
INSERT INTO sav_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ɓa meekissa Ibrahiima ne : « A nde ɓitiifu Saarata ? » A woosa ɓa ne : « A yii ŋ ɗooƴ ɗiipi. » ");
INSERT INTO sav_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yino nga ɓa woosa ɗe ne : « Mi na woyee ɗu ini nik : Ŋ hey dokkisse ndii maas, ŋ raakan Saarata ɓitiifu raakiɗ kuɓu ƴaar. » Weem raak Saarata ŋ nguɓu ɗiipa, ŋ finho ɓoyi, a kerheeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Weem raak Ibrahiima yaɓko'iɗ te Saarata namiɗ ɓitif ŋ raak kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saarata ƴennda ŋ ɗooƴ ce, a woosa ne : « Moo mi yi ɓitfiɗii ŋ minisiɗ yeg neɓɗeem e ? Te ŋ hot heɗ tuuƴ co yaɓko'iɗ. » ");
INSERT INTO sav_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nikiɗi woosa Ibrahiima ne : « Wa ye tah Saarata ƴennda, an : “ Ŋ ɓitfi ŋ ɓitif wii, ŋ minisiɗ raak kuɓu e ? ” ");
INSERT INTO sav_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Andi raakiɗ ini wooñ Nikiɗi ? E mi woo ɗa wa, ŋ hey dokkisse ndii maas, ŋ raakan Saarata raakiɗ kuɓu ƴaar. » ");
INSERT INTO sav_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Wi Saarata kerah woo keem, a tiitta, a taasukka an : « Ŋ ƴenɗi. » Nikiɗi woosa ɗe ne : « Aha'kay ! Fu ƴeniɗ. » ");
INSERT INTO sav_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ŋ finho ineem, hanheeca kaahay ca kurukka ne ɓa coot. Ibrahiima ɓennda ɓa po ɓa hoteeɗa Sodom ŋ oona. ");
INSERT INTO sav_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nikiɗi woosa ŋ haf ce ne : « Andi ŋ hey ɗasɗohe Ibrahiima ini maa hee tume ? ");
INSERT INTO sav_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Laam, a hey fere cuuɓ angiɗ, raakiɗ hatil, te ŋ hey barke'ɗe cuuɓ ciŋ kehƴi jen, saguuce. ");
INSERT INTO sav_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","A yi ŋ kooɗ ne, a teeɓ kuɓuuciŋ ɗe na ɓi rimkohan nga ɗe, ɓa pesohee keeh na yurah, findi Nikiɗi waaɗoha ; ndaa, ŋ min ɗe haɓɗiɗ in ci ŋ gap ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nikiɗi woyissa ɗe ne : « In ca Sodom na Gomor na yambse, yakiɗ lool, bakaaɗ caŋ ɓa uupiɗ. ");
INSERT INTO sav_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ŋ hey ruhse po nga ŋ marak andi ɓaa tumohe findi ŋ kerhoh ; ŋ hey inhe, andi wa raakoh ɗaa, wala wa raakohɗi ɗaa. » ");
INSERT INTO sav_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ŋ ineem ƴaaɓa kanak ca yurhiɗta ɓak Sodom, waaye Ibrahiima tassa na Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibrahiima reɓpa, a tummba ne : « Heɗ ɓoo, hanaa fu heyɗi apndohe yurhiɗ na yurhaaɗi ? ");
INSERT INTO sav_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nik ne yurhiɗ ndaŋkiyaah-yatuus (50) raakiɗ ŋ kur ka ɗah, fu hey ɓa apndohe e ? Andi fu heyɗi ɗaase ɓi kur ka sagu ndaŋkiyaah-yatuus (50) ceem ? ");
INSERT INTO sav_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Fu tumohanɗi muk in mand ɗaa, fu apndohanɗi yurhiɗ na yurhaaɗi, tah po yurhiɗ kaan sagu yurhaaɗi e ? Fu yi atte'ohiŋ kehƴi jen, fu tumanɗi yurhiɗ e ? » ");
INSERT INTO sav_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nikiɗi loffa ɗe ne : « Ŋ raak yurhiɗ ndaŋkiyaah-yatuus (50) ŋ ɗooƴ Sodom ɗah, ɓa hey tahe po, ŋ ɗaas ɓi kur ka jen. » ");
INSERT INTO sav_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibrahiima woyissa ne : « Ɗaas so de' Heɗ ɓoo, mi yii kaañ po ŋ woyee na ɗa, te ŋ merhey dong ; ");
INSERT INTO sav_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","nik ne ndaŋkiyaah-yatuus (50) ɓi yurhiɗ ceem ɓa tasiɗ ɓo' yatuus ɗah, yatuus ceem hey tahe po fu ɗumb kur ka e ? » Nikiɗi loffa ne : « Ŋ raak ɓo' ndaŋkiyaah-nikiis na yatuus (45) yurhiɗ nga ɗah, ŋ heyɗi wa ɗumbe. » ");
INSERT INTO sav_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahiima woosa ne : « Moo ndaŋkiyaah-nikiis (40) raak nga ɗah ? » Nikiɗi loffa ne : « Ŋ tumanɗi ali in, sagu ndaŋkiyaah-nikiis (40) ceem. » ");
INSERT INTO sav_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibrahiima tummba ne : « Heɗ ɓoo kanaat ayruk de', ŋ woyis woyis, moo ndaŋkiyaah-kaahay (30) raak nga ɗah ? » Nikiɗi loffa ne : « Ŋ tumanɗi ali in, ne ŋ raak ndaŋkiyaah-kaahay (30) nga ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahiima woosa ne : « Po ŋ kaannja woo na Heɗ ɓoo ; moo ndaŋkiyaah-kanak (20) raak nga ɗah ? » Nikiɗi loffa ne : « Ŋ tumanɗi ali in, sagu ndaŋkiyaah-kanak (20) ceem. » ");
INSERT INTO sav_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibrahiima woosa ne : « Heɗ ɓoo kanaat ayruk de', ɗal wii ɗah, ŋ woyissanɗi ; moo ndaŋkiyaah raak nga ɗah ? » Nikiɗi teyya ne : « Ŋ tumanɗi ali in, ne ŋ raak ndaŋkiyaah nga ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Wa Nikiɗi ƴut woo na Ibrahiima, a cootta. Ibrahiima dokukka kahan ce. ");
INSERT INTO sav_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Waaye malaakaaca kanak ca kaɗee Sodom, ɓa ree nga na niina. Ɓa raak Loot ɓoofiɗ ŋ teembohaara, ŋ aasohaanaŋ miira wil kur ka. Wa a hot ɓa, a kaɗta coha na ɓa, a ƴekiɗta ɓa po pukiŋ ɗe reesa kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A woosa ɓa ne : « Kilifaaci, ne wa neɓ ɗu ɗah, welaat ŋ kahan ɓoyi joy ɗu taambkoh, ɗu naawis kot ciŋ ɗu, ɗu neeh po kim na ɓaaɓa ɗah, ɗu han taalndiɗ waasiŋ ɗu. » Ɓa loffa ɗe ne : « Tee fu faɗ ɓoo neeh ŋ hari rek. » ");
INSERT INTO sav_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Waaye Loot kiimmba ɓa po ɓa teyɗukka, ɓa wella kahan ce, a nakohiɗta ɓa haɓɗiɗu kañam neɓiɗ na mbuuru, ɓa ñammba. ");
INSERT INTO sav_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ɓa raawɗi faanuk ndoom, ɓi kur ka, ƴaar caŋ Sodom, ŋ ƴina po yakka, ali ɓo' tasɗi, ɓa willa kahna, ");
INSERT INTO sav_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ɓa ɓeeɗukka Loot, ɓa woosa ɗe ne : « Ɓa nde ƴaaɓi hay kahan fu na niini, pulɗaat ɓa ndii, ɓoo faanuk ɓa. » ");
INSERT INTO sav_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loot pulla nga ɓa ŋ nguɓu kahna, a rannga buntaana, ");
INSERT INTO sav_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","a woosa ɓa ne : « Ƴaaɓiŋ ngo, ŋ kiim ɗu wa kiim, kanaat tum ini moɗaaɗiineem waay ! ");
INSERT INTO sav_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Sikɗukaat, ŋ raakiɗ kuɓu kanak cafƴiɗ, ɓi inahɗi ƴaar, ɗu waaɗ ɗah, ŋ puliɗ ɓa ndii ŋ hari, ɗu haɓiɗ ɓa ini neɓ ɗu, waaye ƴaaɓi kanak cii, kanaat ɓa reɓ, laam, ɓa hanheeciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ɓa woosa ne : « Kurka ndii waay. » Ɓa ɓaatta nga ne : « Ƴaari nikohaah nikohaah ndii dong, a waaɗ ɓoo teeɓ waas ; ɓoo hey ɗa tume ini uup moɗaaɗi wiŋ ɓa. » Weɗ ɓa yeñoh Loot yeñ miskiɗ ne ɓa yahroh buntaana, ");
INSERT INTO sav_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","waaye ƴaaɓa hanheeca eɗndukka Loot na yaah, ɓa ɓekka ɗe ŋ ɗooƴ kahna, ɓa ranngaa, ");
INSERT INTO sav_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ɓa mbiraañiɗta has caŋ ƴaaɓa nikee ŋ nguɓu kahna, ŋ ya uup ƴissuut po ŋ ya uup yak, ne ɓa hotissuu buntaana. ");
INSERT INTO sav_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wa ineem coot, hanheeca kanak ca woosa Loot ne : « Andi fu raakiɗ ɓaah ndii findi payum, kuɓu ƴaar mbaa ɓitiɓ ? Pulɗa ɓaah ciŋ ɗa ndii jen, ");
INSERT INTO sav_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","laam, ɓoo hey ɗumbe kur kii. Nikiɗi yegiɗ moɗaaɗiici na woyse nga te ca uupootiɗ ; a yi woos ɓoo ne ɓoo ɗumba. » ");
INSERT INTO sav_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ineem tahha Loot pul, a woosa fiir ca hee toke kuɓuucaŋ ɗe ɓitiɓ ca ne : « Araat ɗu pul ŋ kur kii laam, Nikiɗi na hee wa ɗumbe. » Waaye ɓa liiɓpa ne a na apsukee ɓa. ");
INSERT INTO sav_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wa wiisaaɗiina ree, malaakaaca tufukka Loot an : « Ara coot na ɓitiifu na kuɓuuciŋ ɗa ɓitiɓ ci kanak ci, fu kaanuu ŋ naamooni na hee ŋ kur kii sagu aƴaarkiŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loot nikka nga, a yiihsiɗkeeɗa, hanheeca kanak ca ammba ɗe na ɓitiice na kuɓuucaŋ ɗe kanak ca ŋ yaah, ɓa puliɗta ɓa po ɓa ussa kur ka sagu miski a miskee Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Wa ɓa puliɗ ɓa ŋ bilaf fa, yinoora woosa Loot ne : « Saandoha, ka heeluk, ka tufuk ŋ hatandii, kaɗa ŋ tangooceen, fu min muc. » ");
INSERT INTO sav_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loot woosa ɗe ne : « Bara ! Heɗ ɓoo, ");
INSERT INTO sav_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","fu keeñkohiɗ to, fu tumɗiɗ to in yakak po ŋ muciɗ, waaye, ŋ nar kaɗ po tangooceen ɗah, naamooni hey yo rahse, ŋ kaan. ");
INSERT INTO sav_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Fu hotiɗ kur keen e ? Wa reɓiɗ po ŋ joyiɗ min ree nga. On ndo ŋ saandoh nga, ne ŋ min muc, laam wa kur ƴissuut. » ");
INSERT INTO sav_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaakaani woosa ɗe ne : « Ee, po woti ŋ ris ɗa tufkoh ; kaɗa, ŋ heyɗi ɗumbe kur ki fu na wee weem, ");
INSERT INTO sav_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","waaye artuka fu kaɗ laam, feeh fu reeɗi ɗah, ŋ minɗi tum ali in. » Ineem tahha po kur kaam teekuusa Sowar (in ƴissuut). ");
INSERT INTO sav_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Wa Loot ree Sowar, tel noha puliɗ. ");
INSERT INTO sav_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Weɗi Nikiɗi toɓoh yongkaah na suufar ŋ ɗafuk Sodom na Gomor. ");
INSERT INTO sav_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A ɗummba kur ceem jen na ɓooɓa genee nga ca, na oona jen na kidig ca nikee nga. ");
INSERT INTO sav_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ɓiti Loot heelkeeɗa, a ɓoƴsuusa ɗus meɗa. ");
INSERT INTO sav_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wa Ibrahiima kuruk na ɓaaɓa teel, a kaɗta ŋ ɗiska a saɓsukohee na Nikiɗi ; ");
INSERT INTO sav_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","a marakka ŋ ɓak Sodom na Gomor na ina wil ooneem jen, a hotta ɗuuku haa ɗuuku koraaɓ puloheeɗa ŋ kehƴa rapeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Wa Kooh na ɗumbe Sodom a ɗaakkoheen Ibrahiima nof po tahha a muciɗta Loot ŋ naamoona a sooƴɗoh kur ca Loot genohe. ");
INSERT INTO sav_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Wa ineem coot, Loot kaañisɗi nik ŋ Sowar, a toorukka ŋ tangooca, a yi na kuɓuucaŋ ɗe ɓitiɓ ca kanak ca, ɓa gennda ŋ hur atoh. ");
INSERT INTO sav_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wa raakka mbeh, yi nikee saawa woosa taambɗoh ce ne : « Ɗiski wa nik ndii baabiŋ ɓoo a yi yaɓko'eeɗa, te ƴaar raakɗi ndii, ɓi fu inah ne ɓa miniɗ ɓoo tok findi wa na tumohse. ");
INSERT INTO sav_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mbaa haya ɓoo aniɗ baabiŋ ɓoo biiñ, ɓoo hun na ɗe, ɓoo min ɗe raakiɗ ɓi pulohan nga ɗe po tiikiŋ ɗe ƴimuu. » ");
INSERT INTO sav_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ŋ weka mbaɗi ɓa aniɗta baab ɓa biiñ, saawa aassa faanukka na ɗe, te Loot yegɗi faankaŋ yeem na kurkaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wa Kooh wiis saawa woosa taambɗoh ce ne : « Niinma, ŋ huniɗ na baab, mbaa ɗah, ɓoo anɗissaat ɗe biiñ woti, fu nam kaɗ fu faanuk na ɗe, ɓoo min ɗe raakiɗ ɓi pulohan nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ɓa anɗissa baabiŋ ɓa biiñ ŋ wekaam, taambɗoha nammba kaɗ faanukka na ɗe ; Loot namɗi yeg faankaŋ yeem na kurkaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kuɓuucaŋ Loot tumoh na baab ɓa ɗaa, ɓa taambohha nga, ɓa ammba rook. ");
INSERT INTO sav_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Wa saawa raak kuɓu, a nikka ƴaar, a teekka ɗe Mowab (puloh ŋ baab), a yi caaciŋ Mowab ci woti-woti. ");
INSERT INTO sav_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Taambɗoha nammba raak kuɓu ƴaar, a teekka ɗe Ben-Ammi (kuɓkiŋ ɓaah ho), a yi caaciŋ Amon ci woti-woti. ");
INSERT INTO sav_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ŋ jamanoonaam, Ibrahiima pulohha ndeem, a kaɗta Negef, a yippa ŋ harmban Kades na Suur, a kurkissa nga, a kaɗta Gerar. ");
INSERT INTO sav_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ŋ nikohaahaŋ ɗe ŋ Gerar, Ibrahiima woyeen ne, a yi na ɓitiice Saarata, ɓa taambɗoh taambɗoh. Abimelek, buuraŋ kur ka, woossa ɓooɓaŋ ɗe ne ɓa ɓayiɗ ɗe Saarata ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ŋ wek, Kooh teeɓukka Abimelek ŋ heeƴ, a woosa ɗe ne : « Fu mand na kaaniɗ, laam ɓitɓi fu ɓay, a ɓitiɓ jaambur. » ");
INSERT INTO sav_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Raak Abimelek raawɗi hun na Saarata, a woosa Kooh ne : « Heɗ ɓoo, hanaa fu heyɗi ɗumbe ɓooɓiŋ kur kii ŋ ini ɓa inahɗi ? ");
INSERT INTO sav_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Laam Ibrahiima a yi woyee so ne ɓa taambɗoh taambɗoh, te yi ɓitɓi nameen ndo woo ne ɓa taambɗoh. Wi ŋ haɓɗee ineem, ŋ tuma na liiɓohaaɗ moɗiɗ na yaah hooliɗ. » ");
INSERT INTO sav_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kooh woyissa ɗe ŋ ɗooƴ heeƴi ne : « Ee, mi sah, ŋ inhiɗ ne ini fu tum fu tiiɗaa, weɗ tah ŋ hondohha ɗa tooñ njo, ŋ faɗɗi ɗa ne fu hun na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ŋ ɗiski wa nik ndii wika ƴaari ɓitiice, laam a woosuuɗ, te a hey ɗa kiimɗe, fu muc ŋ kakaan kii ; fu tumɗaa ɗah, inha ne fu hey kaane, fu na ɓooɓiŋ ɗa jen. » ");
INSERT INTO sav_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wa Abimelek kuruk na ɓaaɓa teel, a ɓeeɗukka dag caŋ ɗe jen, a naandsukka ɓa ini raak, ɓa neƴƴohha lool. ");
INSERT INTO sav_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","A ɓeeɗukka Ibrahiima, a meekissa ɗe ne : « Fu haɓiɗ ɓoo ye wii ? Ŋ tum ɗa ye po wa tahha ɗa ɓek ɓoo bakaaɗi yakkii, mi na ɓooɓiŋ ngo ? Fu tumiɗ ini ɓo' joyɗi tum. » ");
INSERT INTO sav_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","A ɓaatta nga ne : « Mi yii meekis ɗa, wa ye ɓek ɗa ŋ inii ? » ");
INSERT INTO sav_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahiima woosa ɗe ne : « Ŋ liiɓee rek ne, ɓooɓiŋ kur kii ɓa nupɗi Kooh delem ne ɓa hey yo ape sagu ɓitiiso. ");
INSERT INTO sav_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Te wa nam nik keeh ne a taambɗoh ho, laam, e ɓoo ɓaah baab waaye ɓoo ɓaahɗi yaay, ŋ tokka ɗe, a nikka ɓitiiso. ");
INSERT INTO sav_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ina Kooh pulɗoh ho ŋ kahan baab ɓoo po wi, ŋ wileeɗa, ŋ woyee Saarata ne : “ Fu waaɗta so amboh ɗah, ɗisik nu ɓoo min kaɗ ɗah, fu na woye ne ɓoo taambɗoh taambɗoh. ” » ");
INSERT INTO sav_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Wa ɓa ƴut ŋ woo caŋ ɓa, Abimelek ɓayya ɓi pe', mbaal na ɓi inoh na ñaam, ƴaar na ɓitiɓ, a eɗta Ibrahiima, a nammba ɗe wik ɓitiice Saarata. ");
INSERT INTO sav_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A woosa ɗe ne : « Kur kiŋ ngo weɗɗi, gena ŋ ɗiski neɓ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A woosa Saarata ne : « Fu hot nga, mi yii eɗ taambɗoh fu ƴel haalis junni, wa hey teeɓohe ŋ fiki gentoh ciŋ ɗa ne, fu hooliɗ ŋ inii ; ɓooɓi jen inah ne, fu tumɗi in moɗaaɗi. » ");
INSERT INTO sav_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Wa Abimelek wik ɗe Saarata, Ibrahiima kiimmba Kooh, Kooh ngisohiɗta Abimelek na ɓitiice na ñaam ca ɓitiɓ ca po ɓa minissa raak kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Weem raak Nikiɗi rangeen fikiicaŋ ɓitiɓ caŋ kahan Abimelek jen po ɓa minisseeɗi raak kuɓu, sagu Saarata ɓiti Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Saarata, a yi genoh na Ibrahiima po, Nikiɗi ambohha ɗe findi a woyohee wa. A tumiɗta ɗe ina a gapee ɗe. ");
INSERT INTO sav_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saarata ammba rook, a raakiɗta Ibrahiima kuɓu ƴaar, ngaŋ kiyaɓkookaŋ ɗe, findi Kooh gapohee wa, wa nohaŋ wa ree. ");
INSERT INTO sav_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahiima teekka kuɓka Saarata raakee na ɗe, Isaahha. ");
INSERT INTO sav_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","A nguɗta ɗe ŋ neeha yasna-kaahayɗoh, findi Kooh woyohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahiima raakeen kiis teemet (100) wa Isaahha raaku. ");
INSERT INTO sav_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saarata woosa ne : « Kooh soosɗiɗ keeñiŋ ngo po ŋ miniɗ ƴen, te ɓo' nu kerah raakuukiŋ Isaahha yii ɗah, a hey yo ƴenohe. » ");
INSERT INTO sav_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Saarata degga nga ne : « Eey ɓo' woyeen Ibrahiima ne noh hey haye, Saarata ɓapɗe ɓi kuɓu ɗah ! Waaye deey ŋ raakɗiɗ ɗe kuɓu ƴaar ngaŋ kiyaɓkookiŋ ɗe wii. » ");
INSERT INTO sav_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Wa Isaahha yak po Saarata ombɗeeɗa ɗe, Ibrahiima ɓeeɗkohha ceeke yakak. ");
INSERT INTO sav_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saarata hotta Ismaayla ƴeneeɗa, a yi kuɓki Ibrahiima raakee na Haajara yi puloh Misra ; ");
INSERT INTO sav_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","wa tahha po a woosa Ibrahiima ne : « Aaña ñaami na kuɓkiŋ ɗe laam, kuɓkiŋ ñaamii joyɗi lam na kuɓkiŋ ngo, Isaahha. » ");
INSERT INTO sav_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Woo keem ngaŋ Ismaayla misikka Ibrahiima lool laam, a namee nik kuɓuuce. ");
INSERT INTO sav_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Waaye Kooh woosa ɗe ne : « Ineem kanaat ɗa misik sagu kuɓkii na ñaamiŋ ɗa, tuma ini Saarata woo ɗa laam, fu raakohan ɓi rimkohan nga ɗa ŋ Isaahha ; ");
INSERT INTO sav_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","hondohɗi kuɓkiŋ ñaamiŋ ɗa, ŋ hey name fer cuuɓ angiɗ nga ɗe, laam, a nam puloh nga ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ŋ Kooh-wiisiina, na ɓaaɓa teel, Ibrahiima ɓayya mbuuru na mbohos und tumiɗ masuɓ, a eɗta Haajara ca, a likiɗta ɗe ca ŋ yuug, a nammba ɗe eɗ kuɓkiŋ ɗe. Ƴutta, a puliɗta ɗe. Yeem kaɗeeɗa po a reesa bilaf faŋ Beerseba, a muuƴca. ");
INSERT INTO sav_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wa masmaŋ mbohosa reeh, Haajara faɗta kuɓka ŋ tas kidig ƴin, ");
INSERT INTO sav_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","a tiinnda ini ree saangal teemet (100), a ɓooffa, a woosa ŋ haf ce ne : « Ŋ minɗi marak muk, ŋ kakaan kiŋ kuɓkiŋ ngo. » A cangtiɗukka a fuɗeeɗa ŋ ɗafka. ");
INSERT INTO sav_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Waaye Kooh kerhiɗ hoosooraŋ kuɓka. Ŋ ɗafuk eel ci malaakaaniŋ Kooh ɓeeɗukka Haajara, a woosa ɗe ne : « Haajara, wa ye na ɗa ? Kana neƴƴoh ali in laam Kooh kerhiɗ kuɓki ŋ ɗiski a nik ndeem. ");
INSERT INTO sav_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kurka fu meeɓ ɗe, ambaa ɗe yaah kanak laam, ŋ hey fere cuuɓ angiɗ nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kooh teeɓpa Haajara woong, a soɗta mbohosa nga, a aniɗta kuɓka. ");
INSERT INTO sav_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Kooh taambkoheeɗa komaaknda, a yakeeɗa ŋ bilaf faŋ Paran, a nikka weesoh ɓis. Yaay ɓa waakiɗta ɗe ɓitiɓ ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ŋ jamanoonaam, Abimelek hunnda na Pikol, ƴaara adgohee hiñohoh caŋ ɗe, a raakka Ibrahiima, a woosa ɗe ne : « Ŋ inhiɗ ne Kooh huniɗ na ɗa ŋ in nu fu haɓiɗ ɗah. ");
INSERT INTO sav_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ŋ ɗiski wa nik ndii, giña ŋ Kooh ne fu heyɗi so njuye, mi na kuɓuuciŋ ngo po ŋ set ciŋ ngo na haye ; ne findi ŋ moɗɗohee na ɗa, fu moɗɗohan na so ɗaa na ɓooɓiŋ kur ki fu parɗoh wii. » ");
INSERT INTO sav_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahiima woosa ne : « Ŋ giñiɗa. » ");
INSERT INTO sav_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","A nammba woo na Abimelek ŋ ini kaɗ ŋ naaca ƴaaɓaŋ Abimelek naafee nga ɗe. ");
INSERT INTO sav_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek loffa ɗe ne : « Ŋ inahɗi ɓoyi tum ineem te fu woyeeɗi so wa, ŋ hana kerah woti. » ");
INSERT INTO sav_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ibrahiima ɓayya ɓi pe', mbaal na inoh, a eɗta Abimelek ca ; ŋ ineem, ɓa kanak, ɓa tufkiɗta ambtiɗohaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Wa ɓa tufkiɗa, Ibrahiima ɓakiɗta mbaal yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek meekissa ɗe ne : « Moo mbaal ci yasna-kanak ci fu ɓakiɗ nak ? » ");
INSERT INTO sav_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A loffa ɗe ne : « Teya mbaal ci yasna-kanak cii ŋ tiikiŋ ngo, weɗ teeɓoh ne, e mi ac naacii. » ");
INSERT INTO sav_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Weɗi tah ɗiska teekuusa Beerseba (naaciŋ giñi), laam, ɓa kanak jen ɓa giñoh ndaam. ");
INSERT INTO sav_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ɓa tufkiɗoh ambtiɗohaŋ ɓa ɗaa ŋ Beerseba. Ƴutta, Abimelek hunnda na Pikol, ƴaara adgohee hiñohoh caŋ ɗe, ɓa guridda ŋ kur kaŋ Filistiica. ");
INSERT INTO sav_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahiima jimmba tas kaɗeeɗ ŋ Beerseba, a ñaamukka Nikiɗi, Koohi moos nik te a yi nikan po faw. ");
INSERT INTO sav_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibrahiima gennda in maañiɗ ŋ kur kaŋ Filistiica. ");
INSERT INTO sav_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Wa in ceem coot, wa raakka mbeh, Kooh markiskeeɗa Ibrahiima, a woosa ɗe ne : « Ibrahiima ! » Yeem loffa ɗe ne : « Ee, mi yii kerah ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kooh taalndiɗta ne : « Ɓaya kuɓkiŋ ɗa yinoori Isaahha, yi fu waaɗ ŋ keeñiŋ ɗa, fu kaɗ ŋ tangoora maa hee ɗa teeɓe ŋ kur kaŋ Moriya, fu seeƴkoh ɗe ŋ ndaam, a nik hoomɗaah wuu so. » ");
INSERT INTO sav_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibrahiima kurukka na ɓaaɓa teel, a ɓessa sokoñ seeƴkoha, a siffa mbaamaŋ ɗe, a hunnda na ñaam kanak ŋ ñaam caŋ ɗe, na kuɓkiŋ ɗe Isaahha ; ɓa kaɗeeɗa ɗiska Kooh woyee ɗe. ");
INSERT INTO sav_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ŋ neeha kaahayɗoh, Ibrahiima ƴokka ɗiska Kooh woyee ɗe in usiɗ. ");
INSERT INTO sav_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A woosa ñaam caŋ ɗe ne : « Tasaat ndii na mbaami, mi na njaanji, ɓoo kaɗ ñaamka Kooh ndeen, ɓoo hay. » ");
INSERT INTO sav_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahiima ɓayya sokoñ ca seeƴkohaaca, a raannda Isaahha ca, a ɓayootta yongkaaha na japla. Ɓa hunnda kanak, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ɓa kaɗoh kaɗoh po, Isaahha woosa baabiŋ ɗe ne : « Baab ! » A tahassa ɗe ne : « Ee, mi yii kerah ɗa. » Kuɓka meekissa ɗe ne : « Sokoñ ci ceɗi cii, yongkaahi weɗi wii, moo a nde mbaali joy seeƴkohu ? » ");
INSERT INTO sav_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahiima loffa ɗe ne : « E Kooh ŋ haf ce na hee eɗohe mbaali joy seeƴkohu. » Ɓa taalndiɗta kanak, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wa ɓa ree ɗiska Kooh woyee ɗe, Ibrahiima haɓiɗta seeƴkoha, a degga sokoñ ca nga, a tokka kuɓkiŋ ɗe Isaahha, a degga ɗe ŋ sokoñ ca. ");
INSERT INTO sav_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ibrahiima meeɓpa japla ne a hoos kuɓkiŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","waaye malaakaaniŋ Nikiɗi ɓeeɗukka ɗe ŋ eel ci, a woosa ɗe ne : « Ibrahiima ! Ibrahiima ! » A tahassa ɗe ne : « Ee, mi yii kerah ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaakaani woosa ɗe ne : « Kana reɓ kuɓki, kanaa ɗe tum in. Ŋ inhiɗ kotii ne, fu nupiɗ Kooh laam, fu sangiɗɗi so kuɓkiŋ ɗa yinoori. » ");
INSERT INTO sav_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahiima jaɗtukka, a hotta mbaal naar na wiic ca longiɗ ŋ kidig ƴin ; a ɓayya ɗe, a hoomiɗta ɗe ŋ ɗiska Isaahha joyee seeƴkohu. ");
INSERT INTO sav_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahiima teekka ɗiska \"Nikiɗi eɗohiɗ ini etohu.\" Weɗi tah waam po woti ɓa na woye ne : « Ŋ tangooraŋ Nikiɗi, a hey eɗohe ini etohu. » ");
INSERT INTO sav_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ŋ eel ci, malaakaaniŋ Nikiɗi ɓeeɗkissa Ibrahiima, ");
INSERT INTO sav_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","a woosa ɗe ini Nikiɗi woo wii : « Ŋ giñiɗ nga so mi yii ne, ŋ tumi fu tum ineem, fu sangiɗɗi so kuɓkiŋ ɗa yinoori, ");
INSERT INTO sav_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ŋ hey ɗa barke'ɗe baahiɗ, ŋ on ɗa ɓi rimkohan nga ɗa laay po ɓa hend na hor ciŋ eel ci, po ɓo' minuu ɓa kind findi merhey miŋ yaah-cookmi. Te ɓeɗ na hee mine ɓi sang ɓa jen ; ");
INSERT INTO sav_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","cuuɓ ciŋ kehƴi jen hey raake barke sagu ɓi na hee rimkohe nga ɗa, laam fu kerhiɗiɗ to. » ");
INSERT INTO sav_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ibrahiima dokukka ŋ ɗiska a faɗe ñaam caŋ ɗe, ɓa hunnda jen ɓa haadeeɗa Beerseba laam, a risee gen nga. ");
INSERT INTO sav_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","E Ibrahiima nikoh ŋ Beerseba po, a woyuusa an : « Nahor taambɗoh fu namiɗ raak ɓi kuɓu ƴaar na ɓitiice Milka. » ");
INSERT INTO sav_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ɓa saawkoh Uus, Bus taammba nga, Kemuwel yi baab ɓi Aram, ");
INSERT INTO sav_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haaso, Pildas, Yidlaf na Betuwel. ");
INSERT INTO sav_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel a yi rim Rebeka ; ɓii ɓeɗ kuɓu ƴaar ci yasna-kaahay ci Milka raak na Nahor, taambɗoh Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor nameen raak kilook ŋ ñaam caŋ ɗe na woyse Rewuma, a raakka na ɗe Tebaa, Gaham, Tahas na Ma'akaa. ");
INSERT INTO sav_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saarata pesiɗ kiis teemet na kiis ndaŋkiyaah-kanak na yasna-kanak (127) a hannda kuruk nga. ");
INSERT INTO sav_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","A kaanoh ŋ Kiriyat-Arba, weɗ Hebron, ŋ kur kaŋ Kanaan. Ibrahiima miskiɗukka kakaan kaŋ Saarata ; a fuɗta ɗe lool. ");
INSERT INTO sav_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ƴutta, Ibrahiima faɗta fiɗaafa ŋ ɗiska wa nik, a kaɗta hotoha na cuuɓaŋ Hit ca. ");
INSERT INTO sav_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Wa Ibrahiima ree, a woosa ɓa ne : « Ŋ jaambur nga ɗu, ŋ nikohaah nikohaah ŋ ndii, mi yii kiim ɗu ne ɗu on ndo ŋ waak ruy-ruyi mi na hee uumbohe fiɗaafiŋ ɓitiiso. » ");
INSERT INTO sav_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hit ca loffa Ibrahiima ne : ");
INSERT INTO sav_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","« Sikɗuka ini ɓoo na wee ɗa ; Kooh tumiɗ ɗa kilifa yakak ŋ ɗooƴ ɓoo, kon mbaa ɗah, kooɗa wi neɓ ɗa ŋ ruy-ruy ciŋ ɓoo, fu uumb ɓitiifu nga ; nama inah ne ali ɓo' heyɗi ɗa sangohe ɗiski fu joy uumb ɓitiifu. » ");
INSERT INTO sav_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Wa Ibrahiima kerah woo keem, a kurukka, a hiirra ŋ fiki Hit ca genee ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ƴutta, a hannda ɓa woo ne : « Nik ne ɗu teyɗukiɗ ne ŋ uumb ɓitiiso ndii ɗah, kiimaat Efron, kuɓkiŋ Sohar, ");
INSERT INTO sav_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","a faɗiɗ to huraŋ atoh faŋ ɗe nik ŋ Makpela, weɗaa ŋ sereendaŋ yohon ce ; kiimaat ɗe a toon ndo wa ŋ candoomiŋ wa po wa nik ruy-ruyi ŋ raakoot ŋ fikiiɗu. » ");
INSERT INTO sav_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wa Ibrahiima na wee, raak Efron ɓoofiɗ ŋ harmban ɓaah caŋ ɗe Hit ca. Ŋ fiki Hit ca cohee ŋ ɗiska jen, ŋ aasohaanaŋ kur ka, Efron loffa Ibrahiima ŋ ɗafka ne : ");
INSERT INTO sav_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","« On ndo ŋ woo ɗa kilifaani, ɓaya ɓay yohna na huraŋ atoh fa ; ŋ fiki ɓooɓiŋ ngo, ŋ on ɗa wa, fu tuma ruy-ruyiŋ ɓitiifu. » ");
INSERT INTO sav_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ŋ woo keem, Ibrahiima hiirissa ŋ fiki ɓooɓaŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ƴutta, a woosa Efron ŋ ɗafka ne : « Ɓoo kanaata nookoh, faɗa ŋ eɗ ɗa candoomiŋ yohni ; teya haalsi po ŋ min uumb ɓitiiso. » ");
INSERT INTO sav_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","« Kilifaani, yohni na care ƴel haalis teemet-nikiis (400), ineem ye ŋ harmban mi na ɗa ? Kon fu miniɗ uumb ɓitiifu nga. » ");
INSERT INTO sav_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahiima kerahha woo ka, a eɗohha candooma Efron woo ŋ fiki Hit ca, wa nikka ƴel teemet-nikiis (400) ŋ haalis, ɓeesuuɗ ŋ findi toonoh caam meeɗ tumoh. ");
INSERT INTO sav_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ibrahiima raakoh yohon Efron ɗaa, wa nikee ŋ Makpela, ŋ pulohaaɗ-nohaŋ Mamre. Yohna, po ɗiska wa top, na kidig ca nikee ŋ ɗooƴa na huraŋ atoh fa ; ");
INSERT INTO sav_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ca nikka raakuuɗaŋ Ibrahiima ŋ fiki Hit ca cohee ŋ aasohaanaŋ kur ka jen. ");
INSERT INTO sav_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Wa a puloh nga, Ibrahiima ɓekka fiɗaafaŋ ɓitiice Saarata ŋ ɗooƴ huraŋ atoh fa nik ŋ yohna ŋ Makpela ŋ pulohaaɗ-nohaŋ Mamre, weɗ Hebron, ŋ kur kaŋ Kanaan, wa nikka ruy-ruyaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hit ca teyɗukka ne, e Ibrahiima raak huraŋ atoh fa na yohna ; tahha po a tummba ɗiska ruy-ruy caŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahiima yaɓko'een lool, te Nikiɗi barke'ɗeen ɗe ŋ in nu nik ɗah. ");
INSERT INTO sav_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wa raakka mbeh, Ibrahiima woosa ñaama yakka ŋ ñaam caŋ ɗe, ya meeɗ taambkoh raak-raakaŋ ɗe jen ne : « Ooɓa yaahiŋ ɗa ŋ rambiŋ ngo, ");
INSERT INTO sav_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","fu giñiɗ to ŋ Nikiɗi, Kooh yi Heɗ ɗafki na kehƴi, ne fu heyɗi waakɗe kuɓkiŋ ngo ɓitiɓ ŋ cafaƴ ciŋ Kanaan, kur ki ŋ genoh wii, ");
INSERT INTO sav_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","waaye fu na hee kaɗe po ŋ kur ɓoo, ŋ ɓooɓaŋ ngo, fu waakiɗ kuɓkiŋ ngo Isaahha ɓitiɓ nga. » ");
INSERT INTO sav_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ñaama loffa ɗe ne : « Wa miniɗ nik ne ɓitɓeem teyɗukanɗi hay na so ŋ kur kii, andi maa hee hey ɓayndohe kuɓkiŋ ɗa po ŋ kur ka fu puloh ? » ");
INSERT INTO sav_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahiima woosa ɗe ne : « Muk, kana moos ɓay kuɓkiŋ ngo ŋ ndaam. ");
INSERT INTO sav_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Laam Nikiɗi, Kooh yiŋ ɗafki, yi pulɗoh ho kahan baab na kur ɓoo, woyiɗ na so, a giñiɗta so ne a hey one ɓi rimkohan nga so kur kii jen ; a yi na hee woose malaakaaniŋ ɗe, yeem yooɓɗiɗ ɗa waasiŋ ɗa po, fu ɓayohiɗ kuɓkiŋ ngo ɓitiɓ ŋ ndaam. ");
INSERT INTO sav_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nik ne ɓitɓeem teyɗukanɗi hay na ɗa ɗah, giñi fu na hee giñe wii, wa hey ɗa ruhse, waaye findi wa min mand ɗah, kana ɓay kuɓkiŋ ngo ndaam. » ");
INSERT INTO sav_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ñaama ooɓpa yaahaŋ ɗe ŋ rambaŋ Ibrahiima kilifaanaŋ ɗe, a giñiɗta ɗe ineem. ");
INSERT INTO sav_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Wa a ƴut, ñaama ɓayya ngeelemb ndaŋkiyaah ŋ caŋ kilifaanaŋ ɗe na ina uup baah ŋ raak-raakaŋ kilifaanaŋ ɗe, a yurahha kur ka Nahor genohe, ŋ ɓak Mesopotami. ");
INSERT INTO sav_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","A na huntoh caŋ ɗe, ɓa kaɗoh kaɗoh po ɓa reesa ŋ woong ne fu aasee ŋ kur ka ɗah, a ƴekiɗta ngeelemb ca ; wa nikee ŋ noh niiniɗ, wahtuuni ɓitiɓ ca na pulohe ne ɓa kaɗ neya. ");
INSERT INTO sav_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A woosa ne : « Mi yii kiim ɗa Nikiɗi, Koohiŋ kilifaaniŋ ngo Ibrahiima, teyɗukiɗ to waasiŋ ngo wii, fu baahoha kilifaaniŋ ngo Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ñam yii tufukka ŋ woongiŋ masmi, te cafaƴ ciŋ kur ki hey haye neye. ");
INSERT INTO sav_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ŋ waaɗ ne cafƴi mi na hee kiime masuɓ, a naar meemeeniŋ ɗe a on ndo ŋ an, a nam woo ne, a hey yo anɗiɗe ngeelemb ci ; yeem a yi nikaat yi fu ambiɗ ñaamiŋ ɗa Isaahha. Ineem hey yo inhiɗe ne fu teeɓohiɗ baah kiŋ ɗa ŋ kilifaaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","A reehiɗɗi kiim ndoom, cafaƴ pulla na meeme ŋ yuugaŋ ɗe ; a nikka Rebeka, kuɓu Betuwel ; Betuwel yi baab ɓi kuɓki, a Milka yaayiŋ ɗe, Nahor yi taambɗoh Ibrahiima, nikka baabiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A nikee komaaki cafaƴ moɗiɗ, inhaaɗi ƴaar. A aassa ŋ woonga, a neyya meemeena po a pulla. ");
INSERT INTO sav_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Weɗ ñaamaŋ Ibrahiima aroh kaɗ coha na ɗe, a woosa ɗe ne : « Kaambsuka, fu on ndo ŋ an ƴissuut ne wa neɓ ɗa ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebeka loffa ɗe ne : « Ee, ana kilifaani. » A arra kaambsuk, a naariɗta ɗe meemeena, a aneeɗa. ");
INSERT INTO sav_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Wa Rebeka ƴut, a woosa ɗe ne : « Faɗa ŋ nam aniɗ ngeelemb ci po ca hiƴ. » ");
INSERT INTO sav_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A artukka, a yiiffa ina tasee ŋ hongla na anɗohse ; a dokkissa ŋ woonga. A yi neyoh neyoh po a aniɗta ngeelemb ca jen. ");
INSERT INTO sav_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ƴaara ɗekka teɗ, markeeɗa ɗe ne a inah, andi Nikiɗi teyɗukɗiɗ ɗe waasiŋ ɗe wala. ");
INSERT INTO sav_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Wa a aniɗ ngeelemb ca po a ƴutta, ƴaara ɓayya tokkaah ŋ kiñin tiɓuuɗ na garam yasna-yino ngaŋ urus, na kiñi kanak urus ɓekaah ŋ yaah, waa nu nga ɗah, tiɓohu ini uup garam teemet (100). ");
INSERT INTO sav_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A meekissa ɗe ne : « Woo so, fu kuɓu ɓa ? Ɓoo raakiɗ ɗiski ɓoo min neeh ngaŋ kahan baab ɗu e ? » ");
INSERT INTO sav_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka loffa ɗe ne : « Ŋ kuɓu Betuwel, ŋ setiŋ Milka na Nahor. ");
INSERT INTO sav_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ee, kahan baab ɓoo raakiɗ mbaang ne ngeelemb ci raak ɗiski ca na hee neehe na ñamaah laayiɗ, te wa raakiɗ ɗiski ɗu joy min neeh. » ");
INSERT INTO sav_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ƴaara ƴekka po pukaŋ ɗe reesa kehƴi ne a ñaamuk Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A woosa ne : « Corka Nikiɗi, Koohiŋ kilifaaniŋ ngo Ibrahiima ; fu teeɓohiɗ baah kiŋ ɗa nga ɗe te fu moosɗi ɗe faɗoh ! Ini kaɗ nga so, fu yurhiɗiɗ to po ŋ ɓaah ciŋ kilifaaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Wa kuɓka cafƴa puloh ndaam, a arra kaɗ, a naandsukka ɓi kahan yaay ɓa ina raak jen. ");
INSERT INTO sav_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka raakeen taambɗoh ƴaar na woyse Laban, Laban kaɗta raaka ƴaara ŋ sero woonga. ");
INSERT INTO sav_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Weem, raak ɗe hoteen tokkaahaŋ kiñin ka na kiñiica taambɗoh ce ɓekɗasse, a nameen kerah wi Rebeka na naandsuke ina ƴaara woyee na ɗe. A raakka ƴaara na ngeelemb caŋ ɗe ŋ sero woonga. ");
INSERT INTO sav_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","A woosa ɗe ne : « Fu yi Nikiɗi barke'iɗ, fu ɓoof ye ŋ bilaf fii ? Haya ɓoo kaɗ kahna, ŋ haɓɗiɗiɗ ɗu daloha na ɗiski ngeelemb ci nikan. » ");
INSERT INTO sav_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Wa ƴaara ree kahna, ɓa nihissa unung caŋ ngeelemb ca, ca ɓekuusa ŋ ɗisik baahiɗ, ca onuusa mbaang na ñamaah. Ƴaara na ɓa hunee na ɗe, onuusa masuɓ, ɓa naawissa kot. ");
INSERT INTO sav_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ɓa nammba deƴƴu kañam, waaye, ƴaara woosa ne : « Bala ŋ ñaman ɗah, ŋ woo kot ci ŋ tiind. » Laban woosa ɗe ne : « Ee, woya. » ");
INSERT INTO sav_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","A woosa ne : « Mi deey, ŋ ñaamiŋ Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nikiɗi barke'ɗiɗ kilifaaniŋ ngo lool, a tumiɗ ɗe ɓo' raakiɗ. A oniɗ ɗe ɓi pe', mbaal, na inoh, urus na haalis na ɓi ñaam ƴaar na ɓitiɓ na ngeelemb na mbaam. ");
INSERT INTO sav_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ɓitiice Saarata, a kaɗeen po a ɓitiffa, a hannda raak na ɗe kuɓu. Kuɓkeem, a yi Ibrahiima kilifaaniŋ ngo eɗ raak-raak kiŋ ɗe jen. ");
INSERT INTO sav_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kilifaaniŋ ngo giñɗukohha so ne : “ Fu heyɗi waakɗe kuɓkiŋ ngo ƴaari ɓitiɓ ŋ cafaƴ ciŋ Kanaan, kur ki ŋ genoh wii ; ");
INSERT INTO sav_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","waaye, fu na hee kaɗe po ŋ ɓooɓaŋ ngo ŋ kahan baab, fu ɓayiɗ ɗe ɓitiɓ nga. ” ");
INSERT INTO sav_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ŋ woosa kilifaaniŋ ngo ne : “ Nik ne ɓitɓeem teyɗukanɗi hay na so ɗah ? ” ");
INSERT INTO sav_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A loffa so ne : “ Nikiɗi, yi ŋ moos taamboh ŋ ini a waaɗ, hey woose malaakaaniŋ ɗe, a yooɓɗiɗ ɗa waasiŋ ɗa. Fu hey ɓayɗe kuɓkiŋ ngo ɓitiɓ ŋ cuuɓiŋ ngo, ŋ kahan baab ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ali ɓa teyɗukɗi, giñi fu na hee giñe, wa hey ɗa ruhse nik ne fu kaɗiɗ po ŋ ndaam ɗah. ” ");
INSERT INTO sav_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Woti, wi ŋ hay po ŋ reesa ŋ woongi, ŋ kiimmba an : “ Nikiɗi, Koohiŋ kilifaaniŋ ngo Ibrahiima, nik ne fu hey yooɓɗe waasiŋ ngo ɗah, ");
INSERT INTO sav_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ñam yii ŋ sero woongi. Ŋ waaɗ ne cafƴi na hee neye, ŋ kiim ɗe masuɓ ƴissuut ŋ meemeeniŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","a on ndo ŋ an, a nam woo ne, a hey yo anɗiɗe ngeelemb ci ; yeem a yi nikaat yi fu ambiɗ kuɓkiŋ kilifaaniŋ ngo. ” ");
INSERT INTO sav_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ŋ ƴutɗi woo ŋ haf fo ndoom, Rebeka pulla na meemeeni ŋ yuugiŋ ɗe. A ruhussa ŋ woongi, a neyya masuɓ. Ŋ woosa ɗe ne : “ On ndo ŋ an. ” ");
INSERT INTO sav_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A arra kaambsuk, a naariɗta so meemeeni. A woosa so ne : “ Ana, fu ƴut ɗah, ŋ aniɗ ngeelemb ci. ” Ŋ annda, a aniɗta ngeelemb ci. ");
INSERT INTO sav_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Weɗ ŋ meeksoh ɗe ne : “ Fu kuɓu ɓa ? ” A woosa so ne : “ Ŋ kuɓu Betuwel, yiŋ Milka na Nahor. ” Ŋ ɓekiɗta ɗe tokkaahi ŋ kiñin kiŋ ɗe na kiñiici ŋ yaah ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ƴutta, ŋ ƴekka ŋ kehƴi ne ŋ ñaamuk Nikiɗi Koohiŋ kilifaaniŋ ngo Ibrahiima, a yi amboh ho po ŋ miniɗ ɓayiɗ kuɓkiŋ ɗe Isaahha ɓitiɓ, setiŋ taambɗoh ce Nahor. ");
INSERT INTO sav_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mbaa ɗiski wa nik ndii, e ɗu na hee so woye andi ɗu ris amb kilifaaniŋ ngo ne ɗu teeɓoh baah kiŋ ɗu nga ɗe ; wa nikɗi ɗah, ŋ inah findi ŋ tuman. » ");
INSERT INTO sav_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban na Betuwel loffa ɗe ne : « Inii deey, wa puloh ŋ Nikiɗi ; ɓoo raakɗi woyaah nga. ");
INSERT INTO sav_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka a yeem ŋ fikiifu, ɓayaa ɗe, a nik ɓiti kuɓkiŋ kilifaaniŋ ɗa findi Nikiɗi waaɗoh. » ");
INSERT INTO sav_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Wa ñaamiŋ Ibrahiima kerah woo ceem, a ƴekiɗta Nikiɗi po pukiŋ ɗe reesa kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ƴutta, a puliɗta ɓi in tiɓuuɗ ŋ haalis na urus, na ɓi ndima, a eɗta Rebeka. A nammba ɓay alal keeh-keeh, a onnda yaaya na Laban, taambɗoh kuɓka cafƴa. ");
INSERT INTO sav_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ɓa hannda ñam kotii, ɓa annda, a yi na huntoh caŋ ɗe ; ɓa neehha nga po na ɓaaɓa. Wa ɓa kuruk, ñaamaŋ Ibrahiima woosa ne : « Onaat to ŋ haad ŋ kilifaaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Taambɗoh Rebeka na yaayiŋ ɗe woosa ɗe ne : « Ona ɓoo, kuɓki cafƴi nik na ɓoo ƴissuut, ini ree neeh ndaŋkiyaah dong ; ƴut ɗah, fu kaɗ na ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A loffa ɓa ne : « Kanaat to ɗaak, laam Nikiɗi yooɓɗiɗiɗ to waasiŋ ngo po ƴutiɗ ; onaat to ŋ gurid ŋ kilifaaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ɓa woosa ɗe ne : « Po woti. Mbaa ɗah, ɓoo ɓeeɗkaat cafƴi a woo ini a liiɓ nga. » ");
INSERT INTO sav_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ɓa ɓeeɗukka Rebeka, ɓa meekissa ɗe ne : « Andi fu waaɗiɗ kaɗ na ƴaarii woti ? » A woosa ɓa ne : « Ee. » ");
INSERT INTO sav_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ɓa ambsohha ɗe na ɓoya meeɗ ɗe ɓapiɗ na ñaamaŋ Ibrahiima na ɓa hunee na ɗe, ɓa askohha na ɓa. ");
INSERT INTO sav_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ɓa kiimiɗta ɗe an : « Kooh barke'ɗaat ɗa, gooyiŋ ɓoo, a tum ɗa ɓasil, te ɓi rimkohan nga ɗa degaat ɓi sang ɓa yaah. » ");
INSERT INTO sav_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka hunnda na ñaam caŋ ɗe ɓitiɓ ca, ɓa rappa ngeelemb ca, ɓa kaɗeeɗa na ñaamaŋ Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Waam, raak Isaahha pulohiɗ Lahay-Roy, a gennda Negef. ");
INSERT INTO sav_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wa raakka niin, a tiindsukeeɗa ŋ nduuf-nduufa ; a jaɗtuk jaɗtuk, a ƴokka ɓi ngeelemb hayeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ŋ ɗafuk ngeelmba a rape, Rebeka nammba hot Isaahha, a ruhussa. ");
INSERT INTO sav_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A meekissa ñaama ne : « Moo, ƴaara na hee cohe na ɓoo ŋ nduuf-nduufa yen, e ɓa ? » Ñaama woosa ɗe ne : « A kilifaaniŋ ngo. » Rebeka muurukka. ");
INSERT INTO sav_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Wa ɓa coh, ñaama naandsukka Isaahha findi wa kaɗoh jen. ");
INSERT INTO sav_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaahha ɓayya Rebeka ɓitiɓ, a waaɗta ɗe lool. A ɓekka ɗe ŋ ɗiipaŋ yaay ɓa, Saarata. Ineem weɗ giifiɗ Isaahha ŋ kakaan kaŋ yaay ɓa. ");
INSERT INTO sav_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahiima nameen tok ɓitiɓ wiiriis teeku Ketura. ");
INSERT INTO sav_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","A raakeen na ɗe kuɓu ƴaar yasna-yino : Simraan na Yoksan, Medaan, Majaan, Yisbak na Suwa. ");
INSERT INTO sav_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan, a yi baab ɓi Sabaa na Deedaan ; Deedaan nikka caaciŋ Asuur ci na Letuus ci na Lewuum ci. ");
INSERT INTO sav_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Majaan, a yi baabiŋ Eefa na Eefer, Hanook, Abida na Elda'ah. Ɓii jen ɓa kuɓuuciŋ Ketura na set ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahiima eɗeen Isaahha raak-raak kaŋ ɗe ne a lama. ");
INSERT INTO sav_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ŋ ini kaɗ ŋ kuɓuucaŋ ɓitiɓ caŋ ɗe ɓinooɓa, a nameen ɓa on ŋ raak-raaka wa a na pese, a cootiɗta ɓa ŋ kur, ŋ ɓak pulohaaɗ-noh po, ɓa ussa Isaahha, kuɓkiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahiima pesiɗ kiis teemet na ndaŋkiyaah-yasna-kanak na kiis yatuus (175) nde a kurukka nga. ");
INSERT INTO sav_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","A kaan ŋ kiyaɓko neɓiɗ, ŋ finho kipes hutiɗ, a haadda Jaanim. ");
INSERT INTO sav_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kuɓuuciŋ ɗe Isaahha na Ismaayla uummba ɗe ŋ huraŋ atoh fa nik Makpela, wa ŋ fiki Mamre ŋ yohon Efron, kuɓkaŋ Sohar, ya ɓaahe ŋ Hit ca. ");
INSERT INTO sav_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yohneem weɗ Ibrahiima romee ŋ Hit ca. A yi na ɓitiice Saarata, ɓa uumbu nga. ");
INSERT INTO sav_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ŋ finho kakaan kaŋ Ibrahiima, Kooh barke'iɗta Isaahha. A yi Isaahha, a genee ŋ sero laaha teeku Lahay-Roy. ");
INSERT INTO sav_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Inii weɗ naandsuku ŋ Ismaayla na ɓi rimkoh nga ɗe, kuɓki Ibrahiima raakee na Haajara, yi pulohee Misra, ñaamaŋ Saarata. ");
INSERT INTO sav_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Tiik ciŋ ɓa ceɗi cii : Nebayot a yi saawi, taammba nga Kedaar, taambissa nga Aadabel, na Mipsam, ");
INSERT INTO sav_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Maasa, ");
INSERT INTO sav_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Teema, Yeetur, Nafis po gannga ŋ Keedama. ");
INSERT INTO sav_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ɓii ɓeɗ kuɓuuciŋ Ismaayla ƴaar ci, tiik ciŋ ɓa ceɗi ceem. Ɓa nikka kilifa ndaŋkiyaah na kanak (12) ɓi fu inah ne kur ca na ndut ca ɓa adgohee teeksee nga ɓa. ");
INSERT INTO sav_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaayla pesiɗ kiis teemet na ndaŋkiyaah-kaahay na kiis yasna-kanak (137), a kurukka nga, a haadda Jaanim. ");
INSERT INTO sav_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ɓi rimkoh nga ɗe genee ŋ harmban Hawiilaa na Suur, ŋ pulohaaɗ-nohaŋ Misra, ŋ waas Assuur. Ɓa genoh ɗaa, saɓsukohiɗ na ɓaah caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Inii weɗ naandsuku ŋ Isaahha na kahan ce ; Isaahha nikee kuɓu Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Wa a raak kiis ndaŋkiyaah-nikiis (40), a ɓayya Rebeka ɓitiɓ, taambɗoh Laban. Rebeka namee nik kuɓu Betuwel ; ɓeɗ ɓeem, ɓa ɓaahee ŋ cuuɓaŋ Aram ca, ɓa genee Paddan-Aram. ");
INSERT INTO sav_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Waaye Rebeka mineeɗi raak kuɓu, a ineem tah po, Isaahha kiimmba Nikiɗi ŋ ini kaɗ ŋ ɓitiice, Nikiɗi teyɗukiɗta ɗe ; Rebeka ammba rook. ");
INSERT INTO sav_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Wa a amb rook, kuɓu kanak hiñoheeɗa ŋ ɗooƴ rookiŋ ɗe, a woosa ne : « Wa ye tah wa kaɗohha an nga so ? » A kaɗta meeksa Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nikiɗi woosa ɗe ne : « Ca cuuɓ kanak nik ŋ rookiŋ ɗa, cuuɓ kanak ɗalohiɗ hey rimkohe nga ɗa ; winoori hey uupɗe wi tas hatil, te yi ƴini hey yilfe yi yakki. » ");
INSERT INTO sav_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wa noha a joyee ɓasloh ree, laam-laam raakɗi nga, ɓa nikangannga siis. ");
INSERT INTO sav_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ya ɗeɓ raaku nikka ruumind coy, a riiffa na find haa a ɓeku kulɓa, ɓa teekka ɗe Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ya taamb nga, raaku na yaahiŋ ɗe ambiɗ ŋ patangiŋ kotiŋ Esaaw, ɓa teekka ɗe Yaŋhooɓa. Wa komaakceem na raakse, wa tel Isaahha raakiɗ kiis ndaŋkiyaah-yasna-yino (60). ");
INSERT INTO sav_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wa komaakca yak, Esaaw nikka kaalsukoh keeh-keeh, a uupee waaɗ nik ŋ bilaf fa. Yaŋhooɓa nak, a nikee ɓo' yeeɓkiɗ, a nikangee ŋ ɗiip ca. ");
INSERT INTO sav_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ŋ ineem Isaahha uupee waaɗ Esaaw laam a waaɗeen sepet kaalsukuuɗ lool, waaye Rebeka uupee waaɗ Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wa raakka mbeh, Yaŋhooɓa tikeeɗa suppa, wa hennda Esaaw pulohha kaala yaaɓiɗ. ");
INSERT INTO sav_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A woosa Yaŋhooɓa ne : « Faɗ to ŋ on suppaani ruumndii, laam ŋ minisɗi in. » Ineem weɗ tah a tapuusa tiikiŋ Edom (ruumind). ");
INSERT INTO sav_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaŋhooɓa loffa ɗe ne : « Mbaa ɗah, toon ndo waɗiŋ ɗa paaɗ, wiŋ saawi fu nikoh. » ");
INSERT INTO sav_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaaw woosa ne : « Mi yi aɗuk po ŋ minisɗi, waɗ saaw raakiɗ to winde etoh ? » ");
INSERT INTO sav_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaŋhooɓa loffa ɗe ne : « Giñiɗ to ineem paaɗ. » Weɗ Esaaw giñohha, a toonnda ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaŋhooɓa eɗta ɗe mbuuru na suppa iraak, a ñammba, a annda po ƴutta, a cootta waas ce. Esaaw sagankohoh waɗiŋ saawiŋ ɗe ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Wa raakka jamano, aɗ raakka ŋ kur ka, aɗ ɗalohiɗ na wa raakee ŋ jamanoonaŋ Ibrahiima ; tahha po Isaahha kaɗta Gerar ɗiskaŋ Abimelek buuraŋ Filistiica. ");
INSERT INTO sav_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ŋ ndaam, Nikiɗi teeɓukka ɗe, woosa ɗe ne : « Kana kaɗ Misra waaye tasa ŋ kur ka maa hee ɗa teeɓe. ");
INSERT INTO sav_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nikohaaha nga, ŋ hey ɗa ambohe, ŋ barke'iɗ ɗa, laam maa hee ɗa eɗe keheƴ cii jen, fu na ɓi na hee rimkohe nga ɗa ; ŋ hey tume ini ŋ gapee baab ɗu Ibrahiima te ŋ ginnjaa. ");
INSERT INTO sav_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ŋ hey ɓaate ɓi rimkohan nga ɗa po ɓa hend na hor ci laay te ŋ hey ɓa eɗe keheƴ cii jen. Cuuɓ ciŋ kehƴi jen hey raake barke sagu ɓi na hee rimkohe nga ɗa, ");
INSERT INTO sav_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","laam Ibrahiima kerhiɗeen ndo, a teyɗukeen in ci ŋ nakohe te a taambɗeen waasiŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Weɗ tah Isaahha tassa ŋ Gerar. ");
INSERT INTO sav_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","A nikee ŋ ndaam po ɓooɓaŋ kur ka meekissa ɗe ŋ ini kaɗ ŋ ɓitiice. A loffa ɓa ne a taambɗoh ce laam a neƴƴoheen woo ne a ɓitiice, bala ɓa apan ɗe sagu moɗa Rebeka moɗe. ");
INSERT INTO sav_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Wa ɓa nik nga po wa maannja, wa raakka mbeh, Abimelek buuraŋ Filistiica nikka ŋ palaŋteeraŋ ɗe, a hotta Isaahha hoñeeɗa ɓitiice Rebeka. ");
INSERT INTO sav_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","A nakohha ɗe ɓeeɗkiɗu, a woosa ɗe ne : « Kon ɓoyii, a ɓitiifu ! Fu min woyoh na ne a taambɗoh fu ? » Isaahha loffa ɗe ne : « Ŋ woyiɗa laam ŋ sangee ne ŋ apu saguuce. » ");
INSERT INTO sav_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek woyissa ɗe ne : « Fu inhiɗ ini fu haɓiɗ ɓoo e ? Ƴaar ŋ ɓooɓiŋ ngo mineen ɗe ɓitiɓkoh ; mbaa ɗah, fu heen ɓoo ɓeke tooñ. » ");
INSERT INTO sav_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelek nakohha ɓooɓaŋ ɗe jen woyu ne : « Ɓo' nu reɓ ƴaarii mbaa ɓitiice ɗah, a hey apse. » ");
INSERT INTO sav_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ŋ kiis ka, Isaahha sokka ŋ kur ka, a raakka ini ree waas teemet ŋ ina a soke, laam Nikiɗi barke'ɗeen ɗe. ");
INSERT INTO sav_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A uupeeɗa nga raak, a raakka po a nikka heɗ alal, ");
INSERT INTO sav_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","a raakeen ɓi pe', mbaal na inoh na ñaam laayiɗ po Filistiica siiseeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Siisa Filistiica siisee ɗe tahha po ɓa uummba naac ca ñaam caŋ baab ɓa Ibrahiima acee jen, ŋ jamanoonaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek woosa ɗe ne : « Pula kur ki, fu kaɗ, laam fu uupɗiɗ ɓoo hatil. » ");
INSERT INTO sav_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Weɗ Isaahha kurkoh ndaam, a kaɗta yipa ŋ oonaŋ Gerar, a nikka nga. ");
INSERT INTO sav_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A uumbissa naac ca baab ɓa acee wa a na pese, te Filistiica uummba ca wa a kuruk nga. Isaahha teekissa ca ŋ tiik ca baab ɓa ferɗee ca. ");
INSERT INTO sav_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wa raakka mbeh, ñaam caŋ ɗe aceeɗa naac ŋ oona po ɓa pulla ŋ cul masuɓ. ");
INSERT INTO sav_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Waaye niiɗoh caŋ Gerar nookoheeɗa na ɓaŋ Isaahha an : « Masmii, a ɓoo raaka. » Isaahha teekka naacaam Esek (ñaɗoh) laam ɓa waakee ɗe ñaɗoh. ");
INSERT INTO sav_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ñaam caŋ ɗe acissa naac, lahtoh raakissa nga, a teekkaa Sitna (lahtoh). ");
INSERT INTO sav_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaahha pulohha ndaam, ñaam caŋ ɗe acissa naac, ali woo raakɗi nga, a teekkaa Rehobot (ɗisik angiɗ), laam a woo ne : « Nikiɗi oniɗ ɓoo po, ɓoo raakiɗ ɗisik angiɗ, ɓoo hey mine raak in ŋ kur kii. » ");
INSERT INTO sav_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Wa a puloh ndeem, Isaahha kaɗta Beerseba. ");
INSERT INTO sav_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ŋ weka mbaɗi, Nikiɗi teeɓukka ɗe, a woosa ɗe ne : « E mi Koohiŋ baab ɗu Ibrahiima, ka neƴƴoh ali in laam mi yii na ɗa ; ŋ hey ɗa barke'ɗe, ŋ ɓaat ɓi rimkohan nga ɗa sagu ñaamiŋ ngo Ibrahiima. » ");
INSERT INTO sav_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaahha haɓiɗta seeƴkoha ndaam, a ɓeeɗkohha Kooh ŋ tiikiŋ Nikiɗi. A yippa ɗiipaŋ ɗe ndaam, ñaam caŋ ɗe acissa naac ŋ ɗiska. ");
INSERT INTO sav_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Isaahha, a yi nikoh ŋ Beerseba po, Abimelek pulohha Gerar, a hunnda na Ahusat nawleece, na Pikol, ƴaara adgohee hiñohoh caŋ ɗe, ɓa hayya ɗe raake. ");
INSERT INTO sav_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaahha meekissa ɓa ne : « Wa ye tah po ɗu hayya ndii, te sang ngo weɗ tahee ɗu puliɗta so kur ɗu ? » ");
INSERT INTO sav_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ɓa loffa ɗe ne : « Ɓoo hotiɗ hooliɗ ne Nikiɗi huniɗ na ɗa, weɗ tah ɓoo woosa ne ɓoo joyiɗ kerhiɗoh te ɓoo tufkiɗ ambtiɗoh, wa giñu ŋ harmban ɓoo na ɗa. ");
INSERT INTO sav_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Giña ne fu heyɗi ɓoo tume in moɗaaɗi laam ɓoo torhiɗɗi ɗa, ɓoo tumɗangee ɗa in baahiɗ, ɓoo faɗ ɗa faɗ, fu cootta moɗoɗ. Ŋ ɗiski wa nik ndii, Nikiɗi oniɗ ɗa barke. » ");
INSERT INTO sav_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaahha haɓɗiɗta ɓa kañam baahiɗ ɓa ñammba, ɓa annda. ");
INSERT INTO sav_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wa Kooh wiis, ɓa kurukka na ɓaaɓa teel, ɓa ginnja ŋ harmban ɓa, Isaahha askohha na ɓa, ƴutta ɓa cootta moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mbaɗi, ñaam caŋ Isaahha hayya nga ɗe, ɓa woosa ɗe ne, naaca ɓa acee nguliɗ. ");
INSERT INTO sav_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaahha teekka naacaam Siba (giñ). Weɗ tah po woti kur ka teeku Beerseba (naaciŋ giñi). ");
INSERT INTO sav_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Wa Esaaw raak kiis ndaŋkiyaah-nikiis (40), a ɓayya ɓitiɓ kanak ŋ cuuɓaŋ Hit ca, Yehudit, kuɓu Be'eri, na Baasmat, kuɓu Eloon. ");
INSERT INTO sav_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ɓitiɓ caam mirndohha nik aay-keeñ ŋ Isaahha na Rebeka. ");
INSERT INTO sav_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Wa Isaahha yaɓko, has caŋ ɗe neɓisɗi, kaɗta po a minisɗi sah hot, wa raakka mbeh a ɓeeɗukka saawaŋ ɗe an : « Esaaw ! » Yeem loffa ɗe ne : « Ee ñam yii ! » ");
INSERT INTO sav_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaahha woosa ɗe ne : « Fu hot nga, ɗiski wa nik ndii ŋ mand na kurkiɗ nga. ");
INSERT INTO sav_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mbaa ɗah, ɓaya halliiniŋ ɗa na ɓis ciŋ ɗa fu kaɗ kaalsuka, fu kom mbo, ");
INSERT INTO sav_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","fu tikiɗ to tik neɓiɗ findi ŋ waaɗoha, ŋ ñam, ŋ eɗ ɗa barkeeni ndo ŋ kaanan ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Wa Isaahha woyee na Esaaw, Rebeka kerhee nga. Esaaw ɓayya halliina na ɓis caŋ ɗe, a cootta kaala. ");
INSERT INTO sav_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Weɗ Rebeka ɓeeɗkoh Yaŋhooɓa a woosa ɗe ne : « Ŋ kerhiɗ baab ɗu woyeeɗa taambɗoh fu Esaaw ne, ");
INSERT INTO sav_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","a kaalsukɗaat ɗe, a tikiɗ ɗe tik neɓiɗ, a ñam, a eɗ ɗe barkeeni ŋ fiki Nikiɗi ndo a kaanan ɗah. ");
INSERT INTO sav_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Sikɗuk ko, te fu tum ini maa hee ɗa woye. ");
INSERT INTO sav_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kaɗa gat ca fu kom mbo koteng kanak baahiɗ nga, ŋ tikiɗ baab ɗu tik neɓiɗ findi a waaɗoha ; ");
INSERT INTO sav_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","fu eɗ ɗe a ñam, a eɗ ɗa barkeeni ndo a kurkan nga ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaŋhooɓa loffa yaay ɓa Rebeka ne : « Moo, Esaaw paariɗ te ŋ paarɗi ; ");
INSERT INTO sav_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","baab ɓoo laal lo ŋ yaah ɗah, a hey inhe ne maa ñaañohee ɗe, te ŋ kooɗohan alku nga waaye barke haa. » ");
INSERT INTO sav_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yaay ɓa woosa ɗe ne : « Alkeem hay ɗah, wa ambaat to, tuma ɗaa rek, kom mbo in ci ŋ woo ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yaŋhooɓa kaɗta ɓaya koteng ca, a eɗta yaay ɓa ca, yeem tikka ca findi baab ɓa waaɗoh. ");
INSERT INTO sav_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ƴutta, Rebeka ɓayya kulɓaacaŋ saawaŋ ɗe Esaaw, ca uupee moɗ, raak ca na ɗe ŋ kahna, a ɓekiɗta Yaŋhooɓa ca. ");
INSERT INTO sav_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A ɓayya ŋ und caŋ koteng ca a muurra yaah ciŋ Yaŋhooɓa na ɓaki raakeeɗi find ŋ mbooh kiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ƴutta a eɗta ɗe mbuuru na kañam ka a tike. ");
INSERT INTO sav_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Wa Yaŋhooɓa ɓay kañam ka, a kaɗta ŋ baab ɓa a woosa ɗe ne : « Baab ! » Isaahha loffa ne : « Ee, ñam yii. A fu ɓa ? » ");
INSERT INTO sav_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaŋhooɓa woosa ne : « Ñam Esaaw saawiŋ ɗa, ŋ haɓɗiɗ ini fu nakee so, ɓoofa fu ñam, ƴut ɗah, fu eɗ to barkeeni. » ");
INSERT INTO sav_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaahha woosa ɗe ne : « Moo fu tumoh na po fu arra malu ? » Yaŋhooɓa loffa ɗe ne : « E Koohiŋ ɗa Nikiɗi, tum po ŋ arra malu. » ");
INSERT INTO sav_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaahha woosa ɗe ne : « Reɓa ndii ŋ saaɓiɗ ɗa, ŋ marak andi a fu Esaaw. » ");
INSERT INTO sav_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaŋhooɓa reɓpa, baab ɓa saaɓiɗta ɗe a woosa ne : « Hoosoori, a wiŋ Yaŋhooɓa waaye yaah ci, e ciŋ Esaaw. » ");
INSERT INTO sav_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A inhiseeɗi Yaŋhooɓa laam, yaah ciŋ ɗe muurkeen na find findi ciŋ Esaaw. Tahha po a eɗta ɗe barkeeni. ");
INSERT INTO sav_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Waaye ndo a eɗan ɗe wa ɗah, a meekissa ɗe an : « Wa hooliɗ ne a fu Esaaw e ? » Yaŋhooɓa loffa ɗe : « Ee, a ñam. » ");
INSERT INTO sav_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaahha woosa ɗe ne : « Deƴiɗ to ŋ ñam po ŋ min ɗa eɗ barkeeni. » Yaŋhooɓa deƴiɗta ɗe, a ñammba ; a nammba ɗe eɗ biiñ, a annda. ");
INSERT INTO sav_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ƴutta, Isaahha woosa ɗe ne : « Haya fu morgiɗuk ko. » ");
INSERT INTO sav_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaŋhooɓa reɓpa, a morgiɗukka ɗe. Wa Isaahha amb hetaŋ kulɓaaca, a eɗohha ɗe barkeeni an : « Aah ! Hetiŋ kuɓkiŋ ngo mand na wiŋ bilaf fi Nikiɗi barke'iɗ. ");
INSERT INTO sav_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kooh ruhsiɗaat maar ŋ yohon ciŋ ɗa, te a baahiɗ merhey miŋ ca, fu laayiɗ pees na biiñ. ");
INSERT INTO sav_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ɓi cuuɓ ñaamkaat ɗa, ɓi heet ƴekɗaat ɗa, fu adgoh ɓaah ciŋ ɗa, kuɓuuciŋ yaay ɗu ƴekiɗ ɗa, ɓo' nu waaɗiɗ ɗa moɗaaɗi ɗah, a alku'aat, ɓo' nu waaɗiɗ ɗa moɗiɗ ɗah, a raakaat barke. » ");
INSERT INTO sav_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Wa a ƴut eɗ Yaŋhooɓa barkeeni, yeem cootee coot rek, Esaaw pulohha kaala. ");
INSERT INTO sav_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A nammba tik tik neɓiɗ, a kommbaa baabiŋ ɗe. Wa a ree a woosa ɗe ne : « Baab, ɓoofa fu ñam, fu eɗ to barkeeni. » ");
INSERT INTO sav_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaahha meekissa ɗe ne : « A fu ɓa ? » A loffa ne : « Ñam Esaaw, saawiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaahha feyuusa po a saakɗoheeɗa ; a woosa ne : « Moo, a ɓa kee kaala po a hayya a eɗta so ŋ ñammba raak ɗa hayɗi ? Yeem a yi ŋ eɗ barkeeni te wa hey nike na ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Wa Esaaw kerah woo keem, keeñiŋ ɗe aayya, a leehkeeɗa ŋ ɗafka. A woosa baab ɓa ne : « Na so ! Nam mbo eɗ barke. » ");
INSERT INTO sav_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaahha loffa ɗe ne : « Taambɗoh fu hayiɗ ndii a ñaañohha so po ŋ eɗta ɗe barkeeni ŋ joyee ɗa eɗ. » ");
INSERT INTO sav_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaaw woosa ne : « A ɗalɗi tiikiŋ ɗe Yaŋhooɓa (ñaañohoh), a ñaañohiɗ to waas kanak, a adug ɓay waɗiŋ saawi ŋ nikoh, a yi a ɓayissiɗ barkeeni fu joyee so barke'iɗ. » A woosa baab ɓa ne : « Moo fu tasiɗɗi barkeeni fu min ndo eɗ e ? » ");
INSERT INTO sav_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Baab ɓa loffa ɗe ne : « Ŋ tumiɗ ɗe kilifaaniŋ ɗa po ƴutiɗ, ŋ kiimɗiɗ ɗe pees na biiñ laayiɗ te a hey nike kilifaaniŋ ɓaah ciŋ ɗe, ŋ min ɗa ye tumiɗ ? » ");
INSERT INTO sav_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaaw ɓaatta ndengɗuk nga an : « Fu min barke'ɗoh waas yino dong e ? Nam mbo eɗ barke, baab. » A ammba ŋ muhun ca a fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Baab ɓa woosa ɗe ne : « Fu hey use merhey mi baahɗi na maari na pulohe ŋ ɗafki. ");
INSERT INTO sav_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Fu na hee pesohe hiñoh te a taambɗoh fu yilfan ɗa, waaye mbeha fu ndengɗukohan fu hey kaambsuke ini a raan ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Barkeeni Yaŋhooɓa ɓayoh ŋ baab ɓa, weɗ tah po Esaaw ambiɗta ɗe aay-keeñ. A woosa ŋ ɗooƴ ce ne : « Baab mand na kaaniɗ, ruyiŋ ɗe reeh ɗah, ŋ ap Yaŋhooɓa. » ");
INSERT INTO sav_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wa Rebeka inah ina saawiŋ ɗe Esaaw nar tum, a nakohha ɓeeɗkiɗu Yaŋhooɓa, kuɓkiŋ ɗe ƴini, a woosa ɗe ne : « Ŋ ɗiski wa nik ndii, taambɗoh fu waaɗ ɗa ap ne a wirnduk. ");
INSERT INTO sav_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mbaa fu na hee tume an : Ara saandoh ɗiskaŋ taambɗoh ho Laban ŋ Haaraan, ");
INSERT INTO sav_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","fu ɓoofohaah nga po Esaaw giif ngaŋ ayrukiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Aay-keeñiŋ ɗe reeh po a alkoh ini fu haɓiɗ ɗe ɗah, ŋ hey woose ɓo' a kaɗ ɗa ɓaya ; ŋ waaɗɗi ɗu ñak kanak ŋ noh yino. » ");
INSERT INTO sav_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Wa Rebeka woo na Yaŋhooɓa po ƴutta, a woosa Isaahha ne : « Ɗiski ŋ nik kipes neɓisɗi so sagu ɓitiɓ ciŋ Esaaw ɓii, na cuuɓiŋ Hiti ɓa nikoh. Yaŋhooɓa nam ɓay ɓitiɓ nga ɓa ɗah, wa carissanɗi ŋ pese. » ");
INSERT INTO sav_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Weɗ Isaahha ɓeeɗkoh Yaŋhooɓa a kiimiɗta ɗe barke, a dennga ɗe an : « Kana ɓay ɓitiɓ muk ŋ cafaƴ ci gen ndii, Kanaan, ");
INSERT INTO sav_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","kaɗa Paddan-Aram, ŋ Betuwel yi rim yaay ɗu, fu ɓay ɓitiɓ ngaŋ kuɓuucaŋ taanum fu Laban yi taambɗoh yaay ɗu. ");
INSERT INTO sav_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Koohi Min onaat ɗa barke, a tum ɗa ɓasil po fu nik caaciŋ ɓi cuuɓi cuuɓ. ");
INSERT INTO sav_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kooh onaat ɗa barkeeni a onee Ibrahiima, fu na ɓi rimkohan nga ɗa po fu raak kur ki fu nikoh jaambur wii, wi a gapee Ibrahiima. » ");
INSERT INTO sav_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaahha tuuƴca Yaŋhooɓa a kaɗta Paddan-Aram ŋ taanum ce Laban, kuɓu Betuwel yi ɓaah ŋ cuuɓiŋ Aram ci, a nikka taambɗoh Rebeka, yaay ɓi Yaŋhooɓa na Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ŋ ini kaɗ ŋ Esaaw, a kerhiɗ ne Isaahha kiimɗiɗ Yaŋhooɓa barke po a tuuƴiɗ ɗe Paddan-Aram ne a waak ɓitiɓ nga te a dengiɗ ɗe ne a kanaat ɓay ɓitiɓ ŋ cafaƴ ciŋ Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A kerhissa ne Yaŋhooɓa teyɗukɗiɗ baab ɓa na yaay ɓa po a cootiɗ Paddan-Aram. ");
INSERT INTO sav_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Weɗ Esaaw inhoh ne cafaƴ ciŋ Kanaan neɓɗi baab ɓa. ");
INSERT INTO sav_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Wa tahha po a kaɗta ɓayya ɓitiɓ ŋ kuɓuuciŋ Ismaayla yi kuɓkiŋ Ibrahiima. A ɓayya Mahalat taambɗoh Nebayot, a ɓaatta ngaŋ ɓa a raake. ");
INSERT INTO sav_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaŋhooɓa, ŋ pulohaŋ ɗe Beerseba, a yurah Haaraan. ");
INSERT INTO sav_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A kaɗoh kaɗoh po ɗiska noha muyoh ɗe, a parahha ŋ atoh ca ŋ ɗiska, a tiknukkaa, a neehha nga. ");
INSERT INTO sav_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A heeƴca inaa feyohiɗ : Seel yipohha kehƴi po wa maannga ŋ eel ca, malaakaaciŋ Kooh rapeeɗa nga, ruhseeɗa. ");
INSERT INTO sav_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","An ŋ heeƴi, Nikiɗi nikee ŋ serooce a woosa ɗe ne : « Ñam Nikiɗi, Koohiŋ caac ɗu Ibrahiima na baab ɗu Isaahha. Kehƴi fu faankoh wii, ŋ hey ɗa wa one, fu na ɓi na hee rimkohe nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ɓi rimkohan nga ɗa hey laaye po ɓa mand na merhey. Ɗu hey ɓaatke ŋ ɓak ci jen : pulohaaɗ-noh na muyohaaɗ-noh, yaah-sing na yaah-ñaahum. Cuuɓ ciŋ kehƴi jen hey raake barke saguufu, fu na ɓi na hee rimkohe nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mi yii na ɗa te ŋ hey ɗa niiɗe ɗisik nu fu kaɗ ɗah. Ŋ hey ɗa dokne ŋ kehƴii laam ŋ hey ɗa tumɗe in ci ŋ gap ɗa te ŋ moosanɗi ɗa faɗoh. » ");
INSERT INTO sav_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Wa Yaŋhooɓa yunuk a woosa ne : « Ndekete yoo, Nikiɗi yii ŋ ɗiski te ŋ inheeɗaa. » ");
INSERT INTO sav_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A neƴƴohha, a woyissa ne : « Ndii deey wa kaañaah haa, wa nikɗi ɗisik wiiriis ɗal kahan Kooh te weɗ yahndeeriŋ eel ci. » ");
INSERT INTO sav_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wa Kooh wiis na ɓaaɓa Yaŋhooɓa kurukka teel, a ɓayya atoh fa a tiknukohe, a yippaa, a ɓayya diwliin a yiiffaa ŋ ɗafuk wa. ");
INSERT INTO sav_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A teekka ɗiska Betel (kahan Kooh). Waaye kur ka teeksee Luus ŋ ɗeɓgaan. ");
INSERT INTO sav_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ƴutta, a gapukka an : « Kooh hun na so, a tufkoh ho ŋ ɓaaɓiŋ ngo, a on ndo kañam na ɓekkaah, ");
INSERT INTO sav_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","te a amboh ho po ŋ dokuk kahan baab ɓoo moɗoɗ ɗah, ŋ ineem a yi Nikiɗi, a yi nikan Koohiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Te atoh fi ŋ yip inhisoha wii, wa hey nike kahan Kooh. Ndaŋkiyaah nu a tumiɗ to ɗah, ŋ hey ɗe eɗe yinooriŋ wa. » ");
INSERT INTO sav_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Wa Yaŋhooɓa puloh ndaam, a yurahha ɓak kur kaŋ ɓi pulohaaɗ-noh. ");
INSERT INTO sav_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A kaɗoh kaɗoh po, wa raakka mbeh, a pulla ŋ naac ŋ bilaf fa, gat kaahay pe' na mbaal ambsukohiɗ goorra ŋ seroowa, laam, ɓa meeɗee anɗoh ndaam. Naaca meeɗ rangohu atoh yakak. ");
INSERT INTO sav_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ɓaa faɗe faɗ po gat ci jen cohha ɗah, ɓa pilngin atoh fa, ɓa ƴut aniɗ ɗah, ɓa dokina. ");
INSERT INTO sav_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaŋhooɓa meekissa niiɗoh ca ne : « Ƴaaɓi, ɗu puloh nde ? » Ɓa loffa ɗe ne : « Ɓoo puloh Haaraan. » ");
INSERT INTO sav_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A woosa ɓa ne : « Ɗu inhiɗ Laban, setiŋ Nahor e ? » Ɓa loffa ɗe ne : « Ee, ɓoo inhiɗ ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A woosa ɓa ne : « A tum na ? » Ɓa loffa ne : « A yaa ŋ jam ; cafƴa na haye na gateen a kuɓkiŋ ɗe, Rasel. » ");
INSERT INTO sav_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaŋhooɓa woosa ɓa ne : « Ɗu goorɗoh ɗoopaat ci ye, te ŋ hot nohi ris ŋ ɗafki ? Anɗaat ca, ɗu kaɗ ca niiɗa book ! » ");
INSERT INTO sav_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ɓa woosa ɗe ne : « Ɓoo minɗaa paaɗ ; ɓoo na sekee sek po gat ci jen hayya ɗah, ɓoo han min pilngin atoh fi rang naaci, ɓoo aniɗ. » ");
INSERT INTO sav_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wa Yaŋhooɓa woyee na ɓa, weɗi cafƴa reyoh na gataŋ baab ɓa, laam a yi Rasel a nikee niiɗoh. ");
INSERT INTO sav_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Wa a hot Rasel, kuɓkiŋ Laban yi taambɗoh yaayiŋ ɗe, na pe' ca na mbaal ca, Yaŋhooɓa reɓpa ŋ naaca, a pilnginnda atoh fa, a aniɗta gataŋ taanum ce. ");
INSERT INTO sav_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ƴutta a kañiɗta Rasel na morgiɗuk, a fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A woosa Rasel ne : « Mi na baab ɗu, e ɓoo ɓaah, laam, ŋ kuɓu Rebeka. » Rasel nuppa, woosa baab ɓa wa. ");
INSERT INTO sav_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Wa Laban kerah ne Yaŋhooɓa kuɓkiŋ Rebeka yi taambɗoh ce hiiɗ, a arra kaɗ coha na ɗe, a morgiɗukka ɗe, a ɓayya ɗe kahna. Yaŋhooɓa naandsukka ɗe ini raak jen. ");
INSERT INTO sav_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban woosa ɗe ne : « Fu kay, e ɓoo ɓaah ñif yino. » Yaŋhooɓa ɓooffa ŋ kahan ce ina ree caɓin. ");
INSERT INTO sav_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Wa Yaŋhooɓa tum nga caɓin, Laban woosa ɗe ne : « Ini fu ɓaah na so tahanɗi po, fu pangkiɗee so ɓarang ɓarang ; fu na hee so hey woye ini fu na hee wirndasse. » ");
INSERT INTO sav_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Waam raak Laban raakiɗ komaaki kanak cafƴiɗ, saawa teeksee Leya, taambɗoh ce teekuusa Rasel. ");
INSERT INTO sav_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Has ciŋ Leya moɗeen waaye Rasel nikee cafaƴ moɗiɗ lool. ");
INSERT INTO sav_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ŋ ineem Yaŋhooɓa waaɗee Rasel, a woosa Laban ne : « Ŋ hey ɗa pangkiɗe kiis yasna-kanak, ƴut ɗah, fu on ndo Rasel, kuɓkiŋ ɗa ƴini. » ");
INSERT INTO sav_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban loffa ɗe ne : « Ŋ on ɗa ɗe, weɗ ngisohiɗ to fuuf, ŋ kee ona ɓo' wiiriis ɗe, kon, ɓoo tum ɗaa, fu miniɗ tas ŋ kahan ndo. » ");
INSERT INTO sav_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wa ɓa kerhiɗoh ŋ woo, Yaŋhooɓa pangkiɗta Laban kiis yasna-kanak, waaye ca mannda nga ɗe na ɓi neeh dong sagu waaɗa a waaɗee Rasel. ");
INSERT INTO sav_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ƴutta a woosa Laban ne : « Eɗ to ɓitiiso ŋ neeh na ɗe, laam kiis ci ɓoo woytiɗkohee reehiɗ. » ");
INSERT INTO sav_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Weɗi Laban ɓeeɗkoh ɓooɓa genee na ɓa jen, a haɓiɗta ceeke. ");
INSERT INTO sav_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Waaye, na weka, joy ne a ɓay Rasel, a ɓayya saawiŋ ɗe Leya, a eɗta Yaŋhooɓa ɗe, yeem neehha na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Raak, Laban eɗeen Leya ñaamaŋ ɗe ɓitiɓ teeksee Silpa ne a amboh ɗe. ");
INSERT INTO sav_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Wa Kooh wiis na ɓaaɓa Yaŋhooɓa hotta ne, a neeh na Leya. A woosa Laban ne : « Fu haɓiɗ to ye wii, ŋ woytiɗkohee na ɗa Rasel weɗi tahee ŋ pangkiɗta ɗa, wa ye tah fu worra so ? » ");
INSERT INTO sav_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban loffa ɗe ne : « Ineem na tumseeɗi ŋ ndii, ali ɓo' na adgeeɗi kilooku yakak ce. ");
INSERT INTO sav_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Waaye, ɗiindoha neeh ci yasna-kanak ciŋ kilooki na Leya, ƴut ɗah, ŋ eɗ ɗa Rasel ne fu tey pangkis kiis yasna-kanak ndii ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaŋhooɓa teyɗukkaa a ɗiindohha neeh ca yasna-kanak ca na Leya. Ƴutta Laban eɗta ɗe Rasel ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","A nammba eɗndoh Rasel ñaamaŋ ɗe ɓitɓa teeksee Bilha. ");
INSERT INTO sav_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaŋhooɓa neehha na Rasel, a waaɗta ɗe waaɗi uup wa a waaɗee Leya, a pangkiɗissa Laban kiis yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Wa Nikiɗi hot ne Leya waaɗuuɗi, a tummba ɗe ɓasil waaye Rasel mineeɗi raak kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya ammba rook, a raakka kuɓu ƴaar, a woosa ne : « Nikiɗi hotiɗ miskiɗiŋ ngo, ƴaar ro hey yo waaɗe kotii. » A teekka kuɓka Ruben (a hotiɗ). ");
INSERT INTO sav_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A ambissa rook, a raakissa kuɓu ƴaar, a woyissa ne : « Nikiɗi kerhiɗ to. A inhiɗ ne ŋ waaɗuuɗi, a onissiɗ to kuɓu wiiriis. » A teekka ɗe Simeyong (a kerhiɗ). ");
INSERT INTO sav_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A ambissa rook, a raakissa kuɓu ƴaar, a woosa ne : « Koti-kotii, ƴaar ro hey ŋoɗe nga so, laam ŋ raakɗiɗ ɗe kuɓu ƴaar kaahay. » Ineem tahha po kuɓkeem teekuusa Lewi (ŋoɗ). ");
INSERT INTO sav_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leya ambissa rook, a raakissa kuɓu ƴaar, a woyissa ne : « Waasii, ŋ hey gidme Nikiɗi. » Weɗ tah a teekka yeem Yudaa (ŋ hey gidme). A raakisɗi kuɓu, a tufukka. ");
INSERT INTO sav_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Wa Rasel hot ne a minɗi raak na Yaŋhooɓa kuɓu, a ayrukka taambɗoh ce Leya ŋ raaki aa raake kuɓu ; a woosa Yaŋhooɓa ne : « Ɓoo raakaat kuɓu, ŋ kaaniɗ waay ! » ");
INSERT INTO sav_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaŋhooɓa ayrukka ɗe, a woosa ɗe ne : « Ñam Kooh yi hondoh ɗa raak kuɓu e ? » ");
INSERT INTO sav_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasel loffa ne : « Huna na Bilha ñaamiŋ ngo, a raakiɗ to kuɓu koɗaah, po ŋ min nik ɓasil. » ");
INSERT INTO sav_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rasel eɗta Yaŋhooɓa ñaamiŋ ɗe ɓitiɓ, a hunnda na ɗe ; ");
INSERT INTO sav_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","yeem ammba rook, a raakiɗta Yaŋhooɓa kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasel woosa ne : « Kooh atte'iɗ, a eɗiɗ to keeh, a namiɗ to kerah po a oniɗ to kuɓu ƴaar. » Weɗ tah, Rasel teekka ɗe Daan (a atte'iɗ). ");
INSERT INTO sav_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha ambissa rook, a raakɗissa Yaŋhooɓa kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasel woosa ne : « Ŋ leberiɗ na taambɗoh ho leber miskiɗ po ŋ saahiɗ. » A teekka kuɓka Naftaali (ŋ leberiɗ). ");
INSERT INTO sav_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Wa Leya hot ne a tufkiɗ, a minisɗi raak kuɓu, a ɓayya ñaamiŋ ɗe Silpa a eɗta Yaŋhooɓa ɗe ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpa raakiɗta Yaŋhooɓa kuɓu ƴaar, ");
INSERT INTO sav_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya woosa ne : « Wii deey, wa muuɗ. » A teekka kuɓka Gaad (muuɗ). ");
INSERT INTO sav_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa raakɗissa Yaŋhooɓa kuɓu ƴaar, ");
INSERT INTO sav_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya woosa ne : « Ŋ sumiɗ po ɓitiɓ ci hey wee ne ŋ sumiɗ. » A teekka kuɓka Aser (sum). ");
INSERT INTO sav_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wa raakka mbeh, ŋ jamanoona ɓaa nguɗohe bele, Ruben hotta kidig ci na paƴe ɓitiɓ minaaɗi raak kuɓu, na woyse mandargoor, a kommba yaay ɓa Leya ca. Rasel hotta ca, a woosa Leya ne : « On ndo ŋ mandargoor ciŋ kuɓkiŋ ɗa, ne wa neɓ ɗa ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya loffa ɗe ne : « Naafi fu naaf ƴaar ro doyɗi ɗa e ? Po fu waaɗis ɓay mandargoor ciŋ kuɓkiŋ ngo. » Rasel woosa ɗe ne : « Mbaa Yaŋhooɓa neehaat na ɗa woti te fu eɗ to kidig ci. » ");
INSERT INTO sav_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Wa Yaŋhooɓa puloh yohon ca na niina, Leya kaɗta coha na ɗe, a woosa ɗe ne : « Woti, fu na hee neehe na so laam, ŋ romiɗ mbari na mandargoor ciŋ kuɓkiŋ ngo. » Mbaɗi, Yaŋhooɓa neehha na Leya. ");
INSERT INTO sav_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kooh teyɗukiɗta Leya, a ammba rook, a raakissa kuɓu ƴaar, yi yatuusɗoh. ");
INSERT INTO sav_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya woosa ne : « Kooh wirndiɗ to ŋ eɗi ŋ eɗ ƴaar ro ñaamiŋ ngo. » A teekka kuɓka Issaakar (wirndiŋ ngo). ");
INSERT INTO sav_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya ambissa rook, a raakissa kuɓu ƴaar, yi yasna-yino'ɗoh. ");
INSERT INTO sav_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A woosa ne : « Kooh tumɗiɗ to in yakak, kotii ƴaar ro hey yo meeɓle, laam ŋ raakɗiɗ ɗe kuɓu ƴaar yasna-yino. » A teekka kuɓka Sabuloon (a hey yo meeɓle). ");
INSERT INTO sav_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ŋ mirndaani a raakissa kuɓu ɓitiɓ a teekka ɗe Dinaa. ");
INSERT INTO sav_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ŋ ini kaɗ ŋ Rasel, wa Kooh tufuk ŋ in ciŋ ɗe, a teyɗukiɗta ɗe, a onnda ɗe, a minnda raak kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rasel ammba rook, a raakka kuɓu ƴaar. A woosa ne : « Kooh pulɗohiɗ to ŋ kaciikiŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A teekka kuɓka Yuusufa (a ɓaataat), a kiimmba Nikiɗi ne a ɓaat ɗe kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ŋ finho raakuukaŋ Yuusufa, Yaŋhooɓa woosa Laban ne : « On ndo ŋ haad kur ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Fu eɗ to ɓitiɓ ciŋ ngo na kuɓuuciŋ ngo ŋ coot, laam, ɓeɗ tahee so pangkiɗeeɗa ɗa ; fu ŋ haf fu, fu inhiɗ ini ŋ haɓɗiɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban woosa ɗe ne : « On ndo wa on ! Laam, ŋ markiskiɗ po ŋ hotiɗ ne, Nikiɗi barke'ɗiɗ to saguufu, ");
INSERT INTO sav_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","woya ini fu waaɗ wirndu, ŋ eɗ ɗa wa. » ");
INSERT INTO sav_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaŋhooɓa woosa ɗe ne : « Fu ŋ haf fu, fu inhiɗ findi ŋ pangkiɗoh ɗa, na findi gatiŋ ɗa mirndoh mand saguuso. ");
INSERT INTO sav_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ini ƴissuuti fu raakee bala ŋ hayan ɗah, wa ɓaatkiɗ baahiɗ. Laam ina ŋ aasoh kahan fu poyi, Nikiɗi barke'ɗiɗ ɗa saguuso. Mbaa wa reyiɗ kotii nak ne ŋ pangkiɗ haf fo. » ");
INSERT INTO sav_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban meekissa ɗe ne : « Mi na hee ɗa eɗe hend na ? » Yaŋhooɓa woosa ne : « Fu heyɗi so eɗe ali in, waaye fu teyɗuk ini maa hee ɗa woye ɗah, ŋ hey taalndiɗe, ŋ niiɗɗissee ɗa gatiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ŋ woo ne, woti, ŋ hey aase ŋ gat ciŋ ɗa, ŋ puliɗ pe' ci na mbaal ci jen, ci nik njeenje nga na mbaal ci suusus ci, ca nik wirndiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kim fu hey marke wirndiŋ ngo ɗah, fu hey hote kiyurhiŋ ngo, laam fu hot mbaal ci nikɗi suusus mbaa pe' ci nikɗi njeenje nga ɗah, fu inah ne ca roku roku. » ");
INSERT INTO sav_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban woosa ɗe ne : « Ee ŋ huniɗ nga. » ");
INSERT INTO sav_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Waaye mbaɗi, Laban ɓayya suket ca na pe' ca njeenjeeca raak in yaanow jen, na mbaal ca suusus ca, a degga ca ŋ yaah kuɓuuciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","A cootta na ɓa, ɓa ussa Yaŋhooɓa ini ree tiindu neeh kaahay, waaye Yaŋhooɓa taambkoheeɗa ini tas ŋ gataŋ Laban. ");
INSERT INTO sav_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Weɗ a waakoh ɓi ndooɗ iiri ngaŋ kidig kaahay ɓaahaaɗi, ndooɗ \"poopaalye\" na ndooɗ \"gerte-tuɓaaɓ\" na ndooɗ \"palatan\" ; a ŋeeƴ-ŋeeƴiɗta ca po ndooɗ nu nga ɗah, raakka yaanow yaanow. ");
INSERT INTO sav_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A ɓekka ca ŋ ɗooƴ hongla na anɗohse, ne ɗoopaat ca hay ane ɗah, ca hot ca laam, ɗoopaat ca meeɗ rapkoh ŋ ndaam ne ca hayya ane ɗah. ");
INSERT INTO sav_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ca rapkohha ŋ fiki ndooɗ ceem ɗah, ca na rime buul njeenje. ");
INSERT INTO sav_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaŋhooɓa saɓsohha buul ceem, a yurhiɗta haf ciŋ ca ngaŋ njeenjeeca na suusus ca nikee ngaŋ gataŋ Laban. A waakoh gat haf ce ɗaa, ɓaahaaɗi na waŋ Laban. ");
INSERT INTO sav_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ɗoopaat ca kapiɗ ca heesa rapkohe ɗah, a ɓekiɗ ca ndooɗ ca ne ca rapkee ɗah, ca yurhiɗkoh na ca, ");
INSERT INTO sav_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","waaye ca nikka ɗoopaat ca ñiiɓiɗ ca ɗah, a ɓekɗuu ca ali in. A tumee ɗaa po ca kapiɗ ca nikka caŋ ɗe, ca ñiiɓiɗ ca nikka caŋ Laban. ");
INSERT INTO sav_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ŋ mirndaani a nikka heɗ raak-raak yakak, a raakeen ɓi gat pe' na mbaal na ɓi ñaam ƴaar na ɓitiɓ na ɓi ngeelemb na ɓi mbaam. ");
INSERT INTO sav_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kaɗta po Yaŋhooɓa kerahha ini kuɓuuciŋ Laban meeɗ woo, an : « Yaŋhooɓa ɓayiɗ raak-raakiŋ baabiŋ ɓoo jen po wa tahiɗ ɗe raak. » ");
INSERT INTO sav_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ŋ ɗooƴ ineem Yaŋhooɓa nammba hot ne findi Laban mandee na ɗe, a mandisɗi ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nikiɗi woosa Yaŋhooɓa ne : « Gurda fu haad kur ɗu, nga ɓi kahan baab ɗu, ŋ hey rise na ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Waam raak Yaŋhooɓa na gat ca ŋ yohon ca, a nakohha ɓeeɗkiɗu ɓitiɓ ciŋ ɗe Rasel na Leya ; ");
INSERT INTO sav_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","a woosa ɓa ne : « Ŋ markiɗ po ŋ hotiɗ ne baab ɗu mandisɗi nga so findi a mande. Waaye Koohiŋ baab ɓoo yii na so. ");
INSERT INTO sav_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ɗu inhiɗ ne ŋ pangkiɗiɗ ɗe findi ŋ minoh, ");
INSERT INTO sav_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","hondohɗi a worra so, a ɓoƴsohha wirndiŋ ngo waas ndaŋkiyaah, waaye Kooh faɗɗi ɗe ne a tum mbo miskiɗ. ");
INSERT INTO sav_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A woosa so ne ɗoopaat ci tap-tap ci ceɗ wirndiŋ ngo ɗah, ndaamuuci jen na rime raakiɗ tap-tap. A woosa ne ci fiis-fiis ci ceɗ wirndiŋ ngo ɗah, ndaamuuci jen na rime raakiɗ fiis-fiis. ");
INSERT INTO sav_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","E Kooh naaf gatiŋ baabiŋ ɗu, a eɗta so wa. ");
INSERT INTO sav_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ŋ jamanooni ɗoopaat ci na rapke, ŋ hotta ŋ ɗooƴ heeƴ ne suket ci na rape jen nikee njeenje raakiɗ tap-tap mbaa fiis-fiis. ");
INSERT INTO sav_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Weɗ malaakaaniŋ Kooh woyoh ne : “ Yaŋhooɓa ! ” Ŋ woosa ɗe ne : “ Ee mi yi kerah ɗa. ” ");
INSERT INTO sav_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A woosa so ne : “ Marka, ɗoopaat ci na rape jen ca njeenje, raakiɗ tap-tap mbaa fiis-fiis, laam ŋ hotiɗ findi Laban na tumohe na ɗa. ");
INSERT INTO sav_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ñam Koohi teeɓkee ɗa ŋ Betel ŋ ɗiska fu yipee atoh fa, fu yiiffa diwliin nga, te fu gappa so mbaɗi. Ŋ ɗiski wa nik ndii, faɗa kur kii, fu haad kur ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Wa Yaŋhooɓa woo woo keem, Rasel na Leya loffa ɗe ne : « Ɓoo raakisɗi ɓak na in lamaah ŋ kahan baabiŋ ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ɓoo mand na jaambur nga ɗe ; laam a tooniɗ ɓoo po a ñamiɗ candoomi. ");
INSERT INTO sav_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mbaa, in nu Kooh naafoh nga ɗe ɗah, a wiŋ ɓoo na kuɓuuciŋ ɓoo ; tuma ini Kooh nak ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Weɗi Yaŋhooɓa kooɗkoh, a rapiɗta ɓitiɓ ciŋ ɗe na kuɓuuciŋ ɗe ŋ ngeelemb ca, ");
INSERT INTO sav_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","a nammba ɓay ɗoopaat caŋ ɗe na in ca a raakoh Paddan-Aram jen ne a dokuk kahan baab ɓa Isaahha ŋ Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Waam raak Laban kaɗiɗ hufa find caŋ mbaal caŋ ɗe. Rasel tondukka nga, a rokka in ca pestuuɗ ca baab ɓa ambee ne ceɗ kooh ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaŋhooɓa nammba inah ne Laban yi ɓaah ŋ cuuɓiŋ Aram ci nikɗi nga, a moonnda ɗe. ");
INSERT INTO sav_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A saandohha na ina a raakoot jen, a huussa kala na woyse Ewfaraat po a pullaa, a yurahha ŋ ɓak tangooca nik ŋ Galaad. ");
INSERT INTO sav_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yaŋhooɓa cootiɗ po wa raakka neeh kaahay, Laban hanndaa woyu. ");
INSERT INTO sav_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","A jaarra hun na ɓooɓaŋ ɗe, ɓa taambɗeeɗa Yaŋhooɓa ini ree neeh yasna-kanak, ɓa hannda ɗe rahas ŋ tangoocaŋ Galaad. ");
INSERT INTO sav_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Waaye ŋ weka, Kooh teeɓukka Laban ngaŋ heeƴ, a woosa ɗe ne : « Wortuka woo Yaŋhooɓa in. » ");
INSERT INTO sav_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Wa Laban rahas Yaŋhooɓa, raak ɗe yipiɗ ŋ tangoocaŋ Galaad ; Laban nammba yip ɗiip caŋ ɗe nga, a yi na ɓooɓaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","A kaɗta ŋ Yaŋhooɓa, a woosa ɗe ne : « Fu haɓiɗ ye cii, fu na ɗembohee so ye fu coote ? Fu ɓayndoh kuɓuuciŋ ngo ɓitiɓ ci po haa ɓooɓi ambohu ŋ hiñoh. ");
INSERT INTO sav_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Wee tah fu moonnda so, fu kaɗe te fu asukɗi so ? Fu woyeen ndo ɗah, ŋ heen ɗa faɗe fu kaɗ moɗoɗ, ŋ ɓend ɗa na ɓi ƴeek na haan na koora. ");
INSERT INTO sav_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Fu onɗi so sah, ŋ askoh na set ciŋ ngo na kuɓuuciŋ ngo ; fu tum naandoha kat ! ");
INSERT INTO sav_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ŋ miniɗ ɗa tum in sepƴiɗ, waaye Koohiŋ baab ɗu teeɓkiɗ to niinma, a woosa so ne : “ Wortuka woo Yaŋhooɓa in. ” ");
INSERT INTO sav_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Fu seesuk haad kahan baab ɗu ɗah, fu miniɗ kaɗ sah, waaye fu rokoh kooh ciŋ ngo ye ? » ");
INSERT INTO sav_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaŋhooɓa loffa Laban ne : « Ŋ neƴƴohee ne fu naaf kuɓuuciŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Waaye ɓo' nu fu hot na kooh ciŋ ɗa ɗah, a pesissanɗi. Ŋ fiki ɓooɓiŋ ngo na ɓiŋ ɗa, marka, in nu fu hot na so te nik ne ya fu raaka ɗah, ɓayaa. » Waam raak Yaŋhooɓa inahɗi ne a Rasel rok ca. ");
INSERT INTO sav_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Weɗi Laban aasoh ŋ ɗiipaŋ Yaŋhooɓa na waŋ Leya na caŋ ñaam ca kanak ca, a hotɗi in. A pulohha waŋ Leya, a aassa waŋ Rasel. ");
INSERT INTO sav_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raak Rasel ɓayiɗ kooh ca, a ɓekka ca ŋ teg ngeelemb, a ɓooffa nga. Laban marakka ɗiipa jen, a hotɗi in. ");
INSERT INTO sav_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel woosa ɗe ne : « Baab deey, fu na hee so hey ɗaase, ŋ minɗi kuruk laam ŋ hot naaw. » Ndaa a markoh po a yaaɓpa, a hotɗi ali in. ");
INSERT INTO sav_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Weɗi Yaŋhooɓa ayrukoh, a ngasukka Laban an : « Ŋ tum ɗa ye, ŋ haɓiɗ winde ro' po fu taambɗee so mand an ? ");
INSERT INTO sav_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wi fu waak ŋ in ciŋ ngo po fu ƴutta, pulɗa ini fu hot ndii te fu raakkaa, degaa ndii ŋ fiki ɓooɓiŋ ngo na ɓiŋ ɗa, ɓa atte ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ŋ tumiɗ kiis ndaŋkiyaah-kanak (20) ŋ kahan fu ; ali ɗoopaat moosɗi waanoh nga te ŋ moosɗi ɗa ñamɗoh kuy yino. ");
INSERT INTO sav_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Yaa nu apseen nga ɗah, ŋ meeɗɗi ɗa ɗe kom, ñam meeɗa deguk, te ɗoopaat nu rokseen nga, wa nik na wek mbaa na noh, fu meeɗ to ɗe meeɗ wirndiɗuk. ");
INSERT INTO sav_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Dohɗiŋ nohi meeɗ reeh nga so. Wek ree ɗah, soosi hee so ape ; ŋ minuu sah gind pani. ");
INSERT INTO sav_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kiis ndaŋkiyaah-kanak (20) ceɗɗi, ŋ nikka ca ŋ kahan fu, ŋ pangkiɗiɗ ɗa kiis ndaŋkiyaah na kiis nikiis (14) ne fu on ndo kuɓuuciŋ ɗa kanak cii. Ŋ pangkiɗissa ɗa kiis yasna-yino ne ŋ raak gat, waaye hondohɗi, fu ɓoƴsohiɗ wirndiŋ ngo waas ndaŋkiyaah. ");
INSERT INTO sav_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Koohiŋ Ibrahiima, a nammba nik Yi baab ɓoo Isaahha nupe, a amboheeɗi so ɗah, fu heen ndo aañe yaah ɓarang. Waaye a hotiɗ findi ŋ yaaɓoh na ini ŋ op po tahha niinma, a atteesa. » ");
INSERT INTO sav_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Wa a woo ineem, Laban loffa ɗe ne : « Ɓitiɓ cii, ɓa kuɓuuciŋ ngo, komaakcii, ɓa ɓiŋ ngo te gat cii, ñam raak ca. In nu fu hot ndii ɗah, wa ɓaah nga so ; ɗiski wa nik ndii fu liiɓiɗ moos ne ŋ hey tume kuɓuuciŋ ngo in, na komaakciŋ ɓa e ? ");
INSERT INTO sav_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mi yi kiim ɗa ɓoo tufkiɗ ambtiɗoh ndii mi na ɗa te wa raak ini seede'ana. » ");
INSERT INTO sav_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaŋhooɓa parahha atoh, a yippaa, ");
INSERT INTO sav_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","a woosa ƴaaɓaŋ ɗe ne ɓa parhaat atoh ; ɓa parahha, ɓa juukka ca ɗisik yino. Ƴutta, ɓa ɓooffa nga jen, ɓa ñameeɗa. ");
INSERT INTO sav_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban teekka ɗiska Yegaar-Sahaduta (juuk atoh seede ŋ peɗmiŋ ɗe), Yaŋhooɓa nammbaa teek Galeed (juuk atoh seede ŋ peɗmiŋ ɗe). ");
INSERT INTO sav_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban woyeen ne : « Juukiŋ atoh fii weɗi ini na hee nike seedeeni ŋ harmban mi na ɗa woti. » Weɗ tah wa teekuusa Galeed. ");
INSERT INTO sav_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Wa teekissuuɗ Mispa (ɗisik markoha), laam Laban woyisseen ne : « Nikiɗi markaat ɓoo kanak baahiɗ ne ɓoo hotohisɗi ɗah. ");
INSERT INTO sav_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Fu torhiɗ kuɓuuciŋ ngo, mbaa fu ɓay ɓitiɓ wiiriis fu deg nga ɓa ɗah, inha ne ali ɓo' nikɗi ŋ harmban mi na ɗa, a Kooh nikan seedeeni ŋ harmban ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban woyissa Yaŋhooɓa ne : « Juukiŋ atoh fii na atoh fi ŋ yip, ");
INSERT INTO sav_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ceɗ ŋ harmban ɓoo, weɗ teeɓoh ne ŋ joyɗi ca cootuk ne ŋ yurhiɗ in moɗaaɗi nga ɗa te fu joyɗaa nam tum. ");
INSERT INTO sav_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Koohiŋ Ibrahiima na yiŋ Nahor, kooh ciŋ baab ciŋ ɓa, nikaat seedeeciŋ ɓoo. » Yaŋhooɓa ginnja ŋ Kooh yi baab ɓa Isaahha nupe. ");
INSERT INTO sav_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ƴutta a puliɗta seeƴkaah wuu Kooh, a ɓeeɗukka ƴaaɓa jen, ɓa ñammba, ɓa neehha nga, ŋ tangoora. ");
INSERT INTO sav_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wa Kooh wiis, Laban kurukka na ɓaaɓa teel, a morgiɗkohha na set caŋ ɗe na kuɓuucaŋ ɗe, a askohha na ɓa, a haadeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaŋhooɓa taalndiɗta waasaŋ ɗe. A yi kaɗoh kaɗoh po, ɓi malaaka teeɓukka ɗe. ");
INSERT INTO sav_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Wa a hot ɓa, Yaŋhooɓa woosa ne : « Wii deey, wa daliŋ Kooh. » Weɗ tah a teekka ɗiska Mahanayim (dal ci kanak ci). ");
INSERT INTO sav_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wa ineem coot, Yaŋhooɓa woossa ɓi ɓo' ne ɓa adug ɗe ŋ taambɗoh ce Esaaw, ŋ kur ka na woyse Seyiir ŋ Edom. ");
INSERT INTO sav_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A woosa ɓa ne : « Ɗu kaɗ ɗah, ɗu na wee kilifaaniŋ ngo Esaaw ne : “ Ñaamiŋ ɗa Yaŋhooɓa a yi woos ɓoo. A woo ne a ɓaaɓee ɗiskaŋ Laban, a nikka nga po woti. ");
INSERT INTO sav_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","A raakiɗ ɓi inoh na mbaam, na ɓi pe' na mbaal na ɓi ñaam ƴaar na ɓitiɓ. A yii kiim ɗa ne fu teyɗuk ɗe moɗoɗ. ” » ");
INSERT INTO sav_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Wa ɓooɓa Yaŋhooɓa woosee hay, ɓa woosa ɗe ne : « Ɓoo deey, ɓoo kaɗiɗ ŋ taambɗoh fu Esaaw. A yii ŋ waas, na haye na ƴaar teemet-nikiis (400). » ");
INSERT INTO sav_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Wa Yaŋhooɓa kerah ineem a neƴƴohha lool. A paysohha ɓooɓaŋ ɗe dal kanak, na mbaal ca na pe' ca na inoh ca na ngeelemb ca. ");
INSERT INTO sav_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Laam a woo ne : « Esaaw keen winoori ɗah, wi tas hey mine fus. » ");
INSERT INTO sav_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yaŋhooɓa kiimmba Kooh an : « Nikiɗi, Koohiŋ caac Ibrahiima, yi nam nik Koohiŋ baab Isaahha, a fu woyee so ne ŋ dokkaat kur ɓoo, nga ɓi kahan baab ɓoo te fu hey yo ambohe. ");
INSERT INTO sav_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mi yi ñaamiŋ ɗa deey, ŋ carɗi baahohi fu baahoh ho na ambi fu amb mbo ; laam, wa maa huuse ŋ kalaŋ Yurdan, ŋ ambee ndooɗ dong ŋ yaah ciŋ ngo te ŋ raakiɗ dal kanak kotii. ");
INSERT INTO sav_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mi yii kiim ɗa fu muciɗ to ŋ yaah ciŋ taambɗoh ho Esaaw laam, ŋ neƴƴohiɗ ne a raak ko ndii, a ap po, a apndoh ndaamu na kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","A fu woyee so ne : “ Ŋ hey ɗa ambohe, ŋ ɓaat ɓi na hee rimkohe nga ɗa, po ɓa hend na merhey mi ŋ yaah-cookmi. Ali ɓo' minanɗi ɓa kind. ” » ");
INSERT INTO sav_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yaŋhooɓa neeh ndaam, a nihsiɗta taambɗoh ce Esaaw ŋ raak-raakaŋ ɗe ne a eɗ ɗe ; ");
INSERT INTO sav_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ca nikka pe' teemet-kanak (200) na suket ndaŋkiyaah-kanak (20), na mbaal riɓ teemet-kanak (200) na kuy ndaŋkiyaah-kanak (20), ");
INSERT INTO sav_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","na ngeelemb ndaŋkiyaah-kaahay (30) ɓapɗoh na buul caŋ ca, na inoh riɓ ndaŋkiyaah-nikiis (40) na naar ndaŋkiyaah na mbaam riɓ ndaŋkiyaah-kanak (20) na mbaam naar ndaŋkiyaah. ");
INSERT INTO sav_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Gat nu nga ɗah, a eɗtaa ñaam. A woosa ɓa ne : « Adgiɗohaat, ɗu kaɗ te ɗu usoh, ŋ taambee nga ɗu. » ");
INSERT INTO sav_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A woosa ñaama adug ne : « Fu coh na taambɗoh ho Esaaw ɗah, a meekis ɗa ne : “ Ya ɓa kilifaaniŋ ɗa ? Fu na kee nde ? Ya ɓa raak gati fu ɓay wii ? ” ");
INSERT INTO sav_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Woyaa ɗe ne : “ A ñaamiŋ ɗa Yaŋhooɓa na ɗaasnukohee ɗa wa, te a yii hay ŋ finho ɓoo. ” » ");
INSERT INTO sav_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A nammba woo ya kanakɗoh ɗaa, na ya kaahayɗoh, na ɓa ñaakee ŋ gat ca jen. A dennga ɓa ne : « Ɗu coh na Esaaw ɗah, woyaat ɗe ineem, ");
INSERT INTO sav_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","te kanaat alkoh ɓaat nga ne ñaamiŋ ɗe Yaŋhooɓa yii hay ŋ finhooɗu. » Yaŋhooɓa woosa ŋ ɗooƴ ce ne : « Mi na hee ɗe giifɗe na in ci ŋ on ɗe ; ƴut, ŋ coh na ɗe ɗah, ŋ liiɓiɗ ne a hey yo teyɗuke moɗoɗ. » ");
INSERT INTO sav_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Gat ca onohu cootta, waaye a yi Yaŋhooɓa, a neehha ɗiska. ");
INSERT INTO sav_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Na weka, Yaŋhooɓa ɓayya ɓitiɓ caŋ ɗe kanak ca, na ɓaŋ ɗe ñaam ca kanak ca na kuɓuucaŋ ɗe ndaŋkiyaah na yinooca (11), a huusiɗta ɓa kalaŋ Yabbok. ");
INSERT INTO sav_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A koc ɓa ƴakaandkiɗ, po ƴutta a degga raak-raakaŋ ɗe nga. ");
INSERT INTO sav_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A tassa ŋ ɗiska kiik ce ; a nikka nga po ƴaar pulla nga ɗe, ɓa neehha leber po ŋ wiisaaɗiina. ");
INSERT INTO sav_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Wa ƴaara kaɗ po, a inahha ne a miniɗɗi Yaŋhooɓa in ŋ lebera, a laɓpa ɗe ŋ rangaƴ ; rangƴiŋ Yaŋhooɓa mukuƴca. ");
INSERT INTO sav_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ƴaara woosa ɗe ne : « Faɗ to ŋ coot bala nohi pulan ɗah. » Waaye Yaŋhooɓa woosa ɗe ne : « Ŋ heyɗi ɗa faɗe fu coot ne fu barke'iɗɗi so ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ƴaara meekissa ɗe ne : « Fu teeku na ? » A woosa ne : « Ŋ teeku Yaŋhooɓa. » ");
INSERT INTO sav_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ƴaara woyissa ɗe ne : « Fu teekissuuɗi Yaŋhooɓa. Tiikiŋ ɗa kotii wa Israayel, laam fu hiñohiɗ na Kooh, fu hiñohha na ɓo' te ya fu min. » ");
INSERT INTO sav_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaŋhooɓa nammba ɗe meekis : « Fu miniɗ to woo findi fu teeku e ? » A woosa ne : « Wee tah fu meeksee so tiikiŋ ngo ? » Ŋ ineem, a barke'iɗta Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaŋhooɓa teekka ɗiska Peni'eel (fikiiriŋ Kooh) laam, a woo ne : « Ŋ hotiɗ Kooh jahran te ŋ ris pes. » ");
INSERT INTO sav_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Wa noha pul, raak Yaŋhooɓa kurkohiɗ Peni'eel, a yiiɓeeɗa sagu rangƴiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Ineem weɗ tah po woti, raakiɗ ɓaki nik ŋ rangaƴ Israayel ci na ñameeɗi wa, laam, Yaŋhooɓa laɓsee nga. ");
INSERT INTO sav_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Wa Yaŋhooɓa puloh Peni'eel, ɗekka po a hotta Esaaw hayeeɗa na ƴaar teemet-nikiis (400). A paysohha komaakca ŋ harmban Leya na Rasel na ñaam ca kanak ca. ");
INSERT INTO sav_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A adgiɗ ñaam ca kanak ca na kuɓuuca a raak na ɓa, a degga Leya nga na ɓaŋ ɗe, a mirndohiɗta Rasel na Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ƴutta, a hannda adug ŋ fikiira a kaɗeeɗa, a ƴekɗeeɗa taambɗoh ce Esaaw poo a raakka waas yasna-kanak bala a reyan nga ɗe ɗah. ");
INSERT INTO sav_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaaw nuppa, a kaɗta coha na ɗe. Wa a ree, a morgiɗukka ɗe, ɓa ambsukohha kanak, ɓa fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wa Esaaw hot ɓitiɓ ca na komaakca, a meekissa Yaŋhooɓa ne : « Ɓooɓi fu hun na ɓa ɓii, ɓa ye nga ɗa ? » Yaŋhooɓa loffa ɗe ne : « E kuɓuuci Kooh baahoh ho, kilifaani. » ");
INSERT INTO sav_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ñaam ca na kuɓuucaŋ ɓa reɓpa, ɓa ƴekiɗta Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya na ɓaŋ ɗe nammba reɓ, ɓa tummba ɗaa. Ƴutta, Yuusufa na Rasel nammba tum ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaaw meekissa ɗe ne : « An wa ye tah ɗa woosoh gat ci ŋ coh na ca jen ? » Yaŋhooɓa loffa ɗe an : « Ne fu teyɗuk ko moɗoɗ kilifaani. » ");
INSERT INTO sav_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaaw woosa ɗe ne : « Ƴaariŋ ngo, ŋ raakiɗ po ŋ doyɗiɗ, fu miniɗ amb ini fu raak. » ");
INSERT INTO sav_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaŋhooɓa loffa ɗe ne : « Muk ŋ kiim ɗa wa kiim ne fu ambɗisɗi so aay-keeñ ɗah, teya in ci ŋ on ɗa ; laam wi ŋ coh na ɗa fu teyɗukiɗ to moɗoɗ po haa ŋ coh na Kooh jahran. ");
INSERT INTO sav_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mbaa teya in ci ŋ on ɗa, laam Kooh oniɗ to po ŋ raakiɗ lool. » Yaŋhooɓa ñaakiɗta ɗe na ca po Esaaw mirndohha ca ɓay. ");
INSERT INTO sav_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaaw woosa ɗe ne : « Haya ɓoo kaɗ, ŋ ɓend ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaŋhooɓa woosa ɗe ne : « Kilifaani, fu inhiɗ ne komaakci ndengɗi te ŋ waaɗ seeskiɗ ɗoopaat ci na ɓapɗe ɗah, noh yino dong ca kaan jen. ");
INSERT INTO sav_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kon kilifaani, fu na hee so hey adge, ŋ hun na komaakci na gat ci, ŋ taambee nga ɗa ƴin-ƴin po mbaɗna ŋ raakan ɗa ŋ Seyiir. » ");
INSERT INTO sav_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaaw woosa ɗe ne : « Mbaa, faɗa ŋ haawsiɗ ɗa ngaŋ ɓooɓiŋ ngo. » Yaŋhooɓa woosa ɗe ne : « Wa carɗaa, ŋ waaɗee rek ne fu teyɗuk ko moɗoɗ. » ");
INSERT INTO sav_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Mbaɗi, Esaaw kooɗissa waas, a gurdeeɗa Seyiir, ");
INSERT INTO sav_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","waaye Yaŋhooɓa yurahha kur ka na woyse Sukkoot. A haɓiɗta kahan nga, a nammba ɗiipiɗ ɗoopaat caŋ ɗe nga ; weɗ tah ɗiska teekuusa Sukkoot (ɗiip). ");
INSERT INTO sav_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaŋhooɓa reyiɗ Kanaan moɗoɗ kotii ŋ pulohaŋ ɗe Paddan-Aram, a yipee ŋ fiki kur ka na woyse Sisem. ");
INSERT INTO sav_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A romohee yohna a yipohee ɗiip caŋ ɗe ngaŋ kuɓuucaŋ Hamor, baabiŋ Sisem. Candoomaŋ wa nikee ƴel haalis teemet (100). ");
INSERT INTO sav_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A haɓiɗta seeƴkoha nga ; a teekkaa El-Elohe-Israayel (Koohiŋ Israayel a yi Kooh). ");
INSERT INTO sav_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Wa raakka mbeh, Dinaa, kuɓka cafƴa Yaŋhooɓa raakee na Leya, kaɗta marka ɓitiɓ caŋ kur ka, ");
INSERT INTO sav_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","raak Hamor, ya ɓaah ŋ cuuɓaŋ Hiw ca a yi adgohee wa ; a raakeen kuɓu ƴaar teeku Sisem. Sisem yeem hotta Dinaa, a ammba ɗe, a siiffa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","A waaɗta ɗe po a jeemeeɗa ɗe nook ŋ haf ce ne yeem waaɗ ɗe ; ");
INSERT INTO sav_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","a woosa baab ɓa Hamor ne : « Baab, ɓayiɗ to cafƴii ɓitiɓ. » ");
INSERT INTO sav_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Wa Yaŋhooɓa kerah ne Sisem yahiɗ kuɓkaŋ ɗe Dinaa, a wooɗi in nga laam wa raak kuɓuucaŋ ɗe ƴaar ca ŋ yohon ca na gat ca ; a sek sek po ɓa hayya. ");
INSERT INTO sav_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ŋ neeh ceem, Hamor, baab ɓi Sisem kaɗta ŋ Yaŋhooɓa ne a woo na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Wa hennda kuɓuucaŋ Yaŋhooɓa pulohha yohon ca, ɓa kerahha ina raak, wa mannda na ɓaseeh nga ɓa. Wa ayrukiɗta ɓa lool laam Sisem haɓiɗ in moɗaaɗi'iɗ ; faanka a faanuk kuɓkaŋ Yaŋhooɓa, ini joyɗi tumu ŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor woosa ɓa ne : « Sisem, kuɓkiŋ ngo waaɗiɗ Dinaa lool ; mi yii kiim ɗu ne ɗu on ɗe ɗe ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Te, ɓoo kilooktiɗohaat, ɗu ɓayee ɓitiɓ ŋ kuɓuuciŋ ɓoo, ɓoo namee kilook ŋ cafaƴ ciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kur ki weɗi wii, genaat na ɓoo, ɗu toontukee nga, ɗu waak merhey nga. » ");
INSERT INTO sav_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sisem nammba woo Yaŋhooɓa na taambɗoh caŋ Dinaa ne : « Ɗu teyɗukiɗ to ɗah, in nu ɗu meekis so ɗah, ŋ hey ɗu wa eɗe. ");
INSERT INTO sav_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Meeksaat to cakiim ɓitiɗ, ŋ hey wa eɗohe. Meeksaat to in laayiɗ, ŋ hey ɗu wa one ; teyɗukaat to on kuɓkiŋ ɗu ɓitiɓ rek. » ");
INSERT INTO sav_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sagu yahi taambɗoh ɓa Dinaa yahu, kuɓuuciŋ Yaŋhooɓa ñaañohha Sisem na Hamor, yi baabiŋ ɗe ; ");
INSERT INTO sav_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ɓa woosa ɓa ne : « Ɓoo minɗi on taambɗoh ɓoo ƴaari nguɗukɗi laam ineem, mand na ɓaseeh nga ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ɓoo min ɗu teyɗukiɗ ŋ in yino, weɗ ne ƴaar ciŋ kur ki jen nguɗuk findi ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ŋ ineem ɗu hey mine ɓay ɓitiɓ ŋ cafaƴ ciŋ ɓoo, ɓoo min ɓay ngaŋ ɓiŋ ɗu ; ɓoo gen na ɗu, ɓoo nik yino. ");
INSERT INTO sav_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Waaye ɗu hunɗi ŋ ineem ɗah, ɓoo hey ɓaye taambɗoh ɓoo te ɓoo coot na ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Weɗ Hamor na kuɓkiŋ ɗe teyɗukoh ineem. ");
INSERT INTO sav_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","A yi Sisem, a arra tum ina a woyu sagu waaɗa a waaɗee kuɓkaŋ Yaŋhooɓa. A nikee ɓoya uupee kerhiɗu ŋ kahan baab ɓa. ");
INSERT INTO sav_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor na Sisem kaɗta ŋ teembohaara, ŋ aasohaanaŋ kur ka, ɓa woosa ɓooɓaŋ ɓa ne : ");
INSERT INTO sav_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Ɓooɓii deey, ɓa raakiɗ jam na ɓoo, ɓoo faɗaat ɓa, ɓa gen ŋ kur ki laam wa angiɗ ; ɓa toontukee nga, ɓoo minee ɓay ɓitiɓ ŋ kuɓuuciŋ ɓa, ɓa namee ɓay ɓitiɓ ŋ ɓiŋ ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ɓa hey teyɗuke gen na ɓoo, ɓoo nik yino, waaye, bala ineem minan nik ɗah, ƴaar ciŋ kur ki jen hey nguɗke findiiɓa. ");
INSERT INTO sav_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ɓoo teyɗukaat tum ini ɓa woo, ɓa min gen na ɓoo. Wa nik ɗah, gat ciŋ ɓa na raak-raakiŋ ɓa jen jaaran nik cuu ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ƴaar ca nikee ŋ aasohaanaŋ kur ka jen, kerhiɗta Hamor na kuɓkiŋ ɗe Sisem, ɓa nguɗukka. ");
INSERT INTO sav_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Wa ɓa nguɗuk po wa degga neeh kanak, miskiɗa nikka na ƴaar ca, kanak ŋ kuɓuucaŋ Yaŋhooɓa, Simeyong na Lewi, taambɗoh caŋ Dinaa, ɓayya ndang caŋ ɓa ; ɓa aassa kur ka moɗoɗ, ɓa appa ɓa jen. ");
INSERT INTO sav_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ɓa apndohha Hamor na Sisem, ɓa naaffa Dinaa, ɓa cootta na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Weɗi kuɓuucaŋ Yaŋhooɓa ɓinooɓa rokoh in ca nikee ŋ fiɗaaf ca, ɓa ɓayya ina nikee raak-raak ŋ kur ka jen sagu njoofa taambɗoh ɓa Dinaa ɓeku. ");
INSERT INTO sav_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ɓa ɓayya ɗoopaat caŋ ɓa na in ca nikee ŋ ɗooƴ kur ka na yohon ca jen. ");
INSERT INTO sav_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ɓa ɓayndohha raak-raakaŋ ɓa jen na komaakca ƴin ca na ɓitiɓ ca, ɓa faɗɗi ali in ŋ kahan ca. ");
INSERT INTO sav_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Wa ɓa puloh ndeem, Yaŋhooɓa woosa Simeyong na Lewi ne : « Ɗu deey, ɗu tefɗiɗ to ro', ɗu tahiɗ po ɓi Kanaan na ɓi Peris, ɓi gen kur cii, hey yo sange. Ɓa hey ambsukohe, ɓa keen ndo, ɓa apndoh ho na ɓi kahan ndo, laam ɓooɓiŋ ngo laayɗi. » ");
INSERT INTO sav_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ɓa loffa ɗe ne : « Ƴaari joyiɗ tum taambɗoh ɓoo findi toonkoh e ? » ");
INSERT INTO sav_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Wa raakka mbeh, Kooh woosa Yaŋhooɓa ne : « Kaɗa Betel, te fu nik nga ; haɓɗa seeƴkoha nga wuu so, mi yi Koohi teeɓkee ɗa nga, wa fu nupee taambɗoh fu Esaaw. » ");
INSERT INTO sav_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaŋhooɓa woosa ɓi kahan ce na ɓooɓa hunee na ɗe jen ne : « Saɓsukohaat na kooh ciŋ jaambur ci, ci nik na ɗu, ɓoktukaat te ɗu ɓekuk kulɓa wiiriis, ");
INSERT INTO sav_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ɓoo kaɗ Betel, ŋ haɓɗiɗa Kooh seeƴkoha nga. A yi hirpee so wa ŋ feyu te a ɓaatɗohha so ŋ ɗisik ci ŋ taamb jen. » ");
INSERT INTO sav_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ɓa ɓayya kooh ca nikee na ɓa jen, na long-long ca ɓa ɓekkee ŋ nof caŋ ɓa, ɓa eɗta Yaŋhooɓa ca ; a acca ca ŋ tasaŋ kidga yakka nik ŋ sero Sisem. ");
INSERT INTO sav_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ƴutta, ɓa cooteeɗa. Kooh tummba, ɓooɓaŋ kur ca wilee ɓa neƴƴohha po, ɓa kaañɗi taambiɗ kuɓuucaŋ Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaŋhooɓa na ɓooɓa hunee na ɗe kaɗta po ɓa reesa Luus, weɗ Betel, ŋ kur kaŋ Kanaan poyi. ");
INSERT INTO sav_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A haɓiɗta seeƴkoha nga, a teekka ɗiska El-Betel (Koohiŋ Betel) laam, Kooh teeɓkohee ɗe ndaam wa a nupee taambɗoh ce. ");
INSERT INTO sav_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ɓitfa meeɗee ɓapiɗ Rebeka na woyse Debora hunee na ɓa. A yaa kaanohha ndaam. Ɓa acca ɗe ŋ tasaŋ kidga yakka nik ŋ sero Betel ; ɓa teekkaa Kidgiŋ-Fuɗ-ci. ");
INSERT INTO sav_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ŋ pulohaŋ Yaŋhooɓa Paddan-Aram po a reesa Betel, Kooh teeɓkissa ɗe nga, a barke'iɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","A woosa ɗe ne : « Tiikiŋ ɗa wa Yaŋhooɓa, waaye fu ɓeeɗkissassanɗi Yaŋhooɓa, fu teeku Israayel kotii. » Kooh teekka ɗe Israayel. ");
INSERT INTO sav_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A woyissa ɗe ne : « Ñam Koohi Min. Rimaatɗoha, fu ɓaatuk laam cuuɓ angiɗ na heet laayiɗ hey pulohe nga ɗa ; ɓi buur sah hey raake nga. ");
INSERT INTO sav_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kur ki ŋ onee Ibrahiima, ŋ onndaa Isaahha, ŋ hey ɗa wa one, ŋ ona ɓi na hee rimkohe nga ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Wa a woo po ƴutta, Kooh faɗta Yaŋhooɓa ŋ ndaam, a cootta ɗafka. ");
INSERT INTO sav_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaŋhooɓa ɓayya atoh, a yippaa ŋ ɗiska. A seeƴkohhaa anaah, a yiiffa diwliin ŋ ɗafuk wa. ");
INSERT INTO sav_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A teekka ɗiska Kooh woyohee na ɗe Betel (kahan Kooh). ");
INSERT INTO sav_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wa Yaŋhooɓa na ɓooɓa hunee na ɗe puloh Betel, ɓa kaɗ kaɗ po ɓa tassa ree Efraata, raak Rasel nikee rook, a miskasseeɗa ; raakaŋ ɗe kuɓu misikka lool. ");
INSERT INTO sav_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ŋ ɗooƴ miskiɗeem, dooñoha nikee na ɗe woosa ɗe ne : « Kana neƴƴoh, fu raakis kuɓu ƴaar. » ");
INSERT INTO sav_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Waam raak Rasel kaaneeɗa, bala a nguɗan ɗah, a teekka kuɓka Benooni (kuɓkiŋ miskiɗiŋ ngo). Waaye baab ɓa teekka ɗe Benyaamin (kuɓkiŋ yaah-ñaahmi). ");
INSERT INTO sav_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rasel kurukka nga, a acuusa ŋ waas Efraata, weɗ Betlehem. ");
INSERT INTO sav_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaŋhooɓa yippa atoh inhisoha ŋ ruy-ruyaŋ ɗe ; atoh faam wa ɗaa nga po ɗiski maa woyohe na ɗu ndii. ");
INSERT INTO sav_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Wa Israayel (yi Yaŋhooɓa) puloh ndaam, a kaɗta, a yippa ɗiip caŋ ɗe ŋ finho Migdal-Eder. ");
INSERT INTO sav_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ŋ nikaŋ Israayel ndaam, Ruben faanukka na Bilha ñaama baab ɓa ɓayee ɓitiɓ ; Israayel yeggaa. Yaŋhooɓa raakeen kuɓu ƴaar ndaŋkiyaah na kanak (12). ");
INSERT INTO sav_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ɓi a raakee na Leya nikee Ruben saawiŋ ɗe, na Simeyong, na Lewi na Yudaa na Issaakar na Sabuloon. ");
INSERT INTO sav_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ɓi a raakee na Rasel nikka Yuusufa na Benyaamin. ");
INSERT INTO sav_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ɓi a raakee na Bilha, ñaamaŋ Rasel nikee Daan na Naftaali. ");
INSERT INTO sav_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ɓi a raakee na Silpa, ñaamaŋ Leya nikee Gaad na Aser. Ɓeem, ɓeɗ kuɓuuci ƴaar ci Yaŋhooɓa raakoh Paddan-Aram. ");
INSERT INTO sav_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Wa raakka mbeh, Yaŋhooɓa dokukka ɗiskaŋ baab ɓa Isaahha ŋ Mamre ŋ sero Kiriyat-Arba wa na woyse Hebron kotii. Ibrahiima nameen gen nga. ");
INSERT INTO sav_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaahha kaan wa a raak kiis teemet na kiis ndaŋkiyaah-yasna-kaahay (180). ");
INSERT INTO sav_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","A kaan ŋ finho kipes hutiɗ, a haadda Jaanim. Kuɓuuciŋ ɗe Yaŋhooɓa na Esaaw uummba ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Inii weɗ naandsuku ŋ Esaaw, yi teeku Edom, na ɓi rimkoh nga ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaaw ɓayeen ɓitiɓ ŋ cafaƴ caŋ Kanaan ; ɓeem ɓa nikee Aada na Ohlibaama. Aada nikee kuɓu Eloon ya ɓaahee ŋ cuuɓiŋ Hit ci. Ohlibaama nikee kuɓu Aana, Aana nikka kuɓu Sibeyon ya ɓaahee ŋ cuuɓiŋ Hiw ci. ");
INSERT INTO sav_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Taambɗoh Nebayot, Baasmat yi kuɓu Ismaayla namee ɓaah ŋ ɓitiɓ ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aada a yi rim Elifaas, Baasmat rimmba Rewyel, ");
INSERT INTO sav_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ohlibaama rimmba Yewus na Yalaam na Koorah. Ɓii ɓeɗ kuɓuuci ƴaar ci Esaaw raakoh Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Wa raakka mbeh, Esaaw ɓayya ɓitiɓ ciŋ ɗe na kuɓuuciŋ ɗe, ƴaar na ɓitiɓ, na ɓooɓaŋ ɗe, a ɓayndohha ɗoopaat caŋ ɗe na in ca a raakoh Kanaan jen, a yongsukka kur wiiriis, a ussa taambɗoh ce Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Raak-raakaŋ ɓa laayee laay po ɓa haɓisseeɗi ŋ kur ka sagu ɗoopaat caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaaw yi teeku Edom, kaɗoh yipa ɗaa ŋ tangoocaŋ Seyiir. ");
INSERT INTO sav_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Inii weɗ naandsuku ŋ Esaaw na ɓi rimkoh nga ɗe. A yi caaciŋ Edom ca genee ŋ tangoocaŋ Seyiir. ");
INSERT INTO sav_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tiik ciŋ kuɓuuciŋ Esaaw ƴaar ci ceɗi cii : Elifaas yi a raak na ɓitiice Aada, na Rewyel yi a raak na Baasmat. ");
INSERT INTO sav_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Kuɓuuciŋ Elifaas ƴaar ci nikka Teemaan, Omaar, Sefoo, Gataam na Kenas. ");
INSERT INTO sav_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaas raakeen ɓitiɓ ñaam na woyse Timna ; a raakeen na ɗe kuɓu teeku Amalek. Ɓeem ɓeɗ set ciŋ Aada, ɓiti Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Kuɓuuciŋ Rewyel ƴaar ci nikee Nahat, Seerah, Samaa na Misaa. Ɓeem ɓeɗ set ciŋ Baasmat, ɓiti Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kuɓuuci ƴaar ciŋ ɓiti Esaaw yi na woyse Ohlibaama, kuɓkiŋ Aana yiŋ Sibeyon, ɓeɗ Yewus, Yalaam na Koorah. ");
INSERT INTO sav_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Kilifaaciŋ ɓi rimkoh ŋ Esaaw ɓa ɗi ɓii : Ɓi rimkoh ŋ saawiŋ ɗe Elifaas nikee Teemaan, Omaar, Sefoo, Kenas, ");
INSERT INTO sav_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Koorah, Gataam na Amalek ; ɓeem ɓeɗ nikee kilifa ŋ kur kaŋ Edom ɓi rimkoh ŋ Elifaas kuɓkiŋ Aada. ");
INSERT INTO sav_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ɓi rimkoh ŋ Rewyel, kuɓu Esaaw, nikee Nahat, Seerah, Samaa na Misaa ; ɓeem ɓeɗ nikee kilifa ŋ kur kaŋ Edom ɓi rimkoh ŋ Rewyel kuɓu Baasmat, ɓiti Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ɓi rimkoh ŋ Ohlibaama nikee Yewus, Yalaam na Koorah ; ɓeem ɓeɗ kilifaaca rimkoh ŋ kuɓkiŋ Aana, Ohlibaama yi ɓiti Esaaw. ");
INSERT INTO sav_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ɓeem ɓeɗ rimkoh ŋ Esaaw, ɓa nikka kilifa ŋ Edom. ");
INSERT INTO sav_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ɓii ɓeɗ rimkoh ŋ Seyiir yi ɓaah ŋ cuuɓaŋ Hoor ca te ɓi Edom raakka ɓa geniɗ nga : Lootaan, Sobaal, Sibeyon, Aana, Disoon, Eeser na Disaan. Ɓeem ɓeɗ nikee ɓi rimkoh ŋ Seyiir, kilifaacaŋ cuuɓaŋ Hoor ca genee ngaŋ kur kaŋ Edom. ");
INSERT INTO sav_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Kuɓuuciŋ Lootaan ƴaar ci nikka Hoori na Hemaam ; taambɗoh ce ɓitiɓ teeksee Timna. ");
INSERT INTO sav_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kuɓuuciŋ Sobaal ƴaar ci nikka Alwaan, Manahat, Eebal, Sefoo na Onaam. ");
INSERT INTO sav_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kuɓuuciŋ Sibeyon ƴaar ci nikee Ayaa na Aana. Aana yeem a yi koc hot masma dohɗa balɗee ŋ kehƴi ngaŋ bilaf fa, waam raak ɗe niiɗee mbaam caŋ baab ɓa Sibeyon. ");
INSERT INTO sav_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kuɓuuciŋ Aana nikee Disoon na taambɗoh ce ɓitiɓ Ohlibaama. ");
INSERT INTO sav_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kuɓuuci ƴaar ciŋ Disoon nikee Hemdaan, Esbaan, Yitraan na Keraan. ");
INSERT INTO sav_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kuɓuuci ƴaar ciŋ Eeser nikka Bilhaan, Sawaan na Akaan. ");
INSERT INTO sav_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ɓiŋ Disaan nikka Uus na Araan. ");
INSERT INTO sav_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Kon, ɓii ɓeɗ nikee kilifaacaŋ cuuɓaŋ Hoor ca ŋ kur kaŋ Seyiir : Lootaan, Sobaal, Sibeyon, Aana, Disoon, Eeser na Disaan. ");
INSERT INTO sav_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Bala buur raakan ŋ Israayel ɗah, ɓii ɓeɗ nikee buur caŋ kur kaŋ Edom : ");
INSERT INTO sav_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela kuɓu Beyoor, a yi nikee ŋ Dinaaba. ");
INSERT INTO sav_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Wa Bela kaan, Yoobaab kuɓu Seerah, ya nikee ŋ Bosra a yi namsiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Wa Yoobaab kaan, Husaam ya ŋ kur kaŋ Teemaan-Teemaan ca, a yi namsiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Wa Husaam kaan, Hadad, ya nikee ŋ Awit, kuɓu Bedad, namsiɗta ɗe ; a yi laɓee Majaan-Majaan ca ŋ kur kaŋ Mowab. ");
INSERT INTO sav_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Wa Hadad kaan, Samla ya ŋ Masreeka namsiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Wa Samla kaan, Sawul ya ŋ Rehobot-Hanahar namsiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Wa Sawul kaan, Ba'al-Hanan kuɓkiŋ Akboor namsiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Wa Ba'al-Hanan kuɓkiŋ Akboor kaan, Hadar ya ŋ Pawu namsiɗta ɗe. Ɓitiice teeksee Mehtabeel kuɓu Matareed yi kuɓkiŋ Mesaahab. ");
INSERT INTO sav_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ɓii ɓeɗ nikee kilifaacaŋ cuuɓiŋ Edom ci puloh ŋ Esaaw, yaa nu nga ɗah, na kur kaŋ ɗa : Timna, Alwaah, Yetet, Ohlibaama, Eela, Pinoon, Kenas, Teemaan, Mibsaar, Magdiyel na Iraam. ");
INSERT INTO sav_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ŋ ini kaɗ ŋ Yaŋhooɓa, a nikee ŋ Kanaan ŋ kur ka baab ɓa genohaahe. ");
INSERT INTO sav_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Inii weɗ naandsuku ŋ Yaŋhooɓa na kahan ce. Wa kuɓkiŋ ɗe Yuusufa raak kiis ndaŋkiyaah na kiis yasna-kanak (17), a meeɗee hun na taambɗoh ciŋ ɗe, ɓa niiɗee mbaal ca na pe' caŋ baab ɓa. A nikee komaaki, a meeɗta hun na kuɓuuciŋ Bilha na ɓiŋ Silpa, ɓitiɓ ciŋ baab ɓa. Taambɗoh ciŋ ɗe tummba in moɗaaɗi ɗah, a woo baab ɓa wa. ");
INSERT INTO sav_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israayel raakee ɗe ŋ kiyaɓkookaŋ ɗe, tahha po a yi a uupee waaɗ ŋ kuɓuuciŋ ɗe jen. A haɓɗiɗta ɗe kulɓa moɗoh na moɗoh. ");
INSERT INTO sav_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Taambɗoh ciŋ ɗe hotta ne baab ɓa uupee ɗe waaɗ, weɗi tahee ɓa sang ɗe po, ɓa mineeɗi woo na ɗe sah, woo moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Wa kaɗeeɗa po, Yuusufa heeƴca, a naandsukka taambɗoh ciŋ ɗe wa, ɓa uuppa ɗe nga sang. ");
INSERT INTO sav_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A woo ɓa ne : « Sikɗukaat ini ŋ heeƴ. ");
INSERT INTO sav_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","An ɓoo nikee ŋ yohon ca, ɓoo tokeeɗa bele, ɗekka po ɗufiŋ ngo tufukka, ciŋ ɗu willaa, ca ƴekɗeeɗaa. » ");
INSERT INTO sav_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Taambɗoh ciŋ ɗe woosa ɗe ne : « Fu waaɗ woo ne a fu na hee nike buuriŋ ɓoo e ? Fu yilif ɓoo e ? » Tahha po ɓa uuppa ɗe sang, sagu heeƴ caŋ ɗe na in ca a woyee nga. ");
INSERT INTO sav_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Wa Yuusufa heeƴis, a naandsukissaa taambɗoh ciŋ ɗe an : « Hee ! Ŋ heeƴissiɗ nohi na caɓni na hor ndaŋkiyaah na yino ƴekɗeeɗa so. » ");
INSERT INTO sav_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A nammbaa naandsuk baab ɓa, yeem ngassa ɗe an : « Fu heeƴ ye weem ? Fu liiɓiɗ ne mi na yaay ɗu na taambɗoh ciŋ ɗa, ɓoo hey ɗa ƴekɗe e ? » ");
INSERT INTO sav_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Taambɗoh ciŋ Yuusufa ayrukka ɗe, Yaŋhooɓa ɗaakohha heeƴ ceem nof. ");
INSERT INTO sav_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wa raakeen jamano, taambɗoh ciŋ Yuusufa kaɗta mangaana na gataŋ baab ɓa ŋ ɓak kur ka na woyse Sisem. ");
INSERT INTO sav_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Mbeh, Israayel woosa kuɓkiŋ ɗe Yuusufa ne : « Haya ŋ woos ɗa, fu marka taambɗoh ciŋ ɗa ŋ Sisem, ndah ɓa ɗaa ŋ jam na ɗoopaat ca. In nu raak nga ɗah, fu woo so. » Yuusufa woosa ɗe ne : « Ee. » A tuuƴca Yuusufa, yeem pulohha Oonaŋ-Hebron, a rappa ŋ ɓak Sisem. ");
INSERT INTO sav_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ƴaar cohha na ɗe wiltiɗoheeɗa ŋ bilaf fa, a meekissa ɗe ne : « Fu na waake ye ? » ");
INSERT INTO sav_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yuusufa woosa ɗe ne : « Mi na marke taambɗoh ciŋ ngo, fu miniɗ to woo ɗiski ɓa na niiɗohe e ? » ");
INSERT INTO sav_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ƴaara loffa ɗe ne : « Ɓa kurkiɗ ndii, ŋ kerhiɗ ɓa woyeeɗa ne ɓaa kee Dotan. » Yuusufa kaɗta ɓa raaka ŋ Dotan. ");
INSERT INTO sav_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wa taambɗoh ciŋ ɗe ƴok ɗe hayeeɗa, bala a reyan nga ɓa ɗah, ɓa waakohha ɗe ap. ");
INSERT INTO sav_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ɓa woytiɗohha ŋ harmban ɓa ne : « Heɗ heeƴ ci a yoon na haye. ");
INSERT INTO sav_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ɓoo apaat ɗe, ɓoo ɓek ɗe ŋ ngurtut. Hey ɗah, ɓoo woo ne a ɗoopaat saahiɗ ap ɗe ; ɓoo marak findi heeƴ ciŋ ɗe na hee mirndohe. » ");
INSERT INTO sav_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Wa Ruben kerah ineem, a waaɗta muciɗ Yuusufa, a woosa ɓa ne : « Ɓoo kanaat ɗe ap. » ");
INSERT INTO sav_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","A degga nga ne : « Kanaat aam ñif, ɓekaat ɗe ŋ ngurtuta ŋ bilaf fa ween, yaah ciŋ ɓoo degkuu ɗe. » A woosa ɓa ineem ne a min ɗe muciɗ po a wik ɗe baab ɓa. ");
INSERT INTO sav_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wa Yuusufa ree, ɓa ammba ɗe, ɓa wolissa kulɓaakaŋ ɗe moɗohngaana, ");
INSERT INTO sav_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ɓa njaffa ɗe ŋ ɗooƴ ngurtuta. ");
INSERT INTO sav_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ƴutta ɓa ɓooffa ne ɓa ñam. Ɗekka po ɓa hotta Ismaayla-Ismaaylaaca huniɗ, pulohiɗ Galaad na ngeelemb caŋ ɓa sifiɗ ɓi toon findi cuuraay, daakaande na diw faan, ɓa kaɗeeɗa Misra. ");
INSERT INTO sav_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yudaa woosa taambɗoh ciŋ ɗe ne : « Wa raakiɗ ɓoo winde etoh, ɓoo ap taambɗoh ɓoo po ƴut, ɓoo ɗasɗohee wa ? ");
INSERT INTO sav_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ismaayla-Ismaaylaaca ɓeɗɗeen na haye, ɓoo toonaat ɓa ɗe, ɓoo apuu ɗe laam, e ɓoo ɓaah ñif, a taambɗoh ɓoo. » Ɓa hunnda nga. ");
INSERT INTO sav_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wa toonoh ca ree, tel ɓa puloh kur ka na woyse Majaan, ɓa puliɗta Yuusufa ŋ ngurtuta, ɓa toonohha ɓa ɗe ƴel haalis ndaŋkiyaah-kanak (20) ; Ismaayla-Ismaaylaaca cootta na ɗe Misra. ");
INSERT INTO sav_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wa Ruben wiiruk ngurtuta, a hotta ne Yuusufa nikisɗi nga, keeñaŋ ɗe reehha, a faarra kulɓaacaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A kaɗta ŋ taambɗoh ciŋ ɗe, a woosa ɓa ne : « Cooy, Yuusufa nikisɗi ndaam ! Ŋ tuman na ? » ");
INSERT INTO sav_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ɓa hoossa suket, ɓa tahha'iɗta kulɓaakaŋ Yuusufa na ñif ma. ");
INSERT INTO sav_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ƴutta ɓa kommba baab ɓa wa, ɓa woosa ɗe ne : « Inii, ɓoo paraha parah, wa kulɓaakiŋ kuɓkiŋ ɗa haa e ? » ");
INSERT INTO sav_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yaŋhooɓa inhissaa, a woosa ne : « Marka ! A ɗoopaat saahiɗ sifiñsoh ɗe, cooy, Yuusufa sifiñsohuuɗ ! » ");
INSERT INTO sav_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Wa Yaŋhooɓa inhis kulɓaaka, weɗi a faaroh kulɓaacaŋ ɗe, a ɓekukka daah, a ruyiɗta kuɓkiŋ ɗe neeh laayiɗ. ");
INSERT INTO sav_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kuɓuuciŋ ɗe jen, ƴaar na ɓitiɓ giifɗeeɗa ɗe, waaye a sannga, a woosa ne : « Ŋ nikan ŋ ruy po mbaɗna maa hee ɗe raake ŋ Jaanim. » A taalndiɗta, a fuɗeeɗa kuɓkiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ŋ ini kaɗ ŋ Majaan-Majaan ca ɓayee Yuusufa Misra, ɓa toon ɗe Potifaar, ƴaara adgohee dag caŋ Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ŋ jamanoonaam, Yudaa faɗta taambɗoh ciŋ ɗe, a kaɗta nika na Hiraa, ya gen kur ka na woyse Adulaam. ");
INSERT INTO sav_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","A hotta cafaƴ nga, kuɓu Suwa ya genee Kanaan, a ɓayya ɗe ɓitiɓ, a hunnda na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Yeem ammba rook, a raakka kuɓu ƴaar, Yudaa teekka ɗe Eer. ");
INSERT INTO sav_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ɓitɓa ambissa rook, a raakissa kuɓu ƴaar, a teekka ɗe Onaan. ");
INSERT INTO sav_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A raakissa kuɓu ƴaar, a teekka ɗe Seela. Wa Seela na raakse, raak Yudaa ŋ Kesiib. ");
INSERT INTO sav_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Wa saawiŋ ɗe Eer kaɗ po reesa ɗaak ɓitiɓ, Yudaa kilookiɗta ɗe cafƴa na woyse Tamaar ; ");
INSERT INTO sav_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nikiɗi hotta ne Eer yi saawiŋ Yudaa yurahɗi, a appa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yudaa woosa Onaan taambɗoh Eer ne : « Fu inhiɗ ini fu joy haɓiɗ, lama ɓitɓii, fu waakiɗ yakak fu kuɓu. » ");
INSERT INTO sav_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onaan inheen ne kuɓki a na hee raake na ɓiti taambɗoh ce, a nikanɗi yiŋ ɗe ; weɗ tah a hunnda na ɗe poo, a heesa keenɗe ɗah, a keeniɗ ŋ bilaf fi ne a sang raakiɗ taambɗoh ce kuɓu. ");
INSERT INTO sav_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nikiɗi neɓaaɗi'uusa ŋ ini Onaan na tume weem, a nammba ɗe ap. ");
INSERT INTO sav_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yudaa woosa payum ce Tamaar ne : « Haada kahan baab ɗu, fu muurka ƴaar fu nga. Fu ɓoof nga po Seela kuɓkiŋ ngo yak. » A neƴƴohee ne Seela nam kaan findi yakak ciŋ ɗe. Tamaar haadda kahan baab ɓa. ");
INSERT INTO sav_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Wa tummba in maañiɗ, ɓiti Yudaa kaannda, kuɓkiŋ Suwa. Wa ruya coot Yudaa hunnda na nawleece Hiraa, ƴaaraŋ Adulaam ca, a kaɗta marka ɓooɓa nguɗɗee ɗe find caŋ mbaal caŋ ɗe ŋ Timnaa. ");
INSERT INTO sav_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamaar woyuusa ne : « Payum fu yaa kaɗ hufɗuka find caŋ mbaal caŋ ɗe ŋ Timnaa. » ");
INSERT INTO sav_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A inheen ne Seela yakiɗ, te a tokɗuuɗi ɗe, tahha po a ɓekukka kulɓa wiiriis kotii, a muurukka findi toonkoh, a kaɗta, a ɓooffa ŋ waas Timnaa ne fu aasee Enayim ɗah. ");
INSERT INTO sav_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Wa Yudaa hot ɗe, a liiɓpa ne a toonkoh laam a muurkee muuruk. ");
INSERT INTO sav_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A reɓpa nga ɗe, a woosa ɗe ne a waaɗ hun na ɗe. Raak ɗe inhisɗi payum ce. Tamaar loffa ɗe ne : « Fu na hee so ye eɗe ŋ ineem ? » ");
INSERT INTO sav_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A woosa ɗe ne : « Ŋ hey ɓaye koteng ŋ gataŋ ngo, ŋ woosoh ɗe nga ɗa. » A loffa ɗe ne : « Ee. Waaye fu na hee wa tayle'ohe ye ? » ");
INSERT INTO sav_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yudaa loffa ɗe ne : « Fu waaɗ ne ŋ tayle'oha ye ? » Tamaar woosa ɗe ne « Eɗ to jaarndi inhisohaaniŋ ɗa fu tokuk ŋ mbooh na ndooɗiŋ yaah fu. » Yudaa eɗta ɗe ca, a hunnda na ɗe, yeem taambohha nga, ammba rook. ");
INSERT INTO sav_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A haadda, a nihissa muura, a ɓekkissa kulɓaaca a muurkohe. ");
INSERT INTO sav_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ŋ ini kaɗ ŋ Yudaa, a woos nawleece ƴaaraŋ Adulaam ca ne a kaɗ ɗe wikɗa koteng ka, a haytoh in ca tayle'ohse. Yeem reesa, a hotɗi ɓitɓa. ");
INSERT INTO sav_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A meekissa ɓooɓa genee Enayim ne : « A nde toonkohi na nike ŋ waasi ? » Ɓa loffa ɗe ne : « Toonkoh moosɗi raakoh ndii. » ");
INSERT INTO sav_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A dokukka ŋ Yudaa, a woosa ɗe ne : « Ŋ kaɗiɗ po nga, ŋ hotɗi ɗe te ɓi kur ka woo ne, toonkoh moosɗi raakoh ŋ ndaam. » ");
INSERT INTO sav_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yudaa loffa ne : « A tasaat na in caam, ɓoo kanaat ƴenɗuk haf ɓoo, ŋ woosiɗ ɗa, fu kaɗiɗ na koteng ki po ndaam, fu hotɗi ɗe. » ");
INSERT INTO sav_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Wa deg caɓin kaahay, Yudaa woyuusa ne : « Payum fu Tamaar deey, a toonkee toonuk po, a waliɗ amb rook nga. » Yudaa woosa ne : « A pulɗassaat, a dohu kaanaaɗi. » ");
INSERT INTO sav_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wa Tamaar ɓayse, a woosohha ŋ payum ce Yudaa ne a markaat baahiɗ jaarndi inhisohaani hun na niyiŋ wa, na ndooɗi, andi a hey inhise ɓoyi raak ca ? Laam heɗ ca a yi rookiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yudaa inhissa ca, a woosa ne : « A yi uup po nik ŋ keeh laam, ñam joyee ɗe on kuɓkiŋ ngo Seela, waaye ŋ tumɗaa. » Ŋ ineem a faankisɗi na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wa noha Tamaar joyee ɓasloh ree, wa nikka ne a hee siise. ");
INSERT INTO sav_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A ɓasleeɗa, yino ŋ siis ca puliɗta yaah, dooñoha ammbaa, a tokkaa ooy ruumind ; a woosa ne : « Yii, a yi adug raaku. » ");
INSERT INTO sav_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Waaye kuɓka dokinnda yaahaŋ ɗe, taambɗoh ce kocca ɗe pul. Dooñoha woosa ɗe ne : « Waaw, fu mbolit nde ? » Ɓa teekka ɗe Peeres (mbolit). ");
INSERT INTO sav_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ƴutta, taambɗoh ce hannda raaku na ooya ruumnda ŋ yaahaŋ ɗe, ɓa teekka ɗe Seerah. ");
INSERT INTO sav_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ŋ ini kaɗ ŋ Yuusufa, wa Ismaayla-Ismaaylaaca ree na Yuusufa Misra, ɓa toon ɗe Potifaar ; a yi daga adgohee ƴaaɓa niiɗe kahan Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nikiɗi huneen na Yuusufa te in nu a haɓɗeen ɗah, wa baah ; a nikka ŋ kahan kilifaanaŋ ɗe Potifaar. ");
INSERT INTO sav_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kilifaanaŋ ɗe hotta ne Nikiɗi huniɗ na Yuusufa te in nu a haɓiɗ ɗah, Nikiɗi baahiɗa. ");
INSERT INTO sav_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Kilifaanaŋ ɗe baahohha ɗe, a degga ɗe ŋ serooce, Yuusufa adgohha kahan ce na raak-raakaŋ ɗe jen. ");
INSERT INTO sav_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wa Potifaar haɓiɗ ineem, Nikiɗi barke'iɗta kahan ce, in ca nikee nga na ca ŋ yohon caŋ ɗe jen, sagu Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Wa tahha po Potifaar faɗta in caŋ kahan ce jen ŋ yaah Yuusufa ; a taambkohisseeɗi ali in, nikɗi kañam kaŋ ɗe ɗah. Yuusufa nikee moɗoh fiir. ");
INSERT INTO sav_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kaɗta po, ɓiti kilifaanaŋ ɗe hememmba ɗe, a woosa ɗe ne : « Haya fu faanuk na so ! » ");
INSERT INTO sav_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yuusufa sannga, a woosa ɗe ne : « Fu hot nga, kilifaaniŋ ngo oolkiɗ to po a haɓɗisɗi tus ŋ kahni, a faɗiɗ in ciŋ ɗe jen ŋ yaah ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A mi na ɗe hend ŋ kahni ; a sangiɗɗi so tus nikɗi fu ɗah, laam fu ɓitiice ; mbaa ŋ min na tumoh ini moɗaaɗiineem, ŋ tooñ Kooh ? » ");
INSERT INTO sav_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","A gennda gen ñaakiɗ Yuusufa na ineem, waaye tahɗi po a teyɗukka faanuk na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wa raakka mbeh, Yuusufa aassa ŋ kahna ne a panguk, raak surgaaca nikeeɗi ŋ ɗiska ; ");
INSERT INTO sav_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ɓiti Potifaar ammba ɗe ŋ kulɓa, a woosa ɗe ne : « Haya ɓoo faanuk ! » Yuusufa nookukka, kulɓaaka tassa ŋ yaah caŋ ɗe ; Yuusufa saandohha ŋ hara. ");
INSERT INTO sav_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ɓitɓa inahha ne Yuusufa saandohiɗ te a faɗiɗ ɗe na kulɓaaka ŋ yaah caŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a ɓeeɗukka surgaaca, a woosa ɓa ne : « Markaat ! Ɓoo komu kuɓu Heber ne a ɓasɗuk ɓoo ; a hayiɗ nga so ne a faanuk na so waaye ŋ leehukka ŋ ɗafka. ");
INSERT INTO sav_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Wi ŋ leehuk, a saandohha, a faɗta kulɓaakiŋ ɗe ndii. » ");
INSERT INTO sav_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A ɗaakka kulɓaakaŋ Yuusufa, a sekeeɗa hayiŋ ƴaar ce. ");
INSERT INTO sav_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Wa ƴaar ce hay, a naandsukohha ɗe wa ɗaa, a woosa ɗe ne : « Ñaami Heberi fu ɓayiɗ ɓoo, a hayiɗ nga so ne a kelsukoh ho, ");
INSERT INTO sav_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ŋ leehukka ŋ ɗafka, a saandohha, a faɗta kulɓaakiŋ ɗe ndii. » ");
INSERT INTO sav_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wa Potifaar kerah ina ɓitiice naandsuk ɗe ne weɗ Yuusufa haɓiɗ, a ayrukka. ");
INSERT INTO sav_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","A ambɗukka Yuusufa ne a taƴ ɗe ŋ kasoona ɓi kahan Firawnaana na ɗaakohse. Yuusufa nikka nga. ");
INSERT INTO sav_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nikiɗi huneen na Yuusufa, a tummba po ƴaara adgohee kasoona baahohha ɗe. ");
INSERT INTO sav_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ƴaara faɗta ɓooɓa ambsee jen ŋ yaah Yuusufa, a adgohha pangkaŋ ɓa jen. ");
INSERT INTO sav_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ƴaara haɓɗisɗi ali in ŋ ina a nakee ɗe laam, a hoteen ne Nikiɗi huneen na Yuusufa te in nu a haɓiɗ ɗah, Nikiɗi baahiɗa. ");
INSERT INTO sav_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Weɗ kaɗoh po wa raakka mbeh, dag kanak, toonnja buuraŋ Misra. Ɓa nikee ƴaara adgohee ɓooɓa meeɗ taambkoh anaah caŋ ɗe, na ya adgohee utoh mbuuruuca. ");
INSERT INTO sav_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","A ayrukka ɓa lool. ");
INSERT INTO sav_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A ɗaakɗukka ɓa ŋ kasoonaŋ daga adgohee ƴaaɓa niiɗee kahan ce, ŋ ɗiska Yuusufa taƴu. ");
INSERT INTO sav_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ƴaara degga ɓa ŋ yaah Yuusufa, a taambkoheeɗa ɓa. Ɓa nikka nga po, ");
INSERT INTO sav_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","wa raakka wek, ɓa kanak, ɓa heeƴca ; heeƴ nu nga ɗah, raakka ini wa tokis. ");
INSERT INTO sav_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wa Kooh wiis na ɓaaɓa, Yuusufa kaɗta ɓa marka, a raakka ɓa feyuuɗ. ");
INSERT INTO sav_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A woosa ɓa ne : « Ɗu soos ye an woti ? » ");
INSERT INTO sav_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ɓa woosa ɗe ne : « Ɓoo heeƴ heeƴ yaa nu nga ɗah, te ɓoo raakɗi ɓoyi joy ɓoo ca toksiɗ ŋ ndii. » Yuusufa woosa ɓa ne : « Hanaa a Kooh na tokse heeƴ haa ? Naandsukaat to ca ŋ hot. » ");
INSERT INTO sav_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Weɗi ƴaara adgohee ɓooɓa meeɗ taambkoh anaah caŋ Firawnaana naandsukoh waŋ ɗe an : « Ŋ heeƴ tas kidig reseñ ŋ fikiiso, ");
INSERT INTO sav_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","wa raakka naak kaahay ; wa kifissa, wa possa, wa rimmba, ca ruunnda ŋ ɗiski ɗiski. ");
INSERT INTO sav_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Raak ko na kaasiŋ Firawnaani ŋ yaah, ŋ ɓeennda ŋ rim ci, ŋ pooƴca masmiŋ ca ŋ kaasi, ŋ eɗta ɗe wa ŋ yaah. » ");
INSERT INTO sav_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yuusufa woosa ɗe ne : « Heeƴi tokis inii : Naak ci kaahay ci, ca neeh kaahay. ");
INSERT INTO sav_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ndii na neeh kaahay, Firawnaani hey ɗa rapɗe po ɗiskaŋ ɗe, ƴut ɗa, a dokin ɗa ŋ pangkiŋ ɗa. Fu eɗissee ɗe kaasiŋ ɗe findi fu meeɗ tumoh. ");
INSERT INTO sav_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Waaye, in ciŋ ɗa baah ɗah, kanaa so alkoh. Amboh ho, fu woo Firawnaani ini kaɗ nga so ne fu puliɗ to ŋ kasoonii. ");
INSERT INTO sav_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ŋ uupu hatil ŋ kur kaŋ Heber ca, ŋ ɓayuusa kur kii. Te ndii, ŋ namɗi tum ini joy yo tah taƴu. » ");
INSERT INTO sav_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wa ƴaara adgohee utoh mbuuruuca hot ne toksaŋ Yuusufa na heeƴa neɓiɗ, a nammba woo ne : « Na so, ŋ heeƴiŋ ngo, ŋ raan waah kaahay tumiɗ mbuuru. ");
INSERT INTO sav_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Wi nikee ŋ ɗafki riifee na mbuuru nu nik ne Firawnaani na haɓɗiɗasse wa ɗah, waaye sel ci ñameeɗa ca ŋ waahi, ŋ hafiŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yuusufa woosa ɗe ne : « Heeƴi tokis inii : Waah ci kaahay ci, ca neeh kaahay. ");
INSERT INTO sav_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ndii na neeh kaahay, Firawnaani hey ɗa rapɗe po ɗiskaŋ ɗe, ƴut ɗah, a ap ɗa, a keɗ ɗa ŋ kidig, sel ci ñamee ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wa degga neeh kaahay Firawnaana yakɗeeɗa noha a rimohu, a haɓɗiɗta dag caŋ ɗe kañam neɓiɗ. A rapiɗta ƴaaɓa kanak ca taƴsee ŋ kasoona po ŋ ɗiskaŋ ɗe, dag ca hoteeɗa nga. ");
INSERT INTO sav_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A dokinnda ya adgohee taambkohoh anaah ca ŋ ɗiska a nikee ne a eɗissee ɗe kaasiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","A appa ƴaara adgohee utoh mbuuruuca, a keɗta ɗe ŋ kidig ; wa taamboh ɗaa, ina Yuusufa woyee raakka. ");
INSERT INTO sav_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Waaye ƴaara adgohee ɓooɓa meeɗ taambkoh anaah caŋ Firawnaana, alkohha Yuusufa jameet. ");
INSERT INTO sav_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wa degga kiis kanak, Firawnaana, buuraŋ Misra heeƴca. Ŋ heeƴiŋ ɗe, an a nikee ŋ sero kala na woyse Niil. ");
INSERT INTO sav_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A hotta inoh moɗiɗ yasna-kanak, kapiɗ, pulohha nga, ca ñameeɗa ŋ paangfa ŋ sereenda. ");
INSERT INTO sav_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A hotissa ŋak moɗaaɗi'iɗ yasna-kanak nammba puloh ŋ kala, ca nikka na ca. ");
INSERT INTO sav_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ŋak ca ñammba inoh ca kapiɗ ca. Ndeem, Firawnaana yunukka. ");
INSERT INTO sav_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A neehissa, a heeƴissa mbong yasna-kanak moɗiɗ, ɓiɗsiɗ ŋ mbaang yino. ");
INSERT INTO sav_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Furus yasna-kanak ca fu inah ne a mbooyooni oñiɗ ca, ɓiɗissa ŋ serooca ; ");
INSERT INTO sav_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","furus ca onnda mbong ca yasna-kanak ca moɗiɗ ca. Firawnaana yunukka, a inahha ne a heeƴ heeƴ. ");
INSERT INTO sav_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wa Kooh wiis na ɓaaɓa, Firawnaana feyuusa, a cohɗohha naah ca na riifiɗ haf caŋ Misra jen, a naandsukka ɓa heeƴ caŋ ɗe, waaye ali ɓo' nga ɓa minɗi ɗe ca toksiɗ. ");
INSERT INTO sav_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ƴaara adgohee ɓa meeɗ taambkoh anaah caŋ Firawnaana woosa ɗe ne : « Mi deey, ŋ hey naandsohe tooñiŋ ngo woti. ");
INSERT INTO sav_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Firawna ayrukeen mi na ƴaara adgohee utoh mbuuruuci po a rannga ɓoo ŋ kasooniŋ dagi adgoh ɓi na niiɗe kahan ce. ");
INSERT INTO sav_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ɓoo heeƴandoosa, te heeƴ nu nga ɗah raakeen ini wa tokis. ");
INSERT INTO sav_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Komaaki fiir Heber nikeen na ɓoo ŋ ɗooƴ kasoona, a ñaamiŋ dagi adgoh ɓi na niiɗe kahan buur. Ɓoo naandsukka ɗe yaa nu nga ɗah ini fu heeƴ, a yi toksiɗ ɓoo ca mbaɗi. ");
INSERT INTO sav_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Te findi a toksoh ca, ca raakoh ɗaa ; ŋ doknuusa ŋ pangkiŋ ngo, ƴaara tas keɗuusa ŋ kidig. » ");
INSERT INTO sav_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Firawnaana woosa ne ɓa kaɗaat ɓa haya na ɗe. Ɓa arra kaɗ ŋ kasoona, ɓa puliɗta ɗe, a nenukka, a ɓekukka kulɓa wiiriis, ɓa ɓayya ɗe ŋ Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firawnaana woosa Yuusufa ne : « Ŋ heeƴ heeƴ, te ali ɓo' minɗi wa tokis, waaye ŋ kerah ne fu miniɗ tokis heeƴ nu fu naandsuku ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yuusufa woosa ɗe ne : « A ñam haa, waaye a Kooh na hee eɗohe toksi na hee ɗa doye. » ");
INSERT INTO sav_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firawnaana woosa Yuusufa ne : « Ŋ heeƴiŋ ngo, ŋ nikee ŋ sero Niil, ");
INSERT INTO sav_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ŋ hotta inoh moɗiɗ yasna-kanak, kapiɗ, pulohha nga, ca ñameeɗa ŋ paangfa ŋ sereenda. ");
INSERT INTO sav_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ŋak yasna-kanak moɗaaɗi'oh na moɗaaɗi'oh nammba puloh nga, ŋ moosɗi hotoh mand ɗaa moɗaaɗi ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","21","Ca ñammba inoh ca koc, ceɗ ca yasna-kanak ca kapiɗ ca nikka ŋ rook ciŋ ca. Te ɓo' minɗi wa hot nga ca sagu risa ca risee ŋak ; ndeem ŋ yunukka. ");
INSERT INTO sav_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ŋ heeƴissa mbong yasna-kanak moɗiɗ, ɓiɗissa ŋ mbaang yino. ");
INSERT INTO sav_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Furus yasna-kanak moɗaaɗi, ca fu inah ne a mbooyooni oñiɗ ca, ɓiɗissa ŋ serooca. ");
INSERT INTO sav_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Furus ca onnda mbong ca yasna-kanak ca. Ŋ naandsukiɗ ca naah ci waaye ali ɓo' nga ɓa minɗi so ca toksiɗ. » ");
INSERT INTO sav_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yuusufa woosa Firawnaana ne : « Heeƴ ciŋ ɗa tokis in yino ; Kooh na teeɓee ɗa ini a na hee tume. ");
INSERT INTO sav_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Inoh ci yasna-kanak ci kapiɗ ci ca kiis yasna-kanak findi mbong ci yasna-kanak ci ; kon wa heeƴ yino. ");
INSERT INTO sav_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ŋak ci yasna-kanak ci moɗaaɗiici, ca kiis yasna-kanak findi furus ci yasna-kanak ci mbooyooni oñiɗ ; ca nikan kiis aɗ yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Weɗ ini ŋ woo ɗa rek Firawna, Kooh na teeɓee ɗa ini a na hee tume. ");
INSERT INTO sav_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kiis ci yasna-kanak ci na haye, ca na hee nike kiis laaɓɗuk ngaŋ Misra jen. ");
INSERT INTO sav_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kiis yasna-kanak hey taambe nga ca, ci fu inah ne ca na hee nike kiis aɗ, ca hey tahe po kiis ciŋ laaɓɗi alu te ca hey yahrohe kur ki. ");
INSERT INTO sav_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ca hey miske lool, po ɓooɓi alkoh ne kur ki laaɓɗeen. ");
INSERT INTO sav_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ini tah fu heeƴca ca waas kanak Firawna, weɗ ne Kooh tufkiɗ ne ca hey raake, te a hey ca raakɗe findi wa uup gaawoh. ");
INSERT INTO sav_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ɗiski wa nik ndii Firawna, waaka ɓo' ñaañiɗ, heɗ liiɓohaaɗ moɗiɗ, yi fu na hee tufkiɗe, a adgoh kur ki. ");
INSERT INTO sav_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Fu nam waak ɓi kilifa ɓi fu inah ne, ɓa hey ɓaye ŋ in ci na hee nguɗse ŋ kur ki, yatuus nu nik ɗah, yinooriŋ wa, ŋ kiis ciŋ laaɓɗi jen. ");
INSERT INTO sav_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ŋ kiis ciŋ laaɓɗi na haye, ɓa nangɗoh pesoha ŋ kur ci yakak ci, fu deg ca yaah. ");
INSERT INTO sav_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Misra hey ɗaakke po kiis ci yasna-kanak ciŋ aɗi hay ɗah, ca telan ɓi kur ki raakiɗ pesoha po ɓa muc ŋ aɗi. » ");
INSERT INTO sav_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Wa Yuusufa woo po a ƴutta, Firawnaana na dag caŋ ɗe jen hunnda ŋ woo kaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firawnaana woosa ɓa ne : « Ƴaari Fuuɗsiŋ Kooh nik ŋ ɗooƴ ce yii, andi ɓoo minisiɗ raak mand na ɗe ? » ");
INSERT INTO sav_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A woosa Yuusufa ne : « Nik ne Kooh teeɓiɗ ɗa in cii jen ɗah, ali ɓo' minɗi mand na ɗa ; fu ñaañiɗ, fu heɗ haf, ");
INSERT INTO sav_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","mbaa ɗah, ŋ hey ɗa adgiɗe, ɓi kur ki jen taambee ŋ woo kiŋ ɗa ; a tiikiŋ buuri ŋ nikoh dong weɗ ŋ uupohan ɗa. ");
INSERT INTO sav_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mbaa, ŋ degiɗ Misra jen ŋ yaah ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Firawnaana nihissa jaarndaŋ ɗe inhisohaana, a ɓekiɗta Yuusufa wa na kulɓa mbaseñ, a nammba ɗe tokiɗ ceen urus ŋ mbooh. ");
INSERT INTO sav_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A rapiɗta ɗe ŋ wotiira uup baah ɗal waŋ ɗe ɗah. Ɓi ɓo' adugka, ɓa weeɗa ne : « Haaƴɗukaat. » Firawnaana degoh Misra jen ɗaa ŋ yaah Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firawnaana woosa Yuusufa ne : « Ñam Firawnaani, waaye ali ɓo' tumanɗi in ŋ Misra jen, te fu hunɗi nga. » ");
INSERT INTO sav_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firawnaana feriɗta Yuusufa tiik, Safnat-Peneya ; a onnda ɗe ɓitiɓ teeku Asnat, kuɓu Potifera, ɓoyi na seeƴkiɗohe ŋ kur-taaha na woyse On. Yuusufa taambohha nga, a adgohha Misra jen. ");
INSERT INTO sav_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Wa Yuusufa na ɓayse ŋ ɗiskaŋ Firawnaana, buuraŋ Misra, tel ɗe raak kiis ndaŋkiyaah-kaahay (30). A kurkohha ŋ ndeem, ne a taambiɗ Misra jen. ");
INSERT INTO sav_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Wa kiis ca yasna-kanak caŋ laaɓɗa hay, kur ka laaɓiɗta keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yuusufa nangɗohha pesohaaca a ɓayoh ŋ kiis ca yasna-kanak caŋ laaɓɗa, a ɗaakka ca ŋ kur-taah ca ; waa nu nga ɗa, ini nguɗohu ŋ ɗisik ci wila ɗaakuusa nga. ");
INSERT INTO sav_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yuusufa nangɗohha bele po ca laayya findi merhey mi ŋ yaah-cookmi. Kaɗta po ɓa inhisɗi findi ca hend, ɓa faɗta ɓeesa. ");
INSERT INTO sav_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bala kiis caŋ aɗa hayan ɗah, Asnat kuɓu Potifera seeƴkiɗohaŋ kur ka na woyse On, raakeen kuɓu ƴaar kanak na Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A teekka saawiŋ ɗe Manasse (tah alkoh) laam a woo ne : « Kooh oniɗ to ini na hee so tahe alkoh miskiɗ ciŋ ngo po caŋ kahan baab ɓoo sah. » ");
INSERT INTO sav_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A teekka taambɗoha Efrayim (ɓasil) laam a woo ne : « Kooh tumiɗ to ɓasil ŋ kur ki ŋ torhiɗohu. » ");
INSERT INTO sav_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Wa kiis ca yasna-kanak caŋ laaɓɗa nikee ŋ Misra coot, ");
INSERT INTO sav_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","caŋ aɗa hayya findi Yuusufa woyohee wa. Kur ci jen nikka ŋ aɗ waaye pesoha raakeen ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wa aɗa ree nga ɓi kur ka, ɓa kaɗta ŋ Firawnaana, ɓa meekseeɗa ɗe ñamaah. A woosa ɓa jen ne : « Kaɗaat ŋ Yuusufa, in nu a woo ɗu ɗah, ɗu tum ineem. » ");
INSERT INTO sav_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Misra jen nikka ŋ aɗ. Yuusufa rangissa in ca ɓa ɗaakkohe, a tooneeɗa bele laam aɗa miskeen lool. ");
INSERT INTO sav_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ɓi ɓo' puloheeɗa ŋ kur ci wil Misra jen, ɓa heeɗa rome bele ŋ Yuusufa, laam, aɗa miskeen ŋ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Wa Yaŋhooɓa kerah ne Misra raakiɗ bele, a woosa kuɓuuciŋ ɗe ne : « Ɗu ɓoof ye ? ");
INSERT INTO sav_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ŋ kerhiɗ ne bele raakiɗ ŋ Misra, kaɗaat ɗu roma nga, ɓoo raak pesoha, ɓoo kaanuu ŋ aɗi. » ");
INSERT INTO sav_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Taambɗoh ndaŋkiyaah ŋ ɓaŋ Yuusufa kaɗta roma bele ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Waaye Yaŋhooɓa faɗeeɗi Benyaamin, yi ɓaah na Yuusufa yaay na baab, ne a kaɗ na ɓa, a neƴƴohee ne in rahas ɗe. ");
INSERT INTO sav_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Wa kuɓuuciŋ Israayel aasee Misra, ɓa huntiɗkohee na ɓi romoh wiiriis, laam a kur kaŋ Kanaan jen nikee ŋ aɗ. ");
INSERT INTO sav_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Waam raak a Yuusufa a yi adgohee kur ka na toonaŋ beleena. Taambɗoh ciŋ ɗe reesa nga ɗe, ɓa ƴekiɗta ɗe po puk ciŋ ɓa reesa kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wa Yuusufa hot ɓa, a inhissa ɓa, waaye a mannda na ɓoyi inahɗi ɓa, a ngassa ɓa an : « Ɗu puloh nde ? » Ɓa loffa ɗe ne : « Ɓoo puloh Kanaan, ɓoo waaɗ rom pesoha. » ");
INSERT INTO sav_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nikka ne Yuusufa inhisiɗ taambɗoh ciŋ ɗe, waaye, ɓa inhisɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","A naandsukka heeƴ ca a heeƴee ŋ ini kaɗ nga ɓa. A woosa ɓa ne : « Ɗu espiyoŋ, ɗu hay ne ɗu marak ɗiski ɗu min taamb po ɗu saah kur ki. » ");
INSERT INTO sav_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ɓa woosa ɗe ne : « Muk kilifaani, ɓoo hay ne ɓoo rom pesoha dong. ");
INSERT INTO sav_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Te ɓoo jen e ɓoo ɓaah baab yino, ɓoo ɓo' yurhiɗ kilifaani, ɓoo espiyoŋ haa. » ");
INSERT INTO sav_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yuusufa woosa ɓa ne : « Ineem keeh haa, ɗu hay ne ɗu marak ɗiski ɗu min taamb po ɗu saah kur ki. » ");
INSERT INTO sav_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ɓa loffa ɗe ne : « Kilifaani, e ɓoo jen ɓaah baab yino, ɓoo gen Kanaan ; ɓoo nikee ndaŋkiyaah na kanak (12), yinoora sooƴiɗ, ya uup ƴin yaa tassa na baabiŋ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yuusufa woosa ɓa ne : « Ini ŋ woo ɗu weɗ raak, ɗu espiyoŋ, ");
INSERT INTO sav_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","waaye ŋ hey marke ndah ɗu woo keeh ; ŋ giñiɗ ŋ Firawnaani ne ɗu heyɗi kurke ndii feeh taambɗoh ɗu yi uup ƴin hayɗi ndii ɗah. ");
INSERT INTO sav_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Woosaat ɓo' yino nga ɗu, a kaɗ ɗe ɓaya, ɓi tas nikohaah ŋ kasooni po ŋ marak ndah ɗu woo keeh ; wa nikɗi ɗah, ŋ giñiɗ ŋ Firawnaani ne ɗu espiyoŋ. » ");
INSERT INTO sav_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ƴutta, Yuusufa rannga ɓa neeh kaahay ŋ kasoona. ");
INSERT INTO sav_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ngaŋ neeha kaahayɗoh, a woosa ɓa ne : « Ɗu hun ŋ ini maa hee ɗu woye ɗah, ɗu hey muce, laam ŋ nupiɗ Kooh. ");
INSERT INTO sav_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nik ne ɗu ɓo' yurhiɗ ɗah, yino nga ɗu tasaat ŋ kasooni, ɓi tas kom ɓi kahan ɗu bele, ɓeɗ ɓa nik ŋ aɗ. ");
INSERT INTO sav_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ƴut ɗah, komaat to taambɗoh ɗu yi ƴini, ŋ hey inhe ne ɗu woo keeh, ɗu min muc ngaŋ kakaan. » Ɓa teyɗukka ineem. ");
INSERT INTO sav_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ɓa woyeeɗa ŋ harmban ɓa an : « Cey ! A ini ɓoo tum taambɗoh ɓoo weɗ hay nga ɓoo, laam, wa a nik ŋ miskiɗ, a nakeeɗa ɓoo yirmu, ɓoo hotee nga te ɓoo sikɗukɗi ɗe. Ineem weɗ tah woti, ɓoo nammba nik ŋ miskiɗ. » ");
INSERT INTO sav_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben degga nga ne : « Ŋ woyeen ɗu ne ɓoo kanaat tum njaanji in, waaye ɗu sikɗukɗi so, weɗ tah, ɓoo deguuɗ miskiɗ woti sagu kiñin kiŋ ɗe ɓoo ɓay. » ");
INSERT INTO sav_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ɓa liiɓee ne Yuusufa kerahɗi in ci ɓa woye, laam wa ɓa woyee na ɗe, a ƴaar a yi toksiɗee ɓa ; ");
INSERT INTO sav_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yuusufa eɗta ɓa finho, a usɗukka ɓa, a fuɗeeɗa. Wa Yuusufa fuɗ po ƴutta, a dokkissa woya na ɓa, a ɓayya Simeyong a tokka ɗe ŋ fikiiɓa. ");
INSERT INTO sav_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","A nakohha ne saakuucaŋ ɓa soɗu bele po ca riif, ɓa tumɗu haalis caŋ ɓa nga, ɓa nam onu ñamaah ŋ waas ; ineem tumuusa. ");
INSERT INTO sav_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ƴutta taambɗoh caŋ ɗe siffa ca ŋ mbaam caŋ ɓa, ɓa cooteeɗa. ");
INSERT INTO sav_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ɓeɗ kaɗoh kaɗoh po ɓa tufukka ŋ ɗisik ne ɓa neeh nga, raak weka aasiɗ ; yino nga ɓa rangissa saakndaŋ ɗe ne a on mbaamaŋ ɗe ñamaah, a hotta haalsa a romohee ɓekuuɗ nga, ŋ nguɓaŋ wa, a feyuusa. ");
INSERT INTO sav_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A woosa ɓinooɓa ne : « Hee ! Ŋ doknuuɗ haalsiŋ ngo, weɗi wii, ŋ ɗooƴ saakndiŋ ngo. » Ɓa tiitta po ɓa saakɗoheeɗa, ɓa woyeeɗa ŋ harmban ɓa an : « Kooh tum ɓoo ye an ? » ");
INSERT INTO sav_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wa ɓa ree Kanaan ɗiskaŋ baab ɓa, ɓa naandsukka ɗe in ca rahas ɓa jen. ");
INSERT INTO sav_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ɓa woosa ɗe ne : « Ƴaara adgoh kur ka ngasee ngas ɓoo ; a amb ne ɓoo espiyoŋ. ");
INSERT INTO sav_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ɓoo lofiɗ ɗe ne ɓoo ɓo' yurhiɗ, ɓoo espiyoŋ haa. ");
INSERT INTO sav_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","E ɓoo jen ɓaah baab yino, ɓoo nikee ndaŋkiyaah na kanak (12), yinoora sooƴiɗ, ya uup ƴin yaa tassa na baabiŋ ɓoo ŋ Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ƴaara loffa ɓoo ne a min inhoh ne ɓoo ɓo' yurhiɗ an : Ɓoo na hee faɗe ɓo' yino, a tas ndaam te ɓoo kom ɓi kahan ɓoo pesoha, ɓeɗ ɓi nik ŋ aɗ. ");
INSERT INTO sav_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ƴut ɗah, ɓoo kom ɗe taambɗoh ɓoo yi uup ƴin, ineem weɗ na hee ɗe teeɓe ne ɓoo ɓo' yurhiɗ, ɓoo espiyoŋ haa. Ŋ ineem, a faɗis taambɗoh ɓoo, te ɓoo hey mine wil ŋ kur ka. » ");
INSERT INTO sav_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wa ɓa yiif saakuucaŋ ɓa, yaa nu nga hotta nafaanaŋ haalsa fu ɓayee ŋ saakndaŋ ɗa, ɓeɗ na baab ɓa jen ɓa jaahiɗta. ");
INSERT INTO sav_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","A yi Yaŋhooɓa a woosa ɓa ne : « Ɗu ɓii reehiɗ kuɓuuciŋ ngo. Yuusufa na Simeyong sooƴiɗ, ɗu waaɗis ɓay Benyaamin, in ceem jen ŋ ɗafuk ko ! » ");
INSERT INTO sav_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben woosa ɗe ne : « Baab, degga Benyaamin ŋ yaah ciŋ ngo, ŋ hey ɗa ɗe wike, wa nikɗi ɗah, fu ap kuɓuuciŋ ngo kanak ci. » ");
INSERT INTO sav_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaŋhooɓa loffa ne : « Muk, ŋ heyɗi faɗe kuɓkiŋ ngo a kaɗ na ɗu. Yakak ce kaaniɗ, a yi dong ŋ tasiɗ, in rahas ɗe ŋ waas ɗah, ŋ kiyaɓkookiŋ ngo wii, ŋ haadan Jaanim na aay-keeñ saguuɗu. » ");
INSERT INTO sav_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aɗa uupeeɗa uup misik ŋ Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Wa ɓi kahan Yaŋhooɓa reehiɗ ñam beleeca ɓa ɓayohee Misra, a woosa kuɓuuciŋ ɗe ne : « Kaɗissaat, ɗu romɗissa ɓoo pesoha ƴissuut. » ");
INSERT INTO sav_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yudaa loffa ɗe ne : « Ƴaara adgoh kur ka gapkiɗ ɓoo ne, a kanaat hotis ɓoo ŋ fikiice ne ɓoo hunɗi na taambɗoh ɓoo ɗah. ");
INSERT INTO sav_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Fu teyɗuk ne Benyaamin hun na ɓoo ɗah, ɓoo hey ɗa kee romɗa pesoha. ");
INSERT INTO sav_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Waaye fu sang ɗah, ɓoo heyɗi kee laam, ƴaara woyeen ɓoo hooliɗ ne : “ Taambɗoh ɓoo hunɗi na ɓoo ɗah, a kanaat hotis ɓoo ŋ fikiice. ” » ");
INSERT INTO sav_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israayel woyissa ɓa ne : « Ɗu tooñiɗ to, wa ye tah ɗu woosa ƴaara ne ɗu raakiɗ taambɗoh wiiriis ? » ");
INSERT INTO sav_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ɓa loffa ɗe ne : « Ƴaara kat a yi meeksee ɓoo, a meeksisseeɗa ɓoo ŋ ini kaɗ nga ɓoo na ɓi kahni an : “ Ndah baabiŋ ɓoo ris pes ? ” - “ Ndah ɓoo raakiɗ taambɗoh wiiriis ? ” Ɓoo loffa ɗe ŋ in ceem, ɓoo moosɗi liiɓoh ne a hey ɓoo woye ne ɓoo komaat ɗe taambɗoh ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yudaa degga nga ne : « Baab faɗa Benyaamin ŋ yaah ciŋ ngo, ɓoo kaɗ, ɓoo min pes, ɓoo na ɗa na kuɓuuciŋ ɓoo, ɓoo kaanuu. ");
INSERT INTO sav_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ñam deguka, fu na hee so ɗe meekse ; ŋ komɗi ɗa ɗe ɗah, ineem taambɗaat to ŋ kipes kiŋ ngo jen. ");
INSERT INTO sav_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ɓoo kaɗee kaɗ ɗah, wii hee raake ɓoo tumiɗ kot kanak. » ");
INSERT INTO sav_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Weɗi Israayel woyoh ɓa ne : « Nik ne wa ɗaa ɗah, tumaat an : Ɓayndohaat ŋ in ciŋ kur ki baahiɗ ci findi diw faan na kuum na cuuraay na daakaande na ɓi saal, pistas na amand ; ɗu tum ca ŋ saakuuciŋ ɗu, ɗu kom ƴaara ca taambil. ");
INSERT INTO sav_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Te ɗu ɓayndoh haalsi ɗu raak ŋ ɗooƴ saakuuciŋ ɗu ; wa miniɗ nik ne ɓa ɗaarkohee ɗaarkoh, ɗu nam ɓay haalis wiiriis romoha. ");
INSERT INTO sav_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ɓayaat taambɗoh ɗu te ɗu kaɗ ɗiskaŋ ƴaara. ");
INSERT INTO sav_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Koohi Min ambohaat ɗu po ɗu misik ƴaara, a faɗis taambɗoh ɗu Simeyong na Benyaamin ɓa hayis na ɗu. Ŋ ini kaɗ nga so, nik ne maa hee hey ñake kuɓu ɗah, ŋ ñak rek. » ");
INSERT INTO sav_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ƴaaɓa kooɗukka, ɓa ɓayya taambil ca, ɓa ɓayndohha haalis wiiriis degga ŋ wa ɓa kocee ɓay, ɓa hunnda na Benyaamin, ɓa raakka Yuusufa ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wa Yuusufa hot ɓa huniɗ na Benyaamin, a woosa ƴaara adgoh kahan ce ne : « Ɓaya ƴaaɓii kahna, fu ap ɗoopaat, fu haɓiɗ kañam, ɓaa hee ñaktuke na so woti. » ");
INSERT INTO sav_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ƴaara tummba ina Yuusufa woo ɗe, a ɓayya ƴaaɓa kahna. ");
INSERT INTO sav_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ɓa feyuusa ŋ ɓaya ɓa na ɓayse kahan Yuusufa, ɓa woosa ne : « Kaɗ wii ɗah, haalsi ɓoo raak ŋ saakuuciŋ ɓoo ŋ hayiŋ ɓoo koc, weɗ tah ɓa ɓayee ɓoo, ne ɓa amb ɓoo, ɓa tum ɓoo ñaam ; ɓa nam naaf mbaam ciŋ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wa ɓa kaɗ po ɓa heeɗa aase, ɓa woosa ƴaara adgoh kahan Yuusufa ne : ");
INSERT INTO sav_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","« Kilifaani, ɗaasa ɓoo ƴissuut ; ɓoo kociɗ hay rome pesoha ndii. ");
INSERT INTO sav_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Wa ɓoo haadee, e ɓoo kaɗ po ŋ waas, ŋ ɗiska ɓoo tufuk ne ɓoo neeh nga, ɓoo rangissa saakuuciŋ ɓoo, ɓoo hotta haalsi ɓoo romohee, ŋ findi wa hendee ŋ ɗooƴ ca, waaye ɓoo haytohiɗa. ");
INSERT INTO sav_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Te ɓoo namiɗ ɓay kopor wiiriis romoha pesoha. Ɓoo inahɗi ɓoyi dokin koporeem ŋ saakuuciŋ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ƴaara loffa ɓa ne : « Kanaat neƴƴohaat, wa jam ; a Koohiŋ ɗu, yiŋ baab ɗu, a yi tumiɗ ɗu alaleem ŋ saakuuciŋ ɗu ; ini kaɗ ŋ haalsiŋ ɗu, ŋ rahsiɗa. » Ŋ ineem ƴaara faɗsiɗta ɓa Simeyong. ");
INSERT INTO sav_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A ɓekka ɓa ŋ kahan Yuusufa, a onnda ɓa masuɓ ne ɓa naawis kot, a nammba on mbaam caŋ ɓa kañam. ");
INSERT INTO sav_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ɓa haɓiɗta taambil ca, ɓa sekeeɗa hayiŋ Yuusufa na noha laam, ɓa yegeen ne aa hee ñaktuke na ɓa. ");
INSERT INTO sav_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wa Yuusufa haad kahan ce, ɓa eɗta ɗe taambil ca ɓa ɓaye, ɓa ƴekiɗta ɗe po puk ciŋ ɓa reesa kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yuusufa kañiɗta ɓa, a meekissa ɓa ne : « Baab ɗu ya ɗu wee so ne a yaɓko'iɗ, a tum na ? A ris pes e ? » ");
INSERT INTO sav_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ɓa woosa ɗe ne : « Ee, baabiŋ ɓoo, ñaamiŋ ɗa, yaa ŋ jam, a ris pes. » Ɓa hiirra, ɓa ƴekɗissa ɗe. ");
INSERT INTO sav_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yuusufa marakka Benyaamin taambɗoh ce, yi a ɓaah na ɗe yaay na baab, a woosa ɓa ne : « Kon ƴaarii a yi taambɗoh ɗu, yi ƴini ɗu woyee so e ? Kuɓki nee, Kooh barke'ɗaat ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wa a hot taambɗoh ce, faaniŋ Yuusufa nuppa po a minisɗi amb muhun caŋ ɗe, a arra aas ŋ tuuƴ ce ne a fuɗ nga. ");
INSERT INTO sav_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Wa a ƴut po a muktukka, a ndengɗukka, a hayissa ŋ taambɗoh ciŋ ɗe, a nakohha ne kañam ka deƴsaat. ");
INSERT INTO sav_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yuusufa deƴƴuusa kiik ce, taambɗoh ciŋ ɗe nammba deƴƴu kiik ɓa, ɓinooɓa genee Misra nammba deƴƴu kiik ɓa, laam, wa nikee in sanguuɗ nga ɓa ne ɓa ɓaah na Heber ca kañam. ");
INSERT INTO sav_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Taambɗoh ciŋ Yuusufa ɓoofɗuusa taambtiɗohiɗ ini amboh ŋ saawa po ŋ ya uup ƴin, ɓa yurhiɗkohha na ɗe ; ɓa feyuusa ɓa markoheeɗa. ");
INSERT INTO sav_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yuusufa nakohha ɓa eɗu kañam ca nikee ŋ fikiice. Benyaamin uupiɗta taambɗoh ciŋ ɗe nga waas yatuus. Ɓa ƴutta, ɓa annda biiñ po keeñ ciŋ ɓa soossa. ");
INSERT INTO sav_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Wa ɓa ƴut ŋ ñakta, Yuusufa nakka ƴaara adgohee kahan ce ne : « Tumɗa ƴaaɓii pesoha ini saakuuciŋ ɓa min ɓay, yaa nu nga ɗah, fu ɓekiɗ ɗe haalsiŋ ɗe ŋ saakndiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Te fu nam ɓekndoh kaasiŋ ngo haalsi ŋ ɗooƴ saakndiŋ ƴaari uup ƴin nga ɓa. » Ƴaara tummba ina Yuusufa nak ɗe. ");
INSERT INTO sav_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wa Kooh wiis na ɓaaɓa teel, ƴaaɓa woyuusa ne ɓa miniɗ coot ; ɓa siffa mbaam caŋ ɓa, ɓa cooteeɗa. ");
INSERT INTO sav_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ɓa pulla kur ka waaye bala ɓa usan ɗah, Yuusufa woosa ƴaara ne : « Daba ƴaaɓa, fu meekis ɓa ne : Wa ye tah ɓa tumɗuusa baahiɗ po ƴut, ɓa wirndohhaa baahaaɗi ? ");
INSERT INTO sav_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kaasi ɓa rok weɗ mi na anohe te weɗ mi na name markiskoh ; ini ɓa tum sepƴiɗ. » ");
INSERT INTO sav_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ƴaara dabba ɓa, a woosa ɓa ineem. ");
INSERT INTO sav_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ɓa loffa ɗe ne : « Kilifaani, fu na yambe ɓoo ye an ? Ɓoo tumanɗi muk in mand ɗaa. ");
INSERT INTO sav_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Fu hot nga, wa ɓoo puloh Kanaan, ɓoo haytoh haytoh haalsi ɓoo raakee ŋ saakuuciŋ ɓoo. Mbaa ɓoo min na rokoh urus wala haalis ŋ kahan kilifaaniŋ ɗa ? ");
INSERT INTO sav_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɓo' nu fu hot na kaaseem ɗah, a apsaat ; te ɓoo ɓi tas, ɓoo nik ñaam ciŋ ɗa, kilifaani. » ");
INSERT INTO sav_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A woosa ɓa ne : « Ee, ŋ teyɗukiɗ ini ɗu woo, waaye a ƴaari rok dong, a yi ŋ amban ñaam, ɓi tas hool nga. » ");
INSERT INTO sav_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ɓa arra ruhsiɗ saakuucaŋ ɓa, yaa nu nga ɗa rangissa waŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ƴaara markeeɗa, a cambohha waŋ yakkaŋ ɓa po waŋ ƴaara uup ƴin. Kaasa hotohuusa ŋ saakndaŋ Benyaamin. ");
INSERT INTO sav_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Jaarra jaar, keeñ ciŋ ɓa reehha, tahha po ɓa faarra kulɓaacaŋ ɓa. Ƴutta ɓa degissa saakuuca ŋ mbaam caŋ ɓa, ɓa dokkissa ɗiska na Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Wa Yudaa na taambɗoh ciŋ ɗe ree kahan Yuusufa, ɓa raak ɗe ris nga, ɓa raɗukka ŋ kehƴi, ŋ fikiice. ");
INSERT INTO sav_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yuusufa woosa ɓa ne : « Ɗu haɓiɗ ye wii ? Hanaa, ɗu inahɗi ne ɓo' findiiso na mine min markis ? » ");
INSERT INTO sav_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yudaa woosa ɗe ne : « Ɓoo raakɗi woyaah, kilifaani, ɓoo minɗi taasuk po ɓoo hool ŋ inii, laam a Kooh wiñ ɓoo. Ɓoo na hee hey ambsukohe jen ɓoo nik ñaam ciŋ ɗa, ɓoo na ƴaari hotu na kaasi. » ");
INSERT INTO sav_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","A woosa ɓa ne : « Muk, ŋ supkiɗ tum ineem, a ƴaari hotu na kaasi dong a yi nikan ñaamiŋ ngo ; ɓi tas haad ŋ baabiŋ ɓa moɗoɗ. » ");
INSERT INTO sav_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Weɗi Yudaa reɓoh nga ɗe, a woosa ɗe ne : « Kilifaani ɗaas so, on ndo ŋ woo na ɗa, te kanaa so ayruk, laam fu na Firawnaani, e ɗu hend. ");
INSERT INTO sav_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Wa ɓoo koc hay ndii, kilifaani, fu meekseen ɓoo ne : Ndah baabiŋ ɓoo ris pes ? Ndah ɓoo raakiɗ taambɗoh wiiriis ? ");
INSERT INTO sav_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ɓoo loffa ɗa ne, kilifaani, baabiŋ ɓoo yaa nga, a yaɓko'iɗ lool te ɓoo raakiɗ taambɗoh ƴin, yi fu inah ne, a raak ɗe ŋ kiyaɓkookiŋ ɗe. Yakak njaanjeem kaaniɗ, a yi dong a tasiɗ ŋ kuɓuuci a raak na yaayiŋ ɓa, a keeñkohiɗ ɗe lool. ");
INSERT INTO sav_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Fu woosa ɓoo ne, ɓoo ɓayɗaat ɗa njaanjeem, fu hotoot ɗe. ");
INSERT INTO sav_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ɓoo woosa ɗa ne, kilifaani : Kuɓkeem minɗi saɓsukoh na baab ɓa. A saɓsukoh na ɗe ɗah, baab ɓa hey kaane. ");
INSERT INTO sav_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Fu woosa ɓoo ne kilifaani, feeh taambɗoh ɓoo yeem hayɗi ɗah, fu waaɗisɗi hot ɓoo ŋ fikiifu. ");
INSERT INTO sav_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ɓoo kaɗta ŋ baabiŋ ɓoo, ñaamiŋ ɗa, ɓoo woosa ɗe ini fu woo. ");
INSERT INTO sav_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Wa a woyis ɓoo ne, ɓoo hayaat ɓa romɗise pesoha, ");
INSERT INTO sav_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ɓoo woosa ɗe ne, ɓoo minɗi kaɗ te ɓoo hunɗi na taambɗoh ɓoo, mbaa kilifaanaŋ kur ka teyɗukanɗi ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Baabiŋ ɓoo, ñaamiŋ ɗa, loffa ɓoo ne : “ Ɗu inhiɗ ne ŋ raak kuɓu kanak dong na yaay ɓa, ");
INSERT INTO sav_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","yinoori sooƴiɗ, ŋ amb ne, a sifiñsohuuɗ, ŋ hotisɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ɗu waaɗis ɓay yi tas ɗah, ŋ kiyaɓkookiŋ ngo wii, in rahas ɗe ɗah, ŋ hey haade Jaanim na aay-keeñ saguuɗu. ” ");
INSERT INTO sav_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ɗiski wa nik ndii kilifaani, ŋ haad ŋ baab ɓoo, te ɓoo hunɗi na njaanji a na iikohe ɗah, ");
INSERT INTO sav_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","a hey kaane ŋ kiyaɓkookiŋ ɗe, te e ɓoo ɓekan ɗe aay-keeñi ɓayan ɗe Jaanim. ");
INSERT INTO sav_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ɓaatta nga, mi, ŋ haf fo, ñam woyee ɗe ne, a ñam deguka, ne ŋ wikɗi ɗe njaanji ɗah, ahhaaneem taambɗaat to ŋ kipes kiŋ ngo jen. ");
INSERT INTO sav_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Mbaa, mi yii kiim ɗa, kilifaani, ne ŋ tas ndii, ŋ nik ñaamiŋ ɗa, te fu faɗ njaanji, a hun na taambɗoh ciŋ ɗe a haad. ");
INSERT INTO sav_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ŋ minɗi dokuk muk ŋ baab ɓoo, te ŋ hunɗi na ɗe. Ŋ minɗi maasoh muk naamooni baab na hee kooɗohe ŋ ineem. » ");
INSERT INTO sav_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Wa Yuusufa kerah woo ceem, a minisɗi amb haf ce ŋ fiki ɓooɓa nikee ŋ ɗiska. A woosa ñaam caŋ ɗe ne ɓa pulaat, a tassa nga na taambɗoh ciŋ ɗe dong, a hannda ɓa woo ne a yi Yuusufa. ");
INSERT INTO sav_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","A fuɗeeɗa ŋ ɗafka, ɓi Misra kerheeɗa ɗe po ɓi kahan Firawnaana sah inahha ini raak. ");
INSERT INTO sav_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yuusufa woosa taambɗoh ciŋ ɗe ne : « Ñam Yuusufa, ndah baab ɓoo ris pes ? » Waaye ali ɓo' minɗi ɗe lof nga ɓa sagu tiit. ");
INSERT INTO sav_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yuusufa woosa ɓa ne : « Reɓaat nga so. » Ɓa reɓpa. A woosa ɓa ne : « Ñam Yuusufa taambɗoh ɗu, ya ɗu toonee ne a haytohu Misra. ");
INSERT INTO sav_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tooni ɗu toon ndo kanaat ɗu misik laam, a Kooh tuuƴ co, ŋ adugka ɗu ndii ne ɗu min muc. ");
INSERT INTO sav_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kiis kanak ceɗɗi kur ki weɗi ŋ aɗ, te kiis yatuus ŋ fikiiri guur raakanɗi nga, nguɗ raakanɗi. ");
INSERT INTO sav_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kooh a yi tuuƴ co ndii, ŋ adugka ɗu ne ɗu min raak muc yakiɗ ne cuuɓiŋ ɗu sooƴuu. ");
INSERT INTO sav_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","E ɗu ɓay yo ndii haa, a Kooh. A yi tum mbo kilifaani uup reɓ Firawnaani, ŋ adgohha kahan ce na Misra jen. ");
INSERT INTO sav_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ɗiski wa nik ndii, araat kaɗ ŋ baab ɓoo ɗu woo ɗe ne, kuɓkiŋ ɗe Yuusufa woo ne, Kooh tumiɗ ɗe kilifaaniŋ Misra jen, a hayaat findi wa uup gaawoh, ");
INSERT INTO sav_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","a hey gene ŋ kur ki na woyse Gosen, a yi na kuɓuuciŋ ɗe, na set ciŋ ɗe, na ɗoopaat ciŋ ɗe, na ini a raak jen ; a nik ŋ serooso. ");
INSERT INTO sav_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ŋ hey ɗe eɗe in ci a etoh jen ne a pes, a yi na ɓooɓiŋ ɗe, na gat ciŋ ɗe ; ɗu ñakanɗi ali in. Kiis ci yatuus ci na haye, ca na hee name nik kiis aɗ. » ");
INSERT INTO sav_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A woyissa ne : « E ɗu hotoot, na ɗa Benyaamin, ñam na wee na ɗu, mi yi Yuusufa ; ");
INSERT INTO sav_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","naandsukaat baab kiyak ki ŋ raak ŋ Misra na ini ɗu hot jen, te ɗu hay na ɗe ndii findi wa uup gaawoh. » ");
INSERT INTO sav_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","A morgiɗukka taambɗoh ce Benyaamin, yeem morgiɗukka ɗe, ɓa fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A nammba morgiɗkoh na taambɗoh ciŋ ɗe ɓinooɓi, ɓa ambsohhaa na fuɗ, ɓa hannda min woo na ɗe. ");
INSERT INTO sav_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Wa Firawnaana kerah ŋ kahan ce ne taambɗoh ciŋ Yuusufa hayiɗ Misra, a neɓuusa nga, a yi na dag caŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","A woosa Yuusufa ne : « Woya taambɗoh ciŋ ɗa, ɓa sif mbaam ciŋ ɓa, ɓa dokuk Kanaan ");
INSERT INTO sav_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ne ɓa hay na baab ɓa na ɓooɓaŋ ɓa nik ndaam. Ŋ hey ɓa eɗe merhey mi uup baah ŋ kur ki, ɓa gen nga te ɓa pesohan kañam baahiɗ nga. ");
INSERT INTO sav_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Nama woo taambɗoh ciŋ ɗa, ɓa ɓay sareet yakak ndii, haytohoha ɓitiɓ ciŋ ɓa na kuɓuuciŋ ɓa na baab ɗu. ");
INSERT INTO sav_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Te in ca ɓaa hee faɗe ndaam kanaat ɓa misik laam, ɓaa hee gene na in ci uup baah ŋ Misra. » ");
INSERT INTO sav_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kuɓuuciŋ Israayel tumohha ɗaa. Yuusufa eɗta ɓa sareet ca yakak ca findi Firawnaana nakoh ɗe wa, na ñamaah ŋ waas. ");
INSERT INTO sav_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A onnda yaa nu nga ɗah kulɓa, waaye a eɗta Benyaamin ƴel haalis teemet-kaahay (300) na kulɓa yatuus. ");
INSERT INTO sav_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A nammba woosoh baab ɓa hayoha, mbaam naar ndaŋkiyaah, sifuuɗ yaa nu nga ɗah, ŋ in ca uup baah ŋ Misra, na mbaam riɓ ndaŋkiyaah, sifuuɗ bele, mbuuru na pesoha wiiriis. ");
INSERT INTO sav_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","A woosa taambɗoh ciŋ ɗe ne ɓa kanaat ñaɗoh ŋ waas, ƴutta a faɗta ɓa, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ɓeɗ pul Misra kotii, ɓa aassa Kanaan. Wa ɓa ree ŋ baab ɓa Yaŋhooɓa, ");
INSERT INTO sav_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ɓa woosa ɗe ne : « Baab, Yuusufa ris pes ! A yi sah adgoh kur kaŋ Misra jen. » Waaye ineem yoondiɗɗi Yaŋhooɓa, laam a koseeɗi ɓa. ");
INSERT INTO sav_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ɓa naandsukka ɗe in ca Yuusufa woo ɓa jen, a nammba hot sareet ca Yuusufa eɗoh ne ca ɓay ɗe, a hannda raak jam. ");
INSERT INTO sav_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A woosa ne : « Woo ki reehiɗ. Kuɓkiŋ ngo Yuusufa ris pes. Ŋ hey ɗe kee hota bala ŋ kaanan ɗah. » ");
INSERT INTO sav_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israayel kurkoh ɗaa, a ɓayya ina a raakee jen a kaɗeeɗa Misra. A reesa Beerseba, a seeƴukka ŋ Koohiŋ baab ɓa Isaahha. ");
INSERT INTO sav_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ŋ wek, Kooh ɓeeɗukka ɗe ŋ heeƴ an : « Yaŋhooɓa ! Yaŋhooɓa ! » A loffa ne : « Ee ! Mi yii kerah ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kooh woosa ɗe ne : « Ñam Kooh, Koohiŋ baab ɗu, kana neƴƴoh kaɗ Misra, ŋ hey pulɗohe cuuɓ angiɗ nga ɗa, ŋ ndaam. ");
INSERT INTO sav_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mi, ŋ haf fo, ŋ hey ɗa ɓende fu kaɗ te ñam na hee ɗa wike. A Yuusufa tufkan kakaan kiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yaŋhooɓa kurkohha Beerseba, kuɓuuciŋ ɗe ɓayya ɗe, a yi na ɓitiɓ ciŋ ɓa, na komaakciŋ ɓa, ŋ sareet ca Firawnaana eɗohee ne ca haytoh ɓa. ");
INSERT INTO sav_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ɓa ɓayndohha ɗoopaat caŋ ɓa na in ca ɓa raakoh ŋ Kanaan, a kaɗoh Misra ɗaa na ɓi kahan ce jen, ");
INSERT INTO sav_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","a hunnda na kuɓuuciŋ ɗe na set ciŋ ɗe, ƴaar na ɓitiɓ ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ɓii ɓeɗ rimkoh ŋ Israayel te ɓa hayya Misra : Yaŋhooɓa na saawiŋ ɗe Ruben. ");
INSERT INTO sav_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben na kuɓuuciŋ ɗe ƴaar ci : Hanook, Pallu, Hesroon na Karmii. ");
INSERT INTO sav_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyong na kuɓuuciŋ ɗe ƴaar ci : Yemuwel, Yamiin, Ohad, Yakiin, Sohar na Sawul yi yaay ɓa ɓaah nga ɓi Kanaan. ");
INSERT INTO sav_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi na kuɓuuciŋ ɗe ƴaar ci : Geerson, Kehaat na Meraari. ");
INSERT INTO sav_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudaa na kuɓuuciŋ ɗe ƴaar ci : Seela, Peeres na Seerah. Ɓiŋ ɗe ƴaar ci ɓinooɓi Eer na Onaan, ɓa kaanoh Kanaan. Peeres raakeen kuɓu ƴaar kanak : Hesroon na Haamuul. ");
INSERT INTO sav_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issaakar na kuɓuuciŋ ɗe ƴaar ci : Toola, Puwaa, Yob na Simroon. ");
INSERT INTO sav_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sabuloon na kuɓuuciŋ ɗe ƴaar ci : Sered, Eloon na Yahleel. ");
INSERT INTO sav_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ɓeem ɓeɗ kuɓuuci Leya na Yaŋhooɓa raakoh Paddan-Aram na kuɓuuciŋ ɓa. Dinaa kuɓkiŋ ɓa ɓitɓi ɓaatu nga ɗah, ɓa nikan ndaŋkiyaah-kaahay na kaahay (33). ");
INSERT INTO sav_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaad na kuɓuuciŋ ɗe ƴaar ci : Sifon, Haggi, Suuni, Esboon, Eeri, Aroodi na Areeli. ");
INSERT INTO sav_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser na kuɓuuciŋ ɗe ƴaar ci : Yimna, Yiswa, Yiswi na Beriya. Ɓaatta nga Serah taambɗoh ɓa ɓitiɓ. Beriya nameen raak kuɓu ƴaar kanak : Heber na Malkiyel. ");
INSERT INTO sav_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ɓeem ɓeɗ kuɓuuci na set ci Yaŋhooɓa raak na Silpa, ñaama Laban eɗee kuɓkiŋ ɗe Leya. Ɓa jen ɓa nikee ndaŋkiyaah na yasna-yino (16). ");
INSERT INTO sav_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaŋhooɓa na ɓitiice Rasel raakee kuɓu ƴaar kanak : Yuusufa na Benyaamin. ");
INSERT INTO sav_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yuusufa raakka kuɓu ƴaar kanak : Manasse na Efrayim. A raakoh ɓa Misra na ɓitiice Asnat kuɓu Potifera, seeƴkiɗohaŋ kur-taaha na woyse On. ");
INSERT INTO sav_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyaamin na kuɓuuciŋ ɗe ƴaar ci : Bela, Beker, Asbel, Geera, Naaman, Eehi, Roos, Muppiim, Huppiim na Arde. ");
INSERT INTO sav_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ɓeem ɓeɗ kuɓuuci na set ci Yaŋhooɓa raak na Rasel. Ɓa jen ɓa nikee ndaŋkiyaah na nikiis (14). ");
INSERT INTO sav_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daan raakee kuɓu yino teeku Husiim. ");
INSERT INTO sav_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftaali na kuɓuuciŋ ɗe ƴaar ci : Yahce'eel, Guuni, Yeeser na Sillem. ");
INSERT INTO sav_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ɓeem ɓeɗ kuɓuuci na set ci Yaŋhooɓa raak na Bilha, ñaama Laban eɗee kuɓkiŋ ɗe Rasel. Ɓa jen, ɓa nikee yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ɓi rimkoh ŋ Yaŋhooɓa te ɓa hunnda na ɗe Misra jen ɓa nikee ndaŋkiyaah-yasna-yino na yasna-yino (66), ne ɓitiɓ ciŋ kuɓuuciŋ ɗe kinndohuuɗi nga ɗah. ");
INSERT INTO sav_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kuɓuuci kanak ci Yuusufa raakoh Misra ɓaatu nga ɗah, ɓa jen, ɓa nikan ndaŋkiyaah-yasna-kanak (70). Ɓeem ɓeɗ ɓi rimkoh ŋ Yaŋhooɓa te ɓa nikka na ɗe Misra. ");
INSERT INTO sav_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaŋhooɓa tuuƴee Yudaa ŋ Yuusufa ne a adug ɗe ɗiska na woyse Gosen. Wa Yaŋhooɓa na ɓi kahan ce ree Gosen, ");
INSERT INTO sav_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yuusufa nakohha wotiiraŋ ɗe tokɗu, a kaɗta raaka baab ɓa nga, yi nam teeku Israayel. A hot ɗe hot rek, a nuppa, a morgiɗukka ɗe, a fuɗeeɗa in maañiɗ. ");
INSERT INTO sav_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israayel woosa ɗe ne : « Ɗiski wa nik ndii, ŋ miniɗ kaan kotii, laam ŋ hotisiɗ ɗa, te fu yii pes. » ");
INSERT INTO sav_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Weɗi Yuusufa woyoh taambɗoh ciŋ ɗe na ɓi kahan baab ɓa ne : « Mi yii kaɗ woya Firawnaana ne taambɗoh ciŋ ngo na ɓi kahan baab ɓoo, ɓa nikee ŋ Kanaan, ɓa hayiɗ ɗiskiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ŋ hey ɗe woye ne ɗu niiɗoh pe' na mbaal na inoh te ɗu haytohiɗ ca na raak-raakiŋ ɗu jen. ");
INSERT INTO sav_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Firawnaani ɓeeɗuk ɗu, a meekis ɗu ini ɗu na pangke ɗah, ");
INSERT INTO sav_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","woyaat ɗe ne ɗu niiɗoh, te ina ɗu nikoh komaaki po wi, ɗu inah weɗi, findi caac ciŋ ɗu. Ŋ ineem ɗu hey mine gen Gosen, laam gen na niiɗoh wa in sanguuɗ nga ɓi Misra. » ");
INSERT INTO sav_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Wa Yuusufa ƴut woo na ɓi kahan ɓa, a kaɗta ŋ Firawnaana a woosa ɗe ne : « Baab ɓoo na taambɗoh ciŋ ngo pulohiɗ Kanaan, ɓa ɗaa ŋ Gosen na ɗoopaat caŋ ɓa na raak-raakaŋ ɓa jen. » ");
INSERT INTO sav_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yuusufa huneen na yatuus ŋ taambɗoh ciŋ ɗe, ne ɓa teekɗukoh na Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firawnaana meekissa ɓa ne : « Pangkiŋ ɗu wa ye ? » Ɓa loffa ɗe ne : « Ɓoo niiɗoh, kilifaani, findi caacuuciŋ ɓoo. ");
INSERT INTO sav_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ɓoo hay ne ɓoo nikohaah ŋ kur ki, laam aɗi miskiɗ lool ŋ kur kaŋ Kanaan, po ɓoo raakisɗi ɗiski ɓoo niiɗan ɗoopaat ciŋ ɓoo. Ɓoo na kiimee ɗa ne fu on ɓoo, ɓoo nik ŋ Gosen. » ");
INSERT INTO sav_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firawnaana woosa Yuusufa ne : « Baab ɗu na taambɗoh ciŋ ɗa hayiɗ nga ɗa. ");
INSERT INTO sav_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kur ki weɗi ŋ yaah ciŋ ɗa, ɓayaa ɓa ŋ ɗiski uup baah nga, ɓa nik ŋ Gosen ; te fu hot miniɗ niiɗ nga ɓa ɗah, fu eɗ ɓa ɗoopaat ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yuusufa nammba ɓay baab ɓa ne a teekɗukoh na Firawnaana. Yaŋhooɓa barke'iɗta ɗe, ");
INSERT INTO sav_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","yeem hannda ɗe meekis ne : « Fu raak kiis hend na ? » ");
INSERT INTO sav_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaŋhooɓa woosa ɗe ne : « Kiis teemet na kiis ndaŋkiyaah-kaahay (130) ceɗi cii, mi yii wil ŋ kur ci, ca kiis gaawiɗ te ca miskiɗ. Ŋ raakɗi kiis ci caacuuciŋ ngo raakee ndoom te ɓa namee nik tiindoh findiiso. » ");
INSERT INTO sav_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ƴutta, a barke'iɗta Firawnaana, a cootta. ");
INSERT INTO sav_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ƴutta, Yuusufa ɓayya baab ɓa na taambɗoh ciŋ ɗe, a daliɗta ɓa ŋ Ramses, ŋ ɗiska uup baah ŋ Misra, findi Firawnaana nakoh ɗe wa. ");
INSERT INTO sav_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A nammba ɓa eɗ ñamaah, baab ɓa na taambɗoh ciŋ ɗe na ɓi kahan baab ɓa, yaa nu nga ɗah findi kuɓuuciŋ ɗe hend. ");
INSERT INTO sav_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aɗa miskeen lool po ali kañam raakisɗi ŋ Misra na Kanaan, ɓooɓa looffa keeh-keeh sagu aɗuk ; ");
INSERT INTO sav_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yuusufa nangɗohha haalsaŋ Kanaan na waŋ Misra jen, wa ɓa romohe bele, a ɓayyaa kahan Firawnaana. ");
INSERT INTO sav_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wa kaɗta po ali haalis raakisɗi ŋ Misra na Kanaan, ɓi Misra jen hayya ŋ Yuusufa ɓa woosa ɗe ne : « Hanaa fu heyɗi ɓoo markiɗe po ɓoo kaan ŋ aɗi. Eɗa ɓoo pesoha laam ɓoo raakisɗi ali haalis romoha. » ");
INSERT INTO sav_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yuusufa woosa ɓa ne : « Nik ne ɗu raakisɗi haalis ɗah, ɓayaat ɗoopaat ciŋ ɗu, ŋ lofiɗ ɗu ca pesoha. » ");
INSERT INTO sav_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Weɗi ɓa ɓayoh panis caŋ ɓa, mbaal ca, pe' ca, inoh ca na mbaam ca jen, ɓa eɗeeɗa Yuusufa ca, a lofɗeeɗa ɓa ca bele. Ɓa raakka pesoha ŋ kiis kaam. ");
INSERT INTO sav_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Wa kiis ka reeh, ɓa hayissa ŋ Yuusufa ɓa woyissa ɗe ne : « Kilifaani, fu inhiɗ ne ɓoo raakisɗi haalis te ɗoopaat ciŋ ɓoo ceɗi na ɗa, ɓoo tasɗisɗi ali in romoha, nikɗi faan ciŋ ɓoo na keheƴ ciŋ ɓoo ɗah. ");
INSERT INTO sav_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Hanaa fu heyɗi ɓoo markiɗe, po ɓoo kaan na aɗ, yohon ciŋ ɓoo kasaara. Romoha ɓoo pees, ɓoo na yohon ciŋ ɓoo, ɓoo nik ñaam ciŋ Firawnaani. Eɗa ɓoo tisoh, ɓoo min pes, keheƴ ci nikuu ɓarang ɓarang. » ");
INSERT INTO sav_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Weɗi Yuusufa romɗoh Firawnaana kehƴaŋ Misra jen. Yaa nu nik ŋ Misra ɗah, toonnda yohon ce sagu miska aɗa miske. Merhey maŋ kur ka jen nikka wuu Firawnaana kotii, ");
INSERT INTO sav_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yuusufa tummba ɓa gen nga ñaam ɓak po ɓak ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Keheƴ caŋ seeƴkiɗoh ca dong ceɗ Yuusufa tasee rom laam, ɓa raakeen pesoha sagu ina Firawnaana meeɗ ɓa waɗ ; weɗ tah ɓa tooneeɗi yohon caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yuusufa woosa ɓooɓa ne : « Ɗiski wa nik ndii, ɗu romuuɗ, a Firawnaani raak ɗu na keheƴ ciŋ ɗu. Tisoh ceɗi cii, sokaat yohon ci, ");
INSERT INTO sav_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","waaye yatuus nu pul nga ɗah, a Firawnaani raakan yinoori, ɗu raak nikiis ci tas, ɗu puliɗ tisoh nga, ɗu nam raak pesoha, ɗu na kuɓuuciŋ ɗu na ɓi gen na ɗu jen. » ");
INSERT INTO sav_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ɓa woosa ne : « Kilifaani, ɓoo teyɗukiɗ nik ñaam ciŋ Firawnaani laam fu baahohiɗ ɓoo te fu mucɗiɗ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yuusufa tufkiɗoh ineem ɗaa ŋ Misra ŋ jamanoonaam te wa ris nga po ɗiski maa woyohe na ɗu ndii. Yatuus nu nguɗohu ŋ keheƴ ciŋ Misra ɗah, a Firawnaani na raake yinoori po tas keheƴ ciŋ seeƴkiɗoh ci laam a raakɗi ca. ");
INSERT INTO sav_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ŋ ini kaɗ ŋ Israayel ci, ɓa risee ŋ Misra, ŋ kur ka na woyse Gosen, ɓa ɓasilla nga lool te ɓa raakka keheƴ nga. ");
INSERT INTO sav_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaŋhooɓa tumiɗ kiis ndaŋkiyaah na kiis yasna-kanak (17) ŋ Misra. Ini a pes jen wa kiis teemet na kiis ndaŋkiyaah-nikiis na kiis yasna-kanak (147). ");
INSERT INTO sav_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wa Israayel kaɗ po a inahha ne kakaan kiŋ ɗe usisɗi, a ɓeeɗukka kuɓkiŋ ɗe Yuusufa, a woosa ɗe ne : « Nik ne fu kerhiɗiɗ to ɗah, ooɓa yaahiŋ ɗa ŋ rambiŋ ngo, fu giñ ne ŋ kaan ɗah, fu hey yo baahohe po, fu uumbuu so ŋ Misra, ");
INSERT INTO sav_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","waaye fu hey yo ɓaye po ŋ ɗiska caacuucaŋ ngo uumbu, fu uumb mbo nga. » Yuusufa loffa ɗe ne : « Ŋ hey ɗa tumɗe findi fu woyoha. » ");
INSERT INTO sav_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israayel woosa ne : « Giñiɗ to ineem. » A ginnjaa. Ndeem Israayel yippa pukiŋ ɗe ŋ haf fiƴaangaŋ ɗe, a ñaamukka Kooh. ");
INSERT INTO sav_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Wa in ceem coot, ɓa woosa Yuusufa ne baab ɓa kosaayiɗ. A kaɗta nga na kuɓuuciŋ ɗe kanak ci Manasse na Efrayim. ");
INSERT INTO sav_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yaŋhooɓa woyuusa ne kuɓkiŋ ɗe Yuusufa hayiɗ ɗe marke, a ndengɗukka po a ɓooffa ŋ ɗafuk fiƴaangiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","A woosa Yuusufa ne : « Koohi Min teeɓkeen ndo ŋ Luus ŋ kur kaŋ Kanaan, a barke'iɗta so. ");
INSERT INTO sav_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A woosa so ne : “ Ŋ hey ɗa tume ɓasil po fu nik caaciŋ ɓi cuuɓi cuuɓ te ŋ hey one ɓi na hee rimkohe nga ɗa kur kii, ɓa raakoota po faw. ” ");
INSERT INTO sav_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ɗiski wa nik ndii, kuɓuuciŋ ɗa kanak ci fu raakoh ŋ Misra bala ŋ hayan ɗah, ɓa na hee nike ɓiŋ ngo ; Manasse na Efrayim nikan kuɓuuciŋ ngo findi Ruben na Simeyong. ");
INSERT INTO sav_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Waaye ɓi fu na hee raakisse, ɓa na hee nike ɓiŋ ɗa, ɓa laman ngaŋ waɗiŋ yakak ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Wa ŋ puloh Paddan-Aram, Rasel kaannda, kaan miskohiɗ ŋ kur kaŋ Kanaan ; a yaa ŋ uummba ndaam, ŋ sereendaŋ waasa bala fu reyan Efraata ɗah. » Efraata, weɗ nam teeku Betlehem. ");
INSERT INTO sav_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Weɗi Israayel hotoh komaakciŋ Yuusufa a meeksohha ne : « E ɓinde ɓii ? » ");
INSERT INTO sav_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yuusufa loffa ɗe ne : « E kuɓuuci Kooh onoh ho ndii. » A woosa ɗe ne : « Reɓɗaa ɓa ndii, ŋ barke'iɗ ɓa. » ");
INSERT INTO sav_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Wa raak Israayel yaɓko'iɗ po has ciŋ ɗe neɓisɗi. Yuusufa reɓiɗta komaakca nga ɗe, a morgiɗukka ɓa. ");
INSERT INTO sav_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","A woosa Yuusufa ne : « Ŋ liiɓeeɗi ne ŋ hey ɗa hotisse, waaye fu hot nga, Kooh teeɓiɗ to sah kuɓuuciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yuusufa kurkiɗohha ɓa ŋ kot ciŋ baab ɓa, a ƴekka po pukiŋ ɗe reesa kehƴi. ");
INSERT INTO sav_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ƴutta, a ammba Efrayim ŋ yaahiŋ ɗe ñaahmi, yeem lahha baab ɓa Israayel yaah-sing, a ammba Manasse ŋ yaahiŋ ɗe singi, yeem nammba lah Israayel ŋ ñaahmiŋ ɗe ; a reɓiɗta ɓa ŋ baab-caaciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Waaye Israayel sufɗohha yaah ciŋ ɗe, a degga wi ñaahmi ŋ hafiŋ Efrayim yi nikee ƴini ; a degga wi singi ŋ hafiŋ Manasse na ina a nikee saawa jen. ");
INSERT INTO sav_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A barke'iɗta Yuusufa an : « Mi yii kiim Kooh yi Ibrahiima na Isaahha ñaakɗe ŋ kipes kiŋ ɓa jen, Kooh yi na niiɗee so ina ŋ nikoh po wii, ");
INSERT INTO sav_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","malaakaani muciɗ to ŋ siɓin nu nik, a barke'ɗaat komaakcii, po tiikiŋ ngo na ciŋ paamuuciŋ ngo Ibrahiima na Isaahha kerhu saguuɓa ; ɓa rimaatɗohaat laayiɗ ŋ kehƴi jen. » ");
INSERT INTO sav_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wa Yuusufa hot ne baab ɓa deg yaahiŋ ɗe ñaahmi ŋ hafiŋ Efrayim, a neɓuuɗi ; a ammba yaahiŋ baab ɓa ne a yongisa ŋ hafiŋ Manasse, ");
INSERT INTO sav_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","a woosa baab ɓa ne : « Wa ɗaa haa baab, yii a yi saawi, dega yaahiŋ ɗa ñaahmi ŋ hafiŋ ɗe kay ! » ");
INSERT INTO sav_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Waaye baab ɓa sannga, a woosa Yuusufa ne : « Kuɓkiŋ ngo, ineem ŋ inhiɗa, ŋ inhiɗa baahiɗ. Manasse hey name raak cuuɓ angiɗ, waaye a taambɗoh ce na hee ɗe uupe, ɓi cuuɓi cuuɓ hey pulohe nga ɓi na hee rimkohe ŋ Efrayim. » ");
INSERT INTO sav_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mbaɗi, Yaŋhooɓa barke'iɗta ɓa, a woosa ne : « Israayel ci hey kiimohe barke ŋ tiik ciŋ ɗu an : Kooh barke'ɗaat ɗa findi a barke'ɗoh Efrayim na Manasse. » Yaŋhooɓa adgiɗoh Efrayim ɗaa, a degga Manasse nga. ");
INSERT INTO sav_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Wa a ƴut, a woosa Yuusufa ne : « Kakaan kiŋ ngo usisɗi, waaye Kooh hey rise na ɗu te a hey ɗu dokne ŋ kur kaŋ caacuuciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ŋ hey ɗa waɗe ini uup wiŋ taambɗoh ciŋ ɗa, ɓaya Sisem, kur ki ŋ naaf na ndangiŋ ngo na ɓis ciŋ ngo ngaŋ cuuɓiŋ Amoor ci. » ");
INSERT INTO sav_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Wa Yaŋhooɓa ƴut barke'iɗ kuɓuuciŋ Yuusufa, a nammba ɓeeɗuk kuɓuuciŋ ɗe, a woosa ɓa ne : « Hayaat, ŋ woo ɗu kimiŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nangɗukohaat, ɗu sikɗuk, ɗu ɓi kuɓuuciŋ Yaŋhooɓa ; sikɗukaat to mi yi Israayel, baab ɗu. ");
INSERT INTO sav_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, saawiŋ ngo, a fu teeɓoh ne ŋ ƴaar, raak ko na hatil. A fu uupiɗ taambɗoh ciŋ ɗa cir na hatil. ");
INSERT INTO sav_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Fu mand na masuɓ baliɗ, waaye fu mirndohanɗi adug, fu mbetiɗ ciriŋ ɗa, wa fu sot fiƴaangiŋ baab ɗu. ");
INSERT INTO sav_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyong na Lewi yino. Ɓeɗ na hune ne ɓa tum aƴaarkoha. ");
INSERT INTO sav_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Muk ! Ŋ kanaat hun na ɓa ŋ ini ɓaa waakohe te ŋ waaɗɗi maasoh coh ciŋ ɓa. Ŋ ayrukiŋ ɓa, ɓa apiɗ ɓi ɓo' ; te ŋ ini neɓ ɓa, ɓa nguɗiɗ sir kot naar inoh. ");
INSERT INTO sav_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Wa alku'aat, ayrukohaaɗiŋ ɓa wi hun na hatil weem, na aay-keeñiŋ ɓa wi hunɗi na yeeɓuk. Ŋ hey ɓa paysohe ŋ kahan Yaŋhooɓa ŋ pasaroh ɓa ŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yudaa, a fu taambɗoh ciŋ ɗa ƴeekan te fu hey tahe ɓi sang ɗa hiir. Taambɗoh ciŋ ɗa hey ɗa ƴekɗe. ");
INSERT INTO sav_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yudaa kuɓkiŋ ngo, fu gaynde cociɗ, gayndeeni puloh ñama doɓ, faanukka, ya ɓa kaañ ɗe kurkiɗ ? ");
INSERT INTO sav_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Salmaari na yilfohse, saɓsukohanɗi na yaah ciŋ ɓi kahan Yudaa. Te inhisoha buur kurkanɗi ŋ harmban kot ciŋ ɓa po mbaɗna heɗ wa keeh-keeh hayan. A yi fu inah ne, cuuɓ ci jen hey ɗe kerhiɗe. ");
INSERT INTO sav_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A hey laaye tas reseñ po, a layee mbaamiŋ ɗe nga ca te cumbri toksan ŋ ci uup baah. A naawohan kulɓaakiŋ ɗe biiñ na lipiŋ ɗe ñif reseñ. ");
INSERT INTO sav_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Biiñ laayiɗ hey ruumndiɗe has ciŋ ɗe te miis laayiɗ hey yaanwiɗe sis ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabuloon, a genan sereendiŋ cookmi, ɗiski gaal ci na serse. Ini amboh ndeem po Sidoon, wa ɓaahan ŋ kehƴiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issaakar mbaam ngooŋka, a na ɗasɗuke ŋ ɗisik ne a iɗsiɗuk. ");
INSERT INTO sav_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A hotiɗ ne ɗiski a nik baahiɗ iɗsiɗkoha te kur ki neɓiɗ. A ƴuugiɗ ne a sifuk, a yi waɗuk pangki miskiɗiŋ ñaam. ");
INSERT INTO sav_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daan hey raake cuuɓi a adgohan findi cuuɓ ciŋ Israayel cinooci. ");
INSERT INTO sav_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan mandan na laɓriifi raɗuk ŋ waas, hirñi duluuruk ŋ sero waas ; laɓriif na ɗoɓe panis ŋ kot, ƴaari rap ɗe keen kaƴaarsukiɗ. ");
INSERT INTO sav_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Eey, Nikiɗi, ŋ oolkoh ɗa ne fu naaf fo. ");
INSERT INTO sav_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gaad, ɓi ɓo' aƴaarkiɗ ɓeɗ keenan ɗe waaye, a hey ɓa wiindsuke po a ngek ɓa. ");
INSERT INTO sav_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, kehƴiŋ ɗe hey laaɓe te weɗ eɗohan kañam ci, ci min kaɗ ŋ buur. ");
INSERT INTO sav_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftaali, a ngaayi raak haf ce, yi na raake buul moɗiɗ. ");
INSERT INTO sav_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yuusufa, a naak kidig rimiɗ ; kidgi paar ŋ sero masuɓ te naak ciŋ wa cootukka ɗingi. ");
INSERT INTO sav_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ɓi weesoh ɓis keeniɗ ɗe, ɓa weessa ɗe, ɓa tummba ɗe sanguuɗ ; ");
INSERT INTO sav_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Waaye a ris ambiɗ haliini, amb moɗoɗ te yaah ciŋ ɗe neɓiɗ sagu hatiliŋ Koohiŋ Yaŋhooɓa, Kooh yi Niiɗohi, a nammba nik Atoh fiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Koohiŋ baab ɗu hirpaat ɗa, Koohi Min barke'ɗaat ɗa, a on ɗa toɓi na pulohe ɗafki, na masmi na pulohe ŋ kehƴi, a on ɗa, ɓitiɓ ci na ɗoopaat ci nik ɓasloh. ");
INSERT INTO sav_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Barkeeniŋ baab ɗu weɗi uup in ci baahiɗ ciŋ tangooci ɗeɓgaan ; wa cootkiɗ raak-raak ciŋ tangooci maañohngaan ci. Barkeeneem ruhsaat nga ɗa Yuusufa, fu yi kilifaaniŋ taambɗoh ciŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyaamin a ɓaakoɓ saahiɗ, a na ɓaaɓe ñam ini a ap, niin reesa ɗah, a paysoh ini tas. » ");
INSERT INTO sav_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Woo ceem ceɗ baab ɓa barke'ɗoh ɓa, yaa nu nga ɗah, a eɗta ɗa wa hun na ɗa. Ɓeem, ɓeɗ fer cuuɓ ci ndaŋkiyaah na kanak (12) ciŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Wa a ƴut barke'iɗ kuɓuuciŋ ɗe, Yaŋhooɓa woosa ɓa ne : « Haadiŋ ngo Jaanim usisɗi, ŋ kuruk nga ɗah, uumbaat to ŋ sero caacuuciŋ ngo, ŋ huraŋ atoh fa nik ŋ ɗooƴ yohon Efron yi ɓaahee ŋ cuuɓiŋ Hit ci, ");
INSERT INTO sav_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ngaŋ Makpela ŋ sero Mamre, ŋ kur kaŋ Kanaan. Yohneem weɗi Ibrahiima romee ŋ Efron ne a tuma ruy-ruy caŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","A uumbu nga na ɓitiice Saarata, Isaahha nam uumbu nga na ɓitiice Rebeka te ŋ namis uumb Leya nga. ");
INSERT INTO sav_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Yohna na huraŋ atoh fa nik nga romohu ŋ cuuɓiŋ Hit ci. » ");
INSERT INTO sav_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wa Yaŋhooɓa ƴut nak kuɓuuciŋ ɗe in ceem, a faankissa, weɗ a nguɗoh, a haadda Jaanim. ");
INSERT INTO sav_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Weɗi Yuusufa morgiɗkoh baab ɓa, a fuɗeeɗa fuɗ miskiɗ. ");
INSERT INTO sav_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","A woosa paƴoh caŋ ɗe ne ɓa haɓɗaat ɗe ; ɓa haɓiɗta fiɗaafaŋ Israayel na diw eeñiɗ. ");
INSERT INTO sav_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ŋ findi ɓa meeɗ tumoh, ɓa raakka neeh ndaŋkiyaah-nikiis (40) na haɓɗaŋ wa. Ɓi Misra rooyya ɗe ini ree neeh ndaŋkiyaah-yasna-kanak (70). ");
INSERT INTO sav_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wa neeh caŋ rooy ca coot, Yuusufa woosa dag caŋ Firawnaana ne : « Nik ne ɗu kerhiɗiɗ to ɗah, kaɗaat ŋ Firawnaani ɗu woyiɗ to ɗe ne : ");
INSERT INTO sav_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Wi baab ɓoo hee kaane, a giñɗukoheen ndo ne a kuruk nga ɗah, ŋ uumbaat ɗe ŋ kur kaŋ Kanaan, ŋ ruy-ruya a haɓɗiɗ haf ce. Weɗi tah ŋ waaɗ ne, a on ndo ŋ kaɗ tuma ineem, ŋ hay. » ");
INSERT INTO sav_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Wa Firawnaana kerah woo keem, a woosa Yuusufa ne : « Fu miniɗ kaɗ uumba baab ɗu findi fu giñɗohee ɗe wa. » ");
INSERT INTO sav_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yuusufa hunnda na dag caŋ Firawnaana jen, na yakak caŋ Misra, ");
INSERT INTO sav_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","na ɓi kahan ce, na taambɗoh ciŋ ɗe, na ɓi kahan baab ɓa ; ali ɓo' taseeɗi ŋ Gosen ɗal komaakca ƴin ca na ɗoopaat ca ɗah, a kaɗta uumba baab ɓa ; ");
INSERT INTO sav_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ɓi wotiir na ɓi panis rapuuɗ darra ɓa, wa nikka mboolo yakoh na yakoh, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ɓeɗ kaɗoh kaɗoh po, ɓa reesa Goren-Ataat, ŋ ɓak Yurdan, ɓa rooyya Yaŋhooɓa ndaam, rooy keeh-keeh. Yuusufa ruyiɗta baab ɓa neeh yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wa ɓi Kanaan hot mboolndaŋ ruya, ŋ Goren-Ataat, ɓa woosa ne : « Ruyiŋ ɓi Misra wii deey, wa yakiɗ lool ! » Weɗ tah ndaam ŋ sero Yurdan, ferɗuusa Abel-Misrayim (ruyiŋ ɓi Misra). ");
INSERT INTO sav_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ŋ ineem, kuɓuuciŋ Yaŋhooɓa tumiɗta baab ɓa ina a nakee ɓa : ");
INSERT INTO sav_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ɓa ɓayya fiɗaafaŋ ɗe kur kaŋ Kanaan, ndaam, ɓa uummba ɗe ŋ huraŋ atoh fa ŋ yohna nik ŋ Makpela, ŋ sero Mamre. Yohneem weɗi Ibrahiima romee ŋ Efron yi ɓaahee ŋ cuuɓiŋ Hit ci ; a tummbaa ruy-ruyiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Wa Yuusufa ɗaak baab ɓa po ƴutta, a dokukka Misra, a yi na taambɗoh ciŋ ɗe, na ɓooɓa ɓendee ɗe jen. ");
INSERT INTO sav_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Taambɗoh ciŋ ɗe hotta ne baab ɓa kurkiɗ nga, ɓa woosa ne : « Wa miniɗ nik ne Yuusufa ɗaakɗiɗ ɓoo aay-keeñ, ne a wirind ɓoo in ci moɗaaɗiici ɓoo tum ɗe jen. » ");
INSERT INTO sav_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ɓa woosohha nga ɗe ne bala baab ɓa kaanan ɗah, a woyeen ne : ");
INSERT INTO sav_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","« Woyɗaat to Yuusufa ne a ɗaasɗaat to taambɗoh ciŋ ɗe, ŋ in ci moɗaaɗiici ɓa tum ɗe jen, laam ɓa tooñiɗ ɗe keeh-keeh. Mbaa mi yii kiim ɗe ne a ɗaas ɓa, laam ɓa ñaam ciŋ Koohiŋ baab ɓa. » Wa woo keem ree ŋ Yuusufa, a fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ŋ ineem taambɗoh ciŋ ɗe hayootta nga ɗe, ɓa raɗukka ŋ fikiice, ɓa woosa ɗe ne : « Ɓoo ñaam ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Waaye Yuusufa woosa ɓa ne : « Kanaat neƴƴoh, ɗu liiɓ ne e mi Kooh e ? ");
INSERT INTO sav_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wa keeh ne ɗu waaɗee so tum in moɗaaɗi, waaye Kooh ɓoƴsiɗa baahiɗ. Laam, a waaɗee muciɗ kiñin laayiɗ ŋ findi ɗu hotoha an. ");
INSERT INTO sav_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Mbaa kanaat neƴƴoh, ŋ hey ɗu taambkohe, ɗu na komaakciŋ ɗu. » Yuusufa giifɗoh taambɗoh ciŋ ɗe ɗaa, a ñaahha ɓa ne ɓa ndengɗuk. ");
INSERT INTO sav_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yuusufa na ɓi kahan baab ɓa genee Misra. Ini a pes jen wa kiis teemet na kiis ndaŋkiyaah (110). ");
INSERT INTO sav_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A maasohiɗ kuɓuuci na set ciŋ Efrayim ; kuɓuuciŋ setiŋ ɗe Makir yi kuɓkiŋ Manasse, a yi koɗ ɓa. ");
INSERT INTO sav_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bala a kaanan ɗah, Yuusufa woyeen taambɗoh ciŋ ɗe ne : « Ŋ mand na kurkiɗ nga, waaye wa hooliɗ to ne Kooh hey ɗu ambohe ; te a hey ɗu dokne ŋ kur ka a gapee Ibrahiima, Isaahha na Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Waaye Kooh tum, ɗu kaɗee ɗah, giñɗaat to ne, ɗu hey ɓayndohe ƴoh ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yuusufa kaanoh Misra wa a raak kiis teemet na kiis ndaŋkiyaah (110). Ɓa haɓiɗta fiɗaafaŋ ɗe na diw eeñiɗ, ɓa ɓekkaa ŋ jaat.");
INSERT INTO sav_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","4","Cii ceɗ tiik ciŋ kuɓuuciŋ Israayel yi na woyse Yaŋhooɓa, ɓi hay na ɗe Misra : Ruben, Simeyong, Lewi na Yudaa ; Issaakar, Sabuloon na Benyaamin ; Daan na Naftaali, Gaad na Aser ; yaa nu nga ɗah, na ɓi kahan ce. ");
INSERT INTO sav_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Raak Yuusufa kuɓkiŋ Yaŋhooɓa yinoori nikee ŋ Misra. Ɓi kahan Yaŋhooɓa jen nikee ndaŋkiyaah-yasna-kanak (70). ");
INSERT INTO sav_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ŋ mirndaani Yuusufa kaannda, a yi na taambɗoh ciŋ ɗe na ɓooɓa ɓaahee na ɗe jamano jen. ");
INSERT INTO sav_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Waaye Israayel ca nikka ɓasil, ɓa rimaatɗoheeɗa, ɓa ɓaatkeeɗa, po ɓa riiffa kur ka. ");
INSERT INTO sav_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Wa kaɗeeɗa po buur wiiriis adgohha kur ka, raak ɗe inheeɗi in ŋ Yuusufa. ");
INSERT INTO sav_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","A woosa ɓooɓaŋ ɗe ne : « Markaat Israayel ci, ɓeɗ uup ɓoo laay, ɓa uupiɗta ɓoo hatil. ");
INSERT INTO sav_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Hiñoh raak ɗah, ɓa miniɗ hun na ɓi sang ɓoo, ɓa ruuk ɓoo te ɓa pul kur ki, kon ɓoo tumohaat na liiɓoha po ɓa ɓaatkuu. » ");
INSERT INTO sav_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Weɗi ɓi Misra degoh Israayel ca panguk miskiɗ, ɓa kooɗta ɓi ɓo' ne ɓa tumɗukohee Israayel ca ŋ pangkeem ngaŋ uup doole. Ɓa pangkeeɗa, po ɓa taɓahha Pitom na Ramses, ca nikka kur-taah ɗaakkoha pesoha ŋ tiikiŋ Firawnaana, buuraŋ Misra. ");
INSERT INTO sav_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Waaye findi ɓa uup ɓa tumɗukoh panguk miskiɗ ɗah, Israayel ca na uupohe ɓaatkoh ɗaa, ɓi Misra neƴƴohha ɓa keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ŋ ineem, ɓa uupeeɗa ɓa nga uup ñaamɗukoh. ");
INSERT INTO sav_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ɓa yahha kipes kiŋ ɓa na panguk miskiɗ, ɓa haɓɗiɗukoheeɗa ɓa muul na ɗok, ɓa guurɗukoheeɗa ɓa, ɓa añaandkoheeɗa ɓa na panguk nu nik ne wa miskiɗ ɗah. ");
INSERT INTO sav_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Wa raakeen dooñoh kanak ngaŋ ɓaŋ Heber ca, yinoora teeksee Sifara ya tas teekuusa Puwa. ");
INSERT INTO sav_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Buura nakka ɓa ne : « Ɗu tufkohee ɓitiɓ ciŋ Heber ci ne ɓa ɓaslee kotii ɗah, markaat baahiɗ, kuɓki nik ƴaar ɗah, apaat ɗe, a nik ɓitiɓ ɗah, faɗaat ɗe a pes. » ");
INSERT INTO sav_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Waaye dooñoh ca nupeen Kooh, weɗ tah ɓa haɓiɗɗi ineem, ɓa faɗta kuɓuuca ƴaar ca, ɓa apɗi ɓa. ");
INSERT INTO sav_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Weɗi buura ɓeeɗkoh ɓa, woosa ɓa ne : « Wa ye tah ɗu tummba inii, ɗu faɗee kuɓuuci ƴaar ci ɓa pese ? » ");
INSERT INTO sav_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ɓa loffa ɗe ne : « Ɓitiɓ ciŋ Heber ci ɓa mandɗi na ɓiŋ Misra, ɓa ndeng ndeng. Bala dooñohi na ree ɗah, raakee ɓa raakiɗ kuɓu po ƴutiɗ. » ");
INSERT INTO sav_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kooh baahohha dooñoh ca, ŋ ineem Israayel ca uupeeɗa nga ɓaatuk, po ɓa nikka laayoh na laayoh. ");
INSERT INTO sav_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kooh tummba dooñoh ca ɓasil, ɓa raakka ɓi kuɓu ŋ kerhiɗi ɓa kerhiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Firawnaana nakka ɓooɓaŋ ɗe jen ne : « Israayel ci raak kuɓu a nik ƴaar ɗah, njafaat ɗe ŋ kaliŋ Niil ; a nik ɓitiɓ ɗah, faɗaat ɗe a pes. » ");
INSERT INTO sav_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Raakeen ƴaar ŋ Heber ca, ɓaah ŋ cuuɓiŋ Lewi, a tokka ɓitiɓ ŋ cuuɓeem ; ");
INSERT INTO sav_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ɓitɓeem ammba rook, a raakka kuɓu ƴaar, a hotta ne kuɓka moɗiɗ, a ɗasiɗta ɗe ini ree caɓin kaahay. ");
INSERT INTO sav_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Wa kaɗta po a minisɗi ɗe ɗasiɗ, a ɓayya pañe teɗohuuɗ paangfi na woyse hapeel, a reeffaa godirong na daakaande, ne masuɓ aasuu nga, a ɓekka kuɓka nga, a ɗaakkaa ŋ hapeel ca paar ŋ masmaŋ sereendaŋ kalaŋ Niil. ");
INSERT INTO sav_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Taambɗoh kuɓka, ya ɓitɓa, cangtiɗukka, a markeeɗa ini raakan. ");
INSERT INTO sav_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Wa degga ƴissuut, kuɓkiŋ Firawnaana ɓitɓa kaɗta ɓookka ŋ kala, huntoh caŋ ɗe ɓitiɓ ca tiindsukeeɗa ŋ sereendaŋ kala, a ƴokka pañe ŋ ɗooƴ paangiica, a woossa ñaamaŋ ɗe ɓitɓa wa, a ɓayyaa. ");
INSERT INTO sav_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kuɓkiŋ Firawnaana kunissaa, a hotta kuɓu ƴaar ŋ ɗooƴa fuɗeeɗa. Kuɓka misikka ɗe, a woosa ne : « A ɓaah ŋ kuɓuuciŋ Heber ci. » ");
INSERT INTO sav_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Wa taambɗoh kuɓka hot ineem, a woosa ɗe ne : « Fu ɗaas so de', andi fu waaɗiɗ ne ŋ kaɗ ɗa waakɗa ŋ Heber ci ɓitɓi na hee ɗa ɗe ɓapɗiɗe e ? » ");
INSERT INTO sav_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","A woosa ɗe ne : « Ee, kaɗa. » A kaɗta, a hayya na yaayiŋ kuɓka. ");
INSERT INTO sav_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kuɓkiŋ Firawnaana woosa yeem ne : « Ɓayaa ɗe, fu ɓapɗiɗee so ɗe, ŋ hey ɗa wirnde. » Ɓitɓa ɓayya ɗe, a ɓapɗeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Wa kuɓka omb, a wikka kuɓkiŋ Firawnaana ɗe, yeem tummba ɗe kuɓkiŋ ɗe ; a woosa ne : « Ini ŋ nihsoh ɗe ŋ masuɓ tahiɗ po ŋ teekan ɗe Musaa. » ");
INSERT INTO sav_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Wa Musaa nik yakak, a kaɗta marka ɓaah caŋ ɗe Heber ca ; a hotta pangka ɓa degu, na findi wa miskoh ! A nammba hot ƴaar ɓaah ŋ ɓi Misra laɓeeɗa ƴaar Heber laɓ miskiɗ. ");
INSERT INTO sav_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musaa marakka ndeem jen, a hotɗi ɓo', a laɓpa ƴaara genee Misra, a appa ɗe, a uummba fiɗaafiŋ ɗe ŋ merhey mi. ");
INSERT INTO sav_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kooh wiissa, a hayissa, a raakka Heber kanak hiñoheeɗa ; a woosa ƴaara tooñ ne : « Eh ! Wa ye tah fu laɓee ƴaari fu inah ne a ɗu ɓaah ? » ");
INSERT INTO sav_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Waaye ƴaara loffa ɗe ne : « Ya ɓa tum ɗa kilifaaniŋ ɓoo na atte'ohiŋ ɓoo ? Fu waaɗ to nam ap findi fu apoh ƴaariŋ Misraaci e ? » Musaa inahha ne ina a tum inhuuɗ, a neƴƴohha. ");
INSERT INTO sav_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Firawnaana kerahhaa, a waaɗta ɗe ap, waaye a saandohha kur kaŋ Majaan. Wa Musaa ree Majaan, a ɓoof ŋ sero naac. ");
INSERT INTO sav_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Waam seeƴkiɗohaŋ Majaan raakeen kuɓu cafaƴ yasna-kanak. Ɓa kaɗta naaca, ɓa neyya hongol ca, ne ɓa aniɗ pe' ca na mbaal caŋ baab ɓa. ");
INSERT INTO sav_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Waaye ɓi niiɗoh hayya, aannja ɓa na ɗoopaat caŋ ɓa. Weɗi Musaa kurkoh, hirippa ɓa, a anɗiɗta ɓa ɗoopaat ca. ");
INSERT INTO sav_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wa komaakca ɓitiɓ ca haad, Rewyel baab ɓa woosa ɓa ne : « Ca' ! Wa ye tah ɗu teella hay woti ? » ");
INSERT INTO sav_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ɓa loffa ɗe ne : « A ƴaar gen Misra a yi tos ɓoo ŋ niiɗoh ci, a yi neyiɗ ɓoo sah, a aniɗta ɓoo ɗoopaat ci. » ");
INSERT INTO sav_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A woosa ɓa ne : « A nde ƴaara ? Wa ye tah ɗu faɗta ɗe ndaam ? Kaɗaat ɗu ɓeeɗkaa ɗe a ñam na ɓoo book ! » ");
INSERT INTO sav_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ŋ mirndaani Musaa teyɗukka nik ŋ kahan ƴaara, yeem onnda ɗe ɓitiɓ, kuɓkiŋ ɗe na woyse Sefora. ");
INSERT INTO sav_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A raakka na ɗe kuɓu ƴaar, a woosa ne : « Ŋ genohaah ŋ kur jaambur. » Weɗ tah, a teekka kuɓka Geersom. ");
INSERT INTO sav_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Musaa nikka ŋ Majaan in maañiɗ po buuraŋ Misra ŋ jamanoonaam kaannda. Israayel ca rissa ŋ ñaam kaŋ ɓa, ɓa iineeɗa, ɓa leehkeeɗa ; leehuk caŋ ɓa ne ɓa naafu, reesa ŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kooh kerahha ca, a naandsukka ambtiɗohiŋ ɗe na Ibrahiima na Isaahha na Yaŋhooɓa. ");
INSERT INTO sav_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","A marakka ŋ Israayel ca, a inahha ini ɓa nikoh. ");
INSERT INTO sav_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musaa nikka nga, a niiɗeeɗa pe' ca na mbaal caŋ payum ce ƴaar, Yetoro, seeƴkiɗohaŋ Majaan. Raakka mbeh, a ɓayya ca ŋ finho kehƴa hulanga ngaŋ Horeb, ŋ tangooraŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ndaam, malaakaaniŋ Nikiɗi teeɓukka ɗe ŋ ɗooƴ jaal yongkaah, ŋ ɗooƴ kidig ƴin. Musaa hotta kidga ƴina gileeɗa waaye wa dohɗi. ");
INSERT INTO sav_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","A woosa ne : « Faɗa ŋ wel, ŋ kaɗ marka ina feyohɗeen po ŋ inah ini tah kidga ƴineen jaalee te wa dohɗi. » ");
INSERT INTO sav_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Wa Nikiɗi hot ne Musaa weliɗ ne a kaɗa marka, a ɓeeɗkohha ɗe ŋ ɗooƴ kidga ƴina an : « Musaa ! Musaa ! » Musaa loffa ɗe ne : « Yoo. » ");
INSERT INTO sav_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","A woosa ɗe ne : « Kina reɓ ndii, wolsa ñafaɗ ciŋ ɗa, ɗiski fu tufuk wa keheƴ hooliɗ. » ");
INSERT INTO sav_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A degga nga ne : « Ñam Koohiŋ baab ɗu, Koohiŋ Ibrahiima na Isaahha na Yaŋhooɓa. » Musaa ɗasiɗta fikiiriŋ ɗe sagu kaañaaɗiina a kaañeeɗi marak Kooh. ");
INSERT INTO sav_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Nikiɗi woosa ɗe ne : « Ŋ hotiɗ miskiɗi cuuɓi nik wiŋ ngo raak ŋ Misra, ŋ kerhiɗ leehkiŋ ɓa sagu laɓ ciŋ ɓooɓi na torhiɗee ɓa. Ee, ŋ inhiɗ miskiɗiŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ŋ ruhsiɗ ne ŋ pulɗoh ɓa ngaŋ yaah ciŋ ɓi Misra, ŋ ɓay ɓa kur baahiɗ, angiɗ, wi fu inah ne wa riifɗiɗ na miis na kuum. Wa nikka kur kaŋ ɓi Kanaan, na Hit ci, Amoor ci, Peris ci, Hiw ci na Yebuus ci. ");
INSERT INTO sav_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Marka ! Leehuk ciŋ Israayel ci hayiɗ po nga so, te ŋ hotiɗ findi ɓi Misra na torhiɗohee ɓa. ");
INSERT INTO sav_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mbaa kaɗa ŋ Firawna ! Pulɗa Israayel ci, cuuɓiŋ ngo ŋ ndaam. » ");
INSERT INTO sav_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musaa loffa Kooh ne : « Ñam ɓa, ne ŋ kaɗ ŋ Firawna, ne ŋ puliɗ Israayel ci Misra ? » ");
INSERT INTO sav_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kooh woosa ɗe ne : « Ŋ hey nike na ɗa, te ini na hee wa teeɓohe weɗ ne, fu puliɗ Israayel ci Misra ɗah, ɗu na hee so ñaamke ŋ tangoorii. » ");
INSERT INTO sav_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musaa woosa ɗe ne : « Marka ! Ŋ kaɗ ŋ Israayel ca, ŋ woo ɓa ne a Koohiŋ caacuuciŋ ɓa a yi woos so nga ɓa, ɓa woo so ne : “ A teeku na ? ” ɗah, ŋ woyan ɓa na ? » ");
INSERT INTO sav_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kooh woosa ɗe ne : « Ñam yi nik. » A degga nga ne : « Woyaa ɓa ne : “ Yi Nik, a yi woos so nga ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","A woyissa Musaa ne : « Woyaa ɓa ne : “ A Nikiɗi, Koohiŋ caacuuciŋ ɗu Ibrahiima, Isaahha na Yaŋhooɓa, a yi woos so nga ɗu. ” Weem weɗ tiikiŋ ngo po faw, wi mi na hee ɓeeɗkohse jamano nu nik. ");
INSERT INTO sav_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kaɗa fu cohɗoha yakak caŋ Israayel, fu woo ɓa ne : “ Nikiɗi, Koohiŋ caacuuciŋ ɗu Ibrahiima, Isaahha na Yaŋhooɓa, teeɓkiɗ to. A woo ne, a hotiɗ ɗu te a inhiɗ baahiɗ ini rahas ɗu ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Weɗ tah a hey ɗu pulɗohe ŋ miskiɗi ɗu raak nga, a yurhiɗ ɗu ɗiska ɓi Kanaan gen, na Hit ci, Amoor ci, Peris ci, Hiw ci na Yebuus ci ; kur ka fu inah ne wa riifɗoh na riifɗoh na miis na kuum. ” ");
INSERT INTO sav_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Israayel ci hey ɗa kerhiɗe, fu hey hune na yakak ci, ɗu kaɗ ŋ buuraŋ Misra, ɗu woo ɗe ne : “ Nikiɗi, Koohiŋ Heber ci teeɓkiɗ ɓoo, weɗ tah ona ɓoo, ɓoo kaɗ ɗiski ree tiindu neeh kaahay ŋ bilaf fa, ɓoo seeƴuk nga wuu Nikiɗi, Koohiŋ ɓoo. ” ");
INSERT INTO sav_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Waaye ŋ inhiɗ ne buuriŋ Misra teyɗukanɗi ɗu faɗis ne ɗu coot, hanaa a degu yaahi uup ɓit wiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Weɗ tah, ŋ hey raɗse yaahiŋ ngo, ŋ ruhsiɗ ngaŋ Misra ini uup doole ŋ in ciŋ ngo feyohiɗ ci, ŋ ineem, a hey ɗu faɗe ne ɗu coot. ");
INSERT INTO sav_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ŋ hey tume po ɓi Misra naw ɗu te ɗu kaɗee ɗah, ɗu cootanɗi yaah ɓarang. ");
INSERT INTO sav_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ɓitiɓ nu nik nga ɗu ɗah, a hey meekse gentohiŋ ɗe ɓitiɓ, yi gen na ɗe ŋ kahni na yi genɗi na ɗe ŋ kahni, in haɓɗohuuɗ haalis na urus na ɓi kulɓa, ɗu ɓekiɗ kuɓuuciŋ ɗu ca, ƴaar na ɓitiɓ. Ɗu naafohan raak-raakiŋ ɓi Misra ɗaa. » ");
INSERT INTO sav_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musaa loffa Nikiɗi ne : « Marka ! Israayel ci kosanɗi so te ɓa kerhiɗanɗi so, ɓaa hee woye ne Nikiɗi teeɓukɗi so. » ");
INSERT INTO sav_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nikiɗi woosa ɗe ne : « Fu amb ye ŋ yaahiŋ ɗa ? » Musaa loffa ɗe ne : « Wa ndooɗ. » ");
INSERT INTO sav_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","A woosa ɗe ne : « Njafaa ŋ kehƴi. » Musaa njaffaa, wa ɓoƴsukka iiñ ; Musaa saandoheeɗa. ");
INSERT INTO sav_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nikiɗi woosa ɗe ne : « Raɗsa yaah, fu amb ɗe ŋ kose. » A raɗissa yaah, a ammba ɗe. Iiña nikissa ndooɗ ŋ yaahiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nikiɗi woosa ɗe ne : « Inii weɗ fu na hee tume ne Israayel ci kos ne e mi teeɓuk ɗa, mi yi Nikiɗi, Koohiŋ caacuuciŋ ɓa, Koohiŋ Ibrahiima, Isaahha na Yaŋhooɓa. » ");
INSERT INTO sav_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nikiɗi woyissa ɗe ne : « Ooɓa yaahiŋ ɗa ŋ daɗiŋ ɗa. » Musaa ooɓpaa, a nihissa nihis rek, hotta wa oɓsukiɗ po wa nikka yaanow. ");
INSERT INTO sav_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nikiɗi woosa ɗe ne : « Ooɓisaa ŋ daɗiŋ ɗa. » A ooɓissaa, wa a nihissa, wa dokkissa moɗoɗ findi faaniŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nikiɗi woosa ɗe ne : « Israayel ci kosɗi ɗa te ɓa kosɗi ŋ firndeeni koc ɗah, mbaa ɓa hey kose ŋ wi mirndoh. ");
INSERT INTO sav_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ɓa kosɗi ŋ firndeeci kanak ci te ɓa sikɗukɗi ɗa ɗah, fu hey ɓaye ŋ masmaŋ kalaŋ Niil, fu yiifa ŋ merhey mi ; masmi fu ɓay weem, hey ɓoƴsuke ñif ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Wa Nikiɗi woo in ceem jen, Musaa woosa ɗe ne : « Ɗaas so Heɗ ɓoo, ñaamiŋ ɗa woyoh haa, ŋ moosɗi minoh woo, wa wotɓa haa, wa wisetɓa haa te wa ina fu woyoh na so haa. Ali in ɓoƴsukɗi nga, a woo kiŋ ngo weɗ ñiinɗi. » ");
INSERT INTO sav_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nikiɗi loffa ɗe ne : « Ya ɓa waakiɗ ɓo' nguɓ ? Ya ɓa na muumɗe, ɗikɗe, hotɗe wala a fuulɗe ? A mi yi Nikiɗi haa e ? ");
INSERT INTO sav_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Mbaa, kaɗa ! Mi ŋ haf fo, ŋ hey nike na ɗa ne fu jombee ɗah ; ŋ hey ɗa teeɓe in ci fu joy woo. » ");
INSERT INTO sav_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musaa woosa ɗe ne : « Cooy, Heɗ ɓoo, ɗaas so, fu miniɗ woos ɓo' wiiriis. » ");
INSERT INTO sav_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ŋ ineem, Nikiɗi ayrukka ɗe lool, a woosa ne : « Moo, Aaruna yakak fu, yi ɓaah na ɗa cuuɓiŋ Lewi nak ? Ŋ inhiɗ ne a miniɗ jomb baahiɗ, a yii ŋ waas na hee cohe na ɗa, te a hot ɗa ɗah, keeñiŋ ɗe hey soose. ");
INSERT INTO sav_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Fu hey ɗe woye ini a joy woo, mi ŋ haf fo, ŋ hey nike na ɗu, ɗu kanak ne ɗu woyee ɗah, te ŋ hey ɗu teeɓe in ci ɗu joy haɓiɗ. ");
INSERT INTO sav_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A yi na hee ɗa woyɗe na ɓooɓi, a nik tassiɗohiŋ ɗa, fu mand nga ɗe findi Kooh na woyohe na woosuuɗiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Amba ndooɗii ŋ yaahiŋ ɗa, fu tumohee wa firnde. » ");
INSERT INTO sav_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Weɗi Musaa gurdoh ŋ Yetoro, payum ce ƴaar, a woosa ɗe ne : « Mi yii kiim ɗa, on ndo, ŋ waaɗ dokuk ŋ ɓaah caŋ ngo Heber ca ŋ Misra, ŋ marak andi ɓa ris pes wala. » Yetoro woosa ɗe ne : « Ee kaɗa ŋ jam. » ");
INSERT INTO sav_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Raak Nikiɗi woyeen na Musaa ŋ kur kaŋ Majaan ne : « Kaɗa, dokka Misra, ɓooɓa waaɗee ɗa ap jen ɓa kaaniɗ. » ");
INSERT INTO sav_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Weɗi a ɓayoh ɓitiice na kuɓuuciŋ ɗe, a rapiɗta ɓa ŋ mbaam, a kaɗeeɗa Misra. A ammba ndooɗaŋ Kooh ŋ yaah. ");
INSERT INTO sav_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nikiɗi woosa ɗe ne : « Ɗiski wa nik, fu yii dokkeeɗa Misra. Amba in ci feyohiɗ ci ŋ eɗ ɗa. Tuma po fu haɓiɗ ca ŋ fiki Firawna, waaye ŋ hey ndengɗe keeñiŋ ɗe po a faɗanɗi cuuɓiŋ ɗu ne wa kaɗ. ");
INSERT INTO sav_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Teemb ndeem, fu hey ɗe woye ne inii weɗ Nikiɗi woo : “ Israayel a yi saawiŋ ngo, ");
INSERT INTO sav_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ŋ woyeen ɗa ne faɗaa ɗe a kaɗ to ñaamka, fu sannga ; marka, ñam yii na hee ape kuɓkiŋ ɗa saawi. ” » ");
INSERT INTO sav_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Wa ɓa na kaɗe, ŋ ɗiska ɓa iɗsiɗke, Nikiɗi raakka Musaa nga, a waaɗta ɗe ap. ");
INSERT INTO sav_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sefora arra ɓay atoh kaañiɗ, a nguɗta sumtaahiŋ kuɓkiŋ ɗe, a laaliɗta ɗe wa ŋ kot, a woosa ɗe ne : « Fu ƴaar ro ŋ ñif. » ");
INSERT INTO sav_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nikiɗi faɗta ɗe. Sefora woyeen ineem sagu nguɗka. ");
INSERT INTO sav_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nikiɗi woyeen Aaruna ne : « Kaɗa ŋ bilaf fa fu coha na taambɗoh fu Musaa. » A kaɗta a raakka ɗe ŋ tangooraŋ Kooh, a morgiɗukka ɗe. ");
INSERT INTO sav_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musaa woosa ɗe in ca Nikiɗi woos ɗe jen, a nammba ɗe woo in ca feyohiɗ ca a nak ɗe ne a tum ca jen. ");
INSERT INTO sav_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ɓa kaɗta, wa ɓa ree Misra, ɓa cohɗohha yakak caŋ Israayel jen. ");
INSERT INTO sav_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaruna woosa ɓa in ca Nikiɗi woo Musaa jen. A nammba tum in ca feyohiɗ ca ŋ fiki ɓooɓaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ɓa kossa, ɓa inahha ne Nikiɗi hotiɗ ɓa na findi ɓa na torhiɗohse ŋ Misra, ɓa ƴekka ne ɓa ñaamuk. ");
INSERT INTO sav_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Wa coha reeh, Musaa na Aaruna kaɗta ŋ Firawna, ɓa woosa ɗe ne : « Inii weɗ Nikiɗi, Koohiŋ Israayel woo : “ Faɗa cuuɓiŋ ngo ɓa kaɗ haɓɗa feet wuu so ŋ bilaf fa. ” » ");
INSERT INTO sav_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawna loffa ne : « Ya ɓa Nikiɗi po ŋ kerhiɗee ɗe ŋ faɗee Israayel ci ne ɓa coot ? Ŋ inahɗi Nikiɗi te ŋ heyɗi faɗe Israayel ci ne ɓa coot. » ");
INSERT INTO sav_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ɓa woosa ɗe ne : « Koohiŋ Heber ci, a yi teeɓuk ɓoo. Ne wa neɓ ɗa ɗah, ona ɓoo, ɓoo kaɗ ɗiska ree tiindu neeh kaahay ŋ bilaf fa, ɓoo seeƴuk nga wuu ce, bala a laɓan ɓoo na kosaay ki na kaɓkohe ɗah, wala a tuuƴ kur wiiriis ne ɓa hiñoh na ɓoo. » ");
INSERT INTO sav_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","A loffa ɓa ne : « Musaa, fu na Aaruna, wa ye tah ɗu ɓekee ɓooɓi ngaŋ faɗ pangkiŋ ɓa ? Dokkaat ŋ pangkaŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Weɗi, ɗu waaɗ nguɗ pangkiŋ ɓooɓii te ɓa laayiɗ ŋ kur ki. » ");
INSERT INTO sav_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mbaɗi mbaɗi, Firawna nakka Israayel ca adgohee pangka na Misraaca niiɗee ɓa ne : ");
INSERT INTO sav_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","« Kotii, kinaat eɗis Israayel ci mbaang haɓɗoha muul findi ɗu meeɗ tumoh, ɓa kaɗootaat waaka, ");
INSERT INTO sav_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ɗu na hee ɓa muulɗukohe muul hend na ca ɓa meeɗ haɓiɗ. Kinaat haawis ali in nga, ɓa na tiriɓ tiriɓɗuke weɗ tah ɓa leehkee ne ɓa waaɗ kaɗ seeƴka wuu Koohiŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Sifaat ɓa panguk po ɓa talissanɗi sikɗuk lee. » ");
INSERT INTO sav_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Weɗ ɓooɓa adgohee pangka, na ɓa niiɗee ɓa, kurkoh ŋ ɗiskaŋ Firawna, ɓa kaɗta ŋ Israayel ca, ɓa woosa ɓa ina Firawna woo an : « Ɗu heyɗi eɗissasse mbaang, ");
INSERT INTO sav_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","kaɗaat ɗu waakootaa ŋ ɗiska ɗu mina raakoh ɗah, te ali in haawsassanɗi ŋ pangkiŋ ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Wa ɓa kerah woo ceem, Israayel ca pasarkohha ŋ ɗooƴ Misra jen, ɓa parheeɗa tas caŋ mbaang ca sagu hotaaɗi mbaang. ");
INSERT INTO sav_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ɓooɓa niiɗee pangkoh ca ngaseeɗa ɓa, an : « Kooh-nu-wiis ɗah, ɗu na hee haɓɗe muul hend na ca ɗu meeɗ haɓiɗ, findi wa ɗu meeɗ eɗu mbaang, te pangkiŋ ɗu mitaat nak ! » ");
INSERT INTO sav_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ɓa kaɗeen po ɓa meeɗta laɓ ɓa kooɗsee ŋ Israayel ca ne ɓa adgoh pangka. Ɓa hay ɗah, ɓa woyee ɓa ne : « Wa ye tah ɗu mitiɗɗi muul ci ɗu naksee neeh cii, findi ɗu meeɗa tumoh ? » ");
INSERT INTO sav_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Israayel ca adgohee pangka kaɗta ŋ Firawna, ɓa woosa ɗe ne : « Moo kilifaani ! Wa ye tah po fu tumohee na ñaam ciŋ ɗa an ? ");
INSERT INTO sav_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ɓa eɗisɗi ɓoo mbaang, ɓa na woye ɓoo ne ɓoo haɓɗaat muul te ɓa laɓee ɓoo, ini ɓooɓiŋ ɗa na haɓɗe waas haa. » ");
INSERT INTO sav_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Firawna loffa ne : « Ɗu na tiriɓɗuke weɗ tah ɗu woyee ne ɗu waaɗ kaɗ seeƴka wuu Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Acca ! Kaɗaat ɗu pangka ! Ɗu heyɗi eɗse mbaang te ɗu muulan hend na ci ɗu naku. » ");
INSERT INTO sav_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ɓa hotta ne ina ɓa nikoh miskiɗ, sagu ina ɓa woyu ne : « Ali in haawsassanɗi nga ! » ");
INSERT INTO sav_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Wa ɓa puloh ɗiskaŋ Firawna, ɓa cohha na Musaa na Aaruna, raak ɓeem sekeeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ɓa woosa ɓa ne : « Nikiɗi hotaat ini ɗu haɓiɗ, a atte. Ɗu tahiɗ po in ciŋ ɓoo na ote ot Firawna na dag ciŋ ɗe. Ini ɗu haɓiɗ, wa mand haa, ɗu eɗ ɓa ndang ne ɓa ap ɓoo. » ");
INSERT INTO sav_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Weɗi Musaa wiirkoh ŋ Nikiɗi a woosa ɗe ne : « Moo Nikiɗi ! Wa ye tah fu tumee cuuɓii miskiɗ ? Wa ye tah fu woossa so ndii ? ");
INSERT INTO sav_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ina fu woosoh ho ŋ Firawna poyi, ɓa na tume cuuɓiŋ ɗa miskiɗ te fu haɓiɗɗi in, ne fu muciɗa. » ");
INSERT INTO sav_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nikiɗi woosa Musaa ne : « Ɗiski wa nik ndii kotii, fu hey hote ini ŋ tuman Firawna. Wa yaah ɓitiɗ weɗ na hee tahe po ɗu faɗsu ɗu coot te yaaheem weɗ na hee tahe a aañ ɗu, ɗu coot. » ");
INSERT INTO sav_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kooh woyissa Musaa ne : « Mi, a mi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ŋ teeɓkee Ibrahiima na Isaahha na Yaŋhooɓa ne ŋ Koohi Min. Waaye ŋ teeɓkeeɗi ɓa ŋ Nikiɗi, tiikiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ŋ namiɗ ambtiɗoh na ɓa ; ŋ gappa ɓa on kur kaŋ Kanaan wa ɓa nikohee findi hanhe. ");
INSERT INTO sav_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ɓaatta nga, ŋ kerhiɗ leehuk ciŋ Israayel ci ɓi Misra tum ñaam, te yit, ŋ naandsukiɗ ambtiɗohiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Weɗ tah po, woyiɗ to Israayel ci ne : “ Ñam Nikiɗi, ŋ hey ɗu pulɗohe ŋ pangkiŋ ɗu miskiɗi, wi ɓi Misra deg ɗu, ŋ muciɗ ɗu ŋ kiñaamki ɗu nikoh. Na hatiliŋ yaahiŋ ngo, ŋ hey ɗu wirndukɗe na miskiɗ laayiɗ, ŋ tos ɗu nga ɓa. ");
INSERT INTO sav_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ŋ hey ɗu tume cuuɓiŋ ngo, ŋ nik Koohiŋ ɗu. Ɗu hey inhe ne ñam Nikiɗi Koohiŋ ɗu, yi pulɗoh ɗu ŋ pangki miskiɗi ɓi Misra deg ɗu. ");
INSERT INTO sav_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ŋ hey ɗu ɓaye ŋ kur ka ŋ giñee ne ŋ hey wa one Ibrahiima, Isaahha na Yaŋhooɓa. Ŋ hey ɗu wa one, ɗu raakoota, ñam Nikiɗi. ” » ");
INSERT INTO sav_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musaa ɓayoh woo ceem ɗaa ŋ Israayel ca waaye ɓa sikɗukɗi ɗe sagu tiisa na kiñaamka miskiɗa ɓa nikohe. ");
INSERT INTO sav_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Wa Musaa ƴut woo na Israayel ca, Nikiɗi woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","« Kaɗa fu woya na Firawna, buuraŋ Misra, a faɗ Israayel ci ɓa pul kur ce. » ");
INSERT INTO sav_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musaa loffa Nikiɗi ne : « Israayel ci sah sikɗukɗi so, moo Firawna na hee so sikɗukohe na, mi yi minɗi woo ? » ");
INSERT INTO sav_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Waaye Nikiɗi woosa na Musaa na Aaruna, a eɗta ɓa ɓi nakoh ŋ ini kaɗ ŋ Israayel ca na Firawna buuraŋ Misra, ne Israayel ca pulɗu Misra. ");
INSERT INTO sav_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ɓii ɓeɗ kilifaaci, heɗ kahan ciŋ Israayel. Kuɓuuciŋ Ruben yi saawiŋ Yaŋhooɓa nikee : Hanook, Pallu, Hesroon na Karmii. Ɓeem ɓeɗ nikee kilifa ŋ cuuɓ ci puloh ŋ Ruben. ");
INSERT INTO sav_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Kuɓuuciŋ Simeyong nikka : Yemuwel, Yamiin, Ohad, Yakiin, Sohar na Sawul yi yaay ɓa ɓaahee ŋ ɓi Kanaan. Ɓeem ɓeɗ nikee kilifa ŋ cuuɓ ci puloh ŋ Simeyong. ");
INSERT INTO sav_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Cii ceɗ tiik ciŋ ɓi rimkoh ŋ Lewi, na ɓi rimkoh nga ɓa. Kuɓuuciŋ Lewi nikee : Geerson, Kehaat na Meraari. Lewi pesiɗ kiis teemet na kiis ndaŋkiyaah-kaahay na kiis yasna-kanak (137). ");
INSERT INTO sav_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kuɓuuciŋ Geerson nikee Libni na Semeyi, ɓeɗ nikee caaciŋ cuuɓ ciŋ ɓa haf ɓa. ");
INSERT INTO sav_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kuɓuuciŋ Kehaat nikka Amraam, Isaar, Hebron na Usiyel. Kehaat pesiɗ kiis teemet na kiis ndaŋkiyaah-kaahay na kiis kaahay (133). ");
INSERT INTO sav_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Kuɓuuciŋ Meraari nikka Mahli na Muusi. Ɓeem ɓeɗ nikee kilifa ŋ ɓooɓiŋ Lewi, yaa nu nga ɗah, na cuuɓiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraam tokee bajaniŋ ɗe na woyse Yokebet, a raakka na ɗe kuɓu ƴaar kanak Aaruna na Musaa. Amraam pesiɗ kiis teemet na kiis ndaŋkiyaah-kaahay na kiis yasna-kanak (137). ");
INSERT INTO sav_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Kuɓuuciŋ Isaar nikee Kore, Nefek na Sikri. ");
INSERT INTO sav_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Kuɓuuciŋ Usiyel nikka Mikayel, Elitsaafaan na Sitri. ");
INSERT INTO sav_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaruna tokee Eliseba kuɓu Aminadaab, a raakka na ɗe kuɓu ƴaar nikiis : Nadab, Abihu, Elasaar na Itamaar. Eliseba namee nik taambɗoh Nahson. ");
INSERT INTO sav_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kuɓuuciŋ Kore nikee Asiir, Elkana na Abyasaf. Ɓeem ɓeɗ nikee kilifa ŋ cuuɓ ci puloh ŋ Kore. ");
INSERT INTO sav_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elasaar kuɓkiŋ Aaruna tokee ŋ kuɓuuciŋ Putiyel, a raakka na ɗe kuɓu ƴaar, Pinhas. Ɓeem ɓeɗ nikee kilifa ŋ cuuɓ ci puloh ŋ Lewi. ");
INSERT INTO sav_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E Aaruna yeem na Musaa yeem, ɓeɗ Nikiɗi nakee ne ɓa puliɗ Israayel ca Misra, ɓa adgiɗoh cuuɓ cuuɓ, ɓa kaɗe. ");
INSERT INTO sav_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","E ɓeɗ ɓeem, ɓeɗ woyee na Firawna buuraŋ Misra ne a faɗ Israayel ca ɓa pul ŋ kur ce. ");
INSERT INTO sav_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mbeha Nikiɗi woyoh na Musaa ŋ Misra, ");
INSERT INTO sav_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","a woyee ɗe ne : « Ñam Nikiɗi, kaɗa fu woya Firawna buuraŋ Misra in ci ŋ woo ɗa jen. » ");
INSERT INTO sav_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Waaye Musaa lofee Nikiɗi ne : « Fu hot nga, ŋ tasiɗ min woo ; Firawna na hee so na sikɗukohe ? » ");
INSERT INTO sav_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nikiɗi woosa Musaa ne : « Marka ! Ŋ tumiɗ ɗa fu mand findi Kooh ŋ fiki Firawna, yakak fu Aaruna a yi na hee nike findi woosuuɗiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Fu na hee ɗe woye in ci ŋ nakan ɗa jen, a yi na hee woye na Firawna, ne a faɗ Israayel ci ɓa pul kur kiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ŋ hey ndengɗe keeñiŋ ɗe, te ŋ ruhsiɗ firnde na keemaan laayiɗ ŋ Misra ; ");
INSERT INTO sav_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","waaye a sikɗukanɗi ɗu. Ŋ hey teeɓohe hatiliŋ yaahiŋ ngo ŋ Misra, ŋ deg ɓa miskiɗ laayiɗ te ŋ puliɗ cuuɓiŋ ngo, Israayel ci, ŋ kur kiŋ ɗe, wa hun cuuɓ cuuɓ. ");
INSERT INTO sav_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ŋ raɗis yaahiŋ ngo, ŋ deg ɓi Misra wa, ŋ puliɗ Israayel ŋ kur kiŋ ɓa ɗah, ɓi Misra hey inhe ne ñam Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musaa na Aaruna tumoheeɗa in ceem ɗaa findi Nikiɗi woyohee ɓa. ");
INSERT INTO sav_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musaa raakeen kiis ndaŋkiyaah-yasna-kaahay (80), Aaruna raakka kiis ndaŋkiyaah-yasna-kaahay na kiis kaahay (83) wa ɓa na woye na Firawna. ");
INSERT INTO sav_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Wa Nikiɗi woo na Musaa na Aaruna woo ceem, a dokkissa, a woosa ɓa ne : ");
INSERT INTO sav_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","« Firawna woo ɗu ne : “ Teeɓohaat firnde ” ɗah, fu yi Musaa, woya Aaruna ne a ɓayaat ndooɗiŋ ɗe, a njafa ŋ fiki Firawna, wa hey ɓoƴsuke iiñ. » ");
INSERT INTO sav_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musaa na Aaruna kaɗta ŋ Firawna, ɓa haɓɗohha in ceem ɗaa, findi Nikiɗi nakohee ɓa wa. Aaruna ɓayya ndooɗaŋ ɗe, a njaffaa ŋ fiki Firawna na dag caŋ ɗe, wa ɓoƴsukka iiñ duu'in. ");
INSERT INTO sav_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Firawna ɓeeɗukka naah ca na ñiingo'oh caŋ Misra. Heɗ haf ceem nammba haɓiɗ ŋ in caŋ ɓa in mand ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yaa nu nga ɗah njaffa ndooɗaŋ ɗe ŋ kehƴi, wa ɓoƴsukka iiñ. Waaye waŋ Aaruna onnda caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hondohɗi, keeñiŋ Firawna ndennga, findi Nikiɗi woyohee wa. A sannga sikɗuk Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Wa Firawna sang sikɗuk, Nikiɗi woosa Musaa ne : « Firawna faɗanɗi ɗu ne ɗu coot, a ndeng ndeng keeñ. ");
INSERT INTO sav_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kaɗa fu coha na ɗe kim na ɓaaɓa teel, ŋ wahtuuni a na kaɗohe kala, fu tufuk ŋ fikiice ŋ sereendaŋ wa, ɓayndoha ndooɗi ɓoƴsukee iiñ, ");
INSERT INTO sav_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","fu woo ɗe ne : “ Nikiɗi Koohiŋ Heber ci, a yi woos so nga ɗa, a woo ne : ‘Faɗa cuuɓiŋ ɗe wa kaɗ ɗe ñaamka ŋ bilaf fa.’ Waaye fu sikɗukɗi poyi ! ");
INSERT INTO sav_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Nikiɗi woo ne ngaŋ in cii, fu hey inhe ne a yi Nikiɗi. Marka ! Ŋ hey ɓaye ndooɗii ŋ yaahiŋ ngo, ŋ laɓa ŋ kali, wa ɓoƴsuk ñif. ");
INSERT INTO sav_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Cuurund ci kaan, masmiŋ kali otee po ɓi Misra minissanɗaa an. ” » ");
INSERT INTO sav_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nikiɗi woyissa Musaa ne : « Woya Aaruna, a ɓay ndooɗiŋ ɗe, a raɗisa, ŋ ɗisik ci masuɓ raak jen ŋ Misra, kal ci na huluɓ ci, na laah ci na ɗisik ci raak masuɓ jen ne ca ɓoƴsuk ñif. Kur ki jen hey raake ñif po ŋ hongol ci na mbalkaaci. » ");
INSERT INTO sav_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musaa na Aaruna haɓɗohha in ceem ɗaa findi Nikiɗi woyohee ɓa. Ŋ fiki Firawna na dag caŋ ɗe, Aaruna ɓayya ndooɗaŋ ɗe, a laɓpaa ŋ Niil, masma jen ɓoƴsukka ñif. ");
INSERT INTO sav_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Cuurund ca kaannda, masma oteeɗa, ɓi Misra minisɗaa an, kur ka jen raakka ñif. ");
INSERT INTO sav_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ŋ ineem, heɗ haf ca nik ŋ Misra nammba haɓiɗ in mand ɗaa na in caŋ ɓa. Findi Nikiɗi woyohee wa, keeñiŋ Firawna nikka ndengiɗ. A sannga sikɗuk Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","A eɗta ɓa finho, a haadda kahan ce buglassaaɗi. ");
INSERT INTO sav_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ɓi Misra jen mineeɗi an masmaŋ kala weɗ tah po ɓa aceeɗa ŋ sereendaŋ wa ne ɓa raak masuɓ moɗiɗ. ");
INSERT INTO sav_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sota Nikiɗi sotee kala tumeen neeh yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Wa ineem coot, Nikiɗi woosa Musaa ne a kaɗ ŋ Firawna a woo ɗe ne : « Nikiɗi woo ne fu faɗ cuuɓiŋ ɗe wa kaɗ ɗe ñaamka. ");
INSERT INTO sav_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Fu sang ɗah, marka, a hey ruhsiɗe mboɓ laayoh na laayoh ŋ kur kiŋ ɗa, ");
INSERT INTO sav_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","kali hey riife na mboɓ, ca pulohan nga, ca aas ŋ ɗooƴ kur ki jen, ca hey kaɗe po ca ree ɗisik ci na siiɓohse mun na ci na utohse mbuuru. Ca hey name nik ŋ kahan ciŋ ɓooɓiŋ ɗa na ciŋ dag ciŋ ɗa. Ca aas ŋ ɗooƴ kahan fu, ca hey ree tuuƴ fu po fiƴaangi fu na faankohe sah. ");
INSERT INTO sav_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Ee di' ! Ca hey rape ŋ ɗafuk ɓooɓiŋ ɗa, na dag ciŋ ɗa po fu sah. » ");
INSERT INTO sav_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nikiɗi woyissa Musaa ne : « Woya Aaruna, a ɓay ndooɗi, a raɗisa ŋ kal ci, huluɓ ci na laah ci, mboɓ ci hay, ca riif kur ki. » ");
INSERT INTO sav_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aaruna ɓayya ndooɗa, a raɗissaa ŋ ɗisik ca raak masuɓ ŋ Misra, mboɓ ca pulohha nga ca, ca riiffa kur ka. ");
INSERT INTO sav_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Heɗ haf caŋ Misra haɓiɗta mand ɗaa na in caŋ ɓa, ɓa nammba ɓek mboɓ laayiɗ ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Firawna ɓeeɗukka Musaa na Aaruna a woosa ɓa ne : « Kiimaat Nikiɗi, a saɓsoh ɓoo na mboɓ cii, mi na ɓooɓiŋ ngo. Ŋ hey faɗe Israayel ci ɓa kaɗ seeƴka wuu ce. » ");
INSERT INTO sav_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musaa loffa ɗe ne : « Ee, a fu kilifaani, woya mbehi fu waaɗoha, ŋ hey ɗa kiimɗe fu na dag ciŋ ɗa na ɓooɓiŋ ɗa ne Nikiɗi ap mboɓ ci nik ŋ kahan fu ; ali mboɓ tasanɗi ŋ kur ki ɗal ŋ ɗooƴ kali. » ");
INSERT INTO sav_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Firawna woosa ɗe ne : « Tuma ineem kim. » Musaa woosa ɗe ne : « Ee, ŋ hey wa tume findi fu woyoha po fu inah ne ali in hendɗi na Nikiɗi, Koohiŋ ɓoo. ");
INSERT INTO sav_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mboɓ ci hey saɓsukohe na ɗa na ɓi kahan fu na dag ciŋ ɗa na ɓooɓiŋ ɗa. Ali mboɓ tasanɗi nga ɗal ŋ kali. » ");
INSERT INTO sav_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musaa na Aaruna pulohha ɗiskaŋ Firawna. Musaa kiimmba Nikiɗi ŋ ini kaɗ ŋ mboɓ ca a ruhsiɗ ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nikiɗi teyɗukka kiimaŋ Musaa, mboɓ ca kaannda ŋ ɗooƴ kahan ca, na kur ca na yohon ca. ");
INSERT INTO sav_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ɓa nangɗohha ca juuk juuk. Kur ka jen oteeɗa ot. ");
INSERT INTO sav_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Findi Nikiɗi woyohee wa, Firawna hotta ne ngisoh raakiɗ ŋ kur ka, a ndengiɗta keeñiŋ ɗe. A sikɗukɗi Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Wa Firawna sang ɓa sikɗuk, Nikiɗi woosa Musaa ne : « Woya Aaruna, a raɗis ndooɗiŋ ɗe, a laɓa ŋ kehƴi, ɗuukriŋ merhey mi hey kurke, wa ɓoƴsuk ɓok ŋ ɗooƴ Misra jen. » ");
INSERT INTO sav_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Musaa na Aaruna haɓiɗta ineem findi Nikiɗi woyoha. Aaruna raɗissa ndooɗa, a laɓpaa ŋ kehƴi, ɗuukriŋ merhey miŋ kur ka jen kurukka, wa ɓoƴsukka ɓok. Ca riiffa kur ka, ca nikka ŋ ɓooɓa na ɗoopaat ca. ");
INSERT INTO sav_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Heɗ haf caŋ Misra jeemmba hayiɗ ɓok na in caŋ ɓa, waaye ɓa minɗaa. Ɓok ca taalndiɗta, ca nikka ŋ ɓooɓa na ɗoopaat ca. ");
INSERT INTO sav_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Heɗ haf ca woosa Firawna ne : « Yaahiŋ Kooh weɗ haɓiɗ inii. » Waaye, findi Nikiɗi woyohee wa, keeñiŋ Firawna rissa ndengiɗ, a sikɗukɗi Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Wa Firawna sang ɓa sikɗuk, Nikiɗi woosa Musaa ne : « Kim na ɓaaɓa teel ɗah, kurka fu kaɗ coha na Firawna ŋ wahtuuni a na kaɗohe kala, fu woo ɗe ne : “ Nikiɗi woo ne, fu faɗ cuuɓiŋ ɗe wa kaɗ ɗe ñaamka. ");
INSERT INTO sav_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Fu sang ɗah, marka ! A hey ɓeke caakoof laayoh na laayoh ŋ ɓooɓiŋ ɗa na dag ciŋ ɗa na ɗa. Ee di' ! Ca riif kahan ciŋ ɓi Misra, ca ul merhey miŋ kur ki. ");
INSERT INTO sav_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mbaɗi a hey talsohe Gosen, wi cuuɓiŋ ɗe genoh, po ali caakoof reyanɗi nga. Teemb ndeem, fu hey inhe ne a yi Nikiɗi nik ŋ kur kii. ");
INSERT INTO sav_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","A hey tose cuuɓiŋ ɗe ŋ in ci miskiɗ ci aa hee ruhsiɗe ŋ cuuɓiŋ ɗa te wa nikan kim. ” » ");
INSERT INTO sav_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nikiɗi haɓɗohhaa ɗaa, caakoof laayiɗ tummba eel suusus yakak, ca yipukka ŋ kahan Firawna, na kahan caŋ dag caŋ ɗe na kur ka ; Misra yahrukohha. ");
INSERT INTO sav_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Firawna ɓeeɗukka Musaa na Aaruna a woosa ɓa ne : « Kaɗaat ɗu seeƴka wuu Koohiŋ ɗu, waaye wa nikaat ŋ ɗooƴ kur ki. » ");
INSERT INTO sav_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musaa loffa ɗe ne : « Muk ! Ineem waas haa, wa in tiimbuuɗ nga ɓi Misra. Ɓa waaɗɗi seeƴuk ci ɓoo joy seeƴuk wuu Nikiɗi Koohiŋ ɓoo. Ɓoo tuma ŋ has ciŋ ɓa ɗah, ɓa tapanɗi ɓoo atoh po ɓoo kaan e ? ");
INSERT INTO sav_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ɓoo joy kaɗ ini ree tiindu neeh kaahay ŋ bilaf fa, ɓoo seeƴuk nga wuu Nikiɗi, Koohiŋ ɓoo findi a woyoh ɓoo. » ");
INSERT INTO sav_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Firawna woosa ɓa ne : « Ee, ŋ hey ɗu faɗe ɗu kaɗ ŋ bilaf fa ɗu seeƴka wuu Nikiɗi Koohiŋ ɗu, waaye kinaat us lool te kiimɗaat to. » ");
INSERT INTO sav_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musaa woosa ɗe ne : « Marka ! Ŋ pulee ndii ɗah, ŋ hey kiime Nikiɗi, kim a saɓsoh ɗu na caakoof ci, fu na dag ciŋ ɗa na ɓooɓiŋ ɗa. Waaye kina ɓoo ñaañohis, fu sangoh Israayel ci ne ɓa kaɗ seeƴka wuu Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musaa kurkohha ɗiskaŋ Firawna, a kiimmba Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nikiɗi teyɗukka kiimaŋ ɗe, a saɓsohha Firawna na caakoof ca, a yi na dag caŋ ɗe na ɓooɓaŋ ɗe. Ali caakoof tasisɗi ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Waaye Firawna taalndiɗta, a ndengɗissa keeñiŋ ɗe. A sannga faɗ Israayel ca ne ɓa coot. ");
INSERT INTO sav_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Wa Firawna sang, Nikiɗi woosa Musaa ne : « Kaɗa ŋ Firawna, fu woo ɗe ne : “ Nikiɗi Koohiŋ Heber ci woo ne, faɗa ɓooɓiŋ ɗe ɓa kaɗ ɗe ñaamka. ");
INSERT INTO sav_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Fu sang, fu ris ɓa amb ɗah, ");
INSERT INTO sav_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","marka, a hey dege yaahiŋ ɗe ŋ ɗoopaat ciŋ ɗa, kosaay miskiɗ wi na kaɓkohe ruhus ŋ panis ci, mbaam ci, ngeelemb ci, inoh ci, mbaal ci na pe' ci. ");
INSERT INTO sav_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Waaye Nikiɗi hey talsohe ɗoopaat ciŋ ɓi Misra na ciŋ Israayel ci, ali yino kaananɗi ngaŋ ciŋ Israayel ci. ");
INSERT INTO sav_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","A gapiɗ naamooneem, wa nikan kim ngaŋ kur ki. ” » ");
INSERT INTO sav_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wa Kooh wiis, Nikiɗi tummba ina a woyee, ɗoopaat caŋ ɓi Misra kaannda ŋ kur ka jen, waaye ali yino kaanɗi ŋ caŋ Israayel ca. ");
INSERT INTO sav_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Weɗi Firawna woosoh ɓi ɓo' ne ɓa meeksoh, waaye a woyuusa ne ali ɗoopaat yino kaanɗi ŋ caŋ Israayel ca po ya uup ƴissuut sah ! Hondohɗi keeñiŋ ɗe rissa ndengiɗ, a faɗɗi Israayel ca ne ɓa coot. ");
INSERT INTO sav_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Wa Firawna sang ɓa faɗ, Nikiɗi woosa Musaa na Aaruna ne : « Nuyaat ɗuund ŋ yaah ciŋ ɗu po ca riif, ŋ utohaani ; hey ɗah, Musaa njafa ŋ ɗafki, ŋ fiki Firawna. ");
INSERT INTO sav_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ɗuundeem hey ɓoƴsuke ɗuuku, wa ruhus ŋ kur kiŋ Misra jen, ŋ ɓooɓi, na ɗoopaat ci, wa tum ufis ci na hee pulɗe mapuuƴ ŋ faan ciŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Musaa na Aaruna ɓayya ɗuunda, Musaa njaffaa ŋ ɗafka ŋ fiki Firawna, wa tummba ufis ca na pulɗe mapuuƴ ŋ faan caŋ ɓooɓa na ɗoopaat ca. ");
INSERT INTO sav_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Heɗ haf caŋ Misra minɗi tufuk ŋ fiki Musaa sagu riifa ɓa riifee na ufis ca, findi ɓi Misra jen. ");
INSERT INTO sav_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Findi Nikiɗi woyohee wa Musaa, a ndengiɗta keeñiŋ Firawna, yeem sikɗukɗi Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Wa Firawna sang ɓa sikɗuk, Nikiɗi woosa Musaa ne : « Kurka kim na ɓaaɓa teel fu kaɗ ŋ Firawna, fu woo ɗe ne : “ Nikiɗi, Koohiŋ Heber ci woo ne : Faɗa ɓooɓiŋ ɗe ɓa kaɗ ɗe ñaamka. ");
INSERT INTO sav_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Waasii a hey ruhsiɗe ŋ ɓooɓiŋ ɗa na dag ciŋ ɗa na ɗa sah, naamoociŋ ɗe jen, ci na hee ɗa miske ŋ keeñ. Wa teeɓ ɗa ne, ali in hendɗi na Nikiɗi ŋ kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Te a raɗseen yaahiŋ ɗe a laɓ ɗa na kosaay ki na ape ɗah, fu heeɗi nikisse ŋ kehƴii, fu na ɓooɓiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Waaye a yi tufkiɗ ɗa ne a min ɗa teeɓ hatiliŋ ɗe te tiikiŋ ɗe wil kehƴi jen. ");
INSERT INTO sav_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Te fu taalndiɗiɗ, fu ris ndeng haf ŋ ɓooɓiŋ ɗe, fu sangiɗ ɓa faɗ ne ɓa coot, ");
INSERT INTO sav_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","weɗi tah, marka, kim ŋ wahtuunii, a hey toɓe atoh galacaac raakiɗ hatil, mand naa raakohɗi ndii, ina Misra nikoh poyi. ");
INSERT INTO sav_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ɗiski wa nik, nakoha ɗoopaat ciŋ ɗa na ini fu raak jen ɗasɗu, fu tumɗi ineem ɗah, ɓooɓi wala ɗoopaat ci wa raakan ŋ hari jen, wa hey ca ape. ” » ");
INSERT INTO sav_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wa dag caŋ Firawna kerah woo ceem, ɓum nga ɓa ambeen woo kiŋ Nikiɗi, ɓa arra ɓay ñaam caŋ ɓa na ɗoopaat caŋ ɓa ŋ kahan ca. ");
INSERT INTO sav_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ɓinooɓa ambeeɗi woo kiŋ Nikiɗi, ɓa faɗta ñaam caŋ ɓa na ɗoopaat caŋ ɓa ŋ hara. ");
INSERT INTO sav_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Nikiɗi woosa Musaa ne : « Raɗsa yaahiŋ ɗa ŋ eel ci, toɓ galacaac keen ŋ Misra, ŋ ɗafuk ɓooɓi na ɗoopaat ci na in ci na guurse ŋ kur ki jen. » ");
INSERT INTO sav_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musaa raɗissa ndooɗaŋ ɗe ŋ eel ci, Nikiɗi indngeeɗa, a toɓeeɗa galacaac, melña doheeɗa in ci ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","In mand ɗaa misik raakohɗi ina Misra nikoh poyi ; toɓaŋ atoh caŋ galacaaca miskohngaana, wa hunee na meleñ te wa keeneeɗa ɗisik nu nik. ");
INSERT INTO sav_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Wa tapukka in ca nikee ŋ bilaf fa jen na hatil, ɓooɓa na ɗoopaat ca ; wa weersohha kidig ca na in ca soksee ŋ yohon ca. ");
INSERT INTO sav_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Wa tasee ree ŋ Gosen dong, ɗiska Israayel ca gene. ");
INSERT INTO sav_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firawna nakohha ɓeeɗkiɗu Musaa na Aaruna, a woosa ɓa ne : « Waasii ŋ bakaaɗiɗ, a mi na ɓooɓiŋ ngo tooñ, Nikiɗi a yi nik ŋ keeh. ");
INSERT INTO sav_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kiimaat ɗe, ɓoo kaaniɗ na toɓiŋ atoh ciŋ galacaaci yakki na indngi, ŋ hey ɗu faɗe ɗu coot, ŋ ambissanɗi ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musaa loffa ɗe ne : « Ŋ pul kur ki ɗah, ŋ hey raɗse yaah ciŋ ngo ŋ Nikiɗi, ŋ kiim ɗe, indngi na toɓiŋ galacaaci tufuk po fu inah ne Nikiɗi a yi raak kehƴi. ");
INSERT INTO sav_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Waaye, ŋ inhiɗ ne fu na dag ciŋ ɗa, ɗu nupɗi Nikiɗi Kooh paaɗ. » ");
INSERT INTO sav_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Raak guuraah caŋ ɓa, lorsoona ɓiɗseeɗa, leeŋ'a poseeɗa, tahha po toɓa yahrohha ca. ");
INSERT INTO sav_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Waaye heet caŋ beleeca kanak ca yahrukoheeɗi sagu mirndoha ca na mirndohe. ");
INSERT INTO sav_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musaa kurkohha ŋ ɗiskaŋ Firawna, a pulla kur-taaha, a raɗissa yaah ciŋ ɗe ŋ Nikiɗi, toɓa na indnga na toɓaŋ galacaaca toppa ndaam. ");
INSERT INTO sav_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Wa Firawna hot ne toɓaŋ galacaaca hun na indnga seekiɗ, a taalndiɗta a bakaaɗeeɗa. A ndengiɗta keeñiŋ ɗe, dag caŋ ɗe nammba tum ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Findi Nikiɗi woyohee, wa taambohha ŋ Musaa, keeñiŋ Firawna nikka ndengiɗ, a faɗɗi Israayel ca ne ɓa coot. ");
INSERT INTO sav_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Wa Firawna sang faɗ Israayel ca, Nikiɗi woosa Musaa ne : « Kaɗa ŋ Firawna, ñam ndengiɗ keeñiŋ ɗe na ciŋ dag ciŋ ɗe ne ŋ teeɓoh keemaan ciŋ ngo ŋ fikiiɓa, ");
INSERT INTO sav_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ne fu min naandsuk kuɓuuciŋ ɗa, na set ciŋ ɗa findi ŋ njembtoh ɓi Misra na keemaan ci ŋ tum nga jen. Ne ɗu inah ne ñam Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musaa na Aaruna kaɗta ŋ Firawna, ɓa woosa ɗe ne : « Inii weɗ Nikiɗi Koohiŋ Heber ci woo : “ Fu na hee hey sange ruhsiɗ haf fu ŋ fikiice po kiɗa ? Faɗa ɓooɓiŋ ɗe ɓa min ɗe kaɗ ñaamka. ");
INSERT INTO sav_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Fu sang ɗah, marka, kim a hey ruhsiɗe njeeleer ŋ kur kiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ca hey riife kur ki po ca muur merhey mi jameet, ca ñam in ci toɓiŋ atoh ciŋ galacaac ci faɗ, ca heyɗi faɗe ali in ŋ kidig ciŋ bilaf fi. ");
INSERT INTO sav_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ca hey riife ŋ kahan ciŋ ɓooɓiŋ ɗa jen, na ciŋ dag ciŋ ɗa na wiŋ ɗa. Waa hee nike naamooni hotohuuɗi ŋ Misra, ŋ caac caŋ ɗa poyi. ” » Musaa eɗta ɗe finho, a cootta. ");
INSERT INTO sav_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Dag caŋ Firawna woosa ɗe ne : « Ƴaarii na hee ɓoo hey kafnde po kiɗa ? Faɗa ƴaaɓii ɓa coot, ɓa kaɗ ñaamka Nikiɗi Koohiŋ ɓa. Hanaa fu inahɗi ne Misra yahrukohiɗ ? » ");
INSERT INTO sav_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musaa na Aaruna haytohuusa ŋ Firawna, a woosa ɓa ne : « Ɗu miniɗ kaɗ ñaamka Nikiɗi, Koohiŋ ɗu, waaye a ɓinde na hee kaɗe ? » ");
INSERT INTO sav_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musaa loffa ɗe ne : « Ɓoo jen, komaaki na yakak, ƴaar na ɓitiɓ, cafaƴ na fiir, na ɗoopaat ciŋ ɓoo, mbaal ci, pe' ci na inoh ci, laam, ɓoo na hee haɓɗe feet yakiɗ wuu Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","A njembitta ɓa an : « Nikiɗi nikaat na ɗu ! Nik rek ne ñam faɗan ɗu ɗu coot na ɓooɓiŋ ɗu ɗah ! Wa leeriɗ ne ɗu na waake ro'. ");
INSERT INTO sav_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Muk ! Ɗu ɓi ƴaar ci dong, kaɗaat ɗu ñaamka Nikiɗi, ineem weɗ ɗu kiim. » Weɗi ɓa aañoh ɓa ŋ ɗiskaŋ Firawna. ");
INSERT INTO sav_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nikiɗi woosa Musaa ne : « Raɗsa yaahiŋ ɗa ŋ Misra, njeeleer ci hay, ca ñam paangfi jen, in ci toɓiŋ atoh ciŋ galacaac ci faɗ jen. » ");
INSERT INTO sav_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musaa raɗissa ndooɗaŋ ɗe ŋ Misra, Nikiɗi puuɗissa ŋ pulohaaɗ-noh. Mbaɗi wa hooɓukka puuɗis, wa neehha puuɗis. Wa Kooh wiis, puuɗsa hayya na njeeleer ca. ");
INSERT INTO sav_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ca yipukka ŋ kur kaŋ Misra jen, ca yonnga ŋ ɗisik nu nik, njeeleer hend ɗaa laay hotohuuɗi ŋ Misra te ca moosanɗi hotissu nga. ");
INSERT INTO sav_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ca ulla merhey ma po wa minisɗi hotu, ca ñammba rim caŋ kidig ca na in ca nikee ŋ yohon ca jen, ca toɓaŋ galacaaca faɗe, ali in hiliir taseeɗi ŋ kidig ca na in ca nikee ŋ yohon ca ŋ kur kaŋ Misra jen. ");
INSERT INTO sav_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Weɗi Firawna aroh ɓeeɗuk Musaa na Aaruna, a woosa ɓa ne : « Ŋ bakaaɗiɗ ŋ Nikiɗi Koohiŋ ɗu, ŋ bakaaɗta nga ɗu, ");
INSERT INTO sav_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","waaye wa topan waasii. Mi yii kiim ɗu, ɗaasaat to te ɗu kiim Nikiɗi Koohiŋ ɗu, a saɓsoh ho na naamooni na ape wii. » ");
INSERT INTO sav_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musaa kurkohha ɗiskaŋ Firawna, a kiimmba Nikiɗi, ");
INSERT INTO sav_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nikiɗi puuɗissa puuɗis raakiɗ hatil ŋ muyohaaɗ-noh, wa cootiɗta njeeleer ca jen, ŋ ɓakaŋ cookma na woyse Cookmaŋ-Hapeel-ca, ali njeeleer eleerkisɗi ŋ kur kaŋ Misra jen. ");
INSERT INTO sav_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Waaye Nikiɗi ndengiɗta keeñiŋ Firawna po a faɗɗi Israayel ca ne ɓa coot. ");
INSERT INTO sav_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Wa a sang ɓa faɗ, Nikiɗi woosa Musaa ne : « Raɗsa yaahiŋ ɗa ŋ eel ci, kur ki ñuus, ñuusi ɓooɓi saaɓɗan saaɓiɗ. » ");
INSERT INTO sav_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musaa raɗissa yaahiŋ ɗe ŋ eel ci, ñuus tuɗ ruhussa ŋ Misra jen ina ree neeh kaahay. ");
INSERT INTO sav_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ŋ neeh ca kaahay caam, ali ɓo' mineeɗi hot morom ce te ali ɓo' nga ɓi Misra mineeɗi kuruk ŋ ɗiska a nik. Waaye ɗiska Israayel ca genee nikee ñiiniɗ. ");
INSERT INTO sav_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firawna ɓeeɗukka Musaa. A woosa ɗe ne : « Kaɗaat, ɗu ñaamka Nikiɗi, ɓayndohaat ɓooɓiŋ ɗu jen. E ɗoopaat ciŋ ɗu, inoh, mbaal na pe', ca ɗi joy tas ndii. » ");
INSERT INTO sav_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musaa woosa ɗe ne : « E fu sah na hee ɓoo tahe raak ɗoopaat ci ɓoo na hee seeƴkohe wuu Nikiɗi, Koohiŋ ɓoo, na ci ɓoo hoomɗiɗan ɗe. ");
INSERT INTO sav_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ɓoo hey ɓayndohe ɗoopaat ciŋ ɓoo jen, ali yino tasanɗi nga. Ceɗ ɓoo na hee nihsohe ci ɓoo seeƴkohan wuu Nikiɗi. Te ɓoo inahɗi paaɗ ci ɓoo joy kooɗ feeh ɓoo reeɗi ɗah. » ");
INSERT INTO sav_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nikiɗi ndengiɗta keeñiŋ Firawna, yeem waaɗɗi faɗ Israayel ca ne ɓa coot. ");
INSERT INTO sav_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawna woosa Musaa ne : « Pula ndii, te wortuka hotis pukiŋ ngo ; mbehi fu hotissan pukiŋ ngo, fu hey kaane. » ");
INSERT INTO sav_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musaa woosa ɗe ne : « Ee, a fu woo wa ; ŋ hotissanɗi pukiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ŋ ineem, Nikiɗi woosa Musaa ne : « Ŋ hey ruhsiɗisse naamo, naamooni mirndoh, ŋ Firawna na ɓi Misra, ƴut ɗah, a hey ɗu faɗe ɗu coot jameet ; a yi sah na hee ɗu aañoote ne ɗu coot. ");
INSERT INTO sav_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ɗiski wa nik, woya Israayel ci ne ɓo' nu nga ɗah, ƴaar na ɓitiɓ, meeksaat gentohiŋ ɗe in haɓɗohuuɗ haalis mbaa urus. » ");
INSERT INTO sav_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Nikiɗi ɓekeen ŋ keeñ ciŋ ɓi Misra ini tah ɓa baahohha Israayel ci. Te Musaa sah nikee ɓo' kerhiɗuuɗ ŋ Misra, ŋ fiki dag caŋ Firawna na ɓi Misra jen. ");
INSERT INTO sav_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musaa woosa Firawna ne : « Inii weɗ Nikiɗi woo : “ Ŋ ndengelnde wek, mi yi Nikiɗi, ŋ hey aase ŋ Misra jen, ");
INSERT INTO sav_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","saaw ci ƴaar ci nik nga jen hey kaane, ciŋ ɗoopaat ci na ɓiŋ ɓooɓi. Ini amboh ciŋ ɗoopaat ci jen, yaŋ ñaama ɓitɓa ŋ oɗohaana po yiŋ Firawna yi ɓoof ŋ kur ki. ");
INSERT INTO sav_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Rooy keeh-keeh hey kerhasse ŋ Misra jen, rooy ci moosɗi kerhu nga, te mand ɗaa moosissanɗi kerhu nga. ");
INSERT INTO sav_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Waaye ɗiska Israayel ci gen, ɓuu sah hurnukanɗi ɓo' nga mbaa ɗoopaat. Wa teeɓ ɗu ne mi yi Nikiɗi ŋ raakiɗ talsoh ŋ harmban Misra na Israayel. ” » ");
INSERT INTO sav_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ŋ ineem, Musaa taalndiɗta, a woosa ɓa ne : « Dag ciŋ ɗa ɓii jen hey ƴeke ŋ fikiiso, ɓa kiimee so ne ŋ coot na ɓooɓiŋ ngo, ŋ han coot. » A pulla kahan Firawna na ayruk miskiɗ. ");
INSERT INTO sav_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Nikiɗi woosa ɗe ne : « Firawna sikɗukanɗi ɗa ne ŋ min tum keemaan laayiɗ ŋ kur kiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musaa na Aaruna tummba keemaan caam jen ŋ fiki Firawna. Waaye Nikiɗi ndengiɗta keeñiŋ Firawna po, a faɗɗi Israayel ca ne ɓa pul kur ce. ");
INSERT INTO sav_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Weɗi Nikiɗi woyoh Musaa na Aaruna ŋ Misra ne : ");
INSERT INTO sav_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","« Caɓnii weɗ na hee nike nga ɗu caɓni koc, weɗ caɓni koc ŋ kiis ki. ");
INSERT INTO sav_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kaɗaat ɗu woya cuuɓiŋ Israayel ne, neeh ndaŋkiyaah ŋ caɓnii, fah nu nga ɗah, waakaat mbaal naar mbaa suket, fah nu nga ɗah ɗoopaat yino. ");
INSERT INTO sav_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nik ne fahi ƴissuutiɗ po wa minɗi reehiɗ mbaal mbaa suket yino ɗah, ɓa ɓeeɗkaat gentoh ciŋ ɓa uup ɓa reɓ ; ɓa marak ɓo' nu nga ɗah, ini a min ñam, ɓa ɓay ɗoopti ɓa min reehiɗ. ");
INSERT INTO sav_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","A nikaat naar, a raak kiis yino te a raakuu ali sikka. ");
INSERT INTO sav_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ɗu hey ɗe ɗaake baahiɗ po caɓni raak neeh ndaŋkiyaah na neeh nikiis (14) ; ɗu ɓi cuuɓiŋ Israayel jen, fah nu nga ɗah hey hoose ɗoopteem ne nohi muyee ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ɗu hey ɓaye ŋ ñif miŋ ɗe, ɗu reef ŋ leentooni na ɓak ci kanak ciŋ yahndeer kahan nu nik ne ɗoopteem hey ñamse nga ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A na hee hey utse ŋ weka mbaɗi, ɗu ñam ɗe na mbuuru raakaaɗi lawiir na paangi aayiɗ. ");
INSERT INTO sav_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","A heyɗi ñamse nonaaɗi, a heyɗi bahalse, aa hee hey utse na hafi na kot ci na in ci ŋ ɗooƴ ce. ");
INSERT INTO sav_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ɗu heyɗi ɗaake nga wuu kim na ɓaaɓa, in nu tas nga ɗe ɗah, ɗu na hee wa hey dohe bala Kooh wiisan ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ɗu ñamohan ɗe an : tokɗukaat ŋ kinoh po ɗu ndeng, ñafaɗ ci ɓeku ŋ kot ci, ɗu amb ndooɗ ŋ yaah ciŋ ɗu, te ɗu ñam ɗe ñam gaawiɗ. Ineem weɗ kañam kiŋ seeƴkiŋPaak wuu so, mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ŋ wekeem ŋ hey aase ŋ Misra jen, ŋ ruhsiɗ kakaan ŋ saaw ciŋ ɓa jen, ini amboh ciŋ ɗoopaat ci po ɓiŋ ɓooɓi. Ŋ hey name teeɓ kooh ciŋ ɓa ne ca keeh haa, ñam Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Waaye ŋ kahan ci ɗu na hee nikohe, ñif meem hey nikee mandargaani na hee ɗu tose, ŋ hota ɗah, ŋ hey ca ƴakaandke, wa tos ɗu ŋ naamooni na ape, wi maa hee ruhsiɗe ne ŋ laɓ ɓi Misra. ");
INSERT INTO sav_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mbeheem na hee nike ini fu inah ne, ɗu na ɓi rimkohan nga ɗu, na hee naandsuke kiis nu ree na feet yakak wuu so, mi yi Nikiɗi. Feeteem nikan nga ɗu nakohi heyɗi faɗse. ");
INSERT INTO sav_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ɗu ñaman mbuuru raakaaɗi lawiir ini ree neeh yasna-kanak. Ini kooɗoh ŋ mbehi koc ɗu hey nihse lawiir ci nik ŋ kahan ciŋ ɗu po ŋ mbeha yasna-kanakɗoh. Yaa nu ñam mbuuru raakiɗ lawiir ŋ neeh ceem ɗah, a hey pulɗasse ŋ cuuɓiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mbehi koc na wi yasna-kanakɗoh, ɗu hey cohe coh yakak wuu so, ɗu heyɗi pangke, ɗal kañam ki ɗu na hee haɓɗe yaa nu nga ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ɗu hey yakɗe feetiŋ Mbuuruuci raakaaɗi lawiir ceem ne ɗu naandsuk mbehi ŋ pulɗoh ɗu Misra. Ɗu heya haɓɗe, ɗu na ɓi rimkohan nga ɗu, wa nik nakohi heyɗi faɗse. ");
INSERT INTO sav_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Caɓni koc raak neeh ndaŋkiyaah na neeh nikiis (14) ɗah, ini amboh ŋ niinaŋ wa ɗu ñaman mbuuru raakaaɗi lawiir po ŋ niinaŋ mbeha ndaŋkiyaah-kanak na yino'ɗoh (21). ");
INSERT INTO sav_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ini ree neeh yasna-kanak, lawiir joyɗi nik ŋ kahan ciŋ ɗu ; te hanhe mbaa geniɗ nu ñam inaa raakiɗ lawiir ɗah, a hey pulɗasse ŋ cuuɓiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kon ɗu ñamanɗi inaa raakiɗ lawiir ; na ɗisik nu ɗu min gen ɗah, ɗu ñaman ɓi mbuuru raakaaɗi lawiir. » ");
INSERT INTO sav_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Weɗi Musaa ɓeeɗkoh yakak caŋ Israayel jen, a woosa ɓa ne : « Kaɗaat ɗu ɓaya mbaal wala pe', fah nu nga ɗah, ɗu hoos ɗe, a nik Paaki. ");
INSERT INTO sav_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ɗu ɓay ɓi car hisoɓ, ɗu hooƴ ca ŋ ñif mi ɗu na hee taaknohe ŋ ɗoopti ɗu hoosan, ɗu reefa ŋ leentooni na ɓak ci kanak ciŋ yahndeeriŋ kahan nu nik. Ali ɓo' kanaat pul ŋ kahan ce mbaɗi po Kooh wiis. ");
INSERT INTO sav_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Nikiɗi hey aase ŋ Misra jen, ne a ruhsiɗ naamo nga waaye, a hot ñif mi ŋ yahndeer ci ɗah, a hey ƴakaandke kahan ciŋ ɗu, a faɗanɗi malaakaani na yahrohe a aas nga ca. ");
INSERT INTO sav_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ɗu na ɓi rimkohan nga ɗu, ɗu hey taambɗe nakohiŋ ɗe weem, ɗu tumee wa po faw, ");
INSERT INTO sav_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ɗu kaɗ po ɗu aas kur ka a gapee ɗu ne a hey ɗu wa one ɗah, ɗu hey wa haɓɗe. ");
INSERT INTO sav_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kuɓuuciŋ ɗu meekis ɗu ini wa tokis ɗah, ");
INSERT INTO sav_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","woyaat ɓa ne : “ Weɗ seeƴkiŋ Paak wuu Nikiɗi, yi ruhsiɗee naamo ŋ ɓi Misra, a ƴakaandukka kahan caŋ ɓoo te a muciɗta fah ciŋ ɓoo, wa ɓoo nikoh ñaam. ” » Wa Musaa reehiɗ woo, Israayel ca ƴekka ŋ kehƴi ne ɓa ñaamuk Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ƴutta ɓa kaɗta haɓɗa jok ina Nikiɗi nakee Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mbaɗi ŋ ɗooƴ weka, Nikiɗi appa saaw ca ƴaar caŋ Misra jen. Ina amboh caŋ ɗoopaat ca, yaŋ ambuuɗa nik kasoona po yaŋ Firawna ya ɓoof ŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ŋ weka mbaɗi, Firawna na dag caŋ ɗe jen na ɓi Misra jen kurukka ; rooy keeh-keeh raakka ŋ Misra, raakɗi kahna tasee raak ɓo' kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Firawna ɓeeɗukka Musaa na Aaruna ŋ ɗooƴ wekaam, a woosa ɓa ne : « Kurkaat ɗu pul ŋ ɓooɓiŋ ngo, kaɗaat ɗu ñaamka Nikiɗi, ɗu ɓi Israayel ci jen findi ɗu kiimohee wa. ");
INSERT INTO sav_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ɓayaat sah ɗoopaat ciŋ ɗu jen findi ɗu woyoha, ɗu coot te ɗu kiim Koohiŋ ɗu a barke'iɗ to. » ");
INSERT INTO sav_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ɓi Misra liiɓee ne ɓa jen ɓa hey kaane, weɗ tah ɓa tufukka Israayel ca, ɓa aañeeɗa ɓa ne ɓeem araat pul kur kaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Weɗi Israayel ca ɓayndohoh mun ca ɓa siiɓe, raak ca tumuuɗi lawiir paaɗ ; ɓa poonnda kanoh caŋ ɓa na kulɓa, ɓa likukka ca. ");
INSERT INTO sav_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ɓa haɓiɗta ina Musaa woyee ɓa, ɓa meekissa ɓi Misra ngaŋ in caŋ ɓa haɓɗohsee urus mbaa haalis, ɓa nammba ɓa meekis kulɓa. ");
INSERT INTO sav_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nikiɗi ɓekeen ŋ keeñ ciŋ ɓi Misra ini tah ɓa baahohha Israayel ci po ɓa eɗta ɓa in ca ɓa meeksohe. Ŋ ineem, ɓa ɓarngiɗta ɓi Misra. ");
INSERT INTO sav_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Wa ɓa ɓarngiɗ ɓa, ɓa pulohha kur kaŋ Ramses, ɓa kaɗta ɓak Sukkoot. Ɓa nikee ƴaar ndengiɗ junni-teemet-yasna-yino (600.000) ne fu kinndohɗi komaakca ƴin ca na ɓitiɓ ca ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ɓo' laayiɗ pulohha ŋ heet wiiriis hunnda na ɓa. Mbaal caŋ ɓa na pe' caŋ ɓa na inoh ca laayeen lool, ca hunnda ca kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ɓa tufkasse tufku ne ɓa pul Misra, ɓa raweeɗi haɓiɗ kañam, weɗ tah ɓa haɓiɗta mbuuru raakaaɗi lawiir na mun ca siiɓuuɗ ca guufaaɗiica ɓa pulohee na ca Misra. ");
INSERT INTO sav_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ŋ mbeheem, weɗ Israayel ca tumoh kiis teemet-nikiis na kiis ndaŋkiyaah-kaahay (430) ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Wa kiis ceem reeh, ŋ noha mbaɗi, cuuɓiŋ Nikiɗi puleeɗa Misra rung rung, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ŋ wekaam, a neehha ɓa niiɗ wa a pulɗee ɓa Misra. Weɗ tah gomal nu hay ɗah, Israayel ci joyiɗ ɗe neeh ñaamuk ŋ wekeem. ");
INSERT INTO sav_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Wa in ceem raak, Nikiɗi woosa Musaa na Aaruna ne : « Inii weɗ nakohu ŋ ini kaɗ ŋ Paaki : Ali hanhe joyɗi ñam nga. ");
INSERT INTO sav_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ñaami fu inah ne a romu romu, a miniɗ ñam nga, raak ɗa tumiɗ po a nguɗuk ɗah. ");
INSERT INTO sav_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɓoyi genohaah mbaa surgaani na wirndasse joyɗi ñam nga. ");
INSERT INTO sav_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Paakeem ñamohsan ŋ ɗooƴ kahan ci, ali sepet pulanɗi ŋ hari. Te ali ƴoh weersanɗi. ");
INSERT INTO sav_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ɓo' nu nik ne fu ɓaah ŋ cuuɓiŋ Israayel ɗah, fu joyiɗ yakiɗ feeteem. ");
INSERT INTO sav_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Hanheeri gen ŋ harmban ɗu, waaɗ ɓaah ŋ seeƴkiŋ Paaki wuu Nikiɗi ɗah, ƴaar ci nik ŋ fah ce jen joyiɗ nguɗuk, a hana min haɓiɗ findi Israayel ci. Ɓoyi nguɗukɗi minɗi ɓaah nga. ");
INSERT INTO sav_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nakohi yino ; wa faɗɗi Israayel ci, wa namɗi faɗ hanheeci gen na ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Weɗi Israayel ci jen haɓɗoh jok ina Nikiɗi nakee Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mbaɗi Nikiɗi puliɗta Israayel ci Misra, ɓa hunnda rung rung ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Wa Nikiɗi puliɗ Israayel ca, a woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","« Waɗaat to saawiŋ ɓitiɓ nu nik ŋ Israayel ɗah ; ñam raak ɓiŋ ɓo' ci na ciŋ ɗoopaat ci. » ");
INSERT INTO sav_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musaa kaɗta ŋ mboolnda a woosa ɓa ne : « Naandsukaat mbehi woti, wi Nikiɗi na pulɗohee ɗu na hatiliŋ yaahiŋ ɗe ŋ Misra, kur kiŋ kiñaamkiŋ ɗu, kinaat ñam mbuuru raakiɗ lawiir. ");
INSERT INTO sav_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ɗu hot nga, woti, ɗu pul ŋ caɓniŋ Aabiib. ");
INSERT INTO sav_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Nikiɗi ɓay ɗu, a ɓek ɗu ŋ kur ka a giñee ne a hey wa one caacuuciŋ ɗu ɗah, ɗu hey naandsuke ineem kiis nu ree ɗah ŋ caɓnii. Kur keem nikka kur kaŋ ɓi Kanaan, Hit ci, Amoor ci, Hiw ci na Yebuus ci, weɗ kur ka riifiɗ na miis na kuum. ");
INSERT INTO sav_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Neeh yasna-kanak, ɗu na hee ñame mbuuru raakaaɗi lawiir. Ŋ neehi yasna-kanakɗoh, ɗu haɓiɗ feet wuu Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ŋ neeh ceem ɗu ñaman mbuuru raakaaɗi lawiir. In nu raak lawiir ɗah, joyɗi hotu, te sah, ɗisik nu nik ŋ kur ka ɗah wa joyɗi raak lawiir. ");
INSERT INTO sav_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ɗu haɓɗee feeteem ɗah, yaa nu nga ɗu ɗah teeɓaat kuɓkiŋ ɗe ini tah a haɓɗee wa ; wa in ci Nikiɗi haɓɗiɗee ɓoo wa a pulɗee ɓoo Misra. ");
INSERT INTO sav_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Feeteem nikan nik ini naandsan ɗu ineem. Wa nik findi mandarga ŋ yaah ciŋ ɗu na puk ciŋ ɗu, ne woo ngaŋ waasiŋ Nikiɗi nik ini genan gen nguɓ ciŋ ɗu. Laam a yi pulɗoh ɗu Misra na hatiliŋ yaahiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kiis nu hay ɗah, ɗu hey haɓɗe nakoheem ŋ mbehiŋ wa. » ");
INSERT INTO sav_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Musaa taalndiɗta, a woosa mboolnda ne : « Nikiɗi ɓay ɗu kur kaŋ Kanaan, a eɗ ɗu kur ka a gapee caacuuciŋ ɗu na ɗu ɗah, ");
INSERT INTO sav_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ɗu hey ɗe waɗe saaw ci ƴaar ciŋ ɓitiɓ ci jen, ciŋ ɗoopaat ci ɗu raakan sah, ca wuu ce. ");
INSERT INTO sav_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ini kaɗ ŋ yiŋ mbaami, ɗu na hee ɗe hey romkohe na kuy wala suket, wala ɗu weer mbooh kiŋ ɗe. Ɗu na hee hey name romkoh saaw ciŋ ɓo' ci. ");
INSERT INTO sav_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Wa kaɗ po kim kuɓuuciŋ ɗu meekis ɗu ne : “ Wa ye tah ɗu haɓɗee inii ? ” ɗah, lofaat ɓa ne : “ Nikiɗi a yi pulɗoh ɓoo Misra, kur ka ɓoo nikohee ñaam, na hatiliŋ yaahiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Firawna sangee sang tic ne a heyɗi faɗe ɓoo ne ɓoo coot. Ŋ ineem Nikiɗi appa saaw caŋ ɓi Misra jen, ɓaŋ ɓooɓa na caŋ ɗoopaat ca. Ineem weɗ tah ɓoo waɗee Nikiɗi saaw ƴaar ɗoopaat nu nik te ɓoo romkohee saaw ci ƴaar ciŋ ɓo' ci. ” ");
INSERT INTO sav_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Tumohaaɗeem na hee hey nike ini na hee ɗu naandse ineem, wa nikan mandarga ŋ yaah ciŋ ɗu na puk ciŋ ɗu. Wa hey ɗu naandse pulɗi Nikiɗi pulɗoh ɗu Misra na hatiliŋ yaahiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Wa Firawna faɗis Israayel ca ne ɓa coot, Kooh woyee ne : « Israayel ci miniɗ raak hiñoh ŋ waasi, inwaaso amb ɓa nga, ɓa gurid Misra. » Weɗ tah a yurhiɗɗi ɓa ŋ waasa kaɗ ŋ kur kaŋ Filistiica ŋ ina wa uupe reɓ jen. ");
INSERT INTO sav_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","A wilaatkiɗ ɓa ŋ waasaŋ kehƴa hulanga, ŋ ɓak Cookmaŋ-Hapeel-ca. Israayel ca puloh Misra ɗaa, ɓa hunnda rung rung, ɓa kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musaa ɓayndohha ƴoh ciŋ Yuusufa sagu ne yeem giñɗukoheen kuɓuuciŋ Israayel, a woosa ɓa ne : « Mbeh, Kooh hey ɗu ambohe po a puliɗ ɗu ndii, ɗu kaɗee ɗah, giñɗaat to ne ɗu hey ɓayndohe ƴoh ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israayel ca pulohha Sukkoot, ɓa kaɗta, ɓa yippa ɗiip caŋ ɓa ŋ Etam, ŋ sero kehƴa hulanga. ");
INSERT INTO sav_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Noh reesa ɗah, Nikiɗi nik ngaŋ eel yakak yipiɗ findi kumbin ŋ fikiiɓa ne a teeɓ ɓa ɗiski ɓa taamban. Wek reesa ɗah, a nik ngaŋ jaal yongkaah ŋ fikiiɓa ne a ñiinɗiɗ ɓa, tahha po ɓa mineen tiind noh na wek. ");
INSERT INTO sav_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Eela yipee haa kumbin na noh na jaalaŋ yongkaaha haa kumbin nikee nga na wek, kurkangeeɗi ŋ fikiiɓa. ");
INSERT INTO sav_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Wa ɓaa hee pule Etam, Nikiɗi woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","« Woya Israayel ci ne ɓa welaat, ɓa yip ɗiip ciŋ ɓa ŋ sero Pi-Ayrot, ŋ harmban Migdol na cookma. Yipaat ɗiip ciŋ ɗu ndaam, yurhiɗkoh na Ba'al-Sefon ŋ sero cookma. ");
INSERT INTO sav_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firawna hey woye ne : “ Israayel ci muuƴiɗ ŋ bilaf fa ; kehƴa hulanga rangiɗ ɓa. ” ");
INSERT INTO sav_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ŋ hey ndengɗe keeñiŋ ɗe po a taambiɗ ɗu. Teemb ndeem, ŋ hey teeɓohe yaki ŋ yak, ŋ in ci ŋ tuman ɗe, a yi na hiñohoh ciŋ ɗe, te ɓi Misra hey inhe ne ñam Nikiɗi. » Israayel ca tumohha in ceem jen ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Wa Firawna woyu ne Israayel ca saandohiɗ, a yi na ɓooɓaŋ ɗe ɓoƴsohha liiɓohaaɗ ŋ ini kaɗ ngaŋ Israayel ca. Ɓa woosa ne : « Ɓoo haɓiɗ ye cii ? Wa ye tah ɓoo faɗee Israayel ci ɓa cootee, ɓoo raakissuu ñaam ci na hee ɓoo pangkiɗisse ? » ");
INSERT INTO sav_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Firawna nakohha tokɗiɗu wotiiraŋ ɗe, a hunnda na hiñohoh caŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","a ɓayya wotiir caŋ Misra jen po ca teemet-yasna-yinooca (600) uupee baah nga ; waa nu nga ɗah, ɓayya hiñohoh kaahay. ");
INSERT INTO sav_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Nikiɗi ndengiɗta keeñiŋ Firawna, buuraŋ Misra. Yeem taambiɗta Israayel ca, raak ɓeem puleeɗa na ndeng fit. ");
INSERT INTO sav_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hiñohoh caŋ Misra jen taambiɗta ɓa, ɓum tiindeeɗa, ɓinooɓi rappa panis, ɓi tas aassa ŋ wotiir caŋ Firawna, ɓa ñaakɗeeɗa ɓa po ɓa rahsohha ɓa ŋ sero Pi-Ayrot, yurhiɗkoh na Ba'al-Sefon, ɗiska ɓa yipee ɗiip caŋ ɓa ŋ sero cookma. ");
INSERT INTO sav_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Wa Firawna kaɗ po a heeɗa rahse Israayel ca, ɓeem marakka, hotta ne ɓi Misra ɓii hay nga ɓa. Ɓa neƴƴohha lool, ɓa leehkeeɗa naafu ŋ Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ɓa woosa Musaa ne : « Misra raakɗi raakɗi ruy-ruy po fu ɓayya ɓoo ŋ bilaf fii ne ɓoo kaanoh nga e ? Fu haɓiɗ ɓoo ye cii, wee tah fu kooɗohha ɓoo Misra ? ");
INSERT INTO sav_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Inii weɗ ɓoo woyee ɗa wa ɓoo nik ŋ kur ka haa e ? Ne “ Faɗa ɓoo moɗoɗ, ɓoo nik ñaam ciŋ ɓi Misra. ” Weɗ ngisoh kaan ŋ bilaf fii. » ");
INSERT INTO sav_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musaa loffa ɓa ne : « Kinaat neƴƴoh, tufkaat ɗu marak findi Nikiɗi mucɗohan ɗu woti. Ɓi Misra ɓi ɗu na hote ɓii, ɗu hotissanɗi ɓa muk. ");
INSERT INTO sav_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yeeɓkaat rek. Nikiɗi a yi na hee ɗu hiñohɗe. » ");
INSERT INTO sav_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nikiɗi woosa Musaa ne : « Wa ye tah fu leehkee nga so ? Woya Israayel ci ɓa deguk ŋ waasi. ");
INSERT INTO sav_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ɓaya ndooɗiŋ ɗa ŋ yaah, fu yurhiɗa ŋ cookmi. Fu paysoh cookmi kanak, Israayel ci min taamb nga te kot ciŋ ɗu iiri'uu. ");
INSERT INTO sav_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ini kaɗ nga so, ŋ hey ndengɗe keeñ ciŋ ɓi Misra po ɓa taambiɗ ɗu ŋ ɗooƴ cookmi. Teemb ndeem, ŋ hey teeɓohe yaki ŋ yak, ŋ in ci ŋ tuman Firawna na hiñohoh ciŋ ɗe na wotiir ciŋ ɗe na ɓooɓi rap panis. ");
INSERT INTO sav_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ŋ hey teeɓohe yaki ŋ yak ŋ in ci ŋ tuman ɓa, ɓi Misra inah ne ñam Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ƴutta, malaakaaniŋ Kooh, yi meeɗ adug ŋ fiki Israayel ca, kaɗta ŋ finhooɓa, eela yipee haa kumbin ŋ fikiiɓa nammba kaɗ ŋ finhooɓa. ");
INSERT INTO sav_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Wa nikka ŋ harmban dal ca kanak ca, dalaŋ Misra na waŋ Israayel. Eelaam nikka ñuus ŋ ɓaka winoora, waaye weka reesa, wa ñiiniɗta ɓaka tas ne cuuɓ ca kanak ca minuu reɓɗukoh na wek. ");
INSERT INTO sav_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Wa Musaa raɗis ndooɗaŋ ɗe ŋ ɗafuk cookma, Nikiɗi neehha puuɗis ŋ pulohaaɗ-noh, puuɗis raakiɗ hatil. A paysohha cookma kanak, merhey mi suyɗi nikka ŋ harmbana. ");
INSERT INTO sav_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israayel ca taammba nga te ɓa iiriiɗi, raak masma ɗingkiɗ findi miir ŋ yaah-ñaahum na yaah-sing. ");
INSERT INTO sav_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ɓi Misra ñaakɗeeɗa ɓa na panis caŋ ɓa na wotiir caŋ ɓa jen ŋ ɗooƴ cookma. ");
INSERT INTO sav_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na wiisaaɗiina, Nikiɗi, yi nikee ŋ ɗooƴ kumbinaŋ yongkaaha na eela, marakka ŋ dalaŋ ɓi Misra, a saɓsohha ɓa na sagoocaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A tummba po panuucaŋ wotiir caŋ ɓa minisɗi kaɗ kaɗ yurhiɗ, ineem tahha po ɓa minisɗi nupiɗ baahiɗ. Ɓa woosa ne : « Ɓoo saandohaat, Nikiɗi yii hiñohiɗ Israayel ci. » ");
INSERT INTO sav_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nikiɗi woosa Musaa ne : « Raɗsa ndooɗiŋ ɗa ŋ cookmi ne masmi dokkis findi wa nikohe, wa on ɓi Misra, wotiir ci na ɓi rap panis ci. » ");
INSERT INTO sav_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musaa tumohha ineem ɗaa. Ŋ wiisaaɗiina, cookma dokukka findi wa mande, ɓi Misra saandoheeɗa, ɓa cohha na masma, Nikiɗi julla ɓa ŋ ɗooƴ cookma. ");
INSERT INTO sav_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Masma dokukka, wa onnda wotiir caŋ Firawna na ɓooɓa rapee panis ca jen. Hiñohoh ca dabee Israayel ca jen tassa ŋ cookma ; ali ɓo' pulɗi nga. ");
INSERT INTO sav_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Waaye Israayel ca taambeen ŋ cookma te ɓa iiriiɗi, raak masma ɗingkiɗ findi miir ŋ yaah-sing na yaah-ñaahum. ");
INSERT INTO sav_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mbaɗi, Nikiɗi muciɗta ɓa ŋ yaah ciŋ ɓi Misra. Ɓa hotta fiɗaaf caŋ ɓi Misra ŋ sereendaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israayel ca hotta hatili Nikiɗi mucɗoh ɓa nga ɓi Misra, ɓa neƴƴohha ɗe, ɓa kossa Nikiɗi na Musaa ñaamiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Weɗi Musaa na Israayel ca ferɗoh Nikiɗi ƴeekii : « Nikiɗi ƴeekaah ƴeeku nee ! Ŋ hey ɗe ƴeeke. Ndamiŋ ɗe teeɓohiɗ nee A yi min ee ! A kooɗkiɗ panis na rapoh panis, A julla ŋ cookma. ");
INSERT INTO sav_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nikiɗi a yi hatiliŋ ngo nee ! A yi Heɗ ƴeekiŋ ngo. A yi hirip po nee ! Ŋ hey ɗe ƴeeke. Nikiɗi a yi Koohiŋ ngo nee ! Ŋ hey ɗe ɗaape. A yi Koohiŋ baabiŋ ngo nee ! Ŋ hey woye yakkiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Nikiɗi jalmba ngaŋ hiñoh ! Nikiɗi weɗ tiikiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A juliɗ wotiir caŋ Firawna Na hiñohoh caŋ ɗe. Ɓa adgoh ɓa sah muuhiɗ nga ee Ŋ Cookmaŋ-Hapeel-ca. ");
INSERT INTO sav_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ginaah ca ulla ɓa nee Ngaŋ ɗooƴ cookma. Ɓa diigiɗ nga haa ne atoh Ŋ dungaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Nikiɗi ! Ñaahmiŋ ɗa nee ! Eey hatiliŋ wa ! Nikiɗi ! Ñaahmiŋ ɗa nee ! Weɗ ɗumb ɓi sang ɗa. ");
INSERT INTO sav_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Yaki fu yak Nikiɗi nee Fu saahiɗ ɓi sang ɗa. Fu fuuɗsiɗ ayrukiŋ ɗa nee ! Eey dohɗiŋ wa ! Wa hoomɗiɗ ɓa findi mbaang ee ! Eey dohɗiŋ wa ! ");
INSERT INTO sav_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nikiɗi ! Iikiŋ ɗa nee Nangɗohiɗ masuɓ ca. Ginaah ca tufkiɗ saɗ ee Findi miir ee ! Masma sah namiɗ ndeng ee Waŋ dungaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Sangiɗa woyeeɗa nee Ŋ hey ɓa taambɗe. Sangiɗa woyeeɗa nee Ŋ hey ɓa ambe. Sangiɗa woyeeɗa nee Ŋ paysoh in ciŋ ɓa. Sangiɗa woyeeɗa nee Ŋ raak ini ŋ waaɗ jen. Sangiɗa woyeeɗa nee Ŋ fuur ndangiŋ ngo. Sangiɗa woyeeɗa nee Ŋ hey ɓa sooƴɗe. ");
INSERT INTO sav_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nikiɗi fu fuuɗissa rek ee, Cookma ulla ɓa. Ɓa ɗiigga nga haa ne beteeh Ŋ ɗooƴ-ɗooƴ cookma. ");
INSERT INTO sav_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","A yinde kooh mand na ɗa nee Ŋ kooh caŋ ɓooɓa ? A yinde na siñaarɗe sagu hool ? A Nikiɗi nee ! A yinde Kooh neƴƴohu nee ? A Nikiɗi nee ! Po a carra ƴeeku nee ? A Nikiɗi nee ! A tumee in feyohiɗ ee Findiifu nee ? ");
INSERT INTO sav_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nikiɗi fu raɗis ñaahmiŋ ɗa nee ; Kehƴi onnda ɓa. ");
INSERT INTO sav_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nikiɗi waaɗohaaɗiŋ ɗa nee Wa na ɓoƴsukeeɗi. Fu yurhiɗiɗ cuuɓiŋ ɗa fu tos Na hatiliŋ ɗa nee ! Fu yii ɓay ɓa Nikiɗi nee Ɗiskaŋ ɗa hoolɗa. ");
INSERT INTO sav_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Cuuɓ ci kerhiɗa nee ; Ɓii saakɗoheeɗa. Filistiici neƴƴohiɗ lool ee, Ɓii ngaŋ tiis. ");
INSERT INTO sav_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Kilifaacaŋ Edom Nikiɗi nee Iiƴiɗ dic ee. Te ɓa adgoh Mowab Ɓii kot-kotɗeeɗa. Ɓi Kanaan jen Nikiɗi nee Jaahɗiɗ lool ee. ");
INSERT INTO sav_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Neƴƴoh na tiit Nikiɗi nee Aasiɗ ɓa jen ee ! Ɓa hot hatiliŋ yaahiŋ ɗa nee ; Ɓa minɗi yoond. Ɓa mandiɗ nga haa ne atoh. Eey Nikiɗi nee ! Po cuuɓiŋ ɗa wii taamb ee. Eey Nikiɗi nee ! Po cuuɓi fu tos wii taamb ee. Eey Nikiɗi nee ! ");
INSERT INTO sav_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Fu hey ɓa genɗe Nikiɗi nee Ŋ tangoora fu raakoot, Ɗiska fu haɓiɗ kahan fu nee ! Eey Nikiɗi nee ! Ngaŋ ɗiskaŋ ɗa hoolɗa nee ! Eey Nikiɗi nee ! Wa fu haɓiɗ na yaah ciŋ ɗa nee, Fu yi Heɗ ɓoo. ");
INSERT INTO sav_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Nikiɗi a yi nikan buur ee Po faw ee ! » ");
INSERT INTO sav_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ɗaa, panis ca na wotiir caŋ Firawna, na ɓooɓa rapee ca aaseen ŋ cookma. Nikiɗi dokinnda masma ŋ ɗafuk ɓa. Israayel ci taammba ŋ merhey ma suyɗa, ŋ ɗooƴ cookma. ");
INSERT INTO sav_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Maryam, woosuuɗa ɓitɓa, taambɗoh Aaruna, ɓayya haan. Ɓitiɓ caŋ Israayel jen ñaakiɗta ɗe, ɓa tipeeɗa, ɓa mbeceeɗa. ");
INSERT INTO sav_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maryam dokkissa ŋ ƴeeka an : « Nikiɗi ƴeekaah ƴeeku nee Ŋ hey ɗe ƴeeke Ndamiŋ ɗe teeɓohiɗ nee A yi min ee A kooɗkiɗ panis na rapoh panis A julla ŋ cookma. » ");
INSERT INTO sav_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musaa adgiɗta Israayel ca, ɓa pulohha Cookmaŋ-Hapeel-ca, ɓa yurahha kehƴa hulangaŋ Suur. Ɓa tiinnda neeh kaahay, ɓa hotɗi masmi ɓa anan. ");
INSERT INTO sav_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Wa ɓa kaɗ po ɓa reesa ɗiska na woyse Mara, masuɓ raakeen nga, waaye ɓa mineeɗaa an, wa nikee aayiɗ hak weɗ tah ɗiska teekuusa Mara (aay). ");
INSERT INTO sav_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ŋ ineem, mboolnda lahtukeeɗa ŋ Musaa, ɓa woosa ne : « Ɓoo na hee ye ane ? » ");
INSERT INTO sav_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musaa kiimmba Nikiɗi na leehuk. Nikiɗi teeɓpa ɗe ndooɗ, a ɓekkaa ŋ masma, wa hannda min anu. Ŋ ndaam, Nikiɗi eɗta Israayel ca nakoh ciŋ ɗe na haɓɗaah. A nammba ɓa markisuk. ");
INSERT INTO sav_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A woosa ɓa ne : « Ɗu kerah keeh-keeh woo kiŋ ngo, mi yi Nikiɗi Koohiŋ ɗu, te ɗu haɓɗee in ci ŋ amb ne ceɗ yurah ɗah, ɗu ɓekoh nof in ci ŋ nakoh, te ɗu haɓiɗ haɓɗaah ci jen ɗah, ŋ heyɗi yipkiɗe kosaay nga ɗu findi ŋ tumoh na ɓi Misra. Laam ñam Nikiɗi yi na wirɗee ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Israayel ca kaɗeeɗa po ɓa reesa Elim, ɓa raakka cul masuɓ ndaŋkiyaah na kanak (12) nga, na tas tandarma ndaŋkiyaah-yasna-kanak (70), ɓa dalla nga, ŋ sero masma. ");
INSERT INTO sav_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Wa ɓa ɓoof nga po caɓna kanakɗoh ŋ pulohaŋ ɓa Misra raakka neeh ndaŋkiyaah na yatuus (15), Israayel ca jen kurkohha Elim. Ɓa kaɗeeɗa po ɓa reesa kehƴa hulangaŋ Sin, ŋ harmban Elim na tangooraŋ Sinaay. ");
INSERT INTO sav_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ŋ ndaam, Israayel ca jen lahtukeeɗa ŋ Musaa na Aaruna. ");
INSERT INTO sav_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ɓa woyeeɗa ne : « Nikiɗi joyee ɓoo joy ap ŋ Misra ; ndaam, ɓoo nikee ɓoofiɗ na soƴeecaŋ sepet ca te ɓoo meeɗeen ñam po ɓoo kap nding. Waaye weɗɗi, ɗu ɓayiɗ ɓooɓi jen ndii ne ɓoo kaan na aɗ. » ");
INSERT INTO sav_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Nikiɗi woosa Musaa ne : « Marka ! Ŋ hey ɗu toɓɗe kañam. Kooh-nu-wiis, ɗu hey kaɗe, ɗu ɓaya nga ini mit ɗu ɗingiɗ neeh yino ; teemb ndeem, ŋ hey marke andi ɗu hey taambɗe nakoh ciŋ ngo wala. ");
INSERT INTO sav_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ŋ mbehi yasna-yino'ɗoh, ɗu ɓay ngaŋ kañam keem ɗah, wa nikan wuu neeh kanak. » ");
INSERT INTO sav_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","8","Musaa na Aaruna woosa Israayel ca jen ne : « Nikiɗi kerhiɗ lahtukiŋ ɗu nga ɗe, ŋ niini woti, a hey ɗu one sepet ñamaah. Ɗu hey inhe ne a yi Nikiɗi, yi pulɗoh ɗu Misra. Kim na ɓaaɓa, a hey ɗu name on kañam, ɗu ñam po ɗu kap ; ɗu hey hote ndamiŋ ɗe. Ini kaɗ nga ɓoo, ɓoo tus haa ; ɗu lahtukɗi nga ɓoo, ɗu na lahtuke ŋ Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musaa woosa Aaruna ne : « Woya Israayel ci jen ne, ɓa hayaat ɓa tufuk ŋ fiki Nikiɗi laam a kerhiɗ lahtukiŋ ɓa nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Wa Aaruna na woye na mboolndaŋ Israayel ca, ɗekka po, ɓa jen ɓa yurhiɗkohha na kehƴa hulanga. Ndamiŋ Nikiɗi teeɓukka ɓa ŋ ɗooƴ eela yipe haa kumbin. ");
INSERT INTO sav_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nikiɗi woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","« Ŋ kerhiɗ lahtukiŋ Israayel ci ; woyiɗ to ɓa ne : “ Ŋ niini woti, bala nohi muyan ɗah, ɗu hey ñame sepet te kim na ɓaaɓa, ɗu hey raake kañam ki kap ɗu, ɗu hey inhe ne ñam Nikiɗi, Koohiŋ ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Wa niina ree, mbaƴul ca pundeeɗa, hayeeɗa. Ca yoonnga ŋ dala po wa riiffa. Kooh wiissa na ɓaaɓa, maar keennda nga. ");
INSERT INTO sav_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Wa maara coot, ŋiisohi haa sangri raɗiɗta ŋ merhey ma ; ");
INSERT INTO sav_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israayel ca hottaa, ɓa inahɗi ini wa nik, ɓa woyeeɗa ŋ harmban ɓa ne : « Inii wa ye ? » Musaa loffa ɓa ne : « Wa kañam ki Nikiɗi on ɗu ; ");
INSERT INTO sav_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","inii, weɗ a woo nga : “ Yaa nu nga ɓayaat ini mit ɗe ɗingiɗ neeh yino, haf nu nga ɗah, andaar yino. ” » ");
INSERT INTO sav_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ɓa tumohha ɗaa, yaa nu nga ɓayya, ɓum ɓayya juuk, ɓinooɓi ɓayya ƴissuut. ");
INSERT INTO sav_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Waaye wa ɓa ɓees ca na andaar, ɓa ɓayee juuk uupɗeeɗi te ɓa ɓayee ƴissuut mitɗeen. Yaa nu nga ɗah, ɓayee ini doy ɗe. ");
INSERT INTO sav_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musaa woosa ɓa ne : « Ali ɓo' kinaat ɗaak nga wuu kim na ɓaaɓa. » ");
INSERT INTO sav_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Raakka ɓi kerhiɗɗi ɗe, ɓa ɗaakka ŋ caŋ ɓa po na ɓaaɓa, ca canginnda, ca oteeɗa ; Musaa ayrukka ɓa. ");
INSERT INTO sav_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ini kooɗoh ndeem, ɓaaɓ nu ree ɗah, yaa nu nga ɗah, kaɗ ɓaya ini mit ɗe ɗingiɗ neeh yino. Kaɗta po nohi dammba ɗah, ini tas ŋ kehƴi seey. ");
INSERT INTO sav_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ŋ mbeha yasna-yino'ɗoh, ɓa ɓayya ɗingiɗ wuu neeh kanak, weɗ ne haf nu nga ɗah, andaar kanak ; kilifaaca kaɗta ŋ Musaa, ɓa woosa ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","A loffa ɓa ne : « Ineem weɗ Nikiɗi nakohe ; kim, wa mbehi hoolɗi na iɗsiɗkohse, wi Nikiɗi waɗu. Utaat ini ɗu waaɗ ut, ɗu tik ini ɗu waaɗ tik, ɗu ɗaak ini tas po kim na ɓaaɓa. » ");
INSERT INTO sav_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ɓa tummba ineem, ɓa ɗaakka wuu kim findi Musaa nakohoha, ɓa hotta ne ca otɗi, ca cangindɗi. ");
INSERT INTO sav_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Weɗ Musaa woyoh ɓa ne : « Ñamaat ca woti, ɗu heyɗi raake ali in ŋ bilaf fi, laam woti wa mbehi na iɗsiɗkohse, wi Nikiɗi waɗu. ");
INSERT INTO sav_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ini ree neeh yasna-yino, kaɗaat ɗu ɓaya ñamaah waaye mbehi yasna-kanakɗoh, weɗ na iɗsiɗkohse ; ñamaah raakanɗi ŋ bilaf fi. » ");
INSERT INTO sav_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Raakka ɓa pul ŋ mbehi na iɗsiɗkohse ne ɓa ɓay ; ɓa hotɗi ali in. ");
INSERT INTO sav_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nikiɗi woosa Musaa ne : « Ɗu genan gen sang taambiɗ nakoh ci na teeɓoh ciŋ ngo po kiɗa ? » ");
INSERT INTO sav_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Musaa ɓaatiɗta ɓa nga ne : « Inhaat baahiɗ ne a Nikiɗi eɗ ɗu mbehi na iɗsiɗkohse, weɗ tah a onnda ɗu ŋ mbehi yasna-yino'ɗoh ne ɗu ɓay ɗingiɗ wuu neeh kanak nga ; ŋ mbehi yasna-kanakɗoh, yaa nu nga ɗah, ɓoofaat, a puluu. » ");
INSERT INTO sav_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ŋ ineem Israayel ca iɗsiɗukka mbeha yasna-kanakɗoh. ");
INSERT INTO sav_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ɓa teekka kañam kaam maan (wa-ye). Wa mandee na pees koryand, wa nikee yaanow te fu ñamee wa ɗah, waa mandee na ɗangi haɓɗohu kuum. ");
INSERT INTO sav_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musaa woosa ne : « Inii weɗ Nikiɗi nakoh : Andaar tumsaat maan po wa riif, wa ɗaaku, wuu ɓi na hee rimkohe nga ɓoo, ne ɓa hot kañam ki Nikiɗi pesɗohee ɓoo ŋ bilaf fi, wa a puliɗ ɓoo Misra. » ");
INSERT INTO sav_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musaa woosa Aaruna ne : « Ɓaya meeme ɗaakkoha, fu tuma andaar maan po wa riif, fu ɗaaka ŋ fiki Nikiɗi, wa nik wuu ɓi na hee rimkohe nga ɓoo. » ");
INSERT INTO sav_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Findi Nikiɗi nakohee wa Musaa jok, Aaruna ɓayohhaa ɗaa ŋ ɗiska na naandsukohse ambtiɗohi Nikiɗi ambtiɗoh na ɓa, ne wa ɗaaku nga. ");
INSERT INTO sav_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israayel ca ñamiɗ ŋ maaneem ini ree kiis ndaŋkiyaah-nikiis (40) po findi ɓa reyoh ŋ aasoha kur genohuuɗ, wa nikka Kanaan. ");
INSERT INTO sav_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Andaar caŋ ɓa, ca nikee liitar kanak na camban.) ");
INSERT INTO sav_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Findi Nikiɗi woyohee ɓa wa, Israayel ca jen kurkohha kehƴa hulangaŋ Sin, ɓa kaɗeeɗa ƴin ƴin po ɓa reesa Refidim ; ɓa yippa ɗiip caŋ ɓa nga. Waaye ŋ ndaam, ɓa raakeeɗi masmi ɓa anan. ");
INSERT INTO sav_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ɓa waakeeɗa Musaa lahtoh, ɓa woyeeɗa ɗe ne : « Eɗa ɓoo masmi ɓoo anan. » A woosa ɓa ne : « Wa ye tah ɗu waakee so lahtoh ? Wa ye tah ɗu markiskee Nikiɗi ? » ");
INSERT INTO sav_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ɓa sifaɗukka, ɓa lahtukeeɗa nga ɗe an : « Wa ye tah fu pulɗohha ɓoo Misra, fu hayya na ɓoo ŋ ndii ne fu ap ɓoo na sifaɗ, ɓoo na kuɓuuciŋ ɓoo na ɗoopaat ciŋ ɓoo ? » ");
INSERT INTO sav_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musaa kiimmba Nikiɗi keeh-keeh, a woosa ɗe ne : « Ŋ joy haɓɗiɗ ɓooɓi ye Nikiɗi ? Ini hondoh ɓa tap po atoh po ŋ kaan laayisɗi ! » ");
INSERT INTO sav_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nikiɗi loffa ɗe ne : « Adgaa ɓa, fu hun na ɓi yakak, fu ɓay ndooɗi fu laɓee ŋ kalaŋ Niil. ");
INSERT INTO sav_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Marka, ŋ hey ɗa adge, ŋ nik nden, ŋ ɗafuk atoh fi, ŋ Horeb, fu hey laɓe ndooɗi ŋ atoh feem, masuɓ hey pule nga, ɓa raak anaah. » Musaa tummba ina Nikiɗi woyee, a tuma ŋ fiki yakak ca a hunee na ɓa. ");
INSERT INTO sav_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ndaam teekuusa Maasaa (markisuk) na Meeribaa (waak lahtoh). Laam Israayel ca waakee Musaa lahtoh, ɓa markiskeeɗa Nikiɗi ngaŋ meeksoha ɓa meeksohee an : « Nikiɗi yii ŋ harmban ɓoo wala a nikɗi nga ? » ");
INSERT INTO sav_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Wa raakka mbeh Amalek ci hayya hiñohee na Israayel ci ŋ Refidim. ");
INSERT INTO sav_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musaa hotohha na ƴaara teeku Yosuwe, a woosa ɗe ne : « Kooɗa ɓi ɓo' ndengiɗ, ɗu kaɗ hiñoha na Amalek ca ; kim ŋ hey nike ŋ ɗafuk tangoori na ndooɗiŋ Kooh ŋ yaah ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwe kaɗta hiñoha na Amalek ca findi Musaa nakohee ɗe wa. A yi Musaa, a hunnda na Aaruna na ƴaar teeku Hur, ɓa kaɗta, ɓa tufukka ŋ ɗafuk tangoora. ");
INSERT INTO sav_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musaa meeɓpa yaah ŋ ɗafka ɗah, Israayel ci ɓeɗ na mine. Waaye a ruhsiɗta ca ɗah, Amalek ci ɓeɗ na mine. ");
INSERT INTO sav_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musaa nikka na ineem po yaah ciŋ ɗe neeɓohha, Aaruna na Hur ooɓiɗta ɗe atoh, a ɓooffa nga. Yii lahha ɗe ŋ ɓakii, yum lahha ɗe ŋ ɓaki tas, ɓa ammba yaah ciŋ ɗe ne ca ruhsuu po nohi muyya. ");
INSERT INTO sav_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yosuwe na Israayel ca laɓpa Amalek ca na hiñohoh caŋ ɓa ndang po ɓa raɗta ɓa ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Wa hiñoha reeh, Nikiɗi woosa Musaa ne : « Fiisa in cii ŋ teere, fu ɗaaka, ca alkohsuu. Te woya Yosuwe ne ŋ hey reehɗe Amalek ci ŋ kehƴi po ali ɓo' naandsukissanɗi ini kaɗ nga ɓa. » ");
INSERT INTO sav_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ŋ ndaam, Musaa yippa seeƴkoha wuu Nikiɗi nga, a teekkaa tiiki tokis : \"Nikiɗi a yi Raayaaniŋ Ndamiŋ ngo.\" ");
INSERT INTO sav_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A woosa ne : « Yaahi meeɓu yurhiɗuusa ŋ Nikiɗi, tahiɗ po Nikiɗi genan gen hiñoh Amalek ci gomal nu gomal. » ");
INSERT INTO sav_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ŋ jamanoonaam, Yetoro seeƴkiɗohaŋ kur kaŋ Majaan, payum Musaa ƴaar, kerahha in ci Kooh haɓɗiɗ Musaa jen, na Israayel wi cuuɓiŋ ɗe, ne Nikiɗi pulɗohiɗ ɓa Misra. ");
INSERT INTO sav_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Sefora ɓiti Musaa nikee ŋ kahan baab ɓa Yetoro, raak a Musaa tuuƴee ɗe ne a nikohaah nga, ");
INSERT INTO sav_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","na kuɓuuciŋ ɗe ƴaar ci kanak ci. Musaa teekee saawa Geersom laam a woyee ne : « Ŋ genohaah ŋ kur jaambur. » ");
INSERT INTO sav_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ƴina teekuusa Eliyeser (Koohiŋ ngo ɓaatɗohoh) laam, Musaa woyee ne : « Koohiŋ baab ɓoo, yi hirpohiŋ ngo, mucɗiɗ to ŋ yaah ciŋ Firawna. » ");
INSERT INTO sav_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetoro hunnda na ɓiti Musaa na kuɓuuciŋ Musaa kanak ci ; ɓa kaɗta po ɓa reesa kehƴa hulanga Israayel ca dalohee ŋ sero tangooraŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetoro woosohha ŋ Musaa ne a woysaat ne, a yaa hay, a yi na Sefora na kuɓuuciŋ ɗe kanak ci. ");
INSERT INTO sav_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musaa pulla, kaɗta coha na ɓa. Wa a ree a ƴekiɗta payum ce Yetoro, a morgiɗukka ɗe, ɓa kañɗohha po ƴutta ɓa aassa ŋ ɗiipa. ");
INSERT INTO sav_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musaa naandsukka ɗe jen findi Nikiɗi tumoh na Firawna na ɓi Misra sagu Israayel, na miskiɗ ci ɓa raak ŋ waasi te Nikiɗi pulɗohha ɓa nga ca. ");
INSERT INTO sav_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetoro summba ŋ in ci baahiɗ ci jen, ca Nikiɗi haɓɗiɗ Israayel ca wi a pulɗoh ɓa ŋ yaah ciŋ ɓi Misra. ");
INSERT INTO sav_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","A woosa ne : « Nikiɗi yakɗaah, a yi pulɗoh ɗu ŋ yaah ca Firawna na ɓi Misra degee ɗu. ");
INSERT INTO sav_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ŋ teyɗukiɗ kotii ne Nikiɗi a yi uup in ci ambu ne ca kooh jen ; a teeɓohiɗa wi Israayel ci na aƴaarkohse. » ");
INSERT INTO sav_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetoro ɓayya ɓi ɗoopaat, a eɗohha ca seeƴkaah wuu Kooh, yino hoomɗaah, na ɓi wiiriis hoosaah. Aaruna na yakak caŋ Israayel jen hayya, ɓa ɓaahha na ɗe kañam kaŋ seeƴka ŋ fiki Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wa Kooh wiis na ɓaaɓa, Musaa ɓooffa ne a atte leer caŋ ɓooɓa. Ɓa hooɓukka tufuk ŋ fikiice na ɓaaɓa po na niina. ");
INSERT INTO sav_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yetoro payum ce hotta ŋ in ca a na haɓɗiɗe cuuɓa, na findi ca laayoh, a woosa ɗe ne : « Fu na haɓɗe ye wii, wa ye tah fu atte'ee kiik fu ? Mboolndi tufuk na ɓaaɓi po na niini, ɓa sekee nga ɗa ! » ");
INSERT INTO sav_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musaa loffa ɗe ne : « Mboolndi na haye nga so ne ɓa inah ini Kooh woo, ");
INSERT INTO sav_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ɓa raakka ini ɓa leer ɗah, ɓa hay nga so, ŋ attee ɓa, ŋ teeɓ ɓa ne ɓa inah in ci Kooh sangoh na ci a nakoh. » ");
INSERT INTO sav_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Payum ce Yetoro woosa ɗe ne : « Findi fu na tumohe, wa ɗaa haa. ");
INSERT INTO sav_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Fu hey yaaɓɗe haf fu, fu yaaɓiɗ ɓooɓi na haye nga ɗa ; inii, wa ɓit ɓit, fu minɗaa tum kiik fu. ");
INSERT INTO sav_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ɗiski wa nik, sikɗuk ko ŋ ɓaatɗoh ɗa ƴissuut, te Kooh hunaat na ɗa nga : Fu, nika ŋ harmban cuuɓi na Kooh fu ɓayee leer ci nga ɗe. ");
INSERT INTO sav_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Fu teeɓee ɓa ɗiski ɓa joy top, fu teeɓee ɓa nakoh ciŋ Kooh. Fu teeɓ ɓa waasiŋ ɗe, na ini ɓa joy haɓiɗ. ");
INSERT INTO sav_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Waaye waaka nga ɓa ɓi ɓo' mitiɗ, nupiɗ Kooh, yurhiɗ, ɓi fu inah ne ɓa waaɗɗi in lewaaɗi ; fu tufkiɗ ɓa, raak ɓi na hee adgohe junni (1000) ɓo', raak ɓi adgohan ɓo' teemet (100), ɓum ɓo' ndaŋkiyaah-yatuus (50), ɓinooɓi ɓo' ndaŋkiyaah. ");
INSERT INTO sav_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ɓeem hay ɗah, ɓa atte'ee Kooh-nu-wiis leer ci ƴin-ƴin ciŋ mboolndi, ɓa wikee ɗa ci uupiɗ etoh. Ineem hey ɗa eɗfiɗɗe pangkiŋ ɗa, fu ɓaahana ɓaah na ɓa. ");
INSERT INTO sav_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Fu haɓiɗa, te Kooh teeɓ ɗa waasi ɗah, fu heyɗi yaaɓɗe haf fu te ɓooɓii jen hey mine haad moɗoɗ. » ");
INSERT INTO sav_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musaa taambiɗta woo kaŋ payum ce jok, ");
INSERT INTO sav_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","a tannda ɓi ƴaar mitiɗ ŋ Israayel, a tufkiɗta ɓa, ɓum adgohha ɓo' junni (1000), ɓum ɓo' teemet (100), ɓum ɓo' ndaŋkiyaah-yatuus (50), ɓum ɓo' ndaŋkiyaah. ");
INSERT INTO sav_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ɓa atte'eeɗa leer ca ƴin-ƴin caŋ mboolnda Kooh-nu-wiis, ɓa ɓayeeɗa in ca miskiɗ ca ŋ Musaa ne a attee ca. ");
INSERT INTO sav_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musaa askohha na Yetoro payum ce, yeem dokukka kur ɓa. ");
INSERT INTO sav_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Mbeha koc ŋ caɓna kaahayɗoh ŋ finho pulohaŋ ɓa Misra, Israayel ca kurkohha Refidim, ɓa kaɗta kehƴa hulangaŋ Sinaay ; ɓa yippa ɗiip caŋ ɓa nga ŋ sero tangoora. ");
INSERT INTO sav_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musaa rapeeɗa ŋ tangoora ne a coha na Nikiɗi Kooh. Weɗ Nikiɗi ɓeeɗkoh ɗe ŋ ɗafuk tangoora, a woosa ɗe ne : « Inii weɗ fu na hee woye kuɓuuciŋ Yaŋhooɓa, Israayel ci : Nikiɗi woo ne : ");
INSERT INTO sav_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“ Ɗu hotootiɗ findi ŋ tumoh na ɓi Misra, ŋ ɓayya ɗu nga so findi caango na raɗsohe paɓ ciŋ ɗe, a deg ƴiil ciŋ ɗe nga. ");
INSERT INTO sav_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Markaat, kehƴi jen ñam raaka, ɗu kerah woo kiŋ ngo te ɗu taambiɗ ambtiɗohiŋ ngo na ɗu ɗah, ŋ cuuɓ ci jen, a ɗu nikan cuuɓiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ɗu hey nike cuuɓ hooliɗ wuu so, ɗu nik seeƴkiɗoh ci na hee nike ŋ harmban ndo na cuuɓ ci cinooci. ” Inii weɗ fu na hee woye Israayel ci. » ");
INSERT INTO sav_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musaa kaɗta ŋ mboolnda, a cohɗohha yakak ca, a woosa ɓa ini Nikiɗi nak ɗe jen. ");
INSERT INTO sav_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mboolnda jen hunnda woosa ɗe ne ɓa hey haɓɗe in ci Nikiɗi nakoh jen. A kaɗta, a woosa Nikiɗi ineem. ");
INSERT INTO sav_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nikiɗi woosa Musaa ne : « Marka ŋ hey haye po nga ɗa, ŋ ɗooƴ eel ñuusiɗ, Israayel ci hey yo kerhe woyee na ɗa, ɓa ooluk ɗa po faw. » Wa Musaa wik Nikiɗi woo kaŋ mboolnda, ");
INSERT INTO sav_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nikiɗi woosa ɗe ne : « Dokka ŋ mboolnda, woyaa ɓa ne, woti na kim, ɓa ɓoktukaat, ɓa naaw kulɓaaciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Mbehi kaahayɗoh, wa raakaat ɓa ƴutiɗ, mbaɗi ŋ hey yipke ŋ tangooriŋ Sinaay, ŋ fikiiɓa jen. ");
INSERT INTO sav_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Fu hey ɓa teeɓe ɗiski ɓa topan ŋ sereendiŋ tangoori. Te fu woo ɓa ne ɓa wortukaat, ɓa kinaat ree ŋ tangoori, ɓa kinaata laal. Ɓo' nu laala ɗah, a hey apse. ");
INSERT INTO sav_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","A nik ɓo', a nik ɗoopaat, ali ɓo' joyɗi ɗe laal. A tapsan tapu atoh wala ɓis. Kaɗ po ɗu kerah kuluɓ ɗah, raak ɓi han min rap ŋ tangoori. » ");
INSERT INTO sav_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musaa ruhussa ŋ mboolnda, a tummba po ɓa ɓoktukka, ɓa naawwa kulɓaacaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","A woosa ɓa ne : « Faaha kim raakaat ɗu ƴutiɗ, te kinaat faanuk na ɓitiɓ ciŋ ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ŋ neeha kaahayɗoh ŋ wiisaaɗiina, wa melñeeɗa, wa indngeeɗa, eel ñuusiɗ nikka ŋ ɗafuk tangoora, ɓa kerahha kuluɓ roofiɗ nga ; ɓooɓa, ŋ ɗiska ɓa nikee ŋ dala, ɓa tiitta jen po ɓa saakɗoheeɗa. ");
INSERT INTO sav_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musaa puliɗta ɓa ŋ dala, a ɓayya ɓa ŋ sereendaŋ tangoora ne ɓa tufuk ŋ fiki Kooh. ");
INSERT INTO sav_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nikiɗi yipkeen nga ŋ ɗooƴ jaal yongkaah, tahha po tangooraŋ Sinaay nikee ɗuukeeɗa, ɗuukra kurkeeɗa jututut findi ɗuuku puur ; tangoora jen yoondeeɗa yoond keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kuluɓ ka uupeeɗa nga uup roof, Musaa woyeeɗa, a kerheeɗa hoosooriŋ Kooh lofeeɗa ɗe ŋ indnga. ");
INSERT INTO sav_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nikiɗi yipukka ŋ tangoora ŋ suunaŋ wa, a ɓeeɗukka Musaa ; yeem rappa. ");
INSERT INTO sav_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nikiɗi woosa ɗe ne : « Ruhsa fu woya na mboolnda, waaɗ to hot kinaat ɓa ɓek ŋ cootuk ɗiski ɓa topɗu wala laayiɗ nga ɓa hey kaane. ");
INSERT INTO sav_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Te sah seeƴkiɗoh ci joy hay nga so, ɓa joyiɗ farsuk, bala ŋ keenan ɓa ɗah. » ");
INSERT INTO sav_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musaa loffa ɗe ne : « A fu woyee ne ŋ haɓɗaat ɗiski ɓooɓi na hee tope ŋ sereendiŋ tangoori, ŋ tuma ɗisik hooliɗ wuu fu, weɗ tah po mboolndi minanɗi rap ŋ ɗafuk tangoori. » ");
INSERT INTO sav_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ŋ ineem Nikiɗi woosa Musaa ne : « Ruhsa, fu hayee ɗah, fu hun na Aaruna. Waaye ŋ ini kaɗ ŋ mboolndi na seeƴkiɗoh ci, waaɗ rap ŋ ɗiskiŋ ngo kinaat ɓa ɓek ŋ cootuk ɗiski ɓa topɗu, bala ŋ keenan ɓa ɗah. » ");
INSERT INTO sav_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musaa yipukka ŋ mboolnda, a woosa na ɓa. ");
INSERT INTO sav_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mbaɗi, Kooh woyiɗ Israayel ci woo cii jen an : ");
INSERT INTO sav_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","« Ñam Nikiɗi, ñam Koohiŋ ɗa, mi yi pulɗoh ɗa Misra, ŋ ɗiska fu nikee ñaam. ");
INSERT INTO sav_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Fu raakanɗi kooh wiiriis ɗal mi. ");
INSERT INTO sav_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Fu haɓɗanɗi nataal fu ñaamkee ca. Ca nik ŋ in ci ŋ ɗafki, wala ca nik ciŋ kehƴi, wala sah ciŋ masmi ŋ ooɓ kehƴi. ");
INSERT INTO sav_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Te fu heyɗi ca ƴekɗe, fu heyɗi ca ñaamke. Laam mi yi Nikiɗi Koohiŋ ɗa, ŋ teyɗukɗi ɓaah ɗa na in, ñam na mbugale kuɓuuciŋ baab ci sang ngo, na kuɓuuciŋ ɓeem, po ŋ set ca na setaat ca. ");
INSERT INTO sav_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ŋ teeɓohee keeñkohiŋ ngo po ŋ gomal junni (1000) ŋ ɓi waaɗ to, te ɓa haɓɗee in ci ŋ nakoh. ");
INSERT INTO sav_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Fu heyɗi njirñiɗkohe tiikiŋ Nikiɗi Koohiŋ ɗa ŋ woo ɓarang ɓarang ; mi yi Nikiɗi, ŋ faɗanɗi ɓo' a njirñiɗkohee tiikiŋ ngo ŋ woo ɓarang ɓarang. ");
INSERT INTO sav_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ɗaakkoha nof mbehi na iɗsiɗkohse ne fu tuma mbeh hooliɗ wuu so. ");
INSERT INTO sav_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Fu raakiɗ neeh yasna-yino ne fu haɓiɗ pangkiŋ ɗa nga jen. ");
INSERT INTO sav_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Waaye mbehi yasna-kanakɗoh, weɗ wi na iɗsiɗkohse, yakɗoha Nikiɗi Koohiŋ ɗa. Fu heyɗi pangke nga, fu na kuɓuuciŋ ɗa, ƴaar na ɓitiɓ ; na ñaam ciŋ ɗa, ƴaar na ɓitiɓ ; na ɗoopaat ciŋ ɗa po ŋ jaambri gen kahan fu sah. ");
INSERT INTO sav_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Laam, ngaŋ neeh yasna-yino, ŋ haɓɗiɗ eel ci na kehƴi na cookmi na in ci nik nga ca jen, ŋ faɗta mbehi yasna-kanakɗoh ŋ iɗsiɗukka nga, weɗ tah ŋ barke'iɗta mbeheem, ŋ tummbaa wuu so. ");
INSERT INTO sav_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Eɗa yaay ɗu na baab ɗu cir ne fu min raak kipes hutiɗ ŋ kehƴa ŋ eɗan ɗa, mi yi Nikiɗi Koohiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Fu apanɗi ɓo'. ");
INSERT INTO sav_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Fu njaaloo'anɗi. ");
INSERT INTO sav_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Fu rokanɗi. ");
INSERT INTO sav_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Fu woyɗanɗi morom fu ini a tumɗi. ");
INSERT INTO sav_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Fu waaɗɗanɗi haf fu iniŋ morom fu, a kahan ce haa, ɓitiice haa, a ñaamiŋ ɗe ƴaar mbaa ɓitiɓ haa, a inoh fiŋ ɗe haa te a mbaamiŋ ɗe haa. » ");
INSERT INTO sav_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ŋ ndeem Israayel ca jen kerheeɗa inding ca na kuluɓ ka, ɓa nammba hot meleñ ca na findi tangoora ɗuukohe, ɓa saakɗoheeɗa sagu neƴƴoh ŋ ɗiska ɓa cangtiɗke. ");
INSERT INTO sav_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ɓa woosa Musaa ne : « Fu, woya na ɓoo, ɓoo hey ɗa sikɗuke, waaye Kooh kinaat woo na ɓoo jahran, ndaa ɓoo hey kaane. » ");
INSERT INTO sav_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musaa loffa ɓa ne : « Kinaat neƴƴoh, ini tah Kooh reɓ ndii, a na markiskee ɗu ne ɗu nup ɗe, ɗu bakaaɗuu. » ");
INSERT INTO sav_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Israayel ca rissa ŋ ɗiska ɓa cangtiɗke, waaye Musaa reɓpa ŋ eela, ŋ ɗiska Kooh nike. ");
INSERT INTO sav_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Wa Musaa reɓ, Nikiɗi woosa na ɗe woo cii, an : « Inii weɗ fu na hee woye Israayel ci : “ Ɗu hotootiɗ nga, ŋ woyoh na ɗu ŋ eel ci. ");
INSERT INTO sav_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ɗu heyɗi haɓɗe ali in wiiriis ñaamkaah ɓaat nga so, findi kooh ci nataal ci haɓɗohu urus wala haalis. ");
INSERT INTO sav_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ɗu na hee ɓaye merhey, ɗu haɓɗiɗ to seeƴkoha. Ɗu degan pe' ci, mbaal ci na inoh ci nga, ci hoomɗassan na ci seeƴkohsan wuu jam harmban ndo na ɗu. Te mi, ŋ hey haye ŋ barke'iɗ ɗu ŋ ɗisik ci ŋ teeɓohan jen ne mi yii nga. ");
INSERT INTO sav_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ɗu haɓɗiɗee so seeƴkoha na atoh ɗah, wa kinaat nik atoh pestuuɗ, ini ɗu na hee ca pestohe na ɓekee ca hoolaaɗi. ");
INSERT INTO sav_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kinaat to haɓɗiɗ seeƴkoha njooliɗ po ɓo' kee nga ɗah rapan rap, ineem na tahe tas-ɓarngiŋ ɗe hotuk. ” » ");
INSERT INTO sav_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Nikiɗi taalndiɗta woyeeɗa na Musaa an : « Nakoh cii, ceɗ fu na hee degɗe Israayel ci : ");
INSERT INTO sav_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ɓo' nu rom ñaami nik Heber ɗah, a pangkiɗan ɗe kiis yasna-yino. Ŋ kiis ka yasna-kanakɗoh, ñaameem pul nga te a wirndanɗi ali in. ");
INSERT INTO sav_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nik ne a ƴaar, te wa a na romse, raak ɗe raakɗi ɓitiɓ ɗah, a pulan nga raakaaɗi ɓitiɓ. Wa raak ɗe raakeen ɓitiɓ ɗah, ɓitiice pulan na ɗe. ");
INSERT INTO sav_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nik ne ɓoyi rom ɗe, a yi waakiɗ ɗe ɓitiɓ te ɓitɓeem raak na ɗe kuɓu ƴaar wala ɓitiɓ ɗah, ɓitɓi na kuɓuuci jen tasan na ɓoyi romee ɗe ; a yi dong pulan. ");
INSERT INTO sav_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Waaye a woo wooriɗ ne, a waaɗiɗ heɗ ce, na ɓitiice na kuɓuuciŋ ɗe po a waaɗɗi pul a raak haf ce ɗah, ");
INSERT INTO sav_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","heɗ ce hey ɓaye Kooh findi seede, a tikin nofiŋ ɗe ŋ yahndeeriŋ kahni, a oƴa, jaar a nik ñaamiŋ ɗe ŋ ini tas ŋ kipes kiŋ ɗe jen. ");
INSERT INTO sav_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ɓo' nu toon kuɓkiŋ ɗe ɓitɓi findi ñaami kilooksan ɗah, yeem heyɗi pule findi puliŋ ñaam ci ɓinooɓi. ");
INSERT INTO sav_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ƴaari rom ɗe, nik ne a waaɗee ɗe ɓitiɓ, kaɗ po a neɓisɗi ɗe ɗah, a hey yooɓɗiɗe ɓaah ciŋ ɓitɓeem ne ɓa romis ɗe. Ŋ wori a wor ɗe weem a faɗta ɗe, a minanɗi ɗe toon jaambur. ");
INSERT INTO sav_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nik ne ƴaari rom, a romiɗ ɗe kuɓkiŋ ɗe ƴaari ɗah, a ambaat ɗe findi kuɓu ɓitiɓ na ambohse. ");
INSERT INTO sav_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Waa nu wa min nik nga ɗah, ɓayis ɓitiɓ wiiriis ɓaat nga ɗe tahanɗi po, in haawsu ŋ kañam kiŋ ɗe wala ɓekkaahiŋ ɗe wala ayiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","A tumɗuuɗi yino ŋ in ci kaahay ceem ɗah, a hey mine coot moɗoɗ te wa raakanɗi wirind. ");
INSERT INTO sav_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ɓo' laɓ ɓo' po a ap ɗe ɗah, a apsan apu. ");
INSERT INTO sav_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Raak ɗe tiiɗaa, waaye wa taamb taamb ŋ yaah ciŋ ɗe ɗah, ŋ hey ɗa teeɓe ɗiski a joy naafkoh. ");
INSERT INTO sav_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nik ne a aƴaaruk ɓek ɗe nga po a ñaañohha ɗe a appa ɗe ɗah, ali a naafuk ŋ seeƴkohaaniŋ ngo sah, kooɗohaat ɗe nga ne a apu. ");
INSERT INTO sav_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ɓo' laɓ yaayiŋ ɗe wala baabiŋ ɗe ɗah, a apsan apu. ");
INSERT INTO sav_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ɓo' rok ɓo', a ambu na ɗe wala raak ɗe tooniɗ ɗe ɗah, a apsan apu. ");
INSERT INTO sav_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ɓo' nu kiimiɗ yaay ɓa wala baab ɓa moɗaaɗi ɗah, a apsan apu. ");
INSERT INTO sav_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ƴaar nu ngaskohee na morom ce po a tap ɗe kurpañ wala atoh, a kaanɗi waaye wa faan ɗe, ");
INSERT INTO sav_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","a mirndoh kuruk, po a pul a tiindsukee na ndooɗ ɗah, ƴaari tapoh heyɗi tumse in, a wirndan wirind neeh ci yeem joyee panguk dong, te a paƴ ɗe po a wir. ");
INSERT INTO sav_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ɓo' nu ɓay ndooɗ a laɓ ñaamiŋ ɗe ƴaar wala ɓitiɓ po a ap ɗe ɗah, ñaameem hey wirndukɗasse. ");
INSERT INTO sav_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Waaye wa deg neeh yino wala kanak, a kurkiɗuk ɗah, cari a car koporiŋ ɗe hey tahe po, a heyɗi wirndukɗasse. ");
INSERT INTO sav_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ɓi ɓo' hiñohee po ɓa tapuk ɓitiɓ rook, a taamboh nga, a ar raak kuɓu te wa ɓekɗi ɗe in ɗah, ɓoyi tapkoh wirndan wirind ƴaar ɓitɓeem ini a meeksohan te a wirndana ŋ fiki atte'oh ci. ");
INSERT INTO sav_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Waaye in wiiriis raak nga ɗah, kiñin wirndohsan kiñin ; ");
INSERT INTO sav_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","has wirndohu has ; sis wirndohu sis ; yaah wirndohu yaah ; kot wirndohu kot ; ");
INSERT INTO sav_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","doh wirndohu doh ; gaañ wirndohu gaañ ; ɓuur wirndohu ɓuur. ");
INSERT INTO sav_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ɓo' nu laɓ ñaamiŋ ɗe ƴaar wala ɓitiɓ po a eɗ hasiŋ ɗe ɗah, a hey ɗe faɗe a raak haf ce, wa nik wirndiŋ hasi a aam. ");
INSERT INTO sav_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","A cal sis ɗah, a hey ɗe faɗe a raak haf ce, wa nik wirndiŋ sisi a cal. ");
INSERT INTO sav_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Inoh nu maang ɓo' po a ap ɗe ɗah, a tapsan tapu atoh po a kaan, septi sah ñamsanɗi, waaye heɗ ce heyɗaa ambohse. ");
INSERT INTO sav_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nik ne a saahee saah po heɗ ce woyuusaa te a niiɗɗi ɗe po a appa ɓo' ɗah, inoh feem tapsan tapu atoh po a kaan, heɗ ce nam apu. ");
INSERT INTO sav_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Heɗ ce woyu ne a wirndan wirind ne a pes ɗah, a wirndan in nu a meeksu ɗah. ");
INSERT INTO sav_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nik ne a maang komaaki ƴaar wala ɓitiɓ ɗah, a naman tumu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nik ne a ap ñaam ƴaar wala ɓitiɓ ɗah, heɗ ce joy wirind heɗ ñaami ƴel haalis ndaŋkiyaah-kaahay (30) te inoh fi tapu atoh po a kaan. ");
INSERT INTO sav_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ɓo' nu kunis ngurtut wala a ac naac, a faɗa kunsaaɗi po inoh wala mbaam jaambur keen nga ɗah, ");
INSERT INTO sav_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","heɗ wa hey wirnde candoomiŋ ɗoopti kaanɗi, a raak ɗe. ");
INSERT INTO sav_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Inoh nu maang inoh wiiriis, a gaañ ɗe po a kaan, raak ca ɓaahɗi heɗ ɗah, inoh fi maangoh hey toonse, ɓi raak ca paysoh haalsi na inoh fi kaan. ");
INSERT INTO sav_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Waaye nik ne wa inhasseen ne inoh fi apoh maañiɗ na saah kiŋ ɗe po heɗ ce woyuusaa te a niiɗɗi ɗe ɗah, a hey kooɗe inoh fi kaan, a wirndoh ɗe inoh wiiriis. ");
INSERT INTO sav_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Ɓo' nu rok inoh wala mbaal, a ap ɗe wala a toon ɗe ɗah, a na hee wirndohe inoh yatuus nik ne a rok inoh ɗah, wala mbaal nikiis nik ne a rok mbaal ɗah. ");
INSERT INTO sav_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Rokoh nu telu daji'e ne a rok, a laɓu po a kaan, raak wa na wek ɗah, yi ap ɗe ambsanɗi findi ɓoyi ap ɓo'. ");
INSERT INTO sav_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Waaye wa raak nohi puliɗ ɗah, yi ap ɗe hey ambse findi ɓoyi ap ɓo'. Rokoh nu ambu ɗah, a wirndan wirind ini a rok ; a raakɗi ali in ɗah, a hey toonse findi ñaam ne ini a rok wirndu. ");
INSERT INTO sav_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Nik ne ini a rok, findi inoh, mbaam, mbaal wala pe', ris na ɗe kaanaaɗi ɗah, a hey ɗe wike, te a wirind heɗ ce in hend na ɗoopteem. ");
INSERT INTO sav_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ɓo' nu niiɗee ŋ yohon wala nguuk, a faɗ ɗoopaat ciŋ ɗe ca pul po ca ñamiɗ yohon jaambur ɗah, a hey wirndohe ñamɗeem ini uup baah ŋ in ca a kooɗoh ŋ yohon ce wala ŋ nguukiŋ ɗe, a yi yi ñamɗoh. ");
INSERT INTO sav_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ɓo' nu dohke po wa ɓoƴsuk koraaɓ, wa doh koleer jaambur wala yohon nguɗsaaɗi wala wi na hane paar ɗah, a wirndan wirind ini wa doh jen. ");
INSERT INTO sav_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ɓo' nu dengkohu ŋ kahan ce kopor wala in wiiriis, ca roku nga po rokohi ambu ɗah, rokoheem hey wirnde waas kanak ini a roke. ");
INSERT INTO sav_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Waaye rokohi ambuuɗi ɗah, heɗ kahneem hey kaɗe ŋ fiki kilifaaci ne ɓa atte andi yaah ce kaɗɗi nga. ");
INSERT INTO sav_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Nookoh nu raak ŋ harmban ɓi ɓo' ŋ ini kaɗ ŋ inoh, mbaam, mbaal wala pe', mbaa kulɓa wala in nu min muuƴ, po ɓo' min woo ne weɗɗi ɗah, ɓa hey kaɗe ŋ kilifaaci, yi eɗsanɗi keeh hey wirnde hend na ineem waas kanak. ");
INSERT INTO sav_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ɓo' nu nakoh niiɗ mbaam, inoh, mbaal, pe' wala ɗoopaat nu a min nik ɗah, ɗoopteem kaan, a weer wala a roku te ɓo' maasɗi ɗah, ");
INSERT INTO sav_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ɓoyi naksee niiɗ hey giñe ŋ fiki Nikiɗi ne yaah ce kaɗɗi nga. Heɗ ɗoopteem hey teyɗuke giñeem te niiɗohi wirndanɗi ali in. ");
INSERT INTO sav_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Waaye wa woor ne ɗoopti rokohu ŋ yaah ce ɗah, a hey wirnde heɗ ce. ");
INSERT INTO sav_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nik ne wa wooriɗ ne a ɗoopaat-nduuf ap ɗe ɗah, niiɗohi hey haye na ini tas ŋ ɗoopti, wa teeɓoh ineem ; ndeem a wirndanɗi. ");
INSERT INTO sav_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ɓo' nu ɓanduk ɗoopaat, ɗoopteem weer wala a kaan te heɗ ce maasɗi ɗah, a wirndan ɗe wirind. ");
INSERT INTO sav_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Waaye heɗi maasoh ɗah, yi ɓanduk heyɗi wirnde. Nik ne ɓa woytiɗkohee wirind ne a panguk na ɗoopti ɗah, a na hee eɗohe ini ɓa woytiɗkohee dong. ");
INSERT INTO sav_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ƴaar nu woo na cafaƴ inhaaɗi ƴaar yi nguɗɗuuɗi cakiim po a faanuk ɗe ɗah, a eɗohan eɗoh cakiim kiŋ cafƴeem, a tum ɗe ɓitiice. ");
INSERT INTO sav_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Baabiŋ cafƴi teyɗukɗi ɗe on ƴaari ɗah, ƴaareem hey wirnde kopor hend na cakiim cafaƴ inhaaɗi ƴaar. ");
INSERT INTO sav_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kinaat faɗ ɓitɓi na luhuse a pese. ");
INSERT INTO sav_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ɓo' rapkoh na ɗoopaat ɗah, a apsan apu. ");
INSERT INTO sav_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ɓo' nu seeƴuk, te a seeƴukɗi wuu so mi yi Nikiɗi dong ɗah, a ɗumbsan ɗumbu. ");
INSERT INTO sav_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ali ɓo' nga ɗu kinaat torhiɗ jaambri genohaah ŋ kur ki, laam ɗu namee nik jaambur ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ɓitiɓ nu ƴaar ce kaan ɗah, kinaat ɗe torhiɗ. Yaɗuuni baab ɓa kaan, kinaat ɗe nam torhiɗ. ");
INSERT INTO sav_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Wa raak, a leehuk rek ne ŋ naaf ɗe ɗah, wa wooraat yi ɓaahan ɓi tumana ne ŋ hey kerhe nga. ");
INSERT INTO sav_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Te ŋ jaaran ayruk lool, ŋ apɗuk ɗu na ndang po ɓitiɓ ciŋ ɗu nik raakaaɗi ƴaar, kuɓuuciŋ ɗu nik raakaaɗi baab. ");
INSERT INTO sav_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ɓo' nga ɗu ɓand ñakiɗ, yi nam ɓaah ŋ cuuɓiŋ ngo, kopor ɗah, wa kinaat mand na findi ɓinooɓi na tumohe ; kinaat meeksoh ini deggan ŋ kombot ki. ");
INSERT INTO sav_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ɓo' nga ɗu tayle'u palto ɗah, a wikaat heɗ wa wa ŋ noha mbaɗi. ");
INSERT INTO sav_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Laam weɗ dong a raak ulkoha. Wa ɓayu ɗah, a taskohan ye findi uuf ? Te a leehuk ne ŋ naaf ɗe ɗah, ŋ hey kerhe nga, ŋ Heɗ yirmande. ");
INSERT INTO sav_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ali ɓo' nga ɗu kinaat woo in moɗaaɗi ŋ kilifaaci te ali ɓo' nga ɗu kinaat yonj ɓoyi adgoh cuuɓiŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ali ɓo' nga ɗu kinaat to yiih eɗ ɓakiŋ ngo ngaŋ in ci a nguɗan jen na ɓakiŋ ngo ngaŋ reseñi na oliiwi. Yaa nu nga ɗu hey yo waɗe kuɓkiŋ ɗe saawi ƴaari, ");
INSERT INTO sav_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","te yaa nu nga ɗu na hee name tum ɗaa na inoh ciŋ ɗe na mbaal ciŋ ɗe wala pe' ciŋ ɗe. Saaw ciŋ ca raakan na ndaamuuciŋ ca neeh yasna-kanak, wa yasna-kaahayɗoh, ɗu eɗ to ca. ");
INSERT INTO sav_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ɗu na hee nike ɓo' hooliɗ wuu so. Ɗu ñamanɗi septiŋ ɗoopti ɗoopaat-nduuf ap, ɗu njafɗan ɗe ɓuu ci. ");
INSERT INTO sav_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ali ɓo' nga ɗu kinaat pasaroh woo kerahne ; te ali ɓo' nga ɗu kinaat lang na ɓo' añaandiɗ a seede'e ini nikɗi keeh. ");
INSERT INTO sav_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ali ɓo' nga ɗu kinaat taambiɗ mboolo po a tum in moɗaaɗi ; te yaa nu ɓeeɗku ŋ ngel nga ɗu ne a seede ɗah, a kinaat taambiɗ mboolndi po a kee ɗala waas. ");
INSERT INTO sav_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ali ɓo' nga ɗu kinaat lang na ñakiɗ sagu ñaki a ñak ne a ngele ɗah. ");
INSERT INTO sav_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ɓo' nga ɗu, sangiɗiŋ ɗe muuƴɗuk inoh wala mbaam, a kaɗ po a coh na inoh feem wala mbaameem ɗah, a ɓayɗan ɗe ɗe ɓayiɗ. ");
INSERT INTO sav_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ɓo' nga ɗu raak mbaamiŋ sangiɗiŋ ɗe keeniɗ na sifiŋ ɗe ɗah, ali liiɓiŋ ɗa teyɗukɗi ne fu ɓaatɗoh ɗe sah, fu ambohan ɗe amboh, a tokis ɗe. ");
INSERT INTO sav_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ali ɓo' kinaat eɗaaɗi ñakiɗi keeh kiŋ ɗe ne a ngele ɗah. ");
INSERT INTO sav_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ɓo' nu nga ɗu ɗah, usaat ini nikɗi keeh te ali ɓo' nga ɗu kinaat ɓek kakaan kiŋ ɓoyi tumɗi wala ɓoyi yurah. Laam tooñoh mand ɗaa, ŋ faɗanɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ɓo' nu kee atte'a nga ɗu ɗah, a kinaat teyɗuk onu in, laam aaf na fuulɗe fuuliɗ has ciŋ inhiɗ ci te wa na yahrohe yahroh atteeni ɓooɓi yurhiɗ ci na atte'e. ");
INSERT INTO sav_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ali ɓo' nga ɗu kinaat torhiɗ jaambur. Ɗu inhiɗ findi wa mand, laam ɗu nikee jaambur ŋ Misra. ");
INSERT INTO sav_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ɓo' nu nga ɗu guuraat yohon ce kiis yasna-yino, ");
INSERT INTO sav_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","kiis ka yasna-kanakɗohan, a faɗaata wa kiis, ñakiɗ ciŋ cuuɓi njirñiɗkoh ɓaɓ ci, ini tas nik wuu ɗoopaat ciŋ bilaf fi. Nguuk ciŋ reseñ ci na ciŋ oliiw ci namaat tumu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ɓo' nu nga ɗu ɗah, a pangkaat ini a joy panguk ŋ neeh ci yasna-yinooci ; waaye mbehi yasna-kanakɗoh, a faɗaata, inoh fiŋ ɗe na mbaamiŋ ɗe min iɗsiɗuk. Ñaamiŋ kahan ce na jaambri na pangke na ɗe nam iik. ");
INSERT INTO sav_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ɗu hey taambɗe nakoh ci ŋ eɗ ɗu jen te kinaat moos kiim in ci ɓinooɓi amb ne ca kooh, tiik ciŋ ca sah kinaat kerhu ŋ nguɓ ciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ɗu hey feetke wuu so waas kaahay ŋ kiis ki. ");
INSERT INTO sav_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ɗu hey feetke feetiŋ Mbuuruuci raakaaɗi lawiir ci. Ini ree neeh yasna-kanak, ɗu ñaman mbuuru raakaaɗi lawiir, findi ŋ woyohee ɗu wa, wa nikan ŋ jamanooni wa ambu, ŋ caɓniŋ mbong ci. Laam ŋ caɓneem weɗ ɗu puloh Misra. Te ɗu hayee feetke ɗah, ali ɓo' kinaat hay ŋ fikiiso yaah ɓarang. ");
INSERT INTO sav_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ɗu hey feetke feetiŋ Nguɗ ci koc, ɗu kom mbo ca. Ɗu hey name feetuk feetiŋ Nguɗ ci mirndoh, wa nikan ŋ reehɗohaaniŋ kiis ki ne ɗu toor in ci ɗu nguɗoh yohon ci po ƴut ɗah. ");
INSERT INTO sav_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Waas ci kaahay cii ŋ kiis ki, ƴaar ci jen hey haye wike haf ɓa nga so, mi yi Heɗ ɓa Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ɗu seeƴkee ɓi ɗoopaat wuu so ɗah, ñif miŋ ca kinaat hun na in raakiɗ lawiir. Te kinaat faɗ faymiŋ ɗe wa neeh po kim na ɓaaɓa. ");
INSERT INTO sav_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ɓo' nu nga ɗu ɗah, a komaat to ini a koc nguɗ ŋ yohon ciŋ ɗe ŋ kahan ndo mi yi Nikiɗi, Koohiŋ ɗu. Ali ɓo' nga ɗu kinaat tikoh koteng miis mi kooɗohu ŋ ndaam ce. » ");
INSERT INTO sav_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Wa Nikiɗi ƴut woo nakoh cii, a degga nga ne : « Ŋ hey woose malaaka, a adug, a niiɗee ɗu ŋ waasi, po a ɓek ɗu ŋ ɗiska ŋ kooɗkiɗ ɗu. ");
INSERT INTO sav_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Wortukaat, kinaat ndengsiɗkoh na ɗe, kerhiɗaat ɗe ; ɗu ndengsiɗkoh na ɗe ɗah, a muñɗanɗi ɗu, laam tiikiŋ ngo wii nga ɗe. ");
INSERT INTO sav_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ɗu kerhiɗ ɗe, ɗu tum in ci ŋ woo jen ɗah, ŋ hey sange ɓi sang ɗu, ŋ langanɗi na ɓi langɗi na ɗu. ");
INSERT INTO sav_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaakaaniŋ ngo hey ɗu adgiɗe, a ɓek ɗu ŋ kur kaŋ Amoor ca, Hit ca, Peris ca, Kanaan ca, Hiw ca na Yebuus ca te ŋ hey ɓa ɗumbe. ");
INSERT INTO sav_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ɗu heyɗi ƴekɗe in ca ɓa amb ne ca kooh, ɗu heyɗi ca ñaamke, te ɗu heyɗi ca haɓɗiɗe in ci ɓa na haɓɗiɗee ca. Waaye ɗu na hee ca hey yahrohe jameet, ɗu pooksoh atoh ca tufkiɗuuɗ ca. ");
INSERT INTO sav_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ɗu ñaamkan ndo mi yi Nikiɗi Koohiŋ ɗu te ŋ hey barke'ɗe kañam kiŋ ɗu na anaahiŋ ɗu, ŋ hey ɗu usɗe ŋ kosaay. ");
INSERT INTO sav_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Kur kiŋ ɗu raakanɗi ɓitiɓ ci na yahkiɗke rook wala ɓi minɗi raak kuɓu. Ŋ hey ɗu one kipes hutiɗ. ");
INSERT INTO sav_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ɓa kerah ne ɗu ɓii hay ɗah, ŋ hey ɓeke tiit nga ɓa, ŋ ɓek jahaskoh ŋ cuuɓ ci gen ŋ kur ci ɗu aasohan jen, ɓi sang ɗu jen hey saandohe ŋ fikiiɗu. ");
INSERT INTO sav_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ŋ hey tuuƴe caakoof ci, ca adug ɗu, ca aañ Hiw ca, Kanaan ca na Hit ca bala ɗu reyan ɗah. ");
INSERT INTO sav_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ŋ aañanɗi ɓa ŋ kiis yino po kur ka kee nika hulang, ɗoopaat-nduuf ci kee laaya, wa baahuu nga ɗu. ");
INSERT INTO sav_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ŋ hey ɓa aañe ƴin-ƴin, ɗu ɓaatke po mbaɗna ɗu minan ɓay kur ka. ");
INSERT INTO sav_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ŋ hey ɗu teeɓe kikiƴ kaŋ kehƴa ŋ onan ɗu. Ini amboh Cookmaŋ-Hapeel-ca po cookmaŋ Mediterane. Na ini kooɗoh kehƴi hulangi po laɓpa ŋ kalaŋ Ewfaraat. Ŋ hey dege ɓooɓiŋ kur ceem ŋ yaah ciŋ ɗu, ɗu aañ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ɗu heyɗi ambtiɗohe na ɓa, ɗu heyɗi name ambtiɗoh na in ca ɓa tum kooh. ");
INSERT INTO sav_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ɓa heyɗi gene kur kiŋ ɗu po ɓa kee taha ɗu bakaaɗ nga so, ndaa ɗu hey ñaamke kooh caŋ ɓa te ineem na ɓekee ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Nikiɗi woyissa Musaa ne : « Fu hey rape fu hay ɗiskiŋ ngo ŋ tangoori ; huna na Aaruna, Nadab, Abihu, na yakak ndaŋkiyaah-yasna-kanak (70) ŋ ɓiŋ Israayel. Ɗu hay ɗah, nikaat ŋ ɗisik usiɗ, ɗu ƴek nga. ");
INSERT INTO sav_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","A fu dong na hee reɓe nga so, waaye ɓinooɓi heyɗi ree te mboolndi rapanɗi na ɗu ŋ ɗafuk tangoori. » ");
INSERT INTO sav_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musaa kaɗta woosa mboolnda in ci Nikiɗi woo na ci a nakoh jen. Mboolnda hunnda jen loffa ne : « Ɓoo hey tume in ci Nikiɗi woo jen. » ");
INSERT INTO sav_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musaa fiissa woo ciŋ Nikiɗi jen. Wa Kooh wiis, a kurukka na ɓaaɓa teel, a haɓiɗta seeƴkoha ŋ tas tangoora, a yippa atoh ndaŋkiyaah na kanak (12) wuu cuuɓ ci ndaŋkiyaah na kanak (12) ciŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A nakka ɓi komaaki ƴaar ɓaah ŋ Israayel ci ne ɓeem seeƴuk na ɗoopaat ci hoomɗassan wuu Nikiɗi, te ɓa hoos ɓi naar ne ɓa seeƴuk seeƴki ɓa na seeƴke wuu jam ŋ harmban ɓa na Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ŋ ineem Musaa ɓayya cambanaŋ ñif maŋ ɗoopaat ca, a tummbaa ŋ inaa, wa tas, a lissaa ŋ ɗafuk seeƴkohaana. ");
INSERT INTO sav_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ƴutta, a ɓayya woo ci fiisu wuu Ambtiɗohi, a jangɗeeɗa mboolnda ca ŋ ɗafka. Ɓa woosa ne : « Ɓoo hey tume in ci Nikiɗi woo jen te ɓoo hey ɗe kerhiɗe. » ");
INSERT INTO sav_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musaa ɓayya ñif ma a ɗaake, a liseeɗaa ŋ mboolnda, a woyeeɗa ne : « Wii weɗ ñif mi aamu wuu ambtiɗohi Nikiɗi tufkiɗ na ɗu ŋ woo ci a woo cii jen. » ");
INSERT INTO sav_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Wa ɓa ƴut seeƴuk, Musaa rappa ŋ tangoora, a yi na Aaruna na Nadab na Abihu na yakak ca ndaŋkiyaah-yasna-kanak (70) caŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ɓa hotta Koohiŋ Israayel ; ŋ ooɓ kot ciŋ ɗe, mandee haa wa dungohu peme bulo koceet findi eel ci. ");
INSERT INTO sav_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Waaye Nikiɗi tumɗi yakak caŋ Israayel miskiɗ, ɓa hoteen ɗe, ƴutta, ɓa ñammba, ɓa annda. ");
INSERT INTO sav_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Wa in ceem coot, Nikiɗi woosa Musaa ne : « Rapa po ŋ ɗafuk tangoori ŋ ɗiskiŋ ngo, fu nik nga. Ŋ hey ɗa eɗe atoh ci ɗapas ci, ɗiski ŋ fiis waasi na nakoh ci ne fu jangiɗ ɓooɓi ca. » ");
INSERT INTO sav_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musaa hunnda na dagiŋ ɗe Yosuwe, a rapeeɗa tangooraŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Waaye bala a rapan ɗah, a woosa yakak ca ne : « Sekaat ɓoo ndii po mbaɗna ɓoo hayan. Aaruna na Hur hey tase na ɗu, in nu ɓo' raak woyaah ɗah, a woyaata na ɓa. » ");
INSERT INTO sav_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musaa rapeeɗa tangoora, ɗuukra tumee eel ullaa. ");
INSERT INTO sav_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Yaki Nikiɗi yak siñaarɗeeɗa ŋ ɗafuk tangooraŋ Sinaay. Israayel ci hotee nga po haa wa koraaɓ yakak kaɓ ŋ ɗafuk tangoora. Eela ulla tangoora ini ree neeh yasna-yino. Ŋ neeha yasna-kanakɗoh, Nikiɗi ɓeeɗkohha Musaa ŋ ɗooƴ eela. ");
INSERT INTO sav_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musaa aassa ŋ eela, a rapeeɗa po ŋ ɗafuk tangoora. A nikka nga neeh ndaŋkiyaah-nikiis (40). ");
INSERT INTO sav_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nikiɗi woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","« Woya Israayel ci ne, ɓa pulɗaat sarah, ɓa eɗ to. Ɓo' nu teyɗuka tum na keeñ soosiɗ ɗah, teyɗukɗaat to wiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","In cii ceɗ ɗu na hee rahse nga ɓa : urus, haalis na moos. ");
INSERT INTO sav_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Ɗu hey name rahas : ooy bulo, ooy ruumind eɗfiɗ na ruumind coy na leeŋ. Ɗu hey rahse find pe', ");
INSERT INTO sav_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","und kuy mbaal suupuuɗ ruumind, und inoh cookom na ndooɗ kassiya. ");
INSERT INTO sav_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ɗu hey rahse diwliin fuuɗoha laampa, ɗu hey rahse eeñɗohaaci haɓɗohsan diwi na hoolɗohse hoolɗuuɗ ci wuu so, ɗu hey rahse eeñɗoha wuu cuuraayi. ");
INSERT INTO sav_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ɗu hey name rahas peme sooham na peme moɗsinoha efoodi na nafaani ŋ fikiiri. ");
INSERT INTO sav_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ɓa hey yo haɓɗiɗe ɗisik hooliɗ, ŋ gen ŋ harmban ɓa. ");
INSERT INTO sav_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ɗu hey haɓɗe Genohaani, ɗu haɓiɗndoh in ci hun naa jen findi in ci ŋ teeɓan ɗa ndii jen. ");
INSERT INTO sav_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ɗu haɓɗee Wahndeeni ɗah, ɓa ɓayaat hang kassiya, ɓa haɓiɗa naa. Hutiiniŋ wa nikan suung kanak na camban, angiini nik suung na camban, njooliini suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Fu ula na urus koceet ŋ ɗooƴi na finhoori. Fu haɓɗiɗa banda urus ŋ finhoori po wa wil. ");
INSERT INTO sav_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Fu hey wa haɓɗiɗe inaa nikiis haa kiñi, ca nikan urus, kot nu nga ɗah raak yino ; ɓak nu nga ɗah raak kiñi kanak. ");
INSERT INTO sav_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Fu hey wa haɓɗiɗe ndooɗ kassiya, fu ul ca na urus, ");
INSERT INTO sav_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","fu taambiɗ ca ŋ ɗooƴ kiñiici, ca nik ambohaaciŋ wa, ne wahndeeni ɓaysee ɗah. ");
INSERT INTO sav_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ndooɗ ceem risan ŋ ɗooƴ kiñiici, ca nihsassanɗi. ");
INSERT INTO sav_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Fu ɓekan in ci teeɓoh Ambtiɗohi maa hee ɗa eɗe ŋ Wahndeeni. ");
INSERT INTO sav_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Fu haɓɗohan kunohaaniŋ wa urus koceet, wa nik ɗiski na romkohse. Hutiiniŋ wa nikaat suung kanak na camban, angiini nik suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Na urseem, fu hey tiɓe po fu puliɗ nataal seruben ŋ ɓak nu nga ŋ ɓak ci kanak ciŋ angiiniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ca na hee hey yurhiɗkohe, ca hiir ŋ ɗiski na romkohse, ca raɗis paɓ ciŋ ca ŋ ɗafki, ca ɗipa. ");
INSERT INTO sav_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Fu hey ɓeke in ci maa hee ɗa eɗe, ci na teeɓohe Ambtiɗohi, ŋ ɗooƴ Wahndeeni. Ƴut ɗah, fu deg kunohaani, weɗ ɗiski na romkohse, ŋ ɗafki. ");
INSERT INTO sav_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ŋ cohan na ɗa ndeem ne ŋ woo na ɗa, ŋ harmban seruben ci kanak ci ŋ ɗafuk Wahndeeni ɗaak in ci na teeɓohe Ambtiɗohi, ŋ eɗ ɗa nakoh ciŋ ngo jen wuu Israayel ci. ");
INSERT INTO sav_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Fu hey ɓaye hang kassiya, fu haɓiɗ taaɓul, hutiiniŋ wa nikan suung kanak, angiini nik suung yino, njooliini nik suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Fu hey wa ule jen na urus koceet. Fu haɓɗiɗa banda urus po wa wil. ");
INSERT INTO sav_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Fu hey wa name haɓɗiɗ kaadar, angiiniŋ wa nikan santimeetar yasna-kaahay, fu haɓɗiɗa banda urus po wa wil. ");
INSERT INTO sav_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Fu hey haɓɗiɗe taaɓli inaa nikiis haa kiñi, ca nikan urus, fu tum ca ŋ koñ ciŋ wa nikiis ci, teemb ŋ kot ciŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Kiñiici na hee nike ŋ sero kaadari, ndooɗ ci na hee ɓayohse taaɓli taamban nga ca. ");
INSERT INTO sav_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Fu hey haɓɗe ndooɗ ceem, ca na hee nike ndooɗ kassiya, fu ul ca na urus, ceɗ na hee wa ɓayohse. ");
INSERT INTO sav_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Fu hey wa haɓɗiɗe ɓi palaat, ɓi kaas, ɓi meeme na ɓi koppa, ca jen ca na hee haɓɗohse urus koceet ; meemeeci na koppaaci ceɗ na hee tume anaah ci seeƴkohsan wuu so. ");
INSERT INTO sav_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ŋ ɗafuk taaɓleem, fu na hee dege mbuuruuci wuu so nga, te ca genan degsee nga, ŋ fikiiso. ");
INSERT INTO sav_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Fu hey ɓaye urus koceet, fu tiɓa po fu puliɗ degoha laampa na tasiŋ wa na faaniŋ wa na ɓak ci tas jen. Ca jen ceɗ ɓaahan ini ca tiɓohsan. ");
INSERT INTO sav_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Wa hey raake naak yasna-yino ŋ faaniŋ wa, kaahay ŋ ɓaki singi, kaahay ŋ ɓaki ñaahmi, ca nik sal kaahay. ");
INSERT INTO sav_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Naak ci yasna-yinooci, waa nu nga ɗah hey raake koppa kaahay findi amand na posohe, waa nu nga ɗah raak ɓi pos rangsukaaɗi na ɓi pos rangsukiɗ. ");
INSERT INTO sav_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Faani hey raake koppa nikiis findi amand na posohe, waa nu nga ɗah na pos ciŋ wa rangsukaaɗiici, na ci rangsukiɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ooɓ sal nu nik ɗah, hey raake pos rangsukaaɗi yino ŋ faaniŋ degohaaniŋ laampaaci po sal ci kaahay ci jen raak. ");
INSERT INTO sav_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Pos ci rangsukaaɗiici na naak ci jen nikan urus koceet tiɓuuɗ, ca na ini tas ŋ degohaaniŋ laampaaci jen, ceɗ ɓaahan ini ca tiɓohu. ");
INSERT INTO sav_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Fu hey haɓɗe laampa yasna-kanak, ceɗ na hee nike ŋ ɗafki ne ca ñiinɗee fikiiriŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Fu hey wa haɓɗiɗe tanaaƴ na tumoha ƴuuƴ, fu na hee ca haɓɗohe urus koceet. ");
INSERT INTO sav_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kilo urus koceet ndaŋkiyaah-kaahay (30) ceɗ na hee ɓayse, haɓɗoha degohaaniŋ laampaaci na in ci hun naa jen. ");
INSERT INTO sav_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Marka te fu haɓiɗa findi wa fu teeɓsee ŋ ɗafuk tangoori. ");
INSERT INTO sav_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ini kaɗ ŋ Genohaani, fu hey wa haɓɗe na haf-piis ndaŋkiyaah, ca teɗohsan ooy leeŋ eɗfiɗ ndengiɗ ambsohuuɗ na ooy bulo, na ooy ruumind eɗfiɗ na ruumind coy ; piis ci moɗsinohsan ɓi nataal seruben. ");
INSERT INTO sav_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Piis ceem ceɗ hendan, waa nu nga ɗah, hutiiniŋ wa nikaat saangal ndaŋkiyaah na nikiis (14), angiini nik suung nikiis. ");
INSERT INTO sav_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Yatuus nga ca hey ambsohse suptu yino, yatuus ci tas nam tumu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Piis ci yatuus ci ambsohuuɗ ceem, fu hey ca suptiɗe ɓi yaah koroha ŋ ɓaki winoori ŋ sereendiŋ angiini, ca haɓɗohsan ooy bulo. Yatuus ci ambsohuuɗ ci tas nam suptiɗu mand ɗaa. Yaah ci korohaaci ŋ piis ci ambsohuuɗ ci nikan ndaŋkiyaah-yatuus (50). Ciŋ piis ci ambsohuuɗ ci tas naman nik ndaŋkiyaah-yatuus (50). Korohaaceem, waa nu nga ɗah korɗohu na morom wa ŋ piis ci cinooci ambsohuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Fu haɓiɗ korɗoha ndaŋkiyaah-yatuus (50) ne fu ambsoh piis ceem po baasiŋ Genohaani nik yino. Korɗohaaceem nikan urus. ");
INSERT INTO sav_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ƴut ɗah, fu hey name haɓɗis haf-piis ndaŋkiyaah na yino (11). Haɓɗohaa ca find pe' ; wa nik uloha baasiŋ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Haf-piis ceem ceɗ hendaat, waa nu nga ɗah hutiiniŋ wa nikan saangal ndaŋkiyaah na yatuus (15), angiini nik suung nikiis. ");
INSERT INTO sav_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Fu hey ambsohe piis ci yatuus ci, ca nik yino, fu nam ambsoh yasna-yinooci kiik ca, ca nik yino ; wi yasna-yino'ɗoh nga ca, fu lema kanak ŋ ɓakiŋ aasohaaniŋ ɗiipi. ");
INSERT INTO sav_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Fu haɓiɗ yaah koroha ndaŋkiyaah-yatuus (50) ŋ sereendiŋ piisi yatuusɗoh ŋ piis ci yatuus ci ambsohuuɗ ci, fu nam haɓiɗ yaah koroha ndaŋkiyaah-yatuus (50) ŋ sereendiŋ piisi koc ŋ piis ci yasna-yinooci ambsohuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Fu hey ca haɓɗiɗe korɗoha ndaŋkiyaah-yatuus (50), ca nikan moos ruumind, fu taambiɗ ca ŋ yaah ci korohaaci suptu ŋ piis ci, korɗohaaci korɗoh ca, po baasi nik yino. ");
INSERT INTO sav_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Baaseem hey uupe wiŋ Genohaani saangal yino ŋ hutiini, ini uup hey ɗah wa gaat ŋ finhoori. ");
INSERT INTO sav_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Baasi hey name uup wiŋ Genohaani saangal yino ŋ angiiniŋ wa, wa hey wa uupe camban saangal ŋ ɓakii, wa nama uupis camban saangal ŋ ɓaki tas jaar wa ul wiŋ Genohaani jen. ");
INSERT INTO sav_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Fu hey waake und kuy mbaal suupuuɗ ruumind, fu haɓɗis baas, wa nik ulohaaniŋ baasi kanakɗohiini ; fu nam waakis und inoh cookom, fu haɓɗis baas wiiriis fu raɗisa ŋ ɗafuk baasi kaahayɗoh weem, wa nama ul. ");
INSERT INTO sav_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Fu hey haɓɗe ɓi kaadar, fu na hee ca haɓɗohe hang kassiya, ca na hee hey tufke ne ca amb Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kaadar ci jen hendan hend ; waa nu nga ɗah, hutiiniŋ wa nikan saangal yatuus, angiini nik suung yino na camban. ");
INSERT INTO sav_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Findi ca hend jen, kaadar nu nga ɗah, hey pulɗe ndooɗ kanak findi kot, ca na hee hey hunɗohse te ca laaltiɗohanɗi. ");
INSERT INTO sav_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kaadar ceem fu na hee haɓɗe nga ca ndaŋkiyaah-kanak (20) ŋ ɓak yaah-sing ne fu eɗ pulohaaɗ-noh finho, fu aasee ɗah. ");
INSERT INTO sav_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kaadar ceem hey haɓɗiɗasse tufkoha ŋ ooɓi, ca nikan tufkoha ndaŋkiyaah-nikiis (40), ca haɓɗohsan haalis ; kaadar nu nga ɗah hey raake tufkoha kanak, kot ci kanak ciŋ kaadari ɓeksan ŋ tufkohaaceem. ");
INSERT INTO sav_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Fu hey name haɓɗis kaadar ndaŋkiyaah-kanak (20) ŋ ɓaki winooriŋ Genohaani, wi lahoh na yaah-ñaahum. ");
INSERT INTO sav_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ca nam raak tufkoha ndaŋkiyaah-nikiis (40), ci haɓɗohsan haalis, kaadar nu nga ɗah raak tufkoha kanak ŋ ooɓi. ");
INSERT INTO sav_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Fu nam tufkiɗ kaadar yasna-yino ŋ ɓaki mirndoh ŋ Genohaani, ŋ ɓak muyohaaɗ-noh. ");
INSERT INTO sav_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Fu haɓɗis kanak, ceɗ na hee nike ŋ koñ ci nik ŋ fikiira, ŋ ɗooƴ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hang ciŋ kaadar ceem, ca na hee hey nike kanak ini kooɗoh ŋ kehƴi po ca ree ɗafki ɗah, ca tokɗohu baahiɗ na inaa haa kiñi ; kaadar ci kanak ci nik ŋ koñ ci kanak ceem tumsan ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Jaar fikiiri raak kaadar yasna-kaahay na tufkoha ndaŋkiyaah na yasna-yino (16) haɓɗohu haalis. Kaadar nu nga raak tufkoha kanak. ");
INSERT INTO sav_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Fu hey haɓɗe laat kassiya yatuus, ca galanduk kaadar ci ŋ ɓak yaah-sing, ");
INSERT INTO sav_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","fu nam haɓɗis laat yatuus wuu kaadar ciŋ ɓak yaah-ñaahum, na yatuus wuu fikiira, ŋ ɓak muyohaaɗ-noh. ");
INSERT INTO sav_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Wiŋ leerni na hee taambe ŋ leerniŋ kaadar ci jen, wa ambohan ɓak po ɓak. ");
INSERT INTO sav_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kaadar ci, fu na hee ca hey ule na urus, in ci haa kiñi, ci laat ci taambohan, nikan urus, fu ul laat ci na urus. ");
INSERT INTO sav_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ƴut ɗah, fu yip Genohaani findi wa fu teeɓsee ŋ ɗafuk tangoora. ");
INSERT INTO sav_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Fu hey haɓɗe rido, wa haɓɗohsan leeŋ eɗfiɗ ndengiɗ na ooy bulo, na ruumind eɗfiɗ na ruumind coy ; feroh keeh-keeh moɗsina na ɓi nataal seruben. ");
INSERT INTO sav_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Fu na hee wa kore ŋ kumbin kassiya nikiis yipuuɗ ŋ tufkoha haɓɗohuuɗ haalis, kumbin ceem na hee ulse jen na urus, ca raak koroha haɓɗohu urus. ");
INSERT INTO sav_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ridooneem taamban ŋ ooɓ ɗiski piis ciŋ Genohaani korɗohu ; wa saɓsoh Ɗiski Hooliɗi na Ɗiski Hoolohngaani. Wahndeeni ɗaak in ci na teeɓohe Ambtiɗohi aasɗu ŋ Ɗiski Hoolohngaani. ");
INSERT INTO sav_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ƴut ɗah fu deg kunohaani, ɗiski na romkohse ŋ ɗafuk Wahndeeniŋ Ambtiɗohi, ŋ Ɗiski Hoolohngaani. ");
INSERT INTO sav_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Fu aasee Genohaani, ŋ ɓak pulohaaɗ-noh ɗah, dega taaɓli ŋ yaah-ñaahum, fu deg degohaaniŋ laampaaci ŋ yaah-sing, ca yurhiɗkoh. Ca nikaat bala fu reyan ridooni saɓsohaani ɗah. ");
INSERT INTO sav_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Fu hey haɓɗiɗe aasohaaniŋ ɗiipi rido, wa na hee nike leeŋ eɗfiɗ ndengiɗ, fu moɗsina na ooy bulo, na ruumind eɗfiɗ, na ruumind coy. ");
INSERT INTO sav_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Fu hey waakɗe ridooni kumbin kassiya yatuus, fu ul ca na urus jen. Ca na hee hey yipse ŋ tufkoha haɓɗohuuɗ moos ruumind, ca raak koroha haɓɗohu urus. Tufkohaaci, ca na hee muulohse moos ruumind naayɗuuɗ. ");
INSERT INTO sav_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Fu hey waake hang kassiya, fu haɓiɗ kees seeƴkoha ; wa nikan kaare, ɓak nu nga nik saangal kanak na camban ; njooliini nik suung kaahay. ");
INSERT INTO sav_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Fu hey pulɗe wiic ciŋ wa ŋ koñ ciŋ wa nikiis ci, fu puliɗndohan ca ŋ hangi wa haɓɗohsan, wa na hee ulse jen na moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Fu hey name haɓiɗ in ci na hune naa : tumohaaciŋ weti niiniɗi na peel ci, tumohaaciŋ ñif mi na lisse, furset ciŋ sepet ci na tumohaaciŋ ƴuuƴ ci ; in ceem jen, ca haɓɗohsan moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Fu hey wa haɓɗiɗe giryaas moos ruumind, wa raakan koñ nikiis, koñ nu nga ɗah raak in haa kiñi. ");
INSERT INTO sav_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Fu hey wilɗe nguɓiŋ seeƴkohaani na kaadar, fu deg giryaasi ŋ ɗooƴi ŋ ooɓ kaadari, wa yoor ŋ leerni po ŋ leerniŋ njooliiniŋ seeƴkohaani. ");
INSERT INTO sav_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","7","Fu haɓiɗ ndooɗ kassiya kanak, fu ul ca na moos ruumind. Ca ɓeksan ŋ kiñiici nik ŋ ɓak ci kanak ciŋ seeƴkohaani ne wa ɓaysee ɗah. ");
INSERT INTO sav_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Wa nikan kees, ɗooƴi nik hulang, wa haɓɗohsan findi wi ŋ teeɓ ɗa ŋ tangoori ndii. ");
INSERT INTO sav_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ini wil Genohaani raakaat bayaal. Bayaaleem, wilɗaa na piis teɗohuuɗ leeŋ eɗfiɗ ndengiɗ. Ɓak yaah-sing ne fu eɗ pulohaaɗ-noh finho, fu aasee ɗah, wa nikaat saangal ndaŋkiyaah-yatuus (50). ");
INSERT INTO sav_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Piis ci na hee tokse ŋ kumbin ndaŋkiyaah-kanak (20), kumbin ci yipu ŋ tufkoha ndaŋkiyaah-kanak (20) haɓɗohu moos ruumind, te ca raak koroha na ñoori ca na hee ɓekohse haɓɗohu haalis. ");
INSERT INTO sav_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ɓaki lah yaah-ñaahum hendaat ɗaa, wa nam haɓɗohu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Angiini, ŋ ɓaki lahoh muyohaaɗ-noh, wa na hee nike saangal ndaŋkiyaah-kanak na yatuus (25), ca nam toku ŋ kumbin ndaŋkiyaah, ca yipu ŋ tufkoha ndaŋkiyaah. ");
INSERT INTO sav_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ɓakiŋ aasohaani, ŋ pulohaaɗ-noh, namaat nik saangal ndaŋkiyaah-kanak na yatuus (25). ");
INSERT INTO sav_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Ɓak ci kanak ci aasohaani nik ŋ leerniŋ ca, waa nu nga piis ciŋ wa nikaat saangal yasna-kanak na camban, wa raak kumbin kaahay yipuuɗ ŋ ɓi tufkoha. ");
INSERT INTO sav_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Aasohaani raakaat rido, wa nikan saangal ndaŋkiyaah. Ridooni haɓɗohsan leeŋ eɗfiɗ ndengiɗ, wa moɗsinu na ooy bulo na ruumind eɗfiɗ na ruumind coy. Fu tokɗoh ca na kumbin nikiis yipuuɗ ŋ tufkoha nikiis. ");
INSERT INTO sav_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kon ɗingiŋ bayaali jen haɓɗohsan ɓi kumbin yipuuɗ ŋ ɓi tufkoha haɓɗohuuɗ moos ruumind, ca raak ñoor na koroha haɓɗohuuɗ haalis. ");
INSERT INTO sav_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Hutiiniŋ bayaali nikan saangal ndaŋkiyaah-yatuus (50), angiini nik saangal ndaŋkiyaah-kanak na yatuus (25). Njooliiniŋ ɗingi nikan suung yaah yatuus, wa haɓɗohsan leeŋ eɗfiɗ ndengiɗ, tufkohaaci kumbin ci na hee yipohse haɓɗohu moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tumohaaci na pangkohse ŋ Genohaani, na tatohaaci amba ŋ kehƴi, na ciŋ ɗingi wila, ca jen ca naman haɓɗohu moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Fu hey nake Israayel ci ɓa eɗohee diwliin oliiw riiƴuuɗ, siɗuuɗ, wi kaɓɗan laampaaci wek nu ree. ");
INSERT INTO sav_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ŋ ɗooƴ Ɗiipi-na-Cohohse, ndo fu reyan ridooni ɗasiɗ Wahndeeni ɗah, Aaruna na kuɓuuciŋ ɗe taambkoh laampaaci, ca neehan neeh kaɓ, niin po Kooh wiis. Wa nik nakohi Israayel ci taambɗan gomal nu gomal. ");
INSERT INTO sav_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Fu Musaa, fu hey ɓeeɗke yakak fu Aaruna na kuɓuuciŋ ɗe ƴaar ci : Nadab na Abihu na Elasaar na Itamaar. Fu hey ɓa kooɗohe ŋ Israayel ci, ɓa pangkiɗee so findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Fu haɓɗohana an : Fu hey haɓɗiɗe yakak fu Aaruna kulɓa moɗiɗ, hooliɗ wuu Kooh, wi na teeɓohe yaki a yak. ");
INSERT INTO sav_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Fu nak pangkoh ci ŋ baahiɗ yaah ciŋ ɓa ŋ panguk, ɓa haɓɗiɗ Aaruna kulɓaaci a ɓekkan ne a tufkiɗassee findi seeƴkiɗoh wuu so ɗah. ");
INSERT INTO sav_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Kulɓaaci nikan : Efood, na kulɓa hutiɗ yakiɗ na kulɓa mbaseñ adginkoha na mbahne na seentur. Efoodi mandan na taaɓalye hun na nafa ŋ fikiiri. Kulɓaaceem, ceɗ ɓa haɓɗiɗan taambɗoh fu Aaruna na kuɓuuciŋ ɗe. Ca nikan kulɓa hooliɗ ne ɓa min ndo pangkiɗ findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ɓa haɓɗee ca ɗah, ɓa ɓayan leeŋ, na fiil urus, na ooy bulo na ruumind eɗfiɗ na ruumind coy. ");
INSERT INTO sav_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Efoodi, wa haɓɗohsan leeŋ eɗfiɗ ndengɗuuɗ ambsohuuɗ na fiil urus, na ooy bulo na ruumind eɗfiɗ na ruumind coy. Wa nikan panguk feroh keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Wa hey suptiɗasse ngalla kanak ŋ lecem ci ŋ ɗafki ne wa min ɓekku. ");
INSERT INTO sav_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Wa hey raake tokɗukoha ŋ kinoh ki, wa na efoodi, ceɗ hunan, ca nikan piis yino. ");
INSERT INTO sav_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Fu hey ɓaye atoh peme kanak, wa nikaat pemeeni na woyse sooham, te ngaŋ pemeeceem, fu fiis tiik ciŋ kuɓuuci ƴaar ciŋ caac ɗu Israayel nga ca. ");
INSERT INTO sav_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Tiik ci yasna-yinooci fiisuusa ŋ pemeeni winoori ɗah, yasna-yinooci tas fiisu ŋ pemeeni tas ; ca ñaakɗoh findi kuɓuuci raakohu. ");
INSERT INTO sav_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Fu fiisohan ca findi ñaas na ñaasohse, fu ɓay fiil urus, fu teɗiɗ ca ɗisik ci ca ɓeksan. ");
INSERT INTO sav_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Atoh ci kanak ci tumsan ŋ ngallaaciŋ efoodi ne ca naandsohee cuuɓ ciŋ Israayel ; Aaruna hayya nga so ɗah, tiik ci hey nike ŋ fikiiso mi yi Nikiɗi, te ŋ alkohanɗi ɗu. ");
INSERT INTO sav_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Fu hey teɗe ɓekohaaca na fiil urus. ");
INSERT INTO sav_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Fu nam haɓiɗ ceen kanak ; ceen ci mondohsan fiil urus koceet findi niy, ca ambɗu ŋ ɓekohaaciŋ pemeeci. ");
INSERT INTO sav_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Fu hey haɓɗe nafa tumoha markiskohaaci, wa nikan panguk feroh keeh-keeh. Fu haɓɗohana leeŋ eɗfiɗ ndengiɗ, na fiil urus na ooy bulo na ruumind eɗfiɗ na ruumind coy, findi efoodi. ");
INSERT INTO sav_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Wa nikan kaare ne wa lemu kanak ɗah, ɓak nu nga nik santimeetar ndaŋkiyaah-kanak na yatuus (25). ");
INSERT INTO sav_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Fu hey wa moɗsine na raŋalɗoh atoh peme nikiis : raŋalɗohi koc raakan atoh ci moɗohngaan ci na woyse : odem na pitdaah na baareket. ");
INSERT INTO sav_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Wi kanakɗoh raak nopek na safiir na yaahalom. ");
INSERT INTO sav_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Wi kaahayɗoh raak lesem na saboo na ahlamaa. ");
INSERT INTO sav_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Wi nikiisɗoh raak tarsiis na sooham na yaspeeh. Peme nu nga ɗah teɗɗu ɗiski wa ɓeksan na fiil urus, wa ɓeku nga. ");
INSERT INTO sav_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tiik ciŋ kuɓuuci ƴaar ciŋ caac ɗu Israayel fiissan ŋ atoh ci ndaŋkiyaah ci na kanak ceem (12), ca fiisohsan findi ñaas na ñaasohse. Peme nu nga ɗah nikiɗ tiik cuuɓ yino. ");
INSERT INTO sav_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","25","Fu hey ɓaye ceen ci urus koceet ci teɗuuɗ ci ambɗu ŋ ɓekohaaciŋ pemeeci kanak ci nik ŋ efoodi. Fu haɓɗiɗ ca koroha urus kanak haa kiñi ŋ koñ ciŋ nafaani ŋ ɗafki. Fu kor ceen ci ŋ kiñiiceem po nafaani min nik ŋ fikiiri. ");
INSERT INTO sav_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","27","Fu haɓɗis koroha urus nikiis haa kiñi. Kanak ci, ɓeksan ŋ koñ ciŋ nafaani ŋ kehƴi, ŋ ɓakiŋ ɗooƴi, ca laalee efoodi ; kanak ci tas ɓeku ŋ ngallaaciŋ efoodi ŋ kehƴi, ngaŋ fikiiri, ŋ sero ɗiski ca suptu, ŋ ɗafkiŋ tokɗukohaaniŋ kinoh ki. ");
INSERT INTO sav_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kiñiiciŋ nafaani na ciŋ efoodi hey tokɗohse na niy bulo, ne nafaani amb ŋ tokɗukohaaniŋ kinoh ki, wa sang yoond, wa ris ŋ ɗafuk efoodi. ");
INSERT INTO sav_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ŋ ineem, Aaruna aassa ŋ Ɗiski Hooliɗi ɗah, nafaani tuman markiskohaaci hey nike ŋ fisaariŋ ɗe na tiik ciŋ kuɓuuci ƴaar ciŋ caac ɗu Israayel fiisu nga te mi yi Nikiɗi, ŋ alkohanɗi ɗu muk. ");
INSERT INTO sav_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Fu hey ɓeke Uriimi na Tumiimi na markisohse ŋ ɗooƴ nafaani, ca nik ŋ fisaariŋ Aaruna ne a aase ne a hay ŋ fikiiso ɗah, ca genan gen ŋ fisaariŋ ɗe ne Israayel ci meekissa so ini ɓa joy haɓiɗ ɗah, ɓa inah lofiŋ ngo mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Fu hey name haɓɗiɗ Aaruna kulɓa hutiɗ yakiɗ, wi hunan na efoodi ; haɓɗohaata jen leeŋ bulo. ");
INSERT INTO sav_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Mbooh kiŋ wa nikan ŋ leerni daamina'u po wa ndeng, ne wa faarkuu. ");
INSERT INTO sav_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Fu moɗsin kehƴiŋ kulɓaaki hutiɗi yakki na rim garnaat, fu haɓɗohan ca ooy bulo, na ruumind eɗfiɗ na ruumind coy po wa wil. Fu hey ɗooke ŋ harmban ca ɓi joolooli urus ; ");
INSERT INTO sav_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","fu haɓiɗta rim garnaat yino ɗah, fu ɗook joolooli urus yino po sereendiŋ kulɓaaki jen wil. ");
INSERT INTO sav_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaruna ɓekkan kulɓaakeem ne a pangkee findi seeƴkiɗoh ɗah. Joolooliici hey kerhasse ne a aasee ŋ Ɗiski Hooliɗi ŋ fikiiso mi yi Nikiɗi ɗah, wala a pulee ɗah, a lafkuu kaan. ");
INSERT INTO sav_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Fu hey haɓɗe na urus koceet tokkaah ŋ puk, wa mandan na pos kidig, fu fiis woo kii nga : \"Wuu Nikiɗi\". Fu fiisohana findi ñaas na ñaasohse. ");
INSERT INTO sav_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Fu toka na tokɗoha bulo ŋ fiki mbahneeri. ");
INSERT INTO sav_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Tokkaaheem genan pukiŋ ɗe ne a hayee ŋ fikiiso mi yi Nikiɗi ɗah, ŋ min teyɗuk onoh ci Israayel ci eɗohan wuu so jen ; ali ɓa ɗal ŋ eɗohiŋ ca sah, Aaruna heya mine gaduk. ");
INSERT INTO sav_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Fu hey teɗɗe Aaruna kulɓa mbaseñ adginkoha ; wa teɗohsan leeŋ. Fu haɓɗiɗ ɗe mbahne na leeŋ, fu nam ɗe haɓɗiɗ seentur, wa borode'u. ");
INSERT INTO sav_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Fu hey name teɗiɗ kuɓuuciŋ ɗe kulɓa moɗiɗ, ca hun na seentur ciŋ ca, na mbahne, ca teeɓoh yaki ɓa yak. ");
INSERT INTO sav_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Fu Musaa, fu hey ɓekɗe yakak fu Aaruna na kuɓuuciŋ ɗe kulɓaaceem, fu yiif haf ciŋ ɓa diwi na hoolɗohse, fu dengkoh ɓa pangki, fu tum ɓa ɓo' hooliɗ, ɓa pangkiɗee so findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Fu hey ɓa haɓɗiɗe jata, ca nikan leeŋ, ca ambohan kinoh ki po ŋ ramb ci, ɓa nikuu tas-ɓarang. ");
INSERT INTO sav_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaruna na kuɓuuciŋ ɗe ɓekuk ca ne ɓa aasee Ɗiipi-na-Cohohse wala ɓa reɓee ŋ seeƴkohaani ne ɓa pangkiɗ to ŋ Ɗiski Hooliɗi ɗah. Ŋ ineem, ɓa teeɓkanɗi so tas ɓarang te ɓa lafkanɗi kaan sagu ineem. Wa nakohi Aaruna na kuɓuuciŋ ɗe na set ciŋ ɗe taambɗan po faw. » ");
INSERT INTO sav_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Nikiɗi woyissa Musaa ne : « Fu hoolɗee Aaruna na kuɓuuciŋ ɗe wuu so ne ɓa nik ŋ pangkiŋ ngo findi seeƴkiɗoh ɗah, fu na hee tumohe an : Fu ɓayan naar ƴin yino raakaaɗi sikka na kuy mbaal kanak raakaaɗi sikka, ");
INSERT INTO sav_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","fu nam ɓay mun bele baahiɗ, fu haɓiɗ mbuuru raakaaɗi lawiir na ɗang raakaaɗi lawiir hiiñohuuɗ diwliin, fu nam haɓiɗ ɗambaañ raakaaɗi lawiir laalɗuuɗ diwliin. ");
INSERT INTO sav_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Fu tum ca ŋ pañe yino, fu eɗoh ca wuu so ŋ ɗiska hooliɗa, ceɗ, na naari, na kuy ci kanak ci. ");
INSERT INTO sav_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Fu ɓay Aaruna na kuɓuuciŋ ɗe po ŋ aasohaaniŋ Ɗiipi-na-Cohohse, fu ɓook ɓa na masuɓ. ");
INSERT INTO sav_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Fu ɓekiɗ Aaruna kulɓaakiŋ ɗe : kulɓaaki adginkohaani na wi hutiɗi yakki, na efoodi, na nafaani ŋ fikiiri. Fu tokiɗ ɗe efoodi na tokɗukohaaniŋ wa nik ŋ kinoh ki. ");
INSERT INTO sav_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Fu ɓekiɗ ɗe mbahne, fu pengu ŋ ɗafuk mbahneeri tokkaahiŋ puki na teeɓohe ne a wuu so. ");
INSERT INTO sav_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Fu ɓay diwi na hoolɗohse, fu yiifa ŋ hafiŋ ɗe, fu tufkiɗ ɗe, a nik seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Fu nam woo kuɓuuciŋ ɗe ɓa reɓ, fu ɓekiɗ ɓa kulɓa. ");
INSERT INTO sav_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Fu tokiɗ Aaruna na kuɓuuciŋ ɗe seentur ŋ kinoh ciŋ ɓa, fu waakiɗ ɓa mbahne, jaar fu tufkiɗ ɓa, ɓa nik seeƴkiɗoh ci, wa nik nakohi genan gen. ");
INSERT INTO sav_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Fu ɓay naari ŋ nguɓu Ɗiipi-na-Cohohse, Aaruna na kuɓuuciŋ ɗe deg yaah ciŋ ɓa ŋ hafiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Fu hoos ɗe nga ŋ fikiiso mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Fu ɓay ŋ ñif miŋ ɗe, fu reef na ndukniŋ ɗa ŋ wiic ciŋ keesi seeƴkohaani, fu yiif wi tas ŋ kehƴiŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Fu nam ɓay faymi ŋ soohi jen na yoorɗiŋ keeñi na iraak ci kanak ci na faymiŋ ca, fu doh ca ŋ ɗafuk seeƴkohaani. ");
INSERT INTO sav_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Waaye ini tas ŋ faani na undi na haɓit ci, fu na hee ca dohe ŋ bilaf fa. Seeƴkeem, weɗ seeƴki wuu bakaaɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Fu ɓay kuyiŋ mbaali yinoori, Aaruna na kuɓuuciŋ ɗe deg yaah ciŋ ɓa ŋ hafiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Fu hoos ɗe, fu ɓay ñif miŋ ɗe, fu lisa ŋ ɓak ciŋ seeƴkohaani jen. ");
INSERT INTO sav_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Fu nguɗsoh ɗe, fu ɓook soohi na soongal ci, fu deg ca ŋ nguɗ ciŋ sepet ci na hafi. ");
INSERT INTO sav_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Fu doh ca jen ŋ ɗafuk seeƴkohaani. Seeƴkeem, weɗ seeƴki na hoomɗasse wuu so mi yi Nikiɗi, wa na hee hey dohse po wa eeñee so. ");
INSERT INTO sav_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Fu hay na kuyi tas, Aaruna na kuɓuuciŋ ɗe deg yaah ciŋ ɓa ŋ hafiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ƴut ɗah, fu hoos ɗe, fu ɓay ŋ ñif mi, fu reef ŋ yoorɗiŋ nofiŋ Aaruna ñaahmi na ciŋ kuɓuuciŋ ɗe. Fu nam reef ndukun ci yakak ci ŋ yaah ciŋ ɓa ñaahum ci na tukun ci yakak ci ŋ kot ciŋ ɓa ñaahum ci, fu lis ñif mi tas ŋ ɓak ciŋ seeƴkohaani jen. ");
INSERT INTO sav_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Fu ɓay ŋ ñif mi nik ŋ ɗafuk seeƴkohaani, fu ambsoha na diwi na hoolɗohse, fu lisa ŋ ɗafuk Aaruna na kulɓaaciŋ ɗe na ŋ ɗafuk kuɓuuciŋ ɗe na kulɓaaciŋ ɓa. Ŋ ineem, fu hooliɗ Aaruna na kulɓaaciŋ ɗe, na kuɓuuciŋ ɗe na kulɓaaciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Fu ɓay faymiŋ kuyi, na koseekiŋ ɗe na faymiŋ wa, na faymiŋ soohi, na yoorɗiŋ keeñi, na iraak ci kanak ci na faymiŋ ca, fu ɓekndoh rambiŋ ɗe ñaahmi nga, laam a mbaali na tufkiɗohse. ");
INSERT INTO sav_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Fu nam ɓay in ci raakaaɗi lawiir cii : mbuuru ɗapas yino, na ɗang haɓɗohuuɗ diwliin, na ɗambaañ yino, ŋ pañeeni nik ŋ fikiiso. ");
INSERT INTO sav_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","In ci fu ɓay ceem jen, fu deg ca ŋ yaah ciŋ Aaruna na kuɓuuciŋ ɗe, fu woo ɓa, ɓa raɗis so ca mi yi Nikiɗi. Eɗoheem weɗ eɗohi na raɗsasse. ");
INSERT INTO sav_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ƴut ɗah, fu tey ca nga ɓa, fu doh ca ŋ ɗafuk seeƴkohaani po ca hoom ; wa nikan seeƴki dohsan ŋ fikiiso po wa eeñee so mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Fu Musaa, fu ɓay daɗiŋ kuyi kanakɗoh, yi Aaruna tufkiɗohse, fu raɗis so wa mi yi Nikiɗi findi eɗohi na raɗsasse, ƴut ɗah, wa nik wuu fu. ");
INSERT INTO sav_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Findi ɗu raɗsoh ho daɗiŋ kuyi na tufkiɗohse, ɗu eɗta so rambiŋ ɗe ñaahmi, wa nikohaat ɗaa ŋ seeƴuk ci na haye. Ɓak ci kanak ceem, fu hey ca hoolɗe wuu so mi yi Nikiɗi, te ca nikan waɗiŋ Aaruna na ɓi na hee rimkohe nga ɗe. ");
INSERT INTO sav_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","E Israayel ci eɗan ɓa ca ; wa nakohi genan gen, ca nikan in ci Israayel ci waɗan ndo ne ɓa seeƴkee seeƴuk wuu jam ɗah. ");
INSERT INTO sav_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaruna kaan ɗah, kulɓaaci a meeɗ to nikiɗoh, e ɓi rimkoh nga ɗe eɗsan ca ne ɓa yiifsee diwi na hoolɗohse ɗah ŋ mbeha ɓa camban pangki. ");
INSERT INTO sav_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Kuɓkiŋ ɗe yi laman ɗe ŋ seeƴki, hey ca ɓekke neeh yasna-kanak, ne a aasee ŋ Ɗiipi-na-Cohohse ne a panguk ŋ Ɗiski Hooliɗi ɗah. ");
INSERT INTO sav_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Fu ƴut tufkiɗ Aaruna ɗah, fu ɓay sepet ciŋ kuyi tufkiɗohse, ca tiku ŋ ɗisik hooliɗ wuu so. ");
INSERT INTO sav_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaruna na kuɓuuciŋ ɗe hey ñame sepet ci ŋ nguɓu Ɗiipi-na-Cohohse na mbuuruuci nik ŋ pañeeni. ");
INSERT INTO sav_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","E ɓeɗ dong ñaman nga ca, ca seeƴuk ci ɓa toskoh wi ɓa tufkiɗasse, ɓa nikka ɓo' hooliɗ. Ca in hoolɗuuɗ weɗ tah ali ɓo' wiiriis ñamanɗi nga ca. ");
INSERT INTO sav_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Te in tas ŋ sepet ci wala mbuuruuci po na ɓaaɓa ɗah, ca heyɗi ñamse ; dohaa ca doh, ca in hoolɗuuɗ. ");
INSERT INTO sav_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Findi ŋ nakoh ɗa wa jok, fu tumohan na Aaruna na kuɓuuciŋ ɗe ɗaa ; tufkiɗiŋ ɗa na ɓa raakan neeh yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kooh-nu-wiis, fu hey seeƴkohe naar ƴin, wa nik seeƴki wuu bakaaɗ ci, waɗ fu tosohan seeƴkohaani, fu ɓokita ŋ bakaaɗ ; fu yiifa diwi na hoolɗohse ne fu hooliɗa wuu so. ");
INSERT INTO sav_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ini ree neeh yasna-kanak, fu tosan seeƴkohaani, fu hooliɗa wuu so, wa nik in ye hoolan te in nu laala ɗah, wa jaaran nik wuu so. » ");
INSERT INTO sav_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Nikiɗi woyissa Musaa ne : « In cii ceɗ fu na hee seeƴkohe ŋ ɗafuk seeƴkohaani : fu seeƴkan Kooh-nu-wiis na kuy kanak ci raak kiis yino, te wa genan gen. ");
INSERT INTO sav_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Fu seeƴkoh yii na ɓaaɓ ɗah, fu seeƴkoh yi tas na niin. ");
INSERT INTO sav_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kuyi koc hunan na andaar mun kaahay hiiñuuɗ na liitar diwliin koceet na camban, a nam hun na liitar biiñ na camban. Biiñi nikan seeƴuk aamaah ŋ ɗisik wuu so. ");
INSERT INTO sav_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kuyi kanakɗoh, fu na hee ɗe seeƴkohe na niina, a hunan na in ci fu hunɗee na ya na ɓaaɓa, wa nikan seeƴki dohsan ŋ fikiiso po wa eeñee so mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Wa na hee nike seeƴuk hoomɗaah, wa genan gen, gomal nu gomal. Ɗu na hee wa seeƴke ŋ aasohaaniŋ Ɗiipi-na-Cohohse, ŋ fikiiso mi yi Nikiɗi, ŋ cohan na ɗu ŋ ndeem ne ŋ woo na ɗa. ");
INSERT INTO sav_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Te ŋ naman coh na Israayel ci ndeem, ɗiski hey hoole sagu yaki ŋ yak. ");
INSERT INTO sav_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ŋ hey hoolɗe Ɗiipi-na-Cohohse, ŋ hooliɗ seeƴkohaani, ca min nik wuu so. Ŋ hey tume Aaruna na kuɓuuciŋ ɗe ɓo' hooliɗ, ɓa pangkiɗee so findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ŋ genan na Israayel ci, ŋ nikan Koohiŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ɓa hey inhe ne ñam Nikiɗi, Koohiŋ ɓa yi pulɗoh ɓa Misra ne ŋ gen ŋ ɗooƴ ɓa. Ñam Nikiɗi Koohiŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Nikiɗi woyissa Musaa ne : « Fu hey haɓɗe seeƴkoha suusoha cuuraay, fu haɓɗohana hang kassiya. ");
INSERT INTO sav_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Wa nikan kaare, ɓak nu nga nik suung yino te njooliini nik suung kanak. Fu hey pulɗe wiic ciŋ wa ŋ koñ ci wa ŋ ɗafki, fu puliɗndohan ca ŋ hangi wa haɓɗohsan. ");
INSERT INTO sav_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Fu heya ule na urus koceet, ɗafki na ɓak ciŋ wa jen na wiic ci, fu haɓɗiɗa banda urus po wa wil. ");
INSERT INTO sav_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Fu hey wa haɓɗiɗe inaa haa kiñi kanak ŋ ooɓ bandaani, ŋ ɓak ci kanak ci, ɓak nu nga raak yino ; in ceem nikan urus, ndooɗ ci na hee wa ɓayohse taamban nga ca. ");
INSERT INTO sav_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Haɓɗoha ndooɗ ceem ndooɗ kassiya, fu ul ca na urus. ");
INSERT INTO sav_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Fu hey dege seeƴkohaaneem ndo fu reyan ridooni ɗasiɗ Wahndeeni na teeɓohe Ambtiɗohi ɗah, wa yurhiɗkoh na kunohaani, ɗiski na romkohse, wi nik ŋ ɗafuk Wahndeeni, ŋ ɗiski ŋ cohan na ɗa. ");
INSERT INTO sav_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaruna hey suuse cuuraay eeñiɗ nga ɓaaɓ nu ree ne a kee taambkoha laampaaci ɗah. ");
INSERT INTO sav_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Niin nu ree, a kee dega laampaaci ɗah, a nam suusis. Wa nikan cuuraayi genan kaɓ ŋ fikiiso mi yi Nikiɗi, ŋ gomal nu gomal. ");
INSERT INTO sav_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ɗu heyɗi suuse cuuraay wiiriis nga, ɗu seeƴkanɗi seeƴuk hoomɗaah nga, ɗu seeƴkanɗi na in ci na pulohe ŋ yohon ca nga ; te ɗu seeƴkanɗi seeƴuk aamaah nga. ");
INSERT INTO sav_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kiis nu ree ɗah, Aaruna heya seeƴkiɗe waas yino ne wa tosu. A tuman ñif miŋ ɗooptiŋ seeƴki wuu bakaaɗ ci, ŋ wiic ciŋ seeƴkohaani. Wa hey seeƴkiɗasse ne wa tosu, wa nikan waas yino kiis nu ree ɗah, ŋ gomal nu gomal ; wa in ye hoolan wuu so mi yi Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nikiɗi woyissa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","« Fu kindee Israayel ci ne findi ɓa hend inhu ɗah, yaa nu nga ɗah hey yo eɗe mi yi Nikiɗi, lempooni a tosohan kipes kiŋ ɗe, po naamo raakuu ŋ harmban ɓa ŋ mbehi ɓa fiiskohan. ");
INSERT INTO sav_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Inii weɗ yaa nu nga eɗohan ne a fiiskee ɗah : garam yatuus ŋ haalis, wa nikan cambaniŋ ɓeesohaani nik ŋ Ɗiski Hooliɗi. Haalseem nikan wuu so mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Yaa nu raak kiis ndaŋkiyaah-kanak (20) kaɗ ɗafka ɗah, a hey fiiske te a eɗ to wa. ");
INSERT INTO sav_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Heɗ raak-raak eɗohanɗi ini uupa te ñakiɗ eɗohanɗi ini mitɗi garam ci yasna-yinooceem, yaa nu nga hey yo ca eɗe, ca nik ini ɓa tosohan kipes ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Fu hey rahse haalseem jen ŋ Israayel ci, fu tuma ŋ haɓɗuuki na taambkohuukiŋ Ɗiipi-na-Cohohse ; wa nik ini naandsohan ŋ fikiiso mi yi Nikiɗi ne ɓa tosuuɗ. » ");
INSERT INTO sav_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nikiɗi woyissa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","« Fu hey haɓɗe beñwaar ɓoktukoha na degohaaniŋ wa, fu haɓɗohan ca moos ruumind. Ƴut ɗah, fu dega ŋ harmban Ɗiipi-na-Cohohse na seeƴkohaani, fu neya. ");
INSERT INTO sav_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Masmeem weɗ Aaruna na kuɓuuciŋ ɗe ɓookohan yaah ciŋ ɓa na kot ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ɓa aasee ŋ Ɗiipi-na-Cohohse wala ɓa reɓee seeƴkohaani ne ɓa seeƴkee seeƴki dohsan po wa sut wuu so mi yi Nikiɗi ɗah, ɓa hey ɓookke ŋ masmeem ne ɓa kaanuu. ");
INSERT INTO sav_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ɓa ɓookan yaah ciŋ ɓa na kot ciŋ ɓa ne ɓa kaanuu. Wa nakohi genan gen, wi Aaruna na ɓi rimkoh nga ɗe taambɗan ŋ gomal nu gomal. » ");
INSERT INTO sav_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nikiɗi woyissa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","« Fu Musaa, ɓaya ŋ eeñɗohaaci uup neɓ : Fu ɓayan kilo miir ñifsootiɗ yatuus, na kilo kanak na camban ŋ eeñɗohaani na woyse sinaamom, na kilo kanak na camban ŋ wi na woyse kanel, ");
INSERT INTO sav_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kilo yatuus ŋ wi na woyse kas, ca ɓeesohsan ɓeesohaaca nik ŋ Ɗiski Hooliɗi. Fu nam ɓay liitar diwliin oliiw yasna-yino. ");
INSERT INTO sav_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Fu hey ca ambsohe findi haɓɗoh eeñɗoha keeh-keeh na tumohe, wa nik diw hoolɗoha, e hoolɗuuɗ ci wuu so yiifsana. ");
INSERT INTO sav_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Diweem weɗ fu na hee yiife ŋ Ɗiipi-na-Cohohse na Wahndeeni na teeɓohe Ambtiɗohi, ");
INSERT INTO sav_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na taaɓli na tumohaaciŋ wa jen, na degohaaniŋ laampaaci na tumohaaciŋ wa, na seeƴkohaaniŋ cuuraay ci, ");
INSERT INTO sav_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na seeƴkohaani na dohohse hoosuuɗ ci na tumohaaciŋ wa jen, na beñwaari na degohaaniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Fu hey hoolɗe in ceem jen wuu so, ca nikan hooloh na hooloh ; in nu laal ca ɗah jaaran nik wuu so. ");
INSERT INTO sav_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Fu hey name yiif Aaruna na kuɓuuciŋ ɗe diwi, fu hooliɗ ɓa wuu so ne ɓa pangkiɗee so findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Fu hey woye Israayel ci ne ñam woo ne : “ Diwii wa nikan diw hoolɗoha hoolɗuuɗ ci wuu so, ŋ gomal nu gomal. ");
INSERT INTO sav_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Wa heyɗi yiifse ŋ faan ɓo', te ɗu heyɗi haɓɗe wi mand naa jok. Wa hoolɗuuɗ wuu so te ambaata findi in hooliɗ. ");
INSERT INTO sav_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ɓo' nu haɓiɗ mand naa, a diwa ŋ faaniŋ ɓoyi nikɗi seeƴkiɗoh ɗah, a hey pulɗasse ŋ cuuɓiŋ ɗe. ” » ");
INSERT INTO sav_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nikiɗi woyissa Musaa ne : « Waaka makind ci eeñɗohaacii : Naataap na saheelet na helbenaah, na cuuraay koceet, waa nu nga ɗah ini fu ɓayan nga hendan hend na morom wa. ");
INSERT INTO sav_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Fu hey ca ambsohe findi haɓɗoh eeñɗoha na tumohe, wa nikan cuuraay jemiɗ, koceet, hooliɗ wuu so. ");
INSERT INTO sav_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Fu kooɗ in nga, fu oɗa po wa nik puɗ, fu tuma ŋ fiki Wahndeeni na teeɓohe Ambtiɗohi, ŋ ɗooƴ Ɗiipi-na-Cohohse, ɗiski ŋ cohan na ɗa. Cuuraayeem nikan in ye hoolan nga ɗu. ");
INSERT INTO sav_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ɗu heyɗi haɓɗe wi mand naa jok, ɗu njirñiɗkohee wa ; ɗu na hee wa ambe findi in hoolɗuuɗ wuu so mi yi Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Yaa nu haɓiɗ mand naa ne a eeñɗuka ɗah, a hey pulɗasse ŋ cuuɓiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nikiɗi woyissa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","« Marka, ŋ taniɗ Betsalel, kuɓu Uri, a setiŋ Hur, a ɓaah ŋ cuuɓiŋ Yudaa. ");
INSERT INTO sav_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ŋ ɓekiɗ Fuuɗsiŋ ngo nga ɗe po a raakiɗ min-min, a ñaañiɗ, a raakiɗ inah-inah ŋ panguk nu nik ; ");
INSERT INTO sav_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","a miniɗ marak po a inah findi a joy haɓɗoh in moɗiɗ ngaŋ urus, haalis wala moos. ");
INSERT INTO sav_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","A miniɗ pes atoh peme, a namiɗ min ɓek peme ŋ ɓekoha, a miniɗ pes kidig, a miniɗ haɓiɗ panguk nu nik. ");
INSERT INTO sav_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ɓaat nga, ŋ eɗiɗ ɗe Oholiyaab kuɓu Ahisamaak yi ɓaah ŋ cuuɓiŋ Daan, ne a ɓaatɗoh ɗe, te ɓooɓi herñiɗ ci jen, ŋ namiɗ ɓa on min-min ne ɓa min haɓiɗ in ci ŋ nak ɗa cii jen : ");
INSERT INTO sav_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ɓeɗ haɓɗan Ɗiipi-na-Cohohse, na Wahndeeni ɗaak in ci na teeɓohe Ambtiɗohi na kunohaaniŋ wa na tosohse, na tumohaaci nik ŋ ɗiipi jen. ");
INSERT INTO sav_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Ɓa haɓiɗ taaɓli na tumohaaci hunan naa, na degohaaniŋ laampaaci haɓɗohsan urus koceet na in ci hunan naa jen, na seeƴkohaani suusohsan cuuraay ci. ");
INSERT INTO sav_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ɓa haɓiɗ seeƴkohaani na hee dohohse hoosuuɗ ci na tumohaaci hunan naa jen, na beñwaari na degohaaniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ɓa haɓiɗ kulɓaaci ɓekkassan ŋ hew, ca nikka kulɓaaci hooliɗ ciŋ Aaruna seeƴkiɗohi, na kulɓaaciŋ kuɓuuciŋ ɗe ƴaar ci, ne ɓa pangkiɗee so findi seeƴkiɗoh ɗah. ");
INSERT INTO sav_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ɓa haɓiɗ diwi hoolɗohsan hoolɗuuɗ ci wuu so, na cuuraayi eeñiɗi tumsan ŋ Ɗiski Hooliɗi. Pangkoh ci hey ca haɓɗe findi ŋ nakoh ɗa ca jok. » ");
INSERT INTO sav_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Nikiɗi woyissa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","« Woytoha Israayel ci, woyaa ɓa ne : “ Nikiɗi woo ne : ‘Ŋ pangkeem jen, ɗu hey eɗe mbeh ciŋ ngo na iɗsiɗkohse cir, laam, ca na hee nike ini na hee teeɓohe ŋ harmban ndo na ɗu na ɓi na hee rimkohe nga ɗu ne ñam Nikiɗi, yi hooliɗ ɗu wuu so. ");
INSERT INTO sav_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ɗu hey iɗsiɗke ŋ mbehi na iɗsiɗkohse, wa na hee nike nga ɗu in hooliɗ wuu so. Ɓo' nu tumɗaa mbeh hooliɗ ɗah, a hey apse, te ɓo' nu panguk nga ɗah, a hey pulɗasse ŋ cuuɓi a ɓaahoh. ");
INSERT INTO sav_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mbeh yasna-yino ceɗ na hee pangkohse, mbehi yasna-kanakɗoh weɗ wi na iɗsiɗkohse, wi hoolɗu wuu so mi yi Nikiɗi. Ɓo' nu panguk ŋ mbehi na iɗsiɗkohse ɗah, a hey apse. ");
INSERT INTO sav_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israayel ci hey eɗe mbehi na iɗsiɗkohse cir, ɓa yakɗee wa, ɓeɗ na ɓi na hee rimkohe nga ɓa, wa nikan ambtiɗoh ŋ harmban ɓoo te wa genan gen. ");
INSERT INTO sav_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Wa na hee nike mandarga, wi genan gen ŋ harmban ndo na Israayel ci, laam ŋ neeh yasna-yino, ŋ feriɗ eel ci na kehƴi, mi yi Nikiɗi, ŋ faɗta neeha yasna-kanakɗoh, ŋ iɗsiɗukka.’ ” » ");
INSERT INTO sav_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Wa Nikiɗi ƴut woo na Musaa ŋ ɗafuk tangooraŋ Sinaay, a eɗta ɗe atoh ca kanak ca ɗapas ca woo ciŋ Ambtiɗohi fiisohse, atoh ca fu inah ne a Kooh fiisootee ca. ");
INSERT INTO sav_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ini kaɗ ŋ Israayel ci, ɓa hoteen ne Musaa maañiɗ ŋ tangoora a hayɗi paaɗ, ɓa cohha ŋ ɗiskaŋ Aaruna, ɓa woosa ɗe ne : « Musaa ƴaari pulɗoh ɓoo Misra yii, ɓo' inhisɗi in nga ɗe. Mbaa, haɓɗiɗa ɓoo kooh ci adgan ŋ fiki ɓoo. » ");
INSERT INTO sav_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaruna loffa ɓa ne : « Saɓsukohaat na long-long ci urus ci nik ŋ nof ciŋ ɓitiɓ ciŋ ɗu, na ciŋ kuɓuuciŋ ɗu ƴaar ci na ɓi ɓitiɓ ci, ɗu kom mbo ca. » ");
INSERT INTO sav_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ɓa jen, ɓa saɓsukohha na long-long ca urus ca nikee ŋ nof ciŋ ɓa, ɓa kommba ɗe ca. ");
INSERT INTO sav_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A ɓayya ca, a naayiɗta ca, a haɓiɗta na urseem nataal ɗoon naar. Ƴutta, ɓa woosa ne : « Israayel ! Koohiŋ ɓoo pulɗoh ɓoo Misra a Yii ! » ");
INSERT INTO sav_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Wa Aaruna hot ŋ ineem, a haɓiɗta seeƴkoha ŋ fiki nataala, a woosa ŋ ɗafka ne : « Kim, feet hey raake yakɗoha Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wa Kooh wiis na ɓaaɓa teel, ɓa seeƴkohha ɓi ɗoopaat seeƴuk hoomɗaah, na seeƴuk wuu jam. Ɓa ɓooffa, ɓa ñameeɗa, ɓa aneeɗa ; ƴutta ɓa kurukka, ɓa mbuumbaayeeɗa. ");
INSERT INTO sav_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Wa Nikiɗi hot in ceem, a woosa Musaa ne : « Ruhsa fu kaɗ, cuuɓiŋ ɗa fu pulɗoh Misra yahrukohiɗ. ");
INSERT INTO sav_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ɓa ariɗ faɗ waasi ŋ teeɓee ɓa. Ɓa haɓɗiɗiɗ haf ɓa ɗoon na urus naayɗuuɗ, ɓa ƴekiɗ ŋ fikiice, ɓa seeƴkiɗta ɗe te ɓa woosa ne : “ Israayel ! Koohiŋ ɓoo pulɗoh ɓoo Misra a Yii ! ” » ");
INSERT INTO sav_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nikiɗi taalndiɗta woo Musaa ne : « Ŋ hotiɗ ne cuuɓii, wa cuuɓ ndengiɗ haf. ");
INSERT INTO sav_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ɗiski wa nik, faɗ to dohɗiŋ ayrukiŋ ngo dal nga ɓa, ŋ ɗumbiɗ ɓa ; waaye fu, ŋ hey tume po cuuɓ angiɗ rimkoh nga ɗa. » ");
INSERT INTO sav_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ŋ ineem, Musaa kiimmba Nikiɗi Koohiŋ ɗe, a kiimmba ɗe kiim keeh-keeh, an : « Nikiɗi, wa ye tah fu ruhsiɗee dohɗiŋ ayrukiŋ ɗa ŋ cuuɓiŋ ɗa fu pulɗoh Misra, na hatil keeh-keeh na yaah ɓitiɗ ? ");
INSERT INTO sav_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Fu tumoh ɗaa ɗah, ɓi Misra hey woye ne añaand weɗ tah fu pulɗohha Israayel ci nga ne fu ɗumbiɗ ɓa ŋ tangooci, ɓa reeh ŋ kehƴi. Giifɗa ayrukiŋ ɗa te fu faɗ miskiɗi fu waaɗee deg cuuɓiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Naandsuka ñaam ciŋ ɗa Ibrahiima na Isaahha, na Israayel, yi Yaŋhooɓa, ɓi fu giñɗe ŋ haf fu an : “ Ŋ hey ɓaate ɓi rimkohan nga ɗu po ɓa hend na hor ci. Ŋ hey ɓa eɗe kur ki ŋ gapee ɓa wii jen, wa nik wuu ɓa po faw. ” » ");
INSERT INTO sav_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ŋ ineem, Nikiɗi giiffa, a faɗta miskiɗa a waaɗee deg ngaŋ cuuɓiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musaa ruhussa tangoora, a wiirukka, a yurahha ŋ mboolnda ; a ammba atoh ca kanak ca na teeɓohe Ambtiɗohi ŋ yaah, atoh nu nga ɗah fiisuusa ŋ ɓak ciŋ wa kanak ci. ");
INSERT INTO sav_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Atoh ceem, a Kooh haɓiɗ ca, a yi fiisoot ca findi ñaas. ");
INSERT INTO sav_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Wa Yosuwe kerah leehuk caŋ ɓooɓa, a woosa Musaa ne : « Ca leehuk hiñoh ceɗ na kerhasse ŋ dala. » ");
INSERT INTO sav_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musaa loffa ɗe ne : « Ca leehuk saahiɗ haa te ca leehuk saahuuɗ haa ; ca ƴeek ceɗ maa kerhe. » ");
INSERT INTO sav_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musaa reɓee reɓ dala rek a hotta ɗoona na ɓooɓa mbece, a ayrukka ; a mbetta atoh ca a ambe, a pookka ca ŋ tasaŋ tangoora. ");
INSERT INTO sav_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","A ɓayya nataalaŋ ɗoona ɓa haɓɗe, a dohhaa, a oɗtaa po wa nikka mun, a wasarraa ŋ masma, a anɗukohha ɓa wa. ");
INSERT INTO sav_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musaa meekissa Aaruna ne : « Cuuɓii haɓiɗ ɗa ye po fu tahha ɓa bakaaɗee bakaaɗ hend an yak ? » ");
INSERT INTO sav_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaruna loffa ɗe ne : « Ŋ kiim ɗa wa kiim, kilifaaniŋ ngo, kina ayruk ! Fu inhiɗ ŋ haf fu ne cuuɓii tum moɗaaɗi yooɓiɗ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","E ɓeɗ woo so ne : “ Musaa ƴaari pulɗoh ɓoo Misra yii, ɓo' inhisɗi in nga ɗe. Mbaa, haɓɗiɗa ɓoo kooh ci adgan ŋ fiki ɓoo. ” ");
INSERT INTO sav_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ŋ woosa ɓa ne : “ Yaa nu raak urus ɗah, saɓsukoha naa. ” Ɓa eɗta so ca, ŋ njaffa ca ŋ yongkaahi, ɗoonii a yi pulla nga. » ");
INSERT INTO sav_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musaa hotta ne Aaruna faɗ faɗ ɓi cuuɓi ŋ ini neɓ ɓa po ɓa ƴissuutiɗ ŋ fiki ɓi sang ɓa. ");
INSERT INTO sav_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musaa tufukka ŋ aasohaanaŋ dala, a woosa ndengiɗ ne : « Yaa nu hun na Nikiɗi ɗah, a hayaat nga so ! » Ɓi rimkoh ŋ Lewi jen hayya nga ɗe. ");
INSERT INTO sav_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A woosa ɓa ne : « Nikiɗi, Koohiŋ Israayel woo inii : “ Yaa nu nga ɗu ɗah, ɓayaat ndangiŋ ɗe, ɗu aas ɓak nu nik ŋ dali, ɗu ap ɓaah ciŋ ɗu, nawleeciŋ ɗu wala ɓi reɓ ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ɓi rimkoh ŋ Lewi tumohhaa findi Musaa woyoha ; mbaɗi, ini uup ƴaar junni-kaahay (3000) kaannda ŋ Israayel ci. ");
INSERT INTO sav_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musaa woosa Lewiici ne : « Woti, ɗu tufkiɗuuɗ wuu Nikiɗi ŋ api ɗu ap kuɓuuciŋ ɗu na taambɗoh ciŋ ɗu te a barke'ɗiɗ ɗu woti. » ");
INSERT INTO sav_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wa Kooh wiis, Musaa woosa cuuɓa ne : « Ɗu bakaaɗiɗ bakaaɗ yakak. Mi yii rapisseeɗa tangoori ŋ ɗiskaŋ Nikiɗi, ŋ hey ɗu ɗaasnukɗe, wa miniɗ nik ne Kooh ɗaas ɗu bakaaɗiŋ ɗu. » ");
INSERT INTO sav_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musaa dokukka ŋ Nikiɗi, a woosa ɗe ne : « Cey Kooh ! Cuuɓii bakaaɗiɗ bakaaɗ yakak, ɓa ɓay urus, ɓa haɓɗiɗta haf ɓa kooh. ");
INSERT INTO sav_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ɗaasaa ɓa, ŋ kiim ɗa wa kiim ! Wala fu moos tiikiŋ ngo ŋ teerndi fu fiis. » ");
INSERT INTO sav_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nikiɗi loffa ɗe ne : « Ɓoyi haɓiɗ bakaaɗ nga so, a yi ŋ moosan tiikiŋ ɗe ŋ teerndiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kaɗa, fu adgiɗ cuuɓi, fu ɓaya ɗiska ŋ woo ɗa. Amba ne malaakaaniŋ ngo hey nike ŋ fikiifu waaye mbehi ŋ wirndohan ree ɗah, ŋ hey ɓa mbugale sagu bakaaɗiŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nikiɗi mbugaleen Israayel ci, sagu naka ɓa nakee Aaruna ne a haɓɗiɗ ɓa nataalaŋ ɗoona. ");
INSERT INTO sav_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nikiɗi woosa Musaa ne : « Kaɗa, fu na cuuɓi fu pulɗoh Misra, kurkaat ndii, ɗu kaɗ kur ka ŋ giñɗee Ibrahiima na Isaahha na Yaŋhooɓa ne ŋ hey wa eɗe ɓi rimkohan nga ɓa. ");
INSERT INTO sav_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ŋ hey woose malaaka, a nik ŋ fikiiɗu, ŋ hey aañe Kanaan ci na Amoor ci na Hit ci na Peris ci na Hiw ci na Yebuus ci. ");
INSERT INTO sav_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Wa kur riifɗiɗ na miis na kuum. Kaɗaat, waaye ŋ hunanɗi na ɗu, ŋ nikanɗi ŋ ɗiski ɗu nikan. Ɗu cuuɓ ndengiɗ haf, ŋ sang ɗu ɗumb ŋ waas. » ");
INSERT INTO sav_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Wa woo ki ndengɗi Kooh woo weem ree ŋ cuuɓa, ɓa nikka ŋ neɓaaɗi po ali ɓo' ɓekukɗi in moɗiɗ nga ɓa. ");
INSERT INTO sav_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Laam, Nikiɗi nameen woo Musaa ne : « Woya Israayel ci ne : “ Ɗu cuuɓ ndengiɗ haf ! Ŋ nik ŋ harmban ɗu ƴissuut ɗah, ŋ hey ɗu ɗumbe. Saɓsukohaat na ɓekkaah ciŋ ɗu moɗiɗ ci, ƴut ɗah, ŋ hey inhe ini ŋ tuman ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ɓa saɓsukohha na ca ndaam, ɓa ɓekisɗi ca ina amboh ŋ tangooraŋ Horeb. ");
INSERT INTO sav_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musaa meeɗ ɓay ɗiip, a yipa usohiɗ na dala, a teekee wa \"Ɗiipi-na-Cohohse\". Ɓo' nu waaɗta woo na Nikiɗi ɗah, a pul dala, a kaɗ ŋ Ɗiipa-na-Cohohse. ");
INSERT INTO sav_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musaa kaɗeesa nga ɗah, ɓi cuuɓi jen kuruk, yaa nu nga tufuk ŋ nguɓu ɗiipiŋ ɗe, ɓa markee ɗe po a aas. ");
INSERT INTO sav_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musaa aassa ɗah, eela yipee findi kumbin hay po ŋ nguɓu ɗiipa, wa tufuk nga, jaar Nikiɗi woyee na ɗe. ");
INSERT INTO sav_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Israayel ca hottaa rek ɗah, yaa nu nga ɗa ƴek ŋ nguɓu ɗiipiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Nikiɗi woyee na Musaa jahran findi ɓo' na ɓo'. Ƴutta ɗah, Musaa dokuk ŋ dala waaye, dagiŋ ɗe na woyse Yosuwe, kuɓu Nun, tas ŋ ɗooƴ ɗiipa. Raak ɗe fiir. ");
INSERT INTO sav_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Wa raakka mbeh, Musaa woosa Nikiɗi ne : « Marka ! A fu nak ko ne ŋ ɓay cuuɓii waaye fu teeɓɗi so yi hunan na so. Moona a fu woyee so ne : “ Ŋ inhiɗ ɗa na tiikiŋ ɗa, ŋ hey ɗa baahohe. ” ");
INSERT INTO sav_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ɗiski wa nik, nik ne fu baahohiɗ to ɗah, teeɓ po tiindohaaɗ ciŋ ɗa ; ŋ hey ɗa inhe baahiɗ te fu hey yo baahohisse. Kina alkoh ne cuuɓii, wa cuuɓiŋ ɗa ! » ");
INSERT INTO sav_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nikiɗi loffa Musaa ne : « Mi ŋ haf fo, ŋ hey hune na ɗa ne ŋ iɗsiɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musaa woosa ne : « Nik ne fu ŋ haf fu, fu heyɗi ɓoo ɓende ɗah, kina ɓoo kurkiɗoh ndii. ");
INSERT INTO sav_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Fu ɓendɗi ɓoo ɗah, wa inhohsan na ne fu baahohiɗ to, mi na cuuɓiŋ ɗa ? Huni fu hunan na ɓoo weɗ tahan ɓoo ɗaloh na cuuɓ ciŋ kehƴi jen. » ");
INSERT INTO sav_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nikiɗi woosa Musaa ne : « Ŋ baahohiɗ ɗa te ŋ inhiɗ ɗa ŋ tiikiŋ ɗa, tahha po ŋ hey name tum ini fu kiim mbo weem. » ");
INSERT INTO sav_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musaa woosa ɗe ne : « Ŋ kiim ɗa wa kiim, teeɓ po yaki fu yak ! » ");
INSERT INTO sav_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nikiɗi woosa ɗe ne : « Ŋ hey taambɗe baah kiŋ ngo jen ŋ fikiifu te ŋ hey woye tiikiŋ ngo \"Nikiɗi\" ŋ ɗafka ; ŋ baahohee ɓoyi ŋ baahoh, ŋ yirmee ɓoyi ŋ yirim. ");
INSERT INTO sav_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Waaye fu minanɗi hot fikiiriŋ ngo, laam ali ɓo' minɗi so hot te a taalndiɗ a pesisse. ");
INSERT INTO sav_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Seka, ɗisik weɗi ŋ ndii, ŋ serooso ; fu na hee tufke ŋ ɗafuk atoh fi. ");
INSERT INTO sav_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Siñaariŋ yaki ŋ yak taambee ɗah, ŋ hey ɗa ɗasɗe ŋ nungiŋ atoh fi, ŋ ɗip ɗa na yaahiŋ ngo po ŋ taamb. ");
INSERT INTO sav_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ŋ nihis yaahiŋ ngo ɗah, fu hey hote finhooriŋ ngo, waaye fikiiriŋ ngo minanɗi hotu. » ");
INSERT INTO sav_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nikiɗi woyissa Musaa ne : « Pestissa atoh kanak po ca nik ɗapas findi ca koc, ŋ hey fiise nga ca woo ci nikee ŋ ca koc te fu pookka ca. ");
INSERT INTO sav_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kooɗka, kim na ɓaaɓa teel, fu rap ŋ ɗafuk tangooriŋ Sinaay, fu tufuk nga ŋ fikiiso. ");
INSERT INTO sav_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Fu kaɗee ɗah, ali ɓo' kinaat hun na ɗa te ɓo' kinaat hotu ŋ ɗafuk tangoori jen ; ɗoopaat sah kinaat eleeruk ŋ ɓak ciŋ wa, wa mbaal haa, wa pe' haa, wa inoh haa. » ");
INSERT INTO sav_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musaa pessa atoh kanak findi ca koc, a kurukka na ɓaaɓa teel, a ammba ca ŋ yaah, a rappa ŋ tangooraŋ Sinaay findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nikiɗi ruhussa na eela, a rissa ŋ ɗooƴa ŋ sero Musaa, a woosa tiikiŋ ɗe haf ce po wa ɗiiɗɗeeɗa an : « Nikiɗi. » ");
INSERT INTO sav_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ŋ ineem, Nikiɗi taammba Musaa fiki, a woosa ŋ ɗafka an : « Ñam Nikiɗi, Kooh yi na yirmohe te baahohe, yi yooɓɗi ayruk, riiffa na waaɗohaaɗ te a dokkuu finho muk, ");
INSERT INTO sav_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","a teeɓohee baah kiŋ ɗe po ŋ junni (1000) gomal, a ɗaasohee tumohaaɗ moɗaaɗi, na bakaaɗ, na ndengsiɗkoh, waaye ɓoyi tooñ a ambuu ɗe findi ɓoyi tumɗi in, te a na dege deg miskiɗ kuɓuuci na set ci na setaat ciŋ baab ci tum moɗaaɗi po ŋ gomala nikiisɗoh. » ");
INSERT INTO sav_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Jaarra Musaa ƴekiɗta Nikiɗi po a raɗukka ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A woosa ne : « Heɗ ɓoo, ŋ kiim ɗa wa kiim, nik ne fu baahohiɗ to ɗah, haya fu ɓend ɓoo. Ŋ inhiɗ ne cuuɓii wa cuuɓ ndengiɗ haf, waaye ɗaasa ɓoo tumohaaɗ ci moɗaaɗiici na bakaaɗ ciŋ ɓoo, tuma ɓoo raakuuɗiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nikiɗi loffa ɗe ne : « Ŋ hey tufkiɗe ambtiɗoh na ɗu. Ŋ hey tume, ŋ fiki cuuɓiŋ ɗa jen, keemaan ci ɓo' moosɗi hotoh ŋ ali kur na ali ɓak ŋ kehƴi ; ɓooɓi wil ɗa jen hey hote tumohaaɗ ciŋ ngo mi yi Nikiɗi. In ci ŋ lahɗohan nga ɗa, ca nikan in feyohiɗ. ");
INSERT INTO sav_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Faɗoha nof baahiɗ ini maa nakee ɗa woti. Ŋ hey aañe ŋ fikiiɗu : Amoor ci na Kanaan ci na Hit ci na Peris ci na Hiw ci na Yebuus ci. ");
INSERT INTO sav_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wortukaat ambtiɗoh nawle na ɓooɓiŋ kur ci ɗu aasohan, mbaa ɓa nikan fiir jaɗuuɗ ŋ harmban ɗu. ");
INSERT INTO sav_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Waaye ɗu na hee hey fole seeƴkohaaciŋ ɓa, ɗu pook nataal ci, ɗu fol kumbin ci, ci ɓa na yakɗohee kooh ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ali ɓo' nga ɗu ƴekɗanɗi kooh wiiriis, laam, mi yi Nikiɗi, ŋ fiir fiir po weɗ tiikiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Te ali ɓo' kinaat ambtiɗoh nawle na ɓooɓaŋ kur ka ; fu ambtiɗoh na ɓa ɗah, ɓa hey ɗa ɓeke ŋ njaalooniŋ ɓa, weɗ ne ɓa seeƴkee wuu kooh ciŋ ɓa ɗah, ɓa ɓeeɗuk ɗa ne fu ñam ŋ seeƴki. ");
INSERT INTO sav_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Te ineem hey kaɗe po fu ɓayiɗ kuɓuuciŋ ɗa ƴaar ci ɓitiɓ ŋ cafaƴ ciŋ ɓa, cafaƴ ceem ɓek ɓa ŋ njaalooni ɓa na njaalo'e, weɗ ne ñaamki ɓa na ñaamke kooh ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ali ɓo' nga ɗu naayɗanɗi tiwiñ, a haɓɗee nataal, a amb ca findi Kooh. ");
INSERT INTO sav_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Yaa nu nga, fu hey feetke feetiŋ Mbuuruuci raakaaɗi lawiir ci ; ini ree neeh yasna-kanak ŋ jamanooni wa ambu ŋ caɓniŋ mbong ci, fu ñaman mbuuru raakaaɗi lawiir findi ŋ woyohee wa, laam ŋ caɓniŋ mbong ci weɗ ɗu puloh Misra. ");
INSERT INTO sav_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Kuɓuuciŋ ɗa saaw ci ƴaar ci jen, ɓa wuu so, saaw ci naar ciŋ ɗoopaat ci sah ñam raak ca findi ciŋ inoh ci, mbaal ci na pe' ci. ");
INSERT INTO sav_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Saaw ciŋ mbaam ci, fu na hee ca hey romkohe na mbaal wala pe' ; fu romkohɗi ca ɗah, fu joyiɗ weer mbooh ciŋ ca. Fu hey romkohe saaw ciŋ ɗu ƴaar ci jen te ali ɓo' hayanɗi ŋ fikiiso yaah ɓarang. ");
INSERT INTO sav_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Fu hey pangke neeh yasna-yino, wi yasna-kanakɗoh fu iɗsiɗuk, fu hey iɗsiɗke nga sah ŋ jamanooni na guurohse na wi na nguɗohse. ");
INSERT INTO sav_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Mbeh dokkiɗ yasna-kanak ŋ finho Paak, fu hey feetke feetiŋ Beleeci koc ruund ; wa kaɗ po ŋ reehɗohaaniŋ kiis ki ɗah, fu nam feetuk feetiŋ Nguɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Waas kaahay ŋ kiis ki, ƴaar ciŋ cuuɓi jen hey haye ŋ fikiiso mi yi Heɗ ɗu Nikiɗi, Koohiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Laam ŋ hey aañe cuuɓ ci ŋ fikiiɗu te ŋ hey tume po ɗu raak merhey angiɗ ; ali ɓo' waaɗanɗi ɓay kur kiŋ ɗu ŋ jamanooci ɗu hayohan ŋ fikiiso waas kaahay ŋ kiis ki. ");
INSERT INTO sav_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ɓo' nga ɗu seeƴkee ɓi ɗoopaat wuu so ɗah, ñif miŋ ca kinaat hun na in raakiɗ lawiir. Te sepet ciŋ seeƴkiŋ feetiŋ Paak neehanɗi po na ɓaaɓa. ");
INSERT INTO sav_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ɓo' nu nga ɗu ɗah, a komaat to ini a koc nguɗ ŋ yohon ciŋ ɗe ŋ kahan ndo mi yi Nikiɗi, Koohiŋ ɗu. Ali ɓo' nga ɗu kinaat tikoh koteng miis mi kooɗohu ŋ ndaam ce. » ");
INSERT INTO sav_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nikiɗi woosa Musaa ne : « Woo cii ceɗ maa hee tufkiɗohe ambtiɗohiŋ ngo na ɗa, na Israayel ci ; fiisaa ca. » ");
INSERT INTO sav_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musaa nikka ŋ tangooraŋ Sinaay na Nikiɗi ini ree neeh ndaŋkiyaah-nikiis (40), a ñamɗi, a anɗi. Nikiɗi fiissa ŋ atoh ca woo ciŋ Ambtiɗohi, Nakoh-ci-Ndaŋkiyaah-ci. ");
INSERT INTO sav_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Wa Musaa ruhus tangooraŋ Sinaay, raak ɗe na atoh ca kanak ca ŋ yaah, atoh ci ɗapas ci na teeɓohe Ambtiɗohi, fikiiriŋ ɗe siñaarɗeeɗa sagu woyi a woyee na Nikiɗi, waaye a inheeɗaa. ");
INSERT INTO sav_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Wa a ree po Aaruna na Israayel ca jen hotta fikiiriŋ ɗe siñaarɗeeɗa, ɓa kaañɗi ɗe reɓuk. ");
INSERT INTO sav_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Weɗi a ɓeeɗkoh ɓa. Aaruna na yakak caŋ Israayel jen hayya nga ɗe, a woytohha ɓa. ");
INSERT INTO sav_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ƴutta, Israayel ca jen reɓpa, a eɗta ɓa nakoh ci jen, ci a rahsoh ŋ Nikiɗi ŋ ɗafuk tangooraŋ Sinaay. ");
INSERT INTO sav_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Wa Musaa ƴut woo na ɓa, a muurra fikiiriŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Taambohha ndeem, a kaɗeesa ŋ ɗiskaŋ Nikiɗi ɗah, a nihis muuriŋ ɗe po a puloh nga. A pulohha nga ɗah, a woo Israayel ci ini a ɓayoh nga. ");
INSERT INTO sav_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israayel ca marakka fikiiriŋ ɗe ɗah, ɓa hot ne wa na siñaarɗe siñaariɗ, jaar a muura po findi a na dokkohisse woya na Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musaa cohɗohha cuuɓaŋ Israayel jen, a woosa ɓa ne : « In cii ceɗ Nikiɗi nakoh ne ca taambɗu : ");
INSERT INTO sav_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Neeh yasna-yino ceɗ na hee pangkasse, wi yasna-kanakɗoh waa hee nike nga ɗu mbeh hooliɗ, mbehi na iɗsiɗkohse wi hoolɗu wuu Nikiɗi. Ɓo' nu panguk ŋ mbeheem ɗah, a hey apse. ");
INSERT INTO sav_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ɗu heyɗi sah fuuɗe yongkaah ŋ ali ɗisik ŋ mbehi na iɗsiɗkohse. » ");
INSERT INTO sav_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musaa taalndiɗta woyeeɗa Israayel ci jen an : « In cii ceɗ Nikiɗi nakoh : ");
INSERT INTO sav_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ɓayaat ŋ in ci ɗu raakoot, ɗu eɗoh ca wuu Nikiɗi. Ɓo' nu teyɗuka tum na keeñ soosiɗ ɗah, a hey eɗohe ini a onoh wuu Nikiɗi. A miniɗ eɗoh : urus, haalis wala moos. ");
INSERT INTO sav_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","A namiɗ min eɗoh : ooy bulo, ooy ruumind eɗfiɗ, ooy ruumind coy, leeŋ wala find pe'. ");
INSERT INTO sav_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","A namiɗ min eɗoh : ɓi und kuy mbaal suupuuɗ ruumind wala ɓi und inoh cookom wala ndooɗ kassiya. ");
INSERT INTO sav_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","A namiɗ min eɗoh : diwliin fuuɗoha laampaaci, wala ɓi eeñɗoha haɓɗohu diwi na hoolɗohse, wala wuu cuuraayi. ");
INSERT INTO sav_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","A namiɗ min eɗoh pemeeci na woyse sooham wala ɓi peme wiiriis, moɗsinoha efoodi na nafaani ŋ fikiiri. » ");
INSERT INTO sav_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Musaa woyissa ne : « Ɓi raak min-min nga ɗu jen, hayaat ne ɓa haɓiɗ in ci Nikiɗi nakoh jen. ");
INSERT INTO sav_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ɓa hay ɗah, ɓa haɓiɗ Genohaani, na baasiŋ wa na in ci ula, korohaaci, kaadar ci, laat ci, kumbin ci, na tufkohaaci. ");
INSERT INTO sav_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ɓa haɓiɗ Wahndeeni na ndooɗ ciŋ wa na kunohaaniŋ wa, ɗiski na romkohse. Ɓa haɓiɗ ridooni na ɗasɗe Ɗiski Hoolohngaani. ");
INSERT INTO sav_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ɓa nam haɓiɗ taaɓli na ndooɗ ciŋ wa, na tumohaaci hunan naa jen, na mbuuruuci degsan nga, wuu Kooh. ");
INSERT INTO sav_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ɓa nam haɓiɗ degohaaniŋ laampaaci na in ci hunan naa, laampaaciŋ wa na diwliiniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ɓa nam haɓiɗ keesi seeƴkohaani suusohsan cuuraay ci na ndooɗ ciŋ wa. Ɓa haɓiɗ diwi na hoolɗohse, na cuuraayi eeñɗohaani. Ɓa haɓiɗ ridooni nikan ŋ aasohaani. ");
INSERT INTO sav_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ɓa nam haɓiɗ keesi seeƴkohaani dohohsan hoosuuɗ ci, na giryaasiŋ wa moosi, na ndooɗ ci wa ɓayohsan, na tumohaaci hunan naa jen. Ɓa haɓiɗ beñwaari tumohsan masmi ɓoktukohsan na degohaaniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ɓa nam haɓiɗ piis ci ɗingohsan bayaali, na kumbin ci, na tufkohaaciŋ ca, na ridooniŋ aasohaaniŋ bayaali. ");
INSERT INTO sav_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ɓa haɓiɗ tatohaaci amban Genohaani ngaŋ kehƴi, na niy ciŋ ca, na tatohaaci amban ɗingiŋ bayaali ngaŋ kehƴi, na niy ciŋ ca. ");
INSERT INTO sav_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ɓa haɓiɗ kulɓaaci hoolɗuuɗ ci pangkohsan ŋ Ɗiski Hooliɗi, ca nikka ciŋ Aaruna seeƴkiɗohi, na ciŋ kuɓuuciŋ ɗe ne ɓa pangkee findi seeƴkiɗoh ɗah. » ");
INSERT INTO sav_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Wa Musaa woo ɓa nakoh ceem, coha reehha, Israayel ca cootta. ");
INSERT INTO sav_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ɓi waaɗee eɗoh, te ɓa teyɗukkaa tum na keeñ soosiɗ, ɓa hayya eɗohe in ci ɓa onoh wuu Nikiɗi, ɓa eɗohha ca wuu haɓɗuuki na taambkohuukiŋ Ɗiipi-na-Cohohse, na kulɓaaci hoolɗuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ƴaar ci na ɓitiɓ ci jen, ɓi teyɗukee wa na keeñ soosiɗ, ɓa ɓayeeɗa ɓi tokkaah kulɓa, ɓi long-long, ɓi jaaru ndukun, ɓi tokkaah wiiriis, na in nu nik ne wa urus ɗah, yaa nu nga ɗah ɓayya ursi fu eɗoh, fu eɗohhaa findi eɗohi na raɗsasse wuu Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ɓi raakee ooy bulo, ruumind eɗfiɗ wala ruumind coy, leeŋ wala find pe', und kuy ruumndiɗuuɗ wala und inoh cookom, ɓa jen, ɓa haytohha ca. ");
INSERT INTO sav_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ɓi pulɗee in haɓɗohuuɗ haalis na moos ruumind eɗohaah wuu Nikiɗi haytohha ca. Ɓi namee raak ndooɗ kassiya haytohha ca wuu in ci joy haɓɗu. ");
INSERT INTO sav_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ɓitiɓ ci raakee min-min jen monnda na yaah ciŋ ɓa, ƴutta ɓa haytohha in ci ɓa mond, ɓi ooy bulo na ooy ruumind eɗfiɗ, na ruumind coy na ooy leeŋ. ");
INSERT INTO sav_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ɓitiɓ ci teyɗukee wa na keeñ soosiɗ te ɓa minnda mond, ɓa mondeeɗa find pe' ne ɓa haɓiɗ ooy. ");
INSERT INTO sav_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ɓi adgohee cuuɓi haytohha pemeeci na woyse sooham na ɓi peme moɗiɗ wiiriis moɗsinoha efoodi na nafaani ŋ fikiiri ; ");
INSERT INTO sav_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ɓa nammba ɓay eeñɗoha na diwliin, ne laampaaci min fuuɗu, diwi na hoolɗohse na cuuraayi eeñɗohaani nam haɓɗu. ");
INSERT INTO sav_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israayel ci kommba Nikiɗi in ci ɓa onoh ŋ ini neɓ ɓa. Ɓi teyɗukee na keeñ soosiɗ jen, ƴaar na ɓitiɓ, haytohha ca, ne in ci Nikiɗi woo Musaa jen min haɓɗu. ");
INSERT INTO sav_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musaa woosa Israayel ci ne : « Inhaat ne Nikiɗi taniɗ Betsalel, kuɓu Uri, a setiŋ Hur, a ɓaah ŋ cuuɓiŋ Yudaa. ");
INSERT INTO sav_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A riifɗiɗ Betsalel na Fuuɗsiŋ ɗe po a raakiɗ min-min, a ñaañiɗ, a raakiɗ inah-inah ŋ panguk nu panguk. ");
INSERT INTO sav_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","A miniɗ marak po a inah findi a joy haɓɗoh in moɗiɗ ngaŋ urus, haalis, wala moos ; ");
INSERT INTO sav_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","a miniɗ pes atoh peme, a namiɗ min ɓek peme ŋ ɓekoha, a miniɗ pes kidig, a miniɗ haɓiɗ panguk nu nik. ");
INSERT INTO sav_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","A namiɗ ɗe on po a miniɗ jangɗoh, a na Oholiyaab kuɓu Ahisamaak yi ɓaah ŋ cuuɓiŋ Daan. ");
INSERT INTO sav_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","A tumiɗ min-min ŋ haf ciŋ ɓa po ca riifiɗ ne ɓa min pes peme, ɓa min fer in moɗiɗ ŋ liiɓ ciŋ ɓa, ɓa min moɗsin piis na ooy bulo, na ruumind eɗfiɗ, na ruumind coy na leeŋ, ɓa min teɗ, te ɓa min haɓiɗ panguk nu nik, ɓa min fer in moɗiɗ. ");
INSERT INTO sav_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Betsalel na Oholiyaab na ɓi ɓo' wiiriis herñiɗ, Nikiɗi oniɗ ɓa inah-inah ne ɓa haɓiɗ pangkaah nu nik ne wa haɓɗaah ŋ Ɗiski Hooliɗi ɗah. Ɓooɓeem jen nikka ɓi haɓɗan in ci Nikiɗi nakoh jen, ɓa haɓɗan ca findi Nikiɗi nakohee ɓa ca. » ");
INSERT INTO sav_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musaa ɓeeɗkiɗukka Betsalel, Oholiyaab na ɓooɓa Nikiɗi onee hereñ jen te ɓa teyɗukka ɓaah ŋ ɓi haɓɗan pangki. ");
INSERT INTO sav_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musaa eɗta ɓa onoh ca Israayel ca haytohee jen ne pangkaŋ Ɗiska Hooliɗa haɓɗu. Ɓaaɓ nu ree ɗah, ɓooɓa komis Musaa in ca ɓa onoh ŋ keeñ soosiɗ. ");
INSERT INTO sav_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Wa kaɗeeɗa po yaa nu nik ngaŋ pangkoh ca faɗta ina a haɓɗe. Ɓa kaɗta, ");
INSERT INTO sav_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ɓa woyeeɗa Musaa an : « In ci ɓooɓi haytoh uupiɗ fuuf ini etohu ŋ haɓɗuukiŋ in ci Nikiɗi nakoh. » ");
INSERT INTO sav_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musaa nakohha ne wa woysaat ŋ dala ne : « Wa ƴaar haa wa ɓitiɓ haa, ali ɓo' kinaat haɓɗis in haytohaah ŋ Ɗiski Hooliɗi ! » Ɓooɓa tufkiɗta, ɓa haytohisɗi. ");
INSERT INTO sav_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","In ca kooɗkiɗassee doyeen wuu pangka jen, ca uupeen sah. ");
INSERT INTO sav_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Betsalel, na pangkoh ca uupee hereñ, ɓeɗ haɓɗee Genohaani. A haɓɗohee wa haf-piis ndaŋkiyaah teɗohu ooy leeŋ eɗfiɗ ndengiɗ ambsohuuɗ na ooy bulo, na ooy ruumind eɗfiɗ na ruumind coy. A moɗsinohha piis ci ɓi nataal seruben. ");
INSERT INTO sav_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Piis ceem ceɗ hende, waa nu nga ɗah hutiiniŋ wa nikee saangal ndaŋkiyaah na nikiis (14), angiini nikka suung nikiis. ");
INSERT INTO sav_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Yatuus nga ca ambsohuusa suptuusa yino, yatuus ci tas nammba tumu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","12","Piis ci yatuus ci ambsohuuɗ ceem, suptiɗuusa ɓi yaah koroha ŋ ɓaki winoori ŋ sereendiŋ angiini, ca haɓɗohsee ooy bulo. Yatuus ci ambsohuuɗ ci tas nammba suptiɗu mand ɗaa. Yaah ci korohaaci ŋ piis ci ambsohuuɗ ci nikka ndaŋkiyaah-yatuus (50). Ciŋ piis ci ambsohuuɗ ci tas nammba nik ndaŋkiyaah-yatuus (50). Korohaaceem, waa nu nga ɗah korɗohuusa na morom wa ŋ piis ci cinooci ambsohuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Korɗoha ndaŋkiyaah-yatuus (50) haɓɗuusa na urus ; ca ambsohha piis ci po baasiŋ Genohaani nikka yino. ");
INSERT INTO sav_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","A ɓayya find pe', a haɓɗissa haf-piis ndaŋkiyaah na yino (11) uloha baasiŋ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Haf-piis ceem ceɗ hende, waa nu nga ɗah hutiiniŋ wa nikee suung ndaŋkiyaah-kaahay (30), angiini nikka suung nikiis. ");
INSERT INTO sav_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","A ambsohha piis ci yatuus ci, ca nikka yino, a nammba ambsohis yasna-yinooci kiik ca, ca nikka yino. ");
INSERT INTO sav_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","A haɓiɗta yaah koroha ndaŋkiyaah-yatuus (50) ŋ sereendiŋ piisi yatuusɗoh ŋ piis ci yatuus ci ambsohuuɗ ci, a nammba haɓɗis yaah koroha, ndaŋkiyaah-yatuus (50) ŋ sereendiŋ piisi koc ŋ piis ci yasna-yinooci ambsohuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","A haɓiɗta korɗoha ndaŋkiyaah-yatuus (50) na moos ruumind ne a ambsoh haf-piis ci ambsohuuɗ ci po baasi nik yino. ");
INSERT INTO sav_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","A ɓayya und kuy mbaal suupuuɗ ruumind, a haɓiɗta baas uloha baasi kanakɗohiini. A haɓɗissa baas wiiriis na und inoh cookom degaah ŋ ɗafuk weem. ");
INSERT INTO sav_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","A ɓayya hang kassiya, a haɓiɗta kaadar tufkiɗ ne ca amb Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kaadar ci jen hendee hend ; waa nu nga ɗah hutiiniŋ wa nikee saangal yatuus, angiini nikka suung yino na camban. ");
INSERT INTO sav_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kaadar ci jen findi ca hend, waa nu nga ɗah pulɗiɗuusa ndooɗ kanak findi kot, ca hunee hun waaye ca laaltiɗoheeɗi. ");
INSERT INTO sav_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A haɓiɗta kaadar ndaŋkiyaah-kanak (20) ŋ ɓak yaah-sing ne fu eɗ pulohaaɗ-noh finho, fu aasee ɗah. ");
INSERT INTO sav_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Kaadar ceem haɓɗiɗuusa tufkoha ndaŋkiyaah-nikiis (40) ŋ ooɓi, ca haɓɗohsee haalis. Kaadar nu nga ɗah raakka tufkoha kanak, kot ci kanak ciŋ kaadari joy ɓeku ŋ tufkohaaceem. ");
INSERT INTO sav_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ɓaki winooriŋ Genohaani, wi lah yaah-ñaahum, nammba haɓɗiɗu kaadar ndaŋkiyaah-kanak (20), ");
INSERT INTO sav_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na tufkoha ndaŋkiyaah-nikiis (40) haɓɗohu haalis, kaadar nu nga ɗah raakka tufkoha kanak ŋ ooɓi. ");
INSERT INTO sav_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ɓaki mirndoh ŋ Genohaani, ŋ ɓak muyohaaɗ-noh, raakka kaadar yasna-yino. ");
INSERT INTO sav_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Wa raakka kaadar kanak ŋ koñ ci nik ŋ fikiira ŋ ɗooƴ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Hang ciŋ kaadar ceem nikka kanak ini kooɗoh kehƴi po ca reesa ŋ ɗafka, ca tokɗohuusa baahiɗ na inaa haa kiñi, kaadar ci nik ŋ koñ ci kanak ci jen tumuusa ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Jaarra, fikiiri raakka kaadar yasna-kaahay na tufkoha ndaŋkiyaah na yasna-yino (16) ci haɓɗohu haalis. Kaadar nu nga raakka tufkoha kanak. ");
INSERT INTO sav_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ŋ finho ineem a haɓiɗta laat kassiya yatuus ne ca galandu ŋ kaadar ci nik ŋ ɓak yaah-sing. ");
INSERT INTO sav_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","A haɓɗissa laat yatuus, ci galandsan ŋ ɓaki ñaahmi, na laat yatuus ci galandsan ŋ fikiira, ŋ ɓak muyohaaɗ-noh. ");
INSERT INTO sav_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wiŋ leerni taambɗassan ŋ leerniŋ kaadar ci jen, wa ambohan ɓak po ɓak. ");
INSERT INTO sav_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A ulla kaadar ci na urus, a haɓiɗta in ci haa kiñi, ci laat ci taambohan, a ulla laat ci na urus. ");
INSERT INTO sav_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ƴutta a haɓiɗta rido na leeŋ eɗfiɗ ndengiɗ na ooy bulo na ruumind eɗfiɗ na ruumind coy, a moɗsinndaa na ɓi nataal seruben, wa nikka panguk feroh keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A ɓayya kumbin kassiya nikiis, a muurra ca na urus. Ca waakɗuusa koroha urus. Ca haɓɗiɗuusa tufkoha nikiis haɓɗohu haalis naayɗuuɗ. ");
INSERT INTO sav_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Aasohaaniŋ ɗiipi nammba haɓɗiɗu rido, wa haɓɗohsee leeŋ eɗfiɗ ndengiɗ, wa moɗsinuusa na ooy bulo na ooy ruumind eɗfiɗ na ruumind coy. ");
INSERT INTO sav_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wa waakɗuusa kumbin yatuus na korohaaciŋ ca na ñoor ci wa ɓekohsan. Ñoor ci na haf ciŋ kumbin ci muuruusa na urus. Tufkohaaciŋ kumbin ci yatuus ci haɓɗohsee moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Betsalel ɓayya hang kassiya, a haɓiɗta Wahndeeniŋ Ambtiɗohi. Hutiiniŋ wa nikee suung kanak na camban, angiini nikka suung na camban, njooliini nikka suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A ullaa na urus koceet ŋ ɗooƴi na finhoori, a haɓɗiɗtaa banda urus ŋ finhoori po wa willa. ");
INSERT INTO sav_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A haɓɗiɗtaa inaa nikiis haa kiñi, ca nikee urus, kot nu nga ɗah, a ñaakiɗta yino nga, ɓak nu nga ɗah raakka kiñi kanak. ");
INSERT INTO sav_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A haɓiɗta ɓi ndooɗ kassiya, a ulla ca na urus. ");
INSERT INTO sav_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A taambiɗta ca ŋ ɗooƴ kiñiica ne wahndeena min ɓayu. ");
INSERT INTO sav_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A haɓɗiɗtaa kunoha, ɗiski na romkohse, wa nikee urus koceet ; hutiiniŋ wa nikka suung kanak na camban, angiini nikka suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Na urseem, a tiɓpa po a puliɗta nataal seruben ŋ ɓak nu nga ŋ ɓak ci kanak ciŋ angiiniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ca yurhiɗkohee yurhiɗkoh, ca hiirra ŋ ɗiski na romkohse, ca raɗissa paɓ ciŋ ca ŋ ɗafki, ca ɗippaa. ");
INSERT INTO sav_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","A ɓayya hang kassiya, a haɓiɗta taaɓli, hutiiniŋ wa nikee suung kanak, angiini nikka suung yino, njooliini nikka suung na camban. ");
INSERT INTO sav_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A ullaa na urus koceet, a haɓɗiɗtaa banda urus po wa willa. ");
INSERT INTO sav_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A haɓɗiɗtaa kaadar, angiiniŋ wa nikee santimeetar yasna-kaahay, a haɓɗiɗtaa banda urus po wa willa. ");
INSERT INTO sav_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A haɓɗiɗta taaɓli inaa haa kiñi nikiis, ca nikee urus, a tummba ca ŋ koñ ciŋ wa nikiis ci, teemb ŋ kot ciŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Kiñiici nikee ŋ sero kaadari, ne ndooɗ ci na ɓayohse taaɓli taambɗu nga ca. ");
INSERT INTO sav_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ŋ ineem, a haɓiɗta ndooɗ kassiya kanak, a ulla ca na urus, ɓayohaa wa. ");
INSERT INTO sav_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A haɓiɗta in ci nikan ŋ ɗafuk taaɓli : Palaat ci, na kaas ci, na koppaaci na meemeeci, ca jen ca haɓɗohsee urus koceet ; koppaaci na meemeeci nikka tumoha anaah ci na seeƴkohse. ");
INSERT INTO sav_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Betsalel ɓayya urus koceet a tiɓpaa po a puliɗta degoha laampa na tasiŋ wa na faani na koppaaci na pos ci rangsukaaɗiici na ci rangsukiɗ ci. Ca jen ceɗ ɓaahee ini ca tiɓohu. ");
INSERT INTO sav_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Wa raakka naak yasna-yino ŋ faaniŋ wa, kaahay ŋ ɓaki singi, kaahay ŋ ɓaki ñaahmi, ca nikka sal kaahay. ");
INSERT INTO sav_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Naak ci yasna-yinooci, waa nu nga raakka koppa kaahay findi amand na posohe, waa nu nga ɗah raakka ɓi pos rangsukaaɗi na ɓi pos rangsukiɗ. ");
INSERT INTO sav_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Faaniŋ wa raakka koppa nikiis findi amand na posohe, waa nu nga ɗah na pos ciŋ wa rangsukaaɗiici na ci rangsukiɗ ci. ");
INSERT INTO sav_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ooɓ sal nu nik raakka pos rangsukaaɗi ŋ faaniŋ degohaaniŋ laampaaci, po sal ci kaahay ci jen raakka. ");
INSERT INTO sav_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Pos ci rangsukaaɗiici na naak ci jen nikee urus koceet tiɓuuɗ, ca na ini tas ŋ degohaaniŋ laampaaci jen ceɗ ɓaah ini ca tiɓohu. ");
INSERT INTO sav_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A haɓɗiɗtaa laampa yasna-kanak, a nammbaa haɓɗiɗ tanaaƴ na tumoha ƴuuƴ ; ca haɓɗohu urus koceet. ");
INSERT INTO sav_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","A ɓay kilo urus koceet ndaŋkiyaah-kaahay (30) weɗ a haɓɗoh degohaaniŋ laampaaci na in ci hun naa jen. ");
INSERT INTO sav_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ƴutta, a haɓiɗta seeƴkoha, suusoha cuuraay. A haɓɗoha hang kassiya, wa nikee kaare, ɓak nu nga nikka suung yino te njooliini nikee suung kanak. A puliɗtaa wiic ciŋ wa ŋ koñ ciŋ wa ŋ ɗafki, a puliɗndoh ca ŋ hangi wa haɓɗohu. ");
INSERT INTO sav_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A ullaa na urus koceet ŋ ɗafki na wiic ci, a nammba ul ɓak ciŋ wa jen ; a haɓɗiɗtaa banda urus po wa willa. ");
INSERT INTO sav_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A haɓɗiɗtaa inaa haa kiñi kanak ŋ ooɓ bandaani, in ceem nikee urus. Ɓak nu nga raakka yino, ne ndooɗ ci ɓayohsana taambɗu nga ca. ");
INSERT INTO sav_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ŋ ineem, a haɓiɗta ndooɗ kassiya kanak, a ulla ca na urus. ");
INSERT INTO sav_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A haɓiɗta diwi na hoolɗohse hoolɗuuɗ ci, wa nikka in hoolɗuuɗ wuu Kooh, a nammba haɓiɗ cuuraayi hooliɗi eeñiɗi na dohse ŋ seeƴkohaani, a haɓiɗ ca findi haɓɗoh eeñɗoha keeh-keeh na haɓɗohe. ");
INSERT INTO sav_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ƴutta, a waakka hang kassiya, a haɓiɗta keesi seeƴkohaani na dohohse hoosuuɗ ci ; wa nikee kaare, ɓak nu nga ɗah nikee saangal kanak na camban ; njooliini nikka suung kaahay. ");
INSERT INTO sav_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A puliɗta wiic ciŋ wa ŋ koñ ciŋ wa nikiis ci, a puliɗndoh ca ŋ hangi wa haɓɗohu ; a ullaa jen na moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A haɓiɗta in ci hun naa jen : Tumohaaciŋ weti niiniɗi, peel ci, tumohaaciŋ ñif mi na lisse, furset ciŋ sepet ci na tumohaaciŋ ƴuuƴ ci. A haɓɗoh ca jen moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A haɓɗiɗta seeƴkohaani giryaas moos ruumind, a deggaa ŋ ɗooƴi, ŋ ooɓ kaadariŋ seeƴkohaani, wa yoorra ŋ leerni po wa teemmba na leerniŋ njooliiniŋ seeƴkohaani. ");
INSERT INTO sav_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A haɓiɗta in nikiis haa kiñi, a ñaakiɗta ca ŋ koñ ci nikiis ciŋ giryaasi, ɗiski ndooɗ ci ɓeksan. ");
INSERT INTO sav_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A haɓiɗta ndooɗ kassiya kanak, a ulla ca na moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A ɓekka ca ŋ kiñiici ŋ ɓak ciŋ seeƴkohaani, ca nikka ambohaaciŋ wa ne wa ɓayse ɗah. Seeƴkohaani nikee kees, ɗooƴi nikka hulang. ");
INSERT INTO sav_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ƴutta, a haɓiɗta beñwaari na ɓoktukohse na degohaaniŋ wa, a haɓɗoh ca moos ruumind, a ɓay seetuucaŋ ɓitiɓ ca na teembe ŋ nguɓu Ɗiipa-na-Cohohse ne ɓa panguk, a haɓiɗta ca. ");
INSERT INTO sav_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","A haɓiɗta in ci ɗingohsan bayaali wil Genohaani, a haɓiɗta piis teɗohuuɗ leeŋ eɗfiɗ ndengiɗ ɗingoha ɓak yaah-sing ne fu eɗ pulohaaɗ-noh finho, fu aasee ɗah. Ɓakeem nikee saangal ndaŋkiyaah-yatuus (50). ");
INSERT INTO sav_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Kumbin ci ndaŋkiyaah-kanak ci piis ci tokohsan na tufkohaaci ndaŋkiyaah-kanak ci ca yipohsan haɓɗohuusa moos ruumind, ca raakka koroha na ñoori ca ɓekohsan haɓɗohu haalis. ");
INSERT INTO sav_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ɓaki lah yaah-ñaahum hennda ɗaa, wa nammba haɓɗohu ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ɓaki lahoh na muyohaaɗ-noh, hutiiniŋ piis ciŋ wa wa nikee saangal ndaŋkiyaah-kanak na yatuus (25), ca toksan ŋ kumbin ndaŋkiyaah ci yipsan ŋ tufkoha ndaŋkiyaah. Korohaaciŋ ca na ñoor ci nikee haalis. ");
INSERT INTO sav_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ɓakiŋ aasohaani, ŋ pulohaaɗ-noh nikee saangal ndaŋkiyaah-kanak na yatuus (25). ");
INSERT INTO sav_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Ɓak ci kanak ci aasohaani nik ŋ leerniŋ ca, waa nu nga, piis ciŋ wa nikee saangal yasna-kanak na camban, wa raakka kumbin kaahay na tufkohaaciŋ ca. ");
INSERT INTO sav_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Piis ciŋ ɗingiŋ bayaali jen, haɓɗohsee leeŋ eɗfiɗ ndengiɗ. ");
INSERT INTO sav_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tufkohaaci kumbin ci yipohsee nikee moos ruumind, korohaaci na ñoor ci nikka haalis, haf ciŋ kumbin ci uluusa na haalis. Kumbin ciŋ ɗingiŋ bayaali jen raakee ñoor haɓɗohu haalis. ");
INSERT INTO sav_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ridooniŋ aasohaaniŋ ɗingiŋ bayaali teɗohsee ooy leeŋ eɗfiɗ ndengiɗ ambsohuuɗ na ooy bulo na ruumind eɗfiɗ na ruumind coy, wa haɓɗuusa findi borode'oh keeh-keeh na borode'ohe. Hutiiniŋ ridooni nikee saangal ndaŋkiyaah, njooliini nikka suung yatuus findi angiiniŋ haf-piis ciŋ ɗingiŋ bayaali. ");
INSERT INTO sav_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ridooni toksan ŋ kumbin ci nikiis ci haɓɗohu moos ruumind, ci yipsan ŋ tufkohaaci nikiis ciŋ ca nam haɓɗohu moos ruumind ; korohaaci na ñoor ci nikee haalis, haf ciŋ kumbin ci uluusa na haalis. ");
INSERT INTO sav_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tatohaaci amban Genohaani ŋ kehƴi na ciŋ ɗingiŋ bayaali jen, nikee moos ruumind. ");
INSERT INTO sav_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","In cii ceɗ kaɗ ŋ haɓɗuukiŋ Genohaani hooliɗi, ɗiski atoh ci fiisohu Ambtiɗohiŋ Kooh ɗaaku, findi Musaa nakohee wa. Ɓi ɓaah ŋ cuuɓiŋ Lewi ɓeɗ taambkohee kindi ; Itamaar kuɓkiŋ Aaruna seeƴkiɗohi, a yi adgohee ɓa. ");
INSERT INTO sav_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ɓoyi haɓiɗ in ci Nikiɗi nakee Musaa jen, a Betsalel, kuɓkiŋ Uri, yi setiŋ Hur, a ɓaahee ŋ cuuɓiŋ Yudaa. ");
INSERT INTO sav_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiyaab kuɓkiŋ Ahisamaak yi ɓaah ŋ cuuɓiŋ Daan, a yi ɓaatɗohee ɗe. A ƴaar herñiɗ ŋ pesit atoh moɗiɗ na fer in moɗiɗ te a miniɗ moɗsin lool na piis bulo na ruumind eɗfiɗ na ruumind coy, na leeŋ eɗfiɗ ndengiɗ. ");
INSERT INTO sav_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Wi Ɗiski Hooliɗi haɓɗasse, ini kaɗ ngaŋ urus jen te e Israayel ci eɗoha, wa kilo urus teemet-yasna-kaahay na kilo ndaŋkiyaah-yasna-kanak na yasna-kanak (877), na garam teemet-kaahay (300), ca ɓeesu ŋ ɓeesohaacaŋ Ɗiska Hooliɗa. ");
INSERT INTO sav_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Haalsa ƴaar ca kindu eɗohee, wa kilo haalis junni-kaahay na kilo ndaŋkiyaah na yasna-kanak (3017), na garam teemet-yasna-kanak na ndaŋkiyaah-yatuus (750), ca ɓeesu ŋ ɓeesohaacaŋ Ɗiska Hooliɗa. ");
INSERT INTO sav_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Haf nu nga ɗah eɗohee garam haalis yatuus, ɓa ɓees ca ŋ ɓeesohaacaŋ Ɗiska Hooliɗa. Ƴaar nu raakeen kiis ndaŋkiyaah-kanak (20) kaɗta ɗafuk ŋ bindka ɗah, eɗohha, ɓa nikee ƴaar junni-teemet-yasna-yino na junni-kaahay na teemet-yatuus na ndaŋkiyaah-yatuus (603.550). ");
INSERT INTO sav_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kilo haalis junni-kaahay (3000) ceɗ naayɗu haɓɗoha tufkohaaci teemet ciŋ kumbin ciŋ Genohaani hooliɗi na kumbin ciŋ ridooni nik ŋ ɗooƴi. Yino nu nga ɗah haɓɗohuusa kilo haalis ndaŋkiyaah-kaahay (30). ");
INSERT INTO sav_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kilooci ndaŋkiyaah na yasna-kanak ci (17) tasee na garam teemet-yasna-kanak na ndaŋkiyaah-yatuus ci (750) haɓɗohuusa korohaaci, ulohuusa haf ciŋ kumbin ci, haɓɗohuusa ñoor ciŋ ridooci toku ŋ kumbin ci. ");
INSERT INTO sav_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Moosi Israayel ci eɗohee nikee kilo junni-kanak na kilo teemet na kilo ndaŋkiyaah-kanak na nikiis (2124). ");
INSERT INTO sav_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Weɗ moosi haɓɗohu tufkohaaci nik ŋ aasohaaniŋ Ɗiipi-na-Cohohse, na seeƴkohaani moosi na giryaasiŋ wa, na in ciŋ seeƴkohaani ; ");
INSERT INTO sav_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","weɗ nam haɓɗohu tufkohaaciŋ ɗingiŋ bayaali na ciŋ aasohaaniŋ wa, na tatohaaci amb Genohaani ŋ kehƴi na ci amb ɗingiŋ bayaali. ");
INSERT INTO sav_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ɓa ɓayya ooy bulo na ruumind eɗfiɗ na ruumind coy, ɓa haɓiɗta kulɓa hew, ci ɓekkassan wuu pangka ŋ Ɗiska Hooliɗa ; ɓa haɓɗiɗta Aaruna kulɓa hoolɗuuɗ wuu Kooh, findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ɓa teɗta efoodi na fiil urus ambsohuuɗ na leeŋ eɗfiɗ ndengiɗ na ooy bulo na ruumind eɗfiɗ na ruumind coy. ");
INSERT INTO sav_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ɓa ɓayya urus tiɓuuɗ, wa seeluusa fiil fiil. Ɓa ambsohhaa na ooy bulo na ruumind eɗfiɗ na ruumind coy na leeŋ eɗfiɗ, ɓa teɗtaa, wa nikka pangki feroh keeh-keeh panguk. ");
INSERT INTO sav_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ɓa suptiɗtaa ngalla kanak ŋ lecem ci ŋ ɗafki ne wa min ɓekku. ");
INSERT INTO sav_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Wa raakka tokɗukoha ŋ kinoh ki, wa na efoodi, ceɗ hunee, ca nikee piis yino findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ɓa ɓayya atoh peme kanak, pemeeni na woyse sooham. Ɓa ɓayya fiil urus, ɓa teɗiɗta ca ɗisik ci ca ɓeksan, ɓa fiissa tiik ciŋ kuɓuuci ƴaar ciŋ caac ɓa Israayel ŋ atoh ceem. Ca fiissee findi ñaas na ñaasohse. ");
INSERT INTO sav_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","A tummba ca ŋ ngallaaciŋ efoodi ne ca naandsohee cuuɓ ciŋ Israayel, findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ɓi feroh keeh-keeh haɓiɗta nafaani na hee nike ŋ fikiiri, ɓa haɓɗoha leeŋ eɗfiɗ ndengiɗ na fiil urus na ooy bulo na ruumind eɗfiɗ na ruumind coy, findi efoodi. ");
INSERT INTO sav_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Wa nikee kaare ne wa lemu kanak ɗah, ɓak nu nga ɗah nikka santimeetar ndaŋkiyaah-kanak na yatuus (25). ");
INSERT INTO sav_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Wa moɗsinuusa na raŋalɗoh atoh peme nikiis : raŋalɗohi koc raakee atoh ci moɗohngaan ci na woyse : odem, pitdaah, na baareket. ");
INSERT INTO sav_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Wi kanakɗoh raakka nopek na safiir na yaahalom. ");
INSERT INTO sav_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Wi kaahayɗoh raakka lesem na saboo na ahlamaa. ");
INSERT INTO sav_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Wi nikiisɗoh raakka tarsiis na sooham na yaspeeh. Peme nu nga ɗah teɗɗuusa ɗiski wa ɓeksan na fiil urus, wa ɓekuusa nga. ");
INSERT INTO sav_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tiik ciŋ kuɓuuci ƴaar ciŋ caac ɓa Israayel fiissee ŋ atoh ci ndaŋkiyaah na kanak ceem (12). Ca fiisuusa findi ñaas na ñaasohse. Peme nu nga ɗah, nikiɗta tiik cuuɓ yino. ");
INSERT INTO sav_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","18","Ɓa ɓayya ceen ci urus koceet ci teɗuuɗ ci, ci ambɗu ŋ ɓekohaaciŋ pemeeci kanak ci nik ŋ efoodi. Ɓa haɓɗiɗta ca koroha urus kanak haa kiñi ŋ koñ ciŋ nafaani ŋ ɗafki. Ɓa korra ceen ci ngaŋ kiñiiceem po nafaani minnda nik ŋ fikiiri. ");
INSERT INTO sav_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","20","Ɓa haɓɗissa koroha urus nikiis haa kiñi. Kanak ci, ɓekuusa ŋ koñ ciŋ nafaani ŋ kehƴi, ŋ ɓakiŋ ɗooƴi, ca laaleeɗa efoodi ; kanak ci tas ɓekuusa ŋ ngallaaciŋ efoodi ŋ kehƴi, ngaŋ fikiiri, ŋ sero ɗiski ca suptu, ŋ ɗafkiŋ tokɗukohaaniŋ kinoh ki. ");
INSERT INTO sav_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kiñiiciŋ nafaani na ciŋ efoodi tokɗohuusa na niy bulo. Ŋ ineem nafaani ammba ŋ tokɗukohaaniŋ kinoh ki, wa yoondɗi, wa rissa ŋ ɗafuk efoodi findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","A haɓiɗta kulɓaaki hutiɗi yakki hunan na efoodi, wa teɗohsee ooy bulo jen. ");
INSERT INTO sav_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Mbooh kiŋ wa nikee ŋ leerni, wa daamina'uusa po wa ndennga ne wa faarkuu. ");
INSERT INTO sav_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ɓa ɓayya ooy bulo na ruumind eɗfiɗ na ruumind coy na ooy leeŋ ndengiɗ, ɓa haɓiɗta rim garnaat, ɓa moɗsinohha ca kehƴiŋ kulɓaaki po wa willa. ");
INSERT INTO sav_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ɓa haɓiɗta ɓi joolooli urus koceet, ɓa ɗookka ca ŋ kehƴiŋ kulɓaaki po wa willa, ŋ harmban rim ciŋ garnaati ; ");
INSERT INTO sav_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ɓa haɓiɗta rim garnaat yino ɗah, ɓa ɗook joolooli yino po sereendiŋ kulɓaaki jen willa findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ɓa nammba teɗ ɓi kulɓa leeŋ wuu Aaruna na kuɓuuciŋ ɗe ; ");
INSERT INTO sav_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","na mbahne wuu seeƴkiɗohi yakki na ɓi mbahne wiiriis teɗohu leeŋ eɗfiɗ. Ɓa nammba ɓa haɓɗiɗ ɓi jata na leeŋ eɗfiɗ ndengiɗ. ");
INSERT INTO sav_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ɓa haɓiɗta seentur, wa moɗsinuusa na ooy leeŋ eɗfiɗ ndengiɗ na ooy bulo na ruumind eɗfiɗ na ruumind coy findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ɓa haɓiɗta tokkaah ŋ puk hoolɗuuɗ, wa nikee urus koceet, wa mandee na pos kidig. Woo kii fiisuusa nga an : \"Wuu Nikiɗi\", wa fiisuusa findi ñaas na ñaasohse. ");
INSERT INTO sav_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wa tokuusa na tokɗoha bulo ŋ fikiiriŋ mbahneeri, findi Nikiɗi nakohee wa Musaa. ");
INSERT INTO sav_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Panguk ciŋ Genohaani, weɗ Ɗiipi-na-Cohohse, reehoh haɓɗu ɗaa. Israayel ci haɓiɗta pangka jen findi Nikiɗi nakohee wa Musaa jok. ");
INSERT INTO sav_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Musaa komuusa Genohaani, ɗiipi na in ci haɓɗohuu wa jen : Korohaaci, kaadar ci, laat ci, kumbin ci na tufkohaaci ; ");
INSERT INTO sav_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na baasi haɓɗohu und kuy mbaal suupuuɗ ruumind, na wi haɓɗohu und inoh cookom, na ridooni ɗasɗan Ɗiski Hoolohngaani ; ");
INSERT INTO sav_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na Wahndeeni na teeɓohe Ambtiɗohi na ndooɗ ci ɓayohsana, na kunohaani, weɗ ɗiski na romkohse ; ");
INSERT INTO sav_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na taaɓli, na tumohaaci hun naa jen, na mbuuruuci degsan nga, wuu Kooh ; ");
INSERT INTO sav_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na degohaaniŋ laampaaci urus koceeti, na laampaaciŋ wa taambtiɗohiɗ ci, na in ci hun naa ; na diwliini fuuɗoha laampaaci ; ");
INSERT INTO sav_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na keesi seeƴkohaani suusohsan cuuraay ci, wi ursi ; na diwi na hoolɗohse, na cuuraayi eeñɗohaani, na ridooniŋ aasohaaniŋ ɗiipi ; ");
INSERT INTO sav_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na keesi seeƴkohaani dohohsan hoosuuɗ ci, wi moosi ; na giryaasiŋ wa nam haɓɗohu moos ruumind, na ndooɗ ci wa na ɓayohse, na tumohaaci hun naa jen ; na beñwaari na hee tumohse masmi ɓoktukohsan na degohaaniŋ wa ; ");
INSERT INTO sav_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na piis ciŋ ɗingiŋ bayaali na kumbin ciŋ wa, na tufkohaaciŋ ca ; na ridooniŋ aasohaaniŋ bayaali, na niy ciŋ wa na tatohaaciŋ wa ; na tumohaaci pangkohsan ŋ Genohaani, weɗ Ɗiipi-na-Cohohse ; ");
INSERT INTO sav_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na kulɓaaci hoolɗuuɗ ci pangkohsan ŋ Ɗiski Hooliɗi, ca nikka ciŋ Aaruna seeƴkiɗohi, na ciŋ kuɓuuciŋ ɗe ne ɓa pangkee findi seeƴkiɗoh ɗah. ");
INSERT INTO sav_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israayel ci haɓɗeen pangkeem jen findi Nikiɗi nakohee wa Musaa jok. ");
INSERT INTO sav_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musaa marakka pangka ɓa haɓiɗ jen, wa nikka findi Nikiɗi nakohee ɗe wa jok, Musaa barke'iɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Nikiɗi woosa Musaa ne : ");
INSERT INTO sav_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","« Mbehi koc ŋ caɓni koc, fu hey yipe Genohaani, weɗ Ɗiipi-na-Cohohse. ");
INSERT INTO sav_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Fu ɓay Wahndeeni ɗaak in ci na teeɓohe Ambtiɗohi, fu ɓeka ŋ ɗooƴi, fu ɗasiɗa na ridooni saɓsohaani. ");
INSERT INTO sav_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Fu ɓay taaɓli, fu deg in ci na degse nga. Fu ɓay degohaaniŋ laampaaci, fu deg laampaaci ŋ ɗafuk wa. ");
INSERT INTO sav_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Fu ɓay seeƴkohaani haɓɗohu urus, suusoha cuuraayi, fu dega ŋ fiki Wahndeeniŋ Ambtiɗohi ndo fu reyan ridooni saɓsohaani ɗah. Fu nam ɓek ridooniŋ aasohaaniŋ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Fu deg seeƴkohaani na dohohse hoosuuɗ ci ŋ aasohaaniŋ Genohaani, Ɗiipi-na-Cohohse. ");
INSERT INTO sav_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Fu deg beñwaari na ɓoktukohse ŋ harmban ɗiipi na seeƴkohaani, fu tuma masuɓ. ");
INSERT INTO sav_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Fu yip ɗingiŋ bayaali wil Genohaani jen, fu ɓek rido ŋ aasohaaniŋ wa. ");
INSERT INTO sav_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Fu ɓay diwi na hoolɗohse hoolɗuuɗ ci wuu Kooh, fu yiif ŋ Genohaani na in ci nik ŋ ɗooƴi jen. Fu hoolɗohana ɗaa na tumohaaci hun naa jen, jaar wa nik in hooliɗ wuu so. ");
INSERT INTO sav_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Fu nama yiif ŋ seeƴkohaani na dohohse hoosuuɗ ci na tumohaaci hun naa jen, fu hoolɗoha ɗaa, jaar seeƴkohaani nik in ye hoolan wuu so. ");
INSERT INTO sav_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Fu nam yiif diwi ŋ ɗafuk beñwaari na ɓoktukohse na degohaaniŋ wa, fu hooliɗa wuu so. ");
INSERT INTO sav_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Fu ɓay Aaruna na kuɓuuciŋ ɗe po ŋ aasohaaniŋ ɗiipi, fu ɓook ɓa na masmi. ");
INSERT INTO sav_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Fu ɓekiɗ Aaruna kulɓaaci hoolɗuuɗ ci wuu so, fu yiif ɗe diwi, fu hoolɗoh ɗe ɗaa ne a pangkiɗee so findi seeƴkiɗoh. ");
INSERT INTO sav_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Fu ɓeeɗuk kuɓuuciŋ ɗe ƴaar ci, ɓa reɓ, fu ɓekiɗ ɓa kulɓaaciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Fu yiif ɓa diwi findi baab ɓa, ɓa hool wuu so, ne ɓa pangkiɗee so findi seeƴkiɗoh. Ineem hey tahe po, ɓeɗ na ɓi rimkohan nga ɓa nikan seeƴkiɗoh po faw. » ");
INSERT INTO sav_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musaa haɓiɗta ina Nikiɗi nakee ɗe jok, a haɓiɗta ca jen. ");
INSERT INTO sav_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","A yippa Genohaani ŋ mbehi koc ŋ caɓni koc ŋ kiis ki kanakɗoh ŋ pulohaŋ ɓa Misra. ");
INSERT INTO sav_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musaa tufkiɗta Genohaani ; a ɓekka tufkohaaci, a tufkiɗta kaadar ci, a ɓekka laat ci, a yippa kumbin ci. ");
INSERT INTO sav_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","A degga ɗiipi ŋ ɗafuk Genohaani, a uloha ɗiipi baas findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Musaa ɓayya atoh ciŋ Ambtiɗohi, a ɓekka ca ŋ Wahndeeni, a ɓekka ndooɗ ci na ɓayohsee wa, a ranngaa na kunohaaniŋ wa, ɗiski na romkohse. ");
INSERT INTO sav_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A ɓekka Wahndeeni ŋ Genohaani, a ɓekka ridooni saɓsohaani ne wa ɗasiɗ Wahndeeni findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","A ɓekka taaɓli ŋ ɗooƴ Ɗiipi-na-Cohohse, ŋ ɓaki ñaahmi ne fu eɗ pulohaaɗ-noh finho, fu aasee ɗah, ndo fu reyan ridooni ɗah. ");
INSERT INTO sav_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A degga mbuuruuci ŋ ɗafki, ŋ fiki Nikiɗi, findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A ɓekka degohaaniŋ laampaaci ŋ ɗooƴ ɗiipi, wa yurhiɗkohha na taaɓli, ŋ ɓaki singi. ");
INSERT INTO sav_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A degga laampaaci ŋ ɗafkiŋ wa, ŋ fiki Nikiɗi, findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","A ɓekka seeƴkohaani ursi ŋ ɗooƴ ɗiipi, ŋ sero ridooni saɓsohaani, ndo fu reyan nga ɗah. ");
INSERT INTO sav_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A suussa cuuraay ŋ ɗafuk wa findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","A ɓekka ridooniŋ aasohaaniŋ Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A degga seeƴkohaani na dohohse hoosuuɗ ci ŋ sero aasohaaniŋ Genohaani, weɗ Ɗiipi-na-Cohohse. A seeƴkohha ɗoopaat nga, a dohha ɗe po a hoommba, a nammba eɗoh ɓi pees findi Nikiɗi nakohee ɗe wa. ");
INSERT INTO sav_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A degga beñwaari ŋ harmban ɗiipi na seeƴkohaani ; a tummbaa masuɓ ɓooksukoha. ");
INSERT INTO sav_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musaa na Aaruna na kuɓuuciŋ Aaruna ɓookka yaah ciŋ ɓa nga na kot ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ŋ ineem mbaɗna ɓa hee aase ŋ Ɗiipi-na-Cohohse wala ɓa reɓee seeƴkohaani ɗah, ɓa ɓook yaah na kot findi Nikiɗi nakoha Musaa. ");
INSERT INTO sav_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","A tufkiɗta ɗingiŋ bayaali, wa willa Genohaani na seeƴkohaani. A ɓekka ridooni ŋ aasohaaniŋ ɗingiŋ bayaali. Musaa reehɗoh pangki ɗaa. ");
INSERT INTO sav_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Waɗ eel ɗuuku uloh Ɗiipi-na-Cohohse, yaki Nikiɗi yak riiffaa, weɗ wi Genohaani. ");
INSERT INTO sav_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ŋ ineem Musaa mineeɗi aas nga sagu eeliŋ ɗuukri ulee wa na riifi wa riifee na yaki Nikiɗi yak. ");
INSERT INTO sav_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ini kooɗoh ndii, ŋ ɗooƴ yongsiɗkohiŋ ɓa jen, Israayel ci meeɗ ɗof ne ɓa coot mbeh nu eeliŋ ɗuukri kuruk ŋ Genohaani, wa tiimba ɗah. ");
INSERT INTO sav_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Waaye eeli ɗofɗi ɗah, ɓa na kaɗeeɗi po mbaɗna wa kurkan. ");
INSERT INTO sav_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Israayel ci jen meeɗ hot nga, noh reesa ɗah, eeliŋ Nikiɗi nik ŋ ɗafuk Genohaani ; wek reesa ɗah, yongkaah gile. Wa nikohee ɗaa ŋ yongsiɗkohiŋ ɓa jen.");
INSERT INTO sav_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Yunus, a nikee kuɓu Amitay. Raakka mbeh, Nikiɗi woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","« Kaɗa win-win Niniw, kur ka yakka, looƴkaa ɓa ne aƴaarkaŋ ɓa reyiɗ nga so. » ");
INSERT INTO sav_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Waaye Yunus taambohha ndeem a saandohha Tarsis, ne a fus Nikiɗi. A reesa ŋ Joppa, a raakka nga batoona na kaɗe Tarsis, a wirinnda, a aassa na ɓi ɓo' ŋ batoona na hee ɓa coottohe nga ne a min ki us Nikiɗi. ");
INSERT INTO sav_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Waaye, wa ɓa nik ŋ ɗooƴ cookma, Nikiɗi fuuɗissa ŋ ɗafuk cookma puuɗis ayrukiɗ, pahul yakak yoppa cookma po batoona waaɗeeɗa ɓaltukoh. ");
INSERT INTO sav_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ɓooɓa ambohee batoona neƴƴohha ; yaa nik nga ɓa looƴukka tiikaŋ koohaŋ ɗe, ɓa aammba unung caŋ ɓa ŋ cookma ne ɓa eɗfiɗ batoona. Raakka waam Yunus ruhsiɗ ngaŋ tasaŋ batoona ; a nikee faankiɗ, a neeheeɗa pani nooɗiɗ. ");
INSERT INTO sav_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ƴaara adgiɗee amboh ca reɓpa ɗe, woosa ɗe ne : « Fu neehang ye ? Kurka, koolɗa hooso po ŋ koohiŋ ɗa ! Wa miniɗ raak Kooh liiɓsiɗoh ɓoo po ɓoo sooƴuu. » ");
INSERT INTO sav_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ŋ ndeem, ɓa woytiɗohha an : « Ɓoo markiskaat ŋ petaaw ci, ɓoo marak miskiɗi rahas ɓoo puloh nga ɓa. » Ɓa markisukka, petaaw ca teeɓohha Yunus. ");
INSERT INTO sav_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ɓa woyissa ɗe ne : « Teeɓa ɓoo ɓoyi ɓek ɓoo inii ! Fu na haɓɗe ye ? Fu kurkoh nde ? Kur ɗu teeku na ? Fu ɓaah ngaŋ winde cuuɓ ? » ");
INSERT INTO sav_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","A loffa ɓa ne : « Ŋ Heber, Nikiɗi, a yi mi na yakɗe, Kooh ŋ ɗafki, yi fer cookmi na kehƴi. » ");
INSERT INTO sav_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Wa ɓa kerah woo kaŋ ɗe, amboh ca neƴƴohha, ɓa tummba ɗe ne : « Fu haɓiɗ ye an ? » Ɓa inheen ɓal ne a na saandohe fusoha Nikiɗi laam a naandsukeen ɓa wa. ");
INSERT INTO sav_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ɓa meekissa ɗe ne : « Ɓoo na hee na tumtiɗohe na ɗa po cookmi yeeɓuk ? » Laam raak cookma koolɗukeeɗa koolɗuk. ");
INSERT INTO sav_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","A loffa ɓa an : « Meeɓaat to ɗu biir ro ŋ cookmi, ɗah cookmi hey yeeɓke. Laam ŋ inhiɗa, wa nga so findi wa taamboh po pahuli ayrukiɗii bipukka ŋ ɗafuk ɗu. » ");
INSERT INTO sav_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Joy ne ɓa tum ini a woo, amboh ca joowwa ne ɓa teer ŋ tefsa, waaye ŋ ɓarang ɓarang, laam cookma nikee uupeeɗa ɓa uup ayruk. ");
INSERT INTO sav_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ŋ ineem, ɓa kiimmba Nikiɗi ne : « Cey ! Nikiɗi, kana ɓoo ap sagu ƴaarii ! Te kan ɓoo yamb kakaan ɓo' yurhiɗ. Laam a yaf, Nikiɗi, tum findi wa neɓoh ɗa. » ");
INSERT INTO sav_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ɓa jaarra, ɓa meeɓpa Yunus, ɓa njaffa ɗe ŋ cookma, cookma hannda seemiɗ ɗuuɗaŋ wa. ");
INSERT INTO sav_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ɓooɓa neƴƴohha ŋ Nikiɗi ; ɓa seeƴkiɗta ɗe, ɓa giñiɗta ɗe ne ɓa hey ɗe tumɗe in, ɓa cooteeɗa. ");
INSERT INTO sav_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yunus, ŋ tasaŋ ɗe ŋ ɗooƴ cookma, Nikiɗi kerhiɗ ɗe. A tummba po cuurund duu'in pulla a onnda ɗe. Yunus nikka ngaŋ rookaŋ cuurnda neeh kaahay na wek kaahay. ");
INSERT INTO sav_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ngaŋ ɗooƴ rookaŋ cuurnda a kiimmba Nikiɗi, Koohiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","A woosa ne : « Wa ŋ nikoh ngaŋ mbugala, ŋ looƴkiɗ po ngaŋ Nikiɗi, te a tahsiɗ to ; ŋ ɗooƴ oon caŋ Jaanim, ŋ leehkiɗ, fu kerhiɗ hoosooriŋ ngo. ");
INSERT INTO sav_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Fu juleen ndo ngaŋ nooɗ-nooɗa, ŋ ɗooƴ cookma, te masma wileen ndo. Ginaah caŋ ɗa jen na wal-wal ca mburfuñeen ndo. ");
INSERT INTO sav_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Mi nak ŋ woyee ne : “ Fu aañiɗ to, fu waaɗisɗi so deg has. ” Hondohɗi ŋ ambiɗ ne ŋ hey hotisse Kahnaŋ ɗa Hoolɗa. ");
INSERT INTO sav_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Masuɓ ca goɗeen mbooh kiŋ ngo, nooɗaŋ masma wileen ndo. Paangi-cookom duluurkeen hafiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ngaŋ tasaŋ tangooca ŋ ruhseen, ŋ rangseen po faw ngaŋ kur caŋ fiɗaaf ca, ŋ ɓak ɓooɓa ɗeɓgaan. Waaye fu tumiɗ po kipes kiŋ ngo pulla ruy-ruya, Nikiɗi, Koohiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Wa maa waaɗe ñak kiñin, ŋ haltuk ɗa, Nikiɗi te fu kerhiɗ kiimaŋ ngo ŋ Kahnaŋ ɗa Hoolɗa. ");
INSERT INTO sav_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ɓi na taambkohe ɓonaah ci, ɓa na fañe muuɗiŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Mi, faan ndo, ngaŋ ɓi hooso jangtuk, ŋ hey ɗa seeƴke ɓi hoosuuɗ. Ini ŋ giñ, ŋ heya reytine. A Nikiɗi naafohi. » ");
INSERT INTO sav_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Nikiɗi woossa cuurnda, cuurnda hukka Yunus ŋ sereendaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Wa a pul ŋ cuurnda, Nikiɗi kanakɗukka woo Yunus ne : ");
INSERT INTO sav_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","« Kaɗa win-win Niniw, kur ka yakka. Kataa ɓa ini ŋ woo ɗa. » ");
INSERT INTO sav_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yunus gooñukka, kaɗta Niniw findi Nikiɗi woyoha. Niniw nikee kur yakoh na yakoh, a neeh kaahay onan ɓo' a tiinda ɓak po ɓak. ");
INSERT INTO sav_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Wa a kaɗ po a aassa Niniw, a hooɓukka wil nga. A huflukka ɓi Niniw na hoosoocii : « Tasiɗ neeh ndaŋkiyaah-nikiis (40), Niniw ɗumbu ! » ");
INSERT INTO sav_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Wa ɓi Niniw kerah woo keem, ɓa kossa Kooh ; ɓa katohha or, ɓa ɓekukka ɓi daah, ambohha ŋ ya uup yak po ŋ ya uup ƴin. ");
INSERT INTO sav_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Wa woo ka ree ŋ nofaŋ buuraŋ Niniw, a kurukka ngaŋ ɓoofohaanaŋ ɗe, a wolukka lipkohaaɗaŋ ɗe, a ɓekukka daah, a baffa ŋ wet, ");
INSERT INTO sav_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","a woosohha ŋ ɗooƴ kur ka jen ne : « Buur na yakak ci sangohiɗ ɓooɓi na ɗoopaat ci, yakak na ƴin, ne ɓa kanaat ñam, ɓa kanaat an masuɓ, ");
INSERT INTO sav_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","yaa nu nga ɗah, ɓekkaat daah. Ɓi hooso meeɓuuɗ koolɗu, po ngaŋ Kooh, te yaa nu nik suungɗuk tiindohaaɗiŋ ɗe sepƴiɗi, na tumohaaɗ ci otiɗ ciŋ yaah ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Yaa inah andi Kooh ɓoƴsanɗi liiɓohaaɗ, andi inwaaso ambanɗi ɗe, andi a heyɗi dokne paa finho dohɗiŋ aay-keeñiŋ ɗe, po ɓoo sooƴuu ? » ");
INSERT INTO sav_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ŋ ineem, Kooh inhisohha in ca ɓa haɓɗe ne ɓa pul ngaŋ tiindohaaɗ ca moɗaaɗiicaŋ ɓa. Taambohha nga inwaaso ammba Kooh ŋ in ca a kooɗkiɗee ɓa, te a mirndohɗi ca raakiɗ. ");
INSERT INTO sav_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Wa Kooh ɗaas ɓi Niniw, wa neɓaaɗiisa Yunus lool, a ayrukka. ");
INSERT INTO sav_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","A woosa Nikiɗi : « Eey Nikiɗi, ina ŋ woyee wa ŋ nikoh ŋ kur ɓoo weɗi wii haa e ? E ineem tahee po ŋ ɗeɓgohha saandoh Tarsis ; ŋ inhangangeen ne, fu Koohi na baahohe, yi na yirmohe, yi yooɓɗi ayruk, yi riif na waaɗohaaɗ te inwaaso na ambee ɗa amb ŋ tum miskiɗ. ");
INSERT INTO sav_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Teemb ndii, Nikiɗi, ɓaya kiñin kiŋ ngo, laam nga so, ŋ kaan ngisoh ŋ pes. » ");
INSERT INTO sav_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Nikiɗi loffa : « Wi fu ayruk wii, fu nik ŋ kiyooh e ? » ");
INSERT INTO sav_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yunus pulla kur ka, a ɓooffa ŋ ɓak pulohaaɗ-noh ; a ɗiippa nga, a saangnukka nga a sekeeɗa ini na hee raake na kur ka. ");
INSERT INTO sav_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","A nikka nga po, Nikiɗi Kooh paariɗta kidig, wa njopukka Yunus ne wa saangin hafiŋ ɗe, tee ɗah wa naaf ɗe ŋ miskiɗiŋ ɗe. Keeñaŋ Yunus soosootta ngaŋ kidga. ");
INSERT INTO sav_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Hondohɗi, ngaŋ wiisaaɗiina, Kooh tummba cangind aassa kidga wa suyya. ");
INSERT INTO sav_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ɓaatta nga, wa noh pul, Kooh kurkiɗta mbooyo ; noha dammba hafaŋ Yunus po a minisɗi. A kiimmba kaan, a woosa ne : « Ŋ kaan ngisoh ŋ pes. » ");
INSERT INTO sav_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kooh meekissa Yunus : « Fu yii ŋ keeh weem oo, na ayruki ŋ ini na kidgii ? » A loffa : « Ee di' ! Ñam ɓur, ŋ ayruk po ŋ hee kaane. » ");
INSERT INTO sav_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Nikiɗi dokkissa ŋ woo ka : « Fu, kidgii miskiɗ ɗa. Nikɗi haa ne ya fu taambkoha, te ya fu hooɗiɗa haa. Wa paar na wek yino, wa leeɓpa na wek yino. ");
INSERT INTO sav_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Fu waaɗta ne mi, ŋ heeɗi miskasse ŋ ini hee rahse Niniw, kur ki yakki fu inah ne ɓo' junni-teemet na junni-ndaŋkiyaah-kanak (120.000) ɓii nga ɓi inhisohɗi yaah-ñaahum na yaah-sing, ɓaatta nga ɗoopaat ci minɗi reeh ! »");
INSERT INTO sav_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cii ceɗ tiik ciŋ caacuuciŋ Yeesu Kiristaa, setiŋ Dawuuda, setiŋ Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahiima a yi rim Isaahha, Isaahha rimmba Yaŋhooɓa, Yaŋhooɓa rimmba Yudaa na taambɗoh ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaa rimmba Seerah na Peeres, a rim ɓa na Tamaar. Peeres rimmba Hesroon, Hesroon rimmba Raam. ");
INSERT INTO sav_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raam rimmba Aminadaab, Aminadaab rimmba Nahson, Nahson rimmba Salmon. ");
INSERT INTO sav_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon rimmba Boos, a rim ɗe na Rahab, Boos rimmba Obed, a rim ɗe na Riit, Obed rimmba Yesay. ");
INSERT INTO sav_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesay rimmba Dawuuda buuri, Dawuuda rimmba Suleymaan, a rim ɗe na ɓiti Uri. ");
INSERT INTO sav_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaan rimmba Robowaam, Robowaam rimmba Abiya, Abiya rimmba Asaf. ");
INSERT INTO sav_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf rimmba Yosafat, Yosafat rimmba Yoram, Yoram rimmba Osiyas ");
INSERT INTO sav_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas rimmba Yotam, Yotam rimmba Ahas, Ahas rimmba Esekiyaas ");
INSERT INTO sav_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyaas rimmba Manasse, Manasse rimmba Amon, Amon rimmba Yosiyaas ");
INSERT INTO sav_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyaas rimmba Yekoñas na taambɗoh ciŋ ɗe ŋ jamanoona Israayel ci toorsee Babilon. ");
INSERT INTO sav_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ŋ finho tooruukaŋ ɓa Babilon, Yekoñas rimmba Salacel, Salacel rimmba Sorobabel ");
INSERT INTO sav_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel rimmba Abiyud, Abiyud rimmba Eliyakim, Eliyakim rimmba Asoor ");
INSERT INTO sav_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoor rimmba Sadok, Sadok rimmba Ahiim, Ahiim rimmba Eliyud ");
INSERT INTO sav_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud rimmba Eleyasaar, Eleyasaar rimmba Mattaan, Mattaan rimmba Yakob, ");
INSERT INTO sav_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob rimmba Suseef yi ƴaar Maryaama yi rim Yeesu, Yeesu yi na woyse Mucɗohi Gapohse. ");
INSERT INTO sav_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Fu marak ɗah, ca gomal ndaŋkiyaah na gomal nikiis (14) ŋ ini amboh ŋ Ibrahiima po ŋ Dawuuda. Ini nam kooɗoh ŋ Dawuuda po ŋ tooruukaŋ ɓooɓa ŋ Babilon ca gomal ndaŋkiyaah na gomal nikiis (14). Te ŋ tooruukaŋ ɓooɓa ŋ Babilon po ŋ Mucɗohi Gapohse ca gomal ndaŋkiyaah na gomal nikiis (14). ");
INSERT INTO sav_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ŋ ini kaɗ ŋ Yeesu Kiristaa, a raakohu an : Maryaama yi yaay ɓa, a Suseef nguɗee cakiim nga ɗe ; waaye bala a tokan ɗe ɗah, wa nikka ne a rook ŋ tumohaaɗ ciŋ Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Suseef yi fiir ce nikee ɓo' yurhiɗ. Ŋ ineem a waaɗɗi ɗe wiñ, a tufukka ne a reehiɗ harmban ɓa, ɓa daka ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wa a na liiɓsiɗohe ŋ ineem, malaaka Heɗ ɓoo teeɓukka ɗe ŋ heeƴ, woosa ɗe ne : « Suseef, setiŋ Dawuuda, kina neƴƴoh ɓay Maryaama ɓitiɓ, laam kuɓki nik ŋ rookiŋ ɗe a puloh ŋ Fuuɗsi Hoolohngaani. ");
INSERT INTO sav_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A hey raake kuɓu ƴaar, teekaa ɗe Yeesu laam a yi na hee mucɗe cuuɓiŋ ɗe ŋ bakaaɗ ciŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ineem raakohha ɗaa, ne woo kiŋ Heɗ ɓoo, wi a taambɗee ŋ nguɓ woosuuɗ, raak an : ");
INSERT INTO sav_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","« Cafƴi inahɗi ƴaar, hey ambe rook ; a raak kuɓu ƴaar, yi teeksan Emanuwel » wi tokis : \"Kooh yii na ɓoo\". ");
INSERT INTO sav_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wa Suseef yunuk, a haɓiɗta ini malaakaaniŋ Heɗ ɓoo nakee ɗe ; a ɓayya Maryaama ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Waaye a hunɗi na ɗe po findi yeem raakoh kuɓu ƴaar, a teekka ɗe Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeesu raakohu Betlehem ŋ kur kaŋ Yudee ŋ jamanoona Herod nikoh buur. Ɓi heɗ haf kurkohha pulohaaɗ-noh, ɓa hayya Yerusalem. ");
INSERT INTO sav_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ɓa meeksoheeɗa an : « A nde kuɓki han raaku, yi nikan buuriŋ Yawuut ci ? Ɓoo hotiɗ horiŋ ɗe ŋ pulohaaɗ-noh. Te ɓoo hay ne ɓoo ñaamuk ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wa Herod buuri kerah ineem, a feyuusa lool, a yi na ɓi Yerusalem jen. ");
INSERT INTO sav_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A cohɗohha kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa na jangɗohoh caŋ wa jen, a meekissa ɓa ɗiski Mucɗohi Gapohse joy rimohu. ");
INSERT INTO sav_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓa loffa ɗe ne : « A joy raakohu Betlehem ŋ Yudee ŋ ini woosuuɗi fiis wii : ");
INSERT INTO sav_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ Fu Betlehem ŋ kur kiŋ Yudee, fu ɓaahɗi muk ŋ ci uup ƴissuut ŋ kur ciŋ Yudee sagu pulohi kilifaani pulohan nga ɗa, kilifaani niiɗan cuuɓiŋ ngo Israayel. ” » ");
INSERT INTO sav_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod ɓeeɗukka heɗ haf ca, a ɗaayya na ɓa, ne ɓa teeɓ ɗe hooliɗ, jamanooni hora hotkoh. ");
INSERT INTO sav_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A tuuƴca ɓa Betlehem, a woosa ɓa ne : « Kaɗaat ɗu meeksoha kuɓki meeksoh hooliɗ, ɗu hot ɗe ɗah, ɗu woo so, ŋ nam ɗe kaɗ ñaamka. » ");
INSERT INTO sav_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wa heɗ haf ca sikɗuk buura po ƴutta, ɓa kaɗta. Hora ɓa hotee ŋ pulohaaɗ-noh pulissa, wa nikka ŋ fikiiɓa, wa kaɗeeɗa po wa tiimmba ɗiska kuɓka nik, wa tufukka. ");
INSERT INTO sav_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hora ɓa hotee, ɓa sumeen nga keeh-keeh po ɓa minisɗi. ");
INSERT INTO sav_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓa aassa ŋ kahna, ɓa hotta kuɓka na Maryaama yaay ɓa ; ɓa ƴekiɗta Yeesu, ɓa ñaamukka Yeesu. Ɓa puliɗta alala ɓa ɓayndohe, ɓa eɗta ɗe urus, cuuraay na miir. ");
INSERT INTO sav_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ƴutta Kooh teeɓpa ɓa ŋ heeƴ ne, ɓa haadee ɗah, ɓa kinaat taamb ŋ Herod. Ɓa kooɗta waas wiiriis, ɓa dokukka kur ɓa. ");
INSERT INTO sav_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wa heɗ haf ca coot, malaaka Heɗ ɓoo teeɓukka Suseef ŋ heeƴ, a woosa ɗe ne : « Suseef, Herod hey nakohe kuɓki waaku ne a ap ɗe, mbaa kurka fu ɓay kuɓki na yaay ɓa, fu saandoh Misra, fu nik nga po mbaɗna ŋ woyan na ɗa. » ");
INSERT INTO sav_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Suseef kurukka, a ɓayya kuɓka na yaay ɓa ŋ ɗooƴ weka, a kaɗta na ɓa Misra. ");
INSERT INTO sav_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ɓa nikka nga po Herod kaannda. Ŋ ineem, ina Heɗ ɓoo woyee raakka, woo ki a taambɗee ŋ nguɓ woosuuɗ an : « Ŋ ɓeeɗkiɗ kuɓkiŋ ngo ne a pul Misra. » ");
INSERT INTO sav_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wa Herod inah ne heɗ haf ca ñaañoh ɗe ñaañoh, a ayrukka lool. A tuuƴohha ŋ kur kaŋ Betlehem na ina wila ne komaakca ƴaar ca raak kiis kanak ruhussa jen, apsaat. A kindoha ŋ jamanoona heɗ haf ca woyee ɗe. ");
INSERT INTO sav_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wa nikohha ɗaa findi woosuuɗi Yeremi woyohee wa, an : ");
INSERT INTO sav_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","« Hooso kerhuuɗ ŋ kur ki na woyse Rama, ca fuɗ laayiɗ na rooy keeh-keeh. A Rasel na fuɗe komaakciŋ ɗe, ɓa kaaniɗ, weɗ tah a waaɗɗi giifɗu. » ");
INSERT INTO sav_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ŋ finho kakaan kaŋ Herod, malaaka Heɗ ɓoo teeɓukka Suseef ŋ heeƴ ŋ Misra, ");
INSERT INTO sav_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a woosa ɗe ne : « Kurka, fu ɓay kuɓki na yaay ɓa, ɗu dokuk Israayel, ɓooɓa waaɗee ɓay kiñin kiŋ ɗe ɓa kaaniɗ. » ");
INSERT INTO sav_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Suseef kurukka, a ɓayya kuɓka na yaay ɓa, a haadda Israayel. ");
INSERT INTO sav_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Waaye wa a kerah ne e Arkelawus namsiɗ baab ɓa Herod ŋ hafaŋ kur kaŋ Yudee, a neƴƴohha kaɗ nga. Heɗ ɓoo woytohha ɗe ŋ heeƴ, ŋ ineem, a kaɗta Galile, ");
INSERT INTO sav_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","a gennda nga, ŋ kur ka na woyse Nasareet. Ina woosuuɗ ci woyee raakka, ne Mucɗohi Gapohse ɓeeɗkohsan ƴaariŋ ɓi Nasareet. ");
INSERT INTO sav_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ŋ kiis caam, Yahya Ɓoktohi hotukka ŋ nduufaŋ Yudee, a yegɗoheeɗa woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A woyeeɗa ne : « Ɓoƴsohaat pesohaaɗ, Nguuriŋ-Ɗafki reɓiɗ. » ");
INSERT INTO sav_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yahya Ɓoktohi a yi woosuuɗi Esayi woyee an : « Hooso wa ɗaa leehuk ŋ nduufa an : “ Paɗaat waasiŋ Heɗ ɓoo, haɓɗiɗaat ɗe waas ci, ca yurah ! ” » ");
INSERT INTO sav_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahya meeɗ ɓekuk kulɓa haɓɗohuuɗ find ngeelemb, a toka ŋ kinoh kiŋ ɗe na und. A pesohee paƴ na yeeleel kuum. ");
INSERT INTO sav_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓooɓa genee Yerusalem, na ɓaŋ Yudee, na ɓaŋ ɓakaŋ Yurdan jen, hayeeɗa nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓa teyɗukeeɗa bakaaɗ caŋ ɓa, a ɓokteeɗa ɓa ŋ kalaŋ Yurdan. ");
INSERT INTO sav_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wa a hot ne ɓo' laayiɗ ɓaah ŋ ɓooɓi na woyse Farisen na Sadusen nikee hayeeɗa nga ɗe ne ɓa ɓoktu, a woosa ɓa ne : « Ini ɗu añaand haa ne iiñ jen, ɗu liiɓiɗ ne ɗu miniɗ penduk ayrukiŋ Kooh wi na haye e ? ");
INSERT INTO sav_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tumohaaɗ ciŋ ɗu baahaat, wa teeɓoh ne ɗu ɓoƴsohiɗ pesohaaɗ. ");
INSERT INTO sav_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te kinaat ɗaar rek ɗu woyee ŋ ɗooƴ ɗu ne : “ Ɓoo rimkoh ŋ Ibrahiima. ” Ñam na woyee ɗu ne, atoh cii, Kooh miniɗ pulɗiɗ Ibrahiima kuɓu nga ca. ");
INSERT INTO sav_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kiw ki ƴutiɗ ne wa giing tas kidig, te waa nu raakɗi rim baahiɗ ɗah, wa hey ƴoɓse, wa njafu ŋ yongkaaha. ");
INSERT INTO sav_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi na ɓoktee ɗu ŋ masuɓ ne ɗu ɓoƴsoh pesohaaɗ. Waaye raakiɗ ɓoyi na haye ŋ finhooso, a yi uup po fuuf, te woliɗ ɗe ñafaɗ ciŋ ɗe joombiɗ to. A yi, a ɓoktohan ɗu Fuuɗsi Hoolohngaani na yongkaah. ");
INSERT INTO sav_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A amb saliŋ ɗe ŋ yaah, ne a nistoh pees na fuñind. A nangɗoh pees ciŋ ɗe ŋ ndap, a doh fuñndi ŋ yongkaahi heyɗi ƴime. » ");
INSERT INTO sav_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ŋ neeh caam, Yeesu pulohha Galile, a kaɗta kalaŋ Yurdan ŋ Yahya Ɓoktohi ne yeem ɓokit ɗe. ");
INSERT INTO sav_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Waaye Yahya teyɗukɗi, woosa ɗe ne : « Ñam etoh ɓoktuk nga ɗa, fu hayee nga so ! » ");
INSERT INTO sav_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu loffa ɗe ne : « Ɗiski wa nik, faɗa wa nikoh an. Wa in moɗiɗ ne ɓoo mitɗoh ini Kooh nakoh jen an ! » Ŋ ineem Yahya teyɗukka. ");
INSERT INTO sav_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wa Yeesu ɓoktu po a pulla masma, jaarra Eel ci rangsukka, a hotta Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh yipkeeɗa nga ɗe findi banuut. ");
INSERT INTO sav_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hooso kerhukka ŋ Eel ci an : « Yii, a yi Kuɓkiŋ ngo ŋ waaɗ keeh-keeh, yi neɓ po ŋ keeñ. » ");
INSERT INTO sav_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ŋ ineem, Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh ɓayya Yeesu ŋ nduufa, ne Seytaani jaɗiɗ ɗe fiir. ");
INSERT INTO sav_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A orra noh ndaŋkiyaah-nikiis (40) na wek ndaŋkiyaah-nikiis (40) ; ŋ mirndaani a aɗukka. ");
INSERT INTO sav_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seytaani, yi na jaɗɗohe fiir, reɓpa woosa ɗe ne : « Nik ne fu Kuɓkiŋ Kooh ɗah, woya atoh cii, ca ɓoƴsuk mbuuru. » ");
INSERT INTO sav_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeesu loffa ɗe ne : « Fiis ci Hooliɗ ci woyiɗ ne : “ Ɓo' na pesohe mbuuru dong haa, waaye na woo nu nik ne wa puloh ŋ nguɓiŋ Kooh ɗah. ” » ");
INSERT INTO sav_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Seytaani ɓayya ɗe Yerusalem, ŋ jol Kahnaŋ Kooh ; ");
INSERT INTO sav_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a woosa ɗe ne : « Nik ne fu Kuɓkiŋ Kooh ɗah, faɗsuka ŋ kehƴi. Fiis ci Hooliɗ ci woyiɗ ne : “ Kooh hey nake malaakaaciŋ ɗe, ca ɓay ɗa ŋ yaah ciŋ ca po kot ciŋ ɗa laɓkanɗi ŋ atoh. ” » ");
INSERT INTO sav_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu loffa ɗe ne : « Fiis ci namiɗ woo ne : “ Fu joyɗi markisuk Heɗ ɓoo, Koohiŋ ɗa. ” » ");
INSERT INTO sav_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seytaani rapɗissa ɗe ŋ jol tango njooloh na njooloh. A teeɓpa ɗe nguur ciŋ adinaani jen na yaki ca yak. ");
INSERT INTO sav_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A woosa ɗe ne : « In cii jen, fu ƴekiɗ to ne fu ñaamuk ko ɗah, ŋ hey ɗa ca one. » ");
INSERT INTO sav_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeesu loffa ɗe ne : « Seytaani, us so ! Fiis ci woyiɗ ne : “ Ƴekɗa Kooh Heɗ fu, te fu ñaamuk a yi dong. ” » ");
INSERT INTO sav_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Weɗ Seytaani faɗoh ɗe ndaam, jaarra malaakaaca hayya, taambkoheeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ŋ jamanoonaam, Yahya Ɓoktohi ambseen ŋ kasoona ; wa Yeesu keraha, a kaɗta Galile. ");
INSERT INTO sav_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A kurkohha Nasareet a kaɗta gena ŋ Kapernawum ŋ sero cookma, ŋ kehƴaŋ cuuɓ ciŋ Sabuloon na Naftaali. ");
INSERT INTO sav_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaarra ini woosuuɗi Esayi woyee raakka, an : ");
INSERT INTO sav_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","« Kehƴiŋ Sabuloon na Naftaali, wa nikka yaah-cookmi, ŋ ɓakiŋ Yurdan winoori, weɗ Galile, kur kiŋ ɓooɓi nikɗi Yawuut, ");
INSERT INTO sav_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","cuuɓi ɓoofee ŋ ñuusi hotiɗ siñaar yakak, te ɓi ɓoofee ŋ kur ki kakaan ki ñuusiɗ, siñaar hayiɗ nga ɓa. » ");
INSERT INTO sav_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ini amboh ndeem, Yeesu cammba woytoh ɓooɓa ŋ ini kaɗ ŋ waas Kooh an : « Ɓoƴsohaat pesohaaɗ, Nguuriŋ-Ɗafki reɓiɗ. » ");
INSERT INTO sav_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wa raakka mbeh, Yeesu tiindeeɗa ŋ sereendaŋ Cookmaŋ-Galile, a hotta seeɓoh kanak mbaaleeɗa cuurund ŋ cookma, ɓa nikee Simong yi na woyse Piyeer na taambɗoh ce Andare. ");
INSERT INTO sav_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A woosa ɓa ne : « Ñaakɗaat to, ŋ hey ɗu tume seeɓoh ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɓa jaarra faɗ mbaal caŋ ɓa ndaam, ɓa ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A kaɗissa ƴissuut, a hotissa taambɗoh kanak, Saak na Saaŋ, kuɓuuciŋ Sebede, a raak ɓa ŋ gaala na baab ɓa, ɓa haɓiɗtineeɗa mbaal caŋ ɓa. A ɓeeɗukka ɓa ne ɓa hun na ɗe. ");
INSERT INTO sav_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɓa jaarra faɗ gaala na baab ɓa, ɓa ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu wileeɗa Galile jen a jangɗoheeɗa ŋ sinaagog ca, a woyeeɗa Yegɗohiŋ Muci, wi kaɗ ŋ Nguuriŋ-Ɗafki, a wirɗeeɗa kosaay ca na ɓeenduk ca jen, ca ambee ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Laamtohiŋ tiikiŋ ɗe willa kur kaŋ Siri jen. A komuusa ɓooɓa raakee miskiɗ jen sagu kosaay ca ambee ɓa, kosaay nu wa min nik ɗah, ɓa jiini ambe, ɓa raakee kombeɗ-mbeɗ na ɓa lafñe, a wiriɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mboolo laayiɗ ñaakiɗta ɗe, ɓooɓeem pulohee Galile, Dekapool, Yerusalem, Yudee, na ɓaka faahaŋ Yurdan. ");
INSERT INTO sav_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wa Yeesu hot mboolnda, a rappa ŋ tangoora, a ɓooffa nga. Taalubeeciŋ ɗe reɓpa nga ɗe, ");
INSERT INTO sav_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","a jangɗeeɗa ɓa in cii an : ");
INSERT INTO sav_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","« Ɓa neɓɗiɗ, ɓooɓi ruhsiɗ haf ciŋ ɓa, ɓa inahha ne ɓa etohiɗ Kooh, laam Nguuriŋ-Ɗafki wa wuu ɓa. ");
INSERT INTO sav_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɓa neɓɗiɗ, ɓooɓi na fuɗe, laam ɓa hey giifɗasse. ");
INSERT INTO sav_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɓa neɓɗiɗ, ɓooɓi soosiɗ ci, laam ɓeɗ eɗsan kehƴi. ");
INSERT INTO sav_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɓa neɓɗiɗ, ɓooɓi aɗuk, sifaɗukka kipes yurhiɗ, laam ɓa hey hiƴe, ɓa kap nding. ");
INSERT INTO sav_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɓa neɓɗiɗ, ɓooɓi na yirmohe, laam Kooh hey ɓa yirme. ");
INSERT INTO sav_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɓa neɓɗiɗ, ɓooɓi raak keeñ hooliɗ, laam ɓa hey hote Kooh. ");
INSERT INTO sav_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓa neɓɗiɗ, ɓooɓi na waake jam ŋ harmban ɓooɓi, laam ɓa hey ɓeeɗkohse kuɓu Kooh. ");
INSERT INTO sav_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɓa neɓɗiɗ, ɓooɓi na mbugalse sagu yurhi ɓa yurah, laam Nguuriŋ-Ɗafki wa wuu ɓa. ");
INSERT INTO sav_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ɗu neɓɗiɗ, ne ɓooɓi ɓasee ɗu, ɓa mbugalee ɗu, ɓa leyɗohee ɗu na woo moɗaaɗi'iɗ nu nik saguuso ɗah. ");
INSERT INTO sav_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sumaat keeh-keeh, laam aafi na sekee ɗu ŋ ɗafka yakiɗ, te ɗu inah ne ɓa mbugalohee woosuuɗ ci adug ɗu ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","E ɗu meɗaamiŋ Adina. Waaye meɗa kaɗ po wa jemisɗi ɗah, wa min jemɗohissu na ye ? Wa na raakisseeɗi etoh ɗal, wa mbetu, ɓooɓi dakee nga. ");
INSERT INTO sav_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","E ɗu siñaariŋ adinaani, kur ki nik ŋ jol tango, wa minɗi ɗembɗu. ");
INSERT INTO sav_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te ali ɓo' na fuuɗeeɗi laampa ne a kuna na kanoh, a degana kay ŋ degohaaniŋ wa ne wa ñiiniɗ ɓi tuuƴi jen. ");
INSERT INTO sav_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Siñaariŋ ɗu joy ñiinoh ɗaa ŋ fiki ɓooɓi, ne ɓa hot tumohaaɗ ciŋ ɗu baahiɗ ci, ɓa yakiɗ Kooh Baabiŋ ɗu yi nik ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kinaat liiɓ ne ŋ hay ne ŋ nihis waasiŋMusaa wala woo ciŋ woosuuɗ ci, ŋ hayɗi ne ŋ nihis ca, waaye ŋ hay ne ŋ tum in ci ɓa woo po ca mit. ");
INSERT INTO sav_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ñam na woyee ɗu wa te wa keeh. Feeh kehƴi na eel ci kurukɗi nga ɗah, ali in nihsukanɗi ŋ waasi po mbaɗna wa mitan. Wa fiisi uup ƴissuut nga haa, wa tap haa. ");
INSERT INTO sav_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Weɗ tah po ɓo' nu taambiɗɗi wi uup ƴissuut ŋ nakoh ci te a woyee ɓooɓi ne ɓa joyɗaa taambiɗ ɗah, a hey nike yi uup ƴissuut ŋ Nguuriŋ-Ɗafki. Waaye ɓo' nu taambiɗ ca te a jangɗee ɓooɓi ne ɓa taambiɗ ca ɗah, a hey yake ngaŋ Nguuriŋ-Ɗafki. ");
INSERT INTO sav_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ñam na woyee ɗu wa, ɗu uupɗi yurah jangɗohoh ciŋ waasi na Farisen ci ɗah, ɗu aasanɗi ŋ Nguuriŋ-Ɗafki. ");
INSERT INTO sav_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ɗu kerhiɗ ne ɓooɓa ɗeɓgaan woysee ne : “ Kina ap ɓo' ; ɓo' nu apoh ɗah, a hey atte'se. ” ");
INSERT INTO sav_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Waaye mi na woyee ɗu ne, ɓo' nu ayruk ɓaah ce ɗah, a hey atte'se. Te ɓo' nu woo ɓaah ce ne : “ Hafiŋ ɗa riifɗi ” ɗah, a hey ɓayse ŋ atte'oh ciŋ waasi. Te ɓo' nu woo ɓaah ce ne : “ Fu dof ” ɗah, a hey ɓekse ŋ yongkaaha yakka. ");
INSERT INTO sav_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ŋ ineem, fu ɓayee ini fu eɗoh wuu Kooh ŋ seeƴkohaana, fu naandsuk ne ɓaah fu ambɗiɗ ɗa in ɗah, ");
INSERT INTO sav_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","faɗaa ŋ fiki seeƴkohaana, fu kaɗ kerhiɗoha na ɗe po ƴut, fu hana hay dege. ");
INSERT INTO sav_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ara kerhiɗoh na ɓoyi, ne a ɓayee ɗa waas ɗah. Fu tumɗaa ŋ waasi po ɗu ree ngelohaana ɗah, a hey ɗa ɓaye ŋ atte'ohi, yeem eɗ ɗa alkaateeni, fu ɗaaku ŋ kasoona. ");
INSERT INTO sav_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ñam na woyee ɗa wa te wa keeh, fu pulohanɗi ndaam feeh fu wirindɗi po ŋ darmi uup ƴissuut ɗah. ");
INSERT INTO sav_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ɗu kerhiɗ ne wa woyuuɗ ne : “ Fu njaaloo'anɗi. ” ");
INSERT INTO sav_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Waaye mi na woyee ɗu ne, ɓo' nu marak ɓitiɓ, a hemem ɗe ɗah, a njaaloo'iɗ na ɗe ŋ ɗooƴ ce po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hasiŋ ɗa ñaahmi waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nihsaa fu mbeta ; cir yino nihsuk ŋ faaniŋ ɗa, weɗ ngisoh wa jen, wa mbetu ŋ yongkaaha yakka. ");
INSERT INTO sav_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yaahiŋ ɗa ñaahmi waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nguɗaa jameet fu mbeta ; cir yino nihsuk ŋ faaniŋ ɗa, weɗ ngisoh wa jen, wa kaɗ ŋ yongkaaha. ");
INSERT INTO sav_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Wa namiɗ woyuuɗ ne : “ Ɓo' nu faɗ ɓitiice ɗah, a eɗaat ɗe kayti teeɓoha. ” ");
INSERT INTO sav_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Waaye e ñam na woyee ɗu ne, ƴaar nu saɓsukoh na ɓitiice te nikɗi ne yeem njaaloo njaaloo ɗah, a yi ɓek ɗe ŋ njaaloo. Te ɓo' nu ɓay ɓitiɓ faɗuuɗ ɗah, a njaaloo'iɗ. ");
INSERT INTO sav_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ɗu namiɗ kerah ne ɓooɓa ɗeɓgaan woysee ne : “ Fu giñ in ɗah, kinaa nik tumaaɗi. In nu fu giñiɗ Heɗ ɓoo ɗah, tumaa. ” ");
INSERT INTO sav_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Waaye mi na woyee ɗu ne, kinaat giñ delem. Kinaat giñ ŋ ɗafki, laam ɓoofohaaniŋ Kooh, yi buur waa nga. ");
INSERT INTO sav_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kinaat giñ ŋ kehƴi, wa degoha kot ciŋ ɗe. Kinaat giñ ŋ Yerusalem, wa kur kiŋ Kooh, yi Buuri yakki. ");
INSERT INTO sav_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Te hafiŋ ɗa, kina giñ nga laam fu minɗi yaanwiɗ, fu minɗi suussiɗ find yino nga. ");
INSERT INTO sav_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɗu woo \"ee\" ɗah, wa nikaat \"ee\" ; ɗu woo \"a'aa\" ɗah, wa nikaat \"a'aa\". In nu ɗu deg nga ɗah, wa puloh Seytaani. ");
INSERT INTO sav_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ɗu kerhiɗ ne wa woyuuɗ ne : “ Has, e has na wirndee wa ; sis, e sis na wirndee wa. ” ");
INSERT INTO sav_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Waaye mi na woyee ɗu ne, kinaat wirndiɗkoh na ɓoyi na tumee ɗu in miskiɗ. Ɓo' laɓ ɗa paɗ ŋ kaɓaaɓ ñaahum ɗah, eɗaa ɗe wi tas. ");
INSERT INTO sav_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te ɓo' waaɗ ɗa ɓay waas ne a naaf kulɓaakiŋ ɗa ƴini ɗah, nama ɗe eɗ paltooniŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɓo' tiindɗukoh ɗa ŋ doole kilomeet yino ɗah, tiinda na ɗe kanak. ");
INSERT INTO sav_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɓo' kiim ɗa ɗah, onaa ɗe te kina sang ɓand ɓoyi na ɓandukee ɗa. ");
INSERT INTO sav_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ɗu kerhiɗ ne wa woyuuɗ ne : “ Waaɗa morom fu, fu sang ɓoyi sang ɗa. ” ");
INSERT INTO sav_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Waaye mi na woyee ɗu ne, waaɗaat ɓooɓi sang ɗu, ɗu kiimɗee ɓooɓi na torhiɗee ɗu in baahiɗ. ");
INSERT INTO sav_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ŋ ndeem, ɗu hey teeɓohe ne ɗu kuɓuuciŋ Baabiŋ ɗu yi nik ŋ Eel ci, laam a na pulɗe puliɗ nohiŋ ɗe ŋ añaandiɗ ci na baahiɗ ci, a na toɓɗe toɓiɗ yurhiɗ ci na yurhaaɗiici. ");
INSERT INTO sav_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Moo, ɗu waaɗ ɓooɓi waaɗ ɗu dong ɗah, ɗu car ye aafaah ŋ ineem ? Juuti'oh ci sah na tumohe ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te ɗu kañɗee ɓaah ciŋ ɗu dong ɗah, ɗu haɓiɗ ye ini haɓɗohuuɗi ? Ɓooɓi kosɗi Kooh sah na tumohee ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kon kinaat raak sikka findi Baabiŋ ɗu yi nik ŋ ɗafki raakohɗi sikka. ");
INSERT INTO sav_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wortukaat, kinaat teeɓoh kiyurhiŋ ɗu ŋ fiki ɓooɓi ne ɓa hot ɗu, ɗu tuma ɗah, ɗu rahsanɗi aafiŋ Baabiŋ ɗu yi nik ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te fu onee ñakiɗ ci ɗah, kina tip haan ne ɓooɓi hot ɗa ; findi naafeehaaci na tumohee wa ŋ ɗooƴ sinaagog ci na ɗisik ci mbeeddaaci coh ne ɓa waak tiik. Ñam na woyee ɗu wa te wa keeh, ɓa rahsiɗ aafiŋ ɓa po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Waaye fu sarhohee ɗah, yaahiŋ ɗa singi kinaat inah ini yaahiŋ ɗa ñaahmi na haɓɗe, ");
INSERT INTO sav_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ne sarhiŋ ɗa nik ini ɗemb, te Baab ɗu, yi na hote ŋ ini ɗemb, hey ɗa aafe. ");
INSERT INTO sav_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ɗu kiimee Kooh ɗah, kinaat mand na naafeehaaci, ɓi inah ne ɓa kiimee Kooh ɗah, ɓa na waaɗe tufuk ŋ ɗooƴ sinaagog ci na ɗisik ci mbeeddaaci coh, ne ɓa teeɓ ɓooɓi jen ne ɓii kiim Kooh. Ñam na woyee ɗu wa te wa keeh, ɓa rahsiɗ aafiŋ ɓa po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Waaye fu, fu kiimee Kooh ɗah, aasa ŋ ɗooƴ tuuƴ fu, fu rang yahndeeri, fu kiim Baab ɗu, yi nik ŋ ɗiski ɗemb, yi na hote ŋ ɗiski ɗemb, a hey ɗa aafe. ");
INSERT INTO sav_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Te ɗu kiimee Kooh ɗah, kinaat amb ŋ woo yino, ɗu woyee wa, ɗu woyissee wa findi ɓooɓi inahɗi Kooh ; ɓa liiɓ ne e woo kiŋ ɓa laayɗi weɗ na hee ɓa tahe teyɗukɗu. ");
INSERT INTO sav_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kinaat mand na ɓa, laam Baabiŋ ɗu inhiɗ ini ɗu etoh bala ɗu kiiman ɗe ɗah. ");
INSERT INTO sav_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Weɗ tah kiimohaat Kooh an : Baabiŋ ɓoo yi ŋ Eel ci, tiikiŋ ɗa teyɗuksaat ne wa tiik hooliɗ. ");
INSERT INTO sav_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nguuriŋ ɗa hayaat. Ini fu waaɗ raakaat ŋ kehƴi findi wa raakoh ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ona ɓoo kañam ki ɓoo etoh woti. ");
INSERT INTO sav_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɗaasa ɓoo ɗal ci ɓoo na ɗalee ɗa findi ɓoo na ɗaasohe ɓi na ɗale ɓoo. ");
INSERT INTO sav_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te kina tum po ɓoo jaɗɗu fiir. Waaye mucɗa ɓoo ŋ yi baahaaɗi. Ya fu Heɗ Nguur, na hatil na kiyak po faw, Amiin. ");
INSERT INTO sav_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Inhaat ne ɗu ɗaas ɓooɓi na tumee ɗu in moɗaaɗi ɗah, Baabiŋ ɗu yi nik ŋ ɗafki hey ɗu namee ɗaas tumohaaɗ ciŋ ɗu moɗaaɗiici ; ");
INSERT INTO sav_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","waaye ɗu ɗaasɗi ɓooɓi ɗah, a heyɗi ɗu namee ɗaas. ");
INSERT INTO sav_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ɗu oree ɗah, kinaat teeɓ ɓooɓi ne ɗu na haɓɗe in miskiɗ, findi naafeehaaci na tumohee wa. Ɓa oreesa ɗah, ɓa ñuusiɗ fikiiciŋ ɓa ne ɓa teeɓ ɓooɓi jen ne ɓa oriɗ. Ñam na woyee ɗu wa te wa keeh, ɓa rahsiɗ aafiŋ ɓa po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Waaye fu, fu oree ɗah, muktuka, fu laackoloñuk, ");
INSERT INTO sav_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ne fu teeɓuu ɓooɓi ne fu na ore, waaye Baab ɗu yi nik ŋ ɗiski ɗemb, yi na hote ŋ ɗiski ɗemb, a hey ɗa aafe. ");
INSERT INTO sav_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kinaat nangɗoh raak-raak ŋ Adina, ɗiski inah ne ñuhuk miniɗa yahroh wala wa hoy, wala rokoh ci ngul, ɓa aas, ɓa roka. ");
INSERT INTO sav_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Waaye nangɗohaat raak-raak ŋ Eel ci, ɗiska fu inah ne ñuhuk minɗaa yahroh, wa hoyanɗi te rokoh minɗi ngul, a aas ne a roka. ");
INSERT INTO sav_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Inhaat ne ɗiski raak-raakiŋ ɗa nik, keeñiŋ ɗa na name nik nga. ");
INSERT INTO sav_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Has weɗ laampaaniŋ faan. Hasiŋ ɗa wir ɗah, faaniŋ ɗa jen nikan ŋ siñaar. ");
INSERT INTO sav_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Waaye hasiŋ ɗa wirɗi ɗah, faaniŋ ɗa jen nikan ŋ ñuus. Te ñiini nik nga ɗa jen nik ñuus ɗah, ñuuseem nikan taruus ! ");
INSERT INTO sav_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ɓo' yino minɗi raak heɗ kanak, mbaa a hey waaɗe yino a sang yi tas, wala a ŋoɗ ŋ yii, a heef yi tas ; kon ɗu minɗi ñaamuk Kooh, ɗu ñaamkee raak-raak. ");
INSERT INTO sav_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Weɗ tah mi na woyee ɗu ne : Kinaat jaahiɗ ŋ kipes kiŋ ɗu, ŋ ini ɗu ñaman na ini ɗu anan. Kinaat jaahiɗ ŋ faan ciŋ ɗu, ŋ ini ɗu ɓekkan. Kipes uupiɗɗi kañam njiriñ e ? Te faan namɗi uupiɗ ɓekkaah njiriñ e ? ");
INSERT INTO sav_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Markaat sel ci, ca na sokeeɗi, ca na nguɗeeɗi ; te ca raakɗi ndap ɗaakkoha, waaye Baabiŋ ɗu yi nik ŋ Eel ci yii ñamiɗ ca. Ɗu uupiɗɗi ca njiriñ e ? ");
INSERT INTO sav_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ya ɓa min jaahiɗ nga ɗu, po a ɓaat wahtu yino ŋ kipes kiŋ ɗe ? ");
INSERT INTO sav_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wa ye tah ɗu jaahɗe book ŋ ini ɗu ɓekkan ? Markaat paangfiŋ yohon ci na pos ciŋ ca findi ca na kifsohe. Wa na pangkeeɗi, wa na teɗeeɗi. ");
INSERT INTO sav_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Moona mi na woyee ɗu ne Suleymaan, na raak-raakaŋ ɗe jen, a moosɗi ɓekkoh mand na yino nga ca. ");
INSERT INTO sav_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kooh ɓekɗe paangfiŋ yohon ci ɓekuk hend an moɗ woti te kim waa kee ɓeksa ŋ yongkaah ɗah ; kon wa leeriɗ ne Kooh hey ɗu name ɓekiɗ. Kosi ɗu kos ƴissuutiɗ ! ");
INSERT INTO sav_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mbaa kinaat jaahiɗ ɗu woyee ne : “ Ɓoo na hee ye ñame ? Ɓoo anan ye ? Ɓoo ɓekkan ye ? ” ");
INSERT INTO sav_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","In ceem jen, e ɓooɓi inahɗi Kooh ɓeɗ na gene ŋ waakiŋ ca, waaye Baabiŋ ɗu yi nik ŋ ɗafki inhiɗ ne ɗu etohiɗ ca. ");
INSERT INTO sav_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Waakaat ini na kaɗɗe fiki Nguuriŋ ɗe na kiyurhiŋ ɗe paaɗ, a hey ɗu ca one, a ɓaatiɗ ɗu cinooci jen nga. ");
INSERT INTO sav_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kinaat jaahiɗ ŋ ini raakan kim, kim na kimaŋ wa, mbeh nu nik ɗah miskiɗ ci nik nga doyiɗa. ");
INSERT INTO sav_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kinaat markoh ɓo' in, mbaa ɗu heyɗi markohse in. ");
INSERT INTO sav_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Laam findi ɗu na atte'ohe, Kooh atte'ohan ɗu ɗaa te ɓeesohaani ɗu na ɓeesɗohohe, weɗ ɗu ɓeesɗohsan. ");
INSERT INTO sav_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wa ye tah fu markee ɓoli ŋ hasiŋ morom fu, te wa ndooɗ yakak nik ŋ hasiŋ ɗa ? ");
INSERT INTO sav_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wala fu min na woyoh morom fu ne : “ Faɗa ŋ nihsiɗ ɗa ɓoli ŋ hasiŋ ɗa ”, te ndooɗi yakki weɗɗi ŋ hasiŋ ɗa ? ");
INSERT INTO sav_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naafeehaani, koca nihis ndooɗi yakki nik ŋ hasiŋ ɗa. Fu min hot baahiɗ ne fu nihsiɗ morom fu ɓoli nik ŋ hasiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kinaat eɗ ɓuu ci in ci hoolɗu wuu Kooh bala ca wiirkan nga ɗu, ca faarsoh ɗu, te kinaat njaf per ciŋ ɗu ŋ kot ciŋ mbaam-huk ci bala ca daksohan ca. ");
INSERT INTO sav_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kiimaat, ɗu hey onse ; waakaat, ɗu hey hote ; laɓɗaat, ɗu hey rangsiɗasse. ");
INSERT INTO sav_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Laam ɓo' nu kiim ɗah, a hey onse, ɓo' nu waak ɗah, a hey hote, te ɓo' nu laɓiɗ ɗah, a hey rangsiɗasse. ");
INSERT INTO sav_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ya ɓa nga ɗu a yi kuɓkiŋ ɗe kiiman ɗe mbuuru, a on ɗe atoh ? ");
INSERT INTO sav_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wala a kiim ɗe cuurund, a on ɗe iiñ ? ");
INSERT INTO sav_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nik ne ɗu ɓi baahaaɗiici, e ɗu min on kuɓuuciŋ ɗu in baahiɗ ɗah, ŋ woyisɗi ɗa Baabiŋ ɗu yi ŋ Eel ci, a onanɗi in baahiɗ ɓi na kiimee ɗe wa e ? ");
INSERT INTO sav_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kon, in ci ɗu waaɗ ne ɓooɓi haɓɗiɗ ɗu ca jen, tumɗaat ɓa ca. Ineem weɗ waasiŋMusaa nakoh na woosuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Aasohaat yahndeeri ɓengiɗi laam yahndeeri angiɗi na ɓayohe ŋ boom te waasiŋ wa yooɓpa ; laayiɗ na aasohe nga. ");
INSERT INTO sav_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Waaye yahndeeri na ɓayohe ŋ kipes ki, wa ɓengiɗ, waasiŋ wa sewwa te ɓi hota laayɗi. ");
INSERT INTO sav_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Wortukaat ɓooɓi na tume haf ɓa woosuuɗ, ŋ ɗooƴiŋ ɓa, ɓa ɓaakoɓ saahiɗ. Waaye ɓa haye nga ɗu ɗah, ɓa na haye soosiɗ findi mbaal. ");
INSERT INTO sav_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ɗu na hee ɓa inhisohe in ci pesohaaɗ ciŋ ɓa na rime. Reseñ miniɗ ɓeenohu ŋ ñaaɓaaɓ e ? Wala ndun miniɗ ɓeenohu ŋ ñalkook ? ");
INSERT INTO sav_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kidig nu baah ɗah, wa na raake rim baahiɗ. Waaye kidig nu baahɗi ɗah, na raake rim baahaaɗi. ");
INSERT INTO sav_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kidig baahiɗ minɗi raak rim baahaaɗi te kidig baahaaɗi minɗi raak rim baahiɗ. ");
INSERT INTO sav_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kidig nu raakɗi rim baahiɗ ɗah, wa na ƴoɓse ƴoɓu, wa njafu ŋ yongkaah. ");
INSERT INTO sav_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mbaa ɗu na hee ɓa inhisohe in ci pesohaaɗ ciŋ ɓa na rime. ");
INSERT INTO sav_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","E ɓooɓi na ɓeeɗkohee so : “ Heɗ ɓoo, Heɗ ɓoo ” jen ɓeɗ na hee aase ŋ Nguuriŋ-Ɗafki haa, waaye a ɓi na haɓɗe waaɗ-waaɗiŋ Baabiŋ ngo yi nik ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɓi ɓo' laayiɗ hey yo woye mbaɗi ne : “ Heɗ ɓoo Heɗ ɓoo, ɓoo meeɗ yegɗoh woo kiŋ Kooh ŋ tiikiŋ ɗa haa e ? Ɓoo aañiɗ jiiniici ŋ tiikiŋ ɗa te ɓoo haɓɗiɗ keemaan laayiɗ ŋ tiikiŋ ɗa. ” ");
INSERT INTO sav_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ŋ ineem, ŋ hey ɓa woye ne : “ Ŋ moosɗi ɗu inhoh, usaat to ɗu ɓi na haɓɗe ini lahɗi waas. ” ");
INSERT INTO sav_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Weɗ tah ɓoyi na sikɗuke woo kiŋ ngo wii, a pesohee wa, a mandan na ƴaar ñaañiɗ yi taɓah kahan ce ŋ ɗafuk atoh ; ");
INSERT INTO sav_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","toɓi keennda, huluɓ ci nupɗeeɗa, puuɗsi puuɗseeɗa, ca tapukka kahneem, waaye wa keenɗi sagu ini wa taɓahu ŋ ɗafuk atoh. ");
INSERT INTO sav_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Waaye ɓoyi na sikɗuke woo kiŋ ngo te a pesohuu wa, a mandan na ƴaar naandiɗ yi taɓah kahan ce ŋ ɗafuk beeñ ; ");
INSERT INTO sav_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","toɓi keennda, huluɓ ci nupɗeeɗa, puuɗsi puuɗseeɗa, ca tapukka kahneem, wa keennda, wa yahrukohha jameet. » ");
INSERT INTO sav_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wa Yeesu ƴut woo woo ceem, mboolnda jen feyuusa ŋ jangɗohiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jangɗohaaɗaŋ ɗe ɗaloheen na findi jangɗohoh caŋ waasiŋ Musaa na tumohe, laam a woyee keeh-keeh findi kilifa. ");
INSERT INTO sav_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wa Yeesu ruhsee tangoora, mboolo laayiɗ ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wa raakeen ƴaar, a kosaayee kosaay ki na oɓse faan, a hayya ŋ Yeesu, a ƴekka ŋ fikiice, a kiimmba ɗe ne : « Kilifaani, fu waaɗa ɗah, fu miniɗ to saɓsoh na kosaay kii po ŋ nik ɓo' hooliɗ. » ");
INSERT INTO sav_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu raɗissa yaah, laalla ɗe, woosa ɗe ne : « Ŋ waaɗiɗa, nika ɓo' hooliɗ. » Jaarra kosaay ka hoolla nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ƴutta Yeesu woosa ɗe ne : « Wortukaa wa woo ali ɓo' waaye kaɗa fu teeɓa haf fu seeƴkiɗoha, fu haɓiɗ seeƴki waasiŋMusaa nakoh ; wa teeɓoh ne fu wiriɗ. » ");
INSERT INTO sav_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeesu a yi kaɗoh po a aassa kur kaŋ Kapernawum, weɗi ƴaar ɓaah ŋ ɓa adgohee soldaar caŋ Rom reɓoh nga ɗe, kiimmba ɗe keeh-keeh ");
INSERT INTO sav_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","an : « Kilifaani, ñaamaŋ ngo yaa faanukka ŋ kahna, cir ciŋ faaniŋ ɗe ceɗ lafañ a yaa sayeeɗa say. » ");
INSERT INTO sav_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu loffa ɗe ne : « Ŋ hey ɗe hee wirɗe. » ");
INSERT INTO sav_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ƴaara adgohee soldaar ca loffa ne : « Kilifaani, ŋ yeyyooɗi fu aas ŋ kahan ndo ; woya woo rek ñaamaŋ ngo hey wire ! ");
INSERT INTO sav_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Laam mi ŋ haf fo, raakiɗ ɓooɓi adgoh ho te ŋ namiɗ raak soldaar ci ŋ adgoh ; yaa nu ŋ woo ne : “ Kaɗa ” ɗah, a kaɗ, yaa nu ŋ woo ne : “ Haya ” ɗah, a hay. Te in nu ŋ woo ñaamiŋ ngo ne a haɓɗaata ɗah, a haɓiɗa. » ");
INSERT INTO sav_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wa Yeesu kerah woo keem, a feyuusa, a woosa ɓa ñaakɗee ɗe ne : « Ñam na woyee ɗu wa te wa keeh : Ŋ hotɗi ali ɓo' kosiɗ kosii ngaŋ Israayel jen ! ");
INSERT INTO sav_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ñam na woyee ɗu wa, ɓo' laayiɗ hey pulohe ŋ ɓak ci jen, ɓa ɓoof na Ibrahiima, Isaahha na Yaŋhooɓa, ɓa ñamee kañam ka yakka ŋ Nguuraŋ ɗafka. ");
INSERT INTO sav_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waaye ɓi joyee aas ŋ Nguuri, hey njafse ŋ ñuusaŋ hara, ɗiska fuɗ na ɗoɓɗoh sis raak. » ");
INSERT INTO sav_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ƴutta Yeesu woosa ƴaara adgohee soldaar ca ne : « Kaɗa, wa raakohaat ɗaa findi fu kosoha. » Te ŋ jamanoonaam jok, surgaanaŋ ɗe wirra. ");
INSERT INTO sav_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wa Yeesu kurkoh ndaam, a kaɗta kahan ɓi Piyeer, wa a ree, a tel yaayiŋ ɓiti Piyeer jiriɗ po faankiɗ, a faaniŋ ɗe weɗ dohe. ");
INSERT INTO sav_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeesu laalla yaahiŋ ɗe, dohɗaŋ faana saɓsukohha na ɗe ; jaarra a kurukka a taambkoheeɗa Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wa niina ree, a komuusa ɓo' laayiɗ ɓa jiini ambe. A aannja jiiniica na woo kiŋ ɗe, a wiriɗta kosaayiɗ ca ɓinooɓa jen. ");
INSERT INTO sav_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ina woosuuɗi Esayi woyee wii raakka : « A kooɗiɗ in ci ɓoo miskasse, a degukka kosaay ciŋ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wa Yeesu hot mboolnda ndeeree ɗe, a woosa taalubeeciŋ ɗe ne ɓa kaɗ ɓaka faahaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Weɗi ƴaar ɓaah ŋ jangɗohoh caŋ waasiŋ Musaa hayoh nga ɗe woosa ɗe ne : « Jangɗohohi, ɗisik nu fu kaɗ ɗah, ŋ hey ɗa ñaakɗe. » ");
INSERT INTO sav_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu loffa ɗe ne : « Ɓaakoɓ ci raakiɗ nung, sel ci raakiɗ taar, waaye Kuɓkiŋ ɓoyi raakɗi sah ɗiski a na hee iɗsiɗkohe. » ");
INSERT INTO sav_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ƴaar wiiriis ŋ taalubeeciŋ ɗe woosa ɗe ne : « Kilifaani, on ndo paaɗ, ŋ taambkoh yaɓkooriŋ ngo po a kaan, ŋ uumb ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu loffa ɗe ne : « Ñaakiɗ to te fu faɗ kaaniɗ ci ɓa uumb kaaniɗ ciŋ ɓa. » ");
INSERT INTO sav_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wa Yeesu ƴut woo na ɓa, a aassa ŋ gaal, taalubeeciŋ ɗe ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ŋ cookma, ɗekka po puuɗis yakak raakka ɓa nga po ginaah ca riifɗeeɗa gaala, wa raak Yeesu neeheeɗa. ");
INSERT INTO sav_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Taalubeeci reɓpa nga ɗe, ɓa yunnda ɗe na leehuk an : « Kilifaani, mucɗa ɓoo, ɓoo ɓii kaan ! » ");
INSERT INTO sav_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A woosa ɓa ne : « Kosi ɗu kos ƴissuutiɗ, wa ye tah ɗu neek ? » Weɗ a kurkoh, a ngassa puuɗsa na cookma, ɗiska eennda teɗ. ");
INSERT INTO sav_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓa feyuusa, ɓa woyeeɗa ne : « Ƴaarii, a ɓo' ye po puuɗsi na cookmi sah kerhiɗee ɗe ? » ");
INSERT INTO sav_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wa Yeesu na taalubeeciŋ ɗe ree ɓaka faahaŋ Cookmaŋ-Galile, ŋ kur caŋ Gadareen ca, ƴaar kanak ɓa fu inah ne ca jiini ambee ɓa, ɓa pulohha ɗiska ɓa nikee ŋ ruy-ruy ca, ɓa kaɗta coha na ɗe. Ɓa nikee añaandoh na añaandoh, ali ɓo' meeɗɗi kaañ taamb ndeem. ");
INSERT INTO sav_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓa leehkeeɗa an : « Fu waaɗ ɓoo ye tum Kuɓkiŋ Kooh ? Fu hay ne fu torhiɗ ɓoo bala jamanooniŋ wa reyan e ? » ");
INSERT INTO sav_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Raak gat mbaam-huk yakak ñameeɗa ŋ ndaam, wa usoheen na ɓa ƴissuut. ");
INSERT INTO sav_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jiiniica kiimmba Yeesu keeh-keeh an : « Ɓoo inhiɗ ne fu hey ɓoo aañe, ona ɓoo, ɓoo aas ŋ gataŋ mbaam-huk ceen. » ");
INSERT INTO sav_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A woosa ca ne : « Kaɗaat ! » Weɗ ca puloh ŋ ƴaaɓa, ca aassa ŋ mbaam ca. Gata jen giirukka, hunnda na mbartala, faɗsukka ŋ cookma, mbaam ca kaannda ŋ masma. ");
INSERT INTO sav_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɓooɓa niiɗee ca nuppa, kaɗta woya ini raak jen ŋ kur-taaha, na ini rahas ƴaaɓa jiiniica ambe. ");
INSERT INTO sav_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɓooɓaŋ kur-taaha jen pulla, hayya ŋ Yeesu ; wa ɓa hot ɗe, ɓa kiimmba ɗe keeh-keeh ne a pulaat kur caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wa Yeesu kurkoh ndaam, a aassa gaal a huussa cookma, a kaɗta Kapernawum, kur ɓa. ");
INSERT INTO sav_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ŋ ndaam, a komuusa ƴaar lafñiɗ faanuuɗ ŋ faankoha. Yeesu hotta findi ɓooɓa kosoh, a woosa lafñiɗa ne : « Ndengɗuka ƴaariŋ ngo ! Fu ɗaasuuɗ bakaaɗ ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋ woo keem, ɓi ɓo' ɓaah ŋ jangɗohoh caŋ waasiŋMusaa woyeeɗa ŋ harmban ɓa ne : « Ƴaarii na ɗale Kooh ! » ");
INSERT INTO sav_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeesu inheen liiɓ ciŋ ɓa, a woosa ɓa ne : « Wa ye tah ɗu raakka liiɓohaaɗ ci moɗaaɗiiceem ? ");
INSERT INTO sav_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ŋ woo ɗe ne “ Fu ɗaasuuɗ bakaaɗ ciŋ ɗa ”, wala “ Kurka fu tiind. ” A winde uup yooɓ ? ");
INSERT INTO sav_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ɗu hey inhe woti ne Kuɓkiŋ ɓoyi raakiɗ min-min ɗaasoha bakaaɗ ŋ kehƴi. » Weɗ a woyoh ƴaara kosaayɗa ne : « Kurka, ɓaya faankohaaniŋ ɗa, fu haad. » ");
INSERT INTO sav_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ƴaara kurukka, haadda kahan ce. ");
INSERT INTO sav_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wa mboolnda hot ineem, ɓa feyuusa, ɓa yakɗeeɗa Kooh yi on ɓo' ci min-mineem. ");
INSERT INTO sav_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeesu kurkohha ndaam, wa a kaɗe, a hotta ƴaar teeku Macce ɓoofiɗ ŋ ɗiska a na juuti'ohe. A woosa ɗe ne : « Ñaakiɗ to. » Macce kurukka, ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ŋ finho ineem, Yeesu ñameeɗa ŋ kahan Macce, juuti'oh laayiɗ na ɓi bakaaɗoh laayiɗ hayya ne ɓa ñam na ɗe, a yi na taalubeeciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wa Farisen ca hot ineem, ɓa woosa taalubeeciŋ ɗe ne : « Wa ye tah jangɗohohiŋ ɗu ñamee na juuti'oh ci na bakaaɗoh ci ɓinooɓi ? » ");
INSERT INTO sav_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesu kerahha ɓa, a woosa ɓa ne : « Ɓooɓi kosaayɗi etohɗi paƴoh, e kosaayiɗ ci etoh paƴoh. ");
INSERT INTO sav_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jangaat ini Fiis ci woo wii : “ Ŋ waaɗ ne ɗu teeɓoh baah kiŋ ɗu ŋ ɓinooɓi, weɗ ngisoh ɗu seeƴkee wuu so. ” Laam ŋ hayɗi ne ŋ ɓeeɗuk yurhiɗ ci waaye ŋ hay ne ŋ ɓeeɗuk bakaaɗoh ci. » ");
INSERT INTO sav_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋ ineem taalubeeciŋ Yahya Ɓoktohi hayya ŋ Yeesu, meekissa ɗe ne : « Wa ye tah taalubeeciŋ ɗa na oreeɗi te ɓoo na Farisen ci ɓoo na ore or ? » ");
INSERT INTO sav_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A loffa ɓa ne : « Hanheeci hay ŋ kilook miniɗ nik ŋ neɓaaɗi te heɗ kilooki yii na ɓa e ? Waaye wa hey raake jamano, heɗ kilooki kooɗohu nga ɓa ; ŋ ndeem, ɓa hey ore. ");
INSERT INTO sav_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ali ɓo' na daafeeɗi kulɓa maañiɗ na seeket as, mbaa seeketi hey nookɗohe kulɓaaki, kulɓaaki uup nga faaruk. ");
INSERT INTO sav_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ali ɓo' na nameeɗi tum biiñi asi na soñe ŋ mbohos und maañiɗ ; mbaa mbohosi hey pooke, biiñi aamuk, mbohosi yahrukoh. Biiñ as kay na tumse ŋ mbohos as, jaar ca kanak, ca min maañ. » ");
INSERT INTO sav_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wa Yeesu woyee na ɓa ndeem, raakka kilifaani hay, ƴekka ŋ fikiice woosa ɗe ne : « Kuɓkiŋ ngo cafƴi kaaniɗ señci, waaye haya fu deg ɗe yaah, a hey pesisse. » ");
INSERT INTO sav_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeesu kurukka, ñaakeeɗa nga ɗe, a yi na taalubeeciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Wa raakeen ɓitɓa fu inah ne ñif miŋ ɗe meeɗ meeɗ aamuk, a tumiɗ na kosaay keem kiis ndaŋkiyaah na kiis kanak (12) ; a woyee ŋ ɗooƴ ce ne : « Ŋ laal kulɓaakiŋ ɗe dong ɗah, ŋ hey wire ! » A lahha Yeesu finho, a laalla lecmiŋ kulɓaakiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeesu heelukka hotta ɗe, woosa ɗe ne : « Ndengɗukka ɓitɓi ! Kosi fu kos wirɗiɗ ɗa. » Ŋ ɗiska ɗiska ɓitɓa wirra. ");
INSERT INTO sav_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wa Yeesu ree kahan kilifaana, a hotta ɓooɓa mbiiɓee, na mboolnda findi wa ɗuuɗohe, ");
INSERT INTO sav_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a woosa ɓa ne : « Kurkaat ndii, cafƴi kaanɗi, a na neehe. » Waaye ɓa njembteeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa mboolnda cootɗu, Yeesu aassa, ammba kuɓka cafƴa ŋ yaah, njaanja kurukka. ");
INSERT INTO sav_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jaarra ɓooɓa laamtoheeɗaa ŋ kur kaam jen. ");
INSERT INTO sav_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wa Yeesu kurkoh ndaam, kaɗeeɗa, fuuliɗ kanak ñaakɗeeɗa ɗe, leehkeeɗa ŋ ɗafka an : « Setiŋ Dawuuda, ɓoo miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeesu reesa kahna, fuuliɗ ca reɓpa nga ɗe, a woosa ɓa ne : « Ɗu kosiɗ ne ŋ miniɗ haɓiɗ ineem e ? » Ɓa loffa ɗe ne : « Ee kilifaani. » ");
INSERT INTO sav_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A laalla has ciŋ ɓa, a woosa ne : « Wa raakohaat ɗaa nga ɗu findi ɗu kosoha ! » ");
INSERT INTO sav_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ŋ ineem has ciŋ ɓa marakka. A woosa ɓa ndengiɗ ne : « Wortukaat, ali ɓo' kinaata yeg ! » ");
INSERT INTO sav_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Waaye wa ɓa pul, ɓa laamtoheeɗaa ŋ kur kaam jen. ");
INSERT INTO sav_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɓa cootee coot rek, Yeesu komissuusa ƴaar, a jiini ambee ɗe, muumiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeesu aannja jiinnda, muum ma cammba jomb. Mboolnda feyuusa woyeeɗa ne : « In mand an moosɗi hotohu ŋ Israayel. » ");
INSERT INTO sav_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Waaye Farisen ca woyee ne : « A kilifaaniŋ jiiniici na onee ɗe hatili a na aañohee ca. » ");
INSERT INTO sav_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeesu wileeɗa kur ca yakak ca na ca ƴin ca jen, a jangɗoheeɗa ŋ sinaagog ca, a woyeeɗa ɓooɓa Yegɗohiŋ Muci, wi kaɗ ŋ Nguuriŋ-Ɗafki, a wirɗeeɗa kosaay ca na ɓeenduk ca jen. ");
INSERT INTO sav_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A hotta ɓooɓaŋ mboolnda, ɓa misikka ɗe lool ; ɓa nikee goyiɗ, yaaɓoh na yaaɓoh findi mbaal raakaaɗi niiɗoh. ");
INSERT INTO sav_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ŋ ineem, a woosa taalubeeciŋ ɗe ne : « Yohni laaɓiɗ waaye nguɗoh ci laayɗi. ");
INSERT INTO sav_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kon kiimaat Heɗ yohni a woosoh ɓi pangkoh, ɓa nguɗ yohni. » ");
INSERT INTO sav_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ƴutta, a ɓeeɗukka taalubeeciŋ ɗe ndaŋkiyaah na kanak ci (12), a onnda ɓa hatil ne ɓa wirɗee kosaay ci na ɓeenduk ci jen, a nammba ɓa on hatil ne ɓa aañee jiiniici na hoolaaɗiiki ca hoolaaɗi. ");
INSERT INTO sav_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cii ceɗ tiik ciŋ Apootar ci ndaŋkiyaah na kanak ci (12) : Kockoh ŋ Simong yi teeku Piyeer, na Andare taambɗoh ce ; Saak na Saaŋ, kuɓuuciŋ Sebede ; ");
INSERT INTO sav_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip na Bartalemi ; Tomaa na Macce juuti'ohi ; Saak kuɓkiŋ Alfe, na Tade ; ");
INSERT INTO sav_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simong yi nikee Selot na Yudaa Iskaryot yi wor ɗe. ");
INSERT INTO sav_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɓeem ɓeɗ nikee ndaŋkiyaah na kanak ci (12) Yeesu tuuƴe, a eɗta ɓa dengkoh cii an : « Kinaat kaɗ ŋ kur ciŋ ɓooɓi nikɗi Yawuut te kinaat aas ŋ kur ciŋ Samari ; ");
INSERT INTO sav_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","waaye kaɗaat ŋ mbaal ci muuƴiɗ ci ɓaah ŋ cuuɓiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɗisik nu ɗu taamb ŋ waasi ɗah, woyaat ɓooɓi ne Nguuriŋ-Ɗafki reɓiɗ. ");
INSERT INTO sav_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wirɗaat kosaayiɗ ci, hultiɗaat kaaniɗ ci, aañaat jiiniici, ɗu wiriɗ ɓooɓi kosaay kosaay ki na oɓse faan po ɓa nik ɓo' hooliɗ. Ɗu rahsiɗ te ɗu wirindɗi, kon eɗohaat te kinaat wirndiɗuk. ");
INSERT INTO sav_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kinaat ɓayndoh ali kopor, wa urus haa, wa haalis haa, wa hanjar loƴaah haa, ");
INSERT INTO sav_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kinaat ɓayndoh saak ɓaaɓoha, kinaat ɓayndoh kulɓa kanak wala ñafaɗ wala ndooɗ, laam ɓoyi na pangke joyiɗ rahas kañam kiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kur nu ɗu aasoh ɗah, meeksohaat po ɗu inah ɓoyi teyɗuk ɗu daliɗ, ɗu nik ŋ kahan ce po mbaɗna ɗu cootan. ");
INSERT INTO sav_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɗu aasee kahna ɗah, kañɗohaat ; ");
INSERT INTO sav_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","nik ne kahna yeyyoo'iɗ ɗu daliɗ ɗah, jamiŋ ɗu nikaat nga, waaye wa yeyyooɗi ɗu ɗah, kaɗaat na jamiŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɗu dalɗuuɗi, ɗu sikɗukuuɗi ɗah, pulaat kahneem wala kur keem, ɗu faris merhey miŋ kot ciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ñam na woyee ɗu wa te wa keeh, ŋ mbehaŋ atteena, e ɓi kur keem uupan miskiɗ ɓi Sodom na Gomor. ");
INSERT INTO sav_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mi yii tuuƴ ɗu findi mbaal ŋ ɗooƴ gat ɓaakoɓ ; yunkaat findi iiñ, ɗu soos findi banuut. ");
INSERT INTO sav_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wortukaat ɓooɓi, ɓa hey ɗu ambe, ɓa ɓay ɗu ŋ ngelohaaci te ɓa hey ɗu laɓɗuke leraw ŋ sinaagog ciŋ ɓa ; ");
INSERT INTO sav_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ɗu hey ɓayse ŋ fiki ɓi goornoor na ɓi buur saguuso. Ineem hey tahe po ɗu min ndo seede ŋ fikiiɓa na fiki ɓooɓi nikɗi Yawuut. ");
INSERT INTO sav_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Waaye ɓa ɓayee ɗu ɗah, kinaat jaahiɗ ŋ findi ɗu woyohan na ini ɗu woyan, ɗu hey eɗse ŋ saasi saasi ini ɗu woyan. ");
INSERT INTO sav_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Laam, e ɗu woyan haa, a Fuuɗsiŋ Baabiŋ ɗu, a yi woyan taamboh nga ɗu. ");
INSERT INTO sav_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ɓo' hey ambɗuke taambɗoh ce ne a apu, baabu hey ambɗuke kuɓkiŋ ɗe ne a apu, ɓi komaaki hey nike sangiɗ ciŋ ɓooɓi rim ɓa, ɓa apɗuk ɓa. ");
INSERT INTO sav_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɓooɓi jen hey ɗu sange saguuso ; waaye ɓoyi na hee ndengɗuke muñ po ŋ reehɗohaana hey mucɗasse. ");
INSERT INTO sav_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɗu tumsee miskiɗ ŋ kur kii ɗah, saandohaat ŋ kur wiiriis. Ñam na woyee ɗu wa te wa keeh, ɗu reehɗanɗi kur ci nik ŋ Israayel te Kuɓkiŋ ɓoyi hayɗi. ");
INSERT INTO sav_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Taalubeeni uupɗi yak ɓoyi na jangɗee ɗe te ñaami uupɗi yak heɗ ce. ");
INSERT INTO sav_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Taalube mand na ɓoyi na jangɗee ɗe ɗah, wa doyiɗ ɗe. Ñaam na heɗ ce nam mand ɗaa. Nik ne ɓa teekiɗ heɗ kahni Belsebul ɗah, moo ɓooɓiŋ kahni teeksan na ? ");
INSERT INTO sav_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mbaa kinaat ɓa neek. Laam in nu ɗembɗu ɗah, wa hey teeɓohse te in nu ɗemb ɗah, wa hey inhasse. ");
INSERT INTO sav_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","In nu ŋ woo na ɗu na wek ɗah, woyaata noh cong te in nu ɗu moondɗu ŋ nof ɗah, leehkaata ŋ ɗafuk taɓah ci. ");
INSERT INTO sav_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kinaat nup ɓi na ape faan te ɓa minɗi ap ruuh. Nupaat Yi min ambsoh faan na ruuh jen a sooƴiɗ ca ŋ yongkaaha yakka. ");
INSERT INTO sav_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sel ƴin kanak na toonohseeɗi daram yino dong e ? Moona deey, yino na keeneeɗi nga ca te Baabiŋ ɗu yegɗaa. ");
INSERT INTO sav_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Te ini kaɗ nga ɗu, a inhiɗ sah findi find ciŋ haf ciŋ ɗu hend. ");
INSERT INTO sav_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kon kanaat neƴƴoh ! E ɗu uupiɗ juuk sel njiriñ. ");
INSERT INTO sav_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ɓo' nu woo ŋ fiki ɓooɓi ne a ɓaah nga so ɗah, ŋ hey name woo ŋ fiki Baabiŋ ngo yi nik ŋ Eel ci ne ɓoyeem ɓaah nga so. ");
INSERT INTO sav_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Waaye ɓo' nu taasuk ko ŋ fiki ɓooɓi ɗah, ŋ hey ɗe name taasuk ŋ fiki Baabiŋ ngo yi nik ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kinaat liiɓ ne ŋ hay ne ŋ ɓay jam ŋ Adina ; ŋ ɓayɗi jam, ŋ ɓay hiñoh. ");
INSERT INTO sav_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Laam, findi Fiis ci woyoha, hayiŋ ngo hey tahe po “ ɓo' sang baab ce, komaaki ɓitiɓ sang yaay ce, kilook sang payum ce ɓitiɓ. ");
INSERT INTO sav_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sangiɗ ciŋ ɓoyi nikan ɓi kahan ɓa. ” ");
INSERT INTO sav_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ɓo' nu waaɗ baab ɓa mbaa yaay ɓa waaɗi uup wi a waaɗ to ɗah, a yeyyooɗi so te ɓo' nu waaɗ kuɓkiŋ ɗe ƴaar mbaa ɓitiɓ waaɗi uup wi a waaɗ to ɗah, a yeyyooɗi so. ");
INSERT INTO sav_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɓo' nu ɓayɗi kurwaani a joy daaƴohu, a ñaakee nga so ɗah, a yeyyooɗi so. ");
INSERT INTO sav_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɓo' nu waaɗ kipes kiŋ ɗe ɗah, a hey wa ñake, te ɓo' nu ñak kipes kiŋ ɗe saguuso ɗah, a hey raake kipes ki. ");
INSERT INTO sav_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ɓo' nu teyɗuk ɗu ŋ kahan ce ɗah, a teyɗuk ko, te ɓo' nu teyɗuk ko ɗah, a teyɗuk Yi woos so. ");
INSERT INTO sav_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɓo' nu teyɗuk woosuuɗ ŋ kahan ce sagu ini a nik woosuuɗ ɗah, a rahsan aaf woosuuɗ, te ɓo' nu teyɗuk ɓo' yurhiɗ sagu ini ɓoyeem nik ɓo' yurhiɗ ɗah, a rahsan aaf ɓo' yurhiɗ. ");
INSERT INTO sav_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te yaa nu eɗ ɓo' yino ŋ ɓooɓi ƴissuutɗuuɗ ci, ali nik ne wa pot masuɓ soosiɗ ne a an, sagu ini a nik taalube ɗah, ñam na woyee ɗu wa te wa keeh, ɓoyeem ñakanɗi aafu nga. » ");
INSERT INTO sav_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wa Yeesu ƴut eɗ taalubeeciŋ ɗe ndaŋkiyaah na kanak ci (12) dengkoh ciŋ ɗe, a kurkohha ndaam, a kaɗta kur caŋ ɓak caam ne a jangɗoha nga, a woyeeɗa Yegɗohiŋ Muci nga. ");
INSERT INTO sav_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wa raak Yahya Ɓoktohi taƴuuɗ ŋ kasoona, a kerahha in ci Mucɗohi Gapohse haɓɗe. A woossa ɓi ɓo' ŋ taalubeeciŋ ɗe ");
INSERT INTO sav_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ne ɓa meekis ɗe andi a yi Mucɗohi Gapohse joy hay wala ɓa joy sek ɓo' wiiriis. ");
INSERT INTO sav_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wa ɓa ree ŋ Yeesu, a loffa ɓa ne : « Kaɗaat, ɗu woya Yahya ini ɗu hot te ɗu kerahhaa : ");
INSERT INTO sav_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fuuliɗ ci ɓii hot, lafañ ci ɓii tiind moɗoɗ, ɓi raak kosaay ki na oɓse faan ɓii wir, ɗikiɗ ci ɓii kerah, kaaniɗ ci ɓii hulit te ñakiɗ ci ɓii woyu Yegɗohiŋ Muci. ");
INSERT INTO sav_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A sumaat, ɓoyi moosanɗi kurkoh ŋ kosi a kos sagu tumohaaɗ ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wa taalubeeca woossee coote, Yeesu woyeeɗa na mboolnda ŋ ini kaɗ ŋ Yahya. A woosa ɓa ne : « Ɗu kee ye marka ŋ nduufa, caaɓsi yino-kongi puuɗsi na giyaange e ? ");
INSERT INTO sav_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ŋ liiɓɗaa ! Kon, ɗu kee ɓa marka, ɓo' ɓekkiɗ kulɓa moɗiɗ e ? Ŋ hot ɓooɓi na ɓekke kulɓa moɗiɗ na nike ŋ kahan ciŋ buur ci. ");
INSERT INTO sav_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Moo, ɗu kee ɓa marka ? Woosuuɗ e ? Ee, ñam na woyee ɗu wa, a yi uup sah woosuuɗ, ");
INSERT INTO sav_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","laam a yi Fiis ci Hooliɗ ci woyee an : “ Ŋ hey woose ɓo' a adug ɗa, ne a haɓɗiɗ ɗa waasi. ” ");
INSERT INTO sav_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñam na woyee ɗu wa te wa keeh, ŋ ɓooɓi rimuk jen ali ɓo' uupɗi Yahya Ɓoktohi nga. Waaye ɓoyi uup ƴissuut ŋ Nguuriŋ-Ɗafki a yi uup ɗe yak. ");
INSERT INTO sav_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ina amboh ŋ jamanoonaŋ Yahya Ɓoktohi poyi, Nguuriŋ-Ɗafki wii hay na hatil te ɓi na aasohee wa hatil ɓeɗ raaka. ");
INSERT INTO sav_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Laam, woosuuɗ ci na waasiŋMusaa nikee woyeeɗa woo-woosuuɗ po findi Yahya hayoh ; ");
INSERT INTO sav_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","te ɗu waaɗa teyɗuk ɗah, a yi Ilyas yi joyee hay. ");
INSERT INTO sav_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɓo' nu raak nof ɗah, a kerhaat ! ");
INSERT INTO sav_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Moo, ŋ min mandtiɗkoh ɓooɓi woti na ye ? Ɓa mand na komaakci ɓoof ŋ ɗiski na toonohse ŋ kur ki, ɓum woyee ɓinooɓi ");
INSERT INTO sav_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ne : “ Ɓoo tipɗiɗ ɗu, ɗu mbecɗi. Ɓoo ƴeekɗiɗ ɗu ƴeek ruy, ɗu fuɗɗi. ” ");
INSERT INTO sav_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Laam Yahya hiiɗ, a nikeeɗi ñamoh, a nikeeɗi anoh ; ɓa na woye ne a raak jiini ! ");
INSERT INTO sav_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kuɓkiŋ ɓoyi hayya, a ñameeɗa, a aneeɗa, ɓa na woye ne : “ A ñamoh, a anoh biiñ, te a nawle juuti'oh ci na bakaaɗoh ci ! ” Waaye liiɓohaaɗi moɗiɗi puloh ŋ Kooh na teeɓohe yurhiŋ wa, ŋ tumohaaɗ ciŋ wa. » ");
INSERT INTO sav_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ŋ ineem, Yeesu cammba ngas ɓi kur ci a uupee tumoh keemaan, laam ɓa ɓoƴsoheeɗi pesohaaɗ, a woosa ne : ");
INSERT INTO sav_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","« Mas, ɗu ɓi gen Korasin na Betsayda ! Keemaan ci tumu ŋ kur ciŋ ɗu, ca tumseen ŋ Tiir na Sidoon ɗah, ɓa heen ɓoƴsohe tumohaaɗ ciŋ ɓa maañ, ɓa ɓekuk daah ɓa ɓoof ŋ wet ne ɓa teeɓoha ! ");
INSERT INTO sav_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Weɗ tah ñam na woyee ɗu wa, ŋ mbehaŋ atteena, e mbugali ɗu rahsan uupan misik wiŋ ɓi Tiir na ɓi Sidoon. ");
INSERT INTO sav_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te ɗu ɓi gen Kapernawum, ɗu liiɓiɗ ne Kooh hey ɗu rapɗe po ŋ Eel ci e ? Muk ! A hey ɗu ruhsiɗe po ŋ kaaniɗ ca ; laam keemaan ci tumu ŋ kur kiŋ ɗu, ca tumseen ŋ Sodom ɗah, wa heen rise poyi. ");
INSERT INTO sav_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Weɗ tah ñam na woyee ɗu ne, ŋ mbehaŋ atteena e mbugali ɗu rahsan uupan misik wiŋ ɓi Sodom. » ");
INSERT INTO sav_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ŋ jamanoocaam, Yeesu woosa ne : « Mi yii corkiɗ ɗa Baab, fu yi Heɗ Eel ci na kehƴi, ŋ ini fu ɗasɗoh heɗ haf ci na ñaañiɗ ci in cii, fu teeɓpa ca komaakci. ");
INSERT INTO sav_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee Baab, mi yii corkiɗ ɗa. A fu waaɗoha ɗaa ŋ baah kiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yeesu woosa ɓooɓa ne : « Baabiŋ ngo degiɗ in ci jen ŋ yaah ho te ali ɓo' inahɗi Kuɓki ɗal Baabi, te ɓo' inahɗi Baabi, ɗal Kuɓki, na ɓooɓi a waaɗ ɓa ɗe teeɓ. ");
INSERT INTO sav_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Hayaat nga so, ɗu ɓi yaaɓiɗ ci jen na raankiɗ ci, ŋ hey ɗu one, ɗu iɗsiɗuk. ");
INSERT INTO sav_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Teyɗukaat ini ŋ degan ɗu, jangaat nga so, ŋ ɓo' soosiɗ, ŋ ɓo' eɗfiɗ te ɗu hey iɗsiɗe keeñ ciŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ini ŋ degan ɗu yooɓiɗ ɓayu, te ini mi na raanohe eɗfiɗ. » ");
INSERT INTO sav_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ŋ jamanoocaam, Yeesu na taalubeeciŋ ɗe kaɗeeɗa, ɓa taammba yohon caŋ beleeca, wa nikee ŋ mbehi na iɗsiɗkohse. Wa raak taalubeeci aɗkiɗ, ɓa piikeeɗa nga ca, ɓa ñameeɗa. ");
INSERT INTO sav_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wa Farisen ca hot ɓa, ɓa woosa ɗe ne : « Waasiŋ ɓoo sangohiɗ nguɗ ŋ mbehi na iɗsiɗkohse. Waaye marka ! Taalubeeciŋ ɗa tumiɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A woosa ɓa ne : « Mand haa ne ɗu moosɗi jangoh ina Dawuuda haɓɗee wa a aɗuk, a yi na ɓooɓa hunee na ɗe. ");
INSERT INTO sav_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A aas ŋ Kahan Kooh, a ɓayya mbuuruuca degsee ŋ taaɓla wuu Kooh, ɓa ñammba ca te raak e seeƴkiɗoh ci dong teyɗohsee wa. ");
INSERT INTO sav_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te ŋ namee liiɓ ne ɗu jangiɗ ŋ Fiis ciŋ waasiŋMusaa ne seeƴkiɗoh ci na pangke ŋ Kahan Kooh na iɗsiɗkeeɗi ŋ mbeheem. Kon ɓa na taambɗeeɗi nakoheem, waaye ɓa na ambseeɗi findi ɓoyi tooñ. ");
INSERT INTO sav_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ñam na woyee ɗu wa, raakiɗ ɓoyi uup Kahan Kooh ŋ ndii. ");
INSERT INTO sav_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Fiis ci namiɗ woo ne : “ Ŋ waaɗ ne ɗu teeɓoh baah kiŋ ɗu ŋ ɓinooɓi, weɗ ngisoh ɗu seeƴkee wuu so. ” Ɗu inheen ini woo keem tokis ɗah, ɗu heeɗi yambe tooñaaɗiicii. ");
INSERT INTO sav_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Laam Kuɓkiŋ ɓoyi a yi Heɗ mbehi na iɗsiɗkohse. » ");
INSERT INTO sav_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wa Yeesu kurkoh ndaam, a kaɗta sinaagoga. ");
INSERT INTO sav_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A raakka nga ƴaar, yaahiŋ ɗe ɓeendkee ɓeenduk. Ɓa meekissa Yeesu ne : « Andi wiriɗ ɓo' ŋ mbehi na iɗsiɗkohse teyɗohuuɗ ? » Raak ɓa waakee ini ɓa yamban ɗe. ");
INSERT INTO sav_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A loffa ɓa ne : « E ya ɓa nga ɗu a yi raakan mbaal yino dong, a keen ŋ nung ŋ mbehi na iɗsiɗkohse, a faɗ ɗe nga, a pulɗuu ɗe ? ");
INSERT INTO sav_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Te ŋ hot a ɓo' uup mbaal fuuf ! Kon tum in baahiɗ teyɗohuuɗ ŋ mbehi na iɗsiɗkohse. » ");
INSERT INTO sav_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A woosa ƴaara na yaaha ne : « Raɗsa yaahiŋ ɗa. » A raɗissaa, wa dokukka moɗoɗ findi winoora. ");
INSERT INTO sav_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisen ca pulla, ɓa markeeɗa findi ɓa na hee apohe Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Waaye a inahhaa, a kurkohha ndaam, a cooteeɗa. Mboolo laayiɗ ñaakiɗta ɗe, a wiriɗta kosaayiɗ ca nga jen. ");
INSERT INTO sav_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A woytohha ɓa ndengiɗ ne ɓa kinaat ɗe laamtoh. ");
INSERT INTO sav_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaarra ini Kooh woyee taamboh ŋ woosuuɗi Esayi raakka, an : ");
INSERT INTO sav_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","« Surgaaniŋ ngo yeɗɗi, yi ŋ tan, ŋ waaɗta ɗe keeh-keeh, ŋ neɓuusa nga ɗe. Ŋ hey tume Fuuɗsiŋ ngo nga ɗe, a hey yegɗohe kiyurah ŋ cuuɓ ci jen. ");
INSERT INTO sav_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A heyɗi lahtohe na ɓo', a leehkanɗi, te ali ɓo' kerhanɗi hoosooriŋ ɗe ŋ harmban kahan ci. ");
INSERT INTO sav_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A ɗiindohanɗi mbaang hapeel weeriɗ, a ƴimanɗi laampaani na ɗuuke. A tumohan ɗaa po kiyurah raak ndam. ");
INSERT INTO sav_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kur ci jen hey dege yaakaar ciŋ ɓa ŋ tiikiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Weɗ ɓa ɓayoh ŋ Yeesu ƴaari fu inah ne a jiini fuulɗee ɗe, muumiɗta ɗe. Yeesu wiriɗta ɗe po a jombeeɗa, a hoteeɗa. ");
INSERT INTO sav_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mboolnda jen feyuusa woyeeɗa ne : « Wa miniɗ nik ne a setiŋ Dawuuda de' ! » ");
INSERT INTO sav_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wa Farisen ca keraha, ɓa woosa ne : « Uh, a na aañohe jiiniici hatiliŋ Belsebul, kilifaaniŋ ca. » ");
INSERT INTO sav_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeesu inahha liiɓ ciŋ ɓa, a woosa ɓa ne : « Ɓooɓi ɓaah nguur hiñohee ŋ harmban ɓa ɗah, nguureem hey keene, te ɓooɓi ɓaah kur wala kahan hiñohee ŋ harmban ɓa ɗah, kur keem wala kahneem minanɗi tufuk. ");
INSERT INTO sav_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kon wa nik ne Seytaani na aañe Seytaani ɗah, a yi hiñoh na haf ce. Kon nguuriŋ ɗe tufkohan na ? ");
INSERT INTO sav_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nik ne mi na aañohe jiiniici hatiliŋ Belsebul ɗah, moo ɓooɓiŋ ɗu na namee ca aañ, ɓa na aañohee ca winde hatil ? Ineem weɗ tah ɓeɗ atte'an ɗu. ");
INSERT INTO sav_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Waaye nik ne mi na aañohe jiiniici Fuuɗsiŋ Kooh ɗah, kon Nguuriŋ-Kooh reyiɗ nga ɗu. » ");
INSERT INTO sav_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yeesu degga nga ne : « Ɓo' min na aasoh kahan ɓo' raakiɗ hatil, a ɓay in ciŋ ɗe te a tokɗi ɗe po a ndeng ? Waaye a tok ɗe ɗah, a hey ɓaye in ciŋ kahan ce jen. ");
INSERT INTO sav_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɓo' nu langɗi na so ɗah, a sangiɗ to te ɓo' nu nangɗohohɗi so ɗah, a na pasarohe. ");
INSERT INTO sav_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Weɗ tah ñam na woyee ɗu wa : Ɓooɓi ɗaasnuk ɗah, ɓa hey ɗaasse bakaaɗ nu bakaaɗ na ɗal nu ɓa ɗal Kooh ɗah, waaye, ɓo' nu ɗal Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh ɗah, a ɗaassanɗi. ");
INSERT INTO sav_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɓo' nu woo in moɗaaɗi ŋ Kuɓkiŋ ɓoyi ɗah, a ɗaasnuk ɗah, a hey ɗaasse, waaye ɓo' nu woo in moɗaaɗi ŋ Fuuɗsi Hoolohngaani ɗah, a ɗaassanɗi wa ŋ adinaanii na wi na haye. ");
INSERT INTO sav_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Fu woo ne kidgi baahiɗ ɗah, waa ne rim ciŋ wa baahiɗ. Fu woo ne kidgi baahɗi ɗah, waa ne rim ciŋ wa baahɗi. Laam kidig na inhisohse rimiŋ wa. ");
INSERT INTO sav_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɗu hiriñ rek, ɗu min na woyoh in baahiɗ, na baahaaɗiiki ɗu baahaaɗi ? Nguɓ na woye ini keeñ riif naa. ");
INSERT INTO sav_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɓo' baahiɗ na pulɗe in baahiɗ raakee weɗ nik ŋ ɗaakkiŋ ɗe. Ɓo' baahaaɗi na pulɗe in baahaaɗi raakee weɗ nik ŋ ɗaakkiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ñam na woyee ɗu wa : Ŋ mbehaŋ atteena, ɓooɓi hey teeɓohe ini tah woo ciŋ ɓa mbalay ci. ");
INSERT INTO sav_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Laam ɓo' nu nga, e woo ciŋ ɗe hoolɗan ɗe wala ceɗ amban ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Weɗ ɓi jangɗohoh ɓaah ŋ ɓiŋ waasi, na ɓi Farisen woyoh ɗe ne : « Jangɗohohi, ɓoo waaɗ ne fu teeɓ ɓoo firnde puloh ŋ Eel ci. » ");
INSERT INTO sav_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A woosa ɓa ne : « Ɓooɓi woti ɓeɗ baahaaɗi, ɓa topɗi ŋ Kooh po haa njaalo'oh, an ɓa na meeksohe firnde ; ɓa eɗsanɗi ali firnde ɗal wiŋ woosuuɗi Yunus. ");
INSERT INTO sav_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Findi Yunus tumohee noh kaahay na wek kaahay ŋ rookaŋ cuurnda yakka, Kuɓkiŋ ɓoyi hey name nik noh kaahay na wek kaahay ŋ ɗooƴ kehƴi. ");
INSERT INTO sav_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ŋ mbehaŋ atteena, ɓi Niniw hey kurke, ɓa teeɓ ɓooɓi woti ne ɓa raakɗi keeh, laam wa ɓi Niniw kerah woo kaŋ Yunus, ɓa ɓoƴsoheen pesohaaɗ keeh-keeh ; te moona ini nik ndii, weɗ uup Yunus. ");
INSERT INTO sav_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Buura ɓitɓaŋ Saba pulohee kur usiɗ ne a sikɗuk liiɓohaaɗa moɗɗaŋ Suleymaan. Te moona raakiɗ ini uup Suleymaan ŋ ndii, weɗ tah mbehi Kooh na hee atte'ohe ɓooɓi, buuri ɓitɓeem hey kurke, a teeɓ ɓooɓi woti ne ɓa raakɗi keeh. ");
INSERT INTO sav_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jiini, na hoolaaɗiiki a hoolaaɗi, faɗta ɓo' ɗah, a na kaɗe ŋ ɓi ɗisik suyiɗ a waakee ɗiski a iɗsiɗkohan waaye a na raakeeɗi. ");
INSERT INTO sav_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ŋ ineem, a woo ŋ haf ce ne : “ Mi na hee dokke kahnaŋ ngo ŋ puloh. ” A wiiruk ɗah, a raak kahna ɓarang, paɗuuɗ, haɓɗuuɗ moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaar a kaɗ waaka jiini yasna-kanak ci uup ɗe añaand ; ca kaɗ kahna, ca gen. Ŋ ineem, mirndohaaɗiŋ ɓoyeem weɗ na uupe misik fuuf findi a kocee mand. In mand ɗaa weɗ rahsan ɓooɓi woti, ɓa baahɗi. » ");
INSERT INTO sav_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wa Yeesu nik ndaam, a woyeeɗa na mboolnda, yaay ɓa na taambɗoh ciŋ ɗe ƴaar ci hayya, ɓa tufukka ŋ hara ɓa waaɗta woo na ɗe.  ");
INSERT INTO sav_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Raakka ɓoyi woo ɗe ne : « Yaay ɗu na taambɗoh ciŋ ɗa ɓa ɗaa tufukka ŋ hara, ɓa waaɗ woo na ɗa. » ");
INSERT INTO sav_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeesu loffa ɗe ne : « Ɗu amb ne a ɓa yaay ɓoo, e ɓinde taambɗoh ciŋ ngo ? » ");
INSERT INTO sav_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jaarra a yurhiɗta yaah ŋ taalubeeciŋ ɗe a woosa ne : « Ɓooɓii, ɓeɗ yaay ɓoo, ɓeɗ taambɗoh ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ɓo' nu na haɓɗe ini Baabiŋ ngo yi nik ŋ Eel ci waaɗ ɗah, ɓoyeem a taambɗoh ho ƴaar mbaa ɓitiɓ wala yaay ɓoo. » ");
INSERT INTO sav_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mbaɗi, Yeesu pulohha kahna, a kaɗta, a ɓooffa ŋ sereendaŋ cookma ne a jangɗoh. ");
INSERT INTO sav_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mboolo yakiɗ hayya ndeerra ɗe, po a mirndohha rap ŋ gaal, a ɓooffa nga. Mboolnda jen tufukka ŋ sereendaŋ masma. ");
INSERT INTO sav_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A woosa na ɓa, ŋ andiin, ŋ ini kaɗ ŋ in laayiɗ ; a woo ɓa ne : « A nikee guuroh, a kaɗta soka. ");
INSERT INTO sav_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wi a soke, a saaweeɗa tisohi, in nga hennda ŋ waasi ŋ ɗooƴ yohni, sel ci hayya ñammba ca. ");
INSERT INTO sav_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Raakka ci keen ŋ ɗisik laayaaɗi merhey, raakiɗ atoh, tahha po ca arra paar, ");
INSERT INTO sav_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","waaye wi nohi dam, in ca paaree leeɓpa po ca onnja sagu ini ca raakeeɗi niir nooɗiɗ. ");
INSERT INTO sav_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","In ŋ tisohi nammba keen ŋ ɗisik raakiɗ ñaaɓaaɓ ; ca paarandoosa na ñaaɓaaɓ ca, ceem ndooƴca ca. ");
INSERT INTO sav_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waaye raakka ca keen ŋ keheƴ baahiɗ, ca rimmba cum kuɓu teemet (100), cum ndaŋkiyaah-yasna-yino (60), cum ndaŋkiyaah-kaahay (30). » ");
INSERT INTO sav_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ƴutta, Yeesu woosa ɓa ne : « Ɓo' nu raak nof ɗah, a kerhaat ! » ");
INSERT INTO sav_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Taalubeeca reɓpa nga ɗe, ɓa meekissa ɗe ne : « Wa ye tah fu woyee na ɓa ŋ andiin ? » ");
INSERT INTO sav_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A loffa ɓa ne : « Ɗu onuuɗ ne ɗu inah in ci ɗasɗukiɗ ciŋ Nguuriŋ-Ɗafki waaye ɓeɗ, ɓa rahasɗi ca. ");
INSERT INTO sav_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɓoyi raak hey ɓaatse po a laayiɗ lool, waaye ɓoyi raakɗi, ini ƴissuuti a amb sah hey naafse nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ineem weɗ tah po ŋ woyee na ɓa ŋ andiin. Laam ɓa ɗii marak te ɓa hotɗi ; ɓa ɗii sikɗuk, waaye ɓa kerahɗi, ɓa inahɗi. ");
INSERT INTO sav_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ini ɓa tum, weɗ ini Kooh woyee taamboh ŋ woosuuɗi Esayi an : “ Ɗu hey sikɗuke baahiɗ waaye ɗu inhanɗi muk ; ɗu hey marke baahiɗ, waaye ɗu hotanɗi muk. ");
INSERT INTO sav_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Keeñ ciŋ ɓooɓii raakisɗi yeg yeg ; ɓa rangiɗ nof ciŋ ɓa, ɓa ɗuungiɗ has ciŋ ɓa ne ɓa hotuu na has ciŋ ɓa, ɓa kerhuu na nof ciŋ ɓa, te ɓa inhuu ngaŋ keeñ ciŋ ɓa ; te ŋ ineem, ɓa minuu wiiruk nga so ne ŋ wiriɗ ɓa. ” » ");
INSERT INTO sav_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yeesu woyissa taalubeeciŋ ɗe ne : « Waaye ɗu, ɗu neɓɗiɗ, has ciŋ ɗu ca ɗii hot te nof ciŋ ɗu ca ɗii kerah. ");
INSERT INTO sav_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ñam na woyee ɗu wa te wa keeh, woosuuɗ laayiɗ na ɓo' yurhiɗ laayiɗ maɗeen hot ini ɗu na hote te ɓa hotɗaa, ɓa maɗeen kerah ini ɗu na kerhe te ɓa kerahɗaa. ");
INSERT INTO sav_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mbaa sikɗukaat ini andiiniŋ sokohi tokis. ");
INSERT INTO sav_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɓooɓi kerah woo ki kaɗ ŋ Nguuriŋ-Ɗafki, te ɓa inahɗi ini wa tokis, Seytaani na haye nga ɓa, a kooɗ ini soku ŋ keeñ ciŋ ɓa. Ɓeem, ɓeɗ ini saawu ŋ sereendaŋ waasa. ");
INSERT INTO sav_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɓinooɓi ɓeɗ paaroh ŋ ini saawu ŋ kehƴi raak atoh ci ; ɓeɗ ɓooɓi na kerhe Woo ki, ɓa jaara teyɗuk na keeñ soosiɗ, ");
INSERT INTO sav_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","waaye ɓa na raakeeɗi niir ŋ haf ɓa, ɓa na maañeeɗi nga. Ɓa raak miskiɗ wala ɓa tolfiɗassee sagu Woo ki ɗah, ɓa ar faɗ. ");
INSERT INTO sav_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɓinooɓi ɓeɗ paaroh ŋ ini saawu ŋ ñaaɓaaɓ ci ; ɓeɗ ɓooɓi na kerhe Woo ki, ɓa teyɗuka, waaye liiɓsiɗoh ciŋ Adina na raak-raak ci na njuyohe, amb ɓa po Woo ki minuu rim ali in. ");
INSERT INTO sav_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓinooɓi ɓeɗ paaroh ŋ ini saawu ŋ kehƴi baahiɗi ; ɓeɗ ɓi na kerhe Woo ki, ɓa inah ini wa tokis ; ɓa raak rim, ɓum teemet (100), ɓum ndaŋkiyaah-yasna-yino (60) ɓinooɓi ndaŋkiyaah-kaahay (30). » ");
INSERT INTO sav_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu naandsukissa mboolnda andiin wiiriis, a woo ɓa ne : « Nguuriŋ-Ɗafki, wa mand na inii : A nikee ɓo', a sokka tisoh baahiɗ ŋ yohon ce, ");
INSERT INTO sav_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","waaye wa weka ree, ɓooɓa neeheeɗa, sangiɗaŋ ɗe ɓayya gaacooh, a sokka ca ŋ ɗooƴ tohooca, a cootta. ");
INSERT INTO sav_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tohra paarra, gaacooh fa paarra naa. ");
INSERT INTO sav_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ŋ ineem ñaam ciŋ heɗ yohni hayya nga ɗe, ɓa woosa ɗe ne : “ Kilifaani, fu sokee tisoh baahiɗ ŋ yohon fu haa e ? Moo gaacooh fa puloh nde ? ” ");
INSERT INTO sav_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A loffa ɓa ne : “ A ɓoyi sang ngo tum ineem. ” Ɓa woosa ɗe ne : “ Kon ɓoo kaɗa ɗofa e ? ” ");
INSERT INTO sav_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A loffa ɓa ne : “ A'aa ! Ŋ sang ne ɗu ɗofee wa ɗah, ɗu ɗofndoh tohri, ");
INSERT INTO sav_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","faɗaat, ca hun ca yak po ŋ nguɗa. Nguɗa ree ɗah, ŋ hey woye nguɗoh ci ne : ‘Kocaat weɗ nihis, ɗu toka ɗuf ɗuf, ɗu doh ca ; waaye ɗu ɓek tohri ŋ ndapiŋ ngo.’ ” » ");
INSERT INTO sav_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu naandsukissa ɓa andiin wiiriis, a woo ɓa ne : « Nguuriŋ-Ɗafki, wa mand na inii : A nikee ɓo', a ɓayya kuɓu mutarda, a sokkaa ŋ yohon ce. ");
INSERT INTO sav_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kuɓu mutarda weɗ uup ƴissuut ŋ tisoh ciŋ kidig ci ƴin ci na sokse ŋ nguuk jen. Waaye wa paarra ɗah, wa yak po wa uup ca, wa nik kidig po sel ci taar ŋ naak ciŋ wa. » ");
INSERT INTO sav_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A naandsukissa ɓa andiin wiiriis an : « Nguuriŋ-Ɗafki, wa mand na findi ɓitiɓ na ɓayohee lawiir a siiɓa na kanoh mun kaahay ; ƴut ɗah, ini siiɓuuɗi jen guuf. » ");
INSERT INTO sav_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","In ceem jen Yeesu woyee mboolnda ca ŋ andiin, te a woyeeɗi na ɓa ŋ ini nikɗi andiin. ");
INSERT INTO sav_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A woyohee ɗaa ne ini woosuuɗa woyee raak, a woyee ne : « Ŋ hey woye ŋ andiin, ŋ woo in ci ɗembiɗ ci, ina amboh ŋ feraŋ Adina poyi. » ");
INSERT INTO sav_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Weɗi Yeesu faɗoh mboolnda, a aassa ŋ kahna. Taalubeeciŋ ɗe hayya nga ɗe, ɓa woosa ɗe ne a toksiɗaat ɓa andiiniŋ gaacooh fi paar ŋ yohni. ");
INSERT INTO sav_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A loffa ɓa ne : « Kuɓkiŋ ɓoyi a yi ɓoyi sok tisohi baahiɗi, ");
INSERT INTO sav_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","yohni weɗ adinaani, tisohi baahiɗi weɗ ɓooɓi ɓaah ŋ Nguuriŋ-Ɗafki, gaacooh fi weɗ ɓooɓi ɓaah ŋ Seytaani. ");
INSERT INTO sav_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sangiɗi sok gaacooh fi a yi Seytaani, nguɗi weɗ reehiŋ Adina, nguɗoh ci ɓeɗ malaakaaci. ");
INSERT INTO sav_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Findi gaacooh fi nihsohu, wa ɓekuusa ŋ yongkaah, wa kaɗohan ɗaa ne Adina reeh ɗah. ");
INSERT INTO sav_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kuɓkiŋ ɓoyi hey tuuƴe malaakaaciŋ ɗe, ca ɗof ɓi ɓaahɗi ŋ Nguuriŋ ɗe, ɓeɗ ɓooɓi na bakaaɗɗukohe jen na ɓi na tume ini nikɗi waas, ");
INSERT INTO sav_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ca njaf ɓa ŋ yongkaaha yakka, ɗiska fuɗ na ɗoɓɗoh sis raak. ");
INSERT INTO sav_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Weem weɗ ɓooɓi yurhiɗ ci siñaarɗohan findi nohi ŋ ɗooƴ Nguuriŋ Baabiŋ ɓa. Ɓo' nu raak nof ɗah, a kerhaat. » ");
INSERT INTO sav_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ŋ ineem Yeesu woosa taalubeeciŋ ɗe ne : « Nguuriŋ-Ɗafki mand na inii : Wa nikee raak-raak, wa ɗembɗuusa ŋ ɗooƴ yohon, ƴaar hottaa, a ɗembɗissaa. Weɗi a kaɗoh sumoh na sumoh, a toonnda in ca a raakee jen, a rommba yohna. » ");
INSERT INTO sav_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A woyissa ɓa ne : « Nguuriŋ-Ɗafki mand na inii : A nikee toontukoh. A waakeeɗa per moɗiɗ, ");
INSERT INTO sav_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","wi a waak po a hotta yino moɗoh na moɗoh, a kaɗta, a toonnda in ca a raakee jen, a rommbaa. » ");
INSERT INTO sav_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A woyissa ɓa ne : « Nguuriŋ-Ɗafki mand na inii : Ɓa nikee seeɓoh, ɓa njaffa mbaal ŋ ɗooƴ cookmi, wa ammba cuurund nu cuurund ");
INSERT INTO sav_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","po wa riiffa, ɓa ɓayyaa ŋ sereendaŋ cookma, ɓa ɓooffa. Ɓa nihissa baahiɗ ca, ɓa ɓekka ca ŋ pañe, ɓa mbetta ca raakaaɗi etoh ca. ");
INSERT INTO sav_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wa mandan ɗaa ne Adina reehee ɗah ; malaakaaci hey haye ne ca saɓsoh ɓooɓi yurhiɗ ci na ɓi yurhaaɗiici. ");
INSERT INTO sav_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ca njaf yurhaaɗiici ŋ yongkaaha yakka, ɗiska fuɗ na ɗoɓɗoh sis raak. » ");
INSERT INTO sav_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wa Yeesu ƴut woo ineem, a meekissa taalubeeciŋ ɗe ne : « Andi ɗu inhiɗ in ceem jen ini ca tokis ? » Ɓa loffa ɗe ne : « Ee ! » ");
INSERT INTO sav_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A woosa ɓa ne : « Ɓo' nu ɓaah ŋ jangɗohoh ciŋ waasi, kaɗ po a nik taalube Nguuriŋ-Ɗafki ɗah, a na mande na heɗ kahni na uuske as na kiisiɗ ŋ ɗaakkiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wa Yeesu ƴut woo andiin ceem, a kurkohha ndaam, ");
INSERT INTO sav_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a kaɗta kur ka a yakoh, a jangɗoheeɗa ŋ sinaagogaŋ ɓa, ɓooɓa nikee ŋ ɗiska feyuusa, woyeeɗa ne : « Ki'inhi na ɗe wii, a ɓayoha nde, na keemaan ci a na haɓɗe ? ");
INSERT INTO sav_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A kuɓkiŋ miniseeni haa e ? A Maryaama yaay ɓa haa e ? Taambɗoh ciŋ ɗe ƴaar ci, e Saak, Suseef, Simong na Yuud, haa e ? ");
INSERT INTO sav_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te taambɗoh ciŋ ɗe ɓitiɓ ci ɓa ɗii na ɓoo ndii jen haa e ? Kon in cii jen a puloh na ca nde ? » ");
INSERT INTO sav_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ineem weɗ tahee po ɓa minɗi ɗe teyɗuk. Waaye a woosa ɓa ne : « Woosuuɗ na kerhiɗasse ŋ ɗisik ci jen po tas ŋ harmban ɓaah ciŋ ɗe na kur ka a genoh. » ");
INSERT INTO sav_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ɓa koseeɗi ɗe, tahha po a tumɗi keemaan laayiɗ nga. ");
INSERT INTO sav_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ŋ jamanoonaam, Herod ya adgohee Galile, kerahha ɓooɓa laamtoheeɗa Yeesu, ");
INSERT INTO sav_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a woosa dag caŋ ɗe ne : « Ƴaareem, e Yahya Ɓoktohi ; a hultiɗu hultiɗu, weɗ tah a raakka hatil haɓɗoha in feyohiɗ ! » ");
INSERT INTO sav_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod yeem a yi taƴɗukee Yahya sagu Herojaad ɓiti Filip ; Filip nikee taambɗoh Herod. ");
INSERT INTO sav_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Waam, raak Yahya meeɗ woo Herod ne : « Waasiŋ Kooh teyɗohɗi ne fu ɓay ɓiti taambɗoh fu, fu tum ɗe ɓitiɓ. » ");
INSERT INTO sav_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ŋ ineem, Herod waaɗta ɗe apɗuk waaye a neƴƴoheen ɓooɓa laam ɓa teyɗukeen Yahya findi woosuuɗ. ");
INSERT INTO sav_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Waaye wa raakka mbeh Herod yakɗeeɗa mbehi a raakohu, kuɓkiŋ Herojaad ɓitɓi mbeceeɗa ŋ fiki hanheeca, Herod neɓuusa nga ɗe ");
INSERT INTO sav_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","po a gappa ɗe na giñ ne a hey ɗe eɗe in nu a meekis ɗe ɗah. ");
INSERT INTO sav_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herojaad, yaay ɓi kuɓka, ɓekka kuɓka po a woosa ne : « Ŋ waaɗ eɗu palaat ndii, na hafiŋ Yahya Ɓoktohi. » ");
INSERT INTO sav_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ŋ ineem Herod soossa waaye giña a giñee ŋ fiki hanheeca tahha po, a nakohha ne a eɗsaata, ");
INSERT INTO sav_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","a tuuƴohha ne hafiŋ Yahya kaɗ nguɗsa ŋ kasoona. ");
INSERT INTO sav_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hafiŋ Yahya nguɗuusa, ɓayuusa ŋ palaat, kuɓka cafƴa eɗuusaa, a ɓayyaa yaay ɓa. ");
INSERT INTO sav_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Taalubeeciŋ ɗe kaɗta ɓaya fiɗaafaŋ ɗe, ɓa accaa. Ɓa kaɗta, ɓa woosa Yeesu wa. ");
INSERT INTO sav_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wa Yeesu kerah ne Yahya Ɓoktohi apuuɗ, a kurkohha ndaam, a aassa ŋ gaal ne a kaɗ ɗaaya ŋ nduufa ; waaye ɓooɓa yeggaa, ɓa pulla kur ca, ɓa taambiɗta ɗe na kot. ");
INSERT INTO sav_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wi a ree po a ruhussa ŋ gaala, a hotta mboolnda findi wa yakoh, ɓa misikka ɗe lool ; a wiriɗta kosaayiɗ ca nikee nga. ");
INSERT INTO sav_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wa niina ree, taalubeeci reɓpa nga ɗe, woosa ɗe ne : « Ndii bilaf te Kooh yii hooɓeeɗa ; woya mboolndi ɓa kaɗ ŋ kur ci ne ɓa rom ini ɓa joy ñam. » ");
INSERT INTO sav_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeesu loffa ɓa ne : « Wa etohɗi ɓa kaɗe ; ɗu ɓii, eɗaat ɓa ɓa ñam. » ");
INSERT INTO sav_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓa woosa ɗe ne : « Ɓoo raak mbuuru yatuus na cuurund kanak dong ndii. » ");
INSERT INTO sav_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A loffa ɓa ne : « Komaat to ca. » ");
INSERT INTO sav_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A woosa mboolnda ne ɓa ɓoofaat ŋ kehƴi, ŋ ɗafuk paangfa, a ɓayya mbuuruuca yatuus ca na cuurund ca kanak ca, a taaknukka ŋ Eel ci, a corkiɗta Kooh. Ƴutta, a nguɗsohha ca, a eɗta taalubeeci ca, ɓeem paysohha mboolnda ca. ");
INSERT INTO sav_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓooɓa jen ñammba po kappa, ɓa ɓayndohha tasiɗ ca, ca nikee pañe ndaŋkiyaah na kanak (12). ");
INSERT INTO sav_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ƴaar ca ñamee nga nikeen ŋ ɓak junni-yatuus (5000), ɓaatta nga ɓitiɓ ca na komaakca. ");
INSERT INTO sav_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wa mboolnda ñam po ƴutta, Yeesu jaarra tufuk taalubeeciŋ ɗe ne ɓa adug ɗe, ɓa aas ŋ gaala, ɓa kaɗ ɓaka winooraŋ cookma, a yi ŋ haf ce, a woo na mboolnda ne ɓa haadaat. ");
INSERT INTO sav_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wa a cootiɗ mboolnda po ƴutta, a rappa ŋ tango a ɗaayya nga ne a kiim Kooh. Wa weka ree raak ɗe nga, kiik ce. ");
INSERT INTO sav_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waam raak gaala ŋ ɗooƴ cookma, puuɗsi yurhiɗkohha naa, ginaah ci laɓkeeɗa nga. ");
INSERT INTO sav_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ŋ wiisaaɗiina, Yeesu tiindeeɗa ŋ ɗafuk masma, a hayeeɗa ŋ taalubeeci. ");
INSERT INTO sav_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wa ɓa hot ɗe tiindeeɗa ŋ ɗafuk cookma, ɓa feyuusa, ɓa woyeeɗa ne : « A husiɗ ! » Ɓa tiitta, ɓa leehkeeɗa. ");
INSERT INTO sav_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yeesu arra ɓa woo ne : « Tokaat fit ciŋ ɗu, a ñam ; kinaat neƴƴoh ! » ");
INSERT INTO sav_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyeer loffa ɗe ne : « Kilifaani, nik ne a fu ɗah, woo so ŋ tiind ŋ ɗafuk masmi, ŋ hay nga ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu woosa ɗe ne : « Haya ! » Piyeer ruhussa ŋ gaala, cammba tiind ŋ ɗafuk masma ne a kaɗ ŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Waaye a hotta findi puuɗsa raakoh hatil, a neƴƴohha, a cammba diig ŋ masma, a leehukka an : « Kilifaani, naaf fo deey ! » ");
INSERT INTO sav_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeesu arra raɗis yaah, ammba ɗe, woosa ɗe ne : « Ƴaari yaf kosaaɗi, wa ye tah fu taastiɗohee ŋ haf fu ? » ");
INSERT INTO sav_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ƴutta ɓa rappa ŋ gaala, puuɗsa seemmba. ");
INSERT INTO sav_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taalubeeca nikee ŋ gaala ƴekka ŋ fiki Yeesu, ɓa woosa ne : « Wa keeh ne fu Kuɓkiŋ Kooh ! » ");
INSERT INTO sav_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wa ɓa reehiɗ ƴakaanduk cookma, ɓa teerra ŋ kur kaŋ Senesaret. ");
INSERT INTO sav_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓooɓa nikee ŋ ɗiska inhissa Yeesu, ɓa woosaa ŋ kur caŋ ɓak caam jen, a komuusa kosaayiɗ ca jen. ");
INSERT INTO sav_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓa kiimeeɗa ɗe ne ɓa laal lecmiŋ kulɓaakiŋ ɗe dong, te ɓooɓa laalee wa jen wireen jameet koreet. ");
INSERT INTO sav_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wa raakka mbeh, ɓi ɓo' ɓaah ŋ Farisen ca na ɓi jangɗohoh ŋ waasiŋMusaa pulohha Yerusalem hayya ɗiskiŋ Yeesu, ɓa woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","« Wa ye tah taalubeeciŋ ɗa na taambɗeeɗi mbaahiŋ caac ciŋ ɓoo ? Marka rek ! Ɓa hee ñame ɗah, ɓa na ɓohñukeeɗi findi mbaahi nakoha. » ");
INSERT INTO sav_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A loffa ɓa ne : « Moo ɗu, wa ye tah ɗu taambiɗɗi nakohiŋ Kooh, ɗu tumohee findi mbaahiŋ ɗu woyoh ? ");
INSERT INTO sav_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ŋ hot Kooh woyiɗ ne : “ Eɗa yaay ɗu na baab ɗu cir. ” A woyissiɗ ne : “ Ɓo' nu kiimiɗ yaay ɓa wala baab ɓa moɗaaɗi ɗah, a apaah apu. ” ");
INSERT INTO sav_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Waaye ɗu, ɗu na jangɗohe ne ɓo' miniɗ woo baab ɓa wala yaay ɓa ne : “ Ini ŋ joyee ɗa eɗ, ŋ eɗohiɗa wuu Kooh. ” ");
INSERT INTO sav_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jaar ɗu hondoh ɗe taambkoh yaay ɓa na baab ɓa, a eɗuu ɓa cir. Ɗu na heefohe woo kiŋ Kooh ɗaa, sagu taambiɗ mbaahiŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naafeehaaci ! Woo kiŋ Kooh wi woosuuɗi Esayi woyee nga ɗu wii, wa keeh an : ");
INSERT INTO sav_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ Cuuɓii, eɗiŋ ɓa na so cir top ŋ nguɓ ciŋ ɓa ; keeñ ciŋ ɓa usiɗ to lool. ");
INSERT INTO sav_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɓa na ñaamkee so ŋ ɓarang ɓarang ; ɓa na jangɗohe nakoh ciŋ ɓo' ci po mand haa ne mi yi Kooh ñam nakoh ca. ” » ");
INSERT INTO sav_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wa Yeesu ƴut ɓa lof, a ɓeeɗukka mboolnda, a woosa ɓa ne : « Sikɗukaat te ɗu inah inii : ");
INSERT INTO sav_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ini na aase ŋ nguɓiŋ ɓoyi, weɗ na ɓekee ɗe hoolaaɗi haa, waaye a wi na pulohe nga weɗ na ɓekee ɗe hoolaaɗi. » ");
INSERT INTO sav_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Weɗ taalubeeciŋ ɗe reɓoh nga ɗe, woosa ɗe ne : « Andi fu inhiɗ ne woo keem, mand na ɓaseeh ŋ Farisen ci ? » ");
INSERT INTO sav_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A loffa ɓa ne : « Kidig nu Baabiŋ ngo yi nik ŋ Eel ci yipɗi ɗah, wa hey ɗofse. ");
INSERT INTO sav_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Faɗaat ɓa, ɓa fuuliɗ, te ɓa na nooke fuuliɗ ; te fuuliɗ nookee fuuliɗ morom ce ɗah, ɓa kanak jen, ɓa hey keene ŋ nung. » ");
INSERT INTO sav_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyeer woosa ɗe ne : « Teeɓa ɓoo ini woo ki señci tokis. » ");
INSERT INTO sav_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeesu loffa ɗe ne : « Ɗu sah, ɗu raakɗi liiɓohaaɗ moɗiɗ poyi e ? ");
INSERT INTO sav_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɗu inahɗi ne in nu aas ŋ nguɓ ɗah, wa na kaɗe ŋ rook, ƴut ɗah wa bilafsuku e ? ");
INSERT INTO sav_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Waaye ini puloh ŋ nguɓi, wa kurkoh ŋ keeñi te ineem weɗ na ɓeke ɓo' hoolaaɗi. ");
INSERT INTO sav_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Laam in cii na pulohe ŋ ɗooƴ keeñ : Liiɓohaaɗ moɗaaɗi, ap ɓo', njaaloo, faankoh sangohuuɗ, rok, leyɗoh ɓo', na ɗooɓoh. ");
INSERT INTO sav_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E in ceem ceɗ na ɓeke ɓo' hoolaaɗi ; waaye ñam te fu ɓohñukɗi, wa na hoolaaɗi'ɗeeɗi ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeesu pulohha ndaam, a kaɗta ɓak caŋ Tiir na Sidoon. ");
INSERT INTO sav_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wa raakeen ɓitiɓ nga, a ɓaahee ŋ Kanaan ci, a pulohee kur ceem, a hayya, a leehkeeɗa an : « Ŋ miskaat ɗa Kilifaani, setiŋ Dawuuda ! Kuɓkiŋ ngo cafƴi, a jiini amb ɗe, a yaaɓɗiɗ ɗe lool ! » ");
INSERT INTO sav_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Waaye Yeesu lofɗi ali in ; taalubeeci reɓpa ŋ Yeesu, ɓa woosa ɗe ne : « Woyaa ɗe a coot book, a yii taambiɗ ɓoo na leehkiŋ ɗe rek. » ");
INSERT INTO sav_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu woosa ne : « Kooh woos so ŋ mbaal ciŋ ɗe muuƴiɗ ci dong, Israayel ci. » ");
INSERT INTO sav_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Waaye ɓitɓa hayya ƴekka ŋ kot ciŋ ɗe, woosa ɗe ne : « Ɓaatɗoh ho rek Kilifaani ! » ");
INSERT INTO sav_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu loffa ɗe ne : « Wa waas haa ɓuu ci na koɗse teengu kañam kiŋ komaakci. » ");
INSERT INTO sav_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɓitɓa woosa ɗe ne : « Kilifaani, fu woo keeh waaye, ɓuu ci na koɗse na name ñam ŋ ñamohiiciŋ heɗ ca, ci na keene ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ŋ ineem Yeesu woosa ɗe ne : « Ɓitɓi, kosi fu kos yakiɗ ! Wa raakohaat ɗaa findi fu waaɗoh. » Ŋ wahtuunaam, kuɓkaŋ ɗe wirra. ");
INSERT INTO sav_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wa Yeesu kurkoh ndaam, a kaɗta ɓakaŋ Cookmaŋ-Galile, a rappa ŋ ɗafuk tango, a ɓooffa. ");
INSERT INTO sav_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Weɗ mboolo yakak hayoh nga ɗe, ɓayya ɓi lafañ, na ɓi fuuliɗ, ɓi ɓeendkiɗ, ɓi muum, na kosaayiɗ laayiɗ wiiriis, ɓa ɓayya ɓa ŋ fiki Yeesu, a wiriɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mboolnda feyuusa ŋ ina ɓa hot muum ca jombeeɗa, ɓeendkiɗ ca wirra, lafañ ca tiindeeɗa, fuuliɗ ca hoteeɗa ; ŋ ineem, ɓa yakɗeeɗa Koohiŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɓa nikka ndeem po Yeesu ɓeeɗukka taalubeeciŋ ɗe, a woosa ɓa ne : « Ɓooɓii miskiɗ to, neeh kaahay ceɗi cii ɓii na so, ɓa raakisɗi ali ñamaah te ŋ waaɗɗi ɓa cootiɗ rook ɓarang bala ɓa keenan ŋ waasi ɗah. » ");
INSERT INTO sav_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Taalubeeciŋ ɗe woosa ɗe ne : « Moo mboolo hend an, ɓoo ɓayohan mbuuruuci min ɓa kap nde ŋ bilaf fii ? » ");
INSERT INTO sav_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu meekissa ɓa ne : « Ɗu raak mbuuru hend na ? » Ɓa loffa ɗe ne : « Mbuuru yasna-kanak na ɓi cuurund ƴin ƴin, waaye ca laayɗi. » ");
INSERT INTO sav_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A woosa mboolnda ne ɓa ɓoofaat ŋ kehƴa, ");
INSERT INTO sav_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","a ɓayya mbuuruuca yasna-kanak ca na cuurund ca, a corkiɗta Kooh po ƴutta, a nguɗsoheeɗa ca, a eɗeeɗa taalubeeciŋ ɗe ca, ɓa eɗeeɗa mboolnda. ");
INSERT INTO sav_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓooɓa jen ñammba po kappa, tasiɗ ca nangɗohuusa, ca nikee dammba riifiɗ yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓooɓa ñamee nikee ƴaar junni-nikiis (4000) ɓaatta nga ɓitiɓ ca na komaakca. ");
INSERT INTO sav_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wa ɓa ƴut ñam, a woosa mboolnda ne ɓa haadaat, a aassa ŋ gaal, a kaɗta ɓakaŋ Magadan. ");
INSERT INTO sav_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɓi Farisen na Sadusen reɓpa, woyeeɗa na Yeesu. Ɓa markiskeeɗa ɗe, ɓa meekseeɗa ɗe ne a teeɓ ɓa firnde puloh ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A loffa ɓa ne : « Noh muyee te eel ci ruumndiɗee ɗah, ɗu na woye ne : “ Eel ci ruumndiɗ coy, wa hey neɓe ! ” ");
INSERT INTO sav_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wa nik na ɓaaɓ ɗah, ɗu woo ne : “ Wa ngaaɓiɗ, wa neɓanɗi. ” Ɗu minnda inhisoh findi eel ci na mande te ɗu minɗi inhisoh firndeeciŋ jamanooni ! ");
INSERT INTO sav_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɓooɓi woti ɓeɗ baahaaɗi, ɓa topɗi ŋ Kooh po haa njaalo'oh, an ɓa na meeksohe firnde ! Ɓa eɗsanɗi ali firnde ɗal wiŋ Yunus. » Ƴutta a faɗta ɓa ndaam, a cootta. ");
INSERT INTO sav_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wa taalubeeci kaɗee ŋ ɓaka winooraŋ cookma, ɓa alkoheen ɓayndoh mbuuru. ");
INSERT INTO sav_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu woosa ɓa ne : « Wortukaat lawiiriŋ Farisen ci na Sadusen ci ! » ");
INSERT INTO sav_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɓa woyeeɗa ŋ harmban ɓa ne : « A ini ɓoo ɓayɗi mbuuru weɗ tah. » ");
INSERT INTO sav_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Waaye Yeesu inahhaa, a woosa ɓa ne : « Cey, e ɗu kosaaɗi, wa ye tah ɗu woyee ŋ harmban ɗu an : “ A ini ɓoo raakɗi mbuuru ? ” ");
INSERT INTO sav_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɗu inahɗi poyi e ? Ɗu alkoh alkoh mbuuruuca yatuus ca paysohsee ɓooɓa junni-yatuus (5000) ca e, tasɗohiica ɗu ɓayndohee, ca nikee pañe hend na ? ");
INSERT INTO sav_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na mbuuruuca yasna-kanak ca paysohsee ɓooɓa junni-nikiis (4000) ca, tasɗohiica ɗu ɓayndohee, ca nikee dammba hend na ? ");
INSERT INTO sav_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tumoh na po ɗu minɗi inah ne mi na woye mbuuru haa ? Wortukaat lawiiriŋ Farisen ci na Sadusen ci ! » ");
INSERT INTO sav_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ŋ ineem, ɓa inahha ne a woyee ɓa ne ɓa wortuk lawiiriŋ mbuuruuci haa, waaye ne ɓa wortuk jangɗohiŋ Farisen ci na Sadusen ci. ");
INSERT INTO sav_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeesu kaɗta ɓak Seesare-Filip, wa a ree, a meekissa taalubeeciŋ ɗe ne : « Ɓooɓi na woye ne Kuɓkiŋ ɓoyi a yi ɓa ? » ");
INSERT INTO sav_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓa loffa ɗe ne : « Raakiɗ ɓi na woye ne a fu Yahya Ɓoktohi, ɓum na woye ne a fu Ilyas, ɓinooɓi woyee ne a fu Yeremi wala woosuuɗ wiiriis ŋ ɓa ɗeɓgaan. » ");
INSERT INTO sav_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu meeksissa ɓa ne : « Moo nga ɗu nak, a mi ɓa ? » ");
INSERT INTO sav_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simong Piyeer loffa ɗe ne : « A fu Mucɗohi Gapohse, Kuɓkiŋ Koohi na pese. » ");
INSERT INTO sav_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeesu woosa ɗe ne : « Fu neɓɗiɗ Simong kuɓkiŋ Yoona, a ɓo' moondiɗ ɗa ini fu lof haa, waaye a Baabiŋ ngo yi ŋ Eel ci ! ");
INSERT INTO sav_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mi, ŋ woo ne a fu Piyeer, weɗ atoh ; ŋ hey yipe ɓi Janguuniŋ ngo findi taɓah ŋ atoh feem te doolndiŋ kakaan ki sah minɗanɗi wa ali in. ");
INSERT INTO sav_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ŋ hey ɗa eɗe caaɓeeciŋ Nguuriŋ-Ɗafki ; in nu fu sangoh ŋ kehƴi ɗah, wa hey nike ini Kooh sangoh ŋ Eel ci, te in nu fu teyɗuk ŋ kehƴi ɗah, wa hey nike ini Kooh teyɗuk ŋ Eel ci. » ");
INSERT INTO sav_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yeesu nakka taalubeeci ne ɓa kinaat woo ali ɓo' ne a yi Mucɗohi Gapohse. ");
INSERT INTO sav_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ini kooɗoh ndeem, Yeesu cammba woo woo jahran na taalubeeciŋ ɗe an : « Ŋ joyiɗ kaɗ Yerusalem, ŋ yaaɓ keeh-keeh ŋ yaah ciŋ yakak ci na kilifaaciŋ seeƴkiɗoh ciŋ waasiŋMusaa na jangɗohoh ciŋ wa, ŋ apu te ŋ hultiɗu ŋ neeha kaahayɗoh. » ");
INSERT INTO sav_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyeer gukka ɗe, ngaseeɗa ɗe an : « Kilifaani, Kooh mucɗaat ɗa nga ! Ineem rahsanɗi ɗa muk ! » ");
INSERT INTO sav_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Waaye Yeesu heelukka, woosa ɗe ne : « Kurka ndii, kaɗa ŋ finhooso, seytaaniini ! Fu na jaɗɗee so fiir. Liiɓohaaɗiŋ ɗa hunɗi na wiŋ Kooh, fu na liiɓe findi ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ƴutta, Yeesu woosa taalubeeciŋ ɗe ne : « Ɓo' nu waaɗ hun na so ɗah, a joyɗi liiɓ haf ce, a degkaat kurwaani aa hee daaƴohse, a ñaakiɗ to. ");
INSERT INTO sav_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Laam, ɓo' nu waaɗ muciɗ kiñin kiŋ ɗe ɗah, a heya ñake. Waaye ɓo' nu ñak kiñin kiŋ ɗe saguuso ɗah, a heya rahsisse. ");
INSERT INTO sav_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɓo' raak adinaani jen na in ci nik nga te a ñak kipes kiŋ ɗe, ineem raakiɗ ɗe winde njiriñ ? Ɓo' min romkoh kipes kiŋ ɗe na ye ? ");
INSERT INTO sav_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ee, Kuɓkiŋ ɓoyi hey hayisse na malaakaaciŋ ɗe, na yaki Baab ɓa yak, a hey atte'e yaa nu nga ngaŋ tumohaaɗ ciŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ñam na woyee ɗu wa te wa keeh, ɓi ɓo' ɓii ŋ ndii ɓa kaananɗi muk te ɓa hotɗi Kuɓkiŋ ɓoyi hayee findi buur. » ");
INSERT INTO sav_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wa degga neeh yasna-yino, Yeesu ɓayya Piyeer na Saak na Saaŋ taambɗoh Saak, a kaɗta ɗaaya na ɓa ŋ ɗafuk tango njooliɗ ; ");
INSERT INTO sav_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ndaam a ɓoƴsukka ŋ fikiiɓa, fikiiriŋ ɗe melciɗeeɗa findi nohi, kulɓaaciŋ ɗe nikka yaanow tar haa siñaar. ");
INSERT INTO sav_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɗekka po woosuuɗ kanak teeɓukka ɓa, ɓa nikee Musaa na Ilyas, ɓa woyeeɗa na ɗe. ");
INSERT INTO sav_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ŋ ineem, Piyeer woosa Yeesu ne : « Kilifaani, wa baahiɗ ne ɓoo nik ndii, fu waaɗa ɗah ŋ hey haɓɗe ndii ɗiip kaahay, winoori nik wiŋ ɗa, winni nik wiŋ Musaa, wi tas nik wiŋ Ilyas. » ");
INSERT INTO sav_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wa a na woye ineem, eel hayya nga ɓa, wa siñaarɗeeɗa siñaariɗ, wa ulla ɓa. Hooso kerhukka ŋ ɗooƴ eela an : « Yii a yi Kuɓkiŋ ngo ŋ waaɗ keeh-keeh, yi neɓ po ŋ keeñ. Sikɗukaat ɗe ! » ");
INSERT INTO sav_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wa taalubeeci nikee nga kerah woo keem, ɓa tiitta keeh-keeh, ɓa keennda, ɓa ruɗta fikiiciŋ ɓa ŋ kehƴi. ");
INSERT INTO sav_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeesu reɓpa laalla ɓa, a woosa ɓa ne : « Kurkaat, kinaat tiit ! » ");
INSERT INTO sav_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Weɗ ɓa markoh, ɓa hotɗi ali ɓo' ɗal Yeesu kiik ce njong. ");
INSERT INTO sav_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wa ɓa ruhsee tangoora, Yeesu dennga ɓa ne : « Ini ɗu hot wii kinaata woo ali ɓo' po Kuɓkiŋ ɓoyi hultiɗu. » ");
INSERT INTO sav_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɓa meekissa ɗe ne : « Wa ye tah jangɗohoh ciŋ waasiŋ Musaa woyee ne Ilyas joyiɗ hayis paaɗ ? » ");
INSERT INTO sav_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A loffa ɓa ne : « Ee ! Ilyas joyiɗ hay ne a doknoh in ci jen po ca yurah. ");
INSERT INTO sav_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Waaye mi na woyee ɗu ne Ilyas hayiɗ, ɓooɓi inhisɗi ɗe, ɓa tummba ɗe ini neɓ ɓa, ɓa na hee name torhiɗoh Kuɓkiŋ ɓoyi ɗaa. » ");
INSERT INTO sav_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋ ndeem, ɓa inahha ne a na woyee ɓa Yahya Ɓoktohi. ");
INSERT INTO sav_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wa ɓa kaɗ po ɓa reɓgoheeɗa mboolnda, raakka ƴaari hay, ƴekka ŋ fiki Yeesu, ");
INSERT INTO sav_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","woosa ɗe ne : « Kilifaani, kuɓkiŋ ngo ƴaari miskaat ɗa, a raak kombeɗ-mbeɗ, wa yaaɓɗiɗ ɗe lool, a na gene keen ŋ yongkaah wala masuɓ. ");
INSERT INTO sav_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ŋ ɓayiɗ ɗe ŋ taalubeeciŋ ɗa, waaye ɓa minɗi ɗe wiriɗ. » ");
INSERT INTO sav_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeesu woosa ne : « Ɗu ɓi ɓooɓi woti-woti e ɗu kosaaɗi, ɗu yahukka, ŋ nikan nik na ɗu, ŋ muñɗee ɗu po kiɗa ? Komaat to ɗe ndii. » ");
INSERT INTO sav_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeesu ngassa jiinnda ambee njaanja, jiinnda pulla, njaanja wirra ŋ ɗiska ɗiska. ");
INSERT INTO sav_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wa taalubeeci ɗaay na Yeesu, ɓa reɓpa nga ɗe, ɓa meekissa ɗe ne : « Wa ye tah po ɓoo minɗi aañ jiinnda ? » ");
INSERT INTO sav_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A loffa ɓa ne : « E kosi ɗu kos ƴissuut weɗ tah. Ñam na woyee ɗu wa te wa keeh, ɗu raak kos hend na kuɓu mutarda ƴissuut, ɗu woo tangoorii ne wa kurkaat ndii, wa kaɗ nden ɗah, wa hey kaɗe ; ali in wooñanɗi ɗu.  ");
INSERT INTO sav_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21"," » ");
INSERT INTO sav_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wa raakka mbeh, Yeesu na taalubeeciŋ ɗe nikka ŋ Galile. A woosa ɓa ne : « Kuɓkiŋ ɓoyi hey degse ŋ yaah ciŋ ɓooɓi, ");
INSERT INTO sav_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɓa ap ɗe, a hultiɗu ŋ neeha kaahayɗoh. » Wa ɓa kerah woo keem, ɓa soossa sem. ");
INSERT INTO sav_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wa Yeesu na taalubeeciŋ ɗe ree Kapernawum, ɓooɓa meeksohee lempoonaŋ Kahan Kooh yurhiɗta ŋ Piyeer, ɓa woosa ɗe ne : « Jangɗohohiŋ ɗu eɗohanɗi lempooniŋ Kahan Kooh e ? » ");
INSERT INTO sav_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyeer woosa ɓa ne : « Aha'kay ! » Wa a ree kahna, bala a woyan ɗah, Yeesu woosa ɗe ne : « Simong, fu liiɓ ye nga ? Buur ciŋ Adina ɓa na meekse ɓinde juuti mbaa lempo ? Kuɓuuciŋ ɓa wala jaambur ci ? » ");
INSERT INTO sav_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A loffa ɗe ne : « Jaambur ci. » Yeesu woosa ɗe ne : « Kon kuɓuuci ɓaahɗi nga. ");
INSERT INTO sav_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Waaye ne ɓoo sang ɓa ɓek liiɓohaaɗ moɗaaɗi, kaɗa cookma, fu ree ɗah, fu njaf ostukohaani, fu nook cuurndi kocan hay, fu rangis nguɓiŋ ɗe ɗah, fu hey raake hanjar yino nga ; ɓayaa, fu eɗ ɓa wa, wa nik wirndiŋ lempooniŋ ngo na wiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Waam weɗ taalubeeci reɓoh ŋ Yeesu, ɓa meekissa ɗe ne : « Ya ɓa uup ngaŋ Nguuriŋ-Ɗafki ? » ");
INSERT INTO sav_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A ɓeeɗukka komaaki ƴin, a tufkiɗta ɗe ŋ leerooɓa, ");
INSERT INTO sav_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a woosa ne : « Ñam na woyee ɗu wa te wa keeh, ɗu ɓoƴsohɗi mandohaaɗ po ɗu mand na komaaki ɗah, ɗu aasanɗi ŋ Nguuriŋ-Ɗafki. ");
INSERT INTO sav_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Weɗ tah, yaa nu ruhsiɗ haf ce po haa komaakndii ɗah, a yi uupan ŋ Nguuriŋ-Ɗafki. ");
INSERT INTO sav_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te yaa nu teyɗuk njaanj findi yii saguuso ɗah, a teyɗuk ko. ");
INSERT INTO sav_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yaa nu bakaaɗɗukoh yino ŋ komaakci ƴin ci kos so ɓii ɗah, ini hee ngisohe nga ɗe, weɗ ne a toku atoh ɓitiɗ ŋ mbooh, a diigɗu ŋ ɗiska uup nooɗ ŋ cookma. ");
INSERT INTO sav_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mas adinaani ! In ci na ɓaye ɓo' bakaaɗ laayiɗ ! Te ca minɗi nik raakaaɗi waaye mas ɓoyi na hee ca ɓeke ! ");
INSERT INTO sav_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yaahiŋ ɗa wala kotiŋ ɗa waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nguɗaa ca, fu mbet ca usiɗ ; aas ŋ kipes ki na yaah yino wala kot yino, weɗ ngisoh fu njafu na kot ciŋ ɗa kanak ci wala yaah ciŋ ɗa kanak ci ŋ yongkaaha ƴimanɗi muk. ");
INSERT INTO sav_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hasiŋ ɗa waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nihsaa, fu mbeta usiɗ ; aas ŋ kipes ki na has yino weɗ ngisoh fu njafu na has ciŋ ɗa kanak ci ŋ yongkaaha yakka. ");
INSERT INTO sav_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kinaat heef ali yino ŋ ɓi ƴissuut cii ! Ee, ñam na woyee ɗu wa, malaakaaci na niiɗee ɓa nik ŋ Eel ci na gene hot jahran Baabiŋ ngo yi nik nga.  ");
INSERT INTO sav_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɗu liiɓ ye ŋ inii ? Ɓo' raak mbaal teemet (100), yino muuƴ nga ɗah, a faɗanɗi ndaŋkiyaah-yasna-nikiis na yasna-nikiis ci (99) ŋ tangoora a kaɗ waaka yi muuƴ e ? ");
INSERT INTO sav_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ñam na woyee ɗu wa te wa keeh, a hot ɗe ɗah, sumi a suman nga, weɗ uupan wi a sum ŋ ndaŋkiyaah-yasna-nikiis na yasna-nikiis ci muuƴaaɗiici. ");
INSERT INTO sav_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wa mand ɗaa, Baabiŋ ɗu yi nik ŋ Eel ci waaɗɗi ne ali yino ŋ ɓi ƴin cii muuƴ. ");
INSERT INTO sav_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ɓaah fu bakaaɗ nga ɗa ɗah, kaɗa nga ɗe kiik fu, fu woo na ɗe. A kerhiɗ ɗa ɗah, fu raakiɗ keeñiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A kerhiɗɗi ɗa ɗah, huna na ɓo' yino wala kanak, fu kaɗis nga ɗe. Laam, Fiis ci woo ne : “ Seede kanak wala kaahay raak ɗah, in nu nik miniɗ tufkiɗu. ” ");
INSERT INTO sav_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A sang ɓa kerhiɗ ɗah, woyaa ɓooɓiŋ Janguuni. A sang kerhiɗ Janguuni ɗah, ambaa ɗe findi kosaaɗi na juuti'oh. ");
INSERT INTO sav_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ñam na woyee ɗu wa te wa keeh : In nu ɗu sangoh ŋ kehƴi ɗah, wa hey nike ini Kooh sangoh ŋ Eel ci, te in nu ɗu teyɗuk ŋ kehƴi ɗah, wa hey nike ini Kooh teyɗuk ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ñam woyis ɗu wa te wa keeh : Ɓo' kanak kerhiɗoh nga ɗu ndii, ŋ kehƴi, ne ɓa kiim Kooh ŋ in nu wa min nik ɗah, Baabiŋ ngo yi nik ŋ Eel ci hey ɓa wa haɓɗiɗe. ");
INSERT INTO sav_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Laam ɗisik nu kanak mbaa kaahay coh ŋ tiikiŋ ngo ɗah, mi yii ŋ harmban ɓa. » ");
INSERT INTO sav_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Weɗ Piyeer reɓoh ŋ Yeesu, a meekissa ɗe ne : « Kilifaani, ɓaah ho tumee so in ɗah, ŋ joy ɗe ɗaas po waas hend na ? Waas yasna-kanak e ? » ");
INSERT INTO sav_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu loffa ɗe ne : « Ŋ wooɗi ɗa waas yasna-kanak rek waaye, waas ndaŋkiyaah-yasna-kanak waas yasna-kanak (70×7). ");
INSERT INTO sav_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Laam, Nguuriŋ-Ɗafki mand na inii : A nikee buur, a waaɗta ne dag ciŋ ɗe teeɓ ɗe ini a dengkohee ɓa. ");
INSERT INTO sav_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wi a camb, a komuusa dagi joy ɗe wirind saaku hanjar junni-ndaŋkiyaah (10.000). ");
INSERT INTO sav_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A minɗi ɗe wirind. Ŋ ineem buuri nakohha ne dagi toonsaat findi ñaam a yi na ɓitiice na kuɓuuciŋ ɗe na in ci a raak jen, a wirndohu kombot ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Waaye dagi ƴekka ŋ fiki kilifaaniŋ ɗe, a woosa ɗe ne : “ On ndo ƴissuut, ŋ hey ɗa ca wirnde jen ! ” ");
INSERT INTO sav_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A misikka kilifaani lool, yeem ɗaassa ɗe kombot ki, a faɗta ɗe, a cootta. ");
INSERT INTO sav_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wi dagi pul, a cohha na ƴaar ɓaah na ɗe panguk, yi joy ɗe wirind dinaar teemet (100) dong, a ammba ɗe, a ooƴca ɗe ; a woosa ɗe ne : “ Wirind ndo koporiŋ ngo ! ” ");
INSERT INTO sav_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ƴaari ƴekka ŋ fikiice kiimeeɗa ɗe an : “ On ndo ƴissuut rek, ŋ hey ɗa wirnde. ” ");
INSERT INTO sav_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Waaye dagi sannga tic, a taƴca ƴaari ŋ kaso, a sekeeɗa ne a wirind ɗe. ");
INSERT INTO sav_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dag ci ɓinooɓi hotta ini raak, wa misikka ɓa lool, ɓa kaɗta, ɓa naandsukka kilifaana findi wa raakoh jen. ");
INSERT INTO sav_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Weɗi kilifaaniŋ ɗe nakoh ɗe ɓeeɗkiɗu, a woosa ɗe ne : “ Fu dag añaandiɗ ! Fu ɗaasnukiɗ to po ŋ ɗaassa ɗa ini fu joyee so wirind jen. ");
INSERT INTO sav_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Morom fu joyeen ɗa nam misik findi fu miskohee so. ” ");
INSERT INTO sav_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kilifaani ayrukka, a taƴca daga ŋ kaso ne a mbugalu. Daga nikka nga, a sekeeɗa ne a wirind kombot kaŋ ɗe jen. » ");
INSERT INTO sav_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeesu degga nga ne : « Baabiŋ ngo yi ŋ Eel ci tumohan na ɓo' nu nga ɗu ɗaa ne ɗu ɗaasɗi morom ciŋ ɗu na keeñ soosiɗ ɗah. » ");
INSERT INTO sav_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wa Yeesu ƴut woo woo ceem, a kurkohha Galile, a kaɗta ɓakaŋ kur caŋ Yudee ŋ finho kalaŋ Yurdan. ");
INSERT INTO sav_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mboolo yakak ñaakiɗta ɗe nga, a wiriɗta kosaayiɗ caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisen ci hayya nga ɗe, ɓa waaɗta ɗe woyɗukoh woo uupiɗ, ɓa meekissa ɗe ne : « Andi waasi teyɗohiɗ ne, wa neɓ ƴaar ɗah, a miniɗ faɗ ɓitiice ŋ in na nu wa min ki nik ɗah ? » ");
INSERT INTO sav_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu loffa ɓa ne : « Wa mand haa ne ɗu jangɗi ŋ Fiis ci ne Kooh yi ferohi, wi a na fere ŋ camba, a fer ɓa ƴaar na ɓitiɓ ; ");
INSERT INTO sav_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","a woosa ne : “ Weɗ tah ƴaar hey saɓsukohe na yaay na baab, a ŋoɗ ŋ ɓitiice, jaar ɓa kanak, ɓa nik faan yino. ” ");
INSERT INTO sav_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mbaa, ɓa nikisɗi kanak, ɓa faan yino kotii. Kon, ini Kooh ambsoh, ɓo' kinaata saɓsoh. » ");
INSERT INTO sav_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓa woosa ɗe ne : « Moo wa ye tah Musaa nakohha ne ɓo' faɗe ɓitiice ɗah, a fiisɗaat ɗe kayti teeɓoh ne a faɗiɗ ɗe ? » ");
INSERT INTO sav_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A woosa ɓa ne : « E ndengi ɗu ndeng keeñ weɗ tah Musaa teyɗukiɗta ɗu ineem, wa nikoheeɗi ɗaa ŋ cambohaana. ");
INSERT INTO sav_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Waaye ñam na woyee ɗu ne : yaa nu saɓsukoh na ɓitiice te nikɗi ne yeem njaalo'ee njaaloo ; a ɓay ɓitiɓ wiiriis ɗah, a na njaalo'e. » ");
INSERT INTO sav_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Taalubeeci woosa ɗe ne : « Nik ne wa mand ɗaa ŋ ƴaar ɗah, e tokaaɗi ɓitiɓ ngisoh ! » ");
INSERT INTO sav_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A loffa ɓa ne : « E ɓooɓi jen minan teyɗuk ini maa hee woye wii haa, waaye e ɓi Kooh ona dong. ");
INSERT INTO sav_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Laam raakiɗ ɓi nga, ɓa na rimke rimuk na yoomkiŋ ɓa, ɓum nga a ɓo' na ɓucee ɓa, raakiɗ ɓi nga, ɓa na tokeeɗi ɓitiɓ sagu Nguuriŋ-Ɗafki. Ɓoyi min teyɗuk, teyɗukaat ini ŋ woo. » ");
INSERT INTO sav_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɓi ɓo' ɓayeeɗa ɗe ɓi komaaki ƴin ne a deg ɓa yaah ciŋ ɗe, a kiimiɗ ɓa. Waaye taalubeeciŋ ɗe ngaskeeɗa ɓooɓeem. ");
INSERT INTO sav_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A woosa ɓa ne : « Faɗaat komaakci, kinaat ɓa hondoh hay nga so, ɓooɓi mand na ɓa ɓeɗ raak Nguuriŋ-Ɗafki. » ");
INSERT INTO sav_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A degga ɓa yaah ciŋ ɗe po ƴutta, a kurkohha ndaam. ");
INSERT INTO sav_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Weɗ ƴaar reɓoh ŋ Yeesu, a woosa ɗe ne : « Jangɗohohi, ŋ joy ye haɓiɗ in baahiɗ ne ŋ min raak kipes ki heyɗi reehe ? » ");
INSERT INTO sav_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu loffa ɗe ne : « Wa ye tah fu meeksee so ŋ ini kaɗ ŋ baah ? A Yino dong baah te a Kooh. Fu waaɗ raak kipes ki keeh-keehi ɗah, taambɗa nakoh ci. » ");
INSERT INTO sav_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ƴaara woosa ɗe ne : « Ci nde nakoh ? » Yeesu woosa ɗe ne : « Fu apanɗi ɓo' ; fu njaaloo'anɗi ; fu rokanɗi ; fu woyɗanɗi ɓo' ini raakɗi ; ");
INSERT INTO sav_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","eɗa yaay ɗu na baab ɗu cir ; te fu waaɗ morom fu findi fu waaɗoh haf fu. » ");
INSERT INTO sav_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ƴaara woosa ɗe ne : « In ceem jen mi yii taambiɗ ca, ŋ taskohu ye wiiriis ? » ");
INSERT INTO sav_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu woosa ɗe ne : « Fu waaɗ mit ɗah, kaɗa fu toon ini fu raak, fu eɗa ñakiɗ ci te fu hey raake alal ŋ Eel ci. Ƴut ɗah, fu hay, fu ñaakiɗ to. » ");
INSERT INTO sav_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wa ƴaara kerah woo ceem, a cooteeɗa goyoh na goyoh, a nikee heɗ raak-raak. ");
INSERT INTO sav_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yeesu woosa taalubeeciŋ ɗe ne : « Ñam na woyee ɗu wa te wa keeh, wa yooɓɗi ne heɗ raak-raak aas ŋ Nguuriŋ-Ɗafki. ");
INSERT INTO sav_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ñam na woyissee ɗu ne ngeelemb taamb ŋ ngul kufic weɗ uup yooɓ heɗ raak-raak aas ŋ Nguuriŋ-Kooh. » ");
INSERT INTO sav_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wa taalubeeci kerah woo keem, wa feyya ɓa po ɓa inhisɗi ini ɓa haɓɗan, ɓa woosa ne : « Kon a ya ɓa min mucɗu ? » ");
INSERT INTO sav_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu marakka ɓa, woosa ɓa ne : « Wa wooñiɗ ɓo' waaye raakɗi ini wooñ Kooh. » ");
INSERT INTO sav_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ŋ ineem Piyeer woosa ɗe ne : « Moo ɓoo nak ? Ɓoo faɗiɗ in ciŋ ɓoo jen, ɓoo ñaakɗiɗ ɗa ; ɓoo raakan ye ŋ ineem ? » ");
INSERT INTO sav_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu loffa ɓa ne : « Ñam na woyee ɗu wa te wa keeh, mbehi in ci jen na hee ɓoƴsohse, wi Kuɓkiŋ ɓoyi na hee ɓoofohe ŋ ɓoofoha-buuri na teeɓohe yaki a yak, ɗu ɓi na ñaakɗee so, ɗu hey name ɓoof ŋ ɓoofoha-buur ndaŋkiyaah na kanak (12) ne ɗu adgoh cuuɓ ciŋ Israayel ndaŋkiyaah na kanak ci (12). ");
INSERT INTO sav_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te yaa nu faɗ kahan, wala taambɗoh ƴaar mbaa ɓitiɓ, baab, yaay, kuɓu, wala yohon saguuso ɗah, ini a ñak, a heya rahse ini uup waas teemet (100) te a hey raake kipes ki heyɗi reehe. ");
INSERT INTO sav_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Laayiɗ ŋ ɓi adug woti, ɓeɗ mirndohan, te laayiɗ ŋ ɓi mirndoh, ɓeɗ adgan. ");
INSERT INTO sav_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nguuriŋ-Ɗafki mand na inii : A nikee heɗ kahan, a kurukka na ɓaaɓ-teel ne a kooɗ ɓi ɓo' ɓi na hee ɗe pangkiɗe ŋ nguukiŋ reseñiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A woosa na ɓa po ɓa kerhiɗohha ne ɓa na hee ɗe hooɓkiɗe panguk, a wirind ɓa yaa nu nga ɗah hanjar haalis yino. Ƴutta, a tuuƴca ɓa nguuka. ");
INSERT INTO sav_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A pulissa ŋ yoor-yoor, a hotta ɓi pangkoh wiiriis ɓoofiɗ ŋ ɗiska na toonohse ŋ kur ka, haɓɗaaɗi in. ");
INSERT INTO sav_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A woosa ɓa ne : “ Kaɗaat ɗu nama panguk ŋ nguukaŋ ngo, ŋ hey ɗu wirnde ini ɗu joy wirndu. ” ");
INSERT INTO sav_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓeem kaɗta. A pulissa ŋ ɓak njooloor na ɓak tisbaar, a tumissa ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A pulissa ŋ ɓak takusaan, a raakissa ɓi ɓo' ŋ cohohaana, a woosa ɓa ne : “ Wa ye tah ɗu hooɓukka ɓoof ndii haɓɗaaɗi in ? ” ");
INSERT INTO sav_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓa woosa ɗe ne : “ Ali ɓo' kooɗɗi ɓoo ne ɓoo panguk. ” A woosa ɓa ne : “ Kon namaat kaɗ, ɗu pangka ŋ nguukaŋ ngo. ” ");
INSERT INTO sav_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wa niina ree, heɗ nguuka woosa ƴaara taambkohee in caŋ ɗe ne : “ Ɓeeɗka pangkoh ci, fu wirind ɓa ; camboha ŋ ɓi mirndoh hay po ŋ ɓi koc. ” ");
INSERT INTO sav_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɓa kooɗsee ŋ takusaana, kaɗta yaa nu nga ɗah, eɗuusa hanjar haalis yino. ");
INSERT INTO sav_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wa kaɗeeɗa po wa reesa ŋ ɓa kocee kooɗu, ɓa liiɓpa ne ɓeɗ uupɗan wirind, waaye yaa nu nga ɗah, nammba rahas hanjar yino. ");
INSERT INTO sav_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa ɓa eɗsee ca, ɓa ñaɗtukeeɗa ŋ heɗ nguuka ");
INSERT INTO sav_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","an : “ Ƴaaɓii ɓeɗ mirndoh hay, ɓa panguk wahtu yino dong, fu eɗee ɓa in hend na ini fu eɗ ɓoo te ɓoo hooɓuk yaaɓ na pangki na dohɗiŋ nohi ! ” ");
INSERT INTO sav_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Heɗ nguuka loffa yino nga ɓa ne : “ Ƴaariŋ ngo, ŋ tooñɗi ɗa. Ɓoo kerhiɗohee ne mi na hee ɗa wirnde hanjar yino haa e ? ");
INSERT INTO sav_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mbaa ɓaya ini fu raak te fu coot ; ŋ waaɗa waaɗ, ŋ eɗta ƴaari mirndoh hay in hend na ini ŋ eɗ ɗa. ");
INSERT INTO sav_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Andi ŋ minɗi minɗi tum ini ŋ waaɗ na raak-raakiŋ ngo ? Wala wa siis amb ɗa ŋ baahi ŋ baah ? ” » ");
INSERT INTO sav_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeesu degga nga ne : « Ɓi mirndoh adgohan ɗaa, ɓi adug mirndoh. » ");
INSERT INTO sav_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wa raakka mbeh, Yeesu kaɗeeɗa Yerusalem, a ɓeeɗukka taalubeeci ndaŋkiyaah na kanak ci (12) kiik ɓa, a woosa ɓa ŋ waasa ne : ");
INSERT INTO sav_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","« Ɗu hot nga, ɓoo ɓii kaɗ Yerusalem, Kuɓkiŋ ɓoyi hey faɗse ŋ yaah ciŋ kilifaaciŋ seeƴkiɗoh ciŋ waasiŋMusaa na jangɗohoh ciŋ wa ; ɓa hey ɗe atte'e ne a apu. ");
INSERT INTO sav_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓa eɗ ɗe ɓooɓi nikɗi Yawuut ne ɓa njembit ɗe, ɓa laɓ ɗe leraw, ɓa daaƴ ɗe ŋ kurwaa, ŋ neeha kaahayɗoh, a hultiɗu. » ");
INSERT INTO sav_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Weɗi yaayiŋ kuɓuuciŋ Sebede reɓoh ŋ Yeesu. A hunee na ɓa, a ƴekka ŋ fiki Yeesu ne a kiim ɗe in. ");
INSERT INTO sav_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu woosa ɗe ne : « Fu waaɗ ye ? » A woosa ɗe ne : « Woya ne fu kaɗ po fu nik buur ɗah, a kuɓuuciŋ ngo kanak cii daran ɗa, yino lah ɗa yaah-ñaahum, yi tas lah ɗa yaah-sing. » ");
INSERT INTO sav_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu loffa ne : « Ɗu inahɗi ini ɗu na kiime. Ɗu miniɗ an ŋ kaasiŋ miskiɗi maa hee ane e ? » Ɓa woosa ɗe ne : « Ee ɓoo miniɗa. » ");
INSERT INTO sav_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A woosa ɓa ne : « Wa keeh ne ɗu hey ane ŋ kaasiŋ ngo, waaye ini kaɗ ŋ yi lahan ndo yaah-ñaahum na sing, e ñam woyan ɓa haa, e ɓooɓi Baabiŋ ngo kooɗkiɗa ɓeɗ eɗsana. » ");
INSERT INTO sav_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wa taalubeeca ndaŋkiyaah ca ɓinooɓa kerah ineem, ɓa ayrukka ɓa kanak ca. ");
INSERT INTO sav_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Waaye Yeesu ɓeeɗukka ɓa jen, woosa ɓa ne : « Ɗu inhiɗ ne ɓooɓi adgoh kur ci na degee deg ɓooɓiŋ ɓa yaah, ɓooɓi uupiɗ hatil uupohee doole. ");
INSERT INTO sav_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wa joyɗi nikoh ɗaa nga ɗu ; ɓo' nu waaɗ nik ɓo' yakak nga ɗu ɗah, a teyɗukaat nik surgaaniŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te ɓo' nu waaɗ adug nga ɗu ɗah, a teyɗukaat nik ñaamiŋ ɓi tas nga ɗu. ");
INSERT INTO sav_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Findi Kuɓkiŋ ɓoyi, a hayɗi ne a raak surga, a hay ne a nik surga te a eɗoh kipes kiŋ ɗe ne a tos ɓo' laayiɗ. » ");
INSERT INTO sav_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wa ɓa aas Yeriko po ɓa puleeɗa, mboolo yakak ñaakiɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wa raakeen fuuliɗ kanak ɓoofiɗ ŋ mbeeddaana, ɓa kerahha ne a Yeesu na taambe, ɓa leehkeeɗa an : « Kilifaani, setiŋ Dawuuda, ɓoo miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mboolnda ngaskeeɗa ɓa ne ɓa ɗek. Waaye ɓa uupeeɗa leehuk ŋ ɗafka an : « Kilifaani, setiŋ Dawuuda, ɓoo miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeesu tufukka, ɓeeɗukka ɓa woosa ɓa ne : « Ɗu waaɗ ne ŋ haɓɗiɗ ɗu ye ? » ");
INSERT INTO sav_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓa woosa ɗe ne : « Kilifaani, has ciŋ ɓoo rangsukaat ! » ");
INSERT INTO sav_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɓa misikka Yeesu lool, a laalla has ciŋ ɓa, ŋ ɗiska ɗiska ɓa hoteeɗa. Ƴutta ɓa ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeesu na taalubeeciŋ ɗe taalndiɗta ŋ waas Yerusalem. Wa ɓa kaɗ po ɓa heeɗa ree, teemb kur kaŋ Betfase, ŋ sero Tangooraŋ-Oliiw-ca, Yeesu woossa kanak nga ɓa. ");
INSERT INTO sav_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A woosa ɓa ne : « Kaɗaat ŋ kur ki ŋ fikiiɗu wii, ɗu ree rek ɗah, ɗu hey hote mbaam riɓ tokuuɗ nga na cumbriŋ ɗe. Toksaat ca, ɗu kom mbo ca ndii. ");
INSERT INTO sav_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te ɓo' meekis ɗu ɗah, woyaat ɗe ne : “ A kilifaani etoh ca. ” Ŋ ineem, a jaaran ɗu faɗ ɗu hay na ca. » ");
INSERT INTO sav_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ineem raakka ne ina woosuuɗa woyee raak : ");
INSERT INTO sav_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","« Woyaat kur kiŋ Siyong ne : “ Buuriŋ ɗa yii hay nga ɗa, a ruhsiɗiɗ haf ce, a rap mbaam, cumbur mbaam, ɗoopaat sifoh. ” » ");
INSERT INTO sav_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Taalubeeca kanak ca kaɗta, ɓa haɓiɗta ina Yeesu nakee ɓa. ");
INSERT INTO sav_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓa ɓayya mbaama na cumbra, ɓa raɗta kulɓaacaŋ ɓa nga ca, Yeesu rappa. ");
INSERT INTO sav_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɓo' laayiɗ ŋ mboolnda raɗiɗta ɗe kulɓaacaŋ ɓa ŋ waasa ; ɓum raɗɗeeɗa ɗe na saaf ciŋ kidig ci ɓa piike. ");
INSERT INTO sav_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mboolnda hunnda kaɗeeɗa, ɓum adugka Yeesu, ɓum ñaakeeɗa nga ɗe ; ɓa woyeeɗa ŋ ɗafka ne : « Hosaana setiŋ Dawuuda ! Ɓoyi na haye ŋ tiikiŋ Heɗi, a raakaat barke ! Hosaana ŋ jol jol ɗafka ! » ");
INSERT INTO sav_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wa Yeesu aasee Yerusalem, kur ka jen yoondeeɗa yoond, ɓa woyeeɗa ne : « Ya ɓa yii ? » ");
INSERT INTO sav_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mboolnda loffa ne : « A Yeesu, Woosuuɗiŋ Kooh, yi puloh Nasareet ngaŋ Galile. » ");
INSERT INTO sav_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Wa Yeesu ree, a aassa ŋ Kahan Kooh, a aannja toonoh ca na romoh ca nikee nga jen, a folla taaɓul caŋ wecce'oh ca, na ɓoofohaacaŋ toonoh banuut ca. ");
INSERT INTO sav_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A woosa ɓa ne : « Kooh woyiɗ ŋ Fiis ci Hooliɗ ci ne : “ Kahan ndo teeksan kahan kiimoha Kooh, ” waaye ɗu tumiɗa ɗembohaaniŋ rokoh ci. » ");
INSERT INTO sav_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɓi fuuliɗ na ɓi yiiɓoh hayya nga ɗe ŋ Kahan Kooh, a wiriɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa na jangɗohoh caŋ wa hotta in ca feyohiɗ ca a haɓiɗ na leehka komaakca leehkee ŋ ɗooƴ Kahan Kooh an : « Hosaana setiŋ Dawuuda ! » Ɓa ayrukka, ");
INSERT INTO sav_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ɓa woosa Yeesu ne : « Fu kerhiɗ ini ɓa na woye e ? » A loffa ɓa ne : « Ee, ŋ kerhiɗa, waaye hanaa ɗu moosɗi jangoh inii ŋ Fiis ci : “ Fu tumiɗ po komaakci ƴin ci na gooy ci ɓa ɗii ƴeek ɗa. ” » ");
INSERT INTO sav_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ƴutta, a faɗta ɓa ndaam, a pulla kur ka, a kaɗta Betani, a neehha nga. ");
INSERT INTO sav_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wa Kooh wiis na ɓaaɓa, a dokkisseeɗa kur-taaha, a aɗukka. ");
INSERT INTO sav_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A hotta tas ndun ŋ sero waasa, a reɓpa nga waaye a hotɗi ali in nga ɗal saaf. A woosa nduna ne : « Fu heyɗi rimisse muk ! » Ŋ ɗiska ɗiska, nduna suyya. ");
INSERT INTO sav_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wi taalubeeci hot ineem, ɓa feyuusa, ɓa woosa ne : « Wa min na nikoh nduni suy ŋ ɗiski ɗiski ? » ");
INSERT INTO sav_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu loffa ɓa ne : « Ñam na woyee ɗu wa te wa keeh, ɗu kos te ɗu raakɗi liiɓ kanak nga ɗah, ɗu hey haɓɗe ini ŋ haɓiɗ nduni, ali ɗu woo sah tangoorii ne wa kurkaat ndii, wa kaɗ keena ŋ cookma ɗah, wa hey raake. ");
INSERT INTO sav_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","In nu ɗu kiim Kooh na kos ɗah, ɗu hey wa rahse. » ");
INSERT INTO sav_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wa Yeesu kaɗ po a aassa ŋ Kahan Kooh, kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na yakak ca hayya nga ɗe, wa raak ɗe jangɗoheeɗa, ɓa woosa ɗe ne : « In ci fu na haɓɗe, fu gaƴuk nde po fu kaannja ca haɓiɗ ? Ya ɓa tufkiɗ ɗa po fu haɓɗee ca ? » ");
INSERT INTO sav_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A loffa ɓa ne : « Ŋ hey ɗu name meekis in yino, ɗu lof fo ɗah, ŋ nam ɗu woo ini tufkiɗ to po ŋ haɓɗee in cii. ");
INSERT INTO sav_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ya ɓa tuuƴee Yahya ne a ɓoktoh, a Kooh wala ɓi ɓo' ? » Ɓa woyeeɗa ŋ harmban ɓa ne : « Ɓoo woo ɗe ne Kooh a yi woos Yahya ɗah, a na hee ɓoo woye ne : “ Wa ye tah ɗu kosɗi ɗe ? ” ");
INSERT INTO sav_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te ɓoo woo ne, e ɓi ɓo' tuuƴ ɗe ɗah, a', mboolndi cariɗ neƴƴoh. Ɓa jen ɓa amb ne Yahya nikee woosuuɗ. » ");
INSERT INTO sav_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Weɗ ɓa lofoh ɗe ne : « Ɓoo inahɗi. » Yeesu nammba ɓa woo ne : « Ŋ namanɗi ɗu woo ini tufkiɗ to po ŋ haɓɗee in cii. » ");
INSERT INTO sav_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu woyissa ɓa ne : « Ɗu liiɓ ye ŋ naandsukii ? A nikee ƴaar, a raakka komaaki ƴaar kanak, a woosa yi koc ne : “ Kuɓu, woti kaɗa fu pangka ŋ yohnaŋ reseñaŋ ngo. ” ");
INSERT INTO sav_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kuɓka loffa baab ɓa ne : “ Ŋ heyɗi kaɗe. ” Waaye, wa degga ƴissuut, inwaaso ammba ɗe, a kaɗta. ");
INSERT INTO sav_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A kaɗissa ŋ yinoora, a woyissa ɗe ineem. Yeem loffa ɗe ne : “ Ee baab, ŋ hey kaɗe. ” Waaye, a kaɗɗi. » ");
INSERT INTO sav_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeesu meekissa kilifaaca ne : « Komaakci kanak ceem, a yinde tum waaɗ-waaɗiŋ baab ɓa nga ɓa ? » Ɓa loffa ɗe ne : « A yi koc. » Yeesu woosa ɓa ne : « Ñam na woyee ɗu wa te wa keeh, juuti'oh ci na toonkoh ci ɓa ɗaa adug ɗu ŋ Nguuriŋ-Kooh. ");
INSERT INTO sav_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Laam Yahya hayiɗ, a teeɓohha waasi yurhiɗi ; ɗu kosɗi ɗe. Waaye juuti'oh ci na toonkoh ci kosiɗ ɗe te ɗu hotiɗ ŋ ineem waaye poyi ɗu ɓoƴsohɗi pesohaaɗ ne ɗu kos ɗe. ");
INSERT INTO sav_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sikɗukaat andiin wiiriis an : A nikee heɗ kahan, a yippa yohon reseñ. A ɗinngaa po wa willa, a acca nung pooƴoha reseña nga, a haɓiɗta paraang niiɗohaa wa. Ƴutta, a hanndaa deg ŋ yaah ɓi guuroh reseñ ne wa ruund ɗah ɓa paysoh ; a ɓaaɓpa. ");
INSERT INTO sav_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wa nguɗaŋ reseña ree, a tuuƴca ñaam ciŋ ɗe ŋ guuroh ca ne a rahas ɓakiŋ ɗe ŋ reseñi. ");
INSERT INTO sav_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Guuroh ca ammba ñaam ca ; ɓa laɓpa yi, ɓa appa yum, ɓa tapsohha ya tas atoh. ");
INSERT INTO sav_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A tuuƴissa ɓi ñaam wiiriis, ɓi uup laay ɓa koc, waaye guuroh ca tummba ɓa ina ɓa tumee ɓen rek. ");
INSERT INTO sav_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ŋ mirndaani, a woossa kuɓkiŋ ɗe, a woosa ŋ haf ce ne : “ Ɓa hey supke kuɓkiŋ ngo. ” ");
INSERT INTO sav_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Waaye wa guuroh ca hot kuɓka, ɓa woosa harmban ɓa ne : “ Lamohiŋ yohni a yi ! Hayaat ɓoo ap ɗe, ɓoo raak lamaahiŋ ɗe. ” ");
INSERT INTO sav_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɓa ɓayya ɗe, ɓa puliɗta ɗe yohna, ɓa appa ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ŋ ineem, Yeesu woosa ne : « Heɗ yohniŋ reseñi hay ɗah, a tuman guuroh ceem na ? » ");
INSERT INTO sav_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kilifaacaŋ Yawuut ca loffa ɗe ne : « Ɓooɓi baahaaɗiiceem, a hey ɓa ape fut, a deg yohna ŋ yaah ɓi guuroh wiiriis, ɓi eɗan ɗe ini a raak nga ŋ jamanoonaŋ wa. » ");
INSERT INTO sav_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeesu woosa ɓa ne : « Mand haa ne ɗu moosɗi jangoh ini Fiis ci Hooliɗ ci woo wii : “ Atoh fi taɓahoh ci mbetee mirndohiɗ nik atoh fi amb taɓahi. Wa puloh ŋ Heɗ ɓoo, wa in feyohiɗ nga ɓoo. ” ");
INSERT INTO sav_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Weɗ tah, ñam na woyee ɗu ne : Nguuriŋ-Kooh hey teyse ŋ yaah ɗu, cuuɓ wiiriis wi eɗohan rim ciŋ wa, hey wa eɗse.  ");
INSERT INTO sav_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɓo' nu keen ŋ atoh feem ɗah, a hey weersukohe te ɓo' nu wa keen ŋ ɗafuk ce ɗah, wa hey ɗe ruñuɓsohe. » ");
INSERT INTO sav_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kilifaacaŋ seeƴkiɗoh ca na Farisen ca marakka woo ka, ɓa inahha ne Yeesu woyee ini kaɗ nga ɓa ŋ andiin ca. ");
INSERT INTO sav_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓa waakeeɗa findi ɓaa hee ɗe ambohe, waaye ɓa neƴƴoheen mboolnda, laam ɓeem ambee ɗe findi Woosuuɗ. ");
INSERT INTO sav_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu kooɗissa woo ka, a woyisseeɗa na ɓa ŋ andiin an : ");
INSERT INTO sav_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","« Nguuriŋ-Ɗafki mand na inii : A nikee buur, a haɓɗiɗeeɗa kuɓkiŋ ɗe ƴaari ceeke yakak ŋ kilookiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A woossa ñaam ciŋ ɗe ne ɓa kaɗ ɓeeɗka hanheeci joy hay ŋ kilooki ; waaye ɓooɓa ɓeeɗkassee waaɗɗi hay. ");
INSERT INTO sav_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A tuuƴissa ɓi ñaam wiiriis, a woosa ɓa ne : “ Kaɗaat, ɗu woo ɓa ne ŋ haɓɗiɗ kañam ki po ƴutiɗ, ŋ apiɗ inoh ciŋ ngo na ɗoopaat ci ŋ yafale, in ci jen ƴutiɗ, ɓa hayaat kilooki ! ” ");
INSERT INTO sav_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Waaye ineem yoondiɗɗi ɓooɓa ɓeeɗkasse, yaa nu nga ɗah, cootta waas ce, ɓum kaɗta ŋ yohon caŋ ɓa, ɓum ŋ toontukaŋ ɓa ; ");
INSERT INTO sav_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ɓinooɓa ammba ñaam ca woosse, mbugalla ɓa, appa ɓa. ");
INSERT INTO sav_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Weɗi buura ayrukoh, tuuƴca soldaar caŋ ɗe ne ɓa ap ɓooɓi ap ñaam ceem, ɓa doh kur ka. ");
INSERT INTO sav_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋ ineem buura woosa ñaam caŋ ɗe ɓinooɓa ne : “ In ci joy ceeke'ohu ƴutiɗ waaye hanheeci ɓeeɗkasse yeyyooɗi ca. ");
INSERT INTO sav_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kaɗaat ŋ ɗisik ci ɓooɓi na cohe, ɓo' nu ɗu hot ɗah, ɗu ɓeeɗuk ɗe ŋ kañam ki. ” ");
INSERT INTO sav_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ñaam ca kaɗta ŋ waas ca, ɓa ɓeeɗukka ɓooɓa ɓa cohee na ɓa jen, baahiɗ na baahaaɗi po kahna riiffa na hanhe. ");
INSERT INTO sav_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Buura aassa ne a marak ɓooɓi hay ŋ kañam ki, a hotta ɓo' nga ɓekkaaɗi kulɓa ceeke'oha. ");
INSERT INTO sav_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A woosa ɗe ne : “ Ƴaariŋ ngo, fu tumoh na po fu aassa ndii te fu raakɗi kulɓa ceeke'oha ? ” Ƴaara lofɗi ali in. ");
INSERT INTO sav_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Weɗ a woyoh surgaaca ne ɓa tokaat kot caŋ ƴaara na yaah caŋ ɗe, ɓa njaf ɗe ŋ hara, ŋ ñuusa, ɗiska fuɗ na ɗoɓɗoh sis raakan. » ");
INSERT INTO sav_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeesu degga nga ne : « Laayiɗ ɓeeɗkuuɗ waaye ɓi kooɗu laayɗi. » ");
INSERT INTO sav_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ŋ ineem, Farisen ca kaɗta coha ne ɓa marak findi ɓa jaɗɗohan Yeesu fiir po ɓa amb ɗe ŋ woo ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓa tuuƴca nga ɗe ɓi taalube ɓaah nga ɓa na ɓi ɓo' ɓaah ŋ langtoh caŋ Herod, ɓeem woosa ɗe ne : « Jangɗohohi, ɓoo inhiɗ ne fu woyoh keeh te fu na jangɗohe waasiŋ Kooh ŋ keeh. Fu nupɗi ali ɓo', laam fu na markeeɗi ŋ yaki ɓoyi yak. ");
INSERT INTO sav_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kon woya ɓoo ini fu liiɓ ŋ inii : Wa waas ne Sesaar, buura yakkaŋ Rom, wirndasse lempo wala ? » ");
INSERT INTO sav_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Waaye Yeesu inheen baahaaɗiikaŋ ɓa ; a loffa ɓa ne : « Naafeehaaci, wa ye tah ɗu waaɗee so ɓek ? ");
INSERT INTO sav_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Teeɓaat to kopori na ambohse lempo. » Ɓa eɗta ɗe dinaar yino. ");
INSERT INTO sav_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A meekissa ɓa ne : « Ya ɓa raak nataalii, na tiiki nik nga ? » ");
INSERT INTO sav_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓa loffa ɗe ne : « A Sesaar. » Ŋ ineem, a woosa ɓa ne : « Eɗaat Sesaar ini Sesaar raak, te ɗu eɗ Kooh ini Kooh raak. » ");
INSERT INTO sav_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ŋ woo ceem, ɓa feyuusa jen, ɓa faɗta ɗe, ɓa cootta. ");
INSERT INTO sav_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mbaɗi, ɓi ɓo' ɓaah ŋ Sadusen ca hayya nga ɗe, ɓeɗ ɓi na woye ne kaaniɗ ci hultanɗi. Ɓa meekissa ɗe ");
INSERT INTO sav_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","an : « Jangɗohohi, Musaa woo ne ƴaar nu kaan te a raawɗi raak kuɓu ɗah, e taambɗoh ce tokan ɓitɓi a faɗ ne a raakiɗ kaaniɗi kuɓu. ");
INSERT INTO sav_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Laam nga ɓoo, wa raakeen taambɗoh yasna-kanak, saawi tokka ɓitiɓ, a kaannda raakaaɗi kuɓu, taambɗoh ce ɗaakka ɓitiice. ");
INSERT INTO sav_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yeem nammba kaan raakaaɗi kuɓu na ɗe, yi kaahayɗoh nammba tum ɗaa po yi yasna-kanakɗoh. ");
INSERT INTO sav_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wa ɓa kaan jen, ŋ mirndaani, ɓitɓi kaannda. ");
INSERT INTO sav_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ɗiski wa nik, ɓooɓi hulit ɗah, a nikan ɓiti ya ɓa ŋ ƴaaɓi yasna-kanak ci, laam ɓa jen, ɓa tokiɗ ɗe ? » ");
INSERT INTO sav_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu woosa ɓa ne : « Ɗu inahɗi ini Fiis ci woo, ɗu inahɗi hatiliŋ Kooh, weɗ tah ɗu muuƴ. ");
INSERT INTO sav_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ɓooɓi hulit ɗah, ƴaar ci heyɗi toke ɓitiɓ, ɓitiɓ ci heyɗi tokse, ɓa mandan na malaakaaciŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Te ini kaɗ ŋ hultiŋ kaaniɗ ci, mand haa ɗu jangɗi ini Kooh woo ɗu nga wii : ");
INSERT INTO sav_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“ Ñam Koohiŋ Ibrahiima na Isaahha na Yaŋhooɓa. ” Kooh, a Koohiŋ kaaniɗ ci haa, waaye a Koohiŋ pesiɗ ci. » ");
INSERT INTO sav_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wa mboolnda kerah jangɗohiŋ ɗe weem, ɓa yeemuusa. ");
INSERT INTO sav_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wa Farisen ca yeg ne Yeesu rangiɗ nguɓ caŋ Sadusen ca, ɓa cohha. ");
INSERT INTO sav_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yino nga ɓa, jangɗohoh yakak ŋ waasiŋ Musaa, waaɗta ɗe markis ; a meekissa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","« Jangɗohohi, a winde nakoh uup yak ŋ nakoh ciŋ waasi ? » ");
INSERT INTO sav_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu loffa ɗe ne : « “ Waaɗa Heɗ ɓoo Koohiŋ ɗa na keeñiŋ ɗa jen, na ruuhiŋ ɗa jen, na liiɓiŋ ɗa jen. ” ");
INSERT INTO sav_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Weɗ nakohi uup yak te weɗ koc ŋ nakoh ci. ");
INSERT INTO sav_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wi kanakɗoh te wa raakiɗ njiriñ findi wi koc, weɗ ne : “ Waaɗa morom fu findi fu waaɗoh haf fu. ” ");
INSERT INTO sav_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Waasiŋ Musaa na jangɗoh ciŋ woosuuɗ ci jen gaƴuk ŋ nakoh ci kanak cii. » ");
INSERT INTO sav_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Waam raak Farisen ca ris ŋ ɗiska, Yeesu meekissa ɓa ne : ");
INSERT INTO sav_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","« Ɗu liiɓ ye ŋ ini kaɗ ŋ Mucɗohi Gapohse ? A setiŋ ɓa ? » Ɓa loffa ɗe ne : « A setiŋ Dawuuda. » ");
INSERT INTO sav_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Yeesu woosa ɓa ne : « Dawuuda woo ŋ Fiis ci ne : “ Heɗ ɓoo woyiɗ Heɗ to ne : ‘Ɓoofa ŋ ñaahmiŋ ngo po mbaɗna ŋ folan ɓi sang ɗa, fu tum ɓa degoha kot.’ ” Kon Dawuuda ɓeeɗkohee Mucɗohi Gapohse Heɗ ce, haa e ? Te raak Dawuuda riifiɗ na Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh, kon wa min na nikoh ? ");
INSERT INTO sav_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mbaa nik ne Dawuuda ɓeeɗkohee ɗe Heɗ ce ɗah, a min na nikoh setiŋ ɗe ? » ");
INSERT INTO sav_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jaarra ali ɓo' minɗi ɗe lof ali in, ina kooɗoh waam, ɓo' kaañisɗi ɗe meekis ne a markisuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ŋ finho ineem, Yeesu woyeeɗa na mboolnda na taalubeeciŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","an : « Jangɗohoh ciŋ waasi na Farisen ci lamiɗ Musaa ne ɓa teeɓoh waasi. ");
INSERT INTO sav_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kerhiɗaat ɓa te ɗu tumee in ci ɓa na woye jen, waaye kinaat mand na ɓa ŋ tumohaaɗ. Ɓa na woye woo, ɓa na tumeeɗi. ");
INSERT INTO sav_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓa na toke ɗuf ɓitiɗ, ɓa raanee ca ɓooɓi te ɓa waaɗɗi ca reɓ sah na lecem ndukun. ");
INSERT INTO sav_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","In ci ɓa na haɓɗe jen, ɓa na waake hotaat to nga. Hey ɗah, ɓa ɓaat angiɗ aayaaciŋ Fiis ci Hooliɗ ci na tokse ŋ puk na yaah, ɓa ɓaat simbir-simbir ciŋ kulɓaaciŋ ɓa na naandsee ɓa nakoh ciŋ waasi. ");
INSERT INTO sav_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɓa ɓeeɗku kañam yakak ɗah, ɓa na waaɗe ne ɓa ɓoofan ŋ ɗisik ci uup eɗu cir. Ɓa na name waaɗ nik ŋ fiki ɓooɓi ngaŋ sinaagog ci. ");
INSERT INTO sav_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓa na waaɗe ne ɓooɓi kañɗan ɓa yaah kanak ŋ ɗisik ci na toonohse ŋ kur te ɓa waaɗ ne ɓooɓi ɓeeɗkan ɓa \"Rabbi\" (weɗ jangɗohohi yakki). ");
INSERT INTO sav_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Waaye ɗu, kinaat tum haf ɗu \"Rabbi\". Laam ɗu raak jangɗohoh yino, ɗu jen e ɗu taambɗoh. ");
INSERT INTO sav_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kinaat teek ali ɓo' baabiŋ ɗu ngaŋ kehƴi, laam Yi nik ŋ ɗafki dong a yi Baabiŋ ɗu, ");
INSERT INTO sav_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","te ɓa kinaat ɗu ɓeeɗuk njiit, ɗu raak njiit yino dong, Mucɗohi Gapohse. ");
INSERT INTO sav_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yi uup nik kilifa nga ɗu, a yi joy nik surgaaniŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɓo' nu meeɓ haf ce ɗah, a hey ruhsiɗasse te ɓo' nu ruhsiɗ haf ce ɗah, a hey meeɓse. ");
INSERT INTO sav_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mas ɗu ɓi jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! E ɗu na range waasi, ɗu hondoh ɓooɓi aas ŋ Nguuriŋ-Ɗafki ! Ɗu aasɗi, ɗu faɗanɗi ɓooɓi waaɗ aas ne ɓa aas.  ");
INSERT INTO sav_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mas ɗu ɓi jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! Ɗu ɓi wil cookom na keheƴ ne ɗu waak tuuɓoh, te ɗu raakka yino dong ɗah, ɗu tum ɗe ɓo' safara po a uup ɗu wa nik waas kanak. ");
INSERT INTO sav_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mas adgiɗ ci fuuliɗ ci ! Ɗu na woye ne : “ Ɓo' giñ ŋ Kahniŋ Kooh ɗah, in nikɗi nga ; waaye a giñ ŋ ursi nik nga ɗah, wa giñ tufkiɗ. ” ");
INSERT INTO sav_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E ɗu naand ɗu fuulla ! Kon e winde uup raak njiriñ, e ursi wala Kahan Kooh wi na tahe ursi ambu findi in hooliɗ wuu Kooh ? ");
INSERT INTO sav_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɗu na name woo ne : “ Ɓo' giñ ŋ seeƴkohaana nik ŋ Kahnaŋ Kooh ɗah, wa in haa ; waaye a giñ ŋ seeƴka degu nga ɗah, wa giñ tufkiɗ. ” ");
INSERT INTO sav_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fuuliɗ ci ! Kon wa ye uup raak njiriñ, e seeƴki wala seeƴkohaani na tahe wa ambu findi in hooliɗ ? ");
INSERT INTO sav_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɓoyi na giñe ŋ seeƴkohaani na giñe nga na in ci nik ŋ ɗafuk wa jen ; ");
INSERT INTO sav_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","wa mand ɗaa, ɓoyi na giñe ŋ Kahan Kooh na giñe nga, a giñee ŋ Yi gen nga ; ");
INSERT INTO sav_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","wa nam mand ɗaa, ɓoyi na giñe ŋ Eel ci na giñe ŋ ɓoofoha-buuri nik nga na Kooh yi ɓoof nga. ");
INSERT INTO sav_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mas ɗu ɓi jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! Ɗu ɓii eɗoh sah in ci ƴin ƴin ci ɗu na guure findi naana na safɗohaaci cinooci ndaŋkiyaah nu nik yinoori, te ɗu sagankohiɗ in ci uup raak njiriñ ŋ waasi : Ca nikka yurah, na raak yirmande na amb ŋ Kooh, ineem weɗ ɗu joyee tum, te ɗu sang sagankoh ci tas. ");
INSERT INTO sav_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Adgiɗ ci fuuliɗ ci ! Ɗu na siɗe caafu ƴin te ɗu na one ngeelemb ! ");
INSERT INTO sav_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mas jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! Ɗu mand na ɓooɓi ɓohoñ finhooriŋ kaasi na palaati te ɗooƴi riifiɗ na in ci ɗu raakoh ŋ rok na yeeɓkaaɗi. ");
INSERT INTO sav_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisen ci e ɗu fuul ! Kocaat ɓohoñ ɗooƴiŋ kaasi te finhoori hey hoole. ");
INSERT INTO sav_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mas ɗu ɓi jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! Ɗu mand na ruy-ruy ci penturu yaanow ; ŋ finhoori ca na nike ye moɗan waaye ŋ ɗooƴi ca riif na ƴoh ɓo' kaaniɗ na usuɓ nu usuɓ. ");
INSERT INTO sav_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɗu mand ɗaa, ɗu na teeɓe ɓooɓi ñaamaar ɓo' yurhiɗ te ɗu riif na naafeeha na ɗal waas. ");
INSERT INTO sav_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mas ɗu ɓi jangɗohoh ciŋ waasi na Farisen ci ! E ɗu naafeeha ! Ɗu ɓi na taɓahe ruy-ruy ciŋ woosuuɗ ci, ɗu moɗsinee ruy-ruy ciŋ yurhiɗ ci, ");
INSERT INTO sav_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ɗu woyee ne : “ Ɓoo maaseen jamanoocaŋ caac caŋ ɓoo ɗah, ɓoo heeɗi hune na ɓa ŋ aami ɓa aamee ñif maŋ woosuuɗ ca. ” ");
INSERT INTO sav_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ŋ ndeem, ɗu na seede'ɗe haf ɗu ne e ɗu kuɓuuciŋ ɓooɓi ap woosuuɗ ci. ");
INSERT INTO sav_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Reytinaat ini caac ciŋ ɗu camb ! ");
INSERT INTO sav_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ini ɗu añaand haa iiñ jen, ɗu min na mucoh ŋ atteeniŋ yongkaahi yakki ? ");
INSERT INTO sav_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Weɗ tah ŋ woo ɗu ne : Mi, ŋ hey ɗu woosohe ɓi woosuuɗ, ɓi heɗ haf, na ɓi jangɗohoh. Ɗu hey ape nga ɓa, ɗu daaƴ ɓum ŋ kurwaa, ɗu laɓ ɓinooɓi leraw ŋ sinaagog ciŋ ɗu, ɗu taambɗee ɓi na saandohe kur po kur, ");
INSERT INTO sav_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","wa hey tahe po ñif miŋ yurhiɗ ci aamu ŋ kehƴi jen keen ŋ ɗafuk ɗu, ina kooɗoh ŋ ñif maŋ Abel yurhiɗi po ŋ Sakariya kuɓkiŋ Barasi yi ɗu ap ŋ Kahan Kooh, ŋ harmban Ɗiska Hooliɗa na seeƴkohaana. ");
INSERT INTO sav_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ñam na woyee ɗu wa te wa keeh, in ceem jen keenan ŋ ɓooɓi woti. ");
INSERT INTO sav_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Cey Yerusalem, fu yi na ape woosuuɗ ci, fu tapee ɓooɓi fu na woosohse atoh po ɓa kaan, waas hend na weɗ ŋ waaɗ nangɗoh kuɓuuciŋ ɗa findi pambi na nangɗohe ƴiil ciŋ ɗe ŋ ooɓ ce, waaye ɗu moosɗi waaɗoh ! ");
INSERT INTO sav_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɗiski wa nik ɗu hey faɗse na kahan ɗu, kahan ɗu nikan ɓarang cos. ");
INSERT INTO sav_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Laam ñam na woyee ɗu wa, ɗu hotissanɗi so po mbaɗna ɗu na hee woye ne : “ A barke'iɗ, yi na haye ŋ tiikiŋ Heɗ ɓoo ! ” » ");
INSERT INTO sav_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wa Yeesu pul Kahan Kooh kaɗeeɗa, taalubeeciŋ ɗe hayya nga ɗe, ɓa woosa ɗe ne : « Marka taɓah ciŋ Kahniŋ Kooh, findi ca moɗoh ! » ");
INSERT INTO sav_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A loffa ɓa ne : « Ɗu hotiɗ in cii jen haa e ? Ñam woo ɗu wa te wa keeh, ali atoh tasanɗi ŋ ɗafuk atoh ŋ ndii, ca jen ca hey yahrohse. » ");
INSERT INTO sav_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeesu kaɗta ɓooffa ŋ Tangooraŋ-Oliiw-ca, taalubeeci reɓpa, ɗaayya na ɗe, woosa ɗe ne : « Woya ɓoo jamanooni in ceem na hee raakohe, na ini na hee teeɓohe hayiŋ ɗa na reehiŋ Adina. » ");
INSERT INTO sav_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu loffa ɓa ne : « Wortukaat, ali ɓo' kinaat ɗu muuƴiɗ. ");
INSERT INTO sav_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Laam ɓo' laayiɗ hey haye ɓa kooɗ tiikiŋ ngo, ɓa woyee ne ɓeɗ Mucɗohi Gapohse te ɓa hey muuƴɗe ɓo' laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɗu hey kerhoote ɓi hiñoh yakak, ɗu hey name kerah yegɗoh ci na woye ŋ hiñoh. Waaye, wortukaat neƴƴoh ; in ceem joy joy raak, waaye wa nikanɗi ne Adina na reehe. ");
INSERT INTO sav_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cum ɗah, kur hey hiñohe na kur morom wa, buur hey hiñohe na buur morom ce, aɗ raak ŋ ɓi ɗisik, kehƴi namee yoondɗuk ŋ ɓi ɗisik, wa nikohan ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ceem jen ca nikan cambiŋ miskiɗ ci, findi ɓitɓi na hee ɓasle. ");
INSERT INTO sav_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ɗu hey ɓayse ne ɗu mbugalu, ɗu hey apse, cuuɓ ci jen hey ɗu sange saguuso. ");
INSERT INTO sav_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Laayiɗ nga ɗu hey keene ; ɓum hey wore ɓum, ɓa hey sangtiɗohe. ");
INSERT INTO sav_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɓo' laayiɗ hey haye ɓa tum haf ɓa woosuuɗ te ɓa woosuuɗ haa, ɓa hey muuƴɗe ɓo' laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wa hey kaɗe po waaɗi ɓo' laayiɗ waaɗ morom ciŋ ɓa haawsuk sagu eɗaaɗi waas cir ; ");
INSERT INTO sav_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","waaye ɓoyi na hee ndengɗuke muñ po ŋ reehɗohaana, hey mucɗasse. ");
INSERT INTO sav_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yegɗohiŋ Muci, wiŋ Nguuriŋ-Ɗafki, hey yegɗohse ŋ adinaani jen, wa nik seede ŋ cuuɓ ci jen, ƴut ɗah, reehiŋ Adina han hay. ");
INSERT INTO sav_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kaɗ po ɗu hot ini araamiɗi na yahrohe tufkiɗ ŋ Ɗiski Hooliɗi findi woosuuɗi Dañeel woyohee wa ɗah, - Fu yi na jange Fiis cii, inha ! - ");
INSERT INTO sav_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ɓooɓi wa raakan ŋ Yudee, ɓa saandohaat ŋ tangooca. ");
INSERT INTO sav_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɓoyi wa raakan ŋ ɗafuk teeraasiŋ ɗe, a ruhsee ɗah, a kinaat aas ne a na hee ɓaye in ciŋ ɗe ŋ ɗooƴ kahan ce ; ");
INSERT INTO sav_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ɓoyi wa raakan ŋ yohon ca, a kinaat gurid ne a ɓay kulɓaakiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mas ɓitiɓ ci na hee nike rook ŋ jamanooneem na ɓapɗoh ci ! ");
INSERT INTO sav_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kiimaat Kooh po saandohiŋ ɗu nikuu ŋ jamanooniŋ soosi wala ŋ mbehi na iɗsiɗkohse. ");
INSERT INTO sav_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Laam ɓooɓi hey raake miskiɗ lool, miskiɗ mand ɗaa moosɗi raakoh ina Adina nikoh poyi te wa raakissanɗi. ");
INSERT INTO sav_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te mbeh ceem haawsasseeɗi ɗah, ali kiñin heeɗi muce, waaye ca hey haawsasse sagu ɓooɓi Kooh tan. ");
INSERT INTO sav_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ŋ jamanoonaam ɓo' woo ɗu ne Mucɗohi Gapohse yii ŋ ndii wala ŋ nden ɗah, kinaat ɗe kos. ");
INSERT INTO sav_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Laam ɓi ɓo' hey haye, ɓa tum haf ɓa Mucɗohi Gapohse wala woosuuɗ te ɓa yino nga ca haa, ɓa haɓɗee firnde yakak na keemaan ne ɓa muuƴiɗ ɓooɓi po ɓi Kooh tan sah ne wa mineen nik ɗah. ");
INSERT INTO sav_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Weɗi weem nak, ŋ woyiɗ ɗu wa bala wa hayan. ");
INSERT INTO sav_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ɓa woo ɗu ne : “ A yi ŋ ndii ŋ kehƴi hulangi ” ɗah, kinaat kaɗ. Wala : “ A yaa ɗasɗukka nden ” ɗah, kinaata kos. ");
INSERT INTO sav_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Findi meleñ na pulohe ŋ pulohaaɗ-noh, wa ñiiniɗ po ŋ muyohaaɗ-noh, hayiŋ Kuɓkiŋ ɓoyi mandan ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ɗiski fiɗaaf nik, suur ci na cohe nga. ");
INSERT INTO sav_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Miskiɗ ciŋ mbeh ceem reehee rek ɗah, nohi ñuus, caɓni ƴim, hor ci keen te hatil ci nik ŋ eel ci yoondɗu. ");
INSERT INTO sav_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Firndeeniŋ Kuɓkiŋ ɓoyi hey hotke ŋ eel ci, teemb ndeem, cuuɓ ciŋ kehƴi jen hey miskiɗke te ɓa hey hote Kuɓkiŋ ɓoyi, eel ciŋ Asamaan haytohee ɗe, a riif na hatil na kiyak. ");
INSERT INTO sav_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kuluɓ hey ɗiiɗɗe, a woos malaakaaciŋ ɗe, ca kaɗ ɓak po ɓak ŋ adinaani jen ne ɓa teembɗoh ɓooɓi a tan. ");
INSERT INTO sav_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Inhaat ini nduni jangɗoh : Kaɗ po naak ciŋ wa hiƴ, wa camb kifis ɗah, ɗu na jaare inah ne rehi usisɗi. ");
INSERT INTO sav_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wa mand ɗaa, ɗu nam hot in ceem jen ɗah, inhaat ne wa usisɗi, weɗi ŋ nguɓu kahni. ");
INSERT INTO sav_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ñam na woyee ɗu wa te wa keeh, ɓooɓiŋ adinaani woti kurkohanɗi nga jen te in ceem jen raakɗi. ");
INSERT INTO sav_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eel ci na kehƴi hey coote waaye woo ciŋ ngo moosanɗi kurkoh nga. ");
INSERT INTO sav_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ini kaɗ ŋ mbehi na wahtuuni in ceem na hee raakohe, ali ɓo' inahɗi ca. E malaakaaciŋ Eel ci haa te a Kuɓki haa ; waaye a Baabi dong inaha. ");
INSERT INTO sav_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kuɓkiŋ ɓoyi hay ɗah, wa mandan findi wa mandee ŋ jamanoonaŋ Noohin. ");
INSERT INTO sav_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Waam, bala masma laayɗa riifee kehƴi hayan ɗah, ɓooɓa nikee ñameeɗa, aneeɗa, ɓa kilookeeɗa, ɓa kilookseeɗa po mbeha Noohin aasoh ŋ gaala. ");
INSERT INTO sav_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓa inheeɗi in nga po wa masma hay, wa ɗummba ɓa jen. Kuɓkiŋ ɓoyi hay ɗah, wa mandan ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ƴaar kanak hey nike ŋ yohon, yinni ɓayu, yi tas faɗu. ");
INSERT INTO sav_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɓitiɓ kanak hey hune oɗe, yinni ɓayu, yi tas faɗu. ");
INSERT INTO sav_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kon, kinaat neeh, ɗu inahɗi mbehi Heɗ ɗu hayohan. ");
INSERT INTO sav_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Inhaat ne heɗ kahni inheen wahtuuni roki na hee aasohe kahan ce ɗah, a heeɗi neehe ŋ ɗooƴ weki po kahan ce kee aassa. ");
INSERT INTO sav_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Weɗ tah po, ɗu, namaat kooɗuk, laam Kuɓkiŋ ɓoyi hayan ŋ jamanooni ɗu liiɓɗi. » ");
INSERT INTO sav_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeesu ɓaatta nga ne : « Ya ɓa a yi ñaami woor te a ñaannja po, heɗ ce hee ɓaaɓe ɗah, a dengkoh ɗe pangkoh ciŋ kahni ɓinooɓi ne a eɗee ɓa kañam ŋ jamanooniŋ wa ? ");
INSERT INTO sav_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ñaameem hey neɓɗe ne heɗ ce hay, raak ɗe tume ineem findi a nakohee ɗe wa ɗah. ");
INSERT INTO sav_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ñam na woyee ɗu wa te wa keeh, heɗ ce hey ɗe tufkiɗe, a adgoh in ciŋ ɗe jen. ");
INSERT INTO sav_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Waaye ñaameem baahaaɗi po a woo ŋ ɗooƴ ce ne heɗ ce hayɗi paaɗ, ");
INSERT INTO sav_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a nik nga a laɓee ɓooɓi a na pangke na ɓa, a ñame, a anee na laaroh ci ɗah, ");
INSERT INTO sav_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","heɗ ce hey haye ŋ mbehi a foogɗi, ŋ wahtuuni a inahɗi. ");
INSERT INTO sav_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A hey ɗe mbugale, a ɓay ɗe ŋ naafeehaaca, ɗiska fuɗ na ɗoɓɗoh sis raak. » ");
INSERT INTO sav_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yeesu woosa ɓa ne : « Ŋ jamanooneem, Nguuriŋ-Ɗafki mandan na inii : Ɓa nikee cafaƴ ndaŋkiyaah ɓi kee taambka heɗ kilooki, yaa nu nga ɓayya laampaaniŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cafaƴ ci yatuus ci nikee cafaƴ naandiɗ, yatuus ci tas nikka ñaañiɗ. ");
INSERT INTO sav_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yatuus ci naandiɗ ci, wi ɓa kaɗee, ɓa ɓayndohɗi diwliin wuu laampaaciŋ ɓa ; ");
INSERT INTO sav_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","waaye ñaañiɗ ci, wi ɓa kaɗe, yaa nu nga ɗah, ɓayndoheen diwliin ŋ inaa. ");
INSERT INTO sav_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wi wa kaɗ po heɗ kilooki hooɓiɗta hay, ɓa pani'uusa jen, ɓa neeheeɗa. ");
INSERT INTO sav_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ngaŋ ndengelnde weka, ɓa kerahha leehuk an : “ Heɗ kilooki hiiɗ ! Kaɗaat ɗu taambkaa ɗe ! ” ");
INSERT INTO sav_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Weɗi cafaƴ ca kurkoh, ɓa haɓɗeeɗa laampaacaŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Naandiɗ ca yatuus ca woosa ɓinooɓa ne : “ Laampaaciŋ ɓoo ca ɗii ƴim, onaat ɓoo ŋ diwliin ciŋ ɗu. ” ");
INSERT INTO sav_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ñaañiɗ ca woosa ɓa ne : “ Muk ndaa ciŋ ɓoo doyanɗi ɓoo te ca doyanɗi ɗu ; kaɗaat ɗu roma ŋ toonoh ci. ” ");
INSERT INTO sav_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Weɗi ɓa kaɗoh roma, heɗ kilooki hayya ŋ finhooɓa. Ɓa kooɗkee po ƴutta hunnda na ɗe, ɓa aassa kahna kilooka joy haɓɗohu, buntaanaŋ kahna ranguusa. ");
INSERT INTO sav_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wa degga ƴissuut, cafaƴ ca ɓinooɓa hayya, ɓa woosa ne : “ Kilifaani, kilifaani, rangsiɗa ɓoo ! ” ");
INSERT INTO sav_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A loffa ɓa ne : “ Ñam woo ɗu wa te wa keeh, ŋ inahɗi ɗu. ” » ");
INSERT INTO sav_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeesu degga nga ne : « Kon kinaat neeh laam ɗu inahɗi mbehi na wahtuuni Kuɓkiŋ ɓoyi hayohan. ");
INSERT INTO sav_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wa nam mand na ƴaari ɓaaɓe, a ɓeeɗukka ñaam ciŋ ɗe, a dengkohha ɓa taambkohiŋ raak-raakiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A eɗta yaa nu nga ini a min ɓay ; yi koc saaku kopor yatuus, yinoori saaku kanak, yi tas saaku yino. Ƴutta, a cootta. ");
INSERT INTO sav_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yi eɗu saaku yatuus arra kaɗ, a toontukka na ca po ca rimmba saaku yatuus wiiriis. ");
INSERT INTO sav_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yi eɗu saaku kanak nammba tum ɗaa, ca rimmba saaku kanak wiiriis. ");
INSERT INTO sav_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Waaye yi eɗu saaku yino kaɗta acca nung, a ɗasiɗta koporiŋ kilifaaniŋ ɗe nga. ");
INSERT INTO sav_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Wa kilifaani ɓaaɓ maañiɗ po a hayya, a woosa ɓa ne ɓa teeɓaat ɗe findi ɓa tumoh na koporiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ya eɗsee saakuuca yatuus ca hayya na ca, a woosa ne : “ Kilifaani, fu dengkohee so saaku yatuus, ŋ toontukiɗ na ca po ŋ raakissiɗ saaku yatuus, ceɗi cii. ” ");
INSERT INTO sav_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kilifaani woosa ɗe ne : “ Wa baahiɗ, fu ñaam baahiɗ cariɗ oolku ; fu cariɗ oolku ŋ in ci ƴin ci weɗ tah ŋ hey ɗa dengkohisse in laayiɗ. Haya ɓoo ɓaah sumi ŋ sum. ” ");
INSERT INTO sav_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ya eɗsee saakuuca kanak ca nammba kaɗ woosa kilifaana ne : “ Kilifaani, fu dengkohee so saaku kanak, ŋ toontukiɗ na ca po ŋ raakissiɗ saaku kanak ; ceɗi cii. ” ");
INSERT INTO sav_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kilifaana woosa ɗe ne : “ Wa baahiɗ, fu ñaam baahiɗ cariɗ oolku ; fu cariɗ oolku ŋ in ci ƴin ci weɗ tah ŋ hey ɗa dengkohisse in laayiɗ. Haya ɓoo ɓaah sumi ŋ sum. ” ");
INSERT INTO sav_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yi eɗsee saakndi yinoori hayya, a woosa ne : “ Kilifaani, ŋ inheen ne fu ɓo' miskiɗ, fu na nguɗe ini fu sokɗi, fu ɓeenee ŋ ɗiski fu saawɗi ; ");
INSERT INTO sav_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ŋ neƴƴoh neƴƴoh, ŋ ɓayya koporiŋ ɗa, ŋ accaa. Weɗi wii, ɓayaa. ” ");
INSERT INTO sav_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kilifaani woosa ɗe ne : “ Ñaami baahaaɗiini tirɓiɗi ; fu inheen ne maa nguɗe ini ŋ sokɗi, ŋ ɓeenee ŋ ɗiski ŋ saawɗi, ");
INSERT INTO sav_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","fu mineeɗi ɓay koporiŋ ngo ŋ ɗaakoh kopor ci ne ŋ hay ɗah, ŋ raaka rimɗiɗ to in e ? ");
INSERT INTO sav_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ɓayaat saakndi nik na ɗe, ɗu eɗa yi raak saakuuci ndaŋkiyaah ci. ");
INSERT INTO sav_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Laam ɓoyi raak hey ɓaatse po a laayiɗ lool, waaye ɓoyi raakɗi, ini ƴissuuti a amb sah hey naafse nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te ñaami raakaaɗi njirñi, mbetaat ɗe ŋ ñuusa ŋ hara, ɗiska fuɗ na ɗoɓɗoh sis raak. ” ");
INSERT INTO sav_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kuɓkiŋ ɓoyi hay ŋ yaki a yak na malaakaaci jen ɗah, a hey ɓoofe ŋ ɓoofoha-buuri nik wiŋ ɗe, wi na teeɓohe yaki a yak. ");
INSERT INTO sav_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Cuuɓ ci jen cohɗohu ŋ fikiice. A paysohee ɓum na ɓum, findi niiɗoh na talsohohe mbaal ci na pe' ci. ");
INSERT INTO sav_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te a hey ɓaye mbaal ci yaah-ñaahum, a ɓay pe' ci yaah-sing. ");
INSERT INTO sav_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ŋ ineem, buuri hey woye ɓi nik ŋ ñaahmiŋ ɗe ne : “ Hayaat ɗu ɓi Baabiŋ ngo barke'iɗ, ɓayaat Nguuri a kooɗkiɗee ɗu wa adinaani feru po wi. ");
INSERT INTO sav_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Laam ŋ aɗkeen, ɗu onnda so ŋ ñammba. Ŋ sifaɗkeen, ɗu onnda so ŋ annda. Ŋ nikeen ɓoyi ɗu inheeɗi, waaye ɗu daliɗta so ŋ kahan caŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ŋ ɓangtasseen kulɓa, ɗu ɓekiɗta so. Ŋ kosaayeen, ɗu hayya so ɗoohɗe. Ŋ taƴseen ŋ kaso, ɗu kaɗta so marka. ” ");
INSERT INTO sav_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yurhiɗ ci hey ɗe lofe ne : “ Heɗ ɓoo, ɓoo hot ɗa aɗkiɗ kiɗa, ɓoo onnda ɗa fu ñammba ? Wala sifaɗkiɗ, ɓoo onnda ɗa fu annda ? ");
INSERT INTO sav_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kiɗa weɗ ɓoo hot ɗa findi ɓoyi ɓoo inahɗi, ɓoo daliɗta ɗa ? Wala ɓangtuuɗ, ɓoo ɓekiɗta ɗa kulɓa ? ");
INSERT INTO sav_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kiɗa, weɗ ɓoo hot ɗa kosaayiɗ wala taƴuuɗ ŋ kaso, ɓoo kaɗta ɗa marka ? ” ");
INSERT INTO sav_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ŋ ineem, buuri hey ɓa lofe ne : “ Ñam na woyee ɗu wa te wa keeh, ali nik ne ɗu haɓɗiɗ in ceem yino ŋ taambɗoh ciŋ ngo uup heefu sah, ɗu haɓɗiɗ to wa. ” ");
INSERT INTO sav_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ƴut ɗah, a hey woye ɓi lahan ɗe ŋ yaah-sing ne : “ Usaat to, ɗu ɓi alkuuɗ ci ! Ɗu kaɗ ŋ yongkaaha genan, yongkaahi Seytaani kooɗkiɗu na malaakaaciŋ ɗe hun na ɗe. ");
INSERT INTO sav_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Laam ŋ aɗkeen, ɗu onɗi so kañam. Ŋ sifaɗukka, ɗu onɗi so ŋ an. ");
INSERT INTO sav_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ŋ hayiɗ nga ɗu, findi ɓoyi ɗu inahɗi, ɗu daliɗɗi so. Ŋ ɓangtuusa kulɓa, ɗu ɓekiɗɗi so. Ŋ kosaayeen, ŋ taƴuusa ŋ kaso, ɗu kaɗɗi so marka. ” ");
INSERT INTO sav_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ɓa hey ɗe name lof ne : “ Heɗ ɓoo, ɓoo hot ɗa aɗkiɗ, sifaɗkiɗ, hanhe, ɓangtuuɗ, kosaayiɗ wala taƴuuɗ ŋ kaso kiɗa te ɓoo taambkohɗi ɗa ? ” ");
INSERT INTO sav_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ŋ ineem a hey ɓa lofe ne : “ Ñam na woyee ɗu wa te wa keeh, ali nik ne ɗu haɓɗiɗaaɗi in ceem yino ŋ ɓi uup heefu ɓii ɗah, ɗu nik ko ca haɓɗiɗaaɗi. ” ");
INSERT INTO sav_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Te ɓii na kaɗe ŋ mbugala heyɗi reehe, waaye yurhiɗ ci na kaɗe ŋ kipes ki heyɗi reehe. » ");
INSERT INTO sav_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wa Yeesu ƴut woo woo ceem jen, a woosa taalubeeciŋ ɗe ne : ");
INSERT INTO sav_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","« Ɗu inhiɗ ne tas neeh kanak feetiŋ Paakiŋ Yawuut ci ree ; Kuɓkiŋ ɓoyi hey eɗohse ne a daaƴu. » ");
INSERT INTO sav_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ŋ neeh ceem, kilifaacaŋ seeƴkiɗoh ca na yakak caŋ cuuɓi cohha ŋ kahan seeƴkiɗoha yakka, a teeksee Kayif. ");
INSERT INTO sav_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓa kerhiɗohha ŋ woo findi ɓa hee tume po ɓa amb Yeesu te ɓo' yeguu, ne ɓa apɗuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Waaye ɓa woyee ne wa joyɗi nik ŋ ɗooƴ feet ci, ɓa sangee ne ɗuuɗ raak ŋ ɗooƴ ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Waam, Yeesu kaɗta Betani ŋ kahan Simong Gaanaana, ");
INSERT INTO sav_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ɓitiɓ hayya nga ɗe na buteel haɓɗohuuɗ albaatar tumiɗ laackoloñ ɗoɓiɗ, a yiiffaa ŋ hafiŋ Yeesu, raak ɗe ñameeɗa. ");
INSERT INTO sav_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Taalubeeci hoteeɗa ŋ ineem, ɓa neɓuuɗi, ɓa woosa ne : « Wa ye tah ɗe yahrohe laackoloñi ɓarang ɓarang ? ");
INSERT INTO sav_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa mineen toonohu kopor keeh-keeh, ñakiɗ ci eɗuu wa. » ");
INSERT INTO sav_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesu inheena, woosa ɓa ne : « Ɗu na yaaɓɗohe ɓitɓi ye ? A haɓɗiɗ to in ye baahan. ");
INSERT INTO sav_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ini kaɗ ŋ ñakiɗ ci, ɓa genan gen na ɗu waaye mi, ŋ heyɗi gene nik na ɗu. ");
INSERT INTO sav_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ŋ aami a aam mbo laackoloñi, a na kooɗkiɗe acuukiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ñam na woyee ɗu wa te wa keeh, ɗisik nu Yegɗohiŋ Mucii woyu ŋ adinaani jen ɗah, ini a haɓiɗ hey woyse nga, naandsukohaa ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Weɗi Yudaa Iskaryot, yino ŋ Apootar ci ndaŋkiyaah na kanak ci (12), kaɗoh ŋ kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa ");
INSERT INTO sav_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a woosa ɓa ne : « Ɗu na hee so ye eɗe ne ŋ deg Yeesu ŋ yaah ciŋ ɗu ɗah ? » Ɓa eɗta ɗe hanjar haalis ndaŋkiyaah-kaahay (30). ");
INSERT INTO sav_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jaarra a sekɗoheeɗa findi a eɗndohohan ɗe. ");
INSERT INTO sav_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ŋ mbehi koc ŋ feetiŋ Mbuuruuci raakaaɗi lawiir ci, taalubeeci hayya woosa Yeesu ne : « Fu waaɗ ne ɓoo haɓɗiɗohan ɗa kañam kiŋ Paak nde ? » ");
INSERT INTO sav_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A woosa ne : « Kaɗaat Yerusalem, ŋ kahan diw, woyaat ɗe ne Jangɗohohi woo ne jamanooniŋ ɗe reɓiɗ, a waaɗ haɓiɗ feetiŋ Paak, a yi na taalubeeciŋ ɗe, ŋ kahan fu. » ");
INSERT INTO sav_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Taalubeeci tummba findi a woyoh ɓa, ɓa kooɗkiɗta kañam kaŋ Paak. ");
INSERT INTO sav_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wa niina ree, Yeesu ɓooffa na Apootar ci ndaŋkiyaah na kanak ci (12) ne ɓa ñam. ");
INSERT INTO sav_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wa ɓa ñamee a woosa ɓa ne : « Ñam woo ɗu wa te wa keeh, yino nga ɗu hey yo eɗndohe. » ");
INSERT INTO sav_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓa soossa sem, yaa nu nga woyeeɗa ne : « Kilifaani, mbaar a mi haa ? » ");
INSERT INTO sav_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A loffa ɓa ne : « Ɓoyi ɓek yaahiŋ ɗe na so ŋ booli, a yi na hee so eɗndohe. ");
INSERT INTO sav_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kuɓkiŋ ɓoyi hey kurke nga findi Fiis ci woyoha nga ɗe, waaye mas ɓoyi na hee ɗe eɗndohe ŋ ɓi sang ɗe, ini ngisohee ŋ ɓoyeem weɗ ne a rimkuu. » ");
INSERT INTO sav_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jaarra, Yudaa yi eɗndohan ɗe meeksohha an : « Jangɗohohi, mbaar a mi haa ? » Yeesu woosa ɗe ne : « A fu woya ! » ");
INSERT INTO sav_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wa ɓa ñame, Yeesu ɓayya mbuuru ; wi a corkiɗ Kooh po ƴutta a poɓtohhaa, a eɗta taalubeeci wa, a woosa ne : « Ɓayaat ɗu ñam, wii wa faaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ƴutta a ɓayya kaas ; wi a corkiɗ Kooh po ƴutta, a woosa ne : « Ɓayaat ɗu an nga, ɗu jen, ");
INSERT INTO sav_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","wii wa ñif miŋ ngo, ñif miŋ Ambtiɗohi, wi aamu wuu ɓi ɓo' laayiɗ ne bakaaɗ ci ɗaasohu. ");
INSERT INTO sav_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ñam na woyee ɗu wa : Ini kooɗoh woti, ŋ heyɗi anisse masmiŋ reseñii po mbaɗna ŋ anissan na ɗu wi asi ŋ Nguuraŋ Baabiŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wa ɓa ƴut ŋ kañam ka po ɓa ƴeekka ƴeek ciŋ Sabuur, ci hun na feeti, ɓa pulla, ɓa kaɗeeɗa Tangooraŋ-Oliiw-ca. ");
INSERT INTO sav_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Weɗ Yeesu woyoh ɓa ne : « Ŋ weki woti, ɗu jen, ɗu hey yo faɗe sagu ini rahsan ndo. Laam Fiis ci woyiɗ ne : “ Ŋ hey laɓe niiɗohi, mbaal ciŋ gati pasarkoh. ” ");
INSERT INTO sav_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Waaye ŋ hultiɗu po ƴut ɗah, ŋ hey ɗu adge Galile. » ");
INSERT INTO sav_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyeer kooɗta woo ka, a woosa ne : « Ali ɓooɓi jen faɗ ɗa, mi, ŋ faɗanɗi ɗa muk ! » ");
INSERT INTO sav_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu woosa ɗe ne : « Ñam woo ɗa wa te wa keeh, weki woti bala siiki leehkan ɗah, fu hey yo taaske waas kaahay. » ");
INSERT INTO sav_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyeer woosa ɗe ne : « Ali nik ne ŋ kaanan kaan na ɗa sah, ŋ taaskanɗi ɗa. » Taalubeeci ɓinooɓi jen nammba woo ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yeesu hunnda na ɓa, kaɗeeɗa po reesa ɗiska na woyse Getsemane, a woosa ɓa ne : « Ɓoofaat ndii po ŋ kaɗ kiima Kooh nden, ŋ hay. » ");
INSERT INTO sav_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A ɓayndohha Piyeer na kuɓuuciŋ Sebede kanak ci, a kaɗta ƴissuut, a raakka yeg-yeg miskiɗ ŋ ɗooƴ ce, a jaahiɗta. ");
INSERT INTO sav_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A woosa ɓa ne : « Ɗiski wa nik ndii faaniŋ ngo goy goy po mi yii heeɗa kaane, tasaat ndii ɗu irin na so. » ");
INSERT INTO sav_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wi a woo ineem, a ɓaatta kaɗ ƴissuut, a raɗukka ŋ kehƴi a kiimeeɗa Kooh an : « Baabiŋ ngo, wa min nik ɗah, kaasiŋ miskiɗii usaat to ! Waaye wa ka nik findi ŋ waaɗoh, wa nikaat findi fu waaɗoh. » ");
INSERT INTO sav_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wi a dokuk ŋ taalubeeci kaahay ci, a raakka ɓa neeheeɗa, a woosa Piyeer ne : « Ɗu minɗi sah irin na so ini ree wahtu ! ");
INSERT INTO sav_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kinaat neeh, kiimaat Kooh a ndengiɗ ɗu po ɗu keenuu ŋ fiir ; waaɗ-waaɗi wii nga waaye faan ci raakɗi hatil. » ");
INSERT INTO sav_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A kaɗissa waasi kanakɗoh a kiimissa Kooh an : « Baabiŋ ngo, nik ne kaasii minɗi coot feeh ŋ anɗaa ɗah, wa raakohaat findi fu waaɗoh. » ");
INSERT INTO sav_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wa a dokkis nga ɓa, a raakissa ɓa neeheeɗa, raak ɓa pani'uuɗ po has ciŋ ɓa aaykohha. ");
INSERT INTO sav_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A faɗta ɓa ndeem, a usissa ƴissuut, a kiimissa waasi kaahayɗoh, a woyissa ina a woye. ");
INSERT INTO sav_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ƴutta a kaɗissa ŋ taalubeeca a woosa ɓa ne : « Ɗu ɓii neeh, ɗu ɓii iɗsiɗuk ! Weɗɗi, ɗiski wa nik wahtuuni reyiɗ, Kuɓkiŋ ɓoyi faɗuuɗ ŋ yaah ciŋ bakaaɗoh ci. ");
INSERT INTO sav_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kurkaat ɓoo kaɗ. Markaat ! Yi joy yo eɗndoh a yi ! » ");
INSERT INTO sav_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wi a na woye ineem, Yudaa, yino ŋ Apootar ci ndaŋkiyaah na kanak ci (12), reyeeɗa. A hunee na mboolo ganaaykiɗ ndang na ndooɗ. E kilifaacaŋ seeƴkiɗoh ca na yakak caŋ cuuɓa ɓeɗ tuuƴee ɓa. ");
INSERT INTO sav_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Raak Yudaa woyiɗ ɓa ne : « Ɓoyi maa hee foone inhaat ne a yi ; ambaat ɗe ! » ");
INSERT INTO sav_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jaarra, a reɓpa ŋ Yeesu a woosa ɗe ne : « Fu tum na Jangɗohohi ? » A foonnda ɗe. ");
INSERT INTO sav_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu woosa ɗe ne : « Ƴaariŋ ngo, tuma ini ɓay ɗa. » Weɗ ƴaaɓa reɓoh, ɓa ammba ɗe. ");
INSERT INTO sav_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ƴaar ɓaah ŋ ɓa nikee na Yeesu fuurra ndangiŋ ɗe, a ƴoɓpa ñaam ŋ ñaam caŋ seeƴkiɗoha yakka wa hennda ŋ nofiŋ ɗe, wa nguɗtaa. ");
INSERT INTO sav_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeesu woosa ɗe ne : « Dokna ndangi ŋ ɗiska wa nike ; ɓooɓi na ape na ndang jen, a ndang apan ɓa. ");
INSERT INTO sav_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fu liiɓ wii ne ŋ minɗi ɓeeɗuk Baabiŋ ngo e ? Ŋ ɓeeɗuk ɗe ɗah, a hey yo woosohe win-win ɓi junni junni malaaka. ");
INSERT INTO sav_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ŋ tuma ɗah, kon in ci Fiis ci woo raakohan na ? Fiis ci ceɗ woo ne in ci joy nikoh an. » ");
INSERT INTO sav_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jaarra Yeesu woosa mboolnda ne : « Ɗu hayiɗ na ndooɗ na ndang findi taamboh rok ne ɗu amb mbo. Moona Kooh-nu-wiis ŋ nikee ɓoofiɗ ŋ Kahan Kooh jangɗoheeɗa te ɗu ambɗi so. ");
INSERT INTO sav_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Waaye in cii jen raakiɗ ne in ci Fiis ciŋ woosuuɗ ci woo raak. » Weɗ taalubeeci jen faɗoh ɗe ndeem, ɓa saandohha. ");
INSERT INTO sav_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓooɓa ambee Yeesu ɓa ɓay ɗe kahan Kayif seeƴkiɗoha yakka, wa raak jangɗohoh ciŋ waasi na yakak ca cohiɗ nga. ");
INSERT INTO sav_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyeer nikee ñaakɗeeɗa ɗe usiɗ ŋ finhoora po findi a reyoh kahan seeƴkiɗoha yakka, a aassa, a ɓooffa na surgaaca ŋ leero kahna ne a marak findi wa mirndohan. ");
INSERT INTO sav_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na ɓooɓa ɓinooɓa ɓaah ŋ saangnaŋ yakak caŋ Israayel jen waakeeɗa seede leyoh ne ɓa raak ini tah ɓa min apɗuk Yeesu, ");
INSERT INTO sav_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","waaye ɓa raakɗi ini ɓa etoh, ali nik ne leyoh laayiɗ nikee seede'eeɗa woo raakaaɗi nga ɗe sah. Ŋ mirndaani kanak hayya ");
INSERT INTO sav_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","woosa ne : « Ƴaarii woyiɗ ne a miniɗ yahroh Kahniŋ Kooh, a taɓaha ŋ neeh kaahay. » ");
INSERT INTO sav_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Teemb ndeem, seeƴkiɗoha yakka kurukka, woosa Yeesu ne : « Fu heyɗi lofe ali in ŋ in ci ɓooɓi na yambee ɗa e ? » ");
INSERT INTO sav_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yeesu ɗekka teɗ. Seeƴkiɗoha yakka woosa ɗe ne : « Mi yii meekis ɗah, ŋ tiikiŋ Koohi na pese, woya ɓoo andi a fu Mucɗohi Gapohse, Kuɓkiŋ Kooh ! » ");
INSERT INTO sav_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu loffa ɗe ne : « Fu woyiɗa ! Te ɓaat nga ñam na woyee ɗu wa, ini kooɗoh ndii ɗu hey hote Kuɓkiŋ ɓoyi ɓoofiɗ ŋ ñaahmiŋ doolndiŋ Kooh, ɗu hey ɗe hote ŋ ɗafuk ɓi eel, ca haytohee ɗe. » ");
INSERT INTO sav_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Weɗ seeƴkiɗoha yakka faaroh kulɓaacaŋ ɗe haf ce, ne a teeɓoh ne wa woo uupiɗ. A woosa ɓa ne : « A ɗaliɗ Kooh ! Ɓoo etohis seede ye ? Ɗu kerhootiɗ ɗali a ɗal Kooh kotii ! ");
INSERT INTO sav_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","A joy ye tumu ? » Ɓa loffa ne : « A apaah apu ! » ");
INSERT INTO sav_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɓa tuhseeɗa fikiiriŋ ɗe, ɓa laɓeeɗa ɗe kumah, ɓum laɓeeɗa ɗe paɗ ");
INSERT INTO sav_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","woyeeɗa ne : « Fu yi Mucɗohi Gapohse ! Nik ne fu woosuuɗ ɗah, woya ɓoo ɓoyi laɓ ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Waam raak Piyeer ɓoofiɗ ŋ leero kahna, komaaki cafaƴ reɓpa nga ɗe, a ɓaahee ŋ ñaam ca, a woosa ɗe ne : « Na ɗa, fu namee nik na Yeesu ƴaariŋ Galileeci. » ");
INSERT INTO sav_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Waaye a taasukka ŋ fikiiɓa jen an : « Ŋ inahɗi ini fu waaɗ woo. » ");
INSERT INTO sav_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wa a yurhee ŋ ɓakaŋ nguɓu kahna, ñaam ɓitiɓ wiiriis nammba ɗe hot woosa ɓooɓa nikee ndaam ne : « Ƴaarii nikee na Yeesu ƴaariŋ Nasareet ci. » ");
INSERT INTO sav_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A nammba taaskis na giñ an : « Ŋ inahɗi ƴaarii ! » ");
INSERT INTO sav_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wa degga ƴissuut ɓooɓa nikee ŋ ndaam reɓpa ŋ Piyeer, ɓa woosa ɗe ne : « Wa wooriɗ ne fu nam ɓaah ŋ ƴaaɓiŋ ɗe, woyohaaɗiŋ ɗa sah teeɓohiɗa. » ");
INSERT INTO sav_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piyeer nikka nga, giñeeɗa ne : « Ndaa Kooh apaat to ! Ƴaarii ŋ inahɗi ɗe ! » A reehiɗɗi woo, siika leehukka. ");
INSERT INTO sav_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Weɗ Piyeer naandsukoh woo kaŋ Yeesu an : « Bala siiki leehkan ɗah, fu hey yo taaske waas kaahay. » Piyeer pulla, fuɗeeɗa fuɗ miskiɗ. ");
INSERT INTO sav_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wa Kooh wiis na ɓaaɓa, kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa na yakak caŋ cuuɓi cohha ne ɓa min apɗuk Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓa tokɗukka ɗe, ɓa ɓayya ɗe, ɓa eɗta ɗe Pilaat, goornooraŋ kur ka. ");
INSERT INTO sav_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ŋ ineem, Yudaa hotta ne Yeesu yi a eɗndohee hey apse, inwaaso ammba ɗe, a kaɗta ŋ kilifaacaŋ seeƴkiɗoh ca na yakak ca, a wikka ɓa haalsa, hanjar ca ndaŋkiyaah-kaahay (30) ca. ");
INSERT INTO sav_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A woosa ɓa ne : « Ŋ bakaaɗiɗ, ŋ degiɗ ɓoyi tumɗi in ŋ yaah ciŋ ɗu ne a apu ! » Waaye ɓa woosa ɗe ne : « Waas ɓoo ye nga ? A fu inah. » ");
INSERT INTO sav_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Weɗ Yudaa njafoh hanjar ca ŋ Kahan Kooh, a pulla, a ɓayya niy, a kaɗta harka. ");
INSERT INTO sav_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kilifaacaŋ seeƴkiɗoh ca parahha ca, ɓa woosa ne : « Wii, wa candoom ñif aamkiɗ. Ɓoo minɗaa ɓek ŋ koporiŋ Kahniŋ Kooh. » ");
INSERT INTO sav_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ɓa cohha ɓa kerhiɗohha ŋ woo, ɓa ɓayya kopor ka, ɓa romohha wa yohnaŋ mahoha, acoha ɓooɓa genɗi kur ka. ");
INSERT INTO sav_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Weɗ tah yohna teekuusa po woti, yohniŋ ñif mi. ");
INSERT INTO sav_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Taambohha ndeem, ini woosuuɗi Yeremi woyee raakka an : « Ɓa ɓayiɗ hanjar ca ndaŋkiyaah-kaahay (30) ca, ineem weɗ a car ŋ Israayel ci. ");
INSERT INTO sav_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɓa eɗohiɗ ca ne ɓa rom yohniŋ mahohi, findi Heɗ ɓoo woyohee so wa. » ");
INSERT INTO sav_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ŋ ini kaɗ ŋ Yeesu, wa a ɓayu ŋ fiki Pilaat goornoora, yeem meekissa ɗe ne : « A fu buuriŋ Yawuut ci e ? » Yeesu loffa ɗe ne : « Fu woyiɗa. » ");
INSERT INTO sav_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Waaye a lofɗi ali in ŋ in ca kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na yakak ca yambee ɗe. ");
INSERT INTO sav_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilaat woosa ɗe ne : « Ŋ woo ne : fu kerahɗi in ci ɓa na woyɗee ɗa jen e ? » ");
INSERT INTO sav_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Waaye Yeesu lofɗi ɗe ŋ ali in, ineem feyya goornoora lool. ");
INSERT INTO sav_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Feetiŋ Paak reyeen ɗah, goornoor meeɗ ɓa meeɗ faɗsiɗ ambuuɗ yino, e mboolndi meeɗ ɗe tan. ");
INSERT INTO sav_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Waam raak ɓa raakiɗ ƴaar inhuuɗ ya taƴsee ŋ kasoona, a teeksee Yeesu Barabaas. ");
INSERT INTO sav_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mboolnda jen nikee cohiɗ ŋ ɗiskaŋ Pilaat, a woosa ɓa ne : « Ɗu waaɗ ne ŋ faɗsiɗ ɗu ɓa, Yeesu Barabaas wala Yeesu yi na woyse Kiristaa ? » ");
INSERT INTO sav_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A inheen ne waaɗa ɓooɓa waaɗ Yeesu, weɗ tah kilifaaca degga ɗe ŋ yaah ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wa Pilaat ɓoof ŋ ngelohaana a atte'eeɗa, ɓitiice woosohha woo kii nga ɗe an : « Kina raakɗoh ali in na ƴaari yurhiɗeem, woti ŋ heeƴiɗ heeƴ miskiɗ nga so saguuce. » ");
INSERT INTO sav_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kilifaacaŋ seeƴkiɗoh ca na yakak ca hiireeɗa mboolnda ne ɓa woyaat ne Barabaas faɗsassaat, Yeesu apu. ");
INSERT INTO sav_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Goornoor kooɗissa woo ka woosa ɓa ne : « Ɗu waaɗ ne ŋ faɗsiɗ ɗu ya ɓa ŋ ƴaaɓi kanak cii ? » Ɓa loffa ne : « Barabaas. » ");
INSERT INTO sav_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaat woosa ɓa ne : « Moo ŋ tuman Yeesu yi na woyse Kiristaani na ? » Ɓa jen ɓa woosa ne : « A daaƴsaat ŋ kurwaa ! » ");
INSERT INTO sav_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A woosa ɓa ne : « A haɓiɗ ye in moɗaaɗi ? » Ɓa ɓaatta woo ŋ ɗafka ne : « A daaƴsaat ŋ kurwaa ! » ");
INSERT INTO sav_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ɓa uupeeɗa nga uup ɗuuɗ, tahha po Pilaat hotta ne a miniɗɗi ɓa in, weɗ a ɓayoh masuɓ, a ɓohñukka ŋ fikiiɓa, a woosa ne : « Inii, ŋ hooliɗ nga, ŋ ɓaahɗi ŋ aami ɗu aaman ñif miŋ ƴaarii. A ɗu inah naa ! » ");
INSERT INTO sav_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓa loffa ɗe jen ne : « Hey ɗah wa ñaakiɗ ɓoo na kuɓuuciŋ ɓoo ! » ");
INSERT INTO sav_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilaat faɗsiɗta ɓa Barabaas, a laɓɗukka Yeesu leraw po ƴutta, a eɗohha ɗe ne a daaƴu ŋ kurwaa. ");
INSERT INTO sav_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Weɗ soldaar caŋ goornoora ɓayoh Yeesu ŋ leero kahna, ɓa willa ɗe findi ɓa hend jen. ");
INSERT INTO sav_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓa wolla kulɓaacaŋ ɗe, ɓa ɓekiɗta ɗe palto ruumind coy. ");
INSERT INTO sav_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓa teɗiɗta ɗe mbahne-buur, ɓa teɗohhaa ñapir, ɓa deggaa ŋ hafiŋ ɗe, ɓa degiɗta ɗe ndooɗ caaɓees ŋ yaahiŋ ɗe ñaahmi, ƴutta ɓa ƴekɗeeɗa ɗe, ɓa njembteeɗa ɗe an : « Ɓoo ɓii kañiɗ ɗa buuriŋ Yawuut ci ! » ");
INSERT INTO sav_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓa tuhseeɗa ɗe, ɓa ɓayya ndooɗaŋ caaɓsa, ɓa laɓeeɗa ɗe wa ŋ haf. ");
INSERT INTO sav_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wa ɓa njembit ɗe po ƴutta, ɓa wolla paltoona ɓa ɓekɗee ɗe, ɓa ɓekɗissa ɗe kulɓaacaŋ ɗe, ɓa ɓayeeɗa ɗe ne ɓa daaƴaa ɗe ŋ kurwaa. ");
INSERT INTO sav_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wa soldaar ca pulee kur ka, ɓa coh na ƴaar gen Sireen teeku Simong, ɓa junnga ɗe ne a deguk kurwaaniŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wa ɓa ree ɗiska na woyse Golgota, wa tokis \"Ƴoh-haf\", ");
INSERT INTO sav_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ɓa eɗta Yeesu biiñ ambsohuuɗ na in aayiɗ ne a an, Yeesu ƴoohhaa, a waaɗɗi an. ");
INSERT INTO sav_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wa ɓa daaƴ ɗe ŋ kurwaa po ƴutta, ɓa piilohha kulɓaacaŋ ɗe ne ɓa paysoh ca, ");
INSERT INTO sav_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ɓa ɓooffa, ɓa niiɗeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓa daaƴeen in, wa tiimmba hafiŋ ɗe ne ɓa teeɓoh ini tah ɗe apu. Inii weɗ ɓa fiisee nga : « Yii a Yeesu buuriŋ Yawuut ci. » ");
INSERT INTO sav_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nguɗndukohoh kanak daaƴseen na ɗe, yii lahha ɗe yaah-ñaahum, yi tas lahha ɗe yaah-sing. ");
INSERT INTO sav_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓooɓa taambee ŋ ɗiska njembteeɗa ɗe, ɓa kuɗteeɗa haf, ɓa ɓaseeɗa ɗe ");
INSERT INTO sav_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","an : « Ngec ! Fu yi woyee ne, fu hey yahrohe Kahniŋ Kooh, fu taɓahisa ŋ neeh kaahay, mucɗa haf fu ! Nik ne a fu Kuɓkiŋ Kooh ɗah, ruhsa ŋ kurwaani. » ");
INSERT INTO sav_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na jangɗohoh caŋ wa na yakak ca nameeɗa ɗe njembit an : ");
INSERT INTO sav_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","« A mucɗiɗ ɓinooɓi, a minɗi muciɗ haf ce ! Nik ne a yi buuriŋ Israayel ɗah, a ruhsaat ŋ kurwaani win-win te ɓoo hey ɗe kose ! ");
INSERT INTO sav_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A wik haf ce Kooh, nik ne Kooh waaɗiɗ ɗe ɗah, a naafaat ɗe kotii. A woo ne a yi Kuɓkiŋ Kooh haa e ! » ");
INSERT INTO sav_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nguɗndukohoh ca daaƴsee na ɗe nameeɗa ɗe ɓasoh ɗaa. ");
INSERT INTO sav_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ina kooɗoh ŋ njooloor, kehƴi jen nikka ŋ ñuus ini ree wahtu kaahay. ");
INSERT INTO sav_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wa wahtuuca kaahay ca hee reehe, Yeesu leehukka ŋ ɗafka an : « Elii, Elii, lema sabahtani ? » Wa tokis \"Koohiŋ ngo, Koohiŋ ngo, wa ye tah fu faɗta so ?\" ");
INSERT INTO sav_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɓi ɓo' ɓaah ŋ ɓa nikee ŋ ndaam kerahhaa, ɓa woosa ne : « A na ɓeeɗke Ilyas ! » ");
INSERT INTO sav_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yino nga ɓa arra nup, ɓayya daah, a hooƴcaa ŋ masuɓ raakiɗ bineegar, a tokkaa ŋ lecem ndooɗ, a eɗta ɗe ne a an. ");
INSERT INTO sav_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waaye ɓinooɓa woyeeɗa ne : « Faɗa ɓoo marak andi Ilyas hey ɗe hee hirpe ! » ");
INSERT INTO sav_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeesu leehkissa ŋ ɗafka, a nguɗta. ");
INSERT INTO sav_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Teemb ndeem, ridoona ɗasɗe Ɗiska Hoolohngaanaŋ Kahnaŋ Kooh faarukka tareet ini kooɗoh ɗafka po kehƴa, kehƴi yoondɗukka, atoh ci yakak ci ɓessa. ");
INSERT INTO sav_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ruy-ruy ci rangsukka, ɓo'-Kooh laayiɗ ɓi inah ne ɓa kaaneen, hultiɗuusa. ");
INSERT INTO sav_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓa pulohha ruy-ruy ca. Ŋ finho hultaŋ ɗe, ɓa aassa ŋ ɗooƴ Yerusalem, ɓa teeɓukka ɓo' laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldaar ca niiɗee Yeesu na ƴaara adgohee ɓa, hotta ina raak jen, na findi kehƴi yoondɗukoh, ɓa feyuusa keeh-keeh, ɓa woosa ne : « Wa keeh ne a nikee Kuɓu Kooh. » ");
INSERT INTO sav_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɓitiɓ laayiɗ nikee nga, ɓa cangtiɗukka usiɗ, ɓa markeeɗa. Ɓitiɓ ceem ñaakɗohoh Yeesu Galile ne ɓa taambkoh ɗe. ");
INSERT INTO sav_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ɓii ɓaahee nga ɓa : Mari Makdala, Mari yaayiŋ Saak na Suseef, na yaayiŋ Saak na Saaŋ, kuɓuuciŋ Sebede. ");
INSERT INTO sav_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wa niina ree, ƴaar teeku Suseef hayya. A nikee ɓo' raakiɗ, a genee Arimate te a ɓaahee ŋ taalubeeciŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A kaɗta ŋ Pilaat, a meekissa ɗe fiɗaafaŋ Yeesu, Pilaat nakohha ne a eɗsaata. ");
INSERT INTO sav_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Suseef ɓayyaa, a ullaa na uuf leeŋ hooliɗ, ");
INSERT INTO sav_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a ɓekkaa ŋ ruy-ruyi a haɓɗiɗee haf ce, ruy-ruy as acuuɗ ŋ hur atoh. Ƴutta, a pilnginnda atoh yakak, a ranngaa, a cootta. ");
INSERT INTO sav_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Makdala na Mari yi yinoori nikee nga ɓoofiɗ, yurhiɗkohiɗ na ruy-ruya. ");
INSERT INTO sav_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ŋ mbeha taamb ŋ reehɗohaanaŋ mbeha na kooɗkohse, kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na Farisen ca hunnda, ɓa kaɗta ŋ Pilaat, ");
INSERT INTO sav_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ɓa woosa ɗe ne : « Kilifaani, ɓoo naandsukiɗ ne, wi ñaañohohii na pese, a woyiɗ ne : “ Ŋ kaan po wa raak neeh kaahay ɗah, ŋ hey hulte. ” ");
INSERT INTO sav_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mbaa nakoha ruy-ruya niiɗu po neeh ci kaahay ci coot, ne taalubeeciŋ ɗe kaɗuu roka fiɗaafaŋ ɗe, ɓa woyuu ɓooɓi ne a hultiɗ. Kon a leyi mirndoh weem uupan moɗaaɗi wa koc. » ");
INSERT INTO sav_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaat woosa ɓa ne : « Soldaar ɓeɗɗi, kaɗaat ɗu niiɗa ruy-ruya findi ɗu waaɗoh. » ");
INSERT INTO sav_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓa kaɗta, ɓa kooɗukka findi ɓaa hee wa niiɗohe, ɓa reewwa atoh fa ŋ nguɓaŋ wa, ɓa tummba nga mandargaani teeɓoh ne wa ranguuɗ, ɓa tufkiɗta soldaar ca ŋ ɗiska. ");
INSERT INTO sav_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wa mbeha na iɗsiɗkohse coot, ŋ wiisaaɗiinaŋ mbehi koc, Mari Makdala na Mari yi yinoori, kaɗta marka ruy-ruya. ");
INSERT INTO sav_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɗekka po kehƴi yoondɗukka keeh-keeh ; malaaka Heɗ ɓoo pulohha Eel ci, a kaɗta pilngina atoh fa rangee wa, a ɓooffa ŋ ɗafuk wa. ");
INSERT INTO sav_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A melciɗeeɗa findi meleñ, kulɓaaciŋ ɗe nikka yaanow tar. ");
INSERT INTO sav_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldaar ca niiɗee ruy-ruya saakɗoheeɗa sagu tiit, ɓa mannda na kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaakaana woosa ɓitiɓ ca ne : « Ɗu, kinaat tiit, ŋ inhiɗ ne ɗu na marke Yeesu yi daaƴsee ŋ kurwaa. ");
INSERT INTO sav_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A nikɗi ndii, a hultiɗuuɗ findi a woyohee wa. Hayaat ɗu marak ɗiski a faansee, ");
INSERT INTO sav_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","te araat kaɗ ɗu woya taalubeeciŋ ɗe ne, a hultiɗuuɗ, a yaa adug ɗu Galile, ɗu na hee ɗe hotohe ndaam ; weɗɗeem, ŋ woyiɗ ɗu wa. » ");
INSERT INTO sav_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Weɗ ɓitiɓ ca aroh kurkoh ŋ ruy-ruya, ɓa feyuusa waaye, ɓa summba keeh-keeh, ɓa nuppa ne ɓa woyaa wa taalubeeca. ");
INSERT INTO sav_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wa ɓa kaɗee, weɗ Yeesu hayoh cohe na ɓa, a woosa ɓa ne : « Ɗu tum na ? » Ɓa reɓpa nga ɗe, ɓa ammba kot ciŋ ɗe, ɓa ƴekka ne ɓa ñaamuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeesu woosa ɓa ne : « Kinaat neƴƴoh ; kaɗaat ɗu woya ɓooɓiŋ ngo ne ɓa kaɗaat Galile, ɓa hotohan ndo ndaam. » ");
INSERT INTO sav_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wa ɓa kaɗe, ɓi ɓo' ɓaah ŋ ɓa niiɗee ruy-ruya kaɗta kur ka, naandsukka kilifaacaŋ seeƴkiɗoh ca ini raak jen. ");
INSERT INTO sav_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wa ɓeem coh na yakak ca, ɓa kerhiɗohha na ɓa ŋ woo, ɓa puliɗta kopor laayiɗ, ɓa eɗtaa ɓa niiɗee ruy-ruya. ");
INSERT INTO sav_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ɓa woosa ɓa ne : « Woyaat ne, a taalubeeciŋ ɗe tel ɗu nga na wek, raak ɗu neehiɗ, ɓa rokka fiɗaafi, ");
INSERT INTO sav_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","te goornoor keraha ɗah, ɓoo hey woye na ɗe, ineem kanaat ɗu jaahiɗ. » ");
INSERT INTO sav_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ɓa ɓayya kopora, ɓa tumohha findi ɓa woyohu, woo keem pasarkohha ŋ ɗooƴ Yawuut ci po woti. ");
INSERT INTO sav_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taalubeeca ndaŋkiyaah na yinooca (11) kaɗta Galile ŋ tangoora Yeesu woye. ");
INSERT INTO sav_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wa ɓa hot ɗe, ɓa ñaamkeeɗa ɗe, waaye raakka ɓi liiɓsiɗohee nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Weɗ Yeesu reɓoh nga ɓa, a woosa ɓa ne : « Eel ci na kehƴi jen deguuɗ ŋ yaah ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaɗaat ŋ cuuɓ ciŋ adinaani jen, ɗu tum ɓooɓi taalube, ɗu ɓokit ɓa ŋ tiikiŋ Baabi na Kuɓki na Fuuɗsi Hoolohngaani, ");
INSERT INTO sav_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ɗu jangiɗ ɓa po ɓa taambiɗ nakoh ci ŋ eɗ ɗu jen. Te ambaat ne : Ŋ hey nike na ɗu Kooh-nu-wiis po mbaɗna Adina reehan. »");
INSERT INTO sav_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yegɗohiŋ Muci, ŋ ini kaɗ ŋ Yeesu Kiristaa, Kuɓkiŋ Kooh, camboh an : ");
INSERT INTO sav_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngaŋ findi wa fiisohu ŋ teerndiŋ woosuuɗi Esayi ne : « Marka, ŋ hey tuuƴe woosuuɗiŋ ngo, a adug ɗa, ne a haɓɗiɗ ɗa waasi. ");
INSERT INTO sav_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","E hoosoora na leehke ŋ nduufa an : “ Paɗaat waasiŋ Heɗ ɓoo, haɓɗiɗaat ɗe waas ci, ca yurah. ” » ");
INSERT INTO sav_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ŋ ineem Yahya Ɓoktohi hotukka, a ɓokteeɗa ɓooɓa na masuɓ ŋ nduufa. A inhiɗeeɗa ɓa ne ɓa hayaat ɓa ɓoktuk, wa teeɓoh ne ɓa teyiɗ ɓoƴsoh pesohaaɗ, ɓa min ɗaasu bakaaɗ ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓooɓa genee Yudee na ɓaŋ Yerusalem jen, kaɗeeɗa nga ɗe. Ɓa teyɗukeeɗa bakaaɗ caŋ ɓa, a ɓokteeɗa ɓa ŋ kalaŋ Yurdan. ");
INSERT INTO sav_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahya meeɗ ɓekuk kulɓa haɓɗohuuɗ find ngeelemb, a toka ŋ kinoh kiŋ ɗe na und. A meeɗta ñam paƴ na yeeleel kuum. ");
INSERT INTO sav_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A yegɗoheeɗa an : « Raakiɗ ɓoyi na haye ŋ finhooso, a yi uup po yak, ŋ yeyyooɗi nik ñaamiŋ ɗe ne ŋ hiir ŋ toksiɗee ɗe liiɓ ciŋ ñafaɗ ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi na ɓoktee ɗu na masuɓ waaye a yi, a ɓoktohan ɗu Fuuɗsi Hoolohngaani. » ");
INSERT INTO sav_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ŋ jamanoonaam, Yeesu pulohha kur ka na woyse Nasareet ŋ Galile, Yahya Ɓoktohi ɓokitta ɗe ŋ Yurdan. ");
INSERT INTO sav_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wa Yeesu pulee ŋ masma, a hotta Eel ci faarkiɗ, Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh yipkeeɗa nga ɗe ŋ mandohaaɗ banuut. ");
INSERT INTO sav_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hooso kurkoh ŋ Eel ci kerhukka an : « A fu Kuɓkiŋ ngo ŋ waaɗ keeh-keeh te ŋ neɓuuɗ nga ɗa lool. » ");
INSERT INTO sav_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jaarra Fuuɗsi Hoolohngaani hiirra Yeesu ŋ kaɗ nduufa. ");
INSERT INTO sav_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A nikka nga neeh ndaŋkiyaah-nikiis (40), Seytaani jaɗɗeeɗa ɗe fiir. A nikee ŋ ɗiska inah ne ca ɗoopaat-nduuf dong nikee nga, malaakaaca taambkoheeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ŋ jamanoona Yahya Ɓoktohi rangohu ŋ kasoona, weɗ Yeesu kaɗoh Galile, a woyeeɗa Yegɗohiŋ Muci, wi puloh ŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","An : « Jamanooni gapsee reyiɗ. Nguuriŋ-Kooh reɓiɗ ! Ɓoƴsohaat pesohaaɗ te ɗu kos Yegɗohiŋ Muci ! » ");
INSERT INTO sav_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wa raakka mbeh, a hunnda na sereendaŋ Cookmaŋ-Galile, a kaɗeeɗa. A hotta seeɓoh kanak mbaaleeɗa cuurund ; ɓa nikee Simong na taambɗoh ce Andare. ");
INSERT INTO sav_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A woosa ɓa ne : « Ñaakɗaat to, ŋ hey ɗu tume ɗu nik seeɓoh ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɓa jaarra faɗ mbaal caŋ ɓa ndaam, ɓa ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A kaɗissa ƴissuut, a hotta kuɓuuciŋ Sebede ŋ gaal haɓiɗtineeɗa mbaal caŋ ɓa ; ɓa nikee Saak na taambɗoh ce Saaŋ. ");
INSERT INTO sav_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A jaarra ɓa ɓeeɗuk ne ɓa ñaakiɗ ɗe. Ɓa faɗta baab ɓa Sebede na pangkoh caŋ ɗe ŋ gaala, ɓa ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wa taalubeeca ñaakiɗ Yeesu, a hunnda na ɓa kur ka na woyse Kapernawum. Ŋ mbehi na iɗsiɗkohse, a aassa ŋ sinaagoga, a jangɗoheeɗa. ");
INSERT INTO sav_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɓooɓa feyuusa ŋ jangɗohaŋ ɗe. Jangɗohaaɗaŋ ɗe ɗaloheen na findi jangɗohoh caŋ waasiŋMusaa na tumohe, laam a woyee keeh-keeh findi kilifa. ");
INSERT INTO sav_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Teemb ndeem, wa raakeen ƴaar ŋ sinaagoga, a jiini ambee ɗe. A leehkeeɗa ŋ ɗooƴ sinaagoga an : ");
INSERT INTO sav_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","« Yeesu yiŋ Nasareet, waas fu ye nga ɓoo ? Fu hay ne fu yah ɓoo e ? Ŋ inhiɗ ɓoyi fu nikoh, a fu Ɓoyi Hooliɗi Kooh woos. » ");
INSERT INTO sav_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeesu ngassa ɗe an : « Ɗeka te fu pul ngaŋ ƴaari ! » ");
INSERT INTO sav_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jiinnda, na hoolaaɗiika a hoolaaɗi, a pulla ngaŋ ƴaara, a ambsohhaa na sesoh na yoondiɗ ɗe keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɓooɓa nikee ŋ ɗiska jen feyuusa, tahha po ɓa woyeeɗa ŋ harmban ɓa ne : « Inii min na nikoh ? Wii deey, wa jangɗoh as, wa hun na hatil ! A na woye woo na jiiniici, ca tum ini a woo. » ");
INSERT INTO sav_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wa taambohha ndeem, tiikiŋ Yeesu laamtohseeɗa ŋ kur caŋ Galile jen. ");
INSERT INTO sav_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wa Yeesu na taalubeeciŋ ɗe puloh ŋ sinaagoga, Saak na Saaŋ hunee na ɗe, ɓa kaɗta kahan ɓi Simong na Andare. ");
INSERT INTO sav_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wa a ree, a raak yaayiŋ ɓiti Simong ŋ fiƴaang, faaniŋ ɗe dohee doh, Yeesu woyuusaa. ");
INSERT INTO sav_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeesu reɓpa nga ɗe, a ammba ɗe ŋ yaah, a kurkiɗta ɗe, dohɗaŋ faana saɓsukohha na ɗe po a taambkoheeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na niina, wa noha muy, a komuusa kosaayiɗ ca jen, na ɓa jiini ambe. ");
INSERT INTO sav_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɓi kur ka jen cohha ŋ nguɓu kahna. ");
INSERT INTO sav_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A wiriɗta ɓo' laayiɗ na kosaay ɗalohiɗ. A nammba aañ jiini laayiɗ, a faɗɗi ca ne ca woo ; ca inhee inah ɓoyi a nikoh weɗ tah. ");
INSERT INTO sav_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ŋ ɗooƴ weka, bala Kooh wiisan ɗah, a kurukka, a kaɗta ŋ ɗisik ɗaayiɗ, a kiimeeɗa Kooh nga. ");
INSERT INTO sav_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simong na huntoh caŋ ɗe kaɗta ɗe waaka. ");
INSERT INTO sav_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wa ɓa hot ɗe, ɓa woosa ɗe ne : « Ɓooɓi jen na waakee ɗa. » ");
INSERT INTO sav_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeesu woosa ɓa ne : « Ɓoo kaɗaat ŋ kur ci cinooci reɓ ndii, ŋ woo Yegɗohiŋ Muci nga, findi ŋ woyoha ŋ ndii ; ineem weɗ tah ho hay. » ");
INSERT INTO sav_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ŋ ineem, a kaɗta ŋ ɗisik nu ɗisik ŋ Galile, a yegɗoheeɗaa ngaŋ sinaagog ca, a aañeeɗa jiiniica. ");
INSERT INTO sav_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yeesu kaɗeeɗa, ƴaar kosaayiɗ kosaay ki na oɓse faan hayya, ƴekka ŋ fikiice, kiimmba ɗe ne : « Fu waaɗa ɗah, fu miniɗ to saɓsoh na kosaay kii po ŋ nik ɓo' hooliɗ. » ");
INSERT INTO sav_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A misikka Yeesu lool, Yeesu raɗissa yaah, a degga ɗe wa, a woosa ɗe ne : « Ŋ waaɗiɗa, hoola ! » ");
INSERT INTO sav_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ŋ ɗiska ɗiska, kosaay ka saɓsukohha na ƴaara, a hoolla. ");
INSERT INTO sav_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ƴutta Yeesu woosa ɗe ne a kaɗaat, a dennga ɗe na woo ndengiɗ an : « Wortukaa wa woo ali ɓo', kaɗa fu teeɓa haf fu seeƴkiɗoha, fu haɓiɗ seeƴki waasiŋ Musaa nakoh ne fu hool, wa teeɓoh ne fu wiriɗ. » ");
INSERT INTO sav_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Waaye ƴaara cootta, a woyeeɗaa, tahha po wa yooɓisseeɗi ne Yeesu aas ŋ kur. A nikka ŋ nduufa, ɓooɓa puloheeɗa ɗisik nu ɗisik raakeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wa degga ɓi neeh, Yeesu dokukka Kapernawum. Ɓooɓa kerahha ne a yaa ŋ kahan ɓa, ");
INSERT INTO sav_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","mboolo laayiɗ cohha ŋ ɗiska, wa riiffa po, nikoha sah raakisseeɗi ŋ nguɓu kahna. A woyeeɗa ɓa woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɗekka po ɓa kommba ɗe ƴaar lafñiɗ, ƴaar nikiis ɓeɗ gaalɗohee ɗe ŋ faankoha. ");
INSERT INTO sav_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ɓa minɗi ree na ɗe ŋ Yeesu sagu findi ɓooɓa laayohe, tahha po ɓa nihissa ŋ poonaŋ taɓaha teemb ŋ ɗiska Yeesu nike, ɓa yoorra ƴaara nga na faankohaanaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wa Yeesu hot ɓa na findi ɓa kosoh, a woosa lafñiɗa ne : « Ƴaariŋ ngo, fu ɗaasuuɗ bakaaɗ ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Raak ɓi ɓo' ɓaah ŋ jangɗohoh caŋ waasiŋMusaa ɓoofiɗ. Ɓa woyeeɗa ŋ ɗooƴ ɓa an : ");
INSERT INTO sav_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","« Ƴaarii a kaañoh woo ineem na ? A ɗalee Kooh. Ali ɓo' minɗi ɗaasoh bakaaɗ ɗal Kooh dong ! » ");
INSERT INTO sav_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeesu jaarra inah ina ɓa liiɓee ŋ ɗooƴ hel ciŋ ɓa, a woosa ɓa ne : « Wa ye tah ɗu raakee liiɓohaaɗ mand ɗaa ? ");
INSERT INTO sav_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ŋ woo ƴaarii ne : “ Fu ɗaasuuɗ bakaaɗ ciŋ ɗa ” wala ŋ woo ɗe ne : “ Kurka, ɓaya faankohaaniŋ ɗa, fu tiind. ” A winde uup yooɓ ? ");
INSERT INTO sav_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Waaye, ne ɗu inah ne Kuɓkiŋ ɓoyi raakiɗ hatili a min ɗaasoh bakaaɗ ŋ kehƴi - markaat rek. » A woosa ƴaara ne : ");
INSERT INTO sav_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","« Ñam woo ɗa wa, kurka fu ɓay faankohaaniŋ ɗa, fu haad. » ");
INSERT INTO sav_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ŋ ɗiska ɗiska, ƴaara kurukka ŋ fiki ɓooɓa, a ɓayya faankohaanaŋ ɗe, a pulla. Ɓooɓa jen feyuusa, ɓa yakɗeeɗa Kooh, ɓa woyeeɗa ne : « Ɓoo hotohɗi in mand an ! » ");
INSERT INTO sav_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeesu dokkissa ŋ ɓakaŋ cookma. Ɓooɓa jen raakeeɗa ɗe nga, a jangɗeeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wa Yeesu kaɗe, a hotta Lewi kuɓkiŋ Alfe, ɓoofiɗ ŋ ɗiska a na juuti'ohe. A woosa ɗe ne : « Ñaakiɗ to. » Lewi kurukka, ñaakiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wa raakka mbeh, Yeesu nikka ŋ kahan Lewi na taalubeeciŋ ɗe, a ñameeɗa na ɓa na juuti'oh laayiɗ na bakaaɗoh laayiɗ ; ɓo' laayiɗ mand ɗaa nikee ñaakɗeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jangɗohoh caŋ waasi ɓaahee ŋ Farisen ca hotta ɗe ñameeɗa na ɓooɓeem, ɓa woosa taalubeeciŋ ɗe ne : « Wa ye tah kilifaaniŋ ɗu ñamee na juuti'oh ci na bakaaɗoh ci ? » ");
INSERT INTO sav_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeesu kerahha ɓa, a loffa ɓa ne : « Ɓooɓi kosaayɗi etohɗi paƴoh, e kosaayiɗ ci etoh paƴoh. Ŋ hayɗi ne ŋ ɓeeɗuk ɓooɓi yurhiɗ ci waaye ŋ hay ne ŋ ɓeeɗuk bakaaɗoh ci. » ");
INSERT INTO sav_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wa raakka mbeh, taalubeecaŋ Yahya Ɓoktohi na Farisen ca oreeɗa. Ɓi ɓo' hayya ŋ Yeesu, ɓa woosa ɗe ne : « Wee tah hey ɗah taalubeeciŋ Yahya Ɓoktohi na ɓiŋ Farisen ci ore, ɓiŋ ɗa oruu ? » ");
INSERT INTO sav_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A loffa ɓa ne : « Hanheeci hay kilook miniɗ or te raak heɗ kilooki yii na ɓa e ? Wa minɗi nik, feeh a yii na ɓa ɗah. ");
INSERT INTO sav_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Waaye, wa hey raake jamano heɗ kilooki kooɗohu nga ɓa, ŋ ndeem, ɓa hey ore. ");
INSERT INTO sav_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ali ɓo' na daafeeɗi kulɓa maañiɗ na seeket as ; mbaa seeketi hey nookɗohe kulɓaaki, kulɓaaki uup nga faaruk. ");
INSERT INTO sav_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ali ɓo' na nameeɗi tum biiñi asi na soñe ŋ mbohos und maañiɗ ; mbaa biiñi asi hey pooke mbohoseem, biiñi na mbohosi jen yahrukoh. Biiñ as joy tumu ŋ mbohos as. » ");
INSERT INTO sav_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wa nikee ŋ mbehi na iɗsiɗkohse, Yeesu na taalubeeciŋ ɗe kaɗeeɗa, ɓa taammba ŋ yohon caŋ beleeca. Ŋ waasa, taalubeeciŋ ɗe piikeeɗa nga ca. ");
INSERT INTO sav_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisen ca woosa ɗe ne : « Marka, wa ye tah taalubeeciŋ ɗa haɓɗee ini waasiŋ ɓoo sangoh ŋ mbehi na iɗsiɗkohse ? » ");
INSERT INTO sav_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeesu loffa ɓa ne : « Mand haa ne ɗu moosɗi jangoh ina Dawuuda haɓɗee wa a aɗuk, a raakɗi ñamaah, a yi na ɓooɓa hunee na ɗe ? ");
INSERT INTO sav_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A aas ŋ Kahan Kooh. Wa nikee ŋ jamanoonaŋ Abiyatar, seeƴkiɗoha yakka. Dawuuda ɓayya mbuuruuca degsee ŋ taaɓla wuu Kooh a ñammba nga ca, a nammba eɗ ɓooɓa hunee na ɗe. Te ali ɓo' joyɗi ñam mbuuruuceem ɗal seeƴkiɗoh ci. » ");
INSERT INTO sav_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A degiɗta ɓa nga ne : « A ɓo' tah mbehi na iɗsiɗkohse waaku, mbehi na iɗsiɗkohse tahɗi ɓo' feru. ");
INSERT INTO sav_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kon mbaa Kuɓkiŋ ɓoyi a yi Heɗ mbehi na iɗsiɗkohse sah. » ");
INSERT INTO sav_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wa raakka mbeh, Yeesu aasissa sinaagoga. Ndaam, ƴaar nikeen nga yaahiŋ ɗe ɓeendkee ɓeenduk. ");
INSERT INTO sav_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓum markiɗeeɗa Yeesu andi a hey wirɗe ƴaara ŋ mbehi na iɗsiɗkohse, ɓa raak yambaah ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A woosa ƴaara na yaaha ne : « Kurka fu tufuk ŋ fiki ɓooɓi jen. » ");
INSERT INTO sav_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ƴutta Yeesu meekissa ɓa ne : « Wa ye teyɗohu ŋ mbehi na iɗsiɗkohse, in baahiɗ wala in baahaaɗi, ɓo' joy joy hirpu nga wala a joy joy apu ? » Waaye ɓa lofɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A markeeɗa ɓa na ayruk, a raakka neɓsaaɗi ŋ ndenga keeñ caŋ ɓa ndenge. A woosa ƴaara ne : « Raɗsa yaahiŋ ɗa. » A raɗissaa, wa wirra peng. ");
INSERT INTO sav_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisen ca jaarra pul, ɓa kaɗta hotoha na ɓa langee na buur Herod, ne ɓa marak findi ɓa joy ɗe apoh. ");
INSERT INTO sav_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ŋ jamanooneem, Yeesu na taalubeeciŋ ɗe kaɗta nika ɓakaŋ cookma, mboolo keeh-keeh puloh Galile hunnda na ɗe. Raakka ɓa kerah in ca a tumee, tahha po ɓa pulohha kur caŋ Yudee, Yerusalem, na kur caŋ Idime, na caŋ ɓaka faahaŋ kalaŋ Yurdan, na ina wil Tiir na Sidoon, ɓa nammba coh ŋ ɗiska na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A woosa taalubeeciŋ ɗe ne ɓa ɗaakɗohaahaat ɗe gaal ƴin ; a sangee ne mboolnda baɓuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wirɗa a wirɗee kosaayiɗ laayiɗ, weɗ tahee po ɓa raakee kosaay jen, giirkeeɗa giiruk nga ɗe ne ɓa laal ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te jiiniici hotta ɗe ɗah, ca fol ɓooɓi ca amb ŋ fikiice, ca leehkiɗukohee ɓa ne : « A fu Kuɓkiŋ Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Waaye Yeesu meeɗta ca ngas baahiɗ ne ca kinaat ɗe teeɓoh. ");
INSERT INTO sav_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kurkohha ndeem, Yeesu rappa ŋ ɗafuk tango, a ɓeeɗukka ɓi ɓo' ŋ waaɗ-waaɗiŋ ɗe, ɓa hayya nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A kooɗta nga ɓa ɓo' ndaŋkiyaah na kanak (12) ne ɓa nik na ɗe a teekka ɓa \"Apootar\". A tuuƴee ɓa, ne ɓa woya Yegɗohiŋ Muci, ");
INSERT INTO sav_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ɓa aañee jiiniici, a eɗta ɓa hatili. ");
INSERT INTO sav_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndaŋkiyaah na kanak ci (12) a kooɗee nike : Simong yi a teekee Piyeer ; ");
INSERT INTO sav_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saak na Saaŋ, kuɓuuciŋ Sebede ; Yeesu teekee ɓa Bowanerses wi tokis kuɓu inding ; ");
INSERT INTO sav_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Andare, na Filip, na Bartalemi, na Macce, na Tomaa, na Saak kuɓkiŋ Alfe, na Tade, na Simong yi nikee Selot ");
INSERT INTO sav_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yudaa Iskaryot yi wor ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wa raakka mbeh, ɓi Yeesu aassa kahan, mboolo cohissa nga po a yi na taalubeeciŋ ɗe minɗi ñam. ");
INSERT INTO sav_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɓi kahan ɓa yeggaa, ɓa kaɗta ɗe ɓaya, ɓa woyee ne : « Hafiŋ ɗe riifisɗi. » ");
INSERT INTO sav_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jangɗohoh caŋ waasiŋMusaa, ɓi pulohee Yerusalem woosa ne : « A Belsebul na ɗe ! » Ɓa woyissa ne : « Hatiliŋ kilifaaniŋ jiiniici weɗ a na aañohe jiiniici. » ");
INSERT INTO sav_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ŋ ineem Yeesu ɓeeɗukka ɓa, a woosa ɓa ŋ andiin ne : « Seytaani min na aañoh haf ce ? ");
INSERT INTO sav_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɓooɓi ɓaah nguur hiñohee ŋ harmban ɓa ɗah, nguureem minanɗi tufuk. ");
INSERT INTO sav_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te ɓooɓi ɓaah kahan hiñohee ŋ harmban ɓa ɗah, kahneem minanɗi tufuk. ");
INSERT INTO sav_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kon, wa nik ne Seytaani na hiñohe ŋ ɗooƴ ce ɗah, nguuriŋ ɗe hey paysukohe te wa heeɗi minise tufuk, wa heen reehɗukohe. ");
INSERT INTO sav_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ali ɓo' minɗi aas ŋ kahan ɓo' raakiɗ hatil, a ɓay in ciŋ ɗe, te a tokɗi ɗe po a ndeng. Waaye a tok ɗe ɗah, a hey ɓaye in ciŋ kahan ce jen. ");
INSERT INTO sav_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ñam na woyee ɗu wa te wa keeh, ɓooɓi ɗaasnuk ɗah, ɓa hey ɗaasse bakaaɗ nu bakaaɗ na ɗal nu ɓa ɗal Kooh ɗah. ");
INSERT INTO sav_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Waaye ɓo' nu ɗal Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh ɗah, a ɗaassanɗi bakaaɗeem muk, wa taambɗan ɗe taambiɗ po faw. » ");
INSERT INTO sav_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeesu woyiɗ ineem sagu ina ɓa woyee ne a jiini na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Weɗi yaay ɓa na taambɗoh ciŋ ɗe reyoh, ɓa tufukka ŋ hara, ɓa nakohha ɗe ɓeeɗkiɗu. ");
INSERT INTO sav_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Raak mboolnda ɓoofiɗ wiliɗ ɗe, a woyuusa ne : « Tassa yaay ɗu na taambɗoh ciŋ ɗa, ɓa ɗaa ŋ hara na meeksohee ɗa. » ");
INSERT INTO sav_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A loffa ne : « Ɗu amb ne a ɓa yaay ɓoo, e ɓinde taambɗoh ciŋ ngo ? » ");
INSERT INTO sav_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A marakka ɓooɓi wil ɗe, a woosa ne : « Ɓooɓii, ɓeɗ yaay ɓoo, ɓeɗ taambɗoh ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɓo' nu na haɓɗe ini Kooh waaɗ ɗah, ɓoyeem a taambɗoh ho ƴaar mbaa ɓitiɓ, wala yaay ɓoo. » ");
INSERT INTO sav_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wa raakissa mbeh, Yeesu nikka ŋ sereendaŋ cookma, a jangɗoheeɗa. Mboolnda wilee ɗe laayya lool, po a mirndohha rap ŋ gaal, a ɓooffa nga ; a nikka ŋ masma, mboolnda nikka ŋ sereenda. ");
INSERT INTO sav_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A jangɗeeɗa ɓa ŋ andiin inaa laayiɗ, a woosa ɓa ŋ ɗooƴ jangɗoha ne : ");
INSERT INTO sav_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","« Sikɗukaat ! A nikee guuroh, a kaɗta soka. ");
INSERT INTO sav_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wi a soke, a saaweeɗa tisohi, in nga hennda ŋ waasi ŋ ɗooƴ yohni, sel ci hayya ñammbaa. ");
INSERT INTO sav_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Raakka ci keen ŋ ɗisik laayaaɗi merhey, raakiɗ atoh, tahha po ca arra paar, ");
INSERT INTO sav_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","waaye wi nohi dam, in ca paaree leeɓpa po ca onnja sagu ini ca raakeeɗi niir nooɗiɗ. ");
INSERT INTO sav_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","In ŋ tisohi nammba keen ŋ ɗisik raakiɗ ñaaɓaaɓ ; ca paarandoosa na ñaaɓaaɓ ca, ceem ndooƴca ca po ca raakɗi ali rim. ");
INSERT INTO sav_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waaye raakka ci keen ŋ keheƴ baahiɗ, ca paarra, ca yakka, ca rimmba, cum eɗohha rim ndaŋkiyaah-kaahay (30), cum ndaŋkiyaah-yasna-yino (60), cum teemet (100). » ");
INSERT INTO sav_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ƴutta, Yeesu woosa ɓa ne : « Ɓo' nu raak nof kerhoha ɗah, a kerhaat. » ");
INSERT INTO sav_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wa a saɓsukoh na mboolnda po a nikka na taalubeeci ndaŋkiyaah na kanak ci (12) na ɓooɓa meeɗ nik na ɗe, ɓa meekissa ɗe ini kaɗ ŋ andiin ceem. ");
INSERT INTO sav_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A loffa ɓa ne : « Ɗu onuuɗ ne ɗu inah ini ɗasɗukiɗiŋ Nguuriŋ-Kooh. Waaye ɓaahaaɗiici na rahse in ci jen ngaŋ andiin ");
INSERT INTO sav_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ne “ ɓa markee baahiɗ, ɓa minuu hot ; ɓa sikɗukee baahiɗ, ɓa minuu inah. Ŋ ineem, ɓa ɓoƴsohuu kipes po Kooh kee ɓa ɗaasa bakaaɗ ciŋ ɓa. ” » ");
INSERT INTO sav_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeesu woyissa ɓa ne : « Ɗu inahɗi ini andiinii tokis e ? Kon, ne ɗu inah ci tas jen wa hey miske nga ɗu ! ");
INSERT INTO sav_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sokohi na soke woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓum ɓeɗ ŋ sero waasi, ɗiski Woo ki saawu ; ɓeɗ ɓooɓi na kerhe woo kiŋ Kooh, Seytaani jaar hay, nihisa nga ɓa. ");
INSERT INTO sav_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓum ɓeɗ paaroh ŋ ini saawu ŋ kehƴi raak atoh ci ; ɓeɗ ɓooɓi na kerhe Woo ki, ɓa jaara teyɗuk na keeñ soosiɗ, ");
INSERT INTO sav_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","waaye ɓa na raakeeɗi niir ŋ haf ɓa, ɓa na maañeeɗi nga. Ɓa raak miskiɗ wala ɓa tolfiɗassee sagu Woo ki ɗah, ɓa ar faɗ. ");
INSERT INTO sav_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓum ɓeɗ paaroh ŋ ini saawu ŋ ñaaɓaaɓ ci ; ɓeɗ ɓooɓi na kerhe Woo ki, ɓa teyɗuka, ");
INSERT INTO sav_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","waaye liiɓsiɗoh ci, na raak-raak ci na njuyohe, na waaɗ neɓiɗ ciŋ Adina, amb ɓa po Woo ki minuu rim ali in. ");
INSERT INTO sav_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓinooɓi ɓeɗ paaroh ŋ ini saawu ŋ kehƴi baahiɗi ; ɓeɗ ɓi na kerhe Woo ki, ɓa teyɗuka. Ɓa raak rim, ɓum ndaŋkiyaah-kaahay (30), ɓum ndaŋkiyaah-yasna-yino (60), ɓinooɓi teemet (100). » ");
INSERT INTO sav_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeesu woyissa ɓa ne : « Laampa na ɓayse ne wa kunu na kanoh wala wa ɗaaku ŋ ooɓ fiƴaangi e ? Wa na degse ŋ degohaaniŋ wa kay ! ");
INSERT INTO sav_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","In nu ɗembɗu ɗah, wa ɗembɗu ne mbeh hey haye, wa teeɓohu. In nu ɗasɗu ɗah, wa ɗasɗu ne mbeh hey haye, wa teeɓohu noh cong. ");
INSERT INTO sav_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɓo' nu raak nof kerhoha ɗah, a kerhaat. » ");
INSERT INTO sav_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A woyissa ɓa ne : « Markissaat baahiɗ ini ɗu na kerhe ! Inhaat ne, ɓeesohaani ɗu na ɓeesɗohohe, weɗ ɗu ɓeesɗohsan, ƴut ɗah, ɗu ɓaatu. ");
INSERT INTO sav_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Laam ɓoyi raak hey ɓaatse, waaye ɓoyi raakɗi, ini ƴissuuti a amb sah hey naafse nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeesu woyissa ɓa ne : « Nguuriŋ-Kooh mand na inii : A nikee ɓo', a sokka tisoh ŋ yohon. ");
INSERT INTO sav_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ƴutta, a taalndiɗta, wek reesa ɗah a neehe, noh ɗah a kuruk. Tisoha paarra po wa yakka te a inahɗi findi wa kaɗoh po wa hennda ɗaa. ");
INSERT INTO sav_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A merhey mi ŋ haf wa paariɗa, wa raakka pok, wa ɓiɗissa, wa marakka ; ");
INSERT INTO sav_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","wa ruunnda rek, a inahha ne nguɗ reyiɗ, a ɓayya japil, a nguɗtaa. » ");
INSERT INTO sav_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeesu woyissa ne : « Ɓoo min mandtiɗkoh Nguuriŋ-Kooh na ye ? Ɓoo mina teeɓoh na winde andiin ? ");
INSERT INTO sav_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wa mand na kuɓu mutarda, wa sokuusa ɗah, weɗ na uupe ƴissuut ŋ tisoh ciŋ kidig ci ƴin ci na sokse ŋ nguuk jen, ");
INSERT INTO sav_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","waaye wa sokuusa po wa paarra ɗah, wa yak po wa uup ca, wa raak naak yakak po sel ci min taar ŋ saangniŋ wa. » ");
INSERT INTO sav_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeesu jangɗohohee ɓa ɗaa, ŋ andiin laayiɗ findi andiin cii, a jangɗeeɗa ɓa in hend na ini haf ciŋ ɓa min amb. ");
INSERT INTO sav_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A woyeeɗi na ɓa ŋ ini nikɗi andiin, waaye a ɗaayya na taalubeeciŋ ɗe ɗah, a toksiɗ ɓa ca jen. ");
INSERT INTO sav_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mbaɗi, wa noha muy, Yeesu woosa taalubeeciŋ ɗe ne : « Ɓoo kaɗaat ŋ ɓaka faahaŋ cookma. » ");
INSERT INTO sav_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓa faɗta mboolnda ndaam, taalubeeciŋ ɗe ɓayya ɗe na gaala a nikohe, ɓi gaal wiiriis hunnda na ɓa. ");
INSERT INTO sav_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɗekka po pahul yakak kurukka, ginaah ca laɓkeeɗa ŋ gaala po wa riifiɗta na masuɓ. ");
INSERT INTO sav_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Raak Yeesu neeheeɗa ŋ lecmaŋ gaala, a ooɓpa tiknukoha ŋ hafiŋ ɗe ; taalubeeciŋ ɗe yunnda ɗe, woosa ɗe ne : « Jangɗohohi, sooƴi ɓoo na sooƴe wii, tumɗi ɗa in e ? » ");
INSERT INTO sav_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wa a yunu, a ngassa puuɗsa, a woosa cookma ne : « Yeeɓka ! Seema ! » Puuɗsa seemmba, ɗiska eennda teɗ. ");
INSERT INTO sav_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ƴutta a woosa taalubeeciŋ ɗe ne : « Wa ye tah ɗu neek ? Ɗu ris kosɗi poyi e ? » ");
INSERT INTO sav_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓa feyuusa lool, ɓa woyeeɗa ŋ harmban ɓa ne : « Ƴaarii joy nik ɓa po puuɗsi na cookmi sah kerhiɗee ɗe ? » ");
INSERT INTO sav_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wa Yeesu na taalubeeciŋ ɗe ree ɓaka faahaŋ Cookmaŋ-Galile, ngaŋ kur kaŋ Geraas ca, ");
INSERT INTO sav_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","a pulee pul ŋ gaala rek, ƴaar, yi fu inah ne e jiini ambee ɗe, kurkohha ɗiska a nikee ŋ ruy-ruy ca, kaɗta coha na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A genee nga ca, ɓo' minisseeɗi ɗe ndengiɗ, ali a toku na ceen sah. ");
INSERT INTO sav_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A meeɗ meeɗ nguɗsoh ceen ci yaah ciŋ ɗe meeɗ tokohu daggid, a pooksoh jatngiŋ kot ciŋ ɗe muƴ ; ali ɓo' mineeɗi ɗe ndengiɗ. ");
INSERT INTO sav_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A nikangee noha na weka ŋ ruy-ruy ca na tangooca, a leehke, a gaañee haf ce na atoh. ");
INSERT INTO sav_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wa a ƴok Yeesu, a kaɗta coha na ɗe na mbup, a ƴekka ŋ fikiice. ");
INSERT INTO sav_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A leehukka ŋ ɗafka ne : « Yeesu Kuɓkiŋ Kooh yi ŋ ɗafka ɗafka, fu nar ye nga so ? Mi yii kiim ɗa po ŋ fiki Kooh, kinaa so deg miskiɗ. » ");
INSERT INTO sav_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A woyiɗ ineem sagu ne Yeesu woyee ɗe ne : « Jiinndi, pula ŋ ƴaarii na hoolaaɗiikiŋ ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeesu meekissa ɗe ne : « Fu teeku na ? » A loffa ɗe ne : « Lesiyong weɗ tiikiŋ ngo, laayi ɓoo laay, weɗ tah. » ");
INSERT INTO sav_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A kiimeeɗa Yeesu keeh-keeh ne a kinaat ca cootiɗ ɗisik usiɗ. ");
INSERT INTO sav_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Raak gat mbaam-huk ñameeɗa ŋ sero tangoora. Wa nikee gat yakak. ");
INSERT INTO sav_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jiiniica kiimmba Yeesu keeh-keeh an : « Yurhiɗa ɓoo ŋ mbaam ci, ne ɓoo aas nga ca. » ");
INSERT INTO sav_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A onnda ca ineem, ca pulla ŋ ƴaara, ca aassa ŋ mbaam ca. Mbaam ca ɗaleen ree junni-kanak (2000) wala ca uupa. Gata jen giirukka, hunnda na mbartala, faɗsukka ŋ cookma, mbaam ca lappa nga. ");
INSERT INTO sav_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ɓooɓa niiɗee ca nuppa, kaɗtaa woya ŋ kur-taaha na kur ca ƴin ca. Wa ɓooɓa hay marke, ");
INSERT INTO sav_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ɓa kaɗta ŋ Yeesu, ɓa raakka ƴaara jiiniica laayiɗ ca ambee ɓoofiɗ moɗoɗ, ɓekkiɗ kulɓa, a hunnda na sagooniŋ ɗe ; ɓa neƴƴohha. ");
INSERT INTO sav_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓa maasoh ina findi wa raakoh jen, naandsukka ɓooɓa ina rahas ƴaara jiiniica ambee na mbaam ca. ");
INSERT INTO sav_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ŋ ineem ɓa kiimeeɗa Yeesu ne a pulaat kur caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wa Yeesu aasee ŋ gaala ne a coot, ƴaara a saɓsohee na jiiniica kiimmba ɗe ne : « On ndo ŋ kaɗ na ɗa. » ");
INSERT INTO sav_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Waaye Yeesu teyɗukiɗɗi ɗe, woosa ɗe ne : « Kaɗa kahan ɗu, fu ree ɗah, fu naandsuk ɓa ini Heɗi haɓɗiɗ ɗa ŋ miski fu misik ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ƴaara kaɗta, a naandsukeeɗa ina Yeesu haɓɗiɗ ɗe ŋ kur caŋ Dekapool ; ɓooɓa jen feyuusa ŋ ineem. ");
INSERT INTO sav_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wa Yeesu kooɗ gaal po a dokkissa ŋ ɓakaŋ winooraŋ cookma, a reyee ree, a tufukka ŋ sereendaŋ cookma. Mboolo yakak cohissa ŋ ɗiska na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ƴaar teeku Jayrus, ɓaah ŋ kilifaaca adgohee sinaagoga, reyeeɗa. Wi a hot Yeesu, a ƴekka ŋ kot ciŋ yeem, ");
INSERT INTO sav_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a kiimeeɗa ɗe kiim miskiɗ an : « Kuɓkiŋ ngo cafƴi yaa kaaneeɗa, haya hay rek fu degiɗ to ɗe yaah ciŋ ɗa, a wir, a min pes. » ");
INSERT INTO sav_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɓa hunnda, ɓa kaɗeeɗa. Mboolo yakiɗ ñaakiɗta Yeesu, ɓa baɓkeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ŋ ɗooƴ mboolnda, ɓitiɓ nikeen nga, ñif miŋ ɗe meeɗ meeɗ aamuk. A tumiɗ na kosaay keem kiis ndaŋkiyaah na kiis kanak (12). ");
INSERT INTO sav_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A yaaɓeen lool ŋ yaah paƴoh laayiɗ ; ina a raakee jen a tumeena nga ɓa, waaye a ngisoheeɗi ; a uupeeɗa nga uup kosaay. ");
INSERT INTO sav_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","In ca a kerhee ɓooɓi woyeeɗa ca ŋ Yeesu tahha po a huussa ŋ mboolnda, a lahha ɗe finho ; a laalla kulɓaakaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Raak a woyee ŋ ɗooƴ ce ne : « Ali ŋ laal kulɓaakiŋ ɗe dong, ŋ hey wire. » ");
INSERT INTO sav_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wa a laal kulɓaakaŋ Yeesu, ŋ saasi saasi ñif maŋ ɗe aamkisɗi, a yegga ŋ ɗooƴ ce ne a wiriɗ. ");
INSERT INTO sav_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeesu nammba jaar yeg ŋ ɗooƴ ce ne raakiɗ hatili puloh nga ɗe. A mbiliirukka ŋ ɗooƴ mboolnda, a woosa ne : « Ya ɓa laal kulɓaakiŋ ngo ? » ");
INSERT INTO sav_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taalubeeciŋ ɗe woosa ɗe ne : « Moo fu hot ŋ ɓooɓi, ɓa wil ɗa wil, fu meeksohee ɓoyi laal ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yeesu markeeɗa ŋ ini wil ɗe, ne a hot ɓoyi tum ineem. ");
INSERT INTO sav_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɓitɓa inahha ina rahas ɗe, a tiitta po a saakɗoheeɗa, a ƴekka ŋ kot ciŋ Yeesu, a woosa ɗe keeh ka jen. ");
INSERT INTO sav_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeesu woosa ɗe ne : « Kosi fu kos wirɗiɗ ɗa ɓitɓi, kaɗa moɗoɗ, fu saɓsukohiɗ na miskiɗiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wa a woyee ineem, ɓi ɓo' pulohha kahan Jayrus, ɓa woosa yeem ne : « Wa etohisɗi fu yaaɓɗe Jangɗohohi, kuɓkiŋ ɗa kaaniɗ. » ");
INSERT INTO sav_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Waaye Yeesu taambkohɗi woo kaŋ ɓa, a woosa Jayrus ne : « Kina neƴƴoh, kosa rek ! » ");
INSERT INTO sav_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeesu faɗɗi ali ɓo' ne a hun na ɗe ɗal Piyeer, Saak na Saaŋ yi taambɗoh Saak. ");
INSERT INTO sav_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wa ɓa ree kahan Jayrus, Yeesu hotta ne ɗuuɗaŋ ɓooɓa na aastiɗohaŋ ɓa miskiɗ lool ; ɓa rooyeeɗa, ɓa looƴkeeɗa. ");
INSERT INTO sav_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A aassa, a woosa ɓa ne : « Wa ye ɓek miskiɗuk cii na rooy cii ? Kuɓki kaanɗi, a na neehe. » ");
INSERT INTO sav_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓa njembteeɗa ɗe. Weɗ a pulɗoh ɓa jen, a hunnda na baab ɓi kuɓki na yaay ɓa na taalubeeci kaahay ci hunee na ɗe, a aassa na ɓa ŋ tuuƴa kuɓka nikoh. ");
INSERT INTO sav_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A ammba ɗe ŋ yaah, a woosa ɗe ne : « Talita kumi ! » Wa tokis : \"Kuɓki cafƴi, ŋ woo na ɗa, kurka !\" ");
INSERT INTO sav_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Njaanja jaarra kuruk, tiindeeɗa, ɓa feyuusa ŋ ineem lool. A raakeen kiis ndaŋkiyaah na kiis kanak (12). ");
INSERT INTO sav_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeesu dennga ɓa keeh-keeh ne ali ɓo' kinaata kerah. A woosa ɓa ne ɓa onaat kuɓka a ñam. ");
INSERT INTO sav_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wa Yeesu kurkoh ndaam, a kaɗta kur ka a yakoh, taalubeeciŋ ɗe hunnda na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ŋ mbehi na iɗsiɗkohse, a jangɗoheeɗa ŋ sinaagoga. Ɓooɓa laayiɗ ca sikɗukee ɗe feyuusa, ɓa woyeeɗa ne : « Ini ƴaarii inah wii a ɓayoha nde ? A eɗu ki'inah ye wii ? Na keemaan ci a na haɓɗe ? ");
INSERT INTO sav_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A miniseeni, yi kuɓkiŋ Maryaama haa e ? A taambɗoh Saak na Yoose na Yuud na Simong haa e ? Taambɗoh ciŋ ɗe ɓitiɓ ci nikɗi na ɓoo ndii e ? » Ineem weɗ tahee po ɓa minɗi ɗe teyɗuk. ");
INSERT INTO sav_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Waaye Yeesu woosa ɓa ne : « Woosuuɗ na kerhiɗasse ŋ ɗisik ci jen po tas kur ka a genoh, na ɗooƴ ɓaah ciŋ ɗe na kahan ɓa. » ");
INSERT INTO sav_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ineem tahha po Yeesu minɗi haɓiɗ keemaan nga, nikɗi dega a degee ɓi kosaayiɗ yaah ciŋ ɗe, a wirɗeeɗa ɓa ɗah. ");
INSERT INTO sav_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A feyuusa ŋ kosaaɗiikaŋ ɓa. Wa Yeesu kurkoh ndaam, a wileeɗa, a jangɗoheeɗa ŋ kur ca nikee ŋ ɓak caam. ");
INSERT INTO sav_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A ɓeeɗukka Apootar ci ndaŋkiyaah na kanak ci (12), a tuuƴeeɗa ɓa kanak kanak ; a onnda ɓa hatil aañoha jiini. ");
INSERT INTO sav_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A nakka ɓa ne : « Ɗu kaɗee ɗah, kinaat ɓayndoh ali in, ɗal ndooɗ ŋ yaah. Kinaat ɓay kañam, kinaat ɓay saak te kinaat ɓay kopor. ");
INSERT INTO sav_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓekkaat ñafaɗ, waaye kinaat ɓekuk kulɓa kanak. » ");
INSERT INTO sav_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A woyissa ɓa ne : « Kahan nu ɗu daloh ɗah, nikaat nga po mbaɗna ɗu pulan kur ka. ");
INSERT INTO sav_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Waaye ɗu teyɗukuuɗi ŋ ɗisik, ɓa sikɗukɗi ɗu ɗah, paangaat merhey miŋ kot ciŋ ɗu ne ɗu cootee ɗah, wa teeɓ ɓa ini ɓa haɓiɗ. » ");
INSERT INTO sav_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Apootar ci kaɗta, ɓa woyeeɗa ɓooɓa ne ɓa ɓoƴsohaat pesohaaɗ. ");
INSERT INTO sav_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓa aañeeɗa jiini laayiɗ, ɓa reefeeɗa diw ŋ haf jiriɗ gooñ, ɓa wirɗeeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","In ceem kaɗoh kaɗoh po Herod buura kerahha ca, raak tiikiŋ Yeesu wiliɗ kur. Ɓooɓa woyee ne : « Ƴaareem, a Yahya Ɓoktohi ; a hultiɗu hultiɗu, weɗ tah a raakka hatil haɓɗoha in feyohiɗ ! » ");
INSERT INTO sav_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɓum an : « A Ilyas. » Ɓinooɓi woyeeɗa ne : « A woosuuɗ, findi woosuuɗ ca ɗeɓgaan. » ");
INSERT INTO sav_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod kerah ineem, a woosa ne : « Ƴaareem, a Yahya Ɓoktohi, yi ŋ nguɗɗukee hafiŋ ɗe. A hultiɗu hultiɗu. » ");
INSERT INTO sav_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","A Herod yeem, a yi taƴɗukee Yahya sagu inii : A yi Herod, a kooɗee Herojaad, ɓiti taambɗoh ce Filip, a tummba ɗe ɓitiɓ. Yahya woyee na ɗe ŋ ineem an : « Waasiŋ Kooh teyɗohɗi ne fu ɓay ɓiti taambɗoh fu, fu tum ɗe ɓitiɓ. » ");
INSERT INTO sav_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herojaad ambiɗta Yahya aay-keeñ ŋ ineem, a waaɗta ɗe apɗuk, waaye Herod neƴƴohee neƴƴoh Yahya te a inheen ne a ɓo' yurhiɗ, hooliɗ wuu Kooh. Tahha po a meeɗ ɗe meeɗ niiɗ po Herojaad mineeɗi ɗe apɗuk. Ɓaat nga, Yahya woyeesa ɗah, a yi Herod, a meeɗ meeɗ feyu lool ; hondohɗi a meeɗeen neɓu ŋ sikɗuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kaɗeeɗa po mbeh, Herojaad raakka tondkoha ; wa nikee wa Herod yakɗee mbehi a raakohu. A yi Herod a haɓɗiɗukka kañam laayiɗ, a ɓeeɗukka dag caŋ ɗe na kilifaacaŋ soldaar ca na kilifaacaŋ Galile. ");
INSERT INTO sav_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mbaɗi, kuɓkiŋ Herojaad ɓitɓi aassa ŋ ɗiska ɓa nikee, a mbeceeɗa, a neɓpa Herod na hanheecaŋ ɗe. Herod woosa kuɓka cafƴa ne : « Woo so ini fu waaɗ, ŋ hey ɗa wa one. » ");
INSERT INTO sav_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A giñiɗta ɗe ineem, a woosa ɗe ne : « In nu fu meekis so ɗah, ŋ hey ɗa wa eɗe ; ali wa nik haaƴiŋ nguuriŋ ngo sah, ŋ eɗ ɗa wa. » ");
INSERT INTO sav_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kuɓka cafƴa pulla, woosa yaay ɓa ne : « Ŋ meeksan ɗe ye ? » Yaay ɓa loffa ɗe ne : « Meeksaa ɗe hafiŋ Yahya Ɓoktohi. » ");
INSERT INTO sav_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kuɓka cafƴa arra dokuk ŋ buura, a woosa ɗe ne : « Ŋ waaɗ ne fu eɗ to win-win, ŋ palaat, hafiŋ Yahya Ɓoktohi. » ");
INSERT INTO sav_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod soossa waaye giña a giñee ŋ fiki hanheeca tahha po a minɗi ɗe wa sangiɗ. ");
INSERT INTO sav_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A jaarra woos soldaar, a nakka ɗe komu hafiŋ Yahya. Soldaara kaɗta, nguɗta hafiŋ Yahya ŋ ɗiska a nikee ŋ kasoona, ");
INSERT INTO sav_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a hayya naa ŋ palaat, a eɗta kuɓka cafƴa wa, yeem eɗtaa yaay ɓa. ");
INSERT INTO sav_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wa taalubeecaŋ Yahya kerah ineem, ɓa kaɗta, ɓa ɓayya fiɗaafaŋ ɗe, ɓa ɓekkaa ŋ ruy-ruy. ");
INSERT INTO sav_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ini kaɗ ŋ Apootar ca Yeesu tuuƴee, wa ɓa dokuk, ɓa cohha ŋ ɗiska na ɗe, ɓa naandsukka ɗe in ca ɓa haɓiɗ na in ca ɓa jangɗoh jen. ");
INSERT INTO sav_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A woosa ɓa ne : « Hayaat ɓoo ɗaaya ŋ ɗisik eendiɗ, ɗu iɗsiɗuk ƴissuut. » Raak ɓa ɓo' laayiɗ ɓeɗ nikee nga, ɓum kaɗeesa ɗah, ɓum haye ; tahha po Yeesu na taalubeeciŋ ɗe rahasɗi ne ɓa ñam. ");
INSERT INTO sav_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓa ɓayya gaal ne ɓa ɗaaya ŋ ɗisik eendiɗ. ");
INSERT INTO sav_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Waaye ɓo' laayiɗ hotta ɓa kaɗeeɗa, inhissa ɓa ; ɓi kur caam jen nuppa, adugka ɓa ŋ ɗiska ɓa kaɗe. ");
INSERT INTO sav_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wa Yeesu na taalubeeciŋ ɗe ree po a ruhussa ŋ gaala, a hotta mboolo yakak, ɓa misikka ɗe lool ; ɓa mandee na mbaal raakaaɗi niiɗoh. A jangɗeeɗa ɓa in laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wa niina ree, taalubeeciŋ ɗe reɓpa nga ɗe, ɓa woosa ɗe ne : « Ndii wa bilaf, te Kooh yii hooɓeeɗa, ");
INSERT INTO sav_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","woya ɓooɓii ɓa kaɗ ŋ kur ci reɓ ndii ne ɓa rom ini ɓa joy ñam. » ");
INSERT INTO sav_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A loffa ɓa ne : « Ɗu, eɗaat ɓa ini ɓaa hee ñame. » Waaye ɓa woosa ɗe ne : « Ɓoo na hee ɓa kee romɗa mbuuru na hanjar dinaar teemet-kanak (200) hanaa ? » ");
INSERT INTO sav_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A woosa ɓa ne : « Ɗu raak mbuuru hend na ? Kaɗaat ɗu marka. » Ɓa marakka, ɓa loffa ɗe ne : « Ɓoo raak mbuuru yatuus na cuurund kanak. » ");
INSERT INTO sav_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A nakka ɓa ne ɓa ɓoofɗaat ɓooɓa jen rung rung ŋ paangfa iirnda. ");
INSERT INTO sav_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓa ɓooffa teemet teemet (100-100) na ndaŋkiyaah-yatuus ndaŋkiyaah-yatuus (50-50). ");
INSERT INTO sav_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A ɓayya mbuuruuca yatuus ca na cuurund ca kanak ca, a marakka ŋ ɗafki, a corkiɗta Kooh. A nguɗsohha mbuuruuca, a eɗta taalubeeci ca ne ɓa paysoh ca mboolnda, a nammba tum cuurund ca ɗaa po ɓooɓa jen raakka. ");
INSERT INTO sav_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓooɓa jen ñammba po ɓa kappa. ");
INSERT INTO sav_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wa ɓooɓa ñam po ɓa ƴutta, taalubeeca nangɗohha tasɗohiica po ɓa raakka ini mit pañe riifiɗ ndaŋkiyaah na kanak (12). ");
INSERT INTO sav_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ƴaar ca ñamee ŋ ɗiska nikeen ŋ ɓak junni-yatuus (5000). ");
INSERT INTO sav_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wa ɓa nangɗoh tasɗohiica po ƴutta, Yeesu jaarra, tufukka taalubeeciŋ ɗe ne ɓa aasaat ŋ gaala, ɓa adgohaah ɗe ŋ ɓakaŋ winooraŋ cookma, ŋ ɓak Betsayda ; a saɓsukoheeɗa na mboolnda. ");
INSERT INTO sav_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wa a askoh na mboolnda po ƴutta, a kaɗta tango ne a kiima Kooh. ");
INSERT INTO sav_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wa weka ree, raak gaalaŋ taalubeeca ŋ leero cookma, Yeesu tassa kiik ce ŋ merhey ma suyɗa. ");
INSERT INTO sav_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A hotta ne taalubeeca yaaɓiɗ ŋ joowaŋ ɓa na gaala, sagu puuɗsa yurhiɗkohee na ɓa. Ŋ wiisaaɗiina, a tiindeeɗa ŋ ɗafuk masma, a kaɗeeɗa nga ɓa po a heeɗa ɓa cootke. ");
INSERT INTO sav_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ɓa jen, ɓa hotta ɗe tiindeeɗa ŋ ɗafuk cookma, ɓa liiɓpa ne a husiɗ, ɓa feyuusa keeh-keeh, ɓa leehkeeɗa. Jaarra, a jommba na ɓa, a woosa ɓa ne : « Hunaat na sagoociŋ ɗu ! A ñam ! Kinaat neƴƴoh ! » ");
INSERT INTO sav_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A kaɗta nga ɓa ŋ gaala, puuɗsa seemmba. Ŋ ineem, ɓa nikka feyuuɗ jameet ŋ ɗooƴ ɓa po ɓa inhisɗi in ci ɓa haɓɗan ; ");
INSERT INTO sav_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","raak ɓa ambɗi ali in ŋ ina a haɓɗee na mbuuruuca. E ndengaŋ ɓa keeñ tahe. ");
INSERT INTO sav_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wa ɓa reehiɗ ƴakaanduk cookma, ɓa teerra ŋ kur kaŋ Senesaret. ");
INSERT INTO sav_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɓa yipuk yipuk rek, ɓooɓa inhissa Yeesu, ");
INSERT INTO sav_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ɓa nupeeɗa, ɓa aaseeɗa ŋ kur caŋ ɓak caam jen. Ŋ ɗisik nu ɓa kerahha ne a yaa nga ɗah, ɓa komee ɗe kosaayiɗ ca nga, faanuuɗ ŋ faankoha. ");
INSERT INTO sav_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wa kur ca yakak ca haa, wa ca ƴin ca haa, te wa pariɗ ca haa ; ɗisik nu ɗisik ŋ toonohaaca ŋ kur ca, ɓa ɓayeeɗa kosaayiɗ ca nga. A reesa ndeem ɗah, ɓa kiimee ɗe ne ɓa laal lecmiŋ kulɓaakiŋ ɗe dong, te ɓooɓa laalee ɗe jen wireen. ");
INSERT INTO sav_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wa raakka mbeh, Farisen ca cohha ŋ ɗiska na Yeesu na ɓi ɓo' ɓaah ŋ jangɗohoh caŋ waasiŋMusaa puloh Yerusalem. ");
INSERT INTO sav_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓa hotta ɓi taalube ŋ ɓiŋ Yeesu ñameeɗa na yaah hoolaaɗi, weɗ ne ɓa ɓokteeɗi ca na masuɓ wa ɓa hee ñame. ");
INSERT INTO sav_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Te Farisen ci na Yawuut ci jen sah na ñameeɗi muk feeh ɓa ɓohñukohɗi yaah masuɓ, findi mbaahiŋ yakak ci waaɗoha. ");
INSERT INTO sav_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ali ɓa puloh ɗiska na toonohse sah, feeh ɓa farsukɗi ɗah, ɓa na ñameeɗi. Ɓa na name taambiɗ in laayiɗ ŋ mbaah ci ɓa lam, mand na findi ɓa na ɓohñohe kaas, na meeme, soƴe, na bool. ");
INSERT INTO sav_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tahha po ɓa meekissa Yeesu ne : « Wa ye tah taalubeeciŋ ɗa na taambɗeeɗi mbaahiŋ caac ciŋ ɓoo, ɓa ñamee na yaah hoolaaɗi ? » ");
INSERT INTO sav_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A loffa ɓa ne : « Naafeehaaci ! Woo kiŋ Kooh wi woosuuɗi Esayi woyee nga ɗu, wa keeh, findi wa fiisohu, ne : “ Cuuɓii, eɗiŋ ɓa na so cir top ŋ nguɓ ciŋ ɓa ; keeñ ciŋ ɓa usiɗ to lool. ");
INSERT INTO sav_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñaamkiŋ ɓa na so ɓarang ɓarang. Ɓa na jangɗohe in ci ɓo' nakoh po mand haa ne mi yi Kooh, ñam woo ca. ” » ");
INSERT INTO sav_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeesu woyissa ne : « Ɗu na faɗe nakohiŋ Kooh, ɗu taambɗee mbaah ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A taalndiɗta a woyissa ne : « Ee, ɗu faɗ nakohiŋ Kooh moɗoɗ daal, ne ɗu taambiɗ mbaahiŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ŋ hot Musaa woyiɗ ne : “ Eɗa yaay ɗu na baab ɗu cir. ” A woyissiɗ ne “ Ɓo' nu kiimiɗ yaay ɓa wala baab ɓa moɗaaɗi ɗah, a apaah apu. ” ");
INSERT INTO sav_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Waaye ɗu, ɗu na jangɗohe ne, ɓo' woo yaay ɓa wala baab ɓa ne : “ Ini ŋ joyee ɗa eɗ, wa korban ” ɗah (weɗ ne wa wuu Kooh, ɓo' wiiriis minɗi wa njirñiɗkoh), ");
INSERT INTO sav_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","teemb ndeem, ɗu hondoh ɗe tumiɗ yaay ɓa wala baab ɓa ali in. ");
INSERT INTO sav_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɗu na heefohe woo kiŋ Kooh ɗaa, sagu taambiɗ mbaahiŋ ɗu ɗu na lamtiɗohe. Te sah, ɗu na name haɓiɗ in wiiriis laayiɗ mand ɗaa. » ");
INSERT INTO sav_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wa Yeesu ƴut ɓa lof, a ɓeeɗkissa mboolnda, a woosa ɓa ne : « Ɗu jen sikɗukaat to te ɗu inah inii : ");
INSERT INTO sav_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ali in ngaŋ in ci na aase ɓo' minɗi ɗe ɓek hoolaaɗi. Waaye a ini na pulohe ŋ ɓoyi, weɗ na hoolaaɗi'ɗee ɗe.  ");
INSERT INTO sav_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɓo' nu raak nof ɗah, kerhaat. » ");
INSERT INTO sav_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wa Yeesu kurkoh ŋ mboolnda, a aassa kahna. Taalubeeciŋ ɗe meekissa ɗe ŋ ini kaɗ ŋ woo keem. ");
INSERT INTO sav_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A loffa ɓa ne : « Ɗu sah, ɗu namɗi raak liiɓohaaɗ moɗiɗ e ? Ɗu inahɗi ne in ci nik ŋ hari te ca aasee ŋ ɓo' jen, ca minɗi ɗe ɓek hoolaaɗi e ? ");
INSERT INTO sav_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ca na aaseeɗi ŋ keeñiŋ ɗe, ca na kaɗe ŋ rookiŋ ɗe, ƴut ɗah ca bilafsuku. » Ŋ woo ceem, Yeesu hooliɗta kañam ci jen. ");
INSERT INTO sav_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A woyissa ne : « Ini na pulohe ŋ ɓo' weɗ na ɓekee ɗe hoolaaɗi. ");
INSERT INTO sav_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Laam in cii na pulohe ŋ ɗooƴ keeñ ɓo' : liiɓohaaɗ moɗaaɗi, faankoh sangohuuɗ, rok, ap ɓo', ");
INSERT INTO sav_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","njaaloo, waaɗ raak in laayiɗ, cakaay, njuucnjaac, nduuɗuk, siis, ɗooɓoh, hotsiɗuk na naandɗuk. ");
INSERT INTO sav_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","In ci moɗaaɗiiceem jen na pulohe ŋ ɗooƴ ɓo', ca ɓek ɗe hoolaaɗi. » ");
INSERT INTO sav_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wa Yeesu kurkoh ndaam, a kaɗ ɓak caŋ Tiir, a dalla ŋ kahan. A waaɗeeɗi ne ali ɓo' inaha, waaye wa mineeɗi ɗemb. ");
INSERT INTO sav_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wa raakeen ɓitiɓ nga, kuɓkaŋ ɗe ɓitɓa ƴina, a jiini nikee na ɗe. A kerahha ɓooɓa woyeeɗa ŋ ini kaɗ ŋ Yeesu, a jaarra hay nga ɗe, a ƴekka ŋ kot ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɓitɓeem nikeeɗi Yawuut, a nikee Gerek, a ɓaahee Feniis caŋ Siri ; a kiimmba Yeesu ne a aañiɗ ɗe jiinndi amb kuɓkiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeesu loffa ɗe ne : « Komaakci ñamaat paaɗ po ɓa kap ; wa waas haa ɓuu ci na koɗse teengu kañam kiŋ komaakci. » ");
INSERT INTO sav_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɓitɓa loffa ɗe ne : « Wa keeh kilifaani, waaye ɓuu ci na koɗse na name ñam ŋ ñamohiiciŋ komaakci, ci na keene. » ");
INSERT INTO sav_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu woosa ɗe ne : « Sagu woo keem, jiinnda faɗiɗ kuɓkiŋ ɗa, fu miniɗ haad. » ");
INSERT INTO sav_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ɓitɓa haadda, a raakka kuɓka faankiɗ moɗoɗ ŋ fiƴaanga, raak jiinnda faɗiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wa Yeesu kurkoh ɓakaŋ Tiir, a taamb ŋ Sidoon, ne a dokuk ɓakaŋ Cookmaŋ-Galile, ngaŋ kur caŋ Dekapool. ");
INSERT INTO sav_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A komuusa ɗik minaaɗi woo baahiɗ. A kiimuusa ne a degaat ɗika yaah, a wiriɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeesu ɓayya ɗe po ɓa ussa mboolnda, a degga ndukun ciŋ ɗe ŋ nof ciŋ ƴaara, a tuhussa, a laalla peɗmiŋ ƴaara. ");
INSERT INTO sav_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ƴutta, Yeesu marakka ŋ ɗafki, a iikka iik duu'in, a woosa ne : « Effata ! » Weɗ ne \"Rangsuka !\" ");
INSERT INTO sav_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jaarra nof ciŋ ƴaara rangsukka, peɗmiŋ ɗe toksukka, a jombeeɗa moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeesu dennga mboolnda ne ɓa kinaata woo ali ɓo'. Waaye findi a uupee ɓa dengoh ne ɓa kinaata woo, ɓa uupee wa laamtohoh ɗaa. ");
INSERT INTO sav_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓooɓa feyseen po ɓa minisɗi, ɓa woyeeɗa ne : « In nu a haɓiɗ ɗah, wa in baahiɗ. A tumiɗ po kotii, ɗik ci ɓii kerah, muum ci ɓii jomb. » ");
INSERT INTO sav_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ŋ mbeh caam, mboolo laayiɗ cohissa. Wa ɓa kaɗ po ɓa raakisɗi ñamaah, Yeesu ɓeeɗukka taalubeeciŋ ɗe, a woosa ɓa ne : ");
INSERT INTO sav_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","« Ɓooɓii miskiɗ to, neeh kaahay ceɗi cii, ɓii na so, te ɓa raakisɗi ali ñamaah ; ");
INSERT INTO sav_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ŋ woo ɓa ne ɓa haadaat rook ɓarang ɗah, ɓa keenan ŋ waas. Raakiɗ ɓi puloh ɗisik usiɗ. » ");
INSERT INTO sav_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taalubeeciŋ ɗe loffa ɗe ne : « Moo ! Ɓo' ɓayohan mbuuruuci min ɓa kap nde ŋ bilaf fii ? » ");
INSERT INTO sav_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A meekissa ɓa ne : « Ɗu raak mbuuru hend na ? » Ɓa loffa ɗe ne : « Mbuuru yasna-kanak. » ");
INSERT INTO sav_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ŋ ineem, Yeesu woosa mboolnda ne ɓa ɓoofaat ŋ kehƴa. A ɓayya mbuuruuca yasna-kanak ca, a corkiɗta Kooh, a nguɗsoheeɗa ca, a eɗeeɗa taalubeeciŋ ɗe ca ne ɓa paysoh ca ; ɓa paysohha ca ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓa nameen raak ɓi cuurund ƴin ndaam, a ɓayya ca, a corkiɗta Kooh nga ca, a woosa ne ɓa paysohaat ca mboolnda. ");
INSERT INTO sav_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓooɓa ñammba po ɓa kappa ; tasiɗ ca nangɗohuusa, ca nikee dammba yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓooɓa ñamee nikeen ŋ ɓak junni-nikiis (4000). Ƴutta, Yeesu woosa ɓa ne ɓa haadaat. ");
INSERT INTO sav_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jaarra a aassa ŋ gaal na taalubeeciŋ ɗe, ɓa kaɗta ɗiska na woyse Dalmanuta. ");
INSERT INTO sav_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wa ɓa ree ndaam, Farisen ca hayya, ɓa markiskeeɗa Yeesu an : Ɓa woosa ɗe ne a haɓɗaat firndeeni puloh ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeesu fuuppa sagu keeñ riifiɗ, a woosa ne : « Wa ye tah ɓooɓi woti meeksohee firnde ? Ñam na woyee ɗu wa te wa keeh, ɓa eɗsanɗi ali firnde. » ");
INSERT INTO sav_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A faɗta ɓa ndaam, a aasissa gaal ne ɓa coot ɓaka faahaŋ cookma. ");
INSERT INTO sav_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Taalubeeca alkoheen ɓayndoh mbuuru, ɓa raakee mbuuru yino dong ŋ gaala. ");
INSERT INTO sav_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeesu dennga ɓa an : « Tumaat moɗoɗ, wortukaat lawiiriŋ Farisen ci na wiŋ Herod. » ");
INSERT INTO sav_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalubeeca woyeeɗa ŋ harmban ɓa ne wa ina ɓa raakɗi mbuuru tah. ");
INSERT INTO sav_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A inahha ina ɓa woye, a woosa ɓa ne : « Wa ye tah ɗu woye ne : “ A ini ɓoo raakɗi mbuuru ? ” Ɗu inhisohɗi te ɗu inahɗi poyi e ? Ɗu raak keeñ ndengiɗ e ? ");
INSERT INTO sav_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɗu raakiɗ has. Ɗu minɗi minɗi hot e ? Ɗu raakiɗ nof. Ɗu minɗi minɗi kerah e ? Hanaa ɗu alkoh alkoh ");
INSERT INTO sav_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","wa ŋ nguɗsoh mbuuruuca yatuus ca ŋ paysohha ca mboolnda raakee ƴaar junni-yatuus (5000) ? Tasɗohiica ɗu ɓayndohee nikee pañe riifiɗ hend na ? » Ɓa loffa ɗe ne : « Pañe ndaŋkiyaah na kanak (12). » ");
INSERT INTO sav_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A woyissa ɓa ne : « Moo wa ŋ nguɗsoh mbuuruuca yasna-kanak ca, ŋ paysohha ca ɓooɓa junni-nikiis (4000) ca nak ? Tasɗohiica ɗu ɓayndohee mbaɗi, ca nikee dammba riifiɗ hend na ? » Ɓa loffa ɗe ne : « Ca nikee dammba yasna-kanak. » ");
INSERT INTO sav_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A woosa ɓa ne : « Ɗu ris inhaaɗi poyi e ? » ");
INSERT INTO sav_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wa ɓa kaɗ po Betsayda, a komuusa fuuliɗ, a kiimuusa ne a laal ɗe. ");
INSERT INTO sav_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeesu ammba fuulɗa ŋ yaah, a ɓayya ɗe po ɓa pulla kur ka, a tuhussa ŋ has ciŋ ɗe, a degga ɗe yaah ciŋ ɗe, a woosa ɗe ne : « Fu yii hot in e ? » ");
INSERT INTO sav_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ƴaara marakka, a loffa ɗe ne : « Mi yii hot ɓi ɓo', ɓa mand ndo na kidig waaye ɓa na tiinde. » ");
INSERT INTO sav_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A degissa ɗe yaah ciŋ ɗe ŋ has, ƴaara markissa ; a wirra, a hoteeɗa hooliɗ. ");
INSERT INTO sav_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeesu woosa ɗe ne : « Haada kahan fu, kina taamb ŋ ɗooƴ kur ki. » ");
INSERT INTO sav_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wa Yeesu na taalubeeciŋ ɗe kurkohis ndaam, ɓa kaɗeeɗa ŋ ɓak kur ka na woyse Seesare-Filip, ŋ kur ca ƴin ƴin ca wilee wa. Ŋ waasa, a meekissa ɓa ne : « Ɓooɓi na woye ne ñam ɓa ? » ");
INSERT INTO sav_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓa loffa ɗe ne : « Raakiɗ ɓi na woye ne a fu Yahya Ɓoktohi, ɓum woyee ne a fu Ilyas, ɓinooɓi woyee ne fu woosuuɗ wiiriis. » ");
INSERT INTO sav_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A meeksissa ɓa ne : « Moo ɗu nak ? Ɗu na woye ne ñam ɓa ? » Piyeer loffa ɗe ne : « A fu Mucɗohi Gapohse. » ");
INSERT INTO sav_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeesu dennga ɓa baahiɗ ne ɓa kinaat woo ali ɓo' ŋ ini kaɗ nga. ");
INSERT INTO sav_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Weɗi a camboh ɓa teeɓ ne : « Kuɓkiŋ ɓoyi joyiɗ yaaɓ keeh-keeh ŋ yaah ciŋ yakak ci na kilifaaciŋ seeƴkiɗoh ciŋ waasiŋMusaa na jangɗohoh ciŋ wa, ɓa hey ɗe sange, a apu, te a hulit ŋ neeha kaahayɗoh. » ");
INSERT INTO sav_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A woyeeɗa woo ceem halang. Piyeer gukka ɗe, ngaseeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeesu yurhiɗkohha na taalubeeca, a marakka ɓa, a ngassa Piyeer an : « Kurka ndii, kaɗa ŋ finhooso, seytaaniini ! Liiɓohaaɗiŋ ɗa hunɗi na wiŋ Kooh, fu na liiɓe findi ɓo'. » ");
INSERT INTO sav_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Weɗi Yeesu ɓeeɗkoh mboolnda na taalubeeciŋ ɗe, a woosa ɓa ne : « Ɓo' nu waaɗ nik taalubeeniŋ ngo ɗah, a joyɗi liiɓ haf ce, a degkaat kurwaani aa hee daaƴohse, a ñaakiɗ to. ");
INSERT INTO sav_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Laam ɓo' nu waaɗ muciɗ kipes kiŋ ɗe ɗah, a hey wa ñake. Waaye ɓo' nu ñak kipes kiŋ ɗe saguuso na Yegɗohiŋ Muci ɗah, a heya mucɗe. ");
INSERT INTO sav_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɓo' raak adinaani jen na in ci nik nga te a ñak kipes kiŋ ɗe, ineem raakiɗ ɗe winde njiriñ ? ");
INSERT INTO sav_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ɓo' min romkoh kipes kiŋ ɗe na ye ? ");
INSERT INTO sav_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɓooɓi woti-woti, ɓa tumoh moɗaaɗi, ɓa topɗi ŋ Kooh po haa njaalo'oh ; ɓo' nu supuk hun na so na woo ciŋ ngo ŋ fikiiɓa ɗah, Kuɓkiŋ ɓoyi hey ɗe supke inah ne a hayee ŋ yaki Baabiŋ ɗe yak, a hun na malaakaaci hooliɗ ci ɗah. » ");
INSERT INTO sav_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeesu woyissa ɓa ne : « Ñam na woyee ɗu wa te wa keeh, ɓi ɓo' ɓii ŋ ndii, ɓa kaananɗi muk te ɓa hotɗi Nguuriŋ-Kooh hayiɗ na hatil. » ");
INSERT INTO sav_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wa degga neeh yasna-yino, Yeesu ɓayya Piyeer na Saak na Saaŋ, a kaɗta ɗaaya na ɓa ŋ ɗafuk tango njooliɗ ; ndaam a ɓoƴsukka ŋ fikiiɓa. ");
INSERT INTO sav_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kulɓaacaŋ ɗe melciɗeeɗa melciɗ sagu yaanow ; ali naawoh ŋ kehƴi minɗi yaanwiɗoh kulɓa ɗaa. ");
INSERT INTO sav_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Woosuuɗ kanak teeɓukka ɓa, ɓa nikee Ilyas na Musaa, ɓa woyeeɗa na ɗe. ");
INSERT INTO sav_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyeer woosa ɗe ne : « Jangɗohohi, wa baahiɗ ne ɓoo nik ndii. Ɓoo haɓɗaat ɗiip kaahay ; winoori nik wiŋ ɗa, winni nik wiŋ Musaa, wi tas nik wiŋ Ilyas. » ");
INSERT INTO sav_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyeer woyiɗ ineem laam a inhisseeɗi in ci a na woye sagu tiita ɓa tiite ; a yi na taalubeeci kanak ci. ");
INSERT INTO sav_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eel hayya muurra ɓa, hooso kerhukka ŋ eela an : « Yii, a yi Kuɓkiŋ ngo ŋ waaɗ keeh-keeh, sikɗukaat ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jaarra taalubeeca marakka ini wil ndaam jen, ɓa hotisɗi ali ɓo' na ɓa, ɗal Yeesu kiik ce. ");
INSERT INTO sav_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wa ɓa ruhsee tangoora, Yeesu dennga ɓa an : « Kinaat naandsuk ali ɓo' ini ɗu hot po mbaɗna Kuɓkiŋ ɓoyi hultan. » ");
INSERT INTO sav_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓa ammba woo keem te ɓa woyeeɗa ŋ harmban ɓa an : « A waaɗ ye woo ŋ hulit ? » ");
INSERT INTO sav_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɓa meekissa ɗe ne : « Wa ye tah jangɗohoh ciŋ waasiŋ Musaa woyee ne Ilyas joyiɗ hayis paaɗ ? » ");
INSERT INTO sav_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A loffa ɓa ne : « Ɓo' miniɗ woo ne e Ilyas joy hay paaɗ ne a doknoh in ci jen po ca yurah, waaye kinaat alkoh ne, Fiis ci Hooliɗ ci namiɗ woo, ŋ ini kaɗ ŋ Kuɓkiŋ ɓoyi, ne a joyiɗ yaaɓ laayiɗ te a sangu. ");
INSERT INTO sav_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Waaye mi na woyee ɗu ne Ilyas hayiɗ po ɓooɓi tumiɗ ɗe ini neɓ ɓa findi Fiis ci woyohee wa. » ");
INSERT INTO sav_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wa ɓa kaɗ po ɓa reyeeɗa ŋ taalubeeca ɓinooɓa, ɓa hotta mboolo yakak wiliɗ ɓa, jangɗohoh caŋ waasiŋ Musaa taastiɗoheeɗa na ɓa. ");
INSERT INTO sav_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mboolnda hotta Yeesu, ɓa feyuusa. Jaarra, ɓa yurahha nga ɗe na mbup, ɓa kañiɗta ɗe. ");
INSERT INTO sav_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A meekissa ɓa ne : « Ɗu na taastiɗohee ye na ɓa ? » ");
INSERT INTO sav_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ƴaar ŋ mboolnda woosa ɗe ne : « Jangɗohohi, ŋ komee ɗa kuɓkiŋ ngo ƴaari, a jiini muumiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɗisik nu a amboh ɗe ɗah, a na folee ɗe ŋ ndaam, nguɓiŋ ɗe soñe, a ɗoɓɗohee sis ciŋ ɗe, a jaaɗ. Ŋ kiimiɗ taalubeeciŋ ɗa ne ɓa aañ jiinndi, waaye ɓa minɗaa. » ");
INSERT INTO sav_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeesu woosa ɓa ne : « Ɗu ɓi ɓooɓi woti-woti e ɗu kosaaɗi ; ŋ nikan nik na ɗu, ŋ muñɗee ɗu po kiɗa ? Komaat to ɗe ndii ! » ");
INSERT INTO sav_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɓa kommba ɗe ɗe. Wa jiinnda hot Yeesu rek, a yoondiɗta kuɓka, yeem keennda, walañkeeɗa ŋ kehƴi, nguɓiŋ ɗe fuureeɗa. ");
INSERT INTO sav_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeesu meekissa baabiŋ ɗe ne : « Inii rahas ɗe kiɗa ? » Yeem loffa ɗe ne : « Ina a nikoh komaaki poyi. ");
INSERT INTO sav_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","In laayiɗ, jiinndi na hiiree ɗe ngaŋ keen ŋ yongkaah mbaa ŋ masuɓ ne a boom ɗe ; kon fu min in nga ɗah, ɓoo miskaat ɗa, fu ɓaatɗoh ɓoo. » ");
INSERT INTO sav_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeesu loffa ɗe ne : « Ŋ min in nga ɗah i ? Raakɗi ini minukɗi ngaŋ ɓoyi kos. » ");
INSERT INTO sav_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jaarra baab ɓi kuɓka woosa ŋ ɗafka ne : « Ŋ kosiɗ ! Ɓaatɗoh ho ŋ ini tas ŋ kosi ŋ kos ! » ");
INSERT INTO sav_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeesu hotta ne mboolo laayiɗ wa ɗii ar nangɗukoh, a ngassa jiinnda an : « Ñam woo ne, pula ŋ kuɓkii te kinaa ɗe aasis, fu yi jiinndi na ɗikɗohe, muumɗohe ! » ");
INSERT INTO sav_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jiinnda pulla kuɓka, a ambsohhaa na sesoh na yoondiɗ ɗe keeh-keeh. Kuɓka mannda na ɓoyi kaan, po laayiɗ woyeeɗa ne a kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Waaye Yeesu ammba ɗe ŋ yaah ne a kuruk ; a kurukka. ");
INSERT INTO sav_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wa Yeesu aas kahna, taalubeeciŋ ɗe ɗaayya na ɗe, ɓa meekissa ɗe ne : « Wa ye tah po ɓoo minɗi aañ jiinnda ? » ");
INSERT INTO sav_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A loffa ɓa ne : « Jiini mand na yeem, a kiim Kooh dong na tahee ɗe coot. » ");
INSERT INTO sav_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa ɓa puloh ndaam, ɓa lahha ŋ ɗooƴ Galile. Yeesu waaɗeeɗi ne wa inhu, ");
INSERT INTO sav_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","a nikee jangɗeeɗa taalubeeciŋ ɗe ne : « Kuɓkiŋ ɓoyi hey degse ŋ yaah ciŋ ɓooɓi, ɓa ap ɗe, a hulit ŋ neeha kaahayɗoh. » ");
INSERT INTO sav_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waaye taalubeeciŋ ɗe inheeɗi ini woo keem tokis te ɓa kaañeeɗi ɗe meekis. ");
INSERT INTO sav_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wa ɓa ree Kapernawum po ɓa nikka ŋ kahna, Yeesu meekissa taalubeeciŋ ɗe ne : « Ɗu taastiɗohee ye ŋ waas ? » ");
INSERT INTO sav_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɓa ɗekka teɗ ; raak ɓa taastiɗohee ya ɓa uup nik kilifaani nga ɓa. ");
INSERT INTO sav_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A ɓooffa, a ɓeeɗukka ndaŋkiyaah na kanak ci (12), a woosa ɓa ne : « Ɓo' nu waaɗ nik kilifa ɗah, a teyɗukaat mirndoh, te a teyɗuk nik surgaaniŋ ɓi tas jen. » ");
INSERT INTO sav_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A ɓayya komaaki a tufkiɗta ɗe ŋ leerooɓa, a morgiɗukka ɗe, a woosa ne : ");
INSERT INTO sav_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","« Ɓo' nu teyɗuk njaanjii saguuso ɗah, a teyɗuk ko. Ɓo' nu teyɗuk ko ɗah, fu teyɗuk ko haa, fu teyɗuk Yi woos so. » ");
INSERT INTO sav_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Saaŋ woosa ɗe ne : « Jangɗohohi, ɓoo hotiɗ ɓo' aañeeɗa jiiniici ŋ tiikiŋ ɗa te a ɓaahɗi nga ɓoo. Tahha po ɓoo woosa ɗe ne a kinaata tumis. » ");
INSERT INTO sav_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yeesu woosa ɗe ne : « Kinaat ɗe wa sangoh, laam ali ɓo' minɗi haɓiɗ in feyohiɗ ŋ tiikiŋ ngo po ƴut, jaar a woyee in moɗaaɗi nga so. ");
INSERT INTO sav_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɓo' nu sangɗi ɓoo ɗah, a hun na ɓoo. ");
INSERT INTO sav_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ɓo' nu on ɗu pot masuɓ ne ɗu an sagu ɓaahi ɗu ɓaah ŋ Mucɗohi Gapohse ɗah, ñam na woyee ɗu wa te wa keeh, ɓoyeem ñakanɗi aafu nga. ");
INSERT INTO sav_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Waaye yaa nu bakaaɗɗukoh yino ŋ komaakci ƴin ci kos so ɓii ɗah, ini hee ngisohe nga ɗe, weɗ ne a toku atoh ɓitiɗ ŋ mbooh, a njafu ŋ cookma. ");
INSERT INTO sav_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yaahiŋ ɗa waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nguɗaa, fu tas yaah yino ; laam fu aas ŋ kipes ki na yaah yino, weɗ ngisoh fu kaɗ na yaah ciŋ ɗa kanak ci ŋ yongkaaha heyɗi ƴime.  ");
INSERT INTO sav_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kotiŋ ɗa waaɗ ɗa ɓek ŋ bakaaɗ ɗah, nguɗaa ; laam fu aas ŋ kipes ki na kot yino, weɗ ngisoh fu njafu na kot ciŋ ɗa kanak ci ŋ yongkaaha yakka.  ");
INSERT INTO sav_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te hasiŋ ɗa waaɗ ɗa ɓek ŋ bakaaɗ ɗah, luhtaa ; laam fu aas ŋ Nguuriŋ-Kooh na has yino, weɗ ngisoh fu njafu na has ciŋ ɗa kanak ci ŋ yongkaaha yakka. ");
INSERT INTO sav_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cangind ca na ñame faan ndaam na kaaneeɗi te yongkaaha na ƴimeeɗi. ");
INSERT INTO sav_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ɓo' nu nga ɗah, hey jemɗasse na yongkaah. ");
INSERT INTO sav_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Meɗa, wa in baahiɗ, waaye meɗa kaɗ po wa jemisɗi ɗah, wa min jemɗohissu na ye ? Raakaat meɗa ŋ ɗooƴ ɗu te ɗu pesohee jam ŋ harmban ɗu. » ");
INSERT INTO sav_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeesu kurkohha ndaam, a kaɗta ɓakaŋ kur caŋ Yudee, na ɓaka winooraŋ Yurdan. Mboolo cohissa nga ɗe, a jangɗisseeɗa ɓa findi a meeɗa tumoh. ");
INSERT INTO sav_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɓi ɓo' ɓaah ŋ Farisen ca reɓpa, ɓa meekseeɗa ɗe ne ɓa woyɗukoh ɗe woo uupiɗ, an : « Andi ɓo' miniɗ faɗ ɓitiice ? » ");
INSERT INTO sav_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A loffa ɓa ne : « Musaa eɗ ɗu winde nakoh nga ? » ");
INSERT INTO sav_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓa loffa ɗe ne : « A teyɗohiɗ ne, fu miniɗ fiisiɗ ɓitiifu kayti teeɓoh ne fu faɗiɗ ɗe, fu faɗ ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A loffa ɓa ne : « E ndengi ɗu ndeng keeñ weɗ tah Musaa fiisiɗta ɗu nakoheem, ");
INSERT INTO sav_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","waaye ŋ cambohaana, wa Kooh na fere Adina, a fer ɓa ƴaar na ɓitiɓ, ");
INSERT INTO sav_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","weɗ tah ƴaar hey saɓsukohe na yaay na baab, a ŋoɗ ŋ ɓitiice, ");
INSERT INTO sav_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɓa nik faan yino. Teemb ndeem, ɓa nikisɗi kanak ɓa faan yino kotii. ");
INSERT INTO sav_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kon, ini Kooh ambsoh, ɓo' kinaata saɓsoh. » ");
INSERT INTO sav_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wa ɓa dokuk kahna, taalubeeciŋ ɗe meekissa ɗe ini kaɗ ŋ ineem. ");
INSERT INTO sav_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A loffa ɓa ne : « Yaa nu saɓsukoh na ɓitiice, a tokis ɓitiɓ wiiriis ɗah, a njaaloo njaaloo ŋ harmban ce na ɓitɓa koc. ");
INSERT INTO sav_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te ɓitiɓ nu saɓsukoh na ƴaar ce, a tey ƴaar wiiriis tok ɗe ɗah, a njaaloo njaaloo. » ");
INSERT INTO sav_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓi ɓo' komeeɗa Yeesu komaaki ƴin ne a laal ɓa, waaye taalubeeciŋ ɗe ngaskeeɗa ɓooɓeem. ");
INSERT INTO sav_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeesu hotta ineem, a ayrukka, a woosa ɓa ne : « Faɗaat komaakci ɓa hay nga so, kinaat ɓa hondoh hay, ɓooɓi mand na ɓa ɓeɗ raak Nguuriŋ-Kooh. ");
INSERT INTO sav_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ñam na woyee ɗu wa te wa keeh, ɓo' nu teyɗukɗi Nguuriŋ-Kooh findi komaaki ƴin ɗah, a aasanɗi nga muk. » ");
INSERT INTO sav_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ƴutta, a gorukka komaakca, a degga ɓa yaah ciŋ ɗe a barke'iɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wa Yeesu coote, ƴaar nuppa ƴekka ŋ fikiice, meekissa ɗe ne : « Jangɗohohi baahiɗi, ŋ joy ye haɓiɗ po ŋ raak kipes ki heyɗi reehe ? » ");
INSERT INTO sav_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeesu woosa ɗe ne : « Wa ye tah fu ɓeeɗkohee so baahiɗ ? Ali ɓo' baahɗi, hanaa Kooh dong. ");
INSERT INTO sav_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fu inhiɗ nakoh ci ; an kina ap ɓo', kina njaaloo, kina rok, kina woyiɗ ɓo' ini a tumɗi, kina njuucnjaac, eɗa yaay ɗu na baab ɗu cir. » ");
INSERT INTO sav_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ƴaara woosa ɗe ne : « Jangɗohohi, in ceem jen, mi yii taambiɗ ca, ina ŋ nikoh komaaki poyi. » ");
INSERT INTO sav_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeesu marakka ɗe, waaɗta ɗe ŋ ɗooƴ ce, a woosa ɗe ne : « Wa in yino dong weɗ fu taskoh. Toona in ci fu raak jen, fu eɗ ca ñakiɗ ci ; fu hey raake alal ŋ Eel ci. Ƴut ɗah, fu hay, fu ñaakiɗ to. » ");
INSERT INTO sav_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ŋ woo keem, fikiiraŋ ƴaara ɓoƴsukohha, a cooteeɗa goyoh na goyoh, a nikee heɗ raak-raak. ");
INSERT INTO sav_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋ ineem, Yeesu marakka ini wil ɗe, a woosa taalubeeciŋ ɗe ne : « Heɗ raak-raak aas ŋ Nguuriŋ-Kooh wa in ye miskan. » ");
INSERT INTO sav_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taalubeeciŋ ɗe feyuusa ŋ woo kiŋ ɗe, waaye a woyissa ɓa ne : « Kuɓuuci, aas ŋ Nguuriŋ-Kooh yooɓɗi de' ! ");
INSERT INTO sav_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngeelemb taamb ŋ ngul kufic, weɗ uup yooɓ heɗ raak-raak aas ŋ Nguuriŋ-Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Taalubeeca uuppa nga feyu, ɓa woyeeɗa ŋ harmban ɓa ne : « Kon a ya ɓa min mucɗu ? » ");
INSERT INTO sav_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu marakka ɓa, woosa ne : « Ineem wooñiɗ ɓo' waaye raakɗi ini wooñ Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ŋ ineem Piyeer kooɗta woo ka, a woosa ɗe ne : « Moo ɓoo ɓi faɗ in ciŋ ɓoo jen, ɓoo ñaakiɗta ɗa nak ? » ");
INSERT INTO sav_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeesu loffa ɗe ne : « Ñam na woyee ɗu wa te wa keeh, ɓo' nu faɗ kahan, wala taambɗoh ƴaar mbaa ɓitiɓ, yaay, baab, kuɓu wala yohon saguuso na Yegɗohiŋ Muci ɗah, ");
INSERT INTO sav_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɓoyeem hey raake, ŋ jamanoonii, ini ree waas teemet ŋ kahan, taambɗoh, yaay, baab, kuɓu, na yohon. Wa hunan na tolfiɗu ŋ kehƴi, waaye, kim a hey raake kipes ki heyɗi reehe. ");
INSERT INTO sav_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Laayiɗ ŋ ɓi adug woti, ɓeɗ mirndohan, te laayiɗ ŋ ɓi mirndoh woti, ɓeɗ adgan. » ");
INSERT INTO sav_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Waam, ɓa nikee ŋ waas Yerusalem, Yeesu adugka, ɓa kaɗeeɗa, taalubeeci feyuusa, ɓooɓa hunee na ɓa tiitta. Ŋ ineem a ɓeeɗkissa taalubeeci ndaŋkiyaah na kanak ci (12) kiik ɓa, a woyeeɗa ɓa ini na hee ɗe rahse. ");
INSERT INTO sav_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A woosa ɓa ne : « Ɗu hot nga, ɓoo ɓii kaɗ Yerusalem, Kuɓkiŋ ɓoyi hey faɗse ŋ yaah ciŋ kilifaaciŋ seeƴkiɗoh ciŋ waasiŋ Musaa, na jangɗohoh ciŋ wa ; ɓa hey ɗe atte'e ne a apu, ɓa eɗ ɗe ɓooɓi nikɗi Yawuut. ");
INSERT INTO sav_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓeem hey ɗe njembte, ɓa tuhus ɗe, ɓa laɓ ɗe leraw, ɓa ap ɗe. Waaye wa raak neeh kaahay ɗah, a hey hulte. » ");
INSERT INTO sav_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Saak na Saaŋ, kuɓuuciŋ Sebede, reɓpa ŋ Yeesu, ɓa woosa ɗe ne : « Jangɗohohi, ɓoo waaɗ ne fu haɓɗiɗ ɓoo ini ɓoo na hee ɗa kiime. » ");
INSERT INTO sav_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A woosa ɓa ne : « Ɗu waaɗ ne ŋ haɓɗiɗ ɗu ye ? » ");
INSERT INTO sav_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓa woosa ɗe ne : « Ɓoo waaɗ ne fu nik ŋ ndamiŋ ɗa ɗah, yii ɓoof lah ɗa yaah-ñaahum, yii lah ɗa yaah-sing. » ");
INSERT INTO sav_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Waaye a woosa ɓa ne : « Ɗu inahɗi ini ɗu na kiime. Ɗu miniɗ an ŋ kaasiŋ miskiɗi ŋ anan e ? Andi ɗu miniɗ ɓoktuk ŋ miskiɗi ŋ ɓoktukohan ? » ");
INSERT INTO sav_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓa loffa ɗe ne : « Ee, ɓoo miniɗa. » A woosa ɓa ne : « Wa keeh ne ɗu hey ane ŋ kaasiŋ miskiɗi ŋ anan te ɗu hey ɓoktuke ŋ miskiɗi ŋ ɓoktukohan ; ");
INSERT INTO sav_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","waaye ini kaɗ ŋ yi lahan ndo yaah-ñaahum na sing, a ñam woyan ɓa haa ; ɓooɓi kooɗkiɗu ɗisik ceem, ɓeɗ lahan ndo nga. » ");
INSERT INTO sav_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa taalubeeca ndaŋkiyaah ca ɓinooɓa kerah ineem, ɓa ayrukka Saak na Saaŋ. ");
INSERT INTO sav_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeesu ɓeeɗukka ɓa jen, woosa ɓa ne : « Ɗu inhiɗ ne ɓooɓi ambu kilifa yakak ŋ kur ci na degee deg ɓooɓiŋ ɓa yaah, ɓooɓi uupiɗ hatil uupohee doole. ");
INSERT INTO sav_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Waaye wa nikohɗi ɗaa nga ɗu, ɓo' nu waaɗ nik ɓo' yakak nga ɗu ɗah, a teyɗukaat nik surgaaniŋ ɗu. ");
INSERT INTO sav_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te ɓo' nu waaɗ adug nga ɗu ɗah, a teyɗukaat nik ñaamiŋ ɓi tas jen. ");
INSERT INTO sav_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kuɓkiŋ ɓoyi sah, hayɗi ne a raak surga, a hay ne a nik surga te a eɗoh kipes kiŋ ɗe ne a tos ɓo' laayiɗ. » ");
INSERT INTO sav_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yeesu na taalubeeciŋ ɗe woyeeɗa, kaɗeeɗa po ɓa reesa kur-taaha na woyse Yeriko. Ɓa puleeɗaa, ɓa hunnda na mboolo laayiɗ, raak fuuliɗ yalwaanoh teeku Bartime, kuɓu Time, ɓoofiɗ ŋ mbeeddaana. ");
INSERT INTO sav_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wi a kerah ne a Yeesu yi gen Nasareet na haye, a leehkeeɗa an : « Yeesu setiŋ Dawuuda, ŋ miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓo' laayiɗ ngaskeeɗa ɗe ne a ɗek. Waaye a uupeeɗa nga leehuk an : « Setiŋ Dawuuda, ŋ miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeesu tufukka, nakohha ɗe ɓeeɗkiɗu. Ɓi ɓo' kaɗta nga ɗe, woosa ɗe ne : « Ndengɗuka ! Kurka, a nakohiɗ ɗa ɓeeɗku. » ");
INSERT INTO sav_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jaarra fuulɗa njaffa paltoonaŋ ɗe, a gooñukka, a kaɗta ŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeesu meekissa ɗe ne : « Fu waaɗ ne ŋ haɓɗiɗ ɗa ye ? » A loffa ɗe ne : « Rabbuuni (jangɗohohiŋ ngo), ŋ waaɗ ne fu tum po has ciŋ ngo min hot ! » ");
INSERT INTO sav_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeesu woosa ɗe ne : « Kaɗa, kosi fu kos wirɗiɗ ɗa. » Jaarra fuulɗa hoteeɗa, a taambiɗta Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wa Yeesu na ɓa hunee na ɗe kaɗ po ɓa heeɗa ree Yerusalem, ŋ ɓak Betfase na Betani, ŋ sero Tangooraŋ-Oliiw-ca, a woossa kanak ŋ taalubeeciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A woosa ɓa ne : « Kaɗaat ŋ kur ki ŋ fikiiɗu wii, ɗu aasee rek ɗah, ɗu hey hote cumbur mbaam tokuuɗ nga, yi ɓo' moosɗi rapoh. Toksaat ɗe, ɗu kom mbo ɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɓo' meekis ɗu ne wa ye tah ɗu toksee ɗe ɗah, lofaat ne : “ A kilifaani etoh ɗe, ƴut ɗah, a hey ɗe dokne ŋ ndii. ” » ");
INSERT INTO sav_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Taalubeeca kaɗta, ɓa raakka cumbraŋ mbaama tokuuɗ ŋ hara, ŋ nguɓu kahan, ɓa tokissa ɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓi ɓo' ŋ ɓa nikee ŋ ndaam woosa ɓa ne : « Ɗu na haɓɗe ye an ? Wa ye tah ɗu toksee cumbriŋ mbaami ? » ");
INSERT INTO sav_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓa loffa ɓa findi Yeesu woyohe, ɓa faɗuusa. ");
INSERT INTO sav_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wa ɓa hay na cumbra, ɓa raɗta kulɓaacaŋ ɓa ŋ ɗafuk cumbra, Yeesu rappa nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓo' laayiɗ raɗɗeeɗa ɗe kulɓaacaŋ ɓa ŋ waasa, ɓum raɗeeɗa paangiica ɓa piikohee ŋ yohon ca. ");
INSERT INTO sav_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓa adgee na ɓa ñaakee nga ɗe woyeeɗa ŋ ɗafka woo kii : « Hosaana ! Ɓoyi na haye ŋ tiikiŋ Heɗi raakaat barke ! ");
INSERT INTO sav_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wa barke'aat, Nguuriŋ caac ɓoo Dawuuda wi na haye ! Hosaana ŋ ɗisik ca uup ɗafuk ! » ");
INSERT INTO sav_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Weɗ Yeesu kaɗoh po a reesa Yerusalem, a aassa ŋ Kahan Kooh. Wa a maraka jen po ƴutta, a kurukka, a hunnda na taalubeeci ndaŋkiyaah na kanak ci (12), ɓa kaɗta Betani, raak Kooh hooɓeeɗa. ");
INSERT INTO sav_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ŋ Kooh-wiisiina, a puleeɗa Betani, a aɗukka. ");
INSERT INTO sav_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A ƴokka ndun kifsiɗ, a kaɗta marka andi a hey raake ini a min ñam nga. Waaye wa a ree, a hotɗi ali in nga ɗal saaf ca. Wa nikeeɗi ŋ jamanooni ndun ci na rimohe. ");
INSERT INTO sav_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A woosa nduna ne : « Ali ɓo' ñamissanɗi rim ciŋ ɗa ! » Taalubeeciŋ ɗe kerheeɗa nga. ");
INSERT INTO sav_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wa ɓa ree Yerusalem, Yeesu aassa ŋ Kahnaŋ Kooh, a aañeeɗa toonoh ca na romoh ca nikee nga. A foleeɗa taaɓul caŋ ɓoƴsoh kopor ca na ɓoofohaacaŋ toonoh banuut ca. ");
INSERT INTO sav_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A faɗeeɗi ali ɓo' ne a taamb na bagaas ŋ ɗooƴ Kahnaŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A jangɗeeɗa ɓooɓa an : « A inii weɗ woyu ŋ Fiis ci Hooliɗ ci haa e ? Ne : “ Kahan ndo teeksan kahan kiimoha wuu cuuɓ ci jen. ” Waaye ɗu tumiɗa ɗembohaaniŋ rokoh ci. » ");
INSERT INTO sav_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ŋ ineem kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa na jangɗohoh caŋ wa kerahha Yeesu, ɓa waakeeɗa findi ɓa hee ɗe apohe. Ɓa neƴƴoheen ɗe sagu aasa jangɗohiŋ ɗe aasee mboolnda. ");
INSERT INTO sav_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wa niina ree, Yeesu na taalubeeciŋ ɗe pulla Yerusalem. ");
INSERT INTO sav_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ŋ Kooh-wiisiina na ɓaaɓa, ɓa dokkeeɗa po ɓa teembeeɗa ŋ nduna, ɓa hottaa suyiɗ po ŋ niir ca. ");
INSERT INTO sav_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyeer naandsukka ina raake, a woosa Yeesu ne : « Jangɗohohi, marka ! Nduni fu yonjee suyiɗ kong ! » ");
INSERT INTO sav_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A woosa ɓa ne : « Kosaat Kooh, ");
INSERT INTO sav_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ñam na woyee ɗu wa te wa keeh, ɓo' nu woo tangoorii ne : “ Kurka ndii, njafka ŋ cookma ” te a raakɗi liiɓ kanak nga, waaye a kos ne ini a woo hey raake ɗah, Kooh hey ɗe wa tumɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Weɗ tah mi na woyee ɗu ne, in nu ɗu kiimee Kooh ɗah, kosaat ne ɗu rahsiɗa po ƴutiɗ, Kooh hey ɗu wa tumɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Fu kiimee Kooh te raak, fu ambɗiɗ morom fu in ɗah, ɗaasa ɗe, Baabiŋ ɗu, yi ŋ Eel ci nam ɗa ɗaas.  ");
INSERT INTO sav_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26"," » ");
INSERT INTO sav_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wa Yeesu na taalubeeciŋ ɗe dokkis Yerusalem, a tiindsukeeɗa ŋ ɗooƴ Kahan Kooh, kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na jangɗohoh caŋ wa na yakak ca, hayya nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɓa woosa ɗe ne : « In ci fu na haɓɗe, fu gaƴuk nde po fu kaannja ca haɓiɗ, wala a ya ɓa tufkiɗ ɗa ne fu haɓiɗ ca ? » ");
INSERT INTO sav_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu loffa ɓa ne : « Maa hee ɗu meekse in yino dong, lofaat to, ŋ woo ɗu ini tufkiɗ to po ŋ haɓɗee in cii. » ");
INSERT INTO sav_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A woosa ɓa ne : « Ya ɓa tuuƴee Yahya ne a ɓoktoh, a Kooh wala ɓi ɓo' ? Lofaat to ! » ");
INSERT INTO sav_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Waaye ɓa woyeeɗa ŋ harmban ɓa ne : « Ɓoo woo ɗe ne Kooh a yi woos Yahya ɗah, a na hee woye ne : “ Wa ye tah ɗu kosɗi ɗe ? ” ");
INSERT INTO sav_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te ɓoo namɗi kaañ woo ne wa puloh ŋ ɓooɓi. » Ɓa neƴƴoheen ɓooɓa laam mboolnda jen ambeen ne, Yahya nikee woosuuɗ keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɓa loffa Yeesu ne : « Ɓoo inahɗi. » A woosa ɓa ne : « Kon ŋ namanɗi ɗu woo ini tufkiɗ to po ŋ haɓɗee in cii. » ");
INSERT INTO sav_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeesu woyeeɗa na kilifaacaŋ Yawuut ca ŋ andiin an : « A nikee ƴaar, a yippa yohon reseñ, a ɗinngaa po wa willa. A acca nung pooƴoha masmiŋ reseñi nga, a haɓiɗta paraang niiɗohaa wa. Ƴutta, a hanndaa deg ŋ yaah ɓi guuroh reseñ ne wa ruund ɗah ɓa paysoh ; a ɓaaɓpa. ");
INSERT INTO sav_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wi yohni ruund, a tuuƴca ñaam ŋ guuroh ci ne a rahas ɓakiŋ ɗe ŋ reseñi. ");
INSERT INTO sav_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Guuroh ca ammba ñaama, ɓa laɓpa ɗe, ɓa aannja ɗe yaah ɓarang. ");
INSERT INTO sav_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A tuuƴissa ñaam wiiriis nga ɓa, ɓa laɓpa ñaama ŋ haf, ɓa ɓassohha ɗe. ");
INSERT INTO sav_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A tuuƴissa ya kaahayɗoh, ɓa appa ɗe. Ɓa laɓpa ñaam laayiɗ ɓi fu inah ne a namee ɓa nam tuuƴ, ɓa appa ɓum. ");
INSERT INTO sav_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A tasɗee kuɓkiŋ ɗe a keeñkoh dong. Ŋ mirndaani, a woossa ɗe nga ɓa, a woosa ŋ haf ce ne : “ Ɓa hey supke kuɓkiŋ ngo. ” ");
INSERT INTO sav_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Waaye wi pangkoh ci hot ɗe, ɓa woosa ŋ harmban ɓa ne : “ Lamohiŋ yohni a yi ! Hayaat ɓoo ap ɗe, lamaahi nik wiŋ ɓoo kotii. ” ");
INSERT INTO sav_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓa ammba ɗe, ɓa appa ɗe, ɓa mbetta ɗe ŋ finho yohni. » ");
INSERT INTO sav_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeesu woosa ne : « Moo, ɗu liiɓ ne heɗ yohniŋ reseñi tuman na ? A hey haye, a ap guuroh ci, a deg yohni ŋ yaah ɓi ɓo' wiiriis. ");
INSERT INTO sav_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hanaa ɗu jangɗi ini Fiis ci Hooliɗ ci woo wii : “ Atoh fi taɓahoh ci mbete, mirndohiɗ nik atoh fi amb taɓahi. ");
INSERT INTO sav_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ineem puloh ŋ Heɗ ɓoo, wa in feyohiɗ ŋ has ciŋ ɓoo. ” » ");
INSERT INTO sav_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ŋ ineem, kilifaacaŋ Yawuut ca inheen ne Yeesu woyee na ɓa ŋ andiina, ɓa waakeeɗa findi ɓaa hee ɗe ambohe. Waaye ɓa neƴƴoheen mboolnda, tahha po ɓa faɗta ɗe, ɓa cootta. ");
INSERT INTO sav_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ŋ finho ineem, ɓa tuuƴca ɓi Farisen na ɓi ɓo' ɓaah ŋ langtoh caŋ Herod ne ɓa kaɗ ŋ Yeesu, ɓa woyɗukoh ɗe woo ki min ɗe ɓek. ");
INSERT INTO sav_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓeem hayya woosa ɗe ne : « Jangɗohohi, ɓoo inhiɗ ne fu woyoh keeh te fu nupɗi ali ɓo' ; laam, fu na markeeɗi ŋ yaki ɓoyi yak, waaye fu na jangɗohe waasiŋ Kooh ŋ keeh ; woya ɓoo andi wa waas ne Sesaar, buura yakkaŋ Rom, wirndasse lempo wala ? Ɓoo wirind, wala ɓoo wirnduu ? » ");
INSERT INTO sav_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Waaye Yeesu inahha ne woo ciŋ ɓa keeh nga ɓa haa, a woosa ɓa ne : « Wa ye tah ɗu waaɗee so ɓek ? Komaat to hanjar dinaar ndii ŋ marak. » ");
INSERT INTO sav_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓa eɗta ɗe hanjar yino, a meekissa ɓa ne : « Ya ɓa raak nataalii, na tiiki nik nga ? » Ɓa loffa ɗe ne : « A Sesaar. » ");
INSERT INTO sav_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A woosa ɓa ne : « Eɗaat Sesaar ini Sesaar raak, te ɗu eɗ Kooh ini Kooh raak. » Ɓa feyuusa keeh-keeh nga ɗe. ");
INSERT INTO sav_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ŋ ineem, ɓooɓi na woyse Sadusen hayya ŋ Yeesu. Ɓeɗ ɓi na woye ne kaaniɗ ci hultanɗi. Ɓa hayya ŋ Yeesu, ɓa woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","« Jangɗohohi, nakohii weɗ Musaa fiisiɗ ɓoo : “ Ƴaar kaan te a raakɗi kuɓu na ɓitiice ɗah, a taambɗoh ce joy tok ɓitɓi, a raakiɗ ƴaari kaanɗi kuɓu. ” ");
INSERT INTO sav_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waaye wa raakeen taambɗoh yasna-kanak. Saawi tokka ɓitiɓ, a faɗɗi kuɓu a kaannda. ");
INSERT INTO sav_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yi taamb nga ɗe lammba ɓitɓa, a nammba kaan raakaaɗi kuɓu, yi kaahayɗoh nammba tum ɗaa. ");
INSERT INTO sav_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɓa kaɗeeɗa po yasna-kanak ci jen kaannda te ali ɓo' raakɗi kuɓu nga ɓa ; ƴutta, ɓitɓa nammba kaan. ");
INSERT INTO sav_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɓooɓi hulit ɗah, a nikan ɓiti ya ɓa nga ɓa ? Laam, ɓeɗ ɓi yasna-kanak ci jen ɓa tokiɗ ɗe findi ɓitiɓ ! » ");
INSERT INTO sav_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu loffa ɓa ne : « Ini muuƴiɗ ɗu, weɗ ne, ɗu inahɗi ini Fiis ci woo, ɗu inahɗi hatiliŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɓooɓi hulit ɗah, ƴaar ci heyɗi toke ɓitiɓ, ɓitiɓ ci heyɗi tokse, ɓa mandan na malaakaaciŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ŋ ini kaɗ ŋ kakaan ki na hultiŋ ɓooɓi, andi ɗu jangɗi ŋ teerndiŋ Musaa, ŋ ɗiski na woye ŋ kidga ƴina jaale ? Ŋ ndeem, Kooh woo ɗe ne : “ Ñam Koohiŋ Ibrahiima, Isaahha, na Yaŋhooɓa. ” ");
INSERT INTO sav_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kooh, a Koohiŋ kaaniɗ ci haa, a Koohiŋ pesiɗ ci. Muuƴi ɗu muuƴ yakiɗ. » ");
INSERT INTO sav_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ƴaar ɓaah ŋ jangɗohoh caŋ waasiŋ Musaa kerahha woo caŋ ɓa. A hotta ne, findi Yeesu lofoh ƴaaɓa, wa ɗaa. A reɓpa, a meekissa ɗe ne : « A winde nakoh uupiɗ etoh ŋ nakoh ci jen ? » ");
INSERT INTO sav_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeesu loffa ɗe ne : « Wii weɗ nakohi uupiɗ etoh : “ Sikɗuka Israayel, Kooh Heɗ ɓoo a yi dong Heɗi ! ");
INSERT INTO sav_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Waaɗa Heɗ ɓoo, yi Koohiŋ ɗa, na keeñiŋ ɗa jen, na ruuhiŋ ɗa jen, na liiɓiŋ ɗa jen, na hatiliŋ ɗa jen. ” ");
INSERT INTO sav_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wii taammba nga : “ Waaɗa morom fu findi fu waaɗoh haf fu. ” Raakɗi nakohi uup nakoh cii. » ");
INSERT INTO sav_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ƴaara woosa ɗe ne : « Ee Jangɗohohi, fu woo keeh ne a Kooh yino dong raak, wiiriis raakɗi ɗal a yi ; ");
INSERT INTO sav_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","te fu waaɗ ɗe na keeñiŋ ɗa jen, na liiɓiŋ ɗa jen, na hatiliŋ ɗa jen, fu nam waaɗ morom fu findi fu waaɗoh haf fu ɗah, weɗ uupiɗ njiriñ fu hoomɗiɗ Kooh ɗoopaat, wala seeƴuk nu min nik ɗah. » ");
INSERT INTO sav_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jaarra Yeesu hotta ne a lofiɗ na liiɓohaaɗ moɗiɗ, a woosa ɗe ne : « Fu usɗi Nguuriŋ-Kooh. » Ŋ finho ineem, ali ɓo' kaañisɗi ɗe meekis ne a markisuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeesu nikee jangɗoheeɗa ŋ ɗooƴ Kahan Kooh poyi. Ngaŋ jangɗoheem a meeksohha ne : « Jangɗohoh ciŋ waasi minoh woo na ne : “ Mucɗohi Gapohse, a setiŋ Dawuuda ? ” ");
INSERT INTO sav_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te ŋ hot Fuuɗsi Hoolohngaani, woyɗukohiɗ Dawuuda inii : “ Heɗ ɓoo woyiɗ Heɗ to ne : ‘Ɓoofa ŋ ñaahmiŋ ngo po mbaɗna ŋ folan ɓi sang ɗa, fu tum ɓa degoha kot.’ ” ");
INSERT INTO sav_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawuuda ŋ haf ce a yi ɓeeɗkoh Mucɗohi Gapohse Heɗ ce, kon a min na nikohis setiŋ ɗe ? » Wa raak mboolo laayiɗ nga sikɗukeeɗa Yeesu, ɓa neɓuusa. ");
INSERT INTO sav_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A woyeeɗa ɓa ŋ jangɗohaŋ ɗe ne : « Wortukaat mand na jangɗohoh ciŋ waasiŋ Musaa, ini neɓ ɓa weɗ ne ɓa ɓekuk kulɓa yakiɗ ɓa tiindsuke. Te ɓa kañɗassee yaah kanak ŋ ɗisik ci na toonohse ŋ kur. ");
INSERT INTO sav_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɓa nam waaɗ ne, ɓa nikan ŋ fiki ɓooɓi ngaŋ sinaagog ci, te ɓa ɓeeɗku kañam yakak ɗah, ɓa na waaɗe ɓoof ŋ ɗisik ci uup eɗu cir. ");
INSERT INTO sav_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓeɗ na ñame raakuuɗiŋ ɓitiɓ ci ƴaar ciŋ ɓa kaan po kahan ciŋ ɓa sah ; te ɓa kiimee Kooh ɗah, wa minuu reeh, ɓa waakee hotaat to. Ambaat ne a mbugaliŋ ɓa uupan misik. » ");
INSERT INTO sav_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wa Yeesu ƴut, a ɓooffa, a yurhiɗkohha na ɗiska na ɓekohse kopora ŋ Kahan Kooh, a markeeɗa mboolnda, ɓa ɓekeeɗa kopor nga, a hotta ɓi heɗ alal laayiɗ ɓekeeɗa kopor keeh-keeh nga. ");
INSERT INTO sav_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A nammba hot ɓitiɓ ñakiɗ, yi ƴaar ce kaan, ɓekiɗ nga hanjar kanak ƴin findi pistiriñ. ");
INSERT INTO sav_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeesu ɓeeɗukka taalubeeciŋ ɗe, a woosa ɓa ne : « Ñam woo ɗu wa te wa keeh, ini ɓitɓi ñakɗii eɗoh, weɗ uup ciŋ ɓinooɓi jen. ");
INSERT INTO sav_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Laam findi ɓa hend jen, ɓa eɗoh ini ɓa etohɗi ŋ raak-raakiŋ ɓa, waaye a yi, ŋ ñaki a ñak a eɗoh ini a raakee pesoha jen. » ");
INSERT INTO sav_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","A Yeesu nik ŋ Kahan Kooh po a puleeɗa, ƴaar ŋ taalubeeciŋ ɗe woosa ɗe ne : « Jangɗohohi, marka taɓah ci findi ca yakoh na atoh ci ca taɓahohu findi ca moɗoh ! » ");
INSERT INTO sav_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeesu loffa ɗe ne : « Taɓah ci yakak ci fu na hote cii, ali atoh tasanɗi ŋ ɗafuk atoh ŋ ndii, ca jen ca hey yahrohse. » ");
INSERT INTO sav_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ŋ finho woo keem, a kaɗta, a ɓooffa ŋ ɗafuk Tangooraŋ-Oliiw-ca, a yurhiɗkohha na Kahnaŋ Kooh. Piyeer na Saak na Saaŋ na Andare ɗaayya na ɗe, meekissa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","« Woya ɓoo jamanooni in ceem na hee raakohe na ini na hee teeɓohe ne in ceem jen ca ɗi heeɗa raake. » ");
INSERT INTO sav_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A kooɗta woo ki, a lofeeɗa ɓa an : « Wortukaat, ali ɓo' kinaat ɗu muuƴiɗ. ");
INSERT INTO sav_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɓo' laayiɗ hey haye, ɓa kooɗ tiikiŋ ngo, ɓa woyee ne ɓeɗ Mucɗohi Gapohse te ɓa hey muuƴɗe ɓo' laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kaɗ po ɗu kerhoot ɓi hiñoh yakak wala ɗu kerah yegɗoh ci na woye ŋ hiñoh ɗah, kinaat neƴƴoh, in ceem joy joy raak waaye wa nikanɗi ne a Adina na reehe ŋ ɗiski ɗiski. ");
INSERT INTO sav_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cum ɗah, kur hey hiñohe na kur morom wa, buur hey hiñohe na buur morom ce. Kehƴi hey yoondɗuke ŋ ɓi ɗisik te aɗ raak ŋ ɓi ɗisik. Wa nikohan ɗaa. Ca nikan cambiŋ miskiɗ ci findi ɓitɓi na hee ɓasle. ");
INSERT INTO sav_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Waaye ɗu, kurkaat ŋ haf ɗu, laam, ɗu hey ambse, ɗu ɓayu ŋ ngelohaaci, ɗu hey laɓse ŋ sinaagog ci te ɗu hey ɓayse ŋ fiki ɓi goornoor na ɓi buur saguuso. Ineem hey tahe po ɗu min ndo seede ŋ fikiiɓa. ");
INSERT INTO sav_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yegɗohiŋ Muci weɗ joy katohu paaɗ ŋ cuuɓ ci jen. ");
INSERT INTO sav_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ɓa ɓayee ɗu kaso ɗah, kinaat feyu ŋ ini ɗu woyan. Woyaat ini hayɗohan ɗu ŋ saasi saasi ; e ɗu woyan haa, waaye a Fuuɗsi Hoolohngaani. ");
INSERT INTO sav_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ɓo' hey ambɗuke taambɗoh ce ne a apu, baabu hey ambɗuke kuɓkiŋ ɗe ne a apu, ɓi komaaki hey nike sangiɗ ciŋ ɓooɓi rim ɓa, ɓa apɗuk ɓa. ");
INSERT INTO sav_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓooɓi jen hey ɗu sange saguuso. Waaye ɓoyi na hee ndengɗuke muñ po ŋ reehɗohaana, hey mucɗasse. ");
INSERT INTO sav_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kaɗ po ɗu hot ini araamiɗi na yahrohe tufkiɗ ŋ ɗiski a joyɗi nik ɗah, - Fu yi na jange Fiis cii, inha ! - ɓooɓi wa raakan ŋ Yudee, ɓa saandohaat ŋ tangooca. ");
INSERT INTO sav_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɓoyi wa raakan ŋ ɗafuk teeraasiŋ ɗe, a ruhsee ɗah, a kinaat aas ŋ ɗooƴ kahan ce ne a hee ɓaye in nga. ");
INSERT INTO sav_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te ɓoyi wa raakan ŋ yohon ca, a kinaat gurid ne a hee ɓaye kulɓaakiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mas ɓitiɓ ci na hee nike rook ŋ jamanooneem na ɓapɗoh ci ! ");
INSERT INTO sav_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kiimaat Kooh po wa nikuu ŋ jamanooniŋ soosi. ");
INSERT INTO sav_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Laam ŋ mbeh ceem ɓooɓi hey raake miskiɗ. Miskiɗ mand ɗaa moosɗi raakoh ina Kooh feroh Adina poyi te wa raakissanɗi. ");
INSERT INTO sav_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te Heɗ ɓoo haawseeɗi mbeh ceem ɗah, ali kiñin heeɗi muce ; waaye a haawsiɗ ca sagu ɓooɓi a tan. ");
INSERT INTO sav_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ŋ jamanoonaam ɓo' woo ɗu ne Mucɗohi Gapohse yii ŋ ndii wala ŋ nden ɗah, kinaat ɗe kos. ");
INSERT INTO sav_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Laam ɓi ɓo' hey haye ɓa tum haf ɓa Mucɗohi Gapohse wala woosuuɗ te ɓa yino nga ca haa, ɓa haɓɗee firnde na keemaan ne ɓa muuƴiɗ ɓooɓi po ɓi Kooh tan sah ne wa mineen nik ɗah. ");
INSERT INTO sav_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Waaye ɗu nak, wortukaat ! Ŋ woyiɗ ɗu ca jen nak, bala ca hayan. ");
INSERT INTO sav_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ŋ jamanooneem, ŋ finho mbeh ci miskiɗ ceem, nohi ñuus, caɓni ƴim, ");
INSERT INTO sav_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hor ci keen, hatil ci nik ŋ eel ci yoondɗu, ");
INSERT INTO sav_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","teemb ndeem, ɓooɓi hey hote Kuɓkiŋ ɓoyi hayee ŋ eel, a hun na hatil laayiɗ na ndam. ");
INSERT INTO sav_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A hey woose malaakaaci, a cohɗoh ɓooɓi a tan ɓak po ɓak ŋ adinaani jen po ɗiska eel ci top. ");
INSERT INTO sav_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Inhaat ini nduni jangɗoh : Kaɗ po naak ciŋ wa hiƴ, wa camb kifis ɗah, ɗu na jaare inah ne rehi usisɗi. ");
INSERT INTO sav_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wa mand ɗaa, ɗu nam hot in ceem ɗah, inhaat ne wa usisɗi, weɗi ŋ nguɓu kahni. ");
INSERT INTO sav_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ñam na woyee ɗu wa te wa keeh, ɓooɓiŋ adinaani woti kurkohanɗi nga jen te in ceem jen raakɗi. ");
INSERT INTO sav_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Eel ci na kehƴi hey coote, waaye woo ciŋ ngo moosanɗi cootoh. ");
INSERT INTO sav_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ini kaɗ ŋ mbehi, wala wahtuuni in ceem na hee raakohe, ali ɓo' inahɗaa. E malaakaaciŋ Eel ci haa, a Kuɓki haa, a Baabi a yi inaha. ");
INSERT INTO sav_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kon wortukaat, kinaat neeh, ɗu inahɗi andi wa nikan kiɗa. ");
INSERT INTO sav_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wa mand na ƴaari na ɓaaɓe, a dengkoh ñaam ciŋ ɗe kahni, yaa nu nga ɗah a tufkiɗ ɗe, a woo ɗe ini a hee haɓɗe, a woo yi nik ŋ yahndeeri ne a niiɗaat. ");
INSERT INTO sav_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kon kinaat neeh, ɗu inahɗi andi heɗ kahni hayan kiɗa, ndaa wa nikan noh niiniɗ, wala na wek, wala na wiisaaɗi, wala daaɓdaaɓ. ");
INSERT INTO sav_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mbaa wortukaat po a hey jalañ ɗah, a raakuu ɗu neehe. ");
INSERT INTO sav_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ini mi na woyee ɗu, maa woyee wa ɓooɓi jen : Kinaat neeh ! » ");
INSERT INTO sav_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Waam, e neeh kanak tasee ne feetiŋ Paakiŋ Yawuut ci na wiŋ mbuuruuci raakaaɗi lawiir ci ree. Kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa na jangɗohoh caŋ wa waakeeɗa findi ɓa ambohan Yeesu te ɓo' yeguu, ne ɓa apɗuk ɗe. ");
INSERT INTO sav_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɓa woyee ne wa joyɗi nik ŋ ɗooƴ feet ci, ɓa sangee ne ɗuuɗ raak ŋ ɗooƴ ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeesu nikee ŋ kahan Simong Gaanaana, ŋ Betani. Ɗekka po ɓo' ɓitiɓ aassa, a raakka ɗe ñameeɗa, a ɓayee buteelalbaatar riifiɗ na laackoloñ haɓɗohuuɗ narda koceet, candoomaŋ wa ɗoɓeen lool. A poɓiɗta lecmiŋ wa, a yiiffa Yeesu wa ŋ haf. ");
INSERT INTO sav_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɓooɓa nikee ŋ ɗiska hotta ineem, ɓa lahtukeeɗa ŋ harmban ɓa, ɓa woyeeɗa ne : « Wa ye tah laackoloñi yahrohse ? ");
INSERT INTO sav_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa mineen toonohu ini uup dinaar teemet-kaahay (300), ñakiɗ ci eɗu kopori. » Ŋ ineem ɓa ngaskeeɗa ɓitɓa. ");
INSERT INTO sav_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Waaye Yeesu woosa ɓa ne : « Faɗaat ɗe, wa ye tah ɗu yaaɓɗee ɗe ? A tumiɗ to in baahiɗ. ");
INSERT INTO sav_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ñakiɗ ci genan gen na ɗu ; ɗu miniɗ ɓa tumiɗ in baahiɗ ŋ jamano nu ɗu waaɗoha ɗah. Waaye mi, ŋ genanɗi na ɗu. ");
INSERT INTO sav_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te ɓitɓii haɓiɗ ini a min, a eeñɗiɗ faaniŋ ngo po ƴutiɗ bala ɓekuukiŋ wa ŋ ruy-ruy. ");
INSERT INTO sav_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ñam na woyee ɗu wa te wa keeh, ɗisik nu Yegɗohiŋ Muci woyu ŋ adinaani jen ɗah, ini a haɓiɗ hey woyse nga, naandsukohaa ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudaa Iskaryot, yino ŋ Apootar ci ndaŋkiyaah na kanak ci (12), kaɗta ŋ kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa, ne a min ɓa eɗind Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ɓa sikɗukka ɗe, ɓa summba nga lool ! Ɓa gappa ɗe eɗ kopor. Ŋ ineem, Yudaa waakeeɗa findi a joy ɗe eɗoh ɓi sang ɗe moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ŋ mbehi koc ŋ feetiŋ Mbuuruuci raakaaɗi lawiir ci wi mbaaliŋ Paaki na hoosohse, taalubeeciŋ Yeesu meekissa ɗe ne : « Kilifaani, fu waaɗ ne ɓoo kaɗan ɗa haɓɗohɗa kañam kiŋ Paak nde ? » ");
INSERT INTO sav_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yeesu tuuƴca kanak nga ɓa, a woosa ɓa ne : « Kaɗaat Yerusalem, ɗu hey cohe na ƴaar ɓayiɗ meeme masuɓ, ñaakɗaat ɗe. ");
INSERT INTO sav_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Woyaat heɗ kahna a aasohan ne : “ Jangɗohohi woo ne, wa nde ɗiski a joy ñamoh mbaaliŋ Paak, a yi na taalubeeciŋ ɗe ? ” ");
INSERT INTO sav_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A hey ɗu teeɓe tuuƴ angiɗ ŋ ɗafuk kahna, na in ci joy nik nga, ɗu kooɗkiɗohɗan ɓoo kañam ki ndaam. » ");
INSERT INTO sav_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taalubeeca kaɗta Yerusalem ; wa ɓa ree, ɓa raakohha in ceem ɗaa findi Yeesu woyohee ɓa, ɓa kooɗkiɗta kañam kaŋ Paak. ");
INSERT INTO sav_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wa niina ree, Yeesu na Apootar ci ndaŋkiyaah na kanak ci (12) hayya. ");
INSERT INTO sav_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wa ɓa ɓoof ɓa ñameeɗa, a woosa ne : « Ñam na woyee ɗu wa te wa keeh, ɗu ɓi na ñame na so ɓii, yino nga ɗu hey yo eɗndohe ŋ ɓi sang ngo. » ");
INSERT INTO sav_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɓa soossa, yaa nu nga woosa ɗe ne : « Mbaar a mi haa ? » ");
INSERT INTO sav_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A loffa ɓa ne : « Yino ŋ ɗu ɓi ndaŋkiyaah na kanak ci (12) na ɓeke yaah na so ŋ booli. » ");
INSERT INTO sav_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A degga nga ne : « Wa keeh ne Kuɓkiŋ ɓoyi hey kurke nga findi Fiis ci woyoha nga ɗe, waaye mas ɓoyi na hee ɗe eɗndohe ŋ ɓi sang ɗe, ini ngisohee ŋ ɓoyeem weɗ ne a rimkuu. » ");
INSERT INTO sav_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ɓa ñameeɗa, Yeesu ɓayya mbuuru, a corkiɗta Kooh, a poɓiɗtaa, a eɗta ɓa wa, a woosa ɓa ne : « Ɓayaat, wii wa faaniŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ƴutta, a ɓayya kaas tumiɗ, a corkiɗta Kooh, a eɗta ɓa wa, ɓa jen ɓa annda nga. ");
INSERT INTO sav_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A woosa ɓa ne : « Wii, wa ñif miŋ ngo aamu wuu ɓi laayiɗ, ñif mi ndengiɗ Ambtiɗohi. ");
INSERT INTO sav_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ñam na woyee ɗu wa te wa keeh, ŋ heyɗi anisse masuɓ reseñ po mbaɗna ŋ anissan wi asi, ŋ Nguuraŋ Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wa ɓa ƴut ŋ kañam ka po ɓa ƴeekka ƴeek ciŋ Sabuur, ci hun na feeti, ɓa pulla, ɓa kaɗeeɗa Tangooraŋ-Oliiw-ca. ");
INSERT INTO sav_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeesu woosa ɓa ne : « Wa fiisuuɗ ne : “ Ŋ hey laɓe niiɗohi, mbaal ci pasarkoh. ” Kon inhaat ne ɗu jen ɗu hey kafnduke. ");
INSERT INTO sav_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Waaye, ŋ hultiɗu po ƴut ɗah, ŋ hey ɗu adge Galile. » ");
INSERT INTO sav_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyeer woosa ɗe ne : « Ali ɓooɓi jen kafnduk, ŋ kafndukanɗi. » ");
INSERT INTO sav_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeesu loffa ɗe ne : « Ñam na woyee ɗa wa te wa keeh, woti ŋ ɗooƴ weki, bala siiki leehkan waas kanak ɗah, fu hey yo taaske waas kaahay. » ");
INSERT INTO sav_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Waaye Piyeer ɓaatta ndengɗuk ŋ woo ka an : « Ali nik ne ŋ kaanan kaan na ɗa sah, ŋ taaskanɗi ɗa. » Ɓa jen ɓa nammba woo ɗaa. ");
INSERT INTO sav_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wa ɓa ree ngaŋ ɗiska na woyse Getsemane, Yeesu woosa ɓa ne : « Ɓoofaat ndii, ŋ kaɗ kiima Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A kooɗta Piyeer na Saak na Saaŋ, a hunnda na ɓa. A cammba yeg neƴƴoh na jaahiɗ ŋ ɗooƴ ce. ");
INSERT INTO sav_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A woosa ɓa ne : « Ɗiski wa nik ndii faaniŋ ngo goy goy po mi yii heeɗa kaane, tasaat ndii ɗu irin. » ");
INSERT INTO sav_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A faɗta ɓa ndaam, a kaɗta ƴissuut ŋ fikiiɓa, a ƴekka ŋ kehƴi, a kiimeeɗa Kooh ne wahtuuniŋ miskiɗi ɗalaat ɗe, ne wa min nik ɗah. ");
INSERT INTO sav_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A woosa ne : « Abba, Baab, raakɗi ini wooñ ɗa, usɗiɗ to kaasiŋ miskiɗii. Waaye wa kinaat nikoh findi ŋ waaɗoh, waaye waaɗ-waaɗiŋ ɗa weɗ raakaat. » ");
INSERT INTO sav_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wi a dokuk, a raakka ɓa neeheeɗa, a woosa Piyeer ne : « Simong, fu yi neeh de' ! Fu minɗi sah irin ini ree wahtu ! » ");
INSERT INTO sav_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A woosa ɓa ne : « Kinaat neeh, kiimaat Kooh a ndengiɗ ɗu po ɗu keenuu ŋ fiir. Waaɗ-waaɗi wii nga waaye faan ci raakɗi hatil. » ");
INSERT INTO sav_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A kaɗissa, a woyeeɗa in ci a woyee ŋ kiimaŋ ɗe koc. ");
INSERT INTO sav_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wa a dokkis nga ɓa, a raakissa ɓa neeheeɗa, raak ɓa pani'uuɗ po has ciŋ ɓa aaykohha. Ɓa raakeeɗi lofaah ɗe. ");
INSERT INTO sav_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A kaɗissa, a hayissa waasi kaahayɗoh, a woosa ɓa ne : « Ɗu ɓii neeh, ɗu ɓii iɗsiɗuk ! Wa doyiɗ, wahtuuni reyiɗ ! Weɗɗi, Kuɓkiŋ ɓoyi faɗuuɗ ŋ yaah ciŋ bakaaɗoh ci ! ");
INSERT INTO sav_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kurkaat ɓoo kaɗ ! Markaat, yi joy yo eɗndoh a yi ! » ");
INSERT INTO sav_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wa Yeesu na woye, jaarra, Yudaa, yi ɓaah ŋ ndaŋkiyaah na kanak ci (12), reesa na mboolo ɓayiɗ ɓi ndooɗ na ɓi ndang. Ɓa puloh ŋ kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na jangɗohoh caŋ wa na yakak ca. ");
INSERT INTO sav_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Raak Yudaa woyiɗ ɓa ne : « Ɓoyi maa hee foone inhaat ne a yi ; ambaat ɗe po a ndeng, ɗu ɓay ɗe ɗaa. » ");
INSERT INTO sav_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A reyeeɗa rek, a reɓpa ŋ Yeesu, a woosa ɗe ne : « Jangɗohohi ! » A foonnda ɗe. ");
INSERT INTO sav_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaarra ɓa ammba Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ƴaar ɓaah ŋ ɓa nikee ŋ ndaam fuurra ndang, ƴoɓpa ñaam ŋ ñaam caŋ seeƴkiɗoha yakka, a carissa nofaŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeesu woosa ɓa ne : « Ɗu hayiɗ na ndooɗ na ndang findi taamboh rok ne ɗu amb mbo. ");
INSERT INTO sav_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Moona Kooh-nu-wiis, ŋ nikee ŋ harmban ɗu ŋ Kahan Kooh, ŋ jangɗoheeɗa, te ɗu ambɗi so. Waaye in cii jen raakiɗ ne ini Fiis ci Hooliɗ ci woo raak. » ");
INSERT INTO sav_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋ ineem, taalubeeciŋ ɗe jen faɗta ɗe, ɓa saandohha. ");
INSERT INTO sav_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Raakiɗ kuɓka fiira ñaakɗee ɗe, a lipkee na uuf dong. A ambseeɗa, ");
INSERT INTO sav_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a faɗta lipaŋ ɗe nga, a saandohha faan ɓarang. ");
INSERT INTO sav_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓa ɓayoh Yeesu ɗaa ŋ kahan seeƴkiɗoha yakka. Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa jen na jangɗohoh caŋ wa na yakak ca cohee ŋ ɗiska. ");
INSERT INTO sav_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyeer nikee ñaakɗeeɗa ɗe usiɗ ŋ finhoora po findi a reyoh kahan seeƴkiɗoha yakka, a ɓooffa na surgaaca ŋ leero kahna, ɓa yohnukeeɗa. ");
INSERT INTO sav_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa na ɓooɓa ɓinooɓa ɓaah ŋ saangnaŋ yakak caŋ Israayel jen waakeeɗa seede ne ɓa raak ini tah ɓa min apɗuk Yeesu, waaye ɓa hotɗi. ");
INSERT INTO sav_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Laayiɗ leyɗoheeɗa ɗe waaye woo caŋ ɓa huneeɗi. ");
INSERT INTO sav_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Raakka ɓa kuruk leyɗoheeɗa ɗe ne ");
INSERT INTO sav_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ɓa kerhootiɗ ɗe a woosa ne : « Ŋ hey yahrohe Kahniŋ Kooh wi yaah ɓo' haɓiɗ wii. Ƴut ɗah, ngaŋ neeh kaahay, ŋ taɓah wiiriis wi yaah ɓo' haɓɗanɗi. » ");
INSERT INTO sav_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Po ŋ ineem sah, woo caŋ ɓa huneeɗi. ");
INSERT INTO sav_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Teemb ndeem, seeƴkiɗoha yakka tufukka ŋ fiki mboolnda jen, a meekissa Yeesu ne : « Fu heyɗi lofe ali in ŋ in ci ɓooɓi na yambee ɗa e ? » ");
INSERT INTO sav_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Waaye Yeesu ɗekka teɗ, lofɗi ali in. Seeƴkiɗoha yakka meeksissa ɗe an : « Andi a fu Mucɗohi Gapohse, kuɓkiŋ Heɗ barkeeni ? » ");
INSERT INTO sav_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu loffa ɗe ne : « Ñam nik, te ɗu hey hote Kuɓkiŋ ɓoyi ɓoofiɗ ŋ ñaahmiŋ Heɗ hatili, te ɗu hey ɗe hote hayee ŋ eel. » ");
INSERT INTO sav_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Seeƴkiɗoha yakka faarra kulɓaaciŋ ɗe, a yi ŋ haf ce, ne a teeɓoh ne wa woo uupiɗ. A woosa ɓa ne : « Ɓoo etohis seede ye ? ");
INSERT INTO sav_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A ɗu kerhoota, a ɗaliɗ Kooh, a joy ye tumu ? » Ɓa jen ɓa hunnda ɓa woosa ne : « A apaah apu ! » ");
INSERT INTO sav_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Raakka ɓi tuhsee ɗe, ɓa muurra has ciŋ ɗe na daah, ɓa laɓeeɗa ɗe kumah, ɓa woyeeɗa ɗe ne : « Nik ne fu woosuuɗ ɗah, woya ɓoyi laɓ ɗa ! » Surgaaca taambukka ɗe na paɗ. ");
INSERT INTO sav_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Waam, raak Piyeer ŋ kehƴi, ŋ leero kahna, komaaki cafaƴ reesa, a ɓaahee ŋ ñaam caŋ seeƴkiɗoha yakka. ");
INSERT INTO sav_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A hotta Piyeer yohnukeeɗa, a feerukka ɗe baahiɗ, a woosa ɗe ne : « Fu namee nik na ƴaariŋ Nasareet ci, Yeesu. » ");
INSERT INTO sav_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Waaye Piyeer woosa ɗe ne : « Ŋ hotɗi ini fu waaɗ woo te ŋ inahɗaa. » A kurkohha ndaam, a kaɗta nguɓu kahna. Siika leehukka. ");
INSERT INTO sav_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɓoya ɓitɓa hotissa ɗe, a woyisseeɗa ɓooɓa nikee nga ne : « Ƴaarii, a ɓaah ŋ ƴaaɓiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Waaye Piyeer taaskissa. Wa degga ƴissuut, ƴaaɓa nikee ndaam nammba ɗe woo ne : « Fu ɓo' Galile, wa keeh ne fu ɓaah ŋ ƴaaɓiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piyeer giñeeɗa, a woosa ne : « Ŋ lee ɗah, Kooh alkaat to, waaye ŋ inahɗi ƴaari ɗu na woye. » ");
INSERT INTO sav_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Weɗi siika kanakɗukoh leehuk. A naandsukka findi Yeesu woyohee ɗe wa ne : « Bala siiki leehkan waas kanak ɗah, fu hey yo taaske waas kaahay. » Jaarra, a fuɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wa Kooh wiis na ɓaaɓa teel, kilifaacaŋ seeƴkiɗoh caŋ waasiŋMusaa cohha na jangɗohoh caŋ wa, na yakak ca, na saangnaŋ atte'oh ca jen. Ɓa tokɗukka Yeesu, ɓa ɓayya ɗe ŋ Pilaat. ");
INSERT INTO sav_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wa ɓa ree, Pilaat meekissa ɗe ne : « A fu buuriŋ Yawuut ci e ? » Yeesu loffa ɗe ne : « Fu woyiɗa ! » ");
INSERT INTO sav_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa yambeeɗa ɗe in laayiɗ. ");
INSERT INTO sav_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaat woyissa ɗe ne : « Fu lofanɗi e ? Fu kerahɗi in ci laayiɗ ci ɓa na yambee ɗa e ? » ");
INSERT INTO sav_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Waaye Yeesu lofisɗi ali in ; ineem feyya Pilaat. ");
INSERT INTO sav_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Waam, feet Paak reyeen ɗah, Pilaat faɗsiɗ ɓa ambuuɗ yino ŋ ɓa nik ŋ kasoona, ɓeɗ na tanootee ɗe. ");
INSERT INTO sav_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wa raakeen ƴaar teeku Barabaas ; a ɓaahee ŋ ɓa hiñohee na nguura. Wa kurka yoond, ɓa apee ɓo', ɓa taƴuusa ŋ kasoona. ");
INSERT INTO sav_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mboolnda kaɗta ŋ Pilaat, ɓa woyeeɗa ɗe ne : « Haɓɗiɗa ɓoo ini fu na cure ɓoo tumiɗ kiis nu ree. » ");
INSERT INTO sav_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaat loffa ɓa ne : « Ɗu waaɗ ne ŋ faɗsiɗ ɗu buuriŋ Yawuut ci e ? » ");
INSERT INTO sav_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A inheen ne waaɗa ɓooɓa waaɗ Yeesu, weɗ tah po kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa degga ɗe ŋ yaah ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Waaye ɓa yoppa mboolnda ne ɓa woyaat ne : Barabaas ! ");
INSERT INTO sav_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaat woyissa ɓa ne : « Moo ɗu waaɗ ne ŋ tum ƴaari ɗu teek buuriŋ Yawuut ci na ? » ");
INSERT INTO sav_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓa leehkisseeɗa ŋ ɗafka ne : « Daaƴaa ɗe ŋ kurwaa ! » ");
INSERT INTO sav_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A meekissa ɓa ne : « A haɓiɗ ye in moɗaaɗi ? » Waaye ɓa uupeeɗa nga leehuk ŋ ɗafka an : « Daaƴaa ɗe ŋ kurwaa ! » ");
INSERT INTO sav_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilaat waaɗta jam, a taambiɗta mboolnda ŋ ini neɓ ɓa ; a faɗsiɗta ɓa Barabaas, a nakohha Yeesu laɓu na leraw po ƴutta, a eɗta soldaar ca ɗe ne ɓa daaƴ ɗe ŋ kurwaa. ");
INSERT INTO sav_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɓa ɓayya ɗe leero kahan goornoor, ɓa ɓeeɗukka soldaar ca ɓinooɓa jen. ");
INSERT INTO sav_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓa ɓekiɗta ɗe kulɓa ruumind po haa buur, ɓa teɗta ñapir, ɓa ɓekiɗta ɗe wa ŋ haf findi mbahne-buur. ");
INSERT INTO sav_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɓa kañɗeeɗa ɗe an : « Ɓoo ɓii kañiɗ ɗa buuriŋ Yawuut ci. » ");
INSERT INTO sav_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓa laɓeeɗa ɗe ŋ haf na ngeer, ɓa tuhseeɗa ɗe, ɓa ƴekeeɗa ŋ fikiice. ");
INSERT INTO sav_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wa ɓa njembit ɗe po ƴutta, ɓa wolla kulɓaaka ɓa ɓekɗee ɗe, ɓa ɓekɗissa ɗe kulɓaacaŋ ɗe, ɓa ɓayeeɗa ɗe bilaf fa ne ɓa daaƴaa ɗe ŋ kurwaa. ");
INSERT INTO sav_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Waam raak ƴaar gen Sireen teeku Simong, baabiŋ Aleksaandar na Rufus, a pulohee ɓak caŋ yohon ca, a lahha ndaam, ɓa tufukka ɗe ne a deguk kurwaaniŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓa ɓayya Yeesu po ŋ ɗiska na woyse Golgota, wa tokis \"Ƴoh-haf\", ");
INSERT INTO sav_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ɓa waaɗta ɗe anɗukoh biiñ ambsohuuɗ na miir, waaye a anɗi. ");
INSERT INTO sav_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ƴutta, soldaar ca daaƴca ɗe ŋ kurwaa, ɓa piilohha kulɓaacaŋ ɗe ne yaa nu nga ɗah inah ini a joy raak. ");
INSERT INTO sav_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wa raak yoor-yoora aaseeɗa. ");
INSERT INTO sav_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Raakka ina ɓa fiis ndaam, ne wa teeɓoh ini tah ɗe daaƴu. Ɓa fiisee inii : « Buuriŋ Yawuut ci. » ");
INSERT INTO sav_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yeesu daaƴsee na rokoh kanak, yii lahha ɗe yaah-ñaahum, yum yaah-sing.  ");
INSERT INTO sav_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓooɓa taambee ŋ ɗiska njembteeɗa ɗe, ɓa kuɗteeɗa haf, ɓa ɓaseeɗa ɗe an : « Ngec ! Fu yi woyee ne, fu hey yahrohe Kahniŋ Kooh, fu taɓahisa ŋ neeh kaahay, ");
INSERT INTO sav_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mucɗa haf fu, fu ruhus ŋ kurwaani ! » ");
INSERT INTO sav_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kilifaacaŋ seeƴkiɗoh caŋ waasiŋ Musaa ŋ harmban ɓa, na jangɗohoh caŋ wa nameeɗa ɗe njembit an : « A mucɗiɗ ɓinooɓi, a minɗi muciɗ haf ce ! ");
INSERT INTO sav_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mucɗohi Gapohse, buuriŋ Israayel, ruhsaat ŋ kurwaani win-win, ɓoo hot, ɓoo han kos. » Ɓa daaƴsee na ɗe nameeɗa ɗe ɓas. ");
INSERT INTO sav_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wa njooloora ree, kehƴi jen nikka ŋ ñuus ini ree wahtu kaahay. ");
INSERT INTO sav_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wa wahtu ceem mit, Yeesu leehukka ŋ ɗafka, a woosa ne : « Eloyi ! Eloyi ! Lema sabahtani ? » weɗ ne \"Koohiŋ ngo ! Koohiŋ ngo ! Wa ye tah fu faɗta so ?\" ");
INSERT INTO sav_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ɓi ɓo' ɓaah ŋ ɓa nikee ŋ ndaam kerahhaa, ɓa woosa ne : « Kerhaat, a na ɓeeɗke Ilyas ! » ");
INSERT INTO sav_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ƴaar nga ɓa nuppa, ɓayya daah, a hooƴcaa ŋ masuɓ raakiɗ bineegar, a tokkaa ŋ lecem ndooɗ, a deggaa ŋ nguɓiŋ Yeesu ne a an. Ƴaara woosa ne : « Sekaat ɓoo marak, andi Ilyas hey ɗe hee ruhsiɗe ŋ kurwaani. » ");
INSERT INTO sav_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeesu leehukka, nguɗta. ");
INSERT INTO sav_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ridoona ɗasɗee Ɗiska Hoolohngaanaŋ Kahnaŋ Kooh faarukka tareet ini kooɗoh ɗafka po kehƴa. ");
INSERT INTO sav_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ƴaara adgohee soldaar ca, ya tufkee ŋ fiki Yeesu, hotta findi a kaanoh, a woosa ne : « Wa keeh ne ƴaarii nikee Kuɓu Kooh. » ");
INSERT INTO sav_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Raakeen ɓitiɓ ca tufkee usiɗ markeeɗa. Mari Makdala ɓaahee nga na Salome na Mari yi yaay ɓi Yoose na Saak yi ƴini. ");
INSERT INTO sav_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓeem ɓeɗ ñaakɗee Yeesu te ɓeɗ meeɗ ɗe taambkoh wa a nik ŋ Galile. Nameen raak ɓitiɓ wiiriis laayiɗ, ɓaah ŋ ɓa hunee na ɗe Yerusalem. ");
INSERT INTO sav_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ŋ noh niinɗaŋ mbehi na kooɗkohse, wi adug mbehi na iɗsiɗkohse, Suseef ya genee Arimate hayya. A nikee ɓo' yeguuɗ ŋ atte'oh ca te a yi ŋ haf ce, a namee sek Nguuriŋ-Kooh. Hooɓa wa kee hooɓa tahha po a kaɗta ŋ Pilaat na fit, a meekissa ɗe fiɗaafa. ");
INSERT INTO sav_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaat feyuusa wi a kerah ne Yeesu ariɗ kaan, a nakohha ɓeeɗkiɗu ƴaara adgohee soldaar ca, a meekissa ɗe andi a ɓaatsiɗiɗ kaan. ");
INSERT INTO sav_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilaat kerahha ini yeem lof, a teyɗukiɗta Suseef ne a ɓayaat fiɗaafa. ");
INSERT INTO sav_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Suseef rommba uuf leeŋ, a ruhsiɗta faanaŋ Yeesu ŋ ɗiska wa daaƴsee ; a lemessaa na uufa, a ɓekkaa ŋ ruy-ruy huruuɗ ŋ atoh. Ƴutta, a pilnginnda atoh yakak, a ranngaa naa. ");
INSERT INTO sav_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Raak Mari Makdala na Mari yaay ɓi Yoose nga, ɓa markeeɗa ŋ ɗiska Yeesu ɗaaku. ");
INSERT INTO sav_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wa nohi muy po mbehi na iɗsiɗkohse reehha, Mari Makdala na Salome na Mari yaay ɓi Saak rommba eeñɗoha ne ɓa reefa fiɗaafaŋ Yeesu. ");
INSERT INTO sav_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ŋ Kooh-wiisiina na ɓaaɓa teel, wa ɓitiɓ ceem reyee ruy-ruya, raak nohi haneeɗa pul. ");
INSERT INTO sav_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓa woyeeɗa ŋ harmban ɓa ne : « Moo ! Ya ɓa na hee ɓoo pilnginɗe atoh fa rangohu ruy-ruya ? » ");
INSERT INTO sav_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɓa jaɗtukka, ɓa hotta ne atoh fa rangee wa pilnginuuɗ te wa nikee atoh yakoh na yakoh. ");
INSERT INTO sav_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɓa aassa ŋ ruy-ruya, ɓa hotta fiir ɓekkiɗ sabidoor yaanow melciɗ, ɓoofiɗ ŋ ɓaka ñaahma, ɓa feyuusa jameet. ");
INSERT INTO sav_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Waaye, ƴaara woosa ɓa ne : « Kanaat feyu, ɗu na marke Yeesu yiŋ Nasareet, yi daaƴse ŋ kurwaa. A hultiɗuuɗ, a nikisɗi ndii, ɗiski a ɗaaksee weɗɗi. ");
INSERT INTO sav_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɗiski wa nik, kaɗaat ɗu woya taalubeeci, Piyeer na ɓinooɓi, ne a yaa adug ɗu Galile. Ɗu na hee ɗe hotohe ndaam findi a woyohee ɗu wa. » ");
INSERT INTO sav_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɓa pulla ruy-ruya, ɓa saandoheeɗa. Ɓa nikee saakɗoheeɗa sagu tiit, neƴƴoheem tahha po ɓa wooɗi ali ɓo' in.  ");
INSERT INTO sav_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wa Yeesu hulit ŋ mbehi koc na ɓaaɓa, a ɗeɓ teeɓ haf ce Mari Makdala. A yi ɓitɓa a saɓsohee na jiini yasna-kanak. ");
INSERT INTO sav_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yeem kaɗta, a raakka ɓa meeɗ hun na Yeesu fuɗeeɗa kakaan kiŋ ɗe ; a naandsukka ɓa wa. ");
INSERT INTO sav_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Waaye, wa a woo ɓa ne : « Yeesu hultiɗ, ŋ hotiɗ ɗe ! » Ɓa kosɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ƴutta, Yeesu teeɓkissa taalube kanak, ŋ ñaamaar ɗalohiɗ na wa koc, raak ɓa ŋ waas ŋ bilaf fa. ");
INSERT INTO sav_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓa hayya, ɓa naandsukkaa taalubeeca ɓinooɓa, waaye ɓa namɗaa kos. ");
INSERT INTO sav_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ŋ mirndaani, a teeɓukka Apootar ci ndaŋkiyaah na yinooci (11), raak ɓa ɓoofiɗ ñameeɗa. A ngassa ɓa ŋ ndengkiŋ ɓa keeñ na ini ɓa kosɗi ɓooɓi hot ɗe hultiɗuuɗ. ");
INSERT INTO sav_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A hannda ɓa woo ne : « Kaɗaat ŋ adinaani jen, ɗu woo ɓooɓi feru jen Yegɗohiŋ Muci. ");
INSERT INTO sav_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yaa nu kos te a ɓoktu ɗah, a hey muce, waaye yaa nu kosɗi ɗah, a hey atte'se findi bakaaɗoh. ");
INSERT INTO sav_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te in ci ɓooɓi kosan ndo inhisohsan ceɗi cii : Ɓa hey aañe jiini ŋ tiikiŋ ngo, ɓa jombee ɓi peɗeem as, ");
INSERT INTO sav_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ali ɓa amb iiñ wala ɓa an posani na ape sah, ali in rahsanɗi ɓa. Ɓa hey dege kosaayiɗ ci yaah, ɓa wir. » ");
INSERT INTO sav_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wa Heɗ ɓoo Yeesu ƴut ɓa woo in ceem, a rapɗuusa ŋ Eel ca, a ɓooffa ŋ ñaahmaŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taalubeeci woosa Yegɗohiŋ Muci ŋ ɗisik nu nik, Heɗ ɓoo ambɗohha ɓa ŋ pangkeem, in ci feyohiɗ ci a haɓɗee ɗisik nu ɓa kaɗ ɗah, ca teeɓohha ne woo kiŋ ɓa, wa keeh.");
INSERT INTO sav_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tewofiil kilifaani, ɓo' laayiɗ ndengɗukiɗ ŋ fiisiŋ in ci haɓɗu ŋ harmban ɓoo ; ");
INSERT INTO sav_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ɓa kooɗ naandsuk ciŋ ɓooɓi maasoh ina amboh ŋ cambohaaɗa te ɓooɓeem mirndohha nik ɓi na taambkohe woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mi nak, ŋ meeksohiɗ baahiɗ findi in ceem jen raakoh ŋ cambohaana po ŋ reehɗohaana, weɗi tah po ŋ namiɗ ɗa waaɗ teeɓ ngaŋ fiis, findi in ceem taambtiɗohohe. ");
INSERT INTO sav_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ŋ fiisiɗ in ceem jen ne fu min inah ne, ini fu jangɗu, wa ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ŋ jamanoona Herod nikoh buuraŋ Yudee, wa raakeen ƴaar teeku Sakariya, a ɓaahee ŋ seeƴkiɗoh caŋ cuuɓaŋ Abiya. Ɓitiice teeksee Elisabet, a ɓaahee ŋ ɓi kahan Aaruna, caaciŋ seeƴkiɗoh ciŋ Israayel. ");
INSERT INTO sav_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓa kanak jen ɓa nikee ɓo' yurhiɗ ŋ fiki Kooh ; ɓa meeɗta taambiɗ in ci Heɗ ɓoo nakoh jen na waasiŋ ɗe te ali ɓo' raakeeɗi woyaah ɓa. ");
INSERT INTO sav_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Waaye ɓa raakeeɗi kuɓu laam Elisabet jaasiree jaasir, te ɓa kanak jen, ɓa nikee yakak. ");
INSERT INTO sav_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wa raakka mbeh, Sakariya seeƴkeeɗa wuu Kooh sagu ne e cuuɓaŋ Abiya raakɗohee seeƴka ŋ neeh caam. ");
INSERT INTO sav_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Findi ɓa meeɗa tumoh, seeƴkiɗoh ca markiskeeɗa ne Kooh teeɓ ɓa ɓoyi joy aas ŋ Ɗiska HooliɗaŋKahnaŋ Kooh Heɗ ɓoo, ne a fuuɗ cuuraay nga, wa hennda nga ɗe. ");
INSERT INTO sav_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ŋ jamanoona cuuraaya na fuuɗohse, tel mboolnda jen ŋ hara kiimeeɗa Kooh. ");
INSERT INTO sav_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Malaaka Heɗ ɓoo teeɓukka Sakariya, a nikee ŋ ñaahmaŋ seeƴkohaana na suusohse cuuraaya. ");
INSERT INTO sav_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariya hot ɗe hot rek, a feyuusa, a tiitta. ");
INSERT INTO sav_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malaakaana woosa ɗe ne : « Kana neƴƴoh Sakariya, kiimiŋ ɗa teyɗukuuɗ : ɓitiifu Elisabet hey raake kuɓu ƴaar yi fu na hee teeke Yahya. ");
INSERT INTO sav_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A hey soosɗe keeñiŋ ɗa te ɓi ɓo' laayiɗ hey sume ŋ raakuukiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Laam a hey nikee ɓo' yakiɗ ŋ fiki Heɗ ɓoo, a heyɗi ane biiñ mbaa sangara wiiriis, te a rimkan riifiɗ na Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɓi ɓo' laayiɗ ŋ Israayel, a hey ɓa dokne ŋ Heɗi, Koohiŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A hey adge Heɗ ɓoo, a hun na hatiliŋ Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh, findi woosuuɗi Ilyas hunohee naa. A hey ɓeke kerhiɗoh ŋ harmban baab na kuɓu, a yurhiɗ ɓooɓi kerhiɗɗi Kooh ; ŋ ineem, a hey kooɗkiɗe Heɗ ɓoo cuuɓ tufkiɗuuɗ po ƴutiɗ. » ");
INSERT INTO sav_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya meekissa malaakaana ne : « Ŋ min inhoh na ne ineem wa keeh ? Laam ŋ yakak te ɓitiiso ɓitfiɗ. » ");
INSERT INTO sav_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaakaana loffa ɗe ne : « Ñam Jibriil, yi nik na Kooh. A yi woos so ne ŋ gap ɗa in ci neɓiɗ cii. ");
INSERT INTO sav_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Fu kosɗi woo kiŋ ngo, wa tahiɗ po fu hey muume, fu minissanɗi jomb po mbaɗna ini ŋ woo ɗa raakan ŋ jamanoonaŋ wa. » ");
INSERT INTO sav_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Waam raak ɓooɓa sekeeɗa Sakariya, ɓa feyuusa ŋ maaña a maañ ŋ Ɗiska Hooliɗa. ");
INSERT INTO sav_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wa a pul, a minɗi woo, ɓooɓa inahha ne in hayɗohiɗ ɗe findi heeƴ ŋ ɗiska. A nikka muum, a woyee na ɓa woo muum. ");
INSERT INTO sav_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wa mbeh ca a joyee panguk reeh, a haadda kahan ce. ");
INSERT INTO sav_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wa maañɗi ɓitiice Elisabet ammba rook, a ɗemmba naa caɓin yatuus. A woyeeɗa ŋ ɗooƴ ce an : ");
INSERT INTO sav_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Inii, a Heɗ ɓoo tuma, a baahohiɗ to po, a paƴɗiɗ to kaciikiŋ ngo ŋ ɓooɓi. » ");
INSERT INTO sav_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wa Elisabet nik ŋ caɓnaŋ ɗe yasna-yino'ɗoh, Kooh woossa malaakaaniŋ ɗe Jibriil ŋ kur ka nik ŋ Galile na woyse Nasareet. ");
INSERT INTO sav_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A tuuƴ ɗe ŋ cafaƴ inhaaɗi ƴaar na woyse Maryaama. Maryaama yeem, fiira nguɗee cakiim nga ɗe teeksee Suseef te a ɓaahee ŋ cuuɓiŋ Dawuuda. ");
INSERT INTO sav_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaakaana reɓpa, a woosa ɗe ne : « Mi yii kañiɗ ɗa Maryaama, fu yi baahohu ; Heɗ ɓoo a yi na ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kañɗoheem feyya Maryaama, a liiɓeeɗa ini wa joy tokis. ");
INSERT INTO sav_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaakaana woosa ɗe ne : « Kana neƴƴoh Maryaama, Kooh baahohiɗ ɗa. ");
INSERT INTO sav_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fu hey ambe rook, fu raak kuɓu ƴaar ; yi fu na hee teeke Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A hey nike ɓo' yakak, a hey ɓeeɗkasse Kuɓkiŋ Kooh yi ŋ ɗafka ɗafka, te Kooh Heɗ Ɓoo hey ɗe eɗe Nguuriŋ caac ɓa Dawuuda. ");
INSERT INTO sav_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A hey adgohe cuuɓiŋ Yaŋhooɓa po faw te Nguuriŋ ɗe moosanɗi reeh. » ");
INSERT INTO sav_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryaama meekissa malaakaana ne : « Ineem na hee nikohe na te ŋ inahɗi ƴaar ? » ");
INSERT INTO sav_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaakaana loffa ɗe ne : « Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh hey haye nga ɗa, hatiliŋ Kooh yi ŋ ɗafka ɗafka hey ɗa saangne. Ineem weɗi tah po kuɓki hoolɗi fu na hee raake hey ɓeeɗkohse Kuɓkiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Marka, Elisabet yi ndaamu nga ɗa, a rook ; a hey raake kuɓu ƴaar ŋ kiɓitfiŋ ɗe wii. A yi ɓooɓi woyee ne, a jaasir jaasir, moona a rook po wa raakiɗ caɓin yasna-yino. ");
INSERT INTO sav_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Laam raakɗi ini wooñ Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryaama loffa ne : « Mi deey, ŋ ñaamiŋ Heɗ ɓoo. Ineem rahsaat to findi fu woyoha. » Malaakaana cootta. ");
INSERT INTO sav_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ŋ neeh caam, Maryaama arra kaɗ ŋ kur, ŋ tangoocaŋ Yudee. ");
INSERT INTO sav_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wa a ree, a aassa kahan Sakariya, a kañiɗta Elisabet. ");
INSERT INTO sav_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet kerah kerah kañɗohaŋ Maryaama rek, kuɓkiŋ ɗe yoonnda ŋ ɗooƴ rookiŋ ɗe. Elisabet riiffa na Fuuɗsi Hoolohngaani ");
INSERT INTO sav_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a woosa Maryaama ŋ ɗafka ne : « A fu uupiɗ barke ŋ ɓitiɓ ci jen te kuɓki fu na hee raake barke'iɗ. ");
INSERT INTO sav_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A mi ya ɓa po yaayiŋ Heɗ ɓoo hee so marke ? ");
INSERT INTO sav_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wi ŋ kerah kañɗohiŋ ɗa, kuɓki ŋ rookiŋ ngo yoonnda, sagu sum. ");
INSERT INTO sav_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Suma, fu yi kos ne ini Heɗ ɓoo woo ɗa hey raake. » ");
INSERT INTO sav_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ŋ ineem Maryaama woosa ne : « Coonndiŋ ngo weɗi ƴeek yakkiŋ Heɗ ɓoo, ");
INSERT INTO sav_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Keeñiŋ ngo soosiɗ ŋ Kooh Mucɗohiŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A alɗi so, mi yi ñaamiŋ ɗe ñakiɗ njirñi. Ee, ini camboh woti, ɓooɓi jen ngaŋ jamano nu nik ɗah, hey woye ne ŋ ɓitiɓ barke'iɗ. ");
INSERT INTO sav_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Laam, Koohi Min tumɗiɗ to in yakiɗ. Tiikiŋ ɗe Hooliɗ. ");
INSERT INTO sav_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yirmandeeniŋ ɗe genan gen ngaŋ ɓooɓi neek ɗe gomal nu gomal. ");
INSERT INTO sav_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A teeɓohiɗ doolndiŋ ɗe. A pasarohha ɓooɓi yaksiɗkiɗ ci. ");
INSERT INTO sav_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A folla buur. A kurkiɗta ɓooɓi eɗfiɗ ci. ");
INSERT INTO sav_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A onnda aɗkiɗ ci kañam baahiɗ. A aannja raakiɗ ci yaah ɓarang. ");
INSERT INTO sav_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A hirpiɗ Israayel ci ñaam ciŋ ɗe. A alkohɗi teeɓoh yirmandeeniŋ ɗe ");
INSERT INTO sav_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ŋ Ibrahiima na ɓi puloh nga ɗe gomal nu gomal findi a gapohee wa caac ciŋ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryaama ɓooffa ŋ ɗiskaŋ Elisabet ŋ ini ɗal ree caɓin kaahay, wala wa uupa, ƴutta a haadda. ");
INSERT INTO sav_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wa noha Elisabet joy ɓasloh ree, a raakka kuɓu ƴaar. ");
INSERT INTO sav_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gentoh ciŋ ɗe na ɓaah ciŋ ɗe kerahha ne Heɗ ɓoo baahohiɗ ɗe ŋ ineem, ɓa ambsukohha na ɗe, ɓa neɓuusa nga. ");
INSERT INTO sav_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wa mbeha a ɓasloh dokuk, ɓa hayya ne ɓa nguɗ kuɓka. Ɓa waaɗta ɗe teek ŋ baab ɓa Sakariya ");
INSERT INTO sav_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","waaye Elisabet woosa ɓa ne : « Muk, a teeksan Yahya. » ");
INSERT INTO sav_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓa woosa ɗe ne : « Moo, ɗu raakɗi ali ɓaahi teeku ɗaa. » ");
INSERT INTO sav_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓa meekseeɗa Sakariya na yaah findi a waaɗ ne kuɓkiŋ ɗe teeku. ");
INSERT INTO sav_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A nakohha waakɗu fiisoha, ɓa eɗta ɗe, a fiissa nga ne : « A teeku Yahya. » Ɓooɓa jen feyuusa. ");
INSERT INTO sav_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ŋ ɗiska ɗiska, Sakariya minissa jomb, a woyeeɗa baahkiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɓooɓa genee na ɗe feyuusa ŋ ina raake, ɓa laamtoheeɗaa ŋ kur caŋ tangoocaŋ Yudee jen. ");
INSERT INTO sav_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hatiliŋ Heɗ ɓoo hunee na kuɓka, tahha po, ɓa kerhee naandsukaŋ ineem jen, ɓa liiɓeeɗa an : « Kuɓkii joy ye nik ? » ");
INSERT INTO sav_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Baabiŋ kuɓki, Sakariya, wa a kaɗ po a minissa jomb, Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh riiffa ɗe, a woyeeɗa woo ci puloh ŋ Kooh an : ");
INSERT INTO sav_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Heɗ ɓoo Koohiŋ Israayel ƴeekaah ŋ ini a hirip ɓooɓiŋ ɗe, a muciɗta ɓa. ");
INSERT INTO sav_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A komiɗ ɓoo Mucɗoh raakiɗ hatil ŋ cuuɓiŋ ñaamiŋ ɗe Dawuuda, ");
INSERT INTO sav_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","findi a gapohee wa maañiɗ, a taambiɗtaa ŋ nguɓ caŋ woosuuɗ caŋ ɗe, te ɓa jen ɓa hooliɗ, ");
INSERT INTO sav_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ne a hey ɓoo saɓsohe na sangiɗ ciŋ ɓoo, a muciɗ ɓoo ŋ yaah ciŋ ɓi sang ɓoo jen. ");
INSERT INTO sav_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A teeɓ caac ciŋ ɓoo baahkiŋ ɗe, a naandsuk ambtiɗohiŋ ɗe hool, ");
INSERT INTO sav_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","findi a giñɗohee wa caac ɓoo Ibrahiima, ");
INSERT INTO sav_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ne a hey ɓoo pulɗe ŋ ɓi sang ɓoo, po ɓoo ñaamkee ɗe te ɓoo neƴƴohanɗi, ");
INSERT INTO sav_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ɓoo nikan ɓo' hooliɗ, yurhiɗ ŋ fikiice ŋ kipes kiŋ ɓoo jen. ");
INSERT INTO sav_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te fu kuɓu, fu nikan woosuuɗiŋ Kooh yi ŋ ɗafka ɗafka, laam, a fu adgan, fu paɗiɗ Heɗ ɓoo waasiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fu inhiɗ ɓooɓiŋ ɗe ne, ɓa hey ɗaasse bakaaɗ ciŋ ɓa, ɓa muc. ");
INSERT INTO sav_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Laam, Koohiŋ ɓoo keeñkohiɗ ɓoo te a baahiɗ. Weɗi tah, a hey ɓoo woosohe siñaari na hee pulohe ŋ ɗafki, mand na nohi na hane pul, ");
INSERT INTO sav_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ne wa siñaariɗ ɓoo, ɗiski ɓoo ɓoof ŋ ñuusiŋ kakaan ki, a deg ɓoo ŋ waas jam. » ");
INSERT INTO sav_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ŋ ineem, njaanja yakeeɗa, liiɓiŋ ɗe ɓaatkeeɗa, a gennda ŋ nduufa po wa a teeɓ Israayel ci haf ce. ");
INSERT INTO sav_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ŋ jamanoocaam, buura yakkaŋ Rom teeksee Ogis nakohha ne tiik caŋ ɓooɓa jen fiissaat. ");
INSERT INTO sav_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Fiisiŋ tiik ceem nikka wa koc, wa hendee ŋ jamanoona Kiriñus nikoh goornooraŋ Siri. ");
INSERT INTO sav_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ŋ ineem, yaa nu nga ɗah, kaɗeeɗa ne a fiisu ŋ kur ka a cosaankoh. ");
INSERT INTO sav_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Suseef nammba puloh kur ka na woyse Nasareet ŋ Galile, a kaɗta Betlehem ŋ Yudee, kur ɓi Dawuuda laam a ɓaahee ŋ ɓi rimkoh nga ɗe. ");
INSERT INTO sav_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A kaɗta bindka na ɓitiice Maryaama tel ɗe rook. ");
INSERT INTO sav_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Noha a joy ɓasloh raak ɓa reyiɗ Betlehem, ");
INSERT INTO sav_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","a ɓasilla kuɓu ƴaar saawiŋ ɗe, a lemessa ɗe ŋ daah. Ina ɓa haɓeeɗi ŋ dalohaanaŋ hanheeca, tahha po a faannda ɗe ŋ ñamohaanaŋ ɗoopaat ca. ");
INSERT INTO sav_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ŋ bilaf faŋ kur ka, ɓi niiɗoh meeɗeen neeh nga ne ɓa taambkoh ɗoopaat caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaaka teeɓukka ɓa, siñaariŋ Heɗ ɓoo yipukka nga ɓa, ɓa feyuusa lool. ");
INSERT INTO sav_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Waaye malaakaana woosa ɓa ne : « Kinaat neƴƴoh, ŋ kom ɗu woo neɓiɗ wi fu inah ne ɓooɓi jen hey sume nga keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Woti ŋ kur ɓi Dawuuda, Mucɗoh wuu ɗu rimkiɗ nga ; a yi Kiristaani, weɗ Heɗ ɓoo, Mucɗohi Kooh gapohe. ");
INSERT INTO sav_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inii weɗ na hee ɗu wa teeɓe : Ɗu hey hote kuɓu lemesuuɗ ŋ daah, a faanu ŋ ñamoha ɗoopaat. » ");
INSERT INTO sav_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɗekka po, mboolo malaaka laayoh na laayoh nikka na ya koc ŋ ɗiska, ca ƴeekeeɗa Kooh an : ");
INSERT INTO sav_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Yakkiŋ Kooh ƴeekaah ŋ ɗiska uup ɗafuk ŋ Eel ca te ɓooɓi neɓ ɗe, ɓa raakaat jam ŋ kehƴi. » ");
INSERT INTO sav_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wa malaakaaca faɗ ɓa ndaam, dokukka Eel ca, niiɗoh ca woosa ŋ harmban ɓa ne : « Ɓoo kaɗaat Betlehem, marka ini raak nga, wi Heɗ ɓoo woo. » ");
INSERT INTO sav_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓa arra kaɗ, ɓa raakka Maryaama na Suseef nga na kuɓka faanuuɗ ŋ ñamoha ɗoopaat. ");
INSERT INTO sav_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wa ɓa hot kuɓka, ɓa naandsukka ɓooɓa ini ɓa woyu nga ɗe. ");
INSERT INTO sav_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɓooɓa kerah naandsukaŋ niiɗoh ca jen feyuusa. ");
INSERT INTO sav_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ŋ ini kaɗ ŋ Maryaama, a ammba woo ceem jen ŋ hafiŋ ɗe, a markiseeɗa ca ŋ ɗooƴ ce. ");
INSERT INTO sav_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Niiɗoh ca dokkeeɗa, ɓa ƴeekeeɗa yakkiŋ Kooh, ŋ ina ɓa kerah te ɓa hottaa laam wa raakoh ɗaa findi ɓa woyohsee wa. ");
INSERT INTO sav_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wa mbeha Maryaama ɓasloh dokuk, kuɓka nguɗukka ; ɓa teekka ɗe Yeesu, tiika malaakaana eɗohee bala yaay ɓa amban rook. ");
INSERT INTO sav_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wa neeh ca ɓa farsukohee reeh findi waasiŋMusaa nakoha, ɓa ɓayya kuɓka Yerusalem ne ɓa eɗ ɗe Heɗ ɓoo. ");
INSERT INTO sav_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Laam, ŋ waasiŋ Heɗ ɓoo, wa fiisuuɗ ne : « Komaaki saaw ƴaar nu nik ɗah, Heɗ ɓoo hey ɗe waɗse. » ");
INSERT INTO sav_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓa nammba seeƴuk ne Maryaama hool findi wa nakohu ŋ waasiŋ Heɗ ɓoo : hoɗ kanak mbaa banuut ƴin kanak. ");
INSERT INTO sav_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ŋ Yerusalem, raakiɗ ƴaara teeksee Simeyong nga, a nikee ƴaar yurhiɗ te a kerhiɗta Kooh, a nikee sekeeɗa mbehi Israayel hirpohsan. Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh nikee na Simeyong. ");
INSERT INTO sav_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A teeɓeen ɗe ne bala a kaanan ɗah, a hey hote Mucɗohi Gapohse Heɗ ɓoo woos. ");
INSERT INTO sav_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Fuuɗsi Hoolohngaani hiirra ɗe ŋ kaɗ Kahan Kooh, raak Maryaama na Suseef ɓayiɗ Yeesu ne ɓa wik ɗe Kooh findi waasiŋ Musaa nakoha. ");
INSERT INTO sav_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyong ammba gooya, a yakiɗta Kooh, an : ");
INSERT INTO sav_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Ɗiski wa nik ndii Heɗ ɓoo, fu miniɗ faɗ ñaamiŋ ɗa a coot ŋ jam. Fu haɓɗiɗ ini fu gapohee, ");
INSERT INTO sav_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","laam, na has ciŋ ngo, ŋ hotootiɗ Mucɗohi puloh nga ɗa ");
INSERT INTO sav_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yi fu kooɗkiɗ ɓooɓi jen ");
INSERT INTO sav_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","a nikka ñiini na hee ɗa teeɓohe ŋ cuuɓ ci jen, te a yi ndamiŋ Israayel, cuuɓiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baabiŋ kuɓki na yaay ɓa feyuusa ŋ in ci Simeyong woo nga ɗe, ");
INSERT INTO sav_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyong barke'iɗta ɓa, a hannda woo Maryaama, yaayi ne : « Kuɓkii hay ne, ɓi ɓo' laayiɗ ŋ Israayel keen, laayiɗ kuruk. A hey nike firndeeni na hee taasse. ");
INSERT INTO sav_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ŋ ineem, liiɓ ci ɓo' laayiɗ ɗasiɗ ŋ ɗooƴ ɓa hey teeɓohse. Te fu Maryaama, fu hey raake miskiɗ findi ɓoyi yipu salma ŋ keeñ. » ");
INSERT INTO sav_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wa nameen raak woosuuɗ ɓitiɓ teeku Aana, a nikee kuɓu Fanuwel yi ɓaahee ŋ cuuɓiŋ Aser. A ɓitfeen lool ; wa kilookiŋ ɗe coot, a pesiɗ kiis yasna-kanak na ƴaar ce, yeem kaannda, ");
INSERT INTO sav_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a rissa raakaaɗi ƴaar. A raakee kiis ndaŋkiyaah-yasna-kaahay na kiis nikiis (84). A meeɗɗi kurkoh ŋ Kahnaŋ Kooh, a oreeɗa, a kiimeeɗa Kooh noh na wek ; a nikiɗohee ɗe ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A maasoheen wa Simeyong na woye, a nammba gidim Kooh, a woyeeɗa ɓooɓa seke faɗsuukiŋ Yerusalem jen ini kaɗ ŋ kuɓka. ");
INSERT INTO sav_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wa Suseef na Maryaama ƴut haɓiɗ in ci waasiŋ Heɗ ɓoo nakoh jen, ɓa dokukka Galile, ŋ kur ɓa wi na woyse Nasareet. ");
INSERT INTO sav_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kuɓka yakeeɗa, a ndengeeɗa, a ɓaateeɗa raak liiɓohaaɗ moɗiɗ te Kooh hunnda na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kiis nu ree ɗah, Maryaama na Suseef kaɗ Yerusalem ne ɓa maasoh Paak ci, mbeh ci ɓa na naandsukohe pulohaŋ Israayel ci Misra. ");
INSERT INTO sav_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wa Yeesu raak kiis ndaŋkiyaah na kiis kanak (12), a kaɗta na ɓa findi wa na tumohse. ");
INSERT INTO sav_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wa hewa reeh, ɓa haadeeɗa, waaye a yi Yeesu, a tassa ŋ Yerusalem. Yaay ɓa na baab ɓa yegɗi. ");
INSERT INTO sav_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓa liiɓpa haa ne a yaa ŋ huntoh caŋ ɓa ɓinooɓa, ɓa tiinnda ini ree noh mulnguus, ɓa hotɗi ɗe. Ɓa marakka ɗe ŋ nawleecaŋ ɓa na ɓaah caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ɓa hotɗi ɗe, ɓa dokukka, ɓa waakeeɗa ɗe po ŋ ɗooƴ Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ŋ mbeha kaahayɗoh, ɓa raakka ɗe ɓoofiɗ ŋ ɗooƴ Kahan Kooh ŋ leernaŋ jangɗohoh ca ; a sikɗukeeɗa ɓa, a nameeɗa ɓa meekis. ");
INSERT INTO sav_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓooɓa kerhee ɗe jen feyuusa ŋ neɓkiŋ ɗe hel, na findi a lofohee ɓa. ");
INSERT INTO sav_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wa yaay ɓa na baab ɓa hot ɗe, ɓa feyuusa. Yaay ɓa woosa ɗe ne : « Kuɓkiŋ ngo wa ye tah, fu haɓiɗta ɓoo inii ? Mi na baab ɗu, ɓoo feysee feyu, ɓoo ɓii waak ɗa poyi. » ");
INSERT INTO sav_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A loffa ɓa ne : « Wa ye tah ɗu waakeeɗa so ? Hanaa ɗu inahɗi ne, ŋ joy nik ŋ Kahan Baabiŋ ngo ? » ");
INSERT INTO sav_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Waaye ɓa inahɗi ini a woo ɓa. ");
INSERT INTO sav_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ŋ ineem Yeesu hunnda na ɓa, ɓa dokukka kur ka na woyse Nasareet. Ŋ ineem, a kerhiɗeen ɓa, yaay ɓa ammba in ceem jen ŋ hafiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesu yakeeɗa, a uupeeɗa uup raak liiɓohaaɗ moɗiɗ, a neɓpa ɓooɓa, a neɓpa Kooh. ");
INSERT INTO sav_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wa nikee ŋ jamanoonaŋ buura yakkaŋ Rom na woyse Tibeer, wa a tum kiis ndaŋkiyaah na kiis yatuus (15) ŋ hafaŋ kur ka, waam a Ponse Pilaat nikee goornooraŋ Yudee, Herod adgohha Galile, Filip taambɗoh ce adgohha Iture na Tarakonit, Lisañas adgohha Abileen ; ");
INSERT INTO sav_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hannas na Kayif nikka seeƴkiɗoh ca yakak ca. Ŋ kiis kaam, Kooh dengkohha kuɓkiŋ Sakariya na woyse Yahya woo kiŋ ɗe, raak ɗe genee nduufa. ");
INSERT INTO sav_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yahya wileeɗa ŋ ɓakaŋ kalaŋ Yurdan jen, a inhiɗeeɗa ɓa ne ɓa hayaat ɓa ɓoktuk, wa teeɓoh ne ɓa teyiɗ ɓoƴsoh pesohaaɗ, ɓa min ɗaasu bakaaɗ ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wa raakohha ɗaa findi wa fiisohu ŋ teerndiŋ woosuuɗi Esayi an : « Hooso wa ɗaa leehuk ŋ nduufa ne : “ Haɓɗaat waasiŋ Heɗ ɓoo, haɓɗiɗaat ɗe waas ciŋ ɗe jen, ca yurah. ");
INSERT INTO sav_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Oon ci jen hey uumbse, tangooci na tund ci jen hey girtasse, waas ci nduuɗkiɗ ci hey yurhiɗasse te ci raak atoh hey luhtasse. ");
INSERT INTO sav_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ɓooɓi jen hey hote findi Kooh na mucɗohohe. ” » ");
INSERT INTO sav_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɓo' laayiɗ hayeeɗa ŋ Yahya Ɓoktohi ne a ɓokit ɓa, a woosa ɓa ne : « Ini ɗu añaand haa ne iiñ jen, ɗu liiɓiɗ ne ɗu miniɗ penduk ayrukiŋ Kooh wi na haye e ? ");
INSERT INTO sav_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tumohaaɗ ciŋ ɗu baahaat, wa teeɓoh ne ɗu ɓoƴsohiɗ pesohaaɗ, te kinaat ɗaar rek ɗu woyee ŋ ɗooƴ ɗu ne “ Ɓoo rimkoh ŋ Ibrahiima. ” Ñam na woyee ɗu ne atoh cii, Kooh miniɗ pulɗiɗ Ibrahiima kuɓu nga ca. ");
INSERT INTO sav_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ɗiski wa nik ndii, kiw ki ƴutiɗ ne wa giing tas kidig, te waa nu raakɗi rim baahiɗ ɗah, wa hey ƴoɓse wa njafu ŋ yongkaaha. » ");
INSERT INTO sav_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɓooɓa meekseeɗa Yahya ne : « Ɓoo tuman na ? » ");
INSERT INTO sav_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A loffa ɓa ne : « Ɓo' nu raak kulɓa kanak ɗah, eɗa ɓoyi raakɗi winoori, te ɓo' nu nam raak kañam ɗah, paysohaa na ɓoyi raakɗi. » ");
INSERT INTO sav_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɓi juuti'oh nammba hay nga ɗe ne ɓa ɓoktu, ɓa meekissa ɗe ne : « Ɓoo joy ye haɓiɗ Jangɗohohi ? » ");
INSERT INTO sav_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A woosa ɓa ne : « Kanaat ɓaat tus ŋ ini ɗu naku. » ");
INSERT INTO sav_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɓi soldaar hayya nga ɗe, ɓa woosa ɗe ne : « Moo ! Ɓoo joy ye haɓiɗ ? » A woosa ɓa ne : « Kinaat ɓay kopor ɓo' ŋ naafiɗ wala ŋ lee ; topaat ŋ ini ɗu na wirndasse. » ");
INSERT INTO sav_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓooɓa nikee sekeeɗa Mucɗohi Gapohse sek keeh-keeh, yaa nu nga woyeeɗa ŋ ɗooƴ ce ne : « Andi e Yahya Mucɗohi Kooh gapohe ? » ");
INSERT INTO sav_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahya loffa ɓa jen ne : « Mi na ɓoktee ɗu na masuɓ, waaye raakiɗ ɓoyi na haye yi uup po nik kilifa, te ŋ yeyyooɗi nik ñaamiŋ ɗe ne ŋ toksiɗee ɗe ñafaɗ ciŋ ɗe. A yi, a ɓoktohan ɗu Fuuɗsi Hoolohngaani, na yongkaah. ");
INSERT INTO sav_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A amb saliŋ ɗe ŋ yaah, ne a nistoh pees na fuñind. A nangɗoh pees ci ŋ ndapiŋ ɗe, a doh fuñndi ŋ yongkaahi heyɗi ƴime. » ");
INSERT INTO sav_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahya ñaaheeɗa ɓooɓa ŋ inaa laayiɗ ne a woo ɓa Yegɗohiŋ Muci. ");
INSERT INTO sav_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ŋ mirndaani, Yahya woytohha Herod ya adgoh Galile ŋ ini a kooɗ Herojaad, yi ɓiti taambɗoh ce, na in ca moɗaaɗiica wiiriis ca a tumee jen. ");
INSERT INTO sav_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod taƴɗukka Yahya ŋ kasoona, ɓaatta ŋ in ca moɗaaɗiica a tume. ");
INSERT INTO sav_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ŋ jamanoona Yahya ɓoktohee ɓooɓa jen, Yeesu nammba ɓoktu. Wa a na kiime Kooh, Eel ci rangsukka, ");
INSERT INTO sav_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh yipukka nga ɗe, ŋ mandohaaɗ banuut. Hooso kerhukka ŋ Eel ci an : « A fu kuɓkiŋ ngo ŋ waaɗ keeh-keeh te ŋ neɓuuɗ nga ɗa lool. » ");
INSERT INTO sav_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wa Yeesu na cambe pangkaŋ ɗe raak ɗe ŋ ɓak kiis ndaŋkiyaah-kaahay (30). Ɓooɓa ammba ne a kuɓu Suseef. Suseef, a Heeli rim ɗe, ");
INSERT INTO sav_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heeli a kuɓu Matat, Matat nikka kuɓu Lewi, Lewi a yiŋ Melki, Melki nikka yiŋ Yanayi, Yanayi yiŋ Suseef, ");
INSERT INTO sav_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Suseef Matacas, Matacas Amos, Amos Nahum, Nahum Esli, Esli Nagayi, ");
INSERT INTO sav_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi Maat, Maat Matacas, Matacas Semeyin, Semeyin Yosek, Yosek Yoda, ");
INSERT INTO sav_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda Yowanan, Yowanan Resa, Resa Sorobabel, Sorobabel Salacel, Salacel Neri, ");
INSERT INTO sav_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melki, Melki Adi, Adi Kosam, Kosam Elmadam, Elmadam Er, ");
INSERT INTO sav_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Yeesu, Yeesu Eliyeser, Eliyeser Yorim, Yorim Matat, Matat Lewi, ");
INSERT INTO sav_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi Simeyong, Simeyong Yudaa, Yudaa Suseef, Suseef Yonam, Yonam Eliyakim, ");
INSERT INTO sav_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim Meleya, Meleya Menna, Menna Matata, Matata Natan, Natan Dawuuda, ");
INSERT INTO sav_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuuda Yesay, Yesay Obed, Obed Boos, Boos Salmon, Salmon Nahson, ");
INSERT INTO sav_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahson Aminadaab, Aminadaab Admin, Admin Arni, Arni Hesroon, Hesroon Peeres, Peeres Yudaa, ");
INSERT INTO sav_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudaa Yaŋhooɓa, Yaŋhooɓa Isaahha, Isaahha Ibrahiima, Ibrahiima Tera, Tera Nahor, ");
INSERT INTO sav_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serug, Serug Reyu, Reyu Peleg, Peleg Eber, Eber Selah, ");
INSERT INTO sav_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selah Kaynan, Kaynan Arpaksad, Arpaksad Sem, Sem Noohin, Noohin Lemek, ");
INSERT INTO sav_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek Matusalem, Matusalem Henok, Henok Yered, Yered Mahalal'el, Mahalal'el Kenan, ");
INSERT INTO sav_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enos, Enos Set, Set Aadama, Aadama yi Kooh fer. ");
INSERT INTO sav_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Wa Yeesu puloh kalaŋ Yurdan, raak Fuuɗsi Hoolohngaani, Fuuɗsiŋ Kooh riifiɗ ɗe. Fuuɗseem kaɗɗukohhaa ɗe nduufa. ");
INSERT INTO sav_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A nikka nga neeh ndaŋkiyaah-nikiis (40), ndaam, Seytaani fiireeɗa ɗe. A ñamɗi ŋ neeh ceem, ŋ mirndaani a aɗukka. ");
INSERT INTO sav_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Weɗi Seytaani woyoh ɗe ne : « Nik ne fu Kuɓkiŋ Kooh ɗah, woya atoh fii wa ɓoƴsuk mbuuru. » ");
INSERT INTO sav_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu loffa ɗe ne : « Fiis ci Hooliɗ ci woyiɗ ne : “ Ɓo' na pesohe mbuuru dong haa. ” » ");
INSERT INTO sav_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seytaani ɓayya ɗe ŋ ɗiska uup ɗafuk, a teeɓpa ɗe, ŋ harmban ñep na marak, nguur ciŋ adinaani jen. ");
INSERT INTO sav_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A woosa ɗe ne : « Nguur cii jen na ini ŋ ɗooƴ ca degu ŋ yaah ciŋ ngo te ŋ miniɗ ca eɗ ɓoyi neɓ po. ");
INSERT INTO sav_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fu teyɗuk ƴek ŋ fikiiso ɗah, ŋ hey ɗa ca one jen. » ");
INSERT INTO sav_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu loffa ɗe ne : « Fiis ci woo ne “ Ƴekɗa Kooh Heɗ fu, te fu ñaamuk a yi dong. ” » ");
INSERT INTO sav_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seytaani ɓayissa ɗe Yerusalem, ŋ jol Kahnaŋ Kooh, a woosa ɗe ne : « Nik ne fu Kuɓkiŋ Kooh ɗah, faɗsuka ŋ kehƴi ; ");
INSERT INTO sav_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Fiis ci Hooliɗ ci woyiɗ ne : “ Kooh hey nake malaakaaciŋ ɗe, ca niiɗ ɗa. ” ");
INSERT INTO sav_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Te : “ Ca ɓay ɗa ŋ yaah ciŋ ca, po kot ciŋ ɗa laɓkanɗi ŋ atoh. ” » ");
INSERT INTO sav_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu nammba ɗe lof ne : « Fiis ci namiɗ woo ne : “ Kana markisuk Kooh Heɗ fu. ” » ");
INSERT INTO sav_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wa Seytaani jaɗiɗ ɗe fiir po a miniɗɗi ɗe in, a cootta, a sekɗoheeɗa ɗe mbeh wiiriis. ");
INSERT INTO sav_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A Yeesu dokuk Galile kotii, raak ɗe riifiɗ na doolndiŋ Fuuɗsi Hoolohngaani. Ɓooɓa laamtoheeɗa ɗe ŋ kur caam jen, ");
INSERT INTO sav_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","a jangɗoheeɗa ŋ sinaagog ca, ɓooɓa jen laaskeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A aaseeɗa, a puleeɗa kur ca po a reesa ŋ Nasareet, kur ka a yakoh. Wa mbehi na iɗsiɗkohse ree, a aassa ŋ sinaagoga findi a meeɗa tumoh, a kurukka ne a jang ini fiisu. ");
INSERT INTO sav_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɓa eɗta ɗe teerndiŋ woosuuɗi na woyse Esayi, a puliɗta ɗiski inii fiisu : ");
INSERT INTO sav_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Fuuɗsiŋ Heɗ ɓoo yii nga so, laam a yi kooɗ to ne ŋ kom ñakiɗ ci Yegɗohiŋ Muci, a yi woos so ne ŋ woo ambuuɗ ci faɗsuukiŋ ɓa, ŋ woo fuuliɗ ci ne ɓa hey hote te ŋ nam puliɗ torhiɗuuɗ ci ŋ miskiɗiŋ ɓa, ");
INSERT INTO sav_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ŋ yegɗoh ne kiis kii, weɗ kiis ki Heɗ ɓoo teeɓohan baahkiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wa Yeesu ƴut, a lemmba teernda, a dokinndaa ƴaara na ɗaakee wa, a ɓooffa ne a woo ; ɓooɓa nikee ŋ sinaagoga jen yurhiɗkohha na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A woosa ɓa ne : « Ini Fiis ci woyee wii te ɗu kerahhaa, wa raakiɗ woti. » ");
INSERT INTO sav_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓooɓa jen woyeeɗa in baahiɗ nga ɗe, ɓa feyuusa ŋ woo ca neɓiɗ ca a woo. Ɓa weeɗa ne : « Ƴaarii a kuɓu Suseef haa e ? » ");
INSERT INTO sav_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu woosa ɓa ne : « Ŋ inhiɗ ne ɗu hey yo woye woo kii : “ Paƴohi, paƴa haf fu. Ɓoo kerhiɗ in ca fu tum ŋ Kapernawum jen, tuma mand ɗaa ndii, ŋ kur ki fu genoh. ” » ");
INSERT INTO sav_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeesu degiɗta ɓa nga ne : « Ñam na woyee ɗu wa te wa keeh : Ali woosuuɗ na teyɗukseeɗi ŋ kur ka a genoh. ");
INSERT INTO sav_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɗu inhiɗ ne ŋ jamanoonaŋ woosuuɗi Ilyas, wa Kooh toɓɗi kiis kaahay na camban te aɗ miskiɗ raakka ŋ kur ka jen, wa raak ɓitiɓ laayiɗ ŋ Israayel ƴaar caŋ ɓa kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Moona Kooh tuuƴɗi Ilyas ŋ ali ɓitiɓ nga ɓa, waaye a tuuƴ ɗe ŋ ɓitɓa ƴaar ce nam kaan ya genee Sarepta ŋ kur kaŋ Sidoon. ");
INSERT INTO sav_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te ŋ jamanoonaŋ woosuuɗi na woyse Elise, ɓo' laayiɗ raakeen kosaay ki na oɓse faan ŋ Israayel, moona ali ɓo' wirɗuuɗi nga ɓa, waaye a Naaman ya genee Siri, a yi wirɗu. » ");
INSERT INTO sav_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wa ɓa kerah woo ceem, ɓooɓa nikee ŋ sinaagoga jen ayrukka po ɓa heeɗa pooke. ");
INSERT INTO sav_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓa kurukka, ɓa puliɗta ɗe kur ka, ɓa ɓayya ɗe ŋ suunaŋ tangoora ɓa yipohee kur kaŋ ɓa ne ɓa yeñ ɗe a kaan ");
INSERT INTO sav_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","waaye a lahha ŋ harmban ɓa, a cootta waas ce. ");
INSERT INTO sav_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeesu kaɗeeɗa po a reesa kur wiiriis ŋ Galile na woyse Kapernawum ; a jangɗeeɗa ɓooɓa ŋ mbehi na iɗsiɗkohse. ");
INSERT INTO sav_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A woyee woo kilifa, tahha po, ɓa feyuusa ŋ jangɗohiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ŋ ɗooƴ sinaagoga, wa raakeen ƴaara jiini ambe, a leehkeeɗa ŋ ɗafka an : ");
INSERT INTO sav_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Hee ! Yeesu yiŋ Nasareet, waas fu ye nga ɓoo ? Fu hay ne fu yah ɓoo e ? Ŋ inhiɗ ɓoyi fu nikoh ; a fu Ɓoyi Hooliɗi Kooh woos. » ");
INSERT INTO sav_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu ngassa ɗe an : « Ɗeka, te fu pul ngaŋ ƴaari ! » Jiinnda folla ƴaara ŋ fiki ɓooɓa waaye a tumɗi ɗe in, a pulla nga ɗe. ");
INSERT INTO sav_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wa ineem raak, ɓooɓa jen feyuusa, ɓa woyeeɗa ŋ harmban ɓa an : « Cey, woo kiŋ ƴaarii wa woo ye ? Wa hun na hatil, jiiniici sah na hoolaaɗiiki ca hoolaaɗi, ca kerhiɗiɗ ɗe po a woo ca ne pulaat ɗah, ca saandohe ! » ");
INSERT INTO sav_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɓa laamtoheeɗa Yeesu, ŋ ɗisik nu nik ŋ kur caam jen. ");
INSERT INTO sav_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wa Yeesu puloh sinaagoga, a kaɗta kahan Simong tel yaayiŋ ɓiti Simong kosaayiɗ po faaniŋ ɗe nikka dohiɗ jip. Ɓa kiimmba Yeesu ne a wiriɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A hiirra nga ɗe, a ngassa kosaay ka, wa saɓsukohha na ɗe. Ŋ ɗiska ɗiska a kurukka, po a taambkoheeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wa noha muy, ɓa raakee kosaayiɗ jen hayya ŋ Yeesu na ɓi jangaaro ɗalohiɗ, a degga yaa nu nga ɗah yaah ciŋ ɗe, yaa nu a degga yaah ciŋ ɗe ɗah, yeem wir. ");
INSERT INTO sav_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɓi jiini puloheeɗa ŋ kosaayiɗ laayiɗ, ca leehkeeɗa ne : « Fu Kuɓkiŋ Kooh ! » Ca inheen ne a yi Mucɗohi Gapohse, tahha po a ngasukka ca, a faɗɗi ca ne ca woo. ");
INSERT INTO sav_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wa Kooh wiis, Yeesu pulla kur ka, a kaɗta ŋ ɗisik ɗaayiɗ, ɓi ɓo' laayiɗ waakeeɗa ɗe. Wa ɓa hot ɗe, ɓa waaɗta ɗe amb ne a cootuu. ");
INSERT INTO sav_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Waaye a woosa ɓa ne : « Ŋ joyiɗ nam ɓay Yegɗohiŋ Muci, wiŋ Nguuriŋ-Kooh, ŋ kur ci cinooci, ineem weɗ tah ho woosu. » ");
INSERT INTO sav_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A taalndiɗta, a yegɗoheeɗaa ŋ sinaagog caŋ kur caŋ Yudee. ");
INSERT INTO sav_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wa raakka mbeh, Yeesu nikka ŋ sereendaŋ Cookmaŋ-Senesaret, ɓi ɓo' laayiɗ ndeerra ɗe, ɓa baɓkoheeɗa ne ɓa min sikɗuk woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yeesu hotta gaal kanak ŋ sereendaŋ cookma, waam raak seeɓoh ca ruhsiɗ ŋ gaal ca po ɓa naawseeɗa mbaal caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A rappa ŋ waŋ Simong, a woosa ɗe ne : « Yeña gaali ŋ ɗooƴ masmi ƴissuut. » Simong yennjaa, Yeesu ɓooffa nga, a jangɗeeɗa ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wa a ƴut ɓa jangiɗ, a woosa Simong ne : « Kaɗa na gaali po ɗiska cookmi nooɗoh, ɗu njaf mbaal ciŋ ɗu, ɗu seeɓ. » ");
INSERT INTO sav_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simong loffa ɗe ne : « Kilifaani, niinma ɓoo neeh seeɓ te ali cuurund ɓoo ambɗi waaye, ŋ hey njafe mbaal ci. » ");
INSERT INTO sav_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wa ɓa njaf ca, ɓa ammba cuurund laayiɗ po mbaal ca faarkeeɗa. ");
INSERT INTO sav_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ŋ ineem, ɓa kaayilla huntoh caŋ ɓa nikee ŋ gaala winoora yaah, ne ɓeem hay ɓa ɓaatɗohe. Ɓa hayya, ɓa siffa gaal ca kanak ca jen cuurund po ca diigeeɗa. ");
INSERT INTO sav_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wa Simong Piyeer hot ŋ ineem, a ƴekka ŋ fiki Yeesu a woosa ne : « Us so kilifaani, ŋ bakaaɗoh. » ");
INSERT INTO sav_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A feyse feyu a yi na ɓooɓa a hunee na ɓa jen sagu cuurund ca ɓa amb. ");
INSERT INTO sav_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Huntoh caŋ ɗe Saak na Saaŋ, kuɓuuciŋ Sebede, nammba feyu. Yeesu woosa Simong ne : « Kana tiit, ini amboh woti fu seeɓan ɓo' kotii. » ");
INSERT INTO sav_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wa ɓa puliɗ gaal caŋ ɓa ŋ sereendaŋ cookma, ɓa faɗta in caŋ ɓa jen, ɓa ñaakiɗta Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wa raakka mbeh, Yeesu nikka ŋ kur, raak ƴaar yaa nga, a ambohee kosaay ki na oɓse faan po faaniŋ ɗe jen yahrukohha. A hot hot Yeesu rek, a ƴekka po pukiŋ ɗe reesa kehƴi, a kiimmba ɗe an : « Kilifaani, fu waaɗa ɗah, fu miniɗ to saɓsoh na kosaay kii po ŋ nik ɓo' hooliɗ. » ");
INSERT INTO sav_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu raɗissa yaah, a degga ɗe wa, a woosa ne : « Ŋ waaɗiɗa, hoola ! » Ŋ ɗiska ɗiska kosaay kaŋ ƴaara saɓsukohha na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu nakka ɗe ne a kinaata woo ali ɓo', a woosa ɗe ne : « Kaɗa fu teeɓa haf fu seeƴkiɗoha, fu haɓiɗ seeƴki waasiŋMusaa nakoh ne fu hool, wa teeɓoh ne fu wiriɗ. » ");
INSERT INTO sav_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tiikiŋ Yeesu uupeeɗa nga kerhu, ɓi ɓo' laayiɗ hayeeɗa nga ɗe ne ɓa sikɗuk ɗe te ɓa wir ŋ kosaay caŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ini kaɗ ŋ Yeesu, a meeɗeen ɗaay ŋ nduufa, a kiimee Kooh nga. ");
INSERT INTO sav_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wa raakka mbeh, Yeesu jangɗoheeɗa. Ɓi ɓo' ɓaahee ŋ Farisen ca na ɓi ɓo' ɓaah ŋ jangɗohoh caŋ waasiŋ Musaa nikee nga. Ɓa pulohee kur caŋ Galile jen na caŋ Yudee na Yerusalem. Hatiliŋ Heɗ ɓoo huneen na Yeesu ne a wiriɗ kosaayiɗ ca. ");
INSERT INTO sav_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɓi ɓo' hayya, gaalɗohiɗ ƴaar ŋ faankoha. E kot ciŋ ɗe sange. Weɗ tahee ɓa ɓayeeɗa ɗe ŋ Yeesu, raak ɗe ŋ ɗooƴ taɓah. ");
INSERT INTO sav_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Waaye ɓa raakɗi ɗiski ɓa hee taambe sagu findi ɓooɓa laayohe. Ɓa rappa ŋ ɗafuk taɓaha, ɓa nihissa ŋ poon caŋ wa, ɓa yoorra ɗe ŋ ɗooƴ ɓooɓa ŋ fiki Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wa Yeesu hot ɓa na findi ɓa kosoh, a woosa ƴaara kosaayɗa ne : « Ƴaariŋ ngo, fu ɗaasuuɗ bakaaɗ ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jangɗohoh caŋ waasiŋ Musaa na Farisen ca woyeeɗa ŋ ɗooƴ ɓa ne : « Ƴaarii a yi ɓa po a ɗale Kooh mand an ? Ali ɓo' minɗi ɗaasoh bakaaɗ ɗal Kooh dong ! » ");
INSERT INTO sav_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Waaye Yeesu inahha ina ɓa liiɓee ŋ ɗooƴ ɓa, a woosa ɓa ne : « Wa ye tah ɗu liiɓee ineem ? ");
INSERT INTO sav_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ŋ woo ƴaarii ne : “ Fu ɗaasuuɗ bakaaɗ ciŋ ɗa ” wala ŋ woo ɗe ne : “ Kurka fu tiind. ” A winde uup yooɓ ? ");
INSERT INTO sav_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mbaa ŋ hey ɗu teeɓe ne Kuɓkiŋ ɓoyi raakiɗ doolndi a min ɗaasoh bakaaɗ ŋ kehƴi. » Yeesu woosa ƴaara lafñiɗa ne : « Ñam woo ɗa wa, kurka fu ɓay basngiŋ ɗa te fu haad. » ");
INSERT INTO sav_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ŋ fiki ɓooɓa jen ƴaara jaarra kuruk, a ɓayya faankohaanaŋ ɗe, a haadeeɗa, a yakɗeeɗa Kooh. ");
INSERT INTO sav_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓooɓa jen feyuusa ɓa yakɗeeɗa Kooh ; ɓa jaahiɗta, ɓa woyeeɗa ne : « Ɓoo hotiɗ in feyohiɗ woti. » ");
INSERT INTO sav_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wa Yeesu pul, a hotta juuti'oh teeku Lewi ɓoofiɗ ŋ ɗiska a na juuti'ohe. A woosa ɗe ne : « Ñaakiɗ to. » ");
INSERT INTO sav_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi kurukka, a faɗta in caŋ ɗe jen, a ñaakɗeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wa ɓa ree kahan Lewi, a tikɗukiɗta Yeesu kañam laayiɗ ndaam. Ɓi juuti'oh laayiɗ na ɓi ɓo' wiiriis ñameeɗa na ɓa. ");
INSERT INTO sav_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisen ca na jangɗohoh caŋ waasiŋ Musaa ñaɗtukeeɗa ŋ taalubeeciŋ Yeesu an : « Wa ye tah ɗu ñame, ɗu anee na juuti'oh ci na bakaaɗoh ci ɓinooɓi ? » ");
INSERT INTO sav_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu loffa ɓa ne : « Ɓooɓi kosaayɗi etohɗi paƴoh, e kosaayiɗ ci etoh paƴoh. ");
INSERT INTO sav_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ŋ hayɗi ne ŋ ɓeeɗuk ɓooɓi yurhiɗ ci waaye ŋ hay ne ŋ ɓeeɗuk bakaaɗoh ci, ɓa ɓoƴsoh pesohaaɗ. » ");
INSERT INTO sav_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓa woosa Yeesu ne : « Taalubeeciŋ Yahya Ɓoktohi na ɗeke po ɓa ore, ɓa kiimee Kooh findi ɓiŋ Farisen ci, waaye ɓiŋ ɗa deey, na ñamee ñam, ɓa ane. » ");
INSERT INTO sav_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A loffa ɓa ne : « Hanheeci hay kilook, ɓa hey orɗukohse te raak heɗ kilooki yii na ɓa e ? Wa minɗi nik ! ");
INSERT INTO sav_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Waaye wa hey raake jamano heɗ kilooki kooɗohu nga ɓa, ndeem, ɓa hey ore. » ");
INSERT INTO sav_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ŋ ineem Yeesu woosa ɓa andiini mandtiɗkohaanii : « Ali ɓo' na faareeɗi ŋ kulɓa as ne fu daaf kulɓa maañiɗ. Mbaa fu hey yahe kulɓaaki asi te seeketi fu na hee kooɗohe nga hunanɗi na kulɓaaki kiisɗi. ");
INSERT INTO sav_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te ali ɓo' na tumeeɗi biiñi asi na soñe ŋ mbohos und maañiɗ ; mbaa biiñi hey pooke mbohoseem, wa aamuk, mbohosi yahrukoh. ");
INSERT INTO sav_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Biiñ as joy tumu ŋ mbohos as. ");
INSERT INTO sav_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Waaye ɓo' nu an biiñ maañiɗ ɗah, fu heyɗi waaɗe biiñ as, laam fu na woyee ne : “ Wi maañɗi baahiɗ. ” » ");
INSERT INTO sav_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wa nikee ŋ mbehi na iɗsiɗkohse, Yeesu na taalubeeciŋ ɗe kaɗeeɗa, ɓa taammba ŋ yohon caŋ beleeca, taalubeeciŋ ɗe piikeeɗa nga ca, ɓa ɓorñeeɗa pees ca, ɓa ñameeɗa. ");
INSERT INTO sav_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ɓi Farisen hotta ɓa, woosa ɓa ne : « Ɗu na haɓɗe ini waasiŋ ɓoo sangoh ŋ mbehi na iɗsiɗkohse. » ");
INSERT INTO sav_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeesu loffa ɓa ne : « Mand haa ne ɗu moosɗi jangoh ina Dawuuda haɓɗee wa a aɗuk a yi na ɓooɓa hunee na ɗe ? ");
INSERT INTO sav_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A aas ŋ Kahan Kooh, a ɓayya mbuuruuca degsee ŋ taaɓla wuu Kooh, a ñammba nga ca, a nammba eɗ ɓooɓa hunee na ɗe, te ali ɓo' joyɗi ñam mbuuruuceem ɗal seeƴkiɗoh ci. » ");
INSERT INTO sav_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeesu degiɗta ɓa nga ne : « Kuɓkiŋ ɓoyi a yi Heɗ mbehi na iɗsiɗkohse. » ");
INSERT INTO sav_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wa raakissa jamano, ŋ mbehi na iɗsiɗkohse, Yeesu aassa ŋ sinaagoga, a jangɗoheeɗa. Wa raakeen ɓo' nga, yaahiŋ ɗe ñaahmi ɓeendkee ɓeenduk. ");
INSERT INTO sav_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jangɗohoh caŋ waasiŋMusaa na Farisen ca markiɗeeɗa Yeesu andi a hey wirɗohe ŋ mbehi na iɗsiɗkohse, ɓa raak yambaah ɗe. ");
INSERT INTO sav_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yeesu inhee inah ini ɓa liiɓee, tahha po a woosa ƴaara na yaaha ne : « Kurka fu tufuk ŋ fiki ɓooɓi jen. » Ƴaara tufukka ŋ fiki ɓooɓa. ");
INSERT INTO sav_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu woosa ɓa ne : « Ŋ meekis ɗu, wa ye teyɗohu ŋ mbehi na iɗsiɗkohse, in baahiɗ wala in baahaaɗi ? Ɓo' joy joy hirpu nga wala a joy joy apu ? » ");
INSERT INTO sav_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ŋ ineem, a marakka ɓa jen, a woosa ƴaara ne : « Raɗsa yaahiŋ ɗa. » Ƴaara raɗissa yaahiŋ ɗe, wa wirra peng. ");
INSERT INTO sav_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jangɗohoh caŋ waasiŋ Musaa na Farisen ca ayrukka po ɓa heeɗa kaane. Ɓa hotoheeɗa ŋ harmban ɓa ne ɓa marak findi ɓa joy tum Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ŋ neeh caam, Yeesu rappa ŋ ɗafuk tango ne a kiim Kooh ; a neehha kiim Kooh nga. ");
INSERT INTO sav_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na ɓaaɓa teel, a ɓeeɗukka taalubeeciŋ ɗe, a kooɗta nga ɓa ɓo' ndaŋkiyaah na kanak (12), a teekka ɓa \"Apootar\". ");
INSERT INTO sav_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ɓa nikee Simong yi a teekee Piyeer na Andare taambɗoh Simong na Saak na Saaŋ na Filip na Bartalemi ");
INSERT INTO sav_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Macce na Tomaa na Saak kuɓkiŋ Alfe na Simong yi teeksee Selot ");
INSERT INTO sav_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yudaa kuɓu Saak na Yudaa Iskaryot yi mirndoh nik woroh. ");
INSERT INTO sav_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wa a tan ɓa, a hunnda na ɓa, a ruhussa tangoora. A kaɗta po ŋ ɗisik angiɗ, raak ɓo' laayiɗ nga ɓaah ŋ taalubeeciŋ ɗe na ɓooɓa fu inah ne ɓa pulohee kur caŋ Yudee jen na Yerusalem, na kur ca huntiɗkohee na cookma ŋ ɓakaŋ Tiir na Sidoon. ");
INSERT INTO sav_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓooɓeem ɓa hayee ne ɓa sikɗuk Yeesu te ɓa wirɗu ŋ kosaay caŋ ɓa. Ɓa fu inah ne jiiniica na hoolaaɗiika ca hoolaaɗi, ca ambeen ɓa, ɓa wirra. ");
INSERT INTO sav_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓo' nu nga ɗah waaɗta ɗe laal sagu hatila pulohee nga ɗe wirɗeeɗa ɓa jen. ");
INSERT INTO sav_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Weɗi Yeesu yurhiɗkoh na taalubeeciŋ ɗe, a woosa ɓa ne : « Ɗu neɓɗiɗ, ɗu ɓi ñakiɗ ci, laam, Nguuriŋ-Kooh wa wuu ɗu. ");
INSERT INTO sav_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɗu neɓɗiɗ, ɗu ɓi aɗkiɗ ci woti, laam, ɗu hey kape nding. Ɗu neɓɗiɗ, ɗu ɓi na fuɗe woti, ɗu hey ƴene. ");
INSERT INTO sav_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ɗu neɓɗiɗ, ne ɓooɓi sang ɗu ɗah, ɓa aañee ɗu, ɓa ɓasee ɗu, te ɓa moɗaaɗiɗɗee tiik ciŋ ɗu sagu Kuɓkiŋ ɓoyi ɗah. ");
INSERT INTO sav_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wa ree ɗah, sumaat po ɗu mbece, laam aafi na sekee ɗu ŋ ɗafka yakiɗ te ɗu inah ne caacuuciŋ ɓa mbugalohee woosuuɗ ci ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mas, ɗu ɓi heɗ raak-raak ci laam ɗu rahsiɗ ini joy ɗu sumiɗ po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mas, ɗu ɓi kap woti, laam, kim ɗu hey aɗke. Mas, ɗu ɓi na ƴene woti, laam, ɗu hey nike ŋ tiis te ɗu hey fuɗe. ");
INSERT INTO sav_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mas, ne ɓooɓi jen woyɗee ɗu baahiɗ ɗah, laam caacuuciŋ ɓa meeɗ tumoh ɗaa na ɓi tumee haf ɓa woosuuɗ. » ");
INSERT INTO sav_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« Ɗu ɓi na sikɗukee so, ñam na woyee ɗu ne waaɗaat ɓooɓi sang ɗu, te ɗu tumɗee ɓa in baahiɗ. ");
INSERT INTO sav_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kiimɗaat barke ɓooɓi waaɗ ne ɗu alku, te ɗu kiimɗe ɓooɓi na torhiɗee ɗu in baahiɗ. ");
INSERT INTO sav_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ɓo' nu tip ɗa paɗ ŋ kaɓaaɓ ɗah, eɗaa ɗe wi tas. Ɓo' nu naaf paltooniŋ ɗa ɗah, kanaa ɗe sangoh kulɓaakiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɓo' nu kiim ɗa ɗah, onaa ɗe te ɓo' nu ɓay in ci fu raak ɗah, kinaa ɗe ca meekis. ");
INSERT INTO sav_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mbaa tumɗaat ɓooɓi in ci ɗu waaɗ ne ɓa haɓɗiɗ ɗu ca. ");
INSERT INTO sav_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɗu waaɗ ɓooɓi waaɗ ɗu dong ɗah, ɗu raak ye gidmaah ŋ ineem ? Bakaaɗoh ci sah waaɗiɗ ɓooɓi waaɗ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te ɗu haɓɗiɗee in moɗiɗ ɓooɓi na tumɗee ɗu baahiɗ ɗah, ɗu raak ye gidmaah nga ? Bakaaɗoh ci sah na tumohe ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te ɗu wotɗee dong ɓooɓi ɗu amb ne ɓa hey ɗu wirnde ɗah, gidmaah raakɗi ŋ ineem. Bakaaɗoh ci sah na wotɗe bakaaɗoh ci ne ɓa min rahas ini ɓa wotɗoh. ");
INSERT INTO sav_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Waaye waaɗaat ɓi sang ɗu, ɗu tumɗee ɓa in baahiɗ, ɗu wotɗohee te ɗu heelkuu wirind nga. Ŋ ineem aafiŋ ɗu hey yake te ɗu nikan ini ŋ moos ɗu teek, kuɓuuciŋ Kooh yi ŋ ɗafka ɗafka. Laam, a yi, a na teeɓohee teeɓoh baahkiŋ ɗe ŋ ɓooɓi añaandiɗ ci na corkiɗeeɗi ɗe. ");
INSERT INTO sav_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yirmohaat findi Kooh Baabiŋ ɗu na yirmohe. ");
INSERT INTO sav_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kinaat markoh ɓo' in, mbaa ɗu heyɗi markohse in te kinaat amboh ɓo' in, mbaa ɗu heyɗi ambohse in. Ɗaasohaat te ɗu hey ɗaasse. ");
INSERT INTO sav_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Onohaat te ɗu hey onse. Ɗu hey poonɗasse laayiɗ, ca ɗengu po ca aamke, laam ɓeesohaani ɗu na ɓeesɗohohe, weɗ ɗu ɓeesɗohsan. » ");
INSERT INTO sav_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu woyissa ɓa woo kii : « Fuuliɗ miniɗ nook fuuliɗ e ? Ndaa ɓa kanak jen, ɓa keenanɗi ŋ nung e ? ");
INSERT INTO sav_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalube uupɗi inah ɓoyi na jangɗee ɗe waaye a teeɓu baahiɗ ɗah, a hey mande na ɓoyi na jangɗee ɗe. ");
INSERT INTO sav_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wa ye tah fu markee ɓoli ŋ hasiŋ morom fu, te wa ndooɗ yakak nik ŋ hasiŋ ɗa ? ");
INSERT INTO sav_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fu min na woyoh morom fu ne : “ Ƴaariŋ ngo faɗa ŋ nihsiɗ ɗa ɓoli ŋ hasiŋ ɗa ”, te fu yegɗi ndooɗi yakki nik ŋ wiŋ ɗa ? Naafeehaani, koca nihis ndooɗi yakki ŋ hasiŋ ɗa. Fu min hot baahiɗ ne fu nihsiɗ morom fu ɓoli ŋ hasiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kidig baahiɗ minɗi raak rim baahaaɗi te kidig baahaaɗi minɗi raak rim baahiɗ. ");
INSERT INTO sav_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Laam, kidig na inhisohse rimiŋ wa. Ndun na ɓeenohseeɗi ŋ ñaaɓaaɓ, reseñ na nameeɗi ɓeenohu ŋ kidig rup. ");
INSERT INTO sav_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wa mand ɗaa, ɓo' baahiɗ na pulɗe in baahiɗ raakee weɗ a ɗaak ŋ keeñiŋ ɗe. Ɓo' baahaaɗi na pulɗe in baahaaɗi raakee weɗ a ɗaak ŋ keeñiŋ ɗe. Laam, nguɓ na woye ini keeñ riif naa. ");
INSERT INTO sav_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Wa ye tah ɗu ɓeeɗkee so “ Heɗ ɓoo, Heɗ ɓoo ” te ɗu na tumeeɗi ini mi na woye ? ");
INSERT INTO sav_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɓo' nu hay nga so, a sikɗuk woo kiŋ ngo te a pesohee wa ɗah, hayaat ŋ woo ɗu ini ɓoyeem mand naa : ");
INSERT INTO sav_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","a mand na ɓoyi na taɓahe kahan, a acca nooɗiɗ po a pulla ŋ atoh, a yippa fondamaaniŋ ɗe nga. Mbeh, Kooh toɓpa, masma baliɗta po wa laɓpa nga, wa miniɗɗi kahneem in laam wa taɓahu taɓah ndengiɗ. ");
INSERT INTO sav_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Waaye ɓoyi na sikɗuke woo kiŋ ngo te a pesohuu wa, a mand na ɓoyi na taɓahe kahan te a haɓɗiɗuu wa fondama. Wa masma bal po wa laɓpa nga, wa jaarraa fol, wa yahrukohha jameet. » ");
INSERT INTO sav_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wa Yeesu ƴut woo na ɓooɓa ŋ in ceem jen, a kaɗta Kapernawum. ");
INSERT INTO sav_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Raakeen ƴaar nga, a ɓaahee ŋ ɓa adgohee soldaar caŋ Rom, a raakka ñaam kosaayiɗ kosaay miskiɗ po a heeɗa kaane te ƴaareem a keeñkoheen ñaama lool. ");
INSERT INTO sav_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A kerahha laamtohaŋ Yeesu, a woossa ɓi kilifa Yawuut nga ɗe ne ɓa kiim ɗe, a hay wirɗe ñaamiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ɓa kaɗta ŋ Yeesu, ɓa kiimeeɗa ɗe keeh-keeh ; ɓa woosa ɗe ne : « Ƴaari woos ɓoo deey, a waaɗiɗ ɓoo, ɓi Yawuut ci. Te a yi sah taɓahɗuk sinaagogiŋ ɓoo. Weɗ tah, a cariɗ ɓaatɗohu. » ");
INSERT INTO sav_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeesu hunnda na ɓa. Wa ɓa kaɗ po ɓa heeɗa ree kahna, ƴaara woosissa nawleeciŋ ɗe ne ɓa woo Yeesu ne : « Ƴaari woo ne, kina yaaɓ nga kilifaani, a hot ne a yeyyooɗi ne fu aas kahan ce. ");
INSERT INTO sav_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ineem weɗ tah po, a nammba hot ne a ƴissuutiɗ ngaŋ hayoot nga ɗa ; woya woo rek, ñaamiŋ ɗe kuruk. ");
INSERT INTO sav_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A raakiɗ ɓooɓi adgoh ɗe te a namiɗ raak soldaar ci a adgoh. Yaa nu a woo kaɗa ɗah, a kaɗ te yaa nu a woo haya ɗah, a hay. In nu a woo ñaamiŋ ɗe ne a haɓɗaata ɗah, a haɓiɗa. » ");
INSERT INTO sav_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wa Yeesu kerah ineem, a feyuusa ŋ ƴaara ; a woosa mboolnda ñaakɗee ɗe ne : « Ñam na woyee ɗu wa, ŋ Israayel ci sah, ŋ hotɗi ali ɓo' kosiɗ kosii. » ");
INSERT INTO sav_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wa ƴaaɓa woossee dokuk kahna, ɓa raak ñaama kosaayee wiriɗ. ");
INSERT INTO sav_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ŋ finho ineem, Yeesu kaɗeeɗa kur ka na woyse Nayin. Taalubeeciŋ ɗe na ɓo' laayiɗ hunnda na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A kaɗta po a heeɗa ree aasohaanaŋ kur ka, a cohha na ɓi ɓo' kaɗeeɗa uumba fiɗaaf komaaki fiir, yi fu inah ne yaay ɓa raakee ɗe yino te ɓitɓeem ƴaar ce kaaneen. Ɓo' laayiɗ ŋ kur ka huneen na ɗe, ɓa kaɗeeɗa ruy-ruy ca. ");
INSERT INTO sav_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yeesu Heɗ ɓoo hotta yaay ɓi kuɓka, yeem misikka ɗe lool, a woosa ɗe ne : « Kina fuɗ. » ");
INSERT INTO sav_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A reɓpa, a degga yaah ŋ jaata, ƴaaɓa gaalɗohee wa tufukka, a woosa ne : « Ŋ woo ne : Kurka ƴaari. » ");
INSERT INTO sav_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kaanɗa kurukka ɓooffa, a jombeeɗa. Yeesu wikka ɗe yaay ɓa. ");
INSERT INTO sav_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓooɓa nikee ndaam jen feyuusa, ɓa yakɗeeɗa Kooh, ɓa woyeeɗa an : « Woosuuɗ yakak hayiɗ nga ɓoo. Kooh hayiɗ hirpe ɓooɓiŋ ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ŋ ineem, ɓa laamtoheeɗa woo keem ŋ ini kaɗ ŋ Yeesu ŋ kur caŋ Yudee jen na ca wilee wa. ");
INSERT INTO sav_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wa taalubeeciŋ Yahya Ɓoktohi naandsuk ɗe in ci Yeesu na tume jen, Yahya ɓeeɗukka kanak nga ɓa, ");
INSERT INTO sav_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a woossa ɓa ŋ Yeesu Heɗ ɓoo, ne ɓa meekis ɗe andi a yi Mucɗohi Gapohse joy hay wala ɓa joy sek ɓo' wiiriis. ");
INSERT INTO sav_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ɓa kaɗta ŋ Yeesu ɓa woosa ɗe ne : « Yahya Ɓoktohi a yi woos ɓoo, a woo ne ɓoo meeksaat ɗa andi a fu Mucɗohi Gapohse joy hay wala ɓoo joy sek ɓo' wiiriis. » ");
INSERT INTO sav_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Weem, raak, Yeesu wirɗeeɗa ɓo' laayiɗ, kosaayiɗ na jiriɗ na fuuliɗ ; a aañeeɗa jiini ŋ ɓi ɓo'. ");
INSERT INTO sav_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yeesu loffa ɓa ne : « Kaɗaat ɗu woya Yahya ini ɗu hot te ɗu kerahhaa : Fuuliɗ ci ɓii hot, lafañ ci ɓii tiind moɗoɗ, ɓi raak kosaay ki na oɓse faan ɓii wir, ɗikiɗ ci ɓii kerah, kaaniɗ ci ɓii hulit te ñakiɗ ci ɓii woyu Yegɗohiŋ Muci. ");
INSERT INTO sav_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A sumaat, ɓoyi moosanɗi kurkoh ŋ kosi a kos sagu tumohaaɗ ciŋ ngo. » ");
INSERT INTO sav_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wa taalubeeca Yahya woosee coot, Yeesu woyeeɗa na mboolnda ŋ ini kaɗ ŋ Yahya ; a woosa ɓa ne : « Ɗu kee ye marka ŋ nduufa ? Caaɓsi yino-kongi puuɗsi na giyaange e ? ");
INSERT INTO sav_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ŋ liiɓɗaa ! Kon ɗu kee ɓa marka ? Ɓo' ɓekkiɗ kulɓa moɗiɗ e ? Ŋ hot ɓooɓi na ɓekke kulɓa moɗiɗ te ɓa ñame neɓiɗ, na nike ŋ kahan ciŋ buur ci. ");
INSERT INTO sav_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Moo ɗu kee ɓa marka ? Woosuuɗ e ? Ee, ñam na woyee ɗu wa, a yi uup sah woosuuɗ. ");
INSERT INTO sav_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yahya Ɓoktohi a yi Kooh woyee ŋ Fiis ci Hooliɗ ci an : “ Ŋ hey woose ɓo', a adug ɗa, ne a haɓɗiɗ ɗa waasi. ” » ");
INSERT INTO sav_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeesu degiɗta ɓa nga ne : « Ñam na woyee ɗu wa, ŋ ɓooɓi rimuk jen ali ɓo' uupɗi Yahya Ɓoktohi nga. Waaye ɓoyi uup ƴissuut ŋ Nguuriŋ-Kooh a yi uup ɗe yak. ");
INSERT INTO sav_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓooɓi kerah Yahya Ɓoktohi jen, po juuti'oh ci sah, ɓa ambiɗ ne Kooh yurhiɗ, ɓa teyɗukka ɓoktiŋ Yahya. ");
INSERT INTO sav_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Waaye Farisen ci na jangɗohoh ciŋ waasiŋMusaa teyɗukɗi ini Kooh waaɗɗiɗ ɓooɓi, ɓa teyɗukɗi ɓoktiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Moo, ŋ min mandtiɗkoh ɓooɓi woti na ye ? ");
INSERT INTO sav_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓa mand na komaakci ɓoof ŋ ɗiski na toonohse ŋ kur ki, ɓa woytiɗohee ne : “ Ɓoo tipɗiɗ ɗu, ɗu mbecɗi ; ɓoo ƴeekɗiɗ ɗu ƴeek ruy, ɗu fuɗɗi. ” ");
INSERT INTO sav_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Laam Yahya Ɓoktohi hayiɗ, a ñameeɗi ina ɓooɓa na ñame, a aneeɗi biiñ ; ɗu na woye ne a raak jiini. ");
INSERT INTO sav_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kuɓkiŋ ɓoyi hayiɗ, a na ñamee ñam, a ane ; ɗu na woye ne : “ A ñamoh, a anoh biiñ, te a nawle juuti'oh ci na bakaaɗoh ci. ” ");
INSERT INTO sav_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Waaye liiɓohaaɗi moɗiɗi puloh ŋ Kooh na teeɓohe yurhiŋ wa, taamboh ŋ ɓooɓi Kooh ona jen. » ");
INSERT INTO sav_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wa raakka mbeh, ƴaar ɓaah ŋ Farisen ca ɓeeɗukka Yeesu ne a ñama ŋ kahan ce, Yeesu kaɗta, ɓooffa, a raɗissa kot caŋ ɗe, a ñameeɗa na ɓa. ");
INSERT INTO sav_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɓitiɓ mbalayoh gen kur ka kerahha ne Yeesu a yaa ŋ kahan Farisena, a kaɗta na buteelalbaatar riifiɗ na laackoloñ eeñiɗ. ");
INSERT INTO sav_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A nikka ŋ kot ciŋ Yeesu, a fuɗeeɗa ; a cammba ca iiri'iɗ na muhun, a mooseeɗa ca na findiŋ ɗe, a fooneeɗa ca, a laackoloñeeɗa ca. ");
INSERT INTO sav_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wa Farisena hot ineem, a woosa ŋ ɗooƴ ce ne : « Ƴaari nikee woosuuɗ ɗah, a heen inhe ne ɓoyi na laalee ɗe bakaaɗoh. » ");
INSERT INTO sav_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ŋ ineem Yeesu woosa ne : « Simong, raakiɗ ini ŋ waaɗ ɗa woo. » A loffa ne « Ee, Jangɗohohi, woya. » ");
INSERT INTO sav_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu woosa ɗe ne : « A nikee ƴaar, ɓo' kanak joyya ɗe wirind kombot ; yinoori joyee ɗe eɗ dinaar teemet-yatuus (500), yi tas joyya ɗe eɗ dinaar ndaŋkiyaah-yatuus (50). ");
INSERT INTO sav_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɓa kanak jen, ɓa minɗi ɗe ca wirind, a ɗaassa ɓa ca. Woo so yi uupan ɗe waaɗ nga ɓa. » ");
INSERT INTO sav_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A loffa ɗe ne : « Ŋ liiɓiɗ ne a yi ɗaasu kombot ki uup laay. » Yeesu woosa ɗe : « Ee, fu woo keeh. » ");
INSERT INTO sav_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ƴutta, a heelukka ɓitɓa, a woosa Simong ne : « Fu hotiɗ ɓitɓii e ? Ŋ aasiɗ kahan fu, te fu onɗi so masuɓ ne ŋ naawis kot ciŋ ngo, waaye a iiri'ɗiɗ ca na muhun ciŋ ɗe, a moossa ca na findiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fu foonɗi so, waaye ina ŋ reyoh po wi a yi fooneeɗa ŋ kot ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fu diwɗi hafiŋ ngo waaye a laackoloñiɗ kot ciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mi na woyee ɗa ne a ɗaasu bakaaɗ ciŋ ɗe laayiɗ ci, weɗi tah a teeɓohha waaɗoh hend an. Waaye ɓoyi ɗaasu ƴissuut na waaɗee waaɗ ƴissuut. » ");
INSERT INTO sav_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ƴutta Yeesu woosa ɓitɓa ne : « Fu ɗaasuuɗ bakaaɗ ciŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓooɓa ɓinooɓa a ñamee na ɓa woyeeɗa ŋ ɗooƴ ɓa ne : « Moo, ƴaari a yi ɓa po a ɗaasohee bakaaɗ ci ? » ");
INSERT INTO sav_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Waaye Yeesu woosa ɓitɓa ne : « Kosi fu kos tosiɗ ɗa, kaɗa ŋ jam. » ");
INSERT INTO sav_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wa in ceem coot, Yeesu kaɗeeɗa ŋ kur ca yakak ca na ca ƴin ca, a woyeeɗa ɓooɓa Yegɗohiŋ Muci, wi kaɗ ŋ Nguuriŋ-Kooh ; a hunee na Apootar ci ndaŋkiyaah na kanak ci (12). ");
INSERT INTO sav_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A nameen hun na ɓi ɓitiɓ ɓi a saɓsohee na jiiniica ambee ɓa, na ɓa a wirɗee ŋ kosaay caŋ ɓa. Findi Mari yi na woyse Mari Makdala yi a saɓsohee na jiini yasna-kanak, ");
INSERT INTO sav_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Saan ɓiti Kuusa, ƴaara nikee daga meeɗ taambkoh raak-raakaŋ Herod, na Susaan na ɓi wiiriis laayiɗ. Ɓeem ɓeɗ ɓaatɗohee Yeesu na Apootar ciŋ ɗe ŋ in ca ɓa raak. ");
INSERT INTO sav_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓooɓa puloheeɗa ɗisik nu ɗisik, ɓa hayeeɗa ŋ Yeesu. Wa mboolnda laay, a woosa ɓa andiinii : ");
INSERT INTO sav_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","« A nikee guuroh, a kaɗta soka. Wi a soke, a saaweeɗa tisohi, in nga hennda ŋ waasi ŋ ɗooƴ yohni, ɓooɓi daksoheeɗa ca, sel ci hayya ñammbaa. ");
INSERT INTO sav_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Raakka ci keen ŋ keheƴ raakiɗ atoh ; wi ca paar, maañɗi ca suyya laam ɗiska iiri'eeɗi. ");
INSERT INTO sav_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Cum keennda ŋ ñaaɓaaɓ ci, ca paarandoosa na ca, ñaaɓaaɓ ca ammba ca. ");
INSERT INTO sav_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Cinooca hennda ŋ kehƴa baahɗa, ca paarra, wa ca yak ca eɗohha ini ree waas teemet ŋ ina soku. » Teemb ndeem, Yeesu woosa ɓa ne : « Ɓo' nu raak nof kerhoha ɗah, a kerhaat. » ");
INSERT INTO sav_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taalubeeciŋ ɗe meekissa ɗe ini andiineem tokis. ");
INSERT INTO sav_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A loffa ɓa ne : « Ɗu onuuɗ ne ɗu inah in ci ɗasɗukiɗ ciŋ Nguuriŋ-Kooh, waaye ɓinooɓi na woyse in ŋ andiin ne : “ Ɓa markee baahiɗ, ɓa minuu hot, ɓa sikɗuke, ɓa minuu inah. ” ");
INSERT INTO sav_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ŋ ini kaɗ ŋ andiinii, wa tokis inii : Tisohi weɗ woo kiŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɓum ɓeɗ ŋ sero waasi, ɓeɗ ɓooɓi na kerhe woo kiŋ Kooh, waaye Seytaani hay a nihisa ŋ keeñ ciŋ ɓa ; a hondoh ɓa kos ne ɓa mucɗu. ");
INSERT INTO sav_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ɓum ɓeɗ paaroh ŋ ini saawu ŋ kehƴi raak atoh ci ; ɓeɗ ɓooɓi na kerhe Woo ki, te ɓa teyɗuka na keeñ soosiɗ, waaye ɓa na raakeeɗi niir, laam kosi ɓa kos na maañeeɗi, miskiɗ ci hayya ɗah, ɓa faɗ. ");
INSERT INTO sav_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ɓum ɓeɗ paaroh ŋ ini saawu ŋ ñaaɓaaɓ ci, ɓeɗ ɓooɓi na kerhe Woo ki, ɓa teyɗuka, waaye liiɓsiɗoh ci na raak-raak ci na neɓiɗ ciŋ Adina amb ɓa po ɓa raakuu rim ruundiɗ. ");
INSERT INTO sav_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɓinooɓi ɓeɗ paaroh ŋ ini saawu ŋ kehƴi baahiɗi, ɓeɗ ɓi na kerhe Woo ki, ɓa teyɗuka na keeñ moɗiɗ ! Ɓa amba ndengiɗ po ɓa raak rim. ");
INSERT INTO sav_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ali ɓo' na fuuɗeeɗi laampa, a kuna na kanoh wala a ɗaaka ŋ ooɓ fiƴaang, waaye a na degee wa ŋ degohaaniŋ wa ne ɓo' nu aas ɗah, wa ñiinɗiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Laam, ini ɗemb jen hey hotke, ini ɗasɗu jen hey inhasse noh cong. ");
INSERT INTO sav_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mbaa sikɗukaat na nof laam ɓoyi raak hey ɓaatse, te ɓoyi raakɗi, ini a liiɓ ne a raakiɗa, hey ɓayse. » ");
INSERT INTO sav_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Weɗ yaay ɓi Yeesu na taambɗoh ciŋ Yeesu hayoh ɗe marke, waaye ɓa minɗi ree nga ɗe sagu mboolnda. ");
INSERT INTO sav_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A woyuusa ne : « Yaay ɗu na taambɗoh ciŋ ɗa ɓa ɗaa ŋ finhoora te ɓa waaɗiɗ ɗa hot. » ");
INSERT INTO sav_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A loffa ne : « Yaay ɓoo na taambɗoh ciŋ ngo ɓeɗ ɓooɓi na sikɗukee woo kiŋ Kooh te ɓa taambɗee wa. » ");
INSERT INTO sav_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wa raakka mbeh, Yeesu aassa ŋ gaal, a yi na taalubeeciŋ ɗe, a woosa ɓa ne : « Ɓoo kaɗaat ŋ ɓaka faahaŋ cookma. » Ɓa kaɗta. ");
INSERT INTO sav_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wa ɓa joowe, Yeesu neehha. Ɗekka po puuɗis yakak raakka ɓa ŋ cookma, gaala riiffa na masuɓ po wa heeɗa diige. ");
INSERT INTO sav_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Taalubeeciŋ ɗe reɓpa nga ɗe ɓa yuneeɗa ɗe an : « Kilifaani ! Kilifaani, ɓoo ɓii kaan de' ! » Yeesu yunukka, a ngassa puuɗsa na ginaah ca yakiɗ ca, ca yeeɓukka, ɗiska eennda. ");
INSERT INTO sav_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeesu woosa taalubeeciŋ ɗe ne : « Wa nde kosi ɗu kos ? » Ɓa feyuusa ; ɓa woyeeɗa ŋ harmban ɓa ne : « Ƴaarii joy nik ɓa, po a woyee na puuɗsi na masmi ca kerhiɗee ɗe ? » ");
INSERT INTO sav_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ŋ pulohaŋ ɓa Galile, Yeesu na taalubeeciŋ ɗe taalndiɗta, ɓa kaɗeeɗa ŋ cookma po ɓa serra ŋ kur caŋ Geraas ca ; kur ceem yurhiɗkoh na Galile. ");
INSERT INTO sav_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wa Yeesu yipuk, ƴaar gen kur ka kaɗta coha na ɗe, ca jiini ambee ɗe. A gijeen ɓekuk kulɓa te a nikeeɗi ŋ kahan, a genee ruy-ruy ca. ");
INSERT INTO sav_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","A hotta Yeesu, a ƴekka ŋ fikiice a leehkeeɗa ŋ ɗafka, a woosa ne : « Yeesu Kuɓkiŋ Kooh yi ŋ ɗafka ɗafka, fu nar ye nga so ? Mi yii kiim ɗa ne fu tumuu so miskiɗ. » ");
INSERT INTO sav_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Laam raak Yeesu woyiɗ jiiniica na hoolaaɗiika ca hoolaaɗi, ne ca pulaat ŋ ƴaara. Ca meeɗeen ɗe amb waas laayiɗ. Ca ammba ɗe ɗah, ɓa tok yaah ci na kot ciŋ ɗe na ceen, ɓa niiɗee ɗe. Hondohɗi a nguɗ ceen ceem te jiiniica hiir ɗe ne a kaɗ ɗaaya ŋ nduufa. ");
INSERT INTO sav_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeesu meekissa ƴaara ne : « Fu teeku na ? » A loffa ne « Ŋ teeku Lesiyong. » Ca jiini gooñ nikee na ɗe, weɗ tah a woosa ineem. ");
INSERT INTO sav_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jiiniica kiimeeɗa Yeesu ne a kinaat ca tuuƴ ŋ nunga nooɗɗa ca na hee torhiɗohse. ");
INSERT INTO sav_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Raak ŋ serooɓa, ŋ tangoora, gat mbaam-huk yakak nikee ñameeɗa nga. Jiiniica kiimmba Yeesu keeh-keeh ne a on ca ca aas ŋ mbaam ca ; a onnda ca ineem. ");
INSERT INTO sav_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ca pulla ŋ ƴaara, ca aassa ŋ mbaam ca, gata jen giirukka, hunnda na mbartala, faɗsukka ŋ cookma, mbaam ca lappa nga. ");
INSERT INTO sav_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wa ɓooɓa niiɗee mbaam ca hot ineem, ɓa nuppa, ɓa kaɗtaa woya ŋ kur-taaha na kur ca ƴin ca. ");
INSERT INTO sav_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓooɓa hayeeɗa marke ini raak. Ɓa reesa, ɓa raakka ƴaara jiiniica puloh nga ɗe ɓoofiɗ ŋ kot ciŋ Yeesu, ɓekkiɗ kulɓa, a hunnda na sagooniŋ ɗe ; ɓa neƴƴohha. ");
INSERT INTO sav_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓooɓa maasohee naandsukka ɓa findi ƴaara saɓsohohu na jiiniica. ");
INSERT INTO sav_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ɓeɗ ɓa genee Geraas jen kiimmba Yeesu ne a pul ndaam laam ɓa neƴƴoheen lool. Yeesu rappa ŋ gaala ne a coot, ");
INSERT INTO sav_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ƴaara kiimmba ɗe ne : « On ndo ŋ hun na ɗa. » Waaye Yeesu gurdiɗta ɗe, a woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","« Haada kahan ɗu, fu naandsuka ini Kooh tumiɗ ɗa jen. » Ƴaara haadda, a naandsukka ɓi kur ka jen ina Yeesu haɓɗiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wa a dokuk Galile, Yeesu raak ɓo' laayiɗ sekeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɗekka po ƴaara na woyse Jayrus, ya adgohee sinaagoga hayya nga ɗe. A ƴekka ŋ fikiice a kiimmba ɗe ne a kaɗ kahan ce, ");
INSERT INTO sav_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","laam raak kuɓkaŋ ɗe cafƴa heeɗa kaane te a raakee ɗe yino, tel kuɓkeem yii ŋ kiis ndaŋkiyaah na kiis kanak ciŋ ɗe (12). Wa Yeesu kaɗee nga, mboolnda ɗiifɗoheeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋ ɗooƴ mboolnda, ɓitiɓ nikeen nga, ñif miŋ ɗe meeɗ meeɗ aamuk, a tumiɗ na kosaay keem kiis ndaŋkiyaah na kiis kanak (12), a tumeen ina a raake jen ŋ paƴoh ca, te ali ɓo' mineeɗi ɗe wiriɗ. ");
INSERT INTO sav_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A lahha Yeesu finho, a laalla lecmiŋ kulɓaakiŋ ɗe ; ŋ ɗiska ɗiska, ñif maŋ ɗe aamkisɗi. ");
INSERT INTO sav_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu meeksohha ne : « Ya ɓa laal lo ? » Yaa nu nga ɗah taaskeeɗa. Piyeer woosa ɗe ne : « Moo Kilifaani, ɓooɓi wil ɗa wil te ɓa ɗii ɗiifkoheeɗa ! » Yeesu woosa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","« Ee ! Waaye raakiɗ doolndi puloh nga so, weɗ tah ŋ inahha ne raakiɗ ɓoyi laal lo. » ");
INSERT INTO sav_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wa ɓitɓa inah ne a yeguuɗ, a saakɗoheeɗa, a ƴekka ŋ kot ciŋ Yeesu, a naandsukka ŋ fiki ɓooɓa jen, ini tah a laalla Yeesu na findi a wiroh ŋ ɗiska ɗiska. ");
INSERT INTO sav_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu woosa ɗe ne : « Kosi fu kos wirɗiɗ ɗa, kaɗa moɗoɗ ɓitɓi. » ");
INSERT INTO sav_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wa Yeesu woyee, ɓo' pulohha kahan Jayrus, a woosa yeem ne : « Wa etohisɗi fu yaaɓɗe Jangɗohohi, kuɓkiŋ ɗa kaaniɗ. » ");
INSERT INTO sav_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeesu kerahha nga a woosa Jayrus ne : « Kina neƴƴoh, kosa rek, kuɓkiŋ ɗa hey muce. » ");
INSERT INTO sav_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wa Yeesu ree kahna, ɗal Piyeer na Saaŋ na Saak na baab ɓi kuɓki na yaay ɓa ɗah, a faɗɗi ali ɓo' ne a aas na ɗe nga. ");
INSERT INTO sav_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓooɓa jen nikee rooyeeɗa kuɓka, Yeesu woosa ɓa ne : « Kanaat rooy, a kaanɗi, a na neehe. » ");
INSERT INTO sav_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓa njembteeɗa ɗe laam ɓa inheen ne a kaaniɗ. ");
INSERT INTO sav_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeesu ammba yaahiŋ kuɓka, a woosa ŋ ɗafka ne : « Kuɓu kurka ! » ");
INSERT INTO sav_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A hulitta, a jaarra kuruk. Yeesu woosa ɓa ne ɓa onaat kuɓka a ñam. ");
INSERT INTO sav_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yaay ɓa na baab ɓa feyuusa waaye Yeesu woosa ɓa ne ɓa kinaata woo ali ɓo'. ");
INSERT INTO sav_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wa raakka mbeh, Yeesu cohɗohha Apootar ci ndaŋkiyaah na kanak ci (12), a onnda ɓa hatil na min-min aañoha jiini nu nik na wirɗoha kosaay ci. ");
INSERT INTO sav_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ƴutta a tuuƴca ɓa ne ɓa yegɗoha Nguuriŋ-Kooh te ɓa wiriɗ kosaayiɗ ci. ");
INSERT INTO sav_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A woosa ɓa ne : « Ɗu kaɗee ɗah, kinaat ɓayndoh ali in, findi ndooɗ, saak, kañam wala kopor, te kinaat ɓay kulɓa kanak. ");
INSERT INTO sav_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɗu aas kahan, ɓa teyɗuk ɗu ɗah, nikaat nga po mbaɗna ɗu cootan. ");
INSERT INTO sav_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Waaye ɗu kaɗ kur, ɗu teyɗukuuɗi nga ɗah, paangaat kot ciŋ ɗu, ɗu pul, ɓa inah ne ɓa heya markiɗe na Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɓa kaɗta, ɓa aaseeɗa ŋ kur na kur ; ɗisik nu ɗisik, ɓa woyeeɗa Yegɗohiŋ Muci, ɓa wirɗeeɗa kosaayiɗ ca. ");
INSERT INTO sav_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, ya adgohee Galile, wa a kerah in ca raakee jen, a feyuusa, laam raakiɗ ɓi woyee ne : « A Yahya Ɓoktohi a yi hultiɗu. » ");
INSERT INTO sav_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɓum woyeeɗa ne : « A woosuuɗi Ilyas a yi hayis. » Ɓinooɓi woyeeɗa ne : « A woosuuɗ ŋ woosuuɗ ca ɗeɓgaan a yi na pesisse. » ");
INSERT INTO sav_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Waaye Herod woosa ne : « Yahya Ɓoktohi, ñam nguɗɗuk hafiŋ ɗe ; kon ƴaari mi na kerhe na haɓɗe in cii, a joy nik ɓa ? » A waakeeɗa ɗiski a hotohan Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wa Apootar ca puloh ɗisik ca ɓa tuuƴse, ɓa naandsukka Yeesu in ca ɓa haɓiɗ jen. Ƴutta, a ɓayya ɓa ŋ kur ka na woyse Betsayda, a ɗaayya na ɓa nga. ");
INSERT INTO sav_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Waaye ɓooɓa yegga ineem, ɓa raakka ɗe nga. Yeesu teyɗukka ɓa, a woyeeɗa na ɓa ŋ ini kaɗ ŋ Nguuriŋ-Kooh, a wiriɗta kosaayiɗ ca. ");
INSERT INTO sav_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wa noha na niine, Apootar ci reɓpa ŋ Yeesu, ɓa woosa ɗe ne : « Ndii bilaf. Woya ɓooɓii ɓa kaɗ ŋ kur ci reɓ ndii, ɓa waaka ɗiski ɓa nikan na ini ɓa ñaman. » ");
INSERT INTO sav_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Waaye a loffa ɓa ne : « Ɗu, eɗaat ɓa ini ɓaa hee ñame. » Ɓa woosa ɗe ne : « Ɓoo raak mbuuru yatuus na cuurund kanak dong ndii, te ɓoo minɗi ɓa kaɗ romɗa kañam jen ! » ");
INSERT INTO sav_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ƴaar ca ŋ ɗiska ɗaleen ree junni-yatuus (5000) wala ini uupa. A woosa taalubeeciŋ ɗe ne : « Woyaat ɓa, ɓa ɓoof ndaŋkiyaah-yatuus ndaŋkiyaah-yatuus (50-50). » ");
INSERT INTO sav_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓa haɓiɗta ini a woo, ɓa ɓoofiɗta ɓooɓa jen. ");
INSERT INTO sav_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A ɓayya mbuuru ca yatuus ca na cuurund ca kanak ca, a taaknukka ŋ Eel ci, a gidimmba Kooh, a nguɗsohha ca, a eɗta taalubeeciŋ ɗe ne ɓa paysoh mboolnda ca. ");
INSERT INTO sav_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓooɓa jen ñammba po ɓa kappa. Ɓa tummba tasɗohiica ŋ pañe ndaŋkiyaah na kanak (12). ");
INSERT INTO sav_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wa raakka mbeh, Yeesu ɗaayya, a kiimeeɗa Kooh ; taalubeeciŋ ɗe nikee na ɗe, a meekissa ɓa ne : « Ɓooɓi na woye ne ñam ɓa ? » ");
INSERT INTO sav_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓa loffa ɗe ne : « Ɓum na woye ne a fu Yahya Ɓoktohi, ɓinooɓi woyee ne a fu Ilyas, raakka ɓi na woye ne fu woosuuɗ wiiriis, ɓaah ŋ ɓa maañiɗ ca, fu hulit hulit. » ");
INSERT INTO sav_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeesu woosa ɓa ne : « Moo ɗu nak ? Ɗu na woye ne a mi ɓa ? » Piyeer loffa ɗe ne : « Ya fu Mucɗohi Kooh gapohe. » ");
INSERT INTO sav_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeesu dennga ɓa baahiɗ ne ɓa kinaata woo ali ɓo'. ");
INSERT INTO sav_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A woosa ɓa ne : « Kuɓkiŋ ɓoyi joyiɗ yaaɓ keeh-keeh ŋ yaah ciŋ yakak ci na kilifaaciŋ seeƴkiɗoh ciŋ waasiŋMusaa na jangɗohoh ciŋ wa, ɓa hey ɗe sange, a apu te a hultiɗu ŋ neeha kaahayɗoh. » ");
INSERT INTO sav_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A woyissa ɓa ne : « Ɓo' nu waaɗ hun na so ɗah, a joyɗi liiɓ haf ce te Kooh-nu-wiis ɗah, a deguk kurwaani aa hee daaƴohse, a ñaakiɗ to. ");
INSERT INTO sav_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Laam ɓo' nu waaɗ muciɗ kipes kiŋ ɗe ɗah, a heya ñake, waaye ɓo' nu eɗoh kipes kiŋ ɗe saguuso ɗah, a hey wa mucɗe. ");
INSERT INTO sav_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɓo' raak adinaani jen na in ci nik nga, a han ñak kipes kiŋ ɗe wala a yah haf ce ɗah, wa raakiɗ ɗe winde etoh ? ");
INSERT INTO sav_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɓo' nu supuk hun na so na woo ciŋ ngo ɗah, Kuɓkiŋ ɓoyi hey ɗe supke inah ne a hayee ŋ kiyak kiŋ ɗe, na wiŋ Baabi na wiŋ malaakaaci hooliɗ ci ɗah. ");
INSERT INTO sav_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ñam na woyee ɗu inii, te wa keeh, ɓi ɓo' ɓii ŋ ndii, ɓa kaananɗi muk te ɓa hotɗi Nguuriŋ-Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wa degga ini ɗal ree neeh yasna-kaahay ŋ finho woo ceem, Yeesu hunnda na Piyeer na Saaŋ na Saak ; a rappa ŋ tango ne a kiim Kooh. ");
INSERT INTO sav_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wa a na kiime, fikiiriŋ ɗe ɓoƴsukohha, kulɓaaciŋ ɗe nikka yaanow tar po ca melciɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɗekka po ɓo' kanak woyeeɗa na ɗe, ɓa nikee woosuuɗ, Musaa na Ilyas. ");
INSERT INTO sav_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓa siñaarɗeeɗa siñaariɗ, ɓa woyeeɗa na Yeesu ŋ kurkohiŋ ɗe ŋ Adina wi ɗiindohan ini ɓay ɗe, te wa joyya raakoh Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyeer na huntoh ciŋ ɗe nikee neeheeɗa neeh nooɗiɗ. Ɓa yunukka, ɓa hotta siñaariŋ ndamiŋ Yeesu na ɓooɓa kanak ca jombee na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wa ƴaaɓa kanak ca na coote, Piyeer woosa Yeesu ne : « Kilifaani, wa baahiɗ ne ɓoo nik ndii, ɓoo haɓiɗ ɗiip kaahay, winoori nik wiŋ ɗa, winni nik wiŋ Musaa, wi tas nik wiŋ Ilyas. » Waaye a inheeɗi ini a woye. ");
INSERT INTO sav_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wa a na woye, eel saanginnda ɓa, taalubeeci neƴƴohha wa eela muur ɓa. ");
INSERT INTO sav_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ŋ ɗooƴ eela raakka hoosoora woo ne : « Yii, a yi kuɓkiŋ ngo ŋ tan, sikɗukaat a yi. » ");
INSERT INTO sav_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wa hoosoora kerhuk, ɓa hotta Yeesu kiik ce njong. Ŋ neeh caam, ɓa naandsukɗi ali ɓo' ini ɓa hot, ɓa ɗekkaa teɗ. ");
INSERT INTO sav_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wa Kooh wiis, ɓa ruhussa tangoora weɗ mboolo yakak hayoh cohe na Yeesu. ");
INSERT INTO sav_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wa raakeen ƴaar nga a woyeeɗa ŋ ɗafka an : « Jangɗohohi mi yii kiim ɗa, markiɗ to kuɓkiŋ ngo, a yi dong ŋ raak ; ");
INSERT INTO sav_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","na ɗekee ɗek po jiini amb ɗe, a leehke, a walañke, nguɓiŋ ɗe soñe ; a na faɗseeɗi ɗe te a pooksohɗi faaniŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ŋ nakiɗ taalubeeciŋ ɗa ne ɓa saɓsoh ɗe na ɗe, waaye ɓa minɗaa. » ");
INSERT INTO sav_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu woosa ne : « Ɗu ɓi ɓooɓi woti-woti e ɗu kosaaɗi, ɗu yahukka, ŋ nikan nik na ɗu ŋ muñɗee ɗu po kiɗa ? » A woosa ƴaara ne : « Ɓaya kuɓkiŋ ɗa ndii. » ");
INSERT INTO sav_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wa kuɓka na reɓe, jiinnda folla ɗe, a walañkeeɗa. Yeesu ngassa jiinnda, a wiriɗta kuɓka, a wikka ɗe baabiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɓooɓa jen feyuusa ŋ yakkiŋ Kooh. Ɓo' nu nga feyuusa ŋ in ca Yeesu haɓɗe jen. Weɗi a woyoh taalubeeciŋ ɗe ne : ");
INSERT INTO sav_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Sikɗukaat baahiɗ ini maa hee ɗu woye : Kuɓkiŋ ɓoyi hey degse ŋ yaah ciŋ ɓooɓi. » ");
INSERT INTO sav_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Waaye taalubeeciŋ ɗe inheeɗi ini woo keem tokis, ɓa ɗasɗohseen ini wa waaɗ woo, te ɓa kaañeeɗi ɗe wa meekis. ");
INSERT INTO sav_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Taasoh raakka ŋ harmban taalubeeciŋ Yeesu, raak ɓa markee yi uup nik kilifa nga ɓa. ");
INSERT INTO sav_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu inahha ini nik ŋ keeñ ciŋ ɓa, a ɓayya komaaki ƴin a tufkiɗta ɗe ŋ serooce, ");
INSERT INTO sav_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a woosa ɓa ne : « Ɓo' nu teyɗuk njaanjii saguuso ɗah, a teyɗuk ko ; te ɓo' nu teyɗuk ko ɗah, fu teyɗuk Kooh yi woos so ; laam, ɓoyi uup ƴissuut nga ɗu jen, a yi uup yak. » ");
INSERT INTO sav_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Saaŋ woosa ɗe ne : « Kilifaani, ɓoo hotiɗ ɓo' aañeeɗa jiiniici ŋ tiikiŋ ɗa, te a ɓaahɗi nga ɓoo, tahha po ɓoo woosa ɗe ne a kinaata tumis. » ");
INSERT INTO sav_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeesu woosa ɗe ne : « Kinaat ɗe wa sangoh, ɓo' nu sangɗi ɗu ɗah, a hun na ɗu. » ");
INSERT INTO sav_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jamanoona Yeesu joy rapɗohu Eel ci reɓeeɗa, heliŋ ɗe jen nikka ngaŋ kaɗ Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A woossa ɓi ɓo' ne ɓa adug ɗe ŋ kur ngaŋ caŋ ɓi Samari, ne ɓa waakiɗ ɗe dal nga, ");
INSERT INTO sav_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","waaye ɓi kur ka sannga sagu ina Yeesu ɓay waasa kaɗ Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Taalubeeciŋ ɗe Saak na Saaŋ hotta ŋ ineem ɓa woosa ɗe ne : « Kilifaani, fu waaɗiɗ ne ɓoo nak yongkaah, wa puloh eel ci wa ɗumbiɗ ɓa e ? » ");
INSERT INTO sav_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeesu yurhiɗkohha na ɓa, a ngassa ɓa. ");
INSERT INTO sav_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A na huntoh ciŋ ɗe kaɗta kur wiiriis. ");
INSERT INTO sav_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wa ɓa kaɗee, raakka ƴaara woo Yeesu ŋ waasa ne : « Kilifaani, ɗisik nu fu kaɗ ɗah, ŋ hey ɗa ñaakɗe. » ");
INSERT INTO sav_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu woosa ɗe ne : « Ɓaakoɓ ci raakiɗ nung, sel ci raakiɗ taar, waaye Kuɓkiŋ ɓoyi raakɗi sah ɗiski a na hee iɗsiɗkohe. » ");
INSERT INTO sav_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu woosa ƴaar wiiriis ne : « Ñaakiɗ to. » Waaye ƴaara loffa ɗe ne : « Kilifaani, on ndo paaɗ, ŋ taambkoh yaɓkooriŋ ngo po a kaan, ŋ uumb ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu woosa ɗe ne : « Faɗa kaaniɗ ci ɓa uumb kaaniɗ ciŋ ɓa te fu kaɗ yegɗoha Nguuriŋ-Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Raakka ƴaara nam ɗe woo ne : « Kilifaani ŋ hey ɗa ñaakɗe, waaye on ndo ŋ kaɗ aska ɓi kahan ndo paaɗ. » ");
INSERT INTO sav_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu loffa ɗe ne : « Nguuriŋ-Kooh etohɗi ɓoyi na guure heelke. » ");
INSERT INTO sav_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wa in ceem coot, Yeesu Heɗi kooɗissa taalube ndaŋkiyaah-yasna-kanak na taalube kanak (72), a tuuƴca ɓa kanak kanak ŋ kur ca a joyee kaɗoh jen ne ɓa adug ɗe nga. ");
INSERT INTO sav_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A woosa ɓa ne : « Yohni laaɓiɗ waaye nguɗoh ci laayɗi. Kon kiimaat Heɗ yohni a woosoh ɓi pangkoh, ɓa nguɗ yohni. ");
INSERT INTO sav_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kaɗaat, mi yii tuuƴ ɗu findi buul mbaal ŋ ɗooƴ gat ɓaakoɓ. ");
INSERT INTO sav_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kaɗaat yaah ɓarang ; kinaat ɓayndoh kopor, saak mbaa ñafaɗ te ŋ waasi, kinaat tufuk ne ɗu kañɗoh. ");
INSERT INTO sav_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ɗu aasee kahan ɗah, kocaat woo ne : “ Jam raakaat ŋ kahnii. ” ");
INSERT INTO sav_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɓo' jam nik nga ɗah, jameem hey nike na ɗe ; a raakɗi nga ɗah, wa dokuk nga ɗu. ");
INSERT INTO sav_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tasaat ŋ kahneem, ɗu ñamee, ɗu anee, in nu ɓa eɗ ɗu ɗah, laam pangkoh joyiɗ wirndu. Kinaat tooruk ŋ kahan na kahan. ");
INSERT INTO sav_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kur nu ɗu aasoh, ɓooɓa nga teyɗuk ɗu ɗah, in nu ɓa eɗ ɗu ɗah, ñamaat weɗi. ");
INSERT INTO sav_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wirɗaat kosaayiɗ ca nik nga te ɗu woo ɓooɓa ne : “ Nguuriŋ-Kooh reɓiɗ ɗu. ” ");
INSERT INTO sav_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Waaye ɗu aas kur, ɓooɓa nik nga teyɗukɗi ɗu ɗah, pulaat po ŋ mbeeddaaca, ɗu woo ɓa ne : ");
INSERT INTO sav_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“ Ɓoo ɓii faris merhey mi nik ŋ kot ciŋ ɓoo nga ɗu, waaye inhaat ne Nguuriŋ-Kooh reɓiɗ. ” ");
INSERT INTO sav_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ñam na woyee ɗu ne mbehi Kooh atte'ohan ɓooɓi, e ɓi kur keem uupan miskiɗ ɓi Sodom. ");
INSERT INTO sav_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mas ɗu ɓi gen Korasin na Betsayda. Keemaan ci tumu ŋ kur ciŋ ɗu, ca tumseen ŋ Tiir na Sidoon ɗah, ɓooɓa gen nga ca heen ɓoƴsohe tumohaaɗ ciŋ ɓa maañ. Ɓa ɓekuk daah ɓa ɓoof ŋ wet ne ɓa teeɓoha. ");
INSERT INTO sav_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ineem weɗ tah po mbehi Kooh atte'ohan ɓooɓi, e ɗu na hee uupee miskiɗ ɓi Tiir na ɓi Sidoon. ");
INSERT INTO sav_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te ɗu ɓi gen Kapernawum, ɗu liiɓiɗ ne Kooh hey ɗu rapɗe po ŋ Eel ci e ? Muk ! A hey ɗu ruhsiɗe po ŋ kaaniɗ ca. » ");
INSERT INTO sav_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeesu woosa taalubeeciŋ ɗe ne : « Ɓo' nu sikɗuk ɗu ɗah, a sikɗuk ko ; te ɓo' nu teyɗukɗi ɗu ɗah, a teyɗukɗi so. Ɓo' nu teyɗukɗi so ɗah, a teyɗukɗi Yi woos so. » ");
INSERT INTO sav_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wa taalubeeca ndaŋkiyaah-yasna-kanak na kanak ca hay, ɓa hayya neɓuuɗ, ɓa woosa Yeesu ne : « Kilifaani, jiiniici sah, ca tumiɗ ini ɓoo woo sagu tiikiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A woosa ɓa ne : « Ŋ hotiɗ Seytaani keenohha Eel ci findi meleñ. ");
INSERT INTO sav_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sikɗukaat, ŋ oniɗ ɗu ne ɗu min tiind ŋ ɗafuk iiñ ci na ndangal ci, te ɗu min Seytaani, sangiɗiŋ ɓoo, na hatiliŋ ɗe jen po tus minɗanɗi ɗu in. ");
INSERT INTO sav_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Waaye kinaat neɓu ŋ ini jiiniici kerhiɗ ɗu, neɓsaat ŋ ini tiik ciŋ ɗu fiisu ŋ Eel ci. » ");
INSERT INTO sav_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Teemb ndeem Fuuɗsi Hoolohngaani sumɗukohha Yeesu keeh-keeh, a woosa ne : « Mi yii corkiɗ ɗa Baab, fu yi Heɗ Eel ci na kehƴi, ŋ ini fu ɗasɗoh heɗ haf ci na ñaañiɗ ci in cii, fu teeɓpa ca komaakci. Ee Baab, mi yii corkiɗ ɗa. A fu waaɗoha ɗaa ŋ baah kiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A woyissa ɓooɓa ne : « Baabiŋ ngo degiɗ in ci jen ŋ yaah ho. Ali ɓo' inahɗi Kuɓki ɗal Baabi, te ali ɓo' inahɗi Baabi ɗal Kuɓki na ɓooɓi a waaɗ ɓa ɗe teeɓ. » ");
INSERT INTO sav_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋ ineem, Yeesu yurhiɗkohha na taalubeeciŋ ɗe, a woosa ɓa, ɓeɗ dong ne : « Ɗu neɓɗiɗ ŋ hoti ɗu hot in ci ɗu deg has. ");
INSERT INTO sav_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ñam na woyee ɗu ne woosuuɗ laayiɗ na buur laayiɗ waaɗeen hot ini ɗu na hote te ɓa hotɗaa, ɓa waaɗeen kerah ini ɗu na kerhe te ɓa kerahɗaa. » ");
INSERT INTO sav_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Raakka ƴaar nga, a nikee jangɗohoh yakak ŋ waasiŋMusaa, a kurukka, ne a markisuk Yeesu, a meekissa ɗe ne : « Jangɗohohi, ŋ joy ye haɓiɗ po ŋ min raak kipes ki heyɗi reehe ? » ");
INSERT INTO sav_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu loffa ɗe ne : « Wa ye fiisu ŋ waasiŋ Musaa ? Fu jang ye nga ? » ");
INSERT INTO sav_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ƴaara loffa ɗe ne « Waaɗa Kooh Heɗ fu na keeñiŋ ɗa jen, na ruuhiŋ ɗa jen, na hatiliŋ ɗa jen, na liiɓiŋ ɗa jen. Waaɗa morom fu findi fu waaɗoh haf fu. » ");
INSERT INTO sav_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu woosa ɗe ne : « Findi fu lofoh, wa ɗaa. Fu tumoh ɗaa ɗah, fu hey pese. » ");
INSERT INTO sav_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Waaye ƴaara waaɗta teeɓoh ne meeksohiŋ ɗe raakiɗ etoh, a woosa ne : « Ee, moo a ɓa morom mbo ? » ");
INSERT INTO sav_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu loffa ɗe ne : « Raakeen ƴaar, a pulohee Yerusalem a kaɗeeɗa Yeriko, a cohha na nguɗndukohoh ci, ɓa wolla ɗe, ɓa laɓpa ɗe po a taskohha kaan, ɓa faɗta ɗe ŋ ɗiska. ");
INSERT INTO sav_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wa hennda ƴaar ɓaah ŋ seeƴkiɗoh ci lahha ŋ waaseem, a hotta ɗe, a lahha ŋ ɓaka winooraŋ waasi. ");
INSERT INTO sav_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ƴaar ɓaah ŋ Lewiici, nammba taamb nga, a hotta ƴaari, a nammba tum ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Waaye ƴaar gen Samari ɓaaɓeeɗa, a raakka ƴaari nga, wi a hot ɗe, yeem misikka ɗe lool. ");
INSERT INTO sav_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A reɓpa nga ɗe, a ɓayya diwliin na biiñ, a tumiɗta ɗe ŋ gaañ ciŋ ɗe, a tokka ca na daah. Ƴutta a rapiɗta ɗe ŋ ɗoopti a ɓaye, a ɓayya ɗe ŋ kahna ɓaaɓoh ca na dalohe, a taambkohha ɗe. ");
INSERT INTO sav_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na ɓaaɓa, a eɗta ƴaari adgoh kahni kopor, a woosa ɗe ne : “ Taambkohiɗ to ƴaarii, te in nu fu ɓaat nga ɗah, ñam na hee ɗa wa dokne ne ŋ wiirkee ɗah. ” » ");
INSERT INTO sav_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Teemb ndeem Yeesu meekissa ƴaara ne : « Ŋ ini fu liiɓ, ya ɓa ngaŋ ƴaaɓi kaahay ceem, a yi morom ƴaari cohee na nguɗndukohoh ci ? » ");
INSERT INTO sav_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ƴaara loffa ɗe ne : « A ƴaari a misik. » Yeesu woosa ɗe ne : « Fu kaɗ ɗah, tuma findiice. » ");
INSERT INTO sav_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wa raakka mbeh, Yeesu na taalubeeciŋ ɗe kaɗeeɗa po ɓa aassa ŋ kur, ɓitiɓ geneen nga teeku Marta, a daliɗta ɗe ŋ kahan ce. ");
INSERT INTO sav_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A raakeen taambɗoh na woyse Mari, yeem ɓooffa ŋ ɗiska na Heɗ ɓoo Yeesu a sikɗukeeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Waaye Marta, e taambkohaŋ hanheeca laayɗa ambee ɗe. A hayya ŋ Yeesu, a woosa ɗe ne : « Kilifaani, fu hotoh inii na ? Taambɗoh ho faɗiɗ to kiik ko na pangki. Woyaa ɗe a amboh ho book. » ");
INSERT INTO sav_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Heɗ ɓoo Yeesu loffa ɗe ne : « Marta, Marta, in ci hondoh ɗa raak jam laayiɗ, ");
INSERT INTO sav_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","waaye in yino dong weɗi raak etoh. Mari kooɗ ini uup baah te wa nihsassanɗi nga ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wa raakka mbeh, Yeesu kiimeeɗa ŋ ɗisik, wa a ƴut, yino ŋ taalubeeciŋ ɗe woosa ɗe ne : « Kilifaani, Yahya Ɓoktohi jangɗiɗ taalubeeciŋ ɗe findi ɓa joy kiimoh ; nama teeɓ ɓoo findi ɓoo na hee kiimohe. » ");
INSERT INTO sav_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu woosa ɓa ne : « Ɗu kiimee Kooh ɗah, woyaat ne : “ Baab, tiikiŋ ɗa teyɗuksaat ne wa tiik hooliɗ. Nguuriŋ ɗa hayaat. ");
INSERT INTO sav_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mbeh nu nik ɗah, ona ɓoo kañam ki ɓoo etoh. ");
INSERT INTO sav_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɗaasa ɓoo bakaaɗ ciŋ ɓoo, laam ɓoo na name nam ɗaas ɓooɓi na ɗale ɓoo, te kina tum po ɓoo jaɗɗu fiir. ” » ");
INSERT INTO sav_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wa a jangiɗ ɓa ineem, a woyissa ɓa ne : « Wa mand na ɓo' nga ɗu raak nawle, a kaɗ nga ɗe ŋ ndengelnde wek, a woo ɗe ne : “ Naw, ɓand ndo mbuuru kaahay ndeem, ");
INSERT INTO sav_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ŋ raak hanhe ŋ kahan ndo, te ŋ raakɗi kañam ki ŋ eɗan ɗe. ” ");
INSERT INTO sav_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ŋ ineem ƴaara miniɗ ɗe lof ŋ ɗooƴ kahna ne : “ Faɗ to, ŋ rangkiɗ po ƴutiɗ, te mi na kuɓuuciŋ ngo ɓoo faankiɗ, ŋ minɗi kuruk ne ŋ eɗ ɗa. ” ");
INSERT INTO sav_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ñam woo ɗu wa, ƴaara hey kurke ne a eɗ ɗe ini a etoh jen. Ali a eɗɗi ɗe sagu niki a nik nawleece, a hey ɗe eɗe sagu kiima a kiimee te a supukɗi nga. ");
INSERT INTO sav_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ineem weɗ tah mi woo ɗu ne, kiimaat kiim ɗu hey onse, waakaat waak ɗu hey hote, laɓɗaat laɓiɗ ɗu hey rangsiɗasse. ");
INSERT INTO sav_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Laam ɓo' nu kiim ɗah, a hey onse, ɓo' nu waak ɗah, a hey hote, te ɓo' nu laɓiɗ ɗah, a hey rangsiɗasse. ");
INSERT INTO sav_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","A yinde baab nga ɗu, a yi kuɓkiŋ ɗe kiiman ɗe cuurund, a on ɗe iiñ ? ");
INSERT INTO sav_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mbaa a kiim ɗe wak, a on ɗe ndangal ? ");
INSERT INTO sav_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nik ne ɗu ɓi baahaaɗiici, e ɗu min on kuɓuuciŋ ɗu in baahiɗ ɗah, ŋ woyisɗi ɗa Baab Kooh yiŋ Eel ci. A onanɗi ɓi na kiimee ɗe Fuuɗsi Hoolohngaani e ? » ");
INSERT INTO sav_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wa raakka mbeh, Yeesu wiriɗta muum, ya jiini ambe. Jiinnda saɓsohu saɓsohu na ɗe, ƴaara jombeeɗa moɗoɗ, mboolnda nikee nga feyuusa. ");
INSERT INTO sav_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waaye raakka ɓa woyee ŋ ɓooɓa ne : « A Belsebul, kilifaaniŋ jiiniici na onee ɗe hatili a na aañohee ca. » ");
INSERT INTO sav_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Raakka ɓi markiskee ɗe, ɓa woyeeɗa ne, a teeɓaat ɓa firndeeni puloh ŋ Eel ci. ");
INSERT INTO sav_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Waaye Yeesu inahha liiɓ ciŋ ɓa, a woosa ɓa ne : « Ɓooɓi ɓaah nguur hiñohee ŋ harmban ɓa ɗah, nguureem hey keene, kahan cum keen ŋ ɗafuk cinooci. ");
INSERT INTO sav_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ɗu na woye ne mi na aañe jiiniici na hatiliŋ Belsebul ; nik ne a Seytaani paysukoh ŋ haf ce ɗah, kon nguuriŋ ɗe min na tufkoh ? ");
INSERT INTO sav_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nik ne mi na aañohe jiiniici hatiliŋ Belsebul ɗah, moo ɓooɓiŋ ɗu na namee ca aañ, ɓa na aañohee ca winde hatil ? Ineem weɗ tah ɓeɗ atte'an ɗu. ");
INSERT INTO sav_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Waaye nik ne mi na aañohe jiiniici hatiliŋ Kooh ɗah, kon Nguuriŋ-Kooh reyiɗ nga ɗu. ");
INSERT INTO sav_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɓo' raakiɗ hatil, ganaayuk, niiɗee kahan ce ɗah, raak-raakiŋ ɗe hey nike ŋ ɗisik wooriɗ. ");
INSERT INTO sav_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Waaye ɓoyi uupiɗ ɗe hatil raak ɗe nga laɓ ɗe ɗah, a hey naafee ganaay ci a oolkohe, a ɓay in ci a raakee jen, a paysoh ca. ");
INSERT INTO sav_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɓo' nu langɗi na so ɗah, a sangiɗ to ; te ɓo' nu nangɗohohɗi so ɗah, a na pasarohe. ");
INSERT INTO sav_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jiini, na hoolaaɗiikiŋ ɗe, a faɗta ɓo' ɗah, a na kaɗe ŋ ɓi ɗisik suyiɗ, a waakee ɗiski a iɗsiɗkohan. A hotɗi ɗah, a woo ŋ haf ce ne : “ Mi na hee dokke kahnaŋ ngo ŋ puloh. ” ");
INSERT INTO sav_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A wiiruk ɗah, a raak kahna paɗuuɗ, haɓɗuuɗ moɗoɗ. ");
INSERT INTO sav_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jaar a kaɗ waaka jiini yasna-kanak ci uup ɗe añaand ; ca kaɗ kahna, ca gen. Ŋ ineem, mirndohaaɗiŋ ɓoyeem weɗ na uupe misik fuuf findi a kocee mand. » ");
INSERT INTO sav_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wa Yeesu na woyee in ceem, ɓitiɓ ŋ ɗooƴ mboolnda woosa ŋ ɗafka ne : « Yaayi ɓasil ɗa, a ɓapiɗta ɗa, joyiɗ neɓu. » ");
INSERT INTO sav_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeesu loffa ɗe ne : « Woya kay ne, ɓooɓi na sikɗuke woo kiŋ Kooh, te ɓa pesohee wa, ɓeɗ neɓu. » ");
INSERT INTO sav_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ɓooɓa hayeeɗa, mboolnda ɓaatkeeɗa ; Yeesu woosa ne : « Ɓooɓi woti, ɓeɗ baahaaɗi, ɓa na meeksohe firnde, waaye ɓa eɗsanɗi ali firnde, ɗal wiŋ Yunus. ");
INSERT INTO sav_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Findi Yunus ŋ haf ce nikohee firnde nga ɓi Niniw,Kuɓkiŋ ɓoyi naman nikoh firnde ɗaa ngaŋ ɓooɓi woti. ");
INSERT INTO sav_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Buura ɓitɓaŋ Saba pulohee kur usiɗ ne a sikɗuk liiɓohaaɗa moɗɗaŋ Suleymaan. Te moona raakiɗ ini uup Suleymaan ŋ ndii, weɗ tah mbehi Kooh na hee atte'ohe ɓooɓi, buuri ɓitɓeem hey kurke, a teeɓ ɓooɓi woti ne ɓa raakɗi keeh. ");
INSERT INTO sav_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ŋ mbehaŋ atteena, ɓi Niniw hey kurke, ɓa teeɓ ɓooɓi woti ne ɓa raakɗi keeh, laam wa ɓi Niniw kerah woo kaŋ Yunus, ɓa ɓoƴsoheen pesohaaɗ keeh-keeh ; te moona ini nik ndii, weɗ uup Yunus. ");
INSERT INTO sav_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ali ɓo' na fuuɗeeɗi laampa po ƴut, a ɗembiɗa ɗisik wiiriis, wala a kuna na kanoh ; a degana kay ŋ degohaaniŋ wa ne ɓo' nu aas ɗah, wa ñiinɗiɗ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Has weɗ laampaaniŋ faan. Hasiŋ ɗa wir ɗah, faaniŋ ɗa jen na nikee ŋ siñaar, waaye hasiŋ ɗa wirɗi ɗah, faaniŋ ɗa jen na nikee ŋ ñuus. ");
INSERT INTO sav_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mbaa ndengɗuka po ñiini nik nga ɗa, nikuu ñuus. ");
INSERT INTO sav_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nik ne faaniŋ ɗa jen ñiiniɗ, te ali ɓak ñuusɗi nga ɗah, wa hey nikee leer po maa wa laampa ñiiniɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wa Yeesu na woye, ƴaar ŋ Farisen ca ɓeeɗukka ɗe ne a ñama ŋ kahan ce, Yeesu teyɗukka. Wa ɓa ñame, ");
INSERT INTO sav_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisena hotta ne Yeesu ɓohñukɗi findi ɓa na ɓohñukohe, a feyuusa nga. ");
INSERT INTO sav_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Heɗ ɓoo Yeesu woosa ɗe ne : « Ɗu ɓi Farisen ci, ɗu mand na ɓooɓi ɓohoñ finhooriŋ kaasi na booli ɓa faɗta ɗooƴi ; ŋ ɗooƴ keeñ ciŋ ɗu, ɗu riifiɗ na liiɓohaaɗ rok na añaand. ");
INSERT INTO sav_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Naandiɗ ci ! Kooh yi haɓiɗ finhoori, a yi nam haɓiɗ ɗooƴi haa e ? ");
INSERT INTO sav_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sarhohaat in ci nik ŋ ɗooƴi, ɗu hool jameet. ");
INSERT INTO sav_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mas ɗu ɓi Farisen ci, ɗu ɓii eɗoh sah in ci ƴin ƴin ci ɗu na guure findi naana, pooɓar, na in ci mand ɗaa ndaŋkiyaah nu nik yinoori ; waaye ɗu faɗiɗ ini uupiɗ etoh, weɗ yurah na waaɗ Kooh ; ineem weɗ ɗu joyee tum, te ɗu sang sagankoh ci tas. ");
INSERT INTO sav_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mas ɗu ɓi Farisen ci, ɗu waaɗ ne ɗu ɓoofan ŋ fiki ɓooɓi ngaŋ sinaagog ci te ɗu kañɗassee yaah kanak ŋ ɗisik ci na toonohse ŋ kur. ");
INSERT INTO sav_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mas ɗu ɓi Farisen ci, ɗu mand na ruy-ruy ci muuƴ, ɓooɓi inhuu dakee nga ca, wa ɓekee ɓa hoolaaɗi. » ");
INSERT INTO sav_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wa a kerah ineem, ƴaar ɓaah ŋ jangɗohoh caŋ waasiŋMusaa woosa ɗe ne : « Jangɗohohi, fu woyoh ɗaa ɗah, fu na namee ɓas ɓoo. » ");
INSERT INTO sav_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu loffa ne : « Na ɗu, ɗu ɓi jangɗohoh ciŋ waasi, ŋ masɗiɗ ɗu, laam ɗu na raane ɓooɓi in ɓitiɗ te ɗu waaɗɗi ca sah laal na lecem ndukun. ");
INSERT INTO sav_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋ masɗiɗ ɗu, e ɗu na taɓahe ruy-ruy ciŋ woosuuɗ ci te a caac ciŋ ɗu ap ɓa. ");
INSERT INTO sav_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ŋ ineem, ɗu na teeɓohe ne ɗu huniɗ ŋ in ci caac ciŋ ɗu tum. Ee di' ! Ɓeɗ ap woosuuɗ ci, ɗu taɓahee ruy-ruy ciŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ineem weɗ tah, Kooh, ŋ moɗkiŋ ɗe liiɓohaaɗ, a woosa ne : “ Ŋ hey woosohe woosuuɗ na Apootar ; ɓum apu, ɓinooɓi tumu miskiɗ. ” ");
INSERT INTO sav_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te ɓooɓi woti ɓeɗ na hee wirndiɗkasse ñif miŋ woosuuɗ ci aamu ŋ ina amboh ŋ cambohaaɗa poyi. ");
INSERT INTO sav_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ŋ Abel po ŋ Sakariya, yi ɓa apoh Kahan Kooh, ŋ harmban seeƴkohaana na taɓaha. Ñam na woyee ɗu wa, in ceem jen Kooh na hee ca wirnduke ngaŋ ɓooɓi woti. ");
INSERT INTO sav_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mas ɗu ɓi jangɗohoh ciŋ waasi, ɗu ambiɗ caaɓndi joy rangis findi in ciŋ Kooh inhohsan ; ɗu ŋ haf ɗu, ɗu aasɗi te ɗu sangohiɗ ɓooɓi waaɗ aas. » ");
INSERT INTO sav_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wa Yeesu pul kahna, jangɗohoh caŋ waasi na Farisen ca ayrukka ɗe, ɓa cammba ɗe meekis meeksoh laayiɗ ");
INSERT INTO sav_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ne ɓa raak yambaah ɗe. ");
INSERT INTO sav_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ŋ jamanooneem, ɓo' laayiɗ coheen ne ɓa sikɗuk Yeesu ; mboolnda laayya laay po ɓa daktiɗoheeɗa. Yeesu kockoh ŋ taalubeeciŋ ɗe, a woosa ɓa ne : « Wortukaat naafeehaakiŋ Farisen ci, wa mand na lawiir. ");
INSERT INTO sav_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","In nu ɗembɗu ɗah, wa hey teeɓohse te in nu ɗemb ɗah, wa hey inhasse. ");
INSERT INTO sav_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kon in nu ɗu woo na wek ɗah, wa hey kerhasse noh cong ; te in nu ɗu moondɗoh ŋ nof ŋ ɗooƴ tuuƴ ɗah, wa hey leehkasse ŋ ɗafuk taɓah ci. ");
INSERT INTO sav_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ñam na woyee ɗu ne, ɗu ɓi nawleeciŋ ngo, kinaat nup ɓi min top dong ngaŋ ap faan. ");
INSERT INTO sav_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋ hey ɗu teeɓe ya ɓa a yi ɗu joy nup : Nupaat Kooh yi min ɗu ɓek ŋ yongkaaha, ne ɗu apu po ƴut ɗah. Ee, ñam na woyee ɗu ne, a yi ɗu joy nup. ");
INSERT INTO sav_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sel ƴin yatuus na toonohseeɗi daram kanak dong e ? Moona deey, Kooh alɗi yino nga ca. ");
INSERT INTO sav_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te a inhiɗ sah findi find ciŋ haf ciŋ ɗu hend, mbaa kanaat neƴƴoh ! E ɗu uupiɗ juuk sel njiriñ. » ");
INSERT INTO sav_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yeesu ɓaatta nga ne : « Ñam na woyee ɗu ne, ɓo' nu woo ŋ fiki ɓooɓi ne a ɓaah nga so ɗah, mi yi Kuɓkiŋ ɓoyi ŋ hey name woo ŋ fiki malaakaaciŋ Kooh ne ɓoyeem ɓaah nga so. ");
INSERT INTO sav_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Waaye ɓo' nu taasuk ko ŋ fiki ɓooɓi ɗah, a hey name taasku ŋ fiki malaakaaciŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɓo' nu woo in moɗaaɗi ŋ Kuɓkiŋ ɓoyi ɗah, a ɗaasnuk ɗah, a hey ɗaasse ; waaye ɓo' nu woo in moɗaaɗi ŋ Fuuɗsi Hoolohngaani ɗah, a ɗaassanɗi. ");
INSERT INTO sav_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ɓa ɓay ɗu ŋ sinaagog ca, wala ŋ fiki kilifaaca ne ɓa attee ɗu ɗah, kinaat feyu ŋ findi ɗu joy ngeloh, ");
INSERT INTO sav_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","laam Fuuɗsi Hoolohngaani, hey ɗu teeɓe ndeem ini ɗu joy woo. » ");
INSERT INTO sav_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋ ɗooƴ mboolnda raakka ƴaara woo Yeesu nga ne : « Jangɗohohi, woya taambɗoh ho, ɓoo paysoh lamaahi baab ɓoo faɗiɗ ɓoo. » ");
INSERT INTO sav_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu loffa ɗe ne : « Ƴaariŋ ngo, ya ɓa tum mbo atte'ohiŋ ɗu, po ŋ joyya ɗu paysoh raak-raak kiŋ ɗu ? » ");
INSERT INTO sav_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A woosa ɓooɓa jen ne : « Wortukaat, kinaat waaɗ raak kopor in hend na cakna mboɓ, laam kipes ɓo' nikɗi ŋ ini a raak, ali a raakoh na ! » ");
INSERT INTO sav_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Weɗi Yeesu naandsukoh ɓa andiinii : « A nikee heɗ raak-raak, yohon ciŋ ɗe laaɓpa keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A woosa ŋ haf ce ne : “ Ŋ joy ye haɓiɗ ? Ŋ raakɗi ɗiski ŋ min ɗaak laaɓɗiŋ ngo jen. ” ");
INSERT INTO sav_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A woyissa ne : “ Seka, inii weɗ mi na hee tume : Mi na hee nihse ndap ciŋ ngo cii, ŋ haɓiɗ ci uup ca yak, ŋ ɓek laaɓɗiŋ ngo nga, na in ciŋ ngo cinooci. ");
INSERT INTO sav_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ƴut ɗah, ŋ woo ŋ haf fo ne : ‘Ƴaari, fu ɗaakkiɗ laayiɗ, pesoha ɓi kiisi kiis. Ɗiski wa nik, iɗsiɗka, fu ñame, fu ane, fu neɓsiɗke.’ ” ");
INSERT INTO sav_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Waaye Kooh woosa ɗe ne : “ Naandɗi ! Ŋ weki woti, ŋ hey ɓaye kiñin kiŋ ɗa. Moo, ya ɓa raakan ɗaakkiŋ ɗa kotii ? ” » ");
INSERT INTO sav_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu ɓaatta nga ne : « Ɓoyi na waake raak-raak a nangɗohe, te a raakɗi ali in ŋ Kooh, a in mand ɗaa rahsan ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ƴutta, Yeesu woosa taalubeeciŋ ɗe ne : « Weɗ tah mi na woyee ɗu ne, kinaat jaahiɗ ŋ kipes ki, ŋ ini ɗu ñaman. Kinaat jaahiɗ ŋ faan ciŋ ɗu, ŋ ini ɗu ɓekkan. ");
INSERT INTO sav_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Laam kipes weɗ uup kañam, te faan weɗ nam uupiɗ ɓekkaah njiriñ. ");
INSERT INTO sav_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Markaat ngaak-suur ci, ca na sokeeɗi, ca na nguɗeeɗi, ca raakɗi ɗaakkoha, ca raakɗi ndap ; waaye Kooh yii ñamiɗ ca, te a ɗu uupiɗ sel ci njiriñ. ");
INSERT INTO sav_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ya ɓa min jaahiɗ nga ɗu, po a ɓaat wahtu ŋ kipes kiŋ ɗe ? ");
INSERT INTO sav_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nik ne ini ƴissuuteem, ɗu minɗaa ɗah, wa ye tah ɗu feyse ŋ in ci cinooci ? ");
INSERT INTO sav_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Markaat pos ciŋ paangiici findi ca na mande : Ca na pangkeeɗi, ca na teɗeeɗi ; ñam na woyee ɗu ne Suleymaan sah, na ina a raakee jen, a moosɗi raakoh kulɓa mand na yino nga ca moɗ. ");
INSERT INTO sav_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kosi ɗu kos ƴissuutiɗ ! A Kooh na ɓekɗe paangfi ɓekɗi moɗɗeem woti, ali nik ne kim sah, wa miniɗ dohu. Kooh tumiɗ paangfi ineem ɗah, ŋ woyisɗi ɗu, ɗu ɓi uupiɗa njiriñ. ");
INSERT INTO sav_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kinaat feyu ŋ ini ɗu ñaman, wala ini ɗu na hee ane. ");
INSERT INTO sav_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","E ɓooɓi inahɗi Kooh na gene waak in ceem, waaye Baabiŋ ɗu inhiɗ ne ɗu etohiɗ ca. ");
INSERT INTO sav_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mbaa ɗah, waakaat ini na kaɗɗe Nguuriŋ ɗe fiki, a hey ɗu wa one, a ɓaatiɗ ɗu cinooci nga. » ");
INSERT INTO sav_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeesu ɓaatissa nga ne : « Ɗu ɓi gatiŋ ngo, ɗu laayɗi, waaye kinaat neƴƴoh, wa neɓiɗ Kooh ne a ɓaahndoh ɗu ŋ Nguuriŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Toonaat ini ɗu raak, ɗu eɗa ñakiɗ ci, weɗ ne ɗu waak ɗaakkoha minaaɗi yahuk, ɗu nangɗoh raak-raak ŋ Eel ci ; wa heyɗi reehe, wa roksanɗi, te wa ñuhkanɗi. ");
INSERT INTO sav_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Laam ɗiski raak-raakiŋ ɗu nik, keeñ ciŋ ɗu na name nik nga. » ");
INSERT INTO sav_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yeesu woyissa taalubeeciŋ ɗe ne : « Tokɗukaat, te laampaaciŋ ɗu kanaat ƴim. ");
INSERT INTO sav_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mandaat na ñaam ci na seke heɗ ɓa yi joy wiirkoh ŋ kilook, ne a laɓɗee rek ɗah, ɓa rangsiɗ ɗe buntaani. ");
INSERT INTO sav_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wa hey neɓe ŋ ñaam ceem, ne heɗ ɓa hay, raak ɓa sekee ɗe ɗah. Ñam na woyee ɗu wa te wa keeh, a hey ɓekke kulɓa pangkoha, a ɓoofiɗ ñaam ciŋ ɗe, a noɗɗee ɓa, ɓa ñame. ");
INSERT INTO sav_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ali a hay ŋ ndengelnde wek wala ŋ wiisaaɗi, a raak ɓa sekee ɗe ɗah, wa hey neɓe nga ɓa. ");
INSERT INTO sav_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Inhaat ne, heɗ kahni inheen wahtuuni roki na hee aasohe kahan ce ɗah, a heeɗi ɗe faɗe a aas. ");
INSERT INTO sav_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɗu, namaat kooɗuk, laam Kuɓkiŋ ɓoyi hayan ŋ jamanooni ɗu liiɓɗi. » ");
INSERT INTO sav_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Weɗi Piyeer woyoh ɗe ne : « Kilifaani, fu na woye na ɓoo ŋ andiinii, wala na mboolndi jen ? » ");
INSERT INTO sav_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yeesu Heɗi woosa ɗe ne : « Ya ɓa a yi ñaami woor, te a ñaannja po, heɗ ce hee ɓaaɓe ɗah, a nak ɗe niiɗɗu kahan ce ne a eɗee pangkoh ciŋ ɗe ɓinooɓi kañam ŋ jamanooniŋ wa ? ");
INSERT INTO sav_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ñaameem hey neɓɗe ne heɗ ce hay, raak ɗe tumee ineem findi a nakohee ɗe wa ɗah. ");
INSERT INTO sav_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ñam na woyee ɗu wa te wa keeh, heɗ ce hey ɗe tufkiɗe, a adgoh in ciŋ ɗe jen. ");
INSERT INTO sav_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Waaye ñaameem woo ŋ ɗooƴ ce ne heɗ ce hayɗi paaɗ, a nik nga a laɓee ñaam ci ɓinooɓi, ƴaar na ɓitiɓ, a ñame, a ane, a laaree ɗah, ");
INSERT INTO sav_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","heɗ ce hey haye ŋ mbehi a foogɗi, ŋ wahtuuni a inahɗi, a hey ɗe mbugale, a tum ɗe findi ɓooɓi kerhaaɗi-woo ci na tumse. ");
INSERT INTO sav_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ñaami inah ini heɗ ce waaɗ, a sannga wa tum, te a kooɗkiɗɗi hayiŋ heɗ ce, a hey laɓse ndooɗ laayiɗ. ");
INSERT INTO sav_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Waaye ñaami inahɗi ini heɗ ce waaɗ, te a tum ini a joy laɓohu ɗah, a hey laɓse ƴissuut. Ɓo' nu eɗu in laayiɗ ɗah, a hey meeksasse in laayiɗ ; ɓoyi uup dengkohu, a yi uupan meeksu. » ");
INSERT INTO sav_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeesu woosa ne « Ŋ hayiɗ Adina ne ŋ tum yongkaah nga, te ŋ waaɗeen lool ne wa nik fuuɗuuɗ po ƴutiɗ. ");
INSERT INTO sav_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɗiski wa nik ndii, ŋ joyiɗ hooƴu ŋ miskiɗ keeh-keeh, te ŋ raakanɗi jam po mbaɗna wa nikan. ");
INSERT INTO sav_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɗu liiɓiɗ ne ŋ hay ne ŋ ɓay jam ŋ Adina e ? Muk ! Ŋ ɓay saɓsukoh. ");
INSERT INTO sav_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ini camboh woti, ɓo' yatuus nik ŋ fah ɗah, ɓa hey saɓsukohe ; kaahay ci sang kanak ci, kanak ci sang kaahay ci. ");
INSERT INTO sav_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baab sang kuɓu ƴaar, kuɓu ƴaar sang baab ; yaay sang kuɓu ɓitiɓ, kuɓu ɓitiɓ sang yaay ; payum ɓitiɓ sang kilook, kilook sang payum ɓitiɓ. » ");
INSERT INTO sav_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeesu woyissa mboolnda ne : « Ɗu hotta ngaaɓ ɗah, ɗu na jaare woo ne : “ Wa hey toɓe ” te weɗ na raake. ");
INSERT INTO sav_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sarngi laɓ ɗah, ɗu woo ne : “ Wa hey dohe ” te weɗ na raake. ");
INSERT INTO sav_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Naafeehaaci ! Ɗu marak eel ci na kehƴi ɗah, ɗu inah ini na hee raake ; kon ɗu min na inhaaɗi'oh findi Kooh na pangkohe woti-woti ? ");
INSERT INTO sav_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wa ye tah po ɗu ɗuunnga ini yurhiɗi joy haɓɗu ? ");
INSERT INTO sav_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɓo' ɓayee ɗa waas ɗah, jeema kerhiɗoh na ɗe. Fu tumɗaa ŋ waasi po ɗu ree ngelohaana ɗah, a hey ɗa fase po ŋ atte'ohi, yeem eɗ ɗa alkaateeni, yeem rang ɗa ŋ kasoona. ");
INSERT INTO sav_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ñam na woyee ɗa ne, fu pulohanɗi ndaam feeh fu wirindɗi po ŋ darmi uup ƴissuut ɗah. » ");
INSERT INTO sav_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ŋ jamanooneem, ɓi ɓo' naandsukka Yeesu findi Pilaat apoh ɓi ɓo' gen Galile wa ɓa seeƴkee wuu Kooh. ");
INSERT INTO sav_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeesu loffa ɓa ne : « Ɗu liiɓ ne ɓooɓeem ɓeɗ uupiɗ bakaaɗ ŋ Galile sagu miskiɗi ɓa raak weem e ? ");
INSERT INTO sav_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Muk ! Waaye ñam na woyee ɗu ne, ɗu ɓoƴsohɗi kipes ɗah, ɗu hey name boomu jen findiiɓa. ");
INSERT INTO sav_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te ɓooɓa ndaŋkiyaah na yasna-kaahay (18) ca, taɓaha yakka ŋ Silowe keenee nga ɓa, ɓa kaannda, ɗu liiɓ ne ɓeɗ uupee nik bakaaɗoh ŋ Yerusalem jen e ? ");
INSERT INTO sav_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Muk ! Waaye ñam na woyee ɗu ne, ɗu ɓoƴsohɗi kipes ɗah, ɗu hey name boomu jen findiiɓa. » ");
INSERT INTO sav_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeesu naandsukka ɓa andiinii : « Ƴaar raakeen ndun ŋ yohon ce. Wa a kaɗa ɓeena, a raakɗi ali rim nga. ");
INSERT INTO sav_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A woosa ƴaara na pangkiɗee ɗe ŋ yohna ne : “ Kiis kaahay ceɗɗi, ŋ hayya ɓeene ŋ ndunii ɗah, ŋ raakuu rim nga. Ƴoɓaa ! Wa joyɗi naaf ɗiski ŋ ɓarang ɓarang. ” ");
INSERT INTO sav_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ƴaara loffa ɗe ne : “ Kilifaani, faɗaa kiis kii ; ŋ hey bongɗe tasiŋ wa, ŋ tuma kotar. ");
INSERT INTO sav_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Miniɗ nik ne wa hey rime ; wa rimɗi ɗah, fu ƴoɓɗuka. ” » ");
INSERT INTO sav_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wa nikee ŋ mbehi na iɗsiɗkohse, Yeesu jangɗoheeɗa ŋ sinaagoga. ");
INSERT INTO sav_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɓitiɓ nikeen nga, a njuuƴee njuuƴ, a mineeɗi jaɗtuk delem, a jiini ambee ɗe. A tumiɗ na kosaay keem kiis ndaŋkiyaah na kiis yasna-kaahay (18). ");
INSERT INTO sav_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wa Yeesu hot ɗe, a ɓeeɗukka ɗe, a woosa ɗe ne : « Ɓoyi, fu saɓsohuuɗ na kosaay kiŋ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A degga ɗe yaah ciŋ ɗe, ŋ ɗiska ɗiska ɓoya jaɗtukka, a yakɗeeɗa Kooh. ");
INSERT INTO sav_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Waaye ƴaara adgohee sinaagoga ayrukka ŋ ini Yeesu wiriɗ ɓitɓa ŋ mbehi na iɗsiɗkohse, a woosa mboolnda ne : « Neeh yasna-yino ceɗ na pangkohse. Hayaat nga ca ɗu paƴuk, waaye ŋ mbehi na iɗsiɗkohse haa. » ");
INSERT INTO sav_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Heɗ ɓoo Yeesu loffa ɗe ne : « Naafeehaaci ! Ŋ mbehi na iɗsiɗkohse ya ɓa na tokseeɗi inoh fiŋ ɗe wala mbaamiŋ ɗe ŋ ɗiska a toku ne a kaɗ ɗe anɗa ? ");
INSERT INTO sav_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ŋ hot ɓitɓii ɓaah ŋ ɓi rimkoh ŋ Ibrahiima, te Seytaani jatngiɗ ɗe kiis ndaŋkiyaah na kiis yasna-kaahay (18) ; wa ye joy tah po a toksassanɗi ŋ mbehi na iɗsiɗkohse ? » ");
INSERT INTO sav_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Woo kiŋ Yeesu weem tahha po ɓi sang ɗe ñaarra, waaye mboolnda neɓuusa ŋ in ca feyohiɗ ca baahiɗ ca a tumee jen. ");
INSERT INTO sav_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeesu woyissa ne : « Hayaat ŋ teeɓ ɗu Nguuriŋ-Kooh findi wa mand na ini ŋ mina mandtiɗkoh. ");
INSERT INTO sav_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wa mand na inii : A nikee ɓo', a ɓayya kuɓu mutarda, a sokkaa ŋ yohon ce, wa paarra, wa nikka kidig po sel ci taarra ŋ naak ciŋ wa. » ");
INSERT INTO sav_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu woyissa ne : « Ŋ min mandtiɗohis Nguuriŋ-Kooh na ye ? ");
INSERT INTO sav_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wa mand na findi ɓitiɓ na ɓayohee lawiir a siiɓa na kanoh mun kaahay ; ƴut ɗah, ini siiɓuuɗi jen guuf. » ");
INSERT INTO sav_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kaɗaŋ Yeesu Yerusalem, a taambee ŋ kur ci yakak ci na ci ƴin ci, a jangɗoheeɗa. ");
INSERT INTO sav_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Raakka ƴaara meekis ɗe ne : « Kilifaani, ɓooɓi na hee mucɗasse, ɓa hey laaye e ? » Yeesu loffa ɓa ne : ");
INSERT INTO sav_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« Ndengɗukaat ɗu aasoh yahndeeri ɓengiɗi, laam ñam na woyee ɗu ne, ɓi ɓo' laayiɗ hey jeeme aas, waaye ɓa heyɗaa mine. ");
INSERT INTO sav_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te jamanooni heɗ kahni na hee kurkohe ne a rang buntaani, ɗu ɓi wa raakan ŋ hara, ɗu hey nike nga, ɗu laɓɗee buntaani, ɗu woyee ne : “ Heɗi, rangsiɗa ɓoo ! ” A hey ɗu lofe ne : “ Ŋ inahɗi ɗiski ɗu kurkoh. ” ");
INSERT INTO sav_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ŋ ineem ɗu hey woye ne : “ Moo ɓoo ñamiɗ na ɗa, ɓoo aniɗ na ɗa te fu jangɗohiɗ ŋ mbeeddaaciŋ ɓoo ! ” ");
INSERT INTO sav_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A hey ɗu lofisse ne : “ Ŋ inahɗi ɗiski ɗu kurkoh, usaat to, ɗu ɓi tumoh bakaaɗ ci jen. ” ");
INSERT INTO sav_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Teemb ndeem, ɗu hey hote Ibrahiima, na Isaahha, na Yaŋhooɓa na woosuuɗ ci jen ŋ ɗooƴ Nguuriŋ-Kooh, ɗu mbetu ŋ hara, ɗiska fuɗ na ɗoɓɗoh sis raak. ");
INSERT INTO sav_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓooɓi hey pulohe ŋ ɓak ci jen, ɓa ɓoof ŋ Nguuriŋ-Kooh ne ɓa ñam kañam ka yakka. ");
INSERT INTO sav_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Raakiɗ ɓooɓi mirndoh woti, ɓeɗ na hee adge ; te raakiɗ ɓi adug woti, ɓeɗ na hee mirndohe. » ");
INSERT INTO sav_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Teemb ndeem, ɓi ɓo' ɓaah Farisen ca hayya ŋ Yeesu, ɓa woosa ɗe ne : « Kurka ndii fu coot laam Herod na waaɗee ɗa ap. » ");
INSERT INTO sav_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeesu loffa ɓa ne : « Kaɗaat ɗu woya ɓaakoɓeem ne, mi yii saɓsoh ɓooɓi na jiiniici te mi yii wiriɗ kosaayiɗ ci woti na kim, faaha kim ŋ hey ɗiindohe ini ŋ hay ne ŋ haɓiɗa. ");
INSERT INTO sav_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ŋ joyiɗ taalndiɗ waasiŋ ngo woti na kim na faaha kim, woosuuɗ apohsuu ŋ ɗiski nikɗi Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Cey Yerusalem, fu yi na ape woosuuɗ ci, fu tapee ɓooɓi fu na woosohse atoh po ɓa kaan, waas hend na weɗ ŋ waaɗ nangɗoh kuɓuuciŋ ɗa findi pambi na nangɗohe ƴiil ciŋ ɗe ŋ ooɓ ce, waaye ɗu moosɗi waaɗoh ! ");
INSERT INTO sav_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Weɗ tah ɗu hey faɗse na kahan ɗu, te ñam na woyee ɗu wa, ɗu hotissanɗi so po mbaɗna ɗu na hee woye ne : “ A barke'iɗ, yi na haye ŋ tiikiŋ Heɗ ɓoo ! ” » ");
INSERT INTO sav_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wa nikee ŋ mbehi na iɗsiɗkohse, Yeesu ɓeeɗkuusa kañam ŋ kahan kilifa Farisen. Wa a ree, ɓooɓa ŋ ɗiska feerkeeɗa ɗe baahiɗ. ");
INSERT INTO sav_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ƴaar na faan riifɗiɗ nikka ŋ fikiice. ");
INSERT INTO sav_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu meekissa Farisen ca na jangɗohoh caŋ waasiŋMusaa ne : « Andi waasi teyɗohiɗ ne ɓo' wiriɗ kosaayiɗ ŋ mbehi na iɗsiɗkohse wala ? » ");
INSERT INTO sav_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Waaye ali ɓo' lofɗi ɗe ; a ɓayya kosaayɗa, a wiriɗta ɗe, a woosa ɗe ne a kaɗaat. ");
INSERT INTO sav_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ƴutta, Yeesu woosa ɓa ne : « E ya ɓa nga ɗu, a yi kuɓkiŋ ɗe wala inoh fiŋ ɗe keenan ŋ naac ŋ mbehi na iɗsiɗkohse, a jaaruu ɗe puliɗ ? » ");
INSERT INTO sav_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ali ɓo' minɗi ɗe lof ŋ woo keem. ");
INSERT INTO sav_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ŋ ineem, Yeesu hotta findi ɓooɓa ɓeeɗku kañam tansukohee ɗisik ci uup baah ne ɓa ɓoof nga, a jangiɗta ɓa inii : ");
INSERT INTO sav_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« Ɓo' ɓeeɗuk ɗa kañam kilook ɗah, kina kaɗ fu ɓoof ŋ ɗiski uup baah ; miniɗ nik ne ɓoyi uup ɗa eɗu cir namiɗ ɓeeɗku nga. ");
INSERT INTO sav_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ƴaari ɓeeɗuk ɗu, a hay ɗah, a hey ɗa woye ne : “ Ona ƴaarii, a ɓoof. ” Teemb ndeem fu hey kee ɓoofa ŋ finhoora finhoora, ŋ ineem fu hey njoofe. ");
INSERT INTO sav_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Waaye fu ɓeeɗku kañam ŋ kilook ɗah, kaɗa fu ɓoofa ŋ finhoora. Ƴaari ɓeeɗuk ɗa hay ɗah, a hey ɗa woye ne : “ Ƴaariŋ ngo haya, fu ɓoof ŋ fikiiri. ” Teemb ndeem, a hey ɗa yakɗe ŋ fiki ɓooɓi fu ɓoof na ɓa jen. ");
INSERT INTO sav_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Laam ɓo' nu meeɓ haf ce ɗah, a hey ruhsiɗasse, te ɓo' nu ruhsiɗ haf ce ɗah, a hey meeɓse. » ");
INSERT INTO sav_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ƴutta, Yeesu woosa ƴaara ɓeeɗkee ɗe kañam ne : « Fu eɗohee ñakit wala ñamsuk ɗah, kana ɓeeɗuk nawleeciŋ ɗa, taambɗoh ciŋ ɗa, ɓaah ciŋ ɗa wala raakiɗ ci fu gen na ɓa ; ɓa miniɗ ɗa nam ɓeeɗuk ne ɓa wirind ɗa ineem. ");
INSERT INTO sav_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Waaye fu eɗohee kañam ɗah, ɓeeɗka ñakiɗ ci, na ɓeendkiɗ ci na lafñiɗ ci na fuuliɗ ci. ");
INSERT INTO sav_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ɓa minanɗi ɗa wa wirind, a Kooh na hee ɗa wa wirnde ŋ mbeha aa hee hultiɗohe yurhiɗ ci, tahha po fu hey sume. » ");
INSERT INTO sav_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ƴaar ngaŋ ɓa ñamee na Yeesu kerahha ineem, a woosa ɗe ne : « Ɓoyi na hee ñame ŋ kañam kiŋ Nguuriŋ-Kooh, a hey sume. » ");
INSERT INTO sav_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeesu loffa ɗe ne : « Ƴaar gapeen ɓo' laayiɗ kañam keeh-keeh. ");
INSERT INTO sav_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wi kañam ki ƴut, a woosa ñaamiŋ ɗe ne a kaɗaat ɓeeɗka ƴaaɓa. ");
INSERT INTO sav_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yaa nu nga ɗah, waakka naafkoha ; ya koc woosa ne : “ Woya kilifaaniŋ ɗa ne, ŋ han rom yohon te ŋ joyiɗa kaɗ marka, a ɗaasaat to. ” ");
INSERT INTO sav_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ƴaar wiiriis woosa ɗe ne : “ Ŋ rom inoh ndaŋkiyaah, ceɗ ŋ waaɗ kaɗ marka andi ca hey mine guur, a ɗaasaat to. ” ");
INSERT INTO sav_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Raakka ya woo ɗe ne : “ Ŋ han kilook ɓitiɓ, weɗi tah po ŋ minanɗi hay. ” ");
INSERT INTO sav_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ñaama wiirukka ŋ kilifaaniŋ ɗe, heɗ kahni, a woosa ɗe in ceem jen ; yeem ayrukka, a woosa ñaami ne : “ Ara kaɗ ŋ cohohaaci na mbeeddaaci, fu haytoh ñakiɗ ci, na ɓeendkiɗ ci na fuuliɗ ci na yiiɓoh ci. ” ");
INSERT INTO sav_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wi a kaɗ po a hayya, a woosa kilifaani ne : “ Ini fu nakohee haɓɗuuɗ, waaye kahni ris riifɗi. ” ");
INSERT INTO sav_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Heɗ kahni woosa ɗe ne : “ Kaɗa ŋ waas ca na yohon ca, ɓo' nu fu hot ɗah, tuma po a hay, ne kahni riif. ");
INSERT INTO sav_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ñam na woyee ɗu wa, ali ɓo' ƴoohanɗi ŋ kañam ki ngaŋ ɓooɓa ŋ koc ɓeeɗuk ! ” » ");
INSERT INTO sav_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yeesu kooɗissa waasiŋ ɗe, mboolo laayiɗ hunnda na ɗe, a yurhiɗkohha na ɓa, a woosa ɓa ne : ");
INSERT INTO sav_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« Ɓo' nu waaɗ hay nga so ɗah, a joyiɗ to waaɗ waaɗi uup wi a waaɗ baab ɓa na yaay ɓa, ɓitiice, kuɓuuciŋ ɗe, taambɗoh ciŋ ɗe, po haf ce sah, wala a minanɗi nik taalubeeniŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɓo' nu degukɗi kurwaani a joy daaƴohu, a ñaakee nga so ɗah, a minɗi nik taalubeeniŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɓo' nga ɗu waaɗ tufkiɗ taɓah jimimim ɗah, a ɓoofanɗi, a marak, a kind ini a raak, andi wa heya mine reehiɗ e ? ");
INSERT INTO sav_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A tumɗi ineem, a yipa po ƴut, a minuu wa kurkiɗ ɗah, ɓooɓi na hee wa hote hey ɗe ƴene ; ");
INSERT INTO sav_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ɓa woyee ne : “ Ƴaari cambiɗ taɓahi waaye a minɗaa reehiɗ ! ” ");
INSERT INTO sav_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A yinde buur na hee raake hiñohoh junni-ndaŋkiyaah (10.000) a kee aasa ŋ hiñoh na buur morom ce ya raak hiñohoh junni-ndaŋkiyaah-kanak (20.000) te a ɓoofuu a marak andi ɓiŋ ɗe hey mine ɓaŋ buura na hee ɗe keene ? ");
INSERT INTO sav_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A hot ne a minɗaa ɗah, a hey woosohe ŋ buura yinoora ŋ ɗiska a nik, a meekis ɗe ini a waaɗ ne jam raak. » ");
INSERT INTO sav_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yeesu degga nga ne : « Wa mand ɗaa, ali ɓo' minɗi nik taalubeeniŋ ngo nga ɗu, ne a faɗɗi in ci a raak jen ɗah. ");
INSERT INTO sav_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ee, meɗa, wa in baahiɗ, waaye meɗa kaɗ po wa jemisɗi ɗah, wa min jemɗohissu na ye ? ");
INSERT INTO sav_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wa raakiɗɗi kehƴi njiriñ te wa minanɗi kotar, wa hee hey mbetse. Ɓo' nu raak nof kerhoha ɗah, a kerhaat. » ");
INSERT INTO sav_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Juuti'oh ca jen na bakaaɗoh ca ɓinooɓa reɓeeɗa ŋ Yeesu ne ɓa sikɗuk ɗe. ");
INSERT INTO sav_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Waaye Farisen ca na jangɗohoh caŋ waasiŋMusaa ñukumsukeeɗa ŋ harmban ɓa, ɓa woyeeɗa ne : « Ƴaarii deey, a teyɗukiɗ bakaaɗoh ci, a na ñame ñam na ɓa. » ");
INSERT INTO sav_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Weɗi Yeesu woyoh ɓa andiinii : ");
INSERT INTO sav_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« Ɓo' nga ɗu, raak mbaal teemet (100), yino muuƴ nga ɗah, andi a faɗanɗi ca tas jen ŋ bilaf fa, a kaɗ ɗe waaka po a hot ɗe ? ");
INSERT INTO sav_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A hot ɗe ɗah, a hey sume, a deg ɗe ŋ yuug ciŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a haad. A ree kahna ɗah, a ɓeeɗuk nawleeciŋ ɗe na gentoh ciŋ ɗe, a woo ɓa ne : “ Ɓaahaat neɓɗii na so, ŋ hotiɗ mbaaliŋ ngo muuƴe. ” ");
INSERT INTO sav_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ñam na woyee ɗu ne wa nam mand ɗaa ngaŋ ɓi nik ŋ Eel ci ; bakaaɗoh yino ɓoƴsoh pesohaaɗ ɗah, ɓa hey sume nga sumi uup wi ɓa suman ŋ ɓo' ndaŋkiyaah-yasna-nikiis na yasna-nikiis (99) ɓi yurah te ɓa etohɗi ɓoƴsoh pesohaaɗ. ");
INSERT INTO sav_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wala ɓitiɓ raak hanjar \"darakma\" ndaŋkiyaah, yino muuƴ nga ɗah, andi a fuuɗanɗi laampa, a paɗee, a waakee ɓak nu ɓak ŋ kahni po a hota ? ");
INSERT INTO sav_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A hota ɗah, a ɓeeɗuk nawleeciŋ ɗe na gentoh ciŋ ɗe, a woo ɓa ne : “ Ɓaahaat neɓɗii na so, ŋ hotiɗ darakmaaniŋ ngo muuƴe. ” ");
INSERT INTO sav_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ñam na woyee ɗu ne wa nam mand ɗaa ngaŋ malaakaaciŋ Kooh ; bakaaɗoh yino ɓoƴsoh kipes ɗah, ɓa sum nga. » ");
INSERT INTO sav_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu degga nga ne : « Ƴaar raakeen kuɓu ƴaar kanak. ");
INSERT INTO sav_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mbeh, yi uup ƴin nga woosa ɗe ne : “ Baab, eɗ to ɓakiŋ ngo ŋ ini ɓoo joy lam. ” Baab ɓa paysohha ɓa raak-raak kiŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wa degga ɓi neeh, a yi ƴini, a ɓoƴissa ina a raakee jen kopor, a kaɗta naa ŋ kur usiɗ, a yahrohhaa ndaam ŋ nikohaaɗ sepƴiɗ. ");
INSERT INTO sav_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wa a yahroha po wa reehha, aɗ miskiɗ raakka ŋ kur kaam, a cammba ñak. ");
INSERT INTO sav_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A kaɗta ŋ ƴaar gen kur ka, yeem ammba ɗe surga, a niiɗeeɗa mbaam-huk caŋ ɗe ŋ yohon ca. ");
INSERT INTO sav_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A nikka nga, a aɗukka po a waaɗta ñam ŋ rim caŋ kidig ca nikee kañam kaŋ mbaam-huk ca, waaye a onseeɗi nga ca. ");
INSERT INTO sav_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A ɓooffa po a markissa haf ce, a woosa ne : “ Pangkoh caŋ kahan baab ɓoo jen sah, na ñamee ñam po ɓa kap te ndii, mi heeɗa kaane na aɗ. ");
INSERT INTO sav_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi na hee dokke ɗiskaŋ baab ɓoo, ŋ ree ɗah, ŋ woo ɗe ne : ‘Baab, ŋ ɗaliɗ Kooh, ŋ ɗalla ɗa, ");
INSERT INTO sav_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ŋ carisɗi ŋ markohse findi kuɓkiŋ ɗa, amb mbo findi pangkoh ciŋ ɗa.’ ” ");
INSERT INTO sav_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A kaɗta kahan baab ɓa. Wa baab ɓa ƴok ɗe usiɗ, a misikka ɗe lool ; a nuppa ŋ kuɓkiŋ ɗe, a morgiɗukka ɗe. ");
INSERT INTO sav_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kuɓka woosa baab ɓa ne : “ Baab, ŋ ɗaliɗ Kooh, ŋ ɗalla ɗa, ŋ carisɗi ŋ markohse findi kuɓkiŋ ɗa. ” ");
INSERT INTO sav_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Waaye baab ɓa woosa ñaam caŋ ɗe ne : “ Araat ɓay kulɓaaki uup moɗ, ɗu ɓekiɗ ɗe wa, ɓekɗaat ɗe jaaru na ñafaɗ, ");
INSERT INTO sav_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","te ɗu ap ɗooni yafalse, ɓoo mbuumbaay. ");
INSERT INTO sav_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Laam kuɓkiŋ ngo yii, a kaanee kaan, a hultiɗ ; a muuƴee muuƴ, a hotkiɗ ! ” Ɓa mbuumbaayeeɗa. ");
INSERT INTO sav_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wa raak kuɓki yakki ŋ yohon ca ; wi a hay po a heeɗa ree kahni, a kerahha tip ci na mbec ci. ");
INSERT INTO sav_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A ɓeeɗukka ñaam yino ŋ ñaam ci, a meekissa ɗe ini raak. ");
INSERT INTO sav_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ñaami woosa ɗe ne : “ Taambɗoh fu a yi hay, baab ɗu sah apiɗ ɗooni yafalse sagu hoti a hotis kuɓkiŋ ɗe ŋ jam. ” ");
INSERT INTO sav_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Teemb ndeem saawi ayrukka, a sannga ne a heyɗi aase kahni. Weɗi baab ɓa hayoh nga ɗe, a kiimmba ɗe ne a aasaat. ");
INSERT INTO sav_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Waaye a loffa ɗe ne : “ Sikɗuk ko, kiis laayiɗ ceɗɗi mi yii ñaamkiɗ ɗa, ŋ moosɗi ɗa nik kerhiɗaaɗi ŋ in ci fu na nakohe, te koteng sah fu moosɗi so ɗe onoh ne ŋ mbuumbaay na nawleeciŋ ngo. ");
INSERT INTO sav_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Waaye kuɓkiŋ ɗa yi yahroh koporiŋ ɗa ŋ toonkoh ca hayiɗ, fu apɗiɗ ɗe ɗooni yafalse. ” ");
INSERT INTO sav_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baab ɓa loffa ɗe ne : “ Kuɓu, fu moos nik na so, ini ŋ raak jen wa wuu fu. ");
INSERT INTO sav_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Waaye ɓoo joyiɗ sum te ɓoo mbuumbaay, laam taambɗoh fu kaanee kaan, a hultiɗ ; a muuƴee muuƴ, a hotkiɗ ! ” » ");
INSERT INTO sav_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu naandsukeen taalubeeciŋ ɗe andiinii : « A nikee ƴaar heɗ raak-raak, a raakka ñaama meeɗ ɗe taambkohiɗ raak-raakaŋ ɗe. A woyuusa ne ñaamaŋ ɗe na yahrohee wa yahroh. ");
INSERT INTO sav_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ƴaara ɓeeɗukka ñaama, a woosa ɗe ne : “ Ŋ kerhiɗ ini fu na tume ! Teeɓ po findi fu na taambkohohe raak-raakiŋ ngo. Fu pangkiɗissanɗi so. ” ");
INSERT INTO sav_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ñaama woosa ŋ ɗooƴ ce ne : “ Kilifaaniŋ ngo hey yo aañe, moo ŋ tuman na ? Ŋ hot ne ŋ raakɗi hatil guuroha te ŋ supkiɗ kiim. ");
INSERT INTO sav_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ee, waaye ŋ inhiɗ ini mi na hee haɓɗe po kilifaaniŋ ngo aañ njo ɗah, ŋ raak ɓooɓi na hee so ɓaye ŋ kahan ciŋ ɓa. ” ");
INSERT INTO sav_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","A ɓeeɗukka ɓooɓa joy wirind kilifaaniŋ ɗe kombot jen, yino yino. A woo yi koc ne : “ Fu joy ye wirind kilifaaniŋ ngo ? ” ");
INSERT INTO sav_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yeem loffa ɗe ne : “ Diwliin. Ngaal yakak teemet (100). ” A woosa ɗe ne : “ Kaytiŋ ɗa weɗɗi, ɓoofa, fu ar fiis ngaal yakak ndaŋkiyaah-yatuus (50). ” ");
INSERT INTO sav_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ƴutta, a ɓeeɗukka ƴaar wiiriis, a woosa ɗe ne : “ Fu nak, fu joy ye wirind kilifaaniŋ ngo ? ” Ƴaari loffa ne : “ Bele. Saaku teemet (100). ” A woosa ɗe ne : “ Kaytiŋ ɗa weɗɗi, ɓoofa, fu fiis ndaŋkiyaah-yasna-kaahay (80). ” ");
INSERT INTO sav_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kilifaani hotta ini ñaami yurhaaɗiini haɓiɗ, a woosa ne : “ Ƴaari ñaañiɗ kat ! ” » Yeesu degga nga ne : « Ɓooɓi na taambɗe jamanooni, ŋ findi ɓa na tiindɗohe ŋ harmban ɓa, ɓeɗ uup yunuk ɓooɓi nik ŋ ñiiniŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ñam na woyee ɗu ne, raak-raakiŋ Adina yurahɗi, waaye waakaat nawle naa, kaɗ po wa raakisɗi ɗah, ɓa min ɗu taambuk ŋ ɗiip ca na hee nikee po faw. ");
INSERT INTO sav_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɓoyi min oolku ŋ in ƴissuut, a miniɗ oolku ŋ in yakak te ɓoyi nik yurhaaɗi ŋ in ƴissuut, a heyɗi name nik yurhiɗ ŋ in yakak. ");
INSERT INTO sav_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kon, nik ne ɗu minɗi oolku ŋ findi ɗu na ambohe raak-raakiŋ Adina ɗah, ya ɓa na hee ɗu dengkohe raak-raak ci kiyooh ci ? ");
INSERT INTO sav_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nik ne ɗu minɗi oolku ŋ findi ɗu na ambohe ini ɗu raakɗi ɗah, andi ɗu hey eɗse ini ɗu raakoot ? ");
INSERT INTO sav_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ali ñaam minɗi raak heɗ kanak, mbaa a hey waaɗe yino, a sang yi tas ; wala a ŋoɗ ŋ yii, a heef yi tas. Kon ɗu minɗi ñaamuk Kooh, ɗu ñaamkee raak-raak. » ");
INSERT INTO sav_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisen ca nikee ɓo' waaɗiɗ kopor lool, tahha po, wa ɓa kerah woo ceem jen, ɓa njembteeɗa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeesu woosa ɓa ne : « Ɗu na yurah yurahɗuke ŋ has ciŋ ɓooɓi, waaye Kooh inhiɗ ini nik ŋ ɗooƴ keeñ ciŋ ɗu. Laam in ci ɓooɓi na yakɗe, ca in sepƴiɗ ngaŋ Kooh. ");
INSERT INTO sav_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","WaasiŋMusaa na woo ciŋ woosuuɗ ci nikee nga po wi Yahya Ɓoktohi hay. Ini amboh ndeem, Yegɗohiŋ Muci, wiŋ ŋ Nguuriŋ-Kooh wii yegɗohu, te ɓo' nu nga ɗah yii ndengɗuk na hatil ne a aas nga. ");
INSERT INTO sav_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Waaye eel ci na kehƴi kuruk nga, weɗ uup yooɓ fiisi uup ƴissuut nihsuk ŋ waasiŋ Musaa. ");
INSERT INTO sav_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ƴaar nu saɓsukoh na ɓitiice, a tokis ɓitiɓ wiiriis ɗah, a njaaloo njaaloo. Te ƴaar nu tok ɓitiɓ saɓsukohiɗ na ƴaar ce ɗah, a njaaloo njaaloo. » ");
INSERT INTO sav_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yeesu naandsukissa taalubeeciŋ ɗe ne : « A nikee heɗ raak-raak, a meeɗ ɓekuk kulɓa jakiɗ ca uupee raak candoom ; a peseeɗa pes neɓiɗ, Kooh-nu-wiis a meeɗta mbuumbaay. ");
INSERT INTO sav_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Raakeen ñakiɗ ŋ serooce, na woyse Lasaar. Lasaar yeem faaniŋ ɗe riifeen na puus, a meeɗ faɗu faankiɗ ŋ nguɓu kahan ƴaara. ");
INSERT INTO sav_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A meeɗeen aɗuk po a waaɗ ñam ŋ ñamohiicaŋ heɗ raak-raaka, ca na keene. Te ɓuu ci sah meeɗ meeɗ hay, ca ɗeewee puus ciŋ ɗe. ");
INSERT INTO sav_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wi ƴaari ñakɗi kaan, malaakaaci ɓayya ɗe ŋ sero Ibrahiima. Heɗ raak-raaka nammba kaan, a acuusa. ");
INSERT INTO sav_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Waaye ŋ ɗiska a nik ŋ Jaanim, a miskiɗta lool. A marakka usiɗ, a hotta Lasaar ŋ sero Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A yi heɗ raak-raaka, a woosa ŋ ɗafka ne : “ Baab Ibrahiima, ŋ miskaat ɗa, fu woos Lasaar, a ɓek ndukniŋ ɗe ŋ masuɓ, a iiri'ɗiɗ to peɗmiŋ ngo ne sifaɗki haawsuk, ŋ raakiɗ miskiɗ lool ŋ yongkaahii. ” ");
INSERT INTO sav_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Waaye Ibrahiima loffa ɗe ne : “ Kuɓu, naandsuka ne fu rahsiɗ neɓɗaŋ ɗa wa fu na pese te Lasaar nikka ŋ miskiɗ. Ɗiski wa nik ndii, keeñiŋ ɗe soosɗuuɗ, a fu nik ngaŋ miskiɗ kotii. ");
INSERT INTO sav_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɓaat nga, nung angiɗ nooɗiɗ weɗi ŋ harmban ɓoo na ɗu ; tahha po, ali ɓo' waaɗ puloh ndii, a kaɗ nga ɗu, wa minkanɗi te ɓo' minɗi puloh ngaŋ ɗiski fu nik ndeem, a hay ndii. ” ");
INSERT INTO sav_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Heɗ raak-raaka woosa ne : “ Kon, mi yii kiim ɗa baab Ibrahiima, woosa Lasaar ŋ kahan baab ɓoo. ");
INSERT INTO sav_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ŋ raakiɗ taambɗoh yatuus nga, a woo na ɓa, ɓa hayuu ŋ ɗiski miskiɗii. ” ");
INSERT INTO sav_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibrahiima loffa ɗe ne : “ Taambɗoh ciŋ ɗa, ɓa ɗaa na woo ciŋ Musaa na ciŋ woosuuɗ ci, ɓa sikɗukaat ca. ” ");
INSERT INTO sav_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Heɗ raak-raaka woosa ɗe ne : “ Baab Ibrahiima, ineem doyɗi, waaye ɓo' hulit ŋ kaaniɗ ci, a kaɗ nga ɓa ɗah, ɓa hey ɓoƴsohe pesohaaɗ. ” ");
INSERT INTO sav_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Waaye Ibrahiima woosa ɗe ne : “ Ɓa sikɗukɗi Musaa na woosuuɗ ci ɗah, ali ɓo' hulit ŋ kakaan ka, tahanɗi ɓa ɓoƴsoh kipes. ” » ");
INSERT INTO sav_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu woosa taalubeeciŋ ɗe ne : « In ci na hee kome ɓo' bakaaɗ ñakanɗi, waaye mas ɓoyi na hee ca ɓeke. ");
INSERT INTO sav_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɓoyeem tokseen atoh ɓitiɗ ŋ mbooh, a njafu ŋ cookma ɗah weɗ ngisoh nga ɗe, a bakaaɗɗukoh yino ŋ ɓooɓi ƴin cii. ");
INSERT INTO sav_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mbaa markaat in ci ɗu na haɓɗe. Morom fu bakaaɗ nga ɗa ɗah, woytohaa ɗe, inwaaso amb ɗe nga ɗah, ɗaasaa ɗe. ");
INSERT INTO sav_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ali a ɗal ɗa waas yasna-kanak ŋ mbehi yinoori, te waa nu nga ɗa a ɗaasnuk ɗa ɗah, ɗaasaa ɗe. » ");
INSERT INTO sav_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apootar ci woosa ɗe ne : « Kilifaani, ɓaatɗa ɓoo kosi ɓoo kos. » ");
INSERT INTO sav_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Heɗ ɓoo Yeesu woosa ɓa ne : « Ali ɗu raak kos hend na kuɓu mutarda ƴissuut, ɗu woo kidgii ne : “ Ɗofka, fu kaɗ yipa niir ciŋ ɗa ŋ cookma ” ɗah, wa hey ɗu kerhiɗe. ");
INSERT INTO sav_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ɓo' nga ɗu raak ñaam, yeem guurɗee ɗa wala a niiɗɗee ɗa, a puloh yohon ca ɗah, fu heyɗi ɗe jaare woo ne : “ Haya fu ñam. ” ");
INSERT INTO sav_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Waaye fu na hee ɗe woye ne : “ Tikiɗ to, fu ɓekuk kulɓa wiiriis, ne fu deƴiɗ to. Ŋ ñam, ŋ an po ŋ ƴut ɗah, fu han ñam, fu an. ” ");
INSERT INTO sav_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tum ini fu nak ɗe, wa tahanɗi po fu corkiɗ ñaamiŋ ɗa. ");
INSERT INTO sav_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wa mand ɗaa nga ɗu, ɗu haɓiɗ ini ɗu naku po ƴut ɗah, woyaat ne : “ Ɓoo ñaam dong, ɓoo haɓiɗ ini ɓoo joy haɓiɗ. ” » ");
INSERT INTO sav_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeesu nikee ŋ waas Yerusalem, a taambeeɗa ŋ harmban Samari na Galile, ");
INSERT INTO sav_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","a aaseeɗa ŋ kur, weɗ ƴaar ndaŋkiyaah hayoh cohe na ɗe, ɓa raakee kosaay ki na oɓse faan ; ɓa tufukka ɗisik usiɗ, ");
INSERT INTO sav_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɓa woosa ŋ ɗafka ne : « Yeesu Kilifaani, ɓoo miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A hotta ɓa, a woosa ɓa ne : « Kaɗaat, ɗu teeɓa haf ɗu seeƴkiɗoh ca. » Ɓa kaɗeeɗa, ɓa wirra. ");
INSERT INTO sav_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yino nga ɓa, wa a hot ne a wiriɗ, a guridda ŋ Yeesu, a yakɗeeɗa Kooh ŋ ɗafka. ");
INSERT INTO sav_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A ƴekka ŋ kot ciŋ Yeesu po pukiŋ ɗe reesa kehƴi, a corkiɗta ɗe. Ƴaareem ɓaahee nga ɓi Samari. ");
INSERT INTO sav_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wa Yeesu hot ɗe, a woosa ne : « Ɓa ndaŋkiyaah ɓeɗ wirɗu haa e ? Moo ɓa nde yasna-nikiis ca tas ? ");
INSERT INTO sav_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A yinoori dong hay ne a yakiɗ Kooh, te a Yawuut haa sah ! » ");
INSERT INTO sav_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A woosa ƴaara ne : « Kurka, fu miniɗ coot, ƴaari ; kosi fu kos wirɗiɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wa raakka mbeh, Farisen ca meekissa Yeesu ne : « Nguuriŋ-Kooh na hee haye kiɗa ? » A woosa ɓa ne : « Nguuriŋ-Kooh hayee ɗah, wa nikanɗi ini ɓo' min hot, ");
INSERT INTO sav_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","te ɓo' woyanɗi ne : “ Wa ɗii ŋ ndii ! ” wala “ Wa ɗaa ŋ nden ! ” Laam Nguuriŋ-Kooh wa ɗii ŋ ndii na ɗu. » ");
INSERT INTO sav_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ƴutta, a woosa taalubeeciŋ ɗe ne : « Jamano hey haye, ɗu hey waaɗe hot Kuɓkiŋ ɓoyi, ali nik ne wa nikan mbeh yino dong, waaye ɗu minanɗi wa. ");
INSERT INTO sav_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te ɓa hey ɗu woye ne : “ A yii ŋ ndii ! ” wala “ A yaa ŋ nden ! ” Kanaat kaɗ nga, kanaat ɓa ñaakiɗ. ");
INSERT INTO sav_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Findi meleñ na pulohe, wa ñiiniɗ ɓak po ɓak, Kuɓkiŋ ɓoyi na hee mande ɗaa ŋ mbehiŋ ɗe, ");
INSERT INTO sav_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","waaye bala ineem, a joyiɗ raak miskiɗ laayiɗ te ɓooɓiŋ jamanooni woti-woti sang ɗe. ");
INSERT INTO sav_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bala Kuɓkiŋ ɓoyi hayissan ɗah, wa mandan findi wa mandee ŋ jamanoonaŋ Noohin. ");
INSERT INTO sav_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓooɓa nikee ñameeɗa, aneeɗa, ɓa kilookeeɗa, ɓa kilookseeɗa po mbeha Noohin aasoh ŋ gaala, masuɓ laayiɗ riiffa kehƴi, wa ɗummba ɓa jen. ");
INSERT INTO sav_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na findi jamanoonaŋ Loot, ɓooɓa nikee ñameeɗa, ɓa aneeɗa, ɓa romeeɗa, ɓa tooneeɗa, ɓa guureeɗa, ɓa taɓaheeɗa ");
INSERT INTO sav_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","po mbeha Loot pul Sodom, yongkaah na suufar toɓuusa ŋ ɗafuk ɓa, wa ɗummba ɓa jen. ");
INSERT INTO sav_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mbehi Kuɓkiŋ ɓoyi na hee hotkohe, wa mandan ɗaa. ");
INSERT INTO sav_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mbeheem, ɓoyi wa na hee raake ŋ ɗafuk teeraasiŋ ɗe, a ruhsee ɗah, a kinaat aas ne a ɓay in ciŋ ɗe nik ŋ ɗooƴi. Te ɓoyi wa naman raak ŋ yohon ca, a kinaat gurid ; ");
INSERT INTO sav_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","naandsukaat ina rahsee ɓiti Loot. ");
INSERT INTO sav_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɓo' nu waaɗ muciɗ kiñin kiŋ ɗe ɗah, a heya ñake, te ɓo' nu teyɗuk ñak kiñin kiŋ ɗe ɗah, a hey rise naa. ");
INSERT INTO sav_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ñam na woyee ɗu wa, ŋ wekeem ɓo' kanak hey ɓaahe fiƴaang, yinni ɓayu, yi tas faɗu. ");
INSERT INTO sav_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɓitiɓ kanak hey nike ɓa oɗe, yinni ɓayu, yi tas faɗu. »  ");
INSERT INTO sav_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wa Yeesu ƴut ŋ woo kaŋ ɗe, taalubeeciŋ ɗe meekseeɗa ɗe ne : « Kilifaani, ineem waa hee nike ŋ nde ? » A loffa ɓa ne : « Ɓa woo ne : “ Ɗiski fiɗaaf nik, suur ci na cohe nga. ” » ");
INSERT INTO sav_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeesu naandsukissa taalubeeciŋ ɗe andiinii ne a teeɓ ɓa ne ɓa joy joy gen ngaŋ kiim Kooh, ɓa sang faɗsuk. ");
INSERT INTO sav_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","An : « Wa raakeen atte'oh ŋ kur, a nupeeɗi Kooh delem te a kerhiɗeeɗi ali ɓo'. ");
INSERT INTO sav_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wa nameen raak ɓitiɓ nga, ƴaar ce kaanee kaan, a raakka ɓoya a leer na ɗe ; tahha po a meeɗta kaɗ ngaŋ atte'oha ne yeem eɗ ɗe keeh ki a raak ŋ ɓoya a leer na ɗe. ");
INSERT INTO sav_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Atte'ohi waaɗɗi wa tum, a faɗta po wa maannja, a hannda woo ŋ ɗooƴ ce ne : “ Wa keeh ne ŋ nupɗi Kooh te ŋ kerhiɗɗi ali ɓo'. ");
INSERT INTO sav_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Waaye yaaɓɗi ɓitɓii na yaaɓɗee so, tahiɗ po ŋ hey ɗe eɗe keeh kiŋ ɗe ne a hayissuu nga so, a apee so na woo. ” » ");
INSERT INTO sav_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Heɗ ɓoo Yeesu ɓaatta nga ne : « Kerhaat baahiɗ ini atte'ohi yurhaaɗiini woo weem. ");
INSERT INTO sav_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ɗu liiɓiɗ ne Kooh namanɗi eɗ ɓooɓiŋ ɗe a kooɗ keeh kiŋ ɓa e, ɓeɗ ɓi na leehke nga ɗe noh na wek ? A hey ɓa sekɗohe e ? ");
INSERT INTO sav_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ñam na woyee ɗu wa, wa maañanɗi, Kooh eɗ ɓa keeh kiŋ ɓa. Waaye andi Kuɓkiŋ ɓoyi hayis ɗah, a hey raake oolkiɗ Kooh ŋ kehƴi ? » ");
INSERT INTO sav_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Raakka ɓi liiɓee ne ɓa yurhiɗ, ɓa heefeeɗa ɓinooɓi. Yeesu naandsukka ɓa andiinii : ");
INSERT INTO sav_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","« Ɓa nikee ƴaar kanak, ɓa kaɗta Kahan Kooh ne ɓa kiimaa ɗe nga. Yinoori nikee Farisen, yinni nikka juuti'oh. ");
INSERT INTO sav_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseni tufukka, kiimeeɗa Kooh kiik ce an : “ Eey Kooh ! Mi yii corkiɗ ɗa ŋ ini ŋ mandɗi na ɓinooɓi, ɓa rok, ɓa yurahɗi te ɓa na njaalo'ee njaaloo. Mi yii corkiɗ ɗa ŋ ini ŋ namɗi mand na juuti'ohii. ");
INSERT INTO sav_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mi na ore waas kanak ŋ ɗooƴ mbeh dokkiɗ. Te in nu ŋ raak ndaŋkiyaah nga ɗah, ŋ eɗoh yinoori. ” ");
INSERT INTO sav_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Juuti'oha nak, a cangtiɗuk cangtiɗuk, a kaañɗi sah jaɗtuk, a laɓɗeeɗa daɗi, a miskiɗkeeɗa, a woyeeɗa ne : “ Kooh ŋ miskaat ɗa, laam ŋ bakaaɗoh. ” » ");
INSERT INTO sav_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeesu ɓaatta nga ne : « Ñam na woyee ɗu ne, bala juuti'ohi haadan, a yi Kooh ɗaas, a ammba ɗe findi yurhiɗ, waaye Farisena haa. Laam ɓo' nu meeɓ haf ce ɗah, a hey ruhsiɗasse, te ɓo' nu ruhsiɗ haf ce ɗah, a hey meeɓse. » ");
INSERT INTO sav_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓa ɓayeeɗa sah ɓi gooy ŋ Yeesu ne a laal ɓa, waaye taalubeeciŋ ɗe hotta ŋ ineem, ɓa ngaskeeɗa ɓa. ");
INSERT INTO sav_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yeesu nakohha ɓa reɓɗu, a woosa ne : « Faɗaat komaakci ɓa hay nga so, kinaat ɓa hondoh hay, ɓooɓi mand na ɓa ɓeɗ raak Nguuriŋ-Kooh. ");
INSERT INTO sav_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñam na woyee ɗu wa te wa keeh, ɓo' nu teyɗukɗi Nguuriŋ-Kooh findi komaaki ƴin na teyɗukohe ɗah, fu moosanɗi aas nga. » ");
INSERT INTO sav_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ƴaar ɓaah ŋ ɓa adgohee Yawuut ca meekissa Yeesu ne : « Jangɗohohi baahiɗi, ŋ joy ye haɓiɗ po ŋ raak kipes ki heyɗi reehe ? » ");
INSERT INTO sav_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A loffa ɗe ne : « Wa ye tah fu ɓeeɗkohee so baahiɗ ? Ali ɓo' baahɗi, hanaa Kooh dong. ");
INSERT INTO sav_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fu inhiɗ nakoh ci ; an kina njaaloo, kina ap ɓo', kina rok, kina woyiɗ ɓo' ini a tumɗi, eɗa yaay ɗu na baab ɗu cir. » ");
INSERT INTO sav_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ƴaara woosa ɗe ne : « In ceem jen mi yii taambiɗ ca ŋ kikomaakiikaŋ ngo poyi. » ");
INSERT INTO sav_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wa Yeesu kerah ina a woo, a loffa ɗe ne : « Wa in yino weɗ fu tas haɓiɗ. Toona in ci fu raak jen, fu paysoh ca ñakiɗ ci, fu hey raake alal ŋ Eel ci. Ƴut ɗah, fu hay, fu ñaakiɗ to. » ");
INSERT INTO sav_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ƴaara nikee ɓo' raakiɗ lool, tahha po wa a kerah woo keem a goyya. ");
INSERT INTO sav_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeesu hotta ne a goyiɗ, a woosa ne : « Heɗ raak-raak aas ŋ Nguuriŋ-Kooh wa in ye miskan. ");
INSERT INTO sav_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngeelemb aas ŋ ngul kufic weɗ uup yooɓ heɗ raak-raak aas ŋ Nguuriŋ-Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wa ɓooɓa kerah woo keem, ɓa woyeeɗa ne : « Kon a ya ɓa min mucɗu ? » ");
INSERT INTO sav_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu loffa ɓa ne : « Ini wooñ ɓooɓi wooñɗi Kooh. » ");
INSERT INTO sav_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyeer woosa ɗe ne : « Moo ɓoo nak, ɓoo faɗiɗ in ciŋ ɓoo, ɓoo ñaakɗiɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A loffa ɓa ne : « Ñam na woyee ɗu wa te wa keeh, ɓo' nu faɗ kahan mbaa ɓitiɓ, taambɗoh, yaay, baab wala kuɓu sagu Nguuriŋ-Kooh ɗah, ");
INSERT INTO sav_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","fu hey raake nga laayoh na laayoh woti te kim fu hey raake kipes ki heyɗi reehe. » ");
INSERT INTO sav_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wa Yeesu ƴut woo na ɓa, a ɓeeɗukka Apootar ci ndaŋkiyaah na kanak ci (12) kiik ɓa, a woosa ɓa ne : « Sikɗukaat to, ɓoo na kee Yerusalem te in ci woosuuɗ ci fiis ŋ ini kaɗ ŋ Kuɓkiŋ ɓoyi jen, ca hey nike. ");
INSERT INTO sav_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A hey faɗse ŋ yaah ciŋ ɓooɓi nikɗi Yawuut, ɓa hey ɗe njembte, ɓa ɓas ɗe, ɓa tuhus ɗe. ");
INSERT INTO sav_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ɓa laɓ ɗe leraw po ƴut ɗah, ɓa hey ɗe ape te ŋ neeha kaahayɗoh, a hey hulte. » ");
INSERT INTO sav_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Waaye Apootar ci inheeɗi ini woo ceem tokis, ca ñiineeɗi nga ɓa, ɓa inheeɗi ini Yeesu waaɗ woo. ");
INSERT INTO sav_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ŋ kaɗaŋ Yeesu, wa a hay po a heeɗa ree Yeriko, fuuliɗ ɓoofeen ŋ mbeeddaana yalwaaneeɗa. ");
INSERT INTO sav_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wa a kerah ɗuuɗaŋ mboolnda taambee, a meeksohha ini raak. ");
INSERT INTO sav_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓa woosa ɗe ne : « A Yeesu yi gen Nasareet, a yi na taambe. » ");
INSERT INTO sav_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A leehukka an : « Yeesu setiŋ Dawuuda, ŋ miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓooɓa nikee ŋ fikiira ngaskeeɗa ɗe ne a ɗek, waaye a uupeeɗa nga leehuk an : « Setiŋ Dawuuda, ŋ miskaat ɗa ! » ");
INSERT INTO sav_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeesu tufukka, a woosa ɓooɓa ne ɓa reɓɗaat fuulɗa nga ɗe. Wa fuulɗa hay, Yeesu meekissa ɗe ne : ");
INSERT INTO sav_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Fu waaɗ ne ŋ haɓɗiɗ ɗa ye ? » Yeem loffa ɗe ne : « Kilifaani, ŋ waaɗ ne fu tum po has ciŋ ngo min hot. » ");
INSERT INTO sav_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu woosa ɗe ne : « Hota ! Kosi fu kos wirɗiɗ ɗa. » ");
INSERT INTO sav_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jaarra fuulɗa hoteeɗa, a taambɗeeɗa Yeesu, a yakɗeeɗa Kooh. Ɓooɓa jen hotta ŋ ineem, ɓa yakɗeeɗa Kooh. ");
INSERT INTO sav_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wa Yeesu ree Yeriko, a lahha ŋ ɗooƴ kur ka, a kaɗeeɗa. ");
INSERT INTO sav_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wa raakeen ƴaar teeku Sase, a yi nikee kilifaanaŋ juuti'oh ca, te a raakeen lool. ");
INSERT INTO sav_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A markeeɗa ne a hot ya ɓa Yeesu, waaye a mineeɗi wa sagu rohƴa a rohƴee na mboolnda. ");
INSERT INTO sav_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A nuppa ŋ fikiira, a rappa ŋ ɗafuk ndun ŋ waasa ne a hot Yeesu, ne yeem taambee ɗah. ");
INSERT INTO sav_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wa Yeesu hay po a reesa ndaam, a taaknukka, a woosa ɗe ne : « Sase ara ruhus, woti ŋ joy dal ŋ kahan fu. » ");
INSERT INTO sav_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A arra ruhus, a daliɗta Yeesu ŋ kahan ce, a neɓuusa nga lool. ");
INSERT INTO sav_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wa ɓooɓa hot ineem, ɓa jen ɓa lahtukeeɗa ne : « Markaat ƴaari, a dal ŋ kahan bakaaɗoh. » ");
INSERT INTO sav_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Raak Sase tufkiɗ, woyeeɗa Yeesu ne : « Kilifaani, ŋ hey eɗe ñakiɗ ci ɓaki winooriŋ raak-raakiŋ ngo. Te ɓo' nu nik ne ŋ kooɗiɗ in uupiɗ nga ɗe ɗah, ŋ hey ɗe wa dokne waas nikiis. » ");
INSERT INTO sav_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeesu woosa ne : « Muci reyiɗ ŋ kahnii woti. Ƴaarii nam ɓaah keeh-keeh ŋ ɓi rimkoh ŋ Ibrahiima. ");
INSERT INTO sav_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te Kuɓkiŋ ɓoyi hayiɗ ne a waak muuƴiɗ ci, a hirip ɓa. » ");
INSERT INTO sav_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɓooɓa nikee sikɗukeeɗa Yeesu. Raak ɗe ŋ ɓak Yerusalem te ɓooɓi liiɓee ne Nguuriŋ-Kooh na hee hotke win-win. ");
INSERT INTO sav_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ŋ ineem Yeesu woosa ɓa ŋ andiin ne : « A nikee garmi, a joyya kaɗ kur usiɗ ne a ɓekohsa buur nga, ƴut ɗah, a dokuk kur ce. ");
INSERT INTO sav_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bala a kaɗan ɗah, a ɓeeɗukka ñaam ndaŋkiyaah ŋ ɓaŋ ɗe, a eɗta yaa nu nga ɗah hanjar urus, a woosa ɓa ne : “ Toontukaat po ŋ hay. ” ");
INSERT INTO sav_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wa a na kaɗe jen, ɓi kur ce waaɗeeɗi ɗe, ɓa tuuƴca ɓi ɓo' ŋ finhooce ne ɓa ree ɗah, ɓa woo ne ɓa waaɗɗi ne a nik buuriŋ ɓa. ");
INSERT INTO sav_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hondohɗi, a tumuusa buur. A hayissa, a ɓeeɗukka ñaam ca a eɗe kopora ne a marak ini ɓa ɓaat nga. ");
INSERT INTO sav_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ya koc hayya woosa ɗe ne : “ Kilifaani, ursiŋ ɗa fu eɗee so eɗohiɗ hanjar urus ndaŋkiyaah. ” ");
INSERT INTO sav_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Buura loffa ɗe ne : “ Corka ! Fu ñaam baahiɗ, findi fu ndengɗukoh ŋ in ci ƴin ci, tahiɗ po adgoha kur ndaŋkiyaah. ” ");
INSERT INTO sav_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ya kanakɗoh hayya woosa ɗe ne : “ Kilifaani, ursiŋ ɗa fu eɗee so eɗohiɗ hanjar urus yatuus. ” ");
INSERT INTO sav_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Buura woosa ɗe ne : “ Nama adgoh kur yatuus. ” ");
INSERT INTO sav_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Ñaam wiiriis hayya, woosa ɗe ne : “ Kilifaani, fu ɓo' miskiɗ ; fu na kooɗe ini fu raakɗi te fu na nguɗe ini fu sokɗi. Ineem weɗ tah po ŋ neƴƴohha ɗa, ŋ loƴca ursiŋ ɗa, ŋ ɗaakkaa. ” ");
INSERT INTO sav_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Buura loffa ɗe ne : “ Ñaami baahaaɗiini, ŋ atte'an ɗa ngaŋ in ci fu woo. Fu inheen ne ŋ ɓo' miskiɗ, mi na kooɗe ini ŋ raakɗi, ŋ nguɗe ini ŋ sokɗi. ");
INSERT INTO sav_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wa ye tah fu ɗaakɗi koporiŋ ngo ŋ ɗiska na ɗaakohse kopor, ne ŋ hay ɗah, ŋ raaka rimɗiɗ to in ? ” ");
INSERT INTO sav_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ƴutta, a woosa ƴaaɓa nikee nga ne : “ Ɓayaat ursi nik na ɗe, ɗu eɗa yi raak hanjar urus ndaŋkiyaah. ” ");
INSERT INTO sav_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓa woosa ɗe ne : “ Moo Kilifaani, ƴaareem raakiɗ hanjar ndaŋkiyaah ! ” ");
INSERT INTO sav_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A loffa ɓa ne : “ Ñam na woyee ɗu wa, ɓoyi raak hey ɓaatse, waaye ɓoyi raakɗi, ini ƴissuuti a amb sah hey naafse nga ɗe. ");
INSERT INTO sav_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ŋ ini kaɗ ŋ ɓi sang ngo, ɓi waaɗeeɗi ne ŋ nik buuriŋ ɓa, hayaat na ɓa ndii, ɗu ap ɓa ŋ fikiiso. ” » ");
INSERT INTO sav_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wa Yeesu ƴut ŋ woo ceem, a adgiɗta ɓa ne ɓa kaɗ Yerusalem. ");
INSERT INTO sav_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wa Yeesu kaɗ po a heeɗa ree Betfase na Betani ŋ sero tangoora na woyse Tangooraŋ-Oliiw-ca, a woossa taalube kanak. ");
INSERT INTO sav_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A woosa ɓa ne : « Kaɗaat ŋ kur ki ŋ fikiiɗu wii, ɗu ree ɗah, ɗu hey raake cumbur mbaam tokuuɗ nga, yi ali ɓo' moosɗi rapoh. Toksaat ɗe, ɗu hay na ɗe ndii. ");
INSERT INTO sav_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɓo' meekis ɗu wa