﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanvel_vpl;
CREATE TABLE sanvel_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanvel_vpl WRITE;
INSERT INTO sanvel_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibraahiima.h santaano daayuud tasya santaano yii\"sukhrii.s.tastasya puurvvapuru.sava.m\"sa\"sre.nii| ");
INSERT INTO sanvel_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibraahiima.h putra ishaak tasya putro yaakuub tasya putro yihuudaastasya bhraatara\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmaad yihuudaatastaamaro garbhe perasserahau jaj naate, tasya perasa.h putro hi.sro.n tasya putro .araam| ");
INSERT INTO sanvel_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putro .ammiinaadab tasya putro naha\"son tasya putra.h salmon| ");
INSERT INTO sanvel_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmaad raahabo garbhe boyam jaj ne, tasmaad ruuto garbhe obed jaj ne, tasya putro yi\"saya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putro daayuud raaja.h tasmaad m.rtoriyasya jaayaayaa.m sulemaan jaj ne| ");
INSERT INTO sanvel_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putro rihabiyaam, tasya putro.abiya.h, tasya putra aasaa:| ");
INSERT INTO sanvel_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya suto yiho\"saapha.t tasya suto yihoraama tasya suta u.siya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya suto yotham tasya suta aaham tasya suto hi.skiya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya suto mina\"si.h, tasya suta aamon tasya suto yo\"siya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","baabilnagare pravasanaat puurvva.m sa yo\"siyo yikhaniya.m tasya bhraat.r.m\"sca janayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tato baabili pravasanakaale yikhaniya.h \"saltiiyela.m janayaamaasa, tasya suta.h sirubbaavil| ");
INSERT INTO sanvel_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya suto .abohud tasya suta iliiyaakiim tasya suto.asor| ");
INSERT INTO sanvel_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asora.h suta.h saadok tasya suta aakhiim tasya suta iliihuud| ");
INSERT INTO sanvel_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyaasar tasya suto mattan| ");
INSERT INTO sanvel_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya suto yaakuub tasya suto yuu.saph tasya jaayaa mariyam; tasya garbhe yii\"surajani, tameva khrii.s.tam (arthaad abhi.sikta.m) vadanti| ");
INSERT INTO sanvel_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibraahiimo daayuuda.m yaavat saakalyena caturda\"sapuru.saa.h; aa daayuuda.h kaalaad baabili pravasanakaala.m yaavat caturda\"sapuru.saa bhavanti| baabili pravaasanakaalaat khrii.s.tasya kaala.m yaavat caturda\"sapuru.saa bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yii\"sukhrii.s.tasya janma kaththate| mariyam naamikaa kanyaa yuu.saphe vaagdattaasiit, tadaa tayo.h sa\"ngamaat praak saa kanyaa  pavitre.naatmanaa garbhavatii babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyaa.h pati ryuu.saph saujanyaat tasyaa.h kala\"nga.m prakaa\"sayitum anicchan gopanene taa.m paarityaktu.m mana\"scakre| ");
INSERT INTO sanvel_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhaavayati, tadaanii.m parame\"svarasya duuta.h svapne ta.m dar\"sana.m dattvaa vyaajahaara, he daayuuda.h santaana yuu.saph tva.m nijaa.m jaayaa.m mariyamam aadaatu.m maa bhai.sii.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyaa garbha.h pavitraadaatmano.abhavat, saa ca putra.m prasavi.syate, tadaa tva.m tasya naama yii\"sum (arthaat traataara.m) karii.syase, yasmaat sa nijamanujaan te.saa.m kalu.sebhya uddhari.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ittha.m sati, pa\"sya garbhavatii kanyaa tanaya.m prasavi.syate| immaanuuyel tadiiya nca naamadheya.m bhavi.syati|| immaanuuyel asmaaka.m sa\"ngii\"svara_ityartha.h| ");
INSERT INTO sanvel_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vacana.m purvva.m bhavi.syadvaktraa ii\"svara.h kathaayaamaasa, tat tadaanii.m siddhamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantara.m yuu.saph nidraato jaagarita utthaaya parame\"svariiyaduutasya nide\"saanusaare.na nijaa.m jaayaa.m jagraaha, ");
INSERT INTO sanvel_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yaavat saa nija.m prathamasuta.m a su.suve, taavat taa.m nopaagacchat, tata.h sutasya naama yii\"su.m cakre| ");
INSERT INTO sanvel_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantara.m herod sa.mj nake raaj ni raajya.m \"saasati yihuudiiyade\"sasya baitlehami nagare yii\"sau jaatavati ca, katipayaa jyotirvvuda.h puurvvasyaa di\"so yiruu\"saalamnagara.m sametya kathayamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yo yihuudiiyaanaa.m raajaa jaatavaan, sa kutraaste? vaya.m puurvvasyaa.m di\"si ti.s.thantastadiiyaa.m taarakaam apa\"syaama tasmaat ta.m pra.nantum aाgamaama| ");
INSERT INTO sanvel_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadaa herod raajaa kathaametaa.m ni\"samya yiruu\"saalamnagarasthitai.h sarvvamaanavai.h saarddham udvijya ");
INSERT INTO sanvel_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvaan pradhaanayaajakaan adhyaapakaa.m\"sca samaahuuyaaniiya papraccha, khrii.s.ta.h kutra jani.syate? ");
INSERT INTO sanvel_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadaa te kathayaamaasu.h, yihuudiiyade\"sasya baitlehami nagare, yato bhavi.syadvaadinaa ittha.m likhitamaaste, ");
INSERT INTO sanvel_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvaabhyo raajadhaaniibhyo yihuudiiyasya niiv.rta.h| he yiihuudiiyade\"sasye baitleham tva.m na caavaraa|israayeliiyalokaan me yato ya.h paalayi.syati| taad.rgeko mahaaraajastvanmadhya udbhavi.syatii|| ");
INSERT INTO sanvel_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadaanii.m herod raajaa taan jyotirvvido gopanam aahuuya saa taarakaa kadaa d.r.s.taabhavat , tad vini\"scayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","apara.m taan baitlehama.m prahiitya gaditavaan, yuuya.m yaata, yatnaat ta.m \"si\"sum anvi.sya tadudde\"se praapte mahya.m vaarttaa.m daasyatha, tato mayaapi gatvaa sa pra.na.msyate| ");
INSERT INTO sanvel_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadaanii.m raaj na etaad.r\"siim aaj naa.m praapya te pratasthire, tata.h puurvvarsyaa.m di\"si sthitaistai ryaa taarakaa d.r.s.taa saa taarakaa te.saamagre gatvaa yatra sthaane \"si\"suuraaste, tasya sthaanasyopari sthagitaa tasyau| ");
INSERT INTO sanvel_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad d.r.s.tvaa te mahaananditaa babhuuvu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tato gehamadhya pravi\"sya tasya maatraa mariyamaa saaddha.m ta.m \"si\"su.m niriik.saya da.n.davad bhuutvaa pra.nemu.h, apara.m sve.saa.m ghanasampatti.m mocayitvaa suvar.na.m kunduru.m gandharama nca tasmai dar\"saniiya.m dattavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","pa\"scaad herod raajasya samiipa.m punarapi gantu.m svapna ii\"svare.na ni.siddhaa.h santo .anyena pathaa te nijade\"sa.m prati pratasthire| ");
INSERT INTO sanvel_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantara.m te.su gatavatmu parame\"svarasya duuto yuu.saphe svapne dar\"sana.m datvaa jagaada, tvam utthaaya \"si\"su.m tanmaatara nca g.rhiitvaa misarde\"sa.m palaayasva, apara.m yaavadaha.m tubhya.m vaarttaa.m na kathayi.syaami, taavat tatraiva nivasa, yato raajaa herod \"si\"su.m naa\"sayitu.m m.rgayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadaanii.m yuu.saph utthaaya rajanyaa.m \"si\"su.m tanmaatara nca g.rhiitvaa misarde\"sa.m prati pratasthe, ");
INSERT INTO sanvel_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvaa ca herodo n.rpate rmara.naparyyanta.m tatra de\"se nyuvaasa, tena misarde\"saadaha.m putra.m svakiiya.m samupaahuuyam| yadetadvacanam ii\"svare.na bhavi.syadvaadinaa kathita.m tat saphalamabhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantara.m herod jyotirvidbhiraatmaana.m prava ncita.m vij naaya bh.r\"sa.m cukopa; apara.m jyotirvvidbhyastena vini\"scita.m yad dina.m taddinaad ga.nayitvaa dvitiiyavatsara.m pravi.s.taa yaavanto baalakaa asmin baitlehamnagare tatsiimamadhye caasan, lokaan prahitya taan sarvvaan ghaatayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ata.h anekasya vilaapasya ninaada: krandanasya ca| \"sokena k.rta\"sabda\"sca raamaayaa.m sa.mni\"samyate| svabaalaga.nahetorvai raahel naarii tu rodinii| na manyate prabodhantu yataste naiva manti hi|| ");
INSERT INTO sanvel_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadetad vacana.m yiriimiyanaamakabhavi.syadvaadinaa kathita.m tat tadaanii.m saphalam abhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantara.m heredi raajani m.rte parame\"svarasya duuto misarde\"se svapne dar\"sana.m dattvaa yuu.saphe kathitavaan ");
INSERT INTO sanvel_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthaaya \"si\"su.m tanmaatara nca g.rhiitvaa punarapiisraayelo de\"sa.m yaahii, ye janaa.h \"si\"su.m naa\"sayitum am.rgayanta, te m.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadaanii.m sa utthaaya \"si\"su.m tanmaatara nca g.rhlan israayelde\"sam aajagaama| ");
INSERT INTO sanvel_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihuudiiyade\"se arkhilaayanaama raajakumaaro nijapitu rheroda.h pada.m praapya raajatva.m karotiiti ni\"samya tat sthaana.m yaatu.m \"sa\"nkitavaan, pa\"scaat svapna ii\"svaraat prabodha.m praapya gaaliilde\"sasya prade\"saika.m prasthaaya naasarannaama nagara.m gatvaa tatra nyu.sitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tena ta.m naasaratiiya.m kathayi.syanti, yadetadvaakya.m bhavi.syadvaadibhiruktta.m tat saphalamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadaano.m yohnnaamaa majjayitaa yihuudiiyade\"sasya praantaram upasthaaya pracaarayan kathayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manaa.msi paraavarttayata, svargiiyaraajatva.m samiipamaagatam| ");
INSERT INTO sanvel_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","parame\"sasya panthaana.m pari.skuruta sarvvata.h| tasya raajapathaa.m\"scaiva samiikuruta sarvvathaa| ityetat praantare vaakya.m vadata.h kasyacid rava.h|| ");
INSERT INTO sanvel_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","etadvacana.m yi\"sayiyabhavi.syadvaadinaa yohanamuddi\"sya bhaa.sitam| yohano vasana.m mahaa\"ngaromaja.m tasya ka.tau carmmaka.tibandhana.m; sa ca \"suukakii.taan madhu ca bhuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadaanii.m yiruu\"saalamnagaranivaasina.h sarvve yihuudide\"siiyaa yarddanta.tinyaa ubhayata.tasthaa\"sca maanavaa bahiraagatya tasya samiipe ");
INSERT INTO sanvel_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","sviiya.m sviiya.m duritam a\"ngiik.rtya tasyaa.m yarddani tena majjitaa babhuuvu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","apara.m bahuun phiruu\"sina.h siduukina\"sca manujaan ma.mktu.m svasamiipam aagacchto vilokya sa taan abhidadhau, re re bhujagava.m\"saa aagaamiina.h kopaat palaayitu.m yu.smaan ka\"scetitavaan? ");
INSERT INTO sanvel_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","mana.hparaavarttanasya samucita.m phala.m phalata| ");
INSERT INTO sanvel_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmaaka.m taata ibraahiim astiiti sve.su mana.hsu ciintayanto maa vyaaharata| yato yu.smaan aha.m vadaami, ii\"svara etebhya.h paa.saa.nebhya ibraahiima.h santaanaan utpaadayitu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","apara.m paadapaanaa.m muule ku.thaara idaaniimapi lagan aaste, tasmaad yasmin paadape uttama.m phala.m na bhavati, sa k.rtto madhye.agni.m nik.sepsyate| ");
INSERT INTO sanvel_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam aha.m mana.hparaavarttanasuucakena majjanena yu.smaan majjayaamiiti satya.m, kintu mama pa\"scaad ya aagacchati, sa mattopi mahaan, aha.m tadiiyopaanahau vo.dhumapi nahi yogyosmi, sa yu.smaan vahniruupe pavitra aatmani sa.mmajjayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kaare suurpa aaste, sa sviiya\"sasyaani samyak praspho.tya nijaan sakalagodhuumaan sa.mg.rhya bhaa.n.daagaare sthaapayi.syati, ki.mntu sarvvaa.ni vu.saa.nyanirvvaa.navahninaa daahayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantara.m yii\"su ryohanaa majjito bhavitu.m gaaliilprade\"saad yarddani tasya samiipam aajagaama| ");
INSERT INTO sanvel_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yohan ta.m ni.sidhya babhaa.se, tva.m ki.m mama samiipam aagacchasi? vara.m tvayaa majjana.m mama prayojanam aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadaanii.m yii\"su.h pratyavocat; iidaaniim anumanyasva, yata ittha.m sarvvadharmmasaadhanam asmaaka.m karttavya.m, tata.h so.anvamanyata| ");
INSERT INTO sanvel_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantara.m yii\"surammasi majjitu.h san tatk.sa.naat toyamadhyaad utthaaya jagaama, tadaa jiimuutadvaare mukte jaate, sa ii\"svarasyaatmaana.m kapotavad avaruhya svoparyyaagacchanta.m viik.saa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam e.sa mama priya.h putra etasminneva mama mahaasanto.sa etaad.r\"sii vyomajaa vaag babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tata.h para.m yii\"su.h prataarake.na pariik.sito bhavitum aatmanaa praantaram aak.r.s.ta.h ");
INSERT INTO sanvel_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san catvaari.m\"sadahoraatraan anaahaarasti.s.than k.sudhito babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadaanii.m pariik.sitaa tatsamiipam aagatya vyaah.rtavaan, yadi tvamii\"svaraatmajo bhavestarhyaaj nayaa paa.saa.naanetaan puupaan vidhehi| ");
INSERT INTO sanvel_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tata.h sa pratyabraviit, ittha.m likhitamaaste, \"manuja.h kevalapuupena na jiivi.syati, kintvii\"svarasya vadanaad yaani yaani vacaa.msi ni.hsaranti taireva jiivi.syati|\" ");
INSERT INTO sanvel_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadaa prataarakasta.m pu.nyanagara.m niitvaa mandirasya cuu.dopari nidhaaya gaditavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tva.m yadi\"svarasya tanayo bhavestarhiito.adha.h pata, yata ittha.m likhitamaaste, aadek.syati nijaan duutaan rak.situ.m tvaa.m parame\"svara.h| yathaa sarvve.su maarge.su tvadiiyacara.nadvaye| na laget prastaraaghaatastvaa.m ghari.syanti te karai.h|| ");
INSERT INTO sanvel_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadaanii.m yii\"sustasmai kathitavaan etadapi likhitamaaste, \"tva.m nijaprabhu.m parame\"svara.m maa pariik.sasva|\" ");
INSERT INTO sanvel_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantara.m prataaraka.h punarapi tam atyu ncadharaadharopari niitvaa jagata.h sakalaraajyaani tadai\"svaryyaa.ni ca dar\"sayaa\"scakaara kathayaa ncakaara ca, ");
INSERT INTO sanvel_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tva.m da.n.davad bhavan maa.m pra.namestarhyaham etaani tubhya.m pradaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadaanii.m yii\"sustamavocat, duuriibhava prataaraka, likhitamidam aaste, \"tvayaa nija.h prabhu.h parame\"svara.h pra.namya.h kevala.h sa sevya\"sca|\" ");
INSERT INTO sanvel_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tata.h prataarake.na sa paryyatyaaji, tadaa svargiiyaduutairaagatya sa si.seve| ");
INSERT INTO sanvel_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantara.m yohan kaaraayaa.m babandhe, tadvaarttaa.m ni\"samya yii\"sunaa gaaliil praasthiiyata| ");
INSERT INTO sanvel_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tata.h para.m sa naasarannagara.m vihaaya jalaghesta.te sibuuluunnaptaalii etayoruvabhayo.h prade\"sayo.h siimnormadhyavarttii ya: kapharnaahuum tannagaram itvaa nyavasat| ");
INSERT INTO sanvel_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmaat, anyaade\"siiyagaaliili yarddanpaare.abdhirodhasi| naptaalisibuuluunde\"sau yatra sthaane sthitau puraa| ");
INSERT INTO sanvel_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyaa manujaa ye ye paryyabhraamyan tamisrake| tairjanairb.rhadaaloka.h paridar\"si.syate tadaa| avasan ye janaa de\"se m.rtyucchaayaasvaruupake| te.saamupari lokaanaamaaloka.h sa.mprakaa\"sita.h|| ");
INSERT INTO sanvel_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadetadvacana.m yi\"sayiyabhavi.syadvaadinaa prokta.m, tat tadaa saphalam abhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantara.m yii\"su.h susa.mvaada.m pracaarayan etaa.m kathaa.m kathayitum aarebhe, manaa.msi paraavarttayata, svargiiyaraajatva.m savidhamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tata.h para.m yii\"su rgaaliilo jaladhesta.tena gacchan gacchan aandriyastasya bhraataa \"simon arthato ya.m pitara.m vadanti etaavubhau jalaghau jaala.m k.sipantau dadar\"sa, yatastau miinadhaari.naavaastaam| ");
INSERT INTO sanvel_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadaa sa taavaahuuya vyaajahaara, yuvaa.m mama pa\"scaad aagacchata.m, yuvaamaha.m manujadhaari.nau kari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tenaiva tau jaala.m vihaaya tasya pa\"scaat aagacchataam| ");
INSERT INTO sanvel_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantara.m tasmaat sthaanaat vrajan vrajan sivadiyasya sutau yaakuub yohannaamaanau dvau sahajau taatena saarddha.m naukopari jaalasya jiir.noddhaara.m kurvvantau viik.sya taavaahuutavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatk.sa.naat tau naava.m svataata nca vihaaya tasya pa\"scaadgaaminau babhuuvatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantara.m bhajanabhavane samupadi\"san raajyasya susa.mvaada.m pracaarayan manujaanaa.m sarvvaprakaaraan rogaan sarvvaprakaarapii.daa\"sca \"samayan yii\"su.h k.rtsna.m gaaliilde\"sa.m bhramitum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tena k.rtsnasuriyaade\"sasya madhya.m tasya ya\"so vyaapnot, apara.m bhuutagrastaa apasmaarargii.na.h pak.saadhaatiprabh.rtaya\"sca yaavanto manujaa naanaavidhavyaadhibhi.h kli.s.taa aasan, te.su sarvve.su tasya samiipam aaniite.su sa taan svasthaan cakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","etena gaaliil-dikaapani-yiruu\"saalam-yihuudiiyade\"sebhyo yarddana.h paaraa nca bahavo manujaastasya pa\"scaad aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantara.m sa jananivaha.m niriik.sya bhuudharopari vrajitvaa samupavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadaanii.m \"si.sye.su tasya samiipamaagate.su tena tebhya e.saa kathaa kathyaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimaanahiinaa janaa dhanyaa.h, yataste svargiiyaraajyam adhikari.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamaanaa manujaa dhanyaa.h, yasmaat te saantvanaa.m praapsanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namraa maanavaa\"sca dhanyaa.h, yasmaat te mediniim adhikari.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmaaya bubhuk.sitaa.h t.r.saarttaa\"sca manujaa dhanyaa.h, yasmaat te paritarpsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","k.rpaalavo maanavaa dhanyaa.h, yasmaat te k.rpaa.m praapsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalah.rdayaa manujaa\"sca dhanyaa.h, yasmaat ta ii\"scara.m drak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","melayitaaro maanavaa dhanyaa.h, yasmaat ta ii\"scarasya santaanatvena vikhyaasyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakaara.naat taa.ditaa manujaa dhanyaa, yasmaat svargiiyaraajye te.saamadhikaro vidyate| ");
INSERT INTO sanvel_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadaa manujaa mama naamak.rte yu.smaan nindanti taa.dayanti m.r.saa naanaadurvvaakyaani vadanti ca, tadaa yuya.m dhanyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadaa aanandata, tathaa bh.r\"sa.m hlaadadhva nca, yata.h svarge bhuuyaa.msi phalaani lapsyadhve; te yu.smaaka.m puraatanaan bhavi.syadvaadino.api taad.rg ataa.dayan| ");
INSERT INTO sanvel_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuya.m medinyaa.m lava.naruupaa.h, kintu yadi lava.nasya lava.natvam apayaati, tarhi tat kena prakaare.na svaaduyukta.m bhavi.syati? tat kasyaapi kaaryyasyaayogyatvaat kevala.m bahi.h prak.septu.m naraa.naa.m padatalena dalayitu nca yogya.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yuuya.m jagati diiptiruupaa.h, bhuudharopari sthita.m nagara.m gupta.m bhavitu.m nahi \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","apara.m manujaa.h pradiipaan prajvaalya dro.naadho na sthaapayanti, kintu diipaadhaaroparyyeva sthaapayanti, tena te diipaa gehasthitaan sakalaan prakaa\"sayanti| ");
INSERT INTO sanvel_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yena maanavaa yu.smaaka.m satkarmmaa.ni vilokya yu.smaaka.m svargastha.m pitara.m dhanya.m vadanti, te.saa.m samak.sa.m yu.smaaka.m diiptistaad.rk prakaa\"sataam| ");
INSERT INTO sanvel_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","aha.m vyavasthaa.m bhavi.syadvaakya nca loptum aagatavaan, ittha.m maanubhavata, te dve loptu.m naagatavaan, kintu saphale karttum aagatosmi| ");
INSERT INTO sanvel_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","apara.m yu.smaan aha.m tathya.m vadaami yaavat vyomamedinyo rdhva.mso na bhavi.syati, taavat sarvvasmin saphale na jaate vyavasthaayaa ekaa maatraa bindurekopi vaa na lopsyate| ");
INSERT INTO sanvel_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmaat yo jana etaasaam aaj naanaam atik.sudraam ekaaj naamapii la.mghate manujaa.m nca tathaiva \"sik.sayati, sa svargiiyaraajye sarvvebhya.h k.sudratvena vikhyaasyate, kintu yo janastaa.m paalayati, tathaiva \"sik.sayati ca, sa svargiiyaraajye pradhaanatvena vikhyaasyate| ");
INSERT INTO sanvel_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","apara.m yu.smaan aha.m vadaami, adhyaapakaphiruu\"simaanavaanaa.m dharmmaanu.s.thaanaat yu.smaaka.m dharmmaanu.s.thaane nottame jaate yuuyam ii\"svariiyaraajya.m prave.s.tu.m na \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","apara nca tva.m nara.m maa vadhii.h, yasmaat yo nara.m hanti, sa vicaarasabhaayaa.m da.n.daarho bhavi.syati, puurvvakaaliinajanebhya iti kathitamaasiit, yu.smaabhira\"sraavi| ");
INSERT INTO sanvel_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvaha.m yu.smaan vadaami, ya.h ka\"scit kaara.na.m vinaa nijabhraatre kupyati, sa vicaarasabhaayaa.m da.n.daarho bhavi.syati; ya.h ka\"scicca sviiyasahaja.m nirbbodha.m vadati, sa mahaasabhaayaa.m da.n.daarho bhavi.syati; puna\"sca tva.m muu.dha iti vaakya.m yadi ka\"scit sviiyabhraatara.m vakti, tarhi narakaagnau sa da.n.daarho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ato vedyaa.h samiipa.m nijanaivedye samaaniite.api nijabhraatara.m prati kasmaaccit kaara.naat tva.m yadi do.sii vidyase, tadaanii.m tava tasya sm.rti rjaayate ca, ");
INSERT INTO sanvel_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyaa vedyaa.h samiipe nijanaivaidya.m nidhaaya tadaiva gatvaa puurvva.m tena saarddha.m mila, pa\"scaat aagatya nijanaivedya.m nivedaya| ");
INSERT INTO sanvel_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anya nca yaavat vivaadinaa saarddha.m vartmani ti.s.thasi, taavat tena saarddha.m melana.m kuru; no cet vivaadii vicaarayitu.h samiipe tvaa.m samarpayati vicaarayitaa ca rak.si.na.h sannidhau samarpayati tadaa tva.m kaaraayaa.m badhyethaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvaamaha.m taththa.m braviimi, \"se.sakapardake.api na pari\"sodhite tasmaat sthaanaat kadaapi bahiraagantu.m na \"sak.syasi| ");
INSERT INTO sanvel_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","apara.m tva.m maa vyabhicara, yadetad vacana.m puurvvakaaliinalokebhya.h kathitamaasiit, tad yuuya.m \"srutavanta.h; ");
INSERT INTO sanvel_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvaha.m yu.smaan vadaami, yadi ka\"scit kaamata.h kaa ncana yo.sita.m pa\"syati, tarhi sa manasaa tadaiva vyabhicaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmaat tava dak.si.na.m netra.m yadi tvaa.m baadhate, tarhi tannetram utpaa.tya duure nik.sipa, yasmaat tava sarvvavapu.so narake nik.sepaat tavaikaa\"ngasya naa\"so vara.m| ");
INSERT INTO sanvel_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvaa tava dak.si.na.h karo yadi tvaa.m baadhate, tarhi ta.m kara.m chittvaa duure nik.sipa, yata.h sarvvavapu.so narake nik.sepaat ekaa\"ngasya naa\"so vara.m| ");
INSERT INTO sanvel_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamaaste, yadi ka\"scin nijajaayaa.m parityakttum icchati, tarhi sa tasyai tyaagapatra.m dadaatu| ");
INSERT INTO sanvel_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvaha.m yu.smaan vyaaharaami, vyabhicaarado.se na jaate yadi ka\"scin nijajaayaa.m parityajati, tarhi sa taa.m vyabhicaarayati; ya\"sca taa.m tyaktaa.m striya.m vivahati, sopi vyabhicarati| ");
INSERT INTO sanvel_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","puna\"sca tva.m m.r.saa \"sapatham na kurvvan ii\"scaraaya nija\"sapatha.m paalaya, puurvvakaaliinalokebhyo yai.saa kathaa kathitaa, taamapi yuuya.m \"srutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvaha.m yu.smaan vadaami, kamapi \"sapatha.m maa kaar.s.ta, arthata.h svarganaamnaa na, yata.h sa ii\"svarasya si.mhaasana.m; ");
INSERT INTO sanvel_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","p.rthivyaa naamnaapi na, yata.h saa tasya paadapii.tha.m; yiruu\"saalamo naamnaapi na, yata.h saa mahaaraajasya purii; ");
INSERT INTO sanvel_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nija\"sironaamnaapi na, yasmaat tasyaika.m kacamapi sitam asita.m vaa karttu.m tvayaa na \"sakyate| ");
INSERT INTO sanvel_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","apara.m yuuya.m sa.mlaapasamaye kevala.m bhavatiiti na bhavatiiti ca vadata yata ito.adhika.m yat tat paapaatmano jaayate| ");
INSERT INTO sanvel_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","apara.m locanasya vinimayena locana.m dantasya vinimayena danta.h puurvvaktamida.m vacana nca yu.smaabhira\"sruuyata| ");
INSERT INTO sanvel_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvaha.m yu.smaan vadaami yuuya.m hi.msaka.m nara.m maa vyaaghaatayata| kintu kenacit tava dak.si.nakapole cape.taaghaate k.rte ta.m prati vaama.m kapola nca vyaagho.taya| ");
INSERT INTO sanvel_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","apara.m kenacit tvayaa saardhda.m vivaada.m k.rtvaa tava paridheyavasane jigh.rtite tasmaayuttariiyavasanamapi dehi| ");
INSERT INTO sanvel_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi ka\"scit tvaa.m kro\"sameka.m nayanaartha.m anyaayato dharati, tadaa tena saardhda.m kro\"sadvaya.m yaahi| ");
INSERT INTO sanvel_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ya\"sca maanavastvaa.m yaacate, tasmai dehi, yadi ka\"scit tubhya.m dhaarayitum icchati, tarhi ta.m prati paraa.mmukho maa bhuu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamiipavasini prema kuru, kintu \"satru.m prati dve.sa.m kuru, yadetat purokta.m vacana.m etadapi yuuya.m \"srutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvaha.m yu.smaan vadaami, yuuya.m ripuvvapi prema kuruta, ye ca yu.smaan \"sapante, taana, aa\"si.sa.m vadata, ye ca yu.smaan .rृtiiyante, te.saa.m ma\"ngala.m kuruta, ye ca yu.smaan nindanti, taa.dayanti ca, te.saa.m k.rte praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra ya.h sataamasataa ncopari prabhaakaram udaayayati, tathaa dhaarmmikaanaamadhaarmmikaanaa ncopari niira.m var.sayati taad.r\"so yo yu.smaaka.m svargastha.h pitaa, yuuya.m tasyaiva santaanaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ye yu.smaasu prema kurvvanti, yuuya.m yadi kevala.m tevveva prema kurutha, tarhi yu.smaaka.m ki.m phala.m bhavi.syati? ca.n.daalaa api taad.r\"sa.m ki.m na kurvvanti? ");
INSERT INTO sanvel_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","apara.m yuuya.m yadi kevala.m sviiyabhraat.rtvena namata, tarhi ki.m mahat karmma kurutha? ca.n.daalaa api taad.r\"sa.m ki.m na kurvvanti? ");
INSERT INTO sanvel_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmaat yu.smaaka.m svargastha.h pitaa yathaa puur.no bhavati, yuuyamapi taad.r\"saa bhavata| ");
INSERT INTO sanvel_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","saavadhaanaa bhavata, manujaan dar\"sayitu.m te.saa.m gocare dharmmakarmma maa kuruta, tathaa k.rte yu.smaaka.m svargasthapitu.h sakaa\"saat ki ncana phala.m na praapsyatha| ");
INSERT INTO sanvel_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tva.m yadaa dadaasi tadaa kapa.tino janaa yathaa manujebhya.h pra\"sa.msaa.m praaptu.m bhajanabhavane raajamaarge ca tuurii.m vaadayanti, tathaa maa kuriु, aha.m tubhya.m yathaartha.m kathayaami, te svakaaya.m phalam alabhanta| ");
INSERT INTO sanvel_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tva.m yadaa dadaasi, tadaa nijadak.si.nakaro yat karoti, tad vaamakara.m maa j naapaya| ");
INSERT INTO sanvel_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tena tava daana.m gupta.m bhavi.syati yastu tava pitaa guptadar\"sii, sa prakaa\"sya tubhya.m phala.m daasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","apara.m yadaa praarthayase, tadaa kapa.tina_iva maa kuru, yasmaat te bhajanabhavane raajamaargasya ko.ne ti.s.thanto lokaan dar\"sayanta.h praarthayitu.m priiyante; aha.m yu.smaan tathya.m vadaami, te svakiiyaphala.m praapnuvan| ");
INSERT INTO sanvel_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmaat praarthanaakaale antaraagaara.m pravi\"sya dvaara.m rudvvaa gupta.m pa\"syatastava pitu.h samiipe praarthayasva; tena tava ya.h pitaa guptadar\"sii, sa prakaa\"sya tubhya.m phala.m daasyatil ");
INSERT INTO sanvel_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","apara.m praarthanaakaale devapuujakaaiva mudhaa punarukti.m maa kuru, yasmaat te bodhante, bahuvaara.m kathaayaa.m kathitaayaa.m te.saa.m praarthanaa graahi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yuuya.m te.saamiva maa kuruta, yasmaat yu.smaaka.m yad yat prayojana.m yaacanaata.h praageva yu.smaaka.m pitaa tat jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataeva yuuyama iid.rk praarthayadhva.m, he asmaaka.m svargasthapita.h, tava naama puujya.m bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava raajatva.m bhavatu; tavecchaa svarge yathaa tathaiva medinyaamapi saphalaa bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmaaka.m prayojaniiyam aahaaram adya dehi| ");
INSERT INTO sanvel_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vaya.m yathaa nijaaparaadhina.h k.samaamahe, tathaivaasmaakam aparaadhaan k.samasva| ");
INSERT INTO sanvel_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmaan pariik.saa.m maanaya, kintu paapaatmano rak.sa; raajatva.m gaurava.m paraakrama.h ete sarvve sarvvadaa tava; tathaastu| ");
INSERT INTO sanvel_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yuuyam anye.saam aparaadhaan k.samadhve tarhi yu.smaaka.m svargasthapitaapi yu.smaan k.sami.syate; ");
INSERT INTO sanvel_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yuuyam anye.saam aparaadhaan na k.samadhve, tarhi yu.smaaka.m janakopi yu.smaakam aparaadhaan na k.sami.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavaasakaale kapa.tino janaa maanu.saan upavaasa.m j naapayitu.m sve.saa.m vadanaani mlaanaani kurvvanti, yuuya.m ta_iva vi.sa.navadanaa maa bhavata; aha.m yu.smaan tathya.m vadaami te svakiiyaphalam alabhanta| ");
INSERT INTO sanvel_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadaa tvam upavasasi, tadaa yathaa lokaistva.m upavaasiiva na d.r\"syase, kintu tava yo.agocara.h pitaa tenaiva d.r\"syase, tatk.rte nija\"sirasi taila.m marddaya vadana nca prak.saalaya; ");
INSERT INTO sanvel_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tena tava ya.h pitaa guptadar\"sii sa prakaa\"sya tubhya.m phala.m daasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","apara.m yatra sthaane kii.taa.h kala\"nkaa\"sca k.saya.m nayanti, cauraa\"sca sandhi.m karttayitvaa corayitu.m \"saknuvanti, taad.r\"syaa.m medinyaa.m svaartha.m dhana.m maa sa.mcinuta| ");
INSERT INTO sanvel_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthaane kii.taa.h kala\"nkaa\"sca k.saya.m na nayanti, cauraa\"sca sandhi.m karttayitvaa corayitu.m na \"saknuvanti, taad.r\"se svarge dhana.m sa ncinuta| ");
INSERT INTO sanvel_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmaat yatra sthaane yu.smaa.mka dhana.m tatraiva khaane yu.smaaka.m manaa.msi| ");
INSERT INTO sanvel_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","locana.m dehasya pradiipaka.m, tasmaat yadi tava locana.m prasanna.m bhavati, tarhi tava k.rtsna.m vapu rdiiptiyukta.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu locane.aprasanne tava k.rtsna.m vapu.h tamisrayukta.m bhavi.syati| ataeva yaa diiptistvayi vidyate, saa yadi tamisrayuktaa bhavati, tarhi tat tamisra.m kiyan mahat| ");
INSERT INTO sanvel_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kopi manujo dvau prabhuu sevitu.m na \"saknoti, yasmaad eka.m sa.mmanya tadanya.m na sammanyate, yadvaa ekatra mano nidhaaya tadanyam avamanyate; tathaa yuuyamapii\"svara.m lak.smii ncetyubhe sevitu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam aha.m yu.smabhya.m tathya.m kathayaami, ki.m bhak.si.syaama.h? ki.m paasyaama.h? iti praa.nadhaara.naaya maa cintayata; ki.m paridhaasyaama.h? iti kaayarak.sa.naaya na cintayata; bhak.syaat praa.naa vasanaa nca vapuu.m.si ki.m \"sre.s.thaa.ni na hi? ");
INSERT INTO sanvel_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihaayaso viha\"ngamaan vilokayata; tai rnopyate na k.rtyate bhaa.n.daagaare na sa nciiyate.api; tathaapi yu.smaaka.m svargastha.h pitaa tebhya aahaara.m vitarati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yuuya.m tebhya.h ki.m \"sre.s.thaa na bhavatha? yu.smaaka.m ka\"scit manuja.h cintayan nijaayu.sa.h k.sa.namapi varddhayitu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","apara.m vasanaaya kuta\"scintayata? k.setrotpannaani pu.spaa.ni katha.m varddhante tadaalocayata| taani tantuun notpaadayanti kimapi kaaryya.m na kurvvanti; ");
INSERT INTO sanvel_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathaapyaha.m yu.smaan vadaami, sulemaan taad.rg ai\"svaryyavaanapi tatpu.spamiva vibhuu.sito naasiit| ");
INSERT INTO sanvel_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmaat k.sadya vidyamaana.m \"sca.h cullyaa.m nik.sepsyate taad.r\"sa.m yat k.setrasthita.m kusuma.m tat yadii\"scara ittha.m bibhuu.sayati, tarhi he stokapratyayino yu.smaan ki.m na paridhaapayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmaat asmaabhi.h kimatsyate? ki nca paayi.syate? ki.m vaa paridhaayi.syate, iti na cintayata| ");
INSERT INTO sanvel_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmaat devaarccakaa apiiti ce.s.tante; ete.su dravye.su prayojanamastiiti yu.smaaka.m svargastha.h pitaa jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataeva prathamata ii\"svariiyaraajya.m dharmma nca ce.s.tadhva.m, tata etaani vastuuni yu.smabhya.m pradaayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","\"sva.h k.rte maa cintayata, \"svaeva svaya.m svamuddi\"sya cintayi.syati; adyatanii yaa cintaa saadyak.rte pracurataraa| ");
INSERT INTO sanvel_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathaa yuuya.m do.siik.rtaa na bhavatha, tatk.rte.anya.m do.si.na.m maa kuruta| ");
INSERT INTO sanvel_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yato yaad.r\"sena do.se.na yuuya.m paraan do.si.na.h kurutha, taad.r\"sena do.se.na yuuyamapi do.siik.rtaa bhavi.syatha, anya nca yena parimaa.nena yu.smaabhi.h parimiiyate, tenaiva parimaa.nena yu.smatk.rte parimaayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","apara nca nijanayane yaa naasaa vidyate, taam anaalocya tava sahajasya locane yat t.r.nam aaste, tadeva kuto viik.sase? ");
INSERT INTO sanvel_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalocane naasaayaa.m vidyamaanaayaa.m, he bhraata.h, tava nayanaat t.r.na.m bahi.syartu.m anujaaniihi, kathaametaa.m nijasahajaaya katha.m kathayitu.m \"sakno.si? ");
INSERT INTO sanvel_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","he kapa.tin, aadau nijanayanaat naasaa.m bahi.skuru tato nijad.r.s.tau suprasannaayaa.m tava bhraat.r rlocanaat t.r.na.m bahi.skartu.m \"sak.syasi| ");
INSERT INTO sanvel_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anya nca saarameyebhya.h pavitravastuuni maa vitarata, varaahaa.naa.m samak.sa nca muktaa maa nik.sipata; nik.sepa.naat te taa.h sarvvaa.h padai rdalayi.syanti, paraav.rtya yu.smaanapi vidaarayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yaacadhva.m tato yu.smabhya.m daayi.syate; m.rgayadhva.m tata udde\"sa.m lapsyadhve; dvaaram aahata, tato yu.smatk.rte mukta.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmaad yena yaacyate, tena labhyate; yena m.rgyate tenodde\"sa.h praapyate; yena ca dvaaram aahanyate, tatk.rte dvaara.m mocyate| ");
INSERT INTO sanvel_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","aatmajena puupe praarthite tasmai paa.saa.na.m vi\"sraa.nayati, ");
INSERT INTO sanvel_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","miine yaacite ca tasmai bhujaga.m vitarati, etaad.r\"sa.h pitaa yu.smaaka.m madhye ka aaste? ");
INSERT INTO sanvel_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmaad yuuyam abhadraa.h santo.api yadi nijabaalakebhya uttama.m dravya.m daatu.m jaaniitha, tarhi yu.smaaka.m svargastha.h pitaa sviiyayaacakebhya.h kimuttamaani vastuuni na daasyati? ");
INSERT INTO sanvel_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yuu.smaan pratiitare.saa.m yaad.r\"so vyavahaaro yu.smaaka.m priya.h, yuuya.m taan prati taad.r\"saaneva vyavahaaraan vidhatta; yasmaad vyavasthaabhavi.syadvaadinaa.m vacanaanaam iti saaram| ");
INSERT INTO sanvel_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","sa\"nkiir.nadvaare.na pravi\"sata; yato narakagamanaaya yad dvaara.m tad vistiir.na.m yacca vartma tad b.rhat tena bahava.h pravi\"santi| ");
INSERT INTO sanvel_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","apara.m svargagamanaaya yad dvaara.m tat kiid.rk sa.mkiir.na.m| yacca vartma tat kiid.rg durgamam| tadudde.s.taara.h kiyanto.alpaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","apara nca ye janaa me.save\"sena yu.smaaka.m samiipam aagacchanti, kintvantardurantaa v.rkaa etaad.r\"sebhyo bhavi.syadvaadibhya.h saavadhaanaa bhavata, yuuya.m phalena taan paricetu.m \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujaa.h ki.m ka.n.takino v.rk.saad draak.saaphalaani \"s.rgaalakolita\"sca u.dumbaraphalaani \"saatayanti? ");
INSERT INTO sanvel_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama eva paadapa uttamaphalaani janayati, adhamapaadapaevaadhamaphalaani janayati| ");
INSERT INTO sanvel_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintuuttamapaadapa.h kadaapyadhamaphalaani janayitu.m na \"saknoti, tathaadhamopi paadapa uttamaphalaani janayitu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","apara.m ye ye paadapaa adhamaphalaani janayanti, te k.rttaa vahnau k.sipyante| ");
INSERT INTO sanvel_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataeva yuuya.m phalena taan parice.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ye janaa maa.m prabhu.m vadanti, te sarvve svargaraajya.m pravek.syanti tanna, kintu yo maanavo mama svargasthasya pituri.s.ta.m karmma karoti sa eva pravek.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dine bahavo maa.m vadi.syanti, he prabho he prabho, tava naamnaa kimasmaami rbhavi.syadvaakya.m na vyaah.rta.m? tava naamnaa bhuutaa.h ki.m na tyaajitaa.h? tava naamnaa ki.m naanaadbhutaani karmmaa.ni na k.rtaani? ");
INSERT INTO sanvel_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadaaha.m vadi.syaami, he kukarmmakaari.no yu.smaan aha.m na vedmi, yuuya.m matsamiipaad duuriibhavata| ");
INSERT INTO sanvel_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ya.h ka\"scit mamaitaa.h kathaa.h \"srutvaa paalayati, sa paa.saa.nopari g.rhanirmmaatraa j naaninaa saha mayopamiiyate| ");
INSERT INTO sanvel_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yato v.r.s.tau satyaam aaplaava aagate vaayau vaate ca te.su tadgeha.m lagne.su paa.saa.nopari tasya bhittestanna patatil ");
INSERT INTO sanvel_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu ya.h ka\"scit mamaitaa.h kathaa.h \"srutvaa na paalayati sa saikate gehanirmmaatraa .aj naaninaa upamiiyate| ");
INSERT INTO sanvel_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yato jalav.r.s.tau satyaam aaplaava aagate pavane vaate ca tai rg.rhe samaaghaate tat patati tatpatana.m mahad bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yii\"sunaite.su vaakye.su samaapite.su maanavaastadiiyopade\"sam aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmaat sa upaadhyaayaa iva taan nopadide\"sa kintu samarthapuru.sa_iva samupadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadaa sa parvvataad avaarohat tadaa bahavo maanavaastatpa\"scaad vavraju.h| ");
INSERT INTO sanvel_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","eka.h ku.s.thavaan aagatya ta.m pra.namya babhaa.se, he prabho, yadi bhavaan sa.mmanyate, tarhi maa.m niraamaya.m karttu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tato yii\"su.h kara.m prasaaryya tasyaa\"nga.m sp.r\"san vyaajahaara, sammanye.aha.m tva.m niraamayo bhava; tena sa tatk.sa.naat ku.s.thenaamoci| ");
INSERT INTO sanvel_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tato yii\"susta.m jagaada, avadhehi kathaametaa.m ka\"scidapi maa bruuhi, kintu yaajakasya sannidhi.m gatvaa svaatmaana.m dar\"saya manujebhyo nijaniraamayatva.m pramaa.nayitu.m muusaaniruupita.m dravyam uts.rja ca| ");
INSERT INTO sanvel_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantara.m yii\"sunaa kapharnaahuumnaamani nagare pravi.s.te ka\"scit \"satasenaapatistatsamiipam aagatya viniiya babhaa.se, ");
INSERT INTO sanvel_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","he prabho, madiiya eko daasa.h pak.saaghaatavyaadhinaa bh.r\"sa.m vyathita.h, satu \"sayaniiya aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadaanii.m yii\"sustasmai kathitavaan, aha.m gatvaa ta.m niraamaya.m kari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tata.h sa \"satasenaapati.h pratyavadat, he prabho, bhavaan yat mama gehamadhya.m yaati tadyogyabhaajana.m naahamasmi; vaa\"nmaatram aadi\"satu, tenaiva mama daaso niraamayo bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yato mayi paranidhne.api mama nide\"sava\"syaa.h kati kati senaa.h santi, tata ekasmin yaahiityukte sa yaati, tadanyasmin ehiityukte sa aayaati, tathaa mama nijadaase karmmaitat kurvvityukte sa tat karoti| ");
INSERT INTO sanvel_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadaanii.m yii\"sustasyaitat vaco ni\"samya vismayaapanno.abhuut; nijapa\"scaadgaamino maanavaan avocca, yu.smaan tathya.m vacmi, israayeliiyalokaanaa.m madhye.api naitaad.r\"so vi\"svaaso mayaa praapta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyaccaaha.m yu.smaan vadaami, bahava.h puurvvasyaa.h pa\"scimaayaa\"sca di\"sa aagatya ibraahiimaa ishaakaa yaakuubaa ca saakam militvaa samupavek.syanti; ");
INSERT INTO sanvel_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthaane rodanadantaghar.sa.ne bhavatastasmin bahirbhuutatamisre raajyasya santaanaa nik.sesyante| ");
INSERT INTO sanvel_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tata.h para.m yii\"susta.m \"satasenaapati.m jagaada, yaahi, tava pratiityanusaarato ma\"ngala.m bhuuyaat; tadaa tasminneva da.n.de tadiiyadaaso niraamayo babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantara.m yii\"su.h pitarasya gehamupasthaaya jvare.na pii.ditaa.m \"sayaniiyasthitaa.m tasya \"sva\"sruu.m viik.saa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastena tasyaa.h karasya sp.r.s.tatavaat jvarastaa.m tatyaaja, tadaa saa samutthaaya taan si.seve| ");
INSERT INTO sanvel_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantara.m sandhyaayaa.m satyaa.m bahu\"so bhuutagrastamanujaan tasya samiipam aaninyu.h sa ca vaakyena bhuutaan tyaajayaamaasa, sarvvaprakaarapii.ditajanaa.m\"sca niraamayaan cakaara; ");
INSERT INTO sanvel_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmaat, sarvvaa durbbalataasmaaka.m tenaiva paridhaaritaa| asmaaka.m sakala.m vyaadhi.m saeva sa.mg.rhiitavaan| yadetadvacana.m yi\"sayiyabhavi.syadvaadinoktamaasiit, tattadaa saphalamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantara.m yii\"su\"scaturdik.su jananivaha.m vilokya ta.tinyaa.h paara.m yaatu.m \"si.syaan aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadaaniim eka upaadhyaaya aagatya kathitavaan, he guro, bhavaan yatra yaasyati tatraahamapi bhavata.h pa\"scaad yaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tato yii\"su rjagaada, kro.s.tu.h sthaatu.m sthaana.m vidyate, vihaayaso viha\"ngamaanaa.m nii.daani ca santi; kintu manu.syaputrasya \"sira.h sthaapayitu.m sthaana.m na vidyate| ");
INSERT INTO sanvel_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara eka.h \"si.syasta.m babhaa.se, he prabho, prathamato mama pitara.m \"sma\"saane nidhaatu.m gamanaartha.m maam anumanyasva| ");
INSERT INTO sanvel_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tato yii\"suruktavaan m.rtaa m.rtaan \"sma\"saane nidadhatu, tva.m mama pa\"scaad aagaccha| ");
INSERT INTO sanvel_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantara.m tasmin naavamaaruu.dhe tasya \"si.syaastatpa\"scaat jagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","pa\"scaat saagarasya madhya.m te.su gate.su taad.r\"sa.h prabalo jha nbh\"sanila udati.s.that, yena mahaatara\"nga utthaaya tara.ni.m chaaditavaan, kintu sa nidrita aasiit| ");
INSERT INTO sanvel_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadaa \"si.syaa aagatya tasya nidraabha\"nga.m k.rtvaa kathayaamaasu.h, he prabho, vaya.m mriyaamahe, bhavaan asmaaka.m praa.naan rak.satu| ");
INSERT INTO sanvel_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadaa sa taan uktavaan, he alpavi\"svaasino yuuya.m kuto vibhiitha? tata.h sa utthaaya vaata.m saagara nca tarjayaamaasa, tato nirvvaatamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","apara.m manujaa vismaya.m vilokya kathayaamaasu.h, aho vaatasaritpatii asya kimaaj naagraahi.nau? kiid.r\"so.aya.m maanava.h| ");
INSERT INTO sanvel_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantara.m sa paara.m gatvaa gideriiyade\"sam upasthitavaan; tadaa dvau bhuutagrastamanujau \"sma\"saanasthaanaad bahi rbhuutvaa ta.m saak.saat k.rtavantau, taavetaad.r\"sau praca.n.daavaastaa.m yat tena sthaanena kopi yaatu.m naa\"saknot| ");
INSERT INTO sanvel_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","taavucai.h kathayaamaasatu.h, he ii\"svarasya suuno yii\"so, tvayaa saakam aavayo.h ka.h sambandha.h? niruupitakaalaat praageva kimaavaabhyaa.m yaatanaa.m daatum atraagatosi? ");
INSERT INTO sanvel_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadaanii.m taabhyaa.m ki ncid duure varaahaa.naam eko mahaavrajo.acarat| ");
INSERT INTO sanvel_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tato bhuutau tau tasyaantike viniiya kathayaamaasatu.h, yadyaavaa.m tyaajayasi, tarhi varaahaa.naa.m madhyevrajam aavaa.m preraya| ");
INSERT INTO sanvel_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadaa yii\"suravadat yaata.m, anantara.m tau yadaa manujau vihaaya varaahaan aa\"sritavantau, tadaa te sarvve varaahaa uccasthaanaat mahaajavena dhaavanta.h saagariiyatoye majjanto mamru.h| ");
INSERT INTO sanvel_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tato varaaharak.sakaa.h palaayamaanaa madhyenagara.m tau bhuutagrastau prati yadyad agha.tata, taa.h sarvvavaarttaa avadan| ");
INSERT INTO sanvel_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tato naagarikaa.h sarvve manujaa yii\"su.m saak.saat karttu.m bahiraayaataa.h ta nca vilokya praarthayaa ncakrire bhavaan asmaaka.m siimaato yaatu| ");
INSERT INTO sanvel_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantara.m yii\"su rnaukaamaaruhya puna.h paaramaagatya nijagraamam aayayau| ");
INSERT INTO sanvel_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tata.h katipayaa janaa eka.m pak.saaghaatina.m sva.t.topari \"saayayitvaa tatsamiipam aanayan; tato yii\"suste.saa.m pratiiti.m vij naaya ta.m pak.saaghaatina.m jagaada, he putra, susthiro bhava, tava kalu.sasya mar.sa.na.m jaatam| ");
INSERT INTO sanvel_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","taa.m kathaa.m ni\"samya kiyanta upaadhyaayaa mana.hsu cintitavanta e.sa manuja ii\"svara.m nindati| ");
INSERT INTO sanvel_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tata.h sa te.saam etaad.r\"sii.m cintaa.m vij naaya kathitavaan, yuuya.m mana.hsu k.rta etaad.r\"sii.m kucintaa.m kurutha? ");
INSERT INTO sanvel_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava paapamar.sa.na.m jaata.m, yadvaa tvamutthaaya gaccha, dvayoranayo rvaakyayo.h ki.m vaakya.m vaktu.m sugama.m? ");
INSERT INTO sanvel_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu medinyaa.m kalu.sa.m k.samitu.m manujasutasya saamarthyamastiiti yuuya.m yathaa jaaniitha, tadartha.m sa ta.m pak.saaghaatina.m gaditavaan, utti.s.tha, nija\"sayaniiya.m aadaaya geha.m gaccha| ");
INSERT INTO sanvel_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tata.h sa tatk.sa.naad utthaaya nijageha.m prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","maanavaa ittha.m vilokya vismaya.m menire, ii\"svare.na maanavaaya saamarthyam iid.r\"sa.m datta.m iti kaara.naat ta.m dhanya.m babhaa.sire ca| ");
INSERT INTO sanvel_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantara.m yii\"sustatsthaanaad gacchan gacchan karasa.mgrahasthaane samupavi.s.ta.m mathinaamaanam eka.m manuja.m vilokya ta.m babhaa.se, mama pa\"scaad aagaccha, tata.h sa utthaaya tasya pa\"scaad vavraaja| ");
INSERT INTO sanvel_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tata.h para.m yii\"sau g.rhe bhoktum upavi.s.te bahava.h karasa.mgraahi.na.h kalu.si.na\"sca maanavaa aagatya tena saaka.m tasya \"si.syai\"sca saakam upavivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phiruu\"sinastad d.r.s.tvaa tasya \"si.syaan babhaa.sire, yu.smaaka.m guru.h ki.m nimitta.m karasa.mgraahibhi.h kalu.sibhi\"sca saaka.m bhu.mkte? ");
INSERT INTO sanvel_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yii\"sustat \"srutvaa taan pratyavadat, niraamayalokaanaa.m cikitsakena prayojana.m naasti, kintu saamayalokaanaa.m prayojanamaaste| ");
INSERT INTO sanvel_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ato yuuya.m yaatvaa vacanasyaasyaartha.m \"sik.sadhvam, dayaayaa.m me yathaa priiti rna tathaa yaj nakarmma.ni|yato.aha.m dhaarmmikaan aahvaatu.m naagato.asmi kintu mana.h parivarttayitu.m paapina aahvaatum aagato.asmi| ");
INSERT INTO sanvel_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantara.m yohana.h \"si.syaastasya samiipam aagatya kathayaamaasu.h, phiruu\"sino vaya nca puna.h punarupavasaama.h, kintu tava \"si.syaa nopavasanti, kuta.h? ");
INSERT INTO sanvel_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadaa yii\"sustaan avocat yaavat sakhiinaa.m sa.m\"nge kanyaayaa varasti.s.thati, taavat ki.m te vilaapa.m karttu.m \"sakluvanti? kintu yadaa te.saa.m sa.m\"ngaad vara.m nayanti, taad.r\"sa.h samaya aagami.syati, tadaa te upavatsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","puraatanavasane kopi naviinavastra.m na yojayati, yasmaat tena yojitena puraatanavasana.m chinatti tacchidra nca bahukutsita.m d.r\"syate| ");
INSERT INTO sanvel_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anya nca puraatanakutvaa.m kopi navaanagostaniirasa.m na nidadhaati, yasmaat tathaa k.rte kutuu rvidiiryyate tena gostaniirasa.h patati kutuu\"sca na\"syati; tasmaat naviinaayaa.m kutvaa.m naviino gostaniirasa.h sthaapyate, tena dvayoravana.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","apara.m tenaitatkathaakathanakaale eko.adhipatista.m pra.namya babhaa.se, mama duhitaa praaye.naitaavatkaale m.rtaa, tasmaad bhavaanaagatya tasyaa gaatre hastamarpayatu, tena saa jiivi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadaanii.m yii\"su.h \"si.syai.h saakam utthaaya tasya pa\"scaad vavraaja| ");
INSERT INTO sanvel_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantare dvaada\"savatsaraan yaavat pradaraamayena \"siir.naikaa naarii tasya pa\"scaad aagatya tasya vasanasya granthi.m paspar\"sa; ");
INSERT INTO sanvel_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmaat mayaa kevala.m tasya vasana.m sp.r.s.tvaa svaasthya.m praapsyate, saa naariiti manasi ni\"scitavatii| ");
INSERT INTO sanvel_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tato yii\"survadana.m paraavarttya taa.m jagaada, he kanye, tva.m susthiraa bhava, tava vi\"svaasastvaa.m svasthaamakaar.siit| etadvaakye gaditaeva saa yo.sit svasthaabhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","apara.m yii\"sustasyaadhyak.sasya geha.m gatvaa vaadakaprabh.rtiin bahuun lokaan \"sabdaayamaanaan vilokya taan avadat, ");
INSERT INTO sanvel_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthaana.m tyaja, kanyeya.m naamriyata nidritaaste; kathaametaa.m \"srutvaa te tamupajahasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvve.su bahi.sk.rte.su so.abhyantara.m gatvaa kanyaayaa.h kara.m dh.rtavaan, tena sodati.s.that; ");
INSERT INTO sanvel_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmma.no ya\"sa.h k.rtsna.m ta.m de\"sa.m vyaaptavat| ");
INSERT INTO sanvel_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tata.h para.m yii\"sustasmaat sthaanaad yaatraa.m cakaara; tadaa he daayuuda.h santaana, asmaan dayasva, iti vadantau dvau janaavandhau procairaahuuyantau tatpa\"scaad vavrajatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tato yii\"sau gehamadhya.m pravi.s.ta.m taavapi tasya samiipam upasthitavantau, tadaanii.m sa tau p.r.s.tavaan karmmaitat karttu.m mama saamarthyam aaste, yuvaa.m kimiti pratiitha.h? tadaa tau pratyuucatu.h, satya.m prabho| ");
INSERT INTO sanvel_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadaanii.m sa tayo rlocanaani sp.r\"san babhaa.se, yuvayo.h pratiityanusaaraad yuvayo rma\"ngala.m bhuuyaat| tena tatk.sa.naat tayo rnetraa.ni prasannaanyabhavan, ");
INSERT INTO sanvel_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","pa\"scaad yii\"sustau d.r.dhamaaj naapya jagaada, avadhattam etaa.m kathaa.m kopi manujo ma jaaniiyaat| ");
INSERT INTO sanvel_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthaaya tasmin k.rtsne de\"se tasya kiirtti.m prakaa\"sayaamaasatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","apara.m tau bahiryaata etasminnantare manujaa eka.m bhuutagrastamuuka.m tasya samiipam aaniitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tena bhuute tyaajite sa muuka.h kathaa.m kathayitu.m praarabhata, tena janaa vismaya.m vij naaya kathayaamaasu.h, israayelo va.m\"se kadaapi ned.rgad.r\"syata; ");
INSERT INTO sanvel_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phiruu\"sina.h kathayaa ncakru.h bhuutaadhipatinaa sa bhuutaan tyaajayati| ");
INSERT INTO sanvel_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tata.h para.m yii\"suste.saa.m bhajanabhavana upadi\"san raajyasya susa.mvaada.m pracaarayan lokaanaa.m yasya ya aamayo yaa ca pii.daasiit, taan \"samayan \"samaya.m\"sca sarvvaa.ni nagaraa.ni graamaa.m\"sca babhraama| ");
INSERT INTO sanvel_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anya nca manujaan vyaakulaan arak.sakame.saaniva ca tyaktaan niriik.sya te.su kaaru.nika.h san \"si.syaan avadat, ");
INSERT INTO sanvel_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","\"sasyaani pracuraa.ni santi, kintu chettaara.h stokaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","k.setra.m pratyaparaan chedakaan prahetu.m \"sasyasvaamina.m praarthayadhvam| ");
INSERT INTO sanvel_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantara.m yii\"su rdvaada\"sa\"si.syaan aahuuyaamedhyabhuutaan tyaajayitu.m sarvvaprakaararogaan pii.daa\"sca \"samayitu.m tebhya.h saamarthyamadaat| ");
INSERT INTO sanvel_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","te.saa.m dvaada\"sapre.syaa.naa.m naamaanyetaani| prathama.m \"simon ya.m pitara.m vadanti, tata.h para.m tasya sahaja aandriya.h, sivadiyasya putro yaakuub ");
INSERT INTO sanvel_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajo yohan; philip barthalamay thomaa.h karasa.mgraahii mathi.h, aalpheyaputro yaakuub, ");
INSERT INTO sanvel_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinaaniiya.h \"simon, ya ii.skariyotiiyayihuudaa.h khrii.s.ta.m parakare.arpayat| ");
INSERT INTO sanvel_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","etaan dvaada\"sa\"si.syaan yii\"su.h pre.sayan ityaaj naapayat, yuuyam anyade\"siiyaanaa.m padavii.m \"semiro.niiyaanaa.m kimapi nagara nca na pravi\"sye ");
INSERT INTO sanvel_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","israayelgotrasya haaritaa ye ye me.saaste.saameva samiipa.m yaata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvaa gatvaa svargasya raajatva.m savidhamabhavat, etaa.m kathaa.m pracaarayata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","aamayagrastaan svasthaan kuruta, ku.s.thina.h pari.skuruta, m.rtalokaan jiivayata, bhuutaan tyaajayata, vinaa muulya.m yuuyam alabhadhva.m vinaiva muulya.m vi\"sraa.nayata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu sve.saa.m ka.tibandhe.su svar.naruupyataamraa.naa.m kimapi na g.rhliita| ");
INSERT INTO sanvel_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyacca yaatraayai celasampu.ta.m vaa dvitiiyavasana.m vaa paaduke vaa ya.s.ti.h, etaan maa g.rhliita, yata.h kaaryyak.rt bharttu.m yogyo bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","apara.m yuuya.m yat pura.m ya nca graama.m pravi\"satha, tatra yo jano yogyapaatra.m tamavagatya yaanakaala.m yaavat tatra ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadaa yuuya.m tadgeha.m pravi\"satha, tadaa tamaa\"si.sa.m vadata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yogyapaatra.m bhavati, tarhi tatkalyaa.na.m tasmai bhavi.syati, nocet saa\"siiryu.smabhyameva bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu ye janaa yu.smaakamaatithya.m na vidadhati yu.smaaka.m kathaa nca na \"s.r.nvanti te.saa.m gehaat puraadvaa prasthaanakaale svapaduulii.h paatayata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yu.smaanaha.m tathya.m vacmi vicaaradine tatpurasya da\"saata.h sidomamoraapurayorda\"saa sahyataraa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","pa\"syata, v.rkayuuthamadhye me.sa.h yathaavistathaa yu.smaana prahi.nomi, tasmaad yuuyam ahiriva satarkaa.h kapotaaivaahi.msakaa bhavata| ");
INSERT INTO sanvel_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","n.rbhya.h saavadhaanaa bhavata; yatastai ryuuya.m raajasa.msadi samarpi.syadhve te.saa.m bhajanagehe prahaari.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yuuya.m mannaamaheto.h \"saast.r.naa.m raaj naa nca samak.sa.m taananyade\"sina\"scaadhi saak.sitvaarthamaane.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvittha.m samarpitaa yuuya.m katha.m kimuttara.m vak.syatha tatra maa cintayata, yatastadaa yu.smaabhi ryad vaktavya.m tat tadda.n.de yu.smanmana.h su samupasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmaat tadaa yo vak.syati sa na yuuya.m kintu yu.smaakamantarastha.h pitraatmaa| ");
INSERT INTO sanvel_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahaja.h sahaja.m taata.h suta nca m.rtau samarpayi.syati, apatyaagi svasvapitroे rvipak.siibhuuya tau ghaatayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamaheto.h sarvve janaa yu.smaan .rृtiiyi.syante, kintu ya.h \"se.sa.m yaavad dhairyya.m gh.rtvaa sthaasyati, sa traayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadaa yuuyamekapure taa.di.syadhve, tadaa yuuyamanyapura.m palaayadhva.m yu.smaanaha.m tathya.m vacmi yaavanmanujasuto naiti taavad israayelde\"siiyasarvvanagarabhrama.na.m samaapayitu.m na \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","guro.h \"si.syo na mahaan, prabhordaaso na mahaan| ");
INSERT INTO sanvel_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi \"si.syo nijaguro rdaasa\"sca svaprabho.h samaano bhavati tarhi tad yathe.s.ta.m| cettairg.rhapatirbhuutaraaja ucyate, tarhi parivaaraa.h ki.m tathaa na vak.syante? ");
INSERT INTO sanvel_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tebhyo yuuya.m maa bibhiita, yato yanna prakaa\"si.syate, taad.rk chaadita.m kimapi naasti, yacca na vya nci.syate, taad.rg gupta.m kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadaha.m yu.smaan tamasi vacmi tad yu.smaabhirdiiptau kathyataa.m; kar.naabhyaa.m yat \"sruuyate tad gehopari pracaaryyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ye kaaya.m hantu.m \"saknuvanti naatmaana.m, tebhyo maa bhai.s.ta; ya.h kaayaatmaanau niraye naa\"sayitu.m, \"saknoti, tato bibhiita| ");
INSERT INTO sanvel_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau ca.takau kimekataamramudrayaa na vikriiyete? tathaapi yu.smattaataanumati.m vinaa te.saamekopi bhuvi na patati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yu.smacchirasaa.m sarvvakacaa ga.nitaa.m.h santi| ");
INSERT INTO sanvel_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ato maa bibhiita, yuuya.m bahuca.takebhyo bahumuulyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yo manujasaak.saanmaama\"ngiikurute tamaha.m svargasthataatasaak.saada\"ngiikari.sye| ");
INSERT INTO sanvel_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","p.rthvyaamaha.m \"saanti.m daatumaagata_iti maanubhavata, \"saanti.m daatu.m na kintvasi.m| ");
INSERT INTO sanvel_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pit.rmaat.r\"sca\"sruubhi.h saaka.m sutasutaabadhuu rvirodhayitu ncaagateाsmi| ");
INSERT INTO sanvel_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tata.h svasvaparivaaraeva n.r\"satru rbhavitaa| ");
INSERT INTO sanvel_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ya.h pitari maatari vaa mattodhika.m priiyate, sa na madarha.h; ");
INSERT INTO sanvel_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ya\"sca sute sutaayaa.m vaa mattodhika.m priiyate, seाpi na madarha.h| ");
INSERT INTO sanvel_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ya.h svakru\"sa.m g.rhlan matpa\"scaannaiti, seाpi na madarha.h| ");
INSERT INTO sanvel_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ya.h svapraa.naanavati, sa taan haarayi.syate, yastu matk.rte svapraa.naan haarayati, sa taanavati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yo yu.smaakamaatithya.m vidadhaati, sa mamaatithya.m vidadhaati, ya\"sca mamaatithya.m vidadhaati, sa matprerakasyaatithya.m vidadhaati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yo bhavi.syadvaadiiti j naatvaa tasyaatithya.m vidhatte, sa bhavi.syadvaadina.h phala.m lapsyate, ya\"sca dhaarmmika iti viditvaa tasyaatithya.m vidhatte sa dhaarmmikamaanavasya phala.m praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ya\"sca ka\"scit ete.saa.m k.sudranaraa.naam ya.m ka ncanaika.m \"si.sya iti viditvaa ka.msaika.m \"siitalasalila.m tasmai datte, yu.smaanaha.m tathya.m vadaami, sa kenaapi prakaare.na phalena na va nci.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ittha.m yii\"su.h svadvaada\"sa\"si.syaa.naamaaj naapana.m samaapya pure pura upade.s.tu.m susa.mvaada.m pracaarayitu.m tatsthaanaat pratasthe| ");
INSERT INTO sanvel_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantara.m yohan kaaraayaa.m ti.s.than khri.s.tasya karmma.naa.m vaartta.m praapya yasyaagamanavaarttaasiit saeva ki.m tva.m? vaa vayamanyam apek.si.syaamahe? ");
INSERT INTO sanvel_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","etat pra.s.tu.m nijau dvau \"si.syau praahi.not| ");
INSERT INTO sanvel_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yii\"su.h pratyavocat, andhaa netraa.ni labhante, kha ncaa gacchanti, ku.s.thina.h svasthaa bhavanti, badhiraa.h \"s.r.nvanti, m.rtaa jiivanta utti.s.thanti, daridraa.naa.m samiipe susa.mvaada.h pracaaryyata, ");
INSERT INTO sanvel_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","etaani yadyad yuvaa.m \"s.r.nutha.h pa\"syatha\"sca gatvaa tadvaarttaa.m yohana.m gadata.m| ");
INSERT INTO sanvel_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyaaha.m na vighniibhavaami, saeva dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantara.m tayo.h prasthitayo ryii\"su ryohanam uddi\"sya janaan jagaada, yuuya.m ki.m dra.s.tu.m vahirmadhyepraantaram agacchata? ki.m vaatena kampita.m nala.m? ");
INSERT INTO sanvel_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vaa ki.m viik.situ.m vahirgatavanta.h? ki.m parihitasuuk.smavasana.m manujameka.m? pa\"syata, ye suuk.smavasanaani paridadhati, te raajadhaanyaa.m ti.s.thanti| ");
INSERT INTO sanvel_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yuuya.m ki.m dra.s.tu.m bahiragamata, kimeka.m bhavi.syadvaadina.m? tadeva satya.m| yu.smaanaha.m vadaami, sa bhavi.syadvaadinopi mahaan; ");
INSERT INTO sanvel_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yata.h, pa\"sya svakiiyaduutoya.m tvadagre pre.syate mayaa| sa gatvaa tava panthaana.m smayak pari.skari.syati|| etadvacana.m yamadhi likhitamaaste so.aya.m yohan| ");
INSERT INTO sanvel_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","apara.m yu.smaanaha.m tathya.m braviimi, majjayitu ryohana.h \"sre.s.tha.h kopi naariito naajaayata; tathaapi svargaraajyamadhye sarvvebhyo ya.h k.sudra.h sa yohana.h \"sre.s.tha.h| ");
INSERT INTO sanvel_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","apara nca aa yohano.adya yaavat svargaraajya.m balaadaakraanta.m bhavati aakramina\"sca janaa balena tadadhikurvvanti| ");
INSERT INTO sanvel_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yato yohana.m yaavat sarvvabhavi.syadvaadibhi rvyavasthayaa ca upade\"sa.h praakaa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yuuyamida.m vaakya.m grahiitu.m \"saknutha, tarhi \"sreya.h, yasyaagamanasya vacanamaaste so.ayam eliya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya \"srotu.m kar.nau sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ete vidyamaanajanaa.h kai rmayopamiiyante? ye baalakaa ha.t.ta upavi\"sya sva.m sva.m bandhumaahuuya vadanti, ");
INSERT INTO sanvel_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vaya.m yu.smaaka.m samiipe va.m\"siiravaadayaama, kintu yuuya.m naan.rtyata; yu.smaaka.m samiipe ca vayamarodima, kintu yuuya.m na vyalapata, taad.r\"sai rbaalakaista upamaayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yato yohan aagatya na bhuktavaan na piitavaa.m\"sca, tena lokaa vadanti, sa bhuutagrasta iti| ");
INSERT INTO sanvel_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta aagatya bhuktavaan piitavaa.m\"sca, tena lokaa vadanti, pa\"syata e.sa bhoktaa madyapaataa ca.n.daalapaapinaa.m bandha\"sca, kintu j naanino j naanavyavahaara.m nirdo.sa.m jaananti| ");
INSERT INTO sanvel_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra pure bahvaa\"scaryya.m karmma k.rtavaan, tannivaasinaa.m mana.hparaav.rttyabhaavaat taani nagaraa.ni prati hantetyuktaa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","haa koraasiin, haa baitsaide, yu.smanmadhye yadyadaa\"scaryya.m karmma k.rta.m yadi tat sorasiidonnagara akaari.syata, tarhi puurvvameva tannivaasina.h \"saa.navasane bhasmani copavi\"santo manaa.msi paraavartti.syanta| ");
INSERT INTO sanvel_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmaadaha.m yu.smaan vadaami, vicaaradine yu.smaaka.m da\"saata.h sorasiidono rda\"saa sahyataraa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","apara nca bata kapharnaahuum, tva.m svarga.m yaavadunnatosi, kintu narake nik.sepsyase, yasmaat tvayi yaanyaa\"scaryyaa.ni karmma.nyakaari.sata, yadi taani sidomnagara akaari.syanta, tarhi tadadya yaavadasthaasyat| ");
INSERT INTO sanvel_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvaha.m yu.smaan vadaami, vicaaradine tava da.n.data.h sidomo da.n.do sahyataro bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","etasminneva samaye yii\"su.h punaruvaaca, he svargap.rthivyorekaadhipate pitastva.m j naanavato vidu.sa\"sca lokaan pratyetaani na prakaa\"sya baalakaan prati prakaa\"sitavaan, iti hetostvaa.m dhanya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","he pita.h, ittha.m bhavet yata ida.m tvad.r.s.taavuttama.m| ");
INSERT INTO sanvel_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitraa mayi sarvvaa.ni samarpitaani, pitara.m vinaa kopi putra.m na jaanaati, yaan prati putre.na pitaa prakaa\"syate taan vinaa putraad anya.h kopi pitara.m na jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","he pari\"sraantaa bhaaraakraantaa\"sca lokaa yuuya.m matsannidhim aagacchata, aha.m yu.smaan vi\"sramayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","aha.m k.sama.na\"siilo namramanaa\"sca, tasmaat mama yuga.m sve.saamupari dhaarayata matta.h \"sik.sadhva nca, tena yuuya.m sve sve manasi vi\"sraama.m lapsyadhbe| ");
INSERT INTO sanvel_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yato mama yugam anaayaasa.m mama bhaara\"sca laghu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantara.m yii\"su rvi\"sraamavaare \"ssyamadhyena gacchati, tadaa tacchi.syaa bubhuk.sitaa.h santa.h \"ssyama njarii\"schatvaa chitvaa khaaditumaarabhanta| ");
INSERT INTO sanvel_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilokya phiruu\"sino yii\"su.m jagadu.h, pa\"sya vi\"sraamavaare yat karmmaakarttavya.m tadeva tava \"si.syaa.h kurvvanti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa taan pratyaavadata, daayuud tatsa\"ngina\"sca bubhuk.sitaa.h santo yat karmmaakurvvan tat ki.m yu.smaabhi rnaapaa.thi? ");
INSERT INTO sanvel_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ye dar\"saniiyaa.h puupaa.h yaajakaan vinaa tasya tatsa\"ngimanujaanaa ncaabhojaniiyaasta ii\"svaraavaasa.m pravi.s.tena tena bhuktaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyacca vi\"sraamavaare madhyemandira.m vi\"sraamavaariiya.m niyama.m la\"nvantopi yaajakaa nirdo.saa bhavanti, \"saastramadhye kimidamapi yu.smaabhi rna pa.thita.m? ");
INSERT INTO sanvel_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yu.smaanaha.m vadaami, atra sthaane mandiraadapi gariiyaan eka aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayaayaa.m me yathaa priiti rna tathaa yaj nakarmma.ni| etadvacanasyaartha.m yadi yuyam aj naasi.s.ta tarhi nirdo.saan do.si.no naakaar.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyacca manujasuto vi\"sraamavaarasyaapi patiraaste| ");
INSERT INTO sanvel_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantara.m sa tatsthaanaat prasthaaya te.saa.m bhajanabhavana.m pravi.s.tavaan, tadaaniim eka.h \"su.skakaraamayavaan upasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tato yii\"sum apavaditu.m maanu.saa.h papracchu.h, vi\"sraamavaare niraamayatva.m kara.niiya.m na vaa? ");
INSERT INTO sanvel_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tena sa pratyuvaaca, vi\"sraamavaare yadi kasyacid avi rgartte patati, tarhi yasta.m gh.rtvaa na tolayati, etaad.r\"so manujo yu.smaaka.m madhye ka aaste? ");
INSERT INTO sanvel_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ave rmaanava.h ki.m nahi \"sreyaan? ato vi\"sraamavaare hitakarmma karttavya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantara.m sa ta.m maanava.m gaditavaan, kara.m prasaaraya; tena kare prasaarite sonyakaravat svastho.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadaa phiruu\"sino bahirbhuuya katha.m ta.m hani.syaama iti kumantra.naa.m tatpraatikuulyena cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tato yii\"sustad viditvaa sthanaantara.m gatavaan; anye.su bahunare.su tatpa\"scaad gate.su taan sa niraamayaan k.rtvaa ityaaj naapayat, ");
INSERT INTO sanvel_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yuuya.m maa.m na paricaayayata| ");
INSERT INTO sanvel_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmaat mama priiyo manoniito manasastu.s.tikaaraka.h| madiiya.h sevako yastu vidyate ta.m samiik.sataa.m| tasyopari svakiiyaatmaa mayaa sa.msthaapayi.syate| tenaanyade\"sajaate.su vyavasthaa sa.mprakaa\"syate| ");
INSERT INTO sanvel_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kenaapi na virodha.m sa vivaada nca kari.syati| na ca raajapathe tena vacana.m \"sraavayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthaa calitaa yaavat nahi tena kari.syate| taavat nalo vidiir.no.api bha.mk.syate nahi tena ca| tathaa sadhuumavartti nca na sa nirvvaapayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyaa\"saa nca kari.syanti tannaamni bhinnade\"sajaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yaanyetaani vacanaani yi\"sayiyabhavi.syadvaadinaa proktaanyaasan, taani saphalaanyabhavan| ");
INSERT INTO sanvel_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantara.m lokai statsamiipam aaniito bhuutagrastaandhamuukaikamanujastena svasthiik.rta.h, tata.h so.andho muuko dra.s.tu.m vaktu ncaarabdhavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anena sarvve vismitaa.h kathayaa ncakru.h, e.sa.h ki.m daayuuda.h santaano nahi? ");
INSERT INTO sanvel_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phiruu\"sinastat \"srutvaa gaditavanta.h, baalsibuubnaamno bhuutaraajasya saahaayya.m vinaa naaya.m bhuutaan tyaajayati| ");
INSERT INTO sanvel_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadaanii.m yii\"suste.saam iti maanasa.m vij naaya taan avadat ki ncana raajya.m yadi svavipak.saad bhidyate, tarhi tat ucchidyate; yacca ki ncana nagara.m vaa g.rha.m svavipak.saad vibhidyate, tat sthaatu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat \"sayataano yadi \"sayataana.m bahi.h k.rtvaa svavipak.saat p.rthak p.rthak bhavati, tarhi tasya raajya.m kena prakaare.na sthaasyati? ");
INSERT INTO sanvel_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","aha nca yadi baalsibuubaa bhuutaan tyaajayaami, tarhi yu.smaaka.m santaanaa.h kena bhuutaan tyaajayanti? tasmaad yu.smaakam etadvicaarayitaarasta eva bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavaha.m yadii\"svaraatmanaa bhuutaan tyaajayaami, tarhii\"svarasya raajya.m yu.smaaka.m sannidhimaagatavat| ");
INSERT INTO sanvel_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anya nca kopi balavanta jana.m prathamato na badvvaa kena prakaare.na tasya g.rha.m pravi\"sya taddravyaadi lo.thayitu.m \"saknoti? kintu tat k.rtvaa tadiiyag.rsya dravyaadi lo.thayitu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ya.h ka\"scit mama svapak.siiyo nahi sa vipak.siiya aaste, ya\"sca mayaa saaka.m na sa.mg.rhlaati, sa vikirati| ");
INSERT INTO sanvel_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataeva yu.smaanaha.m vadaami, manujaanaa.m sarvvaprakaarapaapaanaa.m nindaayaa\"sca mar.sa.na.m bhavitu.m \"saknoti, kintu pavitrasyaatmano viruddhanindaayaa mar.sa.na.m bhavitu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yo manujasutasya viruddhaa.m kathaa.m kathayati, tasyaaparaadhasya k.samaa bhavitu.m \"saknoti, kintu ya.h ka\"scit pavitrasyaatmano viruddhaa.m kathaa.m kathayati nehaloke na pretya tasyaaparaadhasya k.samaa bhavitu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","paadapa.m yadi bhadra.m vadatha, tarhi tasya phalamapi saadhu vaktavya.m, yadi ca paadapa.m asaadhu.m vadatha, tarhi tasya phalamapyasaadhu vaktavya.m; yata.h sviiyasviiyaphalena paadapa.h pariciiyate| ");
INSERT INTO sanvel_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","re bhujagava.m\"saa yuuyamasaadhava.h santa.h katha.m saadhu vaakya.m vaktu.m \"sak.syatha? yasmaad anta.hkara.nasya puur.nabhaavaanusaaraad vadanaad vaco nirgacchati| ");
INSERT INTO sanvel_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tena saadhurmaanavo.anta.hkara.naruupaat saadhubhaa.n.daagaaraat saadhu dravya.m nirgamayati, asaadhurmaanu.sastvasaadhubhaa.n.daagaaraad asaadhuvastuuni nirgamayati| ");
INSERT INTO sanvel_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvaha.m yu.smaan vadaami, manujaa yaavantyaalasyavacaa.msi vadanti, vicaaradine taduttaramava\"sya.m daatavya.m, ");
INSERT INTO sanvel_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastva.m sviiyavacobhi rniraparaadha.h sviiyavacobhi\"sca saaparaadho ga.ni.syase| ");
INSERT INTO sanvel_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadaanii.m katipayaa upaadhyaayaa.h phiruu\"sina\"sca jagadu.h, he guro vaya.m bhavatta.h ki ncana lak.sma did.rk.saama.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadaa sa pratyuktavaan, du.s.to vyabhicaarii ca va.m\"so lak.sma m.rgayate, kintu bhavi.syadvaadino yuunaso lak.sma vihaayaanyat kimapi lak.sma te na pradar\"sayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yato yuunam yathaa tryahoraatra.m b.rhanmiinasya kuk.saavaasiit, tathaa manujaputropi tryahoraatra.m medinyaa madhye sthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","apara.m niiniviiyaa maanavaa vicaaradina etadva.m\"siiyaanaa.m pratikuulam utthaaya taan do.si.na.h kari.syanti, yasmaatte yuunasa upade\"saat manaa.msi paraavarttayaa ncakrire, kintvatra yuunasopi gurutara eka aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","puna\"sca dak.si.nade\"siiyaa raaj nii vicaaradina etadva.m\"siiyaanaa.m pratikuulamutthaaya taan do.si.na.h kari.syati yata.h saa raaj nii sulemano vidyaayaa.h kathaa.m \"srotu.m medinyaa.h siimna aagacchat, kintu sulemanopi gurutara eko jano.atra aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","apara.m manujaad bahirgato .apavitrabhuuta.h \"su.skasthaanena gatvaa vi\"sraama.m gave.sayati, kintu tadalabhamaana.h sa vakti, yasmaa; niketanaad aagama.m, tadeva ve\"sma pakaav.rtya yaami| ");
INSERT INTO sanvel_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pa\"scaat sa tat sthaanam upasthaaya tat \"suunya.m maarjjita.m \"sobhita nca vilokya vrajan svatopi du.s.tataraan anyasaptabhuutaan sa\"ngina.h karoti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tataste tat sthaana.m pravi\"sya nivasanti, tena tasya manujasya \"se.sada\"saa puurvvada\"saatotiivaa\"subhaa bhavati, ete.saa.m du.s.tava.m\"syaanaamapi tathaiva gha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","maanavebhya etaasaa.m kathanaa.m kathanakaale tasya maataa sahajaa\"sca tena saaka.m kaa ncit kathaa.m kathayitu.m vaa nchanto bahireva sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tata.h ka\"scit tasmai kathitavaan, pa\"sya tava jananii sahajaa\"sca tvayaa saaka.m kaa ncana kathaa.m kathayitu.m kaamayamaanaa bahisti.s.thanti| ");
INSERT INTO sanvel_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa ta.m pratyavadat, mama kaa jananii? ke vaa mama sahajaa.h? ");
INSERT INTO sanvel_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","pa\"scaat \"si.syaan prati kara.m prasaaryya kathitavaan, pa\"sya mama jananii mama sahajaa\"scaite; ");
INSERT INTO sanvel_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ya.h ka\"scit mama svargasthasya pituri.s.ta.m karmma kurute, saeva mama bhraataa bhaginii jananii ca| ");
INSERT INTO sanvel_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","apara nca tasmin dine yii\"su.h sadmano gatvaa saritpate rodhasi samupavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanaanaa.m nivahopasthite.h sa tara.nimaaruhya samupaavi\"sat, tena maanavaa rodhasi sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadaanii.m sa d.r.s.taantaistaan ittha.m bahu\"sa upadi.s.tavaan| pa\"syata, ka\"scit k.r.siivalo biijaani vaptu.m bahirjagaama, ");
INSERT INTO sanvel_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakaale katipayabiije.su maargapaar\"sve patite.su vihagaastaani bhak.sitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","apara.m katipayabiije.su stokam.rdyuktapaa.saa.ne patite.su m.rdalpatvaat tatk.sa.naat taanya\"nkuritaani, ");
INSERT INTO sanvel_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravaavudite dagdhaani te.saa.m muulaapravi.s.tatvaat \"su.skataa.m gataani ca| ");
INSERT INTO sanvel_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","apara.m katipayabiije.su ka.n.takaanaa.m madhye patite.su ka.n.takaanyedhitvaa taani jagrasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","apara nca katipayabiijaani urvvaraayaa.m patitaani; te.saa.m madhye kaanicit \"satagu.naani kaanicit .sa.s.tigu.naani kaanicit tri.m\"sagu.m.naani phalaani phalitavanti| ");
INSERT INTO sanvel_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","\"srotu.m yasya \"srutii aasaate sa \"s.r.nuyaat| ");
INSERT INTO sanvel_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantara.m \"si.syairaagatya so.ap.rcchyata, bhavataa tebhya.h kuto d.r.s.taantakathaa kathyate? ");
INSERT INTO sanvel_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tata.h sa pratyavadat, svargaraajyasya niguu.dhaa.m kathaa.m veditu.m yu.smabhya.m saamarthyamadaayi, kintu tebhyo naadaayi| ");
INSERT INTO sanvel_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmaad yasyaantike varddhate, tasmaayeva daayi.syate, tasmaat tasya baahulya.m bhavi.syati, kintu yasyaantike na varddhate, tasya yat ki ncanaaste, tadapi tasmaad aadaayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","te pa\"syantopi na pa\"syanti, \"s.r.nvantopi na \"s.r.nvanti, budhyamaanaa api na budhyante ca, tasmaat tebhyo d.r.s.taantakathaa kathyate| ");
INSERT INTO sanvel_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathaa kar.nai.h \"sro.syatha yuuya.m vai kintu yuuya.m na bhotsyatha| netrairdrak.syatha yuuya nca parij naatu.m na \"sak.syatha| te maanu.saa yathaa naiva paripa\"syanti locanai.h| kar.nai ryathaa na \"s.r.nvanti na budhyante ca maanasai.h| vyaavarttite.su citte.su kaale kutraapi tairjanai.h| mattaste manujaa.h svasthaa yathaa naiva bhavanti ca| tathaa te.saa.m manu.syaa.naa.m kriyante sthuulabuddhaya.h| badhiriibhuutakar.naa\"sca jaataa\"sca mudritaa d.r\"sa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadetaani vacanaani yi\"sayiyabhavi.syadvaadinaa proktaani te.su taani phalanti| ");
INSERT INTO sanvel_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yu.smaaka.m nayanaani dhanyaani, yasmaat taani viik.sante; dhanyaa\"sca yu.smaaka.m \"sabdagrahaa.h, yasmaat tairaakar.nyate| ");
INSERT INTO sanvel_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayaa yuuya.m tathya.m vacaami yu.smaabhi ryadyad viik.syate, tad bahavo bhavi.syadvaadino dhaarmmikaa\"sca maanavaa did.rk.santopi dra.s.tu.m naalabhanta, puna\"sca yuuya.m yadyat \"s.r.nutha, tat te \"su\"sruu.samaa.naa api \"srotu.m naalabhanta| ");
INSERT INTO sanvel_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","k.r.siivaliiyad.r.s.taantasyaartha.m \"s.r.nuta| ");
INSERT INTO sanvel_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","maargapaar\"sve biijaanyuptaani tasyaartha e.sa.h, yadaa ka\"scit raajyasya kathaa.m ni\"samya na budhyate, tadaa paapaatmaagatya tadiiyamanasa uptaa.m kathaa.m haran nayati| ");
INSERT INTO sanvel_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","apara.m paa.saa.nasthale biijaanyuptaani tasyaartha e.sa.h; ka\"scit kathaa.m \"srutvaiva har.sacittena g.rhlaati, ");
INSERT INTO sanvel_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi muulaapravi.s.tatvaat sa ki ncitkaalamaatra.m sthirasti.s.thati; pa\"scaata tatkathaakaara.naat kopi klestaa.danaa vaa cet jaayate, tarhi sa tatk.sa.naad vighnameti| ");
INSERT INTO sanvel_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","apara.m ka.n.takaanaa.m madhye biijaanyuptaani tadartha e.sa.h; kenacit kathaayaa.m \"srutaayaa.m saa.msaarikacintaabhi rbhraantibhi\"sca saa grasyate, tena saa maa viphalaa bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvaraayaa.m biijaanyuptaani tadartha e.sa.h; ye taa.m kathaa.m \"srutvaa vudhyante, te phalitaa.h santa.h kecit \"satagu.naani kecita .sa.s.tigu.naani kecicca tri.m\"sadgu.naani phalaani janayanti| ");
INSERT INTO sanvel_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantara.m soparaamekaa.m d.r.s.taantakathaamupasthaapya tebhya.h kathayaamaasa; svargiiyaraajya.m taad.r\"sena kenacid g.rhasthenopamiiyate, yena sviiyak.setre pra\"sastabiijaanyaupyanta| ");
INSERT INTO sanvel_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu k.sa.nadaayaa.m sakalaloke.su supte.su tasya ripuraagatya te.saa.m godhuumabiijaanaa.m madhye vanyayavamabiijaanyuptvaa vavraaja| ");
INSERT INTO sanvel_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tato yadaa biijebhyo.a\"nkaraa jaayamaanaa.h ka.ni\"saani gh.rtavanta.h; tadaa vanyayavasaanyapi d.r\"syamaanaanyabhavan| ");
INSERT INTO sanvel_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tato g.rhasthasya daaseyaa aagamya tasmai kathayaa ncakru.h, he maheccha, bhavataa ki.m k.setre bhadrabiijaani naupyanta? tathaatve vanyayavasaani k.rta aayan? ");
INSERT INTO sanvel_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadaanii.m tena te pratigaditaa.h, kenacit ripu.naa karmmadamakaari| daaseyaa.h kathayaamaasu.h, vaya.m gatvaa taanyutpaayya k.sipaamo bhavata.h kiid.r\"siicchaa jaayate? ");
INSERT INTO sanvel_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tenaavaadi, nahi, \"sa\"nke.aha.m vanyayavasotpaa.tanakaale yu.smaabhistai.h saaka.m godhuumaa apyutpaa.ti.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ata.h \"ssyakarttanakaala.m yaavad ubhayaanyapi saha varddhantaa.m, pa\"scaat karttanakaale karttakaan vak.syaami, yuuyamaadau vanyayavasaani sa.mg.rhya daahayitu.m vii.tikaa badvvaa sthaapayata; kintu sarvve godhuumaa yu.smaabhi rbhaa.n.daagaara.m niitvaa sthaapyantaam| ");
INSERT INTO sanvel_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantara.m soparaamekaa.m d.r.s.taantakathaamutthaapya tebhya.h kathitavaan ka\"scinmanuja.h sar.sapabiijameka.m niitvaa svak.setra uvaapa| ");
INSERT INTO sanvel_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sar.sapabiija.m sarvvasmaad biijaat k.sudramapi sada\"nkurita.m sarvvasmaat \"saakaat b.rhad bhavati; sa taad.r\"sastaru rbhavati, yasya \"saakhaasu nabhasa.h khagaa aagatya nivasanti; svargiiyaraajya.m taad.r\"sasya sar.sapaikasya samam| ");
INSERT INTO sanvel_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamaakathaamekaa.m tebhya.h kathayaa ncakaara; kaacana yo.sit yat ki.nvamaadaaya dro.natrayamitagodhuumacuur.naanaa.m madhye sarvve.saa.m mi\"sriibhavanaparyyanta.m samaacchaadya nidhattavatii, tatki.nvamiva svargaraajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ittha.m yii\"su rmanujanivahaanaa.m sannidhaavupamaakathaabhiretaanyaakhyaanaani kathitavaan upamaa.m vinaa tebhya.h kimapi kathaa.m naakathayat| ");
INSERT INTO sanvel_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","etena d.r.s.taantiiyena vaakyena vyaadaaya vadana.m nija.m| aha.m prakaa\"sayi.syaami guptavaakya.m puraabhava.m| yadetadvacana.m bhavi.syadvaadinaa proktamaasiit, tat siddhamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvaan manujaan vis.rjya yii\"sau g.rha.m pravi.s.te tacchi.syaa aagatya yii\"save kathitavanta.h, k.setrasya vanyayavasiiyad.r.s.taantakathaam bhavaana asmaan spa.s.tiik.rtya vadatu| ");
INSERT INTO sanvel_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tata.h sa pratyuvaaca, yena bhadrabiijaanyupyante sa manujaputra.h, ");
INSERT INTO sanvel_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","k.setra.m jagat, bhadrabiijaanii raajyasya santaanaa.h, ");
INSERT INTO sanvel_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasaani paapaatmana.h santaanaa.h| yena ripu.naa taanyuptaani sa \"sayataana.h, karttanasamaya\"sca jagata.h \"se.sa.h, karttakaa.h svargiiyaduutaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathaa vanyayavasaani sa.mg.rhya daahyante, tathaa jagata.h \"se.se bhavi.syati; ");
INSERT INTO sanvel_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthaat manujasuta.h svaa.myaduutaan pre.sayi.syati, tena te ca tasya raajyaat sarvvaan vighnakaari.no.adhaarmmikalokaa.m\"sca sa.mg.rhya ");
INSERT INTO sanvel_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rodana.m dantaghar.sa.na nca bhavati, tatraagniku.n.de nik.sepsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadaanii.m dhaarmmikalokaa.h sve.saa.m pituu raajye bhaaskara_iva tejasvino bhavi.syanti| \"srotu.m yasya \"srutii aasaate, ma \"s.r.nuyaat| ");
INSERT INTO sanvel_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","apara nca k.setramadhye nidhi.m pa\"syan yo gopayati, tata.h para.m saanando gatvaa sviiyasarvvasva.m vikriiya ttak.setra.m krii.naati, sa iva svargaraajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anya nca yo va.nik uttamaa.m muktaa.m gave.sayan ");
INSERT INTO sanvel_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahaarghaa.m muktaa.m vilokya nijasarvvasva.m vikriiya taa.m krii.naati, sa iva svargaraajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","puna\"sca samudro nik.sipta.h sarvvaprakaaramiinasa.mgraahyaanaaya_iva svargaraajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin aanaaye puur.ne janaa yathaa rodhasyuttolya samupavi\"sya pra\"sastamiinaan sa.mgrahya bhaajane.su nidadhate, kutsitaan nik.sipanti; ");
INSERT INTO sanvel_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagata.h \"se.se bhavi.syati, phalata.h svargiiyaduutaa aagatya pu.nyavajjanaanaa.m madhyaat paapina.h p.rthak k.rtvaa vahniku.n.de nik.sepsyanti, ");
INSERT INTO sanvel_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rodana.m dantai rdantaghar.sa.na nca bhavi.syata.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yii\"sunaa te p.r.s.taa yu.smaabhi.h kimetaanyaakhyaanaanyabudhyanta? tadaa te pratyavadan, satya.m prabho| ");
INSERT INTO sanvel_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadaanii.m sa kathitavaan, nijabhaa.n.daagaaraat naviinapuraatanaani vastuuni nirgamayati yo g.rhastha.h sa iva svargaraajyamadhi \"sik.sitaa.h svarva upade.s.taara.h| ");
INSERT INTO sanvel_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantara.m yii\"suretaa.h sarvvaa d.r.s.taantakathaa.h samaapya tasmaat sthaanaat pratasthe| apara.m svade\"samaagatya janaan bhajanabhavana upadi.s.tavaan; ");
INSERT INTO sanvel_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","te vismaya.m gatvaa kathitavanta etasyaitaad.r\"sa.m j naanam aa\"scaryya.m karmma ca kasmaad ajaayata? ");
INSERT INTO sanvel_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimaya.m suutradhaarasya putro nahi? etasya maatu rnaama ca ki.m mariyam nahi? yaakub-yuu.saph-\"simon-yihuudaa\"sca kimetasya bhraataro nahi? ");
INSERT INTO sanvel_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","etasya bhaginya\"sca kimasmaaka.m madhye na santi? tarhi kasmaadayametaani labdhavaan? ittha.m sa te.saa.m vighnaruupo babhuuva; ");
INSERT INTO sanvel_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tato yii\"sunaa nigadita.m svade\"siiyajanaanaa.m madhya.m vinaa bhavi.syadvaadii kutraapyanyatra naasammaanyo bhavatii| ");
INSERT INTO sanvel_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","te.saamavi\"svaasaheto.h sa tatra sthaane bahvaa\"scaryyakarmmaa.ni na k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadaanii.m raajaa herod yii\"so rya\"sa.h \"srutvaa nijadaaseyaan jagaad, ");
INSERT INTO sanvel_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e.sa majjayitaa yohan, pramitebhayastasyotthaanaat tenetthamadbhuta.m karmma prakaa\"syate| ");
INSERT INTO sanvel_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","puraa herod nijabhraatu: philipo jaayaayaa herodiiyaayaa anurodhaad yohana.m dhaarayitvaa baddhaa kaaraayaa.m sthaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yato yohan uktavaan, etsayaa.h sa.mgraho bhavato nocita.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmaat n.rpatista.m hantumicchannapi lokebhyo vibhayaa ncakaara; yata.h sarvve yohana.m bhavi.syadvaadina.m menire| ");
INSERT INTO sanvel_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu herodo janmaahiiyamaha upasthite herodiiyaayaa duhitaa te.saa.m samak.sa.m n.rtitvaa herodamaprii.nyat| ");
INSERT INTO sanvel_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmaat bhuupati.h \"sapatha.m kurvvan iti pratyaj naasiit, tvayaa yad yaacyate, tadevaaha.m daasyaami| ");
INSERT INTO sanvel_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","saa kumaarii sviiyamaatu.h \"sik.saa.m labdhaa babhaa.se, majjayituryohana uttamaa\"nga.m bhaajane samaaniiya mahya.m vi\"sraa.naya| ");
INSERT INTO sanvel_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tato raajaa \"su\"soca, kintu bhojanaayopavi\"sataa.m sa\"nginaa.m svak.rta\"sapathasya caanurodhaat tat pradaatuma aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pa\"scaat kaaraa.m prati nara.m prahitya yohana uttamaa\"nga.m chittvaa ");
INSERT INTO sanvel_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhaajana aanaayya tasyai kumaaryyai vya\"sraa.nayat, tata.h saa svajananyaa.h samiipa.m tanninaaya| ");
INSERT INTO sanvel_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","pa\"scaat yohana.h \"si.syaa aagatya kaaya.m niitvaa \"sma\"saane sthaapayaamaasustato yii\"so.h sannidhi.m vrajitvaa tadvaarttaa.m babhaa.sire| ");
INSERT INTO sanvel_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantara.m yii\"suriti ni\"sabhya naavaa nirjanasthaanam ekaakii gatavaan, pa\"scaat maanavaastat \"srutvaa naanaanagarebhya aagatya padaistatpa\"scaad iiyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadaanii.m yii\"su rbahiraagatya mahaanta.m jananivaha.m niriik.sya te.su kaaru.nika.h man te.saa.m pii.ditajanaan niraamayaan cakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tata.h para.m sandhyaayaa.m \"si.syaastadantikamaagatya kathayaa ncakru.h, ida.m nirjanasthaana.m velaapyavasannaa; tasmaat manujaan svasvagraama.m gantu.m svaartha.m bhak.syaa.ni kretu nca bhavaan taan vis.rjatu| ");
INSERT INTO sanvel_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yii\"sustaanavaadiit, te.saa.m gamane prayojana.m naasti, yuuyameva taan bhojayata| ");
INSERT INTO sanvel_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadaa te pratyavadan, asmaakamatra puupapa ncaka.m miinadvaya ncaaste| ");
INSERT INTO sanvel_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadaanii.m tenokta.m taani madantikamaanayata| ");
INSERT INTO sanvel_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantara.m sa manujaan yavasoparyyupave.s.tum aaj naapayaamaasa; apara tat puupapa ncaka.m miinadvaya nca g.rhlan svarga.m prati niriik.sye\"svariiyagu.naan anuudya bha.mktvaa \"si.syebhyo dattavaan, \"si.syaa\"sca lokebhyo dadu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tata.h sarvve bhuktvaa parit.rptavanta.h, tatastadava\"si.s.tabhak.syai.h puur.naan dvaada\"sa.dalakaan g.rhiitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","te bhoktaara.h striirbaalakaa.m\"sca vihaaya praaye.na pa nca sahasraa.ni pumaa.msa aasan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantara.m yii\"su rlokaanaa.m visarjanakaale \"si.syaan tara.nimaaro.dhu.m svaagre paara.m yaatu nca gaa.dhamaadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tato loke.su vis.r.s.te.su sa vivikte praarthayitu.m girimeka.m gatvaa sandhyaa.m yaavat tatraikaakii sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadaanii.m sammukhavaatatvaat saritpate rmadhye tara\"ngaistara.nirdolaayamaanaabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadaa sa yaaminyaa\"scaturthaprahare padbhyaa.m vrajan te.saamantika.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu \"si.syaasta.m saagaropari vrajanta.m vilokya samudvignaa jagadu.h, e.sa bhuuta iti \"sa\"nkamaanaa uccai.h \"sabdaayaa ncakrire ca| ");
INSERT INTO sanvel_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yii\"sustaanavadat, susthiraa bhavata, maa bhai.s.ta, e.so.aham| ");
INSERT INTO sanvel_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tata.h pitara ityuktavaan, he prabho, yadi bhavaaneva, tarhi maa.m bhavatsamiipa.m yaatumaaj naapayatu| ");
INSERT INTO sanvel_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tata.h tenaadi.s.ta.h pitarastara.nito.avaruhya yii\"seाrantika.m praaptu.m toyopari vavraaja| ");
INSERT INTO sanvel_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu praca.n.da.m pavana.m vilokya bhayaat toye ma.mktum aarebhe, tasmaad uccai.h \"sabdaayamaana.h kathitavaan, he prabho, maamavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yii\"sustatk.sa.naat kara.m prasaaryya ta.m dharan uktavaan, ha stokapratyayin tva.m kuta.h sama\"sethaa.h? ");
INSERT INTO sanvel_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantara.m tayostara.nimaaruu.dhayo.h pavano nivav.rte| ");
INSERT INTO sanvel_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadaanii.m ye tara.nyaamaasan, ta aagatya ta.m pra.nabhya kathitavanta.h, yathaarthastvameve\"svarasuta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantara.m paara.m praapya te gine.sarannaamaka.m nagaramupatasthu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadaa tatratyaa janaa yii\"su.m pariciiya tadde\"ssya caturdi\"so vaarttaa.m prahitya yatra yaavanta.h pii.ditaa aasan, taavataeva tadantikamaanayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","apara.m tadiiyavasanasya granthimaatra.m spra.s.tu.m viniiya yaavanto janaastat spar\"sa.m cakrire, te sarvvaeva niraamayaa babhuuvu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","apara.m yiruu\"saalamnagariiyaa.h katipayaa adhyaapakaa.h phiruu\"sina\"sca yii\"so.h samiipamaagatya kathayaamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava \"si.syaa.h kimartham aprak.saalitakarai rbhak.sitvaa paramparaagata.m praaciinaanaa.m vyavahaara.m la\"nvante? ");
INSERT INTO sanvel_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tato yii\"su.h pratyuvaaca, yuuya.m paramparaagataacaare.na kuta ii\"svaraaj naa.m la\"nvadhve| ");
INSERT INTO sanvel_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ii\"svara ityaaj naapayat, tva.m nijapitarau sa.mmanyethaa.h, yena ca nijapitarau nindyete, sa ni\"scita.m mriyeta; ");
INSERT INTO sanvel_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yuuya.m vadatha, ya.h svajanaka.m svajananii.m vaa vaakyamida.m vadati, yuvaa.m matto yallabhethe, tat nyavidyata, ");
INSERT INTO sanvel_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna sa.mma.msyate| ittha.m yuuya.m paramparaagatena sve.saamaacaare.ne\"svariiyaaj naa.m lumpatha| ");
INSERT INTO sanvel_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","re kapa.tina.h sarvve yi\"sayiyo yu.smaanadhi bhavi.syadvacanaanyetaani samyag uktavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujaa ete samaayaanti madantika.m| tathaadharai rmadiiya nca maana.m kurvvanti te naraa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu te.saa.m mano matto viduuraeva ti.s.thati| \"sik.sayanto vidhiin nraaj naa bhajante maa.m mudhaiva te| ");
INSERT INTO sanvel_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tato yii\"su rlokaan aahuuya proktavaan, yuuya.m \"srutvaa budhyadhba.m| ");
INSERT INTO sanvel_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukha.m pravi\"sati, tat manujam amedhya.m na karoti, kintu yadaasyaat nirgacchati, tadeva maanu.samamedhyii karotii| ");
INSERT INTO sanvel_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadaanii.m \"si.syaa aagatya tasmai kathayaa ncakru.h, etaa.m kathaa.m \"srutvaa phiruu\"sino vyarajyanta, tat ki.m bhavataa j naayate? ");
INSERT INTO sanvel_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargastha.h pitaa ya.m ka ncida\"nkura.m naaropayat, sa utpaavdyate| ");
INSERT INTO sanvel_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","te ti.s.thantu, te andhamanujaanaam andhamaargadar\"sakaa eva; yadyandho.andha.m panthaana.m dar\"sayati, tarhyubhau gartte patata.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadaa pitarasta.m pratyavadat, d.r.s.taantamimamasmaan bodhayatu| ");
INSERT INTO sanvel_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yii\"sunaa prokta.m, yuuyamadya yaavat kimabodhaa.h stha? ");
INSERT INTO sanvel_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathaamimaa.m ki.m na budhyadhbe ? yadaasya.m previ\"sati, tad udare patan bahirniryaati, ");
INSERT INTO sanvel_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvaasyaad yanniryaati, tad anta.hkara.naat niryaatatvaat manujamamedhya.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yato.anta.hkara.naat kucintaa badha.h paaradaarikataa ve\"syaagamana.m cairyya.m mithyaasaak.syam ii\"svaranindaa caitaani sarvvaa.ni niryyaanti| ");
INSERT INTO sanvel_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","etaani manu.syamapavitrii kurvvanti kintvaprak.saalitakare.na bhojana.m manujamamedhya.m na karoti| ");
INSERT INTO sanvel_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantara.m yii\"sustasmaat sthaanaat prasthaaya sorasiidonnagarayo.h siimaamupatasyau| ");
INSERT INTO sanvel_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadaa tatsiimaata.h kaacit kinaaniiyaa yo.sid aagatya tamuccairuvaaca, he prabho daayuuda.h santaana, mamaikaa duhitaaste saa bhuutagrastaa satii mahaakle\"sa.m praapnoti mama dayasva| ");
INSERT INTO sanvel_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yii\"sustaa.m kimapi noktavaan, tata.h \"si.syaa aagatya ta.m nivedayaamaasu.h, e.saa yo.sid asmaaka.m pa\"scaad uccairaahuuyaagacchati, enaa.m vis.rjatu| ");
INSERT INTO sanvel_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadaa sa pratyavadat, israayelgotrasya haaritame.saan vinaa kasyaapyanyasya samiipa.m naaha.m pre.sitosmi| ");
INSERT INTO sanvel_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tata.h saa naariisamaagatya ta.m pra.namya jagaada, he prabho maamupakuru| ");
INSERT INTO sanvel_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavaan, baalakaanaa.m bhak.syamaadaaya saarameyebhyo daana.m nocita.m| ");
INSERT INTO sanvel_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadaa saa babhaa.se, he prabho, tat satya.m, tathaapi prabho rbha ncaad yaducchi.s.ta.m patati, tat saarameyaa.h khaadanti| ");
INSERT INTO sanvel_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tato yii\"su.h pratyavadat, he yo.sit, tava vi\"svaaso mahaan tasmaat tava manobhila.sita.m sidyyatu, tena tasyaa.h kanyaa tasminneva da.n.de niraamayaabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantara.m yii\"sastasmaat sthaanaat prasthaaya gaaliilsaagarasya sannidhimaagatya dharaadharamaaruhya tatropavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","pa\"scaat jananivaho bahuun kha ncaandhamuuka\"su.skakaramaanu.saan aadaaya yii\"so.h samiipamaagatya taccara.naantike sthaapayaamaasu.h, tata.h saa taan niraamayaan akarot| ");
INSERT INTO sanvel_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ittha.m muukaa vaakya.m vadanti, \"su.skakaraa.h svaasthyamaayaanti, pa\"ngavo gacchanti, andhaa viik.sante, iti vilokya lokaa vismaya.m manyamaanaa israayela ii\"svara.m dhanya.m babhaa.sire| ");
INSERT INTO sanvel_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadaanii.m yii\"su.h sva\"si.syaan aahuuya gaditavaan, etajjananivahe.su mama dayaa jaayate, ete dinatraya.m mayaa saaka.m santi, e.saa.m bhak.syavastu ca ka ncidapi naasti, tasmaadahametaanak.rtaahaaraan na visrak.syaami, tathaatve vartmamadhye klaamye.su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadaa \"si.syaa uucu.h, etasmin praantaramadhya etaavato martyaan tarpayitu.m vaya.m kutra puupaan praapsyaama.h? ");
INSERT INTO sanvel_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yii\"surap.rcchat, yu.smaaka.m nika.te kati puupaa aasate? ta uucu.h, saptapuupaa alpaa.h k.sudramiinaa\"sca santi| ");
INSERT INTO sanvel_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadaanii.m sa lokanivaha.m bhuumaavupave.s.tum aadi\"sya ");
INSERT INTO sanvel_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","taan saptapuupaan miinaa.m\"sca g.rhlan ii\"svariiyagu.naan anuudya bha.mktvaa \"si.syebhyo dadau, \"si.syaa lokebhyo dadu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tata.h sarvve bhuktvaa t.rptavanta.h; tadava\"si.s.tabhak.sye.na sapta.dalakaan paripuuryya sa.mjag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","te bhoktaaro yo.sito baalakaa.m\"sca vihaaya praaye.na catu.hsahasraa.ni puru.saa aasan| ");
INSERT INTO sanvel_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tata.h para.m sa jananivaha.m vis.rjya tarimaaruhya magdalaaprade\"sa.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadaanii.m phiruu\"sina.h siduukina\"scaagatya ta.m pariik.situ.m nabhamiiya.m ki ncana lak.sma dar\"sayitu.m tasmai nivedayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tata.h sa uktavaan, sandhyaayaa.m nabhaso raktatvaad yuuya.m vadatha, \"svo nirmmala.m dina.m bhavi.syati; ");
INSERT INTO sanvel_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","praata.hkaale ca nabhaso raktatvaat malinatvaa nca vadatha, jha nbh\"sadya bhavi.syati| he kapa.tino yadi yuuyam antariik.sasya lak.sma boddhu.m \"saknutha, tarhi kaalasyaitasya lak.sma katha.m boddhu.m na \"saknutha? ");
INSERT INTO sanvel_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","etatkaalasya du.s.to vyabhicaarii ca va.m\"so lak.sma gave.sayati, kintu yuunaso bhavi.syadvaadino lak.sma vinaanyat kimapi lak.sma taan na dar\"sayiyyate| tadaanii.m sa taan vihaaya pratasthe| ");
INSERT INTO sanvel_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapaaragamanakaale tasya \"si.syaa.h puupamaanetu.m vism.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yii\"sustaanavaadiit, yuuya.m phiruu\"sinaa.m siduukinaa nca ki.nva.m prati saavadhaanaa.h satarkaa\"sca bhavata| ");
INSERT INTO sanvel_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tena te paraspara.m vivicya kathayitumaarebhire, vaya.m puupaanaanetu.m vism.rtavanta etatkaara.naad iti kathayati| ");
INSERT INTO sanvel_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yii\"sustadvij naaya taanavocat, he stokavi\"svaasino yuuya.m puupaanaanayanamadhi kuta.h parasparametad vivi.mkya? ");
INSERT INTO sanvel_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yu.smaabhi.h kimadyaapi na j naayate? pa ncabhi.h puupai.h pa ncasahasrapuru.se.su bhojite.su bhak.syocchi.s.tapuur.naan kati .dalakaan samag.rhliita.m; ");
INSERT INTO sanvel_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathaa saptabhi.h puupai\"scatu.hsahasrapuru.se.su bhejite.su kati .dalakaan samag.rhliita, tat ki.m yu.smaabhirna smaryyate? ");
INSERT INTO sanvel_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmaat phiruu\"sinaa.m siduukinaa nca ki.nva.m prati saavadhaanaasti.s.thata, kathaamimaam aha.m puupaanadhi naakathaya.m, etad yuuya.m kuto na budhyadhve? ");
INSERT INTO sanvel_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadaanii.m puupaki.nva.m prati saavadhaanaasti.s.thateti noktvaa phiruu\"sinaa.m siduukinaa nca upade\"sa.m prati saavadhaanaasti.s.thateti kathitavaan, iti tairabodhi| ");
INSERT INTO sanvel_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","apara nca yii\"su.h kaisariyaa-philipiprade\"samaagatya \"si.syaan ap.rcchat, yo.aha.m manujasuta.h so.aha.m ka.h? lokairaha.m kimucye? ");
INSERT INTO sanvel_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadaanii.m te kathitavanta.h, kecid vadanti tva.m majjayitaa yohan, kecidvadanti, tvam eliya.h, kecicca vadanti, tva.m yirimiyo vaa ka\"scid bhavi.syadvaadiiti| ");
INSERT INTO sanvel_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","pa\"scaat sa taan papraccha, yuuya.m maa.m ka.m vadatha? tata.h \"simon pitara uvaaca, ");
INSERT INTO sanvel_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamare\"svarasyaabhi.siktaputra.h| ");
INSERT INTO sanvel_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tato yii\"su.h kathitavaan, he yuunasa.h putra \"simon tva.m dhanya.h; yata.h kopi anujastvayyetajj naana.m nodapaadayat, kintu mama svargasya.h pitodapaadayat| ");
INSERT INTO sanvel_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ato.aha.m tvaa.m vadaami, tva.m pitara.h (prastara.h) aha nca tasya prastarasyopari svama.n.dalii.m nirmmaasyaami, tena nirayo balaat taa.m paraajetu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","aha.m tubhya.m svargiiyaraajyasya ku njikaa.m daasyaami, tena yat ki ncana tva.m p.rthivyaa.m bha.mtsyasi tatsvarge bha.mtsyate, yacca ki ncana mahyaa.m mok.syasi tat svarge mok.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","pa\"scaat sa \"si.syaanaadi\"sat, ahamabhi.sikto yii\"suriti kathaa.m kasmaicidapi yuuya.m maa kathayata| ");
INSERT INTO sanvel_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anya nca yiruu\"saalamnagara.m gatvaa praaciinalokebhya.h pradhaanayaajakebhya upaadhyaayebhya\"sca bahudu.hkhabhogastai rhatatva.m t.rtiiyadine punarutthaana nca mamaava\"syakam etaa.h kathaa yii\"sustatkaalamaarabhya \"si.syaan j naapayitum aarabdhavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadaanii.m pitarastasya kara.m gh.rtvaa tarjayitvaa kathayitumaarabdhavaan, he prabho, tat tvatto duura.m yaatu, tvaa.m prati kadaapi na gha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadana.m paraavartya pitara.m jagaada, he vighnakaarin, matsammukhaad duuriibhava, tva.m maa.m baadhase, ii\"svariiyakaaryyaat maanu.siiyakaaryya.m tubhya.m rocate| ");
INSERT INTO sanvel_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantara.m yii\"su.h sviiya\"si.syaan uktavaan ya.h ka\"scit mama pa\"scaadgaamii bhavitum icchati, sa sva.m daamyatu, tathaa svakru\"sa.m g.rhlan matpa\"scaadaayaatu| ");
INSERT INTO sanvel_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yato ya.h praa.naan rak.situmicchati, sa taan haarayi.syati, kintu yo madartha.m nijapraa.naan haarayati, sa taan praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","maanu.so yadi sarvva.m jagat labhate nijapra.naan haarayati, tarhi tasya ko laabha.h? manujo nijapraa.naanaa.m vinimayena vaa ki.m daatu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasuta.h svaduutai.h saaka.m pitu.h prabhaave.naagami.syati; tadaa pratimanuja.m svasvakarmmaanusaaraat phala.m daasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","aha.m yu.smaan tathya.m vacmi, saraajya.m manujasutam aagata.m na pa\"syanto m.rtyu.m na svaadi.syanti, etaad.r\"saa.h katipayajanaa atraapi da.n.daayamaanaa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantara.m .sa.ddinebhya.h para.m yii\"su.h pitara.m yaakuuba.m tatsahaja.m yohana nca g.rhlan uccaadre rviviktasthaanam aagatya te.saa.m samak.sa.m ruupamanyat dadhaara| ");
INSERT INTO sanvel_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tena tadaasya.m tejasvi, tadaabhara.nam aalokavat paa.n.daramabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyacca tena saaka.m sa.mlapantau muusaa eliya\"sca tebhyo dar\"sana.m dadatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadaanii.m pitaro yii\"su.m jagaada, he prabho sthitiratraasmaaka.m \"subhaa, yadi bhavataanumanyate, tarhi bhavadarthameka.m muusaarthamekam eliyaartha ncaikam iti trii.ni duu.syaa.ni nirmmama| ");
INSERT INTO sanvel_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","etatkathanakaala eka ujjavala.h payodaste.saamupari chaayaa.m k.rtavaan, vaaridaad e.saa nabhasiiyaa vaag babhuuva, mamaaya.m priya.h putra.h, asmin mama mahaasanto.sa etasya vaakya.m yuuya.m ni\"saamayata| ");
INSERT INTO sanvel_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vaacametaa.m \"s.r.nvantaeva \"si.syaa m.r\"sa.m \"sa\"nkamaanaa nyubjaa nyapatan| ");
INSERT INTO sanvel_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadaa yii\"suraagatya te.saa.m gaatraa.ni sp.r\"san uvaaca, utti.s.thata, maa bhai.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadaanii.m netraa.nyunmiilya yii\"su.m vinaa kamapi na dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tata.h param adreravaroha.nakaale yii\"sustaan ityaadide\"sa, manujasutasya m.rtaanaa.m madhyaadutthaana.m yaavanna jaayate, taavat yu.smaabhiretaddar\"sana.m kasmaicidapi na kathayitavya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadaa \"si.syaasta.m papracchu.h, prathamam eliya aayaasyatiiti kuta upaadhyaayairucyate? ");
INSERT INTO sanvel_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tato yii\"su.h pratyavaadiit, eliya.h praagetya sarvvaa.ni saadhayi.syatiiti satya.m, ");
INSERT INTO sanvel_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvaha.m yu.smaan vacmi, eliya etya gata.h, te tamaparicitya tasmin yatheccha.m vyavajahu.h; manujasutenaapi te.saamantike taad.rg du.hkha.m bhoktavya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadaanii.m sa majjayitaara.m yohanamadhi kathaametaa.m vyaah.rtavaan, ittha.m tacchi.syaa bubudhire| ");
INSERT INTO sanvel_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","pa\"scaat te.su jananivahasyaantikamaagate.su ka\"scit manujastadantikametya jaanuunii paatayitvaa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","he prabho, matputra.m prati k.rpaa.m vidadhaatu, sopasmaaraamayena bh.r\"sa.m vyathita.h san puna.h puna rvahnau muhu rjalamadhye patati| ");
INSERT INTO sanvel_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmaad bhavata.h \"si.syaa.naa.m samiipe tamaanaya.m kintu te ta.m svaastha.m karttu.m na \"saktaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadaa yii\"su.h kathitavaan re avi\"svaasina.h, re vipathagaamina.h, puna.h katikaalaan aha.m yu.smaaka.m sannidhau sthaasyaami? katikaalaan vaa yu.smaan sahi.sye? tamatra mamaantikamaanayata| ");
INSERT INTO sanvel_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","pa\"scaad yii\"sunaa tarjataeva sa bhuutasta.m vihaaya gatavaan, tadda.n.daeva sa baalako niraamayo.abhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tata.h \"si.syaa gupta.m yii\"sumupaagatya babhaa.sire, kuto vaya.m ta.m bhuuta.m tyaajayitu.m na \"saktaa.h? ");
INSERT INTO sanvel_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yii\"sunaa te proktaa.h, yu.smaakamapratyayaat; ");
INSERT INTO sanvel_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yu.smaanaha.m tathya.m vacmi yadi yu.smaaka.m sar.sapaikamaatropi vi\"svaaso jaayate, tarhi yu.smaabhirasmin \"saile tvamita.h sthaanaat tat sthaana.m yaahiiti bruute sa tadaiva cali.syati, yu.smaaka.m kimapyasaadhya nca karmma na sthaasyaati| kintu praarthanopavaasau vinaitaad.r\"so bhuuto na tyaajyeta| ");
INSERT INTO sanvel_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","apara.m te.saa.m gaaliilprade\"se bhrama.nakaale yii\"sunaa te gaditaa.h, manujasuto janaanaa.m kare.su samarpayi.syate tai rhani.syate ca, ");
INSERT INTO sanvel_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu t.rtiiye.ahi्na ma utthaapi.syate, tena te bh.r\"sa.m du.hkhitaa babhuuva.h| ");
INSERT INTO sanvel_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantara.m te.su kapharnaahuumnagaramaagate.su karasa.mgraahi.na.h pitaraantikamaagatya papracchu.h, yu.smaaka.m guru.h ki.m mandiraartha.m kara.m na dadaati? tata.h pitara.h kathitavaan dadaati| ");
INSERT INTO sanvel_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin g.rhamadhyamaagate tasya kathaakathanaat puurvvameva yii\"suruvaaca, he \"simon, medinyaa raajaana.h svasvaapatyebhya.h ki.m vide\"sibhya.h kebhya.h kara.m g.rhlanti? atra tva.m ki.m budhyase? tata.h pitara uktavaan, vide\"sibhya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadaa yii\"suruktavaan, tarhi santaanaa muktaa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathaapi yathaasmaabhiste.saamantaraayo na janyate, tatk.rte jaladhestiira.m gatvaa va.di\"sa.m k.sipa, tenaadau yo miina utthaasyati, ta.m gh.rtvaa tanmukhe mocite tolakaika.m ruupya.m praapsyasi, tad g.rhiitvaa tava mama ca k.rte tebhyo dehi| ");
INSERT INTO sanvel_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadaanii.m \"si.syaa yii\"so.h samiipamaagatya p.r.s.tavanta.h svargaraajye ka.h \"sre.s.tha.h? ");
INSERT INTO sanvel_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tato yii\"su.h k.sudrameka.m baalaka.m svasamiipamaaniiya te.saa.m madhye nidhaaya jagaada, ");
INSERT INTO sanvel_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yu.smaanaha.m satya.m braviimi, yuuya.m manovinimayena k.sudrabaalavat na santa.h svargaraajya.m prave.s.tu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ya.h ka\"scid etasya k.sudrabaalakasya samamaatmaana.m namriikaroti, saeva svargaraajaye \"sre.s.tha.h| ");
INSERT INTO sanvel_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ya.h ka\"scid etaad.r\"sa.m k.sudrabaalakameka.m mama naamni g.rhlaati, sa maameva g.rhlaati| ");
INSERT INTO sanvel_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yo jano mayi k.rtavi\"svaasaanaamete.saa.m k.sudrapraa.ninaam ekasyaapi vidhni.m janayati, ka.n.thabaddhape.sa.niikasya tasya saagaraagaadhajale majjana.m \"sreya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnaat jagata.h santaapo bhavi.syati, vighno.ava\"sya.m janayi.syate, kintu yena manujena vighno jani.syate tasyaiva santaapo bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmaat tava kara\"scara.no vaa yadi tvaa.m baadhate, tarhi ta.m chittvaa nik.sipa, dvikarasya dvipadasya vaa tavaanaptavahnau nik.sepaat, kha njasya vaa chinnahastasya tava jiivane prave\"so vara.m| ");
INSERT INTO sanvel_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","apara.m tava netra.m yadi tvaa.m baadhate, tarhi tadapyutpaavya nik.sipa, dvinetrasya narakaagnau nik.sepaat kaa.nasya tava jiivane prave\"so vara.m| ");
INSERT INTO sanvel_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmaadavadhaddha.m, ete.saa.m k.sudrapraa.ninaam ekamapi maa tucchiikuruta, ");
INSERT INTO sanvel_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yato yu.smaanaha.m tathya.m braviimi, svarge te.saa.m duutaa mama svargasthasya pituraasya.m nitya.m pa\"syanti| eva.m ye ye haaritaastaan rak.situ.m manujaputra aagacchat| ");
INSERT INTO sanvel_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yuuyamatra ki.m vivi.mgghve? kasyacid yadi \"sata.m me.saa.h santi, te.saameko haaryyate ca, tarhi sa ekona\"sata.m me.saan vihaaya parvvata.m gatvaa ta.m haaritameka.m ki.m na m.rgayate? ");
INSERT INTO sanvel_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi ca kadaacit tanme.sodde\"sa.m lamate, tarhi yu.smaanaha.m satya.m kathayaami, so.avipathagaamibhya ekona\"satame.sebhyopi tadekahetoradhikam aahlaadate| ");
INSERT INTO sanvel_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad ete.saa.m k.sudrapraaeिnaam ekopi na\"syatiiti yu.smaaka.m svargasthapitu rnaabhimatam| ");
INSERT INTO sanvel_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhraataa tvayi kimapyaparaadhyati, tarhi gatvaa yuvayordvayo.h sthitayostasyaaparaadha.m ta.m j naapaya| tatra sa yadi tava vaakya.m \"s.r.noti, tarhi tva.m svabhraatara.m praaptavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na \"s.r.noti, tarhi dvaabhyaa.m tribhi rvaa saak.siibhi.h sarvva.m vaakya.m yathaa ni\"scita.m jaayate, tadartham eka.m dvau vaa saak.si.nau g.rhiitvaa yaahi| ");
INSERT INTO sanvel_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tena sa yadi tayo rvaakya.m na maanyate, tarhi samaaja.m tajj naapaya, kintu yadi samaajasyaapi vaakya.m na maanyate,tarhi sa tava samiipe devapuujaka_iva ca.n.daala_iva ca bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","aha.m yu.smaan satya.m vadaami, yu.smaabhi.h p.rthivyaa.m yad badhyate tat svarge bha.mtsyate; medinyaa.m yat bhocyate, svarge.api tat mok.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punaraha.m yu.smaan vadaami, medinyaa.m yu.smaaka.m yadi dvaavekavaakyiibhuuya ki ncit praarthayete, tarhi mama svargasthapitraa tat tayo.h k.rte sampanna.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yato yatra dvau trayo vaa mama naanni milanti, tatraivaaha.m te.saa.m madhye.asmi| ");
INSERT INTO sanvel_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadaanii.m pitarastatsamiipamaagatya kathitavaan he prabho, mama bhraataa mama yadyaparaadhyati, tarhi ta.m katik.rtva.h k.sami.sye? ");
INSERT INTO sanvel_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ki.m saptak.rtva.h? yii\"susta.m jagaada, tvaa.m kevala.m saptak.rtvo yaavat na vadaami, kintu saptatyaa gu.nita.m saptak.rtvo yaavat| ");
INSERT INTO sanvel_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","apara.m nijadaasai.h saha jiga.nayi.su.h ka\"scid raajeva svargaraajaya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","aarabdhe tasmin ga.nane saarddhasahasramudraapuuritaanaa.m da\"sasahasrapu.takaanaam eko.aghamar.nastatsamak.samaanaayi| ");
INSERT INTO sanvel_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya pari\"sodhanaaya dravyaabhaavaat pari\"sodhanaartha.m sa tadiiyabhaaryyaaputraadisarvvasva nca vikriiyataamiti tatprabhuraadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tena sa daasastasya paadayo.h patan pra.namya kathitavaan , he prabho bhavataa ghairyye k.rte mayaa sarvva.m pari\"sodhi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadaanii.m daasasya prabhu.h sakaru.na.h san sakalar.na.m k.samitvaa ta.m tatyaaja| ");
INSERT INTO sanvel_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin daase bahi ryaate, tasya \"sata.m mudraacaturthaa.m\"saan yo dhaarayati, ta.m sahadaasa.m d.r.sdvaa tasya ka.n.tha.m ni.spii.dya gaditavaan, mama yat praapya.m tat pari\"sodhaya| ");
INSERT INTO sanvel_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadaa tasya sahadaasastatpaadayo.h patitvaa viniiya babhaa.se, tvayaa dhairyye k.rte mayaa sarvva.m pari\"sodhi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathaapi sa tat naa\"nagiik.rtya yaavat sarvvam.r.na.m na pari\"sodhitavaan taavat ta.m kaaraayaa.m sthaapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadaa tasya sahadaasaastasyaitaad.rg aacara.na.m vilokya prabho.h samiipa.m gatvaa sarvva.m v.rttaanta.m nivedayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadaa tasya prabhustamaahuuya jagaada, re du.s.ta daasa, tvayaa matsannidhau praarthite mayaa tava sarvvam.r.na.m tyakta.m; ");
INSERT INTO sanvel_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathaa caaha.m tvayi karu.naa.m k.rtavaan, tathaiva tvatsahadaase karu.naakara.na.m ki.m tava nocita.m? ");
INSERT INTO sanvel_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvaa tasya prabhu.h kruddhyan nijapraapya.m yaavat sa na pari\"sodhitavaan, taavat prahaarakaanaa.m kare.su ta.m samarpitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yuuya.m svaanta.hkara.nai.h svasvasahajaanaam aparaadhaan na k.samadhve, tarhi mama svargasya.h pitaapi yu.smaan pratiittha.m kari.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram etaasu kathaasu samaaptaasu yii\"su rgaaliilaprade\"saat prasthaaya yardantiirastha.m yihuudaaprade\"sa.m praapta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadaa tatpa\"scaat jananivahe gate sa tatra taan niraamayaan akarot| ");
INSERT INTO sanvel_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantara.m phiruu\"sinastatsamiipamaagatya paariik.situ.m ta.m papracchu.h, kasmaadapi kaara.naat nare.na svajaayaa parityaajyaa na vaa? ");
INSERT INTO sanvel_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvaaca, prathamam ii\"svaro naratvena naariitvena ca manujaan sasarja, tasmaat kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","maanu.sa.h svapitarau parityajya svapatnyaam aasak.syate, tau dvau janaavekaa\"ngau bhavi.syata.h, kimetad yu.smaabhi rna pa.thitam? ");
INSERT INTO sanvel_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayorekaa\"ngatva.m jaata.m, ii\"svare.na yacca samayujyata, manujo na tad bhindyaat| ");
INSERT INTO sanvel_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadaanii.m te ta.m pratyavadan, tathaatve tyaajyapatra.m dattvaa svaa.m svaa.m jaayaa.m tyaktu.m vyavasthaa.m muusaa.h katha.m lilekha? ");
INSERT INTO sanvel_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tata.h sa kathitavaan, yu.smaaka.m manasaa.m kaa.thinyaad yu.smaan svaa.m svaa.m jaayaa.m tyaktum anvamanyata kintu prathamaad e.so vidhirnaasiit| ");
INSERT INTO sanvel_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ato yu.smaanaha.m vadaami, vyabhicaara.m vinaa yo nijajaayaa.m tyajet anyaa nca vivahet, sa paradaaraan gacchati; ya\"sca tyaktaa.m naarii.m vivahati sopi paradaare.su ramate| ");
INSERT INTO sanvel_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadaa tasya \"si.syaasta.m babhaa.sire, yadi svajaayayaa saaka.m pu.msa etaad.rk sambandho jaayate, tarhi vivahanameva na bhadra.m| ");
INSERT INTO sanvel_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tata.h sa uktavaan, yebhyastatsaamarthya.m aadaayi, taan vinaanya.h kopi manuja etanmata.m grahiitu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayaa jananakliiba.h katipayaa narak.rtakliiba.h svargaraajyaaya katipayaa.h svak.rtakliibaa\"sca santi, ye grahiitu.m \"saknuvanti te g.rhlantu| ");
INSERT INTO sanvel_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathaa sa \"si\"suunaa.m gaatre.su hasta.m datvaa praarthayate, tadartha.m tatsamii.mpa.m \"si\"sava aaniiyanta, tata aanayit.rn \"si.syaastirask.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yii\"suruvaaca, \"si\"savo madantikam aagacchantu, taan maa vaarayata, etaad.r\"saa.m \"si\"suunaameva svargaraajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tata.h sa te.saa.m gaatre.su hasta.m datvaa tasmaat sthaanaat pratasthe| ");
INSERT INTO sanvel_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam eka aagatya ta.m papraccha, he paramaguro, anantaayu.h praaptu.m mayaa ki.m ki.m satkarmma karttavya.m? ");
INSERT INTO sanvel_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tata.h sa uvaaca, maa.m parama.m kuto vadasi? vine\"scara.m na kopi parama.h, kintu yadyanantaayu.h praaptu.m vaa nchasi, tarhyaaj naa.h paalaya| ");
INSERT INTO sanvel_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadaa sa p.r.s.tavaan, kaa.h kaa aaj naa.h? tato yii\"su.h kathitavaan, nara.m maa hanyaa.h, paradaaraan maa gacche.h, maa coraye.h, m.r.saasaak.sya.m maa dadyaa.h, ");
INSERT INTO sanvel_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau sa.mmanyasva, svasamiipavaasini svavat prema kuru| ");
INSERT INTO sanvel_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvaa kathitavaan, aa baalyaad etaa.h paalayaami, idaanii.m ki.m nyuunamaaste? ");
INSERT INTO sanvel_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tato yii\"suravadat, yadi siddho bhavitu.m vaa nchasi, tarhi gatvaa nijasarvvasva.m vikriiya daridrebhyo vitara, tata.h svarge vitta.m lapsyase; aagaccha, matpa\"scaadvarttii ca bhava| ");
INSERT INTO sanvel_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","etaa.m vaaca.m \"srutvaa sa yuvaa sviiyabahusampatte rvi.sa.na.h san calitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadaa yii\"su.h sva\"si.syaan avadat, dhaninaa.m svargaraajyaprave\"so mahaadu.skara iti yu.smaanaha.m tathya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yu.smaanaha.m vadaami, dhaninaa.m svargaraajyaprave\"saat suuciichidre.na mahaa\"ngagamana.m sukara.m| ");
INSERT INTO sanvel_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vaakya.m ni\"samya \"si.syaa aticamatk.rtya kathayaamaasu.h; tarhi kasya paritraa.na.m bhavitu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadaa sa taan d.r.sdvaa kathayaamaasa, tat maanu.saa.naama\"sakya.m bhavati, kintvii\"svarasya sarvva.m \"sakyam| ");
INSERT INTO sanvel_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadaa pitarasta.m gaditavaan, pa\"sya, vaya.m sarvva.m parityajya bhavata.h pa\"scaadvarttino .abhavaama; vaya.m ki.m praapsyaama.h? ");
INSERT INTO sanvel_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tato yii\"su.h kathitavaan, yu.smaanaha.m tathya.m vadaami, yuuya.m mama pa\"scaadvarttino jaataa iti kaara.naat naviinas.r.s.tikaale yadaa manujasuta.h sviiyai\"scaryyasi.mhaasana upavek.syati, tadaa yuuyamapi dvaada\"sasi.mhaasane.suupavi\"sya israayeliiyadvaada\"sava.m\"saanaa.m vicaara.m kari.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyacca ya.h ka\"scit mama naamakaara.naat g.rha.m vaa bhraatara.m vaa bhaginii.m vaa pitara.m vaa maatara.m vaa jaayaa.m vaa baalaka.m vaa bhuumi.m parityajati, sa te.saa.m \"satagu.na.m lapsyate, anantaayumo.adhikaaritva nca praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agriiyaa aneke janaa.h pa\"scaat, pa\"scaatiiyaa\"scaaneke lokaa agre bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargaraajyam etaad.r\"saa kenacid g.rhasyena sama.m, yo.atiprabhaate nijadraak.saak.setre k.r.sakaan niyoktu.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","pa\"scaat tai.h saaka.m dinaikabh.rti.m mudraacaturthaa.m\"sa.m niruupya taan draak.saak.setra.m prerayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantara.m praharaikavelaayaa.m gatvaa ha.t.te katipayaan ni.skarmmakaan vilokya taanavadat, ");
INSERT INTO sanvel_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yuuyamapi mama draak.saak.setra.m yaata, yu.smabhyamaha.m yogyabh.rti.m daasyaami, tataste vavraju.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","puna\"sca sa dvitiiyat.rtiiyayo.h praharayo rbahi rgatvaa tathaiva k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tato da.n.dadvayaava\"si.s.taayaa.m velaayaa.m bahi rgatvaaparaan katipayajanaan ni.skarmmakaan vilokya p.r.s.tavaan, yuuya.m kimartham atra sarvva.m dina.m ni.skarmmaa.nasti.s.thatha? ");
INSERT INTO sanvel_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","te pratyavadan, asmaan na kopi karmama.ni niyu.mkte| tadaanii.m sa kathitavaan, yuuyamapi mama draak.saak.setra.m yaata, tena yogyaa.m bh.rti.m lapsyatha| ");
INSERT INTO sanvel_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantara.m sandhyaayaa.m satyaa.m saeva draak.saak.setrapatiradhyak.sa.m gadivaan, k.r.sakaan aahuuya \"se.sajanamaarabhya prathama.m yaavat tebhyo bh.rti.m dehi| ");
INSERT INTO sanvel_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tena ye da.n.dadvayaavasthite samaayaataaste.saam ekaiko jano mudraacaturthaa.m\"sa.m praapnot| ");
INSERT INTO sanvel_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadaanii.m prathamaniyuktaa janaa aagatyaanumitavanto vayamadhika.m prapsyaama.h, kintu tairapi mudraacaturthaa.m\"so.alaabhi| ");
INSERT INTO sanvel_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tataste ta.m g.rhiitvaa tena k.setrapatinaa saaka.m vaagyuddha.m kurvvanta.h kathayaamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vaya.m k.rtsna.m dina.m taapakle\"sau so.dhavanta.h, kintu pa\"scaataayaa se janaa da.n.dadvayamaatra.m pari\"sraantavantaste.asmaabhi.h samaanaa.m\"saa.h k.rtaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tata.h sa te.saameka.m pratyuvaaca, he vatsa, mayaa tvaa.m prati kopyanyaayo na k.rta.h ki.m tvayaa matsamak.sa.m mudraacaturthaa.m\"so naa\"ngiik.rta.h? ");
INSERT INTO sanvel_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmaat tava yat praapya.m tadaadaaya yaahi, tubhya.m yati, pa\"scaatiiyaniyuktalokaayaapi tati daatumicchaami| ");
INSERT INTO sanvel_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svecchayaa nijadravyavyavahara.na.m ki.m mayaa na karttavya.m? mama daat.rtvaat tvayaa kim iir.syaad.r.s.ti.h kriyate? ");
INSERT INTO sanvel_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agriiyalokaa.h pa\"scatiiyaa bhavi.syanti, pa\"scaatiiyajanaa\"scagriiyaa bhavi.syanti, ahuutaa bahava.h kintvalpe manobhila.sitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantara.m yii\"su ryiruu\"saalamnagara.m gacchan maargamadhye \"si.syaan ekaante vabhaa.se, ");
INSERT INTO sanvel_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","pa\"sya vaya.m yiruu\"saalamnagara.m yaama.h, tatra pradhaanayaajakaadhyaapakaanaa.m kare.su manu.syaputra.h samarpi.syate; ");
INSERT INTO sanvel_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","te ca ta.m hantumaaj naapya tirask.rtya vetre.na praharttu.m kru\"se dhaatayitu ncaanyade\"siiyaanaa.m kare.su samarpayi.syanti, kintu sa t.rtiiyadivase \"sma\"saanaad utthaapi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadaanii.m sivadiiyasya naarii svaputraavaadaaya yii\"so.h samiipam etya pra.namya ka ncanaanugraha.m ta.m yayaace| ");
INSERT INTO sanvel_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadaa yii\"sustaa.m proktavaan, tva.m ki.m yaacase? tata.h saa babhaa.se, bhavato raajatve mamaanayo.h sutayoreka.m bhavaddak.si.napaar\"sve dvitiiya.m vaamapaar\"sva upave.s.tum aaj naapayatu| ");
INSERT INTO sanvel_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yii\"su.h pratyuvaaca, yuvaabhyaa.m yad yaacyate, tanna budhyate, aha.m yena ka.msena paasyaami yuvaabhyaa.m ki.m tena paatu.m \"sakyate? aha nca yena majjenena majji.sye, yuvaabhyaa.m ki.m tena majjayitu.m \"sakyate? te jagadu.h \"sakyate| ");
INSERT INTO sanvel_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadaa sa uktavaan, yuvaa.m mama ka.msenaava\"sya.m paasyatha.h, mama majjanena ca yuvaamapi majji.syethe, kintu ye.saa.m k.rte mattaatena niruupitam ida.m taan vihaayaanya.m kamapi maddak.si.napaar\"sve vaamapaar\"sve ca samupave\"sayitu.m mamaadhikaaro naasti| ");
INSERT INTO sanvel_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","etaa.m kathaa.m \"srutvaanye da\"sa\"si.syaastau bhraatarau prati cukupu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yii\"su.h svasamiipa.m taanaahuuya jagaada, anyade\"siiyalokaanaa.m narapatayastaan adhikurvvanti, ye tu mahaantaste taan \"saasati, iti yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yu.smaaka.m madhye na tathaa bhavet, yu.smaaka.m ya.h ka\"scit mahaan bubhuu.sati, sa yu.smaan seveta; ");
INSERT INTO sanvel_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ya\"sca yu.smaaka.m madhye mukhyo bubhuu.sati, sa yu.smaaka.m daaso bhavet| ");
INSERT INTO sanvel_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ittha.m manujaputra.h sevyo bhavitu.m nahi, kintu sevitu.m bahuunaa.m paritraa.namuulyaartha.m svapraa.naan daatu ncaagata.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantara.m yiriihonagaraat te.saa.m bahirgamanasamaye tasya pa\"scaad bahavo lokaa vavraju.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","apara.m vartmapaar\"sva upavi\"santau dvaavandhau tena maarge.na yii\"so rgamana.m ni\"samya proccai.h kathayaamaasatu.h, he prabho daayuuda.h santaana, aavayo rdayaa.m vidhehi| ");
INSERT INTO sanvel_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tato lokaa.h sarvve tu.s.niimbhavatamityuktvaa tau tarjayaamaasu.h; tathaapi tau punaruccai.h kathayaamaasatu.h he prabho daayuuda.h santaana, aavaa.m dayasva| ");
INSERT INTO sanvel_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadaanii.m yii\"su.h sthagita.h san taavaahuuya bhaa.sitavaan, yuvayo.h k.rte mayaa ki.m karttarvya.m? yuvaa.m ki.m kaamayethe? ");
INSERT INTO sanvel_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadaa taavuktavantau, prabho netraa.ni nau prasannaani bhaveyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadaanii.m yii\"sustau prati pramanna.h san tayo rnetraa.ni paspar\"sa, tenaiva tau suviik.saa ncakraate tatpa\"scaat jagmutu\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantara.m te.su yiruu\"saalamnagarasya samiipaverttino jaitunanaamakadharaadharasya samiipasthti.m baitphagigraamam aagate.su, yii\"su.h \"si.syadvaya.m pre.sayan jagaada, ");
INSERT INTO sanvel_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvaa.m sammukhasthagraama.m gatvaa baddhaa.m yaa.m savatsaa.m garddabhii.m ha.thaat praapsyatha.h, taa.m mocayitvaa madantikam aanayata.m| ");
INSERT INTO sanvel_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi ka\"scit ki ncid vak.syati, tarhi vadi.syatha.h, etasyaa.m prabho.h prayojanamaaste, tena sa tatk.sa.naat prahe.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","siiyona.h kanyakaa.m yuuya.m bhaa.sadhvamiti bhaaratii.m| pa\"sya te namra\"siila.h san n.rpa aaruhya gardabhii.m| arthaadaaruhya tadvatsamaayaasyati tvadantika.m| ");
INSERT INTO sanvel_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhavi.syadvaadinokta.m vacanamida.m tadaa saphalamabhuut| ");
INSERT INTO sanvel_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantara.m tau \"s.syiौ yii\"so ryathaanide\"sa.m ta.m graama.m gatvaa ");
INSERT INTO sanvel_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhii.m tadvatsa nca samaaniitavantau, pa\"scaat tadupari sviiyavasanaanii paatayitvaa tamaarohayaamaasatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tato bahavo lokaa nijavasanaani pathi prasaarayitumaarebhire, katipayaa janaa\"sca paadapapar.naadika.m chitvaa pathi vistaarayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragaamina.h pa\"scaadgaamina\"sca manujaa uccairjaya jaya daayuuda.h santaaneti jagadu.h parame\"svarasya naamnaa ya aayaati sa dhanya.h, sarvvoparisthasvargepi jayati| ");
INSERT INTO sanvel_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ittha.m tasmin yiruu\"saalama.m pravi.s.te ko.ayamiti kathanaat k.rtsna.m nagara.m ca ncalamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra loko.h kathayaamaasu.h, e.sa gaaliilprade\"siiya-naasaratiiya-bhavi.syadvaadii yii\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantara.m yii\"surii\"svarasya mandira.m pravi\"sya tanmadhyaat krayavikrayi.no vahi\"scakaara; va.nijaa.m mudraasanaanii kapotavikrayi.naa ncasanaanii ca nyuvjayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","apara.m taanuvaaca, e.saa lipiraaste, \"mama g.rha.m praarthanaag.rhamiti vikhyaasyati\", kintu yuuya.m tad dasyuunaa.m gahvara.m k.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakha ncalokaastasya samiipamaagataa.h, sa taan niraamayaan k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadaa pradhaanayaajakaa adhyaapakaa\"sca tena k.rtaanyetaani citrakarmmaa.ni dad.r\"su.h, jaya jaya daayuuda.h santaana, mandire baalakaanaam etaad.r\"sam uccadhvani.m \"su\"sruvu\"sca, tadaa mahaakruddhaa babhuuva.h, ");
INSERT INTO sanvel_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ta.m papracchu\"sca, ime yad vadanti, tat ki.m tva.m \"s.r.no.si? tato yii\"sustaan avocat, satyam; stanyapaayi\"si\"suunaa nca baalakaanaa nca vaktrata.h| svakiiya.m mahimaana.m tva.m sa.mprakaa\"sayasi svaya.m| etadvaakya.m yuuya.m ki.m naapa.thata? ");
INSERT INTO sanvel_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastaan vihaaya sa nagaraad baithaniyaagraama.m gatvaa tatra rajanii.m yaapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantara.m prabhaate sati yii\"su.h punarapi nagaramaagacchan k.sudhaartto babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tato maargapaar\"sva u.dumbarav.rk.sameka.m vilokya tatsamiipa.m gatvaa patraa.ni vinaa kimapi na praapya ta.m paadapa.m provaaca, adyaarabhya kadaapi tvayi phala.m na bhavatu; tena tatk.sa.naat sa u.dumbaramaahiiruha.h \"su.skataa.m gata.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad d.r.s.tvaa \"si.syaa aa\"scaryya.m vij naaya kathayaamaasu.h, aa.h, u.dumvarapaadapo.atituur.na.m \"su.sko.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tato yii\"sustaanuvaaca, yu.smaanaha.m satya.m vadaami, yadi yuuyamasandigdhaa.h pratiitha, tarhi yuuyamapi kevalo.dumvarapaadapa.m pratiittha.m karttu.m \"sak.syatha, tanna, tva.m calitvaa saagare pateti vaakya.m yu.smaabhirasmina \"saile proktepi tadaiva tad gha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathaa vi\"svasya praarthya yu.smaabhi ryad yaaci.syate, tadeva praapsyate| ");
INSERT INTO sanvel_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantara.m mandira.m pravi\"syopade\"sanasamaye tatsamiipa.m pradhaanayaajakaa.h praaciinalokaa\"scaagatya papracchu.h, tvayaa kena saamarthyanaitaani karmmaa.ni kriyante? kena vaa tubhyametaani saamarthyaani dattaani? ");
INSERT INTO sanvel_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tato yii\"su.h pratyavadat, ahamapi yu.smaan vaacamekaa.m p.rcchaami, yadi yuuya.m taduttara.m daatu.m \"sak.syatha, tadaa kena saamarthyena karmmaa.nyetaani karomi, tadaha.m yu.smaan vak.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yohano majjana.m kasyaaj nayaabhavat? kimii\"svarasya manu.syasya vaa? tataste paraspara.m vivicya kathayaamaasu.h, yadii\"svarasyeti vadaamastarhi yuuya.m ta.m kuto na pratyaita? vaacametaa.m vak.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manu.syasyeti vaktumapi lokebhyo bibhiima.h, yata.h sarvvairapi yohan bhavi.syadvaadiiti j naayate| ");
INSERT INTO sanvel_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmaat te yii\"su.m pratyavadan, tad vaya.m na vidma.h| tadaa sa taanuktavaan, tarhi kena saamarathyena karmmaa.nyetaanyaha.m karomi, tadapyaha.m yu.smaan na vak.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyacijjanasya dvau sutaavaastaa.m sa ekasya sutasya samiipa.m gatvaa jagaada, he suta, tvamadya mama draak.saak.setre karmma kartu.m vraja| ");
INSERT INTO sanvel_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tata.h sa uktavaan, na yaasyaami, kintu \"se.se.anutapya jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantara.m sonyasutasya samiipa.m gatvaa tathaiva kathtivaan; tata.h sa pratyuvaaca, maheccha yaami, kintu na gata.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","etayo.h putrayo rmadhye piturabhimata.m kena paalita.m? yu.smaabhi.h ki.m budhyate? tataste pratyuucu.h, prathamena puुtre.na| tadaanii.m yii\"sustaanuvaaca, aha.m yu.smaan tathya.m vadaami, ca.n.daalaa ga.nikaa\"sca yu.smaakamagrata ii\"svarasya raajya.m pravi\"santi| ");
INSERT INTO sanvel_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yato yu.smaaka.m samiipa.m yohani dharmmapathenaagate yuuya.m ta.m na pratiitha, kintu ca.n.daalaa ga.nikaa\"sca ta.m pratyaayan, tad vilokyaapi yuuya.m pratyetu.m naakhidyadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparameka.m d.r.s.taanta.m \"s.r.nuta, ka\"scid g.rhastha.h k.setre draak.saalataa ropayitvaa taccaturdik.su vaara.nii.m vidhaaya tanmadhye draak.saayantra.m sthaapitavaan, maa nca nca nirmmitavaan, tata.h k.r.sake.su tat k.setra.m samarpya svaya.m duurade\"sa.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantara.m phalasamaya upasthite sa phalaani praaptu.m k.r.siivalaanaa.m samiipa.m nijadaasaan pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu k.r.siivalaastasya taan daaseyaan dh.rtvaa ka ncana prah.rtavanta.h, ka ncana paa.saa.nairaahatavanta.h, ka ncana ca hatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhu.h prathamato.adhikadaaseyaan pre.sayaamaasa, kintu te taan pratyapi tathaiva cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantara.m mama sute gate ta.m samaadari.syante, ityuktvaa \"se.se sa nijasuta.m te.saa.m sannidhi.m pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu te k.r.siivalaa.h suta.m viik.sya parasparam iti mantrayitum aarebhire, ayamuttaraadhikaarii vayamena.m nihatyaasyaadhikaara.m svava\"siikari.syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","pa\"scaat te ta.m dh.rtvaa draak.saak.setraad bahi.h paatayitvaabadhi.su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadaa sa draak.saak.setrapatiraagami.syati, tadaa taan k.r.siivalaan ki.m kari.syati? ");
INSERT INTO sanvel_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tataste pratyavadan, taan kalu.si.no daaru.nayaatanaabhiraahani.syati, ye ca samayaanukramaat phalaani daasyanti, taad.r\"se.su k.r.siivale.su k.setra.m samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadaa yii\"sunaa te gaditaa.h, graha.na.m na k.rta.m yasya paa.saa.nasya nicaayakai.h| pradhaanaprastara.h ko.ne saeva sa.mbhavi.syati| etat pare\"situ.h karmmaasmad.r.s.taavadbhuta.m bhavet| dharmmagranthe likhitametadvacana.m yu.smaabhi.h ki.m naapaa.thi? ");
INSERT INTO sanvel_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmaadaha.m yu.smaan vadaami, yu.smatta ii\"svariiyaraajyamapaniiya phalotpaadayitranyajaataye daayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yo jana etatpaa.saa.nopari pati.syati, ta.m sa bha.mk.syate, kintvaya.m paa.saa.no yasyopari pati.syati, ta.m sa dhuulivat cuur.niikari.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadaanii.m praadhanayaajakaa.h phiruu\"sina\"sca tasyemaa.m d.r.s.taantakathaa.m \"srutvaa so.asmaanuddi\"sya kathitavaan, iti vij naaya ta.m dharttu.m ce.s.titavanta.h; ");
INSERT INTO sanvel_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lokebhyo bibhyu.h, yato lokai.h sa bhavi.syadvaadiityaj naayi| ");
INSERT INTO sanvel_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantara.m yii\"su.h punarapi d.r.s.taantena taan avaadiit, ");
INSERT INTO sanvel_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargiiyaraajyam etaad.r\"sasya n.rpate.h sama.m, yo nija putra.m vivaahayan sarvvaan nimantritaan aanetu.m daaseyaan prahitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu te samaagantu.m ne.s.tavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tato raajaa punarapi daasaananyaan ityuktvaa pre.sayaamaasa, nimantritaan vadata, pa\"syata, mama bhejyamaasaaditamaaste, nijav.ta.saadipu.s.tajantuun maarayitvaa sarvva.m khaadyadravyamaasaaditavaan, yuuya.m vivaahamaagacchata| ");
INSERT INTO sanvel_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi te tucchiik.rtya kecit nijak.setra.m kecid vaa.nijya.m prati svasvamaarge.na calitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anye lokaastasya daaseyaan dh.rtvaa dauraatmya.m vyavah.rtya taanavadhi.su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantara.m sa n.rpatistaa.m vaarttaa.m \"srutvaa krudhyan sainyaani prahitya taan ghaatakaan hatvaa te.saa.m nagara.m daahayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tata.h sa nijadaaseyaan babhaa.se, vivaahiiya.m bhojyamaasaaditamaaste, kintu nimantritaa janaa ayogyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmaad yuuya.m raajamaarga.m gatvaa yaavato manujaan pa\"syata, taavataeva vivaahiiyabhojyaaya nimantrayata| ");
INSERT INTO sanvel_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadaa te daaseyaa raajamaarga.m gatvaa bhadraan abhadraan vaa yaavato janaan dad.r\"su.h, taavataeva sa.mg.rhyaanayan; tato.abhyaagatamanujai rvivaahag.rham apuuryyata| ");
INSERT INTO sanvel_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadaanii.m sa raajaa sarvvaanabhyaagataan dra.s.tum abhyantaramaagatavaan; tadaa tatra vivaahiiyavasanahiinameka.m jana.m viik.sya ta.m jagaad, ");
INSERT INTO sanvel_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","he mitra,tva.m vivaahiiyavasana.m vinaa kathamatra pravi.s.tavaan? tena sa niruttaro babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadaa raajaa nijaanucaraan avadat, etasya karacara.naan baddhaa yatra rodana.m dantairdantaghar.sa.na nca bhavati, tatra vahirbhuutatamisre ta.m nik.sipata| ");
INSERT INTO sanvel_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ittha.m bahava aahuutaa alpe manobhimataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantara.m phiruu\"sina.h pragatya yathaa sa.mlaapena tam unmaathe paatayeyustathaa mantrayitvaa ");
INSERT INTO sanvel_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","herodiiyamanujai.h saaka.m nija\"si.syaga.nena ta.m prati kathayaamaasu.h, he guro, bhavaan satya.h satyamii\"svariiyamaargamupadi\"sati, kamapi maanu.sa.m naanurudhyate, kamapi naapek.sate ca, tad vaya.m jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ata.h kaisarabhuupaaya karo.asmaaka.m daatavyo na vaa? atra bhavataa ki.m budhyate? tad asmaan vadatu| ");
INSERT INTO sanvel_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tato yii\"suste.saa.m khalataa.m vij naaya kathitavaan, re kapa.tina.h yuya.m kuto maa.m parik.sadhve? ");
INSERT INTO sanvel_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradaanasya mudraa.m maa.m dar\"sayata| tadaanii.m taistasya samiipa.m mudraacaturthabhaaga aaniite ");
INSERT INTO sanvel_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa taan papraccha, atra kasyeya.m muurtti rnaama caaste? te jagadu.h, kaisarabhuupasya| ");
INSERT INTO sanvel_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tata.h sa uktavaana, kaisarasya yat tat kaisaraaya datta, ii\"svarasya yat tad ii\"svaraaya datta| ");
INSERT INTO sanvel_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vaakya.m ni\"samya te vismaya.m vij naaya ta.m vihaaya calitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani siduukino.arthaat \"sma\"saanaat notthaasyantiiti vaakya.m ye vadanti, te yii\"seाrantikam aagatya papracchu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","he guro, ka\"scinmanuja\"scet ni.hsantaana.h san praa.naan tyajati, tarhi tasya bhraataa tasya jaayaa.m vyuhya bhraatu.h santaanam utpaadayi.syatiiti muusaa aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmaakamatra ke.api janaa.h saptasahodaraa aasan, te.saa.m jye.s.tha ekaa.m kanyaa.m vyavahaat, apara.m praa.natyaagakaale svaya.m ni.hsantaana.h san taa.m striya.m svabhraatari samarpitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tato dvitiiyaadisaptamaantaa\"sca tathaiva cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","\"se.se saapii naarii mamaara| ");
INSERT INTO sanvel_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","m.rtaanaam utthaanasamaye te.saa.m saptaanaa.m madhye saa naarii kasya bhaaryyaa bhavi.syati? yasmaat sarvvaeva taa.m vyavahan| ");
INSERT INTO sanvel_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tato yii\"su.h pratyavaadiit, yuuya.m dharmmapustakam ii\"svariiyaa.m \"sakti nca na vij naaya bhraantimanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthaanapraaptaa lokaa na vivahanti, na ca vaacaa diiyante, kintvii\"svarasya svargasthaduutaanaa.m sad.r\"saa bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","apara.m m.rtaanaamutthaanamadhi yu.smaan pratiiyamii\"svarokti.h, ");
INSERT INTO sanvel_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibraahiima ii\"svara ishaaka ii\"svaro yaakuuba ii\"svara\" iti ki.m yu.smaabhi rnaapaa.thi? kintvii\"svaro jiivataam ii\"svara:, sa m.rtaanaamii\"svaro nahi| ");
INSERT INTO sanvel_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti \"srutvaa sarvve lokaastasyopade\"saad vismaya.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantara.m siduukinaam niruttaratvavaartaa.m ni\"samya phiruu\"sina ekatra militavanta.h, ");
INSERT INTO sanvel_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","te.saameko vyavasthaapako yii\"su.m pariik.situ.m papaccha, ");
INSERT INTO sanvel_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","he guro vyavasthaa\"saastramadhye kaaj naa \"sre.s.thaa? ");
INSERT INTO sanvel_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tato yii\"suruvaaca, tva.m sarvvaanta.hkara.nai.h sarvvapraa.nai.h sarvvacittai\"sca saaka.m prabhau parame\"svare priiyasva, ");
INSERT INTO sanvel_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","e.saa prathamamahaaj naa| tasyaa.h sad.r\"sii dvitiiyaaj nai.saa, ");
INSERT INTO sanvel_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samiipavaasini svaatmaniiva prema kuru| ");
INSERT INTO sanvel_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayo rdvayoraaj nayo.h k.rtsnavyavasthaayaa bhavi.syadvakt.rgranthasya ca bhaarasti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantara.m phiruu\"sinaam ekatra sthitikaale yii\"sustaan papraccha, ");
INSERT INTO sanvel_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrii.s.tamadhi yu.smaaka.m kiid.rgbodho jaayate? sa kasya santaana.h? tataste pratyavadan, daayuuda.h santaana.h| ");
INSERT INTO sanvel_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadaa sa uktavaan, tarhi daayuud katham aatmaadhi.s.thaanena ta.m prabhu.m vadati ? ");
INSERT INTO sanvel_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathaa mama prabhumida.m vaakyamavadat parame\"svara.h| tavaariin paadapii.tha.m te yaavannahi karomyaha.m| taavat kaala.m madiiye tva.m dak.sapaar\"sva upaavi\"sa| ato yadi daayuud ta.m prabhu.m vadati, rtiha sa katha.m tasya santaano bhavati? ");
INSERT INTO sanvel_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadaanii.m te.saa.m kopi tadvaakyasya kimapyuttara.m daatu.m naa\"saknot; ");
INSERT INTO sanvel_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamaarabhya ta.m kimapi vaakya.m pra.s.tu.m kasyaapi saahaso naabhavat| ");
INSERT INTO sanvel_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantara.m yii\"su rjananivaha.m \"si.syaa.m\"scaavadat, ");
INSERT INTO sanvel_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyaapakaa.h phiruu\"sina\"sca muusaasane upavi\"santi, ");
INSERT INTO sanvel_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ataste yu.smaan yadyat mantum aaj naapayanti, tat manyadhva.m paalayadhva nca, kintu te.saa.m karmmaanuruupa.m karmma na kurudhva.m; yataste.saa.m vaakyamaatra.m saara.m kaaryye kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","te durvvahaan gurutaraan bhaaraan badvvaa manu.syaa.naa.m skandhepari samarpayanti, kintu svayama\"ngulyaikayaapi na caalayanti| ");
INSERT INTO sanvel_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kevala.m lokadar\"sanaaya sarvvakarmmaa.ni kurvvanti; phalata.h pa.t.tabandhaan prasaaryya dhaarayanti, svavastre.su ca diirghagranthiin dhaarayanti; ");
INSERT INTO sanvel_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhojanabhavana uccasthaana.m, bhajanabhavane pradhaanamaasana.m, ");
INSERT INTO sanvel_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ha.t.the namaskaara.m gururiti sambodhana ncaitaani sarvvaa.ni vaa nchanti| ");
INSERT INTO sanvel_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yuuya.m gurava iti sambodhaniiyaa maa bhavata, yato yu.smaakam eka.h khrii.s.taeva guru ");
INSERT INTO sanvel_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryuuya.m sarvve mitho bhraatara\"sca| puna.h p.rthivyaa.m kamapi piteti maa sambudhyadhva.m, yato yu.smaakameka.h svargasthaeva pitaa| ");
INSERT INTO sanvel_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yuuya.m naayaketi sambhaa.sitaa maa bhavata, yato yu.smaakameka.h khrii.s.taeva naayaka.h| ");
INSERT INTO sanvel_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","apara.m yu.smaaka.m madhye ya.h pumaan \"sre.s.tha.h sa yu.smaan sevi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yato ya.h svamunnamati, sa nata.h kari.syate; kintu ya.h ka\"scit svamavanata.m karoti, sa unnata.h kari.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuya.m manujaanaa.m samak.sa.m svargadvaara.m rundha, yuuya.m svaya.m tena na pravi\"satha, pravivik.suunapi vaarayatha| vata kapa.tina upaadhyaayaa.h phiruu\"sina\"sca yuuya.m chalaad diirgha.m praarthya vidhavaanaa.m sarvvasva.m grasatha, yu.smaaka.m ghoratarada.n.do bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuyameka.m svadharmmaavalambina.m karttu.m saagara.m bhuuma.n.dala nca pradak.si.niikurutha, ");
INSERT INTO sanvel_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ka ncana praapya svato dvigu.nanarakabhaajana.m ta.m kurutha| ");
INSERT INTO sanvel_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadar\"sakaa.h sarvve, yuuya.m vadatha, mandirasya \"sapathakara.naat kimapi na deya.m; kintu mandirasthasuvar.nasya \"sapathakara.naad deya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","he muu.dhaa he andhaa.h suvar.na.m tatsuvar.napaavakamandiram etayorubhayo rmadhye ki.m \"sreya.h? ");
INSERT INTO sanvel_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyacca vadatha, yaj navedyaa.h \"sapathakara.naat kimapi na deya.m, kintu taduparisthitasya naivedyasya \"sapathakara.naad deya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","he muu.dhaa he andhaa.h, naivedya.m tannaivedyapaavakavediretayorubhayo rmadhye ki.m \"sreya.h? ");
INSERT INTO sanvel_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ata.h kenacid yaj navedyaa.h \"sapathe k.rte taduparisthasya sarvvasya \"sapatha.h kriyate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kenacit mandirasya \"sapathe k.rte mandiratannivaasino.h \"sapatha.h kriyate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kenacit svargasya \"sapathe k.rte ii\"svariiyasi.mhaasanataduparyyupavi.s.tayo.h \"sapatha.h kriyate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuya.m podinaayaa.h sitacchatraayaa jiirakasya ca da\"samaa.m\"saan dattha, kintu vyavasthaayaa gurutaraan nyaayadayaavi\"svaasaan parityajatha; ime yu.smaabhiraacara.niiyaa amii ca na la.mghaniiyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","he andhapathadar\"sakaa yuuya.m ma\"sakaan apasaarayatha, kintu mahaa\"ngaan grasatha| ");
INSERT INTO sanvel_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuya.m paanapaatraa.naa.m bhojanapaatraa.naa nca bahi.h pari.skurutha; kintu tadabhyantara.m duraatmatayaa kalu.se.na ca paripuur.namaaste| ");
INSERT INTO sanvel_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","he andhaa.h phiruu\"silokaa aadau paanapaatraa.naa.m bhojanapaatraa.naa ncaabhyantara.m pari.skuruta, tena te.saa.m bahirapi pari.skaari.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuya.m \"sukliik.rta\"sma\"saanasvaruupaa bhavatha, yathaa \"sma\"saanabhavanasya bahi\"scaaru, kintvabhyantara.m m.rtalokaanaa.m kiika\"sai.h sarvvaprakaaramalena ca paripuur.nam; ");
INSERT INTO sanvel_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yuuyamapi lokaanaa.m samak.sa.m bahirdhaarmmikaa.h kintvanta.hkara.ne.su kevalakaapa.tyaadharmmaabhyaa.m paripuur.naa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","haa haa kapa.tina upaadhyaayaa.h phiruu\"sina\"sca, yuuya.m bhavi.syadvaadinaa.m \"sma\"saanageha.m nirmmaatha, saadhuunaa.m \"sma\"saananiketana.m \"sobhayatha ");
INSERT INTO sanvel_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha ca yadi vaya.m sve.saa.m puurvvapuru.saa.naa.m kaala asthaasyaama, tarhi bhavi.syadvaadinaa.m \"so.nitapaatane te.saa.m sahabhaagino naabhavi.syaama| ");
INSERT INTO sanvel_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ato yuuya.m bhavi.syadvaadighaatakaanaa.m santaanaa iti svayameva sve.saa.m saak.sya.m dattha| ");
INSERT INTO sanvel_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ato yuuya.m nijapuurvvapuru.saa.naa.m parimaa.napaatra.m paripuurayata| ");
INSERT INTO sanvel_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","re bhujagaa.h k.r.s.nabhujagava.m\"saa.h, yuuya.m katha.m narakada.n.daad rak.si.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","pa\"syata, yu.smaakamantikam aha.m bhavi.syadvaadino buddhimata upaadhyaayaa.m\"sca pre.sayi.syaami, kintu te.saa.m katipayaa yu.smaabhi rghaani.syante, kru\"se ca ghaani.syante, kecid bhajanabhavane ka.saabhiraaghaani.syante, nagare nagare taa.di.syante ca; ");
INSERT INTO sanvel_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tena satpuru.sasya haabilo raktapaatamaarabhya berikhiya.h putra.m ya.m sikhariya.m yuuya.m mandirayaj navedyo rmadhye hatavanta.h, tadiiya\"so.nitapaata.m yaavad asmin de\"se yaavataa.m saadhupuru.saa.naa.m \"so.nitapaato .abhavat tat sarvve.saamaagasaa.m da.n.daa yu.smaasu vartti.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","aha.m yu.smaanta tathya.m vadaami, vidyamaane.asmin puru.se sarvve vartti.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","he yiruu\"saalam he yiruu\"saalam nagari tva.m bhavi.syadvaadino hatavatii, tava samiipa.m preritaa.m\"sca paa.saa.nairaahatavatii, yathaa kukku.tii \"saavakaan pak.saadha.h sa.mg.rhlaati, tathaa tava santaanaan sa.mgrahiitu.m aha.m bahuvaaram aiccha.m; kintu tva.m na samamanyathaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","pa\"syata ya.smaaka.m vaasasthaanam ucchinna.m tyak.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","aha.m yu.smaan tathya.m vadaami, ya.h parame\"svarasya naamnaagacchati, sa dhanya iti vaa.nii.m yaavanna vadi.syatha, taavat maa.m puna rna drak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantara.m yii\"su ryadaa mandiraad bahi rgacchati, tadaanii.m \"si.syaasta.m mandiranirmmaa.na.m dar\"sayitumaagataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tato yii\"sustaanuvaaca, yuuya.m kimetaani na pa\"syatha? yu.smaanaha.m satya.m vadaami, etannicayanasya paa.saa.naikamapyanyapaa.saa.neाpari na sthaasyati sarvvaa.ni bhuumisaat kaari.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantara.m tasmin jaitunaparvvatopari samupavi.s.te \"si.syaastasya samiipamaagatya gupta.m papracchu.h, etaa gha.tanaa.h kadaa bhavi.syanti? bhavata aagamanasya yugaantasya ca ki.m lak.sma? tadasmaan vadatu| ");
INSERT INTO sanvel_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadaanii.m yii\"sustaanavocat, avadhadvva.m, kopi yu.smaan na bhramayet| ");
INSERT INTO sanvel_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavo mama naama g.rhlanta aagami.syanti, khrii.s.to.ahameveti vaaca.m vadanto bahuun bhramayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yuuya nca sa.mgraamasya ra.nasya caa.dambara.m \"sro.syatha, avadhadvva.m tena ca ncalaa maa bhavata, etaanyava\"sya.m gha.ti.syante, kintu tadaa yugaanto nahi| ");
INSERT INTO sanvel_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","apara.m de\"sasya vipak.so de\"so raajyasya vipak.so raajya.m bhavi.syati, sthaane sthaane ca durbhik.sa.m mahaamaarii bhuukampa\"sca bhavi.syanti, ");
INSERT INTO sanvel_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","etaani du.hkhopakramaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadaanii.m lokaa du.hkha.m bhojayitu.m yu.smaan parakare.su samarpayi.syanti hani.syanti ca, tathaa mama naamakaara.naad yuuya.m sarvvade\"siiyamanujaanaa.m samiipe gh.r.naarhaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahu.su vighna.m praaptavatsu parasparam .rृtiiyaa.m k.rtavatsu ca eko.apara.m parakare.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathaa bahavo m.r.saabhavi.syadvaadina upasthaaya bahuun bhramayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","du.skarmma.naa.m baahulyaa nca bahuunaa.m prema \"siitala.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu ya.h ka\"scit \"se.sa.m yaavad dhairyyamaa\"srayate, saeva paritraayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","apara.m sarvvade\"siiyalokaan pratimaak.sii bhavitu.m raajasya \"subhasamaacaara.h sarvvajagati pracaari.syate, etaad.r\"si sati yugaanta upasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ato yat sarvvanaa\"sak.rdgh.r.naarha.m vastu daaniyelbhavi.syadvadinaa prokta.m tad yadaa pu.nyasthaane sthaapita.m drak.syatha, (ya.h pa.thati, sa budhyataa.m) ");
INSERT INTO sanvel_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadaanii.m ye yihuudiiyade\"se ti.s.thanti, te parvvate.su palaayantaa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ya.h ka\"scid g.rhap.r.s.the ti.s.thati, sa g.rhaat kimapi vastvaanetum adheा naavarohet| ");
INSERT INTO sanvel_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ya\"sca k.setre ti.s.thati, sopi vastramaanetu.m paraav.rtya na yaayaat| ");
INSERT INTO sanvel_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadaanii.m garbhi.niistanyapaayayitrii.naa.m durgati rbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ato ya.smaaka.m palaayana.m \"siitakaale vi\"sraamavaare vaa yanna bhavet, tadartha.m praarthayadhvam| ");
INSERT INTO sanvel_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","aa jagadaarambhaad etatkaalaparyyananta.m yaad.r\"sa.h kadaapi naabhavat na ca bhavi.syati taad.r\"so mahaakle\"sastadaaniim upasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya kle\"sasya samayo yadi hsvo na kriyeta, tarhi kasyaapi praa.nino rak.sa.na.m bhavitu.m na \"saknuyaat, kintu manoniitamanujaanaa.m k.rte sa kaalo hsviikari.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","apara nca pa\"syata, khrii.s.to.atra vidyate, vaa tatra vidyate, tadaanii.m yadii ka\"scid yu.smaana iti vaakya.m vadati, tathaapi tat na pratiit| ");
INSERT INTO sanvel_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yato bhaaktakhrii.s.taa bhaaktabhavi.syadvaadina\"sca upasthaaya yaani mahanti lak.smaa.ni citrakarmmaa.ni ca prakaa\"sayi.syanti, tai ryadi sambhavet tarhi manoniitamaanavaa api bhraami.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","pa\"syata, gha.tanaata.h puurvva.m yu.smaan vaarttaam avaadi.sam| ");
INSERT INTO sanvel_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ata.h pa\"syata, sa praantare vidyata iti vaakye kenacit kathitepi bahi rmaa gacchata, vaa pa\"syata, sonta.hpure vidyate, etadvaakya uktepi maa pratiita| ");
INSERT INTO sanvel_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yato yathaa vidyut puurvvadi\"so nirgatya pa\"scimadi\"sa.m yaavat prakaa\"sate, tathaa maanu.saputrasyaapyaagamana.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra \"savasti.s.thati, tatreva g.rdhraa milanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","apara.m tasya kle\"sasamayasyaavyavahitaparatra suuryyasya tejo lopsyate, candramaa jyosnaa.m na kari.syati, nabhaso nak.satraa.ni pati.syanti, gaga.niiyaa grahaa\"sca vicali.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadaaniim aakaa\"samadhye manujasutasya lak.sma dar\"si.syate, tato nijaparaakrame.na mahaatejasaa ca meghaaruu.dha.m manujasuta.m nabhasaagacchanta.m vilokya p.rthivyaa.h sarvvava.m\"siiyaa vilapi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadaanii.m sa mahaa\"sabdaayamaanatuuryyaa vaadakaan nijaduutaan prahe.syati, te vyomna ekasiimaato.aparasiimaa.m yaavat caturdi\"sastasya manoniitajanaan aaniiya melayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","u.dumbarapaadapasya d.r.s.taanta.m \"sik.sadhva.m; yadaa tasya naviinaa.h \"saakhaa jaayante, pallavaadi\"sca nirgacchati, tadaa nidaaghakaala.h savidho bhavatiiti yuuya.m jaaniitha; ");
INSERT INTO sanvel_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad etaa gha.tanaa d.r.s.tvaa sa samayo dvaara upaasthaad iti jaaniita| ");
INSERT INTO sanvel_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yu.smaanaha.m tathya.m vadaami, idaaniintanajanaanaa.m gamanaat puurvvameva taani sarvvaa.ni gha.ti.syante| ");
INSERT INTO sanvel_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhomedinyo rluptayorapi mama vaak kadaapi na lopsyate| ");
INSERT INTO sanvel_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","apara.m mama taata.m vinaa maanu.sa.h svargastho duuto vaa kopi taddina.m tadda.n.da nca na j naapayati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","apara.m nohe vidyamaane yaad.r\"samabhavat taad.r\"sa.m manujasutasyaagamanakaalepi bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalato jalaaplaavanaat puurvva.m yaddina.m yaavat noha.h pota.m naarohat, taavatkaala.m yathaa manu.syaa bhojane paane vivahane vivaahane ca prav.rttaa aasan; ");
INSERT INTO sanvel_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam aaplaavitoyamaagatya yaavat sakalamanujaan plaavayitvaa naanayat, taavat te yathaa na vidaamaasu.h, tathaa manujasutaagamanepi bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadaa k.setrasthitayordvayoreko dhaari.syate, aparastyaaji.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathaa pe.sa.nyaa pi.m.satyorubhayo ryo.sitorekaa dhaari.syate.aparaa tyaaji.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yu.smaaka.m prabhu.h kasmin da.n.da aagami.syati, tad yu.smaabhi rnaavagamyate, tasmaat jaagrata.h santasti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yaame stena aagami.syatiiti ced g.rhastho j naatum a\"sak.syat, tarhi jaagaritvaa ta.m sandhi.m karttitum avaarayi.syat tad jaaniita| ");
INSERT INTO sanvel_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yu.smaabhiravadhiiyataa.m, yato yu.smaabhi ryatra na budhyate, tatraiva da.n.de manujasuta aayaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivaaraan yathaakaala.m bhojayitu.m ya.m daasam adhyak.siik.rtya sthaapayati, taad.r\"so vi\"svaasyo dhiimaan daasa.h ka.h? ");
INSERT INTO sanvel_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhuraagatya ya.m daasa.m tathaacaranta.m viik.sate, saeva dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yu.smaanaha.m satya.m vadaami, sa ta.m nijasarvvasvasyaadhipa.m kari.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhuraagantu.m vilambata iti manasi cintayitvaa yo du.s.to daaso ");
INSERT INTO sanvel_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49",".aparadaasaan praharttu.m mattaanaa.m sa\"nge bhoktu.m paatu nca pravarttate, ");
INSERT INTO sanvel_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa daaso yadaa naapek.sate, ya nca da.n.da.m na jaanaati, tatkaalaeva tatprabhurupasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadaa ta.m da.n.dayitvaa yatra sthaane rodana.m dantaghar.sa.na ncaasaate, tatra kapa.tibhi.h saaka.m tadda\"saa.m niruupayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yaa da\"sa kanyaa.h pradiipaan g.rhlatyo vara.m saak.saat karttu.m bahiritaa.h, taabhistadaa svargiiyaraajyasya saad.r\"sya.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","taasaa.m kanyaanaa.m madhye pa nca sudhiya.h pa nca durdhiya aasan| ");
INSERT INTO sanvel_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yaa durdhiyastaa.h pradiipaan sa\"nge g.rhiitvaa taila.m na jag.rhu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiya.h pradiipaan paatre.na taila nca jag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantara.m vare vilambite taa.h sarvvaa nidraavi.s.taa nidraa.m jagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharaatre pa\"syata vara aagacchati, ta.m saak.saat karttu.m bahiryaateti janaravaat ");
INSERT INTO sanvel_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","taa.h sarvvaa.h kanyaa utthaaya pradiipaan aasaadayitu.m aarabhanta| ");
INSERT INTO sanvel_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tato durdhiya.h sudhiya uucu.h, ki ncit taila.m datta, pradiipaa asmaaka.m nirvvaa.naa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiya.h pratyavadan, datte yu.smaanasmaa.m\"sca prati taila.m nyuuniibhavet, tasmaad vikret.r.naa.m samiipa.m gatvaa svaartha.m taila.m krii.niita| ");
INSERT INTO sanvel_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadaa taasu kretu.m gataasu vara aajagaama, tato yaa.h sajjitaa aasan, taastena saaka.m vivaahiiya.m ve\"sma pravivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantara.m dvaare ruddhe aparaa.h kanyaa aagatya jagadu.h, he prabho, he prabho, asmaan prati dvaara.m mocaya| ");
INSERT INTO sanvel_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavaan, tathya.m vadaami, yu.smaanaha.m na vedmi| ");
INSERT INTO sanvel_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ato jaagrata.h santasti.s.thata, manujasuta.h kasmin dine kasmin da.n.de vaagami.syati, tad yu.smaabhi rna j naayate| ");
INSERT INTO sanvel_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","apara.m sa etaad.r\"sa.h kasyacit pu.msastulya.h, yo duurade\"sa.m prati yaatraakaale nijadaasaan aahuuya te.saa.m svasvasaamarthyaanuruupam ");
INSERT INTO sanvel_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ekasmin mudraa.naa.m pa nca po.talikaa.h anyasmi.m\"sca dve po.talike aparasmi.m\"sca po.talikaikaam ittha.m pratijana.m samarpya svaya.m pravaasa.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantara.m yo daasa.h pa nca po.talikaa.h labdhavaan, sa gatvaa vaa.nijya.m vidhaaya taa dvigu.niicakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ya\"sca daaso dve po.talike alabhata, sopi taa mudraa dvigu.niicakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yo daasa ekaa.m po.talikaa.m labdhavaan, sa gatvaa bhuumi.m khanitvaa tanmadhye nijaprabhostaa mudraa gopayaa ncakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantara.m bahutithe kaale gate te.saa.m daasaanaa.m prabhuraagatya tairdaasai.h sama.m ga.nayaa ncakaara| ");
INSERT INTO sanvel_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadaanii.m ya.h pa nca po.talikaa.h praaptavaan sa taa dvigu.niik.rtamudraa aaniiya jagaada; he prabho, bhavataa mayi pa nca po.talikaa.h samarpitaa.h, pa\"syatu, taa mayaa dvigu.niik.rtaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadaanii.m tasya prabhustamuvaaca, he uttama vi\"svaasya daasa, tva.m dhanyosi, stokena vi\"svaasyo jaata.h, tasmaat tvaa.m bahuvittaadhipa.m karomi, tva.m svaprabho.h sukhasya bhaagii bhava| ");
INSERT INTO sanvel_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tato yena dve po.talike labdhe sopyaagatya jagaada, he prabho, bhavataa mayi dve po.talike samarpite, pa\"syatu te mayaa dvigu.niik.rte| ");
INSERT INTO sanvel_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tena tasya prabhustamavocat, he uttama vi\"svaasya daasa, tva.m dhanyosi, stokena vi\"svaasyo jaata.h, tasmaat tvaa.m bahudravi.naadhipa.m karomi, tva.m nijaprabho.h sukhasya bhaagii bhava| ");
INSERT INTO sanvel_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantara.m ya ekaa.m po.talikaa.m labdhavaan, sa etya kathitavaan, he prabho, tvaa.m ka.thinanara.m j naatavaan, tvayaa yatra nopta.m, tatraiva k.rtyate, yatra ca na kiir.na.m, tatraiva sa.mg.rhyate| ");
INSERT INTO sanvel_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atoha.m sa\"sa\"nka.h san gatvaa tava mudraa bhuumadhye sa.mgopya sthaapitavaan, pa\"sya, tava yat tadeva g.rhaa.na| ");
INSERT INTO sanvel_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadaa tasya prabhu.h pratyavadat re du.s.taalasa daasa, yatraaha.m na vapaami, tatra chinadmi, yatra ca na kiraami, tatreva sa.mg.rhlaamiiti cedajaanaastarhi ");
INSERT INTO sanvel_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","va.nik.su mama vittaarpa.na.m tavocitamaasiit, yenaahamaagatya v.rdvyaa saaka.m muulamudraa.h praapsyam| ");
INSERT INTO sanvel_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atosmaat taa.m po.talikaam aadaaya yasya da\"sa po.talikaa.h santi tasminnarpayata| ");
INSERT INTO sanvel_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yena vardvyate tasminnaivaarpi.syate, tasyaiva ca baahulya.m bhavi.syati, kintu yena na vardvyate, tasyaantike yat ki ncana ti.s.thati, tadapi punarne.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","apara.m yuuya.m tamakarmma.nya.m daasa.m niitvaa yatra sthaane krandana.m dantaghar.sa.na nca vidyete, tasmin bahirbhuutatamasi nik.sipata| ");
INSERT INTO sanvel_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadaa manujasuta.h pavitraduutaan sa\"ngina.h k.rtvaa nijaprabhaavenaagatya nijatejomaye si.mhaasane nivek.syati, ");
INSERT INTO sanvel_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadaa tatsammukhe sarvvajaatiiyaa janaa sa.mmeli.syanti| tato me.sapaalako yathaa chaagebhyo.aviin p.rthak karoti tathaa sopyekasmaadanyam ittha.m taan p.rthaka k.rtvaaviin ");
INSERT INTO sanvel_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dak.si.ne chaagaa.m\"sca vaame sthaapayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tata.h para.m raajaa dak.si.nasthitaan maanavaan vadi.syati, aagacchata mattaatasyaanugrahabhaajanaani, yu.smatk.rta aa jagadaarambhat yad raajyam aasaadita.m tadadhikuruta| ");
INSERT INTO sanvel_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yato bubhuk.sitaaya mahya.m bhojyam adatta, pipaasitaaya peyamadatta, vide\"sina.m maa.m svasthaanamanayata, ");
INSERT INTO sanvel_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahiina.m maa.m vasana.m paryyadhaapayata, pii.diita.m maa.m dra.s.tumaagacchata, kaaraastha nca maa.m viik.situma aagacchata| ");
INSERT INTO sanvel_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadaa dhaarmmikaa.h prativadi.syanti, he prabho, kadaa tvaa.m k.sudhita.m viik.sya vayamabhojayaama? vaa pipaasita.m viik.sya apaayayaama? ");
INSERT INTO sanvel_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadaa vaa tvaa.m vide\"sina.m vilokya svasthaanamanayaama? kadaa vaa tvaa.m nagna.m viik.sya vasana.m paryyadhaapayaama? ");
INSERT INTO sanvel_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadaa vaa tvaa.m pii.dita.m kaaraastha nca viik.sya tvadantikamagacchaama? ");
INSERT INTO sanvel_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadaanii.m raajaa taan prativadi.syati, yu.smaanaha.m satya.m vadaami, mamaite.saa.m bhraat.r.naa.m madhye ka ncanaika.m k.sudratama.m prati yad akuruta, tanmaa.m pratyakuruta| ");
INSERT INTO sanvel_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","pa\"scaat sa vaamasthitaan janaan vadi.syati, re \"saapagrastaa.h sarvve, \"saitaane tasya duutebhya\"sca yo.anantavahniraasaadita aaste, yuuya.m madantikaat tamagni.m gacchata| ");
INSERT INTO sanvel_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yato k.sudhitaaya mahyamaahaara.m naadatta, pipaasitaaya mahya.m peya.m naadatta, ");
INSERT INTO sanvel_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","vide\"sina.m maa.m svasthaana.m naanayata, vasanahiina.m maa.m vasana.m na paryyadhaapayata, pii.dita.m kaaraastha nca maa.m viik.situ.m naagacchata| ");
INSERT INTO sanvel_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadaa te prativadi.syanti, he prabho, kadaa tvaa.m k.sudhita.m vaa pipaasita.m vaa vide\"sina.m vaa nagna.m vaa pii.dita.m vaa kaaraastha.m viik.sya tvaa.m naasevaamahi? ");
INSERT INTO sanvel_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadaa sa taan vadi.syati, tathyamaha.m yu.smaan braviimi, yu.smaabhire.saa.m ka ncana k.sodi.s.tha.m prati yannaakaari, tanmaa.m pratyeva naakaari| ");
INSERT INTO sanvel_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","pa\"scaadamyananta\"saasti.m kintu dhaarmmikaa anantaayu.sa.m bhoktu.m yaasyanti| ");
INSERT INTO sanvel_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yii\"suretaan prastaavaan samaapya \"si.syaanuuce, ");
INSERT INTO sanvel_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yu.smaabhi rj naata.m dinadvayaat para.m nistaaramaha upasthaasyati, tatra manujasuta.h kru\"sena hantu.m parakare.su samarpi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tata.h para.m pradhaanayaajakaadhyaapakapraa nca.h kiyaphaanaamno mahaayaajakasyaa.t.taalikaayaa.m militvaa ");
INSERT INTO sanvel_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kenopaayena yii\"su.m dh.rtvaa hantu.m \"saknuyuriti mantrayaa ncakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairukta.m mahakaale na dharttavya.h, dh.rte prajaanaa.m kalahena bhavitu.m \"sakyate| ");
INSERT INTO sanvel_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tato baithaniyaapure \"simonaakhyasya ku.s.thino ve\"smani yii\"sau ti.s.thati ");
INSERT INTO sanvel_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kaacana yo.saa \"svetopalabhaajanena mahaarghya.m sugandhi tailamaaniiya bhojanaayopavi\"satastasya \"sirobhya.secat| ");
INSERT INTO sanvel_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadaalokya tacchi.syai.h kupitairukta.m, kuta itthamapavyayate? ");
INSERT INTO sanvel_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","cedida.m vyakre.syata, tarhi bhuurimuulya.m praapya daridrebhyo vyataari.syata| ");
INSERT INTO sanvel_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yii\"sunaa tadavagatya te samuditaa.h, yo.saamenaa.m kuto du.hkhinii.m kurutha, saa maa.m prati saadhu karmmaakaar.siit| ");
INSERT INTO sanvel_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yu.smaakama.m samiipe daridraa.h satatamevaasate, kintu yu.smaakamantikeha.m naase satata.m| ");
INSERT INTO sanvel_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","saa mama kaayopari sugandhitaila.m siktvaa mama \"sma\"saanadaanakarmmaakaar.siit| ");
INSERT INTO sanvel_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atoha.m yu.smaan tathya.m vadaami sarvvasmin jagati yatra yatrai.sa susamaacaara.h pracaari.syate, tatra tatraitasyaa naaryyaa.h smara.naartham karmmeda.m pracaari.syate| ");
INSERT INTO sanvel_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tato dvaada\"sa\"si.syaa.naam ii.skariyotiiyayihuudaanaamaka eka.h \"si.sya.h pradhaanayaajakaanaamantika.m gatvaa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yu.smaaka.m kare.su yii\"su.m samarpayaami, tarhi ki.m daasyatha? tadaanii.m te tasmai tri.m\"sanmudraa daatu.m sthiriik.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadaarabhya ta.m parakare.su samarpayitu.m suyoga.m ce.s.titavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantara.m ki.nva\"suunyapuupaparvva.na.h prathamehni \"si.syaa yii\"sum upagatya papracchu.h bhavatk.rte kutra vaya.m nistaaramahabhojyam aayojayi.syaama.h? bhavata.h kecchaa? ");
INSERT INTO sanvel_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadaa sa gaditavaan, madhyenagaramamukapu.msa.h samiipa.m vrajitvaa vadata, guru rgaditavaan, matkaala.h savidha.h, saha \"si.syaistvadaalaye nistaaramahabhojya.m bhok.sye| ");
INSERT INTO sanvel_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadaa \"si.syaa yii\"sostaad.r\"sanide\"saanuruupakarmma vidhaaya tatra nistaaramahabhojyamaasaadayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tata.h sandhyaayaa.m satyaa.m dvaada\"sabhi.h \"si.syai.h saaka.m sa nyavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","apara.m bhu njaana uktavaan yu.smaan tathya.m vadaami, yu.smaakameko maa.m parakare.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadaa te.atiiva du.hkhitaa ekaika\"so vaktumaarebhire, he prabho, sa kimaha.m? ");
INSERT INTO sanvel_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tata.h sa jagaada, mayaa saaka.m yo jano bhojanapaatre kara.m sa.mk.sipati, sa eva maa.m parakare.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yaad.r\"sa.m likhitamaaste, tadanuruupaa tadgati rbhavi.syati; kintu yena pu.msaa sa parakare.su samarpayi.syate, haa haa cet sa naajani.syata, tadaa tasya k.semamabhavi.syat| ");
INSERT INTO sanvel_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadaa yihuudaanaamaa yo janasta.m parakare.su samarpayi.syati, sa uktavaan, he guro, sa kimaha.m? tata.h sa pratyuktavaan, tvayaa satya.m gaditam| ");
INSERT INTO sanvel_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantara.m te.saama\"sanakaale yii\"su.h puupamaadaaye\"svariiyagu.naananuudya bha.mktvaa \"si.syebhya.h pradaaya jagaada, madvapu.hsvaruupamima.m g.rhiitvaa khaadata| ");
INSERT INTO sanvel_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","pa\"scaat sa ka.msa.m g.rhlan ii\"svariiyagu.naananuudya tebhya.h pradaaya kathitavaan, sarvvai ryu.smaabhiranena paatavya.m, ");
INSERT INTO sanvel_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmaadaneke.saa.m paapamar.sa.naaya paatita.m yanmannuutnaniyamaruupa\"so.nita.m tadetat| ");
INSERT INTO sanvel_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamaha.m nuutnagostaniirasa.m na paasyaami, taavat gostaniiphalarasa.m puna.h kadaapi na paasyaami| ");
INSERT INTO sanvel_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","pa\"scaat te giitameka.m sa.mgiiya jaitunaakhyagiri.m gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadaanii.m yii\"sustaanavocat, asyaa.m rajanyaamaha.m yu.smaaka.m sarvve.saa.m vighnaruupo bhavi.syaami, yato likhitamaaste, \"me.saa.naa.m rak.sako yasta.m prahari.syaamyaha.m tata.h| me.saa.naa.m nivaho nuuna.m pravikiir.no bhavi.syati\"|| ");
INSERT INTO sanvel_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu \"sma\"saanaat samutthaaya yu.smaakamagre.aha.m gaaliila.m gami.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarasta.m provaaca, bhavaa.m\"scet sarvve.saa.m vighnaruupo bhavati, tathaapi mama na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tato yii\"sunaa sa ukta.h, tubhyamaha.m tathya.m kathayaami, yaaminyaamasyaa.m cara.naayudhasya ravaat puurvva.m tva.m maa.m tri rnaa\"ngiikari.syasi| ");
INSERT INTO sanvel_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tata.h pitara uditavaan, yadyapi tvayaa sama.m marttavya.m, tathaapi kadaapi tvaa.m na naa\"ngiikari.syaami; tathaiva sarvve \"si.syaa\"scocu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantara.m yii\"su.h \"si.syai.h saaka.m get\"simaaniinaamaka.m sthaana.m prasthaaya tebhya.h kathitavaan, ada.h sthaana.m gatvaa yaavadaha.m praarthayi.sye taavad yuuyamatropavi\"sata| ");
INSERT INTO sanvel_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","pa\"scaat sa pitara.m sivadiyasutau ca sa\"ngina.h k.rtvaa gatavaan, \"sokaakulo.atiiva vyathita\"sca babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","taanavaadiicca m.rtiyaataneva matpraa.naanaa.m yaatanaa jaayate, yuuyamatra mayaa saarddha.m jaag.rta| ");
INSERT INTO sanvel_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tata.h sa ki ncidduura.m gatvaadhomukha.h patan praarthayaa ncakre, he matpitaryadi bhavitu.m \"saknoti, tarhi ka.mso.aya.m matto duura.m yaatu; kintu madicchaavat na bhavatu, tvadicchaavad bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tata.h sa \"si.syaanupetya taan nidrato niriik.sya pitaraaya kathayaamaasa, yuuya.m mayaa saaka.m da.n.damekamapi jaagaritu.m naa\"sankuta? ");
INSERT INTO sanvel_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","pariik.saayaa.m na patitu.m jaag.rta praarthayadhva nca; aatmaa samudyatosti, kintu vapu rdurbbala.m| ");
INSERT INTO sanvel_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitiiyavaara.m praarthayaa ncakre, he mattaata, na piite yadi ka.msamida.m matto duura.m yaatu.m na \"saknoti, tarhi tvadicchaavad bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punaretya taan nidrato dadar\"sa, yataste.saa.m netraa.ni nidrayaa puur.naanyaasan| ");
INSERT INTO sanvel_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","pa\"scaat sa taan vihaaya vrajitvaa t.rtiiyavaara.m puurvvavat kathayan praarthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tata.h \"si.syaanupaagatya gaditavaan, saamprata.m \"sayaanaa.h ki.m vi\"sraamyatha? pa\"syata, samaya upaasthaat, manujasuta.h paapinaa.m kare.su samarpyate| ");
INSERT INTO sanvel_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","utti.s.thata, vaya.m yaama.h, yo maa.m parakare.su masarpayi.syati, pa\"syata, sa samiipamaayaati| ");
INSERT INTO sanvel_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","etatkathaakathanakaale dvaada\"sa\"si.syaa.naameko yihuudaanaamako mukhyayaajakalokapraaciinai.h prahitaan asidhaariya.s.tidhaari.no manujaan g.rhiitvaa tatsamiipamupatasthau| ");
INSERT INTO sanvel_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakare.svarpayitaa puurvva.m taan ittha.m sa\"nketayaamaasa, yamaha.m cumbi.sye, so.asau manuja.h,saeva yu.smaabhi rdhaaryyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadaa sa sapadi yii\"sumupaagatya he guro, pra.namaamiityuktvaa ta.m cucumbe| ");
INSERT INTO sanvel_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadaa yii\"sustamuvaaca, he mitra.m kimarthamaagatosi? tadaa tairaagatya yii\"suraakramya daghre| ");
INSERT INTO sanvel_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tato yii\"so.h sa\"nginaameka.h kara.m prasaaryya ko.saadasi.m bahi.sk.rtya mahaayaajakasya daasamekamaahatya tasya kar.na.m ciccheda| ");
INSERT INTO sanvel_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tato yii\"susta.m jagaada, kha.dga.m svasthaaneे nidhehi yato ye ye janaa asi.m dhaarayanti, taevaasinaa vina\"syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","apara.m pitaa yathaa madantika.m svargiiyaduutaanaa.m dvaada\"savaahiniito.adhika.m prahi.nuyaat mayaa tamuddi\"syedaaniimeva tathaa praarthayitu.m na \"sakyate, tvayaa kimittha.m j naayate? ");
INSERT INTO sanvel_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathaa satiittha.m gha.ti.syate dharmmapustakasya yadida.m vaakya.m tat katha.m sidhyet? ");
INSERT INTO sanvel_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadaanii.m yii\"su rjananivaha.m jagaada, yuuya.m kha.dgaya.s.tiin aadaaya maa.m ki.m caura.m dharttumaayaataa.h? aha.m pratyaha.m yu.smaabhi.h saakamupavi\"sya samupaadi\"sa.m, tadaa maa.m naadharata; ");
INSERT INTO sanvel_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhavi.syadvaadinaa.m vaakyaanaa.m sa.msiddhaye sarvvametadabhuut|tadaa sarvve \"si.syaasta.m vihaaya palaayanta| ");
INSERT INTO sanvel_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantara.m te manujaa yii\"su.m dh.rtvaa yatraadhyaapakapraa nca.h pari.sada.m kurvvanta upaavi\"san tatra kiyaphaanaaाmakamahaayaajakasyaantika.m ninyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu \"se.se ki.m bhavi.syatiiti vettu.m pitaro duure tatpa\"scaad vrajitvaa mahaayaajakasyaa.t.taalikaa.m pravi\"sya daasai.h sahita upaavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadaanii.m pradhaanayaajakapraaciinamantri.na.h sarvve yii\"su.m hantu.m m.r.saasaak.syam alipsanta, ");
INSERT INTO sanvel_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lebhire| aneke.su m.r.saasaak.si.svaagate.svapi tanna praapu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","\"se.se dvau m.r.saasaak.si.naavaagatya jagadatu.h, pumaanayamakathayat, ahamii\"svaramandira.m bha.mktvaa dinatrayamadhye tannirmmaatu.m \"saknomi| ");
INSERT INTO sanvel_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadaa mahaayaajaka utthaaya yii\"sum avaadiit| tva.m kimapi na prativadasi? tvaamadhi kimete saak.sya.m vadanti? ");
INSERT INTO sanvel_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yii\"su rmauniibhuuya tasyau| tato mahaayaajaka uktavaan, tvaam amare\"svaranaamnaa \"sapayaami, tvamii\"svarasya putro.abhi.sikto bhavasi naveti vada| ");
INSERT INTO sanvel_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yii\"su.h pratyavadat, tva.m satyamuktavaan; aha.m yu.smaan tathya.m vadaami, ita.hpara.m manujasuta.m sarvva\"saktimato dak.si.napaar\"sve sthaatu.m gaga.nastha.m jaladharaanaaruhyaayaanta.m viik.sadhve| ");
INSERT INTO sanvel_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadaa mahaayaajako nijavasana.m chittvaa jagaada, e.sa ii\"svara.m ninditavaan, asmaakamaparasaak.sye.na ki.m prayojana.m? pa\"syata, yuuyamevaasyaasyaad ii\"svaranindaa.m \"srutavanta.h, ");
INSERT INTO sanvel_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yu.smaabhi.h ki.m vivicyate? te pratyuucu.h, vadhaarho.aya.m| ");
INSERT INTO sanvel_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tato lokaistadaasye ni.s.thiivita.m kecit pratalamaahatya kecicca cape.tamaahatya babhaa.sire, ");
INSERT INTO sanvel_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","he khrii.s.ta tvaa.m ka\"scape.tamaahatavaan? iti ga.nayitvaa vadaasmaan| ");
INSERT INTO sanvel_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitaro bahira\"ngana upavi\"sati, tadaaniimekaa daasii tamupaagatya babhaa.se, tva.m gaaliiliiyayii\"so.h sahacaraeka.h| ");
INSERT INTO sanvel_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvve.saa.m samak.sam ana\"ngiik.rtyaavaadiit, tvayaa yaducyate, tadarthamaha.m na vedmi| ");
INSERT INTO sanvel_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadaa tasmin bahirdvaara.m gate .anyaa daasii ta.m niriik.sya tatratyajanaanavadat, ayamapi naasaratiiyayii\"sunaa saarddham aasiit| ");
INSERT INTO sanvel_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tata.h sa \"sapathena punarana\"ngiik.rtya kathitavaan, ta.m nara.m na paricinomi| ");
INSERT INTO sanvel_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","k.sa.naat para.m ti.s.thanto janaa etya pitaram avadan, tvamava\"sya.m te.saameka iti tvaduccaara.nameva dyotayati| ");
INSERT INTO sanvel_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu so.abhi\"sapya kathitavaan, ta.m jana.m naaha.m paricinomi, tadaa sapadi kukku.to ruraava| ");
INSERT INTO sanvel_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukku.taravaat praak tva.m maa.m trirapaahno.syase, yai.saa vaag yii\"sunaavaadi taa.m pitara.h sa.msm.rtya bahiritvaa khedaad bh.r\"sa.m cakranda| ");
INSERT INTO sanvel_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhaate jaate pradhaanayaajakalokapraaciinaa yii\"su.m hantu.m tatpratikuula.m mantrayitvaa ");
INSERT INTO sanvel_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ta.m badvvaa niitvaa pantiiyapiilaataakhyaadhipe samarpayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tato yii\"so.h parakarevvarpayitaa yihuudaastatpraa.naada.n.daaj naa.m viditvaa santaptamanaa.h pradhaanayaajakalokapraaciinaanaa.m samak.sa.m taastrii.m\"sanmudraa.h pratidaayaavaadiit, ");
INSERT INTO sanvel_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","etanniraagonarapraa.naparakaraarpa.naat kalu.sa.m k.rtavaanaha.m| tadaa ta uditavanta.h, tenaasmaaka.m ki.m? tvayaa tad budhyataam| ");
INSERT INTO sanvel_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tato yihuudaa mandiramadhye taa mudraa nik.sipya prasthitavaan itvaa ca svayamaatmaanamudbabandha| ");
INSERT INTO sanvel_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","pa\"scaat pradhaanayaajakaastaa mudraa aadaaya kathitavanta.h, etaa mudraa.h \"so.nitamuulya.m tasmaad bhaa.n.daagaare na nidhaatavyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantara.m te mantrayitvaa vide\"sinaa.m \"sma\"saanasthaanaaya taabhi.h kulaalasya k.setramakrii.nan| ");
INSERT INTO sanvel_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ato.adyaapi tatsthaana.m raktak.setra.m vadanti| ");
INSERT INTO sanvel_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ittha.m sati israayeliiyasantaanai ryasya muulya.m nirupita.m, tasya tri.m\"sanmudraamaana.m muulya.m ");
INSERT INTO sanvel_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","maa.m prati parame\"svarasyaade\"saat tebhya aadiiyata, tena ca kulaalasya k.setra.m kriitamiti yadvacana.m yirimiyabhavi.syadvaadinaa prokta.m tat tadaasidhyat| ");
INSERT INTO sanvel_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantara.m yii\"sau tadadhipate.h sammukha upati.s.thati sa ta.m papraccha, tva.m ki.m yihuudiiyaanaa.m raajaa? tadaa yii\"sustamavadat, tva.m satyamuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhaanayaajakapraaciinairabhiyuktena tena kimapi na pratyavaadi| ");
INSERT INTO sanvel_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tata.h piilaatena sa udita.h, ime tvatpratikuulata.h kati kati saak.sya.m dadati, tat tva.m na \"s.r.no.si? ");
INSERT INTO sanvel_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathaapi sa te.saamekasyaapi vacasa uttara.m noditavaan; tena so.adhipati rmahaacitra.m vidaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyacca tanmahakaale.adhipateretaad.r\"sii raatiraasiit, prajaa ya.m ka ncana bandhina.m yaacante, tameva sa mocayatiiti| ");
INSERT INTO sanvel_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadaanii.m barabbaanaamaa ka\"scit khyaatabandhyaasiit| ");
INSERT INTO sanvel_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tata.h piilaatastatra militaan lokaan ap.rcchat, e.sa barabbaa bandhii khrii.s.tavikhyaato yii\"su\"scaitayo.h ka.m mocayi.syaami? yu.smaaka.m kimiipsita.m? ");
INSERT INTO sanvel_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairiir.syayaa sa samarpita iti sa j naatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","apara.m vicaaraasanopave\"sanakaale piilaatasya patnii bh.rtya.m prahitya tasmai kathayaamaasa, ta.m dhaarmmikamanuja.m prati tvayaa kimapi na karttavya.m; yasmaat tatk.rte.adyaaha.m svapne prabhuutaka.s.tamalabhe| ");
INSERT INTO sanvel_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantara.m pradhaanayaajakapraaciinaa barabbaa.m yaacitvaadaatu.m yii\"su nca hantu.m sakalalokaan praavarttayan| ");
INSERT INTO sanvel_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tato.adhipatistaan p.r.s.tavaan, etayo.h kamaha.m mocayi.syaami? yu.smaaka.m kecchaa? te procu rbarabbaa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadaa piilaata.h papraccha, tarhi ya.m khrii.s.ta.m vadanti, ta.m yii\"su.m ki.m kari.syaami? sarvve kathayaamaasu.h, sa kru\"sena vidhyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tato.adhipatiravaadiit, kuta.h? ki.m tenaaparaaddha.m? kintu te punarucai rjagadu.h, sa kru\"sena vidhyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadaa nijavaakyamagraahyamabhuut, kalaha\"scaapyabhuut, piilaata iti vilokya lokaanaa.m samak.sa.m toyamaadaaya karau prak.saalyaavocat, etasya dhaarmmikamanu.syasya \"so.nitapaate nirdo.so.aha.m, yu.smaabhireva tad budhyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadaa sarvvaa.h prajaa.h pratyavocan, tasya \"so.nitapaataaparaadho.asmaakam asmatsantaanaanaa ncopari bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tata.h sa te.saa.m samiipe barabbaa.m mocayaamaasa yii\"suntu ka.saabhiraahatya kru\"sena vedhitu.m samarpayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipate.h senaa adhipate rg.rha.m yii\"sumaaniiya tasya samiipe senaasamuuha.m sa.mjag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tataste tasya vasana.m mocayitvaa k.r.s.nalohitavar.navasana.m paridhaapayaamaasu.h ");
INSERT INTO sanvel_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ka.n.takaanaa.m muku.ta.m nirmmaaya tacchirasi dadu.h, tasya dak.si.nakare vetrameka.m dattvaa tasya sammukhe jaanuuni paatayitvaa, he yihuudiiyaanaa.m raajan, tubhya.m nama ityuktvaa ta.m tira\"scakru.h, ");
INSERT INTO sanvel_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gaatre ni.s.thiiva.m datvaa tena vetre.na \"sira aajaghnu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ittha.m ta.m tirask.rtya tad vasana.m mocayitvaa punarnijavasana.m paridhaapayaa ncakru.h, ta.m kru\"sena vedhitu.m niitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","pa\"scaatte bahirbhuuya kurii.niiya.m \"simonnaamakameka.m vilokya kru\"sa.m vo.dhu.m tamaadadire| ");
INSERT INTO sanvel_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantara.m gulgaltaam arthaat \"siraskapaalanaamakasthaanamu pasthaaya te yii\"save pittami\"sritaamlarasa.m paatu.m dadu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamaasvaadya na papau| ");
INSERT INTO sanvel_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadaanii.m te ta.m kru\"sena sa.mvidhya tasya vasanaani gu.tikaapaatena vibhajya jag.rhu.h, tasmaat, vibhajante.adhariiya.m me te manu.syaa.h paraspara.m| maduttariiyavastraartha.m gu.tikaa.m paatayanti ca||yadetadvacana.m bhavi.syadvaadibhiruktamaasiit, tadaa tad asidhyat, ");
INSERT INTO sanvel_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","pa\"scaat te tatropavi\"sya tadrak.sa.nakarvva.ni niyuktaastasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam e.sa yihuudiiyaanaa.m raajaa yii\"surityapavaadalipipatra.m tacchirasa uurdvve yojayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vaame dak.si.ne ca dvau cairau tena saaka.m kru\"sena vividhu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadaa paanthaa nija\"siro laa.dayitvaa ta.m nindanto jagadu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","he ii\"svaramandirabha njaka dinatraye tannirmmaata.h sva.m rak.sa, cettvamii\"svarasutastarhi kru\"saadavaroha| ");
INSERT INTO sanvel_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhaanayaajakaadhyaapakapraaciinaa\"sca tathaa tirask.rtya jagadu.h, ");
INSERT INTO sanvel_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","so.anyajanaanaavat, kintu svamavitu.m na \"saknoti| yadiisraayelo raajaa bhavet, tarhiidaaniimeva kru\"saadavarohatu, tena ta.m vaya.m pratye.syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa ii\"svare pratyaa\"saamakarot, yadii\"svarastasmin santu.s.tastarhiidaaniimeva tamavet, yata.h sa uktavaan ahamii\"svarasuta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stenau saaka.m tena kru\"sena viddhau tau tadvadeva ta.m ninindatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadaa dvitiiyayaamaat t.rtiiyayaama.m yaavat sarvvade\"se tamira.m babhuuva, ");
INSERT INTO sanvel_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","t.rtiiyayaame \"elii elii laamaa \"sivaktanii\", arthaat madii\"svara madii\"svara kuto maamatyaak.sii.h? yii\"suruccairiti jagaada| ");
INSERT INTO sanvel_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadaa tatra sthitaa.h kecit tat \"srutvaa babhaa.sire, ayam eliyamaahuuyati| ");
INSERT INTO sanvel_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","te.saa.m madhyaad eka.h \"siighra.m gatvaa spa nja.m g.rhiitvaa tatraamlarasa.m dattvaa nalena paatu.m tasmai dadau| ");
INSERT INTO sanvel_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itare.akathayan ti.s.thata, ta.m rak.situm eliya aayaati naveti pa\"syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yii\"su.h punarucairaahuuya praa.naan jahau| ");
INSERT INTO sanvel_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tato mandirasya vicchedavasanam uurdvvaadadho yaavat chidyamaana.m dvidhaabhavat, ");
INSERT INTO sanvel_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhuumi\"scakampe bhuudharovyadiiryyata ca| \"sma\"saane mukte bhuuripu.nyavataa.m suptadehaa udati.s.than, ");
INSERT INTO sanvel_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","\"sma\"saanaad vahirbhuuya tadutthaanaat para.m pu.nyapura.m gatvaa bahujanaan dar\"sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yii\"surak.sa.naaya niyukta.h \"satasenaapatistatsa\"ngina\"sca taad.r\"sii.m bhuukampaadigha.tanaa.m d.r.s.tvaa bhiitaa avadan, e.sa ii\"svaraputro bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yaa bahuyo.sito yii\"su.m sevamaanaa gaaliilastatpa\"scaadaagataastaasaa.m madhye ");
INSERT INTO sanvel_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdaliinii mariyam yaakuubyo\"syo rmaataa yaa mariyam sibadiyaputrayo rmaataa ca yo.sita etaa duure ti.s.thantyo dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyaayaa.m satyam arimathiyaanagarasya yuu.saphnaamaa dhanii manujo yii\"so.h \"si.syatvaat ");
INSERT INTO sanvel_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","piilaatasya samiipa.m gatvaa yii\"so.h kaaya.m yayaace, tena piilaata.h kaaya.m daatum aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yuu.saph tatkaaya.m niitvaa \"sucivastre.naacchaadya ");
INSERT INTO sanvel_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svaartha.m \"saile yat \"sma\"saana.m cakhaana, tanmadhye tatkaaya.m nidhaaya tasya dvaari v.rhatpaa.saa.na.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdaliinii mariyam anyamariyam ete striyau tatra \"sma\"saanasammukha upavivi\"satu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantara.m nistaarotsavasyaayojanadinaat pare.ahani pradhaanayaajakaa.h phiruu\"sina\"sca militvaa piilaatamupaagatyaakathayan, ");
INSERT INTO sanvel_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","he maheccha sa prataarako jiivana akathayat, dinatrayaat para.m \"sma\"saanaadutthaasyaami tadvaakya.m smaraamo vaya.m; ");
INSERT INTO sanvel_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmaat t.rtiiyadina.m yaavat tat \"sma\"saana.m rak.situmaadi\"satu, nocet tacchi.syaa yaaminyaamaagatya ta.m h.rtvaa lokaan vadi.syanti, sa \"sma\"saanaadudati.s.that, tathaa sati prathamabhraante.h \"se.siiyabhraanti rmahatii bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadaa piilaata avaadiit, yu.smaaka.m samiipe rak.siga.na aaste, yuuya.m gatvaa yathaa saadhya.m rak.sayata| ");
INSERT INTO sanvel_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tataste gatvaa tadduuाrapaa.saa.na.m mudraa\"nkita.m k.rtvaa rak.siga.na.m niyojya \"sma\"saana.m rak.sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tata.h para.m vi\"sraamavaarasya \"se.se saptaahaprathamadinasya prabhote jaate magdaliinii mariyam anyamariyam ca \"sma\"saana.m dra.s.tumaagataa| ");
INSERT INTO sanvel_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadaa mahaan bhuukampo.abhavat; parame\"svariiyaduuta.h svargaadavaruhya \"sma\"saanadvaaraat paa.saa.namapasaaryya taduparyyupavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadana.m vidyudvat tejomaya.m vasana.m hima\"subhra nca| ");
INSERT INTO sanvel_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadaanii.m rak.si.nastadbhayaat kampitaa m.rtavad babhuuva.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa duuto yo.sito jagaada, yuuya.m maa bhai.s.ta, kru\"sahatayii\"su.m m.rgayadhve tadaha.m vedmi| ");
INSERT INTO sanvel_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","so.atra naasti, yathaavadat tathotthitavaan; etat prabho.h \"sayanasthaana.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tuur.na.m gatvaa tacchi.syaan iti vadata, sa \"sma\"saanaad udati.s.that, yu.smaakamagre gaaliila.m yaasyati yuuya.m tatra ta.m viik.si.syadhve, pa\"syataaha.m vaarttaamimaa.m yu.smaanavaadi.sa.m| ");
INSERT INTO sanvel_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastaa bhayaat mahaanandaa nca \"sma\"saanaat tuur.na.m bahirbhuuya tacchi.syaan vaarttaa.m vaktu.m dhaavitavatya.h| kintu \"si.syaan vaarttaa.m vaktu.m yaanti, tadaa yii\"su rdar\"sana.m dattvaa taa jagaada, ");
INSERT INTO sanvel_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yu.smaaka.m kalyaa.na.m bhuuyaat, tatastaa aagatya tatpaadayo.h patitvaa pra.nemu.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yii\"sustaa avaadiit, maa bibhiita, yuuya.m gatvaa mama bhraat.rn gaaliila.m yaatu.m vadata, tatra te maa.m drak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyo gacchanti, tadaa rak.si.naa.m kecit pura.m gatvaa yadyad gha.tita.m tatsarvva.m pradhaanayaajakaan j naapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","te praaciinai.h sama.m sa.msada.m k.rtvaa mantrayanto bahumudraa.h senaabhyo dattvaavadan, ");
INSERT INTO sanvel_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmaasu nidrite.su tacchi.syaa yaaminyaamaagatya ta.m h.rtvaanayan, iti yuuya.m pracaarayata| ");
INSERT INTO sanvel_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyetadadhipate.h \"srotragocariibhavet, tarhi ta.m bodhayitvaa yu.smaanavi.syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tataste mudraa g.rhiitvaa \"sik.saanuruupa.m karmma cakru.h, yihuudiiyaanaa.m madhye tasyaadyaapi ki.mvadantii vidyate| ");
INSERT INTO sanvel_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ekaada\"sa \"si.syaa yii\"suniruupitaagaaliilasyaadri.m gatvaa ");
INSERT INTO sanvel_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra ta.m sa.mviik.sya pra.nemu.h, kintu kecit sandigdhavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yii\"suste.saa.m samiipamaagatya vyaah.rtavaan, svargamedinyo.h sarvvaadhipatitvabhaaro mayyarpita aaste| ");
INSERT INTO sanvel_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ato yuuya.m prayaaya sarvvade\"siiyaan \"si.syaan k.rtvaa pitu.h putrasya pavitrasyaatmana\"sca naamnaa taanavagaahayata; aha.m yu.smaan yadyadaadi\"sa.m tadapi paalayitu.m taanupaadi\"sata| ");
INSERT INTO sanvel_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","pa\"syata, jagadanta.m yaavat sadaaha.m yu.smaabhi.h saaka.m ti.s.thaami| iti|");
INSERT INTO sanvel_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ii\"svaraputrasya yii\"sukhrii.s.tasya susa.mvaadaarambha.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhavi.syadvaadinaa.m granthe.su lipiritthamaaste, pa\"sya svakiiyaduutantu tavaagre pre.sayaamyaham| gatvaa tvadiiyapanthaana.m sa hi pari.skari.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"parame\"sasya panthaana.m pari.skuruta sarvvata.h| tasya raajapatha ncaiva samaana.m kurutaadhunaa|\" ityetat praantare vaakya.m vadata.h kasyacidrava.h|| ");
INSERT INTO sanvel_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saeva yohan praantare majjitavaan tathaa paapamaarjananimitta.m manovyaavarttakamajjanasya kathaa nca pracaaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tato yihuudaade\"sayiruu\"saalamnagaranivaasina.h sarvve lokaa bahi rbhuutvaa tasya samiipamaagatya svaani svaani paapaanya\"ngiik.rtya yarddananadyaa.m tena majjitaa babhuuvu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yohana.h paridheyaani kramelakalomajaani, tasya ka.tibandhana.m carmmajaatam, tasya bhak.syaa.ni ca \"suukakii.taa vanyamadhuuni caasan| ");
INSERT INTO sanvel_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa pracaarayan kathayaa ncakre, aha.m namriibhuuya yasya paadukaabandhana.m mocayitumapi na yogyosmi, taad.r\"so matto gurutara eka.h puru.so matpa\"scaadaagacchati| ");
INSERT INTO sanvel_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","aha.m yu.smaan jale majjitavaan kintu sa pavitra aatmaani sa.mmajjayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","apara nca tasminneva kaale gaaliilprade\"sasya naasaradgraamaad yii\"suraagatya yohanaa yarddananadyaa.m majjito.abhuut| ");
INSERT INTO sanvel_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalaadutthitamaatro meghadvaara.m mukta.m kapotavat svasyopari avarohantamaatmaana nca d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tva.m mama priya.h putrastvayyeva mamamahaasanto.sa iyamaakaa\"siiyaa vaa.nii babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kaale aatmaa ta.m praantaramadhya.m ninaaya| ");
INSERT INTO sanvel_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa catvaari.m\"saddinaani tasmin sthaane vanyapa\"subhi.h saha ti.s.than \"saitaanaa pariik.sita.h; pa\"scaat svargiiyaduutaasta.m si.sevire| ");
INSERT INTO sanvel_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantara.m yohani bandhanaalaye baddhe sati yii\"su rgaaliilprade\"samaagatya ii\"svararaajyasya susa.mvaada.m pracaarayan kathayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kaala.h sampuur.na ii\"svararaajya nca samiipamaagata.m; atoheto ryuuya.m manaa.msi vyaavarttayadhva.m susa.mvaade ca vi\"svaasita| ");
INSERT INTO sanvel_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantara.m sa gaaliiliiyasamudrasya tiire gacchan \"simon tasya bhraataa andriyanaamaa ca imau dvau janau matsyadhaari.nau saagaramadhye jaala.m prak.sipantau d.r.s.tvaa taavavadat, ");
INSERT INTO sanvel_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvaa.m mama pa\"scaadaagacchata.m, yuvaamaha.m manu.syadhaari.nau kari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatk.sa.nameva jaalaani parityajya tasya pa\"scaat jagmatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tata.h para.m tatsthaanaat ki ncid duura.m gatvaa sa sivadiiputrayaakuub tadbhraat.ryohan ca imau naukaayaa.m jaalaanaa.m jiir.namuddhaarayantau d.r.s.tvaa taavaahuuyat| ");
INSERT INTO sanvel_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukaayaa.m vetanabhugbhi.h sahita.m svapitara.m vihaaya tatpa\"scaadiiyatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tata.h para.m kapharnaahuumnaamaka.m nagaramupasthaaya sa vi\"sraamadivase bhajanagraha.m pravi\"sya samupadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyopade\"saallokaa aa\"scaryya.m menire yata.h sodhyaapakaaiva nopadi\"san prabhaavavaaniva propadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","apara nca tasmin bhajanag.rhe apavitrabhuutena grasta eko maanu.sa aasiit| sa ciit\"sabda.m k.rtvaa kathayaa ncake ");
INSERT INTO sanvel_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bho naasaratiiya yii\"so tvamasmaan tyaja, tvayaa sahaasmaaka.m ka.h sambandha.h? tva.m kimasmaan naa\"sayitu.m samaagata.h? tvamii\"svarasya pavitraloka ityaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadaa yii\"susta.m tarjayitvaa jagaada tuu.s.nii.m bhava ito bahirbhava ca| ");
INSERT INTO sanvel_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tata.h so.apavitrabhuutasta.m sampii.dya atyucai\"sciitk.rtya nirjagaama| ");
INSERT INTO sanvel_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tenaiva sarvve camatk.rtya paraspara.m kathayaa ncakrire, aho kimida.m? kiid.r\"so.aya.m navya upade\"sa.h? anena prabhaavenaapavitrabhuute.svaaj naapite.su te tadaaj naanuvarttino bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadaa tasya ya\"so gaaliila\"scaturdiksthasarvvade\"saan vyaapnot| ");
INSERT INTO sanvel_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","apara nca te bhajanag.rhaad bahi rbhuutvaa yaakuubyohanbhyaa.m saha \"simona aandriyasya ca nive\"sana.m pravivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadaa pitarasya \"sva\"sruurjvarapii.ditaa \"sayyaayaamaasta iti te ta.m jha.titi vij naapayaa ncakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tata.h sa aagatya tasyaa hasta.m dh.rtvaa taamudasthaapayat; tadaiva taa.m jvaro.atyaak.siit tata.h para.m saa taan si.seve| ");
INSERT INTO sanvel_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athaasta.m gate ravau sandhyaakaale sati lokaastatsamiipa.m sarvvaan rogi.no bhuutadh.rtaa.m\"sca samaaninyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvve naagarikaa lokaa dvaari sa.mmilitaa\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tata.h sa naanaavidharogi.no bahuun manujaanarogi.na\"scakaara tathaa bahuun bhuutaan tyaajayaa ncakaara taan bhuutaan kimapi vaakya.m vaktu.m ni.si.sedha ca yatohetoste tamajaanan| ");
INSERT INTO sanvel_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","apara nca so.atipratyuu.se vastutastu raatri\"se.se samutthaaya bahirbhuuya nirjana.m sthaana.m gatvaa tatra praarthayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantara.m \"simon tatsa\"ngina\"sca tasya pa\"scaad gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tadudde\"sa.m praapya tamavadan sarvve lokaastvaa.m m.rgayante| ");
INSERT INTO sanvel_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadaa so.akathayat aagacchata vaya.m samiipasthaani nagaraa.ni yaama.h, yato.aha.m tatra kathaa.m pracaarayitu.m bahiraagamam| ");
INSERT INTO sanvel_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa te.saa.m gaaliilprade\"sasya sarvve.su bhajanag.rhe.su kathaa.h pracaarayaa ncakre bhuutaanatyaajaya nca| ");
INSERT INTO sanvel_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantarameka.h ku.s.thii samaagatya tatsammukhe jaanupaata.m vinaya nca k.rtvaa kathitavaan yadi bhavaan icchati tarhi maa.m pari.skarttu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tata.h k.rpaalu ryii\"su.h karau prasaaryya ta.m spa.s.tvaa kathayaamaasa ");
INSERT INTO sanvel_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamecchaa vidyate tva.m pari.sk.rto bhava| etatkathaayaa.h kathanamaatraat sa ku.s.thii rogaanmukta.h pari.sk.rto.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadaa sa ta.m vis.rjan gaa.dhamaadi\"sya jagaada ");
INSERT INTO sanvel_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","saavadhaano bhava kathaamimaa.m kamapi maa vada; svaatmaana.m yaajaka.m dar\"saya, lokebhya.h svapari.sk.rte.h pramaa.nadaanaaya muusaanir.niita.m yaddaana.m taduts.rjasva ca| ");
INSERT INTO sanvel_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvaa tat karmma ittha.m vistaaryya pracaarayitu.m praarebhe tenaiva yii\"su.h puna.h saprakaa\"sa.m nagara.m prave.s.tu.m naa\"saknot tatohetorbahi.h kaananasthaane tasyau; tathaapi caturddigbhyo lokaastasya samiipamaayayu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantara.m yii\"sai katipayadinaani vilambya puna.h kapharnaahuumnagara.m pravi.s.te sa g.rha aasta iti ki.mvadantyaa tatk.sa.na.m tatsamiipa.m bahavo lokaa aagatya samupatasthu.h, ");
INSERT INTO sanvel_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmaad g.rhamadhye sarvve.saa.m k.rte sthaana.m naabhavad dvaarasya caturdik.svapi naabhavat, tatkaale sa taan prati kathaa.m pracaarayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tata.h para.m lokaa\"scaturbhi rmaanavaireka.m pak.saaghaatina.m vaahayitvaa tatsamiipam aaninyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janaanaa.m bahutvaat ta.m yii\"so.h sammukhamaanetu.m na \"saknuvanto yasmin sthaane sa aaste taduparig.rhap.r.s.tha.m khanitvaa chidra.m k.rtvaa tena maarge.na sa\"sayya.m pak.saaghaatinam avarohayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tato yii\"suste.saa.m vi\"svaasa.m d.r.s.tvaa ta.m pak.saaghaatina.m babhaa.se he vatsa tava paapaanaa.m maarjana.m bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadaa kiyanto.adhyaapakaastatropavi\"santo manobhi rvitarkayaa ncakru.h, e.sa manu.sya etaad.r\"siimii\"svaranindaa.m kathaa.m kuta.h kathayati? ");
INSERT INTO sanvel_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ii\"svara.m vinaa paapaani maar.s.tu.m kasya saamarthyam aaste? ");
INSERT INTO sanvel_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ittha.m te vitarkayanti yii\"sustatk.sa.na.m manasaa tad budvvaa taanavadad yuuyamanta.hkara.nai.h kuta etaani vitarkayatha? ");
INSERT INTO sanvel_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantara.m yii\"sustatsthaanaat puna.h samudrata.ta.m yayau; lokanivahe tatsamiipamaagate sa taan samupadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu p.rthivyaa.m paapaani maar.s.tu.m manu.syaputrasya saamarthyamasti, etad yu.smaan j naapayitu.m (sa tasmai pak.saaghaatine kathayaamaasa) ");
INSERT INTO sanvel_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","utti.s.tha tava \"sayyaa.m g.rhiitvaa svag.rha.m yaahi, aha.m tvaamidam aaj naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tata.h sa tatk.sa.nam utthaaya \"sayyaa.m g.rhiitvaa sarvve.saa.m saak.saat jagaama; sarvve vismitaa etaad.r\"sa.m karmma vayam kadaapi naapa\"syaama, imaa.m kathaa.m kathayitve\"svara.m dhanyamabruvan| ");
INSERT INTO sanvel_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantara.m yii\"sustatsthaanaat puna.h samudrata.ta.m yayau; lokanivahe tatsamiipamaagate sa taan samupadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gacchan karasa ncayag.rha upavi.s.tam aalphiiyaputra.m levi.m d.r.s.tvaa tamaahuuya kathitavaan matpa\"scaat tvaamaamaccha tata.h sa utthaaya tatpa\"scaad yayau| ");
INSERT INTO sanvel_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantara.m yii\"sau tasya g.rhe bhoktum upavi.s.te bahava.h karama ncaayina.h paapina\"sca tena tacchi.syai\"sca sahopavivi\"su.h, yato bahavastatpa\"scaadaajagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadaa sa karama ncaayibhi.h paapibhi\"sca saha khaadati, tad d.r.s.tvaadhyaapakaa.h phiruu\"sina\"sca tasya \"si.syaanuucu.h karama ncaayibhi.h paapibhi\"sca sahaaya.m kuto bhu.mkte pivati ca? ");
INSERT INTO sanvel_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvaakya.m \"srutvaa yii\"su.h pratyuvaaca,arogilokaanaa.m cikitsakena prayojana.m naasti, kintu rogi.naameva; aha.m dhaarmmikaanaahvaatu.m naagata.h kintu mano vyaavarttayitu.m paapina eva| ");
INSERT INTO sanvel_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tata.h para.m yohana.h phiruu\"sinaa ncopavaasaacaari\"si.syaa yii\"so.h samiipam aagatya kathayaamaasu.h, yohana.h phiruu\"sinaa nca \"si.syaa upavasanti kintu bhavata.h \"si.syaa nopavasanti ki.m kaara.namasya? ");
INSERT INTO sanvel_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadaa yii\"sustaan babhaa.se yaavat kaala.m sakhibhi.h saha kanyaayaa varasti.s.thati taavatkaala.m te kimupavastu.m \"saknuvanti? yaavatkaala.m varastai.h saha ti.s.thati taavatkaala.m ta upavastu.m na \"saknuvanti| ");
INSERT INTO sanvel_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kaale tebhya.h sakaa\"saad varo ne.syate sa kaala aagacchati, tasmin kaale te janaa upavatsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kopi jana.h puraatanavastre nuutanavastra.m na siivyati, yato nuutanavastre.na saha sevane k.rte jiir.na.m vastra.m chidyate tasmaat puna rmahat chidra.m jaayate| ");
INSERT INTO sanvel_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kopi jana.h puraatanakutuu.su nuutana.m draak.saarasa.m na sthaapayati, yato nuutanadraak.saarasasya tejasaa taa.h kutvo vidiiryyante tato draak.saarasa\"sca patati kutva\"sca na\"syanti, ataeva nuutanadraak.saaraso nuutanakutuu.su sthaapaniiya.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantara.m yii\"su ryadaa vi\"sraamavaare \"sasyak.setre.na gacchati tadaa tasya \"si.syaa gacchanta.h \"sasyama njarii\"schettu.m prav.rttaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ata.h phiruu\"sino yii\"save kathayaamaasu.h pa\"syatu vi\"sraamavaasare yat karmma na karttavya.m tad ime kuta.h kurvvanti? ");
INSERT INTO sanvel_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadaa sa tebhyo.akathayat daayuud tatsa.m\"ngina\"sca bhak.syaabhaavaat k.sudhitaa.h santo yat karmma k.rtavantastat ki.m yu.smaabhi rna pa.thitam? ");
INSERT INTO sanvel_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyaatharnaamake mahaayaajakataa.m kurvvati sa kathamii\"svarasyaavaasa.m pravi\"sya ye dar\"saniiyapuupaa yaajakaan vinaanyasya kasyaapi na bhak.syaastaaneva bubhuje sa\"ngilokebhyo.api dadau| ");
INSERT INTO sanvel_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","so.aparamapi jagaada, vi\"sraamavaaro manu.syaarthameva niruupito.asti kintu manu.syo vi\"sraamavaaraartha.m naiva| ");
INSERT INTO sanvel_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manu.syaputro vi\"sraamavaarasyaapi prabhuraaste| ");
INSERT INTO sanvel_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantara.m yii\"su.h puna rbhajanag.rha.m pravi.s.tastasmin sthaane \"su.skahasta eko maanava aasiit| ");
INSERT INTO sanvel_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa vi\"sraamavaare tamarogi.na.m kari.syati navetyatra bahavastam apavaditu.m chidramapek.sitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadaa sa ta.m \"su.skahasta.m manu.sya.m jagaada madhyasthaane tvamutti.s.tha| ");
INSERT INTO sanvel_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tata.h para.m sa taan papraccha vi\"sraamavaare hitamahita.m tathaa hi praa.narak.saa vaa praa.nanaa\"sa e.saa.m madhye ki.m kara.niiya.m ? kintu te ni.h\"sabdaastasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadaa sa te.saamanta.hkara.naanaa.m kaa.thinyaaddheto rdu.hkhita.h krodhaat cartuिda\"so d.r.s.tavaan ta.m maanu.sa.m gaditavaan ta.m hasta.m vistaaraya, tatastena haste vist.rte taddhasto.anyahastavad arogo jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phiruu\"sina.h prasthaaya ta.m naa\"sayitu.m herodiiyai.h saha mantrayitumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataeva yii\"sustatsthaana.m parityajya \"si.syai.h saha puna.h saagarasamiipa.m gata.h; ");
INSERT INTO sanvel_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tato gaaliilyihuudaa-yiruu\"saalam-idom-yardannadiipaarasthaanebhyo lokasamuuhastasya pa\"scaad gata.h; tadanya.h sorasiidano.h samiipavaasilokasamuuha\"sca tasya mahaakarmma.naa.m vaartta.m \"srutvaa tasya sannidhimaagata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadaa lokasamuuha\"scet tasyopari patati ityaa\"sa\"nkya sa naavamekaa.m nika.te sthaapayitu.m \"si.syaanaadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yato.anekamanu.syaa.naamaarogyakara.naad vyaadhigrastaa.h sarvve ta.m spra.s.tu.m paraspara.m balena yatnavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","apara nca apavitrabhuutaasta.m d.r.s.tvaa taccara.nayo.h patitvaa procai.h procu.h, tvamii\"svarasya putra.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa taan d.r.dham aaj naapya sva.m paricaayitu.m ni.siddhavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantara.m sa parvvatamaaruhya ya.m ya.m praticchaa ta.m tamaahuutavaan tataste tatsamiipamaagataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadaa sa dvaada\"sajanaan svena saha sthaatu.m susa.mvaadapracaaraaya preritaa bhavitu.m ");
INSERT INTO sanvel_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakaaravyaadhiinaa.m \"samanakara.naaya prabhaava.m praaptu.m bhuutaan tyaajayitu nca niyuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","te.saa.m naamaaniimaani, \"simon sivadiputro ");
INSERT INTO sanvel_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yaakuub tasya bhraataa yohan ca aandriya.h philipo barthalamaya.h, ");
INSERT INTO sanvel_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathii thomaa ca aalphiiyaputro yaakuub thaddiiya.h kinaaniiya.h \"simon yasta.m parahaste.svarpayi.syati sa ii.skariyotiiyayihuudaa\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa \"simone pitara ityupanaama dadau yaakuubyohanbhyaa.m ca binerigi\"s arthato meghanaadaputraavityupanaama dadau| ");
INSERT INTO sanvel_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantara.m te nive\"sana.m gataa.h, kintu tatraapi punarmahaan janasamaagamo .abhavat tasmaatte bhoktumapyavakaa\"sa.m na praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suh.rllokaa imaa.m vaarttaa.m praapya sa hataj naanobhuud iti kathaa.m kathayitvaa ta.m dh.rtvaanetu.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","apara nca yiruu\"saalama aagataa ye ye.adhyaapakaaste jagaduraya.m puru.so bhuutapatyaabi.s.tastena bhuutapatinaa bhuutaan tyaajayati| ");
INSERT INTO sanvel_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastaanaahuuya yii\"su rd.r.s.taantai.h kathaa.m kathitavaan \"saitaan katha.m \"saitaana.m tyaajayitu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ki ncana raajya.m yadi svavirodhena p.rthag bhavati tarhi tad raajya.m sthira.m sthaatu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathaa kasyaapi parivaaro yadi paraspara.m virodhii bhavati tarhi sopi parivaara.h sthira.m sthaatu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat \"saitaan yadi svavipak.satayaa utti.s.than bhinno bhavati tarhi sopi sthira.m sthaatu.m na \"saknoti kintuucchinno bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","apara nca prabala.m jana.m prathama.m na baddhaa kopi tasya g.rha.m pravi\"sya dravyaa.ni lu.n.thayitu.m na \"saknoti, ta.m badvvaiva tasya g.rhasya dravyaa.ni lu.n.thayitu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atoheto ryu.smabhyamaha.m satya.m kathayaami manu.syaa.naa.m santaanaa yaani yaani paapaanii\"svaranindaa nca kurvvanti te.saa.m tatsarvve.saamaparaadhaanaa.m k.samaa bhavitu.m \"saknoti, ");
INSERT INTO sanvel_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu ya.h ka\"scit pavitramaatmaana.m nindati tasyaaparaadhasya k.samaa kadaapi na bhavi.syati sonantada.n.dasyaarho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyaapavitrabhuuto.asti te.saametatkathaaheto.h sa ittha.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya maataa bhraat.rga.na\"scaagatya bahisti.s.thanato lokaan pre.sya tamaahuutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupavi.s.taa lokaasta.m babhaa.sire pa\"sya bahistava maataa bhraatara\"sca tvaam anvicchanti| ");
INSERT INTO sanvel_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadaa sa taan pratyuvaaca mama maataa kaa bhraataro vaa ke? tata.h para.m sa svamiipopavi.s.taan \"si.syaan prati avalokana.m k.rtvaa kathayaamaasa ");
INSERT INTO sanvel_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","pa\"syataite mama maataa bhraatara\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ya.h ka\"scid ii\"svarasye.s.taa.m kriyaa.m karoti sa eva mama bhraataa bhaginii maataa ca| ");
INSERT INTO sanvel_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantara.m sa samudrata.te punarupade.s.tu.m praarebhe, tatastatra bahujanaanaa.m samaagamaat sa saagaropari naukaamaaruhya samupavi.s.ta.h; sarvve lokaa.h samudrakuule tasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadaa sa d.r.s.taantakathaabhi rbahuupadi.s.tavaan upadi\"sa.m\"sca kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhaana.m kuruta, eko biijavaptaa biijaani vaptu.m gata.h; ");
INSERT INTO sanvel_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakaale kiyanti biijaani maargapaa\"sve patitaani, tata aakaa\"siiyapak.si.na etya taani cakhaadu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti biijaani svalpam.rttikaavatpaa.saa.nabhuumau patitaani taani m.rdolpatvaat \"siighrama\"nkuritaani; ");
INSERT INTO sanvel_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintuudite suuryye dagdhaani tathaa muulaano naadhogatatvaat \"su.skaa.ni ca| ");
INSERT INTO sanvel_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti biijaani ka.n.takivanamadhye patitaani tata.h ka.n.takaani sa.mv.rdvya taani jagrasustaani na ca phalitaani| ");
INSERT INTO sanvel_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathaa kiyanti biijaanyuttamabhuumau patitaani taani sa.mv.rdvya phalaanyutpaaditaani kiyanti biijaani tri.m\"sadgu.naani kiyanti .sa.s.tigu.naani kiyanti \"satagu.naani phalaani phalitavanti| ");
INSERT INTO sanvel_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa taanavadat yasya \"srotu.m kar.nau sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantara.m nirjanasamaye tatsa\"ngino dvaada\"sa\"si.syaa\"sca ta.m tadd.r.s.taantavaakyasyaartha.m papracchu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadaa sa taanuditavaan ii\"svararaajyasya niguu.dhavaakya.m boddhu.m yu.smaakamadhikaaro.asti; ");
INSERT INTO sanvel_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu ye vahirbhuutaa.h \"te pa\"syanta.h pa\"syanti kintu na jaananti, \"s.r.nvanta.h \"s.r.nvanti kintu na budhyante, cettai rmana.hsu kadaapi parivarttite.su te.saa.m paapaanyamocayi.syanta,\" atohetostaan prati d.r.s.taantaireva taani mayaa kathitaani| ");
INSERT INTO sanvel_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavaan yuuya.m kimetad d.r.s.taantavaakya.m na budhyadhve? tarhi katha.m sarvvaan d.r.s.taantaana bhotsyadhve? ");
INSERT INTO sanvel_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","biijavaptaa vaakyaruupaa.ni biijaani vapati; ");
INSERT INTO sanvel_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra ye ye lokaa vaakya.m \"s.r.nvanti, kintu \"srutamaatraat \"saitaan \"siighramaagatya te.saa.m mana.hsuuptaani taani vaakyaruupaa.ni biijaanyapanayati taeva uptabiijamaargapaar\"svesvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ye janaa vaakya.m \"srutvaa sahasaa paramaanandena g.rhlanti, kintu h.rdi sthairyyaabhaavaat ki ncit kaalamaatra.m ti.s.thanti tatpa\"scaat tadvaakyaheto.h ");
INSERT INTO sanvel_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutracit kle\"se upadrave vaa samupasthite tadaiva vighna.m praapnuvanti taeva uptabiijapaa.saa.nabhuumisvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ye janaa.h kathaa.m \"s.r.nvanti kintu saa.msaarikii cintaa dhanabhraanti rvi.sayalobha\"sca ete sarvve upasthaaya taa.m kathaa.m grasanti tata.h maa viphalaa bhavati ");
INSERT INTO sanvel_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taeva uptabiijasaka.n.takabhuumisvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ye janaa vaakya.m \"srutvaa g.rhlanti te.saa.m kasya vaa tri.m\"sadgu.naani kasya vaa .sa.s.tigu.naani kasya vaa \"satagu.naani phalaani bhavanti taeva uptabiijorvvarabhuumisvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadaa so.aparamapi kathitavaan kopi jano diipaadhaara.m parityajya dro.nasyaadha.h kha.tvaayaa adhe vaa sthaapayitu.m diipamaanayati ki.m? ");
INSERT INTO sanvel_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atoheto ryanna prakaa\"sayi.syate taad.rg lukkaayita.m kimapi vastu naasti; yad vyakta.m na bhavi.syati taad.r\"sa.m gupta.m kimapi vastu naasti| ");
INSERT INTO sanvel_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya \"srotu.m kar.nau sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavaan yuuya.m yad yad vaakya.m \"s.r.nutha tatra saavadhaanaa bhavata, yato yuuya.m yena parimaa.nena parimaatha tenaiva parimaa.nena yu.smadarthamapi parimaasyate; \"srotaaro yuuya.m yu.smabhyamadhika.m daasyate| ");
INSERT INTO sanvel_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyaa\"sraye varddhate tasmai aparamapi daasyate, kintu yasyaa\"sraye na varddhate tasya yat ki ncidasti tadapi tasmaan ne.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantara.m sa kathitavaan eko loka.h k.setre biijaanyuptvaa ");
INSERT INTO sanvel_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jaagara.nanidraabhyaa.m divaani\"sa.m gamayati, parantu tadviija.m tasyaaj naataruupe.naa\"nkurayati varddhate ca; ");
INSERT INTO sanvel_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatoheto.h prathamata.h patraa.ni tata.h para.m ka.ni\"saani tatpa\"scaat ka.ni\"sapuur.naani \"sasyaani bhuumi.h svayamutpaadayati; ");
INSERT INTO sanvel_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phale.su pakke.su \"sasyacchedanakaala.m j naatvaa sa tatk.sa.na.m \"sasyaani chinatti, anena tulyamii\"svararaajya.m| ");
INSERT INTO sanvel_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","puna.h so.akathayad ii\"svararaajya.m kena sama.m? kena vastunaa saha vaa tadupamaasyaami? ");
INSERT INTO sanvel_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sar.sapaikena tulya.m yato m.rdi vapanakaale sar.sapabiija.m sarvvap.rthiviisthabiijaat k.sudra.m ");
INSERT INTO sanvel_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanaat param a\"nkurayitvaa sarvva\"saakaad b.rhad bhavati, tasya b.rhatya.h \"saakhaa\"sca jaayante tatastacchaayaa.m pak.si.na aa\"srayante| ");
INSERT INTO sanvel_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ittha.m te.saa.m bodhaanuruupa.m so.anekad.r.s.taantaistaanupadi.s.tavaan, ");
INSERT INTO sanvel_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","d.r.s.taanta.m vinaa kaamapi kathaa.m tebhyo na kathitavaan pa\"scaan nirjane sa \"si.syaan sarvvad.r.s.taantaartha.m bodhitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyaayaa.m sa tebhyo.akathayad aagacchata vaya.m paara.m yaama| ");
INSERT INTO sanvel_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadaa te lokaan vis.rjya tamavilamba.m g.rhiitvaa naukayaa pratasthire; aparaa api naavastayaa saha sthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tata.h para.m mahaajha nbh\"sagamaat nau rdolaayamaanaa tara\"nge.na jalai.h puur.naabhavacca| ");
INSERT INTO sanvel_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadaa sa naukaaca\"scaadbhaage upadhaane \"siro nidhaaya nidrita aasiit tataste ta.m jaagarayitvaa jagadu.h, he prabho, asmaaka.m praa.naa yaanti kimatra bhavata\"scintaa naasti? ");
INSERT INTO sanvel_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadaa sa utthaaya vaayu.m tarjitavaan samudra ncoktavaan \"saanta.h susthira\"sca bhava; tato vaayau niv.rtte.abdhirnistara\"ngobhuut| ");
INSERT INTO sanvel_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadaa sa taanuvaaca yuuya.m kuta etaad.rk\"sa\"nkaakulaa bhavata? ki.m vo vi\"svaaso naasti? ");
INSERT INTO sanvel_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmaatte.atiivabhiitaa.h paraspara.m vaktumaarebhire, aho vaayu.h sindhu\"scaasya nide\"sagraahi.nau kiid.rgaya.m manuja.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tuu sindhupaara.m gatvaa gideriiyaprade\"sa upatasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukaato nirgatamaatraad apavitrabhuutagrasta eka.h \"sma\"saanaadetya ta.m saak.saac cakaara| ");
INSERT INTO sanvel_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa \"sma\"saane.avaatsiit kopi ta.m \"s.r\"nkhalena badvvaa sthaapayitu.m naa\"saknot| ");
INSERT INTO sanvel_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvaara.m niga.dai.h \"s.r\"nkhalai\"sca sa baddhopi \"s.r\"nkhalaanyaak.r.sya mocitavaan niga.daani ca bha.mktvaa kha.n.da.m kha.n.da.m k.rtavaan kopi ta.m va\"siikarttu.m na \"sa\"saka| ");
INSERT INTO sanvel_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divaani\"sa.m sadaa parvvata.m \"sma\"saana nca bhramitvaa ciit\"sabda.m k.rtavaan graavabhi\"sca svaya.m sva.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yii\"su.m duuraat pa\"syanneva dhaavan ta.m pra.nanaama ucairuva.m\"scovaaca, ");
INSERT INTO sanvel_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","he sarvvoparisthe\"svaraputra yii\"so bhavataa saha me ka.h sambandha.h? aha.m tvaamii\"svare.na \"saapaye maa.m maa yaataya| ");
INSERT INTO sanvel_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yato yii\"susta.m kathitavaan re apavitrabhuuta, asmaannaraad bahirnirgaccha| ");
INSERT INTO sanvel_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa ta.m p.r.s.tavaan kinte naama? tena pratyukta.m vayamaneke .asmastato.asmannaama baahinii| ");
INSERT INTO sanvel_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatosmaan de\"saanna pre.sayeti te ta.m praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadaanii.m parvvata.m nika.saa b.rhan varaahavraja\"scarannaasiit| ");
INSERT INTO sanvel_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmaad bhuutaa vinayena jagadu.h, amu.m varaahavrajam aa\"srayitum asmaan prahi.nu| ");
INSERT INTO sanvel_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yii\"sunaanuj naataaste.apavitrabhuutaa bahirniryaaya varaahavraja.m praavi\"san tata.h sarvve varaahaa vastutastu praayodvisahasrasa.m\"nkhyakaa.h ka.takena mahaajavaad dhaavanta.h sindhau praa.naan jahu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmaad varaahapaalakaa.h palaayamaanaa.h pure graame ca tadvaartta.m kathayaa ncakru.h| tadaa lokaa gha.tita.m tatkaaryya.m dra.s.tu.m bahirjagmu.h ");
INSERT INTO sanvel_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yii\"so.h sannidhi.m gatvaa ta.m bhuutagrastam arthaad baahiniibhuutagrasta.m nara.m savastra.m sacetana.m samupavi.s.ta nca d.rृ.s.tvaa bibhyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tato d.r.s.tatatkaaryyalokaastasya bhuutagrastanarasya varaahavrajasyaapi taa.m dha.tanaa.m var.nayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tataste svasiimaato bahirgantu.m yii\"su.m vinetumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukaaroha.nakaale sa bhuutamukto naa yii\"sunaa saha sthaatu.m praarthayate; ");
INSERT INTO sanvel_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavaan tva.m nijaatmiiyaanaa.m samiipa.m g.rha nca gaccha prabhustvayi k.rpaa.m k.rtvaa yaani karmmaa.ni k.rtavaan taani taan j naapaya| ");
INSERT INTO sanvel_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ata.h sa prasthaaya yii\"sunaa k.rta.m tatsarvvaa\"scaryya.m karmma dikaapalide\"se pracaarayitu.m praarabdhavaan tata.h sarvve lokaa aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantara.m yii\"sau naavaa punaranyapaara uttiir.ne sindhuta.te ca ti.s.thati sati tatsamiipe bahulokaanaa.m samaagamo.abhuut| ");
INSERT INTO sanvel_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","apara.m yaayiir naamnaa ka\"scid bhajanag.rhasyaadhipa aagatya ta.m d.r.s.tvaiva cara.nayo.h patitvaa bahu nivedya kathitavaan; ");
INSERT INTO sanvel_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyaa m.rtapraayaabhuud ato bhavaanetya tadaarogyaaya tasyaa gaatre hastam arpayatu tenaiva saa jiivi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadaa yii\"sustena saha calita.h kintu tatpa\"scaad bahulokaa\"scalitvaa taadgaatre patitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvaada\"savar.saa.ni pradararoge.na ");
INSERT INTO sanvel_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","\"siir.naa cikitsakaanaa.m naanaacikitsaabhi\"sca du.hkha.m bhuktavatii ca sarvvasva.m vyayitvaapi naarogya.m praaptaa ca punarapi pii.ditaasiicca ");
INSERT INTO sanvel_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yaa strii saa yii\"so rvaarttaa.m praapya manasaakathayat yadyaha.m tasya vastramaatra spra.s.tu.m labheya.m tadaa rogahiinaa bhavi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atoheto.h saa lokaara.nyamadhye tatpa\"scaadaagatya tasya vastra.m paspar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tenaiva tatk.sa.na.m tasyaa raktasrota.h \"su.ska.m svaya.m tasmaad rogaanmuktaa ityapi dehe.anubhuutaa| ");
INSERT INTO sanvel_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmaat \"sakti rnirgataa yii\"suretanmanasaa j naatvaa lokanivaha.m prati mukha.m vyaav.rtya p.r.s.tavaan kena madvastra.m sp.r.s.ta.m? ");
INSERT INTO sanvel_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya \"si.syaa uucu.h bhavato vapu.si lokaa.h sa.mghar.santi tad d.r.s.tvaa kena madvastra.m sp.r.s.tamiti kuta.h kathayati? ");
INSERT INTO sanvel_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kena tat karmma k.rta.m tad dra.s.tu.m yii\"su\"scaturdi\"so d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tata.h saa strii bhiitaa kampitaa ca satii svasyaa rukpratikriyaa jaateti j naatvaagatya tatsammukhe patitvaa sarvvav.rttaanta.m satya.m tasmai kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadaanii.m yii\"sustaa.m gaditavaan, he kanye tava pratiitistvaam arogaamakarot tva.m k.seme.na vraja svarogaanmuktaa ca ti.s.tha| ");
INSERT INTO sanvel_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivaakyavadanakaale bhajanag.rhaadhipasya nive\"sanaal lokaa etyaadhipa.m babhaa.sire tava kanyaa m.rtaa tasmaad guru.m puna.h kuta.h kli\"snaasi? ");
INSERT INTO sanvel_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yii\"sustad vaakya.m \"srutvaiva bhajanag.rhaadhipa.m gaditavaan maa bhai.sii.h kevala.m vi\"svaasihi| ");
INSERT INTO sanvel_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitaro yaakuub tadbhraataa yohan ca etaan vinaa kamapi svapa\"scaad yaatu.m naanvamanyata| ");
INSERT INTO sanvel_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanag.rhaadhipasya nive\"sanasamiipam aagatya kalaha.m bahurodana.m vilaapa nca kurvvato lokaan dadar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmaan nive\"sana.m pravi\"sya proktavaan yuuya.m kuta ittha.m kalaha.m rodana nca kurutha? kanyaa na m.rtaa nidraati| ");
INSERT INTO sanvel_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmaatte tamupajahasu.h kintu yii\"su.h sarvvaana bahi.sk.rtya kanyaayaa.h pitarau svasa\"ngina\"sca g.rhiitvaa yatra kanyaasiit tat sthaana.m pravi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyaa.h kanyaayaa hastau dh.rtvaa taa.m babhaa.se .taaliithaa kuumii, arthato he kanye tvamutti.s.tha ityaaj naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatk.sa.na.m saa dvaada\"savar.savayaskaa kanyaa potthaaya calitumaarebhe, ita.h sarvve mahaavismaya.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata etasyai ki ncit khaadya.m datteti kathayitvaa etatkarmma kamapi na j naapayateti d.r.dhamaadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantara.m sa tatsthaanaat prasthaaya svaprade\"samaagata.h \"si.syaa\"sca tatpa\"scaad gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha vi\"sraamavaare sati sa bhajanag.rhe upade.s.tumaarabdhavaan tato.aneke lokaastatkathaa.m \"srutvaa vismitya jagadu.h, asya manujasya iid.r\"sii aa\"scaryyakriyaa kasmaaj jaataa? tathaa svakaraabhyaam itthamadbhuta.m karmma karttaaुm etasmai katha.m j naana.m dattam? ");
INSERT INTO sanvel_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimaya.m mariyama.h putrastaj naa no? kimaya.m yaakuub-yosi-yihudaa-\"simonaa.m bhraataa no? asya bhaginya.h kimihaasmaabhi.h saha no? ittha.m te tadarthe pratyuuha.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadaa yii\"sustebhyo.akathayat svade\"sa.m svaku.tumbaan svaparijanaa.m\"sca vinaa kutraapi bhavi.syadvaadii asatk.rto na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","apara nca te.saamapratyayaat sa vismita.h kiyataa.m rogi.naa.m vapu.h.su hastam arpayitvaa kevala.m te.saamaarogyakara.naad anyat kimapi citrakaaryya.m karttaa.m na \"sakta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa caturdikstha graamaan bhramitvaa upadi.s.tavaan ");
INSERT INTO sanvel_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvaada\"sa\"si.syaan aahuuya amedhyabhuutaan va\"siikarttaa.m \"sakti.m dattvaa te.saa.m dvau dvau jano pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityaadi\"sad yuuyam ekaikaa.m ya.s.ti.m vinaa vastrasa.mpu.ta.h puupa.h ka.tibandhe taamrakha.n.da nca e.saa.m kimapi maa grahliita, ");
INSERT INTO sanvel_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","maargayaatraayai paade.suupaanahau dattvaa dve uttariiye maa paridhadvva.m| ");
INSERT INTO sanvel_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyukta.m tena yuuya.m yasyaa.m puryyaa.m yasya nive\"sana.m pravek.syatha taa.m purii.m yaavanna tyak.syatha taavat tannive\"sane sthaasyatha| ");
INSERT INTO sanvel_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kepi yu.smaakamaatithya.m na vidadhati yu.smaaka.m kathaa\"sca na \"s.r.nvanti tarhi tatsthaanaat prasthaanasamaye te.saa.m viruddha.m saak.sya.m daatu.m svapaadaanaasphaalya raja.h sampaatayata; aha.m yu.smaan yathaartha.m vacmi vicaaradine tannagarasyaavasthaata.h sidomaamorayo rnagarayoravasthaa sahyataraa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha te gatvaa lokaanaa.m mana.hparaavarttanii.h kathaa pracaaritavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","evamanekaan bhuutaa.m\"sca tyaajitavantastathaa tailena marddayitvaa bahuun janaanarogaanakaar.su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ittha.m tasya sukhyaati\"scaturdi\"so vyaaptaa tadaa herod raajaa tanni\"samya kathitavaan, yohan majjaka.h \"sma\"saanaad utthita atohetostena sarvvaa etaa adbhutakriyaa.h prakaa\"sante| ");
INSERT INTO sanvel_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anye.akathayan ayam eliya.h, kepi kathitavanta e.sa bhavi.syadvaadii yadvaa bhavi.syadvaadinaa.m sad.r\"sa ekoyam| ");
INSERT INTO sanvel_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu herod ityaakar.nya bhaa.sitavaan yasyaaha.m \"sira\"schinnavaan sa eva yohanaya.m sa \"sma\"saanaadudati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","puurvva.m svabhraatu.h philipasya patnyaa udvaaha.m k.rtavanta.m heroda.m yohanavaadiit svabhaat.rvadhuu rna vivaahyaa| ");
INSERT INTO sanvel_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ata.h kaara.naat herod loka.m prahitya yohana.m dh.rtvaa bandhanaalaye baddhavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","herodiyaa tasmai yohane prakupya ta.m hantum aicchat kintu na \"saktaa, ");
INSERT INTO sanvel_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmaad herod ta.m dhaarmmika.m satpuru.sa nca j naatvaa sammanya rak.sitavaan; tatkathaa.m \"srutvaa tadanusaare.na bahuuni karmmaa.ni k.rtavaan h.r.s.tamanaastadupade\"sa.m \"srutavaa.m\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu herod yadaa svajanmadine pradhaanalokebhya.h senaaniibhya\"sca gaaliilprade\"siiya\"sre.s.thalokebhya\"sca raatrau bhojyameka.m k.rtavaan ");
INSERT INTO sanvel_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin \"subhadine herodiyaayaa.h kanyaa sametya te.saa.m samak.sa.m sa.mn.rtya herodastena sahopavi.s.taanaa nca to.samajiijanat tataa n.rpa.h kanyaamaaha sma matto yad yaacase tadeva tubhya.m daasye| ");
INSERT INTO sanvel_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","\"sapatha.m k.rtvaakathayat ced raajyaarddhamapi yaacase tadapi tubhya.m daasye| ");
INSERT INTO sanvel_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tata.h saa bahi rgatvaa svamaatara.m papraccha kimaha.m yaaci.sye? tadaa saakathayat yohano majjakasya \"sira.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tuur.na.m bhuupasamiipam etya yaacamaanaavadat k.sa.nesmin yohano majjakasya \"sira.h paatre nidhaaya dehi, etad yaace.aha.m| ");
INSERT INTO sanvel_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmaat bhuupo.atidu.hkhita.h, tathaapi sva\"sapathasya sahabhojinaa ncaanurodhaat tadana\"ngiikarttu.m na \"sakta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatk.sa.na.m raajaa ghaataka.m pre.sya tasya \"sira aanetumaadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tata.h sa kaaraagaara.m gatvaa tacchira\"schitvaa paatre nidhaayaaniiya tasyai kanyaayai dattavaan kanyaa ca svamaatre dadau| ");
INSERT INTO sanvel_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananatara.m yohana.h \"si.syaastadvaarttaa.m praapyaagatya tasya ku.napa.m \"sma\"saane.asthaapayan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha pre.sitaa yii\"so.h sannidhau militaa yad yac cakru.h \"sik.sayaamaasu\"sca tatsarvvavaarttaastasmai kathitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa taanuvaaca yuuya.m vijanasthaana.m gatvaa vi\"sraamyata yatastatsannidhau bahulokaanaa.m samaagamaat te bhoktu.m naavakaa\"sa.m praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tataste naavaa vijanasthaana.m gupta.m gagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tato lokanivahaste.saa.m sthaanaantarayaana.m dadar\"sa, aneke ta.m paricitya naanaapurebhya.h padairvrajitvaa javena tai.saamagre yii\"so.h samiipa upatasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadaa yii\"su rnaavo bahirgatya lokaara.nyaanii.m d.r.s.tvaa te.su karu.naa.m k.rtavaan yataste.arak.sakame.saa ivaasan tadaa sa taana naanaaprasa\"ngaan upadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divaante sati \"si.syaa etya yii\"sumuucire, ida.m vijanasthaana.m dina ncaavasanna.m| ");
INSERT INTO sanvel_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lokaanaa.m kimapi khaadya.m naasti, ata\"scaturdik.su graamaan gantu.m bhojyadravyaa.ni kretu nca bhavaan taan vis.rjatu| ");
INSERT INTO sanvel_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadaa sa taanuvaaca yuuyameva taan bhojayata; tataste jagadu rvaya.m gatvaa dvi\"satasa.mkhyakai rmudraapaadai.h puupaan kriitvaa ki.m taan bhojayi.syaama.h? ");
INSERT INTO sanvel_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadaa sa taan p.r.s.thavaan yu.smaaka.m sannidhau kati puupaa aasate? gatvaa pa\"syata; tataste d.r.s.tvaa tamavadan pa nca puupaa dvau matsyau ca santi| ");
INSERT INTO sanvel_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadaa sa lokaan \"saspopari pa.mktibhirupave\"sayitum aadi.s.tavaan, ");
INSERT INTO sanvel_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tataste \"sata.m \"sata.m janaa.h pa ncaa\"sat pa ncaa\"sajjanaa\"sca pa.mktibhi rbhuvi samupavivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa taan pa ncapuupaan matsyadvaya nca dh.rtvaa svarga.m pa\"syan ii\"svaragu.naan anvakiirttayat taan puupaan bha.mktvaa lokebhya.h parive.sayitu.m \"si.syebhyo dattavaan dvaa matsyau ca vibhajya sarvvebhyo dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tata.h sarvve bhuktvaat.rpyan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantara.m \"si.syaa ava\"si.s.tai.h puupai rmatsyai\"sca puur.naan dvada\"sa .dallakaan jag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","te bhoktaara.h praaya.h pa nca sahasraa.ni puru.saa aasan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lokaan vis.rjanneva naavamaaro.dhu.m svasmaadagre paare baitsaidaapura.m yaatu nca \"s.syiाn vaa.dhamaadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadaa sa sarvvaan vis.rjya praarthayitu.m parvvata.m gata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tata.h sandhyaayaa.m satyaa.m nau.h sindhumadhya upasthitaa kintu sa ekaakii sthale sthita.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavaatavahanaat \"si.syaa naava.m vaahayitvaa pari\"sraantaa iti j naatvaa sa ni\"saacaturthayaame sindhuupari padbhyaa.m vrajan te.saa.m samiipametya te.saamagre yaatum udyata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu \"si.syaa.h sindhuupari ta.m vrajanta.m d.r.s.tvaa bhuutamanumaaya ruruvu.h, ");
INSERT INTO sanvel_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yata.h sarvve ta.m d.r.s.tvaa vyaakulitaa.h| ataeva yii\"sustatk.sa.na.m tai.h sahaalapya kathitavaan, susthiraa bhuuta, ayamaha.m maa bhai.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukaamaaruhya tasmin te.saa.m sannidhi.m gate vaato niv.rtta.h; tasmaatte mana.hsu vismitaa aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yataste manasaa.m kaa.thinyaat tat puupiiyam aa\"scaryya.m karmma na viviktavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha te paara.m gatvaa gine.saratprade\"sametya ta.ta upasthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","te.su naukaato bahirgate.su tatprade\"siiyaa lokaasta.m paricitya ");
INSERT INTO sanvel_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caturdik.su dhaavanto yatra yatra rogi.no naraa aasan taan sarvvaana kha.tvopari nidhaaya yatra kutracit tadvaarttaa.m praapu.h tat sthaanam aanetum aarebhire| ");
INSERT INTO sanvel_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathaa yatra yatra graame yatra yatra pure yatra yatra pallyaa nca tena prave\"sa.h k.rtastadvartmamadhye lokaa.h pii.ditaan sthaapayitvaa tasya celagranthimaatra.m spra.s.tum te.saamarthe tadanuj naa.m praarthayanta.h yaavanto lokaa.h pasp.r\"sustaavanta eva gadaanmuktaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantara.m yiruu\"saalama aagataa.h phiruu\"sino.adhyaapakaa\"sca yii\"so.h samiipam aagataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","te tasya kiyata.h \"si.syaan a\"sucikarairarthaada aprak.saalitahastai rbhu njato d.r.s.tvaa taanaduu.sayan| ");
INSERT INTO sanvel_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yata.h phiruu\"sina.h sarvvayihuudiiyaa\"sca praacaa.m paramparaagatavaakya.m sammanya pratalena hastaan aprak.saalya na bhu njate| ");
INSERT INTO sanvel_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","aapanaadaagatya majjana.m vinaa na khaadanti; tathaa paanapaatraa.naa.m jalapaatraa.naa.m pittalapaatraa.naam aasanaanaa nca jale majjanam ityaadayonyepi bahavaste.saamaacaaraa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","te phiruu\"sino.adhyaapakaa\"sca yii\"su.m papracchu.h, tava \"si.syaa.h praacaa.m paramparaagatavaakyaanusaare.na naacaranto.aprak.saalitakarai.h kuto bhuja.mte? ");
INSERT INTO sanvel_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tata.h sa pratyuvaaca kapa.tino yu.smaan uddi\"sya yi\"sayiyabhavi.syadvaadii yuktamavaadiit| yathaa svakiiyairadharairete sammanyanate sadaiva maa.m| kintu matto viprakar.se santi te.saa.m manaa.msi ca| ");
INSERT INTO sanvel_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","\"sik.sayanto bidhiin nnaaj naa bhajante maa.m mudhaiva te| ");
INSERT INTO sanvel_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yuuya.m jalapaatrapaanapaatraadiini majjayanto manujaparamparaagatavaakya.m rak.satha kintu ii\"svaraaj naa.m la.mghadhve; aparaa iid.r\"syonekaa.h kriyaa api kurudhve| ");
INSERT INTO sanvel_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anya ncaakathayat yuuya.m svaparamparaagatavaakyasya rak.saartha.m spa.s.taruupe.na ii\"svaraaj naa.m lopayatha| ");
INSERT INTO sanvel_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yato muusaadvaaraa proktamasti svapitarau sammanyadhva.m yastu maatara.m pitara.m vaa durvvaakya.m vakti sa nitaanta.m hanyataa.m| ");
INSERT INTO sanvel_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madiiyena yena dravye.na tavopakaarobhavat tat karbbaa.namarthaad ii\"svaraaya niveditam ida.m vaakya.m yadi kopi pitara.m maatara.m vaa vakti ");
INSERT INTO sanvel_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yuuya.m maatu.h pitu rvopakaara.m karttaa.m ta.m vaarayatha| ");
INSERT INTO sanvel_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ittha.m svapracaaritaparamparaagatavaakyena yuuyam ii\"svaraaj naa.m mudhaa vidhadvve, iid.r\"saanyanyaanyanekaani karmmaa.ni kurudhve| ");
INSERT INTO sanvel_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lokaanaahuuya babhaa.se yuuya.m sarvve madvaakya.m \"s.r.nuta budhyadhva nca| ");
INSERT INTO sanvel_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","baahyaadantara.m pravi\"sya naramamedhya.m karttaa.m \"saknoti iid.r\"sa.m kimapi vastu naasti, varam antaraad bahirgata.m yadvastu tanmanujam amedhya.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya \"srotu.m \"srotre sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tata.h sa lokaan hitvaa g.rhamadhya.m pravi.s.tastadaa \"si.syaastad.r.s.taantavaakyaartha.m papracchu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmaat sa taan jagaada yuuyamapi kimetaad.rgabodhaa.h? kimapi dravya.m baahyaadantara.m pravi\"sya naramamedhya.m karttaa.m na \"saknoti kathaamimaa.m ki.m na budhyadhve? ");
INSERT INTO sanvel_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna pravi\"sati kintu kuk.simadhya.m pravi\"sati \"se.se sarvvabhuktavastugraahi.ni bahirde\"se niryaati| ");
INSERT INTO sanvel_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavaadiid yannaraannireti tadeva naramamedhya.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yato.antaraad arthaan maanavaanaa.m manobhya.h kucintaa parastriive\"syaagamana.m ");
INSERT INTO sanvel_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadha\"scauryya.m lobho du.s.tataa prava ncanaa kaamukataa kud.r.s.tirii\"svaranindaa garvvastama ityaadiini nirgacchanti| ");
INSERT INTO sanvel_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","etaani sarvvaa.ni duritaanyantaraadetya naramamedhya.m kurvvanti| ");
INSERT INTO sanvel_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthaaya tatsthaanaat sorasiidonpuraprade\"sa.m jagaama tatra kimapi nive\"sana.m pravi\"sya sarvvairaj naata.h sthaatu.m mati ncakre kintu gupta.h sthaatu.m na \"sa\"saaka| ");
INSERT INTO sanvel_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yata.h suraphainikiide\"siiyayuunaaniiva.m\"sodbhavastriyaa.h kanyaa bhuutagrastaasiit| saa strii tadvaarttaa.m praapya tatsamiipamaagatya taccara.nayo.h patitvaa ");
INSERT INTO sanvel_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyaato bhuuta.m niraakarttaa.m tasmin vinaya.m k.rtavatii| ");
INSERT INTO sanvel_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yii\"sustaamavadat prathama.m baalakaast.rpyantu yato baalakaanaa.m khaadya.m g.rhiitvaa kukkurebhyo nik.sepo.anucita.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadaa saa strii tamavaadiit bho.h prabho tat satya.m tathaapi ma ncaadha.hsthaa.h kukkuraa baalaanaa.m karapatitaani khaadyakha.n.daani khaadanti| ");
INSERT INTO sanvel_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tata.h so.akathayad etatkathaaheto.h saku\"salaa yaahi tava kanyaa.m tyaktvaa bhuuto gata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha saa strii g.rha.m gatvaa kanyaa.m bhuutatyaktaa.m \"sayyaasthitaa.m dadar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","puna\"sca sa sorasiidonpuraprade\"saat prasthaaya dikaapalide\"sasya praantarabhaagena gaaliiljaladhe.h samiipa.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadaa lokaireka.m badhira.m kadvada nca nara.m tannika.tamaaniiya tasya gaatre hastamarpayitu.m vinaya.h k.rta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tato yii\"su rlokaara.nyaat ta.m nirjanamaaniiya tasya kar.nayo\"ngulii rdadau ni.s.thiiva.m dattvaa ca tajjihvaa.m paspar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantara.m svarga.m niriik.sya diirgha.m ni\"svasya tamavadat itaphata.h arthaan mukto bhuuyaat| ");
INSERT INTO sanvel_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatk.sa.na.m tasya kar.nau muktau jihvaayaa\"sca jaa.dyaapagamaat sa suspa.s.tavaakyamakathayat| ");
INSERT INTO sanvel_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa taan vaa.dhamityaadide\"sa yuuyamimaa.m kathaa.m kasmaicidapi maa kathayata, kintu sa yati nya.sedhat te tati baahulyena praacaarayan; ");
INSERT INTO sanvel_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","te.aticamatk.rtya paraspara.m kathayaamaasu.h sa badhiraaya \"srava.na\"sakti.m muukaaya ca kathana\"sakti.m dattvaa sarvva.m karmmottamaruupe.na cakaara| ");
INSERT INTO sanvel_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadaa tatsamiipa.m bahavo lokaa aayaataa ataste.saa.m bhojyadravyaabhaavaad yii\"su.h \"si.syaanaahuuya jagaada,| ");
INSERT INTO sanvel_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lokanivahe mama k.rpaa jaayate te dinatraya.m mayaa saarddha.m santi te.saa.m bhojya.m kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","te.saa.m madhye.aneke duuraad aagataa.h, abhukte.su te.su mayaa svag.rhamabhiprahite.su te pathi klami.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","\"si.syaa avaadi.su.h, etaavato lokaan tarpayitum atra prantare puupaan praaptu.m kena \"sakyate? ");
INSERT INTO sanvel_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tata.h sa taan papraccha yu.smaaka.m kati puupaa.h santi? te.akathayan sapta| ");
INSERT INTO sanvel_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tata.h sa taallokaan bhuvi samupave.s.tum aadi\"sya taan sapta puupaan dh.rtvaa ii\"svaragu.naan anukiirttayaamaasa, bha.mktvaa parive.sayitu.m \"si.syaan prati dadau, tataste lokebhya.h parive.sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathaa te.saa.m samiipe ye k.sudramatsyaa aasan taanapyaadaaya ii\"svaragu.naan sa.mkiirtya parive.sayitum aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tato lokaa bhuktvaa t.rpti.m gataa ava\"si.s.takhaadyai.h puur.naa.h sapta.dallakaa g.rhiitaa\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ete bhoktaara.h praaya\"scatu.h sahasrapuru.saa aasan tata.h sa taan visasarja| ");
INSERT INTO sanvel_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa \"si.sya.h saha naavamaaruhya dalmaanuuthaasiimaamaagata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tata.h para.m phiruu\"sina aagatya tena saha vivadamaanaastasya pariik.saartham aakaa\"siiyacihna.m dra.s.tu.m yaacitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadaa so.antardiirgha.m ni\"svasyaakathayat, ete vidyamaananaraa.h kuta\"scinha.m m.rgayante? yu.smaanaha.m yathaartha.m braviimi lokaanetaan kimapi cihna.m na dar\"sayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha taan hitvaa puna rnaavam aaruhya paaramagaat| ");
INSERT INTO sanvel_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","etarhi \"si.syai.h puupe.su vism.rte.su naavi te.saa.m sannidhau puupa ekaeva sthita.h| ");
INSERT INTO sanvel_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadaanii.m yii\"sustaan aadi.s.tavaan phiruu\"sinaa.m heroda\"sca ki.nva.m prati satarkaa.h saavadhaanaa\"sca bhavata| ");
INSERT INTO sanvel_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tataste.anyonya.m vivecana.m kartum aarebhire, asmaaka.m sannidhau puupo naastiiti hetorida.m kathayati| ");
INSERT INTO sanvel_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvaa yii\"sustebhyo.akathayat yu.smaaka.m sthaane puupaabhaavaat kuta ittha.m vitarkayatha? yuuya.m kimadyaapi kimapi na jaaniitha? boddhu nca na \"saknutha? yaavadadya ki.m yu.smaaka.m manaa.msi ka.thinaani santi? ");
INSERT INTO sanvel_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu netre.su ki.m na pa\"syatha? satsu kar.ne.su ki.m na \"s.r.nutha? na smaratha ca? ");
INSERT INTO sanvel_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadaaha.m pa ncapuupaan pa ncasahasraa.naa.m puru.saa.naa.m madhye bha.mktvaa dattavaan tadaanii.m yuuyam ava\"si.s.tapuupai.h puur.naan kati .dallakaan g.rhiitavanta.h? te.akathayan dvaada\"sa.dallakaan| ");
INSERT INTO sanvel_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","apara nca yadaa catu.hsahasraa.naa.m puru.saa.naa.m madhye puupaan bha.mktvaadadaa.m tadaa yuuyam atiriktapuupaanaa.m kati .dallakaan g.rhiitavanta.h? te kathayaamaasu.h sapta.dallakaan| ");
INSERT INTO sanvel_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadaa sa kathitavaan tarhi yuuyam adhunaapi kuto bodvvu.m na \"saknutha? ");
INSERT INTO sanvel_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantara.m tasmin baitsaidaanagare praapte lokaa andhameka.m nara.m tatsamiipamaaniiya ta.m spra.s.tu.m ta.m praarthayaa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadaa tasyaandhasya karau g.rhiitvaa nagaraad bahirde\"sa.m ta.m niitavaan; tannetre ni.s.thiiva.m dattvaa tadgaatre hastaavarpayitvaa ta.m papraccha, kimapi pa\"syasi? ");
INSERT INTO sanvel_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa netre unmiilya jagaada, v.rk.savat manujaan gacchato niriik.se| ");
INSERT INTO sanvel_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tato yii\"su.h punastasya nayanayo rhastaavarpayitvaa tasya netre unmiilayaamaasa; tasmaat sa svastho bhuutvaa spa.s.taruupa.m sarvvalokaan dadar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tata.h para.m tva.m graama.m maa gaccha graamastha.m kamapi ca kimapyanuktvaa nijag.rha.m yaahiityaadi\"sya yii\"susta.m nijag.rha.m prahitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantara.m \"si.syai.h sahito yii\"su.h kaisariiyaaphilipipura.m jagaama, pathi gacchan taanap.rcchat ko.aham atra lokaa.h ki.m vadanti? ");
INSERT INTO sanvel_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","te pratyuucu.h tvaa.m yohana.m majjaka.m vadanti kintu kepi kepi eliya.m vadanti; apare kepi kepi bhavi.syadvaadinaam eko jana iti vadanti| ");
INSERT INTO sanvel_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa taanap.rcchat kintu koham? ityatra yuuya.m ki.m vadatha? tadaa pitara.h pratyavadat bhavaan abhi.siktastraataa| ");
INSERT INTO sanvel_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tata.h sa taan gaa.dhamaadi\"sad yuuya.m mama kathaa kasmaicidapi maa kathayata| ");
INSERT INTO sanvel_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manu.syaputre.naava\"sya.m bahavo yaatanaa bhoktavyaa.h praaciinalokai.h pradhaanayaajakairadhyaapakai\"sca sa nindita.h san ghaatayi.syate t.rtiiyadine utthaasyati ca, yii\"su.h \"si.syaanupade.s.tumaarabhya kathaamimaa.m spa.s.tamaaca.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmaat pitarastasya hastau dh.rtvaa ta.m tarjjitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukha.m paraavartya \"si.syaga.na.m niriik.sya pitara.m tarjayitvaavaadiid duuriibhava vighnakaarin ii\"svariiyakaaryyaadapi manu.syakaaryya.m tubhya.m rocatataraa.m| ");
INSERT INTO sanvel_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lokaan \"si.syaa.m\"scaahuuya jagaada ya.h ka\"scin maamanugantum icchati sa aatmaana.m daamyatu, svakru\"sa.m g.rhiitvaa matpa\"scaad aayaatu| ");
INSERT INTO sanvel_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yato ya.h ka\"scit svapraa.na.m rak.situmicchati sa ta.m haarayi.syati, kintu ya.h ka\"scin madartha.m susa.mvaadaartha nca praa.na.m haarayati sa ta.m rak.si.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","apara nca manuja.h sarvva.m jagat praapya yadi svapraa.na.m haarayati tarhi tasya ko laabha.h? ");
INSERT INTO sanvel_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","nara.h svapraa.navinimayena ki.m daatu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ete.saa.m vyabhicaari.naa.m paapinaa nca lokaanaa.m saak.saad yadi kopi maa.m matkathaa nca lajjaaspada.m jaanaati tarhi manujaputro yadaa dharmmaduutai.h saha pitu.h prabhaave.naagami.syati tadaa sopi ta.m lajjaaspada.m j naasyati| ");
INSERT INTO sanvel_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa taanavaadiit yu.smabhyamaha.m yathaartha.m kathayaami, ii\"svararaajya.m paraakrame.nopasthita.m na d.r.s.tvaa m.rtyu.m naasvaadi.syante, atra da.n.daayamaanaanaa.m madhyepi taad.r\"saa lokaa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha .sa.ddinebhya.h para.m yii\"su.h pitara.m yaakuuba.m yohana nca g.rhiitvaa gireruccasya nirjanasthaana.m gatvaa te.saa.m pratyak.se muurtyantara.m dadhaara| ");
INSERT INTO sanvel_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridheyam iid.r\"sam ujjvalahimapaa.na.dara.m jaata.m yad jagati kopi rajako na taad.rk paa.na.dara.m karttaa.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","apara nca eliyo muusaa\"sca tebhyo dar\"sana.m dattvaa yii\"sunaa saha kathana.m karttumaarebhaate| ");
INSERT INTO sanvel_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadaa pitaro yii\"sumavaadiit he guro.asmaakamatra sthitiruttamaa, tataeva vaya.m tvatk.rte ekaa.m muusaak.rte ekaam eliyak.rte caikaa.m, etaastisra.h ku.tii rnirmmaama| ");
INSERT INTO sanvel_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavaan tat svaya.m na bubudhe tata.h sarvve bibhayaa ncakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","etarhi payodastaan chaadayaamaasa, mamayaa.m priya.h putra.h kathaasu tasya manaa.msi nive\"sayateti nabhovaa.nii tanmedyaanniryayau| ");
INSERT INTO sanvel_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha ha.thaatte caturdi\"so d.r.s.tvaa yii\"su.m vinaa svai.h sahita.m kamapi na dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tata.h para.m gireravaroha.nakaale sa taan gaa.dham duutyaadide\"sa yaavannarasuuno.h \"sma\"saanaadutthaana.m na bhavati, taavat dar\"sanasyaasya vaarttaa yu.smaabhi.h kasmaicidapi na vaktavyaa| ");
INSERT INTO sanvel_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadaa \"sma\"saanaadutthaanasya kobhipraaya iti vicaaryya te tadvaakya.m sve.su gopaayaa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha te yii\"su.m papracchu.h prathamata eliyenaagantavyam iti vaakya.m kuta upaadhyaayaa aahu.h? ");
INSERT INTO sanvel_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadaa sa pratyuvaaca , eliya.h prathamametya sarvvakaaryyaa.ni saadhayi.syati; naraputre ca lipi ryathaaste tathaiva sopi bahudu.hkha.m praapyaavaj naasyate| ");
INSERT INTO sanvel_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvaha.m yu.smaan vadaami , eliyaarthe lipi ryathaaste tathaiva sa etya yayau, lokaa: svecchaanuruupa.m tamabhivyavaharanti sma| ");
INSERT INTO sanvel_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantara.m sa \"si.syasamiipametya te.saa.m catu.hpaar\"sve tai.h saha bahujanaan vivadamaanaan adhyaapakaa.m\"sca d.r.s.tavaan; ");
INSERT INTO sanvel_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalokaasta.m d.r.s.tvaiva camatk.rtya tadaasanna.m dhaavantasta.m pra.nemu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadaa yii\"suradhyaapakaanapraak.siid etai.h saha yuuya.m ki.m vivadadhve? ");
INSERT INTO sanvel_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tato lokaanaa.m ka\"scideka.h pratyavaadiit he guro mama suunu.m muuka.m bhuutadh.rta nca bhavadaasannam aanaya.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadaasau bhuutastamaakramate tadaiva paatasati tathaa sa phe.naayate, dantairdantaan ghar.sati k.sii.no bhavati ca; tato hetosta.m bhuuta.m tyaajayitu.m bhavacchi.syaan niveditavaan kintu te na \"seku.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadaa sa tamavaadiit, re avi\"svaasina.h santaanaa yu.smaabhi.h saha kati kaalaanaha.m sthaasyaami? aparaan kati kaalaan vaa va aacaaraan sahi.sye? ta.m madaasannamaanayata| ");
INSERT INTO sanvel_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhi.m sa aaniiyata kintu ta.m d.r.s.tvaiva bhuuto baalaka.m dh.rtavaan; sa ca bhuumau patitvaa phe.naayamaano lulo.tha| ");
INSERT INTO sanvel_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadaa sa tatpitara.m papraccha, asyed.r\"sii da\"saa kati dinaani bhuutaa? tata.h sovaadiit baalyakaalaat| ");
INSERT INTO sanvel_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhuutoya.m ta.m naa\"sayitu.m bahuvaaraan vahnau jale ca nyak.sipat kintu yadi bhavaana kimapi karttaa.m \"saknoti tarhi dayaa.m k.rtvaasmaan upakarotu| ");
INSERT INTO sanvel_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadaa yii\"sustamavadat yadi pratyetu.m \"sakno.si tarhi pratyayine janaaya sarvva.m saadhyam| ");
INSERT INTO sanvel_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatk.sa.na.m tadbaalakasya pitaa proccai ruuvan saa\"srunetra.h provaaca, prabho pratyemi mamaapratyaya.m pratikuru| ");
INSERT INTO sanvel_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yii\"su rlokasa\"ngha.m dhaavitvaayaanta.m d.r.s.tvaa tamapuutabhuuta.m tarjayitvaa jagaada, re badhira muuka bhuuta tvametasmaad bahirbhava puna.h kadaapi maa\"srayaina.m tvaamaham ityaadi\"saami| ");
INSERT INTO sanvel_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadaa sa bhuuta\"sciit\"sabda.m k.rtvaa tamaapii.dya bahirjajaama, tato baalako m.rtakalpo babhuuva tasmaadaya.m m.rta_ityaneke kathayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu kara.m dh.rtvaa yii\"sunotthaapita.h sa uttasthau| ");
INSERT INTO sanvel_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yii\"sau g.rha.m pravi.s.te \"si.syaa gupta.m ta.m papracchu.h, vayamena.m bhuuta.m tyaajayitu.m kuto na \"saktaa.h? ");
INSERT INTO sanvel_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvaaca, praarthanopavaasau vinaa kenaapyanyena karmma.naa bhuutamiid.r\"sa.m tyaajayitu.m na \"sakya.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantara.m sa tatsthaanaaditvaa gaaliilmadhyena yayau, kintu tat kopi jaaniiyaaditi sa naicchat| ");
INSERT INTO sanvel_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","apara nca sa \"si.syaanupadi\"san babhaa.se, naraputro narahaste.su samarpayi.syate te ca ta.m hani.syanti taistasmin hate t.rtiiyadine sa utthaasyatiiti| ");
INSERT INTO sanvel_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathaa.m te naabudhyanta pra.s.tu nca bibhya.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yii\"su.h kapharnaahuumpuramaagatya madhyeg.rha ncetya taanap.rcchad vartmamadhye yuuyamanyonya.m ki.m vivadadhve sma? ");
INSERT INTO sanvel_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu te niruttaraastasthu ryasmaatte.saa.m ko mukhya iti vartmaani te.anyonya.m vyavadanta| ");
INSERT INTO sanvel_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tata.h sa upavi\"sya dvaada\"sa\"si.syaan aahuuya babhaa.se ya.h ka\"scit mukhyo bhavitumicchati sa sarvvebhyo gau.na.h sarvve.saa.m sevaka\"sca bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadaa sa baalakameka.m g.rhiitvaa madhye samupaave\"sayat tatasta.m kro.de k.rtvaa taanavaadaat ");
INSERT INTO sanvel_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ya.h ka\"scidiid.r\"sasya kasyaapi baalasyaatithya.m karoti sa mamaatithya.m karoti; ya.h ka\"scinmamaatithya.m karoti sa kevalam mamaatithya.m karoti tanna matprerakasyaapyaatithya.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yohan tamabraviit he guro, asmaakamananugaaminam eka.m tvaannaamnaa bhuutaan tyaajayanta.m vaya.m d.r.s.tavanta.h, asmaakamapa\"scaadgaamitvaacca ta.m nya.sedhaama| ");
INSERT INTO sanvel_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yii\"suravadat ta.m maa ni.sedhat, yato ya.h ka\"scin mannaamnaa citra.m karmma karoti sa sahasaa maa.m ninditu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathaa ya.h ka\"scid yu.smaaka.m vipak.sataa.m na karoti sa yu.smaakameva sapak.sa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ya.h ka\"scid yu.smaan khrii.s.ta\"si.syaan j naatvaa mannaamnaa ka.msaikena paaniiya.m paatu.m dadaati, yu.smaanaha.m yathaartha.m vacmi, sa phalena va ncito na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi ka\"scin mayi vi\"svaasinaame.saa.m k.sudrapraa.ninaam ekasyaapi vighna.m janayati, tarhi tasyaitatkarmma kara.naat ka.n.thabaddhape.sa.niikasya tasya saagaraagaadhajala majjana.m bhadra.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ata.h svakaro yadi tvaa.m baadhate tarhi ta.m chindhi; ");
INSERT INTO sanvel_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmaat yatra kii.taa na mriyante vahni\"sca na nirvvaati, tasmin anirvvaa.naanalanarake karadvayavastava gamanaat karahiinasya svargaprave\"sastava k.sema.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava paado vighna.m janayati tarhi ta.m chindhi, ");
INSERT INTO sanvel_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yato yatra kii.taa na mriyante vahni\"sca na nirvvaati, tasmin .anirvvaa.navahnau narake dvipaadavatastava nik.sepaat paadahiinasya svargaprave\"sastava k.sema.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanetra.m yadi tvaa.m baadhate tarhi tadapyutpaa.taya, yato yatra kii.taa na mriyante vahni\"sca na nirvvaati, ");
INSERT INTO sanvel_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina .anirvvaa.navahnau narake dvinetrasya tava nik.sepaad ekanetravata ii\"svararaajye prave\"sastava k.sema.m| ");
INSERT INTO sanvel_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathaa sarvvo bali rlava.naakta.h kriyate tathaa sarvvo jano vahniruupe.na lava.naakta.h kaari.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lava.na.m bhadra.m kintu yadi lava.ne svaadutaa na ti.s.thati, tarhi katham aasvaadyukta.m kari.syatha? yuuya.m lava.nayuktaa bhavata paraspara.m prema kuruta| ");
INSERT INTO sanvel_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantara.m sa tatsthaanaat prasthaaya yarddananadyaa.h paare yihuudaaprade\"sa upasthitavaan, tatra tadantike lokaanaa.m samaagame jaate sa nijariityanusaare.na punastaan upadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadaa phiruu\"sinastatsamiipam etya ta.m pariik.situ.m papraccha.h svajaayaa manujaanaa.m tyajyaa na veti? ");
INSERT INTO sanvel_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tata.h sa pratyavaadiit, atra kaaryye muusaa yu.smaan prati kimaaj naapayat? ");
INSERT INTO sanvel_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta uucu.h tyaagapatra.m lekhitu.m svapatnii.m tyaktu nca muusaa.anumanyate| ");
INSERT INTO sanvel_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadaa yii\"su.h pratyuvaaca, yu.smaaka.m manasaa.m kaa.thinyaaddheto rmuusaa nide\"samimam alikhat| ");
INSERT INTO sanvel_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu s.r.s.teraadau ii\"svaro naraan pu.mruupe.na striiruupe.na ca sasarja| ");
INSERT INTO sanvel_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tata.h kaara.naat pumaan pitara.m maatara nca tyaktvaa svajaayaayaam aasakto bhavi.syati, ");
INSERT INTO sanvel_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvaav ekaa\"ngau bhavi.syata.h|\" tasmaat tatkaalamaarabhya tau na dvaav ekaa\"ngau| ");
INSERT INTO sanvel_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ata.h kaara.naad ii\"svaro yadayojayat kopi narastanna viyejayet| ");
INSERT INTO sanvel_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yii\"su rg.rha.m pravi.s.tastadaa \"si.syaa.h punastatkathaa.m ta.m papracchu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tata.h sovadat ka\"scid yadi svabhaaryyaa.m tyaktavaanyaam udvahati tarhi sa svabhaaryyaayaa.h praatikuulyena vyabhicaarii bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kaacinnaarii yadi svapati.m hitvaanyapu.msaa vivaahitaa bhavati tarhi saapi vyabhicaari.nii bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathaa \"si\"suun sp.r\"set, tadartha.m lokaistadantika.m \"si\"sava aaniiyanta, kintu \"si.syaastaanaaniitavatastarjayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yii\"sustad d.r.s.tvaa krudhyan jagaada, mannika.tam aagantu.m \"si\"suun maa vaarayata, yata etaad.r\"saa ii\"svararaajyaadhikaari.na.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yu.smaanaha.m yathaartha.m vacmi, ya.h ka\"scit \"si\"suvad bhuutvaa raajyamii\"svarasya na g.rhliiyaat sa kadaapi tadraajya.m prave.s.tu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananatara.m sa \"si\"suuna\"nke nidhaaya te.saa.m gaatre.su hastau dattvaa\"si.sa.m babhaa.se| ");
INSERT INTO sanvel_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanaa yaati, etarhi jana eko dhaavan aagatya tatsammukhe jaanunii paatayitvaa p.r.s.tavaan, bho.h paramaguro, anantaayu.h praaptaye mayaa ki.m karttavya.m? ");
INSERT INTO sanvel_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadaa yii\"suruvaaca, maa.m parama.m kuto vadasi? vine\"svara.m kopi paramo na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrii.m naabhigaccha; nara.m maa ghaataya; steya.m maa kuru; m.r.saasaak.sya.m maa dehi; hi.msaa nca maa kuru; pitarau sammanyasva; nide\"saa ete tvayaa j naataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyukta.m, he guro baalyakaalaadaha.m sarvvaanetaan aacaraami| ");
INSERT INTO sanvel_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadaa yii\"susta.m vilokya snehena babhaa.se, tavaikasyaabhaava aaste; tva.m gatvaa sarvvasva.m vikriiya daridrebhyo vi\"sraa.naya, tata.h svarge dhana.m praapsyasi; tata.h param etya kru\"sa.m vahan madanuvarttii bhava| ");
INSERT INTO sanvel_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamaanatvaat sa imaa.m kathaamaakar.nya vi.sa.no du.hkhita\"sca san jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yii\"su\"scaturdi\"so niriik.sya \"si.syaan avaadiit, dhanilokaanaam ii\"svararaajyaprave\"sa.h kiid.rg du.skara.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathaata.h \"si.syaa\"scamaccakru.h, kintu sa punaravadat, he baalakaa ye dhane vi\"svasanti te.saam ii\"svararaajyaprave\"sa.h kiid.rg du.skara.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ii\"svararaajye dhaninaa.m prave\"saat suucirandhre.na mahaa\"ngasya gamanaagamana.m sukara.m| ");
INSERT INTO sanvel_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadaa \"si.syaa atiiva vismitaa.h paraspara.m procu.h, tarhi ka.h paritraa.na.m praaptu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tato yii\"sustaan vilokya babhaa.se, tan narasyaasaadhya.m kintu ne\"svarasya, yato hetorii\"svarasya sarvva.m saadhyam| ");
INSERT INTO sanvel_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadaa pitara uvaaca, pa\"sya vaya.m sarvva.m parityajya bhavatonugaamino jaataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tato yii\"su.h pratyavadat, yu.smaanaha.m yathaartha.m vadaami, madartha.m susa.mvaadaartha.m vaa yo jana.h sadana.m bhraatara.m bhaginii.m pitara.m maatara.m jaayaa.m santaanaan bhuumi vaa tyaktvaa ");
INSERT INTO sanvel_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","g.rhabhraat.rbhaginiipit.rmaat.rpatniisantaanabhuumiinaamiha \"satagu.naan pretyaanantaayu\"sca na praapnoti taad.r\"sa.h kopi naasti| ");
INSERT INTO sanvel_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagriiyaa aneke lokaa.h \"se.saa.h, \"se.siiyaa aneke lokaa\"scaagraa bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yiruu\"saalamyaanakaale yii\"suste.saam agragaamii babhuuva, tasmaatte citra.m j naatvaa pa\"scaadgaamino bhuutvaa bibhyu.h| tadaa sa puna rdvaada\"sa\"si.syaan g.rhiitvaa sviiya.m yadyad gha.ti.syate tattat tebhya.h kathayitu.m praarebhe; ");
INSERT INTO sanvel_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","pa\"syata vaya.m yiruu\"saalampura.m yaama.h, tatra manu.syaputra.h pradhaanayaajakaanaam upaadhyaayaanaa nca kare.su samarpayi.syate; te ca vadhada.n.daaj naa.m daapayitvaa parade\"siiyaanaa.m kare.su ta.m samarpayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","te tamupahasya ka\"sayaa prah.rtya tadvapu.si ni.s.thiiva.m nik.sipya ta.m hani.syanti, tata.h sa t.rtiiyadine protthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tata.h sivade.h putrau yaakuubyohanau tadantikam etya procatu.h, he guro yad aavaabhyaa.m yaaci.syate tadasmadartha.m bhavaan karotu nivedanamidamaavayo.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tata.h sa kathitavaan, yuvaa.m kimicchatha.h? ki.m mayaa yu.smadartha.m kara.niiya.m? ");
INSERT INTO sanvel_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadaa tau procatu.h, aavayoreka.m dak.si.napaar\"sve vaamapaar\"sve caika.m tavai\"svaryyapade samupave.s.tum aaj naapaya| ");
INSERT INTO sanvel_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yii\"su.h pratyuvaaca yuvaamaj naatveda.m praarthayethe, yena ka.msenaaha.m paasyaami tena yuvaabhyaa.m ki.m paatu.m \"sak.syate? yasmin majjanenaaha.m majji.sye tanmajjane majjayitu.m ki.m yuvaabhyaa.m \"sak.syate? tau pratyuucatu.h \"sak.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadaa yii\"suravadat yena ka.msenaaha.m paasyaami tenaava\"sya.m yuvaamapi paasyatha.h, yena majjanena caaha.m majjiyye tatra yuvaamapi majji.syethe| ");
INSERT INTO sanvel_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu ye.saamartham ida.m niruupita.m, taan vihaayaanya.m kamapi mama dak.si.napaar\"sve vaamapaar\"sve vaa samupave\"sayitu.m mamaadhikaaro naasti| ");
INSERT INTO sanvel_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athaanyada\"sa\"si.syaa imaa.m kathaa.m \"srutvaa yaakuubyohanbhyaa.m cukupu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yii\"sustaan samaahuuya babhaa.se, anyade\"siiyaanaa.m raajatva.m ye kurvvanti te te.saameva prabhutva.m kurvvanti, tathaa ye mahaalokaaste te.saam adhipatitva.m kurvvantiiti yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yu.smaaka.m madhye na tathaa bhavi.syati, yu.smaaka.m madhye ya.h praadhaanya.m vaa nchati sa yu.smaaka.m sevako bhavi.syati, ");
INSERT INTO sanvel_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yu.smaaka.m yo mahaan bhavitumicchati sa sarvve.saa.m ki\"nkaro bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yato manu.syaputra.h sevyo bhavitu.m naagata.h sevaa.m karttaa.m tathaaneke.saa.m paritraa.nasya muulyaruupasvapraa.na.m daatu ncaagata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha te yiriihonagara.m praaptaastasmaat \"si.syai rlokai\"sca saha yii\"so rgamanakaale .tiimayasya putro bar.tiimayanaamaa andhastanmaargapaar\"sve bhik.saartham upavi.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa naasaratiiyasya yii\"soraagamanavaarttaa.m praapya procai rvaktumaarebhe, he yii\"so daayuuda.h santaana maa.m dayasva| ");
INSERT INTO sanvel_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatoneke lokaa mauniibhaveti ta.m tarjayaamaasu.h, kintu sa punaradhikamuccai rjagaada, he yii\"so daayuuda.h santaana maa.m dayasva| ");
INSERT INTO sanvel_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadaa yii\"su.h sthitvaa tamaahvaatu.m samaadide\"sa, tato lokaastamandhamaahuuya babhaa.sire, he nara, sthiro bhava, utti.s.tha, sa tvaamaahvayati| ");
INSERT INTO sanvel_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadaa sa uttariiyavastra.m nik.sipya protthaaya yii\"so.h samiipa.m gata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tato yii\"sustamavadat tvayaa ki.m praarthyate? tubhyamaha.m ki.m kari.syaamii? tadaa sondhastamuvaaca, he guro madiiyaa d.r.s.tirbhavet| ");
INSERT INTO sanvel_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tato yii\"sustamuvaaca yaahi tava vi\"svaasastvaa.m svasthamakaar.siit, tasmaat tatk.sa.na.m sa d.r.s.ti.m praapya pathaa yii\"so.h pa\"scaad yayau| ");
INSERT INTO sanvel_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantara.m te.su yiruu\"saalama.h samiipasthayo rbaitphagiibaithaniiyapurayorantikastha.m jaitunanaamaadrimaagate.su yii\"su.h pre.sa.nakaale dvau \"si.syaavida.m vaakya.m jagaada, ");
INSERT INTO sanvel_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvaamamu.m sammukhastha.m graama.m yaata.m, tatra pravi\"sya yo nara.m naavahat ta.m garddabha\"saavaka.m drak.syathasta.m mocayitvaanayata.m| ");
INSERT INTO sanvel_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvaa.m karmmeda.m kuta.h kurutha.h? kathaamimaa.m yadi kopi p.rcchati tarhi prabhoratra prayojanamastiiti kathite sa \"siighra.m tamatra pre.sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvaa dvimaargamelane kasyacid dvaarasya paar\"sve ta.m garddabha\"saavaka.m praapya mocayata.h, ");
INSERT INTO sanvel_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","etarhi tatropasthitalokaanaa.m ka\"scid ap.rcchat, garddabha\"si\"su.m kuto mocayatha.h? ");
INSERT INTO sanvel_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadaa yii\"soraaj naanusaare.na tebhya.h pratyudite tatk.sa.na.m tamaadaatu.m te.anujaj nu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yii\"so.h sannidhi.m garddabha\"si\"sum aaniiya tadupari svavastraa.ni paatayaamaasatu.h; tata.h sa tadupari samupavi.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadaaneke pathi svavaasaa.msi paatayaamaasu.h, parai\"sca taru\"saakhaa\"schitavaa maarge vikiir.naa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","apara nca pa\"scaadgaamino.agragaamina\"sca sarvve janaa ucai.hsvare.na vaktumaarebhire, jaya jaya ya.h parame\"svarasya naamnaagacchati sa dhanya iti| ");
INSERT INTO sanvel_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathaasmaakama.m puurvvapuru.sasya daayuudo yadraajya.m parame\"svaranaamnaayaati tadapi dhanya.m, sarvvasmaaducchraaye svarge ii\"svarasya jayo bhavet| ");
INSERT INTO sanvel_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ittha.m yii\"su ryiruu\"saalami mandira.m pravi\"sya caturdiksthaani sarvvaa.ni vastuuni d.r.s.tavaan; atha saaya.mkaala upasthite dvaada\"sa\"si.syasahito baithaniya.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparehani baithaniyaad aagamanasamaye k.sudhaartto babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tato duure sapatramu.dumbarapaadapa.m vilokya tatra ki ncit phala.m praaptu.m tasya sannik.r.s.ta.m yayau, tadaanii.m phalapaatanasya samayo naagacchati| tatastatropasthita.h patraa.ni vinaa kimapyapara.m na praapya sa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyaarabhya kopi maanavastvatta.h phala.m na bhu njiita; imaa.m kathaa.m tasya \"si.syaa.h \"su\"sruvu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantara.m te.su yiruu\"saalamamaayaate.su yii\"su rmandira.m gatvaa tatrasthaanaa.m ba.nijaa.m mudraasanaani paaraavatavikret.r.naam aasanaani ca nyubjayaa ncakaara sarvvaan kret.rn vikret.r.m\"sca bahi\"scakaara| ");
INSERT INTO sanvel_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","apara.m mandiramadhyena kimapi paatra.m vo.dhu.m sarvvajana.m nivaarayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lokaanupadi\"san jagaada, mama g.rha.m sarvvajaatiiyaanaa.m praarthanaag.rham iti naamnaa prathita.m bhavi.syati etat ki.m \"saastre likhita.m naasti? kintu yuuya.m tadeva coraa.naa.m gahvara.m kurutha| ");
INSERT INTO sanvel_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imaa.m vaa.nii.m \"srutvaadhyaapakaa.h pradhaanayaajakaa\"sca ta.m yathaa naa\"sayitu.m \"saknuvanti tathoेpaaya.m m.rgayaamaasu.h, kintu tasyopade\"saat sarvve lokaa vismaya.m gataa ataste tasmaad bibhyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha saaya.msamaya upasthite yii\"surnagaraad bahirvavraaja| ");
INSERT INTO sanvel_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantara.m praata.hkaale te tena maarge.na gacchantastamu.dumbaramahiiruha.m samuula.m \"su.ska.m dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tata.h pitara.h puurvvavaakya.m smaran yii\"su.m babhaa.sa.m, he guro pa\"syatu ya u.dumbaravi.tapii bhavataa \"sapta.h sa \"su.sko babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tato yii\"su.h pratyavaadiit, yuuyamii\"svare vi\"svasita| ");
INSERT INTO sanvel_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yu.smaanaha.m yathaartha.m vadaami kopi yadyetadgiri.m vadati, tvamutthaaya gatvaa jaladhau pata, proktamida.m vaakyamava\"sya.m gha.ti.syate, manasaa kimapi na sandihya cedida.m vi\"svaset tarhi tasya vaakyaanusaare.na tad gha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ato hetoraha.m yu.smaan vacmi, praarthanaakaale yadyadaakaa.mk.si.syadhve tattadava\"sya.m praapsyatha, ittha.m vi\"svasita, tata.h praapsyatha| ");
INSERT INTO sanvel_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","apara nca yu.smaasu praarthayitu.m samutthite.su yadi kopi yu.smaakam aparaadhii ti.s.thati, tarhi ta.m k.samadhva.m, tathaa k.rte yu.smaaka.m svargastha.h pitaapi yu.smaakamaagaa.mmi k.sami.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na k.samadhve tarhi va.h svargastha.h pitaapi yu.smaakamaagaa.msi na k.sami.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantara.m te puna ryiruu\"saalama.m pravivi\"su.h, yii\"su ryadaa madhyemandiram itastato gacchati, tadaanii.m pradhaanayaajakaa upaadhyaayaa.h praa nca\"sca tadantikametya kathaamimaa.m papracchu.h, ");
INSERT INTO sanvel_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tva.m kenaade\"sena karmmaa.nyetaani karo.si? tathaitaani karmmaa.ni karttaa.m kenaadi.s.tosi? ");
INSERT INTO sanvel_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tato yii\"su.h pratigaditavaan ahamapi yu.smaan ekakathaa.m p.rcchaami, yadi yuuya.m tasyaa uttara.m kurutha, tarhi kayaaj nayaaha.m karmmaa.nyetaani karomi tad yu.smabhya.m kathayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yohano majjanam ii\"svaraat jaata.m ki.m maanavaat? tanmahya.m kathayata| ");
INSERT INTO sanvel_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","te paraspara.m vivektu.m praarebhire, tad ii\"svaraad babhuuveti ced vadaamastarhi kutasta.m na pratyaita? kathametaa.m kathayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","maanavaad abhavaditi ced vadaamastarhi lokebhyo bhayamasti yato heto.h sarvve yohana.m satya.m bhavi.syadvaadina.m manyante| ");
INSERT INTO sanvel_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataeva te yii\"su.m pratyavaadi.su rvaya.m tad vaktu.m na \"saknuma.h| yii\"suruvaaca, tarhi yenaade\"sena karmmaa.nyetaani karomi, ahamapi yu.smabhya.m tanna kathayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantara.m yii\"su rd.r.s.taantena tebhya.h kathayitumaarebhe, ka\"scideko draak.saak.setra.m vidhaaya taccaturdik.su vaara.nii.m k.rtvaa tanmadhye draak.saape.sa.naku.n.dam akhanat, tathaa tasya ga.damapi nirmmitavaan tatastatk.setra.m k.r.siivale.su samarpya duurade\"sa.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantara.m phalakaale k.r.siivalebhyo draak.saak.setraphalaani praaptu.m te.saa.m savidhe bh.rtyam eka.m praahi.not| ");
INSERT INTO sanvel_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu k.r.siivalaasta.m dh.rtvaa prah.rtya riktahasta.m visas.rju.h| ");
INSERT INTO sanvel_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tata.h sa punaranyameka.m bh.rtya.m pra.sayaamaasa, kintu te k.r.siivalaa.h paa.saa.naaghaataistasya \"siro bha\"nktvaa saapamaana.m ta.m vyasarjan| ");
INSERT INTO sanvel_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tata.h para.m sopara.m daasa.m praahi.not tadaa te ta.m jaghnu.h, evam aneke.saa.m kasyacit prahaara.h kasyacid vadha\"sca tai.h k.rta.h| ");
INSERT INTO sanvel_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tata.h para.m mayaa svaputre prahite te tamava\"sya.m samma.msyante, ityuktvaava\"se.se te.saa.m sannidhau nijapriyam advitiiya.m putra.m pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu k.r.siivalaa.h paraspara.m jagadu.h, e.sa uttaraadhikaarii, aagacchata vayamena.m hanmastathaa k.rte .adhikaaroyam asmaaka.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatasta.m dh.rtvaa hatvaa draak.saak.setraad bahi.h praak.sipan| ");
INSERT INTO sanvel_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anenaasau draak.saak.setrapati.h ki.m kari.syati? sa etya taan k.r.siivalaan sa.mhatya tatk.setram anye.su k.r.siivale.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","apara nca, \"sthapataya.h kari.syanti graavaa.na.m yantu tucchaka.m| praadhaanaprastara.h ko.ne sa eva sa.mbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","etat karmma pare\"sasyaa.mdbhuta.m no d.r.s.tito bhavet||\" imaa.m \"saastriiyaa.m lipi.m yuuya.m ki.m naapaa.thi.s.ta? ");
INSERT INTO sanvel_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadaanii.m sa taanuddi\"sya taa.m d.r.s.taantakathaa.m kathitavaan, ta ittha.m budvvaa ta.m dharttaamudyataa.h, kintu lokebhyo bibhyu.h, tadanantara.m te ta.m vihaaya vavraju.h| ");
INSERT INTO sanvel_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","apara nca te tasya vaakyado.sa.m dharttaa.m katipayaan phiruu\"sino herodiiyaa.m\"sca lokaan tadantika.m pre.sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta aagatya tamavadan, he guro bhavaan tathyabhaa.sii kasyaapyanurodha.m na manyate, pak.sapaata nca na karoti, yathaarthata ii\"svariiya.m maarga.m dar\"sayati vayametat prajaaniima.h, kaisaraaya karo deyo na vaa.m? vaya.m daasyaamo na vaa? ");
INSERT INTO sanvel_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa te.saa.m kapa.ta.m j naatvaa jagaada, kuto maa.m pariik.sadhve? eka.m mudraapaada.m samaaniiya maa.m dar\"sayata| ");
INSERT INTO sanvel_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadaa tairekasmin mudraapaade samaaniite sa taan papraccha, atra likhita.m naama muurtti rvaa kasya? te pratyuucu.h, kaisarasya| ");
INSERT INTO sanvel_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadaa yii\"suravadat tarhi kaisarasya dravyaa.ni kaisaraaya datta, ii\"svarasya dravyaa.ni tu ii\"svaraaya datta; tataste vismaya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha m.rtaanaamutthaana.m ye na manyante te siduukino yii\"so.h samiipamaagatya ta.m papracchu.h; ");
INSERT INTO sanvel_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","he guro ka\"scijjano yadi ni.hsantati.h san bhaaryyaayaa.m satyaa.m mriyate tarhi tasya bhraataa tasya bhaaryyaa.m g.rhiitvaa bhraatu rva.m\"sotpatti.m kari.syati, vyavasthaamimaa.m muusaa asmaan prati vyalikhat| ");
INSERT INTO sanvel_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kecit sapta bhraatara aasan, tataste.saa.m jye.s.thabhraataa vivahya ni.hsantati.h san amriyata| ");
INSERT INTO sanvel_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tato dvitiiyo bhraataa taa.m striyamag.rha.nat kintu sopi ni.hsantati.h san amriyata; atha t.rtiiyopi bhraataa taad.r\"sobhavat| ");
INSERT INTO sanvel_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ittha.m saptaiva bhraatarastaa.m striya.m g.rhiitvaa ni.hsantaanaa.h santo.amriyanta, sarvva\"se.se saapi strii mriyate sma| ");
INSERT INTO sanvel_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha m.rtaanaamutthaanakaale yadaa ta utthaasyanti tadaa te.saa.m kasya bhaaryyaa saa bhavi.syati? yataste saptaiva taa.m vyavahan| ");
INSERT INTO sanvel_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tato yii\"su.h pratyuvaaca \"saastram ii\"svara\"sakti nca yuuyamaj naatvaa kimabhraamyata na? ");
INSERT INTO sanvel_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","m.rtalokaanaamutthaana.m sati te na vivahanti vaagdattaa api na bhavanti, kintu svargiiyaduutaanaa.m sad.r\"saa bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","puna\"sca \"aham ibraahiima ii\"svara ishaaka ii\"svaro yaakuuba\"sce\"svara.h\" yaamimaa.m kathaa.m stambamadhye ti.s.than ii\"svaro muusaamavaadiit m.rtaanaamutthaanaarthe saa kathaa muusaalikhite pustake ki.m yu.smaabhi rnaapaa.thi? ");
INSERT INTO sanvel_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ii\"svaro jiivataa.m prabhu.h kintu m.rtaanaa.m prabhu rna bhavati, tasmaaddheto ryuuya.m mahaabhrame.na ti.s.thatha| ");
INSERT INTO sanvel_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","etarhi ekodhyaapaka etya te.saamittha.m vicaara.m \"su\"sraava; yii\"suste.saa.m vaakyasya saduttara.m dattavaan iti budvvaa ta.m p.r.s.tavaan sarvvaasaam aaj naanaa.m kaa \"sre.s.thaa? tato yii\"su.h pratyuvaaca, ");
INSERT INTO sanvel_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"he israayellokaa avadhatta, asmaaka.m prabhu.h parame\"svara eka eva, ");
INSERT INTO sanvel_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yuuya.m sarvvanta.hkara.nai.h sarvvapraa.nai.h sarvvacittai.h sarvva\"saktibhi\"sca tasmin prabhau parame\"svare priiyadhva.m,\" ityaaj naa \"sre.s.thaa| ");
INSERT INTO sanvel_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathaa \"svaprativaasini svavat prema kurudhva.m,\" e.saa yaa dvitiiyaaj naa saa taad.r\"sii; etaabhyaa.m dvaabhyaam aaj naabhyaam anyaa kaapyaaj naa \"sre.s.thaa naasti| ");
INSERT INTO sanvel_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadaa sodhyaapakastamavadat, he guro satya.m bhavaan yathaartha.m proktavaan yata ekasmaad ii\"svaraad anyo dvitiiya ii\"svaro naasti; ");
INSERT INTO sanvel_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","apara.m sarvvaanta.hkara.nai.h sarvvapraa.nai.h sarvvacittai.h sarvva\"saktibhi\"sca ii\"svare premakara.na.m tathaa svamiipavaasini svavat premakara.na nca sarvvebhyo homabalidaanaadibhya.h \"sra.s.tha.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tato yii\"su.h subuddheriva tasyedam uttara.m \"srutvaa ta.m bhaa.sitavaan tvamii\"svarasya raajyaanna duurosi|ita.h para.m tena saha kasyaapi vaakyasya vicaara.m karttaa.m kasyaapi pragalbhataa na jaataa| ");
INSERT INTO sanvel_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantara.m madhyemandiram upadi\"san yii\"surima.m pra\"sna.m cakaara, adhyaapakaa abhi.sikta.m (taaraka.m) kuto daayuuda.h santaana.m vadanti? ");
INSERT INTO sanvel_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svaya.m daayuud pavitrasyaatmana aave\"seneda.m kathayaamaasa| yathaa| \"mama prabhumida.m vaakyavadat parame\"svara.h| tava \"satruunaha.m yaavat paadapii.tha.m karomi na| taavat kaala.m madiiye tva.m dak.sapaar\"sv upaavi\"sa|\" ");
INSERT INTO sanvel_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi daayuud ta.m prabhuu.m vadati tarhi katha.m sa tasya santaano bhavitumarhati? itare lokaastatkathaa.m \"srutvaananandu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadaanii.m sa taanupadi\"sya kathitavaan ye naraa diirghaparidheyaani ha.t.te vipanau ca ");
INSERT INTO sanvel_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lokak.rtanamaskaaraan bhajanag.rhe pradhaanaasanaani bhojanakaale pradhaanasthaanaani ca kaa\"nk.sante; ");
INSERT INTO sanvel_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavaanaa.m sarvvasva.m grasitvaa chalaad diirghakaala.m praarthayante tebhya upaadhyaayebhya.h saavadhaanaa bhavata; te.adhikataraan da.n.daan praapsyanti| ");
INSERT INTO sanvel_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantara.m lokaa bhaa.n.daagaare mudraa yathaa nik.sipanti bhaa.n.daagaarasya sammukhe samupavi\"sya yii\"sustadavaluloka; tadaanii.m bahavo dhaninastasya madhye bahuuni dhanaani nirak.sipan| ");
INSERT INTO sanvel_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","pa\"scaad ekaa daridraa vidhavaa samaagatya dvipa.namuulyaa.m mudraikaa.m tatra nirak.sipat| ");
INSERT INTO sanvel_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadaa yii\"su.h \"si.syaan aahuuya kathitavaan yu.smaanaha.m yathaartha.m vadaami ye ye bhaa.n.daagaare.asmina dhanaani ni.hk.sipanti sma tebhya.h sarvvebhya iya.m vidhavaa daridraadhikam ni.hk.sipati sma| ");
INSERT INTO sanvel_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yataste prabhuutadhanasya ki ncit nirak.sipan kintu diineya.m svadinayaapanayogya.m ki ncidapi na sthaapayitvaa sarvvasva.m nirak.sipat| ");
INSERT INTO sanvel_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantara.m mandiraad bahirgamanakaale tasya \"si.syaa.naamekasta.m vyaah.rtavaan he guro pa\"syatu kiid.r\"saa.h paa.saa.naa.h kiid.rk ca nicayana.m| ");
INSERT INTO sanvel_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadaa yii\"sustam avadat tva.m kimetad b.rhannicayana.m pa\"syasi? asyaikapaa.saa.nopi dvitiiyapaa.saa.nopari na sthaasyati sarvve .adha.hk.sepsyante| ");
INSERT INTO sanvel_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kaale jaitungirau mandirasya sammukhe sa samupavi.s.tastasmin kaale pitaro yaakuub yohan aandriya\"scaite ta.m rahasi papracchu.h, ");
INSERT INTO sanvel_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","etaa gha.tanaa.h kadaa bhavi.syanti? tathaitatsarvvaasaa.m siddhyupakramasya vaa ki.m cihna.m? tadasmabhya.m kathayatu bhavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tato yaa\"sustaan vaktumaarebhe, kopi yathaa yu.smaan na bhraamayati tathaatra yuuya.m saavadhaanaa bhavata| ");
INSERT INTO sanvel_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yata.h khrii.s.tohamiti kathayitvaa mama naamnaaneke samaagatya lokaanaa.m bhrama.m janayi.syanti; ");
INSERT INTO sanvel_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yuuya.m ra.nasya vaarttaa.m ra.naa.dambara nca \"srutvaa maa vyaakulaa bhavata, gha.tanaa etaa ava\"syammaavinya.h; kintvaapaatato na yugaanto bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","de\"sasya vipak.satayaa de\"so raajyasya vipak.satayaa ca raajyamutthaasyati, tathaa sthaane sthaane bhuumikampo durbhik.sa.m mahaakle\"saa\"sca samupasthaasyanti, sarvva ete du.hkhasyaarambhaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yuuyam aatmaarthe saavadhaanaasti.s.thata, yato lokaa raajasabhaayaa.m yu.smaan samarpayi.syanti, tathaa bhajanag.rhe prahari.syanti; yuuya.m madarthe de\"saadhipaan bhuupaa.m\"sca prati saak.syadaanaaya te.saa.m sammukhe upasthaapayi.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","\"se.siibhavanaat puurvva.m sarvvaan de\"siiyaan prati susa.mvaada.h pracaarayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadaa te yu.smaan dh.rtvaa samarpayi.syanti tadaa yuuya.m yadyad uttara.m daasyatha, tadagra tasya vivecana.m maa kuruta tadartha.m ki ncidapi maa cintayata ca, tadaanii.m yu.smaaka.m mana.hsu yadyad vaakyam upasthaapayi.syate tadeva vadi.syatha, yato yuuya.m na tadvaktaara.h kintu pavitra aatmaa tasya vaktaa| ");
INSERT INTO sanvel_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadaa bhraataa bhraatara.m pitaa putra.m ghaatanaartha.m parahaste.su samarpayi.syate, tathaa patyaani maataapitro rvipak.satayaa tau ghaatayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama naamaheto.h sarvve.saa.m savidhe yuuya.m jugupsitaa bhavi.syatha, kintu ya.h ka\"scit \"se.saparyyanta.m dhairyyam aalambi.syate saeva paritraasyate| ");
INSERT INTO sanvel_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","daaniyelbhavi.syadvaadinaa prokta.m sarvvanaa\"si jugupsita nca vastu yadaa tvayogyasthaane vidyamaana.m drak.satha (yo jana.h pa.thati sa budhyataa.m) tadaa ye yihuudiiyade\"se ti.s.thanti te mahiidhra.m prati palaayantaa.m; ");
INSERT INTO sanvel_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathaa yo naro g.rhopari ti.s.thati sa g.rhamadhya.m naavarohatu, tathaa kimapi vastu grahiitu.m madhyeg.rha.m na pravi\"satu; ");
INSERT INTO sanvel_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathaa ca yo nara.h k.setre ti.s.thati sopi svavastra.m grahiitu.m paraav.rtya na vrajatu| ");
INSERT INTO sanvel_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadaanii.m garbbhavatiinaa.m stanyadaatrii.naa nca yo.sitaa.m durgati rbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yu.smaaka.m palaayana.m \"siitakaale yathaa na bhavati tadartha.m praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadaa yaad.r\"sii durgha.tanaa gha.ti.syate taad.r\"sii durgha.tanaa ii\"svaras.r.s.te.h prathamamaarabhyaadya yaavat kadaapi na jaataa na jani.syate ca| ");
INSERT INTO sanvel_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","apara nca parame\"svaro yadi tasya samayasya sa.mk.sepa.m na karoti tarhi kasyaapi praa.nabh.rto rak.saa bhavitu.m na \"sak.syati, kintu yaan janaan manoniitaan akarot te.saa.m svamanoniitaanaa.m heto.h sa tadanehasa.m sa.mk.sepsyati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyacca pa\"syata khrii.s.totra sthaane vaa tatra sthaane vidyate, tasminkaale yadi ka\"scid yu.smaan etaad.r\"sa.m vaakya.m vyaaharati, tarhi tasmin vaakye bhaiva vi\"svasita| ");
INSERT INTO sanvel_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatoneke mithyaakhrii.s.taa mithyaabhavi.syadvaadina\"sca samupasthaaya bahuuni cihnaanyadbhutaani karmmaa.ni ca dar\"sayi.syanti; tathaa yadi sambhavati tarhi manoniitalokaanaamapi mithyaamati.m janayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","pa\"syata gha.tanaata.h puurvva.m sarvvakaaryyasya vaarttaa.m yu.smabhyamadaam, yuuya.m saavadhaanaasti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","apara nca tasya kle\"sakaalasyaavyavahite parakaale bhaaskara.h saandhakaaro bhavi.syati tathaiva candra\"scandrikaa.m na daasyati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabha.hsthaani nak.satraa.ni pati.syanti, vyomama.n.dalasthaa grahaa\"sca vicali.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadaanii.m mahaaparaakrame.na mahai\"svaryye.na ca meghamaaruhya samaayaanta.m maanavasuta.m maanavaa.h samiik.si.syante| ");
INSERT INTO sanvel_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyacca sa nijaduutaan prahitya nabhobhuumyo.h siimaa.m yaavad jagata\"scaturdigbhya.h svamanoniitalokaan sa.mgrahii.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","u.dumbarataro rd.r.s.taanta.m \"sik.sadhva.m yado.dumbarasya taro rnaviinaa.h \"saakhaa jaayante pallavaadiini ca rnigacchanti, tadaa nidaaghakaala.h savidho bhavatiiti yuuya.m j naatu.m \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad etaa gha.tanaa d.r.s.tvaa sa kaalo dvaaryyupasthita iti jaaniita| ");
INSERT INTO sanvel_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yu.smaanaha.m yathaartha.m vadaami, aadhunikalokaanaa.m gamanaat puurvva.m taani sarvvaa.ni gha.ti.syante| ");
INSERT INTO sanvel_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyaavaap.rthivyo rvicalitayo.h satyo rmadiiyaa vaa.nii na vicali.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","apara nca svargasthaduutaga.no vaa putro vaa taataadanya.h kopi ta.m divasa.m ta.m da.n.da.m vaa na j naapayati| ");
INSERT INTO sanvel_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ata.h sa samaya.h kadaa bhavi.syati, etajj naanaabhaavaad yuuya.m saavadhaanaasti.s.thata, satarkaa\"sca bhuutvaa praarthayadhva.m; ");
INSERT INTO sanvel_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat ka\"scit pumaan svanive\"sanaad duurade\"sa.m prati yaatraakara.nakaale daase.su svakaaryyasya bhaaramarpayitvaa sarvvaan sve sve karmma.ni niyojayati; apara.m dauvaarika.m jaagaritu.m samaadi\"sya yaati, tadvan naraputra.h| ");
INSERT INTO sanvel_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","g.rhapati.h saaya.mkaale ni\"siithe vaa t.rtiiyayaame vaa praata.hkaale vaa kadaagami.syati tad yuuya.m na jaaniitha; ");
INSERT INTO sanvel_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa ha.thaadaagatya yathaa yu.smaan nidritaan na pa\"syati, tadartha.m jaagaritaasti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yu.smaanaha.m yad vadaami tadeva sarvvaan vadaami, jaagaritaasti.s.thateti| ");
INSERT INTO sanvel_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadaa nistaarotsavaki.nvahiinapuupotsavayoraarambhasya dinadvaye .ava\"si.s.te pradhaanayaajakaa adhyaapakaa\"sca kenaapi chalena yii\"su.m dharttaa.m hantu nca m.rgayaa ncakrire; ");
INSERT INTO sanvel_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lokaanaa.m kalahabhayaaduucire, nacotsavakaala ucitametaditi| ");
INSERT INTO sanvel_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantara.m baithaniyaapuुre \"simonaku.s.thino g.rhe yo\"sau bhotkumupavi.s.te sati kaacid yo.sit paa.n.darapaa.saa.nasya sampu.takena mahaarghyottamatailam aaniiya sampu.taka.m bha.mktvaa tasyottamaa\"nge tailadhaaraa.m paatayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmaat kecit svaante kupyanta.h kathitava.mnta.h kutoya.m tailaapavyaya.h? ");
INSERT INTO sanvel_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyetat taila vyakre.syata tarhi mudraapaada\"satatrayaadapyadhika.m tasya praaptamuulya.m daridralokebhyo daatuma\"sak.syata, kathaametaa.m kathayitvaa tayaa yo.sitaa saaka.m vaacaayuhyan| ");
INSERT INTO sanvel_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yii\"suruvaaca, kuta etasyai k.rcchra.m dadaasi? mahyamiya.m karmmottama.m k.rtavatii| ");
INSERT INTO sanvel_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridraa.h sarvvadaa yu.smaabhi.h saha ti.s.thanti, tasmaad yuuya.m yadecchatha tadaiva taanupakarttaa.m \"saknutha, kintvaha.m yubhaabhi.h saha nirantara.m na ti.s.thaami| ");
INSERT INTO sanvel_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyaa yathaasaadhya.m tathaivaakarodiya.m, \"sma\"saanayaapanaat puurvva.m sametya madvapu.si tailam amarddayat| ");
INSERT INTO sanvel_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","aha.m yu.smabhya.m yathaartha.m kathayaami, jagataa.m madhye yatra yatra susa.mvaadoya.m pracaarayi.syate tatra tatra yo.sita etasyaa.h smara.naartha.m tatk.rtakarmmaitat pracaarayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tata.h para.m dvaada\"saanaa.m \"si.syaa.naameka ii.skariyotiiyayihuudaakhyo yii\"su.m parakare.su samarpayitu.m pradhaanayaajakaanaa.m samiipamiyaaya| ");
INSERT INTO sanvel_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","te tasya vaakya.m samaakar.nya santu.s.taa.h santastasmai mudraa daatu.m pratyajaanata; tasmaat sa ta.m te.saa.m kare.su samarpa.naayopaaya.m m.rgayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantara.m ki.nva\"suunyapuupotsavasya prathame.ahani nistaarotmavaartha.m me.samaara.naasamaye \"si.syaasta.m papraccha.h kutra gatvaa vaya.m nistaarotsavasya bhojyamaasaadayi.syaama.h? kimicchati bhavaan? ");
INSERT INTO sanvel_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadaanii.m sa te.saa.m dvaya.m prerayan babhaa.se yuvayo.h puramadhya.m gatayo.h sato ryo jana.h sajalakumbha.m vahan yuvaa.m saak.saat kari.syati tasyaiva pa\"scaad yaata.m; ");
INSERT INTO sanvel_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadana.m pravek.syati tadbhavanapati.m vadata.m, gururaaha yatra sa\"si.syoha.m nistaarotsaviiya.m bhojana.m kari.syaami, saa bhojana\"saalaa kutraasti? ");
INSERT INTO sanvel_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tata.h sa pari.sk.rtaa.m susajjitaa.m b.rhatiica nca yaa.m \"saalaa.m dar\"sayi.syati tasyaamasmadartha.m bhojyadravyaa.nyaasaadayata.m| ");
INSERT INTO sanvel_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tata.h \"si.syau prasthaaya pura.m pravi\"sya sa yathoktavaan tathaiva praapya nistaarotsavasya bhojyadravyaa.ni samaasaadayetaam| ");
INSERT INTO sanvel_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantara.m yii\"su.h saaya.mkaale dvaada\"sabhi.h \"si.syai.h saarddha.m jagaama; ");
INSERT INTO sanvel_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvve.su bhojanaaya propavi.s.te.su sa taanuditavaan yu.smaanaha.m yathaartha.m vyaaharaami, atra yu.smaakameko jano yo mayaa saha bhu.mkte maa.m parakere.su samarpayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadaanii.m te du.hkhitaa.h santa ekaika\"sasta.m pra.s.tumaarabdhavanta.h sa kimaha.m? pa\"scaad anya ekobhidadhe sa kimaha.m? ");
INSERT INTO sanvel_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tata.h sa pratyavadad ete.saa.m dvaada\"saanaa.m yo jano mayaa sama.m bhojanaapaatre paa.ni.m majjayi.syati sa eva| ");
INSERT INTO sanvel_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yaad.r\"sa.m likhitamaaste tadanuruupaa gatistasya bhavi.syati, kintu yo jano maanavasuta.m samarpayi.syate hanta tasya janmaabhaave sati bhadramabhavi.syat| ");
INSERT INTO sanvel_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","apara nca te.saa.m bhojanasamaye yii\"su.h puupa.m g.rhiitve\"svaragu.naan anukiirtya bha\"nktvaa tebhyo dattvaa babhaa.se, etad g.rhiitvaa bhu njiidhvam etanmama vigraharuupa.m| ");
INSERT INTO sanvel_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantara.m sa ka.msa.m g.rhiitve\"svarasya gu.naan kiirttayitvaa tebhyo dadau, tataste sarvve papu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","apara.m sa taanavaadiid bahuunaa.m nimitta.m paatita.m mama naviinaniyamaruupa.m \"so.nitametat| ");
INSERT INTO sanvel_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yu.smaanaha.m yathaartha.m vadaami, ii\"svarasya raajye yaavat sadyojaata.m draak.saarasa.m na paasyaami,taavadaha.m draak.saaphalarasa.m puna rna paasyaami| ");
INSERT INTO sanvel_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantara.m te giitameka.m sa.mgiiya bahi rjaituna.m \"sikhari.na.m yayu.h ");
INSERT INTO sanvel_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yii\"sustaanuvaaca ni\"saayaamasyaa.m mayi yu.smaaka.m sarvve.saa.m pratyuuho bhavi.syati yato likhitamaaste yathaa, me.saa.naa.m rak.saka ncaaha.m prahari.syaami vai tata.h| me.saa.naa.m nivaho nuuna.m pravikiir.no bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthaane jaate yu.smaakamagre.aha.m gaaliila.m vraji.syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadaa pitara.h pratibabhaa.se, yadyapi sarvve.saa.m pratyuuho bhavati tathaapi mama naiva bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tato yii\"suruktaavaan aha.m tubhya.m tathya.m kathayaami, k.sa.naadaayaamadya kukku.tasya dvitiiyavaararava.naat puurvva.m tva.m vaaratraya.m maamapahno.syase| ");
INSERT INTO sanvel_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gaa.dha.m vyaaharad yadyapi tvayaa saarddha.m mama praa.no yaati tathaapi kathamapi tvaa.m naapahno.sye; sarvve.apiitare tathaiva babhaa.sire| ");
INSERT INTO sanvel_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","apara nca te.su get\"simaaniinaamaka.m sthaana gate.su sa \"si.syaan jagaada, yaavadaha.m praarthaye taavadatra sthaane yuuya.m samupavi\"sata| ");
INSERT INTO sanvel_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitara.m yaakuuba.m yohana nca g.rhiitvaa vavraaja; atyanta.m traasito vyaakulita\"sca tebhya.h kathayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakaalavat praa.no me.atiiva da.hkhameti, yuuya.m jaagratotra sthaane ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tata.h sa ki ncidduura.m gatvaa bhuumaavadhomukha.h patitvaa praarthitavaanetat, yadi bhavitu.m \"sakya.m tarhi du.hkhasamayoya.m matto duuriibhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavaan he pita rhe pita.h sarvve.m tvayaa saadhya.m, tato hetorima.m ka.msa.m matto duuriikuru, kintu tan mamecchaato na tavecchaato bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tata.h para.m sa etya taan nidritaan niriik.sya pitara.m provaaca, \"simon tva.m ki.m nidraasi? gha.tikaamekaam api jaagaritu.m na \"sakno.si? ");
INSERT INTO sanvel_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","pariik.saayaa.m yathaa na patatha tadartha.m sacetanaa.h santa.h praarthayadhva.m; mana udyuktamiti satya.m kintu vapura\"saktika.m| ");
INSERT INTO sanvel_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvaa puurvvavat praarthayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","paraav.rtyaagatya punarapi taan nidritaan dadar\"sa tadaa te.saa.m locanaani nidrayaa puur.naani, tasmaattasmai kaa kathaa kathayitavyaa ta etad boddhu.m na \"seku.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tata.hpara.m t.rtiiyavaara.m aagatya tebhyo .akathayad idaaniimapi \"sayitvaa vi\"sraamyatha? yathe.s.ta.m jaata.m, samaya\"scopasthita.h pa\"syata maanavatanaya.h paapilokaanaa.m paa.ni.su samarpyate| ");
INSERT INTO sanvel_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","utti.s.thata, vaya.m vrajaamo yo jano maa.m parapaa.ni.su samarpayi.syate pa\"syata sa samiipamaayaata.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imaa.m kathaa.m kathayati sa, etarhidvaada\"saanaameko yihuudaa naamaa \"si.sya.h pradhaanayaajakaanaam upaadhyaayaanaa.m praaciinalokaanaa nca sannidhe.h kha\"ngalagu.dadhaari.no bahulokaan g.rhiitvaa tasya samiipa upasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","apara ncaasau parapaa.ni.su samarpayitaa puurvvamiti sa\"nketa.m k.rtavaan yamaha.m cumbi.syaami sa evaasau tameva dh.rtvaa saavadhaana.m nayata| ");
INSERT INTO sanvel_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ato heto.h sa aagatyaiva yo\"so.h savidha.m gatvaa he guro he guro, ityuktvaa ta.m cucumba| ");
INSERT INTO sanvel_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadaa te tadupari paa.niinarpayitvaa ta.m dadhnu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya paar\"svasthaanaa.m lokaanaameka.h kha\"nga.m ni.sko.sayan mahaayaajakasya daasameka.m prah.rtya tasya kar.na.m ciccheda| ");
INSERT INTO sanvel_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","pa\"scaad yii\"sustaan vyaajahaara kha\"ngaan lagu.daa.m\"sca g.rhiitvaa maa.m ki.m caura.m dharttaa.m samaayaataa.h? ");
INSERT INTO sanvel_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyemandira.m samupadi\"san pratyaha.m yu.smaabhi.h saha sthitavaanataha.m, tasmin kaale yuuya.m maa.m naadiidharata, kintvanena \"saastriiya.m vacana.m sedhaniiya.m| ");
INSERT INTO sanvel_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadaa sarvve \"si.syaasta.m parityajya palaayaa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaiko yuvaa maanavo nagnakaaye vastrameka.m nidhaaya tasya pa\"scaad vrajan yuvalokai rdh.rto ");
INSERT INTO sanvel_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastra.m vihaaya nagna.h palaayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","apara nca yasmin sthaane pradhaanayaajakaa upaadhyaayaa.h praaciinalokaa\"sca mahaayaajakena saha sadasi sthitaastasmin sthaane mahaayaajakasya samiipa.m yii\"su.m ninyu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitaro duure tatpa\"scaad itvaa mahaayaajakasyaa.t.taalikaa.m pravi\"sya ki\"nkarai.h sahopavi\"sya vahnitaapa.m jagraaha| ");
INSERT INTO sanvel_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadaanii.m pradhaanayaajakaa mantri.na\"sca yii\"su.m ghaatayitu.m tatpraatikuulyena saak.si.no m.rgayaa ncakrire, kintu na praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anekaistadviruddha.m m.r.saasaak.sye dattepi te.saa.m vaakyaani na samagacchanta| ");
INSERT INTO sanvel_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvva\"se.se kiyanta utthaaya tasya praatikuulyena m.r.saasaak.sya.m dattvaa kathayaamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ida.m karak.rtamandira.m vinaa\"sya dinatrayamadhye punaraparam akarak.rta.m mandira.m nirmmaasyaami, iti vaakyam asya mukhaat \"srutamasmaabhiriti| ");
INSERT INTO sanvel_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatraapi te.saa.m saak.syakathaa na sa\"ngaataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahaayaajako madhyesabham utthaaya yii\"su.m vyaajahaara, ete janaastvayi yat saak.syamadu.h tvametasya kimapyuttara.m ki.m na daasyasi? ");
INSERT INTO sanvel_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttara.m na datvaa mauniibhuuya tasyau; tato mahaayaajaka.h punarapi ta.m p.r.s.taavaan tva.m saccidaanandasya tanayo .abhi.siktastrataa? ");
INSERT INTO sanvel_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadaa yii\"susta.m provaaca bhavaamyaham yuuya nca sarvva\"saktimato dak.sii.napaar\"sve samupavi\"santa.m megha maaruhya samaayaanta nca manu.syaputra.m sandrak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadaa mahaayaajaka.h sva.m vamana.m chitvaa vyaavaharat ");
INSERT INTO sanvel_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmaaka.m saak.sibhi.h prayojanam? ii\"svaranindaavaakya.m yu.smaabhira\"sraavi ki.m vicaarayatha? tadaanii.m sarvve jagaduraya.m nidhanada.n.damarhati| ");
INSERT INTO sanvel_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tata.h ka\"scit ka\"scit tadvapu.si ni.s.thiiva.m nicik.sepa tathaa tanmukhamaacchaadya cape.tena hatvaa gaditavaan ga.nayitvaa vada, anucaraa\"sca cape.taistamaajaghnu.h ");
INSERT INTO sanvel_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tata.h para.m pitare.a.t.taalikaadha.hko.s.the ti.s.thati mahaayaajakasyaikaa daasii sametya ");
INSERT INTO sanvel_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ta.m vihnitaapa.m g.rhlanta.m vilokya ta.m suniriik.sya babhaa.se tvamapi naasaratiiyayii\"so.h sa\"nginaam eko jana aasii.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sopahnutya jagaada tamaha.m na vadmi tva.m yat kathayami tadapyaha.m na buddhye| tadaanii.m pitare catvara.m gatavati kuेkku.to ruraava| ");
INSERT INTO sanvel_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athaanyaa daasii pitara.m d.r.s.tvaa samiipasthaan janaan jagaada aya.m te.saameko jana.h| ");
INSERT INTO sanvel_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tata.h sa dvitiiyavaaram apahnutavaan pa\"scaat tatrasthaa lokaa.h pitara.m procustvamava\"sya.m te.saameko jana.h yatastva.m gaaliiliiyo nara iti tavoccaara.na.m prakaa\"sayati| ");
INSERT INTO sanvel_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadaa sa \"sapathaabhi\"saapau k.rtvaa provaaca yuuya.m kathaa.m kathayatha ta.m nara.m na jaane.aha.m| ");
INSERT INTO sanvel_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadaanii.m dvitiiyavaara.m kukku.to .araaviit| kukku.tasya dvitiiyaravaat puurvva.m tva.m maa.m vaaratrayam apahno.syasi, iti yadvaakya.m yii\"sunaa samudita.m tat tadaa sa.msm.rtya pitaro roditum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhaate sati pradhaanayaajakaa.h praa nca upaadhyaayaa.h sarvve mantri.na\"sca sabhaa.m k.rtvaa yii\"suृ.m bandhayitva piilaataakhyasya de\"saadhipate.h savidha.m niitvaa samarpayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadaa piilaatasta.m p.r.s.tavaan tva.m ki.m yihuudiiyalokaanaa.m raajaa? tata.h sa pratyuktavaan satya.m vadasi| ");
INSERT INTO sanvel_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","apara.m pradhaanayaajakaastasya bahu.su vaakye.su do.samaaropayaa ncakru.h kintu sa kimapi na pratyuvaaca| ");
INSERT INTO sanvel_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadaanii.m piilaatasta.m puna.h papraccha tva.m ki.m nottarayasi? pa\"syaite tvadviruddha.m kati.su saadhye.su saak.sa.m dadati| ");
INSERT INTO sanvel_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yii\"sustadaapi nottara.m dadau tata.h piilaata aa\"scaryya.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","apara nca kaaraabaddhe kasti.m\"scit jane tanmahotsavakaale lokai ryaacite de\"saadhipatista.m mocayati| ");
INSERT INTO sanvel_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ye ca puurvvamupaplavamakaar.surupaplave vadhamapi k.rtavantaste.saa.m madhye tadaano.m barabbaanaamaka eko baddha aasiit| ");
INSERT INTO sanvel_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ato heto.h puurvvaapariiyaa.m riitikathaa.m kathayitvaa lokaa uccairuvanta.h piilaatasya samak.sa.m nivedayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadaa piilaatastaanaacakhyau tarhi ki.m yihuudiiyaanaa.m raajaana.m mocayi.syaami? yu.smaabhi.h kimi.syate? ");
INSERT INTO sanvel_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yata.h pradhaanayaajakaa iir.syaata eva yii\"su.m samaarpayanniti sa viveda| ");
INSERT INTO sanvel_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathaa barabbaa.m mocayati tathaa praarthayitu.m pradhaanayaajakaa lokaan pravarttayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha piilaata.h puna.h p.r.s.tavaan tarhi ya.m yihuudiiyaanaa.m raajeti vadatha tasya ki.m kari.syaami yu.smaabhi.h kimi.syate? ");
INSERT INTO sanvel_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadaa te punarapi proccai.h procusta.m kru\"se vedhaya| ");
INSERT INTO sanvel_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmaat piilaata.h kathitavaan kuta.h? sa ki.m kukarmma k.rtavaan? kintu te puna\"sca ruvanto vyaajahrusta.m kru\"se vedhaya| ");
INSERT INTO sanvel_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadaa piilaata.h sarvvaallokaan to.sayitumicchan barabbaa.m mocayitvaa yii\"su.m ka\"saabhi.h prah.rtya kru\"se veddhu.m ta.m samarpayaambabhuuva| ");
INSERT INTO sanvel_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantara.m sainyaga.no.a.t.taalikaam arthaad adhipate rg.rha.m yii\"su.m niitvaa senaanivaha.m samaahuyat| ");
INSERT INTO sanvel_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","pa\"scaat te ta.m dhuumalavar.navastra.m paridhaapya ka.n.takamuku.ta.m racayitvaa \"sirasi samaaropya ");
INSERT INTO sanvel_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","he yihuudiiyaanaa.m raajan namaskaara ityuktvaa ta.m namaskarttaamaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyottamaa\"nge vetraaghaata.m cakrustadgaatre ni.s.thiiva nca nicik.sipu.h, tathaa tasya sammukhe jaanupaata.m pra.nomu.h ");
INSERT INTO sanvel_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhuumravar.navastram uttaaryya tasya vastra.m ta.m paryyadhaapayan kru\"se veddhu.m bahirninyu\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tata.h para.m sekandarasya ruphasya ca pitaa \"simonnaamaa kurii.niiyaloka eka.h kuta\"scid graamaadetya pathi yaati ta.m te yii\"so.h kru\"sa.m vo.dhu.m balaad dadhnu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltaa arthaat \"sira.hkapaalanaamaka.m sthaana.m yii\"sumaaniiya ");
INSERT INTO sanvel_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","te gandharasami\"srita.m draak.saarasa.m paatu.m tasmai dadu.h kintu sa na jagraaha| ");
INSERT INTO sanvel_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin kru\"se viddhe sati te.saamekaika\"sa.h ki.m praapsyatiiti nir.nayaaya ");
INSERT INTO sanvel_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridheyaanaa.m vibhaagaartha.m gu.tikaapaata.m cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam e.sa yihuudiiyaanaa.m raajeti likhita.m do.sapatra.m tasya \"sirauurdvvam aaropayaa ncakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vaamadak.si.nayo rdvau caurau kru\"sayo rvividhaate| ");
INSERT INTO sanvel_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tenaiva \"aparaadhijanai.h saarddha.m sa ga.nito bhavi.syati,\" iti \"saastrokta.m vacana.m siddhamabhuuta| ");
INSERT INTO sanvel_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantara.m maarge ye ye lokaa gamanaagamane cakruste sarvva eva \"siraa.msyaandolya nindanto jagadu.h, re mandiranaa\"saka re dinatrayamadhye tannirmmaayaka, ");
INSERT INTO sanvel_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunaatmaanam avitvaa kru\"saadavaroha| ");
INSERT INTO sanvel_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ki nca pradhaanayaajakaa adhyaapakaa\"sca tadvat tirask.rtya paraspara.m cacak.sire e.sa paraanaavat kintu svamavitu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadiisraayelo raajaabhi.siktastraataa bhavati tarhyadhunaina kru\"saadavarohatu vaya.m tad d.r.s.tvaa vi\"svasi.syaama.h; ki nca yau lokau tena saarddha.m kru\"se .avidhyetaa.m taavapi ta.m nirbhartsayaamaasatu.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitiiyayaamaat t.rtiiyayaama.m yaavat sarvvo de\"sa.h saandhakaarobhuut| ");
INSERT INTO sanvel_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatast.rtiiyaprahare yii\"suruccairavadat elii elii laamaa \"sivaktanii arthaad \"he madii\"sa madii\"sa tva.m paryyatyaak.sii.h kuto hi maa.m?\" ");
INSERT INTO sanvel_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadaa samiipasthalokaanaa.m kecit tadvaakya.m ni\"samyaacakhyu.h pa\"syai.sa eliyam aahuuyati| ");
INSERT INTO sanvel_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata eko jano dhaavitvaagatya spa nje .amlarasa.m puurayitvaa ta.m na.daagre nidhaaya paatu.m tasmai dattvaavadat ti.s.tha eliya enamavarohayitum eti na veti pa\"syaami| ");
INSERT INTO sanvel_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yii\"suruccai.h samaahuuya praa.naan jahau| ");
INSERT INTO sanvel_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadaa mandirasya javanikordvvaadadha.hryyantaa vidiir.naa dvikha.n.daabhuut| ");
INSERT INTO sanvel_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ki nca itthamuccairaahuuya praa.naan tyajanta.m ta.m d.r.sdvaa tadrak.sa.naaya niyukto ya.h senaapatiraasiit sovadat naroyam ii\"svaraputra iti satyam| ");
INSERT INTO sanvel_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadaanii.m magdaliinii marisam kani.s.thayaakuubo yose\"sca maataanyamariyam \"saalomii ca yaa.h striyo ");
INSERT INTO sanvel_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gaaliilprade\"se yii\"su.m sevitvaa tadanugaaminyo jaataa imaastadanyaa\"sca yaa anekaa naaryo yii\"sunaa saarddha.m yiruu\"saalamamaayaataastaa\"sca duuraat taani dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athaasaadanadinasyaarthaad vi\"sraamavaaraat puurvvadinasya saaya.mkaala aagata ");
INSERT INTO sanvel_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ii\"svararaajyaapek.syarimathiiyayuu.saphanaamaa maanyamantrii sametya piilaatasavidha.m nirbhayo gatvaa yii\"sordeha.m yayaace| ");
INSERT INTO sanvel_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idaanii.m m.rta.h piilaata ityasambhava.m matvaa \"satasenaapatimaahuuya sa kadaa m.rta iti papraccha| ");
INSERT INTO sanvel_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","\"satasemanaapatimukhaat tajj naatvaa yuu.saphe yii\"sordeha.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","pa\"scaat sa suuk.sma.m vaasa.h kriitvaa yii\"so.h kaayamavarohya tena vaasasaa ve.s.taayitvaa girau khaata\"sma\"saane sthaapitavaan paa.saa.na.m lo.thayitvaa dvaari nidadhe| ");
INSERT INTO sanvel_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sosthaapyata tata magdaliinii mariyam yosimaat.rmariyam ca dad.r\"sat.r.h| ");
INSERT INTO sanvel_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha vi\"sraamavaare gate magdaliinii mariyam yaakuubamaataa mariyam \"saalomii cemaasta.m marddayitu.m sugandhidravyaa.ni kriitvaa ");
INSERT INTO sanvel_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptaahaprathamadine.atipratyuu.se suuryyodayakaale \"sma\"saanamupagataa.h| ");
INSERT INTO sanvel_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu \"sma\"saanadvaarapaa.saa.no.atib.rhan ta.m ko.apasaarayi.syatiiti taa.h paraspara.m gadanti! ");
INSERT INTO sanvel_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","etarhi niriik.sya paa.saa.no dvaaro .apasaarita iti dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","pa\"scaattaa.h \"sma\"saana.m pravi\"sya \"suklavar.nadiirghaparicchadaav.rtameka.m yuvaana.m \"sma\"saanadak.si.napaar\"sva upavi.s.ta.m d.r.s.tvaa camaccakru.h| ");
INSERT INTO sanvel_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","so.avadat, maabhai.s.ta yuuya.m kru\"se hata.m naasaratiiyayii\"su.m gave.sayatha sotra naasti \"sma\"saanaadudasthaat; tai ryatra sa sthaapita.h sthaana.m tadida.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tena yathokta.m tathaa yu.smaakamagre gaaliila.m yaasyate tatra sa yu.smaan saak.saat kari.syate yuuya.m gatvaa tasya \"si.syebhya.h pitaraaya ca vaarttaamimaa.m kathayata| ");
INSERT INTO sanvel_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","taa.h kampitaa vistitaa\"sca tuur.na.m \"sma\"saanaad bahirgatvaa palaayanta bhayaat kamapi kimapi naavada.m\"sca| ");
INSERT INTO sanvel_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","apara.m yii\"su.h saptaahaprathamadine pratyuu.se \"sma\"saanaadutthaaya yasyaa.h saptabhuutaastyaajitaastasyai magdaliiniimariyame prathama.m dar\"sana.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tata.h saa gatvaa \"sokarodanak.rdbhyo.anugatalokebhyastaa.m vaarttaa.m kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yii\"su.h punarjiivan tasyai dar\"sana.m dattavaaniti \"srutvaa te na pratyayan| ");
INSERT INTO sanvel_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","pa\"scaat te.saa.m dvaayo rgraamayaanakaale yii\"suranyave\"sa.m dh.rtvaa taabhyaa.m dar\"sana dadau! ");
INSERT INTO sanvel_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","taavapi gatvaanya\"si.syebhyastaa.m kathaa.m kathayaa ncakratu.h kintu tayo.h kathaamapi te na pratyayan| ");
INSERT INTO sanvel_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","\"se.sata ekaada\"sa\"si.sye.su bhojanopavi.s.te.su yii\"sustebhyo dar\"sana.m dadau tathotthaanaat para.m taddar\"sanapraaptalokaanaa.m kathaayaamavi\"svaasakara.naat te.saamavi\"svaasamana.hkaa.thinyaabhyaa.m hetubhyaa.m sa taa.mstarjitavaan| ");
INSERT INTO sanvel_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha taanaacakhyau yuuya.m sarvvajagad gatvaa sarvvajanaan prati susa.mvaada.m pracaarayata| ");
INSERT INTO sanvel_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra ya.h ka\"scid vi\"svasya majjito bhavet sa paritraasyate kintu yo na vi\"svasi.syati sa da.n.dayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ki nca ye pratye.syanti tairiid.rg aa\"scaryya.m karmma prakaa\"sayi.syate te mannaamnaa bhuutaan tyaajayi.syanti bhaa.saa anyaa\"sca vadi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","apara.m tai.h sarpe.su dh.rte.su praa.nanaa\"sakavastuni piite ca te.saa.m kaapi k.sati rna bhavi.syati; rogi.naa.m gaatre.su karaarpite te.arogaa bhavi.syanti ca| ");
INSERT INTO sanvel_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustaanityaadi\"sya svarga.m niita.h san parame\"svarasya dak.si.na upavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tataste prasthaaya sarvvatra susa.mvaadiiyakathaa.m pracaarayitumaarebhire prabhustu te.saa.m sahaaya.h san prakaa\"sitaa\"scaryyakriyaabhistaa.m kathaa.m pramaa.navatii.m cakaara| iti|");
INSERT INTO sanvel_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamato ye saak.si.no vaakyapracaarakaa\"scaasan te.asmaaka.m madhye yadyat sapramaa.na.m vaakyamarpayanti sma ");
INSERT INTO sanvel_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusaarato.anyepi bahavastadv.rttaanta.m racayitu.m prav.rttaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataeva he mahaamahimathiyaphil tva.m yaa yaa.h kathaa a\"sik.syathaastaasaa.m d.r.dhapramaa.naani yathaa praapno.si ");
INSERT INTO sanvel_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadartha.m prathamamaarabhya taani sarvvaa.ni j naatvaahamapi anukramaat sarvvav.rttaantaan tubhya.m lekhitu.m matimakaar.sam| ");
INSERT INTO sanvel_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihuudaade\"siiyaherodnaamake raajatva.m kurvvati abiiyayaajakasya paryyaayaadhikaarii sikhariyanaamaka eko yaajako haaro.nava.m\"sodbhavaa ilii\"sevaakhyaa ");
INSERT INTO sanvel_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jaayaa dvaavimau nirdo.sau prabho.h sarvvaaj naa vyavasthaa\"sca sa.mmanya ii\"svarad.r.s.tau dhaarmmikaavaastaam| ");
INSERT INTO sanvel_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayo.h santaana ekopi naasiit, yata ilii\"sevaa bandhyaa tau dvaaveva v.rddhaavabhavataam| ");
INSERT INTO sanvel_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadaa svaparyyaanukrame.na sikhariya ii\"svaasya samak.sa.m yaajakiiya.m karmma karoti ");
INSERT INTO sanvel_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadaa yaj nasya dinaparipaayyaa parame\"svarasya mandire prave\"sakaale dhuupajvaalana.m karmma tasya kara.niiyamaasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhuupajvaalanakaale lokanivahe praarthanaa.m kartu.m bahisti.s.thati ");
INSERT INTO sanvel_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyo yasyaa.m vedyaa.m dhuupa.m jvaalayati taddak.si.napaar\"sve parame\"svarasya duuta eka upasthito dar\"sana.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ta.m d.r.s.tvaa sikhariya udvivije \"sa\"sa\"nke ca| ");
INSERT INTO sanvel_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadaa sa duutasta.m babhaa.se he sikhariya maa bhaistava praarthanaa graahyaa jaataa tava bhaaryyaa ilii\"sevaa putra.m praso.syate tasya naama yoेhan iti kari.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ki nca tva.m saananda.h sahar.sa\"sca bhavi.syasi tasya janmani bahava aanandi.syanti ca| ");
INSERT INTO sanvel_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yato heto.h sa parame\"svarasya gocare mahaan bhavi.syati tathaa draak.saarasa.m suraa.m vaa kimapi na paasyati, apara.m janmaarabhya pavitre.naatmanaa paripuur.na.h ");
INSERT INTO sanvel_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san israayelva.m\"siiyaan anekaan prabho.h parame\"svarasya maargamaane.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santaanaan prati pit.r.naa.m manaa.msi dharmmaj naana.m pratyanaaj naagraahi.na\"sca paraavarttayitu.m, prabho.h parame\"svarasya sevaartham ekaa.m sajjitajaati.m vidhaatu nca sa eliyaruupaatma\"saktipraaptastasyaagre gami.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadaa sikhariyo duutamavaadiit kathametad vetsyaami? yatoha.m v.rddho mama bhaaryyaa ca v.rddhaa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tato duuta.h pratyuvaaca pa\"sye\"svarasya saak.saadvarttii jibraayelnaamaa duutoha.m tvayaa saha kathaa.m gaditu.m tubhyamimaa.m \"subhavaarttaa.m daatu nca pre.sita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madiiya.m vaakya.m kaale phali.syati tat tvayaa na pratiitam ata.h kaara.naad yaavadeva taani na setsyanti taavat tva.m vaktu.mma\"sakto muuko bhava| ");
INSERT INTO sanvel_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadaanii.m ye ye lokaa.h sikhariyamapaik.santa te madhyemandira.m tasya bahuvilambaad aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahiraagato yadaa kimapi vaakya.m vaktuma\"sakta.h sa\"nketa.m k.rtvaa ni.h\"sabdastasyau tadaa madhyemandira.m kasyacid dar\"sana.m tena praaptam iti sarvve bubudhire| ");
INSERT INTO sanvel_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantara.m tasya sevanaparyyaaye sampuur.ne sati sa nijageha.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadine.su gate.su tasya bhaaryyaa ilii\"sevaa garbbhavatii babhuuva ");
INSERT INTO sanvel_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","pa\"scaat saa pa ncamaasaan sa.mgopyaakathayat lokaanaa.m samak.sa.m mamaapamaana.m kha.n.dayitu.m parame\"svaro mayi d.r.s.ti.m paatayitvaa karmmed.r\"sa.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","apara nca tasyaa garbbhasya .sa.s.the maase jaate gaaliilprade\"siiyanaasaratpure ");
INSERT INTO sanvel_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","daayuudo va.m\"siiyaaya yuu.saphnaamne puru.saaya yaa mariyamnaamakumaarii vaagdattaasiit tasyaa.h samiipa.m jibraayel duuta ii\"svare.na prahita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvaa jagaada he ii\"svaraanug.rhiitakanye tava \"subha.m bhuuyaat prabhu.h parame\"svarastava sahaayosti naarii.naa.m madhye tvameva dhanyaa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadaanii.m saa ta.m d.r.s.tvaa tasya vaakyata udvijya kiid.r\"sa.m bhaa.sa.namidam iti manasaa cintayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tato duuto.avadat he mariyam bhaya.m maakaar.sii.h, tvayi parame\"svarasyaanugrahosti| ");
INSERT INTO sanvel_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","pa\"sya tva.m garbbha.m dh.rtvaa putra.m praso.syase tasya naama yii\"suriti kari.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahaan bhavi.syati tathaa sarvvebhya.h \"sre.s.thasya putra iti khyaasyati; apara.m prabhu.h parame\"svarastasya piturdaayuuda.h si.mhaasana.m tasmai daasyati; ");
INSERT INTO sanvel_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathaa sa yaakuubo va.m\"sopari sarvvadaa raajatva.m kari.syati, tasya raajatvasyaanto na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadaa mariyam ta.m duuta.m babhaa.se naaha.m puru.sasa\"nga.m karomi tarhi kathametat sambhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tato duuto.akathayat pavitra aatmaa tvaamaa\"sraayi.syati tathaa sarvva\"sre.s.thasya \"saktistavopari chaayaa.m kari.syati tato hetostava garbbhaad ya.h pavitrabaalako jani.syate sa ii\"svaraputra iti khyaati.m praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","apara nca pa\"sya tava j naatirilii\"sevaa yaa.m sarvve bandhyaamavadan idaanii.m saa vaarddhakye santaanameka.m garbbhe.adhaarayat tasya .sa.s.thamaasobhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma naasaadhyam ii\"svarasya| ");
INSERT INTO sanvel_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadaa mariyam jagaada, pa\"sya prabheraha.m daasii mahya.m tava vaakyaanusaare.na sarvvametad gha.tataam; ananatara.m duutastasyaa.h samiipaat pratasthe| ");
INSERT INTO sanvel_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadinaat para.m mariyam tasmaat parvvatamayaprade\"siiyayihuudaayaa nagarameka.m \"siighra.m gatvaa ");
INSERT INTO sanvel_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayaajakasya g.rha.m pravi\"sya tasya jaayaam ilii\"sevaa.m sambodhyaavadat| ");
INSERT INTO sanvel_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tato mariyama.h sambodhanavaakye ilii\"sevaayaa.h kar.nayo.h pravi.s.tamaatre sati tasyaa garbbhasthabaalako nanartta| tata ilii\"sevaa pavitre.naatmanaa paripuur.naa satii ");
INSERT INTO sanvel_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","proccairgaditumaarebhe, yo.sitaa.m madhye tvameva dhanyaa, tava garbbhastha.h \"si\"su\"sca dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tva.m prabhormaataa, mama nive\"sane tvayaa cara.naavarpitau, mamaadya saubhaagyametat| ");
INSERT INTO sanvel_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","pa\"sya tava vaakye mama kar.nayo.h pravi.s.tamaatre sati mamodarastha.h \"si\"suraanandaan nanartta| ");
INSERT INTO sanvel_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yaa strii vya\"svasiit saa dhanyaa, yato hetostaa.m prati parame\"svarokta.m vaakya.m sarvva.m siddha.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadaanii.m mariyam jagaada| dhanyavaada.m pare\"sasya karoti maamaka.m mana.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamaatmaa taarake\"se ca samullaasa.m pragacchati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarot sa prabhu rdu.s.ti.m svadaasyaa durgati.m prati| pa\"syaadyaarabhya maa.m dhanyaa.m vak.syanti puru.saa.h sadaa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ya.h sarvva\"saktimaan yasya naamaapi ca pavitraka.m| sa eva sumahatkarmma k.rtavaan mannimittaka.m| ");
INSERT INTO sanvel_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ye bibhyati janaastasmaat te.saa.m santaanapa.mkti.su| anukampaa tadiiyaa ca sarvvadaiva suti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabaahubalatastena praakaa\"syata paraakrama.h| mana.hkumantra.naasaarddha.m vikiiryyante.abhimaanina.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","si.mhaasanagataallokaan balina\"scaavarohya sa.h| pade.suucce.su lokaa.mstu k.sudraan sa.msthaapayatyapi| ");
INSERT INTO sanvel_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","k.sudhitaan maanavaan dravyairuttamai.h paritarpya sa.h| sakalaan dhanino lokaan vis.rjed riktahastakaan| ");
INSERT INTO sanvel_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibraahiimi ca tadva.m\"se yaa dayaasti sadaiva taa.m| sm.rtvaa puraa pit.r.naa.m no yathaa saak.saat prati\"sruta.m| ");
INSERT INTO sanvel_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","israayelsevakastena tathopakriyate svaya.m|| ");
INSERT INTO sanvel_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantara.m mariyam praaye.na maasatrayam ilii\"sevayaa saho.sitvaa vyaaghuyya nijanive\"sana.m yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilii\"sevaayaa.h prasavakaala upasthite sati saa putra.m praaso.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tata.h parame\"svarastasyaa.m mahaanugraha.m k.rtavaan etat \"srutvaa samiipavaasina.h ku.tumbaa\"scaagatya tayaa saha mumudire| ");
INSERT INTO sanvel_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathaa.s.tame dine te baalakasya tvaca.m chettum etya tasya pit.rnaamaanuruupa.m tannaama sikhariya iti karttumii.su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya maataakathayat tanna, naamaasya yohan iti karttavyam| ");
INSERT INTO sanvel_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadaa te vyaaharan tava va.m\"samadhye naamed.r\"sa.m kasyaapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tata.h para.m tasya pitara.m sikhariya.m prati sa\"nketya papracchu.h \"si\"so.h ki.m naama kaari.syate? ");
INSERT INTO sanvel_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tata.h sa phalakameka.m yaacitvaa lilekha tasya naama yohan bhavi.syati| tasmaat sarvve aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatk.sa.na.m sikhariyasya jihvaajaa.dye.apagate sa mukha.m vyaadaaya spa.s.tavar.namuccaaryya ii\"svarasya gu.naanuvaada.m cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmaaccaturdiksthaa.h samiipavaasilokaa bhiitaa evametaa.h sarvvaa.h kathaa yihuudaayaa.h parvvatamayaprade\"sasya sarvvatra pracaaritaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmaat \"srotaaro mana.hsu sthaapayitvaa kathayaambabhuuvu.h kiid.r\"soya.m baalo bhavi.syati? atha parame\"svarastasya sahaayobhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadaa yohana.h pitaa sikhariya.h pavitre.naatmanaa paripuur.na.h san etaad.r\"sa.m bhavi.syadvaakya.m kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","israayela.h prabhu ryastu sa dhanya.h parame\"svara.h| anug.rhya nijaallokaan sa eva parimocayet| ");
INSERT INTO sanvel_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipak.sajanahastebhyo yathaa mocyaamahe vaya.m| yaavajjiiva nca dharmme.na saaralyena ca nirbhayaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sevaamahai tamevaikam etatkaara.nameva ca| svakiiya.m supavitra nca sa.msm.rtya niyama.m sadaa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","k.rpayaa puru.saan puurvvaan nika.saarthaattu na.h pitu.h| ibraahiima.h samiipe ya.m \"sapatha.m k.rtavaan puraa| ");
INSERT INTO sanvel_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tameva saphala.m kartta.m tathaa \"satruga.nasya ca| .rृtiiyaakaari.na\"scaiva karebhyo rak.sa.naaya na.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","s.r.s.te.h prathamata.h sviiyai.h pavitrai rbhaavivaadibhi.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathoktavaan tathaa svasya daayuuda.h sevakasya tu| ");
INSERT INTO sanvel_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","va.m\"se traataarameka.m sa samutpaaditavaan svayam| ");
INSERT INTO sanvel_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ato he baalaka tvantu sarvvebhya.h \"sre.s.tha eva ya.h| tasyaiva bhaavivaadiiti pravikhyaato bhavi.syasi| asmaaka.m cara.naan k.seme maarge caalayitu.m sadaa| eva.m dhvaante.arthato m.rtyo\"schaayaayaa.m ye tu maanavaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upavi.s.taastu taaneva prakaa\"sayitumeva hi| k.rtvaa mahaanukampaa.m hi yaameva parame\"svara.h| ");
INSERT INTO sanvel_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","uurdvvaat suuryyamudaayyaivaasmabhya.m praadaattu dar\"sana.m| tayaanukampayaa svasya lokaanaa.m paapamocane| ");
INSERT INTO sanvel_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritraa.nasya tebhyo hi j naanavi\"sraa.nanaaya ca| prabho rmaarga.m pari.skarttu.m tasyaagraayii bhavi.syasi|| ");
INSERT INTO sanvel_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha baalaka.h \"sariire.na buddhyaa ca varddhitumaarebhe; apara nca sa israayelo va.m\"siiyalokaanaa.m samiipe yaavanna praka.tiibhuutastaastaavat praantare nyavasat| ");
INSERT INTO sanvel_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","apara nca tasmin kaale raajyasya sarvve.saa.m lokaanaa.m naamaani lekhayitum agastakaisara aaj naapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusaare.na kurii.niyanaamani suriyaade\"sasya \"saasake sati naamalekhana.m praarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ato heto rnaama lekhitu.m sarvve janaa.h sviiya.m sviiya.m nagara.m jagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadaanii.m yuu.saph naama lekhitu.m vaagdattayaa svabhaaryyayaa garbbhavatyaa mariyamaa saha svaya.m daayuuda.h sajaativa.m\"sa iti kaara.naad gaaliilprade\"sasya naasaratnagaraad ");
INSERT INTO sanvel_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihuudaaprade\"sasya baitlehamaakhya.m daayuudnagara.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyacca tatra sthaane tayosti.s.thato.h sato rmariyama.h prasuutikaala upasthite ");
INSERT INTO sanvel_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","saa ta.m prathamasuta.m praaso.s.ta kintu tasmin vaasag.rhe sthaanaabhaavaad baalaka.m vastre.na ve.s.tayitvaa go\"saalaayaa.m sthaapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantara.m ye kiyanto me.sapaalakaa.h svame.savrajarak.saayai tatprade\"se sthitvaa rajanyaa.m praantare prahari.na.h karmma kurvvanti, ");
INSERT INTO sanvel_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","te.saa.m samiipa.m parame\"svarasya duuta aagatyopatasthau; tadaa catu.spaar\"sve parame\"svarasya tejasa.h prakaa\"sitatvaat te.ati\"sa\"sa\"nkire| ");
INSERT INTO sanvel_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadaa sa duuta uvaaca maa bhai.s.ta pa\"syataadya daayuuda.h pure yu.smannimitta.m traataa prabhu.h khrii.s.to.ajani.s.ta, ");
INSERT INTO sanvel_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvve.saa.m lokaanaa.m mahaanandajanakam ima.m ma\"ngalav.rttaanta.m yu.smaan j naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yuuya.m (tatsthaana.m gatvaa) vastrave.s.tita.m ta.m baalaka.m go\"saalaayaa.m \"sayana.m drak.syatha yu.smaan pratiida.m cihna.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","duuta imaa.m kathaa.m kathitavati tatraakasmaat svargiiyaa.h p.rtanaa aagatya kathaam imaa.m kathayitve\"svarasya gu.naananvavaadi.su.h, yathaa, ");
INSERT INTO sanvel_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvordvvasthairii\"svarasya mahimaa samprakaa\"syataa.m| \"saantirbhuuyaat p.rthivyaastu santo.sa\"sca naraan prati|| ");
INSERT INTO sanvel_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tata.h para.m te.saa.m sannidhe rduutaga.ne svarga.m gate me.sapaalakaa.h parasparam avecan aagacchata prabhu.h parame\"svaro yaa.m gha.tanaa.m j naapitavaan tasyaa yaatharya.m j naatu.m vayamadhunaa baitlehampura.m yaama.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","pa\"scaat te tuur.na.m vrajitvaa mariyama.m yuu.sapha.m go\"saalaayaa.m \"sayana.m baalaka nca dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ittha.m d.r.s.tvaa baalakasyaarthe proktaa.m sarvvakathaa.m te praacaarayaa ncakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tato ye lokaa me.sarak.sakaa.naa.m vadanebhyastaa.m vaarttaa.m \"su\"sruvuste mahaa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam etatsarvvagha.tanaanaa.m taatparyya.m vivicya manasi sthaapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpa\"scaad duutavij naptaanuruupa.m \"srutvaa d.r.s.tvaa ca me.sapaalakaa ii\"svarasya gu.naanuvaada.m dhanyavaada nca kurvvaa.naa.h paraav.rtya yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha baalakasya tvakchedanakaale.a.s.tamadivase samupasthite tasya garbbhasthite.h purvva.m svargiiyaduuto yathaaj naapayat tadanuruupa.m te tannaamadheya.m yii\"suriti cakrire| ");
INSERT INTO sanvel_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tata.h para.m muusaalikhitavyavasthaayaa anusaare.na mariyama.h \"sucitvakaala upasthite, ");
INSERT INTO sanvel_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamaja.h sarvva.h puru.sasantaana.h parame\"svare samarpyataa.m,\" iti parame\"svarasya vyavasthayaa ");
INSERT INTO sanvel_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yii\"su.m parame\"svare samarpayitum \"saastriiyavidhyukta.m kapotadvaya.m paaraavata\"saavakadvaya.m vaa bali.m daatu.m te ta.m g.rhiitvaa yiruu\"saalamam aayayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yiruu\"saalampuranivaasii \"simiyonnaamaa dhaarmmika eka aasiit sa israayela.h saantvanaamapek.sya tasthau ki nca pavitra aatmaa tasminnaavirbhuuta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","apara.m prabhu.naa parame\"svare.naabhi.sikte traatari tvayaa na d.r.s.te tva.m na mari.syasiiti vaakya.m pavitre.na aatmanaa tasma praakathyata| ");
INSERT INTO sanvel_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","apara nca yadaa yii\"so.h pitaa maataa ca tadartha.m vyavasthaanuruupa.m karmma karttu.m ta.m mandiram aaninyatustadaa ");
INSERT INTO sanvel_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","\"simiyon aatmana aakar.sa.nena mandiramaagatya ta.m kro.de nidhaaya ii\"svarasya dhanyavaada.m k.rtvaa kathayaamaasa, yathaa, ");
INSERT INTO sanvel_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","he prabho tava daasoya.m nijavaakyaanusaarata.h| idaaniintu sakalyaa.no bhavataa sa.mvis.rjyataam| ");
INSERT INTO sanvel_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yata.h sakalade\"sasya diiptaye diiptiruupaka.m| ");
INSERT INTO sanvel_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","israayeliiyalokasya mahaagauravaruupaka.m| ");
INSERT INTO sanvel_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ya.m traayaka.m janaanaantu sammukhe tvamajiijana.h| saeva vidyate.asmaaka.m dhrava.m nayananagocare|| ");
INSERT INTO sanvel_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadaanii.m tenoktaa etaa.h sakalaa.h kathaa.h \"srutvaa tasya maataa yuu.saph ca vismaya.m menaate| ");
INSERT INTO sanvel_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tata.h para.m \"simiyon tebhya aa\"si.sa.m dattvaa tanmaatara.m mariyamam uvaaca, pa\"sya israayelo va.m\"samadhye bahuunaa.m paatanaayotthaapanaaya ca tathaa virodhapaatra.m bhavitu.m, bahuunaa.m guptamanogataanaa.m praka.tiikara.naaya baalakoya.m niyuktosti| ");
INSERT INTO sanvel_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmaat tavaapi praa.naa.h \"suulena vyatsyante| ");
INSERT INTO sanvel_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","apara nca aa\"serasya va.m\"siiyaphinuuyelo duhitaa hannaakhyaa atijaratii bhavi.syadvaadinyekaa yaa vivaahaat para.m sapta vatsaraan patyaa saha nyavasat tato vidhavaa bhuutvaa catura\"siitivar.savaya.hparyyanata.m ");
INSERT INTO sanvel_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandire sthitvaa praarthanopavaasairdivaani\"sam ii\"svaram asevata saapi strii tasmin samaye mandiramaagatya ");
INSERT INTO sanvel_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","parame\"svarasya dhanyavaada.m cakaara, yiruu\"saalampuravaasino yaavanto lokaa muktimapek.sya sthitaastaan yii\"sorv.rttaanta.m j naapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ittha.m parame\"svarasya vyavasthaanusaare.na sarvve.su karmmasu k.rte.su tau puna\"sca gaaliilo naasaratnaamaka.m nijanagara.m pratasthaate| ");
INSERT INTO sanvel_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpa\"scaad baalaka.h \"sariire.na v.rddhimetya j naanena paripuur.na aatmanaa \"saktimaa.m\"sca bhavitumaarebhe tathaa tasmin ii\"svaraanugraho babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitaa maataa ca prativar.sa.m nistaarotsavasamaye yiruu\"saalamam agacchataam| ");
INSERT INTO sanvel_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","apara nca yii\"sau dvaada\"savar.savayaske sati tau parvvasamayasya riityanusaare.na yiruu\"saalama.m gatvaa ");
INSERT INTO sanvel_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","paarvva.na.m sampaadya punarapi vyaaghuyya yaata.h kintu yii\"surbaalako yiruu\"saalami ti.s.thati| yuu.saph tanmaataa ca tad aviditvaa ");
INSERT INTO sanvel_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa sa\"ngibhi.h saha vidyata etacca budvvaa dinaikagamyamaarga.m jagmatu.h| kintu \"se.se j naatibandhuunaa.m samiipe m.rgayitvaa taduddeे\"samapraapya ");
INSERT INTO sanvel_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yiruu\"saalamam paraav.rtyaagatya ta.m m.rgayaa ncakratu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayaat para.m pa.n.ditaanaa.m madhye te.saa.m kathaa.h \"s.r.nvan tattva.m p.rccha.m\"sca mandire samupavi.s.ta.h sa taabhyaa.m d.r.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadaa tasya buddhyaa pratyuttarai\"sca sarvve \"srotaaro vismayamaapadyante| ");
INSERT INTO sanvel_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","taad.r\"sa.m d.r.s.tvaa tasya janako jananii ca camaccakratu.h ki nca tasya maataa tamavadat, he putra, kathamaavaa.m pratiittha.m samaacarastvam? pa\"sya tava pitaaha nca \"sokaakulau santau tvaamanvicchaava.h sma| ");
INSERT INTO sanvel_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tata.h sovadat kuto maam anvaicchata.m? piturg.rhe mayaa sthaatavyam etat ki.m yuvaabhyaa.m na j naayate? ");
INSERT INTO sanvel_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvaakyasya taatparyya.m boddhu.m naa\"saknutaa.m| ");
INSERT INTO sanvel_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tata.h para.m sa taabhyaa.m saha naasarata.m gatvaa tayorva\"siibhuutastasthau kintu sarvvaa etaa.h kathaastasya maataa manasi sthaapayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yii\"so rbuddhi.h \"sariira nca tathaa tasmin ii\"svarasya maanavaanaa ncaanugraho varddhitum aarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantara.m tibiriyakaisarasya raajatvasya pa ncada\"se vatsare sati yadaa pantiiyapiilaato yihuudaade\"saadhipati rherod tu gaaliilprade\"sasya raajaa philipanaamaa tasya bhraataa tu yituuriyaayaastraakhoniitiyaaprade\"sasya ca raajaasiit lu.saaniiyanaamaa aviliiniide\"sasya raajaasiit ");
INSERT INTO sanvel_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","haanan kiyaphaa\"scemau pradhaanayaajaakaavaastaa.m tadaanii.m sikhariyasya putraaya yohane madhyepraantaram ii\"svarasya vaakye prakaa\"site sati ");
INSERT INTO sanvel_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayata.taprade\"saan sametya paapamocanaartha.m mana.hparaavarttanasya cihnaruupa.m yanmajjana.m tadiiyaa.h kathaa.h sarvvatra pracaarayitumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yi\"sayiyabhavi.syadvakt.rgranthe yaad.r\"sii lipiraaste yathaa, parame\"sasya panthaana.m pari.skuruta sarvvata.h| tasya raajapatha ncaiva samaana.m kurutaadhunaa| ");
INSERT INTO sanvel_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kaari.syante samucchraayaa.h sakalaa nimnabhuumaya.h| kaari.syante nataa.h sarvve parvvataa\"scopaparvvataa.h| kaari.syante ca yaa vakraastaa.h sarvvaa.h saralaa bhuva.h| kaari.syante samaanaastaa yaa uccaniicabhuumaya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ii\"svare.na k.rta.m traa.na.m drak.syanti sarvvamaanavaa.h| ityetat praantare vaakya.m vadata.h kasyacid rava.h|| ");
INSERT INTO sanvel_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ye ye lokaa majjanaartha.m bahiraayayustaan sovadat re re sarpava.m\"saa aagaamina.h kopaat palaayitu.m yu.smaan ka\"scetayaamaasa? ");
INSERT INTO sanvel_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmaad ibraahiim asmaaka.m pitaa kathaamiid.r\"sii.m manobhi rna kathayitvaa yuuya.m mana.hparivarttanayogya.m phala.m phalata; yu.smaanaha.m yathaartha.m vadaami paa.saa.nebhya etebhya ii\"svara ibraahiima.h santaanotpaadane samartha.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","apara nca tarumuule.adhunaapi para\"su.h sa.mlagnosti yastaruruttama.m phala.m na phalati sa chidyate.agnau nik.sipyate ca| ");
INSERT INTO sanvel_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadaanii.m lokaasta.m papracchustarhi ki.m karttavyamasmaabhi.h? ");
INSERT INTO sanvel_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tata.h sovaadiit yasya dve vasane vidyete sa vastrahiinaayaika.m vitaratu ki.m nca yasya khaadyadravya.m vidyate sopi tathaiva karotu| ");
INSERT INTO sanvel_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tata.h para.m karasa ncaayino majjanaartham aagatya papracchu.h he guro ki.m karttavyamasmaabhi.h? ");
INSERT INTO sanvel_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tata.h sokathayat niruupitaadadhika.m na g.rhlita| ");
INSERT INTO sanvel_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantara.m senaaga.na etya papraccha kimasmaabhi rvaa karttavyam? tata.h sobhidadhe kasya kaamapi haani.m maa kaar.s.ta tathaa m.r.saapavaada.m maa kuruta nijavetanena ca santu.sya ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","apara nca lokaa apek.sayaa sthitvaa sarvvepiiti manobhi rvitarkayaa ncakru.h, yohanayam abhi.siktastraataa na veti? ");
INSERT INTO sanvel_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadaa yohan sarvvaan vyaajahaara, jale.aha.m yu.smaan majjayaami satya.m kintu yasya paadukaabandhana.m mocayitumapi na yogyosmi taad.r\"sa eko matto gurutara.h pumaan eti, sa yu.smaan vahniruupe pavitra aatmani majjayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","apara nca tasya haste \"suurpa aaste sa sva\"sasyaani \"suddharuupa.m praspho.tya godhuumaan sarvvaan bhaa.n.daagaare sa.mgrahii.syati kintu buu.saa.ni sarvvaa.nyanirvvaa.navahninaa daahayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yohan upade\"senettha.m naanaakathaa lokaanaa.m samak.sa.m pracaarayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","apara nca herod raajaa philipnaamna.h sahodarasya bhaaryyaa.m herodiyaamadhi tathaanyaani yaani yaani kukarmmaa.ni k.rtavaan tadadhi ca ");
INSERT INTO sanvel_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yohanaa tirask.rto bhuutvaa kaaraagaare tasya bandhanaad aparamapi kukarmma cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ita.h puurvva.m yasmin samaye sarvve yohanaa majjitaastadaanii.m yii\"surapyaagatya majjita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantara.m tena praarthite meghadvaara.m mukta.m tasmaacca pavitra aatmaa muurttimaan bhuutvaa kapotavat taduparyyavaruroha; tadaa tva.m mama priya.h putrastvayi mama parama.h santo.sa ityaakaa\"savaa.nii babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadaanii.m yii\"su.h praaye.na tri.m\"sadvar.savayaska aasiit| laukikaj naane tu sa yuu.sapha.h putra.h, ");
INSERT INTO sanvel_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yuu.saph ele.h putra.h, elirmattata.h putra.h, mattat leve.h putra.h, levi rmalke.h putra.h, malkiryaannasya putra.h; yaanno yuu.sapha.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yuu.saph mattathiyasya putra.h, mattathiya aamosa.h putra.h, aamos nahuuma.h putra.h, nahuum i.sle.h putra.h i.slirnage.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmaa.ta.h putra.h, maa.t mattathiyasya putra.h, mattathiya.h \"simiye.h putra.h, \"simiyiryuu.sapha.h putra.h, yuu.saph yihuudaa.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihuudaa yohaanaa.h putra.h, yohaanaa rii.saa.h putra.h, rii.saa.h sirubbaabila.h putra.h, sirubbaabil \"saltiiyela.h putra.h, \"saltiiyel nere.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nerirmalke.h putra.h, malki.h adya.h putra.h, addii ko.sama.h putra.h, ko.sam ilmodada.h putra.h, ilmodad era.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","er yo\"se.h putra.h, yo\"si.h iliiye.sara.h putra.h, iliiye.sar yoriima.h putra.h, yoriim mattata.h putra.h, mattata leve.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","levi.h \"simiyona.h putra.h, \"simiyon yihuudaa.h putra.h, yihuudaa yuu.supha.h putra.h, yuu.suph yonana.h putra.h, yaanan iliiyaakiima.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyaakiim.h mileyaa.h putra.h, mileyaa mainana.h putra.h, mainan mattattasya putra.h, mattatto naathana.h putra.h, naathan daayuuda.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","daayuud yi\"saya.h putra.h, yi\"saya obeda.h putra, obed boyasa.h putra.h, boyas salmona.h putra.h, salmon naha\"sona.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","naha\"son ammiinaadaba.h putra.h, ammiinaadab araama.h putra.h, araam hi.sro.na.h putra.h, hi.sro.n perasa.h putra.h, peras yihuudaa.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihuudaa yaakuuba.h putra.h, yaakuub ishaaka.h putra.h, ishaak ibraahiima.h putra.h, ibraahiim teraha.h putra.h, terah naahora.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","naahor siruga.h putra.h, sirug riyva.h putra.h, riyuu.h pelaga.h putra.h, pelag evara.h putra.h, evar \"selaha.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","\"selah kainana.h putra.h, kainan arphak.sada.h putra.h, arphak.sad \"saama.h putra.h, \"saam noha.h putra.h, noho lemaka.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lemak mithuu\"selaha.h putra.h, mithuu\"selah hanoka.h putra.h, hanok yerada.h putra.h, yerad mahalalela.h putra.h, mahalalel kainana.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan ino\"sa.h putra.h, ino\"s \"seta.h putra.h, \"set aadama.h putra, aadam ii\"svarasya putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tata.h para.m yii\"su.h pavitre.naatmanaa puur.na.h san yarddananadyaa.h paraav.rtyaatmanaa praantara.m niita.h san catvaari.m\"saddinaani yaavat \"saitaanaa pariik.sito.abhuut, ");
INSERT INTO sanvel_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ki nca taani sarvvadinaani bhojana.m vinaa sthitatvaat kaale puur.ne sa k.sudhitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tata.h \"saitaanaagatya tamavadat tva.m cedii\"svarasya putrastarhi prastaraanetaan aaj nayaa puupaan kuru| ");
INSERT INTO sanvel_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadaa yii\"suruvaaca, lipiriid.r\"sii vidyate manuja.h kevalena puupena na jiivati kintvii\"svarasya sarvvaabhiraaj naabhi rjiivati| ");
INSERT INTO sanvel_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadaa \"saitaan tamucca.m parvvata.m niitvaa nimi.saikamadhye jagata.h sarvvaraajyaani dar\"sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","pa\"scaat tamavaadiit sarvvam etad vibhava.m prataapa nca tubhya.m daasyaami tan mayi samarpitamaaste ya.m prati mamecchaa jaayate tasmai daatu.m \"saknomi, ");
INSERT INTO sanvel_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tva.m cenmaa.m bhajase tarhi sarvvametat tavaiva bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadaa yii\"susta.m pratyuktavaan duurii bhava \"saitaan lipiraaste, nija.m prabhu.m parame\"svara.m bhajasva kevala.m tameva sevasva ca| ");
INSERT INTO sanvel_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha \"saitaan ta.m yiruu\"saalama.m niitvaa mandirasya cuu.daayaa upari samupave\"sya jagaada tva.m cedii\"svarasya putrastarhi sthaanaadito lamphitvaadha.h ");
INSERT INTO sanvel_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yato lipiraaste, aaj naapayi.syati sviiyaan duutaan sa parame\"svara.h| ");
INSERT INTO sanvel_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rak.situ.m sarvvamaarge tvaa.m tena tvaccara.ne yathaa| na laget prastaraaghaatastvaa.m dhari.syanti te tathaa| ");
INSERT INTO sanvel_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadaa yii\"sunaa pratyuktam idamapyuktamasti tva.m svaprabhu.m pare\"sa.m maa pariik.sasva| ");
INSERT INTO sanvel_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","pa\"scaat \"saitaan sarvvapariik.saa.m samaapya k.sa.naatta.m tyaktvaa yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadaa yii\"suraatmaprabhaavaat punargaaliilprade\"sa.m gatastadaa tatsukhyaati\"scaturdi\"sa.m vyaana\"se| ");
INSERT INTO sanvel_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa te.saa.m bhajanag.rhe.su upadi\"sya sarvvai.h pra\"sa.msito babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapaalanasthaana.m naasaratpurametya vi\"sraamavaare svaacaaraad bhajanageha.m pravi\"sya pa.thitumuttasthau| ");
INSERT INTO sanvel_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tato yi\"sayiyabhavi.syadvaadina.h pustake tasya karadatte sati sa tat pustaka.m vistaaryya yatra vak.syamaa.naani vacanaani santi tat sthaana.m praapya papaa.tha| ");
INSERT INTO sanvel_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","aatmaa tu parame\"sasya madiiyopari vidyate| daridre.su susa.mvaada.m vaktu.m maa.m sobhi.siktavaan| bhagnaanta.h kara.naallokaan susvasthaan karttumeva ca| bandiik.rte.su loke.su mukte rgho.sayitu.m vaca.h| netraa.ni daatumandhebhyastraatu.m baddhajanaanapi| ");
INSERT INTO sanvel_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pare\"saanugrahe kaala.m pracaarayitumeva ca| sarvvaitatkara.naarthaaya maameva prahi.noti sa.h|| ");
INSERT INTO sanvel_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tata.h pustaka.m badvvaa paricaarakasya haste samarpya caasane samupavi.s.ta.h, tato bhajanag.rhe yaavanto lokaa aasan te sarvve.ananyad.r.s.tyaa ta.m vilulokire| ");
INSERT INTO sanvel_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitaani sarvvaa.ni likhitavacanaani yu.smaaka.m madhye siddhaani sa imaa.m kathaa.m tebhya.h kathayitumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tata.h sarvve tasmin anvarajyanta, ki nca tasya mukhaannirgataabhiranugrahasya kathaabhi\"scamatk.rtya kathayaamaasu.h kimaya.m yuu.sapha.h putro na? ");
INSERT INTO sanvel_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadaa so.avaadiid he cikitsaka svameva svastha.m kuru kapharnaahuumi yadyat k.rtavaan tada\"srau.sma taa.h sarvaa.h kriyaa atra svade\"se kuru kathaametaa.m yuuyamevaava\"sya.m maa.m vadi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","puna.h sovaadiid yu.smaanaha.m yathaartha.m vadaami, kopi bhavi.syadvaadii svade\"se satkaara.m na praapnoti| ");
INSERT INTO sanvel_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","apara nca yathaartha.m vacmi, eliyasya jiivanakaale yadaa saarddhatritayavar.saa.ni yaavat jaladapratibandhaat sarvvasmin de\"se mahaadurbhik.sam ajani.s.ta tadaaniim israayelo de\"sasya madhye bahvyo vidhavaa aasan, ");
INSERT INTO sanvel_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu siidonprade\"siiyasaariphatpuranivaasiniim ekaa.m vidhavaa.m vinaa kasyaa\"scidapi samiipe eliya.h prerito naabhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","apara nca ilii\"saayabhavi.syadvaadividyamaanataakaale israayelde\"se bahava.h ku.s.thina aasan kintu suriiyade\"siiya.m naamaanku.s.thina.m vinaa kopyanya.h pari.sk.rto naabhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imaa.m kathaa.m \"srutvaa bhajanagehasthitaa lokaa.h sakrodham utthaaya ");
INSERT INTO sanvel_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagaraatta.m bahi.sk.rtya yasya \"sikhari.na upari te.saa.m nagara.m sthaapitamaaste tasmaannik.septu.m tasya \"sikhara.m ta.m ninyu.h ");
INSERT INTO sanvel_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa te.saa.m madhyaadapas.rtya sthaanaantara.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tata.h para.m yii\"surgaaliilprade\"siiyakapharnaahuumnagara upasthaaya vi\"sraamavaare lokaanupade.s.tum aarabdhavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupade\"saat sarvve camaccakru ryatastasya kathaa gurutaraa aasan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadaanii.m tadbhajanagehasthito.amedhyabhuutagrasta eko jana uccai.h kathayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","he naasaratiiyayii\"so.asmaan tyaja, tvayaa sahaasmaaka.m ka.h sambandha.h? kimasmaan vinaa\"sayitumaayaasi? tvamii\"svarasya pavitro jana etadaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadaa yii\"susta.m tarjayitvaavadat maunii bhava ito bahirbhava; tata.h somedhyabhuutasta.m madhyasthaane paatayitvaa ki ncidapyahi.msitvaa tasmaad bahirgatavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tata.h sarvve lokaa\"scamatk.rtya paraspara.m vaktumaarebhire koya.m camatkaara.h| e.sa prabhaave.na paraakrame.na caamedhyabhuutaan aaj naapayati tenaiva te bahirgacchanti| ");
INSERT INTO sanvel_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantara.m caturdiksthade\"saan tasya sukhyaatirvyaapnot| ");
INSERT INTO sanvel_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantara.m sa bhajanagehaad bahiraagatya \"simono nive\"sana.m pravive\"sa tadaa tasya \"sva\"sruurjvare.naatyanta.m pii.ditaasiit \"si.syaastadartha.m tasmin vinaya.m cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tata.h sa tasyaa.h samiipe sthitvaa jvara.m tarjayaamaasa tenaiva taa.m jvaro.atyaak.siit tata.h saa tatk.sa.nam utthaaya taan si.seve| ");
INSERT INTO sanvel_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha suuryyaastakaale sve.saa.m ye ye janaa naanaarogai.h pii.ditaa aasan lokaastaan yii\"so.h samiipam aaninyu.h, tadaa sa ekaikasya gaatre karamarpayitvaa taanarogaan cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tato bhuutaa bahubhyo nirgatya ciit\"sabda.m k.rtvaa ca babhaa.sire tvamii\"svarasya putro.abhi.siktatraataa; kintu sobhi.siktatraateti te vividuretasmaat kaara.naat taan tarjayitvaa tadvaktu.m ni.si.sedha| ");
INSERT INTO sanvel_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","apara nca prabhaate sati sa vijanasthaana.m pratasthe pa\"scaat janaastamanvicchantastannika.ta.m gatvaa sthaanaantaragamanaartha.m tamanvarundhan| ");
INSERT INTO sanvel_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa taan jagaada, ii\"svariiyaraajyasya susa.mvaada.m pracaarayitum anyaani puraa.nyapi mayaa yaatavyaani yatastadarthameva preritoha.m| ");
INSERT INTO sanvel_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gaaliilo bhajanagehe.su sa upadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantara.m yii\"surekadaa gine.sarathdasya tiira utti.s.thati, tadaa lokaa ii\"svariiyakathaa.m \"srotu.m tadupari prapatitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadaanii.m sa hdasya tiirasamiipe naudvaya.m dadar\"sa ki nca matsyopajiivino naava.m vihaaya jaala.m prak.saalayanti| ");
INSERT INTO sanvel_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayordvayo rmadhye \"simono naavamaaruhya tiiraat ki ncidduura.m yaatu.m tasmin vinaya.m k.rtvaa naukaayaamupavi\"sya lokaan propadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","pa\"scaat ta.m prastaava.m samaapya sa \"simona.m vyaajahaara, gabhiira.m jala.m gatvaa matsyaan dharttu.m jaala.m nik.sipa| ");
INSERT INTO sanvel_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tata.h \"simona babhaa.se, he guro yadyapi vaya.m k.rtsnaa.m yaaminii.m pari\"sramya matsyaikamapi na praaptaastathaapi bhavato nide\"sato jaala.m k.sipaama.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jaale k.sipte bahumatsyapatanaad aanaaya.h pracchinna.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmaad upakarttum anyanausthaan sa\"ngina aayaatum i\"ngitena samaahvayan tatasta aagatya matsyai rnaudvaya.m prapuurayaamaasu ryai rnaudvaya.m pramagnam| ");
INSERT INTO sanvel_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadaa \"simonpitarastad vilokya yii\"so\"scara.nayo.h patitvaa, he prabhoha.m paapii naro mama nika.taad bhavaan yaatu, iti kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yato jaale patitaanaa.m matsyaanaa.m yuuthaat \"simon tatsa\"ngina\"sca camatk.rtavanta.h; \"simona.h sahakaari.nau sivade.h putrau yaakuub yohan cemau taad.r\"sau babhuuvatu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadaa yii\"su.h \"simona.m jagaada maa bhai.siiradyaarabhya tva.m manu.syadharo bhavi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantara.m sarvvaasu nausu tiiram aaniitaasu te sarvvaan parityajya tasya pa\"scaadgaamino babhuuvu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tata.h para.m yii\"sau kasmi.m\"scit pure ti.s.thati jana eka.h sarvvaa\"ngaku.s.thasta.m vilokya tasya samiipe nyubja.h patitvaa savinaya.m vaktumaarebhe, he prabho yadi bhavaanicchati tarhi maa.m pari.skarttu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadaanii.m sa paa.ni.m prasaaryya tada\"nga.m sp.r\"san babhaa.se tva.m pari.skriyasveti mamecchaasti tatastatk.sa.na.m sa ku.s.thaat mukta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","pa\"scaat sa tamaaj naapayaamaasa kathaamimaa.m kasmaicid akathayitvaa yaajakasya samiipa nca gatvaa sva.m dar\"saya, lokebhyo nijapari.sk.rtatvasya pramaa.nadaanaaya muusaaj naanusaare.na dravyamutm.rjasva ca| ");
INSERT INTO sanvel_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathaapi yii\"so.h sukhyaati rbahu vyaaptumaarebhe ki nca tasya kathaa.m \"srotu.m sviiyarogebhyo moktu nca lokaa aajagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa praantara.m gatvaa praarthayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","apara nca ekadaa yii\"surupadi\"sati, etarhi gaaliilyihuudaaprade\"sayo.h sarvvanagarebhyo yiruu\"saalama\"sca kiyanta.h phiruu\"silokaa vyavasthaapakaa\"sca samaagatya tadantike samupavivi\"su.h, tasmin kaale lokaanaamaarogyakaara.naat prabho.h prabhaava.h pracakaa\"se| ");
INSERT INTO sanvel_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","pa\"scaat kiyanto lokaa eka.m pak.saaghaatina.m kha.tvaayaa.m nidhaaya yii\"so.h samiipamaanetu.m sammukhe sthaapayitu nca vyaapriyanta| ");
INSERT INTO sanvel_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvaadhaat na \"saknuvanto g.rhopari gatvaa g.rhap.r.s.tha.m khanitvaa ta.m pak.saaghaatina.m sakha.tva.m g.rhamadhye yii\"so.h sammukhe .avarohayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadaa yii\"suste.saam iid.r\"sa.m vi\"svaasa.m vilokya ta.m pak.saaghaatina.m vyaajahaara, he maanava tava paapamak.samyata| ");
INSERT INTO sanvel_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmaad adhyaapakaa.h phiruu\"sina\"sca cittairittha.m pracintitavanta.h, e.sa jana ii\"svara.m nindati koya.m? kevalamii\"svara.m vinaa paapa.m k.santu.m ka.h \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadaa yii\"suste.saam ittha.m cintana.m viditvaa tebhyokathayad yuuya.m manobhi.h kuto vitarkayatha? ");
INSERT INTO sanvel_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava paapak.samaa jaataa yadvaa tvamutthaaya vraja etayo rmadhye kaa kathaa sukathyaa? ");
INSERT INTO sanvel_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu p.rthivyaa.m paapa.m k.santu.m maanavasutasya saamarthyamastiiti yathaa yuuya.m j naatu.m \"saknutha tadartha.m (sa ta.m pak.saaghaatina.m jagaada) utti.s.tha sva\"sayyaa.m g.rhiitvaa g.rha.m yaahiiti tvaamaadi\"saami| ");
INSERT INTO sanvel_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmaat sa tatk.sa.nam utthaaya sarvve.saa.m saak.saat nija\"sayaniiya.m g.rhiitvaa ii\"svara.m dhanya.m vadan nijanive\"sana.m yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmaat sarvve vismaya praaptaa mana.hsu bhiitaa\"sca vayamadyaasambhavakaaryyaa.nyadar\"saama ityuktvaa parame\"svara.m dhanya.m proditaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tata.h para.m bahirgacchan karasa ncayasthaane levinaamaana.m karasa ncaayaka.m d.r.s.tvaa yii\"sustamabhidadhe mama pa\"scaadehi| ");
INSERT INTO sanvel_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmaat sa tatk.sa.naat sarvva.m parityajya tasya pa\"scaadiyaaya| ");
INSERT INTO sanvel_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantara.m levi rnijag.rhe tadartha.m mahaabhojya.m cakaara, tadaa tai.h sahaaneke karasa ncaayinastadanyalokaa\"sca bhoktumupavivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmaat kaara.naat ca.n.daalaanaa.m paapilokaanaa nca sa\"nge yuuya.m kuto bha.mgdhve pivatha ceti kathaa.m kathayitvaa phiruu\"sino.adhyaapakaa\"sca tasya \"si.syai.h saha vaagyuddha.m karttumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmaad yii\"sustaan pratyavocad arogalokaanaa.m cikitsakena prayojana.m naasti kintu sarogaa.naameva| ");
INSERT INTO sanvel_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","aha.m dhaarmmikaan aahvaatu.m naagatosmi kintu mana.h paraavarttayitu.m paapina eva| ");
INSERT INTO sanvel_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tataste procu.h, yohana.h phiruu\"sinaa nca \"si.syaa vaara.mvaaram upavasanti praarthayante ca kintu tava \"si.syaa.h kuto bhu njate pivanti ca? ");
INSERT INTO sanvel_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadaa sa taanaacakhyau vare sa\"nge ti.s.thati varasya sakhiga.na.m kimupavaasayitu.m \"saknutha? ");
INSERT INTO sanvel_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadaa te.saa.m nika.taad varo ne.syate tadaa te samupavatsyanti| ");
INSERT INTO sanvel_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","soparamapi d.r.s.taanta.m kathayaambabhuuva puraatanavastre kopi nutanavastra.m na siivyati yatastena sevanena jiir.navastra.m chidyate, nuutanapuraatanavastrayo rmela nca na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","puraatanyaa.m kutvaa.m kopi nutana.m draak.saarasa.m na nidadhaati, yato naviinadraak.saarasasya tejasaa puraatanii kutuu rvidiiryyate tato draak.saarasa.h patati kutuu\"sca na\"syati| ");
INSERT INTO sanvel_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tato heto rnuutanyaa.m kutvaa.m naviinadraak.saarasa.h nidhaatavyastenobhayasya rak.saa bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","apara nca puraatana.m draak.saarasa.m piitvaa kopi nuutana.m na vaa nchati, yata.h sa vakti nuutanaat puraatanam pra\"sastam| ");
INSERT INTO sanvel_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","acara nca parvva.no dvitiiyadinaat para.m prathamavi\"sraamavaare \"sasyak.setre.na yii\"sorgamanakaale tasya \"si.syaa.h ka.ni\"sa.m chittvaa kare.su marddayitvaa khaaditumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmaat kiyanta.h phiruu\"sinastaanavadan vi\"sraamavaare yat karmma na karttavya.m tat kuta.h kurutha? ");
INSERT INTO sanvel_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yii\"su.h pratyuvaaca daayuud tasya sa\"ngina\"sca k.sudhaarttaa.h ki.m cakru.h sa katham ii\"svarasya mandira.m pravi\"sya ");
INSERT INTO sanvel_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ye dar\"saniiyaa.h puupaa yaajakaan vinaanyasya kasyaapyabhojaniiyaastaanaaniiya svaya.m bubhaje sa\"ngibhyopi dadau tat ki.m yu.smaabhi.h kadaapi naapaa.thi? ");
INSERT INTO sanvel_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","pa\"scaat sa taanavadat manujasuto vi\"sraamavaarasyaapi prabhu rbhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyavi\"sraamavaare sa bhajanageha.m pravi\"sya samupadi\"sati| tadaa tatsthaane \"su.skadak.si.nakara eka.h pumaan upatasthivaan| ");
INSERT INTO sanvel_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmaad adhyaapakaa.h phiruu\"sina\"sca tasmin do.samaaropayitu.m sa vi\"sraamavaare tasya svaasthya.m karoti naveti pratiik.situmaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadaa yii\"suste.saa.m cintaa.m viditvaa ta.m \"su.skakara.m pumaa.msa.m provaaca, tvamutthaaya madhyasthaane ti.s.tha| ");
INSERT INTO sanvel_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmaat tasmin utthitavati yii\"sustaan vyaajahaara, yu.smaan imaa.m kathaa.m p.rcchaami, vi\"sraamavaare hitam ahita.m vaa, praa.narak.sa.na.m praa.nanaa\"sana.m vaa, ete.saa.m ki.m karmmakara.niiyam? ");
INSERT INTO sanvel_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","pa\"scaat caturdik.su sarvvaan vilokya ta.m maanava.m babhaa.se, nijakara.m prasaaraya; tatastena tathaa k.rta itarakaravat tasya hasta.h svasthobhavat| ");
INSERT INTO sanvel_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmaat te praca.n.dakopaanvitaa yii\"su.m ki.m kari.syantiiti paraspara.m pramantritaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tata.h para.m sa parvvatamaaruhye\"svaramuddi\"sya praarthayamaana.h k.rtsnaa.m raatri.m yaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dine sati sa sarvvaan \"si.syaan aahuutavaan te.saa.m madhye ");
INSERT INTO sanvel_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranaamnaa khyaata.h \"simon tasya bhraataa aandriya\"sca yaakuub yohan ca philip barthalamaya\"sca ");
INSERT INTO sanvel_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathi.h thomaa aalphiiyasya putro yaakuub jvalantanaamnaa khyaata.h \"simon ");
INSERT INTO sanvel_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ca yaakuubo bhraataa yihuudaa\"sca ta.m ya.h parakare.su samarpayi.syati sa ii.skariiyotiiyayihuudaa\"scaitaan dvaada\"sa janaan manoniitaan k.rtvaa sa jagraaha tathaa prerita iti te.saa.m naama cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tata.h para.m sa tai.h saha parvvataadavaruhya upatyakaayaa.m tasthau tatastasya \"si.syasa\"ngho yihuudaade\"saad yiruu\"saalama\"sca sora.h siidona\"sca jaladhe rodhaso jananihaa\"sca etya tasya kathaa\"srava.naartha.m rogamuktyartha nca tasya samiipe tasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amedhyabhuutagrastaa\"sca tannika.tamaagatya svaasthya.m praapu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvve.saa.m svaasthyakara.naprabhaavasya prakaa\"sitatvaat sarvve lokaa etya ta.m spra.s.tu.m yetire| ");
INSERT INTO sanvel_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","pa\"scaat sa \"si.syaan prati d.r.s.ti.m kutvaa jagaada, he daridraa yuuya.m dhanyaa yata ii\"svariiye raajye vo.adhikaarosti| ");
INSERT INTO sanvel_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","he adhunaa k.sudhitalokaa yuuya.m dhanyaa yato yuuya.m tarpsyatha; he iha rodino janaa yuuya.m dhanyaa yato yuuya.m hasi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadaa lokaa manu.syasuuno rnaamaheto ryu.smaan .rृtiiyi.syante p.rthak k.rtvaa nindi.syanti, adhamaaniva yu.smaan svasamiipaad duuriikari.syanti ca tadaa yuuya.m dhanyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svarge yu.smaaka.m yathe.s.ta.m phala.m bhavi.syati, etadartha.m tasmin dine prollasata aanandena n.rtyata ca, te.saa.m puurvvapuru.saa\"sca bhavi.syadvaadina.h prati tathaiva vyavaaharan| ");
INSERT INTO sanvel_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu haa haa dhanavanto yuuya.m sukha.m praapnuta| hanta parit.rptaa yuuya.m k.sudhitaa bhavi.syatha; ");
INSERT INTO sanvel_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasanto yuuya.m vata yu.smaabhi.h \"socitavya.m roditavya nca| ");
INSERT INTO sanvel_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailaakai ryu.smaaka.m sukhyaatau k.rtaayaa.m yu.smaaka.m durgati rbhavi.syati yu.smaaka.m puurvvapuru.saa m.r.saabhavi.syadvaadina.h prati tadvat k.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","he \"srotaaro yu.smabhyamaha.m kathayaami, yuuya.m \"satru.su priiyadhva.m ye ca yu.smaan dvi.santi te.saamapi hita.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ye ca yu.smaan \"sapanti tebhya aa\"si.sa.m datta ye ca yu.smaan avamanyante te.saa.m ma\"ngala.m praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi ka\"scit tava kapole cape.taaghaata.m karoti tarhi ta.m prati kapolam anya.m paraavarttya sammukhiikuru puna\"sca yadi ka\"scit tava gaatriiyavastra.m harati tarhi ta.m paridheyavastram api grahiitu.m maa vaaraya| ");
INSERT INTO sanvel_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvaa.m yaacate tasmai dehi, ya\"sca tava sampatti.m harati ta.m maa yaacasva| ");
INSERT INTO sanvel_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parebhya.h svaan prati yathaacara.nam apek.sadhve paraan prati yuuyamapi tathaacarata| ");
INSERT INTO sanvel_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ye janaa yu.smaasu priiyante kevala.m te.su priiyamaa.ne.su yu.smaaka.m ki.m phala.m? paapilokaa api sve.su priiyamaa.ne.su priiyante| ");
INSERT INTO sanvel_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakaari.na eva hita.m kurutha tarhi yu.smaaka.m ki.m phala.m? paapilokaa api tathaa kurvvanti| ");
INSERT INTO sanvel_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yebhya .r.napari\"sodhasya praaptipratyaa\"saaste kevala.m te.su .r.ne samarpite yu.smaaka.m ki.m phala.m? puna.h praaptyaa\"sayaa paapiilokaa api paapijane.su .r.nam arpayanti| ");
INSERT INTO sanvel_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ato yuuya.m ripu.svapi priiyadhva.m, parahita.m kuruta ca; puna.h praaptyaa\"saa.m tyaktvaa .r.namarpayata, tathaa k.rte yu.smaaka.m mahaaphala.m bhavi.syati, yuuya nca sarvvapradhaanasya santaanaa iti khyaati.m praapsyatha, yato yu.smaaka.m pitaa k.rtaghnaanaa.m durv.tattaanaa nca hitamaacarati| ");
INSERT INTO sanvel_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata eva sa yathaa dayaalu ryuuyamapi taad.r\"saa dayaalavo bhavata| ");
INSERT INTO sanvel_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","apara nca paraan do.si.no maa kuruta tasmaad yuuya.m do.siik.rtaa na bhavi.syatha; ada.n.dyaan maa da.n.dayata tasmaad yuuyamapi da.n.da.m na praapsyatha; pare.saa.m do.saan k.samadhva.m tasmaad yu.smaakamapi do.saa.h k.sami.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","daanaanidatta tasmaad yuuya.m daanaani praapsyatha, vara nca lokaa.h parimaa.napaatra.m pradalayya sa ncaalya pro ncaalya paripuuryya yu.smaaka.m kro.de.su samarpayi.syanti; yuuya.m yena parimaa.nena parimaatha tenaiva parimaa.nena yu.smatk.rte parimaasyate| ");
INSERT INTO sanvel_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tebhyo d.r.s.taantakathaamakathayat, andho jana.h kimandha.m panthaana.m dar\"sayitu.m \"saknoti? tasmaad ubhaavapi ki.m gartte na pati.syata.h? ");
INSERT INTO sanvel_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","guro.h \"si.syo na \"sre.s.tha.h kintu \"si.sye siddhe sati sa gurutulyo bhavitu.m \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","apara nca tva.m svacak.suु.si naasaam ad.r.s.tvaa tava bhraatu\"scak.su.si yatt.r.namasti tadeva kuta.h pa\"syami? ");
INSERT INTO sanvel_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svacak.su.si yaa naasaa vidyate taam aj naatvaa, bhraatastava netraat t.r.na.m bahi.h karomiiti vaakya.m bhraatara.m katha.m vaktu.m \"sakno.si? he kapa.tin puurvva.m svanayanaat naasaa.m bahi.h kuru tato bhraatu\"scak.su.sast.r.na.m bahi.h karttu.m sud.r.s.ti.m praapsyasi| ");
INSERT INTO sanvel_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anya nca uttamastaru.h kadaapi phalamanuttama.m na phalati, anuttamataru\"sca phalamuttama.m na phalati kaara.naadata.h phalaistaravo j naayante| ");
INSERT INTO sanvel_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ka.n.takipaadapaat kopi u.dumbaraphalaani na paatayati tathaa \"s.rgaalakoliv.rk.saadapi kopi draak.saaphala.m na paatayati| ");
INSERT INTO sanvel_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat saadhuloko.anta.hkara.naruupaat subhaa.n.daagaaraad uttamaani dravyaa.ni bahi.h karoti, du.s.to loka\"scaanta.hkara.naruupaat kubhaa.n.daagaaraat kutsitaani dravyaa.ni nirgamayati yato.anta.hkara.naanaa.m puur.nabhaavaanuruupaa.ni vacaa.msi mukhaannirgacchanti| ");
INSERT INTO sanvel_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","apara nca mamaaj naanuruupa.m naacaritvaa kuto maa.m prabho prabho iti vadatha? ");
INSERT INTO sanvel_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ya.h ka\"scin mama nika.tam aagatya mama kathaa ni\"samya tadanuruupa.m karmma karoti sa kasya sad.r\"so bhavati tadaha.m yu.smaan j naaाpayaami| ");
INSERT INTO sanvel_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yo jano gabhiira.m khanitvaa paa.saa.nasthale bhitti.m nirmmaaya svag.rha.m racayati tena saha tasyopamaa bhavati; yata aaplaavijalametya tasya muule vegena vahadapi tadgeha.m laa.dayitu.m na \"saknoti yatastasya bhitti.h paa.saa.nopari ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu ya.h ka\"scin mama kathaa.h \"srutvaa tadanuruupa.m naacarati sa bhitti.m vinaa m.rृdupari g.rhanirmmaatraa samaano bhavati; yata aaplaavijalamaagatya vegena yadaa vahati tadaa tadg.rha.m patati tasya mahat patana.m jaayate| ");
INSERT INTO sanvel_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tata.h para.m sa lokaanaa.m kar.nagocare taan sarvvaan upade\"saan samaapya yadaa kapharnaahuumpura.m pravi\"sati ");
INSERT INTO sanvel_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadaa \"satasenaapate.h priyadaasa eko m.rtakalpa.h pii.dita aasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ata.h senaapati ryii\"so rvaarttaa.m ni\"samya daasasyaarogyakara.naaya tasyaagamanaartha.m vinayakara.naaya yihuudiiyaan kiyata.h praaca.h pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","te yii\"sorantika.m gatvaa vinayaati\"saya.m vaktumaarebhire, sa senaapati rbhavatonugraha.m praaptum arhati| ");
INSERT INTO sanvel_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yata.h sosmajjaatiiye.su loke.su priiyate tathaasmatk.rte bhajanageha.m nirmmitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmaad yii\"sustai.h saha gatvaa nive\"sanasya samiipa.m praapa, tadaa sa \"satasenaapati rvak.syamaa.navaakya.m ta.m vaktu.m bandhuun praahi.not| he prabho svaya.m \"sramo na karttavyo yad bhavataa madgehamadhye paadaarpa.na.m kriyeta tadapyaha.m naarhaami, ");
INSERT INTO sanvel_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ki ncaaha.m bhavatsamiipa.m yaatumapi naatmaana.m yogya.m buddhavaan, tato bhavaan vaakyamaatra.m vadatu tenaiva mama daasa.h svastho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmaad aha.m paraadhiinopi mamaadhiinaa yaa.h senaa.h santi taasaam ekajana.m prati yaahiiti mayaa prokte sa yaati; tadanya.m prati aayaahiiti prokte sa aayaati; tathaa nijadaasa.m prati etat kurvviti prokte sa tadeva karoti| ");
INSERT INTO sanvel_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yii\"surida.m vaakya.m \"srutvaa vismaya.m yayau, mukha.m paraavartya pa\"scaadvarttino lokaan babhaa.se ca, yu.smaanaha.m vadaami israayelo va.m\"samadhyepi vi\"svaasamiid.r\"sa.m na praapnava.m| ");
INSERT INTO sanvel_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tataste pre.sitaa g.rha.m gatvaa ta.m pii.dita.m daasa.m svastha.m dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pare.ahani sa naayiinaakhya.m nagara.m jagaama tasyaaneke \"si.syaa anye ca lokaastena saarddha.m yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","te.su tannagarasya dvaarasannidhi.m praapte.su kiyanto lokaa eka.m m.rtamanuja.m vahanto nagarasya bahiryaanti, sa tanmaaturekaputrastanmaataa ca vidhavaa; tayaa saarddha.m tannagariiyaa bahavo lokaa aasan| ");
INSERT INTO sanvel_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustaa.m vilokya saanukampa.h kathayaamaasa, maa rodii.h| sa samiipamitvaa kha.tvaa.m paspar\"sa tasmaad vaahakaa.h sthagitaastamyu.h; ");
INSERT INTO sanvel_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadaa sa uvaaca he yuvamanu.sya tvamutti.s.tha, tvaamaham aaj naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmaat sa m.rto janastatk.sa.namutthaaya kathaa.m prakathita.h; tato yii\"sustasya maatari ta.m samarpayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmaat sarvve lokaa.h \"sa\"sa\"nkire; eko mahaabhavi.syadvaadii madhye.asmaakam samudait, ii\"svara\"sca svalokaananvag.rhlaat kathaamimaa.m kathayitvaa ii\"svara.m dhanya.m jagadu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tata.h para.m samasta.m yihuudaade\"sa.m tasya caturdiksthade\"sa nca tasyaitatkiirtti rvyaana\"se| ");
INSERT INTO sanvel_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tata.h para.m yohana.h \"si.sye.su ta.m tadv.rttaanta.m j naapitavatsu ");
INSERT INTO sanvel_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa sva\"si.syaa.naa.m dvau janaavaahuuya yii\"su.m prati vak.syamaa.na.m vaakya.m vaktu.m pre.sayaamaasa, yasyaagamanam apek.sya ti.s.thaamo vaya.m ki.m sa eva janastva.m? ki.m vayamanyamapek.sya sthaasyaama.h? ");
INSERT INTO sanvel_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","pa\"scaattau maanavau gatvaa kathayaamaasatu.h, yasyaagamanam apek.sya ti.s.thaamo vaya.m, ki.m saeva janastva.m? ki.m vayamanyamapek.sya sthaasyaama.h? kathaamimaa.m tubhya.m kathayitu.m yohan majjaka aavaa.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin da.n.de yii\"suurogi.no mahaavyaadhimato du.s.tabhuutagrastaa.m\"sca bahuun svasthaan k.rtvaa, anekaandhebhya\"scak.su.m.si dattvaa pratyuvaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvaa.m vrajatam andhaa netraa.ni kha njaa\"scara.naani ca praapnuvanti, ku.s.thina.h pari.skriyante, badhiraa.h \"srava.naani m.rtaa\"sca jiivanaani praapnuvanti, daridraa.naa.m samiipe.su susa.mvaada.h pracaaryyate, ya.m prati vighnasvaruupoha.m na bhavaami sa dhanya.h, ");
INSERT INTO sanvel_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","etaani yaani pa\"syatha.h \"s.r.nutha\"sca taani yohana.m j naapayatam| ");
INSERT INTO sanvel_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayo rduutayo rgatayo.h sato ryohani sa lokaan vaktumupacakrame, yuuya.m madhyepraantara.m ki.m dra.s.tu.m niragamata? ki.m vaayunaa kampita.m na.da.m? ");
INSERT INTO sanvel_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yuuya.m ki.m dra.s.tu.m niragamata? ki.m suuk.smavastraparidhaayina.m kamapi nara.m? kintu ye suuk.smam.rduvastraa.ni paridadhati suuttamaani dravyaa.ni bhu njate ca te raajadhaanii.su ti.s.thanti| ");
INSERT INTO sanvel_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yuuya.m ki.m dra.s.tu.m niragamata? kimeka.m bhavi.syadvaadina.m? tadeva satya.m kintu sa pumaan bhavi.syadvaadinopi \"sre.s.tha ityaha.m yu.smaan vadaami; ");
INSERT INTO sanvel_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","pa\"sya svakiiyaduutantu tavaagra pre.sayaamyaha.m| gatvaa tvadiiyamaargantu sa hi pari.skari.syati| yadarthe lipiriyam aaste sa eva yohan| ");
INSERT INTO sanvel_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ato yu.smaanaha.m vadaami striyaa garbbhajaataanaa.m bhavi.syadvaadinaa.m madhye yohano majjakaat \"sre.s.tha.h kopi naasti, tatraapi ii\"svarasya raajye ya.h sarvvasmaat k.sudra.h sa yohanopi \"sre.s.tha.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","apara nca sarvve lokaa.h karama ncaayina\"sca tasya vaakyaani \"srutvaa yohanaa majjanena majjitaa.h parame\"svara.m nirdo.sa.m menire| ");
INSERT INTO sanvel_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phiruu\"sino vyavasthaapakaa\"sca tena na majjitaa.h svaan pratii\"svarasyopade\"sa.m ni.sphalam akurvvan| ");
INSERT INTO sanvel_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhu.h kathayaamaasa, idaaniintanajanaan kenopamaami? te kasya sad.r\"saa.h? ");
INSERT INTO sanvel_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ye baalakaa vipa.nyaam upavi\"sya parasparam aahuuya vaakyamida.m vadanti, vaya.m yu.smaaka.m nika.te va.m\"siiravaadi.sma, kintu yuuya.m naanartti.s.ta, vaya.m yu.smaaka.m nika.ta arodi.sma, kintu yuya.m na vyalapi.s.ta, baalakairetaad.r\"saiste.saam upamaa bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yato yohan majjaka aagatya puupa.m naakhaadat draak.saarasa nca naapivat tasmaad yuuya.m vadatha, bhuutagrastoyam| ");
INSERT INTO sanvel_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tata.h para.m maanavasuta aagatyaakhaadadapiva nca tasmaad yuuya.m vadatha, khaadaka.h suraapa\"scaa.n.daalapaapinaa.m bandhureko jano d.r\"syataam| ");
INSERT INTO sanvel_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu j naanino j naana.m nirdo.sa.m vidu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","pa\"scaadeka.h phiruu\"sii yii\"su.m bhojanaaya nyamantrayat tata.h sa tasya g.rha.m gatvaa bhoktumupavi.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","etarhi tatphiruu\"sino g.rhe yii\"su rbhektum upaavek.siit tacchrutvaa tannagaravaasinii kaapi du.s.taa naarii paa.n.daraprastarasya sampu.take sugandhitailam aaniiya ");
INSERT INTO sanvel_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya pa\"scaat paadayo.h sannidhau tasyau rudatii ca netraambubhistasya cara.nau prak.saalya nijakacairamaark.siit, tatastasya cara.nau cumbitvaa tena sugandhitailena mamarda| ");
INSERT INTO sanvel_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmaat sa nimantrayitaa phiruu\"sii manasaa cintayaamaasa, yadyaya.m bhavi.syadvaadii bhavet tarhi ena.m sp.r\"sati yaa strii saa kaa kiid.r\"sii ceti j naatu.m \"saknuyaat yata.h saa du.s.taa| ");
INSERT INTO sanvel_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadaa yaa\"susta.m jagaada, he \"simon tvaa.m prati mama ki ncid vaktavyamasti; tasmaat sa babhaa.se, he guro tad vadatu| ");
INSERT INTO sanvel_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ekottamar.nasya dvaavadhamar.naavaastaa.m, tayoreka.h pa nca\"sataani mudraapaadaan apara\"sca pa ncaa\"sat mudraapaadaan dhaarayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantara.m tayo.h \"sodhyaabhaavaat sa uttamar.nastayo r.r.ne cak.same; tasmaat tayordvayo.h kastasmin pre.syate bahu? tad bruuhi| ");
INSERT INTO sanvel_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","\"simon pratyuvaaca, mayaa budhyate yasyaadhikam .r.na.m cak.same sa iti; tato yii\"susta.m vyaajahaara, tva.m yathaartha.m vyacaaraya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha taa.m naarii.m prati vyaaghu.thya \"simonamavocat, striimimaa.m pa\"syasi? tava g.rhe mayyaagate tva.m paadaprak.saalanaartha.m jala.m naadaa.h kintu yo.side.saa nayanajalai rmama paadau prak.saalya ke\"sairamaark.siit| ");
INSERT INTO sanvel_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tva.m maa.m naacumbii.h kintu yo.side.saa sviiyaagamanaadaarabhya madiiyapaadau cumbitu.m na vyara.msta| ");
INSERT INTO sanvel_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tva nca madiiyottamaa\"nge ki ncidapi taila.m naamardii.h kintu yo.side.saa mama cara.nau sugandhitailenaamarddiit| ");
INSERT INTO sanvel_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvaa.m vyaaharaami, etasyaa bahu paapamak.samyata tato bahu priiyate kintu yasyaalpapaapa.m k.samyate solpa.m priiyate| ");
INSERT INTO sanvel_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tata.h para.m sa taa.m babhaa.se, tvadiiya.m paapamak.samyata| ");
INSERT INTO sanvel_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadaa tena saarddha.m ye bhoktum upavivi\"suste paraspara.m vaktumaarebhire, aya.m paapa.m k.samate ka e.sa.h? ");
INSERT INTO sanvel_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa taa.m naarii.m jagaada, tava vi\"svaasastvaa.m paryyatraasta tva.m k.seme.na vraja| ");
INSERT INTO sanvel_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","apara nca yii\"su rdvaada\"sabhi.h \"si.syai.h saarddha.m naanaanagare.su naanaagraame.su ca gacchan i\"svariiyaraajatvasya susa.mvaada.m pracaarayitu.m praarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadaa yasyaa.h sapta bhuutaa niragacchan saa magdaliiniiti vikhyaataa mariyam herodraajasya g.rhaadhipate.h ho.se rbhaaryyaa yohanaa \"suu\"saanaa ");
INSERT INTO sanvel_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabh.rtayo yaa bahvya.h striya.h du.s.tabhuutebhyo rogebhya\"sca muktaa.h satyo nijavibhuutii rvyayitvaa tamasevanta, taa.h sarvvaastena saarddham aasan| ");
INSERT INTO sanvel_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantara.m naanaanagarebhyo bahavo lokaa aagatya tasya samiipe.amilan, tadaa sa tebhya ekaa.m d.r.s.taantakathaa.m kathayaamaasa| eka.h k.r.siibalo biijaani vaptu.m bahirjagaama, ");
INSERT INTO sanvel_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tato vapanakaale katipayaani biijaani maargapaar\"sve petu.h, tatastaani padatalai rdalitaani pak.sibhi rbhak.sitaani ca| ");
INSERT INTO sanvel_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayaani biijaani paa.saa.nasthale patitaani yadyapi taanya\"nkuritaani tathaapi rasaabhaavaat \"su\"su.su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayaani biijaani ka.n.takivanamadhye patitaani tata.h ka.n.takivanaani sa.mv.rddhya taani jagrasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyaani katipayabiijaani ca bhuumyaamuttamaayaa.m petustatastaanya\"nkurayitvaa \"satagu.naani phalaani phelu.h| sa imaa kathaa.m kathayitvaa proccai.h provaaca, yasya \"srotu.m \"srotre sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tata.h para.m \"si.syaasta.m papracchurasya d.r.s.taantasya ki.m taatparyya.m? ");
INSERT INTO sanvel_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tata.h sa vyaajahaara, ii\"svariiyaraajyasya guhyaani j naatu.m yu.smabhyamadhikaaro diiyate kintvanye yathaa d.r.s.tvaapi na pa\"syanti \"srutvaapi ma budhyante ca tadartha.m te.saa.m purastaat taa.h sarvvaa.h kathaa d.r.s.taantena kathyante| ");
INSERT INTO sanvel_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","d.r.s.taantasyaasyaabhipraaya.h, ii\"svariiyakathaa biijasvaruupaa| ");
INSERT INTO sanvel_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ye kathaamaatra.m \"s.r.nvanti kintu pa\"scaad vi\"svasya yathaa paritraa.na.m na praapnuvanti tadaa\"sayena \"saitaanetya h.rdayaat.r taa.m kathaam apaharati ta eva maargapaar\"svasthabhuumisvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ye katha.m \"srutvaa saananda.m g.rhlanti kintvabaddhamuulatvaat svalpakaalamaatra.m pratiitya pariik.saakaale bhra\"syanti taeva paa.saa.nabhuumisvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ye kathaa.m \"srutvaa yaanti vi.sayacintaayaa.m dhanalobhena eेhikasukhe ca majjanta upayuktaphalaani na phalanti ta evoptabiijaka.n.takibhuusvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu ye \"srutvaa saralai.h \"suddhai\"scaanta.hkara.nai.h kathaa.m g.rhlanti dhairyyam avalambya phalaanyutpaadayanti ca ta evottamam.rtsvaruupaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","apara nca pradiipa.m prajvaalya kopi paatre.na naacchaadayati tathaa kha.tvaadhopi na sthaapayati, kintu diipaadhaaroparyyeva sthaapayati, tasmaat prave\"sakaa diipti.m pa\"syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakaa\"sayi.syate taad.rg aprakaa\"sita.m vastu kimapi naasti yacca na suvyakta.m pracaarayi.syate taad.rg g.rpta.m vastu kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ato yuuya.m kena prakaare.na \"s.r.nutha tatra saavadhaanaa bhavata, yasya samiipe barddhate tasmai punardaasyate kintu yasyaa\"sraye na barddhate tasya yadyadasti tadapi tasmaat ne.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","apara nca yii\"so rmaataa bhraatara\"sca tasya samiipa.m jigami.sava.h ");
INSERT INTO sanvel_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janataasambaadhaat tatsannidhi.m praaptu.m na \"seku.h| tatpa\"scaat tava maataa bhraatara\"sca tvaa.m saak.saat cikiir.santo bahisti.s.thanatiiti vaarttaayaa.m tasmai kathitaayaa.m ");
INSERT INTO sanvel_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvaaca; ye janaa ii\"svarasya kathaa.m \"srutvaa tadanuruupamaacaranti taeva mama maataa bhraatara\"sca| ");
INSERT INTO sanvel_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantara.m ekadaa yii\"su.h \"si.syai.h saarddha.m naavamaaruhya jagaada, aayaata vaya.m hradasya paara.m yaama.h, tataste jagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","te.su naukaa.m vaahayatsu sa nidadrau; ");
INSERT INTO sanvel_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athaakasmaat prabalajha nbh\"sagamaad hrade naukaayaa.m tara\"ngairaacchannaayaa.m vipat taan jagraasa|tasmaad yii\"sorantika.m gatvaa he guro he guro praa.naa no yaantiiti gaditvaa ta.m jaagarayaambabhuuvu.h|tadaa sa utthaaya vaayu.m tara\"ngaa.m\"sca tarjayaamaasa tasmaadubhau niv.rtya sthirau babhuuvatu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa taan babhaa.se yu.smaaka.m vi\"svaasa.h ka? tasmaatte bhiitaa vismitaa\"sca paraspara.m jagadu.h, aho kiid.rgaya.m manuja.h pavana.m paaniiya ncaadi\"sati tadubhaya.m tadaade\"sa.m vahati| ");
INSERT INTO sanvel_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tata.h para.m gaaliilprade\"sasya sammukhasthagideriiyaprade\"se naukaayaa.m lagantyaa.m ta.te.avarohamaavaad ");
INSERT INTO sanvel_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakaala.m bhuutagrasta eko maanu.sa.h puraadaagatya ta.m saak.saaccakaara| sa manu.so vaaso na paridadhat g.rhe ca na vasan kevala.m \"sma\"saanam adhyuvaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yii\"su.m d.r.s.tvaiva ciicchabda.m cakaara tasya sammukhe patitvaa proccairjagaada ca, he sarvvapradhaane\"svarasya putra, mayaa saha tava ka.h sambandha.h? tvayi vinaya.m karomi maa.m maa yaataya| ");
INSERT INTO sanvel_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yata.h sa ta.m maanu.sa.m tyaktvaa yaatum amedhyabhuutam aadide\"sa; sa bhuutasta.m maanu.sam asak.rd dadhaara tasmaallokaa.h \"s.r\"nkhalena niga.dena ca babandhu.h; sa tad bha.mktvaa bhuutava\"satvaat madhyepraantara.m yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantara.m yii\"susta.m papraccha tava kinnaama? sa uvaaca, mama naama baahino yato bahavo bhuutaastamaa\"si\"sriyu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhuutaa vinayena jagadu.h, gabhiira.m gartta.m gantu.m maaj naapayaasmaan| ");
INSERT INTO sanvel_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadaa parvvatopari varaahavraja\"scarati tasmaad bhuutaa vinayena procu.h, amu.m varaahavrajam aa\"srayitum asmaan anujaaniihi; tata.h sonujaj nau| ");
INSERT INTO sanvel_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tata.h para.m bhuutaasta.m maanu.sa.m vihaaya varaahavrajam aa\"si\"sriyu.h varaahavrajaa\"sca tatk.sa.naat ka.takena dhaavanto hrade praa.naan vij.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad d.r.s.tvaa \"suukararak.sakaa.h palaayamaanaa nagara.m graama nca gatvaa tatsarvvav.rttaanta.m kathayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tata.h ki.m v.rttam etaddar\"sanaartha.m lokaa nirgatya yii\"so.h samiipa.m yayu.h, ta.m maanu.sa.m tyaktabhuuta.m parihitavastra.m svasthamaanu.savad yii\"so\"scara.nasannidhau suupavi\"santa.m vilokya bibhyu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ye lokaastasya bhuutagrastasya svaasthyakara.na.m dad.r\"suste tebhya.h sarvvav.rttaanta.m kathayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantara.m tasya gideriiyaprade\"sasya caturdiksthaa bahavo janaa atitrastaa vinayena ta.m jagadu.h, bhavaan asmaaka.m nika.taad vrajatu tasmaat sa naavamaaruhya tato vyaaghu.tya jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadaanii.m tyaktabhuutamanujastena saha sthaatu.m praarthayaa ncakre ");
INSERT INTO sanvel_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham ii\"svara.h kiid.r\"nmahaakarmma k.rtavaan iti nive\"sana.m gatvaa vij naapaya, yii\"su.h kathaametaa.m kathayitvaa ta.m visasarja| tata.h sa vrajitvaa yii\"sustadartha.m yanmahaakarmma cakaara tat purasya sarvvatra prakaa\"sayitu.m praarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yii\"sau paraav.rtyaagate lokaasta.m aadare.na jag.rhu ryasmaatte sarvve tamapek.saa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantara.m yaayiirnaamno bhajanagehasyaikodhipa aagatya yii\"so\"scara.nayo.h patitvaa svanive\"sanaagamanaartha.m tasmin vinaya.m cakaara, ");
INSERT INTO sanvel_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvaada\"savar.savayaskaa kanyaikaasiit saa m.rtakalpaabhavat| tatastasya gamanakaale maarge lokaanaa.m mahaan samaagamo babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvaada\"savar.saa.ni pradararogagrastaa naanaa vaidyai\"scikitsitaa sarvvasva.m vyayitvaapi svaasthya.m na praaptaa yaa yo.sit saa yii\"so.h pa\"scaadaagatya tasya vastragranthi.m paspar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmaat tatk.sa.naat tasyaa raktasraavo ruddha.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadaanii.m yii\"suravadat kenaaha.m sp.r.s.ta.h? tato.anekairana\"ngiik.rte pitarastasya sa\"ngina\"scaavadan, he guro lokaa nika.tasthaa.h santastava dehe ghar.sayanti, tathaapi kenaaha.m sp.r.s.ta_iti bhavaan kuta.h p.rcchati? ");
INSERT INTO sanvel_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yii\"su.h kathayaamaasa, kenaapyaha.m sp.r.s.to, yato matta.h \"sakti rnirgateti mayaa ni\"scitamaj naayi| ");
INSERT INTO sanvel_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadaa saa naarii svaya.m na gupteti viditvaa kampamaanaa satii tasya sammukhe papaata; yena nimittena ta.m paspar\"sa spar\"samaatraacca yena prakaare.na svasthaabhavat tat sarvva.m tasya saak.saadaacakhyau| ");
INSERT INTO sanvel_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tata.h sa taa.m jagaada he kanye susthiraa bhava, tava vi\"svaasastvaa.m svasthaam akaar.siit tva.m k.seme.na yaahi| ");
INSERT INTO sanvel_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yii\"soretadvaakyavadanakaale tasyaadhipate rnive\"sanaat ka\"scilloka aagatya ta.m babhaa.se, tava kanyaa m.rtaa guru.m maa kli\"saana| ");
INSERT INTO sanvel_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yii\"sustadaakar.nyaadhipati.m vyaajahaara, maa bhai.sii.h kevala.m vi\"svasihi tasmaat saa jiivi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya nive\"sane praapte sa pitara.m yohana.m yaakuuba nca kanyaayaa maatara.m pitara nca vinaa, anya.m ka ncana prave.s.tu.m vaarayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","apara nca ye rudanti vilapanti ca taan sarvvaan janaan uvaaca, yuuya.m maa rodi.s.ta kanyaa na m.rtaa nidraati| ");
INSERT INTO sanvel_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu saa ni\"scita.m m.rteti j naatvaa te tamupajahasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","pa\"scaat sa sarvvaan bahi.h k.rtvaa kanyaayaa.h karau dh.rtvaajuhuve, he kanye tvamutti.s.tha, ");
INSERT INTO sanvel_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmaat tasyaa.h praa.ne.su punaraagate.su saa tatk.sa.naad uttasyau| tadaanii.m tasyai ki ncid bhak.sya.m daatum aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyaa.h pitarau vismaya.m gatau kintu sa taavaadide\"sa gha.tanaayaa etasyaa.h kathaa.m kasmaicidapi maa kathayata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tata.h para.m sa dvaada\"sa\"si.syaanaahuuya bhuutaan tyaajayitu.m rogaan pratikarttu nca tebhya.h \"saktimaadhipatya nca dadau| ");
INSERT INTO sanvel_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","apara nca ii\"svariiyaraajyasya susa.mvaada.m prakaa\"sayitum rogi.naamaarogya.m karttu nca prera.nakaale taan jagaada| ");
INSERT INTO sanvel_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yaatraartha.m ya.s.ti rvastrapu.taka.m bhak.sya.m mudraa dvitiiyavastram, e.saa.m kimapi maa g.rhliita| ");
INSERT INTO sanvel_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yuuya nca yannive\"sana.m pravi\"satha nagaratyaagaparyyanata.m tannive\"sane ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyacit purasya lokaa yu.smaakamaatithya.m na kurvvanti tarhi tasmaannagaraad gamanakaale te.saa.m viruddha.m saak.syaartha.m yu.smaaka.m padadhuulii.h sampaatayata| ");
INSERT INTO sanvel_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha te prasthaaya sarvvatra susa.mvaada.m pracaarayitu.m pii.ditaan svasthaan karttu nca graame.su bhramitu.m praarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","etarhi herod raajaa yii\"so.h sarvvakarmma.naa.m vaarttaa.m \"srutvaa bh.r\"samudvivije ");
INSERT INTO sanvel_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yata.h keciduucuryohan \"sma\"saanaadudati.s.that| keciduucu.h, eliyo dar\"sana.m dattavaan; evamanyalokaa uucu.h puurvviiya.h ka\"scid bhavi.syadvaadii samutthita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu heroduvaaca yohana.h \"siro.ahamachinadam idaanii.m yasyed.rkkarmma.naa.m vaarttaa.m praapnomi sa ka.h? atha sa ta.m dra.s.tum aicchat| ");
INSERT INTO sanvel_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantara.m preritaa.h pratyaagatya yaani yaani karmmaa.ni cakrustaani yii\"save kathayaamaasu.h tata.h sa taan baitsaidaanaamakanagarasya vijana.m sthaana.m niitvaa gupta.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","pa\"scaal lokaastad viditvaa tasya pa\"scaad yayu.h; tata.h sa taan nayan ii\"svariiyaraajyasya prasa\"ngamuktavaan, ye.saa.m cikitsayaa prayojanam aasiit taan svasthaan cakaara ca| ");
INSERT INTO sanvel_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","apara nca divaavasanne sati dvaada\"sa\"si.syaa yii\"sorantikam etya kathayaamaasu.h, vayamatra praantarasthaane ti.s.thaama.h, tato nagaraa.ni graamaa.ni gatvaa vaasasthaanaani praapya bhak.syadravyaa.ni kretu.m jananivaha.m bhavaan vis.rjatu| ");
INSERT INTO sanvel_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadaa sa uvaaca, yuuyameva taan bhejayadhva.m; tataste procurasmaaka.m nika.te kevala.m pa nca puupaa dvau matsyau ca vidyante, ataeva sthaanaantaram itvaa nimittamete.saa.m bhak.syadravye.su na kriite.su na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra praaye.na pa ncasahasraa.ni puru.saa aasan| ");
INSERT INTO sanvel_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadaa sa \"si.syaan jagaada pa ncaa\"sat pa ncaa\"sajjanai.h pa.mktiik.rtya taanupave\"sayata, tasmaat te tadanusaare.na sarvvalokaanupave\"sayaapaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tata.h sa taan pa nca puupaan miinadvaya nca g.rhiitvaa svarga.m vilokye\"svaragu.naan kiirttayaa ncakre bha\"nktaa ca lokebhya.h parive.sa.naartha.m \"si.sye.su samarpayaambabhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tata.h sarvve bhuktvaa t.rpti.m gataa ava\"si.s.taanaa nca dvaada\"sa .dallakaan sa.mjag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadaa nirjane \"si.syai.h saha praarthanaakaale taan papraccha, lokaa maa.m ka.m vadanti? ");
INSERT INTO sanvel_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tataste praacu.h, tvaa.m yohanmajjaka.m vadanti; kecit tvaam eliya.m vadanti, puurvvakaalika.h ka\"scid bhavi.syadvaadii \"sma\"saanaad udati.s.thad ityapi kecid vadanti| ");
INSERT INTO sanvel_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadaa sa uvaaca, yuuya.m maa.m ka.m vadatha? tata.h pitara uktavaan tvam ii\"svaraabhi.sikta.h puru.sa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadaa sa taan d.r.dhamaadide\"sa, kathaametaa.m kasmaicidapi maa kathayata| ");
INSERT INTO sanvel_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvaaca, manu.syaputre.na vahuyaatanaa bhoktavyaa.h praaciinalokai.h pradhaanayaajakairadhyaapakai\"sca sovaj naaya hantavya.h kintu t.rtiiyadivase \"sma\"saanaat tenotthaatavyam| ");
INSERT INTO sanvel_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","apara.m sa sarvvaanuvaaca, ka\"scid yadi mama pa\"scaad gantu.m vaa nchati tarhi sa sva.m daamyatu, dine dine kru\"sa.m g.rhiitvaa ca mama pa\"scaadaagacchatu| ");
INSERT INTO sanvel_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yato ya.h ka\"scit svapraa.naan rirak.si.sati sa taan haarayi.syati, ya.h ka\"scin madartha.m praa.naan haarayi.syati sa taan rak.si.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ka\"scid yadi sarvva.m jagat praapnoti kintu svapraa.naan haarayati svaya.m vina\"syati ca tarhi tasya ko laabha.h? ");
INSERT INTO sanvel_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna rya.h ka\"scin maa.m mama vaakya.m vaa lajjaaspada.m jaanaati manu.syaputro yadaa svasya pitu\"sca pavitraa.naa.m duutaanaa nca tejobhi.h parive.s.tita aagami.syati tadaa sopi ta.m lajjaaspada.m j naasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yu.smaanaha.m yathaartha.m vadaami, ii\"svariiyaraajatva.m na d.r.s.tavaa m.rtyu.m naasvaadi.syante, etaad.r\"saa.h kiyanto lokaa atra sthane.api da.n.daayamaanaa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","etadaakhyaanakathanaat para.m praaye.naa.s.tasu dine.su gate.su sa pitara.m yohana.m yaakuuba nca g.rhiitvaa praarthayitu.m parvvatameka.m samaaruroha| ");
INSERT INTO sanvel_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya praarthanakaale tasya mukhaak.rtiranyaruupaa jaataa, tadiiya.m vastramujjvala\"sukla.m jaata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","apara nca muusaa eliya\"scobhau tejasvinau d.r.s.tau ");
INSERT INTO sanvel_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tena yiruu\"saalampure yo m.rtyu.h saadhi.syate tadiiyaa.m kathaa.m tena saarddha.m kathayitum aarebhaate| ");
INSERT INTO sanvel_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadaa pitaraadaya.h svasya sa\"ngino nidrayaak.r.s.taa aasan kintu jaagaritvaa tasya tejastena saarddham utti.s.thantau janau ca dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayorubhayo rgamanakaale pitaro yii\"su.m babhaa.se, he guro.asmaaka.m sthaane.asmin sthiti.h \"subhaa, tata ekaa tvadarthaa, ekaa muusaarthaa, ekaa eliyaarthaa, iti tisra.h ku.tyosmaabhi rnirmmiiyantaa.m, imaa.m kathaa.m sa na vivicya kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","apara nca tadvaakyavadanakaale payoda eka aagatya te.saamupari chaayaa.m cakaara, tatastanmadhye tayo.h prave\"saat te \"sa\"sa\"nkire| ");
INSERT INTO sanvel_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadaa tasmaat payodaad iyamaakaa\"siiyaa vaa.nii nirjagaama, mamaaya.m priya.h putra etasya kathaayaa.m mano nidhatta| ");
INSERT INTO sanvel_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti \"sabde jaate te yii\"sumekaakina.m dad.r\"su.h kintu te tadaanii.m tasya dar\"sanasya vaacamekaamapi noktvaa mana.hsu sthaapayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","pare.ahani te.su tasmaacchailaad avaruu.dhe.su ta.m saak.saat karttu.m bahavo lokaa aajagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","te.saa.m madhyaad eko jana uccairuvaaca, he guro aha.m vinaya.m karomi mama putra.m prati k.rpaad.r.s.ti.m karotu, mama sa evaika.h putra.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhuutena dh.rta.h san sa.m prasabha.m ciicchabda.m karoti tanmukhaat phe.naa nirgacchanti ca, bhuuta ittha.m vidaaryya kli.s.tvaa praaya\"sasta.m na tyajati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmaat ta.m bhuuta.m tyaajayitu.m tava \"si.syasamiipe nyavedaya.m kintu te na \"seku.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadaa yii\"suravaadiit, re aavi\"svaasin vipathagaamin va.m\"sa katikaalaan yu.smaabhi.h saha sthaasyaamyaha.m yu.smaakam aacara.naani ca sahi.sye? tava putramihaanaya| ");
INSERT INTO sanvel_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnaagatamaatre bhuutasta.m bhuumau paatayitvaa vidadaara; tadaa yii\"sustamamedhya.m bhuuta.m tarjayitvaa baalaka.m svastha.m k.rtvaa tasya pitari samarpayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ii\"svarasya mahaa\"saktim imaa.m vilokya sarvve camaccakru.h; ittha.m yii\"so.h sarvvaabhi.h kriyaabhi.h sarvvairlokairaa\"scaryye manyamaane sati sa \"si.syaan babhaa.se, ");
INSERT INTO sanvel_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","katheya.m yu.smaaka.m kar.ne.su pravi\"satu, manu.syaputro manu.syaa.naa.m kare.su samarpayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu te taa.m kathaa.m na bubudhire, spa.s.tatvaabhaavaat tasyaa abhipraayaste.saa.m bodhagamyo na babhuuva; tasyaa aa\"saya.h ka ityapi te bhayaat pra.s.tu.m na \"seku.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantara.m te.saa.m madhye ka.h \"sre.s.tha.h kathaametaa.m g.rhiitvaa te mitho vivaada.m cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tato yii\"suste.saa.m manobhipraaya.m viditvaa baalakameka.m g.rhiitvaa svasya nika.te sthaapayitvaa taan jagaada, ");
INSERT INTO sanvel_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yo jano mama naamnaasya baalaasyaatithya.m vidadhaati sa mamaatithya.m vidadhaati, ya\"sca mamaatithya.m vidadhaati sa mama prerakasyaatithya.m vidadhaati, yu.smaaka.m madhyeya.h sva.m sarvvasmaat k.sudra.m jaaniite sa eva \"sre.s.tho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","apara nca yohan vyaajahaara he prabheा tava naamnaa bhuutaan tyaajayanta.m maanu.sam eka.m d.r.s.tavanto vaya.m, kintvasmaakam apa\"scaad gaamitvaat ta.m nya.sedhaam| tadaanii.m yii\"suruvaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ta.m maa ni.sedhata, yato yo janosmaaka.m na vipak.sa.h sa evaasmaaka.m sapak.so bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantara.m tasyaaroha.nasamaya upasthite sa sthiracetaa yiruu\"saalama.m prati yaatraa.m karttu.m ni\"scityaagre duutaan pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmaat te gatvaa tasya prayojaniiyadravyaa.ni sa.mgrahiitu.m \"somiro.niiyaanaa.m graama.m pravivi\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yiruu\"saalama.m nagara.m yaati tato heto rlokaastasyaatithya.m na cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataeva yaakuubyohanau tasya \"si.syau tad d.r.s.tvaa jagadatu.h, he prabho eliyo yathaa cakaara tathaa vayamapi ki.m gaga.naad aagantum etaan bhasmiikarttu nca vahnimaaj naapayaama.h? bhavaan kimicchati? ");
INSERT INTO sanvel_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukha.m paraavartya taan tarjayitvaa gaditavaan yu.smaaka.m manobhaava.h ka.h, iti yuuya.m na jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasuto manujaanaa.m praa.naan naa\"sayitu.m naagacchat, kintu rak.situm aagacchat| pa\"scaad itaragraama.m te yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantara.m pathi gamanakaale jana ekasta.m babhaa.se, he prabho bhavaan yatra yaati bhavataa sahaahamapi tatra yaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadaanii.m yii\"sustamuvaaca, gomaayuunaa.m garttaa aasate, vihaayasiiyavihagaaाnaa.m nii.daani ca santi, kintu maanavatanayasya \"sira.h sthaapayitu.m sthaana.m naasti| ");
INSERT INTO sanvel_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tata.h para.m sa itarajana.m jagaada, tva.m mama pa\"scaad ehi; tata.h sa uvaaca, he prabho puurvva.m pitara.m \"sma\"saane sthaapayitu.m maamaadi\"satu| ");
INSERT INTO sanvel_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadaa yii\"suruvaaca, m.rtaa m.rtaan \"sma\"saane sthaapayantu kintu tva.m gatve\"svariiyaraajyasya kathaa.m pracaaraya| ");
INSERT INTO sanvel_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatonya.h kathayaamaasa, he prabho mayaapi bhavata.h pa\"scaad ga.msyate, kintu puurvva.m mama nive\"sanasya parijanaanaam anumati.m grahiitum ahamaadi\"syai bhavataa| ");
INSERT INTO sanvel_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadaanii.m yii\"susta.m proktavaan, yo jano laa\"ngale karamarpayitvaa pa\"scaat pa\"syati sa ii\"svariiyaraajya.m naarhati| ");
INSERT INTO sanvel_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tata.h para.m prabhuraparaan saptati\"si.syaan niyujya svaya.m yaani nagaraa.ni yaani sthaanaani ca gami.syati taani nagaraa.ni taani sthaanaani ca prati dvau dvau janau prahitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tebhya.h kathayaamaasa ca \"sasyaani bahuuniiti satya.m kintu chedakaa alpe; tasmaaddheto.h \"sasyak.setre chedakaan aparaanapi pre.sayitu.m k.setrasvaamina.m praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yuuya.m yaata, pa\"syata, v.rkaa.naa.m madhye me.sa\"saavakaaniva yu.smaan prahi.nomi| ");
INSERT INTO sanvel_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yuuya.m k.sudra.m mahad vaa vasanasampu.taka.m paadukaa\"sca maa g.rhliita, maargamadhye kamapi maa namata ca| ");
INSERT INTO sanvel_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","apara nca yuuya.m yad yat nive\"sana.m pravi\"satha tatra nive\"sanasyaasya ma\"ngala.m bhuuyaaditi vaakya.m prathama.m vadata| ");
INSERT INTO sanvel_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmaat tasmin nive\"sane yadi ma\"ngalapaatra.m sthaasyati tarhi tanma\"ngala.m tasya bhavi.syati, nocet yu.smaan prati paraavartti.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","apara nca te yatki ncid daasyanti tadeva bhuktvaa piitvaa tasminnive\"sane sthaasyatha; yata.h karmmakaarii jano bh.rtim arhati; g.rhaad g.rha.m maa yaasyatha| ");
INSERT INTO sanvel_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyacca yu.smaasu kimapi nagara.m pravi.s.te.su lokaa yadi yu.smaakam aatithya.m kari.syanti, tarhi yat khaadyam upasthaasyanti tadeva khaadi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthaan rogi.na.h svasthaan kari.syatha, ii\"svariiya.m raajya.m yu.smaakam antikam aagamat kathaametaa nca pracaarayi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi pura.m yu.smaasu pravi.s.te.su lokaa yadi yu.smaakam aatithya.m na kari.syanti, tarhi tasya nagarasya panthaana.m gatvaa kathaametaa.m vadi.syatha, ");
INSERT INTO sanvel_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yu.smaaka.m nagariiyaa yaa dhuulyo.asmaasu samalagan taa api yu.smaaka.m praatikuulyena saak.syaartha.m sampaatayaama.h; tathaapii\"svararaajya.m yu.smaaka.m samiipam aagatam iti ni\"scita.m jaaniita| ");
INSERT INTO sanvel_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","aha.m yu.smabhya.m yathaartha.m kathayaami, vicaaradine tasya nagarasya da\"saata.h sidomo da\"saa sahyaa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","haa haa koraasiin nagara, haa haa baitsaidaanagara yuvayormadhye yaad.r\"saani aa\"scaryyaa.ni karmmaa.nyakriyanta, taani karmmaa.ni yadi sorasiidono rnagarayorakaari.syanta, tadaa ito bahudinapuurvva.m tannivaasina.h \"sa.navastraa.ni paridhaaya gaatre.su bhasma vilipya samupavi\"sya samakhetsyanta| ");
INSERT INTO sanvel_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ato vicaaradivase yu.smaaka.m da\"saata.h sorasiidonnivaasinaa.m da\"saa sahyaa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","he kapharnaahuum, tva.m svarga.m yaavad unnataa kintu naraka.m yaavat nyagbhavi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yo jano yu.smaaka.m vaakya.m g.rhlaati sa mamaiva vaakya.m g.rhlaati; ki nca yo jano yu.smaakam avaj naa.m karoti sa mamaivaavaj naa.m karoti; yo jano mamaavaj naa.m karoti ca sa matprerakasyaivaavaj naa.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha te saptati\"si.syaa aanandena pratyaagatya kathayaamaasu.h, he prabho bhavato naamnaa bhuutaa apyasmaaka.m va\"siibhavanti| ");
INSERT INTO sanvel_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadaanii.m sa taan jagaada, vidyutamiva svargaat patanta.m \"saitaanam adar\"sam| ");
INSERT INTO sanvel_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","pa\"syata sarpaan v.r\"scikaan ripo.h sarvvaparaakramaa.m\"sca padatalai rdalayitu.m yu.smabhya.m \"sakti.m dadaami tasmaad yu.smaaka.m kaapi haani rna bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhuutaa yu.smaaka.m va\"siibhavanti, etannimittat maa samullasata, svarge yu.smaaka.m naamaani likhitaani santiiti nimitta.m samullasata| ");
INSERT INTO sanvel_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadgha.tikaayaa.m yii\"su rmanasi jaataahlaada.h kathayaamaasa he svargap.rthivyorekaadhipate pitastva.m j naanavataa.m vidu.saa nca lokaanaa.m purastaat sarvvametad aprakaa\"sya baalakaanaa.m purastaat praakaa\"saya etasmaaddhetostvaa.m dhanya.m vadaami, he pitarittha.m bhavatu yad etadeva tava gocara uttamam| ");
INSERT INTO sanvel_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitraa sarvvaa.ni mayi samarpitaani pitara.m vinaa kopi putra.m na jaanaati ki nca putra.m vinaa yasmai janaaya putrasta.m prakaa\"sitavaan ta nca vinaa kopi pitara.m na jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapa.h para.m sa \"si.syaan prati paraav.rtya gupta.m jagaada, yuuyametaani sarvvaa.ni pa\"syatha tato yu.smaaka.m cak.suu.m.si dhanyaani| ");
INSERT INTO sanvel_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yu.smaanaha.m vadaami, yuuya.m yaani sarvvaa.ni pa\"syatha taani bahavo bhavi.syadvaadino bhuupataya\"sca dra.s.tumicchantopi dra.s.tu.m na praapnuvan, yu.smaabhi ryaa yaa.h kathaa\"sca \"sruuyante taa.h \"srotumicchantopi \"srotu.m naalabhanta| ");
INSERT INTO sanvel_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram eko vyavasthaapaka utthaaya ta.m pariik.situ.m papraccha, he upade\"saka anantaayu.sa.h praaptaye mayaa ki.m kara.niiya.m? ");
INSERT INTO sanvel_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yii\"su.h pratyuvaaca, atraarthe vyavasthaayaa.m ki.m likhitamasti? tva.m kiid.rk pa.thasi? ");
INSERT INTO sanvel_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tata.h sovadat, tva.m sarvvaanta.hkara.nai.h sarvvapraa.nai.h sarvva\"saktibhi.h sarvvacittai\"sca prabhau parame\"svare prema kuru, samiipavaasini svavat prema kuru ca| ");
INSERT INTO sanvel_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadaa sa kathayaamaasa, tva.m yathaartha.m pratyavoca.h, ittham aacara tenaiva jiivi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa jana.h sva.m nirddo.sa.m j naapayitu.m yii\"su.m papraccha, mama samiipavaasii ka.h? tato yii\"su.h pratyuvaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","eko jano yiruu\"saalampuraad yiriihopura.m yaati, etarhi dasyuunaa.m kare.su patite te tasya vastraadika.m h.rtavanta.h tamaahatya m.rtapraaya.m k.rtvaa tyaktvaa yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmaad eko yaajakastena maarge.na gacchan ta.m d.r.s.tvaa maargaanyapaar\"svena jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham eko leviiyastatsthaana.m praapya tasyaantika.m gatvaa ta.m vilokyaanyena paar\"svena jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintveka.h \"somiro.niiyo gacchan tatsthaana.m praapya ta.m d.r.s.tvaadayata| ");
INSERT INTO sanvel_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyaantika.m gatvaa tasya k.sate.su taila.m draak.saarasa nca prak.sipya k.sataani baddhvaa nijavaahanopari tamupave\"sya pravaasiiyag.rham aaniiya ta.m si.seve| ");
INSERT INTO sanvel_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divase nijagamanakaale dvau mudraapaadau tadg.rhasvaamine dattvaavadat janamena.m sevasva tatra yo.adhiko vyayo bhavi.syati tamaha.m punaraagamanakaale pari\"sotsyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","e.saa.m trayaa.naa.m madhye tasya dasyuhastapatitasya janasya samiipavaasii ka.h? tvayaa ki.m budhyate? ");
INSERT INTO sanvel_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tata.h sa vyavasthaapaka.h kathayaamaasa yastasmin dayaa.m cakaara| tadaa yii\"su.h kathayaamaasa tvamapi gatvaa tathaacara| ");
INSERT INTO sanvel_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tata.h para.m te gacchanta eka.m graama.m pravivi\"su.h; tadaa marthaanaamaa strii svag.rhe tasyaatithya.m cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmaat mariyam naamadheyaa tasyaa bhaginii yii\"so.h padasamiipa uvavi\"sya tasyopade\"sakathaa.m \"srotumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthaa naanaaparicaryyaayaa.m vyagraa babhuuva tasmaaddhetostasya samiipamaagatya babhaa.se; he prabho mama bhaginii kevala.m mamopari sarvvakarmma.naa.m bhaaram arpitavatii tatra bhavataa ki ncidapi na mano nidhiiyate kim? mama saahaayya.m karttu.m bhavaan taamaadi\"satu| ");
INSERT INTO sanvel_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tato yii\"su.h pratyuvaaca he marthe he marthe, tva.m naanaakaaryye.su cintitavatii vyagraa caasi, ");
INSERT INTO sanvel_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayojaniiyam ekamaatram aaste| apara nca yamuttama.m bhaaga.m kopi harttu.m na \"saknoti saeva mariyamaa v.rta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantara.m sa kasmi.m\"scit sthaane praarthayata tatsamaaptau satyaa.m tasyaika.h \"si.syasta.m jagaada he prabho yohan yathaa sva\"si.syaan praarthayitum upadi.s.tavaan tathaa bhavaanapyasmaan upadi\"satu| ");
INSERT INTO sanvel_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmaat sa kathayaamaasa, praarthanakaale yuuyam ittha.m kathayadhva.m, he asmaaka.m svargasthapitastava naama puujya.m bhavatu; tava raajatva.m bhavatu; svarge yathaa tathaa p.rthivyaamapi tavecchayaa sarvva.m bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmaaka.m prayojaniiya.m bhojya.m dehi| ");
INSERT INTO sanvel_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathaa vaya.m sarvvaan aparaadhina.h k.samaamahe tathaa tvamapi paapaanyasmaaka.m k.samasva| asmaan pariik.saa.m maanaya kintu paapaatmano rak.sa| ");
INSERT INTO sanvel_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","pa\"scaat soparamapi kathitavaan yadi yu.smaaka.m kasyacid bandhusti.s.thati ni\"siithe ca tasya samiipa.m sa gatvaa vadati, ");
INSERT INTO sanvel_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","he bandho pathika eko bandhu rmama nive\"sanam aayaata.h kintu tasyaatithya.m karttu.m mamaantike kimapi naasti, ataeva puupatraya.m mahyam .r.na.m dehi; ");
INSERT INTO sanvel_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadaa sa yadi g.rhamadhyaat prativadati maa.m maa kli\"saana, idaanii.m dvaara.m ruddha.m \"sayane mayaa saha baalakaa\"sca ti.s.thanti tubhya.m daatum utthaatu.m na \"saknomi, ");
INSERT INTO sanvel_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yu.smaanaha.m vadaami, sa yadi mitratayaa tasmai kimapi daatu.m notti.s.thati tathaapi vaara.m vaara.m praarthanaata utthaapita.h san yasmin tasya prayojana.m tadeva daasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ata.h kaara.naat kathayaami, yaacadhva.m tato yu.smabhya.m daasyate, m.rgayadhva.m tata udde\"sa.m praapsyatha, dvaaram aahata tato yu.smabhya.m dvaara.m mok.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yo yaacate sa praapnoti, yo m.rgayate sa evodde\"sa.m praapnoti, yo dvaaram aahanti tadartha.m dvaara.m mocyate| ");
INSERT INTO sanvel_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putre.na puupe yaacite tasmai paa.saa.na.m dadaati vaa matsye yaacite tasmai sarpa.m dadaati ");
INSERT INTO sanvel_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vaa a.n.de yaacite tasmai v.r\"scika.m dadaati yu.smaaka.m madhye ka etaad.r\"sa.h pitaaste? ");
INSERT INTO sanvel_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmaadeva yuuyamabhadraa api yadi svasvabaalakebhya uttamaani dravyaa.ni daatu.m jaaniitha tarhyasmaaka.m svargastha.h pitaa nijayaacakebhya.h ki.m pavitram aatmaana.m na daasyati? ");
INSERT INTO sanvel_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantara.m yii\"sunaa kasmaaccid ekasmin muukabhuute tyaajite sati sa bhuutatyakto maanu.so vaakya.m vaktum aarebhe; tato lokaa.h sakalaa aa\"scaryya.m menire| ");
INSERT INTO sanvel_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu te.saa.m keciduucu rjanoya.m baalasibuubaa arthaad bhuutaraajena bhuutaan tyaajayati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ta.m pariik.situ.m kecid aakaa\"siiyam eka.m cihna.m dar\"sayitu.m ta.m praarthayaa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadaa sa te.saa.m mana.hkalpanaa.m j naatvaa kathayaamaasa, kasyacid raajyasya lokaa yadi paraspara.m virundhanti tarhi tad raajyam na\"syati; kecid g.rhasthaa yadi paraspara.m virundhanti tarhi tepi na\"syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva \"saitaanapi svalokaan yadi viru.naddhi tadaa tasya raajya.m katha.m sthaasyati? baalasibuubaaha.m bhuutaan tyaajayaami yuuyamiti vadatha| ");
INSERT INTO sanvel_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyaha.m baalasibuubaa bhuutaan tyaajayaami tarhi yu.smaaka.m santaanaa.h kena tyaajayanti? tasmaat taeva kathaayaa etasyaa vicaarayitaaro bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham ii\"svarasya paraakrame.na bhuutaan tyaajayaami tarhi yu.smaaka.m nika.tam ii\"svarasya raajyamava\"syam upati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavaan pumaan susajjamaano yatikaala.m nijaa.t.taalikaa.m rak.sati tatikaala.m tasya dravya.m nirupadrava.m ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmaad adhikabala.h ka\"scidaagatya yadi ta.m jayati tarhi ye.su \"sastraastre.su tasya vi\"svaasa aasiit taani sarvvaa.ni h.rtvaa tasya dravyaa.ni g.rhlaati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ata.h kaara.naad yo mama sapak.so na sa vipak.sa.h, yo mayaa saha na sa.mg.rhlaati sa vikirati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","apara nca amedhyabhuuto maanu.sasyaantarnirgatya \"su.skasthaane bhraantvaa vi\"sraama.m m.rgayate kintu na praapya vadati mama yasmaad g.rhaad aagatoha.m punastad g.rha.m paraav.rtya yaami| ");
INSERT INTO sanvel_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tato gatvaa tad g.rha.m maarjita.m \"sobhita nca d.r.s.tvaa ");
INSERT INTO sanvel_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatk.sa.nam apagatya svasmaadapi durmmatiin aparaan saptabhuutaan sahaanayati te ca tadg.rha.m pavi\"sya nivasanti| tasmaat tasya manu.syasya prathamada\"saata.h \"se.sada\"saa du.hkhataraa bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyaa.h kathaayaa.h kathanakaale janataamadhyasthaa kaacinnaarii tamuccai.hsvara.m provaaca, yaa yo.sit tvaa.m garbbhe.adhaarayat stanyamapaayayacca saiva dhanyaa| ");
INSERT INTO sanvel_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sokathayat ye parame\"svarasya kathaa.m \"srutvaa tadanuruupam aacaranti taeva dhanyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tata.h para.m tasyaantike bahulokaanaa.m samaagame jaate sa vaktumaarebhe, aadhunikaa du.s.talokaa\"scihna.m dra.s.tumicchanti kintu yuunasbhavi.syadvaadina\"scihna.m vinaanyat ki nciccihna.m taan na dar\"sayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yuunas tu yathaa niiniviiyalokaanaa.m samiipe cihnaruupobhavat tathaa vidyamaanalokaanaam e.saa.m samiipe manu.syaputropi cihnaruupo bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vicaarasamaye idaaniintanalokaanaa.m praatikuulyena dak.si.nade\"siiyaa raaj nii protthaaya taan do.si.na.h kari.syati, yata.h saa raaj nii sulemaana upade\"sakathaa.m \"srotu.m p.rthivyaa.h siimaata aagacchat kintu pa\"syata sulemaanopi gurutara eko jano.asmin sthaane vidyate| ");
INSERT INTO sanvel_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","apara nca vicaarasamaye niiniviiyalokaa api varttamaanakaalikaanaa.m lokaanaa.m vaipariityena protthaaya taan do.si.na.h kari.syanti, yato hetoste yuunaso vaakyaat cittaani parivarttayaamaasu.h kintu pa\"syata yuunasotigurutara eko jano.asmin sthaane vidyate| ");
INSERT INTO sanvel_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradiipa.m prajvaalya dro.nasyaadha.h kutraapi guptasthaane vaa kopi na sthaapayati kintu g.rhaprave\"sibhyo diipti.m daata.m diipaadhaaroparyyeva sthaapayati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dehasya pradiipa\"scak.sustasmaadeva cak.su ryadi prasanna.m bhavati tarhi tava sarvva\"sariira.m diiptimad bhavi.syati kintu cak.su ryadi maliimasa.m ti.s.thati tarhi sarvva\"sariira.m saandhakaara.m sthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmaat kaara.naat tavaanta.hstha.m jyoti ryathaandhakaaramaya.m na bhavati tadarthe saavadhaano bhava| ");
INSERT INTO sanvel_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yata.h \"sariirasya kutraapya.m\"se saandhakaare na jaate sarvva.m yadi diiptimat ti.s.thati tarhi tubhya.m diiptidaayiprojjvalan pradiipa iva tava savarva\"sariira.m diiptimad bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","etatkathaayaa.h kathanakaale phiru\"syeko bhejanaaya ta.m nimantrayaamaasa, tata.h sa gatvaa bhoktum upavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhojanaat puurvva.m naamaa\"nk.siit etad d.r.s.tvaa sa phiru\"syaa\"scaryya.m mene| ");
INSERT INTO sanvel_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadaa prabhusta.m provaaca yuuya.m phiruu\"silokaa.h paanapaatraa.naa.m bhojanapaatraa.naa nca bahi.h pari.skurutha kintu yu.smaakamanta rdauraatmyai rdu.skriyaabhi\"sca paripuur.na.m ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","he sarvve nirbodhaa yo bahi.h sasarja sa eva kimanta rna sasarja? ");
INSERT INTO sanvel_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata eva yu.smaabhiranta.hkara.na.m (ii\"svaraaya) nivedyataa.m tasmin k.rte yu.smaaka.m sarvvaa.ni \"sucitaa.m yaasyanti| ");
INSERT INTO sanvel_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phiruu\"siga.naa yuuya.m nyaayam ii\"svare prema ca parityajya podinaayaa arudaadiinaa.m sarvve.saa.m \"saakaanaa nca da\"samaa.m\"saan dattha kintu prathama.m paalayitvaa \"se.sasyaala\"nghana.m yu.smaakam ucitamaasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","haa haa phiruu\"sino yuuya.m bhajanagehe proccaasane aapa.ne.su ca namaskaare.su priiyadhve| ");
INSERT INTO sanvel_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapa.tino.adhyaapakaa.h phiruu\"sina\"sca lokaayat \"sma\"saanam anupalabhya tadupari gacchanti yuuyam taad.rgaprakaa\"sita\"sma\"saanavaad bhavatha| ");
INSERT INTO sanvel_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadaanii.m vyavasthaapakaanaam ekaa yii\"sumavadat, he upade\"saka vaakyened.r\"senaasmaasvapi do.sam aaropayasi| ");
INSERT INTO sanvel_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tata.h sa uvaaca, haa haa vyavasthaapakaa yuuyam maanu.saa.naam upari du.hsahyaan bhaaraan nyasyatha kintu svayam ekaa\"nguुlyaapi taan bhaaraan na sp.r\"satha| ");
INSERT INTO sanvel_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yu.smaaka.m puurvvapuru.saa yaan bhavi.syadvaadino.avadhi.suste.saa.m \"sma\"saanaani yuuya.m nirmmaatha| ");
INSERT INTO sanvel_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tenaiva yuuya.m svapuurvvapuru.saa.naa.m karmmaa.ni sa.mmanyadhve tadeva sapramaa.na.m kurutha ca, yataste taanavadhi.su.h yuuya.m te.saa.m \"sma\"saanaani nirmmaatha| ");
INSERT INTO sanvel_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataeva ii\"svarasya \"saastre proktamasti te.saamantike bhavi.syadvaadina.h preritaa.m\"sca pre.sayi.syaami tataste te.saa.m kaa.m\"scana hani.syanti kaa.m\"scana taa.da\"s.syinti| ");
INSERT INTO sanvel_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","etasmaat kaara.naat haabila.h \"so.nitapaatamaarabhya mandirayaj navedyo rmadhye hatasya sikhariyasya raktapaataparyyanta.m ");
INSERT INTO sanvel_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagata.h s.r.s.timaarabhya p.rthivyaa.m bhavi.syadvaadinaa.m yatiraktapaataa jaataastatiinaam aparaadhada.n.daa e.saa.m varttamaanalokaanaa.m bhavi.syanti, yu.smaanaha.m ni\"scita.m vadaami sarvve da.n.daa va.m\"sasyaasya bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","haa haa vyavasthapakaa yuuya.m j naanasya ku ncikaa.m h.rtvaa svaya.m na pravi.s.taa ye prave.s.tu nca prayaasinastaanapi prave.s.tu.m vaaritavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ittha.m kathaakathanaad adhyaapakaa.h phiruu\"sina\"sca satarkaa.h ");
INSERT INTO sanvel_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavaditu.m tasya kathaayaa do.sa.m dharttamicchanto naanaakhyaanakathanaaya ta.m pravarttayitu.m kopayitu nca praarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadaanii.m lokaa.h sahasra.m sahasram aagatya samupasthitaastata ekaiko .anye.saamupari patitum upacakrame; tadaa yii\"su.h \"si.syaan babhaa.se, yuuya.m phiruu\"sinaa.m ki.nvaruupakaapa.tye vi\"se.se.na saavadhaanaasti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yato yanna prakaa\"sayi.syate tadaacchanna.m vastu kimapi naasti; tathaa yanna j naasyate tad gupta.m vastu kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakaare ti.s.thanato yaa.h kathaa akathayata taa.h sarvvaa.h kathaa diiptau \"sro.syante nirjane kar.ne ca yadakathayata g.rhap.r.s.thaat tat pracaarayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","he bandhavo yu.smaanaha.m vadaami, ye \"sariirasya naa\"sa.m vinaa kimapyapara.m karttu.m na \"sakruvanti tebhyo maa bhai.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmaad bhetavyam ityaha.m vadaami, ya.h \"sariira.m naa\"sayitvaa naraka.m nik.septu.m \"saknoti tasmaadeva bhaya.m kuruta, punarapi vadaami tasmaadeva bhaya.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","pa nca ca.takapak.si.na.h ki.m dvaabhyaa.m taamrakha.n.daabhyaa.m na vikriiyante? tathaapii\"svaraste.saam ekamapi na vismarati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yu.smaaka.m \"sira.hke\"saa api ga.nitaa.h santi tasmaat maa vibhiita bahuca.takapak.sibhyopi yuuya.m bahumuulyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","apara.m yu.smabhya.m kathayaami ya.h ka\"scin maanu.saa.naa.m saak.saan maa.m sviikaroti manu.syaputra ii\"svaraduutaanaa.m saak.saat ta.m sviikari.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu ya.h ka\"scinmaanu.saa.naa.m saak.saanmaam asviikaroti tam ii\"svarasya duutaanaa.m saak.saad aham asviikari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyacca ya.h ka\"scin manujasutasya nindaabhaavena kaa ncit kathaa.m kathayati tasya tatpaapasya mocana.m bhavi.syati kintu yadi ka\"scit pavitram aatmaana.m nindati tarhi tasya tatpaapasya mocana.m na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadaa lokaa yu.smaan bhajanageha.m vicaarakart.rraajyakart.r.naa.m sammukha nca ne.syanti tadaa kena prakaare.na kimuttara.m vadi.syatha ki.m kathayi.syatha cetyatra maa cintayata; ");
INSERT INTO sanvel_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yato yu.smaabhiryad yad vaktavya.m tat tasmin samayaeva pavitra aatmaa yu.smaan \"sik.sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tata.h para.m janataamadhyastha.h ka\"scijjanasta.m jagaada he guro mayaa saha pait.rka.m dhana.m vibhaktu.m mama bhraataramaaj naapayatu bhavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat he manu.sya yuvayo rvicaara.m vibhaaga nca karttu.m maa.m ko niyuktavaan? ");
INSERT INTO sanvel_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantara.m sa lokaanavadat lobhe saavadhaanaa.h satarkaa\"sca ti.s.thata, yato bahusampattipraaptyaa manu.syasyaayu rna bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","pa\"scaad d.r.s.taantakathaamutthaapya kathayaamaasa, ekasya dhanino bhuumau bahuuni \"sasyaani jaataani| ");
INSERT INTO sanvel_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tata.h sa manasaa cintayitvaa kathayaambabhuuva mamaitaani samutpannaani dravyaa.ni sthaapayitu.m sthaana.m naasti ki.m kari.syaami? ");
INSERT INTO sanvel_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatovadad ittha.m kari.syaami, mama sarvvabhaa.n.daagaaraa.ni bha\"nktvaa b.rhadbhaa.n.daagaaraa.ni nirmmaaya tanmadhye sarvvaphalaani dravyaa.ni ca sthaapayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","apara.m nijamano vadi.syaami, he mano bahuvatsaraartha.m naanaadravyaa.ni sa ncitaani santi vi\"sraama.m kuru bhuktvaa piitvaa kautuka nca kuru| kintvii\"svarastam avadat, ");
INSERT INTO sanvel_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","re nirbodha adya raatrau tava praa.naastvatto ne.syante tata etaani yaani dravyaa.ni tvayaasaaditaani taani kasya bhavi.syanti? ");
INSERT INTO sanvel_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataeva ya.h ka\"scid ii\"svarasya samiipe dhanasa ncayamak.rtvaa kevala.m svanika.te sa ncaya.m karoti sopi taad.r\"sa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa \"si.syebhya.h kathayaamaasa, yu.smaanaha.m vadaami, ki.m khaadi.syaama.h? ki.m paridhaasyaama.h? ityuktvaa jiivanasya \"sariirasya caartha.m cintaa.m maa kaar.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhak.syaajjiivana.m bhuu.sa.naacchariira nca \"sre.s.tha.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kaakapak.si.naa.m kaaryya.m vicaarayata, te na vapanti \"sasyaani ca na chindanti, te.saa.m bhaa.n.daagaaraa.ni na santi ko.saa\"sca na santi, tathaapii\"svarastebhyo bhak.syaa.ni dadaati, yuuya.m pak.sibhya.h \"sre.s.thataraa na ki.m? ");
INSERT INTO sanvel_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","apara nca bhaavayitvaa nijaayu.sa.h k.sa.namaatra.m varddhayitu.m \"saknoti, etaad.r\"so laako yu.smaaka.m madhye kosti? ");
INSERT INTO sanvel_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataeva k.sudra.m kaaryya.m saadhayitum asamarthaa yuuyam anyasmin kaaryye kuto bhaavayatha? ");
INSERT INTO sanvel_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyacca kaampilapu.spa.m katha.m varddhate tadaapi vicaarayata, tat ka ncana \"srama.m na karoti tantuu.m\"sca na janayati kintu yu.smabhya.m yathaartha.m kathayaami sulemaan bahvai\"svaryyaanvitopi pu.spasyaasya sad.r\"so vibhuu.sito naasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya k.setre varttamaana.m \"sva\"scuullyaa.m k.sepsyamaana.m yat t.r.na.m, tasmai yadii\"svara ittha.m bhuu.sayati tarhi he alpapratyayino yu.smaana ki.m na paridhaapayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataeva ki.m khaadi.syaama.h? ki.m paridhaasyaama.h? etadartha.m maa ce.s.tadhva.m maa sa.mdigdhva nca| ");
INSERT INTO sanvel_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagato devaarccakaa etaani sarvvaa.ni ce.s.tanate; e.su vastu.su yu.smaaka.m prayojanamaaste iti yu.smaaka.m pitaa jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataeve\"svarasya raajyaartha.m sace.s.taa bhavata tathaa k.rte sarvvaa.nyetaani dravyaa.ni yu.smabhya.m pradaayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","he k.sudrame.savraja yuuya.m maa bhai.s.ta yu.smabhya.m raajya.m daatu.m yu.smaaka.m pitu.h sammatirasti| ");
INSERT INTO sanvel_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataeva yu.smaaka.m yaa yaa sampattirasti taa.m taa.m vikriiya vitarata, yat sthaana.m cauraa naagacchanti, kii.taa\"sca na k.saayayanti taad.r\"se svarge nijaartham ajare sampu.take .ak.saya.m dhana.m sa ncinuta ca; ");
INSERT INTO sanvel_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yato yatra yu.smaaka.m dhana.m varttate tatreva yu.smaaka.m mana.h| ");
INSERT INTO sanvel_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","apara nca yuuya.m pradiipa.m jvaalayitvaa baddhaka.tayasti.s.thata; ");
INSERT INTO sanvel_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivaahaadaagatya yadaiva dvaaramaahanti tadaiva dvaara.m mocayitu.m yathaa bh.rtyaa apek.sya ti.s.thanti tathaa yuuyamapi ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yata.h prabhuraagatya yaan daasaan sacetanaan ti.s.thato drak.syati taeva dhanyaa.h; aha.m yu.smaan yathaartha.m vadaami prabhustaan bhojanaartham upave\"sya svaya.m baddhaka.ti.h samiipametya parive.sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitiiye t.rtiiye vaa prahare samaagatya tathaiva pa\"syati, tarhi taeva daasaa dhanyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","apara nca kasmin k.sa.ne cauraa aagami.syanti iti yadi g.rhapati rj naatu.m \"saknoti tadaava\"sya.m jaagran nijag.rhe sandhi.m karttayitu.m vaarayati yuuyametad vitta| ");
INSERT INTO sanvel_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataeva yuuyamapi sajjamaanaasti.s.thata yato yasmin k.sa.ne ta.m naaprek.sadhve tasminneva k.sa.ne manu.syaputra aagami.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadaa pitara.h papraccha, he prabho bhavaan kimasmaan uddi\"sya ki.m sarvvaan uddi\"sya d.r.s.taantakathaamimaa.m vadati? ");
INSERT INTO sanvel_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tata.h prabhu.h provaaca, prabhu.h samucitakaale nijaparivaaraartha.m bhojyaparive.sa.naaya ya.m tatpade niyok.syati taad.r\"so vi\"svaasyo boddhaa karmmaadhii\"sa.h kosti? ");
INSERT INTO sanvel_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhuraagatya yam etaad.r\"se karmma.ni prav.rtta.m drak.syati saeva daaso dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","aha.m yu.smaan yathaartha.m vadaami sa ta.m nijasarvvasvasyaadhipati.m kari.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambenaagami.syati, iti vicintya sa daaso yadi tadanyadaasiidaasaan praharttum bhoktu.m paatu.m maditu nca praarabhate, ");
INSERT INTO sanvel_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadaa prabhu.m naapek.si.syate yasmin k.sa.ne so.acetana\"sca sthaasyati tasminneva k.sa.ne tasya prabhuraagatya ta.m padabhra.s.ta.m k.rtvaa vi\"svaasahiinai.h saha tasya a.m\"sa.m niruupayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yo daasa.h prabheाraaj naa.m j naatvaapi sajjito na ti.s.thati tadaaj naanusaare.na ca kaaryya.m na karoti sonekaan prahaaraan praapsyati; ");
INSERT INTO sanvel_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yo jano.aj naatvaa prahaaraarha.m karmma karoti solpaprahaaraan praapsyati| yato yasmai baahulyena datta.m tasmaadeva baahulyena grahii.syate, maanu.saa yasya nika.te bahu samarpayanti tasmaad bahu yaacante| ");
INSERT INTO sanvel_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","aha.m p.rthivyaam anaikyaruupa.m vahni nik.septum aagatosmi, sa ced idaaniimeva prajvalati tatra mama kaa cintaa? ");
INSERT INTO sanvel_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yena majjanenaaha.m magno bhavi.syaami yaavatkaala.m tasya siddhi rna bhavi.syati taavadaha.m katika.s.ta.m praapsyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","melana.m karttu.m jagad aagatosmi yuuya.m kimittha.m bodhadhve? yu.smaan vadaami na tathaa, kintvaha.m melanaabhaava.m karttu.mm aagatosmi| ");
INSERT INTO sanvel_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmaadetatkaalamaarabhya ekatrasthaparijanaanaa.m madhye pa ncajanaa.h p.rthag bhuutvaa trayo janaa dvayorjanayo.h pratikuulaa dvau janau ca trayaa.naa.m janaanaa.m pratikuulau bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitaa putrasya vipak.sa.h putra\"sca pitu rvipak.so bhavi.syati maataa kanyaayaa vipak.saa kanyaa ca maatu rvipak.saa bhavi.syati, tathaa \"sva\"sruurbadhvaa vipak.saa badhuu\"sca \"sva\"srvaa vipak.saa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lokebhyoparamapi kathayaamaasa, pa\"scimadi\"si meghodgama.m d.r.s.tvaa yuuya.m ha.thaad vadatha v.r.s.ti rbhavi.syati tatastathaiva jaayate| ");
INSERT INTO sanvel_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","apara.m dak.si.nato vaayau vaati sati vadatha nidaagho bhavi.syati tata.h sopi jaayate| ");
INSERT INTO sanvel_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","re re kapa.tina aakaa\"sasya bhuumyaa\"sca lak.sa.na.m boddhu.m \"saknutha, ");
INSERT INTO sanvel_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kaalasyaasya lak.sa.na.m kuto boddhu.m na \"saknutha? yuuya nca svaya.m kuto na nyaa.sya.m vicaarayatha? ");
INSERT INTO sanvel_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","apara nca vivaadinaa saarddha.m vicaarayitu.h samiipa.m gacchan pathi tasmaaduddhaara.m praaptu.m yatasva nocet sa tvaa.m dh.rtvaa vicaarayitu.h samiipa.m nayati| vicaarayitaa yadi tvaa.m praharttu.h samiipa.m samarpayati praharttaa tvaa.m kaaraayaa.m badhnaati ");
INSERT INTO sanvel_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvaamaha.m vadaami tvayaa ni.h\"se.sa.m kapardake.su na pari\"sodhite.su tva.m tato mukti.m praaptu.m na \"sak.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","apara nca piilaato ye.saa.m gaaliiliiyaanaa.m raktaani baliinaa.m raktai.h sahaami\"srayat te.saa.m gaaliiliiyaanaa.m v.rttaanta.m katipayajanaa upasthaapya yii\"save kathayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tata.h sa pratyuvaaca te.saa.m lokaanaam etaad.r\"sii durgati rgha.titaa tatkaara.naad yuuya.m kimanyebhyo gaaliiliiyebhyopyadhikapaapinastaan bodhadhve? ");
INSERT INTO sanvel_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yu.smaanaha.m vadaami tathaa na kintu mana.hsu na paraavarttite.su yuuyamapi tathaa na.mk.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","apara nca \"siilohanaamna uccag.rhasya patanaad ye.a.s.taada\"sajanaa m.rtaaste yiruu\"saalami nivaasisarvvalokebhyo.adhikaaparaadhina.h ki.m yuuyamitya.m bodhadhve? ");
INSERT INTO sanvel_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yu.smaanaha.m vadaami tathaa na kintu mana.hsu na parivarttite.su yuuyamapi tathaa na.mk.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantara.m sa imaa.m d.r.s.taantakathaamakathayad eko jano draak.saak.setramadhya ekamu.dumbarav.rk.sa.m ropitavaan| pa\"scaat sa aagatya tasmin phalaani gave.sayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalaapraapte.h kaara.naad udyaanakaara.m bh.rtya.m jagaada, pa\"sya vatsaratraya.m yaavadaagatya etasminnu.dumbaratarau k.salaanyanvicchaami, kintu naikamapi prapnomi taruraya.m kuto v.rthaa sthaana.m vyaapya ti.s.thati? ena.m chindhi| ");
INSERT INTO sanvel_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tato bh.rtya.h pratyuvaaca, he prabho punarvar.sameka.m sthaatum aadi\"sa; etasya muulasya caturdik.su khanitvaaham aalavaala.m sthaapayaami| ");
INSERT INTO sanvel_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tata.h phalitu.m \"saknoti yadi na phalati tarhi pa\"scaat chetsyasi| ");
INSERT INTO sanvel_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha vi\"sraamavaare bhajanagehe yii\"surupadi\"sati ");
INSERT INTO sanvel_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samaye bhuutagrastatvaat kubjiibhuuyaa.s.taada\"savar.saa.ni yaavat kenaapyupaayena .rju rbhavitu.m na \"saknoti yaa durbbalaa strii, ");
INSERT INTO sanvel_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","taa.m tatropasthitaa.m vilokya yii\"sustaamaahuuya kathitavaan he naari tava daurbbalyaat tva.m muktaa bhava| ");
INSERT INTO sanvel_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tata.h para.m tasyaa gaatre hastaarpa.namaatraat saa .rjurbhuutve\"svarasya dhanyavaada.m karttumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu vi\"sraamavaare yii\"sunaa tasyaa.h svaasthyakara.naad bhajanagehasyaadhipati.h prakupya lokaan uvaaca, .sa.tsu dine.su lokai.h karmma karttavya.m tasmaaddheto.h svaasthyaartha.m te.su dine.su aagacchata, vi\"sraamavaare maagacchata| ");
INSERT INTO sanvel_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadaa pabhu.h pratyuvaaca re kapa.tino yu.smaakam ekaiko jano vi\"sraamavaare sviiya.m sviiya.m v.r.sabha.m gardabha.m vaa bandhanaanmocayitvaa jala.m paayayitu.m ki.m na nayati? ");
INSERT INTO sanvel_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyaa.s.taada\"savatsaraan yaavat \"saitaanaa baddhaa ibraahiima.h santatiriya.m naarii ki.m vi\"sraamavaare na mocayitavyaa? ");
INSERT INTO sanvel_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","e.su vaakye.su kathite.su tasya vipak.saa.h salajjaa jaataa.h kintu tena k.rtasarvvamahaakarmmakaara.naat lokanivaha.h saanando.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantara.m sovadad ii\"svarasya raajya.m kasya sad.r\"sa.m? kena tadupamaasyaami? ");
INSERT INTO sanvel_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sar.sapabiija.m g.rhiitvaa ka\"scijjana udyaana uptavaan tad biijama\"nkurita.m sat mahaav.rk.so.ajaayata, tatastasya \"saakhaasu vihaayasiiyavihagaa aagatya nyuu.su.h, tadraajya.m taad.r\"sena sar.sapabiijena tulya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","puna.h kathayaamaasa, ii\"svarasya raajya.m kasya sad.r\"sa.m vadi.syaami? yat ki.nva.m kaacit strii g.rhiitvaa dro.natrayaparimitagodhuumacuur.ne.su sthaapayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tata.h krame.na tat sarvvagodhuumacuur.na.m vyaapnoti, tasya ki.nvasya tulyam ii\"svarasya raajya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tata.h sa yiruu\"saalamnagara.m prati yaatraa.m k.rtvaa nagare nagare graame graame samupadi\"san jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadaa ka\"scijjanasta.m papraccha, he prabho ki.m kevalam alpe lokaa.h paritraasyante? ");
INSERT INTO sanvel_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tata.h sa lokaan uvaaca, sa.mkiir.nadvaare.na prave.s.tu.m yataghva.m, yatoha.m yu.smaan vadaami, bahava.h prave.s.tu.m ce.s.ti.syante kintu na \"sak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","g.rhapatinotthaaya dvaare ruddhe sati yadi yuuya.m bahi.h sthitvaa dvaaramaahatya vadatha, he prabho he prabho asmatkaara.naad dvaara.m mocayatu, tata.h sa iti prativak.syati, yuuya.m kutratyaa lokaa ityaha.m na jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadaa yuuya.m vadi.syatha, tava saak.saad vaya.m bheाjana.m paana nca k.rtavanta.h, tva ncaasmaaka.m nagarasya pathi samupadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vak.syati, yu.smaanaha.m vadaami, yuuya.m kutratyaa lokaa ityaha.m na jaanaami; he duraacaari.no yuuya.m matto duuriibhavata| ");
INSERT INTO sanvel_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadaa ibraahiima.m ishaaka.m yaakuuba nca sarvvabhavi.syadvaadina\"sca ii\"svarasya raajya.m praaptaan svaa.m\"sca bahi.sk.rtaan d.r.s.tvaa yuuya.m rodana.m dantairdantaghar.sa.na nca kari.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","apara nca puurvvapa\"scimadak.si.nottaradigbhyo lokaa aagatya ii\"svarasya raajye nivatsyanti| ");
INSERT INTO sanvel_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","pa\"syatettha.m \"se.siiyaa lokaa agraa bhavi.syanti, agriiyaa lokaa\"sca \"se.saa bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","apara nca tasmin dine kiyanta.h phiruu\"sina aagatya yii\"su.m procu.h, bahirgaccha, sthaanaadasmaat prasthaana.m kuru, herod tvaa.m jighaa.msati| ");
INSERT INTO sanvel_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tata.h sa pratyavocat pa\"syataadya \"sva\"sca bhuutaan vihaapya rogi.no.arogi.na.h k.rtvaa t.rtiiyehni setsyaami, kathaametaa.m yuuyamitvaa ta.m bhuurimaaya.m vadata| ");
INSERT INTO sanvel_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatraapyadya \"sva.h para\"sva\"sca mayaa gamanaagamane karttavye, yato heto ryiruu\"saalamo bahi.h kutraapi kopi bhavi.syadvaadii na ghaani.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","he yiruu\"saalam he yiruu\"saalam tva.m bhavi.syadvaadino ha.msi tavaantike preritaan prastarairmaarayasi ca, yathaa kukku.tii nijapak.saadha.h sva\"saavakaan sa.mg.rhlaati, tathaahamapi tava \"si\"suun sa.mgrahiitu.m kativaaraan aiccha.m kintu tva.m naiccha.h| ");
INSERT INTO sanvel_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","pa\"syata yu.smaaka.m vaasasthaanaani procchidyamaanaani parityaktaani ca bhavi.syanti; yu.smaanaha.m yathaartha.m vadaami, ya.h prabho rnaamnaagacchati sa dhanya iti vaaca.m yaavatkaala.m na vadi.syatha, taavatkaala.m yuuya.m maa.m na drak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantara.m vi\"sraamavaare yii\"sau pradhaanasya phiruu\"sino g.rhe bhoktu.m gatavati te ta.m viik.situm aarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadaa jalodarii tasya sammukhe sthita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tata.h sa vyavasthaapakaan phiruu\"sina\"sca papraccha, vi\"sraamavaare svaasthya.m karttavya.m na vaa? tataste kimapi na pratyuucu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadaa sa ta.m rogi.na.m svastha.m k.rtvaa visasarja; ");
INSERT INTO sanvel_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","taanuvaaca ca yu.smaaka.m kasyacid garddabho v.r.sabho vaa ced gartte patati tarhi vi\"sraamavaare tatk.sa.na.m sa ki.m ta.m notthaapayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tataste kathaayaa etasyaa.h kimapi prativaktu.m na \"seku.h| ");
INSERT INTO sanvel_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","apara nca pradhaanasthaanamanoniitatvakara.na.m vilokya sa nimantritaan etadupade\"sakathaa.m jagaada, ");
INSERT INTO sanvel_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tva.m vivaahaadibhojye.su nimantrita.h san pradhaanasthaane mopaavek.sii.h| tvatto gauravaanvitanimantritajana aayaate ");
INSERT INTO sanvel_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitaagatya manu.syaayaitasmai sthaana.m dehiiti vaakya.m ced vak.syati tarhi tva.m sa\"nkucito bhuutvaa sthaana itarasmin upave.s.tum udya.msyasi| ");
INSERT INTO sanvel_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmaat kaara.naadeva tva.m nimantrito gatvaa.apradhaanasthaana upavi\"sa, tato nimantrayitaagatya vadi.syati, he bandho proccasthaana.m gatvopavi\"sa, tathaa sati bhojanopavi.s.taanaa.m sakalaanaa.m saak.saat tva.m maanyo bhavi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ya.h ka\"scit svamunnamayati sa namayi.syate, kintu ya.h ka\"scit sva.m namayati sa unnamayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadaa sa nimantrayitaara.m janamapi jagaada, madhyaahne raatrau vaa bhojye k.rte nijabandhuga.no vaa bhraat.rृga.no vaa j naatiga.no vaa dhaniga.no vaa samiipavaasiga.no vaa etaan na nimantraya, tathaa k.rte cet te tvaa.m nimantrayi.syanti, tarhi pari\"sodho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadaa bhejya.m karo.si tadaa daridra\"su.skakarakha njaandhaan nimantraya, ");
INSERT INTO sanvel_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata aa\"si.sa.m lapsyase, te.su pari\"sodha.m karttuma\"saknuvatsu \"sma\"saanaaddhaarmmikaanaamutthaanakaale tva.m phalaa.m lapsyase| ");
INSERT INTO sanvel_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantara.m taa.m kathaa.m ni\"samya bhojanopavi.s.ta.h ka\"scit kathayaamaasa, yo jana ii\"svarasya raajye bhoktu.m lapsyate saeva dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tata.h sa uvaaca, ka\"scit jano raatrau bheाjya.m k.rtvaa bahuun nimantrayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tato bhojanasamaye nimantritalokaan aahvaatu.m daasadvaaraa kathayaamaasa, khadyadravyaa.ni sarvvaa.ni samaasaaditaani santi, yuuyamaagacchata| ");
INSERT INTO sanvel_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu te sarvva ekaika.m chala.m k.rtvaa k.samaa.m praarthayaa ncakrire| prathamo jana.h kathayaamaasa, k.setrameka.m kriitavaanaha.m tadeva dra.s.tu.m mayaa gantavyam, ataeva maa.m k.santu.m ta.m nivedaya| ");
INSERT INTO sanvel_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyo jana.h kathayaamaasa, da\"sav.r.saanaha.m kriitavaan taan pariik.situ.m yaami tasmaadeva maa.m k.santu.m ta.m nivedaya| ");
INSERT INTO sanvel_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","apara.h kathayaamaasa, vyuu.dhavaanaha.m tasmaat kaara.naad yaatu.m na \"saknomi| ");
INSERT INTO sanvel_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","pa\"scaat sa daaso gatvaa nijaprabho.h saak.saat sarvvav.rttaanta.m nivedayaamaasa, tatosau g.rhapati.h kupitvaa svadaasa.m vyaajahaara, tva.m satvara.m nagarasya sannive\"saan maargaa.m\"sca gatvaa daridra\"su.skakarakha njaandhaan atraanaya| ");
INSERT INTO sanvel_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tato daaso.avadat, he prabho bhavata aaj naanusaare.naakriyata tathaapi sthaanamasti| ");
INSERT INTO sanvel_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadaa prabhu.h puna rdaasaayaakathayat, raajapathaan v.rk.samuulaani ca yaatvaa madiiyag.rhapuura.naartha.m lokaanaagantu.m pravarttaya| ");
INSERT INTO sanvel_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","aha.m yu.smabhya.m kathayaami, puurvvanimantritaanamekopi mamaasya raatribhojyasyaasvaada.m na praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantara.m bahu.su loke.su yii\"so.h pa\"scaad vrajite.su satsu sa vyaaghu.tya tebhya.h kathayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ya.h ka\"scin mama samiipam aagatya svasya maataa pitaa patnii santaanaa bhraataro bhagimyo nijapraa.naa\"sca, etebhya.h sarvvebhyo mayyadhika.m prema na karoti, sa mama \"si.syo bhavitu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ya.h ka\"scit sviiya.m kru\"sa.m vahan mama pa\"scaanna gacchati, sopi mama \"si.syo bhavitu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmaa.ne kativyayo bhavi.syati, tathaa tasya samaaptikara.naartha.m sampattirasti na vaa, prathamamupavi\"sya etanna ga.nayati, yu.smaaka.m madhya etaad.r\"sa.h kosti? ");
INSERT INTO sanvel_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","noced bhitti.m k.rtvaa \"se.se yadi samaapayitu.m na \"sak.syati, ");
INSERT INTO sanvel_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi maanu.soya.m nicetum aarabhata samaapayitu.m naa\"saknot, iti vyaah.rtya sarvve tamupahasi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","apara nca bhinnabhuupatinaa saha yuddha.m karttum udyamya da\"sasahasraa.ni sainyaani g.rhiitvaa vi.m\"satisahasre.h sainyai.h sahitasya samiipavaasina.h sammukha.m yaatu.m \"sak.syaami na veti prathama.m upavi\"sya na vicaarayati etaad.r\"so bhuumipati.h ka.h? ");
INSERT INTO sanvel_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na \"saknoti tarhi ripaavatiduure ti.s.thati sati nijaduuta.m pre.sya sandhi.m karttu.m praarthayeta| ");
INSERT INTO sanvel_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yu.smaaka.m madhye ya.h ka\"scin madartha.m sarvvasva.m haatu.m na \"saknoti sa mama \"si.syo bhavitu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lava.nam uttamam iti satya.m, kintu yadi lava.nasya lava.natvam apagacchati tarhi tat katha.m svaaduyukta.m bhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhuumyartham aalavaalaraa\"syarthamapi bhadra.m na bhavati; lokaastad bahi.h k.sipanti|yasya \"srotu.m \"srotre sta.h sa \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadaa karasa ncaayina.h paapina\"sca lokaa upade\"skathaa.m \"srotu.m yii\"so.h samiipam aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tata.h phiruu\"sina upaadhyaayaa\"sca vivadamaanaa.h kathayaamaasu.h e.sa maanu.sa.h paapibhi.h saha pra.naya.m k.rtvaa tai.h saarddha.m bhu.mkte| ");
INSERT INTO sanvel_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadaa sa tebhya imaa.m d.r.s.taantakathaa.m kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyacit \"satame.se.su ti.s.thatmu te.saameka.m sa yadi haarayati tarhi madhyepraantaram ekona\"satame.saan vihaaya haaritame.sasya udde\"sapraaptiparyyanata.m na gave.sayati, etaad.r\"so loko yu.smaaka.m madhye ka aaste? ");
INSERT INTO sanvel_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyodde\"sa.m praapya h.r.s.tamanaasta.m skandhe nidhaaya svasthaanam aaniiya bandhubaandhavasamiipavaasina aahuuya vakti, ");
INSERT INTO sanvel_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","haarita.m me.sa.m praaptoham ato heto rmayaa saarddham aanandata| ");
INSERT INTO sanvel_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadaha.m yu.smaan vadaami, ye.saa.m mana.hparaavarttanasya prayojana.m naasti, taad.r\"saikona\"satadhaarmmikakaara.naad ya aanandastasmaad ekasya mana.hparivarttina.h paapina.h kaara.naat svarge .adhikaanando jaayate| ");
INSERT INTO sanvel_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","apara nca da\"saanaa.m ruupyakha.n.daanaam ekakha.n.de haarite pradiipa.m prajvaalya g.rha.m sammaarjya tasya praapti.m yaavad yatnena na gave.sayati, etaad.r\"sii yo.sit kaaste? ");
INSERT INTO sanvel_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","praapte sati bandhubaandhavasamiipavaasiniiraahuuya kathayati, haarita.m ruupyakha.n.da.m praaptaaha.m tasmaadeva mayaa saarddham aanandata| ");
INSERT INTO sanvel_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadaha.m yu.smaan vyaaharaami, ekena paapinaa manasi parivarttite, ii\"svarasya duutaanaa.m madhyepyaanando jaayate| ");
INSERT INTO sanvel_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","apara nca sa kathayaamaasa, kasyacid dvau putraavaastaa.m, ");
INSERT INTO sanvel_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayo.h kani.s.tha.h putra.h pitre kathayaamaasa, he pitastava sampattyaa yama.m\"sa.m praapsyaamyaha.m vibhajya ta.m dehi, tata.h pitaa nijaa.m sampatti.m vibhajya taabhyaa.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayaat kaalaat para.m sa kani.s.thaputra.h samasta.m dhana.m sa.mg.rhya duurade\"sa.m gatvaa du.s.taacara.nena sarvvaa.m sampatti.m naa\"sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhane vyaya.m gate tadde\"se mahaadurbhik.sa.m babhuuva, tatastasya dainyada\"saa bhavitum aarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tata.h para.m sa gatvaa tadde\"siiya.m g.rhasthamekam aa\"srayata; tata.h sata.m \"suukaravraja.m caarayitu.m praantara.m pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kenaapi tasmai bhak.syaadaanaat sa \"suukaraphalavalkalena pici.n.dapuura.naa.m vavaa ncha| ");
INSERT INTO sanvel_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","\"se.se sa manasi cetanaa.m praapya kathayaamaasa, haa mama pitu.h samiipe kati kati vetanabhujo daasaa yathe.s.ta.m tatodhika nca bhak.sya.m praapnuvanti kintvaha.m k.sudhaa mumuur.su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthaaya pitu.h samiipa.m gatvaa kathaametaa.m vadi.syaami, he pitar ii\"svarasya tava ca viruddha.m paapamakaravam ");
INSERT INTO sanvel_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra_iti vikhyaato bhavitu.m na yogyosmi ca, maa.m tava vaitanika.m daasa.m k.rtvaa sthaapaya| ");
INSERT INTO sanvel_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","pa\"scaat sa utthaaya pitu.h samiipa.m jagaama; tatastasya pitaatiduure ta.m niriik.sya dayaa ncakre, dhaavitvaa tasya ka.n.tha.m g.rhiitvaa ta.m cucumba ca| ");
INSERT INTO sanvel_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadaa putra uvaaca, he pitar ii\"svarasya tava ca viruddha.m paapamakarava.m, tava putra_iti vikhyaato bhavitu.m na yogyosmi ca| ");
INSERT INTO sanvel_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitaa nijadaasaan aadide\"sa, sarvvottamavastraa.nyaaniiya paridhaapayataina.m haste caa\"nguriiyakam arpayata paadayo\"scopaanahau samarpayata; ");
INSERT INTO sanvel_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","pu.s.ta.m govatsam aaniiya maarayata ca ta.m bhuktvaa vayam aanandaama| ");
INSERT INTO sanvel_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yato mama putroyam amriyata punarajiiviid haarita\"sca labdhobhuut tatasta aananditum aarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkaale tasya jye.s.tha.h putra.h k.setra aasiit| atha sa nive\"sanasya nika.ta.m aagacchan n.rtyaanaa.m vaadyaanaa nca \"sabda.m \"srutvaa ");
INSERT INTO sanvel_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","daasaanaam ekam aahuuya papraccha, ki.m kaara.namasya? ");
INSERT INTO sanvel_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tata.h sovaadiit, tava bhraataagamat, tava taata\"sca ta.m su\"sariira.m praapya pu.s.ta.m govatsa.m maaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tata.h sa prakupya nive\"sanaanta.h prave.s.tu.m na sammene; tatastasya pitaa bahiraagatya ta.m saadhayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tata.h sa pitara.m pratyuvaaca, pa\"sya tava kaa ncidapyaaj naa.m na vila.mghya bahuun vatsaraan aha.m tvaa.m seve tathaapi mitrai.h saarddham utsava.m karttu.m kadaapi chaagamekamapi mahya.m naadadaa.h; ");
INSERT INTO sanvel_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava ya.h putro ve\"syaagamanaadibhistava sampattim apavyayitavaan tasminnaagatamaatre tasyaiva nimitta.m pu.s.ta.m govatsa.m maaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadaa tasya pitaavocat, he putra tva.m sarvvadaa mayaa sahaasi tasmaan mama yadyadaaste tatsarvva.m tava| ");
INSERT INTO sanvel_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavaaya.m bhraataa m.rta.h punarajiiviid haarita\"sca bhuutvaa praaptobhuut, etasmaat kaara.naad utsavaanandau karttum ucitamasmaakam| ");
INSERT INTO sanvel_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","apara nca yii\"su.h \"si.syebhyonyaamekaa.m kathaa.m kathayaamaasa kasyacid dhanavato manu.syasya g.rhakaaryyaadhii\"se sampatterapavyaye.apavaadite sati ");
INSERT INTO sanvel_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam aahuuya jagaada, tvayi yaamimaa.m kathaa.m \"s.r.nomi saa kiid.r\"sii? tva.m g.rhakaaryyaadhii\"sakarmma.no ga.nanaa.m dar\"saya g.rhakaaryyaadhii\"sapade tva.m na sthaasyasi| ");
INSERT INTO sanvel_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadaa sa g.rhakaaryyaadhii\"so manasaa cintayaamaasa, prabhu ryadi maa.m g.rhakaaryyaadhii\"sapadaad bhra.m\"sayati tarhi ki.m kari.sye.aha.m? m.rda.m khanitu.m mama \"sakti rnaasti bhik.situ nca lajji.sye.aha.m| ");
INSERT INTO sanvel_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataeva mayi g.rhakaaryyaadhii\"sapadaat cyute sati yathaa lokaa mahyam aa\"sraya.m daasyanti tadartha.m yatkarmma mayaa kara.niiya.m tan nir.niiyate| ");
INSERT INTO sanvel_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","pa\"scaat sa svaprabhorekaikam adhamar.nam aahuuya prathama.m papraccha, tvatto me prabhu.naa kati praapyam? ");
INSERT INTO sanvel_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tata.h sa uvaaca, eka\"sataa.dhakatailaani; tadaa g.rhakaaryyaadhii\"sa.h provaaca, tava patramaaniiya \"siighramupavi\"sya tatra pa ncaa\"sata.m likha| ");
INSERT INTO sanvel_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","pa\"scaadanyameka.m papraccha, tvatto me prabhu.naa kati praapyam? tata.h sovaadiid eka\"sataa.dhakagodhuumaa.h; tadaa sa kathayaamaasa, tava patramaaniiya a\"siiti.m likha| ");
INSERT INTO sanvel_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tenaiva prabhustamayathaarthak.rtam adhii\"sa.m tadbuddhinaipu.nyaat pra\"sa\"sa.msa; ittha.m diiptiruupasantaanebhya etatsa.msaarasya santaanaa varttamaanakaale.adhikabuddhimanto bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ato vadaami yuuyamapyayathaarthena dhanena mitraa.ni labhadhva.m tato yu.smaasu padabhra.s.te.svapi taani cirakaalam aa\"sraya.m daasyanti| ");
INSERT INTO sanvel_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ya.h ka\"scit k.sudre kaaryye vi\"svaasyo bhavati sa mahati kaaryyepi vi\"svaasyo bhavati, kintu ya.h ka\"scit k.sudre kaaryye.avi\"svaasyo bhavati sa mahati kaaryyepyavi\"svaasyo bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataeva ayathaarthena dhanena yadi yuuyamavi\"svaasyaa jaataastarhi satya.m dhana.m yu.smaaka.m kare.su ka.h samarpayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi ca paradhanena yuuyam avi\"svaasyaa bhavatha tarhi yu.smaaka.m svakiiyadhana.m yu.smabhya.m ko daasyati? ");
INSERT INTO sanvel_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kopi daasa ubhau prabhuu sevitu.m na \"saknoti, yata ekasmin priiyamaa.no.anyasminnapriiyate yadvaa eka.m jana.m samaad.rtya tadanya.m tucchiikaroti tadvad yuuyamapi dhane\"svarau sevitu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitaa.h sarvvaa.h kathaa.h \"srutvaa lobhiphiruu\"sinastamupajahasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tata.h sa uvaaca, yuuya.m manu.syaa.naa.m nika.te svaan nirdo.saan dar\"sayatha kintu yu.smaakam anta.hkara.naanii\"svaro jaanaati, yat manu.syaa.naam ati pra\"sa.msya.m tad ii\"svarasya gh.r.nya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yohana aagamanaparyyanata.m yu.smaaka.m samiipe vyavasthaabhavi.syadvaadinaa.m lekhanaani caasan tata.h prabh.rti ii\"svararaajyasya susa.mvaada.h pracarati, ekaiko lokastanmadhya.m yatnena pravi\"sati ca| ");
INSERT INTO sanvel_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","vara.m nabhasa.h p.rthivyaa\"sca lopo bhavi.syati tathaapi vyavasthaayaa ekabindorapi lopo na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ya.h ka\"scit sviiyaa.m bhaaryyaa.m vihaaya striyamanyaa.m vivahati sa paradaaraan gacchati, ya\"sca taa tyaktaa.m naarii.m vivahati sopi paradaaraana gacchati| ");
INSERT INTO sanvel_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","eko dhanii manu.sya.h \"suklaani suuk.smaa.ni vastraa.ni paryyadadhaat pratidina.m parito.saruupe.naabhu.mktaapivacca| ");
INSERT INTO sanvel_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvaa\"nge k.satayukta iliyaasaranaamaa ka\"scid daridrastasya dhanavato bhojanapaatraat patitam ucchi.s.ta.m bhoktu.m vaa nchan tasya dvaare patitvaati.s.that; ");
INSERT INTO sanvel_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha \"svaana aagatya tasya k.sataanyalihan| ");
INSERT INTO sanvel_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkaalaatpara.m sa daridra.h praa.naan jahau; tata.h svargiiyaduutaasta.m niitvaa ibraahiima.h kro.da upave\"sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","pa\"scaat sa dhanavaanapi mamaara, ta.m \"sma\"saane sthaapayaamaasu\"sca; kintu paraloke sa vedanaakula.h san uurddhvaa.m niriik.sya bahuduuraad ibraahiima.m tatkro.da iliyaasara nca vilokya ruvannuvaaca; ");
INSERT INTO sanvel_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","he pitar ibraahiim anug.rhya a\"ngulyagrabhaaga.m jale majjayitvaa mama jihvaa.m \"siitalaa.m karttum iliyaasara.m preraya, yato vahni\"sikhaatoha.m vyathitosmi| ");
INSERT INTO sanvel_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadaa ibraahiim babhaa.se, he putra tva.m jiivan sampada.m praaptavaan iliyaasarastu vipada.m praaptavaan etat smara, kintu samprati tasya sukha.m tava ca du.hkha.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yu.smaakam asmaaka nca sthaanayo rmadhye mahadvicchedo.asti tata etatsthaanasya lokaastat sthaana.m yaatu.m yadvaa tatsthaanasya lokaa etat sthaanamaayaatu.m na \"saknuvanti| ");
INSERT INTO sanvel_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadaa sa uktavaan, he pitastarhi tvaa.m nivedayaami mama pitu rgehe ye mama pa nca bhraatara.h santi ");
INSERT INTO sanvel_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te yathaitad yaatanaasthaana.m naayaasyanti tathaa mantra.naa.m daatu.m te.saa.m samiipam iliyaasara.m preraya| ");
INSERT INTO sanvel_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibraahiim uvaaca, muusaabhavi.syadvaadinaa nca pustakaani te.saa.m nika.te santi te tadvacanaani manyantaa.m| ");
INSERT INTO sanvel_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadaa sa nivedayaamaasa, he pitar ibraahiim na tathaa, kintu yadi m.rtalokaanaa.m ka\"scit te.saa.m samiipa.m yaati tarhi te manaa.msi vyaagho.tayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibraahiim jagaada, te yadi muusaabhavi.syadvaadinaa nca vacanaani na manyante tarhi m.rtalokaanaa.m kasmi.m\"scid utthitepi te tasya mantra.naa.m na ma.msyante| ");
INSERT INTO sanvel_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ita.h para.m yii\"su.h \"si.syaan uvaaca, vighnairava\"syam aagantavya.m kintu vighnaa yena gha.ti.syante tasya durgati rbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ete.saa.m k.sudrapraa.ninaam ekasyaapi vighnajananaat ka.n.thabaddhape.sa.niikasya tasya saagaraagaadhajale majjana.m bhadra.m| ");
INSERT INTO sanvel_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yuuya.m sve.su saavadhaanaasti.s.thata; tava bhraataa yadi tava ki ncid aparaadhyati tarhi ta.m tarjaya, tena yadi mana.h parivarttayati tarhi ta.m k.samasva| ");
INSERT INTO sanvel_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarekadinamadhye yadi sa tava saptak.rtvo.aparaadhyati kintu saptak.rtva aagatya mana.h parivartya mayaaparaaddham iti vadati tarhi ta.m k.samasva| ");
INSERT INTO sanvel_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadaa preritaa.h prabhum avadan asmaaka.m vi\"svaasa.m varddhaya| ");
INSERT INTO sanvel_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvaaca, yadi yu.smaaka.m sar.sapaikapramaa.no vi\"svaasosti tarhi tva.m samuulamutpaa.tito bhuutvaa samudre ropito bhava kathaayaam etasyaam etadu.dumbaraaya kathitaayaa.m sa yu.smaakamaaj naavaho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","apara.m svadaase hala.m vaahayitvaa vaa pa\"suun caarayitvaa k.setraad aagate sati ta.m vadati, ehi bhoktumupavi\"sa, yu.smaakam etaad.r\"sa.h kosti? ");
INSERT INTO sanvel_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","vara nca puurvva.m mama khaadyamaasaadya yaavad bhu nje pivaami ca taavad baddhaka.ti.h paricara pa\"scaat tvamapi bhok.syase paasyasi ca kathaamiid.r\"sii.m ki.m na vak.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tena daasena prabhoraaj naanuruupe karmma.ni k.rte prabhu.h ki.m tasmin baadhito jaata.h? nettha.m budhyate mayaa| ");
INSERT INTO sanvel_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ittha.m niruupite.su sarvvakarmmasu k.rte.su satmu yuuyamapiida.m vaakya.m vadatha, vayam anupakaari.no daasaa asmaabhiryadyatkarttavya.m tanmaatrameva k.rta.m| ");
INSERT INTO sanvel_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yiruu\"saalami yaatraa.m kurvvan \"somiro.ngaaliilprade\"samadhyena gacchati, ");
INSERT INTO sanvel_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","etarhi kutracid graame prave\"samaatre da\"saku.s.thinasta.m saak.saat k.rtvaa ");
INSERT INTO sanvel_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","duure ti.s.thanata uccai rvaktumaarebhire, he prabho yii\"so dayasvaasmaan| ");
INSERT INTO sanvel_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tata.h sa taan d.r.s.tvaa jagaada, yuuya.m yaajakaanaa.m samiipe svaan dar\"sayata, tataste gacchanto rogaat pari.sk.rtaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadaa te.saameka.h sva.m svastha.m d.r.s.tvaa proccairii\"svara.m dhanya.m vadan vyaaghu.tyaayaato yii\"so rgu.naananuvadan taccara.naadhobhuumau papaata; ");
INSERT INTO sanvel_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa caasiit \"somiro.nii| ");
INSERT INTO sanvel_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadaa yii\"suravadat, da\"sajanaa.h ki.m na pari.sk.rtaa.h? tahyanye navajanaa.h kutra? ");
INSERT INTO sanvel_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ii\"svara.m dhanya.m vadantam ena.m vide\"sina.m vinaa kopyanyo na praapyata| ");
INSERT INTO sanvel_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadaa sa tamuvaaca, tvamutthaaya yaahi vi\"svaasaste tvaa.m svastha.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kade\"svarasya raajatva.m bhavi.syatiiti phiruu\"sibhi.h p.r.s.te sa pratyuvaaca, ii\"svarasya raajatvam ai\"svaryyadar\"sanena na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata etasmin pa\"sya tasmin vaa pa\"sya, iti vaakya.m lokaa vaktu.m na \"sak.syanti, ii\"svarasya raajatva.m yu.smaakam antarevaaste| ");
INSERT INTO sanvel_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tata.h sa \"si.syaan jagaada, yadaa yu.smaabhi rmanujasutasya dinameka.m dra.s.tum vaa nchi.syate kintu na dar\"si.syate, iid.rkkaala aayaati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadaatra pa\"sya vaa tatra pa\"syeti vaakya.m lokaa vak.syanti, kintu te.saa.m pa\"scaat maa yaata, maanugacchata ca| ");
INSERT INTO sanvel_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatasta.did yathaakaa\"saikadi\"syudiya tadanyaamapi di\"sa.m vyaapya prakaa\"sate tadvat nijadine manujasuunu.h prakaa\"si.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpuurvva.m tenaanekaani du.hkhaani bhoktavyaanyetadvarttamaanalokai\"sca so.avaj naatavya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nohasya vidyamaanakaale yathaabhavat manu.syasuuno.h kaalepi tathaa bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yaavatkaala.m noho mahaapota.m naarohad aaplaavivaaryyetya sarvva.m naanaa\"sayacca taavatkaala.m yathaa lokaa abhu njataapivan vyavahan vyavaahaya.m\"sca; ");
INSERT INTO sanvel_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ittha.m lo.to varttamaanakaalepi yathaa lokaa bhojanapaanakrayavikrayaropa.nag.rhanirmmaa.nakarmmasu praavarttanta, ");
INSERT INTO sanvel_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadaa lo.t sidomo nirjagaama tadaa nabhasa.h sagandhakaagniv.r.s.ti rbhuutvaa sarvva.m vyanaa\"sayat ");
INSERT INTO sanvel_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan maanavaputraprakaa\"sadinepi bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadaa yadi ka\"scid g.rhopari ti.s.thati tarhi sa g.rhamadhyaat kimapi dravyamaanetum avaruhya naitu; ya\"sca k.setre ti.s.thati sopi vyaaghu.tya naayaatu| ");
INSERT INTO sanvel_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","lo.ta.h patnii.m smarata| ");
INSERT INTO sanvel_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ya.h praa.naan rak.situ.m ce.s.ti.syate sa praa.naan haarayi.syati yastu praa.naan haarayi.syati saeva praa.naan rak.si.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yu.smaanaha.m vacmi tasyaa.m raatrau \"sayyaikagatayo rlokayoreko dhaari.syate parastyak.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat pe.sa.nii.m vyaavarttayi.syatastayorekaa dhaari.syate paraatyak.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puru.sau k.setre sthaasyatastayoreko dhaari.syate parastyak.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadaa te papracchu.h, he prabho kutrettha.m bhavi.syati? tata.h sa uvaaca, yatra \"savasti.s.thati tatra g.rdhraa milanti| ");
INSERT INTO sanvel_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","apara nca lokairaklaantai rnirantara.m praarthayitavyam ityaa\"sayena yii\"sunaa d.r.s.taanta eka.h kathita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutracinnagare ka\"scit praa.dvivaaka aasiit sa ii\"svaraannaabibhet maanu.saa.m\"sca naamanyata| ");
INSERT INTO sanvel_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravaasinii kaacidvidhavaa tatsamiipametya vivaadinaa saha mama vivaada.m pari.skurvviti nivedayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tata.h sa praa.dvivaaka.h kiyaddinaani na tada\"ngiik.rtavaan pa\"scaaccitte cintayaamaasa, yadyapii\"svaraanna bibhemi manu.syaanapi na manye ");
INSERT INTO sanvel_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathaapye.saa vidhavaa maa.m kli\"snaati tasmaadasyaa vivaada.m pari.skari.syaami nocet saa sadaagatya maa.m vyagra.m kari.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","pa\"scaat prabhuravadad asaavanyaayapraa.dvivaako yadaaha tatra mano nidhadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ii\"svarasya ye .abhirucitalokaa divaani\"sa.m praarthayante sa bahudinaani vilambyaapi te.saa.m vivaadaan ki.m na pari.skari.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yu.smaanaha.m vadaami tvarayaa pari.skari.syati, kintu yadaa manu.syaputra aagami.syati tadaa p.rthivyaa.m kimiid.r\"sa.m vi\"svaasa.m praapsyati? ");
INSERT INTO sanvel_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ye svaan dhaarmmikaan j naatvaa paraan tucchiikurvvanti etaad.rgbhya.h, kiyadbhya ima.m d.r.s.taanta.m kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","eka.h phiruu\"syapara.h karasa ncaayii dvaavimau praarthayitu.m mandira.m gatau| ");
INSERT INTO sanvel_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tato.asau phiruu\"syekapaar\"sve ti.s.than he ii\"svara ahamanyalokavat lo.thayitaanyaayii paaradaarika\"sca na bhavaami asya karasa ncaayinastulya\"sca na, tasmaattvaa.m dhanya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dine.su dinadvayamupavasaami sarvvasampatte rda\"samaa.m\"sa.m dadaami ca, etatkathaa.m kathayan praarthayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasa ncaayi duure ti.s.than svarga.m dra.s.tu.m necchan vak.sasi karaaghaata.m kurvvan he ii\"svara paapi.s.tha.m maa.m dayasva, ittha.m praarthayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yu.smaanaha.m vadaami, tayordvayo rmadhye kevala.h karasa ncaayii pu.nyavattvena ga.nito nijag.rha.m jagaama, yato ya.h ka\"scit svamunnamayati sa naamayi.syate kintu ya.h ka\"scit sva.m namayati sa unnamayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha \"si\"suunaa.m gaatraspar\"saartha.m lokaastaan tasya samiipamaaninyu.h \"si.syaastad d.r.s.tvaanet.rn tarjayaamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yii\"sustaanaahuuya jagaada, mannika.tam aagantu.m \"si\"suun anujaaniidhva.m taa.m\"sca maa vaarayata; yata ii\"svararaajyaadhikaari.na e.saa.m sad.r\"saa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","aha.m yu.smaan yathaartha.m vadaami, yo jana.h \"si\"so.h sad.r\"so bhuutvaa ii\"svararaajya.m na g.rhlaati sa kenaapi prakaare.na tat prave.s.tu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam ekodhipatista.m papraccha, he paramaguro, anantaayu.sa.h praaptaye mayaa ki.m karttavya.m? ");
INSERT INTO sanvel_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yii\"suruvaaca, maa.m kuta.h parama.m vadasi? ii\"svara.m vinaa kopi paramo na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradaaraan maa gaccha, nara.m maa jahi, maa coraya, mithyaasaak.sya.m maa dehi, maatara.m pitara nca sa.mmanyasva, etaa yaa aaj naa.h santi taastva.m jaanaasi| ");
INSERT INTO sanvel_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadaa sa uvaaca, baalyakaalaat sarvvaa etaa aacaraami| ");
INSERT INTO sanvel_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathaa.m \"srutvaa yii\"sustamavadat, tathaapi tavaika.m karmma nyuunamaaste, nija.m sarvvasva.m vikriiya daridrebhyo vitara, tasmaat svarge dhana.m praapsyasi; tata aagatya mamaanugaamii bhava| ");
INSERT INTO sanvel_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvetaa.m kathaa.m \"srutvaa sodhipati.h \"su\"soca, yatastasya bahudhanamaasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadaa yii\"sustamati\"sokaanvita.m d.r.s.tvaa jagaada, dhanavataam ii\"svararaajyaprave\"sa.h kiid.rg du.skara.h| ");
INSERT INTO sanvel_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ii\"svararaajye dhanina.h prave\"saat suuce\"schidre.na mahaa\"ngasya gamanaagamane sukare| ");
INSERT INTO sanvel_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","\"srotaara.h papracchustarhi kena paritraa.na.m praapsyate? ");
INSERT INTO sanvel_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavaan, yan maanu.se.naa\"sakya.m tad ii\"svare.na \"sakya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadaa pitara uvaaca, pa\"sya vaya.m sarvvasva.m parityajya tava pa\"scaadgaamino.abhavaama| ");
INSERT INTO sanvel_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tata.h sa uvaaca, yu.smaanaha.m yathaartha.m vadaami, ii\"svararaajyaartha.m g.rha.m pitarau bhraat.rga.na.m jaayaa.m santaanaa.m\"sca tyaktavaa ");
INSERT INTO sanvel_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kaale tato.adhika.m parakaale .anantaayu\"sca na praapsyati loka iid.r\"sa.h kopi naasti| ");
INSERT INTO sanvel_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantara.m sa dvaada\"sa\"si.syaanaahuuya babhaa.se, pa\"syata vaya.m yiruu\"saalamnagara.m yaama.h, tasmaat manu.syaputre bhavi.syadvaadibhirukta.m yadasti tadanuruupa.m ta.m prati gha.ti.syate; ");
INSERT INTO sanvel_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu so.anyade\"siiyaanaa.m haste.su samarpayi.syate, te tamupahasi.syanti, anyaayamaacari.syanti tadvapu.si ni.s.thiiva.m nik.sepsyanti, ka\"saabhi.h prah.rtya ta.m hani.syanti ca, ");
INSERT INTO sanvel_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu t.rtiiyadine sa \"sma\"saanaad utthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","etasyaa.h kathaayaa abhipraaya.m ki ncidapi te boddhu.m na \"seku.h te.saa.m nika.te.aspa.s.tatavaat tasyaitaasaa.m kathaanaam aa\"saya.m te j naatu.m na \"seku\"sca| ");
INSERT INTO sanvel_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yiriiho.h purasyaantika.m praapte ka\"scidandha.h patha.h paar\"sva upavi\"sya bhik.saam akarot ");
INSERT INTO sanvel_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lokasamuuhasya gamana\"sabda.m \"srutvaa tatkaara.na.m p.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","naasaratiiyayii\"suryaatiiti lokairukte sa uccairvaktumaarebhe, ");
INSERT INTO sanvel_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","he daayuuda.h santaana yii\"so maa.m dayasva| ");
INSERT INTO sanvel_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatogragaaminasta.m maunii ti.s.theti tarjayaamaasu.h kintu sa punaaruvan uvaaca, he daayuuda.h santaana maa.m dayasva| ");
INSERT INTO sanvel_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadaa yii\"su.h sthagito bhuutvaa svaantike tamaanetum aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tata.h sa tasyaantikam aagamat, tadaa sa ta.m papraccha, tva.m kimicchasi? tvadarthamaha.m ki.m kari.syaami? sa uktavaan, he prabho.aha.m dra.s.tu.m labhai| ");
INSERT INTO sanvel_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadaa yii\"suruvaaca, d.r.s.ti\"sakti.m g.rhaa.na tava pratyayastvaa.m svastha.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatk.sa.naat tasya cak.su.sii prasanne; tasmaat sa ii\"svara.m dhanya.m vadan tatpa\"scaad yayau, tadaalokya sarvve lokaa ii\"svara.m pra\"sa.msitum aarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadaa yii\"su ryiriihopura.m pravi\"sya tanmadhyena gaccha.mstadaa ");
INSERT INTO sanvel_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkeyanaamaa karasa ncaayinaa.m pradhaano dhanavaaneko ");
INSERT INTO sanvel_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yii\"su.h kiid.rgiti dra.s.tu.m ce.s.titavaan kintu kharvvatvaallokasa.mghamadhye taddar\"sanamapraapya ");
INSERT INTO sanvel_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yena pathaa sa yaasyati tatpathe.agre dhaavitvaa ta.m dra.s.tum u.dumbaratarumaaruroha| ");
INSERT INTO sanvel_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","pa\"scaad yii\"sustatsthaanam itvaa uurddhva.m vilokya ta.m d.r.s.tvaavaadiit, he sakkeya tva.m \"siighramavaroha mayaadya tvadgehe vastavya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tata.h sa \"siighramavaruhya saahlaada.m ta.m jagraaha| ");
INSERT INTO sanvel_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad d.r.s.tvaa sarvve vivadamaanaa vaktumaarebhire, sotithitvena du.s.talokag.rha.m gacchati| ");
INSERT INTO sanvel_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkeyo da.n.daayamaano vaktumaarebhe, he prabho pa\"sya mama yaa sampattirasti tadarddha.m daridrebhyo dade, aparam anyaaya.m k.rtvaa kasmaadapi yadi kadaapi ki ncit mayaa g.rhiita.m tarhi taccaturgu.na.m dadaami| ");
INSERT INTO sanvel_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadaa yii\"sustamuktavaan ayamapi ibraahiima.h santaano.ata.h kaara.naad adyaasya g.rhe traa.namupasthita.m| ");
INSERT INTO sanvel_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad haarita.m tat m.rgayitu.m rak.situ nca manu.syaputra aagatavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yiruu\"saalama.h samiipa upaati.s.thad ii\"svararaajatvasyaanu.s.thaana.m tadaiva bhavi.syatiiti lokairanvabhuuyata, tasmaat sa \"srot.rbhya.h punard.r.s.taantakathaam utthaapya kathayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kopi mahaalloko nijaartha.m raajatvapada.m g.rhiitvaa punaraagantu.m duurade\"sa.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yaatraakaale nijaan da\"sadaasaan aahuuya da\"sasvar.namudraa dattvaa mamaagamanaparyyanta.m vaa.nijya.m kurutetyaadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajaastamavaj naaya manu.syamenam asmaakamupari raajatva.m na kaarayivyaama imaa.m vaarttaa.m tannika.te prerayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa raajatvapada.m praapyaagatavaan ekaiko jano baa.nijyena ki.m labdhavaan iti j naatu.m ye.su daase.su mudraa arpayat taan aahuuyaanetum aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadaa prathama aagatya kathitavaan, he prabho tava tayaikayaa mudrayaa da\"samudraa labdhaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tata.h sa uvaaca tvamuttamo daasa.h svalpena vi\"svaasyo jaata ita.h kaara.naat tva.m da\"sanagaraa.naam adhipo bhava| ");
INSERT INTO sanvel_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitiiya aagatya kathitavaan, he prabho tavaikayaa mudrayaa pa ncamudraa labdhaa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tata.h sa uvaaca, tva.m pa ncaanaa.m nagaraa.naamadhipati rbhava| ");
INSERT INTO sanvel_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatonya aagatya kathayaamaasa, he prabho pa\"sya tava yaa mudraa aha.m vastre baddhvaasthaapaya.m seya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tva.m k.rpa.no yannaasthaapayastadapi g.rhlaasi, yannaavapastadeva ca chinatsi tatoha.m tvatto bhiita.h| ");
INSERT INTO sanvel_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadaa sa jagaada, re du.s.tadaasa tava vaakyena tvaa.m do.si.na.m kari.syaami, yadaha.m naasthaapaya.m tadeva g.rhlaami, yadaha.m naavapa nca tadeva chinadmi, etaad.r\"sa.h k.rpa.nohamiti yadi tva.m jaanaasi, ");
INSERT INTO sanvel_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudraa ba.nijaa.m nika.te kuto naasthaapaya.h? tayaa k.rte.aham aagatya kusiidena saarddha.m nijamudraa apraapsyam| ");
INSERT INTO sanvel_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","pa\"scaat sa samiipasthaan janaan aaj naapayat asmaat mudraa aaniiya yasya da\"samudraa.h santi tasmai datta| ");
INSERT INTO sanvel_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","te procu.h prabho.asya da\"samudraa.h santi| ");
INSERT INTO sanvel_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yu.smaanaha.m vadaami yasyaa\"sraye vaddhate .adhika.m tasmai daayi.syate, kintu yasyaa\"sraye na varddhate tasya yadyadasti tadapi tasmaan naayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamaadhipatitvasya va\"satve sthaatum asammanyamaanaa ye mama ripavastaanaaniiya mama samak.sa.m sa.mharata| ");
INSERT INTO sanvel_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupade\"sakathaa.m kathayitvaa sograga.h san yiruu\"saalamapura.m yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tato baitphagiibaithaniiyaagraamayo.h samiipe jaitunaadrerantikam itvaa \"si.syadvayam ityuktvaa pre.sayaamaasa, ");
INSERT INTO sanvel_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvaamamu.m sammukhasthagraama.m pravi\"syaiva ya.m kopi maanu.sa.h kadaapi naarohat ta.m garddabha\"saavaka.m baddha.m drak.syathasta.m mocayitvaanayata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kuto mocayatha.h? iti cet kopi vak.syati tarhi vak.syatha.h prabheाratra prayojanam aaste| ");
INSERT INTO sanvel_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadaa tau praritau gatvaa tatkathaaाnusaare.na sarvva.m praaptau| ");
INSERT INTO sanvel_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabha\"saavakamocanakaale tatvaamina uucu.h, gardabha\"saavaka.m kuto mocayatha.h? ");
INSERT INTO sanvel_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","taavuucatu.h prabhoratra prayojanam aaste| ");
INSERT INTO sanvel_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","pa\"scaat tau ta.m gardabha\"saavaka.m yii\"sorantikamaaniiya tatp.r.s.the nijavasanaani paatayitvaa tadupari yii\"sumaarohayaamaasatu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yaatraakaale lokaa.h pathi svavastraa.ni paatayitum aarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","apara.m jaitunaadrerupatyakaam itvaa \"si.syasa.mgha.h puurvvad.r.s.taani mahaakarmmaa.ni sm.rtvaa, ");
INSERT INTO sanvel_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yo raajaa prabho rnaamnaayaati sa dhanya.h svarge ku\"sala.m sarvvocce jayadhvani rbhavatu, kathaametaa.m kathayitvaa saanandam ucairii\"svara.m dhanya.m vaktumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadaa lokaara.nyamadhyasthaa.h kiyanta.h phiruu\"sinastat \"srutvaa yii\"su.m procu.h, he upade\"saka sva\"si.syaan tarjaya| ");
INSERT INTO sanvel_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvaaca, yu.smaanaha.m vadaami yadyamii niiravaasti.s.thanti tarhi paa.saa.naa ucai.h kathaa.h kathayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","pa\"scaat tatpuraantikametya tadavalokya saa\"srupaata.m jagaada, ");
INSERT INTO sanvel_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","haa haa cet tvamagre.aj naasyathaa.h, tavaasminneva dine vaa yadi svama\"ngalam upaalapsyathaa.h, tarhyuttamam abhavi.syat, kintu k.sa.nesmin tattava d.r.s.teragocaram bhavati| ");
INSERT INTO sanvel_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tva.m svatraa.nakaale na mano nyadhatthaa iti heto ryatkaale tava ripavastvaa.m caturdik.su praaciire.na ve.s.tayitvaa rotsyanti ");
INSERT INTO sanvel_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","baalakai.h saarddha.m bhuumisaat kari.syanti ca tvanmadhye paa.saa.naikopi paa.saa.nopari na sthaasyati ca, kaala iid.r\"sa upasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyemandira.m pravi\"sya tatratyaan krayivikrayi.no bahi.skurvvan ");
INSERT INTO sanvel_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madg.rha.m praarthanaag.rhamiti lipiraaste kintu yuuya.m tadeva cairaa.naa.m gahvara.m kurutha| ");
INSERT INTO sanvel_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","pa\"scaat sa pratyaha.m madhyemandiram upadide\"sa; tata.h pradhaanayaajakaa adhyaapakaa.h praaciinaa\"sca ta.m naa\"sayitu.m cice.s.tire; ");
INSERT INTO sanvel_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupade\"se sarvve lokaa nivi.s.tacittaa.h sthitaastasmaat te tatkarttu.m naavakaa\"sa.m praapu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadaa yii\"su rmanidare susa.mvaada.m pracaarayan lokaanupadi\"sati, etarhi pradhaanayaajakaa adhyaapakaa.h praa nca\"sca tannika.tamaagatya papracchu.h ");
INSERT INTO sanvel_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayaaj nayaa tva.m karmmaa.nyetaani karo.si? ko vaa tvaamaaj naapayat? tadasmaan vada| ");
INSERT INTO sanvel_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvaaca, tarhi yu.smaanapi kathaamekaa.m p.rcchaami tasyottara.m vadata| ");
INSERT INTO sanvel_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yohano majjanam ii\"svarasya maanu.saa.naa.m vaaj naato jaata.m? ");
INSERT INTO sanvel_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tataste mitho vivicya jagadu.h, yadii\"svarasya vadaamastarhi ta.m kuto na pratyaita sa iti vak.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manu.syasyeti vadaamastarhi sarvve lokaa asmaan paa.saa.nai rhani.syanti yato yohan bhavi.syadvaadiiti sarvve d.r.dha.m jaananti| ");
INSERT INTO sanvel_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataeva te pratyuucu.h kasyaaj nayaa jaatam iti vaktu.m na \"saknuma.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadaa yii\"suravadat tarhi kayaaj nayaa karmmaa.nyetaati karomiiti ca yu.smaan na vak.syaami| ");
INSERT INTO sanvel_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lokaanaa.m saak.saat sa imaa.m d.r.s.taantakathaa.m vaktumaarebhe, ka\"scid draak.saak.setra.m k.rtvaa tat k.setra.m k.r.siivalaanaa.m haste.su samarpya bahukaalaartha.m duurade\"sa.m jagaama| ");
INSERT INTO sanvel_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakaale phalaani grahiitu k.r.siivalaanaa.m samiipe daasa.m praahi.not kintu k.r.siivalaasta.m prah.rtya riktahasta.m visasarju.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tata.h sodhipati.h punaranya.m daasa.m pre.sayaamaasa, te tamapi prah.rtya kuvyavah.rtya riktahasta.m visas.rju.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tata.h sa t.rtiiyavaaram anya.m praahi.not te tamapi k.sataa\"nga.m k.rtvaa bahi rnicik.sipu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadaa k.setrapati rvicaarayaamaasa, mamedaanii.m ki.m karttavya.m? mama priye putre prahite te tamava\"sya.m d.r.s.tvaa samaadari.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu k.r.siivalaasta.m niriik.sya paraspara.m vivicya procu.h, ayamuttaraadhikaarii aagacchataina.m hanmastatodhikaarosmaaka.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tataste ta.m k.setraad bahi rnipaatya jaghnustasmaat sa k.setrapatistaan prati ki.m kari.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa aagatya taan k.r.siivalaan hatvaa pare.saa.m haste.su tatk.setra.m samarpayi.syati; iti kathaa.m \"srutvaa te .avadan etaad.r\"sii gha.tanaa na bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yii\"sustaanavalokya jagaada, tarhi, sthapataya.h kari.syanti graavaa.na.m yantu tucchaka.m| pradhaanaprastara.h ko.ne sa eva hi bhavi.syati| etasya \"saastriiyavacanasya ki.m taatparyya.m? ");
INSERT INTO sanvel_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","apara.m tatpaa.saa.nopari ya.h pati.syati sa bha.mk.syate kintu yasyopari sa paa.saa.na.h pati.syati sa tena dhuulivac cuur.niibhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sosmaaka.m viruddha.m d.r.s.taantamima.m kathitavaan iti j naatvaa pradhaanayaajakaa adhyaapakaa\"sca tadaiva ta.m dhartu.m vavaa nchu.h kintu lokebhyo bibhyu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataeva ta.m prati satarkaa.h santa.h katha.m tadvaakyado.sa.m dh.rtvaa ta.m de\"saadhipasya saadhuve\"sadhaari.na\"scaraan tasya samiipe pre.sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadaa te ta.m papracchu.h, he upade\"saka bhavaan yathaartha.m kathayan upadi\"sati, kamapyanapek.sya satyatvenai\"svara.m maargamupadi\"sati, vayametajjaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararaajaaya karosmaabhi rdeyo na vaa? ");
INSERT INTO sanvel_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa te.saa.m va ncana.m j naatvaavadat kuto maa.m pariik.sadhve? maa.m mudraameka.m dar\"sayata| ");
INSERT INTO sanvel_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitaa muurtiriya.m naama ca kasya? te.avadan kaisarasya| ");
INSERT INTO sanvel_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadaa sa uvaaca, tarhi kaisarasya dravya.m kaisaraaya datta; ii\"svarasya tu dravyamii\"svaraaya datta| ");
INSERT INTO sanvel_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmaallokaanaa.m saak.saat tatkathaayaa.h kamapi do.sa.m dhartumapraapya te tasyottaraad aa\"scaryya.m manyamaanaa mauninastasthu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","apara nca \"sma\"saanaadutthaanaana\"ngiikaari.naa.m siduukinaa.m kiyanto janaa aagatya ta.m papracchu.h, ");
INSERT INTO sanvel_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","he upade\"saka \"saastre muusaa asmaan pratiiti lilekha yasya bhraataa bhaaryyaayaa.m satyaa.m ni.hsantaano mriyate sa tajjaayaa.m vivahya tadva.m\"sam utpaadayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathaaca kecit sapta bhraatara aasan te.saa.m jye.s.tho bhraataa vivahya nirapatya.h praa.naan jahau| ");
INSERT INTO sanvel_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitiiyastasya jaayaa.m vivahya nirapatya.h san mamaara| t.rtiiya\"sca taameva vyuvaaha; ");
INSERT INTO sanvel_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ittha.m sapta bhraatarastaameva vivahya nirapatyaa.h santo mamru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","\"se.se saa strii ca mamaara| ");
INSERT INTO sanvel_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataeva \"sma\"saanaadutthaanakaale te.saa.m saptajanaanaa.m kasya saa bhaaryyaa bhavi.syati? yata.h saa te.saa.m saptaanaameva bhaaryyaasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadaa yii\"su.h pratyuvaaca, etasya jagato lokaa vivahanti vaagdattaa\"sca bhavanti ");
INSERT INTO sanvel_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu ye tajjagatpraaptiyogyatvena ga.nitaa.m bhavi.syanti \"sma\"saanaaccotthaasyanti te na vivahanti vaagdattaa\"sca na bhavanti, ");
INSERT INTO sanvel_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te puna rna mriyante kintu \"sma\"saanaadutthaapitaa.h santa ii\"svarasya santaanaa.h svargiiyaduutaanaa.m sad.r\"saa\"sca bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu muusaa.h stambopaakhyaane parame\"svara iibraahiima ii\"svara ishaaka ii\"svaro yaakuuba\"sce\"svara ityuktvaa m.rtaanaa.m \"sma\"saanaad utthaanasya pramaa.na.m lilekha| ");
INSERT INTO sanvel_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataeva ya ii\"svara.h sa m.rtaanaa.m prabhu rna kintu jiivataameva prabhu.h, tannika.te sarvve jiivanta.h santi| ");
INSERT INTO sanvel_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti \"srutvaa kiyantodhyaapakaa uucu.h, he upade\"saka bhavaan bhadra.m pratyuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ita.h para.m ta.m kimapi pra.s.ta.m te.saa.m pragalbhataa naabhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","pa\"scaat sa taan uvaaca, ya.h khrii.s.ta.h sa daayuuda.h santaana etaa.m kathaa.m lokaa.h katha.m kathayanti? ");
INSERT INTO sanvel_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yata.h mama prabhumida.m vaakyamavadat parame\"svara.h| tava \"satruunaha.m yaavat paadapii.tha.m karomi na| taavat kaala.m madiiye tva.m dak.sapaar\"sva upaavi\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathaa.m daayuud svaya.m giitagranthe.avadat| ");
INSERT INTO sanvel_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataeva yadi daayuud ta.m prabhu.m vadati, tarhi sa katha.m tasya santaano bhavati? ");
INSERT INTO sanvel_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","pa\"scaad yii\"su.h sarvvajanaanaa.m kar.nagocare \"si.syaanuvaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ye.adhyaapakaa diirghaparicchada.m paridhaaya bhramanti, ha.t.taapa.nayo rnamaskaare bhajanagehasya proccaasane bhojanag.rhasya pradhaanasthaane ca priiyante ");
INSERT INTO sanvel_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavaanaa.m sarvvasva.m grasitvaa chalena diirghakaala.m praarthayante ca te.su saavadhaanaa bhavata, te.saamugrada.n.do bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilokaa bhaa.n.daagaare dhana.m nik.sipanti sa tadeva pa\"syati, ");
INSERT INTO sanvel_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","etarhi kaaciddiinaa vidhavaa pa.nadvaya.m nik.sipati tad dadar\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tato yii\"suruvaaca yu.smaanaha.m yathaartha.m vadaami, daridreya.m vidhavaa sarvvebhyodhika.m nyak.sepsiit, ");
INSERT INTO sanvel_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatonye svapraajyadhanebhya ii\"svaraaya ki ncit nyak.sepsu.h, kintu daridreya.m vidhavaa dinayaapanaartha.m svasya yat ki ncit sthita.m tat sarvva.m nyak.sepsiit| ");
INSERT INTO sanvel_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","apara nca uttamaprastarairuts.r.s.tavyai\"sca mandira.m su\"sobhatetaraa.m kai\"scidityukte sa pratyuvaaca ");
INSERT INTO sanvel_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yuuya.m yadida.m nicayana.m pa\"syatha, asya paa.saa.naikopyanyapaa.saa.nopari na sthaasyati, sarvve bhuusaadbhavi.syanti kaaloyamaayaati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadaa te papracchu.h, he guro gha.taned.r\"sii kadaa bhavi.syati? gha.tanaayaa etasyasa\"scihna.m vaa ki.m bhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadaa sa jagaada, saavadhaanaa bhavata yathaa yu.smaaka.m bhrama.m kopi na janayati, khii.s.tohamityuktvaa mama naamraa bahava upasthaasyanti sa kaala.h praaye.nopasthita.h, te.saa.m pa\"scaanmaa gacchata| ");
INSERT INTO sanvel_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyopaplavasya ca vaarttaa.m \"srutvaa maa \"sa\"nkadhva.m, yata.h prathamam etaa gha.tanaa ava\"sya.m bhavi.syanti kintu naapaate yugaanto bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","apara nca kathayaamaasa, tadaa de\"sasya vipak.satvena de\"so raajyasya vipak.satvena raajyam utthaasyati, ");
INSERT INTO sanvel_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","naanaasthaane.su mahaabhuukampo durbhik.sa.m maarii ca bhavi.syanti, tathaa vyomama.n.dalasya bhaya\"nkaradar\"sanaanya\"scaryyalak.sa.naani ca prakaa\"sayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvaasaametaasaa.m gha.tanaanaa.m puurvva.m lokaa yu.smaan dh.rtvaa taa.dayi.syanti, bhajanaalaye kaaraayaa nca samarpayi.syanti mama naamakaara.naad yu.smaan bhuupaanaa.m \"saasakaanaa nca sammukha.m ne.syanti ca| ");
INSERT INTO sanvel_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","saak.syaartham etaani yu.smaan prati gha.ti.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadaa kimuttara.m vaktavyam etat na cintayi.syaama iti mana.hsu ni\"scitanuta| ");
INSERT INTO sanvel_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipak.saa yasmaat kimapyuttaram aapatti nca karttu.m na \"sak.syanti taad.r\"sa.m vaakpa.tutva.m j naana nca yu.smabhya.m daasyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ki nca yuuya.m pitraa maatraa bhraatraa bandhunaa j naatyaa ku.tumbena ca parakare.su samarpayi.syadhve; tataste yu.smaaka.m ka ncana ka ncana ghaatayi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama naamna.h kaara.naat sarvvai rmanu.syai ryuuyam .rtiiyi.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yu.smaaka.m \"sira.hke\"saikopi na vina.mk.syati, ");
INSERT INTO sanvel_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmaadeva dhairyyamavalambya svasvapraa.naan rak.sata| ");
INSERT INTO sanvel_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","apara nca yiruu\"saalampura.m sainyave.s.tita.m vilokya tasyocchinnataayaa.h samaya.h samiipa ityavagami.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadaa yihuudaade\"sasthaa lokaa.h parvvata.m palaayantaa.m, ye ca nagare ti.s.thanti te de\"saantara.m palaayantaa, ye ca graame ti.s.thanti te nagara.m na pravi\"santu, ");
INSERT INTO sanvel_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadaa samucitada.n.danaaya dharmmapustake yaani sarvvaa.ni likhitaani taani saphalaani bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yaa yaastadaa garbhavatya.h stanyadaavya\"sca taamaa.m durgati rbhavi.syati, yata etaallokaan prati kopo de\"se ca vi.samadurgati rgha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu te kha\"ngadhaaraparivva\"nga.m lapsyante baddhaa.h santa.h sarvvade\"se.su naayi.syante ca ki ncaanyade\"siiyaanaa.m samayopasthitiparyyanta.m yiruu\"saalampura.m tai.h padatalai rdalayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","suuryyacandranak.satre.su lak.sa.naadi bhavi.syanti, bhuvi sarvvade\"siiyaanaa.m du.hkha.m cintaa ca sindhau viiciinaa.m tarjana.m garjana nca bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhuubhau bhaavigha.tanaa.m cintayitvaa manujaa bhiyaam.rtakalpaa bhavi.syanti, yato vyomama.n.dale tejasvino dolaayamaanaa bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadaa paraakrame.naa mahaatejasaa ca meghaaruu.dha.m manu.syaputram aayaanta.m drak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvetaasaa.m gha.tanaanaamaarambhe sati yuuya.m mastakaanyuttolya uurdadhva.m drak.syatha, yato yu.smaaka.m mukte.h kaala.h savidho bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastenaitad.r.s.taantakathaa kathitaa, pa\"syata u.dumbaraadiv.rk.saa.naa.m ");
INSERT INTO sanvel_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","naviinapatraa.ni jaataaniiti d.r.s.tvaa nidaavakaala upasthita iti yathaa yuuya.m j naatu.m \"saknutha, ");
INSERT INTO sanvel_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathaa sarvvaasaamaasaa.m gha.tanaanaam aarambhe d.r.s.te satii\"svarasya raajatva.m nika.tam ityapi j naasyatha| ");
INSERT INTO sanvel_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yu.smaanaha.m yathaartha.m vadaami, vidyamaanalokaanaame.saa.m gamanaat puurvvam etaani gha.ti.syante| ");
INSERT INTO sanvel_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhobhuvorlopo bhavi.syati mama vaak tu kadaapi luptaa na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataeva vi.samaa\"sanena paanena ca saa.mmaarikacintaabhi\"sca yu.smaaka.m citte.su matte.su taddinam akasmaad yu.smaan prati yathaa nopati.s.thati tadartha.m sve.su saavadhaanaasti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","p.rthiviisthasarvvalokaan prati taddinam unmaatha iva upasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathaa yuuyam etadbhaavigha.tanaa uttarttu.m manujasutasya sammukhe sa.msthaatu nca yogyaa bhavatha kaara.naadasmaat saavadhaanaa.h santo nirantara.m praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","apara nca sa divaa mandira upadi\"sya raacai jaitunaadri.m gatvaati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tata.h pratyuu.se laakaastatkathaa.m \"srotu.m mandire tadantikam aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","apara nca ki.nva\"suunyapuupotsavasya kaala upasthite ");
INSERT INTO sanvel_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhaanayaajakaa adhyaayakaa\"sca yathaa ta.m hantu.m \"saknuvanti tathopaayaam ace.s.tanta kintu lokebhyo bibhyu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","etastin samaye dvaada\"sa\"si.sye.su ga.nita ii.skariyotiiyaruu.dhimaan yo yihuudaastasyaanta.hkara.na.m \"saitaanaa\"sritatvaat ");
INSERT INTO sanvel_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvaa yathaa yii\"su.m te.saa.m kare.su samarpayitu.m \"saknoti tathaa mantra.naa.m pradhaanayaajakai.h senaapatibhi\"sca saha cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tena te tu.s.taastasmai mudraa.m daatu.m pa.na.m cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tata.h so\"ngiik.rtya yathaa lokaanaamagocare ta.m parakare.su samarpayitu.m \"saknoti tathaavakaa\"sa.m ce.s.titumaarebhe| ");
INSERT INTO sanvel_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha ki.nva\"suunyapuupotmavadine, arthaat yasmin dine nistaarotsavasya me.so hantavyastasmin dine ");
INSERT INTO sanvel_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yii\"su.h pitara.m yohana ncaahuuya jagaada, yuvaa.m gatvaasmaaka.m bhojanaartha.m nistaarotsavasya dravyaa.nyaasaadayata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadaa tau papracchatu.h kucaasaadayaavo bhavata.h kecchaa? ");
INSERT INTO sanvel_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadaa sovaadiit, nagare pravi.s.te ka\"scijjalakumbhamaadaaya yuvaa.m saak.saat kari.syati sa yannive\"sana.m pravi\"sati yuvaamapi tannive\"sana.m tatpa\"scaaditvaa nive\"sanapatim iti vaakya.m vadata.m, ");
INSERT INTO sanvel_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatraaha.m nistaarotsavasya bhojya.m \"si.syai.h saarddha.m bhoktu.m \"saknomi saatithi\"saalaaा kutra? kathaamimaa.m prabhustvaa.m p.rcchati| ");
INSERT INTO sanvel_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tata.h sa jano dvitiiyaprako.s.thiiyam eka.m \"sasta.m ko.s.tha.m dar\"sayi.syati tatra bhojyamaasaadayata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvaa tadvaakyaanusaare.na sarvva.m d.r.sdvaa tatra nistaarotsaviiya.m bhojyamaasaadayaamaasatu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kaala upasthite yii\"su rdvaada\"sabhi.h preritai.h saha bhoktumupavi\"sya kathitavaan ");
INSERT INTO sanvel_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama du.hkhabhogaat puurvva.m yubhaabhi.h saha nistaarotsavasyaitasya bhojya.m bhoktu.m mayaativaa nchaa k.rtaa| ");
INSERT INTO sanvel_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yu.smaan vadaami, yaavatkaalam ii\"svararaajye bhojana.m na kari.sye taavatkaalam ida.m na bhok.sye| ");
INSERT INTO sanvel_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadaa sa paanapaatramaadaaya ii\"svarasya gu.naan kiirttayitvaa tebhyo datvaavadat, ida.m g.rhliita yuuya.m vibhajya pivata| ");
INSERT INTO sanvel_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yu.smaan vadaami yaavatkaalam ii\"svararaajatvasya sa.msthaapana.m na bhavati taavad draak.saaphalarasa.m na paasyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tata.h puupa.m g.rhiitvaa ii\"svaragu.naan kiirttayitvaa bha\"nktaa tebhyo datvaavadat, yu.smadartha.m samarpita.m yanmama vapustadida.m, etat karmma mama smara.naartha.m kurudhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhojanaante taad.r\"sa.m paatra.m g.rhiitvaavadat, yu.smatk.rte paatita.m yanmama rakta.m tena nir.niitanavaniyamaruupa.m paanapaatramida.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","pa\"syata yo maa.m parakare.su samarpayi.syati sa mayaa saha bhojanaasana upavi\"sati| ");
INSERT INTO sanvel_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathaa niruupitamaaste tadanusaare.naa manu.syapuुtrasya gati rbhavi.syati kintu yasta.m parakare.su samarpayi.syati tasya santaapo bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadaa te.saa.m ko jana etat karmma kari.syati tat te paraspara.m pra.s.tumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","apara.m te.saa.m ko jana.h \"sre.s.thatvena ga.nayi.syate, atraarthe te.saa.m vivaadobhavat| ");
INSERT INTO sanvel_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmaat kaara.naat sovadat, anyade\"siiyaanaa.m raajaana.h prajaanaamupari prabhutva.m kurvvanti daaru.na\"saasana.m k.rtvaapi te bhuupatitvena vikhyaataa bhavanti ca| ");
INSERT INTO sanvel_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yu.smaaka.m tathaa na bhavi.syati, yo yu.smaaka.m \"sre.s.tho bhavi.syati sa kani.s.thavad bhavatu, ya\"sca mukhyo bhavi.syati sa sevakavadbhavatu| ");
INSERT INTO sanvel_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhojanopavi.s.taparicaarakayo.h ka.h \"sre.s.tha.h? yo bhojanaayopavi\"sati sa ki.m \"sre.s.tho na bhavati? kintu yu.smaaka.m madhye.aha.m paricaaraka_ivaasmi| ");
INSERT INTO sanvel_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","apara nca yuya.m mama pariik.saakaale prathamamaarabhya mayaa saha sthitaa ");
INSERT INTO sanvel_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","etatkaara.naat pitraa yathaa madartha.m raajyameka.m niruupita.m tathaahamapi yu.smadartha.m raajya.m niruupayaami| ");
INSERT INTO sanvel_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmaan mama raajye bhojanaasane ca bhojanapaane kari.syadhve si.mhaasane.suupavi\"sya cesraayeliiyaanaa.m dvaada\"sava.m\"saanaa.m vicaara.m kari.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","apara.m prabhuruvaaca, he \"simon pa\"sya tita_unaa dhaanyaaniiva yu.smaan \"saitaan caalayitum aicchat, ");
INSERT INTO sanvel_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava vi\"svaasasya lopo yathaa na bhavati etat tvadartha.m praarthita.m mayaa, tvanmanasi parivarttite ca bhraat.r.naa.m manaa.msi sthiriikuru| ");
INSERT INTO sanvel_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadaa sovadat, he prabhoha.m tvayaa saarddha.m kaaraa.m m.rti nca yaatu.m majjitosmi| ");
INSERT INTO sanvel_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tata.h sa uvaaca, he pitara tvaa.m vadaami, adya kukku.taravaat puurvva.m tva.m matparicaya.m vaaratrayam apahvo.syase| ");
INSERT INTO sanvel_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","apara.m sa papraccha, yadaa mudraasampu.ta.m khaadyapaatra.m paadukaa nca vinaa yu.smaan praahi.nava.m tadaa yu.smaaka.m kasyaapi nyuunataasiit? te procu.h kasyaapi na| ");
INSERT INTO sanvel_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadaa sovadat kintvidaanii.m mudraasampu.ta.m khaadyapaatra.m vaa yasyaasti tena tadgrahiitavya.m, yasya ca k.rpaa.noे naasti tena svavastra.m vikriiya sa kretavya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yato yu.smaanaha.m vadaami, aparaadhijanai.h saarddha.m ga.nita.h sa bhavi.syati| ida.m yacchaastriiya.m vacana.m likhitamasti tanmayi phali.syati yato mama sambandhiiya.m sarvva.m setsyati| ");
INSERT INTO sanvel_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadaa te procu.h prabho pa\"sya imau k.rpaa.nau| tata.h sovadad etau yathe.s.tau| ");
INSERT INTO sanvel_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmaadvahi rgatvaa svaacaaraanusaare.na jaitunanaamaadri.m jagaama \"si.syaa\"sca tatpa\"scaad yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatropasthaaya sa taanuvaaca, yathaa pariik.saayaa.m na patatha tadartha.m praarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","pa\"scaat sa tasmaad eka\"sarak.sepaad bahi rgatvaa jaanunii paatayitvaa etat praarthayaa ncakre, ");
INSERT INTO sanvel_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","he pita ryadi bhavaan sammanyate tarhi ka.msamena.m mamaantikaad duuraya kintu madicchaanuruupa.m na tvadicchaanuruupa.m bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadaa tasmai \"sakti.m daatu.m svargiiyaduuto dar\"sana.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","pa\"scaat sotyanta.m yaatanayaa vyaakulo bhuutvaa punard.r.dha.m praarthayaa ncakre, tasmaad b.rhaccho.nitabindava iva tasya svedabindava.h p.rthivyaa.m patitumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha praarthanaata utthaaya \"si.syaa.naa.m samiipametya taan manodu.hkhino nidritaan d.r.s.tvaavadat ");
INSERT INTO sanvel_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kuto nidraatha? pariik.saayaam apatanaartha.m prarthayadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","etatkathaayaa.h kathanakaale dvaada\"sa\"si.syaa.naa.m madhye ga.nito yihuudaanaamaa janataasahitaste.saam agre calitvaa yii\"so\"scumbanaartha.m tadantikam aayayau| ");
INSERT INTO sanvel_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadaa yii\"suruvaaca, he yihuudaa ki.m cumbanena manu.syaputra.m parakare.su samarpayasi? ");
INSERT INTO sanvel_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadaa yadyad gha.ti.syate tadanumaaya sa\"ngibhirukta.m, he prabho vaya.m ki kha\"ngena ghaatayi.syaama.h? ");
INSERT INTO sanvel_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata eka.h karavaalenaahatya pradhaanayaajakasya daasasya dak.si.na.m kar.na.m ciccheda| ");
INSERT INTO sanvel_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhuunaa nivarttasva ityuktvaa yii\"sustasya \"sruti.m sp.r.s.tvaa svasya.m cakaara| ");
INSERT INTO sanvel_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","pa\"scaad yii\"su.h samiipasthaan pradhaanayaajakaan mandirasya senaapatiin praaciinaa.m\"sca jagaada, yuuya.m k.rpaa.naan ya.s.tii.m\"sca g.rhiitvaa maa.m ki.m cora.m dharttumaayaataa.h? ");
INSERT INTO sanvel_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadaaha.m yu.smaabhi.h saha pratidina.m mandire.ati.s.tha.m tadaa maa.m dhartta.m na prav.rttaa.h, kintvidaanii.m yu.smaaka.m samayondhakaarasya caadhipatyamasti| ");
INSERT INTO sanvel_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha te ta.m dh.rtvaa mahaayaajakasya nive\"sana.m ninyu.h| tata.h pitaro duure duure pa\"scaaditvaa ");
INSERT INTO sanvel_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","b.rhatko.s.thasya madhye yatraagni.m jvaalayitvaa lokaa.h sametyopavi.s.taastatra tai.h saarddham upavive\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupave\"sakaale kaaciddaasii mano nivi\"sya ta.m niriik.syaavadat pumaanaya.m tasya sa\"nge.asthaat| ");
INSERT INTO sanvel_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyaavaadiit he naari tamaha.m na paricinomi| ");
INSERT INTO sanvel_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","k.sa.naantare.anyajanasta.m d.r.s.tvaabraviit tvamapi te.saa.m nikarasyaikajanosi| pitara.h pratyuvaaca he nara naahamasmi| ");
INSERT INTO sanvel_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tata.h saarddhada.n.dadvayaat para.m punaranyo jano ni\"scitya babhaa.se, e.sa tasya sa\"ngiiti satya.m yatoya.m gaaliiliiyo loka.h| ");
INSERT INTO sanvel_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadaa pitara uvaaca he nara tva.m yad vadami tadaha.m boddhu.m na \"saknomi, iti vaakye kathitamaatre kukku.to ruraava| ");
INSERT INTO sanvel_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadaa prabhu.naa vyaadhu.tya pitare niriik.site k.rkavaakuravaat puurvva.m maa.m trirapahno.syase iti puurvvokta.m tasya vaakya.m pitara.h sm.rtvaa ");
INSERT INTO sanvel_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvaa mahaakhedena cakranda| ");
INSERT INTO sanvel_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadaa yai ryii\"surdh.rtaste tamupahasya praharttumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastre.na tasya d.r\"sau baddhvaa kapole cape.taaghaata.m k.rtvaa papracchu.h, kaste kapole cape.taaghaata.m k.rtavaana? ga.nayitvaa tad vada| ");
INSERT INTO sanvel_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddha.m bahunindaavaakya.m vaktumaarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhaate sati lokapraa nca.h pradhaanayaajakaa adhyaapakaa\"sca sabhaa.m k.rtvaa madhyesabha.m yii\"sumaaniiya papracchu.h, tvam abhi.sikatosi na vaasmaan vada| ");
INSERT INTO sanvel_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvaaca, mayaa tasminnukte.api yuuya.m na vi\"svasi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmi.m\"scidvaakye yu.smaan p.r.s.te.api maa.m na taduttara.m vak.syatha na maa.m tyak.syatha ca| ");
INSERT INTO sanvel_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvita.h para.m manujasuta.h sarvva\"saktimata ii\"svarasya dak.si.ne paar\"sve samupavek.syati| ");
INSERT INTO sanvel_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tataste papracchu.h, rtiha tvamii\"svarasya putra.h? sa kathayaamaasa, yuuya.m yathaartha.m vadatha sa evaaha.m| ");
INSERT INTO sanvel_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadaa te sarvve kathayaamaasu.h, rtiha saak.sye.ansasmin asmaaka.m ki.m prayojana.m? asya svamukhaadeva saak.sya.m praaptam| ");
INSERT INTO sanvel_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tata.h sabhaasthaa.h sarvvalokaa utthaaya ta.m piilaatasammukha.m niitvaaprodya vaktumaarebhire, ");
INSERT INTO sanvel_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhi.sikta.m raajaana.m vadanta.m kaimararaajaaya karadaana.m ni.sedhanta.m raajyaviparyyaya.m kurttu.m pravarttamaanam ena praaptaa vaya.m| ");
INSERT INTO sanvel_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadaa piilaatasta.m p.r.s.tavaan tva.m ki.m yihuudiiyaanaa.m raajaa? sa pratyuvaaca tva.m satyamuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadaa piilaata.h pradhaanayaajakaadilokaan jagaad, ahametasya kamapyaparaadha.m naaptavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tataste puna.h saahamino bhuutvaavadan, e.sa gaaliila etatsthaanaparyyante sarvvasmin yihuudaade\"se sarvvaallokaanupadi\"sya kuprav.rtti.m graahiitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadaa piilaato gaaliilaprade\"sasya naama \"srutvaa papraccha, kimaya.m gaaliiliiyo loka.h? ");
INSERT INTO sanvel_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tata.h sa gaaliilprade\"siiyaherodraajasya tadaa sthitestasya samiipe yii\"su.m pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadaa herod yii\"su.m vilokya santuto.sa, yata.h sa tasya bahuv.rttaanta\"srava.naat tasya ki ni्cadaa\"scaryyakarmma pa\"syati ityaa\"saa.m k.rtvaa bahukaalamaarabhya ta.m dra.s.tu.m prayaasa.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmaat ta.m bahukathaa.h papraccha kintu sa tasya kasyaapi vaakyasya pratyuttara.m novaaca| ");
INSERT INTO sanvel_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhaanayaajakaa adhyaapakaa\"sca protti.s.thanta.h saahasena tamapavaditu.m praarebhire| ");
INSERT INTO sanvel_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","herod tasya senaaga.na\"sca tamavaj naaya upahaasatvena raajavastra.m paridhaapya puna.h piilaata.m prati ta.m praahi.not| ");
INSERT INTO sanvel_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","puurvva.m herodpiilaatayo.h paraspara.m vairabhaava aasiit kintu taddine dvayo rmelana.m jaatam| ");
INSERT INTO sanvel_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","pa\"scaat piilaata.h pradhaanayaajakaan \"saasakaan lokaa.m\"sca yugapadaahuuya babhaa.se, ");
INSERT INTO sanvel_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","raajyaviparyyayakaarakoyam ityuktvaa manu.syamena.m mama nika.tamaanai.s.ta kintu pa\"syata yu.smaaka.m samak.sam asya vicaara.m k.rtvaapi proktaapavaadaanuruupe.naasya kopyaparaadha.h sapramaa.no na jaata.h, ");
INSERT INTO sanvel_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yuuya nca heroda.h sannidhau pre.sitaa mayaa tatraasya kopyaparaadhastenaapi na praapta.h|pa\"syataanena vadhaheेtuka.m kimapi naaparaaddha.m| ");
INSERT INTO sanvel_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmaadena.m taa.dayitvaa vihaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrotsave te.saameko mocayitavya.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hetoste proccairekadaa procu.h, ena.m duuriik.rtya barabbaanaamaana.m mocaya| ");
INSERT INTO sanvel_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbaa nagara upaplavavadhaaparaadhaabhyaa.m kaaraayaa.m baddha aasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu piilaato yii\"su.m mocayitu.m vaa nchan punastaanuvaaca| ");
INSERT INTO sanvel_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathaapyena.m kru\"se vyadha kru\"se vyadheti vadantaste ruruvu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tata.h sa t.rtiiyavaara.m jagaada kuta.h? sa ki.m karmma k.rtavaan? naahamasya kamapi vadhaaparaadha.m praapta.h kevala.m taa.dayitvaamu.m tyajaami| ");
INSERT INTO sanvel_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathaapi te punarena.m kru\"se vyadha ityuktvaa proccaird.r.dha.m praarthayaa ncakrire; ");
INSERT INTO sanvel_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tata.h pradhaanayaajakaadiinaa.m kalarave prabale sati te.saa.m praarthanaaruupa.m karttu.m piilaata aadide\"sa| ");
INSERT INTO sanvel_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","raajadrohavadhayoraparaadhena kaaraastha.m ya.m jana.m te yayaacire ta.m mocayitvaa yii\"su.m te.saamicchaayaa.m samaarpayat| ");
INSERT INTO sanvel_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha te yii\"su.m g.rhiitvaa yaanti, etarhi graamaadaagata.m \"simonanaamaana.m kurii.niiya.m jana.m dh.rtvaa yii\"so.h pa\"scaannetu.m tasya skandhe kru\"samarpayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tato loाkaara.nyamadhye bahustriyo rudatyo vilapantya\"sca yii\"so.h pa\"scaad yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyaaghu.tya taa uvaaca, he yiruu\"saalamo naaryyo yuya.m madartha.m na ruditvaa svaartha.m svaapatyaartha nca ruditi; ");
INSERT INTO sanvel_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pa\"syata ya.h kadaapi garbhavatyo naabhavan stanya nca naapaayayan taad.r\"sii rvandhyaa yadaa dhanyaa vak.syanti sa kaala aayaati| ");
INSERT INTO sanvel_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadaa he \"sailaa asmaakamupari patata, he upa\"sailaa asmaanaacchaadayata kathaamiid.r\"sii.m lokaa vak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yata.h satejasi \"saakhini cedetad gha.tate tarhi \"su.ska\"saakhini ki.m na gha.ti.syate? ");
INSERT INTO sanvel_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadaa te hantu.m dvaavaparaadhinau tena saarddha.m ninyu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","apara.m \"sira.hkapaalanaamakasthaana.m praapya ta.m kru\"se vividhu.h; taddvayoraparaadhinoreka.m tasya dak.si.no tadanya.m vaame kru\"se vividhu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadaa yii\"surakathayat, he pitaretaan k.samasva yata ete yat karmma kurvvanti tan na vidu.h; pa\"scaatte gu.tikaapaata.m k.rtvaa tasya vastraa.ni vibhajya jag.rhu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lokasa.mghasti.s.than dadar\"sa; te te.saa.m \"saasakaa\"sca tamupahasya jagadu.h, e.sa itaraan rak.sitavaan yadii\"svare.naabhirucito .abhi.siktastraataa bhavati tarhi svamadhunaa rak.satu| ");
INSERT INTO sanvel_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanya.h senaaga.naa etya tasmai amlarasa.m datvaa parihasya provaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cettva.m yihuudiiyaanaa.m raajaasi tarhi sva.m rak.sa| ");
INSERT INTO sanvel_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihuudiiyaanaa.m raajeti vaakya.m yuunaaniiyaromiiyebriiyaak.sarai rlikhita.m tacchirasa uurddhve.asthaapyata| ");
INSERT INTO sanvel_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadobhayapaar\"svayo rviddhau yaavaparaadhinau tayorekasta.m vinindya babhaa.se, cettvam abhi.siktosi tarhi svamaavaa nca rak.sa| ");
INSERT INTO sanvel_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyasta.m tarjayitvaavadat, ii\"svaraattava ki ncidapi bhaya.m naasti ki.m? tvamapi samaanada.n.dosi, ");
INSERT INTO sanvel_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yogyapaatre aavaa.m svasvakarmma.naa.m samucitaphala.m praapnuva.h kintvanena kimapi naaparaaddha.m| ");
INSERT INTO sanvel_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yii\"su.m jagaada he prabhe bhavaan svaraajyaprave\"sakaale maa.m smaratu| ");
INSERT INTO sanvel_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadaa yii\"su.h kathitavaan tvaa.m yathaartha.m vadaami tvamadyaiva mayaa saarddha.m paralokasya sukhasthaana.m praapsyasi| ");
INSERT INTO sanvel_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","apara nca dvitiiyayaamaat t.rtiiyayaamaparyyanta.m ravestejasontarhitatvaat sarvvade\"so.andhakaare.naav.rto ");
INSERT INTO sanvel_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikaa ca chidyamaanaa dvidhaa babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tato yii\"suruccairuvaaca, he pita rmamaatmaana.m tava kare samarpaye, ityuktvaa sa praa.naan jahau| ");
INSERT INTO sanvel_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitaa gha.tanaa d.r.s.tvaa \"satasenaapatirii\"svara.m dhanyamuktvaa kathitavaan aya.m nitaanta.m saadhumanu.sya aasiit| ");
INSERT INTO sanvel_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yaavanto lokaa dra.s.tum aagataaste taa gha.tanaa d.r.s.tvaa vak.sa.hsu karaaghaata.m k.rtvaa vyaacu.tya gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yii\"so rj naatayo yaa yaa yo.sita\"sca gaaliilastena saarddhamaayaataastaa api duure sthitvaa tat sarvva.m dad.r\"su.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadaa yihuudiiyaanaa.m mantra.naa.m kriyaa ncaasammanyamaana ii\"svarasya raajatvam apek.samaa.no ");
INSERT INTO sanvel_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihuudide\"siiyo .arimathiiyanagariiyo yuu.saphnaamaa mantrii bhadro dhaarmmika\"sca pumaan ");
INSERT INTO sanvel_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","piilaataantika.m gatvaa yii\"so rdeha.m yayaace| ");
INSERT INTO sanvel_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","pa\"scaad vapuravarohya vaasasaa sa.mve.s.tya yatra kopi maanu.so naasthaapyata tasmin \"saile svaate \"sma\"saane tadasthaapayat| ");
INSERT INTO sanvel_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamaayojaniiya.m dina.m vi\"sraamavaara\"sca samiipa.h| ");
INSERT INTO sanvel_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","apara.m yii\"sunaa saarddha.m gaaliila aagataa yo.sita.h pa\"scaaditvaa \"sma\"saane tatra yathaa vapu.h sthaapita.m tacca d.r.s.tvaa ");
INSERT INTO sanvel_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyaaghu.tya sugandhidravyatailaani k.rtvaa vidhivad vi\"sraamavaare vi\"sraama.m cakru.h| ");
INSERT INTO sanvel_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptaahaprathamadine.atipratyuu.se taa yo.sita.h sampaadita.m sugandhidravya.m g.rhiitvaa tadanyaabhi.h kiyatiibhi.h striibhi.h saha \"sma\"saana.m yayu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu \"sma\"saanadvaaraat paa.saa.namapasaarita.m d.r.s.tvaa ");
INSERT INTO sanvel_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","taa.h pravi\"sya prabho rdehamapraapya ");
INSERT INTO sanvel_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyaakulaa bhavanti etarhi tejomayavastraanvitau dvau puru.sau taasaa.m samiipe samupasthitau ");
INSERT INTO sanvel_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmaattaa.h \"sa\"nkaayuktaa bhuumaavadhomukhyasyasthu.h| tadaa tau taa uucatu rm.rtaanaa.m madhye jiivanta.m kuto m.rgayatha? ");
INSERT INTO sanvel_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sotra naasti sa udasthaat| ");
INSERT INTO sanvel_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","paapinaa.m kare.su samarpitena kru\"se hatena ca manu.syaputre.na t.rtiiyadivase \"sma\"saanaadutthaatavyam iti kathaa.m sa galiili ti.s.than yu.smabhya.m kathitavaan taa.m smarata| ");
INSERT INTO sanvel_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadaa tasya saa kathaa taasaa.m mana.hsu jaataa| ");
INSERT INTO sanvel_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantara.m \"sma\"saanaad gatvaa taa ekaada\"sa\"si.syaadibhya.h sarvvebhyastaa.m vaarttaa.m kathayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdaliiniimariyam, yohanaa, yaakuubo maataa mariyam tadanyaa.h sa\"nginyo yo.sita\"sca preritebhya etaa.h sarvvaa vaarttaa.h kathayaamaasu.h ");
INSERT INTO sanvel_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu taasaa.m kathaam anarthakaakhyaanamaatra.m buddhvaa kopi na pratyait| ");
INSERT INTO sanvel_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadaa pitara utthaaya \"sma\"saanaantika.m dadhaava, tatra ca prahvo bhuutvaa paar\"svaikasthaapita.m kevala.m vastra.m dadar\"sa; tasmaadaa\"scaryya.m manyamaano yadagha.tata tanmanasi vicaarayan pratasthe| ");
INSERT INTO sanvel_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminneva dine dvau \"siyyau yiruu\"saalama\"scatu.skro\"saantaritam immaayugraama.m gacchantau ");
INSERT INTO sanvel_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","taasaa.m gha.tanaanaa.m kathaamakathayataa.m ");
INSERT INTO sanvel_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayoraalaapavicaarayo.h kaale yii\"suraagatya taabhyaa.m saha jagaama ");
INSERT INTO sanvel_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathaa tau ta.m na paricinutastadartha.m tayo rd.r.s.ti.h sa.mruddhaa| ");
INSERT INTO sanvel_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau p.r.s.tavaan yuvaa.m vi.sa.n.nau ki.m vicaarayantau gacchatha.h? ");
INSERT INTO sanvel_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayo.h kliyapaanaamaa pratyuvaaca yiruu\"saalamapure.adhunaa yaanyagha.tanta tva.m kevalavide\"sii ki.m tadv.rttaanta.m na jaanaasi? ");
INSERT INTO sanvel_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa papraccha kaa gha.tanaa.h? tadaa tau vaktumaarebhaate yii\"sunaamaa yo naasaratiiyo bhavi.syadvaadii ii\"svarasya maanu.saa.naa nca saak.saat vaakye karmma.ni ca \"saktimaanaasiit ");
INSERT INTO sanvel_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmaaka.m pradhaanayaajakaa vicaarakaa\"sca kenaapi prakaare.na kru\"se viddhvaa tasya praa.naananaa\"sayan tadiiyaa gha.tanaa.h; ");
INSERT INTO sanvel_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya israayeliiyalokaan uddhaarayi.syati sa evaayam ityaa\"saasmaabhi.h k.rtaa|tadyathaa tathaastu tasyaa gha.tanaayaa adya dinatraya.m gata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmaaka.m sa\"nginiinaa.m kiyatstrii.naa.m mukhebhyo.asambhavavaakyamida.m \"sruta.m; ");
INSERT INTO sanvel_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","taa.h pratyuu.se \"sma\"saana.m gatvaa tatra tasya deham apraapya vyaaghu.tyetvaa proktavatya.h svargiisaduutau d.r.s.taavasmaabhistau caavaadi.s.taa.m sa jiivitavaan| ");
INSERT INTO sanvel_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatosmaaka.m kai\"scit \"sma\"saanamagamyata te.api strii.naa.m vaakyaanuruupa.m d.r.s.tavanta.h kintu ta.m naapa\"syan| ");
INSERT INTO sanvel_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadaa sa taavuvaaca, he abodhau he bhavi.syadvaadibhiruktavaakya.m pratyetu.m vilambamaanau; ");
INSERT INTO sanvel_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","etatsarvvadu.hkha.m bhuktvaa svabhuutipraapti.h ki.m khrii.s.tasya na nyaayyaa? ");
INSERT INTO sanvel_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tata.h sa muusaagranthamaarabhya sarvvabhavi.syadvaadinaa.m sarvva\"saastre svasmin likhitaakhyaanaabhipraaya.m bodhayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagraamaabhyar.na.m praapya tenaagre gamanalak.sa.ne dar\"site ");
INSERT INTO sanvel_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau saadhayitvaavadataa.m sahaavaabhyaa.m ti.s.tha dine gate sati raatrirabhuut; tata.h sa taabhyaa.m saarddha.m sthaatu.m g.rha.m yayau| ");
INSERT INTO sanvel_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","pa\"scaadbhojanopave\"sakaale sa puupa.m g.rhiitvaa ii\"svaragu.naan jagaada ta nca bha.mktvaa taabhyaa.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadaa tayo rd.r.s.tau prasannaayaa.m ta.m pratyabhij natu.h kintu sa tayo.h saak.saadantardadhe| ");
INSERT INTO sanvel_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithobhidhaatum aarabdhavantau gamanakaale yadaa kathaamakathayat \"saastraartha ncabodhayat tadaavayo rbuddhi.h ki.m na praajvalat? ");
INSERT INTO sanvel_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatk.sa.naadutthaaya yiruu\"saalamapura.m pratyaayayatu.h, tatsthaane \"si.syaa.naam ekaada\"saanaa.m sa\"nginaa nca dar\"sana.m jaata.m| ");
INSERT INTO sanvel_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","te procu.h prabhurudati.s.thad iti satya.m \"simone dar\"sanamadaacca| ");
INSERT INTO sanvel_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tata.h patha.h sarvvagha.tanaayaa.h puupabha njanena tatparicayasya ca sarvvav.rttaanta.m tau vaktumaarebhaate| ");
INSERT INTO sanvel_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ittha.m te paraspara.m vadanti tatkaale yii\"su.h svaya.m te.saa.m madhya protthaya yu.smaaka.m kalyaa.na.m bhuuyaad ityuvaaca, ");
INSERT INTO sanvel_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhuuta.m pa\"syaama ityanumaaya te samudvivijire tre.su\"sca| ");
INSERT INTO sanvel_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvaaca, kuto du.hkhitaa bhavatha? yu.smaaka.m mana.hsu sandeha udeti ca kuta.h? ");
INSERT INTO sanvel_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","e.soha.m, mama karau pa\"syata vara.m sp.r.s.tvaa pa\"syata, mama yaad.r\"saani pa\"syatha taad.r\"saani bhuutasya maa.msaasthiini na santi| ");
INSERT INTO sanvel_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvaa sa hastapaadaan dar\"sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","te.asambhava.m j naatvaa saanandaa na pratyayan| tata.h sa taan papraccha, atra yu.smaaka.m samiipe khaadya.m ki ncidasti? ");
INSERT INTO sanvel_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tataste kiyaddagdhamatsya.m madhu ca dadu.h ");
INSERT INTO sanvel_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadaadaaya te.saa.m saak.saad bubhuje ");
INSERT INTO sanvel_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayaamaasa ca muusaavyavasthaayaa.m bhavi.syadvaadinaa.m granthe.su giitapustake ca mayi yaani sarvvaa.ni vacanaani likhitaani tadanuruupaa.ni gha.ti.syante yu.smaabhi.h saarddha.m sthitvaaha.m yadetadvaakyam avada.m tadidaanii.m pratyak.samabhuut| ");
INSERT INTO sanvel_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tebhya.h \"saastrabodhaadhikaara.m datvaavadat, ");
INSERT INTO sanvel_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrii.s.tenettha.m m.rtiyaatanaa bhoktavyaa t.rtiiyadine ca \"sma\"saanaadutthaatavya nceti lipirasti; ");
INSERT INTO sanvel_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannaamnaa yiruu\"saalamamaarabhya sarvvade\"se mana.hparaavarttanasya paapamocanasya ca susa.mvaada.h pracaarayitavya.h, ");
INSERT INTO sanvel_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","e.su sarvve.su yuuya.m saak.si.na.h| ");
INSERT INTO sanvel_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","apara nca pa\"syata pitraa yat pratij naata.m tat pre.sayi.syaami, ataeva yaavatkaala.m yuuya.m svargiiyaa.m \"sakti.m na praapsyatha taavatkaala.m yiruu\"saalamnagare ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa taan baithaniiyaaparyyanta.m niitvaa hastaavuttolya aa\"si.sa vaktumaarebhe ");
INSERT INTO sanvel_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","aa\"si.sa.m vadanneva ca tebhya.h p.rthag bhuutvaa svargaaya niito.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadaa te ta.m bhajamaanaa mahaanandena yiruu\"saalama.m pratyaajagmu.h| ");
INSERT INTO sanvel_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tato nirantara.m mandire ti.s.thanta ii\"svarasya pra\"sa.msaa.m dhanyavaada nca karttam aarebhire| iti||");
INSERT INTO sanvel_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","aadau vaada aasiit sa ca vaada ii\"svare.na saardhamaasiit sa vaada.h svayamii\"svara eva| ");
INSERT INTO sanvel_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa aadaavii\"svare.na sahaasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tena sarvva.m vastu sas.rje sarvve.su s.r.s.tavastu.su kimapi vastu tenaas.r.s.ta.m naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jiivanasyaakaara.h, tacca jiivana.m manu.syaa.naa.m jyoti.h ");
INSERT INTO sanvel_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyotirandhakaare pracakaa\"se kintvandhakaarastanna jagraaha| ");
INSERT INTO sanvel_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yohan naamaka eko manuja ii\"svare.na pre.sayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvaaraa yathaa sarvve vi\"svasanti tadartha.m sa tajjyoti.si pramaa.na.m daatu.m saak.sisvaruupo bhuutvaagamat, ");
INSERT INTO sanvel_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svaya.m tajjyoti rna kintu tajjyoti.si pramaa.na.m daatumaagamat| ");
INSERT INTO sanvel_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyaagatya ya.h sarvvamanujebhyo diipti.m dadaati tadeva satyajyoti.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadas.rjat tanmadya eva sa aasiit kintu jagato lokaasta.m naajaanan| ");
INSERT INTO sanvel_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijaadhikaara.m sa aagacchat kintu prajaasta.m naag.rhlan| ");
INSERT INTO sanvel_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathaapi ye ye tamag.rhlan arthaat tasya naamni vya\"svasan tebhya ii\"svarasya putraa bhavitum adhikaaram adadaat| ");
INSERT INTO sanvel_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","te.saa.m jani.h \"so.nitaanna \"saariirikaabhilaa.saanna maanavaanaamicchaato na kintvii\"svaraadabhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vaado manu.syaruupe.naavatiiryya satyataanugrahaabhyaa.m paripuur.na.h san saardham asmaabhi rnyavasat tata.h pituradvitiiyaputrasya yogyo yo mahimaa ta.m mahimaana.m tasyaapa\"syaama| ");
INSERT INTO sanvel_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tato yohanapi pracaaryya saak.syamida.m dattavaan yo mama pa\"scaad aagami.syati sa matto gurutara.h; yato matpuurvva.m sa vidyamaana aasiit; yadartham aha.m saak.syamidam adaa.m sa e.sa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","apara nca tasya puur.nataayaa vaya.m sarvve krama\"sa.h krama\"sonugraha.m praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","muusaadvaaraa vyavasthaa dattaa kintvanugraha.h satyatva nca yii\"sukhrii.s.tadvaaraa samupaati.s.thataa.m| ");
INSERT INTO sanvel_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kopi manuja ii\"svara.m kadaapi naapa\"syat kintu pitu.h kro.dastho.advitiiya.h putrasta.m prakaa\"sayat| ");
INSERT INTO sanvel_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tva.m ka.h? iti vaakya.m pre.s.tu.m yadaa yihuudiiyalokaa yaajakaan levilokaa.m\"sca yiruu\"saalamo yohana.h samiipe pre.sayaamaasu.h, ");
INSERT INTO sanvel_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadaa sa sviik.rtavaan naapahnuutavaan naaham abhi.sikta itya\"ngiik.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadaa te.ap.rcchan tarhi ko bhavaan? ki.m eliya.h? sovadat na; tataste.ap.rcchan tarhi bhavaan sa bhavi.syadvaadii? sovadat naaha.m sa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadaa te.ap.rcchan tarhi bhavaan ka.h? vaya.m gatvaa prerakaan tvayi ki.m vak.syaama.h? svasmin ki.m vadasi? ");
INSERT INTO sanvel_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadaa sovadat| parame\"sasya panthaana.m pari.skuruta sarvvata.h| itiida.m praantare vaakya.m vadata.h kasyacidrava.h| kathaamimaa.m yasmin yi\"sayiyo bhavi.syadvaadii likhitavaan soham| ");
INSERT INTO sanvel_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ye pre.sitaaste phiruu\"silokaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadaa te.ap.rcchan yadi naabhi.siktosi eliyosi na sa bhavi.syadvaadyapi naasi ca, tarhi lokaan majjayasi kuta.h? ");
INSERT INTO sanvel_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tato yohan pratyavocat, toye.aha.m majjayaamiiti satya.m kintu ya.m yuuya.m na jaaniitha taad.r\"sa eko jano yu.smaaka.m madhya upati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpa\"scaad aagatopi matpuurvva.m varttamaana aasiit tasya paadukaabandhana.m mocayitumapi naaha.m yogyosmi| ");
INSERT INTO sanvel_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyaa.h paarasthabaithabaaraayaa.m yasminsthaane yohanamajjayat tasmina sthaane sarvvametad agha.tata| ");
INSERT INTO sanvel_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","pare.ahani yohan svanika.tamaagacchanta.m yi\"su.m vilokya praavocat jagata.h paapamocakam ii\"svarasya me.sa\"saavaka.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yo mama pa\"scaadaagami.syati sa matto gurutara.h, yato hetormatpuurvva.m so.avarttata yasminnaha.m kathaamimaa.m kathitavaan sa evaaya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","apara.m naahamena.m pratyabhij naatavaan kintu israayellokaa ena.m yathaa paricinvanti tadabhipraaye.naaha.m jale majjayitumaagaccham| ");
INSERT INTO sanvel_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","puna\"sca yohanaparameka.m pramaa.na.m datvaa kathitavaan vihaayasa.h kapotavad avatarantamaatmaanam asyoparyyavati.s.thanta.m ca d.r.s.tavaanaham| ");
INSERT INTO sanvel_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","naahamena.m pratyabhij naatavaan iti satya.m kintu yo jale majjayitu.m maa.m prairayat sa evemaa.m kathaamakathayat yasyoparyyaatmaanam avatarantam avati.s.thanta nca drak.sayasi saeva pavitre aatmani majjayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastanniriik.syaayam ii\"svarasya tanaya iti pramaa.na.m dadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","pare.ahani yohan dvaabhyaa.m \"si.syaabhyaa.m saarddhe.m ti.s.than ");
INSERT INTO sanvel_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yi\"su.m gacchanta.m vilokya gaditavaan, ii\"svarasya me.sa\"saavaka.m pa\"syata.m| ");
INSERT INTO sanvel_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imaa.m kathaa.m \"srutvaa dvau \"si.syau yii\"so.h pa\"scaad iiyatu.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tato yii\"su.h paraav.rtya tau pa\"scaad aagacchantau d.r.s.tvaa p.r.s.tavaan yuvaa.m ki.m gave\"sayatha.h? taavap.rcchataa.m he rabbi arthaat he guro bhavaan kutra ti.s.thati? ");
INSERT INTO sanvel_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tata.h sovaadit etya pa\"syata.m| tato divasasya t.rtiiyapraharasya gatatvaat tau taddina.m tasya sa\"nge.asthaataa.m| ");
INSERT INTO sanvel_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yohano vaakya.m \"srutvaa yi\"so.h pa\"scaad aagamataa.m tayo.h \"simonpitarasya bhraataa aandriya.h ");
INSERT INTO sanvel_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvaa prathama.m nijasodara.m \"simona.m saak.saatpraapya kathitavaan vaya.m khrii.s.tam arthaat abhi.siktapuru.sa.m saak.saatk.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","pa\"scaat sa ta.m yi\"so.h samiipam aanayat| tadaa yii\"susta.m d.r.s.tvaavadat tva.m yuunasa.h putra.h \"simon kintu tvannaamadheya.m kaiphaa.h vaa pitara.h arthaat prastaro bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","pare.ahani yii\"sau gaaliila.m gantu.m ni\"scitacetasi sati philipanaamaana.m jana.m saak.saatpraapyaavocat mama pa\"scaad aagaccha| ");
INSERT INTO sanvel_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidaanaamni yasmin graame pitaraandriyayorvaasa aasiit tasmin graame tasya philipasya vasatiraasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","pa\"scaat philipo nithanela.m saak.saatpraapyaavadat muusaa vyavasthaa granthe bhavi.syadvaadinaa.m granthe.su ca yasyaakhyaana.m likhitamaaste ta.m yuu.sapha.h putra.m naasaratiiya.m yii\"su.m saak.saad akaar.sma vaya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadaa nithanel kathitavaan naasarannagaraata ki.m ka\"sciduttama utpantu.m \"saknoti? tata.h philipo .avocat etya pa\"sya| ");
INSERT INTO sanvel_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","apara nca yii\"su.h svasya samiipa.m tam aagacchanta.m d.r.s.tvaa vyaah.rtavaan, pa\"syaaya.m ni.skapa.ta.h satya israayelloka.h| ");
INSERT INTO sanvel_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tata.h sovadad, bhavaan maa.m katha.m pratyabhijaanaati? yii\"suravaadiit philipasya aahvaanaat puurvva.m yadaa tvamu.dumbarasya tarormuule.asthaastadaa tvaamadar\"sam| ");
INSERT INTO sanvel_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanel acakathat, he guro bhavaan nitaantam ii\"svarasya putrosi, bhavaan israayelva.m\"sasya raajaa| ");
INSERT INTO sanvel_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tato yii\"su rvyaaharat, tvaamu.dumbarasya paadapasya muule d.r.s.tavaanaaha.m mamaitasmaadvaakyaat ki.m tva.m vya\"svasii.h? etasmaadapyaa\"scaryyaa.ni kaaryyaa.ni drak.syasi| ");
INSERT INTO sanvel_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyaccaavaadiid yu.smaanaha.m yathaartha.m vadaami, ita.h para.m mocite meghadvaare tasmaanmanujasuununaa ii\"svarasya duutaga.nam avarohantamaarohanta nca drak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantara.m trutiiyadivase gaaliil prade\"siye kaannaanaamni nagare vivaaha aasiit tatra ca yii\"sormaataa ti.s.that| ");
INSERT INTO sanvel_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivaahaaya yii\"sustasya \"si.syaa\"sca nimantritaa aasan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantara.m draak.saarasasya nyuunatvaad yii\"sormaataa tamavadat ete.saa.m draak.saaraso naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadaa sa taamavocat he naari mayaa saha tava ki.m kaaryya.m? mama samaya idaanii.m nopati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya maataa daasaanavocad aya.m yad vadati tadeva kuruta| ");
INSERT INTO sanvel_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthaane yihuudiiyaanaa.m \"sucitvakara.navyavahaaraanusaare.naa.dhakaikajaladharaa.ni paa.saa.namayaani .sa.dv.rhatpaatraa.niaasan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadaa yii\"sustaan sarvvakala\"saan jalai.h puurayitu.m taanaaj naapayat, tataste sarvvaan kumbhaanaakar.na.m jalai.h paryyapuurayan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tebhya.h ki nciduttaaryya bhojyaadhipaate.hsamiipa.m netu.m sa taanaadi\"sat, te tadanayan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","apara nca tajjala.m katha.m draak.saaraso.abhavat tajjalavaahakaadaasaa j naatu.m \"saktaa.h kintu tadbhojyaadhipo j naatu.m naa\"saknot tadavalihya vara.m sa.mmbodyaavadata, ");
INSERT INTO sanvel_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lokaa.h prathama.m uttamadraak.saarasa.m dadati ta.su yathe.s.ta.m pitavatsu tasmaa ki ncidanuttama nca dadati kintu tvamidaanii.m yaavat uttamadraak.saarasa.m sthaapayasi| ");
INSERT INTO sanvel_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ittha.m yii\"surgaaliilaprade\"se aa\"scaryyakaarmma praarambha nijamahimaana.m praakaa\"sayat tata.h \"si.syaastasmin vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tata.h param sa nijamaatrubhraatrus\"si.syai.h saarddh.m kapharnaahuumam aagamat kintu tatra bahuudinaani aati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantara.m yihuudiyaanaa.m nistaarotsave nika.tamaagate yii\"su ryiruu\"saalam nagaram aagacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tato mandirasya madhye gome.sapaaraavatavikrayi.no vaa.nijak.scopavi.s.taan vilokya ");
INSERT INTO sanvel_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhi.h ka\"saa.m nirmmaaya sarvvagome.saadibhi.h saarddha.m taan mandiraad duuriik.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","va.nijaa.m mudraadi vikiiryya aasanaani nyuubjiik.rtya paaraavatavikrayibhyo.akathayad asmaat sthaanaat sarvaa.nyetaani nayata, mama pitug.rha.m vaa.nijyag.rha.m maa kaar.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmaat tanmandiraartha udyogo yastu sa grasatiiva maam| imaa.m \"saastriiyalipi.m \"si.syaa.hsamasmaran| ");
INSERT INTO sanvel_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tata.h param yihuudiiyalokaa yii.simavadan tavamid.r\"sakarmmakara.naat ki.m cihnamasmaan dar\"sayasi? ");
INSERT INTO sanvel_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tato yii\"sustaanavocad yu.smaabhire tasmin mandire naa\"site dinatrayamadhye.aha.m tad utthaapayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadaa yihuudiyaa vyaahaar.su.h, etasya mandirasa nirmmaa.nena .sa.tcatvaari.m\"sad vatsaraa gataa.h, tva.m ki.m dinatrayamadhye tad utthaapayi.syasi? ");
INSERT INTO sanvel_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadeharuupamandire kathaamimaa.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadetaad.r\"sa.m gaditavaan tacchi.syaa.h \"sma\"saanaat tadiiyotthaane sati sm.rtvaa dharmmagranthe yii\"sunoktakathaayaa.m ca vya\"svasi.su.h| ");
INSERT INTO sanvel_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantara.m nistaarotsavasya bhojyasamaye yiruu\"saalam nagare tatkrutaa\"scaryyakarmmaa.ni vilokya bahubhistasya naamani vi\"svasita.m| ");
INSERT INTO sanvel_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa te.saa.m kare.su sva.m na samarpayat, yata.h sa sarvvaanavait| ");
INSERT INTO sanvel_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa maanave.su kasyacit pramaa.na.m naapek.sata yato manujaanaa.m madhye yadyadasti tattat sojaanaat| ");
INSERT INTO sanvel_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanaamaa yihuudiiyaanaam adhipati.h phiruu\"sii k.sa.nadaayaa.m ");
INSERT INTO sanvel_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yii\"saurabhyar.nam aavrajya vyaahaar.siit, he guro bhavaan ii\"svaraad aagat eka upade.s.taa, etad asmaabhirj naayate; yato bhavataa yaanyaa\"scaryyakarmmaa.ni kriyante parame\"svarasya saahaayya.m vinaa kenaapi tattatkarmmaa.ni karttu.m na \"sakyante| ");
INSERT INTO sanvel_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadaa yii\"suruttara.m dattavaan tavaaha.m yathaarthatara.m vyaaharaami punarjanmani na sati kopi maanava ii\"svarasya raajya.m dra.s.tu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tato nikadiima.h pratyavocat manujo v.rddho bhuutvaa katha.m jani.syate? sa ki.m puna rmaat.rrja.thara.m pravi\"sya janitu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yii\"suravaadiid yathaarthataram aha.m kathayaami manuje toyaatmabhyaa.m puna rna jaate sa ii\"svarasya raajya.m prave.s.tu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","maa.msaad yat jaayate tan maa.msameva tathaatmano yo jaayate sa aatmaiva| ");
INSERT INTO sanvel_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yu.smaabhi.h puna rjanitavya.m mamaitasyaa.m kathaayaam aa\"scarya.m maa ma.msthaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadaagatiryaa.m di\"samicchati tasyaameva di\"si vaati, tva.m tasya svana.m \"su.no.si kintu sa kuta aayaati kutra yaati vaa kimapi na jaanaasi tadvaad aatmana.h sakaa\"saat sarvve.saa.m manujaanaa.m janma bhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadaa nikadiima.h p.r.s.tavaan etat katha.m bhavitu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yii\"su.h pratyaktavaan tvamisraayelo gururbhuutvaapi kimetaa.m kathaa.m na vetsi? ");
INSERT INTO sanvel_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhya.m yathaartha.m kathayaami, vaya.m yad vidmastad vacma.h ya.mcca pa\"syaamastasyaiva saak.sya.m dadma.h kintu yu.smaabhirasmaaka.m saak.sitva.m na g.rhyate| ");
INSERT INTO sanvel_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","etasya sa.msaarasya kathaayaa.m kathitaayaa.m yadi yuuya.m na vi\"svasitha tarhi svargiiyaayaa.m kathaayaa.m katha.m vi\"svasi.syatha? ");
INSERT INTO sanvel_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ya.h svarge.asti ya.m ca svargaad avaarohat ta.m maanavatanaya.m vinaa kopi svarga.m naarohat| ");
INSERT INTO sanvel_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","apara nca muusaa yathaa praantare sarpa.m protthaapitavaan manu.syaputro.api tathaivotthaapitavya.h; ");
INSERT INTO sanvel_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmaad ya.h ka\"scit tasmin vi\"svasi.syati so.avinaa\"sya.h san anantaayu.h praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ii\"svara ittha.m jagadadayata yat svamadvitiiya.m tanaya.m praadadaat tato ya.h ka\"scit tasmin vi\"svasi.syati so.avinaa\"sya.h san anantaayu.h praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ii\"svaro jagato lokaan da.n.dayitu.m svaputra.m na pre.sya taan paritraatu.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataeva ya.h ka\"scit tasmin vi\"svasiti sa da.n.daarho na bhavati kintu ya.h ka\"scit tasmin na vi\"svasiti sa idaaniimeva da.n.daarho bhavati,yata.h sa ii\"svarasyaadvitiiyaputrasya naamani pratyaya.m na karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagato madhye jyoti.h praakaa\"sata kintu manu.syaa.naa.m karmma.naa.m d.r.s.tatvaat te jyoti.sopi timire priiyante etadeva da.n.dasya kaara.naa.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ya.h kukarmma karoti tasyaacaarasya d.r.s.tatvaat sa jyotir.rrtiiyitvaa tannika.ta.m naayaati; ");
INSERT INTO sanvel_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu ya.h satkarmma karoti tasya sarvvaa.ni karmmaa.nii\"svare.na k.rtaaniiti sathaa prakaa\"sate tadabhipraaye.na sa jyoti.sa.h sannidhim aayaati| ");
INSERT INTO sanvel_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tata.h param yii\"su.h \"si.syai.h saarddha.m yihuudiiyade\"sa.m gatvaa tatra sthitvaa majjayitum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadaa \"saalam nagarasya samiipasthaayini ainan graame bahutaratoyasthitestatra yohan amajjayat tathaa ca lokaa aagatya tena majjitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadaa yohan kaaraayaa.m na baddha.h| ");
INSERT INTO sanvel_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","apara nca \"saacakarmma.ni yohaana.h \"si.syai.h saha yihuudiiyalokaanaa.m vivaade jaate, te yohana.h sa.mnnidhi.m gatvaakathayan, ");
INSERT INTO sanvel_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","he guro yarddananadyaa.h paare bhavataa saarddha.m ya aasiit yasmi.m\"sca bhavaan saak.sya.m pradadaat pa\"syatu sopi majjayati sarvve tasya samiipa.m yaanti ca| ");
INSERT INTO sanvel_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadaa yohan pratyavocad ii\"svare.na na datte kopi manuja.h kimapi praaptu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","aha.m abhi.sikto na bhavaami kintu tadagre pre.sitosmi yaamimaa.m kathaa.m kathitavaanaaha.m tatra yuuya.m sarvve saak.si.na.h stha| ");
INSERT INTO sanvel_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yo jana.h kanyaa.m labhate sa eva vara.h kintu varasya sannidhau da.n.daayamaana.m tasya yanmitra.m tena varasya \"sabde \"srute.atiivaahlaadyate mamaapi tadvad aanandasiddhirjaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tena krama\"so varddhitavya.m kintu mayaa hsitavya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya uurdhvaadaagacchat sa sarvve.saa.m mukhyo ya\"sca sa.msaaraad udapadyata sa saa.msaarika.h sa.msaariiyaa.m kathaa nca kathayati yastu svargaadaagacchat sa sarvve.saa.m mukhya.h| ");
INSERT INTO sanvel_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapa\"syada\"s.r.nocca tasminneva saak.sya.m dadaati tathaapi praaya\"sa.h ka\"scit tasya saak.sya.m na g.rhlaati; ");
INSERT INTO sanvel_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yo g.rhlaati sa ii\"svarasya satyavaaditva.m mudraa\"ngita.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ii\"svare.na ya.h prerita.h saeva ii\"svariiyakathaa.m kathayati yata ii\"svara aatmaana.m tasmai aparimitam adadaat| ");
INSERT INTO sanvel_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitaa putre sneha.m k.rtvaa tasya haste sarvvaa.ni samarpitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ya.h ka\"scit putre vi\"svasiti sa evaanantam paramaayu.h praapnoti kintu ya.h ka\"scit putre na vi\"svasiti sa paramaayu.so dar\"sana.m na praapnoti kintvii\"svarasya kopabhaajana.m bhuutvaa ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yii\"su.h svaya.m naamajjayat kevala.m tasya \"si.syaa amajjayat kintu yohano.adhika\"si.syaan sa karoti majjayati ca, ");
INSERT INTO sanvel_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phiruu\"sina imaa.m vaarttaama\"s.r.nvan iti prabhuravagatya ");
INSERT INTO sanvel_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihuudiiyade\"sa.m vihaaya puna rgaaliilam aagat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tata.h \"somiro.naprade\"sasya madyena tena gantavye sati ");
INSERT INTO sanvel_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yaakuub nijaputraaya yuu.saphe yaa.m bhuumim adadaat tatsamiipasthaayi \"somiro.naprade\"sasya sukhaar naamnaa vikhyaatasya nagarasya sannidhaavupaasthaat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yaakuuba.h prahiraasiit; tadaa dvitiiyayaamavelaayaa.m jaataayaa.m sa maarge \"sramaapannastasya prahe.h paar\"sve upaavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","etarhi kaacit \"somiro.niiyaa yo.sit toyottolanaartham tatraagamat ");
INSERT INTO sanvel_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadaa \"si.syaa.h khaadyadravyaa.ni kretu.m nagaram agacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yii\"su.h \"somiro.niiyaa.m taa.m yo.sitam vyaahaar.siit mahya.m ki ncit paaniiya.m paatu.m dehi| kintu \"somiro.niiyai.h saaka.m yihuudiiyalokaa na vyavaaharan tasmaaddheto.h saakathayat \"somiro.niiyaa yo.sitadaha.m tva.m yihuudiiyosi katha.m matta.h paaniiya.m paatum icchasi? ");
INSERT INTO sanvel_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tato yii\"suravadad ii\"svarasya yaddaana.m tatkiid.rk paaniiya.m paatu.m mahya.m dehi ya ittha.m tvaa.m yaacate sa vaa ka iti cedaj naasyathaastarhi tamayaaci.syathaa.h sa ca tubhyamam.rta.m toyamadaasyat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadaa saa siimantinii bhaa.sitavati, he maheccha prahirgambhiiro bhavato niirottolanapaatra.m naastii ca tasmaat tadam.rta.m kiilaala.m kuta.h praapsyasi? ");
INSERT INTO sanvel_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yosmabhyam imamandhuu.m dadau, yasya ca parijanaa gome.saadaya\"sca sarvve.asya prahe.h paaniiya.m papuretaad.r\"so yosmaaka.m puurvvapuru.so yaakuub tasmaadapi bhavaan mahaan ki.m? ");
INSERT INTO sanvel_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tato yii\"surakathayad ida.m paaniiya.m sa.h pivati sa punast.r.saartto bhavi.syati, ");
INSERT INTO sanvel_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayaa datta.m paaniiya.m ya.h pivati sa puna.h kadaapi t.r.saartto na bhavi.syati| mayaa dattam ida.m toya.m tasyaanta.h prasrava.naruupa.m bhuutvaa anantaayuryaavat sro.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadaa saa vanitaakathayat he maheccha tarhi mama puna.h piipaasaa yathaa na jaayate toyottolanaaya yathaatraagamana.m na bhavati ca tadartha.m mahya.m tattoya.m dehii| ");
INSERT INTO sanvel_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tato yii\"suuravadadyaahi tava patimaahuuya sthaane.atraagaccha| ");
INSERT INTO sanvel_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","saa vaamaavadat mama patirnaasti| yii\"suravadat mama patirnaastiiti vaakya.m bhadramavoca.h| ");
INSERT INTO sanvel_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava pa nca patayobhavan adhunaa tu tvayaa saarddha.m yasti.s.thati sa tava bharttaa na vaakyamida.m satyamavaadi.h| ");
INSERT INTO sanvel_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadaa saa mahilaa gaditavati he maheccha bhavaan eko bhavi.syadvaadiiti buddha.m mayaa| ");
INSERT INTO sanvel_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmaaka.m pit.rlokaa etasmin \"siloccaye.abhajanta, kintu bhavadbhirucyate yiruu\"saalam nagare bhajanayogya.m sthaanamaaste| ");
INSERT INTO sanvel_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yii\"suravocat he yo.sit mama vaakye vi\"svasihi yadaa yuuya.m kevala\"saile.asmin vaa yiruu\"saalam nagare piturbhajana.m na kari.syadhve kaala etaad.r\"sa aayaati| ");
INSERT INTO sanvel_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yuuya.m ya.m bhajadhve ta.m na jaaniitha, kintu vaya.m ya.m bhajaamahe ta.m jaaniimahe, yato yihuudiiyalokaanaa.m madhyaat paritraa.na.m jaayate| ");
INSERT INTO sanvel_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadaa satyabhaktaa aatmanaa satyaruupe.na ca piturbhajana.m kari.syante samaya etaad.r\"sa aayaati, varam idaaniimapi vidyate ; yata etaad.r\"so bhatkaan pitaa ce.s.tate| ");
INSERT INTO sanvel_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ii\"svara aatmaa; tatastasya ye bhaktaastai.h sa aatmanaa satyaruupe.na ca bhajaniiya.h| ");
INSERT INTO sanvel_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadaa saa mahilaavaadiit khrii.s.tanaamnaa vikhyaato.abhi.sikta.h puru.sa aagami.syatiiti jaanaami sa ca sarvvaa.h kathaa asmaan j naapayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tato yii\"suravadat tvayaa saarddha.m kathana.m karomi yo.aham ahameva sa puru.sa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","etasmin samaye \"si.syaa aagatya tathaa striyaa saarddha.m tasya kathopakathane mahaa\"scaryyam amanyanta tathaapi bhavaan kimicchati? yadvaa kimartham etayaa saarddha.m kathaa.m kathayati? iti kopi naap.rcchat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tata.h para.m saa naarii kala\"sa.m sthaapayitvaa nagaramadhya.m gatvaa lokebhyokathaayad ");
INSERT INTO sanvel_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","aha.m yadyat karmmaakarava.m tatsarvva.m mahyamakathayad etaad.r\"sa.m maanavamekam aagatya pa\"syata ru kim abhi.sikto na bhavati ? ");
INSERT INTO sanvel_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tataste nagaraad bahiraagatya taatasya samiipam aayan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","etarhi \"si.syaa.h saadhayitvaa ta.m vyaahaar.su.h he guro bhavaan ki ncid bhuuktaa.m| ");
INSERT INTO sanvel_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tata.h sovadad yu.smaabhiryanna j naayate taad.r\"sa.m bhak.sya.m mamaaste| ");
INSERT INTO sanvel_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadaa \"si.syaa.h paraspara.m pra.s.tum aarambhanta, kimasmai kopi kimapi bhak.syamaaniiya dattavaan? ");
INSERT INTO sanvel_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yii\"suravocat matprerakasyaabhimataanuruupakara.na.m tasyaiva karmmasiddhikaara.na nca mama bhak.sya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","maasacatu.s.taye jaate \"sasyakarttanasamayo bhavi.syatiiti vaakya.m yu.smaabhi.h ki.m nodyate? kintvaha.m vadaami, \"sira uttolya k.setraa.ni prati niriik.sya pa\"syata, idaanii.m karttanayogyaani \"suklavar.naanyabhavan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ya\"schinatti sa vetana.m labhate anantaayu.hsvaruupa.m \"sasya.m sa g.rhlaati ca, tenaiva vaptaa chettaa ca yugapad aanandata.h| ");
INSERT INTO sanvel_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ittha.m sati vapatyeka\"schinatyanya iti vacana.m siddhyati| ");
INSERT INTO sanvel_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yuuya.m na paryya\"sraamyata taad.r\"sa.m \"sasya.m chettu.m yu.smaan prairayam anye janaa.hparyya\"sraamyan yuuya.m te.saa.m \"sragasya phalam alabhadhvam| ");
INSERT INTO sanvel_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kaale yadyat karmmaakaar.sa.m tatsarvva.m sa mahyam akathayat tasyaa vanitaayaa ida.m saak.syavaakya.m \"srutvaa tannagaranivaasino bahava.h \"somiro.niiyalokaa vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathaa ca tasyaantike samupasthaaya sve.saa.m sannidhau katicid dinaani sthaatu.m tasmin vinayam akurvvaana tasmaat sa dinadvaya.m tatsthaane nyava.s.tat ");
INSERT INTO sanvel_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyopade\"sena bahavo.apare vi\"svasya ");
INSERT INTO sanvel_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","taa.m yo.saamavadan kevala.m tava vaakyena pratiima iti na, kintu sa jagato.abhi.siktastraateti tasya kathaa.m \"srutvaa vaya.m svayamevaaj naasamahi| ");
INSERT INTO sanvel_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svade\"se bhavi.syadvaktu.h satkaaro naastiiti yadyapi yii\"su.h pramaa.na.m datvaakathayat ");
INSERT INTO sanvel_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathaapi divasadvayaat para.m sa tasmaat sthaanaad gaaliila.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantara.m ye gaaliilii liyalokaa utsave gataa utsavasamaye yiruu\"salam nagare tasya sarvvaa.h kriyaa apa\"syan te gaaliilam aagata.m tam aag.rhlan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tata.h param yii\"su ryasmin kaannaanagare jala.m draak.saarasam aakarot tat sthaana.m punaragaat| tasminneva samaye kasyacid raajasabhaastaarasya putra.h kapharnaahuumapurii rogagrasta aasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yehuudiiyade\"saad yii\"so rgaaliilaagamanavaarttaa.m ni\"samya tasya samiipa.m gatvaa praarthya vyaah.rtavaan mama putrasya praaye.na kaala aasanna.h bhavaan aagatya ta.m svastha.m karotu| ");
INSERT INTO sanvel_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadaa yii\"surakathayad aa\"scaryya.m karmma citra.m cihna.m ca na d.r.s.taa yuuya.m na pratye.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tata.h sa sabhaasadavadat he maheccha mama putre na m.rte bhavaanaagacchatu| ");
INSERT INTO sanvel_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yii\"sustamavadad gaccha tava putro.ajiiviit tadaa yii\"sunoktavaakye sa vi\"svasya gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakaale maargamadhye daasaasta.m saak.saatpraapyaavadan bhavata.h putro.ajiiviit| ");
INSERT INTO sanvel_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tata.h ka.m kaalamaarabhya rogapratiikaaraarambho jaataa iti p.r.s.te tairukta.m hya.h saarddhada.n.dadvayaadhikadvitiiyayaame tasya jvaratyaago.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadaa yii\"sustasmin k.sa.ne proktavaan tava putro.ajiiviit pitaa tadbuddhvaa saparivaaro vya\"svasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihuudiiyade\"saad aagatya gaaliili yii\"suretad dvitiiyam aa\"scaryyakarmmaakarot| ");
INSERT INTO sanvel_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tata.h para.m yihuudiiyaanaam utsava upasthite yii\"su ryiruu\"saalama.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagare me.sanaamno dvaarasya samiipe ibriiyabhaa.sayaa baithesdaa naamnaa pi.skari.nii pa ncagha.t.tayuktaasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyaaste.su gha.t.te.su kilaalakampanam apek.sya andhakha nca\"su.skaa\"ngaadayo bahavo rogi.na.h patantasti.s.thanti sma| ");
INSERT INTO sanvel_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yato vi\"se.sakaale tasya saraso vaari svargiiyaduuta etyaakampayat tatkiilaalakampanaat para.m ya.h ka\"scid rogii prathama.m paaniiyamavaarohat sa eva tatk.sa.naad rogamukto.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadaa.s.taatri.m\"sadvar.saa.ni yaavad rogagrasta ekajanastasmin sthaane sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yii\"susta.m \"sayita.m d.r.s.tvaa bahukaalikarogiiti j naatvaa vyaah.rtavaan tva.m ki.m svastho bubhuu.sasi? ");
INSERT INTO sanvel_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tato rogii kathitavaan he maheccha yadaa kiilaala.m kampate tadaa maa.m pu.skari.niim avarohayitu.m mama kopi naasti, tasmaan mama gamanakaale ka\"scidanyo.agro gatvaa avarohati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadaa yii\"surakathayad utti.s.tha, tava \"sayyaamuttolya g.rhiitvaa yaahi| ");
INSERT INTO sanvel_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatk.sa.naat svastho bhuutvaa \"sayyaamuttolyaadaaya gatavaan kintu taddina.m vi\"sraamavaara.h| ");
INSERT INTO sanvel_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmaad yihuudiiyaa.h svastha.m nara.m vyaaharan adya vi\"sraamavaare \"sayaniiyamaadaaya na yaatavyam| ");
INSERT INTO sanvel_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tata.h sa pratyavocad yo maa.m svastham akaar.siit \"sayaniiyam uttolyaadaaya yaatu.m maa.m sa evaadi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadaa te.ap.rcchan \"sayaniiyam uttolyaadaaya yaatu.m ya aaj naapayat sa ka.h? ");
INSERT INTO sanvel_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthiibhuuto naajaanaad yatastasmin sthaane janataasattvaad yii\"su.h sthaanaantaram aagamat| ");
INSERT INTO sanvel_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tata.h para.m ye\"su rmandire ta.m nara.m saak.saatpraapyaakathayat pa\"syedaaniim anaamayo jaatosi yathaadhikaa durda\"saa na gha.tate taddheto.h paapa.m karmma punarmaakaar.sii.h| ");
INSERT INTO sanvel_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tata.h sa gatvaa yihuudiiyaan avadad yii\"su rmaam arogi.nam akaar.siit| ");
INSERT INTO sanvel_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tato yii\"su rvi\"sraamavaare karmmed.r\"sa.m k.rtavaan iti heto ryihuudiiyaasta.m taa.dayitvaa hantum ace.s.tanta| ");
INSERT INTO sanvel_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yii\"sustaanaakhyat mama pitaa yat kaaryya.m karoti tadanuruupam ahamapi karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tato yihuudiiyaasta.m hantu.m punarayatanta yato vi\"sraamavaara.m naamanyata tadeva kevala.m na adhikantu ii\"svara.m svapitara.m procya svamapii\"svaratulya.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","pa\"scaad yii\"suravadad yu.smaanaha.m yathaarthatara.m vadaami putra.h pitara.m yadyat karmma kurvvanta.m pa\"syati tadatirikta.m svecchaata.h kimapi karmma karttu.m na \"saknoti| pitaa yat karoti putropi tadeva karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitaa putre sneha.m karoti tasmaat svaya.m yadyat karmma karoti tatsarvva.m putra.m dar\"sayati ; yathaa ca yu.smaaka.m aa\"scaryyaj naana.m jani.syate tadartham itopi mahaakarmma ta.m dar\"sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitaa yathaa pramitaan utthaapya sajivaan karoti tadvat putropi ya.m ya.m icchati ta.m ta.m sajiiva.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvve pitara.m yathaa satkurvvanti tathaa putramapi satkaarayitu.m pitaa svaya.m kasyaapi vicaaramak.rtvaa sarvvavicaaraa.naa.m bhaara.m putre samarpitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ya.h putra.m sat karoti sa tasya prerakamapi sat karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yu.smaanaaha.m yathaarthatara.m vadaami yo jano mama vaakya.m \"srutvaa matprerake vi\"svasiti sonantaayu.h praapnoti kadaapi da.n.dabaajana.m na bhavati nidhanaadutthaaya paramaayu.h praapnoti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","aha.m yu.smaanatiyathaartha.m vadaami yadaa m.rtaa ii\"svaraputrasya ninaada.m \"sro.syanti ye ca \"sro.syanti te sajiivaa bhavi.syanti samaya etaad.r\"sa aayaati varam idaaniimapyupati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitaa yathaa svaya njiivii tathaa putraaya svaya njiivitvaadhikaara.m dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manu.syaputra.h etasmaat kaara.naat pitaa da.n.dakara.naadhikaaramapi tasmin samarpitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","etadarthe yuuyam aa\"scaryya.m na manyadhva.m yato yasmin samaye tasya ninaada.m \"srutvaa \"sma\"saanasthaa.h sarvve bahiraagami.syanti samaya etaad.r\"sa upasthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmaad ye satkarmmaa.ni k.rtavantasta utthaaya aayu.h praapsyanti ye ca kukarmaa.ni k.rtavantasta utthaaya da.n.da.m praapsyanti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","aha.m svaya.m kimapi karttu.m na \"saknomi yathaa \"su.nomi tathaa vicaarayaami mama vicaara nca nyaayya.h yatoha.m sviiyaabhii.s.ta.m nehitvaa matprerayitu.h pituri.s.tam iihe| ");
INSERT INTO sanvel_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svaya.m saak.sya.m dadaami tarhi tatsaak.syam aagraahya.m bhavati ; ");
INSERT INTO sanvel_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthe.aparo jana.h saak.sya.m dadaati madarthe tasya yat saak.sya.m tat satyam etadapyaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yu.smaabhi ryohana.m prati loke.su prerite.su sa satyakathaayaa.m saak.syamadadaat| ");
INSERT INTO sanvel_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","maanu.saadaha.m saak.sya.m nopek.se tathaapi yuuya.m yathaa paritrayadhve tadartham ida.m vaakya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yohan dediipyamaano diipa iva tejasvii sthitavaan yuuyam alpakaala.m tasya diiptyaananditu.m samamanyadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramaa.naadapi mama gurutara.m pramaa.na.m vidyate pitaa maa.m pre.sya yadyat karmma samaapayitu.m \"sakttimadadaat mayaa k.rta.m tattat karmma madarthe pramaa.na.m dadaati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ya.h pitaa maa.m preritavaan mopi madarthe pramaa.na.m dadaati| tasya vaakya.m yu.smaabhi.h kadaapi na \"sruta.m tasya ruupa nca na d.r.s.ta.m ");
INSERT INTO sanvel_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vaakya nca yu.smaakam anta.h kadaapi sthaana.m naapnoti yata.h sa ya.m pre.sitavaan yuuya.m tasmin na vi\"svasitha| ");
INSERT INTO sanvel_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakaani yuuyam aalocayadhva.m tai rvaakyairanantaayu.h praapsyaama iti yuuya.m budhyadhve taddharmmapustakaani madarthe pramaa.na.m dadati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathaapi yuuya.m paramaayu.hpraaptaye mama sa.mnidhim na jigami.satha| ");
INSERT INTO sanvel_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","aha.m maanu.sebhya.h satkaara.m na g.rhlaami| ");
INSERT INTO sanvel_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","aha.m yu.smaan jaanaami; yu.smaakamantara ii\"svaraprema naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","aha.m nijapitu rnaamnaagatosmi tathaapi maa.m na g.rhliitha kintu ka\"scid yadi svanaamnaa samaagami.syati tarhi ta.m grahii.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yuuyam ii\"svaraat satkaara.m na ci.s.tatvaa kevala.m paraspara.m satkaaram ced aadadhvve tarhi katha.m vi\"svasitu.m \"saknutha? ");
INSERT INTO sanvel_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putu.h samiipe.aha.m yu.smaan apavadi.syaamiiti maa cintayata yasmin , yasmin yu.smaaka.m vi\"svasa.h saeva muusaa yu.smaan apavadati| ");
INSERT INTO sanvel_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yuuya.m tasmin vya\"svasi.syata tarhi mayyapi vya\"svasi.syata, yat sa mayi likhitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tato yadi tena likhitavaani na pratitha tarhi mama vaakyaani katha.m pratye.syatha? ");
INSERT INTO sanvel_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tata.h para.m yii\"su rgaaliil prade\"siiyasya tiviriyaanaamna.h sindho.h paara.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tato vyaadhimallokasvaasthyakara.naruupaa.ni tasyaa\"scaryyaa.ni karmmaa.ni d.r.s.tvaa bahavo janaastatpa\"scaad agacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tato yii\"su.h parvvatamaaruhya tatra \"si.syai.h saakam| ");
INSERT INTO sanvel_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistaarotsavanaamni yihuudiiyaanaama utsava upasthite ");
INSERT INTO sanvel_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yii\"su rnetre uttolya bahulokaan svasamiipaagataan vilokya philipa.m p.r.s.tavaan ete.saa.m bhojanaaya bhojadravyaa.ni vaya.m kutra kretu.m \"sakruma.h? ");
INSERT INTO sanvel_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vaakyamida.m tasya pariik.saartham avaadiit kintu yat kari.syati tat svayam ajaanaat| ");
INSERT INTO sanvel_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipa.h pratyavocat ete.saam ekaiko yadyalpam alpa.m praapnoti tarhi mudraapaadadvi\"satena kriitapuupaa api nyuunaa bhavi.syanti| ");
INSERT INTO sanvel_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","\"simon pitarasya bhraataa aandriyaakhya.h \"si.syaa.naameko vyaah.rtavaan ");
INSERT INTO sanvel_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyacid baalakasya samiipe pa nca yaavapuupaa.h k.sudramatsyadvaya nca santi kintu lokaanaa.m etaavaataa.m madhye tai.h ki.m bhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","pa\"scaad yii\"suravadat lokaanupave\"sayata tatra bahuyavasasattvaat pa ncasahastrebhyo nyuunaa adhikaa vaa puru.saa bhuumyaam upaavi\"san| ");
INSERT INTO sanvel_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tato yii\"sustaan puupaanaadaaya ii\"svarasya gu.naan kiirttayitvaa \"si.sye.su samaarpayat tataste tebhya upavi.s.talokebhya.h puupaan yathe.s.tamatsya nca praadu.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","te.su t.rpte.su sa taanavocad ete.saa.m ki ncidapi yathaa naapaciiyate tathaa sarvvaa.nyava\"si.s.taani sa.mg.rhliita| ");
INSERT INTO sanvel_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tata.h sarvve.saa.m bhojanaat para.m te te.saa.m pa ncaanaa.m yaavapuupaanaa.m ava\"si.s.taanyakhilaani sa.mg.rhya dvaada\"sa.dallakaan apuurayan| ");
INSERT INTO sanvel_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","apara.m yii\"soretaad.r\"siim aa\"scaryyakriyaa.m d.r.s.tvaa lokaa mitho vaktumaarebhire jagati yasyaagamana.m bhavi.syati sa evaayam ava\"sya.m bhavi.syadvakttaa| ");
INSERT INTO sanvel_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataeva lokaa aagatya tamaakramya raajaana.m kari.syanti yii\"suste.saam iid.r\"sa.m maanasa.m vij naaya puna\"sca parvvatam ekaakii gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","saaya.mkaala upasthite \"si.syaa jaladhita.ta.m vrajitvaa naavamaaruhya nagaradi\"si sindhau vaahayitvaagaman| ");
INSERT INTO sanvel_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samaye timira upaati.s.that kintu yii.suste.saa.m samiipa.m naagacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadaa prabalapavanavahanaat saagare mahaatara\"ngo bhavitum aarebhe| ");
INSERT INTO sanvel_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tataste vaahayitvaa dvitraan kro\"saan gataa.h pa\"scaad yii\"su.m jaladherupari padbhyaa.m vrajanta.m naukaantikam aagacchanta.m vilokya traasayuktaa abhavan ");
INSERT INTO sanvel_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa taanukttavaan ayamaha.m maa bhai.s.ta| ");
INSERT INTO sanvel_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadaa te ta.m svaira.m naavi g.rhiitavanta.h tadaa tatk.sa.naad uddi.s.tasthaane naurupaasthaat| ");
INSERT INTO sanvel_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayaa naavaa \"si.syaa agacchan tadanyaa kaapi naukaa tasmin sthaane naasiit tato yii\"su.h \"si.syai.h saaka.m naagamat kevalaa.h \"si.syaa agaman etat paarasthaa lokaa j naatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tata.h para.m prabhu ryatra ii\"svarasya gu.naan anukiirttya lokaan puupaan abhojayat tatsthaanasya samiipasthativiriyaayaa aparaastara.naya aagaman| ");
INSERT INTO sanvel_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yii\"sustatra naasti \"si.syaa api tatra naa santi lokaa iti vij naaya yii\"su.m gave.sayitu.m tara.nibhi.h kapharnaahuum pura.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tataste saritpate.h paare ta.m saak.saat praapya praavocan he guro bhavaan atra sthaane kadaagamat? ");
INSERT INTO sanvel_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadaa yii\"sustaan pratyavaadiid yu.smaanaha.m yathaarthatara.m vadaami aa\"scaryyakarmmadar\"sanaaddheto rna kintu puupabhojanaat tena t.rptatvaa nca maa.m gave.sayatha| ");
INSERT INTO sanvel_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","k.saya.niiyabhak.syaartha.m maa \"sraami.s.ta kintvantaayurbhak.syaartha.m \"sraamyata, tasmaat taad.r\"sa.m bhak.sya.m manujaputro yu.smaabhya.m daasyati; tasmin taata ii\"svara.h pramaa.na.m praadaat| ");
INSERT INTO sanvel_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadaa te.ap.rcchan ii\"svaraabhimata.m karmma karttum asmaabhi.h ki.m karttavya.m? ");
INSERT INTO sanvel_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tato yii\"suravadad ii\"svaro ya.m prairayat tasmin vi\"svasanam ii\"svaraabhimata.m karmma| ");
INSERT INTO sanvel_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadaa te vyaaharan bhavataa ki.m lak.sa.na.m dar\"sita.m yadd.r.s.tvaa bhavati vi\"svasi.syaama.h? tvayaa ki.m karmma k.rta.m? ");
INSERT INTO sanvel_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmaaka.m puurvvapuru.saa mahaapraantare maannaa.m bhokttu.m praapu.h yathaa lipiraaste| svargiiyaa.ni tu bhak.syaa.ni pradadau parame\"svara.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadaa yii\"suravadad aha.m yu.smaanatiyathaartha.m vadaami muusaa yu.smaabhya.m svargiiya.m bhak.sya.m naadaat kintu mama pitaa yu.smaabhya.m svargiiya.m parama.m bhak.sya.m dadaati| ");
INSERT INTO sanvel_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ya.h svargaadavaruhya jagate jiivana.m dadaati sa ii\"svaradattabhak.syaruupa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadaa te praavocan he prabho bhak.syamida.m nityamasmabhya.m dadaatu| ");
INSERT INTO sanvel_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yii\"suravadad ahameva jiivanaruupa.m bhak.sya.m yo jano mama sannidhim aagacchati sa jaatu k.sudhaartto na bhavi.syati, tathaa yo jano maa.m pratyeti sa jaatu t.r.saartto na bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","maa.m d.r.s.tvaapi yuuya.m na vi\"svasitha yu.smaanaham ityavoca.m| ");
INSERT INTO sanvel_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitaa mahya.m yaavato lokaanadadaat te sarvva eva mamaantikam aagami.syanti ya.h ka\"scicca mama sannidhim aayaasyati ta.m kenaapi prakaare.na na duuriikari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijaabhimata.m saadhayitu.m na hi kintu prerayiturabhimata.m saadhayitu.m svargaad aagatosmi| ");
INSERT INTO sanvel_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yaan yaan lokaan mahyamadadaat te.saamekamapi na haarayitvaa \"se.sadine sarvvaanaham utthaapayaami ida.m matprerayitu.h piturabhimata.m| ");
INSERT INTO sanvel_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ya.h ka\"scin maanavasuta.m vilokya vi\"svasiti sa \"se.sadine mayotthaapita.h san anantaayu.h praapsyati iti matprerakasyaabhimata.m| ");
INSERT INTO sanvel_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadaa svargaad yad bhak.syam avaarohat tad bhak.syam ahameva yihuudiiyalokaastasyaitad vaakye vivadamaanaa vakttumaarebhire ");
INSERT INTO sanvel_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yuu.sapha.h putro yii\"su ryasya maataapitarau vaya.m jaaniima e.sa ki.m saeva na? tarhi svargaad avaaroham iti vaakya.m katha.m vaktti? ");
INSERT INTO sanvel_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadaa yii\"sustaan pratyavadat paraspara.m maa vivadadhva.m ");
INSERT INTO sanvel_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprerake.na pitraa naak.r.s.ta.h kopi jano mamaantikam aayaatu.m na \"saknoti kintvaagata.m jana.m carame.ahni protthaapayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","te sarvva ii\"svare.na \"sik.sitaa bhavi.syanti bhavi.syadvaadinaa.m granthe.su lipiritthamaaste ato ya.h ka\"scit pitu.h sakaa\"saat \"srutvaa \"sik.sate sa eva mama samiipam aagami.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya ii\"svaraad ajaayata ta.m vinaa kopi manu.syo janaka.m naadar\"sat kevala.h saeva taatam adraak.siit| ");
INSERT INTO sanvel_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","aha.m yu.smaan yathaarthatara.m vadaami yo jano mayi vi\"svaasa.m karoti sonantaayu.h praapnoti| ");
INSERT INTO sanvel_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahameva tajjiivanabhak.sya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yu.smaaka.m puurvvapuru.saa mahaapraantare mannaabhak.sya.m bhuukttaapi m.rtaa.h ");
INSERT INTO sanvel_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhak.sya.m svargaadaagacchat tad yadi ka\"scid bhu\"nktte tarhi sa na mriyate| ");
INSERT INTO sanvel_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjiivanabhak.sya.m svargaadaagacchat sohameva ida.m bhak.sya.m yo jano bhu\"nktte sa nityajiivii bhavi.syati| puna\"sca jagato jiivanaarthamaha.m yat svakiiyapi\"sita.m daasyaami tadeva mayaa vitarita.m bhak.syam| ");
INSERT INTO sanvel_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmaad yihuudiiyaa.h paraspara.m vivadamaanaa vakttumaarebhire e.sa bhojanaartha.m sviiya.m palala.m katham asmabhya.m daasyati? ");
INSERT INTO sanvel_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadaa yii\"sustaan aavocad yu.smaanaha.m yathaarthatara.m vadaami manu.syaputrasyaami.se yu.smaabhi rna bhuktte tasya rudhire ca na piite jiivanena saarddha.m yu.smaaka.m sambandho naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yo mamaami.sa.m svaadati mama sudhira nca pivati sonantaayu.h praapnoti tata.h \"se.se.ahni tamaham utthaapayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yato madiiyamaami.sa.m parama.m bhak.sya.m tathaa madiiya.m \"so.nita.m parama.m peya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yo jano madiiya.m palala.m svaadati madiiya.m rudhira nca pivati sa mayi vasati tasminnaha nca vasaami| ");
INSERT INTO sanvel_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprerayitraa jiivataa taatena yathaaha.m jiivaami tadvad ya.h ka\"scin maamatti sopi mayaa jiivi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhak.sya.m svargaadaagacchat tadida.m yanmaannaa.m svaaditvaa yu.smaaka.m pitaro.amriyanta taad.r\"sam ida.m bhak.sya.m na bhavati ida.m bhak.sya.m yo bhak.sati sa nitya.m jiivi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadaa kapharnaahuum puryyaa.m bhajanagehe upaadi\"sat tadaa kathaa etaa akathayat| ");
INSERT INTO sanvel_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadettha.m \"srutvaa tasya \"si.syaa.naam aneke parasparam akathayan ida.m gaa.dha.m vaakya.m vaakyamiid.r\"sa.m ka.h \"srotu.m \"sakruyaat? ");
INSERT INTO sanvel_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yii\"su.h \"si.syaa.naam ittha.m vivaada.m svacitte vij naaya kathitavaan ida.m vaakya.m ki.m yu.smaaka.m vighna.m janayati? ");
INSERT INTO sanvel_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasuta.m puurvvavaasasthaanam uurdvva.m gacchanta.m pa\"syatha tarhi ki.m bhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","aatmaiva jiivanadaayaka.h vapu rni.sphala.m yu.smabhyamaha.m yaani vacaa.msi kathayaami taanyaatmaa jiivana nca| ");
INSERT INTO sanvel_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yu.smaaka.m madhye kecana avi\"svaasina.h santi ke ke na vi\"svasanti ko vaa ta.m parakare.su samarpayi.syati taan yii\"suraaprathamaad vetti| ");
INSERT INTO sanvel_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavaan asmaat kaara.naad akathaya.m pitu.h sakaa\"saat \"sakttimapraapya kopi mamaantikam aagantu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkaale.aneke \"si.syaa vyaaghu.tya tena saarddha.m puna rnaagacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadaa yii\"su rdvaada\"sa\"si.syaan ukttavaan yuuyamapi ki.m yaasyatha? ");
INSERT INTO sanvel_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tata.h \"simon pitara.h pratyavocat he prabho kasyaabhyar.na.m gami.syaama.h? ");
INSERT INTO sanvel_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajiivanadaayinyo yaa.h kathaastaastavaiva| bhavaan amare\"svarasyaabhi.sikttaputra iti vi\"svasya ni\"scita.m jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadaa yii\"suravadat kimaha.m yu.smaaka.m dvaada\"sajanaan manoniitaan na k.rtavaan? kintu yu.smaaka.m madhyepi ka\"scideko vighnakaarii vidyate| ");
INSERT INTO sanvel_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imaa.m katha.m sa \"simona.h putram ii.skariiyotiiya.m yihuudaam uddi\"sya kathitavaan yato dvaada\"saanaa.m madhye ga.nita.h sa ta.m parakare.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tata.h para.m yihuudiiyalokaasta.m hantu.m samaihanta tasmaad yii\"su ryihuudaaprade\"se paryya.titu.m necchan gaaliil prade\"se paryya.titu.m praarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samaye yihuudiiyaanaa.m duu.syavaasanaamotsava upasthite ");
INSERT INTO sanvel_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhraatarastam avadan yaani karmmaa.ni tvayaa kriyante taani yathaa tava \"si.syaa.h pa\"syanti tadartha.m tvamita.h sthaanaad yihuudiiyade\"sa.m vraja| ");
INSERT INTO sanvel_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ya.h ka\"scit svaya.m pracikaa\"si.sati sa kadaapi gupta.m karmma na karoti yadiid.r\"sa.m karmma karo.si tarhi jagati nija.m paricaayaya| ");
INSERT INTO sanvel_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhraataropi ta.m na vi\"svasanti| ");
INSERT INTO sanvel_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadaa yii\"sustaan avocat mama samaya idaanii.m nopati.s.thati kintu yu.smaaka.m samaya.h satatam upati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagato lokaa yu.smaan .rtiiyitu.m na \"sakruvanti kintu maameva .rtiiyante yataste.saa.m karmaa.ni du.s.taani tatra saak.syamidam aha.m dadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataeva yuuyam utsave.asmin yaata naaham idaaniim asminnutsave yaami yato mama samaya idaanii.m na sampuur.na.h| ");
INSERT INTO sanvel_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vaakyam ukttvaa sa gaaliili sthitavaan ");
INSERT INTO sanvel_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhraat.r.su tatra prasthite.su satsu so.apraka.ta utsavam agacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitaa yihuudiiyaasta.m m.rgayitvaap.rcchan sa kutra? ");
INSERT INTO sanvel_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tato lokaanaa.m madhye tasmin naanaavidhaa vivaadaa bhavitum aarabdhavanta.h| kecid avocan sa uttama.h puru.sa.h kecid avocan na tathaa vara.m lokaanaa.m bhrama.m janayati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihuudiiyaanaa.m bhayaat kopi tasya pak.se spa.s.ta.m naakathayat| ");
INSERT INTO sanvel_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tata.h param utsavasya madhyasamaye yii\"su rmandira.m gatvaa samupadi\"sati sma| ");
INSERT INTO sanvel_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tato yihuudiiyaa lokaa aa\"scaryya.m j naatvaakathayan e.saa maanu.so naadhiityaa katham etaad.r\"so vidvaanabhuut? ");
INSERT INTO sanvel_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadaa yii\"su.h pratyavocad upade\"soya.m na mama kintu yo maa.m pre.sitavaan tasya| ");
INSERT INTO sanvel_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yo jano nide\"sa.m tasya grahii.syati mamopade\"so matto bhavati kim ii\"svaraad bhavati sa ganastajj naatu.m \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yo jana.h svata.h kathayati sa sviiya.m gauravam iihate kintu ya.h prerayitu rgauravam iihate sa satyavaadii tasmin kopyadharmmo naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","muusaa yu.smabhya.m vyavasthaagrantha.m ki.m naadadaat? kintu yu.smaaka.m kopi taa.m vyavasthaa.m na samaacarati| maa.m hantu.m kuto yatadhve? ");
INSERT INTO sanvel_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadaa lokaa avadan tva.m bhuutagrastastvaa.m hantu.m ko yatate? ");
INSERT INTO sanvel_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tato yii\"suravocad eka.m karmma mayaakaari tasmaad yuuya.m sarvva mahaa\"scaryya.m manyadhve| ");
INSERT INTO sanvel_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","muusaa yu.smabhya.m tvakchedavidhi.m pradadau sa muusaato na jaata.h kintu pit.rpuru.sebhyo jaata.h tena vi\"sraamavaare.api maanu.saa.naa.m tvakcheda.m kurutha| ");
INSERT INTO sanvel_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataeva vi\"sraamavaare manu.syaa.naa.m tvakchede k.rte yadi muusaavyavasthaama\"ngana.m na bhavati tarhi mayaa vi\"sraamavaare maanu.sa.h sampuur.naruupe.na svastho.akaari tatkaara.naad yuuya.m ki.m mahya.m kupyatha? ");
INSERT INTO sanvel_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapak.sapaata.m vicaaramak.rtvaa nyaayya.m vicaara.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadaa yiruu\"saalam nivaasina.h katipayajanaa akathayan ime ya.m hantu.m ce.s.tante sa evaaya.m ki.m na? ");
INSERT INTO sanvel_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu pa\"syata nirbhaya.h san kathaa.m kathayati tathaapi kimapi a vadantyete ayamevaabhi.siktto bhavatiiti ni\"scita.m kimadhipatayo jaananti? ");
INSERT INTO sanvel_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujoya.m kasmaadaagamad iti vaya.m jaanoma.h kintvabhi.siktta aagate sa kasmaadaagatavaan iti kopi j naatu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadaa yii\"su rmadhyemandiram upadi\"san uccai.hkaaram ukttavaan yuuya.m ki.m maa.m jaaniitha? kasmaaccaagatosmi tadapi ki.m jaaniitha? naaha.m svata aagatosmi kintu ya.h satyavaadii saeva maa.m pre.sitavaan yuuya.m ta.m na jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamaha.m jaane tenaaha.m prerita agatosmi| ");
INSERT INTO sanvel_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmaad yihuudiiyaasta.m dharttum udyataastathaapi kopi tasya gaatre hasta.m naarpayad yato hetostadaa tasya samayo nopati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavo lokaastasmin vi\"svasya kathitavaanto.abhi.sikttapuru.sa aagatya maanu.sasyaasya kriyaabhya.h kim adhikaa aa\"scaryyaa.h kriyaa.h kari.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tata.h para.m lokaastasmin ittha.m vivadante phiruu\"sina.h pradhaanayaajakaa nceti \"srutavantasta.m dh.rtvaa netu.m padaatiga.na.m pre.sayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tato yii\"suravadad aham alpadinaani yu.smaabhi.h saarddha.m sthitvaa matprerayitu.h samiipa.m yaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","maa.m m.rgayi.syadhve kintuudde\"sa.m na lapsyadhve ratra sthaasyaami tatra yuuya.m gantu.m na \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadaa yihuudiiyaa.h paraspara.m vakttumaarebhire asyodde\"sa.m na praapsyaama etaad.r\"sa.m ki.m sthaana.m yaasyati? bhinnade\"se vikiir.naanaa.m yihuudiiyaanaa.m sannidhim e.sa gatvaa taan upadek.syati ki.m? ");
INSERT INTO sanvel_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","no cet maa.m gave.sayi.syatha kintuudde\"sa.m na praapsyatha e.sa kod.r\"sa.m vaakyamida.m vadati? ");
INSERT INTO sanvel_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya carame.ahani arthaat pradhaanadine yii\"surutti.s.than uccai.hkaaram aahvayan uditavaan yadi ka\"scit t.r.saartto bhavati tarhi mamaantikam aagatya pivatu| ");
INSERT INTO sanvel_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ya.h ka\"scinmayi vi\"svasiti dharmmagranthasya vacanaanusaare.na tasyaabhyantarato.am.rtatoyasya srotaa.msi nirgami.syanti| ");
INSERT INTO sanvel_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ye tasmin vi\"svasanti ta aatmaana.m praapsyantiityarthe sa ida.m vaakya.m vyaah.rtavaan etatkaala.m yaavad yii\"su rvibhava.m na praaptastasmaat pavitra aatmaa naadiiyata| ");
INSERT INTO sanvel_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","etaa.m vaa.nii.m \"srutvaa bahavo lokaa avadan ayameva ni\"scita.m sa bhavi.syadvaadii| ");
INSERT INTO sanvel_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kecid akathayan e.saeva sobhi.siktta.h kintu kecid avadan sobhi.siktta.h ki.m gaaliil prade\"se jani.syate? ");
INSERT INTO sanvel_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sobhi.siktto daayuudo va.m\"se daayuudo janmasthaane baitlehami pattane jani.syate dharmmagranthe kimittha.m likhita.m naasti? ");
INSERT INTO sanvel_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ittha.m tasmin lokaanaa.m bhinnavaakyataa jaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalokaasta.m dharttum aicchan tathaapi tadvapu.si kopi hasta.m naarpayat| ");
INSERT INTO sanvel_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantara.m paadaatiga.ne pradhaanayaajakaanaa.m phiruu\"sinaa nca samiipamaagatavati te taan ap.rcchan kuto hetosta.m naanayata? ");
INSERT INTO sanvel_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadaa padaataya.h pratyavadan sa maanava iva kopi kadaapi nopaadi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tata.h phiruu\"sina.h praavocan yuuyamapi kimabhraami.s.ta? ");
INSERT INTO sanvel_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatiinaa.m phiruu\"sinaa nca kopi ki.m tasmin vya\"svasiit? ");
INSERT INTO sanvel_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ye \"saastra.m na jaananti ta ime.adhamalokaaeva \"saapagrastaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadaa nikadiimanaamaa te.saameko ya.h k.sa.nadaayaa.m yii\"so.h sannidhim agaat sa ukttavaan ");
INSERT INTO sanvel_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vaakye na \"srute karmma.ni ca na vidite .asmaaka.m vyavasthaa ki.m ka ncana manuja.m do.siikaroti? ");
INSERT INTO sanvel_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tataste vyaaharan tvamapi ki.m gaaliiliiyaloka.h? vivicya pa\"sya galiili kopi bhavi.syadvaadii notpadyate| ");
INSERT INTO sanvel_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tata.h para.m sarvve sva.m sva.m g.rha.m gataa.h kintu yii\"su rjaitunanaamaana.m \"siloccaya.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyuu.se yii\"su.h panarmandiram aagacchat ");
INSERT INTO sanvel_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tata.h sarvve.su loke.su tasya samiipa aagate.su sa upavi\"sya taan upade.s.tum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadaa adhyaapakaa.h phiruu\"sina nca vyabhicaarakarmma.ni dh.rta.m striyamekaam aaniya sarvve.saa.m madhye sthaapayitvaa vyaaharan ");
INSERT INTO sanvel_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","he guro yo.sitam imaa.m vyabhicaarakarmma kurvvaa.naa.m lokaa dh.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","etaad.r\"salokaa.h paa.saa.naaghaatena hantavyaa iti vidhirmuusaavyavasthaagranthe likhitosti kintu bhavaan kimaadi\"sati? ");
INSERT INTO sanvel_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","te tamapavaditu.m pariik.saabhipraaye.na vaakyamidam ap.rcchan kintu sa prahviibhuuya bhuumaava\"ngalyaa lekhitum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastai.h puna.h puna.h p.r.s.ta utthaaya kathitavaan yu.smaaka.m madhye yo jano niraparaadhii saeva prathamam enaa.m paa.saa.nenaahantu| ");
INSERT INTO sanvel_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","pa\"scaat sa puna\"sca prahviibhuuya bhuumau lekhitum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","taa.m katha.m \"srutvaa te svasvamanasi prabodha.m praapya jye.s.thaanukrama.m ekaika\"sa.h sarvve bahiragacchan tato yii\"surekaakii tayakttobhavat madhyasthaane da.n.daayamaanaa saa yo.saa ca sthitaa| ");
INSERT INTO sanvel_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpa\"scaad yii\"surutthaaya taa.m vanitaa.m vinaa kamapyapara.m na vilokya p.r.s.tavaan he vaame tavaapavaadakaa.h kutra? kopi tvaa.m ki.m na da.n.dayati? ");
INSERT INTO sanvel_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","saavadat he maheccha kopi na tadaa yii\"suravocat naahamapi da.n.dayaami yaahi puna.h paapa.m maakaar.sii.h| ");
INSERT INTO sanvel_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tato yii\"su.h punarapi lokebhya ittha.m kathayitum aarabhata jagatoha.m jyoti.hsvaruupo ya.h ka\"scin matpa\"scaada gacchati sa timire na bhramitvaa jiivanaruupaa.m diipti.m praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tata.h phiruu\"sino.avaadi.sustva.m svaarthe svaya.m saak.sya.m dadaasi tasmaat tava saak.sya.m graahya.m na bhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadaa yii\"su.h pratyuditavaan yadyapi svaarthe.aha.m svaya.m saak.sya.m dadaami tathaapi mat saak.sya.m graahya.m yasmaad aha.m kuta aagatosmi kva yaami ca tadaha.m jaanaami kintu kuta aagatosmi kutra gacchaami ca tad yuuya.m na jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yuuya.m laukika.m vicaarayatha naaha.m kimapi vicaarayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vicaarayaami tarhi mama vicaaro grahiitavyo yatoham ekaakii naasmi prerayitaa pitaa mayaa saha vidyate| ");
INSERT INTO sanvel_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayo rjanayo.h saak.sya.m graha.niiya.m bhavatiiti yu.smaaka.m vyavasthaagranthe likhitamasti| ");
INSERT INTO sanvel_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","aha.m svaarthe svaya.m saak.sitva.m dadaami ya\"sca mama taato maa.m preritavaan sopi madarthe saak.sya.m dadaati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadaa te.ap.rcchan tava taata.h kutra? tato yii\"su.h pratyavaadiid yuuya.m maa.m na jaaniitha matpitara nca na jaaniitha yadi maam ak.saasyata tarhi mama taatamapyak.saasyata| ");
INSERT INTO sanvel_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yii\"su rmandira upadi\"sya bha.n.daagaare kathaa etaa akathayat tathaapi ta.m prati kopi kara.m nodatolayat| ");
INSERT INTO sanvel_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tata.h para.m yii\"su.h punaruditavaan adhunaaha.m gacchaami yuuya.m maa.m gave.sayi.syatha kintu nijai.h paapai rmari.syatha yat sthaanam aha.m yaasyaami tat sthaanam yuuya.m yaatu.m na \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadaa yihuudiiyaa.h praavocan kimayam aatmaghaata.m kari.syati? yato yat sthaanam aha.m yaasyaami tat sthaanam yuuya.m yaatu.m na \"sak.syatha iti vaakya.m braviiti| ");
INSERT INTO sanvel_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tato yii\"sustebhya.h kathitavaan yuuyam adha.hsthaaniiyaa lokaa aham uurdvvasthaaniiya.h yuuyam etajjagatsambandhiiyaa aham etajjagatsambandhiiyo na| ");
INSERT INTO sanvel_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmaat kathitavaan yuuya.m nijai.h paapai rmari.syatha yatoha.m sa pumaan iti yadi na vi\"svasitha tarhi nijai.h paapai rmari.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadaa te .ap.rcchan kastva.m? tato yii\"su.h kathitavaan yu.smaaka.m sannidhau yasya prastaavam aa prathamaat karomi saeva puru.soha.m| ");
INSERT INTO sanvel_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yu.smaasu mayaa bahuvaakya.m vakttavya.m vicaarayitavya nca kintu matprerayitaa satyavaadii tasya samiipe yadaha.m \"srutavaan tadeva jagate kathayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janake vaakyamida.m prokttavaan iti te naabudhyanta| ");
INSERT INTO sanvel_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tato yii\"surakathayad yadaa manu.syaputram uurdvva utthaapayi.syatha tadaaha.m sa pumaan kevala.h svaya.m kimapi karmma na karomi kintu taato yathaa \"sik.sayati tadanusaare.na vaakyamida.m vadaamiiti ca yuuya.m j naatu.m \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprerayitaa pitaa maam ekaakina.m na tyajati sa mayaa saarddha.m ti.s.thati yatoha.m tadabhimata.m karmma sadaa karomi| ");
INSERT INTO sanvel_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadaa tasyaitaani vaakyaani \"srutvaa bahuvastaasmin vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ye yihuudiiyaa vya\"svasan yii\"sustebhyo.akathayat ");
INSERT INTO sanvel_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vaakye yadi yuuyam aasthaa.m kurutha tarhi mama \"si.syaa bhuutvaa satyatva.m j naasyatha tata.h satyatayaa yu.smaaka.m mok.so bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadaa te pratyavaadi.su.h vayam ibraahiimo va.m\"sa.h kadaapi kasyaapi daasaa na jaataastarhi yu.smaaka.m muktti rbhavi.syatiiti vaakya.m katha.m bravii.si? ");
INSERT INTO sanvel_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadaa yii\"su.h pratyavadad yu.smaanaha.m yathaarthatara.m vadaami ya.h paapa.m karoti sa paapasya daasa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","daasa\"sca nirantara.m nive\"sane na ti.s.thati kintu putro nirantara.m ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ata.h putro yadi yu.smaan mocayati tarhi nitaantameva mukttaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibraahiimo va.m\"sa ityaha.m jaanaami kintu mama kathaa yu.smaakam anta.hkara.ne.su sthaana.m na praapnuvanti tasmaaddheto rmaa.m hantum iihadhve| ");
INSERT INTO sanvel_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","aha.m svapitu.h samiipe yadapa\"sya.m tadeva kathayaami tathaa yuuyamapi svapitu.h samiipe yadapa\"syata tadeva kurudhve| ");
INSERT INTO sanvel_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadaa te pratyavocan ibraahiim asmaaka.m pitaa tato yii\"surakathayad yadi yuuyam ibraahiima.h santaanaa abhavi.syata tarhi ibraahiima aacaara.navad aacari.syata| ");
INSERT INTO sanvel_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ii\"svarasya mukhaat satya.m vaakya.m \"srutvaa yu.smaan j naapayaami yoha.m ta.m maa.m hantu.m ce.s.tadhve ibraahiim etaad.r\"sa.m karmma na cakaara| ");
INSERT INTO sanvel_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yuuya.m svasvapitu.h karmmaa.ni kurutha tadaa tairuktta.m na vaya.m jaarajaataa asmaakam ekaeva pitaasti sa eve\"svara.h ");
INSERT INTO sanvel_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tato yii\"sunaa kathitam ii\"svaro yadi yu.smaaka.m taatobhavi.syat tarhi yuuya.m mayi premaakari.syata yatoham ii\"svaraannirgatyaagatosmi svato naagatoha.m sa maa.m praahi.not| ");
INSERT INTO sanvel_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yuuya.m mama vaakyamida.m na budhyadhve kuta.h? yato yuuya.m mamopade\"sa.m so.dhu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yuuya.m \"saitaan pitu.h santaanaa etasmaad yu.smaaka.m piturabhilaa.sa.m puurayatha sa aa prathamaat naraghaatii tadanta.h satyatvasya le\"sopi naasti kaara.naadata.h sa satyataayaa.m naati.s.that sa yadaa m.r.saa kathayati tadaa nijasvabhaavaanusaare.naiva kathayati yato sa m.r.saabhaa.sii m.r.sotpaadaka\"sca| ");
INSERT INTO sanvel_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","aha.m tathyavaakya.m vadaami kaara.naadasmaad yuuya.m maa.m na pratiitha| ");
INSERT INTO sanvel_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi paapamastiiti pramaa.na.m yu.smaaka.m ko daatu.m \"saknoti? yadyaha.m tathyavaakya.m vadaami tarhi kuto maa.m na pratitha? ");
INSERT INTO sanvel_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ya.h ka\"scana ii\"svariiyo loka.h sa ii\"svariiyakathaayaa.m mano nidhatte yuuyam ii\"svariiyalokaa na bhavatha tannidaanaat tatra na manaa.msi nidhadve| ");
INSERT INTO sanvel_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadaa yihuudiiyaa.h pratyavaadi.su.h tvameka.h \"somiro.niiyo bhuutagrasta\"sca vaya.m kimida.m bhadra.m naavaadi.sma? ");
INSERT INTO sanvel_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tato yii\"su.h pratyavaadiit naaha.m bhuutagrasta.h kintu nijataata.m sammanye tasmaad yuuya.m maam apamanyadhve| ");
INSERT INTO sanvel_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","aha.m svasukhyaati.m na ce.s.te kintu ce.s.titaa vicaarayitaa caapara eka aaste| ");
INSERT INTO sanvel_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","aha.m yu.smabhyam atiiva yathaartha.m kathayaami yo naro madiiya.m vaaca.m manyate sa kadaacana nidhana.m na drak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihuudiiyaastamavadan tva.m bhuutagrasta itiidaaniim avai.sma| ibraahiim bhavi.syadvaadina nca sarvve m.rtaa.h kintu tva.m bhaa.sase yo naro mama bhaaratii.m g.rhlaati sa jaatu nidhaanaasvaada.m na lapsyate| ");
INSERT INTO sanvel_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tva.m kim asmaaka.m puurvvapuru.saad ibraahiimopi mahaan? yasmaat sopi m.rta.h bhavi.syadvaadinopi m.rtaa.h tva.m sva.m ka.m pumaa.msa.m manu.se? ");
INSERT INTO sanvel_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yii\"su.h pratyavocad yadyaha.m sva.m svaya.m sammanye tarhi mama tat sammanana.m kimapi na kintu mama taato ya.m yuuya.m sviiyam ii\"svara.m bhaa.sadhve saeva maa.m sammanute| ");
INSERT INTO sanvel_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yuuya.m ta.m naavagacchatha kintvaha.m tamavagacchaami ta.m naavagacchaamiiti vaakya.m yadi vadaami tarhi yuuyamiva m.r.saabhaa.sii bhavaami kintvaha.m tamavagacchaami tadaak.saamapi g.rhlaami| ");
INSERT INTO sanvel_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yu.smaaka.m puurvvapuru.sa ibraahiim mama samaya.m dra.s.tum atiivaavaa nchat tanniriik.syaanandacca| ");
INSERT INTO sanvel_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadaa yihuudiiyaa ap.rcchan tava vaya.h pa ncaa\"sadvatsaraa na tva.m kim ibraahiimam adraak.sii.h? ");
INSERT INTO sanvel_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yii\"su.h pratyavaadiid yu.smaanaha.m yathaarthatara.m vadaami ibraahiimo janmana.h puurvvakaalamaarabhyaaha.m vidye| ");
INSERT INTO sanvel_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadaa te paa.saa.naan uttolya tamaahantum udayacchan kintu yii\"su rgupto mantiraad bahirgatya te.saa.m madhyena prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tata.h para.m yii\"surgacchan maargamadhye janmaandha.m naram apa\"syat| ");
INSERT INTO sanvel_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tata.h \"si.syaastam ap.rcchan he guro naroya.m svapaapena vaa svapitraa.h paapenaandho.ajaayata? ");
INSERT INTO sanvel_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tata.h sa pratyuditavaan etasya vaasya pitro.h paapaad etaad.r\"sobhuuda iti nahi kintvanena yathe\"svarasya karmma prakaa\"syate taddhetoreva| ");
INSERT INTO sanvel_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dine ti.s.thati matprerayitu.h karmma mayaa karttavya.m yadaa kimapi karmma na kriyate taad.r\"sii ni\"saagacchati| ");
INSERT INTO sanvel_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","aha.m yaavatkaala.m jagati ti.s.thaami taavatkaala.m jagato jyoti.hsvaruuposmi| ");
INSERT INTO sanvel_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttaa bhuumau ni.s.thiiva.m nik.sipya tena pa\"nka.m k.rtavaan ");
INSERT INTO sanvel_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","pa\"scaat tatpa\"nkena tasyaandhasya netre pralipya tamityaadi\"sat gatvaa \"silohe .arthaat preritanaamni sarasi snaahi| tatondho gatvaa tatraasnaat tata.h prannacak.su rbhuutvaa vyaaghu.tyaagaat| ");
INSERT INTO sanvel_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","apara nca samiipavaasino lokaa ye ca ta.m puurvvamandham apa\"syan te bakttum aarabhanta yondhaloko vartmanyupavi\"syaabhik.sata sa evaaya.m jana.h ki.m na bhavati? ");
INSERT INTO sanvel_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kecidavadan sa eva kecidavocan taad.r\"so bhavati kintu sa svayamabraviit sa evaaha.m bhavaami| ");
INSERT INTO sanvel_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataeva te .ap.rcchan tva.m katha.m d.r.s.ti.m paaptavaan? ");
INSERT INTO sanvel_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tata.h sovadad yii\"sanaamaka eko jano mama nayane pa\"nkena pralipya ityaaj naapayat \"silohakaasaara.m gatvaa tatra snaahi| tatastatra gatvaa mayi snaate d.r.s.timaha.m labdhavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadaa te .avadan sa pumaan kutra? tenoktta.m naaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","apara.m tasmin puurvvaandhe jane phiruu\"sinaa.m nika.tam aaniite sati phiruu\"sinopi tamap.rcchan katha.m d.r.s.ti.m praaptosi? ");
INSERT INTO sanvel_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tata.h sa kathitavaan sa pa\"nkena mama netre .alimpat pa\"scaad snaatvaa d.r.s.timalabhe| ");
INSERT INTO sanvel_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yii\"su rvi\"sraamavaare karddama.m k.rtvaa tasya nayane prasanne.akarod itikaara.naat katipayaphiruu\"sino.avadan ");
INSERT INTO sanvel_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumaan ii\"svaraanna yata.h sa vi\"sraamavaara.m na manyate| tatonye kecit pratyavadan paapii pumaan kim etaad.r\"sam aa\"scaryya.m karmma karttu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ittha.m te.saa.m paraspara.m bhinnavaakyatvam abhavat| pa\"scaat te punarapi ta.m puurvvaandha.m maanu.sam apraak.su.h yo janastava cak.su.sii prasanne k.rtavaan tasmin tva.m ki.m vadasi? sa ukttavaan sa bhavi\"sadvaadii| ");
INSERT INTO sanvel_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa d.r.s.tim aaptavaan iti yihuudiiyaastasya d.r.s.ti.m praaptasya janasya pitro rmukhaad a\"srutvaa na pratyayan| ");
INSERT INTO sanvel_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataeva te taavap.rcchan yuvayo rya.m putra.m janmaandha.m vadatha.h sa kimaya.m? tarhiidaanii.m katha.m dra.s.tu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavocataam ayam aavayo.h putra aa janerandha\"sca tadapyaavaa.m jaaniiva.h ");
INSERT INTO sanvel_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunaa katha.m d.r.s.ti.m praaptavaan tadaavaa.m n jaaniiva.h kosya cak.su.sii prasanne k.rtavaan tadapi na jaaniiva e.sa vaya.hpraapta ena.m p.rcchata svakathaa.m svaya.m vak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihuudiiyaanaa.m bhayaat tasya pitarau vaakyamidam avadataa.m yata.h kopi manu.syo yadi yii\"sum abhi.sikta.m vadati tarhi sa bhajanag.rhaad duuriikaari.syate yihuudiiyaa iti mantra.naam akurvvan ");
INSERT INTO sanvel_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyaaharataam e.sa vaya.hpraapta ena.m p.rcchata| ");
INSERT INTO sanvel_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadaa te puna\"sca ta.m puurvvaandham aahuuya vyaaharan ii\"svarasya gu.naan vada e.sa manu.sya.h paapiiti vaya.m jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadaa sa ukttavaan sa paapii na veti naaha.m jaane puurvaamandha aasamaham adhunaa pa\"syaamiiti maatra.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","te punarap.rcchan sa tvaa.m prati kimakarot? katha.m netre prasanne .akarot? ");
INSERT INTO sanvel_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tata.h sovaadiid ekak.rtvokathaya.m yuuya.m na \"s.r.nutha tarhi kuta.h puna.h \"srotum icchatha? yuuyamapi ki.m tasya \"si.syaa bhavitum icchatha? ");
INSERT INTO sanvel_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadaa te ta.m tirask.rtya vyaaharan tva.m tasya \"si.syo vaya.m muusaa.h \"si.syaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","muusaavaktre.ne\"svaro jagaada tajjaaniima.h kintve.sa kutratyaloka iti na jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sovadad e.sa mama locane prasanne .akarot tathaapi kutratyaloka iti yuuya.m na jaaniitha etad aa\"scaryya.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ii\"svara.h paapinaa.m kathaa.m na \"s.r.noti kintu yo janastasmin bhakti.m k.rtvaa tadi.s.takriyaa.m karoti tasyaiva kathaa.m \"s.r.noti etad vaya.m jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kopi manu.syo janmaandhaaya cak.su.sii adadaat jagadaarambhaad etaad.r\"sii.m kathaa.m kopi kadaapi naa\"s.r.not| ");
INSERT INTO sanvel_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmaad e.sa manu.syo yadii\"svaraannaajaayata tarhi ki ncidapiid.r\"sa.m karmma karttu.m naa\"saknot| ");
INSERT INTO sanvel_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","te vyaaharan tva.m paapaad ajaayathaa.h kimasmaan tva.m \"sik.sayasi? pa\"scaatte ta.m bahirakurvvan| ");
INSERT INTO sanvel_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantara.m yihuudiiyai.h sa bahirakriyata yii\"suriti vaarttaa.m \"srutvaa ta.m saak.saat praapya p.r.s.tavaan ii\"svarasya putre tva.m vi\"svasi.si? ");
INSERT INTO sanvel_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadaa sa pratyavocat he prabho sa ko yat tasminnaha.m vi\"svasimi? ");
INSERT INTO sanvel_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tato yii\"su.h kathitavaan tva.m ta.m d.r.s.tavaan tvayaa saaka.m ya.h katha.m kathayati saeva sa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadaa he prabho vi\"svasimiityuktvaa sa ta.m pra.naamat| ");
INSERT INTO sanvel_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","pa\"scaad yii\"su.h kathitavaan nayanahiinaa nayanaani praapnuvanti nayanavanta\"scaandhaa bhavantiityabhipraaye.na jagadaaham aagaccham| ");
INSERT INTO sanvel_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","etat \"srutvaa nika.tasthaa.h katipayaa.h phiruu\"sino vyaaharan vayamapi kimandhaa.h? ");
INSERT INTO sanvel_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadaa yii\"suravaadiid yadyandhaa abhavata tarhi paapaani naati.s.than kintu pa\"syaamiiti vaakyavadanaad yu.smaaka.m paapaani ti.s.thanti| ");
INSERT INTO sanvel_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","aha.m yu.smaanatiyathaartha.m vadaami, yo jano dvaare.na na pravi\"sya kenaapyanyena me.sag.rha.m pravi\"sati sa eva steno dasyu\"sca| ");
INSERT INTO sanvel_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yo dvaare.na pravi\"sati sa eva me.sapaalaka.h| ");
INSERT INTO sanvel_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvaarikastasmai dvaara.m mocayati me.saga.na\"sca tasya vaakya.m \"s.r.noti sa nijaan me.saan svasvanaamnaahuuya bahi.h k.rtvaa nayati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathaa nijaan me.saan bahi.h k.rtvaa svaya.m te.saam agre gacchati, tato me.saastasya \"sabda.m budhyante, tasmaat tasya pa\"scaad vrajanti| ");
INSERT INTO sanvel_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya \"sabda.m na budhyante tasmaat tasya pa\"scaad vraji.syanti vara.m tasya samiipaat palaayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yii\"sustebhya imaa.m d.r.s.taantakathaam akathayat kintu tena kathitakathaayaastaatparyya.m te naabudhyanta| ");
INSERT INTO sanvel_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ato yii\"su.h punarakathayat, yu.smaanaaha.m yathaarthatara.m vyaaharaami, me.sag.rhasya dvaaram ahameva| ");
INSERT INTO sanvel_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayaa na pravi\"sya ya aagacchan te stenaa dasyava\"sca kintu me.saaste.saa.m kathaa naa\"s.r.nvan| ");
INSERT INTO sanvel_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahameva dvaarasvaruupa.h, mayaa ya.h ka\"scita pravi\"sati sa rak.saa.m praapsyati tathaa bahiranta\"sca gamanaagamane k.rtvaa cara.nasthaana.m praapsyati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yo janastena.h sa kevala.m stainyabadhavinaa\"saan karttumeva samaayaati kintvaham aayu rdaatum arthaat baahuulyena tadeva daatum aagaccham| ");
INSERT INTO sanvel_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahameva satyame.sapaalako yastu satyo me.sapaalaka.h sa me.saartha.m praa.natyaaga.m karoti; ");
INSERT INTO sanvel_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yo jano me.sapaalako na, arthaad yasya me.saa nijaa na bhavanti, ya etaad.r\"so vaitanika.h sa v.rkam aagacchanta.m d.r.s.tvaa mejavraja.m vihaaya palaayate, tasmaad v.rkasta.m vraja.m dh.rtvaa vikirati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanika.h palaayate yata.h sa vetanaarthii me.saartha.m na cintayati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahameva satyo me.sapaalaka.h, pitaa maa.m yathaa jaanaati, aha nca yathaa pitara.m jaanaami, ");
INSERT INTO sanvel_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathaa nijaan me.saanapi jaanaami, me.saa\"sca maa.m jaanaanti, aha nca me.saartha.m praa.natyaaga.m karomi| ");
INSERT INTO sanvel_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","apara nca etad g.rhiiya me.sebhyo bhinnaa api me.saa mama santi te sakalaa aanayitavyaa.h; te mama \"sabda.m \"sro.syanti tata eko vraja eko rak.sako bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","praa.naanaha.m tyaktvaa puna.h praa.naan grahii.syaami, tasmaat pitaa mayi sneha.m karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ka\"scijjano mama praa.naan hantu.m na \"saknoti kintu svaya.m taan samarpayaami taan samarpayitu.m punargrahiitu nca mama \"saktiraaste bhaaramima.m svapitu.h sakaa\"saat praaptoham| ");
INSERT INTO sanvel_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmaadupade\"saat puna\"sca yihuudiiyaanaa.m madhye bhinnavaakyataa jaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tato bahavo vyaaharan e.sa bhuutagrasta unmatta\"sca, kuta etasya kathaa.m \"s.r.nutha? ");
INSERT INTO sanvel_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kecid avadan etasya kathaa bhuutagrastasya kathaavanna bhavanti, bhuuta.h kim andhaaya cak.su.sii daatu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","\"siitakaale yiruu\"saalami mandirotsargaparvva.nyupasthite ");
INSERT INTO sanvel_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yii\"su.h sulemaano ni.hsaare.na gamanaagamane karoti, ");
INSERT INTO sanvel_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","etasmin samaye yihuudiiyaasta.m ve.s.tayitvaa vyaaharan kati kaalaan asmaaka.m vicikitsaa.m sthaapayi.syaami? yadyabhi.sikto bhavati tarhi tat spa.s.ta.m vada| ");
INSERT INTO sanvel_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadaa yii\"su.h pratyavadad aham acakatha.m kintu yuuya.m na pratiitha, nijapitu rnaamnaa yaa.m yaa.m kriyaa.m karomi saa kriyaiva mama saak.sisvaruupaa| ");
INSERT INTO sanvel_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvaha.m puurvvamakathaya.m yuuya.m mama me.saa na bhavatha, kaara.naadasmaan na vi\"svasitha| ");
INSERT INTO sanvel_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama me.saa mama \"sabda.m \"s.r.nvanti taanaha.m jaanaami te ca mama pa\"scaad gacchanti| ");
INSERT INTO sanvel_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","aha.m tebhyo.anantaayu rdadaami, te kadaapi na na.mk.syanti kopi mama karaat taan harttu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yo mama pitaa taan mahya.m dattavaan sa sarvvasmaat mahaan, kopi mama pitu.h karaat taan harttu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","aha.m pitaa ca dvayorekatvam| ");
INSERT INTO sanvel_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tato yihuudiiyaa.h punarapi ta.m hantu.m paa.saa.naan udatolayan| ");
INSERT INTO sanvel_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yii\"su.h kathitavaan pitu.h sakaa\"saad bahuunyuttamakarmmaa.ni yu.smaaka.m praakaa\"saya.m te.saa.m kasya karmma.na.h kaara.naan maa.m paa.saa.nairaahantum udyataa.h stha? ");
INSERT INTO sanvel_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihuudiiyaa.h pratyavadan pra\"sastakarmmaheto rna kintu tva.m maanu.sa.h svamii\"svaram uktve\"svara.m nindasi kaara.naadasmaat tvaa.m paa.saa.nairhanma.h| ");
INSERT INTO sanvel_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadaa yii\"su.h pratyuktavaan mayaa kathita.m yuuyam ii\"svaraa etadvacana.m yu.smaaka.m \"saastre likhita.m naasti ki.m? ");
INSERT INTO sanvel_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmaad ye.saam udde\"se ii\"svarasya kathaa kathitaa te yadii\"svaraga.naa ucyante dharmmagranthasyaapyanyathaa bhavitu.m na \"sakya.m, ");
INSERT INTO sanvel_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyaaham ii\"svarasya putra iti vaakyasya kathanaat yuuya.m pitraabhi.sikta.m jagati prerita nca pumaa.msa.m katham ii\"svaranindaka.m vaadaya? ");
INSERT INTO sanvel_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyaha.m pitu.h karmma na karomi tarhi maa.m na pratiita; ");
INSERT INTO sanvel_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karomi tarhi mayi yu.smaabhi.h pratyaye na k.rte.api kaaryye pratyaya.h kriyataa.m, tato mayi pitaastiiti pitaryyaham asmiiti ca k.saatvaa vi\"svasi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadaa te punarapi ta.m dharttum ace.s.tanta kintu sa te.saa.m karebhyo nistiiryya ");
INSERT INTO sanvel_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyaasta.te yatra purvva.m yohan amajjayat tatraagatya nyavasat| ");
INSERT INTO sanvel_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tato bahavo lokaastatsamiipam aagatya vyaaharan yohan kimapyaa\"scaryya.m karmma naakarot kintvasmin manu.sye yaa ya.h kathaa akathayat taa.h sarvvaa.h satyaa.h; ");
INSERT INTO sanvel_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra ca bahavo lokaastasmin vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantara.m mariyam tasyaa bhaginii marthaa ca yasmin vaithaniiyaagraame vasatastasmin graame iliyaasar naamaa pii.dita eka aasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yaa mariyam prabhu.m sugandhitelaina marddayitvaa svake\"saistasya cara.nau samamaarjat tasyaa bhraataa sa iliyaasar rogii| ");
INSERT INTO sanvel_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","apara nca he prabho bhavaan yasmin priiyate sa eva pii.ditostiiti kathaa.m kathayitvaa tasya bhaginyau pre.sitavatyau| ");
INSERT INTO sanvel_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadaa yii\"surimaa.m vaarttaa.m \"srutvaakathayata pii.deya.m mara.naartha.m na kintvii\"svarasya mahimaartham ii\"svaraputrasya mahimaprakaa\"saartha nca jaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yii\"su ryadyapimarthaayaa.m tadbhaginyaam iliyaasari caapriiyata, ");
INSERT INTO sanvel_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathaapi iliyaasara.h pii.daayaa.h katha.m \"srutvaa yatra aasiit tatraiva dinadvayamati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tata.h param sa \"si.syaanakathayad vaya.m puna ryihuudiiyaprade\"sa.m yaama.h| ");
INSERT INTO sanvel_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tataste pratyavadan, he guro svalpadinaani gataani yihuudiiyaastvaa.m paa.saa.nai rhantum udyataastathaapi ki.m punastatra yaasyasi? ");
INSERT INTO sanvel_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yii\"su.h pratyavadat, ekasmin dine ki.m dvaada\"sagha.tikaa na bhavanti? kopi divaa gacchan na skhalati yata.h sa etajjagato diipti.m praapnoti| ");
INSERT INTO sanvel_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu raatrau gacchan skhalati yato hetostatra diipti rnaasti| ");
INSERT INTO sanvel_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imaa.m kathaa.m kathayitvaa sa taanavadad, asmaaka.m bandhu.h iliyaasar nidritobhuud idaanii.m ta.m nidraato jaagarayitu.m gacchaami| ");
INSERT INTO sanvel_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yii\"su rm.rtau kathaamimaa.m kathitavaan kintu vi\"sraamaartha.m nidraayaa.m kathitavaan iti j naatvaa \"si.syaa akathayan, ");
INSERT INTO sanvel_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","he guro sa yadi nidraati tarhi bhadrameva| ");
INSERT INTO sanvel_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadaa yii\"su.h spa.s.ta.m taan vyaaharat, iliyaasar amriyata; ");
INSERT INTO sanvel_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yuuya.m yathaa pratiitha tadarthamaha.m tatra na sthitavaan ityasmaad yu.smannimittam aahlaaditoha.m, tathaapi tasya samiipe yaama| ");
INSERT INTO sanvel_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadaa thomaa ya.m diduma.m vadanti sa sa\"ngina.h \"si.syaan avadad vayamapi gatvaa tena saarddha.m mriyaamahai| ");
INSERT INTO sanvel_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yii\"sustatropasthaaya iliyaasara.h \"sma\"saane sthaapanaat catvaari dinaani gataaniiti vaarttaa.m \"srutavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithaniiyaa yiruu\"saalama.h samiipasthaa kro\"saikamaatraantaritaa; ");
INSERT INTO sanvel_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmaad bahavo yihuudiiyaa marthaa.m mariyama nca bhyaat.r\"sokaapannaa.m saantvayitu.m tayo.h samiipam aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthaa yii\"soraagamanavaartaa.m \"srutvaiva ta.m saak.saad akarot kintu mariyam geha upavi\"sya sthitaa| ");
INSERT INTO sanvel_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadaa marthaa yii\"sumavaadat, he prabho yadi bhavaan atraasthaasyat tarhi mama bhraataa naamari.syat| ");
INSERT INTO sanvel_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidaaniimapi yad ii\"svare praarthayi.syate ii\"svarastad daasyatiiti jaane.aha.m| ");
INSERT INTO sanvel_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yii\"suravaadiit tava bhraataa samutthaasyati| ");
INSERT INTO sanvel_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthaa vyaaharat \"se.sadivase sa utthaanasamaye protthaasyatiiti jaane.aha.m| ");
INSERT INTO sanvel_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadaa yii\"su.h kathitavaan ahameva utthaapayitaa jiivayitaa ca ya.h ka\"scana mayi vi\"svasiti sa m.rtvaapi jiivi.syati; ");
INSERT INTO sanvel_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ya.h ka\"scana ca jiivan mayi vi\"svasiti sa kadaapi na mari.syati, asyaa.m kathaayaa.m ki.m vi\"svasi.si? ");
INSERT INTO sanvel_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","saavadat prabho yasyaavatara.naapek.saasti bhavaan saevaabhi.siktta ii\"svaraputra iti vi\"svasimi| ");
INSERT INTO sanvel_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathaa.m kathayitvaa saa gatvaa svaa.m bhaginii.m mariyama.m guptamaahuuya vyaaharat gururupati.s.thati tvaamaahuuyati ca| ");
INSERT INTO sanvel_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathaamimaa.m \"srutvaa saa tuur.nam utthaaya tasya samiipam agacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yii\"su rgraamamadhya.m na pravi\"sya yatra marthaa ta.m saak.saad akarot tatra sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ye yihuudiiyaa mariyamaa saaka.m g.rhe ti.s.thantastaam asaantvayana te taa.m k.sipram utthaaya gacchanti.m vilokya vyaaharan, sa \"sma\"saane roditu.m yaati, ityuktvaa te tasyaa.h pa\"scaad agacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yii\"surati.s.that tatra mariyam upasthaaya ta.m d.r.s.tvaa tasya cara.nayo.h patitvaa vyaaharat he prabho yadi bhavaan atraasthaasyat tarhi mama bhraataa naamari.syat| ");
INSERT INTO sanvel_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yii\"sustaa.m tasyaa.h sa\"ngino yihuudiiyaa.m\"sca rudato vilokya \"sokaartta.h san diirgha.m ni\"svasya kathitavaan ta.m kutraasthaapayata? ");
INSERT INTO sanvel_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","te vyaaharan, he prabho bhavaan aagatya pa\"syatu| ");
INSERT INTO sanvel_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yii\"sunaa krandita.m| ");
INSERT INTO sanvel_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataeva yihuudiiyaa avadan, pa\"syataaya.m tasmin kid.rg apriyata| ");
INSERT INTO sanvel_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","te.saa.m kecid avadan yondhaaya cak.su.sii dattavaan sa kim asya m.rtyu.m nivaarayitu.m naa\"saknot? ");
INSERT INTO sanvel_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tato yii\"su.h punarantardiirgha.m ni\"svasya \"sma\"saanaantikam agacchat| tat \"sma\"saanam eka.m gahvara.m tanmukhe paa.saa.na eka aasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadaa yii\"suravadad ena.m paa.saa.nam apasaarayata, tata.h pramiitasya bhaginii marthaavadat prabho, adhunaa tatra durgandho jaata.h, yatodya catvaari dinaani \"sma\"saane sa ti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadaa yii\"suravaadiit, yadi vi\"svasi.si tarhii\"svarasya mahimaprakaa\"sa.m drak.syasi kathaamimaa.m ki.m tubhya.m naakathaya.m? ");
INSERT INTO sanvel_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadaa m.rtasya \"sma\"saanaat paa.saa.no.apasaarite yii\"suruurdvva.m pa\"syan akathayat, he pita rmama nevesanam a\"s.r.no.h kaara.naadasmaat tvaa.m dhanya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tva.m satata.m \"s.r.no.si tadapyaha.m jaanaami, kintu tva.m maa.m yat prairayastad yathaasmin sthaane sthitaa lokaa vi\"svasanti tadartham ida.m vaakya.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imaa.m kathaa.m kathayitvaa sa proccairaahvayat, he iliyaasar bahiraagaccha| ");
INSERT INTO sanvel_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tata.h sa pramiita.h \"sma\"saanavastrai rbaddhahastapaado gaatramaarjanavaasasaa baddhamukha\"sca bahiraagacchat| yii\"suruditavaan bandhanaani mocayitvaa tyajataina.m| ");
INSERT INTO sanvel_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyama.h samiipam aagataa ye yihuudiiyalokaastadaa yii\"soretat karmmaapa\"syan te.saa.m bahavo vya\"svasan, ");
INSERT INTO sanvel_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kecidanye phiruu\"sinaa.m samiipa.m gatvaa yii\"soretasya karmma.no vaarttaam avadan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tata.h para.m pradhaanayaajakaa.h phiruu\"sinaa\"sca sabhaa.m k.rtvaa vyaaharan vaya.m ki.m kurmma.h? e.sa maanavo bahuunyaa\"scaryyakarmmaa.ni karoti| ");
INSERT INTO sanvel_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadiid.r\"sa.m karmma karttu.m na vaarayaamastarhi sarvve lokaastasmin vi\"svasi.syanti romilokaa\"scaagatyaasmaakam anayaa raajadhaanyaa saarddha.m raajyam aachetsyanti| ");
INSERT INTO sanvel_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadaa te.saa.m kiyaphaanaamaa yastasmin vatsare mahaayaajakapade nyayujyata sa pratyavadad yuuya.m kimapi na jaaniitha; ");
INSERT INTO sanvel_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagrade\"sasya vinaa\"satopi sarvvalokaartham ekasya janasya mara.nam asmaaka.m ma\"ngalahetukam etasya vivecanaamapi na kurutha| ");
INSERT INTO sanvel_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","etaa.m kathaa.m sa nijabuddhyaa vyaaharad iti na, ");
INSERT INTO sanvel_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yii\"suustadde\"siiyaanaa.m kaara.naat praa.naan tyak.syati, di\"si di\"si vikiir.naan ii\"svarasya santaanaan sa.mg.rhyaikajaati.m kari.syati ca, tasmin vatsare kiyaphaa mahaayaajakatvapade niyukta.h san ida.m bhavi.syadvaakya.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamaarabhya te katha.m ta.m hantu.m \"saknuvantiiti mantra.naa.m karttu.m praarebhire| ");
INSERT INTO sanvel_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataeva yihuudiiyaanaa.m madhye yii\"su.h saprakaa\"sa.m gamanaagamane ak.rtvaa tasmaad gatvaa praantarasya samiipasthaayiprade\"sasyephraayim naamni nagare \"si.syai.h saaka.m kaala.m yaapayitu.m praarebhe| ");
INSERT INTO sanvel_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantara.m yihuudiiyaanaa.m nistaarotsave nika.tavarttini sati tadutsavaat puurvva.m svaan \"suciin karttu.m bahavo janaa graamebhyo yiruu\"saalam nagaram aagacchan, ");
INSERT INTO sanvel_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yii\"soranve.sa.na.m k.rtvaa mandire da.n.daayamaanaa.h santa.h paraspara.m vyaaharan, yu.smaaka.m kiid.r\"so bodho jaayate? sa kim utsave.asmin atraagami.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa ca kutraasti yadyetat ka\"scid vetti tarhi dar\"sayatu pradhaanayaajakaa.h phiruu\"sina\"sca ta.m dharttu.m puurvvam imaam aaj naa.m praacaarayan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistaarotsavaat puurvva.m dina.sa.tke sthite yii\"su rya.m pramiitam iliyaasara.m \"sma\"saanaad udasthaaparat tasya nivaasasthaana.m baithaniyaagraamam aagacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadartha.m rajanyaa.m bhojye k.rte marthaa paryyave.sayad iliyaasar ca tasya sa\"ngibhi.h saarddha.m bhojanaasana upaavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadaa mariyam arddhase.taka.m bahumuulya.m ja.taamaa.msiiya.m tailam aaniiya yii\"so\"scara.nayo rmarddayitvaa nijake\"sa rmaar.s.tum aarabhata; tadaa tailasya parimalena g.rham aamoditam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ya.h \"simona.h putra ri.skariyotiiyo yihuudaanaamaa yii\"su.m parakare.su samarpayi.syati sa \"si.syastadaa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","etattaila.m tribhi.h \"satai rmudraapadai rvikriita.m sad daridrebhya.h kuto naadiiyata? ");
INSERT INTO sanvel_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralokaartham acintayad iti na, kintu sa caura eva.m tannika.te mudraasampu.takasthityaa tanmadhye yadati.s.that tadapaaharat tasmaat kaara.naad imaa.m kathaamakathayat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadaa yii\"surakathayad enaa.m maa vaaraya saa mama \"sma\"saanasthaapanadinaartha.m tadarak.sayat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridraa yu.smaaka.m sannidhau sarvvadaa ti.s.thanti kintvaha.m sarvvadaa yu.smaaka.m sannidhau na ti.s.thaami| ");
INSERT INTO sanvel_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tata.h para.m yii\"sustatraastiiti vaarttaa.m \"srutvaa bahavo yihuudiiyaasta.m \"sma\"saanaadutthaapitam iliyaasara nca dra.s.tu.m tat sthaanam aagacchana| ");
INSERT INTO sanvel_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadaa pradhaanayaajakaastam iliyaasaramapi sa.mharttum amantrayan ; ");
INSERT INTO sanvel_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastena bahavo yihuudiiyaa gatvaa yii\"sau vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantara.m yii\"su ryiruu\"saalam nagaram aagacchatiiti vaarttaa.m \"srutvaa pare.ahani utsavaagataa bahavo lokaa.h ");
INSERT INTO sanvel_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjuurapatraadyaaniiya ta.m saak.saat karttu.m bahiraagatya jaya jayeti vaaca.m proccai rvaktum aarabhanta, israayelo yo raajaa parame\"svarasya naamnaagacchati sa dhanya.h| ");
INSERT INTO sanvel_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadaa \"he siyona.h kanye maa bhai.sii.h pa\"syaaya.m tava raajaa garddabha\"saavakam aaruhyaagacchati\" ");
INSERT INTO sanvel_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti \"saastriiyavacanaanusaare.na yii\"sureka.m yuvagarddabha.m praapya taduparyyaarohat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyaa.h gha.tanaayaastaatparyya.m \"si.syaa.h prathama.m naabudhyanta, kintu yii\"sau mahimaana.m praapte sati vaakyamida.m tasmina akathyata lokaa\"sca tampratiittham akurvvan iti te sm.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyaasara.m \"sma\"saanaad aagantum aahvatavaan \"sma\"saanaa nca udasthaapayad ye ye lokaastatkarmya saak.saad apa\"syan te pramaa.na.m daatum aarabhanta| ");
INSERT INTO sanvel_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa etaad.r\"sam adbhuta.m karmmakarot tasya jana\"srute rlokaasta.m saak.saat karttum aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tata.h phiruu\"sina.h paraspara.m vaktum aarabhanta yu.smaaka.m sarvvaa\"sce.s.taa v.rthaa jaataa.h, iti ki.m yuuya.m na budhyadhve? pa\"syata sarvve lokaastasya pa\"scaadvarttinobhavan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajana.m karttum utsavaagataanaa.m lokaanaa.m katipayaa janaa anyade\"siiyaa aasan , ");
INSERT INTO sanvel_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","te gaaliiliiyabaitsaidaanivaasina.h philipasya samiipam aagatya vyaaharan he maheccha vaya.m yii\"su.m dra.s.tum icchaama.h| ");
INSERT INTO sanvel_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tata.h philipo gatvaa aandriyam avadat pa\"scaad aandriyaphilipau yii\"save vaarttaam akathayataa.m| ");
INSERT INTO sanvel_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadaa yii\"su.h pratyuditavaan maanavasutasya mahimapraaptisamaya upasthita.h| ");
INSERT INTO sanvel_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","aha.m yu.smaanatiyathaartha.m vadaami, dhaanyabiija.m m.rttikaayaa.m patitvaa yadi na m.ryate tarhyekaakii ti.s.thati kintu yadi m.ryate tarhi bahugu.na.m phala.m phalati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yo janeा nijapraa.naan priyaan jaanaati sa taan haarayi.syati kintu yeा jana ihaloke nijapraa.naan apriyaan jaanaati seाnantaayu.h praaptu.m taan rak.si.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ka\"scid yadi mama sevako bhavitu.m vaa nchati tarhi sa mama pa\"scaadgaamii bhavatu, tasmaad aha.m yatra ti.s.thaami mama sevakeाpi tatra sthaasyati; yo jano maa.m sevate mama pitaapi ta.m samma.msyate| ");
INSERT INTO sanvel_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","saamprata.m mama praa.naa vyaakulaa bhavanti, tasmaad he pitara etasmaat samayaan maa.m rak.sa, ityaha.m ki.m praarthayi.sye? kintvaham etatsamayaartham avatiir.navaan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","he pita: svanaamno mahimaana.m prakaa\"saya; tanaiva svanaamno mahimaanam aha.m praakaa\"saya.m punarapi prakaa\"sayi.syaami, e.saa gaga.niiyaa vaa.nii tasmin samaye.ajaayata| ");
INSERT INTO sanvel_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","tac\"srutvaa samiipasthalokaanaa.m kecid avadan megho.agarjiit, kecid avadan svargiiyaduuto.anena saha kathaamacakathat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadaa yii\"su.h pratyavaadiit, madartha.m \"sabdoya.m naabhuut yu.smadarthamevaabhuut| ");
INSERT INTO sanvel_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunaa jagatosya vicaara: sampatsyate, adhunaasya jagata: patii raajyaat cyo.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaii p.rthivyaa uurdvve protthaapitosmi tarhi sarvvaan maanavaan svasamiipam aakar.si.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","katha.m tasya m.rti rbhavi.syati, etad bodhayitu.m sa imaa.m kathaam akathayat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadaa lokaa akathayan sobhi.sikta.h sarvvadaa ti.s.thatiiti vyavasthaagranthe \"srutam asmaabhi.h, tarhi manu.syaputra.h protthaapito bhavi.syatiiti vaakya.m katha.m vadasi? manu.syaputroya.m ka.h? ");
INSERT INTO sanvel_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadaa yii\"surakathaayad yu.smaabhi.h saarddham alpadinaani jyotiraaste, yathaa yu.smaan andhakaaro naacchaadayati tadartha.m yaavatkaala.m yu.smaabhi.h saarddha.m jyotisti.s.thati taavatkaala.m gacchata; yo jano.andhakaare gacchati sa kutra yaatiiti na jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataeva yaavatkaala.m yu.smaaka.m nika.te jyotiraaste taavatkaala.m jyotiiruupasantaanaa bhavitu.m jyoti.si vi\"svasita; imaa.m kathaa.m kathayitvaa yii\"su.h prasthaaya tebhya.h sva.m guptavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yii\"suste.saa.m samak.sam etaavadaa\"scaryyakarmmaa.ni k.rtavaan tathaapi te tasmin na vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataeva ka.h pratyeti susa.mvaada.m pare\"saasmat pracaarita.m? prakaa\"sate pare\"sasya hasta.h kasya ca sannidhau? yi\"sayiyabhavi.syadvaadinaa yadetad vaakyamukta.m tat saphalam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","te pratyetu.m naa\"sankuvan tasmin yi\"sayiyabhavi.syadvaadi punaravaadiid, ");
INSERT INTO sanvel_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadaa, \"te nayanai rna pa\"syanti buddhibhi\"sca na budhyante tai rmana.hsu parivarttite.su ca taanaha.m yathaa svasthaan na karomi tathaa sa te.saa.m locanaanyandhaani k.rtvaa te.saamanta.hkara.naani gaa.dhaani kari.syati|\" ");
INSERT INTO sanvel_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yi\"sayiyo yadaa yii\"so rmahimaana.m vilokya tasmin kathaamakathayat tadaa bhavi.syadvaakyam iid.r\"sa.m prakaa\"sayat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathaapyadhipatinaa.m bahavastasmin pratyaayan| kintu phiruu\"sinastaan bhajanag.rhaad duuriikurvvantiiti bhayaat te ta.m na sviik.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata ii\"svarasya pra\"sa.msaato maanavaanaa.m pra\"sa.msaayaa.m te.apriyanta| ");
INSERT INTO sanvel_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadaa yii\"suruccai.hkaaram akathayad yo jano mayi vi\"svasiti sa kevale mayi vi\"svasitiiti na, sa matprerake.api vi\"svasiti| ");
INSERT INTO sanvel_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yo jano maa.m pa\"syati sa matprerakamapi pa\"syati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yo jano maa.m pratyeti sa yathaandhakaare na ti.s.thati tadartham aha.m jyoti.hsvaruupo bhuutvaa jagatyasmin avatiir.navaan| ");
INSERT INTO sanvel_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathaa.m \"srutvaa yadi ka\"scin na vi\"svasiti tarhi tamaha.m do.si.na.m na karomi, yato heto rjagato janaanaa.m do.saan ni\"scitaan karttu.m naagatya taan paricaatum aagatosmi| ");
INSERT INTO sanvel_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ya.h ka\"scin maa.m na \"sraddhaaya mama katha.m na g.rhlaati, anyasta.m do.si.na.m kari.syati vastutastu yaa.m kathaamaham acakatha.m saa kathaa carame.anhi ta.m do.si.na.m kari.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yato hetoraha.m svata.h kimapi na kathayaami, ki.m ki.m mayaa kathayitavya.m ki.m samupade.s.tavya nca iti matprerayitaa pitaa maamaaj naapayat| ");
INSERT INTO sanvel_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya saaj naa anantaayurityaha.m jaanaami, ataevaaha.m yat kathayaami tat pitaa yathaaj naapayat tathaiva kathayaamyaham| ");
INSERT INTO sanvel_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistaarotsavasya ki ncitkaalaat puurvva.m p.rthivyaa.h pitu.h samiipagamanasya samaya.h sannikar.sobhuud iti j naatvaa yii\"suraaprathamaad ye.su jagatpravaasi.svaatmiiyaloke.sa prema karoti sma te.su \"se.sa.m yaavat prema k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitaa tasya haste sarvva.m samarpitavaan svayam ii\"svarasya samiipaad aagacchad ii\"svarasya samiipa.m yaasyati ca, sarvvaa.nyetaani j naatvaa rajanyaa.m bhojane sampuur.ne sati, ");
INSERT INTO sanvel_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadaa \"saitaan ta.m parahaste.su samarpayitu.m \"simona.h putrasya ii.skaariyotiyasya yihuudaa anta.hkara.ne kuprav.rtti.m samaarpayat, ");
INSERT INTO sanvel_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadaa yii\"su rbhojanaasanaad utthaaya gaatravastra.m mocayitvaa gaatramaarjanavastra.m g.rhiitvaa tena svaka.tim abadhnaat, ");
INSERT INTO sanvel_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","pa\"scaad ekapaatre jalam abhi.sicya \"si.syaa.naa.m paadaan prak.saalya tena ka.tibaddhagaatramaarjanavaasasaa maar.s.tu.m praarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tata.h \"simonpitarasya samiipamaagate sa uktavaan he prabho bhavaan ki.m mama paadau prak.saalayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yii\"suruditavaan aha.m yat karomi tat samprati na jaanaasi kintu pa\"scaaj j naasyasi| ");
INSERT INTO sanvel_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tata.h pitara.h kathitavaan bhavaan kadaapi mama paadau na prak.saalayi.syati| yii\"surakathayad yadi tvaa.m na prak.saalaye tarhi mayi tava kopya.m\"so naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadaa \"simonpitara.h kathitavaan he prabho tarhi kevalapaadau na, mama hastau \"sira\"sca prak.saalayatu| ");
INSERT INTO sanvel_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tato yii\"suravadad yo jano dhautastasya sarvvaa\"ngapari.sk.rtatvaat paadau vinaanyaa\"ngasya prak.saalanaapek.saa naasti| yuuya.m pari.sk.rtaa iti satya.m kintu na sarvve, ");
INSERT INTO sanvel_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yato yo janasta.m parakare.su samarpayi.syati ta.m sa j naatavaana; ataeva yuuya.m sarvve na pari.sk.rtaa imaa.m kathaa.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ittha.m yii\"suste.saa.m paadaan prak.saalya vastra.m paridhaayaasane samupavi\"sya kathitavaan aha.m yu.smaan prati ki.m karmmaakaar.sa.m jaaniitha? ");
INSERT INTO sanvel_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yuuya.m maa.m guru.m prabhu nca vadatha tat satyameva vadatha yatoha.m saeva bhavaami| ");
INSERT INTO sanvel_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyaha.m prabhu rguru\"sca san yu.smaaka.m paadaan prak.saalitavaan tarhi yu.smaakamapi paraspara.m paadaprak.saalanam ucitam| ");
INSERT INTO sanvel_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","aha.m yu.smaan prati yathaa vyavaahara.m yu.smaan tathaa vyavaharttum eka.m panthaana.m dar\"sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","aha.m yu.smaanatiyathaartha.m vadaami, prabho rdaaso na mahaan prerakaacca prerito na mahaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imaa.m kathaa.m viditvaa yadi tadanusaarata.h karmmaa.ni kurutha tarhi yuuya.m dhanyaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvve.su yu.smaasu kathaamimaa.m kathayaami iti na, ye mama manoniitaastaanaha.m jaanaami, kintu mama bhak.syaa.ni yo bhu\"nkte matpraa.napraatikuulyata.h| utthaapayati paadasya muula.m sa e.sa maanava.h|yadetad dharmmapustakasya vacana.m tadanusaare.naava\"sya.m gha.ti.syate| ");
INSERT INTO sanvel_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","aha.m sa jana ityatra yathaa yu.smaaka.m vi\"svaaso jaayate tadartha.m etaad.r\"sagha.tanaat puurvvam ahamidaanii.m yu.smabhyamakathayam| ");
INSERT INTO sanvel_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","aha.m yu.smaanatiiva yathaartha.m vadaami, mayaa prerita.m jana.m yo g.rhlaati sa maameva g.rhlaati ya\"sca maa.m g.rhlaati sa matpreraka.m g.rhlaati| ");
INSERT INTO sanvel_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","etaa.m kathaa.m kathayitvaa yii\"su rdu.hkhii san pramaa.na.m dattvaa kathitavaan aha.m yu.smaanatiyathaartha.m vadaami yu.smaakam eko jano maa.m parakare.su samarpayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tata.h sa kamuddi\"sya kathaametaa.m kathitavaan ityatra sandigdhaa.h \"si.syaa.h paraspara.m mukhamaalokayitu.m praarabhanta| ");
INSERT INTO sanvel_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samaye yii\"su ryasmin apriiyata sa \"si.syastasya vak.sa.hsthalam avaalambata| ");
INSERT INTO sanvel_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","\"simonpitarasta.m sa\"nketenaavadat, aya.m kamuddi\"sya kathaametaam kathayatiiti p.rccha| ");
INSERT INTO sanvel_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadaa sa yii\"so rvak.sa.hsthalam avalambya p.r.s.thavaan, he prabho sa jana.h ka.h? ");
INSERT INTO sanvel_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tato yii\"su.h pratyavadad ekakha.n.da.m puupa.m majjayitvaa yasmai daasyaami saeva sa.h; pa\"scaat puupakha.n.dameka.m majjayitvaa \"simona.h putraaya ii.skariyotiiyaaya yihuudai dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin datte sati \"saitaan tamaa\"srayat; tadaa yii\"sustam avadat tva.m yat kari.syasi tat k.sipra.m kuru| ");
INSERT INTO sanvel_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yenaa\"sayena taa.m kathaamakathaayat tam upavi.s.talokaanaa.m kopi naabudhyata; ");
INSERT INTO sanvel_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihuudaa.h samiipe mudraasampu.takasthite.h kecid ittham abudhyanta paarvva.naasaadanaartha.m kimapi dravya.m kretu.m vaa daridrebhya.h ki ncid vitaritu.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadaa puupakha.n.dagraha.naat para.m sa tuur.na.m bahiragacchat; raatri\"sca samupasyitaa| ");
INSERT INTO sanvel_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihuude bahirgate yii\"surakathayad idaanii.m maanavasutasya mahimaa prakaa\"sate tene\"svarasyaapi mahimaa prakaa\"sate| ");
INSERT INTO sanvel_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi tene\"svarasya mahimaa prakaa\"sate tarhii\"svaropi svena tasya mahimaana.m prakaa\"sayi.syati tuur.nameva prakaa\"sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","he vatsaa aha.m yu.smaabhi.h saarddha.m ki ncitkaalamaatram aase, tata.h para.m maa.m m.rgayi.syadhve kintvaha.m yatsthaana.m yaami tatsthaana.m yuuya.m gantu.m na \"sak.syatha, yaamimaa.m kathaa.m yihuudiiyebhya.h kathitavaan tathaadhunaa yu.smabhyamapi kathayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yuuya.m paraspara.m priiyadhvam aha.m yu.smaasu yathaa priiye yuuyamapi parasparam tathaiva priiyadhva.m, yu.smaan imaa.m naviinaam aaj naam aadi\"saami| ");
INSERT INTO sanvel_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tenaiva yadi paraspara.m priiyadhve tarhi lak.sa.nenaanena yuuya.m mama \"si.syaa iti sarvve j naatu.m \"sak.syanti| ");
INSERT INTO sanvel_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","\"simonapitara.h p.r.s.thavaan he prabho bhavaan kutra yaasyati? tato yii\"su.h pratyavadat, aha.m yatsthaana.m yaami tatsthaana.m saamprata.m mama pa\"scaad gantu.m na \"sakno.si kintu pa\"scaad gami.syasi| ");
INSERT INTO sanvel_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadaa pitara.h pratyuditavaan, he prabho saamprata.m kuto hetostava pa\"scaad gantu.m na \"saknomi? tvadartha.m praa.naan daatu.m \"saknomi| ");
INSERT INTO sanvel_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tato yii\"su.h pratyuktavaan mannimitta.m ki.m praa.naan daatu.m \"sakno.si? tvaamaha.m yathaartha.m vadaami, kukku.tarava.naat puurvva.m tva.m tri rmaam apahno.syase| ");
INSERT INTO sanvel_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manodu.hkhino maa bhuuta; ii\"svare vi\"svasita mayi ca vi\"svasita| ");
INSERT INTO sanvel_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu g.rhe bahuuni vaasasthaani santi no cet puurvva.m yu.smaan aj naapayi.sya.m yu.smadartha.m sthaana.m sajjayitu.m gacchaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvaaha.m yu.smannimitta.m sthaana.m sajjayaami tarhi panaraagatya yu.smaan svasamiipa.m ne.syaami, tato yatraaha.m ti.s.thaami tatra yuuyamapi sthaasyatha| ");
INSERT INTO sanvel_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","aha.m yatsthaana.m brajaami tatsthaana.m yuuya.m jaaniitha tasya panthaanamapi jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadaa thomaa avadat, he prabho bhavaan kutra yaati tadvaya.m na jaaniima.h, tarhi katha.m panthaana.m j naatu.m \"saknuma.h? ");
INSERT INTO sanvel_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yii\"surakathayad ahameva satyajiivanaruupapatho mayaa na gantaa kopi pitu.h samiipa.m gantu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi maam aj naasyata tarhi mama pitaramapyaj naasyata kintvadhunaatasta.m jaaniitha pa\"syatha ca| ");
INSERT INTO sanvel_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadaa philipa.h kathitavaan, he prabho pitara.m dar\"saya tasmaadasmaaka.m yathe.s.ta.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tato yii\"su.h pratyaavaadiit, he philipa yu.smaabhi.h saarddham etaavaddinaani sthitamapi maa.m ki.m na pratyabhijaanaasi? yo jano maam apa\"syat sa pitaramapyapa\"syat tarhi pitaram asmaan dar\"sayeti kathaa.m katha.m kathayasi? ");
INSERT INTO sanvel_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","aha.m pitari ti.s.thaami pitaa mayi ti.s.thatiiti ki.m tva.m na pratya.si? aha.m yadvaakya.m vadaami tat svato na vadaami kintu ya.h pitaa mayi viraajate sa eva sarvvakarmmaa.ni karaati| ");
INSERT INTO sanvel_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataeva pitaryyaha.m ti.s.thaami pitaa ca mayi ti.s.thati mamaasyaa.m kathaayaa.m pratyaya.m kuruta, no cet karmmaheto.h pratyaya.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","aha.m yu.smaanatiyathaartha.m vadaami, yo jano mayi vi\"svasiti sohamiva karmmaa.ni kari.syati vara.m tatopi mahaakarmmaa.ni kari.syati yato hetoraha.m pitu.h samiipa.m gacchaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathaa putre.na pitu rmahimaa prakaa\"sate tadartha.m mama naama procya yat praarthayi.syadhve tat saphala.m kari.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama naamnaa yat ki ncid yaacadhve tarhi tadaha.m saadhayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi priiyadhve tarhi mamaaj naa.h samaacarata| ");
INSERT INTO sanvel_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tato mayaa pitu.h samiipe praarthite pitaa nirantara.m yu.smaabhi.h saarddha.m sthaatum itarameka.m sahaayam arthaat satyamayam aatmaana.m yu.smaaka.m nika.ta.m pre.sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","etajjagato lokaasta.m grahiitu.m na \"saknuvanti yataste ta.m naapa\"syan naajana.m\"sca kintu yuuya.m jaaniitha yato heto.h sa yu.smaakamanta rnivasati yu.smaaka.m madhye sthaasyati ca| ");
INSERT INTO sanvel_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","aha.m yu.smaan anaathaan k.rtvaa na yaasyaami punarapi yu.smaaka.m samiipam aagami.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkaalarat param asya jagato lokaa maa.m puna rna drak.syanti kintu yuuya.m drak.syatha;aha.m jiivi.syaami tasmaat kaara.naad yuuyamapi jiivi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi ca yuuya.m stha, tathaaha.m yu.smaasvasmi tadapi tadaa j naasyatha| ");
INSERT INTO sanvel_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yo jano mamaaj naa g.rhiitvaa taa aacarati saeva mayi priiyate; yo jana\"sca mayi priiyate saeva mama pitu.h priyapaatra.m bhavi.syati, tathaahamapi tasmin priitvaa tasmai sva.m prakaa\"sayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadaa ii.skariyotiiyaad anyo yihuudaastamavadat, he prabho bhavaan jagato lokaanaa.m sannidhau prakaa\"sito na bhuutvaasmaaka.m sannidhau kuta.h prakaa\"sito bhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tato yii\"su.h pratyuditavaan, yo jano mayi priiyate sa mamaaj naa api g.rhlaati, tena mama pitaapi tasmin pre.syate, aavaa nca tannika.tamaagatya tena saha nivatsyaava.h| ");
INSERT INTO sanvel_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yo jano mayi na priiyate sa mama kathaa api na g.rhlaati puna\"sca yaamimaa.m kathaa.m yuuya.m \"s.r.nutha saa kathaa kevalasya mama na kintu mama prerako ya.h pitaa tasyaapi kathaa| ");
INSERT INTO sanvel_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idaanii.m yu.smaaka.m nika.te vidyamaanoham etaa.h sakalaa.h kathaa.h kathayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvita.h para.m pitraa ya.h sahaayo.arthaat pavitra aatmaa mama naamni prerayi.syati sa sarvva.m \"sik.sayitvaa mayoktaa.h samastaa.h kathaa yu.smaan smaarayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","aha.m yu.smaaka.m nika.te \"saanti.m sthaapayitvaa yaami, nijaa.m \"saanti.m yu.smabhya.m dadaami, jagato lokaa yathaa dadaati tathaaha.m na dadaami; yu.smaakam anta.hkara.naani du.hkhitaani bhiitaani ca na bhavantu| ");
INSERT INTO sanvel_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","aha.m gatvaa punarapi yu.smaaka.m samiipam aagami.syaami mayokta.m vaakyamida.m yuuyam a\"srau.s.ta; yadi mayyapre.syadhva.m tarhyaha.m pitu.h samiipa.m gacchaami mamaasyaa.m kathaayaa.m yuuyam ahlaadi.syadhva.m yato mama pitaa mattopi mahaan| ");
INSERT INTO sanvel_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyaa gha.tanaayaa.h samaye yathaa yu.smaaka.m \"sraddhaa jaayate tadartham aha.m tasyaa gha.tanaayaa.h puurvvam idaanii.m yu.smaan etaa.m vaarttaa.m vadaami| ");
INSERT INTO sanvel_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ita.h para.m yu.smaabhi.h saha mama bahava aalaapaa na bhavi.syanti yata.h kaara.naad etasya jagata.h patiraagacchati kintu mayaa saha tasya kopi sambandho naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","aha.m pitari prema karomi tathaa pitu rvidhivat karmmaa.ni karomiiti yena jagato lokaa jaananti tadartham utti.s.thata vaya.m sthaanaadasmaad gacchaama| ");
INSERT INTO sanvel_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","aha.m satyadraak.saalataasvaruupo mama pitaa tuudyaanaparicaarakasvaruupa nca| ");
INSERT INTO sanvel_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yaasu \"saakhaasu phalaani na bhavanti taa.h sa chinatti tathaa phalavatya.h \"saakhaa yathaadhikaphalaani phalanti tadartha.m taa.h pari.skaroti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idaanii.m mayoktopade\"sena yuuya.m pari.sk.rtaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ata.h kaara.naat mayi ti.s.thata tenaahamapi yu.smaasu ti.s.thaami, yato heto rdraak.saalataayaam asa.mlagnaa \"saakhaa yathaa phalavatii bhavitu.m na \"saknoti tathaa yuuyamapi mayyati.s.thanta.h phalavanto bhavitu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","aha.m draak.saalataasvaruupo yuuya nca \"saakhaasvaruupo.h; yo jano mayi ti.s.thati yatra caaha.m ti.s.thaami, sa pracuuraphalai.h phalavaan bhavati, kintu maa.m vinaa yuuya.m kimapi karttu.m na \"saknutha| ");
INSERT INTO sanvel_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ya.h ka\"scin mayi na ti.s.thati sa \"su.ska\"saakheva bahi rnik.sipyate lokaa\"sca taa aah.rtya vahnau nik.sipya daahayanti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yuuya.m mayi ti.s.thatha mama kathaa ca yu.smaasu ti.s.thati tarhi yad vaa nchitvaa yaaci.syadhve yu.smaaka.m tadeva saphala.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yuuya.m pracuuraphalavanto bhavatha tarhi tadvaaraa mama pitu rmahimaa prakaa\"si.syate tathaa yuuya.m mama \"si.syaa iti parik.saayi.syadhve| ");
INSERT INTO sanvel_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitaa yathaa mayi priitavaan ahamapi yu.smaasu tathaa priitavaan ato heto ryuuya.m nirantara.m mama premapaatraa.ni bhuutvaa ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","aha.m yathaa pituraaj naa g.rhiitvaa tasya premabhaajana.m ti.s.thaami tathaiva yuuyamapi yadi mamaaj naa guhliitha tarhi mama premabhaajanaani sthaasyatha| ");
INSERT INTO sanvel_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yu.smannimitta.m mama ya aahlaada.h sa yathaa cira.m ti.s.thati yu.smaakam aananda\"sca yathaa puuryyate tadartha.m yu.smabhyam etaa.h kathaa atrakatham| ");
INSERT INTO sanvel_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","aha.m yu.smaasu yathaa priiye yuuyamapi paraspara.m tathaa priiyadhvam e.saa mamaaj naa| ");
INSERT INTO sanvel_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitraa.naa.m kaara.naat svapraa.nadaanaparyyanta.m yat prema tasmaan mahaaprema kasyaapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","aha.m yadyad aadi\"saami tattadeva yadi yuuyam aacarata tarhi yuuyameva mama mitraa.ni| ");
INSERT INTO sanvel_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyaarabhya yu.smaan daasaan na vadi.syaami yat prabhu ryat karoti daasastad na jaanaati; kintu pitu.h samiipe yadyad a\"s.r.nava.m tat sarvva.m yuu.smaan aj naapayam tatkaara.naad yu.smaan mitraa.ni proktavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yuuya.m maa.m rocitavanta iti na, kintvahameva yu.smaan rocitavaan yuuya.m gatvaa yathaa phalaanyutpaadayatha taani phalaani caak.sayaa.ni bhavanti, tadartha.m yu.smaan nyajunaja.m tasmaan mama naama procya pitara.m yat ki ncid yaaci.syadhve tadeva sa yu.smabhya.m daasyati| ");
INSERT INTO sanvel_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yuuya.m paraspara.m priiyadhvam aham ityaaj naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagato lokai ryu.smaasu .rtiiyite.su te puurvva.m maamevaarttiiyanta iti yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yuuya.m jagato lokaa abhavi.syata tarhi jagato lokaa yu.smaan aatmiiyaan buddhvaapre.syanta; kintu yuuya.m jagato lokaa na bhavatha, aha.m yu.smaan asmaajjagato.arocayam etasmaat kaara.naajjagato lokaa yu.smaan .rtiiyante| ");
INSERT INTO sanvel_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","daasa.h prabho rmahaan na bhavati mamaitat puurvviiya.m vaakya.m smarata; te yadi maamevaataa.dayan tarhi yu.smaanapi taa.dayi.syanti, yadi mama vaakya.m g.rhlanti tarhi yu.smaakamapi vaakya.m grahii.syanti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu te mama naamakaara.naad yu.smaan prati taad.r\"sa.m vyavahari.syanti yato yo maa.m preritavaan ta.m te na jaananti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","te.saa.m sannidhim aagatya yadyaha.m naakathayi.sya.m tarhi te.saa.m paapa.m naabhavi.syat kintvadhunaa te.saa.m paapamaacchaadayitum upaayo naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yo jano maam .rtiiyate sa mama pitaramapi .rtiiyate| ");
INSERT INTO sanvel_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yaad.r\"saani karmmaa.ni kenaapi kadaapi naakriyanta taad.r\"saani karmmaa.ni yadi te.saa.m saak.saad aha.m naakari.sya.m tarhi te.saa.m paapa.m naabhavi.syat kintvadhunaa te d.r.s.tvaapi maa.m mama pitara ncaarttiiyanta| ");
INSERT INTO sanvel_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmaat te.akaara.na.m maam .rtiiyante yadetad vacana.m te.saa.m \"saastre likhitamaaste tat saphalam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgata.m ya.m sahaayamarthaat satyamayam aatmaana.m pitu.h samiipaad yu.smaaka.m samiipe pre.sayi.syaami sa aagatya mayi pramaa.na.m daasyati| ");
INSERT INTO sanvel_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yuuya.m prathamamaarabhya mayaa saarddha.m ti.s.thatha tasmaaddheto ryuuyamapi pramaa.na.m daasyatha| ");
INSERT INTO sanvel_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yu.smaaka.m yathaa vaadhaa na jaayate tadartha.m yu.smaan etaani sarvvavaakyaani vyaahara.m| ");
INSERT INTO sanvel_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lokaa yu.smaan bhajanag.rhebhyo duuriikari.syanti tathaa yasmin samaye yu.smaan hatvaa ii\"svarasya tu.s.ti janaka.m karmmaakurmma iti ma.msyante sa samaya aagacchanti| ");
INSERT INTO sanvel_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","te pitara.m maa nca na jaananti, tasmaad yu.smaan pratiid.r\"sam aacari.syanti| ");
INSERT INTO sanvel_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ato hetaa.h samaye samupasthite yathaa mama kathaa yu.smaaka.m mana.hsu.h samupati.s.thati tadartha.m yu.smaabhyam etaa.m kathaa.m kathayaami yu.smaabhi.h saarddham aha.m ti.s.than prathama.m taa.m yu.smabhya.m naakathaya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","saamprata.m svasya prerayitu.h samiipa.m gacchaami tathaapi tva.m kka gacchasi kathaametaa.m yu.smaaka.m kopi maa.m na p.rcchati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayoktaabhiraabhi.h kathaabhi ryuu.smaakam anta.hkara.naani du.hkhena puur.naanyabhavan| ");
INSERT INTO sanvel_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathaapyaha.m yathaartha.m kathayaami mama gamana.m yu.smaaka.m hitaarthameva, yato heto rgamane na k.rte sahaayo yu.smaaka.m samiipa.m naagami.syati kintu yadi gacchaami tarhi yu.smaaka.m samiipe ta.m pre.sayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tata.h sa aagatya paapapu.nyada.n.de.su jagato lokaanaa.m prabodha.m janayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","te mayi na vi\"svasanti tasmaaddheto.h paapaprabodha.m janayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yu.smaakam ad.r\"sya.h sannaha.m pitu.h samiipa.m gacchaami tasmaad pu.nye prabodha.m janayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","etajjagato.adhipati rda.n.daaj naa.m praapnoti tasmaad da.n.de prabodha.m janayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yu.smabhya.m kathayitu.m mamaanekaa.h kathaa aasate, taa.h kathaa idaanii.m yuuya.m so.dhu.m na \"saknutha; ");
INSERT INTO sanvel_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya aatmaa yadaa samaagami.syati tadaa sarvva.m satya.m yu.smaan ne.syati, sa svata.h kimapi na vadi.syati kintu yacchro.syati tadeva kathayitvaa bhaavikaaryya.m yu.smaan j naapayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimaana.m prakaa\"sayi.syati yato madiiyaa.m kathaa.m g.rhiitvaa yu.smaan bodhayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad aaste tat sarvva.m mama tasmaad kaara.naad avaadi.sa.m sa madiiyaa.m kathaa.m g.rhiitvaa yu.smaan bodhayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkaalaat para.m yuuya.m maa.m dra.s.tu.m na lapsyadhve kintu kiyatkaalaat para.m puna rdra.s.tu.m lapsyadhve yatoha.m pitu.h samiipa.m gacchaami| ");
INSERT INTO sanvel_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tata.h \"si.syaa.naa.m kiyanto janaa.h paraspara.m vaditum aarabhanta, kiyatkaalaat para.m maa.m dra.s.tu.m na lapsyadhve kintu kiyatkaalaat para.m puna rdra.s.tu.m lapsyadhve yatoha.m pitu.h samiipa.m gacchaami, iti yad vaakyam aya.m vadati tat ki.m? ");
INSERT INTO sanvel_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tata.h kiyatkaalaat param iti tasya vaakya.m ki.m? tasya vaakyasyaabhipraaya.m vaya.m boddhu.m na \"saknumastairiti ");
INSERT INTO sanvel_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigadite yii\"suste.saa.m pra\"snecchaa.m j naatvaa tebhyo.akathayat kiyatkaalaat para.m maa.m dra.s.tu.m na lapsyadhve, kintu kiyatkaalaat para.m puuna rdra.s.tu.m lapsyadhve, yaamimaa.m kathaamakathaya.m tasyaa abhipraaya.m ki.m yuuya.m paraspara.m m.rgayadhve? ");
INSERT INTO sanvel_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yu.smaanaham atiyathaartha.m vadaami yuuya.m krandi.syatha vilapi.syatha ca, kintu jagato lokaa aanandi.syanti; yuuya.m \"sokaakulaa bhavi.syatha kintu \"sokaat para.m aanandayuktaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakaala upasthite naarii yathaa prasavavedanayaa vyaakulaa bhavati kintu putre bhuumi.s.the sati manu.syaiko janmanaa naraloke pravi.s.ta ityaanandaat tasyaastatsarvva.m du.hkha.m manasi na ti.s.thati, ");
INSERT INTO sanvel_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathaa yuuyamapi saamprata.m \"sokaakulaa bhavatha kintu punarapi yu.smabhya.m dar\"sana.m daasyaami tena yu.smaakam anta.hkara.naani saanandaani bhavi.syanti, yu.smaaka.m tam aananda nca kopi harttu.m na \"sak.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divase kaamapi kathaa.m maa.m na prak.syatha| yu.smaanaham atiyathaartha.m vadaami, mama naamnaa yat ki ncid pitara.m yaaci.syadhve tadeva sa daasyati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","puurvve mama naamnaa kimapi naayaacadhva.m, yaacadhva.m tata.h praapsyatha tasmaad yu.smaaka.m sampuur.naanando jani.syate| ");
INSERT INTO sanvel_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamaakathaabhi.h sarvvaa.nyetaani yu.smaan j naapitavaan kintu yasmin samaye upamayaa noktvaa pitu.h kathaa.m spa.s.ta.m j naapayi.syaami samaya etaad.r\"sa aagacchati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadaa mama naamnaa praarthayi.syadhve .aha.m yu.smannimitta.m pitara.m vine.sye kathaamimaa.m na vadaami; ");
INSERT INTO sanvel_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yato yuuya.m mayi prema kurutha, tathaaham ii\"svarasya samiipaad aagatavaan ityapi pratiitha, tasmaad kaara.naat kaara.naat pitaa svaya.m yu.smaasu priiyate| ");
INSERT INTO sanvel_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pitu.h samiipaajjajad aagatosmi jagat parityajya ca punarapi pitu.h samiipa.m gacchaami| ");
INSERT INTO sanvel_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadaa \"si.syaa avadan, he prabho bhavaan upamayaa noktvaadhunaa spa.s.ta.m vadati| ");
INSERT INTO sanvel_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavaan sarvvaj na.h kenacit p.r.s.to bhavitumapi bhavata.h prayojana.m naastiityadhunaasmaaka.m sthiraj naana.m jaata.m tasmaad bhavaan ii\"svarasya samiipaad aagatavaan ityatra vaya.m vi\"svasima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tato yii\"su.h pratyavaadiid idaanii.m ki.m yuuya.m vi\"svasitha? ");
INSERT INTO sanvel_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pa\"syata sarvve yuuya.m vikiir.naa.h santo maam ekaakina.m piiratyajya sva.m sva.m sthaana.m gami.syatha, etaad.r\"sa.h samaya aagacchati vara.m praaye.nopasthitavaan; tathaapyaha.m naikaakii bhavaami yata.h pitaa mayaa saarddham aaste| ");
INSERT INTO sanvel_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathaa mayaa yu.smaaka.m \"saanti rjaayate tadartham etaa.h kathaa yu.smabhyam acakatha.m; asmin jagati yu.smaaka.m kle\"so gha.ti.syate kintvak.sobhaa bhavata yato mayaa jagajjita.m| ");
INSERT INTO sanvel_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tata.h para.m yii\"suretaa.h kathaa.h kathayitvaa svarga.m vilokyaitat praarthayat, he pita.h samaya upasthitavaan; yathaa tava putrastava mahimaana.m prakaa\"sayati tadartha.m tva.m nijaputrasya mahimaana.m prakaa\"saya| ");
INSERT INTO sanvel_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tva.m yollokaan tasya haste samarpitavaan sa yathaa tebhyo.anantaayu rdadaati tadartha.m tva.m praa.nimaatraa.naam adhipatitvabhaara.m tasmai dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitiiya.h satya ii\"svarastvayaa prerita\"sca yii\"su.h khrii.s.ta etayorubhayo.h paricaye praapte.anantaayu rbhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tva.m yasya karmma.no bhaara.m mahya.m dattavaan, tat sampanna.m k.rtvaa jagatyasmin tava mahimaana.m praakaa\"saya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataeva he pita rjagatyavidyamaane tvayaa saha ti.s.thato mama yo mahimaasiit samprati tava samiipe maa.m ta.m mahimaana.m praapaya| ");
INSERT INTO sanvel_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyacca tvam etajjagato yaallokaan mahyam adadaa aha.m tebhyastava naamnastattvaj naanam adadaa.m, te tavaivaasan, tva.m taan mahyamadadaa.h, tasmaatte tavopade\"sam ag.rhlan| ");
INSERT INTO sanvel_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tva.m mahya.m yat ki ncid adadaastatsarvva.m tvatto jaayate ityadhunaajaanan| ");
INSERT INTO sanvel_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahya.m yamupade\"sam adadaa ahamapi tebhyastamupade\"sam adadaa.m tepi tamag.rhlan tvattoha.m nirgatya tvayaa preritobhavam atra ca vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","te.saameva nimitta.m praarthaye.aha.m jagato lokanimitta.m na praarthaye kintu yaallokaan mahyam adadaaste.saameva nimitta.m praarthaye.aha.m yataste tavaivaasate| ");
INSERT INTO sanvel_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ye mama te tava ye ca tava te mama tathaa tai rmama mahimaa prakaa\"syate| ");
INSERT INTO sanvel_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","saampratam asmin jagati mamaavasthite.h \"se.sam abhavat aha.m tava samiipa.m gacchaami kintu te jagati sthaasyanti; he pavitra pitaraavayo ryathaikatvamaaste tathaa te.saamapyekatva.m bhavati tadartha.m yaallokaan mahyam adadaastaan svanaamnaa rak.sa| ");
INSERT INTO sanvel_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yaavanti dinaani jagatyasmin tai.h sahaahamaasa.m taavanti dinaani taan tava naamnaaha.m rak.sitavaan; yaallokaan mahyam adadaastaan sarvvaan ahamarak.sa.m, te.saa.m madhye kevala.m vinaa\"sapaatra.m haarita.m tena dharmmapustakasya vacana.m pratyak.sa.m bhavati| ");
INSERT INTO sanvel_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunaa tava sannidhi.m gacchaami mayaa yathaa te.saa.m sampuur.naanando bhavati tadarthamaha.m jagati ti.s.than etaa.h kathaa akathayam| ");
INSERT INTO sanvel_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavopade\"sa.m tebhyo.adadaa.m jagataa saha yathaa mama sambandho naasti tathaa jajataa saha te.saamapi sambandhaabhaavaaj jagato lokaastaan .rtiiyante| ");
INSERT INTO sanvel_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tva.m jagatastaan g.rhaa.neti na praarthaye kintva\"subhaad rak.seti praarthayeham| ");
INSERT INTO sanvel_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","aha.m yathaa jagatsambandhiiyo na bhavaami tathaa tepi jagatsambandhiiyaa na bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayaa taan pavitriikuru tava vaakyameva satya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tva.m yathaa maa.m jagati prairayastathaahamapi taan jagati prairaya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","te.saa.m hitaartha.m yathaaha.m sva.m pavitriikaromi tathaa satyakathayaa tepi pavitriibhavantu| ");
INSERT INTO sanvel_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kevala.m ete.saamarthe praarthaye.aham iti na kintvete.saamupade\"sena ye janaa mayi vi\"svasi.syanti te.saamapyarthe praartheye.aham| ");
INSERT INTO sanvel_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","he pitaste.saa.m sarvve.saam ekatva.m bhavatu tava yathaa mayi mama ca yathaa tvayyekatva.m tathaa te.saamapyaavayorekatva.m bhavatu tena tva.m maa.m preritavaan iti jagato lokaa.h pratiyantu| ");
INSERT INTO sanvel_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathaavayorekatva.m tathaa te.saamapyekatva.m bhavatu te.svaha.m mayi ca tvam ittha.m te.saa.m sampuur.namekatva.m bhavatu, tva.m preritavaan tva.m mayi yathaa priiyase ca tathaa te.svapi priitavaan etadyathaa jagato lokaa jaananti ");
INSERT INTO sanvel_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadartha.m tva.m ya.m mahimaana.m mahyam adadaasta.m mahimaanam ahamapi tebhyo dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","he pita rjagato nirmmaa.naat puurvva.m mayi sneha.m k.rtvaa ya.m mahimaana.m dattavaan mama ta.m mahimaana.m yathaa te pa\"syanti tadartha.m yaallokaan mahya.m dattavaan aha.m yatra ti.s.thaami tepi yathaa tatra ti.s.thanti mamai.saa vaa nchaa| ");
INSERT INTO sanvel_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","he yathaarthika pita rjagato lokaistvayyaj naatepi tvaamaha.m jaane tva.m maa.m preritavaan itiime \"si.syaa jaananti| ");
INSERT INTO sanvel_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathaaha.m te.su ti.s.thaami tathaa mayi yena premnaa premaakarostat te.su ti.s.thati tadartha.m tava naamaaha.m taan j naapitavaan punarapi j naapayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","taa.h kathaa.h kathayitvaa yii\"su.h \"si.syaanaadaaya kidronnaamaka.m srota uttiiryya \"si.syai.h saha tatratyodyaana.m praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu vi\"svaasaghaatiyihuudaastat sthaana.m pariciiyate yato yii\"su.h \"si.syai.h saarddha.m kadaacit tat sthaanam agacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadaa sa yihuudaa.h sainyaga.na.m pradhaanayaajakaanaa.m phiruu\"sinaa nca padaatiga.na nca g.rhiitvaa pradiipaan ulkaan astraa.ni caadaaya tasmin sthaana upasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","sva.m prati yad gha.ti.syate taj j naatvaa yii\"suragresara.h san taanap.rcchat ka.m gave.sayatha? ");
INSERT INTO sanvel_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","te pratyavadan, naasaratiiya.m yii\"su.m; tato yii\"suravaadiid ahameva sa.h; tai.h saha vi\"svaasaghaatii yihuudaa\"scaati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadaahameva sa tasyaitaa.m kathaa.m \"srutvaiva te pa\"scaadetya bhuumau patitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tato yii\"su.h punarapi p.r.s.thavaan ka.m gave.sayatha? tataste pratyavadan naasaratiiya.m yii\"su.m| ");
INSERT INTO sanvel_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadaa yii\"su.h pratyuditavaan ahameva sa imaa.m kathaamacakatham; yadi maamanvicchatha tarhiimaan gantu.m maa vaarayata| ");
INSERT INTO sanvel_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ittha.m bhuute mahya.m yaallokaan adadaaste.saam ekamapi naahaarayam imaa.m yaa.m kathaa.m sa svayamakathayat saa kathaa saphalaa jaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadaa \"simonpitarasya nika.te kha\"ngalsthite.h sa ta.m ni.sko.sa.m k.rtvaa mahaayaajakasya maalkhanaamaana.m daasam aahatya tasya dak.si.nakar.na.m chinnavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tato yii\"su.h pitaram avadat, kha\"nga.m ko.se sthaapaya mama pitaa mahya.m paatu.m ya.m ka.msam adadaat tenaaha.m ki.m na paasyaami? ");
INSERT INTO sanvel_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadaa sainyaga.na.h senaapati ryihuudiiyaanaa.m padaataya\"sca yii\"su.m gh.rtvaa baddhvaa haanannaamna.h kiyaphaa.h \"sva\"surasya samiipa.m prathamam anayan| ");
INSERT INTO sanvel_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphaastasmin vatsare mahaayaajatvapade niyukta.h ");
INSERT INTO sanvel_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san saadhaara.nalokaanaa.m ma\"ngalaartham ekajanasya mara.namucitam iti yihuudiiyai.h saarddham amantrayat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadaa \"simonpitaro.anyaika\"si.sya\"sca yii\"so.h pa\"scaad agacchataa.m tasyaanya\"si.syasya mahaayaajakena paricitatvaat sa yii\"sunaa saha mahaayaajakasyaa.t.taalikaa.m praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitaro bahirdvaarasya samiipe.ati.s.thad ataeva mahaayaajakena paricita.h sa \"si.sya.h punarbahirgatvaa dauvaayikaayai kathayitvaa pitaram abhyantaram aanayat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadaa sa dvaararak.sikaa pitaram avadat tva.m ki.m na tasya maanavasya \"si.sya.h? tata.h sovadad aha.m na bhavaami| ");
INSERT INTO sanvel_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tata.h para.m yatsthaane daasaa.h padaataya\"sca \"siitahetora\"ngaarai rvahni.m prajvaalya taapa.m sevitavantastatsthaane pitarasti.s.than tai.h saha vahnitaapa.m sevitum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadaa \"si.sye.suupade\"se ca mahaayaajakena yii\"su.h p.r.s.ta.h ");
INSERT INTO sanvel_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavaan sarvvalokaanaa.m samak.sa.m kathaamakathaya.m gupta.m kaamapi kathaa.m na kathayitvaa yat sthaana.m yihuudiiyaa.h satata.m gacchanti tatra bhajanagehe mandire caa\"sik.saya.m| ");
INSERT INTO sanvel_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","matta.h kuta.h p.rcchasi? ye janaa madupade\"sam a\"s.r.nvan taaneva p.rccha yadyad avada.m te tat jaaninta| ");
INSERT INTO sanvel_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadettha.m pratyuditatvaat nika.tasthapadaati ryii\"su.m cape.tenaahatya vyaaharat mahaayaajakam eva.m prativadasi? ");
INSERT INTO sanvel_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tato yii\"su.h pratigaditavaan yadyayathaartham acakatha.m tarhi tasyaayathaarthasya pramaa.na.m dehi, kintu yadi yathaartha.m tarhi kuto heto rmaam ataa.daya.h? ");
INSERT INTO sanvel_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","puurvva.m haanan sabandhana.m ta.m kiyaphaamahaayaajakasya samiipa.m prai.sayat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","\"simonpitarasti.s.than vahnitaapa.m sevate, etasmin samaye kiyantastam ap.rcchan tva.m kim etasya janasya \"si.syo na? tata.h sopahnutyaabraviid aha.m na bhavaami| ");
INSERT INTO sanvel_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadaa mahaayaajakasya yasya daasasya pitara.h kar.namacchinat tasya ku.tumba.h pratyuditavaan udyaane tena saha ti.s.thanta.m tvaa.m ki.m naapa\"sya.m? ");
INSERT INTO sanvel_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitara.h punarapahnutya kathitavaan; tadaanii.m kukku.to.araut| ");
INSERT INTO sanvel_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantara.m pratyuu.se te kiyaphaag.rhaad adhipate rg.rha.m yii\"sum anayan kintu yasmin a\"sucitve jaate tai rnistaarotsave na bhoktavya.m, tasya bhayaad yihuudiiyaastadg.rha.m naavi\"san| ");
INSERT INTO sanvel_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","apara.m piilaato bahiraagatya taan p.r.s.thavaan etasya manu.syasya ka.m do.sa.m vadatha? ");
INSERT INTO sanvel_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadaa te petyavadan du.skarmmakaari.ni na sati bhavata.h samiipe naina.m samaarpayi.syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tata.h piilaato.avadad yuuyamena.m g.rhiitvaa sve.saa.m vyavasthayaa vicaarayata| tadaa yihuudiiyaa.h pratyavadan kasyaapi manu.syasya praa.nada.n.da.m karttu.m naasmaakam adhikaaro.asti| ");
INSERT INTO sanvel_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","eva.m sati yii\"su.h svasya m.rtyau yaa.m kathaa.m kathitavaan saa saphalaabhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantara.m piilaata.h punarapi tad raajag.rha.m gatvaa yii\"sumaahuuya p.r.s.tavaan tva.m ki.m yihuudiiyaanaa.m raajaa? ");
INSERT INTO sanvel_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yii\"su.h pratyavadat tvam etaa.m kathaa.m svata.h kathayasi kimanya.h ka\"scin mayi kathitavaan? ");
INSERT INTO sanvel_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","piilaato.avadad aha.m ki.m yihuudiiya.h? tava svade\"siiyaa vi\"se.sata.h pradhaanayaajakaa mama nika.te tvaa.m samaarpayana, tva.m ki.m k.rtavaan? ");
INSERT INTO sanvel_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yii\"su.h pratyavadat mama raajyam etajjagatsambandhiiya.m na bhavati yadi mama raajya.m jagatsambandhiiyam abhavi.syat tarhi yihuudiiyaanaa.m haste.su yathaa samarpito naabhava.m tadartha.m mama sevakaa ayotsyan kintu mama raajyam aihika.m na| ");
INSERT INTO sanvel_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadaa piilaata.h kathitavaan, tarhi tva.m raajaa bhavasi? yii\"su.h pratyuktavaan tva.m satya.m kathayasi, raajaaha.m bhavaami; satyataayaa.m saak.sya.m daatu.m jani.m g.rhiitvaa jagatyasmin avatiir.navaan, tasmaat satyadharmmapak.sapaatino mama kathaa.m \"s.r.nvanti| ");
INSERT INTO sanvel_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadaa satya.m ki.m? etaa.m kathaa.m pa.s.tvaa piilaata.h punarapi bahirgatvaa yihuudiiyaan abhaa.sata, aha.m tasya kamapyaparaadha.m na praapnomi| ");
INSERT INTO sanvel_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistaarotsavasamaye yu.smaabhirabhirucita eko jano mayaa mocayitavya e.saa yu.smaaka.m riitirasti, ataeva yu.smaaka.m nika.te yihuudiiyaanaa.m raajaana.m ki.m mocayaami, yu.smaakam icchaa kaa? ");
INSERT INTO sanvel_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadaa te sarvve ruvanto vyaaharan ena.m maanu.sa.m nahi barabbaa.m mocaya| kintu sa barabbaa dasyuraasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","piilaato yii\"sum aaniiya ka\"sayaa praahaarayat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","pa\"scaat senaaga.na.h ka.n.takanirmmita.m muku.ta.m tasya mastake samarpya vaarttaakiivar.na.m raajaparicchada.m paridhaapya, ");
INSERT INTO sanvel_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","he yihuudiiyaanaa.m raajan namaskaara ityuktvaa ta.m cape.tenaahantum aarabhata| ");
INSERT INTO sanvel_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadaa piilaata.h punarapi bahirgatvaa lokaan avadat, asya kamapyaparaadha.m na labhe.aha.m, pa\"syata tad yu.smaan j naapayitu.m yu.smaaka.m sannidhau bahirenam aanayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tata.h para.m yii\"su.h ka.n.takamuku.tavaan vaarttaakiivar.navasanavaa.m\"sca bahiraagacchat| tata.h piilaata uktavaan ena.m manu.sya.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadaa pradhaanayaajakaa.h padaataya\"sca ta.m d.r.s.tvaa, ena.m kru\"se vidha, ena.m kru\"se vidha, ityuktvaa ravitu.m aarabhanta| tata.h piilaata.h kathitavaan yuuya.m svayam ena.m niitvaa kru\"se vidhata, aham etasya kamapyaparaadha.m na praaptavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihuudiiyaa.h pratyavadan asmaaka.m yaa vyavasthaaste tadanusaare.naasya praa.nahananam ucita.m yatoya.m svam ii\"svarasya putramavadat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","piilaata imaa.m kathaa.m \"srutvaa mahaatraasayukta.h ");
INSERT INTO sanvel_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi raajag.rha aagatya yii\"su.m p.r.s.tavaan tva.m kutratyo loka.h? kintu yii\"sastasya kimapi pratyuttara.m naavadat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tata.h piilaat kathitavaana tva.m ki.m mayaa saarddha.m na sa.mlapi.syasi ? tvaa.m kru\"se vedhitu.m vaa mocayitu.m \"sakti rmamaaste iti ki.m tva.m na jaanaasi ? tadaa yii\"su.h pratyavadad ii\"svare.naadaŸा.m mamopari tava kimapyadhipatitva.m na vidyate, tathaapi yo jano maa.m tava haste samaarpayat tasya mahaapaataka.m jaatam| ");
INSERT INTO sanvel_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadaa yii\"su.h pratyavadad ii\"svare.naadatta.m mamopari tava kimapyadhipatitva.m na vidyate, tathaapi yo jano maa.m tava haste samaarpayat tasya mahaapaataka.m jaatam| ");
INSERT INTO sanvel_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadaarabhya piilaatasta.m mocayitu.m ce.s.titavaan kintu yihuudiiyaa ruvanto vyaaharan yadiima.m maanava.m tyajasi tarhi tva.m kaisarasya mitra.m na bhavasi, yo jana.h sva.m raajaana.m vakti saeva kaimarasya viruddhaa.m kathaa.m kathayati| ");
INSERT INTO sanvel_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","etaa.m kathaa.m \"srutvaa piilaato yii\"su.m bahiraaniiya nistaarotsavasya aasaadanadinasya dvitiiyapraharaat puurvva.m prastarabandhananaamni sthaane .arthaat ibriiyabhaa.sayaa yad gabbithaa kathyate tasmin sthaane vicaaraasana upaavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantara.m piilaato yihuudiiyaan avadat, yu.smaaka.m raajaana.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu ena.m duuriikuru, ena.m duuriikuru, ena.m kru\"se vidha, iti kathaa.m kathayitvaa te ravitum aarabhanta; tadaa piilaata.h kathitavaan yu.smaaka.m raajaana.m ki.m kru\"se vedhi.syaami? pradhaanayaajakaa uttaram avadan kaisara.m vinaa kopi raajaasmaaka.m naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tata.h piilaato yii\"su.m kru\"se vedhitu.m te.saa.m haste.su samaarpayat, tataste ta.m dh.rtvaa niitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tata.h para.m yii\"su.h kru\"sa.m vahan \"sira.hkapaalam arthaad yad ibriiyabhaa.sayaa gulgaltaa.m vadanti tasmin sthaana upasthita.h| ");
INSERT INTO sanvel_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tataste madhyasthaane ta.m tasyobhayapaar\"sve dvaavaparau kru\"se.avidhan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam e.sa yihuudiiyaanaa.m raajaa naasaratiiyayii\"su.h, iti vij naapana.m likhitvaa piilaatastasya kru\"sopari samayojayat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","saa lipi.h ibriiyayuunaaniiyaromiiyabhaa.saabhi rlikhitaa; yii\"so.h kru\"savedhanasthaana.m nagarasya samiipa.m, tasmaad bahavo yihuudiiyaastaa.m pa.thitum aarabhanta| ");
INSERT INTO sanvel_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihuudiiyaanaa.m pradhaanayaajakaa.h piilaatamiti nyavedayan yihuudiiyaanaa.m raajeti vaakya.m na kintu e.sa sva.m yihuudiiyaanaa.m raajaanam avadad ittha.m likhatu| ");
INSERT INTO sanvel_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tata.h piilaata uttara.m dattavaan yallekhaniiya.m tallikhitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ittha.m senaaga.no yii\"su.m kru\"se vidhitvaa tasya paridheyavastra.m caturo bhaagaan k.rtvaa ekaikasenaa ekaikabhaagam ag.rhlat tasyottariiyavastra ncaag.rhlat| kintuuttariiyavastra.m suucisevana.m vinaa sarvvam uuta.m| ");
INSERT INTO sanvel_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmaatte vyaaharan etat ka.h praapsyati? tanna kha.n.dayitvaa tatra gu.tikaapaata.m karavaama| vibhajante.adhariiya.m me vasana.m te paraspara.m| mamottariiyavastraartha.m gu.tikaa.m paatayanti ca| iti yadvaakya.m dharmmapustake likhitamaaste tat senaaga.nenettha.m vyavahara.naat siddhamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadaanii.m yii\"so rmaataa maatu rbhaginii ca yaa kliyapaa bhaaryyaa mariyam magdaliinii mariyam ca etaastasya kru\"sasya sannidhau samati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tato yii\"su.h svamaatara.m priyatama\"si.sya nca samiipe da.n.daayamaanau vilokya maataram avadat, he yo.sid ena.m tava putra.m pa\"sya, ");
INSERT INTO sanvel_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","\"si.syantvavadat, enaa.m tava maatara.m pa\"sya| tata.h sa \"si.syastadgha.tikaayaa.m taa.m nijag.rha.m niitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantara.m sarvva.m karmmaadhunaa sampannamabhuut yii\"suriti j naatvaa dharmmapustakasya vacana.m yathaa siddha.m bhavati tadartham akathayat mama pipaasaa jaataa| ");
INSERT INTO sanvel_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthaane amlarasena puur.napaatrasthityaa te spa njameka.m tadamlarasenaardriik.rtya esobnale tad yojayitvaa tasya mukhasya sannidhaavasthaapayan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadaa yii\"suramlarasa.m g.rhiitvaa sarvva.m siddham iti kathaa.m kathayitvaa mastaka.m namayan praa.naan paryyatyajat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam aasaadanadina.m tasmaat pare.ahani vi\"sraamavaare dehaa yathaa kru\"sopari na ti.s.thanti, yata.h sa vi\"sraamavaaro mahaadinamaasiit, tasmaad yihuudiiyaa.h piilaatanika.ta.m gatvaa te.saa.m paadabha njanasya sthaanaantaranayanasya caanumati.m praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ata.h senaa aagatya yii\"sunaa saha kru\"se hatayo.h prathamadvitiiyacorayo.h paadaan abha njan; ");
INSERT INTO sanvel_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yii\"so.h sannidhi.m gatvaa sa m.rta iti d.r.s.tvaa tasya paadau naabha njan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","pa\"scaad eko yoddhaa \"suulaaghaatena tasya kuk.sim avidhat tatk.sa.naat tasmaad rakta.m jala nca niragacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yo jano.asya saak.sya.m dadaati sa svaya.m d.r.s.tavaan tasyeda.m saak.sya.m satya.m tasya kathaa yu.smaaka.m vi\"svaasa.m janayitu.m yogyaa tat sa jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bha.mk.syate, ");
INSERT INTO sanvel_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anya\"saastrepi likhyate, yathaa, \"d.r.s.tipaata.m kari.syanti te.avidhan yantu tamprati|\" ");
INSERT INTO sanvel_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathiiyanagarasya yuu.saphnaamaa \"si.sya eka aasiit kintu yihuudiiyebhyo bhayaat prakaa\"sito na bhavati; sa yii\"so rdeha.m netu.m piilaatasyaanumati.m praarthayata, tata.h piilaatenaanumate sati sa gatvaa yii\"so rdeham anayat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","apara.m yo nikadiimo raatrau yii\"so.h samiipam agacchat sopi gandharasena mi\"srita.m praaye.na pa ncaa\"satse.takamaguru.m g.rhiitvaagacchat| ");
INSERT INTO sanvel_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tataste yihuudiiyaanaa.m \"sma\"saane sthaapanariityanusaare.na tatsugandhidravye.na sahita.m tasya deha.m vastre.naave.s.tayan| ");
INSERT INTO sanvel_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","apara nca yatra sthaane ta.m kru\"se.avidhan tasya nika.tasthodyaane yatra kimapi m.rtadeha.m kadaapi naasthaapyata taad.r\"sam eka.m nuutana.m \"sma\"saanam aasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihuudiiyaanaam aasaadanadinaagamanaat te tasmin samiipastha\"sma\"saane yii\"sum a\"saayayan| ");
INSERT INTO sanvel_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantara.m saptaahasya prathamadine .atipratyuu.se .andhakaare ti.s.thati magdaliinii mariyam tasya \"sma\"saanasya nika.ta.m gatvaa \"sma\"saanasya mukhaat prastaramapasaaritam apa\"syat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","pa\"scaad dhaavitvaa \"simonpitaraaya yii\"so.h priyatama\"si.syaaya cedam akathayat, lokaa.h \"sma\"saanaat prabhu.m niitvaa kutraasthaapayan tad vaktu.m na \"saknomi| ");
INSERT INTO sanvel_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ata.h pitara.h sonya\"si.sya\"sca barhi rbhutvaa \"sma\"saanasthaana.m gantum aarabhetaa.m| ");
INSERT INTO sanvel_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayordhaavato.h sonya\"si.sya.h pitara.m pa\"scaat tyaktvaa puurvva.m \"sma\"saanasthaana upasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadaa prahviibhuuya sthaapitavastraa.ni d.r.s.tavaan kintu na praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","apara.m \"simonpitara aagatya \"sma\"saanasthaana.m pravi\"sya ");
INSERT INTO sanvel_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthaapitavastraa.ni mastakasya vastra nca p.rthak sthaanaantare sthaapita.m d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tata.h \"sma\"saanasthaana.m puurvvam aagato yonya\"si.sya.h sopi pravi\"sya taad.r\"sa.m d.r.s.taa vya\"svasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yata.h \"sma\"saanaat sa utthaapayitavya etasya dharmmapustakavacanasya bhaava.m te tadaa voddhu.m naa\"sankuvan| ");
INSERT INTO sanvel_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantara.m tau dvau \"si.syau sva.m sva.m g.rha.m paraav.rtyaagacchataam| ");
INSERT INTO sanvel_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tata.h para.m mariyam \"sma\"saanadvaarasya bahi.h sthitvaa roditum aarabhata tato rudatii prahviibhuuya \"sma\"saana.m vilokya ");
INSERT INTO sanvel_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yii\"so.h \"sayanasthaanasya \"sira.hsthaane padatale ca dvayo rdi\"so dvau svargiiyaduutaavupavi.s.tau samapa\"syat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau p.r.s.tavantau he naari kuto rodi.si? saavadat lokaa mama prabhu.m niitvaa kutraasthaapayan iti na jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvaa mukha.m paraav.rtya yii\"su.m da.n.daayamaanam apa\"syat kintu sa yii\"suriti saa j naatu.m naa\"saknot| ");
INSERT INTO sanvel_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadaa yii\"sustaam ap.rcchat he naari kuto rodi.si? ka.m vaa m.rgayase? tata.h saa tam udyaanasevaka.m j naatvaa vyaaharat, he maheccha tva.m yadiita.h sthaanaat ta.m niitavaan tarhi kutraasthaapayastad vada tatsthaanaat tam aanayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadaa yii\"sustaam avadat he mariyam| tata.h saa paraav.rtya pratyavadat he rabbuunii arthaat he guro| ");
INSERT INTO sanvel_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadaa yii\"suravadat maa.m maa dhara, idaanii.m pitu.h samiipe uurddhvagamana.m na karomi kintu yo mama yu.smaaka nca pitaa mama yu.smaaka nce\"svarastasya nika.ta uurddhvagamana.m karttum udyatosmi, imaa.m kathaa.m tva.m gatvaa mama bhraat.rga.na.m j naapaya| ");
INSERT INTO sanvel_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tato magdaliiniimariyam tatk.sa.naad gatvaa prabhustasyai dar\"sana.m dattvaa kathaa etaa akathayad iti vaarttaa.m \"si.syebhyo.akathayat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tata.h para.m saptaahasya prathamadinasya sandhyaasamaye \"si.syaa ekatra militvaa yihuudiiyebhyo bhiyaa dvaararuddham akurvvan, etasmin kaale yii\"suste.saa.m madhyasthaane ti.s.than akathayad yu.smaaka.m kalyaa.na.m bhuuyaat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvaa nijahasta.m kuk.si nca dar\"sitavaan, tata.h \"si.syaa.h prabhu.m d.r.s.tvaa h.r.s.taa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yii\"su.h punaravadad yu.smaaka.m kalyaa.na.m bhuuyaat pitaa yathaa maa.m prai.sayat tathaahamapi yu.smaan pre.sayaami| ");
INSERT INTO sanvel_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvaa sa te.saamupari diirghapra\"svaasa.m dattvaa kathitavaan pavitram aatmaana.m g.rhliita| ");
INSERT INTO sanvel_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yuuya.m ye.saa.m paapaani mocayi.syatha te mocayi.syante ye.saa nca paapaati na mocayi.syatha te na mocayi.syante| ");
INSERT INTO sanvel_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvaada\"samadhye ga.nito yamajo thomaanaamaa \"si.syo yii\"soraagamanakaalai tai.h saarddha.m naasiit| ");
INSERT INTO sanvel_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ato vaya.m prabhuum apa\"syaameti vaakye.anya\"si.syairukte sovadat, tasya hastayo rlauhakiilakaanaa.m cihna.m na vilokya taccihnam a\"ngulyaa na sp.r.s.tvaa tasya kuk.sau hasta.m naaropya caaha.m na vi\"svasi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam a.s.tame.ahni gate sati thomaasahita.h \"si.syaga.na ekatra militvaa dvaara.m ruddhvaabhyantara aasiit, etarhi yii\"suste.saa.m madhyasthaane ti.s.than akathayat, yu.smaaka.m ku\"sala.m bhuuyaat| ");
INSERT INTO sanvel_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","pa\"scaat thaamai kathitavaan tvam a\"nguliim atraarpayitvaa mama karau pa\"sya kara.m prasaaryya mama kuk.saavarpaya naavi\"svasya| ");
INSERT INTO sanvel_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadaa thomaa avadat, he mama prabho he madii\"svara| ");
INSERT INTO sanvel_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yii\"surakathayat, he thomaa maa.m niriik.sya vi\"svasi.si ye na d.r.s.tvaa vi\"svasanti taeva dhanyaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","etadanyaani pustake.asmin alikhitaani bahuunyaa\"scaryyakarmmaa.ni yii\"su.h \"si.syaa.naa.m purastaad akarot| ");
INSERT INTO sanvel_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yii\"surii\"svarasyaabhi.sikta.h suta eveti yathaa yuuya.m vi\"svasitha vi\"svasya ca tasya naamnaa paramaayu.h praapnutha tadartham etaani sarvvaa.nyalikhyanta| ");
INSERT INTO sanvel_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tata.h para.m tibiriyaajaladhesta.te yii\"su.h punarapi \"si.syebhyo dar\"sana.m dattavaan dar\"sanasyaakhyaanamidam| ");
INSERT INTO sanvel_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","\"simonpitara.h yamajathomaa gaaliiliiyakaannaanagaranivaasii nithanel sivade.h putraavanyau dvau \"si.syau caite.svekatra milite.su \"simonpitaro.akathayat matsyaan dhartu.m yaami| ");
INSERT INTO sanvel_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tataste vyaaharan tarhi vayamapi tvayaa saarddha.m yaama.h tadaa te bahirgataa.h santa.h k.sipra.m naavam aarohan kintu tasyaa.m rajanyaam ekamapi na praapnuvan| ");
INSERT INTO sanvel_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhaate sati yii\"susta.te sthitavaan kintu sa yii\"suriti \"si.syaa j naatu.m naa\"saknuvan| ");
INSERT INTO sanvel_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadaa yii\"surap.rcchat, he vatsaa sannidhau ki ncit khaadyadravyam aaste? te.avadan kimapi naasti| ");
INSERT INTO sanvel_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadaa so.avadat naukaayaa dak.si.napaar\"sve jaala.m nik.sipata tato lapsyadhve, tasmaat tai rnik.sipte jaale matsyaa etaavanto.apatan yena te jaalamaak.r.sya nottolayitu.m \"saktaa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmaad yii\"so.h priyatama\"si.sya.h pitaraayaakathayat e.sa prabhu rbhavet, e.sa prabhuriti vaaca.m \"srutvaiva \"simon nagnataaheto rmatsyadhaari.na uttariiyavastra.m paridhaaya hrada.m pratyudalamphayat| ");
INSERT INTO sanvel_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","apare \"si.syaa matsyai.h saarddha.m jaalam aakar.santa.h k.sudranaukaa.m vaahayitvaa kuulamaanayan te kuulaad atiduure naasan dvi\"satahastebhyo duura aasan ityanumiiyate| ");
INSERT INTO sanvel_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tiira.m praaptaistaistatra prajvalitaagnistadupari matsyaa.h puupaa\"sca d.r.s.taa.h| ");
INSERT INTO sanvel_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tato yii\"surakathayad yaan matsyaan adharata te.saa.m katipayaan aanayata| ");
INSERT INTO sanvel_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ata.h \"simonpitara.h paraav.rtya gatvaa b.rhadbhistripa ncaa\"sadadhika\"satamatsyai.h paripuur.na.m tajjaalam aak.r.syodatolayat kintvetaavadbhi rmatsyairapi jaala.m naachidyata| ");
INSERT INTO sanvel_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantara.m yii\"sustaan avaadiit yuuyamaagatya bhu.mgdhva.m; tadaa saeva prabhuriti j naatatvaat tva.m ka.h? iti pra.s.tu.m \"si.syaa.naa.m kasyaapi pragalbhataa naabhavat| ");
INSERT INTO sanvel_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tato yii\"suraagatya puupaan matsyaa.m\"sca g.rhiitvaa tebhya.h paryyave.sayat| ");
INSERT INTO sanvel_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ittha.m \"sma\"saanaadutthaanaat para.m yii\"su.h \"si.syebhyast.rtiiyavaara.m dar\"sana.m dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhojane samaapte sati yii\"su.h \"simonpitara.m p.r.s.tavaan, he yuunasa.h putra \"simon tva.m kim etebhyodhika.m mayi priiyase? tata.h sa uditavaan satya.m prabho tvayi priiye.aha.m tad bhavaan jaanaati; tadaa yii\"surakathayat tarhi mama me.sa\"saavakaga.na.m paalaya| ");
INSERT INTO sanvel_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tata.h sa dvitiiyavaara.m p.r.s.tavaan he yuunasa.h putra \"simon tva.m ki.m mayi priiyase? tata.h sa uktavaan satya.m prabho tvayi priiye.aha.m tad bhavaan jaanaati; tadaa yii\"surakathayata tarhi mama me.saga.na.m paalaya| ");
INSERT INTO sanvel_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","pa\"scaat sa t.rtiiyavaara.m p.r.s.tavaan, he yuunasa.h putra \"simon tva.m ki.m mayi priiyase? etadvaakya.m t.rtiiyavaara.m p.r.s.tavaan tasmaat pitaro du.hkhito bhuutvaa.akathayat he prabho bhavata.h kimapyagocara.m naasti tvayyaha.m priiye tad bhavaan jaanaati; tato yii\"suravadat tarhi mama me.saga.na.m paalaya| ");
INSERT INTO sanvel_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","aha.m tubhya.m yathaartha.m kathayaami yauvanakaale svaya.m baddhaka.ti ryatrecchaa tatra yaatavaan kintvita.h para.m v.rddhe vayasi hasta.m vistaarayi.syasi, anyajanastvaa.m baddhvaa yatra gantu.m tavecchaa na bhavati tvaa.m dh.rtvaa tatra ne.syati| ");
INSERT INTO sanvel_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalata.h kiid.r\"sena mara.nena sa ii\"svarasya mahimaana.m prakaa\"sayi.syati tad bodhayitu.m sa iti vaakya.m proktavaan| ityukte sati sa tamavocat mama pa\"scaad aagaccha| ");
INSERT INTO sanvel_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yo jano raatrikaale yii\"so rvak.so.avalambya, he prabho ko bhavanta.m parakare.su samarpayi.syatiiti vaakya.m p.r.s.tavaan, ta.m yii\"so.h priyatama\"si.sya.m pa\"scaad aagacchanta.m ");
INSERT INTO sanvel_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitaro mukha.m paraavarttya vilokya yii\"su.m p.r.s.tavaan, he prabho etasya maanavasya kiid.r\"sii gati rbhavi.syati? ");
INSERT INTO sanvel_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punaraagamanaparyyanta.m yadi ta.m sthaapayitum icchaami tatra tava ki.m? tva.m mama pa\"scaad aagaccha| ");
INSERT INTO sanvel_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmaat sa \"si.syo na mari.syatiiti bhraat.rga.namadhye ki.mvadantii jaataa kintu sa na mari.syatiiti vaakya.m yii\"su rnaavadat kevala.m mama punaraagamanaparyyanta.m yadi ta.m sthaapayitum icchaami tatra tava ki.m? iti vaakyam uktavaan| ");
INSERT INTO sanvel_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yo jana etaani sarvvaa.ni likhitavaan atra saak.sya nca dattavaan saeva sa \"si.sya.h, tasya saak.sya.m pramaa.namiti vaya.m jaaniima.h| ");
INSERT INTO sanvel_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yii\"suretebhyo.aparaa.nyapi bahuuni karmmaa.ni k.rtavaan taani sarvvaa.ni yadyekaika.m k.rtvaa likhyante tarhi granthaa etaavanto bhavanti te.saa.m dhaara.ne p.rthivyaa.m sthaana.m na bhavati| iti||");
INSERT INTO sanvel_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","he thiyaphila, yii\"su.h svamanoniitaan preritaan pavitre.naatmanaa samaadi\"sya yasmin dine svargamaarohat yaa.m yaa.m kriyaamakarot yadyad upaadi\"sacca taani sarvvaa.ni puurvva.m mayaa likhitaani| ");
INSERT INTO sanvel_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanadu.hkhabhogaat param anekapratyayak.sapramaa.nau.h sva.m sajiiva.m dar\"sayitvaa ");
INSERT INTO sanvel_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","catvaari.m\"saddinaani yaavat tebhya.h preritebhyo dar\"sana.m dattve\"svariiyaraajyasya var.nanama akarot| ");
INSERT INTO sanvel_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantara.m te.saa.m sabhaa.m k.rtvaa ityaaj naapayat, yuuya.m yiruu\"saalamo.anyatra gamanamak.rtvaa yastin pitraa\"ngiik.rte mama vadanaat kathaa a\"s.r.nuta tatpraaptim apek.sya ti.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yohan jale majjitaavaan kintvalpadinamadhye yuuya.m pavitra aatmani majjitaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","pa\"scaat te sarvve militvaa tam ap.rcchan he prabho bhavaan kimidaanii.m punarapi raajyam israayeliiyalokaanaa.m kare.su samarpayi.syati? ");
INSERT INTO sanvel_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tata.h sovadat yaan sarvvaan kaalaan samayaa.m\"sca pitaa svava\"se.asthaapayat taan j naat.r.m yu.smaakam adhikaaro na jaayate| ");
INSERT INTO sanvel_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yu.smaasu pavitrasyaatmana aavirbhaave sati yuuya.m \"sakti.m praapya yiruu\"saalami samastayihuudaa\"somiro.nade\"sayo.h p.rthivyaa.h siimaa.m yaavad yaavanto de\"saaste.su yarvve.su ca mayi saak.sya.m daasyatha| ");
INSERT INTO sanvel_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vaakyamuktvaa sa te.saa.m samak.sa.m svarga.m niito.abhavat, tato meghamaaruhya te.saa.m d.r.s.teragocaro.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samaye te vihaayasa.m pratyananyad.r.s.tyaa tasya taad.r\"sam uurdvvagamanam apa\"syan tasminneva samaye \"suklavastrau dvau janau te.saa.m sannidhau da.n.daayamaanau kathitavantau, ");
INSERT INTO sanvel_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","he gaaliiliiyalokaa yuuya.m kimartha.m gaga.na.m prati niriik.sya da.n.daayamaanaasti.s.thatha? yu.smaaka.m samiipaat svarga.m niito yo yii\"susta.m yuuya.m yathaa svargam aarohantam adar\"sam tathaa sa puna\"scaagami.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tata.h para.m te jaitunanaamna.h parvvataad vi\"sraamavaarasya patha.h parimaa.nam arthaat praaye.naarddhakro\"sa.m durastha.m yiruu\"saalamnagara.m paraav.rtyaagacchan| ");
INSERT INTO sanvel_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagara.m pravi\"sya pitaro yaakuub yohan aandriya.h philipa.h thomaa barthajamayo mathiraalphiiyaputro yaakuub udyogaaी \"simon yaakuubo bhraataa yihuudaa ete sarvve yatra sthaane pravasanti tasmin uparitanaprako.s.the praavi\"san| ");
INSERT INTO sanvel_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","pa\"scaad ime kiyatya.h striya\"sca yii\"so rmaataa mariyam tasya bhraatara\"scaite sarvva ekacittiibhuuta satata.m vinayena vinayena praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samaye tatra sthaane saakalyena vi.m\"satyadhika\"sata.m \"si.syaa aasan| tata.h pitaraste.saa.m madhye ti.s.than uktavaan ");
INSERT INTO sanvel_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","he bhraat.rga.na yii\"sudhaari.naa.m lokaanaa.m pathadar\"sako yo yihuudaastasmin daayuudaa pavitra aatmaa yaa.m kathaa.m kathayaamaasa tasyaa.h pratyak.siibhavanasyaava\"syakatvam aasiit| ");
INSERT INTO sanvel_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa jano.asmaaka.m madhyavarttii san asyaa.h sevaayaa a.m\"sam alabhata| ");
INSERT INTO sanvel_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantara.m kukarmma.naa labdha.m yanmuulya.m tena k.setrameka.m kriitam apara.m tasmin adhomukhe bh.rmau patite sati tasyodarasya vidiir.natvaat sarvvaa naa.dyo niragacchan| ");
INSERT INTO sanvel_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","etaa.m kathaa.m yiruu\"saalamnivaasina.h sarvve lokaa vidaanti; te.saa.m nijabhaa.sayaa tatk.setra nca hakaldaamaa, arthaat raktak.setramiti vikhyaatamaaste| ");
INSERT INTO sanvel_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyacca, niketana.m tadiiyantu \"sunyameva bhavi.syati| tasya duu.sye nivaasaartha.m kopi sthaasyati naiva hi| anya eva janastasya pada.m sa.mpraapsyati dhruva.m| ittha.m giitapustake likhitamaaste| ");
INSERT INTO sanvel_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ato yohano majjanam aarabhyaasmaaka.m samiipaat prabho ryii\"so.h svargaaroha.nadina.m yaavat sosmaaka.m madhye yaavanti dinaani yaapitavaan ");
INSERT INTO sanvel_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","taavanti dinaani ye maanavaa asmaabhi.h saarddha.m ti.s.thanti te.saam ekena janenaasmaabhi.h saarddha.m yii\"sorutthaane saak.si.naa bhavitavya.m| ");
INSERT INTO sanvel_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ato yasya ruu.dhi ryu.s.to ya.m bar\"sabbetyuktvaahuuyanti sa yuu.saph matathi\"sca dvaavetau p.rthak k.rtvaa ta ii\"svarasya sannidhau praaryya kathitavanta.h, ");
INSERT INTO sanvel_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","he sarvvaantaryyaamin parame\"svara, yihuudaa.h sevanapreritatvapadacyuta.h ");
INSERT INTO sanvel_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthaanam agacchat, tatpada.m labdhum enayo rjanayo rmadhye bhavataa ko.abhirucitastadasmaan dar\"syataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tato gu.tikaapaa.te k.rte matathirniraciiyata tasmaat sonye.saam ekaada\"saanaa.m praritaanaa.m madhye ga.nitobhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","apara nca nistaarotsavaat para.m pa ncaa\"sattame dine samupasthite sati te sarvve ekaacittiibhuuya sthaana ekasmin militaa aasan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","etasminneva samaye.akasmaad aakaa\"saat praca.n.daatyugravaayo.h \"sabdavad eka.h \"sabda aagatya yasmin g.rhe ta upaavi\"san tad g.rha.m samasta.m vyaapnot| ");
INSERT INTO sanvel_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tata.h para.m vahni\"sikhaasvaruupaa jihvaa.h pratyak.siibhuuya vibhaktaa.h satya.h pratijanorddhve sthagitaa abhuuvan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmaat sarvve pavitre.naatmanaa paripuur.naa.h santa aatmaa yathaa vaacitavaan tadanusaare.naanyade\"siiyaanaa.m bhaa.saa uktavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samaye p.rthiviisthasarvvade\"sebhyo yihuudiiyamataavalambino bhaktalokaa yiruu\"saalami praavasan; ");
INSERT INTO sanvel_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyaa.h kathaayaa.h ki.mvadantyaa jaatatvaat sarvve lokaa militvaa nijanijabhaa.sayaa \"si.syaa.naa.m kathaakathana.m \"srutvaa samudvignaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaeva vismayaapannaa aa\"scaryyaanvitaa\"sca santa.h paraspara.m uktavanta.h pa\"syata ye kathaa.m kathayanti te sarvve gaaliiliiyalokaa.h ki.m na bhavanti? ");
INSERT INTO sanvel_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vaya.m pratyeka\"sa.h svasvajanmade\"siiyabhaa.saabhi.h kathaa ete.saa.m \"s.r.numa.h kimida.m? ");
INSERT INTO sanvel_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","paarthii-maadii-araamnaharayimde\"sanivaasimano yihuudaa-kappadakiyaa-panta-aa\"siyaa- ");
INSERT INTO sanvel_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyaa-pamphuliyaa-misaranivaasina.h kurii.niinika.tavarttiluubiiyaprade\"sanivaasino romanagaraad aagataa yihuudiiyalokaa yihuudiiyamatagraahi.na.h kriitiiyaa araabiiyaadayo lokaa\"sca ye vayam ");
INSERT INTO sanvel_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmaaka.m nijanijabhaa.saabhirete.saam ii\"svariiyamahaakarmmavyaakhyaana.m \"s.r.numa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ittha.m te sarvvaeva vismayaapannaa.h sandigdhacittaa.h santa.h parasparamuucu.h, asya ko bhaava.h? ");
INSERT INTO sanvel_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","apare kecit parihasya kathitavanta ete naviinadraak.saarasena mattaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadaa pitara ekaada\"sabhi rjanai.h saaka.m ti.s.than taallokaan uccai.hkaaram avadat, he yihuudiiyaa he yiruu\"saalamnivaasina.h sarvve, avadhaana.m k.rtvaa madiiyavaakya.m budhyadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idaaniim ekayaamaad adhikaa velaa naasti tasmaad yuuya.m yad anumaatha maanavaa ime madyapaanena mattaastanna| ");
INSERT INTO sanvel_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yoyelbhavi.syadvaktraitadvaakyamukta.m yathaa, ");
INSERT INTO sanvel_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ii\"svara.h kathayaamaasa yugaantasamaye tvaham| var.si.syaami svamaatmaana.m sarvvapraa.nyupari dhruvam| bhaavivaakya.m vadi.syanti kanyaa.h putraa\"sca vastuta.h|pratyaade\"sa nca praapsyanti yu.smaaka.m yuvamaanavaa.h| tathaa praaciinalokaastu svapnaan drak.syanti ni\"scita.m| ");
INSERT INTO sanvel_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","var.si.syaami tadaatmaana.m daasadaasiijanopiri| tenaiva bhaavivaakya.m te vadi.syanti hi sarvva\"sa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","uurddhvasthe gaga.ne caiva niicasthe p.rthiviitale| \"so.nitaani b.rhadbhaanuun ghanadhuumaadikaani ca| cihnaani dar\"sayi.syaami mahaa\"scaryyakriyaastathaa| ");
INSERT INTO sanvel_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahaabhayaanakasyaiva taddinasya pare\"situ.h| puraagamaad ravi.h k.r.s.no rakta\"scandro bhavi.syata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu ya.h parame\"sasya naamni sampraarthayi.syate| saeva manujo nuuna.m paritraato bhavi.syati|| ");
INSERT INTO sanvel_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ato he israayelva.m\"siiyalokaa.h sarvve kathaayaametasyaam mano nidhaddhva.m naasaratiiyo yii\"surii\"svarasya manoniita.h pumaan etad ii\"svarastatk.rtairaa\"scaryyaadbhutakarmmabhi rlak.sa.nai\"sca yu.smaaka.m saak.saadeva pratipaaditavaan iti yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yii\"sau ii\"svarasya puurvvani\"scitamantra.naaniruupa.naanusaare.na m.rtyau samarpite sati yuuya.m ta.m dh.rtvaa du.s.talokaanaa.m hastai.h kru\"se vidhitvaahata| ");
INSERT INTO sanvel_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvii\"svarasta.m nidhanasya bandhanaanmocayitvaa udasthaapayat yata.h sa m.rtyunaa baddhasti.s.thatiiti na sambhavati| ");
INSERT INTO sanvel_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","etastin daayuudapi kathitavaan yathaa, sarvvadaa mama saak.saatta.m sthaapaya parame\"svara.m| sthite maddak.si.ne tasmin skhali.syaami tvaha.m nahi| ");
INSERT INTO sanvel_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","aanandi.syati taddheto rmaamakiina.m manastu vai| aahlaadi.syati jihvaapi madiiyaa tu tathaiva ca| pratyaa\"sayaa \"sariirantu madiiya.m vai\"sayi.syate| ");
INSERT INTO sanvel_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paraloke yato hetostva.m maa.m naiva hi tyak.syasi| svakiiya.m pu.nyavanta.m tva.m k.sayitu.m naiva daasyasi| eva.m jiivanamaarga.m tva.m maameva dar\"sayi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhe ya aanando dak.si.ne svasya yat sukha.m| ananta.m tena maa.m puur.na.m kari.syasi na sa.m\"saya.h|| ");
INSERT INTO sanvel_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","he bhraataro.asmaaka.m tasya puurvvapuru.sasya daayuuda.h kathaa.m spa.s.ta.m kathayitu.m maam anumanyadhva.m, sa praa.naan tyaktvaa \"sma\"saane sthaapitobhavad adyaapi tat \"sma\"saanam asmaaka.m sannidhau vidyate| ");
INSERT INTO sanvel_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalato laukikabhaavena daayuudo va.m\"se khrii.s.ta.m janma graahayitvaa tasyaiva si.mhaasane samuve.s.tu.m tamutthaapayi.syati parame\"svara.h \"sapatha.m kutvaa daayuuda.h samiipa imam a\"ngiikaara.m k.rtavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti j naatvaa daayuud bhavi.syadvaadii san bhavi.syatkaaliiyaj naanena khrii.s.totthaane kathaamimaa.m kathayaamaasa yathaa tasyaatmaa paraloke na tyak.syate tasya \"sariira nca na k.se.syati; ");
INSERT INTO sanvel_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ata.h parame\"svara ena.m yii\"su.m \"sma\"saanaad udasthaapayat tatra vaya.m sarvve saak.si.na aasmahe| ");
INSERT INTO sanvel_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa ii\"svarasya dak.si.nakare.nonnati.m praapya pavitra aatmina pitaa yama\"ngiikaara.m k.rtavaan tasya phala.m praapya yat pa\"syatha \"s.r.nutha ca tadavar.sat| ");
INSERT INTO sanvel_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yato daayuud svarga.m naaruroha kintu svayam imaa.m kathaam akathayad yathaa, mama prabhumida.m vaakyamavadat parame\"svara.h| ");
INSERT INTO sanvel_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava \"satruunaha.m yaavat paadapii.tha.m karomi na| taavat kaala.m madiiye tva.m dak.savaar\"sva upaavi\"sa| ");
INSERT INTO sanvel_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ato ya.m yii\"su.m yuuya.m kru\"se.ahata parame\"svarasta.m prabhutvaabhi.siktatvapade nyayu.mkteti israayeliiyaa lokaa ni\"scita.m jaanantu| ");
INSERT INTO sanvel_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","etaad.r\"sii.m kathaa.m \"srutvaa te.saa.m h.rdayaanaa.m vidiir.natvaat te pitaraaya tadanyapreritebhya\"sca kathitavanta.h, he bhraat.rga.na vaya.m ki.m kari.syaama.h? ");
INSERT INTO sanvel_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tata.h pitara.h pratyavadad yuuya.m sarvve sva.m sva.m mana.h parivarttayadhva.m tathaa paapamocanaartha.m yii\"sukhrii.s.tasya naamnaa majjitaa\"sca bhavata, tasmaad daanaruupa.m paritram aatmaana.m lapsyatha| ");
INSERT INTO sanvel_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yato yu.smaaka.m yu.smatsantaanaanaa nca duurasthasarvvalokaanaa nca nimittam arthaad asmaaka.m prabhu.h parame\"svaro yaavato laakaan aahvaasyati te.saa.m sarvve.saa.m nimittam ayama\"ngiikaara aaste| ");
INSERT INTO sanvel_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","etadanyaabhi rbahukathaabhi.h pramaa.na.m datvaakathayat etebhyo vipathagaamibhyo varttamaanalokebhya.h svaan rak.sata| ");
INSERT INTO sanvel_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tata.h para.m ye saanandaastaa.m kathaam ag.rhlan te majjitaa abhavan| tasmin divase praaye.na trii.ni sahasraa.ni lokaaste.saa.m sapak.saa.h santa.h ");
INSERT INTO sanvel_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","preritaanaam upade\"se sa\"ngatau puupabha njane praarthanaasu ca mana.hsa.myoga.m k.rtvaati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","preritai rnaanaaprakaaralak.sa.ne.su mahaa\"scaryyakarmamasu ca dar\"site.su sarvvalokaanaa.m bhayamupasthita.m| ");
INSERT INTO sanvel_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","vi\"svaasakaari.na.h sarvva ca saha ti.s.thanata.h| sve.saa.m sarvvaa.h sampattii.h saadhaara.nyena sthaapayitvaabhu njata| ");
INSERT INTO sanvel_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalato g.rhaa.ni dravyaa.ni ca sarvvaa.ni vikriiya sarvve.saa.m svasvaprayojanaanusaare.na vibhajya sarvvebhyo.adadan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva ekacittiibhuuya dine dine mandire santi.s.thamaanaa g.rhe g.rhe ca puupaanabha njanta ii\"svarasya dhanyavaada.m kurvvanto lokai.h samaad.rtaa.h paramaanandena saralaanta.hkara.nena bhojana.m paana ncakurvvan| ");
INSERT INTO sanvel_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","parame\"svaro dine dine paritraa.nabhaajanai rma.n.daliim avarddhayat| ");
INSERT INTO sanvel_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","t.rtiiyayaamavelaayaa.m satyaa.m praarthanaayaa.h samaye pitarayohanau sambhuuya mandira.m gacchata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminneva samaye mandiraprave\"sakaanaa.m samiipe bhik.saara.naartha.m ya.m janmakha njamaanu.sa.m lokaa mandirasya sundaranaamni dvaare pratidinam asthaapayan ta.m vahantastadvaara.m aanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadaa pitarayohanau mantira.m prave.s.tum udyatau vilokya sa kha njastau ki ncid bhik.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmaad yohanaa sahita.h pitarastam ananyad.r.s.tyaa niriik.sya proktavaan aavaa.m prati d.r.s.ti.m kuru| ");
INSERT INTO sanvel_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tata.h sa ki ncit praaptyaa\"sayaa tau prati d.r.s.ti.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadaa pitaro gaditavaan mama nika.te svar.naruupyaadi kimapi naasti kintu yadaaste tad dadaami naasaratiiyasya yii\"sukhrii.s.tasya naamnaa tvamutthaaya gamanaagamane kuru| ");
INSERT INTO sanvel_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tata.h para.m sa tasya dak.si.nakara.m dh.rtvaa tam udatolayat; tena tatk.sa.naat tasya janasya paadagulphayo.h sabalatvaat sa ullamphya protthaaya gamanaagamane .akarot| ");
INSERT INTO sanvel_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tato gamanaagamane kurvvan ullamphan ii\"svara.m dhanya.m vadan taabhyaa.m saarddha.m mandira.m praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tata.h sarvve lokaasta.m gamanaagamane kurvvantam ii\"svara.m dhanya.m vadanta nca vilokya ");
INSERT INTO sanvel_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundare dvaare ya upavi\"sya bhik.sitavaan saevaayam iti j naatvaa ta.m prati tayaa gha.tanayaa camatk.rtaa vismayaapannaa\"scaabhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ya.h kha nja.h svasthobhavat tena pitarayohano.h karayordh.tatayo.h sato.h sarvve lokaa sannidhim aagacchan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad d.r.s.tvaa pitarastebhyo.akathayat, he israayeliiyalokaa yuuya.m kuto .anenaa\"scaryya.m manyadhve? aavaa.m nija\"saktyaa yadvaa nijapu.nyena kha njamanu.syamena.m gamitavantaaviti cintayitvaa aavaa.m prati kuto.ananyad.r.s.ti.m kurutha? ");
INSERT INTO sanvel_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ya.m yii\"su.m yuuya.m parakare.su samaarpayata tato ya.m piilaato mocayitum eैcchat tathaapi yuuya.m tasya saak.saan naa\"ngiik.rtavanta ibraahiima ishaako yaakuuba\"sce\"svaro.arthaad asmaaka.m puurvvapuru.saa.naam ii\"svara.h svaputrasya tasya yii\"so rmahimaana.m praakaa\"sayat| ");
INSERT INTO sanvel_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yuuya.m ta.m pavitra.m dhaarmmika.m pumaa.msa.m naa\"ngiik.rtya hatyaakaari.nameka.m svebhyo daatum ayaacadhva.m| ");
INSERT INTO sanvel_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","pa\"scaat ta.m jiivanasyaadhipatim ahata kintvii\"svara.h \"sma\"saanaat tam udasthaapayata tatra vaya.m saak.si.na aasmahe| ");
INSERT INTO sanvel_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ima.m ya.m maanu.sa.m yuuya.m pa\"syatha paricinutha ca sa tasya naamni vi\"svaasakara.naat calana\"sakti.m labdhavaan tasmin tasya yo vi\"svaasa.h sa ta.m yu.smaaka.m sarvve.saa.m saak.saat sampuur.naruupe.na svastham akaar.siit| ");
INSERT INTO sanvel_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","he bhraataro yuuya.m yu.smaakam adhipataya\"sca aj naatvaa karmmaa.nyetaani k.rtavanta idaanii.m mamai.sa bodho jaayate| ");
INSERT INTO sanvel_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvii\"svara.h khrii.s.tasya du.hkhabhoge bhavi.syadvaadinaa.m mukhebhyo yaa.m yaa.m kathaa.m puurvvamakathayat taa.h kathaa ittha.m siddhaa akarot| ");
INSERT INTO sanvel_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ata.h sve.saa.m paapamocanaartha.m kheda.m k.rtvaa manaa.msi parivarttayadhva.m, tasmaad ii\"svaraat saantvanaapraapte.h samaya upasthaasyati; ");
INSERT INTO sanvel_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","puna\"sca puurvvakaalam aarabhya pracaarito yo yii\"sukhrii.s.tastam ii\"svaro yu.smaan prati pre.sayi.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagata.h s.r.s.timaarabhya ii\"svaro nijapavitrabhavi.syadvaadiga.nona yathaa kathitavaan tadanusaare.na sarvve.saa.m kaaryyaa.naa.m siddhiparyyanta.m tena svarge vaasa.h karttavya.h| ");
INSERT INTO sanvel_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yu.smaaka.m prabhu.h parame\"svaro yu.smaaka.m bhraat.rga.namadhyaat matsad.r\"sa.m bhavi.syadvaktaaram utpaadayi.syati, tata.h sa yat ki ncit kathayi.syati tatra yuuya.m manaa.msi nidhaddhva.m| ");
INSERT INTO sanvel_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu ya.h ka\"scit praa.nii tasya bhavi.syadvaadina.h kathaa.m na grahii.syati sa nijalokaanaa.m madhyaad ucchetsyate,\" imaa.m kathaam asmaaka.m puurvvapuru.sebhya.h kevalo muusaa.h kathayaamaasa iti nahi, ");
INSERT INTO sanvel_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","\"simuuyelbhavi.syadvaadinam aarabhya yaavanto bhavi.syadvaakyam akathayan te sarvvaeva samayasyaitasya kathaam akathayan| ");
INSERT INTO sanvel_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yuuyamapi te.saa.m bhavi.syadvaadinaa.m santaanaa.h, \"tava va.m\"sodbhavapu.msaa sarvvade\"siiyaa lokaa aa\"si.sa.m praaptaa bhavi.syanti\", ibraahiime kathaametaa.m kathayitvaa ii\"svarosmaaka.m puurvvapuru.sai.h saarddha.m ya.m niyama.m sthiriik.rtavaan tasya niyamasyaadhikaari.nopi yuuya.m bhavatha| ");
INSERT INTO sanvel_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata ii\"svaro nijaputra.m yii\"sum utthaapya yu.smaaka.m sarvve.saa.m svasvapaapaat paraavarttya yu.smabhyam aa\"si.sa.m daatu.m prathamatasta.m yu.smaaka.m nika.ta.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samaye pitarayohanau lokaan upadi\"satastasmin samaye yaajakaa mandirasya senaapataya.h siduukiiga.na\"sca ");
INSERT INTO sanvel_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayor upade\"sakara.ne khrii.s.tasyotthaanam upalak.sya sarvve.saa.m m.rtaanaam utthaanaprastaave ca vyagraa.h santastaavupaagaman| ");
INSERT INTO sanvel_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dh.rtvaa dinaavasaanakaara.naat paradinaparyyananta.m ruddhvaa sthaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathaapi ye lokaastayorupade\"sam a\"s.r.nvan te.saa.m praaye.na pa ncasahasraa.ni janaa vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","pare.ahani adhipataya.h praaciinaa adhyaapakaa\"sca haanananaamaa mahaayaajaka.h ");
INSERT INTO sanvel_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphaa yohan sikandara ityaadayo mahaayaajakasya j naataya.h sarvve yiruu\"saalamnagare militaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantara.m preritau madhye sthaapayitvaap.rcchan yuvaa.m kayaa \"saktayaa vaa kena naamnaa karmmaa.nyetaani kurutha.h? ");
INSERT INTO sanvel_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadaa pitara.h pavitre.naatmanaa paripuur.na.h san pratyavaadiit, he lokaanaam adhipatiga.na he israayeliiyapraaciinaa.h, ");
INSERT INTO sanvel_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","etasya durbbalamaanu.sasya hita.m yat karmmaakriyata, arthaat, sa yena prakaare.na svasthobhavat tacced adyaavaa.m p.rcchatha, ");
INSERT INTO sanvel_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva israayeेliiyalokaa yuuya.m jaaniita naasaratiiyo yo yii\"sukhrii.s.ta.h kru\"se yu.smaabhiravidhyata ya\"sce\"svare.na \"sma\"saanaad utthaapita.h, tasya naamnaa janoya.m svastha.h san yu.smaaka.m sammukhe protti.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nicet.rbhi ryu.smaabhiraya.m ya.h prastaro.avaj naato.abhavat sa pradhaanako.nasya prastaro.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnaadaparaat kasmaadapi paritraa.na.m bhavitu.m na \"saknoti, yena traa.na.m praapyeta bhuuma.n.dalasyalokaanaa.m madhye taad.r\"sa.m kimapi naama naasti| ");
INSERT INTO sanvel_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadaa pitarayohanoretaad.r\"siim ak.sebhataa.m d.r.s.tvaa taavavidvaa.msau niicalokaaviti buddhvaa aa\"scaryyam amanyanta tau ca yii\"so.h sa\"nginau jaataaviti j naatum a\"saknuvan| ");
INSERT INTO sanvel_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu taabhyaa.m saarddha.m ta.m svasthamaanu.sa.m ti.s.thanta.m d.r.s.tvaa te kaamapyaparaam aapatti.m kartta.m naa\"saknun| ");
INSERT INTO sanvel_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadaa te sabhaata.h sthaanaantara.m gantu.m taan aaj naapya svaya.m parasparam iti mantra.naamakurvvan ");
INSERT INTO sanvel_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau maanavau prati ki.m karttavya.m? taaveka.m prasiddham aa\"scaryya.m karmma k.rtavantau tad yiruu\"saalamnivaasinaa.m sarvve.saa.m lokaanaa.m samiipe praakaa\"sata tacca vayamapahnotu.m na \"saknuma.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lokaanaa.m madhyam etad yathaa na vyaapnoti tadartha.m tau bhaya.m pradar\"sya tena naamnaa kamapi manu.sya.m nopadi\"satam iti d.r.dha.m ni.sedhaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tataste preritaavaahuuya etadaaj naapayan ita.h para.m yii\"so rnaamnaa kadaapi kaamapi kathaa.m maa kathayata.m kimapi nopadi\"sa nca| ");
INSERT INTO sanvel_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tata.h pitarayohanau pratyavadataam ii\"svarasyaaj naagraha.na.m vaa yu.smaakam aaj naagraha.nam etayo rmadhye ii\"svarasya gocare ki.m vihita.m? yuuya.m tasya vivecanaa.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vaya.m yad apa\"syaama yada\"s.r.numa ca tanna pracaarayi.syaama etat kadaapi bhavitu.m na \"saknoti| ");
INSERT INTO sanvel_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadagha.tata tad d.r.s.taa sarvve lokaa ii\"svarasya gu.naan anvavadan tasmaat lokabhayaat tau da.n.dayitu.m kamapyupaaya.m na praapya te punarapi tarjayitvaa taavatyajan| ");
INSERT INTO sanvel_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya maanu.sasyaitat svaasthyakara.nam aa\"scaryya.m karmmaakriyata tasya vaya\"scatvaari.m\"sadvatsaraa vyatiitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tata.h para.m tau vis.r.s.tau santau svasa\"nginaa.m sannidhi.m gatvaa pradhaanayaajakai.h praaciinalokai\"sca proktaa.h sarvvaa.h kathaa j naapitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tacchrutvaa sarvva ekacittiibhuuya ii\"svaramuddi\"sya proccairetat praarthayanta, he prabho gaga.nap.rthiviipayodhiinaa.m te.su ca yadyad aaste te.saa.m sra.s.te\"svarastva.m| ");
INSERT INTO sanvel_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tva.m nijasevakena daayuudaa vaakyamidam uvacitha, manu.syaa anyade\"siiyaa.h kurvvanti kalaha.m kuta.h| lokaa.h sarvve kimartha.m vaa cintaa.m kurvvanti ni.sphalaa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","parame\"sasya tenaivaabhi.siktasya janasya ca| viruddhamabhiti.s.thanti p.rthivyaa.h pataya.h kuta.h|| ");
INSERT INTO sanvel_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastena mantra.nayaa ca puurvva yadyat sthiriik.rta.m tad yathaa siddha.m bhavati tadartha.m tva.m yam athi.siktavaan sa eva pavitro yii\"sustasya praatikuulyena herod pantiiyapiilaato ");
INSERT INTO sanvel_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28",".anyade\"siiyalokaa israayellokaa\"sca sarvva ete sabhaayaam ati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","he parame\"svara adhunaa te.saa.m tarjana.m garjana nca \"s.r.nu; ");
INSERT INTO sanvel_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathaa svaasthyakara.nakarmma.naa tava baahubalaprakaa\"sapuurvvaka.m tava sevakaan nirbhayena tava vaakya.m pracaarayitu.m tava pavitraputrasya yii\"so rnaamnaa aa\"scaryyaa.nyasambhavaani ca karmmaa.ni karttu ncaaj naapaya| ");
INSERT INTO sanvel_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ittha.m praarthanayaa yatra sthaane te sabhaayaam aasan tat sthaana.m praakampata; tata.h sarvve pavitre.naatmanaa paripuur.naa.h santa ii\"svarasya kathaam ak.sobhe.na praacaarayan| ");
INSERT INTO sanvel_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","apara nca pratyayakaarilokasamuuhaa ekamanasa ekacittiibhuuya sthitaa.h| te.saa.m kepi nijasampatti.m sviiyaa.m naajaanan kintu te.saa.m sarvvaa.h sampattya.h saadhaara.nyena sthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyacca preritaa mahaa\"saktiprakaa\"sapuurvvaka.m prabho ryii\"sorutthaane saak.syam adadu.h, te.su sarvve.su mahaanugraho.abhavacca| ");
INSERT INTO sanvel_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","te.saa.m madhye kasyaapi dravyanyuunataa naabhavad yataste.saa.m g.rhabhuumyaadyaa yaa.h sampattaya aasan taa vikriiya ");
INSERT INTO sanvel_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmuulyamaaniiya preritaanaa.m cara.ne.su tai.h sthaapita.m; tata.h pratyeka\"sa.h prayojanaanusaare.na dattamabhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","vi\"se.sata.h kupropadviipiiyo yosinaamako leviva.m\"sajaata eko jano bhuumyadhikaarii, ya.m preritaa bar.nabbaa arthaat saantvanaadaayaka ityuktvaa samaahuuyan, ");
INSERT INTO sanvel_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa jano nijabhuumi.m vikriiya tanmuulyamaaniiya preritaanaa.m cara.ne.su sthaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadaa anaaniyanaamaka eko jano yasya bhaaryyaayaa naama saphiiraa sa svaadhikaara.m vikriiya ");
INSERT INTO sanvel_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhaaryyaa.m j naapayitvaa tanmuulyasyaikaa.m\"sa.m sa\"ngopya sthaapayitvaa tadanyaa.m\"samaatramaaniiya preritaanaa.m cara.ne.su samarpitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmaat pitarokathayat he anaaniya bhuume rmuulya.m ki ncit sa\"ngopya sthaapayitu.m pavitrasyaatmana.h sannidhau m.r.saavaakya.m kathayitu nca \"saitaan kutastavaanta.hkara.ne prav.rttimajanayat? ");
INSERT INTO sanvel_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","saa bhuumi ryadaa tava hastagataa tadaa ki.m tava sviiyaa naasiit? tarhi svaanta.hkara.ne kuta etaad.r\"sii kukalpanaa tvayaa k.rtaa? tva.m kevalamanu.syasya nika.te m.r.saavaakya.m naavaadii.h kintvii\"svarasya nika.te.api| ");
INSERT INTO sanvel_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","etaa.m kathaa.m \"srutvaiva so.anaaniyo bhuumau patan praa.naan atyajat, tadv.rttaanta.m yaavanto lokaa a\"s.r.nvan te.saa.m sarvve.saa.m mahaabhayam ajaayat| ");
INSERT INTO sanvel_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadaa yuvalokaasta.m vastre.naacchaadya bahi rniitvaa \"sma\"saane.asthaapayan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tata.h praharaikaanantara.m ki.m v.rtta.m tannaavagatya tasya bhaaryyaapi tatra samupasthitaa| ");
INSERT INTO sanvel_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tata.h pitarastaam ap.rcchat, yuvaabhyaam etaavanmudraabhyo bhuumi rvikriitaa na vaa? etatva.m vada; tadaa saa pratyavaadiit satyam etaavadbhyo mudraabhya eva| ");
INSERT INTO sanvel_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tata.h pitarokathayat yuvaa.m katha.m parame\"svarasyaatmaana.m pariik.situm ekamantra.naavabhavataa.m? pa\"sya ye tava pati.m \"sma\"saane sthaapitavantaste dvaarasya samiipe samupati.s.thanti tvaamapi bahirne.syanti| ");
INSERT INTO sanvel_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tata.h saapi tasya cara.nasannidhau patitvaa praa.naan atyaak.siit| pa\"scaat te yuvaano.abhyantaram aagatya taamapi m.rtaa.m d.r.s.tvaa bahi rniitvaa tasyaa.h patyu.h paar\"sve \"sma\"saane sthaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmaat ma.n.dalyaa.h sarvve lokaa anyalokaa\"sca taa.m vaarttaa.m \"srutvaa saadhvasa.m gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tata.h para.m preritaanaa.m hastai rlokaanaa.m madhye bahvaa\"scaryyaa.nyadbhutaani karmmaa.nyakriyanta; tadaa \"si.syaa.h sarvva ekacittiibhuuya sulemaano .alinde sambhuuyaasan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","te.saa.m sa\"nghaantargo bhavitu.m kopi pragalbhataa.m naagamat kintu lokaastaan samaadriyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striya.h puru.saa\"sca bahavo lokaa vi\"svaasya prabhu.m \"sara.namaapannaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanaagamanaabhyaa.m kenaapi prakaare.na tasya chaayaa kasmi.m\"scijjane lagi.syatiityaa\"sayaa lokaa rogi.na.h \"sivikayaa kha.tvayaa caaniiya pathi pathi sthaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","caturdiksthanagarebhyo bahavo lokaa.h sambhuuya rogi.no.apavitrabhutagrastaa.m\"sca yiruu\"saalamam aanayan tata.h sarvve svasthaa akriyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantara.m mahaayaajaka.h siduukinaa.m matagraahi.naste.saa.m sahacaraa\"sca ");
INSERT INTO sanvel_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahaakrodhaantvitaa.h santa.h preritaan dh.rtvaa niicalokaanaa.m kaaraayaa.m baddhvaa sthaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu raatrau parame\"svarasya duuta.h kaaraayaa dvaara.m mocayitvaa taan bahiraaniiyaakathayat, ");
INSERT INTO sanvel_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yuuya.m gatvaa mandire da.n.daayamaanaa.h santo lokaan pratiimaa.m jiivanadaayikaa.m sarvvaa.m kathaa.m pracaarayata| ");
INSERT INTO sanvel_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti \"srutvaa te pratyuu.se mandira upasthaaya upadi.s.tavanta.h| tadaa sahacaraga.nena sahito mahaayaajaka aagatya mantriga.nam israayelva.m\"sasya sarvvaan raajasabhaasada.h sabhaasthaan k.rtvaa kaaraayaastaan aapayitu.m padaatiga.na.m preritavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tataste gatvaa kaaraayaa.m taan apraapya pratyaagatya iti vaarttaam avaadi.su.h, ");
INSERT INTO sanvel_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vaya.m tatra gatvaa nirvvighna.m kaaraayaa dvaara.m ruddha.m rak.sakaa.m\"sca dvaarasya bahirda.n.daayamaanaan adar\"saama eva kintu dvaara.m mocayitvaa tanmadhye kamapi dra.s.tu.m na praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","etaa.m kathaa.m \"srutvaa mahaayaajako mandirasya senaapati.h pradhaanayaajakaa\"sca, ita para.m kimapara.m bhavi.syatiiti cintayitvaa sandigdhacittaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","etasminneva samaye ka\"scit jana aagatya vaarttaametaam avadat pa\"syata yuuya.m yaan maanavaan kaaraayaam asthaapayata te mandire ti.s.thanto lokaan upadi\"santi| ");
INSERT INTO sanvel_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadaa mandirasya senaapati.h padaataya\"sca tatra gatvaa cellokaa.h paa.saa.naan nik.sipyaasmaan maarayantiiti bhiyaa vinatyaacaara.m taan aanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","te mahaasabhaayaa madhye taan asthaapayan tata.h para.m mahaayaajakastaan ap.rcchat, ");
INSERT INTO sanvel_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anena naamnaa samupade.s.tu.m vaya.m ki.m d.r.dha.m na nya.sedhaama? tathaapi pa\"syata yuuya.m sve.saa.m tenopade\"sene yiruu\"saalama.m paripuur.na.m k.rtvaa tasya janasya raktapaatajanitaaparaadham asmaan pratyaanetu.m ce.s.tadhve| ");
INSERT INTO sanvel_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tata.h pitaronyapreritaa\"sca pratyavadan maanu.sasyaaj naagraha.naad ii\"svarasyaaj naagraha.nam asmaakamucitam| ");
INSERT INTO sanvel_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ya.m yii\"su.m yuuya.m kru\"se vedhitvaahata tam asmaaka.m pait.rka ii\"svara utthaapya ");
INSERT INTO sanvel_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","israayelva.m\"saanaa.m mana.hparivarttana.m paapak.samaa nca karttu.m raajaana.m paritraataara nca k.rtvaa svadak.si.napaar\"sve tasyaannatim akarot| ");
INSERT INTO sanvel_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","etasmin vayamapi saak.si.na aasmahe, tat kevala.m nahi, ii\"svara aaj naagraahibhyo ya.m pavitram aatmana.m dattavaan sopi saak.syasti| ");
INSERT INTO sanvel_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","etadvaakye \"srute te.saa.m h.rdayaani viddhaanyabhavan tataste taan hantu.m mantritavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","etasminneva samaye tatsabhaasthaanaa.m sarvvalokaanaa.m madhye sukhyaato gamiliiyelnaamaka eko jano vyavasthaapaka.h phiruu\"siloka utthaaya preritaan k.sa.naartha.m sthaanaantara.m gantum aadi\"sya kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","he israayelva.m\"siiyaa.h sarvve yuuyam etaan maanu.saan prati yat karttum udyataastasmin saavadhaanaa bhavata| ");
INSERT INTO sanvel_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ita.h puurvva.m thuudaanaamaiko jana upasthaaya sva.m kamapi mahaapuru.sam avadat, tata.h praaye.na catu.h\"satalokaastasya matagraahi.nobhavan pa\"scaat sa hatobhavat tasyaaj naagraahi.no yaavanto lokaaste sarvve virkiir.naa.h santo .ak.rtakaaryyaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmaajjanaat para.m naamalekhanasamaye gaaliiliiyayihuudaanaamaiko jana upasthaaya bahuullokaan svamata.m graahiitavaan tata.h sopi vyana\"syat tasyaaj naagraahi.no yaavanto lokaa aasan te sarvve vikiir.naa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunaa vadaami, yuuyam etaan manu.syaan prati kimapi na k.rtvaa k.saantaa bhavata, yata e.sa sa\"nkalpa etat karmma ca yadi manu.syaadabhavat tarhi viphala.m bhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadii\"svaraadabhavat tarhi yuuya.m tasyaanyathaa karttu.m na \"sak.syatha, varam ii\"svararodhakaa bhavi.syatha| ");
INSERT INTO sanvel_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadaa tasya mantra.naa.m sviik.rtya te preritaan aahuuya prah.rtya yii\"so rnaamnaa kaamapi kathaa.m kathayitu.m ni.sidhya vyasarjan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya naamaartha.m vaya.m lajjaabhogasya yogyatvena ga.nitaa ityatra te saanandaa.h santa.h sabhaasthaanaa.m saak.saad agacchan| ");
INSERT INTO sanvel_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tata.h para.m pratidina.m mandire g.rhe g.rhe caavi\"sraamam upadi\"sya yii\"sukhrii.s.tasya susa.mvaada.m pracaaritavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samaye \"si.syaa.naa.m baahulyaat praatyahikadaanasya vi\"sraa.nanai rbhinnade\"siiyaanaa.m vidhavaastriiga.na upek.site sati ibriiyalokai.h sahaanyade\"siiyaanaa.m vivaada upaati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadaa dvaada\"sapreritaa.h sarvvaan \"si.syaan sa.mg.rhyaakathayan ii\"svarasya kathaapracaara.m parityajya bhojanagave.sa.nam asmaakam ucita.m nahi| ");
INSERT INTO sanvel_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ato he bhraat.rga.na vayam etatkarmma.no bhaara.m yebhyo daatu.m \"saknuma etaad.r\"saan sukhyaatyaapannaan pavitre.naatmanaa j naanena ca puur.naan sapprajanaan yuuya.m sve.saa.m madhye manoniitaan kuruta, ");
INSERT INTO sanvel_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vaya.m praarthanaayaa.m kathaapracaarakarmma.ni ca nityaprav.rttaa.h sthaasyaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","etasyaa.m kathaayaa.m sarvve lokaa.h santu.s.taa.h santa.h sve.saa.m madhyaat stiphaana.h philipa.h prakharo nikaanor tiiman parmmi.naa yihuudimatagraahii-aantiyakhiyaanagariiyo nikalaa etaan paramabhaktaan pavitre.naatmanaa paripuur.naan sapta janaan ");
INSERT INTO sanvel_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","preritaanaa.m samak.sam aanayan, tataste praarthanaa.m k.rtvaa te.saa.m \"sira.hsu hastaan aarpayan| ");
INSERT INTO sanvel_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","apara nca ii\"svarasya kathaa de\"sa.m vyaapnot vi\"se.sato yiruu\"saalami nagare \"si.syaa.naa.m sa.mkhyaa prabhuutaruupe.naavarddhata yaajakaanaa.m madhyepi bahava.h khrii.s.tamatagraahi.no.abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphaanoे vi\"svaasena paraakrame.na ca paripuur.na.h san lokaanaa.m madhye bahuvidham adbhutam aa\"scaryya.m karmmaakarot| ");
INSERT INTO sanvel_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tena libarttiniiyanaamnaa vikhyaatasa\"nghasya katipayajanaa.h kurii.niiyasikandariiya-kilikiiyaa\"siiyaade\"siiyaa.h kiyanto janaa\"scotthaaya stiphaanena saarddha.m vyavadanta| ");
INSERT INTO sanvel_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphaano j naanena pavitre.naatmanaa ca iid.r\"sii.m kathaa.m kathitavaan yasyaaste aapatti.m karttu.m naa\"saknuvan| ");
INSERT INTO sanvel_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","pa\"scaat tai rlobhitaa.h katipayajanaa.h kathaamenaam akathayan, vaya.m tasya mukhato muusaa ii\"svarasya ca nindaavaakyam a\"srau.sma| ");
INSERT INTO sanvel_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","te lokaanaa.m lokapraaciinaanaam adhyaapakaanaa nca prav.rtti.m janayitvaa stiphaanasya sannidhim aagatya ta.m dh.rtvaa mahaasabhaamadhyam aanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantara.m katipayajane.su mithyaasaak.si.su samaaniite.su te.akathayan e.sa jana etatpu.nyasthaanavyavasthayo rnindaata.h kadaapi na nivarttate| ");
INSERT INTO sanvel_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalato naasaratiiyayii\"su.h sthaanametad ucchinna.m kari.syati muusaasamarpitam asmaaka.m vyavahara.nam anyaruupa.m kari.syati tasyaitaad.r\"sii.m kathaa.m vayam a\"s.r.numa| ");
INSERT INTO sanvel_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadaa mahaasabhaasthaa.h sarvve ta.m prati sthiraa.m d.r.s.ti.m k.rtvaa svargaduutamukhasad.r\"sa.m tasya mukham apa\"syan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tata.h para.m mahaayaajaka.h p.r.s.tavaan, e.saa kathaa.m ki.m satyaa? ");
INSERT INTO sanvel_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tata.h sa pratyavadat, he pitaro he bhraatara.h sarvve laakaa manaa.msi nidhaddhva.m|asmaaka.m puurvvapuru.sa ibraahiim haara.nnagare vaasakara.naat puurvva.m yadaa araam-naharayimade\"se aasiit tadaa tejomaya ii\"svaro dar\"sana.m datvaa ");
INSERT INTO sanvel_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tva.m svade\"saj naatimitraa.ni parityajya ya.m de\"samaha.m dar\"sayi.syaami ta.m de\"sa.m vraja| ");
INSERT INTO sanvel_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ata.h sa kasdiiyade\"sa.m vihaaya haara.nnagare nyavasat, tadanantara.m tasya pitari m.rte yatra de\"se yuuya.m nivasatha sa ena.m de\"samaagacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvii\"svarastasmai kamapyadhikaaram arthaad ekapadaparimitaa.m bhuumimapi naadadaat; tadaa tasya kopi santaano naasiit tathaapi santaanai.h saarddham etasya de\"sasyaadhikaarii tva.m bhavi.syasiiti tampratya\"ngiik.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ii\"svara ittham aparamapi kathitavaan tava santaanaa.h parade\"se nivatsyanti tatastadde\"siiyalokaa\"scatu.h\"satavatsaraan yaavat taan daasatve sthaapayitvaa taan prati kuvyavahaara.m kari.syanti| ");
INSERT INTO sanvel_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam ii\"svara enaa.m kathaamapi kathitavaan, ye lokaastaan daasatve sthaapayi.syanti taallokaan aha.m da.n.dayi.syaami, tata.h para.m te bahirgataa.h santo maam atra sthaane sevi.syante| ");
INSERT INTO sanvel_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","pa\"scaat sa tasmai tvakchedasya niyama.m dattavaan, ata ishaakanaamni ibraahiima ekaputre jaate, a.s.tamadine tasya tvakchedam akarot| tasya ishaaka.h putro yaakuub, tatastasya yaakuubo.asmaaka.m dvaada\"sa puurvvapuru.saa ajaayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","te puurvvapuru.saa iir.syayaa paripuur.naa misarade\"sa.m pre.sayitu.m yuu.sapha.m vyakrii.nan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvii\"svarastasya sahaayo bhuutvaa sarvvasyaa durgate rak.sitvaa tasmai buddhi.m dattvaa misarade\"sasya raaj na.h phirau.na.h priyapaatra.m k.rtavaan tato raajaa misarade\"sasya sviiyasarvvaparivaarasya ca \"saasanapada.m tasmai dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samaye misara-kinaanade\"sayo rdurbhik.sahetoratikli.s.tatvaat na.h puurvvapuru.saa bhak.syadravya.m naalabhanta| ");
INSERT INTO sanvel_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misarade\"se \"sasyaani santi, yaakuub imaa.m vaarttaa.m \"srutvaa prathamam asmaaka.m puurvvapuru.saan misara.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tato dvitiiyavaaragamane yuu.saph svabhraat.rbhi.h paricito.abhavat; yuu.sapho bhraatara.h phirau.n raajena paricitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantara.m yuu.saph bhraat.rga.na.m pre.sya nijapitara.m yaakuuba.m nijaan pa ncaadhikasaptatisa.mkhyakaan j naatijanaa.m\"sca samaahuutavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmaad yaakuub misarade\"sa.m gatvaa svayam asmaaka.m puurvvapuru.saa\"sca tasmin sthaane.amriyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tataste \"sikhima.m niitaa yat \"sma\"saanam ibraahiim mudraadatvaa \"sikhima.h pitu rhamora.h putrebhya.h kriitavaan tat\"sma\"saane sthaapayaa ncakrire| ");
INSERT INTO sanvel_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tata.h param ii\"svara ibraahiima.h sannidhau \"sapatha.m k.rtvaa yaa.m pratij naa.m k.rtavaan tasyaa.h pratij naayaa.h phalanasamaye nika.te sati israayellokaa simarade\"se varddhamaanaa bahusa.mkhyaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","\"se.se yuu.sapha.m yo na paricinoti taad.r\"sa eko narapatirupasthaaya ");
INSERT INTO sanvel_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmaaka.m j naatibhi.h saarddha.m dhuurttataa.m vidhaaya puurvvapuru.saan prati kuvyavahara.napuurvvaka.m te.saa.m va.m\"sanaa\"sanaaya te.saa.m navajaataan \"si\"suun bahi rnirak.sepayat| ");
INSERT INTO sanvel_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","etasmin samaye muusaa jaj ne, sa tu paramasundaro.abhavat tathaa pit.rg.rhe maasatrayaparyyanta.m paalito.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnik.sipte sati phirau.naraajasya kanyaa tam uttolya niitvaa dattakaputra.m k.rtvaa paalitavatii| ");
INSERT INTO sanvel_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmaat sa muusaa misarade\"siiyaayaa.h sarvvavidyaayaa.h paarad.r.svaa san vaakye kriyaayaa nca \"saktimaan abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampuur.nacatvaari.m\"sadvatsaravayasko bhuutvaa israayeliiyava.m\"sanijabhraat.rn saak.saat kartu.m mati.m cakre| ");
INSERT INTO sanvel_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","te.saa.m janameka.m hi.msita.m d.r.s.tvaa tasya sapak.sa.h san hi.msitajanam upak.rtya misariiyajana.m jaghaana| ");
INSERT INTO sanvel_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hastene\"svarastaan uddhari.syati tasya bhraat.rga.na iti j naasyati sa ityanumaana.m cakaara, kintu te na bubudhire| ");
INSERT INTO sanvel_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatpare .ahani te.saam ubhayo rjanayo rvaakkalaha upasthite sati muusaa.h samiipa.m gatvaa tayo rmelana.m karttu.m mati.m k.rtvaa kathayaamaasa, he mahaa\"sayau yuvaa.m bhraatarau parasparam anyaaya.m kuta.h kurutha.h? ");
INSERT INTO sanvel_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tata.h samiipavaasina.m prati yo jano.anyaaya.m cakaara sa ta.m duuriik.rtya kathayaamaasa, asmaakamupari \"saast.rtvavicaarayit.rtvapadayo.h kastvaa.m niyuktavaan? ");
INSERT INTO sanvel_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyo yathaa misariiya.m hatavaan tathaa ki.m maamapi hani.syasi? ");
INSERT INTO sanvel_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadaa muusaa etaad.r\"sii.m kathaa.m \"srutvaa palaayana.m cakre, tato midiyanade\"sa.m gatvaa pravaasii san tasthau, tatastatra dvau putrau jaj naate| ");
INSERT INTO sanvel_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantara.m catvaari.m\"sadvatsare.su gate.su siinayaparvvatasya praantare prajvalitastambasya vahni\"sikhaayaa.m parame\"svaraduutastasmai dar\"sana.m dadau| ");
INSERT INTO sanvel_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","muusaastasmin dar\"sane vismaya.m matvaa vi\"se.sa.m j naatu.m nika.ta.m gacchati, ");
INSERT INTO sanvel_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","etasmin samaye, aha.m tava puurvvapuru.saa.naam ii\"svaro.arthaad ibraahiima ii\"svara ishaaka ii\"svaro yaakuuba ii\"svara\"sca, muusaamuddi\"sya parame\"svarasyaitaad.r\"sii vihaayasiiyaa vaa.nii babhuuva, tata.h sa kampaanvita.h san puna rniriik.situ.m pragalbho na babhuuva| ");
INSERT INTO sanvel_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","parame\"svarasta.m jagaada, tava paadayo.h paaduke mocaya yatra ti.s.thasi saa pavitrabhuumi.h| ");
INSERT INTO sanvel_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","aha.m misarade\"sasthaanaa.m nijalokaanaa.m durdda\"saa.m nitaantam apa\"sya.m, te.saa.m kaataryyokti nca \"srutavaan tasmaat taan uddharttum avaruhyaagamam; idaaniim aagaccha misarade\"sa.m tvaa.m pre.sayaami| ");
INSERT INTO sanvel_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvaa.m \"saast.rtvavicaarayit.rtvapadayo rniyuktavaan, iti vaakyamuktvaa tai ryo muusaa avaj naatastameva ii\"svara.h stambamadhye dar\"sanadaatraa tena duutena \"saastaara.m muktidaataara nca k.rtvaa pre.sayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa ca misarade\"se suuphnaamni samudre ca pa\"scaat catvaari.m\"sadvatsaraan yaavat mahaapraantare naanaaprakaaraa.nyadbhutaani karmmaa.ni lak.sa.naani ca dar\"sayitvaa taan bahi.h k.rtvaa samaaninaaya| ");
INSERT INTO sanvel_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhu.h parame\"svaro yu.smaaka.m bhraat.rga.nasya madhye maad.r\"sam eka.m bhavi.syadvaktaaram utpaadayi.syati tasya kathaayaa.m yuuya.m mano nidhaasyatha, yo jana israayela.h santaanebhya enaa.m kathaa.m kathayaamaasa sa e.sa muusaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahaapraantarasthama.n.daliimadhye.api sa eva siinayaparvvatopari tena saarddha.m sa.mlaapino duutasya caasmatpit.rga.nasya madhyastha.h san asmabhya.m daatavyani jiivanadaayakaani vaakyaani lebhe| ");
INSERT INTO sanvel_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmaaka.m puurvvapuru.saastam amaanya.m katvaa svebhyo duuriik.rtya misarade\"sa.m paraav.rtya gantu.m manobhirabhila.sya haaro.na.m jagadu.h, ");
INSERT INTO sanvel_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmaakam agre.agre gantuुm asmadartha.m devaga.na.m nirmmaahi yato yo muusaa asmaan misarade\"saad bahi.h k.rtvaaniitavaan tasya ki.m jaata.m tadasmaabhi rna j naayate| ");
INSERT INTO sanvel_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samaye te govatsaak.rti.m pratimaa.m nirmmaaya taamuddi\"sya naivedyamutm.rjya svahastak.rtavastunaa aananditavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmaad ii\"svaraste.saa.m prati vimukha.h san aakaa\"sastha.m jyotirga.na.m puujayitu.m tebhyo.anumati.m dadau, yaad.r\"sa.m bhavi.syadvaadinaa.m granthe.su likhitamaaste, yathaa, israayeliiyava.m\"saa re catvaari.m\"satsamaan puraa| mahati praantare sa.msthaa yuuyantu yaani ca| balihomaadikarmmaa.ni k.rtavantastu taani ki.m| maa.m samuddi\"sya yu.smaabhi.h prak.rtaaniiti naiva ca| ");
INSERT INTO sanvel_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vo molakaakhyasya devasya duu.syameva ca| yu.smaaka.m rimphanaakhyaayaa devataayaa\"sca taarakaa| etayorubhayo rmuurtii yu.smaabhi.h paripuujite| ato yu.smaa.mstu baabela.h paara.m ne.syaami ni\"scita.m| ");
INSERT INTO sanvel_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","apara nca yannidar\"sanam apa\"syastadanusaare.na duu.sya.m nirmmaahi yasmin ii\"svaro muusaam etadvaakya.m babhaa.se tat tasya niruupita.m saak.syasvaruupa.m duu.syam asmaaka.m puurvvapuru.sai.h saha praantare tasthau| ");
INSERT INTO sanvel_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","pa\"scaat yiho\"suuyena sahitaiste.saa.m va.m\"sajaatairasmatpuurvvapuru.sai.h sve.saa.m sammukhaad ii\"svare.na duuriik.rtaanaam anyade\"siiyaanaa.m de\"saadhik.rtikaale samaaniita.m tad duu.sya.m daayuudodhikaara.m yaavat tatra sthaana aasiit| ");
INSERT INTO sanvel_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa daayuud parame\"svarasyaanugraha.m praapya yaakuub ii\"svaraartham eka.m duu.sya.m nirmmaatu.m vavaa ncha; ");
INSERT INTO sanvel_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulemaan tadartha.m mandiram eka.m nirmmitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathaapi ya.h sarvvoparistha.h sa kasmi.m\"scid hastak.rte mandire nivasatiiti nahi, bhavi.syadvaadii kathaametaa.m kathayati, yathaa, ");
INSERT INTO sanvel_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","pare\"so vadati svargo raajasi.mhaasana.m mama| madiiya.m paadapii.tha nca p.rthivii bhavati dhruva.m| tarhi yuuya.m k.rte me ki.m pranirmmaasyatha mandira.m| vi\"sraamaaya madiiya.m vaa sthaana.m ki.m vidyate tviha| ");
INSERT INTO sanvel_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvaa.nyetaani vastuuni ki.m me hastak.rtaani na|| ");
INSERT INTO sanvel_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","he anaaj naagraahakaa anta.hkara.ne \"srava.ne caapavitralokaa.h yuuyam anavarata.m pavitrasyaatmana.h praatikuulyam aacaratha, yu.smaaka.m puurvvapuru.saa yaad.r\"saa yuuyamapi taad.r\"saa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yu.smaaka.m puurvvapuru.saa.h ka.m bhavi.syadvaadina.m naataa.dayan? ye tasya dhaarmmikasya janasyaagamanakathaa.m kathitavantastaan aghnan yuuyam adhuunaa vi\"svaasaghaatino bhuutvaa ta.m dhaarmmika.m janam ahata| ");
INSERT INTO sanvel_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yuuya.m svargiiyaduutaga.nena vyavasthaa.m praapyaapi taa.m naacaratha| ");
INSERT INTO sanvel_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imaa.m kathaa.m \"srutvaa te mana.hsu biddhaa.h santasta.m prati dantaghar.sa.nam akurvvan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphaana.h pavitre.naatmanaa puur.no bhuutvaa gaga.na.m prati sthirad.r.s.ti.m k.rtvaa ii\"svarasya dak.si.ne da.n.daayamaana.m yii\"su nca vilokya kathitavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","pa\"sya,meghadvaara.m muktam ii\"svarasya dak.si.ne sthita.m maanavasuta nca pa\"syaami| ");
INSERT INTO sanvel_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadaa te proccai.h \"sabda.m k.rtvaa kar.ne.sva\"ngulii rnidhaaya ekacittiibhuuya tam aakraman| ");
INSERT INTO sanvel_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","pa\"scaat ta.m nagaraad bahi.h k.rtvaa prastarairaaghnan saak.si.no laakaa.h \"saulanaamno yuuna\"scara.nasannidhau nijavastraa.ni sthaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantara.m he prabho yii\"se madiiyamaatmaana.m g.rhaa.na stiphaanasyeti praarthanavaakyavadanasamaye te ta.m prastarairaaghnan| ");
INSERT INTO sanvel_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmaat sa jaanunii paatayitvaa proccai.h \"sabda.m k.rtvaa, he prabhe paapametad ete.su maa sthaapaya, ityuktvaa mahaanidraa.m praapnot| ");
INSERT INTO sanvel_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyaakara.na.m \"saulopi samamanyata| tasmin samaye yiruu\"saalamnagarasthaa.m ma.n.dalii.m prati mahaataa.danaayaa.m jaataayaa.m preritalokaan hitvaa sarvve.apare yihuudaa\"somiro.nade\"sayo rnaanaasthaane vikiir.naa.h santo gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyacca bhaktalokaasta.m stiphaana.m \"sma\"saane sthaapayitvaa bahu vyalapan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu \"saulo g.rhe g.rhe bhramitvaa striya.h puru.saa.m\"sca dh.rtvaa kaaraayaa.m baddhvaa ma.n.dalyaa mahotpaata.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyacca ye vikiir.naa abhavan te sarvvatra bhramitvaa susa.mvaada.m praacaarayan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadaa philipa.h \"somiro.nnagara.m gatvaa khrii.s.taakhyaana.m praacaarayat; ");
INSERT INTO sanvel_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tato.a\"suci-bh.rtagrastalokebhyo bhuutaa\"sciitk.rtyaagacchan tathaa bahava.h pak.saaghaatina.h kha njaa lokaa\"sca svasthaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmaat laakaa iid.r\"sa.m tasyaa\"scaryya.m karmma vilokya ni\"samya ca sarvva ekacittiibhuuya tenoktaakhyaane manaa.msi nyadadhu.h| ");
INSERT INTO sanvel_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagare mahaananda\"scaabhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tata.h puurvva.m tasminnagare \"simonnaamaa ka\"scijjano bahvii rmaayaakriyaa.h k.rtvaa sva.m ka ncana mahaapuru.sa.m procya \"somiro.niiyaanaa.m moha.m janayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmaat sa maanu.sa ii\"svarasya mahaa\"saktisvaruupa ityuktvaa baalav.rddhavanitaa.h sarvve laakaastasmin manaa.msi nyadadhu.h| ");
INSERT INTO sanvel_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukaalaan maayaavikriyayaa sarvvaan atiiva mohayaa ncakaara, tasmaat te ta.m menire| ");
INSERT INTO sanvel_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvii\"svarasya raajyasya yii\"sukhrii.s.tasya naamna\"scaakhyaanapracaari.na.h philipasya kathaayaa.m vi\"svasya te.saa.m striipuru.sobhayalokaa majjitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","\"se.se sa \"simonapi svaya.m pratyait tato majjita.h san philipena k.rtaam aa\"scaryyakriyaa.m lak.sa.na nca vilokyaasambhava.m manyamaanastena saha sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ittha.m \"somiro.nde\"siiyalokaa ii\"svarasya kathaam ag.rhlan iti vaarttaa.m yiruu\"saalamnagarasthapreritaa.h praapya pitara.m yohana nca te.saa.m nika.te pre.sitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthaanam upasthaaya lokaa yathaa pavitram aatmaana.m praapnuvanti tadartha.m praarthayetaa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yataste puraa kevalaprabhuyii\"so rnaamnaa majjitamaatraa abhavan, na tu te.saa.m madhye kamapi prati pavitrasyaatmana aavirbhaavo jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu preritaabhyaa.m te.saa.m gaatre.su kare.svarpite.su satsu te pavitram aatmaanam praapnuvan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ittha.m lokaanaa.m gaatre.su preritayo.h karaarpa.nena taan pavitram aatmaana.m praaptaan d.r.s.tvaa sa \"simon tayo.h samiipe mudraa aaniiya kathitavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","aha.m yasya gaatre hastam arpayi.syaami tasyaapi yathettha.m pavitraatmapraapti rbhavati taad.r\"sii.m \"sakti.m mahya.m datta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarasta.m pratyavadat tava mudraastvayaa vina\"syantu yata ii\"svarasya daana.m mudraabhi.h kriiyate tvamittha.m buddhavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ii\"svaraaya taavanta.hkara.na.m sarala.m nahi, tasmaad atra tavaa.m\"so.adhikaara\"sca kopi naasti| ");
INSERT INTO sanvel_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata etatpaapaheto.h khedaanvita.h san kenaapi prakaare.na tava manasa etasyaa.h kukalpanaayaa.h k.samaa bhavati, etadartham ii\"svare praarthanaa.m kuru; ");
INSERT INTO sanvel_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastva.m tiktapitte paapasya bandhane ca yadasi tanmayaa buddham| ");
INSERT INTO sanvel_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadaa \"simon akathayat tarhi yuvaabhyaamuditaa kathaa mayi yathaa na phalati tadartha.m yuvaa.m mannimitta.m prabhau praarthanaa.m kuruta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anena prakaare.na tau saak.sya.m dattvaa prabho.h kathaa.m pracaarayantau \"somiro.niiyaanaam anekagraame.su susa.mvaada nca pracaarayantau yiruu\"saalamnagara.m paraav.rtya gatau| ");
INSERT INTO sanvel_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tata.h param ii\"svarasya duuta.h philipam ityaadi\"sat, tvamutthaaya dak.si.nasyaa.m di\"si yo maargo praantarasya madhyena yiruu\"saalamo .asaanagara.m yaati ta.m maarga.m gaccha| ");
INSERT INTO sanvel_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tata.h sa utthaaya gatavaan; tadaa kandaakiinaamna.h kuu\"slokaanaa.m raaj nyaa.h sarvvasampatteradhii\"sa.h kuu\"sade\"siiya eka.h .sa.n.do bhajanaartha.m yiruu\"saalamnagaram aagatya ");
INSERT INTO sanvel_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamaaruhya yi\"sayiyanaamno bhavi.syadvaadino grantha.m pa.than pratyaagacchati| ");
INSERT INTO sanvel_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","etasmin samaye aatmaa philipam avadat, tvam rathasya samiipa.m gatvaa tena saarddha.m mila| ");
INSERT INTO sanvel_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmaat sa dhaavan tasya sannidhaavupasthaaya tena pa.thyamaana.m yi\"sayiyathavi.syadvaadino vaakya.m \"srutvaa p.r.s.tavaan yat pa.thasi tat ki.m budhyase? ");
INSERT INTO sanvel_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tata.h sa kathitavaan kenacinna bodhitoha.m katha.m budhyeya? tata.h sa philipa.m rathamaaro.dhu.m svena saarddham upave.s.tu nca nyavedayat| ");
INSERT INTO sanvel_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa \"saastrasyetadvaakya.m pa.thitavaan yathaa, samaaniiyata ghaataaya sa yathaa me.sa\"saavaka.h| lomacchedakasaak.saacca me.sa\"sca niiravo yathaa| aabadhya vadana.m sviiya.m tathaa sa samati.s.thata| ");
INSERT INTO sanvel_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyaayena vicaare.na sa ucchinno .abhavat tadaa| tatkaaliinamanu.syaan ko jano var.nayitu.m k.sama.h| yato jiivann.r.naa.m de\"saat sa ucchinno .abhavat dhruva.m| ");
INSERT INTO sanvel_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantara.m sa philipam avadat nivedayaami, bhavi.syadvaadii yaamimaa.m kathaa.m kathayaamaasa sa ki.m svasmin vaa kasmi.m\"scid anyasmin? ");
INSERT INTO sanvel_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tata.h philipastatprakara.nam aarabhya yii\"sorupaakhyaana.m tasyaagre praastaut| ");
INSERT INTO sanvel_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ittha.m maarge.na gacchantau jalaa\"sayasya samiipa upasthitau; tadaa kliibo.avaadiit pa\"syaatra sthaane jalamaaste mama majjane kaa baadhaa? ");
INSERT INTO sanvel_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tata.h philipa uttara.m vyaaharat svaanta.hkara.nena saaka.m yadi pratye.si tarhi baadhaa naasti| tata.h sa kathitavaan yii\"sukhrii.s.ta ii\"svarasya putra ityaha.m pratyemi| ");
INSERT INTO sanvel_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadaa ratha.m sthagita.m karttum aadi.s.te philipakliibau dvau jalam avaaruhataa.m; tadaa philipastam majjayaamaasa| ");
INSERT INTO sanvel_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpa\"scaat jalamadhyaad utthitayo.h sato.h parame\"svarasyaatmaa philipa.m h.rtvaa niitavaan, tasmaat kliiba.h punasta.m na d.r.s.tavaan tathaapi h.r.s.tacitta.h san svamaarge.na gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipa\"scaasdodnagaram upasthaaya tasmaat kaisariyaanagara upasthitikaalaparyyanata.m sarvvasminnagare susa.mvaada.m pracaarayan gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkaalaparyyanata.m \"saula.h prabho.h \"si.syaa.naa.m praatikuulyena taa.danaabadhayo.h kathaa.m ni.hsaarayan mahaayaajakasya sannidhi.m gatvaa ");
INSERT INTO sanvel_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striya.m puru.sa nca tanmatagraahi.na.m ya.m ka ncit pa\"syati taan dh.rtvaa baddhvaa yiruu\"saalamam aanayatiityaa\"sayena damme.saknagariiya.m dharmmasamaajaan prati patra.m yaacitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gacchan tu damme.saknagaranika.ta upasthitavaan; tato.akasmaad aakaa\"saat tasya caturdik.su tejasa.h prakaa\"sanaat sa bhuumaavapatat| ");
INSERT INTO sanvel_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pa\"scaat he \"saula he \"saula kuto maa.m taa.dayasi? sva.m prati proktam eta.m \"sabda.m \"srutvaa ");
INSERT INTO sanvel_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa p.r.s.tavaan, he prabho bhavaan ka.h? tadaa prabhurakathayat ya.m yii\"su.m tva.m taa.dayasi sa evaaha.m; ka.n.takasya mukhe padaaghaatakara.na.m tava ka.s.tam| ");
INSERT INTO sanvel_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadaa kampamaano vismayaapanna\"sca sovadat he prabho mayaa ki.m karttavya.m? bhavata icchaa kaa? tata.h prabhuraaj naapayad utthaaya nagara.m gaccha tatra tvayaa yat karttavya.m tad vadi.syate| ");
INSERT INTO sanvel_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya sa\"ngino lokaa api ta.m \"sabda.m \"srutavanta.h kintu kamapi na d.r.s.tvaa stabdhaa.h santa.h sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantara.m \"saulo bhuumita utthaaya cak.su.sii unmiilya kamapi na d.r.s.tavaan| tadaa lokaastasya hastau dh.rtvaa damme.saknagaram aanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tata.h sa dinatraya.m yaavad andho bhuutvaa na bhuktavaan piitavaa.m\"sca| ");
INSERT INTO sanvel_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantara.m prabhustaddamme.saknagaravaasina ekasmai \"si.syaaya dar\"sana.m datvaa aahuutavaan he ananiya| tata.h sa pratyavaadiit, he prabho pa\"sya \"s.r.nomi| ");
INSERT INTO sanvel_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadaa prabhustamaaj naapayat tvamutthaaya saralanaamaana.m maarga.m gatvaa yihuudaanive\"sane taar.sanagariiya.m \"saulanaamaana.m jana.m gave.sayan p.rccha; ");
INSERT INTO sanvel_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pa\"sya sa praarthayate, tathaa ananiyanaamaka eko janastasya samiipam aagatya tasya gaatre hastaarpa.na.m k.rtvaa d.r.s.ti.m dadaatiittha.m svapne d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmaad ananiya.h pratyavadat he prabho yiruu\"saalami pavitralokaan prati so.anekahi.msaa.m k.rtavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthaane ca ye lokaastava naamni praarthayanti taanapi baddhu.m sa pradhaanayaajakebhya.h \"sakti.m praaptavaan, imaa.m kathaam aham aneke.saa.m mukhebhya.h \"srutavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yaahi bhinnade\"siiyalokaanaa.m bhuupatiinaam israayellokaanaa nca nika.te mama naama pracaarayitu.m sa jano mama manoniitapaatramaaste| ");
INSERT INTO sanvel_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama naamanimitta nca tena kiyaan mahaan kle\"so bhoktavya etat ta.m dar\"sayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tato .ananiyo gatvaa g.rha.m pravi\"sya tasya gaatre hastaarpra.na.m k.rtvaa kathitavaan, he bhraata.h \"saula tva.m yathaa d.r.s.ti.m praapno.si pavitre.naatmanaa paripuur.no bhavasi ca, tadartha.m tavaagamanakaale ya.h prabhuyii\"sustubhya.m dar\"sanam adadaat sa maa.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamaatre tasya cak.surbhyaam miina\"salkavad vastuni nirgate tatk.sa.naat sa prasannacak.su rbhuutvaa protthaaya majjito.abhavat bhuktvaa piitvaa sabalobhavacca| ");
INSERT INTO sanvel_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tata.h para.m \"saula.h \"si.syai.h saha katipayadivasaan tasmin damme.sakanagare sthitvaa.avilamba.m ");
INSERT INTO sanvel_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanaani gatvaa yii\"surii\"svarasya putra imaa.m kathaa.m praacaarayat| ");
INSERT INTO sanvel_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmaat sarvve \"srotaara\"scamatk.rtya kathitavanto yo yiruu\"saalamnagara etannaamnaa praarthayit.rlokaan vinaa\"sitavaan evam etaad.r\"salokaan baddhvaa pradhaanayaajakanika.ta.m nayatiityaa\"sayaa etatsthaanamapyaagacchat saeva kimaya.m na bhavati? ");
INSERT INTO sanvel_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu \"saula.h krama\"sa utsaahavaan bhuutvaa yii\"surii\"svare.naabhi.sikto jana etasmin pramaa.na.m datvaa damme.sak-nivaasiyihuudiiyalokaan niruttaraan akarot| ");
INSERT INTO sanvel_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ittha.m bahutithe kaale gate yihuudiiyalokaasta.m hantu.m mantrayaamaasu.h ");
INSERT INTO sanvel_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu \"saulaste.saametasyaa mantra.naayaa vaarttaa.m praaptavaan| te ta.m hantu.m tu divaani\"sa.m guptaa.h santo nagarasya dvaare.ati.s.than; ");
INSERT INTO sanvel_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmaat \"si.syaasta.m niitvaa raatrau pi.take nidhaaya praaciire.naavaarohayan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tata.h para.m \"saulo yiruu\"saalama.m gatvaa \"si.syaga.nena saarddha.m sthaatum aihat, kintu sarvve tasmaadabibhayu.h sa \"si.sya iti ca na pratyayan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","etasmaad bar.nabbaasta.m g.rhiitvaa preritaanaa.m samiipamaaniiya maargamadhye prabhu.h katha.m tasmai dar\"sana.m dattavaan yaa.h kathaa\"sca kathitavaan sa ca yathaak.sobha.h san damme.saknagare yii\"so rnaama praacaarayat etaan sarvvav.rttaantaan taan j naapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tata.h \"saulastai.h saha yiruu\"saalami kaala.m yaapayan nirbhaya.m prabho ryii\"so rnaama praacaarayat| ");
INSERT INTO sanvel_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmaad anyade\"siiyalokai.h saarddha.m vivaadasyopasthitatvaat te ta.m hantum ace.s.tanta| ");
INSERT INTO sanvel_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhraat.rga.nastajj naatvaa ta.m kaisariyaanagara.m niitvaa taar.sanagara.m pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ittha.m sati yihuudiyaagaaliil\"somiro.nade\"siiyaa.h sarvvaa ma.n.dalyo vi\"sraama.m praaptaastatastaasaa.m ni.s.thaabhavat prabho rbhiyaa pavitrasyaatmana.h saantvanayaa ca kaala.m k.sepayitvaa bahusa.mkhyaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tata.h para.m pitara.h sthaane sthaane bhramitvaa \"se.se lodnagaranivaasipavitralokaanaa.m samiipe sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadaa tatra pak.saaghaatavyaadhinaa.s.tau vatsaraan \"sayyaagatam aineyanaamaana.m manu.sya.m saak.sat praapya tamavadat, ");
INSERT INTO sanvel_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","he aineya yii\"sukhrii.s.tastvaa.m svastham akaar.siit, tvamutthaaya sva\"sayyaa.m nik.sipa, ityuktamaatre sa udati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","etaad.r\"sa.m d.r.s.tvaa lod\"saaro.nanivaasino lokaa.h prabhu.m prati paraavarttanta| ");
INSERT INTO sanvel_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","apara nca bhik.saadaanaadi.su naanakriyaasu nitya.m prav.rttaa yaa yaaphonagaranivaasinii .taabithaanaamaa \"si.syaa yaa.m darkkaa.m arthaad hari.niimayuktvaa aahvayan saa naarii ");
INSERT INTO sanvel_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samaye rugnaa satii praa.naan atyajat, tato lokaastaa.m prak.saalyoparisthaprako.s.the \"saayayitvaasthaapayan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lodnagara.m yaaphonagarasya samiipastha.m tasmaattatra pitara aaste, iti vaarttaa.m \"srutvaa tuur.na.m tasyaagamanaartha.m tasmin vinayamuktvaa \"si.syaga.no dvau manujau pre.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmaat pitara utthaaya taabhyaa.m saarddham aagacchat, tatra tasmin upasthita uparisthaprako.s.tha.m samaaniite ca vidhavaa.h svaabhi.h saha sthitikaale darkkayaa k.rtaani yaanyuttariiyaa.ni paridheyaani ca taani sarvvaa.ni ta.m dar\"sayitvaa rudatya\"scatas.r.su dik.svati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastaa.h sarvvaa bahi.h k.rtvaa jaanunii paatayitvaa praarthitavaan; pa\"scaat \"sava.m prati d.r.s.ti.m k.rtvaa kathitavaan, he .taabiithe tvamutti.s.tha, iti vaakya ukte saa strii cak.su.sii pronmiilya pitaram avalokyotthaayopaavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tata.h pitarastasyaa.h karau dh.rtvaa uttolya pavitralokaan vidhavaa\"scaahuuya te.saa.m nika.te sajiivaa.m taa.m samaarpayat| ");
INSERT INTO sanvel_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","e.saa kathaa samastayaaphonagara.m vyaaptaa tasmaad aneke lokaa.h prabhau vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","apara nca pitarastadyaaphonagariiyasya kasyacit \"simonnaamna\"scarmmakaarasya g.rhe bahudinaani nyavasat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyaanagara itaaliyaakhyasainyaantargata.h kar.niiliyanaamaa senaapatiraasiit ");
INSERT INTO sanvel_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivaaro bhakta ii\"svaraparaaya.na\"scaasiit; lokebhyo bahuuni daanaadiini datvaa nirantaram ii\"svare praarthayaa ncakre| ");
INSERT INTO sanvel_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ekadaa t.rtiiyapraharavelaayaa.m sa d.r.s.tavaan ii\"svarasyaiko duuta.h saprakaa\"sa.m tatsamiipam aagatya kathitavaan, he kar.niiliya| ");
INSERT INTO sanvel_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa ta.m d.r.s.tvaa bhiito.akathayat, he prabho ki.m? tadaa tamavadat tava praarthanaa daanaadi ca saak.sisvaruupa.m bhuutve\"svarasya gocaramabhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idaanii.m yaaphonagara.m prati lokaan pre.sya samudratiire \"simonnaamna\"scarmmakaarasya g.rhe pravaasakaarii pitaranaamnaa vikhyaato ya.h \"simon tam aahvaayaya; ");
INSERT INTO sanvel_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmaat tvayaa yadyat karttavya.m tattat sa vadi.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadi\"sya duute prasthite sati kar.niiliya.h svag.rhasthaanaa.m daasaanaa.m dvau janau nitya.m svasa\"nginaa.m sainyaanaam ekaa.m bhaktasenaa ncaahuuya ");
INSERT INTO sanvel_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalameta.m v.rttaanta.m vij naapya yaaphonagara.m taan praahi.not| ");
INSERT INTO sanvel_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dine te yaatraa.m k.rtvaa yadaa nagarasya samiipa upaati.s.than, tadaa pitaro dvitiiyapraharavelaayaa.m praarthayitu.m g.rhap.r.s.tham aarohat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","etasmin samaye k.sudhaartta.h san ki ncid bhoktum aicchat kintu te.saam annaasaadanasamaye sa muurcchita.h sannapatat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tato meghadvaara.m mukta.m caturbhi.h ko.nai rlambita.m b.rhadvastramiva ki ncana bhaajanam aakaa\"saat p.rthiviim avaarohatiiti d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhye naanaprakaaraa graamyavanyapa\"sava.h khecarorogaamiprabh.rtayo jantava\"scaasan| ");
INSERT INTO sanvel_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantara.m he pitara utthaaya hatvaa bhu.mk.sva tampratiiya.m gaga.niiyaa vaa.nii jaataa| ");
INSERT INTO sanvel_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadaa pitara.h pratyavadat, he prabho iid.r\"sa.m maa bhavatu, aham etat kaala.m yaavat ni.siddham a\"suci vaa dravya.m ki ncidapi na bhuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tata.h punarapi taad.r\"sii vihayasiiyaa vaa.nii jaataa yad ii\"svara.h \"suci k.rtavaan tat tva.m ni.siddha.m na jaaniihi| ");
INSERT INTO sanvel_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ittha.m tri.h sati tat paatra.m punaraak.r.s.ta.m aakaa\"sam agacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tata.h para.m yad dar\"sana.m praaptavaan tasya ko bhaava ityatra pitaro manasaa sandegdhi, etasmin samaye kar.niiliyasya te pre.sitaa manu.syaa dvaarasya sannidhaavupasthaaya, ");
INSERT INTO sanvel_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","\"simono g.rhamanvicchanta.h samp.rchyaahuuya kathitavanta.h pitaranaamnaa vikhyaato ya.h \"simon sa kimatra pravasati? ");
INSERT INTO sanvel_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadaa pitarastaddar\"sanasya bhaava.m manasaandolayati tadaatmaa tamavadat, pa\"sya trayo janaastvaa.m m.rgayante| ");
INSERT INTO sanvel_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthaayaavaruhya ni.hsandeha.m tai.h saha gaccha mayaiva te pre.sitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmaat pitaro.avaruhya kar.niiliyapreritalokaanaa.m nika.tamaagatya kathitavaan pa\"syata yuuya.m ya.m m.rgayadhve sa janoha.m, yuuya.m kinnimittam aagataa.h? ");
INSERT INTO sanvel_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tataste pratyavadan kar.niiliyanaamaa \"suddhasattva ii\"svaraparaaya.no yihuudiiyade\"sasthaanaa.m sarvve.saa.m sannidhau sukhyaatyaapanna eka.h senaapati rnijag.rha.m tvaamaahuuya netu.m tvatta.h kathaa \"srotu nca pavitraduutena samaadi.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadaa pitarastaanabhyantara.m niitvaa te.saamaatithya.m k.rtavaan, pare.ahani tai.h saarddha.m yaatraamakarot, yaaphonivaasinaa.m bhraat.r.naa.m kiyanto janaa\"sca tena saha gataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divase kaisariyaanagaramadhyaprave\"sasamaye kar.niiliyo j naatibandhuun aahuuyaaniiya taan apek.sya sthita.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitare g.rha upasthite kar.niiliyasta.m saak.saatk.rtya cara.nayo.h patitvaa praa.namat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthaapya kathitavaan, utti.s.thaahamapi maanu.sa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadaa kar.niiliyena saakam aalapan g.rha.m praavi\"sat tanmadhye ca bahulokaanaa.m samaagama.m d.r.s.tvaa taan avadat, ");
INSERT INTO sanvel_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajaatiiyalokai.h mahaalapana.m vaa te.saa.m g.rhamadhye prave\"sana.m yihuudiiyaanaa.m ni.siddham astiiti yuuyam avagacchatha; kintu kamapi maanu.sam avyavahaaryyam a\"suci.m vaa j naatu.m mama nocitam iti parame\"svaro maa.m j naapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hetoraahvaana\"srava.namaatraat kaa ncanaapattim ak.rtvaa yu.smaaka.m samiipam aagatosmi; p.rcchaami yuuya.m kinnimitta.m maam aahuuyata? ");
INSERT INTO sanvel_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadaa kar.niiliya.h kathitavaan, adya catvaari dinaani jaataani etaavadvelaa.m yaavad aham anaahaara aasan tatast.rtiiyaprahare sati g.rhe praarthanasamaye tejomayavastrabh.rd eko jano mama samak.sa.m ti.s.than etaa.m kathaam akathayat, ");
INSERT INTO sanvel_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","he kar.niiliya tvadiiyaa praarthanaa ii\"svarasya kar.nagocariibhuutaa tava daanaadi ca saak.sisvaruupa.m bhuutvaa tasya d.r.s.tigocaramabhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ato yaaphonagara.m prati lokaan prahitya tatra samudratiire \"simonnaamna.h kasyaciccarmmakaarasya g.rhe pravaasakaarii pitaranaamnaa vikhyaato ya.h \"simon tamaahuuाyaya; tata.h sa aagatya tvaam upadek.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kaara.naat tatk.sa.naat tava nika.te lokaan pre.sitavaan, tvamaagatavaan iti bhadra.m k.rtavaan| ii\"svaro yaanyaakhyaanaani kathayitum aadi\"sat taani \"srotu.m vaya.m sarvve saampratam ii\"svarasya saak.saad upasthitaa.h sma.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadaa pitara imaa.m kathaa.m kathayitum aarabdhavaan, ii\"svaro manu.syaa.naam apak.sapaatii san ");
INSERT INTO sanvel_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyacid de\"sasya yo lokaastasmaadbhiitvaa satkarmma karoti sa tasya graahyo bhavati, etasya ni\"scayam upalabdhavaanaham| ");
INSERT INTO sanvel_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvve.saa.m prabhu ryo yii\"sukhrii.s.tastena ii\"svara israayelva.m\"saanaa.m nika.te susa.mvaada.m pre.sya sammelanasya ya.m sa.mvaada.m praacaarayat ta.m sa.mvaada.m yuuya.m \"srutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yato yohanaa majjane pracaarite sati sa gaaliilade\"samaarabhya samastayihuudiiyade\"sa.m vyaapnot; ");
INSERT INTO sanvel_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata ii\"svare.na pavitre.naatmanaa \"saktyaa caabhi.sikto naasaratiiyayii\"su.h sthaane sthaane bhraman sukriyaa.m kurvvan \"saitaanaa kli.s.taan sarvvalokaan svasthaan akarot, yata ii\"svarastasya sahaaya aasiit; ");
INSERT INTO sanvel_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vaya nca yihuudiiyade\"se yiruu\"saalamnagare ca tena k.rtaanaa.m sarvve.saa.m karmma.naa.m saak.si.no bhavaama.h| lokaasta.m kru\"se viddhvaa hatavanta.h, ");
INSERT INTO sanvel_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu t.rtiiyadivase ii\"svarastamutthaapya saprakaa\"sam adar\"sayat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalokaanaa.m nika.ta iti na hi, kintu tasmin \"sma\"saanaadutthite sati tena saarddha.m bhojana.m paana nca k.rtavanta etaad.r\"saa ii\"svarasya manoniitaa.h saak.si.no ye vayam asmaaka.m nika.te tamadar\"sayat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jiivitam.rtobhayalokaanaa.m vicaara.m karttum ii\"svaro ya.m niyuktavaan sa eva sa jana.h, imaa.m kathaa.m pracaarayitu.m tasmin pramaa.na.m daatu nca so.asmaan aaj naapayat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin vi\"svasiti sa tasya naamnaa paapaanmukto bhavi.syati tasmin sarvve bhavi.syadvaadinopi etaad.r\"sa.m saak.sya.m dadati| ");
INSERT INTO sanvel_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathaakathanakaale sarvve.saa.m \"srot.r.naamupari pavitra aatmaavaarohat| ");
INSERT INTO sanvel_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tata.h pitare.na saarddham aagataastvakchedino vi\"svaasino lokaa anyade\"siiyebhya.h pavitra aatmani datte sati ");
INSERT INTO sanvel_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","te naanaajaatiiyabhaa.saabhi.h kathaa.m kathayanta ii\"svara.m pra\"sa.msanti, iti d.r.s.tvaa \"srutvaa ca vismayam aapadyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadaa pitara.h kathitavaan, vayamiva ye pavitram aatmaana.m praaptaaste.saa.m jalamajjana.m ki.m kopi ni.seddhu.m \"saknoti? ");
INSERT INTO sanvel_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tata.h prabho rnaamnaa majjitaa bhavateti taanaaj naapayat| anantara.m te svai.h saarddha.m katipayadinaani sthaatu.m praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ittha.m bhinnade\"siiyalokaa apii\"svarasya vaakyam ag.rhlan imaa.m vaarttaa.m yihuudiiyade\"sasthapreritaa bhraat.rga.na\"sca \"srutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tata.h pitare yiruu\"saalamnagara.m gatavati tvakchedino lokaastena saha vivadamaanaa avadan, ");
INSERT INTO sanvel_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakchedilokaanaa.m g.rha.m gatvaa tai.h saarddha.m bhuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tata.h pitara aadita.h krama\"sastatkaaryyasya sarvvav.rttaantamaakhyaatum aarabdhavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yaaphonagara ekadaaha.m praarthayamaano muurcchita.h san dar\"sanena catur.su ko.ne.su lambanamaana.m v.rhadvastramiva paatramekam aakaa\"sadavaruhya mannika.tam aagacchad apa\"syam| ");
INSERT INTO sanvel_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","pa\"scaat tad ananyad.r.s.tyaa d.r.s.tvaa vivicya tasya madhye naanaaprakaaraan graamyavanyapa\"suun urogaamikhecaraa.m\"sca d.r.s.tavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","he pitara tvamutthaaya gatvaa bhu.mk.sva maa.m sambodhya kathayanta.m \"sabdameka.m \"srutavaa.m\"sca| ");
INSERT INTO sanvel_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatoha.m pratyavada.m, he prabho nettha.m bhavatu, yata.h ki ncana ni.siddham a\"suci dravya.m vaa mama mukhamadhya.m kadaapi na praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam ii\"svaro yat \"suci k.rtavaan tanni.siddha.m na jaaniihi dvi rmaampratiid.r\"sii vihaayasiiyaa vaa.nii jaataa| ");
INSERT INTO sanvel_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","tririttha.m sati tat sarvva.m punaraakaa\"sam aak.r.s.ta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","pa\"scaat kaisariyaanagaraat trayo janaa mannika.ta.m pre.sitaa yatra nive\"sane sthitoha.m tasmin samaye tatropaati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadaa ni.hsandeha.m tai.h saarddha.m yaatum aatmaa maamaadi.s.tavaan; tata.h para.m mayaa sahaite.su .sa.dbhraat.r.su gate.su vaya.m tasya manujasya g.rha.m praavi\"saama| ");
INSERT INTO sanvel_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sosmaaka.m nika.te kathaametaam akathayat ekadaa duuta eka.h pratyak.siibhuuya mama g.rhamadhye ti.s.tan maamityaaj naapitavaan, yaaphonagara.m prati lokaan prahitya pitaranaamnaa vikhyaata.m \"simonam aahuuyaya; ");
INSERT INTO sanvel_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadiiyaparivaaraa.naa nca yena paritraa.na.m bhavi.syati tat sa upadek.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","aha.m taa.m kathaamutthaapya kathitavaan tena prathamam asmaakam upari yathaa pavitra aatmaavaruu.dhavaan tathaa te.saamapyupari samavaruu.dhavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tena yohan jale majjitavaan iti satya.m kintu yuuya.m pavitra aatmani majjitaa bhavi.syatha, iti yadvaakya.m prabhuruditavaan tat tadaa mayaa sm.rtam| ");
INSERT INTO sanvel_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ata.h prabhaa yii\"sukhrii.s.te pratyayakaari.no ye vayam asmabhyam ii\"svaro yad dattavaan tat tebhyo lokebhyopi dattavaan tata.h koha.m? kimaham ii\"svara.m vaarayitu.m \"saknomi? ");
INSERT INTO sanvel_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathaametaa.m \"sruvaa te k.saantaa ii\"svarasya gu.naan anukiirttya kathitavanta.h, tarhi paramaayu.hpraaptinimittam ii\"svaronyade\"siiyalokebhyopi mana.hparivarttanaruupa.m daanam adaat| ");
INSERT INTO sanvel_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphaana.m prati upadrave gha.tite ye vikiir.naa abhavan tai phainiikiikupraantiyakhiyaasu bhramitvaa kevalayihuudiiyalokaan vinaa kasyaapyanyasya samiipa ii\"svarasya kathaa.m na praacaarayan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","apara.m te.saa.m kupriiyaa.h kuriiniiyaa\"sca kiyanto janaa aantiyakhiyaanagara.m gatvaa yuunaaniiyalokaanaa.m samiipepi prabhoryii\"so.h kathaa.m praacaarayan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabho.h karaste.saa.m sahaaya aasiit tasmaad aneke lokaa vi\"svasya prabhu.m prati paraavarttanta| ");
INSERT INTO sanvel_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vaarttaayaa.m yiruu\"saalamasthama.n.daliiyalokaanaa.m kar.nagocariibhuutaayaam aantiyakhiyaanagara.m gantu te bar.nabbaa.m prairayan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tato bar.nabbaastatra upasthita.h san ii\"svarasyaanugrahasya phala.m d.r.s.tvaa saanando jaata.h, ");
INSERT INTO sanvel_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svaya.m saadhu rvi\"svaasena pavitre.naatmanaa ca paripuur.na.h san ganoni.s.tayaa prabhaavaasthaa.m karttu.m sarvvaan upadi.s.tavaan tena prabho.h \"si.syaa aneke babhuuvu.h| ");
INSERT INTO sanvel_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","\"se.se \"saula.m m.rgayitu.m bar.nabbaastaar.sanagara.m prasthitavaan| tatra tasyodde\"sa.m praapya tam aantiyakhiyaanagaram aanayat; ");
INSERT INTO sanvel_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau ma.n.daliisthalokai.h sabhaa.m k.rtvaa sa.mvatsarameka.m yaavad bahulokaan upaadi\"sataa.m; tasmin aantiyakhiyaanagare \"si.syaa.h prathama.m khrii.s.tiiyanaamnaa vikhyaataa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tata.h para.m bhavi.syadvaadiga.ne yiruu\"saalama aantiyakhiyaanagaram aagate sati ");
INSERT INTO sanvel_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","aagaabanaamaa te.saameka utthaaya aatmana.h \"sik.sayaa sarvvade\"se durbhik.sa.m bhavi.syatiiti j naapitavaan; tata.h klaudiyakaisarasyaadhikaare sati tat pratyak.sam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmaat \"si.syaa ekaika\"sa.h svasva\"saktyanusaarato yihuudiiyade\"sanivaasinaa.m bhrat.r.naa.m dinayaapanaartha.m dhana.m pre.sayitu.m ni\"scitya ");
INSERT INTO sanvel_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","bar.nabbaa\"saulayo rdvaaraa praaciinalokaanaa.m samiipa.m tat pre.sitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samaye herod‌raajo ma.n.dalyaa.h kiyajjanebhyo du.hkha.m daatu.m praarabhat| ");
INSERT INTO sanvel_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","vi\"se.sato yohana.h sodara.m yaakuuba.m karavaalaaghaaten hatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmaad yihuudiiyaa.h santu.s.taa abhavan iti vij naaya sa pitaramapi dharttu.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadaa ki.nva\"suunyapuupotsavasamaya upaati.s.tat; ata utsave gate sati lokaanaa.m samak.sa.m ta.m bahiraaneyyaamiiti manasi sthiriik.rtya sa ta.m dhaarayitvaa rak.s.naartham ye.saam ekaikasa.mghe catvaaro janaa.h santi te.saa.m catur.naa.m rak.sakasa.mghaanaa.m samiipe ta.m samarpya kaaraayaa.m sthaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintu.m pitarasya kaaraasthitikaara.naat ma.n.dalyaa lokaa avi\"sraamam ii\"svarasya samiipe praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantara.m herodi ta.m bahiraanaayitu.m udyate sati tasyaa.m raatrau pitaro rak.sakadvayamadhyasthaane \"s.r\"nkhaladvayena baddhva.h san nidrita aasiit, dauvaarikaa\"sca kaaraayaa.h sammukhe ti.s.thanato dvaaram arak.si.su.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","etasmin samaye parame\"svarasya duute samupasthite kaaraa diiptimatii jaataa; tata.h sa duuta.h pitarasya kuk.saavaavaata.m k.rtvaa ta.m jaagarayitvaa bhaa.sitavaan tuur.namutti.s.tha; tatastasya hastastha\"s.r\"nkhaladvaya.m galat patita.m| ");
INSERT INTO sanvel_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa duutastamavadat, baddhaka.ti.h san paadayo.h paaduke arpaya; tena tathaa k.rte sati duutastam uktavaan gaatriiyavastra.m gaatre nidhaaya mama pa\"scaad ehi| ");
INSERT INTO sanvel_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tata.h pitarastasya pa\"scaad vrajana bahiragacchat, kintu duutena karmmaitat k.rtamiti satyamaj naatvaa svapnadar\"sana.m j naatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ittha.m tau prathamaa.m dvitiiyaa nca kaaraa.m la\"nghitvaa yena lauhanirmmitadvaare.na nagara.m gamyate tatsamiipa.m praapnutaa.m; tatastasya kavaa.ta.m svaya.m muktamabhavat tatastau tatsthaanaad bahi rbhuutvaa maargaikasya siimaa.m yaavad gatau; tato.akasmaat sa duuta.h pitara.m tyaktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadaa sa cetanaa.m praapya kathitavaan nijaduuta.m prahitya parame\"svaro herodo hastaad yihuudiiyalokaanaa.m sarvvaa\"saayaa\"sca maa.m samuddh.rtavaan ityaha.m ni\"scaya.m j naatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivicya maarkanaamraa vikhyaatasya yohano maatu rmariyamo yasmin g.rhe bahava.h sambhuuya praarthayanta tannive\"sana.m gata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitare.na bahirdvaara aahate sati rodaanaamaa baalikaa dra.s.tu.m gataa| ");
INSERT INTO sanvel_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tata.h pitarasya svara.m \"sruvaa saa har.sayuktaa satii dvaara.m na mocayitvaa pitaro dvaare ti.s.thatiiti vaarttaa.m vaktum abhyantara.m dhaavitvaa gatavatii| ");
INSERT INTO sanvel_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","te praavocan tvamunmattaa jaataasi kintu saa muhurmuhuruktavatii satyamevaitat| ");
INSERT INTO sanvel_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadaa te kathitavantastarhi tasya duuto bhavet| ");
INSERT INTO sanvel_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitaro dvaaramaahatavaan etasminnantare dvaara.m mocayitvaa pitara.m d.r.s.tvaa vismaya.m praaptaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tata.h pitaro ni.h\"sabda.m sthaatu.m taan prati hastena sa\"nketa.m k.rtvaa parame\"svaro yena prakaare.na ta.m kaaraayaa uddh.rtyaaniitavaan tasya v.rttaanta.m taanaj naapayat, yuuya.m gatvaa yaakuba.m bhraat.rga.na nca vaarttaametaa.m vadatetyuktaa sthaanaantara.m prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhaate sati pitara.h kva gata ityatra rak.sakaa.naa.m madhye mahaan kalaho jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","herod bahu m.rgayitvaa tasyodde\"se na praapte sati rak.sakaan sa.mp.rcchya te.saa.m praa.naan hantum aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","pa\"scaat sa yihuudiiyaprade\"saat kaisariyaanagara.m gatvaa tatraavaati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sorasiidonade\"sayo rlokebhyo herodi yuyutsau sati te sarvva ekamantra.naa.h santastasya samiipa upasthaaya lvaastanaamaana.m tasya vastrag.rhaadhii\"sa.m sahaaya.m k.rtvaa herodaa saarddha.m sandhi.m praarthayanta yatastasya raaj no de\"sena te.saa.m de\"siiyaanaa.m bhara.nam abhavat.m ");
INSERT INTO sanvel_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ata.h kutracin nirupitadine herod raajakiiya.m paricchada.m paridhaaya si.mhaasane samupavi\"sya taan prati kathaam uktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tato lokaa uccai.hkaara.m pratyavadan, e.sa manujaravo na hi, ii\"svariiyarava.h| ");
INSERT INTO sanvel_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadaa herod ii\"svarasya sammaana.m naakarot; tasmaaddheto.h parame\"svarasya duuto ha.thaat ta.m praaharat tenaiva sa kii.tai.h k.sii.na.h san praa.naan ajahaat| kintvii\"svarasya kathaa de\"sa.m vyaapya prabalaabhavat| tata.h para.m bar.nabbaa\"saulau yasya karmma.no bhaara.m praapnutaa.m taabhyaa.m tasmin sampaadite sati maarkanaamnaa vikhyaato yo yohan ta.m sa\"ngina.m k.rtvaa yiruu\"saalamnagaraat pratyaagatau| ");
INSERT INTO sanvel_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","apara nca bar.nabbaa.h, \"simon ya.m nigra.m vadanti, kuriiniiyaluukiyo herodaa raaj naa saha k.rtavidyaaाbhyaaso minahem, \"saula\"scaite ye kiyanto janaa bhavi.syadvaadina upade.s.taara\"scaantiyakhiyaanagarasthama.n.dalyaam aasan, ");
INSERT INTO sanvel_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","te yadopavaasa.m k.rtve\"svaram asevanta tasmin samaye pavitra aatmaa kathitavaan aha.m yasmin karmma.ni bar.nabbaa\"sailau niyuktavaan tatkarmma karttu.m tau p.rthak kuruta| ");
INSERT INTO sanvel_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavaasapraarthanayo.h k.rtayo.h satoste tayo rgaatrayo rhastaarpa.na.m k.rtvaa tau vyas.rjan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tata.h para.m tau pavitre.naatmanaa preritau santau siluukiyaanagaram upasthaaya samudrapathena kupropadviipam agacchataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tata.h saalaamiinagaram upasthaaya tatra yihuudiiyaanaa.m bhajanabhavanaani gatve\"svarasya kathaa.m praacaarayataa.m; yohanapi tatsahacaro.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ittha.m te tasyopadviipasya sarvvatra bhramanta.h paaphanagaram upasthitaa.h; tatra suvivecakena sarjiyapaulanaamnaa tadde\"saadhipatinaa saha bhavi.syadvaadino ve\"sadhaarii baryii\"sunaamaa yo maayaavii yihuudii aasiit ta.m saak.saat praaptavata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","tadde\"saadhipa ii\"svarasya kathaa.m \"srotu.m vaa nchan paulabar.nabbau nyamantrayat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumaa ya.m maayaavina.m vadanti sa de\"saadhipati.m dharmmamaargaad bahirbhuuta.m karttum ayatata| ");
INSERT INTO sanvel_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmaat \"solo.arthaat paula.h pavitre.naatmanaa paripuur.na.h san ta.m maayaavina.m pratyananyad.r.s.ti.m k.rtvaakathayat, ");
INSERT INTO sanvel_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","he narakin dharmmadve.sin kau.tilyadu.skarmmaparipuur.na, tva.m ki.m prabho.h satyapathasya viparyyayakara.naat kadaapi na nivartti.syase? ");
INSERT INTO sanvel_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunaa parame\"svarastava samucita.m kari.syati tena katipayadinaani tvam andha.h san suuryyamapi na drak.syasi| tatk.sa.naad raatrivad andhakaarastasya d.r.s.tim aacchaaditavaan; tasmaat tasya hasta.m dharttu.m sa lokamanvicchan itastato bhrama.na.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","enaa.m gha.tanaa.m d.r.s.tvaa sa de\"saadhipati.h prabhuupade\"saad vismitya vi\"svaasa.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantara.m paulastatsa\"nginau ca paaphanagaraat prota.m caalayitvaa pamphuliyaade\"sasya pargiinagaram agacchan kintu yohan tayo.h samiipaad etya yiruu\"saalama.m pratyaagacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","pa\"scaat tau pargiito yaatraa.m k.rtvaa pisidiyaade\"sasya aantiyakhiyaanagaram upasthaaya vi\"sraamavaare bhajanabhavana.m pravi\"sya samupaavi\"sataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthaabhavi.syadvaakyayo.h pa.thitayo.h sato rhe bhraatarau lokaan prati yuvayo.h kaacid upade\"sakathaa yadyasti tarhi taa.m vadata.m tau prati tasya bhajanabhavanasyaadhipataya.h kathaam etaa.m kathayitvaa prai.sayan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ata.h paula utti.s.than hastena sa\"nketa.m kurvvan kathitavaan he israayeliiyamanu.syaa ii\"svaraparaaya.naa.h sarvve lokaa yuuyam avadhaddha.m| ");
INSERT INTO sanvel_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ete.saamisraayellokaanaam ii\"svaro.asmaaka.m puurvvaparu.saan manoniitaan katvaa g.rhiitavaan tato misari de\"se pravasanakaale te.saamunnati.m k.rtvaa tasmaat sviiyabaahubalena taan bahi.h k.rtvaa samaanayat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","catvaari.m\"sadvatsaraan yaavacca mahaapraantare te.saa.m bhara.na.m k.rtvaa ");
INSERT INTO sanvel_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kinaande\"saantarvvarttii.ni saptaraajyaani naa\"sayitvaa gu.tikaapaatena te.su sarvvade\"se.su tebhyo.adhikaara.m dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","pa ncaa\"sadadhikacatu.h\"sate.su vatsare.su gate.su ca \"simuuyelbhavi.syadvaadiparyyanta.m te.saamupari vicaarayit.rn niyuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","tai\"sca raaj ni praarthite, ii\"svaro binyaamiino va.m\"sajaatasya kii\"sa.h putra.m \"saula.m catvaari.m\"sadvar.saparyyanta.m te.saamupari raajaana.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","pa\"scaat ta.m padacyuta.m k.rtvaa yo madi.s.takriyaa.h sarvvaa.h kari.syati taad.r\"sa.m mama manobhimatam eka.m jana.m yi\"saya.h putra.m daayuuda.m praaptavaan ida.m pramaa.na.m yasmin daayuudi sa dattavaan ta.m daayuuda.m te.saamupari raajatva.m karttum utpaaditavaana| ");
INSERT INTO sanvel_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svaprati\"srutasya vaakyasyaanusaare.na israayellokaanaa.m nimitta.m te.saa.m manu.syaa.naa.m va.m\"saad ii\"svara eka.m yii\"su.m (traataaram) udapaadayat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakaa\"sanaat puurvva.m yohan israayellokaanaa.m sannidhau mana.hparaavarttanaruupa.m majjana.m praacaarayat| ");
INSERT INTO sanvel_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya ca karmma.noे bhaara.m praptavaan yohan tan ni.spaadayan etaa.m kathaa.m kathitavaan, yuuya.m maa.m ka.m jana.m jaaniitha? aham abhi.siktatraataa nahi, kintu pa\"syata yasya paadayo.h paadukayo rbandhane mocayitumapi yogyo na bhavaami taad.r\"sa eko jano mama pa\"scaad upati.s.thati| ");
INSERT INTO sanvel_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","he ibraahiimo va.m\"sajaataa bhraataro he ii\"svarabhiitaa.h sarvvalokaa yu.smaan prati paritraa.nasya kathai.saa preritaa| ");
INSERT INTO sanvel_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yiruu\"saalamnivaasinaste.saam adhipataya\"sca tasya yii\"so.h paricaya.m na praapya prativi\"sraamavaara.m pa.thyamaanaanaa.m bhavi.syadvaadikathaanaam abhipraayam abuddhvaa ca tasya vadhena taa.h kathaa.h saphalaa akurvvan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","praa.nahananasya kamapi hetum apraapyaapi piilaatasya nika.te tasya vadha.m praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yaa.h kathaa likhitaa.h santi tadanusaare.na karmma sampaadya ta.m kru\"saad avataaryya \"sma\"saane \"saayitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvii\"svara.h \"sma\"saanaat tamudasthaapayat, ");
INSERT INTO sanvel_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","puna\"sca gaaliilaprade\"saad yiruu\"saalamanagara.m tena saarddha.m ye lokaa aagacchan sa bahudinaani tebhyo dar\"sana.m dattavaan, atasta idaanii.m lokaan prati tasya saak.si.na.h santi| ");
INSERT INTO sanvel_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmaaka.m puurvvapuru.saa.naa.m samak.sam ii\"svaro yasmin pratij naatavaan yathaa, tva.m me putrosi caadya tvaa.m samutthaapitavaanaham| ");
INSERT INTO sanvel_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ida.m yadvacana.m dvitiiyagiite likhitamaaste tad yii\"sorutthaanena te.saa.m santaanaa ye vayam asmaaka.m sannidhau tena pratyak.sii k.rta.m, yu.smaan ima.m susa.mvaada.m j naapayaami| ");
INSERT INTO sanvel_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","parame\"svare.na \"sma\"saanaad utthaapita.m tadiiya.m \"sariira.m kadaapi na k.se.syate, etasmin sa svaya.m kathitavaan yathaa daayuuda.m prati pratij naato yo varastamaha.m tubhya.m daasyaami| ");
INSERT INTO sanvel_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","etadanyasmin giite.api kathitavaan| svakiiya.m pu.nyavanta.m tva.m k.sayitu.m na ca daasyasi| ");
INSERT INTO sanvel_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","daayuudaa ii\"svaraabhimatasevaayai nijaayu.si vyayite sati sa mahaanidraa.m praapya nijai.h puurvvapuru.sai.h saha milita.h san ak.siiyata; ");
INSERT INTO sanvel_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamii\"svara.h \"sma\"saanaad udasthaapayat sa naak.siiyata| ");
INSERT INTO sanvel_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ato he bhraatara.h, anena janena paapamocana.m bhavatiiti yu.smaan prati pracaaritam aaste| ");
INSERT INTO sanvel_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalato muusaavyavasthayaa yuuya.m yebhyo do.sebhyo muktaa bhavitu.m na \"sak.syatha tebhya.h sarvvado.sebhya etasmin jane vi\"svaasina.h sarvve muktaa bhavi.syantiiti yu.smaabhi rj naayataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","apara nca| avaj naakaari.no lokaa\"scak.surunmiilya pa\"syata| tathaivaasambhava.m j naatvaa syaata yuuya.m vilajjitaa.h| yato yu.smaasu ti.s.thatsu kari.sye karmma taad.r\"sa.m| yenaiva tasya v.rttaante yu.smabhya.m kathite.api hi| yuuya.m na tantu v.rttaanta.m pratye.syatha kadaacana|| ");
INSERT INTO sanvel_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yeya.m kathaa bhavi.syadvaadinaa.m granthe.su likhitaaste saavadhaanaa bhavata sa kathaa yathaa yu.smaan prati na gha.tate| ");
INSERT INTO sanvel_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihuudiiyabhajanabhavanaan nirgatayostayo rbhinnade\"siiyai rvak.syamaa.naa praarthanaa k.rtaa, aagaamini vi\"sraamavaare.api katheyam asmaan prati pracaaritaa bhavatviti| ");
INSERT INTO sanvel_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhaayaa bha\"nge sati bahavo yihuudiiyalokaa yihuudiiyamatagraahi.no bhaktalokaa\"sca bar.nabbaapaulayo.h pa\"scaad aagacchan, tena tau tai.h saha naanaakathaa.h kathayitve\"svaraanugrahaa\"sraye sthaatu.m taan praavarttayataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paravi\"sraamavaare nagarasya praaye.na sarvve laakaa ii\"svariiyaa.m kathaa.m \"srotu.m militaa.h, ");
INSERT INTO sanvel_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihuudiiyalokaa jananivaha.m vilokya iir.syayaa paripuur.naa.h santo vipariitakathaakathanene\"svaranindayaa ca paulenoktaa.m kathaa.m kha.n.dayitu.m ce.s.titavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tata.h pauैlabar.nabbaavak.sobhau kathitavantau prathama.m yu.smaaka.m sannidhaavii\"svariiyakathaayaa.h pracaara.nam ucitamaasiit kintu.m tadagraahyatvakara.nena yuuya.m svaan anantaayu.so.ayogyaan dar\"sayatha, etatkaara.naad vayam anyade\"siiyalokaanaa.m samiipa.m gacchaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmaan ittham aadi.s.tavaan yathaa, yaavacca jagata.h siimaa.m lokaanaa.m traa.nakaara.naat| mayaanyade\"samadhye tva.m sthaapito bhuu.h pradiipavat|| ");
INSERT INTO sanvel_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadaa kathaamiid.r\"sii.m \"srutvaa bhinnade\"siiyaa aahlaaditaa.h santa.h prabho.h kathaa.m dhanyaa.m dhanyaam avadan, yaavanto lokaa\"sca paramaayu.h praaptinimitta.m niruupitaa aasan teे vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ittha.m prabho.h kathaa sarvvede\"sa.m vyaapnot| ");
INSERT INTO sanvel_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihuudiiyaa nagarasya pradhaanapuru.saan sammaanyaa.h kathipayaa bhaktaa yo.sita\"sca kuprav.rtti.m graahayitvaa paulabar.nabbau taa.dayitvaa tasmaat prade\"saad duuriik.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ata.h kaara.naat tau nijapadadhuuliiste.saa.m praatikuulyena paatayitveेkaniya.m nagara.m gatau| ");
INSERT INTO sanvel_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tata.h \"si.syaga.na aanandena pavitre.naatmanaa ca paripuur.nobhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihuudiiyaanaa.m bhajanabhavana.m gatvaa yathaa bahavo yihuudiiyaa anyadeे\"siiyalokaa\"sca vya\"svasan taad.r\"sii.m kathaa.m kathitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu vi\"svaasahiinaa yihuudiiyaa anyade\"siiyalokaan kuprav.rtti.m graahayitvaa bhraat.rga.na.m prati te.saa.m vaira.m janitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ata.h svaanugrahakathaayaa.h pramaa.na.m datvaa tayo rhastai rbahulak.sa.nam adbhutakarmma ca praakaa\"sayad ya.h prabhustasya kathaa ak.sobhena pracaaryya tau tatra bahudinaani samavaati.s.thetaa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyanto lokaa yihuudiiyaanaa.m sapak.saa.h kiyanto lokaa.h preritaanaa.m sapak.saa jaataa.h, ato naagarikajananivahamadhye bhinnavaakyatvam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyade\"siiyaa yihuudiiyaaste.saam adhipataya\"sca dauraatmya.m kutvaa tau prastarairaahantum udyataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvaarttaa.m praapya palaayitvaa lukaayaniyaade\"sasyaantarvvarttilustraadarbbo ");
INSERT INTO sanvel_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamiipasthade\"sa nca gatvaa tatra susa.mvaada.m pracaarayataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrobhayapaadayo\"scalana\"saktihiino janmaarabhya kha nja.h kadaapi gamana.m naakarot etaad.r\"sa eko maanu.so lustraanagara upavi\"sya paulasya kathaa.m \"srutavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","etasmin samaye paulastamprati d.r.s.ti.m k.rtvaa tasya svaasthye vi\"svaasa.m viditvaa proccai.h kathitavaan ");
INSERT INTO sanvel_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyaamutti.s.than .rju rbhava|tata.h sa ullampha.m k.rtvaa gamanaagamane kutavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadaa lokaa.h paulasya tat kaaryya.m vilokya lukaayaniiyabhaa.sayaa proccai.h kathaametaa.m kathitavanta.h, devaa manu.syaruupa.m dh.rtvaasmaaka.m samiipam avaarohan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","te bar.nabbaa.m yuupitaram avadan paula\"sca mukhyo vaktaa tasmaat ta.m markuriyam avadan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhe sthaapitasya yuupitaravigrahasya yaajako v.r.saan pu.spamaalaa\"sca dvaarasamiipam aaniiya lokai.h sarddha.m taavuddi\"sya samuts.rjya daatum udyata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvaarttaa.m \"srutvaa bar.nabbaapaulau sviiyavastraa.ni chitvaa lokaanaa.m madhya.m vegena pravi\"sya proccai.h kathitavantau, ");
INSERT INTO sanvel_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","he mahecchaa.h kuta etaad.r\"sa.m karmma kurutha? aavaamapi yu.smaad.r\"sau sukhadu.hkhabhoginau manu.syau, yuyam etaa.h sarvvaa v.rthaakalpanaa.h parityajya yathaa gaga.navasundharaajalanidhiinaa.m tanmadhyasthaanaa.m sarvve.saa nca sra.s.taaramamaram ii\"svara.m prati paraavarttadhve tadartham aavaa.m yu.smaaka.m sannidhau susa.mvaada.m pracaarayaava.h| ");
INSERT INTO sanvel_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa ii\"svara.h puurvvakaale sarvvade\"siiyalokaan svasvamaarge calitumanumati.m dattavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathaapi aakaa\"saat toyavar.sa.nena naanaaprakaara\"sasyotpatyaa ca yu.smaaka.m hitai.sii san bhak.syairaananadena ca yu.smaakam anta.hkara.naani tarpayan taani daanaani nijasaak.sisvaruupaa.ni sthapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu taad.r\"saayaa.m kathaayaa.m kathitaayaamapi tayo.h samiipa utsarjanaat lokanivaha.m praaye.na nivarttayitu.m naa\"saknutaam| ");
INSERT INTO sanvel_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","aantiyakhiyaa-ikaniyanagaraabhyaa.m katipayayihuudiiyalokaa aagatya lokaan praavarttayanta tasmaat tai paula.m prastarairaaghnan tena sa m.rta iti vij naaya nagarasya bahistam aak.r.sya niitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu \"si.syaga.ne tasya caturdi\"si ti.s.thati sati sa svayam utthaaya punarapi nagaramadhya.m praavi\"sat tatpare.ahani bar.nabbaasahito darbbiinagara.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susa.mvaada.m pracaaryya bahulokaan \"si.syaan k.rtvaa tau lustraam ikaniyam aantiyakhiyaa nca paraav.rtya gatau| ");
INSERT INTO sanvel_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahudu.hkhaani bhuktvaapii\"svararaajya.m prave.s.tavyam iti kaara.naad dharmmamaarge sthaatu.m vinaya.m k.rtvaa \"si.syaga.nasya mana.hsthairyyam akurutaa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ma.n.daliinaa.m praaciinavargaan niyujya praarthanopavaasau k.rtvaa yatprabhau te vya\"svasan tasya haste taan samarpya ");
INSERT INTO sanvel_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyaamadhyena paamphuliyaade\"sa.m gatavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","pa\"scaat pargaanagara.m gatvaa susa.mvaada.m pracaaryya attaaliyaanagara.m prasthitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmaat samudrapathena gatvaa taabhyaa.m yat karmma sampanna.m tatkarmma saadhayitu.m yannagare dayaalorii\"svarasya haste samarpitau jaatau tad aantiyakhiyaanagara.m gatavantaa| ");
INSERT INTO sanvel_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatropasthaaya tannagarasthama.n.dalii.m sa.mg.rhya svaabhyaama ii\"svaro yadyat karmmakarot tathaa yena prakaare.na bhinnade\"siiyalokaan prati vi\"svaasaruupadvaaram amocayad etaan sarvvav.rttaantaan taan j naapitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau \"siryyai.h saarddha.m tatra bahudinaani nyavasataam| ");
INSERT INTO sanvel_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihuudaade\"saat kiyanto janaa aagatya bhraat.rga.namittha.m \"sik.sitavanto muusaavyavasthayaa yadi yu.smaaka.m tvakchedo na bhavati tarhi yuuya.m paritraa.na.m praaptu.m na \"sak.syatha| ");
INSERT INTO sanvel_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabar.nabbau tai.h saha bahuun vicaaraan vivaadaa.m\"sca k.rtavantau, tato ma.n.daliiyanokaa etasyaa.h kathaayaastattva.m j naatu.m yiruu\"saalamnagarasthaan preritaan praaciinaa.m\"sca prati paulabar.nabbaaprabh.rtiin katipayajanaan pre.sayitu.m ni\"scaya.m k.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","te ma.n.dalyaa preritaa.h santa.h phai.niikii\"somironde\"saabhyaa.m gatvaa bhinnade\"siiyaanaa.m mana.hparivarttanasya vaarttayaa bhraat.r.naa.m paramaahlaadam ajanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yiruu\"saalamyupasthaaya preritaga.nena lokapraaciinaga.nena samaajena ca samupag.rhiitaa.h santa.h svairii\"svaro yaani karmmaa.ni k.rtavaan te.saa.m sarvvav.rttaantaan te.saa.m samak.sam akathayan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu vi\"svaasina.h kiyanta.h phiruu\"simatagraahi.no lokaa utthaaya kathaametaa.m kathitavanto bhinnade\"siiyaanaa.m tvakcheda.m karttu.m muusaavyavasthaa.m paalayitu nca samaade.s.tavyam| ");
INSERT INTO sanvel_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tata.h preritaa lokapraaciinaa\"sca tasya vivecanaa.m karttu.m sabhaayaa.m sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvicaare.su jaata.su pitara utthaaya kathitavaan, he bhraataro yathaa bhinnade\"siiyalokaa mama mukhaat susa.mvaada.m \"srutvaa vi\"svasanti tadartha.m bahudinaat puurvvam ii\"svarosmaaka.m madhye maa.m v.rtvaa niyuktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyaamii\"svaro yathaasmabhya.m tathaa bhinnade\"siiyebhya.h pavitramaatmaana.m pradaaya vi\"svaasena te.saam anta.hkara.naani pavitraa.ni k.rtvaa ");
INSERT INTO sanvel_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","te.saam asmaaka nca madhye kimapi vi\"se.sa.m na sthaapayitvaa taanadhi svaya.m pramaa.na.m dattavaan iti yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataevaasmaaka.m puurvvapuru.saa vaya nca svaya.m yadyugasya bhaara.m so.dhu.m na \"saktaa.h samprati ta.m \"si.syaga.nasya skandhe.su nyasitu.m kuta ii\"svarasya pariik.saa.m kari.syatha? ");
INSERT INTO sanvel_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabho ryii\"sukhrii.s.tasyaanugrahe.na te yathaa vayamapi tathaa paritraa.na.m praaptum aa\"saa.m kurmma.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantara.m bar.nabbaapaulaabhyaam ii\"svaro bhinnade\"siiyaanaa.m madhye yadyad aa\"scaryyam adbhuta nca karmma k.rtavaan tadv.rttaanta.m tau svamukhaabhyaam avar.nayataa.m sabhaasthaa.h sarvve niiravaa.h santa.h \"srutavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayo.h kathaayaa.m samaaptaayaa.m satyaa.m yaakuub kathayitum aarabdhavaan ");
INSERT INTO sanvel_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","he bhraataro mama kathaayaam mano nidhatta| ii\"svara.h svanaamaartha.m bhinnade\"siiyalokaanaam madhyaad eka.m lokasa.mgha.m grahiitu.m mati.m k.rtvaa yena prakaare.na prathama.m taan prati k.rpaavalekana.m k.rtavaan ta.m \"simon var.nitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhavi.syadvaadibhiruktaani yaani vaakyaani tai.h saarddham etasyaikya.m bhavati yathaa likhitamaaste| ");
INSERT INTO sanvel_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvve.saa.m karmma.naa.m yastu saadhaka.h parame\"svara.h| sa eveda.m vadedvaakya.m \"se.saa.h sakalamaanavaa.h| bhinnade\"siiyalokaa\"sca yaavanto mama naamata.h| bhavanti hi suvikhyaataaste yathaa parame\"situ.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatva.m samyak samiihante tannimittamaha.m kila| paraav.rtya samaagatya daayuuda.h patita.m puna.h| duu.syamutthaapayi.syaami tadiiya.m sarvvavastu ca| patita.m punaruthaapya sajjayi.syaami sarvvathaa|| ");
INSERT INTO sanvel_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","aa prathamaad ii\"svara.h sviiyaani sarvvakarmmaa.ni jaanaati| ");
INSERT INTO sanvel_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataeva mama nivedanamida.m bhinnade\"siiyalokaanaa.m madhye ye janaa ii\"svara.m prati paraavarttanta te.saamupari anya.m kamapi bhaara.m na nyasya ");
INSERT INTO sanvel_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","devataaprasaadaa\"sucibhak.sya.m vyabhicaarakarmma ka.n.thasampii.danamaaritapraa.nibhak.sya.m raktabhak.sya nca etaani parityaktu.m likhaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yata.h puurvvakaalato muusaavyavasthaapracaari.no lokaa nagare nagare santi prativi\"sraamavaara nca bhajanabhavane tasyaa.h paa.tho bhavati| ");
INSERT INTO sanvel_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tata.h para.m preritaga.no lokapraaciinaga.na.h sarvvaa ma.n.dalii ca sve.saa.m madhye bar\"sabbaa naamnaa vikhyaato manoniitau k.rtvaa paulabar.nabbaabhyaa.m saarddham aantiyakhiyaanagara.m prati pre.sa.nam ucita.m buddhvaa taabhyaa.m patra.m prai.sayan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patre likhitami.mda, aantiyakhiyaa-suriyaa-kilikiyaade\"sasthabhinnade\"siiyabhraat.rga.naaya preritaga.nasya lokapraaciinaga.nasya bhraat.rga.nasya ca namaskaara.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","vi\"se.sato.asmaakam aaj naam apraapyaapi kiyanto janaa asmaaka.m madhyaad gatvaa tvakchedo muusaavyavasthaa ca paalayitavyaaviti yu.smaan \"sik.sayitvaa yu.smaaka.m manasaamasthairyya.m k.rtvaa yu.smaan sasandehaan akurvvan etaa.m kathaa.m vayam a\"s.rnma| ");
INSERT INTO sanvel_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkaara.naad vayam ekamantra.naa.h santa.h sabhaayaa.m sthitvaa prabho ryii\"sukhrii.s.tasya naamanimitta.m m.rtyumukhagataabhyaamasmaaka.m ");
INSERT INTO sanvel_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabar.nabbaapaulaabhyaa.m saarddha.m manoniitalokaanaa.m ke.saa ncid yu.smaaka.m sannidhau pre.sa.nam ucita.m buddhavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ato yihuudaasiilau yu.smaan prati pre.sitavanta.h, etayo rmukhaabhyaa.m sarvvaa.m kathaa.m j naasyatha| ");
INSERT INTO sanvel_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","devataaprasaadabhak.sya.m raktabhak.sya.m galapii.danamaaritapraa.nibhak.sya.m vyabhicaarakarmma cemaani sarvvaa.ni yu.smaabhistyaajyaani; etatprayojaniiyaaj naavyatirekena yu.smaakam upari bhaaramanya.m na nyasitu.m pavitrasyaatmano.asmaaka nca ucitaj naanam abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataeva tebhya.h sarvvebhya.h sve.su rak.site.su yuuya.m bhadra.m karmma kari.syatha| yu.smaaka.m ma\"ngala.m bhuuyaat| ");
INSERT INTO sanvel_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","teे vis.r.s.taa.h santa aantiyakhiyaanagara upasthaaya lokanivaha.m sa.mg.rhya patram adadan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tataste tatpatra.m pa.thitvaa saantvanaa.m praapya saanandaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihuudaasiilau ca svaya.m pracaarakau bhuutvaa bhraat.rga.na.m naanopadi\"sya taan susthiraan akurutaam| ");
INSERT INTO sanvel_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ittha.m tau tatra tai.h saaka.m katipayadinaani yaapayitvaa pa\"scaat preritaanaa.m samiipe pratyaagamanaartha.m te.saa.m sannidhe.h kalyaa.nena vis.r.s.taavabhavataa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu siilastatra sthaatu.m vaa nchitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","apara.m paulabar.nabbau bahava.h \"si.syaa\"sca lokaan upadi\"sya prabho.h susa.mvaada.m pracaarayanta aantiyakhiyaayaa.m kaala.m yaapitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadine.su gate.su paulo bar.nabbaam avadat aagacchaavaa.m ye.su nagare.svii\"svarasya susa.mvaada.m pracaaritavantau taani sarvvanagaraa.ni punargatvaa bhraatara.h kiid.r\"saa.h santiiti dra.s.tu.m taan saak.saat kurvva.h| ");
INSERT INTO sanvel_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tena maarkanaamnaa vikhyaata.m yohana.m sa\"ngina.m karttu.m bar.nabbaa matimakarot, ");
INSERT INTO sanvel_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa puurvva.m taabhyaa.m saha kaaryyaartha.m na gatvaa paamphuuliyaade\"se tau tyaktavaan tatkaara.naat paulasta.m sa\"ngina.m karttum anucita.m j naatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ittha.m tayorati\"sayavirodhasyopasthitatvaat tau paraspara.m p.rthagabhavataa.m tato bar.nabbaa maarka.m g.rhiitvaa potena kupropadviipa.m gatavaan; ");
INSERT INTO sanvel_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paula.h siila.m manoniita.m k.rtvaa bhraat.rbhirii\"svaraanugrahe samarpita.h san prasthaaya ");
INSERT INTO sanvel_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyaakilikiyaade\"saabhyaa.m ma.n.dalii.h sthiriikurvvan agacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulo darbbiilustraanagarayorupasthitobhavat tatra tiimathiyanaamaa \"si.sya eka aasiit; sa vi\"svaasinyaa yihuudiiyaayaa yo.sito garbbhajaata.h kintu tasya pitaanyade\"siiyaloka.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa jano lustraa-ikaniyanagarasthaanaa.m bhraat.r.naa.m samiipepi sukhyaatimaan aasiit| ");
INSERT INTO sanvel_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulasta.m svasa\"ngina.m karttu.m mati.m k.rtvaa ta.m g.rhiitvaa tadde\"sanivaasinaa.m yihuudiiyaanaam anurodhaat tasya tvakcheda.m k.rtavaan yatastasya pitaa bhinnade\"siiyaloka iti sarvvairaj naayata| ");
INSERT INTO sanvel_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tata.h para.m te nagare nagare bhramitvaa yiruu\"saalamasthai.h preritai rlokapraaciinai\"sca niruupita.m yad vyavasthaapatra.m tadanusaare.naacaritu.m lokebhyastad dattavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tenaiva sarvve dharmmasamaajaa.h khrii.s.tadharmme susthiraa.h santa.h pratidina.m varddhitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","te.su phrugiyaagaalaatiyaade\"samadhyena gate.su satsu pavitra aatmaa taan aa\"siyaade\"se kathaa.m prakaa\"sayitu.m prati.siddhavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathaa musiyaade\"sa upasthaaya bithuniyaa.m gantu.m tairudyoge k.rte aatmaa taan naanvamanyata| ");
INSERT INTO sanvel_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmaat te musiyaade\"sa.m parityajya troyaanagara.m gatvaa samupasthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","raatrau paula.h svapne d.r.s.tavaan eko maakidaniyalokasti.s.than vinaya.m k.rtvaa tasmai kathayati, maakidaniyaade\"sam aagatyaasmaan upakurvviti| ");
INSERT INTO sanvel_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyettha.m svapnadar\"sanaat prabhustadde\"siiyalokaan prati susa.mvaada.m pracaarayitum asmaan aahuuyatiiti ni\"scita.m buddhvaa vaya.m tuur.na.m maakidaniyaade\"sa.m gantum udyogam akurmma| ");
INSERT INTO sanvel_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tata.h para.m vaya.m troyaanagaraad prasthaaya .rjumaarge.na saamathraakiyopadviipena gatvaa pare.ahani niyaapalinagara upasthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmaad gatvaa maakidaniyaantarvvartti romiiyavasatisthaana.m yat philipiinaamapradhaananagara.m tatropasthaaya katipayadinaani tatra sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","vi\"sraamavaare nagaraad bahi rgatvaa nadiita.te yatra praarthanaacaara aasiit tatropavi\"sya samaagataa naarii.h prati kathaa.m praacaarayaama| ");
INSERT INTO sanvel_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tata.h thuyaatiiraanagariiyaa dhuu.saraambaravikraayi.nii ludiyaanaamikaa yaa ii\"svarasevikaa yo.sit \"srotrii.naa.m madhya aasiit tayaa pauloktavaakyaani yad g.rhyante tadartha.m prabhustasyaa manodvaara.m muktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ata.h saa yo.sit saparivaaraa majjitaa satii vinaya.m k.rtvaa kathitavatii, yu.smaaka.m vicaaraad yadi prabhau vi\"svaasinii jaataaha.m tarhi mama g.rham aagatya ti.s.thata| ittha.m saa yatnenaasmaan asthaapayat| ");
INSERT INTO sanvel_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyaa ga.nanayaa tadadhipatiinaa.m bahudhanopaarjana.m jaata.m taad.r\"sii ga.nakabhuutagrastaa kaacana daasii praarthanaasthaanagamanakaala aagatyaasmaan saak.saat k.rtavatii| ");
INSERT INTO sanvel_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","saasmaaka.m paulasya ca pa\"scaad etya proccai.h kathaamimaa.m kathitavatii, manu.syaa ete sarvvoparisthasye\"svarasya sevakaa.h santo.asmaan prati paritraa.nasya maarga.m prakaa\"sayanti| ");
INSERT INTO sanvel_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","saa kanyaa bahudinaani taad.r\"sam akarot tasmaat paulo du.hkhita.h san mukha.m paraavartya ta.m bhuutamavadad, aha.m yii\"sukhrii.s.tasya naamnaa tvaamaaj naapayaami tvamasyaa bahirgaccha; tenaiva tatk.sa.naat sa bhuutastasyaa bahirgata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tata.h sve.saa.m laabhasya pratyaa\"saa viphalaa jaateti vilokya tasyaa.h prabhava.h paula.m siila nca dh.rtvaak.r.sya vicaarasthaane.adhipatiinaa.m samiipam aanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tata.h \"saasakaanaa.m nika.ta.m niitvaa romilokaa vayam asmaaka.m yad vyavahara.na.m grahiitum aacaritu nca ni.siddha.m, ");
INSERT INTO sanvel_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ime yihuudiiyalokaa.h santopi tadeva \"sik.sayitvaa nagare.asmaakam atiiva kalaha.m kurvvanti, ");
INSERT INTO sanvel_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathite sati lokanivahastayo.h praatikuulyenodati.s.that tathaa \"saasakaastayo rvastraa.ni chitvaa vetraaghaata.m karttum aaj naapayan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","apara.m te tau bahu prahaaryya tvametau kaaraa.m niitvaa saavadhaana.m rak.sayeti kaaraarak.sakam aadi\"san| ");
INSERT INTO sanvel_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham aaj naa.m praapya sa taavabhyantarasthakaaraa.m niitvaa paade.su paadapaa\"siibhi rbaddhvaa sthaapitaavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha ni\"siithasamaye paulasiilaavii\"svaramuddi\"sya praathanaa.m gaana nca k.rtavantau, kaaraasthitaa lokaa\"sca tada\"s.r.nvan ");
INSERT INTO sanvel_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadaakasmaat mahaan bhuumikampo.abhavat tena bhittimuulena saha kaaraa kampitaabhuut tatk.sa.naat sarvvaa.ni dvaaraa.ni muktaani jaataani sarvve.saa.m bandhanaani ca muktaani| ");
INSERT INTO sanvel_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataeva kaaraarak.sako nidraato jaagaritvaa kaaraayaa dvaaraa.ni muktaani d.r.s.tvaa bandilokaa.h palaayitaa ityanumaaya ko.saat kha\"nga.m bahi.h k.rtvaatmaghaata.m karttum udyata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paula.h proccaistamaahuuya kathitavaan pa\"sya vaya.m sarvve.atraasmahe, tva.m nijapraa.nahi.msaa.m maakaar.sii.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadaa pradiipam aanetum uktvaa sa kampamaana.h san ullampyaabhyantaram aagatya paulasiilayo.h paade.su patitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","pa\"scaat sa tau bahiraaniiya p.r.s.tavaan he mahecchau paritraa.na.m praaptu.m mayaa ki.m karttavya.m? ");
INSERT INTO sanvel_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","pa\"scaat tau svag.rhamaaniiya tayo.h sammukhe khaadyadravyaa.ni sthaapitavaan tathaa sa svaya.m tadiiyaa.h sarvve parivaaraa\"sce\"svare vi\"svasanta.h saananditaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya g.rhasthitasarvvalokebhya\"sca prabho.h kathaa.m kathitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathaa raatrestasminneva da.n.de sa tau g.rhiitvaa tayo.h prahaaraa.naa.m k.sataani prak.saalitavaan tata.h sa svaya.m tasya sarvve parijanaa\"sca majjitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","pa\"scaat tau svag.rhamaaniiya tayo.h sammukhe khaadyadravyaa.ni sthaapitavaan tathaa sa svaya.m tadiiyaa.h sarvve parivaaraa\"sce\"svare vi\"svasanta.h saananditaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthite tau lokau mocayeti kathaa.m kathayitu.m \"saasakaa.h padaatiga.na.m pre.sitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tata.h kaaraarak.saka.h paulaaya taa.m vaarttaa.m kathitavaan yuvaa.m tyaajayitu.m \"saasakaa lokaana pre.sitavanta idaanii.m yuvaa.m bahi rbhuutvaa ku\"salena prati.s.thetaa.m| ");
INSERT INTO sanvel_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastaan avadat romilokayoraavayo.h kamapi do.sam na ni\"scitya sarvve.saa.m samak.sam aavaa.m ka\"sayaa taa.dayitvaa kaaraayaa.m baddhavanta idaanii.m kimaavaa.m gupta.m vistrak.syanti? tanna bhavi.syati, svayamaagatyaavaa.m bahi.h k.rtvaa nayantu| ");
INSERT INTO sanvel_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadaa padaatibhi.h \"saasakebhya etadvaarttaayaa.m kathitaayaa.m tau romilokaaviti kathaa.m \"srutvaa te bhiitaa.h ");
INSERT INTO sanvel_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayo.h sannidhimaagatya vinayam akurvvan apara.m bahi.h k.rtvaa nagaraat prasthaatu.m praarthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kaaraayaa nirgatya ludiyaayaa g.rha.m gatavantau tatra bhraat.rga.na.m saak.saatk.rtya taan saantvayitvaa tasmaat sthaanaat prasthitau| ");
INSERT INTO sanvel_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasiilau aamphipalyaapalloniyaanagaraabhyaa.m gatvaa yatra yihuudiiyaanaa.m bhajanabhavanamekam aaste tatra thi.salaniikiinagara upasthitau| ");
INSERT INTO sanvel_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadaa paula.h svaacaaraanusaare.na te.saa.m samiipa.m gatvaa vi\"sraamavaaratraye tai.h saarddha.m dharmmapustakiiyakathaayaa vicaara.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalata.h khrii.s.tena du.hkhabhoga.h karttavya.h \"sma\"saanadutthaana nca karttavya.m yu.smaaka.m sannidhau yasya yii\"so.h prastaava.m karomi sa ii\"svare.naabhi.sikta.h sa etaa.h kathaa.h prakaa\"sya pramaa.na.m datvaa sthiriik.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmaat te.saa.m katipayajanaa anyade\"siiyaa bahavo bhaktalokaa bahya.h pradhaananaaryya\"sca vi\"svasya paulasiilayo.h pa\"scaadgaamino jaataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu vi\"svaasahiinaa yihuudiiyalokaa iir.syayaa paripuur.naa.h santo ha.ta.tsya katinayalampa.talokaan sa\"ngina.h k.rtvaa janatayaa nagaramadhye mahaakalaha.m k.rtvaa yaasono g.rham aakramya preritaan dh.rtvaa lokanivahasya samiipam aanetu.m ce.s.titavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","te.saamudde\"sam apraapya ca yaasona.m katipayaan bhraat.r.m\"sca dh.rtvaa nagaraadhipatiinaa.m nika.tamaaniiya proccai.h kathitavanto ye manu.syaa jagadudvaa.titavantaste .atraapyupasthitaa.h santi, ");
INSERT INTO sanvel_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","e.sa yaason aatithya.m k.rtvaa taan g.rhiitavaan| yii\"sunaamaka eko raajastiiti kathayantaste kaisarasyaaj naaviruddha.m karmma kurvvati| ");
INSERT INTO sanvel_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","te.saa.m kathaamimaa.m \"srutvaa lokanivaho nagaraadhipataya\"sca samudvignaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadaa yaasonastadanye.saa nca dhanada.n.da.m g.rhiitvaa taan parityaktavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tata.h para.m bhraat.rga.no rajanyaa.m paulasiilau \"siighra.m birayaanagara.m pre.sitavaan tau tatropasthaaya yihuudiiyaanaa.m bhajanabhavana.m gatavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthaa lokaa.h thi.salaniikiisthalokebhyo mahaatmaana aasan yata ittha.m bhavati na veti j naatu.m dine dine dharmmagranthasyaalocanaa.m k.rtvaa svaira.m kathaam ag.rhlan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmaad aneke yihuudiiyaa anyade\"siiyaanaa.m maanyaa striya.h puru.saa\"scaaneke vya\"svasan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayaanagare paulene\"svariiyaa kathaa pracaaryyata iti thi.salaniikiisthaa yihuudiiyaa j naatvaa tatsthaanamapyaagatya lokaanaa.m kuprav.rttim ajanayan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataeva tasmaat sthaanaat samudre.na yaantiiti dar\"sayitvaa bhraatara.h k.sipra.m paula.m praahi.nvan kintu siilatiimathiyau tatra sthitavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tata.h para.m paulasya maargadar\"sakaastam aathiiniinagara upasthaapayan pa\"scaad yuvaa.m tuur.nam etat sthaana.m aagami.syatha.h siilatiimathiyau pratiimaam aaj naa.m praapya te pratyaagataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula aathiiniinagare taavapek.sya ti.s.than tannagara.m pratimaabhi.h paripuur.na.m d.r.s.tvaa santaptah.rdayo .abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tata.h sa bhajanabhavane yaan yihuudiiyaan bhaktalokaa.m\"sca ha.t.te ca yaan apa\"syat tai.h saha pratidina.m vicaaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikuuriiyamatagrahi.na.h stoyikiiyamatagraahi.na\"sca kiyanto janaastena saarddha.m vyavadanta| tatra kecid akathayan e.sa vaacaala.h ki.m vaktum icchati? apare kecid e.sa jana.h ke.saa ncid vide\"siiyadevaanaa.m pracaaraka ityanumiiyate yata.h sa yii\"sum utthiti nca pracaarayat| ");
INSERT INTO sanvel_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","te tam areyapaaganaama vicaarasthaanam aaniiya praavocan ida.m yannaviina.m mata.m tva.m praaciika\"sa ida.m kiid.r\"sa.m etad asmaan \"sraavaya; ");
INSERT INTO sanvel_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yaamimaam asambhavakathaam asmaaka.m kar.nagocariik.rtavaan asyaa bhaavaartha.h ka iti vaya.m j naatum icchaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadaathiiniinivaasinastannagarapravaasina\"sca kevala.m kasyaa\"scana naviinakathaayaa.h \"srava.nena pracaara.nena ca kaalam ayaapayan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulo.areyapaagasya madhye ti.s.than etaa.m kathaa.m pracaaritavaan, he aathiiniiyalokaa yuuya.m sarvvathaa devapuujaayaam aasaktaa ityaha pratyak.sa.m pa\"syaami| ");
INSERT INTO sanvel_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yata.h paryya.tanakaale yu.smaaka.m puujaniiyaani pa\"syan ‘avij naate\"svaraaya` etallipiyuktaa.m yaj navediimekaa.m d.r.s.tavaan; ato na viditvaa ya.m puujayadhve tasyaiva tatva.m yu.smaan prati pracaarayaami| ");
INSERT INTO sanvel_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagato jagatsthaanaa.m sarvvavastuunaa nca sra.s.taa ya ii\"svara.h sa svargap.rthivyorekaadhipati.h san karanirmmitamandire.su na nivasati; ");
INSERT INTO sanvel_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa eva sarvvebhyo jiivana.m praa.naan sarvvasaamagrii\"sca pradadaati; ataeva sa kasyaa\"scit saamagyraa abhaavaheto rmanu.syaa.naa.m hastai.h sevito bhavatiiti na| ");
INSERT INTO sanvel_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhuuma.n.dale nivaasaartham ekasmaat \"so.nitaat sarvvaan manu.syaan s.r.s.tvaa te.saa.m puurvvaniruupitasamaya.m vasatisiimaa nca niracinot; ");
INSERT INTO sanvel_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmaat lokai.h kenaapi prakaare.na m.rgayitvaa parame\"svarasya tatva.m praaptu.m tasya gave.sa.na.m kara.niiyam| ");
INSERT INTO sanvel_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu so.asmaaka.m kasmaaccidapi duure ti.s.thatiiti nahi, vaya.m tena ni\"svasanapra\"svasanagamanaagamanapraa.nadhaara.naani kurmma.h, puुna\"sca yu.smaakameva katipayaa.h kavaya.h kathayanti ‘tasya va.m\"saa vaya.m smo hi` iti| ");
INSERT INTO sanvel_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataeva yadi vayam ii\"svarasya va.m\"saa bhavaamastarhi manu.syai rvidyayaa kau\"salena ca tak.sita.m svar.na.m ruupya.m d.r.sad vaite.saamii\"svaratvam asmaabhi rna j naatavya.m| ");
INSERT INTO sanvel_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","te.saa.m puurvviiyalokaanaam aj naanataa.m pratii\"svaro yadyapi naavaadhatta tathaapiidaanii.m sarvvatra sarvvaan mana.h parivarttayitum aaj naapayati, ");
INSERT INTO sanvel_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yata.h svaniyuktena puru.se.na yadaa sa p.rthiviisthaanaa.m sarvvalokaanaa.m vicaara.m kari.syati taddina.m nyaruupayat; tasya \"sma\"saanotthaapanena tasmin sarvvebhya.h pramaa.na.m praadaat| ");
INSERT INTO sanvel_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadaa \"sma\"saanaad utthaanasya kathaa.m \"srutvaa kecid upaahaman, kecidavadan enaa.m kathaa.m punarapi tvatta.h \"sro.syaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tata.h paulaste.saa.m samiipaat prasthiाtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathaapi kecillokaastena saarddha.m militvaa vya\"svasan te.saa.m madhye .areyapaagiiyadiyanusiyo daamaariinaamaa kaacinnaarii kiyanto naraa\"scaasan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadgha.tanaata.h para.m paula aathiiniinagaraad yaatraa.m k.rtvaa karinthanagaram aagacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samaye klaudiya.h sarvvaan yihuudiiyaan romaanagara.m vihaaya gantum aaj naapayat, tasmaat priskillaanaamnaa jaayayaa saarddham itaaliyaade\"saat ki ncitpuurvvam aagamat ya.h pantade\"se jaata aakkilanaamaa yihuudiiyaloka.h paulasta.m saak.saat praapya tayo.h samiipamitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau duu.syanirmmaa.najiivinau, tasmaat parasparam ekav.rttikatvaat sa taabhyaa.m saha u.sitvaa tat karmmaakarot| ");
INSERT INTO sanvel_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paula.h prativi\"sraamavaara.m bhajanabhavana.m gatvaa vicaara.m k.rtvaa yihuudiiyaan anyade\"siiyaa.m\"sca prav.rtti.m graahitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","siilatiimathiyayo rmaakidaniyaade\"saat sametayo.h sato.h paula uttaptamanaa bhuutvaa yii\"surii\"svare.naabhi.sikto bhavatiiti pramaa.na.m yihuudiiyaanaa.m samiipe praadaat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu te .atiiva virodha.m vidhaaya paa.sa.n.diiyakathaa.m kathitavantastata.h paulo vastra.m dhunvan etaa.m kathaa.m kathitavaan, yu.smaaka.m \"so.nitapaataaparaadho yu.smaan pratyeva bhavatu, tenaaha.m niraparaadho .adyaarabhya bhinnade\"siiyaanaa.m samiipa.m yaami| ");
INSERT INTO sanvel_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmaat prasthaaya bhajanabhavanasamiipasthasya yustanaamna ii\"svarabhaktasya bhinnade\"siiyasya nive\"sana.m praavi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tata.h krii.spanaamaa bhajanabhavanaadhipati.h saparivaara.h prabhau vya\"svasiit, karinthanagariiyaa bahavo lokaa\"sca samaakar.nya vi\"svasya majjitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","k.sa.nadaayaa.m prabhu.h paula.m dar\"sana.m datvaa bhaa.sitavaan, maa bhai.sii.h, maa nirasii.h kathaa.m pracaaraya| ");
INSERT INTO sanvel_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","aha.m tvayaa saarddham aasa hi.msaartha.m kopi tvaa.m spra.s.tu.m na \"sak.syati nagare.asmin madiiyaa lokaa bahava aasate| ");
INSERT INTO sanvel_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmaat paulastannagare praaye.na saarddhavatsaraparyyanta.m sa.msthaaye\"svarasya kathaam upaadi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gaalliyanaamaa ka\"scid aakhaayaade\"sasya praa.dvivaaka.h samabhavat, tato yihuudiiyaa ekavaakyaa.h santa.h paulam aakramya vicaarasthaana.m niitvaa ");
INSERT INTO sanvel_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","maanu.sa e.sa vyavasthaaya viruddham ii\"svarabhajana.m karttu.m lokaan kuprav.rtti.m graahayatiiti niveditavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tata.h paule pratyuttara.m daatum udyate sati gaalliyaa yihuudiiyaan vyaaharat, yadi kasyacid anyaayasya vaati\"sayadu.s.tataacara.nasya vicaaro.abhavi.syat tarhi yu.smaaka.m kathaa mayaa sahaniiyaabhavi.syat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kevala.m kathaayaa vaa naamno vaa yu.smaaka.m vyavasthaayaa vivaado bhavati tarhi tasya vicaaramaha.m na kari.syaami, yuuya.m tasya miimaa.msaa.m kuruta| ");
INSERT INTO sanvel_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tata.h sa taan vicaarasthaanaad duuriik.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadaa bhinnade\"siiyaa.h sosthininaamaana.m bhajanabhavanasya pradhaanaadhipati.m dh.rtvaa vicaarasthaanasya sammukhe praaharan tathaapi gaalliyaa te.su sarvvakarmmasu na mano nyadadhaat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudinaani nyavasat, tato bhraat.rga.naad visarjana.m praapya ki ncanavratanimitta.m ki.mkriyaanagare \"siro mu.n.dayitvaa priskillaakkilaabhyaa.m sahito jalapathena suriyaade\"sa.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphi.sanagara upasthaaya tatra tau vis.rjya svaya.m bhajanabhvana.m pravi\"sya yihuudiiyai.h saha vicaaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","te svai.h saarddha.m puna.h katipayadinaani sthaatu.m ta.m vyanayan, sa tadanurariik.rtya kathaametaa.m kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yiruu\"saalami aagaamyutsavapaalanaartha.m mayaa gamaniiya.m; pa\"scaad ii\"svarecchaayaa.m jaataayaa.m yu.smaaka.m samiipa.m pratyaagami.syaami| tata.h para.m sa tai rvis.r.s.ta.h san jalapathena iphi.sanagaraat prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tata.h kaisariyaam upasthita.h san nagara.m gatvaa samaaja.m namask.rtya tasmaad aantiyakhiyaanagara.m prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkaala.m yaapayitvaa tasmaat prasthaaya sarvve.saa.m \"si.syaa.naa.m manaa.msi susthiraa.ni k.rtvaa krama\"so galaatiyaaphrugiyaade\"sayo rbhramitvaa gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminneva samaye sikandariyaanagare jaata aapallonaamaa \"saastravit suvaktaa yihuudiiya eko jana iphi.sanagaram aagatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa \"sik.sitaprabhumaargo manasodyogii ca san yohano majjanamaatra.m j naatvaa yathaarthatayaa prabho.h kathaa.m kathayan samupaadi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","e.sa jano nirbhayatvena bhajanabhavane kathayitum aarabdhavaan, tata.h priskillaakkilau tasyopade\"sakathaa.m ni\"samya ta.m svayo.h samiipam aaniiya \"suddharuupe.ne\"svarasya kathaam abodhayataam| ");
INSERT INTO sanvel_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","pa\"scaat sa aakhaayaade\"sa.m gantu.m mati.m k.rtavaan, tadaa tatratya.h \"si.syaga.no yathaa ta.m g.rhlaati tadartha.m bhraat.rga.nena samaa\"svasya patre likhite sati, aapallaastatropasthita.h san anugrahe.na pratyayinaa.m bahuupakaaraan akarot, ");
INSERT INTO sanvel_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalato yii\"surabhi.siktastraateti \"saastrapramaa.na.m datvaa prakaa\"saruupe.na pratipanna.m k.rtvaa yihuudiiyaan niruttaraan k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara aapallasa.h sthitikaale paula uttaraprade\"sairaagacchan iphi.sanagaram upasthitavaan| tatra katipaya\"si.syaan saak.sat praapya taan ap.rcchat, ");
INSERT INTO sanvel_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yuuya.m vi\"svasya pavitramaatmaana.m praaptaa na vaa? tataste pratyavadan pavitra aatmaa diiyate ityasmaabhi.h \"srutamapi nahi| ");
INSERT INTO sanvel_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadaa saa.avadat tarhi yuuya.m kena majjitaa abhavata? te.akathayan yohano majjanena| ");
INSERT INTO sanvel_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadaa paula uktavaan ita.h para.m ya upasthaasyati tasmin arthata yii\"sukhrii.s.te vi\"svasitavyamityuktvaa yohan mana.hparivarttanasuucakena majjanena jale lokaan amajjayat| ");
INSERT INTO sanvel_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","taad.r\"sii.m kathaa.m \"srutvaa te prabho ryii\"sukhrii.s.tasya naamnaa majjitaa abhavan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tata.h paulena te.saa.m gaatre.su kare.arpite te.saamupari pavitra aatmaavaruu.dhavaan, tasmaat te naanaade\"siiyaa bhaa.saa bhavi.syatkathaa\"sca kathitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","te praaye.na dvaada\"sajanaa aasan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulo bhajanabhavana.m gatvaa praaye.na maasatrayam ii\"svarasya raajyasya vicaara.m k.rtvaa lokaan pravartya saahasena kathaamakathayat| ");
INSERT INTO sanvel_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu ka.thinaanta.hkara.natvaat kiyanto janaa na vi\"svasya sarvve.saa.m samak.sam etatpathasya nindaa.m karttu.m prav.rttaa.h, ata.h paulaste.saa.m samiipaat prasthaaya \"si.syaga.na.m p.rthakk.rtvaa pratyaha.m turaannanaamna.h kasyacit janasya paa.tha\"saalaayaa.m vicaara.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ittha.m vatsaradvaya.m gata.m tasmaad aa\"siyaade\"sanivaasina.h sarvve yihuudiiyaa anyade\"siiyalokaa\"sca prabho ryii\"so.h kathaam a\"srau.san| ");
INSERT INTO sanvel_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulena ca ii\"svara etaad.r\"saanyadbhutaani karmmaa.ni k.rtavaan ");
INSERT INTO sanvel_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridheye gaatramaarjanavastre vaa tasya dehaat pii.ditalokaanaam samiipam aaniite te niraamayaa jaataa apavitraa bhuutaa\"sca tebhyo bahirgatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadaa de\"saa.tanakaari.na.h kiyanto yihuudiiyaa bhuutaapasaari.no bhuutagrastanokaanaa.m sannidhau prabhe ryii\"so rnaama japtvaa vaakyamidam avadan, yasya kathaa.m paula.h pracaarayati tasya yii\"so rnaamnaa yu.smaan aaj naapayaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanaamno yihuudiiyaanaa.m pradhaanayaajakasya saptabhi.h puttaistathaa k.rte sati ");
INSERT INTO sanvel_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ka\"scid apavitro bhuuta.h pratyuditavaan, yii\"su.m jaanaami paula nca paricinomi kintu ke yuuya.m? ");
INSERT INTO sanvel_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvaa sopavitrabhuutagrasto manu.syo lampha.m k.rtvaa te.saamupari patitvaa balena taan jitavaan, tasmaatte nagnaa.h k.sataa\"ngaa\"sca santastasmaad gehaat palaayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","saa vaag iphi.sanagaranivaasinasa.m sarvve.saa.m yihuudiiyaanaa.m bhinnade\"siiyaanaa.m lokaanaa nca \"sravogocariibhuutaa; tata.h sarvve bhaya.m gataa.h prabho ryii\"so rnaamno ya\"so .avarddhata| ");
INSERT INTO sanvel_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ye.saamaneke.saa.m lokaanaa.m pratiitirajaayata ta aagatya svai.h k.rtaa.h kriyaa.h prakaa\"saruupe.naa\"ngiik.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavo maayaakarmmakaari.na.h svasvagranthaan aaniiya raa\"siik.rtya sarvve.saa.m samak.sam adaahayan, tato ga.nanaa.m k.rtvaabudhyanta pa ncaayutaruupyamudraamuulyapustakaani dagdhaani| ");
INSERT INTO sanvel_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ittha.m prabho.h kathaa sarvvade\"sa.m vyaapya prabalaa jaataa| ");
INSERT INTO sanvel_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvve.svete.su karmmasu sampanne.su satsu paulo maakidaniyaakhaayaade\"saabhyaa.m yiruu\"saalama.m gantu.m mati.m k.rtvaa kathitavaan tatsthaana.m yaatraayaa.m k.rtaayaa.m satyaa.m mayaa romaanagara.m dra.s.tavya.m| ");
INSERT INTO sanvel_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svaanugatalokaanaa.m tiimathiyeraastau dvau janau maakidaniyaade\"sa.m prati prahitya svayam aa\"siyaade\"se katipayadinaani sthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samaye mate.asmin kalaho jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkaara.namida.m, arttimiidevyaa ruupyamandiranirmmaa.nena sarvve.saa.m \"silpinaa.m yathe.s.talaabham ajanayat yo diimiitriyanaamaa naa.diindhama.h ");
INSERT INTO sanvel_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa taan tatkarmmajiivina.h sarvvalokaa.m\"sca samaahuuya bhaa.sitavaan he mahecchaa etena mandiranirmmaa.nenaasmaaka.m jiivikaa bhavati, etad yuuya.m vittha; ");
INSERT INTO sanvel_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmite\"svaraa ii\"svaraa nahi paulanaamnaa kenacijjanena kathaamimaa.m vyaah.rtya kevalephi.sanagare nahi praaye.na sarvvasmin aa\"siyaade\"se prav.rtti.m graahayitvaa bahulokaanaa.m \"semu.sii paraavarttitaa, etad yu.smaabhi rd.r\"syate \"sruuyate ca| ");
INSERT INTO sanvel_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tenaasmaaka.m vaa.nijyasya sarvvathaa haane.h sambhavana.m kevalamiti nahi, aa\"siyaade\"sasthai rvaa sarvvajagatsthai rlokai.h puujyaa yaartimii mahaadevii tasyaa mandirasyaavaj naanasya tasyaa ai\"svaryyasya naa\"sasya ca sambhaavanaa vidyateे| ");
INSERT INTO sanvel_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","etaad.r\"sii.m kathaa.m \"srutvaa te mahaakrodhaanvitaa.h santa uccai.hkaara.m kathitavanta iphi.siiyaanaam arttimii devii mahatii bhavati| ");
INSERT INTO sanvel_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tata.h sarvvanagara.m kalahena paripuur.namabhavat, tata.h para.m te maakidaniiyagaayaaristaarkhanaamaanau paulasya dvau sahacarau dh.rtvaikacittaa ra\"ngabhuumi.m javena dhaavitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tata.h paulo lokaanaa.m sannidhi.m yaatum udyatavaan kintu \"si.syaga.nasta.m vaaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmiiyaa aa\"siyaade\"sasthaa.h katipayaa.h pradhaanalokaastasya samiipa.m narameka.m pre.sya tva.m ra\"ngabhuumi.m maagaa iti nyavedayan| ");
INSERT INTO sanvel_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tato naanaalokaanaa.m naanaakathaakathanaat sabhaa vyaakulaa jaataa ki.m kaara.naad etaavatii janataabhavat etad adhikai rlokai rnaaj naayi| ");
INSERT INTO sanvel_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tata.h para.m janataamadhyaad yihuudiiyairbahi.sk.rta.h sikandaro hastena sa\"nketa.m k.rtvaa lokebhya uttara.m daatumudyatavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihuudiiyaloka iti ni\"scite sati iphi.siiyaanaam arttimii devii mahatiiti vaakya.m praaye.na pa nca da.n.daan yaavad ekasvare.na lokanivahai.h prokta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tato nagaraadhipatistaan sthiraan k.rtvaa kathitavaan he iphi.saayaa.h sarvve lokaa aakar.nayata, artimiimahaadevyaa mahaadevaat patitaayaastatpratimaayaa\"sca puujanama iphi.sanagarasthaa.h sarvve lokaa.h kurvvanti, etat ke na jaananti? ");
INSERT INTO sanvel_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmaad etatpratikuula.m kepi kathayitu.m na \"saknuvanti, iti j naatvaa yu.smaabhi.h susthiratvena sthaatavyam avivicya kimapi karmma na karttavya nca| ");
INSERT INTO sanvel_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yaan etaan manu.syaan yuuyamatra samaanayata te mandiradravyaapahaarakaa yu.smaaka.m devyaa nindakaa\"sca na bhavanti| ");
INSERT INTO sanvel_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi ka ncana prati diimiitriyasya tasya sahaayaanaa nca kaacid aapatti rvidyate tarhi pratinidhilokaa vicaarasthaana nca santi, te tat sthaana.m gatvaa uttarapratyuttare kurvvantu| ");
INSERT INTO sanvel_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yu.smaaka.m kaacidaparaa kathaa yadi ti.s.thati tarhi niyamitaayaa.m sabhaayaa.m tasyaa ni.spatti rbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvetasya virodhasyottara.m yena daatu.m \"saknum etaad.r\"sasya kasyacit kaara.nasyaabhaavaad adyatanagha.tanaaheto raajadrohi.naamivaasmaakam abhiyogo bhavi.syatiiti \"sa\"nkaa vidyate| ");
INSERT INTO sanvel_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvaa sa sabhaasthalokaan vis.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ittha.m kalahe niv.rtte sati paula.h \"si.syaga.nam aahuuya visarjana.m praapya maakidaniyaade\"sa.m prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tena sthaanena gacchan tadde\"siiyaan \"si.syaan bahuupadi\"sya yuunaaniiyade\"sam upasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra maasatraya.m sthitvaa tasmaat suriyaade\"sa.m yaatum udyata.h, kintu yihuudiiyaasta.m hantu.m guptaa ati.s.than tasmaat sa punarapi maakidaniyaamaarge.na pratyaagantu.m mati.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayaanagariiyasopaatra.h thi.salaniikiiyaaristaarkhasikundau darbbonagariiyagaayatiimathiyau aa\"siyaade\"siiyatukhikatraphimau ca tena saarddha.m aa\"siyaade\"sa.m yaavad gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ete sarvve .agrasaraa.h santo .asmaan apek.sya troyaanagare sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ki.nva\"suunyapuupotsavadine ca gate sati vaya.m philipiinagaraat toyapathena gatvaa pa ncabhi rdinaistroyaanagaram upasthaaya tatra saptadinaanyavaati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptaahasya prathamadine puupaan bha.mktu \"si.sye.su milite.su paula.h paradine tasmaat prasthaatum udyata.h san tadahni praaye.na k.sapaayaa yaamadvaya.m yaavat \"si.syebhyo dharmmakathaam akathayat| ");
INSERT INTO sanvel_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthe yasmin prako.s.the sabhaa.m k.rtvaasan tatra bahava.h pradiipaa.h praajvalan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanaamaa ka\"scana yuvaa ca vaataayana upavi\"san ghorataranidraagrasto .abhuut tadaa paulena bahuk.sa.na.m kathaayaa.m pracaaritaayaa.m nidraamagna.h sa tasmaad uparisthat.rtiiyaprako.s.thaad apatat, tato lokaasta.m m.rtakalpa.m dh.rtvodatolayan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tata.h paulo.avaruhya tasya gaatre patitvaa ta.m kro.de nidhaaya kathitavaan, yuuya.m vyaakulaa maa bhuuta naaya.m praa.nai rviyukta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","pa\"scaat sa puna\"scopari gatvaa puupaan bha.mktvaa prabhaata.m yaavat kathopakathane k.rtvaa prasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","te ca ta.m jiivanta.m yuvaana.m g.rhiitvaa gatvaa paramaapyaayitaa jaataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantara.m vaya.m potenaagrasaraa bhuutvaasmanagaram uttiiryya paula.m grahiitu.m matim akurmma yata.h sa tatra padbhyaa.m vrajitu.m mati.m k.rtveti niruupitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmaat tatraasmaabhi.h saarddha.m tasmin milite sati vaya.m ta.m niitvaa mituliinyupadviipa.m praaptavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmaat pota.m mocayitvaa pare.ahani khiiyopadviipasya sammukha.m labdhavantastasmaad ekenaahnaa saamopadviipa.m gatvaa pota.m laagayitvaa trogulliye sthitvaa parasmin divaseे miliitanagaram upaati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yata.h paula aa\"siyaade\"se kaala.m yaapayitum naabhila.san iphi.sanagara.m tyaktvaa yaatu.m mantra.naa.m sthiriik.rtavaan; yasmaad yadi saadhya.m bhavati tarhi nistaarotsavasya pa ncaa\"sattamadine sa yiruu\"saalamyupasthaatu.m mati.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulo miliitaad iphi.sa.m prati loka.m prahitya samaajasya praaciinaan aahuuyaaniitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","te.su tasya samiipam upasthite.su sa tebhya imaa.m kathaa.m kathitavaan, aham aa\"siyaade\"se prathamaagamanam aarabhyaadya yaavad yu.smaaka.m sannidhau sthitvaa sarvvasamaye yathaacaritavaan tad yuuya.m jaaniitha; ");
INSERT INTO sanvel_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalata.h sarvvathaa namramanaa.h san bahu\"srupaatena yihudiiyaanaam kumantra.naajaatanaanaapariik.saabhi.h prabho.h sevaamakarava.m| ");
INSERT INTO sanvel_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kaamapi hitakathaaा.m na gopaayitavaan taa.m pracaaryya saprakaa\"sa.m g.rhe g.rhe samupadi\"sye\"svara.m prati mana.h paraavarttaniiya.m prabhau yii\"sukhrii.s.te vi\"svasaniiya.m ");
INSERT INTO sanvel_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihuudiiyaanaam anyade\"siiyalokaanaa nca samiipa etaad.r\"sa.m saak.sya.m dadaami| ");
INSERT INTO sanvel_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","pa\"syata saampratam aatmanaak.r.s.ta.h san yiruu\"saalamnagare yaatraa.m karomi, tatra maamprati yadyad gha.ti.syate taanyaha.m na jaanaami; ");
INSERT INTO sanvel_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayaa bandhana.m kle\"sa\"sca bhoktavya iti pavitra aatmaa nagare nagare pramaa.na.m dadaati| ");
INSERT INTO sanvel_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathaapi ta.m kle\"samaha.m t.r.naaya na manye; ii\"svarasyaanugrahavi.sayakasya susa.mvaadasya pramaa.na.m daatu.m, prabho ryii\"so.h sakaa\"saada yasyaa.h sevaayaa.h bhaara.m praapnava.m taa.m sevaa.m saadhayitu.m saananda.m svamaarga.m samaapayituु nca nijapraa.naanapi priyaan na manye| ");
INSERT INTO sanvel_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunaa pa\"syata ye.saa.m samiipe.aham ii\"svariiyaraajyasya susa.mvaada.m pracaaryya bhrama.na.m k.rtavaan etaad.r\"saa yuuya.m mama vadana.m puna rdra.s.tu.m na praapsyatha etadapyaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yu.smabhyam aham ii\"svarasya sarvvaan aade\"saan prakaa\"sayitu.m na nyavartte| ");
INSERT INTO sanvel_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","aha.m sarvve.saa.m lokaanaa.m raktapaatado.saad yannirdo.sa aase tasyaadya yu.smaan saak.si.na.h karomi| ");
INSERT INTO sanvel_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yuuya.m sve.su tathaa yasya vrajasyaadhyak.san aatmaa yu.smaan vidhaaya nyayu\"nkta tatsarvvasmin saavadhaanaa bhavata, ya samaaja nca prabhu rnijaraktamuulyena kriitavaana tam avata, ");
INSERT INTO sanvel_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yato mayaa gamane k.rtaeva durjayaa v.rkaa yu.smaaka.m madhya.m pravi\"sya vraja.m prati nirdayataam aacari.syanti, ");
INSERT INTO sanvel_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yu.smaakameva madhyaadapi lokaa utthaaya \"si.syaga.nam apahantu.m vipariitam upadek.syantiityaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti heto ryuuya.m sacaitanyaa.h santasti.s.tata, aha nca saa\"srupaata.h san vatsaratraya.m yaavad divaani\"sa.m pratijana.m bodhayitu.m na nyavartte tadapi smarata| ");
INSERT INTO sanvel_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idaanii.m he bhraataro yu.smaaka.m ni.s.thaa.m janayitu.m pavitriik.rtalokaanaa.m madhye.adhikaara nca daatu.m samartho ya ii\"svarastasyaanugrahasya yo vaada\"sca tayorubhayo ryu.smaan samaarpayam| ");
INSERT INTO sanvel_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyaapi svar.na.m ruupya.m vastra.m vaa prati mayaa lobho na k.rta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacaralokaanaa ncaava\"syakavyayaaya madiiyamida.m karadvayam a\"sraamyad etad yuuya.m jaaniitha| ");
INSERT INTO sanvel_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anena prakaare.na graha.nad daana.m bhadramiti yadvaakya.m prabhu ryii\"su.h kathitavaan tat smarttu.m daridralokaanaamupakaaraartha.m \"srama.m karttu nca yu.smaakam ucitam etatsarvva.m yu.smaanaham upadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","etaa.m kathaa.m kathayitvaa sa jaanunii paatayitvaa sarvai.h saha praarthayata| ");
INSERT INTO sanvel_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tena te krandranta.h ");
INSERT INTO sanvel_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukha.m na drak.syatha vi\"se.sata e.saa yaa kathaa tenaakathi tatkaara.naat \"soka.m vilaapa nca k.rtvaa ka.n.tha.m dh.rtvaa cumbitavanta.h| pa\"scaat te ta.m pota.m niitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvis.r.s.taa.h santo vaya.m pota.m baahayitvaa .rjumaarge.na ko.sam upadviipam aagatya pare.ahani rodiyopadviipam aagacchaama tatastasmaat paataaraayaam upaati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainiikiyaade\"sagaaminam potameka.m praapya tamaaruhya gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kupropadviipa.m d.r.s.tvaa ta.m savyadi\"si sthaapayitvaa suriyaade\"sa.m gatvaa potasthadravyaa.nyavarohayitu.m soranagare laagitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra \"si.syaga.nasya saak.saatkara.naaya vaya.m tatra saptadinaani sthitavanta.h pa\"scaatte pavitre.naatmanaa paula.m vyaaharan tva.m yiruu\"saalamnagara.m maa gama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tataste.su saptasu dine.su yaapite.su satsu vaya.m tasmaat sthaanaat nijavartmanaa gatavanta.h, tasmaat te sabaalav.rddhavanitaa asmaabhi.h saha nagarasya parisaraparyyantam aagataa.h pa\"scaadvaya.m jaladhita.te jaanupaata.m praarthayaamahi| ");
INSERT INTO sanvel_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tata.h paraspara.m vis.r.s.taa.h santo vaya.m pota.m gataaste tu svasvag.rha.m pratyaagatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vaya.m soranagaraat naavaa prasthaaya talimaayinagaram upaati.s.thaama tatraasmaaka.m samudriiyamaargasyaanto.abhavat tatra bhraat.rga.na.m namask.rtya dinameka.m tai.h saarddham u.satavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","pare .ahani paulastasya sa\"ngino vaya nca prati.s.thamaanaa.h kaisariyaanagaram aagatya susa.mvaadapracaarakaanaa.m saptajanaanaa.m philipanaamna ekasya g.rha.m pravi\"syaavati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya catasro duhitaro.anuu.dhaa bhavi.syadvaadinya aasan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatraasmaasu bahudinaani pro.site.su yihuudiiyade\"saad aagatyaagaabanaamaa bhavi.syadvaadii samupasthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sosmaaka.m samiipametya paulasya ka.tibandhana.m g.rhiitvaa nijahastaapaadaan baddhvaa bhaa.sitavaan yasyeda.m ka.tibandhana.m ta.m yihuudiiyalokaa yiruu\"saalamanagara ittha.m baddhvaa bhinnade\"siiyaanaa.m kare.su samarpayi.syantiiti vaakya.m pavitra aatmaa kathayati| ");
INSERT INTO sanvel_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","etaad.r\"sii.m kathaa.m \"srutvaa vaya.m tannagaravaasino bhraatara\"sca yiruu\"saalama.m na yaatu.m paula.m vyanayaamahi; ");
INSERT INTO sanvel_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyaavaadiit, yuuya.m ki.m kurutha? ki.m krandanena mamaanta.hkara.na.m vidiir.na.m kari.syatha? prabho ryii\"so rnaamno nimitta.m yiruu\"saalami baddho bhavitu.m kevala tanna praa.naan daatumapi sasajjosmi| ");
INSERT INTO sanvel_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tenaasmaaka.m kathaayaam ag.rhiitaayaam ii\"svarasya yathecchaa tathaiva bhavatvityuktvaa vaya.m nirasyaama| ");
INSERT INTO sanvel_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","pare.ahani paatheyadravyaa.ni g.rhiitvaa yiruu\"saalama.m prati yaatraam akurmma| ");
INSERT INTO sanvel_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tata.h kaisariyaanagaranivaasina.h katipayaa.h \"si.syaa asmaabhi.h saarddham itvaa k.rpriiyena mnaasannaamnaa yena praaciina\"si.syena saarddham asmaabhi rvastavya.m tasya samiipam asmaan niitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmaasu yiruu\"saalamyupasthite.su tatrasthabhraat.rga.no.asmaan aahlaadena g.rhiitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divase paule.asmaabhi.h saha yaakuubo g.rha.m pravi.s.te lokapraaciinaa.h sarvve tatra pari.sadi sa.msthitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantara.m sa taan natvaa sviiyapracaara.nena bhinnade\"siiyaan pratii\"svaro yaani karmmaa.ni saadhitavaan tadiiyaa.m kathaam anukramaat kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti \"srutvaa te prabhu.m dhanya.m procya vaakyamidam abhaa.santa, he bhraata ryihuudiiyaanaa.m madhye bahusahasraa.ni lokaa vi\"svaasina aasate kintu te sarvve vyavasthaamataacaari.na etat pratyak.sa.m pa\"syasi| ");
INSERT INTO sanvel_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","\"si\"suunaa.m tvakchedanaadyaacara.na.m prati.sidhya tva.m bhinnade\"sanivaasino yihuudiiyalokaan muusaavaakyam a\"sraddhaatum upadi\"sasiiti tai.h \"srutamasti| ");
INSERT INTO sanvel_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatraagatosiiti vaarttaa.m samaakar.nya jananivaho militvaava\"syamevaagami.syati; ataeva ki.m kara.niiyam? atra vaya.m mantrayitvaa samupaaya.m tvaa.m vadaamasta.m tvamaacara| ");
INSERT INTO sanvel_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrata.m karttu.m k.rtasa\"nkalpaa ye.asmaa.mka catvaaro maanavaa.h santi ");
INSERT INTO sanvel_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","taan g.rhiitvaa tai.h sahita.h sva.m \"suci.m kuru tathaa te.saa.m \"siromu.n.dane yo vyayo bhavati ta.m tva.m dehi| tathaa k.rte tvadiiyaacaare yaa jana\"sruti rjaayate saaliikaa kintu tva.m vidhi.m paalayan vyavasthaanusaare.nevaacarasiiti te bhotsante| ");
INSERT INTO sanvel_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnade\"siiyaanaa.m vi\"svaasilokaanaa.m nika.te vaya.m patra.m likhitvettha.m sthiriik.rtavanta.h, devaprasaadabhojana.m rakta.m galapii.danamaaritapraa.nibhojana.m vyabhicaara\"scaitebhya.h svarak.sa.navyatireke.na te.saamanyavidhipaalana.m kara.niiya.m na| ");
INSERT INTO sanvel_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tata.h paulastaan maanu.saanaadaaya parasmin divase tai.h saha \"suci rbhuutvaa mandira.m gatvaa \"saucakarmma.no dine.su sampuur.ne.su te.saam ekaikaartha.m naivedyaadyutsargo bhavi.syatiiti j naapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","te.su saptasu dine.su samaaptakalpe.su aa\"siyaade\"sanivaasino yihuudiiyaasta.m madhyemandira.m vilokya jananivahasya mana.hsu kuprav.rtti.m janayitvaa ta.m dh.rtvaa ");
INSERT INTO sanvel_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","proccai.h praavocan, he israayellokaa.h sarvve saahaayya.m kuruta| yo manuja ete.saa.m lokaanaa.m muusaavyavasthaayaa etasya sthaanasyaapi vipariita.m sarvvatra sarvvaan \"sik.sayati sa e.sa.h; vi\"se.sata.h sa bhinnade\"siiyalokaan mandiram aaniiya pavitrasthaanametad apavitramakarot| ");
INSERT INTO sanvel_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","puurvva.m te madhyenagaram iphi.sanagariiya.m traphima.m paulena sahita.m d.r.s.tavanta etasmaat paulasta.m mandiramadhyam aanayad ityanvamimata| ");
INSERT INTO sanvel_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataeva sarvvasmin nagare kalahotpannatvaat dhaavanto lokaa aagatya paula.m dh.rtvaa mandirasya bahiraak.r.syaanayan tatk.sa.naad dvaaraa.ni sarvvaa.ni ca ruddhaani| ");
INSERT INTO sanvel_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","te.su ta.m hantumudyateे.su yiruu\"saalamnagare mahaanupadravo jaata iti vaarttaayaa.m sahasrasenaapate.h kar.nagocariibhuutaayaa.m satyaa.m sa tatk.sa.naat sainyaani senaapatiga.na nca g.rhiitvaa javenaagatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tato lokaa.h senaaga.nena saha sahasrasenaapatim aagacchanta.m d.r.s.tvaa paulataa.danaato nyavarttanta| ");
INSERT INTO sanvel_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasenaapati.h sannidhaavaagamya paula.m dh.rtvaa \"s.r\"nkhaladvayena baddham aadi\"sya taan p.r.s.tavaan e.sa ka.h? ki.m karmma caaya.m k.rtavaan? ");
INSERT INTO sanvel_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tato janasamuuhasya ka\"scid ekaprakaara.m ka\"scid anyaprakaara.m vaakyam araut sa tatra satya.m j naatum kalahakaara.naad a\"sakta.h san ta.m durga.m netum aaj naapayat| ");
INSERT INTO sanvel_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","te.su sopaanasyopari praapte.su lokaanaa.m saahasakaara.naat senaaga.na.h paulamuttolya niitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tata.h sarvve lokaa.h pa\"scaadgaamina.h santa ena.m duriikuruteti vaakyam uccairavadan| ");
INSERT INTO sanvel_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgaanayanasamaye sa tasmai sahasrasenaapataye kathitavaan, bhavata.h purastaat kathaa.m kathayitu.m kim anumanyate? sa tamap.rcchat tva.m ki.m yuunaaniiyaa.m bhaa.saa.m jaanaasi? ");
INSERT INTO sanvel_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yo misariiyo jana.h puurvva.m virodha.m k.rtvaa catvaari sahasraa.ni ghaatakaan sa\"ngina.h k.rtvaa vipina.m gatavaan tva.m ki.m saeva na bhavasi? ");
INSERT INTO sanvel_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadaa paulo.akathayat aha.m kilikiyaade\"sasya taar.sanagariiyo yihuudiiyo, naaha.m saamaanyanagariiyo maanava.h; ataeva vinaye.aha.m laakaanaa.m samak.sa.m kathaa.m kathayitu.m maamanujaanii.sva| ");
INSERT INTO sanvel_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tenaanuj naata.h paula.h sopaanopari ti.s.than hastene\"ngita.m k.rtavaan, tasmaat sarvve susthiraa abhavan| tadaa paula ibriiyabhaa.sayaa kathayitum aarabhata, ");
INSERT INTO sanvel_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","he pit.rga.naa he bhraat.rga.naa.h, idaanii.m mama nivedane samavadhatta| ");
INSERT INTO sanvel_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadaa sa ibriiyabhaa.sayaa kathaa.m kathayatiiti \"srutvaa sarvve lokaa atiiva ni.h\"sabdaa santo.ati.s.than| ");
INSERT INTO sanvel_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","pa\"scaat so.akathayad aha.m yihuudiiya iti ni\"scaya.h kilikiyaade\"sasya taar.sanagara.m mama janmabhuumi.h,etannagariiyasya gamiliiyelanaamno.adhyaapakasya \"si.syo bhuutvaa puurvvapuru.saa.naa.m vidhivyavasthaanusaare.na sampuur.naruupe.na \"sik.sito.abhavam idaaniintanaa yuuya.m yaad.r\"saa bhavatha taad.r\"so.ahamapii\"svarasevaayaam udyogii jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matametad dvi.s.tvaa tadgraahinaariipuru.saan kaaraayaa.m baddhvaa te.saa.m praa.nanaa\"saparyyantaa.m vipak.sataam akaravam| ");
INSERT INTO sanvel_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahaayaajaka.h sabhaasada.h praaciinalokaa\"sca mamaitasyaa.h kathaayaa.h pramaa.na.m daatu.m \"saknuvanti, yasmaat te.saa.m samiipaad damme.sakanagaranivaasibhraat.rga.naartham aaj naapatraa.ni g.rhiitvaa ye tatra sthitaastaan da.n.dayitu.m yiruu\"saalamam aanayanaartha.m damme.sakanagara.m gatosmi| ");
INSERT INTO sanvel_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gacchan tannagarasya samiipa.m praaptavaan tadaa dvitiiyapraharavelaayaa.m satyaam akasmaad gaga.naannirgatya mahatii diipti rmama caturdi\"si prakaa\"sitavatii| ");
INSERT INTO sanvel_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tato mayi bhuumauै patite sati, he \"saula he \"saula kuto maa.m taa.dayasi? maamprati bhaa.sita etaad.r\"sa eko ravopi mayaa \"sruta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadaaha.m pratyavada.m, he prabhe ko bhavaan? tata.h so.avaadiit ya.m tva.m taa.dayasi sa naasaratiiyo yii\"suraha.m| ");
INSERT INTO sanvel_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama sa\"ngino lokaastaa.m diipti.m d.r.s.tvaa bhiya.m praaptaa.h, kintu maampratyudita.m tadvaakya.m teे naabudhyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tata.h para.m p.r.s.tavaanaha.m, he prabho mayaa ki.m karttavya.m? tata.h prabhurakathayat, utthaaya damme.sakanagara.m yaahi tvayaa yadyat karttavya.m niruupitamaaste tat tatra tva.m j naapayi.syase| ");
INSERT INTO sanvel_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantara.m tasyaa.h kharataradiipte.h kaara.naat kimapi na d.r.s.tvaa sa\"ngiga.nena dh.rtahasta.h san damme.sakanagara.m vrajitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivaasinaa.m sarvve.saa.m yihuudiiyaanaa.m maanyo vyavasthaanusaare.na bhakta\"sca hanaaniiyanaamaa maanava eko ");
INSERT INTO sanvel_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim etya ti.s.than akathayat, he bhraata.h \"saula sud.r.s.ti rbhava tasmin da.n.de.aha.m samyak ta.m d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tata.h sa mahya.m kathitavaan yathaa tvam ii\"svarasyaabhipraaya.m vetsi tasya \"suddhasattvajanasya dar\"sana.m praapya tasya \"sriimukhasya vaakya.m \"s.r.no.si tannimittam asmaaka.m puurvvapuru.saa.naam ii\"svarastvaa.m manoniita.m k.rtavaana.m| ");
INSERT INTO sanvel_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yato yadyad adraak.siira\"srau.sii\"sca sarvve.saa.m maanavaanaa.m samiipe tva.m te.saa.m saak.sii bhavi.syasi| ");
INSERT INTO sanvel_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataeva kuto vilambase? prabho rnaamnaa praarthya nijapaapaprak.saalanaartha.m majjanaaya samutti.s.tha| ");
INSERT INTO sanvel_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tata.h para.m yiruu\"saalamnagara.m pratyaagatya mandire.aham ekadaa praarthaye, tasmin samaye.aham abhibhuuta.h san prabhuu.m saak.saat pa\"syan, ");
INSERT INTO sanvel_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tva.m tvarayaa yiruu\"saalama.h prati.s.thasva yato lokaamayi tava saak.sya.m na grahii.syanti, maampratyudita.m tasyeda.m vaakyam a\"srau.sam| ");
INSERT INTO sanvel_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatoha.m pratyavaadi.sam he prabho pratibhajanabhavana.m tvayi vi\"svaasino lokaan baddhvaa prah.rtavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathaa tava saak.si.na.h stiphaanasya raktapaatanasamaye tasya vinaa\"sa.m sammanya sannidhau ti.s.than hant.rlokaanaa.m vaasaa.msi rak.sitavaan, etat te vidu.h| ");
INSERT INTO sanvel_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tata.h so.akathayat prati.s.thasva tvaa.m duurasthabhinnade\"siiyaanaa.m samiipa.m pre.sayi.sye| ");
INSERT INTO sanvel_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadaa lokaa etaavatparyyantaa.m tadiiyaa.m kathaa.m \"srutvaa proccairakathayan, ena.m bhuuma.n.dalaad duuriikuruta, etaad.r\"sajanasya jiivana.m nocitam| ");
INSERT INTO sanvel_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuccai.h kathayitvaa vasanaani parityajya gaga.na.m prati dhuuliirak.sipan ");
INSERT INTO sanvel_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tata.h sahasrasenaapati.h paula.m durgaabhyantara netu.m samaadi\"sat| etasya pratikuulaa.h santo lokaa.h kinnimittam etaavaduccai.hsvaram akurvvan, etad vettu.m ta.m ka\"sayaa prah.rtya tasya pariik.saa.m karttumaadi\"sat| ");
INSERT INTO sanvel_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padaataya\"scarmmanirmmitarajjubhistasya bandhana.m karttumudyataastaastadaanii.m paula.h sammukhasthita.m \"satasenaapatim uktavaan da.n.daaj naayaam apraaptaayaa.m ki.m romiloka.m praharttu.m yu.smaakam adhikaarosti? ");
INSERT INTO sanvel_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","enaa.m kathaa.m \"srutvaa sa sahasrasenaapate.h sannidhi.m gatvaa taa.m vaarttaamavadat sa romiloka etasmaat saavadhaana.h san karmma kuru| ");
INSERT INTO sanvel_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmaat sahasrasenaapati rgatvaa tamapraak.siit tva.m ki.m romiloka.h? iti maa.m bruuhi| so.akathayat satyam| ");
INSERT INTO sanvel_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tata.h sahasrasenaapati.h kathitavaan bahudravi.na.m dattvaaha.m tat paurasakhya.m praaptavaan; kintu paula.h kathitavaan aha.m janunaa tat praapto.asmi| ");
INSERT INTO sanvel_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ittha.m sati ye prahaare.na ta.m pariik.situ.m samudyataa aasan te tasya samiipaat praati.s.thanta; sahasrasenaapatista.m romiloka.m vij naaya svaya.m yat tasya bandhanam akaar.siit tatkaara.naad abibhet| ");
INSERT INTO sanvel_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihuudiiyalokaa.h paula.m kuto.apavadante tasya v.rttaanta.m j naatu.m vaa nchan sahasrasenaapati.h pare.ahani paula.m bandhanaat mocayitvaa pradhaanayaajakaan mahaasabhaayaa.h sarvvalokaa\"sca samupasthaatum aadi\"sya te.saa.m sannidhau paulam avarohya sthaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhaasadlokaan prati paulo.ananyad.r.s.tyaa pa\"syan akathayat, he bhraat.rga.naa adya yaavat saralena sarvvaanta.hkara.nene\"svarasya saak.saad aacaraami| ");
INSERT INTO sanvel_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anena hanaaniiyanaamaa mahaayaajakasta.m kapole cape.tenaahantu.m samiipasthalokaan aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadaa paulastamavadat, he bahi.spari.sk.rta, ii\"svarastvaa.m praharttum udyatosti, yato vyavasthaanusaare.na vicaarayitum upavi\"sya vyavasthaa.m la\"nghitvaa maa.m praharttum aaj naapayasi| ");
INSERT INTO sanvel_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tato nika.tasthaa lokaa akathayan, tva.m kim ii\"svarasya mahaayaajaka.m nindasi? ");
INSERT INTO sanvel_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tata.h paula.h pratibhaa.sitavaan he bhraat.rga.na mahaayaajaka e.sa iti na buddha.m mayaa tadanyacca svalokaanaam adhipati.m prati durvvaakya.m maa kathaya, etaad.r\"sii lipirasti| ");
INSERT INTO sanvel_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantara.m paulaste.saam arddha.m siduukilokaa arddha.m phiruu\"silokaa iti d.r.s.tvaa proccai.h sabhaasthalokaan avadat he bhraat.rga.na aha.m phiruu\"simataavalambii phiruu\"sina.h satnaana\"sca, m.rtalokaanaam utthaane pratyaa\"saakara.naad ahamapavaaditosmi| ");
INSERT INTO sanvel_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathaayaa.m kathitaayaa.m phiruu\"sisiduukino.h paraspara.m bhinnavaakyatvaat sabhaayaa madhye dvau sa.mghau jaatau| ");
INSERT INTO sanvel_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yata.h siduukilokaa utthaana.m svargiiyaduutaa aatmaana\"sca sarvve.saam ete.saa.m kamapi na manyante, kintu phiruu\"sina.h sarvvam a\"ngiikurvvanti| ");
INSERT INTO sanvel_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tata.h parasparam ati\"sayakolaahale samupasthite phiruu\"sinaa.m pak.siiyaa.h sabhaasthaa adhyaapakaa.h pratipak.saa utti.s.thanto .akathayan, etasya maanavasya kamapi do.sa.m na pa\"syaama.h; yadi ka\"scid aatmaa vaa ka\"scid duuta ena.m pratyaadi\"sat tarhi vayam ii\"svarasya praatikuulyena na yotsyaama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmaad atiiva bhinnavaakyatve sati te paula.m kha.n.da.m kha.n.da.m kari.syantiityaa\"sa\"nkayaa sahasrasenaapati.h senaaga.na.m tatsthaana.m yaatu.m sabhaato balaat paula.m dh.rtvaa durga.m neta ncaaj naapayat| ");
INSERT INTO sanvel_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","raatro prabhustasya samiipe ti.s.than kathitavaan he paula nirbhayo bhava yathaa yiruu\"saalamnagare mayi saak.sya.m dattavaan tathaa romaanagarepi tvayaa daatavyam| ");
INSERT INTO sanvel_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dine samupasthite sati kiyanto yihuudiiyalokaa ekamantra.naa.h santa.h paula.m na hatvaa bhojanapaane kari.syaama iti \"sapathena svaan abadhnan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","catvaari.m\"sajjanebhyo.adhikaa lokaa iti pa.nam akurvvan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","te mahaayaajakaanaa.m praaciinalokaanaa nca samiipa.m gatvaa kathayan, vaya.m paula.m na hatvaa kimapi na bhok.syaamahe d.r.dhenaanena \"sapathena baddhvaa abhavaama| ");
INSERT INTO sanvel_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataeva saamprata.m sabhaasadlokai.h saha vaya.m tasmin ka ncid vi\"se.savicaara.m kari.syaamastadartha.m bhavaan \"svo .asmaaka.m samiipa.m tam aanayatviti sahasrasenaapataye nivedana.m kuruta tena yu.smaaka.m samiipa.m upasthite.h puurvva.m vaya.m ta.m hantu sajji.syaama| ");
INSERT INTO sanvel_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadaa paulasya bhaagineyaste.saamiti mantra.naa.m vij naaya durga.m gatvaa taa.m vaarttaa.m paulam uktavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmaat paula eka.m \"satasenaapatim aahuuya vaakyamidam bhaa.sitavaan sahasrasenaapate.h samiipe.asya yuvamanu.syasya ki ncinnivedanam aaste, tasmaat tatsavidham ena.m naya| ");
INSERT INTO sanvel_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tata.h sa tamaadaaya sahasrasenaapate.h samiipam upasthaaya kathitavaan, bhavata.h samiipe.asya kimapi nivedanamaaste tasmaat bandi.h paulo maamaahuuya bhavata.h samiipam enam aanetu.m praarthitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadaa sahasrasenaapatistasya hasta.m dh.rtvaa nirjanasthaana.m niitvaa p.r.s.thavaan tava ki.m nivedana.m? tat kathaya| ");
INSERT INTO sanvel_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tata.h sokathayat, yihuudiiyalaakaa.h paule kamapi vi\"se.savicaara.m chala.m k.rtvaa ta.m sabhaa.m netu.m bhavata.h samiipe nivedayitu.m amantrayan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavataa tanna sviikarttavya.m yataste.saa.m madhyevarttina\"scatvaari.m\"sajjanebhyo .adhikalokaa ekamantra.naa bhuutvaa paula.m na hatvaa bhojana.m paana nca na kari.syaama iti \"sapathena baddhaa.h santo ghaatakaa iva sajjitaa idaanii.m kevala.m bhavato .anumatim apek.sante| ");
INSERT INTO sanvel_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yaamimaa.m kathaa.m tva.m niveditavaan taa.m kasmaicidapi maa kathayetyuktvaa sahasrasenaapatista.m yuvaana.m vis.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantara.m sahasrasenaapati rdvau \"satasenaapatii aahuuyedam aadi\"sat, yuvaa.m raatrau praharaikaava\"si.s.taayaa.m satyaa.m kaisariyaanagara.m yaatu.m padaatisainyaanaa.m dve \"sate gho.takaarohisainyaanaa.m saptati.m \"saktidhaarisainyaanaa.m dve \"sate ca janaan sajjitaan kuruta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam aarohayitu.m phiilik.saadhipate.h samiipa.m nirvvighna.m netu nca vaahanaani samupasthaapayata.m| ");
INSERT INTO sanvel_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","apara.m sa patra.m likhitvaa dattavaan tallikhitametat, ");
INSERT INTO sanvel_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahaamahima\"sriiyuktaphiilik.saadhipataye klaudiyalu.siyasya namaskaara.h| ");
INSERT INTO sanvel_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihuudiiyalokaa.h puurvvam ena.m maanava.m dh.rtvaa svahastai rhantum udyataa etasminnantare sasainyoha.m tatropasthaaya e.sa jano romiiya iti vij naaya ta.m rak.sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimitta.m te tamapavadante tajj naatu.m te.saa sabhaa.m tamaanaayitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tataste.saa.m vyavasthaayaa viruddhayaa kayaacana kathayaa so.apavaadito.abhavat, kintu sa \"s.r\"nkhalabandhanaarho vaa praa.nanaa\"saarho bhavatiid.r\"sa.h kopyaparaadho mayaasya na d.r.s.ta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathaapi manu.syasyaasya vadhaartha.m yihuudiiyaa ghaatakaaiva sajjitaa etaa.m vaarttaa.m \"srutvaa tatk.sa.naat tava samiipamena.m pre.sitavaan asyaapavaadakaa.m\"sca tava samiipa.m gatvaapavaditum aaj naapayam| bhavata.h ku\"sala.m bhuuyaat| ");
INSERT INTO sanvel_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyaga.na aaj naanusaare.na paula.m g.rhiitvaa tasyaa.m rajanyaam aantipaatrinagaram aanayat| ");
INSERT INTO sanvel_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","pare.ahani tena saha yaatu.m gho.takaaruu.dhasainyaga.na.m sthaapayitvaa paraav.rtya durga.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tata.h pare gho.takaarohisainyaga.na.h kaisariyaanagaram upasthaaya tatpatram adhipate.h kare samarpya tasya samiipe paulam upasthaapitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadaadhipatistatpatra.m pa.thitvaa p.r.s.thavaan e.sa kimprade\"siiyo jana.h? sa kilikiyaaprade\"siiya eko jana iti j naatvaa kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavaapavaadakaga.na aagate tava kathaa.m \"sro.syaami| herodraajag.rhe ta.m sthaapayitum aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","pa ncabhyo dinebhya.h para.m hanaaniiyanaamaa mahaayaajako.adhipate.h samak.sa.m paulasya praatikuulyena nivedayitu.m tartullanaamaana.m ka ncana vaktaara.m praaciinajanaa.m\"sca sa\"ngina.h k.rtvaa kaisariyaanagaram aagacchat| ");
INSERT INTO sanvel_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tata.h paule samaaniite sati tartullastasyaapavaadakathaa.m kathayitum aarabhata he mahaamahimaphiilik.sa bhavato vayam atinirvvighna.m kaala.m yaapayaamo bhavata.h pari.naamadar\"sitayaa etadde\"siiyaanaa.m bahuuni ma\"ngalaani gha.titaani, ");
INSERT INTO sanvel_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti heto rvayamatik.rtaj naa.h santa.h sarvvatra sarvvadaa bhavato gu.naan gaayama.h| ");
INSERT INTO sanvel_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhi.h kathaabhi rbhavanta.m yena na vira njayaami tasmaad vinaye bhavaan banukampya madalpakathaa.m \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","e.sa mahaamaariisvaruupo naasaratiiyamatagraahisa.mghaatasya mukhyo bhuutvaa sarvvade\"se.su sarvve.saa.m yihuudiiyaanaa.m raajadrohaacara.naprav.rtti.m janayatiityasmaabhi rni\"scita.m| ");
INSERT INTO sanvel_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi a\"suci karttu.m ce.s.titavaan; iti kaara.naad vayam ena.m dh.rtvaa svavyavasthaanusaare.na vicaarayitu.m praavarttaamahi; ");
INSERT INTO sanvel_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu lu.siya.h sahasrasenaapatiraagatya balaad asmaaka.m karebhya ena.m g.rhiitvaa ");
INSERT INTO sanvel_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","etasyaapavaadakaan bhavata.h samiipam aagantum aaj naapayat| vaya.m yasmin tamapavaadaamo bhavataa padapavaadakathaayaa.m vicaaritaayaa.m satyaa.m sarvva.m v.rttaanta.m veditu.m \"sak.syate| ");
INSERT INTO sanvel_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tato yihuudiiyaa api sviik.rtya kathitavanta e.saa kathaa pramaa.nam| ");
INSERT INTO sanvel_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathaa.m kathayitu.m paula.m pratii\"ngita.m k.rtavati sa kathitavaan bhavaan bahuun vatsaraan yaavad etadde\"sasya \"saasana.m karotiiti vij naaya pratyuttara.m daatum ak.sobho.abhavam| ");
INSERT INTO sanvel_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kevala.m dvaada\"sa dinaani yaataani, aham aaraadhanaa.m karttu.m yiruu\"saalamanagara.m gatavaan e.saa kathaa bhavataa j naatu.m \"sakyate; ");
INSERT INTO sanvel_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhe maa.m madhyemandira.m kenaapi saha vita.n.daa.m kurvvanta.m kutraapi bhajanabhavane nagare vaa lokaan kuprav.rtti.m janayantu.m na d.r.s.tavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idaanii.m yasmin yasmin maam apavadante tasya kimapi pramaa.na.m daatu.m na \"saknuvanti| ");
INSERT INTO sanvel_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhavi.syadvaakyagranthe vyavasthaagranthe ca yaa yaa kathaa likhitaaste taasu sarvvaasu vi\"svasya yanmatam ime vidharmma.m jaananti tanmataanusaare.naaha.m nijapit.rpuru.saa.naam ii\"svaram aaraadhayaamiityaha.m bhavata.h samak.sam a\"ngiikaromi| ");
INSERT INTO sanvel_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhaarmmikaa.naam adhaarmmikaa.naa nca pramiitalokaanaamevotthaana.m bhavi.syatiiti kathaamime sviikurvvanti tathaahamapi tasmin ii\"svare pratyaa\"saa.m karomi; ");
INSERT INTO sanvel_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ii\"svarasya maanavaanaa nca samiipe yathaa nirdo.so bhavaami tadartha.m satata.m yatnavaan asmi| ");
INSERT INTO sanvel_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahu.su vatsare.su gate.su svade\"siiyalokaanaa.m nimitta.m daaniiyadravyaa.ni naivedyaani ca samaadaaya punaraagamana.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatoha.m \"suci rbhuutvaa lokaanaa.m samaagama.m kalaha.m vaa na kaaritavaan tathaapyaa\"siyaade\"siiyaa.h kiyanto yihudiiyalokaa madhyemandira.m maa.m dh.rtavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamopari yadi kaacidapavaadakathaasti tarhi bhavata.h samiipam upasthaaya te.saameva saak.syadaanam ucitam| ");
INSERT INTO sanvel_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nocet puurvve mahaasabhaasthaanaa.m lokaanaa.m sannidhau mama da.n.daayamaanatvasamaye, ahamadya m.rtaanaamutthaane yu.smaabhi rvicaaritosmi, ");
INSERT INTO sanvel_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","te.saa.m madhye ti.s.thannaha.m yaamimaa.m kathaamuccai.h svare.na kathitavaan tadanyo mama kopi do.so.alabhyata na veti varam ete samupasthitalokaa vadantu| ");
INSERT INTO sanvel_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadaa phiilik.sa etaa.m kathaa.m \"srutvaa tanmatasya vi\"se.sav.rttaanta.m vij naatu.m vicaara.m sthagita.m k.rtvaa kathitavaan lu.siye sahasrasenaapatau samaayaate sati yu.smaaka.m vicaaram aha.m ni.spaadayi.syaami| ");
INSERT INTO sanvel_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantara.m bandhana.m vinaa paula.m rak.situ.m tasya sevanaaya saak.saatkara.naaya vaa tadiiyaatmiiyabandhujanaan na vaarayitu nca \"samasenaapatim aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadinaat para.m phiilik.so.adhipati rdru.sillaanaamnaa yihuudiiyayaa svabhaaryyayaa sahaagatya paulamaahuuya tasya mukhaat khrii.s.tadharmmasya v.rttaantam a\"srau.siit| ");
INSERT INTO sanvel_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulena nyaayasya parimitabhogasya caramavicaarasya ca kathaayaa.m kathitaayaa.m satyaa.m phiilik.sa.h kampamaana.h san vyaaharad idaanii.m yaahi, aham avakaa\"sa.m praapya tvaam aahuusyaami| ");
INSERT INTO sanvel_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyartha.m paulena mahya.m mudraadaasyante iti patyaa\"saa.m k.rtvaa sa puna.h punastamaahuuya tena saaka.m kathopakathana.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayaat para.m parkiyaphii.s.ta phaalik.sasya pada.m praapte sati phiilik.so yihuudiiyaan santu.s.taan cikiir.san paula.m baddha.m sa.msthaapya gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantara.m phii.s.to nijaraajyam aagatya dinatrayaat para.m kaisariyaato yiruu\"saalamnagaram aagamat| ");
INSERT INTO sanvel_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadaa mahaayaajako yihuudiiyaanaa.m pradhaanalokaa\"sca tasya samak.sa.m paulam apaavadanta| ");
INSERT INTO sanvel_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavaan ta.m yiruu\"saalamam aanetum aaj naapayatviti viniiya te tasmaad anugraha.m vaa nchitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yata.h pathimadhye gopanena paula.m hantu.m tai rghaatakaa niyuktaa.h| phii.s.ta uttara.m dattavaan paula.h kaisariyaayaa.m sthaasyati punaralpadinaat param aha.m tatra yaasyaami| ");
INSERT INTO sanvel_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya maanu.sasya yadi ka\"scid aparaadhasti.s.thati tarhi yu.smaaka.m ye \"saknuvanti te mayaa saha tatra gatvaa tamapavadantu sa etaa.m kathaa.m kathitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","da\"sadivasebhyo.adhika.m vilambya phii.s.tastasmaat kaisariyaanagara.m gatvaa parasmin divase vicaaraasana upadi\"sya paulam aanetum aaj naapayat| ");
INSERT INTO sanvel_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paule samupasthite sati yiruu\"saalamnagaraad aagataa yihuudiiyalokaasta.m caturdi\"si sa.mve.s.tya tasya viruddha.m bahuun mahaado.saan utthaapitavanta.h kintu te.saa.m kimapi pramaa.na.m daatu.m na \"saknuvanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tata.h paula.h svasmin uttaramidam uditavaan, yihuudiiyaanaa.m vyavasthaayaa mandirasya kaisarasya vaa pratikuula.m kimapi karmma naaha.m k.rtavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phii.s.to yihuudiiyaan santu.s.taan karttum abhila.san paulam abhaa.sata tva.m ki.m yiruu\"saalama.m gatvaasmin abhiyoge mama saak.saad vicaarito bhavi.syasi? ");
INSERT INTO sanvel_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tata.h paula uttara.m proktavaan, yatra mama vicaaro bhavitu.m yogya.h kaisarasya tatra vicaaraasana eva samupasthitosmi; aha.m yihuudiiyaanaa.m kaamapi haani.m naakaar.sam iti bhavaan yathaarthato vijaanaati| ");
INSERT INTO sanvel_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ka ncidaparaadha.m ki ncana vadhaarha.m karmma vaa yadyaham akari.sya.m tarhi praa.nahananada.n.damapi bhoktum udyato.abhavi.sya.m, kintu te mama samapavaada.m kurvvanti sa yadi kalpitamaatro bhavati tarhi te.saa.m kare.su maa.m samarpayitu.m kasyaapyadhikaaro naasti, kaisarasya nika.te mama vicaaro bhavatu| ");
INSERT INTO sanvel_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadaa phii.s.to mantribhi.h saarddha.m sa.mmantrya paulaaya kathitavaan, kaisarasya nika.te ki.m tava vicaaro bhavi.syati? kaisarasya samiipa.m gami.syasi| ");
INSERT INTO sanvel_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinebhya.h param aagripparaajaa bar.niikii ca phii.s.ta.m saak.saat karttu.m kaisariyaanagaram aagatavantau| ");
INSERT INTO sanvel_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadaa tau bahudinaani tatra sthitau tata.h phii.s.tasta.m raajaana.m paulasya kathaa.m vij naapya kathayitum aarabhata paulanaamaanam eka.m bandi phiilik.so baddha.m sa.msthaapya gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yiruu\"saalami mama sthitikaale mahaayaajako yihuudiiyaanaa.m praaciinalokaa\"sca tam apodya tamprati da.n.daaj naa.m praarthayanta| ");
INSERT INTO sanvel_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatoham ityuttaram avada.m yaavad apodito jana.h svaapavaadakaan saak.saat k.rtvaa svasmin yo.aparaadha aaropitastasya pratyuttara.m daatu.m suyoga.m na praapnoti, taavatkaala.m kasyaapi maanu.sasya praa.nanaa\"saaj naapana.m romilokaanaa.m riiti rnahi| ");
INSERT INTO sanvel_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tataste.svatraagate.su parasmin divase.aham avilamba.m vicaaraasana upavi\"sya ta.m maanu.sam aanetum aaj naapayam| ");
INSERT INTO sanvel_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantara.m tasyaapavaadakaa upasthaaya yaad.r\"sam aha.m cintitavaan taad.r\"sa.m ka ncana mahaapavaada.m notthaapya ");
INSERT INTO sanvel_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","sve.saa.m mate tathaa paulo ya.m sajiiva.m vadati tasmin yii\"sunaamani m.rtajane ca tasya viruddha.m kathitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatoha.m taad.rgvicaare sa.m\"sayaana.h san kathitavaan tva.m yiruu\"saalama.m gatvaa ki.m tatra vicaarito bhavitum icchasi? ");
INSERT INTO sanvel_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadaa paulo mahaaraajasya nika.te vicaarito bhavitu.m praarthayata, tasmaad yaavatkaala.m ta.m kaisarasya samiipa.m pre.sayitu.m na \"saknomi taavatkaala.m tamatra sthaapayitum aadi.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata aagrippa.h phii.s.tam uktavaan, ahamapi tasya maanu.sasya kathaa.m \"srotum abhila.saami| tadaa phii.s.to vyaaharat \"svastadiiyaa.m kathaa.m tva.m \"sro.syasi| ");
INSERT INTO sanvel_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divase aagrippo bar.niikii ca mahaasamaagama.m k.rtvaa pradhaanavaahiniipatibhi rnagarasthapradhaanalokai\"sca saha militvaa raajag.rhamaagatya samupasthitau tadaa phii.s.tasyaaj nayaa paula aaniito.abhavat| ");
INSERT INTO sanvel_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadaa phii.s.ta.h kathitavaan he raajan aagrippa he upasthitaa.h sarvve lokaa yiruu\"saalamnagare yihuudiiyalokasamuuho yasmin maanu.se mama samiipe nivedana.m k.rtvaa proccai.h kathaamimaa.m kathitavaan punaralpakaalamapi tasya jiivana.m nocita.m tameta.m maanu.sa.m pa\"syata| ");
INSERT INTO sanvel_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintve.sa jana.h praa.nanaa\"sarha.m kimapi karmma na k.rtavaan ityajaanaa.m tathaapi sa mahaaraajasya sannidhau vicaarito bhavitu.m praarthayata tasmaat tasya samiipa.m ta.m pre.sayitu.m matimakaravam| ");
INSERT INTO sanvel_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu \"sriiyuktasya samiipam etasmin ki.m lekhaniiyam ityasya kasyacin nir.nayasya na jaatatvaad etasya vicaare sati yathaaha.m lekhitu.m ki ncana ni\"scita.m praapnomi tadartha.m yu.smaaka.m samak.sa.m vi\"se.sato he aagripparaaja bhavata.h samak.sam etam aanaye| ");
INSERT INTO sanvel_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yato bandipre.sa.nasamaye tasyaabhiyogasya ki ncidalekhanam aham ayukta.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata aagrippa.h paulam avaadiit, nijaa.m kathaa.m kathayitu.m tubhyam anumati rdiiyate| tasmaat paula.h kara.m prasaaryya svasmin uttaram avaadiit| ");
INSERT INTO sanvel_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","he aagripparaaja yatkaara.naadaha.m yihuudiiyairapavaadito .abhava.m tasya v.rttaantam adya bhavata.h saak.saan nivedayitumanumatoham ida.m sviiya.m parama.m bhaagya.m manye; ");
INSERT INTO sanvel_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yato yihuudiiyalokaanaa.m madhye yaa yaa riiti.h suuk.smavicaaraa\"sca santi te.su bhavaan vij natama.h; ataeva praarthaye dhairyyamavalambya mama nivedana.m \"s.r.notu| ");
INSERT INTO sanvel_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","aha.m yiruu\"saalamnagare svade\"siiyalokaanaa.m madhye ti.s.than aa yauvanakaalaad yadruupam aacaritavaan tad yihuudiiyalokaa.h sarvve vidanti| ");
INSERT INTO sanvel_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmaaka.m sarvvebhya.h \"suddhatama.m yat phiruu\"siiyamata.m tadavalambii bhuutvaaha.m kaala.m yaapitavaan ye janaa aa baalyakaalaan maa.m jaanaanti te etaad.r\"sa.m saak.sya.m yadi dadaati tarhi daatu.m \"saknuvanti| ");
INSERT INTO sanvel_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu he aagripparaaja ii\"svaro.asmaaka.m puurvvapuru.saa.naa.m nika.te yad a\"ngiik.rtavaan tasya pratyaa\"saahetoraham idaanii.m vicaarasthaane da.n.daayamaanosmi| ");
INSERT INTO sanvel_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyaa\"ngiikaarasya phala.m praaptum asmaaka.m dvaada\"sava.m\"saa divaani\"sa.m mahaayatnaad ii\"svarasevana.m k.rtvaa yaa.m pratyaa\"saa.m kurvvanti tasyaa.h pratyaa\"saayaa hetoraha.m yihuudiiyairapavaadito.abhavam| ");
INSERT INTO sanvel_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ii\"svaro m.rtaan utthaapayi.syatiiti vaakya.m yu.smaaka.m nika.te.asambhava.m kuto bhavet? ");
INSERT INTO sanvel_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","naasaratiiyayii\"so rnaamno viruddha.m naanaaprakaarapratikuulaacara.nam ucitam ityaha.m manasi yathaartha.m vij naaya ");
INSERT INTO sanvel_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yiruu\"saalamanagare tadakarava.m phalata.h pradhaanayaajakasya nika.taat k.samataa.m praapya bahuun pavitralokaan kaaraayaa.m baddhavaan vi\"se.sataste.saa.m hananasamaye te.saa.m viruddhaa.m nijaa.m sammati.m prakaa\"sitavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vaara.m vaara.m bhajanabhavane.su tebhyo da.n.da.m pradattavaan balaat ta.m dharmma.m nindayitavaa.m\"sca puna\"sca taan prati mahaakrodhaad unmatta.h san vide\"siiyanagaraa.ni yaavat taan taa.ditavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ittha.m pradhaanayaajakasya samiipaat \"saktim aaj naapatra nca labdhvaa damme.saknagara.m gatavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadaaha.m he raajan maargamadhye madhyaahnakaale mama madiiyasa\"nginaa.m lokaanaa nca catas.r.su dik.su gaga.naat prakaa\"samaanaa.m bhaaskaratopi tejasvatii.m diipti.m d.r.s.tavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmaad asmaasu sarvve.su bhuumau patite.su satsu he \"saula hai \"saula kuto maa.m taa.dayasi? ka.n.takaanaa.m mukhe paadaahanana.m tava du.hsaadhyam ibriiyabhaa.sayaa gadita etaad.r\"sa eka.h \"sabdo mayaa \"sruta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadaaha.m p.r.s.tavaan he prabho ko bhavaan? tata.h sa kathitavaan ya.m yii\"su.m tva.m taa.dayasi soha.m, ");
INSERT INTO sanvel_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samutti.s.tha tva.m yad d.r.s.tavaan ita.h puna nca yadyat tvaa.m dar\"sayi.syaami te.saa.m sarvve.saa.m kaaryyaa.naa.m tvaa.m saak.si.na.m mama sevaka nca karttum dar\"sanam adaam| ");
INSERT INTO sanvel_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","vi\"se.sato yihuudiiyalokebhyo bhinnajaatiiyebhya\"sca tvaa.m manoniita.m k.rtvaa te.saa.m yathaa paapamocana.m bhavati ");
INSERT INTO sanvel_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathaa te mayi vi\"svasya pavitriik.rtaanaa.m madhye bhaaga.m praapnuvanti tadabhipraaye.na te.saa.m j naanacak.suu.m.si prasannaani karttu.m tathaandhakaaraad diipti.m prati \"saitaanaadhikaaraacca ii\"svara.m prati matii.h paraavarttayitu.m te.saa.m samiipa.m tvaa.m pre.syaami| ");
INSERT INTO sanvel_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","he aagripparaaja etaad.r\"sa.m svargiiyapratyaade\"sa.m agraahyam ak.rtvaaha.m ");
INSERT INTO sanvel_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamato damme.saknagare tato yiruu\"saalami sarvvasmin yihuudiiyade\"se anye.su de\"se.su ca yeेna lokaa mati.m paraavarttya ii\"svara.m prati paraavarttayante, mana.hparaavarttanayogyaani karmmaa.ni ca kurvvanti taad.r\"sam upade\"sa.m pracaaritavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","etatkaara.naad yihuudiiyaa madhyemandira.m maa.m dh.rtvaa hantum udyataa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathaapi khrii.s.to du.hkha.m bhuktvaa sarvve.saa.m puurvva.m \"sma\"saanaad utthaaya nijade\"siiyaanaa.m bhinnade\"siiyaanaa nca samiipe diipti.m prakaa\"sayi.syati ");
INSERT INTO sanvel_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhavi.syadvaadiga.no muusaa\"sca bhaavikaaryyasya yadida.m pramaa.nam adaduretad vinaanyaa.m kathaa.m na kathayitvaa ii\"svaraad anugraha.m labdhvaa mahataa.m k.sudraa.naa nca sarvve.saa.m samiipe pramaa.na.m dattvaadya yaavat ti.s.thaami| ");
INSERT INTO sanvel_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamaa.m kathaa.m ni\"samya phii.s.ta uccai.h svare.na kathitavaan he paula tvam unmattosi bahuvidyaabhyaasena tva.m hataj naano jaata.h| ");
INSERT INTO sanvel_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavaan he mahaamahima phii.s.ta naaham unmatta.h kintu satya.m vivecaniiya nca vaakya.m prastaumi| ");
INSERT INTO sanvel_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya saak.saad ak.sobha.h san kathaa.m kathayaami sa raajaa tadv.rttaanta.m jaanaati tasya samiipe kimapi gupta.m neti mayaa ni\"scita.m budhyate yatastad vijane na k.rta.m| ");
INSERT INTO sanvel_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","he aagripparaaja bhavaan ki.m bhavi.syadvaadiga.noktaani vaakyaani pratyeti? bhavaan pratyeti tadaha.m jaanaami| ");
INSERT INTO sanvel_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata aagrippa.h paulam abhihitavaan tva.m prav.rtti.m janayitvaa praaye.na maamapi khrii.s.tiiya.m karo.si| ");
INSERT INTO sanvel_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tata.h so.avaadiit bhavaan ye ye lokaa\"sca mama kathaam adya \"s.r.nvanti praaye.na iti nahi kintvetat \"s.r\"nkhalabandhana.m vinaa sarvvathaa te sarvve maad.r\"saa bhavantvitii\"svasya samiipe praarthaye.aham| ");
INSERT INTO sanvel_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","etasyaa.m kathaayaa.m kathitaayaa.m sa raajaa so.adhipati rbar.niikii sabhaasthaa lokaa\"sca tasmaad utthaaya ");
INSERT INTO sanvel_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gopane paraspara.m vivicya kathitavanta e.sa jano bandhanaarha.m praa.nahananaarha.m vaa kimapi karmma naakarot| ");
INSERT INTO sanvel_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata aagrippa.h phii.s.tam avadat, yadye.sa maanu.sa.h kaisarasya nika.te vicaarito bhavitu.m na praarthayi.syat tarhi mukto bhavitum a\"sak.syat| ");
INSERT INTO sanvel_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathenaasmaakam itoliyaade\"sa.m prati yaatraayaa.m ni\"scitaayaa.m satyaa.m te yuuliyanaamno mahaaraajasya sa.mghaataantargatasya senaapate.h samiipe paula.m tadanyaan katinayajanaa.m\"sca samaarpayan| ");
INSERT INTO sanvel_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam aadraamuttiiya.m potamekam aaruhya aa\"siyaade\"sasya ta.tasamiipena yaatu.m mati.m k.rtvaa la\"ngaram utthaapya potam amocayaama; maakidaniyaade\"sasthathi.salaniikiinivaasyaaristaarkhanaamaa ka\"scid jano.asmaabhi.h saarddham aasiit| ");
INSERT INTO sanvel_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divase .asmaabhi.h siidonnagare pote laagite tatra yuuliya.h senaapati.h paula.m prati saujanya.m pradarthya saantvanaartha.m bandhubaandhavaan upayaatum anujaj nau| ");
INSERT INTO sanvel_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmaat pote mocite sati sammukhavaayo.h sambhavaad vaya.m kupropadviipasya tiirasamiipena gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyaayaa.h paamphuuliyaayaa\"sca samudrasya paara.m gatvaa luukiyaade\"saantargata.m muraanagaram upaati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthaanaad itaaliyaade\"sa.m gacchati ya.h sikandariyaanagarasya potasta.m tatra praapya \"satasenaapatista.m potam asmaan aarohayat| ");
INSERT INTO sanvel_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tata.h para.m bahuuni dinaani \"sanai.h \"sanai.h rgatvaa kniidapaar\"svopasthtiे.h puurvva.m pratikuulena pavanena vaya.m salmonyaa.h sammukham upasthaaya kriityupadviipasya tiirasamiipena gatavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ka.s.tena tamuttiiryya laaseyaanagarasyaadha.h sundaranaamaka.m khaatam upaati.s.thaama| ");
INSERT INTO sanvel_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ittha.m bahutitha.h kaalo yaapita upavaasadina ncaatiita.m, tatkaara.naat nauvartmani bhaya\"nkare sati paulo vinayena kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","he mahecchaa aha.m ni\"scaya.m jaanaami yaatraayaamasyaam asmaaka.m kle\"saa bahuunaamapacayaa\"sca bhavi.syanti, te kevala.m potasaamagryoriti nahi, kintvasmaaka.m praa.naanaamapi| ");
INSERT INTO sanvel_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadaa \"satasenaapati.h pauैेloktavaakyatopi kar.nadhaarasya potava.nija\"sca vaakya.m bahuma.msta| ");
INSERT INTO sanvel_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khaata.m \"siitakaale vaasaarhasthaana.m na tasmaad avaaciipratiicordi\"so.h kriityaa.h phainiikiyakhaata.m yaatu.m yadi \"saknuvantastarhi tatra \"siitakaala.m yaapayitu.m praaye.na sarvve mantrayaamaasu.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tata.h para.m dak.si.navaayu rmanda.m vahatiiti vilokya nijaabhipraayasya siddhe.h suyogo bhavatiiti buddhvaa pota.m mocayitvaa kriityupadviipasya tiirasamiipena calitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpak.sa.naat parameva urakludonnaamaa pratikuula.h praca.n.do vaayu rvahan pote.alagiit ");
INSERT INTO sanvel_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyaabhimukha.m gantum potasyaa\"saktatvaad vaya.m vaayunaa svaya.m niitaa.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantara.m klaudiinaamna upadviipasya kuulasamiipena pota.m gamayitvaa bahunaa ka.s.tena k.sudranaavam arak.saama| ");
INSERT INTO sanvel_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","te taamaaruhya rajjcaa potasyaadhobhaagam abadhnan tadanantara.m cet poto saikate lagatiiti bhayaad vaatavasanaanyamocayan tata.h poto vaayunaa caalita.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu krama\"so vaayo.h prabalatvaat poto dolaayamaano.abhavat parasmin divase potasthaani katipayaani dravyaa.ni toye nik.siptaani| ");
INSERT INTO sanvel_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","t.rtiiyadivase vaya.m svahastai.h potasajjanadravyaa.ni nik.siptavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tato bahudinaani yaavat suuryyanak.satraadiini samaacchannaani tato .atiiva vaatyaagamaad asmaaka.m praa.narak.saayaa.h kaapi pratyaa\"saa naati.s.that| ");
INSERT INTO sanvel_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudine.su lokairanaahaare.na yaapite.su sarvve.saa.m saak.sat paulasti.s.than akathayat, he mahecchaa.h kriityupadviipaat pota.m na mocayitum aha.m puurvva.m yad avada.m tadgraha.na.m yu.smaakam ucitam aasiit tathaa k.rte yu.smaakam e.saa vipad e.so.apacaya\"sca naagha.ti.syetaam| ");
INSERT INTO sanvel_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu saamprata.m yu.smaan viniiya braviimyaha.m, yuuya.m na k.subhyata yu.smaakam ekasyaapi praa.nino haani rna bhavi.syati, kevalasya potasya haani rbhavi.syati| ");
INSERT INTO sanvel_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yato yasye\"svarasya loko.aha.m ya ncaaha.m paricaraami tadiiya eko duuto hyo raatrau mamaantike ti.s.than kathitavaan, ");
INSERT INTO sanvel_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","he paula maa bhai.sii.h kaisarasya sammukhe tvayopasthaatavya.m; tavaitaan sa\"ngino lokaan ii\"svarastubhya.m dattavaan| ");
INSERT INTO sanvel_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataeva he mahecchaa yuuya.m sthiramanaso bhavata mahya.m yaa kathaakathi saava\"sya.m gha.ti.syate mamaitaad.r\"sii vi\"svaasa ii\"svare vidyate, ");
INSERT INTO sanvel_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyacid upadviipasyopari patitavyam asmaabhi.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tata.h param aadriyaasamudre potastathaiva dolaayamaana.h san itastato gacchan caturda\"sadivasasya raatre rdvitiiyapraharasamaye kasyacit sthalasya samiipamupati.s.thatiiti potiiyalokaa anvamanyanta| ");
INSERT INTO sanvel_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tataste jala.m parimaaya tatra vi.m\"sati rvyaamaa jalaaniiti j naatavanta.h| ki ncidduura.m gatvaa punarapi jala.m parimitavanta.h| tatra pa ncada\"sa vyaamaa jalaani d.r.s.tvaa ");
INSERT INTO sanvel_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","cet paa.saa.ne lagatiiti bhayaat potasya pa\"scaadbhaagata\"scaturo la\"ngaraan nik.sipya divaakaram apek.sya sarvve sthitavanta.h| ");
INSERT INTO sanvel_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu potiiyalokaa.h potaagrabhaage la\"ngaranik.sepa.m chala.m k.rtvaa jaladhau k.sudranaavam avarohya palaayitum ace.s.tanta| ");
INSERT INTO sanvel_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tata.h paula.h senaapataye sainyaga.naaya ca kathitavaan, ete yadi potamadhye na ti.s.thanti tarhi yu.smaaka.m rak.sa.na.m na \"sakya.m| ");
INSERT INTO sanvel_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadaa senaaga.no rajjuun chitvaa naava.m jale patitum adadaat| ");
INSERT INTO sanvel_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhaatasamaye paula.h sarvvaan janaan bhojanaartha.m praarthya vyaaharat, adya caturda\"sadinaani yaavad yuuyam apek.samaanaa anaahaaraa.h kaalam ayaapayata kimapi naabhu.mgdha.m| ");
INSERT INTO sanvel_vpl VALUES ("