﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanurd_vpl;
CREATE TABLE sanurd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanurd_vpl WRITE;
INSERT INTO sanurd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","اِبْراہِیمَح سَنْتانو دایُودْ تَسْیَ سَنْتانو یِیشُکھْرِیشْٹَسْتَسْیَ پُورْوَّپُرُشَوَںشَشْرینِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","اِبْراہِیمَح پُتْرَ اِسْہاکْ تَسْیَ پُتْرو یاکُوبْ تَسْیَ پُتْرو یِہُوداسْتَسْیَ بھْراتَرَشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","تَسْمادْ یِہُوداتَسْتامَرو گَرْبھے پیرَسّیرَہَو جَجْناتے، تَسْیَ پیرَسَح پُتْرو ہِشْرونْ تَسْیَ پُتْرو رامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","تَسْیَ پُتْرو مِّینادَبْ تَسْیَ پُتْرو نَہَشونْ تَسْیَ پُتْرَح سَلْمونْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","تَسْمادْ راہَبو گَرْبھے بویَمْ جَجْنے، تَسْمادْ رُوتو گَرْبھے اوبیدْ جَجْنے، تَسْیَ پُتْرو یِشَیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","تَسْیَ پُتْرو دایُودْ راجَح تَسْمادْ مرِتورِیَسْیَ جایایاں سُلیمانْ جَجْنے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","تَسْیَ پُتْرو رِہَبِیامْ، تَسْیَ پُتْروبِیَح، تَسْیَ پُتْرَ آسا:۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","تَسْیَ سُتو یِہوشاپھَٹْ تَسْیَ سُتو یِہورامَ تَسْیَ سُتَ اُشِیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","تَسْیَ سُتو یوتھَمْ تَسْیَ سُتَ آہَمْ تَسْیَ سُتو ہِشْکِیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","تَسْیَ سُتو مِنَشِح، تَسْیَ سُتَ آمونْ تَسْیَ سُتو یوشِیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","بابِلْنَگَرے پْرَوَسَناتْ پُورْوَّں سَ یوشِیو یِکھَنِیَں تَسْیَ بھْراترِںشْچَ جَنَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","تَتو بابِلِ پْرَوَسَنَکالے یِکھَنِیَح شَلْتِیییلَں جَنَیاماسَ، تَسْیَ سُتَح سِرُبّاوِلْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","تَسْیَ سُتو بوہُدْ تَسْیَ سُتَ اِلِییاکِیمْ تَسْیَ سُتوسورْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","اَسورَح سُتَح سادوکْ تَسْیَ سُتَ آکھِیمْ تَسْیَ سُتَ اِلِیہُودْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","تَسْیَ سُتَ اِلِیاسَرْ تَسْیَ سُتو مَتَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","تَسْیَ سُتو یاکُوبْ تَسْیَ سُتو یُوشَپھْ تَسْیَ جایا مَرِیَمْ؛ تَسْیَ گَرْبھے یِیشُرَجَنِ، تَمیوَ کھْرِیشْٹَمْ (اَرْتھادْ اَبھِشِکْتَں) وَدَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","اِتّھَمْ اِبْراہِیمو دایُودَں یاوَتْ ساکَلْیینَ چَتُرْدَشَپُرُشاح؛ آ دایُودَح کالادْ بابِلِ پْرَوَسَنَکالَں یاوَتْ چَتُرْدَشَپُرُشا بھَوَنْتِ۔ بابِلِ پْرَواسَنَکالاتْ کھْرِیشْٹَسْیَ کالَں یاوَتْ چَتُرْدَشَپُرُشا بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","یِیشُکھْرِیشْٹَسْیَ جَنْمَ کَتھْتھَتے۔ مَرِیَمْ نامِکا کَنْیا یُوشَپھے واگْدَتّاسِیتْ، تَدا تَیوح سَنْگَماتْ پْراکْ سا کَنْیا  پَوِتْریناتْمَنا گَرْبھَوَتِی بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","تَتْرَ تَسْیاح پَتِ رْیُوشَپھْ سَوجَنْیاتْ تَسْیاح کَلَنْگَں پْرَکاشَیِتُمْ اَنِچّھَنْ گوپَنینے تاں پارِتْیَکْتُں مَنَشْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","سَ تَتھَیوَ بھاوَیَتِ، تَدانِیں پَرَمیشْوَرَسْیَ دُوتَح سْوَپْنے تَں دَرْشَنَں دَتّوا وْیاجَہارَ، ہے دایُودَح سَنْتانَ یُوشَپھْ تْوَں نِجاں جایاں مَرِیَمَمْ آداتُں ما بھَیشِیح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","یَتَسْتَسْیا گَرْبھَح پَوِتْراداتْمَنوبھَوَتْ، سا چَ پُتْرَں پْرَسَوِشْیَتے، تَدا تْوَں تَسْیَ نامَ یِیشُمْ (اَرْتھاتْ تْراتارَں) کَرِیشْیَسے، یَسْماتْ سَ نِجَمَنُجانْ تیشاں کَلُشیبھْیَ اُدّھَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","اِتّھَں سَتِ، پَشْیَ گَرْبھَوَتِی کَنْیا تَنَیَں پْرَسَوِشْیَتے۔ اِمّانُوییلْ تَدِییَنْچَ نامَدھییَں بھَوِشْیَتِ۔۔ اِمّانُوییلْ اَسْماکَں سَنْگِیشْوَرَاِتْیَرْتھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","اِتِ یَدْ وَچَنَں پُرْوَّں بھَوِشْیَدْوَکْتْرا اِیشْوَرَح کَتھایاماسَ، تَتْ تَدانِیں سِدّھَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","اَنَنْتَرَں یُوشَپھْ نِدْراتو جاگَرِتَ اُتّھایَ پَرَمیشْوَرِییَدُوتَسْیَ نِدیشانُسارینَ نِجاں جایاں جَگْراہَ، ");
INSERT INTO sanurd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","کِنْتُ یاوَتْ سا نِجَں پْرَتھَمَسُتَں اَ سُشُوے، تاوَتْ تاں نوپاگَچّھَتْ، تَتَح سُتَسْیَ نامَ یِیشُں چَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","اَنَنْتَرَں ہیرودْ سَںجْنَکے راجْنِ راجْیَں شاسَتِ یِہُودِییَدیشَسْیَ بَیتْلیہَمِ نَگَرے یِیشَو جاتَوَتِ چَ، کَتِپَیا جْیوتِرْوُّدَح پُورْوَّسْیا دِشو یِرُوشالَمْنَگَرَں سَمیتْیَ کَتھَیَماسُح، ");
INSERT INTO sanurd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","یو یِہُودِییاناں راجا جاتَوانْ، سَ کُتْراسْتے؟ وَیَں پُورْوَّسْیاں دِشِ تِشْٹھَنْتَسْتَدِییاں تارَکامْ اَپَشْیامَ تَسْماتْ تَں پْرَنَنْتُمْ اَाگَمامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","تَدا ہیرودْ راجا کَتھامیتاں نِشَمْیَ یِرُوشالَمْنَگَرَسْتھِتَیح سَرْوَّمانَوَیح سارْدّھَمْ اُدْوِجْیَ ");
INSERT INTO sanurd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","سَرْوّانْ پْرَدھانَیاجَکانْ اَدھْیاپَکاںشْچَ سَماہُویانِییَ پَپْرَچّھَ، کھْرِیشْٹَح کُتْرَ جَنِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","تَدا تے کَتھَیاماسُح، یِہُودِییَدیشَسْیَ بَیتْلیہَمِ نَگَرے، یَتو بھَوِشْیَدْوادِنا اِتّھَں لِکھِتَماسْتے، ");
INSERT INTO sanurd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","سَرْوّابھْیو راجَدھانِیبھْیو یِہُودِییَسْیَ نِیورِتَح۔ ہے یِیہُودِییَدیشَسْیے بَیتْلیہَمْ تْوَں نَ چاوَرا۔ اِسْراییلِییَلوکانْ مے یَتو یَح پالَیِشْیَتِ۔ تادرِگیکو مَہاراجَسْتْوَنْمَدھْیَ اُدْبھَوِشْیَتِی۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","تَدانِیں ہیرودْ راجا تانْ جْیوتِرْوِّدو گوپَنَمْ آہُویَ سا تارَکا کَدا درِشْٹابھَوَتْ ، تَدْ وِنِشْچَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","اَپَرَں تانْ بَیتْلیہَمَں پْرَہِیتْیَ گَدِتَوانْ، یُویَں یاتَ، یَتْناتْ تَں شِشُمْ اَنْوِشْیَ تَدُدّیشے پْراپْتے مَہْیَں وارْتّاں داسْیَتھَ، تَتو مَیاپِ گَتْوا سَ پْرَنَںسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","تَدانِیں راجْنَ ایتادرِشِیمْ آجْناں پْراپْیَ تے پْرَتَسْتھِرے، تَتَح پُورْوَّرْسْیاں دِشِ سْتھِتَیسْتَے رْیا تارَکا درِشْٹا سا تارَکا تیشامَگْرے گَتْوا یَتْرَ سْتھانے شِشُوراسْتے، تَسْیَ سْتھانَسْیوپَرِ سْتھَگِتا تَسْیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","تَدْ درِشْٹْوا تے مَہانَنْدِتا بَبھُووُح، ");
INSERT INTO sanurd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","تَتو گیہَمَدھْیَ پْرَوِشْیَ تَسْیَ ماتْرا مَرِیَما سادّھَں تَں شِشُں نِرِیکْشَیَ دَنْڈَوَدْ بھُوتْوا پْرَنیمُح، اَپَرَں سْویشاں گھَنَسَمْپَتِّں موچَیِتْوا سُوَرْنَں کُنْدُرُں گَنْدھَرَمَنْچَ تَسْمَے دَرْشَنِییَں دَتَّوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","پَشْچادْ ہیرودْ راجَسْیَ سَمِیپَں پُنَرَپِ گَنْتُں سْوَپْنَ اِیشْوَرینَ نِشِدّھاح سَنْتو نْیینَ پَتھا تے نِجَدیشَں پْرَتِ پْرَتَسْتھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","اَنَنْتَرَں تیشُ گَتَوَتْمُ پَرَمیشْوَرَسْیَ دُوتو یُوشَپھے سْوَپْنے دَرْشَنَں دَتْوا جَگادَ، تْوَمْ اُتّھایَ شِشُں تَنْماتَرَنْچَ گرِہِیتْوا مِسَرْدیشَں پَلایَسْوَ، اَپَرَں یاوَدَہَں تُبھْیَں وارْتّاں نَ کَتھَیِشْیامِ، تاوَتْ تَتْرَیوَ نِوَسَ، یَتو راجا ہیرودْ شِشُں ناشَیِتُں مرِگَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","تَدانِیں یُوشَپھْ اُتّھایَ رَجَنْیاں شِشُں تَنْماتَرَنْچَ گرِہِیتْوا مِسَرْدیشَں پْرَتِ پْرَتَسْتھے، ");
INSERT INTO sanurd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","گَتْوا چَ ہیرودو نرِپَتے رْمَرَنَپَرْیَّنْتَں تَتْرَ دیشے نْیُواسَ، تینَ مِسَرْدیشادَہَں پُتْرَں سْوَکِییَں سَمُپاہُویَمْ۔ یَدیتَدْوَچَنَمْ اِیشْوَرینَ بھَوِشْیَدْوادِنا کَتھِتَں تَتْ سَپھَلَمَبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","اَنَنْتَرَں ہیرودْ جْیوتِرْوِدْبھِراتْمانَں پْرَوَنْچِتَں وِجْنایَ بھرِشَں چُکوپَ؛ اَپَرَں جْیوتِرْوِّدْبھْیَسْتینَ وِنِشْچِتَں یَدْ دِنَں تَدِّنادْ گَنَیِتْوا دْوِتِییَوَتْسَرَں پْرَوِشْٹا یاوَنْتو بالَکا اَسْمِنْ بَیتْلیہَمْنَگَرے تَتْسِیمَمَدھْیے چاسَنْ، لوکانْ پْرَہِتْیَ تانْ سَرْوّانْ گھاتَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","اَتَح اَنیکَسْیَ وِلاپَسْیَ نِنادَ: کْرَنْدَنَسْیَ چَ۔ شوکینَ کرِتَشَبْدَشْچَ رامایاں سَںنِشَمْیَتے۔ سْوَبالَگَنَہیتورْوَے راہیلْ نارِی تُ رودِنِی۔ نَ مَنْیَتے پْرَبودھَنْتُ یَتَسْتے نَیوَ مَنْتِ ہِ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","یَدیتَدْ وَچَنَں یِرِیمِیَنامَکَبھَوِشْیَدْوادِنا کَتھِتَں تَتْ تَدانِیں سَپھَلَمْ اَبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","تَدَنَنْتَرَں ہیریدِ راجَنِ مرِتے پَرَمیشْوَرَسْیَ دُوتو مِسَرْدیشے سْوَپْنے دَرْشَنَں دَتّوا یُوشَپھے کَتھِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","تْوَمْ اُتّھایَ شِشُں تَنْماتَرَنْچَ گرِہِیتْوا پُنَرَپِیسْراییلو دیشَں یاہِی، یے جَناح شِشُں ناشَیِتُمْ اَمرِگَیَنْتَ، تے مرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","تَدانِیں سَ اُتّھایَ شِشُں تَنْماتَرَنْچَ گرِہْلَنْ اِسْراییلْدیشَمْ آجَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","کِنْتُ یِہُودِییَدیشے اَرْکھِلایَنامَ راجَکُمارو نِجَپِتُ رْہیرودَح پَدَں پْراپْیَ راجَتْوَں کَروتِیتِ نِشَمْیَ تَتْ سْتھانَں یاتُں شَنْکِتَوانْ، پَشْچاتْ سْوَپْنَ اِیشْوَراتْ پْرَبودھَں پْراپْیَ گالِیلْدیشَسْیَ پْرَدیشَیکَں پْرَسْتھایَ ناسَرَنّامَ نَگَرَں گَتْوا تَتْرَ نْیُشِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","تینَ تَں ناسَرَتِییَں کَتھَیِشْیَنْتِ، یَدیتَدْواکْیَں بھَوِشْیَدْوادِبھِرُکْتَّں تَتْ سَپھَلَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","تَدانوں یوہْنّاما مَجَّیِتا یِہُودِییَدیشَسْیَ پْرانْتَرَمْ اُپَسْتھایَ پْرَچارَیَنْ کَتھَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","مَناںسِ پَراوَرْتَّیَتَ، سْوَرْگِییَراجَتْوَں سَمِیپَماگَتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","پَرَمیشَسْیَ پَنْتھانَں پَرِشْکُرُتَ سَرْوَّتَح۔ تَسْیَ راجَپَتھاںشْچَیوَ سَمِیکُرُتَ سَرْوَّتھا۔ اِتْییتَتْ پْرانْتَرے واکْیَں وَدَتَح کَسْیَچِدْ رَوَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ایتَدْوَچَنَں یِشَیِیَبھَوِشْیَدْوادِنا یوہَنَمُدِّشْیَ بھاشِتَمْ۔ یوہَنو وَسَنَں مَہانْگَرومَجَں تَسْیَ کَٹَو چَرْمَّکَٹِبَنْدھَنَں؛ سَ چَ شُوکَکِیٹانْ مَدھُ چَ بھُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","تَدانِیں یِرُوشالَمْنَگَرَنِواسِنَح سَرْوّے یِہُودِدیشِییا یَرْدَّنْتَٹِنْیا اُبھَیَتَٹَسْتھاشْچَ مانَوا بَہِراگَتْیَ تَسْیَ سَمِیپی ");
INSERT INTO sanurd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","سْوِییَں سْوِییَں دُرِتَمْ اَنْگِیکرِتْیَ تَسْیاں یَرْدَّنِ تینَ مَجِّتا بَبھُووُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","اَپَرَں بَہُونْ پھِرُوشِنَح سِدُوکِنَشْچَ مَنُجانْ مَںکْتُں سْوَسَمِیپَمْ آگَچّھتو وِلوکْیَ سَ تانْ اَبھِدَدھَو، رے رے بھُجَگَوَںشا آگامِینَح کوپاتْ پَلایِتُں یُشْمانْ کَشْچیتِتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","مَنَحپَراوَرْتَّنَسْیَ سَمُچِتَں پھَلَں پھَلَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","کِنْتْوَسْماکَں تاتَ اِبْراہِیمْ اَسْتِیتِ سْویشُ مَنَحسُ چِینْتَیَنْتو ما وْیاہَرَتَ۔ یَتو یُشْمانْ اَہَں وَدامِ، اِیشْوَرَ ایتیبھْیَح پاشانیبھْیَ اِبْراہِیمَح سَنْتانانْ اُتْپادَیِتُں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","اَپَرَں پادَپاناں مُولے کُٹھارَ اِدانِیمَپِ لَگَنْ آسْتے، تَسْمادْ یَسْمِنْ پادَپے اُتَّمَں پھَلَں نَ بھَوَتِ، سَ کرِتّو مَدھْیےگْنِں نِکْشیپْسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","اَپَرَمْ اَہَں مَنَحپَراوَرْتَّنَسُوچَکینَ مَجَّنینَ یُشْمانْ مَجَّیامِیتِ سَتْیَں، کِنْتُ مَمَ پَشْچادْ یَ آگَچّھَتِ، سَ مَتّوپِ مَہانْ، اَہَں تَدِییوپانَہَو ووڈھُمَپِ نَہِ یوگْیوسْمِ، سَ یُشْمانْ وَہْنِرُوپے پَوِتْرَ آتْمَنِ سَںمَجَّیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","تَسْیَ کارے سُورْپَ آسْتے، سَ سْوِییَشَسْیانِ سَمْیَکْ پْرَسْپھوٹْیَ نِجانْ سَکَلَگودھُومانْ سَںگرِہْیَ بھانْڈاگارے سْتھاپَیِشْیَتِ، کِںنْتُ سَرْوّانِ وُشانْیَنِرْوّانَوَہْنِنا داہَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","اَنَنْتَرَں یِیشُ رْیوہَنا مَجِّتو بھَوِتُں گالِیلْپْرَدیشادْ یَرْدَّنِ تَسْیَ سَمِیپَمْ آجَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","کِنْتُ یوہَنْ تَں نِشِدھْیَ بَبھاشے، تْوَں کِں مَمَ سَمِیپَمْ آگَچّھَسِ؟ وَرَں تْوَیا مَجَّنَں مَمَ پْرَیوجَنَمْ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","تَدانِیں یِیشُح پْرَتْیَووچَتْ؛ اِیدانِیمْ اَنُمَنْیَسْوَ، یَتَ اِتّھَں سَرْوَّدھَرْمَّسادھَنَمْ اَسْماکَں کَرْتَّوْیَں، تَتَح سونْوَمَنْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","اَنَنْتَرَں یِیشُرَمَّسِ مَجِّتُح سَنْ تَتْکْشَناتْ تویَمَدھْیادْ اُتّھایَ جَگامَ، تَدا جِیمُوتَدْوارے مُکْتے جاتے، سَ اِیشْوَرَسْیاتْمانَں کَپوتَوَدْ اَوَرُہْیَ سْووپَرْیّاگَچّھَنْتَں وِیکْشانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","اَپَرَمْ ایشَ مَمَ پْرِیَح پُتْرَ ایتَسْمِنّیوَ مَمَ مَہاسَنْتوشَ ایتادرِشِی وْیومَجا واگْ بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","تَتَح پَرَں یِیشُح پْرَتارَکینَ پَرِیکْشِتو بھَوِتُمْ آتْمَنا پْرانْتَرَمْ آکرِشْٹَح ");
INSERT INTO sanurd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","سَنْ چَتْوارِںشَدَہوراتْرانْ اَناہارَسْتِشْٹھَنْ کْشُدھِتو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","تَدانِیں پَرِیکْشِتا تَتْسَمِیپَمْ آگَتْیَ وْیاہرِتَوانْ، یَدِ تْوَمِیشْوَراتْمَجو بھَویسْتَرْہْیاجْنَیا پاشانانیتانْ پُوپانْ وِدھیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","تَتَح سَ پْرَتْیَبْرَوِیتْ، اِتّھَں لِکھِتَماسْتے، \"مَنُجَح کیوَلَپُوپینَ نَ جِیوِشْیَتِ، کِنْتْوِیشْوَرَسْیَ وَدَنادْ یانِ یانِ وَچاںسِ نِحسَرَنْتِ تَیریوَ جِیوِشْیَتِ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","تَدا پْرَتارَکَسْتَں پُنْیَنَگَرَں نِیتْوا مَنْدِرَسْیَ چُوڈوپَرِ نِدھایَ گَدِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","تْوَں یَدِشْوَرَسْیَ تَنَیو بھَویسْتَرْہِیتودھَح پَتَ، یَتَ اِتّھَں لِکھِتَماسْتے، آدیکْشْیَتِ نِجانْ دُوتانْ رَکْشِتُں تْواں پَرَمیشْوَرَح۔ یَتھا سَرْوّیشُ مارْگیشُ تْوَدِییَچَرَنَدْوَیے۔ نَ لَگیتْ پْرَسْتَراگھاتَسْتْواں گھَرِشْیَنْتِ تے کَرَیح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","تَدانِیں یِیشُسْتَسْمَے کَتھِتَوانْ ایتَدَپِ لِکھِتَماسْتے، \"تْوَں نِجَپْرَبھُں پَرَمیشْوَرَں ما پَرِیکْشَسْوَ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","اَنَنْتَرَں پْرَتارَکَح پُنَرَپِ تَمْ اَتْیُنْچَدھَرادھَروپَرِ نِیتْوا جَگَتَح سَکَلَراجْیانِ تَدَیشْوَرْیّانِ چَ دَرْشَیاشْچَکارَ کَتھَیانْچَکارَ چَ، ");
INSERT INTO sanurd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","یَدِ تْوَں دَنْڈَوَدْ بھَوَنْ ماں پْرَنَمیسْتَرْہْیَہَمْ ایتانِ تُبھْیَں پْرَداسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","تَدانِیں یِیشُسْتَمَووچَتْ، دُورِیبھَوَ پْرَتارَکَ، لِکھِتَمِدَمْ آسْتے، \"تْوَیا نِجَح پْرَبھُح پَرَمیشْوَرَح پْرَنَمْیَح کیوَلَح سَ سیوْیَشْچَ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","تَتَح پْرَتارَکینَ سَ پَرْیَّتْیاجِ، تَدا سْوَرْگِییَدُوتَیراگَتْیَ سَ سِشیوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","تَدَنَنْتَرَں یوہَنْ کارایاں بَبَنْدھے، تَدْوارْتّاں نِشَمْیَ یِیشُنا گالِیلْ پْراسْتھِییَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","تَتَح پَرَں سَ ناسَرَنَّگَرَں وِہایَ جَلَگھیسْتَٹے سِبُولُونَّپْتالِی ایتَیورُوَبھَیوح پْرَدیشَیوح سِیمْنورْمَدھْیَوَرْتِّی یَ: کَپھَرْناہُومْ تَنَّگَرَمْ اِتْوا نْیَوَسَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","تَسْماتْ، اَنْیادیشِییَگالِیلِ یَرْدَّنْپارےبْدھِرودھَسِ۔ نَپْتالِسِبُولُونْدیشَو یَتْرَ سْتھانے سْتھِتَو پُرا۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","تَتْرَتْیا مَنُجا یے یے پَرْیَّبھْرامْیَنْ تَمِسْرَکے۔ تَیرْجَنَیرْبرِہَدالوکَح پَرِدَرْشِشْیَتے تَدا۔ اَوَسَنْ یے جَنا دیشے مرِتْیُچّھایاسْوَرُوپَکے۔ تیشامُپَرِ لوکانامالوکَح سَںپْرَکاشِتَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","یَدیتَدْوَچَنَں یِشَیِیَبھَوِشْیَدْوادِنا پْروکْتَں، تَتْ تَدا سَپھَلَمْ اَبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","اَنَنْتَرَں یِیشُح سُسَںوادَں پْرَچارَیَنْ ایتاں کَتھاں کَتھَیِتُمْ آریبھے، مَناںسِ پَراوَرْتَّیَتَ، سْوَرْگِییَراجَتْوَں سَوِدھَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","تَتَح پَرَں یِیشُ رْگالِیلو جَلَدھیسْتَٹینَ گَچّھَنْ گَچّھَنْ آنْدْرِیَسْتَسْیَ بھْراتا شِمونْ اَرْتھَتو یَں پِتَرَں وَدَنْتِ ایتاوُبھَو جَلَگھَو جالَں کْشِپَنْتَو دَدَرْشَ، یَتَسْتَو مِینَدھارِناواسْتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","تَدا سَ تاواہُویَ وْیاجَہارَ، یُواں مَمَ پَشْچادْ آگَچّھَتَں، یُوامَہَں مَنُجَدھارِنَو کَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","تینَیوَ تَو جالَں وِہایَ تَسْیَ پَشْچاتْ آگَچّھَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","اَنَنْتَرَں تَسْماتْ سْتھاناتْ وْرَجَنْ وْرَجَنْ سِوَدِیَسْیَ سُتَو یاکُوبْ یوہَنّامانَو دْوَو سَہَجَو تاتینَ سارْدّھَں نَوکوپَرِ جالَسْیَ جِیرْنودّھارَں کُرْوَّنْتَو وِیکْشْیَ تاواہُوتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","تَتْکْشَناتْ تَو ناوَں سْوَتاتَنْچَ وِہایَ تَسْیَ پَشْچادْگامِنَو بَبھُووَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","اَنَنْتَرَں بھَجَنَبھَوَنے سَمُپَدِشَنْ راجْیَسْیَ سُسَںوادَں پْرَچارَیَنْ مَنُجاناں سَرْوَّپْرَکارانْ روگانْ سَرْوَّپْرَکارَپِیڈاشْچَ شَمَیَنْ یِیشُح کرِتْسْنَں گالِیلْدیشَں بھْرَمِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","تینَ کرِتْسْنَسُرِیادیشَسْیَ مَدھْیَں تَسْیَ یَشو وْیاپْنوتْ، اَپَرَں بھُوتَگْرَسْتا اَپَسْمارَرْگِینَح پَکْشادھاتِپْرَبھرِتَیَشْچَ یاوَنْتو مَنُجا ناناوِدھَوْیادھِبھِح کْلِشْٹا آسَنْ، تیشُ سَرْوّیشُ تَسْیَ سَمِیپَمْ آنِیتیشُ سَ تانْ سْوَسْتھانْ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ایتینَ گالِیلْ-دِکاپَنِ-یِرُوشالَمْ-یِہُودِییَدیشیبھْیو یَرْدَّنَح پارانْچَ بَہَوو مَنُجاسْتَسْیَ پَشْچادْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","اَنَنْتَرَں سَ جَنَنِوَہَں نِرِیکْشْیَ بھُودھَروپَرِ وْرَجِتْوا سَمُپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","تَدانِیں شِشْییشُ تَسْیَ سَمِیپَماگَتیشُ تینَ تیبھْیَ ایشا کَتھا کَتھْیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","اَبھِمانَہِینا جَنا دھَنْیاح، یَتَسْتے سْوَرْگِییَراجْیَمْ اَدھِکَرِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","کھِدْیَمانا مَنُجا دھَنْیاح، یَسْماتْ تے سانْتْوَناں پْراپْسَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","نَمْرا مانَواشْچَ دھَنْیاح، یَسْماتْ تے میدِنِیمْ اَدھِکَرِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","دھَرْمّایَ بُبھُکْشِتاح ترِشارْتّاشْچَ مَنُجا دھَنْیاح، یَسْماتْ تے پَرِتَرْپْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","کرِپالَوو مانَوا دھَنْیاح، یَسْماتْ تے کرِپاں پْراپْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","نِرْمَّلَہرِدَیا مَنُجاشْچَ دھَنْیاح، یَسْماتْ تَ اِیشْچَرَں دْرَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","میلَیِتارو مانَوا دھَنْیاح، یَسْماتْ تَ اِیشْچَرَسْیَ سَنْتانَتْوینَ وِکھْیاسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","دھَرْمَّکارَناتْ تاڈِتا مَنُجا دھَنْیا، یَسْماتْ سْوَرْگِییَراجْیے تیشامَدھِکَرو وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","یَدا مَنُجا مَمَ نامَکرِتے یُشْمانْ نِنْدَنْتِ تاڈَیَنْتِ مرِشا نانادُرْوّاکْیانِ وَدَنْتِ چَ، تَدا یُیَں دھَنْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","تَدا آنَنْدَتَ، تَتھا بھرِشَں ہْلادَدھْوَنْچَ، یَتَح سْوَرْگے بھُویاںسِ پھَلانِ لَپْسْیَدھْوے؛ تے یُشْماکَں پُراتَنانْ بھَوِشْیَدْوادِنوپِ تادرِگْ اَتاڈَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","یُیَں میدِنْیاں لَوَنَرُوپاح، کِنْتُ یَدِ لَوَنَسْیَ لَوَنَتْوَمْ اَپَیاتِ، تَرْہِ تَتْ کینَ پْرَکارینَ سْوادُیُکْتَں بھَوِشْیَتِ؟ تَتْ کَسْیاپِ کارْیَّسْیایوگْیَتْواتْ کیوَلَں بَہِح پْرَکْشیپْتُں نَراناں پَدَتَلینَ دَلَیِتُنْچَ یوگْیَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","یُویَں جَگَتِ دِیپْتِرُوپاح، بھُودھَروپَرِ سْتھِتَں نَگَرَں گُپْتَں بھَوِتُں نَہِ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","اَپَرَں مَنُجاح پْرَدِیپانْ پْرَجْوالْیَ دْرونادھو نَ سْتھاپَیَنْتِ، کِنْتُ دِیپادھاروپَرْیّیوَ سْتھاپَیَنْتِ، تینَ تے دِیپا گیہَسْتھِتانْ سَکَلانْ پْرَکاشَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","یینَ مانَوا یُشْماکَں سَتْکَرْمّانِ وِلوکْیَ یُشْماکَں سْوَرْگَسْتھَں پِتَرَں دھَنْیَں وَدَنْتِ، تیشاں سَمَکْشَں یُشْماکَں دِیپْتِسْتادرِکْ پْرَکاشَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","اَہَں وْیَوَسْتھاں بھَوِشْیَدْواکْیَنْچَ لوپْتُمْ آگَتَوانْ، اِتّھَں مانُبھَوَتَ، تے دْوے لوپْتُں ناگَتَوانْ، کِنْتُ سَپھَلے کَرْتُّمْ آگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","اَپَرَں یُشْمانْ اَہَں تَتھْیَں وَدامِ یاوَتْ وْیومَمیدِنْیو رْدھْوَںسو نَ بھَوِشْیَتِ، تاوَتْ سَرْوَّسْمِنْ سَپھَلے نَ جاتے وْیَوَسْتھایا ایکا ماتْرا بِنْدُریکوپِ وا نَ لوپْسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","تَسْماتْ یو جَنَ ایتاسامْ آجْنانامْ اَتِکْشُدْرامْ ایکاجْنامَپِی لَںگھَتے مَنُجاںنْچَ تَتھَیوَ شِکْشَیَتِ، سَ سْوَرْگِییَراجْیے سَرْوّیبھْیَح کْشُدْرَتْوینَ وِکھْیاسْیَتے، کِنْتُ یو جَنَسْتاں پالَیَتِ، تَتھَیوَ شِکْشَیَتِ چَ، سَ سْوَرْگِییَراجْیے پْرَدھانَتْوینَ وِکھْیاسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","اَپَرَں یُشْمانْ اَہَں وَدامِ، اَدھْیاپَکَپھِرُوشِمانَواناں دھَرْمّانُشْٹھاناتْ یُشْماکَں دھَرْمّانُشْٹھانے نوتَّمے جاتے یُویَمْ اِیشْوَرِییَراجْیَں پْرَویشْٹُں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","اَپَرَنْچَ تْوَں نَرَں ما وَدھِیح، یَسْماتْ یو نَرَں ہَنْتِ، سَ وِچارَسَبھایاں دَنْڈارْہو بھَوِشْیَتِ، پُورْوَّکالِینَجَنیبھْیَ اِتِ کَتھِتَماسِیتْ، یُشْمابھِرَشْراوِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","کِنْتْوَہَں یُشْمانْ وَدامِ، یَح کَشْچِتْ کارَنَں وِنا نِجَبھْراتْرے کُپْیَتِ، سَ وِچارَسَبھایاں دَنْڈارْہو بھَوِشْیَتِ؛ یَح کَشْچِچَّ سْوِییَسَہَجَں نِرْبّودھَں وَدَتِ، سَ مَہاسَبھایاں دَنْڈارْہو بھَوِشْیَتِ؛ پُنَشْچَ تْوَں مُوڈھَ اِتِ واکْیَں یَدِ کَشْچِتْ سْوِییَبھْراتَرَں وَکْتِ، تَرْہِ نَرَکاگْنَو سَ دَنْڈارْہو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","اَتو ویدْیاح سَمِیپَں نِجَنَیویدْیے سَمانِیتےپِ نِجَبھْراتَرَں پْرَتِ کَسْماچِّتْ کارَناتْ تْوَں یَدِ دوشِی وِدْیَسے، تَدانِیں تَوَ تَسْیَ سْمرِتِ رْجایَتے چَ، ");
INSERT INTO sanurd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","تَرْہِ تَسْیا ویدْیاح سَمِیپے نِجَنَیوَیدْیَں نِدھایَ تَدَیوَ گَتْوا پُورْوَّں تینَ سارْدّھَں مِلَ، پَشْچاتْ آگَتْیَ نِجَنَیویدْیَں نِویدَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","اَنْیَنْچَ یاوَتْ وِوادِنا سارْدّھَں وَرْتْمَنِ تِشْٹھَسِ، تاوَتْ تینَ سارْدّھَں میلَنَں کُرُ؛ نو چیتْ وِوادِی وِچارَیِتُح سَمِیپے تْواں سَمَرْپَیَتِ وِچارَیِتا چَ رَکْشِنَح سَنِّدھَو سَمَرْپَیَتِ تَدا تْوَں کارایاں بَدھْییتھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","تَرْہِ تْوامَہَں تَتھْتھَں بْرَوِیمِ، شیشَکَپَرْدَکےپِ نَ پَرِشودھِتے تَسْماتْ سْتھاناتْ کَداپِ بَہِراگَنْتُں نَ شَکْشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","اَپَرَں تْوَں ما وْیَبھِچَرَ، یَدیتَدْ وَچَنَں پُورْوَّکالِینَلوکیبھْیَح کَتھِتَماسِیتْ، تَدْ یُویَں شْرُتَوَنْتَح؛ ");
INSERT INTO sanurd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","کِنْتْوَہَں یُشْمانْ وَدامِ، یَدِ کَشْچِتْ کامَتَح کانْچَنَ یوشِتَں پَشْیَتِ، تَرْہِ سَ مَنَسا تَدَیوَ وْیَبھِچَرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","تَسْماتْ تَوَ دَکْشِنَں نیتْرَں یَدِ تْواں بادھَتے، تَرْہِ تَنّیتْرَمْ اُتْپاٹْیَ دُورے نِکْشِپَ، یَسْماتْ تَوَ سَرْوَّوَپُشو نَرَکے نِکْشیپاتْ تَوَیکانْگَسْیَ ناشو وَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","یَدْوا تَوَ دَکْشِنَح کَرو یَدِ تْواں بادھَتے، تَرْہِ تَں کَرَں چھِتّوا دُورے نِکْشِپَ، یَتَح سَرْوَّوَپُشو نَرَکے نِکْشیپاتْ ایکانْگَسْیَ ناشو وَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","اُکْتَماسْتے، یَدِ کَشْچِنْ نِجَجایاں پَرِتْیَکْتُّمْ اِچّھَتِ، تَرْہِ سَ تَسْیَے تْیاگَپَتْرَں دَداتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","کِنْتْوَہَں یُشْمانْ وْیاہَرامِ، وْیَبھِچارَدوشے نَ جاتے یَدِ کَشْچِنْ نِجَجایاں پَرِتْیَجَتِ، تَرْہِ سَ تاں وْیَبھِچارَیَتِ؛ یَشْچَ تاں تْیَکْتاں سْتْرِیَں وِوَہَتِ، سوپِ وْیَبھِچَرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","پُنَشْچَ تْوَں مرِشا شَپَتھَمْ نَ کُرْوَّنْ اِیشْچَرایَ نِجَشَپَتھَں پالَیَ، پُورْوَّکالِینَلوکیبھْیو یَیشا کَتھا کَتھِتا، تامَپِ یُویَں شْرُتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","کِنْتْوَہَں یُشْمانْ وَدامِ، کَمَپِ شَپَتھَں ما کارْشْٹَ، اَرْتھَتَح سْوَرْگَنامْنا نَ، یَتَح سَ اِیشْوَرَسْیَ سِںہاسَنَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","پرِتھِوْیا نامْناپِ نَ، یَتَح سا تَسْیَ پادَپِیٹھَں؛ یِرُوشالَمو نامْناپِ نَ، یَتَح سا مَہاراجَسْیَ پُرِی؛ ");
INSERT INTO sanurd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","نِجَشِرونامْناپِ نَ، یَسْماتْ تَسْیَیکَں کَچَمَپِ سِتَمْ اَسِتَں وا کَرْتُّں تْوَیا نَ شَکْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","اَپَرَں یُویَں سَںلاپَسَمَیے کیوَلَں بھَوَتِیتِ نَ بھَوَتِیتِ چَ وَدَتَ یَتَ اِتودھِکَں یَتْ تَتْ پاپاتْمَنو جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","اَپَرَں لوچَنَسْیَ وِنِمَیینَ لوچَنَں دَنْتَسْیَ وِنِمَیینَ دَنْتَح پُورْوَّکْتَمِدَں وَچَنَنْچَ یُشْمابھِرَشْرُویَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","کِنْتْوَہَں یُشْمانْ وَدامِ یُویَں ہِںسَکَں نَرَں ما وْیاگھاتَیَتَ۔ کِنْتُ کینَچِتْ تَوَ دَکْشِنَکَپولے چَپیٹاگھاتے کرِتے تَں پْرَتِ وامَں کَپولَنْچَ وْیاگھوٹَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","اَپَرَں کینَچِتْ تْوَیا سارْدھْدَں وِوادَں کرِتْوا تَوَ پَرِدھییَوَسَنے جِگھرِتِتے تَسْمایُتَّرِییَوَسَنَمَپِ دیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","یَدِ کَشْچِتْ تْواں کْروشَمیکَں نَیَنارْتھَں اَنْیایَتو دھَرَتِ، تَدا تینَ سارْدھْدَں کْروشَدْوَیَں یاہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","یَشْچَ مانَوَسْتْواں یاچَتے، تَسْمَے دیہِ، یَدِ کَشْچِتْ تُبھْیَں دھارَیِتُمْ اِچّھَتِ، تَرْہِ تَں پْرَتِ پَراںمُکھو ما بھُوح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","نِجَسَمِیپَوَسِنِ پْریمَ کُرُ، کِنْتُ شَتْرُں پْرَتِ دْویشَں کُرُ، یَدیتَتْ پُروکْتَں وَچَنَں ایتَدَپِ یُویَں شْرُتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","کِنْتْوَہَں یُشْمانْ وَدامِ، یُویَں رِپُوَّپِ پْریمَ کُرُتَ، یے چَ یُشْمانْ شَپَنْتے، تانَ، آشِشَں وَدَتَ، یے چَ یُشْمانْ رِृتِییَنْتے، تیشاں مَنْگَلَں کُرُتَ، یے چَ یُشْمانْ نِنْدَنْتِ، تاڈَیَنْتِ چَ، تیشاں کرِتے پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","تَتْرَ یَح سَتامَسَتانْچوپَرِ پْرَبھاکَرَمْ اُدایَیَتِ، تَتھا دھارْمِّکانامَدھارْمِّکانانْچوپَرِ نِیرَں وَرْشَیَتِ تادرِشو یو یُشْماکَں سْوَرْگَسْتھَح پِتا، یُویَں تَسْیَیوَ سَنْتانا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","یے یُشْماسُ پْریمَ کُرْوَّنْتِ، یُویَں یَدِ کیوَلَں تیوّیوَ پْریمَ کُرُتھَ، تَرْہِ یُشْماکَں کِں پھَلَں بھَوِشْیَتِ؟ چَنْڈالا اَپِ تادرِشَں کِں نَ کُرْوَّنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","اَپَرَں یُویَں یَدِ کیوَلَں سْوِییَبھْراترِتْوینَ نَمَتَ، تَرْہِ کِں مَہَتْ کَرْمَّ کُرُتھَ؟ چَنْڈالا اَپِ تادرِشَں کِں نَ کُرْوَّنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","تَسْماتْ یُشْماکَں سْوَرْگَسْتھَح پِتا یَتھا پُورْنو بھَوَتِ، یُویَمَپِ تادرِشا بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ساوَدھانا بھَوَتَ، مَنُجانْ دَرْشَیِتُں تیشاں گوچَرے دھَرْمَّکَرْمَّ ما کُرُتَ، تَتھا کرِتے یُشْماکَں سْوَرْگَسْتھَپِتُح سَکاشاتْ کِنْچَنَ پھَلَں نَ پْراپْسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","تْوَں یَدا دَداسِ تَدا کَپَٹِنو جَنا یَتھا مَنُجیبھْیَح پْرَشَںساں پْراپْتُں بھَجَنَبھَوَنے راجَمارْگے چَ تُورِیں وادَیَنْتِ، تَتھا ما کُرِु، اَہَں تُبھْیَں یَتھارْتھَں کَتھَیامِ، تے سْوَکایَں پھَلَمْ اَلَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","کِنْتُ تْوَں یَدا دَداسِ، تَدا نِجَدَکْشِنَکَرو یَتْ کَروتِ، تَدْ وامَکَرَں ما جْناپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","تینَ تَوَ دانَں گُپْتَں بھَوِشْیَتِ یَسْتُ تَوَ پِتا گُپْتَدَرْشِی، سَ پْرَکاشْیَ تُبھْیَں پھَلَں داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","اَپَرَں یَدا پْرارْتھَیَسے، تَدا کَپَٹِنَاِوَ ما کُرُ، یَسْماتْ تے بھَجَنَبھَوَنے راجَمارْگَسْیَ کونے تِشْٹھَنْتو لوکانْ دَرْشَیَنْتَح پْرارْتھَیِتُں پْرِییَنْتے؛ اَہَں یُشْمانْ تَتھْیَں وَدامِ، تے سْوَکِییَپھَلَں پْراپْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","تَسْماتْ پْرارْتھَناکالے اَنْتَراگارَں پْرَوِشْیَ دْوارَں رُدْوّا گُپْتَں پَشْیَتَسْتَوَ پِتُح سَمِیپے پْرارْتھَیَسْوَ؛ تینَ تَوَ یَح پِتا گُپْتَدَرْشِی، سَ پْرَکاشْیَ تُبھْیَں پھَلَں داسْیَتِl ");
INSERT INTO sanurd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","اَپَرَں پْرارْتھَناکالے دیوَپُوجَکااِوَ مُدھا پُنَرُکْتِں ما کُرُ، یَسْماتْ تے بودھَنْتے، بَہُوارَں کَتھایاں کَتھِتایاں تیشاں پْرارْتھَنا گْراہِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","یُویَں تیشامِوَ ما کُرُتَ، یَسْماتْ یُشْماکَں یَدْ یَتْ پْرَیوجَنَں یاچَناتَح پْراگیوَ یُشْماکَں پِتا تَتْ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","اَتَایوَ یُویَمَ اِیدرِکْ پْرارْتھَیَدھْوَں، ہے اَسْماکَں سْوَرْگَسْتھَپِتَح، تَوَ نامَ پُوجْیَں بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","تَوَ راجَتْوَں بھَوَتُ؛ تَویچّھا سْوَرْگے یَتھا تَتھَیوَ میدِنْیامَپِ سَپھَلا بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","اَسْماکَں پْرَیوجَنِییَمْ آہارَمْ اَدْیَ دیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","وَیَں یَتھا نِجاپَرادھِنَح کْشَمامَہے، تَتھَیواسْماکَمْ اَپَرادھانْ کْشَمَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","اَسْمانْ پَرِیکْشاں مانَیَ، کِنْتُ پاپاتْمَنو رَکْشَ؛ راجَتْوَں گَورَوَں پَراکْرَمَح ایتے سَرْوّے سَرْوَّدا تَوَ؛ تَتھاسْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","یَدِ یُویَمْ اَنْییشامْ اَپَرادھانْ کْشَمَدھْوے تَرْہِ یُشْماکَں سْوَرْگَسْتھَپِتاپِ یُشْمانْ کْشَمِشْیَتے؛ ");
INSERT INTO sanurd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","کِنْتُ یَدِ یُویَمْ اَنْییشامْ اَپَرادھانْ نَ کْشَمَدھْوے، تَرْہِ یُشْماکَں جَنَکوپِ یُشْماکَمْ اَپَرادھانْ نَ کْشَمِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","اَپَرَمْ اُپَواسَکالے کَپَٹِنو جَنا مانُشانْ اُپَواسَں جْناپَیِتُں سْویشاں وَدَنانِ مْلانانِ کُرْوَّنْتِ، یُویَں تَاِوَ وِشَنَوَدَنا ما بھَوَتَ؛ اَہَں یُشْمانْ تَتھْیَں وَدامِ تے سْوَکِییَپھَلَمْ اَلَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","یَدا تْوَمْ اُپَوَسَسِ، تَدا یَتھا لوکَیسْتْوَں اُپَواسِیوَ نَ درِشْیَسے، کِنْتُ تَوَ یوگوچَرَح پِتا تینَیوَ درِشْیَسے، تَتْکرِتے نِجَشِرَسِ تَیلَں مَرْدَّیَ وَدَنَنْچَ پْرَکْشالَیَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","تینَ تَوَ یَح پِتا گُپْتَدَرْشِی سَ پْرَکاشْیَ تُبھْیَں پھَلَں داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","اَپَرَں یَتْرَ سْتھانے کِیٹاح کَلَنْکاشْچَ کْشَیَں نَیَنْتِ، چَوراشْچَ سَنْدھِں کَرْتَّیِتْوا چورَیِتُں شَکْنُوَنْتِ، تادرِشْیاں میدِنْیاں سْوارْتھَں دھَنَں ما سَںچِنُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","کِنْتُ یَتْرَ سْتھانے کِیٹاح کَلَنْکاشْچَ کْشَیَں نَ نَیَنْتِ، چَوراشْچَ سَنْدھِں کَرْتَّیِتْوا چورَیِتُں نَ شَکْنُوَنْتِ، تادرِشے سْوَرْگے دھَنَں سَنْچِنُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","یَسْماتْ یَتْرَ سْتھانے یُشْماںکَ دھَنَں تَتْرَیوَ کھانے یُشْماکَں مَناںسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","لوچَنَں دیہَسْیَ پْرَدِیپَکَں، تَسْماتْ یَدِ تَوَ لوچَنَں پْرَسَنَّں بھَوَتِ، تَرْہِ تَوَ کرِتْسْنَں وَپُ رْدِیپْتِیُکْتَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","کِنْتُ لوچَنےپْرَسَنّے تَوَ کرِتْسْنَں وَپُح تَمِسْرَیُکْتَں بھَوِشْیَتِ۔ اَتَایوَ یا دِیپْتِسْتْوَیِ وِدْیَتے، سا یَدِ تَمِسْرَیُکْتا بھَوَتِ، تَرْہِ تَتْ تَمِسْرَں کِیَنْ مَہَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","کوپِ مَنُجو دْوَو پْرَبھُو سیوِتُں نَ شَکْنوتِ، یَسْمادْ ایکَں سَںمَنْیَ تَدَنْیَں نَ سَمَّنْیَتے، یَدْوا ایکَتْرَ مَنو نِدھایَ تَدَنْیَمْ اَوَمَنْیَتے؛ تَتھا یُویَمَپِیشْوَرَں لَکْشْمِینْچیتْیُبھے سیوِتُں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","اَپَرَمْ اَہَں یُشْمَبھْیَں تَتھْیَں کَتھَیامِ، کِں بھَکْشِشْیامَح؟ کِں پاسْیامَح؟ اِتِ پْرانَدھارَنایَ ما چِنْتَیَتَ؛ کِں پَرِدھاسْیامَح؟ اِتِ کایَرَکْشَنایَ نَ چِنْتَیَتَ؛ بھَکْشْیاتْ پْرانا وَسَنانْچَ وَپُوںشِ کِں شْریشْٹھانِ نَ ہِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","وِہایَسو وِہَنْگَمانْ وِلوکَیَتَ؛ تَے رْنوپْیَتے نَ کرِتْیَتے بھانْڈاگارے نَ سَنْچِییَتےپِ؛ تَتھاپِ یُشْماکَں سْوَرْگَسْتھَح پِتا تیبھْیَ آہارَں وِتَرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","یُویَں تیبھْیَح کِں شْریشْٹھا نَ بھَوَتھَ؟ یُشْماکَں کَشْچِتْ مَنُجَح چِنْتَیَنْ نِجایُشَح کْشَنَمَپِ وَرْدّھَیِتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","اَپَرَں وَسَنایَ کُتَشْچِنْتَیَتَ؟ کْشیتْروتْپَنّانِ پُشْپانِ کَتھَں وَرْدّھَنْتے تَدالوچَیَتَ۔ تانِ تَنْتُونْ نوتْپادَیَنْتِ کِمَپِ کارْیَّں نَ کُرْوَّنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","تَتھاپْیَہَں یُشْمانْ وَدامِ، سُلیمانْ تادرِگْ اَیشْوَرْیَّوانَپِ تَتْپُشْپَمِوَ وِبھُوشِتو ناسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","تَسْماتْ کْشَدْیَ وِدْیَمانَں شْچَح چُلّیاں نِکْشیپْسْیَتے تادرِشَں یَتْ کْشیتْرَسْتھِتَں کُسُمَں تَتْ یَدِیشْچَرَ اِتّھَں بِبھُوشَیَتِ، تَرْہِ ہے سْتوکَپْرَتْیَیِنو یُشْمانْ کِں نَ پَرِدھاپَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","تَسْماتْ اَسْمابھِح کِمَتْسْیَتے؟ کِنْچَ پایِشْیَتے؟ کِں وا پَرِدھایِشْیَتے، اِتِ نَ چِنْتَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","یَسْماتْ دیوارْچَّکا اَپِیتِ چیشْٹَنْتے؛ ایتیشُ دْرَوْییشُ پْرَیوجَنَمَسْتِیتِ یُشْماکَں سْوَرْگَسْتھَح پِتا جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","اَتَایوَ پْرَتھَمَتَ اِیشْوَرِییَراجْیَں دھَرْمَّنْچَ چیشْٹَدھْوَں، تَتَ ایتانِ وَسْتُونِ یُشْمَبھْیَں پْرَدایِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","شْوَح کرِتے ما چِنْتَیَتَ، شْوَایوَ سْوَیَں سْوَمُدِّشْیَ چِنْتَیِشْیَتِ؛ اَدْیَتَنِی یا چِنْتا سادْیَکرِتے پْرَچُرَتَرا۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","یَتھا یُویَں دوشِیکرِتا نَ بھَوَتھَ، تَتْکرِتےنْیَں دوشِنَں ما کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","یَتو یادرِشینَ دوشینَ یُویَں پَرانْ دوشِنَح کُرُتھَ، تادرِشینَ دوشینَ یُویَمَپِ دوشِیکرِتا بھَوِشْیَتھَ، اَنْیَنْچَ یینَ پَرِمانینَ یُشْمابھِح پَرِمِییَتے، تینَیوَ پَرِمانینَ یُشْمَتْکرِتے پَرِمایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","اَپَرَنْچَ نِجَنَیَنے یا ناسا وِدْیَتے، تامْ اَنالوچْیَ تَوَ سَہَجَسْیَ لوچَنے یَتْ ترِنَمْ آسْتے، تَدیوَ کُتو وِیکْشَسے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","تَوَ نِجَلوچَنے ناسایاں وِدْیَمانایاں، ہے بھْراتَح، تَوَ نَیَناتْ ترِنَں بَہِشْیَرْتُں اَنُجانِیہِ، کَتھامیتاں نِجَسَہَجایَ کَتھَں کَتھَیِتُں شَکْنوشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ہے کَپَٹِنْ، آدَو نِجَنَیَناتْ ناساں بَہِشْکُرُ تَتو نِجَدرِشْٹَو سُپْرَسَنّایاں تَوَ بھْراترِ رْلوچَناتْ ترِنَں بَہِشْکَرْتُں شَکْشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","اَنْیَنْچَ سارَمیییبھْیَح پَوِتْرَوَسْتُونِ ما وِتَرَتَ، وَراہاناں سَمَکْشَنْچَ مُکْتا ما نِکْشِپَتَ؛ نِکْشیپَناتْ تے تاح سَرْوّاح پَدَے رْدَلَیِشْیَنْتِ، پَراورِتْیَ یُشْمانَپِ وِدارَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","یاچَدھْوَں تَتو یُشْمَبھْیَں دایِشْیَتے؛ مرِگَیَدھْوَں تَتَ اُدّیشَں لَپْسْیَدھْوے؛ دْوارَمْ آہَتَ، تَتو یُشْمَتْکرِتے مُکْتَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","یَسْمادْ یینَ یاچْیَتے، تینَ لَبھْیَتے؛ یینَ مرِگْیَتے تینودّیشَح پْراپْیَتے؛ یینَ چَ دْوارَمْ آہَنْیَتے، تَتْکرِتے دْوارَں موچْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","آتْمَجینَ پُوپے پْرارْتھِتے تَسْمَے پاشانَں وِشْرانَیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","مِینے یاچِتے چَ تَسْمَے بھُجَگَں وِتَرَتِ، ایتادرِشَح پِتا یُشْماکَں مَدھْیے کَ آسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","تَسْمادْ یُویَمْ اَبھَدْراح سَنْتوپِ یَدِ نِجَبالَکیبھْیَ اُتَّمَں دْرَوْیَں داتُں جانِیتھَ، تَرْہِ یُشْماکَں سْوَرْگَسْتھَح پِتا سْوِییَیاچَکیبھْیَح کِمُتَّمانِ وَسْتُونِ نَ داسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","یُوشْمانْ پْرَتِیتَریشاں یادرِشو وْیَوَہارو یُشْماکَں پْرِیَح، یُویَں تانْ پْرَتِ تادرِشانیوَ وْیَوَہارانْ وِدھَتَّ؛ یَسْمادْ وْیَوَسْتھابھَوِشْیَدْوادِناں وَچَنانامْ اِتِ سارَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","سَنْکِیرْنَدْوارینَ پْرَوِشَتَ؛ یَتو نَرَکَگَمَنایَ یَدْ دْوارَں تَدْ وِسْتِیرْنَں یَچَّ وَرْتْمَ تَدْ برِہَتْ تینَ بَہَوَح پْرَوِشَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","اَپَرَں سْوَرْگَگَمَنایَ یَدْ دْوارَں تَتْ کِیدرِکْ سَںکِیرْنَں۔ یَچَّ وَرْتْمَ تَتْ کِیدرِگْ دُرْگَمَمْ۔ تَدُدّیشْٹارَح کِیَنْتولْپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","اَپَرَنْچَ یے جَنا میشَویشینَ یُشْماکَں سَمِیپَمْ آگَچّھَنْتِ، کِنْتْوَنْتَرْدُرَنْتا ورِکا ایتادرِشیبھْیو بھَوِشْیَدْوادِبھْیَح ساوَدھانا بھَوَتَ، یُویَں پھَلینَ تانْ پَرِچیتُں شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","مَنُجاح کِں کَنْٹَکِنو ورِکْشادْ دْراکْشاپھَلانِ شرِگالَکولِتَشْچَ اُڈُمْبَرَپھَلانِ شاتَیَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","تَدْوَدْ اُتَّمَ ایوَ پادَپَ اُتَّمَپھَلانِ جَنَیَتِ، اَدھَمَپادَپَایوادھَمَپھَلانِ جَنَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","کِنْتُوتَّمَپادَپَح کَداپْیَدھَمَپھَلانِ جَنَیِتُں نَ شَکْنوتِ، تَتھادھَموپِ پادَپَ اُتَّمَپھَلانِ جَنَیِتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","اَپَرَں یے یے پادَپا اَدھَمَپھَلانِ جَنَیَنْتِ، تے کرِتّا وَہْنَو کْشِپْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","اَتَایوَ یُویَں پھَلینَ تانْ پَرِچیشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","یے جَنا ماں پْرَبھُں وَدَنْتِ، تے سَرْوّے سْوَرْگَراجْیَں پْرَویکْشْیَنْتِ تَنَّ، کِنْتُ یو مانَوو مَمَ سْوَرْگَسْتھَسْیَ پِتُرِشْٹَں کَرْمَّ کَروتِ سَ ایوَ پْرَویکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","تَدْ دِنے بَہَوو ماں وَدِشْیَنْتِ، ہے پْرَبھو ہے پْرَبھو، تَوَ نامْنا کِمَسْمامِ رْبھَوِشْیَدْواکْیَں نَ وْیاہرِتَں؟ تَوَ نامْنا بھُوتاح کِں نَ تْیاجِتاح؟ تَوَ نامْنا کِں نانادْبھُتانِ کَرْمّانِ نَ کرِتانِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","تَداہَں وَدِشْیامِ، ہے کُکَرْمَّکارِنو یُشْمانْ اَہَں نَ ویدْمِ، یُویَں مَتْسَمِیپادْ دُورِیبھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","یَح کَشْچِتْ مَمَیتاح کَتھاح شْرُتْوا پالَیَتِ، سَ پاشانوپَرِ گرِہَنِرْمّاتْرا جْنانِنا سَہَ مَیوپَمِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","یَتو ورِشْٹَو سَتْیامْ آپْلاوَ آگَتے وایَو واتے چَ تیشُ تَدْگیہَں لَگْنیشُ پاشانوپَرِ تَسْیَ بھِتّیسْتَنَّ پَتَتِl ");
INSERT INTO sanurd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","کِنْتُ یَح کَشْچِتْ مَمَیتاح کَتھاح شْرُتْوا نَ پالَیَتِ سَ سَیکَتے گیہَنِرْمّاتْرا جْنانِنا اُپَمِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","یَتو جَلَورِشْٹَو سَتْیامْ آپْلاوَ آگَتے پَوَنے واتے چَ تَے رْگرِہے سَماگھاتے تَتْ پَتَتِ تَتْپَتَنَں مَہَدْ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","یِیشُنَیتیشُ واکْییشُ سَماپِتیشُ مانَواسْتَدِییوپَدیشَمْ آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","یَسْماتْ سَ اُپادھْیایا اِوَ تانْ نوپَدِدیشَ کِنْتُ سَمَرْتھَپُرُشَاِوَ سَمُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","یَدا سَ پَرْوَّتادْ اَواروہَتْ تَدا بَہَوو مانَواسْتَتْپَشْچادْ وَوْرَجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ایکَح کُشْٹھَوانْ آگَتْیَ تَں پْرَنَمْیَ بَبھاشے، ہے پْرَبھو، یَدِ بھَوانْ سَںمَنْیَتے، تَرْہِ ماں نِرامَیَں کَرْتُّں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","تَتو یِیشُح کَرَں پْرَسارْیَّ تَسْیانْگَں سْپرِشَنْ وْیاجَہارَ، سَمَّنْیےہَں تْوَں نِرامَیو بھَوَ؛ تینَ سَ تَتْکْشَناتْ کُشْٹھیناموچِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","تَتو یِیشُسْتَں جَگادَ، اَوَدھیہِ کَتھامیتاں کَشْچِدَپِ ما بْرُوہِ، کِنْتُ یاجَکَسْیَ سَنِّدھِں گَتْوا سْواتْمانَں دَرْشَیَ مَنُجیبھْیو نِجَنِرامَیَتْوَں پْرَمانَیِتُں مُوسانِرُوپِتَں دْرَوْیَمْ اُتْسرِجَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","تَدَنَنْتَرَں یِیشُنا کَپھَرْناہُومْنامَنِ نَگَرے پْرَوِشْٹے کَشْچِتْ شَتَسیناپَتِسْتَتْسَمِیپَمْ آگَتْیَ وِنِییَ بَبھاشے، ");
INSERT INTO sanurd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ہے پْرَبھو، مَدِییَ ایکو داسَح پَکْشاگھاتَوْیادھِنا بھرِشَں وْیَتھِتَح، سَتُ شَیَنِییَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","تَدانِیں یِیشُسْتَسْمَے کَتھِتَوانْ، اَہَں گَتْوا تَں نِرامَیَں کَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","تَتَح سَ شَتَسیناپَتِح پْرَتْیَوَدَتْ، ہے پْرَبھو، بھَوانْ یَتْ مَمَ گیہَمَدھْیَں یاتِ تَدْیوگْیَبھاجَنَں ناہَمَسْمِ؛ وانْماتْرَمْ آدِشَتُ، تینَیوَ مَمَ داسو نِرامَیو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","یَتو مَیِ پَرَنِدھْنےپِ مَمَ نِدیشَوَشْیاح کَتِ کَتِ سیناح سَنْتِ، تَتَ ایکَسْمِنْ یاہِیتْیُکْتے سَ یاتِ، تَدَنْیَسْمِنْ ایہِیتْیُکْتے سَ آیاتِ، تَتھا مَمَ نِجَداسے کَرْمَّیتَتْ کُرْوِّتْیُکْتے سَ تَتْ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","تَدانِیں یِیشُسْتَسْیَیتَتْ وَچو نِشَمْیَ وِسْمَیاپَنّوبھُوتْ؛ نِجَپَشْچادْگامِنو مانَوانْ اَووچَّ، یُشْمانْ تَتھْیَں وَچْمِ، اِسْراییلِییَلوکاناں مَدھْیےپِ نَیتادرِشو وِشْواسو مَیا پْراپْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","اَنْیَچّاہَں یُشْمانْ وَدامِ، بَہَوَح پُورْوَّسْیاح پَشْچِمایاشْچَ دِشَ آگَتْیَ اِبْراہِیما اِسْہاکا یاکُوبا چَ ساکَمْ مِلِتْوا سَمُپَویکْشْیَنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","کِنْتُ یَتْرَ سْتھانے رودَنَدَنْتَگھَرْشَنے بھَوَتَسْتَسْمِنْ بَہِرْبھُوتَتَمِسْرے راجْیَسْیَ سَنْتانا نِکْشیسْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","تَتَح پَرَں یِیشُسْتَں شَتَسیناپَتِں جَگادَ، یاہِ، تَوَ پْرَتِیتْیَنُسارَتو مَنْگَلَں بھُویاتْ؛ تَدا تَسْمِنّیوَ دَنْڈے تَدِییَداسو نِرامَیو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","اَنَنْتَرَں یِیشُح پِتَرَسْیَ گیہَمُپَسْتھایَ جْوَرینَ پِیڈِتاں شَیَنِییَسْتھِتاں تَسْیَ شْوَشْرُوں وِیکْشانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","تَتَسْتینَ تَسْیاح کَرَسْیَ سْپرِشْٹَتَواتْ جْوَرَسْتاں تَتْیاجَ، تَدا سا سَمُتّھایَ تانْ سِشیوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","اَنَنْتَرَں سَنْدھْیایاں سَتْیاں بَہُشو بھُوتَگْرَسْتَمَنُجانْ تَسْیَ سَمِیپَمْ آنِنْیُح سَ چَ واکْیینَ بھُوتانْ تْیاجَیاماسَ، سَرْوَّپْرَکارَپِیڈِتَجَناںشْچَ نِرامَیانْ چَکارَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","تَسْماتْ، سَرْوّا دُرْبَّلَتاسْماکَں تینَیوَ پَرِدھارِتا۔ اَسْماکَں سَکَلَں وْیادھِں سَایوَ سَںگرِہِیتَوانْ۔ یَدیتَدْوَچَنَں یِشَیِیَبھَوِشْیَدْوادِنوکْتَماسِیتْ، تَتَّدا سَپھَلَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","اَنَنْتَرَں یِیشُشْچَتُرْدِکْشُ جَنَنِوَہَں وِلوکْیَ تَٹِنْیاح پارَں یاتُں شِشْیانْ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","تَدانِیمْ ایکَ اُپادھْیایَ آگَتْیَ کَتھِتَوانْ، ہے گُرو، بھَوانْ یَتْرَ یاسْیَتِ تَتْراہَمَپِ بھَوَتَح پَشْچادْ یاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","تَتو یِیشُ رْجَگادَ، کْروشْٹُح سْتھاتُں سْتھانَں وِدْیَتے، وِہایَسو وِہَنْگَماناں نِیڈانِ چَ سَنْتِ؛ کِنْتُ مَنُشْیَپُتْرَسْیَ شِرَح سْتھاپَیِتُں سْتھانَں نَ وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","اَنَنْتَرَمْ اَپَرَ ایکَح شِشْیَسْتَں بَبھاشے، ہے پْرَبھو، پْرَتھَمَتو مَمَ پِتَرَں شْمَشانے نِدھاتُں گَمَنارْتھَں مامْ اَنُمَنْیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","تَتو یِیشُرُکْتَوانْ مرِتا مرِتانْ شْمَشانے نِدَدھَتُ، تْوَں مَمَ پَشْچادْ آگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","اَنَنْتَرَں تَسْمِنْ ناوَمارُوڈھے تَسْیَ شِشْیاسْتَتْپَشْچاتْ جَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","پَشْچاتْ ساگَرَسْیَ مَدھْیَں تیشُ گَتیشُ تادرِشَح پْرَبَلو جھَنْبھْشَنِلَ اُدَتِشْٹھَتْ، یینَ مَہاتَرَنْگَ اُتّھایَ تَرَنِں چھادِتَوانْ، کِنْتُ سَ نِدْرِتَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","تَدا شِشْیا آگَتْیَ تَسْیَ نِدْرابھَنْگَں کرِتْوا کَتھَیاماسُح، ہے پْرَبھو، وَیَں مْرِیامَہے، بھَوانْ اَسْماکَں پْرانانْ رَکْشَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","تَدا سَ تانْ اُکْتَوانْ، ہے اَلْپَوِشْواسِنو یُویَں کُتو وِبھِیتھَ؟ تَتَح سَ اُتّھایَ واتَں ساگَرَنْچَ تَرْجَیاماسَ، تَتو نِرْوّاتَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","اَپَرَں مَنُجا وِسْمَیَں وِلوکْیَ کَتھَیاماسُح، اَہو واتَسَرِتْپَتِی اَسْیَ کِماجْناگْراہِنَو؟ کِیدرِشویَں مانَوَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","اَنَنْتَرَں سَ پارَں گَتْوا گِدیرِییَدیشَمْ اُپَسْتھِتَوانْ؛ تَدا دْوَو بھُوتَگْرَسْتَمَنُجَو شْمَشانَسْتھانادْ بَہِ رْبھُوتْوا تَں ساکْشاتْ کرِتَوَنْتَو، تاویتادرِشَو پْرَچَنْڈاواسْتاں یَتْ تینَ سْتھانینَ کوپِ یاتُں ناشَکْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","تاوُچَیح کَتھَیاماسَتُح، ہے اِیشْوَرَسْیَ سُونو یِیشو، تْوَیا ساکَمْ آوَیوح کَح سَمْبَنْدھَح؟ نِرُوپِتَکالاتْ پْراگیوَ کِماوابھْیاں یاتَناں داتُمْ اَتْراگَتوسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","تَدانِیں تابھْیاں کِنْچِدْ دُورے وَراہانامْ ایکو مَہاوْرَجوچَرَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","تَتو بھُوتَو تَو تَسْیانْتِکے وِنِییَ کَتھَیاماسَتُح، یَدْیاواں تْیاجَیَسِ، تَرْہِ وَراہاناں مَدھْییوْرَجَمْ آواں پْریرَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","تَدا یِیشُرَوَدَتْ یاتَں، اَنَنْتَرَں تَو یَدا مَنُجَو وِہایَ وَراہانْ آشْرِتَوَنْتَو، تَدا تے سَرْوّے وَراہا اُچَّسْتھاناتْ مَہاجَوینَ دھاوَنْتَح ساگَرِییَتویے مَجَّنْتو مَمْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","تَتو وَراہَرَکْشَکاح پَلایَمانا مَدھْیینَگَرَں تَو بھُوتَگْرَسْتَو پْرَتِ یَدْیَدْ اَگھَٹَتَ، تاح سَرْوَّوارْتّا اَوَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","تَتو ناگَرِکاح سَرْوّے مَنُجا یِیشُں ساکْشاتْ کَرْتُّں بَہِرایاتاح تَنْچَ وِلوکْیَ پْرارْتھَیانْچَکْرِرے بھَوانْ اَسْماکَں سِیماتو یاتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","اَنَنْتَرَں یِیشُ رْنَوکامارُہْیَ پُنَح پارَماگَتْیَ نِجَگْرامَمْ آیَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","تَتَح کَتِپَیا جَنا ایکَں پَکْشاگھاتِنَں سْوَٹّوپَرِ شایَیِتْوا تَتْسَمِیپَمْ آنَیَنْ؛ تَتو یِیشُسْتیشاں پْرَتِیتِں وِجْنایَ تَں پَکْشاگھاتِنَں جَگادَ، ہے پُتْرَ، سُسْتھِرو بھَوَ، تَوَ کَلُشَسْیَ مَرْشَنَں جاتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","تاں کَتھاں نِشَمْیَ کِیَنْتَ اُپادھْیایا مَنَحسُ چِنْتِتَوَنْتَ ایشَ مَنُجَ اِیشْوَرَں نِنْدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","تَتَح سَ تیشامْ ایتادرِشِیں چِنْتاں وِجْنایَ کَتھِتَوانْ، یُویَں مَنَحسُ کرِتَ ایتادرِشِیں کُچِنْتاں کُرُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","تَوَ پاپَمَرْشَنَں جاتَں، یَدْوا تْوَمُتّھایَ گَچّھَ، دْوَیورَنَیو رْواکْیَیوح کِں واکْیَں وَکْتُں سُگَمَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","کِنْتُ میدِنْیاں کَلُشَں کْشَمِتُں مَنُجَسُتَسْیَ سامَرْتھْیَمَسْتِیتِ یُویَں یَتھا جانِیتھَ، تَدَرْتھَں سَ تَں پَکْشاگھاتِنَں گَدِتَوانْ، اُتِّشْٹھَ، نِجَشَیَنِییَں آدایَ گیہَں گَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","تَتَح سَ تَتْکْشَنادْ اُتّھایَ نِجَگیہَں پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","مانَوا اِتّھَں وِلوکْیَ وِسْمَیَں مینِرے، اِیشْوَرینَ مانَوایَ سامَرْتھْیَمْ اِیدرِشَں دَتَّں اِتِ کارَناتْ تَں دھَنْیَں بَبھاشِرے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","اَنَنْتَرَں یِیشُسْتَتْسْتھانادْ گَچّھَنْ گَچّھَنْ کَرَسَںگْرَہَسْتھانے سَمُپَوِشْٹَں مَتھِنامانَمْ ایکَں مَنُجَں وِلوکْیَ تَں بَبھاشے، مَمَ پَشْچادْ آگَچّھَ، تَتَح سَ اُتّھایَ تَسْیَ پَشْچادْ وَوْراجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","تَتَح پَرَں یِیشَو گرِہے بھوکْتُمْ اُپَوِشْٹے بَہَوَح کَرَسَںگْراہِنَح کَلُشِنَشْچَ مانَوا آگَتْیَ تینَ ساکَں تَسْیَ شِشْیَیشْچَ ساکَمْ اُپَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","پھِرُوشِنَسْتَدْ درِشْٹْوا تَسْیَ شِشْیانْ بَبھاشِرے، یُشْماکَں گُرُح کِں نِمِتَّں کَرَسَںگْراہِبھِح کَلُشِبھِشْچَ ساکَں بھُںکْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","یِیشُسْتَتْ شْرُتْوا تانْ پْرَتْیَوَدَتْ، نِرامَیَلوکاناں چِکِتْسَکینَ پْرَیوجَنَں ناسْتِ، کِنْتُ سامَیَلوکاناں پْرَیوجَنَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","اَتو یُویَں یاتْوا وَچَنَسْیاسْیارْتھَں شِکْشَدھْوَمْ، دَیایاں مے یَتھا پْرِیتِ رْنَ تَتھا یَجْنَکَرْمَّنِ۔ یَتوہَں دھارْمِّکانْ آہْواتُں ناگَتوسْمِ کِنْتُ مَنَح پَرِوَرْتَّیِتُں پاپِنَ آہْواتُمْ آگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","اَنَنْتَرَں یوہَنَح شِشْیاسْتَسْیَ سَمِیپَمْ آگَتْیَ کَتھَیاماسُح، پھِرُوشِنو وَیَنْچَ پُنَح پُنَرُپَوَسامَح، کِنْتُ تَوَ شِشْیا نوپَوَسَنْتِ، کُتَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","تَدا یِیشُسْتانْ اَووچَتْ یاوَتْ سَکھِیناں سَںنْگے کَنْیایا وَرَسْتِشْٹھَتِ، تاوَتْ کِں تے وِلاپَں کَرْتُّں شَکْلُوَنْتِ؟ کِنْتُ یَدا تیشاں سَںنْگادْ وَرَں نَیَنْتِ، تادرِشَح سَمَیَ آگَمِشْیَتِ، تَدا تے اُپَوَتْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","پُراتَنَوَسَنے کوپِ نَوِینَوَسْتْرَں نَ یوجَیَتِ، یَسْماتْ تینَ یوجِتینَ پُراتَنَوَسَنَں چھِنَتِّ تَچّھِدْرَنْچَ بَہُکُتْسِتَں درِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","اَنْیَنْچَ پُراتَنَکُتْواں کوپِ نَوانَگوسْتَنِیرَسَں نَ نِدَدھاتِ، یَسْماتْ تَتھا کرِتے کُتُو رْوِدِیرْیَّتے تینَ گوسْتَنِیرَسَح پَتَتِ کُتُوشْچَ نَشْیَتِ؛ تَسْماتْ نَوِینایاں کُتْواں نَوِینو گوسْتَنِیرَسَح سْتھاپْیَتے، تینَ دْوَیورَوَنَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","اَپَرَں تینَیتَتْکَتھاکَتھَنَکالے ایکودھِپَتِسْتَں پْرَنَمْیَ بَبھاشے، مَمَ دُہِتا پْرایینَیتاوَتْکالے مرِتا، تَسْمادْ بھَواناگَتْیَ تَسْیا گاتْرے ہَسْتَمَرْپَیَتُ، تینَ سا جِیوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","تَدانِیں یِیشُح شِشْیَیح ساکَمْ اُتّھایَ تَسْیَ پَشْچادْ وَوْراجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","اِتْیَنَنْتَرے دْوادَشَوَتْسَرانْ یاوَتْ پْرَدَرامَیینَ شِیرْنَیکا نارِی تَسْیَ پَشْچادْ آگَتْیَ تَسْیَ وَسَنَسْیَ گْرَنْتھِں پَسْپَرْشَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","یَسْماتْ مَیا کیوَلَں تَسْیَ وَسَنَں سْپرِشْٹْوا سْواسْتھْیَں پْراپْسْیَتے، سا نارِیتِ مَنَسِ نِشْچِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","تَتو یِیشُرْوَدَنَں پَراوَرْتّیَ تاں جَگادَ، ہے کَنْیے، تْوَں سُسْتھِرا بھَوَ، تَوَ وِشْواسَسْتْواں سْوَسْتھامَکارْشِیتْ۔ ایتَدْواکْیے گَدِتَایوَ سا یوشِتْ سْوَسْتھابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","اَپَرَں یِیشُسْتَسْیادھْیَکْشَسْیَ گیہَں گَتْوا وادَکَپْرَبھرِتِینْ بَہُونْ لوکانْ شَبْدایَمانانْ وِلوکْیَ تانْ اَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","پَنْتھانَں تْیَجَ، کَنْیییَں نامْرِیَتَ نِدْرِتاسْتے؛ کَتھامیتاں شْرُتْوا تے تَمُپَجَہَسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","کِنْتُ سَرْوّیشُ بَہِشْکرِتیشُ سوبھْیَنْتَرَں گَتْوا کَنْیایاح کَرَں دھرِتَوانْ، تینَ سودَتِشْٹھَتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","تَتَسْتَتْکَرْمَّنو یَشَح کرِتْسْنَں تَں دیشَں وْیاپْتَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","تَتَح پَرَں یِیشُسْتَسْماتْ سْتھانادْ یاتْراں چَکارَ؛ تَدا ہے دایُودَح سَنْتانَ، اَسْمانْ دَیَسْوَ، اِتِ وَدَنْتَو دْوَو جَناوَنْدھَو پْروچَیراہُویَنْتَو تَتْپَشْچادْ وَوْرَجَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","تَتو یِیشَو گیہَمَدھْیَں پْرَوِشْٹَں تاوَپِ تَسْیَ سَمِیپَمْ اُپَسْتھِتَوَنْتَو، تَدانِیں سَ تَو پرِشْٹَوانْ کَرْمَّیتَتْ کَرْتُّں مَمَ سامَرْتھْیَمْ آسْتے، یُواں کِمِتِ پْرَتِیتھَح؟ تَدا تَو پْرَتْیُوچَتُح، سَتْیَں پْرَبھو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","تَدانِیں سَ تَیو رْلوچَنانِ سْپرِشَنْ بَبھاشے، یُوَیوح پْرَتِیتْیَنُسارادْ یُوَیو رْمَنْگَلَں بھُویاتْ۔ تینَ تَتْکْشَناتْ تَیو رْنیتْرانِ پْرَسَنّانْیَبھَوَنْ، ");
INSERT INTO sanurd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","پَشْچادْ یِیشُسْتَو درِڈھَماجْناپْیَ جَگادَ، اَوَدھَتَّمْ ایتاں کَتھاں کوپِ مَنُجو مَ جانِییاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","کِنْتُ تَو پْرَسْتھایَ تَسْمِنْ کرِتْسْنے دیشے تَسْیَ کِیرْتِّں پْرَکاشَیاماسَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","اَپَرَں تَو بَہِرْیاتَ ایتَسْمِنَّنْتَرے مَنُجا ایکَں بھُوتَگْرَسْتَمُوکَں تَسْیَ سَمِیپَمْ آنِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","تینَ بھُوتے تْیاجِتے سَ مُوکَح کَتھاں کَتھَیِتُں پْرارَبھَتَ، تینَ جَنا وِسْمَیَں وِجْنایَ کَتھَیاماسُح، اِسْراییلو وَںشے کَداپِ نیدرِگَدرِشْیَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","کِنْتُ پھِرُوشِنَح کَتھَیانْچَکْرُح بھُوتادھِپَتِنا سَ بھُوتانْ تْیاجَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","تَتَح پَرَں یِیشُسْتیشاں بھَجَنَبھَوَنَ اُپَدِشَنْ راجْیَسْیَ سُسَںوادَں پْرَچارَیَنْ لوکاناں یَسْیَ یَ آمَیو یا چَ پِیڈاسِیتْ، تانْ شَمَیَنْ شَمَیَںشْچَ سَرْوّانِ نَگَرانِ گْراماںشْچَ بَبھْرامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","اَنْیَنْچَ مَنُجانْ وْیاکُلانْ اَرَکْشَکَمیشانِوَ چَ تْیَکْتانْ نِرِیکْشْیَ تیشُ کارُنِکَح سَنْ شِشْیانْ اَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","شَسْیانِ پْرَچُرانِ سَنْتِ، کِنْتُ چھیتّارَح سْتوکاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","کْشیتْرَں پْرَتْیَپَرانْ چھیدَکانْ پْرَہیتُں شَسْیَسْوامِنَں پْرارْتھَیَدھْوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","اَنَنْتَرَں یِیشُ رْدْوادَشَشِشْیانْ آہُویامیدھْیَبھُوتانْ تْیاجَیِتُں سَرْوَّپْرَکارَروگانْ پِیڈاشْچَ شَمَیِتُں تیبھْیَح سامَرْتھْیَمَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","تیشاں دْوادَشَپْریشْیاناں نامانْییتانِ۔ پْرَتھَمَں شِمونْ یَں پِتَرَں وَدَنْتِ، تَتَح پَرَں تَسْیَ سَہَجَ آنْدْرِیَح، سِوَدِیَسْیَ پُتْرو یاکُوبْ ");
INSERT INTO sanurd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","تَسْیَ سَہَجو یوہَنْ؛ پھِلِپْ بَرْتھَلَمَیْ تھوماح کَرَسَںگْراہِی مَتھِح، آلْپھییَپُتْرو یاکُوبْ، ");
INSERT INTO sanurd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","کِنانِییَح شِمونْ، یَ اِیشْکَرِیوتِییَیِہُوداح کھْرِیشْٹَں پَرَکَرےرْپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ایتانْ دْوادَشَشِشْیانْ یِیشُح پْریشَیَنْ اِتْیاجْناپَیَتْ، یُویَمْ اَنْیَدیشِییاناں پَدَوِیں شیمِرونِییاناں کِمَپِ نَگَرَنْچَ نَ پْرَوِشْیی ");
INSERT INTO sanurd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","اِسْراییلْگوتْرَسْیَ ہارِتا یے یے میشاسْتیشامیوَ سَمِیپَں یاتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","گَتْوا گَتْوا سْوَرْگَسْیَ راجَتْوَں سَوِدھَمَبھَوَتْ، ایتاں کَتھاں پْرَچارَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","آمَیَگْرَسْتانْ سْوَسْتھانْ کُرُتَ، کُشْٹھِنَح پَرِشْکُرُتَ، مرِتَلوکانْ جِیوَیَتَ، بھُوتانْ تْیاجَیَتَ، وِنا مُولْیَں یُویَمْ اَلَبھَدھْوَں وِنَیوَ مُولْیَں وِشْرانَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","کِنْتُ سْویشاں کَٹِبَنْدھیشُ سْوَرْنَرُوپْیَتامْراناں کِمَپِ نَ گرِہْلِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","اَنْیَچَّ یاتْرایَے چیلَسَمْپُٹَں وا دْوِتِییَوَسَنَں وا پادُکے وا یَشْٹِح، ایتانْ ما گرِہْلِیتَ، یَتَح کارْیَّکرِتْ بھَرْتُّں یوگْیو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","اَپَرَں یُویَں یَتْ پُرَں یَنْچَ گْرامَں پْرَوِشَتھَ، تَتْرَ یو جَنو یوگْیَپاتْرَں تَمَوَگَتْیَ یانَکالَں یاوَتْ تَتْرَ تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","یَدا یُویَں تَدْگیہَں پْرَوِشَتھَ، تَدا تَماشِشَں وَدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","یَدِ سَ یوگْیَپاتْرَں بھَوَتِ، تَرْہِ تَتْکَلْیانَں تَسْمَے بھَوِشْیَتِ، نوچیتْ ساشِیرْیُشْمَبھْیَمیوَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","کِنْتُ یے جَنا یُشْماکَماتِتھْیَں نَ وِدَدھَتِ یُشْماکَں کَتھانْچَ نَ شرِنْوَنْتِ تیشاں گیہاتْ پُرادْوا پْرَسْتھانَکالے سْوَپَدُولِیح پاتَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","یُشْمانَہَں تَتھْیَں وَچْمِ وِچارَدِنے تَتْپُرَسْیَ دَشاتَح سِدومَموراپُرَیورْدَشا سَہْیَتَرا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","پَشْیَتَ، ورِکَیُوتھَمَدھْیے میشَح یَتھاوِسْتَتھا یُشْمانَ پْرَہِنومِ، تَسْمادْ یُویَمْ اَہِرِوَ سَتَرْکاح کَپوتااِواہِںسَکا بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","نرِبھْیَح ساوَدھانا بھَوَتَ؛ یَتَسْتَے رْیُویَں راجَسَںسَدِ سَمَرْپِشْیَدھْوے تیشاں بھَجَنَگیہے پْرَہارِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","یُویَں مَنّامَہیتوح شاسْترِناں راجْنانْچَ سَمَکْشَں تانَنْیَدیشِنَشْچادھِ ساکْشِتْوارْتھَمانیشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","کِنْتْوِتّھَں سَمَرْپِتا یُویَں کَتھَں کِمُتَّرَں وَکْشْیَتھَ تَتْرَ ما چِنْتَیَتَ، یَتَسْتَدا یُشْمابھِ رْیَدْ وَکْتَوْیَں تَتْ تَدَّنْڈے یُشْمَنْمَنَح سُ سَمُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","یَسْماتْ تَدا یو وَکْشْیَتِ سَ نَ یُویَں کِنْتُ یُشْماکَمَنْتَرَسْتھَح پِتْراتْما۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","سَہَجَح سَہَجَں تاتَح سُتَنْچَ مرِتَو سَمَرْپَیِشْیَتِ، اَپَتْیاگِ سْوَسْوَپِتْروे رْوِپَکْشِیبھُویَ تَو گھاتَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","مَنَّمَہیتوح سَرْوّے جَنا یُشْمانْ رِृتِییِشْیَنْتے، کِنْتُ یَح شیشَں یاوَدْ دھَیرْیَّں گھرِتْوا سْتھاسْیَتِ، سَ تْرایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","تَے رْیَدا یُویَمیکَپُرے تاڈِشْیَدھْوے، تَدا یُویَمَنْیَپُرَں پَلایَدھْوَں یُشْمانَہَں تَتھْیَں وَچْمِ یاوَنْمَنُجَسُتو نَیتِ تاوَدْ اِسْراییلْدیشِییَسَرْوَّنَگَرَبھْرَمَنَں سَماپَیِتُں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","گُروح شِشْیو نَ مَہانْ، پْرَبھورْداسو نَ مَہانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","یَدِ شِشْیو نِجَگُرو رْداسَشْچَ سْوَپْرَبھوح سَمانو بھَوَتِ تَرْہِ تَدْ یَتھیشْٹَں۔ چیتَّیرْگرِہَپَتِرْبھُوتَراجَ اُچْیَتے، تَرْہِ پَرِواراح کِں تَتھا نَ وَکْشْیَنْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","کِنْتُ تیبھْیو یُویَں ما بِبھِیتَ، یَتو یَنَّ پْرَکاشِشْیَتے، تادرِکْ چھادِتَں کِمَپِ ناسْتِ، یَچَّ نَ وْیَنْچِشْیَتے، تادرِگْ گُپْتَں کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","یَدَہَں یُشْمانْ تَمَسِ وَچْمِ تَدْ یُشْمابھِرْدِیپْتَو کَتھْیَتاں؛ کَرْنابھْیاں یَتْ شْرُویَتے تَدْ گیہوپَرِ پْرَچارْیَّتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","یے کایَں ہَنْتُں شَکْنُوَنْتِ ناتْمانَں، تیبھْیو ما بھَیشْٹَ؛ یَح کایاتْمانَو نِرَیے ناشَیِتُں، شَکْنوتِ، تَتو بِبھِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","دْوَو چَٹَکَو کِمیکَتامْرَمُدْرَیا نَ وِکْرِیییتے؟ تَتھاپِ یُشْمَتّاتانُمَتِں وِنا تیشامیکوپِ بھُوِ نَ پَتَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","یُشْمَچّھِرَساں سَرْوَّکَچا گَنِتاںح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","اَتو ما بِبھِیتَ، یُویَں بَہُچَٹَکیبھْیو بَہُمُولْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","یو مَنُجَساکْشانْمامَنْگِیکُرُتے تَمَہَں سْوَرْگَسْتھَتاتَساکْشادَنْگِیکَرِشْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","پرِتھْوْیامَہَں شانْتِں داتُماگَتَاِتِ مانُبھَوَتَ، شانْتِں داتُں نَ کِنْتْوَسِں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","پِترِماترِشْچَشْرُوبھِح ساکَں سُتَسُتابَدھُو رْوِرودھَیِتُنْچاگَتےाسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","تَتَح سْوَسْوَپَرِوارَایوَ نرِشَتْرُ رْبھَوِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","یَح پِتَرِ ماتَرِ وا مَتّودھِکَں پْرِییَتے، سَ نَ مَدَرْہَح؛ ");
INSERT INTO sanurd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","یَشْچَ سُتے سُتایاں وا مَتّودھِکَں پْرِییَتے، سےाپِ نَ مَدَرْہَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","یَح سْوَکْرُشَں گرِہْلَنْ مَتْپَشْچانَّیتِ، سےाپِ نَ مَدَرْہَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","یَح سْوَپْرانانَوَتِ، سَ تانْ ہارَیِشْیَتے، یَسْتُ مَتْکرِتے سْوَپْرانانْ ہارَیَتِ، سَ تانَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","یو یُشْماکَماتِتھْیَں وِدَدھاتِ، سَ مَماتِتھْیَں وِدَدھاتِ، یَشْچَ مَماتِتھْیَں وِدَدھاتِ، سَ مَتْپْریرَکَسْیاتِتھْیَں وِدَدھاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","یو بھَوِشْیَدْوادِیتِ جْناتْوا تَسْیاتِتھْیَں وِدھَتّے، سَ بھَوِشْیَدْوادِنَح پھَلَں لَپْسْیَتے، یَشْچَ دھارْمِّکَ اِتِ وِدِتْوا تَسْیاتِتھْیَں وِدھَتّے سَ دھارْمِّکَمانَوَسْیَ پھَلَں پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","یَشْچَ کَشْچِتْ ایتیشاں کْشُدْرَنَرانامْ یَں کَنْچَنَیکَں شِشْیَ اِتِ وِدِتْوا کَںسَیکَں شِیتَلَسَلِلَں تَسْمَے دَتّے، یُشْمانَہَں تَتھْیَں وَدامِ، سَ کیناپِ پْرَکارینَ پھَلینَ نَ وَنْچِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","اِتّھَں یِیشُح سْوَدْوادَشَشِشْیاناماجْناپَنَں سَماپْیَ پُرے پُرَ اُپَدیشْٹُں سُسَںوادَں پْرَچارَیِتُں تَتْسْتھاناتْ پْرَتَسْتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","اَنَنْتَرَں یوہَنْ کارایاں تِشْٹھَنْ کھْرِشْٹَسْیَ کَرْمَّناں وارْتَّں پْراپْیَ یَسْیاگَمَنَوارْتّاسِیتْ سَایوَ کِں تْوَں؟ وا وَیَمَنْیَمْ اَپیکْشِشْیامَہے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ایتَتْ پْرَشْٹُں نِجَو دْوَو شِشْیَو پْراہِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","یِیشُح پْرَتْیَووچَتْ، اَنْدھا نیتْرانِ لَبھَنْتے، کھَنْچا گَچّھَنْتِ، کُشْٹھِنَح سْوَسْتھا بھَوَنْتِ، بَدھِراح شرِنْوَنْتِ، مرِتا جِیوَنْتَ اُتِّشْٹھَنْتِ، دَرِدْراناں سَمِیپے سُسَںوادَح پْرَچارْیَّتَ، ");
INSERT INTO sanurd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ایتانِ یَدْیَدْ یُواں شرِنُتھَح پَشْیَتھَشْچَ گَتْوا تَدْوارْتّاں یوہَنَں گَدَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","یَسْیاہَں نَ وِگھْنِیبھَوامِ، سَایوَ دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","اَنَنْتَرَں تَیوح پْرَسْتھِتَیو رْیِیشُ رْیوہَنَمْ اُدِّشْیَ جَنانْ جَگادَ، یُویَں کِں دْرَشْٹُں وَہِرْمَدھْییپْرانْتَرَمْ اَگَچّھَتَ؟ کِں واتینَ کَمْپِتَں نَلَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","وا کِں وِیکْشِتُں وَہِرْگَتَوَنْتَح؟ کِں پَرِہِتَسُوکْشْمَوَسَنَں مَنُجَمیکَں؟ پَشْیَتَ، یے سُوکْشْمَوَسَنانِ پَرِدَدھَتِ، تے راجَدھانْیاں تِشْٹھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","تَرْہِ یُویَں کِں دْرَشْٹُں بَہِرَگَمَتَ، کِمیکَں بھَوِشْیَدْوادِنَں؟ تَدیوَ سَتْیَں۔ یُشْمانَہَں وَدامِ، سَ بھَوِشْیَدْوادِنوپِ مَہانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","یَتَح، پَشْیَ سْوَکِییَدُوتویَں تْوَدَگْرے پْریشْیَتے مَیا۔ سَ گَتْوا تَوَ پَنْتھانَں سْمَیَکْ پَرِشْکَرِشْیَتِ۔۔ ایتَدْوَچَنَں یَمَدھِ لِکھِتَماسْتے سویَں یوہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","اَپَرَں یُشْمانَہَں تَتھْیَں بْرَوِیمِ، مَجَّیِتُ رْیوہَنَح شْریشْٹھَح کوپِ نارِیتو ناجایَتَ؛ تَتھاپِ سْوَرْگَراجْیَمَدھْیے سَرْوّیبھْیو یَح کْشُدْرَح سَ یوہَنَح شْریشْٹھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","اَپَرَنْچَ آ یوہَنودْیَ یاوَتْ سْوَرْگَراجْیَں بَلاداکْرانْتَں بھَوَتِ آکْرَمِنَشْچَ جَنا بَلینَ تَدَدھِکُرْوَّنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","یَتو یوہَنَں یاوَتْ سَرْوَّبھَوِشْیَدْوادِبھِ رْوْیَوَسْتھَیا چَ اُپَدیشَح پْراکاشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","یَدِ یُویَمِدَں واکْیَں گْرَہِیتُں شَکْنُتھَ، تَرْہِ شْرییَح، یَسْیاگَمَنَسْیَ وَچَنَماسْتے سویَمْ ایلِیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","یَسْیَ شْروتُں کَرْنَو سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ایتے وِدْیَمانَجَناح کَے رْمَیوپَمِییَنْتے؟ یے بالَکا ہَٹَّ اُپَوِشْیَ سْوَں سْوَں بَنْدھُماہُویَ وَدَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","وَیَں یُشْماکَں سَمِیپے وَںشِیرَوادَیامَ، کِنْتُ یُویَں نانرِتْیَتَ؛ یُشْماکَں سَمِیپے چَ وَیَمَرودِمَ، کِنْتُ یُویَں نَ وْیَلَپَتَ، تادرِشَے رْبالَکَیسْتَ اُپَمایِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","یَتو یوہَنْ آگَتْیَ نَ بھُکْتَوانْ نَ پِیتَواںشْچَ، تینَ لوکا وَدَنْتِ، سَ بھُوتَگْرَسْتَ اِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","مَنُجَسُتَ آگَتْیَ بھُکْتَوانْ پِیتَواںشْچَ، تینَ لوکا وَدَنْتِ، پَشْیَتَ ایشَ بھوکْتا مَدْیَپاتا چَنْڈالَپاپِناں بَنْدھَشْچَ، کِنْتُ جْنانِنو جْنانَوْیَوَہارَں نِرْدوشَں جانَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","سَ یَتْرَ یَتْرَ پُرے بَہْواشْچَرْیَّں کَرْمَّ کرِتَوانْ، تَنِّواسِناں مَنَحپَراورِتّیَبھاواتْ تانِ نَگَرانِ پْرَتِ ہَنْتیتْیُکْتا کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ہا کوراسِینْ، ہا بَیتْسَیدے، یُشْمَنْمَدھْیے یَدْیَداشْچَرْیَّں کَرْمَّ کرِتَں یَدِ تَتْ سورَسِیدونَّگَرَ اَکارِشْیَتَ، تَرْہِ پُورْوَّمیوَ تَنِّواسِنَح شانَوَسَنے بھَسْمَنِ چوپَوِشَنْتو مَناںسِ پَراوَرْتِّشْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","تَسْمادَہَں یُشْمانْ وَدامِ، وِچارَدِنے یُشْماکَں دَشاتَح سورَسِیدونو رْدَشا سَہْیَتَرا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","اَپَرَنْچَ بَتَ کَپھَرْناہُومْ، تْوَں سْوَرْگَں یاوَدُنَّتوسِ، کِنْتُ نَرَکے نِکْشیپْسْیَسے، یَسْماتْ تْوَیِ یانْیاشْچَرْیّانِ کَرْمَّنْیَکارِشَتَ، یَدِ تانِ سِدومْنَگَرَ اَکارِشْیَنْتَ، تَرْہِ تَدَدْیَ یاوَدَسْتھاسْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","کِنْتْوَہَں یُشْمانْ وَدامِ، وِچارَدِنے تَوَ دَنْڈَتَح سِدومو دَنْڈو سَہْیَتَرو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ایتَسْمِنّیوَ سَمَیے یِیشُح پُنَرُواچَ، ہے سْوَرْگَپرِتھِوْیوریکادھِپَتے پِتَسْتْوَں جْنانَوَتو وِدُشَشْچَ لوکانْ پْرَتْییتانِ نَ پْرَکاشْیَ بالَکانْ پْرَتِ پْرَکاشِتَوانْ، اِتِ ہیتوسْتْواں دھَنْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ہے پِتَح، اِتّھَں بھَویتْ یَتَ اِدَں تْوَدرِشْٹاوُتَّمَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","پِتْرا مَیِ سَرْوّانِ سَمَرْپِتانِ، پِتَرَں وِنا کوپِ پُتْرَں نَ جاناتِ، یانْ پْرَتِ پُتْرینَ پِتا پْرَکاشْیَتے تانْ وِنا پُتْرادْ اَنْیَح کوپِ پِتَرَں نَ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ہے پَرِشْرانْتا بھاراکْرانْتاشْچَ لوکا یُویَں مَتْسَنِّدھِمْ آگَچّھَتَ، اَہَں یُشْمانْ وِشْرَمَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","اَہَں کْشَمَنَشِیلو نَمْرَمَناشْچَ، تَسْماتْ مَمَ یُگَں سْویشامُپَرِ دھارَیَتَ مَتَّح شِکْشَدھْوَنْچَ، تینَ یُویَں سْوے سْوے مَنَسِ وِشْرامَں لَپْسْیَدھْبے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","یَتو مَمَ یُگَمْ اَنایاسَں مَمَ بھارَشْچَ لَگھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","اَنَنْتَرَں یِیشُ رْوِشْرامَوارے شْسْیَمَدھْیینَ گَچّھَتِ، تَدا تَچّھِشْیا بُبھُکْشِتاح سَنْتَح شْسْیَمَنْجَرِیشْچھَتْوا چھِتْوا کھادِتُمارَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","تَدْ وِلوکْیَ پھِرُوشِنو یِیشُں جَگَدُح، پَشْیَ وِشْرامَوارے یَتْ کَرْمّاکَرْتَّوْیَں تَدیوَ تَوَ شِشْیاح کُرْوَّنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","سَ تانْ پْرَتْیاوَدَتَ، دایُودْ تَتْسَنْگِنَشْچَ بُبھُکْشِتاح سَنْتو یَتْ کَرْمّاکُرْوَّنْ تَتْ کِں یُشْمابھِ رْناپاٹھِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","یے دَرْشَنِییاح پُوپاح یاجَکانْ وِنا تَسْیَ تَتْسَنْگِمَنُجانانْچابھوجَنِییاسْتَ اِیشْوَراواسَں پْرَوِشْٹینَ تینَ بھُکْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","اَنْیَچَّ وِشْرامَوارے مَدھْییمَنْدِرَں وِشْرامَوارِییَں نِیَمَں لَنْوَنْتوپِ یاجَکا نِرْدوشا بھَوَنْتِ، شاسْتْرَمَدھْیے کِمِدَمَپِ یُشْمابھِ رْنَ پَٹھِتَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","یُشْمانَہَں وَدامِ، اَتْرَ سْتھانے مَنْدِرادَپِ گَرِییانْ ایکَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","کِنْتُ دَیایاں مے یَتھا پْرِیتِ رْنَ تَتھا یَجْنَکَرْمَّنِ۔ ایتَدْوَچَنَسْیارْتھَں یَدِ یُیَمْ اَجْناسِشْٹَ تَرْہِ نِرْدوشانْ دوشِنو ناکارْشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","اَنْیَچَّ مَنُجَسُتو وِشْرامَوارَسْیاپِ پَتِراسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","اَنَنْتَرَں سَ تَتْسْتھاناتْ پْرَسْتھایَ تیشاں بھَجَنَبھَوَنَں پْرَوِشْٹَوانْ، تَدانِیمْ ایکَح شُشْکَکَرامَیَوانْ اُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","تَتو یِیشُمْ اَپَوَدِتُں مانُشاح پَپْرَچّھُح، وِشْرامَوارے نِرامَیَتْوَں کَرَنِییَں نَ وا؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","تینَ سَ پْرَتْیُواچَ، وِشْرامَوارے یَدِ کَسْیَچِدْ اَوِ رْگَرْتّے پَتَتِ، تَرْہِ یَسْتَں گھرِتْوا نَ تولَیَتِ، ایتادرِشو مَنُجو یُشْماکَں مَدھْیے کَ آسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","اَوے رْمانَوَح کِں نَہِ شْرییانْ؟ اَتو وِشْرامَوارے ہِتَکَرْمَّ کَرْتَّوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","اَنَنْتَرَں سَ تَں مانَوَں گَدِتَوانْ، کَرَں پْرَسارَیَ؛ تینَ کَرے پْرَسارِتے سونْیَکَرَوَتْ سْوَسْتھوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","تَدا پھِرُوشِنو بَہِرْبھُویَ کَتھَں تَں ہَنِشْیامَ اِتِ کُمَنْتْرَناں تَتْپْراتِکُولْیینَ چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","تَتو یِیشُسْتَدْ وِدِتْوا سْتھَنانْتَرَں گَتَوانْ؛ اَنْییشُ بَہُنَریشُ تَتْپَشْچادْ گَتیشُ تانْ سَ نِرامَیانْ کرِتْوا اِتْیاجْناپَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","یُویَں ماں نَ پَرِچایَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","تَسْماتْ مَمَ پْرِییو مَنونِیتو مَنَسَسْتُشْٹِکارَکَح۔ مَدِییَح سیوَکو یَسْتُ وِدْیَتے تَں سَمِیکْشَتاں۔ تَسْیوپَرِ سْوَکِییاتْما مَیا سَںسْتھاپَیِشْیَتے۔ تینانْیَدیشَجاتیشُ وْیَوَسْتھا سَںپْرَکاشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","کیناپِ نَ وِرودھَں سَ وِوادَنْچَ کَرِشْیَتِ۔ نَ چَ راجَپَتھے تینَ وَچَنَں شْراوَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","وْیَوَسْتھا چَلِتا یاوَتْ نَہِ تینَ کَرِشْیَتے۔ تاوَتْ نَلو وِدِیرْنوپِ بھَںکْشْیَتے نَہِ تینَ چَ۔ تَتھا سَدھُومَوَرْتِّنْچَ نَ سَ نِرْوّاپَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","پْرَتْیاشانْچَ کَرِشْیَنْتِ تَنّامْنِ بھِنَّدیشَجاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","یانْییتانِ وَچَنانِ یِشَیِیَبھَوِشْیَدْوادِنا پْروکْتانْیاسَنْ، تانِ سَپھَلانْیَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","اَنَنْتَرَں لوکَے سْتَتْسَمِیپَمْ آنِیتو بھُوتَگْرَسْتانْدھَمُوکَیکَمَنُجَسْتینَ سْوَسْتھِیکرِتَح، تَتَح سونْدھو مُوکو دْرَشْٹُں وَکْتُنْچارَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","اَنینَ سَرْوّے وِسْمِتاح کَتھَیانْچَکْرُح، ایشَح کِں دایُودَح سَنْتانو نَہِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","کِنْتُ پھِرُوشِنَسْتَتْ شْرُتْوا گَدِتَوَنْتَح، بالْسِبُوبْنامْنو بھُوتَراجَسْیَ ساہایَّں وِنا نایَں بھُوتانْ تْیاجَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","تَدانِیں یِیشُسْتیشامْ اِتِ مانَسَں وِجْنایَ تانْ اَوَدَتْ کِنْچَنَ راجْیَں یَدِ سْوَوِپَکْشادْ بھِدْیَتے، تَرْہِ تَتْ اُچّھِدْیَتے؛ یَچَّ کِنْچَنَ نَگَرَں وا گرِہَں سْوَوِپَکْشادْ وِبھِدْیَتے، تَتْ سْتھاتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","تَدْوَتْ شَیَتانو یَدِ شَیَتانَں بَہِح کرِتْوا سْوَوِپَکْشاتْ پرِتھَکْ پرِتھَکْ بھَوَتِ، تَرْہِ تَسْیَ راجْیَں کینَ پْرَکارینَ سْتھاسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","اَہَنْچَ یَدِ بالْسِبُوبا بھُوتانْ تْیاجَیامِ، تَرْہِ یُشْماکَں سَنْتاناح کینَ بھُوتانْ تْیاجَیَنْتِ؟ تَسْمادْ یُشْماکَمْ ایتَدْوِچارَیِتارَسْتَ ایوَ بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","کِنْتَوَہَں یَدِیشْوَراتْمَنا بھُوتانْ تْیاجَیامِ، تَرْہِیشْوَرَسْیَ راجْیَں یُشْماکَں سَنِّدھِماگَتَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","اَنْیَنْچَ کوپِ بَلَوَنْتَ جَنَں پْرَتھَمَتو نَ بَدْوّا کینَ پْرَکارینَ تَسْیَ گرِہَں پْرَوِشْیَ تَدّرَوْیادِ لوٹھَیِتُں شَکْنوتِ؟ کِنْتُ تَتْ کرِتْوا تَدِییَگرِسْیَ دْرَوْیادِ لوٹھَیِتُں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","یَح کَشْچِتْ مَمَ سْوَپَکْشِییو نَہِ سَ وِپَکْشِییَ آسْتے، یَشْچَ مَیا ساکَں نَ سَںگرِہْلاتِ، سَ وِکِرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","اَتَایوَ یُشْمانَہَں وَدامِ، مَنُجاناں سَرْوَّپْرَکارَپاپاناں نِنْدایاشْچَ مَرْشَنَں بھَوِتُں شَکْنوتِ، کِنْتُ پَوِتْرَسْیاتْمَنو وِرُدّھَنِنْدایا مَرْشَنَں بھَوِتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","یو مَنُجَسُتَسْیَ وِرُدّھاں کَتھاں کَتھَیَتِ، تَسْیاپَرادھَسْیَ کْشَما بھَوِتُں شَکْنوتِ، کِنْتُ یَح کَشْچِتْ پَوِتْرَسْیاتْمَنو وِرُدّھاں کَتھاں کَتھَیَتِ نیہَلوکے نَ پْریتْیَ تَسْیاپَرادھَسْیَ کْشَما بھَوِتُں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","پادَپَں یَدِ بھَدْرَں وَدَتھَ، تَرْہِ تَسْیَ پھَلَمَپِ سادھُ وَکْتَوْیَں، یَدِ چَ پادَپَں اَسادھُں وَدَتھَ، تَرْہِ تَسْیَ پھَلَمَپْیَسادھُ وَکْتَوْیَں؛ یَتَح سْوِییَسْوِییَپھَلینَ پادَپَح پَرِچِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","رے بھُجَگَوَںشا یُویَمَسادھَوَح سَنْتَح کَتھَں سادھُ واکْیَں وَکْتُں شَکْشْیَتھَ؟ یَسْمادْ اَنْتَحکَرَنَسْیَ پُورْنَبھاوانُسارادْ وَدَنادْ وَچو نِرْگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","تینَ سادھُرْمانَوونْتَحکَرَنَرُوپاتْ سادھُبھانْڈاگاراتْ سادھُ دْرَوْیَں نِرْگَمَیَتِ، اَسادھُرْمانُشَسْتْوَسادھُبھانْڈاگارادْ اَسادھُوَسْتُونِ نِرْگَمَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","کِنْتْوَہَں یُشْمانْ وَدامِ، مَنُجا یاوَنْتْیالَسْیَوَچاںسِ وَدَنْتِ، وِچارَدِنے تَدُتَّرَمَوَشْیَں داتَوْیَں، ");
INSERT INTO sanurd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","یَتَسْتْوَں سْوِییَوَچوبھِ رْنِرَپَرادھَح سْوِییَوَچوبھِشْچَ ساپَرادھو گَنِشْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","تَدانِیں کَتِپَیا اُپادھْیایاح پھِرُوشِنَشْچَ جَگَدُح، ہے گُرو وَیَں بھَوَتَّح کِنْچَنَ لَکْشْمَ دِدرِکْشامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","تَدا سَ پْرَتْیُکْتَوانْ، دُشْٹو وْیَبھِچارِی چَ وَںشو لَکْشْمَ مرِگَیَتے، کِنْتُ بھَوِشْیَدْوادِنو یُونَسو لَکْشْمَ وِہایانْیَتْ کِمَپِ لَکْشْمَ تے نَ پْرَدَرْشَیِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","یَتو یُونَمْ یَتھا تْرْیَہوراتْرَں برِہَنْمِینَسْیَ کُکْشاواسِیتْ، تَتھا مَنُجَپُتْروپِ تْرْیَہوراتْرَں میدِنْیا مَدھْیے سْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","اَپَرَں نِینِوِییا مانَوا وِچارَدِنَ ایتَدْوَںشِییاناں پْرَتِکُولَمْ اُتّھایَ تانْ دوشِنَح کَرِشْیَنْتِ، یَسْماتّے یُونَسَ اُپَدیشاتْ مَناںسِ پَراوَرْتَّیانْچَکْرِرے، کِنْتْوَتْرَ یُونَسوپِ گُرُتَرَ ایکَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","پُنَشْچَ دَکْشِنَدیشِییا راجْنِی وِچارَدِنَ ایتَدْوَںشِییاناں پْرَتِکُولَمُتّھایَ تانْ دوشِنَح کَرِشْیَتِ یَتَح سا راجْنِی سُلیمَنو وِدْیایاح کَتھاں شْروتُں میدِنْیاح سِیمْنَ آگَچّھَتْ، کِنْتُ سُلیمَنوپِ گُرُتَرَ ایکو جَنوتْرَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","اَپَرَں مَنُجادْ بَہِرْگَتو پَوِتْرَبھُوتَح شُشْکَسْتھانینَ گَتْوا وِشْرامَں گَویشَیَتِ، کِنْتُ تَدَلَبھَمانَح سَ وَکْتِ، یَسْما؛ نِکیتَنادْ آگَمَں، تَدیوَ ویشْمَ پَکاورِتْیَ یامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","پَشْچاتْ سَ تَتْ سْتھانَمْ اُپَسْتھایَ تَتْ شُونْیَں مارْجِّتَں شوبھِتَنْچَ وِلوکْیَ وْرَجَنْ سْوَتوپِ دُشْٹَتَرانْ اَنْیَسَپْتَبھُوتانْ سَنْگِنَح کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","تَتَسْتے تَتْ سْتھانَں پْرَوِشْیَ نِوَسَنْتِ، تینَ تَسْیَ مَنُجَسْیَ شیشَدَشا پُورْوَّدَشاتوتِیواشُبھا بھَوَتِ، ایتیشاں دُشْٹَوَںشْیانامَپِ تَتھَیوَ گھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","مانَویبھْیَ ایتاساں کَتھَناں کَتھَنَکالے تَسْیَ ماتا سَہَجاشْچَ تینَ ساکَں کانْچِتْ کَتھاں کَتھَیِتُں وانْچھَنْتو بَہِریوَ سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","تَتَح کَشْچِتْ تَسْمَے کَتھِتَوانْ، پَشْیَ تَوَ جَنَنِی سَہَجاشْچَ تْوَیا ساکَں کانْچَنَ کَتھاں کَتھَیِتُں کامَیَمانا بَہِسْتِشْٹھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","کِنْتُ سَ تَں پْرَتْیَوَدَتْ، مَمَ کا جَنَنِی؟ کے وا مَمَ سَہَجاح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","پَشْچاتْ شِشْیانْ پْرَتِ کَرَں پْرَسارْیَّ کَتھِتَوانْ، پَشْیَ مَمَ جَنَنِی مَمَ سَہَجاشْچَیتے؛ ");
INSERT INTO sanurd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","یَح کَشْچِتْ مَمَ سْوَرْگَسْتھَسْیَ پِتُرِشْٹَں کَرْمَّ کُرُتے، سَایوَ مَمَ بھْراتا بھَگِنِی جَنَنِی چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","اَپَرَنْچَ تَسْمِنْ دِنے یِیشُح سَدْمَنو گَتْوا سَرِتْپَتے رودھَسِ سَمُپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","تَتْرَ تَتْسَنِّدھَو بَہُجَناناں نِوَہوپَسْتھِتیح سَ تَرَنِمارُہْیَ سَمُپاوِشَتْ، تینَ مانَوا رودھَسِ سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","تَدانِیں سَ درِشْٹانْتَیسْتانْ اِتّھَں بَہُشَ اُپَدِشْٹَوانْ۔ پَشْیَتَ، کَشْچِتْ کرِشِیوَلو بِیجانِ وَپْتُں بَہِرْجَگامَ، ");
INSERT INTO sanurd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","تَسْیَ وَپَنَکالے کَتِپَیَبِیجیشُ مارْگَپارْشْوے پَتِتیشُ وِہَگاسْتانِ بھَکْشِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","اَپَرَں کَتِپَیَبِیجیشُ سْتوکَمرِدْیُکْتَپاشانے پَتِتیشُ مرِدَلْپَتْواتْ تَتْکْشَناتْ تانْیَنْکُرِتانِ، ");
INSERT INTO sanurd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","کِنْتُ رَواوُدِتے دَگْدھانِ تیشاں مُولاپْرَوِشْٹَتْواتْ شُشْکَتاں گَتانِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","اَپَرَں کَتِپَیَبِیجیشُ کَنْٹَکاناں مَدھْیے پَتِتیشُ کَنْٹَکانْییدھِتْوا تانِ جَگْرَسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","اَپَرَنْچَ کَتِپَیَبِیجانِ اُرْوَّرایاں پَتِتانِ؛ تیشاں مَدھْیے کانِچِتْ شَتَگُنانِ کانِچِتْ شَشْٹِگُنانِ کانِچِتْ تْرِںشَگُںنانِ پھَلانِ پھَلِتَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","شْروتُں یَسْیَ شْرُتِی آساتے سَ شرِنُیاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","اَنَنْتَرَں شِشْیَیراگَتْیَ سوپرِچّھیَتَ، بھَوَتا تیبھْیَح کُتو درِشْٹانْتَکَتھا کَتھْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","تَتَح سَ پْرَتْیَوَدَتْ، سْوَرْگَراجْیَسْیَ نِگُوڈھاں کَتھاں ویدِتُں یُشْمَبھْیَں سامَرْتھْیَمَدایِ، کِنْتُ تیبھْیو نادایِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","یَسْمادْ یَسْیانْتِکے وَرْدّھَتے، تَسْماییوَ دایِشْیَتے، تَسْماتْ تَسْیَ باہُلْیَں بھَوِشْیَتِ، کِنْتُ یَسْیانْتِکے نَ وَرْدّھَتے، تَسْیَ یَتْ کِنْچَناسْتے، تَدَپِ تَسْمادْ آدایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","تے پَشْیَنْتوپِ نَ پَشْیَنْتِ، شرِنْوَنْتوپِ نَ شرِنْوَنْتِ، بُدھْیَمانا اَپِ نَ بُدھْیَنْتے چَ، تَسْماتْ تیبھْیو درِشْٹانْتَکَتھا کَتھْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","یَتھا کَرْنَیح شْروشْیَتھَ یُویَں وَے کِنْتُ یُویَں نَ بھوتْسْیَتھَ۔ نیتْرَیرْدْرَکْشْیَتھَ یُویَنْچَ پَرِجْناتُں نَ شَکْشْیَتھَ۔ تے مانُشا یَتھا نَیوَ پَرِپَشْیَنْتِ لوچَنَیح۔ کَرْنَے رْیَتھا نَ شرِنْوَنْتِ نَ بُدھْیَنْتے چَ مانَسَیح۔ وْیاوَرْتِّتیشُ چِتّیشُ کالے کُتْراپِ تَیرْجَنَیح۔ مَتَّسْتے مَنُجاح سْوَسْتھا یَتھا نَیوَ بھَوَنْتِ چَ۔ تَتھا تیشاں مَنُشْیاناں کْرِیَنْتے سْتھُولَبُدّھَیَح۔ بَدھِرِیبھُوتَکَرْناشْچَ جاتاشْچَ مُدْرِتا درِشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","یَدیتانِ وَچَنانِ یِشَیِیَبھَوِشْیَدْوادِنا پْروکْتانِ تیشُ تانِ پھَلَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","کِنْتُ یُشْماکَں نَیَنانِ دھَنْیانِ، یَسْماتْ تانِ وِیکْشَنْتے؛ دھَنْیاشْچَ یُشْماکَں شَبْدَگْرَہاح، یَسْماتْ تَیراکَرْنْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","مَیا یُویَں تَتھْیَں وَچامِ یُشْمابھِ رْیَدْیَدْ وِیکْشْیَتے، تَدْ بَہَوو بھَوِشْیَدْوادِنو دھارْمِّکاشْچَ مانَوا دِدرِکْشَنْتوپِ دْرَشْٹُں نالَبھَنْتَ، پُنَشْچَ یُویَں یَدْیَتْ شرِنُتھَ، تَتْ تے شُشْرُوشَمانا اَپِ شْروتُں نالَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","کرِشِیوَلِییَدرِشْٹانْتَسْیارْتھَں شرِنُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","مارْگَپارْشْوے بِیجانْیُپْتانِ تَسْیارْتھَ ایشَح، یَدا کَشْچِتْ راجْیَسْیَ کَتھاں نِشَمْیَ نَ بُدھْیَتے، تَدا پاپاتْماگَتْیَ تَدِییَمَنَسَ اُپْتاں کَتھاں ہَرَنْ نَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","اَپَرَں پاشانَسْتھَلے بِیجانْیُپْتانِ تَسْیارْتھَ ایشَح؛ کَشْچِتْ کَتھاں شْرُتْوَیوَ ہَرْشَچِتّینَ گرِہْلاتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","کِنْتُ تَسْیَ مَنَسِ مُولاپْرَوِشْٹَتْواتْ سَ کِنْچِتْکالَماتْرَں سْتھِرَسْتِشْٹھَتِ؛ پَشْچاتَ تَتْکَتھاکارَناتْ کوپِ کْلیسْتاڈَنا وا چیتْ جایَتے، تَرْہِ سَ تَتْکْشَنادْ وِگھْنَمیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","اَپَرَں کَنْٹَکاناں مَدھْیے بِیجانْیُپْتانِ تَدَرْتھَ ایشَح؛ کینَچِتْ کَتھایاں شْرُتایاں ساںسارِکَچِنْتابھِ رْبھْرانْتِبھِشْچَ سا گْرَسْیَتے، تینَ سا ما وِپھَلا بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","اَپَرَمْ اُرْوَّرایاں بِیجانْیُپْتانِ تَدَرْتھَ ایشَح؛ یے تاں کَتھاں شْرُتْوا وُدھْیَنْتے، تے پھَلِتاح سَنْتَح کیچِتْ شَتَگُنانِ کیچِتَ شَشْٹِگُنانِ کیچِچَّ تْرِںشَدْگُنانِ پھَلانِ جَنَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","اَنَنْتَرَں سوپَرامیکاں درِشْٹانْتَکَتھامُپَسْتھاپْیَ تیبھْیَح کَتھَیاماسَ؛ سْوَرْگِییَراجْیَں تادرِشینَ کینَچِدْ گرِہَسْتھینوپَمِییَتے، یینَ سْوِییَکْشیتْرے پْرَشَسْتَبِیجانْیَوپْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","کِنْتُ کْشَنَدایاں سَکَلَلوکیشُ سُپْتیشُ تَسْیَ رِپُراگَتْیَ تیشاں گودھُومَبِیجاناں مَدھْیے وَنْیَیَوَمَبِیجانْیُپْتْوا وَوْراجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","تَتو یَدا بِیجیبھْیونْکَرا جایَماناح کَنِشانِ گھرِتَوَنْتَح؛ تَدا وَنْیَیَوَسانْیَپِ درِشْیَمانانْیَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","تَتو گرِہَسْتھَسْیَ داسییا آگَمْیَ تَسْمَے کَتھَیانْچَکْرُح، ہے مَہیچّھَ، بھَوَتا کِں کْشیتْرے بھَدْرَبِیجانِ نَوپْیَنْتَ؟ تَتھاتْوے وَنْیَیَوَسانِ کرِتَ آیَنْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","تَدانِیں تینَ تے پْرَتِگَدِتاح، کینَچِتْ رِپُنا کَرْمَّدَمَکارِ۔ داسییاح کَتھَیاماسُح، وَیَں گَتْوا تانْیُتْپایَّ کْشِپامو بھَوَتَح کِیدرِشِیچّھا جایَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","تیناوادِ، نَہِ، شَنْکےہَں وَنْیَیَوَسوتْپاٹَنَکالے یُشْمابھِسْتَیح ساکَں گودھُوما اَپْیُتْپاٹِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","اَتَح شْسْیَکَرْتَّنَکالَں یاوَدْ اُبھَیانْیَپِ سَہَ وَرْدّھَنْتاں، پَشْچاتْ کَرْتَّنَکالے کَرْتَّکانْ وَکْشْیامِ، یُویَمادَو وَنْیَیَوَسانِ سَںگرِہْیَ داہَیِتُں وِیٹِکا بَدْوّا سْتھاپَیَتَ؛ کِنْتُ سَرْوّے گودھُوما یُشْمابھِ رْبھانْڈاگارَں نِیتْوا سْتھاپْیَنْتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","اَنَنْتَرَں سوپَرامیکاں درِشْٹانْتَکَتھامُتّھاپْیَ تیبھْیَح کَتھِتَوانْ کَشْچِنْمَنُجَح سَرْشَپَبِیجَمیکَں نِیتْوا سْوَکْشیتْرَ اُواپَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","سَرْشَپَبِیجَں سَرْوَّسْمادْ بِیجاتْ کْشُدْرَمَپِ سَدَنْکُرِتَں سَرْوَّسْماتْ شاکاتْ برِہَدْ بھَوَتِ؛ سَ تادرِشَسْتَرُ رْبھَوَتِ، یَسْیَ شاکھاسُ نَبھَسَح کھَگا آگَتْیَ نِوَسَنْتِ؛ سْوَرْگِییَراجْیَں تادرِشَسْیَ سَرْشَپَیکَسْیَ سَمَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","پُنَرَپِ سَ اُپَماکَتھامیکاں تیبھْیَح کَتھَیانْچَکارَ؛ کاچَنَ یوشِتْ یَتْ کِنْوَمادایَ دْرونَتْرَیَمِتَگودھُومَچُورْناناں مَدھْیے سَرْوّیشاں مِشْرِیبھَوَنَپَرْیَّنْتَں سَماچّھادْیَ نِدھَتَّوَتِی، تَتْکِنْوَمِوَ سْوَرْگَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","اِتّھَں یِیشُ رْمَنُجَنِوَہاناں سَنِّدھاوُپَماکَتھابھِریتانْیاکھْیانانِ کَتھِتَوانْ اُپَماں وِنا تیبھْیَح کِمَپِ کَتھاں ناکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ایتینَ درِشْٹانْتِییینَ واکْیینَ وْیادایَ وَدَنَں نِجَں۔ اَہَں پْرَکاشَیِشْیامِ گُپْتَواکْیَں پُرابھَوَں۔ یَدیتَدْوَچَنَں بھَوِشْیَدْوادِنا پْروکْتَماسِیتْ، تَتْ سِدّھَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","سَرْوّانْ مَنُجانْ وِسرِجْیَ یِیشَو گرِہَں پْرَوِشْٹے تَچّھِشْیا آگَتْیَ یِیشَوے کَتھِتَوَنْتَح، کْشیتْرَسْیَ وَنْیَیَوَسِییَدرِشْٹانْتَکَتھامْ بھَوانَ اَسْمانْ سْپَشْٹِیکرِتْیَ وَدَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","تَتَح سَ پْرَتْیُواچَ، یینَ بھَدْرَبِیجانْیُپْیَنْتے سَ مَنُجَپُتْرَح، ");
INSERT INTO sanurd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","کْشیتْرَں جَگَتْ، بھَدْرَبِیجانِی راجْیَسْیَ سَنْتاناح، ");
INSERT INTO sanurd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","وَنْیَیَوَسانِ پاپاتْمَنَح سَنْتاناح۔ یینَ رِپُنا تانْیُپْتانِ سَ شَیَتانَح، کَرْتَّنَسَمَیَشْچَ جَگَتَح شیشَح، کَرْتَّکاح سْوَرْگِییَدُوتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","یَتھا وَنْیَیَوَسانِ سَںگرِہْیَ داہْیَنْتے، تَتھا جَگَتَح شیشے بھَوِشْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","اَرْتھاتْ مَنُجَسُتَح سْواںیَدُوتانْ پْریشَیِشْیَتِ، تینَ تے چَ تَسْیَ راجْیاتْ سَرْوّانْ وِگھْنَکارِنودھارْمِّکَلوکاںشْچَ سَںگرِہْیَ ");
INSERT INTO sanurd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","یَتْرَ رودَنَں دَنْتَگھَرْشَنَنْچَ بھَوَتِ، تَتْراگْنِکُنْڈے نِکْشیپْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","تَدانِیں دھارْمِّکَلوکاح سْویشاں پِتُو راجْیے بھاسْکَرَاِوَ تیجَسْوِنو بھَوِشْیَنْتِ۔ شْروتُں یَسْیَ شْرُتِی آساتے، مَ شرِنُیاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","اَپَرَنْچَ کْشیتْرَمَدھْیے نِدھِں پَشْیَنْ یو گوپَیَتِ، تَتَح پَرَں سانَنْدو گَتْوا سْوِییَسَرْوَّسْوَں وِکْرِییَ تَّکْشیتْرَں کْرِیناتِ، سَ اِوَ سْوَرْگَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","اَنْیَنْچَ یو وَنِکْ اُتَّماں مُکْتاں گَویشَیَنْ ");
INSERT INTO sanurd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","مَہارْگھاں مُکْتاں وِلوکْیَ نِجَسَرْوَّسْوَں وِکْرِییَ تاں کْرِیناتِ، سَ اِوَ سْوَرْگَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","پُنَشْچَ سَمُدْرو نِکْشِپْتَح سَرْوَّپْرَکارَمِینَسَںگْراہْیانایَاِوَ سْوَرْگَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","تَسْمِنْ آنایے پُورْنے جَنا یَتھا رودھَسْیُتّولْیَ سَمُپَوِشْیَ پْرَشَسْتَمِینانْ سَںگْرَہْیَ بھاجَنیشُ نِدَدھَتے، کُتْسِتانْ نِکْشِپَنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","تَتھَیوَ جَگَتَح شیشے بھَوِشْیَتِ، پھَلَتَح سْوَرْگِییَدُوتا آگَتْیَ پُنْیَوَجَّناناں مَدھْیاتْ پاپِنَح پرِتھَکْ کرِتْوا وَہْنِکُنْڈے نِکْشیپْسْیَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","تَتْرَ رودَنَں دَنْتَے رْدَنْتَگھَرْشَنَنْچَ بھَوِشْیَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","یِیشُنا تے پرِشْٹا یُشْمابھِح کِمیتانْیاکھْیانانْیَبُدھْیَنْتَ؟ تَدا تے پْرَتْیَوَدَنْ، سَتْیَں پْرَبھو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","تَدانِیں سَ کَتھِتَوانْ، نِجَبھانْڈاگاراتْ نَوِینَپُراتَنانِ وَسْتُونِ نِرْگَمَیَتِ یو گرِہَسْتھَح سَ اِوَ سْوَرْگَراجْیَمَدھِ شِکْشِتاح سْوَرْوَ اُپَدیشْٹارَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","اَنَنْتَرَں یِیشُریتاح سَرْوّا درِشْٹانْتَکَتھاح سَماپْیَ تَسْماتْ سْتھاناتْ پْرَتَسْتھے۔ اَپَرَں سْوَدیشَماگَتْیَ جَنانْ بھَجَنَبھَوَنَ اُپَدِشْٹَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","تے وِسْمَیَں گَتْوا کَتھِتَوَنْتَ ایتَسْیَیتادرِشَں جْنانَمْ آشْچَرْیَّں کَرْمَّ چَ کَسْمادْ اَجایَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","کِمَیَں سُوتْرَدھارَسْیَ پُتْرو نَہِ؟ ایتَسْیَ ماتُ رْنامَ چَ کِں مَرِیَمْ نَہِ؟ یاکُبْ-یُوشَپھْ-شِمونْ-یِہُوداشْچَ کِمیتَسْیَ بھْراتَرو نَہِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ایتَسْیَ بھَگِنْیَشْچَ کِمَسْماکَں مَدھْیے نَ سَنْتِ؟ تَرْہِ کَسْمادَیَمیتانِ لَبْدھَوانْ؟ اِتّھَں سَ تیشاں وِگھْنَرُوپو بَبھُووَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","تَتو یِیشُنا نِگَدِتَں سْوَدیشِییَجَناناں مَدھْیَں وِنا بھَوِشْیَدْوادِی کُتْراپْیَنْیَتْرَ ناسَمّانْیو بھَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","تیشامَوِشْواسَہیتوح سَ تَتْرَ سْتھانے بَہْواشْچَرْیَّکَرْمّانِ نَ کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","تَدانِیں راجا ہیرودْ یِیشو رْیَشَح شْرُتْوا نِجَداسییانْ جَگادْ، ");
INSERT INTO sanurd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ایشَ مَجَّیِتا یوہَنْ، پْرَمِتیبھَیَسْتَسْیوتّھاناتْ تینیتّھَمَدْبھُتَں کَرْمَّ پْرَکاشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","پُرا ہیرودْ نِجَبھْراتُ: پھِلِپو جایایا ہیرودِییایا اَنُرودھادْ یوہَنَں دھارَیِتْوا بَدّھا کارایاں سْتھاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","یَتو یوہَنْ اُکْتَوانْ، ایتْسَیاح سَںگْرَہو بھَوَتو نوچِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","تَسْماتْ نرِپَتِسْتَں ہَنْتُمِچّھَنَّپِ لوکیبھْیو وِبھَیانْچَکارَ؛ یَتَح سَرْوّے یوہَنَں بھَوِشْیَدْوادِنَں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","کِنْتُ ہیرودو جَنْماہِییَمَہَ اُپَسْتھِتے ہیرودِییایا دُہِتا تیشاں سَمَکْشَں نرِتِتْوا ہیرودَمَپْرِینْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","تَسْماتْ بھُوپَتِح شَپَتھَں کُرْوَّنْ اِتِ پْرَتْیَجْناسِیتْ، تْوَیا یَدْ یاچْیَتے، تَدیواہَں داسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","سا کُمارِی سْوِییَماتُح شِکْشاں لَبْدھا بَبھاشے، مَجَّیِتُرْیوہَنَ اُتَّمانْگَں بھاجَنے سَمانِییَ مَہْیَں وِشْرانَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","تَتو راجا شُشوچَ، کِنْتُ بھوجَنایوپَوِشَتاں سَنْگِناں سْوَکرِتَشَپَتھَسْیَ چانُرودھاتْ تَتْ پْرَداتُمَ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","پَشْچاتْ کاراں پْرَتِ نَرَں پْرَہِتْیَ یوہَنَ اُتَّمانْگَں چھِتّوا ");
INSERT INTO sanurd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","تَتْ بھاجَنَ آنایَّ تَسْیَے کُمارْیَّے وْیَشْرانَیَتْ، تَتَح سا سْوَجَنَنْیاح سَمِیپَں تَنِّنایَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","پَشْچاتْ یوہَنَح شِشْیا آگَتْیَ کایَں نِیتْوا شْمَشانے سْتھاپَیاماسُسْتَتو یِیشوح سَنِّدھِں وْرَجِتْوا تَدْوارْتّاں بَبھاشِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","اَنَنْتَرَں یِیشُرِتِ نِشَبھْیَ ناوا نِرْجَنَسْتھانَمْ ایکاکِی گَتَوانْ، پَشْچاتْ مانَواسْتَتْ شْرُتْوا نانانَگَریبھْیَ آگَتْیَ پَدَیسْتَتْپَشْچادْ اِییُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","تَدانِیں یِیشُ رْبَہِراگَتْیَ مَہانْتَں جَنَنِوَہَں نِرِیکْشْیَ تیشُ کارُنِکَح مَنْ تیشاں پِیڈِتَجَنانْ نِرامَیانْ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","تَتَح پَرَں سَنْدھْیایاں شِشْیاسْتَدَنْتِکَماگَتْیَ کَتھَیانْچَکْرُح، اِدَں نِرْجَنَسْتھانَں ویلاپْیَوَسَنّا؛ تَسْماتْ مَنُجانْ سْوَسْوَگْرامَں گَنْتُں سْوارْتھَں بھَکْشْیانِ کْریتُنْچَ بھَوانْ تانْ وِسرِجَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","کِنْتُ یِیشُسْتانَوادِیتْ، تیشاں گَمَنے پْرَیوجَنَں ناسْتِ، یُویَمیوَ تانْ بھوجَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","تَدا تے پْرَتْیَوَدَنْ، اَسْماکَمَتْرَ پُوپَپَنْچَکَں مِینَدْوَیَنْچاسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","تَدانِیں تینوکْتَں تانِ مَدَنْتِکَمانَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","اَنَنْتَرَں سَ مَنُجانْ یَوَسوپَرْیُّپَویشْٹُمْ آجْناپَیاماسَ؛ اَپَرَ تَتْ پُوپَپَنْچَکَں مِینَدْوَیَنْچَ گرِہْلَنْ سْوَرْگَں پْرَتِ نِرِیکْشْییشْوَرِییَگُنانْ اَنُودْیَ بھَںکْتْوا شِشْییبھْیو دَتَّوانْ، شِشْیاشْچَ لوکیبھْیو دَدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","تَتَح سَرْوّے بھُکْتْوا پَرِترِپْتَوَنْتَح، تَتَسْتَدَوَشِشْٹَبھَکْشْیَیح پُورْنانْ دْوادَشَڈَلَکانْ گرِہِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","تے بھوکْتارَح سْتْرِیرْبالَکاںشْچَ وِہایَ پْرایینَ پَنْچَ سَہَسْرانِ پُماںسَ آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","تَدَنَنْتَرَں یِیشُ رْلوکاناں وِسَرْجَنَکالے شِشْیانْ تَرَنِماروڈھُں سْواگْرے پارَں یاتُنْچَ گاڈھَمادِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","تَتو لوکیشُ وِسرِشْٹیشُ سَ وِوِکْتے پْرارْتھَیِتُں گِرِمیکَں گَتْوا سَنْدھْیاں یاوَتْ تَتْرَیکاکِی سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","کِنْتُ تَدانِیں سَمُّکھَواتَتْواتْ سَرِتْپَتے رْمَدھْیے تَرَنْگَیسْتَرَنِرْدولایَمانابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","تَدا سَ یامِنْیاشْچَتُرْتھَپْرَہَرے پَدْبھْیاں وْرَجَنْ تیشامَنْتِکَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","کِنْتُ شِشْیاسْتَں ساگَروپَرِ وْرَجَنْتَں وِلوکْیَ سَمُدْوِگْنا جَگَدُح، ایشَ بھُوتَ اِتِ شَنْکَمانا اُچَّیح شَبْدایانْچَکْرِرے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","تَدَیوَ یِیشُسْتانَوَدَتْ، سُسْتھِرا بھَوَتَ، ما بھَیشْٹَ، ایشوہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","تَتَح پِتَرَ اِتْیُکْتَوانْ، ہے پْرَبھو، یَدِ بھَوانیوَ، تَرْہِ ماں بھَوَتْسَمِیپَں یاتُماجْناپَیَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","تَتَح تینادِشْٹَح پِتَرَسْتَرَنِتووَرُہْیَ یِیشےाرَنْتِکَں پْراپْتُں تویوپَرِ وَوْراجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","کِنْتُ پْرَچَنْڈَں پَوَنَں وِلوکْیَ بھَیاتْ تویے مَںکْتُمْ آریبھے، تَسْمادْ اُچَّیح شَبْدایَمانَح کَتھِتَوانْ، ہے پْرَبھو، مامَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","یِیشُسْتَتْکْشَناتْ کَرَں پْرَسارْیَّ تَں دھَرَنْ اُکْتَوانْ، ہَ سْتوکَپْرَتْیَیِنْ تْوَں کُتَح سَمَشیتھاح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","اَنَنْتَرَں تَیوسْتَرَنِمارُوڈھَیوح پَوَنو نِوَورِتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","تَدانِیں یے تَرَنْیاماسَنْ، تَ آگَتْیَ تَں پْرَنَبھْیَ کَتھِتَوَنْتَح، یَتھارْتھَسْتْوَمیویشْوَرَسُتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","اَنَنْتَرَں پارَں پْراپْیَ تے گِنیشَرَنّامَکَں نَگَرَمُپَتَسْتھُح، ");
INSERT INTO sanurd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","تَدا تَتْرَتْیا جَنا یِیشُں پَرِچِییَ تَدّیشْسْیَ چَتُرْدِشو وارْتّاں پْرَہِتْیَ یَتْرَ یاوَنْتَح پِیڈِتا آسَنْ، تاوَتَایوَ تَدَنْتِکَمانَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","اَپَرَں تَدِییَوَسَنَسْیَ گْرَنْتھِماتْرَں سْپْرَشْٹُں وِنِییَ یاوَنْتو جَناسْتَتْ سْپَرْشَں چَکْرِرے، تے سَرْوَّایوَ نِرامَیا بَبھُووُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","اَپَرَں یِرُوشالَمْنَگَرِییاح کَتِپَیا اَدھْیاپَکاح پھِرُوشِنَشْچَ یِیشوح سَمِیپَماگَتْیَ کَتھَیاماسُح، ");
INSERT INTO sanurd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","تَوَ شِشْیاح کِمَرْتھَمْ اَپْرَکْشالِتَکَرَے رْبھَکْشِتْوا پَرَمْپَراگَتَں پْراچِیناناں وْیَوَہارَں لَنْوَنْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","تَتو یِیشُح پْرَتْیُواچَ، یُویَں پَرَمْپَراگَتاچارینَ کُتَ اِیشْوَراجْناں لَنْوَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","اِیشْوَرَ اِتْیاجْناپَیَتْ، تْوَں نِجَپِتَرَو سَںمَنْییتھاح، یینَ چَ نِجَپِتَرَو نِنْدْییتے، سَ نِشْچِتَں مْرِییتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","کِنْتُ یُویَں وَدَتھَ، یَح سْوَجَنَکَں سْوَجَنَنِیں وا واکْیَمِدَں وَدَتِ، یُواں مَتّو یَلَّبھیتھے، تَتْ نْیَوِدْیَتَ، ");
INSERT INTO sanurd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","سَ نِجَپِتَرَو پُنَ رْنَ سَںمَںسْیَتے۔ اِتّھَں یُویَں پَرَمْپَراگَتینَ سْویشاماچارینیشْوَرِییاجْناں لُمْپَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","رے کَپَٹِنَح سَرْوّے یِشَیِیو یُشْمانَدھِ بھَوِشْیَدْوَچَنانْییتانِ سَمْیَگْ اُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","وَدَنَے رْمَنُجا ایتے سَمایانْتِ مَدَنْتِکَں۔ تَتھادھَرَے رْمَدِییَنْچَ مانَں کُرْوَّنْتِ تے نَراح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","کِنْتُ تیشاں مَنو مَتّو وِدُورَایوَ تِشْٹھَتِ۔ شِکْشَیَنْتو وِدھِینْ نْراجْنا بھَجَنْتے ماں مُدھَیوَ تے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","تَتو یِیشُ رْلوکانْ آہُویَ پْروکْتَوانْ، یُویَں شْرُتْوا بُدھْیَدھْبَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","یَنْمُکھَں پْرَوِشَتِ، تَتْ مَنُجَمْ اَمیدھْیَں نَ کَروتِ، کِنْتُ یَداسْیاتْ نِرْگَچّھَتِ، تَدیوَ مانُشَمَمیدھْیِی کَروتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","تَدانِیں شِشْیا آگَتْیَ تَسْمَے کَتھَیانْچَکْرُح، ایتاں کَتھاں شْرُتْوا پھِرُوشِنو وْیَرَجْیَنْتَ، تَتْ کِں بھَوَتا جْنایَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","سَ پْرَتْیَوَدَتْ، مَمَ سْوَرْگَسْتھَح پِتا یَں کَنْچِدَنْکُرَں ناروپَیَتْ، سَ اُتْپاوْدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","تے تِشْٹھَنْتُ، تے اَنْدھَمَنُجانامْ اَنْدھَمارْگَدَرْشَکا ایوَ؛ یَدْیَنْدھونْدھَں پَنْتھانَں دَرْشَیَتِ، تَرْہْیُبھَو گَرْتّے پَتَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","تَدا پِتَرَسْتَں پْرَتْیَوَدَتْ، درِشْٹانْتَمِمَمَسْمانْ بودھَیَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","یِیشُنا پْروکْتَں، یُویَمَدْیَ یاوَتْ کِمَبودھاح سْتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","کَتھامِماں کِں نَ بُدھْیَدھْبے ؟ یَداسْیَں پْریوِشَتِ، تَدْ اُدَرے پَتَنْ بَہِرْنِرْیاتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","کِنْتْواسْیادْ یَنِّرْیاتِ، تَدْ اَنْتَحکَرَناتْ نِرْیاتَتْواتْ مَنُجَمَمیدھْیَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","یَتونْتَحکَرَناتْ کُچِنْتا بَدھَح پارَدارِکَتا ویشْیاگَمَنَں چَیرْیَّں مِتھْیاساکْشْیَمْ اِیشْوَرَنِنْدا چَیتانِ سَرْوّانِ نِرْیّانْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ایتانِ مَنُشْیَمَپَوِتْرِی کُرْوَّنْتِ کِنْتْوَپْرَکْشالِتَکَرینَ بھوجَنَں مَنُجَمَمیدھْیَں نَ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","اَنَنْتَرَں یِیشُسْتَسْماتْ سْتھاناتْ پْرَسْتھایَ سورَسِیدونَّگَرَیوح سِیمامُپَتَسْیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","تَدا تَتْسِیماتَح کاچِتْ کِنانِییا یوشِدْ آگَتْیَ تَمُچَّیرُواچَ، ہے پْرَبھو دایُودَح سَنْتانَ، مَمَیکا دُہِتاسْتے سا بھُوتَگْرَسْتا سَتِی مَہاکْلیشَں پْراپْنوتِ مَمَ دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","کِنْتُ یِیشُسْتاں کِمَپِ نوکْتَوانْ، تَتَح شِشْیا آگَتْیَ تَں نِویدَیاماسُح، ایشا یوشِدْ اَسْماکَں پَشْچادْ اُچَّیراہُویاگَچّھَتِ، ایناں وِسرِجَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","تَدا سَ پْرَتْیَوَدَتْ، اِسْراییلْگوتْرَسْیَ ہارِتَمیشانْ وِنا کَسْیاپْیَنْیَسْیَ سَمِیپَں ناہَں پْریشِتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","تَتَح سا نارِیسَماگَتْیَ تَں پْرَنَمْیَ جَگادَ، ہے پْرَبھو مامُپَکُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","سَ اُکْتَوانْ، بالَکاناں بھَکْشْیَمادایَ سارَمیییبھْیو دانَں نوچِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","تَدا سا بَبھاشے، ہے پْرَبھو، تَتْ سَتْیَں، تَتھاپِ پْرَبھو رْبھَنْچادْ یَدُچّھِشْٹَں پَتَتِ، تَتْ سارَمییاح کھادَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","تَتو یِیشُح پْرَتْیَوَدَتْ، ہے یوشِتْ، تَوَ وِشْواسو مَہانْ تَسْماتْ تَوَ مَنوبھِلَشِتَں سِدْیَّتُ، تینَ تَسْیاح کَنْیا تَسْمِنّیوَ دَنْڈے نِرامَیابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","اَنَنْتَرَں یِیشَسْتَسْماتْ سْتھاناتْ پْرَسْتھایَ گالِیلْساگَرَسْیَ سَنِّدھِماگَتْیَ دھَرادھَرَمارُہْیَ تَتْروپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","پَشْچاتْ جَنَنِوَہو بَہُونْ کھَنْچانْدھَمُوکَشُشْکَکَرَمانُشانْ آدایَ یِیشوح سَمِیپَماگَتْیَ تَچَّرَنانْتِکے سْتھاپَیاماسُح، تَتَح سا تانْ نِرامَیانْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","اِتّھَں مُوکا واکْیَں وَدَنْتِ، شُشْکَکَراح سْواسْتھْیَمایانْتِ، پَنْگَوو گَچّھَنْتِ، اَنْدھا وِیکْشَنْتے، اِتِ وِلوکْیَ لوکا وِسْمَیَں مَنْیَمانا اِسْراییلَ اِیشْوَرَں دھَنْیَں بَبھاشِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","تَدانِیں یِیشُح سْوَشِشْیانْ آہُویَ گَدِتَوانْ، ایتَجَّنَنِوَہیشُ مَمَ دَیا جایَتے، ایتے دِنَتْرَیَں مَیا ساکَں سَنْتِ، ایشاں بھَکْشْیَوَسْتُ چَ کَنْچِدَپِ ناسْتِ، تَسْمادَہَمیتانَکرِتاہارانْ نَ وِسْرَکْشْیامِ، تَتھاتْوے وَرْتْمَمَدھْیے کْلامْییشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","تَدا شِشْیا اُوچُح، ایتَسْمِنْ پْرانْتَرَمَدھْیَ ایتاوَتو مَرْتْیانْ تَرْپَیِتُں وَیَں کُتْرَ پُوپانْ پْراپْسْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","یِیشُرَپرِچّھَتْ، یُشْماکَں نِکَٹے کَتِ پُوپا آسَتے؟ تَ اُوچُح، سَپْتَپُوپا اَلْپاح کْشُدْرَمِیناشْچَ سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","تَدانِیں سَ لوکَنِوَہَں بھُوماوُپَویشْٹُمْ آدِشْیَ ");
INSERT INTO sanurd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","تانْ سَپْتَپُوپانْ مِیناںشْچَ گرِہْلَنْ اِیشْوَرِییَگُنانْ اَنُودْیَ بھَںکْتْوا شِشْییبھْیو دَدَو، شِشْیا لوکیبھْیو دَدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","تَتَح سَرْوّے بھُکْتْوا ترِپْتَوَنْتَح؛ تَدَوَشِشْٹَبھَکْشْیینَ سَپْتَڈَلَکانْ پَرِپُورْیَّ سَںجَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","تے بھوکْتارو یوشِتو بالَکاںشْچَ وِہایَ پْرایینَ چَتُحسَہَسْرانِ پُرُشا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","تَتَح پَرَں سَ جَنَنِوَہَں وِسرِجْیَ تَرِمارُہْیَ مَگْدَلاپْرَدیشَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","تَدانِیں پھِرُوشِنَح سِدُوکِنَشْچاگَتْیَ تَں پَرِیکْشِتُں نَبھَمِییَں کِنْچَنَ لَکْشْمَ دَرْشَیِتُں تَسْمَے نِویدَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","تَتَح سَ اُکْتَوانْ، سَنْدھْیایاں نَبھَسو رَکْتَتْوادْ یُویَں وَدَتھَ، شْوو نِرْمَّلَں دِنَں بھَوِشْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","پْراتَحکالے چَ نَبھَسو رَکْتَتْواتْ مَلِنَتْوانْچَ وَدَتھَ، جھَنْبھْشَدْیَ بھَوِشْیَتِ۔ ہے کَپَٹِنو یَدِ یُویَمْ اَنْتَرِیکْشَسْیَ لَکْشْمَ بودّھُں شَکْنُتھَ، تَرْہِ کالَسْیَیتَسْیَ لَکْشْمَ کَتھَں بودّھُں نَ شَکْنُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ایتَتْکالَسْیَ دُشْٹو وْیَبھِچارِی چَ وَںشو لَکْشْمَ گَویشَیَتِ، کِنْتُ یُونَسو بھَوِشْیَدْوادِنو لَکْشْمَ وِنانْیَتْ کِمَپِ لَکْشْمَ تانْ نَ دَرْشَیِیَّتے۔ تَدانِیں سَ تانْ وِہایَ پْرَتَسْتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","اَنَنْتَرَمَنْیَپارَگَمَنَکالے تَسْیَ شِشْیاح پُوپَمانیتُں وِسْمرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","یِیشُسْتانَوادِیتْ، یُویَں پھِرُوشِناں سِدُوکِنانْچَ کِنْوَں پْرَتِ ساوَدھاناح سَتَرْکاشْچَ بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","تینَ تے پَرَسْپَرَں وِوِچْیَ کَتھَیِتُماریبھِرے، وَیَں پُوپانانیتُں وِسْمرِتَوَنْتَ ایتَتْکارَنادْ اِتِ کَتھَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","کِنْتُ یِیشُسْتَدْوِجْنایَ تانَووچَتْ، ہے سْتوکَوِشْواسِنو یُویَں پُوپانانَیَنَمَدھِ کُتَح پَرَسْپَرَمیتَدْ وِوِںکْیَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","یُشْمابھِح کِمَدْیاپِ نَ جْنایَتے؟ پَنْچَبھِح پُوپَیح پَنْچَسَہَسْرَپُرُشیشُ بھوجِتیشُ بھَکْشْیوچّھِشْٹَپُورْنانْ کَتِ ڈَلَکانْ سَمَگرِہْلِیتَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","تَتھا سَپْتَبھِح پُوپَیشْچَتُحسَہَسْرَپُرُشیشُ بھیجِتیشُ کَتِ ڈَلَکانْ سَمَگرِہْلِیتَ، تَتْ کِں یُشْمابھِرْنَ سْمَرْیَّتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","تَسْماتْ پھِرُوشِناں سِدُوکِنانْچَ کِنْوَں پْرَتِ ساوَدھاناسْتِشْٹھَتَ، کَتھامِمامْ اَہَں پُوپانَدھِ ناکَتھَیَں، ایتَدْ یُویَں کُتو نَ بُدھْیَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","تَدانِیں پُوپَکِنْوَں پْرَتِ ساوَدھاناسْتِشْٹھَتیتِ نوکْتْوا پھِرُوشِناں سِدُوکِنانْچَ اُپَدیشَں پْرَتِ ساوَدھاناسْتِشْٹھَتیتِ کَتھِتَوانْ، اِتِ تَیرَبودھِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","اَپَرَنْچَ یِیشُح کَیسَرِیا-پھِلِپِپْرَدیشَماگَتْیَ شِشْیانْ اَپرِچّھَتْ، یوہَں مَنُجَسُتَح سوہَں کَح؟ لوکَیرَہَں کِمُچْیے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","تَدانِیں تے کَتھِتَوَنْتَح، کیچِدْ وَدَنْتِ تْوَں مَجَّیِتا یوہَنْ، کیچِدْوَدَنْتِ، تْوَمْ ایلِیَح، کیچِچَّ وَدَنْتِ، تْوَں یِرِمِیو وا کَشْچِدْ بھَوِشْیَدْوادِیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","پَشْچاتْ سَ تانْ پَپْرَچّھَ، یُویَں ماں کَں وَدَتھَ؟ تَتَح شِمونْ پِتَرَ اُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","تْوَمَمَریشْوَرَسْیابھِشِکْتَپُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","تَتو یِیشُح کَتھِتَوانْ، ہے یُونَسَح پُتْرَ شِمونْ تْوَں دھَنْیَح؛ یَتَح کوپِ اَنُجَسْتْوَیّیتَجّنانَں نودَپادَیَتْ، کِنْتُ مَمَ سْوَرْگَسْیَح پِتودَپادَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","اَتوہَں تْواں وَدامِ، تْوَں پِتَرَح (پْرَسْتَرَح) اَہَنْچَ تَسْیَ پْرَسْتَرَسْیوپَرِ سْوَمَنْڈَلِیں نِرْمّاسْیامِ، تینَ نِرَیو بَلاتْ تاں پَراجیتُں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","اَہَں تُبھْیَں سْوَرْگِییَراجْیَسْیَ کُنْجِکاں داسْیامِ، تینَ یَتْ کِنْچَنَ تْوَں پرِتھِوْیاں بھَںتْسْیَسِ تَتْسْوَرْگے بھَںتْسْیَتے، یَچَّ کِنْچَنَ مَہْیاں موکْشْیَسِ تَتْ سْوَرْگے موکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","پَشْچاتْ سَ شِشْیانادِشَتْ، اَہَمَبھِشِکْتو یِیشُرِتِ کَتھاں کَسْمَیچِدَپِ یُویَں ما کَتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","اَنْیَنْچَ یِرُوشالَمْنَگَرَں گَتْوا پْراچِینَلوکیبھْیَح پْرَدھانَیاجَکیبھْیَ اُپادھْیاییبھْیَشْچَ بَہُدُحکھَبھوگَسْتَے رْہَتَتْوَں ترِتِییَدِنے پُنَرُتّھانَنْچَ مَماوَشْیَکَمْ ایتاح کَتھا یِیشُسْتَتْکالَمارَبھْیَ شِشْیانْ جْناپَیِتُمْ آرَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","تَدانِیں پِتَرَسْتَسْیَ کَرَں گھرِتْوا تَرْجَیِتْوا کَتھَیِتُمارَبْدھَوانْ، ہے پْرَبھو، تَتْ تْوَتّو دُورَں یاتُ، تْواں پْرَتِ کَداپِ نَ گھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","کِنْتُ سَ وَدَنَں پَراوَرْتْیَ پِتَرَں جَگادَ، ہے وِگھْنَکارِنْ، مَتْسَمُّکھادْ دُورِیبھَوَ، تْوَں ماں بادھَسے، اِیشْوَرِییَکارْیّاتْ مانُشِییَکارْیَّں تُبھْیَں روچَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","اَنَنْتَرَں یِیشُح سْوِییَشِشْیانْ اُکْتَوانْ یَح کَشْچِتْ مَمَ پَشْچادْگامِی بھَوِتُمْ اِچّھَتِ، سَ سْوَں دامْیَتُ، تَتھا سْوَکْرُشَں گرِہْلَنْ مَتْپَشْچادایاتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","یَتو یَح پْرانانْ رَکْشِتُمِچّھَتِ، سَ تانْ ہارَیِشْیَتِ، کِنْتُ یو مَدَرْتھَں نِجَپْرانانْ ہارَیَتِ، سَ تانْ پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","مانُشو یَدِ سَرْوَّں جَگَتْ لَبھَتے نِجَپْرَنانْ ہارَیَتِ، تَرْہِ تَسْیَ کو لابھَح؟ مَنُجو نِجَپْراناناں وِنِمَیینَ وا کِں داتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","مَنُجَسُتَح سْوَدُوتَیح ساکَں پِتُح پْرَبھاویناگَمِشْیَتِ؛ تَدا پْرَتِمَنُجَں سْوَسْوَکَرْمّانُساراتْ پھَلَں داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","اَہَں یُشْمانْ تَتھْیَں وَچْمِ، سَراجْیَں مَنُجَسُتَمْ آگَتَں نَ پَشْیَنْتو مرِتْیُں نَ سْوادِشْیَنْتِ، ایتادرِشاح کَتِپَیَجَنا اَتْراپِ دَنْڈایَماناح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","اَنَنْتَرَں شَڈْدِنیبھْیَح پَرَں یِیشُح پِتَرَں یاکُوبَں تَتْسَہَجَں یوہَنَنْچَ گرِہْلَنْ اُچّادْرے رْوِوِکْتَسْتھانَمْ آگَتْیَ تیشاں سَمَکْشَں رُوپَمَنْیَتْ دَدھارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","تینَ تَداسْیَں تیجَسْوِ، تَدابھَرَنَمْ آلوکَوَتْ پانْڈَرَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","اَنْیَچَّ تینَ ساکَں سَںلَپَنْتَو مُوسا ایلِیَشْچَ تیبھْیو دَرْشَنَں دَدَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","تَدانِیں پِتَرو یِیشُں جَگادَ، ہے پْرَبھو سْتھِتِرَتْراسْماکَں شُبھا، یَدِ بھَوَتانُمَنْیَتے، تَرْہِ بھَوَدَرْتھَمیکَں مُوسارْتھَمیکَمْ ایلِیارْتھَنْچَیکَمْ اِتِ تْرِینِ دُوشْیانِ نِرْمَّمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ایتَتْکَتھَنَکالَ ایکَ اُجَّوَلَح پَیودَسْتیشامُپَرِ چھایاں کرِتَوانْ، وارِدادْ ایشا نَبھَسِییا واگْ بَبھُووَ، مَمایَں پْرِیَح پُتْرَح، اَسْمِنْ مَمَ مَہاسَنْتوشَ ایتَسْیَ واکْیَں یُویَں نِشامَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","کِنْتُ واچَمیتاں شرِنْوَنْتَایوَ شِشْیا مرِشَں شَنْکَمانا نْیُبْجا نْیَپَتَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","تَدا یِیشُراگَتْیَ تیشاں گاتْرانِ سْپرِشَنْ اُواچَ، اُتِّشْٹھَتَ، ما بھَیشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","تَدانِیں نیتْرانْیُنْمِیلْیَ یِیشُں وِنا کَمَپِ نَ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","تَتَح پَرَمْ اَدْریرَوَروہَنَکالے یِیشُسْتانْ اِتْیادِدیشَ، مَنُجَسُتَسْیَ مرِتاناں مَدھْیادُتّھانَں یاوَنَّ جایَتے، تاوَتْ یُشْمابھِریتَدَّرْشَنَں کَسْمَیچِدَپِ نَ کَتھَیِتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","تَدا شِشْیاسْتَں پَپْرَچّھُح، پْرَتھَمَمْ ایلِیَ آیاسْیَتِیتِ کُتَ اُپادھْیایَیرُچْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","تَتو یِیشُح پْرَتْیَوادِیتْ، ایلِیَح پْراگیتْیَ سَرْوّانِ سادھَیِشْیَتِیتِ سَتْیَں، ");
INSERT INTO sanurd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","کِنْتْوَہَں یُشْمانْ وَچْمِ، ایلِیَ ایتْیَ گَتَح، تے تَمَپَرِچِتْیَ تَسْمِنْ یَتھیچّھَں وْیَوَجَہُح؛ مَنُجَسُتیناپِ تیشامَنْتِکے تادرِگْ دُحکھَں بھوکْتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","تَدانِیں سَ مَجَّیِتارَں یوہَنَمَدھِ کَتھامیتاں وْیاہرِتَوانْ، اِتّھَں تَچّھِشْیا بُبُدھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","پَشْچاتْ تیشُ جَنَنِوَہَسْیانْتِکَماگَتیشُ کَشْچِتْ مَنُجَسْتَدَنْتِکَمیتْیَ جانُونِی پاتَیِتْوا کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ہے پْرَبھو، مَتْپُتْرَں پْرَتِ کرِپاں وِدَدھاتُ، سوپَسْمارامَیینَ بھرِشَں وْیَتھِتَح سَنْ پُنَح پُنَ رْوَہْنَو مُہُ رْجَلَمَدھْیے پَتَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","تَسْمادْ بھَوَتَح شِشْیاناں سَمِیپے تَمانَیَں کِنْتُ تے تَں سْواسْتھَں کَرْتُّں نَ شَکْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","تَدا یِیشُح کَتھِتَوانْ رے اَوِشْواسِنَح، رے وِپَتھَگامِنَح، پُنَح کَتِکالانْ اَہَں یُشْماکَں سَنِّدھَو سْتھاسْیامِ؟ کَتِکالانْ وا یُشْمانْ سَہِشْیے؟ تَمَتْرَ مَمانْتِکَمانَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","پَشْچادْ یِیشُنا تَرْجَتَایوَ سَ بھُوتَسْتَں وِہایَ گَتَوانْ، تَدَّنْڈَایوَ سَ بالَکو نِرامَیوبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","تَتَح شِشْیا گُپْتَں یِیشُمُپاگَتْیَ بَبھاشِرے، کُتو وَیَں تَں بھُوتَں تْیاجَیِتُں نَ شَکْتاح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","یِیشُنا تے پْروکْتاح، یُشْماکَمَپْرَتْیَیاتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","یُشْمانَہَں تَتھْیَں وَچْمِ یَدِ یُشْماکَں سَرْشَپَیکَماتْروپِ وِشْواسو جایَتے، تَرْہِ یُشْمابھِرَسْمِنْ شَیلے تْوَمِتَح سْتھاناتْ تَتْ سْتھانَں یاہِیتِ بْرُوتے سَ تَدَیوَ چَلِشْیَتِ، یُشْماکَں کِمَپْیَسادھْیَنْچَ کَرْمَّ نَ سْتھاسْیاتِ۔ کِنْتُ پْرارْتھَنوپَواسَو وِنَیتادرِشو بھُوتو نَ تْیاجْییتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","اَپَرَں تیشاں گالِیلْپْرَدیشے بھْرَمَنَکالے یِیشُنا تے گَدِتاح، مَنُجَسُتو جَناناں کَریشُ سَمَرْپَیِشْیَتے تَے رْہَنِشْیَتے چَ، ");
INSERT INTO sanurd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","کِنْتُ ترِتِییےہ्ِنَ مَ اُتّھاپِشْیَتے، تینَ تے بھرِشَں دُحکھِتا بَبھُووَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","تَدَنَنْتَرَں تیشُ کَپھَرْناہُومْنَگَرَماگَتیشُ کَرَسَںگْراہِنَح پِتَرانْتِکَماگَتْیَ پَپْرَچّھُح، یُشْماکَں گُرُح کِں مَنْدِرارْتھَں کَرَں نَ دَداتِ؟ تَتَح پِتَرَح کَتھِتَوانْ دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","تَتَسْتَسْمِنْ گرِہَمَدھْیَماگَتے تَسْیَ کَتھاکَتھَناتْ پُورْوَّمیوَ یِیشُرُواچَ، ہے شِمونْ، میدِنْیا راجانَح سْوَسْواپَتْییبھْیَح کِں وِدیشِبھْیَح کیبھْیَح کَرَں گرِہْلَنْتِ؟ اَتْرَ تْوَں کِں بُدھْیَسے؟ تَتَح پِتَرَ اُکْتَوانْ، وِدیشِبھْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","تَدا یِیشُرُکْتَوانْ، تَرْہِ سَنْتانا مُکْتاح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","تَتھاپِ یَتھاسْمابھِسْتیشامَنْتَرایو نَ جَنْیَتے، تَتْکرِتے جَلَدھیسْتِیرَں گَتْوا وَڈِشَں کْشِپَ، تینادَو یو مِینَ اُتّھاسْیَتِ، تَں گھرِتْوا تَنْمُکھے موچِتے تولَکَیکَں رُوپْیَں پْراپْسْیَسِ، تَدْ گرِہِیتْوا تَوَ مَمَ چَ کرِتے تیبھْیو دیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","تَدانِیں شِشْیا یِیشوح سَمِیپَماگَتْیَ پرِشْٹَوَنْتَح سْوَرْگَراجْیے کَح شْریشْٹھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","تَتو یِیشُح کْشُدْرَمیکَں بالَکَں سْوَسَمِیپَمانِییَ تیشاں مَدھْیے نِدھایَ جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","یُشْمانَہَں سَتْیَں بْرَوِیمِ، یُویَں مَنووِنِمَیینَ کْشُدْرَبالَوَتْ نَ سَنْتَح سْوَرْگَراجْیَں پْرَویشْٹُں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","یَح کَشْچِدْ ایتَسْیَ کْشُدْرَبالَکَسْیَ سَمَماتْمانَں نَمْرِیکَروتِ، سَایوَ سْوَرْگَراجَیے شْریشْٹھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","یَح کَشْچِدْ ایتادرِشَں کْشُدْرَبالَکَمیکَں مَمَ نامْنِ گرِہْلاتِ، سَ مامیوَ گرِہْلاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","کِنْتُ یو جَنو مَیِ کرِتَوِشْواسانامیتیشاں کْشُدْرَپْرانِنامْ ایکَسْیاپِ وِدھْنِں جَنَیَتِ، کَنْٹھَبَدّھَپیشَنِیکَسْیَ تَسْیَ ساگَراگادھَجَلے مَجَّنَں شْرییَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","وِگھْناتْ جَگَتَح سَنْتاپو بھَوِشْیَتِ، وِگھْنووَشْیَں جَنَیِشْیَتے، کِنْتُ یینَ مَنُجینَ وِگھْنو جَنِشْیَتے تَسْیَیوَ سَنْتاپو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","تَسْماتْ تَوَ کَرَشْچَرَنو وا یَدِ تْواں بادھَتے، تَرْہِ تَں چھِتّوا نِکْشِپَ، دْوِکَرَسْیَ دْوِپَدَسْیَ وا تَوانَپْتَوَہْنَو نِکْشیپاتْ، کھَنْجَسْیَ وا چھِنَّہَسْتَسْیَ تَوَ جِیوَنے پْرَویشو وَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","اَپَرَں تَوَ نیتْرَں یَدِ تْواں بادھَتے، تَرْہِ تَدَپْیُتْپاوْیَ نِکْشِپَ، دْوِنیتْرَسْیَ نَرَکاگْنَو نِکْشیپاتْ کانَسْیَ تَوَ جِیوَنے پْرَویشو وَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","تَسْمادَوَدھَدّھَں، ایتیشاں کْشُدْرَپْرانِنامْ ایکَمَپِ ما تُچّھِیکُرُتَ، ");
INSERT INTO sanurd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","یَتو یُشْمانَہَں تَتھْیَں بْرَوِیمِ، سْوَرْگے تیشاں دُوتا مَمَ سْوَرْگَسْتھَسْیَ پِتُراسْیَں نِتْیَں پَشْیَنْتِ۔ ایوَں یے یے ہارِتاسْتانْ رَکْشِتُں مَنُجَپُتْرَ آگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","یُویَمَتْرَ کِں وِوِںگّھوے؟ کَسْیَچِدْ یَدِ شَتَں میشاح سَنْتِ، تیشامیکو ہارْیَّتے چَ، تَرْہِ سَ ایکونَشَتَں میشانْ وِہایَ پَرْوَّتَں گَتْوا تَں ہارِتَمیکَں کِں نَ مرِگَیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","یَدِ چَ کَداچِتْ تَنْمیشودّیشَں لَمَتے، تَرْہِ یُشْمانَہَں سَتْیَں کَتھَیامِ، سووِپَتھَگامِبھْیَ ایکونَشَتَمیشیبھْیوپِ تَدیکَہیتورَدھِکَمْ آہْلادَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","تَدْوَدْ ایتیشاں کْشُدْرَپْرااےिنامْ ایکوپِ نَشْیَتِیتِ یُشْماکَں سْوَرْگَسْتھَپِتُ رْنابھِمَتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","یَدْیَپِ تَوَ بھْراتا تْوَیِ کِمَپْیَپَرادھْیَتِ، تَرْہِ گَتْوا یُوَیورْدْوَیوح سْتھِتَیوسْتَسْیاپَرادھَں تَں جْناپَیَ۔ تَتْرَ سَ یَدِ تَوَ واکْیَں شرِنوتِ، تَرْہِ تْوَں سْوَبھْراتَرَں پْراپْتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","کِنْتُ یَدِ نَ شرِنوتِ، تَرْہِ دْوابھْیاں تْرِبھِ رْوا ساکْشِیبھِح سَرْوَّں واکْیَں یَتھا نِشْچِتَں جایَتے، تَدَرْتھَمْ ایکَں دْوَو وا ساکْشِنَو گرِہِیتْوا یاہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","تینَ سَ یَدِ تَیو رْواکْیَں نَ مانْیَتے، تَرْہِ سَماجَں تَجّناپَیَ، کِنْتُ یَدِ سَماجَسْیاپِ واکْیَں نَ مانْیَتے،تَرْہِ سَ تَوَ سَمِیپے دیوَپُوجَکَاِوَ چَنْڈالَاِوَ چَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","اَہَں یُشْمانْ سَتْیَں وَدامِ، یُشْمابھِح پرِتھِوْیاں یَدْ بَدھْیَتے تَتْ سْوَرْگے بھَںتْسْیَتے؛ میدِنْیاں یَتْ بھوچْیَتے، سْوَرْگےپِ تَتْ موکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","پُنَرَہَں یُشْمانْ وَدامِ، میدِنْیاں یُشْماکَں یَدِ دْواویکَواکْیِیبھُویَ کِنْچِتْ پْرارْتھَییتے، تَرْہِ مَمَ سْوَرْگَسْتھَپِتْرا تَتْ تَیوح کرِتے سَمْپَنَّں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","یَتو یَتْرَ دْوَو تْرَیو وا مَمَ نانِّ مِلَنْتِ، تَتْرَیواہَں تیشاں مَدھْیےسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","تَدانِیں پِتَرَسْتَتْسَمِیپَماگَتْیَ کَتھِتَوانْ ہے پْرَبھو، مَمَ بھْراتا مَمَ یَدْیَپَرادھْیَتِ، تَرْہِ تَں کَتِکرِتْوَح کْشَمِشْیے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","کِں سَپْتَکرِتْوَح؟ یِیشُسْتَں جَگادَ، تْواں کیوَلَں سَپْتَکرِتْوو یاوَتْ نَ وَدامِ، کِنْتُ سَپْتَتْیا گُنِتَں سَپْتَکرِتْوو یاوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","اَپَرَں نِجَداسَیح سَہَ جِگَنَیِشُح کَشْچِدْ راجیوَ سْوَرْگَراجَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","آرَبْدھے تَسْمِنْ گَنَنے سارْدّھَسَہَسْرَمُدْراپُورِتاناں دَشَسَہَسْرَپُٹَکانامْ ایکوگھَمَرْنَسْتَتْسَمَکْشَمانایِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","تَسْیَ پَرِشودھَنایَ دْرَوْیابھاواتْ پَرِشودھَنارْتھَں سَ تَدِییَبھارْیّاپُتْرادِسَرْوَّسْوَنْچَ وِکْرِییَتامِتِ تَتْپْرَبھُرادِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","تینَ سَ داسَسْتَسْیَ پادَیوح پَتَنْ پْرَنَمْیَ کَتھِتَوانْ ، ہے پْرَبھو بھَوَتا گھَیرْیّے کرِتے مَیا سَرْوَّں پَرِشودھِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","تَدانِیں داسَسْیَ پْرَبھُح سَکَرُنَح سَنْ سَکَلَرْنَں کْشَمِتْوا تَں تَتْیاجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","کِنْتُ تَسْمِنْ داسے بَہِ رْیاتے، تَسْیَ شَتَں مُدْراچَتُرْتھاںشانْ یو دھارَیَتِ، تَں سَہَداسَں درِشْدْوا تَسْیَ کَنْٹھَں نِشْپِیڈْیَ گَدِتَوانْ، مَمَ یَتْ پْراپْیَں تَتْ پَرِشودھَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","تَدا تَسْیَ سَہَداسَسْتَتْپادَیوح پَتِتْوا وِنِییَ بَبھاشے، تْوَیا دھَیرْیّے کرِتے مَیا سَرْوَّں پَرِشودھِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","تَتھاپِ سَ تَتْ نانَگِیکرِتْیَ یاوَتْ سَرْوَّمرِنَں نَ پَرِشودھِتَوانْ تاوَتْ تَں کارایاں سْتھاپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","تَدا تَسْیَ سَہَداساسْتَسْیَیتادرِگْ آچَرَنَں وِلوکْیَ پْرَبھوح سَمِیپَں گَتْوا سَرْوَّں ورِتّانْتَں نِویدَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","تَدا تَسْیَ پْرَبھُسْتَماہُویَ جَگادَ، رے دُشْٹَ داسَ، تْوَیا مَتْسَنِّدھَو پْرارْتھِتے مَیا تَوَ سَرْوَّمرِنَں تْیَکْتَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","یَتھا چاہَں تْوَیِ کَرُناں کرِتَوانْ، تَتھَیوَ تْوَتْسَہَداسے کَرُناکَرَنَں کِں تَوَ نوچِتَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","اِتِ کَتھَیِتْوا تَسْیَ پْرَبھُح کْرُدّھیَنْ نِجَپْراپْیَں یاوَتْ سَ نَ پَرِشودھِتَوانْ، تاوَتْ پْرَہارَکاناں کَریشُ تَں سَمَرْپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","یَدِ یُویَں سْوانْتَحکَرَنَیح سْوَسْوَسَہَجانامْ اَپَرادھانْ نَ کْشَمَدھْوے، تَرْہِ مَمَ سْوَرْگَسْیَح پِتاپِ یُشْمانْ پْرَتِیتّھَں کَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","اَنَنْتَرَمْ ایتاسُ کَتھاسُ سَماپْتاسُ یِیشُ رْگالِیلَپْرَدیشاتْ پْرَسْتھایَ یَرْدَنْتِیرَسْتھَں یِہُوداپْرَدیشَں پْراپْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","تَدا تَتْپَشْچاتْ جَنَنِوَہے گَتے سَ تَتْرَ تانْ نِرامَیانْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","تَدَنَنْتَرَں پھِرُوشِنَسْتَتْسَمِیپَماگَتْیَ پارِیکْشِتُں تَں پَپْرَچّھُح، کَسْمادَپِ کارَناتْ نَرینَ سْوَجایا پَرِتْیاجْیا نَ وا؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","سَ پْرَتْیُواچَ، پْرَتھَمَمْ اِیشْوَرو نَرَتْوینَ نارِیتْوینَ چَ مَنُجانْ سَسَرْجَ، تَسْماتْ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","مانُشَح سْوَپِتَرَو پَرِتْیَجْیَ سْوَپَتْنْیامْ آسَکْشْیَتے، تَو دْوَو جَناویکانْگَو بھَوِشْیَتَح، کِمیتَدْ یُشْمابھِ رْنَ پَٹھِتَمْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","اَتَسْتَو پُنَ رْنَ دْوَو تَیوریکانْگَتْوَں جاتَں، اِیشْوَرینَ یَچَّ سَمَیُجْیَتَ، مَنُجو نَ تَدْ بھِنْدْیاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","تَدانِیں تے تَں پْرَتْیَوَدَنْ، تَتھاتْوے تْیاجْیَپَتْرَں دَتّوا سْواں سْواں جایاں تْیَکْتُں وْیَوَسْتھاں مُوساح کَتھَں لِلیکھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","تَتَح سَ کَتھِتَوانْ، یُشْماکَں مَنَساں کاٹھِنْیادْ یُشْمانْ سْواں سْواں جایاں تْیَکْتُمْ اَنْوَمَنْیَتَ کِنْتُ پْرَتھَمادْ ایشو وِدھِرْناسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","اَتو یُشْمانَہَں وَدامِ، وْیَبھِچارَں وِنا یو نِجَجایاں تْیَجیتْ اَنْیانْچَ وِوَہیتْ، سَ پَرَدارانْ گَچّھَتِ؛ یَشْچَ تْیَکْتاں نارِیں وِوَہَتِ سوپِ پَرَداریشُ رَمَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","تَدا تَسْیَ شِشْیاسْتَں بَبھاشِرے، یَدِ سْوَجایَیا ساکَں پُںسَ ایتادرِکْ سَمْبَنْدھو جایَتے، تَرْہِ وِوَہَنَمیوَ نَ بھَدْرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","تَتَح سَ اُکْتَوانْ، ییبھْیَسْتَتْسامَرْتھْیَں آدایِ، تانْ وِنانْیَح کوپِ مَنُجَ ایتَنْمَتَں گْرَہِیتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","کَتِپَیا جَنَنَکْلِیبَح کَتِپَیا نَرَکرِتَکْلِیبَح سْوَرْگَراجْیایَ کَتِپَیاح سْوَکرِتَکْلِیباشْچَ سَنْتِ، یے گْرَہِیتُں شَکْنُوَنْتِ تے گرِہْلَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","اَپَرَمْ یَتھا سَ شِشُوناں گاتْریشُ ہَسْتَں دَتْوا پْرارْتھَیَتے، تَدَرْتھَں تَتْسَمِیںپَں شِشَوَ آنِییَنْتَ، تَتَ آنَیِترِنْ شِشْیاسْتِرَسْکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","کِنْتُ یِیشُرُواچَ، شِشَوو مَدَنْتِکَمْ آگَچّھَنْتُ، تانْ ما وارَیَتَ، ایتادرِشاں شِشُونامیوَ سْوَرْگَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","تَتَح سَ تیشاں گاتْریشُ ہَسْتَں دَتْوا تَسْماتْ سْتھاناتْ پْرَتَسْتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","اَپَرَمْ ایکَ آگَتْیَ تَں پَپْرَچّھَ، ہے پَرَمَگُرو، اَنَنْتایُح پْراپْتُں مَیا کِں کِں سَتْکَرْمَّ کَرْتَّوْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","تَتَح سَ اُواچَ، ماں پَرَمَں کُتو وَدَسِ؟ وِنیشْچَرَں نَ کوپِ پَرَمَح، کِنْتُ یَدْیَنَنْتایُح پْراپْتُں وانْچھَسِ، تَرْہْیاجْناح پالَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","تَدا سَ پرِشْٹَوانْ، کاح کا آجْناح؟ تَتو یِیشُح کَتھِتَوانْ، نَرَں ما ہَنْیاح، پَرَدارانْ ما گَچّھیح، ما چورَییح، مرِشاساکْشْیَں ما دَدْیاح، ");
INSERT INTO sanurd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","نِجَپِتَرَو سَںمَنْیَسْوَ، سْوَسَمِیپَواسِنِ سْوَوَتْ پْریمَ کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","سَ یُوا کَتھِتَوانْ، آ بالْیادْ ایتاح پالَیامِ، اِدانِیں کِں نْیُونَماسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","تَتو یِیشُرَوَدَتْ، یَدِ سِدّھو بھَوِتُں وانْچھَسِ، تَرْہِ گَتْوا نِجَسَرْوَّسْوَں وِکْرِییَ دَرِدْریبھْیو وِتَرَ، تَتَح سْوَرْگے وِتَّں لَپْسْیَسے؛ آگَچّھَ، مَتْپَشْچادْوَرْتِّی چَ بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ایتاں واچَں شْرُتْوا سَ یُوا سْوِییَبَہُسَمْپَتّے رْوِشَنَح سَنْ چَلِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","تَدا یِیشُح سْوَشِشْیانْ اَوَدَتْ، دھَنِناں سْوَرْگَراجْیَپْرَویشو مَہادُشْکَرَ اِتِ یُشْمانَہَں تَتھْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","پُنَرَپِ یُشْمانَہَں وَدامِ، دھَنِناں سْوَرْگَراجْیَپْرَویشاتْ سُوچِیچھِدْرینَ مَہانْگَگَمَنَں سُکَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","اِتِ واکْیَں نِشَمْیَ شِشْیا اَتِچَمَتْکرِتْیَ کَتھَیاماسُح؛ تَرْہِ کَسْیَ پَرِتْرانَں بھَوِتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","تَدا سَ تانْ درِشْدْوا کَتھَیاماسَ، تَتْ مانُشانامَشَکْیَں بھَوَتِ، کِنْتْوِیشْوَرَسْیَ سَرْوَّں شَکْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","تَدا پِتَرَسْتَں گَدِتَوانْ، پَشْیَ، وَیَں سَرْوَّں پَرِتْیَجْیَ بھَوَتَح پَشْچادْوَرْتِّنو بھَوامَ؛ وَیَں کِں پْراپْسْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","تَتو یِیشُح کَتھِتَوانْ، یُشْمانَہَں تَتھْیَں وَدامِ، یُویَں مَمَ پَشْچادْوَرْتِّنو جاتا اِتِ کارَناتْ نَوِینَسرِشْٹِکالے یَدا مَنُجَسُتَح سْوِییَیشْچَرْیَّسِںہاسَنَ اُپَویکْشْیَتِ، تَدا یُویَمَپِ دْوادَشَسِںہاسَنیشُوپَوِشْیَ اِسْراییلِییَدْوادَشَوَںشاناں وِچارَں کَرِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","اَنْیَچَّ یَح کَشْچِتْ مَمَ نامَکارَناتْ گرِہَں وا بھْراتَرَں وا بھَگِنِیں وا پِتَرَں وا ماتَرَں وا جایاں وا بالَکَں وا بھُومِں پَرِتْیَجَتِ، سَ تیشاں شَتَگُنَں لَپْسْیَتے، اَنَنْتایُمودھِکارِتْوَنْچَ پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","کِنْتُ اَگْرِییا اَنیکے جَناح پَشْچاتْ، پَشْچاتِییاشْچانیکے لوکا اَگْرے بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","سْوَرْگَراجْیَمْ ایتادرِشا کینَچِدْ گرِہَسْیینَ سَمَں، یوتِپْرَبھاتے نِجَدْراکْشاکْشیتْرے کرِشَکانْ نِیوکْتُں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","پَشْچاتْ تَیح ساکَں دِنَیکَبھرِتِں مُدْراچَتُرْتھاںشَں نِرُوپْیَ تانْ دْراکْشاکْشیتْرَں پْریرَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","اَنَنْتَرَں پْرَہَرَیکَویلایاں گَتْوا ہَٹّے کَتِپَیانْ نِشْکَرْمَّکانْ وِلوکْیَ تانَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","یُویَمَپِ مَمَ دْراکْشاکْشیتْرَں یاتَ، یُشْمَبھْیَمَہَں یوگْیَبھرِتِں داسْیامِ، تَتَسْتے وَوْرَجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","پُنَشْچَ سَ دْوِتِییَترِتِییَیوح پْرَہَرَیو رْبَہِ رْگَتْوا تَتھَیوَ کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","تَتو دَنْڈَدْوَیاوَشِشْٹایاں ویلایاں بَہِ رْگَتْواپَرانْ کَتِپَیَجَنانْ نِشْکَرْمَّکانْ وِلوکْیَ پرِشْٹَوانْ، یُویَں کِمَرْتھَمْ اَتْرَ سَرْوَّں دِنَں نِشْکَرْمّانَسْتِشْٹھَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","تے پْرَتْیَوَدَنْ، اَسْمانْ نَ کوپِ کَرْمَمَنِ نِیُںکْتے۔ تَدانِیں سَ کَتھِتَوانْ، یُویَمَپِ مَمَ دْراکْشاکْشیتْرَں یاتَ، تینَ یوگْیاں بھرِتِں لَپْسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","تَدَنَنْتَرَں سَنْدھْیایاں سَتْیاں سَایوَ دْراکْشاکْشیتْرَپَتِرَدھْیَکْشَں گَدِوانْ، کرِشَکانْ آہُویَ شیشَجَنَمارَبھْیَ پْرَتھَمَں یاوَتْ تیبھْیو بھرِتِں دیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","تینَ یے دَنْڈَدْوَیاوَسْتھِتے سَمایاتاسْتیشامْ ایکَیکو جَنو مُدْراچَتُرْتھاںشَں پْراپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","تَدانِیں پْرَتھَمَنِیُکْتا جَنا آگَتْیانُمِتَوَنْتو وَیَمَدھِکَں پْرَپْسْیامَح، کِنْتُ تَیرَپِ مُدْراچَتُرْتھاںشولابھِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","تَتَسْتے تَں گرِہِیتْوا تینَ کْشیتْرَپَتِنا ساکَں واگْیُدّھَں کُرْوَّنْتَح کَتھَیاماسُح، ");
INSERT INTO sanurd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","وَیَں کرِتْسْنَں دِنَں تاپَکْلیشَو سوڈھَوَنْتَح، کِنْتُ پَشْچاتایا سے جَنا دَنْڈَدْوَیَماتْرَں پَرِشْرانْتَوَنْتَسْتےسْمابھِح سَماناںشاح کرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","تَتَح سَ تیشامیکَں پْرَتْیُواچَ، ہے وَتْسَ، مَیا تْواں پْرَتِ کوپْیَنْیایو نَ کرِتَح کِں تْوَیا مَتْسَمَکْشَں مُدْراچَتُرْتھاںشو نانْگِیکرِتَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","تَسْماتْ تَوَ یَتْ پْراپْیَں تَدادایَ یاہِ، تُبھْیَں یَتِ، پَشْچاتِییَنِیُکْتَلوکایاپِ تَتِ داتُمِچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","سْویچّھَیا نِجَدْرَوْیَوْیَوَہَرَنَں کِں مَیا نَ کَرْتَّوْیَں؟ مَمَ داترِتْواتْ تْوَیا کِمْ اِیرْشْیادرِشْٹِح کْرِیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","اِتّھَمْ اَگْرِییَلوکاح پَشْچَتِییا بھَوِشْیَنْتِ، پَشْچاتِییَجَناشْچَگْرِییا بھَوِشْیَنْتِ، اَہُوتا بَہَوَح کِنْتْوَلْپے مَنوبھِلَشِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","تَدَنَنْتَرَں یِیشُ رْیِرُوشالَمْنَگَرَں گَچّھَنْ مارْگَمَدھْیے شِشْیانْ ایکانْتے وَبھاشے، ");
INSERT INTO sanurd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","پَشْیَ وَیَں یِرُوشالَمْنَگَرَں یامَح، تَتْرَ پْرَدھانَیاجَکادھْیاپَکاناں کَریشُ مَنُشْیَپُتْرَح سَمَرْپِشْیَتے؛ ");
INSERT INTO sanurd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","تے چَ تَں ہَنْتُماجْناپْیَ تِرَسْکرِتْیَ ویتْرینَ پْرَہَرْتُّں کْرُشے دھاتَیِتُنْچانْیَدیشِییاناں کَریشُ سَمَرْپَیِشْیَنْتِ، کِنْتُ سَ ترِتِییَدِوَسے شْمَشانادْ اُتّھاپِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","تَدانِیں سِوَدِییَسْیَ نارِی سْوَپُتْراوادایَ یِیشوح سَمِیپَمْ ایتْیَ پْرَنَمْیَ کَنْچَنانُگْرَہَں تَں یَیاچے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","تَدا یِیشُسْتاں پْروکْتَوانْ، تْوَں کِں یاچَسے؟ تَتَح سا بَبھاشے، بھَوَتو راجَتْوے مَمانَیوح سُتَیوریکَں بھَوَدَّکْشِنَپارْشْوے دْوِتِییَں وامَپارْشْوَ اُپَویشْٹُمْ آجْناپَیَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","یِیشُح پْرَتْیُواچَ، یُوابھْیاں یَدْ یاچْیَتے، تَنَّ بُدھْیَتے، اَہَں یینَ کَںسینَ پاسْیامِ یُوابھْیاں کِں تینَ پاتُں شَکْیَتے؟ اَہَنْچَ یینَ مَجّینینَ مَجِّشْیے، یُوابھْیاں کِں تینَ مَجَّیِتُں شَکْیَتے؟ تے جَگَدُح شَکْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","تَدا سَ اُکْتَوانْ، یُواں مَمَ کَںسیناوَشْیَں پاسْیَتھَح، مَمَ مَجَّنینَ چَ یُوامَپِ مَجِّشْییتھے، کِنْتُ ییشاں کرِتے مَتّاتینَ نِرُوپِتَمْ اِدَں تانْ وِہایانْیَں کَمَپِ مَدَّکْشِنَپارْشْوے وامَپارْشْوے چَ سَمُپَویشَیِتُں مَمادھِکارو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ایتاں کَتھاں شْرُتْوانْیے دَشَشِشْیاسْتَو بھْراتَرَو پْرَتِ چُکُپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","کِنْتُ یِیشُح سْوَسَمِیپَں تاناہُویَ جَگادَ، اَنْیَدیشِییَلوکاناں نَرَپَتَیَسْتانْ اَدھِکُرْوَّنْتِ، یے تُ مَہانْتَسْتے تانْ شاسَتِ، اِتِ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","کِنْتُ یُشْماکَں مَدھْیے نَ تَتھا بھَویتْ، یُشْماکَں یَح کَشْچِتْ مَہانْ بُبھُوشَتِ، سَ یُشْمانْ سیویتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","یَشْچَ یُشْماکَں مَدھْیے مُکھْیو بُبھُوشَتِ، سَ یُشْماکَں داسو بھَویتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","اِتّھَں مَنُجَپُتْرَح سیوْیو بھَوِتُں نَہِ، کِنْتُ سیوِتُں بَہُوناں پَرِتْرانَمُولْیارْتھَں سْوَپْرانانْ داتُنْچاگَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","اَنَنْتَرَں یِرِیہونَگَراتْ تیشاں بَہِرْگَمَنَسَمَیے تَسْیَ پَشْچادْ بَہَوو لوکا وَوْرَجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","اَپَرَں وَرْتْمَپارْشْوَ اُپَوِشَنْتَو دْواوَنْدھَو تینَ مارْگینَ یِیشو رْگَمَنَں نِشَمْیَ پْروچَّیح کَتھَیاماسَتُح، ہے پْرَبھو دایُودَح سَنْتانَ، آوَیو رْدَیاں وِدھیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","تَتو لوکاح سَرْوّے تُشْنِیمْبھَوَتَمِتْیُکْتْوا تَو تَرْجَیاماسُح؛ تَتھاپِ تَو پُنَرُچَّیح کَتھَیاماسَتُح ہے پْرَبھو دایُودَح سَنْتانَ، آواں دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","تَدانِیں یِیشُح سْتھَگِتَح سَنْ تاواہُویَ بھاشِتَوانْ، یُوَیوح کرِتے مَیا کِں کَرْتَّرْوْیَں؟ یُواں کِں کامَییتھے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","تَدا تاوُکْتَوَنْتَو، پْرَبھو نیتْرانِ نَو پْرَسَنّانِ بھَوییُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","تَدانِیں یِیشُسْتَو پْرَتِ پْرَمَنَّح سَنْ تَیو رْنیتْرانِ پَسْپَرْشَ، تینَیوَ تَو سُوِیکْشانْچَکْراتے تَتْپَشْچاتْ جَگْمُتُشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","اَنَنْتَرَں تیشُ یِرُوشالَمْنَگَرَسْیَ سَمِیپَویرْتِّنو جَیتُنَنامَکَدھَرادھَرَسْیَ سَمِیپَسْتھْتِں بَیتْپھَگِگْرامَمْ آگَتیشُ، یِیشُح شِشْیَدْوَیَں پْریشَیَنْ جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","یُواں سَمُّکھَسْتھَگْرامَں گَتْوا بَدّھاں یاں سَوَتْساں گَرْدَّبھِیں ہَٹھاتْ پْراپْسْیَتھَح، تاں موچَیِتْوا مَدَنْتِکَمْ آنَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","تَتْرَ یَدِ کَشْچِتْ کِنْچِدْ وَکْشْیَتِ، تَرْہِ وَدِشْیَتھَح، ایتَسْیاں پْرَبھوح پْرَیوجَنَماسْتے، تینَ سَ تَتْکْشَناتْ پْرَہیشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","سِییونَح کَنْیَکاں یُویَں بھاشَدھْوَمِتِ بھارَتِیں۔ پَشْیَ تے نَمْرَشِیلَح سَنْ نرِپَ آرُہْیَ گَرْدَبھِیں۔ اَرْتھادارُہْیَ تَدْوَتْسَمایاسْیَتِ تْوَدَنْتِکَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","بھَوِشْیَدْوادِنوکْتَں وَچَنَمِدَں تَدا سَپھَلَمَبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","اَنَنْتَرَں تَو شْشْیِौ یِیشو رْیَتھانِدیشَں تَں گْرامَں گَتْوا ");
INSERT INTO sanurd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","گَرْدَبھِیں تَدْوَتْسَنْچَ سَمانِیتَوَنْتَو، پَشْچاتْ تَدُپَرِ سْوِییَوَسَنانِی پاتَیِتْوا تَماروہَیاماسَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","تَتو بَہَوو لوکا نِجَوَسَنانِ پَتھِ پْرَسارَیِتُماریبھِرے، کَتِپَیا جَناشْچَ پادَپَپَرْنادِکَں چھِتْوا پَتھِ وِسْتارَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","اَگْرَگامِنَح پَشْچادْگامِنَشْچَ مَنُجا اُچَّیرْجَیَ جَیَ دایُودَح سَنْتانیتِ جَگَدُح پَرَمیشْوَرَسْیَ نامْنا یَ آیاتِ سَ دھَنْیَح، سَرْوّوپَرِسْتھَسْوَرْگیپِ جَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","اِتّھَں تَسْمِنْ یِرُوشالَمَں پْرَوِشْٹے کویَمِتِ کَتھَناتْ کرِتْسْنَں نَگَرَں چَنْچَلَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","تَتْرَ لوکوح کَتھَیاماسُح، ایشَ گالِیلْپْرَدیشِییَ-ناسَرَتِییَ-بھَوِشْیَدْوادِی یِیشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","اَنَنْتَرَں یِیشُرِیشْوَرَسْیَ مَنْدِرَں پْرَوِشْیَ تَنْمَدھْیاتْ کْرَیَوِکْرَیِنو وَہِشْچَکارَ؛ وَنِجاں مُدْراسَنانِی کَپوتَوِکْرَیِنانْچَسَنانِی چَ نْیُوْجَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","اَپَرَں تانُواچَ، ایشا لِپِراسْتے، \"مَمَ گرِہَں پْرارْتھَناگرِہَمِتِ وِکھْیاسْیَتِ\"، کِنْتُ یُویَں تَدْ دَسْیُوناں گَہْوَرَں کرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","تَدَنَنْتَرَمْ اَنْدھَکھَنْچَلوکاسْتَسْیَ سَمِیپَماگَتاح، سَ تانْ نِرامَیانْ کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","یَدا پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ تینَ کرِتانْییتانِ چِتْرَکَرْمّانِ دَدرِشُح، جَیَ جَیَ دایُودَح سَنْتانَ، مَنْدِرے بالَکانامْ ایتادرِشَمْ اُچَّدھْوَنِں شُشْرُوُشْچَ، تَدا مَہاکْرُدّھا بَبھُووَح، ");
INSERT INTO sanurd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","تَں پَپْرَچّھُشْچَ، اِمے یَدْ وَدَنْتِ، تَتْ کِں تْوَں شرِنوشِ؟ تَتو یِیشُسْتانْ اَووچَتْ، سَتْیَمْ؛ سْتَنْیَپایِشِشُونانْچَ بالَکانانْچَ وَکْتْرَتَح۔ سْوَکِییَں مَہِمانَں تْوَں سَںپْرَکاشَیَسِ سْوَیَں۔ ایتَدْواکْیَں یُویَں کِں ناپَٹھَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","تَتَسْتانْ وِہایَ سَ نَگَرادْ بَیتھَنِیاگْرامَں گَتْوا تَتْرَ رَجَنِیں یاپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","اَنَنْتَرَں پْرَبھاتے سَتِ یِیشُح پُنَرَپِ نَگَرَماگَچّھَنْ کْشُدھارْتّو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","تَتو مارْگَپارْشْوَ اُڈُمْبَرَورِکْشَمیکَں وِلوکْیَ تَتْسَمِیپَں گَتْوا پَتْرانِ وِنا کِمَپِ نَ پْراپْیَ تَں پادَپَں پْروواچَ، اَدْیارَبھْیَ کَداپِ تْوَیِ پھَلَں نَ بھَوَتُ؛ تینَ تَتْکْشَناتْ سَ اُڈُمْبَرَماہِیرُہَح شُشْکَتاں گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","تَدْ درِشْٹْوا شِشْیا آشْچَرْیَّں وِجْنایَ کَتھَیاماسُح، آح، اُڈُمْوَرَپادَپوتِتُورْنَں شُشْکوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","تَتو یِیشُسْتانُواچَ، یُشْمانَہَں سَتْیَں وَدامِ، یَدِ یُویَمَسَنْدِگْدھاح پْرَتِیتھَ، تَرْہِ یُویَمَپِ کیوَلوڈُمْوَرَپادَپَں پْرَتِیتّھَں کَرْتُّں شَکْشْیَتھَ، تَنَّ، تْوَں چَلِتْوا ساگَرے پَتیتِ واکْیَں یُشْمابھِرَسْمِنَ شَیلے پْروکْتیپِ تَدَیوَ تَدْ گھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","تَتھا وِشْوَسْیَ پْرارْتھْیَ یُشْمابھِ رْیَدْ یاچِشْیَتے، تَدیوَ پْراپْسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","اَنَنْتَرَں مَنْدِرَں پْرَوِشْیوپَدیشَنَسَمَیے تَتْسَمِیپَں پْرَدھانَیاجَکاح پْراچِینَلوکاشْچاگَتْیَ پَپْرَچّھُح، تْوَیا کینَ سامَرْتھْیَنَیتانِ کَرْمّانِ کْرِیَنْتے؟ کینَ وا تُبھْیَمیتانِ سامَرْتھْیانِ دَتّانِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","تَتو یِیشُح پْرَتْیَوَدَتْ، اَہَمَپِ یُشْمانْ واچَمیکاں پرِچّھامِ، یَدِ یُویَں تَدُتَّرَں داتُں شَکْشْیَتھَ، تَدا کینَ سامَرْتھْیینَ کَرْمّانْییتانِ کَرومِ، تَدَہَں یُشْمانْ وَکْشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","یوہَنو مَجَّنَں کَسْیاجْنَیابھَوَتْ؟ کِمِیشْوَرَسْیَ مَنُشْیَسْیَ وا؟ تَتَسْتے پَرَسْپَرَں وِوِچْیَ کَتھَیاماسُح، یَدِیشْوَرَسْییتِ وَدامَسْتَرْہِ یُویَں تَں کُتو نَ پْرَتْیَیتَ؟ واچَمیتاں وَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","مَنُشْیَسْییتِ وَکْتُمَپِ لوکیبھْیو بِبھِیمَح، یَتَح سَرْوَّیرَپِ یوہَنْ بھَوِشْیَدْوادِیتِ جْنایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","تَسْماتْ تے یِیشُں پْرَتْیَوَدَنْ، تَدْ وَیَں نَ وِدْمَح۔ تَدا سَ تانُکْتَوانْ، تَرْہِ کینَ سامَرَتھْیینَ کَرْمّانْییتانْیَہَں کَرومِ، تَدَپْیَہَں یُشْمانْ نَ وَکْشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","کَسْیَچِجَّنَسْیَ دْوَو سُتاواسْتاں سَ ایکَسْیَ سُتَسْیَ سَمِیپَں گَتْوا جَگادَ، ہے سُتَ، تْوَمَدْیَ مَمَ دْراکْشاکْشیتْرے کَرْمَّ کَرْتُں وْرَجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","تَتَح سَ اُکْتَوانْ، نَ یاسْیامِ، کِنْتُ شیشےنُتَپْیَ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","اَنَنْتَرَں سونْیَسُتَسْیَ سَمِیپَں گَتْوا تَتھَیوَ کَتھْتِوانْ؛ تَتَح سَ پْرَتْیُواچَ، مَہیچّھَ یامِ، کِنْتُ نَ گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ایتَیوح پُتْرَیو رْمَدھْیے پِتُرَبھِمَتَں کینَ پالِتَں؟ یُشْمابھِح کِں بُدھْیَتے؟ تَتَسْتے پْرَتْیُوچُح، پْرَتھَمینَ پُुتْرینَ۔ تَدانِیں یِیشُسْتانُواچَ، اَہَں یُشْمانْ تَتھْیَں وَدامِ، چَنْڈالا گَنِکاشْچَ یُشْماکَمَگْرَتَ اِیشْوَرَسْیَ راجْیَں پْرَوِشَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","یَتو یُشْماکَں سَمِیپَں یوہَنِ دھَرْمَّپَتھیناگَتے یُویَں تَں نَ پْرَتِیتھَ، کِنْتُ چَنْڈالا گَنِکاشْچَ تَں پْرَتْیایَنْ، تَدْ وِلوکْیاپِ یُویَں پْرَتْییتُں ناکھِدْیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","اَپَرَمیکَں درِشْٹانْتَں شرِنُتَ، کَشْچِدْ گرِہَسْتھَح کْشیتْرے دْراکْشالَتا روپَیِتْوا تَچَّتُرْدِکْشُ وارَنِیں وِدھایَ تَنْمَدھْیے دْراکْشایَنْتْرَں سْتھاپِتَوانْ، مانْچَنْچَ نِرْمِّتَوانْ، تَتَح کرِشَکیشُ تَتْ کْشیتْرَں سَمَرْپْیَ سْوَیَں دُورَدیشَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","تَدَنَنْتَرَں پھَلَسَمَیَ اُپَسْتھِتے سَ پھَلانِ پْراپْتُں کرِشِیوَلاناں سَمِیپَں نِجَداسانْ پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","کِنْتُ کرِشِیوَلاسْتَسْیَ تانْ داسییانْ دھرِتْوا کَنْچَنَ پْرَہرِتَوَنْتَح، کَنْچَنَ پاشانَیراہَتَوَنْتَح، کَنْچَنَ چَ ہَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","پُنَرَپِ سَ پْرَبھُح پْرَتھَمَتودھِکَداسییانْ پْریشَیاماسَ، کِنْتُ تے تانْ پْرَتْیَپِ تَتھَیوَ چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","اَنَنْتَرَں مَمَ سُتے گَتے تَں سَمادَرِشْیَنْتے، اِتْیُکْتْوا شیشے سَ نِجَسُتَں تیشاں سَنِّدھِں پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","کِنْتُ تے کرِشِیوَلاح سُتَں وِیکْشْیَ پَرَسْپَرَمْ اِتِ مَنْتْرَیِتُمْ آریبھِرے، اَیَمُتَّرادھِکارِی وَیَمینَں نِہَتْیاسْیادھِکارَں سْوَوَشِیکَرِشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","پَشْچاتْ تے تَں دھرِتْوا دْراکْشاکْشیتْرادْ بَہِح پاتَیِتْوابَدھِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","یَدا سَ دْراکْشاکْشیتْرَپَتِراگَمِشْیَتِ، تَدا تانْ کرِشِیوَلانْ کِں کَرِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","تَتَسْتے پْرَتْیَوَدَنْ، تانْ کَلُشِنو دارُنَیاتَنابھِراہَنِشْیَتِ، یے چَ سَمَیانُکْرَماتْ پھَلانِ داسْیَنْتِ، تادرِشیشُ کرِشِیوَلیشُ کْشیتْرَں سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","تَدا یِیشُنا تے گَدِتاح، گْرَہَنَں نَ کرِتَں یَسْیَ پاشانَسْیَ نِچایَکَیح۔ پْرَدھانَپْرَسْتَرَح کونے سَایوَ سَںبھَوِشْیَتِ۔ ایتَتْ پَریشِتُح کَرْمّاسْمَدرِشْٹاوَدْبھُتَں بھَویتْ۔ دھَرْمَّگْرَنْتھے لِکھِتَمیتَدْوَچَنَں یُشْمابھِح کِں ناپاٹھِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","تَسْمادَہَں یُشْمانْ وَدامِ، یُشْمَتَّ اِیشْوَرِییَراجْیَمَپَنِییَ پھَلوتْپادَیِتْرَنْیَجاتَیے دایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","یو جَنَ ایتَتْپاشانوپَرِ پَتِشْیَتِ، تَں سَ بھَںکْشْیَتے، کِنْتْوَیَں پاشانو یَسْیوپَرِ پَتِشْیَتِ، تَں سَ دھُولِوَتْ چُورْنِیکَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","تَدانِیں پْرادھَنَیاجَکاح پھِرُوشِنَشْچَ تَسْییماں درِشْٹانْتَکَتھاں شْرُتْوا سوسْمانُدِّشْیَ کَتھِتَوانْ، اِتِ وِجْنایَ تَں دھَرْتُّں چیشْٹِتَوَنْتَح؛ ");
INSERT INTO sanurd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","کِنْتُ لوکیبھْیو بِبھْیُح، یَتو لوکَیح سَ بھَوِشْیَدْوادِیتْیَجْنایِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","اَنَنْتَرَں یِیشُح پُنَرَپِ درِشْٹانْتینَ تانْ اَوادِیتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","سْوَرْگِییَراجْیَمْ ایتادرِشَسْیَ نرِپَتیح سَمَں، یو نِجَ پُتْرَں وِواہَیَنْ سَرْوّانْ نِمَنْتْرِتانْ آنیتُں داسییانْ پْرَہِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","کِنْتُ تے سَماگَنْتُں نیشْٹَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","تَتو راجا پُنَرَپِ داسانَنْیانْ اِتْیُکْتْوا پْریشَیاماسَ، نِمَنْتْرِتانْ وَدَتَ، پَشْیَتَ، مَمَ بھیجْیَماسادِتَماسْتے، نِجَوْٹَشادِپُشْٹَجَنْتُونْ مارَیِتْوا سَرْوَّں کھادْیَدْرَوْیَماسادِتَوانْ، یُویَں وِواہَماگَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","تَتھَپِ تے تُچّھِیکرِتْیَ کیچِتْ نِجَکْشیتْرَں کیچِدْ وانِجْیَں پْرَتِ سْوَسْوَمارْگینَ چَلِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","اَنْیے لوکاسْتَسْیَ داسییانْ دھرِتْوا دَوراتْمْیَں وْیَوَہرِتْیَ تانَوَدھِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","اَنَنْتَرَں سَ نرِپَتِسْتاں وارْتّاں شْرُتْوا کْرُدھْیَنْ سَینْیانِ پْرَہِتْیَ تانْ گھاتَکانْ ہَتْوا تیشاں نَگَرَں داہَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","تَتَح سَ نِجَداسییانْ بَبھاشے، وِواہِییَں بھوجْیَماسادِتَماسْتے، کِنْتُ نِمَنْتْرِتا جَنا اَیوگْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","تَسْمادْ یُویَں راجَمارْگَں گَتْوا یاوَتو مَنُجانْ پَشْیَتَ، تاوَتَایوَ وِواہِییَبھوجْیایَ نِمَنْتْرَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","تَدا تے داسییا راجَمارْگَں گَتْوا بھَدْرانْ اَبھَدْرانْ وا یاوَتو جَنانْ دَدرِشُح، تاوَتَایوَ سَںگرِہْیانَیَنْ؛ تَتوبھْیاگَتَمَنُجَے رْوِواہَگرِہَمْ اَپُورْیَّتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","تَدانِیں سَ راجا سَرْوّانَبھْیاگَتانْ دْرَشْٹُمْ اَبھْیَنْتَرَماگَتَوانْ؛ تَدا تَتْرَ وِواہِییَوَسَنَہِینَمیکَں جَنَں وِیکْشْیَ تَں جَگادْ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ہے مِتْرَ،تْوَں وِواہِییَوَسَنَں وِنا کَتھَمَتْرَ پْرَوِشْٹَوانْ؟ تینَ سَ نِرُتَّرو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","تَدا راجا نِجانُچَرانْ اَوَدَتْ، ایتَسْیَ کَرَچَرَنانْ بَدّھا یَتْرَ رودَنَں دَنْتَیرْدَنْتَگھَرْشَنَنْچَ بھَوَتِ، تَتْرَ وَہِرْبھُوتَتَمِسْرے تَں نِکْشِپَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","اِتّھَں بَہَوَ آہُوتا اَلْپے مَنوبھِمَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","اَنَنْتَرَں پھِرُوشِنَح پْرَگَتْیَ یَتھا سَںلاپینَ تَمْ اُنْماتھے پاتَیییُسْتَتھا مَنْتْرَیِتْوا ");
INSERT INTO sanurd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ہیرودِییَمَنُجَیح ساکَں نِجَشِشْیَگَنینَ تَں پْرَتِ کَتھَیاماسُح، ہے گُرو، بھَوانْ سَتْیَح سَتْیَمِیشْوَرِییَمارْگَمُپَدِشَتِ، کَمَپِ مانُشَں نانُرُدھْیَتے، کَمَپِ ناپیکْشَتے چَ، تَدْ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","اَتَح کَیسَرَبھُوپایَ کَروسْماکَں داتَوْیو نَ وا؟ اَتْرَ بھَوَتا کِں بُدھْیَتے؟ تَدْ اَسْمانْ وَدَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","تَتو یِیشُسْتیشاں کھَلَتاں وِجْنایَ کَتھِتَوانْ، رے کَپَٹِنَح یُیَں کُتو ماں پَرِکْشَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","تَتْکَرَدانَسْیَ مُدْراں ماں دَرْشَیَتَ۔ تَدانِیں تَیسْتَسْیَ سَمِیپَں مُدْراچَتُرْتھَبھاگَ آنِیتی ");
INSERT INTO sanurd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","سَ تانْ پَپْرَچّھَ، اَتْرَ کَسْیییَں مُورْتِّ رْنامَ چاسْتے؟ تے جَگَدُح، کَیسَرَبھُوپَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","تَتَح سَ اُکْتَوانَ، کَیسَرَسْیَ یَتْ تَتْ کَیسَرایَ دَتَّ، اِیشْوَرَسْیَ یَتْ تَدْ اِیشْوَرایَ دَتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","اِتِ واکْیَں نِشَمْیَ تے وِسْمَیَں وِجْنایَ تَں وِہایَ چَلِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","تَسْمِنَّہَنِ سِدُوکِنورْتھاتْ شْمَشاناتْ نوتّھاسْیَنْتِیتِ واکْیَں یے وَدَنْتِ، تے یِیشےाرَنْتِکَمْ آگَتْیَ پَپْرَچّھُح، ");
INSERT INTO sanurd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ہے گُرو، کَشْچِنْمَنُجَشْچیتْ نِحسَنْتانَح سَنْ پْرانانْ تْیَجَتِ، تَرْہِ تَسْیَ بھْراتا تَسْیَ جایاں وْیُہْیَ بھْراتُح سَنْتانَمْ اُتْپادَیِشْیَتِیتِ مُوسا آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","کِنْتْوَسْماکَمَتْرَ کےپِ جَناح سَپْتَسَہودَرا آسَنْ، تیشاں جْییشْٹھَ ایکاں کَنْیاں وْیَوَہاتْ، اَپَرَں پْرانَتْیاگَکالے سْوَیَں نِحسَنْتانَح سَنْ تاں سْتْرِیَں سْوَبھْراتَرِ سَمَرْپِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","تَتو دْوِتِییادِسَپْتَمانْتاشْچَ تَتھَیوَ چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","شیشے ساپِی نارِی مَمارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","مرِتانامْ اُتّھانَسَمَیے تیشاں سَپْتاناں مَدھْیے سا نارِی کَسْیَ بھارْیّا بھَوِشْیَتِ؟ یَسْماتْ سَرْوَّایوَ تاں وْیَوَہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","تَتو یِیشُح پْرَتْیَوادِیتْ، یُویَں دھَرْمَّپُسْتَکَمْ اِیشْوَرِییاں شَکْتِنْچَ نَ وِجْنایَ بھْرانْتِمَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","اُتّھانَپْراپْتا لوکا نَ وِوَہَنْتِ، نَ چَ واچا دِییَنْتے، کِنْتْوِیشْوَرَسْیَ سْوَرْگَسْتھَدُوتاناں سَدرِشا بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","اَپَرَں مرِتانامُتّھانَمَدھِ یُشْمانْ پْرَتِییَمِیشْوَروکْتِح، ");
INSERT INTO sanurd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"اَہَمِبْراہِیمَ اِیشْوَرَ اِسْہاکَ اِیشْوَرو یاکُوبَ اِیشْوَرَ\" اِتِ کِں یُشْمابھِ رْناپاٹھِ؟ کِنْتْوِیشْوَرو جِیوَتامْ اِیشْوَرَ:، سَ مرِتانامِیشْوَرو نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","اِتِ شْرُتْوا سَرْوّے لوکاسْتَسْیوپَدیشادْ وِسْمَیَں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","اَنَنْتَرَں سِدُوکِنامْ نِرُتَّرَتْوَوارْتاں نِشَمْیَ پھِرُوشِنَ ایکَتْرَ مِلِتَوَنْتَح، ");
INSERT INTO sanurd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","تیشامیکو وْیَوَسْتھاپَکو یِیشُں پَرِیکْشِتُں پَپَچّھَ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ہے گُرو وْیَوَسْتھاشاسْتْرَمَدھْیے کاجْنا شْریشْٹھا؟ ");
INSERT INTO sanurd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","تَتو یِیشُرُواچَ، تْوَں سَرْوّانْتَحکَرَنَیح سَرْوَّپْرانَیح سَرْوَّچِتَّیشْچَ ساکَں پْرَبھَو پَرَمیشْوَرے پْرِییَسْوَ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ایشا پْرَتھَمَمَہاجْنا۔ تَسْیاح سَدرِشِی دْوِتِییاجْنَیشا، ");
INSERT INTO sanurd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","تَوَ سَمِیپَواسِنِ سْواتْمَنِیوَ پْریمَ کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","اَنَیو رْدْوَیوراجْنَیوح کرِتْسْنَوْیَوَسْتھایا بھَوِشْیَدْوَکْترِگْرَنْتھَسْیَ چَ بھارَسْتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","اَنَنْتَرَں پھِرُوشِنامْ ایکَتْرَ سْتھِتِکالے یِیشُسْتانْ پَپْرَچّھَ، ");
INSERT INTO sanurd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","کھْرِیشْٹَمَدھِ یُشْماکَں کِیدرِگْبودھو جایَتے؟ سَ کَسْیَ سَنْتانَح؟ تَتَسْتے پْرَتْیَوَدَنْ، دایُودَح سَنْتانَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","تَدا سَ اُکْتَوانْ، تَرْہِ دایُودْ کَتھَمْ آتْمادھِشْٹھانینَ تَں پْرَبھُں وَدَتِ ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","یَتھا مَمَ پْرَبھُمِدَں واکْیَمَوَدَتْ پَرَمیشْوَرَح۔ تَوارِینْ پادَپِیٹھَں تے یاوَنَّہِ کَرومْیَہَں۔ تاوَتْ کالَں مَدِییے تْوَں دَکْشَپارْشْوَ اُپاوِشَ۔ اَتو یَدِ دایُودْ تَں پْرَبھُں وَدَتِ، رْتِہَ سَ کَتھَں تَسْیَ سَنْتانو بھَوَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","تَدانِیں تیشاں کوپِ تَدْواکْیَسْیَ کِمَپْیُتَّرَں داتُں ناشَکْنوتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","تَدِّنَمارَبھْیَ تَں کِمَپِ واکْیَں پْرَشْٹُں کَسْیاپِ ساہَسو نابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","اَنَنْتَرَں یِیشُ رْجَنَنِوَہَں شِشْیاںشْچاوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","اَدھْیاپَکاح پھِرُوشِنَشْچَ مُوساسَنے اُپَوِشَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","اَتَسْتے یُشْمانْ یَدْیَتْ مَنْتُمْ آجْناپَیَنْتِ، تَتْ مَنْیَدھْوَں پالَیَدھْوَنْچَ، کِنْتُ تیشاں کَرْمّانُرُوپَں کَرْمَّ نَ کُرُدھْوَں؛ یَتَسْتیشاں واکْیَماتْرَں سارَں کارْیّے کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","تے دُرْوَّہانْ گُرُتَرانْ بھارانْ بَدْوّا مَنُشْیاناں سْکَنْدھیپَرِ سَمَرْپَیَنْتِ، کِنْتُ سْوَیَمَنْگُلْیَیکَیاپِ نَ چالَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","کیوَلَں لوکَدَرْشَنایَ سَرْوَّکَرْمّانِ کُرْوَّنْتِ؛ پھَلَتَح پَٹَّبَنْدھانْ پْرَسارْیَّ دھارَیَنْتِ، سْوَوَسْتْریشُ چَ دِیرْگھَگْرَنْتھِینْ دھارَیَنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","بھوجَنَبھَوَنَ اُچَّسْتھانَں، بھَجَنَبھَوَنے پْرَدھانَماسَنَں، ");
INSERT INTO sanurd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ہَٹّھے نَمَسْکارَں گُرُرِتِ سَمْبودھَنَنْچَیتانِ سَرْوّانِ وانْچھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","کِنْتُ یُویَں گُرَوَ اِتِ سَمْبودھَنِییا ما بھَوَتَ، یَتو یُشْماکَمْ ایکَح کھْرِیشْٹَایوَ گُرُ ");
INSERT INTO sanurd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","رْیُویَں سَرْوّے مِتھو بھْراتَرَشْچَ۔ پُنَح پرِتھِوْیاں کَمَپِ پِتیتِ ما سَمْبُدھْیَدھْوَں، یَتو یُشْماکَمیکَح سْوَرْگَسْتھَایوَ پِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","یُویَں نایَکیتِ سَمْبھاشِتا ما بھَوَتَ، یَتو یُشْماکَمیکَح کھْرِیشْٹَایوَ نایَکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","اَپَرَں یُشْماکَں مَدھْیے یَح پُمانْ شْریشْٹھَح سَ یُشْمانْ سیوِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","یَتو یَح سْوَمُنَّمَتِ، سَ نَتَح کَرِشْیَتے؛ کِنْتُ یَح کَشْچِتْ سْوَمَوَنَتَں کَروتِ، سَ اُنَّتَح کَرِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ہَنْتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَں مَنُجاناں سَمَکْشَں سْوَرْگَدْوارَں رُنْدھَ، یُویَں سْوَیَں تینَ نَ پْرَوِشَتھَ، پْرَوِوِکْشُونَپِ وارَیَتھَ۔ وَتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ یُویَں چھَلادْ دِیرْگھَں پْرارْتھْیَ وِدھَواناں سَرْوَّسْوَں گْرَسَتھَ، یُشْماکَں گھورَتَرَدَنْڈو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ہَنْتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَمیکَں سْوَدھَرْمّاوَلَمْبِنَں کَرْتُّں ساگَرَں بھُومَنْڈَلَنْچَ پْرَدَکْشِنِیکُرُتھَ، ");
INSERT INTO sanurd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","کَنْچَنَ پْراپْیَ سْوَتو دْوِگُنَنَرَکَبھاجَنَں تَں کُرُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","وَتَ اَنْدھَپَتھَدَرْشَکاح سَرْوّے، یُویَں وَدَتھَ، مَنْدِرَسْیَ شَپَتھَکَرَناتْ کِمَپِ نَ دییَں؛ کِنْتُ مَنْدِرَسْتھَسُوَرْنَسْیَ شَپَتھَکَرَنادْ دییَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ہے مُوڈھا ہے اَنْدھاح سُوَرْنَں تَتْسُوَرْنَپاوَکَمَنْدِرَمْ ایتَیورُبھَیو رْمَدھْیے کِں شْرییَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","اَنْیَچَّ وَدَتھَ، یَجْنَویدْیاح شَپَتھَکَرَناتْ کِمَپِ نَ دییَں، کِنْتُ تَدُپَرِسْتھِتَسْیَ نَیویدْیَسْیَ شَپَتھَکَرَنادْ دییَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ہے مُوڈھا ہے اَنْدھاح، نَیویدْیَں تَنَّیویدْیَپاوَکَویدِریتَیورُبھَیو رْمَدھْیے کِں شْرییَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","اَتَح کینَچِدْ یَجْنَویدْیاح شَپَتھے کرِتے تَدُپَرِسْتھَسْیَ سَرْوَّسْیَ شَپَتھَح کْرِیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","کینَچِتْ مَنْدِرَسْیَ شَپَتھے کرِتے مَنْدِرَتَنِّواسِنوح شَپَتھَح کْرِیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","کینَچِتْ سْوَرْگَسْیَ شَپَتھے کرِتے اِیشْوَرِییَسِںہاسَنَتَدُپَرْیُّپَوِشْٹَیوح شَپَتھَح کْرِیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ہَنْتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَں پودِنایاح سِتَچّھَتْرایا جِیرَکَسْیَ چَ دَشَماںشانْ دَتّھَ، کِنْتُ وْیَوَسْتھایا گُرُتَرانْ نْیایَدَیاوِشْواسانْ پَرِتْیَجَتھَ؛ اِمے یُشْمابھِراچَرَنِییا اَمِی چَ نَ لَںگھَنِییاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ہے اَنْدھَپَتھَدَرْشَکا یُویَں مَشَکانْ اَپَسارَیَتھَ، کِنْتُ مَہانْگانْ گْرَسَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ہَنْتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَں پانَپاتْراناں بھوجَنَپاتْرانانْچَ بَہِح پَرِشْکُرُتھَ؛ کِنْتُ تَدَبھْیَنْتَرَں دُراتْمَتَیا کَلُشینَ چَ پَرِپُورْنَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ہے اَنْدھاح پھِرُوشِلوکا آدَو پانَپاتْراناں بھوجَنَپاتْرانانْچابھْیَنْتَرَں پَرِشْکُرُتَ، تینَ تیشاں بَہِرَپِ پَرِشْکارِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ہَنْتَ کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَں شُکْلِیکرِتَشْمَشانَسْوَرُوپا بھَوَتھَ، یَتھا شْمَشانَبھَوَنَسْیَ بَہِشْچارُ، کِنْتْوَبھْیَنْتَرَں مرِتَلوکاناں کِیکَشَیح سَرْوَّپْرَکارَمَلینَ چَ پَرِپُورْنَمْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","تَتھَیوَ یُویَمَپِ لوکاناں سَمَکْشَں بَہِرْدھارْمِّکاح کِنْتْوَنْتَحکَرَنیشُ کیوَلَکاپَٹْیادھَرْمّابھْیاں پَرِپُورْناح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ہا ہا کَپَٹِنَ اُپادھْیایاح پھِرُوشِنَشْچَ، یُویَں بھَوِشْیَدْوادِناں شْمَشانَگیہَں نِرْمّاتھَ، سادھُوناں شْمَشانَنِکیتَنَں شوبھَیَتھَ ");
INSERT INTO sanurd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","وَدَتھَ چَ یَدِ وَیَں سْویشاں پُورْوَّپُرُشاناں کالَ اَسْتھاسْیامَ، تَرْہِ بھَوِشْیَدْوادِناں شونِتَپاتَنے تیشاں سَہَبھاگِنو نابھَوِشْیامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","اَتو یُویَں بھَوِشْیَدْوادِگھاتَکاناں سَنْتانا اِتِ سْوَیَمیوَ سْویشاں ساکْشْیَں دَتّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","اَتو یُویَں نِجَپُورْوَّپُرُشاناں پَرِمانَپاتْرَں پَرِپُورَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","رے بھُجَگاح کرِشْنَبھُجَگَوَںشاح، یُویَں کَتھَں نَرَکَدَنْڈادْ رَکْشِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","پَشْیَتَ، یُشْماکَمَنْتِکَمْ اَہَں بھَوِشْیَدْوادِنو بُدّھِمَتَ اُپادھْیایاںشْچَ پْریشَیِشْیامِ، کِنْتُ تیشاں کَتِپَیا یُشْمابھِ رْگھانِشْیَنْتے، کْرُشے چَ گھانِشْیَنْتے، کیچِدْ بھَجَنَبھَوَنے کَشابھِراگھانِشْیَنْتے، نَگَرے نَگَرے تاڈِشْیَنْتے چَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","تینَ سَتْپُرُشَسْیَ ہابِلو رَکْتَپاتَمارَبھْیَ بیرِکھِیَح پُتْرَں یَں سِکھَرِیَں یُویَں مَنْدِرَیَجْنَویدْیو رْمَدھْیے ہَتَوَنْتَح، تَدِییَشونِتَپاتَں یاوَدْ اَسْمِنْ دیشے یاوَتاں سادھُپُرُشاناں شونِتَپاتو بھَوَتْ تَتْ سَرْوّیشاماگَساں دَنْڈا یُشْماسُ وَرْتِّشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","اَہَں یُشْمانْتَ تَتھْیَں وَدامِ، وِدْیَمانےسْمِنْ پُرُشے سَرْوّے وَرْتِّشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ہے یِرُوشالَمْ ہے یِرُوشالَمْ نَگَرِ تْوَں بھَوِشْیَدْوادِنو ہَتَوَتِی، تَوَ سَمِیپَں پْریرِتاںشْچَ پاشانَیراہَتَوَتِی، یَتھا کُکُّٹِی شاوَکانْ پَکْشادھَح سَںگرِہْلاتِ، تَتھا تَوَ سَنْتانانْ سَںگْرَہِیتُں اَہَں بَہُوارَمْ اَیچّھَں؛ کِنْتُ تْوَں نَ سَمَمَنْیَتھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","پَشْیَتَ یَشْماکَں واسَسْتھانَمْ اُچّھِنَّں تْیَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","اَہَں یُشْمانْ تَتھْیَں وَدامِ، یَح پَرَمیشْوَرَسْیَ نامْناگَچّھَتِ، سَ دھَنْیَ اِتِ وانِیں یاوَنَّ وَدِشْیَتھَ، تاوَتْ ماں پُنَ رْنَ دْرَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","اَنَنْتَرَں یِیشُ رْیَدا مَنْدِرادْ بَہِ رْگَچّھَتِ، تَدانِیں شِشْیاسْتَں مَنْدِرَنِرْمّانَں دَرْشَیِتُماگَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","تَتو یِیشُسْتانُواچَ، یُویَں کِمیتانِ نَ پَشْیَتھَ؟ یُشْمانَہَں سَتْیَں وَدامِ، ایتَنِّچَیَنَسْیَ پاشانَیکَمَپْیَنْیَپاشانےाپَرِ نَ سْتھاسْیَتِ سَرْوّانِ بھُومِساتْ کارِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","اَنَنْتَرَں تَسْمِنْ جَیتُنَپَرْوَّتوپَرِ سَمُپَوِشْٹے شِشْیاسْتَسْیَ سَمِیپَماگَتْیَ گُپْتَں پَپْرَچّھُح، ایتا گھَٹَناح کَدا بھَوِشْیَنْتِ؟ بھَوَتَ آگَمَنَسْیَ یُگانْتَسْیَ چَ کِں لَکْشْمَ؟ تَدَسْمانْ وَدَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","تَدانِیں یِیشُسْتانَووچَتْ، اَوَدھَدْوَّں، کوپِ یُشْمانْ نَ بھْرَمَییتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","بَہَوو مَمَ نامَ گرِہْلَنْتَ آگَمِشْیَنْتِ، کھْرِیشْٹوہَمیویتِ واچَں وَدَنْتو بَہُونْ بھْرَمَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","یُویَنْچَ سَںگْرامَسْیَ رَنَسْیَ چاڈَمْبَرَں شْروشْیَتھَ، اَوَدھَدْوَّں تینَ چَنْچَلا ما بھَوَتَ، ایتانْیَوَشْیَں گھَٹِشْیَنْتے، کِنْتُ تَدا یُگانْتو نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","اَپَرَں دیشَسْیَ وِپَکْشو دیشو راجْیَسْیَ وِپَکْشو راجْیَں بھَوِشْیَتِ، سْتھانے سْتھانے چَ دُرْبھِکْشَں مَہامارِی بھُوکَمْپَشْچَ بھَوِشْیَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ایتانِ دُحکھوپَکْرَماح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","تَدانِیں لوکا دُحکھَں بھوجَیِتُں یُشْمانْ پَرَکَریشُ سَمَرْپَیِشْیَنْتِ ہَنِشْیَنْتِ چَ، تَتھا مَمَ نامَکارَنادْ یُویَں سَرْوَّدیشِییَمَنُجاناں سَمِیپے گھرِنارْہا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","بَہُشُ وِگھْنَں پْراپْتَوَتْسُ پَرَسْپَرَمْ رِृتِییاں کرِتَوَتْسُ چَ ایکوپَرَں پَرَکَریشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","تَتھا بَہَوو مرِشابھَوِشْیَدْوادِنَ اُپَسْتھایَ بَہُونْ بھْرَمَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","دُشْکَرْمَّناں باہُلْیانْچَ بَہُوناں پْریمَ شِیتَلَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","کِنْتُ یَح کَشْچِتْ شیشَں یاوَدْ دھَیرْیَّماشْرَیَتے، سَایوَ پَرِتْرایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","اَپَرَں سَرْوَّدیشِییَلوکانْ پْرَتِماکْشِی بھَوِتُں راجَسْیَ شُبھَسَماچارَح سَرْوَّجَگَتِ پْرَچارِشْیَتے، ایتادرِشِ سَتِ یُگانْتَ اُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","اَتو یَتْ سَرْوَّناشَکرِدْگھرِنارْہَں وَسْتُ دانِییلْبھَوِشْیَدْوَدِنا پْروکْتَں تَدْ یَدا پُنْیَسْتھانے سْتھاپِتَں دْرَکْشْیَتھَ، (یَح پَٹھَتِ، سَ بُدھْیَتاں) ");
INSERT INTO sanurd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","تَدانِیں یے یِہُودِییَدیشے تِشْٹھَنْتِ، تے پَرْوَّتیشُ پَلایَنْتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","یَح کَشْچِدْ گرِہَپرِشْٹھے تِشْٹھَتِ، سَ گرِہاتْ کِمَپِ وَسْتْوانیتُمْ اَدھےा ناوَروہیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","یَشْچَ کْشیتْرے تِشْٹھَتِ، سوپِ وَسْتْرَمانیتُں پَراورِتْیَ نَ یایاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","تَدانِیں گَرْبھِنِیسْتَنْیَپایَیِتْرِیناں دُرْگَتِ رْبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","اَتو یَشْماکَں پَلایَنَں شِیتَکالے وِشْرامَوارے وا یَنَّ بھَویتْ، تَدَرْتھَں پْرارْتھَیَدھْوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","آ جَگَدارَمْبھادْ ایتَتْکالَپَرْیَّنَنْتَں یادرِشَح کَداپِ نابھَوَتْ نَ چَ بھَوِشْیَتِ تادرِشو مَہاکْلیشَسْتَدانِیمْ اُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","تَسْیَ کْلیشَسْیَ سَمَیو یَدِ ہْسْوو نَ کْرِییتَ، تَرْہِ کَسْیاپِ پْرانِنو رَکْشَنَں بھَوِتُں نَ شَکْنُیاتْ، کِنْتُ مَنونِیتَمَنُجاناں کرِتے سَ کالو ہْسْوِیکَرِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","اَپَرَنْچَ پَشْیَتَ، کھْرِیشْٹوتْرَ وِدْیَتے، وا تَتْرَ وِدْیَتے، تَدانِیں یَدِی کَشْچِدْ یُشْمانَ اِتِ واکْیَں وَدَتِ، تَتھاپِ تَتْ نَ پْرَتِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","یَتو بھاکْتَکھْرِیشْٹا بھاکْتَبھَوِشْیَدْوادِنَشْچَ اُپَسْتھایَ یانِ مَہَنْتِ لَکْشْمانِ چِتْرَکَرْمّانِ چَ پْرَکاشَیِشْیَنْتِ، تَے رْیَدِ سَمْبھَویتْ تَرْہِ مَنونِیتَمانَوا اَپِ بھْرامِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","پَشْیَتَ، گھَٹَناتَح پُورْوَّں یُشْمانْ وارْتّامْ اَوادِشَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","اَتَح پَشْیَتَ، سَ پْرانْتَرے وِدْیَتَ اِتِ واکْیے کینَچِتْ کَتھِتیپِ بَہِ رْما گَچّھَتَ، وا پَشْیَتَ، سونْتَحپُرے وِدْیَتے، ایتَدْواکْیَ اُکْتیپِ ما پْرَتِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","یَتو یَتھا وِدْیُتْ پُورْوَّدِشو نِرْگَتْیَ پَشْچِمَدِشَں یاوَتْ پْرَکاشَتے، تَتھا مانُشَپُتْرَسْیاپْیاگَمَنَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","یَتْرَ شَوَسْتِشْٹھَتِ، تَتْریوَ گرِدھْرا مِلَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","اَپَرَں تَسْیَ کْلیشَسَمَیَسْیاوْیَوَہِتَپَرَتْرَ سُورْیَّسْیَ تیجو لوپْسْیَتے، چَنْدْرَما جْیوسْناں نَ کَرِشْیَتِ، نَبھَسو نَکْشَتْرانِ پَتِشْیَنْتِ، گَگَنِییا گْرَہاشْچَ وِچَلِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","تَدانِیمْ آکاشَمَدھْیے مَنُجَسُتَسْیَ لَکْشْمَ دَرْشِشْیَتے، تَتو نِجَپَراکْرَمینَ مَہاتیجَسا چَ میگھارُوڈھَں مَنُجَسُتَں نَبھَساگَچّھَنْتَں وِلوکْیَ پرِتھِوْیاح سَرْوَّوَںشِییا وِلَپِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","تَدانِیں سَ مَہاشَبْدایَمانَتُورْیّا وادَکانْ نِجَدُوتانْ پْرَہیشْیَتِ، تے وْیومْنَ ایکَسِیماتوپَرَسِیماں یاوَتْ چَتُرْدِشَسْتَسْیَ مَنونِیتَجَنانْ آنِییَ میلَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","اُڈُمْبَرَپادَپَسْیَ درِشْٹانْتَں شِکْشَدھْوَں؛ یَدا تَسْیَ نَوِیناح شاکھا جایَنْتے، پَلَّوادِشْچَ نِرْگَچّھَتِ، تَدا نِداگھَکالَح سَوِدھو بھَوَتِیتِ یُویَں جانِیتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","تَدْوَدْ ایتا گھَٹَنا درِشْٹْوا سَ سَمَیو دْوارَ اُپاسْتھادْ اِتِ جانِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","یُشْمانَہَں تَتھْیَں وَدامِ، اِدانِینْتَنَجَناناں گَمَناتْ پُورْوَّمیوَ تانِ سَرْوّانِ گھَٹِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","نَبھومیدِنْیو رْلُپْتَیورَپِ مَمَ واکْ کَداپِ نَ لوپْسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","اَپَرَں مَمَ تاتَں وِنا مانُشَح سْوَرْگَسْتھو دُوتو وا کوپِ تَدِّنَں تَدَّنْڈَنْچَ نَ جْناپَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","اَپَرَں نوہے وِدْیَمانے یادرِشَمَبھَوَتْ تادرِشَں مَنُجَسُتَسْیاگَمَنَکالیپِ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","پھَلَتو جَلاپْلاوَناتْ پُورْوَّں یَدِّنَں یاوَتْ نوہَح پوتَں ناروہَتْ، تاوَتْکالَں یَتھا مَنُشْیا بھوجَنے پانے وِوَہَنے وِواہَنے چَ پْرَورِتّا آسَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","اَپَرَمْ آپْلاوِتویَماگَتْیَ یاوَتْ سَکَلَمَنُجانْ پْلاوَیِتْوا نانَیَتْ، تاوَتْ تے یَتھا نَ وِداماسُح، تَتھا مَنُجَسُتاگَمَنیپِ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","تَدا کْشیتْرَسْتھِتَیورْدْوَیوریکو دھارِشْیَتے، اَپَرَسْتْیاجِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","تَتھا پیشَنْیا پِںشَتْیورُبھَیو رْیوشِتوریکا دھارِشْیَتےپَرا تْیاجِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","یُشْماکَں پْرَبھُح کَسْمِنْ دَنْڈَ آگَمِشْیَتِ، تَدْ یُشْمابھِ رْناوَگَمْیَتے، تَسْماتْ جاگْرَتَح سَنْتَسْتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","کُتْرَ یامے سْتینَ آگَمِشْیَتِیتِ چیدْ گرِہَسْتھو جْناتُمْ اَشَکْشْیَتْ، تَرْہِ جاگَرِتْوا تَں سَنْدھِں کَرْتِّتُمْ اَوارَیِشْیَتْ تَدْ جانِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","یُشْمابھِرَوَدھِییَتاں، یَتو یُشْمابھِ رْیَتْرَ نَ بُدھْیَتے، تَتْرَیوَ دَنْڈے مَنُجَسُتَ آیاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","پْرَبھُ رْنِجَپَرِوارانْ یَتھاکالَں بھوجَیِتُں یَں داسَمْ اَدھْیَکْشِیکرِتْیَ سْتھاپَیَتِ، تادرِشو وِشْواسْیو دھِیمانْ داسَح کَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","پْرَبھُراگَتْیَ یَں داسَں تَتھاچَرَنْتَں وِیکْشَتے، سَایوَ دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","یُشْمانَہَں سَتْیَں وَدامِ، سَ تَں نِجَسَرْوَّسْوَسْیادھِپَں کَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","کِنْتُ پْرَبھُراگَنْتُں وِلَمْبَتَ اِتِ مَنَسِ چِنْتَیِتْوا یو دُشْٹو داسو ");
INSERT INTO sanurd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","پَرَداسانْ پْرَہَرْتُّں مَتّاناں سَنْگے بھوکْتُں پاتُنْچَ پْرَوَرْتَّتے، ");
INSERT INTO sanurd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","سَ داسو یَدا ناپیکْشَتے، یَنْچَ دَنْڈَں نَ جاناتِ، تَتْکالَایوَ تَتْپْرَبھُرُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","تَدا تَں دَنْڈَیِتْوا یَتْرَ سْتھانے رودَنَں دَنْتَگھَرْشَنَنْچاساتے، تَتْرَ کَپَٹِبھِح ساکَں تَدَّشاں نِرُوپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","یا دَشَ کَنْیاح پْرَدِیپانْ گرِہْلَتْیو وَرَں ساکْشاتْ کَرْتُّں بَہِرِتاح، تابھِسْتَدا سْوَرْگِییَراجْیَسْیَ سادرِشْیَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","تاساں کَنْیاناں مَدھْیے پَنْچَ سُدھِیَح پَنْچَ دُرْدھِیَ آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","یا دُرْدھِیَسْتاح پْرَدِیپانْ سَنْگے گرِہِیتْوا تَیلَں نَ جَگرِہُح، ");
INSERT INTO sanurd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","کِنْتُ سُدھِیَح پْرَدِیپانْ پاتْرینَ تَیلَنْچَ جَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","اَنَنْتَرَں وَرے وِلَمْبِتے تاح سَرْوّا نِدْراوِشْٹا نِدْراں جَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","اَنَنْتَرَمْ اَرْدّھَراتْرے پَشْیَتَ وَرَ آگَچّھَتِ، تَں ساکْشاتْ کَرْتُّں بَہِرْیاتیتِ جَنَرَواتْ ");
INSERT INTO sanurd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","تاح سَرْوّاح کَنْیا اُتّھایَ پْرَدِیپانْ آسادَیِتُں آرَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","تَتو دُرْدھِیَح سُدھِیَ اُوچُح، کِنْچِتْ تَیلَں دَتَّ، پْرَدِیپا اَسْماکَں نِرْوّاناح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","کِنْتُ سُدھِیَح پْرَتْیَوَدَنْ، دَتّے یُشْمانَسْماںشْچَ پْرَتِ تَیلَں نْیُونِیبھَویتْ، تَسْمادْ وِکْریترِناں سَمِیپَں گَتْوا سْوارْتھَں تَیلَں کْرِینِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","تَدا تاسُ کْریتُں گَتاسُ وَرَ آجَگامَ، تَتو یاح سَجِّتا آسَنْ، تاسْتینَ ساکَں وِواہِییَں ویشْمَ پْرَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","اَنَنْتَرَں دْوارے رُدّھے اَپَراح کَنْیا آگَتْیَ جَگَدُح، ہے پْرَبھو، ہے پْرَبھو، اَسْمانْ پْرَتِ دْوارَں موچَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","کِنْتُ سَ اُکْتَوانْ، تَتھْیَں وَدامِ، یُشْمانَہَں نَ ویدْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","اَتو جاگْرَتَح سَنْتَسْتِشْٹھَتَ، مَنُجَسُتَح کَسْمِنْ دِنے کَسْمِنْ دَنْڈے واگَمِشْیَتِ، تَدْ یُشْمابھِ رْنَ جْنایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","اَپَرَں سَ ایتادرِشَح کَسْیَچِتْ پُںسَسْتُلْیَح، یو دُورَدیشَں پْرَتِ یاتْراکالے نِجَداسانْ آہُویَ تیشاں سْوَسْوَسامَرْتھْیانُرُوپَمْ ");
INSERT INTO sanurd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ایکَسْمِنْ مُدْراناں پَنْچَ پوٹَلِکاح اَنْیَسْمِںشْچَ دْوے پوٹَلِکے اَپَرَسْمِںشْچَ پوٹَلِکَیکامْ اِتّھَں پْرَتِجَنَں سَمَرْپْیَ سْوَیَں پْرَواسَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","اَنَنْتَرَں یو داسَح پَنْچَ پوٹَلِکاح لَبْدھَوانْ، سَ گَتْوا وانِجْیَں وِدھایَ تا دْوِگُنِیچَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","یَشْچَ داسو دْوے پوٹَلِکے اَلَبھَتَ، سوپِ تا مُدْرا دْوِگُنِیچَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","کِنْتُ یو داسَ ایکاں پوٹَلِکاں لَبْدھَوانْ، سَ گَتْوا بھُومِں کھَنِتْوا تَنْمَدھْیے نِجَپْرَبھوسْتا مُدْرا گوپَیانْچَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","تَدَنَنْتَرَں بَہُتِتھے کالے گَتے تیشاں داساناں پْرَبھُراگَتْیَ تَیرْداسَیح سَمَں گَنَیانْچَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","تَدانِیں یَح پَنْچَ پوٹَلِکاح پْراپْتَوانْ سَ تا دْوِگُنِیکرِتَمُدْرا آنِییَ جَگادَ؛ ہے پْرَبھو، بھَوَتا مَیِ پَنْچَ پوٹَلِکاح سَمَرْپِتاح، پَشْیَتُ، تا مَیا دْوِگُنِیکرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","تَدانِیں تَسْیَ پْرَبھُسْتَمُواچَ، ہے اُتَّمَ وِشْواسْیَ داسَ، تْوَں دھَنْیوسِ، سْتوکینَ وِشْواسْیو جاتَح، تَسْماتْ تْواں بَہُوِتّادھِپَں کَرومِ، تْوَں سْوَپْرَبھوح سُکھَسْیَ بھاگِی بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","تَتو یینَ دْوے پوٹَلِکے لَبْدھے سوپْیاگَتْیَ جَگادَ، ہے پْرَبھو، بھَوَتا مَیِ دْوے پوٹَلِکے سَمَرْپِتے، پَشْیَتُ تے مَیا دْوِگُنِیکرِتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","تینَ تَسْیَ پْرَبھُسْتَمَووچَتْ، ہے اُتَّمَ وِشْواسْیَ داسَ، تْوَں دھَنْیوسِ، سْتوکینَ وِشْواسْیو جاتَح، تَسْماتْ تْواں بَہُدْرَوِنادھِپَں کَرومِ، تْوَں نِجَپْرَبھوح سُکھَسْیَ بھاگِی بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","اَنَنْتَرَں یَ ایکاں پوٹَلِکاں لَبْدھَوانْ، سَ ایتْیَ کَتھِتَوانْ، ہے پْرَبھو، تْواں کَٹھِنَنَرَں جْناتَوانْ، تْوَیا یَتْرَ نوپْتَں، تَتْرَیوَ کرِتْیَتے، یَتْرَ چَ نَ کِیرْنَں، تَتْرَیوَ سَںگرِہْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","اَتوہَں سَشَنْکَح سَنْ گَتْوا تَوَ مُدْرا بھُومَدھْیے سَںگوپْیَ سْتھاپِتَوانْ، پَشْیَ، تَوَ یَتْ تَدیوَ گرِہانَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","تَدا تَسْیَ پْرَبھُح پْرَتْیَوَدَتْ رے دُشْٹالَسَ داسَ، یَتْراہَں نَ وَپامِ، تَتْرَ چھِنَدْمِ، یَتْرَ چَ نَ کِرامِ، تَتْریوَ سَںگرِہْلامِیتِ چیدَجاناسْتَرْہِ ");
INSERT INTO sanurd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","وَنِکْشُ مَمَ وِتّارْپَنَں تَووچِتَماسِیتْ، ییناہَماگَتْیَ ورِدْوْیا ساکَں مُولَمُدْراح پْراپْسْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","اَتوسْماتْ تاں پوٹَلِکامْ آدایَ یَسْیَ دَشَ پوٹَلِکاح سَنْتِ تَسْمِنَّرْپَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","یینَ وَرْدْوْیَتے تَسْمِنَّیوارْپِشْیَتے، تَسْیَیوَ چَ باہُلْیَں بھَوِشْیَتِ، کِنْتُ یینَ نَ وَرْدْوْیَتے، تَسْیانْتِکے یَتْ کِنْچَنَ تِشْٹھَتِ، تَدَپِ پُنَرْنیشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","اَپَرَں یُویَں تَمَکَرْمَّنْیَں داسَں نِیتْوا یَتْرَ سْتھانے کْرَنْدَنَں دَنْتَگھَرْشَنَنْچَ وِدْییتے، تَسْمِنْ بَہِرْبھُوتَتَمَسِ نِکْشِپَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","یَدا مَنُجَسُتَح پَوِتْرَدُوتانْ سَنْگِنَح کرِتْوا نِجَپْرَبھاویناگَتْیَ نِجَتیجومَیے سِںہاسَنے نِویکْشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","تَدا تَتْسَمُّکھے سَرْوَّجاتِییا جَنا سَںمیلِشْیَنْتِ۔ تَتو میشَپالَکو یَتھا چھاگیبھْیووِینْ پرِتھَکْ کَروتِ تَتھا سوپْییکَسْمادَنْیَمْ اِتّھَں تانْ پرِتھَکَ کرِتْواوِینْ ");
INSERT INTO sanurd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","دَکْشِنے چھاگاںشْچَ وامے سْتھاپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","تَتَح پَرَں راجا دَکْشِنَسْتھِتانْ مانَوانْ وَدِشْیَتِ، آگَچّھَتَ مَتّاتَسْیانُگْرَہَبھاجَنانِ، یُشْمَتْکرِتَ آ جَگَدارَمْبھَتْ یَدْ راجْیَمْ آسادِتَں تَدَدھِکُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","یَتو بُبھُکْشِتایَ مَہْیَں بھوجْیَمْ اَدَتَّ، پِپاسِتایَ پییَمَدَتَّ، وِدیشِنَں ماں سْوَسْتھانَمَنَیَتَ، ");
INSERT INTO sanurd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","وَسْتْرَہِینَں ماں وَسَنَں پَرْیَّدھاپَیَتَ، پِیڈِیتَں ماں دْرَشْٹُماگَچّھَتَ، کاراسْتھَنْچَ ماں وِیکْشِتُمَ آگَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","تَدا دھارْمِّکاح پْرَتِوَدِشْیَنْتِ، ہے پْرَبھو، کَدا تْواں کْشُدھِتَں وِیکْشْیَ وَیَمَبھوجَیامَ؟ وا پِپاسِتَں وِیکْشْیَ اَپایَیامَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","کَدا وا تْواں وِدیشِنَں وِلوکْیَ سْوَسْتھانَمَنَیامَ؟ کَدا وا تْواں نَگْنَں وِیکْشْیَ وَسَنَں پَرْیَّدھاپَیامَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","کَدا وا تْواں پِیڈِتَں کاراسْتھَنْچَ وِیکْشْیَ تْوَدَنْتِکَمَگَچّھامَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","تَدانِیں راجا تانْ پْرَتِوَدِشْیَتِ، یُشْمانَہَں سَتْیَں وَدامِ، مَمَیتیشاں بھْراترِناں مَدھْیے کَنْچَنَیکَں کْشُدْرَتَمَں پْرَتِ یَدْ اَکُرُتَ، تَنْماں پْرَتْیَکُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","پَشْچاتْ سَ وامَسْتھِتانْ جَنانْ وَدِشْیَتِ، رے شاپَگْرَسْتاح سَرْوّے، شَیتانے تَسْیَ دُوتیبھْیَشْچَ یونَنْتَوَہْنِراسادِتَ آسْتے، یُویَں مَدَنْتِکاتْ تَمَگْنِں گَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","یَتو کْشُدھِتایَ مَہْیَماہارَں نادَتَّ، پِپاسِتایَ مَہْیَں پییَں نادَتَّ، ");
INSERT INTO sanurd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","وِدیشِنَں ماں سْوَسْتھانَں نانَیَتَ، وَسَنَہِینَں ماں وَسَنَں نَ پَرْیَّدھاپَیَتَ، پِیڈِتَں کاراسْتھَنْچَ ماں وِیکْشِتُں ناگَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","تَدا تے پْرَتِوَدِشْیَنْتِ، ہے پْرَبھو، کَدا تْواں کْشُدھِتَں وا پِپاسِتَں وا وِدیشِنَں وا نَگْنَں وا پِیڈِتَں وا کاراسْتھَں وِیکْشْیَ تْواں ناسیوامَہِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","تَدا سَ تانْ وَدِشْیَتِ، تَتھْیَمَہَں یُشْمانْ بْرَوِیمِ، یُشْمابھِریشاں کَنْچَنَ کْشودِشْٹھَں پْرَتِ یَنّاکارِ، تَنْماں پْرَتْییوَ ناکارِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","پَشْچادَمْیَنَنْتَشاسْتِں کِنْتُ دھارْمِّکا اَنَنْتایُشَں بھوکْتُں یاسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","یِیشُریتانْ پْرَسْتاوانْ سَماپْیَ شِشْیانُوچے، ");
INSERT INTO sanurd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","یُشْمابھِ رْجْناتَں دِنَدْوَیاتْ پَرَں نِسْتارَمَہَ اُپَسْتھاسْیَتِ، تَتْرَ مَنُجَسُتَح کْرُشینَ ہَنْتُں پَرَکَریشُ سَمَرْپِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","تَتَح پَرَں پْرَدھانَیاجَکادھْیاپَکَپْرانْچَح کِیَپھانامْنو مَہایاجَکَسْیاٹّالِکایاں مِلِتْوا ");
INSERT INTO sanurd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","کینوپایینَ یِیشُں دھرِتْوا ہَنْتُں شَکْنُیُرِتِ مَنْتْرَیانْچَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","کِنْتُ تَیرُکْتَں مَہَکالے نَ دھَرْتَّوْیَح، دھرِتے پْرَجاناں کَلَہینَ بھَوِتُں شَکْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","تَتو بَیتھَنِیاپُرے شِموناکھْیَسْیَ کُشْٹھِنو ویشْمَنِ یِیشَو تِشْٹھَتِ ");
INSERT INTO sanurd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","کاچَنَ یوشا شْویتوپَلَبھاجَنینَ مَہارْگھْیَں سُگَنْدھِ تَیلَمانِییَ بھوجَنایوپَوِشَتَسْتَسْیَ شِروبھْیَشیچَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","کِنْتُ تَدالوکْیَ تَچّھِشْیَیح کُپِتَیرُکْتَں، کُتَ اِتّھَمَپَوْیَیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","چیدِدَں وْیَکْریشْیَتَ، تَرْہِ بھُورِمُولْیَں پْراپْیَ دَرِدْریبھْیو وْیَتارِشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","یِیشُنا تَدَوَگَتْیَ تے سَمُدِتاح، یوشامیناں کُتو دُحکھِنِیں کُرُتھَ، سا ماں پْرَتِ سادھُ کَرْمّاکارْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","یُشْماکَمَں سَمِیپے دَرِدْراح سَتَتَمیواسَتے، کِنْتُ یُشْماکَمَنْتِکیہَں ناسے سَتَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","سا مَمَ کایوپَرِ سُگَنْدھِتَیلَں سِکْتْوا مَمَ شْمَشانَدانَکَرْمّاکارْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","اَتوہَں یُشْمانْ تَتھْیَں وَدامِ سَرْوَّسْمِنْ جَگَتِ یَتْرَ یَتْرَیشَ سُسَماچارَح پْرَچارِشْیَتے، تَتْرَ تَتْرَیتَسْیا نارْیّاح سْمَرَنارْتھَمْ کَرْمّیدَں پْرَچارِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","تَتو دْوادَشَشِشْیانامْ اِیشْکَرِیوتِییَیِہُودانامَکَ ایکَح شِشْیَح پْرَدھانَیاجَکانامَنْتِکَں گَتْوا کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","یَدِ یُشْماکَں کَریشُ یِیشُں سَمَرْپَیامِ، تَرْہِ کِں داسْیَتھَ؟ تَدانِیں تے تَسْمَے تْرِںشَنْمُدْرا داتُں سْتھِرِیکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","سَ تَدارَبھْیَ تَں پَرَکَریشُ سَمَرْپَیِتُں سُیوگَں چیشْٹِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","اَنَنْتَرَں کِنْوَشُونْیَپُوپَپَرْوَّنَح پْرَتھَمیہْنِ شِشْیا یِیشُمْ اُپَگَتْیَ پَپْرَچّھُح بھَوَتْکرِتے کُتْرَ وَیَں نِسْتارَمَہَبھوجْیَمْ آیوجَیِشْیامَح؟ بھَوَتَح کیچّھا؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","تَدا سَ گَدِتَوانْ، مَدھْیینَگَرَمَمُکَپُںسَح سَمِیپَں وْرَجِتْوا وَدَتَ، گُرُ رْگَدِتَوانْ، مَتْکالَح سَوِدھَح، سَہَ شِشْیَیسْتْوَدالَیے نِسْتارَمَہَبھوجْیَں بھوکْشْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","تَدا شِشْیا یِیشوسْتادرِشَنِدیشانُرُوپَکَرْمَّ وِدھایَ تَتْرَ نِسْتارَمَہَبھوجْیَماسادَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","تَتَح سَنْدھْیایاں سَتْیاں دْوادَشَبھِح شِشْیَیح ساکَں سَ نْیَوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","اَپَرَں بھُنْجانَ اُکْتَوانْ یُشْمانْ تَتھْیَں وَدامِ، یُشْماکَمیکو ماں پَرَکَریشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","تَدا تےتِیوَ دُحکھِتا ایکَیکَشو وَکْتُماریبھِرے، ہے پْرَبھو، سَ کِمَہَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","تَتَح سَ جَگادَ، مَیا ساکَں یو جَنو بھوجَنَپاتْرے کَرَں سَںکْشِپَتِ، سَ ایوَ ماں پَرَکَریشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","مَنُجَسُتَمَدھِ یادرِشَں لِکھِتَماسْتے، تَدَنُرُوپا تَدْگَتِ رْبھَوِشْیَتِ؛ کِنْتُ یینَ پُںسا سَ پَرَکَریشُ سَمَرْپَیِشْیَتے، ہا ہا چیتْ سَ ناجَنِشْیَتَ، تَدا تَسْیَ کْشیمَمَبھَوِشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","تَدا یِہُوداناما یو جَنَسْتَں پَرَکَریشُ سَمَرْپَیِشْیَتِ، سَ اُکْتَوانْ، ہے گُرو، سَ کِمَہَں؟ تَتَح سَ پْرَتْیُکْتَوانْ، تْوَیا سَتْیَں گَدِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","اَنَنْتَرَں تیشامَشَنَکالے یِیشُح پُوپَماداییشْوَرِییَگُنانَنُودْیَ بھَںکْتْوا شِشْییبھْیَح پْرَدایَ جَگادَ، مَدْوَپُحسْوَرُوپَمِمَں گرِہِیتْوا کھادَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","پَشْچاتْ سَ کَںسَں گرِہْلَنْ اِیشْوَرِییَگُنانَنُودْیَ تیبھْیَح پْرَدایَ کَتھِتَوانْ، سَرْوَّے رْیُشْمابھِرَنینَ پاتَوْیَں، ");
INSERT INTO sanurd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","یَسْمادَنیکیشاں پاپَمَرْشَنایَ پاتِتَں یَنْمَنُّوتْنَنِیَمَرُوپَشونِتَں تَدیتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","اَپَرَمَہَں نُوتْنَگوسْتَنِیرَسَں نَ پاسْیامِ، تاوَتْ گوسْتَنِیپھَلَرَسَں پُنَح کَداپِ نَ پاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","پَشْچاتْ تے گِیتَمیکَں سَںگِییَ جَیتُناکھْیَگِرِں گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","تَدانِیں یِیشُسْتانَووچَتْ، اَسْیاں رَجَنْیامَہَں یُشْماکَں سَرْوّیشاں وِگھْنَرُوپو بھَوِشْیامِ، یَتو لِکھِتَماسْتے، \"میشاناں رَکْشَکو یَسْتَں پْرَہَرِشْیامْیَہَں تَتَح۔ میشاناں نِوَہو نُونَں پْرَوِکِیرْنو بھَوِشْیَتِ\"۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","کِنْتُ شْمَشاناتْ سَمُتّھایَ یُشْماکَمَگْرےہَں گالِیلَں گَمِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","پِتَرَسْتَں پْروواچَ، بھَواںشْچیتْ سَرْوّیشاں وِگھْنَرُوپو بھَوَتِ، تَتھاپِ مَمَ نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","تَتو یِیشُنا سَ اُکْتَح، تُبھْیَمَہَں تَتھْیَں کَتھَیامِ، یامِنْیامَسْیاں چَرَنایُدھَسْیَ رَواتْ پُورْوَّں تْوَں ماں تْرِ رْنانْگِیکَرِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","تَتَح پِتَرَ اُدِتَوانْ، یَدْیَپِ تْوَیا سَمَں مَرْتَّوْیَں، تَتھاپِ کَداپِ تْواں نَ نانْگِیکَرِشْیامِ؛ تَتھَیوَ سَرْوّے شِشْیاشْچوچُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","اَنَنْتَرَں یِیشُح شِشْیَیح ساکَں گیتْشِمانِینامَکَں سْتھانَں پْرَسْتھایَ تیبھْیَح کَتھِتَوانْ، اَدَح سْتھانَں گَتْوا یاوَدَہَں پْرارْتھَیِشْیے تاوَدْ یُویَمَتْروپَوِشَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","پَشْچاتْ سَ پِتَرَں سِوَدِیَسُتَو چَ سَنْگِنَح کرِتْوا گَتَوانْ، شوکاکُلوتِیوَ وْیَتھِتَشْچَ بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","تانَوادِیچَّ مرِتِیاتَنیوَ مَتْپْراناناں یاتَنا جایَتے، یُویَمَتْرَ مَیا سارْدّھَں جاگرِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","تَتَح سَ کِنْچِدُّورَں گَتْوادھومُکھَح پَتَنْ پْرارْتھَیانْچَکْرے، ہے مَتْپِتَرْیَدِ بھَوِتُں شَکْنوتِ، تَرْہِ کَںسویَں مَتّو دُورَں یاتُ؛ کِنْتُ مَدِچّھاوَتْ نَ بھَوَتُ، تْوَدِچّھاوَدْ بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","تَتَح سَ شِشْیانُپیتْیَ تانْ نِدْرَتو نِرِیکْشْیَ پِتَرایَ کَتھَیاماسَ، یُویَں مَیا ساکَں دَنْڈَمیکَمَپِ جاگَرِتُں ناشَنْکُتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","پَرِیکْشایاں نَ پَتِتُں جاگرِتَ پْرارْتھَیَدھْوَنْچَ؛ آتْما سَمُدْیَتوسْتِ، کِنْتُ وَپُ رْدُرْبَّلَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","سَ دْوِتِییَوارَں پْرارْتھَیانْچَکْرے، ہے مَتّاتَ، نَ پِیتے یَدِ کَںسَمِدَں مَتّو دُورَں یاتُں نَ شَکْنوتِ، تَرْہِ تْوَدِچّھاوَدْ بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","سَ پُنَریتْیَ تانْ نِدْرَتو دَدَرْشَ، یَتَسْتیشاں نیتْرانِ نِدْرَیا پُورْنانْیاسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","پَشْچاتْ سَ تانْ وِہایَ وْرَجِتْوا ترِتِییَوارَں پُورْوَّوَتْ کَتھَیَنْ پْرارْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","تَتَح شِشْیانُپاگَتْیَ گَدِتَوانْ، سامْپْرَتَں شَیاناح کِں وِشْرامْیَتھَ؟ پَشْیَتَ، سَمَیَ اُپاسْتھاتْ، مَنُجَسُتَح پاپِناں کَریشُ سَمَرْپْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","اُتِّشْٹھَتَ، وَیَں یامَح، یو ماں پَرَکَریشُ مَسَرْپَیِشْیَتِ، پَشْیَتَ، سَ سَمِیپَمایاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ایتَتْکَتھاکَتھَنَکالے دْوادَشَشِشْیانامیکو یِہُودانامَکو مُکھْیَیاجَکَلوکَپْراچِینَیح پْرَہِتانْ اَسِدھارِیَشْٹِدھارِنو مَنُجانْ گرِہِیتْوا تَتْسَمِیپَمُپَتَسْتھَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","اَسَو پَرَکَریشْوَرْپَیِتا پُورْوَّں تانْ اِتّھَں سَنْکیتَیاماسَ، یَمَہَں چُمْبِشْیے، سوسَو مَنُجَح،سَایوَ یُشْمابھِ رْدھارْیَّتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","تَدا سَ سَپَدِ یِیشُمُپاگَتْیَ ہے گُرو، پْرَنَمامِیتْیُکْتْوا تَں چُچُمْبے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","تَدا یِیشُسْتَمُواچَ، ہے مِتْرَں کِمَرْتھَماگَتوسِ؟ تَدا تَیراگَتْیَ یِیشُراکْرَمْیَ دَگھْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","تَتو یِیشوح سَنْگِنامیکَح کَرَں پْرَسارْیَّ کوشادَسِں بَہِشْکرِتْیَ مَہایاجَکَسْیَ داسَمیکَماہَتْیَ تَسْیَ کَرْنَں چِچّھیدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","تَتو یِیشُسْتَں جَگادَ، کھَڈْگَں سْوَسْتھانےे نِدھیہِ یَتو یے یے جَنا اَسِں دھارَیَنْتِ، تَایواسِنا وِنَشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","اَپَرَں پِتا یَتھا مَدَنْتِکَں سْوَرْگِییَدُوتاناں دْوادَشَواہِنِیتودھِکَں پْرَہِنُیاتْ مَیا تَمُدِّشْییدانِیمیوَ تَتھا پْرارْتھَیِتُں نَ شَکْیَتے، تْوَیا کِمِتّھَں جْنایَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","تَتھا سَتِیتّھَں گھَٹِشْیَتے دھَرْمَّپُسْتَکَسْیَ یَدِدَں واکْیَں تَتْ کَتھَں سِدھْییتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","تَدانِیں یِیشُ رْجَنَنِوَہَں جَگادَ، یُویَں کھَڈْگَیَشْٹِینْ آدایَ ماں کِں چَورَں دھَرْتُّمایاتاح؟ اَہَں پْرَتْیَہَں یُشْمابھِح ساکَمُپَوِشْیَ سَمُپادِشَں، تَدا ماں نادھَرَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","کِنْتُ بھَوِشْیَدْوادِناں واکْیاناں سَںسِدّھَیے سَرْوَّمیتَدَبھُوتْ۔ تَدا سَرْوّے شِشْیاسْتَں وِہایَ پَلایَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","اَنَنْتَرَں تے مَنُجا یِیشُں دھرِتْوا یَتْرادھْیاپَکَپْرانْچَح پَرِشَدَں کُرْوَّنْتَ اُپاوِشَنْ تَتْرَ کِیَپھاناाمَکَمَہایاجَکَسْیانْتِکَں نِنْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","کِنْتُ شیشے کِں بھَوِشْیَتِیتِ ویتُّں پِتَرو دُورے تَتْپَشْچادْ وْرَجِتْوا مَہایاجَکَسْیاٹّالِکاں پْرَوِشْیَ داسَیح سَہِتَ اُپاوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","تَدانِیں پْرَدھانَیاجَکَپْراچِینَمَنْتْرِنَح سَرْوّے یِیشُں ہَنْتُں مرِشاساکْشْیَمْ اَلِپْسَنْتَ، ");
INSERT INTO sanurd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","کِنْتُ نَ لیبھِرے۔ اَنیکیشُ مرِشاساکْشِشْواگَتیشْوَپِ تَنَّ پْراپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","شیشے دْوَو مرِشاساکْشِناواگَتْیَ جَگَدَتُح، پُمانَیَمَکَتھَیَتْ، اَہَمِیشْوَرَمَنْدِرَں بھَںکْتْوا دِنَتْرَیَمَدھْیے تَنِّرْمّاتُں شَکْنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","تَدا مَہایاجَکَ اُتّھایَ یِیشُمْ اَوادِیتْ۔ تْوَں کِمَپِ نَ پْرَتِوَدَسِ؟ تْوامَدھِ کِمیتے ساکْشْیَں وَدَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","کِنْتُ یِیشُ رْمَونِیبھُویَ تَسْیَو۔ تَتو مَہایاجَکَ اُکْتَوانْ، تْوامْ اَمَریشْوَرَنامْنا شَپَیامِ، تْوَمِیشْوَرَسْیَ پُتْروبھِشِکْتو بھَوَسِ نَویتِ وَدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","یِیشُح پْرَتْیَوَدَتْ، تْوَں سَتْیَمُکْتَوانْ؛ اَہَں یُشْمانْ تَتھْیَں وَدامِ، اِتَحپَرَں مَنُجَسُتَں سَرْوَّشَکْتِمَتو دَکْشِنَپارْشْوے سْتھاتُں گَگَنَسْتھَں جَلَدھَرانارُہْیایانْتَں وِیکْشَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","تَدا مَہایاجَکو نِجَوَسَنَں چھِتّوا جَگادَ، ایشَ اِیشْوَرَں نِنْدِتَوانْ، اَسْماکَمَپَرَساکْشْیینَ کِں پْرَیوجَنَں؟ پَشْیَتَ، یُویَمیواسْیاسْیادْ اِیشْوَرَنِنْداں شْرُتَوَنْتَح، ");
INSERT INTO sanurd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","یُشْمابھِح کِں وِوِچْیَتے؟ تے پْرَتْیُوچُح، وَدھارْہویَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","تَتو لوکَیسْتَداسْیے نِشْٹھِیوِتَں کیچِتْ پْرَتَلَماہَتْیَ کیچِچَّ چَپیٹَماہَتْیَ بَبھاشِرے، ");
INSERT INTO sanurd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ہے کھْرِیشْٹَ تْواں کَشْچَپیٹَماہَتَوانْ؟ اِتِ گَنَیِتْوا وَداسْمانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","پِتَرو بَہِرَنْگَنَ اُپَوِشَتِ، تَدانِیمیکا داسِی تَمُپاگَتْیَ بَبھاشے، تْوَں گالِیلِییَیِیشوح سَہَچَرَایکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","کِنْتُ سَ سَرْوّیشاں سَمَکْشَمْ اَنَنْگِیکرِتْیاوادِیتْ، تْوَیا یَدُچْیَتے، تَدَرْتھَمَہَں نَ ویدْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","تَدا تَسْمِنْ بَہِرْدْوارَں گَتے نْیا داسِی تَں نِرِیکْشْیَ تَتْرَتْیَجَنانَوَدَتْ، اَیَمَپِ ناسَرَتِییَیِیشُنا سارْدّھَمْ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","تَتَح سَ شَپَتھینَ پُنَرَنَنْگِیکرِتْیَ کَتھِتَوانْ، تَں نَرَں نَ پَرِچِنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","کْشَناتْ پَرَں تِشْٹھَنْتو جَنا ایتْیَ پِتَرَمْ اَوَدَنْ، تْوَمَوَشْیَں تیشامیکَ اِتِ تْوَدُچّارَنَمیوَ دْیوتَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","کِنْتُ سوبھِشَپْیَ کَتھِتَوانْ، تَں جَنَں ناہَں پَرِچِنومِ، تَدا سَپَدِ کُکُّٹو رُراوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","کُکُّٹَرَواتْ پْراکْ تْوَں ماں تْرِرَپاہْنوشْیَسے، یَیشا واگْ یِیشُناوادِ تاں پِتَرَح سَںسْمرِتْیَ بَہِرِتْوا کھیدادْ بھرِشَں چَکْرَنْدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","پْرَبھاتے جاتے پْرَدھانَیاجَکَلوکَپْراچِینا یِیشُں ہَنْتُں تَتْپْرَتِکُولَں مَنْتْرَیِتْوا ");
INSERT INTO sanurd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","تَں بَدْوّا نِیتْوا پَنْتِییَپِیلاتاکھْیادھِپے سَمَرْپَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","تَتو یِیشوح پَرَکَریوَّرْپَیِتا یِہُوداسْتَتْپْرانادَنْڈاجْناں وِدِتْوا سَنْتَپْتَمَناح پْرَدھانَیاجَکَلوکَپْراچِیناناں سَمَکْشَں تاسْتْرِیںشَنْمُدْراح پْرَتِدایاوادِیتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ایتَنِّراگونَرَپْرانَپَرَکَرارْپَناتْ کَلُشَں کرِتَوانَہَں۔ تَدا تَ اُدِتَوَنْتَح، تیناسْماکَں کِں؟ تْوَیا تَدْ بُدھْیَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","تَتو یِہُودا مَنْدِرَمَدھْیے تا مُدْرا نِکْشِپْیَ پْرَسْتھِتَوانْ اِتْوا چَ سْوَیَماتْمانَمُدْبَبَنْدھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","پَشْچاتْ پْرَدھانَیاجَکاسْتا مُدْرا آدایَ کَتھِتَوَنْتَح، ایتا مُدْراح شونِتَمُولْیَں تَسْمادْ بھانْڈاگارے نَ نِدھاتَوْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","اَنَنْتَرَں تے مَنْتْرَیِتْوا وِدیشِناں شْمَشانَسْتھانایَ تابھِح کُلالَسْیَ کْشیتْرَمَکْرِینَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","اَتودْیاپِ تَتْسْتھانَں رَکْتَکْشیتْرَں وَدَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","اِتّھَں سَتِ اِسْراییلِییَسَنْتانَے رْیَسْیَ مُولْیَں نِرُپِتَں، تَسْیَ تْرِںشَنْمُدْرامانَں مُولْیَں ");
INSERT INTO sanurd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ماں پْرَتِ پَرَمیشْوَرَسْیادیشاتْ تیبھْیَ آدِییَتَ، تینَ چَ کُلالَسْیَ کْشیتْرَں کْرِیتَمِتِ یَدْوَچَنَں یِرِمِیَبھَوِشْیَدْوادِنا پْروکْتَں تَتْ تَداسِدھْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","اَنَنْتَرَں یِیشَو تَدَدھِپَتیح سَمُّکھَ اُپَتِشْٹھَتِ سَ تَں پَپْرَچّھَ، تْوَں کِں یِہُودِییاناں راجا؟ تَدا یِیشُسْتَمَوَدَتْ، تْوَں سَتْیَمُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","کِنْتُ پْرَدھانَیاجَکَپْراچِینَیرَبھِیُکْتینَ تینَ کِمَپِ نَ پْرَتْیَوادِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","تَتَح پِیلاتینَ سَ اُدِتَح، اِمے تْوَتْپْرَتِکُولَتَح کَتِ کَتِ ساکْشْیَں دَدَتِ، تَتْ تْوَں نَ شرِنوشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","تَتھاپِ سَ تیشامیکَسْیاپِ وَچَسَ اُتَّرَں نودِتَوانْ؛ تینَ سودھِپَتِ رْمَہاچِتْرَں وِداماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","اَنْیَچَّ تَنْمَہَکالےدھِپَتیریتادرِشِی راتِراسِیتْ، پْرَجا یَں کَنْچَنَ بَنْدھِنَں یاچَنْتے، تَمیوَ سَ موچَیَتِیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","تَدانِیں بَرَبّاناما کَشْچِتْ کھْیاتَبَنْدھْیاسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","تَتَح پِیلاتَسْتَتْرَ مِلِتانْ لوکانْ اَپرِچّھَتْ، ایشَ بَرَبّا بَنْدھِی کھْرِیشْٹَوِکھْیاتو یِیشُشْچَیتَیوح کَں موچَیِشْیامِ؟ یُشْماکَں کِمِیپْسِتَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","تَیرِیرْشْیَیا سَ سَمَرْپِتَ اِتِ سَ جْناتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","اَپَرَں وِچاراسَنوپَویشَنَکالے پِیلاتَسْیَ پَتْنِی بھرِتْیَں پْرَہِتْیَ تَسْمَے کَتھَیاماسَ، تَں دھارْمِّکَمَنُجَں پْرَتِ تْوَیا کِمَپِ نَ کَرْتَّوْیَں؛ یَسْماتْ تَتْکرِتےدْیاہَں سْوَپْنے پْرَبھُوتَکَشْٹَمَلَبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","اَنَنْتَرَں پْرَدھانَیاجَکَپْراچِینا بَرَبّاں یاچِتْواداتُں یِیشُنْچَ ہَنْتُں سَکَلَلوکانْ پْراوَرْتَّیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","تَتودھِپَتِسْتانْ پرِشْٹَوانْ، ایتَیوح کَمَہَں موچَیِشْیامِ؟ یُشْماکَں کیچّھا؟ تے پْروچُ رْبَرَبّاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","تَدا پِیلاتَح پَپْرَچّھَ، تَرْہِ یَں کھْرِیشْٹَں وَدَنْتِ، تَں یِیشُں کِں کَرِشْیامِ؟ سَرْوّے کَتھَیاماسُح، سَ کْرُشینَ وِدھْیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","تَتودھِپَتِرَوادِیتْ، کُتَح؟ کِں تیناپَرادّھَں؟ کِنْتُ تے پُنَرُچَے رْجَگَدُح، سَ کْرُشینَ وِدھْیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","تَدا نِجَواکْیَمَگْراہْیَمَبھُوتْ، کَلَہَشْچاپْیَبھُوتْ، پِیلاتَ اِتِ وِلوکْیَ لوکاناں سَمَکْشَں تویَمادایَ کَرَو پْرَکْشالْیاووچَتْ، ایتَسْیَ دھارْمِّکَمَنُشْیَسْیَ شونِتَپاتے نِرْدوشوہَں، یُشْمابھِریوَ تَدْ بُدھْیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","تَدا سَرْوّاح پْرَجاح پْرَتْیَووچَنْ، تَسْیَ شونِتَپاتاپَرادھوسْماکَمْ اَسْمَتْسَنْتانانانْچوپَرِ بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","تَتَح سَ تیشاں سَمِیپے بَرَبّاں موچَیاماسَ یِیشُنْتُ کَشابھِراہَتْیَ کْرُشینَ ویدھِتُں سَمَرْپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","اَنَنْتَرَمْ اَدھِپَتیح سینا اَدھِپَتے رْگرِہَں یِیشُمانِییَ تَسْیَ سَمِیپے سیناسَمُوہَں سَںجَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","تَتَسْتے تَسْیَ وَسَنَں موچَیِتْوا کرِشْنَلوہِتَوَرْنَوَسَنَں پَرِدھاپَیاماسُح ");
INSERT INTO sanurd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","کَنْٹَکاناں مُکُٹَں نِرْمّایَ تَچّھِرَسِ دَدُح، تَسْیَ دَکْشِنَکَرے ویتْرَمیکَں دَتّوا تَسْیَ سَمُّکھے جانُونِ پاتَیِتْوا، ہے یِہُودِییاناں راجَنْ، تُبھْیَں نَمَ اِتْیُکْتْوا تَں تِرَشْچَکْرُح، ");
INSERT INTO sanurd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","تَتَسْتَسْیَ گاتْرے نِشْٹھِیوَں دَتْوا تینَ ویتْرینَ شِرَ آجَگھْنُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","اِتّھَں تَں تِرَسْکرِتْیَ تَدْ وَسَنَں موچَیِتْوا پُنَرْنِجَوَسَنَں پَرِدھاپَیانْچَکْرُح، تَں کْرُشینَ ویدھِتُں نِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","پَشْچاتّے بَہِرْبھُویَ کُرِینِییَں شِمونّامَکَمیکَں وِلوکْیَ کْرُشَں ووڈھُں تَمادَدِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","اَنَنْتَرَں گُلْگَلْتامْ اَرْتھاتْ شِرَسْکَپالَنامَکَسْتھانَمُ پَسْتھایَ تے یِیشَوے پِتَّمِشْرِتامْلَرَسَں پاتُں دَدُح، ");
INSERT INTO sanurd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","کِنْتُ سَ تَماسْوادْیَ نَ پَپَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","تَدانِیں تے تَں کْرُشینَ سَںوِدھْیَ تَسْیَ وَسَنانِ گُٹِکاپاتینَ وِبھَجْیَ جَگرِہُح، تَسْماتْ، وِبھَجَنْتےدھَرِییَں مے تے مَنُشْیاح پَرَسْپَرَں۔ مَدُتَّرِییَوَسْتْرارْتھَں گُٹِکاں پاتَیَنْتِ چَ۔۔ یَدیتَدْوَچَنَں بھَوِشْیَدْوادِبھِرُکْتَماسِیتْ، تَدا تَدْ اَسِدھْیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","پَشْچاتْ تے تَتْروپَوِشْیَ تَدْرَکْشَنَکَرْوَّنِ نِیُکْتاسْتَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","اَپَرَمْ ایشَ یِہُودِییاناں راجا یِیشُرِتْیَپَوادَلِپِپَتْرَں تَچّھِرَسَ اُورْدْوّے یوجَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","تَتَسْتَسْیَ وامے دَکْشِنے چَ دْوَو چَیرَو تینَ ساکَں کْرُشینَ وِوِدھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","تَدا پانْتھا نِجَشِرو لاڈَیِتْوا تَں نِنْدَنْتو جَگَدُح، ");
INSERT INTO sanurd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ہے اِیشْوَرَمَنْدِرَبھَنْجَکَ دِنَتْرَیے تَنِّرْمّاتَح سْوَں رَکْشَ، چیتّوَمِیشْوَرَسُتَسْتَرْہِ کْرُشادَوَروہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","پْرَدھانَیاجَکادھْیاپَکَپْراچِیناشْچَ تَتھا تِرَسْکرِتْیَ جَگَدُح، ");
INSERT INTO sanurd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","سونْیَجَناناوَتْ، کِنْتُ سْوَمَوِتُں نَ شَکْنوتِ۔ یَدِیسْراییلو راجا بھَویتْ، تَرْہِیدانِیمیوَ کْرُشادَوَروہَتُ، تینَ تَں وَیَں پْرَتْییشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","سَ اِیشْوَرے پْرَتْیاشامَکَروتْ، یَدِیشْوَرَسْتَسْمِنْ سَنْتُشْٹَسْتَرْہِیدانِیمیوَ تَمَویتْ، یَتَح سَ اُکْتَوانْ اَہَمِیشْوَرَسُتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","یَو سْتینَو ساکَں تینَ کْرُشینَ وِدّھَو تَو تَدْوَدیوَ تَں نِنِنْدَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","تَدا دْوِتِییَیاماتْ ترِتِییَیامَں یاوَتْ سَرْوَّدیشے تَمِرَں بَبھُووَ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ترِتِییَیامے \"ایلِی ایلِی لاما شِوَکْتَنِی\"، اَرْتھاتْ مَدِیشْوَرَ مَدِیشْوَرَ کُتو مامَتْیاکْشِیح؟ یِیشُرُچَّیرِتِ جَگادَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","تَدا تَتْرَ سْتھِتاح کیچِتْ تَتْ شْرُتْوا بَبھاشِرے، اَیَمْ ایلِیَماہُویَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","تیشاں مَدھْیادْ ایکَح شِیگھْرَں گَتْوا سْپَنْجَں گرِہِیتْوا تَتْرامْلَرَسَں دَتّوا نَلینَ پاتُں تَسْمَے دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","اِتَرےکَتھَیَنْ تِشْٹھَتَ، تَں رَکْشِتُمْ ایلِیَ آیاتِ نَویتِ پَشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","یِیشُح پُنَرُچَیراہُویَ پْرانانْ جَہَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","تَتو مَنْدِرَسْیَ وِچّھیدَوَسَنَمْ اُورْدْوّادَدھو یاوَتْ چھِدْیَمانَں دْوِدھابھَوَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","بھُومِشْچَکَمْپے بھُودھَرووْیَدِیرْیَّتَ چَ۔ شْمَشانے مُکْتے بھُورِپُنْیَوَتاں سُپْتَدیہا اُدَتِشْٹھَنْ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","شْمَشانادْ وَہِرْبھُویَ تَدُتّھاناتْ پَرَں پُنْیَپُرَں گَتْوا بَہُجَنانْ دَرْشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","یِیشُرَکْشَنایَ نِیُکْتَح شَتَسیناپَتِسْتَتْسَنْگِنَشْچَ تادرِشِیں بھُوکَمْپادِگھَٹَناں درِشْٹْوا بھِیتا اَوَدَنْ، ایشَ اِیشْوَرَپُتْرو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","یا بَہُیوشِتو یِیشُں سیوَمانا گالِیلَسْتَتْپَشْچاداگَتاسْتاساں مَدھْیی ");
INSERT INTO sanurd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","مَگْدَلِینِی مَرِیَمْ یاکُوبْیوشْیو رْماتا یا مَرِیَمْ سِبَدِیَپُتْرَیو رْماتا چَ یوشِتَ ایتا دُورے تِشْٹھَنْتْیو دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","سَنْدھْیایاں سَتْیَمْ اَرِمَتھِیانَگَرَسْیَ یُوشَپھْناما دھَنِی مَنُجو یِیشوح شِشْیَتْواتْ ");
INSERT INTO sanurd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","پِیلاتَسْیَ سَمِیپَں گَتْوا یِیشوح کایَں یَیاچے، تینَ پِیلاتَح کایَں داتُمْ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","یُوشَپھْ تَتْکایَں نِیتْوا شُچِوَسْتْریناچّھادْیَ ");
INSERT INTO sanurd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","سْوارْتھَں شَیلے یَتْ شْمَشانَں چَکھانَ، تَنْمَدھْیے تَتْکایَں نِدھایَ تَسْیَ دْوارِ ورِہَتْپاشانَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","کِنْتُ مَگْدَلِینِی مَرِیَمْ اَنْیَمَرِیَمْ ایتے سْتْرِیَو تَتْرَ شْمَشانَسَمُّکھَ اُپَوِوِشَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","تَدَنَنْتَرَں نِسْتاروتْسَوَسْیایوجَنَدِناتْ پَرےہَنِ پْرَدھانَیاجَکاح پھِرُوشِنَشْچَ مِلِتْوا پِیلاتَمُپاگَتْیاکَتھَیَنْ، ");
INSERT INTO sanurd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ہے مَہیچّھَ سَ پْرَتارَکو جِیوَنَ اَکَتھَیَتْ، دِنَتْرَیاتْ پَرَں شْمَشانادُتّھاسْیامِ تَدْواکْیَں سْمَرامو وَیَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","تَسْماتْ ترِتِییَدِنَں یاوَتْ تَتْ شْمَشانَں رَکْشِتُمادِشَتُ، نوچیتْ تَچّھِشْیا یامِنْیاماگَتْیَ تَں ہرِتْوا لوکانْ وَدِشْیَنْتِ، سَ شْمَشانادُدَتِشْٹھَتْ، تَتھا سَتِ پْرَتھَمَبھْرانْتیح شیشِییَبھْرانْتِ رْمَہَتِی بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","تَدا پِیلاتَ اَوادِیتْ، یُشْماکَں سَمِیپے رَکْشِگَنَ آسْتے، یُویَں گَتْوا یَتھا سادھْیَں رَکْشَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","تَتَسْتے گَتْوا تَدُّوाرَپاشانَں مُدْرانْکِتَں کرِتْوا رَکْشِگَنَں نِیوجْیَ شْمَشانَں رَکْشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","تَتَح پَرَں وِشْرامَوارَسْیَ شیشے سَپْتاہَپْرَتھَمَدِنَسْیَ پْرَبھوتے جاتے مَگْدَلِینِی مَرِیَمْ اَنْیَمَرِیَمْ چَ شْمَشانَں دْرَشْٹُماگَتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","تَدا مَہانْ بھُوکَمْپوبھَوَتْ؛ پَرَمیشْوَرِییَدُوتَح سْوَرْگادَوَرُہْیَ شْمَشانَدْواراتْ پاشانَمَپَسارْیَّ تَدُپَرْیُّپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","تَدْوَدَنَں وِدْیُدْوَتْ تیجومَیَں وَسَنَں ہِمَشُبھْرَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","تَدانِیں رَکْشِنَسْتَدْبھَیاتْ کَمْپِتا مرِتَوَدْ بَبھُووَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","سَ دُوتو یوشِتو جَگادَ، یُویَں ما بھَیشْٹَ، کْرُشَہَتَیِیشُں مرِگَیَدھْوے تَدَہَں ویدْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","سوتْرَ ناسْتِ، یَتھاوَدَتْ تَتھوتّھِتَوانْ؛ ایتَتْ پْرَبھوح شَیَنَسْتھانَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","تُورْنَں گَتْوا تَچّھِشْیانْ اِتِ وَدَتَ، سَ شْمَشانادْ اُدَتِشْٹھَتْ، یُشْماکَمَگْرے گالِیلَں یاسْیَتِ یُویَں تَتْرَ تَں وِیکْشِشْیَدھْوے، پَشْیَتاہَں وارْتّامِماں یُشْمانَوادِشَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","تَتَسْتا بھَیاتْ مَہانَنْدانْچَ شْمَشاناتْ تُورْنَں بَہِرْبھُویَ تَچّھِشْیانْ وارْتّاں وَکْتُں دھاوِتَوَتْیَح۔ کِنْتُ شِشْیانْ وارْتّاں وَکْتُں یانْتِ، تَدا یِیشُ رْدَرْشَنَں دَتّوا تا جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","یُشْماکَں کَلْیانَں بھُویاتْ، تَتَسْتا آگَتْیَ تَتْپادَیوح پَتِتْوا پْرَنیمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","یِیشُسْتا اَوادِیتْ، ما بِبھِیتَ، یُویَں گَتْوا مَمَ بھْراترِنْ گالِیلَں یاتُں وَدَتَ، تَتْرَ تے ماں دْرَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","سْتْرِیو گَچّھَنْتِ، تَدا رَکْشِناں کیچِتْ پُرَں گَتْوا یَدْیَدْ گھَٹِتَں تَتْسَرْوَّں پْرَدھانَیاجَکانْ جْناپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","تے پْراچِینَیح سَمَں سَںسَدَں کرِتْوا مَنْتْرَیَنْتو بَہُمُدْراح سینابھْیو دَتّواوَدَنْ، ");
INSERT INTO sanurd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","اَسْماسُ نِدْرِتیشُ تَچّھِشْیا یامِنْیاماگَتْیَ تَں ہرِتْوانَیَنْ، اِتِ یُویَں پْرَچارَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","یَدْییتَدَدھِپَتیح شْروتْرَگوچَرِیبھَویتْ، تَرْہِ تَں بودھَیِتْوا یُشْمانَوِشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","تَتَسْتے مُدْرا گرِہِیتْوا شِکْشانُرُوپَں کَرْمَّ چَکْرُح، یِہُودِییاناں مَدھْیے تَسْیادْیاپِ کِںوَدَنْتِی وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ایکادَشَ شِشْیا یِیشُنِرُوپِتاگالِیلَسْیادْرِں گَتْوا ");
INSERT INTO sanurd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","تَتْرَ تَں سَںوِیکْشْیَ پْرَنیمُح، کِنْتُ کیچِتْ سَنْدِگْدھَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","یِیشُسْتیشاں سَمِیپَماگَتْیَ وْیاہرِتَوانْ، سْوَرْگَمیدِنْیوح سَرْوّادھِپَتِتْوَبھارو مَیَّرْپِتَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","اَتو یُویَں پْرَیایَ سَرْوَّدیشِییانْ شِشْیانْ کرِتْوا پِتُح پُتْرَسْیَ پَوِتْرَسْیاتْمَنَشْچَ نامْنا تانَوَگاہَیَتَ؛ اَہَں یُشْمانْ یَدْیَدادِشَں تَدَپِ پالَیِتُں تانُپادِشَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","پَشْیَتَ، جَگَدَنْتَں یاوَتْ سَداہَں یُشْمابھِح ساکَں تِشْٹھامِ۔ اِتِ۔");
INSERT INTO sanurd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","اِیشْوَرَپُتْرَسْیَ یِیشُکھْرِیشْٹَسْیَ سُسَںوادارَمْبھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","بھَوِشْیَدْوادِناں گْرَنْتھیشُ لِپِرِتّھَماسْتے، پَشْیَ سْوَکِییَدُوتَنْتُ تَواگْرے پْریشَیامْیَہَمْ۔ گَتْوا تْوَدِییَپَنْتھانَں سَ ہِ پَرِشْکَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"پَرَمیشَسْیَ پَنْتھانَں پَرِشْکُرُتَ سَرْوَّتَح۔ تَسْیَ راجَپَتھَنْچَیوَ سَمانَں کُرُتادھُنا۔ \" اِتْییتَتْ پْرانْتَرے واکْیَں وَدَتَح کَسْیَچِدْرَوَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","سَایوَ یوہَنْ پْرانْتَرے مَجِّتَوانْ تَتھا پاپَمارْجَنَنِمِتَّں مَنووْیاوَرْتَّکَمَجَّنَسْیَ کَتھانْچَ پْرَچارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","تَتو یِہُودادیشَیِرُوشالَمْنَگَرَنِواسِنَح سَرْوّے لوکا بَہِ رْبھُوتْوا تَسْیَ سَمِیپَماگَتْیَ سْوانِ سْوانِ پاپانْیَنْگِیکرِتْیَ یَرْدَّنَنَدْیاں تینَ مَجِّتا بَبھُووُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","اَسْیَ یوہَنَح پَرِدھییانِ کْرَمیلَکَلومَجانِ، تَسْیَ کَٹِبَنْدھَنَں چَرْمَّجاتَمْ، تَسْیَ بھَکْشْیانِ چَ شُوکَکِیٹا وَنْیَمَدھُونِ چاسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","سَ پْرَچارَیَنْ کَتھَیانْچَکْرے، اَہَں نَمْرِیبھُویَ یَسْیَ پادُکابَنْدھَنَں موچَیِتُمَپِ نَ یوگْیوسْمِ، تادرِشو مَتّو گُرُتَرَ ایکَح پُرُشو مَتْپَشْچاداگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","اَہَں یُشْمانْ جَلے مَجِّتَوانْ کِنْتُ سَ پَوِتْرَ آتْمانِ سَںمَجَّیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","اَپَرَنْچَ تَسْمِنّیوَ کالے گالِیلْپْرَدیشَسْیَ ناسَرَدْگْرامادْ یِیشُراگَتْیَ یوہَنا یَرْدَّنَنَدْیاں مَجِّتوبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","سَ جَلادُتّھِتَماتْرو میگھَدْوارَں مُکْتَں کَپوتَوَتْ سْوَسْیوپَرِ اَوَروہَنْتَماتْمانَنْچَ درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","تْوَں مَمَ پْرِیَح پُتْرَسْتْوَیّیوَ مَمَمَہاسَنْتوشَ اِیَماکاشِییا وانِی بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","تَسْمِنْ کالے آتْما تَں پْرانْتَرَمَدھْیَں نِنایَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","اَتھَ سَ چَتْوارِںشَدِّنانِ تَسْمِنْ سْتھانے وَنْیَپَشُبھِح سَہَ تِشْٹھَنْ شَیتانا پَرِیکْشِتَح؛ پَشْچاتْ سْوَرْگِییَدُوتاسْتَں سِشیوِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","اَنَنْتَرَں یوہَنِ بَنْدھَنالَیے بَدّھے سَتِ یِیشُ رْگالِیلْپْرَدیشَماگَتْیَ اِیشْوَرَراجْیَسْیَ سُسَںوادَں پْرَچارَیَنْ کَتھَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","کالَح سَمْپُورْنَ اِیشْوَرَراجْیَنْچَ سَمِیپَماگَتَں؛ اَتوہیتو رْیُویَں مَناںسِ وْیاوَرْتَّیَدھْوَں سُسَںوادے چَ وِشْواسِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","تَدَنَنْتَرَں سَ گالِیلِییَسَمُدْرَسْیَ تِیرے گَچّھَنْ شِمونْ تَسْیَ بھْراتا اَنْدْرِیَناما چَ اِمَو دْوَو جَنَو مَتْسْیَدھارِنَو ساگَرَمَدھْیے جالَں پْرَکْشِپَنْتَو درِشْٹْوا تاوَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","یُواں مَمَ پَشْچاداگَچّھَتَں، یُوامَہَں مَنُشْیَدھارِنَو کَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","تَتَسْتَو تَتْکْشَنَمیوَ جالانِ پَرِتْیَجْیَ تَسْیَ پَشْچاتْ جَگْمَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","تَتَح پَرَں تَتْسْتھاناتْ کِنْچِدْ دُورَں گَتْوا سَ سِوَدِیپُتْرَیاکُوبْ تَدْبھْراترِیوہَنْ چَ اِمَو نَوکایاں جالاناں جِیرْنَمُدّھارَیَنْتَو درِشْٹْوا تاواہُویَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","تَتَسْتَو نَوکایاں ویتَنَبھُگْبھِح سَہِتَں سْوَپِتَرَں وِہایَ تَتْپَشْچادِییَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","تَتَح پَرَں کَپھَرْناہُومْنامَکَں نَگَرَمُپَسْتھایَ سَ وِشْرامَدِوَسے بھَجَنَگْرَہَں پْرَوِشْیَ سَمُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","تَسْیوپَدیشالّوکا آشْچَرْیَّں مینِرے یَتَح سودھْیاپَکااِوَ نوپَدِشَنْ پْرَبھاوَوانِوَ پْروپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","اَپَرَنْچَ تَسْمِنْ بھَجَنَگرِہے اَپَوِتْرَبھُوتینَ گْرَسْتَ ایکو مانُشَ آسِیتْ۔ سَ چِیتْشَبْدَں کرِتْوا کَتھَیانْچَکی ");
INSERT INTO sanurd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","بھو ناسَرَتِییَ یِیشو تْوَمَسْمانْ تْیَجَ، تْوَیا سَہاسْماکَں کَح سَمْبَنْدھَح؟ تْوَں کِمَسْمانْ ناشَیِتُں سَماگَتَح؟ تْوَمِیشْوَرَسْیَ پَوِتْرَلوکَ اِتْیَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","تَدا یِیشُسْتَں تَرْجَیِتْوا جَگادَ تُوشْنِیں بھَوَ اِتو بَہِرْبھَوَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","تَتَح سوپَوِتْرَبھُوتَسْتَں سَمْپِیڈْیَ اَتْیُچَیشْچِیتْکرِتْیَ نِرْجَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","تینَیوَ سَرْوّے چَمَتْکرِتْیَ پَرَسْپَرَں کَتھَیانْچَکْرِرے، اَہو کِمِدَں؟ کِیدرِشویَں نَوْیَ اُپَدیشَح؟ اَنینَ پْرَبھاویناپَوِتْرَبھُوتیشْواجْناپِتیشُ تے تَداجْنانُوَرْتِّنو بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","تَدا تَسْیَ یَشو گالِیلَشْچَتُرْدِکْسْتھَسَرْوَّدیشانْ وْیاپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","اَپَرَنْچَ تے بھَجَنَگرِہادْ بَہِ رْبھُوتْوا یاکُوبْیوہَنْبھْیاں سَہَ شِمونَ آنْدْرِیَسْیَ چَ نِویشَنَں پْرَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","تَدا پِتَرَسْیَ شْوَشْرُورْجْوَرَپِیڈِتا شَیّایاماسْتَ اِتِ تے تَں جھَٹِتِ وِجْناپَیانْچَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","تَتَح سَ آگَتْیَ تَسْیا ہَسْتَں دھرِتْوا تامُدَسْتھاپَیَتْ؛ تَدَیوَ تاں جْوَروتْیاکْشِیتْ تَتَح پَرَں سا تانْ سِشیوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","اَتھاسْتَں گَتے رَوَو سَنْدھْیاکالے سَتِ لوکاسْتَتْسَمِیپَں سَرْوّانْ روگِنو بھُوتَدھرِتاںشْچَ سَمانِنْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","سَرْوّے ناگَرِکا لوکا دْوارِ سَںمِلِتاشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","تَتَح سَ ناناوِدھَروگِنو بَہُونْ مَنُجانَروگِنَشْچَکارَ تَتھا بَہُونْ بھُوتانْ تْیاجَیانْچَکارَ تانْ بھُوتانْ کِمَپِ واکْیَں وَکْتُں نِشِشیدھَ چَ یَتوہیتوسْتے تَمَجانَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","اَپَرَنْچَ سوتِپْرَتْیُوشے وَسْتُتَسْتُ راتْرِشیشے سَمُتّھایَ بَہِرْبھُویَ نِرْجَنَں سْتھانَں گَتْوا تَتْرَ پْرارْتھَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","اَنَنْتَرَں شِمونْ تَتْسَنْگِنَشْچَ تَسْیَ پَشْچادْ گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","تَدُدّیشَں پْراپْیَ تَمَوَدَنْ سَرْوّے لوکاسْتْواں مرِگَیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","تَدا سوکَتھَیَتْ آگَچّھَتَ وَیَں سَمِیپَسْتھانِ نَگَرانِ یامَح، یَتوہَں تَتْرَ کَتھاں پْرَچارَیِتُں بَہِراگَمَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","اَتھَ سَ تیشاں گالِیلْپْرَدیشَسْیَ سَرْوّیشُ بھَجَنَگرِہیشُ کَتھاح پْرَچارَیانْچَکْرے بھُوتانَتْیاجَیَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","اَنَنْتَرَمیکَح کُشْٹھِی سَماگَتْیَ تَتْسَمُّکھے جانُپاتَں وِنَیَنْچَ کرِتْوا کَتھِتَوانْ یَدِ بھَوانْ اِچّھَتِ تَرْہِ ماں پَرِشْکَرْتُّں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","تَتَح کرِپالُ رْیِیشُح کَرَو پْرَسارْیَّ تَں سْپَشْٹْوا کَتھَیاماسَ ");
INSERT INTO sanurd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","مَمیچّھا وِدْیَتے تْوَں پَرِشْکرِتو بھَوَ۔ ایتَتْکَتھایاح کَتھَنَماتْراتْ سَ کُشْٹھِی روگانْمُکْتَح پَرِشْکرِتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","تَدا سَ تَں وِسرِجَنْ گاڈھَمادِشْیَ جَگادَ ");
INSERT INTO sanurd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ساوَدھانو بھَوَ کَتھامِماں کَمَپِ ما وَدَ؛ سْواتْمانَں یاجَکَں دَرْشَیَ، لوکیبھْیَح سْوَپَرِشْکرِتیح پْرَمانَدانایَ مُوسانِرْنِیتَں یَدّانَں تَدُتْسرِجَسْوَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","کِنْتُ سَ گَتْوا تَتْ کَرْمَّ اِتّھَں وِسْتارْیَّ پْرَچارَیِتُں پْراریبھے تینَیوَ یِیشُح پُنَح سَپْرَکاشَں نَگَرَں پْرَویشْٹُں ناشَکْنوتْ تَتوہیتورْبَہِح کانَنَسْتھانے تَسْیَو؛ تَتھاپِ چَتُرْدِّگْبھْیو لوکاسْتَسْیَ سَمِیپَمایَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","تَدَنَنْتَرَں یِیشَے کَتِپَیَدِنانِ وِلَمْبْیَ پُنَح کَپھَرْناہُومْنَگَرَں پْرَوِشْٹے سَ گرِہَ آسْتَ اِتِ کِںوَدَنْتْیا تَتْکْشَنَں تَتْسَمِیپَں بَہَوو لوکا آگَتْیَ سَمُپَتَسْتھُح، ");
INSERT INTO sanurd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","تَسْمادْ گرِہَمَدھْیے سَرْوّیشاں کرِتے سْتھانَں نابھَوَدْ دْوارَسْیَ چَتُرْدِکْشْوَپِ نابھَوَتْ، تَتْکالے سَ تانْ پْرَتِ کَتھاں پْرَچارَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","تَتَح پَرَں لوکاشْچَتُرْبھِ رْمانَوَیریکَں پَکْشاگھاتِنَں واہَیِتْوا تَتْسَمِیپَمْ آنِنْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","کِنْتُ جَناناں بَہُتْواتْ تَں یِیشوح سَمُّکھَمانیتُں نَ شَکْنُوَنْتو یَسْمِنْ سْتھانے سَ آسْتے تَدُپَرِگرِہَپرِشْٹھَں کھَنِتْوا چھِدْرَں کرِتْوا تینَ مارْگینَ سَشَیَّں پَکْشاگھاتِنَمْ اَوَروہَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","تَتو یِیشُسْتیشاں وِشْواسَں درِشْٹْوا تَں پَکْشاگھاتِنَں بَبھاشے ہے وَتْسَ تَوَ پاپاناں مارْجَنَں بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","تَدا کِیَنْتودھْیاپَکاسْتَتْروپَوِشَنْتو مَنوبھِ رْوِتَرْکَیانْچَکْرُح، ایشَ مَنُشْیَ ایتادرِشِیمِیشْوَرَنِنْداں کَتھاں کُتَح کَتھَیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","اِیشْوَرَں وِنا پاپانِ مارْشْٹُں کَسْیَ سامَرْتھْیَمْ آسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","اِتّھَں تے وِتَرْکَیَنْتِ یِیشُسْتَتْکْشَنَں مَنَسا تَدْ بُدْوّا تانَوَدَدْ یُویَمَنْتَحکَرَنَیح کُتَ ایتانِ وِتَرْکَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","تَدَنَنْتَرَں یِیشُسْتَتْسْتھاناتْ پُنَح سَمُدْرَتَٹَں یَیَو؛ لوکَنِوَہے تَتْسَمِیپَماگَتے سَ تانْ سَمُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","کِنْتُ پرِتھِوْیاں پاپانِ مارْشْٹُں مَنُشْیَپُتْرَسْیَ سامَرْتھْیَمَسْتِ، ایتَدْ یُشْمانْ جْناپَیِتُں (سَ تَسْمَے پَکْشاگھاتِنے کَتھَیاماسَ) ");
INSERT INTO sanurd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","اُتِّشْٹھَ تَوَ شَیّاں گرِہِیتْوا سْوَگرِہَں یاہِ، اَہَں تْوامِدَمْ آجْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","تَتَح سَ تَتْکْشَنَمْ اُتّھایَ شَیّاں گرِہِیتْوا سَرْوّیشاں ساکْشاتْ جَگامَ؛ سَرْوّے وِسْمِتا ایتادرِشَں کَرْمَّ وَیَمْ کَداپِ ناپَشْیامَ، اِماں کَتھاں کَتھَیِتْویشْوَرَں دھَنْیَمَبْرُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","تَدَنَنْتَرَں یِیشُسْتَتْسْتھاناتْ پُنَح سَمُدْرَتَٹَں یَیَو؛ لوکَنِوَہے تَتْسَمِیپَماگَتے سَ تانْ سَمُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","اَتھَ گَچّھَنْ کَرَسَنْچَیَگرِہَ اُپَوِشْٹَمْ آلْپھِییَپُتْرَں لیوِں درِشْٹْوا تَماہُویَ کَتھِتَوانْ مَتْپَشْچاتْ تْوامامَچّھَ تَتَح سَ اُتّھایَ تَتْپَشْچادْ یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","اَنَنْتَرَں یِیشَو تَسْیَ گرِہے بھوکْتُمْ اُپَوِشْٹے بَہَوَح کَرَمَنْچایِنَح پاپِنَشْچَ تینَ تَچّھِشْیَیشْچَ سَہوپَوِوِشُح، یَتو بَہَوَسْتَتْپَشْچاداجَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","تَدا سَ کَرَمَنْچایِبھِح پاپِبھِشْچَ سَہَ کھادَتِ، تَدْ درِشْٹْوادھْیاپَکاح پھِرُوشِنَشْچَ تَسْیَ شِشْیانُوچُح کَرَمَنْچایِبھِح پاپِبھِشْچَ سَہایَں کُتو بھُںکْتے پِوَتِ چَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","تَدْواکْیَں شْرُتْوا یِیشُح پْرَتْیُواچَ،اَروگِلوکاناں چِکِتْسَکینَ پْرَیوجَنَں ناسْتِ، کِنْتُ روگِنامیوَ؛ اَہَں دھارْمِّکاناہْواتُں ناگَتَح کِنْتُ مَنو وْیاوَرْتَّیِتُں پاپِنَ ایوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","تَتَح پَرَں یوہَنَح پھِرُوشِنانْچوپَواساچارِشِشْیا یِیشوح سَمِیپَمْ آگَتْیَ کَتھَیاماسُح، یوہَنَح پھِرُوشِنانْچَ شِشْیا اُپَوَسَنْتِ کِنْتُ بھَوَتَح شِشْیا نوپَوَسَنْتِ کِں کارَنَمَسْیَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","تَدا یِیشُسْتانْ بَبھاشے یاوَتْ کالَں سَکھِبھِح سَہَ کَنْیایا وَرَسْتِشْٹھَتِ تاوَتْکالَں تے کِمُپَوَسْتُں شَکْنُوَنْتِ؟ یاوَتْکالَں وَرَسْتَیح سَہَ تِشْٹھَتِ تاوَتْکالَں تَ اُپَوَسْتُں نَ شَکْنُوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","یَسْمِنْ کالے تیبھْیَح سَکاشادْ وَرو نیشْیَتے سَ کالَ آگَچّھَتِ، تَسْمِنْ کالے تے جَنا اُپَوَتْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","کوپِ جَنَح پُراتَنَوَسْتْرے نُوتَنَوَسْتْرَں نَ سِیوْیَتِ، یَتو نُوتَنَوَسْتْرینَ سَہَ سیوَنے کرِتے جِیرْنَں وَسْتْرَں چھِدْیَتے تَسْماتْ پُنَ رْمَہَتْ چھِدْرَں جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","کوپِ جَنَح پُراتَنَکُتُوشُ نُوتَنَں دْراکْشارَسَں نَ سْتھاپَیَتِ، یَتو نُوتَنَدْراکْشارَسَسْیَ تیجَسا تاح کُتْوو وِدِیرْیَّنْتے تَتو دْراکْشارَسَشْچَ پَتَتِ کُتْوَشْچَ نَشْیَنْتِ، اَتَایوَ نُوتَنَدْراکْشارَسو نُوتَنَکُتُوشُ سْتھاپَنِییَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","تَدَنَنْتَرَں یِیشُ رْیَدا وِشْرامَوارے شَسْیَکْشیتْرینَ گَچّھَتِ تَدا تَسْیَ شِشْیا گَچّھَنْتَح شَسْیَمَنْجَرِیشْچھیتُّں پْرَورِتّاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","اَتَح پھِرُوشِنو یِیشَوے کَتھَیاماسُح پَشْیَتُ وِشْرامَواسَرے یَتْ کَرْمَّ نَ کَرْتَّوْیَں تَدْ اِمے کُتَح کُرْوَّنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","تَدا سَ تیبھْیوکَتھَیَتْ دایُودْ تَتْسَںنْگِنَشْچَ بھَکْشْیابھاواتْ کْشُدھِتاح سَنْتو یَتْ کَرْمَّ کرِتَوَنْتَسْتَتْ کِں یُشْمابھِ رْنَ پَٹھِتَمْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","اَبِیاتھَرْنامَکے مَہایاجَکَتاں کُرْوَّتِ سَ کَتھَمِیشْوَرَسْیاواسَں پْرَوِشْیَ یے دَرْشَنِییَپُوپا یاجَکانْ وِنانْیَسْیَ کَسْیاپِ نَ بھَکْشْیاسْتانیوَ بُبھُجے سَنْگِلوکیبھْیوپِ دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","سوپَرَمَپِ جَگادَ، وِشْرامَوارو مَنُشْیارْتھَمیوَ نِرُوپِتوسْتِ کِنْتُ مَنُشْیو وِشْرامَوارارْتھَں نَیوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","مَنُشْیَپُتْرو وِشْرامَوارَسْیاپِ پْرَبھُراسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","اَنَنْتَرَں یِیشُح پُنَ رْبھَجَنَگرِہَں پْرَوِشْٹَسْتَسْمِنْ سْتھانے شُشْکَہَسْتَ ایکو مانَوَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","سَ وِشْرامَوارے تَمَروگِنَں کَرِشْیَتِ نَویتْیَتْرَ بَہَوَسْتَمْ اَپَوَدِتُں چھِدْرَمَپیکْشِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","تَدا سَ تَں شُشْکَہَسْتَں مَنُشْیَں جَگادَ مَدھْیَسْتھانے تْوَمُتِّشْٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","تَتَح پَرَں سَ تانْ پَپْرَچّھَ وِشْرامَوارے ہِتَمَہِتَں تَتھا ہِ پْرانَرَکْشا وا پْرانَناشَ ایشاں مَدھْیے کِں کَرَنِییَں ؟ کِنْتُ تے نِحشَبْداسْتَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","تَدا سَ تیشامَنْتَحکَرَناناں کاٹھِنْیادّھیتو رْدُحکھِتَح کْرودھاتْ چَرْتُिدَشو درِشْٹَوانْ تَں مانُشَں گَدِتَوانْ تَں ہَسْتَں وِسْتارَیَ، تَتَسْتینَ ہَسْتے وِسْترِتے تَدّھَسْتونْیَہَسْتَوَدْ اَروگو جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","اَتھَ پھِرُوشِنَح پْرَسْتھایَ تَں ناشَیِتُں ہیرودِییَیح سَہَ مَنْتْرَیِتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","اَتَایوَ یِیشُسْتَتْسْتھانَں پَرِتْیَجْیَ شِشْیَیح سَہَ پُنَح ساگَرَسَمِیپَں گَتَح؛ ");
INSERT INTO sanurd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","تَتو گالِیلْیِہُودا-یِرُوشالَمْ-اِدومْ-یَرْدَنَّدِیپارَسْتھانیبھْیو لوکَسَمُوہَسْتَسْیَ پَشْچادْ گَتَح؛ تَدَنْیَح سورَسِیدَنوح سَمِیپَواسِلوکَسَمُوہَشْچَ تَسْیَ مَہاکَرْمَّناں وارْتَّں شْرُتْوا تَسْیَ سَنِّدھِماگَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","تَدا لوکَسَمُوہَشْچیتْ تَسْیوپَرِ پَتَتِ اِتْیاشَنْکْیَ سَ ناوَمیکاں نِکَٹے سْتھاپَیِتُں شِشْیانادِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","یَتونیکَمَنُشْیاناماروگْیَکَرَنادْ وْیادھِگْرَسْتاح سَرْوّے تَں سْپْرَشْٹُں پَرَسْپَرَں بَلینَ یَتْنَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","اَپَرَنْچَ اَپَوِتْرَبھُوتاسْتَں درِشْٹْوا تَچَّرَنَیوح پَتِتْوا پْروچَیح پْروچُح، تْوَمِیشْوَرَسْیَ پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","کِنْتُ سَ تانْ درِڈھَمْ آجْناپْیَ سْوَں پَرِچایِتُں نِشِدّھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","اَنَنْتَرَں سَ پَرْوَّتَمارُہْیَ یَں یَں پْرَتِچّھا تَں تَماہُوتَوانْ تَتَسْتے تَتْسَمِیپَماگَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","تَدا سَ دْوادَشَجَنانْ سْوینَ سَہَ سْتھاتُں سُسَںوادَپْرَچارایَ پْریرِتا بھَوِتُں ");
INSERT INTO sanurd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","سَرْوَّپْرَکارَوْیادھِیناں شَمَنَکَرَنایَ پْرَبھاوَں پْراپْتُں بھُوتانْ تْیاجَیِتُنْچَ نِیُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","تیشاں نامانِیمانِ، شِمونْ سِوَدِپُتْرو ");
INSERT INTO sanurd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","یاکُوبْ تَسْیَ بھْراتا یوہَنْ چَ آنْدْرِیَح پھِلِپو بَرْتھَلَمَیَح، ");
INSERT INTO sanurd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","مَتھِی تھوما چَ آلْپھِییَپُتْرو یاکُوبْ تھَدِّییَح کِنانِییَح شِمونْ یَسْتَں پَرَہَسْتیشْوَرْپَیِشْیَتِ سَ اِیشْکَرِیوتِییَیِہُوداشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","سَ شِمونے پِتَرَ اِتْیُپَنامَ دَدَو یاکُوبْیوہَنْبھْیاں چَ بِنیرِگِشْ اَرْتھَتو میگھَنادَپُتْراوِتْیُپَنامَ دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","اَنَنْتَرَں تے نِویشَنَں گَتاح، کِنْتُ تَتْراپِ پُنَرْمَہانْ جَنَسَماگَمو بھَوَتْ تَسْماتّے بھوکْتُمَپْیَوَکاشَں نَ پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","تَتَسْتَسْیَ سُہرِلّوکا اِماں وارْتّاں پْراپْیَ سَ ہَتَجْنانوبھُودْ اِتِ کَتھاں کَتھَیِتْوا تَں دھرِتْوانیتُں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","اَپَرَنْچَ یِرُوشالَمَ آگَتا یے یےدھْیاپَکاسْتے جَگَدُرَیَں پُرُشو بھُوتَپَتْیابِشْٹَسْتینَ بھُوتَپَتِنا بھُوتانْ تْیاجَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","تَتَسْتاناہُویَ یِیشُ رْدرِشْٹانْتَیح کَتھاں کَتھِتَوانْ شَیتانْ کَتھَں شَیتانَں تْیاجَیِتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","کِنْچَنَ راجْیَں یَدِ سْوَوِرودھینَ پرِتھَگْ بھَوَتِ تَرْہِ تَدْ راجْیَں سْتھِرَں سْتھاتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","تَتھا کَسْیاپِ پَرِوارو یَدِ پَرَسْپَرَں وِرودھِی بھَوَتِ تَرْہِ سوپِ پَرِوارَح سْتھِرَں سْتھاتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","تَدْوَتْ شَیتانْ یَدِ سْوَوِپَکْشَتَیا اُتِّشْٹھَنْ بھِنّو بھَوَتِ تَرْہِ سوپِ سْتھِرَں سْتھاتُں نَ شَکْنوتِ کِنْتُوچّھِنّو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","اَپَرَنْچَ پْرَبَلَں جَنَں پْرَتھَمَں نَ بَدّھا کوپِ تَسْیَ گرِہَں پْرَوِشْیَ دْرَوْیانِ لُنْٹھَیِتُں نَ شَکْنوتِ، تَں بَدْوَّیوَ تَسْیَ گرِہَسْیَ دْرَوْیانِ لُنْٹھَیِتُں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","اَتوہیتو رْیُشْمَبھْیَمَہَں سَتْیَں کَتھَیامِ مَنُشْیاناں سَنْتانا یانِ یانِ پاپانِیشْوَرَنِنْدانْچَ کُرْوَّنْتِ تیشاں تَتْسَرْوّیشامَپَرادھاناں کْشَما بھَوِتُں شَکْنوتِ، ");
INSERT INTO sanurd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","کِنْتُ یَح کَشْچِتْ پَوِتْرَماتْمانَں نِنْدَتِ تَسْیاپَرادھَسْیَ کْشَما کَداپِ نَ بھَوِشْیَتِ سونَنْتَدَنْڈَسْیارْہو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","تَسْیاپَوِتْرَبھُوتوسْتِ تیشامیتَتْکَتھاہیتوح سَ اِتّھَں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","اَتھَ تَسْیَ ماتا بھْراترِگَنَشْچاگَتْیَ بَہِسْتِشْٹھَنَتو لوکانْ پْریشْیَ تَماہُوتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","تَتَسْتَتْسَنِّدھَو سَمُپَوِشْٹا لوکاسْتَں بَبھاشِرے پَشْیَ بَہِسْتَوَ ماتا بھْراتَرَشْچَ تْوامْ اَنْوِچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","تَدا سَ تانْ پْرَتْیُواچَ مَمَ ماتا کا بھْراتَرو وا کے؟ تَتَح پَرَں سَ سْوَمِیپوپَوِشْٹانْ شِشْیانْ پْرَتِ اَوَلوکَنَں کرِتْوا کَتھَیاماسَ ");
INSERT INTO sanurd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","پَشْیَتَیتے مَمَ ماتا بھْراتَرَشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","یَح کَشْچِدْ اِیشْوَرَسْییشْٹاں کْرِیاں کَروتِ سَ ایوَ مَمَ بھْراتا بھَگِنِی ماتا چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","اَنَنْتَرَں سَ سَمُدْرَتَٹے پُنَرُپَدیشْٹُں پْراریبھے، تَتَسْتَتْرَ بَہُجَناناں سَماگَماتْ سَ ساگَروپَرِ نَوکامارُہْیَ سَمُپَوِشْٹَح؛ سَرْوّے لوکاح سَمُدْرَکُولے تَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","تَدا سَ درِشْٹانْتَکَتھابھِ رْبَہُوپَدِشْٹَوانْ اُپَدِشَںشْچَ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","اَوَدھانَں کُرُتَ، ایکو بِیجَوَپْتا بِیجانِ وَپْتُں گَتَح؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","وَپَنَکالے کِیَنْتِ بِیجانِ مارْگَپاشْوے پَتِتانِ، تَتَ آکاشِییَپَکْشِنَ ایتْیَ تانِ چَکھادُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","کِیَنْتِ بِیجانِ سْوَلْپَمرِتِّکاوَتْپاشانَبھُومَو پَتِتانِ تانِ مرِدولْپَتْواتْ شِیگھْرَمَنْکُرِتانِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","کِنْتُودِتے سُورْیّے دَگْدھانِ تَتھا مُولانو نادھوگَتَتْواتْ شُشْکانِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","کِیَنْتِ بِیجانِ کَنْٹَکِوَنَمَدھْیے پَتِتانِ تَتَح کَنْٹَکانِ سَںورِدْوْیَ تانِ جَگْرَسُسْتانِ نَ چَ پھَلِتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","تَتھا کِیَنْتِ بِیجانْیُتَّمَبھُومَو پَتِتانِ تانِ سَںورِدْوْیَ پھَلانْیُتْپادِتانِ کِیَنْتِ بِیجانِ تْرِںشَدْگُنانِ کِیَنْتِ شَشْٹِگُنانِ کِیَنْتِ شَتَگُنانِ پھَلانِ پھَلِتَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","اَتھَ سَ تانَوَدَتْ یَسْیَ شْروتُں کَرْنَو سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","تَدَنَنْتَرَں نِرْجَنَسَمَیے تَتْسَنْگِنو دْوادَشَشِشْیاشْچَ تَں تَدّرِشْٹانْتَواکْیَسْیارْتھَں پَپْرَچّھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","تَدا سَ تانُدِتَوانْ اِیشْوَرَراجْیَسْیَ نِگُوڈھَواکْیَں بودّھُں یُشْماکَمَدھِکاروسْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","کِنْتُ یے وَہِرْبھُوتاح \"تے پَشْیَنْتَح پَشْیَنْتِ کِنْتُ نَ جانَنْتِ، شرِنْوَنْتَح شرِنْوَنْتِ کِنْتُ نَ بُدھْیَنْتے، چیتَّے رْمَنَحسُ کَداپِ پَرِوَرْتِّتیشُ تیشاں پاپانْیَموچَیِشْیَنْتَ،\" اَتوہیتوسْتانْ پْرَتِ درِشْٹانْتَیریوَ تانِ مَیا کَتھِتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","اَتھَ سَ کَتھِتَوانْ یُویَں کِمیتَدْ درِشْٹانْتَواکْیَں نَ بُدھْیَدھْوے؟ تَرْہِ کَتھَں سَرْوّانْ درِشْٹانْتانَ بھوتْسْیَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","بِیجَوَپْتا واکْیَرُوپانِ بِیجانِ وَپَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","تَتْرَ یے یے لوکا واکْیَں شرِنْوَنْتِ، کِنْتُ شْرُتَماتْراتْ شَیتانْ شِیگھْرَماگَتْیَ تیشاں مَنَحسُوپْتانِ تانِ واکْیَرُوپانِ بِیجانْیَپَنَیَتِ تَایوَ اُپْتَبِیجَمارْگَپارْشْویسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","یے جَنا واکْیَں شْرُتْوا سَہَسا پَرَمانَنْدینَ گرِہْلَنْتِ، کِنْتُ ہرِدِ سْتھَیرْیّابھاواتْ کِنْچِتْ کالَماتْرَں تِشْٹھَنْتِ تَتْپَشْچاتْ تَدْواکْیَہیتوح ");
INSERT INTO sanurd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","کُتْرَچِتْ کْلیشے اُپَدْرَوے وا سَمُپَسْتھِتے تَدَیوَ وِگھْنَں پْراپْنُوَنْتِ تَایوَ اُپْتَبِیجَپاشانَبھُومِسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","یے جَناح کَتھاں شرِنْوَنْتِ کِنْتُ ساںسارِکِی چِنْتا دھَنَبھْرانْتِ رْوِشَیَلوبھَشْچَ ایتے سَرْوّے اُپَسْتھایَ تاں کَتھاں گْرَسَنْتِ تَتَح ما وِپھَلا بھَوَتِ ");
INSERT INTO sanurd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","تَایوَ اُپْتَبِیجَسَکَنْٹَکَبھُومِسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","یے جَنا واکْیَں شْرُتْوا گرِہْلَنْتِ تیشاں کَسْیَ وا تْرِںشَدْگُنانِ کَسْیَ وا شَشْٹِگُنانِ کَسْیَ وا شَتَگُنانِ پھَلانِ بھَوَنْتِ تَایوَ اُپْتَبِیجورْوَّرَبھُومِسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","تَدا سوپَرَمَپِ کَتھِتَوانْ کوپِ جَنو دِیپادھارَں پَرِتْیَجْیَ دْرونَسْیادھَح کھَٹْوایا اَدھے وا سْتھاپَیِتُں دِیپَمانَیَتِ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","اَتوہیتو رْیَنَّ پْرَکاشَیِشْیَتے تادرِگْ لُکّایِتَں کِمَپِ وَسْتُ ناسْتِ؛ یَدْ وْیَکْتَں نَ بھَوِشْیَتِ تادرِشَں گُپْتَں کِمَپِ وَسْتُ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","یَسْیَ شْروتُں کَرْنَو سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","اَپَرَمَپِ کَتھِتَوانْ یُویَں یَدْ یَدْ واکْیَں شرِنُتھَ تَتْرَ ساوَدھانا بھَوَتَ، یَتو یُویَں یینَ پَرِمانینَ پَرِماتھَ تینَیوَ پَرِمانینَ یُشْمَدَرْتھَمَپِ پَرِماسْیَتے؛ شْروتارو یُویَں یُشْمَبھْیَمَدھِکَں داسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","یَسْیاشْرَیے وَرْدّھَتے تَسْمَے اَپَرَمَپِ داسْیَتے، کِنْتُ یَسْیاشْرَیے نَ وَرْدّھَتے تَسْیَ یَتْ کِنْچِدَسْتِ تَدَپِ تَسْمانْ نیشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","اَنَنْتَرَں سَ کَتھِتَوانْ ایکو لوکَح کْشیتْرے بِیجانْیُپْتْوا ");
INSERT INTO sanurd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","جاگَرَنَنِدْرابھْیاں دِوانِشَں گَمَیَتِ، پَرَنْتُ تَدْوِیجَں تَسْیاجْناتَرُوپینانْکُرَیَتِ وَرْدّھَتے چَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","یَتوہیتوح پْرَتھَمَتَح پَتْرانِ تَتَح پَرَں کَنِشانِ تَتْپَشْچاتْ کَنِشَپُورْنانِ شَسْیانِ بھُومِح سْوَیَمُتْپادَیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","کِنْتُ پھَلیشُ پَکّیشُ شَسْیَچّھیدَنَکالَں جْناتْوا سَ تَتْکْشَنَں شَسْیانِ چھِنَتِّ، اَنینَ تُلْیَمِیشْوَرَراجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","پُنَح سوکَتھَیَدْ اِیشْوَرَراجْیَں کینَ سَمَں؟ کینَ وَسْتُنا سَہَ وا تَدُپَماسْیامِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","تَتْ سَرْشَپَیکینَ تُلْیَں یَتو مرِدِ وَپَنَکالے سَرْشَپَبِیجَں سَرْوَّپرِتھِوِیسْتھَبِیجاتْ کْشُدْرَں ");
INSERT INTO sanurd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","کِنْتُ وَپَناتْ پَرَمْ اَنْکُرَیِتْوا سَرْوَّشاکادْ برِہَدْ بھَوَتِ، تَسْیَ برِہَتْیَح شاکھاشْچَ جایَنْتے تَتَسْتَچّھایاں پَکْشِنَ آشْرَیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","اِتّھَں تیشاں بودھانُرُوپَں سونیکَدرِشْٹانْتَیسْتانُپَدِشْٹَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","درِشْٹانْتَں وِنا کامَپِ کَتھاں تیبھْیو نَ کَتھِتَوانْ پَشْچانْ نِرْجَنے سَ شِشْیانْ سَرْوَّدرِشْٹانْتارْتھَں بودھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","تَدِّنَسْیَ سَنْدھْیایاں سَ تیبھْیوکَتھَیَدْ آگَچّھَتَ وَیَں پارَں یامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","تَدا تے لوکانْ وِسرِجْیَ تَمَوِلَمْبَں گرِہِیتْوا نَوکَیا پْرَتَسْتھِرے؛ اَپَرا اَپِ ناوَسْتَیا سَہَ سْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","تَتَح پَرَں مَہاجھَنْبھْشَگَماتْ نَو رْدولایَمانا تَرَنْگینَ جَلَیح پُورْنابھَوَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","تَدا سَ نَوکاچَشْچادْبھاگے اُپَدھانے شِرو نِدھایَ نِدْرِتَ آسِیتْ تَتَسْتے تَں جاگَرَیِتْوا جَگَدُح، ہے پْرَبھو، اَسْماکَں پْرانا یانْتِ کِمَتْرَ بھَوَتَشْچِنْتا ناسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","تَدا سَ اُتّھایَ وایُں تَرْجِتَوانْ سَمُدْرَنْچوکْتَوانْ شانْتَح سُسْتھِرَشْچَ بھَوَ؛ تَتو وایَو نِورِتّےبْدھِرْنِسْتَرَنْگوبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","تَدا سَ تانُواچَ یُویَں کُتَ ایتادرِکْشَنْکاکُلا بھَوَتَ؟ کِں وو وِشْواسو ناسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","تَسْماتّےتِیوَبھِیتاح پَرَسْپَرَں وَکْتُماریبھِرے، اَہو وایُح سِنْدھُشْچاسْیَ نِدیشَگْراہِنَو کِیدرِگَیَں مَنُجَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","اَتھَ تُو سِنْدھُپارَں گَتْوا گِدیرِییَپْرَدیشَ اُپَتَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","نَوکاتو نِرْگَتَماتْرادْ اَپَوِتْرَبھُوتَگْرَسْتَ ایکَح شْمَشانادیتْیَ تَں ساکْشاچْ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","سَ شْمَشانےواتْسِیتْ کوپِ تَں شرِنْکھَلینَ بَدْوّا سْتھاپَیِتُں ناشَکْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","جَنَیرْوارَں نِگَڈَیح شرِنْکھَلَیشْچَ سَ بَدّھوپِ شرِنْکھَلانْیاکرِشْیَ موچِتَوانْ نِگَڈانِ چَ بھَںکْتْوا کھَنْڈَں کھَنْڈَں کرِتَوانْ کوپِ تَں وَشِیکَرْتُّں نَ شَشَکَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","دِوانِشَں سَدا پَرْوَّتَں شْمَشانَنْچَ بھْرَمِتْوا چِیتْشَبْدَں کرِتَوانْ گْراوَبھِشْچَ سْوَیَں سْوَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","سَ یِیشُں دُوراتْ پَشْیَنّیوَ دھاوَنْ تَں پْرَنَنامَ اُچَیرُوَںشْچوواچَ، ");
INSERT INTO sanurd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ہے سَرْوّوپَرِسْتھیشْوَرَپُتْرَ یِیشو بھَوَتا سَہَ مے کَح سَمْبَنْدھَح؟ اَہَں تْوامِیشْوَرینَ شاپَیے ماں ما یاتَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","یَتو یِیشُسْتَں کَتھِتَوانْ رے اَپَوِتْرَبھُوتَ، اَسْمانَّرادْ بَہِرْنِرْگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","اَتھَ سَ تَں پرِشْٹَوانْ کِنْتے نامَ؟ تینَ پْرَتْیُکْتَں وَیَمَنیکے سْمَسْتَتوسْمَنّامَ باہِنِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","تَتوسْمانْ دیشانَّ پْریشَییتِ تے تَں پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","تَدانِیں پَرْوَّتَں نِکَشا برِہَنْ وَراہَوْرَجَشْچَرَنّاسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","تَسْمادْ بھُوتا وِنَیینَ جَگَدُح، اَمُں وَراہَوْرَجَمْ آشْرَیِتُمْ اَسْمانْ پْرَہِنُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","یِیشُنانُجْناتاسْتےپَوِتْرَبھُوتا بَہِرْنِرْیایَ وَراہَوْرَجَں پْراوِشَنْ تَتَح سَرْوّے وَراہا وَسْتُتَسْتُ پْرایودْوِسَہَسْرَسَںنْکھْیَکاح کَٹَکینَ مَہاجَوادْ دھاوَنْتَح سِنْدھَو پْرانانْ جَہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","تَسْمادْ وَراہَپالَکاح پَلایَماناح پُرے گْرامے چَ تَدْوارْتَّں کَتھَیانْچَکْرُح۔ تَدا لوکا گھَٹِتَں تَتْکارْیَّں دْرَشْٹُں بَہِرْجَگْمُح ");
INSERT INTO sanurd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","یِیشوح سَنِّدھِں گَتْوا تَں بھُوتَگْرَسْتَمْ اَرْتھادْ باہِنِیبھُوتَگْرَسْتَں نَرَں سَوَسْتْرَں سَچیتَنَں سَمُپَوِشْٹَنْچَ درِृشْٹْوا بِبھْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","تَتو درِشْٹَتَتْکارْیَّلوکاسْتَسْیَ بھُوتَگْرَسْتَنَرَسْیَ وَراہَوْرَجَسْیاپِ تاں دھَٹَناں وَرْنَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","تَتَسْتے سْوَسِیماتو بَہِرْگَنْتُں یِیشُں وِنیتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","اَتھَ تَسْیَ نَوکاروہَنَکالے سَ بھُوتَمُکْتو نا یِیشُنا سَہَ سْتھاتُں پْرارْتھَیَتے؛ ");
INSERT INTO sanurd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","کِنْتُ سَ تَمَنَنُمَتْیَ کَتھِتَوانْ تْوَں نِجاتْمِییاناں سَمِیپَں گرِہَنْچَ گَچّھَ پْرَبھُسْتْوَیِ کرِپاں کرِتْوا یانِ کَرْمّانِ کرِتَوانْ تانِ تانْ جْناپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","اَتَح سَ پْرَسْتھایَ یِیشُنا کرِتَں تَتْسَرْوّاشْچَرْیَّں کَرْمَّ دِکاپَلِدیشے پْرَچارَیِتُں پْرارَبْدھَوانْ تَتَح سَرْوّے لوکا آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","اَنَنْتَرَں یِیشَو ناوا پُنَرَنْیَپارَ اُتِّیرْنے سِنْدھُتَٹے چَ تِشْٹھَتِ سَتِ تَتْسَمِیپے بَہُلوکاناں سَماگَموبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","اَپَرَں یایِیرْ نامْنا کَشْچِدْ بھَجَنَگرِہَسْیادھِپَ آگَتْیَ تَں درِشْٹْوَیوَ چَرَنَیوح پَتِتْوا بَہُ نِویدْیَ کَتھِتَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","مَمَ کَنْیا مرِتَپْرایابھُودْ اَتو بھَوانیتْیَ تَداروگْیایَ تَسْیا گاتْرے ہَسْتَمْ اَرْپَیَتُ تینَیوَ سا جِیوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","تَدا یِیشُسْتینَ سَہَ چَلِتَح کِنْتُ تَتْپَشْچادْ بَہُلوکاشْچَلِتْوا تادْگاتْرے پَتِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","اَتھَ دْوادَشَوَرْشانِ پْرَدَرَروگینَ ");
INSERT INTO sanurd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","شِیرْنا چِکِتْسَکاناں ناناچِکِتْسابھِشْچَ دُحکھَں بھُکْتَوَتِی چَ سَرْوَّسْوَں وْیَیِتْواپِ ناروگْیَں پْراپْتا چَ پُنَرَپِ پِیڈِتاسِیچَّ ");
INSERT INTO sanurd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","یا سْتْرِی سا یِیشو رْوارْتّاں پْراپْیَ مَنَساکَتھَیَتْ یَدْیَہَں تَسْیَ وَسْتْرَماتْرَ سْپْرَشْٹُں لَبھییَں تَدا روگَہِینا بھَوِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","اَتوہیتوح سا لوکارَنْیَمَدھْیے تَتْپَشْچاداگَتْیَ تَسْیَ وَسْتْرَں پَسْپَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","تینَیوَ تَتْکْشَنَں تَسْیا رَکْتَسْروتَح شُشْکَں سْوَیَں تَسْمادْ روگانْمُکْتا اِتْیَپِ دیہےنُبھُوتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","اَتھَ سْوَسْماتْ شَکْتِ رْنِرْگَتا یِیشُریتَنْمَنَسا جْناتْوا لوکَنِوَہَں پْرَتِ مُکھَں وْیاورِتْیَ پرِشْٹَوانْ کینَ مَدْوَسْتْرَں سْپرِشْٹَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","تَتَسْتَسْیَ شِشْیا اُوچُح بھَوَتو وَپُشِ لوکاح سَںگھَرْشَنْتِ تَدْ درِشْٹْوا کینَ مَدْوَسْتْرَں سْپرِشْٹَمِتِ کُتَح کَتھَیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","کِنْتُ کینَ تَتْ کَرْمَّ کرِتَں تَدْ دْرَشْٹُں یِیشُشْچَتُرْدِشو درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","تَتَح سا سْتْرِی بھِیتا کَمْپِتا چَ سَتِی سْوَسْیا رُکْپْرَتِکْرِیا جاتیتِ جْناتْواگَتْیَ تَتْسَمُّکھے پَتِتْوا سَرْوَّورِتّانْتَں سَتْیَں تَسْمَے کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","تَدانِیں یِیشُسْتاں گَدِتَوانْ، ہے کَنْیے تَوَ پْرَتِیتِسْتْوامْ اَروگامَکَروتْ تْوَں کْشیمینَ وْرَجَ سْوَروگانْمُکْتا چَ تِشْٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","اِتِواکْیَوَدَنَکالے بھَجَنَگرِہادھِپَسْیَ نِویشَنالْ لوکا ایتْیادھِپَں بَبھاشِرے تَوَ کَنْیا مرِتا تَسْمادْ گُرُں پُنَح کُتَح کْلِشْناسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","کِنْتُ یِیشُسْتَدْ واکْیَں شْرُتْوَیوَ بھَجَنَگرِہادھِپَں گَدِتَوانْ ما بھَیشِیح کیوَلَں وِشْواسِہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","اَتھَ پِتَرو یاکُوبْ تَدْبھْراتا یوہَنْ چَ ایتانْ وِنا کَمَپِ سْوَپَشْچادْ یاتُں نانْوَمَنْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","تَسْیَ بھَجَنَگرِہادھِپَسْیَ نِویشَنَسَمِیپَمْ آگَتْیَ کَلَہَں بَہُرودَنَں وِلاپَنْچَ کُرْوَّتو لوکانْ دَدَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","تَسْمانْ نِویشَنَں پْرَوِشْیَ پْروکْتَوانْ یُویَں کُتَ اِتّھَں کَلَہَں رودَنَنْچَ کُرُتھَ؟ کَنْیا نَ مرِتا نِدْراتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","تَسْماتّے تَمُپَجَہَسُح کِنْتُ یِیشُح سَرْوّانَ بَہِشْکرِتْیَ کَنْیایاح پِتَرَو سْوَسَنْگِنَشْچَ گرِہِیتْوا یَتْرَ کَنْیاسِیتْ تَتْ سْتھانَں پْرَوِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","اَتھَ سَ تَسْیاح کَنْیایا ہَسْتَو دھرِتْوا تاں بَبھاشے ٹالِیتھا کُومِی، اَرْتھَتو ہے کَنْیے تْوَمُتِّشْٹھَ اِتْیاجْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","تُنَیوَ تَتْکْشَنَں سا دْوادَشَوَرْشَوَیَسْکا کَنْیا پوتّھایَ چَلِتُماریبھے، اِتَح سَرْوّے مَہاوِسْمَیَں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","تَتَ ایتَسْیَے کِنْچِتْ کھادْیَں دَتّیتِ کَتھَیِتْوا ایتَتْکَرْمَّ کَمَپِ نَ جْناپَیَتیتِ درِڈھَمادِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","اَنَنْتَرَں سَ تَتْسْتھاناتْ پْرَسْتھایَ سْوَپْرَدیشَماگَتَح شِشْیاشْچَ تَتْپَشْچادْ گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","اَتھَ وِشْرامَوارے سَتِ سَ بھَجَنَگرِہے اُپَدیشْٹُمارَبْدھَوانْ تَتونیکے لوکاسْتَتْکَتھاں شْرُتْوا وِسْمِتْیَ جَگَدُح، اَسْیَ مَنُجَسْیَ اِیدرِشِی آشْچَرْیَّکْرِیا کَسْماجْ جاتا؟ تَتھا سْوَکَرابھْیامْ اِتّھَمَدْبھُتَں کَرْمَّ کَرْتّاुمْ ایتَسْمَے کَتھَں جْنانَں دَتَّمْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","کِمَیَں مَرِیَمَح پُتْرَسْتَجْنا نو؟ کِمَیَں یاکُوبْ-یوسِ-یِہُدا-شِموناں بھْراتا نو؟ اَسْیَ بھَگِنْیَح کِمِہاسْمابھِح سَہَ نو؟ اِتّھَں تے تَدَرْتھے پْرَتْیُوہَں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","تَدا یِیشُسْتیبھْیوکَتھَیَتْ سْوَدیشَں سْوَکُٹُمْبانْ سْوَپَرِجَناںشْچَ وِنا کُتْراپِ بھَوِشْیَدْوادِی اَسَتْکرِتو نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","اَپَرَنْچَ تیشامَپْرَتْیَیاتْ سَ وِسْمِتَح کِیَتاں روگِناں وَپُحشُ ہَسْتَمْ اَرْپَیِتْوا کیوَلَں تیشاماروگْیَکَرَنادْ اَنْیَتْ کِمَپِ چِتْرَکارْیَّں کَرْتّاں نَ شَکْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","اَتھَ سَ چَتُرْدِکْسْتھَ گْرامانْ بھْرَمِتْوا اُپَدِشْٹَوانْ ");
INSERT INTO sanurd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","دْوادَشَشِشْیانْ آہُویَ اَمیدھْیَبھُوتانْ وَشِیکَرْتّاں شَکْتِں دَتّوا تیشاں دْوَو دْوَو جَنو پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","پُنَرِتْیادِشَدْ یُویَمْ ایکَیکاں یَشْٹِں وِنا وَسْتْرَسَںپُٹَح پُوپَح کَٹِبَنْدھے تامْرَکھَنْڈَنْچَ ایشاں کِمَپِ ما گْرَہْلِیتَ، ");
INSERT INTO sanurd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","مارْگَیاتْرایَے پادیشُوپانَہَو دَتّوا دْوے اُتَّرِییے ما پَرِدھَدْوَّں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","اَپَرَمَپْیُکْتَں تینَ یُویَں یَسْیاں پُرْیّاں یَسْیَ نِویشَنَں پْرَویکْشْیَتھَ تاں پُرِیں یاوَنَّ تْیَکْشْیَتھَ تاوَتْ تَنِّویشَنے سْتھاسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","تَتْرَ یَدِ کیپِ یُشْماکَماتِتھْیَں نَ وِدَدھَتِ یُشْماکَں کَتھاشْچَ نَ شرِنْوَنْتِ تَرْہِ تَتْسْتھاناتْ پْرَسْتھانَسَمَیے تیشاں وِرُدّھَں ساکْشْیَں داتُں سْوَپاداناسْپھالْیَ رَجَح سَمْپاتَیَتَ؛ اَہَں یُشْمانْ یَتھارْتھَں وَچْمِ وِچارَدِنے تَنَّگَرَسْیاوَسْتھاتَح سِدومامورَیو رْنَگَرَیورَوَسْتھا سَہْیَتَرا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","اَتھَ تے گَتْوا لوکاناں مَنَحپَراوَرْتَّنِیح کَتھا پْرَچارِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ایوَمَنیکانْ بھُوتاںشْچَ تْیاجِتَوَنْتَسْتَتھا تَیلینَ مَرْدَّیِتْوا بَہُونْ جَنانَروگانَکارْشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","اِتّھَں تَسْیَ سُکھْیاتِشْچَتُرْدِشو وْیاپْتا تَدا ہیرودْ راجا تَنِّشَمْیَ کَتھِتَوانْ، یوہَنْ مَجَّکَح شْمَشانادْ اُتّھِتَ اَتوہیتوسْتینَ سَرْوّا ایتا اَدْبھُتَکْرِیاح پْرَکاشَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","اَنْیےکَتھَیَنْ اَیَمْ ایلِیَح، کیپِ کَتھِتَوَنْتَ ایشَ بھَوِشْیَدْوادِی یَدْوا بھَوِشْیَدْوادِناں سَدرِشَ ایکویَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","کِنْتُ ہیرودْ اِتْیاکَرْنْیَ بھاشِتَوانْ یَسْیاہَں شِرَشْچھِنَّوانْ سَ ایوَ یوہَنَیَں سَ شْمَشانادُدَتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","پُورْوَّں سْوَبھْراتُح پھِلِپَسْیَ پَتْنْیا اُدْواہَں کرِتَوَنْتَں ہیرودَں یوہَنَوادِیتْ سْوَبھاترِوَدھُو رْنَ وِواہْیا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","اَتَح کارَناتْ ہیرودْ لوکَں پْرَہِتْیَ یوہَنَں دھرِتْوا بَنْدھَنالَیے بَدّھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ہیرودِیا تَسْمَے یوہَنے پْرَکُپْیَ تَں ہَنْتُمْ اَیچّھَتْ کِنْتُ نَ شَکْتا، ");
INSERT INTO sanurd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","یَسْمادْ ہیرودْ تَں دھارْمِّکَں سَتْپُرُشَنْچَ جْناتْوا سَمَّنْیَ رَکْشِتَوانْ؛ تَتْکَتھاں شْرُتْوا تَدَنُسارینَ بَہُونِ کَرْمّانِ کرِتَوانْ ہرِشْٹَمَناسْتَدُپَدیشَں شْرُتَواںشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","کِنْتُ ہیرودْ یَدا سْوَجَنْمَدِنے پْرَدھانَلوکیبھْیَح سینانِیبھْیَشْچَ گالِیلْپْرَدیشِییَشْریشْٹھَلوکیبھْیَشْچَ راتْرَو بھوجْیَمیکَں کرِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","تَسْمِنْ شُبھَدِنے ہیرودِیایاح کَنْیا سَمیتْیَ تیشاں سَمَکْشَں سَںنرِتْیَ ہیرودَسْتینَ سَہوپَوِشْٹانانْچَ توشَمَجِیجَنَتْ تَتا نرِپَح کَنْیاماہَ سْمَ مَتّو یَدْ یاچَسے تَدیوَ تُبھْیَں داسْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","شَپَتھَں کرِتْواکَتھَیَتْ چیدْ راجْیارْدّھَمَپِ یاچَسے تَدَپِ تُبھْیَں داسْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","تَتَح سا بَہِ رْگَتْوا سْوَماتَرَں پَپْرَچّھَ کِمَہَں یاچِشْیے؟ تَدا ساکَتھَیَتْ یوہَنو مَجَّکَسْیَ شِرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","اَتھَ تُورْنَں بھُوپَسَمِیپَمْ ایتْیَ یاچَماناوَدَتْ کْشَنیسْمِنْ یوہَنو مَجَّکَسْیَ شِرَح پاتْرے نِدھایَ دیہِ، ایتَدْ یاچےہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","تَسْماتْ بھُوپوتِدُحکھِتَح، تَتھاپِ سْوَشَپَتھَسْیَ سَہَبھوجِنانْچانُرودھاتْ تَدَنَنْگِیکَرْتُّں نَ شَکْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","تَتْکْشَنَں راجا گھاتَکَں پْریشْیَ تَسْیَ شِرَ آنیتُمادِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","تَتَح سَ کاراگارَں گَتْوا تَچّھِرَشْچھِتْوا پاتْرے نِدھایانِییَ تَسْیَے کَنْیایَے دَتَّوانْ کَنْیا چَ سْوَماتْرے دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","اَنَنَتَرَں یوہَنَح شِشْیاسْتَدْوارْتّاں پْراپْیاگَتْیَ تَسْیَ کُنَپَں شْمَشانےسْتھاپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","اَتھَ پْریشِتا یِیشوح سَنِّدھَو مِلِتا یَدْ یَچْ چَکْرُح شِکْشَیاماسُشْچَ تَتْسَرْوَّوارْتّاسْتَسْمَے کَتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","سَ تانُواچَ یُویَں وِجَنَسْتھانَں گَتْوا وِشْرامْیَتَ یَتَسْتَتْسَنِّدھَو بَہُلوکاناں سَماگَماتْ تے بھوکْتُں ناوَکاشَں پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","تَتَسْتے ناوا وِجَنَسْتھانَں گُپْتَں گَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","تَتو لوکَنِوَہَسْتیشاں سْتھانانْتَرَیانَں دَدَرْشَ، اَنیکے تَں پَرِچِتْیَ ناناپُریبھْیَح پَدَیرْوْرَجِتْوا جَوینَ تَیشامَگْرے یِیشوح سَمِیپَ اُپَتَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","تَدا یِیشُ رْناوو بَہِرْگَتْیَ لوکارَنْیانِیں درِشْٹْوا تیشُ کَرُناں کرِتَوانْ یَتَسْتےرَکْشَکَمیشا اِواسَنْ تَدا سَ تانَ ناناپْرَسَنْگانْ اُپَدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","اَتھَ دِوانْتے سَتِ شِشْیا ایتْیَ یِیشُمُوچِرے، اِدَں وِجَنَسْتھانَں دِنَنْچاوَسَنَّں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","لوکاناں کِمَپِ کھادْیَں ناسْتِ، اَتَشْچَتُرْدِکْشُ گْرامانْ گَنْتُں بھوجْیَدْرَوْیانِ کْریتُنْچَ بھَوانْ تانْ وِسرِجَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","تَدا سَ تانُواچَ یُویَمیوَ تانْ بھوجَیَتَ؛ تَتَسْتے جَگَدُ رْوَیَں گَتْوا دْوِشَتَسَںکھْیَکَے رْمُدْراپادَیح پُوپانْ کْرِیتْوا کِں تانْ بھوجَیِشْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","تَدا سَ تانْ پرِشْٹھَوانْ یُشْماکَں سَنِّدھَو کَتِ پُوپا آسَتے؟ گَتْوا پَشْیَتَ؛ تَتَسْتے درِشْٹْوا تَمَوَدَنْ پَنْچَ پُوپا دْوَو مَتْسْیَو چَ سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","تَدا سَ لوکانْ شَسْپوپَرِ پَںکْتِبھِرُپَویشَیِتُمْ آدِشْٹَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","تَتَسْتے شَتَں شَتَں جَناح پَنْچاشَتْ پَنْچاشَجَّناشْچَ پَںکْتِبھِ رْبھُوِ سَمُپَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","اَتھَ سَ تانْ پَنْچَپُوپانْ مَتْسْیَدْوَیَنْچَ دھرِتْوا سْوَرْگَں پَشْیَنْ اِیشْوَرَگُنانْ اَنْوَکِیرْتَّیَتْ تانْ پُوپانْ بھَںکْتْوا لوکیبھْیَح پَرِویشَیِتُں شِشْییبھْیو دَتَّوانْ دْوا مَتْسْیَو چَ وِبھَجْیَ سَرْوّیبھْیو دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","تَتَح سَرْوّے بھُکْتْواترِپْیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","اَنَنْتَرَں شِشْیا اَوَشِشْٹَیح پُوپَے رْمَتْسْیَیشْچَ پُورْنانْ دْوَدَشَ ڈَلَّکانْ جَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","تے بھوکْتارَح پْرایَح پَنْچَ سَہَسْرانِ پُرُشا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","اَتھَ سَ لوکانْ وِسرِجَنّیوَ ناوَماروڈھُں سْوَسْمادَگْرے پارے بَیتْسَیداپُرَں یاتُنْچَ شْشْیِाنْ واڈھَمادِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","تَدا سَ سَرْوّانْ وِسرِجْیَ پْرارْتھَیِتُں پَرْوَّتَں گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","تَتَح سَنْدھْیایاں سَتْیاں نَوح سِنْدھُمَدھْیَ اُپَسْتھِتا کِنْتُ سَ ایکاکِی سْتھَلے سْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","اَتھَ سَمُّکھَواتَوَہَناتْ شِشْیا ناوَں واہَیِتْوا پَرِشْرانْتا اِتِ جْناتْوا سَ نِشاچَتُرْتھَیامے سِنْدھُوپَرِ پَدْبھْیاں وْرَجَنْ تیشاں سَمِیپَمیتْیَ تیشامَگْرے یاتُمْ اُدْیَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","کِنْتُ شِشْیاح سِنْدھُوپَرِ تَں وْرَجَنْتَں درِشْٹْوا بھُوتَمَنُمایَ رُرُوُح، ");
INSERT INTO sanurd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","یَتَح سَرْوّے تَں درِشْٹْوا وْیاکُلِتاح۔ اَتَایوَ یِیشُسْتَتْکْشَنَں تَیح سَہالَپْیَ کَتھِتَوانْ، سُسْتھِرا بھُوتَ، اَیَمَہَں ما بھَیشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","اَتھَ نَوکامارُہْیَ تَسْمِنْ تیشاں سَنِّدھِں گَتے واتو نِورِتَّح؛ تَسْماتّے مَنَحسُ وِسْمِتا آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","یَتَسْتے مَنَساں کاٹھِنْیاتْ تَتْ پُوپِییَمْ آشْچَرْیَّں کَرْمَّ نَ وِوِکْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","اَتھَ تے پارَں گَتْوا گِنیشَرَتْپْرَدیشَمیتْیَ تَٹَ اُپَسْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","تیشُ نَوکاتو بَہِرْگَتیشُ تَتْپْرَدیشِییا لوکاسْتَں پَرِچِتْیَ ");
INSERT INTO sanurd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","چَتُرْدِکْشُ دھاوَنْتو یَتْرَ یَتْرَ روگِنو نَرا آسَنْ تانْ سَرْوّانَ کھَٹْووپَرِ نِدھایَ یَتْرَ کُتْرَچِتْ تَدْوارْتّاں پْراپُح تَتْ سْتھانَمْ آنیتُمْ آریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","تَتھا یَتْرَ یَتْرَ گْرامے یَتْرَ یَتْرَ پُرے یَتْرَ یَتْرَ پَلّیانْچَ تینَ پْرَویشَح کرِتَسْتَدْوَرْتْمَمَدھْیے لوکاح پِیڈِتانْ سْتھاپَیِتْوا تَسْیَ چیلَگْرَنْتھِماتْرَں سْپْرَشْٹُمْ تیشامَرْتھے تَدَنُجْناں پْرارْتھَیَنْتَح یاوَنْتو لوکاح پَسْپرِشُسْتاوَنْتَ ایوَ گَدانْمُکْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","اَنَنْتَرَں یِرُوشالَمَ آگَتاح پھِرُوشِنودھْیاپَکاشْچَ یِیشوح سَمِیپَمْ آگَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","تے تَسْیَ کِیَتَح شِشْیانْ اَشُچِکَرَیرَرْتھادَ اَپْرَکْشالِتَہَسْتَے رْبھُنْجَتو درِشْٹْوا تانَدُوشَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","یَتَح پھِرُوشِنَح سَرْوَّیِہُودِییاشْچَ پْراچاں پَرَمْپَراگَتَواکْیَں سَمَّنْیَ پْرَتَلینَ ہَسْتانْ اَپْرَکْشالْیَ نَ بھُنْجَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","آپَناداگَتْیَ مَجَّنَں وِنا نَ کھادَنْتِ؛ تَتھا پانَپاتْراناں جَلَپاتْراناں پِتَّلَپاتْرانامْ آسَنانانْچَ جَلے مَجَّنَمْ اِتْیادَیونْییپِ بَہَوَسْتیشاماچاراح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","تے پھِرُوشِنودھْیاپَکاشْچَ یِیشُں پَپْرَچّھُح، تَوَ شِشْیاح پْراچاں پَرَمْپَراگَتَواکْیانُسارینَ ناچَرَنْتوپْرَکْشالِتَکَرَیح کُتو بھُجَںتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","تَتَح سَ پْرَتْیُواچَ کَپَٹِنو یُشْمانْ اُدِّشْیَ یِشَیِیَبھَوِشْیَدْوادِی یُکْتَمَوادِیتْ۔ یَتھا سْوَکِییَیرَدھَرَیریتے سَمَّنْیَنَتے سَدَیوَ ماں۔ کِنْتُ مَتّو وِپْرَکَرْشے سَنْتِ تیشاں مَناںسِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","شِکْشَیَنْتو بِدھِینْ نّاجْنا بھَجَنْتے ماں مُدھَیوَ تے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","یُویَں جَلَپاتْرَپانَپاتْرادِینِ مَجَّیَنْتو مَنُجَپَرَمْپَراگَتَواکْیَں رَکْشَتھَ کِنْتُ اِیشْوَراجْناں لَںگھَدھْوے؛ اَپَرا اِیدرِشْیونیکاح کْرِیا اَپِ کُرُدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","اَنْیَنْچاکَتھَیَتْ یُویَں سْوَپَرَمْپَراگَتَواکْیَسْیَ رَکْشارْتھَں سْپَشْٹَرُوپینَ اِیشْوَراجْناں لوپَیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","یَتو مُوسادْوارا پْروکْتَمَسْتِ سْوَپِتَرَو سَمَّنْیَدھْوَں یَسْتُ ماتَرَں پِتَرَں وا دُرْوّاکْیَں وَکْتِ سَ نِتانْتَں ہَنْیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","کِنْتُ مَدِییینَ یینَ دْرَوْیینَ تَووپَکاروبھَوَتْ تَتْ کَرْبّانَمَرْتھادْ اِیشْوَرایَ نِویدِتَمْ اِدَں واکْیَں یَدِ کوپِ پِتَرَں ماتَرَں وا وَکْتِ ");
INSERT INTO sanurd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","تَرْہِ یُویَں ماتُح پِتُ رْووپَکارَں کَرْتّاں تَں وارَیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","اِتّھَں سْوَپْرَچارِتَپَرَمْپَراگَتَواکْیینَ یُویَمْ اِیشْوَراجْناں مُدھا وِدھَدْوّے، اِیدرِشانْیَنْیانْیَنیکانِ کَرْمّانِ کُرُدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","اَتھَ سَ لوکاناہُویَ بَبھاشے یُویَں سَرْوّے مَدْواکْیَں شرِنُتَ بُدھْیَدھْوَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","باہْیادَنْتَرَں پْرَوِشْیَ نَرَمَمیدھْیَں کَرْتّاں شَکْنوتِ اِیدرِشَں کِمَپِ وَسْتُ ناسْتِ، وَرَمْ اَنْتَرادْ بَہِرْگَتَں یَدْوَسْتُ تَنْمَنُجَمْ اَمیدھْیَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","یَسْیَ شْروتُں شْروتْرے سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","تَتَح سَ لوکانْ ہِتْوا گرِہَمَدھْیَں پْرَوِشْٹَسْتَدا شِشْیاسْتَدرِشْٹانْتَواکْیارْتھَں پَپْرَچّھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","تَسْماتْ سَ تانْ جَگادَ یُویَمَپِ کِمیتادرِگَبودھاح؟ کِمَپِ دْرَوْیَں باہْیادَنْتَرَں پْرَوِشْیَ نَرَمَمیدھْیَں کَرْتّاں نَ شَکْنوتِ کَتھامِماں کِں نَ بُدھْیَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","تَتْ تَدَنْتَرْنَ پْرَوِشَتِ کِنْتُ کُکْشِمَدھْیَں پْرَوِشَتِ شیشے سَرْوَّبھُکْتَوَسْتُگْراہِنِ بَہِرْدیشے نِرْیاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","اَپَرَمَپْیَوادِیدْ یَنَّرانِّریتِ تَدیوَ نَرَمَمیدھْیَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","یَتونْتَرادْ اَرْتھانْ مانَواناں مَنوبھْیَح کُچِنْتا پَرَسْتْرِیویشْیاگَمَنَں ");
INSERT INTO sanurd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","نَرَوَدھَشْچَورْیَّں لوبھو دُشْٹَتا پْرَوَنْچَنا کامُکَتا کُدرِشْٹِرِیشْوَرَنِنْدا گَرْوَّسْتَمَ اِتْیادِینِ نِرْگَچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ایتانِ سَرْوّانِ دُرِتانْیَنْتَرادیتْیَ نَرَمَمیدھْیَں کُرْوَّنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","اَتھَ سَ اُتّھایَ تَتْسْتھاناتْ سورَسِیدونْپُرَپْرَدیشَں جَگامَ تَتْرَ کِمَپِ نِویشَنَں پْرَوِشْیَ سَرْوَّیرَجْناتَح سْتھاتُں مَتِنْچَکْرے کِنْتُ گُپْتَح سْتھاتُں نَ شَشاکَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","یَتَح سُرَپھَینِکِیدیشِییَیُونانِیوَںشودْبھَوَسْتْرِیاح کَنْیا بھُوتَگْرَسْتاسِیتْ۔ سا سْتْرِی تَدْوارْتّاں پْراپْیَ تَتْسَمِیپَماگَتْیَ تَچَّرَنَیوح پَتِتْوا ");
INSERT INTO sanurd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","سْوَکَنْیاتو بھُوتَں نِراکَرْتّاں تَسْمِنْ وِنَیَں کرِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","کِنْتُ یِیشُسْتامَوَدَتْ پْرَتھَمَں بالَکاسْترِپْیَنْتُ یَتو بالَکاناں کھادْیَں گرِہِیتْوا کُکُّریبھْیو نِکْشیپونُچِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","تَدا سا سْتْرِی تَمَوادِیتْ بھوح پْرَبھو تَتْ سَتْیَں تَتھاپِ مَنْچادھَحسْتھاح کُکُّرا بالاناں کَرَپَتِتانِ کھادْیَکھَنْڈانِ کھادَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","تَتَح سوکَتھَیَدْ ایتَتْکَتھاہیتوح سَکُشَلا یاہِ تَوَ کَنْیاں تْیَکْتْوا بھُوتو گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","اَتھَ سا سْتْرِی گرِہَں گَتْوا کَنْیاں بھُوتَتْیَکْتاں شَیّاسْتھِتاں دَدَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","پُنَشْچَ سَ سورَسِیدونْپُرَپْرَدیشاتْ پْرَسْتھایَ دِکاپَلِدیشَسْیَ پْرانْتَرَبھاگینَ گالِیلْجَلَدھیح سَمِیپَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","تَدا لوکَیریکَں بَدھِرَں کَدْوَدَنْچَ نَرَں تَنِّکَٹَمانِییَ تَسْیَ گاتْرے ہَسْتَمَرْپَیِتُں وِنَیَح کرِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","تَتو یِیشُ رْلوکارَنْیاتْ تَں نِرْجَنَمانِییَ تَسْیَ کَرْنَیونْگُلِی رْدَدَو نِشْٹھِیوَں دَتّوا چَ تَجِّہْواں پَسْپَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","اَنَنْتَرَں سْوَرْگَں نِرِیکْشْیَ دِیرْگھَں نِشْوَسْیَ تَمَوَدَتْ اِتَپھَتَح اَرْتھانْ مُکْتو بھُویاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","تَتَسْتَتْکْشَنَں تَسْیَ کَرْنَو مُکْتَو جِہْوایاشْچَ جاڈْیاپَگَماتْ سَ سُسْپَشْٹَواکْیَمَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","اَتھَ سَ تانْ واڈھَمِتْیادِدیشَ یُویَمِماں کَتھاں کَسْمَیچِدَپِ ما کَتھَیَتَ، کِنْتُ سَ یَتِ نْیَشیدھَتْ تے تَتِ باہُلْیینَ پْراچارَیَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","تےتِچَمَتْکرِتْیَ پَرَسْپَرَں کَتھَیاماسُح سَ بَدھِرایَ شْرَوَنَشَکْتِں مُوکایَ چَ کَتھَنَشَکْتِں دَتّوا سَرْوَّں کَرْمّوتَّمَرُوپینَ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","تَدا تَتْسَمِیپَں بَہَوو لوکا آیاتا اَتَسْتیشاں بھوجْیَدْرَوْیابھاوادْ یِیشُح شِشْیاناہُویَ جَگادَ،۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","لوکَنِوَہے مَمَ کرِپا جایَتے تے دِنَتْرَیَں مَیا سارْدّھَں سَنْتِ تیشاں بھوجْیَں کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","تیشاں مَدھْیےنیکے دُورادْ آگَتاح، اَبھُکْتیشُ تیشُ مَیا سْوَگرِہَمَبھِپْرَہِتیشُ تے پَتھِ کْلَمِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","شِشْیا اَوادِشُح، ایتاوَتو لوکانْ تَرْپَیِتُمْ اَتْرَ پْرَنْتَرے پُوپانْ پْراپْتُں کینَ شَکْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","تَتَح سَ تانْ پَپْرَچّھَ یُشْماکَں کَتِ پُوپاح سَنْتِ؟ تےکَتھَیَنْ سَپْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","تَتَح سَ تالّوکانْ بھُوِ سَمُپَویشْٹُمْ آدِشْیَ تانْ سَپْتَ پُوپانْ دھرِتْوا اِیشْوَرَگُنانْ اَنُکِیرْتَّیاماسَ، بھَںکْتْوا پَرِویشَیِتُں شِشْیانْ پْرَتِ دَدَو، تَتَسْتے لوکیبھْیَح پَرِویشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","تَتھا تیشاں سَمِیپے یے کْشُدْرَمَتْسْیا آسَنْ تانَپْیادایَ اِیشْوَرَگُنانْ سَںکِیرْتْیَ پَرِویشَیِتُمْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","تَتو لوکا بھُکْتْوا ترِپْتِں گَتا اَوَشِشْٹَکھادْیَیح پُورْناح سَپْتَڈَلَّکا گرِہِیتاشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ایتے بھوکْتارَح پْرایَشْچَتُح سَہَسْرَپُرُشا آسَنْ تَتَح سَ تانْ وِسَسَرْجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","اَتھَ سَ شِشْیَح سَہَ ناوَمارُہْیَ دَلْمانُوتھاسِیماماگَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","تَتَح پَرَں پھِرُوشِنَ آگَتْیَ تینَ سَہَ وِوَدَماناسْتَسْیَ پَرِیکْشارْتھَمْ آکاشِییَچِہْنَں دْرَشْٹُں یاچِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","تَدا سونْتَرْدِیرْگھَں نِشْوَسْیاکَتھَیَتْ، ایتے وِدْیَمانَنَراح کُتَشْچِنْہَں مرِگَیَنْتے؟ یُشْمانَہَں یَتھارْتھَں بْرَوِیمِ لوکانیتانْ کِمَپِ چِہْنَں نَ دَرْشَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","اَتھَ تانْ ہِتْوا پُنَ رْناوَمْ آرُہْیَ پارَمَگاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ایتَرْہِ شِشْیَیح پُوپیشُ وِسْمرِتیشُ ناوِ تیشاں سَنِّدھَو پُوپَ ایکَایوَ سْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","تَدانِیں یِیشُسْتانْ آدِشْٹَوانْ پھِرُوشِناں ہیرودَشْچَ کِنْوَں پْرَتِ سَتَرْکاح ساوَدھاناشْچَ بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","تَتَسْتےنْیونْیَں وِویچَنَں کَرْتُمْ آریبھِرے، اَسْماکَں سَنِّدھَو پُوپو ناسْتِیتِ ہیتورِدَں کَتھَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","تَدْ بُدْوّا یِیشُسْتیبھْیوکَتھَیَتْ یُشْماکَں سْتھانے پُوپابھاواتْ کُتَ اِتّھَں وِتَرْکَیَتھَ؟ یُویَں کِمَدْیاپِ کِمَپِ نَ جانِیتھَ؟ بودّھُنْچَ نَ شَکْنُتھَ؟ یاوَدَدْیَ کِں یُشْماکَں مَناںسِ کَٹھِنانِ سَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","سَتْسُ نیتْریشُ کِں نَ پَشْیَتھَ؟ سَتْسُ کَرْنیشُ کِں نَ شرِنُتھَ؟ نَ سْمَرَتھَ چَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","یَداہَں پَنْچَپُوپانْ پَنْچَسَہَسْراناں پُرُشاناں مَدھْیے بھَںکْتْوا دَتَّوانْ تَدانِیں یُویَمْ اَوَشِشْٹَپُوپَیح پُورْنانْ کَتِ ڈَلَّکانْ گرِہِیتَوَنْتَح؟ تےکَتھَیَنْ دْوادَشَڈَلَّکانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","اَپَرَنْچَ یَدا چَتُحسَہَسْراناں پُرُشاناں مَدھْیے پُوپانْ بھَںکْتْوادَداں تَدا یُویَمْ اَتِرِکْتَپُوپاناں کَتِ ڈَلَّکانْ گرِہِیتَوَنْتَح؟ تے کَتھَیاماسُح سَپْتَڈَلَّکانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","تَدا سَ کَتھِتَوانْ تَرْہِ یُویَمْ اَدھُناپِ کُتو بودْوُّں نَ شَکْنُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","اَنَنْتَرَں تَسْمِنْ بَیتْسَیدانَگَرے پْراپْتے لوکا اَنْدھَمیکَں نَرَں تَتْسَمِیپَمانِییَ تَں سْپْرَشْٹُں تَں پْرارْتھَیانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","تَدا تَسْیانْدھَسْیَ کَرَو گرِہِیتْوا نَگَرادْ بَہِرْدیشَں تَں نِیتَوانْ؛ تَنّیتْرے نِشْٹھِیوَں دَتّوا تَدْگاتْرے ہَسْتاوَرْپَیِتْوا تَں پَپْرَچّھَ، کِمَپِ پَشْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","سَ نیتْرے اُنْمِیلْیَ جَگادَ، ورِکْشَوَتْ مَنُجانْ گَچّھَتو نِرِیکْشے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","تَتو یِیشُح پُنَسْتَسْیَ نَیَنَیو رْہَسْتاوَرْپَیِتْوا تَسْیَ نیتْرے اُنْمِیلَیاماسَ؛ تَسْماتْ سَ سْوَسْتھو بھُوتْوا سْپَشْٹَرُوپَں سَرْوَّلوکانْ دَدَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","تَتَح پَرَں تْوَں گْرامَں ما گَچّھَ گْرامَسْتھَں کَمَپِ چَ کِمَپْیَنُکْتْوا نِجَگرِہَں یاہِیتْیادِشْیَ یِیشُسْتَں نِجَگرِہَں پْرَہِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","اَنَنْتَرَں شِشْیَیح سَہِتو یِیشُح کَیسَرِییاپھِلِپِپُرَں جَگامَ، پَتھِ گَچّھَنْ تانَپرِچّھَتْ کوہَمْ اَتْرَ لوکاح کِں وَدَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","تے پْرَتْیُوچُح تْواں یوہَنَں مَجَّکَں وَدَنْتِ کِنْتُ کیپِ کیپِ ایلِیَں وَدَنْتِ؛ اَپَرے کیپِ کیپِ بھَوِشْیَدْوادِنامْ ایکو جَنَ اِتِ وَدَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","اَتھَ سَ تانَپرِچّھَتْ کِنْتُ کوہَمْ؟ اِتْیَتْرَ یُویَں کِں وَدَتھَ؟ تَدا پِتَرَح پْرَتْیَوَدَتْ بھَوانْ اَبھِشِکْتَسْتْراتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","تَتَح سَ تانْ گاڈھَمادِشَدْ یُویَں مَمَ کَتھا کَسْمَیچِدَپِ ما کَتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","مَنُشْیَپُتْریناوَشْیَں بَہَوو یاتَنا بھوکْتَوْیاح پْراچِینَلوکَیح پْرَدھانَیاجَکَیرَدھْیاپَکَیشْچَ سَ نِنْدِتَح سَنْ گھاتَیِشْیَتے ترِتِییَدِنے اُتّھاسْیَتِ چَ، یِیشُح شِشْیانُپَدیشْٹُمارَبھْیَ کَتھامِماں سْپَشْٹَماچَشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","تَسْماتْ پِتَرَسْتَسْیَ ہَسْتَو دھرِتْوا تَں تَرْجِّتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","کِنْتُ سَ مُکھَں پَراوَرْتْیَ شِشْیَگَنَں نِرِیکْشْیَ پِتَرَں تَرْجَیِتْواوادِیدْ دُورِیبھَوَ وِگھْنَکارِنْ اِیشْوَرِییَکارْیّادَپِ مَنُشْیَکارْیَّں تُبھْیَں روچَتَتَراں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","اَتھَ سَ لوکانْ شِشْیاںشْچاہُویَ جَگادَ یَح کَشْچِنْ مامَنُگَنْتُمْ اِچّھَتِ سَ آتْمانَں دامْیَتُ، سْوَکْرُشَں گرِہِیتْوا مَتْپَشْچادْ آیاتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","یَتو یَح کَشْچِتْ سْوَپْرانَں رَکْشِتُمِچّھَتِ سَ تَں ہارَیِشْیَتِ، کِنْتُ یَح کَشْچِنْ مَدَرْتھَں سُسَںوادارْتھَنْچَ پْرانَں ہارَیَتِ سَ تَں رَکْشِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","اَپَرَنْچَ مَنُجَح سَرْوَّں جَگَتْ پْراپْیَ یَدِ سْوَپْرانَں ہارَیَتِ تَرْہِ تَسْیَ کو لابھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","نَرَح سْوَپْرانَوِنِمَیینَ کِں داتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ایتیشاں وْیَبھِچارِناں پاپِنانْچَ لوکاناں ساکْشادْ یَدِ کوپِ ماں مَتْکَتھانْچَ لَجّاسْپَدَں جاناتِ تَرْہِ مَنُجَپُتْرو یَدا دھَرْمَّدُوتَیح سَہَ پِتُح پْرَبھاویناگَمِشْیَتِ تَدا سوپِ تَں لَجّاسْپَدَں جْناسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","اَتھَ سَ تانَوادِیتْ یُشْمَبھْیَمَہَں یَتھارْتھَں کَتھَیامِ، اِیشْوَرَراجْیَں پَراکْرَمینوپَسْتھِتَں نَ درِشْٹْوا مرِتْیُں ناسْوادِشْیَنْتے، اَتْرَ دَنْڈایَماناناں مَدھْییپِ تادرِشا لوکاح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","اَتھَ شَڈْدِنیبھْیَح پَرَں یِیشُح پِتَرَں یاکُوبَں یوہَنَنْچَ گرِہِیتْوا گِریرُچَّسْیَ نِرْجَنَسْتھانَں گَتْوا تیشاں پْرَتْیَکْشے مُورْتْیَنْتَرَں دَدھارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","تَتَسْتَسْیَ پَرِدھییَمْ اِیدرِشَمْ اُجّوَلَہِمَپانَڈَرَں جاتَں یَدْ جَگَتِ کوپِ رَجَکو نَ تادرِکْ پانَڈَرَں کَرْتّاں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","اَپَرَنْچَ ایلِیو مُوساشْچَ تیبھْیو دَرْشَنَں دَتّوا یِیشُنا سَہَ کَتھَنَں کَرْتُّماریبھاتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","تَدا پِتَرو یِیشُمَوادِیتْ ہے گُروسْماکَمَتْرَ سْتھِتِرُتَّما، تَتَایوَ وَیَں تْوَتْکرِتے ایکاں مُوساکرِتے ایکامْ ایلِیَکرِتے چَیکاں، ایتاسْتِسْرَح کُٹِی رْنِرْمّامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","کِنْتُ سَ یَدُکْتَوانْ تَتْ سْوَیَں نَ بُبُدھے تَتَح سَرْوّے بِبھَیانْچَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ایتَرْہِ پَیودَسْتانْ چھادَیاماسَ، مَمَیاں پْرِیَح پُتْرَح کَتھاسُ تَسْیَ مَناںسِ نِویشَیَتیتِ نَبھووانِی تَنْمیدْیانِّرْیَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","اَتھَ ہَٹھاتّے چَتُرْدِشو درِشْٹْوا یِیشُں وِنا سْوَیح سَہِتَں کَمَپِ نَ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","تَتَح پَرَں گِریرَوَروہَنَکالے سَ تانْ گاڈھَمْ دُوتْیادِدیشَ یاوَنَّرَسُونوح شْمَشانادُتّھانَں نَ بھَوَتِ، تاوَتْ دَرْشَنَسْیاسْیَ وارْتّا یُشْمابھِح کَسْمَیچِدَپِ نَ وَکْتَوْیا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","تَدا شْمَشانادُتّھانَسْیَ کوبھِپْرایَ اِتِ وِچارْیَّ تے تَدْواکْیَں سْویشُ گوپایانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","اَتھَ تے یِیشُں پَپْرَچّھُح پْرَتھَمَتَ ایلِییناگَنْتَوْیَمْ اِتِ واکْیَں کُتَ اُپادھْیایا آہُح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","تَدا سَ پْرَتْیُواچَ ، ایلِیَح پْرَتھَمَمیتْیَ سَرْوَّکارْیّانِ سادھَیِشْیَتِ؛ نَرَپُتْرے چَ لِپِ رْیَتھاسْتے تَتھَیوَ سوپِ بَہُدُحکھَں پْراپْیاوَجْناسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","کِنْتْوَہَں یُشْمانْ وَدامِ ، ایلِیارْتھے لِپِ رْیَتھاسْتے تَتھَیوَ سَ ایتْیَ یَیَو، لوکا: سْویچّھانُرُوپَں تَمَبھِوْیَوَہَرَنْتِ سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","اَنَنْتَرَں سَ شِشْیَسَمِیپَمیتْیَ تیشاں چَتُحپارْشْوے تَیح سَہَ بَہُجَنانْ وِوَدَمانانْ اَدھْیاپَکاںشْچَ درِشْٹَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","کِنْتُ سَرْوَّلوکاسْتَں درِشْٹْوَیوَ چَمَتْکرِتْیَ تَداسَنَّں دھاوَنْتَسْتَں پْرَنیمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","تَدا یِیشُرَدھْیاپَکانَپْراکْشِیدْ ایتَیح سَہَ یُویَں کِں وِوَدَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","تَتو لوکاناں کَشْچِدیکَح پْرَتْیَوادِیتْ ہے گُرو مَمَ سُونُں مُوکَں بھُوتَدھرِتَنْچَ بھَوَداسَنَّمْ آنَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","یَداسَو بھُوتَسْتَماکْرَمَتے تَدَیوَ پاتَسَتِ تَتھا سَ پھینایَتے، دَنْتَیرْدَنْتانْ گھَرْشَتِ کْشِینو بھَوَتِ چَ؛ تَتو ہیتوسْتَں بھُوتَں تْیاجَیِتُں بھَوَچّھِشْیانْ نِویدِتَوانْ کِنْتُ تے نَ شیکُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","تَدا سَ تَمَوادِیتْ، رے اَوِشْواسِنَح سَنْتانا یُشْمابھِح سَہَ کَتِ کالانَہَں سْتھاسْیامِ؟ اَپَرانْ کَتِ کالانْ وا وَ آچارانْ سَہِشْیے؟ تَں مَداسَنَّمانَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","تَتَسْتَتْسَنِّدھِں سَ آنِییَتَ کِنْتُ تَں درِشْٹْوَیوَ بھُوتو بالَکَں دھرِتَوانْ؛ سَ چَ بھُومَو پَتِتْوا پھینایَمانو لُلوٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","تَدا سَ تَتْپِتَرَں پَپْرَچّھَ، اَسْییدرِشِی دَشا کَتِ دِنانِ بھُوتا؟ تَتَح سووادِیتْ بالْیَکالاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","بھُوتویَں تَں ناشَیِتُں بَہُوارانْ وَہْنَو جَلے چَ نْیَکْشِپَتْ کِنْتُ یَدِ بھَوانَ کِمَپِ کَرْتّاں شَکْنوتِ تَرْہِ دَیاں کرِتْواسْمانْ اُپَکَروتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","تَدا یِیشُسْتَمَوَدَتْ یَدِ پْرَتْییتُں شَکْنوشِ تَرْہِ پْرَتْیَیِنے جَنایَ سَرْوَّں سادھْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","تَتَسْتَتْکْشَنَں تَدْبالَکَسْیَ پِتا پْروچَّے رُووَنْ ساشْرُنیتْرَح پْروواچَ، پْرَبھو پْرَتْییمِ مَماپْرَتْیَیَں پْرَتِکُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","اَتھَ یِیشُ رْلوکَسَنْگھَں دھاوِتْوایانْتَں درِشْٹْوا تَمَپُوتَبھُوتَں تَرْجَیِتْوا جَگادَ، رے بَدھِرَ مُوکَ بھُوتَ تْوَمیتَسْمادْ بَہِرْبھَوَ پُنَح کَداپِ ماشْرَیَینَں تْوامَہَمْ اِتْیادِشامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","تَدا سَ بھُوتَشْچِیتْشَبْدَں کرِتْوا تَماپِیڈْیَ بَہِرْجَجامَ، تَتو بالَکو مرِتَکَلْپو بَبھُووَ تَسْمادَیَں مرِتَاِتْیَنیکے کَتھَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","کِنْتُ کَرَں دھرِتْوا یِیشُنوتّھاپِتَح سَ اُتَّسْتھَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","اَتھَ یِیشَو گرِہَں پْرَوِشْٹے شِشْیا گُپْتَں تَں پَپْرَچّھُح، وَیَمینَں بھُوتَں تْیاجَیِتُں کُتو نَ شَکْتاح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","سَ اُواچَ، پْرارْتھَنوپَواسَو وِنا کیناپْیَنْیینَ کَرْمَّنا بھُوتَمِیدرِشَں تْیاجَیِتُں نَ شَکْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","اَنَنْتَرَں سَ تَتْسْتھانادِتْوا گالِیلْمَدھْیینَ یَیَو، کِنْتُ تَتْ کوپِ جانِییادِتِ سَ نَیچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","اَپَرَنْچَ سَ شِشْیانُپَدِشَنْ بَبھاشے، نَرَپُتْرو نَرَہَسْتیشُ سَمَرْپَیِشْیَتے تے چَ تَں ہَنِشْیَنْتِ تَیسْتَسْمِنْ ہَتے ترِتِییَدِنے سَ اُتّھاسْیَتِیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","کِنْتُ تَتْکَتھاں تے نابُدھْیَنْتَ پْرَشْٹُنْچَ بِبھْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","اَتھَ یِیشُح کَپھَرْناہُومْپُرَماگَتْیَ مَدھْییگرِہَنْچیتْیَ تانَپرِچّھَدْ وَرْتْمَمَدھْیے یُویَمَنْیونْیَں کِں وِوَدَدھْوے سْمَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","کِنْتُ تے نِرُتَّراسْتَسْتھُ رْیَسْماتّیشاں کو مُکھْیَ اِتِ وَرْتْمانِ تےنْیونْیَں وْیَوَدَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","تَتَح سَ اُپَوِشْیَ دْوادَشَشِشْیانْ آہُویَ بَبھاشے یَح کَشْچِتْ مُکھْیو بھَوِتُمِچّھَتِ سَ سَرْوّیبھْیو گَونَح سَرْوّیشاں سیوَکَشْچَ بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","تَدا سَ بالَکَمیکَں گرِہِیتْوا مَدھْیے سَمُپاویشَیَتْ تَتَسْتَں کْروڈے کرِتْوا تانَواداتْ ");
INSERT INTO sanurd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","یَح کَشْچِدِیدرِشَسْیَ کَسْیاپِ بالَسْیاتِتھْیَں کَروتِ سَ مَماتِتھْیَں کَروتِ؛ یَح کَشْچِنْمَماتِتھْیَں کَروتِ سَ کیوَلَمْ مَماتِتھْیَں کَروتِ تَنَّ مَتْپْریرَکَسْیاپْیاتِتھْیَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","اَتھَ یوہَنْ تَمَبْرَوِیتْ ہے گُرو، اَسْماکَمَنَنُگامِنَمْ ایکَں تْوانّامْنا بھُوتانْ تْیاجَیَنْتَں وَیَں درِشْٹَوَنْتَح، اَسْماکَمَپَشْچادْگامِتْواچَّ تَں نْیَشیدھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","کِنْتُ یِیشُرَوَدَتْ تَں ما نِشیدھَتْ، یَتو یَح کَشْچِنْ مَنّامْنا چِتْرَں کَرْمَّ کَروتِ سَ سَہَسا ماں نِنْدِتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","تَتھا یَح کَشْچِدْ یُشْماکَں وِپَکْشَتاں نَ کَروتِ سَ یُشْماکَمیوَ سَپَکْشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","یَح کَشْچِدْ یُشْمانْ کھْرِیشْٹَشِشْیانْ جْناتْوا مَنّامْنا کَںسَیکینَ پانِییَں پاتُں دَداتِ، یُشْمانَہَں یَتھارْتھَں وَچْمِ، سَ پھَلینَ وَنْچِتو نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","کِنْتُ یَدِ کَشْچِنْ مَیِ وِشْواسِنامیشاں کْشُدْرَپْرانِنامْ ایکَسْیاپِ وِگھْنَں جَنَیَتِ، تَرْہِ تَسْیَیتَتْکَرْمَّ کَرَناتْ کَنْٹھَبَدّھَپیشَنِیکَسْیَ تَسْیَ ساگَراگادھَجَلَ مَجَّنَں بھَدْرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","اَتَح سْوَکَرو یَدِ تْواں بادھَتے تَرْہِ تَں چھِنْدھِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","یَسْماتْ یَتْرَ کِیٹا نَ مْرِیَنْتے وَہْنِشْچَ نَ نِرْوّاتِ، تَسْمِنْ اَنِرْوّانانَلَنَرَکے کَرَدْوَیَوَسْتَوَ گَمَناتْ کَرَہِینَسْیَ سْوَرْگَپْرَویشَسْتَوَ کْشیمَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","یَدِ تَوَ پادو وِگھْنَں جَنَیَتِ تَرْہِ تَں چھِنْدھِ، ");
INSERT INTO sanurd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","یَتو یَتْرَ کِیٹا نَ مْرِیَنْتے وَہْنِشْچَ نَ نِرْوّاتِ، تَسْمِنْ نِرْوّانَوَہْنَو نَرَکے دْوِپادَوَتَسْتَوَ نِکْشیپاتْ پادَہِینَسْیَ سْوَرْگَپْرَویشَسْتَوَ کْشیمَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","سْوَنیتْرَں یَدِ تْواں بادھَتے تَرْہِ تَدَپْیُتْپاٹَیَ، یَتو یَتْرَ کِیٹا نَ مْرِیَنْتے وَہْنِشْچَ نَ نِرْوّاتِ، ");
INSERT INTO sanurd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","تَسْمِنَ نِرْوّانَوَہْنَو نَرَکے دْوِنیتْرَسْیَ تَوَ نِکْشیپادْ ایکَنیتْرَوَتَ اِیشْوَرَراجْیے پْرَویشَسْتَوَ کْشیمَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","یَتھا سَرْوّو بَلِ رْلَوَناکْتَح کْرِیَتے تَتھا سَرْوّو جَنو وَہْنِرُوپینَ لَوَناکْتَح کارِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","لَوَنَں بھَدْرَں کِنْتُ یَدِ لَوَنے سْوادُتا نَ تِشْٹھَتِ، تَرْہِ کَتھَمْ آسْوادْیُکْتَں کَرِشْیَتھَ؟ یُویَں لَوَنَیُکْتا بھَوَتَ پَرَسْپَرَں پْریمَ کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","اَنَنْتَرَں سَ تَتْسْتھاناتْ پْرَسْتھایَ یَرْدَّنَنَدْیاح پارے یِہُوداپْرَدیشَ اُپَسْتھِتَوانْ، تَتْرَ تَدَنْتِکے لوکاناں سَماگَمے جاتے سَ نِجَرِیتْیَنُسارینَ پُنَسْتانْ اُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","تَدا پھِرُوشِنَسْتَتْسَمِیپَمْ ایتْیَ تَں پَرِیکْشِتُں پَپْرَچّھَح سْوَجایا مَنُجاناں تْیَجْیا نَ ویتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","تَتَح سَ پْرَتْیَوادِیتْ، اَتْرَ کارْیّے مُوسا یُشْمانْ پْرَتِ کِماجْناپَیَتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","تَ اُوچُح تْیاگَپَتْرَں لیکھِتُں سْوَپَتْنِیں تْیَکْتُنْچَ مُوسانُمَنْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","تَدا یِیشُح پْرَتْیُواچَ، یُشْماکَں مَنَساں کاٹھِنْیادّھیتو رْمُوسا نِدیشَمِمَمْ اَلِکھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","کِنْتُ سرِشْٹیرادَو اِیشْوَرو نَرانْ پُںرُوپینَ سْتْرِیرُوپینَ چَ سَسَرْجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"تَتَح کارَناتْ پُمانْ پِتَرَں ماتَرَنْچَ تْیَکْتْوا سْوَجایایامْ آسَکْتو بھَوِشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","تَو دْواوْ ایکانْگَو بھَوِشْیَتَح۔ \" تَسْماتْ تَتْکالَمارَبھْیَ تَو نَ دْواوْ ایکانْگَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","اَتَح کارَنادْ اِیشْوَرو یَدَیوجَیَتْ کوپِ نَرَسْتَنَّ وِییجَییتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","اَتھَ یِیشُ رْگرِہَں پْرَوِشْٹَسْتَدا شِشْیاح پُنَسْتَتْکَتھاں تَں پَپْرَچّھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","تَتَح سووَدَتْ کَشْچِدْ یَدِ سْوَبھارْیّاں تْیَکْتَوانْیامْ اُدْوَہَتِ تَرْہِ سَ سْوَبھارْیّایاح پْراتِکُولْیینَ وْیَبھِچارِی بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","کاچِنّارِی یَدِ سْوَپَتِں ہِتْوانْیَپُںسا وِواہِتا بھَوَتِ تَرْہِ ساپِ وْیَبھِچارِنِی بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","اَتھَ سَ یَتھا شِشُونْ سْپرِشیتْ، تَدَرْتھَں لوکَیسْتَدَنْتِکَں شِشَوَ آنِییَنْتَ، کِنْتُ شِشْیاسْتانانِیتَوَتَسْتَرْجَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","یِیشُسْتَدْ درِشْٹْوا کْرُدھْیَنْ جَگادَ، مَنِّکَٹَمْ آگَنْتُں شِشُونْ ما وارَیَتَ، یَتَ ایتادرِشا اِیشْوَرَراجْیادھِکارِنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","یُشْمانَہَں یَتھارْتھَں وَچْمِ، یَح کَشْچِتْ شِشُوَدْ بھُوتْوا راجْیَمِیشْوَرَسْیَ نَ گرِہْلِییاتْ سَ کَداپِ تَدْراجْیَں پْرَویشْٹُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","اَنَنَتَرَں سَ شِشُونَنْکے نِدھایَ تیشاں گاتْریشُ ہَسْتَو دَتّواشِشَں بَبھاشے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","اَتھَ سَ وَرْتْمَنا یاتِ، ایتَرْہِ جَنَ ایکو دھاوَنْ آگَتْیَ تَتْسَمُّکھے جانُنِی پاتَیِتْوا پرِشْٹَوانْ، بھوح پَرَمَگُرو، اَنَنْتایُح پْراپْتَیے مَیا کِں کَرْتَّوْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","تَدا یِیشُرُواچَ، ماں پَرَمَں کُتو وَدَسِ؟ وِنیشْوَرَں کوپِ پَرَمو نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","پَرَسْتْرِیں نابھِگَچّھَ؛ نَرَں ما گھاتَیَ؛ سْتییَں ما کُرُ؛ مرِشاساکْشْیَں ما دیہِ؛ ہِںسانْچَ ما کُرُ؛ پِتَرَو سَمَّنْیَسْوَ؛ نِدیشا ایتے تْوَیا جْناتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","تَتَسْتَنَ پْرَتْیُکْتَں، ہے گُرو بالْیَکالادَہَں سَرْوّانیتانْ آچَرامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","تَدا یِیشُسْتَں وِلوکْیَ سْنیہینَ بَبھاشے، تَوَیکَسْیابھاوَ آسْتے؛ تْوَں گَتْوا سَرْوَّسْوَں وِکْرِییَ دَرِدْریبھْیو وِشْرانَیَ، تَتَح سْوَرْگے دھَنَں پْراپْسْیَسِ؛ تَتَح پَرَمْ ایتْیَ کْرُشَں وَہَنْ مَدَنُوَرْتِّی بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","کِنْتُ تَسْیَ بَہُسَمْپَدْوِدْیَمانَتْواتْ سَ اِماں کَتھاماکَرْنْیَ وِشَنو دُحکھِتَشْچَ سَنْ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","اَتھَ یِیشُشْچَتُرْدِشو نِرِیکْشْیَ شِشْیانْ اَوادِیتْ، دھَنِلوکانامْ اِیشْوَرَراجْیَپْرَویشَح کِیدرِگْ دُشْکَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","تَسْیَ کَتھاتَح شِشْیاشْچَمَچَّکْرُح، کِنْتُ سَ پُنَرَوَدَتْ، ہے بالَکا یے دھَنے وِشْوَسَنْتِ تیشامْ اِیشْوَرَراجْیَپْرَویشَح کِیدرِگْ دُشْکَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","اِیشْوَرَراجْیے دھَنِناں پْرَویشاتْ سُوچِرَنْدھْرینَ مَہانْگَسْیَ گَمَناگَمَنَں سُکَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","تَدا شِشْیا اَتِیوَ وِسْمِتاح پَرَسْپَرَں پْروچُح، تَرْہِ کَح پَرِتْرانَں پْراپْتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","تَتو یِیشُسْتانْ وِلوکْیَ بَبھاشے، تَنْ نَرَسْیاسادھْیَں کِنْتُ نیشْوَرَسْیَ، یَتو ہیتورِیشْوَرَسْیَ سَرْوَّں سادھْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","تَدا پِتَرَ اُواچَ، پَشْیَ وَیَں سَرْوَّں پَرِتْیَجْیَ بھَوَتونُگامِنو جاتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","تَتو یِیشُح پْرَتْیَوَدَتْ، یُشْمانَہَں یَتھارْتھَں وَدامِ، مَدَرْتھَں سُسَںوادارْتھَں وا یو جَنَح سَدَنَں بھْراتَرَں بھَگِنِیں پِتَرَں ماتَرَں جایاں سَنْتانانْ بھُومِ وا تْیَکْتْوا ");
INSERT INTO sanurd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","گرِہَبھْراترِبھَگِنِیپِترِماترِپَتْنِیسَنْتانَبھُومِینامِہَ شَتَگُنانْ پْریتْیانَنْتایُشْچَ نَ پْراپْنوتِ تادرِشَح کوپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","کِنْتْوَگْرِییا اَنیکے لوکاح شیشاح، شیشِییا اَنیکے لوکاشْچاگْرا بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","اَتھَ یِرُوشالَمْیانَکالے یِیشُسْتیشامْ اَگْرَگامِی بَبھُووَ، تَسْماتّے چِتْرَں جْناتْوا پَشْچادْگامِنو بھُوتْوا بِبھْیُح۔ تَدا سَ پُنَ رْدْوادَشَشِشْیانْ گرِہِیتْوا سْوِییَں یَدْیَدْ گھَٹِشْیَتے تَتَّتْ تیبھْیَح کَتھَیِتُں پْراریبھے؛ ");
INSERT INTO sanurd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","پَشْیَتَ وَیَں یِرُوشالَمْپُرَں یامَح، تَتْرَ مَنُشْیَپُتْرَح پْرَدھانَیاجَکانامْ اُپادھْیایانانْچَ کَریشُ سَمَرْپَیِشْیَتے؛ تے چَ وَدھَدَنْڈاجْناں داپَیِتْوا پَرَدیشِییاناں کَریشُ تَں سَمَرْپَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","تے تَمُپَہَسْیَ کَشَیا پْرَہرِتْیَ تَدْوَپُشِ نِشْٹھِیوَں نِکْشِپْیَ تَں ہَنِشْیَنْتِ، تَتَح سَ ترِتِییَدِنے پْروتّھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","تَتَح سِوَدیح پُتْرَو یاکُوبْیوہَنَو تَدَنْتِکَمْ ایتْیَ پْروچَتُح، ہے گُرو یَدْ آوابھْیاں یاچِشْیَتے تَدَسْمَدَرْتھَں بھَوانْ کَروتُ نِویدَنَمِدَماوَیوح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","تَتَح سَ کَتھِتَوانْ، یُواں کِمِچّھَتھَح؟ کِں مَیا یُشْمَدَرْتھَں کَرَنِییَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","تَدا تَو پْروچَتُح، آوَیوریکَں دَکْشِنَپارْشْوے وامَپارْشْوے چَیکَں تَوَیشْوَرْیَّپَدے سَمُپَویشْٹُمْ آجْناپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","کِنْتُ یِیشُح پْرَتْیُواچَ یُوامَجْناتْویدَں پْرارْتھَییتھے، یینَ کَںسیناہَں پاسْیامِ تینَ یُوابھْیاں کِں پاتُں شَکْشْیَتے؟ یَسْمِنْ مَجَّنیناہَں مَجِّشْیے تَنْمَجَّنے مَجَّیِتُں کِں یُوابھْیاں شَکْشْیَتے؟ تَو پْرَتْیُوچَتُح شَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","تَدا یِیشُرَوَدَتْ یینَ کَںسیناہَں پاسْیامِ تیناوَشْیَں یُوامَپِ پاسْیَتھَح، یینَ مَجَّنینَ چاہَں مَجِّیّے تَتْرَ یُوامَپِ مَجِّشْییتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","کِنْتُ ییشامَرْتھَمْ اِدَں نِرُوپِتَں، تانْ وِہایانْیَں کَمَپِ مَمَ دَکْشِنَپارْشْوے وامَپارْشْوے وا سَمُپَویشَیِتُں مَمادھِکارو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","اَتھانْیَدَشَشِشْیا اِماں کَتھاں شْرُتْوا یاکُوبْیوہَنْبھْیاں چُکُپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","کِنْتُ یِیشُسْتانْ سَماہُویَ بَبھاشے، اَنْیَدیشِییاناں راجَتْوَں یے کُرْوَّنْتِ تے تیشامیوَ پْرَبھُتْوَں کُرْوَّنْتِ، تَتھا یے مَہالوکاسْتے تیشامْ اَدھِپَتِتْوَں کُرْوَّنْتِیتِ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","کِنْتُ یُشْماکَں مَدھْیے نَ تَتھا بھَوِشْیَتِ، یُشْماکَں مَدھْیے یَح پْرادھانْیَں وانْچھَتِ سَ یُشْماکَں سیوَکو بھَوِشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","یُشْماکَں یو مَہانْ بھَوِتُمِچّھَتِ سَ سَرْوّیشاں کِنْکَرو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","یَتو مَنُشْیَپُتْرَح سیوْیو بھَوِتُں ناگَتَح سیواں کَرْتّاں تَتھانیکیشاں پَرِتْرانَسْیَ مُولْیَرُوپَسْوَپْرانَں داتُنْچاگَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","اَتھَ تے یِرِیہونَگَرَں پْراپْتاسْتَسْماتْ شِشْیَے رْلوکَیشْچَ سَہَ یِیشو رْگَمَنَکالے ٹِیمَیَسْیَ پُتْرو بَرْٹِیمَیَناما اَنْدھَسْتَنْمارْگَپارْشْوے بھِکْشارْتھَمْ اُپَوِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","سَ ناسَرَتِییَسْیَ یِیشوراگَمَنَوارْتّاں پْراپْیَ پْروچَے رْوَکْتُماریبھے، ہے یِیشو دایُودَح سَنْتانَ ماں دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","تَتونیکے لوکا مَونِیبھَویتِ تَں تَرْجَیاماسُح، کِنْتُ سَ پُنَرَدھِکَمُچَّے رْجَگادَ، ہے یِیشو دایُودَح سَنْتانَ ماں دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","تَدا یِیشُح سْتھِتْوا تَماہْواتُں سَمادِدیشَ، تَتو لوکاسْتَمَنْدھَماہُویَ بَبھاشِرے، ہے نَرَ، سْتھِرو بھَوَ، اُتِّشْٹھَ، سَ تْواماہْوَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","تَدا سَ اُتَّرِییَوَسْتْرَں نِکْشِپْیَ پْروتّھایَ یِیشوح سَمِیپَں گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","تَتو یِیشُسْتَمَوَدَتْ تْوَیا کِں پْرارْتھْیَتے؟ تُبھْیَمَہَں کِں کَرِشْیامِی؟ تَدا سونْدھَسْتَمُواچَ، ہے گُرو مَدِییا درِشْٹِرْبھَویتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","تَتو یِیشُسْتَمُواچَ یاہِ تَوَ وِشْواسَسْتْواں سْوَسْتھَمَکارْشِیتْ، تَسْماتْ تَتْکْشَنَں سَ درِشْٹِں پْراپْیَ پَتھا یِیشوح پَشْچادْ یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","اَنَنْتَرَں تیشُ یِرُوشالَمَح سَمِیپَسْتھَیو رْبَیتْپھَگِیبَیتھَنِییَپُرَیورَنْتِکَسْتھَں جَیتُنَنامادْرِماگَتیشُ یِیشُح پْریشَنَکالے دْوَو شِشْیاوِدَں واکْیَں جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","یُوامَمُں سَمُّکھَسْتھَں گْرامَں یاتَں، تَتْرَ پْرَوِشْیَ یو نَرَں ناوَہَتْ تَں گَرْدَّبھَشاوَکَں دْرَکْشْیَتھَسْتَں موچَیِتْوانَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","کِنْتُ یُواں کَرْمّیدَں کُتَح کُرُتھَح؟ کَتھامِماں یَدِ کوپِ پرِچّھَتِ تَرْہِ پْرَبھورَتْرَ پْرَیوجَنَمَسْتِیتِ کَتھِتے سَ شِیگھْرَں تَمَتْرَ پْریشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","تَتَسْتَو گَتْوا دْوِمارْگَمیلَنے کَسْیَچِدْ دْوارَسْیَ پارْشْوے تَں گَرْدَّبھَشاوَکَں پْراپْیَ موچَیَتَح، ");
INSERT INTO sanurd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ایتَرْہِ تَتْروپَسْتھِتَلوکاناں کَشْچِدْ اَپرِچّھَتْ، گَرْدَّبھَشِشُں کُتو موچَیَتھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","تَدا یِیشوراجْنانُسارینَ تیبھْیَح پْرَتْیُدِتے تَتْکْشَنَں تَماداتُں تےنُجَجْنُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","اَتھَ تَو یِیشوح سَنِّدھِں گَرْدَّبھَشِشُمْ آنِییَ تَدُپَرِ سْوَوَسْتْرانِ پاتَیاماسَتُح؛ تَتَح سَ تَدُپَرِ سَمُپَوِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","تَدانیکے پَتھِ سْوَواساںسِ پاتَیاماسُح، پَرَیشْچَ تَرُشاکھاشْچھِتَوا مارْگے وِکِیرْناح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","اَپَرَنْچَ پَشْچادْگامِنوگْرَگامِنَشْچَ سَرْوّے جَنا اُچَیحسْوَرینَ وَکْتُماریبھِرے، جَیَ جَیَ یَح پَرَمیشْوَرَسْیَ نامْناگَچّھَتِ سَ دھَنْیَ اِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","تَتھاسْماکَمَں پُورْوَّپُرُشَسْیَ دایُودو یَدْراجْیَں پَرَمیشْوَرَنامْنایاتِ تَدَپِ دھَنْیَں، سَرْوَّسْمادُچّھرایے سْوَرْگے اِیشْوَرَسْیَ جَیو بھَویتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","اِتّھَں یِیشُ رْیِرُوشالَمِ مَنْدِرَں پْرَوِشْیَ چَتُرْدِکْسْتھانِ سَرْوّانِ وَسْتُونِ درِشْٹَوانْ؛ اَتھَ سایَںکالَ اُپَسْتھِتے دْوادَشَشِشْیَسَہِتو بَیتھَنِیَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","اَپَریہَنِ بَیتھَنِیادْ آگَمَنَسَمَیے کْشُدھارْتّو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","تَتو دُورے سَپَتْرَمُڈُمْبَرَپادَپَں وِلوکْیَ تَتْرَ کِنْچِتْ پھَلَں پْراپْتُں تَسْیَ سَنِّکرِشْٹَں یَیَو، تَدانِیں پھَلَپاتَنَسْیَ سَمَیو ناگَچّھَتِ۔ تَتَسْتَتْروپَسْتھِتَح پَتْرانِ وِنا کِمَپْیَپَرَں نَ پْراپْیَ سَ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","اَدْیارَبھْیَ کوپِ مانَوَسْتْوَتَّح پھَلَں نَ بھُنْجِیتَ؛ اِماں کَتھاں تَسْیَ شِشْیاح شُشْرُوُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","تَدَنَنْتَرَں تیشُ یِرُوشالَمَمایاتیشُ یِیشُ رْمَنْدِرَں گَتْوا تَتْرَسْتھاناں بَنِجاں مُدْراسَنانِ پاراوَتَوِکْریترِنامْ آسَنانِ چَ نْیُبْجَیانْچَکارَ سَرْوّانْ کْریترِنْ وِکْریترِںشْچَ بَہِشْچَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","اَپَرَں مَنْدِرَمَدھْیینَ کِمَپِ پاتْرَں ووڈھُں سَرْوَّجَنَں نِوارَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","لوکانُپَدِشَنْ جَگادَ، مَمَ گرِہَں سَرْوَّجاتِییاناں پْرارْتھَناگرِہَمْ اِتِ نامْنا پْرَتھِتَں بھَوِشْیَتِ ایتَتْ کِں شاسْتْرے لِکھِتَں ناسْتِ؟ کِنْتُ یُویَں تَدیوَ چوراناں گَہْوَرَں کُرُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","اِماں وانِیں شْرُتْوادھْیاپَکاح پْرَدھانَیاجَکاشْچَ تَں یَتھا ناشَیِتُں شَکْنُوَنْتِ تَتھوेپایَں مرِگَیاماسُح، کِنْتُ تَسْیوپَدیشاتْ سَرْوّے لوکا وِسْمَیَں گَتا اَتَسْتے تَسْمادْ بِبھْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","اَتھَ سایَںسَمَیَ اُپَسْتھِتے یِیشُرْنَگَرادْ بَہِرْوَوْراجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","اَنَنْتَرَں پْراتَحکالے تے تینَ مارْگینَ گَچّھَنْتَسْتَمُڈُمْبَرَمَہِیرُہَں سَمُولَں شُشْکَں دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","تَتَح پِتَرَح پُورْوَّواکْیَں سْمَرَنْ یِیشُں بَبھاشَں، ہے گُرو پَشْیَتُ یَ اُڈُمْبَرَوِٹَپِی بھَوَتا شَپْتَح سَ شُشْکو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","تَتو یِیشُح پْرَتْیَوادِیتْ، یُویَمِیشْوَرے وِشْوَسِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","یُشْمانَہَں یَتھارْتھَں وَدامِ کوپِ یَدْییتَدْگِرِں وَدَتِ، تْوَمُتّھایَ گَتْوا جَلَدھَو پَتَ، پْروکْتَمِدَں واکْیَمَوَشْیَں گھَٹِشْیَتے، مَنَسا کِمَپِ نَ سَنْدِہْیَ چیدِدَں وِشْوَسیتْ تَرْہِ تَسْیَ واکْیانُسارینَ تَدْ گھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","اَتو ہیتورَہَں یُشْمانْ وَچْمِ، پْرارْتھَناکالے یَدْیَداکاںکْشِشْیَدھْوے تَتَّدَوَشْیَں پْراپْسْیَتھَ، اِتّھَں وِشْوَسِتَ، تَتَح پْراپْسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","اَپَرَنْچَ یُشْماسُ پْرارْتھَیِتُں سَمُتّھِتیشُ یَدِ کوپِ یُشْماکَمْ اَپَرادھِی تِشْٹھَتِ، تَرْہِ تَں کْشَمَدھْوَں، تَتھا کرِتے یُشْماکَں سْوَرْگَسْتھَح پِتاپِ یُشْماکَماگاںمِ کْشَمِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","کِنْتُ یَدِ نَ کْشَمَدھْوے تَرْہِ وَح سْوَرْگَسْتھَح پِتاپِ یُشْماکَماگاںسِ نَ کْشَمِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","اَنَنْتَرَں تے پُنَ رْیِرُوشالَمَں پْرَوِوِشُح، یِیشُ رْیَدا مَدھْییمَنْدِرَمْ اِتَسْتَتو گَچّھَتِ، تَدانِیں پْرَدھانَیاجَکا اُپادھْیایاح پْرانْچَشْچَ تَدَنْتِکَمیتْیَ کَتھامِماں پَپْرَچّھُح، ");
INSERT INTO sanurd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","تْوَں کینادیشینَ کَرْمّانْییتانِ کَروشِ؟ تَتھَیتانِ کَرْمّانِ کَرْتّاں کینادِشْٹوسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","تَتو یِیشُح پْرَتِگَدِتَوانْ اَہَمَپِ یُشْمانْ ایکَکَتھاں پرِچّھامِ، یَدِ یُویَں تَسْیا اُتَّرَں کُرُتھَ، تَرْہِ کَیاجْنَیاہَں کَرْمّانْییتانِ کَرومِ تَدْ یُشْمَبھْیَں کَتھَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","یوہَنو مَجَّنَمْ اِیشْوَراتْ جاتَں کِں مانَواتْ؟ تَنْمَہْیَں کَتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","تے پَرَسْپَرَں وِویکْتُں پْراریبھِرے، تَدْ اِیشْوَرادْ بَبھُوویتِ چیدْ وَدامَسْتَرْہِ کُتَسْتَں نَ پْرَتْیَیتَ؟ کَتھَمیتاں کَتھَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","مانَوادْ اَبھَوَدِتِ چیدْ وَدامَسْتَرْہِ لوکیبھْیو بھَیَمَسْتِ یَتو ہیتوح سَرْوّے یوہَنَں سَتْیَں بھَوِشْیَدْوادِنَں مَنْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","اَتَایوَ تے یِیشُں پْرَتْیَوادِشُ رْوَیَں تَدْ وَکْتُں نَ شَکْنُمَح۔ یِیشُرُواچَ، تَرْہِ یینادیشینَ کَرْمّانْییتانِ کَرومِ، اَہَمَپِ یُشْمَبھْیَں تَنَّ کَتھَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","اَنَنْتَرَں یِیشُ رْدرِشْٹانْتینَ تیبھْیَح کَتھَیِتُماریبھے، کَشْچِدیکو دْراکْشاکْشیتْرَں وِدھایَ تَچَّتُرْدِکْشُ وارَنِیں کرِتْوا تَنْمَدھْیے دْراکْشاپیشَنَکُنْڈَمْ اَکھَنَتْ، تَتھا تَسْیَ گَڈَمَپِ نِرْمِّتَوانْ تَتَسْتَتْکْشیتْرَں کرِشِیوَلیشُ سَمَرْپْیَ دُورَدیشَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","تَدَنَنْتَرَں پھَلَکالے کرِشِیوَلیبھْیو دْراکْشاکْشیتْرَپھَلانِ پْراپْتُں تیشاں سَوِدھے بھرِتْیَمْ ایکَں پْراہِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","کِنْتُ کرِشِیوَلاسْتَں دھرِتْوا پْرَہرِتْیَ رِکْتَہَسْتَں وِسَسرِجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","تَتَح سَ پُنَرَنْیَمیکَں بھرِتْیَں پْرَشَیاماسَ، کِنْتُ تے کرِشِیوَلاح پاشاناگھاتَیسْتَسْیَ شِرو بھَنْکْتْوا ساپَمانَں تَں وْیَسَرْجَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","تَتَح پَرَں سوپَرَں داسَں پْراہِنوتْ تَدا تے تَں جَگھْنُح، ایوَمْ اَنیکیشاں کَسْیَچِتْ پْرَہارَح کَسْیَچِدْ وَدھَشْچَ تَیح کرِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","تَتَح پَرَں مَیا سْوَپُتْرے پْرَہِتے تے تَمَوَشْیَں سَمَّںسْیَنْتے، اِتْیُکْتْواوَشیشے تیشاں سَنِّدھَو نِجَپْرِیَمْ اَدْوِتِییَں پُتْرَں پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","کِنْتُ کرِشِیوَلاح پَرَسْپَرَں جَگَدُح، ایشَ اُتَّرادھِکارِی، آگَچّھَتَ وَیَمینَں ہَنْمَسْتَتھا کرِتے دھِکارویَمْ اَسْماکَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","تَتَسْتَں دھرِتْوا ہَتْوا دْراکْشاکْشیتْرادْ بَہِح پْراکْشِپَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","اَنیناسَو دْراکْشاکْشیتْرَپَتِح کِں کَرِشْیَتِ؟ سَ ایتْیَ تانْ کرِشِیوَلانْ سَںہَتْیَ تَتْکْشیتْرَمْ اَنْییشُ کرِشِیوَلیشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","اَپَرَنْچَ، \"سْتھَپَتَیَح کَرِشْیَنْتِ گْراوانَں یَنْتُ تُچّھَکَں۔ پْرادھانَپْرَسْتَرَح کونے سَ ایوَ سَںبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ایتَتْ کَرْمَّ پَریشَسْیاںدْبھُتَں نو درِشْٹِتو بھَویتْ۔۔ \" اِماں شاسْتْرِییاں لِپِں یُویَں کِں ناپاٹھِشْٹَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","تَدانِیں سَ تانُدِّشْیَ تاں درِشْٹانْتَکَتھاں کَتھِتَوانْ، تَ اِتّھَں بُدْوّا تَں دھَرْتّامُدْیَتاح، کِنْتُ لوکیبھْیو بِبھْیُح، تَدَنَنْتَرَں تے تَں وِہایَ وَوْرَجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","اَپَرَنْچَ تے تَسْیَ واکْیَدوشَں دھَرْتّاں کَتِپَیانْ پھِرُوشِنو ہیرودِییاںشْچَ لوکانْ تَدَنْتِکَں پْریشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","تَ آگَتْیَ تَمَوَدَنْ، ہے گُرو بھَوانْ تَتھْیَبھاشِی کَسْیاپْیَنُرودھَں نَ مَنْیَتے، پَکْشَپاتَنْچَ نَ کَروتِ، یَتھارْتھَتَ اِیشْوَرِییَں مارْگَں دَرْشَیَتِ وَیَمیتَتْ پْرَجانِیمَح، کَیسَرایَ کَرو دییو نَ واں؟ وَیَں داسْیامو نَ وا؟ ");
INSERT INTO sanurd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","کِنْتُ سَ تیشاں کَپَٹَں جْناتْوا جَگادَ، کُتو ماں پَرِیکْشَدھْوے؟ ایکَں مُدْراپادَں سَمانِییَ ماں دَرْشَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","تَدا تَیریکَسْمِنْ مُدْراپادے سَمانِیتے سَ تانْ پَپْرَچّھَ، اَتْرَ لِکھِتَں نامَ مُورْتِّ رْوا کَسْیَ؟ تے پْرَتْیُوچُح، کَیسَرَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","تَدا یِیشُرَوَدَتْ تَرْہِ کَیسَرَسْیَ دْرَوْیانِ کَیسَرایَ دَتَّ، اِیشْوَرَسْیَ دْرَوْیانِ تُ اِیشْوَرایَ دَتَّ؛ تَتَسْتے وِسْمَیَں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","اَتھَ مرِتانامُتّھانَں یے نَ مَنْیَنْتے تے سِدُوکِنو یِیشوح سَمِیپَماگَتْیَ تَں پَپْرَچّھُح؛ ");
INSERT INTO sanurd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ہے گُرو کَشْچِجَّنو یَدِ نِحسَنْتَتِح سَنْ بھارْیّایاں سَتْیاں مْرِیَتے تَرْہِ تَسْیَ بھْراتا تَسْیَ بھارْیّاں گرِہِیتْوا بھْراتُ رْوَںشوتْپَتِّں کَرِشْیَتِ، وْیَوَسْتھامِماں مُوسا اَسْمانْ پْرَتِ وْیَلِکھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","کِنْتُ کیچِتْ سَپْتَ بھْراتَرَ آسَنْ، تَتَسْتیشاں جْییشْٹھَبھْراتا وِوَہْیَ نِحسَنْتَتِح سَنْ اَمْرِیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","تَتو دْوِتِییو بھْراتا تاں سْتْرِیَمَگرِہَنَتْ کِنْتُ سوپِ نِحسَنْتَتِح سَنْ اَمْرِیَتَ؛ اَتھَ ترِتِییوپِ بھْراتا تادرِشوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","اِتّھَں سَپْتَیوَ بھْراتَرَسْتاں سْتْرِیَں گرِہِیتْوا نِحسَنْتاناح سَنْتومْرِیَنْتَ، سَرْوَّشیشے ساپِ سْتْرِی مْرِیَتے سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","اَتھَ مرِتانامُتّھانَکالے یَدا تَ اُتّھاسْیَنْتِ تَدا تیشاں کَسْیَ بھارْیّا سا بھَوِشْیَتِ؟ یَتَسْتے سَپْتَیوَ تاں وْیَوَہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","تَتو یِیشُح پْرَتْیُواچَ شاسْتْرَمْ اِیشْوَرَشَکْتِنْچَ یُویَمَجْناتْوا کِمَبھْرامْیَتَ نَ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","مرِتَلوکانامُتّھانَں سَتِ تے نَ وِوَہَنْتِ واگْدَتّا اَپِ نَ بھَوَنْتِ، کِنْتُ سْوَرْگِییَدُوتاناں سَدرِشا بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","پُنَشْچَ \"اَہَمْ اِبْراہِیمَ اِیشْوَرَ اِسْہاکَ اِیشْوَرو یاکُوبَشْچیشْوَرَح\" یامِماں کَتھاں سْتَمْبَمَدھْیے تِشْٹھَنْ اِیشْوَرو مُوسامَوادِیتْ مرِتانامُتّھانارْتھے سا کَتھا مُوسالِکھِتے پُسْتَکے کِں یُشْمابھِ رْناپاٹھِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","اِیشْوَرو جِیوَتاں پْرَبھُح کِنْتُ مرِتاناں پْرَبھُ رْنَ بھَوَتِ، تَسْمادّھیتو رْیُویَں مَہابھْرَمینَ تِشْٹھَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ایتَرْہِ ایکودھْیاپَکَ ایتْیَ تیشامِتّھَں وِچارَں شُشْراوَ؛ یِیشُسْتیشاں واکْیَسْیَ سَدُتَّرَں دَتَّوانْ اِتِ بُدْوّا تَں پرِشْٹَوانْ سَرْوّاسامْ آجْناناں کا شْریشْٹھا؟ تَتو یِیشُح پْرَتْیُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ہے اِسْراییلّوکا اَوَدھَتَّ، اَسْماکَں پْرَبھُح پَرَمیشْوَرَ ایکَ ایوَ، ");
INSERT INTO sanurd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","یُویَں سَرْوَّنْتَحکَرَنَیح سَرْوَّپْرانَیح سَرْوَّچِتَّیح سَرْوَّشَکْتِبھِشْچَ تَسْمِنْ پْرَبھَو پَرَمیشْوَرے پْرِییَدھْوَں،\" اِتْیاجْنا شْریشْٹھا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","تَتھا \"سْوَپْرَتِواسِنِ سْوَوَتْ پْریمَ کُرُدھْوَں،\" ایشا یا دْوِتِییاجْنا سا تادرِشِی؛ ایتابھْیاں دْوابھْیامْ آجْنابھْیامْ اَنْیا کاپْیاجْنا شْریشْٹھا ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","تَدا سودھْیاپَکَسْتَمَوَدَتْ، ہے گُرو سَتْیَں بھَوانْ یَتھارْتھَں پْروکْتَوانْ یَتَ ایکَسْمادْ اِیشْوَرادْ اَنْیو دْوِتِییَ اِیشْوَرو ناسْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","اَپَرَں سَرْوّانْتَحکَرَنَیح سَرْوَّپْرانَیح سَرْوَّچِتَّیح سَرْوَّشَکْتِبھِشْچَ اِیشْوَرے پْریمَکَرَنَں تَتھا سْوَمِیپَواسِنِ سْوَوَتْ پْریمَکَرَنَنْچَ سَرْوّیبھْیو ہومَبَلِدانادِبھْیَح شْرَشْٹھَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","تَتو یِیشُح سُبُدّھیرِوَ تَسْییدَمْ اُتَّرَں شْرُتْوا تَں بھاشِتَوانْ تْوَمِیشْوَرَسْیَ راجْیانَّ دُوروسِ۔ اِتَح پَرَں تینَ سَہَ کَسْیاپِ واکْیَسْیَ وِچارَں کَرْتّاں کَسْیاپِ پْرَگَلْبھَتا نَ جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","اَنَنْتَرَں مَدھْییمَنْدِرَمْ اُپَدِشَنْ یِیشُرِمَں پْرَشْنَں چَکارَ، اَدھْیاپَکا اَبھِشِکْتَں (تارَکَں) کُتو دایُودَح سَنْتانَں وَدَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","سْوَیَں دایُودْ پَوِتْرَسْیاتْمَنَ آویشینیدَں کَتھَیاماسَ۔ یَتھا۔ \"مَمَ پْرَبھُمِدَں واکْیَوَدَتْ پَرَمیشْوَرَح۔ تَوَ شَتْرُونَہَں یاوَتْ پادَپِیٹھَں کَرومِ نَ۔ تاوَتْ کالَں مَدِییے تْوَں دَکْشَپارْشْوْ اُپاوِشَ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","یَدِ دایُودْ تَں پْرَبھُوں وَدَتِ تَرْہِ کَتھَں سَ تَسْیَ سَنْتانو بھَوِتُمَرْہَتِ؟ اِتَرے لوکاسْتَتْکَتھاں شْرُتْوانَنَنْدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","تَدانِیں سَ تانُپَدِشْیَ کَتھِتَوانْ یے نَرا دِیرْگھَپَرِدھییانِ ہَٹّے وِپَنَو چَ ");
INSERT INTO sanurd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","لوکَکرِتَنَمَسْکارانْ بھَجَنَگرِہے پْرَدھاناسَنانِ بھوجَنَکالے پْرَدھانَسْتھانانِ چَ کانْکْشَنْتے؛ ");
INSERT INTO sanurd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","وِدھَواناں سَرْوَّسْوَں گْرَسِتْوا چھَلادْ دِیرْگھَکالَں پْرارْتھَیَنْتے تیبھْیَ اُپادھْیاییبھْیَح ساوَدھانا بھَوَتَ؛ تےدھِکَتَرانْ دَنْڈانْ پْراپْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","تَدَنَنْتَرَں لوکا بھانْڈاگارے مُدْرا یَتھا نِکْشِپَنْتِ بھانْڈاگارَسْیَ سَمُّکھے سَمُپَوِشْیَ یِیشُسْتَدَوَلُلوکَ؛ تَدانِیں بَہَوو دھَنِنَسْتَسْیَ مَدھْیے بَہُونِ دھَنانِ نِرَکْشِپَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","پَشْچادْ ایکا دَرِدْرا وِدھَوا سَماگَتْیَ دْوِپَنَمُولْیاں مُدْرَیکاں تَتْرَ نِرَکْشِپَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","تَدا یِیشُح شِشْیانْ آہُویَ کَتھِتَوانْ یُشْمانَہَں یَتھارْتھَں وَدامِ یے یے بھانْڈاگارےسْمِنَ دھَنانِ نِحکْشِپَنْتِ سْمَ تیبھْیَح سَرْوّیبھْیَ اِیَں وِدھَوا دَرِدْرادھِکَمْ نِحکْشِپَتِ سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","یَتَسْتے پْرَبھُوتَدھَنَسْیَ کِنْچِتْ نِرَکْشِپَنْ کِنْتُ دِینییَں سْوَدِنَیاپَنَیوگْیَں کِنْچِدَپِ نَ سْتھاپَیِتْوا سَرْوَّسْوَں نِرَکْشِپَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","اَنَنْتَرَں مَنْدِرادْ بَہِرْگَمَنَکالے تَسْیَ شِشْیانامیکَسْتَں وْیاہرِتَوانْ ہے گُرو پَشْیَتُ کِیدرِشاح پاشاناح کِیدرِکْ چَ نِچَیَنَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","تَدا یِیشُسْتَمْ اَوَدَتْ تْوَں کِمیتَدْ برِہَنِّچَیَنَں پَشْیَسِ؟ اَسْیَیکَپاشانوپِ دْوِتِییَپاشانوپَرِ نَ سْتھاسْیَتِ سَرْوّے دھَحکْشیپْسْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","اَتھَ یَسْمِنْ کالے جَیتُنْگِرَو مَنْدِرَسْیَ سَمُّکھے سَ سَمُپَوِشْٹَسْتَسْمِنْ کالے پِتَرو یاکُوبْ یوہَنْ آنْدْرِیَشْچَیتے تَں رَہَسِ پَپْرَچّھُح، ");
INSERT INTO sanurd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ایتا گھَٹَناح کَدا بھَوِشْیَنْتِ؟ تَتھَیتَتْسَرْوّاساں سِدّھیُپَکْرَمَسْیَ وا کِں چِہْنَں؟ تَدَسْمَبھْیَں کَتھَیَتُ بھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","تَتو یاشُسْتانْ وَکْتُماریبھے، کوپِ یَتھا یُشْمانْ نَ بھْرامَیَتِ تَتھاتْرَ یُویَں ساوَدھانا بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","یَتَح کھْرِیشْٹوہَمِتِ کَتھَیِتْوا مَمَ نامْنانیکے سَماگَتْیَ لوکاناں بھْرَمَں جَنَیِشْیَنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","کِنْتُ یُویَں رَنَسْیَ وارْتّاں رَناڈَمْبَرَنْچَ شْرُتْوا ما وْیاکُلا بھَوَتَ، گھَٹَنا ایتا اَوَشْیَمّاوِنْیَح؛ کِنْتْواپاتَتو نَ یُگانْتو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","دیشَسْیَ وِپَکْشَتَیا دیشو راجْیَسْیَ وِپَکْشَتَیا چَ راجْیَمُتّھاسْیَتِ، تَتھا سْتھانے سْتھانے بھُومِکَمْپو دُرْبھِکْشَں مَہاکْلیشاشْچَ سَمُپَسْتھاسْیَنْتِ، سَرْوَّ ایتے دُحکھَسْیارَمْبھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","کِنْتُ یُویَمْ آتْمارْتھے ساوَدھاناسْتِشْٹھَتَ، یَتو لوکا راجَسَبھایاں یُشْمانْ سَمَرْپَیِشْیَنْتِ، تَتھا بھَجَنَگرِہے پْرَہَرِشْیَنْتِ؛ یُویَں مَدَرْتھے دیشادھِپانْ بھُوپاںشْچَ پْرَتِ ساکْشْیَدانایَ تیشاں سَمُّکھے اُپَسْتھاپَیِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","شیشِیبھَوَناتْ پُورْوَّں سَرْوّانْ دیشِییانْ پْرَتِ سُسَںوادَح پْرَچارَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","کِنْتُ یَدا تے یُشْمانْ دھرِتْوا سَمَرْپَیِشْیَنْتِ تَدا یُویَں یَدْیَدْ اُتَّرَں داسْیَتھَ، تَدَگْرَ تَسْیَ وِویچَنَں ما کُرُتَ تَدَرْتھَں کِنْچِدَپِ ما چِنْتَیَتَ چَ، تَدانِیں یُشْماکَں مَنَحسُ یَدْیَدْ واکْیَمْ اُپَسْتھاپَیِشْیَتے تَدیوَ وَدِشْیَتھَ، یَتو یُویَں نَ تَدْوَکْتارَح کِنْتُ پَوِتْرَ آتْما تَسْیَ وَکْتا۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","تَدا بھْراتا بھْراتَرَں پِتا پُتْرَں گھاتَنارْتھَں پَرَہَسْتیشُ سَمَرْپَیِشْیَتے، تَتھا پَتْیانِ ماتاپِتْرو رْوِپَکْشَتَیا تَو گھاتَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","مَمَ نامَہیتوح سَرْوّیشاں سَوِدھے یُویَں جُگُپْسِتا بھَوِشْیَتھَ، کِنْتُ یَح کَشْچِتْ شیشَپَرْیَّنْتَں دھَیرْیَّمْ آلَمْبِشْیَتے سَایوَ پَرِتْراسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","دانِییلْبھَوِشْیَدْوادِنا پْروکْتَں سَرْوَّناشِ جُگُپْسِتَنْچَ وَسْتُ یَدا تْوَیوگْیَسْتھانے وِدْیَمانَں دْرَکْشَتھَ (یو جَنَح پَٹھَتِ سَ بُدھْیَتاں) تَدا یے یِہُودِییَدیشے تِشْٹھَنْتِ تے مَہِیدھْرَں پْرَتِ پَلایَنْتاں؛ ");
INSERT INTO sanurd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","تَتھا یو نَرو گرِہوپَرِ تِشْٹھَتِ سَ گرِہَمَدھْیَں ناوَروہَتُ، تَتھا کِمَپِ وَسْتُ گْرَہِیتُں مَدھْییگرِہَں نَ پْرَوِشَتُ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","تَتھا چَ یو نَرَح کْشیتْرے تِشْٹھَتِ سوپِ سْوَوَسْتْرَں گْرَہِیتُں پَراورِتْیَ نَ وْرَجَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","تَدانِیں گَرْبّھَوَتِیناں سْتَنْیَداتْرِینانْچَ یوشِتاں دُرْگَتِ رْبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","یُشْماکَں پَلایَنَں شِیتَکالے یَتھا نَ بھَوَتِ تَدَرْتھَں پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","یَتَسْتَدا یادرِشِی دُرْگھَٹَنا گھَٹِشْیَتے تادرِشِی دُرْگھَٹَنا اِیشْوَرَسرِشْٹیح پْرَتھَمَمارَبھْیادْیَ یاوَتْ کَداپِ نَ جاتا نَ جَنِشْیَتے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","اَپَرَنْچَ پَرَمیشْوَرو یَدِ تَسْیَ سَمَیَسْیَ سَںکْشیپَں نَ کَروتِ تَرْہِ کَسْیاپِ پْرانَبھرِتو رَکْشا بھَوِتُں نَ شَکْشْیَتِ، کِنْتُ یانْ جَنانْ مَنونِیتانْ اَکَروتْ تیشاں سْوَمَنونِیتاناں ہیتوح سَ تَدَنیہَسَں سَںکْشیپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","اَنْیَچَّ پَشْیَتَ کھْرِیشْٹوتْرَ سْتھانے وا تَتْرَ سْتھانے وِدْیَتے، تَسْمِنْکالے یَدِ کَشْچِدْ یُشْمانْ ایتادرِشَں واکْیَں وْیاہَرَتِ، تَرْہِ تَسْمِنْ واکْیے بھَیوَ وِشْوَسِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","یَتونیکے مِتھْیاکھْرِیشْٹا مِتھْیابھَوِشْیَدْوادِنَشْچَ سَمُپَسْتھایَ بَہُونِ چِہْنانْیَدْبھُتانِ کَرْمّانِ چَ دَرْشَیِشْیَنْتِ؛ تَتھا یَدِ سَمْبھَوَتِ تَرْہِ مَنونِیتَلوکانامَپِ مِتھْیامَتِں جَنَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","پَشْیَتَ گھَٹَناتَح پُورْوَّں سَرْوَّکارْیَّسْیَ وارْتّاں یُشْمَبھْیَمَدامْ، یُویَں ساوَدھاناسْتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","اَپَرَنْچَ تَسْیَ کْلیشَکالَسْیاوْیَوَہِتے پَرَکالے بھاسْکَرَح سانْدھَکارو بھَوِشْیَتِ تَتھَیوَ چَنْدْرَشْچَنْدْرِکاں نَ داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","نَبھَحسْتھانِ نَکْشَتْرانِ پَتِشْیَنْتِ، وْیومَمَنْڈَلَسْتھا گْرَہاشْچَ وِچَلِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","تَدانِیں مَہاپَراکْرَمینَ مَہَیشْوَرْیّینَ چَ میگھَمارُہْیَ سَمایانْتَں مانَوَسُتَں مانَواح سَمِیکْشِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","اَنْیَچَّ سَ نِجَدُوتانْ پْرَہِتْیَ نَبھوبھُومْیوح سِیماں یاوَدْ جَگَتَشْچَتُرْدِگْبھْیَح سْوَمَنونِیتَلوکانْ سَںگْرَہِیشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","اُڈُمْبَرَتَرو رْدرِشْٹانْتَں شِکْشَدھْوَں یَدوڈُمْبَرَسْیَ تَرو رْنَوِیناح شاکھا جایَنْتے پَلَّوادِینِ چَ رْنِگَچّھَنْتِ، تَدا نِداگھَکالَح سَوِدھو بھَوَتِیتِ یُویَں جْناتُں شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","تَدْوَدْ ایتا گھَٹَنا درِشْٹْوا سَ کالو دْوارْیُّپَسْتھِتَ اِتِ جانِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","یُشْمانَہَں یَتھارْتھَں وَدامِ، آدھُنِکَلوکاناں گَمَناتْ پُورْوَّں تانِ سَرْوّانِ گھَٹِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","دْیاواپرِتھِوْیو رْوِچَلِتَیوح سَتْیو رْمَدِییا وانِی نَ وِچَلِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","اَپَرَنْچَ سْوَرْگَسْتھَدُوتَگَنو وا پُتْرو وا تاتادَنْیَح کوپِ تَں دِوَسَں تَں دَنْڈَں وا نَ جْناپَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","اَتَح سَ سَمَیَح کَدا بھَوِشْیَتِ، ایتَجّنانابھاوادْ یُویَں ساوَدھاناسْتِشْٹھَتَ، سَتَرْکاشْچَ بھُوتْوا پْرارْتھَیَدھْوَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","یَدْوَتْ کَشْچِتْ پُمانْ سْوَنِویشَنادْ دُورَدیشَں پْرَتِ یاتْراکَرَنَکالے داسیشُ سْوَکارْیَّسْیَ بھارَمَرْپَیِتْوا سَرْوّانْ سْوے سْوے کَرْمَّنِ نِیوجَیَتِ؛ اَپَرَں دَووارِکَں جاگَرِتُں سَمادِشْیَ یاتِ، تَدْوَنْ نَرَپُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","گرِہَپَتِح سایَںکالے نِشِیتھے وا ترِتِییَیامے وا پْراتَحکالے وا کَداگَمِشْیَتِ تَدْ یُویَں نَ جانِیتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","سَ ہَٹھاداگَتْیَ یَتھا یُشْمانْ نِدْرِتانْ نَ پَشْیَتِ، تَدَرْتھَں جاگَرِتاسْتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","یُشْمانَہَں یَدْ وَدامِ تَدیوَ سَرْوّانْ وَدامِ، جاگَرِتاسْتِشْٹھَتیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","تَدا نِسْتاروتْسَوَکِنْوَہِینَپُوپوتْسَوَیورارَمْبھَسْیَ دِنَدْوَیے وَشِشْٹے پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ کیناپِ چھَلینَ یِیشُں دھَرْتّاں ہَنْتُنْچَ مرِگَیانْچَکْرِرے؛ ");
INSERT INTO sanurd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","کِنْتُ لوکاناں کَلَہَبھَیادُوچِرے، نَچوتْسَوَکالَ اُچِتَمیتَدِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","اَنَنْتَرَں بَیتھَنِیاپُुرے شِمونَکُشْٹھِنو گرِہے یوشَو بھوتْکُمُپَوِشْٹے سَتِ کاچِدْ یوشِتْ پانْڈَرَپاشانَسْیَ سَمْپُٹَکینَ مَہارْگھْیوتَّمَتَیلَمْ آنِییَ سَمْپُٹَکَں بھَںکْتْوا تَسْیوتَّمانْگے تَیلَدھاراں پاتَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","تَسْماتْ کیچِتْ سْوانْتے کُپْیَنْتَح کَتھِتَوَںنْتَح کُتویَں تَیلاپَوْیَیَح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","یَدْییتَتْ تَیلَ وْیَکْریشْیَتَ تَرْہِ مُدْراپادَشَتَتْرَیادَپْیَدھِکَں تَسْیَ پْراپْتَمُولْیَں دَرِدْرَلوکیبھْیو داتُمَشَکْشْیَتَ، کَتھامیتاں کَتھَیِتْوا تَیا یوشِتا ساکَں واچایُہْیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","کِنْتُ یِیشُرُواچَ، کُتَ ایتَسْیَے کرِچّھرَں دَداسِ؟ مَہْیَمِیَں کَرْمّوتَّمَں کرِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","دَرِدْراح سَرْوَّدا یُشْمابھِح سَہَ تِشْٹھَنْتِ، تَسْمادْ یُویَں یَدیچّھَتھَ تَدَیوَ تانُپَکَرْتّاں شَکْنُتھَ، کِنْتْوَہَں یُبھابھِح سَہَ نِرَنْتَرَں نَ تِشْٹھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","اَسْیا یَتھاسادھْیَں تَتھَیواکَرودِیَں، شْمَشانَیاپَناتْ پُورْوَّں سَمیتْیَ مَدْوَپُشِ تَیلَمْ اَمَرْدَّیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","اَہَں یُشْمَبھْیَں یَتھارْتھَں کَتھَیامِ، جَگَتاں مَدھْیے یَتْرَ یَتْرَ سُسَںوادویَں پْرَچارَیِشْیَتے تَتْرَ تَتْرَ یوشِتَ ایتَسْیاح سْمَرَنارْتھَں تَتْکرِتَکَرْمَّیتَتْ پْرَچارَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","تَتَح پَرَں دْوادَشاناں شِشْیانامیکَ اِیشْکَرِیوتِییَیِہُوداکھْیو یِیشُں پَرَکَریشُ سَمَرْپَیِتُں پْرَدھانَیاجَکاناں سَمِیپَمِیایَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","تے تَسْیَ واکْیَں سَماکَرْنْیَ سَنْتُشْٹاح سَنْتَسْتَسْمَے مُدْرا داتُں پْرَتْیَجانَتَ؛ تَسْماتْ سَ تَں تیشاں کَریشُ سَمَرْپَنایوپایَں مرِگَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","اَنَنْتَرَں کِنْوَشُونْیَپُوپوتْسَوَسْیَ پْرَتھَمےہَنِ نِسْتاروتْمَوارْتھَں میشَمارَناسَمَیے شِشْیاسْتَں پَپْرَچّھَح کُتْرَ گَتْوا وَیَں نِسْتاروتْسَوَسْیَ بھوجْیَماسادَیِشْیامَح؟ کِمِچّھَتِ بھَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","تَدانِیں سَ تیشاں دْوَیَں پْریرَیَنْ بَبھاشے یُوَیوح پُرَمَدھْیَں گَتَیوح سَتو رْیو جَنَح سَجَلَکُمْبھَں وَہَنْ یُواں ساکْشاتْ کَرِشْیَتِ تَسْیَیوَ پَشْچادْ یاتَں؛ ");
INSERT INTO sanurd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","سَ یَتْ سَدَنَں پْرَویکْشْیَتِ تَدْبھَوَنَپَتِں وَدَتَں، گُرُراہَ یَتْرَ سَشِشْیوہَں نِسْتاروتْسَوِییَں بھوجَنَں کَرِشْیامِ، سا بھوجَنَشالا کُتْراسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","تَتَح سَ پَرِشْکرِتاں سُسَجِّتاں برِہَتِیچَنْچَ یاں شالاں دَرْشَیِشْیَتِ تَسْیامَسْمَدَرْتھَں بھوجْیَدْرَوْیانْیاسادَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","تَتَح شِشْیَو پْرَسْتھایَ پُرَں پْرَوِشْیَ سَ یَتھوکْتَوانْ تَتھَیوَ پْراپْیَ نِسْتاروتْسَوَسْیَ بھوجْیَدْرَوْیانِ سَماسادَییتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","اَنَنْتَرَں یِیشُح سایَںکالے دْوادَشَبھِح شِشْیَیح سارْدّھَں جَگامَ؛ ");
INSERT INTO sanurd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","سَرْوّیشُ بھوجَنایَ پْروپَوِشْٹیشُ سَ تانُدِتَوانْ یُشْمانَہَں یَتھارْتھَں وْیاہَرامِ، اَتْرَ یُشْماکَمیکو جَنو یو مَیا سَہَ بھُںکْتے ماں پَرَکیریشُ سَمَرْپَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","تَدانِیں تے دُحکھِتاح سَنْتَ ایکَیکَشَسْتَں پْرَشْٹُمارَبْدھَوَنْتَح سَ کِمَہَں؟ پَشْچادْ اَنْیَ ایکوبھِدَدھے سَ کِمَہَں؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","تَتَح سَ پْرَتْیَوَدَدْ ایتیشاں دْوادَشاناں یو جَنو مَیا سَمَں بھوجَناپاتْرے پانِں مَجَّیِشْیَتِ سَ ایوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","مَنُجَتَنَیَمَدھِ یادرِشَں لِکھِتَماسْتے تَدَنُرُوپا گَتِسْتَسْیَ بھَوِشْیَتِ، کِنْتُ یو جَنو مانَوَسُتَں سَمَرْپَیِشْیَتے ہَنْتَ تَسْیَ جَنْمابھاوے سَتِ بھَدْرَمَبھَوِشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","اَپَرَنْچَ تیشاں بھوجَنَسَمَیے یِیشُح پُوپَں گرِہِیتْویشْوَرَگُنانْ اَنُکِیرْتْیَ بھَنْکْتْوا تیبھْیو دَتّوا بَبھاشے، ایتَدْ گرِہِیتْوا بھُنْجِیدھْوَمْ ایتَنْمَمَ وِگْرَہَرُوپَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","اَنَنْتَرَں سَ کَںسَں گرِہِیتْویشْوَرَسْیَ گُنانْ کِیرْتَّیِتْوا تیبھْیو دَدَو، تَتَسْتے سَرْوّے پَپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","اَپَرَں سَ تانَوادِیدْ بَہُوناں نِمِتَّں پاتِتَں مَمَ نَوِینَنِیَمَرُوپَں شونِتَمیتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","یُشْمانَہَں یَتھارْتھَں وَدامِ، اِیشْوَرَسْیَ راجْیے یاوَتْ سَدْیوجاتَں دْراکْشارَسَں نَ پاسْیامِ،تاوَدَہَں دْراکْشاپھَلَرَسَں پُنَ رْنَ پاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","تَدَنَنْتَرَں تے گِیتَمیکَں سَںگِییَ بَہِ رْجَیتُنَں شِکھَرِنَں یَیُح ");
INSERT INTO sanurd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","اَتھَ یِیشُسْتانُواچَ نِشایامَسْیاں مَیِ یُشْماکَں سَرْوّیشاں پْرَتْیُوہو بھَوِشْیَتِ یَتو لِکھِتَماسْتے یَتھا، میشاناں رَکْشَکَنْچاہَں پْرَہَرِشْیامِ وَے تَتَح۔ میشاناں نِوَہو نُونَں پْرَوِکِیرْنو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","کَنْتُ مَدُتّھانے جاتے یُشْماکَمَگْرےہَں گالِیلَں وْرَجِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","تَدا پِتَرَح پْرَتِبَبھاشے، یَدْیَپِ سَرْوّیشاں پْرَتْیُوہو بھَوَتِ تَتھاپِ مَمَ نَیوَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","تَتو یِیشُرُکْتاوانْ اَہَں تُبھْیَں تَتھْیَں کَتھَیامِ، کْشَنادایامَدْیَ کُکُّٹَسْیَ دْوِتِییَوارَرَوَناتْ پُورْوَّں تْوَں وارَتْرَیَں مامَپَہْنوشْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","کِنْتُ سَ گاڈھَں وْیاہَرَدْ یَدْیَپِ تْوَیا سارْدّھَں مَمَ پْرانو یاتِ تَتھاپِ کَتھَمَپِ تْواں ناپَہْنوشْیے؛ سَرْوّےپِیتَرے تَتھَیوَ بَبھاشِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","اَپَرَنْچَ تیشُ گیتْشِمانِینامَکَں سْتھانَ گَتیشُ سَ شِشْیانْ جَگادَ، یاوَدَہَں پْرارْتھَیے تاوَدَتْرَ سْتھانے یُویَں سَمُپَوِشَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","اَتھَ سَ پِتَرَں یاکُوبَں یوہَنَنْچَ گرِہِیتْوا وَوْراجَ؛ اَتْیَنْتَں تْراسِتو وْیاکُلِتَشْچَ تیبھْیَح کَتھَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","نِدھَنَکالَوَتْ پْرانو مےتِیوَ دَحکھَمیتِ، یُویَں جاگْرَتوتْرَ سْتھانے تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","تَتَح سَ کِنْچِدُّورَں گَتْوا بھُوماوَدھومُکھَح پَتِتْوا پْرارْتھِتَوانیتَتْ، یَدِ بھَوِتُں شَکْیَں تَرْہِ دُحکھَسَمَیویَں مَتّو دُورِیبھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","اَپَرَمُدِتَوانْ ہے پِتَ رْہے پِتَح سَرْوّیں تْوَیا سادھْیَں، تَتو ہیتورِمَں کَںسَں مَتّو دُورِیکُرُ، کِنْتُ تَنْ مَمیچّھاتو نَ تَویچّھاتو بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","تَتَح پَرَں سَ ایتْیَ تانْ نِدْرِتانْ نِرِیکْشْیَ پِتَرَں پْروواچَ، شِمونْ تْوَں کِں نِدْراسِ؟ گھَٹِکامیکامْ اَپِ جاگَرِتُں نَ شَکْنوشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","پَرِیکْشایاں یَتھا نَ پَتَتھَ تَدَرْتھَں سَچیتَناح سَنْتَح پْرارْتھَیَدھْوَں؛ مَنَ اُدْیُکْتَمِتِ سَتْیَں کِنْتُ وَپُرَشَکْتِکَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","اَتھَ سَ پُنَرْوْرَجِتْوا پُورْوَّوَتْ پْرارْتھَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","پَراورِتْیاگَتْیَ پُنَرَپِ تانْ نِدْرِتانْ دَدَرْشَ تَدا تیشاں لوچَنانِ نِدْرَیا پُورْنانِ، تَسْماتَّسْمَے کا کَتھا کَتھَیِتَوْیا تَ ایتَدْ بودّھُں نَ شیکُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","تَتَحپَرَں ترِتِییَوارَں آگَتْیَ تیبھْیو کَتھَیَدْ اِدانِیمَپِ شَیِتْوا وِشْرامْیَتھَ؟ یَتھیشْٹَں جاتَں، سَمَیَشْچوپَسْتھِتَح پَشْیَتَ مانَوَتَنَیَح پاپِلوکاناں پانِشُ سَمَرْپْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","اُتِّشْٹھَتَ، وَیَں وْرَجامو یو جَنو ماں پَرَپانِشُ سَمَرْپَیِشْیَتے پَشْیَتَ سَ سَمِیپَمایاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","اِماں کَتھاں کَتھَیَتِ سَ، ایتَرْہِدْوادَشانامیکو یِہُودا ناما شِشْیَح پْرَدھانَیاجَکانامْ اُپادھْیایاناں پْراچِینَلوکانانْچَ سَنِّدھیح کھَنْگَلَگُڈَدھارِنو بَہُلوکانْ گرِہِیتْوا تَسْیَ سَمِیپَ اُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","اَپَرَنْچاسَو پَرَپانِشُ سَمَرْپَیِتا پُورْوَّمِتِ سَنْکیتَں کرِتَوانْ یَمَہَں چُمْبِشْیامِ سَ ایواسَو تَمیوَ دھرِتْوا ساوَدھانَں نَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","اَتو ہیتوح سَ آگَتْیَیوَ یوشوح سَوِدھَں گَتْوا ہے گُرو ہے گُرو، اِتْیُکْتْوا تَں چُچُمْبَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","تَدا تے تَدُپَرِ پانِینَرْپَیِتْوا تَں دَدھْنُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","تَتَسْتَسْیَ پارْشْوَسْتھاناں لوکانامیکَح کھَنْگَں نِشْکوشَیَنْ مَہایاجَکَسْیَ داسَمیکَں پْرَہرِتْیَ تَسْیَ کَرْنَں چِچّھیدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","پَشْچادْ یِیشُسْتانْ وْیاجَہارَ کھَنْگانْ لَگُڈاںشْچَ گرِہِیتْوا ماں کِں چَورَں دھَرْتّاں سَمایاتاح؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","مَدھْییمَنْدِرَں سَمُپَدِشَنْ پْرَتْیَہَں یُشْمابھِح سَہَ سْتھِتَوانَتَہَں، تَسْمِنْ کالے یُویَں ماں نادِیدھَرَتَ، کِنْتْوَنینَ شاسْتْرِییَں وَچَنَں سیدھَنِییَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","تَدا سَرْوّے شِشْیاسْتَں پَرِتْیَجْیَ پَلایانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","اَتھَیکو یُوا مانَوو نَگْنَکایے وَسْتْرَمیکَں نِدھایَ تَسْیَ پَشْچادْ وْرَجَنْ یُوَلوکَے رْدھرِتو ");
INSERT INTO sanurd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","وَسْتْرَں وِہایَ نَگْنَح پَلایانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","اَپَرَنْچَ یَسْمِنْ سْتھانے پْرَدھانَیاجَکا اُپادھْیایاح پْراچِینَلوکاشْچَ مَہایاجَکینَ سَہَ سَدَسِ سْتھِتاسْتَسْمِنْ سْتھانے مَہایاجَکَسْیَ سَمِیپَں یِیشُں نِنْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","پِتَرو دُورے تَتْپَشْچادْ اِتْوا مَہایاجَکَسْیاٹّالِکاں پْرَوِشْیَ کِنْکَرَیح سَہوپَوِشْیَ وَہْنِتاپَں جَگْراہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","تَدانِیں پْرَدھانَیاجَکا مَنْتْرِنَشْچَ یِیشُں گھاتَیِتُں تَتْپْراتِکُولْیینَ ساکْشِنو مرِگَیانْچَکْرِرے، کِنْتُ نَ پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","اَنیکَیسْتَدْوِرُدّھَں مرِشاساکْشْیے دَتّیپِ تیشاں واکْیانِ نَ سَمَگَچّھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","سَرْوَّشیشے کِیَنْتَ اُتّھایَ تَسْیَ پْراتِکُولْیینَ مرِشاساکْشْیَں دَتّوا کَتھَیاماسُح، ");
INSERT INTO sanurd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","اِدَں کَرَکرِتَمَنْدِرَں وِناشْیَ دِنَتْرَیَمَدھْیے پُنَرَپَرَمْ اَکَرَکرِتَں مَنْدِرَں نِرْمّاسْیامِ، اِتِ واکْیَمْ اَسْیَ مُکھاتْ شْرُتَمَسْمابھِرِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","کِنْتُ تَتْراپِ تیشاں ساکْشْیَکَتھا نَ سَنْگاتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","اَتھَ مَہایاجَکو مَدھْییسَبھَمْ اُتّھایَ یِیشُں وْیاجَہارَ، ایتے جَناسْتْوَیِ یَتْ ساکْشْیَمَدُح تْوَمیتَسْیَ کِمَپْیُتَّرَں کِں نَ داسْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","کِنْتُ سَ کِمَپْیُتَّرَں نَ دَتْوا مَونِیبھُویَ تَسْیَو؛ تَتو مَہایاجَکَح پُنَرَپِ تَں پرِشْٹاوانْ تْوَں سَچِّدانَنْدَسْیَ تَنَیو بھِشِکْتَسْتْرَتا؟ ");
INSERT INTO sanurd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","تَدا یِیشُسْتَں پْروواچَ بھَوامْیَہَمْ یُویَنْچَ سَرْوَّشَکْتِمَتو دَکْشِینَپارْشْوے سَمُپَوِشَنْتَں میگھَ مارُہْیَ سَمایانْتَنْچَ مَنُشْیَپُتْرَں سَنْدْرَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","تَدا مَہایاجَکَح سْوَں وَمَنَں چھِتْوا وْیاوَہَرَتْ ");
INSERT INTO sanurd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","کِمَسْماکَں ساکْشِبھِح پْرَیوجَنَمْ؟ اِیشْوَرَنِنْداواکْیَں یُشْمابھِرَشْراوِ کِں وِچارَیَتھَ؟ تَدانِیں سَرْوّے جَگَدُرَیَں نِدھَنَدَنْڈَمَرْہَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","تَتَح کَشْچِتْ کَشْچِتْ تَدْوَپُشِ نِشْٹھِیوَں نِچِکْشیپَ تَتھا تَنْمُکھَماچّھادْیَ چَپیٹینَ ہَتْوا گَدِتَوانْ گَنَیِتْوا وَدَ، اَنُچَراشْچَ چَپیٹَیسْتَماجَگھْنُح ");
INSERT INTO sanurd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","تَتَح پَرَں پِتَرےٹّالِکادھَحکوشْٹھے تِشْٹھَتِ مَہایاجَکَسْیَیکا داسِی سَمیتْیَ ");
INSERT INTO sanurd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","تَں وِہْنِتاپَں گرِہْلَنْتَں وِلوکْیَ تَں سُنِرِیکْشْیَ بَبھاشے تْوَمَپِ ناسَرَتِییَیِیشوح سَنْگِنامْ ایکو جَنَ آسِیح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","کِنْتُ سوپَہْنُتْیَ جَگادَ تَمَہَں نَ وَدْمِ تْوَں یَتْ کَتھَیَمِ تَدَپْیَہَں نَ بُدّھیے۔ تَدانِیں پِتَرے چَتْوَرَں گَتَوَتِ کُेکُّٹو رُراوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","اَتھانْیا داسِی پِتَرَں درِشْٹْوا سَمِیپَسْتھانْ جَنانْ جَگادَ اَیَں تیشامیکو جَنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","تَتَح سَ دْوِتِییَوارَمْ اَپَہْنُتَوانْ پَشْچاتْ تَتْرَسْتھا لوکاح پِتَرَں پْروچُسْتْوَمَوَشْیَں تیشامیکو جَنَح یَتَسْتْوَں گالِیلِییو نَرَ اِتِ تَووچّارَنَں پْرَکاشَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","تَدا سَ شَپَتھابھِشاپَو کرِتْوا پْروواچَ یُویَں کَتھاں کَتھَیَتھَ تَں نَرَں نَ جانےہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","تَدانِیں دْوِتِییَوارَں کُکُّٹو راوِیتْ۔ کُکُّٹَسْیَ دْوِتِییَرَواتْ پُورْوَّں تْوَں ماں وارَتْرَیَمْ اَپَہْنوشْیَسِ، اِتِ یَدْواکْیَں یِیشُنا سَمُدِتَں تَتْ تَدا سَںسْمرِتْیَ پِتَرو رودِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","اَتھَ پْرَبھاتے سَتِ پْرَدھانَیاجَکاح پْرانْچَ اُپادھْیایاح سَرْوّے مَنْتْرِنَشْچَ سَبھاں کرِتْوا یِیشُृں بَنْدھَیِتْوَ پِیلاتاکھْیَسْیَ دیشادھِپَتیح سَوِدھَں نِیتْوا سَمَرْپَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","تَدا پِیلاتَسْتَں پرِشْٹَوانْ تْوَں کِں یِہُودِییَلوکاناں راجا؟ تَتَح سَ پْرَتْیُکْتَوانْ سَتْیَں وَدَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","اَپَرَں پْرَدھانَیاجَکاسْتَسْیَ بَہُشُ واکْییشُ دوشَماروپَیانْچَکْرُح کِنْتُ سَ کِمَپِ نَ پْرَتْیُواچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","تَدانِیں پِیلاتَسْتَں پُنَح پَپْرَچّھَ تْوَں کِں نوتَّرَیَسِ؟ پَشْیَیتے تْوَدْوِرُدّھَں کَتِشُ سادھْییشُ ساکْشَں دَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","کَنْتُ یِیشُسْتَداپِ نوتَّرَں دَدَو تَتَح پِیلاتَ آشْچَرْیَّں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","اَپَرَنْچَ کارابَدّھے کَسْتِںشْچِتْ جَنے تَنْمَہوتْسَوَکالے لوکَے رْیاچِتے دیشادھِپَتِسْتَں موچَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","یے چَ پُورْوَّمُپَپْلَوَمَکارْشُرُپَپْلَوے وَدھَمَپِ کرِتَوَنْتَسْتیشاں مَدھْیے تَدانوں بَرَبّانامَکَ ایکو بَدّھَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","اَتو ہیتوح پُورْوّاپَرِییاں رِیتِکَتھاں کَتھَیِتْوا لوکا اُچَّیرُوَنْتَح پِیلاتَسْیَ سَمَکْشَں نِویدَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","تَدا پِیلاتَسْتاناچَکھْیَو تَرْہِ کِں یِہُودِییاناں راجانَں موچَیِشْیامِ؟ یُشْمابھِح کِمِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","یَتَح پْرَدھانَیاجَکا اِیرْشْیاتَ ایوَ یِیشُں سَمارْپَیَنِّتِ سَ وِویدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","کِنْتُ یَتھا بَرَبّاں موچَیَتِ تَتھا پْرارْتھَیِتُں پْرَدھانَیاجَکا لوکانْ پْرَوَرْتَّیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","اَتھَ پِیلاتَح پُنَح پرِشْٹَوانْ تَرْہِ یَں یِہُودِییاناں راجیتِ وَدَتھَ تَسْیَ کِں کَرِشْیامِ یُشْمابھِح کِمِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","تَدا تے پُنَرَپِ پْروچَّیح پْروچُسْتَں کْرُشے ویدھَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","تَسْماتْ پِیلاتَح کَتھِتَوانْ کُتَح؟ سَ کِں کُکَرْمَّ کرِتَوانْ؟ کِنْتُ تے پُنَشْچَ رُوَنْتو وْیاجَہْرُسْتَں کْرُشے ویدھَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","تَدا پِیلاتَح سَرْوّالّوکانْ توشَیِتُمِچّھَنْ بَرَبّاں موچَیِتْوا یِیشُں کَشابھِح پْرَہرِتْیَ کْرُشے ویدّھُں تَں سَمَرْپَیامْبَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","اَنَنْتَرَں سَینْیَگَنوٹّالِکامْ اَرْتھادْ اَدھِپَتے رْگرِہَں یِیشُں نِیتْوا سینانِوَہَں سَماہُیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","پَشْچاتْ تے تَں دھُومَلَوَرْنَوَسْتْرَں پَرِدھاپْیَ کَنْٹَکَمُکُٹَں رَچَیِتْوا شِرَسِ سَماروپْیَ ");
INSERT INTO sanurd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ہے یِہُودِییاناں راجَنْ نَمَسْکارَ اِتْیُکْتْوا تَں نَمَسْکَرْتّاماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","تَسْیوتَّمانْگے ویتْراگھاتَں چَکْرُسْتَدْگاتْرے نِشْٹھِیوَنْچَ نِچِکْشِپُح، تَتھا تَسْیَ سَمُّکھے جانُپاتَں پْرَنومُح ");
INSERT INTO sanurd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","اِتّھَمُپَہَسْیَ دھُومْرَوَرْنَوَسْتْرَمْ اُتّارْیَّ تَسْیَ وَسْتْرَں تَں پَرْیَّدھاپَیَنْ کْرُشے ویدّھُں بَہِرْنِنْیُشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","تَتَح پَرَں سیکَنْدَرَسْیَ رُپھَسْیَ چَ پِتا شِمونّاما کُرِینِییَلوکَ ایکَح کُتَشْچِدْ گْرامادیتْیَ پَتھِ یاتِ تَں تے یِیشوح کْرُشَں ووڈھُں بَلادْ دَدھْنُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","اَتھَ گُلْگَلْتا اَرْتھاتْ شِرَحکَپالَنامَکَں سْتھانَں یِیشُمانِییَ ");
INSERT INTO sanurd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","تے گَنْدھَرَسَمِشْرِتَں دْراکْشارَسَں پاتُں تَسْمَے دَدُح کِنْتُ سَ نَ جَگْراہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","تَسْمِنْ کْرُشے وِدّھے سَتِ تیشامیکَیکَشَح کِں پْراپْسْیَتِیتِ نِرْنَیایَ ");
INSERT INTO sanurd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","تَسْیَ پَرِدھییاناں وِبھاگارْتھَں گُٹِکاپاتَں چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","اَپَرَمْ ایشَ یِہُودِییاناں راجیتِ لِکھِتَں دوشَپَتْرَں تَسْیَ شِرَاُورْدْوَّمْ آروپَیانْچَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","تَسْیَ وامَدَکْشِنَیو رْدْوَو چَورَو کْرُشَیو رْوِوِدھاتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","تینَیوَ \"اَپَرادھِجَنَیح سارْدّھَں سَ گَنِتو بھَوِشْیَتِ،\" اِتِ شاسْتْروکْتَں وَچَنَں سِدّھَمَبھُوتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","اَنَنْتَرَں مارْگے یے یے لوکا گَمَناگَمَنے چَکْرُسْتے سَرْوَّ ایوَ شِراںسْیانْدولْیَ نِنْدَنْتو جَگَدُح، رے مَنْدِرَناشَکَ رے دِنَتْرَیَمَدھْیے تَنِّرْمّایَکَ، ");
INSERT INTO sanurd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","اَدھُناتْمانَمْ اَوِتْوا کْرُشادَوَروہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","کِنْچَ پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ تَدْوَتْ تِرَسْکرِتْیَ پَرَسْپَرَں چَچَکْشِرے ایشَ پَراناوَتْ کِنْتُ سْوَمَوِتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","یَدِیسْراییلو راجابھِشِکْتَسْتْراتا بھَوَتِ تَرْہْیَدھُنَینَ کْرُشادَوَروہَتُ وَیَں تَدْ درِشْٹْوا وِشْوَسِشْیامَح؛ کِنْچَ یَو لوکَو تینَ سارْدّھَں کْرُشے وِدھْییتاں تاوَپِ تَں نِرْبھَرْتْسَیاماسَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","اَتھَ دْوِتِییَیاماتْ ترِتِییَیامَں یاوَتْ سَرْوّو دیشَح سانْدھَکاروبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","تَتَسْترِتِییَپْرَہَرے یِیشُرُچَّیرَوَدَتْ ایلِی ایلِی لاما شِوَکْتَنِی اَرْتھادْ \"ہے مَدِیشَ مَدِیشَ تْوَں پَرْیَّتْیاکْشِیح کُتو ہِ ماں؟\" ");
INSERT INTO sanurd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","تَدا سَمِیپَسْتھَلوکاناں کیچِتْ تَدْواکْیَں نِشَمْیاچَکھْیُح پَشْیَیشَ ایلِیَمْ آہُویَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","تَتَ ایکو جَنو دھاوِتْواگَتْیَ سْپَنْجے مْلَرَسَں پُورَیِتْوا تَں نَڈاگْرے نِدھایَ پاتُں تَسْمَے دَتّواوَدَتْ تِشْٹھَ ایلِیَ اینَمَوَروہَیِتُمْ ایتِ نَ ویتِ پَشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","اَتھَ یِیشُرُچَّیح سَماہُویَ پْرانانْ جَہَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","تَدا مَنْدِرَسْیَ جَوَنِکورْدْوّادَدھَحرْیَّنْتا وِدِیرْنا دْوِکھَنْڈابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","کِنْچَ اِتّھَمُچَّیراہُویَ پْرانانْ تْیَجَنْتَں تَں درِشْدْوا تَدْرَکْشَنایَ نِیُکْتو یَح سیناپَتِراسِیتْ سووَدَتْ نَرویَمْ اِیشْوَرَپُتْرَ اِتِ سَتْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","تَدانِیں مَگْدَلِینِی مَرِسَمْ کَنِشْٹھَیاکُوبو یوسیشْچَ ماتانْیَمَرِیَمْ شالومِی چَ یاح سْتْرِیو ");
INSERT INTO sanurd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","گالِیلْپْرَدیشے یِیشُں سیوِتْوا تَدَنُگامِنْیو جاتا اِماسْتَدَنْیاشْچَ یا اَنیکا نارْیو یِیشُنا سارْدّھَں یِرُوشالَمَمایاتاسْتاشْچَ دُوراتْ تانِ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","اَتھاسادَنَدِنَسْیارْتھادْ وِشْرامَواراتْ پُورْوَّدِنَسْیَ سایَںکالَ آگَتَ ");
INSERT INTO sanurd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","اِیشْوَرَراجْیاپیکْشْیَرِمَتھِییَیُوشَپھَناما مانْیَمَنْتْرِی سَمیتْیَ پِیلاتَسَوِدھَں نِرْبھَیو گَتْوا یِیشورْدیہَں یَیاچے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","کِنْتُ سَ اِدانِیں مرِتَح پِیلاتَ اِتْیَسَمْبھَوَں مَتْوا شَتَسیناپَتِماہُویَ سَ کَدا مرِتَ اِتِ پَپْرَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","شَتَسیمَناپَتِمُکھاتْ تَجّناتْوا یُوشَپھے یِیشورْدیہَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","پَشْچاتْ سَ سُوکْشْمَں واسَح کْرِیتْوا یِیشوح کایَمَوَروہْیَ تینَ واسَسا ویشْٹایِتْوا گِرَو کھاتَشْمَشانے سْتھاپِتَوانْ پاشانَں لوٹھَیِتْوا دْوارِ نِدَدھے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","کِنْتُ یَتْرَ سوسْتھاپْیَتَ تَتَ مَگْدَلِینِی مَرِیَمْ یوسِماترِمَرِیَمْ چَ دَدرِشَترِح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","اَتھَ وِشْرامَوارے گَتے مَگْدَلِینِی مَرِیَمْ یاکُوبَماتا مَرِیَمْ شالومِی چیماسْتَں مَرْدَّیِتُں سُگَنْدھِدْرَوْیانِ کْرِیتْوا ");
INSERT INTO sanurd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","سَپْتاہَپْرَتھَمَدِنےتِپْرَتْیُوشے سُورْیّودَیَکالے شْمَشانَمُپَگَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","کِنْتُ شْمَشانَدْوارَپاشانوتِبرِہَنْ تَں کوپَسارَیِشْیَتِیتِ تاح پَرَسْپَرَں گَدَنْتِ! ");
INSERT INTO sanurd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ایتَرْہِ نِرِیکْشْیَ پاشانو دْوارو پَسارِتَ اِتِ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","پَشْچاتّاح شْمَشانَں پْرَوِشْیَ شُکْلَوَرْنَدِیرْگھَپَرِچّھَداورِتَمیکَں یُوانَں شْمَشانَدَکْشِنَپارْشْوَ اُپَوِشْٹَں درِشْٹْوا چَمَچَّکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","سووَدَتْ، مابھَیشْٹَ یُویَں کْرُشے ہَتَں ناسَرَتِییَیِیشُں گَویشَیَتھَ سوتْرَ ناسْتِ شْمَشانادُدَسْتھاتْ؛ تَے رْیَتْرَ سَ سْتھاپِتَح سْتھانَں تَدِدَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","کِنْتُ تینَ یَتھوکْتَں تَتھا یُشْماکَمَگْرے گالِیلَں یاسْیَتے تَتْرَ سَ یُشْمانْ ساکْشاتْ کَرِشْیَتے یُویَں گَتْوا تَسْیَ شِشْییبھْیَح پِتَرایَ چَ وارْتّامِماں کَتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","تاح کَمْپِتا وِسْتِتاشْچَ تُورْنَں شْمَشانادْ بَہِرْگَتْوا پَلایَنْتَ بھَیاتْ کَمَپِ کِمَپِ ناوَدَںشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","اَپَرَں یِیشُح سَپْتاہَپْرَتھَمَدِنے پْرَتْیُوشے شْمَشانادُتّھایَ یَسْیاح سَپْتَبھُوتاسْتْیاجِتاسْتَسْیَے مَگْدَلِینِیمَرِیَمے پْرَتھَمَں دَرْشَنَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","تَتَح سا گَتْوا شوکَرودَنَکرِدْبھْیونُگَتَلوکیبھْیَسْتاں وارْتّاں کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","کِنْتُ یِیشُح پُنَرْجِیوَنْ تَسْیَے دَرْشَنَں دَتَّوانِتِ شْرُتْوا تے نَ پْرَتْیَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","پَشْچاتْ تیشاں دْوایو رْگْرامَیانَکالے یِیشُرَنْیَویشَں دھرِتْوا تابھْیاں دَرْشَنَ دَدَو! ");
INSERT INTO sanurd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","تاوَپِ گَتْوانْیَشِشْییبھْیَسْتاں کَتھاں کَتھَیانْچَکْرَتُح کِنْتُ تَیوح کَتھامَپِ تے نَ پْرَتْیَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","شیشَتَ ایکادَشَشِشْییشُ بھوجَنوپَوِشْٹیشُ یِیشُسْتیبھْیو دَرْشَنَں دَدَو تَتھوتّھاناتْ پَرَں تَدَّرْشَنَپْراپْتَلوکاناں کَتھایامَوِشْواسَکَرَناتْ تیشامَوِشْواسَمَنَحکاٹھِنْیابھْیاں ہیتُبھْیاں سَ تاںسْتَرْجِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","اَتھَ تاناچَکھْیَو یُویَں سَرْوَّجَگَدْ گَتْوا سَرْوَّجَنانْ پْرَتِ سُسَںوادَں پْرَچارَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","تَتْرَ یَح کَشْچِدْ وِشْوَسْیَ مَجِّتو بھَویتْ سَ پَرِتْراسْیَتے کِنْتُ یو نَ وِشْوَسِشْیَتِ سَ دَنْڈَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","کِنْچَ یے پْرَتْییشْیَنْتِ تَیرِیدرِگْ آشْچَرْیَّں کَرْمَّ پْرَکاشَیِشْیَتے تے مَنّامْنا بھُوتانْ تْیاجَیِشْیَنْتِ بھاشا اَنْیاشْچَ وَدِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","اَپَرَں تَیح سَرْپیشُ دھرِتیشُ پْرانَناشَکَوَسْتُنِ پِیتے چَ تیشاں کاپِ کْشَتِ رْنَ بھَوِشْیَتِ؛ روگِناں گاتْریشُ کَرارْپِتے تےروگا بھَوِشْیَنْتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","اَتھَ پْرَبھُسْتانِتْیادِشْیَ سْوَرْگَں نِیتَح سَنْ پَرَمیشْوَرَسْیَ دَکْشِنَ اُپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","تَتَسْتے پْرَسْتھایَ سَرْوَّتْرَ سُسَںوادِییَکَتھاں پْرَچارَیِتُماریبھِرے پْرَبھُسْتُ تیشاں سَہایَح سَنْ پْرَکاشِتاشْچَرْیَّکْرِیابھِسْتاں کَتھاں پْرَمانَوَتِیں چَکارَ۔ اِتِ۔");
INSERT INTO sanurd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","پْرَتھَمَتو یے ساکْشِنو واکْیَپْرَچارَکاشْچاسَنْ تےسْماکَں مَدھْیے یَدْیَتْ سَپْرَمانَں واکْیَمَرْپَیَنْتِ سْمَ ");
INSERT INTO sanurd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","تَدَنُسارَتونْییپِ بَہَوَسْتَدْورِتّانْتَں رَچَیِتُں پْرَورِتّاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","اَتَایوَ ہے مَہامَہِمَتھِیَپھِلْ تْوَں یا یاح کَتھا اَشِکْشْیَتھاسْتاساں درِڈھَپْرَمانانِ یَتھا پْراپْنوشِ ");
INSERT INTO sanurd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","تَدَرْتھَں پْرَتھَمَمارَبھْیَ تانِ سَرْوّانِ جْناتْواہَمَپِ اَنُکْرَماتْ سَرْوَّورِتّانْتانْ تُبھْیَں لیکھِتُں مَتِمَکارْشَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","یِہُودادیشِییَہیرودْنامَکے راجَتْوَں کُرْوَّتِ اَبِییَیاجَکَسْیَ پَرْیّایادھِکارِی سِکھَرِیَنامَکَ ایکو یاجَکو ہارونَوَںشودْبھَوا اِلِیشیواکھْیا ");
INSERT INTO sanurd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","تَسْیَ جایا دْواوِمَو نِرْدوشَو پْرَبھوح سَرْوّاجْنا وْیَوَسْتھاشْچَ سَںمَنْیَ اِیشْوَرَدرِشْٹَو دھارْمِّکاواسْتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","تَیوح سَنْتانَ ایکوپِ ناسِیتْ، یَتَ اِلِیشیوا بَنْدھْیا تَو دْواویوَ ورِدّھاوَبھَوَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","یَدا سْوَپَرْیّانُکْرَمینَ سِکھَرِیَ اِیشْواسْیَ سَمَکْشَں یاجَکِییَں کَرْمَّ کَروتِ ");
INSERT INTO sanurd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","تَدا یَجْنَسْیَ دِنَپَرِپایّا پَرَمیشْوَرَسْیَ مَنْدِرے پْرَویشَکالے دھُوپَجْوالَنَں کَرْمَّ تَسْیَ کَرَنِییَماسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","تَدّھُوپَجْوالَنَکالے لوکَنِوَہے پْرارْتھَناں کَرْتُں بَہِسْتِشْٹھَتِ ");
INSERT INTO sanurd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","سَتِ سِکھَرِیو یَسْیاں ویدْیاں دھُوپَں جْوالَیَتِ تَدَّکْشِنَپارْشْوے پَرَمیشْوَرَسْیَ دُوتَ ایکَ اُپَسْتھِتو دَرْشَنَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","تَں درِشْٹْوا سِکھَرِیَ اُدْوِوِجے شَشَنْکے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","تَدا سَ دُوتَسْتَں بَبھاشے ہے سِکھَرِیَ ما بھَیسْتَوَ پْرارْتھَنا گْراہْیا جاتا تَوَ بھارْیّا اِلِیشیوا پُتْرَں پْرَسوشْیَتے تَسْیَ نامَ یوेہَنْ اِتِ کَرِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","کِنْچَ تْوَں سانَنْدَح سَہَرْشَشْچَ بھَوِشْیَسِ تَسْیَ جَنْمَنِ بَہَوَ آنَنْدِشْیَنْتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","یَتو ہیتوح سَ پَرَمیشْوَرَسْیَ گوچَرے مَہانْ بھَوِشْیَتِ تَتھا دْراکْشارَسَں سُراں وا کِمَپِ نَ پاسْیَتِ، اَپَرَں جَنْمارَبھْیَ پَوِتْریناتْمَنا پَرِپُورْنَح ");
INSERT INTO sanurd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","سَنْ اِسْراییلْوَںشِییانْ اَنیکانْ پْرَبھوح پَرَمیشْوَرَسْیَ مارْگَمانیشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","سَنْتانانْ پْرَتِ پِترِناں مَناںسِ دھَرْمَّجْنانَں پْرَتْیَناجْناگْراہِنَشْچَ پَراوَرْتَّیِتُں، پْرَبھوح پَرَمیشْوَرَسْیَ سیوارْتھَمْ ایکاں سَجِّتَجاتِں وِدھاتُنْچَ سَ ایلِیَرُوپاتْمَشَکْتِپْراپْتَسْتَسْیاگْرے گَمِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","تَدا سِکھَرِیو دُوتَمَوادِیتْ کَتھَمیتَدْ ویتْسْیامِ؟ یَتوہَں ورِدّھو مَمَ بھارْیّا چَ ورِدّھا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","تَتو دُوتَح پْرَتْیُواچَ پَشْییشْوَرَسْیَ ساکْشادْوَرْتِّی جِبْراییلْناما دُوتوہَں تْوَیا سَہَ کَتھاں گَدِتُں تُبھْیَمِماں شُبھَوارْتّاں داتُنْچَ پْریشِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","کِنْتُ مَدِییَں واکْیَں کالے پھَلِشْیَتِ تَتْ تْوَیا نَ پْرَتِیتَمْ اَتَح کارَنادْ یاوَدیوَ تانِ نَ سیتْسْیَنْتِ تاوَتْ تْوَں وَکْتُںمَشَکْتو مُوکو بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","تَدانِیں یے یے لوکاح سِکھَرِیَمَپَیکْشَنْتَ تے مَدھْییمَنْدِرَں تَسْیَ بَہُوِلَمْبادْ آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","سَ بَہِراگَتو یَدا کِمَپِ واکْیَں وَکْتُمَشَکْتَح سَنْکیتَں کرِتْوا نِحشَبْدَسْتَسْیَو تَدا مَدھْییمَنْدِرَں کَسْیَچِدْ دَرْشَنَں تینَ پْراپْتَمْ اِتِ سَرْوّے بُبُدھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","اَنَنْتَرَں تَسْیَ سیوَنَپَرْیّایے سَمْپُورْنے سَتِ سَ نِجَگیہَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","کَتِپَیَدِنیشُ گَتیشُ تَسْیَ بھارْیّا اِلِیشیوا گَرْبّھَوَتِی بَبھُووَ ");
INSERT INTO sanurd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","پَشْچاتْ سا پَنْچَماسانْ سَںگوپْیاکَتھَیَتْ لوکاناں سَمَکْشَں مَماپَمانَں کھَنْڈَیِتُں پَرَمیشْوَرو مَیِ درِشْٹِں پاتَیِتْوا کَرْمّیدرِشَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","اَپَرَنْچَ تَسْیا گَرْبّھَسْیَ شَشْٹھے ماسے جاتے گالِیلْپْرَدیشِییَناسَرَتْپُری ");
INSERT INTO sanurd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","دایُودو وَںشِییایَ یُوشَپھْنامْنے پُرُشایَ یا مَرِیَمْنامَکُمارِی واگْدَتّاسِیتْ تَسْیاح سَمِیپَں جِبْراییلْ دُوتَ اِیشْوَرینَ پْرَہِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","سَ گَتْوا جَگادَ ہے اِیشْوَرانُگرِہِیتَکَنْیے تَوَ شُبھَں بھُویاتْ پْرَبھُح پَرَمیشْوَرَسْتَوَ سَہایوسْتِ نارِیناں مَدھْیے تْوَمیوَ دھَنْیا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","تَدانِیں سا تَں درِشْٹْوا تَسْیَ واکْیَتَ اُدْوِجْیَ کِیدرِشَں بھاشَنَمِدَمْ اِتِ مَنَسا چِنْتَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","تَتو دُوتووَدَتْ ہے مَرِیَمْ بھَیَں ماکارْشِیح، تْوَیِ پَرَمیشْوَرَسْیانُگْرَہوسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","پَشْیَ تْوَں گَرْبّھَں دھرِتْوا پُتْرَں پْرَسوشْیَسے تَسْیَ نامَ یِیشُرِتِ کَرِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","سَ مَہانْ بھَوِشْیَتِ تَتھا سَرْوّیبھْیَح شْریشْٹھَسْیَ پُتْرَ اِتِ کھْیاسْیَتِ؛ اَپَرَں پْرَبھُح پَرَمیشْوَرَسْتَسْیَ پِتُرْدایُودَح سِںہاسَنَں تَسْمَے داسْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","تَتھا سَ یاکُوبو وَںشوپَرِ سَرْوَّدا راجَتْوَں کَرِشْیَتِ، تَسْیَ راجَتْوَسْیانْتو نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","تَدا مَرِیَمْ تَں دُوتَں بَبھاشے ناہَں پُرُشَسَنْگَں کَرومِ تَرْہِ کَتھَمیتَتْ سَمْبھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","تَتو دُوتوکَتھَیَتْ پَوِتْرَ آتْما تْواماشْرایِشْیَتِ تَتھا سَرْوَّشْریشْٹھَسْیَ شَکْتِسْتَووپَرِ چھایاں کَرِشْیَتِ تَتو ہیتوسْتَوَ گَرْبّھادْ یَح پَوِتْرَبالَکو جَنِشْیَتے سَ اِیشْوَرَپُتْرَ اِتِ کھْیاتِں پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","اَپَرَنْچَ پَشْیَ تَوَ جْناتِرِلِیشیوا یاں سَرْوّے بَنْدھْیامَوَدَنْ اِدانِیں سا وارْدّھَکْیے سَنْتانَمیکَں گَرْبّھےدھارَیَتْ تَسْیَ شَشْٹھَماسوبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","کِمَپِ کَرْمَّ ناسادھْیَمْ اِیشْوَرَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","تَدا مَرِیَمْ جَگادَ، پَشْیَ پْرَبھیرَہَں داسِی مَہْیَں تَوَ واکْیانُسارینَ سَرْوَّمیتَدْ گھَٹَتامْ؛ اَنَنَتَرَں دُوتَسْتَسْیاح سَمِیپاتْ پْرَتَسْتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","اَتھَ کَتِپَیَدِناتْ پَرَں مَرِیَمْ تَسْماتْ پَرْوَّتَمَیَپْرَدیشِییَیِہُودایا نَگَرَمیکَں شِیگھْرَں گَتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","سِکھَرِیَیاجَکَسْیَ گرِہَں پْرَوِشْیَ تَسْیَ جایامْ اِلِیشیواں سَمْبودھْیاوَدَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","تَتو مَرِیَمَح سَمْبودھَنَواکْیے اِلِیشیوایاح کَرْنَیوح پْرَوِشْٹَماتْرے سَتِ تَسْیا گَرْبّھَسْتھَبالَکو نَنَرْتَّ۔ تَتَ اِلِیشیوا پَوِتْریناتْمَنا پَرِپُورْنا سَتِی ");
INSERT INTO sanurd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","پْروچَّیرْگَدِتُماریبھے، یوشِتاں مَدھْیے تْوَمیوَ دھَنْیا، تَوَ گَرْبّھَسْتھَح شِشُشْچَ دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","تْوَں پْرَبھورْماتا، مَمَ نِویشَنے تْوَیا چَرَناوَرْپِتَو، مَمادْیَ سَوبھاگْیَمیتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","پَشْیَ تَوَ واکْیے مَمَ کَرْنَیوح پْرَوِشْٹَماتْرے سَتِ مَمودَرَسْتھَح شِشُرانَنْدانْ نَنَرْتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","یا سْتْرِی وْیَشْوَسِیتْ سا دھَنْیا، یَتو ہیتوسْتاں پْرَتِ پَرَمیشْوَروکْتَں واکْیَں سَرْوَّں سِدّھَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","تَدانِیں مَرِیَمْ جَگادَ۔ دھَنْیَوادَں پَریشَسْیَ کَروتِ مامَکَں مَنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","مَماتْما تارَکیشے چَ سَمُلّاسَں پْرَگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","اَکَروتْ سَ پْرَبھُ رْدُشْٹِں سْوَداسْیا دُرْگَتِں پْرَتِ۔ پَشْیادْیارَبھْیَ ماں دھَنْیاں وَکْشْیَنْتِ پُرُشاح سَدا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","یَح سَرْوَّشَکْتِمانْ یَسْیَ ناماپِ چَ پَوِتْرَکَں۔ سَ ایوَ سُمَہَتْکَرْمَّ کرِتَوانْ مَنِّمِتَّکَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","یے بِبھْیَتِ جَناسْتَسْماتْ تیشاں سَنْتانَپَںکْتِشُ۔ اَنُکَمْپا تَدِییا چَ سَرْوَّدَیوَ سُتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","سْوَباہُبَلَتَسْتینَ پْراکاشْیَتَ پَراکْرَمَح۔ مَنَحکُمَنْتْرَناسارْدّھَں وِکِیرْیَّنْتےبھِمانِنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","سِںہاسَنَگَتالّوکانْ بَلِنَشْچاوَروہْیَ سَح۔ پَدیشُوچّیشُ لوکاںسْتُ کْشُدْرانْ سَںسْتھاپَیَتْیَپِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","کْشُدھِتانْ مانَوانْ دْرَوْیَیرُتَّمَیح پَرِتَرْپْیَ سَح۔ سَکَلانْ دھَنِنو لوکانْ وِسرِجیدْ رِکْتَہَسْتَکانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","اِبْراہِیمِ چَ تَدْوَںشے یا دَیاسْتِ سَدَیوَ تاں۔ سْمرِتْوا پُرا پِترِناں نو یَتھا ساکْشاتْ پْرَتِشْرُتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","اِسْراییلْسیوَکَسْتینَ تَتھوپَکْرِیَتے سْوَیَں۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","اَنَنْتَرَں مَرِیَمْ پْرایینَ ماسَتْرَیَمْ اِلِیشیوَیا سَہوشِتْوا وْیاگھُیَّ نِجَنِویشَنَں یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","تَدَنَنْتَرَمْ اِلِیشیوایاح پْرَسَوَکالَ اُپَسْتھِتے سَتِ سا پُتْرَں پْراسوشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","تَتَح پَرَمیشْوَرَسْتَسْیاں مَہانُگْرَہَں کرِتَوانْ ایتَتْ شْرُتْوا سَمِیپَواسِنَح کُٹُمْباشْچاگَتْیَ تَیا سَہَ مُمُدِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","تَتھاشْٹَمے دِنے تے بالَکَسْیَ تْوَچَں چھیتُّمْ ایتْیَ تَسْیَ پِترِنامانُرُوپَں تَنّامَ سِکھَرِیَ اِتِ کَرْتُّمِیشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","کِنْتُ تَسْیَ ماتاکَتھَیَتْ تَنَّ، ناماسْیَ یوہَنْ اِتِ کَرْتَّوْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","تَدا تے وْیاہَرَنْ تَوَ وَںشَمَدھْیے نامیدرِشَں کَسْیاپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","تَتَح پَرَں تَسْیَ پِتَرَں سِکھَرِیَں پْرَتِ سَنْکیتْیَ پَپْرَچّھُح شِشوح کِں نامَ کارِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","تَتَح سَ پھَلَکَمیکَں یاچِتْوا لِلیکھَ تَسْیَ نامَ یوہَنْ بھَوِشْیَتِ۔ تَسْماتْ سَرْوّے آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","تَتْکْشَنَں سِکھَرِیَسْیَ جِہْواجاڈْیےپَگَتے سَ مُکھَں وْیادایَ سْپَشْٹَوَرْنَمُچّارْیَّ اِیشْوَرَسْیَ گُنانُوادَں چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","تَسْماچَّتُرْدِکْسْتھاح سَمِیپَواسِلوکا بھِیتا ایوَمیتاح سَرْوّاح کَتھا یِہُودایاح پَرْوَّتَمَیَپْرَدیشَسْیَ سَرْوَّتْرَ پْرَچارِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","تَسْماتْ شْروتارو مَنَحسُ سْتھاپَیِتْوا کَتھَیامْبَبھُووُح کِیدرِشویَں بالو بھَوِشْیَتِ؟ اَتھَ پَرَمیشْوَرَسْتَسْیَ سَہایوبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","تَدا یوہَنَح پِتا سِکھَرِیَح پَوِتْریناتْمَنا پَرِپُورْنَح سَنْ ایتادرِشَں بھَوِشْیَدْواکْیَں کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","اِسْراییلَح پْرَبھُ رْیَسْتُ سَ دھَنْیَح پَرَمیشْوَرَح۔ اَنُگرِہْیَ نِجالّوکانْ سَ ایوَ پَرِموچَییتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","وِپَکْشَجَنَہَسْتیبھْیو یَتھا موچْیامَہے وَیَں۔ یاوَجِّیوَنْچَ دھَرْمّینَ سارَلْیینَ چَ نِرْبھَیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","سیوامَہَے تَمیوَیکَمْ ایتَتْکارَنَمیوَ چَ۔ سْوَکِییَں سُپَوِتْرَنْچَ سَںسْمرِتْیَ نِیَمَں سَدا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","کرِپَیا پُرُشانْ پُورْوّانْ نِکَشارْتھاتُّ نَح پِتُح۔ اِبْراہِیمَح سَمِیپے یَں شَپَتھَں کرِتَوانْ پُرا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","تَمیوَ سَپھَلَں کَرْتَّں تَتھا شَتْرُگَنَسْیَ چَ۔ رِृتِییاکارِنَشْچَیوَ کَریبھْیو رَکْشَنایَ نَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","سرِشْٹیح پْرَتھَمَتَح سْوِییَیح پَوِتْرَے رْبھاوِوادِبھِح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","یَتھوکْتَوانْ تَتھا سْوَسْیَ دایُودَح سیوَکَسْیَ تُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","وَںشے تْراتارَمیکَں سَ سَمُتْپادِتَوانْ سْوَیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","اَتو ہے بالَکَ تْوَنْتُ سَرْوّیبھْیَح شْریشْٹھَ ایوَ یَح۔ تَسْیَیوَ بھاوِوادِیتِ پْرَوِکھْیاتو بھَوِشْیَسِ۔ اَسْماکَں چَرَنانْ کْشیمے مارْگے چالَیِتُں سَدا۔ ایوَں دھْوانْتےرْتھَتو مرِتْیوشْچھایایاں یے تُ مانَواح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","اُپَوِشْٹاسْتُ تانیوَ پْرَکاشَیِتُمیوَ ہِ۔ کرِتْوا مَہانُکَمْپاں ہِ یامیوَ پَرَمیشْوَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","اُورْدْوّاتْ سُورْیَّمُدایَّیواسْمَبھْیَں پْراداتُّ دَرْشَنَں۔ تَیانُکَمْپَیا سْوَسْیَ لوکاناں پاپَموچَنے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","پَرِتْرانَسْیَ تیبھْیو ہِ جْنانَوِشْرانَنایَ چَ۔ پْرَبھو رْمارْگَں پَرِشْکَرْتُّں تَسْیاگْرایِی بھَوِشْیَسِ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","اَتھَ بالَکَح شَرِیرینَ بُدّھیا چَ وَرْدّھِتُماریبھے؛ اَپَرَنْچَ سَ اِسْراییلو وَںشِییَلوکاناں سَمِیپے یاوَنَّ پْرَکَٹِیبھُوتَسْتاسْتاوَتْ پْرانْتَرے نْیَوَسَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","اَپَرَنْچَ تَسْمِنْ کالے راجْیَسْیَ سَرْوّیشاں لوکاناں نامانِ لیکھَیِتُمْ اَگَسْتَکَیسَرَ آجْناپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","تَدَنُسارینَ کُرِینِیَنامَنِ سُرِیادیشَسْیَ شاسَکے سَتِ نامَلیکھَنَں پْراریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","اَتو ہیتو رْنامَ لیکھِتُں سَرْوّے جَناح سْوِییَں سْوِییَں نَگَرَں جَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","تَدانِیں یُوشَپھْ نامَ لیکھِتُں واگْدَتَّیا سْوَبھارْیَّیا گَرْبّھَوَتْیا مَرِیَما سَہَ سْوَیَں دایُودَح سَجاتِوَںشَ اِتِ کارَنادْ گالِیلْپْرَدیشَسْیَ ناسَرَتْنَگَرادْ ");
INSERT INTO sanurd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","یِہُوداپْرَدیشَسْیَ بَیتْلیہَماکھْیَں دایُودْنَگَرَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","اَنْیَچَّ تَتْرَ سْتھانے تَیوسْتِشْٹھَتوح سَتو رْمَرِیَمَح پْرَسُوتِکالَ اُپَسْتھِتی ");
INSERT INTO sanurd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","سا تَں پْرَتھَمَسُتَں پْراسوشْٹَ کِنْتُ تَسْمِنْ واسَگرِہے سْتھانابھاوادْ بالَکَں وَسْتْرینَ ویشْٹَیِتْوا گوشالایاں سْتھاپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","اَنَنْتَرَں یے کِیَنْتو میشَپالَکاح سْوَمیشَوْرَجَرَکْشایَے تَتْپْرَدیشے سْتھِتْوا رَجَنْیاں پْرانْتَرے پْرَہَرِنَح کَرْمَّ کُرْوَّنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","تیشاں سَمِیپَں پَرَمیشْوَرَسْیَ دُوتَ آگَتْیوپَتَسْتھَو؛ تَدا چَتُشْپارْشْوے پَرَمیشْوَرَسْیَ تیجَسَح پْرَکاشِتَتْواتْ تےتِشَشَنْکِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","تَدا سَ دُوتَ اُواچَ ما بھَیشْٹَ پَشْیَتادْیَ دایُودَح پُرے یُشْمَنِّمِتَّں تْراتا پْرَبھُح کھْرِیشْٹوجَنِشْٹَ، ");
INSERT INTO sanurd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","سَرْوّیشاں لوکاناں مَہانَنْدَجَنَکَمْ اِمَں مَنْگَلَورِتّانْتَں یُشْمانْ جْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","یُویَں (تَتْسْتھانَں گَتْوا) وَسْتْرَویشْٹِتَں تَں بالَکَں گوشالایاں شَیَنَں دْرَکْشْیَتھَ یُشْمانْ پْرَتِیدَں چِہْنَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","دُوتَ اِماں کَتھاں کَتھِتَوَتِ تَتْراکَسْماتْ سْوَرْگِییاح پرِتَنا آگَتْیَ کَتھامْ اِماں کَتھَیِتْویشْوَرَسْیَ گُنانَنْوَوادِشُح، یَتھا، ");
INSERT INTO sanurd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","سَرْوّورْدْوَّسْتھَیرِیشْوَرَسْیَ مَہِما سَمْپْرَکاشْیَتاں۔ شانْتِرْبھُویاتْ پرِتھِوْیاسْتُ سَنْتوشَشْچَ نَرانْ پْرَتِ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","تَتَح پَرَں تیشاں سَنِّدھے رْدُوتَگَنے سْوَرْگَں گَتے میشَپالَکاح پَرَسْپَرَمْ اَویچَنْ آگَچّھَتَ پْرَبھُح پَرَمیشْوَرو یاں گھَٹَناں جْناپِتَوانْ تَسْیا یاتھَرْیَں جْناتُں وَیَمَدھُنا بَیتْلیہَمْپُرَں یامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","پَشْچاتْ تے تُورْنَں وْرَجِتْوا مَرِیَمَں یُوشَپھَں گوشالایاں شَیَنَں بالَکَنْچَ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","اِتّھَں درِشْٹْوا بالَکَسْیارْتھے پْروکْتاں سَرْوَّکَتھاں تے پْراچارَیانْچَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","تَتو یے لوکا میشَرَکْشَکاناں وَدَنیبھْیَسْتاں وارْتّاں شُشْرُوُسْتے مَہاشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","کِنْتُ مَرِیَمْ ایتَتْسَرْوَّگھَٹَناناں تاتْپَرْیَّں وِوِچْیَ مَنَسِ سْتھاپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","تَتْپَشْچادْ دُوتَوِجْنَپْتانُرُوپَں شْرُتْوا درِشْٹْوا چَ میشَپالَکا اِیشْوَرَسْیَ گُنانُوادَں دھَنْیَوادَنْچَ کُرْوّاناح پَراورِتْیَ یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","اَتھَ بالَکَسْیَ تْوَکْچھیدَنَکالےشْٹَمَدِوَسے سَمُپَسْتھِتے تَسْیَ گَرْبّھَسْتھِتیح پُرْوَّں سْوَرْگِییَدُوتو یَتھاجْناپَیَتْ تَدَنُرُوپَں تے تَنّامَدھییَں یِیشُرِتِ چَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","تَتَح پَرَں مُوسالِکھِتَوْیَوَسْتھایا اَنُسارینَ مَرِیَمَح شُچِتْوَکالَ اُپَسْتھِتے، ");
INSERT INTO sanurd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"پْرَتھَمَجَح سَرْوَّح پُرُشَسَنْتانَح پَرَمیشْوَرے سَمَرْپْیَتاں،\" اِتِ پَرَمیشْوَرَسْیَ وْیَوَسْتھَیا ");
INSERT INTO sanurd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","یِیشُں پَرَمیشْوَرے سَمَرْپَیِتُمْ شاسْتْرِییَوِدھْیُکْتَں کَپوتَدْوَیَں پاراوَتَشاوَکَدْوَیَں وا بَلِں داتُں تے تَں گرِہِیتْوا یِرُوشالَمَمْ آیَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","یِرُوشالَمْپُرَنِواسِی شِمِیونّاما دھارْمِّکَ ایکَ آسِیتْ سَ اِسْراییلَح سانْتْوَنامَپیکْشْیَ تَسْتھَو کِنْچَ پَوِتْرَ آتْما تَسْمِنّاوِرْبھُوتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","اَپَرَں پْرَبھُنا پَرَمیشْوَرینابھِشِکْتے تْراتَرِ تْوَیا نَ درِشْٹے تْوَں نَ مَرِشْیَسِیتِ واکْیَں پَوِتْرینَ آتْمَنا تَسْمَ پْراکَتھْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","اَپَرَنْچَ یَدا یِیشوح پِتا ماتا چَ تَدَرْتھَں وْیَوَسْتھانُرُوپَں کَرْمَّ کَرْتُّں تَں مَنْدِرَمْ آنِنْیَتُسْتَدا ");
INSERT INTO sanurd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","شِمِیونْ آتْمَنَ آکَرْشَنینَ مَنْدِرَماگَتْیَ تَں کْروڈے نِدھایَ اِیشْوَرَسْیَ دھَنْیَوادَں کرِتْوا کَتھَیاماسَ، یَتھا، ");
INSERT INTO sanurd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ہے پْرَبھو تَوَ داسویَں نِجَواکْیانُسارَتَح۔ اِدانِینْتُ سَکَلْیانو بھَوَتا سَںوِسرِجْیَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","یَتَح سَکَلَدیشَسْیَ دِیپْتَیے دِیپْتِرُوپَکَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","اِسْراییلِییَلوکَسْیَ مَہاگَورَوَرُوپَکَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","یَں تْرایَکَں جَنانانْتُ سَمُّکھے تْوَمَجِیجَنَح۔ سَایوَ وِدْیَتےسْماکَں دھْرَوَں نَیَنَنَگوچَرے۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","تَدانِیں تینوکْتا ایتاح سَکَلاح کَتھاح شْرُتْوا تَسْیَ ماتا یُوشَپھْ چَ وِسْمَیَں میناتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","تَتَح پَرَں شِمِیونْ تیبھْیَ آشِشَں دَتّوا تَنْماتَرَں مَرِیَمَمْ اُواچَ، پَشْیَ اِسْراییلو وَںشَمَدھْیے بَہُوناں پاتَنایوتّھاپَنایَ چَ تَتھا وِرودھَپاتْرَں بھَوِتُں، بَہُوناں گُپْتَمَنوگَتاناں پْرَکَٹِیکَرَنایَ بالَکویَں نِیُکْتوسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","تَسْماتْ تَواپِ پْراناح شُولینَ وْیَتْسْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","اَپَرَنْچَ آشیرَسْیَ وَںشِییَپھِنُوییلو دُہِتا ہَنّاکھْیا اَتِجَرَتِی بھَوِشْیَدْوادِنْییکا یا وِواہاتْ پَرَں سَپْتَ وَتْسَرانْ پَتْیا سَہَ نْیَوَسَتْ تَتو وِدھَوا بھُوتْوا چَتُرَشِیتِوَرْشَوَیَحپَرْیَّنَتَں ");
INSERT INTO sanurd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","مَنْدِرے سْتھِتْوا پْرارْتھَنوپَواسَیرْدِوانِشَمْ اِیشْوَرَمْ اَسیوَتَ ساپِ سْتْرِی تَسْمِنْ سَمَیے مَنْدِرَماگَتْیَ ");
INSERT INTO sanurd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","پَرَمیشْوَرَسْیَ دھَنْیَوادَں چَکارَ، یِرُوشالَمْپُرَواسِنو یاوَنْتو لوکا مُکْتِمَپیکْشْیَ سْتھِتاسْتانْ یِیشورْورِتّانْتَں جْناپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","اِتّھَں پَرَمیشْوَرَسْیَ وْیَوَسْتھانُسارینَ سَرْوّیشُ کَرْمَّسُ کرِتیشُ تَو پُنَشْچَ گالِیلو ناسَرَتْنامَکَں نِجَنَگَرَں پْرَتَسْتھاتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","تَتْپَشْچادْ بالَکَح شَرِیرینَ ورِدّھِمیتْیَ جْنانینَ پَرِپُورْنَ آتْمَنا شَکْتِماںشْچَ بھَوِتُماریبھے تَتھا تَسْمِنْ اِیشْوَرانُگْرَہو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","تَسْیَ پِتا ماتا چَ پْرَتِوَرْشَں نِسْتاروتْسَوَسَمَیے یِرُوشالَمَمْ اَگَچّھَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","اَپَرَنْچَ یِیشَو دْوادَشَوَرْشَوَیَسْکے سَتِ تَو پَرْوَّسَمَیَسْیَ رِیتْیَنُسارینَ یِرُوشالَمَں گَتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","پارْوَّنَں سَمْپادْیَ پُنَرَپِ وْیاگھُیَّ یاتَح کِنْتُ یِیشُرْبالَکو یِرُوشالَمِ تِشْٹھَتِ۔ یُوشَپھْ تَنْماتا چَ تَدْ اَوِدِتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","سَ سَنْگِبھِح سَہَ وِدْیَتَ ایتَچَّ بُدْوّا دِنَیکَگَمْیَمارْگَں جَگْمَتُح۔ کِنْتُ شیشے جْناتِبَنْدھُوناں سَمِیپے مرِگَیِتْوا تَدُدّےेشَمَپْراپْیَ ");
INSERT INTO sanurd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","تَو پُنَرَپِ یِرُوشالَمَمْ پَراورِتْیاگَتْیَ تَں مرِگَیانْچَکْرَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","اَتھَ دِنَتْرَیاتْ پَرَں پَنْڈِتاناں مَدھْیے تیشاں کَتھاح شرِنْوَنْ تَتّوَں پرِچّھَںشْچَ مَنْدِرے سَمُپَوِشْٹَح سَ تابھْیاں درِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","تَدا تَسْیَ بُدّھیا پْرَتْیُتَّرَیشْچَ سَرْوّے شْروتارو وِسْمَیَماپَدْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","تادرِشَں درِشْٹْوا تَسْیَ جَنَکو جَنَنِی چَ چَمَچَّکْرَتُح کِنْچَ تَسْیَ ماتا تَمَوَدَتْ، ہے پُتْرَ، کَتھَماواں پْرَتِیتّھَں سَماچَرَسْتْوَمْ؟ پَشْیَ تَوَ پِتاہَنْچَ شوکاکُلَو سَنْتَو تْوامَنْوِچّھاوَح سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","تَتَح سووَدَتْ کُتو مامْ اَنْوَیچّھَتَں؟ پِتُرْگرِہے مَیا سْتھاتَوْیَمْ ایتَتْ کِں یُوابھْیاں نَ جْنایَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","کِنْتُ تَو تَسْیَیتَدْواکْیَسْیَ تاتْپَرْیَّں بودّھُں ناشَکْنُتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","تَتَح پَرَں سَ تابھْیاں سَہَ ناسَرَتَں گَتْوا تَیورْوَشِیبھُوتَسْتَسْتھَو کِنْتُ سَرْوّا ایتاح کَتھاسْتَسْیَ ماتا مَنَسِ سْتھاپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","اَتھَ یِیشو رْبُدّھِح شَرِیرَنْچَ تَتھا تَسْمِنْ اِیشْوَرَسْیَ مانَوانانْچانُگْرَہو وَرْدّھِتُمْ آریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","اَنَنْتَرَں تِبِرِیَکَیسَرَسْیَ راجَتْوَسْیَ پَنْچَدَشے وَتْسَرے سَتِ یَدا پَنْتِییَپِیلاتو یِہُودادیشادھِپَتِ رْہیرودْ تُ گالِیلْپْرَدیشَسْیَ راجا پھِلِپَناما تَسْیَ بھْراتا تُ یِتُورِیایاسْتْراکھونِیتِیاپْرَدیشَسْیَ چَ راجاسِیتْ لُشانِییَناما اَوِلِینِیدیشَسْیَ راجاسِیتْ ");
INSERT INTO sanurd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ہانَنْ کِیَپھاشْچیمَو پْرَدھانَیاجاکاواسْتاں تَدانِیں سِکھَرِیَسْیَ پُتْرایَ یوہَنے مَدھْییپْرانْتَرَمْ اِیشْوَرَسْیَ واکْیے پْرَکاشِتے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","سَ یَرْدَّنَ اُبھَیَتَٹَپْرَدیشانْ سَمیتْیَ پاپَموچَنارْتھَں مَنَحپَراوَرْتَّنَسْیَ چِہْنَرُوپَں یَنْمَجَّنَں تَدِییاح کَتھاح سَرْوَّتْرَ پْرَچارَیِتُماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","یِشَیِیَبھَوِشْیَدْوَکْترِگْرَنْتھے یادرِشِی لِپِراسْتے یَتھا، پَرَمیشَسْیَ پَنْتھانَں پَرِشْکُرُتَ سَرْوَّتَح۔ تَسْیَ راجَپَتھَنْچَیوَ سَمانَں کُرُتادھُنا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","کارِشْیَنْتے سَمُچّھرایاح سَکَلا نِمْنَبھُومَیَح۔ کارِشْیَنْتے نَتاح سَرْوّے پَرْوَّتاشْچوپَپَرْوَّتاح۔ کارِشْیَنْتے چَ یا وَکْراسْتاح سَرْوّاح سَرَلا بھُوَح۔ کارِشْیَنْتے سَماناسْتا یا اُچَّنِیچَبھُومَیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","اِیشْوَرینَ کرِتَں تْرانَں دْرَکْشْیَنْتِ سَرْوَّمانَواح۔ اِتْییتَتْ پْرانْتَرے واکْیَں وَدَتَح کَسْیَچِدْ رَوَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","یے یے لوکا مَجَّنارْتھَں بَہِرایَیُسْتانْ سووَدَتْ رے رے سَرْپَوَںشا آگامِنَح کوپاتْ پَلایِتُں یُشْمانْ کَشْچیتَیاماسَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","تَسْمادْ اِبْراہِیمْ اَسْماکَں پِتا کَتھامِیدرِشِیں مَنوبھِ رْنَ کَتھَیِتْوا یُویَں مَنَحپَرِوَرْتَّنَیوگْیَں پھَلَں پھَلَتَ؛ یُشْمانَہَں یَتھارْتھَں وَدامِ پاشانیبھْیَ ایتیبھْیَ اِیشْوَرَ اِبْراہِیمَح سَنْتانوتْپادَنے سَمَرْتھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","اَپَرَنْچَ تَرُمُولےدھُناپِ پَرَشُح سَںلَگْنوسْتِ یَسْتَرُرُتَّمَں پھَلَں نَ پھَلَتِ سَ چھِدْیَتےگْنَو نِکْشِپْیَتے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","تَدانِیں لوکاسْتَں پَپْرَچّھُسْتَرْہِ کِں کَرْتَّوْیَمَسْمابھِح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","تَتَح سووادِیتْ یَسْیَ دْوے وَسَنے وِدْییتے سَ وَسْتْرَہِینایَیکَں وِتَرَتُ کِںنْچَ یَسْیَ کھادْیَدْرَوْیَں وِدْیَتے سوپِ تَتھَیوَ کَروتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","تَتَح پَرَں کَرَسَنْچایِنو مَجَّنارْتھَمْ آگَتْیَ پَپْرَچّھُح ہے گُرو کِں کَرْتَّوْیَمَسْمابھِح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","تَتَح سوکَتھَیَتْ نِرُوپِتادَدھِکَں نَ گرِہْلِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","اَنَنْتَرَں سیناگَنَ ایتْیَ پَپْرَچّھَ کِمَسْمابھِ رْوا کَرْتَّوْیَمْ؟ تَتَح سوبھِدَدھے کَسْیَ کامَپِ ہانِں ما کارْشْٹَ تَتھا مرِشاپَوادَں ما کُرُتَ نِجَویتَنینَ چَ سَنْتُشْیَ تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","اَپَرَنْچَ لوکا اَپیکْشَیا سْتھِتْوا سَرْوّیپِیتِ مَنوبھِ رْوِتَرْکَیانْچَکْرُح، یوہَنَیَمْ اَبھِشِکْتَسْتْراتا نَ ویتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","تَدا یوہَنْ سَرْوّانْ وْیاجَہارَ، جَلےہَں یُشْمانْ مَجَّیامِ سَتْیَں کِنْتُ یَسْیَ پادُکابَنْدھَنَں موچَیِتُمَپِ نَ یوگْیوسْمِ تادرِشَ ایکو مَتّو گُرُتَرَح پُمانْ ایتِ، سَ یُشْمانْ وَہْنِرُوپے پَوِتْرَ آتْمَنِ مَجَّیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","اَپَرَنْچَ تَسْیَ ہَسْتے شُورْپَ آسْتے سَ سْوَشَسْیانِ شُدّھَرُوپَں پْرَسْپھوٹْیَ گودھُومانْ سَرْوّانْ بھانْڈاگارے سَںگْرَہِیشْیَتِ کِنْتُ بُوشانِ سَرْوّانْیَنِرْوّانَوَہْنِنا داہَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","یوہَنْ اُپَدیشینیتّھَں ناناکَتھا لوکاناں سَمَکْشَں پْرَچارَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","اَپَرَنْچَ ہیرودْ راجا پھِلِپْنامْنَح سَہودَرَسْیَ بھارْیّاں ہیرودِیامَدھِ تَتھانْیانِ یانِ یانِ کُکَرْمّانِ کرِتَوانْ تَدَدھِ چَ ");
INSERT INTO sanurd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","یوہَنا تِرَسْکرِتو بھُوتْوا کاراگارے تَسْیَ بَنْدھَنادْ اَپَرَمَپِ کُکَرْمَّ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","اِتَح پُورْوَّں یَسْمِنْ سَمَیے سَرْوّے یوہَنا مَجِّتاسْتَدانِیں یِیشُرَپْیاگَتْیَ مَجِّتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","تَدَنَنْتَرَں تینَ پْرارْتھِتے میگھَدْوارَں مُکْتَں تَسْماچَّ پَوِتْرَ آتْما مُورْتِّمانْ بھُوتْوا کَپوتَوَتْ تَدُپَرْیَّوَرُروہَ؛ تَدا تْوَں مَمَ پْرِیَح پُتْرَسْتْوَیِ مَمَ پَرَمَح سَنْتوشَ اِتْیاکاشَوانِی بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","تَدانِیں یِیشُح پْرایینَ تْرِںشَدْوَرْشَوَیَسْکَ آسِیتْ۔ لَوکِکَجْنانے تُ سَ یُوشَپھَح پُتْرَح، ");
INSERT INTO sanurd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","یُوشَپھْ ایلیح پُتْرَح، ایلِرْمَتَّتَح پُتْرَح، مَتَّتْ لیویح پُتْرَح، لیوِ رْمَلْکیح پُتْرَح، مَلْکِرْیانَّسْیَ پُتْرَح؛ یانّو یُوشَپھَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","یُوشَپھْ مَتَّتھِیَسْیَ پُتْرَح، مَتَّتھِیَ آموسَح پُتْرَح، آموسْ نَہُومَح پُتْرَح، نَہُومْ اِشْلیح پُتْرَح اِشْلِرْنَگیح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","نَگِرْماٹَح پُتْرَح، ماٹْ مَتَّتھِیَسْیَ پُتْرَح، مَتَّتھِیَح شِمِییح پُتْرَح، شِمِیِرْیُوشَپھَح پُتْرَح، یُوشَپھْ یِہُوداح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","یِہُودا یوہاناح پُتْرَح، یوہانا رِیشاح پُتْرَح، رِیشاح سِرُبّابِلَح پُتْرَح، سِرُبّابِلْ شَلْتِیییلَح پُتْرَح، شَلْتِیییلْ نیریح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","نیرِرْمَلْکیح پُتْرَح، مَلْکِح اَدْیَح پُتْرَح، اَدِّی کوشَمَح پُتْرَح، کوشَمْ اِلْمودَدَح پُتْرَح، اِلْمودَدْ ایرَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ایرْ یوشیح پُتْرَح، یوشِح اِلِیییشَرَح پُتْرَح، اِلِیییشَرْ یورِیمَح پُتْرَح، یورِیمْ مَتَّتَح پُتْرَح، مَتَّتَ لیویح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","لیوِح شِمِیونَح پُتْرَح، شِمِیونْ یِہُوداح پُتْرَح، یِہُودا یُوشُپھَح پُتْرَح، یُوشُپھْ یونَنَح پُتْرَح، یانَنْ اِلِییاکِیمَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","اِلِیاکِیمْح مِلییاح پُتْرَح، مِلییا مَینَنَح پُتْرَح، مَینَنْ مَتَّتَّسْیَ پُتْرَح، مَتَّتّو ناتھَنَح پُتْرَح، ناتھَنْ دایُودَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","دایُودْ یِشَیَح پُتْرَح، یِشَیَ اوبیدَح پُتْرَ، اوبیدْ بویَسَح پُتْرَح، بویَسْ سَلْمونَح پُتْرَح، سَلْمونْ نَہَشونَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","نَہَشونْ اَمِّینادَبَح پُتْرَح، اَمِّینادَبْ اَرامَح پُتْرَح، اَرامْ ہِشْرونَح پُتْرَح، ہِشْرونْ پیرَسَح پُتْرَح، پیرَسْ یِہُوداح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","یِہُودا یاکُوبَح پُتْرَح، یاکُوبْ اِسْہاکَح پُتْرَح، اِسْہاکْ اِبْراہِیمَح پُتْرَح، اِبْراہِیمْ تیرَہَح پُتْرَح، تیرَہْ ناہورَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ناہورْ سِرُگَح پُتْرَح، سِرُگْ رِیْوَح پُتْرَح، رِیُوح پیلَگَح پُتْرَح، پیلَگْ ایوَرَح پُتْرَح، ایوَرْ شیلَہَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","شیلَہْ کَینَنَح پُتْرَح، کَینَنْ اَرْپھَکْشَدَح پُتْرَح، اَرْپھَکْشَدْ شامَح پُتْرَح، شامْ نوہَح پُتْرَح، نوہو لیمَکَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","لیمَکْ مِتھُوشیلَہَح پُتْرَح، مِتھُوشیلَہْ ہَنوکَح پُتْرَح، ہَنوکْ ییرَدَح پُتْرَح، ییرَدْ مَہَلَلیلَح پُتْرَح، مَہَلَلیلْ کَینَنَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","کَینَنْ اِنوشَح پُتْرَح، اِنوشْ شیتَح پُتْرَح، شیتْ آدَمَح پُتْرَ، آدَمْ اِیشْوَرَسْیَ پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","تَتَح پَرَں یِیشُح پَوِتْریناتْمَنا پُورْنَح سَنْ یَرْدَّنَنَدْیاح پَراورِتْیاتْمَنا پْرانْتَرَں نِیتَح سَنْ چَتْوارِںشَدِّنانِ یاوَتْ شَیتانا پَرِیکْشِتوبھُوتْ، ");
INSERT INTO sanurd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","کِنْچَ تانِ سَرْوَّدِنانِ بھوجَنَں وِنا سْتھِتَتْواتْ کالے پُورْنے سَ کْشُدھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","تَتَح شَیتاناگَتْیَ تَمَوَدَتْ تْوَں چیدِیشْوَرَسْیَ پُتْرَسْتَرْہِ پْرَسْتَرانیتانْ آجْنَیا پُوپانْ کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","تَدا یِیشُرُواچَ، لِپِرِیدرِشِی وِدْیَتے مَنُجَح کیوَلینَ پُوپینَ نَ جِیوَتِ کِنْتْوِیشْوَرَسْیَ سَرْوّابھِراجْنابھِ رْجِیوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","تَدا شَیتانْ تَمُچَّں پَرْوَّتَں نِیتْوا نِمِشَیکَمَدھْیے جَگَتَح سَرْوَّراجْیانِ دَرْشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","پَشْچاتْ تَمَوادِیتْ سَرْوَّمْ ایتَدْ وِبھَوَں پْرَتاپَنْچَ تُبھْیَں داسْیامِ تَنْ مَیِ سَمَرْپِتَماسْتے یَں پْرَتِ مَمیچّھا جایَتے تَسْمَے داتُں شَکْنومِ، ");
INSERT INTO sanurd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","تْوَں چینْماں بھَجَسے تَرْہِ سَرْوَّمیتَتْ تَوَیوَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","تَدا یِیشُسْتَں پْرَتْیُکْتَوانْ دُورِی بھَوَ شَیتانْ لِپِراسْتے، نِجَں پْرَبھُں پَرَمیشْوَرَں بھَجَسْوَ کیوَلَں تَمیوَ سیوَسْوَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","اَتھَ شَیتانْ تَں یِرُوشالَمَں نِیتْوا مَنْدِرَسْیَ چُوڈایا اُپَرِ سَمُپَویشْیَ جَگادَ تْوَں چیدِیشْوَرَسْیَ پُتْرَسْتَرْہِ سْتھانادِتو لَمْپھِتْوادھَح ");
INSERT INTO sanurd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","پَتَ یَتو لِپِراسْتے، آجْناپَیِشْیَتِ سْوِییانْ دُوتانْ سَ پَرَمیشْوَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","رَکْشِتُں سَرْوَّمارْگے تْواں تینَ تْوَچَّرَنے یَتھا۔ نَ لَگیتْ پْرَسْتَراگھاتَسْتْواں دھَرِشْیَنْتِ تے تَتھا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","تَدا یِیشُنا پْرَتْیُکْتَمْ اِدَمَپْیُکْتَمَسْتِ تْوَں سْوَپْرَبھُں پَریشَں ما پَرِیکْشَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","پَشْچاتْ شَیتانْ سَرْوَّپَرِیکْشاں سَماپْیَ کْشَناتَّں تْیَکْتْوا یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","تَدا یِیشُراتْمَپْرَبھاواتْ پُنَرْگالِیلْپْرَدیشَں گَتَسْتَدا تَتْسُکھْیاتِشْچَتُرْدِشَں وْیانَشے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","سَ تیشاں بھَجَنَگرِہیشُ اُپَدِشْیَ سَرْوَّیح پْرَشَںسِتو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","اَتھَ سَ سْوَپالَنَسْتھانَں ناسَرَتْپُرَمیتْیَ وِشْرامَوارے سْواچارادْ بھَجَنَگیہَں پْرَوِشْیَ پَٹھِتُمُتَّسْتھَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","تَتو یِشَیِیَبھَوِشْیَدْوادِنَح پُسْتَکے تَسْیَ کَرَدَتّے سَتِ سَ تَتْ پُسْتَکَں وِسْتارْیَّ یَتْرَ وَکْشْیَمانانِ وَچَنانِ سَنْتِ تَتْ سْتھانَں پْراپْیَ پَپاٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","آتْما تُ پَرَمیشَسْیَ مَدِییوپَرِ وِدْیَتے۔ دَرِدْریشُ سُسَںوادَں وَکْتُں ماں سوبھِشِکْتَوانْ۔ بھَگْنانْتَح کَرَنالّوکانْ سُسْوَسْتھانْ کَرْتُّمیوَ چَ۔ بَنْدِیکرِتیشُ لوکیشُ مُکْتے رْگھوشَیِتُں وَچَح۔ نیتْرانِ داتُمَنْدھیبھْیَسْتْراتُں بَدّھَجَنانَپِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","پَریشانُگْرَہے کالَں پْرَچارَیِتُمیوَ چَ۔ سَرْوَّیتَتْکَرَنارْتھایَ مامیوَ پْرَہِنوتِ سَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","تَتَح پُسْتَکَں بَدْوّا پَرِچارَکَسْیَ ہَسْتے سَمَرْپْیَ چاسَنے سَمُپَوِشْٹَح، تَتو بھَجَنَگرِہے یاوَنْتو لوکا آسَنْ تے سَرْوّےنَنْیَدرِشْٹْیا تَں وِلُلوکِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","اَنَنْتَرَمْ اَدْیَیتانِ سَرْوّانِ لِکھِتَوَچَنانِ یُشْماکَں مَدھْیے سِدّھانِ سَ اِماں کَتھاں تیبھْیَح کَتھَیِتُماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","تَتَح سَرْوّے تَسْمِنْ اَنْوَرَجْیَنْتَ، کِنْچَ تَسْیَ مُکھانِّرْگَتابھِرَنُگْرَہَسْیَ کَتھابھِشْچَمَتْکرِتْیَ کَتھَیاماسُح کِمَیَں یُوشَپھَح پُتْرو نَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","تَدا سووادِیدْ ہے چِکِتْسَکَ سْوَمیوَ سْوَسْتھَں کُرُ کَپھَرْناہُومِ یَدْیَتْ کرِتَوانْ تَدَشْرَوشْمَ تاح سَرْواح کْرِیا اَتْرَ سْوَدیشے کُرُ کَتھامیتاں یُویَمیواوَشْیَں ماں وَدِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","پُنَح سووادِیدْ یُشْمانَہَں یَتھارْتھَں وَدامِ، کوپِ بھَوِشْیَدْوادِی سْوَدیشے سَتْکارَں نَ پْراپْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","اَپَرَنْچَ یَتھارْتھَں وَچْمِ، ایلِیَسْیَ جِیوَنَکالے یَدا سارْدّھَتْرِتَیَوَرْشانِ یاوَتْ جَلَدَپْرَتِبَنْدھاتْ سَرْوَّسْمِنْ دیشے مَہادُرْبھِکْشَمْ اَجَنِشْٹَ تَدانِیمْ اِسْراییلو دیشَسْیَ مَدھْیے بَہْوْیو وِدھَوا آسَنْ، ");
INSERT INTO sanurd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","کِنْتُ سِیدونْپْرَدیشِییَسارِپھَتْپُرَنِواسِنِیمْ ایکاں وِدھَواں وِنا کَسْیاشْچِدَپِ سَمِیپے ایلِیَح پْریرِتو نابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","اَپَرَنْچَ اِلِیشایَبھَوِشْیَدْوادِوِدْیَمانَتاکالے اِسْراییلْدیشے بَہَوَح کُشْٹھِنَ آسَنْ کِنْتُ سُرِییَدیشِییَں نامانْکُشْٹھِنَں وِنا کوپْیَنْیَح پَرِشْکرِتو نابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","اِماں کَتھاں شْرُتْوا بھَجَنَگیہَسْتھِتا لوکاح سَکْرودھَمْ اُتّھایَ ");
INSERT INTO sanurd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","نَگَراتَّں بَہِشْکرِتْیَ یَسْیَ شِکھَرِنَ اُپَرِ تیشاں نَگَرَں سْتھاپِتَماسْتے تَسْمانِّکْشیپْتُں تَسْیَ شِکھَرَں تَں نِنْیُح ");
INSERT INTO sanurd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","کِنْتُ سَ تیشاں مَدھْیادَپَسرِتْیَ سْتھانانْتَرَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","تَتَح پَرَں یِیشُرْگالِیلْپْرَدیشِییَکَپھَرْناہُومْنَگَرَ اُپَسْتھایَ وِشْرامَوارے لوکانُپَدیشْٹُمْ آرَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","تَدُپَدیشاتْ سَرْوّے چَمَچَّکْرُ رْیَتَسْتَسْیَ کَتھا گُرُتَرا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","تَدانِیں تَدْبھَجَنَگیہَسْتھِتومیدھْیَبھُوتَگْرَسْتَ ایکو جَنَ اُچَّیح کَتھَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ہے ناسَرَتِییَیِیشوسْمانْ تْیَجَ، تْوَیا سَہاسْماکَں کَح سَمْبَنْدھَح؟ کِمَسْمانْ وِناشَیِتُمایاسِ؟ تْوَمِیشْوَرَسْیَ پَوِتْرو جَنَ ایتَدَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","تَدا یِیشُسْتَں تَرْجَیِتْواوَدَتْ مَونِی بھَوَ اِتو بَہِرْبھَوَ؛ تَتَح سومیدھْیَبھُوتَسْتَں مَدھْیَسْتھانے پاتَیِتْوا کِنْچِدَپْیَہِںسِتْوا تَسْمادْ بَہِرْگَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","تَتَح سَرْوّے لوکاشْچَمَتْکرِتْیَ پَرَسْپَرَں وَکْتُماریبھِرے کویَں چَمَتْکارَح۔ ایشَ پْرَبھاوینَ پَراکْرَمینَ چامیدھْیَبھُوتانْ آجْناپَیَتِ تینَیوَ تے بَہِرْگَچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","اَنَنْتَرَں چَتُرْدِکْسْتھَدیشانْ تَسْیَ سُکھْیاتِرْوْیاپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","تَدَنَنْتَرَں سَ بھَجَنَگیہادْ بَہِراگَتْیَ شِمونو نِویشَنَں پْرَوِویشَ تَدا تَسْیَ شْوَشْرُورْجْوَریناتْیَنْتَں پِیڈِتاسِیتْ شِشْیاسْتَدَرْتھَں تَسْمِنْ وِنَیَں چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","تَتَح سَ تَسْیاح سَمِیپے سْتھِتْوا جْوَرَں تَرْجَیاماسَ تینَیوَ تاں جْوَروتْیاکْشِیتْ تَتَح سا تَتْکْشَنَمْ اُتّھایَ تانْ سِشیوے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","اَتھَ سُورْیّاسْتَکالے سْویشاں یے یے جَنا ناناروگَیح پِیڈِتا آسَنْ لوکاسْتانْ یِیشوح سَمِیپَمْ آنِنْیُح، تَدا سَ ایکَیکَسْیَ گاتْرے کَرَمَرْپَیِتْوا تانَروگانْ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","تَتو بھُوتا بَہُبھْیو نِرْگَتْیَ چِیتْشَبْدَں کرِتْوا چَ بَبھاشِرے تْوَمِیشْوَرَسْیَ پُتْروبھِشِکْتَتْراتا؛ کِنْتُ سوبھِشِکْتَتْراتیتِ تے وِوِدُریتَسْماتْ کارَناتْ تانْ تَرْجَیِتْوا تَدْوَکْتُں نِشِشیدھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","اَپَرَنْچَ پْرَبھاتے سَتِ سَ وِجَنَسْتھانَں پْرَتَسْتھے پَشْچاتْ جَناسْتَمَنْوِچّھَنْتَسْتَنِّکَٹَں گَتْوا سْتھانانْتَرَگَمَنارْتھَں تَمَنْوَرُنْدھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","کِنْتُ سَ تانْ جَگادَ، اِیشْوَرِییَراجْیَسْیَ سُسَںوادَں پْرَچارَیِتُمْ اَنْیانِ پُرانْیَپِ مَیا یاتَوْیانِ یَتَسْتَدَرْتھَمیوَ پْریرِتوہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","اَتھَ گالِیلو بھَجَنَگیہیشُ سَ اُپَدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","اَنَنْتَرَں یِیشُریکَدا گِنیشَرَتھْدَسْیَ تِیرَ اُتِّشْٹھَتِ، تَدا لوکا اِیشْوَرِییَکَتھاں شْروتُں تَدُپَرِ پْرَپَتِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","تَدانِیں سَ ہْدَسْیَ تِیرَسَمِیپے نَودْوَیَں دَدَرْشَ کِنْچَ مَتْسْیوپَجِیوِنو ناوَں وِہایَ جالَں پْرَکْشالَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","تَتَسْتَیورْدْوَیو رْمَدھْیے شِمونو ناوَمارُہْیَ تِیراتْ کِنْچِدُّورَں یاتُں تَسْمِنْ وِنَیَں کرِتْوا نَوکایامُپَوِشْیَ لوکانْ پْروپَدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","پَشْچاتْ تَں پْرَسْتاوَں سَماپْیَ سَ شِمونَں وْیاجَہارَ، گَبھِیرَں جَلَں گَتْوا مَتْسْیانْ دھَرْتُّں جالَں نِکْشِپَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","تَتَح شِمونَ بَبھاشے، ہے گُرو یَدْیَپِ وَیَں کرِتْسْناں یامِنِیں پَرِشْرَمْیَ مَتْسْیَیکَمَپِ نَ پْراپْتاسْتَتھاپِ بھَوَتو نِدیشَتو جالَں کْشِپامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","اَتھَ جالے کْشِپْتے بَہُمَتْسْیَپَتَنادْ آنایَح پْرَچّھِنَّح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","تَسْمادْ اُپَکَرْتُّمْ اَنْیَنَوسْتھانْ سَنْگِنَ آیاتُمْ اِنْگِتینَ سَماہْوَیَنْ تَتَسْتَ آگَتْیَ مَتْسْیَے رْنَودْوَیَں پْرَپُورَیاماسُ رْیَے رْنَودْوَیَں پْرَمَگْنَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","تَدا شِمونْپِتَرَسْتَدْ وِلوکْیَ یِیشوشْچَرَنَیوح پَتِتْوا، ہے پْرَبھوہَں پاپِی نَرو مَمَ نِکَٹادْ بھَوانْ یاتُ، اِتِ کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","یَتو جالے پَتِتاناں مَتْسْیاناں یُوتھاتْ شِمونْ تَتْسَنْگِنَشْچَ چَمَتْکرِتَوَنْتَح؛ شِمونَح سَہَکارِنَو سِوَدیح پُتْرَو یاکُوبْ یوہَنْ چیمَو تادرِشَو بَبھُووَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","تَدا یِیشُح شِمونَں جَگادَ ما بھَیشِیرَدْیارَبھْیَ تْوَں مَنُشْیَدھَرو بھَوِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","اَنَنْتَرَں سَرْوّاسُ نَوسُ تِیرَمْ آنِیتاسُ تے سَرْوّانْ پَرِتْیَجْیَ تَسْیَ پَشْچادْگامِنو بَبھُووُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","تَتَح پَرَں یِیشَو کَسْمِںشْچِتْ پُرے تِشْٹھَتِ جَنَ ایکَح سَرْوّانْگَکُشْٹھَسْتَں وِلوکْیَ تَسْیَ سَمِیپے نْیُبْجَح پَتِتْوا سَوِنَیَں وَکْتُماریبھے، ہے پْرَبھو یَدِ بھَوانِچّھَتِ تَرْہِ ماں پَرِشْکَرْتُّں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","تَدانِیں سَ پانِں پْرَسارْیَّ تَدَنْگَں سْپرِشَنْ بَبھاشے تْوَں پَرِشْکْرِیَسْویتِ مَمیچّھاسْتِ تَتَسْتَتْکْشَنَں سَ کُشْٹھاتْ مُکْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","پَشْچاتْ سَ تَماجْناپَیاماسَ کَتھامِماں کَسْمَیچِدْ اَکَتھَیِتْوا یاجَکَسْیَ سَمِیپَنْچَ گَتْوا سْوَں دَرْشَیَ، لوکیبھْیو نِجَپَرِشْکرِتَتْوَسْیَ پْرَمانَدانایَ مُوساجْنانُسارینَ دْرَوْیَمُتْمرِجَسْوَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","تَتھاپِ یِیشوح سُکھْیاتِ رْبَہُ وْیاپْتُماریبھے کِنْچَ تَسْیَ کَتھاں شْروتُں سْوِییَروگیبھْیو موکْتُنْچَ لوکا آجَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","اَتھَ سَ پْرانْتَرَں گَتْوا پْرارْتھَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","اَپَرَنْچَ ایکَدا یِیشُرُپَدِشَتِ، ایتَرْہِ گالِیلْیِہُوداپْرَدیشَیوح سَرْوَّنَگَریبھْیو یِرُوشالَمَشْچَ کِیَنْتَح پھِرُوشِلوکا وْیَوَسْتھاپَکاشْچَ سَماگَتْیَ تَدَنْتِکے سَمُپَوِوِشُح، تَسْمِنْ کالے لوکاناماروگْیَکارَناتْ پْرَبھوح پْرَبھاوَح پْرَچَکاشے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","پَشْچاتْ کِیَنْتو لوکا ایکَں پَکْشاگھاتِنَں کھَٹْوایاں نِدھایَ یِیشوح سَمِیپَمانیتُں سَمُّکھے سْتھاپَیِتُنْچَ وْیاپْرِیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","کِنْتُ بَہُجَنَنِوَہَسَمْوادھاتْ نَ شَکْنُوَنْتو گرِہوپَرِ گَتْوا گرِہَپرِشْٹھَں کھَنِتْوا تَں پَکْشاگھاتِنَں سَکھَٹْوَں گرِہَمَدھْیے یِیشوح سَمُّکھے وَروہَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","تَدا یِیشُسْتیشامْ اِیدرِشَں وِشْواسَں وِلوکْیَ تَں پَکْشاگھاتِنَں وْیاجَہارَ، ہے مانَوَ تَوَ پاپَمَکْشَمْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","تَسْمادْ اَدھْیاپَکاح پھِرُوشِنَشْچَ چِتَّیرِتّھَں پْرَچِنْتِتَوَنْتَح، ایشَ جَنَ اِیشْوَرَں نِنْدَتِ کویَں؟ کیوَلَمِیشْوَرَں وِنا پاپَں کْشَنْتُں کَح شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","تَدا یِیشُسْتیشامْ اِتّھَں چِنْتَنَں وِدِتْوا تیبھْیوکَتھَیَدْ یُویَں مَنوبھِح کُتو وِتَرْکَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","تَوَ پاپَکْشَما جاتا یَدْوا تْوَمُتّھایَ وْرَجَ ایتَیو رْمَدھْیے کا کَتھا سُکَتھْیا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","کِنْتُ پرِتھِوْیاں پاپَں کْشَنْتُں مانَوَسُتَسْیَ سامَرْتھْیَمَسْتِیتِ یَتھا یُویَں جْناتُں شَکْنُتھَ تَدَرْتھَں (سَ تَں پَکْشاگھاتِنَں جَگادَ) اُتِّشْٹھَ سْوَشَیّاں گرِہِیتْوا گرِہَں یاہِیتِ تْوامادِشامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","تَسْماتْ سَ تَتْکْشَنَمْ اُتّھایَ سَرْوّیشاں ساکْشاتْ نِجَشَیَنِییَں گرِہِیتْوا اِیشْوَرَں دھَنْیَں وَدَنْ نِجَنِویشَنَں یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","تَسْماتْ سَرْوّے وِسْمَیَ پْراپْتا مَنَحسُ بھِیتاشْچَ وَیَمَدْیاسَمْبھَوَکارْیّانْیَدَرْشامَ اِتْیُکْتْوا پَرَمیشْوَرَں دھَنْیَں پْرودِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","تَتَح پَرَں بَہِرْگَچّھَنْ کَرَسَنْچَیَسْتھانے لیوِنامانَں کَرَسَنْچایَکَں درِشْٹْوا یِیشُسْتَمَبھِدَدھے مَمَ پَشْچادیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","تَسْماتْ سَ تَتْکْشَناتْ سَرْوَّں پَرِتْیَجْیَ تَسْیَ پَشْچادِیایَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","اَنَنْتَرَں لیوِ رْنِجَگرِہے تَدَرْتھَں مَہابھوجْیَں چَکارَ، تَدا تَیح سَہانیکے کَرَسَنْچایِنَسْتَدَنْیَلوکاشْچَ بھوکْتُمُپَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","تَسْماتْ کارَناتْ چَنْڈالاناں پاپِلوکانانْچَ سَنْگے یُویَں کُتو بھَںگْدھْوے پِوَتھَ چیتِ کَتھاں کَتھَیِتْوا پھِرُوشِنودھْیاپَکاشْچَ تَسْیَ شِشْیَیح سَہَ واگْیُدّھَں کَرْتُّماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","تَسْمادْ یِیشُسْتانْ پْرَتْیَووچَدْ اَروگَلوکاناں چِکِتْسَکینَ پْرَیوجَنَں ناسْتِ کِنْتُ سَروگانامیوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","اَہَں دھارْمِّکانْ آہْواتُں ناگَتوسْمِ کِنْتُ مَنَح پَراوَرْتَّیِتُں پاپِنَ ایوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","تَتَسْتے پْروچُح، یوہَنَح پھِرُوشِنانْچَ شِشْیا وارَںوارَمْ اُپَوَسَنْتِ پْرارْتھَیَنْتے چَ کِنْتُ تَوَ شِشْیاح کُتو بھُنْجَتے پِوَنْتِ چَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","تَدا سَ تاناچَکھْیَو وَرے سَنْگے تِشْٹھَتِ وَرَسْیَ سَکھِگَنَں کِمُپَواسَیِتُں شَکْنُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","کِنْتُ یَدا تیشاں نِکَٹادْ وَرو نیشْیَتے تَدا تے سَمُپَوَتْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","سوپَرَمَپِ درِشْٹانْتَں کَتھَیامْبَبھُووَ پُراتَنَوَسْتْرے کوپِ نُتَنَوَسْتْرَں نَ سِیوْیَتِ یَتَسْتینَ سیوَنینَ جِیرْنَوَسْتْرَں چھِدْیَتے، نُوتَنَپُراتَنَوَسْتْرَیو رْمیلَنْچَ نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","پُراتَنْیاں کُتْواں کوپِ نُتَنَں دْراکْشارَسَں نَ نِدَدھاتِ، یَتو نَوِینَدْراکْشارَسَسْیَ تیجَسا پُراتَنِی کُتُو رْوِدِیرْیَّتے تَتو دْراکْشارَسَح پَتَتِ کُتُوشْچَ نَشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","تَتو ہیتو رْنُوتَنْیاں کُتْواں نَوِینَدْراکْشارَسَح نِدھاتَوْیَسْتینوبھَیَسْیَ رَکْشا بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","اَپَرَنْچَ پُراتَنَں دْراکْشارَسَں پِیتْوا کوپِ نُوتَنَں نَ وانْچھَتِ، یَتَح سَ وَکْتِ نُوتَناتْ پُراتَنَمْ پْرَشَسْتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","اَچَرَنْچَ پَرْوَّنو دْوِتِییَدِناتْ پَرَں پْرَتھَمَوِشْرامَوارے شَسْیَکْشیتْرینَ یِیشورْگَمَنَکالے تَسْیَ شِشْیاح کَنِشَں چھِتّوا کَریشُ مَرْدَّیِتْوا کھادِتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","تَسْماتْ کِیَنْتَح پھِرُوشِنَسْتانَوَدَنْ وِشْرامَوارے یَتْ کَرْمَّ نَ کَرْتَّوْیَں تَتْ کُتَح کُرُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","یِیشُح پْرَتْیُواچَ دایُودْ تَسْیَ سَنْگِنَشْچَ کْشُدھارْتّاح کِں چَکْرُح سَ کَتھَمْ اِیشْوَرَسْیَ مَنْدِرَں پْرَوِشْیَ ");
INSERT INTO sanurd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","یے دَرْشَنِییاح پُوپا یاجَکانْ وِنانْیَسْیَ کَسْیاپْیَبھوجَنِییاسْتانانِییَ سْوَیَں بُبھَجے سَنْگِبھْیوپِ دَدَو تَتْ کِں یُشْمابھِح کَداپِ ناپاٹھِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","پَشْچاتْ سَ تانَوَدَتْ مَنُجَسُتو وِشْرامَوارَسْیاپِ پْرَبھُ رْبھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","اَنَنْتَرَمْ اَنْیَوِشْرامَوارے سَ بھَجَنَگیہَں پْرَوِشْیَ سَمُپَدِشَتِ۔ تَدا تَتْسْتھانے شُشْکَدَکْشِنَکَرَ ایکَح پُمانْ اُپَتَسْتھِوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","تَسْمادْ اَدھْیاپَکاح پھِرُوشِنَشْچَ تَسْمِنْ دوشَماروپَیِتُں سَ وِشْرامَوارے تَسْیَ سْواسْتھْیَں کَروتِ نَویتِ پْرَتِیکْشِتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","تَدا یِیشُسْتیشاں چِنْتاں وِدِتْوا تَں شُشْکَکَرَں پُماںسَں پْروواچَ، تْوَمُتّھایَ مَدھْیَسْتھانے تِشْٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","تَسْماتْ تَسْمِنْ اُتّھِتَوَتِ یِیشُسْتانْ وْیاجَہارَ، یُشْمانْ اِماں کَتھاں پرِچّھامِ، وِشْرامَوارے ہِتَمْ اَہِتَں وا، پْرانَرَکْشَنَں پْرانَناشَنَں وا، ایتیشاں کِں کَرْمَّکَرَنِییَمْ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","پَشْچاتْ چَتُرْدِکْشُ سَرْوّانْ وِلوکْیَ تَں مانَوَں بَبھاشے، نِجَکَرَں پْرَسارَیَ؛ تَتَسْتینَ تَتھا کرِتَ اِتَرَکَرَوَتْ تَسْیَ ہَسْتَح سْوَسْتھوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","تَسْماتْ تے پْرَچَنْڈَکوپانْوِتا یِیشُں کِں کَرِشْیَنْتِیتِ پَرَسْپَرَں پْرَمَنْتْرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","تَتَح پَرَں سَ پَرْوَّتَمارُہْییشْوَرَمُدِّشْیَ پْرارْتھَیَمانَح کرِتْسْناں راتْرِں یاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","اَتھَ دِنے سَتِ سَ سَرْوّانْ شِشْیانْ آہُوتَوانْ تیشاں مَدھْیی ");
INSERT INTO sanurd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","پِتَرَنامْنا کھْیاتَح شِمونْ تَسْیَ بھْراتا آنْدْرِیَشْچَ یاکُوبْ یوہَنْ چَ پھِلِپْ بَرْتھَلَمَیَشْچَ ");
INSERT INTO sanurd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","مَتھِح تھوما آلْپھِییَسْیَ پُتْرو یاکُوبْ جْوَلَنْتَنامْنا کھْیاتَح شِمونْ ");
INSERT INTO sanurd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","چَ یاکُوبو بھْراتا یِہُوداشْچَ تَں یَح پَرَکَریشُ سَمَرْپَیِشْیَتِ سَ اِیشْکَرِییوتِییَیِہُوداشْچَیتانْ دْوادَشَ جَنانْ مَنونِیتانْ کرِتْوا سَ جَگْراہَ تَتھا پْریرِتَ اِتِ تیشاں نامَ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","تَتَح پَرَں سَ تَیح سَہَ پَرْوَّتادَوَرُہْیَ اُپَتْیَکایاں تَسْتھَو تَتَسْتَسْیَ شِشْیَسَنْگھو یِہُودادیشادْ یِرُوشالَمَشْچَ سورَح سِیدونَشْچَ جَلَدھے رودھَسو جَنَنِہاشْچَ ایتْیَ تَسْیَ کَتھاشْرَوَنارْتھَں روگَمُکْتْیَرْتھَنْچَ تَسْیَ سَمِیپے تَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","اَمیدھْیَبھُوتَگْرَسْتاشْچَ تَنِّکَٹَماگَتْیَ سْواسْتھْیَں پْراپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","سَرْوّیشاں سْواسْتھْیَکَرَنَپْرَبھاوَسْیَ پْرَکاشِتَتْواتْ سَرْوّے لوکا ایتْیَ تَں سْپْرَشْٹُں ییتِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","پَشْچاتْ سَ شِشْیانْ پْرَتِ درِشْٹِں کُتْوا جَگادَ، ہے دَرِدْرا یُویَں دھَنْیا یَتَ اِیشْوَرِییے راجْیے وودھِکاروسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ہے اَدھُنا کْشُدھِتَلوکا یُویَں دھَنْیا یَتو یُویَں تَرْپْسْیَتھَ؛ ہے اِہَ رودِنو جَنا یُویَں دھَنْیا یَتو یُویَں ہَسِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","یَدا لوکا مَنُشْیَسُونو رْنامَہیتو رْیُشْمانْ رِृتِییِشْیَنْتے پرِتھَکْ کرِتْوا نِنْدِشْیَنْتِ، اَدھَمانِوَ یُشْمانْ سْوَسَمِیپادْ دُورِیکَرِشْیَنْتِ چَ تَدا یُویَں دھَنْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","سْوَرْگے یُشْماکَں یَتھیشْٹَں پھَلَں بھَوِشْیَتِ، ایتَدَرْتھَں تَسْمِنْ دِنے پْرولَّسَتَ آنَنْدینَ نرِتْیَتَ چَ، تیشاں پُورْوَّپُرُشاشْچَ بھَوِشْیَدْوادِنَح پْرَتِ تَتھَیوَ وْیَواہَرَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","کِنْتُ ہا ہا دھَنَوَنْتو یُویَں سُکھَں پْراپْنُتَ۔ ہَنْتَ پَرِترِپْتا یُویَں کْشُدھِتا بھَوِشْیَتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","اِہَ ہَسَنْتو یُویَں وَتَ یُشْمابھِح شوچِتَوْیَں رودِتَوْیَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","سَرْوَّیلاکَے رْیُشْماکَں سُکھْیاتَو کرِتایاں یُشْماکَں دُرْگَتِ رْبھَوِشْیَتِ یُشْماکَں پُورْوَّپُرُشا مرِشابھَوِشْیَدْوادِنَح پْرَتِ تَدْوَتْ کرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ہے شْروتارو یُشْمَبھْیَمَہَں کَتھَیامِ، یُویَں شَتْرُشُ پْرِییَدھْوَں یے چَ یُشْمانْ دْوِشَنْتِ تیشامَپِ ہِتَں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","یے چَ یُشْمانْ شَپَنْتِ تیبھْیَ آشِشَں دَتَّ یے چَ یُشْمانْ اَوَمَنْیَنْتے تیشاں مَنْگَلَں پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","یَدِ کَشْچِتْ تَوَ کَپولے چَپیٹاگھاتَں کَروتِ تَرْہِ تَں پْرَتِ کَپولَمْ اَنْیَں پَراوَرْتّیَ سَمُّکھِیکُرُ پُنَشْچَ یَدِ کَشْچِتْ تَوَ گاتْرِییَوَسْتْرَں ہَرَتِ تَرْہِ تَں پَرِدھییَوَسْتْرَمْ اَپِ گْرَہِیتُں ما وارَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","یَسْتْواں یاچَتے تَسْمَے دیہِ، یَشْچَ تَوَ سَمْپَتِّں ہَرَتِ تَں ما یاچَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","پَریبھْیَح سْوانْ پْرَتِ یَتھاچَرَنَمْ اَپیکْشَدھْوے پَرانْ پْرَتِ یُویَمَپِ تَتھاچَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","یے جَنا یُشْماسُ پْرِییَنْتے کیوَلَں تیشُ پْرِییَمانیشُ یُشْماکَں کِں پھَلَں؟ پاپِلوکا اَپِ سْویشُ پْرِییَمانیشُ پْرِییَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","یَدِ ہِتَکارِنَ ایوَ ہِتَں کُرُتھَ تَرْہِ یُشْماکَں کِں پھَلَں؟ پاپِلوکا اَپِ تَتھا کُرْوَّنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ییبھْیَ رِنَپَرِشودھَسْیَ پْراپْتِپْرَتْیاشاسْتے کیوَلَں تیشُ رِنے سَمَرْپِتے یُشْماکَں کِں پھَلَں؟ پُنَح پْراپْتْیاشَیا پاپِیلوکا اَپِ پاپِجَنیشُ رِنَمْ اَرْپَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","اَتو یُویَں رِپُشْوَپِ پْرِییَدھْوَں، پَرَہِتَں کُرُتَ چَ؛ پُنَح پْراپْتْیاشاں تْیَکْتْوا رِنَمَرْپَیَتَ، تَتھا کرِتے یُشْماکَں مَہاپھَلَں بھَوِشْیَتِ، یُویَنْچَ سَرْوَّپْرَدھانَسْیَ سَنْتانا اِتِ کھْیاتِں پْراپْسْیَتھَ، یَتو یُشْماکَں پِتا کرِتَگھْناناں دُرْوْٹَتّانانْچَ ہِتَماچَرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","اَتَ ایوَ سَ یَتھا دَیالُ رْیُویَمَپِ تادرِشا دَیالَوو بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","اَپَرَنْچَ پَرانْ دوشِنو ما کُرُتَ تَسْمادْ یُویَں دوشِیکرِتا نَ بھَوِشْیَتھَ؛ اَدَنْڈْیانْ ما دَنْڈَیَتَ تَسْمادْ یُویَمَپِ دَنْڈَں نَ پْراپْسْیَتھَ؛ پَریشاں دوشانْ کْشَمَدھْوَں تَسْمادْ یُشْماکَمَپِ دوشاح کْشَمِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","دانانِدَتَّ تَسْمادْ یُویَں دانانِ پْراپْسْیَتھَ، وَرَنْچَ لوکاح پَرِمانَپاتْرَں پْرَدَلَیَّ سَنْچالْیَ پْرونْچالْیَ پَرِپُورْیَّ یُشْماکَں کْروڈیشُ سَمَرْپَیِشْیَنْتِ؛ یُویَں یینَ پَرِمانینَ پَرِماتھَ تینَیوَ پَرِمانینَ یُشْمَتْکرِتے پَرِماسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","اَتھَ سَ تیبھْیو درِشْٹانْتَکَتھامَکَتھَیَتْ، اَنْدھو جَنَح کِمَنْدھَں پَنْتھانَں دَرْشَیِتُں شَکْنوتِ؟ تَسْمادْ اُبھاوَپِ کِں گَرْتّے نَ پَتِشْیَتَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","گُروح شِشْیو نَ شْریشْٹھَح کِنْتُ شِشْیے سِدّھے سَتِ سَ گُرُتُلْیو بھَوِتُں شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","اَپَرَنْچَ تْوَں سْوَچَکْشُुشِ ناسامْ اَدرِشْٹْوا تَوَ بھْراتُشْچَکْشُشِ یَتّرِنَمَسْتِ تَدیوَ کُتَح پَشْیَمِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","سْوَچَکْشُشِ یا ناسا وِدْیَتے تامْ اَجْناتْوا، بھْراتَسْتَوَ نیتْراتْ ترِنَں بَہِح کَرومِیتِ واکْیَں بھْراتَرَں کَتھَں وَکْتُں شَکْنوشِ؟ ہے کَپَٹِنْ پُورْوَّں سْوَنَیَناتْ ناساں بَہِح کُرُ تَتو بھْراتُشْچَکْشُشَسْترِنَں بَہِح کَرْتُّں سُدرِشْٹِں پْراپْسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","اَنْیَنْچَ اُتَّمَسْتَرُح کَداپِ پھَلَمَنُتَّمَں نَ پھَلَتِ، اَنُتَّمَتَرُشْچَ پھَلَمُتَّمَں نَ پھَلَتِ کارَنادَتَح پھَلَیسْتَرَوو جْنایَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","کَنْٹَکِپادَپاتْ کوپِ اُڈُمْبَرَپھَلانِ نَ پاتَیَتِ تَتھا شرِگالَکولِورِکْشادَپِ کوپِ دْراکْشاپھَلَں نَ پاتَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","تَدْوَتْ سادھُلوکونْتَحکَرَنَرُوپاتْ سُبھانْڈاگارادْ اُتَّمانِ دْرَوْیانِ بَہِح کَروتِ، دُشْٹو لوکَشْچانْتَحکَرَنَرُوپاتْ کُبھانْڈاگاراتْ کُتْسِتانِ دْرَوْیانِ نِرْگَمَیَتِ یَتونْتَحکَرَناناں پُورْنَبھاوانُرُوپانِ وَچاںسِ مُکھانِّرْگَچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","اَپَرَنْچَ مَماجْنانُرُوپَں ناچَرِتْوا کُتو ماں پْرَبھو پْرَبھو اِتِ وَدَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","یَح کَشْچِنْ مَمَ نِکَٹَمْ آگَتْیَ مَمَ کَتھا نِشَمْیَ تَدَنُرُوپَں کَرْمَّ کَروتِ سَ کَسْیَ سَدرِشو بھَوَتِ تَدَہَں یُشْمانْ جْناाپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","یو جَنو گَبھِیرَں کھَنِتْوا پاشانَسْتھَلے بھِتِّں نِرْمّایَ سْوَگرِہَں رَچَیَتِ تینَ سَہَ تَسْیوپَما بھَوَتِ؛ یَتَ آپْلاوِجَلَمیتْیَ تَسْیَ مُولے ویگینَ وَہَدَپِ تَدْگیہَں لاڈَیِتُں نَ شَکْنوتِ یَتَسْتَسْیَ بھِتِّح پاشانوپَرِ تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","کِنْتُ یَح کَشْچِنْ مَمَ کَتھاح شْرُتْوا تَدَنُرُوپَں ناچَرَتِ سَ بھِتِّں وِنا مرِृدُپَرِ گرِہَنِرْمّاتْرا سَمانو بھَوَتِ؛ یَتَ آپْلاوِجَلَماگَتْیَ ویگینَ یَدا وَہَتِ تَدا تَدْگرِہَں پَتَتِ تَسْیَ مَہَتْ پَتَنَں جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","تَتَح پَرَں سَ لوکاناں کَرْنَگوچَرے تانْ سَرْوّانْ اُپَدیشانْ سَماپْیَ یَدا کَپھَرْناہُومْپُرَں پْرَوِشَتِ ");
INSERT INTO sanurd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","تَدا شَتَسیناپَتیح پْرِیَداسَ ایکو مرِتَکَلْپَح پِیڈِتَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","اَتَح سیناپَتِ رْیِیشو رْوارْتّاں نِشَمْیَ داسَسْیاروگْیَکَرَنایَ تَسْیاگَمَنارْتھَں وِنَیَکَرَنایَ یِہُودِییانْ کِیَتَح پْراچَح پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","تے یِیشورَنْتِکَں گَتْوا وِنَیاتِشَیَں وَکْتُماریبھِرے، سَ سیناپَتِ رْبھَوَتونُگْرَہَں پْراپْتُمْ اَرْہَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","یَتَح سوسْمَجّاتِیییشُ لوکیشُ پْرِییَتے تَتھاسْمَتْکرِتے بھَجَنَگیہَں نِرْمِّتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","تَسْمادْ یِیشُسْتَیح سَہَ گَتْوا نِویشَنَسْیَ سَمِیپَں پْراپَ، تَدا سَ شَتَسیناپَتِ رْوَکْشْیَمانَواکْیَں تَں وَکْتُں بَنْدھُونْ پْراہِنوتْ۔ ہے پْرَبھو سْوَیَں شْرَمو نَ کَرْتَّوْیو یَدْ بھَوَتا مَدْگیہَمَدھْیے پادارْپَنَں کْرِییتَ تَدَپْیَہَں نارْہامِ، ");
INSERT INTO sanurd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","کِنْچاہَں بھَوَتْسَمِیپَں یاتُمَپِ ناتْمانَں یوگْیَں بُدّھَوانْ، تَتو بھَوانْ واکْیَماتْرَں وَدَتُ تینَیوَ مَمَ داسَح سْوَسْتھو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","یَسْمادْ اَہَں پَرادھِینوپِ مَمادھِینا یاح سیناح سَنْتِ تاسامْ ایکَجَنَں پْرَتِ یاہِیتِ مَیا پْروکْتے سَ یاتِ؛ تَدَنْیَں پْرَتِ آیاہِیتِ پْروکْتے سَ آیاتِ؛ تَتھا نِجَداسَں پْرَتِ ایتَتْ کُرْوِّتِ پْروکْتے سَ تَدیوَ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","یِیشُرِدَں واکْیَں شْرُتْوا وِسْمَیَں یَیَو، مُکھَں پَراوَرْتْیَ پَشْچادْوَرْتِّنو لوکانْ بَبھاشے چَ، یُشْمانَہَں وَدامِ اِسْراییلو وَںشَمَدھْییپِ وِشْواسَمِیدرِشَں نَ پْراپْنَوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","تَتَسْتے پْریشِتا گرِہَں گَتْوا تَں پِیڈِتَں داسَں سْوَسْتھَں دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","پَرےہَنِ سَ نایِیناکھْیَں نَگَرَں جَگامَ تَسْیانیکے شِشْیا اَنْیے چَ لوکاسْتینَ سارْدّھَں یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","تیشُ تَنَّگَرَسْیَ دْوارَسَنِّدھِں پْراپْتیشُ کِیَنْتو لوکا ایکَں مرِتَمَنُجَں وَہَنْتو نَگَرَسْیَ بَہِرْیانْتِ، سَ تَنْماتُریکَپُتْرَسْتَنْماتا چَ وِدھَوا؛ تَیا سارْدّھَں تَنَّگَرِییا بَہَوو لوکا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","پْرَبھُسْتاں وِلوکْیَ سانُکَمْپَح کَتھَیاماسَ، ما رودِیح۔ سَ سَمِیپَمِتْوا کھَٹْواں پَسْپَرْشَ تَسْمادْ واہَکاح سْتھَگِتاسْتَمْیُح؛ ");
INSERT INTO sanurd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","تَدا سَ اُواچَ ہے یُوَمَنُشْیَ تْوَمُتِّشْٹھَ، تْوامَہَمْ آجْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","تَسْماتْ سَ مرِتو جَنَسْتَتْکْشَنَمُتّھایَ کَتھاں پْرَکَتھِتَح؛ تَتو یِیشُسْتَسْیَ ماتَرِ تَں سَمَرْپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","تَسْماتْ سَرْوّے لوکاح شَشَنْکِرے؛ ایکو مَہابھَوِشْیَدْوادِی مَدھْیےسْماکَمْ سَمُدَیتْ، اِیشْوَرَشْچَ سْوَلوکانَنْوَگرِہْلاتْ کَتھامِماں کَتھَیِتْوا اِیشْوَرَں دھَنْیَں جَگَدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","تَتَح پَرَں سَمَسْتَں یِہُودادیشَں تَسْیَ چَتُرْدِکْسْتھَدیشَنْچَ تَسْیَیتَتْکِیرْتِّ رْوْیانَشے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","تَتَح پَرَں یوہَنَح شِشْییشُ تَں تَدْورِتّانْتَں جْناپِتَوَتْسُ ");
INSERT INTO sanurd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","سَ سْوَشِشْیاناں دْوَو جَناواہُویَ یِیشُں پْرَتِ وَکْشْیَمانَں واکْیَں وَکْتُں پْریشَیاماسَ، یَسْیاگَمَنَمْ اَپیکْشْیَ تِشْٹھامو وَیَں کِں سَ ایوَ جَنَسْتْوَں؟ کِں وَیَمَنْیَمَپیکْشْیَ سْتھاسْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","پَشْچاتَّو مانَوَو گَتْوا کَتھَیاماسَتُح، یَسْیاگَمَنَمْ اَپیکْشْیَ تِشْٹھامو وَیَں، کِں سَایوَ جَنَسْتْوَں؟ کِں وَیَمَنْیَمَپیکْشْیَ سْتھاسْیامَح؟ کَتھامِماں تُبھْیَں کَتھَیِتُں یوہَنْ مَجَّکَ آواں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","تَسْمِنْ دَنْڈے یِیشُوروگِنو مَہاوْیادھِمَتو دُشْٹَبھُوتَگْرَسْتاںشْچَ بَہُونْ سْوَسْتھانْ کرِتْوا، اَنیکانْدھیبھْیَشْچَکْشُںشِ دَتّوا پْرَتْیُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","یُواں وْرَجَتَمْ اَنْدھا نیتْرانِ کھَنْجاشْچَرَنانِ چَ پْراپْنُوَنْتِ، کُشْٹھِنَح پَرِشْکْرِیَنْتے، بَدھِراح شْرَوَنانِ مرِتاشْچَ جِیوَنانِ پْراپْنُوَنْتِ، دَرِدْراناں سَمِیپیشُ سُسَںوادَح پْرَچارْیَّتے، یَں پْرَتِ وِگھْنَسْوَرُوپوہَں نَ بھَوامِ سَ دھَنْیَح، ");
INSERT INTO sanurd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ایتانِ یانِ پَشْیَتھَح شرِنُتھَشْچَ تانِ یوہَنَں جْناپَیَتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","تَیو رْدُوتَیو رْگَتَیوح سَتو رْیوہَنِ سَ لوکانْ وَکْتُمُپَچَکْرَمے، یُویَں مَدھْییپْرانْتَرَں کِں دْرَشْٹُں نِرَگَمَتَ؟ کِں وایُنا کَمْپِتَں نَڈَں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","یُویَں کِں دْرَشْٹُں نِرَگَمَتَ؟ کِں سُوکْشْمَوَسْتْرَپَرِدھایِنَں کَمَپِ نَرَں؟ کِنْتُ یے سُوکْشْمَمرِدُوَسْتْرانِ پَرِدَدھَتِ سُوتَّمانِ دْرَوْیانِ بھُنْجَتے چَ تے راجَدھانِیشُ تِشْٹھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","تَرْہِ یُویَں کِں دْرَشْٹُں نِرَگَمَتَ؟ کِمیکَں بھَوِشْیَدْوادِنَں؟ تَدیوَ سَتْیَں کِنْتُ سَ پُمانْ بھَوِشْیَدْوادِنوپِ شْریشْٹھَ اِتْیَہَں یُشْمانْ وَدامِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","پَشْیَ سْوَکِییَدُوتَنْتُ تَواگْرَ پْریشَیامْیَہَں۔ گَتْوا تْوَدِییَمارْگَنْتُ سَ ہِ پَرِشْکَرِشْیَتِ۔ یَدَرْتھے لِپِرِیَمْ آسْتے سَ ایوَ یوہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","اَتو یُشْمانَہَں وَدامِ سْتْرِیا گَرْبّھَجاتاناں بھَوِشْیَدْوادِناں مَدھْیے یوہَنو مَجَّکاتْ شْریشْٹھَح کوپِ ناسْتِ، تَتْراپِ اِیشْوَرَسْیَ راجْیے یَح سَرْوَّسْماتْ کْشُدْرَح سَ یوہَنوپِ شْریشْٹھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","اَپَرَنْچَ سَرْوّے لوکاح کَرَمَنْچایِنَشْچَ تَسْیَ واکْیانِ شْرُتْوا یوہَنا مَجَّنینَ مَجِّتاح پَرَمیشْوَرَں نِرْدوشَں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","کِنْتُ پھِرُوشِنو وْیَوَسْتھاپَکاشْچَ تینَ نَ مَجِّتاح سْوانْ پْرَتِیشْوَرَسْیوپَدیشَں نِشْپھَلَمْ اَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","اَتھَ پْرَبھُح کَتھَیاماسَ، اِدانِینْتَنَجَنانْ کینوپَمامِ؟ تے کَسْیَ سَدرِشاح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","یے بالَکا وِپَنْیامْ اُپَوِشْیَ پَرَسْپَرَمْ آہُویَ واکْیَمِدَں وَدَنْتِ، وَیَں یُشْماکَں نِکَٹے وَںشِیرَوادِشْمَ، کِنْتُ یُویَں نانَرْتِّشْٹَ، وَیَں یُشْماکَں نِکَٹَ اَرودِشْمَ، کِنْتُ یُیَں نَ وْیَلَپِشْٹَ، بالَکَیریتادرِشَیسْتیشامْ اُپَما بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","یَتو یوہَنْ مَجَّکَ آگَتْیَ پُوپَں ناکھادَتْ دْراکْشارَسَنْچَ ناپِوَتْ تَسْمادْ یُویَں وَدَتھَ، بھُوتَگْرَسْتویَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","تَتَح پَرَں مانَوَسُتَ آگَتْیاکھادَدَپِوَنْچَ تَسْمادْ یُویَں وَدَتھَ، کھادَکَح سُراپَشْچانْڈالَپاپِناں بَنْدھُریکو جَنو درِشْیَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","کِنْتُ جْنانِنو جْنانَں نِرْدوشَں وِدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","پَشْچادیکَح پھِرُوشِی یِیشُں بھوجَنایَ نْیَمَنْتْرَیَتْ تَتَح سَ تَسْیَ گرِہَں گَتْوا بھوکْتُمُپَوِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ایتَرْہِ تَتْپھِرُوشِنو گرِہے یِیشُ رْبھیکْتُمْ اُپاویکْشِیتْ تَچّھرُتْوا تَنَّگَرَواسِنِی کاپِ دُشْٹا نارِی پانْڈَرَپْرَسْتَرَسْیَ سَمْپُٹَکے سُگَنْدھِتَیلَمْ آنِییَ ");
INSERT INTO sanurd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","تَسْیَ پَشْچاتْ پادَیوح سَنِّدھَو تَسْیَو رُدَتِی چَ نیتْرامْبُبھِسْتَسْیَ چَرَنَو پْرَکْشالْیَ نِجَکَچَیرَمارْکْشِیتْ، تَتَسْتَسْیَ چَرَنَو چُمْبِتْوا تینَ سُگَنْدھِتَیلینَ مَمَرْدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","تَسْماتْ سَ نِمَنْتْرَیِتا پھِرُوشِی مَنَسا چِنْتَیاماسَ، یَدْیَیَں بھَوِشْیَدْوادِی بھَویتْ تَرْہِ اینَں سْپرِشَتِ یا سْتْرِی سا کا کِیدرِشِی چیتِ جْناتُں شَکْنُیاتْ یَتَح سا دُشْٹا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","تَدا یاشُسْتَں جَگادَ، ہے شِمونْ تْواں پْرَتِ مَمَ کِنْچِدْ وَکْتَوْیَمَسْتِ؛ تَسْماتْ سَ بَبھاشے، ہے گُرو تَدْ وَدَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ایکوتَّمَرْنَسْیَ دْواوَدھَمَرْناواسْتاں، تَیوریکَح پَنْچَشَتانِ مُدْراپادانْ اَپَرَشْچَ پَنْچاشَتْ مُدْراپادانْ دھارَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","تَدَنَنْتَرَں تَیوح شودھْیابھاواتْ سَ اُتَّمَرْنَسْتَیو ررِنے چَکْشَمے؛ تَسْماتْ تَیورْدْوَیوح کَسْتَسْمِنْ پْریشْیَتے بَہُ؟ تَدْ بْرُوہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","شِمونْ پْرَتْیُواچَ، مَیا بُدھْیَتے یَسْیادھِکَمْ رِنَں چَکْشَمے سَ اِتِ؛ تَتو یِیشُسْتَں وْیاجَہارَ، تْوَں یَتھارْتھَں وْیَچارَیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","اَتھَ تاں نارِیں پْرَتِ وْیاگھُٹھْیَ شِمونَمَووچَتْ، سْتْرِیمِماں پَشْیَسِ؟ تَوَ گرِہے مَیّاگَتے تْوَں پادَپْرَکْشالَنارْتھَں جَلَں ناداح کِنْتُ یوشِدیشا نَیَنَجَلَے رْمَمَ پادَو پْرَکْشالْیَ کیشَیرَمارْکْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","تْوَں ماں ناچُمْبِیح کِنْتُ یوشِدیشا سْوِییاگَمَنادارَبھْیَ مَدِییَپادَو چُمْبِتُں نَ وْیَرَںسْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","تْوَنْچَ مَدِییوتَّمانْگے کِنْچِدَپِ تَیلَں نامَرْدِیح کِنْتُ یوشِدیشا مَمَ چَرَنَو سُگَنْدھِتَیلینامَرْدِّیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","اَتَسْتْواں وْیاہَرامِ، ایتَسْیا بَہُ پاپَمَکْشَمْیَتَ تَتو بَہُ پْرِییَتے کِنْتُ یَسْیالْپَپاپَں کْشَمْیَتے سولْپَں پْرِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","تَتَح پَرَں سَ تاں بَبھاشے، تْوَدِییَں پاپَمَکْشَمْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","تَدا تینَ سارْدّھَں یے بھوکْتُمْ اُپَوِوِشُسْتے پَرَسْپَرَں وَکْتُماریبھِرے، اَیَں پاپَں کْشَمَتے کَ ایشَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","کِنْتُ سَ تاں نارِیں جَگادَ، تَوَ وِشْواسَسْتْواں پَرْیَّتْراسْتَ تْوَں کْشیمینَ وْرَجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","اَپَرَنْچَ یِیشُ رْدْوادَشَبھِح شِشْیَیح سارْدّھَں نانانَگَریشُ ناناگْرامیشُ چَ گَچّھَنْ اِشْوَرِییَراجَتْوَسْیَ سُسَںوادَں پْرَچارَیِتُں پْراریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","تَدا یَسْیاح سَپْتَ بھُوتا نِرَگَچّھَنْ سا مَگْدَلِینِیتِ وِکھْیاتا مَرِیَمْ ہیرودْراجَسْیَ گرِہادھِپَتیح ہوشے رْبھارْیّا یوہَنا شُوشانا ");
INSERT INTO sanurd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","پْرَبھرِتَیو یا بَہْوْیَح سْتْرِیَح دُشْٹَبھُوتیبھْیو روگیبھْیَشْچَ مُکْتاح سَتْیو نِجَوِبھُوتِی رْوْیَیِتْوا تَمَسیوَنْتَ، تاح سَرْوّاسْتینَ سارْدّھَمْ آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","اَنَنْتَرَں نانانَگَریبھْیو بَہَوو لوکا آگَتْیَ تَسْیَ سَمِیپےمِلَنْ، تَدا سَ تیبھْیَ ایکاں درِشْٹانْتَکَتھاں کَتھَیاماسَ۔ ایکَح کرِشِیبَلو بِیجانِ وَپْتُں بَہِرْجَگامَ، ");
INSERT INTO sanurd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","تَتو وَپَنَکالے کَتِپَیانِ بِیجانِ مارْگَپارْشْوے پیتُح، تَتَسْتانِ پَدَتَلَے رْدَلِتانِ پَکْشِبھِ رْبھَکْشِتانِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","کَتِپَیانِ بِیجانِ پاشانَسْتھَلے پَتِتانِ یَدْیَپِ تانْیَنْکُرِتانِ تَتھاپِ رَسابھاواتْ شُشُشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","کَتِپَیانِ بِیجانِ کَنْٹَکِوَنَمَدھْیے پَتِتانِ تَتَح کَنْٹَکِوَنانِ سَںورِدّھیَ تانِ جَگْرَسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","تَدَنْیانِ کَتِپَیَبِیجانِ چَ بھُومْیامُتَّمایاں پیتُسْتَتَسْتانْیَنْکُرَیِتْوا شَتَگُنانِ پھَلانِ پھیلُح۔ سَ اِما کَتھاں کَتھَیِتْوا پْروچَّیح پْروواچَ، یَسْیَ شْروتُں شْروتْرے سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","تَتَح پَرَں شِشْیاسْتَں پَپْرَچّھُرَسْیَ درِشْٹانْتَسْیَ کِں تاتْپَرْیَّں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","تَتَح سَ وْیاجَہارَ، اِیشْوَرِییَراجْیَسْیَ گُہْیانِ جْناتُں یُشْمَبھْیَمَدھِکارو دِییَتے کِنْتْوَنْیے یَتھا درِشْٹْواپِ نَ پَشْیَنْتِ شْرُتْواپِ مَ بُدھْیَنْتے چَ تَدَرْتھَں تیشاں پُرَسْتاتْ تاح سَرْوّاح کَتھا درِشْٹانْتینَ کَتھْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","درِشْٹانْتَسْیاسْیابھِپْرایَح، اِیشْوَرِییَکَتھا بِیجَسْوَرُوپا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","یے کَتھاماتْرَں شرِنْوَنْتِ کِنْتُ پَشْچادْ وِشْوَسْیَ یَتھا پَرِتْرانَں نَ پْراپْنُوَنْتِ تَداشَیینَ شَیتانیتْیَ ہرِدَیاترِ تاں کَتھامْ اَپَہَرَتِ تَ ایوَ مارْگَپارْشْوَسْتھَبھُومِسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","یے کَتھَں شْرُتْوا سانَنْدَں گرِہْلَنْتِ کِنْتْوَبَدّھَمُولَتْواتْ سْوَلْپَکالَماتْرَں پْرَتِیتْیَ پَرِیکْشاکالے بھْرَشْیَنْتِ تَایوَ پاشانَبھُومِسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","یے کَتھاں شْرُتْوا یانْتِ وِشَیَچِنْتایاں دھَنَلوبھینَ اےेہِکَسُکھے چَ مَجَّنْتَ اُپَیُکْتَپھَلانِ نَ پھَلَنْتِ تَ ایووپْتَبِیجَکَنْٹَکِبھُوسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","کِنْتُ یے شْرُتْوا سَرَلَیح شُدّھَیشْچانْتَحکَرَنَیح کَتھاں گرِہْلَنْتِ دھَیرْیَّمْ اَوَلَمْبْیَ پھَلانْیُتْپادَیَنْتِ چَ تَ ایووتَّمَمرِتْسْوَرُوپاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","اَپَرَنْچَ پْرَدِیپَں پْرَجْوالْیَ کوپِ پاتْرینَ ناچّھادَیَتِ تَتھا کھَٹْوادھوپِ نَ سْتھاپَیَتِ، کِنْتُ دِیپادھاروپَرْیّیوَ سْتھاپَیَتِ، تَسْماتْ پْرَویشَکا دِیپْتِں پَشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","یَنَّ پْرَکاشَیِشْیَتے تادرِگْ اَپْرَکاشِتَں وَسْتُ کِمَپِ ناسْتِ یَچَّ نَ سُوْیَکْتَں پْرَچارَیِشْیَتے تادرِگْ گرِپْتَں وَسْتُ کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","اَتو یُویَں کینَ پْرَکارینَ شرِنُتھَ تَتْرَ ساوَدھانا بھَوَتَ، یَسْیَ سَمِیپے بَرْدّھَتے تَسْمَے پُنَرْداسْیَتے کِنْتُ یَسْیاشْرَیے نَ بَرْدّھَتے تَسْیَ یَدْیَدَسْتِ تَدَپِ تَسْماتْ نیشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","اَپَرَنْچَ یِیشو رْماتا بھْراتَرَشْچَ تَسْیَ سَمِیپَں جِگَمِشَوَح ");
INSERT INTO sanurd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","کِنْتُ جَنَتاسَمْبادھاتْ تَتْسَنِّدھِں پْراپْتُں نَ شیکُح۔ تَتْپَشْچاتْ تَوَ ماتا بھْراتَرَشْچَ تْواں ساکْشاتْ چِکِیرْشَنْتو بَہِسْتِشْٹھَنَتِیتِ وارْتّایاں تَسْمَے کَتھِتایاں ");
INSERT INTO sanurd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","سَ پْرَتْیُواچَ؛ یے جَنا اِیشْوَرَسْیَ کَتھاں شْرُتْوا تَدَنُرُوپَماچَرَنْتِ تَایوَ مَمَ ماتا بھْراتَرَشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","اَنَنْتَرَں ایکَدا یِیشُح شِشْیَیح سارْدّھَں ناوَمارُہْیَ جَگادَ، آیاتَ وَیَں ہْرَدَسْیَ پارَں یامَح، تَتَسْتے جَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","تیشُ نَوکاں واہَیَتْسُ سَ نِدَدْرَو؛ ");
INSERT INTO sanurd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","اَتھاکَسْماتْ پْرَبَلَجھَنْبھْشَگَمادْ ہْرَدے نَوکایاں تَرَنْگَیراچّھَنّایاں وِپَتْ تانْ جَگْراسَ۔ تَسْمادْ یِیشورَنْتِکَں گَتْوا ہے گُرو ہے گُرو پْرانا نو یانْتِیتِ گَدِتْوا تَں جاگَرَیامْبَبھُووُح۔ تَدا سَ اُتّھایَ وایُں تَرَنْگاںشْچَ تَرْجَیاماسَ تَسْمادُبھَو نِورِتْیَ سْتھِرَو بَبھُووَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","سَ تانْ بَبھاشے یُشْماکَں وِشْواسَح کَ؟ تَسْماتّے بھِیتا وِسْمِتاشْچَ پَرَسْپَرَں جَگَدُح، اَہو کِیدرِگَیَں مَنُجَح پَوَنَں پانِییَنْچادِشَتِ تَدُبھَیَں تَدادیشَں وَہَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","تَتَح پَرَں گالِیلْپْرَدیشَسْیَ سَمُّکھَسْتھَگِدیرِییَپْرَدیشے نَوکایاں لَگَنْتْیاں تَٹےوَروہَماوادْ ");
INSERT INTO sanurd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","بَہُتِتھَکالَں بھُوتَگْرَسْتَ ایکو مانُشَح پُراداگَتْیَ تَں ساکْشاچَّکارَ۔ سَ مَنُشو واسو نَ پَرِدَدھَتْ گرِہے چَ نَ وَسَنْ کیوَلَں شْمَشانَمْ اَدھْیُواسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","سَ یِیشُں درِشْٹْوَیوَ چِیچّھَبْدَں چَکارَ تَسْیَ سَمُّکھے پَتِتْوا پْروچَّیرْجَگادَ چَ، ہے سَرْوَّپْرَدھانیشْوَرَسْیَ پُتْرَ، مَیا سَہَ تَوَ کَح سَمْبَنْدھَح؟ تْوَیِ وِنَیَں کَرومِ ماں ما یاتَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","یَتَح سَ تَں مانُشَں تْیَکْتْوا یاتُمْ اَمیدھْیَبھُوتَمْ آدِدیشَ؛ سَ بھُوتَسْتَں مانُشَمْ اَسَکرِدْ دَدھارَ تَسْمالّوکاح شرِنْکھَلینَ نِگَڈینَ چَ بَبَنْدھُح؛ سَ تَدْ بھَںکْتْوا بھُوتَوَشَتْواتْ مَدھْییپْرانْتَرَں یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","اَنَنْتَرَں یِیشُسْتَں پَپْرَچّھَ تَوَ کِنّامَ؟ سَ اُواچَ، مَمَ نامَ باہِنو یَتو بَہَوو بھُوتاسْتَماشِشْرِیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","اَتھَ بھُوتا وِنَیینَ جَگَدُح، گَبھِیرَں گَرْتَّں گَنْتُں ماجْناپَیاسْمانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","تَدا پَرْوَّتوپَرِ وَراہَوْرَجَشْچَرَتِ تَسْمادْ بھُوتا وِنَیینَ پْروچُح، اَمُں وَراہَوْرَجَمْ آشْرَیِتُمْ اَسْمانْ اَنُجانِیہِ؛ تَتَح سونُجَجْنَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","تَتَح پَرَں بھُوتاسْتَں مانُشَں وِہایَ وَراہَوْرَجَمْ آشِشْرِیُح وَراہَوْرَجاشْچَ تَتْکْشَناتْ کَٹَکینَ دھاوَنْتو ہْرَدے پْرانانْ وِجرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","تَدْ درِشْٹْوا شُوکَرَرَکْشَکاح پَلایَمانا نَگَرَں گْرامَنْچَ گَتْوا تَتْسَرْوَّورِتّانْتَں کَتھَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","تَتَح کِں ورِتَّمْ ایتَدَّرْشَنارْتھَں لوکا نِرْگَتْیَ یِیشوح سَمِیپَں یَیُح، تَں مانُشَں تْیَکْتَبھُوتَں پَرِہِتَوَسْتْرَں سْوَسْتھَمانُشَوَدْ یِیشوشْچَرَنَسَنِّدھَو سُوپَوِشَنْتَں وِلوکْیَ بِبھْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","یے لوکاسْتَسْیَ بھُوتَگْرَسْتَسْیَ سْواسْتھْیَکَرَنَں دَدرِشُسْتے تیبھْیَح سَرْوَّورِتّانْتَں کَتھَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","تَدَنَنْتَرَں تَسْیَ گِدیرِییَپْرَدیشَسْیَ چَتُرْدِکْسْتھا بَہَوو جَنا اَتِتْرَسْتا وِنَیینَ تَں جَگَدُح، بھَوانْ اَسْماکَں نِکَٹادْ وْرَجَتُ تَسْماتْ سَ ناوَمارُہْیَ تَتو وْیاگھُٹْیَ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","تَدانِیں تْیَکْتَبھُوتَمَنُجَسْتینَ سَہَ سْتھاتُں پْرارْتھَیانْچَکْری ");
INSERT INTO sanurd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","کِنْتُ تَدَرْتھَمْ اِیشْوَرَح کِیدرِنْمَہاکَرْمَّ کرِتَوانْ اِتِ نِویشَنَں گَتْوا وِجْناپَیَ، یِیشُح کَتھامیتاں کَتھَیِتْوا تَں وِسَسَرْجَ۔ تَتَح سَ وْرَجِتْوا یِیشُسْتَدَرْتھَں یَنْمَہاکَرْمَّ چَکارَ تَتْ پُرَسْیَ سَرْوَّتْرَ پْرَکاشَیِتُں پْراریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","اَتھَ یِیشَو پَراورِتْیاگَتے لوکاسْتَں آدَرینَ جَگرِہُ رْیَسْماتّے سَرْوّے تَمَپیکْشانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","تَدَنَنْتَرَں یایِیرْنامْنو بھَجَنَگیہَسْیَیکودھِپَ آگَتْیَ یِیشوشْچَرَنَیوح پَتِتْوا سْوَنِویشَناگَمَنارْتھَں تَسْمِنْ وِنَیَں چَکارَ، ");
INSERT INTO sanurd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","یَتَسْتَسْیَ دْوادَشَوَرْشَوَیَسْکا کَنْیَیکاسِیتْ سا مرِتَکَلْپابھَوَتْ۔ تَتَسْتَسْیَ گَمَنَکالے مارْگے لوکاناں مَہانْ سَماگَمو بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","دْوادَشَوَرْشانِ پْرَدَرَروگَگْرَسْتا نانا وَیدْیَیشْچِکِتْسِتا سَرْوَّسْوَں وْیَیِتْواپِ سْواسْتھْیَں نَ پْراپْتا یا یوشِتْ سا یِیشوح پَشْچاداگَتْیَ تَسْیَ وَسْتْرَگْرَنْتھِں پَسْپَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","تَسْماتْ تَتْکْشَناتْ تَسْیا رَکْتَسْراوو رُدّھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","تَدانِیں یِیشُرَوَدَتْ کیناہَں سْپرِشْٹَح؟ تَتونیکَیرَنَنْگِیکرِتے پِتَرَسْتَسْیَ سَنْگِنَشْچاوَدَنْ، ہے گُرو لوکا نِکَٹَسْتھاح سَنْتَسْتَوَ دیہے گھَرْشَیَنْتِ، تَتھاپِ کیناہَں سْپرِشْٹَاِتِ بھَوانْ کُتَح پرِچّھَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","یِیشُح کَتھَیاماسَ، کیناپْیَہَں سْپرِشْٹو، یَتو مَتَّح شَکْتِ رْنِرْگَتیتِ مَیا نِشْچِتَمَجْنایِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","تَدا سا نارِی سْوَیَں نَ گُپْتیتِ وِدِتْوا کَمْپَمانا سَتِی تَسْیَ سَمُّکھے پَپاتَ؛ یینَ نِمِتّینَ تَں پَسْپَرْشَ سْپَرْشَماتْراچَّ یینَ پْرَکارینَ سْوَسْتھابھَوَتْ تَتْ سَرْوَّں تَسْیَ ساکْشاداچَکھْیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","تَتَح سَ تاں جَگادَ ہے کَنْیے سُسْتھِرا بھَوَ، تَوَ وِشْواسَسْتْواں سْوَسْتھامْ اَکارْشِیتْ تْوَں کْشیمینَ یاہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","یِیشوریتَدْواکْیَوَدَنَکالے تَسْیادھِپَتے رْنِویشَناتْ کَشْچِلّوکَ آگَتْیَ تَں بَبھاشے، تَوَ کَنْیا مرِتا گُرُں ما کْلِشانَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","کِنْتُ یِیشُسْتَداکَرْنْیادھِپَتِں وْیاجَہارَ، ما بھَیشِیح کیوَلَں وِشْوَسِہِ تَسْماتْ سا جِیوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","اَتھَ تَسْیَ نِویشَنے پْراپْتے سَ پِتَرَں یوہَنَں یاکُوبَنْچَ کَنْیایا ماتَرَں پِتَرَنْچَ وِنا، اَنْیَں کَنْچَنَ پْرَویشْٹُں وارَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","اَپَرَنْچَ یے رُدَنْتِ وِلَپَنْتِ چَ تانْ سَرْوّانْ جَنانْ اُواچَ، یُویَں ما رودِشْٹَ کَنْیا نَ مرِتا نِدْراتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","کِنْتُ سا نِشْچِتَں مرِتیتِ جْناتْوا تے تَمُپَجَہَسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","پَشْچاتْ سَ سَرْوّانْ بَہِح کرِتْوا کَنْیایاح کَرَو دھرِتْواجُہُوے، ہے کَنْیے تْوَمُتِّشْٹھَ، ");
INSERT INTO sanurd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","تَسْماتْ تَسْیاح پْرانیشُ پُنَراگَتیشُ سا تَتْکْشَنادْ اُتَّسْیَو۔ تَدانِیں تَسْیَے کِنْچِدْ بھَکْشْیَں داتُمْ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","تَتَسْتَسْیاح پِتَرَو وِسْمَیَں گَتَو کِنْتُ سَ تاوادِدیشَ گھَٹَنایا ایتَسْیاح کَتھاں کَسْمَیچِدَپِ ما کَتھَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","تَتَح پَرَں سَ دْوادَشَشِشْیاناہُویَ بھُوتانْ تْیاجَیِتُں روگانْ پْرَتِکَرْتُّنْچَ تیبھْیَح شَکْتِمادھِپَتْیَنْچَ دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","اَپَرَنْچَ اِیشْوَرِییَراجْیَسْیَ سُسَںوادَں پْرَکاشَیِتُمْ روگِناماروگْیَں کَرْتُّنْچَ پْریرَنَکالے تانْ جَگادَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","یاتْرارْتھَں یَشْٹِ رْوَسْتْرَپُٹَکَں بھَکْشْیَں مُدْرا دْوِتِییَوَسْتْرَمْ، ایشاں کِمَپِ ما گرِہْلِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","یُویَنْچَ یَنِّویشَنَں پْرَوِشَتھَ نَگَرَتْیاگَپَرْیَّنَتَں تَنِّویشَنے تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","تَتْرَ یَدِ کَسْیَچِتْ پُرَسْیَ لوکا یُشْماکَماتِتھْیَں نَ کُرْوَّنْتِ تَرْہِ تَسْمانَّگَرادْ گَمَنَکالے تیشاں وِرُدّھَں ساکْشْیارْتھَں یُشْماکَں پَدَدھُولِیح سَمْپاتَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","اَتھَ تے پْرَسْتھایَ سَرْوَّتْرَ سُسَںوادَں پْرَچارَیِتُں پِیڈِتانْ سْوَسْتھانْ کَرْتُّنْچَ گْرامیشُ بھْرَمِتُں پْراریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ایتَرْہِ ہیرودْ راجا یِیشوح سَرْوَّکَرْمَّناں وارْتّاں شْرُتْوا بھرِشَمُدْوِوِجی ");
INSERT INTO sanurd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","یَتَح کیچِدُوچُرْیوہَنْ شْمَشانادُدَتِشْٹھَتْ۔ کیچِدُوچُح، ایلِیو دَرْشَنَں دَتَّوانْ؛ ایوَمَنْیَلوکا اُوچُح پُورْوِّییَح کَشْچِدْ بھَوِشْیَدْوادِی سَمُتّھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","کِنْتُ ہیرودُواچَ یوہَنَح شِروہَمَچھِنَدَمْ اِدانِیں یَسْییدرِکَّرْمَّناں وارْتّاں پْراپْنومِ سَ کَح؟ اَتھَ سَ تَں دْرَشْٹُمْ اَیچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","اَنَنْتَرَں پْریرِتاح پْرَتْیاگَتْیَ یانِ یانِ کَرْمّانِ چَکْرُسْتانِ یِیشَوے کَتھَیاماسُح تَتَح سَ تانْ بَیتْسَیدانامَکَنَگَرَسْیَ وِجَنَں سْتھانَں نِیتْوا گُپْتَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","پَشْچالْ لوکاسْتَدْ وِدِتْوا تَسْیَ پَشْچادْ یَیُح؛ تَتَح سَ تانْ نَیَنْ اِیشْوَرِییَراجْیَسْیَ پْرَسَنْگَمُکْتَوانْ، ییشاں چِکِتْسَیا پْرَیوجَنَمْ آسِیتْ تانْ سْوَسْتھانْ چَکارَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","اَپَرَنْچَ دِواوَسَنّے سَتِ دْوادَشَشِشْیا یِیشورَنْتِکَمْ ایتْیَ کَتھَیاماسُح، وَیَمَتْرَ پْرانْتَرَسْتھانے تِشْٹھامَح، تَتو نَگَرانِ گْرامانِ گَتْوا واسَسْتھانانِ پْراپْیَ بھَکْشْیَدْرَوْیانِ کْریتُں جَنَنِوَہَں بھَوانْ وِسرِجَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","تَدا سَ اُواچَ، یُویَمیوَ تانْ بھیجَیَدھْوَں؛ تَتَسْتے پْروچُرَسْماکَں نِکَٹے کیوَلَں پَنْچَ پُوپا دْوَو مَتْسْیَو چَ وِدْیَنْتے، اَتَایوَ سْتھانانْتَرَمْ اِتْوا نِمِتَّمیتیشاں بھَکْشْیَدْرَوْییشُ نَ کْرِیتیشُ نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","تَتْرَ پْرایینَ پَنْچَسَہَسْرانِ پُرُشا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","تَدا سَ شِشْیانْ جَگادَ پَنْچاشَتْ پَنْچاشَجَّنَیح پَںکْتِیکرِتْیَ تانُپَویشَیَتَ، تَسْماتْ تے تَدَنُسارینَ سَرْوَّلوکانُپَویشَیاپاسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","تَتَح سَ تانْ پَنْچَ پُوپانْ مِینَدْوَیَنْچَ گرِہِیتْوا سْوَرْگَں وِلوکْییشْوَرَگُنانْ کِیرْتَّیانْچَکْرے بھَنْکْتا چَ لوکیبھْیَح پَرِویشَنارْتھَں شِشْییشُ سَمَرْپَیامْبَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","تَتَح سَرْوّے بھُکْتْوا ترِپْتِں گَتا اَوَشِشْٹانانْچَ دْوادَشَ ڈَلَّکانْ سَںجَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","اَتھَیکَدا نِرْجَنے شِشْیَیح سَہَ پْرارْتھَناکالے تانْ پَپْرَچّھَ، لوکا ماں کَں وَدَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","تَتَسْتے پْراچُح، تْواں یوہَنْمَجَّکَں وَدَنْتِ؛ کیچِتْ تْوامْ ایلِیَں وَدَنْتِ، پُورْوَّکالِکَح کَشْچِدْ بھَوِشْیَدْوادِی شْمَشانادْ اُدَتِشْٹھَدْ اِتْیَپِ کیچِدْ وَدَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","تَدا سَ اُواچَ، یُویَں ماں کَں وَدَتھَ؟ تَتَح پِتَرَ اُکْتَوانْ تْوَمْ اِیشْوَرابھِشِکْتَح پُرُشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","تَدا سَ تانْ درِڈھَمادِدیشَ، کَتھامیتاں کَسْمَیچِدَپِ ما کَتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","سَ پُنَرُواچَ، مَنُشْیَپُتْرینَ وَہُیاتَنا بھوکْتَوْیاح پْراچِینَلوکَیح پْرَدھانَیاجَکَیرَدھْیاپَکَیشْچَ سووَجْنایَ ہَنْتَوْیَح کِنْتُ ترِتِییَدِوَسے شْمَشاناتْ تینوتّھاتَوْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","اَپَرَں سَ سَرْوّانُواچَ، کَشْچِدْ یَدِ مَمَ پَشْچادْ گَنْتُں وانْچھَتِ تَرْہِ سَ سْوَں دامْیَتُ، دِنے دِنے کْرُشَں گرِہِیتْوا چَ مَمَ پَشْچاداگَچّھَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","یَتو یَح کَشْچِتْ سْوَپْرانانْ رِرَکْشِشَتِ سَ تانْ ہارَیِشْیَتِ، یَح کَشْچِنْ مَدَرْتھَں پْرانانْ ہارَیِشْیَتِ سَ تانْ رَکْشِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","کَشْچِدْ یَدِ سَرْوَّں جَگَتْ پْراپْنوتِ کِنْتُ سْوَپْرانانْ ہارَیَتِ سْوَیَں وِنَشْیَتِ چَ تَرْہِ تَسْیَ کو لابھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","پُنَ رْیَح کَشْچِنْ ماں مَمَ واکْیَں وا لَجّاسْپَدَں جاناتِ مَنُشْیَپُتْرو یَدا سْوَسْیَ پِتُشْچَ پَوِتْراناں دُوتانانْچَ تیجوبھِح پَرِویشْٹِتَ آگَمِشْیَتِ تَدا سوپِ تَں لَجّاسْپَدَں جْناسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","کِنْتُ یُشْمانَہَں یَتھارْتھَں وَدامِ، اِیشْوَرِییَراجَتْوَں نَ درِشْٹَوا مرِتْیُں ناسْوادِشْیَنْتے، ایتادرِشاح کِیَنْتو لوکا اَتْرَ سْتھَنےپِ دَنْڈایَماناح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ایتَداکھْیانَکَتھَناتْ پَرَں پْراییناشْٹَسُ دِنیشُ گَتیشُ سَ پِتَرَں یوہَنَں یاکُوبَنْچَ گرِہِیتْوا پْرارْتھَیِتُں پَرْوَّتَمیکَں سَمارُروہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","اَتھَ تَسْیَ پْرارْتھَنَکالے تَسْیَ مُکھاکرِتِرَنْیَرُوپا جاتا، تَدِییَں وَسْتْرَمُجّوَلَشُکْلَں جاتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","اَپَرَنْچَ مُوسا ایلِیَشْچوبھَو تیجَسْوِنَو درِشْٹَو ");
INSERT INTO sanurd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","تَو تینَ یِرُوشالَمْپُرے یو مرِتْیُح سادھِشْیَتے تَدِییاں کَتھاں تینَ سارْدّھَں کَتھَیِتُمْ آریبھاتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","تَدا پِتَرادَیَح سْوَسْیَ سَنْگِنو نِدْرَیاکرِشْٹا آسَنْ کِنْتُ جاگَرِتْوا تَسْیَ تیجَسْتینَ سارْدّھَمْ اُتِّشْٹھَنْتَو جَنَو چَ دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","اَتھَ تَیورُبھَیو رْگَمَنَکالے پِتَرو یِیشُں بَبھاشے، ہے گُروسْماکَں سْتھانےسْمِنْ سْتھِتِح شُبھا، تَتَ ایکا تْوَدَرْتھا، ایکا مُوسارْتھا، ایکا ایلِیارْتھا، اِتِ تِسْرَح کُٹْیوسْمابھِ رْنِرْمِّییَنْتاں، اِماں کَتھاں سَ نَ وِوِچْیَ کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","اَپَرَنْچَ تَدْواکْیَوَدَنَکالے پَیودَ ایکَ آگَتْیَ تیشامُپَرِ چھایاں چَکارَ، تَتَسْتَنْمَدھْیے تَیوح پْرَویشاتْ تے شَشَنْکِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","تَدا تَسْماتْ پَیودادْ اِیَماکاشِییا وانِی نِرْجَگامَ، مَمایَں پْرِیَح پُتْرَ ایتَسْیَ کَتھایاں مَنو نِدھَتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","اِتِ شَبْدے جاتے تے یِیشُمیکاکِنَں دَدرِشُح کِنْتُ تے تَدانِیں تَسْیَ دَرْشَنَسْیَ واچَمیکامَپِ نوکْتْوا مَنَحسُ سْتھاپَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","پَرےہَنِ تیشُ تَسْماچّھَیلادْ اَوَرُوڈھیشُ تَں ساکْشاتْ کَرْتُّں بَہَوو لوکا آجَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","تیشاں مَدھْیادْ ایکو جَنَ اُچَّیرُواچَ، ہے گُرو اَہَں وِنَیَں کَرومِ مَمَ پُتْرَں پْرَتِ کرِپادرِشْٹِں کَروتُ، مَمَ سَ ایوَیکَح پُتْرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","بھُوتینَ دھرِتَح سَنْ سَں پْرَسَبھَں چِیچّھَبْدَں کَروتِ تَنْمُکھاتْ پھینا نِرْگَچّھَنْتِ چَ، بھُوتَ اِتّھَں وِدارْیَّ کْلِشْٹْوا پْرایَشَسْتَں نَ تْیَجَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","تَسْماتْ تَں بھُوتَں تْیاجَیِتُں تَوَ شِشْیَسَمِیپے نْیَویدَیَں کِنْتُ تے نَ شیکُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","تَدا یِیشُرَوادِیتْ، رے آوِشْواسِنْ وِپَتھَگامِنْ وَںشَ کَتِکالانْ یُشْمابھِح سَہَ سْتھاسْیامْیَہَں یُشْماکَمْ آچَرَنانِ چَ سَہِشْیے؟ تَوَ پُتْرَمِہانَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","تَتَسْتَسْمِنّاگَتَماتْرے بھُوتَسْتَں بھُومَو پاتَیِتْوا وِدَدارَ؛ تَدا یِیشُسْتَمَمیدھْیَں بھُوتَں تَرْجَیِتْوا بالَکَں سْوَسْتھَں کرِتْوا تَسْیَ پِتَرِ سَمَرْپَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","اِیشْوَرَسْیَ مَہاشَکْتِمْ اِماں وِلوکْیَ سَرْوّے چَمَچَّکْرُح؛ اِتّھَں یِیشوح سَرْوّابھِح کْرِیابھِح سَرْوَّیرْلوکَیراشْچَرْیّے مَنْیَمانے سَتِ سَ شِشْیانْ بَبھاشے، ");
INSERT INTO sanurd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","کَتھییَں یُشْماکَں کَرْنیشُ پْرَوِشَتُ، مَنُشْیَپُتْرو مَنُشْیاناں کَریشُ سَمَرْپَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","کِنْتُ تے تاں کَتھاں نَ بُبُدھِرے، سْپَشْٹَتْوابھاواتْ تَسْیا اَبھِپْرایَسْتیشاں بودھَگَمْیو نَ بَبھُووَ؛ تَسْیا آشَیَح کَ اِتْیَپِ تے بھَیاتْ پْرَشْٹُں نَ شیکُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","تَدَنَنْتَرَں تیشاں مَدھْیے کَح شْریشْٹھَح کَتھامیتاں گرِہِیتْوا تے مِتھو وِوادَں چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","تَتو یِیشُسْتیشاں مَنوبھِپْرایَں وِدِتْوا بالَکَمیکَں گرِہِیتْوا سْوَسْیَ نِکَٹے سْتھاپَیِتْوا تانْ جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","یو جَنو مَمَ نامْناسْیَ بالاسْیاتِتھْیَں وِدَدھاتِ سَ مَماتِتھْیَں وِدَدھاتِ، یَشْچَ مَماتِتھْیَں وِدَدھاتِ سَ مَمَ پْریرَکَسْیاتِتھْیَں وِدَدھاتِ، یُشْماکَں مَدھْیییَح سْوَں سَرْوَّسْماتْ کْشُدْرَں جانِیتے سَ ایوَ شْریشْٹھو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","اَپَرَنْچَ یوہَنْ وْیاجَہارَ ہے پْرَبھےा تَوَ نامْنا بھُوتانْ تْیاجَیَنْتَں مانُشَمْ ایکَں درِشْٹَوَنْتو وَیَں، کِنْتْوَسْماکَمْ اَپَشْچادْ گامِتْواتْ تَں نْیَشیدھامْ۔ تَدانِیں یِیشُرُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","تَں ما نِشیدھَتَ، یَتو یو جَنوسْماکَں نَ وِپَکْشَح سَ ایواسْماکَں سَپَکْشو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","اَنَنْتَرَں تَسْیاروہَنَسَمَیَ اُپَسْتھِتے سَ سْتھِرَچیتا یِرُوشالَمَں پْرَتِ یاتْراں کَرْتُّں نِشْچِتْیاگْرے دُوتانْ پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","تَسْماتْ تے گَتْوا تَسْیَ پْرَیوجَنِییَدْرَوْیانِ سَںگْرَہِیتُں شومِرونِییاناں گْرامَں پْرَوِوِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","کِنْتُ سَ یِرُوشالَمَں نَگَرَں یاتِ تَتو ہیتو رْلوکاسْتَسْیاتِتھْیَں نَ چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","اَتَایوَ یاکُوبْیوہَنَو تَسْیَ شِشْیَو تَدْ درِشْٹْوا جَگَدَتُح، ہے پْرَبھو ایلِیو یَتھا چَکارَ تَتھا وَیَمَپِ کِں گَگَنادْ آگَنْتُمْ ایتانْ بھَسْمِیکَرْتُّنْچَ وَہْنِماجْناپَیامَح؟ بھَوانْ کِمِچّھَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","کِنْتُ سَ مُکھَں پَراوَرْتْیَ تانْ تَرْجَیِتْوا گَدِتَوانْ یُشْماکَں مَنوبھاوَح کَح، اِتِ یُویَں نَ جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","مَنُجَسُتو مَنُجاناں پْرانانْ ناشَیِتُں ناگَچّھَتْ، کِنْتُ رَکْشِتُمْ آگَچّھَتْ۔ پَشْچادْ اِتَرَگْرامَں تے یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","تَدَنَنْتَرَں پَتھِ گَمَنَکالے جَنَ ایکَسْتَں بَبھاشے، ہے پْرَبھو بھَوانْ یَتْرَ یاتِ بھَوَتا سَہاہَمَپِ تَتْرَ یاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","تَدانِیں یِیشُسْتَمُواچَ، گومایُوناں گَرْتّا آسَتے، وِہایَسِییَوِہَگاाناں نِیڈانِ چَ سَنْتِ، کِنْتُ مانَوَتَنَیَسْیَ شِرَح سْتھاپَیِتُں سْتھانَں ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","تَتَح پَرَں سَ اِتَرَجَنَں جَگادَ، تْوَں مَمَ پَشْچادْ ایہِ؛ تَتَح سَ اُواچَ، ہے پْرَبھو پُورْوَّں پِتَرَں شْمَشانے سْتھاپَیِتُں مامادِشَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","تَدا یِیشُرُواچَ، مرِتا مرِتانْ شْمَشانے سْتھاپَیَنْتُ کِنْتُ تْوَں گَتْویشْوَرِییَراجْیَسْیَ کَتھاں پْرَچارَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","تَتونْیَح کَتھَیاماسَ، ہے پْرَبھو مَیاپِ بھَوَتَح پَشْچادْ گَںسْیَتے، کِنْتُ پُورْوَّں مَمَ نِویشَنَسْیَ پَرِجَنانامْ اَنُمَتِں گْرَہِیتُمْ اَہَمادِشْیَے بھَوَتا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","تَدانِیں یِیشُسْتَں پْروکْتَوانْ، یو جَنو لانْگَلے کَرَمَرْپَیِتْوا پَشْچاتْ پَشْیَتِ سَ اِیشْوَرِییَراجْیَں نارْہَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","تَتَح پَرَں پْرَبھُرَپَرانْ سَپْتَتِشِشْیانْ نِیُجْیَ سْوَیَں یانِ نَگَرانِ یانِ سْتھانانِ چَ گَمِشْیَتِ تانِ نَگَرانِ تانِ سْتھانانِ چَ پْرَتِ دْوَو دْوَو جَنَو پْرَہِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","تیبھْیَح کَتھَیاماسَ چَ شَسْیانِ بَہُونِیتِ سَتْیَں کِنْتُ چھیدَکا اَلْپے؛ تَسْمادّھیتوح شَسْیَکْشیتْرے چھیدَکانْ اَپَرانَپِ پْریشَیِتُں کْشیتْرَسْوامِنَں پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","یُویَں یاتَ، پَشْیَتَ، ورِکاناں مَدھْیے میشَشاوَکانِوَ یُشْمانْ پْرَہِنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","یُویَں کْشُدْرَں مَہَدْ وا وَسَنَسَمْپُٹَکَں پادُکاشْچَ ما گرِہْلِیتَ، مارْگَمَدھْیے کَمَپِ ما نَمَتَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","اَپَرَنْچَ یُویَں یَدْ یَتْ نِویشَنَں پْرَوِشَتھَ تَتْرَ نِویشَنَسْیاسْیَ مَنْگَلَں بھُویادِتِ واکْیَں پْرَتھَمَں وَدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","تَسْماتْ تَسْمِنْ نِویشَنے یَدِ مَنْگَلَپاتْرَں سْتھاسْیَتِ تَرْہِ تَنْمَنْگَلَں تَسْیَ بھَوِشْیَتِ، نوچیتْ یُشْمانْ پْرَتِ پَراوَرْتِّشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","اَپَرَنْچَ تے یَتْکِنْچِدْ داسْیَنْتِ تَدیوَ بھُکْتْوا پِیتْوا تَسْمِنِّویشَنے سْتھاسْیَتھَ؛ یَتَح کَرْمَّکارِی جَنو بھرِتِمْ اَرْہَتِ؛ گرِہادْ گرِہَں ما یاسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","اَنْیَچَّ یُشْماسُ کِمَپِ نَگَرَں پْرَوِشْٹیشُ لوکا یَدِ یُشْماکَمْ آتِتھْیَں کَرِشْیَنْتِ، تَرْہِ یَتْ کھادْیَمْ اُپَسْتھاسْیَنْتِ تَدیوَ کھادِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","تَنَّگَرَسْتھانْ روگِنَح سْوَسْتھانْ کَرِشْیَتھَ، اِیشْوَرِییَں راجْیَں یُشْماکَمْ اَنْتِکَمْ آگَمَتْ کَتھامیتانْچَ پْرَچارَیِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","کِنْتُ کِمَپِ پُرَں یُشْماسُ پْرَوِشْٹیشُ لوکا یَدِ یُشْماکَمْ آتِتھْیَں نَ کَرِشْیَنْتِ، تَرْہِ تَسْیَ نَگَرَسْیَ پَنْتھانَں گَتْوا کَتھامیتاں وَدِشْیَتھَ، ");
INSERT INTO sanurd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","یُشْماکَں نَگَرِییا یا دھُولْیوسْماسُ سَمَلَگَنْ تا اَپِ یُشْماکَں پْراتِکُولْیینَ ساکْشْیارْتھَں سَمْپاتَیامَح؛ تَتھاپِیشْوَرَراجْیَں یُشْماکَں سَمِیپَمْ آگَتَمْ اِتِ نِشْچِتَں جانِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","اَہَں یُشْمَبھْیَں یَتھارْتھَں کَتھَیامِ، وِچارَدِنے تَسْیَ نَگَرَسْیَ دَشاتَح سِدومو دَشا سَہْیا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ہا ہا کوراسِینْ نَگَرَ، ہا ہا بَیتْسَیدانَگَرَ یُوَیورْمَدھْیے یادرِشانِ آشْچَرْیّانِ کَرْمّانْیَکْرِیَنْتَ، تانِ کَرْمّانِ یَدِ سورَسِیدونو رْنَگَرَیورَکارِشْیَنْتَ، تَدا اِتو بَہُدِنَپُورْوَّں تَنِّواسِنَح شَنَوَسْتْرانِ پَرِدھایَ گاتْریشُ بھَسْمَ وِلِپْیَ سَمُپَوِشْیَ سَمَکھیتْسْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","اَتو وِچارَدِوَسے یُشْماکَں دَشاتَح سورَسِیدونِّواسِناں دَشا سَہْیا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ہے کَپھَرْناہُومْ، تْوَں سْوَرْگَں یاوَدْ اُنَّتا کِنْتُ نَرَکَں یاوَتْ نْیَگْبھَوِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","یو جَنو یُشْماکَں واکْیَں گرِہْلاتِ سَ مَمَیوَ واکْیَں گرِہْلاتِ؛ کِنْچَ یو جَنو یُشْماکَمْ اَوَجْناں کَروتِ سَ مَمَیواوَجْناں کَروتِ؛ یو جَنو مَماوَجْناں کَروتِ چَ سَ مَتْپْریرَکَسْیَیواوَجْناں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","اَتھَ تے سَپْتَتِشِشْیا آنَنْدینَ پْرَتْیاگَتْیَ کَتھَیاماسُح، ہے پْرَبھو بھَوَتو نامْنا بھُوتا اَپْیَسْماکَں وَشِیبھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","تَدانِیں سَ تانْ جَگادَ، وِدْیُتَمِوَ سْوَرْگاتْ پَتَنْتَں شَیتانَمْ اَدَرْشَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","پَشْیَتَ سَرْپانْ ورِشْچِکانْ رِپوح سَرْوَّپَراکْرَماںشْچَ پَدَتَلَے رْدَلَیِتُں یُشْمَبھْیَں شَکْتِں دَدامِ تَسْمادْ یُشْماکَں کاپِ ہانِ رْنَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","بھُوتا یُشْماکَں وَشِیبھَوَنْتِ، ایتَنِّمِتَّتْ ما سَمُلَّسَتَ، سْوَرْگے یُشْماکَں نامانِ لِکھِتانِ سَنْتِیتِ نِمِتَّں سَمُلَّسَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","تَدْگھَٹِکایاں یِیشُ رْمَنَسِ جاتاہْلادَح کَتھَیاماسَ ہے سْوَرْگَپرِتھِوْیوریکادھِپَتے پِتَسْتْوَں جْنانَوَتاں وِدُشانْچَ لوکاناں پُرَسْتاتْ سَرْوَّمیتَدْ اَپْرَکاشْیَ بالَکاناں پُرَسْتاتْ پْراکاشَیَ ایتَسْمادّھیتوسْتْواں دھَنْیَں وَدامِ، ہے پِتَرِتّھَں بھَوَتُ یَدْ ایتَدیوَ تَوَ گوچَرَ اُتَّمَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","پِتْرا سَرْوّانِ مَیِ سَمَرْپِتانِ پِتَرَں وِنا کوپِ پُتْرَں نَ جاناتِ کِنْچَ پُتْرَں وِنا یَسْمَے جَنایَ پُتْرَسْتَں پْرَکاشِتَوانْ تَنْچَ وِنا کوپِ پِتَرَں نَ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","تَپَح پَرَں سَ شِشْیانْ پْرَتِ پَراورِتْیَ گُپْتَں جَگادَ، یُویَمیتانِ سَرْوّانِ پَشْیَتھَ تَتو یُشْماکَں چَکْشُوںشِ دھَنْیانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","یُشْمانَہَں وَدامِ، یُویَں یانِ سَرْوّانِ پَشْیَتھَ تانِ بَہَوو بھَوِشْیَدْوادِنو بھُوپَتَیَشْچَ دْرَشْٹُمِچّھَنْتوپِ دْرَشْٹُں نَ پْراپْنُوَنْ، یُشْمابھِ رْیا یاح کَتھاشْچَ شْرُویَنْتے تاح شْروتُمِچّھَنْتوپِ شْروتُں نالَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","اَنَنْتَرَمْ ایکو وْیَوَسْتھاپَکَ اُتّھایَ تَں پَرِیکْشِتُں پَپْرَچّھَ، ہے اُپَدیشَکَ اَنَنْتایُشَح پْراپْتَیے مَیا کِں کَرَنِییَں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","یِیشُح پْرَتْیُواچَ، اَتْرارْتھے وْیَوَسْتھایاں کِں لِکھِتَمَسْتِ؟ تْوَں کِیدرِکْ پَٹھَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","تَتَح سووَدَتْ، تْوَں سَرْوّانْتَحکَرَنَیح سَرْوَّپْرانَیح سَرْوَّشَکْتِبھِح سَرْوَّچِتَّیشْچَ پْرَبھَو پَرَمیشْوَرے پْریمَ کُرُ، سَمِیپَواسِنِ سْوَوَتْ پْریمَ کُرُ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","تَدا سَ کَتھَیاماسَ، تْوَں یَتھارْتھَں پْرَتْیَووچَح، اِتّھَمْ آچَرَ تینَیوَ جِیوِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","کِنْتُ سَ جَنَح سْوَں نِرْدّوشَں جْناپَیِتُں یِیشُں پَپْرَچّھَ، مَمَ سَمِیپَواسِی کَح؟ تَتو یِیشُح پْرَتْیُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ایکو جَنو یِرُوشالَمْپُرادْ یِرِیہوپُرَں یاتِ، ایتَرْہِ دَسْیُوناں کَریشُ پَتِتے تے تَسْیَ وَسْتْرادِکَں ہرِتَوَنْتَح تَماہَتْیَ مرِتَپْرایَں کرِتْوا تْیَکْتْوا یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","اَکَسْمادْ ایکو یاجَکَسْتینَ مارْگینَ گَچّھَنْ تَں درِشْٹْوا مارْگانْیَپارْشْوینَ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","اِتّھَمْ ایکو لیوِییَسْتَتْسْتھانَں پْراپْیَ تَسْیانْتِکَں گَتْوا تَں وِلوکْیانْیینَ پارْشْوینَ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","کِنْتْویکَح شومِرونِییو گَچّھَنْ تَتْسْتھانَں پْراپْیَ تَں درِشْٹْوادَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","تَسْیانْتِکَں گَتْوا تَسْیَ کْشَتیشُ تَیلَں دْراکْشارَسَنْچَ پْرَکْشِپْیَ کْشَتانِ بَدّھوا نِجَواہَنوپَرِ تَمُپَویشْیَ پْرَواسِییَگرِہَمْ آنِییَ تَں سِشیوے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","پَرَسْمِنْ دِوَسے نِجَگَمَنَکالے دْوَو مُدْراپادَو تَدْگرِہَسْوامِنے دَتّواوَدَتْ جَنَمینَں سیوَسْوَ تَتْرَ یودھِکو وْیَیو بھَوِشْیَتِ تَمَہَں پُنَراگَمَنَکالے پَرِشوتْسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ایشاں تْرَیاناں مَدھْیے تَسْیَ دَسْیُہَسْتَپَتِتَسْیَ جَنَسْیَ سَمِیپَواسِی کَح؟ تْوَیا کِں بُدھْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","تَتَح سَ وْیَوَسْتھاپَکَح کَتھَیاماسَ یَسْتَسْمِنْ دَیاں چَکارَ۔ تَدا یِیشُح کَتھَیاماسَ تْوَمَپِ گَتْوا تَتھاچَرَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","تَتَح پَرَں تے گَچّھَنْتَ ایکَں گْرامَں پْرَوِوِشُح؛ تَدا مَرْتھاناما سْتْرِی سْوَگرِہے تَسْیاتِتھْیَں چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","تَسْماتْ مَرِیَمْ نامَدھییا تَسْیا بھَگِنِی یِیشوح پَدَسَمِیپَ اُوَوِشْیَ تَسْیوپَدیشَکَتھاں شْروتُماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","کِنْتُ مَرْتھا ناناپَرِچَرْیّایاں وْیَگْرا بَبھُووَ تَسْمادّھیتوسْتَسْیَ سَمِیپَماگَتْیَ بَبھاشے؛ ہے پْرَبھو مَمَ بھَگِنِی کیوَلَں مَموپَرِ سَرْوَّکَرْمَّناں بھارَمْ اَرْپِتَوَتِی تَتْرَ بھَوَتا کِنْچِدَپِ نَ مَنو نِدھِییَتے کِمْ؟ مَمَ ساہایَّں کَرْتُّں بھَوانْ تامادِشَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","تَتو یِیشُح پْرَتْیُواچَ ہے مَرْتھے ہے مَرْتھے، تْوَں ناناکارْیّیشُ چِنْتِتَوَتِی وْیَگْرا چاسِ، ");
INSERT INTO sanurd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","کِنْتُ پْرَیوجَنِییَمْ ایکَماتْرَمْ آسْتے۔ اَپَرَنْچَ یَمُتَّمَں بھاگَں کوپِ ہَرْتُّں نَ شَکْنوتِ سَایوَ مَرِیَما ورِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","اَنَنْتَرَں سَ کَسْمِںشْچِتْ سْتھانے پْرارْتھَیَتَ تَتْسَماپْتَو سَتْیاں تَسْیَیکَح شِشْیَسْتَں جَگادَ ہے پْرَبھو یوہَنْ یَتھا سْوَشِشْیانْ پْرارْتھَیِتُمْ اُپَدِشْٹَوانْ تَتھا بھَوانَپْیَسْمانْ اُپَدِشَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","تَسْماتْ سَ کَتھَیاماسَ، پْرارْتھَنَکالے یُویَمْ اِتّھَں کَتھَیَدھْوَں، ہے اَسْماکَں سْوَرْگَسْتھَپِتَسْتَوَ نامَ پُوجْیَں بھَوَتُ؛ تَوَ راجَتْوَں بھَوَتُ؛ سْوَرْگے یَتھا تَتھا پرِتھِوْیامَپِ تَویچّھَیا سَرْوَّں بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","پْرَتْیَہَمْ اَسْماکَں پْرَیوجَنِییَں بھوجْیَں دیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","یَتھا وَیَں سَرْوّانْ اَپَرادھِنَح کْشَمامَہے تَتھا تْوَمَپِ پاپانْیَسْماکَں کْشَمَسْوَ۔ اَسْمانْ پَرِیکْشاں مانَیَ کِنْتُ پاپاتْمَنو رَکْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","پَشْچاتْ سوپَرَمَپِ کَتھِتَوانْ یَدِ یُشْماکَں کَسْیَچِدْ بَنْدھُسْتِشْٹھَتِ نِشِیتھے چَ تَسْیَ سَمِیپَں سَ گَتْوا وَدَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ہے بَنْدھو پَتھِکَ ایکو بَنْدھُ رْمَمَ نِویشَنَمْ آیاتَح کِنْتُ تَسْیاتِتھْیَں کَرْتُّں مَمانْتِکے کِمَپِ ناسْتِ، اَتَایوَ پُوپَتْرَیَں مَہْیَمْ رِنَں دیہِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","تَدا سَ یَدِ گرِہَمَدھْیاتْ پْرَتِوَدَتِ ماں ما کْلِشانَ، اِدانِیں دْوارَں رُدّھَں شَیَنے مَیا سَہَ بالَکاشْچَ تِشْٹھَنْتِ تُبھْیَں داتُمْ اُتّھاتُں نَ شَکْنومِ، ");
INSERT INTO sanurd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","تَرْہِ یُشْمانَہَں وَدامِ، سَ یَدِ مِتْرَتَیا تَسْمَے کِمَپِ داتُں نوتِّشْٹھَتِ تَتھاپِ وارَں وارَں پْرارْتھَناتَ اُتّھاپِتَح سَنْ یَسْمِنْ تَسْیَ پْرَیوجَنَں تَدیوَ داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","اَتَح کارَناتْ کَتھَیامِ، یاچَدھْوَں تَتو یُشْمَبھْیَں داسْیَتے، مرِگَیَدھْوَں تَتَ اُدّیشَں پْراپْسْیَتھَ، دْوارَمْ آہَتَ تَتو یُشْمَبھْیَں دْوارَں موکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","یو یاچَتے سَ پْراپْنوتِ، یو مرِگَیَتے سَ ایوودّیشَں پْراپْنوتِ، یو دْوارَمْ آہَنْتِ تَدَرْتھَں دْوارَں موچْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","پُتْرینَ پُوپے یاچِتے تَسْمَے پاشانَں دَداتِ وا مَتْسْیے یاچِتے تَسْمَے سَرْپَں دَداتِ ");
INSERT INTO sanurd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","وا اَنْڈے یاچِتے تَسْمَے ورِشْچِکَں دَداتِ یُشْماکَں مَدھْیے کَ ایتادرِشَح پِتاسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","تَسْمادیوَ یُویَمَبھَدْرا اَپِ یَدِ سْوَسْوَبالَکیبھْیَ اُتَّمانِ دْرَوْیانِ داتُں جانِیتھَ تَرْہْیَسْماکَں سْوَرْگَسْتھَح پِتا نِجَیاچَکیبھْیَح کِں پَوِتْرَمْ آتْمانَں نَ داسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","اَنَنْتَرَں یِیشُنا کَسْماچِّدْ ایکَسْمِنْ مُوکَبھُوتے تْیاجِتے سَتِ سَ بھُوتَتْیَکْتو مانُشو واکْیَں وَکْتُمْ آریبھے؛ تَتو لوکاح سَکَلا آشْچَرْیَّں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","کِنْتُ تیشاں کیچِدُوچُ رْجَنویَں بالَسِبُوبا اَرْتھادْ بھُوتَراجینَ بھُوتانْ تْیاجَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","تَں پَرِیکْشِتُں کیچِدْ آکاشِییَمْ ایکَں چِہْنَں دَرْشَیِتُں تَں پْرارْتھَیانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","تَدا سَ تیشاں مَنَحکَلْپَناں جْناتْوا کَتھَیاماسَ، کَسْیَچِدْ راجْیَسْیَ لوکا یَدِ پَرَسْپَرَں وِرُنْدھَنْتِ تَرْہِ تَدْ راجْیَمْ نَشْیَتِ؛ کیچِدْ گرِہَسْتھا یَدِ پَرَسْپَرَں وِرُنْدھَنْتِ تَرْہِ تیپِ نَشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","تَتھَیوَ شَیتانَپِ سْوَلوکانْ یَدِ وِرُنَدّھِ تَدا تَسْیَ راجْیَں کَتھَں سْتھاسْیَتِ؟ بالَسِبُوباہَں بھُوتانْ تْیاجَیامِ یُویَمِتِ وَدَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","یَدْیَہَں بالَسِبُوبا بھُوتانْ تْیاجَیامِ تَرْہِ یُشْماکَں سَنْتاناح کینَ تْیاجَیَنْتِ؟ تَسْماتْ تَایوَ کَتھایا ایتَسْیا وِچارَیِتارو بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","کِنْتُ یَدْیَہَمْ اِیشْوَرَسْیَ پَراکْرَمینَ بھُوتانْ تْیاجَیامِ تَرْہِ یُشْماکَں نِکَٹَمْ اِیشْوَرَسْیَ راجْیَمَوَشْیَمْ اُپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","بَلَوانْ پُمانْ سُسَجَّمانو یَتِکالَں نِجاٹّالِکاں رَکْشَتِ تَتِکالَں تَسْیَ دْرَوْیَں نِرُپَدْرَوَں تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","کِنْتُ تَسْمادْ اَدھِکَبَلَح کَشْچِداگَتْیَ یَدِ تَں جَیَتِ تَرْہِ ییشُ شَسْتْراسْتْریشُ تَسْیَ وِشْواسَ آسِیتْ تانِ سَرْوّانِ ہرِتْوا تَسْیَ دْرَوْیانِ گرِہْلاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","اَتَح کارَنادْ یو مَمَ سَپَکْشو نَ سَ وِپَکْشَح، یو مَیا سَہَ نَ سَںگرِہْلاتِ سَ وِکِرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","اَپَرَنْچَ اَمیدھْیَبھُوتو مانُشَسْیانْتَرْنِرْگَتْیَ شُشْکَسْتھانے بھْرانْتْوا وِشْرامَں مرِگَیَتے کِنْتُ نَ پْراپْیَ وَدَتِ مَمَ یَسْمادْ گرِہادْ آگَتوہَں پُنَسْتَدْ گرِہَں پَراورِتْیَ یامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","تَتو گَتْوا تَدْ گرِہَں مارْجِتَں شوبھِتَنْچَ درِشْٹْوا ");
INSERT INTO sanurd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","تَتْکْشَنَمْ اَپَگَتْیَ سْوَسْمادَپِ دُرْمَّتِینْ اَپَرانْ سَپْتَبھُوتانْ سَہانَیَتِ تے چَ تَدْگرِہَں پَوِشْیَ نِوَسَنْتِ۔ تَسْماتْ تَسْیَ مَنُشْیَسْیَ پْرَتھَمَدَشاتَح شیشَدَشا دُحکھَتَرا بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","اَسْیاح کَتھایاح کَتھَنَکالے جَنَتامَدھْیَسْتھا کاچِنّارِی تَمُچَّیحسْوَرَں پْروواچَ، یا یوشِتْ تْواں گَرْبّھےدھارَیَتْ سْتَنْیَمَپایَیَچَّ سَیوَ دھَنْیا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","کِنْتُ سوکَتھَیَتْ یے پَرَمیشْوَرَسْیَ کَتھاں شْرُتْوا تَدَنُرُوپَمْ آچَرَنْتِ تَایوَ دھَنْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","تَتَح پَرَں تَسْیانْتِکے بَہُلوکاناں سَماگَمے جاتے سَ وَکْتُماریبھے، آدھُنِکا دُشْٹَلوکاشْچِہْنَں دْرَشْٹُمِچّھَنْتِ کِنْتُ یُونَسْبھَوِشْیَدْوادِنَشْچِہْنَں وِنانْیَتْ کِنْچِچِّہْنَں تانْ نَ دَرْشَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","یُونَسْ تُ یَتھا نِینِوِییَلوکاناں سَمِیپے چِہْنَرُوپوبھَوَتْ تَتھا وِدْیَمانَلوکانامْ ایشاں سَمِیپے مَنُشْیَپُتْروپِ چِہْنَرُوپو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","وِچارَسَمَیے اِدانِینْتَنَلوکاناں پْراتِکُولْیینَ دَکْشِنَدیشِییا راجْنِی پْروتّھایَ تانْ دوشِنَح کَرِشْیَتِ، یَتَح سا راجْنِی سُلیمانَ اُپَدیشَکَتھاں شْروتُں پرِتھِوْیاح سِیماتَ آگَچّھَتْ کِنْتُ پَشْیَتَ سُلیمانوپِ گُرُتَرَ ایکو جَنوسْمِنْ سْتھانے وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","اَپَرَنْچَ وِچارَسَمَیے نِینِوِییَلوکا اَپِ وَرْتَّمانَکالِکاناں لوکاناں وَیپَرِیتْیینَ پْروتّھایَ تانْ دوشِنَح کَرِشْیَنْتِ، یَتو ہیتوسْتے یُونَسو واکْیاتْ چِتّانِ پَرِوَرْتَّیاماسُح کِنْتُ پَشْیَتَ یُونَسوتِگُرُتَرَ ایکو جَنوسْمِنْ سْتھانے وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","پْرَدِیپَں پْرَجْوالْیَ دْرونَسْیادھَح کُتْراپِ گُپْتَسْتھانے وا کوپِ نَ سْتھاپَیَتِ کِنْتُ گرِہَپْرَویشِبھْیو دِیپْتِں داتَں دِیپادھاروپَرْیّیوَ سْتھاپَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","دیہَسْیَ پْرَدِیپَشْچَکْشُسْتَسْمادیوَ چَکْشُ رْیَدِ پْرَسَنَّں بھَوَتِ تَرْہِ تَوَ سَرْوَّشَرِیرَں دِیپْتِمَدْ بھَوِشْیَتِ کِنْتُ چَکْشُ رْیَدِ مَلِیمَسَں تِشْٹھَتِ تَرْہِ سَرْوَّشَرِیرَں سانْدھَکارَں سْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","اَسْماتْ کارَناتْ تَوانْتَحسْتھَں جْیوتِ رْیَتھانْدھَکارَمَیَں نَ بھَوَتِ تَدَرْتھے ساوَدھانو بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","یَتَح شَرِیرَسْیَ کُتْراپْیَںشے سانْدھَکارے نَ جاتے سَرْوَّں یَدِ دِیپْتِمَتْ تِشْٹھَتِ تَرْہِ تُبھْیَں دِیپْتِدایِپْروجّوَلَنْ پْرَدِیپَ اِوَ تَوَ سَوَرْوَشَرِیرَں دِیپْتِمَدْ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ایتَتْکَتھایاح کَتھَنَکالے پھِرُشْییکو بھیجَنایَ تَں نِمَنْتْرَیاماسَ، تَتَح سَ گَتْوا بھوکْتُمْ اُپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","کِنْتُ بھوجَناتْ پُورْوَّں نامانْکْشِیتْ ایتَدْ درِشْٹْوا سَ پھِرُشْیاشْچَرْیَّں مینے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","تَدا پْرَبھُسْتَں پْروواچَ یُویَں پھِرُوشِلوکاح پانَپاتْراناں بھوجَنَپاتْرانانْچَ بَہِح پَرِشْکُرُتھَ کِنْتُ یُشْماکَمَنْتَ رْدَوراتْمْیَے رْدُشْکْرِیابھِشْچَ پَرِپُورْنَں تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ہے سَرْوّے نِرْبودھا یو بَہِح سَسَرْجَ سَ ایوَ کِمَنْتَ رْنَ سَسَرْجَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","تَتَ ایوَ یُشْمابھِرَنْتَحکَرَنَں (اِیشْوَرایَ) نِویدْیَتاں تَسْمِنْ کرِتے یُشْماکَں سَرْوّانِ شُچِتاں یاسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","کِنْتُ ہَنْتَ پھِرُوشِگَنا یُویَں نْیایَمْ اِیشْوَرے پْریمَ چَ پَرِتْیَجْیَ پودِنایا اَرُدادِیناں سَرْوّیشاں شاکانانْچَ دَشَماںشانْ دَتّھَ کِنْتُ پْرَتھَمَں پالَیِتْوا شیشَسْیالَنْگھَنَں یُشْماکَمْ اُچِتَماسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ہا ہا پھِرُوشِنو یُویَں بھَجَنَگیہے پْروچّاسَنے آپَنیشُ چَ نَمَسْکاریشُ پْرِییَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","وَتَ کَپَٹِنودھْیاپَکاح پھِرُوشِنَشْچَ لوکایَتْ شْمَشانَمْ اَنُپَلَبھْیَ تَدُپَرِ گَچّھَنْتِ یُویَمْ تادرِگَپْرَکاشِتَشْمَشانَوادْ بھَوَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","تَدانِیں وْیَوَسْتھاپَکانامْ ایکا یِیشُمَوَدَتْ، ہے اُپَدیشَکَ واکْیینیدرِشیناسْماسْوَپِ دوشَمْ آروپَیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","تَتَح سَ اُواچَ، ہا ہا وْیَوَسْتھاپَکا یُویَمْ مانُشانامْ اُپَرِ دُحسَہْیانْ بھارانْ نْیَسْیَتھَ کِنْتُ سْوَیَمْ ایکانْگُुلْیاپِ تانْ بھارانْ نَ سْپرِشَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ہَنْتَ یُشْماکَں پُورْوَّپُرُشا یانْ بھَوِشْیَدْوادِنووَدھِشُسْتیشاں شْمَشانانِ یُویَں نِرْمّاتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","تینَیوَ یُویَں سْوَپُورْوَّپُرُشاناں کَرْمّانِ سَںمَنْیَدھْوے تَدیوَ سَپْرَمانَں کُرُتھَ چَ، یَتَسْتے تانَوَدھِشُح یُویَں تیشاں شْمَشانانِ نِرْمّاتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","اَتَایوَ اِیشْوَرَسْیَ شاسْتْرے پْروکْتَمَسْتِ تیشامَنْتِکے بھَوِشْیَدْوادِنَح پْریرِتاںشْچَ پْریشَیِشْیامِ تَتَسْتے تیشاں کاںشْچَنَ ہَنِشْیَنْتِ کاںشْچَنَ تاڈَشْشْیِنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ایتَسْماتْ کارَناتْ ہابِلَح شونِتَپاتَمارَبھْیَ مَنْدِرَیَجْنَویدْیو رْمَدھْیے ہَتَسْیَ سِکھَرِیَسْیَ رَکْتَپاتَپَرْیَّنْتَں ");
INSERT INTO sanurd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","جَگَتَح سرِشْٹِمارَبھْیَ پرِتھِوْیاں بھَوِشْیَدْوادِناں یَتِرَکْتَپاتا جاتاسْتَتِینامْ اَپَرادھَدَنْڈا ایشاں وَرْتَّمانَلوکاناں بھَوِشْیَنْتِ، یُشْمانَہَں نِشْچِتَں وَدامِ سَرْوّے دَنْڈا وَںشَسْیاسْیَ بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ہا ہا وْیَوَسْتھَپَکا یُویَں جْنانَسْیَ کُنْچِکاں ہرِتْوا سْوَیَں نَ پْرَوِشْٹا یے پْرَویشْٹُنْچَ پْرَیاسِنَسْتانَپِ پْرَویشْٹُں وارِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","اِتّھَں کَتھاکَتھَنادْ اَدھْیاپَکاح پھِرُوشِنَشْچَ سَتَرْکاح ");
INSERT INTO sanurd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","سَنْتَسْتَمَپَوَدِتُں تَسْیَ کَتھایا دوشَں دھَرْتَّمِچّھَنْتو ناناکھْیانَکَتھَنایَ تَں پْرَوَرْتَّیِتُں کوپَیِتُنْچَ پْراریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","تَدانِیں لوکاح سَہَسْرَں سَہَسْرَمْ آگَتْیَ سَمُپَسْتھِتاسْتَتَ ایکَیکو نْییشامُپَرِ پَتِتُمْ اُپَچَکْرَمے؛ تَدا یِیشُح شِشْیانْ بَبھاشے، یُویَں پھِرُوشِناں کِنْوَرُوپَکاپَٹْیے وِشیشینَ ساوَدھاناسْتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","یَتو یَنَّ پْرَکاشَیِشْیَتے تَداچّھَنَّں وَسْتُ کِمَپِ ناسْتِ؛ تَتھا یَنَّ جْناسْیَتے تَدْ گُپْتَں وَسْتُ کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","اَنْدھَکارے تِشْٹھَنَتو یاح کَتھا اَکَتھَیَتَ تاح سَرْوّاح کَتھا دِیپْتَو شْروشْیَنْتے نِرْجَنے کَرْنے چَ یَدَکَتھَیَتَ گرِہَپرِشْٹھاتْ تَتْ پْرَچارَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ہے بَنْدھَوو یُشْمانَہَں وَدامِ، یے شَرِیرَسْیَ ناشَں وِنا کِمَپْیَپَرَں کَرْتُّں نَ شَکْرُوَنْتِ تیبھْیو ما بھَیشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","تَرْہِ کَسْمادْ بھیتَوْیَمْ اِتْیَہَں وَدامِ، یَح شَرِیرَں ناشَیِتْوا نَرَکَں نِکْشیپْتُں شَکْنوتِ تَسْمادیوَ بھَیَں کُرُتَ، پُنَرَپِ وَدامِ تَسْمادیوَ بھَیَں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","پَنْچَ چَٹَکَپَکْشِنَح کِں دْوابھْیاں تامْرَکھَنْڈابھْیاں نَ وِکْرِییَنْتے؟ تَتھاپِیشْوَرَسْتیشامْ ایکَمَپِ نَ وِسْمَرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","یُشْماکَں شِرَحکیشا اَپِ گَنِتاح سَنْتِ تَسْماتْ ما وِبھِیتَ بَہُچَٹَکَپَکْشِبھْیوپِ یُویَں بَہُمُولْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","اَپَرَں یُشْمَبھْیَں کَتھَیامِ یَح کَشْچِنْ مانُشاناں ساکْشانْ ماں سْوِیکَروتِ مَنُشْیَپُتْرَ اِیشْوَرَدُوتاناں ساکْشاتْ تَں سْوِیکَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","کِنْتُ یَح کَشْچِنْمانُشاناں ساکْشانْمامْ اَسْوِیکَروتِ تَمْ اِیشْوَرَسْیَ دُوتاناں ساکْشادْ اَہَمْ اَسْوِیکَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","اَنْیَچَّ یَح کَشْچِنْ مَنُجَسُتَسْیَ نِنْدابھاوینَ کانْچِتْ کَتھاں کَتھَیَتِ تَسْیَ تَتْپاپَسْیَ موچَنَں بھَوِشْیَتِ کِنْتُ یَدِ کَشْچِتْ پَوِتْرَمْ آتْمانَں نِنْدَتِ تَرْہِ تَسْیَ تَتْپاپَسْیَ موچَنَں نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","یَدا لوکا یُشْمانْ بھَجَنَگیہَں وِچارَکَرْترِراجْیَکَرْترِناں سَمُّکھَنْچَ نیشْیَنْتِ تَدا کینَ پْرَکارینَ کِمُتَّرَں وَدِشْیَتھَ کِں کَتھَیِشْیَتھَ چیتْیَتْرَ ما چِنْتَیَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","یَتو یُشْمابھِرْیَدْ یَدْ وَکْتَوْیَں تَتْ تَسْمِنْ سَمَیَایوَ پَوِتْرَ آتْما یُشْمانْ شِکْشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","تَتَح پَرَں جَنَتامَدھْیَسْتھَح کَشْچِجَّنَسْتَں جَگادَ ہے گُرو مَیا سَہَ پَیترِکَں دھَنَں وِبھَکْتُں مَمَ بھْراتَرَماجْناپَیَتُ بھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","کِنْتُ سَ تَمَوَدَتْ ہے مَنُشْیَ یُوَیو رْوِچارَں وِبھاگَنْچَ کَرْتُّں ماں کو نِیُکْتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","اَنَنْتَرَں سَ لوکانَوَدَتْ لوبھے ساوَدھاناح سَتَرْکاشْچَ تِشْٹھَتَ، یَتو بَہُسَمْپَتِّپْراپْتْیا مَنُشْیَسْیایُ رْنَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","پَشْچادْ درِشْٹانْتَکَتھامُتّھاپْیَ کَتھَیاماسَ، ایکَسْیَ دھَنِنو بھُومَو بَہُونِ شَسْیانِ جاتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","تَتَح سَ مَنَسا چِنْتَیِتْوا کَتھَیامْبَبھُووَ مَمَیتانِ سَمُتْپَنّانِ دْرَوْیانِ سْتھاپَیِتُں سْتھانَں ناسْتِ کِں کَرِشْیامِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","تَتووَدَدْ اِتّھَں کَرِشْیامِ، مَمَ سَرْوَّبھانْڈاگارانِ بھَنْکْتْوا برِہَدْبھانْڈاگارانِ نِرْمّایَ تَنْمَدھْیے سَرْوَّپھَلانِ دْرَوْیانِ چَ سْتھاپَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","اَپَرَں نِجَمَنو وَدِشْیامِ، ہے مَنو بَہُوَتْسَرارْتھَں نانادْرَوْیانِ سَنْچِتانِ سَنْتِ وِشْرامَں کُرُ بھُکْتْوا پِیتْوا کَوتُکَنْچَ کُرُ۔ کِنْتْوِیشْوَرَسْتَمْ اَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","رے نِرْبودھَ اَدْیَ راتْرَو تَوَ پْراناسْتْوَتّو نیشْیَنْتے تَتَ ایتانِ یانِ دْرَوْیانِ تْوَیاسادِتانِ تانِ کَسْیَ بھَوِشْیَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","اَتَایوَ یَح کَشْچِدْ اِیشْوَرَسْیَ سَمِیپے دھَنَسَنْچَیَمَکرِتْوا کیوَلَں سْوَنِکَٹے سَنْچَیَں کَروتِ سوپِ تادرِشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","اَتھَ سَ شِشْییبھْیَح کَتھَیاماسَ، یُشْمانَہَں وَدامِ، کِں کھادِشْیامَح؟ کِں پَرِدھاسْیامَح؟ اِتْیُکْتْوا جِیوَنَسْیَ شَرِیرَسْیَ چارْتھَں چِنْتاں ما کارْشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","بھَکْشْیاجِّیوَنَں بھُوشَناچّھَرِیرَنْچَ شْریشْٹھَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","کاکَپَکْشِناں کارْیَّں وِچارَیَتَ، تے نَ وَپَنْتِ شَسْیانِ چَ نَ چھِنْدَنْتِ، تیشاں بھانْڈاگارانِ نَ سَنْتِ کوشاشْچَ نَ سَنْتِ، تَتھاپِیشْوَرَسْتیبھْیو بھَکْشْیانِ دَداتِ، یُویَں پَکْشِبھْیَح شْریشْٹھَتَرا نَ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","اَپَرَنْچَ بھاوَیِتْوا نِجایُشَح کْشَنَماتْرَں وَرْدّھَیِتُں شَکْنوتِ، ایتادرِشو لاکو یُشْماکَں مَدھْیے کوسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","اَتَایوَ کْشُدْرَں کارْیَّں سادھَیِتُمْ اَسَمَرْتھا یُویَمْ اَنْیَسْمِنْ کارْیّے کُتو بھاوَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","اَنْیَچَّ کامْپِلَپُشْپَں کَتھَں وَرْدّھَتے تَداپِ وِچارَیَتَ، تَتْ کَنْچَنَ شْرَمَں نَ کَروتِ تَنْتُوںشْچَ نَ جَنَیَتِ کِنْتُ یُشْمَبھْیَں یَتھارْتھَں کَتھَیامِ سُلیمانْ بَہْوَیشْوَرْیّانْوِتوپِ پُشْپَسْیاسْیَ سَدرِشو وِبھُوشِتو ناسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","اَدْیَ کْشیتْرے وَرْتَّمانَں شْوَشْچُولّیاں کْشیپْسْیَمانَں یَتْ ترِنَں، تَسْمَے یَدِیشْوَرَ اِتّھَں بھُوشَیَتِ تَرْہِ ہے اَلْپَپْرَتْیَیِنو یُشْمانَ کِں نَ پَرِدھاپَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","اَتَایوَ کِں کھادِشْیامَح؟ کِں پَرِدھاسْیامَح؟ ایتَدَرْتھَں ما چیشْٹَدھْوَں ما سَںدِگْدھْوَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","جَگَتو دیوارْچَّکا ایتانِ سَرْوّانِ چیشْٹَنَتے؛ ایشُ وَسْتُشُ یُشْماکَں پْرَیوجَنَماسْتے اِتِ یُشْماکَں پِتا جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","اَتَایویشْوَرَسْیَ راجْیارْتھَں سَچیشْٹا بھَوَتَ تَتھا کرِتے سَرْوّانْییتانِ دْرَوْیانِ یُشْمَبھْیَں پْرَدایِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ہے کْشُدْرَمیشَوْرَجَ یُویَں ما بھَیشْٹَ یُشْمَبھْیَں راجْیَں داتُں یُشْماکَں پِتُح سَمَّتِرَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","اَتَایوَ یُشْماکَں یا یا سَمْپَتِّرَسْتِ تاں تاں وِکْرِییَ وِتَرَتَ، یَتْ سْتھانَں چَورا ناگَچّھَنْتِ، کِیٹاشْچَ نَ کْشایَیَنْتِ تادرِشے سْوَرْگے نِجارْتھَمْ اَجَرے سَمْپُٹَکے کْشَیَں دھَنَں سَنْچِنُتَ چَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","یَتو یَتْرَ یُشْماکَں دھَنَں وَرْتَّتے تَتْریوَ یُشْماکَں مَنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","اَپَرَنْچَ یُویَں پْرَدِیپَں جْوالَیِتْوا بَدّھَکَٹَیَسْتِشْٹھَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","پْرَبھُ رْوِواہاداگَتْیَ یَدَیوَ دْوارَماہَنْتِ تَدَیوَ دْوارَں موچَیِتُں یَتھا بھرِتْیا اَپیکْشْیَ تِشْٹھَنْتِ تَتھا یُویَمَپِ تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","یَتَح پْرَبھُراگَتْیَ یانْ داسانْ سَچیتَنانْ تِشْٹھَتو دْرَکْشْیَتِ تَایوَ دھَنْیاح؛ اَہَں یُشْمانْ یَتھارْتھَں وَدامِ پْرَبھُسْتانْ بھوجَنارْتھَمْ اُپَویشْیَ سْوَیَں بَدّھَکَٹِح سَمِیپَمیتْیَ پَرِویشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","یَدِ دْوِتِییے ترِتِییے وا پْرَہَرے سَماگَتْیَ تَتھَیوَ پَشْیَتِ، تَرْہِ تَایوَ داسا دھَنْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","اَپَرَنْچَ کَسْمِنْ کْشَنے چَورا آگَمِشْیَنْتِ اِتِ یَدِ گرِہَپَتِ رْجْناتُں شَکْنوتِ تَداوَشْیَں جاگْرَنْ نِجَگرِہے سَنْدھِں کَرْتَّیِتُں وارَیَتِ یُویَمیتَدْ وِتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","اَتَایوَ یُویَمَپِ سَجَّماناسْتِشْٹھَتَ یَتو یَسْمِنْ کْشَنے تَں ناپْریکْشَدھْوے تَسْمِنّیوَ کْشَنے مَنُشْیَپُتْرَ آگَمِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","تَدا پِتَرَح پَپْرَچّھَ، ہے پْرَبھو بھَوانْ کِمَسْمانْ اُدِّشْیَ کِں سَرْوّانْ اُدِّشْیَ درِشْٹانْتَکَتھامِماں وَدَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","تَتَح پْرَبھُح پْروواچَ، پْرَبھُح سَمُچِتَکالے نِجَپَرِوارارْتھَں بھوجْیَپَرِویشَنایَ یَں تَتْپَدے نِیوکْشْیَتِ تادرِشو وِشْواسْیو بودّھا کَرْمّادھِیشَح کوسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","پْرَبھُراگَتْیَ یَمْ ایتادرِشے کَرْمَّنِ پْرَورِتَّں دْرَکْشْیَتِ سَایوَ داسو دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","اَہَں یُشْمانْ یَتھارْتھَں وَدامِ سَ تَں نِجَسَرْوَّسْوَسْیادھِپَتِں کَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","کِنْتُ پْرَبھُرْوِلَمْبیناگَمِشْیَتِ، اِتِ وِچِنْتْیَ سَ داسو یَدِ تَدَنْیَداسِیداسانْ پْرَہَرْتُّمْ بھوکْتُں پاتُں مَدِتُنْچَ پْرارَبھَتے، ");
INSERT INTO sanurd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","تَرْہِ یَدا پْرَبھُں ناپیکْشِشْیَتے یَسْمِنْ کْشَنے سوچیتَنَشْچَ سْتھاسْیَتِ تَسْمِنّیوَ کْشَنے تَسْیَ پْرَبھُراگَتْیَ تَں پَدَبھْرَشْٹَں کرِتْوا وِشْواسَہِینَیح سَہَ تَسْیَ اَںشَں نِرُوپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","یو داسَح پْرَبھےाراجْناں جْناتْواپِ سَجِّتو نَ تِشْٹھَتِ تَداجْنانُسارینَ چَ کارْیَّں نَ کَروتِ سونیکانْ پْرَہارانْ پْراپْسْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","کِنْتُ یو جَنوجْناتْوا پْرَہارارْہَں کَرْمَّ کَروتِ سولْپَپْرَہارانْ پْراپْسْیَتِ۔ یَتو یَسْمَے باہُلْیینَ دَتَّں تَسْمادیوَ باہُلْیینَ گْرَہِیشْیَتے، مانُشا یَسْیَ نِکَٹے بَہُ سَمَرْپَیَنْتِ تَسْمادْ بَہُ یاچَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","اَہَں پرِتھِوْیامْ اَنَیکْیَرُوپَں وَہْنِ نِکْشیپْتُمْ آگَتوسْمِ، سَ چیدْ اِدانِیمیوَ پْرَجْوَلَتِ تَتْرَ مَمَ کا چِنْتا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","کِنْتُ یینَ مَجَّنیناہَں مَگْنو بھَوِشْیامِ یاوَتْکالَں تَسْیَ سِدّھِ رْنَ بھَوِشْیَتِ تاوَدَہَں کَتِکَشْٹَں پْراپْسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","میلَنَں کَرْتُّں جَگَدْ آگَتوسْمِ یُویَں کِمِتّھَں بودھَدھْوے؟ یُشْمانْ وَدامِ نَ تَتھا، کِنْتْوَہَں میلَنابھاوَں کَرْتُّںمْ آگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","یَسْمادیتَتْکالَمارَبھْیَ ایکَتْرَسْتھَپَرِجَناناں مَدھْیے پَنْچَجَناح پرِتھَگْ بھُوتْوا تْرَیو جَنا دْوَیورْجَنَیوح پْرَتِکُولا دْوَو جَنَو چَ تْرَیاناں جَناناں پْرَتِکُولَو بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","پِتا پُتْرَسْیَ وِپَکْشَح پُتْرَشْچَ پِتُ رْوِپَکْشو بھَوِشْیَتِ ماتا کَنْیایا وِپَکْشا کَنْیا چَ ماتُ رْوِپَکْشا بھَوِشْیَتِ، تَتھا شْوَشْرُورْبَدھْوا وِپَکْشا بَدھُوشْچَ شْوَشْرْوا وِپَکْشا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","سَ لوکیبھْیوپَرَمَپِ کَتھَیاماسَ، پَشْچِمَدِشِ میگھودْگَمَں درِشْٹْوا یُویَں ہَٹھادْ وَدَتھَ ورِشْٹِ رْبھَوِشْیَتِ تَتَسْتَتھَیوَ جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","اَپَرَں دَکْشِنَتو وایَو واتِ سَتِ وَدَتھَ نِداگھو بھَوِشْیَتِ تَتَح سوپِ جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","رے رے کَپَٹِنَ آکاشَسْیَ بھُومْیاشْچَ لَکْشَنَں بودّھُں شَکْنُتھَ، ");
INSERT INTO sanurd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","کِنْتُ کالَسْیاسْیَ لَکْشَنَں کُتو بودّھُں نَ شَکْنُتھَ؟ یُویَنْچَ سْوَیَں کُتو نَ نْیاشْیَں وِچارَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","اَپَرَنْچَ وِوادِنا سارْدّھَں وِچارَیِتُح سَمِیپَں گَچّھَنْ پَتھِ تَسْمادُدّھارَں پْراپْتُں یَتَسْوَ نوچیتْ سَ تْواں دھرِتْوا وِچارَیِتُح سَمِیپَں نَیَتِ۔ وِچارَیِتا یَدِ تْواں پْرَہَرْتُّح سَمِیپَں سَمَرْپَیَتِ پْرَہَرْتّا تْواں کارایاں بَدھْناتِ ");
INSERT INTO sanurd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","تَرْہِ تْوامَہَں وَدامِ تْوَیا نِحشیشَں کَپَرْدَکیشُ نَ پَرِشودھِتیشُ تْوَں تَتو مُکْتِں پْراپْتُں نَ شَکْشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","اَپَرَنْچَ پِیلاتو ییشاں گالِیلِییاناں رَکْتانِ بَلِیناں رَکْتَیح سَہامِشْرَیَتْ تیشاں گالِیلِییاناں ورِتّانْتَں کَتِپَیَجَنا اُپَسْتھاپْیَ یِیشَوے کَتھَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","تَتَح سَ پْرَتْیُواچَ تیشاں لوکانامْ ایتادرِشِی دُرْگَتِ رْگھَٹِتا تَتْکارَنادْ یُویَں کِمَنْییبھْیو گالِیلِیییبھْیوپْیَدھِکَپاپِنَسْتانْ بودھَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","یُشْمانَہَں وَدامِ تَتھا نَ کِنْتُ مَنَحسُ نَ پَراوَرْتِّتیشُ یُویَمَپِ تَتھا نَںکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","اَپَرَنْچَ شِیلوہَنامْنَ اُچَّگرِہَسْیَ پَتَنادْ یےشْٹادَشَجَنا مرِتاسْتے یِرُوشالَمِ نِواسِسَرْوَّلوکیبھْیودھِکاپَرادھِنَح کِں یُویَمِتْیَں بودھَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","یُشْمانَہَں وَدامِ تَتھا نَ کِنْتُ مَنَحسُ نَ پَرِوَرْتِّتیشُ یُویَمَپِ تَتھا نَںکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","اَنَنْتَرَں سَ اِماں درِشْٹانْتَکَتھامَکَتھَیَدْ ایکو جَنو دْراکْشاکْشیتْرَمَدھْیَ ایکَمُڈُمْبَرَورِکْشَں روپِتَوانْ۔ پَشْچاتْ سَ آگَتْیَ تَسْمِنْ پھَلانِ گَویشَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","کِنْتُ پھَلاپْراپْتیح کارَنادْ اُدْیانَکارَں بھرِتْیَں جَگادَ، پَشْیَ وَتْسَرَتْرَیَں یاوَداگَتْیَ ایتَسْمِنُّڈُمْبَرَتَرَو کْشَلانْیَنْوِچّھامِ، کِنْتُ نَیکَمَپِ پْرَپْنومِ تَرُرَیَں کُتو ورِتھا سْتھانَں وْیاپْیَ تِشْٹھَتِ؟ اینَں چھِنْدھِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","تَتو بھرِتْیَح پْرَتْیُواچَ، ہے پْرَبھو پُنَرْوَرْشَمیکَں سْتھاتُمْ آدِشَ؛ ایتَسْیَ مُولَسْیَ چَتُرْدِکْشُ کھَنِتْواہَمْ آلَوالَں سْتھاپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","تَتَح پھَلِتُں شَکْنوتِ یَدِ نَ پھَلَتِ تَرْہِ پَشْچاتْ چھیتْسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","اَتھَ وِشْرامَوارے بھَجَنَگیہے یِیشُرُپَدِشَتِ ");
INSERT INTO sanurd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","تَسْمِتْ سَمَیے بھُوتَگْرَسْتَتْواتْ کُبْجِیبھُویاشْٹادَشَوَرْشانِ یاوَتْ کیناپْیُپایینَ رِجُ رْبھَوِتُں نَ شَکْنوتِ یا دُرْبَّلا سْتْرِی، ");
INSERT INTO sanurd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","تاں تَتْروپَسْتھِتاں وِلوکْیَ یِیشُسْتاماہُویَ کَتھِتَوانْ ہے نارِ تَوَ دَورْبَّلْیاتْ تْوَں مُکْتا بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","تَتَح پَرَں تَسْیا گاتْرے ہَسْتارْپَنَماتْراتْ سا رِجُرْبھُوتْویشْوَرَسْیَ دھَنْیَوادَں کَرْتُّماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","کِنْتُ وِشْرامَوارے یِیشُنا تَسْیاح سْواسْتھْیَکَرَنادْ بھَجَنَگیہَسْیادھِپَتِح پْرَکُپْیَ لوکانْ اُواچَ، شَٹْسُ دِنیشُ لوکَیح کَرْمَّ کَرْتَّوْیَں تَسْمادّھیتوح سْواسْتھْیارْتھَں تیشُ دِنیشُ آگَچّھَتَ، وِشْرامَوارے ماگَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","تَدا پَبھُح پْرَتْیُواچَ رے کَپَٹِنو یُشْماکَمْ ایکَیکو جَنو وِشْرامَوارے سْوِییَں سْوِییَں ورِشَبھَں گَرْدَبھَں وا بَنْدھَنانْموچَیِتْوا جَلَں پایَیِتُں کِں نَ نَیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","تَرْہْیاشْٹادَشَوَتْسَرانْ یاوَتْ شَیتانا بَدّھا اِبْراہِیمَح سَنْتَتِرِیَں نارِی کِں وِشْرامَوارے نَ موچَیِتَوْیا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ایشُ واکْییشُ کَتھِتیشُ تَسْیَ وِپَکْشاح سَلَجّا جاتاح کِنْتُ تینَ کرِتَسَرْوَّمَہاکَرْمَّکارَناتْ لوکَنِوَہَح سانَنْدوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","اَنَنْتَرَں سووَدَدْ اِیشْوَرَسْیَ راجْیَں کَسْیَ سَدرِشَں؟ کینَ تَدُپَماسْیامِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","یَتْ سَرْشَپَبِیجَں گرِہِیتْوا کَشْچِجَّنَ اُدْیانَ اُپْتَوانْ تَدْ بِیجَمَنْکُرِتَں سَتْ مَہاورِکْشوجایَتَ، تَتَسْتَسْیَ شاکھاسُ وِہایَسِییَوِہَگا آگَتْیَ نْیُوشُح، تَدْراجْیَں تادرِشینَ سَرْشَپَبِیجینَ تُلْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","پُنَح کَتھَیاماسَ، اِیشْوَرَسْیَ راجْیَں کَسْیَ سَدرِشَں وَدِشْیامِ؟ یَتْ کِنْوَں کاچِتْ سْتْرِی گرِہِیتْوا دْرونَتْرَیَپَرِمِتَگودھُومَچُورْنیشُ سْتھاپَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","تَتَح کْرَمینَ تَتْ سَرْوَّگودھُومَچُورْنَں وْیاپْنوتِ، تَسْیَ کِنْوَسْیَ تُلْیَمْ اِیشْوَرَسْیَ راجْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","تَتَح سَ یِرُوشالَمْنَگَرَں پْرَتِ یاتْراں کرِتْوا نَگَرے نَگَرے گْرامے گْرامے سَمُپَدِشَنْ جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","تَدا کَشْچِجَّنَسْتَں پَپْرَچّھَ، ہے پْرَبھو کِں کیوَلَمْ اَلْپے لوکاح پَرِتْراسْیَنْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","تَتَح سَ لوکانْ اُواچَ، سَںکِیرْنَدْوارینَ پْرَویشْٹُں یَتَگھْوَں، یَتوہَں یُشْمانْ وَدامِ، بَہَوَح پْرَویشْٹُں چیشْٹِشْیَنْتے کِنْتُ نَ شَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","گرِہَپَتِنوتّھایَ دْوارے رُدّھے سَتِ یَدِ یُویَں بَہِح سْتھِتْوا دْوارَماہَتْیَ وَدَتھَ، ہے پْرَبھو ہے پْرَبھو اَسْمَتْکارَنادْ دْوارَں موچَیَتُ، تَتَح سَ اِتِ پْرَتِوَکْشْیَتِ، یُویَں کُتْرَتْیا لوکا اِتْیَہَں نَ جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","تَدا یُویَں وَدِشْیَتھَ، تَوَ ساکْشادْ وَیَں بھےाجَنَں پانَنْچَ کرِتَوَنْتَح، تْوَنْچاسْماکَں نَگَرَسْیَ پَتھِ سَمُپَدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","کِنْتُ سَ وَکْشْیَتِ، یُشْمانَہَں وَدامِ، یُویَں کُتْرَتْیا لوکا اِتْیَہَں نَ جانامِ؛ ہے دُراچارِنو یُویَں مَتّو دُورِیبھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","تَدا اِبْراہِیمَں اِسْہاکَں یاکُوبَنْچَ سَرْوَّبھَوِشْیَدْوادِنَشْچَ اِیشْوَرَسْیَ راجْیَں پْراپْتانْ سْواںشْچَ بَہِشْکرِتانْ درِشْٹْوا یُویَں رودَنَں دَنْتَیرْدَنْتَگھَرْشَنَنْچَ کَرِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","اَپَرَنْچَ پُورْوَّپَشْچِمَدَکْشِنوتَّرَدِگْبھْیو لوکا آگَتْیَ اِیشْوَرَسْیَ راجْیے نِوَتْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","پَشْیَتیتّھَں شیشِییا لوکا اَگْرا بھَوِشْیَنْتِ، اَگْرِییا لوکاشْچَ شیشا بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","اَپَرَنْچَ تَسْمِنْ دِنے کِیَنْتَح پھِرُوشِنَ آگَتْیَ یِیشُں پْروچُح، بَہِرْگَچّھَ، سْتھانادَسْماتْ پْرَسْتھانَں کُرُ، ہیرودْ تْواں جِگھاںسَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","تَتَح سَ پْرَتْیَووچَتْ پَشْیَتادْیَ شْوَشْچَ بھُوتانْ وِہاپْیَ روگِنوروگِنَح کرِتْوا ترِتِیییہْنِ سیتْسْیامِ، کَتھامیتاں یُویَمِتْوا تَں بھُورِمایَں وَدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","تَتْراپْیَدْیَ شْوَح پَرَشْوَشْچَ مَیا گَمَناگَمَنے کَرْتَّوْیے، یَتو ہیتو رْیِرُوشالَمو بَہِح کُتْراپِ کوپِ بھَوِشْیَدْوادِی نَ گھانِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ہے یِرُوشالَمْ ہے یِرُوشالَمْ تْوَں بھَوِشْیَدْوادِنو ہَںسِ تَوانْتِکے پْریرِتانْ پْرَسْتَرَیرْمارَیَسِ چَ، یَتھا کُکُّٹِی نِجَپَکْشادھَح سْوَشاوَکانْ سَںگرِہْلاتِ، تَتھاہَمَپِ تَوَ شِشُونْ سَںگْرَہِیتُں کَتِوارانْ اَیچّھَں کِنْتُ تْوَں نَیچّھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","پَشْیَتَ یُشْماکَں واسَسْتھانانِ پْروچّھِدْیَمانانِ پَرِتْیَکْتانِ چَ بھَوِشْیَنْتِ؛ یُشْمانَہَں یَتھارْتھَں وَدامِ، یَح پْرَبھو رْنامْناگَچّھَتِ سَ دھَنْیَ اِتِ واچَں یاوَتْکالَں نَ وَدِشْیَتھَ، تاوَتْکالَں یُویَں ماں نَ دْرَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","اَنَنْتَرَں وِشْرامَوارے یِیشَو پْرَدھانَسْیَ پھِرُوشِنو گرِہے بھوکْتُں گَتَوَتِ تے تَں وِیکْشِتُمْ آریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","تَدا جَلودَرِی تَسْیَ سَمُّکھے سْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","تَتَح سَ وْیَوَسْتھاپَکانْ پھِرُوشِنَشْچَ پَپْرَچّھَ، وِشْرامَوارے سْواسْتھْیَں کَرْتَّوْیَں نَ وا؟ تَتَسْتے کِمَپِ نَ پْرَتْیُوچُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","تَدا سَ تَں روگِنَں سْوَسْتھَں کرِتْوا وِسَسَرْجَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","تانُواچَ چَ یُشْماکَں کَسْیَچِدْ گَرْدَّبھو ورِشَبھو وا چیدْ گَرْتّے پَتَتِ تَرْہِ وِشْرامَوارے تَتْکْشَنَں سَ کِں تَں نوتّھاپَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","تَتَسْتے کَتھایا ایتَسْیاح کِمَپِ پْرَتِوَکْتُں نَ شیکُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","اَپَرَنْچَ پْرَدھانَسْتھانَمَنونِیتَتْوَکَرَنَں وِلوکْیَ سَ نِمَنْتْرِتانْ ایتَدُپَدیشَکَتھاں جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","تْوَں وِواہادِبھوجْییشُ نِمَنْتْرِتَح سَنْ پْرَدھانَسْتھانے موپاویکْشِیح۔ تْوَتّو گَورَوانْوِتَنِمَنْتْرِتَجَنَ آیاتی ");
INSERT INTO sanurd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","نِمَنْتْرَیِتاگَتْیَ مَنُشْیایَیتَسْمَے سْتھانَں دیہِیتِ واکْیَں چیدْ وَکْشْیَتِ تَرْہِ تْوَں سَنْکُچِتو بھُوتْوا سْتھانَ اِتَرَسْمِنْ اُپَویشْٹُمْ اُدْیَںسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","اَسْماتْ کارَنادیوَ تْوَں نِمَنْتْرِتو گَتْواپْرَدھانَسْتھانَ اُپَوِشَ، تَتو نِمَنْتْرَیِتاگَتْیَ وَدِشْیَتِ، ہے بَنْدھو پْروچَّسْتھانَں گَتْووپَوِشَ، تَتھا سَتِ بھوجَنوپَوِشْٹاناں سَکَلاناں ساکْشاتْ تْوَں مانْیو بھَوِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","یَح کَشْچِتْ سْوَمُنَّمَیَتِ سَ نَمَیِشْیَتے، کِنْتُ یَح کَشْچِتْ سْوَں نَمَیَتِ سَ اُنَّمَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","تَدا سَ نِمَنْتْرَیِتارَں جَنَمَپِ جَگادَ، مَدھْیاہْنے راتْرَو وا بھوجْیے کرِتے نِجَبَنْدھُگَنو وا بھْراترِृگَنو وا جْناتِگَنو وا دھَنِگَنو وا سَمِیپَواسِگَنو وا ایتانْ نَ نِمَنْتْرَیَ، تَتھا کرِتے چیتْ تے تْواں نِمَنْتْرَیِشْیَنْتِ، تَرْہِ پَرِشودھو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","کِنْتُ یَدا بھیجْیَں کَروشِ تَدا دَرِدْرَشُشْکَکَرَکھَنْجانْدھانْ نِمَنْتْرَیَ، ");
INSERT INTO sanurd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","تَتَ آشِشَں لَپْسْیَسے، تیشُ پَرِشودھَں کَرْتُّمَشَکْنُوَتْسُ شْمَشانادّھارْمِّکانامُتّھانَکالے تْوَں پھَلاں لَپْسْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","اَنَنْتَرَں تاں کَتھاں نِشَمْیَ بھوجَنوپَوِشْٹَح کَشْچِتْ کَتھَیاماسَ، یو جَنَ اِیشْوَرَسْیَ راجْیے بھوکْتُں لَپْسْیَتے سَایوَ دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","تَتَح سَ اُواچَ، کَشْچِتْ جَنو راتْرَو بھےाجْیَں کرِتْوا بَہُونْ نِمَنْتْرَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","تَتو بھوجَنَسَمَیے نِمَنْتْرِتَلوکانْ آہْواتُں داسَدْوارا کَتھَیاماسَ، کھَدْیَدْرَوْیانِ سَرْوّانِ سَماسادِتانِ سَنْتِ، یُویَماگَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","کِنْتُ تے سَرْوَّ ایکَیکَں چھَلَں کرِتْوا کْشَماں پْرارْتھَیانْچَکْرِرے۔ پْرَتھَمو جَنَح کَتھَیاماسَ، کْشیتْرَمیکَں کْرِیتَوانَہَں تَدیوَ دْرَشْٹُں مَیا گَنْتَوْیَمْ، اَتَایوَ ماں کْشَنْتُں تَں نِویدَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","اَنْیو جَنَح کَتھَیاماسَ، دَشَورِشانَہَں کْرِیتَوانْ تانْ پَرِیکْشِتُں یامِ تَسْمادیوَ ماں کْشَنْتُں تَں نِویدَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","اَپَرَح کَتھَیاماسَ، وْیُوڈھَوانَہَں تَسْماتْ کارَنادْ یاتُں نَ شَکْنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","پَشْچاتْ سَ داسو گَتْوا نِجَپْرَبھوح ساکْشاتْ سَرْوَّورِتّانْتَں نِویدَیاماسَ، تَتوسَو گرِہَپَتِح کُپِتْوا سْوَداسَں وْیاجَہارَ، تْوَں سَتْوَرَں نَگَرَسْیَ سَنِّویشانْ مارْگاںشْچَ گَتْوا دَرِدْرَشُشْکَکَرَکھَنْجانْدھانْ اَتْرانَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","تَتو داسووَدَتْ، ہے پْرَبھو بھَوَتَ آجْنانُساریناکْرِیَتَ تَتھاپِ سْتھانَمَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","تَدا پْرَبھُح پُنَ رْداسایاکَتھَیَتْ، راجَپَتھانْ ورِکْشَمُولانِ چَ یاتْوا مَدِییَگرِہَپُورَنارْتھَں لوکاناگَنْتُں پْرَوَرْتَّیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","اَہَں یُشْمَبھْیَں کَتھَیامِ، پُورْوَّنِمَنْتْرِتانَمیکوپِ مَماسْیَ راتْرِبھوجْیَسْیاسْوادَں نَ پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","اَنَنْتَرَں بَہُشُ لوکیشُ یِیشوح پَشْچادْ وْرَجِتیشُ سَتْسُ سَ وْیاگھُٹْیَ تیبھْیَح کَتھَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","یَح کَشْچِنْ مَمَ سَمِیپَمْ آگَتْیَ سْوَسْیَ ماتا پِتا پَتْنِی سَنْتانا بھْراتَرو بھَگِمْیو نِجَپْراناشْچَ، ایتیبھْیَح سَرْوّیبھْیو مَیَّدھِکَں پْریمَ نَ کَروتِ، سَ مَمَ شِشْیو بھَوِتُں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","یَح کَشْچِتْ سْوِییَں کْرُشَں وَہَنْ مَمَ پَشْچانَّ گَچّھَتِ، سوپِ مَمَ شِشْیو بھَوِتُں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","دُرْگَنِرْمّانے کَتِوْیَیو بھَوِشْیَتِ، تَتھا تَسْیَ سَماپْتِکَرَنارْتھَں سَمْپَتِّرَسْتِ نَ وا، پْرَتھَمَمُپَوِشْیَ ایتَنَّ گَنَیَتِ، یُشْماکَں مَدھْیَ ایتادرِشَح کوسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","نوچیدْ بھِتِّں کرِتْوا شیشے یَدِ سَماپَیِتُں نَ شَکْشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","تَرْہِ مانُشویَں نِچیتُمْ آرَبھَتَ سَماپَیِتُں ناشَکْنوتْ، اِتِ وْیاہرِتْیَ سَرْوّے تَمُپَہَسِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","اَپَرَنْچَ بھِنَّبھُوپَتِنا سَہَ یُدّھَں کَرْتُّمْ اُدْیَمْیَ دَشَسَہَسْرانِ سَینْیانِ گرِہِیتْوا وِںشَتِسَہَسْریح سَینْیَیح سَہِتَسْیَ سَمِیپَواسِنَح سَمُّکھَں یاتُں شَکْشْیامِ نَ ویتِ پْرَتھَمَں اُپَوِشْیَ نَ وِچارَیَتِ ایتادرِشو بھُومِپَتِح کَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","یَدِ نَ شَکْنوتِ تَرْہِ رِپاوَتِدُورے تِشْٹھَتِ سَتِ نِجَدُوتَں پْریشْیَ سَنْدھِں کَرْتُّں پْرارْتھَییتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","تَدْوَدْ یُشْماکَں مَدھْیے یَح کَشْچِنْ مَدَرْتھَں سَرْوَّسْوَں ہاتُں نَ شَکْنوتِ سَ مَمَ شِشْیو بھَوِتُں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","لَوَنَمْ اُتَّمَمْ اِتِ سَتْیَں، کِنْتُ یَدِ لَوَنَسْیَ لَوَنَتْوَمْ اَپَگَچّھَتِ تَرْہِ تَتْ کَتھَں سْوادُیُکْتَں بھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","تَدَ بھُومْیَرْتھَمْ آلَوالَراشْیَرْتھَمَپِ بھَدْرَں نَ بھَوَتِ؛ لوکاسْتَدْ بَہِح کْشِپَنْتِ۔ یَسْیَ شْروتُں شْروتْرے سْتَح سَ شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","تَدا کَرَسَنْچایِنَح پاپِنَشْچَ لوکا اُپَدیشْکَتھاں شْروتُں یِیشوح سَمِیپَمْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","تَتَح پھِرُوشِنَ اُپادھْیایاشْچَ وِوَدَماناح کَتھَیاماسُح ایشَ مانُشَح پاپِبھِح سَہَ پْرَنَیَں کرِتْوا تَیح سارْدّھَں بھُںکْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","تَدا سَ تیبھْیَ اِماں درِشْٹانْتَکَتھاں کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","کَسْیَچِتْ شَتَمیشیشُ تِشْٹھَتْمُ تیشامیکَں سَ یَدِ ہارَیَتِ تَرْہِ مَدھْییپْرانْتَرَمْ ایکونَشَتَمیشانْ وِہایَ ہارِتَمیشَسْیَ اُدّیشَپْراپْتِپَرْیَّنَتَں نَ گَویشَیَتِ، ایتادرِشو لوکو یُشْماکَں مَدھْیے کَ آسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","تَسْیودّیشَں پْراپْیَ ہرِشْٹَمَناسْتَں سْکَنْدھے نِدھایَ سْوَسْتھانَمْ آنِییَ بَنْدھُبانْدھَوَسَمِیپَواسِنَ آہُویَ وَکْتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ہارِتَں میشَں پْراپْتوہَمْ اَتو ہیتو رْمَیا سارْدّھَمْ آنَنْدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","تَدْوَدَہَں یُشْمانْ وَدامِ، ییشاں مَنَحپَراوَرْتَّنَسْیَ پْرَیوجَنَں ناسْتِ، تادرِشَیکونَشَتَدھارْمِّکَکارَنادْ یَ آنَنْدَسْتَسْمادْ ایکَسْیَ مَنَحپَرِوَرْتِّنَح پاپِنَح کارَناتْ سْوَرْگے دھِکانَنْدو جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","اَپَرَنْچَ دَشاناں رُوپْیَکھَنْڈانامْ ایکَکھَنْڈے ہارِتے پْرَدِیپَں پْرَجْوالْیَ گرِہَں سَمّارْجْیَ تَسْیَ پْراپْتِں یاوَدْ یَتْنینَ نَ گَویشَیَتِ، ایتادرِشِی یوشِتْ کاسْتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","پْراپْتے سَتِ بَنْدھُبانْدھَوَسَمِیپَواسِنِیراہُویَ کَتھَیَتِ، ہارِتَں رُوپْیَکھَنْڈَں پْراپْتاہَں تَسْمادیوَ مَیا سارْدّھَمْ آنَنْدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","تَدْوَدَہَں یُشْمانْ وْیاہَرامِ، ایکینَ پاپِنا مَنَسِ پَرِوَرْتِّتے، اِیشْوَرَسْیَ دُوتاناں مَدھْییپْیانَنْدو جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","اَپَرَنْچَ سَ کَتھَیاماسَ، کَسْیَچِدْ دْوَو پُتْراواسْتاں، ");
INSERT INTO sanurd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","تَیوح کَنِشْٹھَح پُتْرَح پِتْرے کَتھَیاماسَ، ہے پِتَسْتَوَ سَمْپَتّیا یَمَںشَں پْراپْسْیامْیَہَں وِبھَجْیَ تَں دیہِ، تَتَح پِتا نِجاں سَمْپَتِّں وِبھَجْیَ تابھْیاں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","کَتِپَیاتْ کالاتْ پَرَں سَ کَنِشْٹھَپُتْرَح سَمَسْتَں دھَنَں سَںگرِہْیَ دُورَدیشَں گَتْوا دُشْٹاچَرَنینَ سَرْوّاں سَمْپَتِّں ناشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","تَسْیَ سَرْوَّدھَنے وْیَیَں گَتے تَدّیشے مَہادُرْبھِکْشَں بَبھُووَ، تَتَسْتَسْیَ دَینْیَدَشا بھَوِتُمْ آریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","تَتَح پَرَں سَ گَتْوا تَدّیشِییَں گرِہَسْتھَمیکَمْ آشْرَیَتَ؛ تَتَح سَتَں شُوکَرَوْرَجَں چارَیِتُں پْرانْتَرَں پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","کیناپِ تَسْمَے بھَکْشْیاداناتْ سَ شُوکَرَپھَلَوَلْکَلینَ پِچِنْڈَپُورَناں وَوانْچھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","شیشے سَ مَنَسِ چیتَناں پْراپْیَ کَتھَیاماسَ، ہا مَمَ پِتُح سَمِیپے کَتِ کَتِ ویتَنَبھُجو داسا یَتھیشْٹَں تَتودھِکَنْچَ بھَکْشْیَں پْراپْنُوَنْتِ کِنْتْوَہَں کْشُدھا مُمُورْشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","اَہَمُتّھایَ پِتُح سَمِیپَں گَتْوا کَتھامیتاں وَدِشْیامِ، ہے پِتَرْ اِیشْوَرَسْیَ تَوَ چَ وِرُدّھَں پاپَمَکَرَوَمْ ");
INSERT INTO sanurd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","تَوَ پُتْرَاِتِ وِکھْیاتو بھَوِتُں نَ یوگْیوسْمِ چَ، ماں تَوَ وَیتَنِکَں داسَں کرِتْوا سْتھاپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","پَشْچاتْ سَ اُتّھایَ پِتُح سَمِیپَں جَگامَ؛ تَتَسْتَسْیَ پِتاتِدُورے تَں نِرِیکْشْیَ دَیانْچَکْرے، دھاوِتْوا تَسْیَ کَنْٹھَں گرِہِیتْوا تَں چُچُمْبَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","تَدا پُتْرَ اُواچَ، ہے پِتَرْ اِیشْوَرَسْیَ تَوَ چَ وِرُدّھَں پاپَمَکَرَوَں، تَوَ پُتْرَاِتِ وِکھْیاتو بھَوِتُں نَ یوگْیوسْمِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","کِنْتُ تَسْیَ پِتا نِجَداسانْ آدِدیشَ، سَرْوّوتَّمَوَسْتْرانْیانِییَ پَرِدھاپَیَتَینَں ہَسْتے چانْگُرِییَکَمْ اَرْپَیَتَ پادَیوشْچوپانَہَو سَمَرْپَیَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","پُشْٹَں گووَتْسَمْ آنِییَ مارَیَتَ چَ تَں بھُکْتْوا وَیَمْ آنَنْدامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","یَتو مَمَ پُتْرویَمْ اَمْرِیَتَ پُنَرَجِیوِیدْ ہارِتَشْچَ لَبْدھوبھُوتْ تَتَسْتَ آنَنْدِتُمْ آریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","تَتْکالے تَسْیَ جْییشْٹھَح پُتْرَح کْشیتْرَ آسِیتْ۔ اَتھَ سَ نِویشَنَسْیَ نِکَٹَں آگَچّھَنْ نرِتْیاناں وادْیانانْچَ شَبْدَں شْرُتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","داسانامْ ایکَمْ آہُویَ پَپْرَچّھَ، کِں کارَنَمَسْیَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","تَتَح سووادِیتْ، تَوَ بھْراتاگَمَتْ، تَوَ تاتَشْچَ تَں سُشَرِیرَں پْراپْیَ پُشْٹَں گووَتْسَں مارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","تَتَح سَ پْرَکُپْیَ نِویشَنانْتَح پْرَویشْٹُں نَ سَمّینے؛ تَتَسْتَسْیَ پِتا بَہِراگَتْیَ تَں سادھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","تَتَح سَ پِتَرَں پْرَتْیُواچَ، پَشْیَ تَوَ کانْچِدَپْیاجْناں نَ وِلَںگھْیَ بَہُونْ وَتْسَرانْ اَہَں تْواں سیوے تَتھاپِ مِتْرَیح سارْدّھَمْ اُتْسَوَں کَرْتُّں کَداپِ چھاگَمیکَمَپِ مَہْیَں نادَداح؛ ");
INSERT INTO sanurd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","کِنْتُ تَوَ یَح پُتْرو ویشْیاگَمَنادِبھِسْتَوَ سَمْپَتِّمْ اَپَوْیَیِتَوانْ تَسْمِنّاگَتَماتْرے تَسْیَیوَ نِمِتَّں پُشْٹَں گووَتْسَں مارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","تَدا تَسْیَ پِتاووچَتْ، ہے پُتْرَ تْوَں سَرْوَّدا مَیا سَہاسِ تَسْمانْ مَمَ یَدْیَداسْتے تَتْسَرْوَّں تَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","کِنْتُ تَوایَں بھْراتا مرِتَح پُنَرَجِیوِیدْ ہارِتَشْچَ بھُوتْوا پْراپْتوبھُوتْ، ایتَسْماتْ کارَنادْ اُتْسَوانَنْدَو کَرْتُّمْ اُچِتَمَسْماکَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","اَپَرَنْچَ یِیشُح شِشْییبھْیونْیامیکاں کَتھاں کَتھَیاماسَ کَسْیَچِدْ دھَنَوَتو مَنُشْیَسْیَ گرِہَکارْیّادھِیشے سَمْپَتّیرَپَوْیَیےپَوادِتے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","تَسْیَ پْرَبھُسْتَمْ آہُویَ جَگادَ، تْوَیِ یامِماں کَتھاں شرِنومِ سا کِیدرِشِی؟ تْوَں گرِہَکارْیّادھِیشَکَرْمَّنو گَنَناں دَرْشَیَ گرِہَکارْیّادھِیشَپَدے تْوَں نَ سْتھاسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","تَدا سَ گرِہَکارْیّادھِیشو مَنَسا چِنْتَیاماسَ، پْرَبھُ رْیَدِ ماں گرِہَکارْیّادھِیشَپَدادْ بھْرَںشَیَتِ تَرْہِ کِں کَرِشْیےہَں؟ مرِدَں کھَنِتُں مَمَ شَکْتِ رْناسْتِ بھِکْشِتُنْچَ لَجِّشْیےہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","اَتَایوَ مَیِ گرِہَکارْیّادھِیشَپَداتْ چْیُتے سَتِ یَتھا لوکا مَہْیَمْ آشْرَیَں داسْیَنْتِ تَدَرْتھَں یَتْکَرْمَّ مَیا کَرَنِییَں تَنْ نِرْنِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","پَشْچاتْ سَ سْوَپْرَبھوریکَیکَمْ اَدھَمَرْنَمْ آہُویَ پْرَتھَمَں پَپْرَچّھَ، تْوَتّو مے پْرَبھُنا کَتِ پْراپْیَمْ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","تَتَح سَ اُواچَ، ایکَشَتاڈھَکَتَیلانِ؛ تَدا گرِہَکارْیّادھِیشَح پْروواچَ، تَوَ پَتْرَمانِییَ شِیگھْرَمُپَوِشْیَ تَتْرَ پَنْچاشَتَں لِکھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","پَشْچادَنْیَمیکَں پَپْرَچّھَ، تْوَتّو مے پْرَبھُنا کَتِ پْراپْیَمْ؟ تَتَح سووادِیدْ ایکَشَتاڈھَکَگودھُوماح؛ تَدا سَ کَتھَیاماسَ، تَوَ پَتْرَمانِییَ اَشِیتِں لِکھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","تینَیوَ پْرَبھُسْتَمَیَتھارْتھَکرِتَمْ اَدھِیشَں تَدْبُدّھِنَیپُنْیاتْ پْرَشَشَںسَ؛ اِتّھَں دِیپْتِرُوپَسَنْتانیبھْیَ ایتَتْسَںسارَسْیَ سَنْتانا وَرْتَّمانَکالےدھِکَبُدّھِمَنْتو بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","اَتو وَدامِ یُویَمَپْیَیَتھارْتھینَ دھَنینَ مِتْرانِ لَبھَدھْوَں تَتو یُشْماسُ پَدَبھْرَشْٹیشْوَپِ تانِ چِرَکالَمْ آشْرَیَں داسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","یَح کَشْچِتْ کْشُدْرے کارْیّے وِشْواسْیو بھَوَتِ سَ مَہَتِ کارْیّیپِ وِشْواسْیو بھَوَتِ، کِنْتُ یَح کَشْچِتْ کْشُدْرے کارْیّےوِشْواسْیو بھَوَتِ سَ مَہَتِ کارْیّیپْیَوِشْواسْیو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","اَتَایوَ اَیَتھارْتھینَ دھَنینَ یَدِ یُویَمَوِشْواسْیا جاتاسْتَرْہِ سَتْیَں دھَنَں یُشْماکَں کَریشُ کَح سَمَرْپَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","یَدِ چَ پَرَدھَنینَ یُویَمْ اَوِشْواسْیا بھَوَتھَ تَرْہِ یُشْماکَں سْوَکِییَدھَنَں یُشْمَبھْیَں کو داسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","کوپِ داسَ اُبھَو پْرَبھُو سیوِتُں نَ شَکْنوتِ، یَتَ ایکَسْمِنْ پْرِییَمانونْیَسْمِنَّپْرِییَتے یَدْوا ایکَں جَنَں سَمادرِتْیَ تَدَنْیَں تُچّھِیکَروتِ تَدْوَدْ یُویَمَپِ دھَنیشْوَرَو سیوِتُں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","تَدَیتاح سَرْوّاح کَتھاح شْرُتْوا لوبھِپھِرُوشِنَسْتَمُپَجَہَسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","تَتَح سَ اُواچَ، یُویَں مَنُشْیاناں نِکَٹے سْوانْ نِرْدوشانْ دَرْشَیَتھَ کِنْتُ یُشْماکَمْ اَنْتَحکَرَنانِیشْوَرو جاناتِ، یَتْ مَنُشْیانامْ اَتِ پْرَشَںسْیَں تَدْ اِیشْوَرَسْیَ گھرِنْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","یوہَنَ آگَمَنَپَرْیَّنَتَں یُشْماکَں سَمِیپے وْیَوَسْتھابھَوِشْیَدْوادِناں لیکھَنانِ چاسَنْ تَتَح پْرَبھرِتِ اِیشْوَرَراجْیَسْیَ سُسَںوادَح پْرَچَرَتِ، ایکَیکو لوکَسْتَنْمَدھْیَں یَتْنینَ پْرَوِشَتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","وَرَں نَبھَسَح پرِتھِوْیاشْچَ لوپو بھَوِشْیَتِ تَتھاپِ وْیَوَسْتھایا ایکَبِنْدورَپِ لوپو نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","یَح کَشْچِتْ سْوِییاں بھارْیّاں وِہایَ سْتْرِیَمَنْیاں وِوَہَتِ سَ پَرَدارانْ گَچّھَتِ، یَشْچَ تا تْیَکْتاں نارِیں وِوَہَتِ سوپِ پَرَدارانَ گَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ایکو دھَنِی مَنُشْیَح شُکْلانِ سُوکْشْمانِ وَسْتْرانِ پَرْیَّدَدھاتْ پْرَتِدِنَں پَرِتوشَرُوپینابھُںکْتاپِوَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","سَرْوّانْگے کْشَتَیُکْتَ اِلِیاسَرَناما کَشْچِدْ دَرِدْرَسْتَسْیَ دھَنَوَتو بھوجَنَپاتْراتْ پَتِتَمْ اُچّھِشْٹَں بھوکْتُں وانْچھَنْ تَسْیَ دْوارے پَتِتْواتِشْٹھَتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","اَتھَ شْوانَ آگَتْیَ تَسْیَ کْشَتانْیَلِہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","کِیَتْکالاتْپَرَں سَ دَرِدْرَح پْرانانْ جَہَو؛ تَتَح سْوَرْگِییَدُوتاسْتَں نِیتْوا اِبْراہِیمَح کْروڈَ اُپَویشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","پَشْچاتْ سَ دھَنَوانَپِ مَمارَ، تَں شْمَشانے سْتھاپَیاماسُشْچَ؛ کِنْتُ پَرَلوکے سَ ویدَناکُلَح سَنْ اُورْدّھواں نِرِیکْشْیَ بَہُدُورادْ اِبْراہِیمَں تَتْکْروڈَ اِلِیاسَرَنْچَ وِلوکْیَ رُوَنُّواچَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ہے پِتَرْ اِبْراہِیمْ اَنُگرِہْیَ اَنْگُلْیَگْرَبھاگَں جَلے مَجَّیِتْوا مَمَ جِہْواں شِیتَلاں کَرْتُّمْ اِلِیاسَرَں پْریرَیَ، یَتو وَہْنِشِکھاتوہَں وْیَتھِتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","تَدا اِبْراہِیمْ بَبھاشے، ہے پُتْرَ تْوَں جِیوَنْ سَمْپَدَں پْراپْتَوانْ اِلِیاسَرَسْتُ وِپَدَں پْراپْتَوانْ ایتَتْ سْمَرَ، کِنْتُ سَمْپْرَتِ تَسْیَ سُکھَں تَوَ چَ دُحکھَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","اَپَرَمَپِ یُشْماکَمْ اَسْماکَنْچَ سْتھانَیو رْمَدھْیے مَہَدْوِچّھیدوسْتِ تَتَ ایتَتْسْتھانَسْیَ لوکاسْتَتْ سْتھانَں یاتُں یَدْوا تَتْسْتھانَسْیَ لوکا ایتَتْ سْتھانَمایاتُں نَ شَکْنُوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","تَدا سَ اُکْتَوانْ، ہے پِتَسْتَرْہِ تْواں نِویدَیامِ مَمَ پِتُ رْگیہے یے مَمَ پَنْچَ بھْراتَرَح سَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","تے یَتھَیتَدْ یاتَناسْتھانَں نایاسْیَنْتِ تَتھا مَنْتْرَناں داتُں تیشاں سَمِیپَمْ اِلِیاسَرَں پْریرَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","تَتَ اِبْراہِیمْ اُواچَ، مُوسابھَوِشْیَدْوادِنانْچَ پُسْتَکانِ تیشاں نِکَٹے سَنْتِ تے تَدْوَچَنانِ مَنْیَنْتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","تَدا سَ نِویدَیاماسَ، ہے پِتَرْ اِبْراہِیمْ نَ تَتھا، کِنْتُ یَدِ مرِتَلوکاناں کَشْچِتْ تیشاں سَمِیپَں یاتِ تَرْہِ تے مَناںسِ وْیاگھوٹَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","تَتَ اِبْراہِیمْ جَگادَ، تے یَدِ مُوسابھَوِشْیَدْوادِنانْچَ وَچَنانِ نَ مَنْیَنْتے تَرْہِ مرِتَلوکاناں کَسْمِںشْچِدْ اُتّھِتیپِ تے تَسْیَ مَنْتْرَناں نَ مَںسْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","اِتَح پَرَں یِیشُح شِشْیانْ اُواچَ، وِگھْنَیرَوَشْیَمْ آگَنْتَوْیَں کِنْتُ وِگھْنا یینَ گھَٹِشْیَنْتے تَسْیَ دُرْگَتِ رْبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ایتیشاں کْشُدْرَپْرانِنامْ ایکَسْیاپِ وِگھْنَجَنَناتْ کَنْٹھَبَدّھَپیشَنِیکَسْیَ تَسْیَ ساگَراگادھَجَلے مَجَّنَں بھَدْرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","یُویَں سْویشُ ساوَدھاناسْتِشْٹھَتَ؛ تَوَ بھْراتا یَدِ تَوَ کِنْچِدْ اَپَرادھْیَتِ تَرْہِ تَں تَرْجَیَ، تینَ یَدِ مَنَح پَرِوَرْتَّیَتِ تَرْہِ تَں کْشَمَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","پُنَریکَدِنَمَدھْیے یَدِ سَ تَوَ سَپْتَکرِتْووپَرادھْیَتِ کِنْتُ سَپْتَکرِتْوَ آگَتْیَ مَنَح پَرِوَرْتْیَ مَیاپَرادّھَمْ اِتِ وَدَتِ تَرْہِ تَں کْشَمَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","تَدا پْریرِتاح پْرَبھُمْ اَوَدَنْ اَسْماکَں وِشْواسَں وَرْدّھَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","پْرَبھُرُواچَ، یَدِ یُشْماکَں سَرْشَپَیکَپْرَمانو وِشْواسوسْتِ تَرْہِ تْوَں سَمُولَمُتْپاٹِتو بھُوتْوا سَمُدْرے روپِتو بھَوَ کَتھایامْ ایتَسْیامْ ایتَدُڈُمْبَرایَ کَتھِتایاں سَ یُشْماکَماجْناوَہو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","اَپَرَں سْوَداسے ہَلَں واہَیِتْوا وا پَشُونْ چارَیِتْوا کْشیتْرادْ آگَتے سَتِ تَں وَدَتِ، ایہِ بھوکْتُمُپَوِشَ، یُشْماکَمْ ایتادرِشَح کوسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","وَرَنْچَ پُورْوَّں مَمَ کھادْیَماسادْیَ یاوَدْ بھُنْجے پِوامِ چَ تاوَدْ بَدّھَکَٹِح پَرِچَرَ پَشْچاتْ تْوَمَپِ بھوکْشْیَسے پاسْیَسِ چَ کَتھامِیدرِشِیں کِں نَ وَکْشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","تینَ داسینَ پْرَبھوراجْنانُرُوپے کَرْمَّنِ کرِتے پْرَبھُح کِں تَسْمِنْ بادھِتو جاتَح؟ نیتّھَں بُدھْیَتے مَیا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","اِتّھَں نِرُوپِتیشُ سَرْوَّکَرْمَّسُ کرِتیشُ سَتْمُ یُویَمَپِیدَں واکْیَں وَدَتھَ، وَیَمْ اَنُپَکارِنو داسا اَسْمابھِرْیَدْیَتْکَرْتَّوْیَں تَنْماتْرَمیوَ کرِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","سَ یِرُوشالَمِ یاتْراں کُرْوَّنْ شومِرونْگالِیلْپْرَدیشَمَدھْیینَ گَچّھَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ایتَرْہِ کُتْرَچِدْ گْرامے پْرَویشَماتْرے دَشَکُشْٹھِنَسْتَں ساکْشاتْ کرِتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","دُورے تِشْٹھَنَتَ اُچَّے رْوَکْتُماریبھِرے، ہے پْرَبھو یِیشو دَیَسْواسْمانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","تَتَح سَ تانْ درِشْٹْوا جَگادَ، یُویَں یاجَکاناں سَمِیپے سْوانْ دَرْشَیَتَ، تَتَسْتے گَچّھَنْتو روگاتْ پَرِشْکرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","تَدا تیشامیکَح سْوَں سْوَسْتھَں درِشْٹْوا پْروچَّیرِیشْوَرَں دھَنْیَں وَدَنْ وْیاگھُٹْیایاتو یِیشو رْگُنانَنُوَدَنْ تَچَّرَنادھوبھُومَو پَپاتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","سَ چاسِیتْ شومِرونِی۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","تَدا یِیشُرَوَدَتْ، دَشَجَناح کِں نَ پَرِشْکرِتاح؟ تَہْیَنْیے نَوَجَناح کُتْرَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","اِیشْوَرَں دھَنْیَں وَدَنْتَمْ اینَں وِدیشِنَں وِنا کوپْیَنْیو نَ پْراپْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","تَدا سَ تَمُواچَ، تْوَمُتّھایَ یاہِ وِشْواسَسْتے تْواں سْوَسْتھَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","اَتھَ کَدیشْوَرَسْیَ راجَتْوَں بھَوِشْیَتِیتِ پھِرُوشِبھِح پرِشْٹے سَ پْرَتْیُواچَ، اِیشْوَرَسْیَ راجَتْوَمْ اَیشْوَرْیَّدَرْشَنینَ نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","اَتَ ایتَسْمِنْ پَشْیَ تَسْمِنْ وا پَشْیَ، اِتِ واکْیَں لوکا وَکْتُں نَ شَکْشْیَنْتِ، اِیشْوَرَسْیَ راجَتْوَں یُشْماکَمْ اَنْتَریواسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","تَتَح سَ شِشْیانْ جَگادَ، یَدا یُشْمابھِ رْمَنُجَسُتَسْیَ دِنَمیکَں دْرَشْٹُمْ وانْچھِشْیَتے کِنْتُ نَ دَرْشِشْیَتے، اِیدرِکّالَ آیاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","تَداتْرَ پَشْیَ وا تَتْرَ پَشْییتِ واکْیَں لوکا وَکْشْیَنْتِ، کِنْتُ تیشاں پَشْچاتْ ما یاتَ، مانُگَچّھَتَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","یَتَسْتَڈِدْ یَتھاکاشَیکَدِشْیُدِیَ تَدَنْیامَپِ دِشَں وْیاپْیَ پْرَکاشَتے تَدْوَتْ نِجَدِنے مَنُجَسُونُح پْرَکاشِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","کِنْتُ تَتْپُورْوَّں تینانیکانِ دُحکھانِ بھوکْتَوْیانْییتَدْوَرْتَّمانَلوکَیشْچَ سووَجْناتَوْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","نوہَسْیَ وِدْیَمانَکالے یَتھابھَوَتْ مَنُشْیَسُونوح کالیپِ تَتھا بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","یاوَتْکالَں نوہو مَہاپوتَں ناروہَدْ آپْلاوِوارْیّیتْیَ سَرْوَّں ناناشَیَچَّ تاوَتْکالَں یَتھا لوکا اَبھُنْجَتاپِوَنْ وْیَوَہَنْ وْیَواہَیَںشْچَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","اِتّھَں لوٹو وَرْتَّمانَکالیپِ یَتھا لوکا بھوجَنَپانَکْرَیَوِکْرَیَروپَنَگرِہَنِرْمّانَکَرْمَّسُ پْراوَرْتَّنْتَ، ");
INSERT INTO sanurd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","کِنْتُ یَدا لوٹْ سِدومو نِرْجَگامَ تَدا نَبھَسَح سَگَنْدھَکاگْنِورِشْٹِ رْبھُوتْوا سَرْوَّں وْیَناشَیَتْ ");
INSERT INTO sanurd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","تَدْوَنْ مانَوَپُتْرَپْرَکاشَدِنیپِ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","تَدا یَدِ کَشْچِدْ گرِہوپَرِ تِشْٹھَتِ تَرْہِ سَ گرِہَمَدھْیاتْ کِمَپِ دْرَوْیَمانیتُمْ اَوَرُہْیَ نَیتُ؛ یَشْچَ کْشیتْرے تِشْٹھَتِ سوپِ وْیاگھُٹْیَ نایاتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","لوٹَح پَتْنِیں سْمَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","یَح پْرانانْ رَکْشِتُں چیشْٹِشْیَتے سَ پْرانانْ ہارَیِشْیَتِ یَسْتُ پْرانانْ ہارَیِشْیَتِ سَایوَ پْرانانْ رَکْشِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","یُشْمانَہَں وَچْمِ تَسْیاں راتْرَو شَیَّیکَگَتَیو رْلوکَیوریکو دھارِشْیَتے پَرَسْتْیَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","سْتْرِیَو یُگَپَتْ پیشَنِیں وْیاوَرْتَّیِشْیَتَسْتَیوریکا دھارِشْیَتے پَراتْیَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","پُرُشَو کْشیتْرے سْتھاسْیَتَسْتَیوریکو دھارِشْیَتے پَرَسْتْیَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","تَدا تے پَپْرَچّھُح، ہے پْرَبھو کُتْریتّھَں بھَوِشْیَتِ؟ تَتَح سَ اُواچَ، یَتْرَ شَوَسْتِشْٹھَتِ تَتْرَ گرِدھْرا مِلَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","اَپَرَنْچَ لوکَیرَکْلانْتَے رْنِرَنْتَرَں پْرارْتھَیِتَوْیَمْ اِتْیاشَیینَ یِیشُنا درِشْٹانْتَ ایکَح کَتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","کُتْرَچِنَّگَرے کَشْچِتْ پْراڈْوِواکَ آسِیتْ سَ اِیشْوَرانّابِبھیتْ مانُشاںشْچَ نامَنْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","اَتھَ تَتْپُرَواسِنِی کاچِدْوِدھَوا تَتْسَمِیپَمیتْیَ وِوادِنا سَہَ مَمَ وِوادَں پَرِشْکُرْوِّتِ نِویدَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","تَتَح سَ پْراڈْوِواکَح کِیَدِّنانِ نَ تَدَنْگِیکرِتَوانْ پَشْچاچِّتّے چِنْتَیاماسَ، یَدْیَپِیشْوَرانَّ بِبھیمِ مَنُشْیانَپِ نَ مَنْیی ");
INSERT INTO sanurd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","تَتھاپْییشا وِدھَوا ماں کْلِشْناتِ تَسْمادَسْیا وِوادَں پَرِشْکَرِشْیامِ نوچیتْ سا سَداگَتْیَ ماں وْیَگْرَں کَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","پَشْچاتْ پْرَبھُرَوَدَدْ اَساوَنْیایَپْراڈْوِواکو یَداہَ تَتْرَ مَنو نِدھَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","اِیشْوَرَسْیَ یے بھِرُچِتَلوکا دِوانِشَں پْرارْتھَیَنْتے سَ بَہُدِنانِ وِلَمْبْیاپِ تیشاں وِوادانْ کِں نَ پَرِشْکَرِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","یُشْمانَہَں وَدامِ تْوَرَیا پَرِشْکَرِشْیَتِ، کِنْتُ یَدا مَنُشْیَپُتْرَ آگَمِشْیَتِ تَدا پرِتھِوْیاں کِمِیدرِشَں وِشْواسَں پْراپْسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","یے سْوانْ دھارْمِّکانْ جْناتْوا پَرانْ تُچّھِیکُرْوَّنْتِ ایتادرِگْبھْیَح، کِیَدْبھْیَ اِمَں درِشْٹانْتَں کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ایکَح پھِرُوشْیَپَرَح کَرَسَنْچایِی دْواوِمَو پْرارْتھَیِتُں مَنْدِرَں گَتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","تَتوسَو پھِرُوشْییکَپارْشْوے تِشْٹھَنْ ہے اِیشْوَرَ اَہَمَنْیَلوکَوَتْ لوٹھَیِتانْیایِی پارَدارِکَشْچَ نَ بھَوامِ اَسْیَ کَرَسَنْچایِنَسْتُلْیَشْچَ نَ، تَسْماتّواں دھَنْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","سَپْتَسُ دِنیشُ دِنَدْوَیَمُپَوَسامِ سَرْوَّسَمْپَتّے رْدَشَماںشَں دَدامِ چَ، ایتَتْکَتھاں کَتھَیَنْ پْرارْتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","کِنْتُ سَ کَرَسَنْچایِ دُورے تِشْٹھَنْ سْوَرْگَں دْرَشْٹُں نیچّھَنْ وَکْشَسِ کَراگھاتَں کُرْوَّنْ ہے اِیشْوَرَ پاپِشْٹھَں ماں دَیَسْوَ، اِتّھَں پْرارْتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","یُشْمانَہَں وَدامِ، تَیورْدْوَیو رْمَدھْیے کیوَلَح کَرَسَنْچایِی پُنْیَوَتّوینَ گَنِتو نِجَگرِہَں جَگامَ، یَتو یَح کَشْچِتْ سْوَمُنَّمَیَتِ سَ نامَیِشْیَتے کِنْتُ یَح کَشْچِتْ سْوَں نَمَیَتِ سَ اُنَّمَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","اَتھَ شِشُوناں گاتْرَسْپَرْشارْتھَں لوکاسْتانْ تَسْیَ سَمِیپَمانِنْیُح شِشْیاسْتَدْ درِشْٹْوانیترِنْ تَرْجَیاماسُح، ");
INSERT INTO sanurd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","کِنْتُ یِیشُسْتاناہُویَ جَگادَ، مَنِّکَٹَمْ آگَنْتُں شِشُونْ اَنُجانِیدھْوَں تاںشْچَ ما وارَیَتَ؛ یَتَ اِیشْوَرَراجْیادھِکارِنَ ایشاں سَدرِشاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","اَہَں یُشْمانْ یَتھارْتھَں وَدامِ، یو جَنَح شِشوح سَدرِشو بھُوتْوا اِیشْوَرَراجْیَں نَ گرِہْلاتِ سَ کیناپِ پْرَکارینَ تَتْ پْرَویشْٹُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","اَپَرَمْ ایکودھِپَتِسْتَں پَپْرَچّھَ، ہے پَرَمَگُرو، اَنَنْتایُشَح پْراپْتَیے مَیا کِں کَرْتَّوْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","یِیشُرُواچَ، ماں کُتَح پَرَمَں وَدَسِ؟ اِیشْوَرَں وِنا کوپِ پَرَمو نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","پَرَدارانْ ما گَچّھَ، نَرَں ما جَہِ، ما چورَیَ، مِتھْیاساکْشْیَں ما دیہِ، ماتَرَں پِتَرَنْچَ سَںمَنْیَسْوَ، ایتا یا آجْناح سَنْتِ تاسْتْوَں جاناسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","تَدا سَ اُواچَ، بالْیَکالاتْ سَرْوّا ایتا آچَرامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","اِتِ کَتھاں شْرُتْوا یِیشُسْتَمَوَدَتْ، تَتھاپِ تَوَیکَں کَرْمَّ نْیُونَماسْتے، نِجَں سَرْوَّسْوَں وِکْرِییَ دَرِدْریبھْیو وِتَرَ، تَسْماتْ سْوَرْگے دھَنَں پْراپْسْیَسِ؛ تَتَ آگَتْیَ مَمانُگامِی بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","کِنْتْویتاں کَتھاں شْرُتْوا سودھِپَتِح شُشوچَ، یَتَسْتَسْیَ بَہُدھَنَماسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","تَدا یِیشُسْتَمَتِشوکانْوِتَں درِشْٹْوا جَگادَ، دھَنَوَتامْ اِیشْوَرَراجْیَپْرَویشَح کِیدرِگْ دُشْکَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","اِیشْوَرَراجْیے دھَنِنَح پْرَویشاتْ سُوچیشْچھِدْرینَ مَہانْگَسْیَ گَمَناگَمَنے سُکَرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","شْروتارَح پَپْرَچّھُسْتَرْہِ کینَ پَرِتْرانَں پْراپْسْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","سَ اُکْتَوانْ، یَنْ مانُشیناشَکْیَں تَدْ اِیشْوَرینَ شَکْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","تَدا پِتَرَ اُواچَ، پَشْیَ وَیَں سَرْوَّسْوَں پَرِتْیَجْیَ تَوَ پَشْچادْگامِنوبھَوامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","تَتَح سَ اُواچَ، یُشْمانَہَں یَتھارْتھَں وَدامِ، اِیشْوَرَراجْیارْتھَں گرِہَں پِتَرَو بھْراترِگَنَں جایاں سَنْتاناںشْچَ تْیَکْتَوا ");
INSERT INTO sanurd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","اِہَ کالے تَتودھِکَں پَرَکالے نَنْتایُشْچَ نَ پْراپْسْیَتِ لوکَ اِیدرِشَح کوپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","اَنَنْتَرَں سَ دْوادَشَشِشْیاناہُویَ بَبھاشے، پَشْیَتَ وَیَں یِرُوشالَمْنَگَرَں یامَح، تَسْماتْ مَنُشْیَپُتْرے بھَوِشْیَدْوادِبھِرُکْتَں یَدَسْتِ تَدَنُرُوپَں تَں پْرَتِ گھَٹِشْیَتے؛ ");
INSERT INTO sanurd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","وَسْتُتَسْتُ سونْیَدیشِییاناں ہَسْتیشُ سَمَرْپَیِشْیَتے، تے تَمُپَہَسِشْیَنْتِ، اَنْیایَماچَرِشْیَنْتِ تَدْوَپُشِ نِشْٹھِیوَں نِکْشیپْسْیَنْتِ، کَشابھِح پْرَہرِتْیَ تَں ہَنِشْیَنْتِ چَ، ");
INSERT INTO sanurd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","کِنْتُ ترِتِییَدِنے سَ شْمَشانادْ اُتّھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ایتَسْیاح کَتھایا اَبھِپْرایَں کِنْچِدَپِ تے بودّھُں نَ شیکُح تیشاں نِکَٹےسْپَشْٹَتَواتْ تَسْیَیتاساں کَتھانامْ آشَیَں تے جْناتُں نَ شیکُشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","اَتھَ تَسْمِنْ یِرِیہوح پُرَسْیانْتِکَں پْراپْتے کَشْچِدَنْدھَح پَتھَح پارْشْوَ اُپَوِشْیَ بھِکْشامْ اَکَروتْ ");
INSERT INTO sanurd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","سَ لوکَسَمُوہَسْیَ گَمَنَشَبْدَں شْرُتْوا تَتْکارَنَں پرِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ناسَرَتِییَیِیشُرْیاتِیتِ لوکَیرُکْتے سَ اُچَّیرْوَکْتُماریبھے، ");
INSERT INTO sanurd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ہے دایُودَح سَنْتانَ یِیشو ماں دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","تَتوگْرَگامِنَسْتَں مَونِی تِشْٹھیتِ تَرْجَیاماسُح کِنْتُ سَ پُنارُوَنْ اُواچَ، ہے دایُودَح سَنْتانَ ماں دَیَسْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","تَدا یِیشُح سْتھَگِتو بھُوتْوا سْوانْتِکے تَمانیتُمْ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","تَتَح سَ تَسْیانْتِکَمْ آگَمَتْ، تَدا سَ تَں پَپْرَچّھَ، تْوَں کِمِچّھَسِ؟ تْوَدَرْتھَمَہَں کِں کَرِشْیامِ؟ سَ اُکْتَوانْ، ہے پْرَبھوہَں دْرَشْٹُں لَبھَے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","تَدا یِیشُرُواچَ، درِشْٹِشَکْتِں گرِہانَ تَوَ پْرَتْیَیَسْتْواں سْوَسْتھَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","تَتَسْتَتْکْشَناتْ تَسْیَ چَکْشُشِی پْرَسَنّے؛ تَسْماتْ سَ اِیشْوَرَں دھَنْیَں وَدَنْ تَتْپَشْچادْ یَیَو، تَدالوکْیَ سَرْوّے لوکا اِیشْوَرَں پْرَشَںسِتُمْ آریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","یَدا یِیشُ رْیِرِیہوپُرَں پْرَوِشْیَ تَنْمَدھْیینَ گَچّھَںسْتَدا ");
INSERT INTO sanurd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","سَکّییَناما کَرَسَنْچایِناں پْرَدھانو دھَنَوانیکو ");
INSERT INTO sanurd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","یِیشُح کِیدرِگِتِ دْرَشْٹُں چیشْٹِتَوانْ کِنْتُ کھَرْوَّتْوالّوکَسَںگھَمَدھْیے تَدَّرْشَنَمَپْراپْیَ ");
INSERT INTO sanurd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","یینَ پَتھا سَ یاسْیَتِ تَتْپَتھےگْرے دھاوِتْوا تَں دْرَشْٹُمْ اُڈُمْبَرَتَرُمارُروہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","پَشْچادْ یِیشُسْتَتْسْتھانَمْ اِتْوا اُورْدّھوَں وِلوکْیَ تَں درِشْٹْواوادِیتْ، ہے سَکّییَ تْوَں شِیگھْرَمَوَروہَ مَیادْیَ تْوَدْگیہے وَسْتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","تَتَح سَ شِیگھْرَمَوَرُہْیَ ساہْلادَں تَں جَگْراہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","تَدْ درِشْٹْوا سَرْوّے وِوَدَمانا وَکْتُماریبھِرے، سوتِتھِتْوینَ دُشْٹَلوکَگرِہَں گَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","کِنْتُ سَکّییو دَنْڈایَمانو وَکْتُماریبھے، ہے پْرَبھو پَشْیَ مَمَ یا سَمْپَتِّرَسْتِ تَدَرْدّھَں دَرِدْریبھْیو دَدے، اَپَرَمْ اَنْیایَں کرِتْوا کَسْمادَپِ یَدِ کَداپِ کِنْچِتْ مَیا گرِہِیتَں تَرْہِ تَچَّتُرْگُنَں دَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","تَدا یِیشُسْتَمُکْتَوانْ اَیَمَپِ اِبْراہِیمَح سَنْتانوتَح کارَنادْ اَدْیاسْیَ گرِہے تْرانَمُپَسْتھِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","یَدْ ہارِتَں تَتْ مرِگَیِتُں رَکْشِتُنْچَ مَنُشْیَپُتْرَ آگَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","اَتھَ سَ یِرُوشالَمَح سَمِیپَ اُپاتِشْٹھَدْ اِیشْوَرَراجَتْوَسْیانُشْٹھانَں تَدَیوَ بھَوِشْیَتِیتِ لوکَیرَنْوَبھُویَتَ، تَسْماتْ سَ شْروترِبھْیَح پُنَرْدرِشْٹانْتَکَتھامْ اُتّھاپْیَ کَتھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","کوپِ مَہالّوکو نِجارْتھَں راجَتْوَپَدَں گرِہِیتْوا پُنَراگَنْتُں دُورَدیشَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","یاتْراکالے نِجانْ دَشَداسانْ آہُویَ دَشَسْوَرْنَمُدْرا دَتّوا مَماگَمَنَپَرْیَّنْتَں وانِجْیَں کُرُتیتْیادِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","کِنْتُ تَسْیَ پْرَجاسْتَمَوَجْنایَ مَنُشْیَمینَمْ اَسْماکَمُپَرِ راجَتْوَں نَ کارَیِوْیامَ اِماں وارْتّاں تَنِّکَٹے پْریرَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","اَتھَ سَ راجَتْوَپَدَں پْراپْیاگَتَوانْ ایکَیکو جَنو بانِجْیینَ کِں لَبْدھَوانْ اِتِ جْناتُں ییشُ داسیشُ مُدْرا اَرْپَیَتْ تانْ آہُویانیتُمْ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","تَدا پْرَتھَمَ آگَتْیَ کَتھِتَوانْ، ہے پْرَبھو تَوَ تَیَیکَیا مُدْرَیا دَشَمُدْرا لَبْدھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","تَتَح سَ اُواچَ تْوَمُتَّمو داسَح سْوَلْپینَ وِشْواسْیو جاتَ اِتَح کارَناتْ تْوَں دَشَنَگَرانامْ اَدھِپو بھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","دْوِتِییَ آگَتْیَ کَتھِتَوانْ، ہے پْرَبھو تَوَیکَیا مُدْرَیا پَنْچَمُدْرا لَبْدھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","تَتَح سَ اُواچَ، تْوَں پَنْچاناں نَگَرانامَدھِپَتِ رْبھَوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","تَتونْیَ آگَتْیَ کَتھَیاماسَ، ہے پْرَبھو پَشْیَ تَوَ یا مُدْرا اَہَں وَسْتْرے بَدّھواسْتھاپَیَں سییَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","تْوَں کرِپَنو یَنّاسْتھاپَیَسْتَدَپِ گرِہْلاسِ، یَنّاوَپَسْتَدیوَ چَ چھِنَتْسِ تَتوہَں تْوَتّو بھِیتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","تَدا سَ جَگادَ، رے دُشْٹَداسَ تَوَ واکْیینَ تْواں دوشِنَں کَرِشْیامِ، یَدَہَں ناسْتھاپَیَں تَدیوَ گرِہْلامِ، یَدَہَں ناوَپَنْچَ تَدیوَ چھِنَدْمِ، ایتادرِشَح کرِپَنوہَمِتِ یَدِ تْوَں جاناسِ، ");
INSERT INTO sanurd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","تَرْہِ مَمَ مُدْرا بَنِجاں نِکَٹے کُتو ناسْتھاپَیَح؟ تَیا کرِتےہَمْ آگَتْیَ کُسِیدینَ سارْدّھَں نِجَمُدْرا اَپْراپْسْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","پَشْچاتْ سَ سَمِیپَسْتھانْ جَنانْ آجْناپَیَتْ اَسْماتْ مُدْرا آنِییَ یَسْیَ دَشَمُدْراح سَنْتِ تَسْمَے دَتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","تے پْروچُح پْرَبھوسْیَ دَشَمُدْراح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","یُشْمانَہَں وَدامِ یَسْیاشْرَیے وَدّھَتے دھِکَں تَسْمَے دایِشْیَتے، کِنْتُ یَسْیاشْرَیے نَ وَرْدّھَتے تَسْیَ یَدْیَدَسْتِ تَدَپِ تَسْمانْ نایِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","کِنْتُ مَمادھِپَتِتْوَسْیَ وَشَتْوے سْتھاتُمْ اَسَمَّنْیَمانا یے مَمَ رِپَوَسْتانانِییَ مَمَ سَمَکْشَں سَںہَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","اِتْیُپَدیشَکَتھاں کَتھَیِتْوا سوگْرَگَح سَنْ یِرُوشالَمَپُرَں یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","تَتو بَیتْپھَگِیبَیتھَنِییاگْرامَیوح سَمِیپے جَیتُنادْریرَنْتِکَمْ اِتْوا شِشْیَدْوَیَمْ اِتْیُکْتْوا پْریشَیاماسَ، ");
INSERT INTO sanurd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","یُوامَمُں سَمُّکھَسْتھَگْرامَں پْرَوِشْیَیوَ یَں کوپِ مانُشَح کَداپِ ناروہَتْ تَں گَرْدَّبھَشاوَکَں بَدّھَں دْرَکْشْیَتھَسْتَں موچَیِتْوانَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","تَتْرَ کُتو موچَیَتھَح؟ اِتِ چیتْ کوپِ وَکْشْیَتِ تَرْہِ وَکْشْیَتھَح پْرَبھےाرَتْرَ پْرَیوجَنَمْ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","تَدا تَو پْرَرِتَو گَتْوا تَتْکَتھاाنُسارینَ سَرْوَّں پْراپْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","گَرْدَبھَشاوَکَموچَنَکالے تَتْوامِنَ اُوچُح، گَرْدَبھَشاوَکَں کُتو موچَیَتھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","تاوُوچَتُح پْرَبھورَتْرَ پْرَیوجَنَمْ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","پَشْچاتْ تَو تَں گَرْدَبھَشاوَکَں یِیشورَنْتِکَمانِییَ تَتْپرِشْٹھے نِجَوَسَنانِ پاتَیِتْوا تَدُپَرِ یِیشُماروہَیاماسَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","اَتھَ یاتْراکالے لوکاح پَتھِ سْوَوَسْتْرانِ پاتَیِتُمْ آریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","اَپَرَں جَیتُنادْریرُپَتْیَکامْ اِتْوا شِشْیَسَںگھَح پُورْوَّدرِشْٹانِ مَہاکَرْمّانِ سْمرِتْوا، ");
INSERT INTO sanurd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","یو راجا پْرَبھو رْنامْنایاتِ سَ دھَنْیَح سْوَرْگے کُشَلَں سَرْوّوچّے جَیَدھْوَنِ رْبھَوَتُ، کَتھامیتاں کَتھَیِتْوا سانَنْدَمْ اُچَیرِیشْوَرَں دھَنْیَں وَکْتُماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","تَدا لوکارَنْیَمَدھْیَسْتھاح کِیَنْتَح پھِرُوشِنَسْتَتْ شْرُتْوا یِیشُں پْروچُح، ہے اُپَدیشَکَ سْوَشِشْیانْ تَرْجَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","سَ اُواچَ، یُشْمانَہَں وَدامِ یَدْیَمِی نِیرَواسْتِشْٹھَنْتِ تَرْہِ پاشانا اُچَیح کَتھاح کَتھَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","پَشْچاتْ تَتْپُرانْتِکَمیتْیَ تَدَوَلوکْیَ ساشْرُپاتَں جَگادَ، ");
INSERT INTO sanurd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ہا ہا چیتْ تْوَمَگْرےجْناسْیَتھاح، تَواسْمِنّیوَ دِنے وا یَدِ سْوَمَنْگَلَمْ اُپالَپْسْیَتھاح، تَرْہْیُتَّمَمْ اَبھَوِشْیَتْ، کِنْتُ کْشَنیسْمِنْ تَتَّوَ درِشْٹیرَگوچَرَمْ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","تْوَں سْوَتْرانَکالے نَ مَنو نْیَدھَتّھا اِتِ ہیتو رْیَتْکالے تَوَ رِپَوَسْتْواں چَتُرْدِکْشُ پْراچِیرینَ ویشْٹَیِتْوا روتْسْیَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","بالَکَیح سارْدّھَں بھُومِساتْ کَرِشْیَنْتِ چَ تْوَنْمَدھْیے پاشانَیکوپِ پاشانوپَرِ نَ سْتھاسْیَتِ چَ، کالَ اِیدرِشَ اُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","اَتھَ مَدھْییمَنْدِرَں پْرَوِشْیَ تَتْرَتْیانْ کْرَیِوِکْرَیِنو بَہِشْکُرْوَّنْ ");
INSERT INTO sanurd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","اَوَدَتْ مَدْگرِہَں پْرارْتھَناگرِہَمِتِ لِپِراسْتے کِنْتُ یُویَں تَدیوَ چَیراناں گَہْوَرَں کُرُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","پَشْچاتْ سَ پْرَتْیَہَں مَدھْییمَنْدِرَمْ اُپَدِدیشَ؛ تَتَح پْرَدھانَیاجَکا اَدھْیاپَکاح پْراچِیناشْچَ تَں ناشَیِتُں چِچیشْٹِرے؛ ");
INSERT INTO sanurd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","کِنْتُ تَدُپَدیشے سَرْوّے لوکا نِوِشْٹَچِتّاح سْتھِتاسْتَسْماتْ تے تَتْکَرْتُّں ناوَکاشَں پْراپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","اَتھَیکَدا یِیشُ رْمَنِدَرے سُسَںوادَں پْرَچارَیَنْ لوکانُپَدِشَتِ، ایتَرْہِ پْرَدھانَیاجَکا اَدھْیاپَکاح پْرانْچَشْچَ تَنِّکَٹَماگَتْیَ پَپْرَچّھُح ");
INSERT INTO sanurd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","کَیاجْنَیا تْوَں کَرْمّانْییتانِ کَروشِ؟ کو وا تْواماجْناپَیَتْ؟ تَدَسْمانْ وَدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","سَ پْرَتْیُواچَ، تَرْہِ یُشْمانَپِ کَتھامیکاں پرِچّھامِ تَسْیوتَّرَں وَدَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","یوہَنو مَجَّنَمْ اِیشْوَرَسْیَ مانُشاناں واجْناتو جاتَں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","تَتَسْتے مِتھو وِوِچْیَ جَگَدُح، یَدِیشْوَرَسْیَ وَدامَسْتَرْہِ تَں کُتو نَ پْرَتْیَیتَ سَ اِتِ وَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","یَدِ مَنُشْیَسْییتِ وَدامَسْتَرْہِ سَرْوّے لوکا اَسْمانْ پاشانَے رْہَنِشْیَنْتِ یَتو یوہَنْ بھَوِشْیَدْوادِیتِ سَرْوّے درِڈھَں جانَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","اَتَایوَ تے پْرَتْیُوچُح کَسْیاجْنَیا جاتَمْ اِتِ وَکْتُں نَ شَکْنُمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","تَدا یِیشُرَوَدَتْ تَرْہِ کَیاجْنَیا کَرْمّانْییتاتِ کَرومِیتِ چَ یُشْمانْ نَ وَکْشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","اَتھَ لوکاناں ساکْشاتْ سَ اِماں درِشْٹانْتَکَتھاں وَکْتُماریبھے، کَشْچِدْ دْراکْشاکْشیتْرَں کرِتْوا تَتْ کْشیتْرَں کرِشِیوَلاناں ہَسْتیشُ سَمَرْپْیَ بَہُکالارْتھَں دُورَدیشَں جَگامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","اَتھَ پھَلَکالے پھَلانِ گْرَہِیتُ کرِشِیوَلاناں سَمِیپے داسَں پْراہِنوتْ کِنْتُ کرِشِیوَلاسْتَں پْرَہرِتْیَ رِکْتَہَسْتَں وِسَسَرْجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","تَتَح سودھِپَتِح پُنَرَنْیَں داسَں پْریشَیاماسَ، تے تَمَپِ پْرَہرِتْیَ کُوْیَوَہرِتْیَ رِکْتَہَسْتَں وِسَسرِجُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","تَتَح سَ ترِتِییَوارَمْ اَنْیَں پْراہِنوتْ تے تَمَپِ کْشَتانْگَں کرِتْوا بَہِ رْنِچِکْشِپُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","تَدا کْشیتْرَپَتِ رْوِچارَیاماسَ، مَمیدانِیں کِں کَرْتَّوْیَں؟ مَمَ پْرِیے پُتْرے پْرَہِتے تے تَمَوَشْیَں درِشْٹْوا سَمادَرِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","کِنْتُ کرِشِیوَلاسْتَں نِرِیکْشْیَ پَرَسْپَرَں وِوِچْیَ پْروچُح، اَیَمُتَّرادھِکارِی آگَچّھَتَینَں ہَنْمَسْتَتودھِکاروسْماکَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","تَتَسْتے تَں کْشیتْرادْ بَہِ رْنِپاتْیَ جَگھْنُسْتَسْماتْ سَ کْشیتْرَپَتِسْتانْ پْرَتِ کِں کَرِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","سَ آگَتْیَ تانْ کرِشِیوَلانْ ہَتْوا پَریشاں ہَسْتیشُ تَتْکْشیتْرَں سَمَرْپَیِشْیَتِ؛ اِتِ کَتھاں شْرُتْوا تے وَدَنْ ایتادرِشِی گھَٹَنا نَ بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","کِنْتُ یِیشُسْتانَوَلوکْیَ جَگادَ، تَرْہِ، سْتھَپَتَیَح کَرِشْیَنْتِ گْراوانَں یَنْتُ تُچّھَکَں۔ پْرَدھانَپْرَسْتَرَح کونے سَ ایوَ ہِ بھَوِشْیَتِ۔ ایتَسْیَ شاسْتْرِییَوَچَنَسْیَ کِں تاتْپَرْیَّں؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","اَپَرَں تَتْپاشانوپَرِ یَح پَتِشْیَتِ سَ بھَںکْشْیَتے کِنْتُ یَسْیوپَرِ سَ پاشانَح پَتِشْیَتِ سَ تینَ دھُولِوَچْ چُورْنِیبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","سوسْماکَں وِرُدّھَں درِشْٹانْتَمِمَں کَتھِتَوانْ اِتِ جْناتْوا پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ تَدَیوَ تَں دھَرْتُں وَوانْچھُح کِنْتُ لوکیبھْیو بِبھْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","اَتَایوَ تَں پْرَتِ سَتَرْکاح سَنْتَح کَتھَں تَدْواکْیَدوشَں دھرِتْوا تَں دیشادھِپَسْیَ سادھُویشَدھارِنَشْچَرانْ تَسْیَ سَمِیپے پْریشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","تَدا تے تَں پَپْرَچّھُح، ہے اُپَدیشَکَ بھَوانْ یَتھارْتھَں کَتھَیَنْ اُپَدِشَتِ، کَمَپْیَنَپیکْشْیَ سَتْیَتْوینَیشْوَرَں مارْگَمُپَدِشَتِ، وَیَمیتَجّانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","کَیسَرَراجایَ کَروسْمابھِ رْدییو نَ وا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","سَ تیشاں وَنْچَنَں جْناتْواوَدَتْ کُتو ماں پَرِیکْشَدھْوے؟ ماں مُدْرامیکَں دَرْشَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","اِہَ لِکھِتا مُورْتِرِیَں نامَ چَ کَسْیَ؟ تےوَدَنْ کَیسَرَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","تَدا سَ اُواچَ، تَرْہِ کَیسَرَسْیَ دْرَوْیَں کَیسَرایَ دَتَّ؛ اِیشْوَرَسْیَ تُ دْرَوْیَمِیشْوَرایَ دَتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","تَسْمالّوکاناں ساکْشاتْ تَتْکَتھایاح کَمَپِ دوشَں دھَرْتُمَپْراپْیَ تے تَسْیوتَّرادْ آشْچَرْیَّں مَنْیَمانا مَونِنَسْتَسْتھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","اَپَرَنْچَ شْمَشانادُتّھانانَنْگِیکارِناں سِدُوکِناں کِیَنْتو جَنا آگَتْیَ تَں پَپْرَچّھُح، ");
INSERT INTO sanurd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ہے اُپَدیشَکَ شاسْتْرے مُوسا اَسْمانْ پْرَتِیتِ لِلیکھَ یَسْیَ بھْراتا بھارْیّایاں سَتْیاں نِحسَنْتانو مْرِیَتے سَ تَجّایاں وِوَہْیَ تَدْوَںشَمْ اُتْپادَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","تَتھاچَ کیچِتْ سَپْتَ بھْراتَرَ آسَنْ تیشاں جْییشْٹھو بھْراتا وِوَہْیَ نِرَپَتْیَح پْرانانْ جَہَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","اَتھَ دْوِتِییَسْتَسْیَ جایاں وِوَہْیَ نِرَپَتْیَح سَنْ مَمارَ۔ ترِتِییَشْچَ تامیوَ وْیُواہَ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","اِتّھَں سَپْتَ بھْراتَرَسْتامیوَ وِوَہْیَ نِرَپَتْیاح سَنْتو مَمْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","شیشے سا سْتْرِی چَ مَمارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","اَتَایوَ شْمَشانادُتّھانَکالے تیشاں سَپْتَجَناناں کَسْیَ سا بھارْیّا بھَوِشْیَتِ؟ یَتَح سا تیشاں سَپْتانامیوَ بھارْیّاسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","تَدا یِیشُح پْرَتْیُواچَ، ایتَسْیَ جَگَتو لوکا وِوَہَنْتِ واگْدَتّاشْچَ بھَوَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","کِنْتُ یے تَجَّگَتْپْراپْتِیوگْیَتْوینَ گَنِتاں بھَوِشْیَنْتِ شْمَشاناچّوتّھاسْیَنْتِ تے نَ وِوَہَنْتِ واگْدَتّاشْچَ نَ بھَوَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","تے پُنَ رْنَ مْرِیَنْتے کِنْتُ شْمَشانادُتّھاپِتاح سَنْتَ اِیشْوَرَسْیَ سَنْتاناح سْوَرْگِییَدُوتاناں سَدرِشاشْچَ بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","اَدھِکَنْتُ مُوساح سْتَمْبوپاکھْیانے پَرَمیشْوَرَ اِیبْراہِیمَ اِیشْوَرَ اِسْہاکَ اِیشْوَرو یاکُوبَشْچیشْوَرَ اِتْیُکْتْوا مرِتاناں شْمَشانادْ اُتّھانَسْیَ پْرَمانَں لِلیکھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","اَتَایوَ یَ اِیشْوَرَح سَ مرِتاناں پْرَبھُ رْنَ کِنْتُ جِیوَتامیوَ پْرَبھُح، تَنِّکَٹے سَرْوّے جِیوَنْتَح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","اِتِ شْرُتْوا کِیَنْتودھْیاپَکا اُوچُح، ہے اُپَدیشَکَ بھَوانْ بھَدْرَں پْرَتْیُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","اِتَح پَرَں تَں کِمَپِ پْرَشْٹَں تیشاں پْرَگَلْبھَتا نابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","پَشْچاتْ سَ تانْ اُواچَ، یَح کھْرِیشْٹَح سَ دایُودَح سَنْتانَ ایتاں کَتھاں لوکاح کَتھَں کَتھَیَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","یَتَح مَمَ پْرَبھُمِدَں واکْیَمَوَدَتْ پَرَمیشْوَرَح۔ تَوَ شَتْرُونَہَں یاوَتْ پادَپِیٹھَں کَرومِ نَ۔ تاوَتْ کالَں مَدِییے تْوَں دَکْشَپارْشْوَ اُپاوِشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","اِتِ کَتھاں دایُودْ سْوَیَں گِیتَگْرَنْتھےوَدَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","اَتَایوَ یَدِ دایُودْ تَں پْرَبھُں وَدَتِ، تَرْہِ سَ کَتھَں تَسْیَ سَنْتانو بھَوَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","پَشْچادْ یِیشُح سَرْوَّجَناناں کَرْنَگوچَرے شِشْیانُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","یےدھْیاپَکا دِیرْگھَپَرِچّھَدَں پَرِدھایَ بھْرَمَنْتِ، ہَٹّاپَنَیو رْنَمَسْکارے بھَجَنَگیہَسْیَ پْروچّاسَنے بھوجَنَگرِہَسْیَ پْرَدھانَسْتھانے چَ پْرِییَنْتی ");
INSERT INTO sanurd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","وِدھَواناں سَرْوَّسْوَں گْرَسِتْوا چھَلینَ دِیرْگھَکالَں پْرارْتھَیَنْتے چَ تیشُ ساوَدھانا بھَوَتَ، تیشامُگْرَدَنْڈو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","اَتھَ دھَنِلوکا بھانْڈاگارے دھَنَں نِکْشِپَنْتِ سَ تَدیوَ پَشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ایتَرْہِ کاچِدِّینا وِدھَوا پَنَدْوَیَں نِکْشِپَتِ تَدْ دَدَرْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","تَتو یِیشُرُواچَ یُشْمانَہَں یَتھارْتھَں وَدامِ، دَرِدْرییَں وِدھَوا سَرْوّیبھْیودھِکَں نْیَکْشیپْسِیتْ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","یَتونْیے سْوَپْراجْیَدھَنیبھْیَ اِیشْوَرایَ کِنْچِتْ نْیَکْشیپْسُح، کِنْتُ دَرِدْرییَں وِدھَوا دِنَیاپَنارْتھَں سْوَسْیَ یَتْ کِنْچِتْ سْتھِتَں تَتْ سَرْوَّں نْیَکْشیپْسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","اَپَرَنْچَ اُتَّمَپْرَسْتَرَیرُتْسرِشْٹَوْیَیشْچَ مَنْدِرَں سُشوبھَتیتَراں کَیشْچِدِتْیُکْتے سَ پْرَتْیُواچَ ");
INSERT INTO sanurd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","یُویَں یَدِدَں نِچَیَنَں پَشْیَتھَ، اَسْیَ پاشانَیکوپْیَنْیَپاشانوپَرِ نَ سْتھاسْیَتِ، سَرْوّے بھُوسادْبھَوِشْیَنْتِ کالویَمایاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","تَدا تے پَپْرَچّھُح، ہے گُرو گھَٹَنیدرِشِی کَدا بھَوِشْیَتِ؟ گھَٹَنایا ایتَسْیَسَشْچِہْنَں وا کِں بھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","تَدا سَ جَگادَ، ساوَدھانا بھَوَتَ یَتھا یُشْماکَں بھْرَمَں کوپِ نَ جَنَیَتِ، کھِیشْٹوہَمِتْیُکْتْوا مَمَ نامْرا بَہَوَ اُپَسْتھاسْیَنْتِ سَ کالَح پْرایینوپَسْتھِتَح، تیشاں پَشْچانْما گَچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","یُدّھَسْیوپَپْلَوَسْیَ چَ وارْتّاں شْرُتْوا ما شَنْکَدھْوَں، یَتَح پْرَتھَمَمْ ایتا گھَٹَنا اَوَشْیَں بھَوِشْیَنْتِ کِنْتُ ناپاتے یُگانْتو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","اَپَرَنْچَ کَتھَیاماسَ، تَدا دیشَسْیَ وِپَکْشَتْوینَ دیشو راجْیَسْیَ وِپَکْشَتْوینَ راجْیَمْ اُتّھاسْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ناناسْتھانیشُ مَہابھُوکَمْپو دُرْبھِکْشَں مارِی چَ بھَوِشْیَنْتِ، تَتھا وْیومَمَنْڈَلَسْیَ بھَیَنْکَرَدَرْشَنانْیَشْچَرْیَّلَکْشَنانِ چَ پْرَکاشَیِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","کِنْتُ سَرْوّاسامیتاساں گھَٹَناناں پُورْوَّں لوکا یُشْمانْ دھرِتْوا تاڈَیِشْیَنْتِ، بھَجَنالَیے کارایانْچَ سَمَرْپَیِشْیَنْتِ مَمَ نامَکارَنادْ یُشْمانْ بھُوپاناں شاسَکانانْچَ سَمُّکھَں نیشْیَنْتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ساکْشْیارْتھَمْ ایتانِ یُشْمانْ پْرَتِ گھَٹِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","تَدا کِمُتَّرَں وَکْتَوْیَمْ ایتَتْ نَ چِنْتَیِشْیامَ اِتِ مَنَحسُ نِشْچِتَنُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","وِپَکْشا یَسْماتْ کِمَپْیُتَّرَمْ آپَتِّنْچَ کَرْتُّں نَ شَکْشْیَنْتِ تادرِشَں واکْپَٹُتْوَں جْنانَنْچَ یُشْمَبھْیَں داسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","کِنْچَ یُویَں پِتْرا ماتْرا بھْراتْرا بَنْدھُنا جْناتْیا کُٹُمْبینَ چَ پَرَکَریشُ سَمَرْپَیِشْیَدھْوے؛ تَتَسْتے یُشْماکَں کَنْچَنَ کَنْچَنَ گھاتَیِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","مَمَ نامْنَح کارَناتْ سَرْوَّے رْمَنُشْیَے رْیُویَمْ رِتِییِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","کِنْتُ یُشْماکَں شِرَحکیشَیکوپِ نَ وِنَںکْشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","تَسْمادیوَ دھَیرْیَّمَوَلَمْبْیَ سْوَسْوَپْرانانْ رَکْشَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","اَپَرَنْچَ یِرُوشالَمْپُرَں سَینْیَویشْٹِتَں وِلوکْیَ تَسْیوچّھِنَّتایاح سَمَیَح سَمِیپَ اِتْیَوَگَمِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","تَدا یِہُودادیشَسْتھا لوکاح پَرْوَّتَں پَلایَنْتاں، یے چَ نَگَرے تِشْٹھَنْتِ تے دیشانْتَرَں پَلایَنْتا، یے چَ گْرامے تِشْٹھَنْتِ تے نَگَرَں نَ پْرَوِشَنْتُ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","یَتَسْتَدا سَمُچِتَدَنْڈَنایَ دھَرْمَّپُسْتَکے یانِ سَرْوّانِ لِکھِتانِ تانِ سَپھَلانِ بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","کِنْتُ یا یاسْتَدا گَرْبھَوَتْیَح سْتَنْیَداوْیَشْچَ تاماں دُرْگَتِ رْبھَوِشْیَتِ، یَتَ ایتالّوکانْ پْرَتِ کوپو دیشے چَ وِشَمَدُرْگَتِ رْگھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","وَسْتُتَسْتُ تے کھَنْگَدھارَپَرِوَّنْگَں لَپْسْیَنْتے بَدّھاح سَنْتَح سَرْوَّدیشیشُ نایِشْیَنْتے چَ کِنْچانْیَدیشِییاناں سَمَیوپَسْتھِتِپَرْیَّنْتَں یِرُوشالَمْپُرَں تَیح پَدَتَلَے رْدَلَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","سُورْیَّچَنْدْرَنَکْشَتْریشُ لَکْشَنادِ بھَوِشْیَنْتِ، بھُوِ سَرْوَّدیشِییاناں دُحکھَں چِنْتا چَ سِنْدھَو وِیچِیناں تَرْجَنَں گَرْجَنَنْچَ بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","بھُوبھَو بھاوِگھَٹَناں چِنْتَیِتْوا مَنُجا بھِیامرِتَکَلْپا بھَوِشْیَنْتِ، یَتو وْیومَمَنْڈَلے تیجَسْوِنو دولایَمانا بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","تَدا پَراکْرَمینا مَہاتیجَسا چَ میگھارُوڈھَں مَنُشْیَپُتْرَمْ آیانْتَں دْرَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","کِنْتْویتاساں گھَٹَنانامارَمْبھے سَتِ یُویَں مَسْتَکانْیُتّولْیَ اُورْدَدھْوَں دْرَکْشْیَتھَ، یَتو یُشْماکَں مُکْتیح کالَح سَوِدھو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","تَتَسْتینَیتَدرِشْٹانْتَکَتھا کَتھِتا، پَشْیَتَ اُڈُمْبَرادِورِکْشاناں ");
INSERT INTO sanurd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","نَوِینَپَتْرانِ جاتانِیتِ درِشْٹْوا نِداوَکالَ اُپَسْتھِتَ اِتِ یَتھا یُویَں جْناتُں شَکْنُتھَ، ");
INSERT INTO sanurd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","تَتھا سَرْوّاساماساں گھَٹَنانامْ آرَمْبھے درِشْٹے سَتِیشْوَرَسْیَ راجَتْوَں نِکَٹَمْ اِتْیَپِ جْناسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","یُشْمانَہَں یَتھارْتھَں وَدامِ، وِدْیَمانَلوکانامیشاں گَمَناتْ پُورْوَّمْ ایتانِ گھَٹِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","نَبھوبھُوورْلوپو بھَوِشْیَتِ مَمَ واکْ تُ کَداپِ لُپْتا نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","اَتَایوَ وِشَماشَنینَ پانینَ چَ ساںمارِکَچِنْتابھِشْچَ یُشْماکَں چِتّیشُ مَتّیشُ تَدِّنَمْ اَکَسْمادْ یُشْمانْ پْرَتِ یَتھا نوپَتِشْٹھَتِ تَدَرْتھَں سْویشُ ساوَدھاناسْتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","پرِتھِوِیسْتھَسَرْوَّلوکانْ پْرَتِ تَدِّنَمْ اُنْماتھَ اِوَ اُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","یَتھا یُویَمْ ایتَدْبھاوِگھَٹَنا اُتَّرْتُّں مَنُجَسُتَسْیَ سَمُّکھے سَںسْتھاتُنْچَ یوگْیا بھَوَتھَ کارَنادَسْماتْ ساوَدھاناح سَنْتو نِرَنْتَرَں پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","اَپَرَنْچَ سَ دِوا مَنْدِرَ اُپَدِشْیَ راچَے جَیتُنادْرِں گَتْواتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","تَتَح پْرَتْیُوشے لاکاسْتَتْکَتھاں شْروتُں مَنْدِرے تَدَنْتِکَمْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","اَپَرَنْچَ کِنْوَشُونْیَپُوپوتْسَوَسْیَ کالَ اُپَسْتھِتی ");
INSERT INTO sanurd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","پْرَدھانَیاجَکا اَدھْیایَکاشْچَ یَتھا تَں ہَنْتُں شَکْنُوَنْتِ تَتھوپایامْ اَچیشْٹَنْتَ کِنْتُ لوکیبھْیو بِبھْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ایتَسْتِنْ سَمَیے دْوادَشَشِشْییشُ گَنِتَ اِیشْکَرِیوتِییَرُوڈھِمانْ یو یِہُوداسْتَسْیانْتَحکَرَنَں شَیتاناشْرِتَتْواتْ ");
INSERT INTO sanurd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","سَ گَتْوا یَتھا یِیشُں تیشاں کَریشُ سَمَرْپَیِتُں شَکْنوتِ تَتھا مَنْتْرَناں پْرَدھانَیاجَکَیح سیناپَتِبھِشْچَ سَہَ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","تینَ تے تُشْٹاسْتَسْمَے مُدْراں داتُں پَنَں چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","تَتَح سونْگِیکرِتْیَ یَتھا لوکانامَگوچَرے تَں پَرَکَریشُ سَمَرْپَیِتُں شَکْنوتِ تَتھاوَکاشَں چیشْٹِتُماریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","اَتھَ کِنْوَشُونْیَپُوپوتْمَوَدِنے، اَرْتھاتْ یَسْمِنْ دِنے نِسْتاروتْسَوَسْیَ میشو ہَنْتَوْیَسْتَسْمِنْ دِنی ");
INSERT INTO sanurd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","یِیشُح پِتَرَں یوہَنَنْچاہُویَ جَگادَ، یُواں گَتْواسْماکَں بھوجَنارْتھَں نِسْتاروتْسَوَسْیَ دْرَوْیانْیاسادَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","تَدا تَو پَپْرَچّھَتُح کُچاسادَیاوو بھَوَتَح کیچّھا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","تَدا سووادِیتْ، نَگَرے پْرَوِشْٹے کَشْچِجَّلَکُمْبھَمادایَ یُواں ساکْشاتْ کَرِشْیَتِ سَ یَنِّویشَنَں پْرَوِشَتِ یُوامَپِ تَنِّویشَنَں تَتْپَشْچادِتْوا نِویشَنَپَتِمْ اِتِ واکْیَں وَدَتَں، ");
INSERT INTO sanurd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","یَتْراہَں نِسْتاروتْسَوَسْیَ بھوجْیَں شِشْیَیح سارْدّھَں بھوکْتُں شَکْنومِ ساتِتھِشالاा کُتْرَ؟ کَتھامِماں پْرَبھُسْتْواں پرِچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","تَتَح سَ جَنو دْوِتِییَپْرَکوشْٹھِییَمْ ایکَں شَسْتَں کوشْٹھَں دَرْشَیِشْیَتِ تَتْرَ بھوجْیَماسادَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","تَتَسْتَو گَتْوا تَدْواکْیانُسارینَ سَرْوَّں درِشْدْوا تَتْرَ نِسْتاروتْسَوِییَں بھوجْیَماسادَیاماسَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","اَتھَ کالَ اُپَسْتھِتے یِیشُ رْدْوادَشَبھِح پْریرِتَیح سَہَ بھوکْتُمُپَوِشْیَ کَتھِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","مَمَ دُحکھَبھوگاتْ پُورْوَّں یُبھابھِح سَہَ نِسْتاروتْسَوَسْیَیتَسْیَ بھوجْیَں بھوکْتُں مَیاتِوانْچھا کرِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","یُشْمانْ وَدامِ، یاوَتْکالَمْ اِیشْوَرَراجْیے بھوجَنَں نَ کَرِشْیے تاوَتْکالَمْ اِدَں نَ بھوکْشْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","تَدا سَ پانَپاتْرَمادایَ اِیشْوَرَسْیَ گُنانْ کِیرْتَّیِتْوا تیبھْیو دَتْواوَدَتْ، اِدَں گرِہْلِیتَ یُویَں وِبھَجْیَ پِوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","یُشْمانْ وَدامِ یاوَتْکالَمْ اِیشْوَرَراجَتْوَسْیَ سَںسْتھاپَنَں نَ بھَوَتِ تاوَدْ دْراکْشاپھَلَرَسَں نَ پاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","تَتَح پُوپَں گرِہِیتْوا اِیشْوَرَگُنانْ کِیرْتَّیِتْوا بھَنْکْتا تیبھْیو دَتْواوَدَتْ، یُشْمَدَرْتھَں سَمَرْپِتَں یَنْمَمَ وَپُسْتَدِدَں، ایتَتْ کَرْمَّ مَمَ سْمَرَنارْتھَں کُرُدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","اَتھَ بھوجَنانْتے تادرِشَں پاتْرَں گرِہِیتْواوَدَتْ، یُشْمَتْکرِتے پاتِتَں یَنْمَمَ رَکْتَں تینَ نِرْنِیتَنَوَنِیَمَرُوپَں پانَپاتْرَمِدَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","پَشْیَتَ یو ماں پَرَکَریشُ سَمَرْپَیِشْیَتِ سَ مَیا سَہَ بھوجَناسَنَ اُپَوِشَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","یَتھا نِرُوپِتَماسْتے تَدَنُسارینا مَنُشْیَپُुتْرَسْیَ گَتِ رْبھَوِشْیَتِ کِنْتُ یَسْتَں پَرَکَریشُ سَمَرْپَیِشْیَتِ تَسْیَ سَنْتاپو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","تَدا تیشاں کو جَنَ ایتَتْ کَرْمَّ کَرِشْیَتِ تَتْ تے پَرَسْپَرَں پْرَشْٹُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","اَپَرَں تیشاں کو جَنَح شْریشْٹھَتْوینَ گَنَیِشْیَتے، اَتْرارْتھے تیشاں وِوادوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","اَسْماتْ کارَناتْ سووَدَتْ، اَنْیَدیشِییاناں راجانَح پْرَجانامُپَرِ پْرَبھُتْوَں کُرْوَّنْتِ دارُنَشاسَنَں کرِتْواپِ تے بھُوپَتِتْوینَ وِکھْیاتا بھَوَنْتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","کِنْتُ یُشْماکَں تَتھا نَ بھَوِشْیَتِ، یو یُشْماکَں شْریشْٹھو بھَوِشْیَتِ سَ کَنِشْٹھَوَدْ بھَوَتُ، یَشْچَ مُکھْیو بھَوِشْیَتِ سَ سیوَکَوَدْبھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","بھوجَنوپَوِشْٹَپَرِچارَکَیوح کَح شْریشْٹھَح؟ یو بھوجَنایوپَوِشَتِ سَ کِں شْریشْٹھو نَ بھَوَتِ؟ کِنْتُ یُشْماکَں مَدھْیےہَں پَرِچارَکَاِواسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","اَپَرَنْچَ یُیَں مَمَ پَرِیکْشاکالے پْرَتھَمَمارَبھْیَ مَیا سَہَ سْتھِتا ");
INSERT INTO sanurd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ایتَتْکارَناتْ پِتْرا یَتھا مَدَرْتھَں راجْیَمیکَں نِرُوپِتَں تَتھاہَمَپِ یُشْمَدَرْتھَں راجْیَں نِرُوپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","تَسْمانْ مَمَ راجْیے بھوجَناسَنے چَ بھوجَنَپانے کَرِشْیَدھْوے سِںہاسَنیشُوپَوِشْیَ چیسْراییلِییاناں دْوادَشَوَںشاناں وِچارَں کَرِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","اَپَرَں پْرَبھُرُواچَ، ہے شِمونْ پَشْیَ تِتَاُنا دھانْیانِیوَ یُشْمانْ شَیتانْ چالَیِتُمْ اَیچّھَتْ، ");
INSERT INTO sanurd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","کِنْتُ تَوَ وِشْواسَسْیَ لوپو یَتھا نَ بھَوَتِ ایتَتْ تْوَدَرْتھَں پْرارْتھِتَں مَیا، تْوَنْمَنَسِ پَرِوَرْتِّتے چَ بھْراترِناں مَناںسِ سْتھِرِیکُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","تَدا سووَدَتْ، ہے پْرَبھوہَں تْوَیا سارْدّھَں کاراں مرِتِنْچَ یاتُں مَجِّتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","تَتَح سَ اُواچَ، ہے پِتَرَ تْواں وَدامِ، اَدْیَ کُکُّٹَرَواتْ پُورْوَّں تْوَں مَتْپَرِچَیَں وارَتْرَیَمْ اَپَہْووشْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","اَپَرَں سَ پَپْرَچّھَ، یَدا مُدْراسَمْپُٹَں کھادْیَپاتْرَں پادُکانْچَ وِنا یُشْمانْ پْراہِنَوَں تَدا یُشْماکَں کَسْیاپِ نْیُونَتاسِیتْ؟ تے پْروچُح کَسْیاپِ نَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","تَدا سووَدَتْ کِنْتْوِدانِیں مُدْراسَمْپُٹَں کھادْیَپاتْرَں وا یَسْیاسْتِ تینَ تَدْگْرَہِیتَوْیَں، یَسْیَ چَ کرِپانوे ناسْتِ تینَ سْوَوَسْتْرَں وِکْرِییَ سَ کْریتَوْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","یَتو یُشْمانَہَں وَدامِ، اَپَرادھِجَنَیح سارْدّھَں گَنِتَح سَ بھَوِشْیَتِ۔ اِدَں یَچّھاسْتْرِییَں وَچَنَں لِکھِتَمَسْتِ تَنْمَیِ پھَلِشْیَتِ یَتو مَمَ سَمْبَنْدھِییَں سَرْوَّں سیتْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","تَدا تے پْروچُح پْرَبھو پَشْیَ اِمَو کرِپانَو۔ تَتَح سووَدَدْ ایتَو یَتھیشْٹَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","اَتھَ سَ تَسْمادْوَہِ رْگَتْوا سْواچارانُسارینَ جَیتُنَنامادْرِں جَگامَ شِشْیاشْچَ تَتْپَشْچادْ یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","تَتْروپَسْتھایَ سَ تانُواچَ، یَتھا پَرِیکْشایاں نَ پَتَتھَ تَدَرْتھَں پْرارْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","پَشْچاتْ سَ تَسْمادْ ایکَشَرَکْشیپادْ بَہِ رْگَتْوا جانُنِی پاتَیِتْوا ایتَتْ پْرارْتھَیانْچَکْرے، ");
INSERT INTO sanurd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ہے پِتَ رْیَدِ بھَوانْ سَمَّنْیَتے تَرْہِ کَںسَمینَں مَمانْتِکادْ دُورَیَ کِنْتُ مَدِچّھانُرُوپَں نَ تْوَدِچّھانُرُوپَں بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","تَدا تَسْمَے شَکْتِں داتُں سْوَرْگِییَدُوتو دَرْشَنَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","پَشْچاتْ سوتْیَنْتَں یاتَنَیا وْیاکُلو بھُوتْوا پُنَرْدرِڈھَں پْرارْتھَیانْچَکْرے، تَسْمادْ برِہَچّھونِتَبِنْدَوَ اِوَ تَسْیَ سْویدَبِنْدَوَح پرِتھِوْیاں پَتِتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","اَتھَ پْرارْتھَناتَ اُتّھایَ شِشْیاناں سَمِیپَمیتْیَ تانْ مَنودُحکھِنو نِدْرِتانْ درِشْٹْواوَدَتْ ");
INSERT INTO sanurd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","کُتو نِدْراتھَ؟ پَرِیکْشایامْ اَپَتَنارْتھَں پْرَرْتھَیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ایتَتْکَتھایاح کَتھَنَکالے دْوادَشَشِشْیاناں مَدھْیے گَنِتو یِہُوداناما جَنَتاسَہِتَسْتیشامْ اَگْرے چَلِتْوا یِیشوشْچُمْبَنارْتھَں تَدَنْتِکَمْ آیَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","تَدا یِیشُرُواچَ، ہے یِہُودا کِں چُمْبَنینَ مَنُشْیَپُتْرَں پَرَکَریشُ سَمَرْپَیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","تَدا یَدْیَدْ گھَٹِشْیَتے تَدَنُمایَ سَنْگِبھِرُکْتَں، ہے پْرَبھو وَیَں کِ کھَنْگینَ گھاتَیِشْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","تَتَ ایکَح کَرَوالیناہَتْیَ پْرَدھانَیاجَکَسْیَ داسَسْیَ دَکْشِنَں کَرْنَں چِچّھیدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","اَدھُونا نِوَرْتَّسْوَ اِتْیُکْتْوا یِیشُسْتَسْیَ شْرُتِں سْپرِشْٹْوا سْوَسْیَں چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","پَشْچادْ یِیشُح سَمِیپَسْتھانْ پْرَدھانَیاجَکانْ مَنْدِرَسْیَ سیناپَتِینْ پْراچِیناںشْچَ جَگادَ، یُویَں کرِپانانْ یَشْٹِیںشْچَ گرِہِیتْوا ماں کِں چورَں دھَرْتُّمایاتاح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","یَداہَں یُشْمابھِح سَہَ پْرَتِدِنَں مَنْدِرےتِشْٹھَں تَدا ماں دھَرْتَّں نَ پْرَورِتّاح، کِنْتْوِدانِیں یُشْماکَں سَمَیونْدھَکارَسْیَ چادھِپَتْیَمَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","اَتھَ تے تَں دھرِتْوا مَہایاجَکَسْیَ نِویشَنَں نِنْیُح۔ تَتَح پِتَرو دُورے دُورے پَشْچادِتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","برِہَتْکوشْٹھَسْیَ مَدھْیے یَتْراگْنِں جْوالَیِتْوا لوکاح سَمیتْیوپَوِشْٹاسْتَتْرَ تَیح سارْدّھَمْ اُپَوِویشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","اَتھَ وَہْنِسَنِّدھَو سَمُپَویشَکالے کاچِدّاسِی مَنو نِوِشْیَ تَں نِرِیکْشْیاوَدَتْ پُمانَیَں تَسْیَ سَنْگےسْتھاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","کِنْتُ سَ تَدْ اَپَہْنُتْیاوادِیتْ ہے نارِ تَمَہَں نَ پَرِچِنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","کْشَنانْتَرےنْیَجَنَسْتَں درِشْٹْوابْرَوِیتْ تْوَمَپِ تیشاں نِکَرَسْیَیکَجَنوسِ۔ پِتَرَح پْرَتْیُواچَ ہے نَرَ ناہَمَسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","تَتَح سارْدّھَدَنْڈَدْوَیاتْ پَرَں پُنَرَنْیو جَنو نِشْچِتْیَ بَبھاشے، ایشَ تَسْیَ سَنْگِیتِ سَتْیَں یَتویَں گالِیلِییو لوکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","تَدا پِتَرَ اُواچَ ہے نَرَ تْوَں یَدْ وَدَمِ تَدَہَں بودّھُں نَ شَکْنومِ، اِتِ واکْیے کَتھِتَماتْرے کُکُّٹو رُراوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","تَدا پْرَبھُنا وْیادھُٹْیَ پِتَرے نِرِیکْشِتے کرِکَواکُرَواتْ پُورْوَّں ماں تْرِرَپَہْنوشْیَسے اِتِ پُورْوّوکْتَں تَسْیَ واکْیَں پِتَرَح سْمرِتْوا ");
INSERT INTO sanurd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","بَہِرْگَتْوا مَہاکھیدینَ چَکْرَنْدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","تَدا یَے رْیِیشُرْدھرِتَسْتے تَمُپَہَسْیَ پْرَہَرْتُّماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","وَسْتْرینَ تَسْیَ درِشَو بَدّھوا کَپولے چَپیٹاگھاتَں کرِتْوا پَپْرَچّھُح، کَسْتے کَپولے چَپیٹاگھاتَں کرِتَوانَ؟ گَنَیِتْوا تَدْ وَدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","تَدَنْیَتْ تَدْوِرُدّھَں بَہُنِنْداواکْیَں وَکْتُماریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","اَتھَ پْرَبھاتے سَتِ لوکَپْرانْچَح پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ سَبھاں کرِتْوا مَدھْییسَبھَں یِیشُمانِییَ پَپْرَچّھُح، تْوَمْ اَبھِشِکَتوسِ نَ واسْمانْ وَدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","سَ پْرَتْیُواچَ، مَیا تَسْمِنُّکْتےپِ یُویَں نَ وِشْوَسِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","کَسْمِںشْچِدْواکْیے یُشْمانْ پرِشْٹےپِ ماں نَ تَدُتَّرَں وَکْشْیَتھَ نَ ماں تْیَکْشْیَتھَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","کِنْتْوِتَح پَرَں مَنُجَسُتَح سَرْوَّشَکْتِمَتَ اِیشْوَرَسْیَ دَکْشِنے پارْشْوے سَمُپَویکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","تَتَسْتے پَپْرَچّھُح، رْتِہَ تْوَمِیشْوَرَسْیَ پُتْرَح؟ سَ کَتھَیاماسَ، یُویَں یَتھارْتھَں وَدَتھَ سَ ایواہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","تَدا تے سَرْوّے کَتھَیاماسُح، رْتِہَ ساکْشْیےنْسَسْمِنْ اَسْماکَں کِں پْرَیوجَنَں؟ اَسْیَ سْوَمُکھادیوَ ساکْشْیَں پْراپْتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","تَتَح سَبھاسْتھاح سَرْوَّلوکا اُتّھایَ تَں پِیلاتَسَمُّکھَں نِیتْواپْرودْیَ وَکْتُماریبھِرے، ");
INSERT INTO sanurd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","سْوَمَبھِشِکْتَں راجانَں وَدَنْتَں کَیمَرَراجایَ کَرَدانَں نِشیدھَنْتَں راجْیَوِپَرْیَّیَں کُرْتُّں پْرَوَرْتَّمانَمْ اینَ پْراپْتا وَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","تَدا پِیلاتَسْتَں پرِشْٹَوانْ تْوَں کِں یِہُودِییاناں راجا؟ سَ پْرَتْیُواچَ تْوَں سَتْیَمُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","تَدا پِیلاتَح پْرَدھانَیاجَکادِلوکانْ جَگادْ، اَہَمیتَسْیَ کَمَپْیَپَرادھَں ناپْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","تَتَسْتے پُنَح ساہَمِنو بھُوتْواوَدَنْ، ایشَ گالِیلَ ایتَتْسْتھانَپَرْیَّنْتے سَرْوَّسْمِنْ یِہُودادیشے سَرْوّالّوکانُپَدِشْیَ کُپْرَورِتِّں گْراہِیتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","تَدا پِیلاتو گالِیلَپْرَدیشَسْیَ نامَ شْرُتْوا پَپْرَچّھَ، کِمَیَں گالِیلِییو لوکَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","تَتَح سَ گالِیلْپْرَدیشِییَہیرودْراجَسْیَ تَدا سْتھِتیسْتَسْیَ سَمِیپے یِیشُں پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","تَدا ہیرودْ یِیشُں وِلوکْیَ سَنْتُتوشَ، یَتَح سَ تَسْیَ بَہُورِتّانْتَشْرَوَناتْ تَسْیَ کِن्ِچَداشْچَرْیَّکَرْمَّ پَشْیَتِ اِتْیاشاں کرِتْوا بَہُکالَمارَبھْیَ تَں دْرَشْٹُں پْرَیاسَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","تَسْماتْ تَں بَہُکَتھاح پَپْرَچّھَ کِنْتُ سَ تَسْیَ کَسْیاپِ واکْیَسْیَ پْرَتْیُتَّرَں نوواچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","اَتھَ پْرَدھانَیاجَکا اَدھْیاپَکاشْچَ پْروتِّشْٹھَنْتَح ساہَسینَ تَمَپَوَدِتُں پْراریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ہیرودْ تَسْیَ سیناگَنَشْچَ تَمَوَجْنایَ اُپَہاسَتْوینَ راجَوَسْتْرَں پَرِدھاپْیَ پُنَح پِیلاتَں پْرَتِ تَں پْراہِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","پُورْوَّں ہیرودْپِیلاتَیوح پَرَسْپَرَں وَیرَبھاوَ آسِیتْ کِنْتُ تَدِّنے دْوَیو رْمیلَنَں جاتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","پَشْچاتْ پِیلاتَح پْرَدھانَیاجَکانْ شاسَکانْ لوکاںشْچَ یُگَپَداہُویَ بَبھاشے، ");
INSERT INTO sanurd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","راجْیَوِپَرْیَّیَکارَکویَمْ اِتْیُکْتْوا مَنُشْیَمینَں مَمَ نِکَٹَمانَیشْٹَ کِنْتُ پَشْیَتَ یُشْماکَں سَمَکْشَمْ اَسْیَ وِچارَں کرِتْواپِ پْروکْتاپَوادانُرُوپیناسْیَ کوپْیَپَرادھَح سَپْرَمانو نَ جاتَح، ");
INSERT INTO sanurd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","یُویَنْچَ ہیرودَح سَنِّدھَو پْریشِتا مَیا تَتْراسْیَ کوپْیَپَرادھَسْتیناپِ نَ پْراپْتَح۔ پَشْیَتانینَ وَدھَہےेتُکَں کِمَپِ ناپَرادّھَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","تَسْمادینَں تاڈَیِتْوا وِہاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","تَتْروتْسَوے تیشامیکو موچَیِتَوْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","اِتِ ہیتوسْتے پْروچَّیریکَدا پْروچُح، اینَں دُورِیکرِتْیَ بَرَبّانامانَں موچَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","سَ بَرَبّا نَگَرَ اُپَپْلَوَوَدھاپَرادھابھْیاں کارایاں بَدّھَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","کِنْتُ پِیلاتو یِیشُں موچَیِتُں وانْچھَنْ پُنَسْتانُواچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","تَتھاپْیینَں کْرُشے وْیَدھَ کْرُشے وْیَدھیتِ وَدَنْتَسْتے رُرُوُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","تَتَح سَ ترِتِییَوارَں جَگادَ کُتَح؟ سَ کِں کَرْمَّ کرِتَوانْ؟ ناہَمَسْیَ کَمَپِ وَدھاپَرادھَں پْراپْتَح کیوَلَں تاڈَیِتْوامُں تْیَجامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","تَتھاپِ تے پُنَرینَں کْرُشے وْیَدھَ اِتْیُکْتْوا پْروچَّیرْدرِڈھَں پْرارْتھَیانْچَکْرِرے؛ ");
INSERT INTO sanurd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","تَتَح پْرَدھانَیاجَکادِیناں کَلَرَوے پْرَبَلے سَتِ تیشاں پْرارْتھَنارُوپَں کَرْتُّں پِیلاتَ آدِدیشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","راجَدْروہَوَدھَیورَپَرادھینَ کاراسْتھَں یَں جَنَں تے یَیاچِرے تَں موچَیِتْوا یِیشُں تیشامِچّھایاں سَمارْپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","اَتھَ تے یِیشُں گرِہِیتْوا یانْتِ، ایتَرْہِ گْراماداگَتَں شِمونَنامانَں کُرِینِییَں جَنَں دھرِتْوا یِیشوح پَشْچانّیتُں تَسْیَ سْکَنْدھے کْرُشَمَرْپَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","تَتو لوाکارَنْیَمَدھْیے بَہُسْتْرِیو رُدَتْیو وِلَپَنْتْیَشْچَ یِیشوح پَشْچادْ یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","کِنْتُ سَ وْیاگھُٹْیَ تا اُواچَ، ہے یِرُوشالَمو نارْیّو یُیَں مَدَرْتھَں نَ رُدِتْوا سْوارْتھَں سْواپَتْیارْتھَنْچَ رُدِتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","پَشْیَتَ یَح کَداپِ گَرْبھَوَتْیو نابھَوَنْ سْتَنْیَنْچَ ناپایَیَنْ تادرِشِی رْوَنْدھْیا یَدا دھَنْیا وَکْشْیَنْتِ سَ کالَ آیاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","تَدا ہے شَیلا اَسْماکَمُپَرِ پَتَتَ، ہے اُپَشَیلا اَسْماناچّھادَیَتَ کَتھامِیدرِشِیں لوکا وَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","یَتَح سَتیجَسِ شاکھِنِ چیدیتَدْ گھَٹَتے تَرْہِ شُشْکَشاکھِنِ کِں نَ گھَٹِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","تَدا تے ہَنْتُں دْواوَپَرادھِنَو تینَ سارْدّھَں نِنْیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","اَپَرَں شِرَحکَپالَنامَکَسْتھانَں پْراپْیَ تَں کْرُشے وِوِدھُح؛ تَدّوَیورَپَرادھِنوریکَں تَسْیَ دَکْشِنو تَدَنْیَں وامے کْرُشے وِوِدھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","تَدا یِیشُرَکَتھَیَتْ، ہے پِتَریتانْ کْشَمَسْوَ یَتَ ایتے یَتْ کَرْمَّ کُرْوَّنْتِ تَنْ نَ وِدُح؛ پَشْچاتّے گُٹِکاپاتَں کرِتْوا تَسْیَ وَسْتْرانِ وِبھَجْیَ جَگرِہُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","تَتْرَ لوکَسَںگھَسْتِشْٹھَنْ دَدَرْشَ؛ تے تیشاں شاسَکاشْچَ تَمُپَہَسْیَ جَگَدُح، ایشَ اِتَرانْ رَکْشِتَوانْ یَدِیشْوَرینابھِرُچِتو بھِشِکْتَسْتْراتا بھَوَتِ تَرْہِ سْوَمَدھُنا رَکْشَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","تَدَنْیَح سیناگَنا ایتْیَ تَسْمَے اَمْلَرَسَں دَتْوا پَرِہَسْیَ پْروواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","چیتّوَں یِہُودِییاناں راجاسِ تَرْہِ سْوَں رَکْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","یِہُودِییاناں راجیتِ واکْیَں یُونانِییَرومِیییبْرِییاکْشَرَے رْلِکھِتَں تَچّھِرَسَ اُورْدّھوےسْتھاپْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","تَدوبھَیَپارْشْوَیو رْوِدّھَو یاوَپَرادھِنَو تَیوریکَسْتَں وِنِنْدْیَ بَبھاشے، چیتّوَمْ اَبھِشِکْتوسِ تَرْہِ سْوَماوانْچَ رَکْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","کِنْتْوَنْیَسْتَں تَرْجَیِتْواوَدَتْ، اِیشْوَراتَّوَ کِنْچِدَپِ بھَیَں ناسْتِ کِں؟ تْوَمَپِ سَمانَدَنْڈوسِ، ");
INSERT INTO sanurd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","یوگْیَپاتْرے آواں سْوَسْوَکَرْمَّناں سَمُچِتَپھَلَں پْراپْنُوَح کِنْتْوَنینَ کِمَپِ ناپَرادّھَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","اَتھَ سَ یِیشُں جَگادَ ہے پْرَبھے بھَوانْ سْوَراجْیَپْرَویشَکالے ماں سْمَرَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","تَدا یِیشُح کَتھِتَوانْ تْواں یَتھارْتھَں وَدامِ تْوَمَدْیَیوَ مَیا سارْدّھَں پَرَلوکَسْیَ سُکھَسْتھانَں پْراپْسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","اَپَرَنْچَ دْوِتِییَیاماتْ ترِتِییَیامَپَرْیَّنْتَں رَویسْتیجَسونْتَرْہِتَتْواتْ سَرْوَّدیشونْدھَکاریناورِتو ");
INSERT INTO sanurd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","مَنْدِرَسْیَ یَوَنِکا چَ چھِدْیَمانا دْوِدھا بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","تَتو یِیشُرُچَّیرُواچَ، ہے پِتَ رْمَماتْمانَں تَوَ کَرے سَمَرْپَیے، اِتْیُکْتْوا سَ پْرانانْ جَہَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","تَدَیتا گھَٹَنا درِشْٹْوا شَتَسیناپَتِرِیشْوَرَں دھَنْیَمُکْتْوا کَتھِتَوانْ اَیَں نِتانْتَں سادھُمَنُشْیَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","اَتھَ یاوَنْتو لوکا دْرَشْٹُمْ آگَتاسْتے تا گھَٹَنا درِشْٹْوا وَکْشَحسُ کَراگھاتَں کرِتْوا وْیاچُٹْیَ گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","یِیشو رْجْناتَیو یا یا یوشِتَشْچَ گالِیلَسْتینَ سارْدّھَمایاتاسْتا اَپِ دُورے سْتھِتْوا تَتْ سَرْوَّں دَدرِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","تَدا یِہُودِییاناں مَنْتْرَناں کْرِیانْچاسَمَّنْیَمانَ اِیشْوَرَسْیَ راجَتْوَمْ اَپیکْشَمانو ");
INSERT INTO sanurd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","یِہُودِدیشِییو رِمَتھِییَنَگَرِییو یُوشَپھْناما مَنْتْرِی بھَدْرو دھارْمِّکَشْچَ پُمانْ ");
INSERT INTO sanurd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","پِیلاتانْتِکَں گَتْوا یِیشو رْدیہَں یَیاچے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","پَشْچادْ وَپُرَوَروہْیَ واسَسا سَںویشْٹْیَ یَتْرَ کوپِ مانُشو ناسْتھاپْیَتَ تَسْمِنْ شَیلے سْواتے شْمَشانے تَدَسْتھاپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","تَدِّنَمایوجَنِییَں دِنَں وِشْرامَوارَشْچَ سَمِیپَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","اَپَرَں یِیشُنا سارْدّھَں گالِیلَ آگَتا یوشِتَح پَشْچادِتْوا شْمَشانے تَتْرَ یَتھا وَپُح سْتھاپِتَں تَچَّ درِشْٹْوا ");
INSERT INTO sanurd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","وْیاگھُٹْیَ سُگَنْدھِدْرَوْیَتَیلانِ کرِتْوا وِدھِوَدْ وِشْرامَوارے وِشْرامَں چَکْرُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","اَتھَ سَپْتاہَپْرَتھَمَدِنےتِپْرَتْیُوشے تا یوشِتَح سَمْپادِتَں سُگَنْدھِدْرَوْیَں گرِہِیتْوا تَدَنْیابھِح کِیَتِیبھِح سْتْرِیبھِح سَہَ شْمَشانَں یَیُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","کِنْتُ شْمَشانَدْواراتْ پاشانَمَپَسارِتَں درِشْٹْوا ");
INSERT INTO sanurd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","تاح پْرَوِشْیَ پْرَبھو رْدیہَمَپْراپْیَ ");
INSERT INTO sanurd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","وْیاکُلا بھَوَنْتِ ایتَرْہِ تیجومَیَوَسْتْرانْوِتَو دْوَو پُرُشَو تاساں سَمِیپے سَمُپَسْتھِتَو ");
INSERT INTO sanurd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","تَسْماتّاح شَنْکایُکْتا بھُوماوَدھومُکھْیَسْیَسْتھُح۔ تَدا تَو تا اُوچَتُ رْمرِتاناں مَدھْیے جِیوَنْتَں کُتو مرِگَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","سوتْرَ ناسْتِ سَ اُدَسْتھاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","پاپِناں کَریشُ سَمَرْپِتینَ کْرُشے ہَتینَ چَ مَنُشْیَپُتْرینَ ترِتِییَدِوَسے شْمَشانادُتّھاتَوْیَمْ اِتِ کَتھاں سَ گَلِیلِ تِشْٹھَنْ یُشْمَبھْیَں کَتھِتَوانْ تاں سْمَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","تَدا تَسْیَ سا کَتھا تاساں مَنَحسُ جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","اَنَنْتَرَں شْمَشانادْ گَتْوا تا ایکادَشَشِشْیادِبھْیَح سَرْوّیبھْیَسْتاں وارْتّاں کَتھَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","مَگْدَلِینِیمَرِیَمْ، یوہَنا، یاکُوبو ماتا مَرِیَمْ تَدَنْیاح سَنْگِنْیو یوشِتَشْچَ پْریرِتیبھْیَ ایتاح سَرْوّا وارْتّاح کَتھَیاماسُح ");
INSERT INTO sanurd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","کِنْتُ تاساں کَتھامْ اَنَرْتھَکاکھْیانَماتْرَں بُدّھوا کوپِ نَ پْرَتْیَیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","تَدا پِتَرَ اُتّھایَ شْمَشانانْتِکَں دَدھاوَ، تَتْرَ چَ پْرَہْوو بھُوتْوا پارْشْوَیکَسْتھاپِتَں کیوَلَں وَسْتْرَں دَدَرْشَ؛ تَسْماداشْچَرْیَّں مَنْیَمانو یَدَگھَٹَتَ تَنْمَنَسِ وِچارَیَنْ پْرَتَسْتھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","تَسْمِنّیوَ دِنے دْوَو شِیَّو یِرُوشالَمَشْچَتُشْکْروشانْتَرِتَمْ اِمّایُگْرامَں گَچّھَنْتَو ");
INSERT INTO sanurd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","تاساں گھَٹَناناں کَتھامَکَتھَیَتاں ");
INSERT INTO sanurd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","تَیورالاپَوِچارَیوح کالے یِیشُراگَتْیَ تابھْیاں سَہَ جَگامَ ");
INSERT INTO sanurd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","کِنْتُ یَتھا تَو تَں نَ پَرِچِنُتَسْتَدَرْتھَں تَیو رْدرِشْٹِح سَںرُدّھا۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","سَ تَو پرِشْٹَوانْ یُواں وِشَنَّو کِں وِچارَیَنْتَو گَچّھَتھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","تَتَسْتَیوح کْلِیَپاناما پْرَتْیُواچَ یِرُوشالَمَپُرےدھُنا یانْیَگھَٹَنْتَ تْوَں کیوَلَوِدیشِی کِں تَدْورِتّانْتَں نَ جاناسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","سَ پَپْرَچّھَ کا گھَٹَناح؟ تَدا تَو وَکْتُماریبھاتے یِیشُناما یو ناسَرَتِییو بھَوِشْیَدْوادِی اِیشْوَرَسْیَ مانُشانانْچَ ساکْشاتْ واکْیے کَرْمَّنِ چَ شَکْتِماناسِیتْ ");
INSERT INTO sanurd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","تَمْ اَسْماکَں پْرَدھانَیاجَکا وِچارَکاشْچَ کیناپِ پْرَکارینَ کْرُشے وِدّھوا تَسْیَ پْرانانَناشَیَنْ تَدِییا گھَٹَناح؛ ");
INSERT INTO sanurd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","کِنْتُ یَ اِسْراییلِییَلوکانْ اُدّھارَیِشْیَتِ سَ ایوایَمْ اِتْیاشاسْمابھِح کرِتا۔ تَدْیَتھا تَتھاسْتُ تَسْیا گھَٹَنایا اَدْیَ دِنَتْرَیَں گَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","اَدھِکَنْتْوَسْماکَں سَنْگِنِیناں کِیَتْسْتْرِیناں مُکھیبھْیوسَمْبھَوَواکْیَمِدَں شْرُتَں؛ ");
INSERT INTO sanurd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","تاح پْرَتْیُوشے شْمَشانَں گَتْوا تَتْرَ تَسْیَ دیہَمْ اَپْراپْیَ وْیاگھُٹْییتْوا پْروکْتَوَتْیَح سْوَرْگِیسَدُوتَو درِشْٹاوَسْمابھِسْتَو چاوادِشْٹاں سَ جِیوِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","تَتوسْماکَں کَیشْچِتْ شْمَشانَمَگَمْیَتَ تےپِ سْتْرِیناں واکْیانُرُوپَں درِشْٹَوَنْتَح کِنْتُ تَں ناپَشْیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","تَدا سَ تاوُواچَ، ہے اَبودھَو ہے بھَوِشْیَدْوادِبھِرُکْتَواکْیَں پْرَتْییتُں وِلَمْبَمانَو؛ ");
INSERT INTO sanurd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ایتَتْسَرْوَّدُحکھَں بھُکْتْوا سْوَبھُوتِپْراپْتِح کِں کھْرِیشْٹَسْیَ نَ نْیایّا؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","تَتَح سَ مُوساگْرَنْتھَمارَبھْیَ سَرْوَّبھَوِشْیَدْوادِناں سَرْوَّشاسْتْرے سْوَسْمِنْ لِکھِتاکھْیانابھِپْرایَں بودھَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","اَتھَ گَمْیَگْرامابھْیَرْنَں پْراپْیَ تیناگْرے گَمَنَلَکْشَنے دَرْشِتی ");
INSERT INTO sanurd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","تَو سادھَیِتْواوَدَتاں سَہاوابھْیاں تِشْٹھَ دِنے گَتے سَتِ راتْرِرَبھُوتْ؛ تَتَح سَ تابھْیاں سارْدّھَں سْتھاتُں گرِہَں یَیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","پَشْچادْبھوجَنوپَویشَکالے سَ پُوپَں گرِہِیتْوا اِیشْوَرَگُنانْ جَگادَ تَنْچَ بھَںکْتْوا تابھْیاں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","تَدا تَیو رْدرِشْٹَو پْرَسَنّایاں تَں پْرَتْیَبھِجْنَتُح کِنْتُ سَ تَیوح ساکْشادَنْتَرْدَدھے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","تَتَسْتَو مِتھوبھِدھاتُمْ آرَبْدھَوَنْتَو گَمَنَکالے یَدا کَتھامَکَتھَیَتْ شاسْتْرارْتھَنْچَبودھَیَتْ تَداوَیو رْبُدّھِح کِں نَ پْراجْوَلَتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","تَو تَتْکْشَنادُتّھایَ یِرُوشالَمَپُرَں پْرَتْیایَیَتُح، تَتْسْتھانے شِشْیانامْ ایکادَشاناں سَنْگِنانْچَ دَرْشَنَں جاتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","تے پْروچُح پْرَبھُرُدَتِشْٹھَدْ اِتِ سَتْیَں شِمونے دَرْشَنَمَداچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","تَتَح پَتھَح سَرْوَّگھَٹَنایاح پُوپَبھَنْجَنینَ تَتْپَرِچَیَسْیَ چَ سَرْوَّورِتّانْتَں تَو وَکْتُماریبھاتے۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","اِتّھَں تے پَرَسْپَرَں وَدَنْتِ تَتْکالے یِیشُح سْوَیَں تیشاں مَدھْیَ پْروتّھَیَ یُشْماکَں کَلْیانَں بھُویادْ اِتْیُواچَ، ");
INSERT INTO sanurd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","کِنْتُ بھُوتَں پَشْیامَ اِتْیَنُمایَ تے سَمُدْوِوِجِرے تْریشُشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","سَ اُواچَ، کُتو دُحکھِتا بھَوَتھَ؟ یُشْماکَں مَنَحسُ سَنْدیہَ اُدیتِ چَ کُتَح؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ایشوہَں، مَمَ کَرَو پَشْیَتَ وَرَں سْپرِشْٹْوا پَشْیَتَ، مَمَ یادرِشانِ پَشْیَتھَ تادرِشانِ بھُوتَسْیَ ماںساسْتھِینِ نَ سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","اِتْیُکْتْوا سَ ہَسْتَپادانْ دَرْشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","تےسَمْبھَوَں جْناتْوا سانَنْدا نَ پْرَتْیَیَنْ۔ تَتَح سَ تانْ پَپْرَچّھَ، اَتْرَ یُشْماکَں سَمِیپے کھادْیَں کِنْچِدَسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","تَتَسْتے کِیَدَّگْدھَمَتْسْیَں مَدھُ چَ دَدُح ");
INSERT INTO sanurd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","سَ تَدادایَ تیشاں ساکْشادْ بُبھُجی ");
INSERT INTO sanurd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","کَتھَیاماسَ چَ مُوساوْیَوَسْتھایاں بھَوِشْیَدْوادِناں گْرَنْتھیشُ گِیتَپُسْتَکے چَ مَیِ یانِ سَرْوّانِ وَچَنانِ لِکھِتانِ تَدَنُرُوپانِ گھَٹِشْیَنْتے یُشْمابھِح سارْدّھَں سْتھِتْواہَں یَدیتَدْواکْیَمْ اَوَدَں تَدِدانِیں پْرَتْیَکْشَمَبھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","اَتھَ تیبھْیَح شاسْتْرَبودھادھِکارَں دَتْواوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","کھْرِیشْٹینیتّھَں مرِتِیاتَنا بھوکْتَوْیا ترِتِییَدِنے چَ شْمَشانادُتّھاتَوْیَنْچیتِ لِپِرَسْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","تَنّامْنا یِرُوشالَمَمارَبھْیَ سَرْوَّدیشے مَنَحپَراوَرْتَّنَسْیَ پاپَموچَنَسْیَ چَ سُسَںوادَح پْرَچارَیِتَوْیَح، ");
INSERT INTO sanurd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ایشُ سَرْوّیشُ یُویَں ساکْشِنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","اَپَرَنْچَ پَشْیَتَ پِتْرا یَتْ پْرَتِجْناتَں تَتْ پْریشَیِشْیامِ، اَتَایوَ یاوَتْکالَں یُویَں سْوَرْگِییاں شَکْتِں نَ پْراپْسْیَتھَ تاوَتْکالَں یِرُوشالَمْنَگَرے تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","اَتھَ سَ تانْ بَیتھَنِییاپَرْیَّنْتَں نِیتْوا ہَسْتاوُتّولْیَ آشِشَ وَکْتُماریبھی ");
INSERT INTO sanurd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","آشِشَں وَدَنّیوَ چَ تیبھْیَح پرِتھَگْ بھُوتْوا سْوَرْگایَ نِیتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","تَدا تے تَں بھَجَمانا مَہانَنْدینَ یِرُوشالَمَں پْرَتْیاجَگْمُح۔ ");
INSERT INTO sanurd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","تَتو نِرَنْتَرَں مَنْدِرے تِشْٹھَنْتَ اِیشْوَرَسْیَ پْرَشَںساں دھَنْیَوادَنْچَ کَرْتَّمْ آریبھِرے۔ اِتِ۔۔");
INSERT INTO sanurd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","آدَو وادَ آسِیتْ سَ چَ وادَ اِیشْوَرینَ سارْدھَماسِیتْ سَ وادَح سْوَیَمِیشْوَرَ ایوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","سَ آداوِیشْوَرینَ سَہاسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","تینَ سَرْوَّں وَسْتُ سَسرِجے سَرْوّیشُ سرِشْٹَوَسْتُشُ کِمَپِ وَسْتُ تیناسرِشْٹَں ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","سَ جِیوَنَسْیاکارَح، تَچَّ جِیوَنَں مَنُشْیاناں جْیوتِح ");
INSERT INTO sanurd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","تَجّیوتِرَنْدھَکارے پْرَچَکاشے کِنْتْوَنْدھَکارَسْتَنَّ جَگْراہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","یوہَنْ نامَکَ ایکو مَنُجَ اِیشْوَرینَ پْریشَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","تَدْوارا یَتھا سَرْوّے وِشْوَسَنْتِ تَدَرْتھَں سَ تَجّیوتِشِ پْرَمانَں داتُں ساکْشِسْوَرُوپو بھُوتْواگَمَتْ، ");
INSERT INTO sanurd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","سَ سْوَیَں تَجّیوتِ رْنَ کِنْتُ تَجّیوتِشِ پْرَمانَں داتُماگَمَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","جَگَتْیاگَتْیَ یَح سَرْوَّمَنُجیبھْیو دِیپْتِں دَداتِ تَدیوَ سَتْیَجْیوتِح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","سَ یَجَّگَدَسرِجَتْ تَنْمَدْیَ ایوَ سَ آسِیتْ کِنْتُ جَگَتو لوکاسْتَں ناجانَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","نِجادھِکارَں سَ آگَچّھَتْ کِنْتُ پْرَجاسْتَں ناگرِہْلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","تَتھاپِ یے یے تَمَگرِہْلَنْ اَرْتھاتْ تَسْیَ نامْنِ وْیَشْوَسَنْ تیبھْیَ اِیشْوَرَسْیَ پُتْرا بھَوِتُمْ اَدھِکارَمْ اَدَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","تیشاں جَنِح شونِتانَّ شارِیرِکابھِلاشانَّ مانَوانامِچّھاتو نَ کِنْتْوِیشْوَرادَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","سَ وادو مَنُشْیَرُوپیناوَتِیرْیَّ سَتْیَتانُگْرَہابھْیاں پَرِپُورْنَح سَنْ سارْدھَمْ اَسْمابھِ رْنْیَوَسَتْ تَتَح پِتُرَدْوِتِییَپُتْرَسْیَ یوگْیو یو مَہِما تَں مَہِمانَں تَسْیاپَشْیامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","تَتو یوہَنَپِ پْرَچارْیَّ ساکْشْیَمِدَں دَتَّوانْ یو مَمَ پَشْچادْ آگَمِشْیَتِ سَ مَتّو گُرُتَرَح؛ یَتو مَتْپُورْوَّں سَ وِدْیَمانَ آسِیتْ؛ یَدَرْتھَمْ اَہَں ساکْشْیَمِدَمْ اَداں سَ ایشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","اَپَرَنْچَ تَسْیَ پُورْنَتایا وَیَں سَرْوّے کْرَمَشَح کْرَمَشونُگْرَہَں پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","مُوسادْوارا وْیَوَسْتھا دَتّا کِنْتْوَنُگْرَہَح سَتْیَتْوَنْچَ یِیشُکھْرِیشْٹَدْوارا سَمُپاتِشْٹھَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","کوپِ مَنُجَ اِیشْوَرَں کَداپِ ناپَشْیَتْ کِنْتُ پِتُح کْروڈَسْتھودْوِتِییَح پُتْرَسْتَں پْرَکاشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","تْوَں کَح؟ اِتِ واکْیَں پْریشْٹُں یَدا یِہُودِییَلوکا یاجَکانْ لیوِلوکاںشْچَ یِرُوشالَمو یوہَنَح سَمِیپے پْریشَیاماسُح، ");
INSERT INTO sanurd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","تَدا سَ سْوِیکرِتَوانْ ناپَہْنُوتَوانْ ناہَمْ اَبھِشِکْتَ اِتْیَنْگِیکرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","تَدا تےپرِچّھَنْ تَرْہِ کو بھَوانْ؟ کِں ایلِیَح؟ سووَدَتْ نَ؛ تَتَسْتےپرِچّھَنْ تَرْہِ بھَوانْ سَ بھَوِشْیَدْوادِی؟ سووَدَتْ ناہَں سَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","تَدا تےپرِچّھَنْ تَرْہِ بھَوانْ کَح؟ وَیَں گَتْوا پْریرَکانْ تْوَیِ کِں وَکْشْیامَح؟ سْوَسْمِنْ کِں وَدَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","تَدا سووَدَتْ۔ پَرَمیشَسْیَ پَنْتھانَں پَرِشْکُرُتَ سَرْوَّتَح۔ اِتِیدَں پْرانْتَرے واکْیَں وَدَتَح کَسْیَچِدْرَوَح۔ کَتھامِماں یَسْمِنْ یِشَیِیو بھَوِشْیَدْوادِی لِکھِتَوانْ سوہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","یے پْریشِتاسْتے پھِرُوشِلوکاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","تَدا تےپرِچّھَنْ یَدِ نابھِشِکْتوسِ ایلِیوسِ نَ سَ بھَوِشْیَدْوادْیَپِ ناسِ چَ، تَرْہِ لوکانْ مَجَّیَسِ کُتَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","تَتو یوہَنْ پْرَتْیَووچَتْ، تویےہَں مَجَّیامِیتِ سَتْیَں کِنْتُ یَں یُویَں نَ جانِیتھَ تادرِشَ ایکو جَنو یُشْماکَں مَدھْیَ اُپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","سَ مَتْپَشْچادْ آگَتوپِ مَتْپُورْوَّں وَرْتَّمانَ آسِیتْ تَسْیَ پادُکابَنْدھَنَں موچَیِتُمَپِ ناہَں یوگْیوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","یَرْدَّنَنَدْیاح پارَسْتھَبَیتھَبارایاں یَسْمِنْسْتھانے یوہَنَمَجَّیَتْ تَسْمِنَ سْتھانے سَرْوَّمیتَدْ اَگھَٹَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","پَرےہَنِ یوہَنْ سْوَنِکَٹَماگَچّھَنْتَں یِشُں وِلوکْیَ پْراووچَتْ جَگَتَح پاپَموچَکَمْ اِیشْوَرَسْیَ میشَشاوَکَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","یو مَمَ پَشْچاداگَمِشْیَتِ سَ مَتّو گُرُتَرَح، یَتو ہیتورْمَتْپُورْوَّں سووَرْتَّتَ یَسْمِنَّہَں کَتھامِماں کَتھِتَوانْ سَ ایوایَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","اَپَرَں ناہَمینَں پْرَتْیَبھِجْناتَوانْ کِنْتُ اِسْراییلّوکا اینَں یَتھا پَرِچِنْوَنْتِ تَدَبھِپْراییناہَں جَلے مَجَّیِتُماگَچّھَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","پُنَشْچَ یوہَنَپَرَمیکَں پْرَمانَں دَتْوا کَتھِتَوانْ وِہایَسَح کَپوتَوَدْ اَوَتَرَنْتَماتْمانَمْ اَسْیوپَرْیَّوَتِشْٹھَنْتَں چَ درِشْٹَوانَہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ناہَمینَں پْرَتْیَبھِجْناتَوانْ اِتِ سَتْیَں کِنْتُ یو جَلے مَجَّیِتُں ماں پْرَیرَیَتْ سَ ایویماں کَتھامَکَتھَیَتْ یَسْیوپَرْیّاتْمانَمْ اَوَتَرَنْتَمْ اَوَتِشْٹھَنْتَنْچَ دْرَکْشَیَسِ سَایوَ پَوِتْرے آتْمَنِ مَجَّیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","اَوَسْتَنِّرِیکْشْیایَمْ اِیشْوَرَسْیَ تَنَیَ اِتِ پْرَمانَں دَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","پَرےہَنِ یوہَنْ دْوابھْیاں شِشْیابھْیاں سارْدّھیں تِشْٹھَنْ ");
INSERT INTO sanurd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","یِشُں گَچّھَنْتَں وِلوکْیَ گَدِتَوانْ، اِیشْوَرَسْیَ میشَشاوَکَں پَشْیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","اِماں کَتھاں شْرُتْوا دْوَو شِشْیَو یِیشوح پَشْچادْ اِییَتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","تَتو یِیشُح پَراورِتْیَ تَو پَشْچادْ آگَچّھَنْتَو درِشْٹْوا پرِشْٹَوانْ یُواں کِں گَویشَیَتھَح؟ تاوَپرِچّھَتاں ہے رَبِّ اَرْتھاتْ ہے گُرو بھَوانْ کُتْرَ تِشْٹھَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","تَتَح سووادِتْ ایتْیَ پَشْیَتَں۔ تَتو دِوَسَسْیَ ترِتِییَپْرَہَرَسْیَ گَتَتْواتْ تَو تَدِّنَں تَسْیَ سَنْگےسْتھاتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","یَو دْوَو یوہَنو واکْیَں شْرُتْوا یِشوح پَشْچادْ آگَمَتاں تَیوح شِمونْپِتَرَسْیَ بھْراتا آنْدْرِیَح ");
INSERT INTO sanurd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","سَ اِتْوا پْرَتھَمَں نِجَسودَرَں شِمونَں ساکْشاتْپْراپْیَ کَتھِتَوانْ وَیَں کھْرِیشْٹَمْ اَرْتھاتْ اَبھِشِکْتَپُرُشَں ساکْشاتْکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","پَشْچاتْ سَ تَں یِشوح سَمِیپَمْ آنَیَتْ۔ تَدا یِیشُسْتَں درِشْٹْواوَدَتْ تْوَں یُونَسَح پُتْرَح شِمونْ کِنْتُ تْوَنّامَدھییَں کَیپھاح وا پِتَرَح اَرْتھاتْ پْرَسْتَرو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","پَرےہَنِ یِیشَو گالِیلَں گَنْتُں نِشْچِتَچیتَسِ سَتِ پھِلِپَنامانَں جَنَں ساکْشاتْپْراپْیاووچَتْ مَمَ پَشْچادْ آگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","بَیتْسَیدانامْنِ یَسْمِنْ گْرامے پِتَرانْدْرِیَیورْواسَ آسِیتْ تَسْمِنْ گْرامے تَسْیَ پھِلِپَسْیَ وَسَتِراسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","پَشْچاتْ پھِلِپو نِتھَنیلَں ساکْشاتْپْراپْیاوَدَتْ مُوسا وْیَوَسْتھا گْرَنْتھے بھَوِشْیَدْوادِناں گْرَنْتھیشُ چَ یَسْیاکھْیانَں لِکھِتَماسْتے تَں یُوشَپھَح پُتْرَں ناسَرَتِییَں یِیشُں ساکْشادْ اَکارْشْمَ وَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","تَدا نِتھَنیلْ کَتھِتَوانْ ناسَرَنَّگَراتَ کِں کَشْچِدُتَّمَ اُتْپَنْتُں شَکْنوتِ؟ تَتَح پھِلِپو ووچَتْ ایتْیَ پَشْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","اَپَرَنْچَ یِیشُح سْوَسْیَ سَمِیپَں تَمْ آگَچّھَنْتَں درِشْٹْوا وْیاہرِتَوانْ، پَشْیایَں نِشْکَپَٹَح سَتْیَ اِسْراییلّوکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","تَتَح سووَدَدْ، بھَوانْ ماں کَتھَں پْرَتْیَبھِجاناتِ؟ یِیشُرَوادِیتْ پھِلِپَسْیَ آہْواناتْ پُورْوَّں یَدا تْوَمُڈُمْبَرَسْیَ تَرورْمُولےسْتھاسْتَدا تْوامَدَرْشَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","نِتھَنیلْ اَچَکَتھَتْ، ہے گُرو بھَوانْ نِتانْتَمْ اِیشْوَرَسْیَ پُتْروسِ، بھَوانْ اِسْراییلْوَںشَسْیَ راجا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","تَتو یِیشُ رْوْیاہَرَتْ، تْوامُڈُمْبَرَسْیَ پادَپَسْیَ مُولے درِشْٹَواناہَں مَمَیتَسْمادْواکْیاتْ کِں تْوَں وْیَشْوَسِیح؟ ایتَسْمادَپْیاشْچَرْیّانِ کارْیّانِ دْرَکْشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","اَنْیَچّاوادِیدْ یُشْمانَہَں یَتھارْتھَں وَدامِ، اِتَح پَرَں موچِتے میگھَدْوارے تَسْمانْمَنُجَسُونُنا اِیشْوَرَسْیَ دُوتَگَنَمْ اَوَروہَنْتَماروہَنْتَنْچَ دْرَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","اَنَنْتَرَں تْرُتِییَدِوَسے گالِیلْ پْرَدیشِیے کانّانامْنِ نَگَرے وِواہَ آسِیتْ تَتْرَ چَ یِیشورْماتا تِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","تَسْمَے وِواہایَ یِیشُسْتَسْیَ شِشْیاشْچَ نِمَنْتْرِتا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","تَدَنَنْتَرَں دْراکْشارَسَسْیَ نْیُونَتْوادْ یِیشورْماتا تَمَوَدَتْ ایتیشاں دْراکْشارَسو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","تَدا سَ تامَووچَتْ ہے نارِ مَیا سَہَ تَوَ کِں کارْیَّں؟ مَمَ سَمَیَ اِدانِیں نوپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","تَتَسْتَسْیَ ماتا داسانَووچَدْ اَیَں یَدْ وَدَتِ تَدیوَ کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","تَسْمِنْ سْتھانے یِہُودِییاناں شُچِتْوَکَرَنَوْیَوَہارانُساریناڈھَکَیکَجَلَدھَرانِ پاشانَمَیانِ شَڈْورِہَتْپاتْرانِآسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","تَدا یِیشُسْتانْ سَرْوَّکَلَشانْ جَلَیح پُورَیِتُں تاناجْناپَیَتْ، تَتَسْتے سَرْوّانْ کُمْبھاناکَرْنَں جَلَیح پَرْیَّپُورَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","اَتھَ تیبھْیَح کِنْچِدُتّارْیَّ بھوجْیادھِپاتیحسَمِیپَں نیتُں سَ تانادِشَتْ، تے تَدَنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","اَپَرَنْچَ تَجَّلَں کَتھَں دْراکْشارَسوبھَوَتْ تَجَّلَواہَکاداسا جْناتُں شَکْتاح کِنْتُ تَدْبھوجْیادھِپو جْناتُں ناشَکْنوتْ تَدَوَلِہْیَ وَرَں سَںمْبودْیاوَدَتَ، ");
INSERT INTO sanurd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","لوکاح پْرَتھَمَں اُتَّمَدْراکْشارَسَں دَدَتِ تَشُ یَتھیشْٹَں پِتَوَتْسُ تَسْما کِنْچِدَنُتَّمَنْچَ دَدَتِ کِنْتُ تْوَمِدانِیں یاوَتْ اُتَّمَدْراکْشارَسَں سْتھاپَیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","اِتّھَں یِیشُرْگالِیلَپْرَدیشے آشْچَرْیَّکارْمَّ پْرارَمْبھَ نِجَمَہِمانَں پْراکاشَیَتْ تَتَح شِشْیاسْتَسْمِنْ وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","تَتَح پَرَمْ سَ نِجَماتْرُبھْراتْرُسْشِشْیَیح سارْدّھں کَپھَرْناہُومَمْ آگَمَتْ کِنْتُ تَتْرَ بَہُودِنانِ آتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","تَدَنَنْتَرَں یِہُودِیاناں نِسْتاروتْسَوے نِکَٹَماگَتے یِیشُ رْیِرُوشالَمْ نَگَرَمْ آگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","تَتو مَنْدِرَسْیَ مَدھْیے گومیشَپاراوَتَوِکْرَیِنو وانِجَکْشْچوپَوِشْٹانْ وِلوکْیَ ");
INSERT INTO sanurd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","رَجُّبھِح کَشاں نِرْمّایَ سَرْوَّگومیشادِبھِح سارْدّھَں تانْ مَنْدِرادْ دُورِیکرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","وَنِجاں مُدْرادِ وِکِیرْیَّ آسَنانِ نْیُوبْجِیکرِتْیَ پاراوَتَوِکْرَیِبھْیوکَتھَیَدْ اَسْماتْ سْتھاناتْ سَرْوانْییتانِ نَیَتَ، مَمَ پِتُگرِہَں وانِجْیَگرِہَں ما کارْشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","تَسْماتْ تَنْمَنْدِرارْتھَ اُدْیوگو یَسْتُ سَ گْرَسَتِیوَ مامْ۔ اِماں شاسْتْرِییَلِپِں شِشْیاحسَمَسْمَرَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","تَتَح پَرَمْ یِہُودِییَلوکا یِیشِمَوَدَنْ تَوَمِدرِشَکَرْمَّکَرَناتْ کِں چِہْنَمَسْمانْ دَرْشَیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","تَتو یِیشُسْتانَووچَدْ یُشْمابھِرے تَسْمِنْ مَنْدِرے ناشِتے دِنَتْرَیَمَدھْیےہَں تَدْ اُتّھاپَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","تَدا یِہُودِیا وْیاہارْشُح، ایتَسْیَ مَنْدِرَسَ نِرْمّانینَ شَٹْچَتْوارِںشَدْ وَتْسَرا گَتاح، تْوَں کِں دِنَتْرَیَمَدھْیے تَدْ اُتّھاپَیِشْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","کِنْتُ سَ نِجَدیہَرُوپَمَنْدِرے کَتھامِماں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","سَ یَدیتادرِشَں گَدِتَوانْ تَچّھِشْیاح شْمَشاناتْ تَدِییوتّھانے سَتِ سْمرِتْوا دھَرْمَّگْرَنْتھے یِیشُنوکْتَکَتھایاں چَ وْیَشْوَسِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","اَنَنْتَرَں نِسْتاروتْسَوَسْیَ بھوجْیَسَمَیے یِرُوشالَمْ نَگَرے تَتْکْرُتاشْچَرْیَّکَرْمّانِ وِلوکْیَ بَہُبھِسْتَسْیَ نامَنِ وِشْوَسِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","کِنْتُ سَ تیشاں کَریشُ سْوَں نَ سَمَرْپَیَتْ، یَتَح سَ سَرْوّانَوَیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","سَ مانَویشُ کَسْیَچِتْ پْرَمانَں ناپیکْشَتَ یَتو مَنُجاناں مَدھْیے یَدْیَدَسْتِ تَتَّتْ سوجاناتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","نِکَدِمَناما یِہُودِییانامْ اَدھِپَتِح پھِرُوشِی کْشَنَدایاں ");
INSERT INTO sanurd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","یِیشَورَبھْیَرْنَمْ آوْرَجْیَ وْیاہارْشِیتْ، ہے گُرو بھَوانْ اِیشْوَرادْ آگَتْ ایکَ اُپَدیشْٹا، ایتَدْ اَسْمابھِرْجْنایَتے؛ یَتو بھَوَتا یانْیاشْچَرْیَّکَرْمّانِ کْرِیَنْتے پَرَمیشْوَرَسْیَ ساہایَّں وِنا کیناپِ تَتَّتْکَرْمّانِ کَرْتُّں نَ شَکْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","تَدا یِیشُرُتَّرَں دَتَّوانْ تَواہَں یَتھارْتھَتَرَں وْیاہَرامِ پُنَرْجَنْمَنِ نَ سَتِ کوپِ مانَوَ اِیشْوَرَسْیَ راجْیَں دْرَشْٹُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","تَتو نِکَدِیمَح پْرَتْیَووچَتْ مَنُجو ورِدّھو بھُوتْوا کَتھَں جَنِشْیَتے؟ سَ کِں پُنَ رْماترِرْجَٹھَرَں پْرَوِشْیَ جَنِتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","یِیشُرَوادِیدْ یَتھارْتھَتَرَمْ اَہَں کَتھَیامِ مَنُجے تویاتْمَبھْیاں پُنَ رْنَ جاتے سَ اِیشْوَرَسْیَ راجْیَں پْرَویشْٹُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ماںسادْ یَتْ جایَتے تَنْ ماںسَمیوَ تَتھاتْمَنو یو جایَتے سَ آتْمَیوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","یُشْمابھِح پُنَ رْجَنِتَوْیَں مَمَیتَسْیاں کَتھایامْ آشْچَرْیَں ما مَںسْتھاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","سَداگَتِرْیاں دِشَمِچّھَتِ تَسْیامیوَ دِشِ واتِ، تْوَں تَسْیَ سْوَنَں شُنوشِ کِنْتُ سَ کُتَ آیاتِ کُتْرَ یاتِ وا کِمَپِ نَ جاناسِ تَدْوادْ آتْمَنَح سَکاشاتْ سَرْوّیشاں مَنُجاناں جَنْمَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","تَدا نِکَدِیمَح پرِشْٹَوانْ ایتَتْ کَتھَں بھَوِتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","یِیشُح پْرَتْیَکْتَوانْ تْوَمِسْراییلو گُرُرْبھُوتْواپِ کِمیتاں کَتھاں نَ ویتْسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","تُبھْیَں یَتھارْتھَں کَتھَیامِ، وَیَں یَدْ وِدْمَسْتَدْ وَچْمَح یَںچَّ پَشْیامَسْتَسْیَیوَ ساکْشْیَں دَدْمَح کِنْتُ یُشْمابھِرَسْماکَں ساکْشِتْوَں نَ گرِہْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ایتَسْیَ سَںسارَسْیَ کَتھایاں کَتھِتایاں یَدِ یُویَں نَ وِشْوَسِتھَ تَرْہِ سْوَرْگِییایاں کَتھایاں کَتھَں وِشْوَسِشْیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","یَح سْوَرْگےسْتِ یَں چَ سْوَرْگادْ اَواروہَتْ تَں مانَوَتَنَیَں وِنا کوپِ سْوَرْگَں ناروہَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","اَپَرَنْچَ مُوسا یَتھا پْرانْتَرے سَرْپَں پْروتّھاپِتَوانْ مَنُشْیَپُتْروپِ تَتھَیووتّھاپِتَوْیَح؛ ");
INSERT INTO sanurd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","تَسْمادْ یَح کَشْچِتْ تَسْمِنْ وِشْوَسِشْیَتِ سووِناشْیَح سَنْ اَنَنْتایُح پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","اِیشْوَرَ اِتّھَں جَگَدَدَیَتَ یَتْ سْوَمَدْوِتِییَں تَنَیَں پْرادَداتْ تَتو یَح کَشْچِتْ تَسْمِنْ وِشْوَسِشْیَتِ سووِناشْیَح سَنْ اَنَنْتایُح پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","اِیشْوَرو جَگَتو لوکانْ دَنْڈَیِتُں سْوَپُتْرَں نَ پْریشْیَ تانْ پَرِتْراتُں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","اَتَایوَ یَح کَشْچِتْ تَسْمِنْ وِشْوَسِتِ سَ دَنْڈارْہو نَ بھَوَتِ کِنْتُ یَح کَشْچِتْ تَسْمِنْ نَ وِشْوَسِتِ سَ اِدانِیمیوَ دَنْڈارْہو بھَوَتِ،یَتَح سَ اِیشْوَرَسْیادْوِتِییَپُتْرَسْیَ نامَنِ پْرَتْیَیَں نَ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","جَگَتو مَدھْیے جْیوتِح پْراکاشَتَ کِنْتُ مَنُشْیاناں کَرْمَّناں درِشْٹَتْواتْ تے جْیوتِشوپِ تِمِرے پْرِییَنْتے ایتَدیوَ دَنْڈَسْیَ کارَناں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","یَح کُکَرْمَّ کَروتِ تَسْیاچارَسْیَ درِشْٹَتْواتْ سَ جْیوتِررِیتِییِتْوا تَنِّکَٹَں نایاتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","کِنْتُ یَح سَتْکَرْمَّ کَروتِ تَسْیَ سَرْوّانِ کَرْمّانِیشْوَرینَ کرِتانِیتِ سَتھا پْرَکاشَتے تَدَبھِپْرایینَ سَ جْیوتِشَح سَنِّدھِمْ آیاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","تَتَح پَرَمْ یِیشُح شِشْیَیح سارْدّھَں یِہُودِییَدیشَں گَتْوا تَتْرَ سْتھِتْوا مَجَّیِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","تَدا شالَمْ نَگَرَسْیَ سَمِیپَسْتھایِنِ اَینَنْ گْرامے بَہُتَرَتویَسْتھِتیسْتَتْرَ یوہَنْ اَمَجَّیَتْ تَتھا چَ لوکا آگَتْیَ تینَ مَجِّتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","تَدا یوہَنْ کارایاں نَ بَدّھَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","اَپَرَنْچَ شاچَکَرْمَّنِ یوہانَح شِشْیَیح سَہَ یِہُودِییَلوکاناں وِوادے جاتے، تے یوہَنَح سَںنِّدھِں گَتْواکَتھَیَنْ، ");
INSERT INTO sanurd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ہے گُرو یَرْدَّنَنَدْیاح پارے بھَوَتا سارْدّھَں یَ آسِیتْ یَسْمِںشْچَ بھَوانْ ساکْشْیَں پْرَدَداتْ پَشْیَتُ سوپِ مَجَّیَتِ سَرْوّے تَسْیَ سَمِیپَں یانْتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","تَدا یوہَنْ پْرَتْیَووچَدْ اِیشْوَرینَ نَ دَتّے کوپِ مَنُجَح کِمَپِ پْراپْتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","اَہَں اَبھِشِکْتو نَ بھَوامِ کِنْتُ تَدَگْرے پْریشِتوسْمِ یامِماں کَتھاں کَتھِتَواناہَں تَتْرَ یُویَں سَرْوّے ساکْشِنَح سْتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","یو جَنَح کَنْیاں لَبھَتے سَ ایوَ وَرَح کِنْتُ وَرَسْیَ سَنِّدھَو دَنْڈایَمانَں تَسْیَ یَنْمِتْرَں تینَ وَرَسْیَ شَبْدے شْرُتےتِیواہْلادْیَتے مَماپِ تَدْوَدْ آنَنْدَسِدّھِرْجاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","تینَ کْرَمَشو وَرْدّھِتَوْیَں کِنْتُ مَیا ہْسِتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","یَ اُورْدھْواداگَچّھَتْ سَ سَرْوّیشاں مُکھْیو یَشْچَ سَںسارادْ اُدَپَدْیَتَ سَ ساںسارِکَح سَںسارِییاں کَتھانْچَ کَتھَیَتِ یَسْتُ سْوَرْگاداگَچّھَتْ سَ سَرْوّیشاں مُکھْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","سَ یَدَپَشْیَدَشرِنوچَّ تَسْمِنّیوَ ساکْشْیَں دَداتِ تَتھاپِ پْرایَشَح کَشْچِتْ تَسْیَ ساکْشْیَں نَ گرِہْلاتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","کِنْتُ یو گرِہْلاتِ سَ اِیشْوَرَسْیَ سَتْیَوادِتْوَں مُدْرانْگِتَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","اِیشْوَرینَ یَح پْریرِتَح سَایوَ اِیشْوَرِییَکَتھاں کَتھَیَتِ یَتَ اِیشْوَرَ آتْمانَں تَسْمَے اَپَرِمِتَمْ اَدَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","پِتا پُتْرے سْنیہَں کرِتْوا تَسْیَ ہَسْتے سَرْوّانِ سَمَرْپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","یَح کَشْچِتْ پُتْرے وِشْوَسِتِ سَ ایوانَنْتَمْ پَرَمایُح پْراپْنوتِ کِنْتُ یَح کَشْچِتْ پُتْرے نَ وِشْوَسِتِ سَ پَرَمایُشو دَرْشَنَں نَ پْراپْنوتِ کِنْتْوِیشْوَرَسْیَ کوپَبھاجَنَں بھُوتْوا تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","یِیشُح سْوَیَں نامَجَّیَتْ کیوَلَں تَسْیَ شِشْیا اَمَجَّیَتْ کِنْتُ یوہَنودھِکَشِشْیانْ سَ کَروتِ مَجَّیَتِ چَ، ");
INSERT INTO sanurd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","پھِرُوشِنَ اِماں وارْتّامَشرِنْوَنْ اِتِ پْرَبھُرَوَگَتْیَ ");
INSERT INTO sanurd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","یِہُودِییَدیشَں وِہایَ پُنَ رْگالِیلَمْ آگَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","تَتَح شومِرونَپْرَدیشَسْیَ مَدْیینَ تینَ گَنْتَوْیے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","یاکُوبْ نِجَپُتْرایَ یُوشَپھے یاں بھُومِمْ اَدَداتْ تَتْسَمِیپَسْتھایِ شومِرونَپْرَدیشَسْیَ سُکھارْ نامْنا وِکھْیاتَسْیَ نَگَرَسْیَ سَنِّدھاوُپاسْتھاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","تَتْرَ یاکُوبَح پْرَہِراسِیتْ؛ تَدا دْوِتِییَیامَویلایاں جاتایاں سَ مارْگے شْرَماپَنَّسْتَسْیَ پْرَہیح پارْشْوے اُپاوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ایتَرْہِ کاچِتْ شومِرونِییا یوشِتْ تویوتّولَنارْتھَمْ تَتْراگَمَتْ ");
INSERT INTO sanurd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","تَدا شِشْیاح کھادْیَدْرَوْیانِ کْریتُں نَگَرَمْ اَگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","یِیشُح شومِرونِییاں تاں یوشِتَمْ وْیاہارْشِیتْ مَہْیَں کِنْچِتْ پانِییَں پاتُں دیہِ۔ کِنْتُ شومِرونِییَیح ساکَں یِہُودِییَلوکا نَ وْیَواہَرَنْ تَسْمادّھیتوح ساکَتھَیَتْ شومِرونِییا یوشِتَدَہَں تْوَں یِہُودِییوسِ کَتھَں مَتَّح پانِییَں پاتُمْ اِچّھَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","تَتو یِیشُرَوَدَدْ اِیشْوَرَسْیَ یَدّانَں تَتْکِیدرِکْ پانِییَں پاتُں مَہْیَں دیہِ یَ اِتّھَں تْواں یاچَتے سَ وا کَ اِتِ چیدَجْناسْیَتھاسْتَرْہِ تَمَیاچِشْیَتھاح سَ چَ تُبھْیَمَمرِتَں تویَمَداسْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","تَدا سا سِیمَنْتِنِی بھاشِتَوَتِ، ہے مَہیچّھَ پْرَہِرْگَمْبھِیرو بھَوَتو نِیروتّولَنَپاتْرَں ناسْتِی چَ تَسْماتْ تَدَمرِتَں کِیلالَں کُتَح پْراپْسْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","یوسْمَبھْیَمْ اِمَمَنْدھُوں دَدَو، یَسْیَ چَ پَرِجَنا گومیشادَیَشْچَ سَرْوّےسْیَ پْرَہیح پانِییَں پَپُریتادرِشو یوسْماکَں پُورْوَّپُرُشو یاکُوبْ تَسْمادَپِ بھَوانْ مَہانْ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","تَتو یِیشُرَکَتھَیَدْ اِدَں پانِییَں سَح پِوَتِ سَ پُنَسْترِشارْتّو بھَوِشْیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","کِنْتُ مَیا دَتَّں پانِییَں یَح پِوَتِ سَ پُنَح کَداپِ ترِشارْتّو نَ بھَوِشْیَتِ۔ مَیا دَتَّمْ اِدَں تویَں تَسْیانْتَح پْرَسْرَوَنَرُوپَں بھُوتْوا اَنَنْتایُرْیاوَتْ سْروشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","تَدا سا وَنِتاکَتھَیَتْ ہے مَہیچّھَ تَرْہِ مَمَ پُنَح پِیپاسا یَتھا نَ جایَتے تویوتّولَنایَ یَتھاتْراگَمَنَں نَ بھَوَتِ چَ تَدَرْتھَں مَہْیَں تَتّویَں دیہِی۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","تَتو یِیشُورَوَدَدْیاہِ تَوَ پَتِماہُویَ سْتھانےتْراگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","سا واماوَدَتْ مَمَ پَتِرْناسْتِ۔ یِیشُرَوَدَتْ مَمَ پَتِرْناسْتِیتِ واکْیَں بھَدْرَمَووچَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","یَتَسْتَوَ پَنْچَ پَتَیوبھَوَنْ اَدھُنا تُ تْوَیا سارْدّھَں یَسْتِشْٹھَتِ سَ تَوَ بھَرْتّا نَ واکْیَمِدَں سَتْیَمَوادِح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","تَدا سا مَہِلا گَدِتَوَتِ ہے مَہیچّھَ بھَوانْ ایکو بھَوِشْیَدْوادِیتِ بُدّھَں مَیا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","اَسْماکَں پِترِلوکا ایتَسْمِنْ شِلوچَّیےبھَجَنْتَ، کِنْتُ بھَوَدْبھِرُچْیَتے یِرُوشالَمْ نَگَرے بھَجَنَیوگْیَں سْتھانَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","یِیشُرَووچَتْ ہے یوشِتْ مَمَ واکْیے وِشْوَسِہِ یَدا یُویَں کیوَلَشَیلےسْمِنْ وا یِرُوشالَمْ نَگَرے پِتُرْبھَجَنَں نَ کَرِشْیَدھْوے کالَ ایتادرِشَ آیاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","یُویَں یَں بھَجَدھْوے تَں نَ جانِیتھَ، کِنْتُ وَیَں یَں بھَجامَہے تَں جانِیمَہے، یَتو یِہُودِییَلوکاناں مَدھْیاتْ پَرِتْرانَں جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","کِنْتُ یَدا سَتْیَبھَکْتا آتْمَنا سَتْیَرُوپینَ چَ پِتُرْبھَجَنَں کَرِشْیَنْتے سَمَیَ ایتادرِشَ آیاتِ، وَرَمْ اِدانِیمَپِ وِدْیَتے ؛ یَتَ ایتادرِشو بھَتْکانْ پِتا چیشْٹَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","اِیشْوَرَ آتْما؛ تَتَسْتَسْیَ یے بھَکْتاسْتَیح سَ آتْمَنا سَتْیَرُوپینَ چَ بھَجَنِییَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","تَدا سا مَہِلاوادِیتْ کھْرِیشْٹَنامْنا وِکھْیاتوبھِشِکْتَح پُرُشَ آگَمِشْیَتِیتِ جانامِ سَ چَ سَرْوّاح کَتھا اَسْمانْ جْناپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","تَتو یِیشُرَوَدَتْ تْوَیا سارْدّھَں کَتھَنَں کَرومِ یوہَمْ اَہَمیوَ سَ پُرُشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ایتَسْمِنْ سَمَیے شِشْیا آگَتْیَ تَتھا سْتْرِیا سارْدّھَں تَسْیَ کَتھوپَکَتھَنے مَہاشْچَرْیَّمْ اَمَنْیَنْتَ تَتھاپِ بھَوانْ کِمِچّھَتِ؟ یَدْوا کِمَرْتھَمْ ایتَیا سارْدّھَں کَتھاں کَتھَیَتِ؟ اِتِ کوپِ ناپرِچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","تَتَح پَرَں سا نارِی کَلَشَں سْتھاپَیِتْوا نَگَرَمَدھْیَں گَتْوا لوکیبھْیوکَتھایَدْ ");
INSERT INTO sanurd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","اَہَں یَدْیَتْ کَرْمّاکَرَوَں تَتْسَرْوَّں مَہْیَمَکَتھَیَدْ ایتادرِشَں مانَوَمیکَمْ آگَتْیَ پَشْیَتَ رُ کِمْ اَبھِشِکْتو نَ بھَوَتِ ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","تَتَسْتے نَگَرادْ بَہِراگَتْیَ تاتَسْیَ سَمِیپَمْ آیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ایتَرْہِ شِشْیاح سادھَیِتْوا تَں وْیاہارْشُح ہے گُرو بھَوانْ کِنْچِدْ بھُوکْتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","تَتَح سووَدَدْ یُشْمابھِرْیَنَّ جْنایَتے تادرِشَں بھَکْشْیَں مَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","تَدا شِشْیاح پَرَسْپَرَں پْرَشْٹُمْ آرَمْبھَنْتَ، کِمَسْمَے کوپِ کِمَپِ بھَکْشْیَمانِییَ دَتَّوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","یِیشُرَووچَتْ مَتْپْریرَکَسْیابھِمَتانُرُوپَکَرَنَں تَسْیَیوَ کَرْمَّسِدّھِکارَنَنْچَ مَمَ بھَکْشْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ماسَچَتُشْٹَیے جاتے شَسْیَکَرْتَّنَسَمَیو بھَوِشْیَتِیتِ واکْیَں یُشْمابھِح کِں نودْیَتے؟ کِنْتْوَہَں وَدامِ، شِرَ اُتّولْیَ کْشیتْرانِ پْرَتِ نِرِیکْشْیَ پَشْیَتَ، اِدانِیں کَرْتَّنَیوگْیانِ شُکْلَوَرْنانْیَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","یَشْچھِنَتِّ سَ ویتَنَں لَبھَتے اَنَنْتایُحسْوَرُوپَں شَسْیَں سَ گرِہْلاتِ چَ، تینَیوَ وَپْتا چھیتّا چَ یُگَپَدْ آنَنْدَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","اِتّھَں سَتِ وَپَتْییکَشْچھِنَتْیَنْیَ اِتِ وَچَنَں سِدّھیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","یَتْرَ یُویَں نَ پَرْیَّشْرامْیَتَ تادرِشَں شَسْیَں چھیتُّں یُشْمانْ پْرَیرَیَمْ اَنْیے جَناحپَرْیَّشْرامْیَنْ یُویَں تیشاں شْرَگَسْیَ پھَلَمْ اَلَبھَدھْوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","یَسْمِنْ کالے یَدْیَتْ کَرْمّاکارْشَں تَتْسَرْوَّں سَ مَہْیَمْ اَکَتھَیَتْ تَسْیا وَنِتایا اِدَں ساکْشْیَواکْیَں شْرُتْوا تَنَّگَرَنِواسِنو بَہَوَح شومِرونِییَلوکا وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","تَتھا چَ تَسْیانْتِکے سَمُپَسْتھایَ سْویشاں سَنِّدھَو کَتِچِدْ دِنانِ سْتھاتُں تَسْمِنْ وِنَیَمْ اَکُرْوّانَ تَسْماتْ سَ دِنَدْوَیَں تَتْسْتھانے نْیَوَشْٹَتْ ");
INSERT INTO sanurd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","تَتَسْتَسْیوپَدیشینَ بَہَووپَرے وِشْوَسْیَ ");
INSERT INTO sanurd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","تاں یوشامَوَدَنْ کیوَلَں تَوَ واکْیینَ پْرَتِیمَ اِتِ نَ، کِنْتُ سَ جَگَتوبھِشِکْتَسْتْراتیتِ تَسْیَ کَتھاں شْرُتْوا وَیَں سْوَیَمیواجْناسَمَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","سْوَدیشے بھَوِشْیَدْوَکْتُح سَتْکارو ناسْتِیتِ یَدْیَپِ یِیشُح پْرَمانَں دَتْواکَتھَیَتْ ");
INSERT INTO sanurd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","تَتھاپِ دِوَسَدْوَیاتْ پَرَں سَ تَسْماتْ سْتھانادْ گالِیلَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","اَنَنْتَرَں یے گالِیلِی لِیَلوکا اُتْسَوے گَتا اُتْسَوَسَمَیے یِرُوشَلَمْ نَگَرے تَسْیَ سَرْوّاح کْرِیا اَپَشْیَنْ تے گالِیلَمْ آگَتَں تَمْ آگرِہْلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","تَتَح پَرَمْ یِیشُ رْیَسْمِنْ کانّانَگَرے جَلَں دْراکْشارَسَمْ آکَروتْ تَتْ سْتھانَں پُنَرَگاتْ۔ تَسْمِنّیوَ سَمَیے کَسْیَچِدْ راجَسَبھاسْتارَسْیَ پُتْرَح کَپھَرْناہُومَپُرِی روگَگْرَسْتَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","سَ ییہُودِییَدیشادْ یِیشو رْگالِیلاگَمَنَوارْتّاں نِشَمْیَ تَسْیَ سَمِیپَں گَتْوا پْرارْتھْیَ وْیاہرِتَوانْ مَمَ پُتْرَسْیَ پْرایینَ کالَ آسَنَّح بھَوانْ آگَتْیَ تَں سْوَسْتھَں کَروتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","تَدا یِیشُرَکَتھَیَدْ آشْچَرْیَّں کَرْمَّ چِتْرَں چِہْنَں چَ نَ درِشْٹا یُویَں نَ پْرَتْییشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","تَتَح سَ سَبھاسَدَوَدَتْ ہے مَہیچّھَ مَمَ پُتْرے نَ مرِتے بھَواناگَچّھَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","یِیشُسْتَمَوَدَدْ گَچّھَ تَوَ پُتْروجِیوِیتْ تَدا یِیشُنوکْتَواکْیے سَ وِشْوَسْیَ گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","گَمَنَکالے مارْگَمَدھْیے داساسْتَں ساکْشاتْپْراپْیاوَدَنْ بھَوَتَح پُتْروجِیوِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","تَتَح کَں کالَمارَبھْیَ روگَپْرَتِیکارارَمْبھو جاتا اِتِ پرِشْٹے تَیرُکْتَں ہْیَح سارْدّھَدَنْڈَدْوَیادھِکَدْوِتِییَیامے تَسْیَ جْوَرَتْیاگوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","تَدا یِیشُسْتَسْمِنْ کْشَنے پْروکْتَوانْ تَوَ پُتْروجِیوِیتْ پِتا تَدْبُدّھوا سَپَرِوارو وْیَشْوَسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","یِہُودِییَدیشادْ آگَتْیَ گالِیلِ یِیشُریتَدْ دْوِتِییَمْ آشْچَرْیَّکَرْمّاکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","تَتَح پَرَں یِہُودِییانامْ اُتْسَوَ اُپَسْتھِتے یِیشُ رْیِرُوشالَمَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","تَسْمِنَّگَرے میشَنامْنو دْوارَسْیَ سَمِیپے اِبْرِییَبھاشَیا بَیتھیسْدا نامْنا پِشْکَرِنِی پَنْچَگھَٹَّیُکْتاسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","تَسْیاسْتیشُ گھَٹّیشُ کِلالَکَمْپَنَمْ اَپیکْشْیَ اَنْدھَکھَنْچَشُشْکانْگادَیو بَہَوو روگِنَح پَتَنْتَسْتِشْٹھَنْتِ سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","یَتو وِشیشَکالے تَسْیَ سَرَسو وارِ سْوَرْگِییَدُوتَ ایتْیاکَمْپَیَتْ تَتْکِیلالَکَمْپَناتْ پَرَں یَح کَشْچِدْ روگِی پْرَتھَمَں پانِییَمَواروہَتْ سَ ایوَ تَتْکْشَنادْ روگَمُکْتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","تَداشْٹاتْرِںشَدْوَرْشانِ یاوَدْ روگَگْرَسْتَ ایکَجَنَسْتَسْمِنْ سْتھانے سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","یِیشُسْتَں شَیِتَں درِشْٹْوا بَہُکالِکَروگِیتِ جْناتْوا وْیاہرِتَوانْ تْوَں کِں سْوَسْتھو بُبھُوشَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","تَتو روگِی کَتھِتَوانْ ہے مَہیچّھَ یَدا کِیلالَں کَمْپَتے تَدا ماں پُشْکَرِنِیمْ اَوَروہَیِتُں مَمَ کوپِ ناسْتِ، تَسْمانْ مَمَ گَمَنَکالے کَشْچِدَنْیوگْرو گَتْوا اَوَروہَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","تَدا یِیشُرَکَتھَیَدْ اُتِّشْٹھَ، تَوَ شَیّامُتّولْیَ گرِہِیتْوا یاہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","سَ تَتْکْشَناتْ سْوَسْتھو بھُوتْوا شَیّامُتّولْیادایَ گَتَوانْ کِنْتُ تَدِّنَں وِشْرامَوارَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","تَسْمادْ یِہُودِییاح سْوَسْتھَں نَرَں وْیاہَرَنْ اَدْیَ وِشْرامَوارے شَیَنِییَمادایَ نَ یاتَوْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","تَتَح سَ پْرَتْیَووچَدْ یو ماں سْوَسْتھَمْ اَکارْشِیتْ شَیَنِییَمْ اُتّولْیادایَ یاتُں ماں سَ ایوادِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","تَدا تےپرِچّھَنْ شَیَنِییَمْ اُتّولْیادایَ یاتُں یَ آجْناپَیَتْ سَ کَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","کِنْتُ سَ کَ اِتِ سْوَسْتھِیبھُوتو ناجانادْ یَتَسْتَسْمِنْ سْتھانے جَنَتاسَتّوادْ یِیشُح سْتھانانْتَرَمْ آگَمَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","تَتَح پَرَں ییشُ رْمَنْدِرے تَں نَرَں ساکْشاتْپْراپْیاکَتھَیَتْ پَشْییدانِیمْ اَنامَیو جاتوسِ یَتھادھِکا دُرْدَشا نَ گھَٹَتے تَدّھیتوح پاپَں کَرْمَّ پُنَرْماکارْشِیح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","تَتَح سَ گَتْوا یِہُودِییانْ اَوَدَدْ یِیشُ رْمامْ اَروگِنَمْ اَکارْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","تَتو یِیشُ رْوِشْرامَوارے کَرْمّیدرِشَں کرِتَوانْ اِتِ ہیتو رْیِہُودِییاسْتَں تاڈَیِتْوا ہَنْتُمْ اَچیشْٹَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","یِیشُسْتاناکھْیَتْ مَمَ پِتا یَتْ کارْیَّں کَروتِ تَدَنُرُوپَمْ اَہَمَپِ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","تَتو یِہُودِییاسْتَں ہَنْتُں پُنَرَیَتَنْتَ یَتو وِشْرامَوارَں نامَنْیَتَ تَدیوَ کیوَلَں نَ اَدھِکَنْتُ اِیشْوَرَں سْوَپِتَرَں پْروچْیَ سْوَمَپِیشْوَرَتُلْیَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","پَشْچادْ یِیشُرَوَدَدْ یُشْمانَہَں یَتھارْتھَتَرَں وَدامِ پُتْرَح پِتَرَں یَدْیَتْ کَرْمَّ کُرْوَّنْتَں پَشْیَتِ تَدَتِرِکْتَں سْویچّھاتَح کِمَپِ کَرْمَّ کَرْتُّں نَ شَکْنوتِ۔ پِتا یَتْ کَروتِ پُتْروپِ تَدیوَ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","پِتا پُتْرے سْنیہَں کَروتِ تَسْماتْ سْوَیَں یَدْیَتْ کَرْمَّ کَروتِ تَتْسَرْوَّں پُتْرَں دَرْشَیَتِ ؛ یَتھا چَ یُشْماکَں آشْچَرْیَّجْنانَں جَنِشْیَتے تَدَرْتھَمْ اِتوپِ مَہاکَرْمَّ تَں دَرْشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","وَسْتُتَسْتُ پِتا یَتھا پْرَمِتانْ اُتّھاپْیَ سَجِوانْ کَروتِ تَدْوَتْ پُتْروپِ یَں یَں اِچّھَتِ تَں تَں سَجِیوَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","سَرْوّے پِتَرَں یَتھا سَتْکُرْوَّنْتِ تَتھا پُتْرَمَپِ سَتْکارَیِتُں پِتا سْوَیَں کَسْیاپِ وِچارَمَکرِتْوا سَرْوَّوِچاراناں بھارَں پُتْرے سَمَرْپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","یَح پُتْرَں سَتْ کَروتِ سَ تَسْیَ پْریرَکَمَپِ سَتْ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","یُشْماناہَں یَتھارْتھَتَرَں وَدامِ یو جَنو مَمَ واکْیَں شْرُتْوا مَتْپْریرَکے وِشْوَسِتِ سونَنْتایُح پْراپْنوتِ کَداپِ دَنْڈَباجَنَں نَ بھَوَتِ نِدھَنادُتّھایَ پَرَمایُح پْراپْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ یَدا مرِتا اِیشْوَرَپُتْرَسْیَ نِنادَں شْروشْیَنْتِ یے چَ شْروشْیَنْتِ تے سَجِیوا بھَوِشْیَنْتِ سَمَیَ ایتادرِشَ آیاتِ وَرَمْ اِدانِیمَپْیُپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","پِتا یَتھا سْوَیَنْجِیوِی تَتھا پُتْرایَ سْوَیَنْجِیوِتْوادھِکارَں دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","سَ مَنُشْیَپُتْرَح ایتَسْماتْ کارَناتْ پِتا دَنْڈَکَرَنادھِکارَمَپِ تَسْمِنْ سَمَرْپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ایتَدَرْتھے یُویَمْ آشْچَرْیَّں نَ مَنْیَدھْوَں یَتو یَسْمِنْ سَمَیے تَسْیَ نِنادَں شْرُتْوا شْمَشانَسْتھاح سَرْوّے بَہِراگَمِشْیَنْتِ سَمَیَ ایتادرِشَ اُپَسْتھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","تَسْمادْ یے سَتْکَرْمّانِ کرِتَوَنْتَسْتَ اُتّھایَ آیُح پْراپْسْیَنْتِ یے چَ کُکَرْمانِ کرِتَوَنْتَسْتَ اُتّھایَ دَنْڈَں پْراپْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","اَہَں سْوَیَں کِمَپِ کَرْتُّں نَ شَکْنومِ یَتھا شُنومِ تَتھا وِچارَیامِ مَمَ وِچارَنْچَ نْیایَّح یَتوہَں سْوِییابھِیشْٹَں نیہِتْوا مَتْپْریرَیِتُح پِتُرِشْٹَمْ اِیہے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","یَدِ سْوَسْمِنْ سْوَیَں ساکْشْیَں دَدامِ تَرْہِ تَتْساکْشْیَمْ آگْراہْیَں بھَوَتِ ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","کِنْتُ مَدَرْتھےپَرو جَنَح ساکْشْیَں دَداتِ مَدَرْتھے تَسْیَ یَتْ ساکْشْیَں تَتْ سَتْیَمْ ایتَدَپْیَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","یُشْمابھِ رْیوہَنَں پْرَتِ لوکیشُ پْریرِتیشُ سَ سَتْیَکَتھایاں ساکْشْیَمَدَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","مانُشادَہَں ساکْشْیَں نوپیکْشے تَتھاپِ یُویَں یَتھا پَرِتْرَیَدھْوے تَدَرْتھَمْ اِدَں واکْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","یوہَنْ دیدِیپْیَمانو دِیپَ اِوَ تیجَسْوِی سْتھِتَوانْ یُویَمْ اَلْپَکالَں تَسْیَ دِیپْتْیانَنْدِتُں سَمَمَنْیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","کِنْتُ تَتْپْرَمانادَپِ مَمَ گُرُتَرَں پْرَمانَں وِدْیَتے پِتا ماں پْریشْیَ یَدْیَتْ کَرْمَّ سَماپَیِتُں شَکْتِّمَدَداتْ مَیا کرِتَں تَتَّتْ کَرْمَّ مَدَرْتھے پْرَمانَں دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","یَح پِتا ماں پْریرِتَوانْ موپِ مَدَرْتھے پْرَمانَں دَداتِ۔ تَسْیَ واکْیَں یُشْمابھِح کَداپِ نَ شْرُتَں تَسْیَ رُوپَنْچَ نَ درِشْٹَں ");
INSERT INTO sanurd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","تَسْیَ واکْیَنْچَ یُشْماکَمْ اَنْتَح کَداپِ سْتھانَں ناپْنوتِ یَتَح سَ یَں پْریشِتَوانْ یُویَں تَسْمِنْ نَ وِشْوَسِتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","دھَرْمَّپُسْتَکانِ یُویَمْ آلوچَیَدھْوَں تَے رْواکْیَیرَنَنْتایُح پْراپْسْیامَ اِتِ یُویَں بُدھْیَدھْوے تَدّھَرْمَّپُسْتَکانِ مَدَرْتھے پْرَمانَں دَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","تَتھاپِ یُویَں پَرَمایُحپْراپْتَیے مَمَ سَںنِدھِمْ نَ جِگَمِشَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","اَہَں مانُشیبھْیَح سَتْکارَں نَ گرِہْلامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","اَہَں یُشْمانْ جانامِ؛ یُشْماکَمَنْتَرَ اِیشْوَرَپْریمَ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","اَہَں نِجَپِتُ رْنامْناگَتوسْمِ تَتھاپِ ماں نَ گرِہْلِیتھَ کِنْتُ کَشْچِدْ یَدِ سْوَنامْنا سَماگَمِشْیَتِ تَرْہِ تَں گْرَہِیشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","یُویَمْ اِیشْوَراتْ سَتْکارَں نَ چِشْٹَتْوا کیوَلَں پَرَسْپَرَں سَتْکارَمْ چیدْ آدَدھْوّے تَرْہِ کَتھَں وِشْوَسِتُں شَکْنُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","پُتُح سَمِیپےہَں یُشْمانْ اَپَوَدِشْیامِیتِ ما چِنْتَیَتَ یَسْمِنْ ، یَسْمِنْ یُشْماکَں وِشْوَسَح سَایوَ مُوسا یُشْمانْ اَپَوَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","یَدِ یُویَں تَسْمِنْ وْیَشْوَسِشْیَتَ تَرْہِ مَیَّپِ وْیَشْوَسِشْیَتَ، یَتْ سَ مَیِ لِکھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","تَتو یَدِ تینَ لِکھِتَوانِ نَ پْرَتِتھَ تَرْہِ مَمَ واکْیانِ کَتھَں پْرَتْییشْیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","تَتَح پَرَں یِیشُ رْگالِیلْ پْرَدیشِییَسْیَ تِوِرِیانامْنَح سِنْدھوح پارَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","تَتو وْیادھِمَلّوکَسْواسْتھْیَکَرَنَرُوپانِ تَسْیاشْچَرْیّانِ کَرْمّانِ درِشْٹْوا بَہَوو جَناسْتَتْپَشْچادْ اَگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","تَتو یِیشُح پَرْوَّتَمارُہْیَ تَتْرَ شِشْیَیح ساکَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","تَسْمِنْ سَمَیَ نِسْتاروتْسَوَنامْنِ یِہُودِییانامَ اُتْسَوَ اُپَسْتھِتی ");
INSERT INTO sanurd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","یِیشُ رْنیتْرے اُتّولْیَ بَہُلوکانْ سْوَسَمِیپاگَتانْ وِلوکْیَ پھِلِپَں پرِشْٹَوانْ ایتیشاں بھوجَنایَ بھوجَدْرَوْیانِ وَیَں کُتْرَ کْریتُں شَکْرُمَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","واکْیَمِدَں تَسْیَ پَرِیکْشارْتھَمْ اَوادِیتْ کِنْتُ یَتْ کَرِشْیَتِ تَتْ سْوَیَمْ اَجاناتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","پھِلِپَح پْرَتْیَووچَتْ ایتیشامْ ایکَیکو یَدْیَلْپَمْ اَلْپَں پْراپْنوتِ تَرْہِ مُدْراپادَدْوِشَتینَ کْرِیتَپُوپا اَپِ نْیُونا بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","شِمونْ پِتَرَسْیَ بھْراتا آنْدْرِیاکھْیَح شِشْیانامیکو وْیاہرِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","اَتْرَ کَسْیَچِدْ بالَکَسْیَ سَمِیپے پَنْچَ یاوَپُوپاح کْشُدْرَمَتْسْیَدْوَیَنْچَ سَنْتِ کِنْتُ لوکاناں ایتاواتاں مَدھْیے تَیح کِں بھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","پَشْچادْ یِیشُرَوَدَتْ لوکانُپَویشَیَتَ تَتْرَ بَہُیَوَسَسَتّواتْ پَنْچَسَہَسْتْریبھْیو نْیُونا اَدھِکا وا پُرُشا بھُومْیامْ اُپاوِشَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","تَتو یِیشُسْتانْ پُوپانادایَ اِیشْوَرَسْیَ گُنانْ کِیرْتَّیِتْوا شِشْییشُ سَمارْپَیَتْ تَتَسْتے تیبھْیَ اُپَوِشْٹَلوکیبھْیَح پُوپانْ یَتھیشْٹَمَتْسْیَنْچَ پْرادُح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","تیشُ ترِپْتیشُ سَ تانَووچَدْ ایتیشاں کِنْچِدَپِ یَتھا ناپَچِییَتے تَتھا سَرْوّانْیَوَشِشْٹانِ سَںگرِہْلِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","تَتَح سَرْوّیشاں بھوجَناتْ پَرَں تے تیشاں پَنْچاناں یاوَپُوپاناں اَوَشِشْٹانْیَکھِلانِ سَںگرِہْیَ دْوادَشَڈَلَّکانْ اَپُورَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","اَپَرَں یِیشوریتادرِشِیمْ آشْچَرْیَّکْرِیاں درِشْٹْوا لوکا مِتھو وَکْتُماریبھِرے جَگَتِ یَسْیاگَمَنَں بھَوِشْیَتِ سَ ایوایَمْ اَوَشْیَں بھَوِشْیَدْوَکْتّا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","اَتَایوَ لوکا آگَتْیَ تَماکْرَمْیَ راجانَں کَرِشْیَنْتِ یِیشُسْتیشامْ اِیدرِشَں مانَسَں وِجْنایَ پُنَشْچَ پَرْوَّتَمْ ایکاکِی گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","سایَںکالَ اُپَسْتھِتے شِشْیا جَلَدھِتَٹَں وْرَجِتْوا ناوَمارُہْیَ نَگَرَدِشِ سِنْدھَو واہَیِتْواگَمَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","تَسْمِنْ سَمَیے تِمِرَ اُپاتِشْٹھَتْ کِنْتُ یِیشُسْتیشاں سَمِیپَں ناگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","تَدا پْرَبَلَپَوَنَوَہَناتْ ساگَرے مَہاتَرَنْگو بھَوِتُمْ آریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","تَتَسْتے واہَیِتْوا دْوِتْرانْ کْروشانْ گَتاح پَشْچادْ یِیشُں جَلَدھیرُپَرِ پَدْبھْیاں وْرَجَنْتَں نَوکانْتِکَمْ آگَچّھَنْتَں وِلوکْیَ تْراسَیُکْتا اَبھَوَنْ ");
INSERT INTO sanurd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","کِنْتُ سَ تانُکْتَّوانْ اَیَمَہَں ما بھَیشْٹَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","تَدا تے تَں سْوَیرَں ناوِ گرِہِیتَوَنْتَح تَدا تَتْکْشَنادْ اُدِّشْٹَسْتھانے نَورُپاسْتھاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","یَیا ناوا شِشْیا اَگَچّھَنْ تَدَنْیا کاپِ نَوکا تَسْمِنْ سْتھانے ناسِیتْ تَتو یِیشُح شِشْیَیح ساکَں ناگَمَتْ کیوَلاح شِشْیا اَگَمَنْ ایتَتْ پارَسْتھا لوکا جْناتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","کِنْتُ تَتَح پَرَں پْرَبھُ رْیَتْرَ اِیشْوَرَسْیَ گُنانْ اَنُکِیرْتّیَ لوکانْ پُوپانْ اَبھوجَیَتْ تَتْسْتھانَسْیَ سَمِیپَسْتھَتِوِرِیایا اَپَراسْتَرَنَیَ آگَمَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","یِیشُسْتَتْرَ ناسْتِ شِشْیا اَپِ تَتْرَ نا سَنْتِ لوکا اِتِ وِجْنایَ یِیشُں گَویشَیِتُں تَرَنِبھِح کَپھَرْناہُومْ پُرَں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","تَتَسْتے سَرِتْپَتیح پارے تَں ساکْشاتْ پْراپْیَ پْراووچَنْ ہے گُرو بھَوانْ اَتْرَ سْتھانے کَداگَمَتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","تَدا یِیشُسْتانْ پْرَتْیَوادِیدْ یُشْمانَہَں یَتھارْتھَتَرَں وَدامِ آشْچَرْیَّکَرْمَّدَرْشَنادّھیتو رْنَ کِنْتُ پُوپَبھوجَناتْ تینَ ترِپْتَتْوانْچَ ماں گَویشَیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","کْشَیَنِییَبھَکْشْیارْتھَں ما شْرامِشْٹَ کِنْتْوَنْتایُرْبھَکْشْیارْتھَں شْرامْیَتَ، تَسْماتْ تادرِشَں بھَکْشْیَں مَنُجَپُتْرو یُشْمابھْیَں داسْیَتِ؛ تَسْمِنْ تاتَ اِیشْوَرَح پْرَمانَں پْراداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","تَدا تےپرِچّھَنْ اِیشْوَرابھِمَتَں کَرْمَّ کَرْتُّمْ اَسْمابھِح کِں کَرْتَّوْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","تَتو یِیشُرَوَدَدْ اِیشْوَرو یَں پْرَیرَیَتْ تَسْمِنْ وِشْوَسَنَمْ اِیشْوَرابھِمَتَں کَرْمَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","تَدا تے وْیاہَرَنْ بھَوَتا کِں لَکْشَنَں دَرْشِتَں یَدّرِشْٹْوا بھَوَتِ وِشْوَسِشْیامَح؟ تْوَیا کِں کَرْمَّ کرِتَں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","اَسْماکَں پُورْوَّپُرُشا مَہاپْرانْتَرے مانّاں بھوکْتُّں پْراپُح یَتھا لِپِراسْتے۔ سْوَرْگِییانِ تُ بھَکْشْیانِ پْرَدَدَو پَرَمیشْوَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","تَدا یِیشُرَوَدَدْ اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ مُوسا یُشْمابھْیَں سْوَرْگِییَں بھَکْشْیَں ناداتْ کِنْتُ مَمَ پِتا یُشْمابھْیَں سْوَرْگِییَں پَرَمَں بھَکْشْیَں دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","یَح سْوَرْگادَوَرُہْیَ جَگَتے جِیوَنَں دَداتِ سَ اِیشْوَرَدَتَّبھَکْشْیَرُوپَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","تَدا تے پْراووچَنْ ہے پْرَبھو بھَکْشْیَمِدَں نِتْیَمَسْمَبھْیَں دَداتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","یِیشُرَوَدَدْ اَہَمیوَ جِیوَنَرُوپَں بھَکْشْیَں یو جَنو مَمَ سَنِّدھِمْ آگَچّھَتِ سَ جاتُ کْشُدھارْتّو نَ بھَوِشْیَتِ، تَتھا یو جَنو ماں پْرَتْییتِ سَ جاتُ ترِشارْتّو نَ بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ماں درِشْٹْواپِ یُویَں نَ وِشْوَسِتھَ یُشْمانَہَمْ اِتْیَووچَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","پِتا مَہْیَں یاوَتو لوکانَدَداتْ تے سَرْوَّ ایوَ مَمانْتِکَمْ آگَمِشْیَنْتِ یَح کَشْچِچَّ مَمَ سَنِّدھِمْ آیاسْیَتِ تَں کیناپِ پْرَکارینَ نَ دُورِیکَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","نِجابھِمَتَں سادھَیِتُں نَ ہِ کِنْتُ پْریرَیِتُرَبھِمَتَں سادھَیِتُں سْوَرْگادْ آگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","سَ یانْ یانْ لوکانْ مَہْیَمَدَداتْ تیشامیکَمَپِ نَ ہارَیِتْوا شیشَدِنے سَرْوّانَہَمْ اُتّھاپَیامِ اِدَں مَتْپْریرَیِتُح پِتُرَبھِمَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","یَح کَشْچِنْ مانَوَسُتَں وِلوکْیَ وِشْوَسِتِ سَ شیشَدِنے مَیوتّھاپِتَح سَنْ اَنَنْتایُح پْراپْسْیَتِ اِتِ مَتْپْریرَکَسْیابھِمَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","تَدا سْوَرْگادْ یَدْ بھَکْشْیَمْ اَواروہَتْ تَدْ بھَکْشْیَمْ اَہَمیوَ یِہُودِییَلوکاسْتَسْیَیتَدْ واکْیے وِوَدَمانا وَکْتُّماریبھِری ");
INSERT INTO sanurd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","یُوشَپھَح پُتْرو یِیشُ رْیَسْیَ ماتاپِتَرَو وَیَں جانِیمَ ایشَ کِں سَایوَ نَ؟ تَرْہِ سْوَرْگادْ اَواروہَمْ اِتِ واکْیَں کَتھَں وَکْتِّ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","تَدا یِیشُسْتانْ پْرَتْیَوَدَتْ پَرَسْپَرَں ما وِوَدَدھْوَں ");
INSERT INTO sanurd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","مَتْپْریرَکینَ پِتْرا ناکرِشْٹَح کوپِ جَنو مَمانْتِکَمْ آیاتُں نَ شَکْنوتِ کِنْتْواگَتَں جَنَں چَرَمےہْنِ پْروتّھاپَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","تے سَرْوَّ اِیشْوَرینَ شِکْشِتا بھَوِشْیَنْتِ بھَوِشْیَدْوادِناں گْرَنْتھیشُ لِپِرِتّھَماسْتے اَتو یَح کَشْچِتْ پِتُح سَکاشاتْ شْرُتْوا شِکْشَتے سَ ایوَ مَمَ سَمِیپَمْ آگَمِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","یَ اِیشْوَرادْ اَجایَتَ تَں وِنا کوپِ مَنُشْیو جَنَکَں نادَرْشَتْ کیوَلَح سَایوَ تاتَمْ اَدْراکْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","اَہَں یُشْمانْ یَتھارْتھَتَرَں وَدامِ یو جَنو مَیِ وِشْواسَں کَروتِ سونَنْتایُح پْراپْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","اَہَمیوَ تَجِّیوَنَبھَکْشْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","یُشْماکَں پُورْوَّپُرُشا مَہاپْرانْتَرے مَنّابھَکْشْیَں بھُوکْتّاپِ مرِتاح ");
INSERT INTO sanurd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","کِنْتُ یَدْبھَکْشْیَں سْوَرْگاداگَچّھَتْ تَدْ یَدِ کَشْچِدْ بھُنْکْتّے تَرْہِ سَ نَ مْرِیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","یَجِّیوَنَبھَکْشْیَں سْوَرْگاداگَچّھَتْ سوہَمیوَ اِدَں بھَکْشْیَں یو جَنو بھُنْکْتّے سَ نِتْیَجِیوِی بھَوِشْیَتِ۔ پُنَشْچَ جَگَتو جِیوَنارْتھَمَہَں یَتْ سْوَکِییَپِشِتَں داسْیامِ تَدیوَ مَیا وِتَرِتَں بھَکْشْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","تَسْمادْ یِہُودِییاح پَرَسْپَرَں وِوَدَمانا وَکْتُّماریبھِرے ایشَ بھوجَنارْتھَں سْوِییَں پَلَلَں کَتھَمْ اَسْمَبھْیَں داسْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","تَدا یِیشُسْتانْ آووچَدْ یُشْمانَہَں یَتھارْتھَتَرَں وَدامِ مَنُشْیَپُتْرَسْیامِشے یُشْمابھِ رْنَ بھُکْتّے تَسْیَ رُدھِرے چَ نَ پِیتے جِیوَنینَ سارْدّھَں یُشْماکَں سَمْبَنْدھو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","یو مَمامِشَں سْوادَتِ مَمَ سُدھِرَنْچَ پِوَتِ سونَنْتایُح پْراپْنوتِ تَتَح شیشےہْنِ تَمَہَمْ اُتّھاپَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","یَتو مَدِییَمامِشَں پَرَمَں بھَکْشْیَں تَتھا مَدِییَں شونِتَں پَرَمَں پییَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","یو جَنو مَدِییَں پَلَلَں سْوادَتِ مَدِییَں رُدھِرَنْچَ پِوَتِ سَ مَیِ وَسَتِ تَسْمِنَّہَنْچَ وَسامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","مَتْپْریرَیِتْرا جِیوَتا تاتینَ یَتھاہَں جِیوامِ تَدْوَدْ یَح کَشْچِنْ مامَتِّ سوپِ مَیا جِیوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","یَدْبھَکْشْیَں سْوَرْگاداگَچّھَتْ تَدِدَں یَنْمانّاں سْوادِتْوا یُشْماکَں پِتَرومْرِیَنْتَ تادرِشَمْ اِدَں بھَکْشْیَں نَ بھَوَتِ اِدَں بھَکْشْیَں یو بھَکْشَتِ سَ نِتْیَں جِیوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","یَدا کَپھَرْناہُومْ پُرْیّاں بھَجَنَگیہے اُپادِشَتْ تَدا کَتھا ایتا اَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","تَدیتّھَں شْرُتْوا تَسْیَ شِشْیانامْ اَنیکے پَرَسْپَرَمْ اَکَتھَیَنْ اِدَں گاڈھَں واکْیَں واکْیَمِیدرِشَں کَح شْروتُں شَکْرُیاتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","کِنْتُ یِیشُح شِشْیانامْ اِتّھَں وِوادَں سْوَچِتّے وِجْنایَ کَتھِتَوانْ اِدَں واکْیَں کِں یُشْماکَں وِگھْنَں جَنَیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","یَدِ مَنُجَسُتَں پُورْوَّواسَسْتھانَمْ اُورْدْوَّں گَچّھَنْتَں پَشْیَتھَ تَرْہِ کِں بھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","آتْمَیوَ جِیوَنَدایَکَح وَپُ رْنِشْپھَلَں یُشْمَبھْیَمَہَں یانِ وَچاںسِ کَتھَیامِ تانْیاتْما جِیوَنَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","کِنْتُ یُشْماکَں مَدھْیے کیچَنَ اَوِشْواسِنَح سَنْتِ کے کے نَ وِشْوَسَنْتِ کو وا تَں پَرَکَریشُ سَمَرْپَیِشْیَتِ تانْ یِیشُراپْرَتھَمادْ ویتِّ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","اَپَرَمَپِ کَتھِتَوانْ اَسْماتْ کارَنادْ اَکَتھَیَں پِتُح سَکاشاتْ شَکْتِّمَپْراپْیَ کوپِ مَمانْتِکَمْ آگَنْتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","تَتْکالےنیکے شِشْیا وْیاگھُٹْیَ تینَ سارْدّھَں پُنَ رْناگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","تَدا یِیشُ رْدْوادَشَشِشْیانْ اُکْتَّوانْ یُویَمَپِ کِں یاسْیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","تَتَح شِمونْ پِتَرَح پْرَتْیَووچَتْ ہے پْرَبھو کَسْیابھْیَرْنَں گَمِشْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","اَنَنْتَجِیوَنَدایِنْیو یاح کَتھاسْتاسْتَوَیوَ۔ بھَوانْ اَمَریشْوَرَسْیابھِشِکْتَّپُتْرَ اِتِ وِشْوَسْیَ نِشْچِتَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","تَدا یِیشُرَوَدَتْ کِمَہَں یُشْماکَں دْوادَشَجَنانْ مَنونِیتانْ نَ کرِتَوانْ؟ کِنْتُ یُشْماکَں مَدھْییپِ کَشْچِدیکو وِگھْنَکارِی وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","اِماں کَتھَں سَ شِمونَح پُتْرَمْ اِیشْکَرِییوتِییَں یِہُودامْ اُدِّشْیَ کَتھِتَوانْ یَتو دْوادَشاناں مَدھْیے گَنِتَح سَ تَں پَرَکَریشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","تَتَح پَرَں یِہُودِییَلوکاسْتَں ہَنْتُں سَمَیہَنْتَ تَسْمادْ یِیشُ رْیِہُوداپْرَدیشے پَرْیَّٹِتُں نیچّھَنْ گالِیلْ پْرَدیشے پَرْیَّٹِتُں پْرارَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","کِنْتُ تَسْمِنْ سَمَیے یِہُودِییاناں دُوشْیَواسَناموتْسَوَ اُپَسْتھِتی ");
INSERT INTO sanurd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","تَسْیَ بھْراتَرَسْتَمْ اَوَدَنْ یانِ کَرْمّانِ تْوَیا کْرِیَنْتے تانِ یَتھا تَوَ شِشْیاح پَشْیَنْتِ تَدَرْتھَں تْوَمِتَح سْتھانادْ یِہُودِییَدیشَں وْرَجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","یَح کَشْچِتْ سْوَیَں پْرَچِکاشِشَتِ سَ کَداپِ گُپْتَں کَرْمَّ نَ کَروتِ یَدِیدرِشَں کَرْمَّ کَروشِ تَرْہِ جَگَتِ نِجَں پَرِچایَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","یَتَسْتَسْیَ بھْراتَروپِ تَں نَ وِشْوَسَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","تَدا یِیشُسْتانْ اَووچَتْ مَمَ سَمَیَ اِدانِیں نوپَتِشْٹھَتِ کِنْتُ یُشْماکَں سَمَیَح سَتَتَمْ اُپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","جَگَتو لوکا یُشْمانْ رِتِییِتُں نَ شَکْرُوَنْتِ کِنْتُ مامیوَ رِتِییَنْتے یَتَسْتیشاں کَرْمانِ دُشْٹانِ تَتْرَ ساکْشْیَمِدَمْ اَہَں دَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","اَتَایوَ یُویَمْ اُتْسَوےسْمِنْ یاتَ ناہَمْ اِدانِیمْ اَسْمِنُّتْسَوے یامِ یَتو مَمَ سَمَیَ اِدانِیں نَ سَمْپُورْنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","اِتِ واکْیَمْ اُکْتّوا سَ گالِیلِ سْتھِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","کِنْتُ تَسْیَ بھْراترِشُ تَتْرَ پْرَسْتھِتیشُ سَتْسُ سوپْرَکَٹَ اُتْسَوَمْ اَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","اَنَنْتَرَمْ اُتْسَوَمْ اُپَسْتھِتا یِہُودِییاسْتَں مرِگَیِتْواپرِچّھَنْ سَ کُتْرَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","تَتو لوکاناں مَدھْیے تَسْمِنْ ناناوِدھا وِوادا بھَوِتُمْ آرَبْدھَوَنْتَح۔ کیچِدْ اَووچَنْ سَ اُتَّمَح پُرُشَح کیچِدْ اَووچَنْ نَ تَتھا وَرَں لوکاناں بھْرَمَں جَنَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","کِنْتُ یِہُودِییاناں بھَیاتْ کوپِ تَسْیَ پَکْشے سْپَشْٹَں ناکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","تَتَح پَرَمْ اُتْسَوَسْیَ مَدھْیَسَمَیے یِیشُ رْمَنْدِرَں گَتْوا سَمُپَدِشَتِ سْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","تَتو یِہُودِییا لوکا آشْچَرْیَّں جْناتْواکَتھَیَنْ ایشا مانُشو نادھِیتْیا کَتھَمْ ایتادرِشو وِدْوانَبھُوتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","تَدا یِیشُح پْرَتْیَووچَدْ اُپَدیشویَں نَ مَمَ کِنْتُ یو ماں پْریشِتَوانْ تَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","یو جَنو نِدیشَں تَسْیَ گْرَہِیشْیَتِ مَموپَدیشو مَتّو بھَوَتِ کِمْ اِیشْوَرادْ بھَوَتِ سَ گَنَسْتَجّناتُں شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","یو جَنَح سْوَتَح کَتھَیَتِ سَ سْوِییَں گَورَوَمْ اِیہَتے کِنْتُ یَح پْریرَیِتُ رْگَورَوَمْ اِیہَتے سَ سَتْیَوادِی تَسْمِنْ کوپْیَدھَرْمّو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","مُوسا یُشْمَبھْیَں وْیَوَسْتھاگْرَنْتھَں کِں نادَداتْ؟ کِنْتُ یُشْماکَں کوپِ تاں وْیَوَسْتھاں نَ سَماچَرَتِ۔ ماں ہَنْتُں کُتو یَتَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","تَدا لوکا اَوَدَنْ تْوَں بھُوتَگْرَسْتَسْتْواں ہَنْتُں کو یَتَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","تَتو یِیشُرَووچَدْ ایکَں کَرْمَّ مَیاکارِ تَسْمادْ یُویَں سَرْوَّ مَہاشْچَرْیَّں مَنْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","مُوسا یُشْمَبھْیَں تْوَکْچھیدَوِدھِں پْرَدَدَو سَ مُوساتو نَ جاتَح کِنْتُ پِترِپُرُشیبھْیو جاتَح تینَ وِشْرامَوارےپِ مانُشاناں تْوَکْچھیدَں کُرُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","اَتَایوَ وِشْرامَوارے مَنُشْیاناں تْوَکْچھیدے کرِتے یَدِ مُوساوْیَوَسْتھامَنْگَنَں نَ بھَوَتِ تَرْہِ مَیا وِشْرامَوارے مانُشَح سَمْپُورْنَرُوپینَ سْوَسْتھوکارِ تَتْکارَنادْ یُویَں کِں مَہْیَں کُپْیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","سَپَکْشَپاتَں وِچارَمَکرِتْوا نْیایَّں وِچارَں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","تَدا یِرُوشالَمْ نِواسِنَح کَتِپَیَجَنا اَکَتھَیَنْ اِمے یَں ہَنْتُں چیشْٹَنْتے سَ ایوایَں کِں نَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","کِنْتُ پَشْیَتَ نِرْبھَیَح سَنْ کَتھاں کَتھَیَتِ تَتھاپِ کِمَپِ اَ وَدَنْتْییتے اَیَمیوابھِشِکْتّو بھَوَتِیتِ نِشْچِتَں کِمَدھِپَتَیو جانَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","مَنُجویَں کَسْماداگَمَدْ اِتِ وَیَں جانومَح کِنْتْوَبھِشِکْتَّ آگَتے سَ کَسْماداگَتَوانْ اِتِ کوپِ جْناتُں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","تَدا یِیشُ رْمَدھْییمَنْدِرَمْ اُپَدِشَنْ اُچَّیحکارَمْ اُکْتَّوانْ یُویَں کِں ماں جانِیتھَ؟ کَسْماچّاگَتوسْمِ تَدَپِ کِں جانِیتھَ؟ ناہَں سْوَتَ آگَتوسْمِ کِنْتُ یَح سَتْیَوادِی سَایوَ ماں پْریشِتَوانْ یُویَں تَں نَ جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","تَمَہَں جانے تیناہَں پْریرِتَ اَگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","تَسْمادْ یِہُودِییاسْتَں دھَرْتُّمْ اُدْیَتاسْتَتھاپِ کوپِ تَسْیَ گاتْرے ہَسْتَں نارْپَیَدْ یَتو ہیتوسْتَدا تَسْیَ سَمَیو نوپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","کِنْتُ بَہَوو لوکاسْتَسْمِنْ وِشْوَسْیَ کَتھِتَوانْتوبھِشِکْتَّپُرُشَ آگَتْیَ مانُشَسْیاسْیَ کْرِیابھْیَح کِمْ اَدھِکا آشْچَرْیّاح کْرِیاح کَرِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","تَتَح پَرَں لوکاسْتَسْمِنْ اِتّھَں وِوَدَنْتے پھِرُوشِنَح پْرَدھانَیاجَکانْچیتِ شْرُتَوَنْتَسْتَں دھرِتْوا نیتُں پَداتِگَنَں پْریشَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","تَتو یِیشُرَوَدَدْ اَہَمْ اَلْپَدِنانِ یُشْمابھِح سارْدّھَں سْتھِتْوا مَتْپْریرَیِتُح سَمِیپَں یاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ماں مرِگَیِشْیَدھْوے کِنْتُودّیشَں نَ لَپْسْیَدھْوے رَتْرَ سْتھاسْیامِ تَتْرَ یُویَں گَنْتُں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","تَدا یِہُودِییاح پَرَسْپَرَں وَکْتُّماریبھِرے اَسْیودّیشَں نَ پْراپْسْیامَ ایتادرِشَں کِں سْتھانَں یاسْیَتِ؟ بھِنَّدیشے وِکِیرْناناں یِہُودِییاناں سَنِّدھِمْ ایشَ گَتْوا تانْ اُپَدیکْشْیَتِ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","نو چیتْ ماں گَویشَیِشْیَتھَ کِنْتُودّیشَں نَ پْراپْسْیَتھَ ایشَ کودرِشَں واکْیَمِدَں وَدَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","اَنَنْتَرَمْ اُتْسَوَسْیَ چَرَمےہَنِ اَرْتھاتْ پْرَدھانَدِنے یِیشُرُتِّشْٹھَنْ اُچَّیحکارَمْ آہْوَیَنْ اُدِتَوانْ یَدِ کَشْچِتْ ترِشارْتّو بھَوَتِ تَرْہِ مَمانْتِکَمْ آگَتْیَ پِوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","یَح کَشْچِنْمَیِ وِشْوَسِتِ دھَرْمَّگْرَنْتھَسْیَ وَچَنانُسارینَ تَسْیابھْیَنْتَرَتومرِتَتویَسْیَ سْروتاںسِ نِرْگَمِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","یے تَسْمِنْ وِشْوَسَنْتِ تَ آتْمانَں پْراپْسْیَنْتِیتْیَرْتھے سَ اِدَں واکْیَں وْیاہرِتَوانْ ایتَتْکالَں یاوَدْ یِیشُ رْوِبھَوَں نَ پْراپْتَسْتَسْماتْ پَوِتْرَ آتْما نادِییَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ایتاں وانِیں شْرُتْوا بَہَوو لوکا اَوَدَنْ اَیَمیوَ نِشْچِتَں سَ بھَوِشْیَدْوادِی۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","کیچِدْ اَکَتھَیَنْ ایشَایوَ سوبھِشِکْتَّح کِنْتُ کیچِدْ اَوَدَنْ سوبھِشِکْتَّح کِں گالِیلْ پْرَدیشے جَنِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","سوبھِشِکْتّو دایُودو وَںشے دایُودو جَنْمَسْتھانے بَیتْلیہَمِ پَتَّنے جَنِشْیَتے دھَرْمَّگْرَنْتھے کِمِتّھَں لِکھِتَں ناسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","اِتّھَں تَسْمِنْ لوکاناں بھِنَّواکْیَتا جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","کَتِپَیَلوکاسْتَں دھَرْتُّمْ اَیچّھَنْ تَتھاپِ تَدْوَپُشِ کوپِ ہَسْتَں نارْپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","اَنَنْتَرَں پاداتِگَنے پْرَدھانَیاجَکاناں پھِرُوشِنانْچَ سَمِیپَماگَتَوَتِ تے تانْ اَپرِچّھَنْ کُتو ہیتوسْتَں نانَیَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","تَدا پَداتَیَح پْرَتْیَوَدَنْ سَ مانَوَ اِوَ کوپِ کَداپِ نوپادِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","تَتَح پھِرُوشِنَح پْراووچَنْ یُویَمَپِ کِمَبھْرامِشْٹَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","اَدھِپَتِیناں پھِرُوشِنانْچَ کوپِ کِں تَسْمِنْ وْیَشْوَسِیتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","یے شاسْتْرَں نَ جانَنْتِ تَ اِمےدھَمَلوکاایوَ شاپَگْرَسْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","تَدا نِکَدِیمَناما تیشامیکو یَح کْشَنَدایاں یِیشوح سَنِّدھِمْ اَگاتْ سَ اُکْتَّوانْ ");
INSERT INTO sanurd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","تَسْیَ واکْیے نَ شْرُتے کَرْمَّنِ چَ نَ وِدِتے سْماکَں وْیَوَسْتھا کِں کَنْچَنَ مَنُجَں دوشِیکَروتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","تَتَسْتے وْیاہَرَنْ تْوَمَپِ کِں گالِیلِییَلوکَح؟ وِوِچْیَ پَشْیَ گَلِیلِ کوپِ بھَوِشْیَدْوادِی نوتْپَدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","تَتَح پَرَں سَرْوّے سْوَں سْوَں گرِہَں گَتاح کِنْتُ یِیشُ رْجَیتُنَنامانَں شِلوچَّیَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","پْرَتْیُوشے یِیشُح پَنَرْمَنْدِرَمْ آگَچّھَتْ ");
INSERT INTO sanurd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","تَتَح سَرْوّیشُ لوکیشُ تَسْیَ سَمِیپَ آگَتیشُ سَ اُپَوِشْیَ تانْ اُپَدیشْٹُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","تَدا اَدھْیاپَکاح پھِرُوشِنَنْچَ وْیَبھِچارَکَرْمَّنِ دھرِتَں سْتْرِیَمیکامْ آنِیَ سَرْوّیشاں مَدھْیے سْتھاپَیِتْوا وْیاہَرَنْ ");
INSERT INTO sanurd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ہے گُرو یوشِتَمْ اِماں وْیَبھِچارَکَرْمَّ کُرْوّاناں لوکا دھرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ایتادرِشَلوکاح پاشاناگھاتینَ ہَنْتَوْیا اِتِ وِدھِرْمُوساوْیَوَسْتھاگْرَنْتھے لِکھِتوسْتِ کِنْتُ بھَوانْ کِمادِشَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","تے تَمَپَوَدِتُں پَرِیکْشابھِپْرایینَ واکْیَمِدَمْ اَپرِچّھَنْ کِنْتُ سَ پْرَہْوِیبھُویَ بھُوماوَنْگَلْیا لیکھِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","تَتَسْتَیح پُنَح پُنَح پرِشْٹَ اُتّھایَ کَتھِتَوانْ یُشْماکَں مَدھْیے یو جَنو نِرَپَرادھِی سَایوَ پْرَتھَمَمْ ایناں پاشانیناہَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","پَشْچاتْ سَ پُنَشْچَ پْرَہْوِیبھُویَ بھُومَو لیکھِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","تاں کَتھَں شْرُتْوا تے سْوَسْوَمَنَسِ پْرَبودھَں پْراپْیَ جْییشْٹھانُکْرَمَں ایکَیکَشَح سَرْوّے بَہِرَگَچّھَنْ تَتو یِیشُریکاکِی تَیَکْتّوبھَوَتْ مَدھْیَسْتھانے دَنْڈایَمانا سا یوشا چَ سْتھِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","تَتْپَشْچادْ یِیشُرُتّھایَ تاں وَنِتاں وِنا کَمَپْیَپَرَں نَ وِلوکْیَ پرِشْٹَوانْ ہے وامے تَواپَوادَکاح کُتْرَ؟ کوپِ تْواں کِں نَ دَنْڈَیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ساوَدَتْ ہے مَہیچّھَ کوپِ نَ تَدا یِیشُرَووچَتْ ناہَمَپِ دَنْڈَیامِ یاہِ پُنَح پاپَں ماکارْشِیح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","تَتو یِیشُح پُنَرَپِ لوکیبھْیَ اِتّھَں کَتھَیِتُمْ آرَبھَتَ جَگَتوہَں جْیوتِحسْوَرُوپو یَح کَشْچِنْ مَتْپَشْچادَ گَچّھَتِ سَ تِمِرے نَ بھْرَمِتْوا جِیوَنَرُوپاں دِیپْتِں پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","تَتَح پھِرُوشِنووادِشُسْتْوَں سْوارْتھے سْوَیَں ساکْشْیَں دَداسِ تَسْماتْ تَوَ ساکْشْیَں گْراہْیَں نَ بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","تَدا یِیشُح پْرَتْیُدِتَوانْ یَدْیَپِ سْوارْتھےہَں سْوَیَں ساکْشْیَں دَدامِ تَتھاپِ مَتْ ساکْشْیَں گْراہْیَں یَسْمادْ اَہَں کُتَ آگَتوسْمِ کْوَ یامِ چَ تَدَہَں جانامِ کِنْتُ کُتَ آگَتوسْمِ کُتْرَ گَچّھامِ چَ تَدْ یُویَں نَ جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","یُویَں لَوکِکَں وِچارَیَتھَ ناہَں کِمَپِ وِچارَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","کِنْتُ یَدِ وِچارَیامِ تَرْہِ مَمَ وِچارو گْرَہِیتَوْیو یَتوہَمْ ایکاکِی ناسْمِ پْریرَیِتا پِتا مَیا سَہَ وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","دْوَیو رْجَنَیوح ساکْشْیَں گْرَہَنِییَں بھَوَتِیتِ یُشْماکَں وْیَوَسْتھاگْرَنْتھے لِکھِتَمَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","اَہَں سْوارْتھے سْوَیَں ساکْشِتْوَں دَدامِ یَشْچَ مَمَ تاتو ماں پْریرِتَوانْ سوپِ مَدَرْتھے ساکْشْیَں دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","تَدا تےپرِچّھَنْ تَوَ تاتَح کُتْرَ؟ تَتو یِیشُح پْرَتْیَوادِیدْ یُویَں ماں نَ جانِیتھَ مَتْپِتَرَنْچَ نَ جانِیتھَ یَدِ مامْ اَکْشاسْیَتَ تَرْہِ مَمَ تاتَمَپْیَکْشاسْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","یِیشُ رْمَنْدِرَ اُپَدِشْیَ بھَنْڈاگارے کَتھا ایتا اَکَتھَیَتْ تَتھاپِ تَں پْرَتِ کوپِ کَرَں نودَتولَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","تَتَح پَرَں یِیشُح پُنَرُدِتَوانْ اَدھُناہَں گَچّھامِ یُویَں ماں گَویشَیِشْیَتھَ کِنْتُ نِجَیح پاپَے رْمَرِشْیَتھَ یَتْ سْتھانَمْ اَہَں یاسْیامِ تَتْ سْتھانَمْ یُویَں یاتُں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","تَدا یِہُودِییاح پْراووچَنْ کِمَیَمْ آتْمَگھاتَں کَرِشْیَتِ؟ یَتو یَتْ سْتھانَمْ اَہَں یاسْیامِ تَتْ سْتھانَمْ یُویَں یاتُں نَ شَکْشْیَتھَ اِتِ واکْیَں بْرَوِیتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","تَتو یِیشُسْتیبھْیَح کَتھِتَوانْ یُویَمْ اَدھَحسْتھانِییا لوکا اَہَمْ اُورْدْوَّسْتھانِییَح یُویَمْ ایتَجَّگَتْسَمْبَنْدھِییا اَہَمْ ایتَجَّگَتْسَمْبَنْدھِییو نَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","تَسْماتْ کَتھِتَوانْ یُویَں نِجَیح پاپَے رْمَرِشْیَتھَ یَتوہَں سَ پُمانْ اِتِ یَدِ نَ وِشْوَسِتھَ تَرْہِ نِجَیح پاپَے رْمَرِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","تَدا تے پرِچّھَنْ کَسْتْوَں؟ تَتو یِیشُح کَتھِتَوانْ یُشْماکَں سَنِّدھَو یَسْیَ پْرَسْتاوَمْ آ پْرَتھَماتْ کَرومِ سَایوَ پُرُشوہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","یُشْماسُ مَیا بَہُواکْیَں وَکْتَّوْیَں وِچارَیِتَوْیَنْچَ کِنْتُ مَتْپْریرَیِتا سَتْیَوادِی تَسْیَ سَمِیپے یَدَہَں شْرُتَوانْ تَدیوَ جَگَتے کَتھَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","کِنْتُ سَ جَنَکے واکْیَمِدَں پْروکْتَّوانْ اِتِ تے نابُدھْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","تَتو یِیشُرَکَتھَیَدْ یَدا مَنُشْیَپُتْرَمْ اُورْدْوَّ اُتّھاپَیِشْیَتھَ تَداہَں سَ پُمانْ کیوَلَح سْوَیَں کِمَپِ کَرْمَّ نَ کَرومِ کِنْتُ تاتو یَتھا شِکْشَیَتِ تَدَنُسارینَ واکْیَمِدَں وَدامِیتِ چَ یُویَں جْناتُں شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","مَتْپْریرَیِتا پِتا مامْ ایکاکِنَں نَ تْیَجَتِ سَ مَیا سارْدّھَں تِشْٹھَتِ یَتوہَں تَدَبھِمَتَں کَرْمَّ سَدا کَرومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","تَدا تَسْیَیتانِ واکْیانِ شْرُتْوا بَہُوَسْتاسْمِنْ وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","یے یِہُودِییا وْیَشْوَسَنْ یِیشُسْتیبھْیوکَتھَیَتْ ");
INSERT INTO sanurd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","مَمَ واکْیے یَدِ یُویَمْ آسْتھاں کُرُتھَ تَرْہِ مَمَ شِشْیا بھُوتْوا سَتْیَتْوَں جْناسْیَتھَ تَتَح سَتْیَتَیا یُشْماکَں موکْشو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","تَدا تے پْرَتْیَوادِشُح وَیَمْ اِبْراہِیمو وَںشَح کَداپِ کَسْیاپِ داسا نَ جاتاسْتَرْہِ یُشْماکَں مُکْتِّ رْبھَوِشْیَتِیتِ واکْیَں کَتھَں بْرَوِیشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","تَدا یِیشُح پْرَتْیَوَدَدْ یُشْمانَہَں یَتھارْتھَتَرَں وَدامِ یَح پاپَں کَروتِ سَ پاپَسْیَ داسَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","داسَشْچَ نِرَنْتَرَں نِویشَنے نَ تِشْٹھَتِ کِنْتُ پُتْرو نِرَنْتَرَں تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","اَتَح پُتْرو یَدِ یُشْمانْ موچَیَتِ تَرْہِ نِتانْتَمیوَ مُکْتّا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","یُیَمْ اِبْراہِیمو وَںشَ اِتْیَہَں جانامِ کِنْتُ مَمَ کَتھا یُشْماکَمْ اَنْتَحکَرَنیشُ سْتھانَں نَ پْراپْنُوَنْتِ تَسْمادّھیتو رْماں ہَنْتُمْ اِیہَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","اَہَں سْوَپِتُح سَمِیپے یَدَپَشْیَں تَدیوَ کَتھَیامِ تَتھا یُویَمَپِ سْوَپِتُح سَمِیپے یَدَپَشْیَتَ تَدیوَ کُرُدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","تَدا تے پْرَتْیَووچَنْ اِبْراہِیمْ اَسْماکَں پِتا تَتو یِیشُرَکَتھَیَدْ یَدِ یُویَمْ اِبْراہِیمَح سَنْتانا اَبھَوِشْیَتَ تَرْہِ اِبْراہِیمَ آچارَنَوَدْ آچَرِشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","اِیشْوَرَسْیَ مُکھاتْ سَتْیَں واکْیَں شْرُتْوا یُشْمانْ جْناپَیامِ یوہَں تَں ماں ہَنْتُں چیشْٹَدھْوے اِبْراہِیمْ ایتادرِشَں کَرْمَّ نَ چَکارَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","یُویَں سْوَسْوَپِتُح کَرْمّانِ کُرُتھَ تَدا تَیرُکْتَّں نَ وَیَں جارَجاتا اَسْماکَمْ ایکَایوَ پِتاسْتِ سَ ایویشْوَرَح ");
INSERT INTO sanurd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","تَتو یِیشُنا کَتھِتَمْ اِیشْوَرو یَدِ یُشْماکَں تاتوبھَوِشْیَتْ تَرْہِ یُویَں مَیِ پْریماکَرِشْیَتَ یَتوہَمْ اِیشْوَرانِّرْگَتْیاگَتوسْمِ سْوَتو ناگَتوہَں سَ ماں پْراہِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","یُویَں مَمَ واکْیَمِدَں نَ بُدھْیَدھْوے کُتَح؟ یَتو یُویَں مَموپَدیشَں سوڈھُں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","یُویَں شَیتانْ پِتُح سَنْتانا ایتَسْمادْ یُشْماکَں پِتُرَبھِلاشَں پُورَیَتھَ سَ آ پْرَتھَماتْ نَرَگھاتِی تَدَنْتَح سَتْیَتْوَسْیَ لیشوپِ ناسْتِ کارَنادَتَح سَ سَتْیَتایاں ناتِشْٹھَتْ سَ یَدا مرِشا کَتھَیَتِ تَدا نِجَسْوَبھاوانُسارینَیوَ کَتھَیَتِ یَتو سَ مرِشابھاشِی مرِشوتْپادَکَشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","اَہَں تَتھْیَواکْیَں وَدامِ کارَنادَسْمادْ یُویَں ماں نَ پْرَتِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","مَیِ پاپَمَسْتِیتِ پْرَمانَں یُشْماکَں کو داتُں شَکْنوتِ؟ یَدْیَہَں تَتھْیَواکْیَں وَدامِ تَرْہِ کُتو ماں نَ پْرَتِتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","یَح کَشْچَنَ اِیشْوَرِییو لوکَح سَ اِیشْوَرِییَکَتھایاں مَنو نِدھَتّے یُویَمْ اِیشْوَرِییَلوکا نَ بھَوَتھَ تَنِّداناتْ تَتْرَ نَ مَناںسِ نِدھَدْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","تَدا یِہُودِییاح پْرَتْیَوادِشُح تْوَمیکَح شومِرونِییو بھُوتَگْرَسْتَشْچَ وَیَں کِمِدَں بھَدْرَں ناوادِشْمَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","تَتو یِیشُح پْرَتْیَوادِیتْ ناہَں بھُوتَگْرَسْتَح کِنْتُ نِجَتاتَں سَمَّنْیے تَسْمادْ یُویَں مامْ اَپَمَنْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","اَہَں سْوَسُکھْیاتِں نَ چیشْٹے کِنْتُ چیشْٹِتا وِچارَیِتا چاپَرَ ایکَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","اَہَں یُشْمَبھْیَمْ اَتِیوَ یَتھارْتھَں کَتھَیامِ یو نَرو مَدِییَں واچَں مَنْیَتے سَ کَداچَنَ نِدھَنَں نَ دْرَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","یِہُودِییاسْتَمَوَدَنْ تْوَں بھُوتَگْرَسْتَ اِتِیدانِیمْ اَوَیشْمَ۔ اِبْراہِیمْ بھَوِشْیَدْوادِنَنْچَ سَرْوّے مرِتاح کِنْتُ تْوَں بھاشَسے یو نَرو مَمَ بھارَتِیں گرِہْلاتِ سَ جاتُ نِدھاناسْوادَں نَ لَپْسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","تَرْہِ تْوَں کِمْ اَسْماکَں پُورْوَّپُرُشادْ اِبْراہِیموپِ مَہانْ؟ یَسْماتْ سوپِ مرِتَح بھَوِشْیَدْوادِنوپِ مرِتاح تْوَں سْوَں کَں پُماںسَں مَنُشے؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","یِیشُح پْرَتْیَووچَدْ یَدْیَہَں سْوَں سْوَیَں سَمَّنْیے تَرْہِ مَمَ تَتْ سَمَّنَنَں کِمَپِ نَ کِنْتُ مَمَ تاتو یَں یُویَں سْوِییَمْ اِیشْوَرَں بھاشَدھْوے سَایوَ ماں سَمَّنُتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","یُویَں تَں ناوَگَچّھَتھَ کِنْتْوَہَں تَمَوَگَچّھامِ تَں ناوَگَچّھامِیتِ واکْیَں یَدِ وَدامِ تَرْہِ یُویَمِوَ مرِشابھاشِی بھَوامِ کِنْتْوَہَں تَمَوَگَچّھامِ تَداکْشامَپِ گرِہْلامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","یُشْماکَں پُورْوَّپُرُشَ اِبْراہِیمْ مَمَ سَمَیَں دْرَشْٹُمْ اَتِیواوانْچھَتْ تَنِّرِیکْشْیانَنْدَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","تَدا یِہُودِییا اَپرِچّھَنْ تَوَ وَیَح پَنْچاشَدْوَتْسَرا نَ تْوَں کِمْ اِبْراہِیمَمْ اَدْراکْشِیح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","یِیشُح پْرَتْیَوادِیدْ یُشْمانَہَں یَتھارْتھَتَرَں وَدامِ اِبْراہِیمو جَنْمَنَح پُورْوَّکالَمارَبھْیاہَں وِدْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","تَدا تے پاشانانْ اُتّولْیَ تَماہَنْتُمْ اُدَیَچّھَنْ کِنْتُ یِیشُ رْگُپْتو مَنْتِرادْ بَہِرْگَتْیَ تیشاں مَدھْیینَ پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","تَتَح پَرَں یِیشُرْگَچّھَنْ مارْگَمَدھْیے جَنْمانْدھَں نَرَمْ اَپَشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","تَتَح شِشْیاسْتَمْ اَپرِچّھَنْ ہے گُرو نَرویَں سْوَپاپینَ وا سْوَپِتْراح پاپینانْدھوجایَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","تَتَح سَ پْرَتْیُدِتَوانْ ایتَسْیَ واسْیَ پِتْروح پاپادْ ایتادرِشوبھُودَ اِتِ نَہِ کِنْتْوَنینَ یَتھیشْوَرَسْیَ کَرْمَّ پْرَکاشْیَتے تَدّھیتوریوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","دِنے تِشْٹھَتِ مَتْپْریرَیِتُح کَرْمَّ مَیا کَرْتَّوْیَں یَدا کِمَپِ کَرْمَّ نَ کْرِیَتے تادرِشِی نِشاگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","اَہَں یاوَتْکالَں جَگَتِ تِشْٹھامِ تاوَتْکالَں جَگَتو جْیوتِحسْوَرُوپوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","اِتْیُکْتّا بھُومَو نِشْٹھِیوَں نِکْشِپْیَ تینَ پَنْکَں کرِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","پَشْچاتْ تَتْپَنْکینَ تَسْیانْدھَسْیَ نیتْرے پْرَلِپْیَ تَمِتْیادِشَتْ گَتْوا شِلوہے رْتھاتْ پْریرِتَنامْنِ سَرَسِ سْناہِ۔ تَتونْدھو گَتْوا تَتْراسْناتْ تَتَح پْرَنَّچَکْشُ رْبھُوتْوا وْیاگھُٹْیاگاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","اَپَرَنْچَ سَمِیپَواسِنو لوکا یے چَ تَں پُورْوَّمَنْدھَمْ اَپَشْیَنْ تے بَکْتُّمْ آرَبھَنْتَ یونْدھَلوکو وَرْتْمَنْیُپَوِشْیابھِکْشَتَ سَ ایوایَں جَنَح کِں نَ بھَوَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","کیچِدَوَدَنْ سَ ایوَ کیچِدَووچَنْ تادرِشو بھَوَتِ کِنْتُ سَ سْوَیَمَبْرَوِیتْ سَ ایواہَں بھَوامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","اَتَایوَ تے پرِچّھَنْ تْوَں کَتھَں درِشْٹِں پاپْتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","تَتَح سووَدَدْ یِیشَنامَکَ ایکو جَنو مَمَ نَیَنے پَنْکینَ پْرَلِپْیَ اِتْیاجْناپَیَتْ شِلوہَکاسارَں گَتْوا تَتْرَ سْناہِ۔ تَتَسْتَتْرَ گَتْوا مَیِ سْناتے درِشْٹِمَہَں لَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","تَدا تے وَدَنْ سَ پُمانْ کُتْرَ؟ تینوکْتَّں ناہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","اَپَرَں تَسْمِنْ پُورْوّانْدھے جَنے پھِرُوشِناں نِکَٹَمْ آنِیتے سَتِ پھِرُوشِنوپِ تَمَپرِچّھَنْ کَتھَں درِشْٹِں پْراپْتوسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","تَتَح سَ کَتھِتَوانْ سَ پَنْکینَ مَمَ نیتْرے لِمْپَتْ پَشْچادْ سْناتْوا درِشْٹِمَلَبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","کِنْتُ یِیشُ رْوِشْرامَوارے کَرْدَّمَں کرِتْوا تَسْیَ نَیَنے پْرَسَنّےکَرودْ اِتِکارَناتْ کَتِپَیَپھِرُوشِنووَدَنْ ");
INSERT INTO sanurd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","سَ پُمانْ اِیشْوَرانَّ یَتَح سَ وِشْرامَوارَں نَ مَنْیَتے۔ تَتونْیے کیچِتْ پْرَتْیَوَدَنْ پاپِی پُمانْ کِمْ ایتادرِشَمْ آشْچَرْیَّں کَرْمَّ کَرْتُّں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","اِتّھَں تیشاں پَرَسْپَرَں بھِنَّواکْیَتْوَمْ اَبھَوَتْ۔ پَشْچاتْ تے پُنَرَپِ تَں پُورْوّانْدھَں مانُشَمْ اَپْراکْشُح یو جَنَسْتَوَ چَکْشُشِی پْرَسَنّے کرِتَوانْ تَسْمِنْ تْوَں کِں وَدَسِ؟ سَ اُکْتَّوانْ سَ بھَوِشَدْوادِی۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","سَ درِشْٹِمْ آپْتَوانْ اِتِ یِہُودِییاسْتَسْیَ درِشْٹِں پْراپْتَسْیَ جَنَسْیَ پِتْرو رْمُکھادْ اَشْرُتْوا نَ پْرَتْیَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","اَتَایوَ تے تاوَپرِچّھَنْ یُوَیو رْیَں پُتْرَں جَنْمانْدھَں وَدَتھَح سَ کِمَیَں؟ تَرْہِیدانِیں کَتھَں دْرَشْٹُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","تَتَسْتَسْیَ پِتَرَو پْرَتْیَووچَتامْ اَیَمْ آوَیوح پُتْرَ آ جَنیرَنْدھَشْچَ تَدَپْیاواں جانِیوَح ");
INSERT INTO sanurd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","کِنْتْوَدھُنا کَتھَں درِشْٹِں پْراپْتَوانْ تَداواں نْ جانِیوَح کوسْیَ چَکْشُشِی پْرَسَنّے کرِتَوانْ تَدَپِ نَ جانِیوَ ایشَ وَیَحپْراپْتَ اینَں پرِچّھَتَ سْوَکَتھاں سْوَیَں وَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","یِہُودِییاناں بھَیاتْ تَسْیَ پِتَرَو واکْیَمِدَمْ اَوَدَتاں یَتَح کوپِ مَنُشْیو یَدِ یِیشُمْ اَبھِشِکْتَں وَدَتِ تَرْہِ سَ بھَجَنَگرِہادْ دُورِیکارِشْیَتے یِہُودِییا اِتِ مَنْتْرَنامْ اَکُرْوَّنْ ");
INSERT INTO sanurd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","اَتَسْتَسْیَ پِتَرَو وْیاہَرَتامْ ایشَ وَیَحپْراپْتَ اینَں پرِچّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","تَدا تے پُنَشْچَ تَں پُورْوّانْدھَمْ آہُویَ وْیاہَرَنْ اِیشْوَرَسْیَ گُنانْ وَدَ ایشَ مَنُشْیَح پاپِیتِ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","تَدا سَ اُکْتَّوانْ سَ پاپِی نَ ویتِ ناہَں جانے پُورْوامَنْدھَ آسَمَہَمْ اَدھُنا پَشْیامِیتِ ماتْرَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","تے پُنَرَپرِچّھَنْ سَ تْواں پْرَتِ کِمَکَروتْ؟ کَتھَں نیتْرے پْرَسَنّے کَروتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","تَتَح سووادِیدْ ایکَکرِتْووکَتھَیَں یُویَں نَ شرِنُتھَ تَرْہِ کُتَح پُنَح شْروتُمْ اِچّھَتھَ؟ یُویَمَپِ کِں تَسْیَ شِشْیا بھَوِتُمْ اِچّھَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","تَدا تے تَں تِرَسْکرِتْیَ وْیاہَرَنْ تْوَں تَسْیَ شِشْیو وَیَں مُوساح شِشْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","مُوساوَکْتْرینیشْوَرو جَگادَ تَجّانِیمَح کِنْتْویشَ کُتْرَتْیَلوکَ اِتِ نَ جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","سووَدَدْ ایشَ مَمَ لوچَنے پْرَسَنّے کَروتْ تَتھاپِ کُتْرَتْیَلوکَ اِتِ یُویَں نَ جانِیتھَ ایتَدْ آشْچَرْیَّں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","اِیشْوَرَح پاپِناں کَتھاں نَ شرِنوتِ کِنْتُ یو جَنَسْتَسْمِنْ بھَکْتِں کرِتْوا تَدِشْٹَکْرِیاں کَروتِ تَسْیَیوَ کَتھاں شرِنوتِ ایتَدْ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","کوپِ مَنُشْیو جَنْمانْدھایَ چَکْشُشِی اَدَداتْ جَگَدارَمْبھادْ ایتادرِشِیں کَتھاں کوپِ کَداپِ ناشرِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","اَسْمادْ ایشَ مَنُشْیو یَدِیشْوَرانّاجایَتَ تَرْہِ کِنْچِدَپِیدرِشَں کَرْمَّ کَرْتُّں ناشَکْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","تے وْیاہَرَنْ تْوَں پاپادْ اَجایَتھاح کِمَسْمانْ تْوَں شِکْشَیَسِ؟ پَشْچاتّے تَں بَہِرَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","تَدَنَنْتَرَں یِہُودِییَیح سَ بَہِرَکْرِیَتَ یِیشُرِتِ وارْتّاں شْرُتْوا تَں ساکْشاتْ پْراپْیَ پرِشْٹَوانْ اِیشْوَرَسْیَ پُتْرے تْوَں وِشْوَسِشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","تَدا سَ پْرَتْیَووچَتْ ہے پْرَبھو سَ کو یَتْ تَسْمِنَّہَں وِشْوَسِمِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","تَتو یِیشُح کَتھِتَوانْ تْوَں تَں درِشْٹَوانْ تْوَیا ساکَں یَح کَتھَں کَتھَیَتِ سَایوَ سَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","تَدا ہے پْرَبھو وِشْوَسِمِیتْیُکْتْوا سَ تَں پْرَنامَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","پَشْچادْ یِیشُح کَتھِتَوانْ نَیَنَہِینا نَیَنانِ پْراپْنُوَنْتِ نَیَنَوَنْتَشْچانْدھا بھَوَنْتِیتْیَبھِپْرایینَ جَگَداہَمْ آگَچّھَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ایتَتْ شْرُتْوا نِکَٹَسْتھاح کَتِپَیاح پھِرُوشِنو وْیاہَرَنْ وَیَمَپِ کِمَنْدھاح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","تَدا یِیشُرَوادِیدْ یَدْیَنْدھا اَبھَوَتَ تَرْہِ پاپانِ ناتِشْٹھَنْ کِنْتُ پَشْیامِیتِ واکْیَوَدَنادْ یُشْماکَں پاپانِ تِشْٹھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ، یو جَنو دْوارینَ نَ پْرَوِشْیَ کیناپْیَنْیینَ میشَگرِہَں پْرَوِشَتِ سَ ایوَ سْتینو دَسْیُشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","یو دْوارینَ پْرَوِشَتِ سَ ایوَ میشَپالَکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","دَووارِکَسْتَسْمَے دْوارَں موچَیَتِ میشَگَنَشْچَ تَسْیَ واکْیَں شرِنوتِ سَ نِجانْ میشانْ سْوَسْوَنامْناہُویَ بَہِح کرِتْوا نَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","تَتھا نِجانْ میشانْ بَہِح کرِتْوا سْوَیَں تیشامْ اَگْرے گَچّھَتِ، تَتو میشاسْتَسْیَ شَبْدَں بُدھْیَنْتے، تَسْماتْ تَسْیَ پَشْچادْ وْرَجَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","کِنْتُ پَرَسْیَ شَبْدَں نَ بُدھْیَنْتے تَسْماتْ تَسْیَ پَشْچادْ وْرَجِشْیَنْتِ وَرَں تَسْیَ سَمِیپاتْ پَلایِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","یِیشُسْتیبھْیَ اِماں درِشْٹانْتَکَتھامْ اَکَتھَیَتْ کِنْتُ تینَ کَتھِتَکَتھایاسْتاتْپَرْیَّں تے نابُدھْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","اَتو یِیشُح پُنَرَکَتھَیَتْ، یُشْماناہَں یَتھارْتھَتَرَں وْیاہَرامِ، میشَگرِہَسْیَ دْوارَمْ اَہَمیوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","مَیا نَ پْرَوِشْیَ یَ آگَچّھَنْ تے سْتینا دَسْیَوَشْچَ کِنْتُ میشاسْتیشاں کَتھا ناشرِنْوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","اَہَمیوَ دْوارَسْوَرُوپَح، مَیا یَح کَشْچِتَ پْرَوِشَتِ سَ رَکْشاں پْراپْسْیَتِ تَتھا بَہِرَنْتَشْچَ گَمَناگَمَنے کرِتْوا چَرَنَسْتھانَں پْراپْسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","یو جَنَسْتینَح سَ کیوَلَں سْتَینْیَبَدھَوِناشانْ کَرْتُّمیوَ سَمایاتِ کِنْتْوَہَمْ آیُ رْداتُمْ اَرْتھاتْ باہُولْیینَ تَدیوَ داتُمْ آگَچّھَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","اَہَمیوَ سَتْیَمیشَپالَکو یَسْتُ سَتْیو میشَپالَکَح سَ میشارْتھَں پْرانَتْیاگَں کَروتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","کِنْتُ یو جَنو میشَپالَکو نَ، اَرْتھادْ یَسْیَ میشا نِجا نَ بھَوَنْتِ، یَ ایتادرِشو وَیتَنِکَح سَ ورِکَمْ آگَچّھَنْتَں درِشْٹْوا میجَوْرَجَں وِہایَ پَلایَتے، تَسْمادْ ورِکَسْتَں وْرَجَں دھرِتْوا وِکِرَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","وَیتَنِکَح پَلایَتے یَتَح سَ ویتَنارْتھِی میشارْتھَں نَ چِنْتَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","اَہَمیوَ سَتْیو میشَپالَکَح، پِتا ماں یَتھا جاناتِ، اَہَنْچَ یَتھا پِتَرَں جانامِ، ");
INSERT INTO sanurd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","تَتھا نِجانْ میشانَپِ جانامِ، میشاشْچَ ماں جانانْتِ، اَہَنْچَ میشارْتھَں پْرانَتْیاگَں کَرومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","اَپَرَنْچَ ایتَدْ گرِہِییَ میشیبھْیو بھِنّا اَپِ میشا مَمَ سَنْتِ تے سَکَلا آنَیِتَوْیاح؛ تے مَمَ شَبْدَں شْروشْیَنْتِ تَتَ ایکو وْرَجَ ایکو رَکْشَکو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","پْرانانَہَں تْیَکْتْوا پُنَح پْرانانْ گْرَہِیشْیامِ، تَسْماتْ پِتا مَیِ سْنیہَں کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","کَشْچِجَّنو مَمَ پْرانانْ ہَنْتُں نَ شَکْنوتِ کِنْتُ سْوَیَں تانْ سَمَرْپَیامِ تانْ سَمَرْپَیِتُں پُنَرْگْرَہِیتُنْچَ مَمَ شَکْتِراسْتے بھارَمِمَں سْوَپِتُح سَکاشاتْ پْراپْتوہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","اَسْمادُپَدیشاتْ پُنَشْچَ یِہُودِییاناں مَدھْیے بھِنَّواکْیَتا جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","تَتو بَہَوو وْیاہَرَنْ ایشَ بھُوتَگْرَسْتَ اُنْمَتَّشْچَ، کُتَ ایتَسْیَ کَتھاں شرِنُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","کیچِدْ اَوَدَنْ ایتَسْیَ کَتھا بھُوتَگْرَسْتَسْیَ کَتھاوَنَّ بھَوَنْتِ، بھُوتَح کِمْ اَنْدھایَ چَکْشُشِی داتُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","شِیتَکالے یِرُوشالَمِ مَنْدِروتْسَرْگَپَرْوَّنْیُپَسْتھِتی ");
INSERT INTO sanurd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","یِیشُح سُلیمانو نِحسارینَ گَمَناگَمَنے کَروتِ، ");
INSERT INTO sanurd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ایتَسْمِنْ سَمَیے یِہُودِییاسْتَں ویشْٹَیِتْوا وْیاہَرَنْ کَتِ کالانْ اَسْماکَں وِچِکِتْساں سْتھاپَیِشْیامِ؟ یَدْیَبھِشِکْتو بھَوَتِ تَرْہِ تَتْ سْپَشْٹَں وَدَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","تَدا یِیشُح پْرَتْیَوَدَدْ اَہَمْ اَچَکَتھَں کِنْتُ یُویَں نَ پْرَتِیتھَ، نِجَپِتُ رْنامْنا یاں یاں کْرِیاں کَرومِ سا کْرِیَیوَ مَمَ ساکْشِسْوَرُوپا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","کِنْتْوَہَں پُورْوَّمَکَتھَیَں یُویَں مَمَ میشا نَ بھَوَتھَ، کارَنادَسْمانْ نَ وِشْوَسِتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","مَمَ میشا مَمَ شَبْدَں شرِنْوَنْتِ تانَہَں جانامِ تے چَ مَمَ پَشْچادْ گَچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","اَہَں تیبھْیونَنْتایُ رْدَدامِ، تے کَداپِ نَ نَںکْشْیَنْتِ کوپِ مَمَ کَراتْ تانْ ہَرْتُّں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","یو مَمَ پِتا تانْ مَہْیَں دَتَّوانْ سَ سَرْوَّسْماتْ مَہانْ، کوپِ مَمَ پِتُح کَراتْ تانْ ہَرْتُّں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","اَہَں پِتا چَ دْوَیوریکَتْوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","تَتو یِہُودِییاح پُنَرَپِ تَں ہَنْتُں پاشانانْ اُدَتولَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","یِیشُح کَتھِتَوانْ پِتُح سَکاشادْ بَہُونْیُتَّمَکَرْمّانِ یُشْماکَں پْراکاشَیَں تیشاں کَسْیَ کَرْمَّنَح کارَنانْ ماں پاشانَیراہَنْتُمْ اُدْیَتاح سْتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","یِہُودِییاح پْرَتْیَوَدَنْ پْرَشَسْتَکَرْمَّہیتو رْنَ کِنْتُ تْوَں مانُشَح سْوَمِیشْوَرَمْ اُکْتْویشْوَرَں نِنْدَسِ کارَنادَسْماتْ تْواں پاشانَیرْہَنْمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","تَدا یِیشُح پْرَتْیُکْتَوانْ مَیا کَتھِتَں یُویَمْ اِیشْوَرا ایتَدْوَچَنَں یُشْماکَں شاسْتْرے لِکھِتَں ناسْتِ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","تَسْمادْ ییشامْ اُدّیشے اِیشْوَرَسْیَ کَتھا کَتھِتا تے یَدِیشْوَرَگَنا اُچْیَنْتے دھَرْمَّگْرَنْتھَسْیاپْیَنْیَتھا بھَوِتُں نَ شَکْیَں، ");
INSERT INTO sanurd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","تَرْہْیاہَمْ اِیشْوَرَسْیَ پُتْرَ اِتِ واکْیَسْیَ کَتھَناتْ یُویَں پِتْرابھِشِکْتَں جَگَتِ پْریرِتَنْچَ پُماںسَں کَتھَمْ اِیشْوَرَنِنْدَکَں وادَیَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","یَدْیَہَں پِتُح کَرْمَّ نَ کَرومِ تَرْہِ ماں نَ پْرَتِیتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","کِنْتُ یَدِ کَرومِ تَرْہِ مَیِ یُشْمابھِح پْرَتْیَیے نَ کرِتےپِ کارْیّے پْرَتْیَیَح کْرِیَتاں، تَتو مَیِ پِتاسْتِیتِ پِتَرْیَّہَمْ اَسْمِیتِ چَ کْشاتْوا وِشْوَسِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","تَدا تے پُنَرَپِ تَں دھَرْتُّمْ اَچیشْٹَنْتَ کِنْتُ سَ تیشاں کَریبھْیو نِسْتِیرْیَّ ");
INSERT INTO sanurd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","پُنَ رْیَرْدَّنْ اَدْیاسْتَٹے یَتْرَ پُرْوَّں یوہَنْ اَمَجَّیَتْ تَتْراگَتْیَ نْیَوَسَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","تَتو بَہَوو لوکاسْتَتْسَمِیپَمْ آگَتْیَ وْیاہَرَنْ یوہَنْ کِمَپْیاشْچَرْیَّں کَرْمَّ ناکَروتْ کِنْتْوَسْمِنْ مَنُشْیے یا یَح کَتھا اَکَتھَیَتْ تاح سَرْوّاح سَتْیاح؛ ");
INSERT INTO sanurd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","تَتْرَ چَ بَہَوو لوکاسْتَسْمِنْ وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","اَنَنْتَرَں مَرِیَمْ تَسْیا بھَگِنِی مَرْتھا چَ یَسْمِنْ وَیتھَنِییاگْرامے وَسَتَسْتَسْمِنْ گْرامے اِلِیاسَرْ ناما پِیڈِتَ ایکَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","یا مَرِیَمْ پْرَبھُں سُگَنْدھِتیلَینَ مَرْدَّیِتْوا سْوَکیشَیسْتَسْیَ چَرَنَو سَمَمارْجَتْ تَسْیا بھْراتا سَ اِلِیاسَرْ روگِی۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","اَپَرَنْچَ ہے پْرَبھو بھَوانْ یَسْمِنْ پْرِییَتے سَ ایوَ پِیڈِتوسْتِیتِ کَتھاں کَتھَیِتْوا تَسْیَ بھَگِنْیَو پْریشِتَوَتْیَو۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","تَدا یِیشُرِماں وارْتّاں شْرُتْواکَتھَیَتَ پِیڈییَں مَرَنارْتھَں نَ کِنْتْوِیشْوَرَسْیَ مَہِمارْتھَمْ اِیشْوَرَپُتْرَسْیَ مَہِمَپْرَکاشارْتھَنْچَ جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","یِیشُ رْیَدْیَپِمَرْتھایاں تَدْبھَگِنْیامْ اِلِیاسَرِ چاپْرِییَتَ، ");
INSERT INTO sanurd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","تَتھاپِ اِلِیاسَرَح پِیڈایاح کَتھَں شْرُتْوا یَتْرَ آسِیتْ تَتْرَیوَ دِنَدْوَیَمَتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","تَتَح پَرَمْ سَ شِشْیانَکَتھَیَدْ وَیَں پُنَ رْیِہُودِییَپْرَدیشَں یامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","تَتَسْتے پْرَتْیَوَدَنْ، ہے گُرو سْوَلْپَدِنانِ گَتانِ یِہُودِییاسْتْواں پاشانَے رْہَنْتُمْ اُدْیَتاسْتَتھاپِ کِں پُنَسْتَتْرَ یاسْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","یِیشُح پْرَتْیَوَدَتْ، ایکَسْمِنْ دِنے کِں دْوادَشَگھَٹِکا نَ بھَوَنْتِ؟ کوپِ دِوا گَچّھَنْ نَ سْکھَلَتِ یَتَح سَ ایتَجَّگَتو دِیپْتِں پْراپْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","کِنْتُ راتْرَو گَچّھَنْ سْکھَلَتِ یَتو ہیتوسْتَتْرَ دِیپْتِ رْناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","اِماں کَتھاں کَتھَیِتْوا سَ تانَوَدَدْ، اَسْماکَں بَنْدھُح اِلِیاسَرْ نِدْرِتوبھُودْ اِدانِیں تَں نِدْراتو جاگَرَیِتُں گَچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","یِیشُ رْمرِتَو کَتھامِماں کَتھِتَوانْ کِنْتُ وِشْرامارْتھَں نِدْرایاں کَتھِتَوانْ اِتِ جْناتْوا شِشْیا اَکَتھَیَنْ، ");
INSERT INTO sanurd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ہے گُرو سَ یَدِ نِدْراتِ تَرْہِ بھَدْرَمیوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","تَدا یِیشُح سْپَشْٹَں تانْ وْیاہَرَتْ، اِلِیاسَرْ اَمْرِیَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","کِنْتُ یُویَں یَتھا پْرَتِیتھَ تَدَرْتھَمَہَں تَتْرَ نَ سْتھِتَوانْ اِتْیَسْمادْ یُشْمَنِّمِتَّمْ آہْلادِتوہَں، تَتھاپِ تَسْیَ سَمِیپے یامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","تَدا تھوما یَں دِدُمَں وَدَنْتِ سَ سَنْگِنَح شِشْیانْ اَوَدَدْ وَیَمَپِ گَتْوا تینَ سارْدّھَں مْرِیامَہَے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","یِیشُسْتَتْروپَسْتھایَ اِلِیاسَرَح شْمَشانے سْتھاپَناتْ چَتْوارِ دِنانِ گَتانِیتِ وارْتّاں شْرُتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","وَیتھَنِییا یِرُوشالَمَح سَمِیپَسْتھا کْروشَیکَماتْرانْتَرِتا؛ ");
INSERT INTO sanurd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","تَسْمادْ بَہَوو یِہُودِییا مَرْتھاں مَرِیَمَنْچَ بھْیاترِشوکاپَنّاں سانْتْوَیِتُں تَیوح سَمِیپَمْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","مَرْتھا یِیشوراگَمَنَوارْتاں شْرُتْوَیوَ تَں ساکْشادْ اَکَروتْ کِنْتُ مَرِیَمْ گیہَ اُپَوِشْیَ سْتھِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","تَدا مَرْتھا یِیشُمَوادَتْ، ہے پْرَبھو یَدِ بھَوانْ اَتْراسْتھاسْیَتْ تَرْہِ مَمَ بھْراتا نامَرِشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","کِنْتْوِدانِیمَپِ یَدْ اِیشْوَرے پْرارْتھَیِشْیَتے اِیشْوَرَسْتَدْ داسْیَتِیتِ جانےہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","یِیشُرَوادِیتْ تَوَ بھْراتا سَمُتّھاسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","مَرْتھا وْیاہَرَتْ شیشَدِوَسے سَ اُتّھانَسَمَیے پْروتّھاسْیَتِیتِ جانےہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","تَدا یِیشُح کَتھِتَوانْ اَہَمیوَ اُتّھاپَیِتا جِیوَیِتا چَ یَح کَشْچَنَ مَیِ وِشْوَسِتِ سَ مرِتْواپِ جِیوِشْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","یَح کَشْچَنَ چَ جِیوَنْ مَیِ وِشْوَسِتِ سَ کَداپِ نَ مَرِشْیَتِ، اَسْیاں کَتھایاں کِں وِشْوَسِشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ساوَدَتْ پْرَبھو یَسْیاوَتَرَناپیکْشاسْتِ بھَوانْ سَایوابھِشِکْتَّ اِیشْوَرَپُتْرَ اِتِ وِشْوَسِمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","اِتِ کَتھاں کَتھَیِتْوا سا گَتْوا سْواں بھَگِنِیں مَرِیَمَں گُپْتَماہُویَ وْیاہَرَتْ گُرُرُپَتِشْٹھَتِ تْواماہُویَتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","کَتھامِماں شْرُتْوا سا تُورْنَمْ اُتّھایَ تَسْیَ سَمِیپَمْ اَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","یِیشُ رْگْرامَمَدھْیَں نَ پْرَوِشْیَ یَتْرَ مَرْتھا تَں ساکْشادْ اَکَروتْ تَتْرَ سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","یے یِہُودِییا مَرِیَما ساکَں گرِہے تِشْٹھَنْتَسْتامْ اَسانْتْوَیَنَ تے تاں کْشِپْرَمْ اُتّھایَ گَچّھَنْتِں وِلوکْیَ وْیاہَرَنْ، سَ شْمَشانے رودِتُں یاتِ، اِتْیُکْتْوا تے تَسْیاح پَشْچادْ اَگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","یَتْرَ یِیشُرَتِشْٹھَتْ تَتْرَ مَرِیَمْ اُپَسْتھایَ تَں درِشْٹْوا تَسْیَ چَرَنَیوح پَتِتْوا وْیاہَرَتْ ہے پْرَبھو یَدِ بھَوانْ اَتْراسْتھاسْیَتْ تَرْہِ مَمَ بھْراتا نامَرِشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","یِیشُسْتاں تَسْیاح سَنْگِنو یِہُودِییاںشْچَ رُدَتو وِلوکْیَ شوکارْتَّح سَنْ دِیرْگھَں نِشْوَسْیَ کَتھِتَوانْ تَں کُتْراسْتھاپَیَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","تے وْیاہَرَنْ، ہے پْرَبھو بھَوانْ آگَتْیَ پَشْیَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","یِیشُنا کْرَنْدِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","اَتَایوَ یِہُودِییا اَوَدَنْ، پَشْیَتایَں تَسْمِنْ کِدرِگْ اَپْرِیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","تیشاں کیچِدْ اَوَدَنْ یونْدھایَ چَکْشُشِی دَتَّوانْ سَ کِمْ اَسْیَ مرِتْیُں نِوارَیِتُں ناشَکْنوتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","تَتو یِیشُح پُنَرَنْتَرْدِیرْگھَں نِشْوَسْیَ شْمَشانانْتِکَمْ اَگَچّھَتْ۔ تَتْ شْمَشانَمْ ایکَں گَہْوَرَں تَنْمُکھے پاشانَ ایکَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","تَدا یِیشُرَوَدَدْ اینَں پاشانَمْ اَپَسارَیَتَ، تَتَح پْرَمِیتَسْیَ بھَگِنِی مَرْتھاوَدَتْ پْرَبھو، اَدھُنا تَتْرَ دُرْگَنْدھو جاتَح، یَتودْیَ چَتْوارِ دِنانِ شْمَشانے سَ تِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","تَدا یِیشُرَوادِیتْ، یَدِ وِشْوَسِشِ تَرْہِیشْوَرَسْیَ مَہِمَپْرَکاشَں دْرَکْشْیَسِ کَتھامِماں کِں تُبھْیَں ناکَتھَیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","تَدا مرِتَسْیَ شْمَشاناتْ پاشانوپَسارِتے یِیشُرُورْدْوَّں پَشْیَنْ اَکَتھَیَتْ، ہے پِتَ رْمَمَ نیویسَنَمْ اَشرِنوح کارَنادَسْماتْ تْواں دھَنْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","تْوَں سَتَتَں شرِنوشِ تَدَپْیَہَں جانامِ، کِنْتُ تْوَں ماں یَتْ پْرَیرَیَسْتَدْ یَتھاسْمِنْ سْتھانے سْتھِتا لوکا وِشْوَسَنْتِ تَدَرْتھَمْ اِدَں واکْیَں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","اِماں کَتھاں کَتھَیِتْوا سَ پْروچَّیراہْوَیَتْ، ہے اِلِیاسَرْ بَہِراگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","تَتَح سَ پْرَمِیتَح شْمَشانَوَسْتْرَے رْبَدّھَہَسْتَپادو گاتْرَمارْجَنَواسَسا بَدّھَمُکھَشْچَ بَہِراگَچّھَتْ۔ یِیشُرُدِتَوانْ بَنْدھَنانِ موچَیِتْوا تْیَجَتَینَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","مَرِیَمَح سَمِیپَمْ آگَتا یے یِہُودِییَلوکاسْتَدا یِیشوریتَتْ کَرْمّاپَشْیَنْ تیشاں بَہَوو وْیَشْوَسَنْ، ");
INSERT INTO sanurd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","کِنْتُ کیچِدَنْیے پھِرُوشِناں سَمِیپَں گَتْوا یِیشوریتَسْیَ کَرْمَّنو وارْتّامْ اَوَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","تَتَح پَرَں پْرَدھانَیاجَکاح پھِرُوشِناشْچَ سَبھاں کرِتْوا وْیاہَرَنْ وَیَں کِں کُرْمَّح؟ ایشَ مانَوو بَہُونْیاشْچَرْیَّکَرْمّانِ کَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","یَدِیدرِشَں کَرْمَّ کَرْتُّں نَ وارَیامَسْتَرْہِ سَرْوّے لوکاسْتَسْمِنْ وِشْوَسِشْیَنْتِ رومِلوکاشْچاگَتْیاسْماکَمْ اَنَیا راجَدھانْیا سارْدّھَں راجْیَمْ آچھیتْسْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","تَدا تیشاں کِیَپھاناما یَسْتَسْمِنْ وَتْسَرے مَہایاجَکَپَدے نْیَیُجْیَتَ سَ پْرَتْیَوَدَدْ یُویَں کِمَپِ نَ جانِیتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","سَمَگْرَدیشَسْیَ وِناشَتوپِ سَرْوَّلوکارْتھَمْ ایکَسْیَ جَنَسْیَ مَرَنَمْ اَسْماکَں مَنْگَلَہیتُکَمْ ایتَسْیَ وِویچَنامَپِ نَ کُرُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ایتاں کَتھاں سَ نِجَبُدّھیا وْیاہَرَدْ اِتِ نَ، ");
INSERT INTO sanurd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","کِنْتُ یِیشُوسْتَدّیشِییاناں کارَناتْ پْرانانْ تْیَکْشْیَتِ، دِشِ دِشِ وِکِیرْنانْ اِیشْوَرَسْیَ سَنْتانانْ سَںگرِہْیَیکَجاتِں کَرِشْیَتِ چَ، تَسْمِنْ وَتْسَرے کِیَپھا مَہایاجَکَتْوَپَدے نِیُکْتَح سَنْ اِدَں بھَوِشْیَدْواکْیَں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","تَدِّنَمارَبھْیَ تے کَتھَں تَں ہَنْتُں شَکْنُوَنْتِیتِ مَنْتْرَناں کَرْتُّں پْراریبھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","اَتَایوَ یِہُودِییاناں مَدھْیے یِیشُح سَپْرَکاشَں گَمَناگَمَنے اَکرِتْوا تَسْمادْ گَتْوا پْرانْتَرَسْیَ سَمِیپَسْتھایِپْرَدیشَسْییپھْرایِمْ نامْنِ نَگَرے شِشْیَیح ساکَں کالَں یاپَیِتُں پْراریبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","اَنَنْتَرَں یِہُودِییاناں نِسْتاروتْسَوے نِکَٹَوَرْتِّنِ سَتِ تَدُتْسَواتْ پُورْوَّں سْوانْ شُچِینْ کَرْتُّں بَہَوو جَنا گْرامیبھْیو یِرُوشالَمْ نَگَرَمْ آگَچّھَنْ، ");
INSERT INTO sanurd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","یِیشورَنْویشَنَں کرِتْوا مَنْدِرے دَنْڈایَماناح سَنْتَح پَرَسْپَرَں وْیاہَرَنْ، یُشْماکَں کِیدرِشو بودھو جایَتے؟ سَ کِمْ اُتْسَوےسْمِنْ اَتْراگَمِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","سَ چَ کُتْراسْتِ یَدْییتَتْ کَشْچِدْ ویتِّ تَرْہِ دَرْشَیَتُ پْرَدھانَیاجَکاح پھِرُوشِنَشْچَ تَں دھَرْتُّں پُورْوَّمْ اِمامْ آجْناں پْراچارَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","نِسْتاروتْسَواتْ پُورْوَّں دِنَشَٹْکے سْتھِتے یِیشُ رْیَں پْرَمِیتَمْ اِلِیاسَرَں شْمَشانادْ اُدَسْتھاپَرَتْ تَسْیَ نِواسَسْتھانَں بَیتھَنِیاگْرامَمْ آگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","تَتْرَ تَدَرْتھَں رَجَنْیاں بھوجْیے کرِتے مَرْتھا پَرْیَّویشَیَدْ اِلِیاسَرْ چَ تَسْیَ سَنْگِبھِح سارْدّھَں بھوجَناسَنَ اُپاوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","تَدا مَرِیَمْ اَرْدّھَسیٹَکَں بَہُمُولْیَں جَٹاماںسِییَں تَیلَمْ آنِییَ یِیشوشْچَرَنَیو رْمَرْدَّیِتْوا نِجَکیشَ رْمارْشْٹُمْ آرَبھَتَ؛ تَدا تَیلَسْیَ پَرِمَلینَ گرِہَمْ آمودِتَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","یَح شِمونَح پُتْرَ رِشْکَرِیوتِییو یِہُوداناما یِیشُں پَرَکَریشُ سَمَرْپَیِشْیَتِ سَ شِشْیَسْتَدا کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ایتَتَّیلَں تْرِبھِح شَتَے رْمُدْراپَدَے رْوِکْرِیتَں سَدْ دَرِدْریبھْیَح کُتو نادِییَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","سَ دَرِدْرَلوکارْتھَمْ اَچِنْتَیَدْ اِتِ نَ، کِنْتُ سَ چَورَ ایوَں تَنِّکَٹے مُدْراسَمْپُٹَکَسْتھِتْیا تَنْمَدھْیے یَدَتِشْٹھَتْ تَدَپاہَرَتْ تَسْماتْ کارَنادْ اِماں کَتھامَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","تَدا یِیشُرَکَتھَیَدْ ایناں ما وارَیَ سا مَمَ شْمَشانَسْتھاپَنَدِنارْتھَں تَدَرَکْشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","دَرِدْرا یُشْماکَں سَنِّدھَو سَرْوَّدا تِشْٹھَنْتِ کِنْتْوَہَں سَرْوَّدا یُشْماکَں سَنِّدھَو نَ تِشْٹھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","تَتَح پَرَں یِیشُسْتَتْراسْتِیتِ وارْتّاں شْرُتْوا بَہَوو یِہُودِییاسْتَں شْمَشانادُتّھاپِتَمْ اِلِیاسَرَنْچَ دْرَشْٹُں تَتْ سْتھانَمْ آگَچّھَنَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","تَدا پْرَدھانَیاجَکاسْتَمْ اِلِیاسَرَمَپِ سَںہَرْتُّمْ اَمَنْتْرَیَنْ ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","یَتَسْتینَ بَہَوو یِہُودِییا گَتْوا یِیشَو وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","اَنَنْتَرَں یِیشُ رْیِرُوشالَمْ نَگَرَمْ آگَچّھَتِیتِ وارْتّاں شْرُتْوا پَرےہَنِ اُتْسَواگَتا بَہَوو لوکاح ");
INSERT INTO sanurd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","کھَرْجُّورَپَتْرادْیانِییَ تَں ساکْشاتْ کَرْتُّں بَہِراگَتْیَ جَیَ جَییتِ واچَں پْروچَّے رْوَکْتُمْ آرَبھَنْتَ، اِسْراییلو یو راجا پَرَمیشْوَرَسْیَ نامْناگَچّھَتِ سَ دھَنْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","تَدا \"ہے سِیونَح کَنْیے ما بھَیشِیح پَشْیایَں تَوَ راجا گَرْدَّبھَشاوَکَمْ آرُہْیاگَچّھَتِ\" ");
INSERT INTO sanurd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","اِتِ شاسْتْرِییَوَچَنانُسارینَ یِیشُریکَں یُوَگَرْدَّبھَں پْراپْیَ تَدُپَرْیّاروہَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","اَسْیاح گھَٹَنایاسْتاتْپَرْیَّں شِشْیاح پْرَتھَمَں نابُدھْیَنْتَ، کِنْتُ یِیشَو مَہِمانَں پْراپْتے سَتِ واکْیَمِدَں تَسْمِنَ اَکَتھْیَتَ لوکاشْچَ تَمْپْرَتِیتّھَمْ اَکُرْوَّنْ اِتِ تے سْمرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","سَ اِلِیاسَرَں شْمَشانادْ آگَنْتُمْ آہْوَتَوانْ شْمَشانانْچَ اُدَسْتھاپَیَدْ یے یے لوکاسْتَتْکَرْمْیَ ساکْشادْ اَپَشْیَنْ تے پْرَمانَں داتُمْ آرَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","سَ ایتادرِشَمْ اَدْبھُتَں کَرْمَّکَروتْ تَسْیَ جَنَشْرُتے رْلوکاسْتَں ساکْشاتْ کَرْتُّمْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","تَتَح پھِرُوشِنَح پَرَسْپَرَں وَکْتُمْ آرَبھَنْتَ یُشْماکَں سَرْوّاشْچیشْٹا ورِتھا جاتاح، اِتِ کِں یُویَں نَ بُدھْیَدھْوے؟ پَشْیَتَ سَرْوّے لوکاسْتَسْیَ پَشْچادْوَرْتِّنوبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","بھَجَنَں کَرْتُّمْ اُتْسَواگَتاناں لوکاناں کَتِپَیا جَنا اَنْیَدیشِییا آسَنْ ، ");
INSERT INTO sanurd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","تے گالِیلِییَبَیتْسَیدانِواسِنَح پھِلِپَسْیَ سَمِیپَمْ آگَتْیَ وْیاہَرَنْ ہے مَہیچّھَ وَیَں یِیشُں دْرَشْٹُمْ اِچّھامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","تَتَح پھِلِپو گَتْوا آنْدْرِیَمْ اَوَدَتْ پَشْچادْ آنْدْرِیَپھِلِپَو یِیشَوے وارْتّامْ اَکَتھَیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","تَدا یِیشُح پْرَتْیُدِتَوانْ مانَوَسُتَسْیَ مَہِمَپْراپْتِسَمَیَ اُپَسْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ، دھانْیَبِیجَں مرِتِّکایاں پَتِتْوا یَدِ نَ مرِیَتے تَرْہْییکاکِی تِشْٹھَتِ کِنْتُ یَدِ مرِیَتے تَرْہِ بَہُگُنَں پھَلَں پھَلَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","یو جَنےा نِجَپْرانانْ پْرِیانْ جاناتِ سَ تانْ ہارَیِشْیَتِ کِنْتُ یےा جَنَ اِہَلوکے نِجَپْرانانْ اَپْرِیانْ جاناتِ سےाنَنْتایُح پْراپْتُں تانْ رَکْشِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","کَشْچِدْ یَدِ مَمَ سیوَکو بھَوِتُں وانْچھَتِ تَرْہِ سَ مَمَ پَشْچادْگامِی بھَوَتُ، تَسْمادْ اَہَں یَتْرَ تِشْٹھامِ مَمَ سیوَکےाپِ تَتْرَ سْتھاسْیَتِ؛ یو جَنو ماں سیوَتے مَمَ پِتاپِ تَں سَمَّںسْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","سامْپْرَتَں مَمَ پْرانا وْیاکُلا بھَوَنْتِ، تَسْمادْ ہے پِتَرَ ایتَسْماتْ سَمَیانْ ماں رَکْشَ، اِتْیَہَں کِں پْرارْتھَیِشْیے؟ کِنْتْوَہَمْ ایتَتْسَمَیارْتھَمْ اَوَتِیرْنَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ہے پِتَ: سْوَنامْنو مَہِمانَں پْرَکاشَیَ؛ تَنَیوَ سْوَنامْنو مَہِمانَمْ اَہَں پْراکاشَیَں پُنَرَپِ پْرَکاشَیِشْیامِ، ایشا گَگَنِییا وانِی تَسْمِنْ سَمَیےجایَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","تَچْشْرُتْوا سَمِیپَسْتھَلوکاناں کیچِدْ اَوَدَنْ میگھوگَرْجِیتْ، کیچِدْ اَوَدَنْ سْوَرْگِییَدُوتونینَ سَہَ کَتھامَچَکَتھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","تَدا یِیشُح پْرَتْیَوادِیتْ، مَدَرْتھَں شَبْدویَں نابھُوتْ یُشْمَدَرْتھَمیوابھُوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","اَدھُنا جَگَتوسْیَ وِچارَ: سَمْپَتْسْیَتے، اَدھُناسْیَ جَگَتَ: پَتِی راجْیاتْ چْیوشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","یَدْیَاِی پرِتھِوْیا اُورْدْوّے پْروتّھاپِتوسْمِ تَرْہِ سَرْوّانْ مانَوانْ سْوَسَمِیپَمْ آکَرْشِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","کَتھَں تَسْیَ مرِتِ رْبھَوِشْیَتِ، ایتَدْ بودھَیِتُں سَ اِماں کَتھامْ اَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","تَدا لوکا اَکَتھَیَنْ سوبھِشِکْتَح سَرْوَّدا تِشْٹھَتِیتِ وْیَوَسْتھاگْرَنْتھے شْرُتَمْ اَسْمابھِح، تَرْہِ مَنُشْیَپُتْرَح پْروتّھاپِتو بھَوِشْیَتِیتِ واکْیَں کَتھَں وَدَسِ؟ مَنُشْیَپُتْرویَں کَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","تَدا یِیشُرَکَتھایَدْ یُشْمابھِح سارْدّھَمْ اَلْپَدِنانِ جْیوتِراسْتے، یَتھا یُشْمانْ اَنْدھَکارو ناچّھادَیَتِ تَدَرْتھَں یاوَتْکالَں یُشْمابھِح سارْدّھَں جْیوتِسْتِشْٹھَتِ تاوَتْکالَں گَچّھَتَ؛ یو جَنونْدھَکارے گَچّھَتِ سَ کُتْرَ یاتِیتِ نَ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","اَتَایوَ یاوَتْکالَں یُشْماکَں نِکَٹے جْیوتِراسْتے تاوَتْکالَں جْیوتِیرُوپَسَنْتانا بھَوِتُں جْیوتِشِ وِشْوَسِتَ؛ اِماں کَتھاں کَتھَیِتْوا یِیشُح پْرَسْتھایَ تیبھْیَح سْوَں گُپْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","یَدْیَپِ یِیشُسْتیشاں سَمَکْشَمْ ایتاوَداشْچَرْیَّکَرْمّانِ کرِتَوانْ تَتھاپِ تے تَسْمِنْ نَ وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","اَتَایوَ کَح پْرَتْییتِ سُسَںوادَں پَریشاسْمَتْ پْرَچارِتَں؟ پْرَکاشَتے پَریشَسْیَ ہَسْتَح کَسْیَ چَ سَنِّدھَو؟ یِشَیِیَبھَوِشْیَدْوادِنا یَدیتَدْ واکْیَمُکْتَں تَتْ سَپھَلَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","تے پْرَتْییتُں ناشَنْکُوَنْ تَسْمِنْ یِشَیِیَبھَوِشْیَدْوادِ پُنَرَوادِیدْ، ");
INSERT INTO sanurd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","یَدا، \"تے نَیَنَے رْنَ پَشْیَنْتِ بُدّھِبھِشْچَ نَ بُدھْیَنْتے تَے رْمَنَحسُ پَرِوَرْتِّتیشُ چَ تانَہَں یَتھا سْوَسْتھانْ نَ کَرومِ تَتھا سَ تیشاں لوچَنانْیَنْدھانِ کرِتْوا تیشامَنْتَحکَرَنانِ گاڈھانِ کَرِشْیَتِ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","یِشَیِیو یَدا یِیشو رْمَہِمانَں وِلوکْیَ تَسْمِنْ کَتھامَکَتھَیَتْ تَدا بھَوِشْیَدْواکْیَمْ اِیدرِشَں پْرَکاشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","تَتھاپْیَدھِپَتِناں بَہَوَسْتَسْمِنْ پْرَتْیایَنْ۔ کِنْتُ پھِرُوشِنَسْتانْ بھَجَنَگرِہادْ دُورِیکُرْوَّنْتِیتِ بھَیاتْ تے تَں نَ سْوِیکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","یَتَ اِیشْوَرَسْیَ پْرَشَںساتو مانَواناں پْرَشَںسایاں تےپْرِیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","تَدا یِیشُرُچَّیحکارَمْ اَکَتھَیَدْ یو جَنو مَیِ وِشْوَسِتِ سَ کیوَلے مَیِ وِشْوَسِتِیتِ نَ، سَ مَتْپْریرَکےپِ وِشْوَسِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","یو جَنو ماں پَشْیَتِ سَ مَتْپْریرَکَمَپِ پَشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","یو جَنو ماں پْرَتْییتِ سَ یَتھانْدھَکارے نَ تِشْٹھَتِ تَدَرْتھَمْ اَہَں جْیوتِحسْوَرُوپو بھُوتْوا جَگَتْیَسْمِنْ اَوَتِیرْنَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","مَمَ کَتھاں شْرُتْوا یَدِ کَشْچِنْ نَ وِشْوَسِتِ تَرْہِ تَمَہَں دوشِنَں نَ کَرومِ، یَتو ہیتو رْجَگَتو جَناناں دوشانْ نِشْچِتانْ کَرْتُّں ناگَتْیَ تانْ پَرِچاتُمْ آگَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","یَح کَشْچِنْ ماں نَ شْرَدّھایَ مَمَ کَتھَں نَ گرِہْلاتِ، اَنْیَسْتَں دوشِنَں کَرِشْیَتِ وَسْتُتَسْتُ یاں کَتھامَہَمْ اَچَکَتھَں سا کَتھا چَرَمےنْہِ تَں دوشِنَں کَرِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","یَتو ہیتورَہَں سْوَتَح کِمَپِ نَ کَتھَیامِ، کِں کِں مَیا کَتھَیِتَوْیَں کِں سَمُپَدیشْٹَوْیَنْچَ اِتِ مَتْپْریرَیِتا پِتا ماماجْناپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","تَسْیَ ساجْنا اَنَنْتایُرِتْیَہَں جانامِ، اَتَایواہَں یَتْ کَتھَیامِ تَتْ پِتا یَتھاجْناپَیَتْ تَتھَیوَ کَتھَیامْیَہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","نِسْتاروتْسَوَسْیَ کِنْچِتْکالاتْ پُورْوَّں پرِتھِوْیاح پِتُح سَمِیپَگَمَنَسْیَ سَمَیَح سَنِّکَرْشوبھُودْ اِتِ جْناتْوا یِیشُراپْرَتھَمادْ ییشُ جَگَتْپْرَواسِشْواتْمِییَلوکیشَ پْریمَ کَروتِ سْمَ تیشُ شیشَں یاوَتْ پْریمَ کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","پِتا تَسْیَ ہَسْتے سَرْوَّں سَمَرْپِتَوانْ سْوَیَمْ اِیشْوَرَسْیَ سَمِیپادْ آگَچّھَدْ اِیشْوَرَسْیَ سَمِیپَں یاسْیَتِ چَ، سَرْوّانْییتانِ جْناتْوا رَجَنْیاں بھوجَنے سَمْپُورْنے سَتِ، ");
INSERT INTO sanurd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","یَدا شَیتانْ تَں پَرَہَسْتیشُ سَمَرْپَیِتُں شِمونَح پُتْرَسْیَ اِیشْکارِیوتِیَسْیَ یِہُودا اَنْتَحکَرَنے کُپْرَورِتِّں سَمارْپَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","تَدا یِیشُ رْبھوجَناسَنادْ اُتّھایَ گاتْرَوَسْتْرَں موچَیِتْوا گاتْرَمارْجَنَوَسْتْرَں گرِہِیتْوا تینَ سْوَکَٹِمْ اَبَدھْناتْ، ");
INSERT INTO sanurd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","پَشْچادْ ایکَپاتْرے جَلَمْ اَبھِشِچْیَ شِشْیاناں پادانْ پْرَکْشالْیَ تینَ کَٹِبَدّھَگاتْرَمارْجَنَواسَسا مارْشْٹُں پْرارَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","تَتَح شِمونْپِتَرَسْیَ سَمِیپَماگَتے سَ اُکْتَوانْ ہے پْرَبھو بھَوانْ کِں مَمَ پادَو پْرَکْشالَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","یِیشُرُدِتَوانْ اَہَں یَتْ کَرومِ تَتْ سَمْپْرَتِ نَ جاناسِ کِنْتُ پَشْچاجْ جْناسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","تَتَح پِتَرَح کَتھِتَوانْ بھَوانْ کَداپِ مَمَ پادَو نَ پْرَکْشالَیِشْیَتِ۔ یِیشُرَکَتھَیَدْ یَدِ تْواں نَ پْرَکْشالَیے تَرْہِ مَیِ تَوَ کوپْیَںشو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","تَدا شِمونْپِتَرَح کَتھِتَوانْ ہے پْرَبھو تَرْہِ کیوَلَپادَو نَ، مَمَ ہَسْتَو شِرَشْچَ پْرَکْشالَیَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","تَتو یِیشُرَوَدَدْ یو جَنو دھَوتَسْتَسْیَ سَرْوّانْگَپَرِشْکرِتَتْواتْ پادَو وِنانْیانْگَسْیَ پْرَکْشالَناپیکْشا ناسْتِ۔ یُویَں پَرِشْکرِتا اِتِ سَتْیَں کِنْتُ نَ سَرْوّے، ");
INSERT INTO sanurd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","یَتو یو جَنَسْتَں پَرَکَریشُ سَمَرْپَیِشْیَتِ تَں سَ جْناتَوانَ؛ اَتَایوَ یُویَں سَرْوّے نَ پَرِشْکرِتا اِماں کَتھاں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","اِتّھَں یِیشُسْتیشاں پادانْ پْرَکْشالْیَ وَسْتْرَں پَرِدھایاسَنے سَمُپَوِشْیَ کَتھِتَوانْ اَہَں یُشْمانْ پْرَتِ کِں کَرْمّاکارْشَں جانِیتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","یُویَں ماں گُرُں پْرَبھُنْچَ وَدَتھَ تَتْ سَتْیَمیوَ وَدَتھَ یَتوہَں سَایوَ بھَوامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","یَدْیَہَں پْرَبھُ رْگُرُشْچَ سَنْ یُشْماکَں پادانْ پْرَکْشالِتَوانْ تَرْہِ یُشْماکَمَپِ پَرَسْپَرَں پادَپْرَکْشالَنَمْ اُچِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","اَہَں یُشْمانْ پْرَتِ یَتھا وْیَواہَرَں یُشْمانْ تَتھا وْیَوَہَرْتُّمْ ایکَں پَنْتھانَں دَرْشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ، پْرَبھو رْداسو نَ مَہانْ پْریرَکاچَّ پْریرِتو نَ مَہانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","اِماں کَتھاں وِدِتْوا یَدِ تَدَنُسارَتَح کَرْمّانِ کُرُتھَ تَرْہِ یُویَں دھَنْیا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","سَرْوّیشُ یُشْماسُ کَتھامِماں کَتھَیامِ اِتِ نَ، یے مَمَ مَنونِیتاسْتانَہَں جانامِ، کِنْتُ مَمَ بھَکْشْیانِ یو بھُنْکْتے مَتْپْرانَپْراتِکُولْیَتَح۔ اُتّھاپَیَتِ پادَسْیَ مُولَں سَ ایشَ مانَوَح۔ یَدیتَدْ دھَرْمَّپُسْتَکَسْیَ وَچَنَں تَدَنُساریناوَشْیَں گھَٹِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","اَہَں سَ جَنَ اِتْیَتْرَ یَتھا یُشْماکَں وِشْواسو جایَتے تَدَرْتھَں ایتادرِشَگھَٹَناتْ پُورْوَّمْ اَہَمِدانِیں یُشْمَبھْیَمَکَتھَیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","اَہَں یُشْمانَتِیوَ یَتھارْتھَں وَدامِ، مَیا پْریرِتَں جَنَں یو گرِہْلاتِ سَ مامیوَ گرِہْلاتِ یَشْچَ ماں گرِہْلاتِ سَ مَتْپْریرَکَں گرِہْلاتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ایتاں کَتھاں کَتھَیِتْوا یِیشُ رْدُحکھِی سَنْ پْرَمانَں دَتّوا کَتھِتَوانْ اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ یُشْماکَمْ ایکو جَنو ماں پَرَکَریشُ سَمَرْپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","تَتَح سَ کَمُدِّشْیَ کَتھامیتاں کَتھِتَوانْ اِتْیَتْرَ سَنْدِگْدھاح شِشْیاح پَرَسْپَرَں مُکھَمالوکَیِتُں پْرارَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","تَسْمِنْ سَمَیے یِیشُ رْیَسْمِنْ اَپْرِییَتَ سَ شِشْیَسْتَسْیَ وَکْشَحسْتھَلَمْ اَوالَمْبَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","شِمونْپِتَرَسْتَں سَنْکیتیناوَدَتْ، اَیَں کَمُدِّشْیَ کَتھامیتامْ کَتھَیَتِیتِ پرِچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","تَدا سَ یِیشو رْوَکْشَحسْتھَلَمْ اَوَلَمْبْیَ پرِشْٹھَوانْ، ہے پْرَبھو سَ جَنَح کَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","تَتو یِیشُح پْرَتْیَوَدَدْ ایکَکھَنْڈَں پُوپَں مَجَّیِتْوا یَسْمَے داسْیامِ سَایوَ سَح؛ پَشْچاتْ پُوپَکھَنْڈَمیکَں مَجَّیِتْوا شِمونَح پُتْرایَ اِیشْکَرِیوتِییایَ یِہُودَے دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","تَسْمِنْ دَتّے سَتِ شَیتانْ تَماشْرَیَتْ؛ تَدا یِیشُسْتَمْ اَوَدَتْ تْوَں یَتْ کَرِشْیَسِ تَتْ کْشِپْرَں کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","کِنْتُ سَ ییناشَیینَ تاں کَتھامَکَتھایَتْ تَمْ اُپَوِشْٹَلوکاناں کوپِ نابُدھْیَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","کِنْتُ یِہُوداح سَمِیپے مُدْراسَمْپُٹَکَسْتھِتیح کیچِدْ اِتّھَمْ اَبُدھْیَنْتَ پارْوَّناسادَنارْتھَں کِمَپِ دْرَوْیَں کْریتُں وا دَرِدْریبھْیَح کِنْچِدْ وِتَرِتُں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","تَدا پُوپَکھَنْڈَگْرَہَناتْ پَرَں سَ تُورْنَں بَہِرَگَچّھَتْ؛ راتْرِشْچَ سَمُپَسْیِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","یِہُودے بَہِرْگَتے یِیشُرَکَتھَیَدْ اِدانِیں مانَوَسُتَسْیَ مَہِما پْرَکاشَتے تینیشْوَرَسْیاپِ مَہِما پْرَکاشَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","یَدِ تینیشْوَرَسْیَ مَہِما پْرَکاشَتے تَرْہِیشْوَروپِ سْوینَ تَسْیَ مَہِمانَں پْرَکاشَیِشْیَتِ تُورْنَمیوَ پْرَکاشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ہے وَتْسا اَہَں یُشْمابھِح سارْدّھَں کِنْچِتْکالَماتْرَمْ آسے، تَتَح پَرَں ماں مرِگَیِشْیَدھْوے کِنْتْوَہَں یَتْسْتھانَں یامِ تَتْسْتھانَں یُویَں گَنْتُں نَ شَکْشْیَتھَ، یامِماں کَتھاں یِہُودِیییبھْیَح کَتھِتَوانْ تَتھادھُنا یُشْمَبھْیَمَپِ کَتھَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","یُویَں پَرَسْپَرَں پْرِییَدھْوَمْ اَہَں یُشْماسُ یَتھا پْرِییے یُویَمَپِ پَرَسْپَرَمْ تَتھَیوَ پْرِییَدھْوَں، یُشْمانْ اِماں نَوِینامْ آجْنامْ آدِشامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","تینَیوَ یَدِ پَرَسْپَرَں پْرِییَدھْوے تَرْہِ لَکْشَنینانینَ یُویَں مَمَ شِشْیا اِتِ سَرْوّے جْناتُں شَکْشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","شِمونَپِتَرَح پرِشْٹھَوانْ ہے پْرَبھو بھَوانْ کُتْرَ یاسْیَتِ؟ تَتو یِیشُح پْرَتْیَوَدَتْ، اَہَں یَتْسْتھانَں یامِ تَتْسْتھانَں سامْپْرَتَں مَمَ پَشْچادْ گَنْتُں نَ شَکْنوشِ کِنْتُ پَشْچادْ گَمِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","تَدا پِتَرَح پْرَتْیُدِتَوانْ، ہے پْرَبھو سامْپْرَتَں کُتو ہیتوسْتَوَ پَشْچادْ گَنْتُں نَ شَکْنومِ؟ تْوَدَرْتھَں پْرانانْ داتُں شَکْنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","تَتو یِیشُح پْرَتْیُکْتَوانْ مَنِّمِتَّں کِں پْرانانْ داتُں شَکْنوشِ؟ تْوامَہَں یَتھارْتھَں وَدامِ، کُکُّٹَرَوَناتْ پُورْوَّں تْوَں تْرِ رْمامْ اَپَہْنوشْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","مَنودُحکھِنو ما بھُوتَ؛ اِیشْوَرے وِشْوَسِتَ مَیِ چَ وِشْوَسِتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","مَمَ پِتُ گرِہے بَہُونِ واسَسْتھانِ سَنْتِ نو چیتْ پُورْوَّں یُشْمانْ اَجْناپَیِشْیَں یُشْمَدَرْتھَں سْتھانَں سَجَّیِتُں گَچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","یَدِ گَتْواہَں یُشْمَنِّمِتَّں سْتھانَں سَجَّیامِ تَرْہِ پَنَراگَتْیَ یُشْمانْ سْوَسَمِیپَں نیشْیامِ، تَتو یَتْراہَں تِشْٹھامِ تَتْرَ یُویَمَپِ سْتھاسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","اَہَں یَتْسْتھانَں بْرَجامِ تَتْسْتھانَں یُویَں جانِیتھَ تَسْیَ پَنْتھانَمَپِ جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","تَدا تھوما اَوَدَتْ، ہے پْرَبھو بھَوانْ کُتْرَ یاتِ تَدْوَیَں نَ جانِیمَح، تَرْہِ کَتھَں پَنْتھانَں جْناتُں شَکْنُمَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","یِیشُرَکَتھَیَدْ اَہَمیوَ سَتْیَجِیوَنَرُوپَپَتھو مَیا نَ گَنْتا کوپِ پِتُح سَمِیپَں گَنْتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","یَدِ مامْ اَجْناسْیَتَ تَرْہِ مَمَ پِتَرَمَپْیَجْناسْیَتَ کِنْتْوَدھُناتَسْتَں جانِیتھَ پَشْیَتھَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","تَدا پھِلِپَح کَتھِتَوانْ، ہے پْرَبھو پِتَرَں دَرْشَیَ تَسْمادَسْماکَں یَتھیشْٹَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","تَتو یِیشُح پْرَتْیاوادِیتْ، ہے پھِلِپَ یُشْمابھِح سارْدّھَمْ ایتاوَدِّنانِ سْتھِتَمَپِ ماں کِں نَ پْرَتْیَبھِجاناسِ؟ یو جَنو مامْ اَپَشْیَتْ سَ پِتَرَمَپْیَپَشْیَتْ تَرْہِ پِتَرَمْ اَسْمانْ دَرْشَییتِ کَتھاں کَتھَں کَتھَیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","اَہَں پِتَرِ تِشْٹھامِ پِتا مَیِ تِشْٹھَتِیتِ کِں تْوَں نَ پْرَتْیَشِ؟ اَہَں یَدْواکْیَں وَدامِ تَتْ سْوَتو نَ وَدامِ کِنْتُ یَح پِتا مَیِ وِراجَتے سَ ایوَ سَرْوَّکَرْمّانِ کَراتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","اَتَایوَ پِتَرْیَّہَں تِشْٹھامِ پِتا چَ مَیِ تِشْٹھَتِ مَماسْیاں کَتھایاں پْرَتْیَیَں کُرُتَ، نو چیتْ کَرْمَّہیتوح پْرَتْیَیَں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","اَہَں یُشْمانَتِیَتھارْتھَں وَدامِ، یو جَنو مَیِ وِشْوَسِتِ سوہَمِوَ کَرْمّانِ کَرِشْیَتِ وَرَں تَتوپِ مَہاکَرْمّانِ کَرِشْیَتِ یَتو ہیتورَہَں پِتُح سَمِیپَں گَچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","یَتھا پُتْرینَ پِتُ رْمَہِما پْرَکاشَتے تَدَرْتھَں مَمَ نامَ پْروچْیَ یَتْ پْرارْتھَیِشْیَدھْوے تَتْ سَپھَلَں کَرِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","یَدِ مَمَ نامْنا یَتْ کِنْچِدْ یاچَدھْوے تَرْہِ تَدَہَں سادھَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","یَدِ مَیِ پْرِییَدھْوے تَرْہِ مَماجْناح سَماچَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","تَتو مَیا پِتُح سَمِیپے پْرارْتھِتے پِتا نِرَنْتَرَں یُشْمابھِح سارْدّھَں سْتھاتُمْ اِتَرَمیکَں سَہایَمْ اَرْتھاتْ سَتْیَمَیَمْ آتْمانَں یُشْماکَں نِکَٹَں پْریشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ایتَجَّگَتو لوکاسْتَں گْرَہِیتُں نَ شَکْنُوَنْتِ یَتَسْتے تَں ناپَشْیَنْ ناجَنَںشْچَ کِنْتُ یُویَں جانِیتھَ یَتو ہیتوح سَ یُشْماکَمَنْتَ رْنِوَسَتِ یُشْماکَں مَدھْیے سْتھاسْیَتِ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","اَہَں یُشْمانْ اَناتھانْ کرِتْوا نَ یاسْیامِ پُنَرَپِ یُشْماکَں سَمِیپَمْ آگَمِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","کِیَتْکالَرَتْ پَرَمْ اَسْیَ جَگَتو لوکا ماں پُنَ رْنَ دْرَکْشْیَنْتِ کِنْتُ یُویَں دْرَکْشْیَتھَ؛اَہَں جِیوِشْیامِ تَسْماتْ کارَنادْ یُویَمَپِ جِیوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","پِتَرْیَّہَمَسْمِ مَیِ چَ یُویَں سْتھَ، تَتھاہَں یُشْماسْوَسْمِ تَدَپِ تَدا جْناسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","یو جَنو مَماجْنا گرِہِیتْوا تا آچَرَتِ سَایوَ مَیِ پْرِییَتے؛ یو جَنَشْچَ مَیِ پْرِییَتے سَایوَ مَمَ پِتُح پْرِیَپاتْرَں بھَوِشْیَتِ، تَتھاہَمَپِ تَسْمِنْ پْرِیتْوا تَسْمَے سْوَں پْرَکاشَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","تَدا اِیشْکَرِیوتِییادْ اَنْیو یِہُوداسْتَمَوَدَتْ، ہے پْرَبھو بھَوانْ جَگَتو لوکاناں سَنِّدھَو پْرَکاشِتو نَ بھُوتْواسْماکَں سَنِّدھَو کُتَح پْرَکاشِتو بھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","تَتو یِیشُح پْرَتْیُدِتَوانْ، یو جَنو مَیِ پْرِییَتے سَ مَماجْنا اَپِ گرِہْلاتِ، تینَ مَمَ پِتاپِ تَسْمِنْ پْریشْیَتے، آوانْچَ تَنِّکَٹَماگَتْیَ تینَ سَہَ نِوَتْسْیاوَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","یو جَنو مَیِ نَ پْرِییَتے سَ مَمَ کَتھا اَپِ نَ گرِہْلاتِ پُنَشْچَ یامِماں کَتھاں یُویَں شرِنُتھَ سا کَتھا کیوَلَسْیَ مَمَ نَ کِنْتُ مَمَ پْریرَکو یَح پِتا تَسْیاپِ کَتھا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","اِدانِیں یُشْماکَں نِکَٹے وِدْیَمانوہَمْ ایتاح سَکَلاح کَتھاح کَتھَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","کِنْتْوِتَح پَرَں پِتْرا یَح سَہایورْتھاتْ پَوِتْرَ آتْما مَمَ نامْنِ پْریرَیِشْیَتِ سَ سَرْوَّں شِکْشَیِتْوا مَیوکْتاح سَمَسْتاح کَتھا یُشْمانْ سْمارَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","اَہَں یُشْماکَں نِکَٹے شانْتِں سْتھاپَیِتْوا یامِ، نِجاں شانْتِں یُشْمَبھْیَں دَدامِ، جَگَتو لوکا یَتھا دَداتِ تَتھاہَں نَ دَدامِ؛ یُشْماکَمْ اَنْتَحکَرَنانِ دُحکھِتانِ بھِیتانِ چَ نَ بھَوَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","اَہَں گَتْوا پُنَرَپِ یُشْماکَں سَمِیپَمْ آگَمِشْیامِ مَیوکْتَں واکْیَمِدَں یُویَمْ اَشْرَوشْٹَ؛ یَدِ مَیَّپْریشْیَدھْوَں تَرْہْیَہَں پِتُح سَمِیپَں گَچّھامِ مَماسْیاں کَتھایاں یُویَمْ اَہْلادِشْیَدھْوَں یَتو مَمَ پِتا مَتّوپِ مَہانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","تَسْیا گھَٹَنایاح سَمَیے یَتھا یُشْماکَں شْرَدّھا جایَتے تَدَرْتھَمْ اَہَں تَسْیا گھَٹَنایاح پُورْوَّمْ اِدانِیں یُشْمانْ ایتاں وارْتّاں وَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","اِتَح پَرَں یُشْمابھِح سَہَ مَمَ بَہَوَ آلاپا نَ بھَوِشْیَنْتِ یَتَح کارَنادْ ایتَسْیَ جَگَتَح پَتِراگَچّھَتِ کِنْتُ مَیا سَہَ تَسْیَ کوپِ سَمْبَنْدھو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","اَہَں پِتَرِ پْریمَ کَرومِ تَتھا پِتُ رْوِدھِوَتْ کَرْمّانِ کَرومِیتِ یینَ جَگَتو لوکا جانَنْتِ تَدَرْتھَمْ اُتِّشْٹھَتَ وَیَں سْتھانادَسْمادْ گَچّھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","اَہَں سَتْیَدْراکْشالَتاسْوَرُوپو مَمَ پِتا تُودْیانَپَرِچارَکَسْوَرُوپَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","مَمَ یاسُ شاکھاسُ پھَلانِ نَ بھَوَنْتِ تاح سَ چھِنَتِّ تَتھا پھَلَوَتْیَح شاکھا یَتھادھِکَپھَلانِ پھَلَنْتِ تَدَرْتھَں تاح پَرِشْکَروتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","اِدانِیں مَیوکْتوپَدیشینَ یُویَں پَرِشْکرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","اَتَح کارَناتْ مَیِ تِشْٹھَتَ تیناہَمَپِ یُشْماسُ تِشْٹھامِ، یَتو ہیتو رْدْراکْشالَتایامْ اَسَںلَگْنا شاکھا یَتھا پھَلَوَتِی بھَوِتُں نَ شَکْنوتِ تَتھا یُویَمَپِ مَیَّتِشْٹھَنْتَح پھَلَوَنْتو بھَوِتُں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","اَہَں دْراکْشالَتاسْوَرُوپو یُویَنْچَ شاکھاسْوَرُوپوح؛ یو جَنو مَیِ تِشْٹھَتِ یَتْرَ چاہَں تِشْٹھامِ، سَ پْرَچُورَپھَلَیح پھَلَوانْ بھَوَتِ، کِنْتُ ماں وِنا یُویَں کِمَپِ کَرْتُّں نَ شَکْنُتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","یَح کَشْچِنْ مَیِ نَ تِشْٹھَتِ سَ شُشْکَشاکھیوَ بَہِ رْنِکْشِپْیَتے لوکاشْچَ تا آہرِتْیَ وَہْنَو نِکْشِپْیَ داہَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","یَدِ یُویَں مَیِ تِشْٹھَتھَ مَمَ کَتھا چَ یُشْماسُ تِشْٹھَتِ تَرْہِ یَدْ وانْچھِتْوا یاچِشْیَدھْوے یُشْماکَں تَدیوَ سَپھَلَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","یَدِ یُویَں پْرَچُورَپھَلَوَنْتو بھَوَتھَ تَرْہِ تَدْوارا مَمَ پِتُ رْمَہِما پْرَکاشِشْیَتے تَتھا یُویَں مَمَ شِشْیا اِتِ پَرِکْشایِشْیَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","پِتا یَتھا مَیِ پْرِیتَوانْ اَہَمَپِ یُشْماسُ تَتھا پْرِیتَوانْ اَتو ہیتو رْیُویَں نِرَنْتَرَں مَمَ پْریمَپاتْرانِ بھُوتْوا تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","اَہَں یَتھا پِتُراجْنا گرِہِیتْوا تَسْیَ پْریمَبھاجَنَں تِشْٹھامِ تَتھَیوَ یُویَمَپِ یَدِ مَماجْنا گُہْلِیتھَ تَرْہِ مَمَ پْریمَبھاجَنانِ سْتھاسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","یُشْمَنِّمِتَّں مَمَ یَ آہْلادَح سَ یَتھا چِرَں تِشْٹھَتِ یُشْماکَمْ آنَنْدَشْچَ یَتھا پُورْیَّتے تَدَرْتھَں یُشْمَبھْیَمْ ایتاح کَتھا اَتْرَکَتھَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","اَہَں یُشْماسُ یَتھا پْرِییے یُویَمَپِ پَرَسْپَرَں تَتھا پْرِییَدھْوَمْ ایشا مَماجْنا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","مِتْراناں کارَناتْ سْوَپْرانَدانَپَرْیَّنْتَں یَتْ پْریمَ تَسْمانْ مَہاپْریمَ کَسْیاپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","اَہَں یَدْیَدْ آدِشامِ تَتَّدیوَ یَدِ یُویَمْ آچَرَتَ تَرْہِ یُویَمیوَ مَمَ مِتْرانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","اَدْیارَبھْیَ یُشْمانْ داسانْ نَ وَدِشْیامِ یَتْ پْرَبھُ رْیَتْ کَروتِ داسَسْتَدْ نَ جاناتِ؛ کِنْتُ پِتُح سَمِیپے یَدْیَدْ اَشرِنَوَں تَتْ سَرْوَّں یُوشْمانْ اَجْناپَیَمْ تَتْکارَنادْ یُشْمانْ مِتْرانِ پْروکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","یُویَں ماں روچِتَوَنْتَ اِتِ نَ، کِنْتْوَہَمیوَ یُشْمانْ روچِتَوانْ یُویَں گَتْوا یَتھا پھَلانْیُتْپادَیَتھَ تانِ پھَلانِ چاکْشَیانِ بھَوَنْتِ، تَدَرْتھَں یُشْمانْ نْیَجُنَجَں تَسْمانْ مَمَ نامَ پْروچْیَ پِتَرَں یَتْ کِنْچِدْ یاچِشْیَدھْوے تَدیوَ سَ یُشْمَبھْیَں داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","یُویَں پَرَسْپَرَں پْرِییَدھْوَمْ اَہَمْ اِتْیاجْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","جَگَتو لوکَے رْیُشْماسُ رِتِییِتیشُ تے پُورْوَّں مامیوارْتِّییَنْتَ اِتِ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","یَدِ یُویَں جَگَتو لوکا اَبھَوِشْیَتَ تَرْہِ جَگَتو لوکا یُشْمانْ آتْمِییانْ بُدّھواپْریشْیَنْتَ؛ کِنْتُ یُویَں جَگَتو لوکا نَ بھَوَتھَ، اَہَں یُشْمانْ اَسْماجَّگَتوروچَیَمْ ایتَسْماتْ کارَناجَّگَتو لوکا یُشْمانْ رِتِییَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","داسَح پْرَبھو رْمَہانْ نَ بھَوَتِ مَمَیتَتْ پُورْوِّییَں واکْیَں سْمَرَتَ؛ تے یَدِ مامیواتاڈَیَنْ تَرْہِ یُشْمانَپِ تاڈَیِشْیَنْتِ، یَدِ مَمَ واکْیَں گرِہْلَنْتِ تَرْہِ یُشْماکَمَپِ واکْیَں گْرَہِیشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","کِنْتُ تے مَمَ نامَکارَنادْ یُشْمانْ پْرَتِ تادرِشَں وْیَوَہَرِشْیَنْتِ یَتو یو ماں پْریرِتَوانْ تَں تے نَ جانَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","تیشاں سَنِّدھِمْ آگَتْیَ یَدْیَہَں ناکَتھَیِشْیَں تَرْہِ تیشاں پاپَں نابھَوِشْیَتْ کِنْتْوَدھُنا تیشاں پاپَماچّھادَیِتُمْ اُپایو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","یو جَنو مامْ رِتِییَتے سَ مَمَ پِتَرَمَپِ رِتِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","یادرِشانِ کَرْمّانِ کیناپِ کَداپِ ناکْرِیَنْتَ تادرِشانِ کَرْمّانِ یَدِ تیشاں ساکْشادْ اَہَں ناکَرِشْیَں تَرْہِ تیشاں پاپَں نابھَوِشْیَتْ کِنْتْوَدھُنا تے درِشْٹْواپِ ماں مَمَ پِتَرَنْچارْتِّییَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","تَسْماتْ تےکارَنَں مامْ رِتِییَنْتے یَدیتَدْ وَچَنَں تیشاں شاسْتْرے لِکھِتَماسْتے تَتْ سَپھَلَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","کِنْتُ پِتُ رْنِرْگَتَں یَں سَہایَمَرْتھاتْ سَتْیَمَیَمْ آتْمانَں پِتُح سَمِیپادْ یُشْماکَں سَمِیپے پْریشَیِشْیامِ سَ آگَتْیَ مَیِ پْرَمانَں داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","یُویَں پْرَتھَمَمارَبھْیَ مَیا سارْدّھَں تِشْٹھَتھَ تَسْمادّھیتو رْیُویَمَپِ پْرَمانَں داسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","یُشْماکَں یَتھا وادھا نَ جایَتے تَدَرْتھَں یُشْمانْ ایتانِ سَرْوَّواکْیانِ وْیاہَرَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","لوکا یُشْمانْ بھَجَنَگرِہیبھْیو دُورِیکَرِشْیَنْتِ تَتھا یَسْمِنْ سَمَیے یُشْمانْ ہَتْوا اِیشْوَرَسْیَ تُشْٹِ جَنَکَں کَرْمّاکُرْمَّ اِتِ مَںسْیَنْتے سَ سَمَیَ آگَچّھَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","تے پِتَرَں مانْچَ نَ جانَنْتِ، تَسْمادْ یُشْمانْ پْرَتِیدرِشَمْ آچَرِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","اَتو ہیتاح سَمَیے سَمُپَسْتھِتے یَتھا مَمَ کَتھا یُشْماکَں مَنَحسُح سَمُپَتِشْٹھَتِ تَدَرْتھَں یُشْمابھْیَمْ ایتاں کَتھاں کَتھَیامِ یُشْمابھِح سارْدّھَمْ اَہَں تِشْٹھَنْ پْرَتھَمَں تاں یُشْمَبھْیَں ناکَتھَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","سامْپْرَتَں سْوَسْیَ پْریرَیِتُح سَمِیپَں گَچّھامِ تَتھاپِ تْوَں کَّ گَچّھَسِ کَتھامیتاں یُشْماکَں کوپِ ماں نَ پرِچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","کِنْتُ مَیوکْتابھِرابھِح کَتھابھِ رْیُوشْماکَمْ اَنْتَحکَرَنانِ دُحکھینَ پُورْنانْیَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","تَتھاپْیَہَں یَتھارْتھَں کَتھَیامِ مَمَ گَمَنَں یُشْماکَں ہِتارْتھَمیوَ، یَتو ہیتو رْگَمَنے نَ کرِتے سَہایو یُشْماکَں سَمِیپَں ناگَمِشْیَتِ کِنْتُ یَدِ گَچّھامِ تَرْہِ یُشْماکَں سَمِیپے تَں پْریشَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","تَتَح سَ آگَتْیَ پاپَپُنْیَدَنْڈیشُ جَگَتو لوکاناں پْرَبودھَں جَنَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","تے مَیِ نَ وِشْوَسَنْتِ تَسْمادّھیتوح پاپَپْرَبودھَں جَنَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","یُشْماکَمْ اَدرِشْیَح سَنَّہَں پِتُح سَمِیپَں گَچّھامِ تَسْمادْ پُنْیے پْرَبودھَں جَنَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ایتَجَّگَتودھِپَتِ رْدَنْڈاجْناں پْراپْنوتِ تَسْمادْ دَنْڈے پْرَبودھَں جَنَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","یُشْمَبھْیَں کَتھَیِتُں مَمانیکاح کَتھا آسَتے، تاح کَتھا اِدانِیں یُویَں سوڈھُں نَ شَکْنُتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","کِنْتُ سَتْیَمَیَ آتْما یَدا سَماگَمِشْیَتِ تَدا سَرْوَّں سَتْیَں یُشْمانْ نیشْیَتِ، سَ سْوَتَح کِمَپِ نَ وَدِشْیَتِ کِنْتُ یَچّھروشْیَتِ تَدیوَ کَتھَیِتْوا بھاوِکارْیَّں یُشْمانْ جْناپَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","مَمَ مَہِمانَں پْرَکاشَیِشْیَتِ یَتو مَدِییاں کَتھاں گرِہِیتْوا یُشْمانْ بودھَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","پِتُ رْیَدْیَدْ آسْتے تَتْ سَرْوَّں مَمَ تَسْمادْ کارَنادْ اَوادِشَں سَ مَدِییاں کَتھاں گرِہِیتْوا یُشْمانْ بودھَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","کِیَتْکالاتْ پَرَں یُویَں ماں دْرَشْٹُں نَ لَپْسْیَدھْوے کِنْتُ کِیَتْکالاتْ پَرَں پُنَ رْدْرَشْٹُں لَپْسْیَدھْوے یَتوہَں پِتُح سَمِیپَں گَچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","تَتَح شِشْیاناں کِیَنْتو جَناح پَرَسْپَرَں وَدِتُمْ آرَبھَنْتَ، کِیَتْکالاتْ پَرَں ماں دْرَشْٹُں نَ لَپْسْیَدھْوے کِنْتُ کِیَتْکالاتْ پَرَں پُنَ رْدْرَشْٹُں لَپْسْیَدھْوے یَتوہَں پِتُح سَمِیپَں گَچّھامِ، اِتِ یَدْ واکْیَمْ اَیَں وَدَتِ تَتْ کِں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","تَتَح کِیَتْکالاتْ پَرَمْ اِتِ تَسْیَ واکْیَں کِں؟ تَسْیَ واکْیَسْیابھِپْرایَں وَیَں بودّھُں نَ شَکْنُمَسْتَیرِتِ ");
INSERT INTO sanurd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","نِگَدِتے یِیشُسْتیشاں پْرَشْنیچّھاں جْناتْوا تیبھْیوکَتھَیَتْ کِیَتْکالاتْ پَرَں ماں دْرَشْٹُں نَ لَپْسْیَدھْوے، کِنْتُ کِیَتْکالاتْ پَرَں پُونَ رْدْرَشْٹُں لَپْسْیَدھْوے، یامِماں کَتھامَکَتھَیَں تَسْیا اَبھِپْرایَں کِں یُویَں پَرَسْپَرَں مرِگَیَدھْوے؟ ");
INSERT INTO sanurd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","یُشْمانَہَمْ اَتِیَتھارْتھَں وَدامِ یُویَں کْرَنْدِشْیَتھَ وِلَپِشْیَتھَ چَ، کِنْتُ جَگَتو لوکا آنَنْدِشْیَنْتِ؛ یُویَں شوکاکُلا بھَوِشْیَتھَ کِنْتُ شوکاتْ پَرَں آنَنْدَیُکْتا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","پْرَسَوَکالَ اُپَسْتھِتے نارِی یَتھا پْرَسَوَویدَنَیا وْیاکُلا بھَوَتِ کِنْتُ پُتْرے بھُومِشْٹھے سَتِ مَنُشْیَیکو جَنْمَنا نَرَلوکے پْرَوِشْٹَ اِتْیانَنْداتْ تَسْیاسْتَتْسَرْوَّں دُحکھَں مَنَسِ نَ تِشْٹھَتِ، ");
INSERT INTO sanurd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","تَتھا یُویَمَپِ سامْپْرَتَں شوکاکُلا بھَوَتھَ کِنْتُ پُنَرَپِ یُشْمَبھْیَں دَرْشَنَں داسْیامِ تینَ یُشْماکَمْ اَنْتَحکَرَنانِ سانَنْدانِ بھَوِشْیَنْتِ، یُشْماکَں تَمْ آنَنْدَنْچَ کوپِ ہَرْتُّں نَ شَکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","تَسْمِنْ دِوَسے کامَپِ کَتھاں ماں نَ پْرَکْشْیَتھَ۔ یُشْمانَہَمْ اَتِیَتھارْتھَں وَدامِ، مَمَ نامْنا یَتْ کِنْچِدْ پِتَرَں یاچِشْیَدھْوے تَدیوَ سَ داسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","پُورْوّے مَمَ نامْنا کِمَپِ نایاچَدھْوَں، یاچَدھْوَں تَتَح پْراپْسْیَتھَ تَسْمادْ یُشْماکَں سَمْپُورْنانَنْدو جَنِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","اُپَماکَتھابھِح سَرْوّانْییتانِ یُشْمانْ جْناپِتَوانْ کِنْتُ یَسْمِنْ سَمَیے اُپَمَیا نوکْتْوا پِتُح کَتھاں سْپَشْٹَں جْناپَیِشْیامِ سَمَیَ ایتادرِشَ آگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","تَدا مَمَ نامْنا پْرارْتھَیِشْیَدھْوے ہَں یُشْمَنِّمِتَّں پِتَرَں وِنیشْیے کَتھامِماں نَ وَدامِ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","یَتو یُویَں مَیِ پْریمَ کُرُتھَ، تَتھاہَمْ اِیشْوَرَسْیَ سَمِیپادْ آگَتَوانْ اِتْیَپِ پْرَتِیتھَ، تَسْمادْ کارَناتْ کارَناتْ پِتا سْوَیَں یُشْماسُ پْرِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","پِتُح سَمِیپاجَّجَدْ آگَتوسْمِ جَگَتْ پَرِتْیَجْیَ چَ پُنَرَپِ پِتُح سَمِیپَں گَچّھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","تَدا شِشْیا اَوَدَنْ، ہے پْرَبھو بھَوانْ اُپَمَیا نوکْتْوادھُنا سْپَشْٹَں وَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","بھَوانْ سَرْوَّجْنَح کینَچِتْ پرِشْٹو بھَوِتُمَپِ بھَوَتَح پْرَیوجَنَں ناسْتِیتْیَدھُناسْماکَں سْتھِرَجْنانَں جاتَں تَسْمادْ بھَوانْ اِیشْوَرَسْیَ سَمِیپادْ آگَتَوانْ اِتْیَتْرَ وَیَں وِشْوَسِمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","تَتو یِیشُح پْرَتْیَوادِیدْ اِدانِیں کِں یُویَں وِشْوَسِتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","پَشْیَتَ سَرْوّے یُویَں وِکِیرْناح سَنْتو مامْ ایکاکِنَں پِیرَتْیَجْیَ سْوَں سْوَں سْتھانَں گَمِشْیَتھَ، ایتادرِشَح سَمَیَ آگَچّھَتِ وَرَں پْرایینوپَسْتھِتَوانْ؛ تَتھاپْیَہَں نَیکاکِی بھَوامِ یَتَح پِتا مَیا سارْدّھَمْ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","یَتھا مَیا یُشْماکَں شانْتِ رْجایَتے تَدَرْتھَمْ ایتاح کَتھا یُشْمَبھْیَمْ اَچَکَتھَں؛ اَسْمِنْ جَگَتِ یُشْماکَں کْلیشو گھَٹِشْیَتے کِنْتْوَکْشوبھا بھَوَتَ یَتو مَیا جَگَجِّتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","تَتَح پَرَں یِیشُریتاح کَتھاح کَتھَیِتْوا سْوَرْگَں وِلوکْیَیتَتْ پْرارْتھَیَتْ، ہے پِتَح سَمَیَ اُپَسْتھِتَوانْ؛ یَتھا تَوَ پُتْرَسْتَوَ مَہِمانَں پْرَکاشَیَتِ تَدَرْتھَں تْوَں نِجَپُتْرَسْیَ مَہِمانَں پْرَکاشَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","تْوَں یولّوکانْ تَسْیَ ہَسْتے سَمَرْپِتَوانْ سَ یَتھا تیبھْیونَنْتایُ رْدَداتِ تَدَرْتھَں تْوَں پْرانِماتْرانامْ اَدھِپَتِتْوَبھارَں تَسْمَے دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","یَسْتْوَمْ اَدْوِتِییَح سَتْیَ اِیشْوَرَسْتْوَیا پْریرِتَشْچَ یِیشُح کھْرِیشْٹَ ایتَیورُبھَیوح پَرِچَیے پْراپْتےنَنْتایُ رْبھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","تْوَں یَسْیَ کَرْمَّنو بھارَں مَہْیَں دَتَّوانْ، تَتْ سَمْپَنَّں کرِتْوا جَگَتْیَسْمِنْ تَوَ مَہِمانَں پْراکاشَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","اَتَایوَ ہے پِتَ رْجَگَتْیَوِدْیَمانے تْوَیا سَہَ تِشْٹھَتو مَمَ یو مَہِماسِیتْ سَمْپْرَتِ تَوَ سَمِیپے ماں تَں مَہِمانَں پْراپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","اَنْیَچَّ تْوَمْ ایتَجَّگَتو یالّوکانْ مَہْیَمْ اَدَدا اَہَں تیبھْیَسْتَوَ نامْنَسْتَتّوَجْنانَمْ اَدَداں، تے تَوَیواسَنْ، تْوَں تانْ مَہْیَمَدَداح، تَسْماتّے تَووپَدیشَمْ اَگرِہْلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","تْوَں مَہْیَں یَتْ کِنْچِدْ اَدَداسْتَتْسَرْوَّں تْوَتّو جایَتے اِتْیَدھُناجانَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","مَہْیَں یَمُپَدیشَمْ اَدَدا اَہَمَپِ تیبھْیَسْتَمُپَدیشَمْ اَدَداں تیپِ تَمَگرِہْلَنْ تْوَتّوہَں نِرْگَتْیَ تْوَیا پْریرِتوبھَوَمْ اَتْرَ چَ وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","تیشامیوَ نِمِتَّں پْرارْتھَیےہَں جَگَتو لوکَنِمِتَّں نَ پْرارْتھَیے کِنْتُ یالّوکانْ مَہْیَمْ اَدَداسْتیشامیوَ نِمِتَّں پْرارْتھَیےہَں یَتَسْتے تَوَیواسَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","یے مَمَ تے تَوَ یے چَ تَوَ تے مَمَ تَتھا تَے رْمَمَ مَہِما پْرَکاشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","سامْپْرَتَمْ اَسْمِنْ جَگَتِ مَماوَسْتھِتیح شیشَمْ اَبھَوَتْ اَہَں تَوَ سَمِیپَں گَچّھامِ کِنْتُ تے جَگَتِ سْتھاسْیَنْتِ؛ ہے پَوِتْرَ پِتَراوَیو رْیَتھَیکَتْوَماسْتے تَتھا تیشامَپْییکَتْوَں بھَوَتِ تَدَرْتھَں یالّوکانْ مَہْیَمْ اَدَداسْتانْ سْوَنامْنا رَکْشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","یاوَنْتِ دِنانِ جَگَتْیَسْمِنْ تَیح سَہاہَماسَں تاوَنْتِ دِنانِ تانْ تَوَ نامْناہَں رَکْشِتَوانْ؛ یالّوکانْ مَہْیَمْ اَدَداسْتانْ سَرْوّانْ اَہَمَرَکْشَں، تیشاں مَدھْیے کیوَلَں وِناشَپاتْرَں ہارِتَں تینَ دھَرْمَّپُسْتَکَسْیَ وَچَنَں پْرَتْیَکْشَں بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","کِنْتْوَدھُنا تَوَ سَنِّدھِں گَچّھامِ مَیا یَتھا تیشاں سَمْپُورْنانَنْدو بھَوَتِ تَدَرْتھَمَہَں جَگَتِ تِشْٹھَنْ ایتاح کَتھا اَکَتھَیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","تَووپَدیشَں تیبھْیودَداں جَگَتا سَہَ یَتھا مَمَ سَمْبَنْدھو ناسْتِ تَتھا جَجَتا سَہَ تیشامَپِ سَمْبَنْدھابھاواجْ جَگَتو لوکاسْتانْ رِتِییَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","تْوَں جَگَتَسْتانْ گرِہانیتِ نَ پْرارْتھَیے کِنْتْوَشُبھادْ رَکْشیتِ پْرارْتھَییہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","اَہَں یَتھا جَگَتْسَمْبَنْدھِییو نَ بھَوامِ تَتھا تیپِ جَگَتْسَمْبَنْدھِییا نَ بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","تَوَ سَتْیَکَتھَیا تانْ پَوِتْرِیکُرُ تَوَ واکْیَمیوَ سَتْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","تْوَں یَتھا ماں جَگَتِ پْرَیرَیَسْتَتھاہَمَپِ تانْ جَگَتِ پْرَیرَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","تیشاں ہِتارْتھَں یَتھاہَں سْوَں پَوِتْرِیکَرومِ تَتھا سَتْیَکَتھَیا تیپِ پَوِتْرِیبھَوَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","کیوَلَں ایتیشامَرْتھے پْرارْتھَیےہَمْ اِتِ نَ کِنْتْویتیشامُپَدیشینَ یے جَنا مَیِ وِشْوَسِشْیَنْتِ تیشامَپْیَرْتھے پْرارْتھییےہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ہے پِتَسْتیشاں سَرْوّیشامْ ایکَتْوَں بھَوَتُ تَوَ یَتھا مَیِ مَمَ چَ یَتھا تْوَیّیکَتْوَں تَتھا تیشامَپْیاوَیوریکَتْوَں بھَوَتُ تینَ تْوَں ماں پْریرِتَوانْ اِتِ جَگَتو لوکاح پْرَتِیَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","یَتھاوَیوریکَتْوَں تَتھا تیشامَپْییکَتْوَں بھَوَتُ تیشْوَہَں مَیِ چَ تْوَمْ اِتّھَں تیشاں سَمْپُورْنَمیکَتْوَں بھَوَتُ، تْوَں پْریرِتَوانْ تْوَں مَیِ یَتھا پْرِییَسے چَ تَتھا تیشْوَپِ پْرِیتَوانْ ایتَدْیَتھا جَگَتو لوکا جانَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","تَدَرْتھَں تْوَں یَں مَہِمانَں مَہْیَمْ اَدَداسْتَں مَہِمانَمْ اَہَمَپِ تیبھْیو دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ہے پِتَ رْجَگَتو نِرْمّاناتْ پُورْوَّں مَیِ سْنیہَں کرِتْوا یَں مَہِمانَں دَتَّوانْ مَمَ تَں مَہِمانَں یَتھا تے پَشْیَنْتِ تَدَرْتھَں یالّوکانْ مَہْیَں دَتَّوانْ اَہَں یَتْرَ تِشْٹھامِ تیپِ یَتھا تَتْرَ تِشْٹھَنْتِ مَمَیشا وانْچھا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ہے یَتھارْتھِکَ پِتَ رْجَگَتو لوکَیسْتْوَیَّجْناتیپِ تْوامَہَں جانے تْوَں ماں پْریرِتَوانْ اِتِیمے شِشْیا جانَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","یَتھاہَں تیشُ تِشْٹھامِ تَتھا مَیِ یینَ پْریمْنا پْریماکَروسْتَتْ تیشُ تِشْٹھَتِ تَدَرْتھَں تَوَ ناماہَں تانْ جْناپِتَوانْ پُنَرَپِ جْناپَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","تاح کَتھاح کَتھَیِتْوا یِیشُح شِشْیانادایَ کِدْرونّامَکَں سْروتَ اُتِّیرْیَّ شِشْیَیح سَہَ تَتْرَتْیودْیانَں پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","کِنْتُ وِشْواسَگھاتِیِہُوداسْتَتْ سْتھانَں پَرِچِییَتے یَتو یِیشُح شِشْیَیح سارْدّھَں کَداچِتْ تَتْ سْتھانَمْ اَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","تَدا سَ یِہُوداح سَینْیَگَنَں پْرَدھانَیاجَکاناں پھِرُوشِنانْچَ پَداتِگَنَنْچَ گرِہِیتْوا پْرَدِیپانْ اُلْکانْ اَسْتْرانِ چادایَ تَسْمِنْ سْتھانَ اُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","سْوَں پْرَتِ یَدْ گھَٹِشْیَتے تَجْ جْناتْوا یِیشُرَگْریسَرَح سَنْ تانَپرِچّھَتْ کَں گَویشَیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","تے پْرَتْیَوَدَنْ، ناسَرَتِییَں یِیشُں؛ تَتو یِیشُرَوادِیدْ اَہَمیوَ سَح؛ تَیح سَہَ وِشْواسَگھاتِی یِہُوداشْچاتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","تَداہَمیوَ سَ تَسْیَیتاں کَتھاں شْرُتْوَیوَ تے پَشْچادیتْیَ بھُومَو پَتِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","تَتو یِیشُح پُنَرَپِ پرِشْٹھَوانْ کَں گَویشَیَتھَ؟ تَتَسْتے پْرَتْیَوَدَنْ ناسَرَتِییَں یِیشُں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","تَدا یِیشُح پْرَتْیُدِتَوانْ اَہَمیوَ سَ اِماں کَتھامَچَکَتھَمْ؛ یَدِ مامَنْوِچّھَتھَ تَرْہِیمانْ گَنْتُں ما وارَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","اِتّھَں بھُوتے مَہْیَں یالّوکانْ اَدَداسْتیشامْ ایکَمَپِ ناہارَیَمْ اِماں یاں کَتھاں سَ سْوَیَمَکَتھَیَتْ سا کَتھا سَپھَلا جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","تَدا شِمونْپِتَرَسْیَ نِکَٹے کھَنْگَلْسْتھِتیح سَ تَں نِشْکوشَں کرِتْوا مَہایاجَکَسْیَ مالْکھَنامانَں داسَمْ آہَتْیَ تَسْیَ دَکْشِنَکَرْنَں چھِنَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","تَتو یِیشُح پِتَرَمْ اَوَدَتْ، کھَنْگَں کوشے سْتھاپَیَ مَمَ پِتا مَہْیَں پاتُں یَں کَںسَمْ اَدَداتْ تیناہَں کِں نَ پاسْیامِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","تَدا سَینْیَگَنَح سیناپَتِ رْیِہُودِییاناں پَداتَیَشْچَ یِیشُں گھرِتْوا بَدّھوا ہانَنّامْنَح کِیَپھاح شْوَشُرَسْیَ سَمِیپَں پْرَتھَمَمْ اَنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","سَ کِیَپھاسْتَسْمِنْ وَتْسَرے مَہایاجَتْوَپَدے نِیُکْتَح ");
INSERT INTO sanurd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","سَنْ سادھارَنَلوکاناں مَنْگَلارْتھَمْ ایکَجَنَسْیَ مَرَنَمُچِتَمْ اِتِ یِہُودِییَیح سارْدّھَمْ اَمَنْتْرَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","تَدا شِمونْپِتَرونْیَیکَشِشْیَشْچَ یِیشوح پَشْچادْ اَگَچّھَتاں تَسْیانْیَشِشْیَسْیَ مَہایاجَکینَ پَرِچِتَتْواتْ سَ یِیشُنا سَہَ مَہایاجَکَسْیاٹّالِکاں پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","کِنْتُ پِتَرو بَہِرْدْوارَسْیَ سَمِیپےتِشْٹھَدْ اَتَایوَ مَہایاجَکینَ پَرِچِتَح سَ شِشْیَح پُنَرْبَہِرْگَتْوا دَووایِکایَے کَتھَیِتْوا پِتَرَمْ اَبھْیَنْتَرَمْ آنَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","تَدا سَ دْوارَرَکْشِکا پِتَرَمْ اَوَدَتْ تْوَں کِں نَ تَسْیَ مانَوَسْیَ شِشْیَح؟ تَتَح سووَدَدْ اَہَں نَ بھَوامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","تَتَح پَرَں یَتْسْتھانے داساح پَداتَیَشْچَ شِیتَہیتورَنْگارَے رْوَہْنِں پْرَجْوالْیَ تاپَں سیوِتَوَنْتَسْتَتْسْتھانے پِتَرَسْتِشْٹھَنْ تَیح سَہَ وَہْنِتاپَں سیوِتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","تَدا شِشْییشُوپَدیشے چَ مَہایاجَکینَ یِیشُح پرِشْٹَح ");
INSERT INTO sanurd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","سَنْ پْرَتْیُکْتَوانْ سَرْوَّلوکاناں سَمَکْشَں کَتھامَکَتھَیَں گُپْتَں کامَپِ کَتھاں نَ کَتھَیِتْوا یَتْ سْتھانَں یِہُودِییاح سَتَتَں گَچّھَنْتِ تَتْرَ بھَجَنَگیہے مَنْدِرے چاشِکْشَیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","مَتَّح کُتَح پرِچّھَسِ؟ یے جَنا مَدُپَدیشَمْ اَشرِنْوَنْ تانیوَ پرِچّھَ یَدْیَدْ اَوَدَں تے تَتْ جانِنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","تَدیتّھَں پْرَتْیُدِتَتْواتْ نِکَٹَسْتھَپَداتِ رْیِیشُں چَپیٹیناہَتْیَ وْیاہَرَتْ مَہایاجَکَمْ ایوَں پْرَتِوَدَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","تَتو یِیشُح پْرَتِگَدِتَوانْ یَدْیَیَتھارْتھَمْ اَچَکَتھَں تَرْہِ تَسْیایَتھارْتھَسْیَ پْرَمانَں دیہِ، کِنْتُ یَدِ یَتھارْتھَں تَرْہِ کُتو ہیتو رْمامْ اَتاڈَیَح؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","پُورْوَّں ہانَنْ سَبَنْدھَنَں تَں کِیَپھامَہایاجَکَسْیَ سَمِیپَں پْرَیشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","شِمونْپِتَرَسْتِشْٹھَنْ وَہْنِتاپَں سیوَتے، ایتَسْمِنْ سَمَیے کِیَنْتَسْتَمْ اَپرِچّھَنْ تْوَں کِمْ ایتَسْیَ جَنَسْیَ شِشْیو نَ؟ تَتَح سوپَہْنُتْیابْرَوِیدْ اَہَں نَ بھَوامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","تَدا مَہایاجَکَسْیَ یَسْیَ داسَسْیَ پِتَرَح کَرْنَمَچّھِنَتْ تَسْیَ کُٹُمْبَح پْرَتْیُدِتَوانْ اُدْیانے تینَ سَہَ تِشْٹھَنْتَں تْواں کِں ناپَشْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","کِنْتُ پِتَرَح پُنَرَپَہْنُتْیَ کَتھِتَوانْ؛ تَدانِیں کُکُّٹورَوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","تَدَنَنْتَرَں پْرَتْیُوشے تے کِیَپھاگرِہادْ اَدھِپَتے رْگرِہَں یِیشُمْ اَنَیَنْ کِنْتُ یَسْمِنْ اَشُچِتْوے جاتے تَے رْنِسْتاروتْسَوے نَ بھوکْتَوْیَں، تَسْیَ بھَیادْ یِہُودِییاسْتَدْگرِہَں ناوِشَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","اَپَرَں پِیلاتو بَہِراگَتْیَ تانْ پرِشْٹھَوانْ ایتَسْیَ مَنُشْیَسْیَ کَں دوشَں وَدَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","تَدا تے پیتْیَوَدَنْ دُشْکَرْمَّکارِنِ نَ سَتِ بھَوَتَح سَمِیپے نَینَں سَمارْپَیِشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","تَتَح پِیلاتووَدَدْ یُویَمینَں گرِہِیتْوا سْویشاں وْیَوَسْتھَیا وِچارَیَتَ۔ تَدا یِہُودِییاح پْرَتْیَوَدَنْ کَسْیاپِ مَنُشْیَسْیَ پْرانَدَنْڈَں کَرْتُّں ناسْماکَمْ اَدھِکاروسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ایوَں سَتِ یِیشُح سْوَسْیَ مرِتْیَو یاں کَتھاں کَتھِتَوانْ سا سَپھَلابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","تَدَنَنْتَرَں پِیلاتَح پُنَرَپِ تَدْ راجَگرِہَں گَتْوا یِیشُماہُویَ پرِشْٹَوانْ تْوَں کِں یِہُودِییاناں راجا؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","یِیشُح پْرَتْیَوَدَتْ تْوَمْ ایتاں کَتھاں سْوَتَح کَتھَیَسِ کِمَنْیَح کَشْچِنْ مَیِ کَتھِتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","پِیلاتووَدَدْ اَہَں کِں یِہُودِییَح؟ تَوَ سْوَدیشِییا وِشیشَتَح پْرَدھانَیاجَکا مَمَ نِکَٹے تْواں سَمارْپَیَنَ، تْوَں کِں کرِتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","یِیشُح پْرَتْیَوَدَتْ مَمَ راجْیَمْ ایتَجَّگَتْسَمْبَنْدھِییَں نَ بھَوَتِ یَدِ مَمَ راجْیَں جَگَتْسَمْبَنْدھِییَمْ اَبھَوِشْیَتْ تَرْہِ یِہُودِییاناں ہَسْتیشُ یَتھا سَمَرْپِتو نابھَوَں تَدَرْتھَں مَمَ سیوَکا اَیوتْسْیَنْ کِنْتُ مَمَ راجْیَمْ اَیہِکَں نَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","تَدا پِیلاتَح کَتھِتَوانْ، تَرْہِ تْوَں راجا بھَوَسِ؟ یِیشُح پْرَتْیُکْتَوانْ تْوَں سَتْیَں کَتھَیَسِ، راجاہَں بھَوامِ؛ سَتْیَتایاں ساکْشْیَں داتُں جَنِں گرِہِیتْوا جَگَتْیَسْمِنْ اَوَتِیرْنَوانْ، تَسْماتْ سَتْیَدھَرْمَّپَکْشَپاتِنو مَمَ کَتھاں شرِنْوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","تَدا سَتْیَں کِں؟ ایتاں کَتھاں پَشْٹْوا پِیلاتَح پُنَرَپِ بَہِرْگَتْوا یِہُودِییانْ اَبھاشَتَ، اَہَں تَسْیَ کَمَپْیَپَرادھَں نَ پْراپْنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","نِسْتاروتْسَوَسَمَیے یُشْمابھِرَبھِرُچِتَ ایکو جَنو مَیا موچَیِتَوْیَ ایشا یُشْماکَں رِیتِرَسْتِ، اَتَایوَ یُشْماکَں نِکَٹے یِہُودِییاناں راجانَں کِں موچَیامِ، یُشْماکَمْ اِچّھا کا؟ ");
INSERT INTO sanurd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","تَدا تے سَرْوّے رُوَنْتو وْیاہَرَنْ اینَں مانُشَں نَہِ بَرَبّاں موچَیَ۔ کِنْتُ سَ بَرَبّا دَسْیُراسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","پِیلاتو یِیشُمْ آنِییَ کَشَیا پْراہارَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","پَشْچاتْ سیناگَنَح کَنْٹَکَنِرْمِّتَں مُکُٹَں تَسْیَ مَسْتَکے سَمَرْپْیَ وارْتّاکِیوَرْنَں راجَپَرِچّھَدَں پَرِدھاپْیَ، ");
INSERT INTO sanurd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ہے یِہُودِییاناں راجَنْ نَمَسْکارَ اِتْیُکْتْوا تَں چَپیٹیناہَنْتُمْ آرَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","تَدا پِیلاتَح پُنَرَپِ بَہِرْگَتْوا لوکانْ اَوَدَتْ، اَسْیَ کَمَپْیَپَرادھَں نَ لَبھےہَں، پَشْیَتَ تَدْ یُشْمانْ جْناپَیِتُں یُشْماکَں سَنِّدھَو بَہِرینَمْ آنَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","تَتَح پَرَں یِیشُح کَنْٹَکَمُکُٹَوانْ وارْتّاکِیوَرْنَوَسَنَواںشْچَ بَہِراگَچّھَتْ۔ تَتَح پِیلاتَ اُکْتَوانْ اینَں مَنُشْیَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","تَدا پْرَدھانَیاجَکاح پَداتَیَشْچَ تَں درِشْٹْوا، اینَں کْرُشے وِدھَ، اینَں کْرُشے وِدھَ، اِتْیُکْتْوا رَوِتُں آرَبھَنْتَ۔ تَتَح پِیلاتَح کَتھِتَوانْ یُویَں سْوَیَمْ اینَں نِیتْوا کْرُشے وِدھَتَ، اَہَمْ ایتَسْیَ کَمَپْیَپَرادھَں نَ پْراپْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","یِہُودِییاح پْرَتْیَوَدَنْ اَسْماکَں یا وْیَوَسْتھاسْتے تَدَنُساریناسْیَ پْرانَہَنَنَمْ اُچِتَں یَتویَں سْوَمْ اِیشْوَرَسْیَ پُتْرَمَوَدَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","پِیلاتَ اِماں کَتھاں شْرُتْوا مَہاتْراسَیُکْتَح ");
INSERT INTO sanurd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","سَنْ پُنَرَپِ راجَگرِہَ آگَتْیَ یِیشُں پرِشْٹَوانْ تْوَں کُتْرَتْیو لوکَح؟ کِنْتُ یِیشَسْتَسْیَ کِمَپِ پْرَتْیُتَّرَں ناوَدَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","۱॰ تَتَح پِیلاتْ کَتھِتَوانَ تْوَں کِں مَیا سارْدّھَں نَ سَںلَپِشْیَسِ ؟ تْواں کْرُشے ویدھِتُں وا موچَیِتُں شَکْتِ رْمَماسْتے اِتِ کِں تْوَں نَ جاناسِ ؟ تَدا یِیشُح پْرَتْیَوَدَدْ اِیشْوَرینادَŸाں مَموپَرِ تَوَ کِمَپْیَدھِپَتِتْوَں نَ وِدْیَتے، تَتھاپِ یو جَنو ماں تَوَ ہَسْتے سَمارْپَیَتْ تَسْیَ مَہاپاتَکَں جاتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","تَدا یِیشُح پْرَتْیَوَدَدْ اِیشْوَرینادَتَّں مَموپَرِ تَوَ کِمَپْیَدھِپَتِتْوَں نَ وِدْیَتے، تَتھاپِ یو جَنو ماں تَوَ ہَسْتے سَمارْپَیَتْ تَسْیَ مَہاپاتَکَں جاتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","تَدارَبھْیَ پِیلاتَسْتَں موچَیِتُں چیشْٹِتَوانْ کِنْتُ یِہُودِییا رُوَنْتو وْیاہَرَنْ یَدِیمَں مانَوَں تْیَجَسِ تَرْہِ تْوَں کَیسَرَسْیَ مِتْرَں نَ بھَوَسِ، یو جَنَح سْوَں راجانَں وَکْتِ سَایوَ کَیمَرَسْیَ وِرُدّھاں کَتھاں کَتھَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ایتاں کَتھاں شْرُتْوا پِیلاتو یِیشُں بَہِرانِییَ نِسْتاروتْسَوَسْیَ آسادَنَدِنَسْیَ دْوِتِییَپْرَہَراتْ پُورْوَّں پْرَسْتَرَبَنْدھَنَنامْنِ سْتھانے رْتھاتْ اِبْرِییَبھاشَیا یَدْ گَبِّتھا کَتھْیَتے تَسْمِنْ سْتھانے وِچاراسَنَ اُپاوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","اَنَنْتَرَں پِیلاتو یِہُودِییانْ اَوَدَتْ، یُشْماکَں راجانَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","کِنْتُ اینَں دُورِیکُرُ، اینَں دُورِیکُرُ، اینَں کْرُشے وِدھَ، اِتِ کَتھاں کَتھَیِتْوا تے رَوِتُمْ آرَبھَنْتَ؛ تَدا پِیلاتَح کَتھِتَوانْ یُشْماکَں راجانَں کِں کْرُشے ویدھِشْیامِ؟ پْرَدھانَیاجَکا اُتَّرَمْ اَوَدَنْ کَیسَرَں وِنا کوپِ راجاسْماکَں ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","تَتَح پِیلاتو یِیشُں کْرُشے ویدھِتُں تیشاں ہَسْتیشُ سَمارْپَیَتْ، تَتَسْتے تَں دھرِتْوا نِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","تَتَح پَرَں یِیشُح کْرُشَں وَہَنْ شِرَحکَپالَمْ اَرْتھادْ یَدْ اِبْرِییَبھاشَیا گُلْگَلْتاں وَدَنْتِ تَسْمِنْ سْتھانَ اُپَسْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","تَتَسْتے مَدھْیَسْتھانے تَں تَسْیوبھَیَپارْشْوے دْواوَپَرَو کْرُشےوِدھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","اَپَرَمْ ایشَ یِہُودِییاناں راجا ناسَرَتِییَیِیشُح، اِتِ وِجْناپَنَں لِکھِتْوا پِیلاتَسْتَسْیَ کْرُشوپَرِ سَمَیوجَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","سا لِپِح اِبْرِییَیُونانِییَرومِییَبھاشابھِ رْلِکھِتا؛ یِیشوح کْرُشَویدھَنَسْتھانَں نَگَرَسْیَ سَمِیپَں، تَسْمادْ بَہَوو یِہُودِییاسْتاں پَٹھِتُمْ آرَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","یِہُودِییاناں پْرَدھانَیاجَکاح پِیلاتَمِتِ نْیَویدَیَنْ یِہُودِییاناں راجیتِ واکْیَں نَ کِنْتُ ایشَ سْوَں یِہُودِییاناں راجانَمْ اَوَدَدْ اِتّھَں لِکھَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","تَتَح پِیلاتَ اُتَّرَں دَتَّوانْ یَلّیکھَنِییَں تَلِّکھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","اِتّھَں سیناگَنو یِیشُں کْرُشے وِدھِتْوا تَسْیَ پَرِدھییَوَسْتْرَں چَتُرو بھاگانْ کرِتْوا ایکَیکَسینا ایکَیکَبھاگَمْ اَگرِہْلَتْ تَسْیوتَّرِییَوَسْتْرَنْچاگرِہْلَتْ۔ کِنْتُوتَّرِییَوَسْتْرَں سُوچِسیوَنَں وِنا سَرْوَّمْ اُوتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","تَسْماتّے وْیاہَرَنْ ایتَتْ کَح پْراپْسْیَتِ؟ تَنَّ کھَنْڈَیِتْوا تَتْرَ گُٹِکاپاتَں کَرَوامَ۔ وِبھَجَنْتےدھَرِییَں مے وَسَنَں تے پَرَسْپَرَں۔ مَموتَّرِییَوَسْتْرارْتھَں گُٹِکاں پاتَیَنْتِ چَ۔ اِتِ یَدْواکْیَں دھَرْمَّپُسْتَکے لِکھِتَماسْتے تَتْ سیناگَنینیتّھَں وْیَوَہَرَناتْ سِدّھَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","تَدانِیں یِیشو رْماتا ماتُ رْبھَگِنِی چَ یا کْلِیَپا بھارْیّا مَرِیَمْ مَگْدَلِینِی مَرِیَمْ چَ ایتاسْتَسْیَ کْرُشَسْیَ سَنِّدھَو سَمَتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","تَتو یِیشُح سْوَماتَرَں پْرِیَتَمَشِشْیَنْچَ سَمِیپے دَنْڈایَمانَو وِلوکْیَ ماتَرَمْ اَوَدَتْ، ہے یوشِدْ اینَں تَوَ پُتْرَں پَشْیَ، ");
INSERT INTO sanurd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","شِشْیَنْتْوَوَدَتْ، ایناں تَوَ ماتَرَں پَشْیَ۔ تَتَح سَ شِشْیَسْتَدْگھَٹِکایاں تاں نِجَگرِہَں نِیتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","اَنَنْتَرَں سَرْوَّں کَرْمّادھُنا سَمْپَنَّمَبھُوتْ یِیشُرِتِ جْناتْوا دھَرْمَّپُسْتَکَسْیَ وَچَنَں یَتھا سِدّھَں بھَوَتِ تَدَرْتھَمْ اَکَتھَیَتْ مَمَ پِپاسا جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","تَتَسْتَسْمِنْ سْتھانے اَمْلَرَسینَ پُورْنَپاتْرَسْتھِتْیا تے سْپَنْجَمیکَں تَدَمْلَرَسینارْدْرِیکرِتْیَ ایسوبْنَلے تَدْ یوجَیِتْوا تَسْیَ مُکھَسْیَ سَنِّدھاوَسْتھاپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","تَدا یِیشُرَمْلَرَسَں گرِہِیتْوا سَرْوَّں سِدّھَمْ اِتِ کَتھاں کَتھَیِتْوا مَسْتَکَں نَمَیَنْ پْرانانْ پَرْیَّتْیَجَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","تَدْوِنَمْ آسادَنَدِنَں تَسْماتْ پَرےہَنِ وِشْرامَوارے دیہا یَتھا کْرُشوپَرِ نَ تِشْٹھَنْتِ، یَتَح سَ وِشْرامَوارو مَہادِنَماسِیتْ، تَسْمادْ یِہُودِییاح پِیلاتَنِکَٹَں گَتْوا تیشاں پادَبھَنْجَنَسْیَ سْتھانانْتَرَنَیَنَسْیَ چانُمَتِں پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","اَتَح سینا آگَتْیَ یِیشُنا سَہَ کْرُشے ہَتَیوح پْرَتھَمَدْوِتِییَچورَیوح پادانْ اَبھَنْجَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","کِنْتُ یِیشوح سَنِّدھِں گَتْوا سَ مرِتَ اِتِ درِشْٹْوا تَسْیَ پادَو نابھَنْجَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","پَشْچادْ ایکو یودّھا شُولاگھاتینَ تَسْیَ کُکْشِمْ اَوِدھَتْ تَتْکْشَناتْ تَسْمادْ رَکْتَں جَلَنْچَ نِرَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","یو جَنوسْیَ ساکْشْیَں دَداتِ سَ سْوَیَں درِشْٹَوانْ تَسْییدَں ساکْشْیَں سَتْیَں تَسْیَ کَتھا یُشْماکَں وِشْواسَں جَنَیِتُں یوگْیا تَتْ سَ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","تَسْیَیکَمْ اَسْدھْیَپِ نَ بھَںکْشْیَتے، ");
INSERT INTO sanurd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","تَدْوَدْ اَنْیَشاسْتْریپِ لِکھْیَتے، یَتھا، \"درِشْٹِپاتَں کَرِشْیَنْتِ تےوِدھَنْ یَنْتُ تَمْپْرَتِ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","اَرِمَتھِییَنَگَرَسْیَ یُوشَپھْناما شِشْیَ ایکَ آسِیتْ کِنْتُ یِہُودِیییبھْیو بھَیاتْ پْرَکاشِتو نَ بھَوَتِ؛ سَ یِیشو رْدیہَں نیتُں پِیلاتَسْیانُمَتِں پْرارْتھَیَتَ، تَتَح پِیلاتینانُمَتے سَتِ سَ گَتْوا یِیشو رْدیہَمْ اَنَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","اَپَرَں یو نِکَدِیمو راتْرَو یِیشوح سَمِیپَمْ اَگَچّھَتْ سوپِ گَنْدھَرَسینَ مِشْرِتَں پْرایینَ پَنْچاشَتْسیٹَکَمَگُرُں گرِہِیتْواگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","تَتَسْتے یِہُودِییاناں شْمَشانے سْتھاپَنَرِیتْیَنُسارینَ تَتْسُگَنْدھِدْرَوْیینَ سَہِتَں تَسْیَ دیہَں وَسْتْریناویشْٹَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","اَپَرَنْچَ یَتْرَ سْتھانے تَں کْرُشےوِدھَنْ تَسْیَ نِکَٹَسْتھودْیانے یَتْرَ کِمَپِ مرِتَدیہَں کَداپِ ناسْتھاپْیَتَ تادرِشَمْ ایکَں نُوتَنَں شْمَشانَمْ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","یِہُودِییانامْ آسادَنَدِناگَمَناتْ تے تَسْمِنْ سَمِیپَسْتھَشْمَشانے یِیشُمْ اَشایَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","اَنَنْتَرَں سَپْتاہَسْیَ پْرَتھَمَدِنے تِپْرَتْیُوشے نْدھَکارے تِشْٹھَتِ مَگْدَلِینِی مَرِیَمْ تَسْیَ شْمَشانَسْیَ نِکَٹَں گَتْوا شْمَشانَسْیَ مُکھاتْ پْرَسْتَرَمَپَسارِتَمْ اَپَشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","پَشْچادْ دھاوِتْوا شِمونْپِتَرایَ یِیشوح پْرِیَتَمَشِشْیایَ چیدَمْ اَکَتھَیَتْ، لوکاح شْمَشاناتْ پْرَبھُں نِیتْوا کُتْراسْتھاپَیَنْ تَدْ وَکْتُں نَ شَکْنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","اَتَح پِتَرَح سونْیَشِشْیَشْچَ بَرْہِ رْبھُتْوا شْمَشانَسْتھانَں گَنْتُمْ آرَبھیتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","اُبھَیورْدھاوَتوح سونْیَشِشْیَح پِتَرَں پَشْچاتْ تْیَکْتْوا پُورْوَّں شْمَشانَسْتھانَ اُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","تَدا پْرَہْوِیبھُویَ سْتھاپِتَوَسْتْرانِ درِشْٹَوانْ کِنْتُ نَ پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","اَپَرَں شِمونْپِتَرَ آگَتْیَ شْمَشانَسْتھانَں پْرَوِشْیَ ");
INSERT INTO sanurd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","سْتھاپِتَوَسْتْرانِ مَسْتَکَسْیَ وَسْتْرَنْچَ پرِتھَکْ سْتھانانْتَرے سْتھاپِتَں درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","تَتَح شْمَشانَسْتھانَں پُورْوَّمْ آگَتو یونْیَشِشْیَح سوپِ پْرَوِشْیَ تادرِشَں درِشْٹا وْیَشْوَسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","یَتَح شْمَشاناتْ سَ اُتّھاپَیِتَوْیَ ایتَسْیَ دھَرْمَّپُسْتَکَوَچَنَسْیَ بھاوَں تے تَدا وودّھُں ناشَنْکُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","اَنَنْتَرَں تَو دْوَو شِشْیَو سْوَں سْوَں گرِہَں پَراورِتْیاگَچّھَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","تَتَح پَرَں مَرِیَمْ شْمَشانَدْوارَسْیَ بَہِح سْتھِتْوا رودِتُمْ آرَبھَتَ تَتو رُدَتِی پْرَہْوِیبھُویَ شْمَشانَں وِلوکْیَ ");
INSERT INTO sanurd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","یِیشوح شَیَنَسْتھانَسْیَ شِرَحسْتھانے پَدَتَلے چَ دْوَیو رْدِشو دْوَو سْوَرْگِییَدُوتاوُپَوِشْٹَو سَمَپَشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","تَو پرِشْٹَوَنْتَو ہے نارِ کُتو رودِشِ؟ ساوَدَتْ لوکا مَمَ پْرَبھُں نِیتْوا کُتْراسْتھاپَیَنْ اِتِ نَ جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","اِتْیُکْتْوا مُکھَں پَراورِتْیَ یِیشُں دَنْڈایَمانَمْ اَپَشْیَتْ کِنْتُ سَ یِیشُرِتِ سا جْناتُں ناشَکْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","تَدا یِیشُسْتامْ اَپرِچّھَتْ ہے نارِ کُتو رودِشِ؟ کَں وا مرِگَیَسے؟ تَتَح سا تَمْ اُدْیانَسیوَکَں جْناتْوا وْیاہَرَتْ، ہے مَہیچّھَ تْوَں یَدِیتَح سْتھاناتْ تَں نِیتَوانْ تَرْہِ کُتْراسْتھاپَیَسْتَدْ وَدَ تَتْسْتھاناتْ تَمْ آنَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","تَدا یِیشُسْتامْ اَوَدَتْ ہے مَرِیَمْ۔ تَتَح سا پَراورِتْیَ پْرَتْیَوَدَتْ ہے رَبُّونِی اَرْتھاتْ ہے گُرو۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","تَدا یِیشُرَوَدَتْ ماں ما دھَرَ، اِدانِیں پِتُح سَمِیپے اُورْدّھوَگَمَنَں نَ کَرومِ کِنْتُ یو مَمَ یُشْماکَنْچَ پِتا مَمَ یُشْماکَنْچیشْوَرَسْتَسْیَ نِکَٹَ اُورْدّھوَگَمَنَں کَرْتُّمْ اُدْیَتوسْمِ، اِماں کَتھاں تْوَں گَتْوا مَمَ بھْراترِگَنَں جْناپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","تَتو مَگْدَلِینِیمَرِیَمْ تَتْکْشَنادْ گَتْوا پْرَبھُسْتَسْیَے دَرْشَنَں دَتّوا کَتھا ایتا اَکَتھَیَدْ اِتِ وارْتّاں شِشْییبھْیوکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","تَتَح پَرَں سَپْتاہَسْیَ پْرَتھَمَدِنَسْیَ سَنْدھْیاسَمَیے شِشْیا ایکَتْرَ مِلِتْوا یِہُودِیییبھْیو بھِیا دْوارَرُدّھَمْ اَکُرْوَّنْ، ایتَسْمِنْ کالے یِیشُسْتیشاں مَدھْیَسْتھانے تِشْٹھَنْ اَکَتھَیَدْ یُشْماکَں کَلْیانَں بھُویاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","اِتْیُکْتْوا نِجَہَسْتَں کُکْشِنْچَ دَرْشِتَوانْ، تَتَح شِشْیاح پْرَبھُں درِشْٹْوا ہرِشْٹا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","یِیشُح پُنَرَوَدَدْ یُشْماکَں کَلْیانَں بھُویاتْ پِتا یَتھا ماں پْرَیشَیَتْ تَتھاہَمَپِ یُشْمانْ پْریشَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","اِتْیُکْتْوا سَ تیشامُپَرِ دِیرْگھَپْرَشْواسَں دَتّوا کَتھِتَوانْ پَوِتْرَمْ آتْمانَں گرِہْلِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","یُویَں ییشاں پاپانِ موچَیِشْیَتھَ تے موچَیِشْیَنْتے ییشانْچَ پاپاتِ نَ موچَیِشْیَتھَ تے نَ موچَیِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","دْوادَشَمَدھْیے گَنِتو یَمَجو تھوماناما شِشْیو یِیشوراگَمَنَکالَے تَیح سارْدّھَں ناسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","اَتو وَیَں پْرَبھُومْ اَپَشْیامیتِ واکْیےنْیَشِشْیَیرُکْتے سووَدَتْ، تَسْیَ ہَسْتَیو رْلَوہَکِیلَکاناں چِہْنَں نَ وِلوکْیَ تَچِّہْنَمْ اَنْگُلْیا نَ سْپرِشْٹْوا تَسْیَ کُکْشَو ہَسْتَں ناروپْیَ چاہَں نَ وِشْوَسِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","اَپَرَمْ اَشْٹَمےہْنِ گَتے سَتِ تھوماسَہِتَح شِشْیَگَنَ ایکَتْرَ مِلِتْوا دْوارَں رُدّھوابھْیَنْتَرَ آسِیتْ، ایتَرْہِ یِیشُسْتیشاں مَدھْیَسْتھانے تِشْٹھَنْ اَکَتھَیَتْ، یُشْماکَں کُشَلَں بھُویاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","پَشْچاتْ تھامَے کَتھِتَوانْ تْوَمْ اَنْگُلِیمْ اَتْرارْپَیِتْوا مَمَ کَرَو پَشْیَ کَرَں پْرَسارْیَّ مَمَ کُکْشاوَرْپَیَ ناوِشْوَسْیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","تَدا تھوما اَوَدَتْ، ہے مَمَ پْرَبھو ہے مَدِیشْوَرَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","یِیشُرَکَتھَیَتْ، ہے تھوما ماں نِرِیکْشْیَ وِشْوَسِشِ یے نَ درِشْٹْوا وِشْوَسَنْتِ تَایوَ دھَنْیاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ایتَدَنْیانِ پُسْتَکےسْمِنْ اَلِکھِتانِ بَہُونْیاشْچَرْیَّکَرْمّانِ یِیشُح شِشْیاناں پُرَسْتادْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","کِنْتُ یِیشُرِیشْوَرَسْیابھِشِکْتَح سُتَ ایویتِ یَتھا یُویَں وِشْوَسِتھَ وِشْوَسْیَ چَ تَسْیَ نامْنا پَرَمایُح پْراپْنُتھَ تَدَرْتھَمْ ایتانِ سَرْوّانْیَلِکھْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","تَتَح پَرَں تِبِرِیاجَلَدھیسْتَٹے یِیشُح پُنَرَپِ شِشْییبھْیو دَرْشَنَں دَتَّوانْ دَرْشَنَسْیاکھْیانَمِدَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","شِمونْپِتَرَح یَمَجَتھوما گالِیلِییَکانّانَگَرَنِواسِی نِتھَنیلْ سِوَدیح پُتْراوَنْیَو دْوَو شِشْیَو چَیتیشْویکَتْرَ مِلِتیشُ شِمونْپِتَروکَتھَیَتْ مَتْسْیانْ دھَرْتُں یامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","تَتَسْتے وْیاہَرَنْ تَرْہِ وَیَمَپِ تْوَیا سارْدّھَں یامَح تَدا تے بَہِرْگَتاح سَنْتَح کْشِپْرَں ناوَمْ آروہَنْ کِنْتُ تَسْیاں رَجَنْیامْ ایکَمَپِ نَ پْراپْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","پْرَبھاتے سَتِ یِیشُسْتَٹے سْتھِتَوانْ کِنْتُ سَ یِیشُرِتِ شِشْیا جْناتُں ناشَکْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","تَدا یِیشُرَپرِچّھَتْ، ہے وَتْسا سَنِّدھَو کِنْچِتْ کھادْیَدْرَوْیَمْ آسْتے؟ تےوَدَنْ کِمَپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","تَدا سووَدَتْ نَوکایا دَکْشِنَپارْشْوے جالَں نِکْشِپَتَ تَتو لَپْسْیَدھْوے، تَسْماتْ تَے رْنِکْشِپْتے جالے مَتْسْیا ایتاوَنْتوپَتَنْ یینَ تے جالَماکرِشْیَ نوتّولَیِتُں شَکْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","تَسْمادْ یِیشوح پْرِیَتَمَشِشْیَح پِتَرایاکَتھَیَتْ ایشَ پْرَبھُ رْبھَویتْ، ایشَ پْرَبھُرِتِ واچَں شْرُتْوَیوَ شِمونْ نَگْنَتاہیتو رْمَتْسْیَدھارِنَ اُتَّرِییَوَسْتْرَں پَرِدھایَ ہْرَدَں پْرَتْیُدَلَمْپھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","اَپَرے شِشْیا مَتْسْیَیح سارْدّھَں جالَمْ آکَرْشَنْتَح کْشُدْرَنَوکاں واہَیِتْوا کُولَمانَیَنْ تے کُولادْ اَتِدُورے ناسَنْ دْوِشَتَہَسْتیبھْیو دُورَ آسَنْ اِتْیَنُمِییَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","تِیرَں پْراپْتَیسْتَیسْتَتْرَ پْرَجْوَلِتاگْنِسْتَدُپَرِ مَتْسْیاح پُوپاشْچَ درِشْٹاح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","تَتو یِیشُرَکَتھَیَدْ یانْ مَتْسْیانْ اَدھَرَتَ تیشاں کَتِپَیانْ آنَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","اَتَح شِمونْپِتَرَح پَراورِتْیَ گَتْوا برِہَدْبھِسْتْرِپَنْچاشَدَدھِکَشَتَمَتْسْیَیح پَرِپُورْنَں تَجّالَمْ آکرِشْیودَتولَیَتْ کِنْتْویتاوَدْبھِ رْمَتْسْیَیرَپِ جالَں ناچھِدْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","اَنَنْتَرَں یِیشُسْتانْ اَوادِیتْ یُویَماگَتْیَ بھُںگْدھْوَں؛ تَدا سَایوَ پْرَبھُرِتِ جْناتَتْواتْ تْوَں کَح؟ اِتِ پْرَشْٹُں شِشْیاناں کَسْیاپِ پْرَگَلْبھَتا نابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","تَتو یِیشُراگَتْیَ پُوپانْ مَتْسْیاںشْچَ گرِہِیتْوا تیبھْیَح پَرْیَّویشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","اِتّھَں شْمَشانادُتّھاناتْ پَرَں یِیشُح شِشْییبھْیَسْترِتِییَوارَں دَرْشَنَں دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","بھوجَنے سَماپْتے سَتِ یِیشُح شِمونْپِتَرَں پرِشْٹَوانْ، ہے یُونَسَح پُتْرَ شِمونْ تْوَں کِمْ ایتیبھْیودھِکَں مَیِ پْرِییَسے؟ تَتَح سَ اُدِتَوانْ سَتْیَں پْرَبھو تْوَیِ پْرِییےہَں تَدْ بھَوانْ جاناتِ؛ تَدا یِیشُرَکَتھَیَتْ تَرْہِ مَمَ میشَشاوَکَگَنَں پالَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","تَتَح سَ دْوِتِییَوارَں پرِشْٹَوانْ ہے یُونَسَح پُتْرَ شِمونْ تْوَں کِں مَیِ پْرِییَسے؟ تَتَح سَ اُکْتَوانْ سَتْیَں پْرَبھو تْوَیِ پْرِییےہَں تَدْ بھَوانْ جاناتِ؛ تَدا یِیشُرَکَتھَیَتَ تَرْہِ مَمَ میشَگَنَں پالَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","پَشْچاتْ سَ ترِتِییَوارَں پرِشْٹَوانْ، ہے یُونَسَح پُتْرَ شِمونْ تْوَں کِں مَیِ پْرِییَسے؟ ایتَدْواکْیَں ترِتِییَوارَں پرِشْٹَوانْ تَسْماتْ پِتَرو دُحکھِتو بھُوتْواکَتھَیَتْ ہے پْرَبھو بھَوَتَح کِمَپْیَگوچَرَں ناسْتِ تْوَیَّہَں پْرِییے تَدْ بھَوانْ جاناتِ؛ تَتو یِیشُرَوَدَتْ تَرْہِ مَمَ میشَگَنَں پالَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","اَہَں تُبھْیَں یَتھارْتھَں کَتھَیامِ یَووَنَکالے سْوَیَں بَدّھَکَٹِ رْیَتْریچّھا تَتْرَ یاتَوانْ کِنْتْوِتَح پَرَں ورِدّھے وَیَسِ ہَسْتَں وِسْتارَیِشْیَسِ، اَنْیَجَنَسْتْواں بَدّھوا یَتْرَ گَنْتُں تَویچّھا نَ بھَوَتِ تْواں دھرِتْوا تَتْرَ نیشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","پھَلَتَح کِیدرِشینَ مَرَنینَ سَ اِیشْوَرَسْیَ مَہِمانَں پْرَکاشَیِشْیَتِ تَدْ بودھَیِتُں سَ اِتِ واکْیَں پْروکْتَوانْ۔ اِتْیُکْتے سَتِ سَ تَمَووچَتْ مَمَ پَشْچادْ آگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","یو جَنو راتْرِکالے یِیشو رْوَکْشووَلَمْبْیَ، ہے پْرَبھو کو بھَوَنْتَں پَرَکَریشُ سَمَرْپَیِشْیَتِیتِ واکْیَں پرِشْٹَوانْ، تَں یِیشوح پْرِیَتَمَشِشْیَں پَشْچادْ آگَچّھَنْتَں ");
INSERT INTO sanurd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","پِتَرو مُکھَں پَراوَرْتّیَ وِلوکْیَ یِیشُں پرِشْٹَوانْ، ہے پْرَبھو ایتَسْیَ مانَوَسْیَ کِیدرِشِی گَتِ رْبھَوِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","سَ پْرَتْیَوَدَتْ، مَمَ پُنَراگَمَنَپَرْیَّنْتَں یَدِ تَں سْتھاپَیِتُمْ اِچّھامِ تَتْرَ تَوَ کِں؟ تْوَں مَمَ پَشْچادْ آگَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","تَسْماتْ سَ شِشْیو نَ مَرِشْیَتِیتِ بھْراترِگَنَمَدھْیے کِںوَدَنْتِی جاتا کِنْتُ سَ نَ مَرِشْیَتِیتِ واکْیَں یِیشُ رْناوَدَتْ کیوَلَں مَمَ پُنَراگَمَنَپَرْیَّنْتَں یَدِ تَں سْتھاپَیِتُمْ اِچّھامِ تَتْرَ تَوَ کِں؟ اِتِ واکْیَمْ اُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","یو جَنَ ایتانِ سَرْوّانِ لِکھِتَوانْ اَتْرَ ساکْشْیَنْچَ دَتَّوانْ سَایوَ سَ شِشْیَح، تَسْیَ ساکْشْیَں پْرَمانَمِتِ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","یِیشُریتیبھْیوپَرانْیَپِ بَہُونِ کَرْمّانِ کرِتَوانْ تانِ سَرْوّانِ یَدْییکَیکَں کرِتْوا لِکھْیَنْتے تَرْہِ گْرَنْتھا ایتاوَنْتو بھَوَنْتِ تیشاں دھارَنے پرِتھِوْیاں سْتھانَں نَ بھَوَتِ۔ اِتِ۔۔");
INSERT INTO sanurd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ہے تھِیَپھِلَ، یِیشُح سْوَمَنونِیتانْ پْریرِتانْ پَوِتْریناتْمَنا سَمادِشْیَ یَسْمِنْ دِنے سْوَرْگَماروہَتْ یاں یاں کْرِیامَکَروتْ یَدْیَدْ اُپادِشَچَّ تانِ سَرْوّانِ پُورْوَّں مَیا لِکھِتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","سَ سْوَنِدھَنَدُحکھَبھوگاتْ پَرَمْ اَنیکَپْرَتْیَیَکْشَپْرَمانَوح سْوَں سَجِیوَں دَرْشَیِتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","چَتْوارِںشَدِّنانِ یاوَتْ تیبھْیَح پْریرِتیبھْیو دَرْشَنَں دَتّویشْوَرِییَراجْیَسْیَ وَرْنَنَمَ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","اَنَنْتَرَں تیشاں سَبھاں کرِتْوا اِتْیاجْناپَیَتْ، یُویَں یِرُوشالَمونْیَتْرَ گَمَنَمَکرِتْوا یَسْتِنْ پِتْرانْگِیکرِتے مَمَ وَدَناتْ کَتھا اَشرِنُتَ تَتْپْراپْتِمْ اَپیکْشْیَ تِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","یوہَنْ جَلے مَجِّتاوانْ کِنْتْوَلْپَدِنَمَدھْیے یُویَں پَوِتْرَ آتْمَنِ مَجِّتا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","پَشْچاتْ تے سَرْوّے مِلِتْوا تَمْ اَپرِچّھَنْ ہے پْرَبھو بھَوانْ کِمِدانِیں پُنَرَپِ راجْیَمْ اِسْراییلِییَلوکاناں کَریشُ سَمَرْپَیِشْیَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","تَتَح سووَدَتْ یانْ سَرْوّانْ کالانْ سَمَیاںشْچَ پِتا سْوَوَشےسْتھاپَیَتْ تانْ جْناترِں یُشْماکَمْ اَدھِکارو نَ جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","کِنْتُ یُشْماسُ پَوِتْرَسْیاتْمَنَ آوِرْبھاوے سَتِ یُویَں شَکْتِں پْراپْیَ یِرُوشالَمِ سَمَسْتَیِہُوداشومِرونَدیشَیوح پرِتھِوْیاح سِیماں یاوَدْ یاوَنْتو دیشاسْتیشُ یَرْوّیشُ چَ مَیِ ساکْشْیَں داسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","اِتِ واکْیَمُکْتْوا سَ تیشاں سَمَکْشَں سْوَرْگَں نِیتوبھَوَتْ، تَتو میگھَمارُہْیَ تیشاں درِشْٹیرَگوچَروبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","یَسْمِنْ سَمَیے تے وِہایَسَں پْرَتْیَنَنْیَدرِشْٹْیا تَسْیَ تادرِشَمْ اُورْدْوَّگَمَنَمْ اَپَشْیَنْ تَسْمِنّیوَ سَمَیے شُکْلَوَسْتْرَو دْوَو جَنَو تیشاں سَنِّدھَو دَنْڈایَمانَو کَتھِتَوَنْتَو، ");
INSERT INTO sanurd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ہے گالِیلِییَلوکا یُویَں کِمَرْتھَں گَگَنَں پْرَتِ نِرِیکْشْیَ دَنْڈایَماناسْتِشْٹھَتھَ؟ یُشْماکَں سَمِیپاتْ سْوَرْگَں نِیتو یو یِیشُسْتَں یُویَں یَتھا سْوَرْگَمْ آروہَنْتَمْ اَدَرْشَمْ تَتھا سَ پُنَشْچاگَمِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","تَتَح پَرَں تے جَیتُنَنامْنَح پَرْوَّتادْ وِشْرامَوارَسْیَ پَتھَح پَرِمانَمْ اَرْتھاتْ پْرایینارْدّھَکْروشَں دُرَسْتھَں یِرُوشالَمْنَگَرَں پَراورِتْیاگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","نَگَرَں پْرَوِشْیَ پِتَرو یاکُوبْ یوہَنْ آنْدْرِیَح پھِلِپَح تھوما بَرْتھَجَمَیو مَتھِرالْپھِییَپُتْرو یاکُوبْ اُدْیوگاी شِمونْ یاکُوبو بھْراتا یِہُودا ایتے سَرْوّے یَتْرَ سْتھانے پْرَوَسَنْتِ تَسْمِنْ اُپَرِتَنَپْرَکوشْٹھے پْراوِشَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","پَشْچادْ اِمے کِیَتْیَح سْتْرِیَشْچَ یِیشو رْماتا مَرِیَمْ تَسْیَ بھْراتَرَشْچَیتے سَرْوَّ ایکَچِتِّیبھُوتَ سَتَتَں وِنَیینَ وِنَیینَ پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","تَسْمِنْ سَمَیے تَتْرَ سْتھانے ساکَلْیینَ وِںشَتْیَدھِکَشَتَں شِشْیا آسَنْ۔ تَتَح پِتَرَسْتیشاں مَدھْیے تِشْٹھَنْ اُکْتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ہے بھْراترِگَنَ یِیشُدھارِناں لوکاناں پَتھَدَرْشَکو یو یِہُوداسْتَسْمِنْ دایُودا پَوِتْرَ آتْما یاں کَتھاں کَتھَیاماسَ تَسْیاح پْرَتْیَکْشِیبھَوَنَسْیاوَشْیَکَتْوَمْ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","سَ جَنوسْماکَں مَدھْیَوَرْتِّی سَنْ اَسْیاح سیوایا اَںشَمْ اَلَبھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","تَدَنَنْتَرَں کُکَرْمَّنا لَبْدھَں یَنْمُولْیَں تینَ کْشیتْرَمیکَں کْرِیتَمْ اَپَرَں تَسْمِنْ اَدھومُکھے بھرِمَو پَتِتے سَتِ تَسْیودَرَسْیَ وِدِیرْنَتْواتْ سَرْوّا ناڈْیو نِرَگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ایتاں کَتھاں یِرُوشالَمْنِواسِنَح سَرْوّے لوکا وِدانْتِ؛ تیشاں نِجَبھاشَیا تَتْکْشیتْرَنْچَ ہَکَلْداما، اَرْتھاتْ رَکْتَکْشیتْرَمِتِ وِکھْیاتَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","اَنْیَچَّ، نِکیتَنَں تَدِییَنْتُ شُنْیَمیوَ بھَوِشْیَتِ۔ تَسْیَ دُوشْیے نِواسارْتھَں کوپِ سْتھاسْیَتِ نَیوَ ہِ۔ اَنْیَ ایوَ جَنَسْتَسْیَ پَدَں سَںپْراپْسْیَتِ دھْرُوَں۔ اِتّھَں گِیتَپُسْتَکے لِکھِتَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","اَتو یوہَنو مَجَّنَمْ آرَبھْیاسْماکَں سَمِیپاتْ پْرَبھو رْیِیشوح سْوَرْگاروہَنَدِنَں یاوَتْ سوسْماکَں مَدھْیے یاوَنْتِ دِنانِ یاپِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","تاوَنْتِ دِنانِ یے مانَوا اَسْمابھِح سارْدّھَں تِشْٹھَنْتِ تیشامْ ایکینَ جَنیناسْمابھِح سارْدّھَں یِیشورُتّھانے ساکْشِنا بھَوِتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","اَتو یَسْیَ رُوڈھِ رْیُشْٹو یَں بَرْشَبّیتْیُکْتْواہُویَنْتِ سَ یُوشَپھْ مَتَتھِشْچَ دْواویتَو پرِتھَکْ کرِتْوا تَ اِیشْوَرَسْیَ سَنِّدھَو پْرارْیَّ کَتھِتَوَنْتَح، ");
INSERT INTO sanurd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ہے سَرْوّانْتَرْیّامِنْ پَرَمیشْوَرَ، یِہُوداح سیوَنَپْریرِتَتْوَپَدَچْیُتَح ");
INSERT INTO sanurd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","سَنْ نِجَسْتھانَمْ اَگَچّھَتْ، تَتْپَدَں لَبْدھُمْ اینَیو رْجَنَیو رْمَدھْیے بھَوَتا کوبھِرُچِتَسْتَدَسْمانْ دَرْشْیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","تَتو گُٹِکاپاٹے کرِتے مَتَتھِرْنِرَچِییَتَ تَسْماتْ سونْییشامْ ایکادَشاناں پْرَرِتاناں مَدھْیے گَنِتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","اَپَرَنْچَ نِسْتاروتْسَواتْ پَرَں پَنْچاشَتَّمے دِنے سَمُپَسْتھِتے سَتِ تے سَرْوّے ایکاچِتِّیبھُویَ سْتھانَ ایکَسْمِنْ مِلِتا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ایتَسْمِنّیوَ سَمَیےکَسْمادْ آکاشاتْ پْرَچَنْڈاتْیُگْرَوایوح شَبْدَوَدْ ایکَح شَبْدَ آگَتْیَ یَسْمِنْ گرِہے تَ اُپاوِشَنْ تَدْ گرِہَں سَمَسْتَں وْیاپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","تَتَح پَرَں وَہْنِشِکھاسْوَرُوپا جِہْواح پْرَتْیَکْشِیبھُویَ وِبھَکْتاح سَتْیَح پْرَتِجَنورْدّھوے سْتھَگِتا اَبھُووَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","تَسْماتْ سَرْوّے پَوِتْریناتْمَنا پَرِپُورْناح سَنْتَ آتْما یَتھا واچِتَوانْ تَدَنُسارینانْیَدیشِییاناں بھاشا اُکْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","تَسْمِنْ سَمَیے پرِتھِوِیسْتھَسَرْوَّدیشیبھْیو یِہُودِییَمَتاوَلَمْبِنو بھَکْتَلوکا یِرُوشالَمِ پْراوَسَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","تَسْیاح کَتھایاح کِںوَدَنْتْیا جاتَتْواتْ سَرْوّے لوکا مِلِتْوا نِجَنِجَبھاشَیا شِشْیاناں کَتھاکَتھَنَں شْرُتْوا سَمُدْوِگْنا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","سَرْوَّایوَ وِسْمَیاپَنّا آشْچَرْیّانْوِتاشْچَ سَنْتَح پَرَسْپَرَں اُکْتَوَنْتَح پَشْیَتَ یے کَتھاں کَتھَیَنْتِ تے سَرْوّے گالِیلِییَلوکاح کِں نَ بھَوَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","تَرْہِ وَیَں پْرَتْییکَشَح سْوَسْوَجَنْمَدیشِییَبھاشابھِح کَتھا ایتیشاں شرِنُمَح کِمِدَں؟ ");
INSERT INTO sanurd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","پارْتھِی-مادِی-اَرامْنَہَرَیِمْدیشَنِواسِمَنو یِہُودا-کَپَّدَکِیا-پَنْتَ-آشِیا- ");
INSERT INTO sanurd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","پھْرُگِیا-پَمْپھُلِیا-مِسَرَنِواسِنَح کُرِینِینِکَٹَوَرْتِّلُوبِییَپْرَدیشَنِواسِنو رومَنَگَرادْ آگَتا یِہُودِییَلوکا یِہُودِییَمَتَگْراہِنَح کْرِیتِییا اَرابِییادَیو لوکاشْچَ یے وَیَمْ ");
INSERT INTO sanurd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","اَسْماکَں نِجَنِجَبھاشابھِریتیشامْ اِیشْوَرِییَمَہاکَرْمَّوْیاکھْیانَں شرِنُمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","اِتّھَں تے سَرْوَّایوَ وِسْمَیاپَنّاح سَنْدِگْدھَچِتّاح سَنْتَح پَرَسْپَرَمُوچُح، اَسْیَ کو بھاوَح؟ ");
INSERT INTO sanurd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","اَپَرے کیچِتْ پَرِہَسْیَ کَتھِتَوَنْتَ ایتے نَوِینَدْراکْشارَسینَ مَتّا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","تَدا پِتَرَ ایکادَشَبھِ رْجَنَیح ساکَں تِشْٹھَنْ تالّوکانْ اُچَّیحکارَمْ اَوَدَتْ، ہے یِہُودِییا ہے یِرُوشالَمْنِواسِنَح سَرْوّے، اَوَدھانَں کرِتْوا مَدِییَواکْیَں بُدھْیَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","اِدانِیمْ ایکَیامادْ اَدھِکا ویلا ناسْتِ تَسْمادْ یُویَں یَدْ اَنُماتھَ مانَوا اِمے مَدْیَپانینَ مَتّاسْتَنَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","کِنْتُ یوییلْبھَوِشْیَدْوَکْتْرَیتَدْواکْیَمُکْتَں یَتھا، ");
INSERT INTO sanurd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","اِیشْوَرَح کَتھَیاماسَ یُگانْتَسَمَیے تْوَہَمْ۔ وَرْشِشْیامِ سْوَماتْمانَں سَرْوَّپْرانْیُپَرِ دھْرُوَمْ۔ بھاوِواکْیَں وَدِشْیَنْتِ کَنْیاح پُتْراشْچَ وَسْتُتَح۔ پْرَتْیادیشَنْچَ پْراپْسْیَنْتِ یُشْماکَں یُوَمانَواح۔ تَتھا پْراچِینَلوکاسْتُ سْوَپْنانْ دْرَکْشْیَنْتِ نِشْچِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","وَرْشِشْیامِ تَداتْمانَں داسَداسِیجَنوپِرِ۔ تینَیوَ بھاوِواکْیَں تے وَدِشْیَنْتِ ہِ سَرْوَّشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","اُورْدّھوَسْتھے گَگَنے چَیوَ نِیچَسْتھے پرِتھِوِیتَلے۔ شونِتانِ برِہَدْبھانُونْ گھَنَدھُومادِکانِ چَ۔ چِہْنانِ دَرْشَیِشْیامِ مَہاشْچَرْیَّکْرِیاسْتَتھا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","مَہابھَیانَکَسْیَیوَ تَدِّنَسْیَ پَریشِتُح۔ پُراگَمادْ رَوِح کرِشْنو رَکْتَشْچَنْدْرو بھَوِشْیَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","کِنْتُ یَح پَرَمیشَسْیَ نامْنِ سَمْپْرارْتھَیِشْیَتے۔ سَایوَ مَنُجو نُونَں پَرِتْراتو بھَوِشْیَتِ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","اَتو ہے اِسْراییلْوَںشِییَلوکاح سَرْوّے کَتھایامیتَسْیامْ مَنو نِدھَدّھوَں ناسَرَتِییو یِیشُرِیشْوَرَسْیَ مَنونِیتَح پُمانْ ایتَدْ اِیشْوَرَسْتَتْکرِتَیراشْچَرْیّادْبھُتَکَرْمَّبھِ رْلَکْشَنَیشْچَ یُشْماکَں ساکْشادیوَ پْرَتِپادِتَوانْ اِتِ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","تَسْمِنْ یِیشَو اِیشْوَرَسْیَ پُورْوَّنِشْچِتَمَنْتْرَنانِرُوپَنانُسارینَ مرِتْیَو سَمَرْپِتے سَتِ یُویَں تَں دھرِتْوا دُشْٹَلوکاناں ہَسْتَیح کْرُشے وِدھِتْواہَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","کِنْتْوِیشْوَرَسْتَں نِدھَنَسْیَ بَنْدھَنانْموچَیِتْوا اُدَسْتھاپَیَتْ یَتَح سَ مرِتْیُنا بَدّھَسْتِشْٹھَتِیتِ نَ سَمْبھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ایتَسْتِنْ دایُودَپِ کَتھِتَوانْ یَتھا، سَرْوَّدا مَمَ ساکْشاتَّں سْتھاپَیَ پَرَمیشْوَرَں۔ سْتھِتے مَدَّکْشِنے تَسْمِنْ سْکھَلِشْیامِ تْوَہَں نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","آنَنْدِشْیَتِ تَدّھیتو رْمامَکِینَں مَنَسْتُ وَے۔ آہْلادِشْیَتِ جِہْواپِ مَدِییا تُ تَتھَیوَ چَ۔ پْرَتْیاشَیا شَرِیرَنْتُ مَدِییَں وَیشَیِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","پَرَلوکے یَتو ہیتوسْتْوَں ماں نَیوَ ہِ تْیَکْشْیَسِ۔ سْوَکِییَں پُنْیَوَنْتَں تْوَں کْشَیِتُں نَیوَ داسْیَسِ۔ ایوَں جِیوَنَمارْگَں تْوَں مامیوَ دَرْشَیِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","سْوَسَمُّکھے یَ آنَنْدو دَکْشِنے سْوَسْیَ یَتْ سُکھَں۔ اَنَنْتَں تینَ ماں پُورْنَں کَرِشْیَسِ نَ سَںشَیَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ہے بھْراتَروسْماکَں تَسْیَ پُورْوَّپُرُشَسْیَ دایُودَح کَتھاں سْپَشْٹَں کَتھَیِتُں مامْ اَنُمَنْیَدھْوَں، سَ پْرانانْ تْیَکْتْوا شْمَشانے سْتھاپِتوبھَوَدْ اَدْیاپِ تَتْ شْمَشانَمْ اَسْماکَں سَنِّدھَو وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","پھَلَتو لَوکِکَبھاوینَ دایُودو وَںشے کھْرِیشْٹَں جَنْمَ گْراہَیِتْوا تَسْیَیوَ سِںہاسَنے سَمُویشْٹُں تَمُتّھاپَیِشْیَتِ پَرَمیشْوَرَح شَپَتھَں کُتْوا دایُودَح سَمِیپَ اِمَمْ اَنْگِیکارَں کرِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","اِتِ جْناتْوا دایُودْ بھَوِشْیَدْوادِی سَنْ بھَوِشْیَتْکالِییَجْنانینَ کھْرِیشْٹوتّھانے کَتھامِماں کَتھَیاماسَ یَتھا تَسْیاتْما پَرَلوکے نَ تْیَکْشْیَتے تَسْیَ شَرِیرَنْچَ نَ کْشیشْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","اَتَح پَرَمیشْوَرَ اینَں یِیشُں شْمَشانادْ اُدَسْتھاپَیَتْ تَتْرَ وَیَں سَرْوّے ساکْشِنَ آسْمَہے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","سَ اِیشْوَرَسْیَ دَکْشِنَکَرینونَّتِں پْراپْیَ پَوِتْرَ آتْمِنَ پِتا یَمَنْگِیکارَں کرِتَوانْ تَسْیَ پھَلَں پْراپْیَ یَتْ پَشْیَتھَ شرِنُتھَ چَ تَدَوَرْشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","یَتو دایُودْ سْوَرْگَں نارُروہَ کِنْتُ سْوَیَمْ اِماں کَتھامْ اَکَتھَیَدْ یَتھا، مَمَ پْرَبھُمِدَں واکْیَمَوَدَتْ پَرَمیشْوَرَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","تَوَ شَتْرُونَہَں یاوَتْ پادَپِیٹھَں کَرومِ نَ۔ تاوَتْ کالَں مَدِییے تْوَں دَکْشَوارْشْوَ اُپاوِشَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","اَتو یَں یِیشُں یُویَں کْرُشےہَتَ پَرَمیشْوَرَسْتَں پْرَبھُتْوابھِشِکْتَتْوَپَدے نْیَیُںکْتیتِ اِسْراییلِییا لوکا نِشْچِتَں جانَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ایتادرِشِیں کَتھاں شْرُتْوا تیشاں ہرِدَیاناں وِدِیرْنَتْواتْ تے پِتَرایَ تَدَنْیَپْریرِتیبھْیَشْچَ کَتھِتَوَنْتَح، ہے بھْراترِگَنَ وَیَں کِں کَرِشْیامَح؟ ");
INSERT INTO sanurd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","تَتَح پِتَرَح پْرَتْیَوَدَدْ یُویَں سَرْوّے سْوَں سْوَں مَنَح پَرِوَرْتَّیَدھْوَں تَتھا پاپَموچَنارْتھَں یِیشُکھْرِیشْٹَسْیَ نامْنا مَجِّتاشْچَ بھَوَتَ، تَسْمادْ دانَرُوپَں پَرِتْرَمْ آتْمانَں لَپْسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","یَتو یُشْماکَں یُشْمَتْسَنْتانانانْچَ دُورَسْتھَسَرْوَّلوکانانْچَ نِمِتَّمْ اَرْتھادْ اَسْماکَں پْرَبھُح پَرَمیشْوَرو یاوَتو لاکانْ آہْواسْیَتِ تیشاں سَرْوّیشاں نِمِتَّمْ اَیَمَنْگِیکارَ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ایتَدَنْیابھِ رْبَہُکَتھابھِح پْرَمانَں دَتْواکَتھَیَتْ ایتیبھْیو وِپَتھَگامِبھْیو وَرْتَّمانَلوکیبھْیَح سْوانْ رَکْشَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","تَتَح پَرَں یے سانَنْداسْتاں کَتھامْ اَگرِہْلَنْ تے مَجِّتا اَبھَوَنْ۔ تَسْمِنْ دِوَسے پْرایینَ تْرِینِ سَہَسْرانِ لوکاسْتیشاں سَپَکْشاح سَنْتَح ");
INSERT INTO sanurd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","پْریرِتانامْ اُپَدیشے سَنْگَتَو پُوپَبھَنْجَنے پْرارْتھَناسُ چَ مَنَحسَںیوگَں کرِتْواتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","پْریرِتَے رْناناپْرَکارَلَکْشَنیشُ مَہاشْچَرْیَّکَرْمَمَسُ چَ دَرْشِتیشُ سَرْوَّلوکاناں بھَیَمُپَسْتھِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","وِشْواسَکارِنَح سَرْوَّ چَ سَہَ تِشْٹھَنَتَح۔ سْویشاں سَرْوّاح سَمْپَتِّیح سادھارَنْیینَ سْتھاپَیِتْوابھُنْجَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","پھَلَتو گرِہانِ دْرَوْیانِ چَ سَرْوّانِ وِکْرِییَ سَرْوّیشاں سْوَسْوَپْرَیوجَنانُسارینَ وِبھَجْیَ سَرْوّیبھْیودَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","سَرْوَّ ایکَچِتِّیبھُویَ دِنے دِنے مَنْدِرے سَنْتِشْٹھَمانا گرِہے گرِہے چَ پُوپانَبھَنْجَنْتَ اِیشْوَرَسْیَ دھَنْیَوادَں کُرْوَّنْتو لوکَیح سَمادرِتاح پَرَمانَنْدینَ سَرَلانْتَحکَرَنینَ بھوجَنَں پانَنْچَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","پَرَمیشْوَرو دِنے دِنے پَرِتْرانَبھاجَنَے رْمَنْڈَلِیمْ اَوَرْدّھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ترِتِییَیامَویلایاں سَتْیاں پْرارْتھَنایاح سَمَیے پِتَرَیوہَنَو سَمْبھُویَ مَنْدِرَں گَچّھَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","تَسْمِنّیوَ سَمَیے مَنْدِرَپْرَویشَکاناں سَمِیپے بھِکْشارَنارْتھَں یَں جَنْمَکھَنْجَمانُشَں لوکا مَنْدِرَسْیَ سُنْدَرَنامْنِ دْوارے پْرَتِدِنَمْ اَسْتھاپَیَنْ تَں وَہَنْتَسْتَدْوارَں آنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","تَدا پِتَرَیوہَنَو مَنْتِرَں پْرَویشْٹُمْ اُدْیَتَو وِلوکْیَ سَ کھَنْجَسْتَو کِنْچِدْ بھِکْشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","تَسْمادْ یوہَنا سَہِتَح پِتَرَسْتَمْ اَنَنْیَدرِشْٹْیا نِرِیکْشْیَ پْروکْتَوانْ آواں پْرَتِ درِشْٹِں کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","تَتَح سَ کِنْچِتْ پْراپْتْیاشَیا تَو پْرَتِ درِشْٹِں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","تَدا پِتَرو گَدِتَوانْ مَمَ نِکَٹے سْوَرْنَرُوپْیادِ کِمَپِ ناسْتِ کِنْتُ یَداسْتے تَدْ دَدامِ ناسَرَتِییَسْیَ یِیشُکھْرِیشْٹَسْیَ نامْنا تْوَمُتّھایَ گَمَناگَمَنے کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","تَتَح پَرَں سَ تَسْیَ دَکْشِنَکَرَں دھرِتْوا تَمْ اُدَتولَیَتْ؛ تینَ تَتْکْشَناتْ تَسْیَ جَنَسْیَ پادَگُلْپھَیوح سَبَلَتْواتْ سَ اُلَّمْپھْیَ پْروتّھایَ گَمَناگَمَنے کَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","تَتو گَمَناگَمَنے کُرْوَّنْ اُلَّمْپھَنْ اِیشْوَرَں دھَنْیَں وَدَنْ تابھْیاں سارْدّھَں مَنْدِرَں پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","تَتَح سَرْوّے لوکاسْتَں گَمَناگَمَنے کُرْوَّنْتَمْ اِیشْوَرَں دھَنْیَں وَدَنْتَنْچَ وِلوکْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","مَنْدِرَسْیَ سُنْدَرے دْوارے یَ اُپَوِشْیَ بھِکْشِتَوانْ سَایوایَمْ اِتِ جْناتْوا تَں پْرَتِ تَیا گھَٹَنَیا چَمَتْکرِتا وِسْمَیاپَنّاشْچابھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","یَح کھَنْجَح سْوَسْتھوبھَوَتْ تینَ پِتَرَیوہَنوح کَرَیورْدھْٹَتَیوح سَتوح سَرْوّے لوکا سَنِّدھِمْ آگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","تَدْ درِشْٹْوا پِتَرَسْتیبھْیوکَتھَیَتْ، ہے اِسْراییلِییَلوکا یُویَں کُتو نیناشْچَرْیَّں مَنْیَدھْوے؟ آواں نِجَشَکْتْیا یَدْوا نِجَپُنْیینَ کھَنْجَمَنُشْیَمینَں گَمِتَوَنْتاوِتِ چِنْتَیِتْوا آواں پْرَتِ کُتونَنْیَدرِشْٹِں کُرُتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","یَں یِیشُں یُویَں پَرَکَریشُ سَمارْپَیَتَ تَتو یَں پِیلاتو موچَیِتُمْ اےैچّھَتْ تَتھاپِ یُویَں تَسْیَ ساکْشانْ نانْگِیکرِتَوَنْتَ اِبْراہِیمَ اِسْہاکو یاکُوبَشْچیشْوَرورْتھادْ اَسْماکَں پُورْوَّپُرُشانامْ اِیشْوَرَح سْوَپُتْرَسْیَ تَسْیَ یِیشو رْمَہِمانَں پْراکاشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","کِنْتُ یُویَں تَں پَوِتْرَں دھارْمِّکَں پُماںسَں نانْگِیکرِتْیَ ہَتْیاکارِنَمیکَں سْویبھْیو داتُمْ اَیاچَدھْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","پَشْچاتْ تَں جِیوَنَسْیادھِپَتِمْ اَہَتَ کِنْتْوِیشْوَرَح شْمَشاناتْ تَمْ اُدَسْتھاپَیَتَ تَتْرَ وَیَں ساکْشِنَ آسْمَہے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","اِمَں یَں مانُشَں یُویَں پَشْیَتھَ پَرِچِنُتھَ چَ سَ تَسْیَ نامْنِ وِشْواسَکَرَناتْ چَلَنَشَکْتِں لَبْدھَوانْ تَسْمِنْ تَسْیَ یو وِشْواسَح سَ تَں یُشْماکَں سَرْوّیشاں ساکْشاتْ سَمْپُورْنَرُوپینَ سْوَسْتھَمْ اَکارْشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ہے بھْراتَرو یُویَں یُشْماکَمْ اَدھِپَتَیَشْچَ اَجْناتْوا کَرْمّانْییتانِ کرِتَوَنْتَ اِدانِیں مَمَیشَ بودھو جایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","کِنْتْوِیشْوَرَح کھْرِیشْٹَسْیَ دُحکھَبھوگے بھَوِشْیَدْوادِناں مُکھیبھْیو یاں یاں کَتھاں پُورْوَّمَکَتھَیَتْ تاح کَتھا اِتّھَں سِدّھا اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","اَتَح سْویشاں پاپَموچَنارْتھَں کھیدَں کرِتْوا مَناںسِ پَرِوَرْتَّیَدھْوَں، تَسْمادْ اِیشْوَراتْ سانْتْوَناپْراپْتیح سَمَیَ اُپَسْتھاسْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","پُنَشْچَ پُورْوَّکالَمْ آرَبھْیَ پْرَچارِتو یو یِیشُکھْرِیشْٹَسْتَمْ اِیشْوَرو یُشْمانْ پْرَتِ پْریشَیِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","کِنْتُ جَگَتَح سرِشْٹِمارَبھْیَ اِیشْوَرو نِجَپَوِتْرَبھَوِشْیَدْوادِگَنونَ یَتھا کَتھِتَوانْ تَدَنُسارینَ سَرْوّیشاں کارْیّاناں سِدّھِپَرْیَّنْتَں تینَ سْوَرْگے واسَح کَرْتَّوْیَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","یُشْماکَں پْرَبھُح پَرَمیشْوَرو یُشْماکَں بھْراترِگَنَمَدھْیاتْ مَتْسَدرِشَں بھَوِشْیَدْوَکْتارَمْ اُتْپادَیِشْیَتِ، تَتَح سَ یَتْ کِنْچِتْ کَتھَیِشْیَتِ تَتْرَ یُویَں مَناںسِ نِدھَدّھوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","کِنْتُ یَح کَشْچِتْ پْرانِی تَسْیَ بھَوِشْیَدْوادِنَح کَتھاں نَ گْرَہِیشْیَتِ سَ نِجَلوکاناں مَدھْیادْ اُچّھیتْسْیَتے،\" اِماں کَتھامْ اَسْماکَں پُورْوَّپُرُشیبھْیَح کیوَلو مُوساح کَتھَیاماسَ اِتِ نَہِ، ");
INSERT INTO sanurd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","شِمُوییلْبھَوِشْیَدْوادِنَمْ آرَبھْیَ یاوَنْتو بھَوِشْیَدْواکْیَمْ اَکَتھَیَنْ تے سَرْوَّایوَ سَمَیَسْیَیتَسْیَ کَتھامْ اَکَتھَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","یُویَمَپِ تیشاں بھَوِشْیَدْوادِناں سَنْتاناح، \"تَوَ وَںشودْبھَوَپُںسا سَرْوَّدیشِییا لوکا آشِشَں پْراپْتا بھَوِشْیَنْتِ\"، اِبْراہِیمے کَتھامیتاں کَتھَیِتْوا اِیشْوَروسْماکَں پُورْوَّپُرُشَیح سارْدّھَں یَں نِیَمَں سْتھِرِیکرِتَوانْ تَسْیَ نِیَمَسْیادھِکارِنوپِ یُویَں بھَوَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","اَتَ اِیشْوَرو نِجَپُتْرَں یِیشُمْ اُتّھاپْیَ یُشْماکَں سَرْوّیشاں سْوَسْوَپاپاتْ پَراوَرْتّیَ یُشْمَبھْیَمْ آشِشَں داتُں پْرَتھَمَتَسْتَں یُشْماکَں نِکَٹَں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","یَسْمِنْ سَمَیے پِتَرَیوہَنَو لوکانْ اُپَدِشَتَسْتَسْمِنْ سَمَیے یاجَکا مَنْدِرَسْیَ سیناپَتَیَح سِدُوکِیگَنَشْچَ ");
INSERT INTO sanurd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","تَیورْ اُپَدیشَکَرَنے کھْرِیشْٹَسْیوتّھانَمْ اُپَلَکْشْیَ سَرْوّیشاں مرِتانامْ اُتّھانَپْرَسْتاوے چَ وْیَگْراح سَنْتَسْتاوُپاگَمَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","تَو دھرِتْوا دِناوَسانَکارَناتْ پَرَدِنَپَرْیَّنَنْتَں رُدّھوا سْتھاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","تَتھاپِ یے لوکاسْتَیورُپَدیشَمْ اَشرِنْوَنْ تیشاں پْرایینَ پَنْچَسَہَسْرانِ جَنا وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","پَرےہَنِ اَدھِپَتَیَح پْراچِینا اَدھْیاپَکاشْچَ ہانَنَناما مَہایاجَکَح ");
INSERT INTO sanurd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","کِیَپھا یوہَنْ سِکَنْدَرَ اِتْیادَیو مَہایاجَکَسْیَ جْناتَیَح سَرْوّے یِرُوشالَمْنَگَرے مِلِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","اَنَنْتَرَں پْریرِتَو مَدھْیے سْتھاپَیِتْواپرِچّھَنْ یُواں کَیا شَکْتَیا وا کینَ نامْنا کَرْمّانْییتانِ کُرُتھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","تَدا پِتَرَح پَوِتْریناتْمَنا پَرِپُورْنَح سَنْ پْرَتْیَوادِیتْ، ہے لوکانامْ اَدھِپَتِگَنَ ہے اِسْراییلِییَپْراچِیناح، ");
INSERT INTO sanurd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ایتَسْیَ دُرْبَّلَمانُشَسْیَ ہِتَں یَتْ کَرْمّاکْرِیَتَ، اَرْتھاتْ، سَ یینَ پْرَکارینَ سْوَسْتھوبھَوَتْ تَچّیدْ اَدْیاواں پرِچّھَتھَ، ");
INSERT INTO sanurd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","تَرْہِ سَرْوَّ اِسْرایےेلِییَلوکا یُویَں جانِیتَ ناسَرَتِییو یو یِیشُکھْرِیشْٹَح کْرُشے یُشْمابھِرَوِدھْیَتَ یَشْچیشْوَرینَ شْمَشانادْ اُتّھاپِتَح، تَسْیَ نامْنا جَنویَں سْوَسْتھَح سَنْ یُشْماکَں سَمُّکھے پْروتِّشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","نِچیترِبھِ رْیُشْمابھِرَیَں یَح پْرَسْتَرووَجْناتوبھَوَتْ سَ پْرَدھانَکونَسْیَ پْرَسْتَروبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","تَدْبھِنّادَپَراتْ کَسْمادَپِ پَرِتْرانَں بھَوِتُں نَ شَکْنوتِ، یینَ تْرانَں پْراپْییتَ بھُومَنْڈَلَسْیَلوکاناں مَدھْیے تادرِشَں کِمَپِ نامَ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","تَدا پِتَرَیوہَنوریتادرِشِیمْ اَکْشیبھَتاں درِشْٹْوا تاوَوِدْواںسَو نِیچَلوکاوِتِ بُدّھوا آشْچَرْیَّمْ اَمَنْیَنْتَ تَو چَ یِیشوح سَنْگِنَو جاتاوِتِ جْناتُمْ اَشَکْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","کِنْتُ تابھْیاں سارْدّھَں تَں سْوَسْتھَمانُشَں تِشْٹھَنْتَں درِشْٹْوا تے کامَپْیَپَرامْ آپَتِّں کَرْتَّں ناشَکْنُنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","تَدا تے سَبھاتَح سْتھانانْتَرَں گَنْتُں تانْ آجْناپْیَ سْوَیَں پَرَسْپَرَمْ اِتِ مَنْتْرَنامَکُرْوَّنْ ");
INSERT INTO sanurd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","تَو مانَوَو پْرَتِ کِں کَرْتَّوْیَں؟ تاویکَں پْرَسِدّھَمْ آشْچَرْیَّں کَرْمَّ کرِتَوَنْتَو تَدْ یِرُوشالَمْنِواسِناں سَرْوّیشاں لوکاناں سَمِیپے پْراکاشَتَ تَچَّ وَیَمَپَہْنوتُں نَ شَکْنُمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","کِنْتُ لوکاناں مَدھْیَمْ ایتَدْ یَتھا نَ وْیاپْنوتِ تَدَرْتھَں تَو بھَیَں پْرَدَرْشْیَ تینَ نامْنا کَمَپِ مَنُشْیَں نوپَدِشَتَمْ اِتِ درِڈھَں نِشیدھامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","تَتَسْتے پْریرِتاواہُویَ ایتَداجْناپَیَنْ اِتَح پَرَں یِیشو رْنامْنا کَداپِ کامَپِ کَتھاں ما کَتھَیَتَں کِمَپِ نوپَدِشَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","تَتَح پِتَرَیوہَنَو پْرَتْیَوَدَتامْ اِیشْوَرَسْیاجْناگْرَہَنَں وا یُشْماکَمْ آجْناگْرَہَنَمْ ایتَیو رْمَدھْیے اِیشْوَرَسْیَ گوچَرے کِں وِہِتَں؟ یُویَں تَسْیَ وِویچَناں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","وَیَں یَدْ اَپَشْیامَ یَدَشرِنُمَ چَ تَنَّ پْرَچارَیِشْیامَ ایتَتْ کَداپِ بھَوِتُں نَ شَکْنوتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","یَدَگھَٹَتَ تَدْ درِشْٹا سَرْوّے لوکا اِیشْوَرَسْیَ گُنانْ اَنْوَوَدَنْ تَسْماتْ لوکَبھَیاتْ تَو دَنْڈَیِتُں کَمَپْیُپایَں نَ پْراپْیَ تے پُنَرَپِ تَرْجَیِتْوا تاوَتْیَجَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","یَسْیَ مانُشَسْیَیتَتْ سْواسْتھْیَکَرَنَمْ آشْچَرْیَّں کَرْمّاکْرِیَتَ تَسْیَ وَیَشْچَتْوارِںشَدْوَتْسَرا وْیَتِیتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","تَتَح پَرَں تَو وِسرِشْٹَو سَنْتَو سْوَسَنْگِناں سَنِّدھِں گَتْوا پْرَدھانَیاجَکَیح پْراچِینَلوکَیشْچَ پْروکْتاح سَرْوّاح کَتھا جْناپِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","تَچّھرُتْوا سَرْوَّ ایکَچِتِّیبھُویَ اِیشْوَرَمُدِّشْیَ پْروچَّیریتَتْ پْرارْتھَیَنْتَ، ہے پْرَبھو گَگَنَپرِتھِوِیپَیودھِیناں تیشُ چَ یَدْیَدْ آسْتے تیشاں سْرَشْٹیشْوَرَسْتْوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","تْوَں نِجَسیوَکینَ دایُودا واکْیَمِدَمْ اُوَچِتھَ، مَنُشْیا اَنْیَدیشِییاح کُرْوَّنْتِ کَلَہَں کُتَح۔ لوکاح سَرْوّے کِمَرْتھَں وا چِنْتاں کُرْوَّنْتِ نِشْپھَلاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","پَرَمیشَسْیَ تینَیوابھِشِکْتَسْیَ جَنَسْیَ چَ۔ وِرُدّھَمَبھِتِشْٹھَنْتِ پرِتھِوْیاح پَتَیَح کُتَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","پھَلَتَسْتَوَ ہَسْتینَ مَنْتْرَنَیا چَ پُورْوَّ یَدْیَتْ سْتھِرِیکرِتَں تَدْ یَتھا سِدّھَں بھَوَتِ تَدَرْتھَں تْوَں یَمْ اَتھِشِکْتَوانْ سَ ایوَ پَوِتْرو یِیشُسْتَسْیَ پْراتِکُولْیینَ ہیرودْ پَنْتِییَپِیلاتو ");
INSERT INTO sanurd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","نْیَدیشِییَلوکا اِسْراییلّوکاشْچَ سَرْوَّ ایتے سَبھایامْ اَتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ہے پَرَمیشْوَرَ اَدھُنا تیشاں تَرْجَنَں گَرْجَنَنْچَ شرِنُ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","تَتھا سْواسْتھْیَکَرَنَکَرْمَّنا تَوَ باہُبَلَپْرَکاشَپُورْوَّکَں تَوَ سیوَکانْ نِرْبھَیینَ تَوَ واکْیَں پْرَچارَیِتُں تَوَ پَوِتْرَپُتْرَسْیَ یِیشو رْنامْنا آشْچَرْیّانْیَسَمْبھَوانِ چَ کَرْمّانِ کَرْتُّنْچاجْناپَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","اِتّھَں پْرارْتھَنَیا یَتْرَ سْتھانے تے سَبھایامْ آسَنْ تَتْ سْتھانَں پْراکَمْپَتَ؛ تَتَح سَرْوّے پَوِتْریناتْمَنا پَرِپُورْناح سَنْتَ اِیشْوَرَسْیَ کَتھامْ اَکْشوبھینَ پْراچارَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","اَپَرَنْچَ پْرَتْیَیَکارِلوکَسَمُوہا ایکَمَنَسَ ایکَچِتِّیبھُویَ سْتھِتاح۔ تیشاں کیپِ نِجَسَمْپَتِّں سْوِییاں ناجانَنْ کِنْتُ تیشاں سَرْوّاح سَمْپَتّیَح سادھارَنْیینَ سْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","اَنْیَچَّ پْریرِتا مَہاشَکْتِپْرَکاشَپُورْوَّکَں پْرَبھو رْیِیشورُتّھانے ساکْشْیَمْ اَدَدُح، تیشُ سَرْوّیشُ مَہانُگْرَہوبھَوَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","تیشاں مَدھْیے کَسْیاپِ دْرَوْیَنْیُونَتا نابھَوَدْ یَتَسْتیشاں گرِہَبھُومْیادْیا یاح سَمْپَتَّیَ آسَنْ تا وِکْرِییَ ");
INSERT INTO sanurd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","تَنْمُولْیَمانِییَ پْریرِتاناں چَرَنیشُ تَیح سْتھاپِتَں؛ تَتَح پْرَتْییکَشَح پْرَیوجَنانُسارینَ دَتَّمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","وِشیشَتَح کُپْروپَدْوِیپِییو یوسِنامَکو لیوِوَںشَجاتَ ایکو جَنو بھُومْیَدھِکارِی، یَں پْریرِتا بَرْنَبّا اَرْتھاتْ سانْتْوَنادایَکَ اِتْیُکْتْوا سَماہُویَنْ، ");
INSERT INTO sanurd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","سَ جَنو نِجَبھُومِں وِکْرِییَ تَنْمُولْیَمانِییَ پْریرِتاناں چَرَنیشُ سْتھاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","تَدا اَنانِیَنامَکَ ایکو جَنو یَسْیَ بھارْیّایا نامَ سَپھِیرا سَ سْوادھِکارَں وِکْرِییَ ");
INSERT INTO sanurd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","سْوَبھارْیّاں جْناپَیِتْوا تَنْمُولْیَسْیَیکاںشَں سَنْگوپْیَ سْتھاپَیِتْوا تَدَنْیاںشَماتْرَمانِییَ پْریرِتاناں چَرَنیشُ سَمَرْپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","تَسْماتْ پِتَروکَتھَیَتْ ہے اَنانِیَ بھُومے رْمُولْیَں کِنْچِتْ سَنْگوپْیَ سْتھاپَیِتُں پَوِتْرَسْیاتْمَنَح سَنِّدھَو مرِشاواکْیَں کَتھَیِتُنْچَ شَیتانْ کُتَسْتَوانْتَحکَرَنے پْرَورِتِّمَجَنَیَتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","سا بھُومِ رْیَدا تَوَ ہَسْتَگَتا تَدا کِں تَوَ سْوِییا ناسِیتْ؟ تَرْہِ سْوانْتَحکَرَنے کُتَ ایتادرِشِی کُکَلْپَنا تْوَیا کرِتا؟ تْوَں کیوَلَمَنُشْیَسْیَ نِکَٹے مرِشاواکْیَں ناوادِیح کِنْتْوِیشْوَرَسْیَ نِکَٹےپِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ایتاں کَتھاں شْرُتْوَیوَ سونانِیو بھُومَو پَتَنْ پْرانانْ اَتْیَجَتْ، تَدْورِتّانْتَں یاوَنْتو لوکا اَشرِنْوَنْ تیشاں سَرْوّیشاں مَہابھَیَمْ اَجایَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","تَدا یُوَلوکاسْتَں وَسْتْریناچّھادْیَ بَہِ رْنِیتْوا شْمَشانےسْتھاپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","تَتَح پْرَہَرَیکانَنْتَرَں کِں ورِتَّں تَنّاوَگَتْیَ تَسْیَ بھارْیّاپِ تَتْرَ سَمُپَسْتھِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","تَتَح پِتَرَسْتامْ اَپرِچّھَتْ، یُوابھْیامْ ایتاوَنْمُدْرابھْیو بھُومِ رْوِکْرِیتا نَ وا؟ ایتَتْوَں وَدَ؛ تَدا سا پْرَتْیَوادِیتْ سَتْیَمْ ایتاوَدْبھْیو مُدْرابھْیَ ایوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","تَتَح پِتَروکَتھَیَتْ یُواں کَتھَں پَرَمیشْوَرَسْیاتْمانَں پَرِیکْشِتُمْ ایکَمَنْتْرَناوَبھَوَتاں؟ پَشْیَ یے تَوَ پَتِں شْمَشانے سْتھاپِتَوَنْتَسْتے دْوارَسْیَ سَمِیپے سَمُپَتِشْٹھَنْتِ تْوامَپِ بَہِرْنیشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","تَتَح ساپِ تَسْیَ چَرَنَسَنِّدھَو پَتِتْوا پْرانانْ اَتْیاکْشِیتْ۔ پَشْچاتْ تے یُوانوبھْیَنْتَرَمْ آگَتْیَ تامَپِ مرِتاں درِشْٹْوا بَہِ رْنِیتْوا تَسْیاح پَتْیُح پارْشْوے شْمَشانے سْتھاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","تَسْماتْ مَنْڈَلْیاح سَرْوّے لوکا اَنْیَلوکاشْچَ تاں وارْتّاں شْرُتْوا سادھْوَسَں گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","تَتَح پَرَں پْریرِتاناں ہَسْتَے رْلوکاناں مَدھْیے بَہْواشْچَرْیّانْیَدْبھُتانِ کَرْمّانْیَکْرِیَنْتَ؛ تَدا شِشْیاح سَرْوَّ ایکَچِتِّیبھُویَ سُلیمانو لِنْدے سَمْبھُویاسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","تیشاں سَنْگھانْتَرْگو بھَوِتُں کوپِ پْرَگَلْبھَتاں ناگَمَتْ کِنْتُ لوکاسْتانْ سَمادْرِیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","سْتْرِیَح پُرُشاشْچَ بَہَوو لوکا وِشْواسْیَ پْرَبھُں شَرَنَماپَنّاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","پِتَرَسْیَ گَمَناگَمَنابھْیاں کیناپِ پْرَکارینَ تَسْیَ چھایا کَسْمِںشْچِجَّنے لَگِشْیَتِیتْیاشَیا لوکا روگِنَح شِوِکَیا کھَٹْوَیا چانِییَ پَتھِ پَتھِ سْتھاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","چَتُرْدِکْسْتھَنَگَریبھْیو بَہَوو لوکاح سَمْبھُویَ روگِنوپَوِتْرَبھُتَگْرَسْتاںشْچَ یِرُوشالَمَمْ آنَیَنْ تَتَح سَرْوّے سْوَسْتھا اَکْرِیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","اَنَنْتَرَں مَہایاجَکَح سِدُوکِناں مَتَگْراہِنَسْتیشاں سَہَچَراشْچَ ");
INSERT INTO sanurd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","مَہاکْرودھانْتْوِتاح سَنْتَح پْریرِتانْ دھرِتْوا نِیچَلوکاناں کارایاں بَدّھوا سْتھاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","کِنْتُ راتْرَو پَرَمیشْوَرَسْیَ دُوتَح کارایا دْوارَں موچَیِتْوا تانْ بَہِرانِییاکَتھَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","یُویَں گَتْوا مَنْدِرے دَنْڈایَماناح سَنْتو لوکانْ پْرَتِیماں جِیوَنَدایِکاں سَرْوّاں کَتھاں پْرَچارَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","اِتِ شْرُتْوا تے پْرَتْیُوشے مَنْدِرَ اُپَسْتھایَ اُپَدِشْٹَوَنْتَح۔ تَدا سَہَچَرَگَنینَ سَہِتو مَہایاجَکَ آگَتْیَ مَنْتْرِگَنَمْ اِسْراییلْوَںشَسْیَ سَرْوّانْ راجَسَبھاسَدَح سَبھاسْتھانْ کرِتْوا کارایاسْتانْ آپَیِتُں پَداتِگَنَں پْریرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","تَتَسْتے گَتْوا کارایاں تانْ اَپْراپْیَ پْرَتْیاگَتْیَ اِتِ وارْتّامْ اَوادِشُح، ");
INSERT INTO sanurd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","وَیَں تَتْرَ گَتْوا نِرْوِّگھْنَں کارایا دْوارَں رُدّھَں رَکْشَکاںشْچَ دْوارَسْیَ بَہِرْدَنْڈایَمانانْ اَدَرْشامَ ایوَ کِنْتُ دْوارَں موچَیِتْوا تَنْمَدھْیے کَمَپِ دْرَشْٹُں نَ پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ایتاں کَتھاں شْرُتْوا مَہایاجَکو مَنْدِرَسْیَ سیناپَتِح پْرَدھانَیاجَکاشْچَ، اِتَ پَرَں کِمَپَرَں بھَوِشْیَتِیتِ چِنْتَیِتْوا سَنْدِگْدھَچِتّا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ایتَسْمِنّیوَ سَمَیے کَشْچِتْ جَنَ آگَتْیَ وارْتّامیتامْ اَوَدَتْ پَشْیَتَ یُویَں یانْ مانَوانْ کارایامْ اَسْتھاپَیَتَ تے مَنْدِرے تِشْٹھَنْتو لوکانْ اُپَدِشَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","تَدا مَنْدِرَسْیَ سیناپَتِح پَداتَیَشْچَ تَتْرَ گَتْوا چیلّوکاح پاشانانْ نِکْشِپْیاسْمانْ مارَیَنْتِیتِ بھِیا وِنَتْیاچارَں تانْ آنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","تے مَہاسَبھایا مَدھْیے تانْ اَسْتھاپَیَنْ تَتَح پَرَں مَہایاجَکَسْتانْ اَپرِچّھَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","اَنینَ نامْنا سَمُپَدیشْٹُں وَیَں کِں درِڈھَں نَ نْیَشیدھامَ؟ تَتھاپِ پَشْیَتَ یُویَں سْویشاں تینوپَدیشینے یِرُوشالَمَں پَرِپُورْنَں کرِتْوا تَسْیَ جَنَسْیَ رَکْتَپاتَجَنِتاپَرادھَمْ اَسْمانْ پْرَتْیانیتُں چیشْٹَدھْوے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","تَتَح پِتَرونْیَپْریرِتاشْچَ پْرَتْیَوَدَنْ مانُشَسْیاجْناگْرَہَنادْ اِیشْوَرَسْیاجْناگْرَہَنَمْ اَسْماکَمُچِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","یَں یِیشُں یُویَں کْرُشے ویدھِتْواہَتَ تَمْ اَسْماکَں پَیترِکَ اِیشْوَرَ اُتّھاپْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","اِسْراییلْوَںشاناں مَنَحپَرِوَرْتَّنَں پاپَکْشَمانْچَ کَرْتُّں راجانَں پَرِتْراتارَنْچَ کرِتْوا سْوَدَکْشِنَپارْشْوے تَسْیانَّتِمْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ایتَسْمِنْ وَیَمَپِ ساکْشِنَ آسْمَہے، تَتْ کیوَلَں نَہِ، اِیشْوَرَ آجْناگْراہِبھْیو یَں پَوِتْرَمْ آتْمَنَں دَتَّوانْ سوپِ ساکْشْیَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ایتَدْواکْیے شْرُتے تیشاں ہرِدَیانِ وِدّھانْیَبھَوَنْ تَتَسْتے تانْ ہَنْتُں مَنْتْرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ایتَسْمِنّیوَ سَمَیے تَتْسَبھاسْتھاناں سَرْوَّلوکاناں مَدھْیے سُکھْیاتو گَمِلِیییلْنامَکَ ایکو جَنو وْیَوَسْتھاپَکَح پھِرُوشِلوکَ اُتّھایَ پْریرِتانْ کْشَنارْتھَں سْتھانانْتَرَں گَنْتُمْ آدِشْیَ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ہے اِسْراییلْوَںشِییاح سَرْوّے یُویَمْ ایتانْ مانُشانْ پْرَتِ یَتْ کَرْتُّمْ اُدْیَتاسْتَسْمِنْ ساوَدھانا بھَوَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","اِتَح پُورْوَّں تھُودانامَیکو جَنَ اُپَسْتھایَ سْوَں کَمَپِ مَہاپُرُشَمْ اَوَدَتْ، تَتَح پْرایینَ چَتُحشَتَلوکاسْتَسْیَ مَتَگْراہِنوبھَوَنْ پَشْچاتْ سَ ہَتوبھَوَتْ تَسْیاجْناگْراہِنو یاوَنْتو لوکاسْتے سَرْوّے وِرْکِیرْناح سَنْتو کرِتَکارْیّا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","تَسْماجَّناتْ پَرَں نامَلیکھَنَسَمَیے گالِیلِییَیِہُودانامَیکو جَنَ اُپَسْتھایَ بَہُولّوکانْ سْوَمَتَں گْراہِیتَوانْ تَتَح سوپِ وْیَنَشْیَتْ تَسْیاجْناگْراہِنو یاوَنْتو لوکا آسَنْ تے سَرْوّے وِکِیرْنا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","اَدھُنا وَدامِ، یُویَمْ ایتانْ مَنُشْیانْ پْرَتِ کِمَپِ نَ کرِتْوا کْشانْتا بھَوَتَ، یَتَ ایشَ سَنْکَلْپَ ایتَتْ کَرْمَّ چَ یَدِ مَنُشْیادَبھَوَتْ تَرْہِ وِپھَلَں بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","یَدِیشْوَرادَبھَوَتْ تَرْہِ یُویَں تَسْیانْیَتھا کَرْتُّں نَ شَکْشْیَتھَ، وَرَمْ اِیشْوَرَرودھَکا بھَوِشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","تَدا تَسْیَ مَنْتْرَناں سْوِیکرِتْیَ تے پْریرِتانْ آہُویَ پْرَہرِتْیَ یِیشو رْنامْنا کامَپِ کَتھاں کَتھَیِتُں نِشِدھْیَ وْیَسَرْجَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","کِنْتُ تَسْیَ نامارْتھَں وَیَں لَجّابھوگَسْیَ یوگْیَتْوینَ گَنِتا اِتْیَتْرَ تے سانَنْداح سَنْتَح سَبھاسْتھاناں ساکْشادْ اَگَچّھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","تَتَح پَرَں پْرَتِدِنَں مَنْدِرے گرِہے گرِہے چاوِشْرامَمْ اُپَدِشْیَ یِیشُکھْرِیشْٹَسْیَ سُسَںوادَں پْرَچارِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","تَسْمِنْ سَمَیے شِشْیاناں باہُلْیاتْ پْراتْیَہِکَدانَسْیَ وِشْرانَنَے رْبھِنَّدیشِییاناں وِدھَواسْتْرِیگَنَ اُپیکْشِتے سَتِ اِبْرِییَلوکَیح سَہانْیَدیشِییاناں وِوادَ اُپاتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","تَدا دْوادَشَپْریرِتاح سَرْوّانْ شِشْیانْ سَںگرِہْیاکَتھَیَنْ اِیشْوَرَسْیَ کَتھاپْرَچارَں پَرِتْیَجْیَ بھوجَنَگَویشَنَمْ اَسْماکَمْ اُچِتَں نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","اَتو ہے بھْراترِگَنَ وَیَمْ ایتَتْکَرْمَّنو بھارَں ییبھْیو داتُں شَکْنُمَ ایتادرِشانْ سُکھْیاتْیاپَنّانْ پَوِتْریناتْمَنا جْنانینَ چَ پُورْنانْ سَپّرَجَنانْ یُویَں سْویشاں مَدھْیے مَنونِیتانْ کُرُتَ، ");
INSERT INTO sanurd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","کِنْتُ وَیَں پْرارْتھَنایاں کَتھاپْرَچارَکَرْمَّنِ چَ نِتْیَپْرَورِتّاح سْتھاسْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ایتَسْیاں کَتھایاں سَرْوّے لوکاح سَنْتُشْٹاح سَنْتَح سْویشاں مَدھْیاتْ سْتِپھانَح پھِلِپَح پْرَکھَرو نِکانورْ تِیمَنْ پَرْمِّنا یِہُودِمَتَگْراہِی-آنْتِیَکھِیانَگَرِییو نِکَلا ایتانْ پَرَمَبھَکْتانْ پَوِتْریناتْمَنا پَرِپُورْنانْ سَپْتَ جَنانْ ");
INSERT INTO sanurd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","پْریرِتاناں سَمَکْشَمْ آنَیَنْ، تَتَسْتے پْرارْتھَناں کرِتْوا تیشاں شِرَحسُ ہَسْتانْ آرْپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","اَپَرَنْچَ اِیشْوَرَسْیَ کَتھا دیشَں وْیاپْنوتْ وِشیشَتو یِرُوشالَمِ نَگَرے شِشْیاناں سَںکھْیا پْرَبھُوتَرُوپیناوَرْدّھَتَ یاجَکاناں مَدھْییپِ بَہَوَح کھْرِیشْٹَمَتَگْراہِنوبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","سْتِپھانوे وِشْواسینَ پَراکْرَمینَ چَ پَرِپُورْنَح سَنْ لوکاناں مَدھْیے بَہُوِدھَمْ اَدْبھُتَمْ آشْچَرْیَّں کَرْمّاکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","تینَ لِبَرْتِّنِییَنامْنا وِکھْیاتَسَنْگھَسْیَ کَتِپَیَجَناح کُرِینِییَسِکَنْدَرِییَ-کِلِکِییاشِییادیشِییاح کِیَنْتو جَناشْچوتّھایَ سْتِپھانینَ سارْدّھَں وْیَوَدَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","کِنْتُ سْتِپھانو جْنانینَ پَوِتْریناتْمَنا چَ اِیدرِشِیں کَتھاں کَتھِتَوانْ یَسْیاسْتے آپَتِّں کَرْتُّں ناشَکْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","پَشْچاتْ تَے رْلوبھِتاح کَتِپَیَجَناح کَتھامینامْ اَکَتھَیَنْ، وَیَں تَسْیَ مُکھَتو مُوسا اِیشْوَرَسْیَ چَ نِنْداواکْیَمْ اَشْرَوشْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","تے لوکاناں لوکَپْراچِینانامْ اَدھْیاپَکانانْچَ پْرَورِتِّں جَنَیِتْوا سْتِپھانَسْیَ سَنِّدھِمْ آگَتْیَ تَں دھرِتْوا مَہاسَبھامَدھْیَمْ آنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","تَدَنَنْتَرَں کَتِپَیَجَنیشُ مِتھْیاساکْشِشُ سَمانِیتیشُ تےکَتھَیَنْ ایشَ جَنَ ایتَتْپُنْیَسْتھانَوْیَوَسْتھَیو رْنِنْداتَح کَداپِ نَ نِوَرْتَّتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","پھَلَتو ناسَرَتِییَیِیشُح سْتھانَمیتَدْ اُچّھِنَّں کَرِشْیَتِ مُوساسَمَرْپِتَمْ اَسْماکَں وْیَوَہَرَنَمْ اَنْیَرُوپَں کَرِشْیَتِ تَسْیَیتادرِشِیں کَتھاں وَیَمْ اَشرِنُمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","تَدا مَہاسَبھاسْتھاح سَرْوّے تَں پْرَتِ سْتھِراں درِشْٹِں کرِتْوا سْوَرْگَدُوتَمُکھَسَدرِشَں تَسْیَ مُکھَمْ اَپَشْیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","تَتَح پَرَں مَہایاجَکَح پرِشْٹَوانْ، ایشا کَتھاں کِں سَتْیا؟ ");
INSERT INTO sanurd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","تَتَح سَ پْرَتْیَوَدَتْ، ہے پِتَرو ہے بھْراتَرَح سَرْوّے لاکا مَناںسِ نِدھَدّھوَں۔ اَسْماکَں پُورْوَّپُرُشَ اِبْراہِیمْ ہارَنْنَگَرے واسَکَرَناتْ پُورْوَّں یَدا اَرامْ-نَہَرَیِمَدیشے آسِیتْ تَدا تیجومَیَ اِیشْوَرو دَرْشَنَں دَتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","تَمَوَدَتْ تْوَں سْوَدیشَجْناتِمِتْرانِ پَرِتْیَجْیَ یَں دیشَمَہَں دَرْشَیِشْیامِ تَں دیشَں وْرَجَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","اَتَح سَ کَسْدِییَدیشَں وِہایَ ہارَنْنَگَرے نْیَوَسَتْ، تَدَنَنْتَرَں تَسْیَ پِتَرِ مرِتے یَتْرَ دیشے یُویَں نِوَسَتھَ سَ اینَں دیشَماگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","کِنْتْوِیشْوَرَسْتَسْمَے کَمَپْیَدھِکارَمْ اَرْتھادْ ایکَپَدَپَرِمِتاں بھُومِمَپِ نادَداتْ؛ تَدا تَسْیَ کوپِ سَنْتانو ناسِیتْ تَتھاپِ سَنْتانَیح سارْدّھَمْ ایتَسْیَ دیشَسْیادھِکارِی تْوَں بھَوِشْیَسِیتِ تَمْپْرَتْیَنْگِیکرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","اِیشْوَرَ اِتّھَمْ اَپَرَمَپِ کَتھِتَوانْ تَوَ سَنْتاناح پَرَدیشے نِوَتْسْیَنْتِ تَتَسْتَدّیشِییَلوکاشْچَتُحشَتَوَتْسَرانْ یاوَتْ تانْ داسَتْوے سْتھاپَیِتْوا تانْ پْرَتِ کُوْیَوَہارَں کَرِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","اَپَرَمْ اِیشْوَرَ ایناں کَتھامَپِ کَتھِتَوانْ، یے لوکاسْتانْ داسَتْوے سْتھاپَیِشْیَنْتِ تالّوکانْ اَہَں دَنْڈَیِشْیامِ، تَتَح پَرَں تے بَہِرْگَتاح سَنْتو مامْ اَتْرَ سْتھانے سیوِشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","پَشْچاتْ سَ تَسْمَے تْوَکْچھیدَسْیَ نِیَمَں دَتَّوانْ، اَتَ اِسْہاکَنامْنِ اِبْراہِیمَ ایکَپُتْرے جاتے، اَشْٹَمَدِنے تَسْیَ تْوَکْچھیدَمْ اَکَروتْ۔ تَسْیَ اِسْہاکَح پُتْرو یاکُوبْ، تَتَسْتَسْیَ یاکُوبوسْماکَں دْوادَشَ پُورْوَّپُرُشا اَجایَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","تے پُورْوَّپُرُشا اِیرْشْیَیا پَرِپُورْنا مِسَرَدیشَں پْریشَیِتُں یُوشَپھَں وْیَکْرِینَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","کِنْتْوِیشْوَرَسْتَسْیَ سَہایو بھُوتْوا سَرْوَّسْیا دُرْگَتے رَکْشِتْوا تَسْمَے بُدّھِں دَتّوا مِسَرَدیشَسْیَ راجْنَح پھِرَونَح پْرِیَپاتْرَں کرِتَوانْ تَتو راجا مِسَرَدیشَسْیَ سْوِییَسَرْوَّپَرِوارَسْیَ چَ شاسَنَپَدَں تَسْمَے دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","تَسْمِنْ سَمَیے مِسَرَ-کِنانَدیشَیو رْدُرْبھِکْشَہیتورَتِکْلِشْٹَتْواتْ نَح پُورْوَّپُرُشا بھَکْشْیَدْرَوْیَں نالَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","کِنْتُ مِسَرَدیشے شَسْیانِ سَنْتِ، یاکُوبْ اِماں وارْتّاں شْرُتْوا پْرَتھَمَمْ اَسْماکَں پُورْوَّپُرُشانْ مِسَرَں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","تَتو دْوِتِییَوارَگَمَنے یُوشَپھْ سْوَبھْراترِبھِح پَرِچِتوبھَوَتْ؛ یُوشَپھو بھْراتَرَح پھِرَونْ راجینَ پَرِچِتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","اَنَنْتَرَں یُوشَپھْ بھْراترِگَنَں پْریشْیَ نِجَپِتَرَں یاکُوبَں نِجانْ پَنْچادھِکَسَپْتَتِسَںکھْیَکانْ جْناتِجَناںشْچَ سَماہُوتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","تَسْمادْ یاکُوبْ مِسَرَدیشَں گَتْوا سْوَیَمْ اَسْماکَں پُورْوَّپُرُشاشْچَ تَسْمِنْ سْتھانےمْرِیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","تَتَسْتے شِکھِمَں نِیتا یَتْ شْمَشانَمْ اِبْراہِیمْ مُدْرادَتْوا شِکھِمَح پِتُ رْہَمورَح پُتْریبھْیَح کْرِیتَوانْ تَتْشْمَشانے سْتھاپَیانْچَکْرِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","تَتَح پَرَمْ اِیشْوَرَ اِبْراہِیمَح سَنِّدھَو شَپَتھَں کرِتْوا یاں پْرَتِجْناں کرِتَوانْ تَسْیاح پْرَتِجْنایاح پھَلَنَسَمَیے نِکَٹے سَتِ اِسْراییلّوکا سِمَرَدیشے وَرْدّھَمانا بَہُسَںکھْیا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","شیشے یُوشَپھَں یو نَ پَرِچِنوتِ تادرِشَ ایکو نَرَپَتِرُپَسْتھایَ ");
INSERT INTO sanurd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","اَسْماکَں جْناتِبھِح سارْدّھَں دھُورْتَّتاں وِدھایَ پُورْوَّپُرُشانْ پْرَتِ کُوْیَوَہَرَنَپُورْوَّکَں تیشاں وَںشَناشَنایَ تیشاں نَوَجاتانْ شِشُونْ بَہِ رْنِرَکْشیپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ایتَسْمِنْ سَمَیے مُوسا جَجْنے، سَ تُ پَرَمَسُنْدَروبھَوَتْ تَتھا پِترِگرِہے ماسَتْرَیَپَرْیَّنْتَں پالِتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","کِنْتُ تَسْمِنْ بَہِرْنِکْشِپْتے سَتِ پھِرَونَراجَسْیَ کَنْیا تَمْ اُتّولْیَ نِیتْوا دَتَّکَپُتْرَں کرِتْوا پالِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","تَسْماتْ سَ مُوسا مِسَرَدیشِییایاح سَرْوَّوِدْیایاح پارَدرِشْوا سَنْ واکْیے کْرِیایانْچَ شَکْتِمانْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","سَ سَمْپُورْنَچَتْوارِںشَدْوَتْسَرَوَیَسْکو بھُوتْوا اِسْراییلِییَوَںشَنِجَبھْراترِنْ ساکْشاتْ کَرْتُں مَتِں چَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","تیشاں جَنَمیکَں ہِںسِتَں درِشْٹْوا تَسْیَ سَپَکْشَح سَنْ ہِںسِتَجَنَمْ اُپَکرِتْیَ مِسَرِییَجَنَں جَگھانَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","تَسْیَ ہَسْتینیشْوَرَسْتانْ اُدّھَرِشْیَتِ تَسْیَ بھْراترِگَنَ اِتِ جْناسْیَتِ سَ اِتْیَنُمانَں چَکارَ، کِنْتُ تے نَ بُبُدھِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","تَتْپَرے ہَنِ تیشامْ اُبھَیو رْجَنَیو رْواکَّلَہَ اُپَسْتھِتے سَتِ مُوساح سَمِیپَں گَتْوا تَیو رْمیلَنَں کَرْتُّں مَتِں کرِتْوا کَتھَیاماسَ، ہے مَہاشَیَو یُواں بھْراتَرَو پَرَسْپَرَمْ اَنْیایَں کُتَح کُرُتھَح؟ ");
INSERT INTO sanurd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","تَتَح سَمِیپَواسِنَں پْرَتِ یو جَنونْیایَں چَکارَ سَ تَں دُورِیکرِتْیَ کَتھَیاماسَ، اَسْماکَمُپَرِ شاسْترِتْوَوِچارَیِترِتْوَپَدَیوح کَسْتْواں نِیُکْتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ہْیو یَتھا مِسَرِییَں ہَتَوانْ تَتھا کِں مامَپِ ہَنِشْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","تَدا مُوسا ایتادرِشِیں کَتھاں شْرُتْوا پَلایَنَں چَکْرے، تَتو مِدِیَنَدیشَں گَتْوا پْرَواسِی سَنْ تَسْتھَو، تَتَسْتَتْرَ دْوَو پُتْرَو جَجْناتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","اَنَنْتَرَں چَتْوارِںشَدْوَتْسَریشُ گَتیشُ سِینَیَپَرْوَّتَسْیَ پْرانْتَرے پْرَجْوَلِتَسْتَمْبَسْیَ وَہْنِشِکھایاں پَرَمیشْوَرَدُوتَسْتَسْمَے دَرْشَنَں دَدَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","مُوساسْتَسْمِنْ دَرْشَنے وِسْمَیَں مَتْوا وِشیشَں جْناتُں نِکَٹَں گَچّھَتِ، ");
INSERT INTO sanurd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ایتَسْمِنْ سَمَیے، اَہَں تَوَ پُورْوَّپُرُشانامْ اِیشْوَرورْتھادْ اِبْراہِیمَ اِیشْوَرَ اِسْہاکَ اِیشْوَرو یاکُوبَ اِیشْوَرَشْچَ، مُوسامُدِّشْیَ پَرَمیشْوَرَسْیَیتادرِشِی وِہایَسِییا وانِی بَبھُووَ، تَتَح سَ کَمْپانْوِتَح سَنْ پُنَ رْنِرِیکْشِتُں پْرَگَلْبھو نَ بَبھُووَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","پَرَمیشْوَرَسْتَں جَگادَ، تَوَ پادَیوح پادُکے موچَیَ یَتْرَ تِشْٹھَسِ سا پَوِتْرَبھُومِح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","اَہَں مِسَرَدیشَسْتھاناں نِجَلوکاناں دُرْدَّشاں نِتانْتَمْ اَپَشْیَں، تیشاں کاتَرْیّوکْتِنْچَ شْرُتَوانْ تَسْماتْ تانْ اُدّھَرْتُّمْ اَوَرُہْیاگَمَمْ؛ اِدانِیمْ آگَچّھَ مِسَرَدیشَں تْواں پْریشَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","کَسْتْواں شاسْترِتْوَوِچارَیِترِتْوَپَدَیو رْنِیُکْتَوانْ، اِتِ واکْیَمُکْتْوا تَے رْیو مُوسا اَوَجْناتَسْتَمیوَ اِیشْوَرَح سْتَمْبَمَدھْیے دَرْشَنَداتْرا تینَ دُوتینَ شاسْتارَں مُکْتِداتارَنْچَ کرِتْوا پْریشَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","سَ چَ مِسَرَدیشے سُوپھْنامْنِ سَمُدْرے چَ پَشْچاتْ چَتْوارِںشَدْوَتْسَرانْ یاوَتْ مَہاپْرانْتَرے ناناپْرَکارانْیَدْبھُتانِ کَرْمّانِ لَکْشَنانِ چَ دَرْشَیِتْوا تانْ بَہِح کرِتْوا سَمانِنایَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","پْرَبھُح پَرَمیشْوَرو یُشْماکَں بھْراترِگَنَسْیَ مَدھْیے مادرِشَمْ ایکَں بھَوِشْیَدْوَکْتارَمْ اُتْپادَیِشْیَتِ تَسْیَ کَتھایاں یُویَں مَنو نِدھاسْیَتھَ، یو جَنَ اِسْراییلَح سَنْتانیبھْیَ ایناں کَتھاں کَتھَیاماسَ سَ ایشَ مُوساح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","مَہاپْرانْتَرَسْتھَمَنْڈَلِیمَدھْیےپِ سَ ایوَ سِینَیَپَرْوَّتوپَرِ تینَ سارْدّھَں سَںلاپِنو دُوتَسْیَ چاسْمَتْپِترِگَنَسْیَ مَدھْیَسْتھَح سَنْ اَسْمَبھْیَں داتَوْیَنِ جِیوَنَدایَکانِ واکْیانِ لیبھے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","اَسْماکَں پُورْوَّپُرُشاسْتَمْ اَمانْیَں کَتْوا سْویبھْیو دُورِیکرِتْیَ مِسَرَدیشَں پَراورِتْیَ گَنْتُں مَنوبھِرَبھِلَشْیَ ہارونَں جَگَدُح، ");
INSERT INTO sanurd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","اَسْماکَمْ اَگْرےگْرے گَنْتُुمْ اَسْمَدَرْتھَں دیوَگَنَں نِرْمّاہِ یَتو یو مُوسا اَسْمانْ مِسَرَدیشادْ بَہِح کرِتْوانِیتَوانْ تَسْیَ کِں جاتَں تَدَسْمابھِ رْنَ جْنایَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","تَسْمِنْ سَمَیے تے گووَتْساکرِتِں پْرَتِماں نِرْمّایَ تامُدِّشْیَ نَیویدْیَمُتْمرِجْیَ سْوَہَسْتَکرِتَوَسْتُنا آنَنْدِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","تَسْمادْ اِیشْوَرَسْتیشاں پْرَتِ وِمُکھَح سَنْ آکاشَسْتھَں جْیوتِرْگَنَں پُوجَیِتُں تیبھْیونُمَتِں دَدَو، یادرِشَں بھَوِشْیَدْوادِناں گْرَنْتھیشُ لِکھِتَماسْتے، یَتھا، اِسْراییلِییَوَںشا رے چَتْوارِںشَتْسَمانْ پُرا۔ مَہَتِ پْرانْتَرے سَںسْتھا یُویَنْتُ یانِ چَ۔ بَلِہومادِکَرْمّانِ کرِتَوَنْتَسْتُ تانِ کِں۔ ماں سَمُدِّشْیَ یُشْمابھِح پْرَکرِتانِیتِ نَیوَ چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","کِنْتُ وو مولَکاکھْیَسْیَ دیوَسْیَ دُوشْیَمیوَ چَ۔ یُشْماکَں رِمْپھَناکھْیایا دیوَتایاشْچَ تارَکا۔ ایتَیورُبھَیو رْمُورْتِی یُشْمابھِح پَرِپُوجِتے۔ اَتو یُشْماںسْتُ بابیلَح پارَں نیشْیامِ نِشْچِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","اَپَرَنْچَ یَنِّدَرْشَنَمْ اَپَشْیَسْتَدَنُسارینَ دُوشْیَں نِرْمّاہِ یَسْمِنْ اِیشْوَرو مُوسامْ ایتَدْواکْیَں بَبھاشے تَتْ تَسْیَ نِرُوپِتَں ساکْشْیَسْوَرُوپَں دُوشْیَمْ اَسْماکَں پُورْوَّپُرُشَیح سَہَ پْرانْتَرے تَسْتھَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","پَشْچاتْ یِہوشُویینَ سَہِتَیسْتیشاں وَںشَجاتَیرَسْمَتْپُورْوَّپُرُشَیح سْویشاں سَمُّکھادْ اِیشْوَرینَ دُورِیکرِتانامْ اَنْیَدیشِییاناں دیشادھِکرِتِکالے سَمانِیتَں تَدْ دُوشْیَں دایُودودھِکارَں یاوَتْ تَتْرَ سْتھانَ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","سَ دایُودْ پَرَمیشْوَرَسْیانُگْرَہَں پْراپْیَ یاکُوبْ اِیشْوَرارْتھَمْ ایکَں دُوشْیَں نِرْمّاتُں وَوانْچھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","کِنْتُ سُلیمانْ تَدَرْتھَں مَنْدِرَمْ ایکَں نِرْمِّتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","تَتھاپِ یَح سَرْوّوپَرِسْتھَح سَ کَسْمِںشْچِدْ ہَسْتَکرِتے مَنْدِرے نِوَسَتِیتِ نَہِ، بھَوِشْیَدْوادِی کَتھامیتاں کَتھَیَتِ، یَتھا، ");
INSERT INTO sanurd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","پَریشو وَدَتِ سْوَرْگو راجَسِںہاسَنَں مَمَ۔ مَدِییَں پادَپِیٹھَنْچَ پرِتھِوِی بھَوَتِ دھْرُوَں۔ تَرْہِ یُویَں کرِتے مے کِں پْرَنِرْمّاسْیَتھَ مَنْدِرَں۔ وِشْرامایَ مَدِییَں وا سْتھانَں کِں وِدْیَتے تْوِہَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","سَرْوّانْییتانِ وَسْتُونِ کِں مے ہَسْتَکرِتانِ نَ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ہے اَناجْناگْراہَکا اَنْتَحکَرَنے شْرَوَنے چاپَوِتْرَلوکاح یُویَمْ اَنَوَرَتَں پَوِتْرَسْیاتْمَنَح پْراتِکُولْیَمْ آچَرَتھَ، یُشْماکَں پُورْوَّپُرُشا یادرِشا یُویَمَپِ تادرِشاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","یُشْماکَں پُورْوَّپُرُشاح کَں بھَوِشْیَدْوادِنَں ناتاڈَیَنْ؟ یے تَسْیَ دھارْمِّکَسْیَ جَنَسْیاگَمَنَکَتھاں کَتھِتَوَنْتَسْتانْ اَگھْنَنْ یُویَمْ اَدھُونا وِشْواسَگھاتِنو بھُوتْوا تَں دھارْمِّکَں جَنَمْ اَہَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","یُویَں سْوَرْگِییَدُوتَگَنینَ وْیَوَسْتھاں پْراپْیاپِ تاں ناچَرَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","اِماں کَتھاں شْرُتْوا تے مَنَحسُ بِدّھاح سَنْتَسْتَں پْرَتِ دَنْتَگھَرْشَنَمْ اَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","کِنْتُ سْتِپھانَح پَوِتْریناتْمَنا پُورْنو بھُوتْوا گَگَنَں پْرَتِ سْتھِرَدرِشْٹِں کرِتْوا اِیشْوَرَسْیَ دَکْشِنے دَنْڈایَمانَں یِیشُنْچَ وِلوکْیَ کَتھِتَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","پَشْیَ،میگھَدْوارَں مُکْتَمْ اِیشْوَرَسْیَ دَکْشِنے سْتھِتَں مانَوَسُتَنْچَ پَشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","تَدا تے پْروچَّیح شَبْدَں کرِتْوا کَرْنیشْوَنْگُلِی رْنِدھایَ ایکَچِتِّیبھُویَ تَمْ آکْرَمَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","پَشْچاتْ تَں نَگَرادْ بَہِح کرِتْوا پْرَسْتَرَیراگھْنَنْ ساکْشِنو لاکاح شَولَنامْنو یُونَشْچَرَنَسَنِّدھَو نِجَوَسْتْرانِ سْتھاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","اَنَنْتَرَں ہے پْرَبھو یِیشے مَدِییَماتْمانَں گرِہانَ سْتِپھانَسْییتِ پْرارْتھَنَواکْیَوَدَنَسَمَیے تے تَں پْرَسْتَرَیراگھْنَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","تَسْماتْ سَ جانُنِی پاتَیِتْوا پْروچَّیح شَبْدَں کرِتْوا، ہے پْرَبھے پاپَمیتَدْ ایتیشُ ما سْتھاپَیَ، اِتْیُکْتْوا مَہانِدْراں پْراپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","تَسْیَ ہَتْیاکَرَنَں شَولوپِ سَمَمَنْیَتَ۔ تَسْمِنْ سَمَیے یِرُوشالَمْنَگَرَسْتھاں مَنْڈَلِیں پْرَتِ مَہاتاڈَنایاں جاتایاں پْریرِتَلوکانْ ہِتْوا سَرْوّےپَرے یِہُوداشومِرونَدیشَیو رْناناسْتھانے وِکِیرْناح سَنْتو گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","اَنْیَچَّ بھَکْتَلوکاسْتَں سْتِپھانَں شْمَشانے سْتھاپَیِتْوا بَہُ وْیَلَپَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","کِنْتُ شَولو گرِہے گرِہے بھْرَمِتْوا سْتْرِیَح پُرُشاںشْچَ دھرِتْوا کارایاں بَدّھوا مَنْڈَلْیا مَہوتْپاتَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","اَنْیَچَّ یے وِکِیرْنا اَبھَوَنْ تے سَرْوَّتْرَ بھْرَمِتْوا سُسَںوادَں پْراچارَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","تَدا پھِلِپَح شومِرونْنَگَرَں گَتْوا کھْرِیشْٹاکھْیانَں پْراچارَیَتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","تَتوشُچِ-بھرِتَگْرَسْتَلوکیبھْیو بھُوتاشْچِیتْکرِتْیاگَچّھَنْ تَتھا بَہَوَح پَکْشاگھاتِنَح کھَنْجا لوکاشْچَ سْوَسْتھا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","تَسْماتْ لاکا اِیدرِشَں تَسْیاشْچَرْیَّں کَرْمَّ وِلوکْیَ نِشَمْیَ چَ سَرْوَّ ایکَچِتِّیبھُویَ تینوکْتاکھْیانے مَناںسِ نْیَدَدھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","تَسْمِنَّگَرے مَہانَنْدَشْچابھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","تَتَح پُورْوَّں تَسْمِنَّگَرے شِمونّاما کَشْچِجَّنو بَہْوِی رْمایاکْرِیاح کرِتْوا سْوَں کَنْچَنَ مَہاپُرُشَں پْروچْیَ شومِرونِییاناں موہَں جَنَیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","تَسْماتْ سَ مانُشَ اِیشْوَرَسْیَ مَہاشَکْتِسْوَرُوپَ اِتْیُکْتْوا بالَورِدّھَوَنِتاح سَرْوّے لاکاسْتَسْمِنْ مَناںسِ نْیَدَدھُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","سَ بَہُکالانْ مایاوِکْرِیَیا سَرْوّانْ اَتِیوَ موہَیانْچَکارَ، تَسْماتْ تے تَں مینِرے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","کِنْتْوِیشْوَرَسْیَ راجْیَسْیَ یِیشُکھْرِیشْٹَسْیَ نامْنَشْچاکھْیانَپْرَچارِنَح پھِلِپَسْیَ کَتھایاں وِشْوَسْیَ تیشاں سْتْرِیپُرُشوبھَیَلوکا مَجِّتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","شیشے سَ شِمونَپِ سْوَیَں پْرَتْیَیتْ تَتو مَجِّتَح سَنْ پھِلِپینَ کرِتامْ آشْچَرْیَّکْرِیاں لَکْشَنَنْچَ وِلوکْیاسَمْبھَوَں مَنْیَمانَسْتینَ سَہَ سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","اِتّھَں شومِرونْدیشِییَلوکا اِیشْوَرَسْیَ کَتھامْ اَگرِہْلَنْ اِتِ وارْتّاں یِرُوشالَمْنَگَرَسْتھَپْریرِتاح پْراپْیَ پِتَرَں یوہَنَنْچَ تیشاں نِکَٹے پْریشِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","تَتَسْتَو تَتْ سْتھانَمْ اُپَسْتھایَ لوکا یَتھا پَوِتْرَمْ آتْمانَں پْراپْنُوَنْتِ تَدَرْتھَں پْرارْتھَییتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","یَتَسْتے پُرا کیوَلَپْرَبھُیِیشو رْنامْنا مَجِّتَماتْرا اَبھَوَنْ، نَ تُ تیشاں مَدھْیے کَمَپِ پْرَتِ پَوِتْرَسْیاتْمَنَ آوِرْبھاوو جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","کِنْتُ پْریرِتابھْیاں تیشاں گاتْریشُ کَریشْوَرْپِتیشُ سَتْسُ تے پَوِتْرَمْ آتْمانَمْ پْراپْنُوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","اِتّھَں لوکاناں گاتْریشُ پْریرِتَیوح کَرارْپَنینَ تانْ پَوِتْرَمْ آتْمانَں پْراپْتانْ درِشْٹْوا سَ شِمونْ تَیوح سَمِیپے مُدْرا آنِییَ کَتھِتَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","اَہَں یَسْیَ گاتْرے ہَسْتَمْ اَرْپَیِشْیامِ تَسْیاپِ یَتھیتّھَں پَوِتْراتْمَپْراپْتِ رْبھَوَتِ تادرِشِیں شَکْتِں مَہْیَں دَتَّں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","کِنْتُ پِتَرَسْتَں پْرَتْیَوَدَتْ تَوَ مُدْراسْتْوَیا وِنَشْیَنْتُ یَتَ اِیشْوَرَسْیَ دانَں مُدْرابھِح کْرِییَتے تْوَمِتّھَں بُدّھَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","اِیشْوَرایَ تاوَنْتَحکَرَنَں سَرَلَں نَہِ، تَسْمادْ اَتْرَ تَواںشودھِکارَشْچَ کوپِ ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","اَتَ ایتَتْپاپَہیتوح کھیدانْوِتَح سَنْ کیناپِ پْرَکارینَ تَوَ مَنَسَ ایتَسْیاح کُکَلْپَنایاح کْشَما بھَوَتِ، ایتَدَرْتھَمْ اِیشْوَرے پْرارْتھَناں کُرُ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","یَتَسْتْوَں تِکْتَپِتّے پاپَسْیَ بَنْدھَنے چَ یَدَسِ تَنْمَیا بُدّھَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","تَدا شِمونْ اَکَتھَیَتْ تَرْہِ یُوابھْیامُدِتا کَتھا مَیِ یَتھا نَ پھَلَتِ تَدَرْتھَں یُواں مَنِّمِتَّں پْرَبھَو پْرارْتھَناں کُرُتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","اَنینَ پْرَکارینَ تَو ساکْشْیَں دَتّوا پْرَبھوح کَتھاں پْرَچارَیَنْتَو شومِرونِییانامْ اَنیکَگْرامیشُ سُسَںوادَنْچَ پْرَچارَیَنْتَو یِرُوشالَمْنَگَرَں پَراورِتْیَ گَتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","تَتَح پَرَمْ اِیشْوَرَسْیَ دُوتَح پھِلِپَمْ اِتْیادِشَتْ، تْوَمُتّھایَ دَکْشِنَسْیاں دِشِ یو مارْگو پْرانْتَرَسْیَ مَدھْیینَ یِرُوشالَمو سانَگَرَں یاتِ تَں مارْگَں گَچّھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","تَتَح سَ اُتّھایَ گَتَوانْ؛ تَدا کَنْداکِینامْنَح کُوشْلوکاناں راجْنْیاح سَرْوَّسَمْپَتّیرَدھِیشَح کُوشَدیشِییَ ایکَح شَنْڈو بھَجَنارْتھَں یِرُوشالَمْنَگَرَمْ آگَتْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","پُنَرَپِ رَتھَمارُہْیَ یِشَیِیَنامْنو بھَوِشْیَدْوادِنو گْرَنْتھَں پَٹھَنْ پْرَتْیاگَچّھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ایتَسْمِنْ سَمَیے آتْما پھِلِپَمْ اَوَدَتْ، تْوَمْ رَتھَسْیَ سَمِیپَں گَتْوا تینَ سارْدّھَں مِلَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","تَسْماتْ سَ دھاوَنْ تَسْیَ سَنِّدھاوُپَسْتھایَ تینَ پَٹھْیَمانَں یِشَیِیَتھَوِشْیَدْوادِنو واکْیَں شْرُتْوا پرِشْٹَوانْ یَتْ پَٹھَسِ تَتْ کِں بُدھْیَسے؟ ");
INSERT INTO sanurd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","تَتَح سَ کَتھِتَوانْ کینَچِنَّ بودھِتوہَں کَتھَں بُدھْیییَ؟ تَتَح سَ پھِلِپَں رَتھَماروڈھُں سْوینَ سارْدّھَمْ اُپَویشْٹُنْچَ نْیَویدَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","سَ شاسْتْرَسْییتَدْواکْیَں پَٹھِتَوانْ یَتھا، سَمانِییَتَ گھاتایَ سَ یَتھا میشَشاوَکَح۔ لومَچّھیدَکَساکْشاچَّ میشَشْچَ نِیرَوو یَتھا۔ آبَدھْیَ وَدَنَں سْوِییَں تَتھا سَ سَمَتِشْٹھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","اَنْیایینَ وِچارینَ سَ اُچّھِنّو بھَوَتْ تَدا۔ تَتْکالِینَمَنُشْیانْ کو جَنو وَرْنَیِتُں کْشَمَح۔ یَتو جِیوَنّرِناں دیشاتْ سَ اُچّھِنّو بھَوَتْ دھْرُوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","اَنَنْتَرَں سَ پھِلِپَمْ اَوَدَتْ نِویدَیامِ، بھَوِشْیَدْوادِی یامِماں کَتھاں کَتھَیاماسَ سَ کِں سْوَسْمِنْ وا کَسْمِںشْچِدْ اَنْیَسْمِنْ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","تَتَح پھِلِپَسْتَتْپْرَکَرَنَمْ آرَبھْیَ یِیشورُپاکھْیانَں تَسْیاگْرے پْراسْتَوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","اِتّھَں مارْگینَ گَچّھَنْتَو جَلاشَیَسْیَ سَمِیپَ اُپَسْتھِتَو؛ تَدا کْلِیبووادِیتْ پَشْیاتْرَ سْتھانے جَلَماسْتے مَمَ مَجَّنے کا بادھا؟ ");
INSERT INTO sanurd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","تَتَح پھِلِپَ اُتَّرَں وْیاہَرَتْ سْوانْتَحکَرَنینَ ساکَں یَدِ پْرَتْییشِ تَرْہِ بادھا ناسْتِ۔ تَتَح سَ کَتھِتَوانْ یِیشُکھْرِیشْٹَ اِیشْوَرَسْیَ پُتْرَ اِتْیَہَں پْرَتْییمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","تَدا رَتھَں سْتھَگِتَں کَرْتُّمْ آدِشْٹے پھِلِپَکْلِیبَو دْوَو جَلَمْ اَوارُہَتاں؛ تَدا پھِلِپَسْتَمْ مَجَّیاماسَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","تَتْپَشْچاتْ جَلَمَدھْیادْ اُتّھِتَیوح سَتوح پَرَمیشْوَرَسْیاتْما پھِلِپَں ہرِتْوا نِیتَوانْ، تَسْماتْ کْلِیبَح پُنَسْتَں نَ درِشْٹَوانْ تَتھاپِ ہرِشْٹَچِتَّح سَنْ سْوَمارْگینَ گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","پھِلِپَشْچاسْدودْنَگَرَمْ اُپَسْتھایَ تَسْماتْ کَیسَرِیانَگَرَ اُپَسْتھِتِکالَپَرْیَّنَتَں سَرْوَّسْمِنَّگَرے سُسَںوادَں پْرَچارَیَنْ گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","تَتْکالَپَرْیَّنَتَں شَولَح پْرَبھوح شِشْیاناں پْراتِکُولْیینَ تاڈَنابَدھَیوح کَتھاں نِحسارَیَنْ مَہایاجَکَسْیَ سَنِّدھِں گَتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","سْتْرِیَں پُرُشَنْچَ تَنْمَتَگْراہِنَں یَں کَنْچِتْ پَشْیَتِ تانْ دھرِتْوا بَدّھوا یِرُوشالَمَمْ آنَیَتِیتْیاشَیینَ دَمّیشَکْنَگَرِییَں دھَرْمَّسَماجانْ پْرَتِ پَتْرَں یاچِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","گَچّھَنْ تُ دَمّیشَکْنَگَرَنِکَٹَ اُپَسْتھِتَوانْ؛ تَتوکَسْمادْ آکاشاتْ تَسْیَ چَتُرْدِکْشُ تیجَسَح پْرَکاشَناتْ سَ بھُوماوَپَتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","پَشْچاتْ ہے شَولَ ہے شَولَ کُتو ماں تاڈَیَسِ؟ سْوَں پْرَتِ پْروکْتَمْ ایتَں شَبْدَں شْرُتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","سَ پرِشْٹَوانْ، ہے پْرَبھو بھَوانْ کَح؟ تَدا پْرَبھُرَکَتھَیَتْ یَں یِیشُں تْوَں تاڈَیَسِ سَ ایواہَں؛ کَنْٹَکَسْیَ مُکھے پَداگھاتَکَرَنَں تَوَ کَشْٹَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","تَدا کَمْپَمانو وِسْمَیاپَنَّشْچَ سووَدَتْ ہے پْرَبھو مَیا کِں کَرْتَّوْیَں؟ بھَوَتَ اِچّھا کا؟ تَتَح پْرَبھُراجْناپَیَدْ اُتّھایَ نَگَرَں گَچّھَ تَتْرَ تْوَیا یَتْ کَرْتَّوْیَں تَدْ وَدِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","تَسْیَ سَنْگِنو لوکا اَپِ تَں شَبْدَں شْرُتَوَنْتَح کِنْتُ کَمَپِ نَ درِشْٹْوا سْتَبْدھاح سَنْتَح سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","اَنَنْتَرَں شَولو بھُومِتَ اُتّھایَ چَکْشُشِی اُنْمِیلْیَ کَمَپِ نَ درِشْٹَوانْ۔ تَدا لوکاسْتَسْیَ ہَسْتَو دھرِتْوا دَمّیشَکْنَگَرَمْ آنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","تَتَح سَ دِنَتْرَیَں یاوَدْ اَنْدھو بھُوتْوا نَ بھُکْتَوانْ پِیتَواںشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","تَدَنَنْتَرَں پْرَبھُسْتَدَّمّیشَکْنَگَرَواسِنَ ایکَسْمَے شِشْیایَ دَرْشَنَں دَتْوا آہُوتَوانْ ہے اَنَنِیَ۔ تَتَح سَ پْرَتْیَوادِیتْ، ہے پْرَبھو پَشْیَ شرِنومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","تَدا پْرَبھُسْتَماجْناپَیَتْ تْوَمُتّھایَ سَرَلَنامانَں مارْگَں گَتْوا یِہُودانِویشَنے تارْشَنَگَرِییَں شَولَنامانَں جَنَں گَویشَیَنْ پرِچّھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","پَشْیَ سَ پْرارْتھَیَتے، تَتھا اَنَنِیَنامَکَ ایکو جَنَسْتَسْیَ سَمِیپَمْ آگَتْیَ تَسْیَ گاتْرے ہَسْتارْپَنَں کرِتْوا درِشْٹِں دَداتِیتّھَں سْوَپْنے درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","تَسْمادْ اَنَنِیَح پْرَتْیَوَدَتْ ہے پْرَبھو یِرُوشالَمِ پَوِتْرَلوکانْ پْرَتِ سونیکَہِںساں کرِتَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","اَتْرَ سْتھانے چَ یے لوکاسْتَوَ نامْنِ پْرارْتھَیَنْتِ تانَپِ بَدّھُں سَ پْرَدھانَیاجَکیبھْیَح شَکْتِں پْراپْتَوانْ، اِماں کَتھامْ اَہَمْ اَنیکیشاں مُکھیبھْیَح شْرُتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","کِنْتُ پْرَبھُرَکَتھَیَتْ، یاہِ بھِنَّدیشِییَلوکاناں بھُوپَتِینامْ اِسْراییلّوکانانْچَ نِکَٹے مَمَ نامَ پْرَچارَیِتُں سَ جَنو مَمَ مَنونِیتَپاتْرَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","مَمَ نامَنِمِتَّنْچَ تینَ کِیانْ مَہانْ کْلیشو بھوکْتَوْیَ ایتَتْ تَں دَرْشَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","تَتو نَنِیو گَتْوا گرِہَں پْرَوِشْیَ تَسْیَ گاتْرے ہَسْتارْپْرَنَں کرِتْوا کَتھِتَوانْ، ہے بھْراتَح شَولَ تْوَں یَتھا درِشْٹِں پْراپْنوشِ پَوِتْریناتْمَنا پَرِپُورْنو بھَوَسِ چَ، تَدَرْتھَں تَواگَمَنَکالے یَح پْرَبھُیِیشُسْتُبھْیَں دَرْشَنَمْ اَدَداتْ سَ ماں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","اِتْیُکْتَماتْرے تَسْیَ چَکْشُرْبھْیامْ مِینَشَلْکَوَدْ وَسْتُنِ نِرْگَتے تَتْکْشَناتْ سَ پْرَسَنَّچَکْشُ رْبھُوتْوا پْروتّھایَ مَجِّتوبھَوَتْ بھُکْتْوا پِیتْوا سَبَلوبھَوَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","تَتَح پَرَں شَولَح شِشْیَیح سَہَ کَتِپَیَدِوَسانْ تَسْمِنْ دَمّیشَکَنَگَرے سْتھِتْواوِلَمْبَں ");
INSERT INTO sanurd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","سَرْوَّبھَجَنَبھَوَنانِ گَتْوا یِیشُرِیشْوَرَسْیَ پُتْرَ اِماں کَتھاں پْراچارَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","تَسْماتْ سَرْوّے شْروتارَشْچَمَتْکرِتْیَ کَتھِتَوَنْتو یو یِرُوشالَمْنَگَرَ ایتَنّامْنا پْرارْتھَیِترِلوکانْ وِناشِتَوانْ ایوَمْ ایتادرِشَلوکانْ بَدّھوا پْرَدھانَیاجَکَنِکَٹَں نَیَتِیتْیاشَیا ایتَتْسْتھانَمَپْیاگَچّھَتْ سَایوَ کِمَیَں نَ بھَوَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","کِنْتُ شَولَح کْرَمَشَ اُتْساہَوانْ بھُوتْوا یِیشُرِیشْوَرینابھِشِکْتو جَنَ ایتَسْمِنْ پْرَمانَں دَتْوا دَمّیشَکْ-نِواسِیِہُودِییَلوکانْ نِرُتَّرانْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","اِتّھَں بَہُتِتھے کالے گَتے یِہُودِییَلوکاسْتَں ہَنْتُں مَنْتْرَیاماسُح ");
INSERT INTO sanurd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","کِنْتُ شَولَسْتیشامیتَسْیا مَنْتْرَنایا وارْتّاں پْراپْتَوانْ۔ تے تَں ہَنْتُں تُ دِوانِشَں گُپْتاح سَنْتو نَگَرَسْیَ دْوارےتِشْٹھَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","تَسْماتْ شِشْیاسْتَں نِیتْوا راتْرَو پِٹَکے نِدھایَ پْراچِیریناواروہَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","تَتَح پَرَں شَولو یِرُوشالَمَں گَتْوا شِشْیَگَنینَ سارْدّھَں سْتھاتُمْ اَیہَتْ، کِنْتُ سَرْوّے تَسْمادَبِبھَیُح سَ شِشْیَ اِتِ چَ نَ پْرَتْیَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ایتَسْمادْ بَرْنَبّاسْتَں گرِہِیتْوا پْریرِتاناں سَمِیپَمانِییَ مارْگَمَدھْیے پْرَبھُح کَتھَں تَسْمَے دَرْشَنَں دَتَّوانْ یاح کَتھاشْچَ کَتھِتَوانْ سَ چَ یَتھاکْشوبھَح سَنْ دَمّیشَکْنَگَرے یِیشو رْنامَ پْراچارَیَتْ ایتانْ سَرْوَّورِتّانْتانْ تانْ جْناپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","تَتَح شَولَسْتَیح سَہَ یِرُوشالَمِ کالَں یاپَیَنْ نِرْبھَیَں پْرَبھو رْیِیشو رْنامَ پْراچارَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","تَسْمادْ اَنْیَدیشِییَلوکَیح سارْدّھَں وِوادَسْیوپَسْتھِتَتْواتْ تے تَں ہَنْتُمْ اَچیشْٹَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","کِنْتُ بھْراترِگَنَسْتَجّناتْوا تَں کَیسَرِیانَگَرَں نِیتْوا تارْشَنَگَرَں پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","اِتّھَں سَتِ یِہُودِیاگالِیلْشومِرونَدیشِییاح سَرْوّا مَنْڈَلْیو وِشْرامَں پْراپْتاسْتَتَسْتاساں نِشْٹھابھَوَتْ پْرَبھو رْبھِیا پَوِتْرَسْیاتْمَنَح سانْتْوَنَیا چَ کالَں کْشیپَیِتْوا بَہُسَںکھْیا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","تَتَح پَرَں پِتَرَح سْتھانے سْتھانے بھْرَمِتْوا شیشے لودْنَگَرَنِواسِپَوِتْرَلوکاناں سَمِیپے سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","تَدا تَتْرَ پَکْشاگھاتَوْیادھِناشْٹَو وَتْسَرانْ شَیّاگَتَمْ اَینییَنامانَں مَنُشْیَں ساکْشَتْ پْراپْیَ تَمَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ہے اَینییَ یِیشُکھْرِیشْٹَسْتْواں سْوَسْتھَمْ اَکارْشِیتْ، تْوَمُتّھایَ سْوَشَیّاں نِکْشِپَ، اِتْیُکْتَماتْرے سَ اُدَتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ایتادرِشَں درِشْٹْوا لودْشارونَنِواسِنو لوکاح پْرَبھُں پْرَتِ پَراوَرْتَّنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","اَپَرَنْچَ بھِکْشادانادِشُ نانَکْرِیاسُ نِتْیَں پْرَورِتّا یا یاپھونَگَرَنِواسِنِی ٹابِتھاناما شِشْیا یاں دَرْکّاں اَرْتھادْ ہَرِنِیمَیُکْتْوا آہْوَیَنْ سا نارِی ");
INSERT INTO sanurd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","تَسْمِنْ سَمَیے رُگْنا سَتِی پْرانانْ اَتْیَجَتْ، تَتو لوکاسْتاں پْرَکْشالْیوپَرِسْتھَپْرَکوشْٹھے شایَیِتْواسْتھاپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","لودْنَگَرَں یاپھونَگَرَسْیَ سَمِیپَسْتھَں تَسْماتَّتْرَ پِتَرَ آسْتے، اِتِ وارْتّاں شْرُتْوا تُورْنَں تَسْیاگَمَنارْتھَں تَسْمِنْ وِنَیَمُکْتْوا شِشْیَگَنو دْوَو مَنُجَو پْریشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","تَسْماتْ پِتَرَ اُتّھایَ تابھْیاں سارْدّھَمْ آگَچّھَتْ، تَتْرَ تَسْمِنْ اُپَسْتھِتَ اُپَرِسْتھَپْرَکوشْٹھَں سَمانِیتے چَ وِدھَواح سْوابھِح سَہَ سْتھِتِکالے دَرْکَّیا کرِتانِ یانْیُتَّرِییانِ پَرِدھییانِ چَ تانِ سَرْوّانِ تَں دَرْشَیِتْوا رُدَتْیَشْچَتَسرِشُ دِکْشْوَتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","کِنْتُ پِتَرَسْتاح سَرْوّا بَہِح کرِتْوا جانُنِی پاتَیِتْوا پْرارْتھِتَوانْ؛ پَشْچاتْ شَوَں پْرَتِ درِشْٹِں کرِتْوا کَتھِتَوانْ، ہے ٹابِیتھے تْوَمُتِّشْٹھَ، اِتِ واکْیَ اُکْتے سا سْتْرِی چَکْشُشِی پْرونْمِیلْیَ پِتَرَمْ اَوَلوکْیوتّھایوپاوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","تَتَح پِتَرَسْتَسْیاح کَرَو دھرِتْوا اُتّولْیَ پَوِتْرَلوکانْ وِدھَواشْچاہُویَ تیشاں نِکَٹے سَجِیواں تاں سَمارْپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ایشا کَتھا سَمَسْتَیاپھونَگَرَں وْیاپْتا تَسْمادْ اَنیکے لوکاح پْرَبھَو وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","اَپَرَنْچَ پِتَرَسْتَدْیاپھونَگَرِییَسْیَ کَسْیَچِتْ شِمونّامْنَشْچَرْمَّکارَسْیَ گرِہے بَہُدِنانِ نْیَوَسَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","کَیسَرِیانَگَرَ اِتالِیاکھْیَسَینْیانْتَرْگَتَح کَرْنِیلِیَناما سیناپَتِراسِیتْ ");
INSERT INTO sanurd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","سَ سَپَرِوارو بھَکْتَ اِیشْوَرَپَرایَنَشْچاسِیتْ؛ لوکیبھْیو بَہُونِ دانادِینِ دَتْوا نِرَنْتَرَمْ اِیشْوَرے پْرارْتھَیانْچَکْرے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ایکَدا ترِتِییَپْرَہَرَویلایاں سَ درِشْٹَوانْ اِیشْوَرَسْیَیکو دُوتَح سَپْرَکاشَں تَتْسَمِیپَمْ آگَتْیَ کَتھِتَوانْ، ہے کَرْنِیلِیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","کِنْتُ سَ تَں درِشْٹْوا بھِیتوکَتھَیَتْ، ہے پْرَبھو کِں؟ تَدا تَمَوَدَتْ تَوَ پْرارْتھَنا دانادِ چَ ساکْشِسْوَرُوپَں بھُوتْویشْوَرَسْیَ گوچَرَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","اِدانِیں یاپھونَگَرَں پْرَتِ لوکانْ پْریشْیَ سَمُدْرَتِیرے شِمونّامْنَشْچَرْمَّکارَسْیَ گرِہے پْرَواسَکارِی پِتَرَنامْنا وِکھْیاتو یَح شِمونْ تَمْ آہْوایَیَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","تَسْماتْ تْوَیا یَدْیَتْ کَرْتَّوْیَں تَتَّتْ سَ وَدِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","اِتْیُپَدِشْیَ دُوتے پْرَسْتھِتے سَتِ کَرْنِیلِیَح سْوَگرِہَسْتھاناں داساناں دْوَو جَنَو نِتْیَں سْوَسَنْگِناں سَینْیانامْ ایکاں بھَکْتَسینانْچاہُویَ ");
INSERT INTO sanurd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","سَکَلَمیتَں ورِتّانْتَں وِجْناپْیَ یاپھونَگَرَں تانْ پْراہِنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","پَرَسْمِنْ دِنے تے یاتْراں کرِتْوا یَدا نَگَرَسْیَ سَمِیپَ اُپاتِشْٹھَنْ، تَدا پِتَرو دْوِتِییَپْرَہَرَویلایاں پْرارْتھَیِتُں گرِہَپرِشْٹھَمْ آروہَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ایتَسْمِنْ سَمَیے کْشُدھارْتَّح سَنْ کِنْچِدْ بھوکْتُمْ اَیچّھَتْ کِنْتُ تیشامْ اَنّاسادَنَسَمَیے سَ مُورْچّھِتَح سَنَّپَتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","تَتو میگھَدْوارَں مُکْتَں چَتُرْبھِح کونَے رْلَمْبِتَں برِہَدْوَسْتْرَمِوَ کِنْچَنَ بھاجَنَمْ آکاشاتْ پرِتھِوِیمْ اَواروہَتِیتِ درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","تَنْمَدھْیے نانَپْرَکارا گْرامْیَوَنْیَپَشَوَح کھیچَروروگامِپْرَبھرِتَیو جَنْتَوَشْچاسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","اَنَنْتَرَں ہے پِتَرَ اُتّھایَ ہَتْوا بھُںکْشْوَ تَمْپْرَتِییَں گَگَنِییا وانِی جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","تَدا پِتَرَح پْرَتْیَوَدَتْ، ہے پْرَبھو اِیدرِشَں ما بھَوَتُ، اَہَمْ ایتَتْ کالَں یاوَتْ نِشِدّھَمْ اَشُچِ وا دْرَوْیَں کِنْچِدَپِ نَ بھُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","تَتَح پُنَرَپِ تادرِشِی وِہَیَسِییا وانِی جاتا یَدْ اِیشْوَرَح شُچِ کرِتَوانْ تَتْ تْوَں نِشِدّھَں نَ جانِیہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","اِتّھَں تْرِح سَتِ تَتْ پاتْرَں پُنَراکرِشْٹَں آکاشَمْ اَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","تَتَح پَرَں یَدْ دَرْشَنَں پْراپْتَوانْ تَسْیَ کو بھاوَ اِتْیَتْرَ پِتَرو مَنَسا سَنْدیگْدھِ، ایتَسْمِنْ سَمَیے کَرْنِیلِیَسْیَ تے پْریشِتا مَنُشْیا دْوارَسْیَ سَنِّدھاوُپَسْتھایَ، ");
INSERT INTO sanurd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","شِمونو گرِہَمَنْوِچّھَنْتَح سَمْپرِچھْیاہُویَ کَتھِتَوَنْتَح پِتَرَنامْنا وِکھْیاتو یَح شِمونْ سَ کِمَتْرَ پْرَوَسَتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","یَدا پِتَرَسْتَدَّرْشَنَسْیَ بھاوَں مَنَسانْدولَیَتِ تَداتْما تَمَوَدَتْ، پَشْیَ تْرَیو جَناسْتْواں مرِگَیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","تْوَمْ اُتّھایاوَرُہْیَ نِحسَنْدیہَں تَیح سَہَ گَچّھَ مَیَیوَ تے پْریشِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","تَسْماتْ پِتَرووَرُہْیَ کَرْنِیلِیَپْریرِتَلوکاناں نِکَٹَماگَتْیَ کَتھِتَوانْ پَشْیَتَ یُویَں یَں مرِگَیَدھْوے سَ جَنوہَں، یُویَں کِنِّمِتَّمْ آگَتاح؟ ");
INSERT INTO sanurd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","تَتَسْتے پْرَتْیَوَدَنْ کَرْنِیلِیَناما شُدّھَسَتّوَ اِیشْوَرَپَرایَنو یِہُودِییَدیشَسْتھاناں سَرْوّیشاں سَنِّدھَو سُکھْیاتْیاپَنَّ ایکَح سیناپَتِ رْنِجَگرِہَں تْواماہُویَ نیتُں تْوَتَّح کَتھا شْروتُنْچَ پَوِتْرَدُوتینَ سَمادِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","تَدا پِتَرَسْتانَبھْیَنْتَرَں نِیتْوا تیشاماتِتھْیَں کرِتَوانْ، پَرےہَنِ تَیح سارْدّھَں یاتْرامَکَروتْ، یاپھونِواسِناں بھْراترِناں کِیَنْتو جَناشْچَ تینَ سَہَ گَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","پَرَسْمِنْ دِوَسے کَیسَرِیانَگَرَمَدھْیَپْرَویشَسَمَیے کَرْنِیلِیو جْناتِبَنْدھُونْ آہُویانِییَ تانْ اَپیکْشْیَ سْتھِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","پِتَرے گرِہَ اُپَسْتھِتے کَرْنِیلِیَسْتَں ساکْشاتْکرِتْیَ چَرَنَیوح پَتِتْوا پْرانَمَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","پِتَرَسْتَمُتّھاپْیَ کَتھِتَوانْ، اُتِّشْٹھاہَمَپِ مانُشَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","تَدا کَرْنِیلِیینَ ساکَمْ آلَپَنْ گرِہَں پْراوِشَتْ تَنْمَدھْیے چَ بَہُلوکاناں سَماگَمَں درِشْٹْوا تانْ اَوَدَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","اَنْیَجاتِییَلوکَیح مَہالَپَنَں وا تیشاں گرِہَمَدھْیے پْرَویشَنَں یِہُودِییاناں نِشِدّھَمْ اَسْتِیتِ یُویَمْ اَوَگَچّھَتھَ؛ کِنْتُ کَمَپِ مانُشَمْ اَوْیَوَہارْیَّمْ اَشُچِں وا جْناتُں مَمَ نوچِتَمْ اِتِ پَرَمیشْوَرو ماں جْناپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","اِتِ ہیتوراہْوانَشْرَوَنَماتْراتْ کانْچَناپَتِّمْ اَکرِتْوا یُشْماکَں سَمِیپَمْ آگَتوسْمِ؛ پرِچّھامِ یُویَں کِنِّمِتَّں مامْ آہُویَتَ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","تَدا کَرْنِیلِیَح کَتھِتَوانْ، اَدْیَ چَتْوارِ دِنانِ جاتانِ ایتاوَدْویلاں یاوَدْ اَہَمْ اَناہارَ آسَنْ تَتَسْترِتِییَپْرَہَرے سَتِ گرِہے پْرارْتھَنَسَمَیے تیجومَیَوَسْتْرَبھرِدْ ایکو جَنو مَمَ سَمَکْشَں تِشْٹھَنْ ایتاں کَتھامْ اَکَتھَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ہے کَرْنِیلِیَ تْوَدِییا پْرارْتھَنا اِیشْوَرَسْیَ کَرْنَگوچَرِیبھُوتا تَوَ دانادِ چَ ساکْشِسْوَرُوپَں بھُوتْوا تَسْیَ درِشْٹِگوچَرَمَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","اَتو یاپھونَگَرَں پْرَتِ لوکانْ پْرَہِتْیَ تَتْرَ سَمُدْرَتِیرے شِمونّامْنَح کَسْیَچِچَّرْمَّکارَسْیَ گرِہے پْرَواسَکارِی پِتَرَنامْنا وِکھْیاتو یَح شِمونْ تَماہُوाیَیَ؛ تَتَح سَ آگَتْیَ تْوامْ اُپَدیکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","اِتِ کارَناتْ تَتْکْشَناتْ تَوَ نِکَٹے لوکانْ پْریشِتَوانْ، تْوَماگَتَوانْ اِتِ بھَدْرَں کرِتَوانْ۔ اِیشْوَرو یانْیاکھْیانانِ کَتھَیِتُمْ آدِشَتْ تانِ شْروتُں وَیَں سَرْوّے سامْپْرَتَمْ اِیشْوَرَسْیَ ساکْشادْ اُپَسْتھِتاح سْمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","تَدا پِتَرَ اِماں کَتھاں کَتھَیِتُمْ آرَبْدھَوانْ، اِیشْوَرو مَنُشْیانامْ اَپَکْشَپاتِی سَنْ ");
INSERT INTO sanurd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","یَسْیَ کَسْیَچِدْ دیشَسْیَ یو لوکاسْتَسْمادْبھِیتْوا سَتْکَرْمَّ کَروتِ سَ تَسْیَ گْراہْیو بھَوَتِ، ایتَسْیَ نِشْچَیَمْ اُپَلَبْدھَوانَہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","سَرْوّیشاں پْرَبھُ رْیو یِیشُکھْرِیشْٹَسْتینَ اِیشْوَرَ اِسْراییلْوَںشاناں نِکَٹے سُسَںوادَں پْریشْیَ سَمّیلَنَسْیَ یَں سَںوادَں پْراچارَیَتْ تَں سَںوادَں یُویَں شْرُتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","یَتو یوہَنا مَجَّنے پْرَچارِتے سَتِ سَ گالِیلَدیشَمارَبھْیَ سَمَسْتَیِہُودِییَدیشَں وْیاپْنوتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","پھَلَتَ اِیشْوَرینَ پَوِتْریناتْمَنا شَکْتْیا چابھِشِکْتو ناسَرَتِییَیِیشُح سْتھانے سْتھانے بھْرَمَنْ سُکْرِیاں کُرْوَّنْ شَیتانا کْلِشْٹانْ سَرْوَّلوکانْ سْوَسْتھانْ اَکَروتْ، یَتَ اِیشْوَرَسْتَسْیَ سَہایَ آسِیتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","وَیَنْچَ یِہُودِییَدیشے یِرُوشالَمْنَگَرے چَ تینَ کرِتاناں سَرْوّیشاں کَرْمَّناں ساکْشِنو بھَوامَح۔ لوکاسْتَں کْرُشے وِدّھوا ہَتَوَنْتَح، ");
INSERT INTO sanurd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","کِنْتُ ترِتِییَدِوَسے اِیشْوَرَسْتَمُتّھاپْیَ سَپْرَکاشَمْ اَدَرْشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","سَرْوَّلوکاناں نِکَٹَ اِتِ نَ ہِ، کِنْتُ تَسْمِنْ شْمَشانادُتّھِتے سَتِ تینَ سارْدّھَں بھوجَنَں پانَنْچَ کرِتَوَنْتَ ایتادرِشا اِیشْوَرَسْیَ مَنونِیتاح ساکْشِنو یے وَیَمْ اَسْماکَں نِکَٹے تَمَدَرْشَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","جِیوِتَمرِتوبھَیَلوکاناں وِچارَں کَرْتُّمْ اِیشْوَرو یَں نِیُکْتَوانْ سَ ایوَ سَ جَنَح، اِماں کَتھاں پْرَچارَیِتُں تَسْمِنْ پْرَمانَں داتُنْچَ سوسْمانْ آجْناپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","یَسْتَسْمِنْ وِشْوَسِتِ سَ تَسْیَ نامْنا پاپانْمُکْتو بھَوِشْیَتِ تَسْمِنْ سَرْوّے بھَوِشْیَدْوادِنوپِ ایتادرِشَں ساکْشْیَں دَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","پِتَرَسْیَیتَتْکَتھاکَتھَنَکالے سَرْوّیشاں شْروترِنامُپَرِ پَوِتْرَ آتْماواروہَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","تَتَح پِتَرینَ سارْدّھَمْ آگَتاسْتْوَکْچھیدِنو وِشْواسِنو لوکا اَنْیَدیشِیییبھْیَح پَوِتْرَ آتْمَنِ دَتّے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","تے ناناجاتِییَبھاشابھِح کَتھاں کَتھَیَنْتَ اِیشْوَرَں پْرَشَںسَنْتِ، اِتِ درِشْٹْوا شْرُتْوا چَ وِسْمَیَمْ آپَدْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","تَدا پِتَرَح کَتھِتَوانْ، وَیَمِوَ یے پَوِتْرَمْ آتْمانَں پْراپْتاسْتیشاں جَلَمَجَّنَں کِں کوپِ نِشیدّھُں شَکْنوتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","تَتَح پْرَبھو رْنامْنا مَجِّتا بھَوَتیتِ تاناجْناپَیَتْ۔ اَنَنْتَرَں تے سْوَیح سارْدّھَں کَتِپَیَدِنانِ سْتھاتُں پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","اِتّھَں بھِنَّدیشِییَلوکا اَپِیشْوَرَسْیَ واکْیَمْ اَگرِہْلَنْ اِماں وارْتّاں یِہُودِییَدیشَسْتھَپْریرِتا بھْراترِگَنَشْچَ شْرُتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","تَتَح پِتَرے یِرُوشالَمْنَگَرَں گَتَوَتِ تْوَکْچھیدِنو لوکاسْتینَ سَہَ وِوَدَمانا اَوَدَنْ، ");
INSERT INTO sanurd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","تْوَمْ اَتْوَکْچھیدِلوکاناں گرِہَں گَتْوا تَیح سارْدّھَں بھُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","تَتَح پِتَرَ آدِتَح کْرَمَشَسْتَتْکارْیَّسْیَ سَرْوَّورِتّانْتَماکھْیاتُمْ آرَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","یاپھونَگَرَ ایکَداہَں پْرارْتھَیَمانو مُورْچّھِتَح سَنْ دَرْشَنینَ چَتُرْشُ کونیشُ لَمْبَنَمانَں ورِہَدْوَسْتْرَمِوَ پاتْرَمیکَمْ آکاشَدَوَرُہْیَ مَنِّکَٹَمْ آگَچّھَدْ اَپَشْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","پَشْچاتْ تَدْ اَنَنْیَدرِشْٹْیا درِشْٹْوا وِوِچْیَ تَسْیَ مَدھْیے ناناپْرَکارانْ گْرامْیَوَنْیَپَشُونْ اُروگامِکھیچَراںشْچَ درِشْٹَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ہے پِتَرَ تْوَمُتّھایَ گَتْوا بھُںکْشْوَ ماں سَمْبودھْیَ کَتھَیَنْتَں شَبْدَمیکَں شْرُتَواںشْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","تَتوہَں پْرَتْیَوَدَں، ہے پْرَبھو نیتّھَں بھَوَتُ، یَتَح کِنْچَنَ نِشِدّھَمْ اَشُچِ دْرَوْیَں وا مَمَ مُکھَمَدھْیَں کَداپِ نَ پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","اَپَرَمْ اِیشْوَرو یَتْ شُچِ کرِتَوانْ تَنِّشِدّھَں نَ جانِیہِ دْوِ رْمامْپْرَتِیدرِشِی وِہایَسِییا وانِی جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","تْرِرِتّھَں سَتِ تَتْ سَرْوَّں پُنَراکاشَمْ آکرِشْٹَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","پَشْچاتْ کَیسَرِیانَگَراتْ تْرَیو جَنا مَنِّکَٹَں پْریشِتا یَتْرَ نِویشَنے سْتھِتوہَں تَسْمِنْ سَمَیے تَتْروپاتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","تَدا نِحسَنْدیہَں تَیح سارْدّھَں یاتُمْ آتْما مامادِشْٹَوانْ؛ تَتَح پَرَں مَیا سَہَیتیشُ شَڈْبھْراترِشُ گَتیشُ وَیَں تَسْیَ مَنُجَسْیَ گرِہَں پْراوِشامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","سوسْماکَں نِکَٹے کَتھامیتامْ اَکَتھَیَتْ ایکَدا دُوتَ ایکَح پْرَتْیَکْشِیبھُویَ مَمَ گرِہَمَدھْیے تِشْٹَنْ مامِتْیاجْناپِتَوانْ، یاپھونَگَرَں پْرَتِ لوکانْ پْرَہِتْیَ پِتَرَنامْنا وِکھْیاتَں شِمونَمْ آہُویَیَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","تَتَسْتَوَ تْوَدِییَپَرِوارانانْچَ یینَ پَرِتْرانَں بھَوِشْیَتِ تَتْ سَ اُپَدیکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","اَہَں تاں کَتھامُتّھاپْیَ کَتھِتَوانْ تینَ پْرَتھَمَمْ اَسْماکَمْ اُپَرِ یَتھا پَوِتْرَ آتْماوَرُوڈھَوانْ تَتھا تیشامَپْیُپَرِ سَمَوَرُوڈھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","تینَ یوہَنْ جَلے مَجِّتَوانْ اِتِ سَتْیَں کِنْتُ یُویَں پَوِتْرَ آتْمَنِ مَجِّتا بھَوِشْیَتھَ، اِتِ یَدْواکْیَں پْرَبھُرُدِتَوانْ تَتْ تَدا مَیا سْمرِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","اَتَح پْرَبھا یِیشُکھْرِیشْٹے پْرَتْیَیَکارِنو یے وَیَمْ اَسْمَبھْیَمْ اِیشْوَرو یَدْ دَتَّوانْ تَتْ تیبھْیو لوکیبھْیوپِ دَتَّوانْ تَتَح کوہَں؟ کِمَہَمْ اِیشْوَرَں وارَیِتُں شَکْنومِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","کَتھامیتاں شْرُوا تے کْشانْتا اِیشْوَرَسْیَ گُنانْ اَنُکِیرْتّیَ کَتھِتَوَنْتَح، تَرْہِ پَرَمایُحپْراپْتِنِمِتَّمْ اِیشْوَرونْیَدیشِییَلوکیبھْیوپِ مَنَحپَرِوَرْتَّنَرُوپَں دانَمْ اَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","سْتِپھانَں پْرَتِ اُپَدْرَوے گھَٹِتے یے وِکِیرْنا اَبھَوَنْ تَے پھَینِیکِیکُپْرانْتِیَکھِیاسُ بھْرَمِتْوا کیوَلَیِہُودِییَلوکانْ وِنا کَسْیاپْیَنْیَسْیَ سَمِیپَ اِیشْوَرَسْیَ کَتھاں نَ پْراچارَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","اَپَرَں تیشاں کُپْرِییاح کُرِینِییاشْچَ کِیَنْتو جَنا آنْتِیَکھِیانَگَرَں گَتْوا یُونانِییَلوکاناں سَمِیپیپِ پْرَبھورْیِیشوح کَتھاں پْراچارَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","پْرَبھوح کَرَسْتیشاں سَہایَ آسِیتْ تَسْمادْ اَنیکے لوکا وِشْوَسْیَ پْرَبھُں پْرَتِ پَراوَرْتَّنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","اِتِ وارْتّایاں یِرُوشالَمَسْتھَمَنْڈَلِییَلوکاناں کَرْنَگوچَرِیبھُوتایامْ آنْتِیَکھِیانَگَرَں گَنْتُ تے بَرْنَبّاں پْرَیرَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","تَتو بَرْنَبّاسْتَتْرَ اُپَسْتھِتَح سَنْ اِیشْوَرَسْیانُگْرَہَسْیَ پھَلَں درِشْٹْوا سانَنْدو جاتَح، ");
INSERT INTO sanurd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","سَ سْوَیَں سادھُ رْوِشْواسینَ پَوِتْریناتْمَنا چَ پَرِپُورْنَح سَنْ گَنونِشْٹَیا پْرَبھاواسْتھاں کَرْتُّں سَرْوّانْ اُپَدِشْٹَوانْ تینَ پْرَبھوح شِشْیا اَنیکے بَبھُووُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","شیشے شَولَں مرِگَیِتُں بَرْنَبّاسْتارْشَنَگَرَں پْرَسْتھِتَوانْ۔ تَتْرَ تَسْیودّیشَں پْراپْیَ تَمْ آنْتِیَکھِیانَگَرَمْ آنَیَتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","تَتَسْتَو مَنْڈَلِیسْتھَلوکَیح سَبھاں کرِتْوا سَںوَتْسَرَمیکَں یاوَدْ بَہُلوکانْ اُپادِشَتاں؛ تَسْمِنْ آنْتِیَکھِیانَگَرے شِشْیاح پْرَتھَمَں کھْرِیشْٹِییَنامْنا وِکھْیاتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","تَتَح پَرَں بھَوِشْیَدْوادِگَنے یِرُوشالَمَ آنْتِیَکھِیانَگَرَمْ آگَتے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","آگابَناما تیشامیکَ اُتّھایَ آتْمَنَح شِکْشَیا سَرْوَّدیشے دُرْبھِکْشَں بھَوِشْیَتِیتِ جْناپِتَوانْ؛ تَتَح کْلَودِیَکَیسَرَسْیادھِکارے سَتِ تَتْ پْرَتْیَکْشَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","تَسْماتْ شِشْیا ایکَیکَشَح سْوَسْوَشَکْتْیَنُسارَتو یِہُودِییَدیشَنِواسِناں بھْرَترِناں دِنَیاپَنارْتھَں دھَنَں پْریشَیِتُں نِشْچِتْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","بَرْنَبّاشَولَیو رْدْوارا پْراچِینَلوکاناں سَمِیپَں تَتْ پْریشِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","تَسْمِنْ سَمَیے ہیرودْ‌راجو مَنْڈَلْیاح کِیَجَّنیبھْیو دُحکھَں داتُں پْرارَبھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","وِشیشَتو یوہَنَح سودَرَں یاکُوبَں کَرَوالاگھاتینْ ہَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","تَسْمادْ یِہُودِییاح سَنْتُشْٹا اَبھَوَنْ اِتِ وِجْنایَ سَ پِتَرَمَپِ دھَرْتُّں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","تَدا کِنْوَشُونْیَپُوپوتْسَوَسَمَیَ اُپاتِشْٹَتْ؛ اَتَ اُتْسَوے گَتے سَتِ لوکاناں سَمَکْشَں تَں بَہِرانییّامِیتِ مَنَسِ سْتھِرِیکرِتْیَ سَ تَں دھارَیِتْوا رَکْشْنارْتھَمْ ییشامْ ایکَیکَسَںگھے چَتْوارو جَناح سَنْتِ تیشاں چَتُرْناں رَکْشَکَسَںگھاناں سَمِیپے تَں سَمَرْپْیَ کارایاں سْتھاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","کِنْتُں پِتَرَسْیَ کاراسْتھِتِکارَناتْ مَنْڈَلْیا لوکا اَوِشْرامَمْ اِیشْوَرَسْیَ سَمِیپے پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","اَنَنْتَرَں ہیرودِ تَں بَہِرانایِتُں اُدْیَتے سَتِ تَسْیاں راتْرَو پِتَرو رَکْشَکَدْوَیَمَدھْیَسْتھانے شرِنْکھَلَدْوَیینَ بَدّھوَح سَنْ نِدْرِتَ آسِیتْ، دَووارِکاشْچَ کارایاح سَمُّکھے تِشْٹھَنَتو دْوارَمْ اَرَکْشِشُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ایتَسْمِنْ سَمَیے پَرَمیشْوَرَسْیَ دُوتے سَمُپَسْتھِتے کارا دِیپْتِمَتِی جاتا؛ تَتَح سَ دُوتَح پِتَرَسْیَ کُکْشاواواتَں کرِتْوا تَں جاگَرَیِتْوا بھاشِتَوانْ تُورْنَمُتِّشْٹھَ؛ تَتَسْتَسْیَ ہَسْتَسْتھَشرِنْکھَلَدْوَیَں گَلَتْ پَتِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","سَ دُوتَسْتَمَوَدَتْ، بَدّھَکَٹِح سَنْ پادَیوح پادُکے اَرْپَیَ؛ تینَ تَتھا کرِتے سَتِ دُوتَسْتَمْ اُکْتَوانْ گاتْرِییَوَسْتْرَں گاتْرے نِدھایَ مَمَ پَشْچادْ ایہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","تَتَح پِتَرَسْتَسْیَ پَشْچادْ وْرَجَنَ بَہِرَگَچّھَتْ، کِنْتُ دُوتینَ کَرْمَّیتَتْ کرِتَمِتِ سَتْیَمَجْناتْوا سْوَپْنَدَرْشَنَں جْناتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","اِتّھَں تَو پْرَتھَماں دْوِتِییانْچَ کاراں لَنْگھِتْوا یینَ لَوہَنِرْمِّتَدْوارینَ نَگَرَں گَمْیَتے تَتْسَمِیپَں پْراپْنُتاں؛ تَتَسْتَسْیَ کَواٹَں سْوَیَں مُکْتَمَبھَوَتْ تَتَسْتَو تَتْسْتھانادْ بَہِ رْبھُوتْوا مارْگَیکَسْیَ سِیماں یاوَدْ گَتَو؛ تَتوکَسْماتْ سَ دُوتَح پِتَرَں تْیَکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","تَدا سَ چیتَناں پْراپْیَ کَتھِتَوانْ نِجَدُوتَں پْرَہِتْیَ پَرَمیشْوَرو ہیرودو ہَسْتادْ یِہُودِییَلوکاناں سَرْوّاشایاشْچَ ماں سَمُدّھرِتَوانْ اِتْیَہَں نِشْچَیَں جْناتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","سَ وِوِچْیَ مارْکَنامْرا وِکھْیاتَسْیَ یوہَنو ماتُ رْمَرِیَمو یَسْمِنْ گرِہے بَہَوَح سَمْبھُویَ پْرارْتھَیَنْتَ تَنِّویشَنَں گَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","پِتَرینَ بَہِرْدْوارَ آہَتے سَتِ روداناما بالِکا دْرَشْٹُں گَتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","تَتَح پِتَرَسْیَ سْوَرَں شْرُوا سا ہَرْشَیُکْتا سَتِی دْوارَں نَ موچَیِتْوا پِتَرو دْوارے تِشْٹھَتِیتِ وارْتّاں وَکْتُمْ اَبھْیَنْتَرَں دھاوِتْوا گَتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","تے پْراووچَنْ تْوَمُنْمَتّا جاتاسِ کِنْتُ سا مُہُرْمُہُرُکْتَوَتِی سَتْیَمیوَیتَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","تَدا تے کَتھِتَوَنْتَسْتَرْہِ تَسْیَ دُوتو بھَویتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","پِتَرو دْوارَماہَتَوانْ ایتَسْمِنَّنْتَرے دْوارَں موچَیِتْوا پِتَرَں درِشْٹْوا وِسْمَیَں پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","تَتَح پِتَرو نِحشَبْدَں سْتھاتُں تانْ پْرَتِ ہَسْتینَ سَنْکیتَں کرِتْوا پَرَمیشْوَرو یینَ پْرَکارینَ تَں کارایا اُدّھرِتْیانِیتَوانْ تَسْیَ ورِتّانْتَں تانَجْناپَیَتْ، یُویَں گَتْوا یاکُبَں بھْراترِگَنَنْچَ وارْتّامیتاں وَدَتیتْیُکْتا سْتھانانْتَرَں پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","پْرَبھاتے سَتِ پِتَرَح کْوَ گَتَ اِتْیَتْرَ رَکْشَکاناں مَدھْیے مَہانْ کَلَہو جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ہیرودْ بَہُ مرِگَیِتْوا تَسْیودّیشے نَ پْراپْتے سَتِ رَکْشَکانْ سَںپرِچّھیَ تیشاں پْرانانْ ہَنْتُمْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","پَشْچاتْ سَ یِہُودِییَپْرَدیشاتْ کَیسَرِیانَگَرَں گَتْوا تَتْراواتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","سورَسِیدونَدیشَیو رْلوکیبھْیو ہیرودِ یُیُتْسَو سَتِ تے سَرْوَّ ایکَمَنْتْرَناح سَنْتَسْتَسْیَ سَمِیپَ اُپَسْتھایَ لْواسْتَنامانَں تَسْیَ وَسْتْرَگرِہادھِیشَں سَہایَں کرِتْوا ہیرودا سارْدّھَں سَنْدھِں پْرارْتھَیَنْتَ یَتَسْتَسْیَ راجْنو دیشینَ تیشاں دیشِییاناں بھَرَنَمْ اَبھَوَتْں ");
INSERT INTO sanurd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","اَتَح کُتْرَچِنْ نِرُپِتَدِنے ہیرودْ راجَکِییَں پَرِچّھَدَں پَرِدھایَ سِںہاسَنے سَمُپَوِشْیَ تانْ پْرَتِ کَتھامْ اُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","تَتو لوکا اُچَّیحکارَں پْرَتْیَوَدَنْ، ایشَ مَنُجَرَوو نَ ہِ، اِیشْوَرِییَرَوَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","تَدا ہیرودْ اِیشْوَرَسْیَ سَمّانَں ناکَروتْ؛ تَسْمادّھیتوح پَرَمیشْوَرَسْیَ دُوتو ہَٹھاتْ تَں پْراہَرَتْ تینَیوَ سَ کِیٹَیح کْشِینَح سَنْ پْرانانْ اَجَہاتْ۔ کِنْتْوِیشْوَرَسْیَ کَتھا دیشَں وْیاپْیَ پْرَبَلابھَوَتْ۔ تَتَح پَرَں بَرْنَبّاشَولَو یَسْیَ کَرْمَّنو بھارَں پْراپْنُتاں تابھْیاں تَسْمِنْ سَمْپادِتے سَتِ مارْکَنامْنا وِکھْیاتو یو یوہَنْ تَں سَنْگِنَں کرِتْوا یِرُوشالَمْنَگَراتْ پْرَتْیاگَتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","اَپَرَنْچَ بَرْنَبّاح، شِمونْ یَں نِگْرَں وَدَنْتِ، کُرِینِییَلُوکِیو ہیرودا راجْنا سَہَ کرِتَوِدْیاाبھْیاسو مِنَہیمْ، شَولَشْچَیتے یے کِیَنْتو جَنا بھَوِشْیَدْوادِنَ اُپَدیشْٹارَشْچانْتِیَکھِیانَگَرَسْتھَمَنْڈَلْیامْ آسَنْ، ");
INSERT INTO sanurd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","تے یَدوپَواسَں کرِتْویشْوَرَمْ اَسیوَنْتَ تَسْمِنْ سَمَیے پَوِتْرَ آتْما کَتھِتَوانْ اَہَں یَسْمِنْ کَرْمَّنِ بَرْنَبّاشَیلَو نِیُکْتَوانْ تَتْکَرْمَّ کَرْتُّں تَو پرِتھَکْ کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","تَتَسْتَیرُپَواسَپْرارْتھَنَیوح کرِتَیوح سَتوسْتے تَیو رْگاتْرَیو رْہَسْتارْپَنَں کرِتْوا تَو وْیَسرِجَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","تَتَح پَرَں تَو پَوِتْریناتْمَنا پْریرِتَو سَنْتَو سِلُوکِیانَگَرَمْ اُپَسْتھایَ سَمُدْرَپَتھینَ کُپْروپَدْوِیپَمْ اَگَچّھَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","تَتَح سالامِینَگَرَمْ اُپَسْتھایَ تَتْرَ یِہُودِییاناں بھَجَنَبھَوَنانِ گَتْویشْوَرَسْیَ کَتھاں پْراچارَیَتاں؛ یوہَنَپِ تَتْسَہَچَروبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","اِتّھَں تے تَسْیوپَدْوِیپَسْیَ سَرْوَّتْرَ بھْرَمَنْتَح پاپھَنَگَرَمْ اُپَسْتھِتاح؛ تَتْرَ سُوِویچَکینَ سَرْجِیَپَولَنامْنا تَدّیشادھِپَتِنا سَہَ بھَوِشْیَدْوادِنو ویشَدھارِی بَرْیِیشُناما یو مایاوِی یِہُودِی آسِیتْ تَں ساکْشاتْ پْراپْتَوَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","تَدّیشادھِپَ اِیشْوَرَسْیَ کَتھاں شْروتُں وانْچھَنْ پَولَبَرْنَبَّو نْیَمَنْتْرَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","کِنْتْوِلُما یَں مایاوِنَں وَدَنْتِ سَ دیشادھِپَتِں دھَرْمَّمارْگادْ بَہِرْبھُوتَں کَرْتُّمْ اَیَتَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","تَسْماتْ شولورْتھاتْ پَولَح پَوِتْریناتْمَنا پَرِپُورْنَح سَنْ تَں مایاوِنَں پْرَتْیَنَنْیَدرِشْٹِں کرِتْواکَتھَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ہے نَرَکِنْ دھَرْمَّدْویشِنْ کَوٹِلْیَدُشْکَرْمَّپَرِپُورْنَ، تْوَں کِں پْرَبھوح سَتْیَپَتھَسْیَ وِپَرْیَّیَکَرَناتْ کَداپِ نَ نِوَرْتِّشْیَسے؟ ");
INSERT INTO sanurd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","اَدھُنا پَرَمیشْوَرَسْتَوَ سَمُچِتَں کَرِشْیَتِ تینَ کَتِپَیَدِنانِ تْوَمْ اَنْدھَح سَنْ سُورْیَّمَپِ نَ دْرَکْشْیَسِ۔ تَتْکْشَنادْ راتْرِوَدْ اَنْدھَکارَسْتَسْیَ درِشْٹِمْ آچّھادِتَوانْ؛ تَسْماتْ تَسْیَ ہَسْتَں دھَرْتُّں سَ لوکَمَنْوِچّھَنْ اِتَسْتَتو بھْرَمَنَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ایناں گھَٹَناں درِشْٹْوا سَ دیشادھِپَتِح پْرَبھُوپَدیشادْ وِسْمِتْیَ وِشْواسَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","تَدَنَنْتَرَں پَولَسْتَتْسَنْگِنَو چَ پاپھَنَگَراتْ پْروتَں چالَیِتْوا پَمْپھُلِیادیشَسْیَ پَرْگِینَگَرَمْ اَگَچّھَنْ کِنْتُ یوہَنْ تَیوح سَمِیپادْ ایتْیَ یِرُوشالَمَں پْرَتْیاگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","پَشْچاتْ تَو پَرْگِیتو یاتْراں کرِتْوا پِسِدِیادیشَسْیَ آنْتِیَکھِیانَگَرَمْ اُپَسْتھایَ وِشْرامَوارے بھَجَنَبھَوَنَں پْرَوِشْیَ سَمُپاوِشَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","وْیَوَسْتھابھَوِشْیَدْواکْیَیوح پَٹھِتَیوح سَتو رْہے بھْراتَرَو لوکانْ پْرَتِ یُوَیوح کاچِدْ اُپَدیشَکَتھا یَدْیَسْتِ تَرْہِ تاں وَدَتَں تَو پْرَتِ تَسْیَ بھَجَنَبھَوَنَسْیادھِپَتَیَح کَتھامْ ایتاں کَتھَیِتْوا پْرَیشَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","اَتَح پَولَ اُتِّشْٹھَنْ ہَسْتینَ سَنْکیتَں کُرْوَّنْ کَتھِتَوانْ ہے اِسْراییلِییَمَنُشْیا اِیشْوَرَپَرایَناح سَرْوّے لوکا یُویَمْ اَوَدھَدّھَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ایتیشامِسْراییلّوکانامْ اِیشْوَروسْماکَں پُورْوَّپَرُشانْ مَنونِیتانْ کَتْوا گرِہِیتَوانْ تَتو مِسَرِ دیشے پْرَوَسَنَکالے تیشامُنَّتِں کرِتْوا تَسْماتْ سْوِییَباہُبَلینَ تانْ بَہِح کرِتْوا سَمانَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","چَتْوارِںشَدْوَتْسَرانْ یاوَچَّ مَہاپْرانْتَرے تیشاں بھَرَنَں کرِتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","کِنانْدیشانْتَرْوَّرْتِّینِ سَپْتَراجْیانِ ناشَیِتْوا گُٹِکاپاتینَ تیشُ سَرْوَّدیشیشُ تیبھْیودھِکارَں دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","پَنْچاشَدَدھِکَچَتُحشَتیشُ وَتْسَریشُ گَتیشُ چَ شِمُوییلْبھَوِشْیَدْوادِپَرْیَّنْتَں تیشامُپَرِ وِچارَیِترِنْ نِیُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","تَیشْچَ راجْنِ پْرارْتھِتے، اِیشْوَرو بِنْیامِینو وَںشَجاتَسْیَ کِیشَح پُتْرَں شَولَں چَتْوارِںشَدْوَرْشَپَرْیَّنْتَں تیشامُپَرِ راجانَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","پَشْچاتْ تَں پَدَچْیُتَں کرِتْوا یو مَدِشْٹَکْرِیاح سَرْوّاح کَرِشْیَتِ تادرِشَں مَمَ مَنوبھِمَتَمْ ایکَں جَنَں یِشَیَح پُتْرَں دایُودَں پْراپْتَوانْ اِدَں پْرَمانَں یَسْمِنْ دایُودِ سَ دَتَّوانْ تَں دایُودَں تیشامُپَرِ راجَتْوَں کَرْتُّمْ اُتْپادِتَوانَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","تَسْیَ سْوَپْرَتِشْرُتَسْیَ واکْیَسْیانُسارینَ اِسْراییلّوکاناں نِمِتَّں تیشاں مَنُشْیاناں وَںشادْ اِیشْوَرَ ایکَں یِیشُں (تْراتارَمْ) اُدَپادَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","تَسْیَ پْرَکاشَناتْ پُورْوَّں یوہَنْ اِسْراییلّوکاناں سَنِّدھَو مَنَحپَراوَرْتَّنَرُوپَں مَجَّنَں پْراچارَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","یَسْیَ چَ کَرْمَّنوे بھارَں پْرَپْتَوانْ یوہَنْ تَنْ نِشْپادَیَنْ ایتاں کَتھاں کَتھِتَوانْ، یُویَں ماں کَں جَنَں جانِیتھَ؟ اَہَمْ اَبھِشِکْتَتْراتا نَہِ، کِنْتُ پَشْیَتَ یَسْیَ پادَیوح پادُکَیو رْبَنْدھَنے موچَیِتُمَپِ یوگْیو نَ بھَوامِ تادرِشَ ایکو جَنو مَمَ پَشْچادْ اُپَتِشْٹھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ہے اِبْراہِیمو وَںشَجاتا بھْراتَرو ہے اِیشْوَرَبھِیتاح سَرْوَّلوکا یُشْمانْ پْرَتِ پَرِتْرانَسْیَ کَتھَیشا پْریرِتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","یِرُوشالَمْنِواسِنَسْتیشامْ اَدھِپَتَیَشْچَ تَسْیَ یِیشوح پَرِچَیَں نَ پْراپْیَ پْرَتِوِشْرامَوارَں پَٹھْیَماناناں بھَوِشْیَدْوادِکَتھانامْ اَبھِپْرایَمْ اَبُدّھوا چَ تَسْیَ وَدھینَ تاح کَتھاح سَپھَلا اَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","پْرانَہَنَنَسْیَ کَمَپِ ہیتُمْ اَپْراپْیاپِ پِیلاتَسْیَ نِکَٹے تَسْیَ وَدھَں پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","تَسْمِنْ یاح کَتھا لِکھِتاح سَنْتِ تَدَنُسارینَ کَرْمَّ سَمْپادْیَ تَں کْرُشادْ اَوَتارْیَّ شْمَشانے شایِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","کِنْتْوِیشْوَرَح شْمَشاناتْ تَمُدَسْتھاپَیَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","پُنَشْچَ گالِیلَپْرَدیشادْ یِرُوشالَمَنَگَرَں تینَ سارْدّھَں یے لوکا آگَچّھَنْ سَ بَہُدِنانِ تیبھْیو دَرْشَنَں دَتَّوانْ، اَتَسْتَ اِدانِیں لوکانْ پْرَتِ تَسْیَ ساکْشِنَح سَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","اَسْماکَں پُورْوَّپُرُشاناں سَمَکْشَمْ اِیشْوَرو یَسْمِنْ پْرَتِجْناتَوانْ یَتھا، تْوَں مے پُتْروسِ چادْیَ تْواں سَمُتّھاپِتَوانَہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","اِدَں یَدْوَچَنَں دْوِتِییَگِیتے لِکھِتَماسْتے تَدْ یِیشورُتّھانینَ تیشاں سَنْتانا یے وَیَمْ اَسْماکَں سَنِّدھَو تینَ پْرَتْیَکْشِی کرِتَں، یُشْمانْ اِمَں سُسَںوادَں جْناپَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","پَرَمیشْوَرینَ شْمَشانادْ اُتّھاپِتَں تَدِییَں شَرِیرَں کَداپِ نَ کْشیشْیَتے، ایتَسْمِنْ سَ سْوَیَں کَتھِتَوانْ یَتھا دایُودَں پْرَتِ پْرَتِجْناتو یو وَرَسْتَمَہَں تُبھْیَں داسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ایتَدَنْیَسْمِنْ گِیتےپِ کَتھِتَوانْ۔ سْوَکِییَں پُنْیَوَنْتَں تْوَں کْشَیِتُں نَ چَ داسْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","دایُودا اِیشْوَرابھِمَتَسیوایَے نِجایُشِ وْیَیِتے سَتِ سَ مَہانِدْراں پْراپْیَ نِجَیح پُورْوَّپُرُشَیح سَہَ مِلِتَح سَنْ اَکْشِییَتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","کِنْتُ یَمِیشْوَرَح شْمَشانادْ اُدَسْتھاپَیَتْ سَ ناکْشِییَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","اَتو ہے بھْراتَرَح، اَنینَ جَنینَ پاپَموچَنَں بھَوَتِیتِ یُشْمانْ پْرَتِ پْرَچارِتَمْ آسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","پھَلَتو مُوساوْیَوَسْتھَیا یُویَں ییبھْیو دوشیبھْیو مُکْتا بھَوِتُں نَ شَکْشْیَتھَ تیبھْیَح سَرْوَّدوشیبھْیَ ایتَسْمِنْ جَنے وِشْواسِنَح سَرْوّے مُکْتا بھَوِشْیَنْتِیتِ یُشْمابھِ رْجْنایَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","اَپَرَنْچَ۔ اَوَجْناکارِنو لوکاشْچَکْشُرُنْمِیلْیَ پَشْیَتَ۔ تَتھَیواسَمْبھَوَں جْناتْوا سْیاتَ یُویَں وِلَجِّتاح۔ یَتو یُشْماسُ تِشْٹھَتْسُ کَرِشْیے کَرْمَّ تادرِشَں۔ یینَیوَ تَسْیَ ورِتّانْتے یُشْمَبھْیَں کَتھِتےپِ ہِ۔ یُویَں نَ تَنْتُ ورِتّانْتَں پْرَتْییشْیَتھَ کَداچَنَ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","یییَں کَتھا بھَوِشْیَدْوادِناں گْرَنْتھیشُ لِکھِتاسْتے ساوَدھانا بھَوَتَ سَ کَتھا یَتھا یُشْمانْ پْرَتِ نَ گھَٹَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","یِہُودِییَبھَجَنَبھَوَنانْ نِرْگَتَیوسْتَیو رْبھِنَّدیشِییَے رْوَکْشْیَمانا پْرارْتھَنا کرِتا، آگامِنِ وِشْرامَوارےپِ کَتھییَمْ اَسْمانْ پْرَتِ پْرَچارِتا بھَوَتْوِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","سَبھایا بھَنْگے سَتِ بَہَوو یِہُودِییَلوکا یِہُودِییَمَتَگْراہِنو بھَکْتَلوکاشْچَ بَرْنَبّاپَولَیوح پَشْچادْ آگَچّھَنْ، تینَ تَو تَیح سَہَ ناناکَتھاح کَتھَیِتْویشْوَرانُگْرَہاشْرَیے سْتھاتُں تانْ پْراوَرْتَّیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","پَرَوِشْرامَوارے نَگَرَسْیَ پْرایینَ سَرْوّے لاکا اِیشْوَرِییاں کَتھاں شْروتُں مِلِتاح، ");
INSERT INTO sanurd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","کِنْتُ یِہُودِییَلوکا جَنَنِوَہَں وِلوکْیَ اِیرْشْیَیا پَرِپُورْناح سَنْتو وِپَرِیتَکَتھاکَتھَنینیشْوَرَنِنْدَیا چَ پَولینوکْتاں کَتھاں کھَنْڈَیِتُں چیشْٹِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","تَتَح پَوैلَبَرْنَبّاوَکْشوبھَو کَتھِتَوَنْتَو پْرَتھَمَں یُشْماکَں سَنِّدھاوِیشْوَرِییَکَتھایاح پْرَچارَنَمْ اُچِتَماسِیتْ کِنْتُں تَدَگْراہْیَتْوَکَرَنینَ یُویَں سْوانْ اَنَنْتایُشویوگْیانْ دَرْشَیَتھَ، ایتَتْکارَنادْ وَیَمْ اَنْیَدیشِییَلوکاناں سَمِیپَں گَچّھامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","پْرَبھُرَسْمانْ اِتّھَمْ آدِشْٹَوانْ یَتھا، یاوَچَّ جَگَتَح سِیماں لوکاناں تْرانَکارَناتْ۔ مَیانْیَدیشَمَدھْیے تْوَں سْتھاپِتو بھُوح پْرَدِیپَوَتْ۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","تَدا کَتھامِیدرِشِیں شْرُتْوا بھِنَّدیشِییا آہْلادِتاح سَنْتَح پْرَبھوح کَتھاں دھَنْیاں دھَنْیامْ اَوَدَنْ، یاوَنْتو لوکاشْچَ پَرَمایُح پْراپْتِنِمِتَّں نِرُوپِتا آسَنْ تےे وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","اِتّھَں پْرَبھوح کَتھا سَرْوّیدیشَں وْیاپْنوتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","کِنْتُ یِہُودِییا نَگَرَسْیَ پْرَدھانَپُرُشانْ سَمّانْیاح کَتھِپَیا بھَکْتا یوشِتَشْچَ کُپْرَورِتِّں گْراہَیِتْوا پَولَبَرْنَبَّو تاڈَیِتْوا تَسْماتْ پْرَدیشادْ دُورِیکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","اَتَح کارَناتْ تَو نِجَپَدَدھُولِیسْتیشاں پْراتِکُولْیینَ پاتَیِتْوےेکَنِیَں نَگَرَں گَتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","تَتَح شِشْیَگَنَ آنَنْدینَ پَوِتْریناتْمَنا چَ پَرِپُورْنوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","تَو دْوَو جَنَو یُگَپَدْ اِکَنِیَنَگَرَسْتھَیِہُودِییاناں بھَجَنَبھَوَنَں گَتْوا یَتھا بَہَوو یِہُودِییا اَنْیَدےेشِییَلوکاشْچَ وْیَشْوَسَنْ تادرِشِیں کَتھاں کَتھِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","کِنْتُ وِشْواسَہِینا یِہُودِییا اَنْیَدیشِییَلوکانْ کُپْرَورِتِّں گْراہَیِتْوا بھْراترِگَنَں پْرَتِ تیشاں وَیرَں جَنِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","اَتَح سْوانُگْرَہَکَتھایاح پْرَمانَں دَتْوا تَیو رْہَسْتَے رْبَہُلَکْشَنَمْ اَدْبھُتَکَرْمَّ چَ پْراکاشَیَدْ یَح پْرَبھُسْتَسْیَ کَتھا اَکْشوبھینَ پْرَچارْیَّ تَو تَتْرَ بَہُدِنانِ سَمَواتِشْٹھیتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","کِنْتُ کِیَنْتو لوکا یِہُودِییاناں سَپَکْشاح کِیَنْتو لوکاح پْریرِتاناں سَپَکْشا جاتاح، اَتو ناگَرِکَجَنَنِوَہَمَدھْیے بھِنَّواکْیَتْوَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","اَنْیَدیشِییا یِہُودِییاسْتیشامْ اَدھِپَتَیَشْچَ دَوراتْمْیَں کُتْوا تَو پْرَسْتَرَیراہَنْتُمْ اُدْیَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","تَو تَدْوارْتّاں پْراپْیَ پَلایِتْوا لُکایَنِیادیشَسْیانْتَرْوَّرْتِّلُسْتْرادَرْبّو ");
INSERT INTO sanurd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","تَتْسَمِیپَسْتھَدیشَنْچَ گَتْوا تَتْرَ سُسَںوادَں پْرَچارَیَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","تَتْروبھَیَپادَیوشْچَلَنَشَکْتِہِینو جَنْمارَبھْیَ کھَنْجَح کَداپِ گَمَنَں ناکَروتْ ایتادرِشَ ایکو مانُشو لُسْتْرانَگَرَ اُپَوِشْیَ پَولَسْیَ کَتھاں شْرُتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ایتَسْمِنْ سَمَیے پَولَسْتَمْپْرَتِ درِشْٹِں کرِتْوا تَسْیَ سْواسْتھْیے وِشْواسَں وِدِتْوا پْروچَّیح کَتھِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","پَدْبھْیامُتِّشْٹھَنْ رِجُ رْبھَوَ۔ تَتَح سَ اُلَّمْپھَں کرِتْوا گَمَناگَمَنے کُتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","تَدا لوکاح پَولَسْیَ تَتْ کارْیَّں وِلوکْیَ لُکایَنِییَبھاشَیا پْروچَّیح کَتھامیتاں کَتھِتَوَنْتَح، دیوا مَنُشْیَرُوپَں دھرِتْواسْماکَں سَمِیپَمْ اَواروہَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","تے بَرْنَبّاں یُوپِتَرَمْ اَوَدَنْ پَولَشْچَ مُکھْیو وَکْتا تَسْماتْ تَں مَرْکُرِیَمْ اَوَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","تَسْیَ نَگَرَسْیَ سَمُّکھے سْتھاپِتَسْیَ یُوپِتَرَوِگْرَہَسْیَ یاجَکو ورِشانْ پُشْپَمالاشْچَ دْوارَسَمِیپَمْ آنِییَ لوکَیح سَرْدّھَں تاوُدِّشْیَ سَمُتْسرِجْیَ داتُمْ اُدْیَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","تَدْوارْتّاں شْرُتْوا بَرْنَبّاپَولَو سْوِییَوَسْتْرانِ چھِتْوا لوکاناں مَدھْیَں ویگینَ پْرَوِشْیَ پْروچَّیح کَتھِتَوَنْتَو، ");
INSERT INTO sanurd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ہے مَہیچّھاح کُتَ ایتادرِشَں کَرْمَّ کُرُتھَ؟ آوامَپِ یُشْمادرِشَو سُکھَدُحکھَبھوگِنَو مَنُشْیَو، یُیَمْ ایتاح سَرْوّا ورِتھاکَلْپَناح پَرِتْیَجْیَ یَتھا گَگَنَوَسُنْدھَراجَلَنِدھِیناں تَنْمَدھْیَسْتھاناں سَرْوّیشانْچَ سْرَشْٹارَمَمَرَمْ اِیشْوَرَں پْرَتِ پَراوَرْتَّدھْوے تَدَرْتھَمْ آواں یُشْماکَں سَنِّدھَو سُسَںوادَں پْرَچارَیاوَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","سَ اِیشْوَرَح پُورْوَّکالے سَرْوَّدیشِییَلوکانْ سْوَسْوَمارْگے چَلِتُمَنُمَتِں دَتَّوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","تَتھاپِ آکاشاتْ تویَوَرْشَنینَ ناناپْرَکارَشَسْیوتْپَتْیا چَ یُشْماکَں ہِتَیشِی سَنْ بھَکْشْیَیرانَنَدینَ چَ یُشْماکَمْ اَنْتَحکَرَنانِ تَرْپَیَنْ تانِ دانانِ نِجَساکْشِسْوَرُوپانِ سْتھَپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","کِنْتُ تادرِشایاں کَتھایاں کَتھِتایامَپِ تَیوح سَمِیپَ اُتْسَرْجَناتْ لوکَنِوَہَں پْرایینَ نِوَرْتَّیِتُں ناشَکْنُتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","آنْتِیَکھِیا-اِکَنِیَنَگَرابھْیاں کَتِپَیَیِہُودِییَلوکا آگَتْیَ لوکانْ پْراوَرْتَّیَنْتَ تَسْماتْ تَے پَولَں پْرَسْتَرَیراگھْنَنْ تینَ سَ مرِتَ اِتِ وِجْنایَ نَگَرَسْیَ بَہِسْتَمْ آکرِشْیَ نِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","کِنْتُ شِشْیَگَنے تَسْیَ چَتُرْدِشِ تِشْٹھَتِ سَتِ سَ سْوَیَمْ اُتّھایَ پُنَرَپِ نَگَرَمَدھْیَں پْراوِشَتْ تَتْپَرےہَنِ بَرْنَبّاسَہِتو دَرْبِّینَگَرَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","تَتْرَ سُسَںوادَں پْرَچارْیَّ بَہُلوکانْ شِشْیانْ کرِتْوا تَو لُسْتْرامْ اِکَنِیَمْ آنْتِیَکھِیانْچَ پَراورِتْیَ گَتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","بَہُدُحکھانِ بھُکْتْواپِیشْوَرَراجْیَں پْرَویشْٹَوْیَمْ اِتِ کارَنادْ دھَرْمَّمارْگے سْتھاتُں وِنَیَں کرِتْوا شِشْیَگَنَسْیَ مَنَحسْتھَیرْیَّمْ اَکُرُتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","مَنْڈَلِیناں پْراچِینَوَرْگانْ نِیُجْیَ پْرارْتھَنوپَواسَو کرِتْوا یَتْپْرَبھَو تے وْیَشْوَسَنْ تَسْیَ ہَسْتے تانْ سَمَرْپْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","پِسِدِیامَدھْیینَ پامْپھُلِیادیشَں گَتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","پَشْچاتْ پَرْگانَگَرَں گَتْوا سُسَںوادَں پْرَچارْیَّ اَتّالِیانَگَرَں پْرَسْتھِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","تَسْماتْ سَمُدْرَپَتھینَ گَتْوا تابھْیاں یَتْ کَرْمَّ سَمْپَنَّں تَتْکَرْمَّ سادھَیِتُں یَنَّگَرے دَیالورِیشْوَرَسْیَ ہَسْتے سَمَرْپِتَو جاتَو تَدْ آنْتِیَکھِیانَگَرَں گَتَوَنْتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","تَتْروپَسْتھایَ تَنَّگَرَسْتھَمَنْڈَلِیں سَںگرِہْیَ سْوابھْیامَ اِیشْوَرو یَدْیَتْ کَرْمَّکَروتْ تَتھا یینَ پْرَکارینَ بھِنَّدیشِییَلوکانْ پْرَتِ وِشْواسَرُوپَدْوارَمْ اَموچَیَدْ ایتانْ سَرْوَّورِتّانْتانْ تانْ جْناپِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","تَتَسْتَو شِرْیَّیح سارْدّھَں تَتْرَ بَہُدِنانِ نْیَوَسَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","یِہُودادیشاتْ کِیَنْتو جَنا آگَتْیَ بھْراترِگَنَمِتّھَں شِکْشِتَوَنْتو مُوساوْیَوَسْتھَیا یَدِ یُشْماکَں تْوَکْچھیدو نَ بھَوَتِ تَرْہِ یُویَں پَرِتْرانَں پْراپْتُں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","پَولَبَرْنَبَّو تَیح سَہَ بَہُونْ وِچارانْ وِواداںشْچَ کرِتَوَنْتَو، تَتو مَنْڈَلِییَنوکا ایتَسْیاح کَتھایاسْتَتّوَں جْناتُں یِرُوشالَمْنَگَرَسْتھانْ پْریرِتانْ پْراچِیناںشْچَ پْرَتِ پَولَبَرْنَبّاپْرَبھرِتِینْ کَتِپَیَجَنانْ پْریشَیِتُں نِشْچَیَں کرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","تے مَنْڈَلْیا پْریرِتاح سَنْتَح پھَینِیکِیشومِرونْدیشابھْیاں گَتْوا بھِنَّدیشِییاناں مَنَحپَرِوَرْتَّنَسْیَ وارْتَّیا بھْراترِناں پَرَماہْلادَمْ اَجَنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","یِرُوشالَمْیُپَسْتھایَ پْریرِتَگَنینَ لوکَپْراچِینَگَنینَ سَماجینَ چَ سَمُپَگرِہِیتاح سَنْتَح سْوَیرِیشْوَرو یانِ کَرْمّانِ کرِتَوانْ تیشاں سَرْوَّورِتّانْتانْ تیشاں سَمَکْشَمْ اَکَتھَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","کِنْتُ وِشْواسِنَح کِیَنْتَح پھِرُوشِمَتَگْراہِنو لوکا اُتّھایَ کَتھامیتاں کَتھِتَوَنْتو بھِنَّدیشِییاناں تْوَکْچھیدَں کَرْتُّں مُوساوْیَوَسْتھاں پالَیِتُنْچَ سَمادیشْٹَوْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","تَتَح پْریرِتا لوکَپْراچِیناشْچَ تَسْیَ وِویچَناں کَرْتُّں سَبھایاں سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","بَہُوِچاریشُ جاتَشُ پِتَرَ اُتّھایَ کَتھِتَوانْ، ہے بھْراتَرو یَتھا بھِنَّدیشِییَلوکا مَمَ مُکھاتْ سُسَںوادَں شْرُتْوا وِشْوَسَنْتِ تَدَرْتھَں بَہُدِناتْ پُورْوَّمْ اِیشْوَروسْماکَں مَدھْیے ماں ورِتْوا نِیُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","اَنْتَرْیّامِیشْوَرو یَتھاسْمَبھْیَں تَتھا بھِنَّدیشِیییبھْیَح پَوِتْرَماتْمانَں پْرَدایَ وِشْواسینَ تیشامْ اَنْتَحکَرَنانِ پَوِتْرانِ کرِتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","تیشامْ اَسْماکَنْچَ مَدھْیے کِمَپِ وِشیشَں نَ سْتھاپَیِتْوا تانَدھِ سْوَیَں پْرَمانَں دَتَّوانْ اِتِ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","اَتَایواسْماکَں پُورْوَّپُرُشا وَیَنْچَ سْوَیَں یَدْیُگَسْیَ بھارَں سوڈھُں نَ شَکْتاح سَمْپْرَتِ تَں شِشْیَگَنَسْیَ سْکَنْدھیشُ نْیَسِتُں کُتَ اِیشْوَرَسْیَ پَرِیکْشاں کَرِشْیَتھَ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","پْرَبھو رْیِیشُکھْرِیشْٹَسْیانُگْرَہینَ تے یَتھا وَیَمَپِ تَتھا پَرِتْرانَں پْراپْتُمْ آشاں کُرْمَّح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","اَنَنْتَرَں بَرْنَبّاپَولابھْیامْ اِیشْوَرو بھِنَّدیشِییاناں مَدھْیے یَدْیَدْ آشْچَرْیَّمْ اَدْبھُتَنْچَ کَرْمَّ کرِتَوانْ تَدْورِتّانْتَں تَو سْوَمُکھابھْیامْ اَوَرْنَیَتاں سَبھاسْتھاح سَرْوّے نِیرَواح سَنْتَح شْرُتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","تَیوح کَتھایاں سَماپْتایاں سَتْیاں یاکُوبْ کَتھَیِتُمْ آرَبْدھَوانْ ");
INSERT INTO sanurd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ہے بھْراتَرو مَمَ کَتھایامْ مَنو نِدھَتَّ۔ اِیشْوَرَح سْوَنامارْتھَں بھِنَّدیشِییَلوکانامْ مَدھْیادْ ایکَں لوکَسَںگھَں گْرَہِیتُں مَتِں کرِتْوا یینَ پْرَکارینَ پْرَتھَمَں تانْ پْرَتِ کرِپاوَلیکَنَں کرِتَوانْ تَں شِمونْ وَرْنِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","بھَوِشْیَدْوادِبھِرُکْتانِ یانِ واکْیانِ تَیح سارْدّھَمْ ایتَسْیَیکْیَں بھَوَتِ یَتھا لِکھِتَماسْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","سَرْوّیشاں کَرْمَّناں یَسْتُ سادھَکَح پَرَمیشْوَرَح۔ سَ ایویدَں وَدیدْواکْیَں شیشاح سَکَلَمانَواح۔ بھِنَّدیشِییَلوکاشْچَ یاوَنْتو مَمَ نامَتَح۔ بھَوَنْتِ ہِ سُوِکھْیاتاسْتے یَتھا پَرَمیشِتُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","تَتْوَں سَمْیَکْ سَمِیہَنْتے تَنِّمِتَّمَہَں کِلَ۔ پَراورِتْیَ سَماگَتْیَ دایُودَح پَتِتَں پُنَح۔ دُوشْیَمُتّھاپَیِشْیامِ تَدِییَں سَرْوَّوَسْتُ چَ۔ پَتِتَں پُنَرُتھاپْیَ سَجَّیِشْیامِ سَرْوَّتھا۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","آ پْرَتھَمادْ اِیشْوَرَح سْوِییانِ سَرْوَّکَرْمّانِ جاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","اَتَایوَ مَمَ نِویدَنَمِدَں بھِنَّدیشِییَلوکاناں مَدھْیے یے جَنا اِیشْوَرَں پْرَتِ پَراوَرْتَّنْتَ تیشامُپَرِ اَنْیَں کَمَپِ بھارَں نَ نْیَسْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","دیوَتاپْرَساداشُچِبھَکْشْیَں وْیَبھِچارَکَرْمَّ کَنْٹھَسَمْپِیڈَنَمارِتَپْرانِبھَکْشْیَں رَکْتَبھَکْشْیَنْچَ ایتانِ پَرِتْیَکْتُں لِکھامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","یَتَح پُورْوَّکالَتو مُوساوْیَوَسْتھاپْرَچارِنو لوکا نَگَرے نَگَرے سَنْتِ پْرَتِوِشْرامَوارَنْچَ بھَجَنَبھَوَنے تَسْیاح پاٹھو بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","تَتَح پَرَں پْریرِتَگَنو لوکَپْراچِینَگَنَح سَرْوّا مَنْڈَلِی چَ سْویشاں مَدھْیے بَرْشَبّا نامْنا وِکھْیاتو مَنونِیتَو کرِتْوا پَولَبَرْنَبّابھْیاں سارْدّھَمْ آنْتِیَکھِیانَگَرَں پْرَتِ پْریشَنَمْ اُچِتَں بُدّھوا تابھْیاں پَتْرَں پْرَیشَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","تَسْمِنْ پَتْرے لِکھِتَمِںدَ، آنْتِیَکھِیا-سُرِیا-کِلِکِیادیشَسْتھَبھِنَّدیشِییَبھْراترِگَنایَ پْریرِتَگَنَسْیَ لوکَپْراچِینَگَنَسْیَ بھْراترِگَنَسْیَ چَ نَمَسْکارَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","وِشیشَتوسْماکَمْ آجْنامْ اَپْراپْیاپِ کِیَنْتو جَنا اَسْماکَں مَدھْیادْ گَتْوا تْوَکْچھیدو مُوساوْیَوَسْتھا چَ پالَیِتَوْیاوِتِ یُشْمانْ شِکْشَیِتْوا یُشْماکَں مَنَسامَسْتھَیرْیَّں کرِتْوا یُشْمانْ سَسَنْدیہانْ اَکُرْوَّنْ ایتاں کَتھاں وَیَمْ اَشرِنْمَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","تَتْکارَنادْ وَیَمْ ایکَمَنْتْرَناح سَنْتَح سَبھایاں سْتھِتْوا پْرَبھو رْیِیشُکھْرِیشْٹَسْیَ نامَنِمِتَّں مرِتْیُمُکھَگَتابھْیامَسْماکَں ");
INSERT INTO sanurd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","پْرِیَبَرْنَبّاپَولابھْیاں سارْدّھَں مَنونِیتَلوکاناں کیشانْچِدْ یُشْماکَں سَنِّدھَو پْریشَنَمْ اُچِتَں بُدّھَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","اَتو یِہُوداسِیلَو یُشْمانْ پْرَتِ پْریشِتَوَنْتَح، ایتَیو رْمُکھابھْیاں سَرْوّاں کَتھاں جْناسْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","دیوَتاپْرَسادَبھَکْشْیَں رَکْتَبھَکْشْیَں گَلَپِیڈَنَمارِتَپْرانِبھَکْشْیَں وْیَبھِچارَکَرْمَّ چیمانِ سَرْوّانِ یُشْمابھِسْتْیاجْیانِ؛ ایتَتْپْرَیوجَنِییاجْناوْیَتِریکینَ یُشْماکَمْ اُپَرِ بھارَمَنْیَں نَ نْیَسِتُں پَوِتْرَسْیاتْمَنوسْماکَنْچَ اُچِتَجْنانَمْ اَبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","اَتَایوَ تیبھْیَح سَرْوّیبھْیَح سْویشُ رَکْشِتیشُ یُویَں بھَدْرَں کَرْمَّ کَرِشْیَتھَ۔ یُشْماکَں مَنْگَلَں بھُویاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","تےे وِسرِشْٹاح سَنْتَ آنْتِیَکھِیانَگَرَ اُپَسْتھایَ لوکَنِوَہَں سَںگرِہْیَ پَتْرَمْ اَدَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","تَتَسْتے تَتْپَتْرَں پَٹھِتْوا سانْتْوَناں پْراپْیَ سانَنْدا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","یِہُوداسِیلَو چَ سْوَیَں پْرَچارَکَو بھُوتْوا بھْراترِگَنَں نانوپَدِشْیَ تانْ سُسْتھِرانْ اَکُرُتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","اِتّھَں تَو تَتْرَ تَیح ساکَں کَتِپَیَدِنانِ یاپَیِتْوا پَشْچاتْ پْریرِتاناں سَمِیپے پْرَتْیاگَمَنارْتھَں تیشاں سَنِّدھیح کَلْیانینَ وِسرِشْٹاوَبھَوَتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","کِنْتُ سِیلَسْتَتْرَ سْتھاتُں وانْچھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","اَپَرَں پَولَبَرْنَبَّو بَہَوَح شِشْیاشْچَ لوکانْ اُپَدِشْیَ پْرَبھوح سُسَںوادَں پْرَچارَیَنْتَ آنْتِیَکھِیایاں کالَں یاپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","کَتِپَیَدِنیشُ گَتیشُ پَولو بَرْنَبّامْ اَوَدَتْ آگَچّھاواں ییشُ نَگَریشْوِیشْوَرَسْیَ سُسَںوادَں پْرَچارِتَوَنْتَو تانِ سَرْوَّنَگَرانِ پُنَرْگَتْوا بھْراتَرَح کِیدرِشاح سَنْتِیتِ دْرَشْٹُں تانْ ساکْشاتْ کُرْوَّح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","تینَ مارْکَنامْنا وِکھْیاتَں یوہَنَں سَنْگِنَں کَرْتُّں بَرْنَبّا مَتِمَکَروتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","کِنْتُ سَ پُورْوَّں تابھْیاں سَہَ کارْیّارْتھَں نَ گَتْوا پامْپھُولِیادیشے تَو تْیَکْتَوانْ تَتْکارَناتْ پَولَسْتَں سَنْگِنَں کَرْتُّمْ اَنُچِتَں جْناتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","اِتّھَں تَیورَتِشَیَوِرودھَسْیوپَسْتھِتَتْواتْ تَو پَرَسْپَرَں پرِتھَگَبھَوَتاں تَتو بَرْنَبّا مارْکَں گرِہِیتْوا پوتینَ کُپْروپَدْوِیپَں گَتَوانْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","کِنْتُ پَولَح سِیلَں مَنونِیتَں کرِتْوا بھْراترِبھِرِیشْوَرانُگْرَہے سَمَرْپِتَح سَنْ پْرَسْتھایَ ");
INSERT INTO sanurd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","سُرِیاکِلِکِیادیشابھْیاں مَنْڈَلِیح سْتھِرِیکُرْوَّنْ اَگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","پَولو دَرْبِّیلُسْتْرانَگَرَیورُپَسْتھِتوبھَوَتْ تَتْرَ تِیمَتھِیَناما شِشْیَ ایکَ آسِیتْ؛ سَ وِشْواسِنْیا یِہُودِییایا یوشِتو گَرْبّھَجاتَح کِنْتُ تَسْیَ پِتانْیَدیشِییَلوکَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","سَ جَنو لُسْتْرا-اِکَنِیَنَگَرَسْتھاناں بھْراترِناں سَمِیپیپِ سُکھْیاتِمانْ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","پَولَسْتَں سْوَسَنْگِنَں کَرْتُّں مَتِں کرِتْوا تَں گرِہِیتْوا تَدّیشَنِواسِناں یِہُودِییانامْ اَنُرودھاتْ تَسْیَ تْوَکْچھیدَں کرِتَوانْ یَتَسْتَسْیَ پِتا بھِنَّدیشِییَلوکَ اِتِ سَرْوَّیرَجْنایَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","تَتَح پَرَں تے نَگَرے نَگَرے بھْرَمِتْوا یِرُوشالَمَسْتھَیح پْریرِتَے رْلوکَپْراچِینَیشْچَ نِرُوپِتَں یَدْ وْیَوَسْتھاپَتْرَں تَدَنُساریناچَرِتُں لوکیبھْیَسْتَدْ دَتَّوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","تینَیوَ سَرْوّے دھَرْمَّسَماجاح کھْرِیشْٹَدھَرْمّے سُسْتھِراح سَنْتَح پْرَتِدِنَں وَرْدّھِتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","تیشُ پھْرُگِیاگالاتِیادیشَمَدھْیینَ گَتیشُ سَتْسُ پَوِتْرَ آتْما تانْ آشِیادیشے کَتھاں پْرَکاشَیِتُں پْرَتِشِدّھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","تَتھا مُسِیادیشَ اُپَسْتھایَ بِتھُنِیاں گَنْتُں تَیرُدْیوگے کرِتے آتْما تانْ نانْوَمَنْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","تَسْماتْ تے مُسِیادیشَں پَرِتْیَجْیَ تْرویانَگَرَں گَتْوا سَمُپَسْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","راتْرَو پَولَح سْوَپْنے درِشْٹَوانْ ایکو ماکِدَنِیَلوکَسْتِشْٹھَنْ وِنَیَں کرِتْوا تَسْمَے کَتھَیَتِ، ماکِدَنِیادیشَمْ آگَتْیاسْمانْ اُپَکُرْوِّتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","تَسْییتّھَں سْوَپْنَدَرْشَناتْ پْرَبھُسْتَدّیشِییَلوکانْ پْرَتِ سُسَںوادَں پْرَچارَیِتُمْ اَسْمانْ آہُویَتِیتِ نِشْچِتَں بُدّھوا وَیَں تُورْنَں ماکِدَنِیادیشَں گَنْتُمْ اُدْیوگَمْ اَکُرْمَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","تَتَح پَرَں وَیَں تْرویانَگَرادْ پْرَسْتھایَ رِجُمارْگینَ سامَتھْراکِیوپَدْوِیپینَ گَتْوا پَرےہَنِ نِیاپَلِنَگَرَ اُپَسْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","تَسْمادْ گَتْوا ماکِدَنِیانْتَرْوَّرْتِّ رومِییَوَسَتِسْتھانَں یَتْ پھِلِپِینامَپْرَدھانَنَگَرَں تَتْروپَسْتھایَ کَتِپَیَدِنانِ تَتْرَ سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","وِشْرامَوارے نَگَرادْ بَہِ رْگَتْوا نَدِیتَٹے یَتْرَ پْرارْتھَناچارَ آسِیتْ تَتْروپَوِشْیَ سَماگَتا نارِیح پْرَتِ کَتھاں پْراچارَیامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","تَتَح تھُیاتِیرانَگَرِییا دھُوشَرامْبَرَوِکْرایِنِی لُدِیانامِکا یا اِیشْوَرَسیوِکا یوشِتْ شْروتْرِیناں مَدھْیَ آسِیتْ تَیا پَولوکْتَواکْیانِ یَدْ گرِہْیَنْتے تَدَرْتھَں پْرَبھُسْتَسْیا مَنودْوارَں مُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","اَتَح سا یوشِتْ سَپَرِوارا مَجِّتا سَتِی وِنَیَں کرِتْوا کَتھِتَوَتِی، یُشْماکَں وِچارادْ یَدِ پْرَبھَو وِشْواسِنِی جاتاہَں تَرْہِ مَمَ گرِہَمْ آگَتْیَ تِشْٹھَتَ۔ اِتّھَں سا یَتْنیناسْمانْ اَسْتھاپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","یَسْیا گَنَنَیا تَدَدھِپَتِیناں بَہُدھَنوپارْجَنَں جاتَں تادرِشِی گَنَکَبھُوتَگْرَسْتا کاچَنَ داسِی پْرارْتھَناسْتھانَگَمَنَکالَ آگَتْیاسْمانْ ساکْشاتْ کرِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ساسْماکَں پَولَسْیَ چَ پَشْچادْ ایتْیَ پْروچَّیح کَتھامِماں کَتھِتَوَتِی، مَنُشْیا ایتے سَرْوّوپَرِسْتھَسْییشْوَرَسْیَ سیوَکاح سَنْتوسْمانْ پْرَتِ پَرِتْرانَسْیَ مارْگَں پْرَکاشَیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","سا کَنْیا بَہُدِنانِ تادرِشَمْ اَکَروتْ تَسْماتْ پَولو دُحکھِتَح سَنْ مُکھَں پَراوَرْتْیَ تَں بھُوتَمَوَدَدْ، اَہَں یِیشُکھْرِیشْٹَسْیَ نامْنا تْواماجْناپَیامِ تْوَمَسْیا بَہِرْگَچّھَ؛ تینَیوَ تَتْکْشَناتْ سَ بھُوتَسْتَسْیا بَہِرْگَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","تَتَح سْویشاں لابھَسْیَ پْرَتْیاشا وِپھَلا جاتیتِ وِلوکْیَ تَسْیاح پْرَبھَوَح پَولَں سِیلَنْچَ دھرِتْواکرِشْیَ وِچارَسْتھانےدھِپَتِیناں سَمِیپَمْ آنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","تَتَح شاسَکاناں نِکَٹَں نِیتْوا رومِلوکا وَیَمْ اَسْماکَں یَدْ وْیَوَہَرَنَں گْرَہِیتُمْ آچَرِتُنْچَ نِشِدّھَں، ");
INSERT INTO sanurd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","اِمے یِہُودِییَلوکاح سَنْتوپِ تَدیوَ شِکْشَیِتْوا نَگَرےسْماکَمْ اَتِیوَ کَلَہَں کُرْوَّنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","اِتِ کَتھِتے سَتِ لوکَنِوَہَسْتَیوح پْراتِکُولْیینودَتِشْٹھَتْ تَتھا شاسَکاسْتَیو رْوَسْتْرانِ چھِتْوا ویتْراگھاتَں کَرْتُّمْ آجْناپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","اَپَرَں تے تَو بَہُ پْرَہارْیَّ تْوَمیتَو کاراں نِیتْوا ساوَدھانَں رَکْشَییتِ کارارَکْشَکَمْ آدِشَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","اِتّھَمْ آجْناں پْراپْیَ سَ تاوَبھْیَنْتَرَسْتھَکاراں نِیتْوا پادیشُ پادَپاشِیبھِ رْبَدّھوا سْتھاپِتاوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","اَتھَ نِشِیتھَسَمَیے پَولَسِیلاوِیشْوَرَمُدِّشْیَ پْراتھَناں گانَنْچَ کرِتَوَنْتَو، کاراسْتھِتا لوکاشْچَ تَدَشرِنْوَنْ ");
INSERT INTO sanurd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","تَداکَسْماتْ مَہانْ بھُومِکَمْپوبھَوَتْ تینَ بھِتِّمُولینَ سَہَ کارا کَمْپِتابھُوتْ تَتْکْشَناتْ سَرْوّانِ دْوارانِ مُکْتانِ جاتانِ سَرْوّیشاں بَنْدھَنانِ چَ مُکْتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","اَتَایوَ کارارَکْشَکو نِدْراتو جاگَرِتْوا کارایا دْوارانِ مُکْتانِ درِشْٹْوا بَنْدِلوکاح پَلایِتا اِتْیَنُمایَ کوشاتْ کھَنْگَں بَہِح کرِتْواتْمَگھاتَں کَرْتُّمْ اُدْیَتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","کِنْتُ پَولَح پْروچَّیسْتَماہُویَ کَتھِتَوانْ پَشْیَ وَیَں سَرْوّےتْراسْمَہے، تْوَں نِجَپْرانَہِںساں ماکارْشِیح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","تَدا پْرَدِیپَمْ آنیتُمْ اُکْتْوا سَ کَمْپَمانَح سَنْ اُلَّمْپْیابھْیَنْتَرَمْ آگَتْیَ پَولَسِیلَیوح پادیشُ پَتِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","پَشْچاتْ سَ تَو بَہِرانِییَ پرِشْٹَوانْ ہے مَہیچّھَو پَرِتْرانَں پْراپْتُں مَیا کِں کَرْتَّوْیَں؟ ");
INSERT INTO sanurd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","پَشْچاتْ تَو سْوَگرِہَمانِییَ تَیوح سَمُّکھے کھادْیَدْرَوْیانِ سْتھاپِتَوانْ تَتھا سَ سْوَیَں تَدِییاح سَرْوّے پَرِواراشْچیشْوَرے وِشْوَسَنْتَح سانَنْدِتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","تَسْمَے تَسْیَ گرِہَسْتھِتَسَرْوَّلوکیبھْیَشْچَ پْرَبھوح کَتھاں کَتھِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","تَتھا راتْریسْتَسْمِنّیوَ دَنْڈے سَ تَو گرِہِیتْوا تَیوح پْرَہاراناں کْشَتانِ پْرَکْشالِتَوانْ تَتَح سَ سْوَیَں تَسْیَ سَرْوّے پَرِجَناشْچَ مَجِّتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","پَشْچاتْ تَو سْوَگرِہَمانِییَ تَیوح سَمُّکھے کھادْیَدْرَوْیانِ سْتھاپِتَوانْ تَتھا سَ سْوَیَں تَدِییاح سَرْوّے پَرِواراشْچیشْوَرے وِشْوَسَنْتَح سانَنْدِتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","دِنَ اُپَسْتھِتے تَو لوکَو موچَییتِ کَتھاں کَتھَیِتُں شاسَکاح پَداتِگَنَں پْریشِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","تَتَح کارارَکْشَکَح پَولایَ تاں وارْتّاں کَتھِتَوانْ یُواں تْیاجَیِتُں شاسَکا لوکانَ پْریشِتَوَنْتَ اِدانِیں یُواں بَہِ رْبھُوتْوا کُشَلینَ پْرَتِشْٹھیتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","کِنْتُ پَولَسْتانْ اَوَدَتْ رومِلوکَیوراوَیوح کَمَپِ دوشَمْ نَ نِشْچِتْیَ سَرْوّیشاں سَمَکْشَمْ آواں کَشَیا تاڈَیِتْوا کارایاں بَدّھَوَنْتَ اِدانِیں کِماواں گُپْتَں وِسْتْرَکْشْیَنْتِ؟ تَنَّ بھَوِشْیَتِ، سْوَیَماگَتْیاواں بَہِح کرِتْوا نَیَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","تَدا پَداتِبھِح شاسَکیبھْیَ ایتَدْوارْتّایاں کَتھِتایاں تَو رومِلوکاوِتِ کَتھاں شْرُتْوا تے بھِیتاح ");
INSERT INTO sanurd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","سَنْتَسْتَیوح سَنِّدھِماگَتْیَ وِنَیَمْ اَکُرْوَّنْ اَپَرَں بَہِح کرِتْوا نَگَراتْ پْرَسْتھاتُں پْرارْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","تَتَسْتَو کارایا نِرْگَتْیَ لُدِیایا گرِہَں گَتَوَنْتَو تَتْرَ بھْراترِگَنَں ساکْشاتْکرِتْیَ تانْ سانْتْوَیِتْوا تَسْماتْ سْتھاناتْ پْرَسْتھِتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","پَولَسِیلَو آمْپھِپَلْیاپَلّونِیانَگَرابھْیاں گَتْوا یَتْرَ یِہُودِییاناں بھَجَنَبھَوَنَمیکَمْ آسْتے تَتْرَ تھِشَلَنِیکِینَگَرَ اُپَسْتھِتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","تَدا پَولَح سْواچارانُسارینَ تیشاں سَمِیپَں گَتْوا وِشْرامَوارَتْرَیے تَیح سارْدّھَں دھَرْمَّپُسْتَکِییَکَتھایا وِچارَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","پھَلَتَح کھْرِیشْٹینَ دُحکھَبھوگَح کَرْتَّوْیَح شْمَشانَدُتّھانَنْچَ کَرْتَّوْیَں یُشْماکَں سَنِّدھَو یَسْیَ یِیشوح پْرَسْتاوَں کَرومِ سَ اِیشْوَرینابھِشِکْتَح سَ ایتاح کَتھاح پْرَکاشْیَ پْرَمانَں دَتْوا سْتھِرِیکرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","تَسْماتْ تیشاں کَتِپَیَجَنا اَنْیَدیشِییا بَہَوو بھَکْتَلوکا بَہْیَح پْرَدھانَنارْیَّشْچَ وِشْوَسْیَ پَولَسِیلَیوح پَشْچادْگامِنو جاتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","کِنْتُ وِشْواسَہِینا یِہُودِییَلوکا اِیرْشْیَیا پَرِپُورْناح سَنْتو ہَٹَٹْسْیَ کَتِنَیَلَمْپَٹَلوکانْ سَنْگِنَح کرِتْوا جَنَتَیا نَگَرَمَدھْیے مَہاکَلَہَں کرِتْوا یاسونو گرِہَمْ آکْرَمْیَ پْریرِتانْ دھرِتْوا لوکَنِوَہَسْیَ سَمِیپَمْ آنیتُں چیشْٹِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","تیشامُدّیشَمْ اَپْراپْیَ چَ یاسونَں کَتِپَیانْ بھْراترِںشْچَ دھرِتْوا نَگَرادھِپَتِیناں نِکَٹَمانِییَ پْروچَّیح کَتھِتَوَنْتو یے مَنُشْیا جَگَدُدْواٹِتَوَنْتَسْتے تْراپْیُپَسْتھِتاح سَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ایشَ یاسونْ آتِتھْیَں کرِتْوا تانْ گرِہِیتَوانْ۔ یِیشُنامَکَ ایکو راجَسْتِیتِ کَتھَیَنْتَسْتے کَیسَرَسْیاجْناوِرُدّھَں کَرْمَّ کُرْوَّتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","تیشاں کَتھامِماں شْرُتْوا لوکَنِوَہو نَگَرادھِپَتَیَشْچَ سَمُدْوِگْنا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","تَدا یاسونَسْتَدَنْییشانْچَ دھَنَدَنْڈَں گرِہِیتْوا تانْ پَرِتْیَکْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","تَتَح پَرَں بھْراترِگَنو رَجَنْیاں پَولَسِیلَو شِیگھْرَں بِرَیانَگَرَں پْریشِتَوانْ تَو تَتْروپَسْتھایَ یِہُودِییاناں بھَجَنَبھَوَنَں گَتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","تَتْرَسْتھا لوکاح تھِشَلَنِیکِیسْتھَلوکیبھْیو مَہاتْمانَ آسَنْ یَتَ اِتّھَں بھَوَتِ نَ ویتِ جْناتُں دِنے دِنے دھَرْمَّگْرَنْتھَسْیالوچَناں کرِتْوا سْوَیرَں کَتھامْ اَگرِہْلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","تَسْمادْ اَنیکے یِہُودِییا اَنْیَدیشِییاناں مانْیا سْتْرِیَح پُرُشاشْچانیکے وْیَشْوَسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","کِنْتُ بِرَیانَگَرے پَولینیشْوَرِییا کَتھا پْرَچارْیَّتَ اِتِ تھِشَلَنِیکِیسْتھا یِہُودِییا جْناتْوا تَتْسْتھانَمَپْیاگَتْیَ لوکاناں کُپْرَورِتِّمْ اَجَنَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","اَتَایوَ تَسْماتْ سْتھاناتْ سَمُدْرینَ یانْتِیتِ دَرْشَیِتْوا بھْراتَرَح کْشِپْرَں پَولَں پْراہِنْوَنْ کِنْتُ سِیلَتِیمَتھِیَو تَتْرَ سْتھِتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","تَتَح پَرَں پَولَسْیَ مارْگَدَرْشَکاسْتَمْ آتھِینِینَگَرَ اُپَسْتھاپَیَنْ پَشْچادْ یُواں تُورْنَمْ ایتَتْ سْتھانَں آگَمِشْیَتھَح سِیلَتِیمَتھِیَو پْرَتِیمامْ آجْناں پْراپْیَ تے پْرَتْیاگَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","پَولَ آتھِینِینَگَرے تاوَپیکْشْیَ تِشْٹھَنْ تَنَّگَرَں پْرَتِمابھِح پَرِپُورْنَں درِشْٹْوا سَنْتَپْتَہرِدَیو بھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","تَتَح سَ بھَجَنَبھَوَنے یانْ یِہُودِییانْ بھَکْتَلوکاںشْچَ ہَٹّے چَ یانْ اَپَشْیَتْ تَیح سَہَ پْرَتِدِنَں وِچارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","کِنْتْوِپِکُورِییَمَتَگْرَہِنَح سْتویِکِییَمَتَگْراہِنَشْچَ کِیَنْتو جَناسْتینَ سارْدّھَں وْیَوَدَنْتَ۔ تَتْرَ کیچِدْ اَکَتھَیَنْ ایشَ واچالَح کِں وَکْتُمْ اِچّھَتِ؟ اَپَرے کیچِدْ ایشَ جَنَح کیشانْچِدْ وِدیشِییَدیواناں پْرَچارَکَ اِتْیَنُمِییَتے یَتَح سَ یِیشُمْ اُتّھِتِنْچَ پْرَچارَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","تے تَمْ اَرییَپاگَنامَ وِچارَسْتھانَمْ آنِییَ پْراووچَنْ اِدَں یَنَّوِینَں مَتَں تْوَں پْراچِیکَشَ اِدَں کِیدرِشَں ایتَدْ اَسْمانْ شْراوَیَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","یامِمامْ اَسَمْبھَوَکَتھامْ اَسْماکَں کَرْنَگوچَرِیکرِتَوانْ اَسْیا بھاوارْتھَح کَ اِتِ وَیَں جْناتُمْ اِچّھامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","تَداتھِینِینِواسِنَسْتَنَّگَرَپْرَواسِنَشْچَ کیوَلَں کَسْیاشْچَنَ نَوِینَکَتھایاح شْرَوَنینَ پْرَچارَنینَ چَ کالَمْ اَیاپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","پَولورییَپاگَسْیَ مَدھْیے تِشْٹھَنْ ایتاں کَتھاں پْرَچارِتَوانْ، ہے آتھِینِییَلوکا یُویَں سَرْوَّتھا دیوَپُوجایامْ آسَکْتا اِتْیَہَ پْرَتْیَکْشَں پَشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","یَتَح پَرْیَّٹَنَکالے یُشْماکَں پُوجَنِییانِ پَشْیَنْ ‘اَوِجْناتیشْوَرایَ’ ایتَلِّپِیُکْتاں یَجْنَویدِیمیکاں درِشْٹَوانْ؛ اَتو نَ وِدِتْوا یَں پُوجَیَدھْوے تَسْیَیوَ تَتْوَں یُشْمانْ پْرَتِ پْرَچارَیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","جَگَتو جَگَتْسْتھاناں سَرْوَّوَسْتُونانْچَ سْرَشْٹا یَ اِیشْوَرَح سَ سْوَرْگَپرِتھِوْیوریکادھِپَتِح سَنْ کَرَنِرْمِّتَمَنْدِریشُ نَ نِوَسَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","سَ ایوَ سَرْوّیبھْیو جِیوَنَں پْرانانْ سَرْوَّسامَگْرِیشْچَ پْرَدَداتِ؛ اَتَایوَ سَ کَسْیاشْچِتْ سامَگْیْرا اَبھاوَہیتو رْمَنُشْیاناں ہَسْتَیح سیوِتو بھَوَتِیتِ نَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","سَ بھُومَنْڈَلے نِواسارْتھَمْ ایکَسْماتْ شونِتاتْ سَرْوّانْ مَنُشْیانْ سرِشْٹْوا تیشاں پُورْوَّنِرُوپِتَسَمَیَں وَسَتِسِیمانْچَ نِرَچِنوتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","تَسْماتْ لوکَیح کیناپِ پْرَکارینَ مرِگَیِتْوا پَرَمیشْوَرَسْیَ تَتْوَں پْراپْتُں تَسْیَ گَویشَنَں کَرَنِییَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","کِنْتُ سوسْماکَں کَسْماچِّدَپِ دُورے تِشْٹھَتِیتِ نَہِ، وَیَں تینَ نِشْوَسَنَپْرَشْوَسَنَگَمَناگَمَنَپْرانَدھارَنانِ کُرْمَّح، پُुنَشْچَ یُشْماکَمیوَ کَتِپَیاح کَوَیَح کَتھَیَنْتِ ‘تَسْیَ وَںشا وَیَں سْمو ہِ’ اِتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","اَتَایوَ یَدِ وَیَمْ اِیشْوَرَسْیَ وَںشا بھَوامَسْتَرْہِ مَنُشْیَے رْوِدْیَیا کَوشَلینَ چَ تَکْشِتَں سْوَرْنَں رُوپْیَں درِشَدْ وَیتیشامِیشْوَرَتْوَمْ اَسْمابھِ رْنَ جْناتَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","تیشاں پُورْوِّییَلوکانامْ اَجْنانَتاں پْرَتِیشْوَرو یَدْیَپِ ناوادھَتَّ تَتھاپِیدانِیں سَرْوَّتْرَ سَرْوّانْ مَنَح پَرِوَرْتَّیِتُمْ آجْناپَیَتِ، ");
INSERT INTO sanurd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","یَتَح سْوَنِیُکْتینَ پُرُشینَ یَدا سَ پرِتھِوِیسْتھاناں سَرْوَّلوکاناں وِچارَں کَرِشْیَتِ تَدِّنَں نْیَرُوپَیَتْ؛ تَسْیَ شْمَشانوتّھاپَنینَ تَسْمِنْ سَرْوّیبھْیَح پْرَمانَں پْراداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","تَدا شْمَشانادْ اُتّھانَسْیَ کَتھاں شْرُتْوا کیچِدْ اُپاہَمَنْ، کیچِدَوَدَنْ ایناں کَتھاں پُنَرَپِ تْوَتَّح شْروشْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","تَتَح پَولَسْتیشاں سَمِیپاتْ پْرَسْتھِाتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","تَتھاپِ کیچِلّوکاسْتینَ سارْدّھَں مِلِتْوا وْیَشْوَسَنْ تیشاں مَدھْیے رییَپاگِییَدِیَنُسِیو دامارِیناما کاچِنّارِی کِیَنْتو نَراشْچاسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","تَدْگھَٹَناتَح پَرَں پَولَ آتھِینِینَگَرادْ یاتْراں کرِتْوا کَرِنْتھَنَگَرَمْ آگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","تَسْمِنْ سَمَیے کْلَودِیَح سَرْوّانْ یِہُودِییانْ رومانَگَرَں وِہایَ گَنْتُمْ آجْناپَیَتْ، تَسْماتْ پْرِسْکِلّانامْنا جایَیا سارْدّھَمْ اِتالِیادیشاتْ کِنْچِتْپُورْوَّمْ آگَمَتْ یَح پَنْتَدیشے جاتَ آکِّلَناما یِہُودِییَلوکَح پَولَسْتَں ساکْشاتْ پْراپْیَ تَیوح سَمِیپَمِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","تَو دُوشْیَنِرْمّانَجِیوِنَو، تَسْماتْ پَرَسْپَرَمْ ایکَورِتِّکَتْواتْ سَ تابھْیاں سَہَ اُشِتْوا تَتْ کَرْمّاکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","پَولَح پْرَتِوِشْرامَوارَں بھَجَنَبھَوَنَں گَتْوا وِچارَں کرِتْوا یِہُودِییانْ اَنْیَدیشِییاںشْچَ پْرَورِتِّں گْراہِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","سِیلَتِیمَتھِیَیو رْماکِدَنِیادیشاتْ سَمیتَیوح سَتوح پَولَ اُتَّپْتَمَنا بھُوتْوا یِیشُرِیشْوَرینابھِشِکْتو بھَوَتِیتِ پْرَمانَں یِہُودِییاناں سَمِیپے پْراداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","کِنْتُ تے تِیوَ وِرودھَں وِدھایَ پاشَنْڈِییَکَتھاں کَتھِتَوَنْتَسْتَتَح پَولو وَسْتْرَں دھُنْوَنْ ایتاں کَتھاں کَتھِتَوانْ، یُشْماکَں شونِتَپاتاپَرادھو یُشْمانْ پْرَتْییوَ بھَوَتُ، تیناہَں نِرَپَرادھو دْیارَبھْیَ بھِنَّدیشِییاناں سَمِیپَں یامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","سَ تَسْماتْ پْرَسْتھایَ بھَجَنَبھَوَنَسَمِیپَسْتھَسْیَ یُسْتَنامْنَ اِیشْوَرَبھَکْتَسْیَ بھِنَّدیشِییَسْیَ نِویشَنَں پْراوِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","تَتَح کْرِیشْپَناما بھَجَنَبھَوَنادھِپَتِح سَپَرِوارَح پْرَبھَو وْیَشْوَسِیتْ، کَرِنْتھَنَگَرِییا بَہَوو لوکاشْچَ سَماکَرْنْیَ وِشْوَسْیَ مَجِّتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","کْشَنَدایاں پْرَبھُح پَولَں دَرْشَنَں دَتْوا بھاشِتَوانْ، ما بھَیشِیح، ما نِرَسِیح کَتھاں پْرَچارَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","اَہَں تْوَیا سارْدّھَمْ آسَ ہِںسارْتھَں کوپِ تْواں سْپْرَشْٹُں نَ شَکْشْیَتِ نَگَرےسْمِنْ مَدِییا لوکا بَہَوَ آسَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","تَسْماتْ پَولَسْتَنَّگَرے پْرایینَ سارْدّھَوَتْسَرَپَرْیَّنْتَں سَںسْتھاییشْوَرَسْیَ کَتھامْ اُپادِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","گالِّیَناما کَشْچِدْ آکھایادیشَسْیَ پْراڈْوِواکَح سَمَبھَوَتْ، تَتو یِہُودِییا ایکَواکْیاح سَنْتَح پَولَمْ آکْرَمْیَ وِچارَسْتھانَں نِیتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","مانُشَ ایشَ وْیَوَسْتھایَ وِرُدّھَمْ اِیشْوَرَبھَجَنَں کَرْتُّں لوکانْ کُپْرَورِتِّں گْراہَیَتِیتِ نِویدِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","تَتَح پَولے پْرَتْیُتَّرَں داتُمْ اُدْیَتے سَتِ گالِّیا یِہُودِییانْ وْیاہَرَتْ، یَدِ کَسْیَچِدْ اَنْیایَسْیَ واتِشَیَدُشْٹَتاچَرَنَسْیَ وِچاروبھَوِشْیَتْ تَرْہِ یُشْماکَں کَتھا مَیا سَہَنِییابھَوِشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","کِنْتُ یَدِ کیوَلَں کَتھایا وا نامْنو وا یُشْماکَں وْیَوَسْتھایا وِوادو بھَوَتِ تَرْہِ تَسْیَ وِچارَمَہَں نَ کَرِشْیامِ، یُویَں تَسْیَ مِیماںساں کُرُتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","تَتَح سَ تانْ وِچارَسْتھانادْ دُورِیکرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","تَدا بھِنَّدیشِییاح سوسْتھِنِنامانَں بھَجَنَبھَوَنَسْیَ پْرَدھانادھِپَتِں دھرِتْوا وِچارَسْتھانَسْیَ سَمُّکھے پْراہَرَنْ تَتھاپِ گالِّیا تیشُ سَرْوَّکَرْمَّسُ نَ مَنو نْیَدَدھاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","پَولَسْتَتْرَ پُنَرْبَہُدِنانِ نْیَوَسَتْ، تَتو بھْراترِگَنادْ وِسَرْجَنَں پْراپْیَ کِنْچَنَوْرَتَنِمِتَّں کِںکْرِیانَگَرے شِرو مُنْڈَیِتْوا پْرِسْکِلّاکِّلابھْیاں سَہِتو جَلَپَتھینَ سُرِیادیشَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","تَتَ اِپھِشَنَگَرَ اُپَسْتھایَ تَتْرَ تَو وِسرِجْیَ سْوَیَں بھَجَنَبھْوَنَں پْرَوِشْیَ یِہُودِییَیح سَہَ وِچارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","تے سْوَیح سارْدّھَں پُنَح کَتِپَیَدِنانِ سْتھاتُں تَں وْیَنَیَنْ، سَ تَدَنُرَرِیکرِتْیَ کَتھامیتاں کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","یِرُوشالَمِ آگامْیُتْسَوَپالَنارْتھَں مَیا گَمَنِییَں؛ پَشْچادْ اِیشْوَریچّھایاں جاتایاں یُشْماکَں سَمِیپَں پْرَتْیاگَمِشْیامِ۔ تَتَح پَرَں سَ تَے رْوِسرِشْٹَح سَنْ جَلَپَتھینَ اِپھِشَنَگَراتْ پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","تَتَح کَیسَرِیامْ اُپَسْتھِتَح سَنْ نَگَرَں گَتْوا سَماجَں نَمَسْکرِتْیَ تَسْمادْ آنْتِیَکھِیانَگَرَں پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","تَتْرَ کِیَتْکالَں یاپَیِتْوا تَسْماتْ پْرَسْتھایَ سَرْوّیشاں شِشْیاناں مَناںسِ سُسْتھِرانِ کرِتْوا کْرَمَشو گَلاتِیاپھْرُگِیادیشَیو رْبھْرَمِتْوا گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","تَسْمِنّیوَ سَمَیے سِکَنْدَرِیانَگَرے جاتَ آپَلّوناما شاسْتْرَوِتْ سُوَکْتا یِہُودِییَ ایکو جَنَ اِپھِشَنَگَرَمْ آگَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","سَ شِکْشِتَپْرَبھُمارْگو مَنَسودْیوگِی چَ سَنْ یوہَنو مَجَّنَماتْرَں جْناتْوا یَتھارْتھَتَیا پْرَبھوح کَتھاں کَتھَیَنْ سَمُپادِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ایشَ جَنو نِرْبھَیَتْوینَ بھَجَنَبھَوَنے کَتھَیِتُمْ آرَبْدھَوانْ، تَتَح پْرِسْکِلّاکِّلَو تَسْیوپَدیشَکَتھاں نِشَمْیَ تَں سْوَیوح سَمِیپَمْ آنِییَ شُدّھَرُوپینیشْوَرَسْیَ کَتھامْ اَبودھَیَتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","پَشْچاتْ سَ آکھایادیشَں گَنْتُں مَتِں کرِتَوانْ، تَدا تَتْرَتْیَح شِشْیَگَنو یَتھا تَں گرِہْلاتِ تَدَرْتھَں بھْراترِگَنینَ سَماشْوَسْیَ پَتْرے لِکھِتے سَتِ، آپَلّاسْتَتْروپَسْتھِتَح سَنْ اَنُگْرَہینَ پْرَتْیَیِناں بَہُوپَکارانْ اَکَروتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","پھَلَتو یِیشُرَبھِشِکْتَسْتْراتیتِ شاسْتْرَپْرَمانَں دَتْوا پْرَکاشَرُوپینَ پْرَتِپَنَّں کرِتْوا یِہُودِییانْ نِرُتَّرانْ کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","کَرِنْتھَنَگَرَ آپَلَّسَح سْتھِتِکالے پَولَ اُتَّرَپْرَدیشَیراگَچّھَنْ اِپھِشَنَگَرَمْ اُپَسْتھِتَوانْ۔ تَتْرَ کَتِپَیَشِشْیانْ ساکْشَتْ پْراپْیَ تانْ اَپرِچّھَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","یُویَں وِشْوَسْیَ پَوِتْرَماتْمانَں پْراپْتا نَ وا؟ تَتَسْتے پْرَتْیَوَدَنْ پَوِتْرَ آتْما دِییَتے اِتْیَسْمابھِح شْرُتَمَپِ نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","تَدا ساوَدَتْ تَرْہِ یُویَں کینَ مَجِّتا اَبھَوَتَ؟ تےکَتھَیَنْ یوہَنو مَجَّنینَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","تَدا پَولَ اُکْتَوانْ اِتَح پَرَں یَ اُپَسْتھاسْیَتِ تَسْمِنْ اَرْتھَتَ یِیشُکھْرِیشْٹے وِشْوَسِتَوْیَمِتْیُکْتْوا یوہَنْ مَنَحپَرِوَرْتَّنَسُوچَکینَ مَجَّنینَ جَلے لوکانْ اَمَجَّیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","تادرِشِیں کَتھاں شْرُتْوا تے پْرَبھو رْیِیشُکھْرِیشْٹَسْیَ نامْنا مَجِّتا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","تَتَح پَولینَ تیشاں گاتْریشُ کَرےرْپِتے تیشامُپَرِ پَوِتْرَ آتْماوَرُوڈھَوانْ، تَسْماتْ تے نانادیشِییا بھاشا بھَوِشْیَتْکَتھاشْچَ کَتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","تے پْرایینَ دْوادَشَجَنا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","پَولو بھَجَنَبھَوَنَں گَتْوا پْرایینَ ماسَتْرَیَمْ اِیشْوَرَسْیَ راجْیَسْیَ وِچارَں کرِتْوا لوکانْ پْرَوَرْتْیَ ساہَسینَ کَتھامَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","کِنْتُ کَٹھِنانْتَحکَرَنَتْواتْ کِیَنْتو جَنا نَ وِشْوَسْیَ سَرْوّیشاں سَمَکْشَمْ ایتَتْپَتھَسْیَ نِنْداں کَرْتُّں پْرَورِتّاح، اَتَح پَولَسْتیشاں سَمِیپاتْ پْرَسْتھایَ شِشْیَگَنَں پرِتھَکّرِتْوا پْرَتْیَہَں تُرانَّنامْنَح کَسْیَچِتْ جَنَسْیَ پاٹھَشالایاں وِچارَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","اِتّھَں وَتْسَرَدْوَیَں گَتَں تَسْمادْ آشِیادیشَنِواسِنَح سَرْوّے یِہُودِییا اَنْیَدیشِییَلوکاشْچَ پْرَبھو رْیِیشوح کَتھامْ اَشْرَوشَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","پَولینَ چَ اِیشْوَرَ ایتادرِشانْیَدْبھُتانِ کَرْمّانِ کرِتَوانْ ");
INSERT INTO sanurd_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","یَتْ پَرِدھییے گاتْرَمارْجَنَوَسْتْرے وا تَسْیَ دیہاتْ پِیڈِتَلوکانامْ سَمِیپَمْ آنِیتے تے نِرامَیا جاتا اَپَوِتْرا بھُوتاشْچَ تیبھْیو بَہِرْگَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","تَدا دیشاٹَنَکارِنَح کِیَنْتو یِہُودِییا بھُوتاپَسارِنو بھُوتَگْرَسْتَنوکاناں سَنِّدھَو پْرَبھے رْیِیشو رْنامَ جَپْتْوا واکْیَمِدَمْ اَوَدَنْ، یَسْیَ کَتھاں پَولَح پْرَچارَیَتِ تَسْیَ یِیشو رْنامْنا یُشْمانْ آجْناپَیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","سْکِوَنامْنو یِہُودِییاناں پْرَدھانَیاجَکَسْیَ سَپْتَبھِح پُتَّیسْتَتھا کرِتے سَتِ ");
INSERT INTO sanurd_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","کَشْچِدْ اَپَوِتْرو بھُوتَح پْرَتْیُدِتَوانْ، یِیشُں جانامِ پَولَنْچَ پَرِچِنومِ کِنْتُ کے یُویَں؟ ");
INSERT INTO sanurd_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","اِتْیُکْتْوا سوپَوِتْرَبھُوتَگْرَسْتو مَنُشْیو لَمْپھَں کرِتْوا تیشامُپَرِ پَتِتْوا بَلینَ تانْ جِتَوانْ، تَسْماتّے نَگْناح کْشَتانْگاشْچَ سَنْتَسْتَسْمادْ گیہاتْ پَلایَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","سا واگْ اِپھِشَنَگَرَنِواسِنَسَں سَرْوّیشاں یِہُودِییاناں بھِنَّدیشِییاناں لوکانانْچَ شْرَووگوچَرِیبھُوتا؛ تَتَح سَرْوّے بھَیَں گَتاح پْرَبھو رْیِیشو رْنامْنو یَشو وَرْدّھَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ییشامَنیکیشاں لوکاناں پْرَتِیتِرَجایَتَ تَ آگَتْیَ سْوَیح کرِتاح کْرِیاح پْرَکاشَرُوپینانْگِیکرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","بَہَوو مایاکَرْمَّکارِنَح سْوَسْوَگْرَنْتھانْ آنِییَ راشِیکرِتْیَ سَرْوّیشاں سَمَکْشَمْ اَداہَیَنْ، تَتو گَنَناں کرِتْوابُدھْیَنْتَ پَنْچایُتَرُوپْیَمُدْرامُولْیَپُسْتَکانِ دَگْدھانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","اِتّھَں پْرَبھوح کَتھا سَرْوَّدیشَں وْیاپْیَ پْرَبَلا جاتا۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","سَرْوّیشْویتیشُ کَرْمَّسُ سَمْپَنّیشُ سَتْسُ پَولو ماکِدَنِیاکھایادیشابھْیاں یِرُوشالَمَں گَنْتُں مَتِں کرِتْوا کَتھِتَوانْ تَتْسْتھانَں یاتْرایاں کرِتایاں سَتْیاں مَیا رومانَگَرَں دْرَشْٹَوْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","سْوانُگَتَلوکاناں تِیمَتھِییراسْتَو دْوَو جَنَو ماکِدَنِیادیشَں پْرَتِ پْرَہِتْیَ سْوَیَمْ آشِیادیشے کَتِپَیَدِنانِ سْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","کِنْتُ تَسْمِنْ سَمَیے مَتےسْمِنْ کَلَہو جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","تَتْکارَنَمِدَں، اَرْتِّمِیدیوْیا رُوپْیَمَنْدِرَنِرْمّانینَ سَرْوّیشاں شِلْپِناں یَتھیشْٹَلابھَمْ اَجَنَیَتْ یو دِیمِیتْرِیَناما ناڈِینْدھَمَح ");
INSERT INTO sanurd_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","سَ تانْ تَتْکَرْمَّجِیوِنَح سَرْوَّلوکاںشْچَ سَماہُویَ بھاشِتَوانْ ہے مَہیچّھا ایتینَ مَنْدِرَنِرْمّانیناسْماکَں جِیوِکا بھَوَتِ، ایتَدْ یُویَں وِتّھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","کِنْتُ ہَسْتَنِرْمِّتیشْوَرا اِیشْوَرا نَہِ پَولَنامْنا کینَچِجَّنینَ کَتھامِماں وْیاہرِتْیَ کیوَلیپھِشَنَگَرے نَہِ پْرایینَ سَرْوَّسْمِنْ آشِیادیشے پْرَورِتِّں گْراہَیِتْوا بَہُلوکاناں شیمُشِی پَراوَرْتِّتا، ایتَدْ یُشْمابھِ رْدرِشْیَتے شْرُویَتے چَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","تیناسْماکَں وانِجْیَسْیَ سَرْوَّتھا ہانیح سَمْبھَوَنَں کیوَلَمِتِ نَہِ، آشِیادیشَسْتھَے رْوا سَرْوَّجَگَتْسْتھَے رْلوکَیح پُوجْیا یارْتِمِی مَہادیوِی تَسْیا مَنْدِرَسْیاوَجْنانَسْیَ تَسْیا اَیشْوَرْیَّسْیَ ناشَسْیَ چَ سَمْبھاوَنا وِدْیَتےे۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ایتادرِشِیں کَتھاں شْرُتْوا تے مَہاکْرودھانْوِتاح سَنْتَ اُچَّیحکارَں کَتھِتَوَنْتَ اِپھِشِییانامْ اَرْتِّمِی دیوِی مَہَتِی بھَوَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","تَتَح سَرْوَّنَگَرَں کَلَہینَ پَرِپُورْنَمَبھَوَتْ، تَتَح پَرَں تے ماکِدَنِییَگایارِسْتارْکھَنامانَو پَولَسْیَ دْوَو سَہَچَرَو دھرِتْوَیکَچِتّا رَنْگَبھُومِں جَوینَ دھاوِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","تَتَح پَولو لوکاناں سَنِّدھِں یاتُمْ اُدْیَتَوانْ کِنْتُ شِشْیَگَنَسْتَں وارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","پَولَسْیَتْمِییا آشِیادیشَسْتھاح کَتِپَیاح پْرَدھانَلوکاسْتَسْیَ سَمِیپَں نَرَمیکَں پْریشْیَ تْوَں رَنْگَبھُومِں ماگا اِتِ نْیَویدَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","تَتو نانالوکاناں ناناکَتھاکَتھَناتْ سَبھا وْیاکُلا جاتا کِں کارَنادْ ایتاوَتِی جَنَتابھَوَتْ ایتَدْ اَدھِکَے رْلوکَے رْناجْنایِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","تَتَح پَرَں جَنَتامَدھْیادْ یِہُودِییَیرْبَہِشْکرِتَح سِکَنْدَرو ہَسْتینَ سَنْکیتَں کرِتْوا لوکیبھْیَ اُتَّرَں داتُمُدْیَتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","کِنْتُ سَ یِہُودِییَلوکَ اِتِ نِشْچِتے سَتِ اِپھِشِییانامْ اَرْتِّمِی دیوِی مَہَتِیتِ واکْیَں پْرایینَ پَنْچَ دَنْڈانْ یاوَدْ ایکَسْوَرینَ لوکَنِوَہَیح پْروکْتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","تَتو نَگَرادھِپَتِسْتانْ سْتھِرانْ کرِتْوا کَتھِتَوانْ ہے اِپھِشایاح سَرْوّے لوکا آکَرْنَیَتَ، اَرْتِمِیمَہادیوْیا مَہادیواتْ پَتِتایاسْتَتْپْرَتِمایاشْچَ پُوجَنَمَ اِپھِشَنَگَرَسْتھاح سَرْوّے لوکاح کُرْوَّنْتِ، ایتَتْ کے نَ جانَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","تَسْمادْ ایتَتْپْرَتِکُولَں کیپِ کَتھَیِتُں نَ شَکْنُوَنْتِ، اِتِ جْناتْوا یُشْمابھِح سُسْتھِرَتْوینَ سْتھاتَوْیَمْ اَوِوِچْیَ کِمَپِ کَرْمَّ نَ کَرْتَّوْیَنْچَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","یانْ ایتانْ مَنُشْیانْ یُویَمَتْرَ سَمانَیَتَ تے مَنْدِرَدْرَوْیاپَہارَکا یُشْماکَں دیوْیا نِنْدَکاشْچَ نَ بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","یَدِ کَنْچَنَ پْرَتِ دِیمِیتْرِیَسْیَ تَسْیَ سَہایانانْچَ کاچِدْ آپَتِّ رْوِدْیَتے تَرْہِ پْرَتِنِدھِلوکا وِچارَسْتھانَنْچَ سَنْتِ، تے تَتْ سْتھانَں گَتْوا اُتَّرَپْرَتْیُتَّرے کُرْوَّنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","کِنْتُ یُشْماکَں کاچِدَپَرا کَتھا یَدِ تِشْٹھَتِ تَرْہِ نِیَمِتایاں سَبھایاں تَسْیا نِشْپَتِّ رْبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","کِنْتْویتَسْیَ وِرودھَسْیوتَّرَں یینَ داتُں شَکْنُمْ ایتادرِشَسْیَ کَسْیَچِتْ کارَنَسْیابھاوادْ اَدْیَتَنَگھَٹَناہیتو راجَدْروہِنامِواسْماکَمْ اَبھِیوگو بھَوِشْیَتِیتِ شَنْکا وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","اِتِ کَتھَیِتْوا سَ سَبھاسْتھَلوکانْ وِسرِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","اِتّھَں کَلَہے نِورِتّے سَتِ پَولَح شِشْیَگَنَمْ آہُویَ وِسَرْجَنَں پْراپْیَ ماکِدَنِیادیشَں پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","تینَ سْتھانینَ گَچّھَنْ تَدّیشِییانْ شِشْیانْ بَہُوپَدِشْیَ یُونانِییَدیشَمْ اُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","تَتْرَ ماسَتْرَیَں سْتھِتْوا تَسْماتْ سُرِیادیشَں یاتُمْ اُدْیَتَح، کِنْتُ یِہُودِییاسْتَں ہَنْتُں گُپْتا اَتِشْٹھَنْ تَسْماتْ سَ پُنَرَپِ ماکِدَنِیامارْگینَ پْرَتْیاگَنْتُں مَتِں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","بِرَیانَگَرِییَسوپاتْرَح تھِشَلَنِیکِییارِسْتارْکھَسِکُنْدَو دَرْبّونَگَرِییَگایَتِیمَتھِیَو آشِیادیشِییَتُکھِکَتْرَپھِمَو چَ تینَ سارْدّھَں آشِیادیشَں یاوَدْ گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ایتے سَرْوّے گْرَسَراح سَنْتو سْمانْ اَپیکْشْیَ تْرویانَگَرے سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","کِنْوَشُونْیَپُوپوتْسَوَدِنے چَ گَتے سَتِ وَیَں پھِلِپِینَگَراتْ تویَپَتھینَ گَتْوا پَنْچَبھِ رْدِنَیسْتْرویانَگَرَمْ اُپَسْتھایَ تَتْرَ سَپْتَدِنانْیَواتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","سَپْتاہَسْیَ پْرَتھَمَدِنے پُوپانْ بھَںکْتُ شِشْییشُ مِلِتیشُ پَولَح پَرَدِنے تَسْماتْ پْرَسْتھاتُمْ اُدْیَتَح سَنْ تَدَہْنِ پْرایینَ کْشَپایا یامَدْوَیَں یاوَتْ شِشْییبھْیو دھَرْمَّکَتھامْ اَکَتھَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","اُپَرِسْتھے یَسْمِنْ پْرَکوشْٹھے سَبھاں کرِتْواسَنْ تَتْرَ بَہَوَح پْرَدِیپاح پْراجْوَلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","اُتُکھَناما کَشْچَنَ یُوا چَ واتایَنَ اُپَوِشَنْ گھورَتَرَنِدْراگْرَسْتو بھُوتْ تَدا پَولینَ بَہُکْشَنَں کَتھایاں پْرَچارِتایاں نِدْرامَگْنَح سَ تَسْمادْ اُپَرِسْتھَترِتِییَپْرَکوشْٹھادْ اَپَتَتْ، تَتو لوکاسْتَں مرِتَکَلْپَں دھرِتْوودَتولَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","تَتَح پَولووَرُہْیَ تَسْیَ گاتْرے پَتِتْوا تَں کْروڈے نِدھایَ کَتھِتَوانْ، یُویَں وْیاکُلا ما بھُوتَ نایَں پْرانَے رْوِیُکْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","پَشْچاتْ سَ پُنَشْچوپَرِ گَتْوا پُوپانْ بھَںکْتْوا پْرَبھاتَں یاوَتْ کَتھوپَکَتھَنے کرِتْوا پْرَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","تے چَ تَں جِیوَنْتَں یُوانَں گرِہِیتْوا گَتْوا پَرَماپْیایِتا جاتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","اَنَنْتَرَں وَیَں پوتیناگْرَسَرا بھُوتْواسْمَنَگَرَمْ اُتِّیرْیَّ پَولَں گْرَہِیتُں مَتِمْ اَکُرْمَّ یَتَح سَ تَتْرَ پَدْبھْیاں وْرَجِتُں مَتِں کرِتْویتِ نِرُوپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","تَسْماتْ تَتْراسْمابھِح سارْدّھَں تَسْمِنْ مِلِتے سَتِ وَیَں تَں نِیتْوا مِتُلِینْیُپَدْوِیپَں پْراپْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","تَسْماتْ پوتَں موچَیِتْوا پَرےہَنِ کھِییوپَدْوِیپَسْیَ سَمُّکھَں لَبْدھَوَنْتَسْتَسْمادْ ایکیناہْنا ساموپَدْوِیپَں گَتْوا پوتَں لاگَیِتْوا تْروگُلِّیے سْتھِتْوا پَرَسْمِنْ دِوَسےे مِلِیتَنَگَرَمْ اُپاتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","یَتَح پَولَ آشِیادیشے کالَں یاپَیِتُمْ نابھِلَشَنْ اِپھِشَنَگَرَں تْیَکْتْوا یاتُں مَنْتْرَناں سْتھِرِیکرِتَوانْ؛ یَسْمادْ یَدِ سادھْیَں بھَوَتِ تَرْہِ نِسْتاروتْسَوَسْیَ پَنْچاشَتَّمَدِنے سَ یِرُوشالَمْیُپَسْتھاتُں مَتِں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","پَولو مِلِیتادْ اِپھِشَں پْرَتِ لوکَں پْرَہِتْیَ سَماجَسْیَ پْراچِینانْ آہُویانِیتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","تیشُ تَسْیَ سَمِیپَمْ اُپَسْتھِتیشُ سَ تیبھْیَ اِماں کَتھاں کَتھِتَوانْ، اَہَمْ آشِیادیشے پْرَتھَماگَمَنَمْ آرَبھْیادْیَ یاوَدْ یُشْماکَں سَنِّدھَو سْتھِتْوا سَرْوَّسَمَیے یَتھاچَرِتَوانْ تَدْ یُویَں جانِیتھَ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","پھَلَتَح سَرْوَّتھا نَمْرَمَناح سَنْ بَہُشْرُپاتینَ یِہُدِییانامْ کُمَنْتْرَناجاتَناناپَرِیکْشابھِح پْرَبھوح سیوامَکَرَوَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","کامَپِ ہِتَکَتھاाں نَ گوپایِتَوانْ تاں پْرَچارْیَّ سَپْرَکاشَں گرِہے گرِہے سَمُپَدِشْییشْوَرَں پْرَتِ مَنَح پَراوَرْتَّنِییَں پْرَبھَو یِیشُکھْرِیشْٹے وِشْوَسَنِییَں ");
INSERT INTO sanurd_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","یِہُودِییانامْ اَنْیَدیشِییَلوکانانْچَ سَمِیپَ ایتادرِشَں ساکْشْیَں دَدامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","پَشْیَتَ سامْپْرَتَمْ آتْمَناکرِشْٹَح سَنْ یِرُوشالَمْنَگَرے یاتْراں کَرومِ، تَتْرَ مامْپْرَتِ یَدْیَدْ گھَٹِشْیَتے تانْیَہَں نَ جانامِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","کِنْتُ مَیا بَنْدھَنَں کْلیشَشْچَ بھوکْتَوْیَ اِتِ پَوِتْرَ آتْما نَگَرے نَگَرے پْرَمانَں دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","تَتھاپِ تَں کْلیشَمَہَں ترِنایَ نَ مَنْیے؛ اِیشْوَرَسْیانُگْرَہَوِشَیَکَسْیَ سُسَںوادَسْیَ پْرَمانَں داتُں، پْرَبھو رْیِیشوح سَکاشادَ یَسْیاح سیوایاح بھارَں پْراپْنَوَں تاں سیواں سادھَیِتُں سانَنْدَں سْوَمارْگَں سَماپَیِتُुنْچَ نِجَپْرانانَپِ پْرِیانْ نَ مَنْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","اَدھُنا پَشْیَتَ ییشاں سَمِیپےہَمْ اِیشْوَرِییَراجْیَسْیَ سُسَںوادَں پْرَچارْیَّ بھْرَمَنَں کرِتَوانْ ایتادرِشا یُویَں مَمَ وَدَنَں پُنَ رْدْرَشْٹُں نَ پْراپْسْیَتھَ ایتَدَپْیَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","یُشْمَبھْیَمْ اَہَمْ اِیشْوَرَسْیَ سَرْوّانْ آدیشانْ پْرَکاشَیِتُں نَ نْیَوَرْتّے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","اَہَں سَرْوّیشاں لوکاناں رَکْتَپاتَدوشادْ یَنِّرْدوشَ آسے تَسْیادْیَ یُشْمانْ ساکْشِنَح کَرومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","یُویَں سْویشُ تَتھا یَسْیَ وْرَجَسْیادھْیَکْشَنْ آتْما یُشْمانْ وِدھایَ نْیَیُنْکْتَ تَتْسَرْوَّسْمِنْ ساوَدھانا بھَوَتَ، یَ سَماجَنْچَ پْرَبھُ رْنِجَرَکْتَمُولْیینَ کْرِیتَوانَ تَمْ اَوَتَ، ");
INSERT INTO sanurd_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","یَتو مَیا گَمَنے کرِتَایوَ دُرْجَیا ورِکا یُشْماکَں مَدھْیَں پْرَوِشْیَ وْرَجَں پْرَتِ نِرْدَیَتامْ آچَرِشْیَنْتِ، ");
INSERT INTO sanurd_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","یُشْماکَمیوَ مَدھْیادَپِ لوکا اُتّھایَ شِشْیَگَنَمْ اَپَہَنْتُں وِپَرِیتَمْ اُپَدیکْشْیَنْتِیتْیَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","اِتِ ہیتو رْیُویَں سَچَیتَنْیاح سَنْتَسْتِشْٹَتَ، اَہَنْچَ ساشْرُپاتَح سَنْ وَتْسَرَتْرَیَں یاوَدْ دِوانِشَں پْرَتِجَنَں بودھَیِتُں نَ نْیَوَرْتّے تَدَپِ سْمَرَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","اِدانِیں ہے بھْراتَرو یُشْماکَں نِشْٹھاں جَنَیِتُں پَوِتْرِیکرِتَلوکاناں مَدھْیےدھِکارَنْچَ داتُں سَمَرْتھو یَ اِیشْوَرَسْتَسْیانُگْرَہَسْیَ یو وادَشْچَ تَیورُبھَیو رْیُشْمانْ سَمارْپَیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","کَسْیاپِ سْوَرْنَں رُوپْیَں وَسْتْرَں وا پْرَتِ مَیا لوبھو نَ کرِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","کِنْتُ مَمَ مَتْسَہَچَرَلوکانانْچاوَشْیَکَوْیَیایَ مَدِییَمِدَں کَرَدْوَیَمْ اَشْرامْیَدْ ایتَدْ یُویَں جانِیتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","اَنینَ پْرَکارینَ گْرَہَنَدْ دانَں بھَدْرَمِتِ یَدْواکْیَں پْرَبھُ رْیِیشُح کَتھِتَوانْ تَتْ سْمَرْتُّں دَرِدْرَلوکانامُپَکارارْتھَں شْرَمَں کَرْتُّنْچَ یُشْماکَمْ اُچِتَمْ ایتَتْسَرْوَّں یُشْمانَہَمْ اُپَدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ایتاں کَتھاں کَتھَیِتْوا سَ جانُنِی پاتَیِتْوا سَرْوَیح سَہَ پْرارْتھَیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","تینَ تے کْرَنْدْرَنْتَح ");
INSERT INTO sanurd_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","پُنَ رْمَمَ مُکھَں نَ دْرَکْشْیَتھَ وِشیشَتَ ایشا یا کَتھا تیناکَتھِ تَتْکارَناتْ شوکَں وِلاپَنْچَ کرِتْوا کَنْٹھَں دھرِتْوا چُمْبِتَوَنْتَح۔ پَشْچاتْ تے تَں پوتَں نِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","تَے رْوِسرِشْٹاح سَنْتو وَیَں پوتَں باہَیِتْوا رِجُمارْگینَ کوشَمْ اُپَدْوِیپَمْ آگَتْیَ پَرےہَنِ رودِیوپَدْوِیپَمْ آگَچّھامَ تَتَسْتَسْماتْ پاتارایامْ اُپاتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","تَتْرَ پھَینِیکِیادیشَگامِنَمْ پوتَمیکَں پْراپْیَ تَمارُہْیَ گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","کُپْروپَدْوِیپَں درِشْٹْوا تَں سَوْیَدِشِ سْتھاپَیِتْوا سُرِیادیشَں گَتْوا پوتَسْتھَدْرَوْیانْیَوَروہَیِتُں سورَنَگَرے لاگِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","تَتْرَ شِشْیَگَنَسْیَ ساکْشاتْکَرَنایَ وَیَں تَتْرَ سَپْتَدِنانِ سْتھِتَوَنْتَح پَشْچاتّے پَوِتْریناتْمَنا پَولَں وْیاہَرَنْ تْوَں یِرُوشالَمْنَگَرَں ما گَمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","تَتَسْتیشُ سَپْتَسُ دِنیشُ یاپِتیشُ سَتْسُ وَیَں تَسْماتْ سْتھاناتْ نِجَوَرْتْمَنا گَتَوَنْتَح، تَسْماتْ تے سَبالَورِدّھَوَنِتا اَسْمابھِح سَہَ نَگَرَسْیَ پَرِسَرَپَرْیَّنْتَمْ آگَتاح پَشْچادْوَیَں جَلَدھِتَٹے جانُپاتَں پْرارْتھَیامَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","تَتَح پَرَسْپَرَں وِسرِشْٹاح سَنْتو وَیَں پوتَں گَتاسْتے تُ سْوَسْوَگرِہَں پْرَتْیاگَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","وَیَں سورَنَگَراتْ ناوا پْرَسْتھایَ تَلِمایِنَگَرَمْ اُپاتِشْٹھامَ تَتْراسْماکَں سَمُدْرِییَمارْگَسْیانْتوبھَوَتْ تَتْرَ بھْراترِگَنَں نَمَسْکرِتْیَ دِنَمیکَں تَیح سارْدّھَمْ اُشَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","پَرے ہَنِ پَولَسْتَسْیَ سَنْگِنو وَیَنْچَ پْرَتِشْٹھَماناح کَیسَرِیانَگَرَمْ آگَتْیَ سُسَںوادَپْرَچارَکاناں سَپْتَجَناناں پھِلِپَنامْنَ ایکَسْیَ گرِہَں پْرَوِشْیاوَتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","تَسْیَ چَتَسْرو دُہِتَرونُوڈھا بھَوِشْیَدْوادِنْیَ آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","تَتْراسْماسُ بَہُدِنانِ پْروشِتیشُ یِہُودِییَدیشادْ آگَتْیاگابَناما بھَوِشْیَدْوادِی سَمُپَسْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","سوسْماکَں سَمِیپَمیتْیَ پَولَسْیَ کَٹِبَنْدھَنَں گرِہِیتْوا نِجَہَسْتاپادانْ بَدّھوا بھاشِتَوانْ یَسْییدَں کَٹِبَنْدھَنَں تَں یِہُودِییَلوکا یِرُوشالَمَنَگَرَ اِتّھَں بَدّھوا بھِنَّدیشِییاناں کَریشُ سَمَرْپَیِشْیَنْتِیتِ واکْیَں پَوِتْرَ آتْما کَتھَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ایتادرِشِیں کَتھاں شْرُتْوا وَیَں تَنَّگَرَواسِنو بھْراتَرَشْچَ یِرُوشالَمَں نَ یاتُں پَولَں وْیَنَیامَہِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","کِنْتُ سَ پْرَتْیاوادِیتْ، یُویَں کِں کُرُتھَ؟ کِں کْرَنْدَنینَ مَمانْتَحکَرَنَں وِدِیرْنَں کَرِشْیَتھَ؟ پْرَبھو رْیِیشو رْنامْنو نِمِتَّں یِرُوشالَمِ بَدّھو بھَوِتُں کیوَلَ تَنَّ پْرانانْ داتُمَپِ سَسَجّوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","تیناسْماکَں کَتھایامْ اَگرِہِیتایامْ اِیشْوَرَسْیَ یَتھیچّھا تَتھَیوَ بھَوَتْوِتْیُکْتْوا وَیَں نِرَسْیامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","پَرےہَنِ پاتھییَدْرَوْیانِ گرِہِیتْوا یِرُوشالَمَں پْرَتِ یاتْرامْ اَکُرْمَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","تَتَح کَیسَرِیانَگَرَنِواسِنَح کَتِپَیاح شِشْیا اَسْمابھِح سارْدّھَمْ اِتْوا کرِپْرِییینَ مْناسَنّامْنا یینَ پْراچِینَشِشْیینَ سارْدّھَمْ اَسْمابھِ رْوَسْتَوْیَں تَسْیَ سَمِیپَمْ اَسْمانْ نِیتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","اَسْماسُ یِرُوشالَمْیُپَسْتھِتیشُ تَتْرَسْتھَبھْراترِگَنوسْمانْ آہْلادینَ گرِہِیتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","پَرَسْمِنْ دِوَسے پَولےسْمابھِح سَہَ یاکُوبو گرِہَں پْرَوِشْٹے لوکَپْراچِیناح سَرْوّے تَتْرَ پَرِشَدِ سَںسْتھِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","اَنَنْتَرَں سَ تانْ نَتْوا سْوِییَپْرَچارَنینَ بھِنَّدیشِییانْ پْرَتِیشْوَرو یانِ کَرْمّانِ سادھِتَوانْ تَدِییاں کَتھامْ اَنُکْرَماتْ کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","اِتِ شْرُتْوا تے پْرَبھُں دھَنْیَں پْروچْیَ واکْیَمِدَمْ اَبھاشَنْتَ، ہے بھْراتَ رْیِہُودِییاناں مَدھْیے بَہُسَہَسْرانِ لوکا وِشْواسِنَ آسَتے کِنْتُ تے سَرْوّے وْیَوَسْتھامَتاچارِنَ ایتَتْ پْرَتْیَکْشَں پَشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","شِشُوناں تْوَکْچھیدَنادْیاچَرَنَں پْرَتِشِدھْیَ تْوَں بھِنَّدیشَنِواسِنو یِہُودِییَلوکانْ مُوساواکْیَمْ اَشْرَدّھاتُمْ اُپَدِشَسِیتِ تَیح شْرُتَمَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","تْوَمَتْراگَتوسِیتِ وارْتّاں سَماکَرْنْیَ جَنَنِوَہو مِلِتْواوَشْیَمیواگَمِشْیَتِ؛ اَتَایوَ کِں کَرَنِییَمْ؟ اَتْرَ وَیَں مَنْتْرَیِتْوا سَمُپایَں تْواں وَدامَسْتَں تْوَماچَرَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","وْرَتَں کَرْتُّں کرِتَسَنْکَلْپا یےسْماںکَ چَتْوارو مانَواح سَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","تانْ گرِہِیتْوا تَیح سَہِتَح سْوَں شُچِں کُرُ تَتھا تیشاں شِرومُنْڈَنے یو وْیَیو بھَوَتِ تَں تْوَں دیہِ۔ تَتھا کرِتے تْوَدِییاچارے یا جَنَشْرُتِ رْجایَتے سالِیکا کِنْتُ تْوَں وِدھِں پالَیَنْ وْیَوَسْتھانُسارینیواچَرَسِیتِ تے بھوتْسَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","بھِنَّدیشِییاناں وِشْواسِلوکاناں نِکَٹے وَیَں پَتْرَں لِکھِتْویتّھَں سْتھِرِیکرِتَوَنْتَح، دیوَپْرَسادَبھوجَنَں رَکْتَں گَلَپِیڈَنَمارِتَپْرانِبھوجَنَں وْیَبھِچارَشْچَیتیبھْیَح سْوَرَکْشَنَوْیَتِریکینَ تیشامَنْیَوِدھِپالَنَں کَرَنِییَں نَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","تَتَح پَولَسْتانْ مانُشانادایَ پَرَسْمِنْ دِوَسے تَیح سَہَ شُچِ رْبھُوتْوا مَنْدِرَں گَتْوا شَوچَکَرْمَّنو دِنیشُ سَمْپُورْنیشُ تیشامْ ایکَیکارْتھَں نَیویدْیادْیُتْسَرْگو بھَوِشْیَتِیتِ جْناپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","تیشُ سَپْتَسُ دِنیشُ سَماپْتَکَلْپیشُ آشِیادیشَنِواسِنو یِہُودِییاسْتَں مَدھْییمَنْدِرَں وِلوکْیَ جَنَنِوَہَسْیَ مَنَحسُ کُپْرَورِتِّں جَنَیِتْوا تَں دھرِتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","پْروچَّیح پْراووچَنْ، ہے اِسْراییلّوکاح سَرْوّے ساہایَّں کُرُتَ۔ یو مَنُجَ ایتیشاں لوکاناں مُوساوْیَوَسْتھایا ایتَسْیَ سْتھانَسْیاپِ وِپَرِیتَں سَرْوَّتْرَ سَرْوّانْ شِکْشَیَتِ سَ ایشَح؛ وِشیشَتَح سَ بھِنَّدیشِییَلوکانْ مَنْدِرَمْ آنِییَ پَوِتْرَسْتھانَمیتَدْ اَپَوِتْرَمَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","پُورْوَّں تے مَدھْیینَگَرَمْ اِپھِشَنَگَرِییَں تْرَپھِمَں پَولینَ سَہِتَں درِشْٹَوَنْتَ ایتَسْماتْ پَولَسْتَں مَنْدِرَمَدھْیَمْ آنَیَدْ اِتْیَنْوَمِمَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","اَتَایوَ سَرْوَّسْمِنْ نَگَرے کَلَہوتْپَنَّتْواتْ دھاوَنْتو لوکا آگَتْیَ پَولَں دھرِتْوا مَنْدِرَسْیَ بَہِراکرِشْیانَیَنْ تَتْکْشَنادْ دْوارانِ سَرْوّانِ چَ رُدّھانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","تیشُ تَں ہَنْتُمُدْیَتےेشُ یِرُوشالَمْنَگَرے مَہانُپَدْرَوو جاتَ اِتِ وارْتّایاں سَہَسْرَسیناپَتیح کَرْنَگوچَرِیبھُوتایاں سَتْیاں سَ تَتْکْشَناتْ سَینْیانِ سیناپَتِگَنَنْچَ گرِہِیتْوا جَویناگَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","تَتو لوکاح سیناگَنینَ سَہَ سَہَسْرَسیناپَتِمْ آگَچّھَنْتَں درِشْٹْوا پَولَتاڈَناتو نْیَوَرْتَّنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","سَ سَہَسْرَسیناپَتِح سَنِّدھاواگَمْیَ پَولَں دھرِتْوا شرِنْکھَلَدْوَیینَ بَدّھَمْ آدِشْیَ تانْ پرِشْٹَوانْ ایشَ کَح؟ کِں کَرْمَّ چایَں کرِتَوانْ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","تَتو جَنَسَمُوہَسْیَ کَشْچِدْ ایکَپْرَکارَں کَشْچِدْ اَنْیَپْرَکارَں واکْیَمْ اَرَوتْ سَ تَتْرَ سَتْیَں جْناتُمْ کَلَہَکارَنادْ اَشَکْتَح سَنْ تَں دُرْگَں نیتُمْ آجْناپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","تیشُ سوپانَسْیوپَرِ پْراپْتیشُ لوکاناں ساہَسَکارَناتْ سیناگَنَح پَولَمُتّولْیَ نِیتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","تَتَح سَرْوّے لوکاح پَشْچادْگامِنَح سَنْتَ اینَں دُرِیکُرُتیتِ واکْیَمْ اُچَّیرَوَدَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","پَولَسْیَ دُرْگانَیَنَسَمَیے سَ تَسْمَے سَہَسْرَسیناپَتَیے کَتھِتَوانْ، بھَوَتَح پُرَسْتاتْ کَتھاں کَتھَیِتُں کِمْ اَنُمَنْیَتے؟ سَ تَمَپرِچّھَتْ تْوَں کِں یُونانِییاں بھاشاں جاناسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","یو مِسَرِییو جَنَح پُورْوَّں وِرودھَں کرِتْوا چَتْوارِ سَہَسْرانِ گھاتَکانْ سَنْگِنَح کرِتْوا وِپِنَں گَتَوانْ تْوَں کِں سَایوَ نَ بھَوَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","تَدا پَولوکَتھَیَتْ اَہَں کِلِکِیادیشَسْیَ تارْشَنَگَرِییو یِہُودِییو، ناہَں سامانْیَنَگَرِییو مانَوَح؛ اَتَایوَ وِنَیےہَں لاکاناں سَمَکْشَں کَتھاں کَتھَیِتُں مامَنُجانِیشْوَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","تینانُجْناتَح پَولَح سوپانوپَرِ تِشْٹھَنْ ہَسْتینینْگِتَں کرِتَوانْ، تَسْماتْ سَرْوّے سُسْتھِرا اَبھَوَنْ۔ تَدا پَولَ اِبْرِییَبھاشَیا کَتھَیِتُمْ آرَبھَتَ، ");
INSERT INTO sanurd_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ہے پِترِگَنا ہے بھْراترِگَناح، اِدانِیں مَمَ نِویدَنے سَمَوَدھَتَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","تَدا سَ اِبْرِییَبھاشَیا کَتھاں کَتھَیَتِیتِ شْرُتْوا سَرْوّے لوکا اَتِیوَ نِحشَبْدا سَنْتوتِشْٹھَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","پَشْچاتْ سوکَتھَیَدْ اَہَں یِہُودِییَ اِتِ نِشْچَیَح کِلِکِیادیشَسْیَ تارْشَنَگَرَں مَمَ جَنْمَبھُومِح،ایتَنَّگَرِییَسْیَ گَمِلِیییلَنامْنودھْیاپَکَسْیَ شِشْیو بھُوتْوا پُورْوَّپُرُشاناں وِدھِوْیَوَسْتھانُسارینَ سَمْپُورْنَرُوپینَ شِکْشِتوبھَوَمْ اِدانِینْتَنا یُویَں یادرِشا بھَوَتھَ تادرِشوہَمَپِیشْوَرَسیوایامْ اُدْیوگِی جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","مَتَمیتَدْ دْوِشْٹْوا تَدْگْراہِنارِیپُرُشانْ کارایاں بَدّھوا تیشاں پْرانَناشَپَرْیَّنْتاں وِپَکْشَتامْ اَکَرَوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","مَہایاجَکَح سَبھاسَدَح پْراچِینَلوکاشْچَ مَمَیتَسْیاح کَتھایاح پْرَمانَں داتُں شَکْنُوَنْتِ، یَسْماتْ تیشاں سَمِیپادْ دَمّیشَکَنَگَرَنِواسِبھْراترِگَنارْتھَمْ آجْناپَتْرانِ گرِہِیتْوا یے تَتْرَ سْتھِتاسْتانْ دَنْڈَیِتُں یِرُوشالَمَمْ آنَیَنارْتھَں دَمّیشَکَنَگَرَں گَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","کِنْتُ گَچّھَنْ تَنَّگَرَسْیَ سَمِیپَں پْراپْتَوانْ تَدا دْوِتِییَپْرَہَرَویلایاں سَتْیامْ اَکَسْمادْ گَگَنانِّرْگَتْیَ مَہَتِی دِیپْتِ رْمَمَ چَتُرْدِشِ پْرَکاشِتَوَتِی۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","تَتو مَیِ بھُومَوै پَتِتے سَتِ، ہے شَولَ ہے شَولَ کُتو ماں تاڈَیَسِ؟ مامْپْرَتِ بھاشِتَ ایتادرِشَ ایکو رَووپِ مَیا شْرُتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","تَداہَں پْرَتْیَوَدَں، ہے پْرَبھے کو بھَوانْ؟ تَتَح سووادِیتْ یَں تْوَں تاڈَیَسِ سَ ناسَرَتِییو یِیشُرَہَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","مَمَ سَنْگِنو لوکاسْتاں دِیپْتِں درِشْٹْوا بھِیَں پْراپْتاح، کِنْتُ مامْپْرَتْیُدِتَں تَدْواکْیَں تےे نابُدھْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","تَتَح پَرَں پرِشْٹَوانَہَں، ہے پْرَبھو مَیا کِں کَرْتَّوْیَں؟ تَتَح پْرَبھُرَکَتھَیَتْ، اُتّھایَ دَمّیشَکَنَگَرَں یاہِ تْوَیا یَدْیَتْ کَرْتَّوْیَں نِرُوپِتَماسْتے تَتْ تَتْرَ تْوَں جْناپَیِشْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","اَنَنْتَرَں تَسْیاح کھَرَتَرَدِیپْتیح کارَناتْ کِمَپِ نَ درِشْٹْوا سَنْگِگَنینَ دھرِتَہَسْتَح سَنْ دَمّیشَکَنَگَرَں وْرَجِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","تَنَّگَرَنِواسِناں سَرْوّیشاں یِہُودِییاناں مانْیو وْیَوَسْتھانُسارینَ بھَکْتَشْچَ ہَنانِییَناما مانَوَ ایکو ");
INSERT INTO sanurd_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","مَمَ سَنِّدھِمْ ایتْیَ تِشْٹھَنْ اَکَتھَیَتْ، ہے بھْراتَح شَولَ سُدرِشْٹِ رْبھَوَ تَسْمِنْ دَنْڈےہَں سَمْیَکْ تَں درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","تَتَح سَ مَہْیَں کَتھِتَوانْ یَتھا تْوَمْ اِیشْوَرَسْیابھِپْرایَں ویتْسِ تَسْیَ شُدّھَسَتّوَجَنَسْیَ دَرْشَنَں پْراپْیَ تَسْیَ شْرِیمُکھَسْیَ واکْیَں شرِنوشِ تَنِّمِتَّمْ اَسْماکَں پُورْوَّپُرُشانامْ اِیشْوَرَسْتْواں مَنونِیتَں کرِتَوانَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","یَتو یَدْیَدْ اَدْراکْشِیرَشْرَوشِیشْچَ سَرْوّیشاں مانَواناں سَمِیپے تْوَں تیشاں ساکْشِی بھَوِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","اَتَایوَ کُتو وِلَمْبَسے؟ پْرَبھو رْنامْنا پْرارْتھْیَ نِجَپاپَپْرَکْشالَنارْتھَں مَجَّنایَ سَمُتِّشْٹھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","تَتَح پَرَں یِرُوشالَمْنَگَرَں پْرَتْیاگَتْیَ مَنْدِرےہَمْ ایکَدا پْرارْتھَیے، تَسْمِنْ سَمَیےہَمْ اَبھِبھُوتَح سَنْ پْرَبھُوں ساکْشاتْ پَشْیَنْ، ");
INSERT INTO sanurd_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","تْوَں تْوَرَیا یِرُوشالَمَح پْرَتِشْٹھَسْوَ یَتو لوکامَیِ تَوَ ساکْشْیَں نَ گْرَہِیشْیَنْتِ، مامْپْرَتْیُدِتَں تَسْییدَں واکْیَمْ اَشْرَوشَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","تَتوہَں پْرَتْیَوادِشَمْ ہے پْرَبھو پْرَتِبھَجَنَبھَوَنَں تْوَیِ وِشْواسِنو لوکانْ بَدّھوا پْرَہرِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","تَتھا تَوَ ساکْشِنَح سْتِپھانَسْیَ رَکْتَپاتَنَسَمَیے تَسْیَ وِناشَں سَمَّنْیَ سَنِّدھَو تِشْٹھَنْ ہَنْترِلوکاناں واساںسِ رَکْشِتَوانْ، ایتَتْ تے وِدُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","تَتَح سوکَتھَیَتْ پْرَتِشْٹھَسْوَ تْواں دُورَسْتھَبھِنَّدیشِییاناں سَمِیپَں پْریشَیِشْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","تَدا لوکا ایتاوَتْپَرْیَّنْتاں تَدِییاں کَتھاں شْرُتْوا پْروچَّیرَکَتھَیَنْ، اینَں بھُومَنْڈَلادْ دُورِیکُرُتَ، ایتادرِشَجَنَسْیَ جِیوَنَں نوچِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","اِتْیُچَّیح کَتھَیِتْوا وَسَنانِ پَرِتْیَجْیَ گَگَنَں پْرَتِ دھُولِیرَکْشِپَنْ ");
INSERT INTO sanurd_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","تَتَح سَہَسْرَسیناپَتِح پَولَں دُرْگابھْیَنْتَرَ نیتُں سَمادِشَتْ۔ ایتَسْیَ پْرَتِکُولاح سَنْتو لوکاح کِنِّمِتَّمْ ایتاوَدُچَّیحسْوَرَمْ اَکُرْوَّنْ، ایتَدْ ویتُّں تَں کَشَیا پْرَہرِتْیَ تَسْیَ پَرِیکْشاں کَرْتُّمادِشَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","پَداتَیَشْچَرْمَّنِرْمِّتَرَجُّبھِسْتَسْیَ بَنْدھَنَں کَرْتُّمُدْیَتاسْتاسْتَدانِیں پَولَح سَمُّکھَسْتھِتَں شَتَسیناپَتِمْ اُکْتَوانْ دَنْڈاجْنایامْ اَپْراپْتایاں کِں رومِلوکَں پْرَہَرْتُّں یُشْماکَمْ اَدھِکاروسْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ایناں کَتھاں شْرُتْوا سَ سَہَسْرَسیناپَتیح سَنِّدھِں گَتْوا تاں وارْتّامَوَدَتْ سَ رومِلوکَ ایتَسْماتْ ساوَدھانَح سَنْ کَرْمَّ کُرُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","تَسْماتْ سَہَسْرَسیناپَتِ رْگَتْوا تَمَپْراکْشِیتْ تْوَں کِں رومِلوکَح؟ اِتِ ماں بْرُوہِ۔ سوکَتھَیَتْ سَتْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","تَتَح سَہَسْرَسیناپَتِح کَتھِتَوانْ بَہُدْرَوِنَں دَتّواہَں تَتْ پَورَسَکھْیَں پْراپْتَوانْ؛ کِنْتُ پَولَح کَتھِتَوانْ اَہَں جَنُنا تَتْ پْراپْتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","اِتّھَں سَتِ یے پْرَہارینَ تَں پَرِیکْشِتُں سَمُدْیَتا آسَنْ تے تَسْیَ سَمِیپاتْ پْراتِشْٹھَنْتَ؛ سَہَسْرَسیناپَتِسْتَں رومِلوکَں وِجْنایَ سْوَیَں یَتْ تَسْیَ بَنْدھَنَمْ اَکارْشِیتْ تَتْکارَنادْ اَبِبھیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","یِہُودِییَلوکاح پَولَں کُتوپَوَدَنْتے تَسْیَ ورِتّانْتَں جْناتُں وانْچھَنْ سَہَسْرَسیناپَتِح پَرےہَنِ پَولَں بَنْدھَناتْ موچَیِتْوا پْرَدھانَیاجَکانْ مَہاسَبھایاح سَرْوَّلوکاشْچَ سَمُپَسْتھاتُمْ آدِشْیَ تیشاں سَنِّدھَو پَولَمْ اَوَروہْیَ سْتھاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","سَبھاسَدْلوکانْ پْرَتِ پَولونَنْیَدرِشْٹْیا پَشْیَنْ اَکَتھَیَتْ، ہے بھْراترِگَنا اَدْیَ یاوَتْ سَرَلینَ سَرْوّانْتَحکَرَنینیشْوَرَسْیَ ساکْشادْ آچَرامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","اَنینَ ہَنانِییَناما مَہایاجَکَسْتَں کَپولے چَپیٹیناہَنْتُں سَمِیپَسْتھَلوکانْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","تَدا پَولَسْتَمَوَدَتْ، ہے بَہِشْپَرِشْکرِتَ، اِیشْوَرَسْتْواں پْرَہَرْتُّمْ اُدْیَتوسْتِ، یَتو وْیَوَسْتھانُسارینَ وِچارَیِتُمْ اُپَوِشْیَ وْیَوَسْتھاں لَنْگھِتْوا ماں پْرَہَرْتُّمْ آجْناپَیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","تَتو نِکَٹَسْتھا لوکا اَکَتھَیَنْ، تْوَں کِمْ اِیشْوَرَسْیَ مَہایاجَکَں نِنْدَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","تَتَح پَولَح پْرَتِبھاشِتَوانْ ہے بھْراترِگَنَ مَہایاجَکَ ایشَ اِتِ نَ بُدّھَں مَیا تَدَنْیَچَّ سْوَلوکانامْ اَدھِپَتِں پْرَتِ دُرْوّاکْیَں ما کَتھَیَ، ایتادرِشِی لِپِرَسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","اَنَنْتَرَں پَولَسْتیشامْ اَرْدّھَں سِدُوکِلوکا اَرْدّھَں پھِرُوشِلوکا اِتِ درِشْٹْوا پْروچَّیح سَبھاسْتھَلوکانْ اَوَدَتْ ہے بھْراترِگَنَ اَہَں پھِرُوشِمَتاوَلَمْبِی پھِرُوشِنَح سَتْنانَشْچَ، مرِتَلوکانامْ اُتّھانے پْرَتْیاشاکَرَنادْ اَہَمَپَوادِتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","اِتِ کَتھایاں کَتھِتایاں پھِرُوشِسِدُوکِنوح پَرَسْپَرَں بھِنَّواکْیَتْواتْ سَبھایا مَدھْیے دْوَو سَںگھَو جاتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","یَتَح سِدُوکِلوکا اُتّھانَں سْوَرْگِییَدُوتا آتْمانَشْچَ سَرْوّیشامْ ایتیشاں کَمَپِ نَ مَنْیَنْتے، کِنْتُ پھِرُوشِنَح سَرْوَّمْ اَنْگِیکُرْوَّنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","تَتَح پَرَسْپَرَمْ اَتِشَیَکولاہَلے سَمُپَسْتھِتے پھِرُوشِناں پَکْشِییاح سَبھاسْتھا اَدھْیاپَکاح پْرَتِپَکْشا اُتِّشْٹھَنْتو کَتھَیَنْ، ایتَسْیَ مانَوَسْیَ کَمَپِ دوشَں نَ پَشْیامَح؛ یَدِ کَشْچِدْ آتْما وا کَشْچِدْ دُوتَ اینَں پْرَتْیادِشَتْ تَرْہِ وَیَمْ اِیشْوَرَسْیَ پْراتِکُولْیینَ نَ یوتْسْیامَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","تَسْمادْ اَتِیوَ بھِنَّواکْیَتْوے سَتِ تے پَولَں کھَنْڈَں کھَنْڈَں کَرِشْیَنْتِیتْیاشَنْکَیا سَہَسْرَسیناپَتِح سیناگَنَں تَتْسْتھانَں یاتُں سَبھاتو بَلاتْ پَولَں دھرِتْوا دُرْگَں نیتَنْچاجْناپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","راتْرو پْرَبھُسْتَسْیَ سَمِیپے تِشْٹھَنْ کَتھِتَوانْ ہے پَولَ نِرْبھَیو بھَوَ یَتھا یِرُوشالَمْنَگَرے مَیِ ساکْشْیَں دَتَّوانْ تَتھا رومانَگَریپِ تْوَیا داتَوْیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","دِنے سَمُپَسْتھِتے سَتِ کِیَنْتو یِہُودِییَلوکا ایکَمَنْتْرَناح سَنْتَح پَولَں نَ ہَتْوا بھوجَنَپانے کَرِشْیامَ اِتِ شَپَتھینَ سْوانْ اَبَدھْنَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","چَتْوارِںشَجَّنیبھْیودھِکا لوکا اِتِ پَنَمْ اَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","تے مَہایاجَکاناں پْراچِینَلوکانانْچَ سَمِیپَں گَتْوا کَتھَیَنْ، وَیَں پَولَں نَ ہَتْوا کِمَپِ نَ بھوکْشْیامَہے درِڈھینانینَ شَپَتھینَ بَدّھوا اَبھَوامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","اَتَایوَ سامْپْرَتَں سَبھاسَدْلوکَیح سَہَ وَیَں تَسْمِنْ کَنْچِدْ وِشیشَوِچارَں کَرِشْیامَسْتَدَرْتھَں بھَوانْ شْوو سْماکَں سَمِیپَں تَمْ آنَیَتْوِتِ سَہَسْرَسیناپَتَیے نِویدَنَں کُرُتَ تینَ یُشْماکَں سَمِیپَں اُپَسْتھِتیح پُورْوَّں وَیَں تَں ہَنْتُ سَجِّشْیامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","تَدا پَولَسْیَ بھاگِنییَسْتیشامِتِ مَنْتْرَناں وِجْنایَ دُرْگَں گَتْوا تاں وارْتّاں پَولَمْ اُکْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","تَسْماتْ پَولَ ایکَں شَتَسیناپَتِمْ آہُویَ واکْیَمِدَمْ بھاشِتَوانْ سَہَسْرَسیناپَتیح سَمِیپےسْیَ یُوَمَنُشْیَسْیَ کِنْچِنِّویدَنَمْ آسْتے، تَسْماتْ تَتْسَوِدھَمْ اینَں نَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","تَتَح سَ تَمادایَ سَہَسْرَسیناپَتیح سَمِیپَمْ اُپَسْتھایَ کَتھِتَوانْ، بھَوَتَح سَمِیپےسْیَ کِمَپِ نِویدَنَماسْتے تَسْماتْ بَنْدِح پَولو ماماہُویَ بھَوَتَح سَمِیپَمْ اینَمْ آنیتُں پْرارْتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","تَدا سَہَسْرَسیناپَتِسْتَسْیَ ہَسْتَں دھرِتْوا نِرْجَنَسْتھانَں نِیتْوا پرِشْٹھَوانْ تَوَ کِں نِویدَنَں؟ تَتْ کَتھَیَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","تَتَح سوکَتھَیَتْ، یِہُودِییَلاکاح پَولے کَمَپِ وِشیشَوِچارَں چھَلَں کرِتْوا تَں سَبھاں نیتُں بھَوَتَح سَمِیپے نِویدَیِتُں اَمَنْتْرَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","کِنْتُ مَوَتا تَنَّ سْوِیکَرْتَّوْیَں یَتَسْتیشاں مَدھْییوَرْتِّنَشْچَتْوارِںشَجَّنیبھْیو دھِکَلوکا ایکَمَنْتْرَنا بھُوتْوا پَولَں نَ ہَتْوا بھوجَنَں پانَنْچَ نَ کَرِشْیامَ اِتِ شَپَتھینَ بَدّھاح سَنْتو گھاتَکا اِوَ سَجِّتا اِدانِیں کیوَلَں بھَوَتو نُمَتِمْ اَپیکْشَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","یامِماں کَتھاں تْوَں نِویدِتَوانْ تاں کَسْمَیچِدَپِ ما کَتھَییتْیُکْتْوا سَہَسْرَسیناپَتِسْتَں یُوانَں وِسرِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","اَنَنْتَرَں سَہَسْرَسیناپَتِ رْدْوَو شَتَسیناپَتِی آہُوییدَمْ آدِشَتْ، یُواں راتْرَو پْرَہَرَیکاوَشِشْٹایاں سَتْیاں کَیسَرِیانَگَرَں یاتُں پَداتِسَینْیاناں دْوے شَتے گھوٹَکاروہِسَینْیاناں سَپْتَتِں شَکْتِدھارِسَینْیاناں دْوے شَتے چَ جَنانْ سَجِّتانْ کُرُتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","پَولَمْ آروہَیِتُں پھِیلِکْشادھِپَتیح سَمِیپَں نِرْوِّگھْنَں نیتُنْچَ واہَنانِ سَمُپَسْتھاپَیَتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","اَپَرَں سَ پَتْرَں لِکھِتْوا دَتَّوانْ تَلِّکھِتَمیتَتْ، ");
INSERT INTO sanurd_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","مَہامَہِمَشْرِییُکْتَپھِیلِکْشادھِپَتَیے کْلَودِیَلُشِیَسْیَ نَمَسْکارَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","یِہُودِییَلوکاح پُورْوَّمْ اینَں مانَوَں دھرِتْوا سْوَہَسْتَے رْہَنْتُمْ اُدْیَتا ایتَسْمِنَّنْتَرے سَسَینْیوہَں تَتْروپَسْتھایَ ایشَ جَنو رومِییَ اِتِ وِجْنایَ تَں رَکْشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","کِنِّمِتَّں تے تَمَپَوَدَنْتے تَجّناتُں تیشا سَبھاں تَمانایِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","تَتَسْتیشاں وْیَوَسْتھایا وِرُدّھَیا کَیاچَنَ کَتھَیا سوپَوادِتوبھَوَتْ، کِنْتُ سَ شرِنْکھَلَبَنْدھَنارْہو وا پْرانَناشارْہو بھَوَتِیدرِشَح کوپْیَپَرادھو مَیاسْیَ نَ درِشْٹَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","تَتھاپِ مَنُشْیَسْیاسْیَ وَدھارْتھَں یِہُودِییا گھاتَکااِوَ سَجِّتا ایتاں وارْتّاں شْرُتْوا تَتْکْشَناتْ تَوَ سَمِیپَمینَں پْریشِتَوانْ اَسْیاپَوادَکاںشْچَ تَوَ سَمِیپَں گَتْواپَوَدِتُمْ آجْناپَیَمْ۔ بھَوَتَح کُشَلَں بھُویاتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","سَینْیَگَنَ آجْنانُسارینَ پَولَں گرِہِیتْوا تَسْیاں رَجَنْیامْ آنْتِپاتْرِنَگَرَمْ آنَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","پَرےہَنِ تینَ سَہَ یاتُں گھوٹَکارُوڈھَسَینْیَگَنَں سْتھاپَیِتْوا پَراورِتْیَ دُرْگَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","تَتَح پَرے گھوٹَکاروہِسَینْیَگَنَح کَیسَرِیانَگَرَمْ اُپَسْتھایَ تَتْپَتْرَمْ اَدھِپَتیح کَرے سَمَرْپْیَ تَسْیَ سَمِیپے پَولَمْ اُپَسْتھاپِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","تَدادھِپَتِسْتَتْپَتْرَں پَٹھِتْوا پرِشْٹھَوانْ ایشَ کِمْپْرَدیشِییو جَنَح؟ سَ کِلِکِیاپْرَدیشِییَ ایکو جَنَ اِتِ جْناتْوا کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","تَواپَوادَکَگَنَ آگَتے تَوَ کَتھاں شْروشْیامِ۔ ہیرودْراجَگرِہے تَں سْتھاپَیِتُمْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","پَنْچَبھْیو دِنیبھْیَح پَرَں ہَنانِییَناما مَہایاجَکودھِپَتیح سَمَکْشَں پَولَسْیَ پْراتِکُولْیینَ نِویدَیِتُں تَرْتُلَّنامانَں کَنْچَنَ وَکْتارَں پْراچِینَجَناںشْچَ سَنْگِنَح کرِتْوا کَیسَرِیانَگَرَمْ آگَچّھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","تَتَح پَولے سَمانِیتے سَتِ تَرْتُلَّسْتَسْیاپَوادَکَتھاں کَتھَیِتُمْ آرَبھَتَ ہے مَہامَہِمَپھِیلِکْشَ بھَوَتو وَیَمْ اَتِنِرْوِّگھْنَں کالَں یاپَیامو بھَوَتَح پَرِنامَدَرْشِتَیا ایتَدّیشِییاناں بَہُونِ مَنْگَلانِ گھَٹِتانِ، ");
INSERT INTO sanurd_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","اِتِ ہیتو رْوَیَمَتِکرِتَجْناح سَنْتَح سَرْوَّتْرَ سَرْوَّدا بھَوَتو گُنانْ گایَمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","کِنْتُ بَہُبھِح کَتھابھِ رْبھَوَنْتَں یینَ نَ وِرَنْجَیامِ تَسْمادْ وِنَیے بھَوانْ بَنُکَمْپْیَ مَدَلْپَکَتھاں شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ایشَ مَہامارِیسْوَرُوپو ناسَرَتِییَمَتَگْراہِسَںگھاتَسْیَ مُکھْیو بھُوتْوا سَرْوَّدیشیشُ سَرْوّیشاں یِہُودِییاناں راجَدْروہاچَرَنَپْرَورِتِّں جَنَیَتِیتْیَسْمابھِ رْنِشْچِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","سَ مَنْدِرَمَپِ اَشُچِ کَرْتُّں چیشْٹِتَوانْ؛ اِتِ کارَنادْ وَیَمْ اینَں دھرِتْوا سْوَوْیَوَسْتھانُسارینَ وِچارَیِتُں پْراوَرْتّامَہِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","کِنْتُ لُشِیَح سَہَسْرَسیناپَتِراگَتْیَ بَلادْ اَسْماکَں کَریبھْیَ اینَں گرِہِیتْوا ");
INSERT INTO sanurd_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ایتَسْیاپَوادَکانْ بھَوَتَح سَمِیپَمْ آگَنْتُمْ آجْناپَیَتْ۔ وَیَں یَسْمِنْ تَمَپَوادامو بھَوَتا پَدَپَوادَکَتھایاں وِچارِتایاں سَتْیاں سَرْوَّں ورِتّانْتَں ویدِتُں شَکْشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","تَتو یِہُودِییا اَپِ سْوِیکرِتْیَ کَتھِتَوَنْتَ ایشا کَتھا پْرَمانَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","اَدھِپَتَو کَتھاں کَتھَیِتُں پَولَں پْرَتِینْگِتَں کرِتَوَتِ سَ کَتھِتَوانْ بھَوانْ بَہُونْ وَتْسَرانْ یاوَدْ ایتَدّیشَسْیَ شاسَنَں کَروتِیتِ وِجْنایَ پْرَتْیُتَّرَں داتُمْ اَکْشوبھوبھَوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","اَدْیَ کیوَلَں دْوادَشَ دِنانِ یاتانِ، اَہَمْ آرادھَناں کَرْتُّں یِرُوشالَمَنَگَرَں گَتَوانْ ایشا کَتھا بھَوَتا جْناتُں شَکْیَتے؛ ");
INSERT INTO sanurd_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","کِنْتْوِبھے ماں مَدھْییمَنْدِرَں کیناپِ سَہَ وِتَنْڈاں کُرْوَّنْتَں کُتْراپِ بھَجَنَبھَوَنے نَگَرے وا لوکانْ کُپْرَورِتِّں جَنَیَنْتُں نَ درِشْٹَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","اِدانِیں یَسْمِنْ یَسْمِنْ مامْ اَپَوَدَنْتے تَسْیَ کِمَپِ پْرَمانَں داتُں نَ شَکْنُوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","کِنْتُ بھَوِشْیَدْواکْیَگْرَنْتھے وْیَوَسْتھاگْرَنْتھے چَ یا یا کَتھا لِکھِتاسْتے تاسُ سَرْوّاسُ وِشْوَسْیَ یَنْمَتَمْ اِمے وِدھَرْمَّں جانَنْتِ تَنْمَتانُساریناہَں نِجَپِترِپُرُشانامْ اِیشْوَرَمْ آرادھَیامِیتْیَہَں بھَوَتَح سَمَکْشَمْ اَنْگِیکَرومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","دھارْمِّکانامْ اَدھارْمِّکانانْچَ پْرَمِیتَلوکانامیووتّھانَں بھَوِشْیَتِیتِ کَتھامِمے سْوِیکُرْوَّنْتِ تَتھاہَمَپِ تَسْمِنْ اِیشْوَرے پْرَتْیاشاں کَرومِ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","اِیشْوَرَسْیَ مانَوانانْچَ سَمِیپے یَتھا نِرْدوشو بھَوامِ تَدَرْتھَں سَتَتَں یَتْنَوانْ اَسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","بَہُشُ وَتْسَریشُ گَتیشُ سْوَدیشِییَلوکاناں نِمِتَّں دانِییَدْرَوْیانِ نَیویدْیانِ چَ سَمادایَ پُنَراگَمَنَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","تَتوہَں شُچِ رْبھُوتْوا لوکاناں سَماگَمَں کَلَہَں وا نَ کارِتَوانْ تَتھاپْیاشِیادیشِییاح کِیَنْتو یِہُدِییَلوکا مَدھْییمَنْدِرَں ماں دھرِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","مَموپَرِ یَدِ کاچِدَپَوادَکَتھاسْتِ تَرْہِ بھَوَتَح سَمِیپَمْ اُپَسْتھایَ تیشامیوَ ساکْشْیَدانَمْ اُچِتَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","نوچیتْ پُورْوّے مَہاسَبھاسْتھاناں لوکاناں سَنِّدھَو مَمَ دَنْڈایَمانَتْوَسَمَیے، اَہَمَدْیَ مرِتانامُتّھانے یُشْمابھِ رْوِچارِتوسْمِ، ");
INSERT INTO sanurd_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","تیشاں مَدھْیے تِشْٹھَنَّہَں یامِماں کَتھامُچَّیح سْوَرینَ کَتھِتَوانْ تَدَنْیو مَمَ کوپِ دوشولَبھْیَتَ نَ ویتِ وَرَمْ ایتے سَمُپَسْتھِتَلوکا وَدَنْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","تَدا پھِیلِکْشَ ایتاں کَتھاں شْرُتْوا تَنْمَتَسْیَ وِشیشَورِتّانْتَں وِجْناتُں وِچارَں سْتھَگِتَں کرِتْوا کَتھِتَوانْ لُشِیے سَہَسْرَسیناپَتَو سَمایاتے سَتِ یُشْماکَں وِچارَمْ اَہَں نِشْپادَیِشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","اَنَنْتَرَں بَنْدھَنَں وِنا پَولَں رَکْشِتُں تَسْیَ سیوَنایَ ساکْشاتْکَرَنایَ وا تَدِییاتْمِییَبَنْدھُجَنانْ نَ وارَیِتُنْچَ شَمَسیناپَتِمْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","اَلْپَدِناتْ پَرَں پھِیلِکْشودھِپَتِ رْدْرُشِلّانامْنا یِہُودِییَیا سْوَبھارْیَّیا سَہاگَتْیَ پَولَماہُویَ تَسْیَ مُکھاتْ کھْرِیشْٹَدھَرْمَّسْیَ ورِتّانْتَمْ اَشْرَوشِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","پَولینَ نْیایَسْیَ پَرِمِتَبھوگَسْیَ چَرَمَوِچارَسْیَ چَ کَتھایاں کَتھِتایاں سَتْیاں پھِیلِکْشَح کَمْپَمانَح سَنْ وْیاہَرَدْ اِدانِیں یاہِ، اَہَمْ اَوَکاشَں پْراپْیَ تْوامْ آہُوسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","مُکْتِپْرَپْتْیَرْتھَں پَولینَ مَہْیَں مُدْراداسْیَنْتے اِتِ پَتْیاشاں کرِتْوا سَ پُنَح پُنَسْتَماہُویَ تینَ ساکَں کَتھوپَکَتھَنَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","کِنْتُ وَتْسَرَدْوَیاتْ پَرَں پَرْکِیَپھِیشْٹَ پھالِکْشَسْیَ پَدَں پْراپْتے سَتِ پھِیلِکْشو یِہُودِییانْ سَنْتُشْٹانْ چِکِیرْشَنْ پَولَں بَدّھَں سَںسْتھاپْیَ گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","اَنَنْتَرَں پھِیشْٹو نِجَراجْیَمْ آگَتْیَ دِنَتْرَیاتْ پَرَں کَیسَرِیاتو یِرُوشالَمْنَگَرَمْ آگَمَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","تَدا مَہایاجَکو یِہُودِییاناں پْرَدھانَلوکاشْچَ تَسْیَ سَمَکْشَں پَولَمْ اَپاوَدَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","بھَوانْ تَں یِرُوشالَمَمْ آنیتُمْ آجْناپَیَتْوِتِ وِنِییَ تے تَسْمادْ اَنُگْرَہَں وانْچھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","یَتَح پَتھِمَدھْیے گوپَنینَ پَولَں ہَنْتُں تَے رْگھاتَکا نِیُکْتاح۔ پھِیشْٹَ اُتَّرَں دَتَّوانْ پَولَح کَیسَرِیایاں سْتھاسْیَتِ پُنَرَلْپَدِناتْ پَرَمْ اَہَں تَتْرَ یاسْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","تَتَسْتَسْیَ مانُشَسْیَ یَدِ کَشْچِدْ اَپَرادھَسْتِشْٹھَتِ تَرْہِ یُشْماکَں یے شَکْنُوَنْتِ تے مَیا سَہَ تَتْرَ گَتْوا تَمَپَوَدَنْتُ سَ ایتاں کَتھاں کَتھِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","دَشَدِوَسیبھْیودھِکَں وِلَمْبْیَ پھِیشْٹَسْتَسْماتْ کَیسَرِیانَگَرَں گَتْوا پَرَسْمِنْ دِوَسے وِچاراسَنَ اُپَدِشْیَ پَولَمْ آنیتُمْ آجْناپَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","پَولے سَمُپَسْتھِتے سَتِ یِرُوشالَمْنَگَرادْ آگَتا یِہُودِییَلوکاسْتَں چَتُرْدِشِ سَںویشْٹْیَ تَسْیَ وِرُدّھَں بَہُونْ مَہادوشانْ اُتّھاپِتَوَنْتَح کِنْتُ تیشاں کِمَپِ پْرَمانَں داتُں نَ شَکْنُوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","تَتَح پَولَح سْوَسْمِنْ اُتَّرَمِدَمْ اُدِتَوانْ، یِہُودِییاناں وْیَوَسْتھایا مَنْدِرَسْیَ کَیسَرَسْیَ وا پْرَتِکُولَں کِمَپِ کَرْمَّ ناہَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","کِنْتُ پھِیشْٹو یِہُودِییانْ سَنْتُشْٹانْ کَرْتُّمْ اَبھِلَشَنْ پَولَمْ اَبھاشَتَ تْوَں کِں یِرُوشالَمَں گَتْواسْمِنْ اَبھِیوگے مَمَ ساکْشادْ وِچارِتو بھَوِشْیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","تَتَح پَولَ اُتَّرَں پْروکْتَوانْ، یَتْرَ مَمَ وِچارو بھَوِتُں یوگْیَح کَیسَرَسْیَ تَتْرَ وِچاراسَنَ ایوَ سَمُپَسْتھِتوسْمِ؛ اَہَں یِہُودِییاناں کامَپِ ہانِں ناکارْشَمْ اِتِ بھَوانْ یَتھارْتھَتو وِجاناتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","کَنْچِدَپَرادھَں کِنْچَنَ وَدھارْہَں کَرْمَّ وا یَدْیَہَمْ اَکَرِشْیَں تَرْہِ پْرانَہَنَنَدَنْڈَمَپِ بھوکْتُمْ اُدْیَتوبھَوِشْیَں، کِنْتُ تے مَمَ سَمَپَوادَں کُرْوَّنْتِ سَ یَدِ کَلْپِتَماتْرو بھَوَتِ تَرْہِ تیشاں کَریشُ ماں سَمَرْپَیِتُں کَسْیاپْیَدھِکارو ناسْتِ، کَیسَرَسْیَ نِکَٹے مَمَ وِچارو بھَوَتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","تَدا پھِیشْٹو مَنْتْرِبھِح سارْدّھَں سَںمَنْتْرْیَ پَولایَ کَتھِتَوانْ، کَیسَرَسْیَ نِکَٹے کِں تَوَ وِچارو بھَوِشْیَتِ؟ کَیسَرَسْیَ سَمِیپَں گَمِشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","کِیَدِّنیبھْیَح پَرَمْ آگْرِپَّراجا بَرْنِیکِی چَ پھِیشْٹَں ساکْشاتْ کَرْتُّں کَیسَرِیانَگَرَمْ آگَتَوَنْتَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","تَدا تَو بَہُدِنانِ تَتْرَ سْتھِتَو تَتَح پھِیشْٹَسْتَں راجانَں پَولَسْیَ کَتھاں وِجْناپْیَ کَتھَیِتُمْ آرَبھَتَ پَولَنامانَمْ ایکَں بَنْدِ پھِیلِکْشو بَدّھَں سَںسْتھاپْیَ گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","یِرُوشالَمِ مَمَ سْتھِتِکالے مَہایاجَکو یِہُودِییاناں پْراچِینَلوکاشْچَ تَمْ اَپودْیَ تَمْپْرَتِ دَنْڈاجْناں پْرارْتھَیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","تَتوہَمْ اِتْیُتَّرَمْ اَوَدَں یاوَدْ اَپودِتو جَنَح سْواپَوادَکانْ ساکْشاتْ کرِتْوا سْوَسْمِنْ یوپَرادھَ آروپِتَسْتَسْیَ پْرَتْیُتَّرَں داتُں سُیوگَں نَ پْراپْنوتِ، تاوَتْکالَں کَسْیاپِ مانُشَسْیَ پْرانَناشاجْناپَنَں رومِلوکاناں رِیتِ رْنَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","تَتَسْتیشْوَتْراگَتیشُ پَرَسْمِنْ دِوَسےہَمْ اَوِلَمْبَں وِچاراسَنَ اُپَوِشْیَ تَں مانُشَمْ آنیتُمْ آجْناپَیَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","تَدَنَنْتَرَں تَسْیاپَوادَکا اُپَسْتھایَ یادرِشَمْ اَہَں چِنْتِتَوانْ تادرِشَں کَنْچَنَ مَہاپَوادَں نوتّھاپْیَ ");
INSERT INTO sanurd_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","سْویشاں مَتے تَتھا پَولو یَں سَجِیوَں وَدَتِ تَسْمِنْ یِیشُنامَنِ مرِتَجَنے چَ تَسْیَ وِرُدّھَں کَتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","تَتوہَں تادرِگْوِچارے سَںشَیانَح سَنْ کَتھِتَوانْ تْوَں یِرُوشالَمَں گَتْوا کِں تَتْرَ وِچارِتو بھَوِتُمْ اِچّھَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","تَدا پَولو مَہاراجَسْیَ نِکَٹے وِچارِتو بھَوِتُں پْرارْتھَیَتَ، تَسْمادْ یاوَتْکالَں تَں کَیسَرَسْیَ سَمِیپَں پْریشَیِتُں نَ شَکْنومِ تاوَتْکالَں تَمَتْرَ سْتھاپَیِتُمْ آدِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","تَتَ آگْرِپَّح پھِیشْٹَمْ اُکْتَوانْ، اَہَمَپِ تَسْیَ مانُشَسْیَ کَتھاں شْروتُمْ اَبھِلَشامِ۔ تَدا پھِیشْٹو وْیاہَرَتْ شْوَسْتَدِییاں کَتھاں تْوَں شْروشْیَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","پَرَسْمِنْ دِوَسے آگْرِپّو بَرْنِیکِی چَ مَہاسَماگَمَں کرِتْوا پْرَدھانَواہِنِیپَتِبھِ رْنَگَرَسْتھَپْرَدھانَلوکَیشْچَ سَہَ مِلِتْوا راجَگرِہَماگَتْیَ سَمُپَسْتھِتَو تَدا پھِیشْٹَسْیاجْنَیا پَولَ آنِیتوبھَوَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","تَدا پھِیشْٹَح کَتھِتَوانْ ہے راجَنْ آگْرِپَّ ہے اُپَسْتھِتاح سَرْوّے لوکا یِرُوشالَمْنَگَرے یِہُودِییَلوکَسَمُوہو یَسْمِنْ مانُشے مَمَ سَمِیپے نِویدَنَں کرِتْوا پْروچَّیح کَتھامِماں کَتھِتَوانْ پُنَرَلْپَکالَمَپِ تَسْیَ جِیوَنَں نوچِتَں تَمیتَں مانُشَں پَشْیَتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","کِنْتْویشَ جَنَح پْرانَناشَرْہَں کِمَپِ کَرْمَّ نَ کرِتَوانْ اِتْیَجاناں تَتھاپِ سَ مَہاراجَسْیَ سَنِّدھَو وِچارِتو بھَوِتُں پْرارْتھَیَتَ تَسْماتْ تَسْیَ سَمِیپَں تَں پْریشَیِتُں مَتِمَکَرَوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","کِنْتُ شْرِییُکْتَسْیَ سَمِیپَمْ ایتَسْمِنْ کِں لیکھَنِییَمْ اِتْیَسْیَ کَسْیَچِنْ نِرْنَیَسْیَ نَ جاتَتْوادْ ایتَسْیَ وِچارے سَتِ یَتھاہَں لیکھِتُں کِنْچَنَ نِشْچِتَں پْراپْنومِ تَدَرْتھَں یُشْماکَں سَمَکْشَں وِشیشَتو ہے آگْرِپَّراجَ بھَوَتَح سَمَکْشَمْ ایتَمْ آنَیے۔ ");
INSERT INTO sanurd_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","یَتو بَنْدِپْریشَنَسَمَیے تَسْیابھِیوگَسْیَ کِنْچِدَلیکھَنَمْ اَہَمْ اَیُکْتَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","تَتَ آگْرِپَّح پَولَمْ اَوادِیتْ، نِجاں کَتھاں کَتھَیِتُں تُبھْیَمْ اَنُمَتِ رْدِییَتے۔ تَسْماتْ پَولَح کَرَں پْرَسارْیَّ سْوَسْمِنْ اُتَّرَمْ اَوادِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ہے آگْرِپَّراجَ یَتْکارَنادَہَں یِہُودِییَیرَپَوادِتو بھَوَں تَسْیَ ورِتّانْتَمْ اَدْیَ بھَوَتَح ساکْشانْ نِویدَیِتُمَنُمَتوہَمْ اِدَں سْوِییَں پَرَمَں بھاگْیَں مَنْیے؛ ");
INSERT INTO sanurd_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","یَتو یِہُودِییَلوکاناں مَدھْیے یا یا رِیتِح سُوکْشْمَوِچاراشْچَ سَنْتِ تیشُ بھَوانْ وِجْنَتَمَح؛ اَتَایوَ پْرارْتھَیے دھَیرْیَّمَوَلَمْبْیَ مَمَ نِویدَنَں شرِنوتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","اَہَں یِرُوشالَمْنَگَرے سْوَدیشِییَلوکاناں مَدھْیے تِشْٹھَنْ آ یَووَنَکالادْ یَدْرُوپَمْ آچَرِتَوانْ تَدْ یِہُودِییَلوکاح سَرْوّے وِدَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","اَسْماکَں سَرْوّیبھْیَح شُدّھَتَمَں یَتْ پھِرُوشِییَمَتَں تَدَوَلَمْبِی بھُوتْواہَں کالَں یاپِتَوانْ یے جَنا آ بالْیَکالانْ ماں جانانْتِ تے ایتادرِشَں ساکْشْیَں یَدِ دَداتِ تَرْہِ داتُں شَکْنُوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","کِنْتُ ہے آگْرِپَّراجَ اِیشْوَروسْماکَں پُورْوَّپُرُشاناں نِکَٹے یَدْ اَنْگِیکرِتَوانْ تَسْیَ پْرَتْیاشاہیتورَہَمْ اِدانِیں وِچارَسْتھانے دَنْڈایَمانوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","تَسْیانْگِیکارَسْیَ پھَلَں پْراپْتُمْ اَسْماکَں دْوادَشَوَںشا دِوانِشَں مَہایَتْنادْ اِیشْوَرَسیوَنَں کرِتْوا یاں پْرَتْیاشاں کُرْوَّنْتِ تَسْیاح پْرَتْیاشایا ہیتورَہَں یِہُودِییَیرَپَوادِتوبھَوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","اِیشْوَرو مرِتانْ اُتّھاپَیِشْیَتِیتِ واکْیَں یُشْماکَں نِکَٹےسَمْبھَوَں کُتو بھَویتْ؟ ");
INSERT INTO sanurd_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ناسَرَتِییَیِیشو رْنامْنو وِرُدّھَں ناناپْرَکارَپْرَتِکُولاچَرَنَمْ اُچِتَمْ اِتْیَہَں مَنَسِ یَتھارْتھَں وِجْنایَ ");
INSERT INTO sanurd_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","یِرُوشالَمَنَگَرے تَدَکَرَوَں پھَلَتَح پْرَدھانَیاجَکَسْیَ نِکَٹاتْ کْشَمَتاں پْراپْیَ بَہُونْ پَوِتْرَلوکانْ کارایاں بَدّھَوانْ وِشیشَتَسْتیشاں ہَنَنَسَمَیے تیشاں وِرُدّھاں نِجاں سَمَّتِں پْرَکاشِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","وارَں وارَں بھَجَنَبھَوَنیشُ تیبھْیو دَنْڈَں پْرَدَتَّوانْ بَلاتْ تَں دھَرْمَّں نِنْدَیِتَواںشْچَ پُنَشْچَ تانْ پْرَتِ مَہاکْرودھادْ اُنْمَتَّح سَنْ وِدیشِییَنَگَرانِ یاوَتْ تانْ تاڈِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","اِتّھَں پْرَدھانَیاجَکَسْیَ سَمِیپاتْ شَکْتِمْ آجْناپَتْرَنْچَ لَبْدھْوا دَمّیشَکْنَگَرَں گَتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","تَداہَں ہے راجَنْ مارْگَمَدھْیے مَدھْیاہْنَکالے مَمَ مَدِییَسَنْگِناں لوکانانْچَ چَتَسرِشُ دِکْشُ گَگَناتْ پْرَکاشَماناں بھاسْکَرَتوپِ تیجَسْوَتِیں دِیپْتِں درِشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","تَسْمادْ اَسْماسُ سَرْوّیشُ بھُومَو پَتِتیشُ سَتْسُ ہے شَولَ ہَے شَولَ کُتو ماں تاڈَیَسِ؟ کَنْٹَکاناں مُکھے پاداہَنَنَں تَوَ دُحسادھْیَمْ اِبْرِییَبھاشَیا گَدِتَ ایتادرِشَ ایکَح شَبْدو مَیا شْرُتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","تَداہَں پرِشْٹَوانْ ہے پْرَبھو کو بھَوانْ؟ تَتَح سَ کَتھِتَوانْ یَں یِیشُں تْوَں تاڈَیَسِ سوہَں، ");
INSERT INTO sanurd_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","کِنْتُ سَمُتِّشْٹھَ تْوَں یَدْ درِشْٹَوانْ اِتَح پُنَنْچَ یَدْیَتْ تْواں دَرْشَیِشْیامِ تیشاں سَرْوّیشاں کارْیّاناں تْواں ساکْشِنَں مَمَ سیوَکَنْچَ کَرْتُّمْ دَرْشَنَمْ اَدامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","وِشیشَتو یِہُودِییَلوکیبھْیو بھِنَّجاتِیییبھْیَشْچَ تْواں مَنونِیتَں کرِتْوا تیشاں یَتھا پاپَموچَنَں بھَوَتِ ");
INSERT INTO sanurd_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","یَتھا تے مَیِ وِشْوَسْیَ پَوِتْرِیکرِتاناں مَدھْیے بھاگَں پْراپْنُوَنْتِ تَدَبھِپْرایینَ تیشاں جْنانَچَکْشُوںشِ پْرَسَنّانِ کَرْتُّں تَتھانْدھَکارادْ دِیپْتِں پْرَتِ شَیتانادھِکاراچَّ اِیشْوَرَں پْرَتِ مَتِیح پَراوَرْتَّیِتُں تیشاں سَمِیپَں تْواں پْریشْیامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ہے آگْرِپَّراجَ ایتادرِشَں سْوَرْگِییَپْرَتْیادیشَں اَگْراہْیَمْ اَکرِتْواہَں ");
INSERT INTO sanurd_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","پْرَتھَمَتو دَمّیشَکْنَگَرے تَتو یِرُوشالَمِ سَرْوَّسْمِنْ یِہُودِییَدیشے اَنْییشُ دیشیشُ چَ یےेنَ لوکا مَتِں پَراوَرْتّیَ اِیشْوَرَں پْرَتِ پَراوَرْتَّیَنْتے، مَنَحپَراوَرْتَّنَیوگْیانِ کَرْمّانِ چَ کُرْوَّنْتِ تادرِشَمْ اُپَدیشَں پْرَچارِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ایتَتْکارَنادْ یِہُودِییا مَدھْییمَنْدِرَں ماں دھرِتْوا ہَنْتُمْ اُدْیَتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","تَتھاپِ کھْرِیشْٹو دُحکھَں بھُکْتْوا سَرْوّیشاں پُورْوَّں شْمَشانادْ اُتّھایَ نِجَدیشِییاناں بھِنَّدیشِییانانْچَ سَمِیپے دِیپْتِں پْرَکاشَیِشْیَتِ ");
INSERT INTO sanurd_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","بھَوِشْیَدْوادِگَنو مُوساشْچَ بھاوِکارْیَّسْیَ یَدِدَں پْرَمانَمْ اَدَدُریتَدْ وِنانْیاں کَتھاں نَ کَتھَیِتْوا اِیشْوَرادْ اَنُگْرَہَں لَبْدھْوا مَہَتاں کْشُدْرانانْچَ سَرْوّیشاں سَمِیپے پْرَمانَں دَتّوادْیَ یاوَتْ تِشْٹھامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","تَسْیَماں کَتھاں نِشَمْیَ پھِیشْٹَ اُچَّیح سْوَرینَ کَتھِتَوانْ ہے پَولَ تْوَمْ اُنْمَتّوسِ بَہُوِدْیابھْیاسینَ تْوَں ہَتَجْنانو جاتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","سَ اُکْتَوانْ ہے مَہامَہِمَ پھِیشْٹَ ناہَمْ اُنْمَتَّح کِنْتُ سَتْیَں وِویچَنِییَنْچَ واکْیَں پْرَسْتَومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","یَسْیَ ساکْشادْ اَکْشوبھَح سَنْ کَتھاں کَتھَیامِ سَ راجا تَدْورِتّانْتَں جاناتِ تَسْیَ سَمِیپے کِمَپِ گُپْتَں نیتِ مَیا نِشْچِتَں بُدھْیَتے یَتَسْتَدْ وِجَنے نَ کرِتَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ہے آگْرِپَّراجَ بھَوانْ کِں بھَوِشْیَدْوادِگَنوکْتانِ واکْیانِ پْرَتْییتِ؟ بھَوانْ پْرَتْییتِ تَدَہَں جانامِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","تَتَ آگْرِپَّح پَولَمْ اَبھِہِتَوانْ تْوَں پْرَورِتِّں جَنَیِتْوا پْرایینَ مامَپِ کھْرِیشْٹِییَں کَروشِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","تَتَح سووادِیتْ بھَوانْ یے یے لوکاشْچَ مَمَ کَتھامْ اَدْیَ شرِنْوَنْتِ پْرایینَ اِتِ نَہِ کِنْتْویتَتْ شرِنْکھَلَبَنْدھَنَں وِنا سَرْوَّتھا تے سَرْوّے مادرِشا بھَوَنْتْوِتِیشْوَسْیَ سَمِیپے پْرارْتھَیےہَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ایتَسْیاں کَتھایاں کَتھِتایاں سَ راجا سودھِپَتِ رْبَرْنِیکِی سَبھاسْتھا لوکاشْچَ تَسْمادْ اُتّھایَ ");
INSERT INTO sanurd_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","گوپَنے پَرَسْپَرَں وِوِچْیَ کَتھِتَوَنْتَ ایشَ جَنو بَنْدھَنارْہَں پْرانَہَنَنارْہَں وا کِمَپِ کَرْمَّ ناکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","تَتَ آگْرِپَّح پھِیشْٹَمْ اَوَدَتْ، یَدْییشَ مانُشَح کَیسَرَسْیَ نِکَٹے وِچارِتو بھَوِتُں نَ پْرارْتھَیِشْیَتْ تَرْہِ مُکْتو بھَوِتُمْ اَشَکْشْیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","جَلَپَتھیناسْماکَمْ اِتولِیادیشَں پْرَتِ یاتْرایاں نِشْچِتایاں سَتْیاں تے یُولِیَنامْنو مَہاراجَسْیَ سَںگھاتانْتَرْگَتَسْیَ سیناپَتیح سَمِیپے پَولَں تَدَنْیانْ کَتِنَیَجَناںشْچَ سَمارْپَیَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","وَیَمْ آدْرامُتِّییَں پوتَمیکَمْ آرُہْیَ آشِیادیشَسْیَ تَٹَسَمِیپینَ یاتُں مَتِں کرِتْوا لَنْگَرَمْ اُتّھاپْیَ پوتَمْ اَموچَیامَ؛ ماکِدَنِیادیشَسْتھَتھِشَلَنِیکِینِواسْیارِسْتارْکھَناما کَشْچِدْ جَنوسْمابھِح سارْدّھَمْ آسِیتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","پَرَسْمِنْ دِوَسے سْمابھِح سِیدونَّگَرے پوتے لاگِتے تَتْرَ یُولِیَح سیناپَتِح پَولَں پْرَتِ سَوجَنْیَں پْرَدَرْتھْیَ سانْتْوَنارْتھَں بَنْدھُبانْدھَوانْ اُپَیاتُمْ اَنُجَجْنَو۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","تَسْماتْ پوتے موچِتے سَتِ سَمُّکھَوایوح سَمْبھَوادْ وَیَں کُپْروپَدْوِیپَسْیَ تِیرَسَمِیپینَ گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","کِلِکِیایاح پامْپھُولِیایاشْچَ سَمُدْرَسْیَ پارَں گَتْوا لُوکِیادیشانْتَرْگَتَں مُرانَگَرَمْ اُپاتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","تَتْسْتھانادْ اِتالِیادیشَں گَچّھَتِ یَح سِکَنْدَرِیانَگَرَسْیَ پوتَسْتَں تَتْرَ پْراپْیَ شَتَسیناپَتِسْتَں پوتَمْ اَسْمانْ آروہَیَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","تَتَح پَرَں بَہُونِ دِنانِ شَنَیح شَنَیح رْگَتْوا کْنِیدَپارْشْووپَسْتھْتِेح پُورْوَّں پْرَتِکُولینَ پَوَنینَ وَیَں سَلْمونْیاح سَمُّکھَمْ اُپَسْتھایَ کْرِیتْیُپَدْوِیپَسْیَ تِیرَسَمِیپینَ گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","کَشْٹینَ تَمُتِّیرْیَّ لاسییانَگَرَسْیادھَح سُنْدَرَنامَکَں کھاتَمْ اُپاتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","اِتّھَں بَہُتِتھَح کالو یاپِتَ اُپَواسَدِنَنْچاتِیتَں، تَتْکارَناتْ نَووَرْتْمَنِ بھَیَنْکَرے سَتِ پَولو وِنَیینَ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ہے مَہیچّھا اَہَں نِشْچَیَں جانامِ یاتْرایامَسْیامْ اَسْماکَں کْلیشا بَہُونامَپَچَیاشْچَ بھَوِشْیَنْتِ، تے کیوَلَں پوتَسامَگْرْیورِتِ نَہِ، کِنْتْوَسْماکَں پْرانانامَپِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","تَدا شَتَسیناپَتِح پَوैेلوکْتَواکْیَتوپِ کَرْنَدھارَسْیَ پوتَوَنِجَشْچَ واکْیَں بَہُمَںسْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","تَتْ کھاتَں شِیتَکالے واسارْہَسْتھانَں نَ تَسْمادْ اَواچِیپْرَتِیچورْدِشوح کْرِیتْیاح پھَینِیکِیَکھاتَں یاتُں یَدِ شَکْنُوَنْتَسْتَرْہِ تَتْرَ شِیتَکالَں یاپَیِتُں پْرایینَ سَرْوّے مَنْتْرَیاماسُح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","تَتَح پَرَں دَکْشِنَوایُ رْمَنْدَں وَہَتِیتِ وِلوکْیَ نِجابھِپْرایَسْیَ سِدّھیح سُیوگو بھَوَتِیتِ بُدّھوا پوتَں موچَیِتْوا کْرِیتْیُپَدْوِیپَسْیَ تِیرَسَمِیپینَ چَلِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","کِنْتْوَلْپَکْشَناتْ پَرَمیوَ اُرَکْلُدونّاما پْرَتِکُولَح پْرَچَنْڈو وایُ رْوَہَنْ پوتےلَگِیتْ ");
INSERT INTO sanurd_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","تَسْیابھِمُکھَں گَنْتُمْ پوتَسْیاشَکْتَتْوادْ وَیَں وایُنا سْوَیَں نِیتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","اَنَنْتَرَں کْلَودِینامْنَ اُپَدْوِیپَسْیَ کُولَسَمِیپینَ پوتَں گَمَیِتْوا بَہُنا کَشْٹینَ کْشُدْرَناوَمْ اَرَکْشامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","تے تامارُہْیَ رَجّچا پوتَسْیادھوبھاگَمْ اَبَدھْنَنْ تَدَنَنْتَرَں چیتْ پوتو سَیکَتے لَگَتِیتِ بھَیادْ واتَوَسَنانْیَموچَیَنْ تَتَح پوتو وایُنا چالِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","کِنْتُ کْرَمَشو وایوح پْرَبَلَتْواتْ پوتو دولایَمانوبھَوَتْ پَرَسْمِنْ دِوَسے پوتَسْتھانِ کَتِپَیانِ دْرَوْیانِ تویے نِکْشِپْتانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ترِتِییَدِوَسے وَیَں سْوَہَسْتَیح پوتَسَجَّنَدْرَوْیانِ نِکْشِپْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","تَتو بَہُدِنانِ یاوَتْ سُورْیَّنَکْشَتْرادِینِ سَماچّھَنّانِ تَتو تِیوَ واتْیاگَمادْ اَسْماکَں پْرانَرَکْشایاح کاپِ پْرَتْیاشا ناتِشْٹھَتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","بَہُدِنیشُ لوکَیرَناہارینَ یاپِتیشُ سَرْوّیشاں ساکْشَتْ پَولَسْتِشْٹھَنْ اَکَتھَیَتْ، ہے مَہیچّھاح کْرِیتْیُپَدْوِیپاتْ پوتَں نَ موچَیِتُمْ اَہَں پُورْوَّں یَدْ اَوَدَں تَدْگْرَہَنَں یُشْماکَمْ اُچِتَمْ آسِیتْ تَتھا کرِتے یُشْماکَمْ ایشا وِپَدْ ایشوپَچَیَشْچَ ناگھَٹِشْییتامْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","کِنْتُ سامْپْرَتَں یُشْمانْ وِنِییَ بْرَوِیمْیَہَں، یُویَں نَ کْشُبھْیَتَ یُشْماکَمْ ایکَسْیاپِ پْرانِنو ہانِ رْنَ بھَوِشْیَتِ، کیوَلَسْیَ پوتَسْیَ ہانِ رْبھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","یَتو یَسْییشْوَرَسْیَ لوکوہَں یَنْچاہَں پَرِچَرامِ تَدِییَ ایکو دُوتو ہْیو راتْرَو مَمانْتِکے تِشْٹھَنْ کَتھِتَوانْ، ");
INSERT INTO sanurd_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ہے پَولَ ما بھَیشِیح کَیسَرَسْیَ سَمُّکھے تْوَیوپَسْتھاتَوْیَں؛ تَوَیتانْ سَنْگِنو لوکانْ اِیشْوَرَسْتُبھْیَں دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","اَتَایوَ ہے مَہیچّھا یُویَں سْتھِرَمَنَسو بھَوَتَ مَہْیَں یا کَتھاکَتھِ ساوَشْیَں گھَٹِشْیَتے مَمَیتادرِشِی وِشْواسَ اِیشْوَرے وِدْیَتے، ");
INSERT INTO sanurd_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","کِنْتُ کَسْیَچِدْ اُپَدْوِیپَسْیوپَرِ پَتِتَوْیَمْ اَسْمابھِح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","تَتَح پَرَمْ آدْرِیاسَمُدْرے پوتَسْتَتھَیوَ دولایَمانَح سَنْ اِتَسْتَتو گَچّھَنْ چَتُرْدَشَدِوَسَسْیَ راتْرے رْدْوِتِییَپْرَہَرَسَمَیے کَسْیَچِتْ سْتھَلَسْیَ سَمِیپَمُپَتِشْٹھَتِیتِ پوتِییَلوکا اَنْوَمَنْیَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","تَتَسْتے جَلَں پَرِمایَ تَتْرَ وِںشَتِ رْوْیاما جَلانِیتِ جْناتَوَنْتَح۔ کِنْچِدُّورَں گَتْوا پُنَرَپِ جَلَں پَرِمِتَوَنْتَح۔ تَتْرَ پَنْچَدَشَ وْیاما جَلانِ درِشْٹْوا ");
INSERT INTO sanurd_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","چیتْ پاشانے لَگَتِیتِ بھَیاتْ پوتَسْیَ پَشْچادْبھاگَتَشْچَتُرو لَنْگَرانْ نِکْشِپْیَ دِواکَرَمْ اَپیکْشْیَ سَرْوّے سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","کِنْتُ پوتِییَلوکاح پوتاگْرَبھاگے لَنْگَرَنِکْشیپَں چھَلَں کرِتْوا جَلَدھَو کْشُدْرَناوَمْ اَوَروہْیَ پَلایِتُمْ اَچیشْٹَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","تَتَح پَولَح سیناپَتَیے سَینْیَگَنایَ چَ کَتھِتَوانْ، ایتے یَدِ پوتَمَدھْیے نَ تِشْٹھَنْتِ تَرْہِ یُشْماکَں رَکْشَنَں نَ شَکْیَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","تَدا سیناگَنو رَجُّونْ چھِتْوا ناوَں جَلے پَتِتُمْ اَدَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","پْرَبھاتَسَمَیے پَولَح سَرْوّانْ جَنانْ بھوجَنارْتھَں پْرارْتھْیَ وْیاہَرَتْ، اَدْیَ چَتُرْدَشَدِنانِ یاوَدْ یُویَمْ اَپیکْشَمانا اَناہاراح کالَمْ اَیاپَیَتَ کِمَپِ نابھُںگْدھَں۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","اَتو وِنَیےेہَں بھَکْشْیَں بھُجْیَتاں تَتو یُشْماکَں مَنْگَلَں بھَوِشْیَتِ، یُشْماکَں کَسْیَچِجَّنَسْیَ شِرَسَح کیشَیکوپِ نَ نَںکْشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","اِتِ وْیاہرِتْیَ پَولَں پُوپَں گرِہِیتْویشْوَرَں دھَنْیَں بھاشَمانَسْتَں بھَںکْتْوا بھوکْتُمْ آرَبْدھَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","اَنَنْتَرَں سَرْوّے چَ سُسْتھِراح سَنْتَح کھادْیانِ پَرْپْیَگرِہْلَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","اَسْماکَں پوتے شَٹْسَپْتَتْیَدھِکَشَتَدْوَیَلوکا آسَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","سَرْوّیشُ لوکیشُ یَتھیشْٹَں بھُکْتَوَتْسُ پوتَسْتھَنْ گودھُومانْ جَلَدھَو نِکْشِپْیَ تَیح پوتَسْیَ بھارو لَگھُوکرِتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","دِنے جاتےپِ سَ کو دیشَ اِتِ تَدا نَ پَرْیَّچِییَتَ؛ کِنْتُ تَتْرَ سَمَتَٹَمْ ایکَں کھاتَں درِشْٹْوا یَدِ شَکْنُمَسْتَرْہِ وَیَں تَسْیابھْیَنْتَرَں پوتَں گَمَیامَ اِتِ مَتِں کرِتْوا تے لَنْگَرانْ چھِتّوا جَلَدھَو تْیَکْتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","تَتھا کَرْنَبَنْدھَنَں موچَیِتْوا پْرَدھانَں واتَوَسَنَمْ اُتّولْیَ تِیرَسَمِیپَں گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","کِنْتُ دْوَیوح سَمُدْرَیوح سَنْگَمَسْتھانے سَیکَتوپَرِ پوتے نِکْشِپْتے گْرَبھاگے بادھِتے پَشْچادْبھاگے پْرَبَلَتَرَنْگولَگَتْ تینَ پوتو بھَگْنَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","تَسْمادْ بَنْدَیَشْچیدْ باہُبھِسْتَرَنْتَح پَلایَنْتے اِتْیاشَنْکَیا سیناگَنَسْتانْ ہَنْتُمْ اَمَنْتْرَیَتْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","کِنْتُ شَتَسیناپَتِح پَولَں رَکْشِتُں پْرَیَتْنَں کرِتْوا تانْ تَچّیشْٹایا نِوَرْتْیَ اِتْیادِشْٹَوانْ، یے باہُتَرَنَں جانَنْتِ تےگْرے پْرولَّمْپْیَ سَمُدْرے پَتِتْوا باہُبھِسْتِیرْتّوا کُولَں یانْتُ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","اَپَرَمْ اَوَشِشْٹا جَناح کاشْٹھَں پوتِییَں دْرَوْیَں وا یینَ یَتْ پْراپْیَتے تَدَوَلَمْبْیَ یانْتُ؛ اِتّھَں سَرْوّے بھُومِں پْراپْیَ پْرانَے رْجِیوِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","اِتّھَں سَرْوّیشُ رَکْشاں پْراپْتیشُ تَتْرَتْیوپَدْوِیپَسْیَ نامَ مِلِیتیتِ تے جْناتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","اَسَبھْیَلوکا یَتھیشْٹَمْ اَنُکَمْپاں کرِتْوا وَرْتَّمانَورِشْٹیح شِیتاچَّ وَہْنِں پْرَجّوالْیاسْماکَمْ آتِتھْیَمْ اَکُرْوَّنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","کِنْتُ پَولَ اِنْدھَنانِ سَںگرِہْیَ یَدا تَسْمِنْ اَگْرَو نِرَکْشِپَتْ، تَدا وَہْنیح پْرَتاپاتْ ایکَح کرِشْنَسَرْپو نِرْگَتْیَ تَسْیَ ہَسْتے دْرَشْٹَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","تےسَبھْیَلوکاسْتَسْیَ ہَسْتے سَرْپَمْ اَوَلَمْبَمانَں درِشْٹْوا پَرَسْپَرَمْ اُکْتَوَنْتَ ایشَ جَنووَشْیَں نَرَہا بھَوِشْیَتِ، یَتو یَدْیَپِ جَلَدھے رَکْشاں پْراپْتَوانْ تَتھاپِ پْرَتِپھَلَدایَکَ اینَں جِیوِتُں نَ دَداتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","کِنْتُ سَ ہَسْتَں وِدھُنْوَنْ تَں سَرْپَمْ اَگْنِمَدھْیے نِکْشِپْیَ کامَپِ پِیڈاں ناپْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","تَتو وِشَجْوالَیا ایتَسْیَ شَرِیرَں سْپھِیتَں بھَوِشْیَتِ یَدْوا ہَٹھادَیَں پْرانانْ تْیَکْشْیَتِیتِ نِشْچِتْیَ لوکا بَہُکْشَنانِ یاوَتْ تَدْ دْرَشْٹُں سْتھِتَوَنْتَح کِنْتُ تَسْیَ کَسْیاشْچِدْ وِپَدوگھَٹَناتْ تے تَدْوِپَرِیتَں وِجْنایَ بھاشِتَوَنْتَ ایشَ کَشْچِدْ دیوو بھَویتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","پُبْلِیَناما جَنَ ایکَسْتَسْیوپَدْوِیپَسْیادھِپَتِراسِیتْ تَتْرَ تَسْیَ بھُومْیادِ چَ سْتھِتَں۔ سَ جَنوسْمانْ نِجَگرِہَں نِیتْوا سَوجَنْیَں پْرَکاشْیَ دِنَتْرَیَں یاوَدْ اَسْماکَں آتِتھْیَمْ اَکَروتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","تَدا تَسْیَ پُبْلِیَسْیَ پِتا جْوَراتِسارینَ پِیڈْیَمانَح سَنْ شَیّایامْ آسِیتْ؛ تَتَح پَولَسْتَسْیَ سَمِیپَں گَتْوا پْرارْتھَناں کرِتْوا تَسْیَ گاتْرے ہَسْتَں سَمَرْپْیَ تَں سْوَسْتھَں کرِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","اِتّھَں بھُوتے تَدْوِیپَنِواسِنَ اِتَریپِ روگِلوکا آگَتْیَ نِرامَیا اَبھَوَنْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","تَسْماتّےسْماکَمْ اَتِیوَ سَتْکارَں کرِتَوَنْتَح، وِشیشَتَح پْرَسْتھانَسَمَیے پْرَیوجَنِییانِ نانَدْرَوْیانِ دَتَّوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","اِتّھَں تَتْرَ تْرِشُ ماسیشُ گَتیشُ یَسْیَ چِہْنَں دِیَسْکُورِی تادرِشَ ایکَح سِکَنْدَرِییَنَگَرَسْیَ پوتَح شِیتَکالَں یاپَیَنْ تَسْمِنْ اُپَدْوِیپے تِشْٹھَتْ تَمیوَ پوتَں وَیَمْ آرُہْیَ یاتْرامْ اَکُرْمَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","تَتَح پْرَتھَمَتَح سُراکُوسَنَگَرَمْ اُپَسْتھایَ تَتْرَ تْرِینِ دِنانِ سْتھِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","تَسْمادْ آورِتْیَ رِیگِیَنَگَرَمْ اُپَسْتھِتاح دِنَیکَسْماتْ پَرَں دَکْشِنَوَیَو سانُکُولْیے سَتِ پَرَسْمِنْ دِوَسے پَتِیَلِینَگَرَمْ اُپاتِشْٹھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","تَتوسْماسُ تَتْرَتْیَں بھْراترِگَنَں پْراپْتیشُ تے سْوَیح سارْدّھَمْ اَسْمانْ سَپْتَ دِنانِ سْتھاپَیِتُمْ اَیَتَنْتَ، اِتّھَں وَیَں رومانَگَرَمْ پْرَتْیَگَچّھامَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","تَسْماتْ تَتْرَتْیاح بھْراتَروسْماکَمْ آگَمَنَوارْتّاں شْرُتْوا آپِّیَپھَرَں تْرِشْٹاوَرْنِینْچَ یاوَدْ اَگْریسَراح سَنْتوسْمانْ ساکْشاتْ کَرْتُّمْ آگَمَنْ؛ تیشاں دَرْشَناتْ پَولَ اِیشْوَرَں دھَنْیَں وَدَنْ آشْواسَمْ آپْتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","اَسْماسُ رومانَگَرَں گَتیشُ شَتَسیناپَتِح سَرْوّانْ بَنْدِینْ پْرَدھانَسیناپَتیح سَمِیپے سَمارْپَیَتْ کِنْتُ پَولایَ سْوَرَکْشَکَپَداتِنا سَہَ پرِتھَگْ وَسْتُمْ اَنُمَتِں دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","دِنَتْرَیاتْ پَرَں پَولَسْتَدّیشَسْتھانْ پْرَدھانَیِہُودِنَ آہُوتَوانْ تَتَسْتیشُ سَمُپَسْتھِتیشُ سَ کَتھِتَوانْ، ہے بھْراترِگَنَ نِجَلوکاناں پُورْوَّپُرُشاناں وا رِیتے رْوِپَرِیتَں کِنْچَنَ کَرْمّاہَں ناکَرَوَں تَتھاپِ یِرُوشالَمَنِواسِنو لوکا ماں بَنْدِں کرِتْوا رومِلوکاناں ہَسْتیشُ سَمَرْپِتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","رومِلوکا وِچارْیَّ مَمَ پْرانَہَنَنارْہَں کِمَپِ کارَنَں نَ پْراپْیَ ماں موچَیِتُمْ اَیچّھَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","کِنْتُ یِہُودِلوکانامْ آپَتّیا مَیا کَیسَرَراجَسْیَ سَمِیپے وِچارَسْیَ پْرارْتھَنا کَرْتَّوْیا جاتا نوچیتْ نِجَدیشِییَلوکانْ پْرَتِ مَمَ کوپْیَبھِیوگو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ایتَتْکارَنادْ اَہَں یُشْمانْ دْرَشْٹُں سَںلَپِتُنْچاہُویَمْ اِسْراییلْوَشِییاناں پْرَتْیاشاہیتوہَمْ ایتینَ شُنْکھَلینَ بَدّھوبھَوَمْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","تَدا تے تَمْ اَوادِشُح، یِہُودِییَدیشادْ وَیَں تْوامَدھِ کِمَپِ پَتْرَں نَ پْراپْتا یے بھْراتَرَح سَمایاتاسْتیشاں کوپِ تَوَ کامَپِ وارْتّاں ناوَدَتْ اَبھَدْرَمَپِ ناکَتھَیَچَّ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","تَوَ مَتَں کِمِتِ وَیَں تْوَتَّح شْروتُمِچّھامَح۔ یَدْ اِدَں نَوِینَں مَتَمُتّھِتَں تَتْ سَرْوَّتْرَ سَرْوّیشاں نِکَٹے نِنْدِتَں جاتَمَ اِتِ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","تَیسْتَدَرْتھَمْ ایکَسْمِنْ دِنے نِرُوپِتے تَسْمِنْ دِنے بَہَوَ ایکَتْرَ مِلِتْوا پَولَسْیَ واسَگرِہَمْ آگَچّھَنْ تَسْماتْ پَولَ آ پْراتَحکالاتْ سَنْدھْیاکالَں یاوَنْ مُوساوْیَوَسْتھاگْرَنْتھادْ بھَوِشْیَدْوادِناں گْرَنْتھیبھْیَشْچَ یِیشوح کَتھامْ اُتّھاپْیَ اِیشْوَرَسْیَ راجْیے پْرَمانَں دَتْوا تیشاں پْرَورِتِّں جَنَیِتُں چیشْٹِتَوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","کیچِتُّ تَسْیَ کَتھاں پْرَتْیایَنْ کیچِتُّ نَ پْرَتْیایَنْ؛ ");
INSERT INTO sanurd_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ایتَتْکارَناتْ تیشاں پَرَسْپَرَمْ اَنَیکْیاتْ سَرْوّے چَلِتَوَنْتَح؛ تَتھاپِ پَولَ ایتاں کَتھامیکاں کَتھِتَوانْ پَوِتْرَ آتْما یِشَیِیَسْیَ بھَوِشْیَدْوَکْتُ رْوَدَنادْ اَسْماکَں پِترِپُرُشیبھْیَ ایتاں کَتھاں بھَدْرَں کَتھَیاماسَ، یَتھا، ");
INSERT INTO sanurd_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"اُپَگَتْیَ جَنانیتانْ تْوَں بھاشَسْوَ وَچَسْتْوِدَں۔ کَرْنَیح شْروشْیَتھَ یُویَں ہِ کِنْتُ یُویَں نَ بھوتْسْیَتھَ۔ نیتْرَے رْدْرَکْشْیَتھَ یُویَنْچَ جْناتُں یُویَں نَ شَکْشْیَتھَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","تے مانُشا یَتھا نیتْرَیح پَرِپَشْیَنْتِ نَیوَ ہِ۔ کَرْنَیح رْیَتھا نَ شرِنْوَنْتِ بُدھْیَنْتے نَ چَ مانَسَیح۔ وْیاوَرْتَّیَتْسُ چِتّانِ کالے کُتْراپِ تیشُ وَے۔ مَتَّسْتے مَنُجاح سْوَسْتھا یَتھا نَیوَ بھَوَنْتِ چَ۔ تَتھا تیشاں مَنُشْیاناں سَنْتِ سْتھُولا ہِ بُدّھَیَح۔ بَدھِرِیبھُوتَکَرْناشْچَ جاتاشْچَ مُدْرِتا درِشَح۔۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","اَتَ اِیشْوَرادْ یَتْ پَرِتْرانَں تَسْیَ وارْتّا بھِنَّدیشِییاناں سَمِیپَں پْریشِتا تَایوَ تاں گْرَہِیشْیَنْتِیتِ یُویَں جانِیتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ایتادرِشْیاں کَتھایاں کَتھِتایاں سَتْیاں یِہُودِنَح پَرَسْپَرَں بَہُوِچارَں کُرْوَّنْتو گَتَوَنْتَح۔ ");
INSERT INTO sanurd_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","اِتّھَں پَولَح سَمْپُورْنَں وَتْسَرَدْوَیَں یاوَدْ بھاٹَکِییے واسَگرِہے وَسَنْ یے لوکاسْتَسْیَ سَنِّدھِمْ آگَچّھَنْتِ تانْ سَرْوّانیوَ پَرِگرِہْلَنْ، ");
INSERT INTO sanurd_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","نِرْوِگھْنَمْ اَتِشَیَنِحکْشوبھَمْ اِیشْوَرِییَراجَتْوَسْیَ کَتھاں پْرَچارَیَنْ پْرَبھَو یِیشَو کھْرِیشْٹے کَتھاح سَمُپادِشَتْ۔ اِتِ۔۔");
INSERT INTO sanurd_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","اِیشْوَرو نِجَپُتْرَمَدھِ یَں سُسَںوادَں بھَوِشْیَدْوادِبھِ رْدھَرْمَّگْرَنْتھے پْرَتِشْرُتَوانْ تَں سُسَںوادَں پْرَچارَیِتُں پرِتھَکّرِتَ آہُوتَح پْریرِتَشْچَ پْرَبھو رْیِیشُکھْرِیشْٹَسْیَ سیوَکو یَح پَولَح ");
INSERT INTO sanurd_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","سَ رومانَگَرَسْتھانْ اِیشْوَرَپْرِیانْ آہُوتاںشْچَ پَوِتْرَلوکانْ پْرَتِ پَتْرَں لِکھَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","اَسْماکَں سَ پْرَبھُ رْیِیشُح کھْرِیشْٹَح شارِیرِکَسَمْبَنْدھینَ دایُودو وَںشودْبھَوَح ");
INSERT INTO sanurd_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","پَوِتْرَسْیاتْمَنَح سَمْبَنْدھینَ چیشْوَرَسْیَ پْرَبھاوَوانْ پُتْرَ اِتِ شْمَشاناتْ تَسْیوتّھانینَ پْرَتِپَنَّں۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","اَپَرَں ییشاں مَدھْیے یِیشُنا کھْرِیشْٹینَ یُویَمَپْیاہُوتاسْتے نْیَدیشِییَلوکاسْتَسْیَ نامْنِ وِشْوَسْیَ نِدیشَگْراہِنو یَتھا بھَوَنْتِ ");
INSERT INTO sanurd_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","تَدَبھِپْرایینَ وَیَں تَسْمادْ اَنُگْرَہَں پْریرِتَتْوَپَدَنْچَ پْراپْتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","تاتیناسْماکَمْ اِیشْوَرینَ پْرَبھُنا یِیشُکھْرِیشْٹینَ چَ یُشْمَبھْیَمْ اَنُگْرَہَح شانْتِشْچَ پْرَدِیییتاں۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","پْرَتھَمَتَح سَرْوَّسْمِنْ جَگَتِ یُشْماکَں وِشْواسَسْیَ پْرَکاشِتَتْوادْ اَہَں یُشْماکَں سَرْوّیشاں نِمِتَّں یِیشُکھْرِیشْٹَسْیَ نامَ گرِہْلَنْ اِیشْوَرَسْیَ دھَنْیَوادَں کَرومِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","اَپَرَمْ اِیشْوَرَسْیَ پْرَسادادْ بَہُکالاتْ پَرَں سامْپْرَتَں یُشْماکَں سَمِیپَں یاتُں کَتھَمَپِ یَتْ سُیوگَں پْراپْنومِ، ایتَدَرْتھَں نِرَنْتَرَں نامانْیُچّارَیَنْ نِجاسُ سَرْوَّپْرارْتھَناسُ سَرْوَّدا نِویدَیامِ، ");
INSERT INTO sanurd_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ایتَسْمِنْ یَمَہَں تَتْپُتْرِییَسُسَںوادَپْرَچارَنینَ مَنَسا پَرِچَرامِ سَ اِیشْوَرو مَمَ ساکْشِی وِدْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","یَتو یُشْماکَں مَمَ چَ وِشْواسینَ وَیَمْ اُبھَیے یَتھا شانْتِیُکْتا بھَوامَ اِتِ کارَنادْ ");
INSERT INTO sanurd_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","یُشْماکَں سْتھَیرْیَّکَرَنارْتھَں یُشْمَبھْیَں کِنْچِتْپَرَمارْتھَدانَدانایَ یُشْمانْ ساکْشاتْ کَرْتُّں مَدِییا وانْچھا۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ہے بھْراترِگَنَ بھِنَّدیشِییَلوکاناں مَدھْیے یَدْوَتْ تَدْوَدْ یُشْماکَں مَدھْییپِ یَتھا پھَلَں بھُنْجے تَدَبھِپْرایینَ مُہُرْمُہُ رْیُشْماکَں سَمِیپَں گَنْتُمْ اُدْیَتوہَں کِنْتُ یاوَدْ اَدْیَ تَسْمِنْ گَمَنے مَمَ وِگھْنو جاتَ اِتِ یُویَں یَدْ اَجْناتاسْتِشْٹھَتھَ تَدَہَمْ اُچِتَں نَ بُدھْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","اَہَں سَبھْیاسَبھْیاناں وِدْوَدَوِدْوَتانْچَ سَرْوّیشامْ رِنِی وِدْیے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","اَتَایوَ رومانِواسِناں یُشْماکَں سَمِیپےپِ یَتھاشَکْتِ سُسَںوادَں پْرَچارَیِتُمْ اَہَمْ اُدْیَتوسْمِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","یَتَح کھْرِیشْٹَسْیَ سُسَںوادو مَمَ لَجّاسْپَدَں نَہِ سَ اِیشْوَرَسْیَ شَکْتِسْوَرُوپَح سَنْ آ یِہُودِیییبھْیو نْیَجاتِییانْ یاوَتْ سَرْوَّجاتِییاناں مَدھْیے یَح کَشْچِدْ تَتْرَ وِشْوَسِتِ تَسْیَیوَ تْرانَں جَنَیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","یَتَح پْرَتْیَیَسْیَ سَمَپَرِمانَمْ اِیشْوَرَدَتَّں پُنْیَں تَتْسُسَںوادے پْرَکاشَتے۔ تَدَدھِ دھَرْمَّپُسْتَکیپِ لِکھِتَمِدَں \"پُنْیَوانْ جَنو وِشْواسینَ جِیوِشْیَتِ\"۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","اَتَایوَ یے مانَواح پاپَکَرْمَّنا سَتْیَتاں رُنْدھَنْتِ تیشاں سَرْوَّسْیَ دُراچَرَنَسْیادھَرْمَّسْیَ چَ وِرُدّھَں سْوَرْگادْ اِیشْوَرَسْیَ کوپَح پْرَکاشَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","یَتَ اِیشْوَرَمَدھِ یَدْیَدْ جْنییَں تَدْ اِیشْوَرَح سْوَیَں تانْ پْرَتِ پْرَکاشِتَوانْ تَسْماتْ تیشامْ اَگوچَرَں نَہِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","پھَلَتَسْتَسْیانَنْتَشَکْتِیشْوَرَتْوادِینْیَدرِشْیانْیَپِ سرِشْٹِکالَمْ آرَبھْیَ کَرْمَّسُ پْرَکاشَمانانِ درِشْیَنْتے تَسْماتْ تیشاں دوشَپْرَکْشالَنَسْیَ پَنْتھا ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","اَپَرَمْ اِیشْوَرَں جْناتْواپِ تے تَمْ اِیشْوَرَجْنانینَ نادْرِیَنْتَ کرِتَجْنا وا نَ جاتاح؛ تَسْماتْ تیشاں سَرْوّے تَرْکا وِپھَلِیبھُوتاح، اَپَرَنْچَ تیشاں وِویکَشُونْیانِ مَناںسِ تِمِرے مَگْنانِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","تے سْوانْ جْنانِنو جْناتْوا جْنانَہِینا اَبھَوَنْ ");
INSERT INTO sanurd_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","اَنَشْوَرَسْییشْوَرَسْیَ گَورَوَں وِہایَ نَشْوَرَمَنُشْیَپَشُپَکْشْیُروگامِپْرَبھرِتیراکرِتِوِشِشْٹَپْرَتِماسْتَیراشْرِتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","اِتّھَں تَ اِیشْوَرَسْیَ سَتْیَتاں وِہایَ مرِشامَتَمْ آشْرِتَوَنْتَح سَچِّدانَنْدَں سرِشْٹِکَرْتّارَں تْیَکْتْوا سرِشْٹَوَسْتُنَح پُوجاں سیوانْچَ کرِتَوَنْتَح؛ ");
INSERT INTO sanurd_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","اِتِ ہیتورِیشْوَرَسْتانْ کُکْرِیایاں سَمَرْپْیَ نِجَنِجَکُچِنْتابھِلاشابھْیاں سْوَں سْوَں شَرِیرَں پَرَسْپَرَمْ اَپَمانِتَں کَرْتُّمْ اَدَداتْ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","اِیشْوَرینَ تیشُ کْوَبھِلاشے سَمَرْپِتیشُ تیشاں یوشِتَح سْوابھاوِکاچَرَنَمْ اَپَہایَ وِپَرِیتَکرِتْیے پْراوَرْتَّنْتَ؛ ");
INSERT INTO sanurd_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","تَتھا پُرُشا اَپِ سْوابھاوِکَیوشِتْسَنْگَمَں وِہایَ پَرَسْپَرَں کامَکرِشانُنا دَگْدھاح سَنْتَح پُماںسَح پُںبھِح ساکَں کُکرِتْیے سَماسَجْیَ نِجَنِجَبھْرانْتیح سَمُچِتَں پھَلَمْ اَلَبھَنْتَ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","تے سْویشاں مَنَحسْوِیشْوَرایَ سْتھانَں داتُمْ اَنِچّھُکاسْتَتو ہیتورِیشْوَرَسْتانْ پْرَتِ دُشْٹَمَنَسْکَتْوَمْ اَوِہِتَکْرِیَتْوَنْچَ دَتَّوانْ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","اَتَایوَ تے سَرْوّے نْیایو وْیَبھِچارو دُشْٹَتْوَں لوبھو جِگھاںسا اِیرْشْیا وَدھو وِوادَشْچاتُرِی کُمَتِرِتْیادِبھِ رْدُشْکَرْمَّبھِح پَرِپُورْناح سَنْتَح ");
INSERT INTO sanurd_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","کَرْنیجَپا اَپَوادِنَ اِیشْوَرَدْویشَکا ہِںسَکا اَہَنْکارِنَ آتْمَشْلاگھِنَح کُکَرْمّوتْپادَکاح پِتْروراجْنالَنْگھَکا ");
INSERT INTO sanurd_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","اَوِچارَکا نِیَمَلَنْگھِنَح سْنیہَرَہِتا اَتِدْویشِنو نِرْدَیاشْچَ جاتاح۔ ");
INSERT INTO sanurd_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","یے جَنا ایتادرِشَں کَرْمَّ کُرْوَّنْتِ تَایوَ مرِتِیوگْیا اِیشْوَرَسْیَ وِچارَمِیدرِشَں جْناتْواپِ تَ ایتادرِشَں کَرْمَّ سْوَیَں کُرْوَّنْتِ کیوَلَمِتِ نَہِ کِنْتُ تادرِشَکَرْمَّکارِشُ لوکیشْوَپِ پْرِییَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ہے پَرَدُوشَکَ مَنُشْیَ یَح کَشْچَنَ تْوَں بھَوَسِ تَووتَّرَدانایَ پَنْتھا ناسْتِ یَتو یَسْماتْ کَرْمَّنَح پَرَسْتْوَیا دُوشْیَتے تَسْماتْ تْوَمَپِ دُوشْیَسے، یَتَسْتَں دُوشَیَنَّپِ تْوَں تَدْوَدْ آچَرَسِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","کِنْتْویتادرِگاچارِبھْیو یَں دَنْڈَمْ اِیشْوَرو نِشْچِنوتِ سَ یَتھارْتھَ اِتِ وَیَں جانِیمَح۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","اَتَایوَ ہے مانُشَ تْوَں یادرِگاچارِنو دُوشَیَسِ سْوَیَں یَدِ تادرِگاچَرَسِ تَرْہِ تْوَمْ اِیشْوَرَدَنْڈاتْ پَلایِتُں شَکْشْیَسِیتِ کِں بُدھْیَسے؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","اَپَرَں تَوَ مَنَسَح پَرِوَرْتَّنَں کَرْتُّمْ اِشْوَرَسْیانُگْرَہو بھَوَتِ تَنَّ بُدّھوا تْوَں کِں تَدِییانُگْرَہَکْشَماچِرَسَہِشْنُتْوَنِدھِں تُچّھِیکَروشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","تَتھا سْوانْتَحکَرَنَسْیَ کَٹھورَتْواتْ کھیدَراہِتْیاچّیشْوَرَسْیَ نْیایَّوِچارَپْرَکاشَنَسْیَ کْرودھَسْیَ چَ دِنَں یاوَتْ کِں سْوارْتھَں کوپَں سَنْچِنوشِ؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","کِنْتُ سَ ایکَیکَمَنُجایَ تَتْکَرْمّانُسارینَ پْرَتِپھَلَں داسْیَتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","وَسْتُتَسْتُ یے جَنا دھَیرْیَّں دھرِتْوا سَتْکَرْمَّ کُرْوَّنْتو مَہِما سَتْکارومَرَتْوَنْچَیتانِ مرِگَیَنْتے تیبھْیونَنْتایُ رْداسْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","اَپَرَں یے جَناح سَتْیَدھَرْمَّمْ اَگرِہِیتْوا وِپَرِیتَدھَرْمَّمْ گرِہْلَنْتِ تادرِشا وِرودھِجَناح کوپَں کْرودھَنْچَ بھوکْشْیَنْتے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","آ یِہُودِنونْیَدیشِنَح پَرْیَّنْتَں یاوَنْتَح کُکَرْمَّکارِنَح پْرانِنَح سَنْتِ تے سَرْوّے دُحکھَں یاتَنانْچَ گَمِشْیَنْتِ؛ ");
INSERT INTO sanurd_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","کِنْتُ آ یِہُودِنو بھِنَّدیشِپَرْیَّنْتا یاوَنْتَح سَتْکَرْمَّکارِنو لوکاح سَنْتِ تانْ پْرَتِ مَہِما سَتْکارَح شانْتِشْچَ بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","اِیشْوَرَسْیَ وِچارے پَکْشَپاتو ناسْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","اَلَبْدھَوْیَوَسْتھاشاسْتْرَے رْیَیح پاپانِ کرِتانِ وْیَوَسْتھاشاسْتْرالَبْدھَتْوانُرُوپَسْتیشاں وِناشو بھَوِشْیَتِ؛ کِنْتُ لَبْدھَوْیَوَسْتھاشاسْتْرا یے پاپانْیَکُرْوَّنْ وْیَوَسْتھانُسارادیوَ تیشاں وِچارو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","وْیَوَسْتھاشْروتارَ اِیشْوَرَسْیَ سَمِیپے نِشْپاپا بھَوِشْیَنْتِیتِ نَہِ کِنْتُ وْیَوَسْتھاچارِنَ ایوَ سَپُنْیا بھَوِشْیَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","یَتو لَبْدھَوْیَوَسْتھاشاسْتْرا بھِنَّدیشِییَلوکا یَدِ سْوَبھاوَتو وْیَوَسْتھانُرُوپانْ آچارانْ کُرْوَّنْتِ تَرْہْیَلَبْدھَشاسْتْراح سَنْتوپِ تے سْویشاں وْیَوَسْتھاشاسْتْرَمِوَ سْوَیَمیوَ بھَوَنْتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","تیشاں مَنَسِ ساکْشِسْوَرُوپے سَتِ تیشاں وِتَرْکیشُ چَ کَدا تانْ دوشِنَح کَدا وا نِرْدوشانْ کرِتَوَتْسُ تے سْوانْتَرْلِکھِتَسْیَ وْیَوَسْتھاشاسْتْرَسْیَ پْرَمانَں سْوَیَمیوَ دَدَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","یَسْمِنْ دِنے مَیا پْرَکاشِتَسْیَ سُسَںوادَسْیانُسارادْ اِیشْوَرو یِیشُکھْرِیشْٹینَ مانُشانامْ اَنْتَحکَرَناناں گُوڈھابھِپْرایانْ دھرِتْوا وِچارَیِشْیَتِ تَسْمِنْ وِچارَدِنے تَتْ پْرَکاشِشْیَتے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","پَشْیَ تْوَں سْوَیَں یِہُودِیتِ وِکھْیاتو وْیَوَسْتھوپَرِ وِشْواسَں کَروشِ، ");
INSERT INTO sanurd_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","اِیشْوَرَمُدِّشْیَ سْوَں شْلاگھَسے، تَتھا وْیَوَسْتھَیا شِکْشِتو بھُوتْوا تَسْیابھِمَتَں جاناسِ، سَرْوّاساں کَتھاناں سارَں وِوِںکْشے، ");
INSERT INTO sanurd_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","اَپَرَں جْنانَسْیَ سَتْیَتایاشْچاکَرَسْوَرُوپَں شاسْتْرَں مَمَ سَمِیپے وِدْیَتَ اَتو نْدھَلوکاناں مارْگَدَرْشَیِتا ");
INSERT INTO sanurd_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","تِمِرَسْتھِتَلوکاناں مَدھْیے دِیپْتِسْوَرُوپوجْنانَلوکیبھْیو جْنانَداتا شِشُوناں شِکْشَیِتاہَمیویتِ مَنْیَسے۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","پَرانْ شِکْشَیَنْ سْوَیَں سْوَں کِں نَ شِکْشَیَسِ؟ وَسْتُتَشْچَورْیَّنِشیدھَوْیَوَسْتھاں پْرَچارَیَنْ تْوَں کِں سْوَیَمیوَ چورَیَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","تَتھا پَرَدارَگَمَنَں پْرَتِشیدھَنْ سْوَیَں کِں پَرَدارانْ گَچّھَسِ؟ تَتھا تْوَں سْوَیَں پْرَتِمادْویشِی سَنْ کِں مَنْدِرَسْیَ دْرَوْیانِ ہَرَسِ؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","یَسْتْوَں وْیَوَسْتھاں شْلاگھَسے سَ تْوَں کِں وْیَوَسْتھامْ اَوَمَتْیَ نیشْوَرَں سَمَّنْیَسے؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","شاسْتْرے یَتھا لِکھَتِ \"بھِنَّدیشِناں سَمِیپے یُشْماکَں دوشادْ اِیشْوَرَسْیَ نامْنو نِنْدا بھَوَتِ۔ \" ");
INSERT INTO sanurd_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","یَدِ وْیَوَسْتھاں پالَیَسِ تَرْہِ تَوَ تْوَکْچھیدَکْرِیا سَپھَلا بھَوَتِ؛ یَتِ وْیَوَسْتھاں لَنْگھَسے تَرْہِ تَوَ تْوَکْچھیدوتْوَکْچھیدو بھَوِشْیَتِ۔ ");
INSERT INTO sanurd_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","یَتو وْیَوَسْتھاشاسْتْرادِشْٹَدھَرْمَّکَرْمّاچارِی پُمانْ اَتْوَکْچھیدِی سَنَّپِ کِں تْوَکْچھیدِناں مَدھْیے نَ گَنَیِشْیَتے؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","کِنْتُ لَبْدھَشاسْتْرَشْچھِنَّتْوَکْ چَ تْوَں یَدِ وْیَوَسْتھالَنْگھَنَں کَروشِ تَرْہِ وْیَوَسْتھاپالَکاح سْوابھاوِکاچّھِنَّتْوَچو لوکاسْتْواں کِں نَ دُوشَیِشْیَنْتِ؟ ");
INSERT INTO sanurd_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","تَسْمادْ یو باہْیے یِہُودِی سَ یِہُودِی نَہِ تَتھانْگَسْیَ یَسْتْوَکْچھیدَح سَ تْوَکْچھیدو نَہِ؛ ");
INSERT INTO sanurd_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","کِنْتُ یو جَنَ آنْتَرِکو یِہُودِی سَ ایوَ یِہُودِی اَپَرَنْچَ کیوَلَلِکھِتَیا وْیَوَسْتھَیا نَ کِنْتُ مانَسِکو یَسْتْوَکْچھیدو یَسْیَ چَ پْرَشَںسا مَنُشْییبھْیو نَ بھُوتْوا اِیشْوَرادْ بھَوَتِ سَ ایوَ تْوَکْچھیدَح۔ ");
INSERT INTO sanurd_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","اَپَرَنْچَ یِہُودِنَ