﻿USE sofia;
DROP TABLE IF EXISTS sofia.santib_vpl;
CREATE TABLE santib_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES santib_vpl WRITE;
INSERT INTO santib_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ཨིབྲཱཧཱིམཿ སནྟཱནོ དཱཡཱུད྄ ཏསྱ སནྟཱནོ ཡཱིཤུཁྲཱིཥྚསྟསྱ པཱུཪྻྭཔུརུཥཝཾཤཤྲེཎཱི། ");
INSERT INTO santib_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ཨིབྲཱཧཱིམཿ པུཏྲ ཨིསྷཱཀ྄ ཏསྱ པུཏྲོ ཡཱཀཱུབ྄ ཏསྱ པུཏྲོ ཡིཧཱུདཱསྟསྱ བྷྲཱཏརཤྩ། ");
INSERT INTO santib_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ཏསྨཱད྄ ཡིཧཱུདཱཏསྟཱམརོ གརྦྷེ པེརསྶེརཧཽ ཛཛྙཱཏེ, ཏསྱ པེརསཿ པུཏྲོ ཧིཥྲོཎ྄ ཏསྱ པུཏྲོ ྅རཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ཏསྱ པུཏྲོ ྅མྨཱིནཱདབ྄ ཏསྱ པུཏྲོ ནཧཤོན྄ ཏསྱ པུཏྲཿ སལྨོན྄། ");
INSERT INTO santib_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ཏསྨཱད྄ རཱཧབོ གརྦྷེ བོཡམ྄ ཛཛྙེ, ཏསྨཱད྄ རཱུཏོ གརྦྷེ ཨོབེད྄ ཛཛྙེ, ཏསྱ པུཏྲོ ཡིཤཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ཏསྱ པུཏྲོ དཱཡཱུད྄ རཱཛཿ ཏསྨཱད྄ མྲྀཏོརིཡསྱ ཛཱཡཱཡཱཾ སུལེམཱན྄ ཛཛྙེ། ");
INSERT INTO santib_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ཏསྱ པུཏྲོ རིཧབིཡཱམ྄, ཏསྱ པུཏྲོ྅བིཡཿ, ཏསྱ པུཏྲ ཨཱསཱ:། ");
INSERT INTO santib_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ཏསྱ སུཏོ ཡིཧོཤཱཕཊ྄ ཏསྱ སུཏོ ཡིཧོརཱམ ཏསྱ སུཏ ཨུཥིཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ཏསྱ སུཏོ ཡོཐམ྄ ཏསྱ སུཏ ཨཱཧམ྄ ཏསྱ སུཏོ ཧིཥྐིཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ཏསྱ སུཏོ མིནཤིཿ, ཏསྱ སུཏ ཨཱམོན྄ ཏསྱ སུཏོ ཡོཤིཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","བཱབིལྣགརེ པྲཝསནཱཏ྄ པཱུཪྻྭཾ ས ཡོཤིཡོ ཡིཁནིཡཾ ཏསྱ བྷྲཱཏྲྀཾཤྩ ཛནཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ཏཏོ བཱབིལི པྲཝསནཀཱལེ ཡིཁནིཡཿ ཤལྟཱིཡེལཾ ཛནཡཱམཱས, ཏསྱ སུཏཿ སིརུབྦཱཝིལ྄། ");
INSERT INTO santib_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ཏསྱ སུཏོ ྅བོཧུད྄ ཏསྱ སུཏ ཨིལཱིཡཱཀཱིམ྄ ཏསྱ སུཏོ྅སོར྄། ");
INSERT INTO santib_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ཨསོརཿ སུཏཿ སཱདོཀ྄ ཏསྱ སུཏ ཨཱཁཱིམ྄ ཏསྱ སུཏ ཨིལཱིཧཱུད྄། ");
INSERT INTO santib_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ཏསྱ སུཏ ཨིལིཡཱསར྄ ཏསྱ སུཏོ མཏྟན྄། ");
INSERT INTO santib_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ཏསྱ སུཏོ ཡཱཀཱུབ྄ ཏསྱ སུཏོ ཡཱུཥཕ྄ ཏསྱ ཛཱཡཱ མརིཡམ྄; ཏསྱ གརྦྷེ ཡཱིཤུརཛནི, ཏམེཝ ཁྲཱིཥྚམ྄ (ཨརྠཱད྄ ཨབྷིཥིཀྟཾ) ཝདནྟི། ");
INSERT INTO santib_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ཨིཏྠམ྄ ཨིབྲཱཧཱིམོ དཱཡཱུདཾ ཡཱཝཏ྄ སཱཀལྱེན ཙཏུརྡཤཔུརུཥཱཿ; ཨཱ དཱཡཱུདཿ ཀཱལཱད྄ བཱབིལི པྲཝསནཀཱལཾ ཡཱཝཏ྄ ཙཏུརྡཤཔུརུཥཱ བྷཝནྟི། བཱབིལི པྲཝཱསནཀཱལཱཏ྄ ཁྲཱིཥྚསྱ ཀཱལཾ ཡཱཝཏ྄ ཙཏུརྡཤཔུརུཥཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ཡཱིཤུཁྲཱིཥྚསྱ ཛནྨ ཀཐྠཏེ། མརིཡམ྄ ནཱམིཀཱ ཀནྱཱ ཡཱུཥཕེ ཝཱགྡཏྟཱསཱིཏ྄, ཏདཱ ཏཡོཿ སངྒམཱཏ྄ པྲཱཀ྄ སཱ ཀནྱཱ  པཝིཏྲེཎཱཏྨནཱ གརྦྷཝཏཱི བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ཏཏྲ ཏསྱཱཿ པཏི ཪྻཱུཥཕ྄ སཽཛནྱཱཏ྄ ཏསྱཱཿ ཀལངྒཾ པྲཀཱཤཡིཏུམ྄ ཨནིཙྪན྄ གོཔནེནེ ཏཱཾ པཱརིཏྱཀྟུཾ མནཤྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ས ཏཐཻཝ བྷཱཝཡཏི, ཏདཱནཱིཾ པརམེཤྭརསྱ དཱུཏཿ སྭཔྣེ ཏཾ དརྴནཾ དཏྟྭཱ ཝྱཱཛཧཱར, ཧེ དཱཡཱུདཿ སནྟཱན ཡཱུཥཕ྄ ཏྭཾ ནིཛཱཾ ཛཱཡཱཾ མརིཡམམ྄ ཨཱདཱཏུཾ མཱ བྷཻཥཱིཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ཡཏསྟསྱཱ གརྦྷཿ པཝིཏྲཱདཱཏྨནོ྅བྷཝཏ྄, སཱ ཙ པུཏྲཾ པྲསཝིཥྱཏེ, ཏདཱ ཏྭཾ ཏསྱ ནཱམ ཡཱིཤུམ྄ (ཨརྠཱཏ྄ ཏྲཱཏཱརཾ) ཀརཱིཥྱསེ, ཡསྨཱཏ྄ ས ནིཛམནུཛཱན྄ ཏེཥཱཾ ཀལུཥེབྷྱ ཨུདྡྷརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ཨིཏྠཾ སཏི, པཤྱ གརྦྷཝཏཱི ཀནྱཱ ཏནཡཾ པྲསཝིཥྱཏེ། ཨིམྨཱནཱུཡེལ྄ ཏདཱིཡཉྩ ནཱམདྷེཡཾ བྷཝིཥྱཏི༎ ཨིམྨཱནཱུཡེལ྄ ཨསྨཱཀཾ སངྒཱིཤྭརཨིཏྱརྠཿ། ");
INSERT INTO santib_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ཨིཏི ཡད྄ ཝཙནཾ པུཪྻྭཾ བྷཝིཥྱདྭཀྟྲཱ ཨཱིཤྭརཿ ཀཐཱཡཱམཱས, ཏཏ྄ ཏདཱནཱིཾ སིདྡྷམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ཨནནྟརཾ ཡཱུཥཕ྄ ནིདྲཱཏོ ཛཱགརིཏ ཨུཏྠཱཡ པརམེཤྭརཱིཡདཱུཏསྱ ནིདེཤཱནུསཱརེཎ ནིཛཱཾ ཛཱཡཱཾ ཛགྲཱཧ, ");
INSERT INTO santib_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ཀིནྟུ ཡཱཝཏ྄ སཱ ནིཛཾ པྲཐམསུཏཾ ཨ སུཥུཝེ, ཏཱཝཏ྄ ཏཱཾ ནོཔཱགཙྪཏ྄, ཏཏཿ སུཏསྱ ནཱམ ཡཱིཤུཾ ཙཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ཨནནྟརཾ ཧེརོད྄ སཾཛྙཀེ རཱཛྙི རཱཛྱཾ ཤཱསཏི ཡིཧཱུདཱིཡདེཤསྱ བཻཏླེཧམི ནགརེ ཡཱིཤཽ ཛཱཏཝཏི ཙ, ཀཏིཔཡཱ ཛྱོཏིཪྻྭུདཿ པཱུཪྻྭསྱཱ དིཤོ ཡིརཱུཤཱལམྣགརཾ སམེཏྱ ཀཐཡམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ཡོ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ ཛཱཏཝཱན྄, ས ཀུཏྲཱསྟེ? ཝཡཾ པཱུཪྻྭསྱཱཾ དིཤི ཏིཥྛནྟསྟདཱིཡཱཾ ཏཱརཀཱམ྄ ཨཔཤྱཱམ ཏསྨཱཏ྄ ཏཾ པྲཎནྟུམ྄ ཨाགམཱམ། ");
INSERT INTO santib_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ཏདཱ ཧེརོད྄ རཱཛཱ ཀཐཱམེཏཱཾ ནིཤམྱ ཡིརཱུཤཱལམྣགརསྠིཏཻཿ སཪྻྭམཱནཝཻཿ སཱརྡྡྷམ྄ ཨུདྭིཛྱ ");
INSERT INTO santib_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","སཪྻྭཱན྄ པྲདྷཱནཡཱཛཀཱན྄ ཨདྷྱཱཔཀཱཾཤྩ སམཱཧཱུཡཱནཱིཡ པཔྲཙྪ, ཁྲཱིཥྚཿ ཀུཏྲ ཛནིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ཏདཱ ཏེ ཀཐཡཱམཱསུཿ, ཡིཧཱུདཱིཡདེཤསྱ བཻཏླེཧམི ནགརེ, ཡཏོ བྷཝིཥྱདྭཱདིནཱ ཨིཏྠཾ ལིཁིཏམཱསྟེ, ");
INSERT INTO santib_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","སཪྻྭཱབྷྱོ རཱཛདྷཱནཱིབྷྱོ ཡིཧཱུདཱིཡསྱ ནཱིཝྲྀཏཿ། ཧེ ཡཱིཧཱུདཱིཡདེཤསྱེ བཻཏླེཧམ྄ ཏྭཾ ན ཙཱཝརཱ། ཨིསྲཱཡེལཱིཡལོཀཱན྄ མེ ཡཏོ ཡཿ པཱལཡིཥྱཏི། ཏཱདྲྀགེཀོ མཧཱརཱཛསྟྭནྨདྷྱ ཨུདྦྷཝིཥྱཏཱི༎ ");
INSERT INTO santib_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ཏདཱནཱིཾ ཧེརོད྄ རཱཛཱ ཏཱན྄ ཛྱོཏིཪྻྭིདོ གོཔནམ྄ ཨཱཧཱུཡ སཱ ཏཱརཀཱ ཀདཱ དྲྀཥྚཱབྷཝཏ྄ , ཏད྄ ཝིནིཤྩཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ཨཔརཾ ཏཱན྄ བཻཏླེཧམཾ པྲཧཱིཏྱ གདིཏཝཱན྄, ཡཱུཡཾ ཡཱཏ, ཡཏྣཱཏ྄ ཏཾ ཤིཤུམ྄ ཨནྭིཥྱ ཏདུདྡེཤེ པྲཱཔྟེ མཧྱཾ ཝཱརྟྟཱཾ དཱསྱཐ, ཏཏོ མཡཱཔི གཏྭཱ ས པྲཎཾསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ཏདཱནཱིཾ རཱཛྙ ཨེཏཱདྲྀཤཱིམ྄ ཨཱཛྙཱཾ པྲཱཔྱ ཏེ པྲཏསྠིརེ, ཏཏཿ པཱུཪྻྭརྶྱཱཾ དིཤི སྠིཏཻསྟཻ ཪྻཱ ཏཱརཀཱ དྲྀཥྚཱ སཱ ཏཱརཀཱ ཏེཥཱམགྲེ གཏྭཱ ཡཏྲ སྠཱནེ ཤིཤཱུརཱསྟེ, ཏསྱ སྠཱནསྱོཔརི སྠགིཏཱ ཏསྱཽ། ");
INSERT INTO santib_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ཏད྄ དྲྀཥྚྭཱ ཏེ མཧཱནནྡིཏཱ བབྷཱུཝུཿ, ");
INSERT INTO santib_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ཏཏོ གེཧམདྷྱ པྲཝིཤྱ ཏསྱ མཱཏྲཱ མརིཡམཱ སཱདྡྷཾ ཏཾ ཤིཤུཾ ནིརཱིཀྵཡ དཎྜཝད྄ བྷཱུཏྭཱ པྲཎེམུཿ, ཨཔརཾ སྭེཥཱཾ གྷནསམྤཏྟིཾ མོཙཡིཏྭཱ སུཝརྞཾ ཀུནྡུརུཾ གནྡྷརམཉྩ ཏསྨཻ དརྴནཱིཡཾ དཏྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","པཤྩཱད྄ ཧེརོད྄ རཱཛསྱ སམཱིཔཾ པུནརཔི གནྟུཾ སྭཔྣ ཨཱིཤྭརེཎ ནིཥིདྡྷཱཿ སནྟོ ྅ནྱེན པཐཱ ཏེ ནིཛདེཤཾ པྲཏི པྲཏསྠིརེ། ");
INSERT INTO santib_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ཨནནྟརཾ ཏེཥུ གཏཝཏྨུ པརམེཤྭརསྱ དཱུཏོ ཡཱུཥཕེ སྭཔྣེ དརྴནཾ དཏྭཱ ཛགཱད, ཏྭམ྄ ཨུཏྠཱཡ ཤིཤུཾ ཏནྨཱཏརཉྩ གྲྀཧཱིཏྭཱ མིསརྡེཤཾ པལཱཡསྭ, ཨཔརཾ ཡཱཝདཧཾ ཏུབྷྱཾ ཝཱརྟྟཱཾ ན ཀཐཡིཥྱཱམི, ཏཱཝཏ྄ ཏཏྲཻཝ ནིཝས, ཡཏོ རཱཛཱ ཧེརོད྄ ཤིཤུཾ ནཱཤཡིཏུཾ མྲྀགཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ཏདཱནཱིཾ ཡཱུཥཕ྄ ཨུཏྠཱཡ རཛནྱཱཾ ཤིཤུཾ ཏནྨཱཏརཉྩ གྲྀཧཱིཏྭཱ མིསརྡེཤཾ པྲཏི པྲཏསྠེ, ");
INSERT INTO santib_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","གཏྭཱ ཙ ཧེརོདོ ནྲྀཔཏེ རྨརཎཔཪྻྱནྟཾ ཏཏྲ དེཤེ ནྱུཝཱས, ཏེན མིསརྡེཤཱདཧཾ པུཏྲཾ སྭཀཱིཡཾ སམུཔཱཧཱུཡམ྄། ཡདེཏདྭཙནམ྄ ཨཱིཤྭརེཎ བྷཝིཥྱདྭཱདིནཱ ཀཐིཏཾ ཏཏ྄ སཕལམབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ཨནནྟརཾ ཧེརོད྄ ཛྱོཏིཪྻིདྦྷིརཱཏྨཱནཾ པྲཝཉྩིཏཾ ཝིཛྙཱཡ བྷྲྀཤཾ ཙུཀོཔ; ཨཔརཾ ཛྱོཏིཪྻྭིདྦྷྱསྟེན ཝིནིཤྩིཏཾ ཡད྄ དིནཾ ཏདྡིནཱད྄ གཎཡིཏྭཱ དྭིཏཱིཡཝཏྶརཾ པྲཝིཥྚཱ ཡཱཝནྟོ བཱལཀཱ ཨསྨིན྄ བཻཏླེཧམྣགརེ ཏཏྶཱིམམདྷྱེ ཙཱསན྄, ལོཀཱན྄ པྲཧིཏྱ ཏཱན྄ སཪྻྭཱན྄ གྷཱཏཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ཨཏཿ ཨནེཀསྱ ཝིལཱཔསྱ ནིནཱད: ཀྲནྡནསྱ ཙ། ཤོཀེན ཀྲྀཏཤབྡཤྩ རཱམཱཡཱཾ སཾནིཤམྱཏེ། སྭབཱལགཎཧེཏོཪྻཻ རཱཧེལ྄ ནཱརཱི ཏུ རོདིནཱི། ན མནྱཏེ པྲབོདྷནྟུ ཡཏསྟེ ནཻཝ མནྟི ཧི༎ ");
INSERT INTO santib_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ཡདེཏད྄ ཝཙནཾ ཡིརཱིམིཡནཱམཀབྷཝིཥྱདྭཱདིནཱ ཀཐིཏཾ ཏཏ྄ ཏདཱནཱིཾ སཕལམ྄ ཨབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ཏདནནྟརཾ ཧེརེདི རཱཛནི མྲྀཏེ པརམེཤྭརསྱ དཱུཏོ མིསརྡེཤེ སྭཔྣེ དརྴནཾ དཏྟྭཱ ཡཱུཥཕེ ཀཐིཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ཏྭམ྄ ཨུཏྠཱཡ ཤིཤུཾ ཏནྨཱཏརཉྩ གྲྀཧཱིཏྭཱ པུནརཔཱིསྲཱཡེལོ དེཤཾ ཡཱཧཱི, ཡེ ཛནཱཿ ཤིཤུཾ ནཱཤཡིཏུམ྄ ཨམྲྀགཡནྟ, ཏེ མྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ཏདཱནཱིཾ ས ཨུཏྠཱཡ ཤིཤུཾ ཏནྨཱཏརཉྩ གྲྀཧླན྄ ཨིསྲཱཡེལྡེཤམ྄ ཨཱཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ཀིནྟུ ཡིཧཱུདཱིཡདེཤེ ཨརྑིལཱཡནཱམ རཱཛཀུམཱརོ ནིཛཔིཏུ རྷེརོདཿ པདཾ པྲཱཔྱ རཱཛཏྭཾ ཀརོཏཱིཏི ནིཤམྱ ཏཏ྄ སྠཱནཾ ཡཱཏུཾ ཤངྐིཏཝཱན྄, པཤྩཱཏ྄ སྭཔྣ ཨཱིཤྭརཱཏ྄ པྲབོདྷཾ པྲཱཔྱ གཱལཱིལྡེཤསྱ པྲདེཤཻཀཾ པྲསྠཱཡ ནཱསརནྣཱམ ནགརཾ གཏྭཱ ཏཏྲ ནྱུཥིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ཏེན ཏཾ ནཱསརཏཱིཡཾ ཀཐཡིཥྱནྟི, ཡདེཏདྭཱཀྱཾ བྷཝིཥྱདྭཱདིབྷིརུཀྟྟཾ ཏཏ྄ སཕལམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ཏདཱནོཾ ཡོཧྣྣཱམཱ མཛྫཡིཏཱ ཡིཧཱུདཱིཡདེཤསྱ པྲཱནྟརམ྄ ཨུཔསྠཱཡ པྲཙཱརཡན྄ ཀཐཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","མནཱཾསི པརཱཝརྟྟཡཏ, སྭརྒཱིཡརཱཛཏྭཾ སམཱིཔམཱགཏམ྄། ");
INSERT INTO santib_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","པརམེཤསྱ པནྠཱནཾ པརིཥྐུརུཏ སཪྻྭཏཿ། ཏསྱ རཱཛཔཐཱཾཤྩཻཝ སམཱིཀུརུཏ སཪྻྭཐཱ། ཨིཏྱེཏཏ྄ པྲཱནྟརེ ཝཱཀྱཾ ཝདཏཿ ཀསྱཙིད྄ རཝཿ༎ ");
INSERT INTO santib_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ཨེཏདྭཙནཾ ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཱ ཡོཧནམུདྡིཤྱ བྷཱཥིཏམ྄། ཡོཧནོ ཝསནཾ མཧཱངྒརོམཛཾ ཏསྱ ཀཊཽ ཙརྨྨཀཊིབནྡྷནཾ; ས ཙ ཤཱུཀཀཱིཊཱན྄ མདྷུ ཙ བྷུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ཏདཱནཱིཾ ཡིརཱུཤཱལམྣགརནིཝཱསིནཿ སཪྻྭེ ཡིཧཱུདིདེཤཱིཡཱ ཡརྡྡནྟཊིནྱཱ ཨུབྷཡཏཊསྠཱཤྩ མཱནཝཱ བཧིརཱགཏྱ ཏསྱ སམཱིཔེ ");
INSERT INTO santib_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","སྭཱིཡཾ སྭཱིཡཾ དུརིཏམ྄ ཨངྒཱིཀྲྀཏྱ ཏསྱཱཾ ཡརྡྡནི ཏེན མཛྫིཏཱ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ཨཔརཾ བཧཱུན྄ ཕིརཱུཤིནཿ སིདཱུཀིནཤྩ མནུཛཱན྄ མཾཀྟུཾ སྭསམཱིཔམ྄ ཨཱགཙྪྟོ ཝིལོཀྱ ས ཏཱན྄ ཨབྷིདདྷཽ, རེ རེ བྷུཛགཝཾཤཱ ཨཱགཱམཱིནཿ ཀོཔཱཏ྄ པལཱཡིཏུཾ ཡུཥྨཱན྄ ཀཤྩེཏིཏཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","མནཿཔརཱཝརྟྟནསྱ སམུཙིཏཾ ཕལཾ ཕལཏ། ");
INSERT INTO santib_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ཀིནྟྭསྨཱཀཾ ཏཱཏ ཨིབྲཱཧཱིམ྄ ཨསྟཱིཏི སྭེཥུ མནཿསུ ཙཱིནྟཡནྟོ མཱ ཝྱཱཧརཏ། ཡཏོ ཡུཥྨཱན྄ ཨཧཾ ཝདཱམི, ཨཱིཤྭར ཨེཏེབྷྱཿ པཱཥཱཎེབྷྱ ཨིབྲཱཧཱིམཿ སནྟཱནཱན྄ ཨུཏྤཱདཡིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ཨཔརཾ པཱདཔཱནཱཾ མཱུལེ ཀུཋཱར ཨིདཱནཱིམཔི ལགན྄ ཨཱསྟེ, ཏསྨཱད྄ ཡསྨིན྄ པཱདཔེ ཨུཏྟམཾ ཕལཾ ན བྷཝཏི, ས ཀྲྀཏྟོ མདྷྱེ྅གྣིཾ ནིཀྵེཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ཨཔརམ྄ ཨཧཾ མནཿཔརཱཝརྟྟནསཱུཙཀེན མཛྫནེན ཡུཥྨཱན྄ མཛྫཡཱམཱིཏི སཏྱཾ, ཀིནྟུ མམ པཤྩཱད྄ ཡ ཨཱགཙྪཏི, ས མཏྟོཔི མཧཱན྄, ཨཧཾ ཏདཱིཡོཔཱནཧཽ ཝོཌྷུམཔི ནཧི ཡོགྱོསྨི, ས ཡུཥྨཱན྄ ཝཧྣིརཱུཔེ པཝིཏྲ ཨཱཏྨནི སཾམཛྫཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ཏསྱ ཀཱརེ སཱུརྤ ཨཱསྟེ, ས སྭཱིཡཤསྱཱནི སམྱཀ྄ པྲསྥོཊྱ ནིཛཱན྄ སཀལགོདྷཱུམཱན྄ སཾགྲྀཧྱ བྷཱཎྜཱགཱརེ སྠཱཔཡིཥྱཏི, ཀིཾནྟུ སཪྻྭཱཎི ཝུཥཱཎྱནིཪྻྭཱཎཝཧྣིནཱ དཱཧཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ཨནནྟརཾ ཡཱིཤུ ཪྻོཧནཱ མཛྫིཏོ བྷཝིཏུཾ གཱལཱིལྤྲདེཤཱད྄ ཡརྡྡནི ཏསྱ སམཱིཔམ྄ ཨཱཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ཀིནྟུ ཡོཧན྄ ཏཾ ནིཥིདྷྱ བབྷཱཥེ, ཏྭཾ ཀིཾ མམ སམཱིཔམ྄ ཨཱགཙྪསི? ཝརཾ ཏྭཡཱ མཛྫནཾ མམ པྲཡོཛནམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ཏདཱནཱིཾ ཡཱིཤུཿ པྲཏྱཝོཙཏ྄; ཨཱིདཱནཱིམ྄ ཨནུམནྱསྭ, ཡཏ ཨིཏྠཾ སཪྻྭདྷརྨྨསཱདྷནམ྄ ཨསྨཱཀཾ ཀརྟྟཝྱཾ, ཏཏཿ སོ྅ནྭམནྱཏ། ");
INSERT INTO santib_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ཨནནྟརཾ ཡཱིཤུརམྨསི མཛྫིཏུཿ སན྄ ཏཏྐྵཎཱཏ྄ ཏོཡམདྷྱཱད྄ ཨུཏྠཱཡ ཛགཱམ, ཏདཱ ཛཱིམཱུཏདྭཱརེ མུཀྟེ ཛཱཏེ, ས ཨཱིཤྭརསྱཱཏྨཱནཾ ཀཔོཏཝད྄ ཨཝརུཧྱ སྭོཔཪྻྱཱགཙྪནྟཾ ཝཱིཀྵཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ཨཔརམ྄ ཨེཥ མམ པྲིཡཿ པུཏྲ ཨེཏསྨིནྣེཝ མམ མཧཱསནྟོཥ ཨེཏཱདྲྀཤཱི ཝྱོམཛཱ ཝཱག྄ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ཏཏཿ པརཾ ཡཱིཤུཿ པྲཏཱརཀེཎ པརཱིཀྵིཏོ བྷཝིཏུམ྄ ཨཱཏྨནཱ པྲཱནྟརམ྄ ཨཱཀྲྀཥྚཿ ");
INSERT INTO santib_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","སན྄ ཙཏྭཱརིཾཤདཧོརཱཏྲཱན྄ ཨནཱཧཱརསྟིཥྛན྄ ཀྵུདྷིཏོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ཏདཱནཱིཾ པརཱིཀྵིཏཱ ཏཏྶམཱིཔམ྄ ཨཱགཏྱ ཝྱཱཧྲྀཏཝཱན྄, ཡདི ཏྭམཱིཤྭརཱཏྨཛོ བྷཝེསྟརྷྱཱཛྙཡཱ པཱཥཱཎཱནེཏཱན྄ པཱུཔཱན྄ ཝིདྷེཧི། ");
INSERT INTO santib_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ཏཏཿ ས པྲཏྱབྲཝཱིཏ྄, ཨིཏྠཾ ལིཁིཏམཱསྟེ, \"མནུཛཿ ཀེཝལཔཱུཔེན ན ཛཱིཝིཥྱཏི, ཀིནྟྭཱིཤྭརསྱ ཝདནཱད྄ ཡཱནི ཡཱནི ཝཙཱཾསི ནིཿསརནྟི ཏཻརེཝ ཛཱིཝིཥྱཏི། \" ");
INSERT INTO santib_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ཏདཱ པྲཏཱརཀསྟཾ པུཎྱནགརཾ ནཱིཏྭཱ མནྡིརསྱ ཙཱུཌོཔརི ནིདྷཱཡ གདིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ཏྭཾ ཡདིཤྭརསྱ ཏནཡོ བྷཝེསྟརྷཱིཏོ྅དྷཿ པཏ, ཡཏ ཨིཏྠཾ ལིཁིཏམཱསྟེ, ཨཱདེཀྵྱཏི ནིཛཱན྄ དཱུཏཱན྄ རཀྵིཏུཾ ཏྭཱཾ པརམེཤྭརཿ། ཡཐཱ སཪྻྭེཥུ མཱརྒེཥུ ཏྭདཱིཡཙརཎདྭཡེ། ན ལགེཏ྄ པྲསྟརཱགྷཱཏསྟྭཱཾ གྷརིཥྱནྟི ཏེ ཀརཻཿ༎ ");
INSERT INTO santib_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ཏདཱནཱིཾ ཡཱིཤུསྟསྨཻ ཀཐིཏཝཱན྄ ཨེཏདཔི ལིཁིཏམཱསྟེ, \"ཏྭཾ ནིཛཔྲབྷུཾ པརམེཤྭརཾ མཱ པརཱིཀྵསྭ། \" ");
INSERT INTO santib_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ཨནནྟརཾ པྲཏཱརཀཿ པུནརཔི ཏམ྄ ཨཏྱུཉྩདྷརཱདྷརོཔརི ནཱིཏྭཱ ཛགཏཿ སཀལརཱཛྱཱནི ཏདཻཤྭཪྻྱཱཎི ཙ དརྴཡཱཤྩཀཱར ཀཐཡཱཉྩཀཱར ཙ, ");
INSERT INTO santib_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ཡདི ཏྭཾ དཎྜཝད྄ བྷཝན྄ མཱཾ པྲཎམེསྟརྷྱཧམ྄ ཨེཏཱནི ཏུབྷྱཾ པྲདཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ཏདཱནཱིཾ ཡཱིཤུསྟམཝོཙཏ྄, དཱུརཱིབྷཝ པྲཏཱརཀ, ལིཁིཏམིདམ྄ ཨཱསྟེ, \"ཏྭཡཱ ནིཛཿ པྲབྷུཿ པརམེཤྭརཿ པྲཎམྱཿ ཀེཝལཿ ས སེཝྱཤྩ། \" ");
INSERT INTO santib_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ཏཏཿ པྲཏཱརཀེཎ ས པཪྻྱཏྱཱཛི, ཏདཱ སྭརྒཱིཡདཱུཏཻརཱགཏྱ ས སིཥེཝེ། ");
INSERT INTO santib_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ཏདནནྟརཾ ཡོཧན྄ ཀཱརཱཡཱཾ བབནྡྷེ, ཏདྭཱརྟྟཱཾ ནིཤམྱ ཡཱིཤུནཱ གཱལཱིལ྄ པྲཱསྠཱིཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ཏཏཿ པརཾ ས ནཱསརནྣགརཾ ཝིཧཱཡ ཛལགྷེསྟཊེ སིབཱུལཱུནྣཔྟཱལཱི ཨེཏཡོརུཝབྷཡོཿ པྲདེཤཡོཿ སཱིམྣོརྨདྷྱཝརྟྟཱི ཡ: ཀཕརྣཱཧཱུམ྄ ཏནྣགརམ྄ ཨིཏྭཱ ནྱཝསཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ཏསྨཱཏ྄, ཨནྱཱདེཤཱིཡགཱལཱིལི ཡརྡྡནྤཱརེ྅བྡྷིརོདྷསི། ནཔྟཱལིསིབཱུལཱུནྡེཤཽ ཡཏྲ སྠཱནེ སྠིཏཽ པུརཱ། ");
INSERT INTO santib_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ཏཏྲཏྱཱ མནུཛཱ ཡེ ཡེ པཪྻྱབྷྲཱམྱན྄ ཏམིསྲཀེ། ཏཻརྫནཻརྦྲྀཧདཱལོཀཿ པརིདརྴིཥྱཏེ ཏདཱ། ཨཝསན྄ ཡེ ཛནཱ དེཤེ མྲྀཏྱུཙྪཱཡཱསྭརཱུཔཀེ། ཏེཥཱམུཔརི ལོཀཱནཱམཱལོཀཿ སཾཔྲཀཱཤིཏཿ༎ ");
INSERT INTO santib_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ཡདེཏདྭཙནཾ ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཱ པྲོཀྟཾ, ཏཏ྄ ཏདཱ སཕལམ྄ ཨབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ཨནནྟརཾ ཡཱིཤུཿ སུསཾཝཱདཾ པྲཙཱརཡན྄ ཨེཏཱཾ ཀཐཱཾ ཀཐཡིཏུམ྄ ཨཱརེབྷེ, མནཱཾསི པརཱཝརྟྟཡཏ, སྭརྒཱིཡརཱཛཏྭཾ སཝིདྷམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ཏཏཿ པརཾ ཡཱིཤུ རྒཱལཱིལོ ཛལདྷེསྟཊེན གཙྪན྄ གཙྪན྄ ཨཱནྡྲིཡསྟསྱ བྷྲཱཏཱ ཤིམོན྄ ཨརྠཏོ ཡཾ པིཏརཾ ཝདནྟི ཨེཏཱཝུབྷཽ ཛལགྷཽ ཛཱལཾ ཀྵིཔནྟཽ དདརྴ, ཡཏསྟཽ མཱིནདྷཱརིཎཱཝཱསྟཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ཏདཱ ས ཏཱཝཱཧཱུཡ ཝྱཱཛཧཱར, ཡུཝཱཾ མམ པཤྩཱད྄ ཨཱགཙྪཏཾ, ཡུཝཱམཧཾ མནུཛདྷཱརིཎཽ ཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ཏེནཻཝ ཏཽ ཛཱལཾ ཝིཧཱཡ ཏསྱ པཤྩཱཏ྄ ཨཱགཙྪཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ཨནནྟརཾ ཏསྨཱཏ྄ སྠཱནཱཏ྄ ཝྲཛན྄ ཝྲཛན྄ སིཝདིཡསྱ སུཏཽ ཡཱཀཱུབ྄ ཡོཧནྣཱམཱནཽ དྭཽ སཧཛཽ ཏཱཏེན སཱརྡྡྷཾ ནཽཀོཔརི ཛཱལསྱ ཛཱིརྞོདྡྷཱརཾ ཀུཪྻྭནྟཽ ཝཱིཀྵྱ ཏཱཝཱཧཱུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ཏཏྐྵཎཱཏ྄ ཏཽ ནཱཝཾ སྭཏཱཏཉྩ ཝིཧཱཡ ཏསྱ པཤྩཱདྒཱམིནཽ བབྷཱུཝཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ཨནནྟརཾ བྷཛནབྷཝནེ སམུཔདིཤན྄ རཱཛྱསྱ སུསཾཝཱདཾ པྲཙཱརཡན྄ མནུཛཱནཱཾ སཪྻྭཔྲཀཱརཱན྄ རོགཱན྄ སཪྻྭཔྲཀཱརཔཱིཌཱཤྩ ཤམཡན྄ ཡཱིཤུཿ ཀྲྀཏྶྣཾ གཱལཱིལྡེཤཾ བྷྲམིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ཏེན ཀྲྀཏྶྣསུརིཡཱདེཤསྱ མདྷྱཾ ཏསྱ ཡཤོ ཝྱཱཔྣོཏ྄, ཨཔརཾ བྷཱུཏགྲསྟཱ ཨཔསྨཱརརྒཱིཎཿ པཀྵཱདྷཱཏིཔྲབྷྲྀཏཡཤྩ ཡཱཝནྟོ མནུཛཱ ནཱནཱཝིདྷཝྱཱདྷིབྷིཿ ཀླིཥྚཱ ཨཱསན྄, ཏེཥུ སཪྻྭེཥུ ཏསྱ སམཱིཔམ྄ ཨཱནཱིཏེཥུ ས ཏཱན྄ སྭསྠཱན྄ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ཨེཏེན གཱལཱིལ྄-དིཀཱཔནི-ཡིརཱུཤཱལམ྄-ཡིཧཱུདཱིཡདེཤེབྷྱོ ཡརྡྡནཿ པཱརཱཉྩ བཧཝོ མནུཛཱསྟསྱ པཤྩཱད྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ཨནནྟརཾ ས ཛནནིཝཧཾ ནིརཱིཀྵྱ བྷཱུདྷརོཔརི ཝྲཛིཏྭཱ སམུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ཏདཱནཱིཾ ཤིཥྱེཥུ ཏསྱ སམཱིཔམཱགཏེཥུ ཏེན ཏེབྷྱ ཨེཥཱ ཀཐཱ ཀཐྱཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ཨབྷིམཱནཧཱིནཱ ཛནཱ དྷནྱཱཿ, ཡཏསྟེ སྭརྒཱིཡརཱཛྱམ྄ ཨདྷིཀརིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ཁིདྱམཱནཱ མནུཛཱ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏེ སཱནྟྭནཱཾ པྲཱཔྶནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ནམྲཱ མཱནཝཱཤྩ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏེ མེདིནཱིམ྄ ཨདྷིཀརིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","དྷརྨྨཱཡ བུབྷུཀྵིཏཱཿ ཏྲྀཥཱརྟྟཱཤྩ མནུཛཱ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏེ པརིཏརྤྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ཀྲྀཔཱལཝོ མཱནཝཱ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏེ ཀྲྀཔཱཾ པྲཱཔྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ནིརྨྨལཧྲྀདཡཱ མནུཛཱཤྩ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏ ཨཱིཤྩརཾ དྲཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","མེལཡིཏཱརོ མཱནཝཱ དྷནྱཱཿ, ཡསྨཱཏ྄ ཏ ཨཱིཤྩརསྱ སནྟཱནཏྭེན ཝིཁྱཱསྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","དྷརྨྨཀཱརཎཱཏ྄ ཏཱཌིཏཱ མནུཛཱ དྷནྱཱ, ཡསྨཱཏ྄ སྭརྒཱིཡརཱཛྱེ ཏེཥཱམདྷིཀརོ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ཡདཱ མནུཛཱ མམ ནཱམཀྲྀཏེ ཡུཥྨཱན྄ ནིནྡནྟི ཏཱཌཡནྟི མྲྀཥཱ ནཱནཱདུཪྻྭཱཀྱཱནི ཝདནྟི ཙ, ཏདཱ ཡུཡཾ དྷནྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ཏདཱ ཨཱནནྡཏ, ཏཐཱ བྷྲྀཤཾ ཧླཱདདྷྭཉྩ, ཡཏཿ སྭརྒེ བྷཱུཡཱཾསི ཕལཱནི ལཔྶྱདྷྭེ; ཏེ ཡུཥྨཱཀཾ པུརཱཏནཱན྄ བྷཝིཥྱདྭཱདིནོ྅པི ཏཱདྲྀག྄ ཨཏཱཌཡན྄། ");
INSERT INTO santib_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ཡུཡཾ མེདིནྱཱཾ ལཝཎརཱུཔཱཿ, ཀིནྟུ ཡདི ལཝཎསྱ ལཝཎཏྭམ྄ ཨཔཡཱཏི, ཏརྷི ཏཏ྄ ཀེན པྲཀཱརེཎ སྭཱདུཡུཀྟཾ བྷཝིཥྱཏི? ཏཏ྄ ཀསྱཱཔི ཀཱཪྻྱསྱཱཡོགྱཏྭཱཏ྄ ཀེཝལཾ བཧིཿ པྲཀྵེཔྟུཾ ནརཱཎཱཾ པདཏལེན དལཡིཏུཉྩ ཡོགྱཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ཡཱུཡཾ ཛགཏི དཱིཔྟིརཱུཔཱཿ, བྷཱུདྷརོཔརི སྠིཏཾ ནགརཾ གུཔྟཾ བྷཝིཏུཾ ནཧི ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ཨཔརཾ མནུཛཱཿ པྲདཱིཔཱན྄ པྲཛྭཱལྱ དྲོཎཱདྷོ ན སྠཱཔཡནྟི, ཀིནྟུ དཱིཔཱདྷཱརོཔཪྻྱེཝ སྠཱཔཡནྟི, ཏེན ཏེ དཱིཔཱ གེཧསྠིཏཱན྄ སཀལཱན྄ པྲཀཱཤཡནྟི། ");
INSERT INTO santib_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ཡེན མཱནཝཱ ཡུཥྨཱཀཾ སཏྐརྨྨཱཎི ཝིལོཀྱ ཡུཥྨཱཀཾ སྭརྒསྠཾ པིཏརཾ དྷནྱཾ ཝདནྟི, ཏེཥཱཾ སམཀྵཾ ཡུཥྨཱཀཾ དཱིཔྟིསྟཱདྲྀཀ྄ པྲཀཱཤཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ཨཧཾ ཝྱཝསྠཱཾ བྷཝིཥྱདྭཱཀྱཉྩ ལོཔྟུམ྄ ཨཱགཏཝཱན྄, ཨིཏྠཾ མཱནུབྷཝཏ, ཏེ དྭེ ལོཔྟུཾ ནཱགཏཝཱན྄, ཀིནྟུ སཕལེ ཀརྟྟུམ྄ ཨཱགཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ཨཔརཾ ཡུཥྨཱན྄ ཨཧཾ ཏཐྱཾ ཝདཱམི ཡཱཝཏ྄ ཝྱོམམེདིནྱོ རྡྷྭཾསོ ན བྷཝིཥྱཏི, ཏཱཝཏ྄ སཪྻྭསྨིན྄ སཕལེ ན ཛཱཏེ ཝྱཝསྠཱཡཱ ཨེཀཱ མཱཏྲཱ བིནྡུརེཀོཔི ཝཱ ན ལོཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ཏསྨཱཏ྄ ཡོ ཛན ཨེཏཱསཱམ྄ ཨཱཛྙཱནཱམ྄ ཨཏིཀྵུདྲཱམ྄ ཨེཀཱཛྙཱམཔཱི ལཾགྷཏེ མནུཛཱཾཉྩ ཏཐཻཝ ཤིཀྵཡཏི, ས སྭརྒཱིཡརཱཛྱེ སཪྻྭེབྷྱཿ ཀྵུདྲཏྭེན ཝིཁྱཱསྱཏེ, ཀིནྟུ ཡོ ཛནསྟཱཾ པཱལཡཏི, ཏཐཻཝ ཤིཀྵཡཏི ཙ, ས སྭརྒཱིཡརཱཛྱེ པྲདྷཱནཏྭེན ཝིཁྱཱསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ཨཔརཾ ཡུཥྨཱན྄ ཨཧཾ ཝདཱམི, ཨདྷྱཱཔཀཕིརཱུཤིམཱནཝཱནཱཾ དྷརྨྨཱནུཥྛཱནཱཏ྄ ཡུཥྨཱཀཾ དྷརྨྨཱནུཥྛཱནེ ནོཏྟམེ ཛཱཏེ ཡཱུཡམ྄ ཨཱིཤྭརཱིཡརཱཛྱཾ པྲཝེཥྚུཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ཨཔརཉྩ ཏྭཾ ནརཾ མཱ ཝདྷཱིཿ, ཡསྨཱཏ྄ ཡོ ནརཾ ཧནྟི, ས ཝིཙཱརསབྷཱཡཱཾ དཎྜཱརྷོ བྷཝིཥྱཏི, པཱུཪྻྭཀཱལཱིནཛནེབྷྱ ཨིཏི ཀཐིཏམཱསཱིཏ྄, ཡུཥྨཱབྷིརཤྲཱཝི། ");
INSERT INTO santib_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཡཿ ཀཤྩིཏ྄ ཀཱརཎཾ ཝིནཱ ནིཛབྷྲཱཏྲེ ཀུཔྱཏི, ས ཝིཙཱརསབྷཱཡཱཾ དཎྜཱརྷོ བྷཝིཥྱཏི; ཡཿ ཀཤྩིཙྩ སྭཱིཡསཧཛཾ ནིརྦྦོདྷཾ ཝདཏི, ས མཧཱསབྷཱཡཱཾ དཎྜཱརྷོ བྷཝིཥྱཏི; པུནཤྩ ཏྭཾ མཱུཌྷ ཨིཏི ཝཱཀྱཾ ཡདི ཀཤྩིཏ྄ སྭཱིཡབྷྲཱཏརཾ ཝཀྟི, ཏརྷི ནརཀཱགྣཽ ས དཎྜཱརྷོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ཨཏོ ཝེདྱཱཿ སམཱིཔཾ ནིཛནཻཝེདྱེ སམཱནཱིཏེ྅པི ནིཛབྷྲཱཏརཾ པྲཏི ཀསྨཱཙྩིཏ྄ ཀཱརཎཱཏ྄ ཏྭཾ ཡདི དོཥཱི ཝིདྱསེ, ཏདཱནཱིཾ ཏཝ ཏསྱ སྨྲྀཏི རྫཱཡཏེ ཙ, ");
INSERT INTO santib_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ཏརྷི ཏསྱཱ ཝེདྱཱཿ སམཱིཔེ ནིཛནཻཝཻདྱཾ ནིདྷཱཡ ཏདཻཝ གཏྭཱ པཱུཪྻྭཾ ཏེན སཱརྡྡྷཾ མིལ, པཤྩཱཏ྄ ཨཱགཏྱ ནིཛནཻཝེདྱཾ ནིཝེདཡ། ");
INSERT INTO santib_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ཨནྱཉྩ ཡཱཝཏ྄ ཝིཝཱདིནཱ སཱརྡྡྷཾ ཝརྟྨནི ཏིཥྛསི, ཏཱཝཏ྄ ཏེན སཱརྡྡྷཾ མེལནཾ ཀུརུ; ནོ ཙེཏ྄ ཝིཝཱདཱི ཝིཙཱརཡིཏུཿ སམཱིཔེ ཏྭཱཾ སམརྤཡཏི ཝིཙཱརཡིཏཱ ཙ རཀྵིཎཿ སནྣིདྷཽ སམརྤཡཏི ཏདཱ ཏྭཾ ཀཱརཱཡཱཾ བདྷྱེཐཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ཏརྷི ཏྭཱམཧཾ ཏཐྠཾ བྲཝཱིམི, ཤེཥཀཔརྡཀེ྅པི ན པརིཤོདྷིཏེ ཏསྨཱཏ྄ སྠཱནཱཏ྄ ཀདཱཔི བཧིརཱགནྟུཾ ན ཤཀྵྱསི། ");
INSERT INTO santib_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ཨཔརཾ ཏྭཾ མཱ ཝྱབྷིཙར, ཡདེཏད྄ ཝཙནཾ པཱུཪྻྭཀཱལཱིནལོཀེབྷྱཿ ཀཐིཏམཱསཱིཏ྄, ཏད྄ ཡཱུཡཾ ཤྲུཏཝནྟཿ; ");
INSERT INTO santib_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཡདི ཀཤྩིཏ྄ ཀཱམཏཿ ཀཱཉྩན ཡོཥིཏཾ པཤྱཏི, ཏརྷི ས མནསཱ ཏདཻཝ ཝྱབྷིཙརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ཏསྨཱཏ྄ ཏཝ དཀྵིཎཾ ནེཏྲཾ ཡདི ཏྭཱཾ བཱདྷཏེ, ཏརྷི ཏནྣེཏྲམ྄ ཨུཏྤཱཊྱ དཱུརེ ནིཀྵིཔ, ཡསྨཱཏ྄ ཏཝ སཪྻྭཝཔུཥོ ནརཀེ ནིཀྵེཔཱཏ྄ ཏཝཻཀཱངྒསྱ ནཱཤོ ཝརཾ། ");
INSERT INTO santib_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ཡདྭཱ ཏཝ དཀྵིཎཿ ཀརོ ཡདི ཏྭཱཾ བཱདྷཏེ, ཏརྷི ཏཾ ཀརཾ ཚིཏྟྭཱ དཱུརེ ནིཀྵིཔ, ཡཏཿ སཪྻྭཝཔུཥོ ནརཀེ ནིཀྵེཔཱཏ྄ ཨེཀཱངྒསྱ ནཱཤོ ཝརཾ། ");
INSERT INTO santib_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ཨུཀྟམཱསྟེ, ཡདི ཀཤྩིན྄ ནིཛཛཱཡཱཾ པརིཏྱཀྟྟུམ྄ ཨིཙྪཏི, ཏརྷི ས ཏསྱཻ ཏྱཱགཔཏྲཾ དདཱཏུ། ");
INSERT INTO santib_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝྱཱཧརཱམི, ཝྱབྷིཙཱརདོཥེ ན ཛཱཏེ ཡདི ཀཤྩིན྄ ནིཛཛཱཡཱཾ པརིཏྱཛཏི, ཏརྷི ས ཏཱཾ ཝྱབྷིཙཱརཡཏི; ཡཤྩ ཏཱཾ ཏྱཀྟཱཾ སྟྲིཡཾ ཝིཝཧཏི, སོཔི ཝྱབྷིཙརཏི། ");
INSERT INTO santib_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","པུནཤྩ ཏྭཾ མྲྀཥཱ ཤཔཐམ྄ ན ཀུཪྻྭན྄ ཨཱིཤྩརཱཡ ནིཛཤཔཐཾ པཱལཡ, པཱུཪྻྭཀཱལཱིནལོཀེབྷྱོ ཡཻཥཱ ཀཐཱ ཀཐིཏཱ, ཏཱམཔི ཡཱུཡཾ ཤྲུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཀམཔི ཤཔཐཾ མཱ ཀཱརྵྚ, ཨརྠཏཿ སྭརྒནཱམྣཱ ན, ཡཏཿ ས ཨཱིཤྭརསྱ སིཾཧཱསནཾ; ");
INSERT INTO santib_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","པྲྀཐིཝྱཱ ནཱམྣཱཔི ན, ཡཏཿ སཱ ཏསྱ པཱདཔཱིཋཾ; ཡིརཱུཤཱལམོ ནཱམྣཱཔི ན, ཡཏཿ སཱ མཧཱརཱཛསྱ པུརཱི; ");
INSERT INTO santib_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ནིཛཤིརོནཱམྣཱཔི ན, ཡསྨཱཏ྄ ཏསྱཻཀཾ ཀཙམཔི སིཏམ྄ ཨསིཏཾ ཝཱ ཀརྟྟུཾ ཏྭཡཱ ན ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ཨཔརཾ ཡཱུཡཾ སཾལཱཔསམཡེ ཀེཝལཾ བྷཝཏཱིཏི ན བྷཝཏཱིཏི ཙ ཝདཏ ཡཏ ཨིཏོ྅དྷིཀཾ ཡཏ྄ ཏཏ྄ པཱཔཱཏྨནོ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ཨཔརཾ ལོཙནསྱ ཝིནིམཡེན ལོཙནཾ དནྟསྱ ཝིནིམཡེན དནྟཿ པཱུཪྻྭཀྟམིདཾ ཝཙནཉྩ ཡུཥྨཱབྷིརཤྲཱུཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི ཡཱུཡཾ ཧིཾསཀཾ ནརཾ མཱ ཝྱཱགྷཱཏཡཏ། ཀིནྟུ ཀེནཙིཏ྄ ཏཝ དཀྵིཎཀཔོལེ ཙཔེཊཱགྷཱཏེ ཀྲྀཏེ ཏཾ པྲཏི ཝཱམཾ ཀཔོལཉྩ ཝྱཱགྷོཊཡ། ");
INSERT INTO santib_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ཨཔརཾ ཀེནཙིཏ྄ ཏྭཡཱ སཱརྡྷྡཾ ཝིཝཱདཾ ཀྲྀཏྭཱ ཏཝ པརིདྷེཡཝསནེ ཛིགྷྲྀཏིཏེ ཏསྨཱཡུཏྟརཱིཡཝསནམཔི དེཧི། ");
INSERT INTO santib_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ཡདི ཀཤྩིཏ྄ ཏྭཱཾ ཀྲོཤམེཀཾ ནཡནཱརྠཾ ཨནྱཱཡཏོ དྷརཏི, ཏདཱ ཏེན སཱརྡྷྡཾ ཀྲོཤདྭཡཾ ཡཱཧི། ");
INSERT INTO santib_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ཡཤྩ མཱནཝསྟྭཱཾ ཡཱཙཏེ, ཏསྨཻ དེཧི, ཡདི ཀཤྩིཏ྄ ཏུབྷྱཾ དྷཱརཡིཏུམ྄ ཨིཙྪཏི, ཏརྷི ཏཾ པྲཏི པརཱཾམུཁོ མཱ བྷཱུཿ། ");
INSERT INTO santib_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ནིཛསམཱིཔཝསིནི པྲེམ ཀུརུ, ཀིནྟུ ཤཏྲུཾ པྲཏི དྭེཥཾ ཀུརུ, ཡདེཏཏ྄ པུརོཀྟཾ ཝཙནཾ ཨེཏདཔི ཡཱུཡཾ ཤྲུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཡཱུཡཾ རིཔུཝྺཔི པྲེམ ཀུརུཏ, ཡེ ཙ ཡུཥྨཱན྄ ཤཔནྟེ, ཏཱན, ཨཱཤིཥཾ ཝདཏ, ཡེ ཙ ཡུཥྨཱན྄ ཨྲྀृཏཱིཡནྟེ, ཏེཥཱཾ མངྒལཾ ཀུརུཏ, ཡེ ཙ ཡུཥྨཱན྄ ནིནྡནྟི, ཏཱཌཡནྟི ཙ, ཏེཥཱཾ ཀྲྀཏེ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ཏཏྲ ཡཿ སཏཱམསཏཱཉྩོཔརི པྲབྷཱཀརམ྄ ཨུདཱཡཡཏི, ཏཐཱ དྷཱརྨྨིཀཱནཱམདྷཱརྨྨིཀཱནཱཉྩོཔརི ནཱིརཾ ཝརྵཡཏི ཏཱདྲྀཤོ ཡོ ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱ, ཡཱུཡཾ ཏསྱཻཝ སནྟཱནཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ཡེ ཡུཥྨཱསུ པྲེམ ཀུཪྻྭནྟི, ཡཱུཡཾ ཡདི ཀེཝལཾ ཏེཝྺེཝ པྲེམ ཀུརུཐ, ཏརྷི ཡུཥྨཱཀཾ ཀིཾ ཕལཾ བྷཝིཥྱཏི? ཙཎྜཱལཱ ཨཔི ཏཱདྲྀཤཾ ཀིཾ ན ཀུཪྻྭནྟི? ");
INSERT INTO santib_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ཨཔརཾ ཡཱུཡཾ ཡདི ཀེཝལཾ སྭཱིཡབྷྲཱཏྲྀཏྭེན ནམཏ, ཏརྷི ཀིཾ མཧཏ྄ ཀརྨྨ ཀུརུཐ? ཙཎྜཱལཱ ཨཔི ཏཱདྲྀཤཾ ཀིཾ ན ཀུཪྻྭནྟི? ");
INSERT INTO santib_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ཏསྨཱཏ྄ ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱ ཡཐཱ པཱུརྞོ བྷཝཏི, ཡཱུཡམཔི ཏཱདྲྀཤཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","སཱཝདྷཱནཱ བྷཝཏ, མནུཛཱན྄ དརྴཡིཏུཾ ཏེཥཱཾ གོཙརེ དྷརྨྨཀརྨྨ མཱ ཀུརུཏ, ཏཐཱ ཀྲྀཏེ ཡུཥྨཱཀཾ སྭརྒསྠཔིཏུཿ སཀཱཤཱཏ྄ ཀིཉྩན ཕལཾ ན པྲཱཔྶྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ཏྭཾ ཡདཱ དདཱསི ཏདཱ ཀཔཊིནོ ཛནཱ ཡཐཱ མནུཛེབྷྱཿ པྲཤཾསཱཾ པྲཱཔྟུཾ བྷཛནབྷཝནེ རཱཛམཱརྒེ ཙ ཏཱུརཱིཾ ཝཱདཡནྟི, ཏཐཱ མཱ ཀུརིु, ཨཧཾ ཏུབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི, ཏེ སྭཀཱཡཾ ཕལམ྄ ཨལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ཀིནྟུ ཏྭཾ ཡདཱ དདཱསི, ཏདཱ ནིཛདཀྵིཎཀརོ ཡཏ྄ ཀརོཏི, ཏད྄ ཝཱམཀརཾ མཱ ཛྙཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ཏེན ཏཝ དཱནཾ གུཔྟཾ བྷཝིཥྱཏི ཡསྟུ ཏཝ པིཏཱ གུཔྟདརྴཱི, ས པྲཀཱཤྱ ཏུབྷྱཾ ཕལཾ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ཨཔརཾ ཡདཱ པྲཱརྠཡསེ, ཏདཱ ཀཔཊིནཨིཝ མཱ ཀུརུ, ཡསྨཱཏ྄ ཏེ བྷཛནབྷཝནེ རཱཛམཱརྒསྱ ཀོཎེ ཏིཥྛནྟོ ལོཀཱན྄ དརྴཡནྟཿ པྲཱརྠཡིཏུཾ པྲཱིཡནྟེ; ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི, ཏེ སྭཀཱིཡཕལཾ པྲཱཔྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ཏསྨཱཏ྄ པྲཱརྠནཱཀཱལེ ཨནྟརཱགཱརཾ པྲཝིཤྱ དྭཱརཾ རུདྭྭཱ གུཔྟཾ པཤྱཏསྟཝ པིཏུཿ སམཱིཔེ པྲཱརྠཡསྭ; ཏེན ཏཝ ཡཿ པིཏཱ གུཔྟདརྴཱི, ས པྲཀཱཤྱ ཏུབྷྱཾ ཕལཾ དཱསྱཏིl ");
INSERT INTO santib_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ཨཔརཾ པྲཱརྠནཱཀཱལེ དེཝཔཱུཛཀཱཨིཝ མུདྷཱ པུནརུཀྟིཾ མཱ ཀུརུ, ཡསྨཱཏ྄ ཏེ བོདྷནྟེ, བཧུཝཱརཾ ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ ཏེཥཱཾ པྲཱརྠནཱ གྲཱཧིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ཡཱུཡཾ ཏེཥཱམིཝ མཱ ཀུརུཏ, ཡསྨཱཏ྄ ཡུཥྨཱཀཾ ཡད྄ ཡཏ྄ པྲཡོཛནཾ ཡཱཙནཱཏཿ པྲཱགེཝ ཡུཥྨཱཀཾ པིཏཱ ཏཏ྄ ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ཨཏཨེཝ ཡཱུཡམ ཨཱིདྲྀཀ྄ པྲཱརྠཡདྷྭཾ, ཧེ ཨསྨཱཀཾ སྭརྒསྠཔིཏཿ, ཏཝ ནཱམ པཱུཛྱཾ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ཏཝ རཱཛཏྭཾ བྷཝཏུ; ཏཝེཙྪཱ སྭརྒེ ཡཐཱ ཏཐཻཝ མེདིནྱཱམཔི སཕལཱ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ཨསྨཱཀཾ པྲཡོཛནཱིཡམ྄ ཨཱཧཱརམ྄ ཨདྱ དེཧི། ");
INSERT INTO santib_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ཝཡཾ ཡཐཱ ནིཛཱཔརཱདྷིནཿ ཀྵམཱམཧེ, ཏཐཻཝཱསྨཱཀམ྄ ཨཔརཱདྷཱན྄ ཀྵམསྭ། ");
INSERT INTO santib_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ཨསྨཱན྄ པརཱིཀྵཱཾ མཱནཡ, ཀིནྟུ པཱཔཱཏྨནོ རཀྵ; རཱཛཏྭཾ གཽརཝཾ པརཱཀྲམཿ ཨེཏེ སཪྻྭེ སཪྻྭདཱ ཏཝ; ཏཐཱསྟུ། ");
INSERT INTO santib_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ཡདི ཡཱུཡམ྄ ཨནྱེཥཱམ྄ ཨཔརཱདྷཱན྄ ཀྵམདྷྭེ ཏརྷི ཡུཥྨཱཀཾ སྭརྒསྠཔིཏཱཔི ཡུཥྨཱན྄ ཀྵམིཥྱཏེ; ");
INSERT INTO santib_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ཀིནྟུ ཡདི ཡཱུཡམ྄ ཨནྱེཥཱམ྄ ཨཔརཱདྷཱན྄ ན ཀྵམདྷྭེ, ཏརྷི ཡུཥྨཱཀཾ ཛནཀོཔི ཡུཥྨཱཀམ྄ ཨཔརཱདྷཱན྄ ན ཀྵམིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ཨཔརམ྄ ཨུཔཝཱསཀཱལེ ཀཔཊིནོ ཛནཱ མཱནུཥཱན྄ ཨུཔཝཱསཾ ཛྙཱཔཡིཏུཾ སྭེཥཱཾ ཝདནཱནི མླཱནཱནི ཀུཪྻྭནྟི, ཡཱུཡཾ ཏཨིཝ ཝིཥཎཝདནཱ མཱ བྷཝཏ; ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི ཏེ སྭཀཱིཡཕལམ྄ ཨལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ཡདཱ ཏྭམ྄ ཨུཔཝསསི, ཏདཱ ཡཐཱ ལོཀཻསྟྭཾ ཨུཔཝཱསཱིཝ ན དྲྀཤྱསེ, ཀིནྟུ ཏཝ ཡོ྅གོཙརཿ པིཏཱ ཏེནཻཝ དྲྀཤྱསེ, ཏཏྐྲྀཏེ ནིཛཤིརསི ཏཻལཾ མརྡྡཡ ཝདནཉྩ པྲཀྵཱལཡ; ");
INSERT INTO santib_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ཏེན ཏཝ ཡཿ པིཏཱ གུཔྟདརྴཱི ས པྲཀཱཤྱ ཏུབྷྱཾ ཕལཾ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ཨཔརཾ ཡཏྲ སྠཱནེ ཀཱིཊཱཿ ཀལངྐཱཤྩ ཀྵཡཾ ནཡནྟི, ཙཽརཱཤྩ སནྡྷིཾ ཀརྟྟཡིཏྭཱ ཙོརཡིཏུཾ ཤཀྣུཝནྟི, ཏཱདྲྀཤྱཱཾ མེདིནྱཱཾ སྭཱརྠཾ དྷནཾ མཱ སཾཙིནུཏ། ");
INSERT INTO santib_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ཀིནྟུ ཡཏྲ སྠཱནེ ཀཱིཊཱཿ ཀལངྐཱཤྩ ཀྵཡཾ ན ནཡནྟི, ཙཽརཱཤྩ སནྡྷིཾ ཀརྟྟཡིཏྭཱ ཙོརཡིཏུཾ ན ཤཀྣུཝནྟི, ཏཱདྲྀཤེ སྭརྒེ དྷནཾ སཉྩིནུཏ། ");
INSERT INTO santib_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ཡསྨཱཏ྄ ཡཏྲ སྠཱནེ ཡུཥྨཱཾཀ དྷནཾ ཏཏྲཻཝ ཁཱནེ ཡུཥྨཱཀཾ མནཱཾསི། ");
INSERT INTO santib_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ལོཙནཾ དེཧསྱ པྲདཱིཔཀཾ, ཏསྨཱཏ྄ ཡདི ཏཝ ལོཙནཾ པྲསནྣཾ བྷཝཏི, ཏརྷི ཏཝ ཀྲྀཏྶྣཾ ཝཔུ རྡཱིཔྟིཡུཀྟཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ཀིནྟུ ལོཙནེ྅པྲསནྣེ ཏཝ ཀྲྀཏྶྣཾ ཝཔུཿ ཏམིསྲཡུཀྟཾ བྷཝིཥྱཏི། ཨཏཨེཝ ཡཱ དཱིཔྟིསྟྭཡི ཝིདྱཏེ, སཱ ཡདི ཏམིསྲཡུཀྟཱ བྷཝཏི, ཏརྷི ཏཏ྄ ཏམིསྲཾ ཀིཡན྄ མཧཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ཀོཔི མནུཛོ དྭཽ པྲབྷཱུ སེཝིཏུཾ ན ཤཀྣོཏི, ཡསྨཱད྄ ཨེཀཾ སཾམནྱ ཏདནྱཾ ན སམྨནྱཏེ, ཡདྭཱ ཨེཀཏྲ མནོ ནིདྷཱཡ ཏདནྱམ྄ ཨཝམནྱཏེ; ཏཐཱ ཡཱུཡམཔཱིཤྭརཾ ལཀྵྨཱིཉྩེཏྱུབྷེ སེཝིཏུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ཨཔརམ྄ ཨཧཾ ཡུཥྨབྷྱཾ ཏཐྱཾ ཀཐཡཱམི, ཀིཾ བྷཀྵིཥྱཱམཿ? ཀིཾ པཱསྱཱམཿ? ཨིཏི པྲཱཎདྷཱརཎཱཡ མཱ ཙིནྟཡཏ; ཀིཾ པརིདྷཱསྱཱམཿ? ཨིཏི ཀཱཡརཀྵཎཱཡ ན ཙིནྟཡཏ; བྷཀྵྱཱཏ྄ པྲཱཎཱ ཝསནཱཉྩ ཝཔཱུཾཥི ཀིཾ ཤྲེཥྛཱཎི ན ཧི? ");
INSERT INTO santib_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ཝིཧཱཡསོ ཝིཧངྒམཱན྄ ཝིལོཀཡཏ; ཏཻ རྣོཔྱཏེ ན ཀྲྀཏྱཏེ བྷཱཎྜཱགཱརེ ན སཉྩཱིཡཏེ྅པི; ཏཐཱཔི ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱ ཏེབྷྱ ཨཱཧཱརཾ ཝིཏརཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ཡཱུཡཾ ཏེབྷྱཿ ཀིཾ ཤྲེཥྛཱ ན བྷཝཐ? ཡུཥྨཱཀཾ ཀཤྩིཏ྄ མནུཛཿ ཙིནྟཡན྄ ནིཛཱཡུཥཿ ཀྵཎམཔི ཝརྡྡྷཡིཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ཨཔརཾ ཝསནཱཡ ཀུཏཤྩིནྟཡཏ? ཀྵེཏྲོཏྤནྣཱནི པུཥྤཱཎི ཀཐཾ ཝརྡྡྷནྟེ ཏདཱལོཙཡཏ། ཏཱནི ཏནྟཱུན྄ ནོཏྤཱདཡནྟི ཀིམཔི ཀཱཪྻྱཾ ན ཀུཪྻྭནྟི; ");
INSERT INTO santib_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ཏཐཱཔྱཧཾ ཡུཥྨཱན྄ ཝདཱམི, སུལེམཱན྄ ཏཱདྲྀག྄ ཨཻཤྭཪྻྱཝཱནཔི ཏཏྤུཥྤམིཝ ཝིབྷཱུཥིཏོ ནཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ཏསྨཱཏ྄ ཀྵདྱ ཝིདྱམཱནཾ ཤྩཿ ཙུལླྱཱཾ ནིཀྵེཔྶྱཏེ ཏཱདྲྀཤཾ ཡཏ྄ ཀྵེཏྲསྠིཏཾ ཀུསུམཾ ཏཏ྄ ཡདཱིཤྩར ཨིཏྠཾ བིབྷཱུཥཡཏི, ཏརྷི ཧེ སྟོཀཔྲཏྱཡིནོ ཡུཥྨཱན྄ ཀིཾ ན པརིདྷཱཔཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ཏསྨཱཏ྄ ཨསྨཱབྷིཿ ཀིམཏྶྱཏེ? ཀིཉྩ པཱཡིཥྱཏེ? ཀིཾ ཝཱ པརིདྷཱཡིཥྱཏེ, ཨིཏི ན ཙིནྟཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ཡསྨཱཏ྄ དེཝཱརྩྩཀཱ ཨཔཱིཏི ཙེཥྚནྟེ; ཨེཏེཥུ དྲཝྱེཥུ པྲཡོཛནམསྟཱིཏི ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱ ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ཨཏཨེཝ པྲཐམཏ ཨཱིཤྭརཱིཡརཱཛྱཾ དྷརྨྨཉྩ ཙེཥྚདྷྭཾ, ཏཏ ཨེཏཱནི ཝསྟཱུནི ཡུཥྨབྷྱཾ པྲདཱཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ཤྭཿ ཀྲྀཏེ མཱ ཙིནྟཡཏ, ཤྭཨེཝ སྭཡཾ སྭམུདྡིཤྱ ཙིནྟཡིཥྱཏི; ཨདྱཏནཱི ཡཱ ཙིནྟཱ སཱདྱཀྲྀཏེ པྲཙུརཏརཱ། ");
INSERT INTO santib_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ཡཐཱ ཡཱུཡཾ དོཥཱིཀྲྀཏཱ ན བྷཝཐ, ཏཏྐྲྀཏེ྅ནྱཾ དོཥིཎཾ མཱ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ཡཏོ ཡཱདྲྀཤེན དོཥེཎ ཡཱུཡཾ པརཱན྄ དོཥིཎཿ ཀུརུཐ, ཏཱདྲྀཤེན དོཥེཎ ཡཱུཡམཔི དོཥཱིཀྲྀཏཱ བྷཝིཥྱཐ, ཨནྱཉྩ ཡེན པརིམཱཎེན ཡུཥྨཱབྷིཿ པརིམཱིཡཏེ, ཏེནཻཝ པརིམཱཎེན ཡུཥྨཏྐྲྀཏེ པརིམཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ཨཔརཉྩ ནིཛནཡནེ ཡཱ ནཱསཱ ཝིདྱཏེ, ཏཱམ྄ ཨནཱལོཙྱ ཏཝ སཧཛསྱ ལོཙནེ ཡཏ྄ ཏྲྀཎམ྄ ཨཱསྟེ, ཏདེཝ ཀུཏོ ཝཱིཀྵསེ? ");
INSERT INTO santib_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ཏཝ ནིཛལོཙནེ ནཱསཱཡཱཾ ཝིདྱམཱནཱཡཱཾ, ཧེ བྷྲཱཏཿ, ཏཝ ནཡནཱཏ྄ ཏྲྀཎཾ བཧིཥྱརྟུཾ ཨནུཛཱནཱིཧི, ཀཐཱམེཏཱཾ ནིཛསཧཛཱཡ ཀཐཾ ཀཐཡིཏུཾ ཤཀྣོཥི? ");
INSERT INTO santib_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ཧེ ཀཔཊིན྄, ཨཱདཽ ནིཛནཡནཱཏ྄ ནཱསཱཾ བཧིཥྐུརུ ཏཏོ ནིཛདྲྀཥྚཽ སུཔྲསནྣཱཡཱཾ ཏཝ བྷྲཱཏྲྀ རློཙནཱཏ྄ ཏྲྀཎཾ བཧིཥྐརྟུཾ ཤཀྵྱསི། ");
INSERT INTO santib_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ཨནྱཉྩ སཱརམེཡེབྷྱཿ པཝིཏྲཝསྟཱུནི མཱ ཝིཏརཏ, ཝརཱཧཱཎཱཾ སམཀྵཉྩ མུཀྟཱ མཱ ནིཀྵིཔཏ; ནིཀྵེཔཎཱཏ྄ ཏེ ཏཱཿ སཪྻྭཱཿ པདཻ རྡལཡིཥྱནྟི, པརཱཝྲྀཏྱ ཡུཥྨཱནཔི ཝིདཱརཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ཡཱཙདྷྭཾ ཏཏོ ཡུཥྨབྷྱཾ དཱཡིཥྱཏེ; མྲྀགཡདྷྭཾ ཏཏ ཨུདྡེཤཾ ལཔྶྱདྷྭེ; དྭཱརམ྄ ཨཱཧཏ, ཏཏོ ཡུཥྨཏྐྲྀཏེ མུཀྟཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ཡསྨཱད྄ ཡེན ཡཱཙྱཏེ, ཏེན ལབྷྱཏེ; ཡེན མྲྀགྱཏེ ཏེནོདྡེཤཿ པྲཱཔྱཏེ; ཡེན ཙ དྭཱརམ྄ ཨཱཧནྱཏེ, ཏཏྐྲྀཏེ དྭཱརཾ མོཙྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ཨཱཏྨཛེན པཱུཔེ པྲཱརྠིཏེ ཏསྨཻ པཱཥཱཎཾ ཝིཤྲཱཎཡཏི, ");
INSERT INTO santib_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","མཱིནེ ཡཱཙིཏེ ཙ ཏསྨཻ བྷུཛགཾ ཝིཏརཏི, ཨེཏཱདྲྀཤཿ པིཏཱ ཡུཥྨཱཀཾ མདྷྱེ ཀ ཨཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ཏསྨཱད྄ ཡཱུཡམ྄ ཨབྷདྲཱཿ སནྟོ྅པི ཡདི ནིཛབཱལཀེབྷྱ ཨུཏྟམཾ དྲཝྱཾ དཱཏུཾ ཛཱནཱིཐ, ཏརྷི ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱ སྭཱིཡཡཱཙཀེབྷྱཿ ཀིམུཏྟམཱནི ཝསྟཱུནི ན དཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ཡཱུཥྨཱན྄ པྲཏཱིཏརེཥཱཾ ཡཱདྲྀཤོ ཝྱཝཧཱརོ ཡུཥྨཱཀཾ པྲིཡཿ, ཡཱུཡཾ ཏཱན྄ པྲཏི ཏཱདྲྀཤཱནེཝ ཝྱཝཧཱརཱན྄ ཝིདྷཏྟ; ཡསྨཱད྄ ཝྱཝསྠཱབྷཝིཥྱདྭཱདིནཱཾ ཝཙནཱནཱམ྄ ཨིཏི སཱརམ྄། ");
INSERT INTO santib_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","སངྐཱིརྞདྭཱརེཎ པྲཝིཤཏ; ཡཏོ ནརཀགམནཱཡ ཡད྄ དྭཱརཾ ཏད྄ ཝིསྟཱིརྞཾ ཡཙྩ ཝརྟྨ ཏད྄ བྲྀཧཏ྄ ཏེན བཧཝཿ པྲཝིཤནྟི། ");
INSERT INTO santib_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ཨཔརཾ སྭརྒགམནཱཡ ཡད྄ དྭཱརཾ ཏཏ྄ ཀཱིདྲྀཀ྄ སཾཀཱིརྞཾ། ཡཙྩ ཝརྟྨ ཏཏ྄ ཀཱིདྲྀག྄ དུརྒམམ྄། ཏདུདྡེཥྚཱརཿ ཀིཡནྟོ྅ལྤཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ཨཔརཉྩ ཡེ ཛནཱ མེཥཝེཤེན ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགཙྪནྟི, ཀིནྟྭནྟརྡུརནྟཱ ཝྲྀཀཱ ཨེཏཱདྲྀཤེབྷྱོ བྷཝིཥྱདྭཱདིབྷྱཿ སཱཝདྷཱནཱ བྷཝཏ, ཡཱུཡཾ ཕལེན ཏཱན྄ པརིཙེཏུཾ ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","མནུཛཱཿ ཀིཾ ཀཎྚཀིནོ ཝྲྀཀྵཱད྄ དྲཱཀྵཱཕལཱནི ཤྲྀགཱལཀོལིཏཤྩ ཨུཌུམྦརཕལཱནི ཤཱཏཡནྟི? ");
INSERT INTO santib_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ཏདྭད྄ ཨུཏྟམ ཨེཝ པཱདཔ ཨུཏྟམཕལཱནི ཛནཡཏི, ཨདྷམཔཱདཔཨེཝཱདྷམཕལཱནི ཛནཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ཀིནྟཱུཏྟམཔཱདཔཿ ཀདཱཔྱདྷམཕལཱནི ཛནཡིཏུཾ ན ཤཀྣོཏི, ཏཐཱདྷམོཔི པཱདཔ ཨུཏྟམཕལཱནི ཛནཡིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ཨཔརཾ ཡེ ཡེ པཱདཔཱ ཨདྷམཕལཱནི ཛནཡནྟི, ཏེ ཀྲྀཏྟཱ ཝཧྣཽ ཀྵིཔྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ཨཏཨེཝ ཡཱུཡཾ ཕལེན ཏཱན྄ པརིཙེཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ཡེ ཛནཱ མཱཾ པྲབྷུཾ ཝདནྟི, ཏེ སཪྻྭེ སྭརྒརཱཛྱཾ པྲཝེཀྵྱནྟི ཏནྣ, ཀིནྟུ ཡོ མཱནཝོ མམ སྭརྒསྠསྱ པིཏུརིཥྚཾ ཀརྨྨ ཀརོཏི ས ཨེཝ པྲཝེཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ཏད྄ དིནེ བཧཝོ མཱཾ ཝདིཥྱནྟི, ཧེ པྲབྷོ ཧེ པྲབྷོ, ཏཝ ནཱམྣཱ ཀིམསྨཱམི རྦྷཝིཥྱདྭཱཀྱཾ ན ཝྱཱཧྲྀཏཾ? ཏཝ ནཱམྣཱ བྷཱུཏཱཿ ཀིཾ ན ཏྱཱཛིཏཱཿ? ཏཝ ནཱམྣཱ ཀིཾ ནཱནཱདྦྷུཏཱནི ཀརྨྨཱཎི ན ཀྲྀཏཱནི? ");
INSERT INTO santib_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ཏདཱཧཾ ཝདིཥྱཱམི, ཧེ ཀུཀརྨྨཀཱརིཎོ ཡུཥྨཱན྄ ཨཧཾ ན ཝེདྨི, ཡཱུཡཾ མཏྶམཱིཔཱད྄ དཱུརཱིབྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ཡཿ ཀཤྩིཏ྄ མམཻཏཱཿ ཀཐཱཿ ཤྲུཏྭཱ པཱལཡཏི, ས པཱཥཱཎོཔརི གྲྀཧནིརྨྨཱཏྲཱ ཛྙཱནིནཱ སཧ མཡོཔམཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ཡཏོ ཝྲྀཥྚཽ སཏྱཱམ྄ ཨཱཔླཱཝ ཨཱགཏེ ཝཱཡཽ ཝཱཏེ ཙ ཏེཥུ ཏདྒེཧཾ ལགྣེཥུ པཱཥཱཎོཔརི ཏསྱ བྷིཏྟེསྟནྣ པཏཏིl ");
INSERT INTO santib_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ མམཻཏཱཿ ཀཐཱཿ ཤྲུཏྭཱ ན པཱལཡཏི ས སཻཀཏེ གེཧནིརྨྨཱཏྲཱ ྅ཛྙཱནིནཱ ཨུཔམཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ཡཏོ ཛལཝྲྀཥྚཽ སཏྱཱམ྄ ཨཱཔླཱཝ ཨཱགཏེ པཝནེ ཝཱཏེ ཙ ཏཻ རྒྲྀཧེ སམཱགྷཱཏེ ཏཏ྄ པཏཏི ཏཏྤཏནཾ མཧད྄ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ཡཱིཤུནཻཏེཥུ ཝཱཀྱེཥུ སམཱཔིཏེཥུ མཱནཝཱསྟདཱིཡོཔདེཤམ྄ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ཡསྨཱཏ྄ ས ཨུཔཱདྷྱཱཡཱ ཨིཝ ཏཱན྄ ནོཔདིདེཤ ཀིནྟུ སམརྠཔུརུཥཨིཝ སམུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ཡདཱ ས པཪྻྭཏཱད྄ ཨཝཱརོཧཏ྄ ཏདཱ བཧཝོ མཱནཝཱསྟཏྤཤྩཱད྄ ཝཝྲཛུཿ། ");
INSERT INTO santib_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ཨེཀཿ ཀུཥྛཝཱན྄ ཨཱགཏྱ ཏཾ པྲཎམྱ བབྷཱཥེ, ཧེ པྲབྷོ, ཡདི བྷཝཱན྄ སཾམནྱཏེ, ཏརྷི མཱཾ ནིརཱམཡཾ ཀརྟྟུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ཏཏོ ཡཱིཤུཿ ཀརཾ པྲསཱཪྻྱ ཏསྱཱངྒཾ སྤྲྀཤན྄ ཝྱཱཛཧཱར, སམྨནྱེ྅ཧཾ ཏྭཾ ནིརཱམཡོ བྷཝ; ཏེན ས ཏཏྐྵཎཱཏ྄ ཀུཥྛེནཱམོཙི། ");
INSERT INTO santib_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ཏཏོ ཡཱིཤུསྟཾ ཛགཱད, ཨཝདྷེཧི ཀཐཱམེཏཱཾ ཀཤྩིདཔི མཱ བྲཱུཧི, ཀིནྟུ ཡཱཛཀསྱ སནྣིདྷིཾ གཏྭཱ སྭཱཏྨཱནཾ དརྴཡ མནུཛེབྷྱོ ནིཛནིརཱམཡཏྭཾ པྲམཱཎཡིཏུཾ མཱུསཱནིརཱུཔིཏཾ དྲཝྱམ྄ ཨུཏྶྲྀཛ ཙ། ");
INSERT INTO santib_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ཏདནནྟརཾ ཡཱིཤུནཱ ཀཕརྣཱཧཱུམྣཱམནི ནགརེ པྲཝིཥྚེ ཀཤྩིཏ྄ ཤཏསེནཱཔཏིསྟཏྶམཱིཔམ྄ ཨཱགཏྱ ཝིནཱིཡ བབྷཱཥེ, ");
INSERT INTO santib_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ཧེ པྲབྷོ, མདཱིཡ ཨེཀོ དཱསཿ པཀྵཱགྷཱཏཝྱཱདྷིནཱ བྷྲྀཤཾ ཝྱཐིཏཿ, སཏུ ཤཡནཱིཡ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ཏདཱནཱིཾ ཡཱིཤུསྟསྨཻ ཀཐིཏཝཱན྄, ཨཧཾ གཏྭཱ ཏཾ ནིརཱམཡཾ ཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ཏཏཿ ས ཤཏསེནཱཔཏིཿ པྲཏྱཝདཏ྄, ཧེ པྲབྷོ, བྷཝཱན྄ ཡཏ྄ མམ གེཧམདྷྱཾ ཡཱཏི ཏདྱོགྱབྷཱཛནཾ ནཱཧམསྨི; ཝཱངྨཱཏྲམ྄ ཨཱདིཤཏུ, ཏེནཻཝ མམ དཱསོ ནིརཱམཡོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ཡཏོ མཡི པརནིདྷྣེ྅པི མམ ནིདེཤཝཤྱཱཿ ཀཏི ཀཏི སེནཱཿ སནྟི, ཏཏ ཨེཀསྨིན྄ ཡཱཧཱིཏྱུཀྟེ ས ཡཱཏི, ཏདནྱསྨིན྄ ཨེཧཱིཏྱུཀྟེ ས ཨཱཡཱཏི, ཏཐཱ མམ ནིཛདཱསེ ཀརྨྨཻཏཏ྄ ཀུཪྻྭིཏྱུཀྟེ ས ཏཏ྄ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ཏདཱནཱིཾ ཡཱིཤུསྟསྱཻཏཏ྄ ཝཙོ ནིཤམྱ ཝིསྨཡཱཔནྣོ྅བྷཱུཏ྄; ནིཛཔཤྩཱདྒཱམིནོ མཱནཝཱན྄ ཨཝོཙྩ, ཡུཥྨཱན྄ ཏཐྱཾ ཝཙྨི, ཨིསྲཱཡེལཱིཡལོཀཱནཱཾ མདྷྱེ྅པི ནཻཏཱདྲྀཤོ ཝིཤྭཱསོ མཡཱ པྲཱཔྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ཨནྱཙྩཱཧཾ ཡུཥྨཱན྄ ཝདཱམི, བཧཝཿ པཱུཪྻྭསྱཱཿ པཤྩིམཱཡཱཤྩ དིཤ ཨཱགཏྱ ཨིབྲཱཧཱིམཱ ཨིསྷཱཀཱ ཡཱཀཱུབཱ ཙ སཱཀམ྄ མིལིཏྭཱ སམུཔཝེཀྵྱནྟི; ");
INSERT INTO santib_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ཀིནྟུ ཡཏྲ སྠཱནེ རོདནདནྟགྷརྵཎེ བྷཝཏསྟསྨིན྄ བཧིརྦྷཱུཏཏམིསྲེ རཱཛྱསྱ སནྟཱནཱ ནིཀྵེསྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ཏཏཿ པརཾ ཡཱིཤུསྟཾ ཤཏསེནཱཔཏིཾ ཛགཱད, ཡཱཧི, ཏཝ པྲཏཱིཏྱནུསཱརཏོ མངྒལཾ བྷཱུཡཱཏ྄; ཏདཱ ཏསྨིནྣེཝ དཎྜེ ཏདཱིཡདཱསོ ནིརཱམཡོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ཨནནྟརཾ ཡཱིཤུཿ པིཏརསྱ གེཧམུཔསྠཱཡ ཛྭརེཎ པཱིཌིཏཱཾ ཤཡནཱིཡསྠིཏཱཾ ཏསྱ ཤྭཤྲཱུཾ ཝཱིཀྵཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ཏཏསྟེན ཏསྱཱཿ ཀརསྱ སྤྲྀཥྚཏཝཱཏ྄ ཛྭརསྟཱཾ ཏཏྱཱཛ, ཏདཱ སཱ སམུཏྠཱཡ ཏཱན྄ སིཥེཝེ། ");
INSERT INTO santib_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ཨནནྟརཾ སནྡྷྱཱཡཱཾ སཏྱཱཾ བཧུཤོ བྷཱུཏགྲསྟམནུཛཱན྄ ཏསྱ སམཱིཔམ྄ ཨཱནིནྱུཿ ས ཙ ཝཱཀྱེན བྷཱུཏཱན྄ ཏྱཱཛཡཱམཱས, སཪྻྭཔྲཀཱརཔཱིཌིཏཛནཱཾཤྩ ནིརཱམཡཱན྄ ཙཀཱར; ");
INSERT INTO santib_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ཏསྨཱཏ྄, སཪྻྭཱ དུརྦྦལཏཱསྨཱཀཾ ཏེནཻཝ པརིདྷཱརིཏཱ། ཨསྨཱཀཾ སཀལཾ ཝྱཱདྷིཾ སཨེཝ སཾགྲྀཧཱིཏཝཱན྄། ཡདེཏདྭཙནཾ ཡིཤཡིཡབྷཝིཥྱདྭཱདིནོཀྟམཱསཱིཏ྄, ཏཏྟདཱ སཕལམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ཨནནྟརཾ ཡཱིཤུཤྩཏུརྡིཀྵུ ཛནནིཝཧཾ ཝིལོཀྱ ཏཊིནྱཱཿ པཱརཾ ཡཱཏུཾ ཤིཥྱཱན྄ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ཏདཱནཱིམ྄ ཨེཀ ཨུཔཱདྷྱཱཡ ཨཱགཏྱ ཀཐིཏཝཱན྄, ཧེ གུརོ, བྷཝཱན྄ ཡཏྲ ཡཱསྱཏི ཏཏྲཱཧམཔི བྷཝཏཿ པཤྩཱད྄ ཡཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ཏཏོ ཡཱིཤུ རྫགཱད, ཀྲོཥྚུཿ སྠཱཏུཾ སྠཱནཾ ཝིདྱཏེ, ཝིཧཱཡསོ ཝིཧངྒམཱནཱཾ ནཱིཌཱནི ཙ སནྟི; ཀིནྟུ མནུཥྱཔུཏྲསྱ ཤིརཿ སྠཱཔཡིཏུཾ སྠཱནཾ ན ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ཨནནྟརམ྄ ཨཔར ཨེཀཿ ཤིཥྱསྟཾ བབྷཱཥེ, ཧེ པྲབྷོ, པྲཐམཏོ མམ པིཏརཾ ཤྨཤཱནེ ནིདྷཱཏུཾ གམནཱརྠཾ མཱམ྄ ཨནུམནྱསྭ། ");
INSERT INTO santib_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ཏཏོ ཡཱིཤུརུཀྟཝཱན྄ མྲྀཏཱ མྲྀཏཱན྄ ཤྨཤཱནེ ནིདདྷཏུ, ཏྭཾ མམ པཤྩཱད྄ ཨཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ཨནནྟརཾ ཏསྨིན྄ ནཱཝམཱརཱུཌྷེ ཏསྱ ཤིཥྱཱསྟཏྤཤྩཱཏ྄ ཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","པཤྩཱཏ྄ སཱགརསྱ མདྷྱཾ ཏེཥུ གཏེཥུ ཏཱདྲྀཤཿ པྲབལོ ཛྷཉྦྷྴནིལ ཨུདཏིཥྛཏ྄, ཡེན མཧཱཏརངྒ ཨུཏྠཱཡ ཏརཎིཾ ཚཱདིཏཝཱན྄, ཀིནྟུ ས ནིདྲིཏ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ཏདཱ ཤིཥྱཱ ཨཱགཏྱ ཏསྱ ནིདྲཱབྷངྒཾ ཀྲྀཏྭཱ ཀཐཡཱམཱསུཿ, ཧེ པྲབྷོ, ཝཡཾ མྲིཡཱམཧེ, བྷཝཱན྄ ཨསྨཱཀཾ པྲཱཎཱན྄ རཀྵཏུ། ");
INSERT INTO santib_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ཏདཱ ས ཏཱན྄ ཨུཀྟཝཱན྄, ཧེ ཨལྤཝིཤྭཱསིནོ ཡཱུཡཾ ཀུཏོ ཝིབྷཱིཐ? ཏཏཿ ས ཨུཏྠཱཡ ཝཱཏཾ སཱགརཉྩ ཏརྫཡཱམཱས, ཏཏོ ནིཪྻྭཱཏམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ཨཔརཾ མནུཛཱ ཝིསྨཡཾ ཝིལོཀྱ ཀཐཡཱམཱསུཿ, ཨཧོ ཝཱཏསརིཏྤཏཱི ཨསྱ ཀིམཱཛྙཱགྲཱཧིཎཽ? ཀཱིདྲྀཤོ྅ཡཾ མཱནཝཿ། ");
INSERT INTO santib_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ཨནནྟརཾ ས པཱརཾ གཏྭཱ གིདེརཱིཡདེཤམ྄ ཨུཔསྠིཏཝཱན྄; ཏདཱ དྭཽ བྷཱུཏགྲསྟམནུཛཽ ཤྨཤཱནསྠཱནཱད྄ བཧི རྦྷཱུཏྭཱ ཏཾ སཱཀྵཱཏ྄ ཀྲྀཏཝནྟཽ, ཏཱཝེཏཱདྲྀཤཽ པྲཙཎྜཱཝཱསྟཱཾ ཡཏ྄ ཏེན སྠཱནེན ཀོཔི ཡཱཏུཾ ནཱཤཀྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ཏཱཝུཙཻཿ ཀཐཡཱམཱསཏུཿ, ཧེ ཨཱིཤྭརསྱ སཱུནོ ཡཱིཤོ, ཏྭཡཱ སཱཀམ྄ ཨཱཝཡོཿ ཀཿ སམྦནྡྷཿ? ནིརཱུཔིཏཀཱལཱཏ྄ པྲཱགེཝ ཀིམཱཝཱབྷྱཱཾ ཡཱཏནཱཾ དཱཏུམ྄ ཨཏྲཱགཏོསི? ");
INSERT INTO santib_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ཏདཱནཱིཾ ཏཱབྷྱཱཾ ཀིཉྩིད྄ དཱུརེ ཝརཱཧཱཎཱམ྄ ཨེཀོ མཧཱཝྲཛོ྅ཙརཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ཏཏོ བྷཱུཏཽ ཏཽ ཏསྱཱནྟིཀེ ཝིནཱིཡ ཀཐཡཱམཱསཏུཿ, ཡདྱཱཝཱཾ ཏྱཱཛཡསི, ཏརྷི ཝརཱཧཱཎཱཾ མདྷྱེཝྲཛམ྄ ཨཱཝཱཾ པྲེརཡ། ");
INSERT INTO santib_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ཏདཱ ཡཱིཤུརཝདཏ྄ ཡཱཏཾ, ཨནནྟརཾ ཏཽ ཡདཱ མནུཛཽ ཝིཧཱཡ ཝརཱཧཱན྄ ཨཱཤྲིཏཝནྟཽ, ཏདཱ ཏེ སཪྻྭེ ཝརཱཧཱ ཨུཙྩསྠཱནཱཏ྄ མཧཱཛཝེན དྷཱཝནྟཿ སཱགརཱིཡཏོཡེ མཛྫནྟོ མམྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ཏཏོ ཝརཱཧརཀྵཀཱཿ པལཱཡམཱནཱ མདྷྱེནགརཾ ཏཽ བྷཱུཏགྲསྟཽ པྲཏི ཡདྱད྄ ཨགྷཊཏ, ཏཱཿ སཪྻྭཝཱརྟྟཱ ཨཝདན྄། ");
INSERT INTO santib_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ཏཏོ ནཱགརིཀཱཿ སཪྻྭེ མནུཛཱ ཡཱིཤུཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ བཧིརཱཡཱཏཱཿ ཏཉྩ ཝིལོཀྱ པྲཱརྠཡཱཉྩཀྲིརེ བྷཝཱན྄ ཨསྨཱཀཾ སཱིམཱཏོ ཡཱཏུ། ");
INSERT INTO santib_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ཨནནྟརཾ ཡཱིཤུ རྣཽཀཱམཱརུཧྱ པུནཿ པཱརམཱགཏྱ ནིཛགྲཱམམ྄ ཨཱཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ཏཏཿ ཀཏིཔཡཱ ཛནཱ ཨེཀཾ པཀྵཱགྷཱཏིནཾ སྭཊྚོཔརི ཤཱཡཡིཏྭཱ ཏཏྶམཱིཔམ྄ ཨཱནཡན྄; ཏཏོ ཡཱིཤུསྟེཥཱཾ པྲཏཱིཏིཾ ཝིཛྙཱཡ ཏཾ པཀྵཱགྷཱཏིནཾ ཛགཱད, ཧེ པུཏྲ, སུསྠིརོ བྷཝ, ཏཝ ཀལུཥསྱ མརྵཎཾ ཛཱཏམ྄། ");
INSERT INTO santib_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ཏཱཾ ཀཐཱཾ ནིཤམྱ ཀིཡནྟ ཨུཔཱདྷྱཱཡཱ མནཿསུ ཙིནྟིཏཝནྟ ཨེཥ མནུཛ ཨཱིཤྭརཾ ནིནྡཏི། ");
INSERT INTO santib_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ཏཏཿ ས ཏེཥཱམ྄ ཨེཏཱདྲྀཤཱིཾ ཙིནྟཱཾ ཝིཛྙཱཡ ཀཐིཏཝཱན྄, ཡཱུཡཾ མནཿསུ ཀྲྀཏ ཨེཏཱདྲྀཤཱིཾ ཀུཙིནྟཱཾ ཀུརུཐ? ");
INSERT INTO santib_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ཏཝ པཱཔམརྵཎཾ ཛཱཏཾ, ཡདྭཱ ཏྭམུཏྠཱཡ གཙྪ, དྭཡོརནཡོ ཪྻཱཀྱཡོཿ ཀིཾ ཝཱཀྱཾ ཝཀྟུཾ སུགམཾ? ");
INSERT INTO santib_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ཀིནྟུ མེདིནྱཱཾ ཀལུཥཾ ཀྵམིཏུཾ མནུཛསུཏསྱ སཱམརྠྱམསྟཱིཏི ཡཱུཡཾ ཡཐཱ ཛཱནཱིཐ, ཏདརྠཾ ས ཏཾ པཀྵཱགྷཱཏིནཾ གདིཏཝཱན྄, ཨུཏྟིཥྛ, ནིཛཤཡནཱིཡཾ ཨཱདཱཡ གེཧཾ གཙྪ། ");
INSERT INTO santib_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ཏཏཿ ས ཏཏྐྵཎཱད྄ ཨུཏྠཱཡ ནིཛགེཧཾ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","མཱནཝཱ ཨིཏྠཾ ཝིལོཀྱ ཝིསྨཡཾ མེནིརེ, ཨཱིཤྭརེཎ མཱནཝཱཡ སཱམརྠྱམ྄ ཨཱིདྲྀཤཾ དཏྟཾ ཨིཏི ཀཱརཎཱཏ྄ ཏཾ དྷནྱཾ བབྷཱཥིརེ ཙ། ");
INSERT INTO santib_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ཨནནྟརཾ ཡཱིཤུསྟཏྶྠཱནཱད྄ གཙྪན྄ གཙྪན྄ ཀརསཾགྲཧསྠཱནེ སམུཔཝིཥྚཾ མཐིནཱམཱནམ྄ ཨེཀཾ མནུཛཾ ཝིལོཀྱ ཏཾ བབྷཱཥེ, མམ པཤྩཱད྄ ཨཱགཙྪ, ཏཏཿ ས ཨུཏྠཱཡ ཏསྱ པཤྩཱད྄ ཝཝྲཱཛ། ");
INSERT INTO santib_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ཏཏཿ པརཾ ཡཱིཤཽ གྲྀཧེ བྷོཀྟུམ྄ ཨུཔཝིཥྚེ བཧཝཿ ཀརསཾགྲཱཧིཎཿ ཀལུཥིཎཤྩ མཱནཝཱ ཨཱགཏྱ ཏེན སཱཀཾ ཏསྱ ཤིཥྱཻཤྩ སཱཀམ྄ ཨུཔཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ཕིརཱུཤིནསྟད྄ དྲྀཥྚྭཱ ཏསྱ ཤིཥྱཱན྄ བབྷཱཥིརེ, ཡུཥྨཱཀཾ གུརུཿ ཀིཾ ནིམིཏྟཾ ཀརསཾགྲཱཧིབྷིཿ ཀལུཥིབྷིཤྩ སཱཀཾ བྷུཾཀྟེ? ");
INSERT INTO santib_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ཡཱིཤུསྟཏ྄ ཤྲུཏྭཱ ཏཱན྄ པྲཏྱཝདཏ྄, ནིརཱམཡལོཀཱནཱཾ ཙིཀིཏྶཀེན པྲཡོཛནཾ ནཱསྟི, ཀིནྟུ སཱམཡལོཀཱནཱཾ པྲཡོཛནམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ཨཏོ ཡཱུཡཾ ཡཱཏྭཱ ཝཙནསྱཱསྱཱརྠཾ ཤིཀྵདྷྭམ྄, དཡཱཡཱཾ མེ ཡཐཱ པྲཱིཏི རྣ ཏཐཱ ཡཛྙཀརྨྨཎི། ཡཏོ྅ཧཾ དྷཱརྨྨིཀཱན྄ ཨཱཧྭཱཏུཾ ནཱགཏོ྅སྨི ཀིནྟུ མནཿ པརིཝརྟྟཡིཏུཾ པཱཔིན ཨཱཧྭཱཏུམ྄ ཨཱགཏོ྅སྨི། ");
INSERT INTO santib_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ཨནནྟརཾ ཡོཧནཿ ཤིཥྱཱསྟསྱ སམཱིཔམ྄ ཨཱགཏྱ ཀཐཡཱམཱསུཿ, ཕིརཱུཤིནོ ཝཡཉྩ པུནཿ པུནརུཔཝསཱམཿ, ཀིནྟུ ཏཝ ཤིཥྱཱ ནོཔཝསནྟི, ཀུཏཿ? ");
INSERT INTO santib_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ཏདཱ ཡཱིཤུསྟཱན྄ ཨཝོཙཏ྄ ཡཱཝཏ྄ སཁཱིནཱཾ སཾངྒེ ཀནྱཱཡཱ ཝརསྟིཥྛཏི, ཏཱཝཏ྄ ཀིཾ ཏེ ཝིལཱཔཾ ཀརྟྟུཾ ཤཀླུཝནྟི? ཀིནྟུ ཡདཱ ཏེཥཱཾ སཾངྒཱད྄ ཝརཾ ནཡནྟི, ཏཱདྲྀཤཿ སམཡ ཨཱགམིཥྱཏི, ཏདཱ ཏེ ཨུཔཝཏྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","པུརཱཏནཝསནེ ཀོཔི ནཝཱིནཝསྟྲཾ ན ཡོཛཡཏི, ཡསྨཱཏ྄ ཏེན ཡོཛིཏེན པུརཱཏནཝསནཾ ཚིནཏྟི ཏཙྪིདྲཉྩ བཧུཀུཏྶིཏཾ དྲྀཤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ཨནྱཉྩ པུརཱཏནཀུཏྭཱཾ ཀོཔི ནཝཱནགོསྟནཱིརསཾ ན ནིདདྷཱཏི, ཡསྨཱཏ྄ ཏཐཱ ཀྲྀཏེ ཀུཏཱུ ཪྻིདཱིཪྻྱཏེ ཏེན གོསྟནཱིརསཿ པཏཏི ཀུཏཱུཤྩ ནཤྱཏི; ཏསྨཱཏ྄ ནཝཱིནཱཡཱཾ ཀུཏྭཱཾ ནཝཱིནོ གོསྟནཱིརསཿ སྠཱཔྱཏེ, ཏེན དྭཡོརཝནཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ཨཔརཾ ཏེནཻཏཏྐཐཱཀཐནཀཱལེ ཨེཀོ྅དྷིཔཏིསྟཾ པྲཎམྱ བབྷཱཥེ, མམ དུཧིཏཱ པྲཱཡེཎཻཏཱཝཏྐཱལེ མྲྀཏཱ, ཏསྨཱད྄ བྷཝཱནཱགཏྱ ཏསྱཱ གཱཏྲེ ཧསྟམརྤཡཏུ, ཏེན སཱ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ཏདཱནཱིཾ ཡཱིཤུཿ ཤིཥྱཻཿ སཱཀམ྄ ཨུཏྠཱཡ ཏསྱ པཤྩཱད྄ ཝཝྲཱཛ། ");
INSERT INTO santib_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ཨིཏྱནནྟརེ དྭཱདཤཝཏྶརཱན྄ ཡཱཝཏ྄ པྲདརཱམཡེན ཤཱིརྞཻཀཱ ནཱརཱི ཏསྱ པཤྩཱད྄ ཨཱགཏྱ ཏསྱ ཝསནསྱ གྲནྠིཾ པསྤརྴ; ");
INSERT INTO santib_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ཡསྨཱཏ྄ མཡཱ ཀེཝལཾ ཏསྱ ཝསནཾ སྤྲྀཥྚྭཱ སྭཱསྠྱཾ པྲཱཔྶྱཏེ, སཱ ནཱརཱིཏི མནསི ནིཤྩིཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ཏཏོ ཡཱིཤུཪྻདནཾ པརཱཝརྟྟྱ ཏཱཾ ཛགཱད, ཧེ ཀནྱེ, ཏྭཾ སུསྠིརཱ བྷཝ, ཏཝ ཝིཤྭཱསསྟྭཱཾ སྭསྠཱམཀཱརྵཱིཏ྄། ཨེཏདྭཱཀྱེ གདིཏཨེཝ སཱ ཡོཥིཏ྄ སྭསྠཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ཨཔརཾ ཡཱིཤུསྟསྱཱདྷྱཀྵསྱ གེཧཾ གཏྭཱ ཝཱདཀཔྲབྷྲྀཏཱིན྄ བཧཱུན྄ ལོཀཱན྄ ཤབྡཱཡམཱནཱན྄ ཝིལོཀྱ ཏཱན྄ ཨཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","པནྠཱནཾ ཏྱཛ, ཀནྱེཡཾ ནཱམྲིཡཏ ནིདྲིཏཱསྟེ; ཀཐཱམེཏཱཾ ཤྲུཏྭཱ ཏེ ཏམུཔཛཧསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ཀིནྟུ སཪྻྭེཥུ བཧིཥྐྲྀཏེཥུ སོ྅བྷྱནྟརཾ གཏྭཱ ཀནྱཱཡཱཿ ཀརཾ དྷྲྀཏཝཱན྄, ཏེན སོདཏིཥྛཏ྄; ");
INSERT INTO santib_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ཏཏསྟཏྐརྨྨཎོ ཡཤཿ ཀྲྀཏྶྣཾ ཏཾ དེཤཾ ཝྱཱཔྟཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ཏཏཿ པརཾ ཡཱིཤུསྟསྨཱཏ྄ སྠཱནཱད྄ ཡཱཏྲཱཾ ཙཀཱར; ཏདཱ ཧེ དཱཡཱུདཿ སནྟཱན, ཨསྨཱན྄ དཡསྭ, ཨིཏི ཝདནྟཽ དྭཽ ཛནཱཝནྡྷཽ པྲོཙཻརཱཧཱུཡནྟཽ ཏཏྤཤྩཱད྄ ཝཝྲཛཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ཏཏོ ཡཱིཤཽ གེཧམདྷྱཾ པྲཝིཥྚཾ ཏཱཝཔི ཏསྱ སམཱིཔམ྄ ཨུཔསྠིཏཝནྟཽ, ཏདཱནཱིཾ ས ཏཽ པྲྀཥྚཝཱན྄ ཀརྨྨཻཏཏ྄ ཀརྟྟུཾ མམ སཱམརྠྱམ྄ ཨཱསྟེ, ཡུཝཱཾ ཀིམིཏི པྲཏཱིཐཿ? ཏདཱ ཏཽ པྲཏྱཱུཙཏུཿ, སཏྱཾ པྲབྷོ། ");
INSERT INTO santib_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ཏདཱནཱིཾ ས ཏཡོ རློཙནཱནི སྤྲྀཤན྄ བབྷཱཥེ, ཡུཝཡོཿ པྲཏཱིཏྱནུསཱརཱད྄ ཡུཝཡོ རྨངྒལཾ བྷཱུཡཱཏ྄། ཏེན ཏཏྐྵཎཱཏ྄ ཏཡོ རྣེཏྲཱཎི པྲསནྣཱནྱབྷཝན྄, ");
INSERT INTO santib_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","པཤྩཱད྄ ཡཱིཤུསྟཽ དྲྀཌྷམཱཛྙཱཔྱ ཛགཱད, ཨཝདྷཏྟམ྄ ཨེཏཱཾ ཀཐཱཾ ཀོཔི མནུཛོ མ ཛཱནཱིཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ཀིནྟུ ཏཽ པྲསྠཱཡ ཏསྨིན྄ ཀྲྀཏྶྣེ དེཤེ ཏསྱ ཀཱིརྟྟིཾ པྲཀཱཤཡཱམཱསཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ཨཔརཾ ཏཽ བཧིཪྻཱཏ ཨེཏསྨིནྣནྟརེ མནུཛཱ ཨེཀཾ བྷཱུཏགྲསྟམཱུཀཾ ཏསྱ སམཱིཔམ྄ ཨཱནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ཏེན བྷཱུཏེ ཏྱཱཛིཏེ ས མཱུཀཿ ཀཐཱཾ ཀཐཡིཏུཾ པྲཱརབྷཏ, ཏེན ཛནཱ ཝིསྨཡཾ ཝིཛྙཱཡ ཀཐཡཱམཱསུཿ, ཨིསྲཱཡེལོ ཝཾཤེ ཀདཱཔི ནེདྲྀགདྲྀཤྱཏ; ");
INSERT INTO santib_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ཀིནྟུ ཕིརཱུཤིནཿ ཀཐཡཱཉྩཀྲུཿ བྷཱུཏཱདྷིཔཏིནཱ ས བྷཱུཏཱན྄ ཏྱཱཛཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ཏཏཿ པརཾ ཡཱིཤུསྟེཥཱཾ བྷཛནབྷཝན ཨུཔདིཤན྄ རཱཛྱསྱ སུསཾཝཱདཾ པྲཙཱརཡན྄ ལོཀཱནཱཾ ཡསྱ ཡ ཨཱམཡོ ཡཱ ཙ པཱིཌཱསཱིཏ྄, ཏཱན྄ ཤམཡན྄ ཤམཡཾཤྩ སཪྻྭཱཎི ནགརཱཎི གྲཱམཱཾཤྩ བབྷྲཱམ། ");
INSERT INTO santib_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ཨནྱཉྩ མནུཛཱན྄ ཝྱཱཀུལཱན྄ ཨརཀྵཀམེཥཱནིཝ ཙ ཏྱཀྟཱན྄ ནིརཱིཀྵྱ ཏེཥུ ཀཱརུཎིཀཿ སན྄ ཤིཥྱཱན྄ ཨཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ཤསྱཱནི པྲཙུརཱཎི སནྟི, ཀིནྟུ ཚེཏྟཱརཿ སྟོཀཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ཀྵེཏྲཾ པྲཏྱཔརཱན྄ ཚེདཀཱན྄ པྲཧེཏུཾ ཤསྱསྭཱམིནཾ པྲཱརྠཡདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ཨནནྟརཾ ཡཱིཤུ རྡྭཱདཤཤིཥྱཱན྄ ཨཱཧཱུཡཱམེདྷྱབྷཱུཏཱན྄ ཏྱཱཛཡིཏུཾ སཪྻྭཔྲཀཱརརོགཱན྄ པཱིཌཱཤྩ ཤམཡིཏུཾ ཏེབྷྱཿ སཱམརྠྱམདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ཏེཥཱཾ དྭཱདཤཔྲེཥྱཱཎཱཾ ནཱམཱནྱེཏཱནི། པྲཐམཾ ཤིམོན྄ ཡཾ པིཏརཾ ཝདནྟི, ཏཏཿ པརཾ ཏསྱ སཧཛ ཨཱནྡྲིཡཿ, སིཝདིཡསྱ པུཏྲོ ཡཱཀཱུབ྄ ");
INSERT INTO santib_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ཏསྱ སཧཛོ ཡོཧན྄; ཕིལིཔ྄ བརྠལམཡ྄ ཐོམཱཿ ཀརསཾགྲཱཧཱི མཐིཿ, ཨཱལྥེཡཔུཏྲོ ཡཱཀཱུབ྄, ");
INSERT INTO santib_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ཀིནཱནཱིཡཿ ཤིམོན྄, ཡ ཨཱིཥྐརིཡོཏཱིཡཡིཧཱུདཱཿ ཁྲཱིཥྚཾ པརཀརེ྅རྤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ཨེཏཱན྄ དྭཱདཤཤིཥྱཱན྄ ཡཱིཤུཿ པྲེཥཡན྄ ཨིཏྱཱཛྙཱཔཡཏ྄, ཡཱུཡམ྄ ཨནྱདེཤཱིཡཱནཱཾ པདཝཱིཾ ཤེམིརོཎཱིཡཱནཱཾ ཀིམཔི ནགརཉྩ ན པྲཝིཤྱེ ");
INSERT INTO santib_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ཨིསྲཱཡེལྒོཏྲསྱ ཧཱརིཏཱ ཡེ ཡེ མེཥཱསྟེཥཱམེཝ སམཱིཔཾ ཡཱཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","གཏྭཱ གཏྭཱ སྭརྒསྱ རཱཛཏྭཾ སཝིདྷམབྷཝཏ྄, ཨེཏཱཾ ཀཐཱཾ པྲཙཱརཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ཨཱམཡགྲསྟཱན྄ སྭསྠཱན྄ ཀུརུཏ, ཀུཥྛིནཿ པརིཥྐུརུཏ, མྲྀཏལོཀཱན྄ ཛཱིཝཡཏ, བྷཱུཏཱན྄ ཏྱཱཛཡཏ, ཝིནཱ མཱུལྱཾ ཡཱུཡམ྄ ཨལབྷདྷྭཾ ཝིནཻཝ མཱུལྱཾ ཝིཤྲཱཎཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ཀིནྟུ སྭེཥཱཾ ཀཊིབནྡྷེཥུ སྭརྞརཱུཔྱཏཱམྲཱཎཱཾ ཀིམཔི ན གྲྀཧླཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ཨནྱཙྩ ཡཱཏྲཱཡཻ ཙེལསམྤུཊཾ ཝཱ དྭིཏཱིཡཝསནཾ ཝཱ པཱདུཀེ ཝཱ ཡཥྚིཿ, ཨེཏཱན྄ མཱ གྲྀཧླཱིཏ, ཡཏཿ ཀཱཪྻྱཀྲྀཏ྄ བྷརྟྟུཾ ཡོགྱོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ཨཔརཾ ཡཱུཡཾ ཡཏ྄ པུརཾ ཡཉྩ གྲཱམཾ པྲཝིཤཐ, ཏཏྲ ཡོ ཛནོ ཡོགྱཔཱཏྲཾ ཏམཝགཏྱ ཡཱནཀཱལཾ ཡཱཝཏ྄ ཏཏྲ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ཡདཱ ཡཱུཡཾ ཏདྒེཧཾ པྲཝིཤཐ, ཏདཱ ཏམཱཤིཥཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ཡདི ས ཡོགྱཔཱཏྲཾ བྷཝཏི, ཏརྷི ཏཏྐལྱཱཎཾ ཏསྨཻ བྷཝིཥྱཏི, ནོཙེཏ྄ སཱཤཱིཪྻུཥྨབྷྱམེཝ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ཀིནྟུ ཡེ ཛནཱ ཡུཥྨཱཀམཱཏིཐྱཾ ན ཝིདདྷཏི ཡུཥྨཱཀཾ ཀཐཱཉྩ ན ཤྲྀཎྭནྟི ཏེཥཱཾ གེཧཱཏ྄ པུརཱདྭཱ པྲསྠཱནཀཱལེ སྭཔདཱུལཱིཿ པཱཏཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ཡུཥྨཱནཧཾ ཏཐྱཾ ཝཙྨི ཝིཙཱརདིནེ ཏཏྤུརསྱ དཤཱཏཿ སིདོམམོརཱཔུརཡོརྡཤཱ སཧྱཏརཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","པཤྱཏ, ཝྲྀཀཡཱུཐམདྷྱེ མེཥཿ ཡཐཱཝིསྟཐཱ ཡུཥྨཱན པྲཧིཎོམི, ཏསྨཱད྄ ཡཱུཡམ྄ ཨཧིརིཝ སཏརྐཱཿ ཀཔོཏཱཨིཝཱཧིཾསཀཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ནྲྀབྷྱཿ སཱཝདྷཱནཱ བྷཝཏ; ཡཏསྟཻ ཪྻཱུཡཾ རཱཛསཾསདི སམརྤིཥྱདྷྭེ ཏེཥཱཾ བྷཛནགེཧེ པྲཧཱརིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ཡཱུཡཾ མནྣཱམཧེཏོཿ ཤཱསྟྲྀཎཱཾ རཱཛྙཱཉྩ སམཀྵཾ ཏཱནནྱདེཤིནཤྩཱདྷི སཱཀྵིཏྭཱརྠམཱནེཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ཀིནྟྭིཏྠཾ སམརྤིཏཱ ཡཱུཡཾ ཀཐཾ ཀིམུཏྟརཾ ཝཀྵྱཐ ཏཏྲ མཱ ཙིནྟཡཏ, ཡཏསྟདཱ ཡུཥྨཱབྷི ཪྻད྄ ཝཀྟཝྱཾ ཏཏ྄ ཏདྡཎྜེ ཡུཥྨནྨནཿ སུ སམུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ཡསྨཱཏ྄ ཏདཱ ཡོ ཝཀྵྱཏི ས ན ཡཱུཡཾ ཀིནྟུ ཡུཥྨཱཀམནྟརསྠཿ པིཏྲཱཏྨཱ། ");
INSERT INTO santib_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","སཧཛཿ སཧཛཾ ཏཱཏཿ སུཏཉྩ མྲྀཏཽ སམརྤཡིཥྱཏི, ཨཔཏྱཱགི སྭསྭཔིཏྲོे ཪྻིཔཀྵཱིབྷཱུཡ ཏཽ གྷཱཏཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","མནྣམཧེཏོཿ སཪྻྭེ ཛནཱ ཡུཥྨཱན྄ ཨྲྀृཏཱིཡིཥྱནྟེ, ཀིནྟུ ཡཿ ཤེཥཾ ཡཱཝད྄ དྷཻཪྻྱཾ གྷྲྀཏྭཱ སྠཱསྱཏི, ས ཏྲཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ཏཻ ཪྻདཱ ཡཱུཡམེཀཔུརེ ཏཱཌིཥྱདྷྭེ, ཏདཱ ཡཱུཡམནྱཔུརཾ པལཱཡདྷྭཾ ཡུཥྨཱནཧཾ ཏཐྱཾ ཝཙྨི ཡཱཝནྨནུཛསུཏོ ནཻཏི ཏཱཝད྄ ཨིསྲཱཡེལྡེཤཱིཡསཪྻྭནགརབྷྲམཎཾ སམཱཔཡིཏུཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","གུརོཿ ཤིཥྱོ ན མཧཱན྄, པྲབྷོརྡཱསོ ན མཧཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ཡདི ཤིཥྱོ ནིཛགུརོ རྡཱསཤྩ སྭཔྲབྷོཿ སམཱནོ བྷཝཏི ཏརྷི ཏད྄ ཡཐེཥྚཾ། ཙེཏྟཻརྒྲྀཧཔཏིརྦྷཱུཏརཱཛ ཨུཙྱཏེ, ཏརྷི པརིཝཱརཱཿ ཀིཾ ཏཐཱ ན ཝཀྵྱནྟེ? ");
INSERT INTO santib_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ཀིནྟུ ཏེབྷྱོ ཡཱུཡཾ མཱ བིབྷཱིཏ, ཡཏོ ཡནྣ པྲཀཱཤིཥྱཏེ, ཏཱདྲྀཀ྄ ཚཱདིཏཾ ཀིམཔི ནཱསྟི, ཡཙྩ ན ཝྱཉྩིཥྱཏེ, ཏཱདྲྀག྄ གུཔྟཾ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ཡདཧཾ ཡུཥྨཱན྄ ཏམསི ཝཙྨི ཏད྄ ཡུཥྨཱབྷིརྡཱིཔྟཽ ཀཐྱཏཱཾ; ཀརྞཱབྷྱཱཾ ཡཏ྄ ཤྲཱུཡཏེ ཏད྄ གེཧོཔརི པྲཙཱཪྻྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ཡེ ཀཱཡཾ ཧནྟུཾ ཤཀྣུཝནྟི ནཱཏྨཱནཾ, ཏེབྷྱོ མཱ བྷཻཥྚ; ཡཿ ཀཱཡཱཏྨཱནཽ ནིརཡེ ནཱཤཡིཏུཾ, ཤཀྣོཏི, ཏཏོ བིབྷཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","དྭཽ ཙཊཀཽ ཀིམེཀཏཱམྲམུདྲཡཱ ན ཝིཀྲཱིཡེཏེ? ཏཐཱཔི ཡུཥྨཏྟཱཏཱནུམཏིཾ ཝིནཱ ཏེཥཱམེཀོཔི བྷུཝི ན པཏཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ཡུཥྨཙྪིརསཱཾ སཪྻྭཀཙཱ གཎིཏཱཾཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ཨཏོ མཱ བིབྷཱིཏ, ཡཱུཡཾ བཧུཙཊཀེབྷྱོ བཧུམཱུལྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ཡོ མནུཛསཱཀྵཱནྨཱམངྒཱིཀུརུཏེ ཏམཧཾ སྭརྒསྠཏཱཏསཱཀྵཱདངྒཱིཀརིཥྱེ། ");
INSERT INTO santib_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","པྲྀཐྭྱཱམཧཾ ཤཱནྟིཾ དཱཏུམཱགཏཨིཏི མཱནུབྷཝཏ, ཤཱནྟིཾ དཱཏུཾ ན ཀིནྟྭསིཾ། ");
INSERT INTO santib_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","པིཏྲྀམཱཏྲྀཤྩཤྲཱུབྷིཿ སཱཀཾ སུཏསུཏཱབདྷཱུ ཪྻིརོདྷཡིཏུཉྩཱགཏེाསྨི། ");
INSERT INTO santib_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ཏཏཿ སྭསྭཔརིཝཱརཨེཝ ནྲྀཤཏྲུ རྦྷཝིཏཱ། ");
INSERT INTO santib_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ཡཿ པིཏརི མཱཏརི ཝཱ མཏྟོདྷིཀཾ པྲཱིཡཏེ, ས ན མདརྷཿ; ");
INSERT INTO santib_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ཡཤྩ སུཏེ སུཏཱཡཱཾ ཝཱ མཏྟོདྷིཀཾ པྲཱིཡཏེ, སེाཔི ན མདརྷཿ། ");
INSERT INTO santib_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ཡཿ སྭཀྲུཤཾ གྲྀཧླན྄ མཏྤཤྩཱནྣཻཏི, སེाཔི ན མདརྷཿ། ");
INSERT INTO santib_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ཡཿ སྭཔྲཱཎཱནཝཏི, ས ཏཱན྄ ཧཱརཡིཥྱཏེ, ཡསྟུ མཏྐྲྀཏེ སྭཔྲཱཎཱན྄ ཧཱརཡཏི, ས ཏཱནཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ཡོ ཡུཥྨཱཀམཱཏིཐྱཾ ཝིདདྷཱཏི, ས མམཱཏིཐྱཾ ཝིདདྷཱཏི, ཡཤྩ མམཱཏིཐྱཾ ཝིདདྷཱཏི, ས མཏྤྲེརཀསྱཱཏིཐྱཾ ཝིདདྷཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ཡོ བྷཝིཥྱདྭཱདཱིཏི ཛྙཱཏྭཱ ཏསྱཱཏིཐྱཾ ཝིདྷཏྟེ, ས བྷཝིཥྱདྭཱདིནཿ ཕལཾ ལཔྶྱཏེ, ཡཤྩ དྷཱརྨྨིཀ ཨིཏི ཝིདིཏྭཱ ཏསྱཱཏིཐྱཾ ཝིདྷཏྟེ ས དྷཱརྨྨིཀམཱནཝསྱ ཕལཾ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ཡཤྩ ཀཤྩིཏ྄ ཨེཏེཥཱཾ ཀྵུདྲནརཱཎཱམ྄ ཡཾ ཀཉྩནཻཀཾ ཤིཥྱ ཨིཏི ཝིདིཏྭཱ ཀཾསཻཀཾ ཤཱིཏལསལིལཾ ཏསྨཻ དཏྟེ, ཡུཥྨཱནཧཾ ཏཐྱཾ ཝདཱམི, ས ཀེནཱཔི པྲཀཱརེཎ ཕལེན ན ཝཉྩིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ཨིཏྠཾ ཡཱིཤུཿ སྭདྭཱདཤཤིཥྱཱཎཱམཱཛྙཱཔནཾ སམཱཔྱ པུརེ པུར ཨུཔདེཥྚུཾ སུསཾཝཱདཾ པྲཙཱརཡིཏུཾ ཏཏྶྠཱནཱཏ྄ པྲཏསྠེ། ");
INSERT INTO santib_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ཨནནྟརཾ ཡོཧན྄ ཀཱརཱཡཱཾ ཏིཥྛན྄ ཁྲིཥྚསྱ ཀརྨྨཎཱཾ ཝཱརྟྟཾ པྲཱཔྱ ཡསྱཱགམནཝཱརྟྟཱསཱིཏ྄ སཨེཝ ཀིཾ ཏྭཾ? ཝཱ ཝཡམནྱམ྄ ཨཔེཀྵིཥྱཱམཧེ? ");
INSERT INTO santib_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ཨེཏཏ྄ པྲཥྚུཾ ནིཛཽ དྭཽ ཤིཥྱཽ པྲཱཧིཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ཡཱིཤུཿ པྲཏྱཝོཙཏ྄, ཨནྡྷཱ ནེཏྲཱཎི ལབྷནྟེ, ཁཉྩཱ གཙྪནྟི, ཀུཥྛིནཿ སྭསྠཱ བྷཝནྟི, བདྷིརཱཿ ཤྲྀཎྭནྟི, མྲྀཏཱ ཛཱིཝནྟ ཨུཏྟིཥྛནྟི, དརིདྲཱཎཱཾ སམཱིཔེ སུསཾཝཱདཿ པྲཙཱཪྻྱཏ, ");
INSERT INTO santib_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ཨེཏཱནི ཡདྱད྄ ཡུཝཱཾ ཤྲྀཎུཐཿ པཤྱཐཤྩ གཏྭཱ ཏདྭཱརྟྟཱཾ ཡོཧནཾ གདཏཾ། ");
INSERT INTO santib_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ཡསྱཱཧཾ ན ཝིགྷྣཱིབྷཝཱམི, སཨེཝ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ཨནནྟརཾ ཏཡོཿ པྲསྠིཏཡོ ཪྻཱིཤུ ཪྻོཧནམ྄ ཨུདྡིཤྱ ཛནཱན྄ ཛགཱད, ཡཱུཡཾ ཀིཾ དྲཥྚུཾ ཝཧིརྨདྷྱེཔྲཱནྟརམ྄ ཨགཙྪཏ? ཀིཾ ཝཱཏེན ཀམྤིཏཾ ནལཾ? ");
INSERT INTO santib_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ཝཱ ཀིཾ ཝཱིཀྵིཏུཾ ཝཧིརྒཏཝནྟཿ? ཀིཾ པརིཧིཏསཱུཀྵྨཝསནཾ མནུཛམེཀཾ? པཤྱཏ, ཡེ སཱུཀྵྨཝསནཱནི པརིདདྷཏི, ཏེ རཱཛདྷཱནྱཱཾ ཏིཥྛནྟི། ");
INSERT INTO santib_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ཏརྷི ཡཱུཡཾ ཀིཾ དྲཥྚུཾ བཧིརགམཏ, ཀིམེཀཾ བྷཝིཥྱདྭཱདིནཾ? ཏདེཝ སཏྱཾ། ཡུཥྨཱནཧཾ ཝདཱམི, ས བྷཝིཥྱདྭཱདིནོཔི མཧཱན྄; ");
INSERT INTO santib_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ཡཏཿ, པཤྱ སྭཀཱིཡདཱུཏོཡཾ ཏྭདགྲེ པྲེཥྱཏེ མཡཱ། ས གཏྭཱ ཏཝ པནྠཱནཾ སྨཡཀ྄ པརིཥྐརིཥྱཏི༎ ཨེཏདྭཙནཾ ཡམདྷི ལིཁིཏམཱསྟེ སོ྅ཡཾ ཡོཧན྄། ");
INSERT INTO santib_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ཨཔརཾ ཡུཥྨཱནཧཾ ཏཐྱཾ བྲཝཱིམི, མཛྫཡིཏུ ཪྻོཧནཿ ཤྲེཥྛཿ ཀོཔི ནཱརཱིཏོ ནཱཛཱཡཏ; ཏཐཱཔི སྭརྒརཱཛྱམདྷྱེ སཪྻྭེབྷྱོ ཡཿ ཀྵུདྲཿ ས ཡོཧནཿ ཤྲེཥྛཿ། ");
INSERT INTO santib_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ཨཔརཉྩ ཨཱ ཡོཧནོ྅དྱ ཡཱཝཏ྄ སྭརྒརཱཛྱཾ བལཱདཱཀྲཱནྟཾ བྷཝཏི ཨཱཀྲམིནཤྩ ཛནཱ བལེན ཏདདྷིཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ཡཏོ ཡོཧནཾ ཡཱཝཏ྄ སཪྻྭབྷཝིཥྱདྭཱདིབྷི ཪྻྱཝསྠཡཱ ཙ ཨུཔདེཤཿ པྲཱཀཱཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ཡདི ཡཱུཡམིདཾ ཝཱཀྱཾ གྲཧཱིཏུཾ ཤཀྣུཐ, ཏརྷི ཤྲེཡཿ, ཡསྱཱགམནསྱ ཝཙནམཱསྟེ སོ྅ཡམ྄ ཨེལིཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ཡསྱ ཤྲོཏུཾ ཀརྞཽ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ཨེཏེ ཝིདྱམཱནཛནཱཿ ཀཻ རྨཡོཔམཱིཡནྟེ? ཡེ བཱལཀཱ ཧཊྚ ཨུཔཝིཤྱ སྭཾ སྭཾ བནྡྷུམཱཧཱུཡ ཝདནྟི, ");
INSERT INTO santib_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ཝཡཾ ཡུཥྨཱཀཾ སམཱིཔེ ཝཾཤཱིརཝཱདཡཱམ, ཀིནྟུ ཡཱུཡཾ ནཱནྲྀཏྱཏ; ཡུཥྨཱཀཾ སམཱིཔེ ཙ ཝཡམརོདིམ, ཀིནྟུ ཡཱུཡཾ ན ཝྱལཔཏ, ཏཱདྲྀཤཻ རྦཱལཀཻསྟ ཨུཔམཱཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ཡཏོ ཡོཧན྄ ཨཱགཏྱ ན བྷུཀྟཝཱན྄ ན པཱིཏཝཱཾཤྩ, ཏེན ལོཀཱ ཝདནྟི, ས བྷཱུཏགྲསྟ ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","མནུཛསུཏ ཨཱགཏྱ བྷུཀྟཝཱན྄ པཱིཏཝཱཾཤྩ, ཏེན ལོཀཱ ཝདནྟི, པཤྱཏ ཨེཥ བྷོཀྟཱ མདྱཔཱཏཱ ཙཎྜཱལཔཱཔིནཱཾ བནྡྷཤྩ, ཀིནྟུ ཛྙཱནིནོ ཛྙཱནཝྱཝཧཱརཾ ནིརྡོཥཾ ཛཱནནྟི། ");
INSERT INTO santib_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ས ཡཏྲ ཡཏྲ པུརེ བཧྭཱཤྩཪྻྱཾ ཀརྨྨ ཀྲྀཏཝཱན྄, ཏནྣིཝཱསིནཱཾ མནཿཔརཱཝྲྀཏྟྱབྷཱཝཱཏ྄ ཏཱནི ནགརཱཎི པྲཏི ཧནྟེཏྱུཀྟཱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ཧཱ ཀོརཱསཱིན྄, ཧཱ བཻཏྶཻདེ, ཡུཥྨནྨདྷྱེ ཡདྱདཱཤྩཪྻྱཾ ཀརྨྨ ཀྲྀཏཾ ཡདི ཏཏ྄ སོརསཱིདོནྣགར ཨཀཱརིཥྱཏ, ཏརྷི པཱུཪྻྭམེཝ ཏནྣིཝཱསིནཿ ཤཱཎཝསནེ བྷསྨནི ཙོཔཝིཤནྟོ མནཱཾསི པརཱཝརྟྟིཥྱནྟ། ");
INSERT INTO santib_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ཏསྨཱདཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཝིཙཱརདིནེ ཡུཥྨཱཀཾ དཤཱཏཿ སོརསཱིདོནོ རྡཤཱ སཧྱཏརཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ཨཔརཉྩ བཏ ཀཕརྣཱཧཱུམ྄, ཏྭཾ སྭརྒཾ ཡཱཝདུནྣཏོསི, ཀིནྟུ ནརཀེ ནིཀྵེཔྶྱསེ, ཡསྨཱཏ྄ ཏྭཡི ཡཱནྱཱཤྩཪྻྱཱཎི ཀརྨྨཎྱཀཱརིཥཏ, ཡདི ཏཱནི སིདོམྣགར ཨཀཱརིཥྱནྟ, ཏརྷི ཏདདྱ ཡཱཝདསྠཱསྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཝིཙཱརདིནེ ཏཝ དཎྜཏཿ སིདོམོ དཎྜོ སཧྱཏརོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ཨེཏསྨིནྣེཝ སམཡེ ཡཱིཤུཿ པུནརུཝཱཙ, ཧེ སྭརྒཔྲྀཐིཝྱོརེཀཱདྷིཔཏེ པིཏསྟྭཾ ཛྙཱནཝཏོ ཝིདུཥཤྩ ལོཀཱན྄ པྲཏྱེཏཱནི ན པྲཀཱཤྱ བཱལཀཱན྄ པྲཏི པྲཀཱཤིཏཝཱན྄, ཨིཏི ཧེཏོསྟྭཱཾ དྷནྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ཧེ པིཏཿ, ཨིཏྠཾ བྷཝེཏ྄ ཡཏ ཨིདཾ ཏྭདྲྀཥྚཱཝུཏྟམཾ། ");
INSERT INTO santib_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","པིཏྲཱ མཡི སཪྻྭཱཎི སམརྤིཏཱནི, པིཏརཾ ཝིནཱ ཀོཔི པུཏྲཾ ན ཛཱནཱཏི, ཡཱན྄ པྲཏི པུཏྲེཎ པིཏཱ པྲཀཱཤྱཏེ ཏཱན྄ ཝིནཱ པུཏྲཱད྄ ཨནྱཿ ཀོཔི པིཏརཾ ན ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ཧེ པརིཤྲཱནྟཱ བྷཱརཱཀྲཱནྟཱཤྩ ལོཀཱ ཡཱུཡཾ མཏྶནྣིདྷིམ྄ ཨཱགཙྪཏ, ཨཧཾ ཡུཥྨཱན྄ ཝིཤྲམཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ཨཧཾ ཀྵམཎཤཱིལོ ནམྲམནཱཤྩ, ཏསྨཱཏ྄ མམ ཡུགཾ སྭེཥཱམུཔརི དྷཱརཡཏ མཏྟཿ ཤིཀྵདྷྭཉྩ, ཏེན ཡཱུཡཾ སྭེ སྭེ མནསི ཝིཤྲཱམཾ ལཔྶྱདྷྦེ། ");
INSERT INTO santib_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ཡཏོ མམ ཡུགམ྄ ཨནཱཡཱསཾ མམ བྷཱརཤྩ ལགྷུཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ཨནནྟརཾ ཡཱིཤུ ཪྻིཤྲཱམཝཱརེ ཤྶྱམདྷྱེན གཙྪཏི, ཏདཱ ཏཙྪིཥྱཱ བུབྷུཀྵིཏཱཿ སནྟཿ ཤྶྱམཉྫརཱིཤྪཏྭཱ ཚིཏྭཱ ཁཱདིཏུམཱརབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ཏད྄ ཝིལོཀྱ ཕིརཱུཤིནོ ཡཱིཤུཾ ཛགདུཿ, པཤྱ ཝིཤྲཱམཝཱརེ ཡཏ྄ ཀརྨྨཱཀརྟྟཝྱཾ ཏདེཝ ཏཝ ཤིཥྱཱཿ ཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ས ཏཱན྄ པྲཏྱཱཝདཏ, དཱཡཱུད྄ ཏཏྶངྒིནཤྩ བུབྷུཀྵིཏཱཿ སནྟོ ཡཏ྄ ཀརྨྨཱཀུཪྻྭན྄ ཏཏ྄ ཀིཾ ཡུཥྨཱབྷི རྣཱཔཱཋི? ");
INSERT INTO santib_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ཡེ དརྴནཱིཡཱཿ པཱུཔཱཿ ཡཱཛཀཱན྄ ཝིནཱ ཏསྱ ཏཏྶངྒིམནུཛཱནཱཉྩཱབྷོཛནཱིཡཱསྟ ཨཱིཤྭརཱཝཱསཾ པྲཝིཥྚེན ཏེན བྷུཀྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ཨནྱཙྩ ཝིཤྲཱམཝཱརེ མདྷྱེམནྡིརཾ ཝིཤྲཱམཝཱརཱིཡཾ ནིཡམཾ ལངྭནྟོཔི ཡཱཛཀཱ ནིརྡོཥཱ བྷཝནྟི, ཤཱསྟྲམདྷྱེ ཀིམིདམཔི ཡུཥྨཱབྷི རྣ པཋིཏཾ? ");
INSERT INTO santib_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ཡུཥྨཱནཧཾ ཝདཱམི, ཨཏྲ སྠཱནེ མནྡིརཱདཔི གརཱིཡཱན྄ ཨེཀ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ཀིནྟུ དཡཱཡཱཾ མེ ཡཐཱ པྲཱིཏི རྣ ཏཐཱ ཡཛྙཀརྨྨཎི། ཨེཏདྭཙནསྱཱརྠཾ ཡདི ཡུཡམ྄ ཨཛྙཱསིཥྚ ཏརྷི ནིརྡོཥཱན྄ དོཥིཎོ ནཱཀཱརྵྚ། ");
INSERT INTO santib_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ཨནྱཙྩ མནུཛསུཏོ ཝིཤྲཱམཝཱརསྱཱཔི པཏིརཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ཨནནྟརཾ ས ཏཏྶྠཱནཱཏ྄ པྲསྠཱཡ ཏེཥཱཾ བྷཛནབྷཝནཾ པྲཝིཥྚཝཱན྄, ཏདཱནཱིམ྄ ཨེཀཿ ཤུཥྐཀརཱམཡཝཱན྄ ཨུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ཏཏོ ཡཱིཤུམ྄ ཨཔཝདིཏུཾ མཱནུཥཱཿ པཔྲཙྪུཿ, ཝིཤྲཱམཝཱརེ ནིརཱམཡཏྭཾ ཀརཎཱིཡཾ ན ཝཱ? ");
INSERT INTO santib_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ཏེན ས པྲཏྱུཝཱཙ, ཝིཤྲཱམཝཱརེ ཡདི ཀསྱཙིད྄ ཨཝི རྒརྟྟེ པཏཏི, ཏརྷི ཡསྟཾ གྷྲྀཏྭཱ ན ཏོལཡཏི, ཨེཏཱདྲྀཤོ མནུཛོ ཡུཥྨཱཀཾ མདྷྱེ ཀ ཨཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ཨཝེ རྨཱནཝཿ ཀིཾ ནཧི ཤྲེཡཱན྄? ཨཏོ ཝིཤྲཱམཝཱརེ ཧིཏཀརྨྨ ཀརྟྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ཨནནྟརཾ ས ཏཾ མཱནཝཾ གདིཏཝཱན྄, ཀརཾ པྲསཱརཡ; ཏེན ཀརེ པྲསཱརིཏེ སོནྱཀརཝཏ྄ སྭསྠོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ཏདཱ ཕིརཱུཤིནོ བཧིརྦྷཱུཡ ཀཐཾ ཏཾ ཧནིཥྱཱམ ཨིཏི ཀུམནྟྲཎཱཾ ཏཏྤྲཱཏིཀཱུལྱེན ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ཏཏོ ཡཱིཤུསྟད྄ ཝིདིཏྭཱ སྠནཱནྟརཾ གཏཝཱན྄; ཨནྱེཥུ བཧུནརེཥུ ཏཏྤཤྩཱད྄ གཏེཥུ ཏཱན྄ ས ནིརཱམཡཱན྄ ཀྲྀཏྭཱ ཨིཏྱཱཛྙཱཔཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ཡཱུཡཾ མཱཾ ན པརིཙཱཡཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ཏསྨཱཏ྄ མམ པྲཱིཡོ མནོནཱིཏོ མནསསྟུཥྚིཀཱརཀཿ། མདཱིཡཿ སེཝཀོ ཡསྟུ ཝིདྱཏེ ཏཾ སམཱིཀྵཏཱཾ། ཏསྱོཔརི སྭཀཱིཡཱཏྨཱ མཡཱ སཾསྠཱཔཡིཥྱཏེ། ཏེནཱནྱདེཤཛཱཏེཥུ ཝྱཝསྠཱ སཾཔྲཀཱཤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ཀེནཱཔི ན ཝིརོདྷཾ ས ཝིཝཱདཉྩ ཀརིཥྱཏི། ན ཙ རཱཛཔཐེ ཏེན ཝཙནཾ ཤྲཱཝཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ཝྱཝསྠཱ ཙལིཏཱ ཡཱཝཏ྄ ནཧི ཏེན ཀརིཥྱཏེ། ཏཱཝཏ྄ ནལོ ཝིདཱིརྞོ྅པི བྷཾཀྵྱཏེ ནཧི ཏེན ཙ། ཏཐཱ སདྷཱུམཝརྟྟིཉྩ ན ས ནིཪྻྭཱཔཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","པྲཏྱཱཤཱཉྩ ཀརིཥྱནྟི ཏནྣཱམྣི བྷིནྣདེཤཛཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ཡཱནྱེཏཱནི ཝཙནཱནི ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཱ པྲོཀྟཱནྱཱསན྄, ཏཱནི སཕལཱནྱབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ཨནནྟརཾ ལོཀཻ སྟཏྶམཱིཔམ྄ ཨཱནཱིཏོ བྷཱུཏགྲསྟཱནྡྷམཱུཀཻཀམནུཛསྟེན སྭསྠཱིཀྲྀཏཿ, ཏཏཿ སོ྅ནྡྷོ མཱུཀོ དྲཥྚུཾ ཝཀྟུཉྩཱརབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ཨནེན སཪྻྭེ ཝིསྨིཏཱཿ ཀཐཡཱཉྩཀྲུཿ, ཨེཥཿ ཀིཾ དཱཡཱུདཿ སནྟཱནོ ནཧི? ");
INSERT INTO santib_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ཀིནྟུ ཕིརཱུཤིནསྟཏ྄ ཤྲུཏྭཱ གདིཏཝནྟཿ, བཱལྶིབཱུབྣཱམྣོ བྷཱུཏརཱཛསྱ སཱཧཱཡྻཾ ཝིནཱ ནཱཡཾ བྷཱུཏཱན྄ ཏྱཱཛཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ཏདཱནཱིཾ ཡཱིཤུསྟེཥཱམ྄ ཨིཏི མཱནསཾ ཝིཛྙཱཡ ཏཱན྄ ཨཝདཏ྄ ཀིཉྩན རཱཛྱཾ ཡདི སྭཝིཔཀྵཱད྄ བྷིདྱཏེ, ཏརྷི ཏཏ྄ ཨུཙྪིདྱཏེ; ཡཙྩ ཀིཉྩན ནགརཾ ཝཱ གྲྀཧཾ སྭཝིཔཀྵཱད྄ ཝིབྷིདྱཏེ, ཏཏ྄ སྠཱཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ཏདྭཏ྄ ཤཡཏཱནོ ཡདི ཤཡཏཱནཾ བཧིཿ ཀྲྀཏྭཱ སྭཝིཔཀྵཱཏ྄ པྲྀཐཀ྄ པྲྀཐཀ྄ བྷཝཏི, ཏརྷི ཏསྱ རཱཛྱཾ ཀེན པྲཀཱརེཎ སྠཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ཨཧཉྩ ཡདི བཱལྶིབཱུབཱ བྷཱུཏཱན྄ ཏྱཱཛཡཱམི, ཏརྷི ཡུཥྨཱཀཾ སནྟཱནཱཿ ཀེན བྷཱུཏཱན྄ ཏྱཱཛཡནྟི? ཏསྨཱད྄ ཡུཥྨཱཀམ྄ ཨེཏདྭིཙཱརཡིཏཱརསྟ ཨེཝ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ཀིནྟཝཧཾ ཡདཱིཤྭརཱཏྨནཱ བྷཱུཏཱན྄ ཏྱཱཛཡཱམི, ཏརྷཱིཤྭརསྱ རཱཛྱཾ ཡུཥྨཱཀཾ སནྣིདྷིམཱགཏཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ཨནྱཉྩ ཀོཔི བལཝནྟ ཛནཾ པྲཐམཏོ ན བདྭྭཱ ཀེན པྲཀཱརེཎ ཏསྱ གྲྀཧཾ པྲཝིཤྱ ཏདྡྲཝྱཱདི ལོཋཡིཏུཾ ཤཀྣོཏི? ཀིནྟུ ཏཏ྄ ཀྲྀཏྭཱ ཏདཱིཡགྲྀསྱ དྲཝྱཱདི ལོཋཡིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ཡཿ ཀཤྩིཏ྄ མམ སྭཔཀྵཱིཡོ ནཧི ས ཝིཔཀྵཱིཡ ཨཱསྟེ, ཡཤྩ མཡཱ སཱཀཾ ན སཾགྲྀཧླཱཏི, ས ཝིཀིརཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ཨཏཨེཝ ཡུཥྨཱནཧཾ ཝདཱམི, མནུཛཱནཱཾ སཪྻྭཔྲཀཱརཔཱཔཱནཱཾ ནིནྡཱཡཱཤྩ མརྵཎཾ བྷཝིཏུཾ ཤཀྣོཏི, ཀིནྟུ པཝིཏྲསྱཱཏྨནོ ཝིརུདྡྷནིནྡཱཡཱ མརྵཎཾ བྷཝིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ཡོ མནུཛསུཏསྱ ཝིརུདྡྷཱཾ ཀཐཱཾ ཀཐཡཏི, ཏསྱཱཔརཱདྷསྱ ཀྵམཱ བྷཝིཏུཾ ཤཀྣོཏི, ཀིནྟུ ཡཿ ཀཤྩིཏ྄ པཝིཏྲསྱཱཏྨནོ ཝིརུདྡྷཱཾ ཀཐཱཾ ཀཐཡཏི ནེཧལོཀེ ན པྲེཏྱ ཏསྱཱཔརཱདྷསྱ ཀྵམཱ བྷཝིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","པཱདཔཾ ཡདི བྷདྲཾ ཝདཐ, ཏརྷི ཏསྱ ཕལམཔི སཱདྷུ ཝཀྟཝྱཾ, ཡདི ཙ པཱདཔཾ ཨསཱདྷུཾ ཝདཐ, ཏརྷི ཏསྱ ཕལམཔྱསཱདྷུ ཝཀྟཝྱཾ; ཡཏཿ སྭཱིཡསྭཱིཡཕལེན པཱདཔཿ པརིཙཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","རེ བྷུཛགཝཾཤཱ ཡཱུཡམསཱདྷཝཿ སནྟཿ ཀཐཾ སཱདྷུ ཝཱཀྱཾ ཝཀྟུཾ ཤཀྵྱཐ? ཡསྨཱད྄ ཨནྟཿཀརཎསྱ པཱུརྞབྷཱཝཱནུསཱརཱད྄ ཝདནཱད྄ ཝཙོ ནིརྒཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ཏེན སཱདྷུརྨཱནཝོ྅ནྟཿཀརཎརཱུཔཱཏ྄ སཱདྷུབྷཱཎྜཱགཱརཱཏ྄ སཱདྷུ དྲཝྱཾ ནིརྒམཡཏི, ཨསཱདྷུརྨཱནུཥསྟྭསཱདྷུབྷཱཎྜཱགཱརཱད྄ ཨསཱདྷུཝསྟཱུནི ནིརྒམཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི, མནུཛཱ ཡཱཝནྟྱཱལསྱཝཙཱཾསི ཝདནྟི, ཝིཙཱརདིནེ ཏདུཏྟརམཝཤྱཾ དཱཏཝྱཾ, ");
INSERT INTO santib_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ཡཏསྟྭཾ སྭཱིཡཝཙོབྷི རྣིརཔརཱདྷཿ སྭཱིཡཝཙོབྷིཤྩ སཱཔརཱདྷོ གཎིཥྱསེ། ");
INSERT INTO santib_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ཏདཱནཱིཾ ཀཏིཔཡཱ ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ ཛགདུཿ, ཧེ གུརོ ཝཡཾ བྷཝཏྟཿ ཀིཉྩན ལཀྵྨ དིདྲྀཀྵཱམཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ཏདཱ ས པྲཏྱུཀྟཝཱན྄, དུཥྚོ ཝྱབྷིཙཱརཱི ཙ ཝཾཤོ ལཀྵྨ མྲྀགཡཏེ, ཀིནྟུ བྷཝིཥྱདྭཱདིནོ ཡཱུནསོ ལཀྵྨ ཝིཧཱཡཱནྱཏ྄ ཀིམཔི ལཀྵྨ ཏེ ན པྲདརྴཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ཡཏོ ཡཱུནམ྄ ཡཐཱ ཏྲྱཧོརཱཏྲཾ བྲྀཧནྨཱིནསྱ ཀུཀྵཱཝཱསཱིཏ྄, ཏཐཱ མནུཛཔུཏྲོཔི ཏྲྱཧོརཱཏྲཾ མེདིནྱཱ མདྷྱེ སྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ཨཔརཾ ནཱིནིཝཱིཡཱ མཱནཝཱ ཝིཙཱརདིན ཨེཏདྭཾཤཱིཡཱནཱཾ པྲཏིཀཱུལམ྄ ཨུཏྠཱཡ ཏཱན྄ དོཥིཎཿ ཀརིཥྱནྟི, ཡསྨཱཏྟེ ཡཱུནས ཨུཔདེཤཱཏ྄ མནཱཾསི པརཱཝརྟྟཡཱཉྩཀྲིརེ, ཀིནྟྭཏྲ ཡཱུནསོཔི གུརུཏར ཨེཀ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","པུནཤྩ དཀྵིཎདེཤཱིཡཱ རཱཛྙཱི ཝིཙཱརདིན ཨེཏདྭཾཤཱིཡཱནཱཾ པྲཏིཀཱུལམུཏྠཱཡ ཏཱན྄ དོཥིཎཿ ཀརིཥྱཏི ཡཏཿ སཱ རཱཛྙཱི སུལེམནོ ཝིདྱཱཡཱཿ ཀཐཱཾ ཤྲོཏུཾ མེདིནྱཱཿ སཱིམྣ ཨཱགཙྪཏ྄, ཀིནྟུ སུལེམནོཔི གུརུཏར ཨེཀོ ཛནོ྅ཏྲ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ཨཔརཾ མནུཛཱད྄ བཧིརྒཏོ ྅པཝིཏྲབྷཱུཏཿ ཤུཥྐསྠཱནེན གཏྭཱ ཝིཤྲཱམཾ གཝེཥཡཏི, ཀིནྟུ ཏདལབྷམཱནཿ ས ཝཀྟི, ཡསྨཱ; ནིཀེཏནཱད྄ ཨཱགམཾ, ཏདེཝ ཝེཤྨ པཀཱཝྲྀཏྱ ཡཱམི། ");
INSERT INTO santib_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","པཤྩཱཏ྄ ས ཏཏ྄ སྠཱནམ྄ ཨུཔསྠཱཡ ཏཏ྄ ཤཱུནྱཾ མཱརྫྫིཏཾ ཤོབྷིཏཉྩ ཝིལོཀྱ ཝྲཛན྄ སྭཏོཔི དུཥྚཏརཱན྄ ཨནྱསཔྟབྷཱུཏཱན྄ སངྒིནཿ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ཏཏསྟེ ཏཏ྄ སྠཱནཾ པྲཝིཤྱ ནིཝསནྟི, ཏེན ཏསྱ མནུཛསྱ ཤེཥདཤཱ པཱུཪྻྭདཤཱཏོཏཱིཝཱཤུབྷཱ བྷཝཏི, ཨེཏེཥཱཾ དུཥྚཝཾཤྱཱནཱམཔི ཏཐཻཝ གྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","མཱནཝེབྷྱ ཨེཏཱསཱཾ ཀཐནཱཾ ཀཐནཀཱལེ ཏསྱ མཱཏཱ སཧཛཱཤྩ ཏེན སཱཀཾ ཀཱཉྩིཏ྄ ཀཐཱཾ ཀཐཡིཏུཾ ཝཱཉྪནྟོ བཧིརེཝ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ཏཏཿ ཀཤྩིཏ྄ ཏསྨཻ ཀཐིཏཝཱན྄, པཤྱ ཏཝ ཛནནཱི སཧཛཱཤྩ ཏྭཡཱ སཱཀཾ ཀཱཉྩན ཀཐཱཾ ཀཐཡིཏུཾ ཀཱམཡམཱནཱ བཧིསྟིཥྛནྟི། ");
INSERT INTO santib_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ཀིནྟུ ས ཏཾ པྲཏྱཝདཏ྄, མམ ཀཱ ཛནནཱི? ཀེ ཝཱ མམ སཧཛཱཿ? ");
INSERT INTO santib_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","པཤྩཱཏ྄ ཤིཥྱཱན྄ པྲཏི ཀརཾ པྲསཱཪྻྱ ཀཐིཏཝཱན྄, པཤྱ མམ ཛནནཱི མམ སཧཛཱཤྩཻཏེ; ");
INSERT INTO santib_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ཡཿ ཀཤྩིཏ྄ མམ སྭརྒསྠསྱ པིཏུརིཥྚཾ ཀརྨྨ ཀུརུཏེ, སཨེཝ མམ བྷྲཱཏཱ བྷགིནཱི ཛནནཱི ཙ། ");
INSERT INTO santib_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ཨཔརཉྩ ཏསྨིན྄ དིནེ ཡཱིཤུཿ སདྨནོ གཏྭཱ སརིཏྤཏེ རོདྷསི སམུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ཏཏྲ ཏཏྶནྣིདྷཽ བཧུཛནཱནཱཾ ནིཝཧོཔསྠིཏེཿ ས ཏརཎིམཱརུཧྱ སམུཔཱཝིཤཏ྄, ཏེན མཱནཝཱ རོདྷསི སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ཏདཱནཱིཾ ས དྲྀཥྚཱནྟཻསྟཱན྄ ཨིཏྠཾ བཧུཤ ཨུཔདིཥྚཝཱན྄། པཤྱཏ, ཀཤྩིཏ྄ ཀྲྀཥཱིཝལོ བཱིཛཱནི ཝཔྟུཾ བཧིརྫགཱམ, ");
INSERT INTO santib_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ཏསྱ ཝཔནཀཱལེ ཀཏིཔཡབཱིཛེཥུ མཱརྒཔཱརྴྭེ པཏིཏེཥུ ཝིཧགཱསྟཱནི བྷཀྵིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ཨཔརཾ ཀཏིཔཡབཱིཛེཥུ སྟོཀམྲྀདྱུཀྟཔཱཥཱཎེ པཏིཏེཥུ མྲྀདལྤཏྭཱཏ྄ ཏཏྐྵཎཱཏ྄ ཏཱནྱངྐུརིཏཱནི, ");
INSERT INTO santib_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ཀིནྟུ རཝཱཝུདིཏེ དགྡྷཱནི ཏེཥཱཾ མཱུལཱཔྲཝིཥྚཏྭཱཏ྄ ཤུཥྐཏཱཾ གཏཱནི ཙ། ");
INSERT INTO santib_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ཨཔརཾ ཀཏིཔཡབཱིཛེཥུ ཀཎྚཀཱནཱཾ མདྷྱེ པཏིཏེཥུ ཀཎྚཀཱནྱེདྷིཏྭཱ ཏཱནི ཛགྲསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ཨཔརཉྩ ཀཏིཔཡབཱིཛཱནི ཨུཪྻྭརཱཡཱཾ པཏིཏཱནི; ཏེཥཱཾ མདྷྱེ ཀཱནིཙིཏ྄ ཤཏགུཎཱནི ཀཱནིཙིཏ྄ ཥཥྚིགུཎཱནི ཀཱནིཙིཏ྄ ཏྲིཾཤགུཾཎཱནི ཕལཱནི ཕལིཏཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ཤྲོཏུཾ ཡསྱ ཤྲུཏཱི ཨཱསཱཏེ ས ཤྲྀཎུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ཨནནྟརཾ ཤིཥྱཻརཱགཏྱ སོ྅པྲྀཙྪྱཏ, བྷཝཏཱ ཏེབྷྱཿ ཀུཏོ དྲྀཥྚཱནྟཀཐཱ ཀཐྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ཏཏཿ ས པྲཏྱཝདཏ྄, སྭརྒརཱཛྱསྱ ནིགཱུཌྷཱཾ ཀཐཱཾ ཝེདིཏུཾ ཡུཥྨབྷྱཾ སཱམརྠྱམདཱཡི, ཀིནྟུ ཏེབྷྱོ ནཱདཱཡི། ");
INSERT INTO santib_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ཡསྨཱད྄ ཡསྱཱནྟིཀེ ཝརྡྡྷཏེ, ཏསྨཱཡེཝ དཱཡིཥྱཏེ, ཏསྨཱཏ྄ ཏསྱ བཱཧུལྱཾ བྷཝིཥྱཏི, ཀིནྟུ ཡསྱཱནྟིཀེ ན ཝརྡྡྷཏེ, ཏསྱ ཡཏ྄ ཀིཉྩནཱསྟེ, ཏདཔི ཏསྨཱད྄ ཨཱདཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ཏེ པཤྱནྟོཔི ན པཤྱནྟི, ཤྲྀཎྭནྟོཔི ན ཤྲྀཎྭནྟི, བུདྷྱམཱནཱ ཨཔི ན བུདྷྱནྟེ ཙ, ཏསྨཱཏ྄ ཏེབྷྱོ དྲྀཥྚཱནྟཀཐཱ ཀཐྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ཡཐཱ ཀརྞཻཿ ཤྲོཥྱཐ ཡཱུཡཾ ཝཻ ཀིནྟུ ཡཱུཡཾ ན བྷོཏྶྱཐ། ནེཏྲཻརྡྲཀྵྱཐ ཡཱུཡཉྩ པརིཛྙཱཏུཾ ན ཤཀྵྱཐ། ཏེ མཱནུཥཱ ཡཐཱ ནཻཝ པརིཔཤྱནྟི ལོཙནཻཿ། ཀརྞཻ ཪྻཐཱ ན ཤྲྀཎྭནྟི ན བུདྷྱནྟེ ཙ མཱནསཻཿ། ཝྱཱཝརྟྟིཏེཥུ ཙིཏྟེཥུ ཀཱལེ ཀུཏྲཱཔི ཏཻརྫནཻཿ། མཏྟསྟེ མནུཛཱཿ སྭསྠཱ ཡཐཱ ནཻཝ བྷཝནྟི ཙ། ཏཐཱ ཏེཥཱཾ མནུཥྱཱཎཱཾ ཀྲིཡནྟེ སྠཱུལབུདྡྷཡཿ། བདྷིརཱིབྷཱུཏཀརྞཱཤྩ ཛཱཏཱཤྩ མུདྲིཏཱ དྲྀཤཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ཡདེཏཱནི ཝཙནཱནི ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཱ པྲོཀྟཱནི ཏེཥུ ཏཱནི ཕལནྟི། ");
INSERT INTO santib_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ཀིནྟུ ཡུཥྨཱཀཾ ནཡནཱནི དྷནྱཱནི, ཡསྨཱཏ྄ ཏཱནི ཝཱིཀྵནྟེ; དྷནྱཱཤྩ ཡུཥྨཱཀཾ ཤབྡགྲཧཱཿ, ཡསྨཱཏ྄ ཏཻརཱཀརྞྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","མཡཱ ཡཱུཡཾ ཏཐྱཾ ཝཙཱམི ཡུཥྨཱབྷི ཪྻདྱད྄ ཝཱིཀྵྱཏེ, ཏད྄ བཧཝོ བྷཝིཥྱདྭཱདིནོ དྷཱརྨྨིཀཱཤྩ མཱནཝཱ དིདྲྀཀྵནྟོཔི དྲཥྚུཾ ནཱལབྷནྟ, པུནཤྩ ཡཱུཡཾ ཡདྱཏ྄ ཤྲྀཎུཐ, ཏཏ྄ ཏེ ཤུཤྲཱུཥམཱཎཱ ཨཔི ཤྲོཏུཾ ནཱལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ཀྲྀཥཱིཝལཱིཡདྲྀཥྚཱནྟསྱཱརྠཾ ཤྲྀཎུཏ། ");
INSERT INTO santib_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","མཱརྒཔཱརྴྭེ བཱིཛཱནྱུཔྟཱནི ཏསྱཱརྠ ཨེཥཿ, ཡདཱ ཀཤྩིཏ྄ རཱཛྱསྱ ཀཐཱཾ ནིཤམྱ ན བུདྷྱཏེ, ཏདཱ པཱཔཱཏྨཱགཏྱ ཏདཱིཡམནས ཨུཔྟཱཾ ཀཐཱཾ ཧརན྄ ནཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ཨཔརཾ པཱཥཱཎསྠལེ བཱིཛཱནྱུཔྟཱནི ཏསྱཱརྠ ཨེཥཿ; ཀཤྩིཏ྄ ཀཐཱཾ ཤྲུཏྭཻཝ ཧརྵཙིཏྟེན གྲྀཧླཱཏི, ");
INSERT INTO santib_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ཀིནྟུ ཏསྱ མནསི མཱུལཱཔྲཝིཥྚཏྭཱཏ྄ ས ཀིཉྩིཏྐཱལམཱཏྲཾ སྠིརསྟིཥྛཏི; པཤྩཱཏ ཏཏྐཐཱཀཱརཎཱཏ྄ ཀོཔི ཀླེསྟཱཌནཱ ཝཱ ཙེཏ྄ ཛཱཡཏེ, ཏརྷི ས ཏཏྐྵཎཱད྄ ཝིགྷྣམེཏི། ");
INSERT INTO santib_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ཨཔརཾ ཀཎྚཀཱནཱཾ མདྷྱེ བཱིཛཱནྱུཔྟཱནི ཏདརྠ ཨེཥཿ; ཀེནཙིཏ྄ ཀཐཱཡཱཾ ཤྲུཏཱཡཱཾ སཱཾསཱརིཀཙིནྟཱབྷི རྦྷྲཱནྟིབྷིཤྩ སཱ གྲསྱཏེ, ཏེན སཱ མཱ ཝིཕལཱ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ཨཔརམ྄ ཨུཪྻྭརཱཡཱཾ བཱིཛཱནྱུཔྟཱནི ཏདརྠ ཨེཥཿ; ཡེ ཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ ཝུདྷྱནྟེ, ཏེ ཕལིཏཱཿ སནྟཿ ཀེཙིཏ྄ ཤཏགུཎཱནི ཀེཙིཏ ཥཥྚིགུཎཱནི ཀེཙིཙྩ ཏྲིཾཤདྒུཎཱནི ཕལཱནི ཛནཡནྟི། ");
INSERT INTO santib_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ཨནནྟརཾ སོཔརཱམེཀཱཾ དྲྀཥྚཱནྟཀཐཱམུཔསྠཱཔྱ ཏེབྷྱཿ ཀཐཡཱམཱས; སྭརྒཱིཡརཱཛྱཾ ཏཱདྲྀཤེན ཀེནཙིད྄ གྲྀཧསྠེནོཔམཱིཡཏེ, ཡེན སྭཱིཡཀྵེཏྲེ པྲཤསྟབཱིཛཱནྱཽཔྱནྟ། ");
INSERT INTO santib_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ཀིནྟུ ཀྵཎདཱཡཱཾ སཀལལོཀེཥུ སུཔྟེཥུ ཏསྱ རིཔུརཱགཏྱ ཏེཥཱཾ གོདྷཱུམབཱིཛཱནཱཾ མདྷྱེ ཝནྱཡཝམབཱིཛཱནྱུཔྟྭཱ ཝཝྲཱཛ། ");
INSERT INTO santib_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ཏཏོ ཡདཱ བཱིཛེབྷྱོ྅ངྐརཱ ཛཱཡམཱནཱཿ ཀཎིཤཱནི གྷྲྀཏཝནྟཿ; ཏདཱ ཝནྱཡཝསཱནྱཔི དྲྀཤྱམཱནཱནྱབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ཏཏོ གྲྀཧསྠསྱ དཱསེཡཱ ཨཱགམྱ ཏསྨཻ ཀཐཡཱཉྩཀྲུཿ, ཧེ མཧེཙྪ, བྷཝཏཱ ཀིཾ ཀྵེཏྲེ བྷདྲབཱིཛཱནི ནཽཔྱནྟ? ཏཐཱཏྭེ ཝནྱཡཝསཱནི ཀྲྀཏ ཨཱཡན྄? ");
INSERT INTO santib_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ཏདཱནཱིཾ ཏེན ཏེ པྲཏིགདིཏཱཿ, ཀེནཙིཏ྄ རིཔུཎཱ ཀརྨྨདམཀཱརི། དཱསེཡཱཿ ཀཐཡཱམཱསུཿ, ཝཡཾ གཏྭཱ ཏཱནྱུཏྤཱཡྻ ཀྵིཔཱམོ བྷཝཏཿ ཀཱིདྲྀཤཱིཙྪཱ ཛཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ཏེནཱཝཱདི, ནཧི, ཤངྐེ྅ཧཾ ཝནྱཡཝསོཏྤཱཊནཀཱལེ ཡུཥྨཱབྷིསྟཻཿ སཱཀཾ གོདྷཱུམཱ ཨཔྱུཏྤཱཊིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ཨཏཿ ཤྶྱཀརྟྟནཀཱལཾ ཡཱཝད྄ ཨུབྷཡཱནྱཔི སཧ ཝརྡྡྷནྟཱཾ, པཤྩཱཏ྄ ཀརྟྟནཀཱལེ ཀརྟྟཀཱན྄ ཝཀྵྱཱམི, ཡཱུཡམཱདཽ ཝནྱཡཝསཱནི སཾགྲྀཧྱ དཱཧཡིཏུཾ ཝཱིཊིཀཱ བདྭྭཱ སྠཱཔཡཏ; ཀིནྟུ སཪྻྭེ གོདྷཱུམཱ ཡུཥྨཱབྷི རྦྷཱཎྜཱགཱརཾ ནཱིཏྭཱ སྠཱཔྱནྟཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ཨནནྟརཾ སོཔརཱམེཀཱཾ དྲྀཥྚཱནྟཀཐཱམུཏྠཱཔྱ ཏེབྷྱཿ ཀཐིཏཝཱན྄ ཀཤྩིནྨནུཛཿ སརྵཔབཱིཛམེཀཾ ནཱིཏྭཱ སྭཀྵེཏྲ ཨུཝཱཔ། ");
INSERT INTO santib_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","སརྵཔབཱིཛཾ སཪྻྭསྨཱད྄ བཱིཛཱཏ྄ ཀྵུདྲམཔི སདངྐུརིཏཾ སཪྻྭསྨཱཏ྄ ཤཱཀཱཏ྄ བྲྀཧད྄ བྷཝཏི; ས ཏཱདྲྀཤསྟརུ རྦྷཝཏི, ཡསྱ ཤཱཁཱསུ ནབྷསཿ ཁགཱ ཨཱགཏྱ ནིཝསནྟི; སྭརྒཱིཡརཱཛྱཾ ཏཱདྲྀཤསྱ སརྵཔཻཀསྱ སམམ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","པུནརཔི ས ཨུཔམཱཀཐཱམེཀཱཾ ཏེབྷྱཿ ཀཐཡཱཉྩཀཱར; ཀཱཙན ཡོཥིཏ྄ ཡཏ྄ ཀིཎྭམཱདཱཡ དྲོཎཏྲཡམིཏགོདྷཱུམཙཱུརྞཱནཱཾ མདྷྱེ སཪྻྭེཥཱཾ མིཤྲཱིབྷཝནཔཪྻྱནྟཾ སམཱཙྪཱདྱ ནིདྷཏྟཝཏཱི, ཏཏྐིཎྭམིཝ སྭརྒརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ཨིཏྠཾ ཡཱིཤུ རྨནུཛནིཝཧཱནཱཾ སནྣིདྷཱཝུཔམཱཀཐཱབྷིརེཏཱནྱཱཁྱཱནཱནི ཀཐིཏཝཱན྄ ཨུཔམཱཾ ཝིནཱ ཏེབྷྱཿ ཀིམཔི ཀཐཱཾ ནཱཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ཨེཏེན དྲྀཥྚཱནྟཱིཡེན ཝཱཀྱེན ཝྱཱདཱཡ ཝདནཾ ནིཛཾ། ཨཧཾ པྲཀཱཤཡིཥྱཱམི གུཔྟཝཱཀྱཾ པུརཱབྷཝཾ། ཡདེཏདྭཙནཾ བྷཝིཥྱདྭཱདིནཱ པྲོཀྟམཱསཱིཏ྄, ཏཏ྄ སིདྡྷམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","སཪྻྭཱན྄ མནུཛཱན྄ ཝིསྲྀཛྱ ཡཱིཤཽ གྲྀཧཾ པྲཝིཥྚེ ཏཙྪིཥྱཱ ཨཱགཏྱ ཡཱིཤཝེ ཀཐིཏཝནྟཿ, ཀྵེཏྲསྱ ཝནྱཡཝསཱིཡདྲྀཥྚཱནྟཀཐཱམ྄ བྷཝཱན ཨསྨཱན྄ སྤཥྚཱིཀྲྀཏྱ ཝདཏུ། ");
INSERT INTO santib_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ཏཏཿ ས པྲཏྱུཝཱཙ, ཡེན བྷདྲབཱིཛཱནྱུཔྱནྟེ ས མནུཛཔུཏྲཿ, ");
INSERT INTO santib_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ཀྵེཏྲཾ ཛགཏ྄, བྷདྲབཱིཛཱནཱི རཱཛྱསྱ སནྟཱནཱཿ, ");
INSERT INTO santib_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ཝནྱཡཝསཱནི པཱཔཱཏྨནཿ སནྟཱནཱཿ། ཡེན རིཔུཎཱ ཏཱནྱུཔྟཱནི ས ཤཡཏཱནཿ, ཀརྟྟནསམཡཤྩ ཛགཏཿ ཤེཥཿ, ཀརྟྟཀཱཿ སྭརྒཱིཡདཱུཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ཡཐཱ ཝནྱཡཝསཱནི སཾགྲྀཧྱ དཱཧྱནྟེ, ཏཐཱ ཛགཏཿ ཤེཥེ བྷཝིཥྱཏི; ");
INSERT INTO santib_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ཨརྠཱཏ྄ མནུཛསུཏཿ སྭཱཾཡདཱུཏཱན྄ པྲེཥཡིཥྱཏི, ཏེན ཏེ ཙ ཏསྱ རཱཛྱཱཏ྄ སཪྻྭཱན྄ ཝིགྷྣཀཱརིཎོ྅དྷཱརྨྨིཀལོཀཱཾཤྩ སཾགྲྀཧྱ ");
INSERT INTO santib_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ཡཏྲ རོདནཾ དནྟགྷརྵཎཉྩ བྷཝཏི, ཏཏྲཱགྣིཀུཎྜེ ནིཀྵེཔྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ཏདཱནཱིཾ དྷཱརྨྨིཀལོཀཱཿ སྭེཥཱཾ པིཏཱུ རཱཛྱེ བྷཱསྐརཨིཝ ཏེཛསྭིནོ བྷཝིཥྱནྟི། ཤྲོཏུཾ ཡསྱ ཤྲུཏཱི ཨཱསཱཏེ, མ ཤྲྀཎུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ཨཔརཉྩ ཀྵེཏྲམདྷྱེ ནིདྷིཾ པཤྱན྄ ཡོ གོཔཡཏི, ཏཏཿ པརཾ སཱནནྡོ གཏྭཱ སྭཱིཡསཪྻྭསྭཾ ཝིཀྲཱིཡ ཏྟཀྵེཏྲཾ ཀྲཱིཎཱཏི, ས ཨིཝ སྭརྒརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ཨནྱཉྩ ཡོ ཝཎིཀ྄ ཨུཏྟམཱཾ མུཀྟཱཾ གཝེཥཡན྄ ");
INSERT INTO santib_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","མཧཱརྒྷཱཾ མུཀྟཱཾ ཝིལོཀྱ ནིཛསཪྻྭསྭཾ ཝིཀྲཱིཡ ཏཱཾ ཀྲཱིཎཱཏི, ས ཨིཝ སྭརྒརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","པུནཤྩ སམུདྲོ ནིཀྵིཔྟཿ སཪྻྭཔྲཀཱརམཱིནསཾགྲཱཧྱཱནཱཡཨིཝ སྭརྒརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ཏསྨིན྄ ཨཱནཱཡེ པཱུརྞེ ཛནཱ ཡཐཱ རོདྷསྱུཏྟོལྱ སམུཔཝིཤྱ པྲཤསྟམཱིནཱན྄ སཾགྲཧྱ བྷཱཛནེཥུ ནིདདྷཏེ, ཀུཏྶིཏཱན྄ ནིཀྵིཔནྟི; ");
INSERT INTO santib_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ཏཐཻཝ ཛགཏཿ ཤེཥེ བྷཝིཥྱཏི, ཕལཏཿ སྭརྒཱིཡདཱུཏཱ ཨཱགཏྱ པུཎྱཝཛྫནཱནཱཾ མདྷྱཱཏ྄ པཱཔིནཿ པྲྀཐཀ྄ ཀྲྀཏྭཱ ཝཧྣིཀུཎྜེ ནིཀྵེཔྶྱནྟི, ");
INSERT INTO santib_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ཏཏྲ རོདནཾ དནྟཻ རྡནྟགྷརྵཎཉྩ བྷཝིཥྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ཡཱིཤུནཱ ཏེ པྲྀཥྚཱ ཡུཥྨཱབྷིཿ ཀིམེཏཱནྱཱཁྱཱནཱནྱབུདྷྱནྟ? ཏདཱ ཏེ པྲཏྱཝདན྄, སཏྱཾ པྲབྷོ། ");
INSERT INTO santib_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ཏདཱནཱིཾ ས ཀཐིཏཝཱན྄, ནིཛབྷཱཎྜཱགཱརཱཏ྄ ནཝཱིནཔུརཱཏནཱནི ཝསྟཱུནི ནིརྒམཡཏི ཡོ གྲྀཧསྠཿ ས ཨིཝ སྭརྒརཱཛྱམདྷི ཤིཀྵིཏཱཿ སྭཪྻ ཨུཔདེཥྚཱརཿ། ");
INSERT INTO santib_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ཨནནྟརཾ ཡཱིཤུརེཏཱཿ སཪྻྭཱ དྲྀཥྚཱནྟཀཐཱཿ སམཱཔྱ ཏསྨཱཏ྄ སྠཱནཱཏ྄ པྲཏསྠེ། ཨཔརཾ སྭདེཤམཱགཏྱ ཛནཱན྄ བྷཛནབྷཝན ཨུཔདིཥྚཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ཏེ ཝིསྨཡཾ གཏྭཱ ཀཐིཏཝནྟ ཨེཏསྱཻཏཱདྲྀཤཾ ཛྙཱནམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ ཙ ཀསྨཱད྄ ཨཛཱཡཏ? ");
INSERT INTO santib_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ཀིམཡཾ སཱུཏྲདྷཱརསྱ པུཏྲོ ནཧི? ཨེཏསྱ མཱཏུ རྣཱམ ཙ ཀིཾ མརིཡམ྄ ནཧི? ཡཱཀུབ྄-ཡཱུཥཕ྄-ཤིམོན྄-ཡིཧཱུདཱཤྩ ཀིམེཏསྱ བྷྲཱཏརོ ནཧི? ");
INSERT INTO santib_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ཨེཏསྱ བྷགིནྱཤྩ ཀིམསྨཱཀཾ མདྷྱེ ན སནྟི? ཏརྷི ཀསྨཱདཡམེཏཱནི ལབྡྷཝཱན྄? ཨིཏྠཾ ས ཏེཥཱཾ ཝིགྷྣརཱུཔོ བབྷཱུཝ; ");
INSERT INTO santib_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ཏཏོ ཡཱིཤུནཱ ནིགདིཏཾ སྭདེཤཱིཡཛནཱནཱཾ མདྷྱཾ ཝིནཱ བྷཝིཥྱདྭཱདཱི ཀུཏྲཱཔྱནྱཏྲ ནཱསམྨཱནྱོ བྷཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ཏེཥཱམཝིཤྭཱསཧེཏོཿ ས ཏཏྲ སྠཱནེ བཧྭཱཤྩཪྻྱཀརྨྨཱཎི ན ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ཏདཱནཱིཾ རཱཛཱ ཧེརོད྄ ཡཱིཤོ ཪྻཤཿ ཤྲུཏྭཱ ནིཛདཱསེཡཱན྄ ཛགཱད྄, ");
INSERT INTO santib_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ཨེཥ མཛྫཡིཏཱ ཡོཧན྄, པྲམིཏེབྷཡསྟསྱོཏྠཱནཱཏ྄ ཏེནེཏྠམདྦྷུཏཾ ཀརྨྨ པྲཀཱཤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","པུརཱ ཧེརོད྄ ནིཛབྷྲཱཏུ: ཕིལིཔོ ཛཱཡཱཡཱ ཧེརོདཱིཡཱཡཱ ཨནུརོདྷཱད྄ ཡོཧནཾ དྷཱརཡིཏྭཱ བདྡྷཱ ཀཱརཱཡཱཾ སྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ཡཏོ ཡོཧན྄ ཨུཀྟཝཱན྄, ཨེཏྶཡཱཿ སཾགྲཧོ བྷཝཏོ ནོཙིཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ཏསྨཱཏ྄ ནྲྀཔཏིསྟཾ ཧནྟུམིཙྪནྣཔི ལོཀེབྷྱོ ཝིབྷཡཱཉྩཀཱར; ཡཏཿ སཪྻྭེ ཡོཧནཾ བྷཝིཥྱདྭཱདིནཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ཀིནྟུ ཧེརོདོ ཛནྨཱཧཱིཡམཧ ཨུཔསྠིཏེ ཧེརོདཱིཡཱཡཱ དུཧིཏཱ ཏེཥཱཾ སམཀྵཾ ནྲྀཏིཏྭཱ ཧེརོདམཔྲཱིཎྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ཏསྨཱཏ྄ བྷཱུཔཏིཿ ཤཔཐཾ ཀུཪྻྭན྄ ཨིཏི པྲཏྱཛྙཱསཱིཏ྄, ཏྭཡཱ ཡད྄ ཡཱཙྱཏེ, ཏདེཝཱཧཾ དཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","སཱ ཀུམཱརཱི སྭཱིཡམཱཏུཿ ཤིཀྵཱཾ ལབྡྷཱ བབྷཱཥེ, མཛྫཡིཏུཪྻོཧན ཨུཏྟམཱངྒཾ བྷཱཛནེ སམཱནཱིཡ མཧྱཾ ཝིཤྲཱཎཡ། ");
INSERT INTO santib_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ཏཏོ རཱཛཱ ཤུཤོཙ, ཀིནྟུ བྷོཛནཱཡོཔཝིཤཏཱཾ སངྒིནཱཾ སྭཀྲྀཏཤཔཐསྱ ཙཱནུརོདྷཱཏ྄ ཏཏ྄ པྲདཱཏུམ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","པཤྩཱཏ྄ ཀཱརཱཾ པྲཏི ནརཾ པྲཧིཏྱ ཡོཧན ཨུཏྟམཱངྒཾ ཚིཏྟྭཱ ");
INSERT INTO santib_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ཏཏ྄ བྷཱཛན ཨཱནཱཡྻ ཏསྱཻ ཀུམཱཪྻྱཻ ཝྱཤྲཱཎཡཏ྄, ཏཏཿ སཱ སྭཛནནྱཱཿ སམཱིཔཾ ཏནྣིནཱཡ། ");
INSERT INTO santib_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","པཤྩཱཏ྄ ཡོཧནཿ ཤིཥྱཱ ཨཱགཏྱ ཀཱཡཾ ནཱིཏྭཱ ཤྨཤཱནེ སྠཱཔཡཱམཱསུསྟཏོ ཡཱིཤོཿ སནྣིདྷིཾ ཝྲཛིཏྭཱ ཏདྭཱརྟྟཱཾ བབྷཱཥིརེ། ");
INSERT INTO santib_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ཨནནྟརཾ ཡཱིཤུརིཏི ནིཤབྷྱ ནཱཝཱ ནིརྫནསྠཱནམ྄ ཨེཀཱཀཱི གཏཝཱན྄, པཤྩཱཏ྄ མཱནཝཱསྟཏ྄ ཤྲུཏྭཱ ནཱནཱནགརེབྷྱ ཨཱགཏྱ པདཻསྟཏྤཤྩཱད྄ ཨཱིཡུཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ཏདཱནཱིཾ ཡཱིཤུ རྦཧིརཱགཏྱ མཧཱནྟཾ ཛནནིཝཧཾ ནིརཱིཀྵྱ ཏེཥུ ཀཱརུཎིཀཿ མན྄ ཏེཥཱཾ པཱིཌིཏཛནཱན྄ ནིརཱམཡཱན྄ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ཏཏཿ པརཾ སནྡྷྱཱཡཱཾ ཤིཥྱཱསྟདནྟིཀམཱགཏྱ ཀཐཡཱཉྩཀྲུཿ, ཨིདཾ ནིརྫནསྠཱནཾ ཝེལཱཔྱཝསནྣཱ; ཏསྨཱཏ྄ མནུཛཱན྄ སྭསྭགྲཱམཾ གནྟུཾ སྭཱརྠཾ བྷཀྵྱཱཎི ཀྲེཏུཉྩ བྷཝཱན྄ ཏཱན྄ ཝིསྲྀཛཏུ། ");
INSERT INTO santib_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ཀིནྟུ ཡཱིཤུསྟཱནཝཱདཱིཏ྄, ཏེཥཱཾ གམནེ པྲཡོཛནཾ ནཱསྟི, ཡཱུཡམེཝ ཏཱན྄ བྷོཛཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ཏདཱ ཏེ པྲཏྱཝདན྄, ཨསྨཱཀམཏྲ པཱུཔཔཉྩཀཾ མཱིནདྭཡཉྩཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ཏདཱནཱིཾ ཏེནོཀྟཾ ཏཱནི མདནྟིཀམཱནཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ཨནནྟརཾ ས མནུཛཱན྄ ཡཝསོཔཪྻྱུཔཝེཥྚུམ྄ ཨཱཛྙཱཔཡཱམཱས; ཨཔར ཏཏ྄ པཱུཔཔཉྩཀཾ མཱིནདྭཡཉྩ གྲྀཧླན྄ སྭརྒཾ པྲཏི ནིརཱིཀྵྱེཤྭརཱིཡགུཎཱན྄ ཨནཱུདྱ བྷཾཀྟྭཱ ཤིཥྱེབྷྱོ དཏྟཝཱན྄, ཤིཥྱཱཤྩ ལོཀེབྷྱོ དདུཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ཏཏཿ སཪྻྭེ བྷུཀྟྭཱ པརིཏྲྀཔྟཝནྟཿ, ཏཏསྟདཝཤིཥྚབྷཀྵྱཻཿ པཱུརྞཱན྄ དྭཱདཤཌལཀཱན྄ གྲྀཧཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ཏེ བྷོཀྟཱརཿ སྟྲཱིརྦཱལཀཱཾཤྩ ཝིཧཱཡ པྲཱཡེཎ པཉྩ སཧསྲཱཎི པུམཱཾས ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ཏདནནྟརཾ ཡཱིཤུ རློཀཱནཱཾ ཝིསརྫནཀཱལེ ཤིཥྱཱན྄ ཏརཎིམཱརོཌྷུཾ སྭཱགྲེ པཱརཾ ཡཱཏུཉྩ གཱཌྷམཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ཏཏོ ལོཀེཥུ ཝིསྲྀཥྚེཥུ ས ཝིཝིཀྟེ པྲཱརྠཡིཏུཾ གིརིམེཀཾ གཏྭཱ སནྡྷྱཱཾ ཡཱཝཏ྄ ཏཏྲཻཀཱཀཱི སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ཀིནྟུ ཏདཱནཱིཾ སམྨུཁཝཱཏཏྭཱཏ྄ སརིཏྤཏེ རྨདྷྱེ ཏརངྒཻསྟརཎིརྡོལཱཡམཱནཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ཏདཱ ས ཡཱམིནྱཱཤྩཏུརྠཔྲཧརེ པདྦྷྱཱཾ ཝྲཛན྄ ཏེཥཱམནྟིཀཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ཀིནྟུ ཤིཥྱཱསྟཾ སཱགརོཔརི ཝྲཛནྟཾ ཝིལོཀྱ སམུདྭིགྣཱ ཛགདུཿ, ཨེཥ བྷཱུཏ ཨིཏི ཤངྐམཱནཱ ཨུཙྩཻཿ ཤབྡཱཡཱཉྩཀྲིརེ ཙ། ");
INSERT INTO santib_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ཏདཻཝ ཡཱིཤུསྟཱནཝདཏ྄, སུསྠིརཱ བྷཝཏ, མཱ བྷཻཥྚ, ཨེཥོ྅ཧམ྄། ");
INSERT INTO santib_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ཏཏཿ པིཏར ཨིཏྱུཀྟཝཱན྄, ཧེ པྲབྷོ, ཡདི བྷཝཱནེཝ, ཏརྷི མཱཾ བྷཝཏྶམཱིཔཾ ཡཱཏུམཱཛྙཱཔཡཏུ། ");
INSERT INTO santib_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ཏཏཿ ཏེནཱདིཥྚཿ པིཏརསྟརཎིཏོ྅ཝརུཧྱ ཡཱིཤེाརནྟིཀཾ པྲཱཔྟུཾ ཏོཡོཔརི ཝཝྲཱཛ། ");
INSERT INTO santib_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ཀིནྟུ པྲཙཎྜཾ པཝནཾ ཝིལོཀྱ བྷཡཱཏ྄ ཏོཡེ མཾཀྟུམ྄ ཨཱརེབྷེ, ཏསྨཱད྄ ཨུཙྩཻཿ ཤབྡཱཡམཱནཿ ཀཐིཏཝཱན྄, ཧེ པྲབྷོ, མཱམཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ཡཱིཤུསྟཏྐྵཎཱཏ྄ ཀརཾ པྲསཱཪྻྱ ཏཾ དྷརན྄ ཨུཀྟཝཱན྄, ཧ སྟོཀཔྲཏྱཡིན྄ ཏྭཾ ཀུཏཿ སམཤེཐཱཿ? ");
INSERT INTO santib_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ཨནནྟརཾ ཏཡོསྟརཎིམཱརཱུཌྷཡོཿ པཝནོ ནིཝཝྲྀཏེ། ");
INSERT INTO santib_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ཏདཱནཱིཾ ཡེ ཏརཎྱཱམཱསན྄, ཏ ཨཱགཏྱ ཏཾ པྲཎབྷྱ ཀཐིཏཝནྟཿ, ཡཐཱརྠསྟྭམེཝེཤྭརསུཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ཨནནྟརཾ པཱརཾ པྲཱཔྱ ཏེ གིནེཥརནྣཱམཀཾ ནགརམུཔཏསྠུཿ, ");
INSERT INTO santib_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ཏདཱ ཏཏྲཏྱཱ ཛནཱ ཡཱིཤུཾ པརིཙཱིཡ ཏདྡེཤྶྱ ཙཏུརྡིཤོ ཝཱརྟྟཱཾ པྲཧིཏྱ ཡཏྲ ཡཱཝནྟཿ པཱིཌིཏཱ ཨཱསན྄, ཏཱཝཏཨེཝ ཏདནྟིཀམཱནཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ཨཔརཾ ཏདཱིཡཝསནསྱ གྲནྠིམཱཏྲཾ སྤྲཥྚུཾ ཝིནཱིཡ ཡཱཝནྟོ ཛནཱསྟཏ྄ སྤརྴཾ ཙཀྲིརེ, ཏེ སཪྻྭཨེཝ ནིརཱམཡཱ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ཨཔརཾ ཡིརཱུཤཱལམྣགརཱིཡཱཿ ཀཏིཔཡཱ ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ ཡཱིཤོཿ སམཱིཔམཱགཏྱ ཀཐཡཱམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ཏཝ ཤིཥྱཱཿ ཀིམརྠམ྄ ཨཔྲཀྵཱལིཏཀརཻ རྦྷཀྵིཏྭཱ པརམྤརཱགཏཾ པྲཱཙཱིནཱནཱཾ ཝྱཝཧཱརཾ ལངྭནྟེ? ");
INSERT INTO santib_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ཏཏོ ཡཱིཤུཿ པྲཏྱུཝཱཙ, ཡཱུཡཾ པརམྤརཱགཏཱཙཱརེཎ ཀུཏ ཨཱིཤྭརཱཛྙཱཾ ལངྭདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ཨཱིཤྭར ཨིཏྱཱཛྙཱཔཡཏ྄, ཏྭཾ ནིཛཔིཏརཽ སཾམནྱེཐཱཿ, ཡེན ཙ ནིཛཔིཏརཽ ནིནྡྱེཏེ, ས ནིཤྩིཏཾ མྲིཡེཏ; ");
INSERT INTO santib_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ཀིནྟུ ཡཱུཡཾ ཝདཐ, ཡཿ སྭཛནཀཾ སྭཛནནཱིཾ ཝཱ ཝཱཀྱམིདཾ ཝདཏི, ཡུཝཱཾ མཏྟོ ཡལླབྷེཐེ, ཏཏ྄ ནྱཝིདྱཏ, ");
INSERT INTO santib_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ས ནིཛཔིཏརཽ པུན རྣ སཾམཾསྱཏེ། ཨིཏྠཾ ཡཱུཡཾ པརམྤརཱགཏེན སྭེཥཱམཱཙཱརེཎེཤྭརཱིཡཱཛྙཱཾ ལུམྤཐ། ");
INSERT INTO santib_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","རེ ཀཔཊིནཿ སཪྻྭེ ཡིཤཡིཡོ ཡུཥྨཱནདྷི བྷཝིཥྱདྭཙནཱནྱེཏཱནི སམྱག྄ ཨུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ཝདནཻ རྨནུཛཱ ཨེཏེ སམཱཡཱནྟི མདནྟིཀཾ། ཏཐཱདྷརཻ རྨདཱིཡཉྩ མཱནཾ ཀུཪྻྭནྟི ཏེ ནརཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ཀིནྟུ ཏེཥཱཾ མནོ མཏྟོ ཝིདཱུརཨེཝ ཏིཥྛཏི། ཤིཀྵཡནྟོ ཝིདྷཱིན྄ ནྲཱཛྙཱ བྷཛནྟེ མཱཾ མུདྷཻཝ ཏེ། ");
INSERT INTO santib_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ཏཏོ ཡཱིཤུ རློཀཱན྄ ཨཱཧཱུཡ པྲོཀྟཝཱན྄, ཡཱུཡཾ ཤྲུཏྭཱ བུདྷྱདྷྦཾ། ");
INSERT INTO santib_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ཡནྨུཁཾ པྲཝིཤཏི, ཏཏ྄ མནུཛམ྄ ཨམེདྷྱཾ ན ཀརོཏི, ཀིནྟུ ཡདཱསྱཱཏ྄ ནིརྒཙྪཏི, ཏདེཝ མཱནུཥམམེདྷྱཱི ཀརོཏཱི། ");
INSERT INTO santib_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ཏདཱནཱིཾ ཤིཥྱཱ ཨཱགཏྱ ཏསྨཻ ཀཐཡཱཉྩཀྲུཿ, ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ ཕིརཱུཤིནོ ཝྱརཛྱནྟ, ཏཏ྄ ཀིཾ བྷཝཏཱ ཛྙཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ས པྲཏྱཝདཏ྄, མམ སྭརྒསྠཿ པིཏཱ ཡཾ ཀཉྩིདངྐུརཾ ནཱརོཔཡཏ྄, ས ཨུཏྤཱཝྡྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ཏེ ཏིཥྛནྟུ, ཏེ ཨནྡྷམནུཛཱནཱམ྄ ཨནྡྷམཱརྒདརྴཀཱ ཨེཝ; ཡདྱནྡྷོ྅ནྡྷཾ པནྠཱནཾ དརྴཡཏི, ཏརྷྱུབྷཽ གརྟྟེ པཏཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ཏདཱ པིཏརསྟཾ པྲཏྱཝདཏ྄, དྲྀཥྚཱནྟམིམམསྨཱན྄ བོདྷཡཏུ། ");
INSERT INTO santib_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ཡཱིཤུནཱ པྲོཀྟཾ, ཡཱུཡམདྱ ཡཱཝཏ྄ ཀིམབོདྷཱཿ སྠ? ");
INSERT INTO santib_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ཀཐཱམིམཱཾ ཀིཾ ན བུདྷྱདྷྦེ ? ཡདཱསྱཾ པྲེཝིཤཏི, ཏད྄ ཨུདརེ པཏན྄ བཧིརྣིཪྻཱཏི, ");
INSERT INTO santib_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ཀིནྟྭཱསྱཱད྄ ཡནྣིཪྻཱཏི, ཏད྄ ཨནྟཿཀརཎཱཏ྄ ནིཪྻཱཏཏྭཱཏ྄ མནུཛམམེདྷྱཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ཡཏོ྅ནྟཿཀརཎཱཏ྄ ཀུཙིནྟཱ བདྷཿ པཱརདཱརིཀཏཱ ཝེཤྱཱགམནཾ ཙཻཪྻྱཾ མིཐྱཱསཱཀྵྱམ྄ ཨཱིཤྭརནིནྡཱ ཙཻཏཱནི སཪྻྭཱཎི ནིཪྻྱཱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ཨེཏཱནི མནུཥྱམཔཝིཏྲཱི ཀུཪྻྭནྟི ཀིནྟྭཔྲཀྵཱལིཏཀརེཎ བྷོཛནཾ མནུཛམམེདྷྱཾ ན ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ཨནནྟརཾ ཡཱིཤུསྟསྨཱཏ྄ སྠཱནཱཏ྄ པྲསྠཱཡ སོརསཱིདོནྣགརཡོཿ སཱིམཱམུཔཏསྱཽ། ");
INSERT INTO santib_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ཏདཱ ཏཏྶཱིམཱཏཿ ཀཱཙིཏ྄ ཀིནཱནཱིཡཱ ཡོཥིད྄ ཨཱགཏྱ ཏམུཙྩཻརུཝཱཙ, ཧེ པྲབྷོ དཱཡཱུདཿ སནྟཱན, མམཻཀཱ དུཧིཏཱསྟེ སཱ བྷཱུཏགྲསྟཱ སཏཱི མཧཱཀླེཤཾ པྲཱཔྣོཏི མམ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ཀིནྟུ ཡཱིཤུསྟཱཾ ཀིམཔི ནོཀྟཝཱན྄, ཏཏཿ ཤིཥྱཱ ཨཱགཏྱ ཏཾ ནིཝེདཡཱམཱསུཿ, ཨེཥཱ ཡོཥིད྄ ཨསྨཱཀཾ པཤྩཱད྄ ཨུཙྩཻརཱཧཱུཡཱགཙྪཏི, ཨེནཱཾ ཝིསྲྀཛཏུ། ");
INSERT INTO santib_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ཏདཱ ས པྲཏྱཝདཏ྄, ཨིསྲཱཡེལྒོཏྲསྱ ཧཱརིཏམེཥཱན྄ ཝིནཱ ཀསྱཱཔྱནྱསྱ སམཱིཔཾ ནཱཧཾ པྲེཥིཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ཏཏཿ སཱ ནཱརཱིསམཱགཏྱ ཏཾ པྲཎམྱ ཛགཱད, ཧེ པྲབྷོ མཱམུཔཀུརུ། ");
INSERT INTO santib_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ས ཨུཀྟཝཱན྄, བཱལཀཱནཱཾ བྷཀྵྱམཱདཱཡ སཱརམེཡེབྷྱོ དཱནཾ ནོཙིཏཾ། ");
INSERT INTO santib_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ཏདཱ སཱ བབྷཱཥེ, ཧེ པྲབྷོ, ཏཏ྄ སཏྱཾ, ཏཐཱཔི པྲབྷོ རྦྷཉྩཱད྄ ཡདུཙྪིཥྚཾ པཏཏི, ཏཏ྄ སཱརམེཡཱཿ ཁཱདནྟི། ");
INSERT INTO santib_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ཏཏོ ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཧེ ཡོཥིཏ྄, ཏཝ ཝིཤྭཱསོ མཧཱན྄ ཏསྨཱཏ྄ ཏཝ མནོབྷིལཥིཏཾ སིདྱྱཏུ, ཏེན ཏསྱཱཿ ཀནྱཱ ཏསྨིནྣེཝ དཎྜེ ནིརཱམཡཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ཨནནྟརཾ ཡཱིཤསྟསྨཱཏ྄ སྠཱནཱཏ྄ པྲསྠཱཡ གཱལཱིལྶཱགརསྱ སནྣིདྷིམཱགཏྱ དྷརཱདྷརམཱརུཧྱ ཏཏྲོཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","པཤྩཱཏ྄ ཛནནིཝཧོ བཧཱུན྄ ཁཉྩཱནྡྷམཱུཀཤུཥྐཀརམཱནུཥཱན྄ ཨཱདཱཡ ཡཱིཤོཿ སམཱིཔམཱགཏྱ ཏཙྩརཎཱནྟིཀེ སྠཱཔཡཱམཱསུཿ, ཏཏཿ སཱ ཏཱན྄ ནིརཱམཡཱན྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ཨིཏྠཾ མཱུཀཱ ཝཱཀྱཾ ཝདནྟི, ཤུཥྐཀརཱཿ སྭཱསྠྱམཱཡཱནྟི, པངྒཝོ གཙྪནྟི, ཨནྡྷཱ ཝཱིཀྵནྟེ, ཨིཏི ཝིལོཀྱ ལོཀཱ ཝིསྨཡཾ མནྱམཱནཱ ཨིསྲཱཡེལ ཨཱིཤྭརཾ དྷནྱཾ བབྷཱཥིརེ། ");
INSERT INTO santib_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ཏདཱནཱིཾ ཡཱིཤུཿ སྭཤིཥྱཱན྄ ཨཱཧཱུཡ གདིཏཝཱན྄, ཨེཏཛྫནནིཝཧེཥུ མམ དཡཱ ཛཱཡཏེ, ཨེཏེ དིནཏྲཡཾ མཡཱ སཱཀཾ སནྟི, ཨེཥཱཾ བྷཀྵྱཝསྟུ ཙ ཀཉྩིདཔི ནཱསྟི, ཏསྨཱདཧམེཏཱནཀྲྀཏཱཧཱརཱན྄ ན ཝིསྲཀྵྱཱམི, ཏཐཱཏྭེ ཝརྟྨམདྷྱེ ཀླཱམྱེཥུཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ཏདཱ ཤིཥྱཱ ཨཱུཙུཿ, ཨེཏསྨིན྄ པྲཱནྟརམདྷྱ ཨེཏཱཝཏོ མརྟྱཱན྄ ཏརྤཡིཏུཾ ཝཡཾ ཀུཏྲ པཱུཔཱན྄ པྲཱཔྶྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ཡཱིཤུརཔྲྀཙྪཏ྄, ཡུཥྨཱཀཾ ནིཀཊེ ཀཏི པཱུཔཱ ཨཱསཏེ? ཏ ཨཱུཙུཿ, སཔྟཔཱུཔཱ ཨལྤཱཿ ཀྵུདྲམཱིནཱཤྩ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ཏདཱནཱིཾ ས ལོཀནིཝཧཾ བྷཱུམཱཝུཔཝེཥྚུམ྄ ཨཱདིཤྱ ");
INSERT INTO santib_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ཏཱན྄ སཔྟཔཱུཔཱན྄ མཱིནཱཾཤྩ གྲྀཧླན྄ ཨཱིཤྭརཱིཡགུཎཱན྄ ཨནཱུདྱ བྷཾཀྟྭཱ ཤིཥྱེབྷྱོ དདཽ, ཤིཥྱཱ ལོཀེབྷྱོ དདུཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ཏཏཿ སཪྻྭེ བྷུཀྟྭཱ ཏྲྀཔྟཝནྟཿ; ཏདཝཤིཥྚབྷཀྵྱེཎ སཔྟཌལཀཱན྄ པརིཔཱུཪྻྱ སཾཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ཏེ བྷོཀྟཱརོ ཡོཥིཏོ བཱལཀཱཾཤྩ ཝིཧཱཡ པྲཱཡེཎ ཙཏུཿསཧསྲཱཎི པུརུཥཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ཏཏཿ པརཾ ས ཛནནིཝཧཾ ཝིསྲྀཛྱ ཏརིམཱརུཧྱ མགྡལཱཔྲདེཤཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ཏདཱནཱིཾ ཕིརཱུཤིནཿ སིདཱུཀིནཤྩཱགཏྱ ཏཾ པརཱིཀྵིཏུཾ ནབྷམཱིཡཾ ཀིཉྩན ལཀྵྨ དརྴཡིཏུཾ ཏསྨཻ ནིཝེདཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ཏཏཿ ས ཨུཀྟཝཱན྄, སནྡྷྱཱཡཱཾ ནབྷསོ རཀྟཏྭཱད྄ ཡཱུཡཾ ཝདཐ, ཤྭོ ནིརྨྨལཾ དིནཾ བྷཝིཥྱཏི; ");
INSERT INTO santib_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","པྲཱཏཿཀཱལེ ཙ ནབྷསོ རཀྟཏྭཱཏ྄ མལིནཏྭཱཉྩ ཝདཐ, ཛྷཉྦྷྴདྱ བྷཝིཥྱཏི། ཧེ ཀཔཊིནོ ཡདི ཡཱུཡམ྄ ཨནྟརཱིཀྵསྱ ལཀྵྨ བོདྡྷུཾ ཤཀྣུཐ, ཏརྷི ཀཱལསྱཻཏསྱ ལཀྵྨ ཀཐཾ བོདྡྷུཾ ན ཤཀྣུཐ? ");
INSERT INTO santib_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ཨེཏཏྐཱལསྱ དུཥྚོ ཝྱབྷིཙཱརཱི ཙ ཝཾཤོ ལཀྵྨ གཝེཥཡཏི, ཀིནྟུ ཡཱུནསོ བྷཝིཥྱདྭཱདིནོ ལཀྵྨ ཝིནཱནྱཏ྄ ཀིམཔི ལཀྵྨ ཏཱན྄ ན དརྴཡིཡྻཏེ། ཏདཱནཱིཾ ས ཏཱན྄ ཝིཧཱཡ པྲཏསྠེ། ");
INSERT INTO santib_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ཨནནྟརམནྱཔཱརགམནཀཱལེ ཏསྱ ཤིཥྱཱཿ པཱུཔམཱནེཏུཾ ཝིསྨྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ཡཱིཤུསྟཱནཝཱདཱིཏ྄, ཡཱུཡཾ ཕིརཱུཤིནཱཾ སིདཱུཀིནཱཉྩ ཀིཎྭཾ པྲཏི སཱཝདྷཱནཱཿ སཏརྐཱཤྩ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ཏེན ཏེ པརསྤརཾ ཝིཝིཙྱ ཀཐཡིཏུམཱརེབྷིརེ, ཝཡཾ པཱུཔཱནཱནེཏུཾ ཝིསྨྲྀཏཝནྟ ཨེཏཏྐཱརཎཱད྄ ཨིཏི ཀཐཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ཀིནྟུ ཡཱིཤུསྟདྭིཛྙཱཡ ཏཱནཝོཙཏ྄, ཧེ སྟོཀཝིཤྭཱསིནོ ཡཱུཡཾ པཱུཔཱནཱནཡནམདྷི ཀུཏཿ པརསྤརམེཏད྄ ཝིཝིཾཀྱ? ");
INSERT INTO santib_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ཡུཥྨཱབྷིཿ ཀིམདྱཱཔི ན ཛྙཱཡཏེ? པཉྩབྷིཿ པཱུཔཻཿ པཉྩསཧསྲཔུརུཥེཥུ བྷོཛིཏེཥུ བྷཀྵྱོཙྪིཥྚཔཱུརྞཱན྄ ཀཏི ཌལཀཱན྄ སམགྲྀཧླཱིཏཾ; ");
INSERT INTO santib_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ཏཐཱ སཔྟབྷིཿ པཱུཔཻཤྩཏུཿསཧསྲཔུརུཥེཥུ བྷེཛིཏེཥུ ཀཏི ཌལཀཱན྄ སམགྲྀཧླཱིཏ, ཏཏ྄ ཀིཾ ཡུཥྨཱབྷིརྣ སྨཪྻྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ཏསྨཱཏ྄ ཕིརཱུཤིནཱཾ སིདཱུཀིནཱཉྩ ཀིཎྭཾ པྲཏི སཱཝདྷཱནཱསྟིཥྛཏ, ཀཐཱམིམཱམ྄ ཨཧཾ པཱུཔཱནདྷི ནཱཀཐཡཾ, ཨེཏད྄ ཡཱུཡཾ ཀུཏོ ན བུདྷྱདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ཏདཱནཱིཾ པཱུཔཀིཎྭཾ པྲཏི སཱཝདྷཱནཱསྟིཥྛཏེཏི ནོཀྟྭཱ ཕིརཱུཤིནཱཾ སིདཱུཀིནཱཉྩ ཨུཔདེཤཾ པྲཏི སཱཝདྷཱནཱསྟིཥྛཏེཏི ཀཐིཏཝཱན྄, ཨིཏི ཏཻརབོདྷི། ");
INSERT INTO santib_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ཨཔརཉྩ ཡཱིཤུཿ ཀཻསརིཡཱ-ཕིལིཔིཔྲདེཤམཱགཏྱ ཤིཥྱཱན྄ ཨཔྲྀཙྪཏ྄, ཡོ྅ཧཾ མནུཛསུཏཿ སོ྅ཧཾ ཀཿ? ལོཀཻརཧཾ ཀིམུཙྱེ? ");
INSERT INTO santib_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ཏདཱནཱིཾ ཏེ ཀཐིཏཝནྟཿ, ཀེཙིད྄ ཝདནྟི ཏྭཾ མཛྫཡིཏཱ ཡོཧན྄, ཀེཙིདྭདནྟི, ཏྭམ྄ ཨེལིཡཿ, ཀེཙིཙྩ ཝདནྟི, ཏྭཾ ཡིརིམིཡོ ཝཱ ཀཤྩིད྄ བྷཝིཥྱདྭཱདཱིཏི། ");
INSERT INTO santib_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","པཤྩཱཏ྄ ས ཏཱན྄ པཔྲཙྪ, ཡཱུཡཾ མཱཾ ཀཾ ཝདཐ? ཏཏཿ ཤིམོན྄ པིཏར ཨུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ཏྭམམརེཤྭརསྱཱབྷིཥིཀྟཔུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ཏཏོ ཡཱིཤུཿ ཀཐིཏཝཱན྄, ཧེ ཡཱུནསཿ པུཏྲ ཤིམོན྄ ཏྭཾ དྷནྱཿ; ཡཏཿ ཀོཔི ཨནུཛསྟྭཡྻེཏཛྫྙཱནཾ ནོདཔཱདཡཏ྄, ཀིནྟུ མམ སྭརྒསྱཿ པིཏོདཔཱདཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ཨཏོ྅ཧཾ ཏྭཱཾ ཝདཱམི, ཏྭཾ པིཏརཿ (པྲསྟརཿ) ཨཧཉྩ ཏསྱ པྲསྟརསྱོཔརི སྭམཎྜལཱིཾ ནིརྨྨཱསྱཱམི, ཏེན ནིརཡོ བལཱཏ྄ ཏཱཾ པརཱཛེཏུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ཨཧཾ ཏུབྷྱཾ སྭརྒཱིཡརཱཛྱསྱ ཀུཉྫིཀཱཾ དཱསྱཱམི, ཏེན ཡཏ྄ ཀིཉྩན ཏྭཾ པྲྀཐིཝྱཱཾ བྷཾཏྶྱསི ཏཏྶྭརྒེ བྷཾཏྶྱཏེ, ཡཙྩ ཀིཉྩན མཧྱཱཾ མོཀྵྱསི ཏཏ྄ སྭརྒེ མོཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","པཤྩཱཏ྄ ས ཤིཥྱཱནཱདིཤཏ྄, ཨཧམབྷིཥིཀྟོ ཡཱིཤུརིཏི ཀཐཱཾ ཀསྨཻཙིདཔི ཡཱུཡཾ མཱ ཀཐཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ཨནྱཉྩ ཡིརཱུཤཱལམྣགརཾ གཏྭཱ པྲཱཙཱིནལོཀེབྷྱཿ པྲདྷཱནཡཱཛཀེབྷྱ ཨུཔཱདྷྱཱཡེབྷྱཤྩ བཧུདུཿཁབྷོགསྟཻ རྷཏཏྭཾ ཏྲྀཏཱིཡདིནེ པུནརུཏྠཱནཉྩ མམཱཝཤྱཀམ྄ ཨེཏཱཿ ཀཐཱ ཡཱིཤུསྟཏྐཱལམཱརབྷྱ ཤིཥྱཱན྄ ཛྙཱཔཡིཏུམ྄ ཨཱརབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ཏདཱནཱིཾ པིཏརསྟསྱ ཀརཾ གྷྲྀཏྭཱ ཏརྫཡིཏྭཱ ཀཐཡིཏུམཱརབྡྷཝཱན྄, ཧེ པྲབྷོ, ཏཏ྄ ཏྭཏྟོ དཱུརཾ ཡཱཏུ, ཏྭཱཾ པྲཏི ཀདཱཔི ན གྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ཀིནྟུ ས ཝདནཾ པརཱཝརྟྱ པིཏརཾ ཛགཱད, ཧེ ཝིགྷྣཀཱརིན྄, མཏྶམྨུཁཱད྄ དཱུརཱིབྷཝ, ཏྭཾ མཱཾ བཱདྷསེ, ཨཱིཤྭརཱིཡཀཱཪྻྱཱཏ྄ མཱནུཥཱིཡཀཱཪྻྱཾ ཏུབྷྱཾ རོཙཏེ། ");
INSERT INTO santib_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ཨནནྟརཾ ཡཱིཤུཿ སྭཱིཡཤིཥྱཱན྄ ཨུཀྟཝཱན྄ ཡཿ ཀཤྩིཏ྄ མམ པཤྩཱདྒཱམཱི བྷཝིཏུམ྄ ཨིཙྪཏི, ས སྭཾ དཱམྱཏུ, ཏཐཱ སྭཀྲུཤཾ གྲྀཧླན྄ མཏྤཤྩཱདཱཡཱཏུ། ");
INSERT INTO santib_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ཡཏོ ཡཿ པྲཱཎཱན྄ རཀྵིཏུམིཙྪཏི, ས ཏཱན྄ ཧཱརཡིཥྱཏི, ཀིནྟུ ཡོ མདརྠཾ ནིཛཔྲཱཎཱན྄ ཧཱརཡཏི, ས ཏཱན྄ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","མཱནུཥོ ཡདི སཪྻྭཾ ཛགཏ྄ ལབྷཏེ ནིཛཔྲཎཱན྄ ཧཱརཡཏི, ཏརྷི ཏསྱ ཀོ ལཱབྷཿ? མནུཛོ ནིཛཔྲཱཎཱནཱཾ ཝིནིམཡེན ཝཱ ཀིཾ དཱཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","མནུཛསུཏཿ སྭདཱུཏཻཿ སཱཀཾ པིཏུཿ པྲབྷཱཝེཎཱགམིཥྱཏི; ཏདཱ པྲཏིམནུཛཾ སྭསྭཀརྨྨཱནུསཱརཱཏ྄ ཕལཾ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝཙྨི, སརཱཛྱཾ མནུཛསུཏམ྄ ཨཱགཏཾ ན པཤྱནྟོ མྲྀཏྱུཾ ན སྭཱདིཥྱནྟི, ཨེཏཱདྲྀཤཱཿ ཀཏིཔཡཛནཱ ཨཏྲཱཔི དཎྜཱཡམཱནཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ཨནནྟརཾ ཥཌྡིནེབྷྱཿ པརཾ ཡཱིཤུཿ པིཏརཾ ཡཱཀཱུབཾ ཏཏྶཧཛཾ ཡོཧནཉྩ གྲྀཧླན྄ ཨུཙྩཱདྲེ ཪྻིཝིཀྟསྠཱནམ྄ ཨཱགཏྱ ཏེཥཱཾ སམཀྵཾ རཱུཔམནྱཏ྄ དདྷཱར། ");
INSERT INTO santib_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ཏེན ཏདཱསྱཾ ཏེཛསྭི, ཏདཱབྷརཎམ྄ ཨཱལོཀཝཏ྄ པཱཎྜརམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ཨནྱཙྩ ཏེན སཱཀཾ སཾལཔནྟཽ མཱུསཱ ཨེལིཡཤྩ ཏེབྷྱོ དརྴནཾ དདཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ཏདཱནཱིཾ པིཏརོ ཡཱིཤུཾ ཛགཱད, ཧེ པྲབྷོ སྠིཏིརཏྲཱསྨཱཀཾ ཤུབྷཱ, ཡདི བྷཝཏཱནུམནྱཏེ, ཏརྷི བྷཝདརྠམེཀཾ མཱུསཱརྠམེཀམ྄ ཨེལིཡཱརྠཉྩཻཀམ྄ ཨིཏི ཏྲཱིཎི དཱུཥྱཱཎི ནིརྨྨམ། ");
INSERT INTO santib_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ཨེཏཏྐཐནཀཱལ ཨེཀ ཨུཛྫཝལཿ པཡོདསྟེཥཱམུཔརི ཚཱཡཱཾ ཀྲྀཏཝཱན྄, ཝཱརིདཱད྄ ཨེཥཱ ནབྷསཱིཡཱ ཝཱག྄ བབྷཱུཝ, མམཱཡཾ པྲིཡཿ པུཏྲཿ, ཨསྨིན྄ མམ མཧཱསནྟོཥ ཨེཏསྱ ཝཱཀྱཾ ཡཱུཡཾ ནིཤཱམཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ཀིནྟུ ཝཱཙམེཏཱཾ ཤྲྀཎྭནྟཨེཝ ཤིཥྱཱ མྲྀཤཾ ཤངྐམཱནཱ ནྱུབྫཱ ནྱཔཏན྄། ");
INSERT INTO santib_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ཏདཱ ཡཱིཤུརཱགཏྱ ཏེཥཱཾ གཱཏྲཱཎི སྤྲྀཤན྄ ཨུཝཱཙ, ཨུཏྟིཥྛཏ, མཱ བྷཻཥྚ། ");
INSERT INTO santib_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ཏདཱནཱིཾ ནེཏྲཱཎྱུནྨཱིལྱ ཡཱིཤུཾ ཝིནཱ ཀམཔི ན དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ཏཏཿ པརམ྄ ཨདྲེརཝརོཧཎཀཱལེ ཡཱིཤུསྟཱན྄ ཨིཏྱཱདིདེཤ, མནུཛསུཏསྱ མྲྀཏཱནཱཾ མདྷྱཱདུཏྠཱནཾ ཡཱཝནྣ ཛཱཡཏེ, ཏཱཝཏ྄ ཡུཥྨཱབྷིརེཏདྡརྴནཾ ཀསྨཻཙིདཔི ན ཀཐཡིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ཏདཱ ཤིཥྱཱསྟཾ པཔྲཙྪུཿ, པྲཐམམ྄ ཨེལིཡ ཨཱཡཱསྱཏཱིཏི ཀུཏ ཨུཔཱདྷྱཱཡཻརུཙྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིཏ྄, ཨེལིཡཿ པྲཱགེཏྱ སཪྻྭཱཎི སཱདྷཡིཥྱཏཱིཏི སཏྱཾ, ");
INSERT INTO santib_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝཙྨི, ཨེལིཡ ཨེཏྱ གཏཿ, ཏེ ཏམཔརིཙིཏྱ ཏསྨིན྄ ཡཐེཙྪཾ ཝྱཝཛཧུཿ; མནུཛསུཏེནཱཔི ཏེཥཱམནྟིཀེ ཏཱདྲྀག྄ དུཿཁཾ བྷོཀྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ཏདཱནཱིཾ ས མཛྫཡིཏཱརཾ ཡོཧནམདྷི ཀཐཱམེཏཱཾ ཝྱཱཧྲྀཏཝཱན྄, ཨིཏྠཾ ཏཙྪིཥྱཱ བུབུདྷིརེ། ");
INSERT INTO santib_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","པཤྩཱཏ྄ ཏེཥུ ཛནནིཝཧསྱཱནྟིཀམཱགཏེཥུ ཀཤྩིཏ྄ མནུཛསྟདནྟིཀམེཏྱ ཛཱནཱུནཱི པཱཏཡིཏྭཱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ཧེ པྲབྷོ, མཏྤུཏྲཾ པྲཏི ཀྲྀཔཱཾ ཝིདདྷཱཏུ, སོཔསྨཱརཱམཡེན བྷྲྀཤཾ ཝྱཐིཏཿ སན྄ པུནཿ པུན ཪྻཧྣཽ མུཧུ རྫལམདྷྱེ པཏཏི། ");
INSERT INTO santib_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ཏསྨཱད྄ བྷཝཏཿ ཤིཥྱཱཎཱཾ སམཱིཔེ ཏམཱནཡཾ ཀིནྟུ ཏེ ཏཾ སྭཱསྠཾ ཀརྟྟུཾ ན ཤཀྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ཏདཱ ཡཱིཤུཿ ཀཐིཏཝཱན྄ རེ ཨཝིཤྭཱསིནཿ, རེ ཝིཔཐགཱམིནཿ, པུནཿ ཀཏིཀཱལཱན྄ ཨཧཾ ཡུཥྨཱཀཾ སནྣིདྷཽ སྠཱསྱཱམི? ཀཏིཀཱལཱན྄ ཝཱ ཡུཥྨཱན྄ སཧིཥྱེ? ཏམཏྲ མམཱནྟིཀམཱནཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","པཤྩཱད྄ ཡཱིཤུནཱ ཏརྫཏཨེཝ ས བྷཱུཏསྟཾ ཝིཧཱཡ གཏཝཱན྄, ཏདྡཎྜཨེཝ ས བཱལཀོ ནིརཱམཡོ྅བྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ཏཏཿ ཤིཥྱཱ གུཔྟཾ ཡཱིཤུམུཔཱགཏྱ བབྷཱཥིརེ, ཀུཏོ ཝཡཾ ཏཾ བྷཱུཏཾ ཏྱཱཛཡིཏུཾ ན ཤཀྟཱཿ? ");
INSERT INTO santib_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ཡཱིཤུནཱ ཏེ པྲོཀྟཱཿ, ཡུཥྨཱཀམཔྲཏྱཡཱཏ྄; ");
INSERT INTO santib_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ཡུཥྨཱནཧཾ ཏཐྱཾ ཝཙྨི ཡདི ཡུཥྨཱཀཾ སརྵཔཻཀམཱཏྲོཔི ཝིཤྭཱསོ ཛཱཡཏེ, ཏརྷི ཡུཥྨཱབྷིརསྨིན྄ ཤཻལེ ཏྭམིཏཿ སྠཱནཱཏ྄ ཏཏ྄ སྠཱནཾ ཡཱཧཱིཏི བྲཱུཏེ ས ཏདཻཝ ཙལིཥྱཏི, ཡུཥྨཱཀཾ ཀིམཔྱསཱདྷྱཉྩ ཀརྨྨ ན སྠཱསྱཱཏི། ཀིནྟུ པྲཱརྠནོཔཝཱསཽ ཝིནཻཏཱདྲྀཤོ བྷཱུཏོ ན ཏྱཱཛྱེཏ། ");
INSERT INTO santib_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ཨཔརཾ ཏེཥཱཾ གཱལཱིལྤྲདེཤེ བྷྲམཎཀཱལེ ཡཱིཤུནཱ ཏེ གདིཏཱཿ, མནུཛསུཏོ ཛནཱནཱཾ ཀརེཥུ སམརྤཡིཥྱཏེ ཏཻ རྷནིཥྱཏེ ཙ, ");
INSERT INTO santib_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ཀིནྟུ ཏྲྀཏཱིཡེ྅ཧ्ིན མ ཨུཏྠཱཔིཥྱཏེ, ཏེན ཏེ བྷྲྀཤཾ དུཿཁིཏཱ བབྷཱུཝཿ། ");
INSERT INTO santib_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ཏདནནྟརཾ ཏེཥུ ཀཕརྣཱཧཱུམྣགརམཱགཏེཥུ ཀརསཾགྲཱཧིཎཿ པིཏརཱནྟིཀམཱགཏྱ པཔྲཙྪུཿ, ཡུཥྨཱཀཾ གུརུཿ ཀིཾ མནྡིརཱརྠཾ ཀརཾ ན དདཱཏི? ཏཏཿ པིཏརཿ ཀཐིཏཝཱན྄ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ཏཏསྟསྨིན྄ གྲྀཧམདྷྱམཱགཏེ ཏསྱ ཀཐཱཀཐནཱཏ྄ པཱུཪྻྭམེཝ ཡཱིཤུརུཝཱཙ, ཧེ ཤིམོན྄, མེདིནྱཱ རཱཛཱནཿ སྭསྭཱཔཏྱེབྷྱཿ ཀིཾ ཝིདེཤིབྷྱཿ ཀེབྷྱཿ ཀརཾ གྲྀཧླནྟི? ཨཏྲ ཏྭཾ ཀིཾ བུདྷྱསེ? ཏཏཿ པིཏར ཨུཀྟཝཱན྄, ཝིདེཤིབྷྱཿ། ");
INSERT INTO santib_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ཏདཱ ཡཱིཤུརུཀྟཝཱན྄, ཏརྷི སནྟཱནཱ མུཀྟཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ཏཐཱཔི ཡཐཱསྨཱབྷིསྟེཥཱམནྟརཱཡོ ན ཛནྱཏེ, ཏཏྐྲྀཏེ ཛལདྷེསྟཱིརཾ གཏྭཱ ཝཌིཤཾ ཀྵིཔ, ཏེནཱདཽ ཡོ མཱིན ཨུཏྠཱསྱཏི, ཏཾ གྷྲྀཏྭཱ ཏནྨུཁེ མོཙིཏེ ཏོལཀཻཀཾ རཱུཔྱཾ པྲཱཔྶྱསི, ཏད྄ གྲྀཧཱིཏྭཱ ཏཝ མམ ཙ ཀྲྀཏེ ཏེབྷྱོ དེཧི། ");
INSERT INTO santib_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ཏདཱནཱིཾ ཤིཥྱཱ ཡཱིཤོཿ སམཱིཔམཱགཏྱ པྲྀཥྚཝནྟཿ སྭརྒརཱཛྱེ ཀཿ ཤྲེཥྛཿ? ");
INSERT INTO santib_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ཏཏོ ཡཱིཤུཿ ཀྵུདྲམེཀཾ བཱལཀཾ སྭསམཱིཔམཱནཱིཡ ཏེཥཱཾ མདྷྱེ ནིདྷཱཡ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ཡུཥྨཱནཧཾ སཏྱཾ བྲཝཱིམི, ཡཱུཡཾ མནོཝིནིམཡེན ཀྵུདྲབཱལཝཏ྄ ན སནྟཿ སྭརྒརཱཛྱཾ པྲཝེཥྚུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ཡཿ ཀཤྩིད྄ ཨེཏསྱ ཀྵུདྲབཱལཀསྱ སམམཱཏྨཱནཾ ནམྲཱིཀརོཏི, སཨེཝ སྭརྒརཱཛཡེ ཤྲེཥྛཿ། ");
INSERT INTO santib_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ཡཿ ཀཤྩིད྄ ཨེཏཱདྲྀཤཾ ཀྵུདྲབཱལཀམེཀཾ མམ ནཱམྣི གྲྀཧླཱཏི, ས མཱམེཝ གྲྀཧླཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ཀིནྟུ ཡོ ཛནོ མཡི ཀྲྀཏཝིཤྭཱསཱནཱམེཏེཥཱཾ ཀྵུདྲཔྲཱཎིནཱམ྄ ཨེཀསྱཱཔི ཝིདྷྣིཾ ཛནཡཏི, ཀཎྛབདྡྷཔེཥཎཱིཀསྱ ཏསྱ སཱགརཱགཱདྷཛལེ མཛྫནཾ ཤྲེཡཿ། ");
INSERT INTO santib_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ཝིགྷྣཱཏ྄ ཛགཏཿ སནྟཱཔོ བྷཝིཥྱཏི, ཝིགྷྣོ྅ཝཤྱཾ ཛནཡིཥྱཏེ, ཀིནྟུ ཡེན མནུཛེན ཝིགྷྣོ ཛནིཥྱཏེ ཏསྱཻཝ སནྟཱཔོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ཏསྨཱཏ྄ ཏཝ ཀརཤྩརཎོ ཝཱ ཡདི ཏྭཱཾ བཱདྷཏེ, ཏརྷི ཏཾ ཚིཏྟྭཱ ནིཀྵིཔ, དྭིཀརསྱ དྭིཔདསྱ ཝཱ ཏཝཱནཔྟཝཧྣཽ ནིཀྵེཔཱཏ྄, ཁཉྫསྱ ཝཱ ཚིནྣཧསྟསྱ ཏཝ ཛཱིཝནེ པྲཝེཤོ ཝརཾ། ");
INSERT INTO santib_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ཨཔརཾ ཏཝ ནེཏྲཾ ཡདི ཏྭཱཾ བཱདྷཏེ, ཏརྷི ཏདཔྱུཏྤཱཝྱ ནིཀྵིཔ, དྭིནེཏྲསྱ ནརཀཱགྣཽ ནིཀྵེཔཱཏ྄ ཀཱཎསྱ ཏཝ ཛཱིཝནེ པྲཝེཤོ ཝརཾ། ");
INSERT INTO santib_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ཏསྨཱདཝདྷདྡྷཾ, ཨེཏེཥཱཾ ཀྵུདྲཔྲཱཎིནཱམ྄ ཨེཀམཔི མཱ ཏུཙྪཱིཀུརུཏ, ");
INSERT INTO santib_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ཡཏོ ཡུཥྨཱནཧཾ ཏཐྱཾ བྲཝཱིམི, སྭརྒེ ཏེཥཱཾ དཱུཏཱ མམ སྭརྒསྠསྱ པིཏུརཱསྱཾ ནིཏྱཾ པཤྱནྟི། ཨེཝཾ ཡེ ཡེ ཧཱརིཏཱསྟཱན྄ རཀྵིཏུཾ མནུཛཔུཏྲ ཨཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ཡཱུཡམཏྲ ཀིཾ ཝིཝིཾགྒྷྭེ? ཀསྱཙིད྄ ཡདི ཤཏཾ མེཥཱཿ སནྟི, ཏེཥཱམེཀོ ཧཱཪྻྱཏེ ཙ, ཏརྷི ས ཨེཀོནཤཏཾ མེཥཱན྄ ཝིཧཱཡ པཪྻྭཏཾ གཏྭཱ ཏཾ ཧཱརིཏམེཀཾ ཀིཾ ན མྲྀགཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ཡདི ཙ ཀདཱཙིཏ྄ ཏནྨེཥོདྡེཤཾ ལམཏེ, ཏརྷི ཡུཥྨཱནཧཾ སཏྱཾ ཀཐཡཱམི, སོ྅ཝིཔཐགཱམིབྷྱ ཨེཀོནཤཏམེཥེབྷྱོཔི ཏདེཀཧེཏོརདྷིཀམ྄ ཨཱཧླཱདཏེ། ");
INSERT INTO santib_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ཏདྭད྄ ཨེཏེཥཱཾ ཀྵུདྲཔྲཱཨེिནཱམ྄ ཨེཀོཔི ནཤྱཏཱིཏི ཡུཥྨཱཀཾ སྭརྒསྠཔིཏུ རྣཱབྷིམཏམ྄། ");
INSERT INTO santib_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ཡདྱཔི ཏཝ བྷྲཱཏཱ ཏྭཡི ཀིམཔྱཔརཱདྷྱཏི, ཏརྷི གཏྭཱ ཡུཝཡོརྡྭཡོཿ སྠིཏཡོསྟསྱཱཔརཱདྷཾ ཏཾ ཛྙཱཔཡ། ཏཏྲ ས ཡདི ཏཝ ཝཱཀྱཾ ཤྲྀཎོཏི, ཏརྷི ཏྭཾ སྭབྷྲཱཏརཾ པྲཱཔྟཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ཀིནྟུ ཡདི ན ཤྲྀཎོཏི, ཏརྷི དྭཱབྷྱཱཾ ཏྲིབྷི ཪྻཱ སཱཀྵཱིབྷིཿ སཪྻྭཾ ཝཱཀྱཾ ཡཐཱ ནིཤྩིཏཾ ཛཱཡཏེ, ཏདརྠམ྄ ཨེཀཾ དྭཽ ཝཱ སཱཀྵིཎཽ གྲྀཧཱིཏྭཱ ཡཱཧི། ");
INSERT INTO santib_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ཏེན ས ཡདི ཏཡོ ཪྻཱཀྱཾ ན མཱནྱཏེ, ཏརྷི སམཱཛཾ ཏཛྫྙཱཔཡ, ཀིནྟུ ཡདི སམཱཛསྱཱཔི ཝཱཀྱཾ ན མཱནྱཏེ,ཏརྷི ས ཏཝ སམཱིཔེ དེཝཔཱུཛཀཨིཝ ཙཎྜཱལཨིཝ ཙ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ཨཧཾ ཡུཥྨཱན྄ སཏྱཾ ཝདཱམི, ཡུཥྨཱབྷིཿ པྲྀཐིཝྱཱཾ ཡད྄ བདྷྱཏེ ཏཏ྄ སྭརྒེ བྷཾཏྶྱཏེ; མེདིནྱཱཾ ཡཏ྄ བྷོཙྱཏེ, སྭརྒེ྅པི ཏཏ྄ མོཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","པུནརཧཾ ཡུཥྨཱན྄ ཝདཱམི, མེདིནྱཱཾ ཡུཥྨཱཀཾ ཡདི དྭཱཝེཀཝཱཀྱཱིབྷཱུཡ ཀིཉྩིཏ྄ པྲཱརྠཡེཏེ, ཏརྷི མམ སྭརྒསྠཔིཏྲཱ ཏཏ྄ ཏཡོཿ ཀྲྀཏེ སམྤནྣཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ཡཏོ ཡཏྲ དྭཽ ཏྲཡོ ཝཱ མམ ནཱནྣི མིལནྟི, ཏཏྲཻཝཱཧཾ ཏེཥཱཾ མདྷྱེ྅སྨི། ");
INSERT INTO santib_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ཏདཱནཱིཾ པིཏརསྟཏྶམཱིཔམཱགཏྱ ཀཐིཏཝཱན྄ ཧེ པྲབྷོ, མམ བྷྲཱཏཱ མམ ཡདྱཔརཱདྷྱཏི, ཏརྷི ཏཾ ཀཏིཀྲྀཏྭཿ ཀྵམིཥྱེ? ");
INSERT INTO santib_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ཀིཾ སཔྟཀྲྀཏྭཿ? ཡཱིཤུསྟཾ ཛགཱད, ཏྭཱཾ ཀེཝལཾ སཔྟཀྲྀཏྭོ ཡཱཝཏ྄ ན ཝདཱམི, ཀིནྟུ སཔྟཏྱཱ གུཎིཏཾ སཔྟཀྲྀཏྭོ ཡཱཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ཨཔརཾ ནིཛདཱསཻཿ སཧ ཛིགཎཡིཥུཿ ཀཤྩིད྄ རཱཛེཝ སྭརྒརཱཛཡཾ། ");
INSERT INTO santib_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ཨཱརབྡྷེ ཏསྨིན྄ གཎནེ སཱརྡྡྷསཧསྲམུདྲཱཔཱུརིཏཱནཱཾ དཤསཧསྲཔུཊཀཱནཱམ྄ ཨེཀོ྅གྷམརྞསྟཏྶམཀྵམཱནཱཡི། ");
INSERT INTO santib_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ཏསྱ པརིཤོདྷནཱཡ དྲཝྱཱབྷཱཝཱཏ྄ པརིཤོདྷནཱརྠཾ ས ཏདཱིཡབྷཱཪྻྱཱཔུཏྲཱདིསཪྻྭསྭཉྩ ཝིཀྲཱིཡཏཱམིཏི ཏཏྤྲབྷུརཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ཏེན ས དཱསསྟསྱ པཱདཡོཿ པཏན྄ པྲཎམྱ ཀཐིཏཝཱན྄ , ཧེ པྲབྷོ བྷཝཏཱ གྷཻཪྻྱེ ཀྲྀཏེ མཡཱ སཪྻྭཾ པརིཤོདྷིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ཏདཱནཱིཾ དཱསསྱ པྲབྷུཿ སཀརུཎཿ སན྄ སཀལརྞཾ ཀྵམིཏྭཱ ཏཾ ཏཏྱཱཛ། ");
INSERT INTO santib_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ཀིནྟུ ཏསྨིན྄ དཱསེ བཧི ཪྻཱཏེ, ཏསྱ ཤཏཾ མུདྲཱཙཏུརྠཱཾཤཱན྄ ཡོ དྷཱརཡཏི, ཏཾ སཧདཱསཾ དྲྀཥྡྭཱ ཏསྱ ཀཎྛཾ ནིཥྤཱིཌྱ གདིཏཝཱན྄, མམ ཡཏ྄ པྲཱཔྱཾ ཏཏ྄ པརིཤོདྷཡ། ");
INSERT INTO santib_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ཏདཱ ཏསྱ སཧདཱསསྟཏྤཱདཡོཿ པཏིཏྭཱ ཝིནཱིཡ བབྷཱཥེ, ཏྭཡཱ དྷཻཪྻྱེ ཀྲྀཏེ མཡཱ སཪྻྭཾ པརིཤོདྷིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ཏཐཱཔི ས ཏཏ྄ ནཱངགཱིཀྲྀཏྱ ཡཱཝཏ྄ སཪྻྭམྲྀཎཾ ན པརིཤོདྷིཏཝཱན྄ ཏཱཝཏ྄ ཏཾ ཀཱརཱཡཱཾ སྠཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ཏདཱ ཏསྱ སཧདཱསཱསྟསྱཻཏཱདྲྀག྄ ཨཱཙརཎཾ ཝིལོཀྱ པྲབྷོཿ སམཱིཔཾ གཏྭཱ སཪྻྭཾ ཝྲྀཏྟཱནྟཾ ནིཝེདཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ཏདཱ ཏསྱ པྲབྷུསྟམཱཧཱུཡ ཛགཱད, རེ དུཥྚ དཱས, ཏྭཡཱ མཏྶནྣིདྷཽ པྲཱརྠིཏེ མཡཱ ཏཝ སཪྻྭམྲྀཎཾ ཏྱཀྟཾ; ");
INSERT INTO santib_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ཡཐཱ ཙཱཧཾ ཏྭཡི ཀརུཎཱཾ ཀྲྀཏཝཱན྄, ཏཐཻཝ ཏྭཏྶཧདཱསེ ཀརུཎཱཀརཎཾ ཀིཾ ཏཝ ནོཙིཏཾ? ");
INSERT INTO santib_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ཨིཏི ཀཐཡིཏྭཱ ཏསྱ པྲབྷུཿ ཀྲུདྡྷྱན྄ ནིཛཔྲཱཔྱཾ ཡཱཝཏ྄ ས ན པརིཤོདྷིཏཝཱན྄, ཏཱཝཏ྄ པྲཧཱརཀཱནཱཾ ཀརེཥུ ཏཾ སམརྤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ཡདི ཡཱུཡཾ སྭཱནྟཿཀརཎཻཿ སྭསྭསཧཛཱནཱམ྄ ཨཔརཱདྷཱན྄ ན ཀྵམདྷྭེ, ཏརྷི མམ སྭརྒསྱཿ པིཏཱཔི ཡུཥྨཱན྄ པྲཏཱིཏྠཾ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ཨནནྟརམ྄ ཨེཏཱསུ ཀཐཱསུ སམཱཔྟཱསུ ཡཱིཤུ རྒཱལཱིལཔྲདེཤཱཏ྄ པྲསྠཱཡ ཡརྡནྟཱིརསྠཾ ཡིཧཱུདཱཔྲདེཤཾ པྲཱཔྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ཏདཱ ཏཏྤཤྩཱཏ྄ ཛནནིཝཧེ གཏེ ས ཏཏྲ ཏཱན྄ ནིརཱམཡཱན྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ཏདནནྟརཾ ཕིརཱུཤིནསྟཏྶམཱིཔམཱགཏྱ པཱརཱིཀྵིཏུཾ ཏཾ པཔྲཙྪུཿ, ཀསྨཱདཔི ཀཱརཎཱཏ྄ ནརེཎ སྭཛཱཡཱ པརིཏྱཱཛྱཱ ན ཝཱ? ");
INSERT INTO santib_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ས པྲཏྱུཝཱཙ, པྲཐམམ྄ ཨཱིཤྭརོ ནརཏྭེན ནཱརཱིཏྭེན ཙ མནུཛཱན྄ སསརྫ, ཏསྨཱཏ྄ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","མཱནུཥཿ སྭཔིཏརཽ པརིཏྱཛྱ སྭཔཏྣྱཱམ྄ ཨཱསཀྵྱཏེ, ཏཽ དྭཽ ཛནཱཝེཀཱངྒཽ བྷཝིཥྱཏཿ, ཀིམེཏད྄ ཡུཥྨཱབྷི རྣ པཋིཏམ྄? ");
INSERT INTO santib_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ཨཏསྟཽ པུན རྣ དྭཽ ཏཡོརེཀཱངྒཏྭཾ ཛཱཏཾ, ཨཱིཤྭརེཎ ཡཙྩ སམཡུཛྱཏ, མནུཛོ ན ཏད྄ བྷིནྡྱཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ཏདཱནཱིཾ ཏེ ཏཾ པྲཏྱཝདན྄, ཏཐཱཏྭེ ཏྱཱཛྱཔཏྲཾ དཏྟྭཱ སྭཱཾ སྭཱཾ ཛཱཡཱཾ ཏྱཀྟུཾ ཝྱཝསྠཱཾ མཱུསཱཿ ཀཐཾ ལིལེཁ? ");
INSERT INTO santib_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ཏཏཿ ས ཀཐིཏཝཱན྄, ཡུཥྨཱཀཾ མནསཱཾ ཀཱཋིནྱཱད྄ ཡུཥྨཱན྄ སྭཱཾ སྭཱཾ ཛཱཡཱཾ ཏྱཀྟུམ྄ ཨནྭམནྱཏ ཀིནྟུ པྲཐམཱད྄ ཨེཥོ ཝིདྷིརྣཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ཨཏོ ཡུཥྨཱནཧཾ ཝདཱམི, ཝྱབྷིཙཱརཾ ཝིནཱ ཡོ ནིཛཛཱཡཱཾ ཏྱཛེཏ྄ ཨནྱཱཉྩ ཝིཝཧེཏ྄, ས པརདཱརཱན྄ གཙྪཏི; ཡཤྩ ཏྱཀྟཱཾ ནཱརཱིཾ ཝིཝཧཏི སོཔི པརདཱརེཥུ རམཏེ། ");
INSERT INTO santib_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ཏདཱ ཏསྱ ཤིཥྱཱསྟཾ བབྷཱཥིརེ, ཡདི སྭཛཱཡཡཱ སཱཀཾ པུཾས ཨེཏཱདྲྀཀ྄ སམྦནྡྷོ ཛཱཡཏེ, ཏརྷི ཝིཝཧནམེཝ ན བྷདྲཾ། ");
INSERT INTO santib_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ཏཏཿ ས ཨུཀྟཝཱན྄, ཡེབྷྱསྟཏྶཱམརྠྱཾ ཨཱདཱཡི, ཏཱན྄ ཝིནཱནྱཿ ཀོཔི མནུཛ ཨེཏནྨཏཾ གྲཧཱིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ཀཏིཔཡཱ ཛནནཀླཱིབཿ ཀཏིཔཡཱ ནརཀྲྀཏཀླཱིབཿ སྭརྒརཱཛྱཱཡ ཀཏིཔཡཱཿ སྭཀྲྀཏཀླཱིབཱཤྩ སནྟི, ཡེ གྲཧཱིཏུཾ ཤཀྣུཝནྟི ཏེ གྲྀཧླནྟུ། ");
INSERT INTO santib_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ཨཔརམ྄ ཡཐཱ ས ཤིཤཱུནཱཾ གཱཏྲེཥུ ཧསྟཾ དཏྭཱ པྲཱརྠཡཏེ, ཏདརྠཾ ཏཏྶམཱིཾཔཾ ཤིཤཝ ཨཱནཱིཡནྟ, ཏཏ ཨཱནཡིཏྲྀན྄ ཤིཥྱཱསྟིརསྐྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ཀིནྟུ ཡཱིཤུརུཝཱཙ, ཤིཤཝོ མདནྟིཀམ྄ ཨཱགཙྪནྟུ, ཏཱན྄ མཱ ཝཱརཡཏ, ཨེཏཱདྲྀཤཱཾ ཤིཤཱུནཱམེཝ སྭརྒརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ཏཏཿ ས ཏེཥཱཾ གཱཏྲེཥུ ཧསྟཾ དཏྭཱ ཏསྨཱཏ྄ སྠཱནཱཏ྄ པྲཏསྠེ། ");
INSERT INTO santib_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ཨཔརམ྄ ཨེཀ ཨཱགཏྱ ཏཾ པཔྲཙྪ, ཧེ པརམགུརོ, ཨནནྟཱཡུཿ པྲཱཔྟུཾ མཡཱ ཀིཾ ཀིཾ སཏྐརྨྨ ཀརྟྟཝྱཾ? ");
INSERT INTO santib_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ཏཏཿ ས ཨུཝཱཙ, མཱཾ པརམཾ ཀུཏོ ཝདསི? ཝིནེཤྩརཾ ན ཀོཔི པརམཿ, ཀིནྟུ ཡདྱནནྟཱཡུཿ པྲཱཔྟུཾ ཝཱཉྪསི, ཏརྷྱཱཛྙཱཿ པཱལཡ། ");
INSERT INTO santib_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ཏདཱ ས པྲྀཥྚཝཱན྄, ཀཱཿ ཀཱ ཨཱཛྙཱཿ? ཏཏོ ཡཱིཤུཿ ཀཐིཏཝཱན྄, ནརཾ མཱ ཧནྱཱཿ, པརདཱརཱན྄ མཱ གཙྪེཿ, མཱ ཙོརཡེཿ, མྲྀཥཱསཱཀྵྱཾ མཱ དདྱཱཿ, ");
INSERT INTO santib_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ནིཛཔིཏརཽ སཾམནྱསྭ, སྭསམཱིཔཝཱསིནི སྭཝཏ྄ པྲེམ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ས ཡུཝཱ ཀཐིཏཝཱན྄, ཨཱ བཱལྱཱད྄ ཨེཏཱཿ པཱལཡཱམི, ཨིདཱནཱིཾ ཀིཾ ནྱཱུནམཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ཏཏོ ཡཱིཤུརཝདཏ྄, ཡདི སིདྡྷོ བྷཝིཏུཾ ཝཱཉྪསི, ཏརྷི གཏྭཱ ནིཛསཪྻྭསྭཾ ཝིཀྲཱིཡ དརིདྲེབྷྱོ ཝིཏར, ཏཏཿ སྭརྒེ ཝིཏྟཾ ལཔྶྱསེ; ཨཱགཙྪ, མཏྤཤྩཱདྭརྟྟཱི ཙ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ཨེཏཱཾ ཝཱཙཾ ཤྲུཏྭཱ ས ཡུཝཱ སྭཱིཡབཧུསམྤཏྟེ ཪྻིཥཎཿ སན྄ ཙལིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ཏདཱ ཡཱིཤུཿ སྭཤིཥྱཱན྄ ཨཝདཏ྄, དྷནིནཱཾ སྭརྒརཱཛྱཔྲཝེཤོ མཧཱདུཥྐར ཨིཏི ཡུཥྨཱནཧཾ ཏཐྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","པུནརཔི ཡུཥྨཱནཧཾ ཝདཱམི, དྷནིནཱཾ སྭརྒརཱཛྱཔྲཝེཤཱཏ྄ སཱུཙཱིཚིདྲེཎ མཧཱངྒགམནཾ སུཀརཾ། ");
INSERT INTO santib_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ཨིཏི ཝཱཀྱཾ ནིཤམྱ ཤིཥྱཱ ཨཏིཙམཏྐྲྀཏྱ ཀཐཡཱམཱསུཿ; ཏརྷི ཀསྱ པརིཏྲཱཎཾ བྷཝིཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ཏདཱ ས ཏཱན྄ དྲྀཥྡྭཱ ཀཐཡཱམཱས, ཏཏ྄ མཱནུཥཱཎཱམཤཀྱཾ བྷཝཏི, ཀིནྟྭཱིཤྭརསྱ སཪྻྭཾ ཤཀྱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ཏདཱ པིཏརསྟཾ གདིཏཝཱན྄, པཤྱ, ཝཡཾ སཪྻྭཾ པརིཏྱཛྱ བྷཝཏཿ པཤྩཱདྭརྟྟིནོ ྅བྷཝཱམ; ཝཡཾ ཀིཾ པྲཱཔྶྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ཏཏོ ཡཱིཤུཿ ཀཐིཏཝཱན྄, ཡུཥྨཱནཧཾ ཏཐྱཾ ཝདཱམི, ཡཱུཡཾ མམ པཤྩཱདྭརྟྟིནོ ཛཱཏཱ ཨིཏི ཀཱརཎཱཏ྄ ནཝཱིནསྲྀཥྚིཀཱལེ ཡདཱ མནུཛསུཏཿ སྭཱིཡཻཤྩཪྻྱསིཾཧཱསན ཨུཔཝེཀྵྱཏི, ཏདཱ ཡཱུཡམཔི དྭཱདཤསིཾཧཱསནེཥཱུཔཝིཤྱ ཨིསྲཱཡེལཱིཡདྭཱདཤཝཾཤཱནཱཾ ཝིཙཱརཾ ཀརིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ཨནྱཙྩ ཡཿ ཀཤྩིཏ྄ མམ ནཱམཀཱརཎཱཏ྄ གྲྀཧཾ ཝཱ བྷྲཱཏརཾ ཝཱ བྷགིནཱིཾ ཝཱ པིཏརཾ ཝཱ མཱཏརཾ ཝཱ ཛཱཡཱཾ ཝཱ བཱལཀཾ ཝཱ བྷཱུམིཾ པརིཏྱཛཏི, ས ཏེཥཱཾ ཤཏགུཎཾ ལཔྶྱཏེ, ཨནནྟཱཡུམོ྅དྷིཀཱརིཏྭཉྩ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ཀིནྟུ ཨགྲཱིཡཱ ཨནེཀེ ཛནཱཿ པཤྩཱཏ྄, པཤྩཱཏཱིཡཱཤྩཱནེཀེ ལོཀཱ ཨགྲེ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","སྭརྒརཱཛྱམ྄ ཨེཏཱདྲྀཤཱ ཀེནཙིད྄ གྲྀཧསྱེན སམཾ, ཡོ྅ཏིཔྲབྷཱཏེ ནིཛདྲཱཀྵཱཀྵེཏྲེ ཀྲྀཥཀཱན྄ ནིཡོཀྟུཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","པཤྩཱཏ྄ ཏཻཿ སཱཀཾ དིནཻཀབྷྲྀཏིཾ མུདྲཱཙཏུརྠཱཾཤཾ ནིརཱུཔྱ ཏཱན྄ དྲཱཀྵཱཀྵེཏྲཾ པྲེརཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ཨནནྟརཾ པྲཧརཻཀཝེལཱཡཱཾ གཏྭཱ ཧཊྚེ ཀཏིཔཡཱན྄ ནིཥྐརྨྨཀཱན྄ ཝིལོཀྱ ཏཱནཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ཡཱུཡམཔི མམ དྲཱཀྵཱཀྵེཏྲཾ ཡཱཏ, ཡུཥྨབྷྱམཧཾ ཡོགྱབྷྲྀཏིཾ དཱསྱཱམི, ཏཏསྟེ ཝཝྲཛུཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","པུནཤྩ ས དྭིཏཱིཡཏྲྀཏཱིཡཡོཿ པྲཧརཡོ རྦཧི རྒཏྭཱ ཏཐཻཝ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ཏཏོ དཎྜདྭཡཱཝཤིཥྚཱཡཱཾ ཝེལཱཡཱཾ བཧི རྒཏྭཱཔརཱན྄ ཀཏིཔཡཛནཱན྄ ནིཥྐརྨྨཀཱན྄ ཝིལོཀྱ པྲྀཥྚཝཱན྄, ཡཱུཡཾ ཀིམརྠམ྄ ཨཏྲ སཪྻྭཾ དིནཾ ནིཥྐརྨྨཱཎསྟིཥྛཐ? ");
INSERT INTO santib_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ཏེ པྲཏྱཝདན྄, ཨསྨཱན྄ ན ཀོཔི ཀརྨམཎི ནིཡུཾཀྟེ། ཏདཱནཱིཾ ས ཀཐིཏཝཱན྄, ཡཱུཡམཔི མམ དྲཱཀྵཱཀྵེཏྲཾ ཡཱཏ, ཏེན ཡོགྱཱཾ བྷྲྀཏིཾ ལཔྶྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ཏདནནྟརཾ སནྡྷྱཱཡཱཾ སཏྱཱཾ སཨེཝ དྲཱཀྵཱཀྵེཏྲཔཏིརདྷྱཀྵཾ གདིཝཱན྄, ཀྲྀཥཀཱན྄ ཨཱཧཱུཡ ཤེཥཛནམཱརབྷྱ པྲཐམཾ ཡཱཝཏ྄ ཏེབྷྱོ བྷྲྀཏིཾ དེཧི། ");
INSERT INTO santib_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ཏེན ཡེ དཎྜདྭཡཱཝསྠིཏེ སམཱཡཱཏཱསྟེཥཱམ྄ ཨེཀཻཀོ ཛནོ མུདྲཱཙཏུརྠཱཾཤཾ པྲཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ཏདཱནཱིཾ པྲཐམནིཡུཀྟཱ ཛནཱ ཨཱགཏྱཱནུམིཏཝནྟོ ཝཡམདྷིཀཾ པྲཔྶྱཱམཿ, ཀིནྟུ ཏཻརཔི མུདྲཱཙཏུརྠཱཾཤོ྅ལཱབྷི། ");
INSERT INTO santib_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ཏཏསྟེ ཏཾ གྲྀཧཱིཏྭཱ ཏེན ཀྵེཏྲཔཏིནཱ སཱཀཾ ཝཱགྱུདྡྷཾ ཀུཪྻྭནྟཿ ཀཐཡཱམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ཝཡཾ ཀྲྀཏྶྣཾ དིནཾ ཏཱཔཀླེཤཽ སོཌྷཝནྟཿ, ཀིནྟུ པཤྩཱཏཱཡཱ སེ ཛནཱ དཎྜདྭཡམཱཏྲཾ པརིཤྲཱནྟཝནྟསྟེ྅སྨཱབྷིཿ སམཱནཱཾཤཱཿ ཀྲྀཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ཏཏཿ ས ཏེཥཱམེཀཾ པྲཏྱུཝཱཙ, ཧེ ཝཏྶ, མཡཱ ཏྭཱཾ པྲཏི ཀོཔྱནྱཱཡོ ན ཀྲྀཏཿ ཀིཾ ཏྭཡཱ མཏྶམཀྵཾ མུདྲཱཙཏུརྠཱཾཤོ ནཱངྒཱིཀྲྀཏཿ? ");
INSERT INTO santib_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ཏསྨཱཏ྄ ཏཝ ཡཏ྄ པྲཱཔྱཾ ཏདཱདཱཡ ཡཱཧི, ཏུབྷྱཾ ཡཏི, པཤྩཱཏཱིཡནིཡུཀྟལོཀཱཡཱཔི ཏཏི དཱཏུམིཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","སྭེཙྪཡཱ ནིཛདྲཝྱཝྱཝཧརཎཾ ཀིཾ མཡཱ ན ཀརྟྟཝྱཾ? མམ དཱཏྲྀཏྭཱཏ྄ ཏྭཡཱ ཀིམ྄ ཨཱིརྵྱཱདྲྀཥྚིཿ ཀྲིཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ཨིཏྠམ྄ ཨགྲཱིཡལོཀཱཿ པཤྩཏཱིཡཱ བྷཝིཥྱནྟི, པཤྩཱཏཱིཡཛནཱཤྩགྲཱིཡཱ བྷཝིཥྱནྟི, ཨཧཱུཏཱ བཧཝཿ ཀིནྟྭལྤེ མནོབྷིལཥིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ཏདནནྟརཾ ཡཱིཤུ ཪྻིརཱུཤཱལམྣགརཾ གཙྪན྄ མཱརྒམདྷྱེ ཤིཥྱཱན྄ ཨེཀཱནྟེ ཝབྷཱཥེ, ");
INSERT INTO santib_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","པཤྱ ཝཡཾ ཡིརཱུཤཱལམྣགརཾ ཡཱམཿ, ཏཏྲ པྲདྷཱནཡཱཛཀཱདྷྱཱཔཀཱནཱཾ ཀརེཥུ མནུཥྱཔུཏྲཿ སམརྤིཥྱཏེ; ");
INSERT INTO santib_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ཏེ ཙ ཏཾ ཧནྟུམཱཛྙཱཔྱ ཏིརསྐྲྀཏྱ ཝེཏྲེཎ པྲཧརྟྟུཾ ཀྲུཤེ དྷཱཏཡིཏུཉྩཱནྱདེཤཱིཡཱནཱཾ ཀརེཥུ སམརྤཡིཥྱནྟི, ཀིནྟུ ས ཏྲྀཏཱིཡདིཝསེ ཤྨཤཱནཱད྄ ཨུཏྠཱཔིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ཏདཱནཱིཾ སིཝདཱིཡསྱ ནཱརཱི སྭཔུཏྲཱཝཱདཱཡ ཡཱིཤོཿ སམཱིཔམ྄ ཨེཏྱ པྲཎམྱ ཀཉྩནཱནུགྲཧཾ ཏཾ ཡཡཱཙེ། ");
INSERT INTO santib_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ཏདཱ ཡཱིཤུསྟཱཾ པྲོཀྟཝཱན྄, ཏྭཾ ཀིཾ ཡཱཙསེ? ཏཏཿ སཱ བབྷཱཥེ, བྷཝཏོ རཱཛཏྭེ མམཱནཡོཿ སུཏཡོརེཀཾ བྷཝདྡཀྵིཎཔཱརྴྭེ དྭིཏཱིཡཾ ཝཱམཔཱརྴྭ ཨུཔཝེཥྚུམ྄ ཨཱཛྙཱཔཡཏུ། ");
INSERT INTO santib_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ཡཱིཤུཿ པྲཏྱུཝཱཙ, ཡུཝཱབྷྱཱཾ ཡད྄ ཡཱཙྱཏེ, ཏནྣ བུདྷྱཏེ, ཨཧཾ ཡེན ཀཾསེན པཱསྱཱམི ཡུཝཱབྷྱཱཾ ཀིཾ ཏེན པཱཏུཾ ཤཀྱཏེ? ཨཧཉྩ ཡེན མཛྫེནེན མཛྫིཥྱེ, ཡུཝཱབྷྱཱཾ ཀིཾ ཏེན མཛྫཡིཏུཾ ཤཀྱཏེ? ཏེ ཛགདུཿ ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ཏདཱ ས ཨུཀྟཝཱན྄, ཡུཝཱཾ མམ ཀཾསེནཱཝཤྱཾ པཱསྱཐཿ, མམ མཛྫནེན ཙ ཡུཝཱམཔི མཛྫིཥྱེཐེ, ཀིནྟུ ཡེཥཱཾ ཀྲྀཏེ མཏྟཱཏེན ནིརཱུཔིཏམ྄ ཨིདཾ ཏཱན྄ ཝིཧཱཡཱནྱཾ ཀམཔི མདྡཀྵིཎཔཱརྴྭེ ཝཱམཔཱརྴྭེ ཙ སམུཔཝེཤཡིཏུཾ མམཱདྷིཀཱརོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱནྱེ དཤཤིཥྱཱསྟཽ བྷྲཱཏརཽ པྲཏི ཙུཀུཔུཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ཀིནྟུ ཡཱིཤུཿ སྭསམཱིཔཾ ཏཱནཱཧཱུཡ ཛགཱད, ཨནྱདེཤཱིཡལོཀཱནཱཾ ནརཔཏཡསྟཱན྄ ཨདྷིཀུཪྻྭནྟི, ཡེ ཏུ མཧཱནྟསྟེ ཏཱན྄ ཤཱསཏི, ཨིཏི ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ཀིནྟུ ཡུཥྨཱཀཾ མདྷྱེ ན ཏཐཱ བྷཝེཏ྄, ཡུཥྨཱཀཾ ཡཿ ཀཤྩིཏ྄ མཧཱན྄ བུབྷཱུཥཏི, ས ཡུཥྨཱན྄ སེཝེཏ; ");
INSERT INTO santib_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ཡཤྩ ཡུཥྨཱཀཾ མདྷྱེ མུཁྱོ བུབྷཱུཥཏི, ས ཡུཥྨཱཀཾ དཱསོ བྷཝེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ཨིཏྠཾ མནུཛཔུཏྲཿ སེཝྱོ བྷཝིཏུཾ ནཧི, ཀིནྟུ སེཝིཏུཾ བཧཱུནཱཾ པརིཏྲཱཎམཱུལྱཱརྠཾ སྭཔྲཱཎཱན྄ དཱཏུཉྩཱགཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ཨནནྟརཾ ཡིརཱིཧོནགརཱཏ྄ ཏེཥཱཾ བཧིརྒམནསམཡེ ཏསྱ པཤྩཱད྄ བཧཝོ ལོཀཱ ཝཝྲཛུཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ཨཔརཾ ཝརྟྨཔཱརྴྭ ཨུཔཝིཤནྟཽ དྭཱཝནྡྷཽ ཏེན མཱརྒེཎ ཡཱིཤོ རྒམནཾ ནིཤམྱ པྲོཙྩཻཿ ཀཐཡཱམཱསཏུཿ, ཧེ པྲབྷོ དཱཡཱུདཿ སནྟཱན, ཨཱཝཡོ རྡཡཱཾ ཝིདྷེཧི། ");
INSERT INTO santib_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ཏཏོ ལོཀཱཿ སཪྻྭེ ཏུཥྞཱིམྦྷཝཏམིཏྱུཀྟྭཱ ཏཽ ཏརྫཡཱམཱསུཿ; ཏཐཱཔི ཏཽ པུནརུཙྩཻཿ ཀཐཡཱམཱསཏུཿ ཧེ པྲབྷོ དཱཡཱུདཿ སནྟཱན, ཨཱཝཱཾ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ཏདཱནཱིཾ ཡཱིཤུཿ སྠགིཏཿ སན྄ ཏཱཝཱཧཱུཡ བྷཱཥིཏཝཱན྄, ཡུཝཡོཿ ཀྲྀཏེ མཡཱ ཀིཾ ཀརྟྟཪྻྱཾ? ཡུཝཱཾ ཀིཾ ཀཱམཡེཐེ? ");
INSERT INTO santib_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ཏདཱ ཏཱཝུཀྟཝནྟཽ, པྲབྷོ ནེཏྲཱཎི ནཽ པྲསནྣཱནི བྷཝེཡུཿ། ");
INSERT INTO santib_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ཏདཱནཱིཾ ཡཱིཤུསྟཽ པྲཏི པྲམནྣཿ སན྄ ཏཡོ རྣེཏྲཱཎི པསྤརྴ, ཏེནཻཝ ཏཽ སུཝཱིཀྵཱཉྩཀྲཱཏེ ཏཏྤཤྩཱཏ྄ ཛགྨུཏུཤྩ། ");
INSERT INTO santib_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ཨནནྟརཾ ཏེཥུ ཡིརཱུཤཱལམྣགརསྱ སམཱིཔཝེརྟྟིནོ ཛཻཏུནནཱམཀདྷརཱདྷརསྱ སམཱིཔསྠྟིཾ བཻཏྥགིགྲཱམམ྄ ཨཱགཏེཥུ, ཡཱིཤུཿ ཤིཥྱདྭཡཾ པྲེཥཡན྄ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ཡུཝཱཾ སམྨུཁསྠགྲཱམཾ གཏྭཱ བདྡྷཱཾ ཡཱཾ སཝཏྶཱཾ གརྡྡབྷཱིཾ ཧཋཱཏ྄ པྲཱཔྶྱཐཿ, ཏཱཾ མོཙཡིཏྭཱ མདནྟིཀམ྄ ཨཱནཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ཏཏྲ ཡདི ཀཤྩིཏ྄ ཀིཉྩིད྄ ཝཀྵྱཏི, ཏརྷི ཝདིཥྱཐཿ, ཨེཏསྱཱཾ པྲབྷོཿ པྲཡོཛནམཱསྟེ, ཏེན ས ཏཏྐྵཎཱཏ྄ པྲཧེཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","སཱིཡོནཿ ཀནྱཀཱཾ ཡཱུཡཾ བྷཱཥདྷྭམིཏི བྷཱརཏཱིཾ། པཤྱ ཏེ ནམྲཤཱིལཿ སན྄ ནྲྀཔ ཨཱརུཧྱ གརྡབྷཱིཾ། ཨརྠཱདཱརུཧྱ ཏདྭཏྶམཱཡཱསྱཏི ཏྭདནྟིཀཾ། ");
INSERT INTO santib_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","བྷཝིཥྱདྭཱདིནོཀྟཾ ཝཙནམིདཾ ཏདཱ སཕལམབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ཨནནྟརཾ ཏཽ ཤྵྱིौ ཡཱིཤོ ཪྻཐཱནིདེཤཾ ཏཾ གྲཱམཾ གཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","གརྡབྷཱིཾ ཏདྭཏྶཉྩ སམཱནཱིཏཝནྟཽ, པཤྩཱཏ྄ ཏདུཔརི སྭཱིཡཝསནཱནཱི པཱཏཡིཏྭཱ ཏམཱརོཧཡཱམཱསཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ཏཏོ བཧཝོ ལོཀཱ ནིཛཝསནཱནི པཐི པྲསཱརཡིཏུམཱརེབྷིརེ, ཀཏིཔཡཱ ཛནཱཤྩ པཱདཔཔརྞཱདིཀཾ ཚིཏྭཱ པཐི ཝིསྟཱརཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ཨགྲགཱམིནཿ པཤྩཱདྒཱམིནཤྩ མནུཛཱ ཨུཙྩཻརྫཡ ཛཡ དཱཡཱུདཿ སནྟཱནེཏི ཛགདུཿ པརམེཤྭརསྱ ནཱམྣཱ ཡ ཨཱཡཱཏི ས དྷནྱཿ, སཪྻྭོཔརིསྠསྭརྒེཔི ཛཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ཨིཏྠཾ ཏསྨིན྄ ཡིརཱུཤཱལམཾ པྲཝིཥྚེ ཀོ྅ཡམིཏི ཀཐནཱཏ྄ ཀྲྀཏྶྣཾ ནགརཾ ཙཉྩལམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ཏཏྲ ལོཀོཿ ཀཐཡཱམཱསུཿ, ཨེཥ གཱལཱིལྤྲདེཤཱིཡ-ནཱསརཏཱིཡ-བྷཝིཥྱདྭཱདཱི ཡཱིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ཨནནྟརཾ ཡཱིཤུརཱིཤྭརསྱ མནྡིརཾ པྲཝིཤྱ ཏནྨདྷྱཱཏ྄ ཀྲཡཝིཀྲཡིཎོ ཝཧིཤྩཀཱར; ཝཎིཛཱཾ མུདྲཱསནཱནཱི ཀཔོཏཝིཀྲཡིཎཱཉྩསནཱནཱི ཙ ནྱུཝྫཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ཨཔརཾ ཏཱནུཝཱཙ, ཨེཥཱ ལིཔིརཱསྟེ, \"མམ གྲྀཧཾ པྲཱརྠནཱགྲྀཧམིཏི ཝིཁྱཱསྱཏི\", ཀིནྟུ ཡཱུཡཾ ཏད྄ དསྱཱུནཱཾ གཧྭརཾ ཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ཏདནནྟརམ྄ ཨནྡྷཁཉྩལོཀཱསྟསྱ སམཱིཔམཱགཏཱཿ, ས ཏཱན྄ ནིརཱམཡཱན྄ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ཡདཱ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ ཏེན ཀྲྀཏཱནྱེཏཱནི ཙིཏྲཀརྨྨཱཎི དདྲྀཤུཿ, ཛཡ ཛཡ དཱཡཱུདཿ སནྟཱན, མནྡིརེ བཱལཀཱནཱམ྄ ཨེཏཱདྲྀཤམ྄ ཨུཙྩདྷྭནིཾ ཤུཤྲུཝུཤྩ, ཏདཱ མཧཱཀྲུདྡྷཱ བབྷཱུཝཿ, ");
INSERT INTO santib_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ཏཾ པཔྲཙྪུཤྩ, ཨིམེ ཡད྄ ཝདནྟི, ཏཏ྄ ཀིཾ ཏྭཾ ཤྲྀཎོཥི? ཏཏོ ཡཱིཤུསྟཱན྄ ཨཝོཙཏ྄, སཏྱམ྄; སྟནྱཔཱཡིཤིཤཱུནཱཉྩ བཱལཀཱནཱཉྩ ཝཀྟྲཏཿ། སྭཀཱིཡཾ མཧིམཱནཾ ཏྭཾ སཾཔྲཀཱཤཡསི སྭཡཾ། ཨེཏདྭཱཀྱཾ ཡཱུཡཾ ཀིཾ ནཱཔཋཏ? ");
INSERT INTO santib_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ཏཏསྟཱན྄ ཝིཧཱཡ ས ནགརཱད྄ བཻཐནིཡཱགྲཱམཾ གཏྭཱ ཏཏྲ རཛནཱིཾ ཡཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ཨནནྟརཾ པྲབྷཱཏེ སཏི ཡཱིཤུཿ པུནརཔི ནགརམཱགཙྪན྄ ཀྵུདྷཱརྟྟོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ཏཏོ མཱརྒཔཱརྴྭ ཨུཌུམྦརཝྲྀཀྵམེཀཾ ཝིལོཀྱ ཏཏྶམཱིཔཾ གཏྭཱ པཏྲཱཎི ཝིནཱ ཀིམཔི ན པྲཱཔྱ ཏཾ པཱདཔཾ པྲོཝཱཙ, ཨདྱཱརབྷྱ ཀདཱཔི ཏྭཡི ཕལཾ ན བྷཝཏུ; ཏེན ཏཏྐྵཎཱཏ྄ ས ཨུཌུམྦརམཱཧཱིརུཧཿ ཤུཥྐཏཱཾ གཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ཏད྄ དྲྀཥྚྭཱ ཤིཥྱཱ ཨཱཤྩཪྻྱཾ ཝིཛྙཱཡ ཀཐཡཱམཱསུཿ, ཨཱཿ, ཨུཌུམྭརཔཱདཔོ྅ཏིཏཱུརྞཾ ཤུཥྐོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ཏཏོ ཡཱིཤུསྟཱནུཝཱཙ, ཡུཥྨཱནཧཾ སཏྱཾ ཝདཱམི, ཡདི ཡཱུཡམསནྡིགྡྷཱཿ པྲཏཱིཐ, ཏརྷི ཡཱུཡམཔི ཀེཝལོཌུམྭརཔཱདཔཾ པྲཏཱིཏྠཾ ཀརྟྟུཾ ཤཀྵྱཐ, ཏནྣ, ཏྭཾ ཙལིཏྭཱ སཱགརེ པཏེཏི ཝཱཀྱཾ ཡུཥྨཱབྷིརསྨིན ཤཻལེ པྲོཀྟེཔི ཏདཻཝ ཏད྄ གྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ཏཐཱ ཝིཤྭསྱ པྲཱརྠྱ ཡུཥྨཱབྷི ཪྻད྄ ཡཱཙིཥྱཏེ, ཏདེཝ པྲཱཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ཨནནྟརཾ མནྡིརཾ པྲཝིཤྱོཔདེཤནསམཡེ ཏཏྶམཱིཔཾ པྲདྷཱནཡཱཛཀཱཿ པྲཱཙཱིནལོཀཱཤྩཱགཏྱ པཔྲཙྪུཿ, ཏྭཡཱ ཀེན སཱམརྠྱནཻཏཱནི ཀརྨྨཱཎི ཀྲིཡནྟེ? ཀེན ཝཱ ཏུབྷྱམེཏཱནི སཱམརྠྱཱནི དཏྟཱནི? ");
INSERT INTO santib_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ཏཏོ ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཨཧམཔི ཡུཥྨཱན྄ ཝཱཙམེཀཱཾ པྲྀཙྪཱམི, ཡདི ཡཱུཡཾ ཏདུཏྟརཾ དཱཏུཾ ཤཀྵྱཐ, ཏདཱ ཀེན སཱམརྠྱེན ཀརྨྨཱཎྱེཏཱནི ཀརོམི, ཏདཧཾ ཡུཥྨཱན྄ ཝཀྵྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ཡོཧནོ མཛྫནཾ ཀསྱཱཛྙཡཱབྷཝཏ྄? ཀིམཱིཤྭརསྱ མནུཥྱསྱ ཝཱ? ཏཏསྟེ པརསྤརཾ ཝིཝིཙྱ ཀཐཡཱམཱསུཿ, ཡདཱིཤྭརསྱེཏི ཝདཱམསྟརྷི ཡཱུཡཾ ཏཾ ཀུཏོ ན པྲཏྱཻཏ? ཝཱཙམེཏཱཾ ཝཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","མནུཥྱསྱེཏི ཝཀྟུམཔི ལོཀེབྷྱོ བིབྷཱིམཿ, ཡཏཿ སཪྻྭཻརཔི ཡོཧན྄ བྷཝིཥྱདྭཱདཱིཏི ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ཏསྨཱཏ྄ ཏེ ཡཱིཤུཾ པྲཏྱཝདན྄, ཏད྄ ཝཡཾ ན ཝིདྨཿ། ཏདཱ ས ཏཱནུཀྟཝཱན྄, ཏརྷི ཀེན སཱམརཐྱེན ཀརྨྨཱཎྱེཏཱནྱཧཾ ཀརོམི, ཏདཔྱཧཾ ཡུཥྨཱན྄ ན ཝཀྵྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ཀསྱཙིཛྫནསྱ དྭཽ སུཏཱཝཱསྟཱཾ ས ཨེཀསྱ སུཏསྱ སམཱིཔཾ གཏྭཱ ཛགཱད, ཧེ སུཏ, ཏྭམདྱ མམ དྲཱཀྵཱཀྵེཏྲེ ཀརྨྨ ཀརྟུཾ ཝྲཛ། ");
INSERT INTO santib_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ཏཏཿ ས ཨུཀྟཝཱན྄, ན ཡཱསྱཱམི, ཀིནྟུ ཤེཥེ྅ནུཏཔྱ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ཨནནྟརཾ སོནྱསུཏསྱ སམཱིཔཾ གཏྭཱ ཏཐཻཝ ཀཐྟིཝཱན྄; ཏཏཿ ས པྲཏྱུཝཱཙ, མཧེཙྪ ཡཱམི, ཀིནྟུ ན གཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ཨེཏཡོཿ པུཏྲཡོ རྨདྷྱེ པིཏུརབྷིམཏཾ ཀེན པཱལིཏཾ? ཡུཥྨཱབྷིཿ ཀིཾ བུདྷྱཏེ? ཏཏསྟེ པྲཏྱཱུཙུཿ, པྲཐམེན པུुཏྲེཎ། ཏདཱནཱིཾ ཡཱིཤུསྟཱནུཝཱཙ, ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི, ཙཎྜཱལཱ གཎིཀཱཤྩ ཡུཥྨཱཀམགྲཏ ཨཱིཤྭརསྱ རཱཛྱཾ པྲཝིཤནྟི། ");
INSERT INTO santib_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ཡཏོ ཡུཥྨཱཀཾ སམཱིཔཾ ཡོཧནི དྷརྨྨཔཐེནཱགཏེ ཡཱུཡཾ ཏཾ ན པྲཏཱིཐ, ཀིནྟུ ཙཎྜཱལཱ གཎིཀཱཤྩ ཏཾ པྲཏྱཱཡན྄, ཏད྄ ཝིལོཀྱཱཔི ཡཱུཡཾ པྲཏྱེཏུཾ ནཱཁིདྱདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ཨཔརམེཀཾ དྲྀཥྚཱནྟཾ ཤྲྀཎུཏ, ཀཤྩིད྄ གྲྀཧསྠཿ ཀྵེཏྲེ དྲཱཀྵཱལཏཱ རོཔཡིཏྭཱ ཏཙྩཏུརྡིཀྵུ ཝཱརཎཱིཾ ཝིདྷཱཡ ཏནྨདྷྱེ དྲཱཀྵཱཡནྟྲཾ སྠཱཔིཏཝཱན྄, མཱཉྩཉྩ ནིརྨྨིཏཝཱན྄, ཏཏཿ ཀྲྀཥཀེཥུ ཏཏ྄ ཀྵེཏྲཾ སམརྤྱ སྭཡཾ དཱུརདེཤཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ཏདནནྟརཾ ཕལསམཡ ཨུཔསྠིཏེ ས ཕལཱནི པྲཱཔྟུཾ ཀྲྀཥཱིཝལཱནཱཾ སམཱིཔཾ ནིཛདཱསཱན྄ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ཀིནྟུ ཀྲྀཥཱིཝལཱསྟསྱ ཏཱན྄ དཱསེཡཱན྄ དྷྲྀཏྭཱ ཀཉྩན པྲཧྲྀཏཝནྟཿ, ཀཉྩན པཱཥཱཎཻརཱཧཏཝནྟཿ, ཀཉྩན ཙ ཧཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","པུནརཔི ས པྲབྷུཿ པྲཐམཏོ྅དྷིཀདཱསེཡཱན྄ པྲེཥཡཱམཱས, ཀིནྟུ ཏེ ཏཱན྄ པྲཏྱཔི ཏཐཻཝ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ཨནནྟརཾ མམ སུཏེ གཏེ ཏཾ སམཱདརིཥྱནྟེ, ཨིཏྱུཀྟྭཱ ཤེཥེ ས ནིཛསུཏཾ ཏེཥཱཾ སནྣིདྷིཾ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ཀིནྟུ ཏེ ཀྲྀཥཱིཝལཱཿ སུཏཾ ཝཱིཀྵྱ པརསྤརམ྄ ཨིཏི མནྟྲཡིཏུམ྄ ཨཱརེབྷིརེ, ཨཡམུཏྟརཱདྷིཀཱརཱི ཝཡམེནཾ ནིཧཏྱཱསྱཱདྷིཀཱརཾ སྭཝཤཱིཀརིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","པཤྩཱཏ྄ ཏེ ཏཾ དྷྲྀཏྭཱ དྲཱཀྵཱཀྵེཏྲཱད྄ བཧིཿ པཱཏཡིཏྭཱབདྷིཥུཿ། ");
INSERT INTO santib_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ཡདཱ ས དྲཱཀྵཱཀྵེཏྲཔཏིརཱགམིཥྱཏི, ཏདཱ ཏཱན྄ ཀྲྀཥཱིཝལཱན྄ ཀིཾ ཀརིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ཏཏསྟེ པྲཏྱཝདན྄, ཏཱན྄ ཀལུཥིཎོ དཱརུཎཡཱཏནཱབྷིརཱཧནིཥྱཏི, ཡེ ཙ སམཡཱནུཀྲམཱཏ྄ ཕལཱནི དཱསྱནྟི, ཏཱདྲྀཤེཥུ ཀྲྀཥཱིཝལེཥུ ཀྵེཏྲཾ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ཏདཱ ཡཱིཤུནཱ ཏེ གདིཏཱཿ, གྲཧཎཾ ན ཀྲྀཏཾ ཡསྱ པཱཥཱཎསྱ ནིཙཱཡཀཻཿ། པྲདྷཱནཔྲསྟརཿ ཀོཎེ སཨེཝ སཾབྷཝིཥྱཏི། ཨེཏཏ྄ པརེཤིཏུཿ ཀརྨྨཱསྨདྲྀཥྚཱཝདྦྷུཏཾ བྷཝེཏ྄། དྷརྨྨགྲནྠེ ལིཁིཏམེཏདྭཙནཾ ཡུཥྨཱབྷིཿ ཀིཾ ནཱཔཱཋི? ");
INSERT INTO santib_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ཏསྨཱདཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཡུཥྨཏྟ ཨཱིཤྭརཱིཡརཱཛྱམཔནཱིཡ ཕལོཏྤཱདཡིཏྲནྱཛཱཏཡེ དཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ཡོ ཛན ཨེཏཏྤཱཥཱཎོཔརི པཏིཥྱཏི, ཏཾ ས བྷཾཀྵྱཏེ, ཀིནྟྭཡཾ པཱཥཱཎོ ཡསྱོཔརི པཏིཥྱཏི, ཏཾ ས དྷཱུལིཝཏ྄ ཙཱུརྞཱིཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ཏདཱནཱིཾ པྲཱདྷནཡཱཛཀཱཿ ཕིརཱུཤིནཤྩ ཏསྱེམཱཾ དྲྀཥྚཱནྟཀཐཱཾ ཤྲུཏྭཱ སོ྅སྨཱནུདྡིཤྱ ཀཐིཏཝཱན྄, ཨིཏི ཝིཛྙཱཡ ཏཾ དྷརྟྟུཾ ཙེཥྚིཏཝནྟཿ; ");
INSERT INTO santib_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ཀིནྟུ ལོཀེབྷྱོ བིབྷྱུཿ, ཡཏོ ལོཀཻཿ ས བྷཝིཥྱདྭཱདཱིཏྱཛྙཱཡི། ");
INSERT INTO santib_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ཨནནྟརཾ ཡཱིཤུཿ པུནརཔི དྲྀཥྚཱནྟེན ཏཱན྄ ཨཝཱདཱིཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","སྭརྒཱིཡརཱཛྱམ྄ ཨེཏཱདྲྀཤསྱ ནྲྀཔཏེཿ སམཾ, ཡོ ནིཛ པུཏྲཾ ཝིཝཱཧཡན྄ སཪྻྭཱན྄ ནིམནྟྲིཏཱན྄ ཨཱནེཏུཾ དཱསེཡཱན྄ པྲཧིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ཀིནྟུ ཏེ སམཱགནྟུཾ ནེཥྚཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ཏཏོ རཱཛཱ པུནརཔི དཱསཱནནྱཱན྄ ཨིཏྱུཀྟྭཱ པྲེཥཡཱམཱས, ནིམནྟྲིཏཱན྄ ཝདཏ, པཤྱཏ, མམ བྷེཛྱམཱསཱདིཏམཱསྟེ, ནིཛཝྚཥཱདིཔུཥྚཛནྟཱུན྄ མཱརཡིཏྭཱ སཪྻྭཾ ཁཱདྱདྲཝྱམཱསཱདིཏཝཱན྄, ཡཱུཡཾ ཝིཝཱཧམཱགཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ཏཐཔི ཏེ ཏུཙྪཱིཀྲྀཏྱ ཀེཙིཏ྄ ནིཛཀྵེཏྲཾ ཀེཙིད྄ ཝཱཎིཛྱཾ པྲཏི སྭསྭམཱརྒེཎ ཙལིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ཨནྱེ ལོཀཱསྟསྱ དཱསེཡཱན྄ དྷྲྀཏྭཱ དཽརཱཏྨྱཾ ཝྱཝཧྲྀཏྱ ཏཱནཝདྷིཥུཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ཨནནྟརཾ ས ནྲྀཔཏིསྟཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱ ཀྲུདྷྱན྄ སཻནྱཱནི པྲཧིཏྱ ཏཱན྄ གྷཱཏཀཱན྄ ཧཏྭཱ ཏེཥཱཾ ནགརཾ དཱཧཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ཏཏཿ ས ནིཛདཱསེཡཱན྄ བབྷཱཥེ, ཝིཝཱཧཱིཡཾ བྷོཛྱམཱསཱདིཏམཱསྟེ, ཀིནྟུ ནིམནྟྲིཏཱ ཛནཱ ཨཡོགྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ཏསྨཱད྄ ཡཱུཡཾ རཱཛམཱརྒཾ གཏྭཱ ཡཱཝཏོ མནུཛཱན྄ པཤྱཏ, ཏཱཝཏཨེཝ ཝིཝཱཧཱིཡབྷོཛྱཱཡ ནིམནྟྲཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ཏདཱ ཏེ དཱསེཡཱ རཱཛམཱརྒཾ གཏྭཱ བྷདྲཱན྄ ཨབྷདྲཱན྄ ཝཱ ཡཱཝཏོ ཛནཱན྄ དདྲྀཤུཿ, ཏཱཝཏཨེཝ སཾགྲྀཧྱཱནཡན྄; ཏཏོ྅བྷྱཱགཏམནུཛཻ ཪྻིཝཱཧགྲྀཧམ྄ ཨཔཱུཪྻྱཏ། ");
INSERT INTO santib_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ཏདཱནཱིཾ ས རཱཛཱ སཪྻྭཱནབྷྱཱགཏཱན྄ དྲཥྚུམ྄ ཨབྷྱནྟརམཱགཏཝཱན྄; ཏདཱ ཏཏྲ ཝིཝཱཧཱིཡཝསནཧཱིནམེཀཾ ཛནཾ ཝཱིཀྵྱ ཏཾ ཛགཱད྄, ");
INSERT INTO santib_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ཧེ མིཏྲ,ཏྭཾ ཝིཝཱཧཱིཡཝསནཾ ཝིནཱ ཀཐམཏྲ པྲཝིཥྚཝཱན྄? ཏེན ས ནིརུཏྟརོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ཏདཱ རཱཛཱ ནིཛཱནུཙརཱན྄ ཨཝདཏ྄, ཨེཏསྱ ཀརཙརཎཱན྄ བདྡྷཱ ཡཏྲ རོདནཾ དནྟཻརྡནྟགྷརྵཎཉྩ བྷཝཏི, ཏཏྲ ཝཧིརྦྷཱུཏཏམིསྲེ ཏཾ ནིཀྵིཔཏ། ");
INSERT INTO santib_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ཨིཏྠཾ བཧཝ ཨཱཧཱུཏཱ ཨལྤེ མནོབྷིམཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ཨནནྟརཾ ཕིརཱུཤིནཿ པྲགཏྱ ཡཐཱ སཾལཱཔེན ཏམ྄ ཨུནྨཱཐེ པཱཏཡེཡུསྟཐཱ མནྟྲཡིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ཧེརོདཱིཡམནུཛཻཿ སཱཀཾ ནིཛཤིཥྱགཎེན ཏཾ པྲཏི ཀཐཡཱམཱསུཿ, ཧེ གུརོ, བྷཝཱན྄ སཏྱཿ སཏྱམཱིཤྭརཱིཡམཱརྒམུཔདིཤཏི, ཀམཔི མཱནུཥཾ ནཱནུརུདྷྱཏེ, ཀམཔི ནཱཔེཀྵཏེ ཙ, ཏད྄ ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ཨཏཿ ཀཻསརབྷཱུཔཱཡ ཀརོ྅སྨཱཀཾ དཱཏཝྱོ ན ཝཱ? ཨཏྲ བྷཝཏཱ ཀིཾ བུདྷྱཏེ? ཏད྄ ཨསྨཱན྄ ཝདཏུ། ");
INSERT INTO santib_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ཏཏོ ཡཱིཤུསྟེཥཱཾ ཁལཏཱཾ ཝིཛྙཱཡ ཀཐིཏཝཱན྄, རེ ཀཔཊིནཿ ཡུཡཾ ཀུཏོ མཱཾ པརིཀྵདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ཏཏྐརདཱནསྱ མུདྲཱཾ མཱཾ དརྴཡཏ། ཏདཱནཱིཾ ཏཻསྟསྱ སམཱིཔཾ མུདྲཱཙཏུརྠབྷཱག ཨཱནཱིཏེ ");
INSERT INTO santib_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ས ཏཱན྄ པཔྲཙྪ, ཨཏྲ ཀསྱེཡཾ མཱུརྟྟི རྣཱམ ཙཱསྟེ? ཏེ ཛགདུཿ, ཀཻསརབྷཱུཔསྱ། ");
INSERT INTO santib_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ཏཏཿ ས ཨུཀྟཝཱན, ཀཻསརསྱ ཡཏ྄ ཏཏ྄ ཀཻསརཱཡ དཏྟ, ཨཱིཤྭརསྱ ཡཏ྄ ཏད྄ ཨཱིཤྭརཱཡ དཏྟ། ");
INSERT INTO santib_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ཨིཏི ཝཱཀྱཾ ནིཤམྱ ཏེ ཝིསྨཡཾ ཝིཛྙཱཡ ཏཾ ཝིཧཱཡ ཙལིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ཏསྨིནྣཧནི སིདཱུཀིནོ྅རྠཱཏ྄ ཤྨཤཱནཱཏ྄ ནོཏྠཱསྱནྟཱིཏི ཝཱཀྱཾ ཡེ ཝདནྟི, ཏེ ཡཱིཤེाརནྟིཀམ྄ ཨཱགཏྱ པཔྲཙྪུཿ, ");
INSERT INTO santib_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ཧེ གུརོ, ཀཤྩིནྨནུཛཤྩེཏ྄ ནིཿསནྟཱནཿ སན྄ པྲཱཎཱན྄ ཏྱཛཏི, ཏརྷི ཏསྱ བྷྲཱཏཱ ཏསྱ ཛཱཡཱཾ ཝྱུཧྱ བྷྲཱཏུཿ སནྟཱནམ྄ ཨུཏྤཱདཡིཥྱཏཱིཏི མཱུསཱ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ཀིནྟྭསྨཱཀམཏྲ ཀེ྅པི ཛནཱཿ སཔྟསཧོདརཱ ཨཱསན྄, ཏེཥཱཾ ཛྱེཥྛ ཨེཀཱཾ ཀནྱཱཾ ཝྱཝཧཱཏ྄, ཨཔརཾ པྲཱཎཏྱཱགཀཱལེ སྭཡཾ ནིཿསནྟཱནཿ སན྄ ཏཱཾ སྟྲིཡཾ སྭབྷྲཱཏརི སམརྤིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ཏཏོ དྭིཏཱིཡཱདིསཔྟམཱནྟཱཤྩ ཏཐཻཝ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ཤེཥེ སཱཔཱི ནཱརཱི མམཱར། ");
INSERT INTO santib_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","མྲྀཏཱནཱམ྄ ཨུཏྠཱནསམཡེ ཏེཥཱཾ སཔྟཱནཱཾ མདྷྱེ སཱ ནཱརཱི ཀསྱ བྷཱཪྻྱཱ བྷཝིཥྱཏི? ཡསྨཱཏ྄ སཪྻྭཨེཝ ཏཱཾ ཝྱཝཧན྄། ");
INSERT INTO santib_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིཏ྄, ཡཱུཡཾ དྷརྨྨཔུསྟཀམ྄ ཨཱིཤྭརཱིཡཱཾ ཤཀྟིཉྩ ན ཝིཛྙཱཡ བྷྲཱནྟིམནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ཨུཏྠཱནཔྲཱཔྟཱ ལོཀཱ ན ཝིཝཧནྟི, ན ཙ ཝཱཙཱ དཱིཡནྟེ, ཀིནྟྭཱིཤྭརསྱ སྭརྒསྠདཱུཏཱནཱཾ སདྲྀཤཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ཨཔརཾ མྲྀཏཱནཱམུཏྠཱནམདྷི ཡུཥྨཱན྄ པྲཏཱིཡམཱིཤྭརོཀྟིཿ, ");
INSERT INTO santib_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ཨཧམིབྲཱཧཱིམ ཨཱིཤྭར ཨིསྷཱཀ ཨཱིཤྭརོ ཡཱཀཱུབ ཨཱིཤྭར\" ཨིཏི ཀིཾ ཡུཥྨཱབྷི རྣཱཔཱཋི? ཀིནྟྭཱིཤྭརོ ཛཱིཝཏཱམ྄ ཨཱིཤྭར:, ས མྲྀཏཱནཱམཱིཤྭརོ ནཧི། ");
INSERT INTO santib_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ཨིཏི ཤྲུཏྭཱ སཪྻྭེ ལོཀཱསྟསྱོཔདེཤཱད྄ ཝིསྨཡཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ཨནནྟརཾ སིདཱུཀིནཱམ྄ ནིརུཏྟརཏྭཝཱརྟཱཾ ནིཤམྱ ཕིརཱུཤིན ཨེཀཏྲ མིལིཏཝནྟཿ, ");
INSERT INTO santib_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ཏེཥཱམེཀོ ཝྱཝསྠཱཔཀོ ཡཱིཤུཾ པརཱིཀྵིཏུཾ པཔཙྪ, ");
INSERT INTO santib_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ཧེ གུརོ ཝྱཝསྠཱཤཱསྟྲམདྷྱེ ཀཱཛྙཱ ཤྲེཥྛཱ? ");
INSERT INTO santib_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ཏཏོ ཡཱིཤུརུཝཱཙ, ཏྭཾ སཪྻྭཱནྟཿཀརཎཻཿ སཪྻྭཔྲཱཎཻཿ སཪྻྭཙིཏྟཻཤྩ སཱཀཾ པྲབྷཽ པརམེཤྭརེ པྲཱིཡསྭ, ");
INSERT INTO santib_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ཨེཥཱ པྲཐམམཧཱཛྙཱ། ཏསྱཱཿ སདྲྀཤཱི དྭིཏཱིཡཱཛྙཻཥཱ, ");
INSERT INTO santib_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ཏཝ སམཱིཔཝཱསིནི སྭཱཏྨནཱིཝ པྲེམ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ཨནཡོ རྡྭཡོརཱཛྙཡོཿ ཀྲྀཏྶྣཝྱཝསྠཱཡཱ བྷཝིཥྱདྭཀྟྲྀགྲནྠསྱ ཙ བྷཱརསྟིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ཨནནྟརཾ ཕིརཱུཤིནཱམ྄ ཨེཀཏྲ སྠིཏིཀཱལེ ཡཱིཤུསྟཱན྄ པཔྲཙྪ, ");
INSERT INTO santib_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ཁྲཱིཥྚམདྷི ཡུཥྨཱཀཾ ཀཱིདྲྀགྦོདྷོ ཛཱཡཏེ? ས ཀསྱ སནྟཱནཿ? ཏཏསྟེ པྲཏྱཝདན྄, དཱཡཱུདཿ སནྟཱནཿ། ");
INSERT INTO santib_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ཏདཱ ས ཨུཀྟཝཱན྄, ཏརྷི དཱཡཱུད྄ ཀཐམ྄ ཨཱཏྨཱདྷིཥྛཱནེན ཏཾ པྲབྷུཾ ཝདཏི ? ");
INSERT INTO santib_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ཡཐཱ མམ པྲབྷུམིདཾ ཝཱཀྱམཝདཏ྄ པརམེཤྭརཿ། ཏཝཱརཱིན྄ པཱདཔཱིཋཾ ཏེ ཡཱཝནྣཧི ཀརོམྱཧཾ། ཏཱཝཏ྄ ཀཱལཾ མདཱིཡེ ཏྭཾ དཀྵཔཱརྴྭ ཨུཔཱཝིཤ། ཨཏོ ཡདི དཱཡཱུད྄ ཏཾ པྲབྷུཾ ཝདཏི, རྟིཧ ས ཀཐཾ ཏསྱ སནྟཱནོ བྷཝཏི? ");
INSERT INTO santib_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ཏདཱནཱིཾ ཏེཥཱཾ ཀོཔི ཏདྭཱཀྱསྱ ཀིམཔྱུཏྟརཾ དཱཏུཾ ནཱཤཀྣོཏ྄; ");
INSERT INTO santib_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ཏདྡིནམཱརབྷྱ ཏཾ ཀིམཔི ཝཱཀྱཾ པྲཥྚུཾ ཀསྱཱཔི སཱཧསོ ནཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ཨནནྟརཾ ཡཱིཤུ རྫནནིཝཧཾ ཤིཥྱཱཾཤྩཱཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ མཱུསཱསནེ ཨུཔཝིཤནྟི, ");
INSERT INTO santib_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ཨཏསྟེ ཡུཥྨཱན྄ ཡདྱཏ྄ མནྟུམ྄ ཨཱཛྙཱཔཡནྟི, ཏཏ྄ མནྱདྷྭཾ པཱལཡདྷྭཉྩ, ཀིནྟུ ཏེཥཱཾ ཀརྨྨཱནུརཱུཔཾ ཀརྨྨ ན ཀུརུདྷྭཾ; ཡཏསྟེཥཱཾ ཝཱཀྱམཱཏྲཾ སཱརཾ ཀཱཪྻྱེ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ཏེ དུཪྻྭཧཱན྄ གུརུཏརཱན྄ བྷཱརཱན྄ བདྭྭཱ མནུཥྱཱཎཱཾ སྐནྡྷེཔརི སམརྤཡནྟི, ཀིནྟུ སྭཡམངྒུལྱཻཀཡཱཔི ན ཙཱལཡནྟི། ");
INSERT INTO santib_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ཀེཝལཾ ལོཀདརྴནཱཡ སཪྻྭཀརྨྨཱཎི ཀུཪྻྭནྟི; ཕལཏཿ པཊྚབནྡྷཱན྄ པྲསཱཪྻྱ དྷཱརཡནྟི, སྭཝསྟྲེཥུ ཙ དཱིརྒྷགྲནྠཱིན྄ དྷཱརཡནྟི; ");
INSERT INTO santib_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","བྷོཛནབྷཝན ཨུཙྩསྠཱནཾ, བྷཛནབྷཝནེ པྲདྷཱནམཱསནཾ, ");
INSERT INTO santib_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ཧཊྛེ ནམསྐཱརཾ གུརུརིཏི སམྦོདྷནཉྩཻཏཱནི སཪྻྭཱཎི ཝཱཉྪནྟི། ");
INSERT INTO santib_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ཀིནྟུ ཡཱུཡཾ གུརཝ ཨིཏི སམྦོདྷནཱིཡཱ མཱ བྷཝཏ, ཡཏོ ཡུཥྨཱཀམ྄ ཨེཀཿ ཁྲཱིཥྚཨེཝ གུརུ ");
INSERT INTO santib_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ཪྻཱུཡཾ སཪྻྭེ མིཐོ བྷྲཱཏརཤྩ། པུནཿ པྲྀཐིཝྱཱཾ ཀམཔི པིཏེཏི མཱ སམྦུདྷྱདྷྭཾ, ཡཏོ ཡུཥྨཱཀམེཀཿ སྭརྒསྠཨེཝ པིཏཱ། ");
INSERT INTO santib_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ཡཱུཡཾ ནཱཡཀེཏི སམྦྷཱཥིཏཱ མཱ བྷཝཏ, ཡཏོ ཡུཥྨཱཀམེཀཿ ཁྲཱིཥྚཨེཝ ནཱཡཀཿ། ");
INSERT INTO santib_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ཨཔརཾ ཡུཥྨཱཀཾ མདྷྱེ ཡཿ པུམཱན྄ ཤྲེཥྛཿ ས ཡུཥྨཱན྄ སེཝིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ཡཏོ ཡཿ སྭམུནྣམཏི, ས ནཏཿ ཀརིཥྱཏེ; ཀིནྟུ ཡཿ ཀཤྩིཏ྄ སྭམཝནཏཾ ཀརོཏི, ས ཨུནྣཏཿ ཀརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ཧནྟ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡཾ མནུཛཱནཱཾ སམཀྵཾ སྭརྒདྭཱརཾ རུནྡྷ, ཡཱུཡཾ སྭཡཾ ཏེན ན པྲཝིཤཐ, པྲཝིཝིཀྵཱུནཔི ཝཱརཡཐ། ཝཏ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ ཡཱུཡཾ ཚལཱད྄ དཱིརྒྷཾ པྲཱརྠྱ ཝིདྷཝཱནཱཾ སཪྻྭསྭཾ གྲསཐ, ཡུཥྨཱཀཾ གྷོརཏརདཎྜོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ཧནྟ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡམེཀཾ སྭདྷརྨྨཱཝལམྦིནཾ ཀརྟྟུཾ སཱགརཾ བྷཱུམཎྜལཉྩ པྲདཀྵིཎཱིཀུརུཐ, ");
INSERT INTO santib_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ཀཉྩན པྲཱཔྱ སྭཏོ དྭིགུཎནརཀབྷཱཛནཾ ཏཾ ཀུརུཐ། ");
INSERT INTO santib_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ཝཏ ཨནྡྷཔཐདརྴཀཱཿ སཪྻྭེ, ཡཱུཡཾ ཝདཐ, མནྡིརསྱ ཤཔཐཀརཎཱཏ྄ ཀིམཔི ན དེཡཾ; ཀིནྟུ མནྡིརསྠསུཝརྞསྱ ཤཔཐཀརཎཱད྄ དེཡཾ། ");
INSERT INTO santib_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ཧེ མཱུཌྷཱ ཧེ ཨནྡྷཱཿ སུཝརྞཾ ཏཏྶུཝརྞཔཱཝཀམནྡིརམ྄ ཨེཏཡོརུབྷཡོ རྨདྷྱེ ཀིཾ ཤྲེཡཿ? ");
INSERT INTO santib_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ཨནྱཙྩ ཝདཐ, ཡཛྙཝེདྱཱཿ ཤཔཐཀརཎཱཏ྄ ཀིམཔི ན དེཡཾ, ཀིནྟུ ཏདུཔརིསྠིཏསྱ ནཻཝེདྱསྱ ཤཔཐཀརཎཱད྄ དེཡཾ། ");
INSERT INTO santib_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ཧེ མཱུཌྷཱ ཧེ ཨནྡྷཱཿ, ནཻཝེདྱཾ ཏནྣཻཝེདྱཔཱཝཀཝེདིརེཏཡོརུབྷཡོ རྨདྷྱེ ཀིཾ ཤྲེཡཿ? ");
INSERT INTO santib_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ཨཏཿ ཀེནཙིད྄ ཡཛྙཝེདྱཱཿ ཤཔཐེ ཀྲྀཏེ ཏདུཔརིསྠསྱ སཪྻྭསྱ ཤཔཐཿ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ཀེནཙིཏ྄ མནྡིརསྱ ཤཔཐེ ཀྲྀཏེ མནྡིརཏནྣིཝཱསིནོཿ ཤཔཐཿ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ཀེནཙིཏ྄ སྭརྒསྱ ཤཔཐེ ཀྲྀཏེ ཨཱིཤྭརཱིཡསིཾཧཱསནཏདུཔཪྻྱུཔཝིཥྚཡོཿ ཤཔཐཿ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ཧནྟ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡཾ པོདིནཱཡཱཿ སིཏཙྪཏྲཱཡཱ ཛཱིརཀསྱ ཙ དཤམཱཾཤཱན྄ དཏྠ, ཀིནྟུ ཝྱཝསྠཱཡཱ གུརུཏརཱན྄ ནྱཱཡདཡཱཝིཤྭཱསཱན྄ པརིཏྱཛཐ; ཨིམེ ཡུཥྨཱབྷིརཱཙརཎཱིཡཱ ཨམཱི ཙ ན ལཾགྷནཱིཡཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ཧེ ཨནྡྷཔཐདརྴཀཱ ཡཱུཡཾ མཤཀཱན྄ ཨཔསཱརཡཐ, ཀིནྟུ མཧཱངྒཱན྄ གྲསཐ། ");
INSERT INTO santib_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ཧནྟ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡཾ པཱནཔཱཏྲཱཎཱཾ བྷོཛནཔཱཏྲཱཎཱཉྩ བཧིཿ པརིཥྐུརུཐ; ཀིནྟུ ཏདབྷྱནྟརཾ དུརཱཏྨཏཡཱ ཀལུཥེཎ ཙ པརིཔཱུརྞམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ཧེ ཨནྡྷཱཿ ཕིརཱུཤིལོཀཱ ཨཱདཽ པཱནཔཱཏྲཱཎཱཾ བྷོཛནཔཱཏྲཱཎཱཉྩཱབྷྱནྟརཾ པརིཥྐུརུཏ, ཏེན ཏེཥཱཾ བཧིརཔི པརིཥྐཱརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ཧནྟ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡཾ ཤུཀླཱིཀྲྀཏཤྨཤཱནསྭརཱུཔཱ བྷཝཐ, ཡཐཱ ཤྨཤཱནབྷཝནསྱ བཧིཤྩཱརུ, ཀིནྟྭབྷྱནྟརཾ མྲྀཏལོཀཱནཱཾ ཀཱིཀཤཻཿ སཪྻྭཔྲཀཱརམལེན ཙ པརིཔཱུརྞམ྄; ");
INSERT INTO santib_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ཏཐཻཝ ཡཱུཡམཔི ལོཀཱནཱཾ སམཀྵཾ བཧིརྡྷཱརྨྨིཀཱཿ ཀིནྟྭནྟཿཀརཎེཥུ ཀེཝལཀཱཔཊྱཱདྷརྨྨཱབྷྱཱཾ པརིཔཱུརྞཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ཧཱ ཧཱ ཀཔཊིན ཨུཔཱདྷྱཱཡཱཿ ཕིརཱུཤིནཤྩ, ཡཱུཡཾ བྷཝིཥྱདྭཱདིནཱཾ ཤྨཤཱནགེཧཾ ནིརྨྨཱཐ, སཱདྷཱུནཱཾ ཤྨཤཱནནིཀེཏནཾ ཤོབྷཡཐ ");
INSERT INTO santib_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ཝདཐ ཙ ཡདི ཝཡཾ སྭེཥཱཾ པཱུཪྻྭཔུརུཥཱཎཱཾ ཀཱལ ཨསྠཱསྱཱམ, ཏརྷི བྷཝིཥྱདྭཱདིནཱཾ ཤོཎིཏཔཱཏནེ ཏེཥཱཾ སཧབྷཱགིནོ ནཱབྷཝིཥྱཱམ། ");
INSERT INTO santib_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ཨཏོ ཡཱུཡཾ བྷཝིཥྱདྭཱདིགྷཱཏཀཱནཱཾ སནྟཱནཱ ཨིཏི སྭཡམེཝ སྭེཥཱཾ སཱཀྵྱཾ དཏྠ། ");
INSERT INTO santib_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ཨཏོ ཡཱུཡཾ ནིཛཔཱུཪྻྭཔུརུཥཱཎཱཾ པརིམཱཎཔཱཏྲཾ པརིཔཱུརཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","རེ བྷུཛགཱཿ ཀྲྀཥྞབྷུཛགཝཾཤཱཿ, ཡཱུཡཾ ཀཐཾ ནརཀདཎྜཱད྄ རཀྵིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","པཤྱཏ, ཡུཥྨཱཀམནྟིཀམ྄ ཨཧཾ བྷཝིཥྱདྭཱདིནོ བུདྡྷིམཏ ཨུཔཱདྷྱཱཡཱཾཤྩ པྲེཥཡིཥྱཱམི, ཀིནྟུ ཏེཥཱཾ ཀཏིཔཡཱ ཡུཥྨཱབྷི རྒྷཱནིཥྱནྟེ, ཀྲུཤེ ཙ གྷཱནིཥྱནྟེ, ཀེཙིད྄ བྷཛནབྷཝནེ ཀཥཱབྷིརཱགྷཱནིཥྱནྟེ, ནགརེ ནགརེ ཏཱཌིཥྱནྟེ ཙ; ");
INSERT INTO santib_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ཏེན སཏྤུརུཥསྱ ཧཱབིལོ རཀྟཔཱཏམཱརབྷྱ བེརིཁིཡཿ པུཏྲཾ ཡཾ སིཁརིཡཾ ཡཱུཡཾ མནྡིརཡཛྙཝེདྱོ རྨདྷྱེ ཧཏཝནྟཿ, ཏདཱིཡཤོཎིཏཔཱཏཾ ཡཱཝད྄ ཨསྨིན྄ དེཤེ ཡཱཝཏཱཾ སཱདྷུཔུརུཥཱཎཱཾ ཤོཎིཏཔཱཏོ ྅བྷཝཏ྄ ཏཏ྄ སཪྻྭེཥཱམཱགསཱཾ དཎྜཱ ཡུཥྨཱསུ ཝརྟྟིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ཨཧཾ ཡུཥྨཱནྟ ཏཐྱཾ ཝདཱམི, ཝིདྱམཱནེ྅སྨིན྄ པུརུཥེ སཪྻྭེ ཝརྟྟིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ཧེ ཡིརཱུཤཱལམ྄ ཧེ ཡིརཱུཤཱལམ྄ ནགརི ཏྭཾ བྷཝིཥྱདྭཱདིནོ ཧཏཝཏཱི, ཏཝ སམཱིཔཾ པྲེརིཏཱཾཤྩ པཱཥཱཎཻརཱཧཏཝཏཱི, ཡཐཱ ཀུཀྐུཊཱི ཤཱཝཀཱན྄ པཀྵཱདྷཿ སཾགྲྀཧླཱཏི, ཏཐཱ ཏཝ སནྟཱནཱན྄ སཾགྲཧཱིཏུཾ ཨཧཾ བཧུཝཱརམ྄ ཨཻཙྪཾ; ཀིནྟུ ཏྭཾ ན སམམནྱཐཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","པཤྱཏ ཡཥྨཱཀཾ ཝཱསསྠཱནམ྄ ཨུཙྪིནྣཾ ཏྱཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི, ཡཿ པརམེཤྭརསྱ ནཱམྣཱགཙྪཏི, ས དྷནྱ ཨིཏི ཝཱཎཱིཾ ཡཱཝནྣ ཝདིཥྱཐ, ཏཱཝཏ྄ མཱཾ པུན རྣ དྲཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ཨནནྟརཾ ཡཱིཤུ ཪྻདཱ མནྡིརཱད྄ བཧི རྒཙྪཏི, ཏདཱནཱིཾ ཤིཥྱཱསྟཾ མནྡིརནིརྨྨཱཎཾ དརྴཡིཏུམཱགཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ཏཏོ ཡཱིཤུསྟཱནུཝཱཙ, ཡཱུཡཾ ཀིམེཏཱནི ན པཤྱཐ? ཡུཥྨཱནཧཾ སཏྱཾ ཝདཱམི, ཨེཏནྣིཙཡནསྱ པཱཥཱཎཻཀམཔྱནྱཔཱཥཱཎེाཔརི ན སྠཱསྱཏི སཪྻྭཱཎི བྷཱུམིསཱཏ྄ ཀཱརིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ཨནནྟརཾ ཏསྨིན྄ ཛཻཏུནཔཪྻྭཏོཔརི སམུཔཝིཥྚེ ཤིཥྱཱསྟསྱ སམཱིཔམཱགཏྱ གུཔྟཾ པཔྲཙྪུཿ, ཨེཏཱ གྷཊནཱཿ ཀདཱ བྷཝིཥྱནྟི? བྷཝཏ ཨཱགམནསྱ ཡུགཱནྟསྱ ཙ ཀིཾ ལཀྵྨ? ཏདསྨཱན྄ ཝདཏུ། ");
INSERT INTO santib_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ཏདཱནཱིཾ ཡཱིཤུསྟཱནཝོཙཏ྄, ཨཝདྷདྭྭཾ, ཀོཔི ཡུཥྨཱན྄ ན བྷྲམཡེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","བཧཝོ མམ ནཱམ གྲྀཧླནྟ ཨཱགམིཥྱནྟི, ཁྲཱིཥྚོ྅ཧམེཝེཏི ཝཱཙཾ ཝདནྟོ བཧཱུན྄ བྷྲམཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ཡཱུཡཉྩ སཾགྲཱམསྱ རཎསྱ ཙཱཌམྦརཾ ཤྲོཥྱཐ, ཨཝདྷདྭྭཾ ཏེན ཙཉྩལཱ མཱ བྷཝཏ, ཨེཏཱནྱཝཤྱཾ གྷཊིཥྱནྟེ, ཀིནྟུ ཏདཱ ཡུགཱནྟོ ནཧི། ");
INSERT INTO santib_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ཨཔརཾ དེཤསྱ ཝིཔཀྵོ དེཤོ རཱཛྱསྱ ཝིཔཀྵོ རཱཛྱཾ བྷཝིཥྱཏི, སྠཱནེ སྠཱནེ ཙ དུརྦྷིཀྵཾ མཧཱམཱརཱི བྷཱུཀམྤཤྩ བྷཝིཥྱནྟི, ");
INSERT INTO santib_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ཨེཏཱནི དུཿཁོཔཀྲམཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ཏདཱནཱིཾ ལོཀཱ དུཿཁཾ བྷོཛཡིཏུཾ ཡུཥྨཱན྄ པརཀརེཥུ སམརྤཡིཥྱནྟི ཧནིཥྱནྟི ཙ, ཏཐཱ མམ ནཱམཀཱརཎཱད྄ ཡཱུཡཾ སཪྻྭདེཤཱིཡམནུཛཱནཱཾ སམཱིཔེ གྷྲྀཎཱརྷཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","བཧུཥུ ཝིགྷྣཾ པྲཱཔྟཝཏྶུ པརསྤརམ྄ ཨྲྀृཏཱིཡཱཾ ཀྲྀཏཝཏྶུ ཙ ཨེཀོ྅པརཾ པརཀརེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ཏཐཱ བཧཝོ མྲྀཥཱབྷཝིཥྱདྭཱདིན ཨུཔསྠཱཡ བཧཱུན྄ བྷྲམཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","དུཥྐརྨྨཎཱཾ བཱཧུལྱཱཉྩ བཧཱུནཱཾ པྲེམ ཤཱིཏལཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ ཤེཥཾ ཡཱཝད྄ དྷཻཪྻྱམཱཤྲཡཏེ, སཨེཝ པརིཏྲཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ཨཔརཾ སཪྻྭདེཤཱིཡལོཀཱན྄ པྲཏིམཱཀྵཱི བྷཝིཏུཾ རཱཛསྱ ཤུབྷསམཱཙཱརཿ སཪྻྭཛགཏི པྲཙཱརིཥྱཏེ, ཨེཏཱདྲྀཤི སཏི ཡུགཱནྟ ཨུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ཨཏོ ཡཏ྄ སཪྻྭནཱཤཀྲྀདྒྷྲྀཎཱརྷཾ ཝསྟུ དཱནིཡེལྦྷཝིཥྱདྭདིནཱ པྲོཀྟཾ ཏད྄ ཡདཱ པུཎྱསྠཱནེ སྠཱཔིཏཾ དྲཀྵྱཐ, (ཡཿ པཋཏི, ས བུདྷྱཏཱཾ) ");
INSERT INTO santib_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ཏདཱནཱིཾ ཡེ ཡིཧཱུདཱིཡདེཤེ ཏིཥྛནྟི, ཏེ པཪྻྭཏེཥུ པལཱཡནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ཡཿ ཀཤྩིད྄ གྲྀཧཔྲྀཥྛེ ཏིཥྛཏི, ས གྲྀཧཱཏ྄ ཀིམཔི ཝསྟྭཱནེཏུམ྄ ཨདྷེा ནཱཝརོཧེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ཡཤྩ ཀྵེཏྲེ ཏིཥྛཏི, སོཔི ཝསྟྲམཱནེཏུཾ པརཱཝྲྀཏྱ ན ཡཱཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ཏདཱནཱིཾ གརྦྷིཎཱིསྟནྱཔཱཡཡིཏྲཱིཎཱཾ དུརྒཏི རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ཨཏོ ཡཥྨཱཀཾ པལཱཡནཾ ཤཱིཏཀཱལེ ཝིཤྲཱམཝཱརེ ཝཱ ཡནྣ བྷཝེཏ྄, ཏདརྠཾ པྲཱརྠཡདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ཨཱ ཛགདཱརམྦྷཱད྄ ཨེཏཏྐཱལཔཪྻྱནནྟཾ ཡཱདྲྀཤཿ ཀདཱཔི ནཱབྷཝཏ྄ ན ཙ བྷཝིཥྱཏི ཏཱདྲྀཤོ མཧཱཀླེཤསྟདཱནཱིམ྄ ཨུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ཏསྱ ཀླེཤསྱ སམཡོ ཡདི ཧྶྭོ ན ཀྲིཡེཏ, ཏརྷི ཀསྱཱཔི པྲཱཎིནོ རཀྵཎཾ བྷཝིཏུཾ ན ཤཀྣུཡཱཏ྄, ཀིནྟུ མནོནཱིཏམནུཛཱནཱཾ ཀྲྀཏེ ས ཀཱལོ ཧྶྭཱིཀརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ཨཔརཉྩ པཤྱཏ, ཁྲཱིཥྚོ྅ཏྲ ཝིདྱཏེ, ཝཱ ཏཏྲ ཝིདྱཏེ, ཏདཱནཱིཾ ཡདཱི ཀཤྩིད྄ ཡུཥྨཱན ཨིཏི ཝཱཀྱཾ ཝདཏི, ཏཐཱཔི ཏཏ྄ ན པྲཏཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ཡཏོ བྷཱཀྟཁྲཱིཥྚཱ བྷཱཀྟབྷཝིཥྱདྭཱདིནཤྩ ཨུཔསྠཱཡ ཡཱནི མཧནྟི ལཀྵྨཱཎི ཙིཏྲཀརྨྨཱཎི ཙ པྲཀཱཤཡིཥྱནྟི, ཏཻ ཪྻདི སམྦྷཝེཏ྄ ཏརྷི མནོནཱིཏམཱནཝཱ ཨཔི བྷྲཱམིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","པཤྱཏ, གྷཊནཱཏཿ པཱུཪྻྭཾ ཡུཥྨཱན྄ ཝཱརྟྟཱམ྄ ཨཝཱདིཥམ྄། ");
INSERT INTO santib_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ཨཏཿ པཤྱཏ, ས པྲཱནྟརེ ཝིདྱཏ ཨིཏི ཝཱཀྱེ ཀེནཙིཏ྄ ཀཐིཏེཔི བཧི རྨཱ གཙྪཏ, ཝཱ པཤྱཏ, སོནྟཿཔུརེ ཝིདྱཏེ, ཨེཏདྭཱཀྱ ཨུཀྟེཔི མཱ པྲཏཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ཡཏོ ཡཐཱ ཝིདྱུཏ྄ པཱུཪྻྭདིཤོ ནིརྒཏྱ པཤྩིམདིཤཾ ཡཱཝཏ྄ པྲཀཱཤཏེ, ཏཐཱ མཱནུཥཔུཏྲསྱཱཔྱཱགམནཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ཡཏྲ ཤཝསྟིཥྛཏི, ཏཏྲེཝ གྲྀདྷྲཱ མིལནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ཨཔརཾ ཏསྱ ཀླེཤསམཡསྱཱཝྱཝཧིཏཔརཏྲ སཱུཪྻྱསྱ ཏེཛོ ལོཔྶྱཏེ, ཙནྡྲམཱ ཛྱོསྣཱཾ ན ཀརིཥྱཏི, ནབྷསོ ནཀྵཏྲཱཎི པཏིཥྱནྟི, གགཎཱིཡཱ གྲཧཱཤྩ ཝིཙལིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ཏདཱནཱིམ྄ ཨཱཀཱཤམདྷྱེ མནུཛསུཏསྱ ལཀྵྨ དརྴིཥྱཏེ, ཏཏོ ནིཛཔརཱཀྲམེཎ མཧཱཏེཛསཱ ཙ མེགྷཱརཱུཌྷཾ མནུཛསུཏཾ ནབྷསཱགཙྪནྟཾ ཝིལོཀྱ པྲྀཐིཝྱཱཿ སཪྻྭཝཾཤཱིཡཱ ཝིལཔིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ཏདཱནཱིཾ ས མཧཱཤབྡཱཡམཱནཏཱུཪྻྱཱ ཝཱདཀཱན྄ ནིཛདཱུཏཱན྄ པྲཧེཥྱཏི, ཏེ ཝྱོམྣ ཨེཀསཱིམཱཏོ྅པརསཱིམཱཾ ཡཱཝཏ྄ ཙཏུརྡིཤསྟསྱ མནོནཱིཏཛནཱན྄ ཨཱནཱིཡ མེལཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ཨུཌུམྦརཔཱདཔསྱ དྲྀཥྚཱནྟཾ ཤིཀྵདྷྭཾ; ཡདཱ ཏསྱ ནཝཱིནཱཿ ཤཱཁཱ ཛཱཡནྟེ, པལླཝཱདིཤྩ ནིརྒཙྪཏི, ཏདཱ ནིདཱགྷཀཱལཿ སཝིདྷོ བྷཝཏཱིཏི ཡཱུཡཾ ཛཱནཱིཐ; ");
INSERT INTO santib_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ཏདྭད྄ ཨེཏཱ གྷཊནཱ དྲྀཥྚྭཱ ས སམཡོ དྭཱར ཨུཔཱསྠཱད྄ ཨིཏི ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ཡུཥྨཱནཧཾ ཏཐྱཾ ཝདཱམི, ཨིདཱནཱིནྟནཛནཱནཱཾ གམནཱཏ྄ པཱུཪྻྭམེཝ ཏཱནི སཪྻྭཱཎི གྷཊིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ནབྷོམེདིནྱོ རླུཔྟཡོརཔི མམ ཝཱཀ྄ ཀདཱཔི ན ལོཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ཨཔརཾ མམ ཏཱཏཾ ཝིནཱ མཱནུཥཿ སྭརྒསྠོ དཱུཏོ ཝཱ ཀོཔི ཏདྡིནཾ ཏདྡཎྜཉྩ ན ཛྙཱཔཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ཨཔརཾ ནོཧེ ཝིདྱམཱནེ ཡཱདྲྀཤམབྷཝཏ྄ ཏཱདྲྀཤཾ མནུཛསུཏསྱཱགམནཀཱལེཔི བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ཕལཏོ ཛལཱཔླཱཝནཱཏ྄ པཱུཪྻྭཾ ཡདྡིནཾ ཡཱཝཏ྄ ནོཧཿ པོཏཾ ནཱརོཧཏ྄, ཏཱཝཏྐཱལཾ ཡཐཱ མནུཥྱཱ བྷོཛནེ པཱནེ ཝིཝཧནེ ཝིཝཱཧནེ ཙ པྲཝྲྀཏྟཱ ཨཱསན྄; ");
INSERT INTO santib_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ཨཔརམ྄ ཨཱཔླཱཝིཏོཡམཱགཏྱ ཡཱཝཏ྄ སཀལམནུཛཱན྄ པླཱཝཡིཏྭཱ ནཱནཡཏ྄, ཏཱཝཏ྄ ཏེ ཡཐཱ ན ཝིདཱམཱསུཿ, ཏཐཱ མནུཛསུཏཱགམནེཔི བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ཏདཱ ཀྵེཏྲསྠིཏཡོརྡྭཡོརེཀོ དྷཱརིཥྱཏེ, ཨཔརསྟྱཱཛིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ཏཐཱ པེཥཎྱཱ པིཾཥཏྱོརུབྷཡོ ཪྻོཥིཏོརེཀཱ དྷཱརིཥྱཏེ྅པརཱ ཏྱཱཛིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ཡུཥྨཱཀཾ པྲབྷུཿ ཀསྨིན྄ དཎྜ ཨཱགམིཥྱཏི, ཏད྄ ཡུཥྨཱབྷི རྣཱཝགམྱཏེ, ཏསྨཱཏ྄ ཛཱགྲཏཿ སནྟསྟིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ཀུཏྲ ཡཱམེ སྟེན ཨཱགམིཥྱཏཱིཏི ཙེད྄ གྲྀཧསྠོ ཛྙཱཏུམ྄ ཨཤཀྵྱཏ྄, ཏརྷི ཛཱགརིཏྭཱ ཏཾ སནྡྷིཾ ཀརྟྟིཏུམ྄ ཨཝཱརཡིཥྱཏ྄ ཏད྄ ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ཡུཥྨཱབྷིརཝདྷཱིཡཏཱཾ, ཡཏོ ཡུཥྨཱབྷི ཪྻཏྲ ན བུདྷྱཏེ, ཏཏྲཻཝ དཎྜེ མནུཛསུཏ ཨཱཡཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","པྲབྷུ རྣིཛཔརིཝཱརཱན྄ ཡཐཱཀཱལཾ བྷོཛཡིཏུཾ ཡཾ དཱསམ྄ ཨདྷྱཀྵཱིཀྲྀཏྱ སྠཱཔཡཏི, ཏཱདྲྀཤོ ཝིཤྭཱསྱོ དྷཱིམཱན྄ དཱསཿ ཀཿ? ");
INSERT INTO santib_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","པྲབྷུརཱགཏྱ ཡཾ དཱསཾ ཏཐཱཙརནྟཾ ཝཱིཀྵཏེ, སཨེཝ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ཡུཥྨཱནཧཾ སཏྱཾ ཝདཱམི, ས ཏཾ ནིཛསཪྻྭསྭསྱཱདྷིཔཾ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ཀིནྟུ པྲབྷུརཱགནྟུཾ ཝིལམྦཏ ཨིཏི མནསི ཙིནྟཡིཏྭཱ ཡོ དུཥྚོ དཱསོ ");
INSERT INTO santib_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","྅པརདཱསཱན྄ པྲཧརྟྟུཾ མཏྟཱནཱཾ སངྒེ བྷོཀྟུཾ པཱཏུཉྩ པྲཝརྟྟཏེ, ");
INSERT INTO santib_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ས དཱསོ ཡདཱ ནཱཔེཀྵཏེ, ཡཉྩ དཎྜཾ ན ཛཱནཱཏི, ཏཏྐཱལཨེཝ ཏཏྤྲབྷུརུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ཏདཱ ཏཾ དཎྜཡིཏྭཱ ཡཏྲ སྠཱནེ རོདནཾ དནྟགྷརྵཎཉྩཱསཱཏེ, ཏཏྲ ཀཔཊིབྷིཿ སཱཀཾ ཏདྡཤཱཾ ནིརཱུཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ཡཱ དཤ ཀནྱཱཿ པྲདཱིཔཱན྄ གྲྀཧླཏྱོ ཝརཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ བཧིརིཏཱཿ, ཏཱབྷིསྟདཱ སྭརྒཱིཡརཱཛྱསྱ སཱདྲྀཤྱཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ཏཱསཱཾ ཀནྱཱནཱཾ མདྷྱེ པཉྩ སུདྷིཡཿ པཉྩ དུརྡྷིཡ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ཡཱ དུརྡྷིཡསྟཱཿ པྲདཱིཔཱན྄ སངྒེ གྲྀཧཱིཏྭཱ ཏཻལཾ ན ཛགྲྀཧུཿ, ");
INSERT INTO santib_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ཀིནྟུ སུདྷིཡཿ པྲདཱིཔཱན྄ པཱཏྲེཎ ཏཻལཉྩ ཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ཨནནྟརཾ ཝརེ ཝིལམྦིཏེ ཏཱཿ སཪྻྭཱ ནིདྲཱཝིཥྚཱ ནིདྲཱཾ ཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ཨནནྟརམ྄ ཨརྡྡྷརཱཏྲེ པཤྱཏ ཝར ཨཱགཙྪཏི, ཏཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ བཧིཪྻཱཏེཏི ཛནརཝཱཏ྄ ");
INSERT INTO santib_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ཏཱཿ སཪྻྭཱཿ ཀནྱཱ ཨུཏྠཱཡ པྲདཱིཔཱན྄ ཨཱསཱདཡིཏུཾ ཨཱརབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ཏཏོ དུརྡྷིཡཿ སུདྷིཡ ཨཱུཙུཿ, ཀིཉྩིཏ྄ ཏཻལཾ དཏྟ, པྲདཱིཔཱ ཨསྨཱཀཾ ནིཪྻྭཱཎཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ཀིནྟུ སུདྷིཡཿ པྲཏྱཝདན྄, དཏྟེ ཡུཥྨཱནསྨཱཾཤྩ པྲཏི ཏཻལཾ ནྱཱུནཱིབྷཝེཏ྄, ཏསྨཱད྄ ཝིཀྲེཏྲྀཎཱཾ སམཱིཔཾ གཏྭཱ སྭཱརྠཾ ཏཻལཾ ཀྲཱིཎཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ཏདཱ ཏཱསུ ཀྲེཏུཾ གཏཱསུ ཝར ཨཱཛགཱམ, ཏཏོ ཡཱཿ སཛྫིཏཱ ཨཱསན྄, ཏཱསྟེན སཱཀཾ ཝིཝཱཧཱིཡཾ ཝེཤྨ པྲཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ཨནནྟརཾ དྭཱརེ རུདྡྷེ ཨཔརཱཿ ཀནྱཱ ཨཱགཏྱ ཛགདུཿ, ཧེ པྲབྷོ, ཧེ པྲབྷོ, ཨསྨཱན྄ པྲཏི དྭཱརཾ མོཙཡ། ");
INSERT INTO santib_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ཀིནྟུ ས ཨུཀྟཝཱན྄, ཏཐྱཾ ཝདཱམི, ཡུཥྨཱནཧཾ ན ཝེདྨི། ");
INSERT INTO santib_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ཨཏོ ཛཱགྲཏཿ སནྟསྟིཥྛཏ, མནུཛསུཏཿ ཀསྨིན྄ དིནེ ཀསྨིན྄ དཎྜེ ཝཱགམིཥྱཏི, ཏད྄ ཡུཥྨཱབྷི རྣ ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ཨཔརཾ ས ཨེཏཱདྲྀཤཿ ཀསྱཙིཏ྄ པུཾསསྟུལྱཿ, ཡོ དཱུརདེཤཾ པྲཏི ཡཱཏྲཱཀཱལེ ནིཛདཱསཱན྄ ཨཱཧཱུཡ ཏེཥཱཾ སྭསྭསཱམརྠྱཱནུརཱུཔམ྄ ");
INSERT INTO santib_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ཨེཀསྨིན྄ མུདྲཱཎཱཾ པཉྩ པོཊལིཀཱཿ ཨནྱསྨིཾཤྩ དྭེ པོཊལིཀེ ཨཔརསྨིཾཤྩ པོཊལིཀཻཀཱམ྄ ཨིཏྠཾ པྲཏིཛནཾ སམརྤྱ སྭཡཾ པྲཝཱསཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ཨནནྟརཾ ཡོ དཱསཿ པཉྩ པོཊལིཀཱཿ ལབྡྷཝཱན྄, ས གཏྭཱ ཝཱཎིཛྱཾ ཝིདྷཱཡ ཏཱ དྭིགུཎཱིཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ཡཤྩ དཱསོ དྭེ པོཊལིཀེ ཨལབྷཏ, སོཔི ཏཱ མུདྲཱ དྭིགུཎཱིཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ཀིནྟུ ཡོ དཱས ཨེཀཱཾ པོཊལིཀཱཾ ལབྡྷཝཱན྄, ས གཏྭཱ བྷཱུམིཾ ཁནིཏྭཱ ཏནྨདྷྱེ ནིཛཔྲབྷོསྟཱ མུདྲཱ གོཔཡཱཉྩཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ཏདནནྟརཾ བཧུཏིཐེ ཀཱལེ གཏེ ཏེཥཱཾ དཱསཱནཱཾ པྲབྷུརཱགཏྱ ཏཻརྡཱསཻཿ སམཾ གཎཡཱཉྩཀཱར། ");
INSERT INTO santib_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ཏདཱནཱིཾ ཡཿ པཉྩ པོཊལིཀཱཿ པྲཱཔྟཝཱན྄ ས ཏཱ དྭིགུཎཱིཀྲྀཏམུདྲཱ ཨཱནཱིཡ ཛགཱད; ཧེ པྲབྷོ, བྷཝཏཱ མཡི པཉྩ པོཊལིཀཱཿ སམརྤིཏཱཿ, པཤྱཏུ, ཏཱ མཡཱ དྭིགུཎཱིཀྲྀཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ཏདཱནཱིཾ ཏསྱ པྲབྷུསྟམུཝཱཙ, ཧེ ཨུཏྟམ ཝིཤྭཱསྱ དཱས, ཏྭཾ དྷནྱོསི, སྟོཀེན ཝིཤྭཱསྱོ ཛཱཏཿ, ཏསྨཱཏ྄ ཏྭཱཾ བཧུཝིཏྟཱདྷིཔཾ ཀརོམི, ཏྭཾ སྭཔྲབྷོཿ སུཁསྱ བྷཱགཱི བྷཝ། ");
INSERT INTO santib_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ཏཏོ ཡེན དྭེ པོཊལིཀེ ལབྡྷེ སོཔྱཱགཏྱ ཛགཱད, ཧེ པྲབྷོ, བྷཝཏཱ མཡི དྭེ པོཊལིཀེ སམརྤིཏེ, པཤྱཏུ ཏེ མཡཱ དྭིགུཎཱིཀྲྀཏེ། ");
INSERT INTO santib_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ཏེན ཏསྱ པྲབྷུསྟམཝོཙཏ྄, ཧེ ཨུཏྟམ ཝིཤྭཱསྱ དཱས, ཏྭཾ དྷནྱོསི, སྟོཀེན ཝིཤྭཱསྱོ ཛཱཏཿ, ཏསྨཱཏ྄ ཏྭཱཾ བཧུདྲཝིཎཱདྷིཔཾ ཀརོམི, ཏྭཾ ནིཛཔྲབྷོཿ སུཁསྱ བྷཱགཱི བྷཝ། ");
INSERT INTO santib_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ཨནནྟརཾ ཡ ཨེཀཱཾ པོཊལིཀཱཾ ལབྡྷཝཱན྄, ས ཨེཏྱ ཀཐིཏཝཱན྄, ཧེ པྲབྷོ, ཏྭཱཾ ཀཋིནནརཾ ཛྙཱཏཝཱན྄, ཏྭཡཱ ཡཏྲ ནོཔྟཾ, ཏཏྲཻཝ ཀྲྀཏྱཏེ, ཡཏྲ ཙ ན ཀཱིརྞཾ, ཏཏྲཻཝ སཾགྲྀཧྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ཨཏོཧཾ སཤངྐཿ སན྄ གཏྭཱ ཏཝ མུདྲཱ བྷཱུམདྷྱེ སཾགོཔྱ སྠཱཔིཏཝཱན྄, པཤྱ, ཏཝ ཡཏ྄ ཏདེཝ གྲྀཧཱཎ། ");
INSERT INTO santib_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ཏདཱ ཏསྱ པྲབྷུཿ པྲཏྱཝདཏ྄ རེ དུཥྚཱལས དཱས, ཡཏྲཱཧཾ ན ཝཔཱམི, ཏཏྲ ཚིནདྨི, ཡཏྲ ཙ ན ཀིརཱམི, ཏཏྲེཝ སཾགྲྀཧླཱམཱིཏི ཙེདཛཱནཱསྟརྷི ");
INSERT INTO santib_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ཝཎིཀྵུ མམ ཝིཏྟཱརྤཎཾ ཏཝོཙིཏམཱསཱིཏ྄, ཡེནཱཧམཱགཏྱ ཝྲྀདྭྱཱ སཱཀཾ མཱུལམུདྲཱཿ པྲཱཔྶྱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ཨཏོསྨཱཏ྄ ཏཱཾ པོཊལིཀཱམ྄ ཨཱདཱཡ ཡསྱ དཤ པོཊལིཀཱཿ སནྟི ཏསྨིནྣརྤཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ཡེན ཝརྡྭྱཏེ ཏསྨིནྣཻཝཱརྤིཥྱཏེ, ཏསྱཻཝ ཙ བཱཧུལྱཾ བྷཝིཥྱཏི, ཀིནྟུ ཡེན ན ཝརྡྭྱཏེ, ཏསྱཱནྟིཀེ ཡཏ྄ ཀིཉྩན ཏིཥྛཏི, ཏདཔི པུནརྣེཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ཨཔརཾ ཡཱུཡཾ ཏམཀརྨྨཎྱཾ དཱསཾ ནཱིཏྭཱ ཡཏྲ སྠཱནེ ཀྲནྡནཾ དནྟགྷརྵཎཉྩ ཝིདྱེཏེ, ཏསྨིན྄ བཧིརྦྷཱུཏཏམསི ནིཀྵིཔཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ཡདཱ མནུཛསུཏཿ པཝིཏྲདཱུཏཱན྄ སངྒིནཿ ཀྲྀཏྭཱ ནིཛཔྲབྷཱཝེནཱགཏྱ ནིཛཏེཛོམཡེ སིཾཧཱསནེ ནིཝེཀྵྱཏི, ");
INSERT INTO santib_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ཏདཱ ཏཏྶམྨུཁེ སཪྻྭཛཱཏཱིཡཱ ཛནཱ སཾམེལིཥྱནྟི། ཏཏོ མེཥཔཱལཀོ ཡཐཱ ཚཱགེབྷྱོ྅ཝཱིན྄ པྲྀཐཀ྄ ཀརོཏི ཏཐཱ སོཔྱེཀསྨཱདནྱམ྄ ཨིཏྠཾ ཏཱན྄ པྲྀཐཀ ཀྲྀཏྭཱཝཱིན྄ ");
INSERT INTO santib_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","དཀྵིཎེ ཚཱགཱཾཤྩ ཝཱམེ སྠཱཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ཏཏཿ པརཾ རཱཛཱ དཀྵིཎསྠིཏཱན྄ མཱནཝཱན྄ ཝདིཥྱཏི, ཨཱགཙྪཏ མཏྟཱཏསྱཱནུགྲཧབྷཱཛནཱནི, ཡུཥྨཏྐྲྀཏ ཨཱ ཛགདཱརམྦྷཏ྄ ཡད྄ རཱཛྱམ྄ ཨཱསཱདིཏཾ ཏདདྷིཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ཡཏོ བུབྷུཀྵིཏཱཡ མཧྱཾ བྷོཛྱམ྄ ཨདཏྟ, པིཔཱསིཏཱཡ པེཡམདཏྟ, ཝིདེཤིནཾ མཱཾ སྭསྠཱནམནཡཏ, ");
INSERT INTO santib_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ཝསྟྲཧཱིནཾ མཱཾ ཝསནཾ པཪྻྱདྷཱཔཡཏ, པཱིཌཱིཏཾ མཱཾ དྲཥྚུམཱགཙྪཏ, ཀཱརཱསྠཉྩ མཱཾ ཝཱིཀྵིཏུམ ཨཱགཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ཏདཱ དྷཱརྨྨིཀཱཿ པྲཏིཝདིཥྱནྟི, ཧེ པྲབྷོ, ཀདཱ ཏྭཱཾ ཀྵུདྷིཏཾ ཝཱིཀྵྱ ཝཡམབྷོཛཡཱམ? ཝཱ པིཔཱསིཏཾ ཝཱིཀྵྱ ཨཔཱཡཡཱམ? ");
INSERT INTO santib_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ཀདཱ ཝཱ ཏྭཱཾ ཝིདེཤིནཾ ཝིལོཀྱ སྭསྠཱནམནཡཱམ? ཀདཱ ཝཱ ཏྭཱཾ ནགྣཾ ཝཱིཀྵྱ ཝསནཾ པཪྻྱདྷཱཔཡཱམ? ");
INSERT INTO santib_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ཀདཱ ཝཱ ཏྭཱཾ པཱིཌིཏཾ ཀཱརཱསྠཉྩ ཝཱིཀྵྱ ཏྭདནྟིཀམགཙྪཱམ? ");
INSERT INTO santib_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ཏདཱནཱིཾ རཱཛཱ ཏཱན྄ པྲཏིཝདིཥྱཏི, ཡུཥྨཱནཧཾ སཏྱཾ ཝདཱམི, མམཻཏེཥཱཾ བྷྲཱཏྲྀཎཱཾ མདྷྱེ ཀཉྩནཻཀཾ ཀྵུདྲཏམཾ པྲཏི ཡད྄ ཨཀུརུཏ, ཏནྨཱཾ པྲཏྱཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","པཤྩཱཏ྄ ས ཝཱམསྠིཏཱན྄ ཛནཱན྄ ཝདིཥྱཏི, རེ ཤཱཔགྲསྟཱཿ སཪྻྭེ, ཤཻཏཱནེ ཏསྱ དཱུཏེབྷྱཤྩ ཡོ྅ནནྟཝཧྣིརཱསཱདིཏ ཨཱསྟེ, ཡཱུཡཾ མདནྟིཀཱཏ྄ ཏམགྣིཾ གཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ཡཏོ ཀྵུདྷིཏཱཡ མཧྱམཱཧཱརཾ ནཱདཏྟ, པིཔཱསིཏཱཡ མཧྱཾ པེཡཾ ནཱདཏྟ, ");
INSERT INTO santib_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ཝིདེཤིནཾ མཱཾ སྭསྠཱནཾ ནཱནཡཏ, ཝསནཧཱིནཾ མཱཾ ཝསནཾ ན པཪྻྱདྷཱཔཡཏ, པཱིཌིཏཾ ཀཱརཱསྠཉྩ མཱཾ ཝཱིཀྵིཏུཾ ནཱགཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ཏདཱ ཏེ པྲཏིཝདིཥྱནྟི, ཧེ པྲབྷོ, ཀདཱ ཏྭཱཾ ཀྵུདྷིཏཾ ཝཱ པིཔཱསིཏཾ ཝཱ ཝིདེཤིནཾ ཝཱ ནགྣཾ ཝཱ པཱིཌིཏཾ ཝཱ ཀཱརཱསྠཾ ཝཱིཀྵྱ ཏྭཱཾ ནཱསེཝཱམཧི? ");
INSERT INTO santib_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ཏདཱ ས ཏཱན྄ ཝདིཥྱཏི, ཏཐྱམཧཾ ཡུཥྨཱན྄ བྲཝཱིམི, ཡུཥྨཱབྷིརེཥཱཾ ཀཉྩན ཀྵོདིཥྛཾ པྲཏི ཡནྣཱཀཱརི, ཏནྨཱཾ པྲཏྱེཝ ནཱཀཱརི། ");
INSERT INTO santib_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","པཤྩཱདམྱནནྟཤཱསྟིཾ ཀིནྟུ དྷཱརྨྨིཀཱ ཨནནྟཱཡུཥཾ བྷོཀྟུཾ ཡཱསྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ཡཱིཤུརེཏཱན྄ པྲསྟཱཝཱན྄ སམཱཔྱ ཤིཥྱཱནཱུཙེ, ");
INSERT INTO santib_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ཡུཥྨཱབྷི རྫྙཱཏཾ དིནདྭཡཱཏ྄ པརཾ ནིསྟཱརམཧ ཨུཔསྠཱསྱཏི, ཏཏྲ མནུཛསུཏཿ ཀྲུཤེན ཧནྟུཾ པརཀརེཥུ སམརྤིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ཏཏཿ པརཾ པྲདྷཱནཡཱཛཀཱདྷྱཱཔཀཔྲཱཉྩཿ ཀིཡཕཱནཱམྣོ མཧཱཡཱཛཀསྱཱཊྚཱལིཀཱཡཱཾ མིལིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ཀེནོཔཱཡེན ཡཱིཤུཾ དྷྲྀཏྭཱ ཧནྟུཾ ཤཀྣུཡུརིཏི མནྟྲཡཱཉྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ཀིནྟུ ཏཻརུཀྟཾ མཧཀཱལེ ན དྷརྟྟཝྱཿ, དྷྲྀཏེ པྲཛཱནཱཾ ཀལཧེན བྷཝིཏུཾ ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ཏཏོ བཻཐནིཡཱཔུརེ ཤིམོནཱཁྱསྱ ཀུཥྛིནོ ཝེཤྨནི ཡཱིཤཽ ཏིཥྛཏི ");
INSERT INTO santib_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ཀཱཙན ཡོཥཱ ཤྭེཏོཔལབྷཱཛནེན མཧཱརྒྷྱཾ སུགནྡྷི ཏཻལམཱནཱིཡ བྷོཛནཱཡོཔཝིཤཏསྟསྱ ཤིརོབྷྱཥེཙཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ཀིནྟུ ཏདཱལོཀྱ ཏཙྪིཥྱཻཿ ཀུཔིཏཻརུཀྟཾ, ཀུཏ ཨིཏྠམཔཝྱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ཙེདིདཾ ཝྱཀྲེཥྱཏ, ཏརྷི བྷཱུརིམཱུལྱཾ པྲཱཔྱ དརིདྲེབྷྱོ ཝྱཏཱརིཥྱཏ། ");
INSERT INTO santib_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ཡཱིཤུནཱ ཏདཝགཏྱ ཏེ སམུདིཏཱཿ, ཡོཥཱམེནཱཾ ཀུཏོ དུཿཁིནཱིཾ ཀུརུཐ, སཱ མཱཾ པྲཏི སཱདྷུ ཀརྨྨཱཀཱརྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ཡུཥྨཱཀམཾ སམཱིཔེ དརིདྲཱཿ སཏཏམེཝཱསཏེ, ཀིནྟུ ཡུཥྨཱཀམནྟིཀེཧཾ ནཱསེ སཏཏཾ། ");
INSERT INTO santib_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","སཱ མམ ཀཱཡོཔརི སུགནྡྷིཏཻལཾ སིཀྟྭཱ མམ ཤྨཤཱནདཱནཀརྨྨཱཀཱརྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ཨཏོཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི སཪྻྭསྨིན྄ ཛགཏི ཡཏྲ ཡཏྲཻཥ སུསམཱཙཱརཿ པྲཙཱརིཥྱཏེ, ཏཏྲ ཏཏྲཻཏསྱཱ ནཱཪྻྱཱཿ སྨརཎཱརྠམ྄ ཀརྨྨེདཾ པྲཙཱརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ཏཏོ དྭཱདཤཤིཥྱཱཎཱམ྄ ཨཱིཥྐརིཡོཏཱིཡཡིཧཱུདཱནཱམཀ ཨེཀཿ ཤིཥྱཿ པྲདྷཱནཡཱཛཀཱནཱམནྟིཀཾ གཏྭཱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ཡདི ཡུཥྨཱཀཾ ཀརེཥུ ཡཱིཤུཾ སམརྤཡཱམི, ཏརྷི ཀིཾ དཱསྱཐ? ཏདཱནཱིཾ ཏེ ཏསྨཻ ཏྲིཾཤནྨུདྲཱ དཱཏུཾ སྠིརཱིཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ས ཏདཱརབྷྱ ཏཾ པརཀརེཥུ སམརྤཡིཏུཾ སུཡོགཾ ཙེཥྚིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ཨནནྟརཾ ཀིཎྭཤཱུནྱཔཱུཔཔཪྻྭཎཿ པྲཐམེཧྣི ཤིཥྱཱ ཡཱིཤུམ྄ ཨུཔགཏྱ པཔྲཙྪུཿ བྷཝཏྐྲྀཏེ ཀུཏྲ ཝཡཾ ནིསྟཱརམཧབྷོཛྱམ྄ ཨཱཡོཛཡིཥྱཱམཿ? བྷཝཏཿ ཀེཙྪཱ? ");
INSERT INTO santib_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ཏདཱ ས གདིཏཝཱན྄, མདྷྱེནགརམམུཀཔུཾསཿ སམཱིཔཾ ཝྲཛིཏྭཱ ཝདཏ, གུརུ རྒདིཏཝཱན྄, མཏྐཱལཿ སཝིདྷཿ, སཧ ཤིཥྱཻསྟྭདཱལཡེ ནིསྟཱརམཧབྷོཛྱཾ བྷོཀྵྱེ། ");
INSERT INTO santib_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ཏདཱ ཤིཥྱཱ ཡཱིཤོསྟཱདྲྀཤནིདེཤཱནུརཱུཔཀརྨྨ ཝིདྷཱཡ ཏཏྲ ནིསྟཱརམཧབྷོཛྱམཱསཱདཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ཏཏཿ སནྡྷྱཱཡཱཾ སཏྱཱཾ དྭཱདཤབྷིཿ ཤིཥྱཻཿ སཱཀཾ ས ནྱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ཨཔརཾ བྷུཉྫཱན ཨུཀྟཝཱན྄ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི, ཡུཥྨཱཀམེཀོ མཱཾ པརཀརེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ཏདཱ ཏེ྅ཏཱིཝ དུཿཁིཏཱ ཨེཀཻཀཤོ ཝཀྟུམཱརེབྷིརེ, ཧེ པྲབྷོ, ས ཀིམཧཾ? ");
INSERT INTO santib_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ཏཏཿ ས ཛགཱད, མཡཱ སཱཀཾ ཡོ ཛནོ བྷོཛནཔཱཏྲེ ཀརཾ སཾཀྵིཔཏི, ས ཨེཝ མཱཾ པརཀརེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","མནུཛསུཏམདྷི ཡཱདྲྀཤཾ ལིཁིཏམཱསྟེ, ཏདནུརཱུཔཱ ཏདྒཏི རྦྷཝིཥྱཏི; ཀིནྟུ ཡེན པུཾསཱ ས པརཀརེཥུ སམརྤཡིཥྱཏེ, ཧཱ ཧཱ ཙེཏ྄ ས ནཱཛནིཥྱཏ, ཏདཱ ཏསྱ ཀྵེམམབྷཝིཥྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ཏདཱ ཡིཧཱུདཱནཱམཱ ཡོ ཛནསྟཾ པརཀརེཥུ སམརྤཡིཥྱཏི, ས ཨུཀྟཝཱན྄, ཧེ གུརོ, ས ཀིམཧཾ? ཏཏཿ ས པྲཏྱུཀྟཝཱན྄, ཏྭཡཱ སཏྱཾ གདིཏམ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ཨནནྟརཾ ཏེཥཱམཤནཀཱལེ ཡཱིཤུཿ པཱུཔམཱདཱཡེཤྭརཱིཡགུཎཱནནཱུདྱ བྷཾཀྟྭཱ ཤིཥྱེབྷྱཿ པྲདཱཡ ཛགཱད, མདྭཔུཿསྭརཱུཔམིམཾ གྲྀཧཱིཏྭཱ ཁཱདཏ། ");
INSERT INTO santib_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","པཤྩཱཏ྄ ས ཀཾསཾ གྲྀཧླན྄ ཨཱིཤྭརཱིཡགུཎཱནནཱུདྱ ཏེབྷྱཿ པྲདཱཡ ཀཐིཏཝཱན྄, སཪྻྭཻ ཪྻུཥྨཱབྷིརནེན པཱཏཝྱཾ, ");
INSERT INTO santib_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ཡསྨཱདནེཀེཥཱཾ པཱཔམརྵཎཱཡ པཱཏིཏཾ ཡནྨནྣཱུཏྣནིཡམརཱུཔཤོཎིཏཾ ཏདེཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ཨཔརམཧཾ ནཱུཏྣགོསྟནཱིརསཾ ན པཱསྱཱམི, ཏཱཝཏ྄ གོསྟནཱིཕལརསཾ པུནཿ ཀདཱཔི ན པཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","པཤྩཱཏ྄ ཏེ གཱིཏམེཀཾ སཾགཱིཡ ཛཻཏུནཱཁྱགིརིཾ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ཏདཱནཱིཾ ཡཱིཤུསྟཱནཝོཙཏ྄, ཨསྱཱཾ རཛནྱཱམཧཾ ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ ཝིགྷྣརཱུཔོ བྷཝིཥྱཱམི, ཡཏོ ལིཁིཏམཱསྟེ, \"མེཥཱཎཱཾ རཀྵཀོ ཡསྟཾ པྲཧརིཥྱཱམྱཧཾ ཏཏཿ། མེཥཱཎཱཾ ནིཝཧོ ནཱུནཾ པྲཝིཀཱིརྞོ བྷཝིཥྱཏི\"༎ ");
INSERT INTO santib_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ཀིནྟུ ཤྨཤཱནཱཏ྄ སམུཏྠཱཡ ཡུཥྨཱཀམགྲེ྅ཧཾ གཱལཱིལཾ གམིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","པིཏརསྟཾ པྲོཝཱཙ, བྷཝཱཾཤྩེཏ྄ སཪྻྭེཥཱཾ ཝིགྷྣརཱུཔོ བྷཝཏི, ཏཐཱཔི མམ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ཏཏོ ཡཱིཤུནཱ ས ཨུཀྟཿ, ཏུབྷྱམཧཾ ཏཐྱཾ ཀཐཡཱམི, ཡཱམིནྱཱམསྱཱཾ ཙརཎཱཡུདྷསྱ རཝཱཏ྄ པཱུཪྻྭཾ ཏྭཾ མཱཾ ཏྲི རྣཱངྒཱིཀརིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ཏཏཿ པིཏར ཨུདིཏཝཱན྄, ཡདྱཔི ཏྭཡཱ སམཾ མརྟྟཝྱཾ, ཏཐཱཔི ཀདཱཔི ཏྭཱཾ ན ནཱངྒཱིཀརིཥྱཱམི; ཏཐཻཝ སཪྻྭེ ཤིཥྱཱཤྩོཙུཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ཨནནྟརཾ ཡཱིཤུཿ ཤིཥྱཻཿ སཱཀཾ གེཏྴིམཱནཱིནཱམཀཾ སྠཱནཾ པྲསྠཱཡ ཏེབྷྱཿ ཀཐིཏཝཱན྄, ཨདཿ སྠཱནཾ གཏྭཱ ཡཱཝདཧཾ པྲཱརྠཡིཥྱེ ཏཱཝད྄ ཡཱུཡམཏྲོཔཝིཤཏ། ");
INSERT INTO santib_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","པཤྩཱཏ྄ ས པིཏརཾ སིཝདིཡསུཏཽ ཙ སངྒིནཿ ཀྲྀཏྭཱ གཏཝཱན྄, ཤོཀཱཀུལོ྅ཏཱིཝ ཝྱཐིཏཤྩ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ཏཱནཝཱདཱིཙྩ མྲྀཏིཡཱཏནེཝ མཏྤྲཱཎཱནཱཾ ཡཱཏནཱ ཛཱཡཏེ, ཡཱུཡམཏྲ མཡཱ སཱརྡྡྷཾ ཛཱགྲྀཏ། ");
INSERT INTO santib_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ཏཏཿ ས ཀིཉྩིདྡཱུརཾ གཏྭཱདྷོམུཁཿ པཏན྄ པྲཱརྠཡཱཉྩཀྲེ, ཧེ མཏྤིཏཪྻདི བྷཝིཏུཾ ཤཀྣོཏི, ཏརྷི ཀཾསོ྅ཡཾ མཏྟོ དཱུརཾ ཡཱཏུ; ཀིནྟུ མདིཙྪཱཝཏ྄ ན བྷཝཏུ, ཏྭདིཙྪཱཝད྄ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ཏཏཿ ས ཤིཥྱཱནུཔེཏྱ ཏཱན྄ ནིདྲཏོ ནིརཱིཀྵྱ པིཏརཱཡ ཀཐཡཱམཱས, ཡཱུཡཾ མཡཱ སཱཀཾ དཎྜམེཀམཔི ཛཱགརིཏུཾ ནཱཤནྐུཏ? ");
INSERT INTO santib_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","པརཱིཀྵཱཡཱཾ ན པཏིཏུཾ ཛཱགྲྀཏ པྲཱརྠཡདྷྭཉྩ; ཨཱཏྨཱ སམུདྱཏོསྟི, ཀིནྟུ ཝཔུ རྡུརྦྦལཾ། ");
INSERT INTO santib_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ས དྭིཏཱིཡཝཱརཾ པྲཱརྠཡཱཉྩཀྲེ, ཧེ མཏྟཱཏ, ན པཱིཏེ ཡདི ཀཾསམིདཾ མཏྟོ དཱུརཾ ཡཱཏུཾ ན ཤཀྣོཏི, ཏརྷི ཏྭདིཙྪཱཝད྄ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ས པུནརེཏྱ ཏཱན྄ ནིདྲཏོ དདརྴ, ཡཏསྟེཥཱཾ ནེཏྲཱཎི ནིདྲཡཱ པཱུརྞཱནྱཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","པཤྩཱཏ྄ ས ཏཱན྄ ཝིཧཱཡ ཝྲཛིཏྭཱ ཏྲྀཏཱིཡཝཱརཾ པཱུཪྻྭཝཏ྄ ཀཐཡན྄ པྲཱརྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ཏཏཿ ཤིཥྱཱནུཔཱགཏྱ གདིཏཝཱན྄, སཱམྤྲཏཾ ཤཡཱནཱཿ ཀིཾ ཝིཤྲཱམྱཐ? པཤྱཏ, སམཡ ཨུཔཱསྠཱཏ྄, མནུཛསུཏཿ པཱཔིནཱཾ ཀརེཥུ སམརྤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ཨུཏྟིཥྛཏ, ཝཡཾ ཡཱམཿ, ཡོ མཱཾ པརཀརེཥུ མསརྤཡིཥྱཏི, པཤྱཏ, ས སམཱིཔམཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ཨེཏཏྐཐཱཀཐནཀཱལེ དྭཱདཤཤིཥྱཱཎཱམེཀོ ཡིཧཱུདཱནཱམཀོ མུཁྱཡཱཛཀལོཀཔྲཱཙཱིནཻཿ པྲཧིཏཱན྄ ཨསིདྷཱརིཡཥྚིདྷཱརིཎོ མནུཛཱན྄ གྲྀཧཱིཏྭཱ ཏཏྶམཱིཔམུཔཏསྠཽ། ");
INSERT INTO santib_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ཨསཽ པརཀརེཥྭརྤཡིཏཱ པཱུཪྻྭཾ ཏཱན྄ ཨིཏྠཾ སངྐེཏཡཱམཱས, ཡམཧཾ ཙུམྦིཥྱེ, སོ྅སཽ མནུཛཿ,སཨེཝ ཡུཥྨཱབྷི རྡྷཱཪྻྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ཏདཱ ས སཔདི ཡཱིཤུམུཔཱགཏྱ ཧེ གུརོ, པྲཎམཱམཱིཏྱུཀྟྭཱ ཏཾ ཙུཙུམྦེ། ");
INSERT INTO santib_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ཏདཱ ཡཱིཤུསྟམུཝཱཙ, ཧེ མིཏྲཾ ཀིམརྠམཱགཏོསི? ཏདཱ ཏཻརཱགཏྱ ཡཱིཤུརཱཀྲམྱ དགྷྲེ། ");
INSERT INTO santib_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ཏཏོ ཡཱིཤོཿ སངྒིནཱམེཀཿ ཀརཾ པྲསཱཪྻྱ ཀོཥཱདསིཾ བཧིཥྐྲྀཏྱ མཧཱཡཱཛཀསྱ དཱསམེཀམཱཧཏྱ ཏསྱ ཀརྞཾ ཙིཙྪེད། ");
INSERT INTO santib_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ཏཏོ ཡཱིཤུསྟཾ ཛགཱད, ཁཌྒཾ སྭསྠཱནེे ནིདྷེཧི ཡཏོ ཡེ ཡེ ཛནཱ ཨསིཾ དྷཱརཡནྟི, ཏཨེཝཱསིནཱ ཝིནཤྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ཨཔརཾ པིཏཱ ཡཐཱ མདནྟིཀཾ སྭརྒཱིཡདཱུཏཱནཱཾ དྭཱདཤཝཱཧིནཱིཏོ྅དྷིཀཾ པྲཧིཎུཡཱཏ྄ མཡཱ ཏམུདྡིཤྱེདཱནཱིམེཝ ཏཐཱ པྲཱརྠཡིཏུཾ ན ཤཀྱཏེ, ཏྭཡཱ ཀིམིཏྠཾ ཛྙཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ཏཐཱ སཏཱིཏྠཾ གྷཊིཥྱཏེ དྷརྨྨཔུསྟཀསྱ ཡདིདཾ ཝཱཀྱཾ ཏཏ྄ ཀཐཾ སིདྷྱེཏ྄? ");
INSERT INTO santib_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ཏདཱནཱིཾ ཡཱིཤུ རྫནནིཝཧཾ ཛགཱད, ཡཱུཡཾ ཁཌྒཡཥྚཱིན྄ ཨཱདཱཡ མཱཾ ཀིཾ ཙཽརཾ དྷརྟྟུམཱཡཱཏཱཿ? ཨཧཾ པྲཏྱཧཾ ཡུཥྨཱབྷིཿ སཱཀམུཔཝིཤྱ སམུཔཱདིཤཾ, ཏདཱ མཱཾ ནཱདྷརཏ; ");
INSERT INTO santib_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ཀིནྟུ བྷཝིཥྱདྭཱདིནཱཾ ཝཱཀྱཱནཱཾ སཾསིདྡྷཡེ སཪྻྭམེཏདབྷཱུཏ྄། ཏདཱ སཪྻྭེ ཤིཥྱཱསྟཾ ཝིཧཱཡ པལཱཡནྟ། ");
INSERT INTO santib_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ཨནནྟརཾ ཏེ མནུཛཱ ཡཱིཤུཾ དྷྲྀཏྭཱ ཡཏྲཱདྷྱཱཔཀཔྲཱཉྩཿ པརིཥདཾ ཀུཪྻྭནྟ ཨུཔཱཝིཤན྄ ཏཏྲ ཀིཡཕཱནཱाམཀམཧཱཡཱཛཀསྱཱནྟིཀཾ ནིནྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ཀིནྟུ ཤེཥེ ཀིཾ བྷཝིཥྱཏཱིཏི ཝེཏྟུཾ པིཏརོ དཱུརེ ཏཏྤཤྩཱད྄ ཝྲཛིཏྭཱ མཧཱཡཱཛཀསྱཱཊྚཱལིཀཱཾ པྲཝིཤྱ དཱསཻཿ སཧིཏ ཨུཔཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ཏདཱནཱིཾ པྲདྷཱནཡཱཛཀཔྲཱཙཱིནམནྟྲིཎཿ སཪྻྭེ ཡཱིཤུཾ ཧནྟུཾ མྲྀཥཱསཱཀྵྱམ྄ ཨལིཔྶནྟ, ");
INSERT INTO santib_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ཀིནྟུ ན ལེབྷིརེ། ཨནེཀེཥུ མྲྀཥཱསཱཀྵིཥྭཱགཏེཥྭཔི ཏནྣ པྲཱཔུཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ཤེཥེ དྭཽ མྲྀཥཱསཱཀྵིཎཱཝཱགཏྱ ཛགདཏུཿ, པུམཱནཡམཀཐཡཏ྄, ཨཧམཱིཤྭརམནྡིརཾ བྷཾཀྟྭཱ དིནཏྲཡམདྷྱེ ཏནྣིརྨྨཱཏུཾ ཤཀྣོམི། ");
INSERT INTO santib_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ཏདཱ མཧཱཡཱཛཀ ཨུཏྠཱཡ ཡཱིཤུམ྄ ཨཝཱདཱིཏ྄། ཏྭཾ ཀིམཔི ན པྲཏིཝདསི? ཏྭཱམདྷི ཀིམེཏེ སཱཀྵྱཾ ཝདནྟི? ");
INSERT INTO santib_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ཀིནྟུ ཡཱིཤུ རྨཽནཱིབྷཱུཡ ཏསྱཽ། ཏཏོ མཧཱཡཱཛཀ ཨུཀྟཝཱན྄, ཏྭཱམ྄ ཨམརེཤྭརནཱམྣཱ ཤཔཡཱམི, ཏྭམཱིཤྭརསྱ པུཏྲོ྅བྷིཥིཀྟོ བྷཝསི ནཝེཏི ཝད། ");
INSERT INTO santib_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཏྭཾ སཏྱམུཀྟཝཱན྄; ཨཧཾ ཡུཥྨཱན྄ ཏཐྱཾ ཝདཱམི, ཨིཏཿཔརཾ མནུཛསུཏཾ སཪྻྭཤཀྟིམཏོ དཀྵིཎཔཱརྴྭེ སྠཱཏུཾ གགཎསྠཾ ཛལདྷརཱནཱརུཧྱཱཡཱནྟཾ ཝཱིཀྵདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ཏདཱ མཧཱཡཱཛཀོ ནིཛཝསནཾ ཚིཏྟྭཱ ཛགཱད, ཨེཥ ཨཱིཤྭརཾ ནིནྡིཏཝཱན྄, ཨསྨཱཀམཔརསཱཀྵྱེཎ ཀིཾ པྲཡོཛནཾ? པཤྱཏ, ཡཱུཡམེཝཱསྱཱསྱཱད྄ ཨཱིཤྭརནིནྡཱཾ ཤྲུཏཝནྟཿ, ");
INSERT INTO santib_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ཡུཥྨཱབྷིཿ ཀིཾ ཝིཝིཙྱཏེ? ཏེ པྲཏྱཱུཙུཿ, ཝདྷཱརྷོ྅ཡཾ། ");
INSERT INTO santib_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ཏཏོ ལོཀཻསྟདཱསྱེ ནིཥྛཱིཝིཏཾ ཀེཙིཏ྄ པྲཏལམཱཧཏྱ ཀེཙིཙྩ ཙཔེཊམཱཧཏྱ བབྷཱཥིརེ, ");
INSERT INTO santib_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ཧེ ཁྲཱིཥྚ ཏྭཱཾ ཀཤྩཔེཊམཱཧཏཝཱན྄? ཨིཏི གཎཡིཏྭཱ ཝདཱསྨཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","པིཏརོ བཧིརངྒན ཨུཔཝིཤཏི, ཏདཱནཱིམེཀཱ དཱསཱི ཏམུཔཱགཏྱ བབྷཱཥེ, ཏྭཾ གཱལཱིལཱིཡཡཱིཤོཿ སཧཙརཨེཀཿ། ");
INSERT INTO santib_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ཀིནྟུ ས སཪྻྭེཥཱཾ སམཀྵམ྄ ཨནངྒཱིཀྲྀཏྱཱཝཱདཱིཏ྄, ཏྭཡཱ ཡདུཙྱཏེ, ཏདརྠམཧཾ ན ཝེདྨི། ");
INSERT INTO santib_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ཏདཱ ཏསྨིན྄ བཧིརྡྭཱརཾ གཏེ ྅ནྱཱ དཱསཱི ཏཾ ནིརཱིཀྵྱ ཏཏྲཏྱཛནཱནཝདཏ྄, ཨཡམཔི ནཱསརཏཱིཡཡཱིཤུནཱ སཱརྡྡྷམ྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ཏཏཿ ས ཤཔཐེན པུནརནངྒཱིཀྲྀཏྱ ཀཐིཏཝཱན྄, ཏཾ ནརཾ ན པརིཙིནོམི། ");
INSERT INTO santib_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ཀྵཎཱཏ྄ པརཾ ཏིཥྛནྟོ ཛནཱ ཨེཏྱ པིཏརམ྄ ཨཝདན྄, ཏྭམཝཤྱཾ ཏེཥཱམེཀ ཨིཏི ཏྭདུཙྩཱརཎམེཝ དྱོཏཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ཀིནྟུ སོ྅བྷིཤཔྱ ཀཐིཏཝཱན྄, ཏཾ ཛནཾ ནཱཧཾ པརིཙིནོམི, ཏདཱ སཔདི ཀུཀྐུཊོ རུརཱཝ། ");
INSERT INTO santib_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ཀུཀྐུཊརཝཱཏ྄ པྲཱཀ྄ ཏྭཾ མཱཾ ཏྲིརཔཱཧྣོཥྱསེ, ཡཻཥཱ ཝཱག྄ ཡཱིཤུནཱཝཱདི ཏཱཾ པིཏརཿ སཾསྨྲྀཏྱ བཧིརིཏྭཱ ཁེདཱད྄ བྷྲྀཤཾ ཙཀྲནྡ། ");
INSERT INTO santib_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","པྲབྷཱཏེ ཛཱཏེ པྲདྷཱནཡཱཛཀལོཀཔྲཱཙཱིནཱ ཡཱིཤུཾ ཧནྟུཾ ཏཏྤྲཏིཀཱུལཾ མནྟྲཡིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ཏཾ བདྭྭཱ ནཱིཏྭཱ པནྟཱིཡཔཱིལཱཏཱཁྱཱདྷིཔེ སམརྤཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ཏཏོ ཡཱིཤོཿ པརཀརེཝྺརྤཡིཏཱ ཡིཧཱུདཱསྟཏྤྲཱཎཱདཎྜཱཛྙཱཾ ཝིདིཏྭཱ སནྟཔྟམནཱཿ པྲདྷཱནཡཱཛཀལོཀཔྲཱཙཱིནཱནཱཾ སམཀྵཾ ཏཱསྟྲཱིཾཤནྨུདྲཱཿ པྲཏིདཱཡཱཝཱདཱིཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ཨེཏནྣིརཱགོནརཔྲཱཎཔརཀརཱརྤཎཱཏ྄ ཀལུཥཾ ཀྲྀཏཝཱནཧཾ། ཏདཱ ཏ ཨུདིཏཝནྟཿ, ཏེནཱསྨཱཀཾ ཀིཾ? ཏྭཡཱ ཏད྄ བུདྷྱཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ཏཏོ ཡིཧཱུདཱ མནྡིརམདྷྱེ ཏཱ མུདྲཱ ནིཀྵིཔྱ པྲསྠིཏཝཱན྄ ཨིཏྭཱ ཙ སྭཡམཱཏྨཱནམུདྦབནྡྷ། ");
INSERT INTO santib_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","པཤྩཱཏ྄ པྲདྷཱནཡཱཛཀཱསྟཱ མུདྲཱ ཨཱདཱཡ ཀཐིཏཝནྟཿ, ཨེཏཱ མུདྲཱཿ ཤོཎིཏམཱུལྱཾ ཏསྨཱད྄ བྷཱཎྜཱགཱརེ ན ནིདྷཱཏཝྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ཨནནྟརཾ ཏེ མནྟྲཡིཏྭཱ ཝིདེཤིནཱཾ ཤྨཤཱནསྠཱནཱཡ ཏཱབྷིཿ ཀུལཱལསྱ ཀྵེཏྲམཀྲཱིཎན྄། ");
INSERT INTO santib_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ཨཏོ྅དྱཱཔི ཏཏྶྠཱནཾ རཀྟཀྵེཏྲཾ ཝདནྟི། ");
INSERT INTO santib_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ཨིཏྠཾ སཏི ཨིསྲཱཡེལཱིཡསནྟཱནཻ ཪྻསྱ མཱུལྱཾ ནིརུཔིཏཾ, ཏསྱ ཏྲིཾཤནྨུདྲཱམཱནཾ མཱུལྱཾ ");
INSERT INTO santib_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","མཱཾ པྲཏི པརམེཤྭརསྱཱདེཤཱཏ྄ ཏེབྷྱ ཨཱདཱིཡཏ, ཏེན ཙ ཀུལཱལསྱ ཀྵེཏྲཾ ཀྲཱིཏམིཏི ཡདྭཙནཾ ཡིརིམིཡབྷཝིཥྱདྭཱདིནཱ པྲོཀྟཾ ཏཏ྄ ཏདཱསིདྷྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ཨནནྟརཾ ཡཱིཤཽ ཏདདྷིཔཏེཿ སམྨུཁ ཨུཔཏིཥྛཏི ས ཏཾ པཔྲཙྪ, ཏྭཾ ཀིཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ? ཏདཱ ཡཱིཤུསྟམཝདཏ྄, ཏྭཾ སཏྱམུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ཀིནྟུ པྲདྷཱནཡཱཛཀཔྲཱཙཱིནཻརབྷིཡུཀྟེན ཏེན ཀིམཔི ན པྲཏྱཝཱདི། ");
INSERT INTO santib_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ཏཏཿ པཱིལཱཏེན ས ཨུདིཏཿ, ཨིམེ ཏྭཏྤྲཏིཀཱུལཏཿ ཀཏི ཀཏི སཱཀྵྱཾ དདཏི, ཏཏ྄ ཏྭཾ ན ཤྲྀཎོཥི? ");
INSERT INTO santib_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ཏཐཱཔི ས ཏེཥཱམེཀསྱཱཔི ཝཙས ཨུཏྟརཾ ནོདིཏཝཱན྄; ཏེན སོ྅དྷིཔཏི རྨཧཱཙིཏྲཾ ཝིདཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ཨནྱཙྩ ཏནྨཧཀཱལེ྅དྷིཔཏེརེཏཱདྲྀཤཱི རཱཏིརཱསཱིཏ྄, པྲཛཱ ཡཾ ཀཉྩན བནྡྷིནཾ ཡཱཙནྟེ, ཏམེཝ ས མོཙཡཏཱིཏི། ");
INSERT INTO santib_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ཏདཱནཱིཾ བརབྦཱནཱམཱ ཀཤྩིཏ྄ ཁྱཱཏབནྡྷྱཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ཏཏཿ པཱིལཱཏསྟཏྲ མིལིཏཱན྄ ལོཀཱན྄ ཨཔྲྀཙྪཏ྄, ཨེཥ བརབྦཱ བནྡྷཱི ཁྲཱིཥྚཝིཁྱཱཏོ ཡཱིཤུཤྩཻཏཡོཿ ཀཾ མོཙཡིཥྱཱམི? ཡུཥྨཱཀཾ ཀིམཱིཔྶིཏཾ? ");
INSERT INTO santib_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ཏཻརཱིརྵྱཡཱ ས སམརྤིཏ ཨིཏི ས ཛྙཱཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ཨཔརཾ ཝིཙཱརཱསནོཔཝེཤནཀཱལེ པཱིལཱཏསྱ པཏྣཱི བྷྲྀཏྱཾ པྲཧིཏྱ ཏསྨཻ ཀཐཡཱམཱས, ཏཾ དྷཱརྨྨིཀམནུཛཾ པྲཏི ཏྭཡཱ ཀིམཔི ན ཀརྟྟཝྱཾ; ཡསྨཱཏ྄ ཏཏྐྲྀཏེ྅དྱཱཧཾ སྭཔྣེ པྲབྷཱུཏཀཥྚམལབྷེ། ");
INSERT INTO santib_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ཨནནྟརཾ པྲདྷཱནཡཱཛཀཔྲཱཙཱིནཱ བརབྦཱཾ ཡཱཙིཏྭཱདཱཏུཾ ཡཱིཤུཉྩ ཧནྟུཾ སཀལལོཀཱན྄ པྲཱཝརྟྟཡན྄། ");
INSERT INTO santib_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ཏཏོ྅དྷིཔཏིསྟཱན྄ པྲྀཥྚཝཱན྄, ཨེཏཡོཿ ཀམཧཾ མོཙཡིཥྱཱམི? ཡུཥྨཱཀཾ ཀེཙྪཱ? ཏེ པྲོཙུ རྦརབྦཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ཏདཱ པཱིལཱཏཿ པཔྲཙྪ, ཏརྷི ཡཾ ཁྲཱིཥྚཾ ཝདནྟི, ཏཾ ཡཱིཤུཾ ཀིཾ ཀརིཥྱཱམི? སཪྻྭེ ཀཐཡཱམཱསུཿ, ས ཀྲུཤེན ཝིདྷྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ཏཏོ྅དྷིཔཏིརཝཱདཱིཏ྄, ཀུཏཿ? ཀིཾ ཏེནཱཔརཱདྡྷཾ? ཀིནྟུ ཏེ པུནརུཙཻ རྫགདུཿ, ས ཀྲུཤེན ཝིདྷྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ཏདཱ ནིཛཝཱཀྱམགྲཱཧྱམབྷཱུཏ྄, ཀལཧཤྩཱཔྱབྷཱུཏ྄, པཱིལཱཏ ཨིཏི ཝིལོཀྱ ལོཀཱནཱཾ སམཀྵཾ ཏོཡམཱདཱཡ ཀརཽ པྲཀྵཱལྱཱཝོཙཏ྄, ཨེཏསྱ དྷཱརྨྨིཀམནུཥྱསྱ ཤོཎིཏཔཱཏེ ནིརྡོཥོ྅ཧཾ, ཡུཥྨཱབྷིརེཝ ཏད྄ བུདྷྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ཏདཱ སཪྻྭཱཿ པྲཛཱཿ པྲཏྱཝོཙན྄, ཏསྱ ཤོཎིཏཔཱཏཱཔརཱདྷོ྅སྨཱཀམ྄ ཨསྨཏྶནྟཱནཱནཱཉྩོཔརི བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ཏཏཿ ས ཏེཥཱཾ སམཱིཔེ བརབྦཱཾ མོཙཡཱམཱས ཡཱིཤུནྟུ ཀཥཱབྷིརཱཧཏྱ ཀྲུཤེན ཝེདྷིཏུཾ སམརྤཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ཨནནྟརམ྄ ཨདྷིཔཏེཿ སེནཱ ཨདྷིཔཏེ རྒྲྀཧཾ ཡཱིཤུམཱནཱིཡ ཏསྱ སམཱིཔེ སེནཱསམཱུཧཾ སཾཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ཏཏསྟེ ཏསྱ ཝསནཾ མོཙཡིཏྭཱ ཀྲྀཥྞལོཧིཏཝརྞཝསནཾ པརིདྷཱཔཡཱམཱསུཿ ");
INSERT INTO santib_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ཀཎྚཀཱནཱཾ མུཀུཊཾ ནིརྨྨཱཡ ཏཙྪིརསི དདུཿ, ཏསྱ དཀྵིཎཀརེ ཝེཏྲམེཀཾ དཏྟྭཱ ཏསྱ སམྨུཁེ ཛཱནཱུནི པཱཏཡིཏྭཱ, ཧེ ཡིཧཱུདཱིཡཱནཱཾ རཱཛན྄, ཏུབྷྱཾ ནམ ཨིཏྱུཀྟྭཱ ཏཾ ཏིརཤྩཀྲུཿ, ");
INSERT INTO santib_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ཏཏསྟསྱ གཱཏྲེ ནིཥྛཱིཝཾ དཏྭཱ ཏེན ཝེཏྲེཎ ཤིར ཨཱཛགྷྣུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ཨིཏྠཾ ཏཾ ཏིརསྐྲྀཏྱ ཏད྄ ཝསནཾ མོཙཡིཏྭཱ པུནརྣིཛཝསནཾ པརིདྷཱཔཡཱཉྩཀྲུཿ, ཏཾ ཀྲུཤེན ཝེདྷིཏུཾ ནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","པཤྩཱཏྟེ བཧིརྦྷཱུཡ ཀུརཱིཎཱིཡཾ ཤིམོནྣཱམཀམེཀཾ ཝིལོཀྱ ཀྲུཤཾ ཝོཌྷུཾ ཏམཱདདིརེ། ");
INSERT INTO santib_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ཨནནྟརཾ གུལྒལྟཱམ྄ ཨརྠཱཏ྄ ཤིརསྐཔཱལནཱམཀསྠཱནམུ པསྠཱཡ ཏེ ཡཱིཤཝེ པིཏྟམིཤྲིཏཱམླརསཾ པཱཏུཾ དདུཿ, ");
INSERT INTO santib_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ཀིནྟུ ས ཏམཱསྭཱདྱ ན པཔཽ། ");
INSERT INTO santib_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ཏདཱནཱིཾ ཏེ ཏཾ ཀྲུཤེན སཾཝིདྷྱ ཏསྱ ཝསནཱནི གུཊིཀཱཔཱཏེན ཝིབྷཛྱ ཛགྲྀཧུཿ, ཏསྨཱཏ྄, ཝིབྷཛནྟེ྅དྷརཱིཡཾ མེ ཏེ མནུཥྱཱཿ པརསྤརཾ། མདུཏྟརཱིཡཝསྟྲཱརྠཾ གུཊིཀཱཾ པཱཏཡནྟི ཙ༎ ཡདེཏདྭཙནཾ བྷཝིཥྱདྭཱདིབྷིརུཀྟམཱསཱིཏ྄, ཏདཱ ཏད྄ ཨསིདྷྱཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","པཤྩཱཏ྄ ཏེ ཏཏྲོཔཝིཤྱ ཏདྲཀྵཎཀཪྻྭཎི ནིཡུཀྟཱསྟསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ཨཔརམ྄ ཨེཥ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ ཡཱིཤུརིཏྱཔཝཱདལིཔིཔཏྲཾ ཏཙྪིརས ཨཱུརྡྭྭེ ཡོཛཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ཏཏསྟསྱ ཝཱམེ དཀྵིཎེ ཙ དྭཽ ཙཻརཽ ཏེན སཱཀཾ ཀྲུཤེན ཝིཝིདྷུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ཏདཱ པཱནྠཱ ནིཛཤིརོ ལཱཌཡིཏྭཱ ཏཾ ནིནྡནྟོ ཛགདུཿ, ");
INSERT INTO santib_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ཧེ ཨཱིཤྭརམནྡིརབྷཉྫཀ དིནཏྲཡེ ཏནྣིརྨྨཱཏཿ སྭཾ རཀྵ, ཙེཏྟྭམཱིཤྭརསུཏསྟརྷི ཀྲུཤཱདཝརོཧ། ");
INSERT INTO santib_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","པྲདྷཱནཡཱཛཀཱདྷྱཱཔཀཔྲཱཙཱིནཱཤྩ ཏཐཱ ཏིརསྐྲྀཏྱ ཛགདུཿ, ");
INSERT INTO santib_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","སོ྅ནྱཛནཱནཱཝཏ྄, ཀིནྟུ སྭམཝིཏུཾ ན ཤཀྣོཏི། ཡདཱིསྲཱཡེལོ རཱཛཱ བྷཝེཏ྄, ཏརྷཱིདཱནཱིམེཝ ཀྲུཤཱདཝརོཧཏུ, ཏེན ཏཾ ཝཡཾ པྲཏྱེཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ས ཨཱིཤྭརེ པྲཏྱཱཤཱམཀརོཏ྄, ཡདཱིཤྭརསྟསྨིན྄ སནྟུཥྚསྟརྷཱིདཱནཱིམེཝ ཏམཝེཏ྄, ཡཏཿ ས ཨུཀྟཝཱན྄ ཨཧམཱིཤྭརསུཏཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ཡཽ སྟེནཽ སཱཀཾ ཏེན ཀྲུཤེན ཝིདྡྷཽ ཏཽ ཏདྭདེཝ ཏཾ ནིནིནྡཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ཏདཱ དྭིཏཱིཡཡཱམཱཏ྄ ཏྲྀཏཱིཡཡཱམཾ ཡཱཝཏ྄ སཪྻྭདེཤེ ཏམིརཾ བབྷཱུཝ, ");
INSERT INTO santib_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ཏྲྀཏཱིཡཡཱམེ \"ཨེལཱི ཨེལཱི ལཱམཱ ཤིཝཀྟནཱི\", ཨརྠཱཏ྄ མདཱིཤྭར མདཱིཤྭར ཀུཏོ མཱམཏྱཱཀྵཱིཿ? ཡཱིཤུརུཙྩཻརིཏི ཛགཱད། ");
INSERT INTO santib_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ཏདཱ ཏཏྲ སྠིཏཱཿ ཀེཙིཏ྄ ཏཏ྄ ཤྲུཏྭཱ བབྷཱཥིརེ, ཨཡམ྄ ཨེལིཡམཱཧཱུཡཏི། ");
INSERT INTO santib_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ཏེཥཱཾ མདྷྱཱད྄ ཨེཀཿ ཤཱིགྷྲཾ གཏྭཱ སྤཉྫཾ གྲྀཧཱིཏྭཱ ཏཏྲཱམླརསཾ དཏྟྭཱ ནལེན པཱཏུཾ ཏསྨཻ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ཨིཏརེ྅ཀཐཡན྄ ཏིཥྛཏ, ཏཾ རཀྵིཏུམ྄ ཨེལིཡ ཨཱཡཱཏི ནཝེཏི པཤྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ཡཱིཤུཿ པུནརུཙཻརཱཧཱུཡ པྲཱཎཱན྄ ཛཧཽ། ");
INSERT INTO santib_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ཏཏོ མནྡིརསྱ ཝིཙྪེདཝསནམ྄ ཨཱུརྡྭྭཱདདྷོ ཡཱཝཏ྄ ཚིདྱམཱནཾ དྭིདྷཱབྷཝཏ྄, ");
INSERT INTO santib_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","བྷཱུམིཤྩཀམྤེ བྷཱུདྷརོཝྱདཱིཪྻྱཏ ཙ། ཤྨཤཱནེ མུཀྟེ བྷཱུརིཔུཎྱཝཏཱཾ སུཔྟདེཧཱ ཨུདཏིཥྛན྄, ");
INSERT INTO santib_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ཤྨཤཱནཱད྄ ཝཧིརྦྷཱུཡ ཏདུཏྠཱནཱཏ྄ པརཾ པུཎྱཔུརཾ གཏྭཱ བཧུཛནཱན྄ དརྴཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ཡཱིཤུརཀྵཎཱཡ ནིཡུཀྟཿ ཤཏསེནཱཔཏིསྟཏྶངྒིནཤྩ ཏཱདྲྀཤཱིཾ བྷཱུཀམྤཱདིགྷཊནཱཾ དྲྀཥྚྭཱ བྷཱིཏཱ ཨཝདན྄, ཨེཥ ཨཱིཤྭརཔུཏྲོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ཡཱ བཧུཡོཥིཏོ ཡཱིཤུཾ སེཝམཱནཱ གཱལཱིལསྟཏྤཤྩཱདཱགཏཱསྟཱསཱཾ མདྷྱེ ");
INSERT INTO santib_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","མགྡལཱིནཱི མརིཡམ྄ ཡཱཀཱུབྱོཤྱོ རྨཱཏཱ ཡཱ མརིཡམ྄ སིབདིཡཔུཏྲཡོ རྨཱཏཱ ཙ ཡོཥིཏ ཨེཏཱ དཱུརེ ཏིཥྛནྟྱོ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","སནྡྷྱཱཡཱཾ སཏྱམ྄ ཨརིམཐིཡཱནགརསྱ ཡཱུཥཕྣཱམཱ དྷནཱི མནུཛོ ཡཱིཤོཿ ཤིཥྱཏྭཱཏ྄ ");
INSERT INTO santib_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","པཱིལཱཏསྱ སམཱིཔཾ གཏྭཱ ཡཱིཤོཿ ཀཱཡཾ ཡཡཱཙེ, ཏེན པཱིལཱཏཿ ཀཱཡཾ དཱཏུམ྄ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ཡཱུཥཕ྄ ཏཏྐཱཡཾ ནཱིཏྭཱ ཤུཙིཝསྟྲེཎཱཙྪཱདྱ ");
INSERT INTO santib_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","སྭཱརྠཾ ཤཻལེ ཡཏ྄ ཤྨཤཱནཾ ཙཁཱན, ཏནྨདྷྱེ ཏཏྐཱཡཾ ནིདྷཱཡ ཏསྱ དྭཱརི ཝྲྀཧཏྤཱཥཱཎཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ཀིནྟུ མགྡལཱིནཱི མརིཡམ྄ ཨནྱམརིཡམ྄ ཨེཏེ སྟྲིཡཽ ཏཏྲ ཤྨཤཱནསམྨུཁ ཨུཔཝིཝིཤཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ཏདནནྟརཾ ནིསྟཱརོཏྶཝསྱཱཡོཛནདིནཱཏ྄ པརེ྅ཧནི པྲདྷཱནཡཱཛཀཱཿ ཕིརཱུཤིནཤྩ མིལིཏྭཱ པཱིལཱཏམུཔཱགཏྱཱཀཐཡན྄, ");
INSERT INTO santib_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ཧེ མཧེཙྪ ས པྲཏཱརཀོ ཛཱིཝན ཨཀཐཡཏ྄, དིནཏྲཡཱཏ྄ པརཾ ཤྨཤཱནཱདུཏྠཱསྱཱམི ཏདྭཱཀྱཾ སྨརཱམོ ཝཡཾ; ");
INSERT INTO santib_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ཏསྨཱཏ྄ ཏྲྀཏཱིཡདིནཾ ཡཱཝཏ྄ ཏཏ྄ ཤྨཤཱནཾ རཀྵིཏུམཱདིཤཏུ, ནོཙེཏ྄ ཏཙྪིཥྱཱ ཡཱམིནྱཱམཱགཏྱ ཏཾ ཧྲྀཏྭཱ ལོཀཱན྄ ཝདིཥྱནྟི, ས ཤྨཤཱནཱདུདཏིཥྛཏ྄, ཏཐཱ སཏི པྲཐམབྷྲཱནྟེཿ ཤེཥཱིཡབྷྲཱནྟི རྨཧཏཱི བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ཏདཱ པཱིལཱཏ ཨཝཱདཱིཏ྄, ཡུཥྨཱཀཾ སམཱིཔེ རཀྵིགཎ ཨཱསྟེ, ཡཱུཡཾ གཏྭཱ ཡཐཱ སཱདྷྱཾ རཀྵཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ཏཏསྟེ གཏྭཱ ཏདྡཱུाརཔཱཥཱཎཾ མུདྲཱངྐིཏཾ ཀྲྀཏྭཱ རཀྵིགཎཾ ནིཡོཛྱ ཤྨཤཱནཾ རཀྵཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ཏཏཿ པརཾ ཝིཤྲཱམཝཱརསྱ ཤེཥེ སཔྟཱཧཔྲཐམདིནསྱ པྲབྷོཏེ ཛཱཏེ མགྡལཱིནཱི མརིཡམ྄ ཨནྱམརིཡམ྄ ཙ ཤྨཤཱནཾ དྲཥྚུམཱགཏཱ། ");
INSERT INTO santib_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ཏདཱ མཧཱན྄ བྷཱུཀམྤོ྅བྷཝཏ྄; པརམེཤྭརཱིཡདཱུཏཿ སྭརྒཱདཝརུཧྱ ཤྨཤཱནདྭཱརཱཏ྄ པཱཥཱཎམཔསཱཪྻྱ ཏདུཔཪྻྱུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ཏདྭདནཾ ཝིདྱུདྭཏ྄ ཏེཛོམཡཾ ཝསནཾ ཧིམཤུབྷྲཉྩ། ");
INSERT INTO santib_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ཏདཱནཱིཾ རཀྵིཎསྟདྦྷཡཱཏ྄ ཀམྤིཏཱ མྲྀཏཝད྄ བབྷཱུཝཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ས དཱུཏོ ཡོཥིཏོ ཛགཱད, ཡཱུཡཾ མཱ བྷཻཥྚ, ཀྲུཤཧཏཡཱིཤུཾ མྲྀགཡདྷྭེ ཏདཧཾ ཝེདྨི། ");
INSERT INTO santib_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","སོ྅ཏྲ ནཱསྟི, ཡཐཱཝདཏ྄ ཏཐོཏྠིཏཝཱན྄; ཨེཏཏ྄ པྲབྷོཿ ཤཡནསྠཱནཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ཏཱུརྞཾ གཏྭཱ ཏཙྪིཥྱཱན྄ ཨིཏི ཝདཏ, ས ཤྨཤཱནཱད྄ ཨུདཏིཥྛཏ྄, ཡུཥྨཱཀམགྲེ གཱལཱིལཾ ཡཱསྱཏི ཡཱུཡཾ ཏཏྲ ཏཾ ཝཱིཀྵིཥྱདྷྭེ, པཤྱཏཱཧཾ ཝཱརྟྟཱམིམཱཾ ཡུཥྨཱནཝཱདིཥཾ། ");
INSERT INTO santib_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ཏཏསྟཱ བྷཡཱཏ྄ མཧཱནནྡཱཉྩ ཤྨཤཱནཱཏ྄ ཏཱུརྞཾ བཧིརྦྷཱུཡ ཏཙྪིཥྱཱན྄ ཝཱརྟྟཱཾ ཝཀྟུཾ དྷཱཝིཏཝཏྱཿ། ཀིནྟུ ཤིཥྱཱན྄ ཝཱརྟྟཱཾ ཝཀྟུཾ ཡཱནྟི, ཏདཱ ཡཱིཤུ རྡརྴནཾ དཏྟྭཱ ཏཱ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ཡུཥྨཱཀཾ ཀལྱཱཎཾ བྷཱུཡཱཏ྄, ཏཏསྟཱ ཨཱགཏྱ ཏཏྤཱདཡོཿ པཏིཏྭཱ པྲཎེམུཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ཡཱིཤུསྟཱ ཨཝཱདཱིཏ྄, མཱ བིབྷཱིཏ, ཡཱུཡཾ གཏྭཱ མམ བྷྲཱཏྲྀན྄ གཱལཱིལཾ ཡཱཏུཾ ཝདཏ, ཏཏྲ ཏེ མཱཾ དྲཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","སྟྲིཡོ གཙྪནྟི, ཏདཱ རཀྵིཎཱཾ ཀེཙིཏ྄ པུརཾ གཏྭཱ ཡདྱད྄ གྷཊིཏཾ ཏཏྶཪྻྭཾ པྲདྷཱནཡཱཛཀཱན྄ ཛྙཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ཏེ པྲཱཙཱིནཻཿ སམཾ སཾསདཾ ཀྲྀཏྭཱ མནྟྲཡནྟོ བཧུམུདྲཱཿ སེནཱབྷྱོ དཏྟྭཱཝདན྄, ");
INSERT INTO santib_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ཨསྨཱསུ ནིདྲིཏེཥུ ཏཙྪིཥྱཱ ཡཱམིནྱཱམཱགཏྱ ཏཾ ཧྲྀཏྭཱནཡན྄, ཨིཏི ཡཱུཡཾ པྲཙཱརཡཏ། ");
INSERT INTO santib_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ཡདྱེཏདདྷིཔཏེཿ ཤྲོཏྲགོཙརཱིབྷཝེཏ྄, ཏརྷི ཏཾ བོདྷཡིཏྭཱ ཡུཥྨཱནཝིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ཏཏསྟེ མུདྲཱ གྲྀཧཱིཏྭཱ ཤིཀྵཱནུརཱུཔཾ ཀརྨྨ ཙཀྲུཿ, ཡིཧཱུདཱིཡཱནཱཾ མདྷྱེ ཏསྱཱདྱཱཔི ཀིཾཝདནྟཱི ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ཨེཀཱདཤ ཤིཥྱཱ ཡཱིཤུནིརཱུཔིཏཱགཱལཱིལསྱཱདྲིཾ གཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ཏཏྲ ཏཾ སཾཝཱིཀྵྱ པྲཎེམུཿ, ཀིནྟུ ཀེཙིཏ྄ སནྡིགྡྷཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ཡཱིཤུསྟེཥཱཾ སམཱིཔམཱགཏྱ ཝྱཱཧྲྀཏཝཱན྄, སྭརྒམེདིནྱོཿ སཪྻྭཱདྷིཔཏིཏྭབྷཱརོ མཡྻརྤིཏ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ཨཏོ ཡཱུཡཾ པྲཡཱཡ སཪྻྭདེཤཱིཡཱན྄ ཤིཥྱཱན྄ ཀྲྀཏྭཱ པིཏུཿ པུཏྲསྱ པཝིཏྲསྱཱཏྨནཤྩ ནཱམྣཱ ཏཱནཝགཱཧཡཏ; ཨཧཾ ཡུཥྨཱན྄ ཡདྱདཱདིཤཾ ཏདཔི པཱལཡིཏུཾ ཏཱནུཔཱདིཤཏ། ");
INSERT INTO santib_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","པཤྱཏ, ཛགདནྟཾ ཡཱཝཏ྄ སདཱཧཾ ཡུཥྨཱབྷིཿ སཱཀཾ ཏིཥྛཱམི། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ཨཱིཤྭརཔུཏྲསྱ ཡཱིཤུཁྲཱིཥྚསྱ སུསཾཝཱདཱརམྦྷཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ ལིཔིརིཏྠམཱསྟེ, པཤྱ སྭཀཱིཡདཱུཏནྟུ ཏཝཱགྲེ པྲེཥཡཱམྱཧམ྄། གཏྭཱ ཏྭདཱིཡཔནྠཱནཾ ས ཧི པརིཥྐརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"པརམེཤསྱ པནྠཱནཾ པརིཥྐུརུཏ སཪྻྭཏཿ། ཏསྱ རཱཛཔཐཉྩཻཝ སམཱནཾ ཀུརུཏཱདྷུནཱ། \" ཨིཏྱེཏཏ྄ པྲཱནྟརེ ཝཱཀྱཾ ཝདཏཿ ཀསྱཙིདྲཝཿ༎ ");
INSERT INTO santib_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","སཨེཝ ཡོཧན྄ པྲཱནྟརེ མཛྫིཏཝཱན྄ ཏཐཱ པཱཔམཱརྫནནིམིཏྟཾ མནོཝྱཱཝརྟྟཀམཛྫནསྱ ཀཐཱཉྩ པྲཙཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ཏཏོ ཡིཧཱུདཱདེཤཡིརཱུཤཱལམྣགརནིཝཱསིནཿ སཪྻྭེ ལོཀཱ བཧི རྦྷཱུཏྭཱ ཏསྱ སམཱིཔམཱགཏྱ སྭཱནི སྭཱནི པཱཔཱནྱངྒཱིཀྲྀཏྱ ཡརྡྡནནདྱཱཾ ཏེན མཛྫིཏཱ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ཨསྱ ཡོཧནཿ པརིདྷེཡཱནི ཀྲམེལཀལོམཛཱནི, ཏསྱ ཀཊིབནྡྷནཾ ཙརྨྨཛཱཏམ྄, ཏསྱ བྷཀྵྱཱཎི ཙ ཤཱུཀཀཱིཊཱ ཝནྱམདྷཱུནི ཙཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ས པྲཙཱརཡན྄ ཀཐཡཱཉྩཀྲེ, ཨཧཾ ནམྲཱིབྷཱུཡ ཡསྱ པཱདུཀཱབནྡྷནཾ མོཙཡིཏུམཔི ན ཡོགྱོསྨི, ཏཱདྲྀཤོ མཏྟོ གུརུཏར ཨེཀཿ པུརུཥོ མཏྤཤྩཱདཱགཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ཨཧཾ ཡུཥྨཱན྄ ཛལེ མཛྫིཏཝཱན྄ ཀིནྟུ ས པཝིཏྲ ཨཱཏྨཱནི སཾམཛྫཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ཨཔརཉྩ ཏསྨིནྣེཝ ཀཱལེ གཱལཱིལྤྲདེཤསྱ ནཱསརདྒྲཱམཱད྄ ཡཱིཤུརཱགཏྱ ཡོཧནཱ ཡརྡྡནནདྱཱཾ མཛྫིཏོ྅བྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ས ཛལཱདུཏྠིཏམཱཏྲོ མེགྷདྭཱརཾ མུཀྟཾ ཀཔོཏཝཏ྄ སྭསྱོཔརི ཨཝརོཧནྟམཱཏྨཱནཉྩ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ཏྭཾ མམ པྲིཡཿ པུཏྲསྟྭཡྻེཝ མམམཧཱསནྟོཥ ཨིཡམཱཀཱཤཱིཡཱ ཝཱཎཱི བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ཏསྨིན྄ ཀཱལེ ཨཱཏྨཱ ཏཾ པྲཱནྟརམདྷྱཾ ནིནཱཡ། ");
INSERT INTO santib_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ཨཐ ས ཙཏྭཱརིཾཤདྡིནཱནི ཏསྨིན྄ སྠཱནེ ཝནྱཔཤུབྷིཿ སཧ ཏིཥྛན྄ ཤཻཏཱནཱ པརཱིཀྵིཏཿ; པཤྩཱཏ྄ སྭརྒཱིཡདཱུཏཱསྟཾ སིཥེཝིརེ། ");
INSERT INTO santib_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ཨནནྟརཾ ཡོཧནི བནྡྷནཱལཡེ བདྡྷེ སཏི ཡཱིཤུ རྒཱལཱིལྤྲདེཤམཱགཏྱ ཨཱིཤྭརརཱཛྱསྱ སུསཾཝཱདཾ པྲཙཱརཡན྄ ཀཐཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ཀཱལཿ སམྤཱུརྞ ཨཱིཤྭརརཱཛྱཉྩ སམཱིཔམཱགཏཾ; ཨཏོཧེཏོ ཪྻཱུཡཾ མནཱཾསི ཝྱཱཝརྟྟཡདྷྭཾ སུསཾཝཱདེ ཙ ཝིཤྭཱསིཏ། ");
INSERT INTO santib_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ཏདནནྟརཾ ས གཱལཱིལཱིཡསམུདྲསྱ ཏཱིརེ གཙྪན྄ ཤིམོན྄ ཏསྱ བྷྲཱཏཱ ཨནྡྲིཡནཱམཱ ཙ ཨིམཽ དྭཽ ཛནཽ མཏྶྱདྷཱརིཎཽ སཱགརམདྷྱེ ཛཱལཾ པྲཀྵིཔནྟཽ དྲྀཥྚྭཱ ཏཱཝཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ཡུཝཱཾ མམ པཤྩཱདཱགཙྪཏཾ, ཡུཝཱམཧཾ མནུཥྱདྷཱརིཎཽ ཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ཏཏསྟཽ ཏཏྐྵཎམེཝ ཛཱལཱནི པརིཏྱཛྱ ཏསྱ པཤྩཱཏ྄ ཛགྨཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ཏཏཿ པརཾ ཏཏྶྠཱནཱཏ྄ ཀིཉྩིད྄ དཱུརཾ གཏྭཱ ས སིཝདཱིཔུཏྲཡཱཀཱུབ྄ ཏདྦྷྲཱཏྲྀཡོཧན྄ ཙ ཨིམཽ ནཽཀཱཡཱཾ ཛཱལཱནཱཾ ཛཱིརྞམུདྡྷཱརཡནྟཽ དྲྀཥྚྭཱ ཏཱཝཱཧཱུཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ཏཏསྟཽ ནཽཀཱཡཱཾ ཝེཏནབྷུགྦྷིཿ སཧིཏཾ སྭཔིཏརཾ ཝིཧཱཡ ཏཏྤཤྩཱདཱིཡཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ཏཏཿ པརཾ ཀཕརྣཱཧཱུམྣཱམཀཾ ནགརམུཔསྠཱཡ ས ཝིཤྲཱམདིཝསེ བྷཛནགྲཧཾ པྲཝིཤྱ སམུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ཏསྱོཔདེཤཱལློཀཱ ཨཱཤྩཪྻྱཾ མེནིརེ ཡཏཿ སོདྷྱཱཔཀཱཨིཝ ནོཔདིཤན྄ པྲབྷཱཝཝཱནིཝ པྲོཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ཨཔརཉྩ ཏསྨིན྄ བྷཛནགྲྀཧེ ཨཔཝིཏྲབྷཱུཏེན གྲསྟ ཨེཀོ མཱནུཥ ཨཱསཱིཏ྄། ས ཙཱིཏྴབྡཾ ཀྲྀཏྭཱ ཀཐཡཱཉྩཀེ ");
INSERT INTO santib_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","བྷོ ནཱསརཏཱིཡ ཡཱིཤོ ཏྭམསྨཱན྄ ཏྱཛ, ཏྭཡཱ སཧཱསྨཱཀཾ ཀཿ སམྦནྡྷཿ? ཏྭཾ ཀིམསྨཱན྄ ནཱཤཡིཏུཾ སམཱགཏཿ? ཏྭམཱིཤྭརསྱ པཝིཏྲལོཀ ཨིཏྱཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ཏདཱ ཡཱིཤུསྟཾ ཏརྫཡིཏྭཱ ཛགཱད ཏཱུཥྞཱིཾ བྷཝ ཨིཏོ བཧིརྦྷཝ ཙ། ");
INSERT INTO santib_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ཏཏཿ སོ྅པཝིཏྲབྷཱུཏསྟཾ སམྤཱིཌྱ ཨཏྱུཙཻཤྩཱིཏྐྲྀཏྱ ནིརྫགཱམ། ");
INSERT INTO santib_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ཏེནཻཝ སཪྻྭེ ཙམཏྐྲྀཏྱ པརསྤརཾ ཀཐཡཱཉྩཀྲིརེ, ཨཧོ ཀིམིདཾ? ཀཱིདྲྀཤོ྅ཡཾ ནཝྱ ཨུཔདེཤཿ? ཨནེན པྲབྷཱཝེནཱཔཝིཏྲབྷཱུཏེཥྭཱཛྙཱཔིཏེཥུ ཏེ ཏདཱཛྙཱནུཝརྟྟིནོ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ཏདཱ ཏསྱ ཡཤོ གཱལཱིལཤྩཏུརྡིཀྶྠསཪྻྭདེཤཱན྄ ཝྱཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ཨཔརཉྩ ཏེ བྷཛནགྲྀཧཱད྄ བཧི རྦྷཱུཏྭཱ ཡཱཀཱུབྱོཧནྦྷྱཱཾ སཧ ཤིམོན ཨཱནྡྲིཡསྱ ཙ ནིཝེཤནཾ པྲཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ཏདཱ པིཏརསྱ ཤྭཤྲཱུརྫྭརཔཱིཌིཏཱ ཤཡྻཱཡཱམཱསྟ ཨིཏི ཏེ ཏཾ ཛྷཊིཏི ཝིཛྙཱཔཡཱཉྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ཏཏཿ ས ཨཱགཏྱ ཏསྱཱ ཧསྟཾ དྷྲྀཏྭཱ ཏཱམུདསྠཱཔཡཏ྄; ཏདཻཝ ཏཱཾ ཛྭརོ྅ཏྱཱཀྵཱིཏ྄ ཏཏཿ པརཾ སཱ ཏཱན྄ སིཥེཝེ། ");
INSERT INTO santib_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ཨཐཱསྟཾ གཏེ རཝཽ སནྡྷྱཱཀཱལེ སཏི ལོཀཱསྟཏྶམཱིཔཾ སཪྻྭཱན྄ རོགིཎོ བྷཱུཏདྷྲྀཏཱཾཤྩ སམཱནིནྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","སཪྻྭེ ནཱགརིཀཱ ལོཀཱ དྭཱརི སཾམིལིཏཱཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ཏཏཿ ས ནཱནཱཝིདྷརོགིཎོ བཧཱུན྄ མནུཛཱནརོགིཎཤྩཀཱར ཏཐཱ བཧཱུན྄ བྷཱུཏཱན྄ ཏྱཱཛཡཱཉྩཀཱར ཏཱན྄ བྷཱུཏཱན྄ ཀིམཔི ཝཱཀྱཾ ཝཀྟུཾ ནིཥིཥེདྷ ཙ ཡཏོཧེཏོསྟེ ཏམཛཱནན྄། ");
INSERT INTO santib_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ཨཔརཉྩ སོ྅ཏིཔྲཏྱཱུཥེ ཝསྟུཏསྟུ རཱཏྲིཤེཥེ སམུཏྠཱཡ བཧིརྦྷཱུཡ ནིརྫནཾ སྠཱནཾ གཏྭཱ ཏཏྲ པྲཱརྠཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ཨནནྟརཾ ཤིམོན྄ ཏཏྶངྒིནཤྩ ཏསྱ པཤྩཱད྄ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ཏདུདྡེཤཾ པྲཱཔྱ ཏམཝདན྄ སཪྻྭེ ལོཀཱསྟྭཱཾ མྲྀགཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ཏདཱ སོ྅ཀཐཡཏ྄ ཨཱགཙྪཏ ཝཡཾ སམཱིཔསྠཱནི ནགརཱཎི ཡཱམཿ, ཡཏོ྅ཧཾ ཏཏྲ ཀཐཱཾ པྲཙཱརཡིཏུཾ བཧིརཱགམམ྄། ");
INSERT INTO santib_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ཨཐ ས ཏེཥཱཾ གཱལཱིལྤྲདེཤསྱ སཪྻྭེཥུ བྷཛནགྲྀཧེཥུ ཀཐཱཿ པྲཙཱརཡཱཉྩཀྲེ བྷཱུཏཱནཏྱཱཛཡཉྩ། ");
INSERT INTO santib_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ཨནནྟརམེཀཿ ཀུཥྛཱི སམཱགཏྱ ཏཏྶམྨུཁེ ཛཱནུཔཱཏཾ ཝིནཡཉྩ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄ ཡདི བྷཝཱན྄ ཨིཙྪཏི ཏརྷི མཱཾ པརིཥྐརྟྟུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ཏཏཿ ཀྲྀཔཱལུ ཪྻཱིཤུཿ ཀརཽ པྲསཱཪྻྱ ཏཾ སྤཥྚྭཱ ཀཐཡཱམཱས ");
INSERT INTO santib_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","མམེཙྪཱ ཝིདྱཏེ ཏྭཾ པརིཥྐྲྀཏོ བྷཝ། ཨེཏཏྐཐཱཡཱཿ ཀཐནམཱཏྲཱཏ྄ ས ཀུཥྛཱི རོགཱནྨུཀྟཿ པརིཥྐྲྀཏོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ཏདཱ ས ཏཾ ཝིསྲྀཛན྄ གཱཌྷམཱདིཤྱ ཛགཱད ");
INSERT INTO santib_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","སཱཝདྷཱནོ བྷཝ ཀཐཱམིམཱཾ ཀམཔི མཱ ཝད; སྭཱཏྨཱནཾ ཡཱཛཀཾ དརྴཡ, ལོཀེབྷྱཿ སྭཔརིཥྐྲྀཏེཿ པྲམཱཎདཱནཱཡ མཱུསཱནིརྞཱིཏཾ ཡདྡཱནཾ ཏདུཏྶྲྀཛསྭ ཙ། ");
INSERT INTO santib_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ཀིནྟུ ས གཏྭཱ ཏཏ྄ ཀརྨྨ ཨིཏྠཾ ཝིསྟཱཪྻྱ པྲཙཱརཡིཏུཾ པྲཱརེབྷེ ཏེནཻཝ ཡཱིཤུཿ པུནཿ སཔྲཀཱཤཾ ནགརཾ པྲཝེཥྚུཾ ནཱཤཀྣོཏ྄ ཏཏོཧེཏོརྦཧིཿ ཀཱནནསྠཱནེ ཏསྱཽ; ཏཐཱཔི ཙཏུརྡྡིགྦྷྱོ ལོཀཱསྟསྱ སམཱིཔམཱཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ཏདནནྟརཾ ཡཱིཤཻ ཀཏིཔཡདིནཱནི ཝིལམྦྱ པུནཿ ཀཕརྣཱཧཱུམྣགརཾ པྲཝིཥྚེ ས གྲྀཧ ཨཱསྟ ཨིཏི ཀིཾཝདནྟྱཱ ཏཏྐྵཎཾ ཏཏྶམཱིཔཾ བཧཝོ ལོཀཱ ཨཱགཏྱ སམུཔཏསྠུཿ, ");
INSERT INTO santib_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ཏསྨཱད྄ གྲྀཧམདྷྱེ སཪྻྭེཥཱཾ ཀྲྀཏེ སྠཱནཾ ནཱབྷཝད྄ དྭཱརསྱ ཙཏུརྡིཀྵྭཔི ནཱབྷཝཏ྄, ཏཏྐཱལེ ས ཏཱན྄ པྲཏི ཀཐཱཾ པྲཙཱརཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ཏཏཿ པརཾ ལོཀཱཤྩཏུརྦྷི རྨཱནཝཻརེཀཾ པཀྵཱགྷཱཏིནཾ ཝཱཧཡིཏྭཱ ཏཏྶམཱིཔམ྄ ཨཱནིནྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ཀིནྟུ ཛནཱནཱཾ བཧུཏྭཱཏ྄ ཏཾ ཡཱིཤོཿ སམྨུཁམཱནེཏུཾ ན ཤཀྣུཝནྟོ ཡསྨིན྄ སྠཱནེ ས ཨཱསྟེ ཏདུཔརིགྲྀཧཔྲྀཥྛཾ ཁནིཏྭཱ ཚིདྲཾ ཀྲྀཏྭཱ ཏེན མཱརྒེཎ སཤཡྻཾ པཀྵཱགྷཱཏིནམ྄ ཨཝརོཧཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ཏཏོ ཡཱིཤུསྟེཥཱཾ ཝིཤྭཱསཾ དྲྀཥྚྭཱ ཏཾ པཀྵཱགྷཱཏིནཾ བབྷཱཥེ ཧེ ཝཏྶ ཏཝ པཱཔཱནཱཾ མཱརྫནཾ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ཏདཱ ཀིཡནྟོ྅དྷྱཱཔཀཱསྟཏྲོཔཝིཤནྟོ མནོབྷི ཪྻིཏརྐཡཱཉྩཀྲུཿ, ཨེཥ མནུཥྱ ཨེཏཱདྲྀཤཱིམཱིཤྭརནིནྡཱཾ ཀཐཱཾ ཀུཏཿ ཀཐཡཏི? ");
INSERT INTO santib_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ཨཱིཤྭརཾ ཝིནཱ པཱཔཱནི མཱརྵྚུཾ ཀསྱ སཱམརྠྱམ྄ ཨཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ཨིཏྠཾ ཏེ ཝིཏརྐཡནྟི ཡཱིཤུསྟཏྐྵཎཾ མནསཱ ཏད྄ བུདྭྭཱ ཏཱནཝདད྄ ཡཱུཡམནྟཿཀརཎཻཿ ཀུཏ ཨེཏཱནི ཝིཏརྐཡཐ? ");
INSERT INTO santib_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ཏདནནྟརཾ ཡཱིཤུསྟཏྶྠཱནཱཏ྄ པུནཿ སམུདྲཏཊཾ ཡཡཽ; ལོཀནིཝཧེ ཏཏྶམཱིཔམཱགཏེ ས ཏཱན྄ སམུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ཀིནྟུ པྲྀཐིཝྱཱཾ པཱཔཱནི མཱརྵྚུཾ མནུཥྱཔུཏྲསྱ སཱམརྠྱམསྟི, ཨེཏད྄ ཡུཥྨཱན྄ ཛྙཱཔཡིཏུཾ (ས ཏསྨཻ པཀྵཱགྷཱཏིནེ ཀཐཡཱམཱས) ");
INSERT INTO santib_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ཨུཏྟིཥྛ ཏཝ ཤཡྻཱཾ གྲྀཧཱིཏྭཱ སྭགྲྀཧཾ ཡཱཧི, ཨཧཾ ཏྭཱམིདམ྄ ཨཱཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ཏཏཿ ས ཏཏྐྵཎམ྄ ཨུཏྠཱཡ ཤཡྻཱཾ གྲྀཧཱིཏྭཱ སཪྻྭེཥཱཾ སཱཀྵཱཏ྄ ཛགཱམ; སཪྻྭེ ཝིསྨིཏཱ ཨེཏཱདྲྀཤཾ ཀརྨྨ ཝཡམ྄ ཀདཱཔི ནཱཔཤྱཱམ, ཨིམཱཾ ཀཐཱཾ ཀཐཡིཏྭེཤྭརཾ དྷནྱམབྲུཝན྄། ");
INSERT INTO santib_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ཏདནནྟརཾ ཡཱིཤུསྟཏྶྠཱནཱཏ྄ པུནཿ སམུདྲཏཊཾ ཡཡཽ; ལོཀནིཝཧེ ཏཏྶམཱིཔམཱགཏེ ས ཏཱན྄ སམུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ཨཐ གཙྪན྄ ཀརསཉྩཡགྲྀཧ ཨུཔཝིཥྚམ྄ ཨཱལྥཱིཡཔུཏྲཾ ལེཝིཾ དྲྀཥྚྭཱ ཏམཱཧཱུཡ ཀཐིཏཝཱན྄ མཏྤཤྩཱཏ྄ ཏྭཱམཱམཙྪ ཏཏཿ ས ཨུཏྠཱཡ ཏཏྤཤྩཱད྄ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ཨནནྟརཾ ཡཱིཤཽ ཏསྱ གྲྀཧེ བྷོཀྟུམ྄ ཨུཔཝིཥྚེ བཧཝཿ ཀརམཉྩཱཡིནཿ པཱཔིནཤྩ ཏེན ཏཙྪིཥྱཻཤྩ སཧོཔཝིཝིཤུཿ, ཡཏོ བཧཝསྟཏྤཤྩཱདཱཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ཏདཱ ས ཀརམཉྩཱཡིབྷིཿ པཱཔིབྷིཤྩ སཧ ཁཱདཏི, ཏད྄ དྲྀཥྚྭཱདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ ཏསྱ ཤིཥྱཱནཱུཙུཿ ཀརམཉྩཱཡིབྷིཿ པཱཔིབྷིཤྩ སཧཱཡཾ ཀུཏོ བྷུཾཀྟེ པིཝཏི ཙ? ");
INSERT INTO santib_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ཏདྭཱཀྱཾ ཤྲུཏྭཱ ཡཱིཤུཿ པྲཏྱུཝཱཙ,ཨརོགིལོཀཱནཱཾ ཙིཀིཏྶཀེན པྲཡོཛནཾ ནཱསྟི, ཀིནྟུ རོགིཎཱམེཝ; ཨཧཾ དྷཱརྨྨིཀཱནཱཧྭཱཏུཾ ནཱགཏཿ ཀིནྟུ མནོ ཝྱཱཝརྟྟཡིཏུཾ པཱཔིན ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ཏཏཿ པརཾ ཡོཧནཿ ཕིརཱུཤིནཱཉྩོཔཝཱསཱཙཱརིཤིཥྱཱ ཡཱིཤོཿ སམཱིཔམ྄ ཨཱགཏྱ ཀཐཡཱམཱསུཿ, ཡོཧནཿ ཕིརཱུཤིནཱཉྩ ཤིཥྱཱ ཨུཔཝསནྟི ཀིནྟུ བྷཝཏཿ ཤིཥྱཱ ནོཔཝསནྟི ཀིཾ ཀཱརཎམསྱ? ");
INSERT INTO santib_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ཏདཱ ཡཱིཤུསྟཱན྄ བབྷཱཥེ ཡཱཝཏ྄ ཀཱལཾ སཁིབྷིཿ སཧ ཀནྱཱཡཱ ཝརསྟིཥྛཏི ཏཱཝཏྐཱལཾ ཏེ ཀིམུཔཝསྟུཾ ཤཀྣུཝནྟི? ཡཱཝཏྐཱལཾ ཝརསྟཻཿ སཧ ཏིཥྛཏི ཏཱཝཏྐཱལཾ ཏ ཨུཔཝསྟུཾ ན ཤཀྣུཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ཡསྨིན྄ ཀཱལེ ཏེབྷྱཿ སཀཱཤཱད྄ ཝརོ ནེཥྱཏེ ས ཀཱལ ཨཱགཙྪཏི, ཏསྨིན྄ ཀཱལེ ཏེ ཛནཱ ཨུཔཝཏྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ཀོཔི ཛནཿ པུརཱཏནཝསྟྲེ ནཱུཏནཝསྟྲཾ ན སཱིཝྱཏི, ཡཏོ ནཱུཏནཝསྟྲེཎ སཧ སེཝནེ ཀྲྀཏེ ཛཱིརྞཾ ཝསྟྲཾ ཚིདྱཏེ ཏསྨཱཏ྄ པུན རྨཧཏ྄ ཚིདྲཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ཀོཔི ཛནཿ པུརཱཏནཀུཏཱུཥུ ནཱུཏནཾ དྲཱཀྵཱརསཾ ན སྠཱཔཡཏི, ཡཏོ ནཱུཏནདྲཱཀྵཱརསསྱ ཏེཛསཱ ཏཱཿ ཀུཏྭོ ཝིདཱིཪྻྱནྟེ ཏཏོ དྲཱཀྵཱརསཤྩ པཏཏི ཀུཏྭཤྩ ནཤྱནྟི, ཨཏཨེཝ ནཱུཏནདྲཱཀྵཱརསོ ནཱུཏནཀུཏཱུཥུ སྠཱཔནཱིཡཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ཏདནནྟརཾ ཡཱིཤུ ཪྻདཱ ཝིཤྲཱམཝཱརེ ཤསྱཀྵེཏྲེཎ གཙྪཏི ཏདཱ ཏསྱ ཤིཥྱཱ གཙྪནྟཿ ཤསྱམཉྫརཱིཤྪེཏྟུཾ པྲཝྲྀཏྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ཨཏཿ ཕིརཱུཤིནོ ཡཱིཤཝེ ཀཐཡཱམཱསུཿ པཤྱཏུ ཝིཤྲཱམཝཱསརེ ཡཏ྄ ཀརྨྨ ན ཀརྟྟཝྱཾ ཏད྄ ཨིམེ ཀུཏཿ ཀུཪྻྭནྟི? ");
INSERT INTO santib_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ཏདཱ ས ཏེབྷྱོ྅ཀཐཡཏ྄ དཱཡཱུད྄ ཏཏྶཾངྒིནཤྩ བྷཀྵྱཱབྷཱཝཱཏ྄ ཀྵུདྷིཏཱཿ སནྟོ ཡཏ྄ ཀརྨྨ ཀྲྀཏཝནྟསྟཏ྄ ཀིཾ ཡུཥྨཱབྷི རྣ པཋིཏམ྄? ");
INSERT INTO santib_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ཨབིཡཱཐརྣཱམཀེ མཧཱཡཱཛཀཏཱཾ ཀུཪྻྭཏི ས ཀཐམཱིཤྭརསྱཱཝཱསཾ པྲཝིཤྱ ཡེ དརྴནཱིཡཔཱུཔཱ ཡཱཛཀཱན྄ ཝིནཱནྱསྱ ཀསྱཱཔི ན བྷཀྵྱཱསྟཱནེཝ བུབྷུཛེ སངྒིལོཀེབྷྱོ྅པི དདཽ། ");
INSERT INTO santib_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","སོ྅པརམཔི ཛགཱད, ཝིཤྲཱམཝཱརོ མནུཥྱཱརྠམེཝ ནིརཱུཔིཏོ྅སྟི ཀིནྟུ མནུཥྱོ ཝིཤྲཱམཝཱརཱརྠཾ ནཻཝ། ");
INSERT INTO santib_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","མནུཥྱཔུཏྲོ ཝིཤྲཱམཝཱརསྱཱཔི པྲབྷུརཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ཨནནྟརཾ ཡཱིཤུཿ པུན རྦྷཛནགྲྀཧཾ པྲཝིཥྚསྟསྨིན྄ སྠཱནེ ཤུཥྐཧསྟ ཨེཀོ མཱནཝ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ས ཝིཤྲཱམཝཱརེ ཏམརོགིཎཾ ཀརིཥྱཏི ནཝེཏྱཏྲ བཧཝསྟམ྄ ཨཔཝདིཏུཾ ཚིདྲམཔེཀྵིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ཏདཱ ས ཏཾ ཤུཥྐཧསྟཾ མནུཥྱཾ ཛགཱད མདྷྱསྠཱནེ ཏྭམུཏྟིཥྛ། ");
INSERT INTO santib_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ཏཏཿ པརཾ ས ཏཱན྄ པཔྲཙྪ ཝིཤྲཱམཝཱརེ ཧིཏམཧིཏཾ ཏཐཱ ཧི པྲཱཎརཀྵཱ ཝཱ པྲཱཎནཱཤ ཨེཥཱཾ མདྷྱེ ཀིཾ ཀརཎཱིཡཾ ? ཀིནྟུ ཏེ ནིཿཤབྡཱསྟསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ཏདཱ ས ཏེཥཱམནྟཿཀརཎཱནཱཾ ཀཱཋིནྱཱདྡྷེཏོ རྡུཿཁིཏཿ ཀྲོདྷཱཏ྄ ཙརྟུिདཤོ དྲྀཥྚཝཱན྄ ཏཾ མཱནུཥཾ གདིཏཝཱན྄ ཏཾ ཧསྟཾ ཝིསྟཱརཡ, ཏཏསྟེན ཧསྟེ ཝིསྟྲྀཏེ ཏདྡྷསྟོ྅ནྱཧསྟཝད྄ ཨརོགོ ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ཨཐ ཕིརཱུཤིནཿ པྲསྠཱཡ ཏཾ ནཱཤཡིཏུཾ ཧེརོདཱིཡཻཿ སཧ མནྟྲཡིཏུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ཨཏཨེཝ ཡཱིཤུསྟཏྶྠཱནཾ པརིཏྱཛྱ ཤིཥྱཻཿ སཧ པུནཿ སཱགརསམཱིཔཾ གཏཿ; ");
INSERT INTO santib_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ཏཏོ གཱལཱིལྱིཧཱུདཱ-ཡིརཱུཤཱལམ྄-ཨིདོམ྄-ཡརྡནྣདཱིཔཱརསྠཱནེབྷྱོ ལོཀསམཱུཧསྟསྱ པཤྩཱད྄ གཏཿ; ཏདནྱཿ སོརསཱིདནོཿ སམཱིཔཝཱསིལོཀསམཱུཧཤྩ ཏསྱ མཧཱཀརྨྨཎཱཾ ཝཱརྟྟཾ ཤྲུཏྭཱ ཏསྱ སནྣིདྷིམཱགཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ཏདཱ ལོཀསམཱུཧཤྩེཏ྄ ཏསྱོཔརི པཏཏི ཨིཏྱཱཤངྐྱ ས ནཱཝམེཀཱཾ ནིཀཊེ སྠཱཔཡིཏུཾ ཤིཥྱཱནཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ཡཏོ྅ནེཀམནུཥྱཱཎཱམཱརོགྱཀརཎཱད྄ ཝྱཱདྷིགྲསྟཱཿ སཪྻྭེ ཏཾ སྤྲཥྚུཾ པརསྤརཾ བལེན ཡཏྣཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ཨཔརཉྩ ཨཔཝིཏྲབྷཱུཏཱསྟཾ དྲྀཥྚྭཱ ཏཙྩརཎཡོཿ པཏིཏྭཱ པྲོཙཻཿ པྲོཙུཿ, ཏྭམཱིཤྭརསྱ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ཀིནྟུ ས ཏཱན྄ དྲྀཌྷམ྄ ཨཱཛྙཱཔྱ སྭཾ པརིཙཱཡིཏུཾ ནིཥིདྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ཨནནྟརཾ ས པཪྻྭཏམཱརུཧྱ ཡཾ ཡཾ པྲཏིཙྪཱ ཏཾ ཏམཱཧཱུཏཝཱན྄ ཏཏསྟེ ཏཏྶམཱིཔམཱགཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ཏདཱ ས དྭཱདཤཛནཱན྄ སྭེན སཧ སྠཱཏུཾ སུསཾཝཱདཔྲཙཱརཱཡ པྲེརིཏཱ བྷཝིཏུཾ ");
INSERT INTO santib_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","སཪྻྭཔྲཀཱརཝྱཱདྷཱིནཱཾ ཤམནཀརཎཱཡ པྲབྷཱཝཾ པྲཱཔྟུཾ བྷཱུཏཱན྄ ཏྱཱཛཡིཏུཉྩ ནིཡུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ཏེཥཱཾ ནཱམཱནཱིམཱནི, ཤིམོན྄ སིཝདིཔུཏྲོ ");
INSERT INTO santib_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ཡཱཀཱུབ྄ ཏསྱ བྷྲཱཏཱ ཡོཧན྄ ཙ ཨཱནྡྲིཡཿ ཕིལིཔོ བརྠལམཡཿ, ");
INSERT INTO santib_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","མཐཱི ཐོམཱ ཙ ཨཱལྥཱིཡཔུཏྲོ ཡཱཀཱུབ྄ ཐདྡཱིཡཿ ཀིནཱནཱིཡཿ ཤིམོན྄ ཡསྟཾ པརཧསྟེཥྭརྤཡིཥྱཏི ས ཨཱིཥྐརིཡོཏཱིཡཡིཧཱུདཱཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ས ཤིམོནེ པིཏར ཨིཏྱུཔནཱམ དདཽ ཡཱཀཱུབྱོཧནྦྷྱཱཾ ཙ བིནེརིགིཤ྄ ཨརྠཏོ མེགྷནཱདཔུཏྲཱཝིཏྱུཔནཱམ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ཨནནྟརཾ ཏེ ནིཝེཤནཾ གཏཱཿ, ཀིནྟུ ཏཏྲཱཔི པུནརྨཧཱན྄ ཛནསམཱགམོ ྅བྷཝཏ྄ ཏསྨཱཏྟེ བྷོཀྟུམཔྱཝཀཱཤཾ ན པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ཏཏསྟསྱ སུཧྲྀལློཀཱ ཨིམཱཾ ཝཱརྟྟཱཾ པྲཱཔྱ ས ཧཏཛྙཱནོབྷཱུད྄ ཨིཏི ཀཐཱཾ ཀཐཡིཏྭཱ ཏཾ དྷྲྀཏྭཱནེཏུཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ཨཔརཉྩ ཡིརཱུཤཱལམ ཨཱགཏཱ ཡེ ཡེ྅དྷྱཱཔཀཱསྟེ ཛགདུརཡཾ པུརུཥོ བྷཱུཏཔཏྱཱབིཥྚསྟེན བྷཱུཏཔཏིནཱ བྷཱུཏཱན྄ ཏྱཱཛཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ཏཏསྟཱནཱཧཱུཡ ཡཱིཤུ རྡྲྀཥྚཱནྟཻཿ ཀཐཱཾ ཀཐིཏཝཱན྄ ཤཻཏཱན྄ ཀཐཾ ཤཻཏཱནཾ ཏྱཱཛཡིཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ཀིཉྩན རཱཛྱཾ ཡདི སྭཝིརོདྷེན པྲྀཐག྄ བྷཝཏི ཏརྷི ཏད྄ རཱཛྱཾ སྠིརཾ སྠཱཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ཏཐཱ ཀསྱཱཔི པརིཝཱརོ ཡདི པརསྤརཾ ཝིརོདྷཱི བྷཝཏི ཏརྷི སོཔི པརིཝཱརཿ སྠིརཾ སྠཱཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ཏདྭཏ྄ ཤཻཏཱན྄ ཡདི སྭཝིཔཀྵཏཡཱ ཨུཏྟིཥྛན྄ བྷིནྣོ བྷཝཏི ཏརྷི སོཔི སྠིརཾ སྠཱཏུཾ ན ཤཀྣོཏི ཀིནྟཱུཙྪིནྣོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ཨཔརཉྩ པྲབལཾ ཛནཾ པྲཐམཾ ན བདྡྷཱ ཀོཔི ཏསྱ གྲྀཧཾ པྲཝིཤྱ དྲཝྱཱཎི ལུཎྛཡིཏུཾ ན ཤཀྣོཏི, ཏཾ བདྭྭཻཝ ཏསྱ གྲྀཧསྱ དྲཝྱཱཎི ལུཎྛཡིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ཨཏོཧེཏོ ཪྻུཥྨབྷྱམཧཾ སཏྱཾ ཀཐཡཱམི མནུཥྱཱཎཱཾ སནྟཱནཱ ཡཱནི ཡཱནི པཱཔཱནཱིཤྭརནིནྡཱཉྩ ཀུཪྻྭནྟི ཏེཥཱཾ ཏཏྶཪྻྭེཥཱམཔརཱདྷཱནཱཾ ཀྵམཱ བྷཝིཏུཾ ཤཀྣོཏི, ");
INSERT INTO santib_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ པཝིཏྲམཱཏྨཱནཾ ནིནྡཏི ཏསྱཱཔརཱདྷསྱ ཀྵམཱ ཀདཱཔི ན བྷཝིཥྱཏི སོནནྟདཎྜསྱཱརྷོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ཏསྱཱཔཝིཏྲབྷཱུཏོ྅སྟི ཏེཥཱམེཏཏྐཐཱཧེཏོཿ ས ཨིཏྠཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ཨཐ ཏསྱ མཱཏཱ བྷྲཱཏྲྀགཎཤྩཱགཏྱ བཧིསྟིཥྛནཏོ ལོཀཱན྄ པྲེཥྱ ཏམཱཧཱུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ཏཏསྟཏྶནྣིདྷཽ སམུཔཝིཥྚཱ ལོཀཱསྟཾ བབྷཱཥིརེ པཤྱ བཧིསྟཝ མཱཏཱ བྷྲཱཏརཤྩ ཏྭཱམ྄ ཨནྭིཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ཏདཱ ས ཏཱན྄ པྲཏྱུཝཱཙ མམ མཱཏཱ ཀཱ བྷྲཱཏརོ ཝཱ ཀེ? ཏཏཿ པརཾ ས སྭམཱིཔོཔཝིཥྚཱན྄ ཤིཥྱཱན྄ པྲཏི ཨཝལོཀནཾ ཀྲྀཏྭཱ ཀཐཡཱམཱས ");
INSERT INTO santib_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","པཤྱཏཻཏེ མམ མཱཏཱ བྷྲཱཏརཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ཡཿ ཀཤྩིད྄ ཨཱིཤྭརསྱེཥྚཱཾ ཀྲིཡཱཾ ཀརོཏི ས ཨེཝ མམ བྷྲཱཏཱ བྷགིནཱི མཱཏཱ ཙ། ");
INSERT INTO santib_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ཨནནྟརཾ ས སམུདྲཏཊེ པུནརུཔདེཥྚུཾ པྲཱརེབྷེ, ཏཏསྟཏྲ བཧུཛནཱནཱཾ སམཱགམཱཏ྄ ས སཱགརོཔརི ནཽཀཱམཱརུཧྱ སམུཔཝིཥྚཿ; སཪྻྭེ ལོཀཱཿ སམུདྲཀཱུལེ ཏསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ཏདཱ ས དྲྀཥྚཱནྟཀཐཱབྷི རྦཧཱུཔདིཥྚཝཱན྄ ཨུཔདིཤཾཤྩ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ཨཝདྷཱནཾ ཀུརུཏ, ཨེཀོ བཱིཛཝཔྟཱ བཱིཛཱནི ཝཔྟུཾ གཏཿ; ");
INSERT INTO santib_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ཝཔནཀཱལེ ཀིཡནྟི བཱིཛཱནི མཱརྒཔཱཤྭེ པཏིཏཱནི, ཏཏ ཨཱཀཱཤཱིཡཔཀྵིཎ ཨེཏྱ ཏཱནི ཙཁཱདུཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ཀིཡནྟི བཱིཛཱནི སྭལྤམྲྀཏྟིཀཱཝཏྤཱཥཱཎབྷཱུམཽ པཏིཏཱནི ཏཱནི མྲྀདོལྤཏྭཱཏ྄ ཤཱིགྷྲམངྐུརིཏཱནི; ");
INSERT INTO santib_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ཀིནྟཱུདིཏེ སཱུཪྻྱེ དགྡྷཱནི ཏཐཱ མཱུལཱནོ ནཱདྷོགཏཏྭཱཏ྄ ཤུཥྐཱཎི ཙ། ");
INSERT INTO santib_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ཀིཡནྟི བཱིཛཱནི ཀཎྚཀིཝནམདྷྱེ པཏིཏཱནི ཏཏཿ ཀཎྚཀཱནི སཾཝྲྀདྭྱ ཏཱནི ཛགྲསུསྟཱནི ན ཙ ཕལིཏཱནི། ");
INSERT INTO santib_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ཏཐཱ ཀིཡནྟི བཱིཛཱནྱུཏྟམབྷཱུམཽ པཏིཏཱནི ཏཱནི སཾཝྲྀདྭྱ ཕལཱནྱུཏྤཱདིཏཱནི ཀིཡནྟི བཱིཛཱནི ཏྲིཾཤདྒུཎཱནི ཀིཡནྟི ཥཥྚིགུཎཱནི ཀིཡནྟི ཤཏགུཎཱནི ཕལཱནི ཕལིཏཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ཨཐ ས ཏཱནཝདཏ྄ ཡསྱ ཤྲོཏུཾ ཀརྞཽ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ཏདནནྟརཾ ནིརྫནསམཡེ ཏཏྶངྒིནོ དྭཱདཤཤིཥྱཱཤྩ ཏཾ ཏདྡྲྀཥྚཱནྟཝཱཀྱསྱཱརྠཾ པཔྲཙྪུཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ཏདཱ ས ཏཱནུདིཏཝཱན྄ ཨཱིཤྭརརཱཛྱསྱ ནིགཱུཌྷཝཱཀྱཾ བོདྡྷུཾ ཡུཥྨཱཀམདྷིཀཱརོ྅སྟི; ");
INSERT INTO santib_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ཀིནྟུ ཡེ ཝཧིརྦྷཱུཏཱཿ \"ཏེ པཤྱནྟཿ པཤྱནྟི ཀིནྟུ ན ཛཱནནྟི, ཤྲྀཎྭནྟཿ ཤྲྀཎྭནྟི ཀིནྟུ ན བུདྷྱནྟེ, ཙེཏྟཻ རྨནཿསུ ཀདཱཔི པརིཝརྟྟིཏེཥུ ཏེཥཱཾ པཱཔཱནྱམོཙཡིཥྱནྟ,\" ཨཏོཧེཏོསྟཱན྄ པྲཏི དྲྀཥྚཱནྟཻརེཝ ཏཱནི མཡཱ ཀཐིཏཱནི། ");
INSERT INTO santib_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ཨཐ ས ཀཐིཏཝཱན྄ ཡཱུཡཾ ཀིམེཏད྄ དྲྀཥྚཱནྟཝཱཀྱཾ ན བུདྷྱདྷྭེ? ཏརྷི ཀཐཾ སཪྻྭཱན྄ དྲྀཥྚཱནྟཱན བྷོཏྶྱདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","བཱིཛཝཔྟཱ ཝཱཀྱརཱུཔཱཎི བཱིཛཱནི ཝཔཏི; ");
INSERT INTO santib_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ཏཏྲ ཡེ ཡེ ལོཀཱ ཝཱཀྱཾ ཤྲྀཎྭནྟི, ཀིནྟུ ཤྲུཏམཱཏྲཱཏ྄ ཤཻཏཱན྄ ཤཱིགྷྲམཱགཏྱ ཏེཥཱཾ མནཿསཱུཔྟཱནི ཏཱནི ཝཱཀྱརཱུཔཱཎི བཱིཛཱནྱཔནཡཏི ཏཨེཝ ཨུཔྟབཱིཛམཱརྒཔཱརྴྭེསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ཡེ ཛནཱ ཝཱཀྱཾ ཤྲུཏྭཱ སཧསཱ པརམཱནནྡེན གྲྀཧླནྟི, ཀིནྟུ ཧྲྀདི སྠཻཪྻྱཱབྷཱཝཱཏ྄ ཀིཉྩིཏ྄ ཀཱལམཱཏྲཾ ཏིཥྛནྟི ཏཏྤཤྩཱཏ྄ ཏདྭཱཀྱཧེཏོཿ ");
INSERT INTO santib_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ཀུཏྲཙིཏ྄ ཀླེཤེ ཨུཔདྲཝེ ཝཱ སམུཔསྠིཏེ ཏདཻཝ ཝིགྷྣཾ པྲཱཔྣུཝནྟི ཏཨེཝ ཨུཔྟབཱིཛཔཱཥཱཎབྷཱུམིསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ཡེ ཛནཱཿ ཀཐཱཾ ཤྲྀཎྭནྟི ཀིནྟུ སཱཾསཱརིཀཱི ཙིནྟཱ དྷནབྷྲཱནྟི ཪྻིཥཡལོབྷཤྩ ཨེཏེ སཪྻྭེ ཨུཔསྠཱཡ ཏཱཾ ཀཐཱཾ གྲསནྟི ཏཏཿ མཱ ཝིཕལཱ བྷཝཏི ");
INSERT INTO santib_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ཏཨེཝ ཨུཔྟབཱིཛསཀཎྚཀབྷཱུམིསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ཡེ ཛནཱ ཝཱཀྱཾ ཤྲུཏྭཱ གྲྀཧླནྟི ཏེཥཱཾ ཀསྱ ཝཱ ཏྲིཾཤདྒུཎཱནི ཀསྱ ཝཱ ཥཥྚིགུཎཱནི ཀསྱ ཝཱ ཤཏགུཎཱནི ཕལཱནི བྷཝནྟི ཏཨེཝ ཨུཔྟབཱིཛོཪྻྭརབྷཱུམིསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ཏདཱ སོ྅པརམཔི ཀཐིཏཝཱན྄ ཀོཔི ཛནོ དཱིཔཱདྷཱརཾ པརིཏྱཛྱ དྲོཎསྱཱདྷཿ ཁཊྭཱཡཱ ཨདྷེ ཝཱ སྠཱཔཡིཏུཾ དཱིཔམཱནཡཏི ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ཨཏོཧེཏོ ཪྻནྣ པྲཀཱཤཡིཥྱཏེ ཏཱདྲྀག྄ ལུཀྐཱཡིཏཾ ཀིམཔི ཝསྟུ ནཱསྟི; ཡད྄ ཝྱཀྟཾ ན བྷཝིཥྱཏི ཏཱདྲྀཤཾ གུཔྟཾ ཀིམཔི ཝསྟུ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ཡསྱ ཤྲོཏུཾ ཀརྞཽ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ཨཔརམཔི ཀཐིཏཝཱན྄ ཡཱུཡཾ ཡད྄ ཡད྄ ཝཱཀྱཾ ཤྲྀཎུཐ ཏཏྲ སཱཝདྷཱནཱ བྷཝཏ, ཡཏོ ཡཱུཡཾ ཡེན པརིམཱཎེན པརིམཱཐ ཏེནཻཝ པརིམཱཎེན ཡུཥྨདརྠམཔི པརིམཱསྱཏེ; ཤྲོཏཱརོ ཡཱུཡཾ ཡུཥྨབྷྱམདྷིཀཾ དཱསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ཡསྱཱཤྲཡེ ཝརྡྡྷཏེ ཏསྨཻ ཨཔརམཔི དཱསྱཏེ, ཀིནྟུ ཡསྱཱཤྲཡེ ན ཝརྡྡྷཏེ ཏསྱ ཡཏ྄ ཀིཉྩིདསྟི ཏདཔི ཏསྨཱན྄ ནེཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ཨནནྟརཾ ས ཀཐིཏཝཱན྄ ཨེཀོ ལོཀཿ ཀྵེཏྲེ བཱིཛཱནྱུཔྟྭཱ ");
INSERT INTO santib_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ཛཱགརཎནིདྲཱབྷྱཱཾ དིཝཱནིཤཾ གམཡཏི, པརནྟུ ཏདྭཱིཛཾ ཏསྱཱཛྙཱཏརཱུཔེཎཱངྐུརཡཏི ཝརྡྡྷཏེ ཙ; ");
INSERT INTO santib_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ཡཏོཧེཏོཿ པྲཐམཏཿ པཏྲཱཎི ཏཏཿ པརཾ ཀཎིཤཱནི ཏཏྤཤྩཱཏ྄ ཀཎིཤཔཱུརྞཱནི ཤསྱཱནི བྷཱུམིཿ སྭཡམུཏྤཱདཡཏི; ");
INSERT INTO santib_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ཀིནྟུ ཕལེཥུ པཀྐེཥུ ཤསྱཙྪེདནཀཱལཾ ཛྙཱཏྭཱ ས ཏཏྐྵཎཾ ཤསྱཱནི ཚིནཏྟི, ཨནེན ཏུལྱམཱིཤྭརརཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","པུནཿ སོ྅ཀཐཡད྄ ཨཱིཤྭརརཱཛྱཾ ཀེན སམཾ? ཀེན ཝསྟུནཱ སཧ ཝཱ ཏདུཔམཱསྱཱམི? ");
INSERT INTO santib_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ཏཏ྄ སརྵཔཻཀེན ཏུལྱཾ ཡཏོ མྲྀདི ཝཔནཀཱལེ སརྵཔབཱིཛཾ སཪྻྭཔྲྀཐིཝཱིསྠབཱིཛཱཏ྄ ཀྵུདྲཾ ");
INSERT INTO santib_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ཀིནྟུ ཝཔནཱཏ྄ པརམ྄ ཨངྐུརཡིཏྭཱ སཪྻྭཤཱཀཱད྄ བྲྀཧད྄ བྷཝཏི, ཏསྱ བྲྀཧཏྱཿ ཤཱཁཱཤྩ ཛཱཡནྟེ ཏཏསྟཙྪཱཡཱཾ པཀྵིཎ ཨཱཤྲཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ཨིཏྠཾ ཏེཥཱཾ བོདྷཱནུརཱུཔཾ སོ྅ནེཀདྲྀཥྚཱནྟཻསྟཱནུཔདིཥྚཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","དྲྀཥྚཱནྟཾ ཝིནཱ ཀཱམཔི ཀཐཱཾ ཏེབྷྱོ ན ཀཐིཏཝཱན྄ པཤྩཱན྄ ནིརྫནེ ས ཤིཥྱཱན྄ སཪྻྭདྲྀཥྚཱནྟཱརྠཾ བོདྷིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ཏདྡིནསྱ སནྡྷྱཱཡཱཾ ས ཏེབྷྱོ྅ཀཐཡད྄ ཨཱགཙྪཏ ཝཡཾ པཱརཾ ཡཱམ། ");
INSERT INTO santib_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ཏདཱ ཏེ ལོཀཱན྄ ཝིསྲྀཛྱ ཏམཝིལམྦཾ གྲྀཧཱིཏྭཱ ནཽཀཡཱ པྲཏསྠིརེ; ཨཔརཱ ཨཔི ནཱཝསྟཡཱ སཧ སྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ཏཏཿ པརཾ མཧཱཛྷཉྦྷྴགམཱཏ྄ ནཽ རྡོལཱཡམཱནཱ ཏརངྒེཎ ཛལཻཿ པཱུརྞཱབྷཝཙྩ། ");
INSERT INTO santib_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ཏདཱ ས ནཽཀཱཙཤྩཱདྦྷཱགེ ཨུཔདྷཱནེ ཤིརོ ནིདྷཱཡ ནིདྲིཏ ཨཱསཱིཏ྄ ཏཏསྟེ ཏཾ ཛཱགརཡིཏྭཱ ཛགདུཿ, ཧེ པྲབྷོ, ཨསྨཱཀཾ པྲཱཎཱ ཡཱནྟི ཀིམཏྲ བྷཝཏཤྩིནྟཱ ནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ཏདཱ ས ཨུཏྠཱཡ ཝཱཡུཾ ཏརྫིཏཝཱན྄ སམུདྲཉྩོཀྟཝཱན྄ ཤཱནྟཿ སུསྠིརཤྩ བྷཝ; ཏཏོ ཝཱཡཽ ནིཝྲྀཏྟེ྅བྡྷིརྣིསྟརངྒོབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ཏདཱ ས ཏཱནུཝཱཙ ཡཱུཡཾ ཀུཏ ཨེཏཱདྲྀཀྴངྐཱཀུལཱ བྷཝཏ? ཀིཾ ཝོ ཝིཤྭཱསོ ནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ཏསྨཱཏྟེ྅ཏཱིཝབྷཱིཏཱཿ པརསྤརཾ ཝཀྟུམཱརེབྷིརེ, ཨཧོ ཝཱཡུཿ སིནྡྷུཤྩཱསྱ ནིདེཤགྲཱཧིཎཽ ཀཱིདྲྀགཡཾ མནུཛཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ཨཐ ཏཱུ སིནྡྷུཔཱརཾ གཏྭཱ གིདེརཱིཡཔྲདེཤ ཨུཔཏསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ནཽཀཱཏོ ནིརྒཏམཱཏྲཱད྄ ཨཔཝིཏྲབྷཱུཏགྲསྟ ཨེཀཿ ཤྨཤཱནཱདེཏྱ ཏཾ སཱཀྵཱཙ྄ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ས ཤྨཤཱནེ྅ཝཱཏྶཱིཏ྄ ཀོཔི ཏཾ ཤྲྀངྑལེན བདྭྭཱ སྠཱཔཡིཏུཾ ནཱཤཀྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ཛནཻཪྻཱརཾ ནིགཌཻཿ ཤྲྀངྑལཻཤྩ ས བདྡྷོཔི ཤྲྀངྑལཱནྱཱཀྲྀཥྱ མོཙིཏཝཱན྄ ནིགཌཱནི ཙ བྷཾཀྟྭཱ ཁཎྜཾ ཁཎྜཾ ཀྲྀཏཝཱན྄ ཀོཔི ཏཾ ཝཤཱིཀརྟྟུཾ ན ཤཤཀ། ");
INSERT INTO santib_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","དིཝཱནིཤཾ སདཱ པཪྻྭཏཾ ཤྨཤཱནཉྩ བྷྲམིཏྭཱ ཙཱིཏྴབྡཾ ཀྲྀཏཝཱན྄ གྲཱཝབྷིཤྩ སྭཡཾ སྭཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ས ཡཱིཤུཾ དཱུརཱཏ྄ པཤྱནྣེཝ དྷཱཝན྄ ཏཾ པྲཎནཱམ ཨུཙཻརུཝཾཤྩོཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ཧེ སཪྻྭོཔརིསྠེཤྭརཔུཏྲ ཡཱིཤོ བྷཝཏཱ སཧ མེ ཀཿ སམྦནྡྷཿ? ཨཧཾ ཏྭཱམཱིཤྭརེཎ ཤཱཔཡེ མཱཾ མཱ ཡཱཏཡ། ");
INSERT INTO santib_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ཡཏོ ཡཱིཤུསྟཾ ཀཐིཏཝཱན྄ རེ ཨཔཝིཏྲབྷཱུཏ, ཨསྨཱནྣརཱད྄ བཧིརྣིརྒཙྪ། ");
INSERT INTO santib_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ཨཐ ས ཏཾ པྲྀཥྚཝཱན྄ ཀིནྟེ ནཱམ? ཏེན པྲཏྱུཀྟཾ ཝཡམནེཀེ ྅སྨསྟཏོ྅སྨནྣཱམ བཱཧིནཱི། ");
INSERT INTO santib_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ཏཏོསྨཱན྄ དེཤཱནྣ པྲེཥཡེཏི ཏེ ཏཾ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ཏདཱནཱིཾ པཪྻྭཏཾ ནིཀཥཱ བྲྀཧན྄ ཝརཱཧཝྲཛཤྩརནྣཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ཏསྨཱད྄ བྷཱུཏཱ ཝིནཡེན ཛགདུཿ, ཨམུཾ ཝརཱཧཝྲཛམ྄ ཨཱཤྲཡིཏུམ྄ ཨསྨཱན྄ པྲཧིཎུ། ");
INSERT INTO santib_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ཡཱིཤུནཱནུཛྙཱཏཱསྟེ྅པཝིཏྲབྷཱུཏཱ བཧིརྣིཪྻཱཡ ཝརཱཧཝྲཛཾ པྲཱཝིཤན྄ ཏཏཿ སཪྻྭེ ཝརཱཧཱ ཝསྟུཏསྟུ པྲཱཡོདྭིསཧསྲསཾངྑྱཀཱཿ ཀཊཀེན མཧཱཛཝཱད྄ དྷཱཝནྟཿ སིནྡྷཽ པྲཱཎཱན྄ ཛཧུཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ཏསྨཱད྄ ཝརཱཧཔཱལཀཱཿ པལཱཡམཱནཱཿ པུརེ གྲཱམེ ཙ ཏདྭཱརྟྟཾ ཀཐཡཱཉྩཀྲུཿ། ཏདཱ ལོཀཱ གྷཊིཏཾ ཏཏྐཱཪྻྱཾ དྲཥྚུཾ བཧིརྫགྨུཿ ");
INSERT INTO santib_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ཡཱིཤོཿ སནྣིདྷིཾ གཏྭཱ ཏཾ བྷཱུཏགྲསྟམ྄ ཨརྠཱད྄ བཱཧིནཱིབྷཱུཏགྲསྟཾ ནརཾ སཝསྟྲཾ སཙེཏནཾ སམུཔཝིཥྚཉྩ དྲྀृཥྚྭཱ བིབྷྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ཏཏོ དྲྀཥྚཏཏྐཱཪྻྱལོཀཱསྟསྱ བྷཱུཏགྲསྟནརསྱ ཝརཱཧཝྲཛསྱཱཔི ཏཱཾ དྷཊནཱཾ ཝརྞཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ཏཏསྟེ སྭསཱིམཱཏོ བཧིརྒནྟུཾ ཡཱིཤུཾ ཝིནེཏུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ཨཐ ཏསྱ ནཽཀཱརོཧཎཀཱལེ ས བྷཱུཏམུཀྟོ ནཱ ཡཱིཤུནཱ སཧ སྠཱཏུཾ པྲཱརྠཡཏེ; ");
INSERT INTO santib_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ཀིནྟུ ས ཏམནནུམཏྱ ཀཐིཏཝཱན྄ ཏྭཾ ནིཛཱཏྨཱིཡཱནཱཾ སམཱིཔཾ གྲྀཧཉྩ གཙྪ པྲབྷུསྟྭཡི ཀྲྀཔཱཾ ཀྲྀཏྭཱ ཡཱནི ཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཏཱནི ཏཱན྄ ཛྙཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ཨཏཿ ས པྲསྠཱཡ ཡཱིཤུནཱ ཀྲྀཏཾ ཏཏྶཪྻྭཱཤྩཪྻྱཾ ཀརྨྨ དིཀཱཔལིདེཤེ པྲཙཱརཡིཏུཾ པྲཱརབྡྷཝཱན྄ ཏཏཿ སཪྻྭེ ལོཀཱ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ཨནནྟརཾ ཡཱིཤཽ ནཱཝཱ པུནརནྱཔཱར ཨུཏྟཱིརྞེ སིནྡྷུཏཊེ ཙ ཏིཥྛཏི སཏི ཏཏྶམཱིཔེ བཧུལོཀཱནཱཾ སམཱགམོ྅བྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ཨཔརཾ ཡཱཡཱིར྄ ནཱམྣཱ ཀཤྩིད྄ བྷཛནགྲྀཧསྱཱདྷིཔ ཨཱགཏྱ ཏཾ དྲྀཥྚྭཻཝ ཙརཎཡོཿ པཏིཏྭཱ བཧུ ནིཝེདྱ ཀཐིཏཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","མམ ཀནྱཱ མྲྀཏཔྲཱཡཱབྷཱུད྄ ཨཏོ བྷཝཱནེཏྱ ཏདཱརོགྱཱཡ ཏསྱཱ གཱཏྲེ ཧསྟམ྄ ཨརྤཡཏུ ཏེནཻཝ སཱ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ཏདཱ ཡཱིཤུསྟེན སཧ ཙལིཏཿ ཀིནྟུ ཏཏྤཤྩཱད྄ བཧུལོཀཱཤྩལིཏྭཱ ཏཱདྒཱཏྲེ པཏིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ཨཐ དྭཱདཤཝརྵཱཎི པྲདརརོགེཎ ");
INSERT INTO santib_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ཤཱིརྞཱ ཙིཀིཏྶཀཱནཱཾ ནཱནཱཙིཀིཏྶཱབྷིཤྩ དུཿཁཾ བྷུཀྟཝཏཱི ཙ སཪྻྭསྭཾ ཝྱཡིཏྭཱཔི ནཱརོགྱཾ པྲཱཔྟཱ ཙ པུནརཔི པཱིཌིཏཱསཱིཙྩ ");
INSERT INTO santib_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ཡཱ སྟྲཱི སཱ ཡཱིཤོ ཪྻཱརྟྟཱཾ པྲཱཔྱ མནསཱཀཐཡཏ྄ ཡདྱཧཾ ཏསྱ ཝསྟྲམཱཏྲ སྤྲཥྚུཾ ལབྷེཡཾ ཏདཱ རོགཧཱིནཱ བྷཝིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ཨཏོཧེཏོཿ སཱ ལོཀཱརཎྱམདྷྱེ ཏཏྤཤྩཱདཱགཏྱ ཏསྱ ཝསྟྲཾ པསྤརྴ། ");
INSERT INTO santib_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ཏེནཻཝ ཏཏྐྵཎཾ ཏསྱཱ རཀྟསྲོཏཿ ཤུཥྐཾ སྭཡཾ ཏསྨཱད྄ རོགཱནྨུཀྟཱ ཨིཏྱཔི དེཧེ྅ནུབྷཱུཏཱ། ");
INSERT INTO santib_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ཨཐ སྭསྨཱཏ྄ ཤཀྟི རྣིརྒཏཱ ཡཱིཤུརེཏནྨནསཱ ཛྙཱཏྭཱ ལོཀནིཝཧཾ པྲཏི མུཁཾ ཝྱཱཝྲྀཏྱ པྲྀཥྚཝཱན྄ ཀེན མདྭསྟྲཾ སྤྲྀཥྚཾ? ");
INSERT INTO santib_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ཏཏསྟསྱ ཤིཥྱཱ ཨཱུཙུཿ བྷཝཏོ ཝཔུཥི ལོཀཱཿ སཾགྷརྵནྟི ཏད྄ དྲྀཥྚྭཱ ཀེན མདྭསྟྲཾ སྤྲྀཥྚམིཏི ཀུཏཿ ཀཐཡཏི? ");
INSERT INTO santib_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ཀིནྟུ ཀེན ཏཏ྄ ཀརྨྨ ཀྲྀཏཾ ཏད྄ དྲཥྚུཾ ཡཱིཤུཤྩཏུརྡིཤོ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ཏཏཿ སཱ སྟྲཱི བྷཱིཏཱ ཀམྤིཏཱ ཙ སཏཱི སྭསྱཱ རུཀྤྲཏིཀྲིཡཱ ཛཱཏེཏི ཛྙཱཏྭཱགཏྱ ཏཏྶམྨུཁེ པཏིཏྭཱ སཪྻྭཝྲྀཏྟཱནྟཾ སཏྱཾ ཏསྨཻ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ཏདཱནཱིཾ ཡཱིཤུསྟཱཾ གདིཏཝཱན྄, ཧེ ཀནྱེ ཏཝ པྲཏཱིཏིསྟྭཱམ྄ ཨརོགཱམཀརོཏ྄ ཏྭཾ ཀྵེམེཎ ཝྲཛ སྭརོགཱནྨུཀྟཱ ཙ ཏིཥྛ། ");
INSERT INTO santib_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ཨིཏིཝཱཀྱཝདནཀཱལེ བྷཛནགྲྀཧཱདྷིཔསྱ ནིཝེཤནཱལ྄ ལོཀཱ ཨེཏྱཱདྷིཔཾ བབྷཱཥིརེ ཏཝ ཀནྱཱ མྲྀཏཱ ཏསྨཱད྄ གུརུཾ པུནཿ ཀུཏཿ ཀླིཤྣཱསི? ");
INSERT INTO santib_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ཀིནྟུ ཡཱིཤུསྟད྄ ཝཱཀྱཾ ཤྲུཏྭཻཝ བྷཛནགྲྀཧཱདྷིཔཾ གདིཏཝཱན྄ མཱ བྷཻཥཱིཿ ཀེཝལཾ ཝིཤྭཱསིཧི། ");
INSERT INTO santib_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ཨཐ པིཏརོ ཡཱཀཱུབ྄ ཏདྦྷྲཱཏཱ ཡོཧན྄ ཙ ཨེཏཱན྄ ཝིནཱ ཀམཔི སྭཔཤྩཱད྄ ཡཱཏུཾ ནཱནྭམནྱཏ། ");
INSERT INTO santib_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ཏསྱ བྷཛནགྲྀཧཱདྷིཔསྱ ནིཝེཤནསམཱིཔམ྄ ཨཱགཏྱ ཀལཧཾ བཧུརོདནཾ ཝིལཱཔཉྩ ཀུཪྻྭཏོ ལོཀཱན྄ དདརྴ། ");
INSERT INTO santib_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ཏསྨཱན྄ ནིཝེཤནཾ པྲཝིཤྱ པྲོཀྟཝཱན྄ ཡཱུཡཾ ཀུཏ ཨིཏྠཾ ཀལཧཾ རོདནཉྩ ཀུརུཐ? ཀནྱཱ ན མྲྀཏཱ ནིདྲཱཏི། ");
INSERT INTO santib_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ཏསྨཱཏྟེ ཏམུཔཛཧསུཿ ཀིནྟུ ཡཱིཤུཿ སཪྻྭཱན བཧིཥྐྲྀཏྱ ཀནྱཱཡཱཿ པིཏརཽ སྭསངྒིནཤྩ གྲྀཧཱིཏྭཱ ཡཏྲ ཀནྱཱསཱིཏ྄ ཏཏ྄ སྠཱནཾ པྲཝིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ཨཐ ས ཏསྱཱཿ ཀནྱཱཡཱ ཧསྟཽ དྷྲྀཏྭཱ ཏཱཾ བབྷཱཥེ ཊཱལཱིཐཱ ཀཱུམཱི, ཨརྠཏོ ཧེ ཀནྱེ ཏྭམུཏྟིཥྛ ཨིཏྱཱཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ཏུནཻཝ ཏཏྐྵཎཾ སཱ དྭཱདཤཝརྵཝཡསྐཱ ཀནྱཱ པོཏྠཱཡ ཙལིཏུམཱརེབྷེ, ཨིཏཿ སཪྻྭེ མཧཱཝིསྨཡཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ཏཏ ཨེཏསྱཻ ཀིཉྩིཏ྄ ཁཱདྱཾ དཏྟེཏི ཀཐཡིཏྭཱ ཨེཏཏྐརྨྨ ཀམཔི ན ཛྙཱཔཡཏེཏི དྲྀཌྷམཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ཨནནྟརཾ ས ཏཏྶྠཱནཱཏ྄ པྲསྠཱཡ སྭཔྲདེཤམཱགཏཿ ཤིཥྱཱཤྩ ཏཏྤཤྩཱད྄ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ཨཐ ཝིཤྲཱམཝཱརེ སཏི ས བྷཛནགྲྀཧེ ཨུཔདེཥྚུམཱརབྡྷཝཱན྄ ཏཏོ྅ནེཀེ ལོཀཱསྟཏྐཐཱཾ ཤྲུཏྭཱ ཝིསྨིཏྱ ཛགདུཿ, ཨསྱ མནུཛསྱ ཨཱིདྲྀཤཱི ཨཱཤྩཪྻྱཀྲིཡཱ ཀསྨཱཛ྄ ཛཱཏཱ? ཏཐཱ སྭཀརཱབྷྱཱམ྄ ཨིཏྠམདྦྷུཏཾ ཀརྨྨ ཀརྟྟཱुམ྄ ཨེཏསྨཻ ཀཐཾ ཛྙཱནཾ དཏྟམ྄? ");
INSERT INTO santib_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ཀིམཡཾ མརིཡམཿ པུཏྲསྟཛྙཱ ནོ? ཀིམཡཾ ཡཱཀཱུབ྄-ཡོསི-ཡིཧུདཱ-ཤིམོནཱཾ བྷྲཱཏཱ ནོ? ཨསྱ བྷགིནྱཿ ཀིམིཧཱསྨཱབྷིཿ སཧ ནོ? ཨིཏྠཾ ཏེ ཏདརྠེ པྲཏྱཱུཧཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ཏདཱ ཡཱིཤུསྟེབྷྱོ྅ཀཐཡཏ྄ སྭདེཤཾ སྭཀུཊུམྦཱན྄ སྭཔརིཛནཱཾཤྩ ཝིནཱ ཀུཏྲཱཔི བྷཝིཥྱདྭཱདཱི ཨསཏྐྲྀཏོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ཨཔརཉྩ ཏེཥཱམཔྲཏྱཡཱཏ྄ ས ཝིསྨིཏཿ ཀིཡཏཱཾ རོགིཎཱཾ ཝཔུཿཥུ ཧསྟམ྄ ཨརྤཡིཏྭཱ ཀེཝལཾ ཏེཥཱམཱརོགྱཀརཎཱད྄ ཨནྱཏ྄ ཀིམཔི ཙིཏྲཀཱཪྻྱཾ ཀརྟྟཱཾ ན ཤཀྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ཨཐ ས ཙཏུརྡིཀྶྠ གྲཱམཱན྄ བྷྲམིཏྭཱ ཨུཔདིཥྚཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","དྭཱདཤཤིཥྱཱན྄ ཨཱཧཱུཡ ཨམེདྷྱབྷཱུཏཱན྄ ཝཤཱིཀརྟྟཱཾ ཤཀྟིཾ དཏྟྭཱ ཏེཥཱཾ དྭཽ དྭཽ ཛནོ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","པུནརིཏྱཱདིཤད྄ ཡཱུཡམ྄ ཨེཀཻཀཱཾ ཡཥྚིཾ ཝིནཱ ཝསྟྲསཾཔུཊཿ པཱུཔཿ ཀཊིབནྡྷེ ཏཱམྲཁཎྜཉྩ ཨེཥཱཾ ཀིམཔི མཱ གྲཧླཱིཏ, ");
INSERT INTO santib_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","མཱརྒཡཱཏྲཱཡཻ པཱདེཥཱུཔཱནཧཽ དཏྟྭཱ དྭེ ཨུཏྟརཱིཡེ མཱ པརིདྷདྭྭཾ། ");
INSERT INTO santib_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ཨཔརམཔྱུཀྟཾ ཏེན ཡཱུཡཾ ཡསྱཱཾ པུཪྻྱཱཾ ཡསྱ ནིཝེཤནཾ པྲཝེཀྵྱཐ ཏཱཾ པུརཱིཾ ཡཱཝནྣ ཏྱཀྵྱཐ ཏཱཝཏ྄ ཏནྣིཝེཤནེ སྠཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ཏཏྲ ཡདི ཀེཔི ཡུཥྨཱཀམཱཏིཐྱཾ ན ཝིདདྷཏི ཡུཥྨཱཀཾ ཀཐཱཤྩ ན ཤྲྀཎྭནྟི ཏརྷི ཏཏྶྠཱནཱཏ྄ པྲསྠཱནསམཡེ ཏེཥཱཾ ཝིརུདྡྷཾ སཱཀྵྱཾ དཱཏུཾ སྭཔཱདཱནཱསྥཱལྱ རཛཿ སམྤཱཏཡཏ; ཨཧཾ ཡུཥྨཱན྄ ཡཐཱརྠཾ ཝཙྨི ཝིཙཱརདིནེ ཏནྣགརསྱཱཝསྠཱཏཿ སིདོམཱམོརཡོ རྣགརཡོརཝསྠཱ སཧྱཏརཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ཨཐ ཏེ གཏྭཱ ལོཀཱནཱཾ མནཿཔརཱཝརྟྟནཱིཿ ཀཐཱ པྲཙཱརིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ཨེཝམནེཀཱན྄ བྷཱུཏཱཾཤྩ ཏྱཱཛིཏཝནྟསྟཐཱ ཏཻལེན མརྡྡཡིཏྭཱ བཧཱུན྄ ཛནཱནརོགཱནཀཱརྵུཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ཨིཏྠཾ ཏསྱ སུཁྱཱཏིཤྩཏུརྡིཤོ ཝྱཱཔྟཱ ཏདཱ ཧེརོད྄ རཱཛཱ ཏནྣིཤམྱ ཀཐིཏཝཱན྄, ཡོཧན྄ མཛྫཀཿ ཤྨཤཱནཱད྄ ཨུཏྠིཏ ཨཏོཧེཏོསྟེན སཪྻྭཱ ཨེཏཱ ཨདྦྷུཏཀྲིཡཱཿ པྲཀཱཤནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ཨནྱེ྅ཀཐཡན྄ ཨཡམ྄ ཨེལིཡཿ, ཀེཔི ཀཐིཏཝནྟ ཨེཥ བྷཝིཥྱདྭཱདཱི ཡདྭཱ བྷཝིཥྱདྭཱདིནཱཾ སདྲྀཤ ཨེཀོཡམ྄། ");
INSERT INTO santib_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ཀིནྟུ ཧེརོད྄ ཨིཏྱཱཀརྞྱ བྷཱཥིཏཝཱན྄ ཡསྱཱཧཾ ཤིརཤྪིནྣཝཱན྄ ས ཨེཝ ཡོཧནཡཾ ས ཤྨཤཱནཱདུདཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","པཱུཪྻྭཾ སྭབྷྲཱཏུཿ ཕིལིཔསྱ པཏྣྱཱ ཨུདྭཱཧཾ ཀྲྀཏཝནྟཾ ཧེརོདཾ ཡོཧནཝཱདཱིཏ྄ སྭབྷཱཏྲྀཝདྷཱུ རྣ ཝིཝཱཧྱཱ། ");
INSERT INTO santib_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ཨཏཿ ཀཱརཎཱཏ྄ ཧེརོད྄ ལོཀཾ པྲཧིཏྱ ཡོཧནཾ དྷྲྀཏྭཱ བནྡྷནཱལཡེ བདྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ཧེརོདིཡཱ ཏསྨཻ ཡོཧནེ པྲཀུཔྱ ཏཾ ཧནྟུམ྄ ཨཻཙྪཏ྄ ཀིནྟུ ན ཤཀྟཱ, ");
INSERT INTO santib_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ཡསྨཱད྄ ཧེརོད྄ ཏཾ དྷཱརྨྨིཀཾ སཏྤུརུཥཉྩ ཛྙཱཏྭཱ སམྨནྱ རཀྵིཏཝཱན྄; ཏཏྐཐཱཾ ཤྲུཏྭཱ ཏདནུསཱརེཎ བཧཱུནི ཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཧྲྀཥྚམནཱསྟདུཔདེཤཾ ཤྲུཏཝཱཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ཀིནྟུ ཧེརོད྄ ཡདཱ སྭཛནྨདིནེ པྲདྷཱནལོཀེབྷྱཿ སེནཱནཱིབྷྱཤྩ གཱལཱིལྤྲདེཤཱིཡཤྲེཥྛལོཀེབྷྱཤྩ རཱཏྲཽ བྷོཛྱམེཀཾ ཀྲྀཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ཏསྨིན྄ ཤུབྷདིནེ ཧེརོདིཡཱཡཱཿ ཀནྱཱ སམེཏྱ ཏེཥཱཾ སམཀྵཾ སཾནྲྀཏྱ ཧེརོདསྟེན སཧོཔཝིཥྚཱནཱཉྩ ཏོཥམཛཱིཛནཏ྄ ཏཏཱ ནྲྀཔཿ ཀནྱཱམཱཧ སྨ མཏྟོ ཡད྄ ཡཱཙསེ ཏདེཝ ཏུབྷྱཾ དཱསྱེ། ");
INSERT INTO santib_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ཤཔཐཾ ཀྲྀཏྭཱཀཐཡཏ྄ ཙེད྄ རཱཛྱཱརྡྡྷམཔི ཡཱཙསེ ཏདཔི ཏུབྷྱཾ དཱསྱེ། ");
INSERT INTO santib_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ཏཏཿ སཱ བཧི རྒཏྭཱ སྭམཱཏརཾ པཔྲཙྪ ཀིམཧཾ ཡཱཙིཥྱེ? ཏདཱ སཱཀཐཡཏ྄ ཡོཧནོ མཛྫཀསྱ ཤིརཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ཨཐ ཏཱུརྞཾ བྷཱུཔསམཱིཔམ྄ ཨེཏྱ ཡཱཙམཱནཱཝདཏ྄ ཀྵཎེསྨིན྄ ཡོཧནོ མཛྫཀསྱ ཤིརཿ པཱཏྲེ ནིདྷཱཡ དེཧི, ཨེཏད྄ ཡཱཙེ྅ཧཾ། ");
INSERT INTO santib_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ཏསྨཱཏ྄ བྷཱུཔོ྅ཏིདུཿཁིཏཿ, ཏཐཱཔི སྭཤཔཐསྱ སཧབྷོཛིནཱཉྩཱནུརོདྷཱཏ྄ ཏདནངྒཱིཀརྟྟུཾ ན ཤཀྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ཏཏྐྵཎཾ རཱཛཱ གྷཱཏཀཾ པྲེཥྱ ཏསྱ ཤིར ཨཱནེཏུམཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ཏཏཿ ས ཀཱརཱགཱརཾ གཏྭཱ ཏཙྪིརཤྪིཏྭཱ པཱཏྲེ ནིདྷཱཡཱནཱིཡ ཏསྱཻ ཀནྱཱཡཻ དཏྟཝཱན྄ ཀནྱཱ ཙ སྭམཱཏྲེ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ཨནནཏརཾ ཡོཧནཿ ཤིཥྱཱསྟདྭཱརྟྟཱཾ པྲཱཔྱཱགཏྱ ཏསྱ ཀུཎཔཾ ཤྨཤཱནེ྅སྠཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ཨཐ པྲེཥིཏཱ ཡཱིཤོཿ སནྣིདྷཽ མིལིཏཱ ཡད྄ ཡཙ྄ ཙཀྲུཿ ཤིཀྵཡཱམཱསུཤྩ ཏཏྶཪྻྭཝཱརྟྟཱསྟསྨཻ ཀཐིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ས ཏཱནུཝཱཙ ཡཱུཡཾ ཝིཛནསྠཱནཾ གཏྭཱ ཝིཤྲཱམྱཏ ཡཏསྟཏྶནྣིདྷཽ བཧུལོཀཱནཱཾ སམཱགམཱཏ྄ ཏེ བྷོཀྟུཾ ནཱཝཀཱཤཾ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ཏཏསྟེ ནཱཝཱ ཝིཛནསྠཱནཾ གུཔྟཾ གགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ཏཏོ ལོཀནིཝཧསྟེཥཱཾ སྠཱནཱནྟརཡཱནཾ དདརྴ, ཨནེཀེ ཏཾ པརིཙིཏྱ ནཱནཱཔུརེབྷྱཿ པདཻཪྻྲཛིཏྭཱ ཛཝེན ཏཻཥཱམགྲེ ཡཱིཤོཿ སམཱིཔ ཨུཔཏསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ཏདཱ ཡཱིཤུ རྣཱཝོ བཧིརྒཏྱ ལོཀཱརཎྱཱནཱིཾ དྲྀཥྚྭཱ ཏེཥུ ཀརུཎཱཾ ཀྲྀཏཝཱན྄ ཡཏསྟེ྅རཀྵཀམེཥཱ ཨིཝཱསན྄ ཏདཱ ས ཏཱན ནཱནཱཔྲསངྒཱན྄ ཨུཔདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ཨཐ དིཝཱནྟེ སཏི ཤིཥྱཱ ཨེཏྱ ཡཱིཤུམཱུཙིརེ, ཨིདཾ ཝིཛནསྠཱནཾ དིནཉྩཱཝསནྣཾ། ");
INSERT INTO santib_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ལོཀཱནཱཾ ཀིམཔི ཁཱདྱཾ ནཱསྟི, ཨཏཤྩཏུརྡིཀྵུ གྲཱམཱན྄ གནྟུཾ བྷོཛྱདྲཝྱཱཎི ཀྲེཏུཉྩ བྷཝཱན྄ ཏཱན྄ ཝིསྲྀཛཏུ། ");
INSERT INTO santib_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ཏདཱ ས ཏཱནུཝཱཙ ཡཱུཡམེཝ ཏཱན྄ བྷོཛཡཏ; ཏཏསྟེ ཛགདུ ཪྻཡཾ གཏྭཱ དྭིཤཏསཾཁྱཀཻ རྨུདྲཱཔཱདཻཿ པཱུཔཱན྄ ཀྲཱིཏྭཱ ཀིཾ ཏཱན྄ བྷོཛཡིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ཏདཱ ས ཏཱན྄ པྲྀཥྛཝཱན྄ ཡུཥྨཱཀཾ སནྣིདྷཽ ཀཏི པཱུཔཱ ཨཱསཏེ? གཏྭཱ པཤྱཏ; ཏཏསྟེ དྲྀཥྚྭཱ ཏམཝདན྄ པཉྩ པཱུཔཱ དྭཽ མཏྶྱཽ ཙ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ཏདཱ ས ལོཀཱན྄ ཤསྤོཔརི པཾཀྟིབྷིརུཔཝེཤཡིཏུམ྄ ཨཱདིཥྚཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ཏཏསྟེ ཤཏཾ ཤཏཾ ཛནཱཿ པཉྩཱཤཏ྄ པཉྩཱཤཛྫནཱཤྩ པཾཀྟིབྷི རྦྷུཝི སམུཔཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ཨཐ ས ཏཱན྄ པཉྩཔཱུཔཱན྄ མཏྶྱདྭཡཉྩ དྷྲྀཏྭཱ སྭརྒཾ པཤྱན྄ ཨཱིཤྭརགུཎཱན྄ ཨནྭཀཱིརྟྟཡཏ྄ ཏཱན྄ པཱུཔཱན྄ བྷཾཀྟྭཱ ལོཀེབྷྱཿ པརིཝེཥཡིཏུཾ ཤིཥྱེབྷྱོ དཏྟཝཱན྄ དྭཱ མཏྶྱཽ ཙ ཝིབྷཛྱ སཪྻྭེབྷྱོ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ཏཏཿ སཪྻྭེ བྷུཀྟྭཱཏྲྀཔྱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ཨནནྟརཾ ཤིཥྱཱ ཨཝཤིཥྚཻཿ པཱུཔཻ རྨཏྶྱཻཤྩ པཱུརྞཱན྄ དྭདཤ ཌལླཀཱན྄ ཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ཏེ བྷོཀྟཱརཿ པྲཱཡཿ པཉྩ སཧསྲཱཎི པུརུཥཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ཨཐ ས ལོཀཱན྄ ཝིསྲྀཛནྣེཝ ནཱཝམཱརོཌྷུཾ སྭསྨཱདགྲེ པཱརེ བཻཏྶཻདཱཔུརཾ ཡཱཏུཉྩ ཤྵྱིाན྄ ཝཱཌྷམཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ཏདཱ ས སཪྻྭཱན྄ ཝིསྲྀཛྱ པྲཱརྠཡིཏུཾ པཪྻྭཏཾ གཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ཏཏཿ སནྡྷྱཱཡཱཾ སཏྱཱཾ ནཽཿ སིནྡྷུམདྷྱ ཨུཔསྠིཏཱ ཀིནྟུ ས ཨེཀཱཀཱི སྠལེ སྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ཨཐ སམྨུཁཝཱཏཝཧནཱཏ྄ ཤིཥྱཱ ནཱཝཾ ཝཱཧཡིཏྭཱ པརིཤྲཱནྟཱ ཨིཏི ཛྙཱཏྭཱ ས ནིཤཱཙཏུརྠཡཱམེ སིནྡྷཱུཔརི པདྦྷྱཱཾ ཝྲཛན྄ ཏེཥཱཾ སམཱིཔམེཏྱ ཏེཥཱམགྲེ ཡཱཏུམ྄ ཨུདྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ཀིནྟུ ཤིཥྱཱཿ སིནྡྷཱུཔརི ཏཾ ཝྲཛནྟཾ དྲྀཥྚྭཱ བྷཱུཏམནུམཱཡ རུརུཝུཿ, ");
INSERT INTO santib_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ཡཏཿ སཪྻྭེ ཏཾ དྲྀཥྚྭཱ ཝྱཱཀུལིཏཱཿ། ཨཏཨེཝ ཡཱིཤུསྟཏྐྵཎཾ ཏཻཿ སཧཱལཔྱ ཀཐིཏཝཱན྄, སུསྠིརཱ བྷཱུཏ, ཨཡམཧཾ མཱ བྷཻཥྚ། ");
INSERT INTO santib_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ཨཐ ནཽཀཱམཱརུཧྱ ཏསྨིན྄ ཏེཥཱཾ སནྣིདྷིཾ གཏེ ཝཱཏོ ནིཝྲྀཏྟཿ; ཏསྨཱཏྟེ མནཿསུ ཝིསྨིཏཱ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ཡཏསྟེ མནསཱཾ ཀཱཋིནྱཱཏ྄ ཏཏ྄ པཱུཔཱིཡམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ ན ཝིཝིཀྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ཨཐ ཏེ པཱརཾ གཏྭཱ གིནེཥརཏྤྲདེཤམེཏྱ ཏཊ ཨུཔསྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ཏེཥུ ནཽཀཱཏོ བཧིརྒཏེཥུ ཏཏྤྲདེཤཱིཡཱ ལོཀཱསྟཾ པརིཙིཏྱ ");
INSERT INTO santib_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ཙཏུརྡིཀྵུ དྷཱཝནྟོ ཡཏྲ ཡཏྲ རོགིཎོ ནརཱ ཨཱསན྄ ཏཱན྄ སཪྻྭཱན ཁཊྭོཔརི ནིདྷཱཡ ཡཏྲ ཀུཏྲཙིཏ྄ ཏདྭཱརྟྟཱཾ པྲཱཔུཿ ཏཏ྄ སྠཱནམ྄ ཨཱནེཏུམ྄ ཨཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ཏཐཱ ཡཏྲ ཡཏྲ གྲཱམེ ཡཏྲ ཡཏྲ པུརེ ཡཏྲ ཡཏྲ པལླྱཱཉྩ ཏེན པྲཝེཤཿ ཀྲྀཏསྟདྭརྟྨམདྷྱེ ལོཀཱཿ པཱིཌིཏཱན྄ སྠཱཔཡིཏྭཱ ཏསྱ ཙེལགྲནྠིམཱཏྲཾ སྤྲཥྚུམ྄ ཏེཥཱམརྠེ ཏདནུཛྙཱཾ པྲཱརྠཡནྟཿ ཡཱཝནྟོ ལོཀཱཿ པསྤྲྀཤུསྟཱཝནྟ ཨེཝ གདཱནྨུཀྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ཨནནྟརཾ ཡིརཱུཤཱལམ ཨཱགཏཱཿ ཕིརཱུཤིནོ྅དྷྱཱཔཀཱཤྩ ཡཱིཤོཿ སམཱིཔམ྄ ཨཱགཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ཏེ ཏསྱ ཀིཡཏཿ ཤིཥྱཱན྄ ཨཤུཙིཀརཻརརྠཱད ཨཔྲཀྵཱལིཏཧསྟཻ རྦྷུཉྫཏོ དྲྀཥྚྭཱ ཏཱནདཱུཥཡན྄། ");
INSERT INTO santib_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ཡཏཿ ཕིརཱུཤིནཿ སཪྻྭཡིཧཱུདཱིཡཱཤྩ པྲཱཙཱཾ པརམྤརཱགཏཝཱཀྱཾ སམྨནྱ པྲཏལེན ཧསྟཱན྄ ཨཔྲཀྵཱལྱ ན བྷུཉྫཏེ། ");
INSERT INTO santib_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ཨཱཔནཱདཱགཏྱ མཛྫནཾ ཝིནཱ ན ཁཱདནྟི; ཏཐཱ པཱནཔཱཏྲཱཎཱཾ ཛལཔཱཏྲཱཎཱཾ པིཏྟལཔཱཏྲཱཎཱམ྄ ཨཱསནཱནཱཉྩ ཛལེ མཛྫནམ྄ ཨིཏྱཱདཡོནྱེཔི བཧཝསྟེཥཱམཱཙཱརཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ཏེ ཕིརཱུཤིནོ྅དྷྱཱཔཀཱཤྩ ཡཱིཤུཾ པཔྲཙྪུཿ, ཏཝ ཤིཥྱཱཿ པྲཱཙཱཾ པརམྤརཱགཏཝཱཀྱཱནུསཱརེཎ ནཱཙརནྟོ྅པྲཀྵཱལིཏཀརཻཿ ཀུཏོ བྷུཛཾཏེ? ");
INSERT INTO santib_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ཏཏཿ ས པྲཏྱུཝཱཙ ཀཔཊིནོ ཡུཥྨཱན྄ ཨུདྡིཤྱ ཡིཤཡིཡབྷཝིཥྱདྭཱདཱི ཡུཀྟམཝཱདཱིཏ྄། ཡཐཱ སྭཀཱིཡཻརདྷརཻརེཏེ སམྨནྱནཏེ སདཻཝ མཱཾ། ཀིནྟུ མཏྟོ ཝིཔྲཀརྵེ སནྟི ཏེཥཱཾ མནཱཾསི ཙ། ");
INSERT INTO santib_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ཤིཀྵཡནྟོ བིདྷཱིན྄ ནྣཱཛྙཱ བྷཛནྟེ མཱཾ མུདྷཻཝ ཏེ། ");
INSERT INTO santib_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ཡཱུཡཾ ཛལཔཱཏྲཔཱནཔཱཏྲཱདཱིནི མཛྫཡནྟོ མནུཛཔརམྤརཱགཏཝཱཀྱཾ རཀྵཐ ཀིནྟུ ཨཱིཤྭརཱཛྙཱཾ ལཾགྷདྷྭེ; ཨཔརཱ ཨཱིདྲྀཤྱོནེཀཱཿ ཀྲིཡཱ ཨཔི ཀུརུདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ཨནྱཉྩཱཀཐཡཏ྄ ཡཱུཡཾ སྭཔརམྤརཱགཏཝཱཀྱསྱ རཀྵཱརྠཾ སྤཥྚརཱུཔེཎ ཨཱིཤྭརཱཛྙཱཾ ལོཔཡཐ། ");
INSERT INTO santib_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ཡཏོ མཱུསཱདྭཱརཱ པྲོཀྟམསྟི སྭཔིཏརཽ སམྨནྱདྷྭཾ ཡསྟུ མཱཏརཾ པིཏརཾ ཝཱ དུཪྻྭཱཀྱཾ ཝཀྟི ས ནིཏཱནྟཾ ཧནྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ཀིནྟུ མདཱིཡེན ཡེན དྲཝྱེཎ ཏཝོཔཀཱརོབྷཝཏ྄ ཏཏ྄ ཀརྦྦཱཎམརྠཱད྄ ཨཱིཤྭརཱཡ ནིཝེདིཏམ྄ ཨིདཾ ཝཱཀྱཾ ཡདི ཀོཔི པིཏརཾ མཱཏརཾ ཝཱ ཝཀྟི ");
INSERT INTO santib_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ཏརྷི ཡཱུཡཾ མཱཏུཿ པིཏུ ཪྻོཔཀཱརཾ ཀརྟྟཱཾ ཏཾ ཝཱརཡཐ། ");
INSERT INTO santib_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ཨིཏྠཾ སྭཔྲཙཱརིཏཔརམྤརཱགཏཝཱཀྱེན ཡཱུཡམ྄ ཨཱིཤྭརཱཛྙཱཾ མུདྷཱ ཝིདྷདྭྭེ, ཨཱིདྲྀཤཱནྱནྱཱནྱནེཀཱནི ཀརྨྨཱཎི ཀུརུདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ཨཐ ས ལོཀཱནཱཧཱུཡ བབྷཱཥེ ཡཱུཡཾ སཪྻྭེ མདྭཱཀྱཾ ཤྲྀཎུཏ བུདྷྱདྷྭཉྩ། ");
INSERT INTO santib_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","བཱཧྱཱདནྟརཾ པྲཝིཤྱ ནརམམེདྷྱཾ ཀརྟྟཱཾ ཤཀྣོཏི ཨཱིདྲྀཤཾ ཀིམཔི ཝསྟུ ནཱསྟི, ཝརམ྄ ཨནྟརཱད྄ བཧིརྒཏཾ ཡདྭསྟུ ཏནྨནུཛམ྄ ཨམེདྷྱཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ཡསྱ ཤྲོཏུཾ ཤྲོཏྲེ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ཏཏཿ ས ལོཀཱན྄ ཧིཏྭཱ གྲྀཧམདྷྱཾ པྲཝིཥྚསྟདཱ ཤིཥྱཱསྟདྲྀཥྚཱནྟཝཱཀྱཱརྠཾ པཔྲཙྪུཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ཏསྨཱཏ྄ ས ཏཱན྄ ཛགཱད ཡཱུཡམཔི ཀིམེཏཱདྲྀགབོདྷཱཿ? ཀིམཔི དྲཝྱཾ བཱཧྱཱདནྟརཾ པྲཝིཤྱ ནརམམེདྷྱཾ ཀརྟྟཱཾ ན ཤཀྣོཏི ཀཐཱམིམཱཾ ཀིཾ ན བུདྷྱདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ཏཏ྄ ཏདནྟརྣ པྲཝིཤཏི ཀིནྟུ ཀུཀྵིམདྷྱཾ པྲཝིཤཏི ཤེཥེ སཪྻྭབྷུཀྟཝསྟུགྲཱཧིཎི བཧིརྡེཤེ ནིཪྻཱཏི། ");
INSERT INTO santib_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ཨཔརམཔྱཝཱདཱིད྄ ཡནྣརཱནྣིརེཏི ཏདེཝ ནརམམེདྷྱཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ཡཏོ྅ནྟརཱད྄ ཨརྠཱན྄ མཱནཝཱནཱཾ མནོབྷྱཿ ཀུཙིནྟཱ པརསྟྲཱིཝེཤྱཱགམནཾ ");
INSERT INTO santib_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ནརཝདྷཤྩཽཪྻྱཾ ལོབྷོ དུཥྚཏཱ པྲཝཉྩནཱ ཀཱམུཀཏཱ ཀུདྲྀཥྚིརཱིཤྭརནིནྡཱ གཪྻྭསྟམ ཨིཏྱཱདཱིནི ནིརྒཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ཨེཏཱནི སཪྻྭཱཎི དུརིཏཱནྱནྟརཱདེཏྱ ནརམམེདྷྱཾ ཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ཨཐ ས ཨུཏྠཱཡ ཏཏྶྠཱནཱཏ྄ སོརསཱིདོནྤུརཔྲདེཤཾ ཛགཱམ ཏཏྲ ཀིམཔི ནིཝེཤནཾ པྲཝིཤྱ སཪྻྭཻརཛྙཱཏཿ སྠཱཏུཾ མཏིཉྩཀྲེ ཀིནྟུ གུཔྟཿ སྠཱཏུཾ ན ཤཤཱཀ། ");
INSERT INTO santib_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ཡཏཿ སུརཕཻནིཀཱིདེཤཱིཡཡཱུནཱནཱིཝཾཤོདྦྷཝསྟྲིཡཱཿ ཀནྱཱ བྷཱུཏགྲསྟཱསཱིཏ྄། སཱ སྟྲཱི ཏདྭཱརྟྟཱཾ པྲཱཔྱ ཏཏྶམཱིཔམཱགཏྱ ཏཙྩརཎཡོཿ པཏིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","སྭཀནྱཱཏོ བྷཱུཏཾ ནིརཱཀརྟྟཱཾ ཏསྨིན྄ ཝིནཡཾ ཀྲྀཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ཀིནྟུ ཡཱིཤུསྟཱམཝདཏ྄ པྲཐམཾ བཱལཀཱསྟྲྀཔྱནྟུ ཡཏོ བཱལཀཱནཱཾ ཁཱདྱཾ གྲྀཧཱིཏྭཱ ཀུཀྐུརེབྷྱོ ནིཀྵེཔོ྅ནུཙིཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ཏདཱ སཱ སྟྲཱི ཏམཝཱདཱིཏ྄ བྷོཿ པྲབྷོ ཏཏ྄ སཏྱཾ ཏཐཱཔི མཉྩཱདྷཿསྠཱཿ ཀུཀྐུརཱ བཱལཱནཱཾ ཀརཔཏིཏཱནི ཁཱདྱཁཎྜཱནི ཁཱདནྟི། ");
INSERT INTO santib_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ཏཏཿ སོ྅ཀཐཡད྄ ཨེཏཏྐཐཱཧེཏོཿ སཀུཤལཱ ཡཱཧི ཏཝ ཀནྱཱཾ ཏྱཀྟྭཱ བྷཱུཏོ གཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ཨཐ སཱ སྟྲཱི གྲྀཧཾ གཏྭཱ ཀནྱཱཾ བྷཱུཏཏྱཀྟཱཾ ཤཡྻཱསྠིཏཱཾ དདརྴ། ");
INSERT INTO santib_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","པུནཤྩ ས སོརསཱིདོནྤུརཔྲདེཤཱཏ྄ པྲསྠཱཡ དིཀཱཔལིདེཤསྱ པྲཱནྟརབྷཱགེན གཱལཱིལྫལདྷེཿ སམཱིཔཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ཏདཱ ལོཀཻརེཀཾ བདྷིརཾ ཀདྭདཉྩ ནརཾ ཏནྣིཀཊམཱནཱིཡ ཏསྱ གཱཏྲེ ཧསྟམརྤཡིཏུཾ ཝིནཡཿ ཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ཏཏོ ཡཱིཤུ རློཀཱརཎྱཱཏ྄ ཏཾ ནིརྫནམཱནཱིཡ ཏསྱ ཀརྞཡོངྒུལཱི རྡདཽ ནིཥྛཱིཝཾ དཏྟྭཱ ཙ ཏཛྫིཧྭཱཾ པསྤརྴ། ");
INSERT INTO santib_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ཨནནྟརཾ སྭརྒཾ ནིརཱིཀྵྱ དཱིརྒྷཾ ནིཤྭསྱ ཏམཝདཏ྄ ཨིཏཕཏཿ ཨརྠཱན྄ མུཀྟོ བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ཏཏསྟཏྐྵཎཾ ཏསྱ ཀརྞཽ མུཀྟཽ ཛིཧྭཱཡཱཤྩ ཛཱཌྱཱཔགམཱཏ྄ ས སུསྤཥྚཝཱཀྱམཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ཨཐ ས ཏཱན྄ ཝཱཌྷམིཏྱཱདིདེཤ ཡཱུཡམིམཱཾ ཀཐཱཾ ཀསྨཻཙིདཔི མཱ ཀཐཡཏ, ཀིནྟུ ས ཡཏི ནྱཥེདྷཏ྄ ཏེ ཏཏི བཱཧུལྱེན པྲཱཙཱརཡན྄; ");
INSERT INTO santib_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ཏེ྅ཏིཙམཏྐྲྀཏྱ པརསྤརཾ ཀཐཡཱམཱསུཿ ས བདྷིརཱཡ ཤྲཝཎཤཀྟིཾ མཱུཀཱཡ ཙ ཀཐནཤཀྟིཾ དཏྟྭཱ སཪྻྭཾ ཀརྨྨོཏྟམརཱུཔེཎ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ཏདཱ ཏཏྶམཱིཔཾ བཧཝོ ལོཀཱ ཨཱཡཱཏཱ ཨཏསྟེཥཱཾ བྷོཛྱདྲཝྱཱབྷཱཝཱད྄ ཡཱིཤུཿ ཤིཥྱཱནཱཧཱུཡ ཛགཱད,། ");
INSERT INTO santib_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ལོཀནིཝཧེ མམ ཀྲྀཔཱ ཛཱཡཏེ ཏེ དིནཏྲཡཾ མཡཱ སཱརྡྡྷཾ སནྟི ཏེཥཱཾ བྷོཛྱཾ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ཏེཥཱཾ མདྷྱེ྅ནེཀེ དཱུརཱད྄ ཨཱགཏཱཿ, ཨབྷུཀྟེཥུ ཏེཥུ མཡཱ སྭགྲྀཧམབྷིཔྲཧིཏེཥུ ཏེ པཐི ཀླམིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ཤིཥྱཱ ཨཝཱདིཥུཿ, ཨེཏཱཝཏོ ལོཀཱན྄ ཏརྤཡིཏུམ྄ ཨཏྲ པྲནྟརེ པཱུཔཱན྄ པྲཱཔྟུཾ ཀེན ཤཀྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ཏཏཿ ས ཏཱན྄ པཔྲཙྪ ཡུཥྨཱཀཾ ཀཏི པཱུཔཱཿ སནྟི? ཏེ྅ཀཐཡན྄ སཔྟ། ");
INSERT INTO santib_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ཏཏཿ ས ཏཱལློཀཱན྄ བྷུཝི སམུཔཝེཥྚུམ྄ ཨཱདིཤྱ ཏཱན྄ སཔྟ པཱུཔཱན྄ དྷྲྀཏྭཱ ཨཱིཤྭརགུཎཱན྄ ཨནུཀཱིརྟྟཡཱམཱས, བྷཾཀྟྭཱ པརིཝེཥཡིཏུཾ ཤིཥྱཱན྄ པྲཏི དདཽ, ཏཏསྟེ ལོཀེབྷྱཿ པརིཝེཥཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ཏཐཱ ཏེཥཱཾ སམཱིཔེ ཡེ ཀྵུདྲམཏྶྱཱ ཨཱསན྄ ཏཱནཔྱཱདཱཡ ཨཱིཤྭརགུཎཱན྄ སཾཀཱིརྟྱ པརིཝེཥཡིཏུམ྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ཏཏོ ལོཀཱ བྷུཀྟྭཱ ཏྲྀཔྟིཾ གཏཱ ཨཝཤིཥྚཁཱདྱཻཿ པཱུརྞཱཿ སཔྟཌལླཀཱ གྲྀཧཱིཏཱཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ཨེཏེ བྷོཀྟཱརཿ པྲཱཡཤྩཏུཿ སཧསྲཔུརུཥཱ ཨཱསན྄ ཏཏཿ ས ཏཱན྄ ཝིསསརྫ། ");
INSERT INTO santib_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ཨཐ ས ཤིཥྱཿ སཧ ནཱཝམཱརུཧྱ དལྨཱནཱུཐཱསཱིམཱམཱགཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ཏཏཿ པརཾ ཕིརཱུཤིན ཨཱགཏྱ ཏེན སཧ ཝིཝདམཱནཱསྟསྱ པརཱིཀྵཱརྠམ྄ ཨཱཀཱཤཱིཡཙིཧྣཾ དྲཥྚུཾ ཡཱཙིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ཏདཱ སོ྅ནྟརྡཱིརྒྷཾ ནིཤྭསྱཱཀཐཡཏ྄, ཨེཏེ ཝིདྱམཱནནརཱཿ ཀུཏཤྩིནྷཾ མྲྀགཡནྟེ? ཡུཥྨཱནཧཾ ཡཐཱརྠཾ བྲཝཱིམི ལོཀཱནེཏཱན྄ ཀིམཔི ཙིཧྣཾ ན དརྴཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ཨཐ ཏཱན྄ ཧིཏྭཱ པུན རྣཱཝམ྄ ཨཱརུཧྱ པཱརམགཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ཨེཏརྷི ཤིཥྱཻཿ པཱུཔེཥུ ཝིསྨྲྀཏེཥུ ནཱཝི ཏེཥཱཾ སནྣིདྷཽ པཱུཔ ཨེཀཨེཝ སྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ཏདཱནཱིཾ ཡཱིཤུསྟཱན྄ ཨཱདིཥྚཝཱན྄ ཕིརཱུཤིནཱཾ ཧེརོདཤྩ ཀིཎྭཾ པྲཏི སཏརྐཱཿ སཱཝདྷཱནཱཤྩ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ཏཏསྟེ྅ནྱོནྱཾ ཝིཝེཙནཾ ཀརྟུམ྄ ཨཱརེབྷིརེ, ཨསྨཱཀཾ སནྣིདྷཽ པཱུཔོ ནཱསྟཱིཏི ཧེཏོརིདཾ ཀཐཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ཏད྄ བུདྭྭཱ ཡཱིཤུསྟེབྷྱོ྅ཀཐཡཏ྄ ཡུཥྨཱཀཾ སྠཱནེ པཱུཔཱབྷཱཝཱཏ྄ ཀུཏ ཨིཏྠཾ ཝིཏརྐཡཐ? ཡཱུཡཾ ཀིམདྱཱཔི ཀིམཔི ན ཛཱནཱིཐ? བོདྡྷུཉྩ ན ཤཀྣུཐ? ཡཱཝདདྱ ཀིཾ ཡུཥྨཱཀཾ མནཱཾསི ཀཋིནཱནི སནྟི? ");
INSERT INTO santib_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","སཏྶུ ནེཏྲེཥུ ཀིཾ ན པཤྱཐ? སཏྶུ ཀརྞེཥུ ཀིཾ ན ཤྲྀཎུཐ? ན སྨརཐ ཙ? ");
INSERT INTO santib_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ཡདཱཧཾ པཉྩཔཱུཔཱན྄ པཉྩསཧསྲཱཎཱཾ པུརུཥཱཎཱཾ མདྷྱེ བྷཾཀྟྭཱ དཏྟཝཱན྄ ཏདཱནཱིཾ ཡཱུཡམ྄ ཨཝཤིཥྚཔཱུཔཻཿ པཱུརྞཱན྄ ཀཏི ཌལླཀཱན྄ གྲྀཧཱིཏཝནྟཿ? ཏེ྅ཀཐཡན྄ དྭཱདཤཌལླཀཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ཨཔརཉྩ ཡདཱ ཙཏུཿསཧསྲཱཎཱཾ པུརུཥཱཎཱཾ མདྷྱེ པཱུཔཱན྄ བྷཾཀྟྭཱདདཱཾ ཏདཱ ཡཱུཡམ྄ ཨཏིརིཀྟཔཱུཔཱནཱཾ ཀཏི ཌལླཀཱན྄ གྲྀཧཱིཏཝནྟཿ? ཏེ ཀཐཡཱམཱསུཿ སཔྟཌལླཀཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ཏདཱ ས ཀཐིཏཝཱན྄ ཏརྷི ཡཱུཡམ྄ ཨདྷུནཱཔི ཀུཏོ བོདྭྭུཾ ན ཤཀྣུཐ? ");
INSERT INTO santib_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ཨནནྟརཾ ཏསྨིན྄ བཻཏྶཻདཱནགརེ པྲཱཔྟེ ལོཀཱ ཨནྡྷམེཀཾ ནརཾ ཏཏྶམཱིཔམཱནཱིཡ ཏཾ སྤྲཥྚུཾ ཏཾ པྲཱརྠཡཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ཏདཱ ཏསྱཱནྡྷསྱ ཀརཽ གྲྀཧཱིཏྭཱ ནགརཱད྄ བཧིརྡེཤཾ ཏཾ ནཱིཏཝཱན྄; ཏནྣེཏྲེ ནིཥྛཱིཝཾ དཏྟྭཱ ཏདྒཱཏྲེ ཧསྟཱཝརྤཡིཏྭཱ ཏཾ པཔྲཙྪ, ཀིམཔི པཤྱསི? ");
INSERT INTO santib_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ས ནེཏྲེ ཨུནྨཱིལྱ ཛགཱད, ཝྲྀཀྵཝཏ྄ མནུཛཱན྄ གཙྪཏོ ནིརཱིཀྵེ། ");
INSERT INTO santib_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ཏཏོ ཡཱིཤུཿ པུནསྟསྱ ནཡནཡོ རྷསྟཱཝརྤཡིཏྭཱ ཏསྱ ནེཏྲེ ཨུནྨཱིལཡཱམཱས; ཏསྨཱཏ྄ ས སྭསྠོ བྷཱུཏྭཱ སྤཥྚརཱུཔཾ སཪྻྭལོཀཱན྄ དདརྴ། ");
INSERT INTO santib_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ཏཏཿ པརཾ ཏྭཾ གྲཱམཾ མཱ གཙྪ གྲཱམསྠཾ ཀམཔི ཙ ཀིམཔྱནུཀྟྭཱ ནིཛགྲྀཧཾ ཡཱཧཱིཏྱཱདིཤྱ ཡཱིཤུསྟཾ ནིཛགྲྀཧཾ པྲཧིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ཨནནྟརཾ ཤིཥྱཻཿ སཧིཏོ ཡཱིཤུཿ ཀཻསརཱིཡཱཕིལིཔིཔུརཾ ཛགཱམ, པཐི གཙྪན྄ ཏཱནཔྲྀཙྪཏ྄ ཀོ྅ཧམ྄ ཨཏྲ ལོཀཱཿ ཀིཾ ཝདནྟི? ");
INSERT INTO santib_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ཏེ པྲཏྱཱུཙུཿ ཏྭཱཾ ཡོཧནཾ མཛྫཀཾ ཝདནྟི ཀིནྟུ ཀེཔི ཀེཔི ཨེལིཡཾ ཝདནྟི; ཨཔརེ ཀེཔི ཀེཔི བྷཝིཥྱདྭཱདིནཱམ྄ ཨེཀོ ཛན ཨིཏི ཝདནྟི། ");
INSERT INTO santib_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ཨཐ ས ཏཱནཔྲྀཙྪཏ྄ ཀིནྟུ ཀོཧམ྄? ཨིཏྱཏྲ ཡཱུཡཾ ཀིཾ ཝདཐ? ཏདཱ པིཏརཿ པྲཏྱཝདཏ྄ བྷཝཱན྄ ཨབྷིཥིཀྟསྟྲཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ཏཏཿ ས ཏཱན྄ གཱཌྷམཱདིཤད྄ ཡཱུཡཾ མམ ཀཐཱ ཀསྨཻཙིདཔི མཱ ཀཐཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","མནུཥྱཔུཏྲེཎཱཝཤྱཾ བཧཝོ ཡཱཏནཱ བྷོཀྟཝྱཱཿ པྲཱཙཱིནལོཀཻཿ པྲདྷཱནཡཱཛཀཻརདྷྱཱཔཀཻཤྩ ས ནིནྡིཏཿ སན྄ གྷཱཏཡིཥྱཏེ ཏྲྀཏཱིཡདིནེ ཨུཏྠཱསྱཏི ཙ, ཡཱིཤུཿ ཤིཥྱཱནུཔདེཥྚུམཱརབྷྱ ཀཐཱམིམཱཾ སྤཥྚམཱཙཥྚ། ");
INSERT INTO santib_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ཏསྨཱཏ྄ པིཏརསྟསྱ ཧསྟཽ དྷྲྀཏྭཱ ཏཾ ཏརྫྫིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ཀིནྟུ ས མུཁཾ པརཱཝརྟྱ ཤིཥྱགཎཾ ནིརཱིཀྵྱ པིཏརཾ ཏརྫཡིཏྭཱཝཱདཱིད྄ དཱུརཱིབྷཝ ཝིགྷྣཀཱརིན྄ ཨཱིཤྭརཱིཡཀཱཪྻྱཱདཔི མནུཥྱཀཱཪྻྱཾ ཏུབྷྱཾ རོཙཏཏརཱཾ། ");
INSERT INTO santib_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ཨཐ ས ལོཀཱན྄ ཤིཥྱཱཾཤྩཱཧཱུཡ ཛགཱད ཡཿ ཀཤྩིན྄ མཱམནུགནྟུམ྄ ཨིཙྪཏི ས ཨཱཏྨཱནཾ དཱམྱཏུ, སྭཀྲུཤཾ གྲྀཧཱིཏྭཱ མཏྤཤྩཱད྄ ཨཱཡཱཏུ། ");
INSERT INTO santib_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ཡཏོ ཡཿ ཀཤྩིཏ྄ སྭཔྲཱཎཾ རཀྵིཏུམིཙྪཏི ས ཏཾ ཧཱརཡིཥྱཏི, ཀིནྟུ ཡཿ ཀཤྩིན྄ མདརྠཾ སུསཾཝཱདཱརྠཉྩ པྲཱཎཾ ཧཱརཡཏི ས ཏཾ རཀྵིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ཨཔརཉྩ མནུཛཿ སཪྻྭཾ ཛགཏ྄ པྲཱཔྱ ཡདི སྭཔྲཱཎཾ ཧཱརཡཏི ཏརྷི ཏསྱ ཀོ ལཱབྷཿ? ");
INSERT INTO santib_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ནརཿ སྭཔྲཱཎཝིནིམཡེན ཀིཾ དཱཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ཨེཏེཥཱཾ ཝྱབྷིཙཱརིཎཱཾ པཱཔིནཱཉྩ ལོཀཱནཱཾ སཱཀྵཱད྄ ཡདི ཀོཔི མཱཾ མཏྐཐཱཉྩ ལཛྫཱསྤདཾ ཛཱནཱཏི ཏརྷི མནུཛཔུཏྲོ ཡདཱ དྷརྨྨདཱུཏཻཿ སཧ པིཏུཿ པྲབྷཱཝེཎཱགམིཥྱཏི ཏདཱ སོཔི ཏཾ ལཛྫཱསྤདཾ ཛྙཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ཨཐ ས ཏཱནཝཱདཱིཏ྄ ཡུཥྨབྷྱམཧཾ ཡཐཱརྠཾ ཀཐཡཱམི, ཨཱིཤྭརརཱཛྱཾ པརཱཀྲམེཎོཔསྠིཏཾ ན དྲྀཥྚྭཱ མྲྀཏྱུཾ ནཱསྭཱདིཥྱནྟེ, ཨཏྲ དཎྜཱཡམཱནཱནཱཾ མདྷྱེཔི ཏཱདྲྀཤཱ ལོཀཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ཨཐ ཥཌྡིནེབྷྱཿ པརཾ ཡཱིཤུཿ པིཏརཾ ཡཱཀཱུབཾ ཡོཧནཉྩ གྲྀཧཱིཏྭཱ གིརེརུཙྩསྱ ནིརྫནསྠཱནཾ གཏྭཱ ཏེཥཱཾ པྲཏྱཀྵེ མཱུརྟྱནྟརཾ དདྷཱར། ");
INSERT INTO santib_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ཏཏསྟསྱ པརིདྷེཡམ྄ ཨཱིདྲྀཤམ྄ ཨུཛྫྭལཧིམཔཱཎཌརཾ ཛཱཏཾ ཡད྄ ཛགཏི ཀོཔི རཛཀོ ན ཏཱདྲྀཀ྄ པཱཎཌརཾ ཀརྟྟཱཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ཨཔརཉྩ ཨེལིཡོ མཱུསཱཤྩ ཏེབྷྱོ དརྴནཾ དཏྟྭཱ ཡཱིཤུནཱ སཧ ཀཐནཾ ཀརྟྟུམཱརེབྷཱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ཏདཱ པིཏརོ ཡཱིཤུམཝཱདཱིཏ྄ ཧེ གུརོ྅སྨཱཀམཏྲ སྠིཏིརུཏྟམཱ, ཏཏཨེཝ ཝཡཾ ཏྭཏྐྲྀཏེ ཨེཀཱཾ མཱུསཱཀྲྀཏེ ཨེཀཱམ྄ ཨེལིཡཀྲྀཏེ ཙཻཀཱཾ, ཨེཏཱསྟིསྲཿ ཀུཊཱི རྣིརྨྨཱམ། ");
INSERT INTO santib_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ཀིནྟུ ས ཡདུཀྟཝཱན྄ ཏཏ྄ སྭཡཾ ན བུབུདྷེ ཏཏཿ སཪྻྭེ བིབྷཡཱཉྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ཨེཏརྷི པཡོདསྟཱན྄ ཚཱདཡཱམཱས, མམཡཱཾ པྲིཡཿ པུཏྲཿ ཀཐཱསུ ཏསྱ མནཱཾསི ནིཝེཤཡཏེཏི ནབྷོཝཱཎཱི ཏནྨེདྱཱནྣིཪྻཡཽ། ");
INSERT INTO santib_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ཨཐ ཧཋཱཏྟེ ཙཏུརྡིཤོ དྲྀཥྚྭཱ ཡཱིཤུཾ ཝིནཱ སྭཻཿ སཧིཏཾ ཀམཔི ན དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ཏཏཿ པརཾ གིརེརཝརོཧཎཀཱལེ ས ཏཱན྄ གཱཌྷམ྄ དཱུཏྱཱདིདེཤ ཡཱཝནྣརསཱུནོཿ ཤྨཤཱནཱདུཏྠཱནཾ ན བྷཝཏི, ཏཱཝཏ྄ དརྴནསྱཱསྱ ཝཱརྟྟཱ ཡུཥྨཱབྷིཿ ཀསྨཻཙིདཔི ན ཝཀྟཝྱཱ། ");
INSERT INTO santib_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ཏདཱ ཤྨཤཱནཱདུཏྠཱནསྱ ཀོབྷིཔྲཱཡ ཨིཏི ཝིཙཱཪྻྱ ཏེ ཏདྭཱཀྱཾ སྭེཥུ གོཔཱཡཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ཨཐ ཏེ ཡཱིཤུཾ པཔྲཙྪུཿ པྲཐམཏ ཨེལིཡེནཱགནྟཝྱམ྄ ཨིཏི ཝཱཀྱཾ ཀུཏ ཨུཔཱདྷྱཱཡཱ ཨཱཧུཿ? ");
INSERT INTO santib_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ཏདཱ ས པྲཏྱུཝཱཙ , ཨེལིཡཿ པྲཐམམེཏྱ སཪྻྭཀཱཪྻྱཱཎི སཱདྷཡིཥྱཏི; ནརཔུཏྲེ ཙ ལིཔི ཪྻཐཱསྟེ ཏཐཻཝ སོཔི བཧུདུཿཁཾ པྲཱཔྱཱཝཛྙཱསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ཀིནྟྭཧཾ ཡུཥྨཱན྄ ཝདཱམི , ཨེལིཡཱརྠེ ལིཔི ཪྻཐཱསྟེ ཏཐཻཝ ས ཨེཏྱ ཡཡཽ, ལོཀཱ: སྭེཙྪཱནུརཱུཔཾ ཏམབྷིཝྱཝཧརནྟི སྨ། ");
INSERT INTO santib_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ཨནནྟརཾ ས ཤིཥྱསམཱིཔམེཏྱ ཏེཥཱཾ ཙཏུཿཔཱརྴྭེ ཏཻཿ སཧ བཧུཛནཱན྄ ཝིཝདམཱནཱན྄ ཨདྷྱཱཔཀཱཾཤྩ དྲྀཥྚཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ཀིནྟུ སཪྻྭལོཀཱསྟཾ དྲྀཥྚྭཻཝ ཙམཏྐྲྀཏྱ ཏདཱསནྣཾ དྷཱཝནྟསྟཾ པྲཎེམུཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ཏདཱ ཡཱིཤུརདྷྱཱཔཀཱནཔྲཱཀྵཱིད྄ ཨེཏཻཿ སཧ ཡཱུཡཾ ཀིཾ ཝིཝདདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ཏཏོ ལོཀཱནཱཾ ཀཤྩིདེཀཿ པྲཏྱཝཱདཱིཏ྄ ཧེ གུརོ མམ སཱུནུཾ མཱུཀཾ བྷཱུཏདྷྲྀཏཉྩ བྷཝདཱསནྣམ྄ ཨཱནཡཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ཡདཱསཽ བྷཱུཏསྟམཱཀྲམཏེ ཏདཻཝ པཱཏསཏི ཏཐཱ ས ཕེཎཱཡཏེ, དནྟཻརྡནྟཱན྄ གྷརྵཏི ཀྵཱིཎོ བྷཝཏི ཙ; ཏཏོ ཧེཏོསྟཾ བྷཱུཏཾ ཏྱཱཛཡིཏུཾ བྷཝཙྪིཥྱཱན྄ ནིཝེདིཏཝཱན྄ ཀིནྟུ ཏེ ན ཤེཀུཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ཏདཱ ས ཏམཝཱདཱིཏ྄, རེ ཨཝིཤྭཱསིནཿ སནྟཱནཱ ཡུཥྨཱབྷིཿ སཧ ཀཏི ཀཱལཱནཧཾ སྠཱསྱཱམི? ཨཔརཱན྄ ཀཏི ཀཱལཱན྄ ཝཱ ཝ ཨཱཙཱརཱན྄ སཧིཥྱེ? ཏཾ མདཱསནྣམཱནཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ཏཏསྟཏྶནྣིདྷིཾ ས ཨཱནཱིཡཏ ཀིནྟུ ཏཾ དྲྀཥྚྭཻཝ བྷཱུཏོ བཱལཀཾ དྷྲྀཏཝཱན྄; ས ཙ བྷཱུམཽ པཏིཏྭཱ ཕེཎཱཡམཱནོ ལུལོཋ། ");
INSERT INTO santib_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ཏདཱ ས ཏཏྤིཏརཾ པཔྲཙྪ, ཨསྱེདྲྀཤཱི དཤཱ ཀཏི དིནཱནི བྷཱུཏཱ? ཏཏཿ སོཝཱདཱིཏ྄ བཱལྱཀཱལཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","བྷཱུཏོཡཾ ཏཾ ནཱཤཡིཏུཾ བཧུཝཱརཱན྄ ཝཧྣཽ ཛལེ ཙ ནྱཀྵིཔཏ྄ ཀིནྟུ ཡདི བྷཝཱན ཀིམཔི ཀརྟྟཱཾ ཤཀྣོཏི ཏརྷི དཡཱཾ ཀྲྀཏྭཱསྨཱན྄ ཨུཔཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ཏདཱ ཡཱིཤུསྟམཝདཏ྄ ཡདི པྲཏྱེཏུཾ ཤཀྣོཥི ཏརྷི པྲཏྱཡིནེ ཛནཱཡ སཪྻྭཾ སཱདྷྱམ྄། ");
INSERT INTO santib_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ཏཏསྟཏྐྵཎཾ ཏདྦཱལཀསྱ པིཏཱ པྲོཙྩཻ རཱུཝན྄ སཱཤྲུནེཏྲཿ པྲོཝཱཙ, པྲབྷོ པྲཏྱེམི མམཱཔྲཏྱཡཾ པྲཏིཀུརུ། ");
INSERT INTO santib_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ཨཐ ཡཱིཤུ རློཀསངྒྷཾ དྷཱཝིཏྭཱཡཱནྟཾ དྲྀཥྚྭཱ ཏམཔཱུཏབྷཱུཏཾ ཏརྫཡིཏྭཱ ཛགཱད, རེ བདྷིར མཱུཀ བྷཱུཏ ཏྭམེཏསྨཱད྄ བཧིརྦྷཝ པུནཿ ཀདཱཔི མཱཤྲཡཻནཾ ཏྭཱམཧམ྄ ཨིཏྱཱདིཤཱམི། ");
INSERT INTO santib_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ཏདཱ ས བྷཱུཏཤྩཱིཏྴབྡཾ ཀྲྀཏྭཱ ཏམཱཔཱིཌྱ བཧིརྫཛཱམ, ཏཏོ བཱལཀོ མྲྀཏཀལྤོ བབྷཱུཝ ཏསྨཱདཡཾ མྲྀཏཨིཏྱནེཀེ ཀཐཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ཀིནྟུ ཀརཾ དྷྲྀཏྭཱ ཡཱིཤུནོཏྠཱཔིཏཿ ས ཨུཏྟསྠཽ། ");
INSERT INTO santib_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ཨཐ ཡཱིཤཽ གྲྀཧཾ པྲཝིཥྚེ ཤིཥྱཱ གུཔྟཾ ཏཾ པཔྲཙྪུཿ, ཝཡམེནཾ བྷཱུཏཾ ཏྱཱཛཡིཏུཾ ཀུཏོ ན ཤཀྟཱཿ? ");
INSERT INTO santib_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ས ཨུཝཱཙ, པྲཱརྠནོཔཝཱསཽ ཝིནཱ ཀེནཱཔྱནྱེན ཀརྨྨཎཱ བྷཱུཏམཱིདྲྀཤཾ ཏྱཱཛཡིཏུཾ ན ཤཀྱཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ཨནནྟརཾ ས ཏཏྶྠཱནཱདིཏྭཱ གཱལཱིལྨདྷྱེན ཡཡཽ, ཀིནྟུ ཏཏ྄ ཀོཔི ཛཱནཱིཡཱདིཏི ས ནཻཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ཨཔརཉྩ ས ཤིཥྱཱནུཔདིཤན྄ བབྷཱཥེ, ནརཔུཏྲོ ནརཧསྟེཥུ སམརྤཡིཥྱཏེ ཏེ ཙ ཏཾ ཧནིཥྱནྟི ཏཻསྟསྨིན྄ ཧཏེ ཏྲྀཏཱིཡདིནེ ས ཨུཏྠཱསྱཏཱིཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ཀིནྟུ ཏཏྐཐཱཾ ཏེ ནཱབུདྷྱནྟ པྲཥྚུཉྩ བིབྷྱཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ཨཐ ཡཱིཤུཿ ཀཕརྣཱཧཱུམྤུརམཱགཏྱ མདྷྱེགྲྀཧཉྩེཏྱ ཏཱནཔྲྀཙྪད྄ ཝརྟྨམདྷྱེ ཡཱུཡམནྱོནྱཾ ཀིཾ ཝིཝདདྷྭེ སྨ? ");
INSERT INTO santib_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ཀིནྟུ ཏེ ནིརུཏྟརཱསྟསྠུ ཪྻསྨཱཏྟེཥཱཾ ཀོ མུཁྱ ཨིཏི ཝརྟྨཱནི ཏེ྅ནྱོནྱཾ ཝྱཝདནྟ། ");
INSERT INTO santib_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ཏཏཿ ས ཨུཔཝིཤྱ དྭཱདཤཤིཥྱཱན྄ ཨཱཧཱུཡ བབྷཱཥེ ཡཿ ཀཤྩིཏ྄ མུཁྱོ བྷཝིཏུམིཙྪཏི ས སཪྻྭེབྷྱོ གཽཎཿ སཪྻྭེཥཱཾ སེཝཀཤྩ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ཏདཱ ས བཱལཀམེཀཾ གྲྀཧཱིཏྭཱ མདྷྱེ སམུཔཱཝེཤཡཏ྄ ཏཏསྟཾ ཀྲོཌེ ཀྲྀཏྭཱ ཏཱནཝཱདཱཏ྄ ");
INSERT INTO santib_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ཡཿ ཀཤྩིདཱིདྲྀཤསྱ ཀསྱཱཔི བཱལསྱཱཏིཐྱཾ ཀརོཏི ས མམཱཏིཐྱཾ ཀརོཏི; ཡཿ ཀཤྩིནྨམཱཏིཐྱཾ ཀརོཏི ས ཀེཝལམ྄ མམཱཏིཐྱཾ ཀརོཏི ཏནྣ མཏྤྲེརཀསྱཱཔྱཱཏིཐྱཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ཨཐ ཡོཧན྄ ཏམབྲཝཱིཏ྄ ཧེ གུརོ, ཨསྨཱཀམནནུགཱམིནམ྄ ཨེཀཾ ཏྭཱནྣཱམྣཱ བྷཱུཏཱན྄ ཏྱཱཛཡནྟཾ ཝཡཾ དྲྀཥྚཝནྟཿ, ཨསྨཱཀམཔཤྩཱདྒཱམིཏྭཱཙྩ ཏཾ ནྱཥེདྷཱམ། ");
INSERT INTO santib_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ཀིནྟུ ཡཱིཤུརཝདཏ྄ ཏཾ མཱ ནིཥེདྷཏ྄, ཡཏོ ཡཿ ཀཤྩིན྄ མནྣཱམྣཱ ཙིཏྲཾ ཀརྨྨ ཀརོཏི ས སཧསཱ མཱཾ ནིནྡིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ཏཐཱ ཡཿ ཀཤྩིད྄ ཡུཥྨཱཀཾ ཝིཔཀྵཏཱཾ ན ཀརོཏི ས ཡུཥྨཱཀམེཝ སཔཀྵཿ། ");
INSERT INTO santib_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ཡཿ ཀཤྩིད྄ ཡུཥྨཱན྄ ཁྲཱིཥྚཤིཥྱཱན྄ ཛྙཱཏྭཱ མནྣཱམྣཱ ཀཾསཻཀེན པཱནཱིཡཾ པཱཏུཾ དདཱཏི, ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝཙྨི, ས ཕལེན ཝཉྩིཏོ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ཀིནྟུ ཡདི ཀཤྩིན྄ མཡི ཝིཤྭཱསིནཱམེཥཱཾ ཀྵུདྲཔྲཱཎིནཱམ྄ ཨེཀསྱཱཔི ཝིགྷྣཾ ཛནཡཏི, ཏརྷི ཏསྱཻཏཏྐརྨྨ ཀརཎཱཏ྄ ཀཎྛབདྡྷཔེཥཎཱིཀསྱ ཏསྱ སཱགརཱགཱདྷཛལ མཛྫནཾ བྷདྲཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ཨཏཿ སྭཀརོ ཡདི ཏྭཱཾ བཱདྷཏེ ཏརྷི ཏཾ ཚིནྡྷི; ");
INSERT INTO santib_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ཡསྨཱཏ྄ ཡཏྲ ཀཱིཊཱ ན མྲིཡནྟེ ཝཧྣིཤྩ ན ནིཪྻྭཱཏི, ཏསྨིན྄ ཨནིཪྻྭཱཎཱནལནརཀེ ཀརདྭཡཝསྟཝ གམནཱཏ྄ ཀརཧཱིནསྱ སྭརྒཔྲཝེཤསྟཝ ཀྵེམཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ཡདི ཏཝ པཱདོ ཝིགྷྣཾ ཛནཡཏི ཏརྷི ཏཾ ཚིནྡྷི, ");
INSERT INTO santib_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ཡཏོ ཡཏྲ ཀཱིཊཱ ན མྲིཡནྟེ ཝཧྣིཤྩ ན ནིཪྻྭཱཏི, ཏསྨིན྄ ྅ནིཪྻྭཱཎཝཧྣཽ ནརཀེ དྭིཔཱདཝཏསྟཝ ནིཀྵེཔཱཏ྄ པཱདཧཱིནསྱ སྭརྒཔྲཝེཤསྟཝ ཀྵེམཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","སྭནེཏྲཾ ཡདི ཏྭཱཾ བཱདྷཏེ ཏརྷི ཏདཔྱུཏྤཱཊཡ, ཡཏོ ཡཏྲ ཀཱིཊཱ ན མྲིཡནྟེ ཝཧྣིཤྩ ན ནིཪྻྭཱཏི, ");
INSERT INTO santib_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ཏསྨིན ྅ནིཪྻྭཱཎཝཧྣཽ ནརཀེ དྭིནེཏྲསྱ ཏཝ ནིཀྵེཔཱད྄ ཨེཀནེཏྲཝཏ ཨཱིཤྭརརཱཛྱེ པྲཝེཤསྟཝ ཀྵེམཾ། ");
INSERT INTO santib_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ཡཐཱ སཪྻྭོ བལི རླཝཎཱཀྟཿ ཀྲིཡཏེ ཏཐཱ སཪྻྭོ ཛནོ ཝཧྣིརཱུཔེཎ ལཝཎཱཀྟཿ ཀཱརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ལཝཎཾ བྷདྲཾ ཀིནྟུ ཡདི ལཝཎེ སྭཱདུཏཱ ན ཏིཥྛཏི, ཏརྷི ཀཐམ྄ ཨཱསྭཱདྱུཀྟཾ ཀརིཥྱཐ? ཡཱུཡཾ ལཝཎཡུཀྟཱ བྷཝཏ པརསྤརཾ པྲེམ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ཨནནྟརཾ ས ཏཏྶྠཱནཱཏ྄ པྲསྠཱཡ ཡརྡྡནནདྱཱཿ པཱརེ ཡིཧཱུདཱཔྲདེཤ ཨུཔསྠིཏཝཱན྄, ཏཏྲ ཏདནྟིཀེ ལོཀཱནཱཾ སམཱགམེ ཛཱཏེ ས ནིཛརཱིཏྱནུསཱརེཎ པུནསྟཱན྄ ཨུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ཏདཱ ཕིརཱུཤིནསྟཏྶམཱིཔམ྄ ཨེཏྱ ཏཾ པརཱིཀྵིཏུཾ པཔྲཙྪཿ སྭཛཱཡཱ མནུཛཱནཱཾ ཏྱཛྱཱ ན ཝེཏི? ");
INSERT INTO santib_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ཏཏཿ ས པྲཏྱཝཱདཱིཏ྄, ཨཏྲ ཀཱཪྻྱེ མཱུསཱ ཡུཥྨཱན྄ པྲཏི ཀིམཱཛྙཱཔཡཏ྄? ");
INSERT INTO santib_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ཏ ཨཱུཙུཿ ཏྱཱགཔཏྲཾ ལེཁིཏུཾ སྭཔཏྣཱིཾ ཏྱཀྟུཉྩ མཱུསཱ྅ནུམནྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ཏདཱ ཡཱིཤུཿ པྲཏྱུཝཱཙ, ཡུཥྨཱཀཾ མནསཱཾ ཀཱཋིནྱཱདྡྷེཏོ རྨཱུསཱ ནིདེཤམིམམ྄ ཨལིཁཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ཀིནྟུ སྲྀཥྚེརཱདཽ ཨཱིཤྭརོ ནརཱན྄ པུཾརཱུཔེཎ སྟྲཱིརཱུཔེཎ ཙ སསརྫ། ");
INSERT INTO santib_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ཏཏཿ ཀཱརཎཱཏ྄ པུམཱན྄ པིཏརཾ མཱཏརཉྩ ཏྱཀྟྭཱ སྭཛཱཡཱཡཱམ྄ ཨཱསཀྟོ བྷཝིཥྱཏི, ");
INSERT INTO santib_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ཏཽ དྭཱཝ྄ ཨེཀཱངྒཽ བྷཝིཥྱཏཿ། \" ཏསྨཱཏ྄ ཏཏྐཱལམཱརབྷྱ ཏཽ ན དྭཱཝ྄ ཨེཀཱངྒཽ། ");
INSERT INTO santib_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ཨཏཿ ཀཱརཎཱད྄ ཨཱིཤྭརོ ཡདཡོཛཡཏ྄ ཀོཔི ནརསྟནྣ ཝིཡེཛཡེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ཨཐ ཡཱིཤུ རྒྲྀཧཾ པྲཝིཥྚསྟདཱ ཤིཥྱཱཿ པུནསྟཏྐཐཱཾ ཏཾ པཔྲཙྪུཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ཏཏཿ སོཝདཏ྄ ཀཤྩིད྄ ཡདི སྭབྷཱཪྻྱཱཾ ཏྱཀྟཝཱནྱཱམ྄ ཨུདྭཧཏི ཏརྷི ས སྭབྷཱཪྻྱཱཡཱཿ པྲཱཏིཀཱུལྱེན ཝྱབྷིཙཱརཱི བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ཀཱཙིནྣཱརཱི ཡདི སྭཔཏིཾ ཧིཏྭཱནྱཔུཾསཱ ཝིཝཱཧིཏཱ བྷཝཏི ཏརྷི སཱཔི ཝྱབྷིཙཱརིཎཱི བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ཨཐ ས ཡཐཱ ཤིཤཱུན྄ སྤྲྀཤེཏ྄, ཏདརྠཾ ལོཀཻསྟདནྟིཀཾ ཤིཤཝ ཨཱནཱིཡནྟ, ཀིནྟུ ཤིཥྱཱསྟཱནཱནཱིཏཝཏསྟརྫཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ཡཱིཤུསྟད྄ དྲྀཥྚྭཱ ཀྲུདྷྱན྄ ཛགཱད, མནྣིཀཊམ྄ ཨཱགནྟུཾ ཤིཤཱུན྄ མཱ ཝཱརཡཏ, ཡཏ ཨེཏཱདྲྀཤཱ ཨཱིཤྭརརཱཛྱཱདྷིཀཱརིཎཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝཙྨི, ཡཿ ཀཤྩིཏ྄ ཤིཤུཝད྄ བྷཱུཏྭཱ རཱཛྱམཱིཤྭརསྱ ན གྲྀཧླཱིཡཱཏ྄ ས ཀདཱཔི ཏདྲཱཛྱཾ པྲཝེཥྚུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ཨནནཏརཾ ས ཤིཤཱུནངྐེ ནིདྷཱཡ ཏེཥཱཾ གཱཏྲེཥུ ཧསྟཽ དཏྟྭཱཤིཥཾ བབྷཱཥེ། ");
INSERT INTO santib_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ཨཐ ས ཝརྟྨནཱ ཡཱཏི, ཨེཏརྷི ཛན ཨེཀོ དྷཱཝན྄ ཨཱགཏྱ ཏཏྶམྨུཁེ ཛཱནུནཱི པཱཏཡིཏྭཱ པྲྀཥྚཝཱན྄, བྷོཿ པརམགུརོ, ཨནནྟཱཡུཿ པྲཱཔྟཡེ མཡཱ ཀིཾ ཀརྟྟཝྱཾ? ");
INSERT INTO santib_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ཏདཱ ཡཱིཤུརུཝཱཙ, མཱཾ པརམཾ ཀུཏོ ཝདསི? ཝིནེཤྭརཾ ཀོཔི པརམོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","པརསྟྲཱིཾ ནཱབྷིགཙྪ; ནརཾ མཱ གྷཱཏཡ; སྟེཡཾ མཱ ཀུརུ; མྲྀཥཱསཱཀྵྱཾ མཱ དེཧི; ཧིཾསཱཉྩ མཱ ཀུརུ; པིཏརཽ སམྨནྱསྭ; ནིདེཤཱ ཨེཏེ ཏྭཡཱ ཛྙཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ཏཏསྟན པྲཏྱུཀྟཾ, ཧེ གུརོ བཱལྱཀཱལཱདཧཾ སཪྻྭཱནེཏཱན྄ ཨཱཙརཱམི། ");
INSERT INTO santib_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ཏདཱ ཡཱིཤུསྟཾ ཝིལོཀྱ སྣེཧེན བབྷཱཥེ, ཏཝཻཀསྱཱབྷཱཝ ཨཱསྟེ; ཏྭཾ གཏྭཱ སཪྻྭསྭཾ ཝིཀྲཱིཡ དརིདྲེབྷྱོ ཝིཤྲཱཎཡ, ཏཏཿ སྭརྒེ དྷནཾ པྲཱཔྶྱསི; ཏཏཿ པརམ྄ ཨེཏྱ ཀྲུཤཾ ཝཧན྄ མདནུཝརྟྟཱི བྷཝ། ");
INSERT INTO santib_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ཀིནྟུ ཏསྱ བཧུསམྤདྭིདྱམཱནཏྭཱཏ྄ ས ཨིམཱཾ ཀཐཱམཱཀརྞྱ ཝིཥཎོ དུཿཁིཏཤྩ སན྄ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ཨཐ ཡཱིཤུཤྩཏུརྡིཤོ ནིརཱིཀྵྱ ཤིཥྱཱན྄ ཨཝཱདཱིཏ྄, དྷནིལོཀཱནཱམ྄ ཨཱིཤྭརརཱཛྱཔྲཝེཤཿ ཀཱིདྲྀག྄ དུཥྐརཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ཏསྱ ཀཐཱཏཿ ཤིཥྱཱཤྩམཙྩཀྲུཿ, ཀིནྟུ ས པུནརཝདཏ྄, ཧེ བཱལཀཱ ཡེ དྷནེ ཝིཤྭསནྟི ཏེཥཱམ྄ ཨཱིཤྭརརཱཛྱཔྲཝེཤཿ ཀཱིདྲྀག྄ དུཥྐརཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ཨཱིཤྭརརཱཛྱེ དྷནིནཱཾ པྲཝེཤཱཏ྄ སཱུཙིརནྡྷྲེཎ མཧཱངྒསྱ གམནཱགམནཾ སུཀརཾ། ");
INSERT INTO santib_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ཏདཱ ཤིཥྱཱ ཨཏཱིཝ ཝིསྨིཏཱཿ པརསྤརཾ པྲོཙུཿ, ཏརྷི ཀཿ པརིཏྲཱཎཾ པྲཱཔྟུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ཏཏོ ཡཱིཤུསྟཱན྄ ཝིལོཀྱ བབྷཱཥེ, ཏན྄ ནརསྱཱསཱདྷྱཾ ཀིནྟུ ནེཤྭརསྱ, ཡཏོ ཧེཏོརཱིཤྭརསྱ སཪྻྭཾ སཱདྷྱམ྄། ");
INSERT INTO santib_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ཏདཱ པིཏར ཨུཝཱཙ, པཤྱ ཝཡཾ སཪྻྭཾ པརིཏྱཛྱ བྷཝཏོནུགཱམིནོ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ཏཏོ ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, མདརྠཾ སུསཾཝཱདཱརྠཾ ཝཱ ཡོ ཛནཿ སདནཾ བྷྲཱཏརཾ བྷགིནཱིཾ པིཏརཾ མཱཏརཾ ཛཱཡཱཾ སནྟཱནཱན྄ བྷཱུམི ཝཱ ཏྱཀྟྭཱ ");
INSERT INTO santib_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","གྲྀཧབྷྲཱཏྲྀབྷགིནཱིཔིཏྲྀམཱཏྲྀཔཏྣཱིསནྟཱནབྷཱུམཱིནཱམིཧ ཤཏགུཎཱན྄ པྲེཏྱཱནནྟཱཡུཤྩ ན པྲཱཔྣོཏི ཏཱདྲྀཤཿ ཀོཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ཀིནྟྭགྲཱིཡཱ ཨནེཀེ ལོཀཱཿ ཤེཥཱཿ, ཤེཥཱིཡཱ ཨནེཀེ ལོཀཱཤྩཱགྲཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ཨཐ ཡིརཱུཤཱལམྱཱནཀཱལེ ཡཱིཤུསྟེཥཱམ྄ ཨགྲགཱམཱི བབྷཱུཝ, ཏསྨཱཏྟེ ཙིཏྲཾ ཛྙཱཏྭཱ པཤྩཱདྒཱམིནོ བྷཱུཏྭཱ བིབྷྱུཿ། ཏདཱ ས པུན རྡྭཱདཤཤིཥྱཱན྄ གྲྀཧཱིཏྭཱ སྭཱིཡཾ ཡདྱད྄ གྷཊིཥྱཏེ ཏཏྟཏ྄ ཏེབྷྱཿ ཀཐཡིཏུཾ པྲཱརེབྷེ; ");
INSERT INTO santib_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","པཤྱཏ ཝཡཾ ཡིརཱུཤཱལམྤུརཾ ཡཱམཿ, ཏཏྲ མནུཥྱཔུཏྲཿ པྲདྷཱནཡཱཛཀཱནཱམ྄ ཨུཔཱདྷྱཱཡཱནཱཉྩ ཀརེཥུ སམརྤཡིཥྱཏེ; ཏེ ཙ ཝདྷདཎྜཱཛྙཱཾ དཱཔཡིཏྭཱ པརདེཤཱིཡཱནཱཾ ཀརེཥུ ཏཾ སམརྤཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ཏེ ཏམུཔཧསྱ ཀཤཡཱ པྲཧྲྀཏྱ ཏདྭཔུཥི ནིཥྛཱིཝཾ ནིཀྵིཔྱ ཏཾ ཧནིཥྱནྟི, ཏཏཿ ས ཏྲྀཏཱིཡདིནེ པྲོཏྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ཏཏཿ སིཝདེཿ པུཏྲཽ ཡཱཀཱུབྱོཧནཽ ཏདནྟིཀམ྄ ཨེཏྱ པྲོཙཏུཿ, ཧེ གུརོ ཡད྄ ཨཱཝཱབྷྱཱཾ ཡཱཙིཥྱཏེ ཏདསྨདརྠཾ བྷཝཱན྄ ཀརོཏུ ནིཝེདནམིདམཱཝཡོཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ཏཏཿ ས ཀཐིཏཝཱན྄, ཡུཝཱཾ ཀིམིཙྪཐཿ? ཀིཾ མཡཱ ཡུཥྨདརྠཾ ཀརཎཱིཡཾ? ");
INSERT INTO santib_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ཏདཱ ཏཽ པྲོཙཏུཿ, ཨཱཝཡོརེཀཾ དཀྵིཎཔཱརྴྭེ ཝཱམཔཱརྴྭེ ཙཻཀཾ ཏཝཻཤྭཪྻྱཔདེ སམུཔཝེཥྚུམ྄ ཨཱཛྙཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ཀིནྟུ ཡཱིཤུཿ པྲཏྱུཝཱཙ ཡུཝཱམཛྙཱཏྭེདཾ པྲཱརྠཡེཐེ, ཡེན ཀཾསེནཱཧཾ པཱསྱཱམི ཏེན ཡུཝཱབྷྱཱཾ ཀིཾ པཱཏུཾ ཤཀྵྱཏེ? ཡསྨིན྄ མཛྫནེནཱཧཾ མཛྫིཥྱེ ཏནྨཛྫནེ མཛྫཡིཏུཾ ཀིཾ ཡུཝཱབྷྱཱཾ ཤཀྵྱཏེ? ཏཽ པྲཏྱཱུཙཏུཿ ཤཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ཏདཱ ཡཱིཤུརཝདཏ྄ ཡེན ཀཾསེནཱཧཾ པཱསྱཱམི ཏེནཱཝཤྱཾ ཡུཝཱམཔི པཱསྱཐཿ, ཡེན མཛྫནེན ཙཱཧཾ མཛྫིཡྻེ ཏཏྲ ཡུཝཱམཔི མཛྫིཥྱེཐེ། ");
INSERT INTO santib_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ཀིནྟུ ཡེཥཱམརྠམ྄ ཨིདཾ ནིརཱུཔིཏཾ, ཏཱན྄ ཝིཧཱཡཱནྱཾ ཀམཔི མམ དཀྵིཎཔཱརྴྭེ ཝཱམཔཱརྴྭེ ཝཱ སམུཔཝེཤཡིཏུཾ མམཱདྷིཀཱརོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ཨཐཱནྱདཤཤིཥྱཱ ཨིམཱཾ ཀཐཱཾ ཤྲུཏྭཱ ཡཱཀཱུབྱོཧནྦྷྱཱཾ ཙུཀུཔུཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ཀིནྟུ ཡཱིཤུསྟཱན྄ སམཱཧཱུཡ བབྷཱཥེ, ཨནྱདེཤཱིཡཱནཱཾ རཱཛཏྭཾ ཡེ ཀུཪྻྭནྟི ཏེ ཏེཥཱམེཝ པྲབྷུཏྭཾ ཀུཪྻྭནྟི, ཏཐཱ ཡེ མཧཱལོཀཱསྟེ ཏེཥཱམ྄ ཨདྷིཔཏིཏྭཾ ཀུཪྻྭནྟཱིཏི ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ཀིནྟུ ཡུཥྨཱཀཾ མདྷྱེ ན ཏཐཱ བྷཝིཥྱཏི, ཡུཥྨཱཀཾ མདྷྱེ ཡཿ པྲཱདྷཱནྱཾ ཝཱཉྪཏི ས ཡུཥྨཱཀཾ སེཝཀོ བྷཝིཥྱཏི, ");
INSERT INTO santib_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ཡུཥྨཱཀཾ ཡོ མཧཱན྄ བྷཝིཏུམིཙྪཏི ས སཪྻྭེཥཱཾ ཀིངྐརོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ཡཏོ མནུཥྱཔུཏྲཿ སེཝྱོ བྷཝིཏུཾ ནཱགཏཿ སེཝཱཾ ཀརྟྟཱཾ ཏཐཱནེཀེཥཱཾ པརིཏྲཱཎསྱ མཱུལྱརཱུཔསྭཔྲཱཎཾ དཱཏུཉྩཱགཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ཨཐ ཏེ ཡིརཱིཧོནགརཾ པྲཱཔྟཱསྟསྨཱཏ྄ ཤིཥྱཻ རློཀཻཤྩ སཧ ཡཱིཤོ རྒམནཀཱལེ ཊཱིམཡསྱ པུཏྲོ བརྚཱིམཡནཱམཱ ཨནྡྷསྟནྨཱརྒཔཱརྴྭེ བྷིཀྵཱརྠམ྄ ཨུཔཝིཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ས ནཱསརཏཱིཡསྱ ཡཱིཤོརཱགམནཝཱརྟྟཱཾ པྲཱཔྱ པྲོཙཻ ཪྻཀྟུམཱརེབྷེ, ཧེ ཡཱིཤོ དཱཡཱུདཿ སནྟཱན མཱཾ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ཏཏོནེཀེ ལོཀཱ མཽནཱིབྷཝེཏི ཏཾ ཏརྫཡཱམཱསུཿ, ཀིནྟུ ས པུནརདྷིཀམུཙྩཻ རྫགཱད, ཧེ ཡཱིཤོ དཱཡཱུདཿ སནྟཱན མཱཾ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ཏདཱ ཡཱིཤུཿ སྠིཏྭཱ ཏམཱཧྭཱཏུཾ སམཱདིདེཤ, ཏཏོ ལོཀཱསྟམནྡྷམཱཧཱུཡ བབྷཱཥིརེ, ཧེ ནར, སྠིརོ བྷཝ, ཨུཏྟིཥྛ, ས ཏྭཱམཱཧྭཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ཏདཱ ས ཨུཏྟརཱིཡཝསྟྲཾ ནིཀྵིཔྱ པྲོཏྠཱཡ ཡཱིཤོཿ སམཱིཔཾ གཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ཏཏོ ཡཱིཤུསྟམཝདཏ྄ ཏྭཡཱ ཀིཾ པྲཱརྠྱཏེ? ཏུབྷྱམཧཾ ཀིཾ ཀརིཥྱཱམཱི? ཏདཱ སོནྡྷསྟམུཝཱཙ, ཧེ གུརོ མདཱིཡཱ དྲྀཥྚིརྦྷཝེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ཏཏོ ཡཱིཤུསྟམུཝཱཙ ཡཱཧི ཏཝ ཝིཤྭཱསསྟྭཱཾ སྭསྠམཀཱརྵཱིཏ྄, ཏསྨཱཏ྄ ཏཏྐྵཎཾ ས དྲྀཥྚིཾ པྲཱཔྱ པཐཱ ཡཱིཤོཿ པཤྩཱད྄ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ཨནནྟརཾ ཏེཥུ ཡིརཱུཤཱལམཿ སམཱིཔསྠཡོ རྦཻཏྥགཱིབཻཐནཱིཡཔུརཡོརནྟིཀསྠཾ ཛཻཏུནནཱམཱདྲིམཱགཏེཥུ ཡཱིཤུཿ པྲེཥཎཀཱལེ དྭཽ ཤིཥྱཱཝིདཾ ཝཱཀྱཾ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ཡུཝཱམམུཾ སམྨུཁསྠཾ གྲཱམཾ ཡཱཏཾ, ཏཏྲ པྲཝིཤྱ ཡོ ནརཾ ནཱཝཧཏ྄ ཏཾ གརྡྡབྷཤཱཝཀཾ དྲཀྵྱཐསྟཾ མོཙཡིཏྭཱནཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ཀིནྟུ ཡུཝཱཾ ཀརྨྨེདཾ ཀུཏཿ ཀུརུཐཿ? ཀཐཱམིམཱཾ ཡདི ཀོཔི པྲྀཙྪཏི ཏརྷི པྲབྷོརཏྲ པྲཡོཛནམསྟཱིཏི ཀཐིཏེ ས ཤཱིགྷྲཾ ཏམཏྲ པྲེཥཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ཏཏསྟཽ གཏྭཱ དྭིམཱརྒམེལནེ ཀསྱཙིད྄ དྭཱརསྱ པཱརྴྭེ ཏཾ གརྡྡབྷཤཱཝཀཾ པྲཱཔྱ མོཙཡཏཿ, ");
INSERT INTO santib_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ཨེཏརྷི ཏཏྲོཔསྠིཏལོཀཱནཱཾ ཀཤྩིད྄ ཨཔྲྀཙྪཏ྄, གརྡྡབྷཤིཤུཾ ཀུཏོ མོཙཡཐཿ? ");
INSERT INTO santib_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ཏདཱ ཡཱིཤོརཱཛྙཱནུསཱརེཎ ཏེབྷྱཿ པྲཏྱུདིཏེ ཏཏྐྵཎཾ ཏམཱདཱཏུཾ ཏེ྅ནུཛཛྙུཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ཨཐ ཏཽ ཡཱིཤོཿ སནྣིདྷིཾ གརྡྡབྷཤིཤུམ྄ ཨཱནཱིཡ ཏདུཔརི སྭཝསྟྲཱཎི པཱཏཡཱམཱསཏུཿ; ཏཏཿ ས ཏདུཔརི སམུཔཝིཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ཏདཱནེཀེ པཐི སྭཝཱསཱཾསི པཱཏཡཱམཱསུཿ, པརཻཤྩ ཏརུཤཱཁཱཤྪིཏཝཱ མཱརྒེ ཝིཀཱིརྞཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ཨཔརཉྩ པཤྩཱདྒཱམིནོ྅གྲགཱམིནཤྩ སཪྻྭེ ཛནཱ ཨུཙཻཿསྭརེཎ ཝཀྟུམཱརེབྷིརེ, ཛཡ ཛཡ ཡཿ པརམེཤྭརསྱ ནཱམྣཱགཙྪཏི ས དྷནྱ ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ཏཐཱསྨཱཀམཾ པཱུཪྻྭཔུརུཥསྱ དཱཡཱུདོ ཡདྲཱཛྱཾ པརམེཤྭརནཱམྣཱཡཱཏི ཏདཔི དྷནྱཾ, སཪྻྭསྨཱདུཙྪྲཱཡེ སྭརྒེ ཨཱིཤྭརསྱ ཛཡོ བྷཝེཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ཨིཏྠཾ ཡཱིཤུ ཪྻིརཱུཤཱལམི མནྡིརཾ པྲཝིཤྱ ཙཏུརྡིཀྶྠཱནི སཪྻྭཱཎི ཝསྟཱུནི དྲྀཥྚཝཱན྄; ཨཐ སཱཡཾཀཱལ ཨུཔསྠིཏེ དྭཱདཤཤིཥྱསཧིཏོ བཻཐནིཡཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ཨཔརེཧནི བཻཐནིཡཱད྄ ཨཱགམནསམཡེ ཀྵུདྷཱརྟྟོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ཏཏོ དཱུརེ སཔཏྲམུཌུམྦརཔཱདཔཾ ཝིལོཀྱ ཏཏྲ ཀིཉྩིཏ྄ ཕལཾ པྲཱཔྟུཾ ཏསྱ སནྣིཀྲྀཥྚཾ ཡཡཽ, ཏདཱནཱིཾ ཕལཔཱཏནསྱ སམཡོ ནཱགཙྪཏི། ཏཏསྟཏྲོཔསྠིཏཿ པཏྲཱཎི ཝིནཱ ཀིམཔྱཔརཾ ན པྲཱཔྱ ས ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ཨདྱཱརབྷྱ ཀོཔི མཱནཝསྟྭཏྟཿ ཕལཾ ན བྷུཉྫཱིཏ; ཨིམཱཾ ཀཐཱཾ ཏསྱ ཤིཥྱཱཿ ཤུཤྲུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ཏདནནྟརཾ ཏེཥུ ཡིརཱུཤཱལམམཱཡཱཏེཥུ ཡཱིཤུ རྨནྡིརཾ གཏྭཱ ཏཏྲསྠཱནཱཾ བཎིཛཱཾ མུདྲཱསནཱནི པཱརཱཝཏཝིཀྲེཏྲྀཎཱམ྄ ཨཱསནཱནི ཙ ནྱུབྫཡཱཉྩཀཱར སཪྻྭཱན྄ ཀྲེཏྲྀན྄ ཝིཀྲེཏྲྀཾཤྩ བཧིཤྩཀཱར། ");
INSERT INTO santib_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ཨཔརཾ མནྡིརམདྷྱེན ཀིམཔི པཱཏྲཾ ཝོཌྷུཾ སཪྻྭཛནཾ ནིཝཱརཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ལོཀཱནུཔདིཤན྄ ཛགཱད, མམ གྲྀཧཾ སཪྻྭཛཱཏཱིཡཱནཱཾ པྲཱརྠནཱགྲྀཧམ྄ ཨིཏི ནཱམྣཱ པྲཐིཏཾ བྷཝིཥྱཏི ཨེཏཏ྄ ཀིཾ ཤཱསྟྲེ ལིཁིཏཾ ནཱསྟི? ཀིནྟུ ཡཱུཡཾ ཏདེཝ ཙོརཱཎཱཾ གཧྭརཾ ཀུརུཐ། ");
INSERT INTO santib_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ཨིམཱཾ ཝཱཎཱིཾ ཤྲུཏྭཱདྷྱཱཔཀཱཿ པྲདྷཱནཡཱཛཀཱཤྩ ཏཾ ཡཐཱ ནཱཤཡིཏུཾ ཤཀྣུཝནྟི ཏཐོेཔཱཡཾ མྲྀགཡཱམཱསུཿ, ཀིནྟུ ཏསྱོཔདེཤཱཏ྄ སཪྻྭེ ལོཀཱ ཝིསྨཡཾ གཏཱ ཨཏསྟེ ཏསྨཱད྄ བིབྷྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ཨཐ སཱཡཾསམཡ ཨུཔསྠིཏེ ཡཱིཤུརྣགརཱད྄ བཧིཪྻཝྲཱཛ། ");
INSERT INTO santib_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ཨནནྟརཾ པྲཱཏཿཀཱལེ ཏེ ཏེན མཱརྒེཎ གཙྪནྟསྟམུཌུམྦརམཧཱིརུཧཾ སམཱུལཾ ཤུཥྐཾ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ཏཏཿ པིཏརཿ པཱུཪྻྭཝཱཀྱཾ སྨརན྄ ཡཱིཤུཾ བབྷཱཥཾ, ཧེ གུརོ པཤྱཏུ ཡ ཨུཌུམྦརཝིཊཔཱི བྷཝཏཱ ཤཔྟཿ ས ཤུཥྐོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིཏ྄, ཡཱུཡམཱིཤྭརེ ཝིཤྭསིཏ། ");
INSERT INTO santib_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི ཀོཔི ཡདྱེཏདྒིརིཾ ཝདཏི, ཏྭམུཏྠཱཡ གཏྭཱ ཛལདྷཽ པཏ, པྲོཀྟམིདཾ ཝཱཀྱམཝཤྱཾ གྷཊིཥྱཏེ, མནསཱ ཀིམཔི ན སནྡིཧྱ ཙེདིདཾ ཝིཤྭསེཏ྄ ཏརྷི ཏསྱ ཝཱཀྱཱནུསཱརེཎ ཏད྄ གྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ཨཏོ ཧེཏོརཧཾ ཡུཥྨཱན྄ ཝཙྨི, པྲཱརྠནཱཀཱལེ ཡདྱདཱཀཱཾཀྵིཥྱདྷྭེ ཏཏྟདཝཤྱཾ པྲཱཔྶྱཐ, ཨིཏྠཾ ཝིཤྭསིཏ, ཏཏཿ པྲཱཔྶྱཐ། ");
INSERT INTO santib_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ཨཔརཉྩ ཡུཥྨཱསུ པྲཱརྠཡིཏུཾ སམུཏྠིཏེཥུ ཡདི ཀོཔི ཡུཥྨཱཀམ྄ ཨཔརཱདྷཱི ཏིཥྛཏི, ཏརྷི ཏཾ ཀྵམདྷྭཾ, ཏཐཱ ཀྲྀཏེ ཡུཥྨཱཀཾ སྭརྒསྠཿ པིཏཱཔི ཡུཥྨཱཀམཱགཱཾམི ཀྵམིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ཀིནྟུ ཡདི ན ཀྵམདྷྭེ ཏརྷི ཝཿ སྭརྒསྠཿ པིཏཱཔི ཡུཥྨཱཀམཱགཱཾསི ན ཀྵམིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ཨནནྟརཾ ཏེ པུན ཪྻིརཱུཤཱལམཾ པྲཝིཝིཤུཿ, ཡཱིཤུ ཪྻདཱ མདྷྱེམནྡིརམ྄ ཨིཏསྟཏོ གཙྪཏི, ཏདཱནཱིཾ པྲདྷཱནཡཱཛཀཱ ཨུཔཱདྷྱཱཡཱཿ པྲཱཉྩཤྩ ཏདནྟིཀམེཏྱ ཀཐཱམིམཱཾ པཔྲཙྪུཿ, ");
INSERT INTO santib_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ཏྭཾ ཀེནཱདེཤེན ཀརྨྨཱཎྱེཏཱནི ཀརོཥི? ཏཐཻཏཱནི ཀརྨྨཱཎི ཀརྟྟཱཾ ཀེནཱདིཥྚོསི? ");
INSERT INTO santib_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ཏཏོ ཡཱིཤུཿ པྲཏིགདིཏཝཱན྄ ཨཧམཔི ཡུཥྨཱན྄ ཨེཀཀཐཱཾ པྲྀཙྪཱམི, ཡདི ཡཱུཡཾ ཏསྱཱ ཨུཏྟརཾ ཀུརུཐ, ཏརྷི ཀཡཱཛྙཡཱཧཾ ཀརྨྨཱཎྱེཏཱནི ཀརོམི ཏད྄ ཡུཥྨབྷྱཾ ཀཐཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ཡོཧནོ མཛྫནམ྄ ཨཱིཤྭརཱཏ྄ ཛཱཏཾ ཀིཾ མཱནཝཱཏ྄? ཏནྨཧྱཾ ཀཐཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ཏེ པརསྤརཾ ཝིཝེཀྟུཾ པྲཱརེབྷིརེ, ཏད྄ ཨཱིཤྭརཱད྄ བབྷཱུཝེཏི ཙེད྄ ཝདཱམསྟརྷི ཀུཏསྟཾ ན པྲཏྱཻཏ? ཀཐམེཏཱཾ ཀཐཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","མཱནཝཱད྄ ཨབྷཝདིཏི ཙེད྄ ཝདཱམསྟརྷི ལོཀེབྷྱོ བྷཡམསྟི ཡཏོ ཧེཏོཿ སཪྻྭེ ཡོཧནཾ སཏྱཾ བྷཝིཥྱདྭཱདིནཾ མནྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ཨཏཨེཝ ཏེ ཡཱིཤུཾ པྲཏྱཝཱདིཥུ ཪྻཡཾ ཏད྄ ཝཀྟུཾ ན ཤཀྣུམཿ། ཡཱིཤུརུཝཱཙ, ཏརྷི ཡེནཱདེཤེན ཀརྨྨཱཎྱེཏཱནི ཀརོམི, ཨཧམཔི ཡུཥྨབྷྱཾ ཏནྣ ཀཐཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ཨནནྟརཾ ཡཱིཤུ རྡྲྀཥྚཱནྟེན ཏེབྷྱཿ ཀཐཡིཏུམཱརེབྷེ, ཀཤྩིདེཀོ དྲཱཀྵཱཀྵེཏྲཾ ཝིདྷཱཡ ཏཙྩཏུརྡིཀྵུ ཝཱརཎཱིཾ ཀྲྀཏྭཱ ཏནྨདྷྱེ དྲཱཀྵཱཔེཥཎཀུཎྜམ྄ ཨཁནཏ྄, ཏཐཱ ཏསྱ གཌམཔི ནིརྨྨིཏཝཱན྄ ཏཏསྟཏྐྵེཏྲཾ ཀྲྀཥཱིཝལེཥུ སམརྤྱ དཱུརདེཤཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ཏདནནྟརཾ ཕལཀཱལེ ཀྲྀཥཱིཝལེབྷྱོ དྲཱཀྵཱཀྵེཏྲཕལཱནི པྲཱཔྟུཾ ཏེཥཱཾ སཝིདྷེ བྷྲྀཏྱམ྄ ཨེཀཾ པྲཱཧིཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ཀིནྟུ ཀྲྀཥཱིཝལཱསྟཾ དྷྲྀཏྭཱ པྲཧྲྀཏྱ རིཀྟཧསྟཾ ཝིསསྲྀཛུཿ། ");
INSERT INTO santib_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ཏཏཿ ས པུནརནྱམེཀཾ བྷྲྀཏྱཾ པྲཥཡཱམཱས, ཀིནྟུ ཏེ ཀྲྀཥཱིཝལཱཿ པཱཥཱཎཱགྷཱཏཻསྟསྱ ཤིརོ བྷངྐྟྭཱ སཱཔམཱནཾ ཏཾ ཝྱསརྫན྄། ");
INSERT INTO santib_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ཏཏཿ པརཾ སོཔརཾ དཱསཾ པྲཱཧིཎོཏ྄ ཏདཱ ཏེ ཏཾ ཛགྷྣུཿ, ཨེཝམ྄ ཨནེཀེཥཱཾ ཀསྱཙིཏ྄ པྲཧཱརཿ ཀསྱཙིད྄ ཝདྷཤྩ ཏཻཿ ཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ཏཏཿ པརཾ མཡཱ སྭཔུཏྲེ པྲཧིཏེ ཏེ ཏམཝཤྱཾ སམྨཾསྱནྟེ, ཨིཏྱུཀྟྭཱཝཤེཥེ ཏེཥཱཾ སནྣིདྷཽ ནིཛཔྲིཡམ྄ ཨདྭིཏཱིཡཾ པུཏྲཾ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ཀིནྟུ ཀྲྀཥཱིཝལཱཿ པརསྤརཾ ཛགདུཿ, ཨེཥ ཨུཏྟརཱདྷིཀཱརཱི, ཨཱགཙྪཏ ཝཡམེནཾ ཧནྨསྟཐཱ ཀྲྀཏེ ྅དྷིཀཱརོཡམ྄ ཨསྨཱཀཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ཏཏསྟཾ དྷྲྀཏྭཱ ཧཏྭཱ དྲཱཀྵཱཀྵེཏྲཱད྄ བཧིཿ པྲཱཀྵིཔན྄། ");
INSERT INTO santib_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ཨནེནཱསཽ དྲཱཀྵཱཀྵེཏྲཔཏིཿ ཀིཾ ཀརིཥྱཏི? ས ཨེཏྱ ཏཱན྄ ཀྲྀཥཱིཝལཱན྄ སཾཧཏྱ ཏཏྐྵེཏྲམ྄ ཨནྱེཥུ ཀྲྀཥཱིཝལེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ཨཔརཉྩ, \"སྠཔཏཡཿ ཀརིཥྱནྟི གྲཱཝཱཎཾ ཡནྟུ ཏུཙྪཀཾ། པྲཱདྷཱནཔྲསྟརཿ ཀོཎེ ས ཨེཝ སཾབྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ཨེཏཏ྄ ཀརྨྨ པརེཤསྱཱཾདྦྷུཏཾ ནོ དྲྀཥྚིཏོ བྷཝེཏ྄༎ \" ཨིམཱཾ ཤཱསྟྲཱིཡཱཾ ལིཔིཾ ཡཱུཡཾ ཀིཾ ནཱཔཱཋིཥྚ? ");
INSERT INTO santib_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ཏདཱནཱིཾ ས ཏཱནུདྡིཤྱ ཏཱཾ དྲྀཥྚཱནྟཀཐཱཾ ཀཐིཏཝཱན྄, ཏ ཨིཏྠཾ བུདྭྭཱ ཏཾ དྷརྟྟཱམུདྱཏཱཿ, ཀིནྟུ ལོཀེབྷྱོ བིབྷྱུཿ, ཏདནནྟརཾ ཏེ ཏཾ ཝིཧཱཡ ཝཝྲཛུཿ། ");
INSERT INTO santib_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ཨཔརཉྩ ཏེ ཏསྱ ཝཱཀྱདོཥཾ དྷརྟྟཱཾ ཀཏིཔཡཱན྄ ཕིརཱུཤིནོ ཧེརོདཱིཡཱཾཤྩ ལོཀཱན྄ ཏདནྟིཀཾ པྲེཥཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ཏ ཨཱགཏྱ ཏམཝདན྄, ཧེ གུརོ བྷཝཱན྄ ཏཐྱབྷཱཥཱི ཀསྱཱཔྱནུརོདྷཾ ན མནྱཏེ, པཀྵཔཱཏཉྩ ན ཀརོཏི, ཡཐཱརྠཏ ཨཱིཤྭརཱིཡཾ མཱརྒཾ དརྴཡཏི ཝཡམེཏཏ྄ པྲཛཱནཱིམཿ, ཀཻསརཱཡ ཀརོ དེཡོ ན ཝཱཾ? ཝཡཾ དཱསྱཱམོ ན ཝཱ? ");
INSERT INTO santib_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ཀིནྟུ ས ཏེཥཱཾ ཀཔཊཾ ཛྙཱཏྭཱ ཛགཱད, ཀུཏོ མཱཾ པརཱིཀྵདྷྭེ? ཨེཀཾ མུདྲཱཔཱདཾ སམཱནཱིཡ མཱཾ དརྴཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ཏདཱ ཏཻརེཀསྨིན྄ མུདྲཱཔཱདེ སམཱནཱིཏེ ས ཏཱན྄ པཔྲཙྪ, ཨཏྲ ལིཁིཏཾ ནཱམ མཱུརྟྟི ཪྻཱ ཀསྱ? ཏེ པྲཏྱཱུཙུཿ, ཀཻསརསྱ། ");
INSERT INTO santib_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ཏདཱ ཡཱིཤུརཝདཏ྄ ཏརྷི ཀཻསརསྱ དྲཝྱཱཎི ཀཻསརཱཡ དཏྟ, ཨཱིཤྭརསྱ དྲཝྱཱཎི ཏུ ཨཱིཤྭརཱཡ དཏྟ; ཏཏསྟེ ཝིསྨཡཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ཨཐ མྲྀཏཱནཱམུཏྠཱནཾ ཡེ ན མནྱནྟེ ཏེ སིདཱུཀིནོ ཡཱིཤོཿ སམཱིཔམཱགཏྱ ཏཾ པཔྲཙྪུཿ; ");
INSERT INTO santib_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ཧེ གུརོ ཀཤྩིཛྫནོ ཡདི ནིཿསནྟཏིཿ སན྄ བྷཱཪྻྱཱཡཱཾ སཏྱཱཾ མྲིཡཏེ ཏརྷི ཏསྱ བྷྲཱཏཱ ཏསྱ བྷཱཪྻྱཱཾ གྲྀཧཱིཏྭཱ བྷྲཱཏུ ཪྻཾཤོཏྤཏྟིཾ ཀརིཥྱཏི, ཝྱཝསྠཱམིམཱཾ མཱུསཱ ཨསྨཱན྄ པྲཏི ཝྱལིཁཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ཀིནྟུ ཀེཙིཏ྄ སཔྟ བྷྲཱཏར ཨཱསན྄, ཏཏསྟེཥཱཾ ཛྱེཥྛབྷྲཱཏཱ ཝིཝཧྱ ནིཿསནྟཏིཿ སན྄ ཨམྲིཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ཏཏོ དྭིཏཱིཡོ བྷྲཱཏཱ ཏཱཾ སྟྲིཡམགྲྀཧཎཏ྄ ཀིནྟུ སོཔི ནིཿསནྟཏིཿ སན྄ ཨམྲིཡཏ; ཨཐ ཏྲྀཏཱིཡོཔི བྷྲཱཏཱ ཏཱདྲྀཤོབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ཨིཏྠཾ སཔྟཻཝ བྷྲཱཏརསྟཱཾ སྟྲིཡཾ གྲྀཧཱིཏྭཱ ནིཿསནྟཱནཱཿ སནྟོ྅མྲིཡནྟ, སཪྻྭཤེཥེ སཱཔི སྟྲཱི མྲིཡཏེ སྨ། ");
INSERT INTO santib_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ཨཐ མྲྀཏཱནཱམུཏྠཱནཀཱལེ ཡདཱ ཏ ཨུཏྠཱསྱནྟི ཏདཱ ཏེཥཱཾ ཀསྱ བྷཱཪྻྱཱ སཱ བྷཝིཥྱཏི? ཡཏསྟེ སཔྟཻཝ ཏཱཾ ཝྱཝཧན྄། ");
INSERT INTO santib_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ཏཏོ ཡཱིཤུཿ པྲཏྱུཝཱཙ ཤཱསྟྲམ྄ ཨཱིཤྭརཤཀྟིཉྩ ཡཱུཡམཛྙཱཏྭཱ ཀིམབྷྲཱམྱཏ ན? ");
INSERT INTO santib_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","མྲྀཏལོཀཱནཱམུཏྠཱནཾ སཏི ཏེ ན ཝིཝཧནྟི ཝཱགྡཏྟཱ ཨཔི ན བྷཝནྟི, ཀིནྟུ སྭརྒཱིཡདཱུཏཱནཱཾ སདྲྀཤཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","པུནཤྩ \"ཨཧམ྄ ཨིབྲཱཧཱིམ ཨཱིཤྭར ཨིསྷཱཀ ཨཱིཤྭརོ ཡཱཀཱུབཤྩེཤྭརཿ\" ཡཱམིམཱཾ ཀཐཱཾ སྟམྦམདྷྱེ ཏིཥྛན྄ ཨཱིཤྭརོ མཱུསཱམཝཱདཱིཏ྄ མྲྀཏཱནཱམུཏྠཱནཱརྠེ སཱ ཀཐཱ མཱུསཱལིཁིཏེ པུསྟཀེ ཀིཾ ཡུཥྨཱབྷི རྣཱཔཱཋི? ");
INSERT INTO santib_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ཨཱིཤྭརོ ཛཱིཝཏཱཾ པྲབྷུཿ ཀིནྟུ མྲྀཏཱནཱཾ པྲབྷུ རྣ བྷཝཏི, ཏསྨཱདྡྷེཏོ ཪྻཱུཡཾ མཧཱབྷྲམེཎ ཏིཥྛཐ། ");
INSERT INTO santib_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ཨེཏརྷི ཨེཀོདྷྱཱཔཀ ཨེཏྱ ཏེཥཱམིཏྠཾ ཝིཙཱརཾ ཤུཤྲཱཝ; ཡཱིཤུསྟེཥཱཾ ཝཱཀྱསྱ སདུཏྟརཾ དཏྟཝཱན྄ ཨིཏི བུདྭྭཱ ཏཾ པྲྀཥྚཝཱན྄ སཪྻྭཱསཱམ྄ ཨཱཛྙཱནཱཾ ཀཱ ཤྲེཥྛཱ? ཏཏོ ཡཱིཤུཿ པྲཏྱུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ཧེ ཨིསྲཱཡེལློཀཱ ཨཝདྷཏྟ, ཨསྨཱཀཾ པྲབྷུཿ པརམེཤྭར ཨེཀ ཨེཝ, ");
INSERT INTO santib_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ཡཱུཡཾ སཪྻྭནྟཿཀརཎཻཿ སཪྻྭཔྲཱཎཻཿ སཪྻྭཙིཏྟཻཿ སཪྻྭཤཀྟིབྷིཤྩ ཏསྨིན྄ པྲབྷཽ པརམེཤྭརེ པྲཱིཡདྷྭཾ,\" ཨིཏྱཱཛྙཱ ཤྲེཥྛཱ། ");
INSERT INTO santib_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ཏཐཱ \"སྭཔྲཏིཝཱསིནི སྭཝཏ྄ པྲེམ ཀུརུདྷྭཾ,\" ཨེཥཱ ཡཱ དྭིཏཱིཡཱཛྙཱ སཱ ཏཱདྲྀཤཱི; ཨེཏཱབྷྱཱཾ དྭཱབྷྱཱམ྄ ཨཱཛྙཱབྷྱཱམ྄ ཨནྱཱ ཀཱཔྱཱཛྙཱ ཤྲེཥྛཱ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ཏདཱ སོདྷྱཱཔཀསྟམཝདཏ྄, ཧེ གུརོ སཏྱཾ བྷཝཱན྄ ཡཐཱརྠཾ པྲོཀྟཝཱན྄ ཡཏ ཨེཀསྨཱད྄ ཨཱིཤྭརཱད྄ ཨནྱོ དྭིཏཱིཡ ཨཱིཤྭརོ ནཱསྟི; ");
INSERT INTO santib_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ཨཔརཾ སཪྻྭཱནྟཿཀརཎཻཿ སཪྻྭཔྲཱཎཻཿ སཪྻྭཙིཏྟཻཿ སཪྻྭཤཀྟིབྷིཤྩ ཨཱིཤྭརེ པྲེམཀརཎཾ ཏཐཱ སྭམཱིཔཝཱསིནི སྭཝཏ྄ པྲེམཀརཎཉྩ སཪྻྭེབྷྱོ ཧོམབལིདཱནཱདིབྷྱཿ ཤྲཥྛཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ཏཏོ ཡཱིཤུཿ སུབུདྡྷེརིཝ ཏསྱེདམ྄ ཨུཏྟརཾ ཤྲུཏྭཱ ཏཾ བྷཱཥིཏཝཱན྄ ཏྭམཱིཤྭརསྱ རཱཛྱཱནྣ དཱུརོསི། ཨིཏཿ པརཾ ཏེན སཧ ཀསྱཱཔི ཝཱཀྱསྱ ཝིཙཱརཾ ཀརྟྟཱཾ ཀསྱཱཔི པྲགལྦྷཏཱ ན ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ཨནནྟརཾ མདྷྱེམནྡིརམ྄ ཨུཔདིཤན྄ ཡཱིཤུརིམཾ པྲཤྣཾ ཙཀཱར, ཨདྷྱཱཔཀཱ ཨབྷིཥིཀྟཾ (ཏཱརཀཾ) ཀུཏོ དཱཡཱུདཿ སནྟཱནཾ ཝདནྟི? ");
INSERT INTO santib_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","སྭཡཾ དཱཡཱུད྄ པཝིཏྲསྱཱཏྨན ཨཱཝེཤེནེདཾ ཀཐཡཱམཱས། ཡཐཱ། \"མམ པྲབྷུམིདཾ ཝཱཀྱཝདཏ྄ པརམེཤྭརཿ། ཏཝ ཤཏྲཱུནཧཾ ཡཱཝཏ྄ པཱདཔཱིཋཾ ཀརོམི ན། ཏཱཝཏ྄ ཀཱལཾ མདཱིཡེ ཏྭཾ དཀྵཔཱརྴྭ྄ ཨུཔཱཝིཤ། \" ");
INSERT INTO santib_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ཡདི དཱཡཱུད྄ ཏཾ པྲབྷཱུཾ ཝདཏི ཏརྷི ཀཐཾ ས ཏསྱ སནྟཱནོ བྷཝིཏུམརྷཏི? ཨིཏརེ ལོཀཱསྟཏྐཐཱཾ ཤྲུཏྭཱནནནྡུཿ། ");
INSERT INTO santib_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ཏདཱནཱིཾ ས ཏཱནུཔདིཤྱ ཀཐིཏཝཱན྄ ཡེ ནརཱ དཱིརྒྷཔརིདྷེཡཱནི ཧཊྚེ ཝིཔནཽ ཙ ");
INSERT INTO santib_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ལོཀཀྲྀཏནམསྐཱརཱན྄ བྷཛནགྲྀཧེ པྲདྷཱནཱསནཱནི བྷོཛནཀཱལེ པྲདྷཱནསྠཱནཱནི ཙ ཀཱངྐྵནྟེ; ");
INSERT INTO santib_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ཝིདྷཝཱནཱཾ སཪྻྭསྭཾ གྲསིཏྭཱ ཚལཱད྄ དཱིརྒྷཀཱལཾ པྲཱརྠཡནྟེ ཏེབྷྱ ཨུཔཱདྷྱཱཡེབྷྱཿ སཱཝདྷཱནཱ བྷཝཏ; ཏེ྅དྷིཀཏརཱན྄ དཎྜཱན྄ པྲཱཔྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ཏདནནྟརཾ ལོཀཱ བྷཱཎྜཱགཱརེ མུདྲཱ ཡཐཱ ནིཀྵིཔནྟི བྷཱཎྜཱགཱརསྱ སམྨུཁེ སམུཔཝིཤྱ ཡཱིཤུསྟདཝལུལོཀ; ཏདཱནཱིཾ བཧཝོ དྷནིནསྟསྱ མདྷྱེ བཧཱུནི དྷནཱནི ནིརཀྵིཔན྄། ");
INSERT INTO santib_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","པཤྩཱད྄ ཨེཀཱ དརིདྲཱ ཝིདྷཝཱ སམཱགཏྱ དྭིཔཎམཱུལྱཱཾ མུདྲཻཀཱཾ ཏཏྲ ནིརཀྵིཔཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ཏདཱ ཡཱིཤུཿ ཤིཥྱཱན྄ ཨཱཧཱུཡ ཀཐིཏཝཱན྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི ཡེ ཡེ བྷཱཎྜཱགཱརེ྅སྨིན དྷནཱནི ནིཿཀྵིཔནྟི སྨ ཏེབྷྱཿ སཪྻྭེབྷྱ ཨིཡཾ ཝིདྷཝཱ དརིདྲཱདྷིཀམ྄ ནིཿཀྵིཔཏི སྨ། ");
INSERT INTO santib_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ཡཏསྟེ པྲབྷཱུཏདྷནསྱ ཀིཉྩིཏ྄ ནིརཀྵིཔན྄ ཀིནྟུ དཱིནེཡཾ སྭདིནཡཱཔནཡོགྱཾ ཀིཉྩིདཔི ན སྠཱཔཡིཏྭཱ སཪྻྭསྭཾ ནིརཀྵིཔཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ཨནནྟརཾ མནྡིརཱད྄ བཧིརྒམནཀཱལེ ཏསྱ ཤིཥྱཱཎཱམེཀསྟཾ ཝྱཱཧྲྀཏཝཱན྄ ཧེ གུརོ པཤྱཏུ ཀཱིདྲྀཤཱཿ པཱཥཱཎཱཿ ཀཱིདྲྀཀ྄ ཙ ནིཙཡནཾ། ");
INSERT INTO santib_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ཏདཱ ཡཱིཤུསྟམ྄ ཨཝདཏ྄ ཏྭཾ ཀིམེཏད྄ བྲྀཧནྣིཙཡནཾ པཤྱསི? ཨསྱཻཀཔཱཥཱཎོཔི དྭིཏཱིཡཔཱཥཱཎོཔརི ན སྠཱསྱཏི སཪྻྭེ ྅དྷཿཀྵེཔྶྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ཨཐ ཡསྨིན྄ ཀཱལེ ཛཻཏུནྒིརཽ མནྡིརསྱ སམྨུཁེ ས སམུཔཝིཥྚསྟསྨིན྄ ཀཱལེ པིཏརོ ཡཱཀཱུབ྄ ཡོཧན྄ ཨཱནྡྲིཡཤྩཻཏེ ཏཾ རཧསི པཔྲཙྪུཿ, ");
INSERT INTO santib_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ཨེཏཱ གྷཊནཱཿ ཀདཱ བྷཝིཥྱནྟི? ཏཐཻཏཏྶཪྻྭཱསཱཾ སིདྡྷྱུཔཀྲམསྱ ཝཱ ཀིཾ ཙིཧྣཾ? ཏདསྨབྷྱཾ ཀཐཡཏུ བྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ཏཏོ ཡཱཤུསྟཱན྄ ཝཀྟུམཱརེབྷེ, ཀོཔི ཡཐཱ ཡུཥྨཱན྄ ན བྷྲཱམཡཏི ཏཐཱཏྲ ཡཱུཡཾ སཱཝདྷཱནཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ཡཏཿ ཁྲཱིཥྚོཧམིཏི ཀཐཡིཏྭཱ མམ ནཱམྣཱནེཀེ སམཱགཏྱ ལོཀཱནཱཾ བྷྲམཾ ཛནཡིཥྱནྟི; ");
INSERT INTO santib_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ཀིནྟུ ཡཱུཡཾ རཎསྱ ཝཱརྟྟཱཾ རཎཱཌམྦརཉྩ ཤྲུཏྭཱ མཱ ཝྱཱཀུལཱ བྷཝཏ, གྷཊནཱ ཨེཏཱ ཨཝཤྱམྨཱཝིནྱཿ; ཀིནྟྭཱཔཱཏཏོ ན ཡུགཱནྟོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","དེཤསྱ ཝིཔཀྵཏཡཱ དེཤོ རཱཛྱསྱ ཝིཔཀྵཏཡཱ ཙ རཱཛྱམུཏྠཱསྱཏི, ཏཐཱ སྠཱནེ སྠཱནེ བྷཱུམིཀམྤོ དུརྦྷིཀྵཾ མཧཱཀླེཤཱཤྩ སམུཔསྠཱསྱནྟི, སཪྻྭ ཨེཏེ དུཿཁསྱཱརམྦྷཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ཀིནྟུ ཡཱུཡམ྄ ཨཱཏྨཱརྠེ སཱཝདྷཱནཱསྟིཥྛཏ, ཡཏོ ལོཀཱ རཱཛསབྷཱཡཱཾ ཡུཥྨཱན྄ སམརྤཡིཥྱནྟི, ཏཐཱ བྷཛནགྲྀཧེ པྲཧརིཥྱནྟི; ཡཱུཡཾ མདརྠེ དེཤཱདྷིཔཱན྄ བྷཱུཔཱཾཤྩ པྲཏི སཱཀྵྱདཱནཱཡ ཏེཥཱཾ སམྨུཁེ ཨུཔསྠཱཔཡིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ཤེཥཱིབྷཝནཱཏ྄ པཱུཪྻྭཾ སཪྻྭཱན྄ དེཤཱིཡཱན྄ པྲཏི སུསཾཝཱདཿ པྲཙཱརཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ཀིནྟུ ཡདཱ ཏེ ཡུཥྨཱན྄ དྷྲྀཏྭཱ སམརྤཡིཥྱནྟི ཏདཱ ཡཱུཡཾ ཡདྱད྄ ཨུཏྟརཾ དཱསྱཐ, ཏདགྲ ཏསྱ ཝིཝེཙནཾ མཱ ཀུརུཏ ཏདརྠཾ ཀིཉྩིདཔི མཱ ཙིནྟཡཏ ཙ, ཏདཱནཱིཾ ཡུཥྨཱཀཾ མནཿསུ ཡདྱད྄ ཝཱཀྱམ྄ ཨུཔསྠཱཔཡིཥྱཏེ ཏདེཝ ཝདིཥྱཐ, ཡཏོ ཡཱུཡཾ ན ཏདྭཀྟཱརཿ ཀིནྟུ པཝིཏྲ ཨཱཏྨཱ ཏསྱ ཝཀྟཱ། ");
INSERT INTO santib_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ཏདཱ བྷྲཱཏཱ བྷྲཱཏརཾ པིཏཱ པུཏྲཾ གྷཱཏནཱརྠཾ པརཧསྟེཥུ སམརྤཡིཥྱཏེ, ཏཐཱ པཏྱཱནི མཱཏཱཔིཏྲོ ཪྻིཔཀྵཏཡཱ ཏཽ གྷཱཏཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","མམ ནཱམཧེཏོཿ སཪྻྭེཥཱཾ སཝིདྷེ ཡཱུཡཾ ཛུགུཔྶིཏཱ བྷཝིཥྱཐ, ཀིནྟུ ཡཿ ཀཤྩིཏ྄ ཤེཥཔཪྻྱནྟཾ དྷཻཪྻྱམ྄ ཨཱལམྦིཥྱཏེ སཨེཝ པརིཏྲཱསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","དཱནིཡེལྦྷཝིཥྱདྭཱདིནཱ པྲོཀྟཾ སཪྻྭནཱཤི ཛུགུཔྶིཏཉྩ ཝསྟུ ཡདཱ ཏྭཡོགྱསྠཱནེ ཝིདྱམཱནཾ དྲཀྵཐ (ཡོ ཛནཿ པཋཏི ས བུདྷྱཏཱཾ) ཏདཱ ཡེ ཡིཧཱུདཱིཡདེཤེ ཏིཥྛནྟི ཏེ མཧཱིདྷྲཾ པྲཏི པལཱཡནྟཱཾ; ");
INSERT INTO santib_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ཏཐཱ ཡོ ནརོ གྲྀཧོཔརི ཏིཥྛཏི ས གྲྀཧམདྷྱཾ ནཱཝརོཧཏུ, ཏཐཱ ཀིམཔི ཝསྟུ གྲཧཱིཏུཾ མདྷྱེགྲྀཧཾ ན པྲཝིཤཏུ; ");
INSERT INTO santib_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ཏཐཱ ཙ ཡོ ནརཿ ཀྵེཏྲེ ཏིཥྛཏི སོཔི སྭཝསྟྲཾ གྲཧཱིཏུཾ པརཱཝྲྀཏྱ ན ཝྲཛཏུ། ");
INSERT INTO santib_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ཏདཱནཱིཾ གརྦྦྷཝཏཱིནཱཾ སྟནྱདཱཏྲཱིཎཱཉྩ ཡོཥིཏཱཾ དུརྒཏི རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ཡུཥྨཱཀཾ པལཱཡནཾ ཤཱིཏཀཱལེ ཡཐཱ ན བྷཝཏི ཏདརྠཾ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ཡཏསྟདཱ ཡཱདྲྀཤཱི དུརྒྷཊནཱ གྷཊིཥྱཏེ ཏཱདྲྀཤཱི དུརྒྷཊནཱ ཨཱིཤྭརསྲྀཥྚེཿ པྲཐམམཱརབྷྱཱདྱ ཡཱཝཏ྄ ཀདཱཔི ན ཛཱཏཱ ན ཛནིཥྱཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ཨཔརཉྩ པརམེཤྭརོ ཡདི ཏསྱ སམཡསྱ སཾཀྵེཔཾ ན ཀརོཏི ཏརྷི ཀསྱཱཔི པྲཱཎབྷྲྀཏོ རཀྵཱ བྷཝིཏུཾ ན ཤཀྵྱཏི, ཀིནྟུ ཡཱན྄ ཛནཱན྄ མནོནཱིཏཱན྄ ཨཀརོཏ྄ ཏེཥཱཾ སྭམནོནཱིཏཱནཱཾ ཧེཏོཿ ས ཏདནེཧསཾ སཾཀྵེཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ཨནྱཙྩ པཤྱཏ ཁྲཱིཥྚོཏྲ སྠཱནེ ཝཱ ཏཏྲ སྠཱནེ ཝིདྱཏེ, ཏསྨིནྐཱལེ ཡདི ཀཤྩིད྄ ཡུཥྨཱན྄ ཨེཏཱདྲྀཤཾ ཝཱཀྱཾ ཝྱཱཧརཏི, ཏརྷི ཏསྨིན྄ ཝཱཀྱེ བྷཻཝ ཝིཤྭསིཏ། ");
INSERT INTO santib_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ཡཏོནེཀེ མིཐྱཱཁྲཱིཥྚཱ མིཐྱཱབྷཝིཥྱདྭཱདིནཤྩ སམུཔསྠཱཡ བཧཱུནི ཙིཧྣཱནྱདྦྷུཏཱནི ཀརྨྨཱཎི ཙ དརྴཡིཥྱནྟི; ཏཐཱ ཡདི སམྦྷཝཏི ཏརྷི མནོནཱིཏལོཀཱནཱམཔི མིཐྱཱམཏིཾ ཛནཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","པཤྱཏ གྷཊནཱཏཿ པཱུཪྻྭཾ སཪྻྭཀཱཪྻྱསྱ ཝཱརྟྟཱཾ ཡུཥྨབྷྱམདཱམ྄, ཡཱུཡཾ སཱཝདྷཱནཱསྟིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ཨཔརཉྩ ཏསྱ ཀླེཤཀཱལསྱཱཝྱཝཧིཏེ པརཀཱལེ བྷཱསྐརཿ སཱནྡྷཀཱརོ བྷཝིཥྱཏི ཏཐཻཝ ཙནྡྲཤྩནྡྲིཀཱཾ ན དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ནབྷཿསྠཱནི ནཀྵཏྲཱཎི པཏིཥྱནྟི, ཝྱོམམཎྜལསྠཱ གྲཧཱཤྩ ཝིཙལིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ཏདཱནཱིཾ མཧཱཔརཱཀྲམེཎ མཧཻཤྭཪྻྱེཎ ཙ མེགྷམཱརུཧྱ སམཱཡཱནྟཾ མཱནཝསུཏཾ མཱནཝཱཿ སམཱིཀྵིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ཨནྱཙྩ ས ནིཛདཱུཏཱན྄ པྲཧིཏྱ ནབྷོབྷཱུམྱོཿ སཱིམཱཾ ཡཱཝད྄ ཛགཏཤྩཏུརྡིགྦྷྱཿ སྭམནོནཱིཏལོཀཱན྄ སཾགྲཧཱིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ཨུཌུམྦརཏརོ རྡྲྀཥྚཱནྟཾ ཤིཀྵདྷྭཾ ཡདོཌུམྦརསྱ ཏརོ རྣཝཱིནཱཿ ཤཱཁཱ ཛཱཡནྟེ པལླཝཱདཱིནི ཙ རྣིགཙྪནྟི, ཏདཱ ནིདཱགྷཀཱལཿ སཝིདྷོ བྷཝཏཱིཏི ཡཱུཡཾ ཛྙཱཏུཾ ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ཏདྭད྄ ཨེཏཱ གྷཊནཱ དྲྀཥྚྭཱ ས ཀཱལོ དྭཱཪྻྱུཔསྠིཏ ཨིཏི ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཨཱདྷུནིཀལོཀཱནཱཾ གམནཱཏ྄ པཱུཪྻྭཾ ཏཱནི སཪྻྭཱཎི གྷཊིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","དྱཱཝཱཔྲྀཐིཝྱོ ཪྻིཙལིཏཡོཿ སཏྱོ རྨདཱིཡཱ ཝཱཎཱི ན ཝིཙལིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ཨཔརཉྩ སྭརྒསྠདཱུཏགཎོ ཝཱ པུཏྲོ ཝཱ ཏཱཏཱདནྱཿ ཀོཔི ཏཾ དིཝསཾ ཏཾ དཎྜཾ ཝཱ ན ཛྙཱཔཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ཨཏཿ ས སམཡཿ ཀདཱ བྷཝིཥྱཏི, ཨེཏཛྫྙཱནཱབྷཱཝཱད྄ ཡཱུཡཾ སཱཝདྷཱནཱསྟིཥྛཏ, སཏརྐཱཤྩ བྷཱུཏྭཱ པྲཱརྠཡདྷྭཾ; ");
INSERT INTO santib_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ཡདྭཏ྄ ཀཤྩིཏ྄ པུམཱན྄ སྭནིཝེཤནཱད྄ དཱུརདེཤཾ པྲཏི ཡཱཏྲཱཀརཎཀཱལེ དཱསེཥུ སྭཀཱཪྻྱསྱ བྷཱརམརྤཡིཏྭཱ སཪྻྭཱན྄ སྭེ སྭེ ཀརྨྨཎི ནིཡོཛཡཏི; ཨཔརཾ དཽཝཱརིཀཾ ཛཱགརིཏུཾ སམཱདིཤྱ ཡཱཏི, ཏདྭན྄ ནརཔུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","གྲྀཧཔཏིཿ སཱཡཾཀཱལེ ནིཤཱིཐེ ཝཱ ཏྲྀཏཱིཡཡཱམེ ཝཱ པྲཱཏཿཀཱལེ ཝཱ ཀདཱགམིཥྱཏི ཏད྄ ཡཱུཡཾ ན ཛཱནཱིཐ; ");
INSERT INTO santib_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ས ཧཋཱདཱགཏྱ ཡཐཱ ཡུཥྨཱན྄ ནིདྲིཏཱན྄ ན པཤྱཏི, ཏདརྠཾ ཛཱགརིཏཱསྟིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ཡུཥྨཱནཧཾ ཡད྄ ཝདཱམི ཏདེཝ སཪྻྭཱན྄ ཝདཱམི, ཛཱགརིཏཱསྟིཥྛཏེཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ཏདཱ ནིསྟཱརོཏྶཝཀིཎྭཧཱིནཔཱུཔོཏྶཝཡོརཱརམྦྷསྱ དིནདྭཡེ ྅ཝཤིཥྚེ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ ཀེནཱཔི ཚལེན ཡཱིཤུཾ དྷརྟྟཱཾ ཧནྟུཉྩ མྲྀགཡཱཉྩཀྲིརེ; ");
INSERT INTO santib_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ཀིནྟུ ལོཀཱནཱཾ ཀལཧབྷཡཱདཱུཙིརེ, ནཙོཏྶཝཀཱལ ཨུཙིཏམེཏདིཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ཨནནྟརཾ བཻཐནིཡཱཔུुརེ ཤིམོནཀུཥྛིནོ གྲྀཧེ ཡོཤཽ བྷོཏྐུམུཔཝིཥྚེ སཏི ཀཱཙིད྄ ཡོཥིཏ྄ པཱཎྜརཔཱཥཱཎསྱ སམྤུཊཀེན མཧཱརྒྷྱོཏྟམཏཻལམ྄ ཨཱནཱིཡ སམྤུཊཀཾ བྷཾཀྟྭཱ ཏསྱོཏྟམཱངྒེ ཏཻལདྷཱརཱཾ པཱཏཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ཏསྨཱཏ྄ ཀེཙིཏ྄ སྭཱནྟེ ཀུཔྱནྟཿ ཀཐིཏཝཾནྟཿ ཀུཏོཡཾ ཏཻལཱཔཝྱཡཿ? ");
INSERT INTO santib_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ཡདྱེཏཏ྄ ཏཻལ ཝྱཀྲེཥྱཏ ཏརྷི མུདྲཱཔཱདཤཏཏྲཡཱདཔྱདྷིཀཾ ཏསྱ པྲཱཔྟམཱུལྱཾ དརིདྲལོཀེབྷྱོ དཱཏུམཤཀྵྱཏ, ཀཐཱམེཏཱཾ ཀཐཡིཏྭཱ ཏཡཱ ཡོཥིཏཱ སཱཀཾ ཝཱཙཱཡུཧྱན྄། ");
INSERT INTO santib_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ཀིནྟུ ཡཱིཤུརུཝཱཙ, ཀུཏ ཨེཏསྱཻ ཀྲྀཙྪྲཾ དདཱསི? མཧྱམིཡཾ ཀརྨྨོཏྟམཾ ཀྲྀཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","དརིདྲཱཿ སཪྻྭདཱ ཡུཥྨཱབྷིཿ སཧ ཏིཥྛནྟི, ཏསྨཱད྄ ཡཱུཡཾ ཡདེཙྪཐ ཏདཻཝ ཏཱནུཔཀརྟྟཱཾ ཤཀྣུཐ, ཀིནྟྭཧཾ ཡུབྷཱབྷིཿ སཧ ནིརནྟརཾ ན ཏིཥྛཱམི། ");
INSERT INTO santib_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ཨསྱཱ ཡཐཱསཱདྷྱཾ ཏཐཻཝཱཀརོདིཡཾ, ཤྨཤཱནཡཱཔནཱཏ྄ པཱུཪྻྭཾ སམེཏྱ མདྭཔུཥི ཏཻལམ྄ ཨམརྡྡཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ཨཧཾ ཡུཥྨབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི, ཛགཏཱཾ མདྷྱེ ཡཏྲ ཡཏྲ སུསཾཝཱདོཡཾ པྲཙཱརཡིཥྱཏེ ཏཏྲ ཏཏྲ ཡོཥིཏ ཨེཏསྱཱཿ སྨརཎཱརྠཾ ཏཏྐྲྀཏཀརྨྨཻཏཏ྄ པྲཙཱརཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ཏཏཿ པརཾ དྭཱདཤཱནཱཾ ཤིཥྱཱཎཱམེཀ ཨཱིཥྐརིཡོཏཱིཡཡིཧཱུདཱཁྱོ ཡཱིཤུཾ པརཀརེཥུ སམརྤཡིཏུཾ པྲདྷཱནཡཱཛཀཱནཱཾ སམཱིཔམིཡཱཡ། ");
INSERT INTO santib_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ཏེ ཏསྱ ཝཱཀྱཾ སམཱཀརྞྱ སནྟུཥྚཱཿ སནྟསྟསྨཻ མུདྲཱ དཱཏུཾ པྲཏྱཛཱནཏ; ཏསྨཱཏ྄ ས ཏཾ ཏེཥཱཾ ཀརེཥུ སམརྤཎཱཡོཔཱཡཾ མྲྀགཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ཨནནྟརཾ ཀིཎྭཤཱུནྱཔཱུཔོཏྶཝསྱ པྲཐམེ྅ཧནི ནིསྟཱརོཏྨཝཱརྠཾ མེཥམཱརཎཱསམཡེ ཤིཥྱཱསྟཾ པཔྲཙྪཿ ཀུཏྲ གཏྭཱ ཝཡཾ ནིསྟཱརོཏྶཝསྱ བྷོཛྱམཱསཱདཡིཥྱཱམཿ? ཀིམིཙྪཏི བྷཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ཏདཱནཱིཾ ས ཏེཥཱཾ དྭཡཾ པྲེརཡན྄ བབྷཱཥེ ཡུཝཡོཿ པུརམདྷྱཾ གཏཡོཿ སཏོ ཪྻོ ཛནཿ སཛལཀུམྦྷཾ ཝཧན྄ ཡུཝཱཾ སཱཀྵཱཏ྄ ཀརིཥྱཏི ཏསྱཻཝ པཤྩཱད྄ ཡཱཏཾ; ");
INSERT INTO santib_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ས ཡཏ྄ སདནཾ པྲཝེཀྵྱཏི ཏདྦྷཝནཔཏིཾ ཝདཏཾ, གུརུརཱཧ ཡཏྲ སཤིཥྱོཧཾ ནིསྟཱརོཏྶཝཱིཡཾ བྷོཛནཾ ཀརིཥྱཱམི, སཱ བྷོཛནཤཱལཱ ཀུཏྲཱསྟི? ");
INSERT INTO santib_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ཏཏཿ ས པརིཥྐྲྀཏཱཾ སུསཛྫིཏཱཾ བྲྀཧཏཱིཙཉྩ ཡཱཾ ཤཱལཱཾ དརྴཡིཥྱཏི ཏསྱཱམསྨདརྠཾ བྷོཛྱདྲཝྱཱཎྱཱསཱདཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ཏཏཿ ཤིཥྱཽ པྲསྠཱཡ པུརཾ པྲཝིཤྱ ས ཡཐོཀྟཝཱན྄ ཏཐཻཝ པྲཱཔྱ ནིསྟཱརོཏྶཝསྱ བྷོཛྱདྲཝྱཱཎི སམཱསཱདཡེཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ཨནནྟརཾ ཡཱིཤུཿ སཱཡཾཀཱལེ དྭཱདཤབྷིཿ ཤིཥྱཻཿ སཱརྡྡྷཾ ཛགཱམ; ");
INSERT INTO santib_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","སཪྻྭེཥུ བྷོཛནཱཡ པྲོཔཝིཥྚེཥུ ས ཏཱནུདིཏཝཱན྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝྱཱཧརཱམི, ཨཏྲ ཡུཥྨཱཀམེཀོ ཛནོ ཡོ མཡཱ སཧ བྷུཾཀྟེ མཱཾ པརཀེརེཥུ སམརྤཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ཏདཱནཱིཾ ཏེ དུཿཁིཏཱཿ སནྟ ཨེཀཻཀཤསྟཾ པྲཥྚུམཱརབྡྷཝནྟཿ ས ཀིམཧཾ? པཤྩཱད྄ ཨནྱ ཨེཀོབྷིདདྷེ ས ཀིམཧཾ? ");
INSERT INTO santib_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ཏཏཿ ས པྲཏྱཝདད྄ ཨེཏེཥཱཾ དྭཱདཤཱནཱཾ ཡོ ཛནོ མཡཱ སམཾ བྷོཛནཱཔཱཏྲེ པཱཎིཾ མཛྫཡིཥྱཏི ས ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","མནུཛཏནཡམདྷི ཡཱདྲྀཤཾ ལིཁིཏམཱསྟེ ཏདནུརཱུཔཱ གཏིསྟསྱ བྷཝིཥྱཏི, ཀིནྟུ ཡོ ཛནོ མཱནཝསུཏཾ སམརྤཡིཥྱཏེ ཧནྟ ཏསྱ ཛནྨཱབྷཱཝེ སཏི བྷདྲམབྷཝིཥྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ཨཔརཉྩ ཏེཥཱཾ བྷོཛནསམཡེ ཡཱིཤུཿ པཱུཔཾ གྲྀཧཱིཏྭེཤྭརགུཎཱན྄ ཨནུཀཱིརྟྱ བྷངྐྟྭཱ ཏེབྷྱོ དཏྟྭཱ བབྷཱཥེ, ཨེཏད྄ གྲྀཧཱིཏྭཱ བྷུཉྫཱིདྷྭམ྄ ཨེཏནྨམ ཝིགྲཧརཱུཔཾ། ");
INSERT INTO santib_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ཨནནྟརཾ ས ཀཾསཾ གྲྀཧཱིཏྭེཤྭརསྱ གུཎཱན྄ ཀཱིརྟྟཡིཏྭཱ ཏེབྷྱོ དདཽ, ཏཏསྟེ སཪྻྭེ པཔུཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ཨཔརཾ ས ཏཱནཝཱདཱིད྄ བཧཱུནཱཾ ནིམིཏྟཾ པཱཏིཏཾ མམ ནཝཱིནནིཡམརཱུཔཾ ཤོཎིཏམེཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཨཱིཤྭརསྱ རཱཛྱེ ཡཱཝཏ྄ སདྱོཛཱཏཾ དྲཱཀྵཱརསཾ ན པཱསྱཱམི,ཏཱཝདཧཾ དྲཱཀྵཱཕལརསཾ པུན རྣ པཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ཏདནནྟརཾ ཏེ གཱིཏམེཀཾ སཾགཱིཡ བཧི རྫཻཏུནཾ ཤིཁརིཎཾ ཡཡུཿ ");
INSERT INTO santib_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ཨཐ ཡཱིཤུསྟཱནུཝཱཙ ནིཤཱཡཱམསྱཱཾ མཡི ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ པྲཏྱཱུཧོ བྷཝིཥྱཏི ཡཏོ ལིཁིཏམཱསྟེ ཡཐཱ, མེཥཱཎཱཾ རཀྵཀཉྩཱཧཾ པྲཧརིཥྱཱམི ཝཻ ཏཏཿ། མེཥཱཎཱཾ ནིཝཧོ ནཱུནཾ པྲཝིཀཱིརྞོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ཀནྟུ མདུཏྠཱནེ ཛཱཏེ ཡུཥྨཱཀམགྲེ྅ཧཾ གཱལཱིལཾ ཝྲཛིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ཏདཱ པིཏརཿ པྲཏིབབྷཱཥེ, ཡདྱཔི སཪྻྭེཥཱཾ པྲཏྱཱུཧོ བྷཝཏི ཏཐཱཔི མམ ནཻཝ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ཏཏོ ཡཱིཤུརུཀྟཱཝཱན྄ ཨཧཾ ཏུབྷྱཾ ཏཐྱཾ ཀཐཡཱམི, ཀྵཎཱདཱཡཱམདྱ ཀུཀྐུཊསྱ དྭིཏཱིཡཝཱརརཝཎཱཏ྄ པཱུཪྻྭཾ ཏྭཾ ཝཱརཏྲཡཾ མཱམཔཧྣོཥྱསེ། ");
INSERT INTO santib_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ཀིནྟུ ས གཱཌྷཾ ཝྱཱཧརད྄ ཡདྱཔི ཏྭཡཱ སཱརྡྡྷཾ མམ པྲཱཎོ ཡཱཏི ཏཐཱཔི ཀཐམཔི ཏྭཱཾ ནཱཔཧྣོཥྱེ; སཪྻྭེ྅པཱིཏརེ ཏཐཻཝ བབྷཱཥིརེ། ");
INSERT INTO santib_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ཨཔརཉྩ ཏེཥུ གེཏྴིམཱནཱིནཱམཀཾ སྠཱན གཏེཥུ ས ཤིཥྱཱན྄ ཛགཱད, ཡཱཝདཧཾ པྲཱརྠཡེ ཏཱཝདཏྲ སྠཱནེ ཡཱུཡཾ སམུཔཝིཤཏ། ");
INSERT INTO santib_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ཨཐ ས པིཏརཾ ཡཱཀཱུབཾ ཡོཧནཉྩ གྲྀཧཱིཏྭཱ ཝཝྲཱཛ; ཨཏྱནྟཾ ཏྲཱསིཏོ ཝྱཱཀུལིཏཤྩ ཏེབྷྱཿ ཀཐཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ནིདྷནཀཱལཝཏ྄ པྲཱཎོ མེ྅ཏཱིཝ དཿཁམེཏི, ཡཱུཡཾ ཛཱགྲཏོཏྲ སྠཱནེ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ཏཏཿ ས ཀིཉྩིདྡཱུརཾ གཏྭཱ བྷཱུམཱཝདྷོམུཁཿ པཏིཏྭཱ པྲཱརྠིཏཝཱནེཏཏ྄, ཡདི བྷཝིཏུཾ ཤཀྱཾ ཏརྷི དུཿཁསམཡོཡཾ མཏྟོ དཱུརཱིབྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ཨཔརམུདིཏཝཱན྄ ཧེ པིཏ རྷེ པིཏཿ སཪྻྭེཾ ཏྭཡཱ སཱདྷྱཾ, ཏཏོ ཧེཏོརིམཾ ཀཾསཾ མཏྟོ དཱུརཱིཀུརུ, ཀིནྟུ ཏན྄ མམེཙྪཱཏོ ན ཏཝེཙྪཱཏོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ཏཏཿ པརཾ ས ཨེཏྱ ཏཱན྄ ནིདྲིཏཱན྄ ནིརཱིཀྵྱ པིཏརཾ པྲོཝཱཙ, ཤིམོན྄ ཏྭཾ ཀིཾ ནིདྲཱསི? གྷཊིཀཱམེཀཱམ྄ ཨཔི ཛཱགརིཏུཾ ན ཤཀྣོཥི? ");
INSERT INTO santib_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","པརཱིཀྵཱཡཱཾ ཡཐཱ ན པཏཐ ཏདརྠཾ སཙེཏནཱཿ སནྟཿ པྲཱརྠཡདྷྭཾ; མན ཨུདྱུཀྟམིཏི སཏྱཾ ཀིནྟུ ཝཔུརཤཀྟིཀཾ། ");
INSERT INTO santib_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ཨཐ ས པུནཪྻྲཛིཏྭཱ པཱུཪྻྭཝཏ྄ པྲཱརྠཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","པརཱཝྲྀཏྱཱགཏྱ པུནརཔི ཏཱན྄ ནིདྲིཏཱན྄ དདརྴ ཏདཱ ཏེཥཱཾ ལོཙནཱནི ནིདྲཡཱ པཱུརྞཱནི, ཏསྨཱཏྟསྨཻ ཀཱ ཀཐཱ ཀཐཡིཏཝྱཱ ཏ ཨེཏད྄ བོདྡྷུཾ ན ཤེཀུཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ཏཏཿཔརཾ ཏྲྀཏཱིཡཝཱརཾ ཨཱགཏྱ ཏེབྷྱོ ྅ཀཐཡད྄ ཨིདཱནཱིམཔི ཤཡིཏྭཱ ཝིཤྲཱམྱཐ? ཡཐེཥྚཾ ཛཱཏཾ, སམཡཤྩོཔསྠིཏཿ པཤྱཏ མཱནཝཏནཡཿ པཱཔིལོཀཱནཱཾ པཱཎིཥུ སམརྤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ཨུཏྟིཥྛཏ, ཝཡཾ ཝྲཛཱམོ ཡོ ཛནོ མཱཾ པརཔཱཎིཥུ སམརྤཡིཥྱཏེ པཤྱཏ ས སམཱིཔམཱཡཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ཨིམཱཾ ཀཐཱཾ ཀཐཡཏི ས, ཨེཏརྷིདྭཱདཤཱནཱམེཀོ ཡིཧཱུདཱ ནཱམཱ ཤིཥྱཿ པྲདྷཱནཡཱཛཀཱནཱམ྄ ཨུཔཱདྷྱཱཡཱནཱཾ པྲཱཙཱིནལོཀཱནཱཉྩ སནྣིདྷེཿ ཁངྒལགུཌདྷཱརིཎོ བཧུལོཀཱན྄ གྲྀཧཱིཏྭཱ ཏསྱ སམཱིཔ ཨུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ཨཔརཉྩཱསཽ པརཔཱཎིཥུ སམརྤཡིཏཱ པཱུཪྻྭམིཏི སངྐེཏཾ ཀྲྀཏཝཱན྄ ཡམཧཾ ཙུམྦིཥྱཱམི ས ཨེཝཱསཽ ཏམེཝ དྷྲྀཏྭཱ སཱཝདྷཱནཾ ནཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ཨཏོ ཧེཏོཿ ས ཨཱགཏྱཻཝ ཡོཤོཿ སཝིདྷཾ གཏྭཱ ཧེ གུརོ ཧེ གུརོ, ཨིཏྱུཀྟྭཱ ཏཾ ཙུཙུམྦ། ");
INSERT INTO santib_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ཏདཱ ཏེ ཏདུཔརི པཱཎཱིནརྤཡིཏྭཱ ཏཾ དདྷྣུཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ཏཏསྟསྱ པཱརྴྭསྠཱནཱཾ ལོཀཱནཱམེཀཿ ཁངྒཾ ནིཥྐོཥཡན྄ མཧཱཡཱཛཀསྱ དཱསམེཀཾ པྲཧྲྀཏྱ ཏསྱ ཀརྞཾ ཙིཙྪེད། ");
INSERT INTO santib_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","པཤྩཱད྄ ཡཱིཤུསྟཱན྄ ཝྱཱཛཧཱར ཁངྒཱན྄ ལགུཌཱཾཤྩ གྲྀཧཱིཏྭཱ མཱཾ ཀིཾ ཙཽརཾ དྷརྟྟཱཾ སམཱཡཱཏཱཿ? ");
INSERT INTO santib_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","མདྷྱེམནྡིརཾ སམུཔདིཤན྄ པྲཏྱཧཾ ཡུཥྨཱབྷིཿ སཧ སྠིཏཝཱནཏཧཾ, ཏསྨིན྄ ཀཱལེ ཡཱུཡཾ མཱཾ ནཱདཱིདྷརཏ, ཀིནྟྭནེན ཤཱསྟྲཱིཡཾ ཝཙནཾ སེདྷནཱིཡཾ། ");
INSERT INTO santib_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ཏདཱ སཪྻྭེ ཤིཥྱཱསྟཾ པརིཏྱཛྱ པལཱཡཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ཨཐཻཀོ ཡུཝཱ མཱནཝོ ནགྣཀཱཡེ ཝསྟྲམེཀཾ ནིདྷཱཡ ཏསྱ པཤྩཱད྄ ཝྲཛན྄ ཡུཝལོཀཻ རྡྷྲྀཏོ ");
INSERT INTO santib_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ཝསྟྲཾ ཝིཧཱཡ ནགྣཿ པལཱཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ཨཔརཉྩ ཡསྨིན྄ སྠཱནེ པྲདྷཱནཡཱཛཀཱ ཨུཔཱདྷྱཱཡཱཿ པྲཱཙཱིནལོཀཱཤྩ མཧཱཡཱཛཀེན སཧ སདསི སྠིཏཱསྟསྨིན྄ སྠཱནེ མཧཱཡཱཛཀསྱ སམཱིཔཾ ཡཱིཤུཾ ནིནྱུཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","པིཏརོ དཱུརེ ཏཏྤཤྩཱད྄ ཨིཏྭཱ མཧཱཡཱཛཀསྱཱཊྚཱལིཀཱཾ པྲཝིཤྱ ཀིངྐརཻཿ སཧོཔཝིཤྱ ཝཧྣིཏཱཔཾ ཛགྲཱཧ། ");
INSERT INTO santib_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ཏདཱནཱིཾ པྲདྷཱནཡཱཛཀཱ མནྟྲིཎཤྩ ཡཱིཤུཾ གྷཱཏཡིཏུཾ ཏཏྤྲཱཏིཀཱུལྱེན སཱཀྵིཎོ མྲྀགཡཱཉྩཀྲིརེ, ཀིནྟུ ན པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ཨནེཀཻསྟདྭིརུདྡྷཾ མྲྀཥཱསཱཀྵྱེ དཏྟེཔི ཏེཥཱཾ ཝཱཀྱཱནི ན སམགཙྪནྟ། ");
INSERT INTO santib_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","སཪྻྭཤེཥེ ཀིཡནྟ ཨུཏྠཱཡ ཏསྱ པྲཱཏིཀཱུལྱེན མྲྀཥཱསཱཀྵྱཾ དཏྟྭཱ ཀཐཡཱམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ཨིདཾ ཀརཀྲྀཏམནྡིརཾ ཝིནཱཤྱ དིནཏྲཡམདྷྱེ པུནརཔརམ྄ ཨཀརཀྲྀཏཾ མནྡིརཾ ནིརྨྨཱསྱཱམི, ཨིཏི ཝཱཀྱམ྄ ཨསྱ མུཁཱཏ྄ ཤྲུཏམསྨཱབྷིརིཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ཀིནྟུ ཏཏྲཱཔི ཏེཥཱཾ སཱཀྵྱཀཐཱ ན སངྒཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ཨཐ མཧཱཡཱཛཀོ མདྷྱེསབྷམ྄ ཨུཏྠཱཡ ཡཱིཤུཾ ཝྱཱཛཧཱར, ཨེཏེ ཛནཱསྟྭཡི ཡཏ྄ སཱཀྵྱམདུཿ ཏྭམེཏསྱ ཀིམཔྱུཏྟརཾ ཀིཾ ན དཱསྱསི? ");
INSERT INTO santib_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ཀིནྟུ ས ཀིམཔྱུཏྟརཾ ན དཏྭཱ མཽནཱིབྷཱུཡ ཏསྱཽ; ཏཏོ མཧཱཡཱཛཀཿ པུནརཔི ཏཾ པྲྀཥྚཱཝཱན྄ ཏྭཾ སཙྩིདཱནནྡསྱ ཏནཡོ ྅བྷིཥིཀྟསྟྲཏཱ? ");
INSERT INTO santib_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ཏདཱ ཡཱིཤུསྟཾ པྲོཝཱཙ བྷཝཱམྱཧམ྄ ཡཱུཡཉྩ སཪྻྭཤཀྟིམཏོ དཀྵཱིཎཔཱརྴྭེ སམུཔཝིཤནྟཾ མེགྷ མཱརུཧྱ སམཱཡཱནྟཉྩ མནུཥྱཔུཏྲཾ སནྡྲཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ཏདཱ མཧཱཡཱཛཀཿ སྭཾ ཝམནཾ ཚིཏྭཱ ཝྱཱཝཧརཏ྄ ");
INSERT INTO santib_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ཀིམསྨཱཀཾ སཱཀྵིབྷིཿ པྲཡོཛནམ྄? ཨཱིཤྭརནིནྡཱཝཱཀྱཾ ཡུཥྨཱབྷིརཤྲཱཝི ཀིཾ ཝིཙཱརཡཐ? ཏདཱནཱིཾ སཪྻྭེ ཛགདུརཡཾ ནིདྷནདཎྜམརྷཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ཏཏཿ ཀཤྩིཏ྄ ཀཤྩིཏ྄ ཏདྭཔུཥི ནིཥྛཱིཝཾ ནིཙིཀྵེཔ ཏཐཱ ཏནྨུཁམཱཙྪཱདྱ ཙཔེཊེན ཧཏྭཱ གདིཏཝཱན྄ གཎཡིཏྭཱ ཝད, ཨནུཙརཱཤྩ ཙཔེཊཻསྟམཱཛགྷྣུཿ ");
INSERT INTO santib_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ཏཏཿ པརཾ པིཏརེ྅ཊྚཱལིཀཱདྷཿཀོཥྛེ ཏིཥྛཏི མཧཱཡཱཛཀསྱཻཀཱ དཱསཱི སམེཏྱ ");
INSERT INTO santib_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ཏཾ ཝིཧྣིཏཱཔཾ གྲྀཧླནྟཾ ཝིལོཀྱ ཏཾ སུནིརཱིཀྵྱ བབྷཱཥེ ཏྭམཔི ནཱསརཏཱིཡཡཱིཤོཿ སངྒིནཱམ྄ ཨེཀོ ཛན ཨཱསཱིཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ཀིནྟུ སོཔཧྣུཏྱ ཛགཱད ཏམཧཾ ན ཝདྨི ཏྭཾ ཡཏ྄ ཀཐཡམི ཏདཔྱཧཾ ན བུདྡྷྱེ། ཏདཱནཱིཾ པིཏརེ ཙཏྭརཾ གཏཝཏི ཀུेཀྐུཊོ རུརཱཝ། ");
INSERT INTO santib_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ཨཐཱནྱཱ དཱསཱི པིཏརཾ དྲྀཥྚྭཱ སམཱིཔསྠཱན྄ ཛནཱན྄ ཛགཱད ཨཡཾ ཏེཥཱམེཀོ ཛནཿ། ");
INSERT INTO santib_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ཏཏཿ ས དྭིཏཱིཡཝཱརམ྄ ཨཔཧྣུཏཝཱན྄ པཤྩཱཏ྄ ཏཏྲསྠཱ ལོཀཱཿ པིཏརཾ པྲོཙུསྟྭམཝཤྱཾ ཏེཥཱམེཀོ ཛནཿ ཡཏསྟྭཾ གཱལཱིལཱིཡོ ནར ཨིཏི ཏཝོཙྩཱརཎཾ པྲཀཱཤཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ཏདཱ ས ཤཔཐཱབྷིཤཱཔཽ ཀྲྀཏྭཱ པྲོཝཱཙ ཡཱུཡཾ ཀཐཱཾ ཀཐཡཐ ཏཾ ནརཾ ན ཛཱནེ྅ཧཾ། ");
INSERT INTO santib_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ཏདཱནཱིཾ དྭིཏཱིཡཝཱརཾ ཀུཀྐུཊོ ྅རཱཝཱིཏ྄། ཀུཀྐུཊསྱ དྭིཏཱིཡརཝཱཏ྄ པཱུཪྻྭཾ ཏྭཾ མཱཾ ཝཱརཏྲཡམ྄ ཨཔཧྣོཥྱསི, ཨིཏི ཡདྭཱཀྱཾ ཡཱིཤུནཱ སམུདིཏཾ ཏཏ྄ ཏདཱ སཾསྨྲྀཏྱ པིཏརོ རོདིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ཨཐ པྲབྷཱཏེ སཏི པྲདྷཱནཡཱཛཀཱཿ པྲཱཉྩ ཨུཔཱདྷྱཱཡཱཿ སཪྻྭེ མནྟྲིཎཤྩ སབྷཱཾ ཀྲྀཏྭཱ ཡཱིཤུृཾ བནྡྷཡིཏྭ པཱིལཱཏཱཁྱསྱ དེཤཱདྷིཔཏེཿ སཝིདྷཾ ནཱིཏྭཱ སམརྤཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ཏདཱ པཱིལཱཏསྟཾ པྲྀཥྚཝཱན྄ ཏྭཾ ཀིཾ ཡིཧཱུདཱིཡལོཀཱནཱཾ རཱཛཱ? ཏཏཿ ས པྲཏྱུཀྟཝཱན྄ སཏྱཾ ཝདསི། ");
INSERT INTO santib_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ཨཔརཾ པྲདྷཱནཡཱཛཀཱསྟསྱ བཧུཥུ ཝཱཀྱེཥུ དོཥམཱརོཔཡཱཉྩཀྲུཿ ཀིནྟུ ས ཀིམཔི ན པྲཏྱུཝཱཙ། ");
INSERT INTO santib_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ཏདཱནཱིཾ པཱིལཱཏསྟཾ པུནཿ པཔྲཙྪ ཏྭཾ ཀིཾ ནོཏྟརཡསི? པཤྱཻཏེ ཏྭདྭིརུདྡྷཾ ཀཏིཥུ སཱདྷྱེཥུ སཱཀྵཾ དདཏི། ");
INSERT INTO santib_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ཀནྟུ ཡཱིཤུསྟདཱཔི ནོཏྟརཾ དདཽ ཏཏཿ པཱིལཱཏ ཨཱཤྩཪྻྱཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ཨཔརཉྩ ཀཱརཱབདྡྷེ ཀསྟིཾཤྩིཏ྄ ཛནེ ཏནྨཧོཏྶཝཀཱལེ ལོཀཻ ཪྻཱཙིཏེ དེཤཱདྷིཔཏིསྟཾ མོཙཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ཡེ ཙ པཱུཪྻྭམུཔཔླཝམཀཱརྵུརུཔཔླཝེ ཝདྷམཔི ཀྲྀཏཝནྟསྟེཥཱཾ མདྷྱེ ཏདཱནོཾ བརབྦཱནཱམཀ ཨེཀོ བདྡྷ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ཨཏོ ཧེཏོཿ པཱུཪྻྭཱཔརཱིཡཱཾ རཱིཏིཀཐཱཾ ཀཐཡིཏྭཱ ལོཀཱ ཨུཙྩཻརུཝནྟཿ པཱིལཱཏསྱ སམཀྵཾ ནིཝེདཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ཏདཱ པཱིལཱཏསྟཱནཱཙཁྱཽ ཏརྷི ཀིཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱནཾ མོཙཡིཥྱཱམི? ཡུཥྨཱབྷིཿ ཀིམིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ཡཏཿ པྲདྷཱནཡཱཛཀཱ ཨཱིརྵྱཱཏ ཨེཝ ཡཱིཤུཾ སམཱརྤཡནྣིཏི ས ཝིཝེད། ");
INSERT INTO santib_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ཀིནྟུ ཡཐཱ བརབྦཱཾ མོཙཡཏི ཏཐཱ པྲཱརྠཡིཏུཾ པྲདྷཱནཡཱཛཀཱ ལོཀཱན྄ པྲཝརྟྟཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ཨཐ པཱིལཱཏཿ པུནཿ པྲྀཥྚཝཱན྄ ཏརྷི ཡཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛེཏི ཝདཐ ཏསྱ ཀིཾ ཀརིཥྱཱམི ཡུཥྨཱབྷིཿ ཀིམིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ཏདཱ ཏེ པུནརཔི པྲོཙྩཻཿ པྲོཙུསྟཾ ཀྲུཤེ ཝེདྷཡ། ");
INSERT INTO santib_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ཏསྨཱཏ྄ པཱིལཱཏཿ ཀཐིཏཝཱན྄ ཀུཏཿ? ས ཀིཾ ཀུཀརྨྨ ཀྲྀཏཝཱན྄? ཀིནྟུ ཏེ པུནཤྩ རུཝནྟོ ཝྱཱཛཧྲུསྟཾ ཀྲུཤེ ཝེདྷཡ། ");
INSERT INTO santib_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ཏདཱ པཱིལཱཏཿ སཪྻྭཱལློཀཱན྄ ཏོཥཡིཏུམིཙྪན྄ བརབྦཱཾ མོཙཡིཏྭཱ ཡཱིཤུཾ ཀཤཱབྷིཿ པྲཧྲྀཏྱ ཀྲུཤེ ཝེདྡྷུཾ ཏཾ སམརྤཡཱམྦབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ཨནནྟརཾ སཻནྱགཎོ྅ཊྚཱལིཀཱམ྄ ཨརྠཱད྄ ཨདྷིཔཏེ རྒྲྀཧཾ ཡཱིཤུཾ ནཱིཏྭཱ སེནཱནིཝཧཾ སམཱཧུཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","པཤྩཱཏ྄ ཏེ ཏཾ དྷཱུམལཝརྞཝསྟྲཾ པརིདྷཱཔྱ ཀཎྚཀམུཀུཊཾ རཙཡིཏྭཱ ཤིརསི སམཱརོཔྱ ");
INSERT INTO santib_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ཧེ ཡིཧཱུདཱིཡཱནཱཾ རཱཛན྄ ནམསྐཱར ཨིཏྱུཀྟྭཱ ཏཾ ནམསྐརྟྟཱམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ཏསྱོཏྟམཱངྒེ ཝེཏྲཱགྷཱཏཾ ཙཀྲུསྟདྒཱཏྲེ ནིཥྛཱིཝཉྩ ནིཙིཀྵིཔུཿ, ཏཐཱ ཏསྱ སམྨུཁེ ཛཱནུཔཱཏཾ པྲཎོམུཿ ");
INSERT INTO santib_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ཨིཏྠམུཔཧསྱ དྷཱུམྲཝརྞཝསྟྲམ྄ ཨུཏྟཱཪྻྱ ཏསྱ ཝསྟྲཾ ཏཾ པཪྻྱདྷཱཔཡན྄ ཀྲུཤེ ཝེདྡྷུཾ བཧིརྣིནྱུཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ཏཏཿ པརཾ སེཀནྡརསྱ རུཕསྱ ཙ པིཏཱ ཤིམོནྣཱམཱ ཀུརཱིཎཱིཡལོཀ ཨེཀཿ ཀུཏཤྩིད྄ གྲཱམཱདེཏྱ པཐི ཡཱཏི ཏཾ ཏེ ཡཱིཤོཿ ཀྲུཤཾ ཝོཌྷུཾ བལཱད྄ དདྷྣུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ཨཐ གུལྒལྟཱ ཨརྠཱཏ྄ ཤིརཿཀཔཱལནཱམཀཾ སྠཱནཾ ཡཱིཤུམཱནཱིཡ ");
INSERT INTO santib_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ཏེ གནྡྷརསམིཤྲིཏཾ དྲཱཀྵཱརསཾ པཱཏུཾ ཏསྨཻ དདུཿ ཀིནྟུ ས ན ཛགྲཱཧ། ");
INSERT INTO santib_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ཏསྨིན྄ ཀྲུཤེ ཝིདྡྷེ སཏི ཏེཥཱམེཀཻཀཤཿ ཀིཾ པྲཱཔྶྱཏཱིཏི ནིརྞཡཱཡ ");
INSERT INTO santib_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ཏསྱ པརིདྷེཡཱནཱཾ ཝིབྷཱགཱརྠཾ གུཊིཀཱཔཱཏཾ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ཨཔརམ྄ ཨེཥ ཡིཧཱུདཱིཡཱནཱཾ རཱཛེཏི ལིཁིཏཾ དོཥཔཏྲཾ ཏསྱ ཤིརཨཱུརྡྭྭམ྄ ཨཱརོཔཡཱཉྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ཏསྱ ཝཱམདཀྵིཎཡོ རྡྭཽ ཙཽརཽ ཀྲུཤཡོ ཪྻིཝིདྷཱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ཏེནཻཝ \"ཨཔརཱདྷིཛནཻཿ སཱརྡྡྷཾ ས གཎིཏོ བྷཝིཥྱཏི,\" ཨིཏི ཤཱསྟྲོཀྟཾ ཝཙནཾ སིདྡྷམབྷཱུཏ། ");
INSERT INTO santib_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ཨནནྟརཾ མཱརྒེ ཡེ ཡེ ལོཀཱ གམནཱགམནེ ཙཀྲུསྟེ སཪྻྭ ཨེཝ ཤིརཱཾསྱཱནྡོལྱ ནིནྡནྟོ ཛགདུཿ, རེ མནྡིརནཱཤཀ རེ དིནཏྲཡམདྷྱེ ཏནྣིརྨྨཱཡཀ, ");
INSERT INTO santib_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ཨདྷུནཱཏྨཱནམ྄ ཨཝིཏྭཱ ཀྲུཤཱདཝརོཧ། ");
INSERT INTO santib_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ཀིཉྩ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ ཏདྭཏ྄ ཏིརསྐྲྀཏྱ པརསྤརཾ ཙཙཀྵིརེ ཨེཥ པརཱནཱཝཏ྄ ཀིནྟུ སྭམཝིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ཡདཱིསྲཱཡེལོ རཱཛཱབྷིཥིཀྟསྟྲཱཏཱ བྷཝཏི ཏརྷྱདྷུནཻན ཀྲུཤཱདཝརོཧཏུ ཝཡཾ ཏད྄ དྲྀཥྚྭཱ ཝིཤྭསིཥྱཱམཿ; ཀིཉྩ ཡཽ ལོཀཽ ཏེན སཱརྡྡྷཾ ཀྲུཤེ ྅ཝིདྷྱེཏཱཾ ཏཱཝཔི ཏཾ ནིརྦྷརྟྶཡཱམཱསཏུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ཨཐ དྭིཏཱིཡཡཱམཱཏ྄ ཏྲྀཏཱིཡཡཱམཾ ཡཱཝཏ྄ སཪྻྭོ དེཤཿ སཱནྡྷཀཱརོབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ཏཏསྟྲྀཏཱིཡཔྲཧརེ ཡཱིཤུརུཙྩཻརཝདཏ྄ ཨེལཱི ཨེལཱི ལཱམཱ ཤིཝཀྟནཱི ཨརྠཱད྄ \"ཧེ མདཱིཤ མདཱིཤ ཏྭཾ པཪྻྱཏྱཱཀྵཱིཿ ཀུཏོ ཧི མཱཾ?\" ");
INSERT INTO santib_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ཏདཱ སམཱིཔསྠལོཀཱནཱཾ ཀེཙིཏ྄ ཏདྭཱཀྱཾ ནིཤམྱཱཙཁྱུཿ པཤྱཻཥ ཨེལིཡམ྄ ཨཱཧཱུཡཏི། ");
INSERT INTO santib_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ཏཏ ཨེཀོ ཛནོ དྷཱཝིཏྭཱགཏྱ སྤཉྫེ ྅མླརསཾ པཱུརཡིཏྭཱ ཏཾ ནཌཱགྲེ ནིདྷཱཡ པཱཏུཾ ཏསྨཻ དཏྟྭཱཝདཏ྄ ཏིཥྛ ཨེལིཡ ཨེནམཝརོཧཡིཏུམ྄ ཨེཏི ན ཝེཏི པཤྱཱམི། ");
INSERT INTO santib_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ཨཐ ཡཱིཤུརུཙྩཻཿ སམཱཧཱུཡ པྲཱཎཱན྄ ཛཧཽ། ");
INSERT INTO santib_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ཏདཱ མནྡིརསྱ ཛཝནིཀོརྡྭྭཱདདྷཿཪྻྱནྟཱ ཝིདཱིརྞཱ དྭིཁཎྜཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ཀིཉྩ ཨིཏྠམུཙྩཻརཱཧཱུཡ པྲཱཎཱན྄ ཏྱཛནྟཾ ཏཾ དྲྀཥྡྭཱ ཏདྲཀྵཎཱཡ ནིཡུཀྟོ ཡཿ སེནཱཔཏིརཱསཱིཏ྄ སོཝདཏ྄ ནརོཡམ྄ ཨཱིཤྭརཔུཏྲ ཨིཏི སཏྱམ྄། ");
INSERT INTO santib_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ཏདཱནཱིཾ མགྡལཱིནཱི མརིསམ྄ ཀནིཥྛཡཱཀཱུབོ ཡོསེཤྩ མཱཏཱནྱམརིཡམ྄ ཤཱལོམཱི ཙ ཡཱཿ སྟྲིཡོ ");
INSERT INTO santib_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","གཱལཱིལྤྲདེཤེ ཡཱིཤུཾ སེཝིཏྭཱ ཏདནུགཱམིནྱོ ཛཱཏཱ ཨིམཱསྟདནྱཱཤྩ ཡཱ ཨནེཀཱ ནཱཪྻོ ཡཱིཤུནཱ སཱརྡྡྷཾ ཡིརཱུཤཱལམམཱཡཱཏཱསྟཱཤྩ དཱུརཱཏ྄ ཏཱནི དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ཨཐཱསཱདནདིནསྱཱརྠཱད྄ ཝིཤྲཱམཝཱརཱཏ྄ པཱུཪྻྭདིནསྱ སཱཡཾཀཱལ ཨཱགཏ ");
INSERT INTO santib_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ཨཱིཤྭརརཱཛྱཱཔེཀྵྱརིམཐཱིཡཡཱུཥཕནཱམཱ མཱནྱམནྟྲཱི སམེཏྱ པཱིལཱཏསཝིདྷཾ ནིརྦྷཡོ གཏྭཱ ཡཱིཤོརྡེཧཾ ཡཡཱཙེ། ");
INSERT INTO santib_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ཀིནྟུ ས ཨིདཱནཱིཾ མྲྀཏཿ པཱིལཱཏ ཨིཏྱསམྦྷཝཾ མཏྭཱ ཤཏསེནཱཔཏིམཱཧཱུཡ ས ཀདཱ མྲྀཏ ཨིཏི པཔྲཙྪ། ");
INSERT INTO santib_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ཤཏསེམནཱཔཏིམུཁཱཏ྄ ཏཛྫྙཱཏྭཱ ཡཱུཥཕེ ཡཱིཤོརྡེཧཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","པཤྩཱཏ྄ ས སཱུཀྵྨཾ ཝཱསཿ ཀྲཱིཏྭཱ ཡཱིཤོཿ ཀཱཡམཝརོཧྱ ཏེན ཝཱསསཱ ཝེཥྚཱཡིཏྭཱ གིརཽ ཁཱཏཤྨཤཱནེ སྠཱཔིཏཝཱན྄ པཱཥཱཎཾ ལོཋཡིཏྭཱ དྭཱརི ནིདདྷེ། ");
INSERT INTO santib_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ཀིནྟུ ཡཏྲ སོསྠཱཔྱཏ ཏཏ མགྡལཱིནཱི མརིཡམ྄ ཡོསིམཱཏྲྀམརིཡམ྄ ཙ དདྲྀཤཏྲྀཿ། ");
INSERT INTO santib_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ཨཐ ཝིཤྲཱམཝཱརེ གཏེ མགྡལཱིནཱི མརིཡམ྄ ཡཱཀཱུབམཱཏཱ མརིཡམ྄ ཤཱལོམཱི ཙེམཱསྟཾ མརྡྡཡིཏུཾ སུགནྡྷིདྲཝྱཱཎི ཀྲཱིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","སཔྟཱཧཔྲཐམདིནེ྅ཏིཔྲཏྱཱུཥེ སཱུཪྻྱོདཡཀཱལེ ཤྨཤཱནམུཔགཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ཀིནྟུ ཤྨཤཱནདྭཱརཔཱཥཱཎོ྅ཏིབྲྀཧན྄ ཏཾ ཀོ྅པསཱརཡིཥྱཏཱིཏི ཏཱཿ པརསྤརཾ གདནྟི! ");
INSERT INTO santib_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ཨེཏརྷི ནིརཱིཀྵྱ པཱཥཱཎོ དྭཱརོ ྅པསཱརིཏ ཨིཏི དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","པཤྩཱཏྟཱཿ ཤྨཤཱནཾ པྲཝིཤྱ ཤུཀླཝརྞདཱིརྒྷཔརིཙྪདཱཝྲྀཏམེཀཾ ཡུཝཱནཾ ཤྨཤཱནདཀྵིཎཔཱརྴྭ ཨུཔཝིཥྚཾ དྲྀཥྚྭཱ ཙམཙྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","སོ྅ཝདཏ྄, མཱབྷཻཥྚ ཡཱུཡཾ ཀྲུཤེ ཧཏཾ ནཱསརཏཱིཡཡཱིཤུཾ གཝེཥཡཐ སོཏྲ ནཱསྟི ཤྨཤཱནཱདུདསྠཱཏ྄; ཏཻ ཪྻཏྲ ས སྠཱཔིཏཿ སྠཱནཾ ཏདིདཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ཀིནྟུ ཏེན ཡཐོཀྟཾ ཏཐཱ ཡུཥྨཱཀམགྲེ གཱལཱིལཾ ཡཱསྱཏེ ཏཏྲ ས ཡུཥྨཱན྄ སཱཀྵཱཏ྄ ཀརིཥྱཏེ ཡཱུཡཾ གཏྭཱ ཏསྱ ཤིཥྱེབྷྱཿ པིཏརཱཡ ཙ ཝཱརྟྟཱམིམཱཾ ཀཐཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ཏཱཿ ཀམྤིཏཱ ཝིསྟིཏཱཤྩ ཏཱུརྞཾ ཤྨཤཱནཱད྄ བཧིརྒཏྭཱ པལཱཡནྟ བྷཡཱཏ྄ ཀམཔི ཀིམཔི ནཱཝདཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ཨཔརཾ ཡཱིཤུཿ སཔྟཱཧཔྲཐམདིནེ པྲཏྱཱུཥེ ཤྨཤཱནཱདུཏྠཱཡ ཡསྱཱཿ སཔྟབྷཱུཏཱསྟྱཱཛིཏཱསྟསྱཻ མགྡལཱིནཱིམརིཡམེ པྲཐམཾ དརྴནཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ཏཏཿ སཱ གཏྭཱ ཤོཀརོདནཀྲྀདྦྷྱོ྅ནུགཏལོཀེབྷྱསྟཱཾ ཝཱརྟྟཱཾ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ཀིནྟུ ཡཱིཤུཿ པུནརྫཱིཝན྄ ཏསྱཻ དརྴནཾ དཏྟཝཱནིཏི ཤྲུཏྭཱ ཏེ ན པྲཏྱཡན྄། ");
INSERT INTO santib_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","པཤྩཱཏ྄ ཏེཥཱཾ དྭཱཡོ རྒྲཱམཡཱནཀཱལེ ཡཱིཤུརནྱཝེཤཾ དྷྲྀཏྭཱ ཏཱབྷྱཱཾ དརྴན དདཽ! ");
INSERT INTO santib_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ཏཱཝཔི གཏྭཱནྱཤིཥྱེབྷྱསྟཱཾ ཀཐཱཾ ཀཐཡཱཉྩཀྲཏུཿ ཀིནྟུ ཏཡོཿ ཀཐཱམཔི ཏེ ན པྲཏྱཡན྄། ");
INSERT INTO santib_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ཤེཥཏ ཨེཀཱདཤཤིཥྱེཥུ བྷོཛནོཔཝིཥྚེཥུ ཡཱིཤུསྟེབྷྱོ དརྴནཾ དདཽ ཏཐོཏྠཱནཱཏ྄ པརཾ ཏདྡརྴནཔྲཱཔྟལོཀཱནཱཾ ཀཐཱཡཱམཝིཤྭཱསཀརཎཱཏ྄ ཏེཥཱམཝིཤྭཱསམནཿཀཱཋིནྱཱབྷྱཱཾ ཧེཏུབྷྱཱཾ ས ཏཱཾསྟརྫིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ཨཐ ཏཱནཱཙཁྱཽ ཡཱུཡཾ སཪྻྭཛགད྄ གཏྭཱ སཪྻྭཛནཱན྄ པྲཏི སུསཾཝཱདཾ པྲཙཱརཡཏ། ");
INSERT INTO santib_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ཏཏྲ ཡཿ ཀཤྩིད྄ ཝིཤྭསྱ མཛྫིཏོ བྷཝེཏ྄ ས པརིཏྲཱསྱཏེ ཀིནྟུ ཡོ ན ཝིཤྭསིཥྱཏི ས དཎྜཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ཀིཉྩ ཡེ པྲཏྱེཥྱནྟི ཏཻརཱིདྲྀག྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ པྲཀཱཤཡིཥྱཏེ ཏེ མནྣཱམྣཱ བྷཱུཏཱན྄ ཏྱཱཛཡིཥྱནྟི བྷཱཥཱ ཨནྱཱཤྩ ཝདིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ཨཔརཾ ཏཻཿ སརྤེཥུ དྷྲྀཏེཥུ པྲཱཎནཱཤཀཝསྟུནི པཱིཏེ ཙ ཏེཥཱཾ ཀཱཔི ཀྵཏི རྣ བྷཝིཥྱཏི; རོགིཎཱཾ གཱཏྲེཥུ ཀརཱརྤིཏེ ཏེ྅རོགཱ བྷཝིཥྱནྟི ཙ། ");
INSERT INTO santib_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ཨཐ པྲབྷུསྟཱནིཏྱཱདིཤྱ སྭརྒཾ ནཱིཏཿ སན྄ པརམེཤྭརསྱ དཀྵིཎ ཨུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ཏཏསྟེ པྲསྠཱཡ སཪྻྭཏྲ སུསཾཝཱདཱིཡཀཐཱཾ པྲཙཱརཡིཏུམཱརེབྷིརེ པྲབྷུསྟུ ཏེཥཱཾ སཧཱཡཿ སན྄ པྲཀཱཤིཏཱཤྩཪྻྱཀྲིཡཱབྷིསྟཱཾ ཀཐཱཾ པྲམཱཎཝཏཱིཾ ཙཀཱར། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","པྲཐམཏོ ཡེ སཱཀྵིཎོ ཝཱཀྱཔྲཙཱརཀཱཤྩཱསན྄ ཏེ྅སྨཱཀཾ མདྷྱེ ཡདྱཏ྄ སཔྲམཱཎཾ ཝཱཀྱམརྤཡནྟི སྨ ");
INSERT INTO santib_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ཏདནུསཱརཏོ྅ནྱེཔི བཧཝསྟདྭྲྀཏྟཱནྟཾ རཙཡིཏུཾ པྲཝྲྀཏྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ཨཏཨེཝ ཧེ མཧཱམཧིམཐིཡཕིལ྄ ཏྭཾ ཡཱ ཡཱཿ ཀཐཱ ཨཤིཀྵྱཐཱསྟཱསཱཾ དྲྀཌྷཔྲམཱཎཱནི ཡཐཱ པྲཱཔྣོཥི ");
INSERT INTO santib_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ཏདརྠཾ པྲཐམམཱརབྷྱ ཏཱནི སཪྻྭཱཎི ཛྙཱཏྭཱཧམཔི ཨནུཀྲམཱཏ྄ སཪྻྭཝྲྀཏྟཱནྟཱན྄ ཏུབྷྱཾ ལེཁིཏུཾ མཏིམཀཱརྵམ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ཡིཧཱུདཱདེཤཱིཡཧེརོདྣཱམཀེ རཱཛཏྭཾ ཀུཪྻྭཏི ཨབཱིཡཡཱཛཀསྱ པཪྻྱཱཡཱདྷིཀཱརཱི སིཁརིཡནཱམཀ ཨེཀོ ཡཱཛཀོ ཧཱརོཎཝཾཤོདྦྷཝཱ ཨིལཱིཤེཝཱཁྱཱ ");
INSERT INTO santib_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ཏསྱ ཛཱཡཱ དྭཱཝིམཽ ནིརྡོཥཽ པྲབྷོཿ སཪྻྭཱཛྙཱ ཝྱཝསྠཱཤྩ སཾམནྱ ཨཱིཤྭརདྲྀཥྚཽ དྷཱརྨྨིཀཱཝཱསྟཱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ཏཡོཿ སནྟཱན ཨེཀོཔི ནཱསཱིཏ྄, ཡཏ ཨིལཱིཤེཝཱ བནྡྷྱཱ ཏཽ དྭཱཝེཝ ཝྲྀདྡྷཱཝབྷཝཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ཡདཱ སྭཔཪྻྱཱནུཀྲམེཎ སིཁརིཡ ཨཱིཤྭཱསྱ སམཀྵཾ ཡཱཛཀཱིཡཾ ཀརྨྨ ཀརོཏི ");
INSERT INTO santib_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ཏདཱ ཡཛྙསྱ དིནཔརིཔཱཡྻཱ པརམེཤྭརསྱ མནྡིརེ པྲཝེཤཀཱལེ དྷཱུཔཛྭཱལནཾ ཀརྨྨ ཏསྱ ཀརཎཱིཡམཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ཏདྡྷཱུཔཛྭཱལནཀཱལེ ལོཀནིཝཧེ པྲཱརྠནཱཾ ཀརྟུཾ བཧིསྟིཥྛཏི ");
INSERT INTO santib_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","སཏི སིཁརིཡོ ཡསྱཱཾ ཝེདྱཱཾ དྷཱུཔཾ ཛྭཱལཡཏི ཏདྡཀྵིཎཔཱརྴྭེ པརམེཤྭརསྱ དཱུཏ ཨེཀ ཨུཔསྠིཏོ དརྴནཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ཏཾ དྲྀཥྚྭཱ སིཁརིཡ ཨུདྭིཝིཛེ ཤཤངྐེ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ཏདཱ ས དཱུཏསྟཾ བབྷཱཥེ ཧེ སིཁརིཡ མཱ བྷཻསྟཝ པྲཱརྠནཱ གྲཱཧྱཱ ཛཱཏཱ ཏཝ བྷཱཪྻྱཱ ཨིལཱིཤེཝཱ པུཏྲཾ པྲསོཥྱཏེ ཏསྱ ནཱམ ཡོेཧན྄ ཨིཏི ཀརིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ཀིཉྩ ཏྭཾ སཱནནྡཿ སཧརྵཤྩ བྷཝིཥྱསི ཏསྱ ཛནྨནི བཧཝ ཨཱནནྡིཥྱནྟི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ཡཏོ ཧེཏོཿ ས པརམེཤྭརསྱ གོཙརེ མཧཱན྄ བྷཝིཥྱཏི ཏཐཱ དྲཱཀྵཱརསཾ སུརཱཾ ཝཱ ཀིམཔི ན པཱསྱཏི, ཨཔརཾ ཛནྨཱརབྷྱ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཿ ");
INSERT INTO santib_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","སན྄ ཨིསྲཱཡེལྭཾཤཱིཡཱན྄ ཨནེཀཱན྄ པྲབྷོཿ པརམེཤྭརསྱ མཱརྒམཱནེཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","སནྟཱནཱན྄ པྲཏི པིཏྲྀཎཱཾ མནཱཾསི དྷརྨྨཛྙཱནཾ པྲཏྱནཱཛྙཱགྲཱཧིཎཤྩ པརཱཝརྟྟཡིཏུཾ, པྲབྷོཿ པརམེཤྭརསྱ སེཝཱརྠམ྄ ཨེཀཱཾ སཛྫིཏཛཱཏིཾ ཝིདྷཱཏུཉྩ ས ཨེལིཡརཱུཔཱཏྨཤཀྟིཔྲཱཔྟསྟསྱཱགྲེ གམིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ཏདཱ སིཁརིཡོ དཱུཏམཝཱདཱིཏ྄ ཀཐམེཏད྄ ཝེཏྶྱཱམི? ཡཏོཧཾ ཝྲྀདྡྷོ མམ བྷཱཪྻྱཱ ཙ ཝྲྀདྡྷཱ། ");
INSERT INTO santib_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ཏཏོ དཱུཏཿ པྲཏྱུཝཱཙ པཤྱེཤྭརསྱ སཱཀྵཱདྭརྟྟཱི ཛིབྲཱཡེལྣཱམཱ དཱུཏོཧཾ ཏྭཡཱ སཧ ཀཐཱཾ གདིཏུཾ ཏུབྷྱམིམཱཾ ཤུབྷཝཱརྟྟཱཾ དཱཏུཉྩ པྲེཥིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ཀིནྟུ མདཱིཡཾ ཝཱཀྱཾ ཀཱལེ ཕལིཥྱཏི ཏཏ྄ ཏྭཡཱ ན པྲཏཱིཏམ྄ ཨཏཿ ཀཱརཎཱད྄ ཡཱཝདེཝ ཏཱནི ན སེཏྶྱནྟི ཏཱཝཏ྄ ཏྭཾ ཝཀྟུཾམཤཀྟོ མཱུཀོ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ཏདཱནཱིཾ ཡེ ཡེ ལོཀཱཿ སིཁརིཡམཔཻཀྵནྟ ཏེ མདྷྱེམནྡིརཾ ཏསྱ བཧུཝིལམྦཱད྄ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ས བཧིརཱགཏོ ཡདཱ ཀིམཔི ཝཱཀྱཾ ཝཀྟུམཤཀྟཿ སངྐེཏཾ ཀྲྀཏྭཱ ནིཿཤབྡསྟསྱཽ ཏདཱ མདྷྱེམནྡིརཾ ཀསྱཙིད྄ དརྴནཾ ཏེན པྲཱཔྟམ྄ ཨིཏི སཪྻྭེ བུབུདྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ཨནནྟརཾ ཏསྱ སེཝནཔཪྻྱཱཡེ སམྤཱུརྞེ སཏི ས ནིཛགེཧཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ཀཏིཔཡདིནེཥུ གཏེཥུ ཏསྱ བྷཱཪྻྱཱ ཨིལཱིཤེཝཱ གརྦྦྷཝཏཱི བབྷཱུཝ ");
INSERT INTO santib_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","པཤྩཱཏ྄ སཱ པཉྩམཱསཱན྄ སཾགོཔྱཱཀཐཡཏ྄ ལོཀཱནཱཾ སམཀྵཾ མམཱཔམཱནཾ ཁཎྜཡིཏུཾ པརམེཤྭརོ མཡི དྲྀཥྚིཾ པཱཏཡིཏྭཱ ཀརྨྨེདྲྀཤཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ཨཔརཉྩ ཏསྱཱ གརྦྦྷསྱ ཥཥྛེ མཱསེ ཛཱཏེ གཱལཱིལྤྲདེཤཱིཡནཱསརཏྤུརེ ");
INSERT INTO santib_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","དཱཡཱུདོ ཝཾཤཱིཡཱཡ ཡཱུཥཕྣཱམྣེ པུརུཥཱཡ ཡཱ མརིཡམྣཱམཀུམཱརཱི ཝཱགྡཏྟཱསཱིཏ྄ ཏསྱཱཿ སམཱིཔཾ ཛིབྲཱཡེལ྄ དཱུཏ ཨཱིཤྭརེཎ པྲཧིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ས གཏྭཱ ཛགཱད ཧེ ཨཱིཤྭརཱནུགྲྀཧཱིཏཀནྱེ ཏཝ ཤུབྷཾ བྷཱུཡཱཏ྄ པྲབྷུཿ པརམེཤྭརསྟཝ སཧཱཡོསྟི ནཱརཱིཎཱཾ མདྷྱེ ཏྭམེཝ དྷནྱཱ། ");
INSERT INTO santib_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ཏདཱནཱིཾ སཱ ཏཾ དྲྀཥྚྭཱ ཏསྱ ཝཱཀྱཏ ཨུདྭིཛྱ ཀཱིདྲྀཤཾ བྷཱཥཎམིདམ྄ ཨིཏི མནསཱ ཙིནྟཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ཏཏོ དཱུཏོ྅ཝདཏ྄ ཧེ མརིཡམ྄ བྷཡཾ མཱཀཱརྵཱིཿ, ཏྭཡི པརམེཤྭརསྱཱནུགྲཧོསྟི། ");
INSERT INTO santib_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","པཤྱ ཏྭཾ གརྦྦྷཾ དྷྲྀཏྭཱ པུཏྲཾ པྲསོཥྱསེ ཏསྱ ནཱམ ཡཱིཤུརིཏི ཀརིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ས མཧཱན྄ བྷཝིཥྱཏི ཏཐཱ སཪྻྭེབྷྱཿ ཤྲེཥྛསྱ པུཏྲ ཨིཏི ཁྱཱསྱཏི; ཨཔརཾ པྲབྷུཿ པརམེཤྭརསྟསྱ པིཏུརྡཱཡཱུདཿ སིཾཧཱསནཾ ཏསྨཻ དཱསྱཏི; ");
INSERT INTO santib_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ཏཐཱ ས ཡཱཀཱུབོ ཝཾཤོཔརི སཪྻྭདཱ རཱཛཏྭཾ ཀརིཥྱཏི, ཏསྱ རཱཛཏྭསྱཱནྟོ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ཏདཱ མརིཡམ྄ ཏཾ དཱུཏཾ བབྷཱཥེ ནཱཧཾ པུརུཥསངྒཾ ཀརོམི ཏརྷི ཀཐམེཏཏ྄ སམྦྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ཏཏོ དཱུཏོ྅ཀཐཡཏ྄ པཝིཏྲ ཨཱཏྨཱ ཏྭཱམཱཤྲཱཡིཥྱཏི ཏཐཱ སཪྻྭཤྲེཥྛསྱ ཤཀྟིསྟཝོཔརི ཚཱཡཱཾ ཀརིཥྱཏི ཏཏོ ཧེཏོསྟཝ གརྦྦྷཱད྄ ཡཿ པཝིཏྲབཱལཀོ ཛནིཥྱཏེ ས ཨཱིཤྭརཔུཏྲ ཨིཏི ཁྱཱཏིཾ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ཨཔརཉྩ པཤྱ ཏཝ ཛྙཱཏིརིལཱིཤེཝཱ ཡཱཾ སཪྻྭེ བནྡྷྱཱམཝདན྄ ཨིདཱནཱིཾ སཱ ཝཱརྡྡྷཀྱེ སནྟཱནམེཀཾ གརྦྦྷེ྅དྷཱརཡཏ྄ ཏསྱ ཥཥྛམཱསོབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ཀིམཔི ཀརྨྨ ནཱསཱདྷྱམ྄ ཨཱིཤྭརསྱ། ");
INSERT INTO santib_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ཏདཱ མརིཡམ྄ ཛགཱད, པཤྱ པྲབྷེརཧཾ དཱསཱི མཧྱཾ ཏཝ ཝཱཀྱཱནུསཱརེཎ སཪྻྭམེཏད྄ གྷཊཏཱམ྄; ཨནནཏརཾ དཱུཏསྟསྱཱཿ སམཱིཔཱཏ྄ པྲཏསྠེ། ");
INSERT INTO santib_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ཨཐ ཀཏིཔཡདིནཱཏ྄ པརཾ མརིཡམ྄ ཏསྨཱཏ྄ པཪྻྭཏམཡཔྲདེཤཱིཡཡིཧཱུདཱཡཱ ནགརམེཀཾ ཤཱིགྷྲཾ གཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","སིཁརིཡཡཱཛཀསྱ གྲྀཧཾ པྲཝིཤྱ ཏསྱ ཛཱཡཱམ྄ ཨིལཱིཤེཝཱཾ སམྦོདྷྱཱཝདཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ཏཏོ མརིཡམཿ སམྦོདྷནཝཱཀྱེ ཨིལཱིཤེཝཱཡཱཿ ཀརྞཡོཿ པྲཝིཥྚམཱཏྲེ སཏི ཏསྱཱ གརྦྦྷསྠབཱལཀོ ནནརྟྟ། ཏཏ ཨིལཱིཤེཝཱ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཱ སཏཱི ");
INSERT INTO santib_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","པྲོཙྩཻརྒདིཏུམཱརེབྷེ, ཡོཥིཏཱཾ མདྷྱེ ཏྭམེཝ དྷནྱཱ, ཏཝ གརྦྦྷསྠཿ ཤིཤུཤྩ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ཏྭཾ པྲབྷོརྨཱཏཱ, མམ ནིཝེཤནེ ཏྭཡཱ ཙརཎཱཝརྤིཏཽ, མམཱདྱ སཽབྷཱགྱམེཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","པཤྱ ཏཝ ཝཱཀྱེ མམ ཀརྞཡོཿ པྲཝིཥྚམཱཏྲེ སཏི མམོདརསྠཿ ཤིཤུརཱནནྡཱན྄ ནནརྟྟ། ");
INSERT INTO santib_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ཡཱ སྟྲཱི ཝྱཤྭསཱིཏ྄ སཱ དྷནྱཱ, ཡཏོ ཧེཏོསྟཱཾ པྲཏི པརམེཤྭརོཀྟཾ ཝཱཀྱཾ སཪྻྭཾ སིདྡྷཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ཏདཱནཱིཾ མརིཡམ྄ ཛགཱད། དྷནྱཝཱདཾ པརེཤསྱ ཀརོཏི མཱམཀཾ མནཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","མམཱཏྨཱ ཏཱརཀེཤེ ཙ སམུལླཱསཾ པྲགཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ཨཀརོཏ྄ ས པྲབྷུ རྡུཥྚིཾ སྭདཱསྱཱ དུརྒཏིཾ པྲཏི། པཤྱཱདྱཱརབྷྱ མཱཾ དྷནྱཱཾ ཝཀྵྱནྟི པུརུཥཱཿ སདཱ། ");
INSERT INTO santib_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ཡཿ སཪྻྭཤཀྟིམཱན྄ ཡསྱ ནཱམཱཔི ཙ པཝིཏྲཀཾ། ས ཨེཝ སུམཧཏྐརྨྨ ཀྲྀཏཝཱན྄ མནྣིམིཏྟཀཾ། ");
INSERT INTO santib_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ཡེ བིབྷྱཏི ཛནཱསྟསྨཱཏ྄ ཏེཥཱཾ སནྟཱནཔཾཀྟིཥུ། ཨནུཀམྤཱ ཏདཱིཡཱ ཙ སཪྻྭདཻཝ སུཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","སྭབཱཧུབལཏསྟེན པྲཱཀཱཤྱཏ པརཱཀྲམཿ། མནཿཀུམནྟྲཎཱསཱརྡྡྷཾ ཝིཀཱིཪྻྱནྟེ྅བྷིམཱནིནཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","སིཾཧཱསནགཏཱལློཀཱན྄ བལིནཤྩཱཝརོཧྱ སཿ། པདེཥཱུཙྩེཥུ ལོཀཱཾསྟུ ཀྵུདྲཱན྄ སཾསྠཱཔཡཏྱཔི། ");
INSERT INTO santib_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ཀྵུདྷིཏཱན྄ མཱནཝཱན྄ དྲཝྱཻརུཏྟམཻཿ པརིཏརྤྱ སཿ། སཀལཱན྄ དྷནིནོ ལོཀཱན྄ ཝིསྲྀཛེད྄ རིཀྟཧསྟཀཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ཨིབྲཱཧཱིམི ཙ ཏདྭཾཤེ ཡཱ དཡཱསྟི སདཻཝ ཏཱཾ། སྨྲྀཏྭཱ པུརཱ པིཏྲྀཎཱཾ ནོ ཡཐཱ སཱཀྵཱཏ྄ པྲཏིཤྲུཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ཨིསྲཱཡེལྶེཝཀསྟེན ཏཐོཔཀྲིཡཏེ སྭཡཾ༎ ");
INSERT INTO santib_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ཨནནྟརཾ མརིཡམ྄ པྲཱཡེཎ མཱསཏྲཡམ྄ ཨིལཱིཤེཝཡཱ སཧོཥིཏྭཱ ཝྱཱགྷུཡྻ ནིཛནིཝེཤནཾ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ཏདནནྟརམ྄ ཨིལཱིཤེཝཱཡཱཿ པྲསཝཀཱལ ཨུཔསྠིཏེ སཏི སཱ པུཏྲཾ པྲཱསོཥྚ། ");
INSERT INTO santib_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ཏཏཿ པརམེཤྭརསྟསྱཱཾ མཧཱནུགྲཧཾ ཀྲྀཏཝཱན྄ ཨེཏཏ྄ ཤྲུཏྭཱ སམཱིཔཝཱསིནཿ ཀུཊུམྦཱཤྩཱགཏྱ ཏཡཱ སཧ མུམུདིརེ། ");
INSERT INTO santib_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ཏཐཱཥྚམེ དིནེ ཏེ བཱལཀསྱ ཏྭཙཾ ཚེཏྟུམ྄ ཨེཏྱ ཏསྱ པིཏྲྀནཱམཱནུརཱུཔཾ ཏནྣཱམ སིཁརིཡ ཨིཏི ཀརྟྟུམཱིཥུཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ཀིནྟུ ཏསྱ མཱཏཱཀཐཡཏ྄ ཏནྣ, ནཱམཱསྱ ཡོཧན྄ ཨིཏི ཀརྟྟཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ཏདཱ ཏེ ཝྱཱཧརན྄ ཏཝ ཝཾཤམདྷྱེ ནཱམེདྲྀཤཾ ཀསྱཱཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ཏཏཿ པརཾ ཏསྱ པིཏརཾ སིཁརིཡཾ པྲཏི སངྐེཏྱ པཔྲཙྪུཿ ཤིཤོཿ ཀིཾ ནཱམ ཀཱརིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ཏཏཿ ས ཕལཀམེཀཾ ཡཱཙིཏྭཱ ལིལེཁ ཏསྱ ནཱམ ཡོཧན྄ བྷཝིཥྱཏི། ཏསྨཱཏ྄ སཪྻྭེ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ཏཏྐྵཎཾ སིཁརིཡསྱ ཛིཧྭཱཛཱཌྱེ྅པགཏེ ས མུཁཾ ཝྱཱདཱཡ སྤཥྚཝརྞམུཙྩཱཪྻྱ ཨཱིཤྭརསྱ གུཎཱནུཝཱདཾ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ཏསྨཱཙྩཏུརྡིཀྶྠཱཿ སམཱིཔཝཱསིལོཀཱ བྷཱིཏཱ ཨེཝམེཏཱཿ སཪྻྭཱཿ ཀཐཱ ཡིཧཱུདཱཡཱཿ པཪྻྭཏམཡཔྲདེཤསྱ སཪྻྭཏྲ པྲཙཱརིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ཏསྨཱཏ྄ ཤྲོཏཱརོ མནཿསུ སྠཱཔཡིཏྭཱ ཀཐཡཱམྦབྷཱུཝུཿ ཀཱིདྲྀཤོཡཾ བཱལོ བྷཝིཥྱཏི? ཨཐ པརམེཤྭརསྟསྱ སཧཱཡོབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ཏདཱ ཡོཧནཿ པིཏཱ སིཁརིཡཿ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཿ སན྄ ཨེཏཱདྲྀཤཾ བྷཝིཥྱདྭཱཀྱཾ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ཨིསྲཱཡེལཿ པྲབྷུ ཪྻསྟུ ས དྷནྱཿ པརམེཤྭརཿ། ཨནུགྲྀཧྱ ནིཛཱལློཀཱན྄ ས ཨེཝ པརིམོཙཡེཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ཝིཔཀྵཛནཧསྟེབྷྱོ ཡཐཱ མོཙྱཱམཧེ ཝཡཾ། ཡཱཝཛྫཱིཝཉྩ དྷརྨྨེཎ སཱརལྱེན ཙ ནིརྦྷཡཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","སེཝཱམཧཻ ཏམེཝཻཀམ྄ ཨེཏཏྐཱརཎམེཝ ཙ། སྭཀཱིཡཾ སུཔཝིཏྲཉྩ སཾསྨྲྀཏྱ ནིཡམཾ སདཱ། ");
INSERT INTO santib_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ཀྲྀཔཡཱ པུརུཥཱན྄ པཱུཪྻྭཱན྄ ནིཀཥཱརྠཱཏྟུ ནཿ པིཏུཿ། ཨིབྲཱཧཱིམཿ སམཱིཔེ ཡཾ ཤཔཐཾ ཀྲྀཏཝཱན྄ པུརཱ། ");
INSERT INTO santib_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ཏམེཝ སཕལཾ ཀརྟྟཾ ཏཐཱ ཤཏྲུགཎསྱ ཙ། ཨྲྀृཏཱིཡཱཀཱརིཎཤྩཻཝ ཀརེབྷྱོ རཀྵཎཱཡ ནཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","སྲྀཥྚེཿ པྲཐམཏཿ སྭཱིཡཻཿ པཝིཏྲཻ རྦྷཱཝིཝཱདིབྷིཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ཡཐོཀྟཝཱན྄ ཏཐཱ སྭསྱ དཱཡཱུདཿ སེཝཀསྱ ཏུ། ");
INSERT INTO santib_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ཝཾཤེ ཏྲཱཏཱརམེཀཾ ས སམུཏྤཱདིཏཝཱན྄ སྭཡམ྄། ");
INSERT INTO santib_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ཨཏོ ཧེ བཱལཀ ཏྭནྟུ སཪྻྭེབྷྱཿ ཤྲེཥྛ ཨེཝ ཡཿ། ཏསྱཻཝ བྷཱཝིཝཱདཱིཏི པྲཝིཁྱཱཏོ བྷཝིཥྱསི། ཨསྨཱཀཾ ཙརཎཱན྄ ཀྵེམེ མཱརྒེ ཙཱལཡིཏུཾ སདཱ། ཨེཝཾ དྷྭཱནྟེ྅རྠཏོ མྲྀཏྱོཤྪཱཡཱཡཱཾ ཡེ ཏུ མཱནཝཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ཨུཔཝིཥྚཱསྟུ ཏཱནེཝ པྲཀཱཤཡིཏུམེཝ ཧི། ཀྲྀཏྭཱ མཧཱནུཀམྤཱཾ ཧི ཡཱམེཝ པརམེཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ཨཱུརྡྭྭཱཏ྄ སཱུཪྻྱམུདཱཡྻཻཝཱསྨབྷྱཾ པྲཱདཱཏྟུ དརྴནཾ། ཏཡཱནུཀམྤཡཱ སྭསྱ ལོཀཱནཱཾ པཱཔམོཙནེ། ");
INSERT INTO santib_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","པརིཏྲཱཎསྱ ཏེབྷྱོ ཧི ཛྙཱནཝིཤྲཱཎནཱཡ ཙ། པྲབྷོ རྨཱརྒཾ པརིཥྐརྟྟུཾ ཏསྱཱགྲཱཡཱི བྷཝིཥྱསི༎ ");
INSERT INTO santib_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ཨཐ བཱལཀཿ ཤརཱིརེཎ བུདྡྷྱཱ ཙ ཝརྡྡྷིཏུམཱརེབྷེ; ཨཔརཉྩ ས ཨིསྲཱཡེལོ ཝཾཤཱིཡལོཀཱནཱཾ སམཱིཔེ ཡཱཝནྣ པྲཀཊཱིབྷཱུཏསྟཱསྟཱཝཏ྄ པྲཱནྟརེ ནྱཝསཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ཨཔརཉྩ ཏསྨིན྄ ཀཱལེ རཱཛྱསྱ སཪྻྭེཥཱཾ ལོཀཱནཱཾ ནཱམཱནི ལེཁཡིཏུམ྄ ཨགསྟཀཻསར ཨཱཛྙཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ཏདནུསཱརེཎ ཀུརཱིཎིཡནཱམནི སུརིཡཱདེཤསྱ ཤཱསཀེ སཏི ནཱམལེཁནཾ པྲཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ཨཏོ ཧེཏོ རྣཱམ ལེཁིཏུཾ སཪྻྭེ ཛནཱཿ སྭཱིཡཾ སྭཱིཡཾ ནགརཾ ཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ཏདཱནཱིཾ ཡཱུཥཕ྄ ནཱམ ལེཁིཏུཾ ཝཱགྡཏྟཡཱ སྭབྷཱཪྻྱཡཱ གརྦྦྷཝཏྱཱ མརིཡམཱ སཧ སྭཡཾ དཱཡཱུདཿ སཛཱཏིཝཾཤ ཨིཏི ཀཱརཎཱད྄ གཱལཱིལྤྲདེཤསྱ ནཱསརཏྣགརཱད྄ ");
INSERT INTO santib_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ཡིཧཱུདཱཔྲདེཤསྱ བཻཏླེཧམཱཁྱཾ དཱཡཱུདྣགརཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ཨནྱཙྩ ཏཏྲ སྠཱནེ ཏཡོསྟིཥྛཏོཿ སཏོ རྨརིཡམཿ པྲསཱུཏིཀཱལ ཨུཔསྠིཏེ ");
INSERT INTO santib_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","སཱ ཏཾ པྲཐམསུཏཾ པྲཱསོཥྚ ཀིནྟུ ཏསྨིན྄ ཝཱསགྲྀཧེ སྠཱནཱབྷཱཝཱད྄ བཱལཀཾ ཝསྟྲེཎ ཝེཥྚཡིཏྭཱ གོཤཱལཱཡཱཾ སྠཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ཨནནྟརཾ ཡེ ཀིཡནྟོ མེཥཔཱལཀཱཿ སྭམེཥཝྲཛརཀྵཱཡཻ ཏཏྤྲདེཤེ སྠིཏྭཱ རཛནྱཱཾ པྲཱནྟརེ པྲཧརིཎཿ ཀརྨྨ ཀུཪྻྭནྟི, ");
INSERT INTO santib_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ཏེཥཱཾ སམཱིཔཾ པརམེཤྭརསྱ དཱུཏ ཨཱགཏྱོཔཏསྠཽ; ཏདཱ ཙཏུཥྤཱརྴྭེ པརམེཤྭརསྱ ཏེཛསཿ པྲཀཱཤིཏཏྭཱཏ྄ ཏེ྅ཏིཤཤངྐིརེ། ");
INSERT INTO santib_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ཏདཱ ས དཱུཏ ཨུཝཱཙ མཱ བྷཻཥྚ པཤྱཏཱདྱ དཱཡཱུདཿ པུརེ ཡུཥྨནྣིམིཏྟཾ ཏྲཱཏཱ པྲབྷུཿ ཁྲཱིཥྚོ྅ཛནིཥྚ, ");
INSERT INTO santib_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","སཪྻྭེཥཱཾ ལོཀཱནཱཾ མཧཱནནྡཛནཀམ྄ ཨིམཾ མངྒལཝྲྀཏྟཱནྟཾ ཡུཥྨཱན྄ ཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ཡཱུཡཾ (ཏཏྶྠཱནཾ གཏྭཱ) ཝསྟྲཝེཥྚིཏཾ ཏཾ བཱལཀཾ གོཤཱལཱཡཱཾ ཤཡནཾ དྲཀྵྱཐ ཡུཥྨཱན྄ པྲཏཱིདཾ ཙིཧྣཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","དཱུཏ ཨིམཱཾ ཀཐཱཾ ཀཐིཏཝཏི ཏཏྲཱཀསྨཱཏ྄ སྭརྒཱིཡཱཿ པྲྀཏནཱ ཨཱགཏྱ ཀཐཱམ྄ ཨིམཱཾ ཀཐཡིཏྭེཤྭརསྱ གུཎཱནནྭཝཱདིཥུཿ, ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","སཪྻྭོརྡྭྭསྠཻརཱིཤྭརསྱ མཧིམཱ སམྤྲཀཱཤྱཏཱཾ། ཤཱནྟིརྦྷཱུཡཱཏ྄ པྲྀཐིཝྱཱསྟུ སནྟོཥཤྩ ནརཱན྄ པྲཏི༎ ");
INSERT INTO santib_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ཏཏཿ པརཾ ཏེཥཱཾ སནྣིདྷེ རྡཱུཏགཎེ སྭརྒཾ གཏེ མེཥཔཱལཀཱཿ པརསྤརམ྄ ཨཝེཙན྄ ཨཱགཙྪཏ པྲབྷུཿ པརམེཤྭརོ ཡཱཾ གྷཊནཱཾ ཛྙཱཔིཏཝཱན྄ ཏསྱཱ ཡཱཐཪྻཾ ཛྙཱཏུཾ ཝཡམདྷུནཱ བཻཏླེཧམྤུརཾ ཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","པཤྩཱཏ྄ ཏེ ཏཱུརྞཾ ཝྲཛིཏྭཱ མརིཡམཾ ཡཱུཥཕཾ གོཤཱལཱཡཱཾ ཤཡནཾ བཱལཀཉྩ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ཨིཏྠཾ དྲྀཥྚྭཱ བཱལཀསྱཱརྠེ པྲོཀྟཱཾ སཪྻྭཀཐཱཾ ཏེ པྲཱཙཱརཡཱཉྩཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ཏཏོ ཡེ ལོཀཱ མེཥརཀྵཀཱཎཱཾ ཝདནེབྷྱསྟཱཾ ཝཱརྟྟཱཾ ཤུཤྲུཝུསྟེ མཧཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ཀིནྟུ མརིཡམ྄ ཨེཏཏྶཪྻྭགྷཊནཱནཱཾ ཏཱཏྤཪྻྱཾ ཝིཝིཙྱ མནསི སྠཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ཏཏྤཤྩཱད྄ དཱུཏཝིཛྙཔྟཱནུརཱུཔཾ ཤྲུཏྭཱ དྲྀཥྚྭཱ ཙ མེཥཔཱལཀཱ ཨཱིཤྭརསྱ གུཎཱནུཝཱདཾ དྷནྱཝཱདཉྩ ཀུཪྻྭཱཎཱཿ པརཱཝྲྀཏྱ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ཨཐ བཱལཀསྱ ཏྭཀྪེདནཀཱལེ྅ཥྚམདིཝསེ སམུཔསྠིཏེ ཏསྱ གརྦྦྷསྠིཏེཿ པུཪྻྭཾ སྭརྒཱིཡདཱུཏོ ཡཐཱཛྙཱཔཡཏ྄ ཏདནུརཱུཔཾ ཏེ ཏནྣཱམདྷེཡཾ ཡཱིཤུརིཏི ཙཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ཏཏཿ པརཾ མཱུསཱལིཁིཏཝྱཝསྠཱཡཱ ཨནུསཱརེཎ མརིཡམཿ ཤུཙིཏྭཀཱལ ཨུཔསྠིཏེ, ");
INSERT INTO santib_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"པྲཐམཛཿ སཪྻྭཿ པུརུཥསནྟཱནཿ པརམེཤྭརེ སམརྤྱཏཱཾ,\" ཨིཏི པརམེཤྭརསྱ ཝྱཝསྠཡཱ ");
INSERT INTO santib_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ཡཱིཤུཾ པརམེཤྭརེ སམརྤཡིཏུམ྄ ཤཱསྟྲཱིཡཝིདྷྱུཀྟཾ ཀཔོཏདྭཡཾ པཱརཱཝཏཤཱཝཀདྭཡཾ ཝཱ བལིཾ དཱཏུཾ ཏེ ཏཾ གྲྀཧཱིཏྭཱ ཡིརཱུཤཱལམམ྄ ཨཱཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ཡིརཱུཤཱལམྤུརནིཝཱསཱི ཤིམིཡོནྣཱམཱ དྷཱརྨྨིཀ ཨེཀ ཨཱསཱིཏ྄ ས ཨིསྲཱཡེལཿ སཱནྟྭནཱམཔེཀྵྱ ཏསྠཽ ཀིཉྩ པཝིཏྲ ཨཱཏྨཱ ཏསྨིནྣཱཝིརྦྷཱུཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ཨཔརཾ པྲབྷུཎཱ པརམེཤྭརེཎཱབྷིཥིཀྟེ ཏྲཱཏརི ཏྭཡཱ ན དྲྀཥྚེ ཏྭཾ ན མརིཥྱསཱིཏི ཝཱཀྱཾ པཝིཏྲེཎ ཨཱཏྨནཱ ཏསྨ པྲཱཀཐྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ཨཔརཉྩ ཡདཱ ཡཱིཤོཿ པིཏཱ མཱཏཱ ཙ ཏདརྠཾ ཝྱཝསྠཱནུརཱུཔཾ ཀརྨྨ ཀརྟྟུཾ ཏཾ མནྡིརམ྄ ཨཱནིནྱཏུསྟདཱ ");
INSERT INTO santib_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ཤིམིཡོན྄ ཨཱཏྨན ཨཱཀརྵཎེན མནྡིརམཱགཏྱ ཏཾ ཀྲོཌེ ནིདྷཱཡ ཨཱིཤྭརསྱ དྷནྱཝཱདཾ ཀྲྀཏྭཱ ཀཐཡཱམཱས, ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ཧེ པྲབྷོ ཏཝ དཱསོཡཾ ནིཛཝཱཀྱཱནུསཱརཏཿ། ཨིདཱནཱིནྟུ སཀལྱཱཎོ བྷཝཏཱ སཾཝིསྲྀཛྱཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ཡཏཿ སཀལདེཤསྱ དཱིཔྟཡེ དཱིཔྟིརཱུཔཀཾ། ");
INSERT INTO santib_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ཨིསྲཱཡེལཱིཡལོཀསྱ མཧཱགཽརཝརཱུཔཀཾ། ");
INSERT INTO santib_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ཡཾ ཏྲཱཡཀཾ ཛནཱནཱནྟུ སམྨུཁེ ཏྭམཛཱིཛནཿ། སཨེཝ ཝིདྱཏེ྅སྨཱཀཾ དྷྲཝཾ ནཡནནགོཙརེ༎ ");
INSERT INTO santib_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ཏདཱནཱིཾ ཏེནོཀྟཱ ཨེཏཱཿ སཀལཱཿ ཀཐཱཿ ཤྲུཏྭཱ ཏསྱ མཱཏཱ ཡཱུཥཕ྄ ཙ ཝིསྨཡཾ མེནཱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ཏཏཿ པརཾ ཤིམིཡོན྄ ཏེབྷྱ ཨཱཤིཥཾ དཏྟྭཱ ཏནྨཱཏརཾ མརིཡམམ྄ ཨུཝཱཙ, པཤྱ ཨིསྲཱཡེལོ ཝཾཤམདྷྱེ བཧཱུནཱཾ པཱཏནཱཡོཏྠཱཔནཱཡ ཙ ཏཐཱ ཝིརོདྷཔཱཏྲཾ བྷཝིཏུཾ, བཧཱུནཱཾ གུཔྟམནོགཏཱནཱཾ པྲཀཊཱིཀརཎཱཡ བཱལཀོཡཾ ནིཡུཀྟོསྟི། ");
INSERT INTO santib_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ཏསྨཱཏ྄ ཏཝཱཔི པྲཱཎཱཿ ཤཱུལེན ཝྱཏྶྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ཨཔརཉྩ ཨཱཤེརསྱ ཝཾཤཱིཡཕིནཱུཡེལོ དུཧིཏཱ ཧནྣཱཁྱཱ ཨཏིཛརཏཱི བྷཝིཥྱདྭཱདིནྱེཀཱ ཡཱ ཝིཝཱཧཱཏ྄ པརཾ སཔྟ ཝཏྶརཱན྄ པཏྱཱ སཧ ནྱཝསཏ྄ ཏཏོ ཝིདྷཝཱ བྷཱུཏྭཱ ཙཏུརཤཱིཏིཝརྵཝཡཿཔཪྻྱནཏཾ ");
INSERT INTO santib_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","མནྡིརེ སྠིཏྭཱ པྲཱརྠནོཔཝཱསཻརྡིཝཱནིཤམ྄ ཨཱིཤྭརམ྄ ཨསེཝཏ སཱཔི སྟྲཱི ཏསྨིན྄ སམཡེ མནྡིརམཱགཏྱ ");
INSERT INTO santib_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","པརམེཤྭརསྱ དྷནྱཝཱདཾ ཙཀཱར, ཡིརཱུཤཱལམྤུརཝཱསིནོ ཡཱཝནྟོ ལོཀཱ མུཀྟིམཔེཀྵྱ སྠིཏཱསྟཱན྄ ཡཱིཤོཪྻྲྀཏྟཱནྟཾ ཛྙཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ཨིཏྠཾ པརམེཤྭརསྱ ཝྱཝསྠཱནུསཱརེཎ སཪྻྭེཥུ ཀརྨྨསུ ཀྲྀཏེཥུ ཏཽ པུནཤྩ གཱལཱིལོ ནཱསརཏྣཱམཀཾ ནིཛནགརཾ པྲཏསྠཱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ཏཏྤཤྩཱད྄ བཱལཀཿ ཤརཱིརེཎ ཝྲྀདྡྷིམེཏྱ ཛྙཱནེན པརིཔཱུརྞ ཨཱཏྨནཱ ཤཀྟིམཱཾཤྩ བྷཝིཏུམཱརེབྷེ ཏཐཱ ཏསྨིན྄ ཨཱིཤྭརཱནུགྲཧོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ཏསྱ པིཏཱ མཱཏཱ ཙ པྲཏིཝརྵཾ ནིསྟཱརོཏྶཝསམཡེ ཡིརཱུཤཱལམམ྄ ཨགཙྪཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ཨཔརཉྩ ཡཱིཤཽ དྭཱདཤཝརྵཝཡསྐེ སཏི ཏཽ པཪྻྭསམཡསྱ རཱིཏྱནུསཱརེཎ ཡིརཱུཤཱལམཾ གཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","པཱཪྻྭཎཾ སམྤཱདྱ པུནརཔི ཝྱཱགྷུཡྻ ཡཱཏཿ ཀིནྟུ ཡཱིཤུརྦཱལཀོ ཡིརཱུཤཱལམི ཏིཥྛཏི། ཡཱུཥཕ྄ ཏནྨཱཏཱ ཙ ཏད྄ ཨཝིདིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ས སངྒིབྷིཿ སཧ ཝིདྱཏ ཨེཏཙྩ བུདྭྭཱ དིནཻཀགམྱམཱརྒཾ ཛགྨཏུཿ། ཀིནྟུ ཤེཥེ ཛྙཱཏིབནྡྷཱུནཱཾ སམཱིཔེ མྲྀགཡིཏྭཱ ཏདུདྡེेཤམཔྲཱཔྱ ");
INSERT INTO santib_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ཏཽ པུནརཔི ཡིརཱུཤཱལམམ྄ པརཱཝྲྀཏྱཱགཏྱ ཏཾ མྲྀགཡཱཉྩཀྲཏུཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ཨཐ དིནཏྲཡཱཏ྄ པརཾ པཎྜིཏཱནཱཾ མདྷྱེ ཏེཥཱཾ ཀཐཱཿ ཤྲྀཎྭན྄ ཏཏྟྭཾ པྲྀཙྪཾཤྩ མནྡིརེ སམུཔཝིཥྚཿ ས ཏཱབྷྱཱཾ དྲྀཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ཏདཱ ཏསྱ བུདྡྷྱཱ པྲཏྱུཏྟརཻཤྩ སཪྻྭེ ཤྲོཏཱརོ ཝིསྨཡམཱཔདྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ཏཱདྲྀཤཾ དྲྀཥྚྭཱ ཏསྱ ཛནཀོ ཛནནཱི ཙ ཙམཙྩཀྲཏུཿ ཀིཉྩ ཏསྱ མཱཏཱ ཏམཝདཏ྄, ཧེ པུཏྲ, ཀཐམཱཝཱཾ པྲཏཱིཏྠཾ སམཱཙརསྟྭམ྄? པཤྱ ཏཝ པིཏཱཧཉྩ ཤོཀཱཀུལཽ སནྟཽ ཏྭཱམནྭིཙྪཱཝཿ སྨ། ");
INSERT INTO santib_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ཏཏཿ སོཝདཏ྄ ཀུཏོ མཱམ྄ ཨནྭཻཙྪཏཾ? པིཏུརྒྲྀཧེ མཡཱ སྠཱཏཝྱམ྄ ཨེཏཏ྄ ཀིཾ ཡུཝཱབྷྱཱཾ ན ཛྙཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ཀིནྟུ ཏཽ ཏསྱཻཏདྭཱཀྱསྱ ཏཱཏྤཪྻྱཾ བོདྡྷུཾ ནཱཤཀྣུཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ཏཏཿ པརཾ ས ཏཱབྷྱཱཾ སཧ ནཱསརཏཾ གཏྭཱ ཏཡོཪྻཤཱིབྷཱུཏསྟསྠཽ ཀིནྟུ སཪྻྭཱ ཨེཏཱཿ ཀཐཱསྟསྱ མཱཏཱ མནསི སྠཱཔཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ཨཐ ཡཱིཤོ རྦུདྡྷིཿ ཤརཱིརཉྩ ཏཐཱ ཏསྨིན྄ ཨཱིཤྭརསྱ མཱནཝཱནཱཉྩཱནུགྲཧོ ཝརྡྡྷིཏུམ྄ ཨཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ཨནནྟརཾ ཏིབིརིཡཀཻསརསྱ རཱཛཏྭསྱ པཉྩདཤེ ཝཏྶརེ སཏི ཡདཱ པནྟཱིཡཔཱིལཱཏོ ཡིཧཱུདཱདེཤཱདྷིཔཏི རྷེརོད྄ ཏུ གཱལཱིལྤྲདེཤསྱ རཱཛཱ ཕིལིཔནཱམཱ ཏསྱ བྷྲཱཏཱ ཏུ ཡིཏཱུརིཡཱཡཱསྟྲཱཁོནཱིཏིཡཱཔྲདེཤསྱ ཙ རཱཛཱསཱིཏ྄ ལུཥཱནཱིཡནཱམཱ ཨཝིལཱིནཱིདེཤསྱ རཱཛཱསཱིཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ཧཱནན྄ ཀིཡཕཱཤྩེམཽ པྲདྷཱནཡཱཛཱཀཱཝཱསྟཱཾ ཏདཱནཱིཾ སིཁརིཡསྱ པུཏྲཱཡ ཡོཧནེ མདྷྱེཔྲཱནྟརམ྄ ཨཱིཤྭརསྱ ཝཱཀྱེ པྲཀཱཤིཏེ སཏི ");
INSERT INTO santib_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ས ཡརྡྡན ཨུབྷཡཏཊཔྲདེཤཱན྄ སམེཏྱ པཱཔམོཙནཱརྠཾ མནཿཔརཱཝརྟྟནསྱ ཙིཧྣརཱུཔཾ ཡནྨཛྫནཾ ཏདཱིཡཱཿ ཀཐཱཿ སཪྻྭཏྲ པྲཙཱརཡིཏུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ཡིཤཡིཡབྷཝིཥྱདྭཀྟྲྀགྲནྠེ ཡཱདྲྀཤཱི ལིཔིརཱསྟེ ཡཐཱ, པརམེཤསྱ པནྠཱནཾ པརིཥྐུརུཏ སཪྻྭཏཿ། ཏསྱ རཱཛཔཐཉྩཻཝ སམཱནཾ ཀུརུཏཱདྷུནཱ། ");
INSERT INTO santib_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ཀཱརིཥྱནྟེ སམུཙྪྲཱཡཱཿ སཀལཱ ནིམྣབྷཱུམཡཿ། ཀཱརིཥྱནྟེ ནཏཱཿ སཪྻྭེ པཪྻྭཏཱཤྩོཔཔཪྻྭཏཱཿ། ཀཱརིཥྱནྟེ ཙ ཡཱ ཝཀྲཱསྟཱཿ སཪྻྭཱཿ སརལཱ བྷུཝཿ། ཀཱརིཥྱནྟེ སམཱནཱསྟཱ ཡཱ ཨུཙྩནཱིཙབྷཱུམཡཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ཨཱིཤྭརེཎ ཀྲྀཏཾ ཏྲཱཎཾ དྲཀྵྱནྟི སཪྻྭམཱནཝཱཿ། ཨིཏྱེཏཏ྄ པྲཱནྟརེ ཝཱཀྱཾ ཝདཏཿ ཀསྱཙིད྄ རཝཿ༎ ");
INSERT INTO santib_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ཡེ ཡེ ལོཀཱ མཛྫནཱརྠཾ བཧིརཱཡཡུསྟཱན྄ སོཝདཏ྄ རེ རེ སརྤཝཾཤཱ ཨཱགཱམིནཿ ཀོཔཱཏ྄ པལཱཡིཏུཾ ཡུཥྨཱན྄ ཀཤྩེཏཡཱམཱས? ");
INSERT INTO santib_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ཏསྨཱད྄ ཨིབྲཱཧཱིམ྄ ཨསྨཱཀཾ པིཏཱ ཀཐཱམཱིདྲྀཤཱིཾ མནོབྷི རྣ ཀཐཡིཏྭཱ ཡཱུཡཾ མནཿཔརིཝརྟྟནཡོགྱཾ ཕལཾ ཕལཏ; ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི པཱཥཱཎེབྷྱ ཨེཏེབྷྱ ཨཱིཤྭར ཨིབྲཱཧཱིམཿ སནྟཱནོཏྤཱདནེ སམརྠཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ཨཔརཉྩ ཏརུམཱུལེ྅དྷུནཱཔི པརཤུཿ སཾལགྣོསྟི ཡསྟརུརུཏྟམཾ ཕལཾ ན ཕལཏི ས ཚིདྱཏེ྅གྣཽ ནིཀྵིཔྱཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ཏདཱནཱིཾ ལོཀཱསྟཾ པཔྲཙྪུསྟརྷི ཀིཾ ཀརྟྟཝྱམསྨཱབྷིཿ? ");
INSERT INTO santib_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ཏཏཿ སོཝཱདཱིཏ྄ ཡསྱ དྭེ ཝསནེ ཝིདྱེཏེ ས ཝསྟྲཧཱིནཱཡཻཀཾ ཝིཏརཏུ ཀིཾཉྩ ཡསྱ ཁཱདྱདྲཝྱཾ ཝིདྱཏེ སོཔི ཏཐཻཝ ཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ཏཏཿ པརཾ ཀརསཉྩཱཡིནོ མཛྫནཱརྠམ྄ ཨཱགཏྱ པཔྲཙྪུཿ ཧེ གུརོ ཀིཾ ཀརྟྟཝྱམསྨཱབྷིཿ? ");
INSERT INTO santib_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ཏཏཿ སོཀཐཡཏ྄ ནིརཱུཔིཏཱདདྷིཀཾ ན གྲྀཧླིཏ། ");
INSERT INTO santib_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ཨནནྟརཾ སེནཱགཎ ཨེཏྱ པཔྲཙྪ ཀིམསྨཱབྷི ཪྻཱ ཀརྟྟཝྱམ྄? ཏཏཿ སོབྷིདདྷེ ཀསྱ ཀཱམཔི ཧཱནིཾ མཱ ཀཱརྵྚ ཏཐཱ མྲྀཥཱཔཝཱདཾ མཱ ཀུརུཏ ནིཛཝེཏནེན ཙ སནྟུཥྱ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ཨཔརཉྩ ལོཀཱ ཨཔེཀྵཡཱ སྠིཏྭཱ སཪྻྭེཔཱིཏི མནོབྷི ཪྻིཏརྐཡཱཉྩཀྲུཿ, ཡོཧནཡམ྄ ཨབྷིཥིཀྟསྟྲཱཏཱ ན ཝེཏི? ");
INSERT INTO santib_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ཏདཱ ཡོཧན྄ སཪྻྭཱན྄ ཝྱཱཛཧཱར, ཛལེ྅ཧཾ ཡུཥྨཱན྄ མཛྫཡཱམི སཏྱཾ ཀིནྟུ ཡསྱ པཱདུཀཱབནྡྷནཾ མོཙཡིཏུམཔི ན ཡོགྱོསྨི ཏཱདྲྀཤ ཨེཀོ མཏྟོ གུརུཏརཿ པུམཱན྄ ཨེཏི, ས ཡུཥྨཱན྄ ཝཧྣིརཱུཔེ པཝིཏྲ ཨཱཏྨནི མཛྫཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ཨཔརཉྩ ཏསྱ ཧསྟེ ཤཱུརྤ ཨཱསྟེ ས སྭཤསྱཱནི ཤུདྡྷརཱུཔཾ པྲསྥོཊྱ གོདྷཱུམཱན྄ སཪྻྭཱན྄ བྷཱཎྜཱགཱརེ སཾགྲཧཱིཥྱཏི ཀིནྟུ བཱུཥཱཎི སཪྻྭཱཎྱནིཪྻྭཱཎཝཧྣིནཱ དཱཧཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ཡོཧན྄ ཨུཔདེཤེནེཏྠཾ ནཱནཱཀཐཱ ལོཀཱནཱཾ སམཀྵཾ པྲཙཱརཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ཨཔརཉྩ ཧེརོད྄ རཱཛཱ ཕིལིཔྣཱམྣཿ སཧོདརསྱ བྷཱཪྻྱཱཾ ཧེརོདིཡཱམདྷི ཏཐཱནྱཱནི ཡཱནི ཡཱནི ཀུཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཏདདྷི ཙ ");
INSERT INTO santib_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ཡོཧནཱ ཏིརསྐྲྀཏོ བྷཱུཏྭཱ ཀཱརཱགཱརེ ཏསྱ བནྡྷནཱད྄ ཨཔརམཔི ཀུཀརྨྨ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ཨིཏཿ པཱུཪྻྭཾ ཡསྨིན྄ སམཡེ སཪྻྭེ ཡོཧནཱ མཛྫིཏཱསྟདཱནཱིཾ ཡཱིཤུརཔྱཱགཏྱ མཛྫིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ཏདནནྟརཾ ཏེན པྲཱརྠིཏེ མེགྷདྭཱརཾ མུཀྟཾ ཏསྨཱཙྩ པཝིཏྲ ཨཱཏྨཱ མཱུརྟྟིམཱན྄ བྷཱུཏྭཱ ཀཔོཏཝཏ྄ ཏདུཔཪྻྱཝརུརོཧ; ཏདཱ ཏྭཾ མམ པྲིཡཿ པུཏྲསྟྭཡི མམ པརམཿ སནྟོཥ ཨིཏྱཱཀཱཤཝཱཎཱི བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ཏདཱནཱིཾ ཡཱིཤུཿ པྲཱཡེཎ ཏྲིཾཤདྭརྵཝཡསྐ ཨཱསཱིཏ྄། ལཽཀིཀཛྙཱནེ ཏུ ས ཡཱུཥཕཿ པུཏྲཿ, ");
INSERT INTO santib_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ཡཱུཥཕ྄ ཨེལེཿ པུཏྲཿ, ཨེལིརྨཏྟཏཿ པུཏྲཿ, མཏྟཏ྄ ལེཝེཿ པུཏྲཿ, ལེཝི རྨལྐེཿ པུཏྲཿ, མལྐིཪྻཱནྣསྱ པུཏྲཿ; ཡཱནྣོ ཡཱུཥཕཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ཡཱུཥཕ྄ མཏྟཐིཡསྱ པུཏྲཿ, མཏྟཐིཡ ཨཱམོསཿ པུཏྲཿ, ཨཱམོས྄ ནཧཱུམཿ པུཏྲཿ, ནཧཱུམ྄ ཨིཥླེཿ པུཏྲཿ ཨིཥླིརྣགེཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ནགིརྨཱཊཿ པུཏྲཿ, མཱཊ྄ མཏྟཐིཡསྱ པུཏྲཿ, མཏྟཐིཡཿ ཤིམིཡེཿ པུཏྲཿ, ཤིམིཡིཪྻཱུཥཕཿ པུཏྲཿ, ཡཱུཥཕ྄ ཡིཧཱུདཱཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ཡིཧཱུདཱ ཡོཧཱནཱཿ པུཏྲཿ, ཡོཧཱནཱ རཱིཥཱཿ པུཏྲཿ, རཱིཥཱཿ སིརུབྦཱབིལཿ པུཏྲཿ, སིརུབྦཱབིལ྄ ཤལྟཱིཡེལཿ པུཏྲཿ, ཤལྟཱིཡེལ྄ ནེརེཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ནེརིརྨལྐེཿ པུཏྲཿ, མལྐིཿ ཨདྱཿ པུཏྲཿ, ཨདྡཱི ཀོཥམཿ པུཏྲཿ, ཀོཥམ྄ ཨིལྨོདདཿ པུཏྲཿ, ཨིལྨོདད྄ ཨེརཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ཨེར྄ ཡོཤེཿ པུཏྲཿ, ཡོཤིཿ ཨིལཱིཡེཥརཿ པུཏྲཿ, ཨིལཱིཡེཥར྄ ཡོརཱིམཿ པུཏྲཿ, ཡོརཱིམ྄ མཏྟཏཿ པུཏྲཿ, མཏྟཏ ལེཝེཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ལེཝིཿ ཤིམིཡོནཿ པུཏྲཿ, ཤིམིཡོན྄ ཡིཧཱུདཱཿ པུཏྲཿ, ཡིཧཱུདཱ ཡཱུཥུཕཿ པུཏྲཿ, ཡཱུཥུཕ྄ ཡོནནཿ པུཏྲཿ, ཡཱནན྄ ཨིལཱིཡཱཀཱིམཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ཨིལིཡཱཀཱིམ྄ཿ མིལེཡཱཿ པུཏྲཿ, མིལེཡཱ མཻནནཿ པུཏྲཿ, མཻནན྄ མཏྟཏྟསྱ པུཏྲཿ, མཏྟཏྟོ ནཱཐནཿ པུཏྲཿ, ནཱཐན྄ དཱཡཱུདཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","དཱཡཱུད྄ ཡིཤཡཿ པུཏྲཿ, ཡིཤཡ ཨོབེདཿ པུཏྲ, ཨོབེད྄ བོཡསཿ པུཏྲཿ, བོཡས྄ སལྨོནཿ པུཏྲཿ, སལྨོན྄ ནཧཤོནཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ནཧཤོན྄ ཨམྨཱིནཱདབཿ པུཏྲཿ, ཨམྨཱིནཱདབ྄ ཨརཱམཿ པུཏྲཿ, ཨརཱམ྄ ཧིཥྲོཎཿ པུཏྲཿ, ཧིཥྲོཎ྄ པེརསཿ པུཏྲཿ, པེརས྄ ཡིཧཱུདཱཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ཡིཧཱུདཱ ཡཱཀཱུབཿ པུཏྲཿ, ཡཱཀཱུབ྄ ཨིསྷཱཀཿ པུཏྲཿ, ཨིསྷཱཀ྄ ཨིབྲཱཧཱིམཿ པུཏྲཿ, ཨིབྲཱཧཱིམ྄ ཏེརཧཿ པུཏྲཿ, ཏེརཧ྄ ནཱཧོརཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ནཱཧོར྄ སིརུགཿ པུཏྲཿ, སིརུག྄ རིཡྭཿ པུཏྲཿ, རིཡཱུཿ པེལགཿ པུཏྲཿ, པེལག྄ ཨེཝརཿ པུཏྲཿ, ཨེཝར྄ ཤེལཧཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ཤེལཧ྄ ཀཻནནཿ པུཏྲཿ, ཀཻནན྄ ཨརྥཀྵདཿ པུཏྲཿ, ཨརྥཀྵད྄ ཤཱམཿ པུཏྲཿ, ཤཱམ྄ ནོཧཿ པུཏྲཿ, ནོཧོ ལེམཀཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ལེམཀ྄ མིཐཱུཤེལཧཿ པུཏྲཿ, མིཐཱུཤེལཧ྄ ཧནོཀཿ པུཏྲཿ, ཧནོཀ྄ ཡེརདཿ པུཏྲཿ, ཡེརད྄ མཧལལེལཿ པུཏྲཿ, མཧལལེལ྄ ཀཻནནཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ཀཻནན྄ ཨིནོཤཿ པུཏྲཿ, ཨིནོཤ྄ ཤེཏཿ པུཏྲཿ, ཤེཏ྄ ཨཱདམཿ པུཏྲ, ཨཱདམ྄ ཨཱིཤྭརསྱ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ཏཏཿ པརཾ ཡཱིཤུཿ པཝིཏྲེཎཱཏྨནཱ པཱུརྞཿ སན྄ ཡརྡྡནནདྱཱཿ པརཱཝྲྀཏྱཱཏྨནཱ པྲཱནྟརཾ ནཱིཏཿ སན྄ ཙཏྭཱརིཾཤདྡིནཱནི ཡཱཝཏ྄ ཤཻཏཱནཱ པརཱིཀྵིཏོ྅བྷཱུཏ྄, ");
INSERT INTO santib_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ཀིཉྩ ཏཱནི སཪྻྭདིནཱནི བྷོཛནཾ ཝིནཱ སྠིཏཏྭཱཏ྄ ཀཱལེ པཱུརྞེ ས ཀྵུདྷིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ཏཏཿ ཤཻཏཱནཱགཏྱ ཏམཝདཏ྄ ཏྭཾ ཙེདཱིཤྭརསྱ པུཏྲསྟརྷི པྲསྟརཱནེཏཱན྄ ཨཱཛྙཡཱ པཱུཔཱན྄ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ཏདཱ ཡཱིཤུརུཝཱཙ, ལིཔིརཱིདྲྀཤཱི ཝིདྱཏེ མནུཛཿ ཀེཝལེན པཱུཔེན ན ཛཱིཝཏི ཀིནྟྭཱིཤྭརསྱ སཪྻྭཱབྷིརཱཛྙཱབྷི རྫཱིཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ཏདཱ ཤཻཏཱན྄ ཏམུཙྩཾ པཪྻྭཏཾ ནཱིཏྭཱ ནིམིཥཻཀམདྷྱེ ཛགཏཿ སཪྻྭརཱཛྱཱནི དརྴིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","པཤྩཱཏ྄ ཏམཝཱདཱིཏ྄ སཪྻྭམ྄ ཨེཏད྄ ཝིབྷཝཾ པྲཏཱཔཉྩ ཏུབྷྱཾ དཱསྱཱམི ཏན྄ མཡི སམརྤིཏམཱསྟེ ཡཾ པྲཏི མམེཙྪཱ ཛཱཡཏེ ཏསྨཻ དཱཏུཾ ཤཀྣོམི, ");
INSERT INTO santib_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ཏྭཾ ཙེནྨཱཾ བྷཛསེ ཏརྷི སཪྻྭམེཏཏ྄ ཏཝཻཝ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ཏདཱ ཡཱིཤུསྟཾ པྲཏྱུཀྟཝཱན྄ དཱུརཱི བྷཝ ཤཻཏཱན྄ ལིཔིརཱསྟེ, ནིཛཾ པྲབྷུཾ པརམེཤྭརཾ བྷཛསྭ ཀེཝལཾ ཏམེཝ སེཝསྭ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ཨཐ ཤཻཏཱན྄ ཏཾ ཡིརཱུཤཱལམཾ ནཱིཏྭཱ མནྡིརསྱ ཙཱུཌཱཡཱ ཨུཔརི སམུཔཝེཤྱ ཛགཱད ཏྭཾ ཙེདཱིཤྭརསྱ པུཏྲསྟརྷི སྠཱནཱདིཏོ ལམྥིཏྭཱདྷཿ ");
INSERT INTO santib_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","པཏ ཡཏོ ལིཔིརཱསྟེ, ཨཱཛྙཱཔཡིཥྱཏི སྭཱིཡཱན྄ དཱུཏཱན྄ ས པརམེཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","རཀྵིཏུཾ སཪྻྭམཱརྒེ ཏྭཱཾ ཏེན ཏྭཙྩརཎེ ཡཐཱ། ན ལགེཏ྄ པྲསྟརཱགྷཱཏསྟྭཱཾ དྷརིཥྱནྟི ཏེ ཏཐཱ། ");
INSERT INTO santib_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ཏདཱ ཡཱིཤུནཱ པྲཏྱུཀྟམ྄ ཨིདམཔྱུཀྟམསྟི ཏྭཾ སྭཔྲབྷུཾ པརེཤཾ མཱ པརཱིཀྵསྭ། ");
INSERT INTO santib_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","པཤྩཱཏ྄ ཤཻཏཱན྄ སཪྻྭཔརཱིཀྵཱཾ སམཱཔྱ ཀྵཎཱཏྟཾ ཏྱཀྟྭཱ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ཏདཱ ཡཱིཤུརཱཏྨཔྲབྷཱཝཱཏ྄ པུནརྒཱལཱིལྤྲདེཤཾ གཏསྟདཱ ཏཏྶུཁྱཱཏིཤྩཏུརྡིཤཾ ཝྱཱནཤེ། ");
INSERT INTO santib_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ས ཏེཥཱཾ བྷཛནགྲྀཧེཥུ ཨུཔདིཤྱ སཪྻྭཻཿ པྲཤཾསིཏོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ཨཐ ས སྭཔཱལནསྠཱནཾ ནཱསརཏྤུརམེཏྱ ཝིཤྲཱམཝཱརེ སྭཱཙཱརཱད྄ བྷཛནགེཧཾ པྲཝིཤྱ པཋིཏུམུཏྟསྠཽ། ");
INSERT INTO santib_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ཏཏོ ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཿ པུསྟཀེ ཏསྱ ཀརདཏྟེ སཏི ས ཏཏ྄ པུསྟཀཾ ཝིསྟཱཪྻྱ ཡཏྲ ཝཀྵྱམཱཎཱནི ཝཙནཱནི སནྟི ཏཏ྄ སྠཱནཾ པྲཱཔྱ པཔཱཋ། ");
INSERT INTO santib_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ཨཱཏྨཱ ཏུ པརམེཤསྱ མདཱིཡོཔརི ཝིདྱཏེ། དརིདྲེཥུ སུསཾཝཱདཾ ཝཀྟུཾ མཱཾ སོབྷིཥིཀྟཝཱན྄། བྷགྣཱནྟཿ ཀརཎཱལློཀཱན྄ སུསྭསྠཱན྄ ཀརྟྟུམེཝ ཙ། བནྡཱིཀྲྀཏེཥུ ལོཀེཥུ མུཀྟེ རྒྷོཥཡིཏུཾ ཝཙཿ། ནེཏྲཱཎི དཱཏུམནྡྷེབྷྱསྟྲཱཏུཾ བདྡྷཛནཱནཔི། ");
INSERT INTO santib_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","པརེཤཱནུགྲཧེ ཀཱལཾ པྲཙཱརཡིཏུམེཝ ཙ། སཪྻྭཻཏཏྐརཎཱརྠཱཡ མཱམེཝ པྲཧིཎོཏི སཿ༎ ");
INSERT INTO santib_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ཏཏཿ པུསྟཀཾ བདྭྭཱ པརིཙཱརཀསྱ ཧསྟེ སམརྤྱ ཙཱསནེ སམུཔཝིཥྚཿ, ཏཏོ བྷཛནགྲྀཧེ ཡཱཝནྟོ ལོཀཱ ཨཱསན྄ ཏེ སཪྻྭེ྅ནནྱདྲྀཥྚྱཱ ཏཾ ཝིལུལོཀིརེ། ");
INSERT INTO santib_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ཨནནྟརམ྄ ཨདྱཻཏཱནི སཪྻྭཱཎི ལིཁིཏཝཙནཱནི ཡུཥྨཱཀཾ མདྷྱེ སིདྡྷཱནི ས ཨིམཱཾ ཀཐཱཾ ཏེབྷྱཿ ཀཐཡིཏུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ཏཏཿ སཪྻྭེ ཏསྨིན྄ ཨནྭརཛྱནྟ, ཀིཉྩ ཏསྱ མུཁཱནྣིརྒཏཱབྷིརནུགྲཧསྱ ཀཐཱབྷིཤྩམཏྐྲྀཏྱ ཀཐཡཱམཱསུཿ ཀིམཡཾ ཡཱུཥཕཿ པུཏྲོ ན? ");
INSERT INTO santib_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ཏདཱ སོ྅ཝཱདཱིད྄ ཧེ ཙིཀིཏྶཀ སྭམེཝ སྭསྠཾ ཀུརུ ཀཕརྣཱཧཱུམི ཡདྱཏ྄ ཀྲྀཏཝཱན྄ ཏདཤྲཽཥྨ ཏཱཿ སཪྻཱཿ ཀྲིཡཱ ཨཏྲ སྭདེཤེ ཀུརུ ཀཐཱམེཏཱཾ ཡཱུཡམེཝཱཝཤྱཾ མཱཾ ཝདིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","པུནཿ སོཝཱདཱིད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཀོཔི བྷཝིཥྱདྭཱདཱི སྭདེཤེ སཏྐཱརཾ ན པྲཱཔྣོཏི། ");
INSERT INTO santib_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ཨཔརཉྩ ཡཐཱརྠཾ ཝཙྨི, ཨེལིཡསྱ ཛཱིཝནཀཱལེ ཡདཱ སཱརྡྡྷཏྲིཏཡཝརྵཱཎི ཡཱཝཏ྄ ཛལདཔྲཏིབནྡྷཱཏ྄ སཪྻྭསྨིན྄ དེཤེ མཧཱདུརྦྷིཀྵམ྄ ཨཛནིཥྚ ཏདཱནཱིམ྄ ཨིསྲཱཡེལོ དེཤསྱ མདྷྱེ བཧྭྱོ ཝིདྷཝཱ ཨཱསན྄, ");
INSERT INTO santib_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ཀིནྟུ སཱིདོནྤྲདེཤཱིཡསཱརིཕཏྤུརནིཝཱསིནཱིམ྄ ཨེཀཱཾ ཝིདྷཝཱཾ ཝིནཱ ཀསྱཱཤྩིདཔི སམཱིཔེ ཨེལིཡཿ པྲེརིཏོ ནཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ཨཔརཉྩ ཨིལཱིཤཱཡབྷཝིཥྱདྭཱདིཝིདྱམཱནཏཱཀཱལེ ཨིསྲཱཡེལྡེཤེ བཧཝཿ ཀུཥྛིན ཨཱསན྄ ཀིནྟུ སུརཱིཡདེཤཱིཡཾ ནཱམཱནྐུཥྛིནཾ ཝིནཱ ཀོཔྱནྱཿ པརིཥྐྲྀཏོ ནཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ཨིམཱཾ ཀཐཱཾ ཤྲུཏྭཱ བྷཛནགེཧསྠིཏཱ ལོཀཱཿ སཀྲོདྷམ྄ ཨུཏྠཱཡ ");
INSERT INTO santib_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ནགརཱཏྟཾ བཧིཥྐྲྀཏྱ ཡསྱ ཤིཁརིཎ ཨུཔརི ཏེཥཱཾ ནགརཾ སྠཱཔིཏམཱསྟེ ཏསྨཱནྣིཀྵེཔྟུཾ ཏསྱ ཤིཁརཾ ཏཾ ནིནྱུཿ ");
INSERT INTO santib_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ཀིནྟུ ས ཏེཥཱཾ མདྷྱཱདཔསྲྀཏྱ སྠཱནཱནྟརཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ཏཏཿ པརཾ ཡཱིཤུརྒཱལཱིལྤྲདེཤཱིཡཀཕརྣཱཧཱུམྣགར ཨུཔསྠཱཡ ཝིཤྲཱམཝཱརེ ལོཀཱནུཔདེཥྚུམ྄ ཨཱརབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ཏདུཔདེཤཱཏ྄ སཪྻྭེ ཙམཙྩཀྲུ ཪྻཏསྟསྱ ཀཐཱ གུརུཏརཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ཏདཱནཱིཾ ཏདྦྷཛནགེཧསྠིཏོ྅མེདྷྱབྷཱུཏགྲསྟ ཨེཀོ ཛན ཨུཙྩཻཿ ཀཐཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ཧེ ནཱསརཏཱིཡཡཱིཤོ྅སྨཱན྄ ཏྱཛ, ཏྭཡཱ སཧཱསྨཱཀཾ ཀཿ སམྦནྡྷཿ? ཀིམསྨཱན྄ ཝིནཱཤཡིཏུམཱཡཱསི? ཏྭམཱིཤྭརསྱ པཝིཏྲོ ཛན ཨེཏདཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ཏདཱ ཡཱིཤུསྟཾ ཏརྫཡིཏྭཱཝདཏ྄ མཽནཱི བྷཝ ཨིཏོ བཧིརྦྷཝ; ཏཏཿ སོམེདྷྱབྷཱུཏསྟཾ མདྷྱསྠཱནེ པཱཏཡིཏྭཱ ཀིཉྩིདཔྱཧིཾསིཏྭཱ ཏསྨཱད྄ བཧིརྒཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ཏཏཿ སཪྻྭེ ལོཀཱཤྩམཏྐྲྀཏྱ པརསྤརཾ ཝཀྟུམཱརེབྷིརེ ཀོཡཾ ཙམཏྐཱརཿ། ཨེཥ པྲབྷཱཝེཎ པརཱཀྲམེཎ ཙཱམེདྷྱབྷཱུཏཱན྄ ཨཱཛྙཱཔཡཏི ཏེནཻཝ ཏེ བཧིརྒཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ཨནནྟརཾ ཙཏུརྡིཀྶྠདེཤཱན྄ ཏསྱ སུཁྱཱཏིཪྻྱཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ཏདནནྟརཾ ས བྷཛནགེཧཱད྄ བཧིརཱགཏྱ ཤིམོནོ ནིཝེཤནཾ པྲཝིཝེཤ ཏདཱ ཏསྱ ཤྭཤྲཱུརྫྭརེཎཱཏྱནྟཾ པཱིཌིཏཱསཱིཏ྄ ཤིཥྱཱསྟདརྠཾ ཏསྨིན྄ ཝིནཡཾ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ཏཏཿ ས ཏསྱཱཿ སམཱིཔེ སྠིཏྭཱ ཛྭརཾ ཏརྫཡཱམཱས ཏེནཻཝ ཏཱཾ ཛྭརོ྅ཏྱཱཀྵཱིཏ྄ ཏཏཿ སཱ ཏཏྐྵཎམ྄ ཨུཏྠཱཡ ཏཱན྄ སིཥེཝེ། ");
INSERT INTO santib_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ཨཐ སཱུཪྻྱཱསྟཀཱལེ སྭེཥཱཾ ཡེ ཡེ ཛནཱ ནཱནཱརོགཻཿ པཱིཌིཏཱ ཨཱསན྄ ལོཀཱསྟཱན྄ ཡཱིཤོཿ སམཱིཔམ྄ ཨཱནིནྱུཿ, ཏདཱ ས ཨེཀཻཀསྱ གཱཏྲེ ཀརམརྤཡིཏྭཱ ཏཱནརོགཱན྄ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ཏཏོ བྷཱུཏཱ བཧུབྷྱོ ནིརྒཏྱ ཙཱིཏྴབྡཾ ཀྲྀཏྭཱ ཙ བབྷཱཥིརེ ཏྭམཱིཤྭརསྱ པུཏྲོ྅བྷིཥིཀྟཏྲཱཏཱ; ཀིནྟུ སོབྷིཥིཀྟཏྲཱཏེཏི ཏེ ཝིཝིདུརེཏསྨཱཏ྄ ཀཱརཎཱཏ྄ ཏཱན྄ ཏརྫཡིཏྭཱ ཏདྭཀྟུཾ ནིཥིཥེདྷ། ");
INSERT INTO santib_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ཨཔརཉྩ པྲབྷཱཏེ སཏི ས ཝིཛནསྠཱནཾ པྲཏསྠེ པཤྩཱཏ྄ ཛནཱསྟམནྭིཙྪནྟསྟནྣིཀཊཾ གཏྭཱ སྠཱནཱནྟརགམནཱརྠཾ ཏམནྭརུནྡྷན྄། ");
INSERT INTO santib_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ཀིནྟུ ས ཏཱན྄ ཛགཱད, ཨཱིཤྭརཱིཡརཱཛྱསྱ སུསཾཝཱདཾ པྲཙཱརཡིཏུམ྄ ཨནྱཱནི པུརཱཎྱཔི མཡཱ ཡཱཏཝྱཱནི ཡཏསྟདརྠམེཝ པྲེརིཏོཧཾ། ");
INSERT INTO santib_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ཨཐ གཱལཱིལོ བྷཛནགེཧེཥུ ས ཨུཔདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ཨནནྟརཾ ཡཱིཤུརེཀདཱ གིནེཥརཐྡསྱ ཏཱིར ཨུཏྟིཥྛཏི, ཏདཱ ལོཀཱ ཨཱིཤྭརཱིཡཀཐཱཾ ཤྲོཏུཾ ཏདུཔརི པྲཔཏིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ཏདཱནཱིཾ ས ཧྡསྱ ཏཱིརསམཱིཔེ ནཽདྭཡཾ དདརྴ ཀིཉྩ མཏྶྱོཔཛཱིཝིནོ ནཱཝཾ ཝིཧཱཡ ཛཱལཾ པྲཀྵཱལཡནྟི། ");
INSERT INTO santib_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ཏཏསྟཡོརྡྭཡོ རྨདྷྱེ ཤིམོནོ ནཱཝམཱརུཧྱ ཏཱིརཱཏ྄ ཀིཉྩིདྡཱུརཾ ཡཱཏུཾ ཏསྨིན྄ ཝིནཡཾ ཀྲྀཏྭཱ ནཽཀཱཡཱམུཔཝིཤྱ ལོཀཱན྄ པྲོཔདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","པཤྩཱཏ྄ ཏཾ པྲསྟཱཝཾ སམཱཔྱ ས ཤིམོནཾ ཝྱཱཛཧཱར, གབྷཱིརཾ ཛལཾ གཏྭཱ མཏྶྱཱན྄ དྷརྟྟུཾ ཛཱལཾ ནིཀྵིཔ། ");
INSERT INTO santib_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ཏཏཿ ཤིམོན བབྷཱཥེ, ཧེ གུརོ ཡདྱཔི ཝཡཾ ཀྲྀཏྶྣཱཾ ཡཱམིནཱིཾ པརིཤྲམྱ མཏྶྱཻཀམཔི ན པྲཱཔྟཱསྟཐཱཔི བྷཝཏོ ནིདེཤཏོ ཛཱལཾ ཀྵིཔཱམཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ཨཐ ཛཱལེ ཀྵིཔྟེ བཧུམཏྶྱཔཏནཱད྄ ཨཱནཱཡཿ པྲཙྪིནྣཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ཏསྨཱད྄ ཨུཔཀརྟྟུམ྄ ཨནྱནཽསྠཱན྄ སངྒིན ཨཱཡཱཏུམ྄ ཨིངྒིཏེན སམཱཧྭཡན྄ ཏཏསྟ ཨཱགཏྱ མཏྶྱཻ རྣཽདྭཡཾ པྲཔཱུརཡཱམཱསུ ཪྻཻ རྣཽདྭཡཾ པྲམགྣམ྄། ");
INSERT INTO santib_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ཏདཱ ཤིམོནྤིཏརསྟད྄ ཝིལོཀྱ ཡཱིཤོཤྩརཎཡོཿ པཏིཏྭཱ, ཧེ པྲབྷོཧཾ པཱཔཱི ནརོ མམ ནིཀཊཱད྄ བྷཝཱན྄ ཡཱཏུ, ཨིཏི ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ཡཏོ ཛཱལེ པཏིཏཱནཱཾ མཏྶྱཱནཱཾ ཡཱུཐཱཏ྄ ཤིམོན྄ ཏཏྶངྒིནཤྩ ཙམཏྐྲྀཏཝནྟཿ; ཤིམོནཿ སཧཀཱརིཎཽ སིཝདེཿ པུཏྲཽ ཡཱཀཱུབ྄ ཡོཧན྄ ཙེམཽ ཏཱདྲྀཤཽ བབྷཱུཝཏུཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ཏདཱ ཡཱིཤུཿ ཤིམོནཾ ཛགཱད མཱ བྷཻཥཱིརདྱཱརབྷྱ ཏྭཾ མནུཥྱདྷརོ བྷཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ཨནནྟརཾ སཪྻྭཱསུ ནཽསུ ཏཱིརམ྄ ཨཱནཱིཏཱསུ ཏེ སཪྻྭཱན྄ པརིཏྱཛྱ ཏསྱ པཤྩཱདྒཱམིནོ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ཏཏཿ པརཾ ཡཱིཤཽ ཀསྨིཾཤྩིཏ྄ པུརེ ཏིཥྛཏི ཛན ཨེཀཿ སཪྻྭཱངྒཀུཥྛསྟཾ ཝིལོཀྱ ཏསྱ སམཱིཔེ ནྱུབྫཿ པཏིཏྭཱ སཝིནཡཾ ཝཀྟུམཱརེབྷེ, ཧེ པྲབྷོ ཡདི བྷཝཱནིཙྪཏི ཏརྷི མཱཾ པརིཥྐརྟྟུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ཏདཱནཱིཾ ས པཱཎིཾ པྲསཱཪྻྱ ཏདངྒཾ སྤྲྀཤན྄ བབྷཱཥེ ཏྭཾ པརིཥྐྲིཡསྭེཏི མམེཙྪཱསྟི ཏཏསྟཏྐྵཎཾ ས ཀུཥྛཱཏ྄ མུཀྟཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","པཤྩཱཏ྄ ས ཏམཱཛྙཱཔཡཱམཱས ཀཐཱམིམཱཾ ཀསྨཻཙིད྄ ཨཀཐཡིཏྭཱ ཡཱཛཀསྱ སམཱིཔཉྩ གཏྭཱ སྭཾ དརྴཡ, ལོཀེབྷྱོ ནིཛཔརིཥྐྲྀཏཏྭསྱ པྲམཱཎདཱནཱཡ མཱུསཱཛྙཱནུསཱརེཎ དྲཝྱམུཏྨྲྀཛསྭ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ཏཐཱཔི ཡཱིཤོཿ སུཁྱཱཏི རྦཧུ ཝྱཱཔྟུམཱརེབྷེ ཀིཉྩ ཏསྱ ཀཐཱཾ ཤྲོཏུཾ སྭཱིཡརོགེབྷྱོ མོཀྟུཉྩ ལོཀཱ ཨཱཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ཨཐ ས པྲཱནྟརཾ གཏྭཱ པྲཱརྠཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ཨཔརཉྩ ཨེཀདཱ ཡཱིཤུརུཔདིཤཏི, ཨེཏརྷི གཱལཱིལྱིཧཱུདཱཔྲདེཤཡོཿ སཪྻྭནགརེབྷྱོ ཡིརཱུཤཱལམཤྩ ཀིཡནྟཿ ཕིརཱུཤིལོཀཱ ཝྱཝསྠཱཔཀཱཤྩ སམཱགཏྱ ཏདནྟིཀེ སམུཔཝིཝིཤུཿ, ཏསྨིན྄ ཀཱལེ ལོཀཱནཱམཱརོགྱཀཱརཎཱཏ྄ པྲབྷོཿ པྲབྷཱཝཿ པྲཙཀཱཤེ། ");
INSERT INTO santib_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","པཤྩཱཏ྄ ཀིཡནྟོ ལོཀཱ ཨེཀཾ པཀྵཱགྷཱཏིནཾ ཁཊྭཱཡཱཾ ནིདྷཱཡ ཡཱིཤོཿ སམཱིཔམཱནེཏུཾ སམྨུཁེ སྠཱཔཡིཏུཉྩ ཝྱཱཔྲིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ཀིནྟུ བཧུཛནནིཝཧསམྭཱདྷཱཏ྄ ན ཤཀྣུཝནྟོ གྲྀཧོཔརི གཏྭཱ གྲྀཧཔྲྀཥྛཾ ཁནིཏྭཱ ཏཾ པཀྵཱགྷཱཏིནཾ སཁཊྭཾ གྲྀཧམདྷྱེ ཡཱིཤོཿ སམྨུཁེ ྅ཝརོཧཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ཏདཱ ཡཱིཤུསྟེཥཱམ྄ ཨཱིདྲྀཤཾ ཝིཤྭཱསཾ ཝིལོཀྱ ཏཾ པཀྵཱགྷཱཏིནཾ ཝྱཱཛཧཱར, ཧེ མཱནཝ ཏཝ པཱཔམཀྵམྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ཏསྨཱད྄ ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ ཙིཏྟཻརིཏྠཾ པྲཙིནྟིཏཝནྟཿ, ཨེཥ ཛན ཨཱིཤྭརཾ ནིནྡཏི ཀོཡཾ? ཀེཝལམཱིཤྭརཾ ཝིནཱ པཱཔཾ ཀྵནྟུཾ ཀཿ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ཏདཱ ཡཱིཤུསྟེཥཱམ྄ ཨིཏྠཾ ཙིནྟནཾ ཝིདིཏྭཱ ཏེབྷྱོཀཐཡད྄ ཡཱུཡཾ མནོབྷིཿ ཀུཏོ ཝིཏརྐཡཐ? ");
INSERT INTO santib_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ཏཝ པཱཔཀྵམཱ ཛཱཏཱ ཡདྭཱ ཏྭམུཏྠཱཡ ཝྲཛ ཨེཏཡོ རྨདྷྱེ ཀཱ ཀཐཱ སུཀཐྱཱ? ");
INSERT INTO santib_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ཀིནྟུ པྲྀཐིཝྱཱཾ པཱཔཾ ཀྵནྟུཾ མཱནཝསུཏསྱ སཱམརྠྱམསྟཱིཏི ཡཐཱ ཡཱུཡཾ ཛྙཱཏུཾ ཤཀྣུཐ ཏདརྠཾ (ས ཏཾ པཀྵཱགྷཱཏིནཾ ཛགཱད) ཨུཏྟིཥྛ སྭཤཡྻཱཾ གྲྀཧཱིཏྭཱ གྲྀཧཾ ཡཱཧཱིཏི ཏྭཱམཱདིཤཱམི། ");
INSERT INTO santib_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ཏསྨཱཏ྄ ས ཏཏྐྵཎམ྄ ཨུཏྠཱཡ སཪྻྭེཥཱཾ སཱཀྵཱཏ྄ ནིཛཤཡནཱིཡཾ གྲྀཧཱིཏྭཱ ཨཱིཤྭརཾ དྷནྱཾ ཝདན྄ ནིཛནིཝེཤནཾ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ཏསྨཱཏ྄ སཪྻྭེ ཝིསྨཡ པྲཱཔྟཱ མནཿསུ བྷཱིཏཱཤྩ ཝཡམདྱཱསམྦྷཝཀཱཪྻྱཱཎྱདརྴཱམ ཨིཏྱུཀྟྭཱ པརམེཤྭརཾ དྷནྱཾ པྲོདིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ཏཏཿ པརཾ བཧིརྒཙྪན྄ ཀརསཉྩཡསྠཱནེ ལེཝིནཱམཱནཾ ཀརསཉྩཱཡཀཾ དྲྀཥྚྭཱ ཡཱིཤུསྟམབྷིདདྷེ མམ པཤྩཱདེཧི། ");
INSERT INTO santib_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ཏསྨཱཏ྄ ས ཏཏྐྵཎཱཏ྄ སཪྻྭཾ པརིཏྱཛྱ ཏསྱ པཤྩཱདིཡཱཡ། ");
INSERT INTO santib_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ཨནནྟརཾ ལེཝི རྣིཛགྲྀཧེ ཏདརྠཾ མཧཱབྷོཛྱཾ ཙཀཱར, ཏདཱ ཏཻཿ སཧཱནེཀེ ཀརསཉྩཱཡིནསྟདནྱལོཀཱཤྩ བྷོཀྟུམུཔཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ཏསྨཱཏ྄ ཀཱརཎཱཏ྄ ཙཎྜཱལཱནཱཾ པཱཔིལོཀཱནཱཉྩ སངྒེ ཡཱུཡཾ ཀུཏོ བྷཾགྡྷྭེ པིཝཐ ཙེཏི ཀཐཱཾ ཀཐཡིཏྭཱ ཕིརཱུཤིནོ྅དྷྱཱཔཀཱཤྩ ཏསྱ ཤིཥྱཻཿ སཧ ཝཱགྱུདྡྷཾ ཀརྟྟུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ཏསྨཱད྄ ཡཱིཤུསྟཱན྄ པྲཏྱཝོཙད྄ ཨརོགལོཀཱནཱཾ ཙིཀིཏྶཀེན པྲཡོཛནཾ ནཱསྟི ཀིནྟུ སརོགཱཎཱམེཝ། ");
INSERT INTO santib_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ཨཧཾ དྷཱརྨྨིཀཱན྄ ཨཱཧྭཱཏུཾ ནཱགཏོསྨི ཀིནྟུ མནཿ པརཱཝརྟྟཡིཏུཾ པཱཔིན ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ཏཏསྟེ པྲོཙུཿ, ཡོཧནཿ ཕིརཱུཤིནཱཉྩ ཤིཥྱཱ ཝཱརཾཝཱརམ྄ ཨུཔཝསནྟི པྲཱརྠཡནྟེ ཙ ཀིནྟུ ཏཝ ཤིཥྱཱཿ ཀུཏོ བྷུཉྫཏེ པིཝནྟི ཙ? ");
INSERT INTO santib_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ཏདཱ ས ཏཱནཱཙཁྱཽ ཝརེ སངྒེ ཏིཥྛཏི ཝརསྱ སཁིགཎཾ ཀིམུཔཝཱསཡིཏུཾ ཤཀྣུཐ? ");
INSERT INTO santib_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ཀིནྟུ ཡདཱ ཏེཥཱཾ ནིཀཊཱད྄ ཝརོ ནེཥྱཏེ ཏདཱ ཏེ སམུཔཝཏྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","སོཔརམཔི དྲྀཥྚཱནྟཾ ཀཐཡཱམྦབྷཱུཝ པུརཱཏནཝསྟྲེ ཀོཔི ནུཏནཝསྟྲཾ ན སཱིཝྱཏི ཡཏསྟེན སེཝནེན ཛཱིརྞཝསྟྲཾ ཚིདྱཏེ, ནཱུཏནཔུརཱཏནཝསྟྲཡོ རྨེལཉྩ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","པུརཱཏནྱཱཾ ཀུཏྭཱཾ ཀོཔི ནུཏནཾ དྲཱཀྵཱརསཾ ན ནིདདྷཱཏི, ཡཏོ ནཝཱིནདྲཱཀྵཱརསསྱ ཏེཛསཱ པུརཱཏནཱི ཀུཏཱུ ཪྻིདཱིཪྻྱཏེ ཏཏོ དྲཱཀྵཱརསཿ པཏཏི ཀུཏཱུཤྩ ནཤྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ཏཏོ ཧེཏོ རྣཱུཏནྱཱཾ ཀུཏྭཱཾ ནཝཱིནདྲཱཀྵཱརསཿ ནིདྷཱཏཝྱསྟེནོབྷཡསྱ རཀྵཱ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ཨཔརཉྩ པུརཱཏནཾ དྲཱཀྵཱརསཾ པཱིཏྭཱ ཀོཔི ནཱུཏནཾ ན ཝཱཉྪཏི, ཡཏཿ ས ཝཀྟི ནཱུཏནཱཏ྄ པུརཱཏནམ྄ པྲཤསྟམ྄། ");
INSERT INTO santib_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ཨཙརཉྩ པཪྻྭཎོ དྭིཏཱིཡདིནཱཏ྄ པརཾ པྲཐམཝིཤྲཱམཝཱརེ ཤསྱཀྵེཏྲེཎ ཡཱིཤོརྒམནཀཱལེ ཏསྱ ཤིཥྱཱཿ ཀཎིཤཾ ཚིཏྟྭཱ ཀརེཥུ མརྡྡཡིཏྭཱ ཁཱདིཏུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ཏསྨཱཏ྄ ཀིཡནྟཿ ཕིརཱུཤིནསྟཱནཝདན྄ ཝིཤྲཱམཝཱརེ ཡཏ྄ ཀརྨྨ ན ཀརྟྟཝྱཾ ཏཏ྄ ཀུཏཿ ཀུརུཐ? ");
INSERT INTO santib_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ཡཱིཤུཿ པྲཏྱུཝཱཙ དཱཡཱུད྄ ཏསྱ སངྒིནཤྩ ཀྵུདྷཱརྟྟཱཿ ཀིཾ ཙཀྲུཿ ས ཀཐམ྄ ཨཱིཤྭརསྱ མནྡིརཾ པྲཝིཤྱ ");
INSERT INTO santib_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ཡེ དརྴནཱིཡཱཿ པཱུཔཱ ཡཱཛཀཱན྄ ཝིནཱནྱསྱ ཀསྱཱཔྱབྷོཛནཱིཡཱསྟཱནཱནཱིཡ སྭཡཾ བུབྷཛེ སངྒིབྷྱོཔི དདཽ ཏཏ྄ ཀིཾ ཡུཥྨཱབྷིཿ ཀདཱཔི ནཱཔཱཋི? ");
INSERT INTO santib_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","པཤྩཱཏ྄ ས ཏཱནཝདཏ྄ མནུཛསུཏོ ཝིཤྲཱམཝཱརསྱཱཔི པྲབྷུ རྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ཨནནྟརམ྄ ཨནྱཝིཤྲཱམཝཱརེ ས བྷཛནགེཧཾ པྲཝིཤྱ སམུཔདིཤཏི། ཏདཱ ཏཏྶྠཱནེ ཤུཥྐདཀྵིཎཀར ཨེཀཿ པུམཱན྄ ཨུཔཏསྠིཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ཏསྨཱད྄ ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ ཏསྨིན྄ དོཥམཱརོཔཡིཏུཾ ས ཝིཤྲཱམཝཱརེ ཏསྱ སྭཱསྠྱཾ ཀརོཏི ནཝེཏི པྲཏཱིཀྵིཏུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ཏདཱ ཡཱིཤུསྟེཥཱཾ ཙིནྟཱཾ ཝིདིཏྭཱ ཏཾ ཤུཥྐཀརཾ པུམཱཾསཾ པྲོཝཱཙ, ཏྭམུཏྠཱཡ མདྷྱསྠཱནེ ཏིཥྛ། ");
INSERT INTO santib_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ཏསྨཱཏ྄ ཏསྨིན྄ ཨུཏྠིཏཝཏི ཡཱིཤུསྟཱན྄ ཝྱཱཛཧཱར, ཡུཥྨཱན྄ ཨིམཱཾ ཀཐཱཾ པྲྀཙྪཱམི, ཝིཤྲཱམཝཱརེ ཧིཏམ྄ ཨཧིཏཾ ཝཱ, པྲཱཎརཀྵཎཾ པྲཱཎནཱཤནཾ ཝཱ, ཨེཏེཥཱཾ ཀིཾ ཀརྨྨཀརཎཱིཡམ྄? ");
INSERT INTO santib_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","པཤྩཱཏ྄ ཙཏུརྡིཀྵུ སཪྻྭཱན྄ ཝིལོཀྱ ཏཾ མཱནཝཾ བབྷཱཥེ, ནིཛཀརཾ པྲསཱརཡ; ཏཏསྟེན ཏཐཱ ཀྲྀཏ ཨིཏརཀརཝཏ྄ ཏསྱ ཧསྟཿ སྭསྠོབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ཏསྨཱཏ྄ ཏེ པྲཙཎྜཀོཔཱནྭིཏཱ ཡཱིཤུཾ ཀིཾ ཀརིཥྱནྟཱིཏི པརསྤརཾ པྲམནྟྲིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ཏཏཿ པརཾ ས པཪྻྭཏམཱརུཧྱེཤྭརམུདྡིཤྱ པྲཱརྠཡམཱནཿ ཀྲྀཏྶྣཱཾ རཱཏྲིཾ ཡཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ཨཐ དིནེ སཏི ས སཪྻྭཱན྄ ཤིཥྱཱན྄ ཨཱཧཱུཏཝཱན྄ ཏེཥཱཾ མདྷྱེ ");
INSERT INTO santib_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","པིཏརནཱམྣཱ ཁྱཱཏཿ ཤིམོན྄ ཏསྱ བྷྲཱཏཱ ཨཱནྡྲིཡཤྩ ཡཱཀཱུབ྄ ཡོཧན྄ ཙ ཕིལིཔ྄ བརྠལམཡཤྩ ");
INSERT INTO santib_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","མཐིཿ ཐོམཱ ཨཱལྥཱིཡསྱ པུཏྲོ ཡཱཀཱུབ྄ ཛྭལནྟནཱམྣཱ ཁྱཱཏཿ ཤིམོན྄ ");
INSERT INTO santib_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ཙ ཡཱཀཱུབོ བྷྲཱཏཱ ཡིཧཱུདཱཤྩ ཏཾ ཡཿ པརཀརེཥུ སམརྤཡིཥྱཏི ས ཨཱིཥྐརཱིཡོཏཱིཡཡིཧཱུདཱཤྩཻཏཱན྄ དྭཱདཤ ཛནཱན྄ མནོནཱིཏཱན྄ ཀྲྀཏྭཱ ས ཛགྲཱཧ ཏཐཱ པྲེརིཏ ཨིཏི ཏེཥཱཾ ནཱམ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ཏཏཿ པརཾ ས ཏཻཿ སཧ པཪྻྭཏཱདཝརུཧྱ ཨུཔཏྱཀཱཡཱཾ ཏསྠཽ ཏཏསྟསྱ ཤིཥྱསངྒྷོ ཡིཧཱུདཱདེཤཱད྄ ཡིརཱུཤཱལམཤྩ སོརཿ སཱིདོནཤྩ ཛལདྷེ རོདྷསོ ཛནནིཧཱཤྩ ཨེཏྱ ཏསྱ ཀཐཱཤྲཝཎཱརྠཾ རོགམུཀྟྱརྠཉྩ ཏསྱ སམཱིཔེ ཏསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ཨམེདྷྱབྷཱུཏགྲསྟཱཤྩ ཏནྣིཀཊམཱགཏྱ སྭཱསྠྱཾ པྲཱཔུཿ། ");
INSERT INTO santib_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","སཪྻྭེཥཱཾ སྭཱསྠྱཀརཎཔྲབྷཱཝསྱ པྲཀཱཤིཏཏྭཱཏ྄ སཪྻྭེ ལོཀཱ ཨེཏྱ ཏཾ སྤྲཥྚུཾ ཡེཏིརེ། ");
INSERT INTO santib_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","པཤྩཱཏ྄ ས ཤིཥྱཱན྄ པྲཏི དྲྀཥྚིཾ ཀུཏྭཱ ཛགཱད, ཧེ དརིདྲཱ ཡཱུཡཾ དྷནྱཱ ཡཏ ཨཱིཤྭརཱིཡེ རཱཛྱེ ཝོ྅དྷིཀཱརོསྟི། ");
INSERT INTO santib_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ཧེ ཨདྷུནཱ ཀྵུདྷིཏལོཀཱ ཡཱུཡཾ དྷནྱཱ ཡཏོ ཡཱུཡཾ ཏརྤྶྱཐ; ཧེ ཨིཧ རོདིནོ ཛནཱ ཡཱུཡཾ དྷནྱཱ ཡཏོ ཡཱུཡཾ ཧསིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ཡདཱ ལོཀཱ མནུཥྱསཱུནོ རྣཱམཧེཏོ ཪྻུཥྨཱན྄ ཨྲྀृཏཱིཡིཥྱནྟེ པྲྀཐཀ྄ ཀྲྀཏྭཱ ནིནྡིཥྱནྟི, ཨདྷམཱནིཝ ཡུཥྨཱན྄ སྭསམཱིཔཱད྄ དཱུརཱིཀརིཥྱནྟི ཙ ཏདཱ ཡཱུཡཾ དྷནྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","སྭརྒེ ཡུཥྨཱཀཾ ཡཐེཥྚཾ ཕལཾ བྷཝིཥྱཏི, ཨེཏདརྠཾ ཏསྨིན྄ དིནེ པྲོལླསཏ ཨཱནནྡེན ནྲྀཏྱཏ ཙ, ཏེཥཱཾ པཱུཪྻྭཔུརུཥཱཤྩ བྷཝིཥྱདྭཱདིནཿ པྲཏི ཏཐཻཝ ཝྱཝཱཧརན྄། ");
INSERT INTO santib_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ཀིནྟུ ཧཱ ཧཱ དྷནཝནྟོ ཡཱུཡཾ སུཁཾ པྲཱཔྣུཏ། ཧནྟ པརིཏྲྀཔྟཱ ཡཱུཡཾ ཀྵུདྷིཏཱ བྷཝིཥྱཐ; ");
INSERT INTO santib_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ཨིཧ ཧསནྟོ ཡཱུཡཾ ཝཏ ཡུཥྨཱབྷིཿ ཤོཙིཏཝྱཾ རོདིཏཝྱཉྩ། ");
INSERT INTO santib_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","སཪྻྭཻལཱཀཻ ཪྻུཥྨཱཀཾ སུཁྱཱཏཽ ཀྲྀཏཱཡཱཾ ཡུཥྨཱཀཾ དུརྒཏི རྦྷཝིཥྱཏི ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥཱ མྲྀཥཱབྷཝིཥྱདྭཱདིནཿ པྲཏི ཏདྭཏ྄ ཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ཧེ ཤྲོཏཱརོ ཡུཥྨབྷྱམཧཾ ཀཐཡཱམི, ཡཱུཡཾ ཤཏྲུཥུ པྲཱིཡདྷྭཾ ཡེ ཙ ཡུཥྨཱན྄ དྭིཥནྟི ཏེཥཱམཔི ཧིཏཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ཡེ ཙ ཡུཥྨཱན྄ ཤཔནྟི ཏེབྷྱ ཨཱཤིཥཾ དཏྟ ཡེ ཙ ཡུཥྨཱན྄ ཨཝམནྱནྟེ ཏེཥཱཾ མངྒལཾ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ཡདི ཀཤྩིཏ྄ ཏཝ ཀཔོལེ ཙཔེཊཱགྷཱཏཾ ཀརོཏི ཏརྷི ཏཾ པྲཏི ཀཔོལམ྄ ཨནྱཾ པརཱཝརྟྟྱ སམྨུཁཱིཀུརུ པུནཤྩ ཡདི ཀཤྩིཏ྄ ཏཝ གཱཏྲཱིཡཝསྟྲཾ ཧརཏི ཏརྷི ཏཾ པརིདྷེཡཝསྟྲམ྄ ཨཔི གྲཧཱིཏུཾ མཱ ཝཱརཡ། ");
INSERT INTO santib_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ཡསྟྭཱཾ ཡཱཙཏེ ཏསྨཻ དེཧི, ཡཤྩ ཏཝ སམྤཏྟིཾ ཧརཏི ཏཾ མཱ ཡཱཙསྭ། ");
INSERT INTO santib_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","པརེབྷྱཿ སྭཱན྄ པྲཏི ཡཐཱཙརཎམ྄ ཨཔེཀྵདྷྭེ པརཱན྄ པྲཏི ཡཱུཡམཔི ཏཐཱཙརཏ། ");
INSERT INTO santib_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ཡེ ཛནཱ ཡུཥྨཱསུ པྲཱིཡནྟེ ཀེཝལཾ ཏེཥུ པྲཱིཡམཱཎེཥུ ཡུཥྨཱཀཾ ཀིཾ ཕལཾ? པཱཔིལོཀཱ ཨཔི སྭེཥུ པྲཱིཡམཱཎེཥུ པྲཱིཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ཡདི ཧིཏཀཱརིཎ ཨེཝ ཧིཏཾ ཀུརུཐ ཏརྷི ཡུཥྨཱཀཾ ཀིཾ ཕལཾ? པཱཔིལོཀཱ ཨཔི ཏཐཱ ཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ཡེབྷྱ ཨྲྀཎཔརིཤོདྷསྱ པྲཱཔྟིཔྲཏྱཱཤཱསྟེ ཀེཝལཾ ཏེཥུ ཨྲྀཎེ སམརྤིཏེ ཡུཥྨཱཀཾ ཀིཾ ཕལཾ? པུནཿ པྲཱཔྟྱཱཤཡཱ པཱཔཱིལོཀཱ ཨཔི པཱཔིཛནེཥུ ཨྲྀཎམ྄ ཨརྤཡནྟི། ");
INSERT INTO santib_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ཨཏོ ཡཱུཡཾ རིཔུཥྭཔི པྲཱིཡདྷྭཾ, པརཧིཏཾ ཀུརུཏ ཙ; པུནཿ པྲཱཔྟྱཱཤཱཾ ཏྱཀྟྭཱ ཨྲྀཎམརྤཡཏ, ཏཐཱ ཀྲྀཏེ ཡུཥྨཱཀཾ མཧཱཕལཾ བྷཝིཥྱཏི, ཡཱུཡཉྩ སཪྻྭཔྲདྷཱནསྱ སནྟཱནཱ ཨིཏི ཁྱཱཏིཾ པྲཱཔྶྱཐ, ཡཏོ ཡུཥྨཱཀཾ པིཏཱ ཀྲྀཏགྷྣཱནཱཾ དུཪྻྚཏྟཱནཱཉྩ ཧིཏམཱཙརཏི། ");
INSERT INTO santib_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ཨཏ ཨེཝ ས ཡཐཱ དཡཱལུ ཪྻཱུཡམཔི ཏཱདྲྀཤཱ དཡཱལཝོ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ཨཔརཉྩ པརཱན྄ དོཥིཎོ མཱ ཀུརུཏ ཏསྨཱད྄ ཡཱུཡཾ དོཥཱིཀྲྀཏཱ ན བྷཝིཥྱཐ; ཨདཎྜྱཱན྄ མཱ དཎྜཡཏ ཏསྨཱད྄ ཡཱུཡམཔི དཎྜཾ ན པྲཱཔྶྱཐ; པརེཥཱཾ དོཥཱན྄ ཀྵམདྷྭཾ ཏསྨཱད྄ ཡུཥྨཱཀམཔི དོཥཱཿ ཀྵམིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","དཱནཱནིདཏྟ ཏསྨཱད྄ ཡཱུཡཾ དཱནཱནི པྲཱཔྶྱཐ, ཝརཉྩ ལོཀཱཿ པརིམཱཎཔཱཏྲཾ པྲདལཡྻ སཉྩཱལྱ པྲོཉྩཱལྱ པརིཔཱུཪྻྱ ཡུཥྨཱཀཾ ཀྲོཌེཥུ སམརྤཡིཥྱནྟི; ཡཱུཡཾ ཡེན པརིམཱཎེན པརིམཱཐ ཏེནཻཝ པརིམཱཎེན ཡུཥྨཏྐྲྀཏེ པརིམཱསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ཨཐ ས ཏེབྷྱོ དྲྀཥྚཱནྟཀཐཱམཀཐཡཏ྄, ཨནྡྷོ ཛནཿ ཀིམནྡྷཾ པནྠཱནཾ དརྴཡིཏུཾ ཤཀྣོཏི? ཏསྨཱད྄ ཨུབྷཱཝཔི ཀིཾ གརྟྟེ ན པཏིཥྱཏཿ? ");
INSERT INTO santib_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","གུརོཿ ཤིཥྱོ ན ཤྲེཥྛཿ ཀིནྟུ ཤིཥྱེ སིདྡྷེ སཏི ས གུརུཏུལྱོ བྷཝིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ཨཔརཉྩ ཏྭཾ སྭཙཀྵུुཥི ནཱསཱམ྄ ཨདྲྀཥྚྭཱ ཏཝ བྷྲཱཏུཤྩཀྵུཥི ཡཏྟྲྀཎམསྟི ཏདེཝ ཀུཏཿ པཤྱམི? ");
INSERT INTO santib_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","སྭཙཀྵུཥི ཡཱ ནཱསཱ ཝིདྱཏེ ཏཱམ྄ ཨཛྙཱཏྭཱ, བྷྲཱཏསྟཝ ནེཏྲཱཏ྄ ཏྲྀཎཾ བཧིཿ ཀརོམཱིཏི ཝཱཀྱཾ བྷྲཱཏརཾ ཀཐཾ ཝཀྟུཾ ཤཀྣོཥི? ཧེ ཀཔཊིན྄ པཱུཪྻྭཾ སྭནཡནཱཏ྄ ནཱསཱཾ བཧིཿ ཀུརུ ཏཏོ བྷྲཱཏུཤྩཀྵུཥསྟྲྀཎཾ བཧིཿ ཀརྟྟུཾ སུདྲྀཥྚིཾ པྲཱཔྶྱསི། ");
INSERT INTO santib_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ཨནྱཉྩ ཨུཏྟམསྟརུཿ ཀདཱཔི ཕལམནུཏྟམཾ ན ཕལཏི, ཨནུཏྟམཏརུཤྩ ཕལམུཏྟམཾ ན ཕལཏི ཀཱརཎཱདཏཿ ཕལཻསྟརཝོ ཛྙཱཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ཀཎྚཀིཔཱདཔཱཏ྄ ཀོཔི ཨུཌུམྦརཕལཱནི ན པཱཏཡཏི ཏཐཱ ཤྲྀགཱལཀོལིཝྲྀཀྵཱདཔི ཀོཔི དྲཱཀྵཱཕལཾ ན པཱཏཡཏི། ");
INSERT INTO santib_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ཏདྭཏ྄ སཱདྷུལོཀོ྅ནྟཿཀརཎརཱུཔཱཏ྄ སུབྷཱཎྜཱགཱརཱད྄ ཨུཏྟམཱནི དྲཝྱཱཎི བཧིཿ ཀརོཏི, དུཥྚོ ལོཀཤྩཱནྟཿཀརཎརཱུཔཱཏ྄ ཀུབྷཱཎྜཱགཱརཱཏ྄ ཀུཏྶིཏཱནི དྲཝྱཱཎི ནིརྒམཡཏི ཡཏོ྅ནྟཿཀརཎཱནཱཾ པཱུརྞབྷཱཝཱནུརཱུཔཱཎི ཝཙཱཾསི མུཁཱནྣིརྒཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ཨཔརཉྩ མམཱཛྙཱནུརཱུཔཾ ནཱཙརིཏྭཱ ཀུཏོ མཱཾ པྲབྷོ པྲབྷོ ཨིཏི ཝདཐ? ");
INSERT INTO santib_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ཡཿ ཀཤྩིན྄ མམ ནིཀཊམ྄ ཨཱགཏྱ མམ ཀཐཱ ནིཤམྱ ཏདནུརཱུཔཾ ཀརྨྨ ཀརོཏི ས ཀསྱ སདྲྀཤོ བྷཝཏི ཏདཧཾ ཡུཥྨཱན྄ ཛྙཱाཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ཡོ ཛནོ གབྷཱིརཾ ཁནིཏྭཱ པཱཥཱཎསྠལེ བྷིཏྟིཾ ནིརྨྨཱཡ སྭགྲྀཧཾ རཙཡཏི ཏེན སཧ ཏསྱོཔམཱ བྷཝཏི; ཡཏ ཨཱཔླཱཝིཛལམེཏྱ ཏསྱ མཱུལེ ཝེགེན ཝཧདཔི ཏདྒེཧཾ ལཱཌཡིཏུཾ ན ཤཀྣོཏི ཡཏསྟསྱ བྷིཏྟིཿ པཱཥཱཎོཔརི ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ཀིནྟུ ཡཿ ཀཤྩིན྄ མམ ཀཐཱཿ ཤྲུཏྭཱ ཏདནུརཱུཔཾ ནཱཙརཏི ས བྷིཏྟིཾ ཝིནཱ མྲྀृདུཔརི གྲྀཧནིརྨྨཱཏྲཱ སམཱནོ བྷཝཏི; ཡཏ ཨཱཔླཱཝིཛལམཱགཏྱ ཝེགེན ཡདཱ ཝཧཏི ཏདཱ ཏདྒྲྀཧཾ པཏཏི ཏསྱ མཧཏ྄ པཏནཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ཏཏཿ པརཾ ས ལོཀཱནཱཾ ཀརྞགོཙརེ ཏཱན྄ སཪྻྭཱན྄ ཨུཔདེཤཱན྄ སམཱཔྱ ཡདཱ ཀཕརྣཱཧཱུམྤུརཾ པྲཝིཤཏི ");
INSERT INTO santib_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ཏདཱ ཤཏསེནཱཔཏེཿ པྲིཡདཱས ཨེཀོ མྲྀཏཀལྤཿ པཱིཌིཏ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ཨཏཿ སེནཱཔཏི ཪྻཱིཤོ ཪྻཱརྟྟཱཾ ནིཤམྱ དཱསསྱཱརོགྱཀརཎཱཡ ཏསྱཱགམནཱརྠཾ ཝིནཡཀརཎཱཡ ཡིཧཱུདཱིཡཱན྄ ཀིཡཏཿ པྲཱཙཿ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ཏེ ཡཱིཤོརནྟིཀཾ གཏྭཱ ཝིནཡཱཏིཤཡཾ ཝཀྟུམཱརེབྷིརེ, ས སེནཱཔཏི རྦྷཝཏོནུགྲཧཾ པྲཱཔྟུམ྄ ཨརྷཏི། ");
INSERT INTO santib_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ཡཏཿ སོསྨཛྫཱཏཱིཡེཥུ ལོཀེཥུ པྲཱིཡཏེ ཏཐཱསྨཏྐྲྀཏེ བྷཛནགེཧཾ ནིརྨྨིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ཏསྨཱད྄ ཡཱིཤུསྟཻཿ སཧ གཏྭཱ ནིཝེཤནསྱ སམཱིཔཾ པྲཱཔ, ཏདཱ ས ཤཏསེནཱཔཏི ཪྻཀྵྱམཱཎཝཱཀྱཾ ཏཾ ཝཀྟུཾ བནྡྷཱུན྄ པྲཱཧིཎོཏ྄། ཧེ པྲབྷོ སྭཡཾ ཤྲམོ ན ཀརྟྟཝྱོ ཡད྄ བྷཝཏཱ མདྒེཧམདྷྱེ པཱདཱརྤཎཾ ཀྲིཡེཏ ཏདཔྱཧཾ ནཱརྷཱམི, ");
INSERT INTO santib_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ཀིཉྩཱཧཾ བྷཝཏྶམཱིཔཾ ཡཱཏུམཔི ནཱཏྨཱནཾ ཡོགྱཾ བུདྡྷཝཱན྄, ཏཏོ བྷཝཱན྄ ཝཱཀྱམཱཏྲཾ ཝདཏུ ཏེནཻཝ མམ དཱསཿ སྭསྠོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ཡསྨཱད྄ ཨཧཾ པརཱདྷཱིནོཔི མམཱདྷཱིནཱ ཡཱཿ སེནཱཿ སནྟི ཏཱསཱམ྄ ཨེཀཛནཾ པྲཏི ཡཱཧཱིཏི མཡཱ པྲོཀྟེ ས ཡཱཏི; ཏདནྱཾ པྲཏི ཨཱཡཱཧཱིཏི པྲོཀྟེ ས ཨཱཡཱཏི; ཏཐཱ ནིཛདཱསཾ པྲཏི ཨེཏཏ྄ ཀུཪྻྭིཏི པྲོཀྟེ ས ཏདེཝ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ཡཱིཤུརིདཾ ཝཱཀྱཾ ཤྲུཏྭཱ ཝིསྨཡཾ ཡཡཽ, མུཁཾ པརཱཝརྟྱ པཤྩཱདྭརྟྟིནོ ལོཀཱན྄ བབྷཱཥེ ཙ, ཡུཥྨཱནཧཾ ཝདཱམི ཨིསྲཱཡེལོ ཝཾཤམདྷྱེཔི ཝིཤྭཱསམཱིདྲྀཤཾ ན པྲཱཔྣཝཾ། ");
INSERT INTO santib_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ཏཏསྟེ པྲེཥིཏཱ གྲྀཧཾ གཏྭཱ ཏཾ པཱིཌིཏཾ དཱསཾ སྭསྠཾ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","པརེ྅ཧནི ས ནཱཡཱིནཱཁྱཾ ནགརཾ ཛགཱམ ཏསྱཱནེཀེ ཤིཥྱཱ ཨནྱེ ཙ ལོཀཱསྟེན སཱརྡྡྷཾ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ཏེཥུ ཏནྣགརསྱ དྭཱརསནྣིདྷིཾ པྲཱཔྟེཥུ ཀིཡནྟོ ལོཀཱ ཨེཀཾ མྲྀཏམནུཛཾ ཝཧནྟོ ནགརསྱ བཧིཪྻཱནྟི, ས ཏནྨཱཏུརེཀཔུཏྲསྟནྨཱཏཱ ཙ ཝིདྷཝཱ; ཏཡཱ སཱརྡྡྷཾ ཏནྣགརཱིཡཱ བཧཝོ ལོཀཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","པྲབྷུསྟཱཾ ཝིལོཀྱ སཱནུཀམྤཿ ཀཐཡཱམཱས, མཱ རོདཱིཿ། ས སམཱིཔམིཏྭཱ ཁཊྭཱཾ པསྤརྴ ཏསྨཱད྄ ཝཱཧཀཱཿ སྠགིཏཱསྟམྱུཿ; ");
INSERT INTO santib_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ཏདཱ ས ཨུཝཱཙ ཧེ ཡུཝམནུཥྱ ཏྭམུཏྟིཥྛ, ཏྭཱམཧམ྄ ཨཱཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ཏསྨཱཏ྄ ས མྲྀཏོ ཛནསྟཏྐྵཎམུཏྠཱཡ ཀཐཱཾ པྲཀཐིཏཿ; ཏཏོ ཡཱིཤུསྟསྱ མཱཏརི ཏཾ སམརྤཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ཏསྨཱཏ྄ སཪྻྭེ ལོཀཱཿ ཤཤངྐིརེ; ཨེཀོ མཧཱབྷཝིཥྱདྭཱདཱི མདྷྱེ྅སྨཱཀམ྄ སམུདཻཏ྄, ཨཱིཤྭརཤྩ སྭལོཀཱནནྭགྲྀཧླཱཏ྄ ཀཐཱམིམཱཾ ཀཐཡིཏྭཱ ཨཱིཤྭརཾ དྷནྱཾ ཛགདུཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ཏཏཿ པརཾ སམསྟཾ ཡིཧཱུདཱདེཤཾ ཏསྱ ཙཏུརྡིཀྶྠདེཤཉྩ ཏསྱཻཏཏྐཱིརྟྟི ཪྻྱཱནཤེ། ");
INSERT INTO santib_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ཏཏཿ པརཾ ཡོཧནཿ ཤིཥྱེཥུ ཏཾ ཏདྭྲྀཏྟཱནྟཾ ཛྙཱཔིཏཝཏྶུ ");
INSERT INTO santib_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ས སྭཤིཥྱཱཎཱཾ དྭཽ ཛནཱཝཱཧཱུཡ ཡཱིཤུཾ པྲཏི ཝཀྵྱམཱཎཾ ཝཱཀྱཾ ཝཀྟུཾ པྲེཥཡཱམཱས, ཡསྱཱགམནམ྄ ཨཔེཀྵྱ ཏིཥྛཱམོ ཝཡཾ ཀིཾ ས ཨེཝ ཛནསྟྭཾ? ཀིཾ ཝཡམནྱམཔེཀྵྱ སྠཱསྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","པཤྩཱཏྟཽ མཱནཝཽ གཏྭཱ ཀཐཡཱམཱསཏུཿ, ཡསྱཱགམནམ྄ ཨཔེཀྵྱ ཏིཥྛཱམོ ཝཡཾ, ཀིཾ སཨེཝ ཛནསྟྭཾ? ཀིཾ ཝཡམནྱམཔེཀྵྱ སྠཱསྱཱམཿ? ཀཐཱམིམཱཾ ཏུབྷྱཾ ཀཐཡིཏུཾ ཡོཧན྄ མཛྫཀ ཨཱཝཱཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ཏསྨིན྄ དཎྜེ ཡཱིཤཱུརོགིཎོ མཧཱཝྱཱདྷིམཏོ དུཥྚབྷཱུཏགྲསྟཱཾཤྩ བཧཱུན྄ སྭསྠཱན྄ ཀྲྀཏྭཱ, ཨནེཀཱནྡྷེབྷྱཤྩཀྵུཾཥི དཏྟྭཱ པྲཏྱུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ཡུཝཱཾ ཝྲཛཏམ྄ ཨནྡྷཱ ནེཏྲཱཎི ཁཉྫཱཤྩརཎཱནི ཙ པྲཱཔྣུཝནྟི, ཀུཥྛིནཿ པརིཥྐྲིཡནྟེ, བདྷིརཱཿ ཤྲཝཎཱནི མྲྀཏཱཤྩ ཛཱིཝནཱནི པྲཱཔྣུཝནྟི, དརིདྲཱཎཱཾ སམཱིཔེཥུ སུསཾཝཱདཿ པྲཙཱཪྻྱཏེ, ཡཾ པྲཏི ཝིགྷྣསྭརཱུཔོཧཾ ན བྷཝཱམི ས དྷནྱཿ, ");
INSERT INTO santib_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ཨེཏཱནི ཡཱནི པཤྱཐཿ ཤྲྀཎུཐཤྩ ཏཱནི ཡོཧནཾ ཛྙཱཔཡཏམ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ཏཡོ རྡཱུཏཡོ རྒཏཡོཿ སཏོ ཪྻོཧནི ས ལོཀཱན྄ ཝཀྟུམུཔཙཀྲམེ, ཡཱུཡཾ མདྷྱེཔྲཱནྟརཾ ཀིཾ དྲཥྚུཾ ནིརགམཏ? ཀིཾ ཝཱཡུནཱ ཀམྤིཏཾ ནཌཾ? ");
INSERT INTO santib_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ཡཱུཡཾ ཀིཾ དྲཥྚུཾ ནིརགམཏ? ཀིཾ སཱུཀྵྨཝསྟྲཔརིདྷཱཡིནཾ ཀམཔི ནརཾ? ཀིནྟུ ཡེ སཱུཀྵྨམྲྀདུཝསྟྲཱཎི པརིདདྷཏི སཱུཏྟམཱནི དྲཝྱཱཎི བྷུཉྫཏེ ཙ ཏེ རཱཛདྷཱནཱིཥུ ཏིཥྛནྟི། ");
INSERT INTO santib_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ཏརྷི ཡཱུཡཾ ཀིཾ དྲཥྚུཾ ནིརགམཏ? ཀིམེཀཾ བྷཝིཥྱདྭཱདིནཾ? ཏདེཝ སཏྱཾ ཀིནྟུ ས པུམཱན྄ བྷཝིཥྱདྭཱདིནོཔི ཤྲེཥྛ ཨིཏྱཧཾ ཡུཥྨཱན྄ ཝདཱམི; ");
INSERT INTO santib_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","པཤྱ སྭཀཱིཡདཱུཏནྟུ ཏཝཱགྲ པྲེཥཡཱམྱཧཾ། གཏྭཱ ཏྭདཱིཡམཱརྒནྟུ ས ཧི པརིཥྐརིཥྱཏི། ཡདརྠེ ལིཔིརིཡམ྄ ཨཱསྟེ ས ཨེཝ ཡོཧན྄། ");
INSERT INTO santib_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ཨཏོ ཡུཥྨཱནཧཾ ཝདཱམི སྟྲིཡཱ གརྦྦྷཛཱཏཱནཱཾ བྷཝིཥྱདྭཱདིནཱཾ མདྷྱེ ཡོཧནོ མཛྫཀཱཏ྄ ཤྲེཥྛཿ ཀོཔི ནཱསྟི, ཏཏྲཱཔི ཨཱིཤྭརསྱ རཱཛྱེ ཡཿ སཪྻྭསྨཱཏ྄ ཀྵུདྲཿ ས ཡོཧནོཔི ཤྲེཥྛཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ཨཔརཉྩ སཪྻྭེ ལོཀཱཿ ཀརམཉྩཱཡིནཤྩ ཏསྱ ཝཱཀྱཱནི ཤྲུཏྭཱ ཡོཧནཱ མཛྫནེན མཛྫིཏཱཿ པརམེཤྭརཾ ནིརྡོཥཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ཀིནྟུ ཕིརཱུཤིནོ ཝྱཝསྠཱཔཀཱཤྩ ཏེན ན མཛྫིཏཱཿ སྭཱན྄ པྲཏཱིཤྭརསྱོཔདེཤཾ ནིཥྥལམ྄ ཨཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ཨཐ པྲབྷུཿ ཀཐཡཱམཱས, ཨིདཱནཱིནྟནཛནཱན྄ ཀེནོཔམཱམི? ཏེ ཀསྱ སདྲྀཤཱཿ? ");
INSERT INTO santib_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ཡེ བཱལཀཱ ཝིཔཎྱཱམ྄ ཨུཔཝིཤྱ པརསྤརམ྄ ཨཱཧཱུཡ ཝཱཀྱམིདཾ ཝདནྟི, ཝཡཾ ཡུཥྨཱཀཾ ནིཀཊེ ཝཾཤཱིརཝཱདིཥྨ, ཀིནྟུ ཡཱུཡཾ ནཱནརྟྟིཥྚ, ཝཡཾ ཡུཥྨཱཀཾ ནིཀཊ ཨརོདིཥྨ, ཀིནྟུ ཡུཡཾ ན ཝྱལཔིཥྚ, བཱལཀཻརེཏཱདྲྀཤཻསྟེཥཱམ྄ ཨུཔམཱ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ཡཏོ ཡོཧན྄ མཛྫཀ ཨཱགཏྱ པཱུཔཾ ནཱཁཱདཏ྄ དྲཱཀྵཱརསཉྩ ནཱཔིཝཏ྄ ཏསྨཱད྄ ཡཱུཡཾ ཝདཐ, བྷཱུཏགྲསྟོཡམ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ཏཏཿ པརཾ མཱནཝསུཏ ཨཱགཏྱཱཁཱདདཔིཝཉྩ ཏསྨཱད྄ ཡཱུཡཾ ཝདཐ, ཁཱདཀཿ སུརཱཔཤྩཱཎྜཱལཔཱཔིནཱཾ བནྡྷུརེཀོ ཛནོ དྲྀཤྱཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ཀིནྟུ ཛྙཱནིནོ ཛྙཱནཾ ནིརྡོཥཾ ཝིདུཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","པཤྩཱདེཀཿ ཕིརཱུཤཱི ཡཱིཤུཾ བྷོཛནཱཡ ནྱམནྟྲཡཏ྄ ཏཏཿ ས ཏསྱ གྲྀཧཾ གཏྭཱ བྷོཀྟུམུཔཝིཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ཨེཏརྷི ཏཏྥིརཱུཤིནོ གྲྀཧེ ཡཱིཤུ རྦྷེཀྟུམ྄ ཨུཔཱཝེཀྵཱིཏ྄ ཏཙྪྲུཏྭཱ ཏནྣགརཝཱསིནཱི ཀཱཔི དུཥྚཱ ནཱརཱི པཱཎྜརཔྲསྟརསྱ སམྤུཊཀེ སུགནྡྷིཏཻལམ྄ ཨཱནཱིཡ ");
INSERT INTO santib_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ཏསྱ པཤྩཱཏ྄ པཱདཡོཿ སནྣིདྷཽ ཏསྱཽ རུདཏཱི ཙ ནེཏྲཱམྦུབྷིསྟསྱ ཙརཎཽ པྲཀྵཱལྱ ནིཛཀཙཻརམཱརྐྵཱིཏ྄, ཏཏསྟསྱ ཙརཎཽ ཙུམྦིཏྭཱ ཏེན སུགནྡྷིཏཻལེན མམརྡ། ");
INSERT INTO santib_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ཏསྨཱཏ྄ ས ནིམནྟྲཡིཏཱ ཕིརཱུཤཱི མནསཱ ཙིནྟཡཱམཱས, ཡདྱཡཾ བྷཝིཥྱདྭཱདཱི བྷཝེཏ྄ ཏརྷི ཨེནཾ སྤྲྀཤཏི ཡཱ སྟྲཱི སཱ ཀཱ ཀཱིདྲྀཤཱི ཙེཏི ཛྙཱཏུཾ ཤཀྣུཡཱཏ྄ ཡཏཿ སཱ དུཥྚཱ། ");
INSERT INTO santib_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ཏདཱ ཡཱཤུསྟཾ ཛགཱད, ཧེ ཤིམོན྄ ཏྭཱཾ པྲཏི མམ ཀིཉྩིད྄ ཝཀྟཝྱམསྟི; ཏསྨཱཏ྄ ས བབྷཱཥེ, ཧེ གུརོ ཏད྄ ཝདཏུ། ");
INSERT INTO santib_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ཨེཀོཏྟམརྞསྱ དྭཱཝདྷམརྞཱཝཱསྟཱཾ, ཏཡོརེཀཿ པཉྩཤཏཱནི མུདྲཱཔཱདཱན྄ ཨཔརཤྩ པཉྩཱཤཏ྄ མུདྲཱཔཱདཱན྄ དྷཱརཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ཏདནནྟརཾ ཏཡོཿ ཤོདྷྱཱབྷཱཝཱཏ྄ ས ཨུཏྟམརྞསྟཡོ རྲྀཎེ ཙཀྵམེ; ཏསྨཱཏ྄ ཏཡོརྡྭཡོཿ ཀསྟསྨིན྄ པྲེཥྱཏེ བཧུ? ཏད྄ བྲཱུཧི། ");
INSERT INTO santib_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ཤིམོན྄ པྲཏྱུཝཱཙ, མཡཱ བུདྷྱཏེ ཡསྱཱདྷིཀམ྄ ཨྲྀཎཾ ཙཀྵམེ ས ཨིཏི; ཏཏོ ཡཱིཤུསྟཾ ཝྱཱཛཧཱར, ཏྭཾ ཡཐཱརྠཾ ཝྱཙཱརཡཿ། ");
INSERT INTO santib_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ཨཐ ཏཱཾ ནཱརཱིཾ པྲཏི ཝྱཱགྷུཋྱ ཤིམོནམཝོཙཏ྄, སྟྲཱིམིམཱཾ པཤྱསི? ཏཝ གྲྀཧེ མཡྻཱགཏེ ཏྭཾ པཱདཔྲཀྵཱལནཱརྠཾ ཛལཾ ནཱདཱཿ ཀིནྟུ ཡོཥིདེཥཱ ནཡནཛལཻ རྨམ པཱདཽ པྲཀྵཱལྱ ཀེཤཻརམཱརྐྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ཏྭཾ མཱཾ ནཱཙུམྦཱིཿ ཀིནྟུ ཡོཥིདེཥཱ སྭཱིཡཱགམནཱདཱརབྷྱ མདཱིཡཔཱདཽ ཙུམྦིཏུཾ ན ཝྱརཾསྟ། ");
INSERT INTO santib_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ཏྭཉྩ མདཱིཡོཏྟམཱངྒེ ཀིཉྩིདཔི ཏཻལཾ ནཱམརྡཱིཿ ཀིནྟུ ཡོཥིདེཥཱ མམ ཙརཎཽ སུགནྡྷིཏཻལེནཱམརྡྡཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ཨཏསྟྭཱཾ ཝྱཱཧརཱམི, ཨེཏསྱཱ བཧུ པཱཔམཀྵམྱཏ ཏཏོ བཧུ པྲཱིཡཏེ ཀིནྟུ ཡསྱཱལྤཔཱཔཾ ཀྵམྱཏེ སོལྤཾ པྲཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ཏཏཿ པརཾ ས ཏཱཾ བབྷཱཥེ, ཏྭདཱིཡཾ པཱཔམཀྵམྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ཏདཱ ཏེན སཱརྡྡྷཾ ཡེ བྷོཀྟུམ྄ ཨུཔཝིཝིཤུསྟེ པརསྤརཾ ཝཀྟུམཱརེབྷིརེ, ཨཡཾ པཱཔཾ ཀྵམཏེ ཀ ཨེཥཿ? ");
INSERT INTO santib_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ཀིནྟུ ས ཏཱཾ ནཱརཱིཾ ཛགཱད, ཏཝ ཝིཤྭཱསསྟྭཱཾ པཪྻྱཏྲཱསྟ ཏྭཾ ཀྵེམེཎ ཝྲཛ། ");
INSERT INTO santib_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ཨཔརཉྩ ཡཱིཤུ རྡྭཱདཤབྷིཿ ཤིཥྱཻཿ སཱརྡྡྷཾ ནཱནཱནགརེཥུ ནཱནཱགྲཱམེཥུ ཙ གཙྪན྄ ཨིཤྭརཱིཡརཱཛཏྭསྱ སུསཾཝཱདཾ པྲཙཱརཡིཏུཾ པྲཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ཏདཱ ཡསྱཱཿ སཔྟ བྷཱུཏཱ ནིརགཙྪན྄ སཱ མགྡལཱིནཱིཏི ཝིཁྱཱཏཱ མརིཡམ྄ ཧེརོདྲཱཛསྱ གྲྀཧཱདྷིཔཏེཿ ཧོཥེ རྦྷཱཪྻྱཱ ཡོཧནཱ ཤཱུཤཱནཱ ");
INSERT INTO santib_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","པྲབྷྲྀཏཡོ ཡཱ བཧྭྱཿ སྟྲིཡཿ དུཥྚབྷཱུཏེབྷྱོ རོགེབྷྱཤྩ མུཀྟཱཿ སཏྱོ ནིཛཝིབྷཱུཏཱི ཪྻྱཡིཏྭཱ ཏམསེཝནྟ, ཏཱཿ སཪྻྭཱསྟེན སཱརྡྡྷམ྄ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ཨནནྟརཾ ནཱནཱནགརེབྷྱོ བཧཝོ ལོཀཱ ཨཱགཏྱ ཏསྱ སམཱིཔེ྅མིལན྄, ཏདཱ ས ཏེབྷྱ ཨེཀཱཾ དྲྀཥྚཱནྟཀཐཱཾ ཀཐཡཱམཱས། ཨེཀཿ ཀྲྀཥཱིབལོ བཱིཛཱནི ཝཔྟུཾ བཧིརྫགཱམ, ");
INSERT INTO santib_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ཏཏོ ཝཔནཀཱལེ ཀཏིཔཡཱནི བཱིཛཱནི མཱརྒཔཱརྴྭེ པེཏུཿ, ཏཏསྟཱནི པདཏལཻ རྡལིཏཱནི པཀྵིབྷི རྦྷཀྵིཏཱནི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ཀཏིཔཡཱནི བཱིཛཱནི པཱཥཱཎསྠལེ པཏིཏཱནི ཡདྱཔི ཏཱནྱངྐུརིཏཱནི ཏཐཱཔི རསཱབྷཱཝཱཏ྄ ཤུཤུཥུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ཀཏིཔཡཱནི བཱིཛཱནི ཀཎྚཀིཝནམདྷྱེ པཏིཏཱནི ཏཏཿ ཀཎྚཀིཝནཱནི སཾཝྲྀདྡྷྱ ཏཱནི ཛགྲསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ཏདནྱཱནི ཀཏིཔཡབཱིཛཱནི ཙ བྷཱུམྱཱམུཏྟམཱཡཱཾ པེཏུསྟཏསྟཱནྱངྐུརཡིཏྭཱ ཤཏགུཎཱནི ཕལཱནི ཕེལུཿ། ས ཨིམཱ ཀཐཱཾ ཀཐཡིཏྭཱ པྲོཙྩཻཿ པྲོཝཱཙ, ཡསྱ ཤྲོཏུཾ ཤྲོཏྲེ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ཏཏཿ པརཾ ཤིཥྱཱསྟཾ པཔྲཙྪུརསྱ དྲྀཥྚཱནྟསྱ ཀིཾ ཏཱཏྤཪྻྱཾ? ");
INSERT INTO santib_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ཏཏཿ ས ཝྱཱཛཧཱར, ཨཱིཤྭརཱིཡརཱཛྱསྱ གུཧྱཱནི ཛྙཱཏུཾ ཡུཥྨབྷྱམདྷིཀཱརོ དཱིཡཏེ ཀིནྟྭནྱེ ཡཐཱ དྲྀཥྚྭཱཔི ན པཤྱནྟི ཤྲུཏྭཱཔི མ བུདྷྱནྟེ ཙ ཏདརྠཾ ཏེཥཱཾ པུརསྟཱཏ྄ ཏཱཿ སཪྻྭཱཿ ཀཐཱ དྲྀཥྚཱནྟེན ཀཐྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","དྲྀཥྚཱནྟསྱཱསྱཱབྷིཔྲཱཡཿ, ཨཱིཤྭརཱིཡཀཐཱ བཱིཛསྭརཱུཔཱ། ");
INSERT INTO santib_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ཡེ ཀཐཱམཱཏྲཾ ཤྲྀཎྭནྟི ཀིནྟུ པཤྩཱད྄ ཝིཤྭསྱ ཡཐཱ པརིཏྲཱཎཾ ན པྲཱཔྣུཝནྟི ཏདཱཤཡེན ཤཻཏཱནེཏྱ ཧྲྀདཡཱཏྲྀ ཏཱཾ ཀཐཱམ྄ ཨཔཧརཏི ཏ ཨེཝ མཱརྒཔཱརྴྭསྠབྷཱུམིསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ཡེ ཀཐཾ ཤྲུཏྭཱ སཱནནྡཾ གྲྀཧླནྟི ཀིནྟྭབདྡྷམཱུལཏྭཱཏ྄ སྭལྤཀཱལམཱཏྲཾ པྲཏཱིཏྱ པརཱིཀྵཱཀཱལེ བྷྲཤྱནྟི ཏཨེཝ པཱཥཱཎབྷཱུམིསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ཡེ ཀཐཱཾ ཤྲུཏྭཱ ཡཱནྟི ཝིཥཡཙིནྟཱཡཱཾ དྷནལོབྷེན ཨེेཧིཀསུཁེ ཙ མཛྫནྟ ཨུཔཡུཀྟཕལཱནི ན ཕལནྟི ཏ ཨེཝོཔྟབཱིཛཀཎྚཀིབྷཱུསྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ཀིནྟུ ཡེ ཤྲུཏྭཱ སརལཻཿ ཤུདྡྷཻཤྩཱནྟཿཀརཎཻཿ ཀཐཱཾ གྲྀཧླནྟི དྷཻཪྻྱམ྄ ཨཝལམྦྱ ཕལཱནྱུཏྤཱདཡནྟི ཙ ཏ ཨེཝོཏྟམམྲྀཏྶྭརཱུཔཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ཨཔརཉྩ པྲདཱིཔཾ པྲཛྭཱལྱ ཀོཔི པཱཏྲེཎ ནཱཙྪཱདཡཏི ཏཐཱ ཁཊྭཱདྷོཔི ན སྠཱཔཡཏི, ཀིནྟུ དཱིཔཱདྷཱརོཔཪྻྱེཝ སྠཱཔཡཏི, ཏསྨཱཏ྄ པྲཝེཤཀཱ དཱིཔྟིཾ པཤྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ཡནྣ པྲཀཱཤཡིཥྱཏེ ཏཱདྲྀག྄ ཨཔྲཀཱཤིཏཾ ཝསྟུ ཀིམཔི ནཱསྟི ཡཙྩ ན སུཝྱཀྟཾ པྲཙཱརཡིཥྱཏེ ཏཱདྲྀག྄ གྲྀཔྟཾ ཝསྟུ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ཨཏོ ཡཱུཡཾ ཀེན པྲཀཱརེཎ ཤྲྀཎུཐ ཏཏྲ སཱཝདྷཱནཱ བྷཝཏ, ཡསྱ སམཱིཔེ བརྡྡྷཏེ ཏསྨཻ པུནརྡཱསྱཏེ ཀིནྟུ ཡསྱཱཤྲཡེ ན བརྡྡྷཏེ ཏསྱ ཡདྱདསྟི ཏདཔི ཏསྨཱཏ྄ ནེཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ཨཔརཉྩ ཡཱིཤོ རྨཱཏཱ བྷྲཱཏརཤྩ ཏསྱ སམཱིཔཾ ཛིགམིཥཝཿ ");
INSERT INTO santib_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ཀིནྟུ ཛནཏཱསམྦཱདྷཱཏ྄ ཏཏྶནྣིདྷིཾ པྲཱཔྟུཾ ན ཤེཀུཿ། ཏཏྤཤྩཱཏ྄ ཏཝ མཱཏཱ བྷྲཱཏརཤྩ ཏྭཱཾ སཱཀྵཱཏ྄ ཙིཀཱིརྵནྟོ བཧིསྟིཥྛནཏཱིཏི ཝཱརྟྟཱཡཱཾ ཏསྨཻ ཀཐིཏཱཡཱཾ ");
INSERT INTO santib_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ས པྲཏྱུཝཱཙ; ཡེ ཛནཱ ཨཱིཤྭརསྱ ཀཐཱཾ ཤྲུཏྭཱ ཏདནུརཱུཔམཱཙརནྟི ཏཨེཝ མམ མཱཏཱ བྷྲཱཏརཤྩ། ");
INSERT INTO santib_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ཨནནྟརཾ ཨེཀདཱ ཡཱིཤུཿ ཤིཥྱཻཿ སཱརྡྡྷཾ ནཱཝམཱརུཧྱ ཛགཱད, ཨཱཡཱཏ ཝཡཾ ཧྲདསྱ པཱརཾ ཡཱམཿ, ཏཏསྟེ ཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ཏེཥུ ནཽཀཱཾ ཝཱཧཡཏྶུ ས ནིདདྲཽ; ");
INSERT INTO santib_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ཨཐཱཀསྨཱཏ྄ པྲབལཛྷཉྦྷྴགམཱད྄ ཧྲདེ ནཽཀཱཡཱཾ ཏརངྒཻརཱཙྪནྣཱཡཱཾ ཝིཔཏ྄ ཏཱན྄ ཛགྲཱས། ཏསྨཱད྄ ཡཱིཤོརནྟིཀཾ གཏྭཱ ཧེ གུརོ ཧེ གུརོ པྲཱཎཱ ནོ ཡཱནྟཱིཏི གདིཏྭཱ ཏཾ ཛཱགརཡཱམྦབྷཱུཝུཿ། ཏདཱ ས ཨུཏྠཱཡ ཝཱཡུཾ ཏརངྒཱཾཤྩ ཏརྫཡཱམཱས ཏསྨཱདུབྷཽ ནིཝྲྀཏྱ སྠིརཽ བབྷཱུཝཏུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ས ཏཱན྄ བབྷཱཥེ ཡུཥྨཱཀཾ ཝིཤྭཱསཿ ཀ? ཏསྨཱཏྟེ བྷཱིཏཱ ཝིསྨིཏཱཤྩ པརསྤརཾ ཛགདུཿ, ཨཧོ ཀཱིདྲྀགཡཾ མནུཛཿ པཝནཾ པཱནཱིཡཉྩཱདིཤཏི ཏདུབྷཡཾ ཏདཱདེཤཾ ཝཧཏི། ");
INSERT INTO santib_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ཏཏཿ པརཾ གཱལཱིལྤྲདེཤསྱ སམྨུཁསྠགིདེརཱིཡཔྲདེཤེ ནཽཀཱཡཱཾ ལགནྟྱཱཾ ཏཊེ྅ཝརོཧམཱཝཱད྄ ");
INSERT INTO santib_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","བཧུཏིཐཀཱལཾ བྷཱུཏགྲསྟ ཨེཀོ མཱནུཥཿ པུརཱདཱགཏྱ ཏཾ སཱཀྵཱཙྩཀཱར། ས མནུཥོ ཝཱསོ ན པརིདདྷཏ྄ གྲྀཧེ ཙ ན ཝསན྄ ཀེཝལཾ ཤྨཤཱནམ྄ ཨདྷྱུཝཱས། ");
INSERT INTO santib_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ས ཡཱིཤུཾ དྲྀཥྚྭཻཝ ཙཱིཙྪབྡཾ ཙཀཱར ཏསྱ སམྨུཁེ པཏིཏྭཱ པྲོཙྩཻརྫགཱད ཙ, ཧེ སཪྻྭཔྲདྷཱནེཤྭརསྱ པུཏྲ, མཡཱ སཧ ཏཝ ཀཿ སམྦནྡྷཿ? ཏྭཡི ཝིནཡཾ ཀརོམི མཱཾ མཱ ཡཱཏཡ། ");
INSERT INTO santib_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ཡཏཿ ས ཏཾ མཱནུཥཾ ཏྱཀྟྭཱ ཡཱཏུམ྄ ཨམེདྷྱབྷཱུཏམ྄ ཨཱདིདེཤ; ས བྷཱུཏསྟཾ མཱནུཥམ྄ ཨསཀྲྀད྄ དདྷཱར ཏསྨཱལློཀཱཿ ཤྲྀངྑལེན ནིགཌེན ཙ བབནྡྷུཿ; ས ཏད྄ བྷཾཀྟྭཱ བྷཱུཏཝཤཏྭཱཏ྄ མདྷྱེཔྲཱནྟརཾ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ཨནནྟརཾ ཡཱིཤུསྟཾ པཔྲཙྪ ཏཝ ཀིནྣཱམ? ས ཨུཝཱཙ, མམ ནཱམ བཱཧིནོ ཡཏོ བཧཝོ བྷཱུཏཱསྟམཱཤིཤྲིཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ཨཐ བྷཱུཏཱ ཝིནཡེན ཛགདུཿ, གབྷཱིརཾ གརྟྟཾ གནྟུཾ མཱཛྙཱཔཡཱསྨཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ཏདཱ པཪྻྭཏོཔརི ཝརཱཧཝྲཛཤྩརཏི ཏསྨཱད྄ བྷཱུཏཱ ཝིནཡེན པྲོཙུཿ, ཨམུཾ ཝརཱཧཝྲཛམ྄ ཨཱཤྲཡིཏུམ྄ ཨསྨཱན྄ ཨནུཛཱནཱིཧི; ཏཏཿ སོནུཛཛྙཽ། ");
INSERT INTO santib_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ཏཏཿ པརཾ བྷཱུཏཱསྟཾ མཱནུཥཾ ཝིཧཱཡ ཝརཱཧཝྲཛམ྄ ཨཱཤིཤྲིཡུཿ ཝརཱཧཝྲཛཱཤྩ ཏཏྐྵཎཱཏ྄ ཀཊཀེན དྷཱཝནྟོ ཧྲདེ པྲཱཎཱན྄ ཝིཛྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ཏད྄ དྲྀཥྚྭཱ ཤཱུཀརརཀྵཀཱཿ པལཱཡམཱནཱ ནགརཾ གྲཱམཉྩ གཏྭཱ ཏཏྶཪྻྭཝྲྀཏྟཱནྟཾ ཀཐཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ཏཏཿ ཀིཾ ཝྲྀཏྟམ྄ ཨེཏདྡརྴནཱརྠཾ ལོཀཱ ནིརྒཏྱ ཡཱིཤོཿ སམཱིཔཾ ཡཡུཿ, ཏཾ མཱནུཥཾ ཏྱཀྟབྷཱུཏཾ པརིཧིཏཝསྟྲཾ སྭསྠམཱནུཥཝད྄ ཡཱིཤོཤྩརཎསནྣིདྷཽ སཱུཔཝིཤནྟཾ ཝིལོཀྱ བིབྷྱུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ཡེ ལོཀཱསྟསྱ བྷཱུཏགྲསྟསྱ སྭཱསྠྱཀརཎཾ དདྲྀཤུསྟེ ཏེབྷྱཿ སཪྻྭཝྲྀཏྟཱནྟཾ ཀཐཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ཏདནནྟརཾ ཏསྱ གིདེརཱིཡཔྲདེཤསྱ ཙཏུརྡིཀྶྠཱ བཧཝོ ཛནཱ ཨཏིཏྲསྟཱ ཝིནཡེན ཏཾ ཛགདུཿ, བྷཝཱན྄ ཨསྨཱཀཾ ནིཀཊཱད྄ ཝྲཛཏུ ཏསྨཱཏ྄ ས ནཱཝམཱརུཧྱ ཏཏོ ཝྱཱགྷུཊྱ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ཏདཱནཱིཾ ཏྱཀྟབྷཱུཏམནུཛསྟེན སཧ སྠཱཏུཾ པྲཱརྠཡཱཉྩཀྲེ ");
INSERT INTO santib_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ཀིནྟུ ཏདརྠམ྄ ཨཱིཤྭརཿ ཀཱིདྲྀངྨཧཱཀརྨྨ ཀྲྀཏཝཱན྄ ཨིཏི ནིཝེཤནཾ གཏྭཱ ཝིཛྙཱཔཡ, ཡཱིཤུཿ ཀཐཱམེཏཱཾ ཀཐཡིཏྭཱ ཏཾ ཝིསསརྫ། ཏཏཿ ས ཝྲཛིཏྭཱ ཡཱིཤུསྟདརྠཾ ཡནྨཧཱཀརྨྨ ཙཀཱར ཏཏ྄ པུརསྱ སཪྻྭཏྲ པྲཀཱཤཡིཏུཾ པྲཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ཨཐ ཡཱིཤཽ པརཱཝྲྀཏྱཱགཏེ ལོཀཱསྟཾ ཨཱདརེཎ ཛགྲྀཧུ ཪྻསྨཱཏྟེ སཪྻྭེ ཏམཔེཀྵཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ཏདནནྟརཾ ཡཱཡཱིརྣཱམྣོ བྷཛནགེཧསྱཻཀོདྷིཔ ཨཱགཏྱ ཡཱིཤོཤྩརཎཡོཿ པཏིཏྭཱ སྭནིཝེཤནཱགམནཱརྠཾ ཏསྨིན྄ ཝིནཡཾ ཙཀཱར, ");
INSERT INTO santib_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ཡཏསྟསྱ དྭཱདཤཝརྵཝཡསྐཱ ཀནྱཻཀཱསཱིཏ྄ སཱ མྲྀཏཀལྤཱབྷཝཏ྄། ཏཏསྟསྱ གམནཀཱལེ མཱརྒེ ལོཀཱནཱཾ མཧཱན྄ སམཱགམོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","དྭཱདཤཝརྵཱཎི པྲདརརོགགྲསྟཱ ནཱནཱ ཝཻདྱཻཤྩིཀིཏྶིཏཱ སཪྻྭསྭཾ ཝྱཡིཏྭཱཔི སྭཱསྠྱཾ ན པྲཱཔྟཱ ཡཱ ཡོཥིཏ྄ སཱ ཡཱིཤོཿ པཤྩཱདཱགཏྱ ཏསྱ ཝསྟྲགྲནྠིཾ པསྤརྴ། ");
INSERT INTO santib_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ཏསྨཱཏ྄ ཏཏྐྵཎཱཏ྄ ཏསྱཱ རཀྟསྲཱཝོ རུདྡྷཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ཏདཱནཱིཾ ཡཱིཤུརཝདཏ྄ ཀེནཱཧཾ སྤྲྀཥྚཿ? ཏཏོ྅ནེཀཻརནངྒཱིཀྲྀཏེ པིཏརསྟསྱ སངྒིནཤྩཱཝདན྄, ཧེ གུརོ ལོཀཱ ནིཀཊསྠཱཿ སནྟསྟཝ དེཧེ གྷརྵཡནྟི, ཏཐཱཔི ཀེནཱཧཾ སྤྲྀཥྚཨིཏི བྷཝཱན྄ ཀུཏཿ པྲྀཙྪཏི? ");
INSERT INTO santib_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ཡཱིཤུཿ ཀཐཡཱམཱས, ཀེནཱཔྱཧཾ སྤྲྀཥྚོ, ཡཏོ མཏྟཿ ཤཀྟི རྣིརྒཏེཏི མཡཱ ནིཤྩིཏམཛྙཱཡི། ");
INSERT INTO santib_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ཏདཱ སཱ ནཱརཱི སྭཡཾ ན གུཔྟེཏི ཝིདིཏྭཱ ཀམྤམཱནཱ སཏཱི ཏསྱ སམྨུཁེ པཔཱཏ; ཡེན ནིམིཏྟེན ཏཾ པསྤརྴ སྤརྴམཱཏྲཱཙྩ ཡེན པྲཀཱརེཎ སྭསྠཱབྷཝཏ྄ ཏཏ྄ སཪྻྭཾ ཏསྱ སཱཀྵཱདཱཙཁྱཽ། ");
INSERT INTO santib_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ཏཏཿ ས ཏཱཾ ཛགཱད ཧེ ཀནྱེ སུསྠིརཱ བྷཝ, ཏཝ ཝིཤྭཱསསྟྭཱཾ སྭསྠཱམ྄ ཨཀཱརྵཱིཏ྄ ཏྭཾ ཀྵེམེཎ ཡཱཧི། ");
INSERT INTO santib_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ཡཱིཤོརེཏདྭཱཀྱཝདནཀཱལེ ཏསྱཱདྷིཔཏེ རྣིཝེཤནཱཏ྄ ཀཤྩིལློཀ ཨཱགཏྱ ཏཾ བབྷཱཥེ, ཏཝ ཀནྱཱ མྲྀཏཱ གུརུཾ མཱ ཀླིཤཱན། ");
INSERT INTO santib_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ཀིནྟུ ཡཱིཤུསྟདཱཀརྞྱཱདྷིཔཏིཾ ཝྱཱཛཧཱར, མཱ བྷཻཥཱིཿ ཀེཝལཾ ཝིཤྭསིཧི ཏསྨཱཏ྄ སཱ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ཨཐ ཏསྱ ནིཝེཤནེ པྲཱཔྟེ ས པིཏརཾ ཡོཧནཾ ཡཱཀཱུབཉྩ ཀནྱཱཡཱ མཱཏརཾ པིཏརཉྩ ཝིནཱ, ཨནྱཾ ཀཉྩན པྲཝེཥྚུཾ ཝཱརཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ཨཔརཉྩ ཡེ རུདནྟི ཝིལཔནྟི ཙ ཏཱན྄ སཪྻྭཱན྄ ཛནཱན྄ ཨུཝཱཙ, ཡཱུཡཾ མཱ རོདིཥྚ ཀནྱཱ ན མྲྀཏཱ ནིདྲཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ཀིནྟུ སཱ ནིཤྩིཏཾ མྲྀཏེཏི ཛྙཱཏྭཱ ཏེ ཏམུཔཛཧསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","པཤྩཱཏ྄ ས སཪྻྭཱན྄ བཧིཿ ཀྲྀཏྭཱ ཀནྱཱཡཱཿ ཀརཽ དྷྲྀཏྭཱཛུཧུཝེ, ཧེ ཀནྱེ ཏྭམུཏྟིཥྛ, ");
INSERT INTO santib_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ཏསྨཱཏ྄ ཏསྱཱཿ པྲཱཎེཥུ པུནརཱགཏེཥུ སཱ ཏཏྐྵཎཱད྄ ཨུཏྟསྱཽ། ཏདཱནཱིཾ ཏསྱཻ ཀིཉྩིད྄ བྷཀྵྱཾ དཱཏུམ྄ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ཏཏསྟསྱཱཿ པིཏརཽ ཝིསྨཡཾ གཏཽ ཀིནྟུ ས ཏཱཝཱདིདེཤ གྷཊནཱཡཱ ཨེཏསྱཱཿ ཀཐཱཾ ཀསྨཻཙིདཔི མཱ ཀཐཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ཏཏཿ པརཾ ས དྭཱདཤཤིཥྱཱནཱཧཱུཡ བྷཱུཏཱན྄ ཏྱཱཛཡིཏུཾ རོགཱན྄ པྲཏིཀརྟྟུཉྩ ཏེབྷྱཿ ཤཀྟིམཱདྷིཔཏྱཉྩ དདཽ། ");
INSERT INTO santib_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ཨཔརཉྩ ཨཱིཤྭརཱིཡརཱཛྱསྱ སུསཾཝཱདཾ པྲཀཱཤཡིཏུམ྄ རོགིཎཱམཱརོགྱཾ ཀརྟྟུཉྩ པྲེརཎཀཱལེ ཏཱན྄ ཛགཱད། ");
INSERT INTO santib_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ཡཱཏྲཱརྠཾ ཡཥྚི ཪྻསྟྲཔུཊཀཾ བྷཀྵྱཾ མུདྲཱ དྭིཏཱིཡཝསྟྲམ྄, ཨེཥཱཾ ཀིམཔི མཱ གྲྀཧླཱིཏ། ");
INSERT INTO santib_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ཡཱུཡཉྩ ཡནྣིཝེཤནཾ པྲཝིཤཐ ནགརཏྱཱགཔཪྻྱནཏཾ ཏནྣིཝེཤནེ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ཏཏྲ ཡདི ཀསྱཙིཏ྄ པུརསྱ ལོཀཱ ཡུཥྨཱཀམཱཏིཐྱཾ ན ཀུཪྻྭནྟི ཏརྷི ཏསྨཱནྣགརཱད྄ གམནཀཱལེ ཏེཥཱཾ ཝིརུདྡྷཾ སཱཀྵྱཱརྠཾ ཡུཥྨཱཀཾ པདདྷཱུལཱིཿ སམྤཱཏཡཏ། ");
INSERT INTO santib_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ཨཐ ཏེ པྲསྠཱཡ སཪྻྭཏྲ སུསཾཝཱདཾ པྲཙཱརཡིཏུཾ པཱིཌིཏཱན྄ སྭསྠཱན྄ ཀརྟྟུཉྩ གྲཱམེཥུ བྷྲམིཏུཾ པྲཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ཨེཏརྷི ཧེརོད྄ རཱཛཱ ཡཱིཤོཿ སཪྻྭཀརྨྨཎཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱ བྷྲྀཤམུདྭིཝིཛེ ");
INSERT INTO santib_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ཡཏཿ ཀེཙིདཱུཙུཪྻོཧན྄ ཤྨཤཱནཱདུདཏིཥྛཏ྄། ཀེཙིདཱུཙུཿ, ཨེལིཡོ དརྴནཾ དཏྟཝཱན྄; ཨེཝམནྱལོཀཱ ཨཱུཙུཿ པཱུཪྻྭཱིཡཿ ཀཤྩིད྄ བྷཝིཥྱདྭཱདཱི སམུཏྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ཀིནྟུ ཧེརོདུཝཱཙ ཡོཧནཿ ཤིརོ྅ཧམཚིནདམ྄ ཨིདཱནཱིཾ ཡསྱེདྲྀཀྐརྨྨཎཱཾ ཝཱརྟྟཱཾ པྲཱཔྣོམི ས ཀཿ? ཨཐ ས ཏཾ དྲཥྚུམ྄ ཨཻཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ཨནནྟརཾ པྲེརིཏཱཿ པྲཏྱཱགཏྱ ཡཱནི ཡཱནི ཀརྨྨཱཎི ཙཀྲུསྟཱནི ཡཱིཤཝེ ཀཐཡཱམཱསུཿ ཏཏཿ ས ཏཱན྄ བཻཏྶཻདཱནཱམཀནགརསྱ ཝིཛནཾ སྠཱནཾ ནཱིཏྭཱ གུཔྟཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","པཤྩཱལ྄ ལོཀཱསྟད྄ ཝིདིཏྭཱ ཏསྱ པཤྩཱད྄ ཡཡུཿ; ཏཏཿ ས ཏཱན྄ ནཡན྄ ཨཱིཤྭརཱིཡརཱཛྱསྱ པྲསངྒམུཀྟཝཱན྄, ཡེཥཱཾ ཙིཀིཏྶཡཱ པྲཡོཛནམ྄ ཨཱསཱིཏ྄ ཏཱན྄ སྭསྠཱན྄ ཙཀཱར ཙ། ");
INSERT INTO santib_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ཨཔརཉྩ དིཝཱཝསནྣེ སཏི དྭཱདཤཤིཥྱཱ ཡཱིཤོརནྟིཀམ྄ ཨེཏྱ ཀཐཡཱམཱསུཿ, ཝཡམཏྲ པྲཱནྟརསྠཱནེ ཏིཥྛཱམཿ, ཏཏོ ནགརཱཎི གྲཱམཱཎི གཏྭཱ ཝཱསསྠཱནཱནི པྲཱཔྱ བྷཀྵྱདྲཝྱཱཎི ཀྲེཏུཾ ཛནནིཝཧཾ བྷཝཱན྄ ཝིསྲྀཛཏུ། ");
INSERT INTO santib_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ཏདཱ ས ཨུཝཱཙ, ཡཱུཡམེཝ ཏཱན྄ བྷེཛཡདྷྭཾ; ཏཏསྟེ པྲོཙུརསྨཱཀཾ ནིཀཊེ ཀེཝལཾ པཉྩ པཱུཔཱ དྭཽ མཏྶྱཽ ཙ ཝིདྱནྟེ, ཨཏཨེཝ སྠཱནཱནྟརམ྄ ཨིཏྭཱ ནིམིཏྟམེཏེཥཱཾ བྷཀྵྱདྲཝྱེཥུ ན ཀྲཱིཏེཥུ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ཏཏྲ པྲཱཡེཎ པཉྩསཧསྲཱཎི པུརུཥཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ཏདཱ ས ཤིཥྱཱན྄ ཛགཱད པཉྩཱཤཏ྄ པཉྩཱཤཛྫནཻཿ པཾཀྟཱིཀྲྀཏྱ ཏཱནུཔཝེཤཡཏ, ཏསྨཱཏ྄ ཏེ ཏདནུསཱརེཎ སཪྻྭལོཀཱནུཔཝེཤཡཱཔཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ཏཏཿ ས ཏཱན྄ པཉྩ པཱུཔཱན྄ མཱིནདྭཡཉྩ གྲྀཧཱིཏྭཱ སྭརྒཾ ཝིལོཀྱེཤྭརགུཎཱན྄ ཀཱིརྟྟཡཱཉྩཀྲེ བྷངྐྟཱ ཙ ལོཀེབྷྱཿ པརིཝེཥཎཱརྠཾ ཤིཥྱེཥུ སམརྤཡཱམྦབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ཏཏཿ སཪྻྭེ བྷུཀྟྭཱ ཏྲྀཔྟིཾ གཏཱ ཨཝཤིཥྚཱནཱཉྩ དྭཱདཤ ཌལླཀཱན྄ སཾཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ཨཐཻཀདཱ ནིརྫནེ ཤིཥྱཻཿ སཧ པྲཱརྠནཱཀཱལེ ཏཱན྄ པཔྲཙྪ, ལོཀཱ མཱཾ ཀཾ ཝདནྟི? ");
INSERT INTO santib_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ཏཏསྟེ པྲཱཙུཿ, ཏྭཱཾ ཡོཧནྨཛྫཀཾ ཝདནྟི; ཀེཙིཏ྄ ཏྭཱམ྄ ཨེལིཡཾ ཝདནྟི, པཱུཪྻྭཀཱལིཀཿ ཀཤྩིད྄ བྷཝིཥྱདྭཱདཱི ཤྨཤཱནཱད྄ ཨུདཏིཥྛད྄ ཨིཏྱཔི ཀེཙིད྄ ཝདནྟི། ");
INSERT INTO santib_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ཏདཱ ས ཨུཝཱཙ, ཡཱུཡཾ མཱཾ ཀཾ ཝདཐ? ཏཏཿ པིཏར ཨུཀྟཝཱན྄ ཏྭམ྄ ཨཱིཤྭརཱབྷིཥིཀྟཿ པུརུཥཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ཏདཱ ས ཏཱན྄ དྲྀཌྷམཱདིདེཤ, ཀཐཱམེཏཱཾ ཀསྨཻཙིདཔི མཱ ཀཐཡཏ། ");
INSERT INTO santib_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ས པུནརུཝཱཙ, མནུཥྱཔུཏྲེཎ ཝཧུཡཱཏནཱ བྷོཀྟཝྱཱཿ པྲཱཙཱིནལོཀཻཿ པྲདྷཱནཡཱཛཀཻརདྷྱཱཔཀཻཤྩ སོཝཛྙཱཡ ཧནྟཝྱཿ ཀིནྟུ ཏྲྀཏཱིཡདིཝསེ ཤྨཤཱནཱཏ྄ ཏེནོཏྠཱཏཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ཨཔརཾ ས སཪྻྭཱནུཝཱཙ, ཀཤྩིད྄ ཡདི མམ པཤྩཱད྄ གནྟུཾ ཝཱཉྪཏི ཏརྷི ས སྭཾ དཱམྱཏུ, དིནེ དིནེ ཀྲུཤཾ གྲྀཧཱིཏྭཱ ཙ མམ པཤྩཱདཱགཙྪཏུ། ");
INSERT INTO santib_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ཡཏོ ཡཿ ཀཤྩིཏ྄ སྭཔྲཱཎཱན྄ རིརཀྵིཥཏི ས ཏཱན྄ ཧཱརཡིཥྱཏི, ཡཿ ཀཤྩིན྄ མདརྠཾ པྲཱཎཱན྄ ཧཱརཡིཥྱཏི ས ཏཱན྄ རཀྵིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ཀཤྩིད྄ ཡདི སཪྻྭཾ ཛགཏ྄ པྲཱཔྣོཏི ཀིནྟུ སྭཔྲཱཎཱན྄ ཧཱརཡཏི སྭཡཾ ཝིནཤྱཏི ཙ ཏརྷི ཏསྱ ཀོ ལཱབྷཿ? ");
INSERT INTO santib_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","པུན ཪྻཿ ཀཤྩིན྄ མཱཾ མམ ཝཱཀྱཾ ཝཱ ལཛྫཱསྤདཾ ཛཱནཱཏི མནུཥྱཔུཏྲོ ཡདཱ སྭསྱ པིཏུཤྩ པཝིཏྲཱཎཱཾ དཱུཏཱནཱཉྩ ཏེཛོབྷིཿ པརིཝེཥྚིཏ ཨཱགམིཥྱཏི ཏདཱ སོཔི ཏཾ ལཛྫཱསྤདཾ ཛྙཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ཀིནྟུ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཨཱིཤྭརཱིཡརཱཛཏྭཾ ན དྲྀཥྚཝཱ མྲྀཏྱུཾ ནཱསྭཱདིཥྱནྟེ, ཨེཏཱདྲྀཤཱཿ ཀིཡནྟོ ལོཀཱ ཨཏྲ སྠནེ྅པི དཎྜཱཡམཱནཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ཨེཏདཱཁྱཱནཀཐནཱཏ྄ པརཾ པྲཱཡེཎཱཥྚསུ དིནེཥུ གཏེཥུ ས པིཏརཾ ཡོཧནཾ ཡཱཀཱུབཉྩ གྲྀཧཱིཏྭཱ པྲཱརྠཡིཏུཾ པཪྻྭཏམེཀཾ སམཱརུརོཧ། ");
INSERT INTO santib_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ཨཐ ཏསྱ པྲཱརྠནཀཱལེ ཏསྱ མུཁཱཀྲྀཏིརནྱརཱུཔཱ ཛཱཏཱ, ཏདཱིཡཾ ཝསྟྲམུཛྫྭལཤུཀླཾ ཛཱཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ཨཔརཉྩ མཱུསཱ ཨེལིཡཤྩོབྷཽ ཏེཛསྭིནཽ དྲྀཥྚཽ ");
INSERT INTO santib_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ཏཽ ཏེན ཡིརཱུཤཱལམྤུརེ ཡོ མྲྀཏྱུཿ སཱདྷིཥྱཏེ ཏདཱིཡཱཾ ཀཐཱཾ ཏེན སཱརྡྡྷཾ ཀཐཡིཏུམ྄ ཨཱརེབྷཱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ཏདཱ པིཏརཱདཡཿ སྭསྱ སངྒིནོ ནིདྲཡཱཀྲྀཥྚཱ ཨཱསན྄ ཀིནྟུ ཛཱགརིཏྭཱ ཏསྱ ཏེཛསྟེན སཱརྡྡྷམ྄ ཨུཏྟིཥྛནྟཽ ཛནཽ ཙ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ཨཐ ཏཡོརུབྷཡོ རྒམནཀཱལེ པིཏརོ ཡཱིཤུཾ བབྷཱཥེ, ཧེ གུརོ྅སྨཱཀཾ སྠཱནེ྅སྨིན྄ སྠིཏིཿ ཤུབྷཱ, ཏཏ ཨེཀཱ ཏྭདརྠཱ, ཨེཀཱ མཱུསཱརྠཱ, ཨེཀཱ ཨེལིཡཱརྠཱ, ཨིཏི ཏིསྲཿ ཀུཊྱོསྨཱབྷི རྣིརྨྨཱིཡནྟཱཾ, ཨིམཱཾ ཀཐཱཾ ས ན ཝིཝིཙྱ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ཨཔརཉྩ ཏདྭཱཀྱཝདནཀཱལེ པཡོད ཨེཀ ཨཱགཏྱ ཏེཥཱམུཔརི ཚཱཡཱཾ ཙཀཱར, ཏཏསྟནྨདྷྱེ ཏཡོཿ པྲཝེཤཱཏ྄ ཏེ ཤཤངྐིརེ། ");
INSERT INTO santib_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ཏདཱ ཏསྨཱཏ྄ པཡོདཱད྄ ཨིཡམཱཀཱཤཱིཡཱ ཝཱཎཱི ནིརྫགཱམ, མམཱཡཾ པྲིཡཿ པུཏྲ ཨེཏསྱ ཀཐཱཡཱཾ མནོ ནིདྷཏྟ། ");
INSERT INTO santib_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ཨིཏི ཤབྡེ ཛཱཏེ ཏེ ཡཱིཤུམེཀཱཀིནཾ དདྲྀཤུཿ ཀིནྟུ ཏེ ཏདཱནཱིཾ ཏསྱ དརྴནསྱ ཝཱཙམེཀཱམཔི ནོཀྟྭཱ མནཿསུ སྠཱཔཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","པརེ྅ཧནི ཏེཥུ ཏསྨཱཙྪཻལཱད྄ ཨཝརཱུཌྷེཥུ ཏཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ བཧཝོ ལོཀཱ ཨཱཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ཏེཥཱཾ མདྷྱཱད྄ ཨེཀོ ཛན ཨུཙྩཻརུཝཱཙ, ཧེ གུརོ ཨཧཾ ཝིནཡཾ ཀརོམི མམ པུཏྲཾ པྲཏི ཀྲྀཔཱདྲྀཥྚིཾ ཀརོཏུ, མམ ས ཨེཝཻཀཿ པུཏྲཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","བྷཱུཏེན དྷྲྀཏཿ སན྄ སཾ པྲསབྷཾ ཙཱིཙྪབྡཾ ཀརོཏི ཏནྨུཁཱཏ྄ ཕེཎཱ ནིརྒཙྪནྟི ཙ, བྷཱུཏ ཨིཏྠཾ ཝིདཱཪྻྱ ཀླིཥྚྭཱ པྲཱཡཤསྟཾ ན ཏྱཛཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ཏསྨཱཏ྄ ཏཾ བྷཱུཏཾ ཏྱཱཛཡིཏུཾ ཏཝ ཤིཥྱསམཱིཔེ ནྱཝེདཡཾ ཀིནྟུ ཏེ ན ཤེཀུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ཏདཱ ཡཱིཤུརཝཱདཱིཏ྄, རེ ཨཱཝིཤྭཱསིན྄ ཝིཔཐགཱམིན྄ ཝཾཤ ཀཏིཀཱལཱན྄ ཡུཥྨཱབྷིཿ སཧ སྠཱསྱཱམྱཧཾ ཡུཥྨཱཀམ྄ ཨཱཙརཎཱནི ཙ སཧིཥྱེ? ཏཝ པུཏྲམིཧཱནཡ། ");
INSERT INTO santib_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ཏཏསྟསྨིནྣཱགཏམཱཏྲེ བྷཱུཏསྟཾ བྷཱུམཽ པཱཏཡིཏྭཱ ཝིདདཱར; ཏདཱ ཡཱིཤུསྟམམེདྷྱཾ བྷཱུཏཾ ཏརྫཡིཏྭཱ བཱལཀཾ སྭསྠཾ ཀྲྀཏྭཱ ཏསྱ པིཏརི སམརྤཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ཨཱིཤྭརསྱ མཧཱཤཀྟིམ྄ ཨིམཱཾ ཝིལོཀྱ སཪྻྭེ ཙམཙྩཀྲུཿ; ཨིཏྠཾ ཡཱིཤོཿ སཪྻྭཱབྷིཿ ཀྲིཡཱབྷིཿ སཪྻྭཻརློཀཻརཱཤྩཪྻྱེ མནྱམཱནེ སཏི ས ཤིཥྱཱན྄ བབྷཱཥེ, ");
INSERT INTO santib_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ཀཐེཡཾ ཡུཥྨཱཀཾ ཀརྞེཥུ པྲཝིཤཏུ, མནུཥྱཔུཏྲོ མནུཥྱཱཎཱཾ ཀརེཥུ སམརྤཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ཀིནྟུ ཏེ ཏཱཾ ཀཐཱཾ ན བུབུདྷིརེ, སྤཥྚཏྭཱབྷཱཝཱཏ྄ ཏསྱཱ ཨབྷིཔྲཱཡསྟེཥཱཾ བོདྷགམྱོ ན བབྷཱུཝ; ཏསྱཱ ཨཱཤཡཿ ཀ ཨིཏྱཔི ཏེ བྷཡཱཏ྄ པྲཥྚུཾ ན ཤེཀུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ཏདནནྟརཾ ཏེཥཱཾ མདྷྱེ ཀཿ ཤྲེཥྛཿ ཀཐཱམེཏཱཾ གྲྀཧཱིཏྭཱ ཏེ མིཐོ ཝིཝཱདཾ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ཏཏོ ཡཱིཤུསྟེཥཱཾ མནོབྷིཔྲཱཡཾ ཝིདིཏྭཱ བཱལཀམེཀཾ གྲྀཧཱིཏྭཱ སྭསྱ ནིཀཊེ སྠཱཔཡིཏྭཱ ཏཱན྄ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ཡོ ཛནོ མམ ནཱམྣཱསྱ བཱལཱསྱཱཏིཐྱཾ ཝིདདྷཱཏི ས མམཱཏིཐྱཾ ཝིདདྷཱཏི, ཡཤྩ མམཱཏིཐྱཾ ཝིདདྷཱཏི ས མམ པྲེརཀསྱཱཏིཐྱཾ ཝིདདྷཱཏི, ཡུཥྨཱཀཾ མདྷྱེཡཿ སྭཾ སཪྻྭསྨཱཏ྄ ཀྵུདྲཾ ཛཱནཱིཏེ ས ཨེཝ ཤྲེཥྛོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ཨཔརཉྩ ཡོཧན྄ ཝྱཱཛཧཱར ཧེ པྲབྷེा ཏཝ ནཱམྣཱ བྷཱུཏཱན྄ ཏྱཱཛཡནྟཾ མཱནུཥམ྄ ཨེཀཾ དྲྀཥྚཝནྟོ ཝཡཾ, ཀིནྟྭསྨཱཀམ྄ ཨཔཤྩཱད྄ གཱམིཏྭཱཏ྄ ཏཾ ནྱཥེདྷཱམ྄། ཏདཱནཱིཾ ཡཱིཤུརུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ཏཾ མཱ ནིཥེདྷཏ, ཡཏོ ཡོ ཛནོསྨཱཀཾ ན ཝིཔཀྵཿ ས ཨེཝཱསྨཱཀཾ སཔཀྵོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ཨནནྟརཾ ཏསྱཱརོཧཎསམཡ ཨུཔསྠིཏེ ས སྠིརཙེཏཱ ཡིརཱུཤཱལམཾ པྲཏི ཡཱཏྲཱཾ ཀརྟྟུཾ ནིཤྩིཏྱཱགྲེ དཱུཏཱན྄ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ཏསྨཱཏ྄ ཏེ གཏྭཱ ཏསྱ པྲཡོཛནཱིཡདྲཝྱཱཎི སཾགྲཧཱིཏུཾ ཤོམིརོཎཱིཡཱནཱཾ གྲཱམཾ པྲཝིཝིཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ཀིནྟུ ས ཡིརཱུཤཱལམཾ ནགརཾ ཡཱཏི ཏཏོ ཧེཏོ རློཀཱསྟསྱཱཏིཐྱཾ ན ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ཨཏཨེཝ ཡཱཀཱུབྱོཧནཽ ཏསྱ ཤིཥྱཽ ཏད྄ དྲྀཥྚྭཱ ཛགདཏུཿ, ཧེ པྲབྷོ ཨེལིཡོ ཡཐཱ ཙཀཱར ཏཐཱ ཝཡམཔི ཀིཾ གགཎཱད྄ ཨཱགནྟུམ྄ ཨེཏཱན྄ བྷསྨཱིཀརྟྟུཉྩ ཝཧྣིམཱཛྙཱཔཡཱམཿ? བྷཝཱན྄ ཀིམིཙྪཏི? ");
INSERT INTO santib_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ཀིནྟུ ས མུཁཾ པརཱཝརྟྱ ཏཱན྄ ཏརྫཡིཏྭཱ གདིཏཝཱན྄ ཡུཥྨཱཀཾ མནོབྷཱཝཿ ཀཿ, ཨིཏི ཡཱུཡཾ ན ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","མནུཛསུཏོ མནུཛཱནཱཾ པྲཱཎཱན྄ ནཱཤཡིཏུཾ ནཱགཙྪཏ྄, ཀིནྟུ རཀྵིཏུམ྄ ཨཱགཙྪཏ྄། པཤྩཱད྄ ཨིཏརགྲཱམཾ ཏེ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ཏདནནྟརཾ པཐི གམནཀཱལེ ཛན ཨེཀསྟཾ བབྷཱཥེ, ཧེ པྲབྷོ བྷཝཱན྄ ཡཏྲ ཡཱཏི བྷཝཏཱ སཧཱཧམཔི ཏཏྲ ཡཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ཏདཱནཱིཾ ཡཱིཤུསྟམུཝཱཙ, གོམཱཡཱུནཱཾ གརྟྟཱ ཨཱསཏེ, ཝིཧཱཡསཱིཡཝིཧགཱाནཱཾ ནཱིཌཱནི ཙ སནྟི, ཀིནྟུ མཱནཝཏནཡསྱ ཤིརཿ སྠཱཔཡིཏུཾ སྠཱནཾ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ཏཏཿ པརཾ ས ཨིཏརཛནཾ ཛགཱད, ཏྭཾ མམ པཤྩཱད྄ ཨེཧི; ཏཏཿ ས ཨུཝཱཙ, ཧེ པྲབྷོ པཱུཪྻྭཾ པིཏརཾ ཤྨཤཱནེ སྠཱཔཡིཏུཾ མཱམཱདིཤཏུ། ");
INSERT INTO santib_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ཏདཱ ཡཱིཤུརུཝཱཙ, མྲྀཏཱ མྲྀཏཱན྄ ཤྨཤཱནེ སྠཱཔཡནྟུ ཀིནྟུ ཏྭཾ གཏྭེཤྭརཱིཡརཱཛྱསྱ ཀཐཱཾ པྲཙཱརཡ། ");
INSERT INTO santib_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ཏཏོནྱཿ ཀཐཡཱམཱས, ཧེ པྲབྷོ མཡཱཔི བྷཝཏཿ པཤྩཱད྄ གཾསྱཏེ, ཀིནྟུ པཱུཪྻྭཾ མམ ནིཝེཤནསྱ པརིཛནཱནཱམ྄ ཨནུམཏིཾ གྲཧཱིཏུམ྄ ཨཧམཱདིཤྱཻ བྷཝཏཱ། ");
INSERT INTO santib_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ཏདཱནཱིཾ ཡཱིཤུསྟཾ པྲོཀྟཝཱན྄, ཡོ ཛནོ ལཱངྒལེ ཀརམརྤཡིཏྭཱ པཤྩཱཏ྄ པཤྱཏི ས ཨཱིཤྭརཱིཡརཱཛྱཾ ནཱརྷཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ཏཏཿ པརཾ པྲབྷུརཔརཱན྄ སཔྟཏིཤིཥྱཱན྄ ནིཡུཛྱ སྭཡཾ ཡཱནི ནགརཱཎི ཡཱནི སྠཱནཱནི ཙ གམིཥྱཏི ཏཱནི ནགརཱཎི ཏཱནི སྠཱནཱནི ཙ པྲཏི དྭཽ དྭཽ ཛནཽ པྲཧིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ཏེབྷྱཿ ཀཐཡཱམཱས ཙ ཤསྱཱནི བཧཱུནཱིཏི སཏྱཾ ཀིནྟུ ཚེདཀཱ ཨལྤེ; ཏསྨཱདྡྷེཏོཿ ཤསྱཀྵེཏྲེ ཚེདཀཱན྄ ཨཔརཱནཔི པྲེཥཡིཏུཾ ཀྵེཏྲསྭཱམིནཾ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ཡཱུཡཾ ཡཱཏ, པཤྱཏ, ཝྲྀཀཱཎཱཾ མདྷྱེ མེཥཤཱཝཀཱནིཝ ཡུཥྨཱན྄ པྲཧིཎོམི། ");
INSERT INTO santib_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ཡཱུཡཾ ཀྵུདྲཾ མཧད྄ ཝཱ ཝསནསམྤུཊཀཾ པཱདུཀཱཤྩ མཱ གྲྀཧླཱིཏ, མཱརྒམདྷྱེ ཀམཔི མཱ ནམཏ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ཨཔརཉྩ ཡཱུཡཾ ཡད྄ ཡཏ྄ ནིཝེཤནཾ པྲཝིཤཐ ཏཏྲ ནིཝེཤནསྱཱསྱ མངྒལཾ བྷཱུཡཱདིཏི ཝཱཀྱཾ པྲཐམཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ཏསྨཱཏ྄ ཏསྨིན྄ ནིཝེཤནེ ཡདི མངྒལཔཱཏྲཾ སྠཱསྱཏི ཏརྷི ཏནྨངྒལཾ ཏསྱ བྷཝིཥྱཏི, ནོཙེཏ྄ ཡུཥྨཱན྄ པྲཏི པརཱཝརྟྟིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ཨཔརཉྩ ཏེ ཡཏྐིཉྩིད྄ དཱསྱནྟི ཏདེཝ བྷུཀྟྭཱ པཱིཏྭཱ ཏསྨིནྣིཝེཤནེ སྠཱསྱཐ; ཡཏཿ ཀརྨྨཀཱརཱི ཛནོ བྷྲྀཏིམ྄ ཨརྷཏི; གྲྀཧཱད྄ གྲྀཧཾ མཱ ཡཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ཨནྱཙྩ ཡུཥྨཱསུ ཀིམཔི ནགརཾ པྲཝིཥྚེཥུ ལོཀཱ ཡདི ཡུཥྨཱཀམ྄ ཨཱཏིཐྱཾ ཀརིཥྱནྟི, ཏརྷི ཡཏ྄ ཁཱདྱམ྄ ཨུཔསྠཱསྱནྟི ཏདེཝ ཁཱདིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ཏནྣགརསྠཱན྄ རོགིཎཿ སྭསྠཱན྄ ཀརིཥྱཐ, ཨཱིཤྭརཱིཡཾ རཱཛྱཾ ཡུཥྨཱཀམ྄ ཨནྟིཀམ྄ ཨཱགམཏ྄ ཀཐཱམེཏཱཉྩ པྲཙཱརཡིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ཀིནྟུ ཀིམཔི པུརཾ ཡུཥྨཱསུ པྲཝིཥྚེཥུ ལོཀཱ ཡདི ཡུཥྨཱཀམ྄ ཨཱཏིཐྱཾ ན ཀརིཥྱནྟི, ཏརྷི ཏསྱ ནགརསྱ པནྠཱནཾ གཏྭཱ ཀཐཱམེཏཱཾ ཝདིཥྱཐ, ");
INSERT INTO santib_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ཡུཥྨཱཀཾ ནགརཱིཡཱ ཡཱ དྷཱུལྱོ྅སྨཱསུ སམལགན྄ ཏཱ ཨཔི ཡུཥྨཱཀཾ པྲཱཏིཀཱུལྱེན སཱཀྵྱཱརྠཾ སམྤཱཏཡཱམཿ; ཏཐཱཔཱིཤྭརརཱཛྱཾ ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགཏམ྄ ཨིཏི ནིཤྩིཏཾ ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ཨཧཾ ཡུཥྨབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི, ཝིཙཱརདིནེ ཏསྱ ནགརསྱ དཤཱཏཿ སིདོམོ དཤཱ སཧྱཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ཧཱ ཧཱ ཀོརཱསཱིན྄ ནགར, ཧཱ ཧཱ བཻཏྶཻདཱནགར ཡུཝཡོརྨདྷྱེ ཡཱདྲྀཤཱནི ཨཱཤྩཪྻྱཱཎི ཀརྨྨཱཎྱཀྲིཡནྟ, ཏཱནི ཀརྨྨཱཎི ཡདི སོརསཱིདོནོ རྣགརཡོརཀཱརིཥྱནྟ, ཏདཱ ཨིཏོ བཧུདིནཔཱུཪྻྭཾ ཏནྣིཝཱསིནཿ ཤཎཝསྟྲཱཎི པརིདྷཱཡ གཱཏྲེཥུ བྷསྨ ཝིལིཔྱ སམུཔཝིཤྱ སམཁེཏྶྱནྟ། ");
INSERT INTO santib_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ཨཏོ ཝིཙཱརདིཝསེ ཡུཥྨཱཀཾ དཤཱཏཿ སོརསཱིདོནྣིཝཱསིནཱཾ དཤཱ སཧྱཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ཧེ ཀཕརྣཱཧཱུམ྄, ཏྭཾ སྭརྒཾ ཡཱཝད྄ ཨུནྣཏཱ ཀིནྟུ ནརཀཾ ཡཱཝཏ྄ ནྱགྦྷཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ཡོ ཛནོ ཡུཥྨཱཀཾ ཝཱཀྱཾ གྲྀཧླཱཏི ས མམཻཝ ཝཱཀྱཾ གྲྀཧླཱཏི; ཀིཉྩ ཡོ ཛནོ ཡུཥྨཱཀམ྄ ཨཝཛྙཱཾ ཀརོཏི ས མམཻཝཱཝཛྙཱཾ ཀརོཏི; ཡོ ཛནོ མམཱཝཛྙཱཾ ཀརོཏི ཙ ས མཏྤྲེརཀསྱཻཝཱཝཛྙཱཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ཨཐ ཏེ སཔྟཏིཤིཥྱཱ ཨཱནནྡེན པྲཏྱཱགཏྱ ཀཐཡཱམཱསུཿ, ཧེ པྲབྷོ བྷཝཏོ ནཱམྣཱ བྷཱུཏཱ ཨཔྱསྨཱཀཾ ཝཤཱིབྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ཏདཱནཱིཾ ས ཏཱན྄ ཛགཱད, ཝིདྱུཏམིཝ སྭརྒཱཏ྄ པཏནྟཾ ཤཻཏཱནམ྄ ཨདརྴམ྄། ");
INSERT INTO santib_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","པཤྱཏ སརྤཱན྄ ཝྲྀཤྩིཀཱན྄ རིཔོཿ སཪྻྭཔརཱཀྲམཱཾཤྩ པདཏལཻ རྡལཡིཏུཾ ཡུཥྨབྷྱཾ ཤཀྟིཾ དདཱམི ཏསྨཱད྄ ཡུཥྨཱཀཾ ཀཱཔི ཧཱནི རྣ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","བྷཱུཏཱ ཡུཥྨཱཀཾ ཝཤཱིབྷཝནྟི, ཨེཏནྣིམིཏྟཏ྄ མཱ སམུལླསཏ, སྭརྒེ ཡུཥྨཱཀཾ ནཱམཱནི ལིཁིཏཱནི སནྟཱིཏི ནིམིཏྟཾ སམུལླསཏ། ");
INSERT INTO santib_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ཏདྒྷཊིཀཱཡཱཾ ཡཱིཤུ རྨནསི ཛཱཏཱཧླཱདཿ ཀཐཡཱམཱས ཧེ སྭརྒཔྲྀཐིཝྱོརེཀཱདྷིཔཏེ པིཏསྟྭཾ ཛྙཱནཝཏཱཾ ཝིདུཥཱཉྩ ལོཀཱནཱཾ པུརསྟཱཏ྄ སཪྻྭམེཏད྄ ཨཔྲཀཱཤྱ བཱལཀཱནཱཾ པུརསྟཱཏ྄ པྲཱཀཱཤཡ ཨེཏསྨཱདྡྷེཏོསྟྭཱཾ དྷནྱཾ ཝདཱམི, ཧེ པིཏརིཏྠཾ བྷཝཏུ ཡད྄ ཨེཏདེཝ ཏཝ གོཙར ཨུཏྟམམ྄། ");
INSERT INTO santib_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","པིཏྲཱ སཪྻྭཱཎི མཡི སམརྤིཏཱནི པིཏརཾ ཝིནཱ ཀོཔི པུཏྲཾ ན ཛཱནཱཏི ཀིཉྩ པུཏྲཾ ཝིནཱ ཡསྨཻ ཛནཱཡ པུཏྲསྟཾ པྲཀཱཤིཏཝཱན྄ ཏཉྩ ཝིནཱ ཀོཔི པིཏརཾ ན ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ཏཔཿ པརཾ ས ཤིཥྱཱན྄ པྲཏི པརཱཝྲྀཏྱ གུཔྟཾ ཛགཱད, ཡཱུཡམེཏཱནི སཪྻྭཱཎི པཤྱཐ ཏཏོ ཡུཥྨཱཀཾ ཙཀྵཱུཾཥི དྷནྱཱནི། ");
INSERT INTO santib_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ཡུཥྨཱནཧཾ ཝདཱམི, ཡཱུཡཾ ཡཱནི སཪྻྭཱཎི པཤྱཐ ཏཱནི བཧཝོ བྷཝིཥྱདྭཱདིནོ བྷཱུཔཏཡཤྩ དྲཥྚུམིཙྪནྟོཔི དྲཥྚུཾ ན པྲཱཔྣུཝན྄, ཡུཥྨཱབྷི ཪྻཱ ཡཱཿ ཀཐཱཤྩ ཤྲཱུཡནྟེ ཏཱཿ ཤྲོཏུམིཙྪནྟོཔི ཤྲོཏུཾ ནཱལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ཨནནྟརམ྄ ཨེཀོ ཝྱཝསྠཱཔཀ ཨུཏྠཱཡ ཏཾ པརཱིཀྵིཏུཾ པཔྲཙྪ, ཧེ ཨུཔདེཤཀ ཨནནྟཱཡུཥཿ པྲཱཔྟཡེ མཡཱ ཀིཾ ཀརཎཱིཡཾ? ");
INSERT INTO santib_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ཡཱིཤུཿ པྲཏྱུཝཱཙ, ཨཏྲཱརྠེ ཝྱཝསྠཱཡཱཾ ཀིཾ ལིཁིཏམསྟི? ཏྭཾ ཀཱིདྲྀཀ྄ པཋསི? ");
INSERT INTO santib_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ཏཏཿ སོཝདཏ྄, ཏྭཾ སཪྻྭཱནྟཿཀརཎཻཿ སཪྻྭཔྲཱཎཻཿ སཪྻྭཤཀྟིབྷིཿ སཪྻྭཙིཏྟཻཤྩ པྲབྷཽ པརམེཤྭརེ པྲེམ ཀུརུ, སམཱིཔཝཱསིནི སྭཝཏ྄ པྲེམ ཀུརུ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ཏདཱ ས ཀཐཡཱམཱས, ཏྭཾ ཡཐཱརྠཾ པྲཏྱཝོཙཿ, ཨིཏྠམ྄ ཨཱཙར ཏེནཻཝ ཛཱིཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ཀིནྟུ ས ཛནཿ སྭཾ ནིརྡྡོཥཾ ཛྙཱཔཡིཏུཾ ཡཱིཤུཾ པཔྲཙྪ, མམ སམཱིཔཝཱསཱི ཀཿ? ཏཏོ ཡཱིཤུཿ པྲཏྱུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ཨེཀོ ཛནོ ཡིརཱུཤཱལམྤུརཱད྄ ཡིརཱིཧོཔུརཾ ཡཱཏི, ཨེཏརྷི དསྱཱུནཱཾ ཀརེཥུ པཏིཏེ ཏེ ཏསྱ ཝསྟྲཱདིཀཾ ཧྲྀཏཝནྟཿ ཏམཱཧཏྱ མྲྀཏཔྲཱཡཾ ཀྲྀཏྭཱ ཏྱཀྟྭཱ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ཨཀསྨཱད྄ ཨེཀོ ཡཱཛཀསྟེན མཱརྒེཎ གཙྪན྄ ཏཾ དྲྀཥྚྭཱ མཱརྒཱནྱཔཱརྴྭེན ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ཨིཏྠམ྄ ཨེཀོ ལེཝཱིཡསྟཏྶྠཱནཾ པྲཱཔྱ ཏསྱཱནྟིཀཾ གཏྭཱ ཏཾ ཝིལོཀྱཱནྱེན པཱརྴྭེན ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ཀིནྟྭེཀཿ ཤོམིརོཎཱིཡོ གཙྪན྄ ཏཏྶྠཱནཾ པྲཱཔྱ ཏཾ དྲྀཥྚྭཱདཡཏ། ");
INSERT INTO santib_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ཏསྱཱནྟིཀཾ གཏྭཱ ཏསྱ ཀྵཏེཥུ ཏཻལཾ དྲཱཀྵཱརསཉྩ པྲཀྵིཔྱ ཀྵཏཱནི བདྡྷྭཱ ནིཛཝཱཧནོཔརི ཏམུཔཝེཤྱ པྲཝཱསཱིཡགྲྀཧམ྄ ཨཱནཱིཡ ཏཾ སིཥེཝེ། ");
INSERT INTO santib_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","པརསྨིན྄ དིཝསེ ནིཛགམནཀཱལེ དྭཽ མུདྲཱཔཱདཽ ཏདྒྲྀཧསྭཱམིནེ དཏྟྭཱཝདཏ྄ ཛནམེནཾ སེཝསྭ ཏཏྲ ཡོ྅དྷིཀོ ཝྱཡོ བྷཝིཥྱཏི ཏམཧཾ པུནརཱགམནཀཱལེ པརིཤོཏྶྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ཨེཥཱཾ ཏྲཡཱཎཱཾ མདྷྱེ ཏསྱ དསྱུཧསྟཔཏིཏསྱ ཛནསྱ སམཱིཔཝཱསཱི ཀཿ? ཏྭཡཱ ཀིཾ བུདྷྱཏེ? ");
INSERT INTO santib_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ཏཏཿ ས ཝྱཝསྠཱཔཀཿ ཀཐཡཱམཱས ཡསྟསྨིན྄ དཡཱཾ ཙཀཱར། ཏདཱ ཡཱིཤུཿ ཀཐཡཱམཱས ཏྭམཔི གཏྭཱ ཏཐཱཙར། ");
INSERT INTO santib_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ཏཏཿ པརཾ ཏེ གཙྪནྟ ཨེཀཾ གྲཱམཾ པྲཝིཝིཤུཿ; ཏདཱ མརྠཱནཱམཱ སྟྲཱི སྭགྲྀཧེ ཏསྱཱཏིཐྱཾ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ཏསྨཱཏ྄ མརིཡམ྄ ནཱམདྷེཡཱ ཏསྱཱ བྷགིནཱི ཡཱིཤོཿ པདསམཱིཔ ཨུཝཝིཤྱ ཏསྱོཔདེཤཀཐཱཾ ཤྲོཏུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ཀིནྟུ མརྠཱ ནཱནཱཔརིཙཪྻྱཱཡཱཾ ཝྱགྲཱ བབྷཱུཝ ཏསྨཱདྡྷེཏོསྟསྱ སམཱིཔམཱགཏྱ བབྷཱཥེ; ཧེ པྲབྷོ མམ བྷགིནཱི ཀེཝལཾ མམོཔརི སཪྻྭཀརྨྨཎཱཾ བྷཱརམ྄ ཨརྤིཏཝཏཱི ཏཏྲ བྷཝཏཱ ཀིཉྩིདཔི ན མནོ ནིདྷཱིཡཏེ ཀིམ྄? མམ སཱཧཱཡྻཾ ཀརྟྟུཾ བྷཝཱན྄ ཏཱམཱདིཤཏུ། ");
INSERT INTO santib_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ཏཏོ ཡཱིཤུཿ པྲཏྱུཝཱཙ ཧེ མརྠེ ཧེ མརྠེ, ཏྭཾ ནཱནཱཀཱཪྻྱེཥུ ཙིནྟིཏཝཏཱི ཝྱགྲཱ ཙཱསི, ");
INSERT INTO santib_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ཀིནྟུ པྲཡོཛནཱིཡམ྄ ཨེཀམཱཏྲམ྄ ཨཱསྟེ། ཨཔརཉྩ ཡམུཏྟམཾ བྷཱགཾ ཀོཔི ཧརྟྟུཾ ན ཤཀྣོཏི སཨེཝ མརིཡམཱ ཝྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ཨནནྟརཾ ས ཀསྨིཾཤྩིཏ྄ སྠཱནེ པྲཱརྠཡཏ ཏཏྶམཱཔྟཽ སཏྱཱཾ ཏསྱཻཀཿ ཤིཥྱསྟཾ ཛགཱད ཧེ པྲབྷོ ཡོཧན྄ ཡཐཱ སྭཤིཥྱཱན྄ པྲཱརྠཡིཏུམ྄ ཨུཔདིཥྚཝཱན྄ ཏཐཱ བྷཝཱནཔྱསྨཱན྄ ཨུཔདིཤཏུ། ");
INSERT INTO santib_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ཏསྨཱཏ྄ ས ཀཐཡཱམཱས, པྲཱརྠནཀཱལེ ཡཱུཡམ྄ ཨིཏྠཾ ཀཐཡདྷྭཾ, ཧེ ཨསྨཱཀཾ སྭརྒསྠཔིཏསྟཝ ནཱམ པཱུཛྱཾ བྷཝཏུ; ཏཝ རཱཛཏྭཾ བྷཝཏུ; སྭརྒེ ཡཐཱ ཏཐཱ པྲྀཐིཝྱཱམཔི ཏཝེཙྪཡཱ སཪྻྭཾ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","པྲཏྱཧམ྄ ཨསྨཱཀཾ པྲཡོཛནཱིཡཾ བྷོཛྱཾ དེཧི། ");
INSERT INTO santib_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ཡཐཱ ཝཡཾ སཪྻྭཱན྄ ཨཔརཱདྷིནཿ ཀྵམཱམཧེ ཏཐཱ ཏྭམཔི པཱཔཱནྱསྨཱཀཾ ཀྵམསྭ། ཨསྨཱན྄ པརཱིཀྵཱཾ མཱནཡ ཀིནྟུ པཱཔཱཏྨནོ རཀྵ། ");
INSERT INTO santib_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","པཤྩཱཏ྄ སོཔརམཔི ཀཐིཏཝཱན྄ ཡདི ཡུཥྨཱཀཾ ཀསྱཙིད྄ བནྡྷུསྟིཥྛཏི ནིཤཱིཐེ ཙ ཏསྱ སམཱིཔཾ ས གཏྭཱ ཝདཏི, ");
INSERT INTO santib_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ཧེ བནྡྷོ པཐིཀ ཨེཀོ བནྡྷུ རྨམ ནིཝེཤནམ྄ ཨཱཡཱཏཿ ཀིནྟུ ཏསྱཱཏིཐྱཾ ཀརྟྟུཾ མམཱནྟིཀེ ཀིམཔི ནཱསྟི, ཨཏཨེཝ པཱུཔཏྲཡཾ མཧྱམ྄ ཨྲྀཎཾ དེཧི; ");
INSERT INTO santib_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ཏདཱ ས ཡདི གྲྀཧམདྷྱཱཏ྄ པྲཏིཝདཏི མཱཾ མཱ ཀླིཤཱན, ཨིདཱནཱིཾ དྭཱརཾ རུདྡྷཾ ཤཡནེ མཡཱ སཧ བཱལཀཱཤྩ ཏིཥྛནྟི ཏུབྷྱཾ དཱཏུམ྄ ཨུཏྠཱཏུཾ ན ཤཀྣོམི, ");
INSERT INTO santib_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ཏརྷི ཡུཥྨཱནཧཾ ཝདཱམི, ས ཡདི མིཏྲཏཡཱ ཏསྨཻ ཀིམཔི དཱཏུཾ ནོཏྟིཥྛཏི ཏཐཱཔི ཝཱརཾ ཝཱརཾ པྲཱརྠནཱཏ ཨུཏྠཱཔིཏཿ སན྄ ཡསྨིན྄ ཏསྱ པྲཡོཛནཾ ཏདེཝ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ཨཏཿ ཀཱརཎཱཏ྄ ཀཐཡཱམི, ཡཱཙདྷྭཾ ཏཏོ ཡུཥྨབྷྱཾ དཱསྱཏེ, མྲྀགཡདྷྭཾ ཏཏ ཨུདྡེཤཾ པྲཱཔྶྱཐ, དྭཱརམ྄ ཨཱཧཏ ཏཏོ ཡུཥྨབྷྱཾ དྭཱརཾ མོཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ཡོ ཡཱཙཏེ ས པྲཱཔྣོཏི, ཡོ མྲྀགཡཏེ ས ཨེཝོདྡེཤཾ པྲཱཔྣོཏི, ཡོ དྭཱརམ྄ ཨཱཧནྟི ཏདརྠཾ དྭཱརཾ མོཙྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","པུཏྲེཎ པཱུཔེ ཡཱཙིཏེ ཏསྨཻ པཱཥཱཎཾ དདཱཏི ཝཱ མཏྶྱེ ཡཱཙིཏེ ཏསྨཻ སརྤཾ དདཱཏི ");
INSERT INTO santib_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ཝཱ ཨཎྜེ ཡཱཙིཏེ ཏསྨཻ ཝྲྀཤྩིཀཾ དདཱཏི ཡུཥྨཱཀཾ མདྷྱེ ཀ ཨེཏཱདྲྀཤཿ པིཏཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ཏསྨཱདེཝ ཡཱུཡམབྷདྲཱ ཨཔི ཡདི སྭསྭབཱལཀེབྷྱ ཨུཏྟམཱནི དྲཝྱཱཎི དཱཏུཾ ཛཱནཱིཐ ཏརྷྱསྨཱཀཾ སྭརྒསྠཿ པིཏཱ ནིཛཡཱཙཀེབྷྱཿ ཀིཾ པཝིཏྲམ྄ ཨཱཏྨཱནཾ ན དཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ཨནནྟརཾ ཡཱིཤུནཱ ཀསྨཱཙྩིད྄ ཨེཀསྨིན྄ མཱུཀབྷཱུཏེ ཏྱཱཛིཏེ སཏི ས བྷཱུཏཏྱཀྟོ མཱནུཥོ ཝཱཀྱཾ ཝཀྟུམ྄ ཨཱརེབྷེ; ཏཏོ ལོཀཱཿ སཀལཱ ཨཱཤྩཪྻྱཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ཀིནྟུ ཏེཥཱཾ ཀེཙིདཱུཙུ རྫནོཡཾ བཱལསིབཱུབཱ ཨརྠཱད྄ བྷཱུཏརཱཛེན བྷཱུཏཱན྄ ཏྱཱཛཡཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ཏཾ པརཱིཀྵིཏུཾ ཀེཙིད྄ ཨཱཀཱཤཱིཡམ྄ ཨེཀཾ ཙིཧྣཾ དརྴཡིཏུཾ ཏཾ པྲཱརྠཡཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ཏདཱ ས ཏེཥཱཾ མནཿཀལྤནཱཾ ཛྙཱཏྭཱ ཀཐཡཱམཱས, ཀསྱཙིད྄ རཱཛྱསྱ ལོཀཱ ཡདི པརསྤརཾ ཝིརུནྡྷནྟི ཏརྷི ཏད྄ རཱཛྱམ྄ ནཤྱཏི; ཀེཙིད྄ གྲྀཧསྠཱ ཡདི པརསྤརཾ ཝིརུནྡྷནྟི ཏརྷི ཏེཔི ནཤྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ཏཐཻཝ ཤཻཏཱནཔི སྭལོཀཱན྄ ཡདི ཝིརུཎདྡྷི ཏདཱ ཏསྱ རཱཛྱཾ ཀཐཾ སྠཱསྱཏི? བཱལསིབཱུབཱཧཾ བྷཱུཏཱན྄ ཏྱཱཛཡཱམི ཡཱུཡམིཏི ཝདཐ། ");
INSERT INTO santib_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ཡདྱཧཾ བཱལསིབཱུབཱ བྷཱུཏཱན྄ ཏྱཱཛཡཱམི ཏརྷི ཡུཥྨཱཀཾ སནྟཱནཱཿ ཀེན ཏྱཱཛཡནྟི? ཏསྨཱཏ྄ ཏཨེཝ ཀཐཱཡཱ ཨེཏསྱཱ ཝིཙཱརཡིཏཱརོ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ཀིནྟུ ཡདྱཧམ྄ ཨཱིཤྭརསྱ པརཱཀྲམེཎ བྷཱུཏཱན྄ ཏྱཱཛཡཱམི ཏརྷི ཡུཥྨཱཀཾ ནིཀཊམ྄ ཨཱིཤྭརསྱ རཱཛྱམཝཤྱམ྄ ཨུཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","བལཝཱན྄ པུམཱན྄ སུསཛྫམཱནོ ཡཏིཀཱལཾ ནིཛཱཊྚཱལིཀཱཾ རཀྵཏི ཏཏིཀཱལཾ ཏསྱ དྲཝྱཾ ནིརུཔདྲཝཾ ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ཀིནྟུ ཏསྨཱད྄ ཨདྷིཀབལཿ ཀཤྩིདཱགཏྱ ཡདི ཏཾ ཛཡཏི ཏརྷི ཡེཥུ ཤསྟྲཱསྟྲེཥུ ཏསྱ ཝིཤྭཱས ཨཱསཱིཏ྄ ཏཱནི སཪྻྭཱཎི ཧྲྀཏྭཱ ཏསྱ དྲཝྱཱཎི གྲྀཧླཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ཨཏཿ ཀཱརཎཱད྄ ཡོ མམ སཔཀྵོ ན ས ཝིཔཀྵཿ, ཡོ མཡཱ སཧ ན སཾགྲྀཧླཱཏི ས ཝིཀིརཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ཨཔརཉྩ ཨམེདྷྱབྷཱུཏོ མཱནུཥསྱཱནྟརྣིརྒཏྱ ཤུཥྐསྠཱནེ བྷྲཱནྟྭཱ ཝིཤྲཱམཾ མྲྀགཡཏེ ཀིནྟུ ན པྲཱཔྱ ཝདཏི མམ ཡསྨཱད྄ གྲྀཧཱད྄ ཨཱགཏོཧཾ པུནསྟད྄ གྲྀཧཾ པརཱཝྲྀཏྱ ཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ཏཏོ གཏྭཱ ཏད྄ གྲྀཧཾ མཱརྫིཏཾ ཤོབྷིཏཉྩ དྲྀཥྚྭཱ ");
INSERT INTO santib_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ཏཏྐྵཎམ྄ ཨཔགཏྱ སྭསྨཱདཔི དུརྨྨཏཱིན྄ ཨཔརཱན྄ སཔྟབྷཱུཏཱན྄ སཧཱནཡཏི ཏེ ཙ ཏདྒྲྀཧཾ པཝིཤྱ ནིཝསནྟི། ཏསྨཱཏ྄ ཏསྱ མནུཥྱསྱ པྲཐམདཤཱཏཿ ཤེཥདཤཱ དུཿཁཏརཱ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ཨསྱཱཿ ཀཐཱཡཱཿ ཀཐནཀཱལེ ཛནཏཱམདྷྱསྠཱ ཀཱཙིནྣཱརཱི ཏམུཙྩཻཿསྭརཾ པྲོཝཱཙ, ཡཱ ཡོཥིཏ྄ ཏྭཱཾ གརྦྦྷེ྅དྷཱརཡཏ྄ སྟནྱམཔཱཡཡཙྩ སཻཝ དྷནྱཱ། ");
INSERT INTO santib_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ཀིནྟུ སོཀཐཡཏ྄ ཡེ པརམེཤྭརསྱ ཀཐཱཾ ཤྲུཏྭཱ ཏདནུརཱུཔམ྄ ཨཱཙརནྟི ཏཨེཝ དྷནྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ཏཏཿ པརཾ ཏསྱཱནྟིཀེ བཧུལོཀཱནཱཾ སམཱགམེ ཛཱཏེ ས ཝཀྟུམཱརེབྷེ, ཨཱདྷུནིཀཱ དུཥྚལོཀཱཤྩིཧྣཾ དྲཥྚུམིཙྪནྟི ཀིནྟུ ཡཱུནསྦྷཝིཥྱདྭཱདིནཤྩིཧྣཾ ཝིནཱནྱཏ྄ ཀིཉྩིཙྩིཧྣཾ ཏཱན྄ ན དརྴཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ཡཱུནས྄ ཏུ ཡཐཱ ནཱིནིཝཱིཡལོཀཱནཱཾ སམཱིཔེ ཙིཧྣརཱུཔོབྷཝཏ྄ ཏཐཱ ཝིདྱམཱནལོཀཱནཱམ྄ ཨེཥཱཾ སམཱིཔེ མནུཥྱཔུཏྲོཔི ཙིཧྣརཱུཔོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ཝིཙཱརསམཡེ ཨིདཱནཱིནྟནལོཀཱནཱཾ པྲཱཏིཀཱུལྱེན དཀྵིཎདེཤཱིཡཱ རཱཛྙཱི པྲོཏྠཱཡ ཏཱན྄ དོཥིཎཿ ཀརིཥྱཏི, ཡཏཿ སཱ རཱཛྙཱི སུལེམཱན ཨུཔདེཤཀཐཱཾ ཤྲོཏུཾ པྲྀཐིཝྱཱཿ སཱིམཱཏ ཨཱགཙྪཏ྄ ཀིནྟུ པཤྱཏ སུལེམཱནོཔི གུརུཏར ཨེཀོ ཛནོ྅སྨིན྄ སྠཱནེ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ཨཔརཉྩ ཝིཙཱརསམཡེ ནཱིནིཝཱིཡལོཀཱ ཨཔི ཝརྟྟམཱནཀཱལིཀཱནཱཾ ལོཀཱནཱཾ ཝཻཔརཱིཏྱེན པྲོཏྠཱཡ ཏཱན྄ དོཥིཎཿ ཀརིཥྱནྟི, ཡཏོ ཧེཏོསྟེ ཡཱུནསོ ཝཱཀྱཱཏ྄ ཙིཏྟཱནི པརིཝརྟྟཡཱམཱསུཿ ཀིནྟུ པཤྱཏ ཡཱུནསོཏིགུརུཏར ཨེཀོ ཛནོ྅སྨིན྄ སྠཱནེ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","པྲདཱིཔཾ པྲཛྭཱལྱ དྲོཎསྱཱདྷཿ ཀུཏྲཱཔི གུཔྟསྠཱནེ ཝཱ ཀོཔི ན སྠཱཔཡཏི ཀིནྟུ གྲྀཧཔྲཝེཤིབྷྱོ དཱིཔྟིཾ དཱཏཾ དཱིཔཱདྷཱརོཔཪྻྱེཝ སྠཱཔཡཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","དེཧསྱ པྲདཱིཔཤྩཀྵུསྟསྨཱདེཝ ཙཀྵུ ཪྻདི པྲསནྣཾ བྷཝཏི ཏརྷི ཏཝ སཪྻྭཤརཱིརཾ དཱིཔྟིམད྄ བྷཝིཥྱཏི ཀིནྟུ ཙཀྵུ ཪྻདི མལཱིམསཾ ཏིཥྛཏི ཏརྷི སཪྻྭཤརཱིརཾ སཱནྡྷཀཱརཾ སྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ཨསྨཱཏ྄ ཀཱརཎཱཏ྄ ཏཝཱནྟཿསྠཾ ཛྱོཏི ཪྻཐཱནྡྷཀཱརམཡཾ ན བྷཝཏི ཏདརྠེ སཱཝདྷཱནོ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ཡཏཿ ཤརཱིརསྱ ཀུཏྲཱཔྱཾཤེ སཱནྡྷཀཱརེ ན ཛཱཏེ སཪྻྭཾ ཡདི དཱིཔྟིམཏ྄ ཏིཥྛཏི ཏརྷི ཏུབྷྱཾ དཱིཔྟིདཱཡིཔྲོཛྫྭལན྄ པྲདཱིཔ ཨིཝ ཏཝ སཝཪྻཤརཱིརཾ དཱིཔྟིམད྄ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ཨེཏཏྐཐཱཡཱཿ ཀཐནཀཱལེ ཕིརུཤྱེཀོ བྷེཛནཱཡ ཏཾ ནིམནྟྲཡཱམཱས, ཏཏཿ ས གཏྭཱ བྷོཀྟུམ྄ ཨུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ཀིནྟུ བྷོཛནཱཏ྄ པཱུཪྻྭཾ ནཱམཱངྐྵཱིཏ྄ ཨེཏད྄ དྲྀཥྚྭཱ ས ཕིརུཤྱཱཤྩཪྻྱཾ མེནེ། ");
INSERT INTO santib_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ཏདཱ པྲབྷུསྟཾ པྲོཝཱཙ ཡཱུཡཾ ཕིརཱུཤིལོཀཱཿ པཱནཔཱཏྲཱཎཱཾ བྷོཛནཔཱཏྲཱཎཱཉྩ བཧིཿ པརིཥྐུརུཐ ཀིནྟུ ཡུཥྨཱཀམནྟ རྡཽརཱཏྨྱཻ རྡུཥྐྲིཡཱབྷིཤྩ པརིཔཱུརྞཾ ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ཧེ སཪྻྭེ ནིརྦོདྷཱ ཡོ བཧིཿ སསརྫ ས ཨེཝ ཀིམནྟ རྣ སསརྫ? ");
INSERT INTO santib_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ཏཏ ཨེཝ ཡུཥྨཱབྷིརནྟཿཀརཎཾ (ཨཱིཤྭརཱཡ) ནིཝེདྱཏཱཾ ཏསྨིན྄ ཀྲྀཏེ ཡུཥྨཱཀཾ སཪྻྭཱཎི ཤུཙིཏཱཾ ཡཱསྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ཀིནྟུ ཧནྟ ཕིརཱུཤིགཎཱ ཡཱུཡཾ ནྱཱཡམ྄ ཨཱིཤྭརེ པྲེམ ཙ པརིཏྱཛྱ པོདིནཱཡཱ ཨརུདཱདཱིནཱཾ སཪྻྭེཥཱཾ ཤཱཀཱནཱཉྩ དཤམཱཾཤཱན྄ དཏྠ ཀིནྟུ པྲཐམཾ པཱལཡིཏྭཱ ཤེཥསྱཱལངྒྷནཾ ཡུཥྨཱཀམ྄ ཨུཙིཏམཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ཧཱ ཧཱ ཕིརཱུཤིནོ ཡཱུཡཾ བྷཛནགེཧེ པྲོཙྩཱསནེ ཨཱཔཎེཥུ ཙ ནམསྐཱརེཥུ པྲཱིཡདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ཝཏ ཀཔཊིནོ྅དྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ ལོཀཱཡཏ྄ ཤྨཤཱནམ྄ ཨནུཔལབྷྱ ཏདུཔརི གཙྪནྟི ཡཱུཡམ྄ ཏཱདྲྀགཔྲཀཱཤིཏཤྨཤཱནཝཱད྄ བྷཝཐ། ");
INSERT INTO santib_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ཏདཱནཱིཾ ཝྱཝསྠཱཔཀཱནཱམ྄ ཨེཀཱ ཡཱིཤུམཝདཏ྄, ཧེ ཨུཔདེཤཀ ཝཱཀྱེནེདྲྀཤེནཱསྨཱསྭཔི དོཥམ྄ ཨཱརོཔཡསི། ");
INSERT INTO santib_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ཏཏཿ ས ཨུཝཱཙ, ཧཱ ཧཱ ཝྱཝསྠཱཔཀཱ ཡཱུཡམ྄ མཱནུཥཱཎཱམ྄ ཨུཔརི དུཿསཧྱཱན྄ བྷཱརཱན྄ ནྱསྱཐ ཀིནྟུ སྭཡམ྄ ཨེཀཱངྒུुལྱཱཔི ཏཱན྄ བྷཱརཱན྄ ན སྤྲྀཤཐ། ");
INSERT INTO santib_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ཧནྟ ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥཱ ཡཱན྄ བྷཝིཥྱདྭཱདིནོ྅ཝདྷིཥུསྟེཥཱཾ ཤྨཤཱནཱནི ཡཱུཡཾ ནིརྨྨཱཐ། ");
INSERT INTO santib_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ཏེནཻཝ ཡཱུཡཾ སྭཔཱུཪྻྭཔུརུཥཱཎཱཾ ཀརྨྨཱཎི སཾམནྱདྷྭེ ཏདེཝ སཔྲམཱཎཾ ཀུརུཐ ཙ, ཡཏསྟེ ཏཱནཝདྷིཥུཿ ཡཱུཡཾ ཏེཥཱཾ ཤྨཤཱནཱནི ནིརྨྨཱཐ། ");
INSERT INTO santib_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ཨཏཨེཝ ཨཱིཤྭརསྱ ཤཱསྟྲེ པྲོཀྟམསྟི ཏེཥཱམནྟིཀེ བྷཝིཥྱདྭཱདིནཿ པྲེརིཏཱཾཤྩ པྲེཥཡིཥྱཱམི ཏཏསྟེ ཏེཥཱཾ ཀཱཾཤྩན ཧནིཥྱནྟི ཀཱཾཤྩན ཏཱཌཤྵྱིནྟི། ");
INSERT INTO santib_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ཨེཏསྨཱཏ྄ ཀཱརཎཱཏ྄ ཧཱབིལཿ ཤོཎིཏཔཱཏམཱརབྷྱ མནྡིརཡཛྙཝེདྱོ རྨདྷྱེ ཧཏསྱ སིཁརིཡསྱ རཀྟཔཱཏཔཪྻྱནྟཾ ");
INSERT INTO santib_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ཛགཏཿ སྲྀཥྚིམཱརབྷྱ པྲྀཐིཝྱཱཾ བྷཝིཥྱདྭཱདིནཱཾ ཡཏིརཀྟཔཱཏཱ ཛཱཏཱསྟཏཱིནཱམ྄ ཨཔརཱདྷདཎྜཱ ཨེཥཱཾ ཝརྟྟམཱནལོཀཱནཱཾ བྷཝིཥྱནྟི, ཡུཥྨཱནཧཾ ནིཤྩིཏཾ ཝདཱམི སཪྻྭེ དཎྜཱ ཝཾཤསྱཱསྱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ཧཱ ཧཱ ཝྱཝསྠཔཀཱ ཡཱུཡཾ ཛྙཱནསྱ ཀུཉྩིཀཱཾ ཧྲྀཏྭཱ སྭཡཾ ན པྲཝིཥྚཱ ཡེ པྲཝེཥྚུཉྩ པྲཡཱསིནསྟཱནཔི པྲཝེཥྚུཾ ཝཱརིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ཨིཏྠཾ ཀཐཱཀཐནཱད྄ ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཤྩ སཏརྐཱཿ ");
INSERT INTO santib_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","སནྟསྟམཔཝདིཏུཾ ཏསྱ ཀཐཱཡཱ དོཥཾ དྷརྟྟམིཙྪནྟོ ནཱནཱཁྱཱནཀཐནཱཡ ཏཾ པྲཝརྟྟཡིཏུཾ ཀོཔཡིཏུཉྩ པྲཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ཏདཱནཱིཾ ལོཀཱཿ སཧསྲཾ སཧསྲམ྄ ཨཱགཏྱ སམུཔསྠིཏཱསྟཏ ཨེཀཻཀོ ྅ནྱེཥཱམུཔརི པཏིཏུམ྄ ཨུཔཙཀྲམེ; ཏདཱ ཡཱིཤུཿ ཤིཥྱཱན྄ བབྷཱཥེ, ཡཱུཡཾ ཕིརཱུཤིནཱཾ ཀིཎྭརཱུཔཀཱཔཊྱེ ཝིཤེཥེཎ སཱཝདྷཱནཱསྟིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ཡཏོ ཡནྣ པྲཀཱཤཡིཥྱཏེ ཏདཱཙྪནྣཾ ཝསྟུ ཀིམཔི ནཱསྟི; ཏཐཱ ཡནྣ ཛྙཱསྱཏེ ཏད྄ གུཔྟཾ ཝསྟུ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ཨནྡྷཀཱརེ ཏིཥྛནཏོ ཡཱཿ ཀཐཱ ཨཀཐཡཏ ཏཱཿ སཪྻྭཱཿ ཀཐཱ དཱིཔྟཽ ཤྲོཥྱནྟེ ནིརྫནེ ཀརྞེ ཙ ཡདཀཐཡཏ གྲྀཧཔྲྀཥྛཱཏ྄ ཏཏ྄ པྲཙཱརཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ཧེ བནྡྷཝོ ཡུཥྨཱནཧཾ ཝདཱམི, ཡེ ཤརཱིརསྱ ནཱཤཾ ཝིནཱ ཀིམཔྱཔརཾ ཀརྟྟུཾ ན ཤཀྲུཝནྟི ཏེབྷྱོ མཱ བྷཻཥྚ། ");
INSERT INTO santib_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ཏརྷི ཀསྨཱད྄ བྷེཏཝྱམ྄ ཨིཏྱཧཾ ཝདཱམི, ཡཿ ཤརཱིརཾ ནཱཤཡིཏྭཱ ནརཀཾ ནིཀྵེཔྟུཾ ཤཀྣོཏི ཏསྨཱདེཝ བྷཡཾ ཀུརུཏ, པུནརཔི ཝདཱམི ཏསྨཱདེཝ བྷཡཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","པཉྩ ཙཊཀཔཀྵིཎཿ ཀིཾ དྭཱབྷྱཱཾ ཏཱམྲཁཎྜཱབྷྱཱཾ ན ཝིཀྲཱིཡནྟེ? ཏཐཱཔཱིཤྭརསྟེཥཱམ྄ ཨེཀམཔི ན ཝིསྨརཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ཡུཥྨཱཀཾ ཤིརཿཀེཤཱ ཨཔི གཎིཏཱཿ སནྟི ཏསྨཱཏ྄ མཱ ཝིབྷཱིཏ བཧུཙཊཀཔཀྵིབྷྱོཔི ཡཱུཡཾ བཧུམཱུལྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ཨཔརཾ ཡུཥྨབྷྱཾ ཀཐཡཱམི ཡཿ ཀཤྩིན྄ མཱནུཥཱཎཱཾ སཱཀྵཱན྄ མཱཾ སྭཱིཀརོཏི མནུཥྱཔུཏྲ ཨཱིཤྭརདཱུཏཱནཱཾ སཱཀྵཱཏ྄ ཏཾ སྭཱིཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ཀིནྟུ ཡཿ ཀཤྩིནྨཱནུཥཱཎཱཾ སཱཀྵཱནྨཱམ྄ ཨསྭཱིཀརོཏི ཏམ྄ ཨཱིཤྭརསྱ དཱུཏཱནཱཾ སཱཀྵཱད྄ ཨཧམ྄ ཨསྭཱིཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ཨནྱཙྩ ཡཿ ཀཤྩིན྄ མནུཛསུཏསྱ ནིནྡཱབྷཱཝེན ཀཱཉྩིཏ྄ ཀཐཱཾ ཀཐཡཏི ཏསྱ ཏཏྤཱཔསྱ མོཙནཾ བྷཝིཥྱཏི ཀིནྟུ ཡདི ཀཤྩིཏ྄ པཝིཏྲམ྄ ཨཱཏྨཱནཾ ནིནྡཏི ཏརྷི ཏསྱ ཏཏྤཱཔསྱ མོཙནཾ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ཡདཱ ལོཀཱ ཡུཥྨཱན྄ བྷཛནགེཧཾ ཝིཙཱརཀརྟྲྀརཱཛྱཀརྟྲྀཎཱཾ སམྨུཁཉྩ ནེཥྱནྟི ཏདཱ ཀེན པྲཀཱརེཎ ཀིམུཏྟརཾ ཝདིཥྱཐ ཀིཾ ཀཐཡིཥྱཐ ཙེཏྱཏྲ མཱ ཙིནྟཡཏ; ");
INSERT INTO santib_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ཡཏོ ཡུཥྨཱབྷིཪྻད྄ ཡད྄ ཝཀྟཝྱཾ ཏཏ྄ ཏསྨིན྄ སམཡཨེཝ པཝིཏྲ ཨཱཏྨཱ ཡུཥྨཱན྄ ཤིཀྵཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ཏཏཿ པརཾ ཛནཏཱམདྷྱསྠཿ ཀཤྩིཛྫནསྟཾ ཛགཱད ཧེ གུརོ མཡཱ སཧ པཻཏྲྀཀཾ དྷནཾ ཝིབྷཀྟུཾ མམ བྷྲཱཏརམཱཛྙཱཔཡཏུ བྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ཀིནྟུ ས ཏམཝདཏ྄ ཧེ མནུཥྱ ཡུཝཡོ ཪྻིཙཱརཾ ཝིབྷཱགཉྩ ཀརྟྟུཾ མཱཾ ཀོ ནིཡུཀྟཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ཨནནྟརཾ ས ལོཀཱནཝདཏ྄ ལོབྷེ སཱཝདྷཱནཱཿ སཏརྐཱཤྩ ཏིཥྛཏ, ཡཏོ བཧུསམྤཏྟིཔྲཱཔྟྱཱ མནུཥྱསྱཱཡུ རྣ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","པཤྩཱད྄ དྲྀཥྚཱནྟཀཐཱམུཏྠཱཔྱ ཀཐཡཱམཱས, ཨེཀསྱ དྷནིནོ བྷཱུམཽ བཧཱུནི ཤསྱཱནི ཛཱཏཱནི། ");
INSERT INTO santib_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ཏཏཿ ས མནསཱ ཙིནྟཡིཏྭཱ ཀཐཡཱམྦབྷཱུཝ མམཻཏཱནི སམུཏྤནྣཱནི དྲཝྱཱཎི སྠཱཔཡིཏུཾ སྠཱནཾ ནཱསྟི ཀིཾ ཀརིཥྱཱམི? ");
INSERT INTO santib_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ཏཏོཝདད྄ ཨིཏྠཾ ཀརིཥྱཱམི, མམ སཪྻྭབྷཱཎྜཱགཱརཱཎི བྷངྐྟྭཱ བྲྀཧདྦྷཱཎྜཱགཱརཱཎི ནིརྨྨཱཡ ཏནྨདྷྱེ སཪྻྭཕལཱནི དྲཝྱཱཎི ཙ སྠཱཔཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ཨཔརཾ ནིཛམནོ ཝདིཥྱཱམི, ཧེ མནོ བཧུཝཏྶརཱརྠཾ ནཱནཱདྲཝྱཱཎི སཉྩིཏཱནི སནྟི ཝིཤྲཱམཾ ཀུརུ བྷུཀྟྭཱ པཱིཏྭཱ ཀཽཏུཀཉྩ ཀུརུ། ཀིནྟྭཱིཤྭརསྟམ྄ ཨཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","རེ ནིརྦོདྷ ཨདྱ རཱཏྲཽ ཏཝ པྲཱཎཱསྟྭཏྟོ ནེཥྱནྟེ ཏཏ ཨེཏཱནི ཡཱནི དྲཝྱཱཎི ཏྭཡཱསཱདིཏཱནི ཏཱནི ཀསྱ བྷཝིཥྱནྟི? ");
INSERT INTO santib_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ཨཏཨེཝ ཡཿ ཀཤྩིད྄ ཨཱིཤྭརསྱ སམཱིཔེ དྷནསཉྩཡམཀྲྀཏྭཱ ཀེཝལཾ སྭནིཀཊེ སཉྩཡཾ ཀརོཏི སོཔི ཏཱདྲྀཤཿ། ");
INSERT INTO santib_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ཨཐ ས ཤིཥྱེབྷྱཿ ཀཐཡཱམཱས, ཡུཥྨཱནཧཾ ཝདཱམི, ཀིཾ ཁཱདིཥྱཱམཿ? ཀིཾ པརིདྷཱསྱཱམཿ? ཨིཏྱུཀྟྭཱ ཛཱིཝནསྱ ཤརཱིརསྱ ཙཱརྠཾ ཙིནྟཱཾ མཱ ཀཱརྵྚ། ");
INSERT INTO santib_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","བྷཀྵྱཱཛྫཱིཝནཾ བྷཱུཥཎཱཙྪརཱིརཉྩ ཤྲེཥྛཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ཀཱཀཔཀྵིཎཱཾ ཀཱཪྻྱཾ ཝིཙཱརཡཏ, ཏེ ན ཝཔནྟི ཤསྱཱནི ཙ ན ཚིནྡནྟི, ཏེཥཱཾ བྷཱཎྜཱགཱརཱཎི ན སནྟི ཀོཥཱཤྩ ན སནྟི, ཏཐཱཔཱིཤྭརསྟེབྷྱོ བྷཀྵྱཱཎི དདཱཏི, ཡཱུཡཾ པཀྵིབྷྱཿ ཤྲེཥྛཏརཱ ན ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ཨཔརཉྩ བྷཱཝཡིཏྭཱ ནིཛཱཡུཥཿ ཀྵཎམཱཏྲཾ ཝརྡྡྷཡིཏུཾ ཤཀྣོཏི, ཨེཏཱདྲྀཤོ ལཱཀོ ཡུཥྨཱཀཾ མདྷྱེ ཀོསྟི? ");
INSERT INTO santib_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ཨཏཨེཝ ཀྵུདྲཾ ཀཱཪྻྱཾ སཱདྷཡིཏུམ྄ ཨསམརྠཱ ཡཱུཡམ྄ ཨནྱསྨིན྄ ཀཱཪྻྱེ ཀུཏོ བྷཱཝཡཐ? ");
INSERT INTO santib_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ཨནྱཙྩ ཀཱམྤིལཔུཥྤཾ ཀཐཾ ཝརྡྡྷཏེ ཏདཱཔི ཝིཙཱརཡཏ, ཏཏ྄ ཀཉྩན ཤྲམཾ ན ཀརོཏི ཏནྟཱུཾཤྩ ན ཛནཡཏི ཀིནྟུ ཡུཥྨབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི སུལེམཱན྄ བཧྭཻཤྭཪྻྱཱནྭིཏོཔི པུཥྤསྱཱསྱ སདྲྀཤོ ཝིབྷཱུཥིཏོ ནཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ཨདྱ ཀྵེཏྲེ ཝརྟྟམཱནཾ ཤྭཤྩཱུལླྱཱཾ ཀྵེཔྶྱམཱནཾ ཡཏ྄ ཏྲྀཎཾ, ཏསྨཻ ཡདཱིཤྭར ཨིཏྠཾ བྷཱུཥཡཏི ཏརྷི ཧེ ཨལྤཔྲཏྱཡིནོ ཡུཥྨཱན ཀིཾ ན པརིདྷཱཔཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ཨཏཨེཝ ཀིཾ ཁཱདིཥྱཱམཿ? ཀིཾ པརིདྷཱསྱཱམཿ? ཨེཏདརྠཾ མཱ ཙེཥྚདྷྭཾ མཱ སཾདིགྡྷྭཉྩ། ");
INSERT INTO santib_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ཛགཏོ དེཝཱརྩྩཀཱ ཨེཏཱནི སཪྻྭཱཎི ཙེཥྚནཏེ; ཨེཥུ ཝསྟུཥུ ཡུཥྨཱཀཾ པྲཡོཛནམཱསྟེ ཨིཏི ཡུཥྨཱཀཾ པིཏཱ ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ཨཏཨེཝེཤྭརསྱ རཱཛྱཱརྠཾ སཙེཥྚཱ བྷཝཏ ཏཐཱ ཀྲྀཏེ སཪྻྭཱཎྱེཏཱནི དྲཝྱཱཎི ཡུཥྨབྷྱཾ པྲདཱཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ཧེ ཀྵུདྲམེཥཝྲཛ ཡཱུཡཾ མཱ བྷཻཥྚ ཡུཥྨབྷྱཾ རཱཛྱཾ དཱཏུཾ ཡུཥྨཱཀཾ པིཏུཿ སམྨཏིརསྟི། ");
INSERT INTO santib_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ཨཏཨེཝ ཡུཥྨཱཀཾ ཡཱ ཡཱ སམྤཏྟིརསྟི ཏཱཾ ཏཱཾ ཝིཀྲཱིཡ ཝིཏརཏ, ཡཏ྄ སྠཱནཾ ཙཽརཱ ནཱགཙྪནྟི, ཀཱིཊཱཤྩ ན ཀྵཱཡཡནྟི ཏཱདྲྀཤེ སྭརྒེ ནིཛཱརྠམ྄ ཨཛརེ སམྤུཊཀེ ྅ཀྵཡཾ དྷནཾ སཉྩིནུཏ ཙ; ");
INSERT INTO santib_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ཡཏོ ཡཏྲ ཡུཥྨཱཀཾ དྷནཾ ཝརྟྟཏེ ཏཏྲེཝ ཡུཥྨཱཀཾ མནཿ། ");
INSERT INTO santib_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ཨཔརཉྩ ཡཱུཡཾ པྲདཱིཔཾ ཛྭཱལཡིཏྭཱ བདྡྷཀཊཡསྟིཥྛཏ; ");
INSERT INTO santib_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","པྲབྷུ ཪྻིཝཱཧཱདཱགཏྱ ཡདཻཝ དྭཱརམཱཧནྟི ཏདཻཝ དྭཱརཾ མོཙཡིཏུཾ ཡཐཱ བྷྲྀཏྱཱ ཨཔེཀྵྱ ཏིཥྛནྟི ཏཐཱ ཡཱུཡམཔི ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ཡཏཿ པྲབྷུརཱགཏྱ ཡཱན྄ དཱསཱན྄ སཙེཏནཱན྄ ཏིཥྛཏོ དྲཀྵྱཏི ཏཨེཝ དྷནྱཱཿ; ཨཧཾ ཡུཥྨཱན྄ ཡཐཱརྠཾ ཝདཱམི པྲབྷུསྟཱན྄ བྷོཛནཱརྠམ྄ ཨུཔཝེཤྱ སྭཡཾ བདྡྷཀཊིཿ སམཱིཔམེཏྱ པརིཝེཥཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ཡདི དྭིཏཱིཡེ ཏྲྀཏཱིཡེ ཝཱ པྲཧརེ སམཱགཏྱ ཏཐཻཝ པཤྱཏི, ཏརྷི ཏཨེཝ དཱསཱ དྷནྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ཨཔརཉྩ ཀསྨིན྄ ཀྵཎེ ཙཽརཱ ཨཱགམིཥྱནྟི ཨིཏི ཡདི གྲྀཧཔཏི རྫྙཱཏུཾ ཤཀྣོཏི ཏདཱཝཤྱཾ ཛཱགྲན྄ ནིཛགྲྀཧེ སནྡྷིཾ ཀརྟྟཡིཏུཾ ཝཱརཡཏི ཡཱུཡམེཏད྄ ཝིཏྟ། ");
INSERT INTO santib_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ཨཏཨེཝ ཡཱུཡམཔི སཛྫམཱནཱསྟིཥྛཏ ཡཏོ ཡསྨིན྄ ཀྵཎེ ཏཾ ནཱཔྲེཀྵདྷྭེ ཏསྨིནྣེཝ ཀྵཎེ མནུཥྱཔུཏྲ ཨཱགམིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ཏདཱ པིཏརཿ པཔྲཙྪ, ཧེ པྲབྷོ བྷཝཱན྄ ཀིམསྨཱན྄ ཨུདྡིཤྱ ཀིཾ སཪྻྭཱན྄ ཨུདྡིཤྱ དྲྀཥྚཱནྟཀཐཱམིམཱཾ ཝདཏི? ");
INSERT INTO santib_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ཏཏཿ པྲབྷུཿ པྲོཝཱཙ, པྲབྷུཿ སམུཙིཏཀཱལེ ནིཛཔརིཝཱརཱརྠཾ བྷོཛྱཔརིཝེཥཎཱཡ ཡཾ ཏཏྤདེ ནིཡོཀྵྱཏི ཏཱདྲྀཤོ ཝིཤྭཱསྱོ བོདྡྷཱ ཀརྨྨཱདྷཱིཤཿ ཀོསྟི? ");
INSERT INTO santib_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","པྲབྷུརཱགཏྱ ཡམ྄ ཨེཏཱདྲྀཤེ ཀརྨྨཎི པྲཝྲྀཏྟཾ དྲཀྵྱཏི སཨེཝ དཱསོ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ཨཧཾ ཡུཥྨཱན྄ ཡཐཱརྠཾ ཝདཱམི ས ཏཾ ནིཛསཪྻྭསྭསྱཱདྷིཔཏིཾ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ཀིནྟུ པྲབྷུཪྻིལམྦེནཱགམིཥྱཏི, ཨིཏི ཝིཙིནྟྱ ས དཱསོ ཡདི ཏདནྱདཱསཱིདཱསཱན྄ པྲཧརྟྟུམ྄ བྷོཀྟུཾ པཱཏུཾ མདིཏུཉྩ པྲཱརབྷཏེ, ");
INSERT INTO santib_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ཏརྷི ཡདཱ པྲབྷུཾ ནཱཔེཀྵིཥྱཏེ ཡསྨིན྄ ཀྵཎེ སོ྅ཙེཏནཤྩ སྠཱསྱཏི ཏསྨིནྣེཝ ཀྵཎེ ཏསྱ པྲབྷུརཱགཏྱ ཏཾ པདབྷྲཥྚཾ ཀྲྀཏྭཱ ཝིཤྭཱསཧཱིནཻཿ སཧ ཏསྱ ཨཾཤཾ ནིརཱུཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ཡོ དཱསཿ པྲབྷེाརཱཛྙཱཾ ཛྙཱཏྭཱཔི སཛྫིཏོ ན ཏིཥྛཏི ཏདཱཛྙཱནུསཱརེཎ ཙ ཀཱཪྻྱཾ ན ཀརོཏི སོནེཀཱན྄ པྲཧཱརཱན྄ པྲཱཔྶྱཏི; ");
INSERT INTO santib_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ཀིནྟུ ཡོ ཛནོ྅ཛྙཱཏྭཱ པྲཧཱརཱརྷཾ ཀརྨྨ ཀརོཏི སོལྤཔྲཧཱརཱན྄ པྲཱཔྶྱཏི། ཡཏོ ཡསྨཻ བཱཧུལྱེན དཏྟཾ ཏསྨཱདེཝ བཱཧུལྱེན གྲཧཱིཥྱཏེ, མཱནུཥཱ ཡསྱ ནིཀཊེ བཧུ སམརྤཡནྟི ཏསྨཱད྄ བཧུ ཡཱཙནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ཨཧཾ པྲྀཐིཝྱཱམ྄ ཨནཻཀྱརཱུཔཾ ཝཧྣི ནིཀྵེཔྟུམ྄ ཨཱགཏོསྨི, ས ཙེད྄ ཨིདཱནཱིམེཝ པྲཛྭལཏི ཏཏྲ མམ ཀཱ ཙིནྟཱ? ");
INSERT INTO santib_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ཀིནྟུ ཡེན མཛྫནེནཱཧཾ མགྣོ བྷཝིཥྱཱམི ཡཱཝཏྐཱལཾ ཏསྱ སིདྡྷི རྣ བྷཝིཥྱཏི ཏཱཝདཧཾ ཀཏིཀཥྚཾ པྲཱཔྶྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","མེལནཾ ཀརྟྟུཾ ཛགད྄ ཨཱགཏོསྨི ཡཱུཡཾ ཀིམིཏྠཾ བོདྷདྷྭེ? ཡུཥྨཱན྄ ཝདཱམི ན ཏཐཱ, ཀིནྟྭཧཾ མེལནཱབྷཱཝཾ ཀརྟྟུཾམ྄ ཨཱགཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ཡསྨཱདེཏཏྐཱལམཱརབྷྱ ཨེཀཏྲསྠཔརིཛནཱནཱཾ མདྷྱེ པཉྩཛནཱཿ པྲྀཐག྄ བྷཱུཏྭཱ ཏྲཡོ ཛནཱ དྭཡོརྫནཡོཿ པྲཏིཀཱུལཱ དྭཽ ཛནཽ ཙ ཏྲཡཱཎཱཾ ཛནཱནཱཾ པྲཏིཀཱུལཽ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","པིཏཱ པུཏྲསྱ ཝིཔཀྵཿ པུཏྲཤྩ པིཏུ ཪྻིཔཀྵོ བྷཝིཥྱཏི མཱཏཱ ཀནྱཱཡཱ ཝིཔཀྵཱ ཀནྱཱ ཙ མཱཏུ ཪྻིཔཀྵཱ བྷཝིཥྱཏི, ཏཐཱ ཤྭཤྲཱུརྦདྷྭཱ ཝིཔཀྵཱ བདྷཱུཤྩ ཤྭཤྲྭཱ ཝིཔཀྵཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ས ལོཀེབྷྱོཔརམཔི ཀཐཡཱམཱས, པཤྩིམདིཤི མེགྷོདྒམཾ དྲྀཥྚྭཱ ཡཱུཡཾ ཧཋཱད྄ ཝདཐ ཝྲྀཥྚི རྦྷཝིཥྱཏི ཏཏསྟཐཻཝ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ཨཔརཾ དཀྵིཎཏོ ཝཱཡཽ ཝཱཏི སཏི ཝདཐ ནིདཱགྷོ བྷཝིཥྱཏི ཏཏཿ སོཔི ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","རེ རེ ཀཔཊིན ཨཱཀཱཤསྱ བྷཱུམྱཱཤྩ ལཀྵཎཾ བོདྡྷུཾ ཤཀྣུཐ, ");
INSERT INTO santib_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ཀིནྟུ ཀཱལསྱཱསྱ ལཀྵཎཾ ཀུཏོ བོདྡྷུཾ ན ཤཀྣུཐ? ཡཱུཡཉྩ སྭཡཾ ཀུཏོ ན ནྱཱཥྱཾ ཝིཙཱརཡཐ? ");
INSERT INTO santib_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ཨཔརཉྩ ཝིཝཱདིནཱ སཱརྡྡྷཾ ཝིཙཱརཡིཏུཿ སམཱིཔཾ གཙྪན྄ པཐི ཏསྨཱདུདྡྷཱརཾ པྲཱཔྟུཾ ཡཏསྭ ནོཙེཏ྄ ས ཏྭཱཾ དྷྲྀཏྭཱ ཝིཙཱརཡིཏུཿ སམཱིཔཾ ནཡཏི། ཝིཙཱརཡིཏཱ ཡདི ཏྭཱཾ པྲཧརྟྟུཿ སམཱིཔཾ སམརྤཡཏི པྲཧརྟྟཱ ཏྭཱཾ ཀཱརཱཡཱཾ བདྷྣཱཏི ");
INSERT INTO santib_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ཏརྷི ཏྭཱམཧཾ ཝདཱམི ཏྭཡཱ ནིཿཤེཥཾ ཀཔརྡཀེཥུ ན པརིཤོདྷིཏེཥུ ཏྭཾ ཏཏོ མུཀྟིཾ པྲཱཔྟུཾ ན ཤཀྵྱསི། ");
INSERT INTO santib_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ཨཔརཉྩ པཱིལཱཏོ ཡེཥཱཾ གཱལཱིལཱིཡཱནཱཾ རཀྟཱནི བལཱིནཱཾ རཀྟཻཿ སཧཱམིཤྲཡཏ྄ ཏེཥཱཾ གཱལཱིལཱིཡཱནཱཾ ཝྲྀཏྟཱནྟཾ ཀཏིཔཡཛནཱ ཨུཔསྠཱཔྱ ཡཱིཤཝེ ཀཐཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ཏཏཿ ས པྲཏྱུཝཱཙ ཏེཥཱཾ ལོཀཱནཱམ྄ ཨེཏཱདྲྀཤཱི དུརྒཏི རྒྷཊིཏཱ ཏཏྐཱརཎཱད྄ ཡཱུཡཾ ཀིམནྱེབྷྱོ གཱལཱིལཱིཡེབྷྱོཔྱདྷིཀཔཱཔིནསྟཱན྄ བོདྷདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ཡུཥྨཱནཧཾ ཝདཱམི ཏཐཱ ན ཀིནྟུ མནཿསུ ན པརཱཝརྟྟིཏེཥུ ཡཱུཡམཔི ཏཐཱ ནཾཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ཨཔརཉྩ ཤཱིལོཧནཱམྣ ཨུཙྩགྲྀཧསྱ པཏནཱད྄ ཡེ྅ཥྚཱདཤཛནཱ མྲྀཏཱསྟེ ཡིརཱུཤཱལམི ནིཝཱསིསཪྻྭལོཀེབྷྱོ྅དྷིཀཱཔརཱདྷིནཿ ཀིཾ ཡཱུཡམིཏྱཾ བོདྷདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ཡུཥྨཱནཧཾ ཝདཱམི ཏཐཱ ན ཀིནྟུ མནཿསུ ན པརིཝརྟྟིཏེཥུ ཡཱུཡམཔི ཏཐཱ ནཾཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ཨནནྟརཾ ས ཨིམཱཾ དྲྀཥྚཱནྟཀཐཱམཀཐཡད྄ ཨེཀོ ཛནོ དྲཱཀྵཱཀྵེཏྲམདྷྱ ཨེཀམུཌུམྦརཝྲྀཀྵཾ རོཔིཏཝཱན྄། པཤྩཱཏ྄ ས ཨཱགཏྱ ཏསྨིན྄ ཕལཱནི གཝེཥཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ཀིནྟུ ཕལཱཔྲཱཔྟེཿ ཀཱརཎཱད྄ ཨུདྱཱནཀཱརཾ བྷྲྀཏྱཾ ཛགཱད, པཤྱ ཝཏྶརཏྲཡཾ ཡཱཝདཱགཏྱ ཨེཏསྨིནྣུཌུམྦརཏརཽ ཀྵལཱནྱནྭིཙྪཱམི, ཀིནྟུ ནཻཀམཔི པྲཔྣོམི ཏརུརཡཾ ཀུཏོ ཝྲྀཐཱ སྠཱནཾ ཝྱཱཔྱ ཏིཥྛཏི? ཨེནཾ ཚིནྡྷི། ");
INSERT INTO santib_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ཏཏོ བྷྲྀཏྱཿ པྲཏྱུཝཱཙ, ཧེ པྲབྷོ པུནཪྻརྵམེཀཾ སྠཱཏུམ྄ ཨཱདིཤ; ཨེཏསྱ མཱུལསྱ ཙཏུརྡིཀྵུ ཁནིཏྭཱཧམ྄ ཨཱལཝཱལཾ སྠཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ཏཏཿ ཕལིཏུཾ ཤཀྣོཏི ཡདི ན ཕལཏི ཏརྷི པཤྩཱཏ྄ ཚེཏྶྱསི། ");
INSERT INTO santib_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ཨཐ ཝིཤྲཱམཝཱརེ བྷཛནགེཧེ ཡཱིཤུརུཔདིཤཏི ");
INSERT INTO santib_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ཏསྨིཏ྄ སམཡེ བྷཱུཏགྲསྟཏྭཱཏ྄ ཀུབྫཱིབྷཱུཡཱཥྚཱདཤཝརྵཱཎི ཡཱཝཏ྄ ཀེནཱཔྱུཔཱཡེན ཨྲྀཛུ རྦྷཝིཏུཾ ན ཤཀྣོཏི ཡཱ དུརྦྦལཱ སྟྲཱི, ");
INSERT INTO santib_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ཏཱཾ ཏཏྲོཔསྠིཏཱཾ ཝིལོཀྱ ཡཱིཤུསྟཱམཱཧཱུཡ ཀཐིཏཝཱན྄ ཧེ ནཱརི ཏཝ དཽརྦྦལྱཱཏ྄ ཏྭཾ མུཀྟཱ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ཏཏཿ པརཾ ཏསྱཱ གཱཏྲེ ཧསྟཱརྤཎམཱཏྲཱཏ྄ སཱ ཨྲྀཛུརྦྷཱུཏྭེཤྭརསྱ དྷནྱཝཱདཾ ཀརྟྟུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ཀིནྟུ ཝིཤྲཱམཝཱརེ ཡཱིཤུནཱ ཏསྱཱཿ སྭཱསྠྱཀརཎཱད྄ བྷཛནགེཧསྱཱདྷིཔཏིཿ པྲཀུཔྱ ལོཀཱན྄ ཨུཝཱཙ, ཥཊྶུ དིནེཥུ ལོཀཻཿ ཀརྨྨ ཀརྟྟཝྱཾ ཏསྨཱདྡྷེཏོཿ སྭཱསྠྱཱརྠཾ ཏེཥུ དིནེཥུ ཨཱགཙྪཏ, ཝིཤྲཱམཝཱརེ མཱགཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ཏདཱ པབྷུཿ པྲཏྱུཝཱཙ རེ ཀཔཊིནོ ཡུཥྨཱཀམ྄ ཨེཀཻཀོ ཛནོ ཝིཤྲཱམཝཱརེ སྭཱིཡཾ སྭཱིཡཾ ཝྲྀཥབྷཾ གརྡབྷཾ ཝཱ བནྡྷནཱནྨོཙཡིཏྭཱ ཛལཾ པཱཡཡིཏུཾ ཀིཾ ན ནཡཏི? ");
INSERT INTO santib_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ཏརྷྱཱཥྚཱདཤཝཏྶརཱན྄ ཡཱཝཏ྄ ཤཻཏཱནཱ བདྡྷཱ ཨིབྲཱཧཱིམཿ སནྟཏིརིཡཾ ནཱརཱི ཀིཾ ཝིཤྲཱམཝཱརེ ན མོཙཡིཏཝྱཱ? ");
INSERT INTO santib_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ཨེཥུ ཝཱཀྱེཥུ ཀཐིཏེཥུ ཏསྱ ཝིཔཀྵཱཿ སལཛྫཱ ཛཱཏཱཿ ཀིནྟུ ཏེན ཀྲྀཏསཪྻྭམཧཱཀརྨྨཀཱརཎཱཏ྄ ལོཀནིཝཧཿ སཱནནྡོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ཨནནྟརཾ སོཝདད྄ ཨཱིཤྭརསྱ རཱཛྱཾ ཀསྱ སདྲྀཤཾ? ཀེན ཏདུཔམཱསྱཱམི? ");
INSERT INTO santib_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ཡཏ྄ སརྵཔབཱིཛཾ གྲྀཧཱིཏྭཱ ཀཤྩིཛྫན ཨུདྱཱན ཨུཔྟཝཱན྄ ཏད྄ བཱིཛམངྐུརིཏཾ སཏ྄ མཧཱཝྲྀཀྵོ྅ཛཱཡཏ, ཏཏསྟསྱ ཤཱཁཱསུ ཝིཧཱཡསཱིཡཝིཧགཱ ཨཱགཏྱ ནྱཱུཥུཿ, ཏདྲཱཛྱཾ ཏཱདྲྀཤེན སརྵཔབཱིཛེན ཏུལྱཾ། ");
INSERT INTO santib_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","པུནཿ ཀཐཡཱམཱས, ཨཱིཤྭརསྱ རཱཛྱཾ ཀསྱ སདྲྀཤཾ ཝདིཥྱཱམི? ཡཏ྄ ཀིཎྭཾ ཀཱཙིཏ྄ སྟྲཱི གྲྀཧཱིཏྭཱ དྲོཎཏྲཡཔརིམིཏགོདྷཱུམཙཱུརྞེཥུ སྠཱཔཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ཏཏཿ ཀྲམེཎ ཏཏ྄ སཪྻྭགོདྷཱུམཙཱུརྞཾ ཝྱཱཔྣོཏི, ཏསྱ ཀིཎྭསྱ ཏུལྱམ྄ ཨཱིཤྭརསྱ རཱཛྱཾ། ");
INSERT INTO santib_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ཏཏཿ ས ཡིརཱུཤཱལམྣགརཾ པྲཏི ཡཱཏྲཱཾ ཀྲྀཏྭཱ ནགརེ ནགརེ གྲཱམེ གྲཱམེ སམུཔདིཤན྄ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ཏདཱ ཀཤྩིཛྫནསྟཾ པཔྲཙྪ, ཧེ པྲབྷོ ཀིཾ ཀེཝལམ྄ ཨལྤེ ལོཀཱཿ པརིཏྲཱསྱནྟེ? ");
INSERT INTO santib_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ཏཏཿ ས ལོཀཱན྄ ཨུཝཱཙ, སཾཀཱིརྞདྭཱརེཎ པྲཝེཥྚུཾ ཡཏགྷྭཾ, ཡཏོཧཾ ཡུཥྨཱན྄ ཝདཱམི, བཧཝཿ པྲཝེཥྚུཾ ཙེཥྚིཥྱནྟེ ཀིནྟུ ན ཤཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","གྲྀཧཔཏིནོཏྠཱཡ དྭཱརེ རུདྡྷེ སཏི ཡདི ཡཱུཡཾ བཧིཿ སྠིཏྭཱ དྭཱརམཱཧཏྱ ཝདཐ, ཧེ པྲབྷོ ཧེ པྲབྷོ ཨསྨཏྐཱརཎཱད྄ དྭཱརཾ མོཙཡཏུ, ཏཏཿ ས ཨིཏི པྲཏིཝཀྵྱཏི, ཡཱུཡཾ ཀུཏྲཏྱཱ ལོཀཱ ཨིཏྱཧཾ ན ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ཏདཱ ཡཱུཡཾ ཝདིཥྱཐ, ཏཝ སཱཀྵཱད྄ ཝཡཾ བྷེाཛནཾ པཱནཉྩ ཀྲྀཏཝནྟཿ, ཏྭཉྩཱསྨཱཀཾ ནགརསྱ པཐི སམུཔདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ཀིནྟུ ས ཝཀྵྱཏི, ཡུཥྨཱནཧཾ ཝདཱམི, ཡཱུཡཾ ཀུཏྲཏྱཱ ལོཀཱ ཨིཏྱཧཾ ན ཛཱནཱམི; ཧེ དུརཱཙཱརིཎོ ཡཱུཡཾ མཏྟོ དཱུརཱིབྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ཏདཱ ཨིབྲཱཧཱིམཾ ཨིསྷཱཀཾ ཡཱཀཱུབཉྩ སཪྻྭབྷཝིཥྱདྭཱདིནཤྩ ཨཱིཤྭརསྱ རཱཛྱཾ པྲཱཔྟཱན྄ སྭཱཾཤྩ བཧིཥྐྲྀཏཱན྄ དྲྀཥྚྭཱ ཡཱུཡཾ རོདནཾ དནྟཻརྡནྟགྷརྵཎཉྩ ཀརིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ཨཔརཉྩ པཱུཪྻྭཔཤྩིམདཀྵིཎོཏྟརདིགྦྷྱོ ལོཀཱ ཨཱགཏྱ ཨཱིཤྭརསྱ རཱཛྱེ ནིཝཏྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","པཤྱཏེཏྠཾ ཤེཥཱིཡཱ ལོཀཱ ཨགྲཱ བྷཝིཥྱནྟི, ཨགྲཱིཡཱ ལོཀཱཤྩ ཤེཥཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ཨཔརཉྩ ཏསྨིན྄ དིནེ ཀིཡནྟཿ ཕིརཱུཤིན ཨཱགཏྱ ཡཱིཤུཾ པྲོཙུཿ, བཧིརྒཙྪ, སྠཱནཱདསྨཱཏ྄ པྲསྠཱནཾ ཀུརུ, ཧེརོད྄ ཏྭཱཾ ཛིགྷཱཾསཏི། ");
INSERT INTO santib_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ཏཏཿ ས པྲཏྱཝོཙཏ྄ པཤྱཏཱདྱ ཤྭཤྩ བྷཱུཏཱན྄ ཝིཧཱཔྱ རོགིཎོ྅རོགིཎཿ ཀྲྀཏྭཱ ཏྲྀཏཱིཡེཧྣི སེཏྶྱཱམི, ཀཐཱམེཏཱཾ ཡཱུཡམིཏྭཱ ཏཾ བྷཱུརིམཱཡཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ཏཏྲཱཔྱདྱ ཤྭཿ པརཤྭཤྩ མཡཱ གམནཱགམནེ ཀརྟྟཝྱེ, ཡཏོ ཧེཏོ ཪྻིརཱུཤཱལམོ བཧིཿ ཀུཏྲཱཔི ཀོཔི བྷཝིཥྱདྭཱདཱི ན གྷཱནིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ཧེ ཡིརཱུཤཱལམ྄ ཧེ ཡིརཱུཤཱལམ྄ ཏྭཾ བྷཝིཥྱདྭཱདིནོ ཧཾསི ཏཝཱནྟིཀེ པྲེརིཏཱན྄ པྲསྟརཻརྨཱརཡསི ཙ, ཡཐཱ ཀུཀྐུཊཱི ནིཛཔཀྵཱདྷཿ སྭཤཱཝཀཱན྄ སཾགྲྀཧླཱཏི, ཏཐཱཧམཔི ཏཝ ཤིཤཱུན྄ སཾགྲཧཱིཏུཾ ཀཏིཝཱརཱན྄ ཨཻཙྪཾ ཀིནྟུ ཏྭཾ ནཻཙྪཿ། ");
INSERT INTO santib_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","པཤྱཏ ཡུཥྨཱཀཾ ཝཱསསྠཱནཱནི པྲོཙྪིདྱམཱནཱནི པརིཏྱཀྟཱནི ཙ བྷཝིཥྱནྟི; ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཡཿ པྲབྷོ རྣཱམྣཱགཙྪཏི ས དྷནྱ ཨིཏི ཝཱཙཾ ཡཱཝཏྐཱལཾ ན ཝདིཥྱཐ, ཏཱཝཏྐཱལཾ ཡཱུཡཾ མཱཾ ན དྲཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ཨནནྟརཾ ཝིཤྲཱམཝཱརེ ཡཱིཤཽ པྲདྷཱནསྱ ཕིརཱུཤིནོ གྲྀཧེ བྷོཀྟུཾ གཏཝཏི ཏེ ཏཾ ཝཱིཀྵིཏུམ྄ ཨཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ཏདཱ ཛལོདརཱི ཏསྱ སམྨུཁེ སྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ཏཏཿ ས ཝྱཝསྠཱཔཀཱན྄ ཕིརཱུཤིནཤྩ པཔྲཙྪ, ཝིཤྲཱམཝཱརེ སྭཱསྠྱཾ ཀརྟྟཝྱཾ ན ཝཱ? ཏཏསྟེ ཀིམཔི ན པྲཏྱཱུཙུཿ། ");
INSERT INTO santib_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ཏདཱ ས ཏཾ རོགིཎཾ སྭསྠཾ ཀྲྀཏྭཱ ཝིསསརྫ; ");
INSERT INTO santib_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ཏཱནུཝཱཙ ཙ ཡུཥྨཱཀཾ ཀསྱཙིད྄ གརྡྡབྷོ ཝྲྀཥབྷོ ཝཱ ཙེད྄ གརྟྟེ པཏཏི ཏརྷི ཝིཤྲཱམཝཱརེ ཏཏྐྵཎཾ ས ཀིཾ ཏཾ ནོཏྠཱཔཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ཏཏསྟེ ཀཐཱཡཱ ཨེཏསྱཱཿ ཀིམཔི པྲཏིཝཀྟུཾ ན ཤེཀུཿ། ");
INSERT INTO santib_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ཨཔརཉྩ པྲདྷཱནསྠཱནམནོནཱིཏཏྭཀརཎཾ ཝིལོཀྱ ས ནིམནྟྲིཏཱན྄ ཨེཏདུཔདེཤཀཐཱཾ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ཏྭཾ ཝིཝཱཧཱདིབྷོཛྱེཥུ ནིམནྟྲིཏཿ སན྄ པྲདྷཱནསྠཱནེ མོཔཱཝེཀྵཱིཿ། ཏྭཏྟོ གཽརཝཱནྭིཏནིམནྟྲིཏཛན ཨཱཡཱཏེ ");
INSERT INTO santib_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ནིམནྟྲཡིཏཱགཏྱ མནུཥྱཱཡཻཏསྨཻ སྠཱནཾ དེཧཱིཏི ཝཱཀྱཾ ཙེད྄ ཝཀྵྱཏི ཏརྷི ཏྭཾ སངྐུཙིཏོ བྷཱུཏྭཱ སྠཱན ཨིཏརསྨིན྄ ཨུཔཝེཥྚུམ྄ ཨུདྱཾསྱསི། ");
INSERT INTO santib_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ཨསྨཱཏ྄ ཀཱརཎཱདེཝ ཏྭཾ ནིམནྟྲིཏོ གཏྭཱ྅པྲདྷཱནསྠཱན ཨུཔཝིཤ, ཏཏོ ནིམནྟྲཡིཏཱགཏྱ ཝདིཥྱཏི, ཧེ བནྡྷོ པྲོཙྩསྠཱནཾ གཏྭོཔཝིཤ, ཏཐཱ སཏི བྷོཛནོཔཝིཥྚཱནཱཾ སཀལཱནཱཾ སཱཀྵཱཏ྄ ཏྭཾ མཱནྱོ བྷཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ཡཿ ཀཤྩིཏ྄ སྭམུནྣམཡཏི ས ནམཡིཥྱཏེ, ཀིནྟུ ཡཿ ཀཤྩིཏ྄ སྭཾ ནམཡཏི ས ཨུནྣམཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ཏདཱ ས ནིམནྟྲཡིཏཱརཾ ཛནམཔི ཛགཱད, མདྷྱཱཧྣེ རཱཏྲཽ ཝཱ བྷོཛྱེ ཀྲྀཏེ ནིཛབནྡྷུགཎོ ཝཱ བྷྲཱཏྲྀृགཎོ ཝཱ ཛྙཱཏིགཎོ ཝཱ དྷནིགཎོ ཝཱ སམཱིཔཝཱསིགཎོ ཝཱ ཨེཏཱན྄ ན ནིམནྟྲཡ, ཏཐཱ ཀྲྀཏེ ཙེཏ྄ ཏེ ཏྭཱཾ ནིམནྟྲཡིཥྱནྟི, ཏརྷི པརིཤོདྷོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ཀིནྟུ ཡདཱ བྷེཛྱཾ ཀརོཥི ཏདཱ དརིདྲཤུཥྐཀརཁཉྫཱནྡྷཱན྄ ནིམནྟྲཡ, ");
INSERT INTO santib_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ཏཏ ཨཱཤིཥཾ ལཔྶྱསེ, ཏེཥུ པརིཤོདྷཾ ཀརྟྟུམཤཀྣུཝཏྶུ ཤྨཤཱནཱདྡྷཱརྨྨིཀཱནཱམུཏྠཱནཀཱལེ ཏྭཾ ཕལཱཾ ལཔྶྱསེ། ");
INSERT INTO santib_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ཨནནྟརཾ ཏཱཾ ཀཐཱཾ ནིཤམྱ བྷོཛནོཔཝིཥྚཿ ཀཤྩིཏ྄ ཀཐཡཱམཱས, ཡོ ཛན ཨཱིཤྭརསྱ རཱཛྱེ བྷོཀྟུཾ ལཔྶྱཏེ སཨེཝ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ཏཏཿ ས ཨུཝཱཙ, ཀཤྩིཏ྄ ཛནོ རཱཏྲཽ བྷེाཛྱཾ ཀྲྀཏྭཱ བཧཱུན྄ ནིམནྟྲཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ཏཏོ བྷོཛནསམཡེ ནིམནྟྲིཏལོཀཱན྄ ཨཱཧྭཱཏུཾ དཱསདྭཱརཱ ཀཐཡཱམཱས, ཁདྱདྲཝྱཱཎི སཪྻྭཱཎི སམཱསཱདིཏཱནི སནྟི, ཡཱུཡམཱགཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ཀིནྟུ ཏེ སཪྻྭ ཨེཀཻཀཾ ཚལཾ ཀྲྀཏྭཱ ཀྵམཱཾ པྲཱརྠཡཱཉྩཀྲིརེ། པྲཐམོ ཛནཿ ཀཐཡཱམཱས, ཀྵེཏྲམེཀཾ ཀྲཱིཏཝཱནཧཾ ཏདེཝ དྲཥྚུཾ མཡཱ གནྟཝྱམ྄, ཨཏཨེཝ མཱཾ ཀྵནྟུཾ ཏཾ ནིཝེདཡ། ");
INSERT INTO santib_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ཨནྱོ ཛནཿ ཀཐཡཱམཱས, དཤཝྲྀཥཱནཧཾ ཀྲཱིཏཝཱན྄ ཏཱན྄ པརཱིཀྵིཏུཾ ཡཱམི ཏསྨཱདེཝ མཱཾ ཀྵནྟུཾ ཏཾ ནིཝེདཡ། ");
INSERT INTO santib_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ཨཔརཿ ཀཐཡཱམཱས, ཝྱཱུཌྷཝཱནཧཾ ཏསྨཱཏ྄ ཀཱརཎཱད྄ ཡཱཏུཾ ན ཤཀྣོམི། ");
INSERT INTO santib_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","པཤྩཱཏ྄ ས དཱསོ གཏྭཱ ནིཛཔྲབྷོཿ སཱཀྵཱཏ྄ སཪྻྭཝྲྀཏྟཱནྟཾ ནིཝེདཡཱམཱས, ཏཏོསཽ གྲྀཧཔཏིཿ ཀུཔིཏྭཱ སྭདཱསཾ ཝྱཱཛཧཱར, ཏྭཾ སཏྭརཾ ནགརསྱ སནྣིཝེཤཱན྄ མཱརྒཱཾཤྩ གཏྭཱ དརིདྲཤུཥྐཀརཁཉྫཱནྡྷཱན྄ ཨཏྲཱནཡ། ");
INSERT INTO santib_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ཏཏོ དཱསོ྅ཝདཏ྄, ཧེ པྲབྷོ བྷཝཏ ཨཱཛྙཱནུསཱརེཎཱཀྲིཡཏ ཏཐཱཔི སྠཱནམསྟི། ");
INSERT INTO santib_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ཏདཱ པྲབྷུཿ པུན རྡཱསཱཡཱཀཐཡཏ྄, རཱཛཔཐཱན྄ ཝྲྀཀྵམཱུལཱནི ཙ ཡཱཏྭཱ མདཱིཡགྲྀཧཔཱུརཎཱརྠཾ ལོཀཱནཱགནྟུཾ པྲཝརྟྟཡ། ");
INSERT INTO santib_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ཨཧཾ ཡུཥྨབྷྱཾ ཀཐཡཱམི, པཱུཪྻྭནིམནྟྲིཏཱནམེཀོཔི མམཱསྱ རཱཏྲིབྷོཛྱསྱཱསྭཱདཾ ན པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ཨནནྟརཾ བཧུཥུ ལོཀེཥུ ཡཱིཤོཿ པཤྩཱད྄ ཝྲཛིཏེཥུ སཏྶུ ས ཝྱཱགྷུཊྱ ཏེབྷྱཿ ཀཐཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ཡཿ ཀཤྩིན྄ མམ སམཱིཔམ྄ ཨཱགཏྱ སྭསྱ མཱཏཱ པིཏཱ པཏྣཱི སནྟཱནཱ བྷྲཱཏརོ བྷགིམྱོ ནིཛཔྲཱཎཱཤྩ, ཨེཏེབྷྱཿ སཪྻྭེབྷྱོ མཡྻདྷིཀཾ པྲེམ ན ཀརོཏི, ས མམ ཤིཥྱོ བྷཝིཏུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ཡཿ ཀཤྩིཏ྄ སྭཱིཡཾ ཀྲུཤཾ ཝཧན྄ མམ པཤྩཱནྣ གཙྪཏི, སོཔི མམ ཤིཥྱོ བྷཝིཏུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","དུརྒནིརྨྨཱཎེ ཀཏིཝྱཡོ བྷཝིཥྱཏི, ཏཐཱ ཏསྱ སམཱཔྟིཀརཎཱརྠཾ སམྤཏྟིརསྟི ན ཝཱ, པྲཐམམུཔཝིཤྱ ཨེཏནྣ གཎཡཏི, ཡུཥྨཱཀཾ མདྷྱ ཨེཏཱདྲྀཤཿ ཀོསྟི? ");
INSERT INTO santib_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ནོཙེད྄ བྷིཏྟིཾ ཀྲྀཏྭཱ ཤེཥེ ཡདི སམཱཔཡིཏུཾ ན ཤཀྵྱཏི, ");
INSERT INTO santib_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ཏརྷི མཱནུཥོཡཾ ནིཙེཏུམ྄ ཨཱརབྷཏ སམཱཔཡིཏུཾ ནཱཤཀྣོཏ྄, ཨིཏི ཝྱཱཧྲྀཏྱ སཪྻྭེ ཏམུཔཧསིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ཨཔརཉྩ བྷིནྣབྷཱུཔཏིནཱ སཧ ཡུདྡྷཾ ཀརྟྟུམ྄ ཨུདྱམྱ དཤསཧསྲཱཎི སཻནྱཱནི གྲྀཧཱིཏྭཱ ཝིཾཤཏིསཧསྲེཿ སཻནྱཻཿ སཧིཏསྱ སམཱིཔཝཱསིནཿ སམྨུཁཾ ཡཱཏུཾ ཤཀྵྱཱམི ན ཝེཏི པྲཐམཾ ཨུཔཝིཤྱ ན ཝིཙཱརཡཏི ཨེཏཱདྲྀཤོ བྷཱུམིཔཏིཿ ཀཿ? ");
INSERT INTO santib_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ཡདི ན ཤཀྣོཏི ཏརྷི རིཔཱཝཏིདཱུརེ ཏིཥྛཏི སཏི ནིཛདཱུཏཾ པྲེཥྱ སནྡྷིཾ ཀརྟྟུཾ པྲཱརྠཡེཏ། ");
INSERT INTO santib_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ཏདྭད྄ ཡུཥྨཱཀཾ མདྷྱེ ཡཿ ཀཤྩིན྄ མདརྠཾ སཪྻྭསྭཾ ཧཱཏུཾ ན ཤཀྣོཏི ས མམ ཤིཥྱོ བྷཝིཏུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ལཝཎམ྄ ཨུཏྟམམ྄ ཨིཏི སཏྱཾ, ཀིནྟུ ཡདི ལཝཎསྱ ལཝཎཏྭམ྄ ཨཔགཙྪཏི ཏརྷི ཏཏ྄ ཀཐཾ སྭཱདུཡུཀྟཾ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ཏད བྷཱུམྱརྠམ྄ ཨཱལཝཱལརཱཤྱརྠམཔི བྷདྲཾ ན བྷཝཏི; ལོཀཱསྟད྄ བཧིཿ ཀྵིཔནྟི། ཡསྱ ཤྲོཏུཾ ཤྲོཏྲེ སྟཿ ས ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ཏདཱ ཀརསཉྩཱཡིནཿ པཱཔིནཤྩ ལོཀཱ ཨུཔདེཤྐཐཱཾ ཤྲོཏུཾ ཡཱིཤོཿ སམཱིཔམ྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ཏཏཿ ཕིརཱུཤིན ཨུཔཱདྷྱཱཡཱཤྩ ཝིཝདམཱནཱཿ ཀཐཡཱམཱསུཿ ཨེཥ མཱནུཥཿ པཱཔིབྷིཿ སཧ པྲཎཡཾ ཀྲྀཏྭཱ ཏཻཿ སཱརྡྡྷཾ བྷུཾཀྟེ། ");
INSERT INTO santib_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ཏདཱ ས ཏེབྷྱ ཨིམཱཾ དྲྀཥྚཱནྟཀཐཱཾ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ཀསྱཙིཏ྄ ཤཏམེཥེཥུ ཏིཥྛཏྨུ ཏེཥཱམེཀཾ ས ཡདི ཧཱརཡཏི ཏརྷི མདྷྱེཔྲཱནྟརམ྄ ཨེཀོནཤཏམེཥཱན྄ ཝིཧཱཡ ཧཱརིཏམེཥསྱ ཨུདྡེཤཔྲཱཔྟིཔཪྻྱནཏཾ ན གཝེཥཡཏི, ཨེཏཱདྲྀཤོ ལོཀོ ཡུཥྨཱཀཾ མདྷྱེ ཀ ཨཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ཏསྱོདྡེཤཾ པྲཱཔྱ ཧྲྀཥྚམནཱསྟཾ སྐནྡྷེ ནིདྷཱཡ སྭསྠཱནམ྄ ཨཱནཱིཡ བནྡྷུབཱནྡྷཝསམཱིཔཝཱསིན ཨཱཧཱུཡ ཝཀྟི, ");
INSERT INTO santib_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ཧཱརིཏཾ མེཥཾ པྲཱཔྟོཧམ྄ ཨཏོ ཧེཏོ རྨཡཱ སཱརྡྡྷམ྄ ཨཱནནྡཏ། ");
INSERT INTO santib_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ཏདྭདཧཾ ཡུཥྨཱན྄ ཝདཱམི, ཡེཥཱཾ མནཿཔརཱཝརྟྟནསྱ པྲཡོཛནཾ ནཱསྟི, ཏཱདྲྀཤཻཀོནཤཏདྷཱརྨྨིཀཀཱརཎཱད྄ ཡ ཨཱནནྡསྟསྨཱད྄ ཨེཀསྱ མནཿཔརིཝརྟྟིནཿ པཱཔིནཿ ཀཱརཎཱཏ྄ སྭརྒེ ྅དྷིཀཱནནྡོ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ཨཔརཉྩ དཤཱནཱཾ རཱུཔྱཁཎྜཱནཱམ྄ ཨེཀཁཎྜེ ཧཱརིཏེ པྲདཱིཔཾ པྲཛྭཱལྱ གྲྀཧཾ སམྨཱརྫྱ ཏསྱ པྲཱཔྟིཾ ཡཱཝད྄ ཡཏྣེན ན གཝེཥཡཏི, ཨེཏཱདྲྀཤཱི ཡོཥིཏ྄ ཀཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","པྲཱཔྟེ སཏི བནྡྷུབཱནྡྷཝསམཱིཔཝཱསིནཱིརཱཧཱུཡ ཀཐཡཏི, ཧཱརིཏཾ རཱུཔྱཁཎྜཾ པྲཱཔྟཱཧཾ ཏསྨཱདེཝ མཡཱ སཱརྡྡྷམ྄ ཨཱནནྡཏ། ");
INSERT INTO santib_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ཏདྭདཧཾ ཡུཥྨཱན྄ ཝྱཱཧརཱམི, ཨེཀེན པཱཔིནཱ མནསི པརིཝརྟྟིཏེ, ཨཱིཤྭརསྱ དཱུཏཱནཱཾ མདྷྱེཔྱཱནནྡོ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ཨཔརཉྩ ས ཀཐཡཱམཱས, ཀསྱཙིད྄ དྭཽ པུཏྲཱཝཱསྟཱཾ, ");
INSERT INTO santib_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ཏཡོཿ ཀནིཥྛཿ པུཏྲཿ པིཏྲེ ཀཐཡཱམཱས, ཧེ པིཏསྟཝ སམྤཏྟྱཱ ཡམཾཤཾ པྲཱཔྶྱཱམྱཧཾ ཝིབྷཛྱ ཏཾ དེཧི, ཏཏཿ པིཏཱ ནིཛཱཾ སམྤཏྟིཾ ཝིབྷཛྱ ཏཱབྷྱཱཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ཀཏིཔཡཱཏ྄ ཀཱལཱཏ྄ པརཾ ས ཀནིཥྛཔུཏྲཿ སམསྟཾ དྷནཾ སཾགྲྀཧྱ དཱུརདེཤཾ གཏྭཱ དུཥྚཱཙརཎེན སཪྻྭཱཾ སམྤཏྟིཾ ནཱཤཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ཏསྱ སཪྻྭདྷནེ ཝྱཡཾ གཏེ ཏདྡེཤེ མཧཱདུརྦྷིཀྵཾ བབྷཱུཝ, ཏཏསྟསྱ དཻནྱདཤཱ བྷཝིཏུམ྄ ཨཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ཏཏཿ པརཾ ས གཏྭཱ ཏདྡེཤཱིཡཾ གྲྀཧསྠམེཀམ྄ ཨཱཤྲཡཏ; ཏཏཿ སཏཾ ཤཱུཀརཝྲཛཾ ཙཱརཡིཏུཾ པྲཱནྟརཾ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ཀེནཱཔི ཏསྨཻ བྷཀྵྱཱདཱནཱཏ྄ ས ཤཱུཀརཕལཝལྐལེན པིཙིཎྜཔཱུརཎཱཾ ཝཝཱཉྪ། ");
INSERT INTO santib_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ཤེཥེ ས མནསི ཙེཏནཱཾ པྲཱཔྱ ཀཐཡཱམཱས, ཧཱ མམ པིཏུཿ སམཱིཔེ ཀཏི ཀཏི ཝེཏནབྷུཛོ དཱསཱ ཡཐེཥྚཾ ཏཏོདྷིཀཉྩ བྷཀྵྱཾ པྲཱཔྣུཝནྟི ཀིནྟྭཧཾ ཀྵུདྷཱ མུམཱུརྵུཿ། ");
INSERT INTO santib_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ཨཧམུཏྠཱཡ པིཏུཿ སམཱིཔཾ གཏྭཱ ཀཐཱམེཏཱཾ ཝདིཥྱཱམི, ཧེ པིཏར྄ ཨཱིཤྭརསྱ ཏཝ ཙ ཝིརུདྡྷཾ པཱཔམཀརཝམ྄ ");
INSERT INTO santib_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ཏཝ པུཏྲཨིཏི ཝིཁྱཱཏོ བྷཝིཏུཾ ན ཡོགྱོསྨི ཙ, མཱཾ ཏཝ ཝཻཏནིཀཾ དཱསཾ ཀྲྀཏྭཱ སྠཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","པཤྩཱཏ྄ ས ཨུཏྠཱཡ པིཏུཿ སམཱིཔཾ ཛགཱམ; ཏཏསྟསྱ པིཏཱཏིདཱུརེ ཏཾ ནིརཱིཀྵྱ དཡཱཉྩཀྲེ, དྷཱཝིཏྭཱ ཏསྱ ཀཎྛཾ གྲྀཧཱིཏྭཱ ཏཾ ཙུཙུམྦ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ཏདཱ པུཏྲ ཨུཝཱཙ, ཧེ པིཏར྄ ཨཱིཤྭརསྱ ཏཝ ཙ ཝིརུདྡྷཾ པཱཔམཀརཝཾ, ཏཝ པུཏྲཨིཏི ཝིཁྱཱཏོ བྷཝིཏུཾ ན ཡོགྱོསྨི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ཀིནྟུ ཏསྱ པིཏཱ ནིཛདཱསཱན྄ ཨཱདིདེཤ, སཪྻྭོཏྟམཝསྟྲཱཎྱཱནཱིཡ པརིདྷཱཔཡཏཻནཾ ཧསྟེ ཙཱངྒུརཱིཡཀམ྄ ཨརྤཡཏ པཱདཡོཤྩོཔཱནཧཽ སམརྤཡཏ; ");
INSERT INTO santib_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","པུཥྚཾ གོཝཏྶམ྄ ཨཱནཱིཡ མཱརཡཏ ཙ ཏཾ བྷུཀྟྭཱ ཝཡམ྄ ཨཱནནྡཱམ། ");
INSERT INTO santib_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ཡཏོ མམ པུཏྲོཡམ྄ ཨམྲིཡཏ པུནརཛཱིཝཱིད྄ ཧཱརིཏཤྩ ལབྡྷོབྷཱུཏ྄ ཏཏསྟ ཨཱནནྡིཏུམ྄ ཨཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ཏཏྐཱལེ ཏསྱ ཛྱེཥྛཿ པུཏྲཿ ཀྵེཏྲ ཨཱསཱིཏ྄། ཨཐ ས ནིཝེཤནསྱ ནིཀཊཾ ཨཱགཙྪན྄ ནྲྀཏྱཱནཱཾ ཝཱདྱཱནཱཉྩ ཤབྡཾ ཤྲུཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","དཱསཱནཱམ྄ ཨེཀམ྄ ཨཱཧཱུཡ པཔྲཙྪ, ཀིཾ ཀཱརཎམསྱ? ");
INSERT INTO santib_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ཏཏཿ སོཝཱདཱིཏ྄, ཏཝ བྷྲཱཏཱགམཏ྄, ཏཝ ཏཱཏཤྩ ཏཾ སུཤརཱིརཾ པྲཱཔྱ པུཥྚཾ གོཝཏྶཾ མཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ཏཏཿ ས པྲཀུཔྱ ནིཝེཤནཱནྟཿ པྲཝེཥྚུཾ ན སམྨེནེ; ཏཏསྟསྱ པིཏཱ བཧིརཱགཏྱ ཏཾ སཱདྷཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ཏཏཿ ས པིཏརཾ པྲཏྱུཝཱཙ, པཤྱ ཏཝ ཀཱཉྩིདཔྱཱཛྙཱཾ ན ཝིལཾགྷྱ བཧཱུན྄ ཝཏྶརཱན྄ ཨཧཾ ཏྭཱཾ སེཝེ ཏཐཱཔི མིཏྲཻཿ སཱརྡྡྷམ྄ ཨུཏྶཝཾ ཀརྟྟུཾ ཀདཱཔི ཚཱགམེཀམཔི མཧྱཾ ནཱདདཱཿ; ");
INSERT INTO santib_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ཀིནྟུ ཏཝ ཡཿ པུཏྲོ ཝེཤྱཱགམནཱདིབྷིསྟཝ སམྤཏྟིམ྄ ཨཔཝྱཡིཏཝཱན྄ ཏསྨིནྣཱགཏམཱཏྲེ ཏསྱཻཝ ནིམིཏྟཾ པུཥྚཾ གོཝཏྶཾ མཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ཏདཱ ཏསྱ པིཏཱཝོཙཏ྄, ཧེ པུཏྲ ཏྭཾ སཪྻྭདཱ མཡཱ སཧཱསི ཏསྨཱན྄ མམ ཡདྱདཱསྟེ ཏཏྶཪྻྭཾ ཏཝ། ");
INSERT INTO santib_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ཀིནྟུ ཏཝཱཡཾ བྷྲཱཏཱ མྲྀཏཿ པུནརཛཱིཝཱིད྄ ཧཱརིཏཤྩ བྷཱུཏྭཱ པྲཱཔྟོབྷཱུཏ྄, ཨེཏསྨཱཏ྄ ཀཱརཎཱད྄ ཨུཏྶཝཱནནྡཽ ཀརྟྟུམ྄ ཨུཙིཏམསྨཱཀམ྄། ");
INSERT INTO santib_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ཨཔརཉྩ ཡཱིཤུཿ ཤིཥྱེབྷྱོནྱཱམེཀཱཾ ཀཐཱཾ ཀཐཡཱམཱས ཀསྱཙིད྄ དྷནཝཏོ མནུཥྱསྱ གྲྀཧཀཱཪྻྱཱདྷཱིཤེ སམྤཏྟེརཔཝྱཡེ྅པཝཱདིཏེ སཏི ");
INSERT INTO santib_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ཏསྱ པྲབྷུསྟམ྄ ཨཱཧཱུཡ ཛགཱད, ཏྭཡི ཡཱམིམཱཾ ཀཐཱཾ ཤྲྀཎོམི སཱ ཀཱིདྲྀཤཱི? ཏྭཾ གྲྀཧཀཱཪྻྱཱདྷཱིཤཀརྨྨཎོ གཎནཱཾ དརྴཡ གྲྀཧཀཱཪྻྱཱདྷཱིཤཔདེ ཏྭཾ ན སྠཱསྱསི། ");
INSERT INTO santib_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ཏདཱ ས གྲྀཧཀཱཪྻྱཱདྷཱིཤོ མནསཱ ཙིནྟཡཱམཱས, པྲབྷུ ཪྻདི མཱཾ གྲྀཧཀཱཪྻྱཱདྷཱིཤཔདཱད྄ བྷྲཾཤཡཏི ཏརྷི ཀིཾ ཀརིཥྱེ྅ཧཾ? མྲྀདཾ ཁནིཏུཾ མམ ཤཀྟི རྣཱསྟི བྷིཀྵིཏུཉྩ ལཛྫིཥྱེ྅ཧཾ། ");
INSERT INTO santib_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ཨཏཨེཝ མཡི གྲྀཧཀཱཪྻྱཱདྷཱིཤཔདཱཏ྄ ཙྱུཏེ སཏི ཡཐཱ ལོཀཱ མཧྱམ྄ ཨཱཤྲཡཾ དཱསྱནྟི ཏདརྠཾ ཡཏྐརྨྨ མཡཱ ཀརཎཱིཡཾ ཏན྄ ནིརྞཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","པཤྩཱཏ྄ ས སྭཔྲབྷོརེཀཻཀམ྄ ཨདྷམརྞམ྄ ཨཱཧཱུཡ པྲཐམཾ པཔྲཙྪ, ཏྭཏྟོ མེ པྲབྷུཎཱ ཀཏི པྲཱཔྱམ྄? ");
INSERT INTO santib_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ཏཏཿ ས ཨུཝཱཙ, ཨེཀཤཏཱཌྷཀཏཻལཱནི; ཏདཱ གྲྀཧཀཱཪྻྱཱདྷཱིཤཿ པྲོཝཱཙ, ཏཝ པཏྲམཱནཱིཡ ཤཱིགྷྲམུཔཝིཤྱ ཏཏྲ པཉྩཱཤཏཾ ལིཁ། ");
INSERT INTO santib_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","པཤྩཱདནྱམེཀཾ པཔྲཙྪ, ཏྭཏྟོ མེ པྲབྷུཎཱ ཀཏི པྲཱཔྱམ྄? ཏཏཿ སོཝཱདཱིད྄ ཨེཀཤཏཱཌྷཀགོདྷཱུམཱཿ; ཏདཱ ས ཀཐཡཱམཱས, ཏཝ པཏྲམཱནཱིཡ ཨཤཱིཏིཾ ལིཁ། ");
INSERT INTO santib_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ཏེནཻཝ པྲབྷུསྟམཡཐཱརྠཀྲྀཏམ྄ ཨདྷཱིཤཾ ཏདྦུདྡྷིནཻཔུཎྱཱཏ྄ པྲཤཤཾས; ཨིཏྠཾ དཱིཔྟིརཱུཔསནྟཱནེབྷྱ ཨེཏཏྶཾསཱརསྱ སནྟཱནཱ ཝརྟྟམཱནཀཱལེ྅དྷིཀབུདྡྷིམནྟོ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ཨཏོ ཝདཱམི ཡཱུཡམཔྱཡཐཱརྠེན དྷནེན མིཏྲཱཎི ལབྷདྷྭཾ ཏཏོ ཡུཥྨཱསུ པདབྷྲཥྚེཥྭཔི ཏཱནི ཙིརཀཱལམ྄ ཨཱཤྲཡཾ དཱསྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ཡཿ ཀཤྩིཏ྄ ཀྵུདྲེ ཀཱཪྻྱེ ཝིཤྭཱསྱོ བྷཝཏི ས མཧཏི ཀཱཪྻྱེཔི ཝིཤྭཱསྱོ བྷཝཏི, ཀིནྟུ ཡཿ ཀཤྩིཏ྄ ཀྵུདྲེ ཀཱཪྻྱེ྅ཝིཤྭཱསྱོ བྷཝཏི ས མཧཏི ཀཱཪྻྱེཔྱཝིཤྭཱསྱོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ཨཏཨེཝ ཨཡཐཱརྠེན དྷནེན ཡདི ཡཱུཡམཝིཤྭཱསྱཱ ཛཱཏཱསྟརྷི སཏྱཾ དྷནཾ ཡུཥྨཱཀཾ ཀརེཥུ ཀཿ སམརྤཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ཡདི ཙ པརདྷནེན ཡཱུཡམ྄ ཨཝིཤྭཱསྱཱ བྷཝཐ ཏརྷི ཡུཥྨཱཀཾ སྭཀཱིཡདྷནཾ ཡུཥྨབྷྱཾ ཀོ དཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ཀོཔི དཱས ཨུབྷཽ པྲབྷཱུ སེཝིཏུཾ ན ཤཀྣོཏི, ཡཏ ཨེཀསྨིན྄ པྲཱིཡམཱཎོ྅ནྱསྨིནྣཔྲཱིཡཏེ ཡདྭཱ ཨེཀཾ ཛནཾ སམཱདྲྀཏྱ ཏདནྱཾ ཏུཙྪཱིཀརོཏི ཏདྭད྄ ཡཱུཡམཔི དྷནེཤྭརཽ སེཝིཏུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ཏདཻཏཱཿ སཪྻྭཱཿ ཀཐཱཿ ཤྲུཏྭཱ ལོབྷིཕིརཱུཤིནསྟམུཔཛཧསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ཏཏཿ ས ཨུཝཱཙ, ཡཱུཡཾ མནུཥྱཱཎཱཾ ནིཀཊེ སྭཱན྄ ནིརྡོཥཱན྄ དརྴཡཐ ཀིནྟུ ཡུཥྨཱཀམ྄ ཨནྟཿཀརཎཱནཱིཤྭརོ ཛཱནཱཏི, ཡཏ྄ མནུཥྱཱཎཱམ྄ ཨཏི པྲཤཾསྱཾ ཏད྄ ཨཱིཤྭརསྱ གྷྲྀཎྱཾ། ");
INSERT INTO santib_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ཡོཧན ཨཱགམནཔཪྻྱནཏཾ ཡུཥྨཱཀཾ སམཱིཔེ ཝྱཝསྠཱབྷཝིཥྱདྭཱདིནཱཾ ལེཁནཱནི ཙཱསན྄ ཏཏཿ པྲབྷྲྀཏི ཨཱིཤྭརརཱཛྱསྱ སུསཾཝཱདཿ པྲཙརཏི, ཨེཀཻཀོ ལོཀསྟནྨདྷྱཾ ཡཏྣེན པྲཝིཤཏི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ཝརཾ ནབྷསཿ པྲྀཐིཝྱཱཤྩ ལོཔོ བྷཝིཥྱཏི ཏཐཱཔི ཝྱཝསྠཱཡཱ ཨེཀབིནྡོརཔི ལོཔོ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ཡཿ ཀཤྩིཏ྄ སྭཱིཡཱཾ བྷཱཪྻྱཱཾ ཝིཧཱཡ སྟྲིཡམནྱཱཾ ཝིཝཧཏི ས པརདཱརཱན྄ གཙྪཏི, ཡཤྩ ཏཱ ཏྱཀྟཱཾ ནཱརཱིཾ ཝིཝཧཏི སོཔི པརདཱརཱན གཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ཨེཀོ དྷནཱི མནུཥྱཿ ཤུཀླཱནི སཱུཀྵྨཱཎི ཝསྟྲཱཎི པཪྻྱདདྷཱཏ྄ པྲཏིདིནཾ པརིཏོཥརཱུཔེཎཱབྷུཾཀྟཱཔིཝཙྩ། ");
INSERT INTO santib_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","སཪྻྭཱངྒེ ཀྵཏཡུཀྟ ཨིལིཡཱསརནཱམཱ ཀཤྩིད྄ དརིདྲསྟསྱ དྷནཝཏོ བྷོཛནཔཱཏྲཱཏ྄ པཏིཏམ྄ ཨུཙྪིཥྚཾ བྷོཀྟུཾ ཝཱཉྪན྄ ཏསྱ དྭཱརེ པཏིཏྭཱཏིཥྛཏ྄; ");
INSERT INTO santib_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ཨཐ ཤྭཱན ཨཱགཏྱ ཏསྱ ཀྵཏཱནྱལིཧན྄། ");
INSERT INTO santib_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ཀིཡཏྐཱལཱཏྤརཾ ས དརིདྲཿ པྲཱཎཱན྄ ཛཧཽ; ཏཏཿ སྭརྒཱིཡདཱུཏཱསྟཾ ནཱིཏྭཱ ཨིབྲཱཧཱིམཿ ཀྲོཌ ཨུཔཝེཤཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","པཤྩཱཏ྄ ས དྷནཝཱནཔི མམཱར, ཏཾ ཤྨཤཱནེ སྠཱཔཡཱམཱསུཤྩ; ཀིནྟུ པརལོཀེ ས ཝེདནཱཀུལཿ སན྄ ཨཱུརྡྡྷྭཱཾ ནིརཱིཀྵྱ བཧུདཱུརཱད྄ ཨིབྲཱཧཱིམཾ ཏཏྐྲོཌ ཨིལིཡཱསརཉྩ ཝིལོཀྱ རུཝནྣུཝཱཙ; ");
INSERT INTO santib_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ཧེ པིཏར྄ ཨིབྲཱཧཱིམ྄ ཨནུགྲྀཧྱ ཨངྒུལྱགྲབྷཱགཾ ཛལེ མཛྫཡིཏྭཱ མམ ཛིཧྭཱཾ ཤཱིཏལཱཾ ཀརྟྟུམ྄ ཨིལིཡཱསརཾ པྲེརཡ, ཡཏོ ཝཧྣིཤིཁཱཏོཧཾ ཝྱཐིཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ཏདཱ ཨིབྲཱཧཱིམ྄ བབྷཱཥེ, ཧེ པུཏྲ ཏྭཾ ཛཱིཝན྄ སམྤདཾ པྲཱཔྟཝཱན྄ ཨིལིཡཱསརསྟུ ཝིཔདཾ པྲཱཔྟཝཱན྄ ཨེཏཏ྄ སྨར, ཀིནྟུ སམྤྲཏི ཏསྱ སུཁཾ ཏཝ ཙ དུཿཁཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ཨཔརམཔི ཡུཥྨཱཀམ྄ ཨསྨཱཀཉྩ སྠཱནཡོ རྨདྷྱེ མཧདྭིཙྪེདོ྅སྟི ཏཏ ཨེཏཏྶྠཱནསྱ ལོཀཱསྟཏ྄ སྠཱནཾ ཡཱཏུཾ ཡདྭཱ ཏཏྶྠཱནསྱ ལོཀཱ ཨེཏཏ྄ སྠཱནམཱཡཱཏུཾ ན ཤཀྣུཝནྟི། ");
INSERT INTO santib_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ཏདཱ ས ཨུཀྟཝཱན྄, ཧེ པིཏསྟརྷི ཏྭཱཾ ནིཝེདཡཱམི མམ པིཏུ རྒེཧེ ཡེ མམ པཉྩ བྷྲཱཏརཿ སནྟི ");
INSERT INTO santib_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ཏེ ཡཐཻཏད྄ ཡཱཏནཱསྠཱནཾ ནཱཡཱསྱནྟི ཏཐཱ མནྟྲཎཱཾ དཱཏུཾ ཏེཥཱཾ སམཱིཔམ྄ ཨིལིཡཱསརཾ པྲེརཡ། ");
INSERT INTO santib_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ཏཏ ཨིབྲཱཧཱིམ྄ ཨུཝཱཙ, མཱུསཱབྷཝིཥྱདྭཱདིནཱཉྩ པུསྟཀཱནི ཏེཥཱཾ ནིཀཊེ སནྟི ཏེ ཏདྭཙནཱནི མནྱནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ཏདཱ ས ནིཝེདཡཱམཱས, ཧེ པིཏར྄ ཨིབྲཱཧཱིམ྄ ན ཏཐཱ, ཀིནྟུ ཡདི མྲྀཏལོཀཱནཱཾ ཀཤྩིཏ྄ ཏེཥཱཾ སམཱིཔཾ ཡཱཏི ཏརྷི ཏེ མནཱཾསི ཝྱཱགྷོཊཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ཏཏ ཨིབྲཱཧཱིམ྄ ཛགཱད, ཏེ ཡདི མཱུསཱབྷཝིཥྱདྭཱདིནཱཉྩ ཝཙནཱནི ན མནྱནྟེ ཏརྷི མྲྀཏལོཀཱནཱཾ ཀསྨིཾཤྩིད྄ ཨུཏྠིཏེཔི ཏེ ཏསྱ མནྟྲཎཱཾ ན མཾསྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ཨིཏཿ པརཾ ཡཱིཤུཿ ཤིཥྱཱན྄ ཨུཝཱཙ, ཝིགྷྣཻརཝཤྱམ྄ ཨཱགནྟཝྱཾ ཀིནྟུ ཝིགྷྣཱ ཡེན གྷཊིཥྱནྟེ ཏསྱ དུརྒཏི རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ཨེཏེཥཱཾ ཀྵུདྲཔྲཱཎིནཱམ྄ ཨེཀསྱཱཔི ཝིགྷྣཛནནཱཏ྄ ཀཎྛབདྡྷཔེཥཎཱིཀསྱ ཏསྱ སཱགརཱགཱདྷཛལེ མཛྫནཾ བྷདྲཾ། ");
INSERT INTO santib_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ཡཱུཡཾ སྭེཥུ སཱཝདྷཱནཱསྟིཥྛཏ; ཏཝ བྷྲཱཏཱ ཡདི ཏཝ ཀིཉྩིད྄ ཨཔརཱདྷྱཏི ཏརྷི ཏཾ ཏརྫཡ, ཏེན ཡདི མནཿ པརིཝརྟྟཡཏི ཏརྷི ཏཾ ཀྵམསྭ། ");
INSERT INTO santib_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","པུནརེཀདིནམདྷྱེ ཡདི ས ཏཝ སཔྟཀྲྀཏྭོ྅པརཱདྷྱཏི ཀིནྟུ སཔྟཀྲྀཏྭ ཨཱགཏྱ མནཿ པརིཝརྟྱ མཡཱཔརཱདྡྷམ྄ ཨིཏི ཝདཏི ཏརྷི ཏཾ ཀྵམསྭ། ");
INSERT INTO santib_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ཏདཱ པྲེརིཏཱཿ པྲབྷུམ྄ ཨཝདན྄ ཨསྨཱཀཾ ཝིཤྭཱསཾ ཝརྡྡྷཡ། ");
INSERT INTO santib_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","པྲབྷུརུཝཱཙ, ཡདི ཡུཥྨཱཀཾ སརྵཔཻཀཔྲམཱཎོ ཝིཤྭཱསོསྟི ཏརྷི ཏྭཾ སམཱུལམུཏྤཱཊིཏོ བྷཱུཏྭཱ སམུདྲེ རོཔིཏོ བྷཝ ཀཐཱཡཱམ྄ ཨེཏསྱཱམ྄ ཨེཏདུཌུམྦརཱཡ ཀཐིཏཱཡཱཾ ས ཡུཥྨཱཀམཱཛྙཱཝཧོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ཨཔརཾ སྭདཱསེ ཧལཾ ཝཱཧཡིཏྭཱ ཝཱ པཤཱུན྄ ཙཱརཡིཏྭཱ ཀྵེཏྲཱད྄ ཨཱགཏེ སཏི ཏཾ ཝདཏི, ཨེཧི བྷོཀྟུམུཔཝིཤ, ཡུཥྨཱཀམ྄ ཨེཏཱདྲྀཤཿ ཀོསྟི? ");
INSERT INTO santib_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ཝརཉྩ པཱུཪྻྭཾ མམ ཁཱདྱམཱསཱདྱ ཡཱཝད྄ བྷུཉྫེ པིཝཱམི ཙ ཏཱཝད྄ བདྡྷཀཊིཿ པརིཙར པཤྩཱཏ྄ ཏྭམཔི བྷོཀྵྱསེ པཱསྱསི ཙ ཀཐཱམཱིདྲྀཤཱིཾ ཀིཾ ན ཝཀྵྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ཏེན དཱསེན པྲབྷོརཱཛྙཱནུརཱུཔེ ཀརྨྨཎི ཀྲྀཏེ པྲབྷུཿ ཀིཾ ཏསྨིན྄ བཱདྷིཏོ ཛཱཏཿ? ནེཏྠཾ བུདྷྱཏེ མཡཱ། ");
INSERT INTO santib_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ཨིཏྠཾ ནིརཱུཔིཏེཥུ སཪྻྭཀརྨྨསུ ཀྲྀཏེཥུ སཏྨུ ཡཱུཡམཔཱིདཾ ཝཱཀྱཾ ཝདཐ, ཝཡམ྄ ཨནུཔཀཱརིཎོ དཱསཱ ཨསྨཱབྷིཪྻདྱཏྐརྟྟཝྱཾ ཏནྨཱཏྲམེཝ ཀྲྀཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ས ཡིརཱུཤཱལམི ཡཱཏྲཱཾ ཀུཪྻྭན྄ ཤོམིརོཎྒཱལཱིལྤྲདེཤམདྷྱེན གཙྪཏི, ");
INSERT INTO santib_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ཨེཏརྷི ཀུཏྲཙིད྄ གྲཱམེ པྲཝེཤམཱཏྲེ དཤཀུཥྛིནསྟཾ སཱཀྵཱཏ྄ ཀྲྀཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","དཱུརེ ཏིཥྛནཏ ཨུཙྩཻ ཪྻཀྟུམཱརེབྷིརེ, ཧེ པྲབྷོ ཡཱིཤོ དཡསྭཱསྨཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ཏཏཿ ས ཏཱན྄ དྲྀཥྚྭཱ ཛགཱད, ཡཱུཡཾ ཡཱཛཀཱནཱཾ སམཱིཔེ སྭཱན྄ དརྴཡཏ, ཏཏསྟེ གཙྪནྟོ རོགཱཏ྄ པརིཥྐྲྀཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ཏདཱ ཏེཥཱམེཀཿ སྭཾ སྭསྠཾ དྲྀཥྚྭཱ པྲོཙྩཻརཱིཤྭརཾ དྷནྱཾ ཝདན྄ ཝྱཱགྷུཊྱཱཡཱཏོ ཡཱིཤོ རྒུཎཱནནུཝདན྄ ཏཙྩརཎཱདྷོབྷཱུམཽ པཔཱཏ; ");
INSERT INTO santib_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ས ཙཱསཱིཏ྄ ཤོམིརོཎཱི། ");
INSERT INTO santib_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ཏདཱ ཡཱིཤུརཝདཏ྄, དཤཛནཱཿ ཀིཾ ན པརིཥྐྲྀཏཱཿ? ཏཧྱནྱེ ནཝཛནཱཿ ཀུཏྲ? ");
INSERT INTO santib_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ཨཱིཤྭརཾ དྷནྱཾ ཝདནྟམ྄ ཨེནཾ ཝིདེཤིནཾ ཝིནཱ ཀོཔྱནྱོ ན པྲཱཔྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ཏདཱ ས ཏམུཝཱཙ, ཏྭམུཏྠཱཡ ཡཱཧི ཝིཤྭཱསསྟེ ཏྭཱཾ སྭསྠཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ཨཐ ཀདེཤྭརསྱ རཱཛཏྭཾ བྷཝིཥྱཏཱིཏི ཕིརཱུཤིབྷིཿ པྲྀཥྚེ ས པྲཏྱུཝཱཙ, ཨཱིཤྭརསྱ རཱཛཏྭམ྄ ཨཻཤྭཪྻྱདརྴནེན ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ཨཏ ཨེཏསྨིན྄ པཤྱ ཏསྨིན྄ ཝཱ པཤྱ, ཨིཏི ཝཱཀྱཾ ལོཀཱ ཝཀྟུཾ ན ཤཀྵྱནྟི, ཨཱིཤྭརསྱ རཱཛཏྭཾ ཡུཥྨཱཀམ྄ ཨནྟརེཝཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ཏཏཿ ས ཤིཥྱཱན྄ ཛགཱད, ཡདཱ ཡུཥྨཱབྷི རྨནུཛསུཏསྱ དིནམེཀཾ དྲཥྚུམ྄ ཝཱཉྪིཥྱཏེ ཀིནྟུ ན དརྴིཥྱཏེ, ཨཱིདྲྀཀྐཱལ ཨཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ཏདཱཏྲ པཤྱ ཝཱ ཏཏྲ པཤྱེཏི ཝཱཀྱཾ ལོཀཱ ཝཀྵྱནྟི, ཀིནྟུ ཏེཥཱཾ པཤྩཱཏ྄ མཱ ཡཱཏ, མཱནུགཙྪཏ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ཡཏསྟཌིད྄ ཡཐཱཀཱཤཻཀདིཤྱུདིཡ ཏདནྱཱམཔི དིཤཾ ཝྱཱཔྱ པྲཀཱཤཏེ ཏདྭཏ྄ ནིཛདིནེ མནུཛསཱུནུཿ པྲཀཱཤིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ཀིནྟུ ཏཏྤཱུཪྻྭཾ ཏེནཱནེཀཱནི དུཿཁཱནི བྷོཀྟཝྱཱནྱེཏདྭརྟྟམཱནལོཀཻཤྩ སོ྅ཝཛྙཱཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ནོཧསྱ ཝིདྱམཱནཀཱལེ ཡཐཱབྷཝཏ྄ མནུཥྱསཱུནོཿ ཀཱལེཔི ཏཐཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ཡཱཝཏྐཱལཾ ནོཧོ མཧཱཔོཏཾ ནཱརོཧད྄ ཨཱཔླཱཝིཝཱཪྻྱེཏྱ སཪྻྭཾ ནཱནཱཤཡཙྩ ཏཱཝཏྐཱལཾ ཡཐཱ ལོཀཱ ཨབྷུཉྫཏཱཔིཝན྄ ཝྱཝཧན྄ ཝྱཝཱཧཡཾཤྩ; ");
INSERT INTO santib_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ཨིཏྠཾ ལོཊོ ཝརྟྟམཱནཀཱལེཔི ཡཐཱ ལོཀཱ བྷོཛནཔཱནཀྲཡཝིཀྲཡརོཔཎགྲྀཧནིརྨྨཱཎཀརྨྨསུ པྲཱཝརྟྟནྟ, ");
INSERT INTO santib_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ཀིནྟུ ཡདཱ ལོཊ྄ སིདོམོ ནིརྫགཱམ ཏདཱ ནབྷསཿ སགནྡྷཀཱགྣིཝྲྀཥྚི རྦྷཱུཏྭཱ སཪྻྭཾ ཝྱནཱཤཡཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ཏདྭན྄ མཱནཝཔུཏྲཔྲཀཱཤདིནེཔི བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ཏདཱ ཡདི ཀཤྩིད྄ གྲྀཧོཔརི ཏིཥྛཏི ཏརྷི ས གྲྀཧམདྷྱཱཏ྄ ཀིམཔི དྲཝྱམཱནེཏུམ྄ ཨཝརུཧྱ ནཻཏུ; ཡཤྩ ཀྵེཏྲེ ཏིཥྛཏི སོཔི ཝྱཱགྷུཊྱ ནཱཡཱཏུ། ");
INSERT INTO santib_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ལོཊཿ པཏྣཱིཾ སྨརཏ། ");
INSERT INTO santib_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ཡཿ པྲཱཎཱན྄ རཀྵིཏུཾ ཙེཥྚིཥྱཏེ ས པྲཱཎཱན྄ ཧཱརཡིཥྱཏི ཡསྟུ པྲཱཎཱན྄ ཧཱརཡིཥྱཏི སཨེཝ པྲཱཎཱན྄ རཀྵིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ཡུཥྨཱནཧཾ ཝཙྨི ཏསྱཱཾ རཱཏྲཽ ཤཡྻཻཀགཏཡོ རློཀཡོརེཀོ དྷཱརིཥྱཏེ པརསྟྱཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","སྟྲིཡཽ ཡུགཔཏ྄ པེཥཎཱིཾ ཝྱཱཝརྟྟཡིཥྱཏསྟཡོརེཀཱ དྷཱརིཥྱཏེ པརཱཏྱཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","པུརུཥཽ ཀྵེཏྲེ སྠཱསྱཏསྟཡོརེཀོ དྷཱརིཥྱཏེ པརསྟྱཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ཏདཱ ཏེ པཔྲཙྪུཿ, ཧེ པྲབྷོ ཀུཏྲེཏྠཾ བྷཝིཥྱཏི? ཏཏཿ ས ཨུཝཱཙ, ཡཏྲ ཤཝསྟིཥྛཏི ཏཏྲ གྲྀདྷྲཱ མིལནྟི། ");
INSERT INTO santib_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ཨཔརཉྩ ལོཀཻརཀླཱནྟཻ རྣིརནྟརཾ པྲཱརྠཡིཏཝྱམ྄ ཨིཏྱཱཤཡེན ཡཱིཤུནཱ དྲྀཥྚཱནྟ ཨེཀཿ ཀཐིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ཀུཏྲཙིནྣགརེ ཀཤྩིཏ྄ པྲཱཌྭིཝཱཀ ཨཱསཱིཏ྄ ས ཨཱིཤྭརཱནྣཱབིབྷེཏ྄ མཱནུཥཱཾཤྩ ནཱམནྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ཨཐ ཏཏྤུརཝཱསིནཱི ཀཱཙིདྭིདྷཝཱ ཏཏྶམཱིཔམེཏྱ ཝིཝཱདིནཱ སཧ མམ ཝིཝཱདཾ པརིཥྐུཪྻྭིཏི ནིཝེདཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ཏཏཿ ས པྲཱཌྭིཝཱཀཿ ཀིཡདྡིནཱནི ན ཏདངྒཱིཀྲྀཏཝཱན྄ པཤྩཱཙྩིཏྟེ ཙིནྟཡཱམཱས, ཡདྱཔཱིཤྭརཱནྣ བིབྷེམི མནུཥྱཱནཔི ན མནྱེ ");
INSERT INTO santib_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ཏཐཱཔྱེཥཱ ཝིདྷཝཱ མཱཾ ཀླིཤྣཱཏི ཏསྨཱདསྱཱ ཝིཝཱདཾ པརིཥྐརིཥྱཱམི ནོཙེཏ྄ སཱ སདཱགཏྱ མཱཾ ཝྱགྲཾ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","པཤྩཱཏ྄ པྲབྷུརཝདད྄ ཨསཱཝནྱཱཡཔྲཱཌྭིཝཱཀོ ཡདཱཧ ཏཏྲ མནོ ནིདྷདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ཨཱིཤྭརསྱ ཡེ ྅བྷིརུཙིཏལོཀཱ དིཝཱནིཤཾ པྲཱརྠཡནྟེ ས བཧུདིནཱནི ཝིལམྦྱཱཔི ཏེཥཱཾ ཝིཝཱདཱན྄ ཀིཾ ན པརིཥྐརིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ཡུཥྨཱནཧཾ ཝདཱམི ཏྭརཡཱ པརིཥྐརིཥྱཏི, ཀིནྟུ ཡདཱ མནུཥྱཔུཏྲ ཨཱགམིཥྱཏི ཏདཱ པྲྀཐིཝྱཱཾ ཀིམཱིདྲྀཤཾ ཝིཤྭཱསཾ པྲཱཔྶྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ཡེ སྭཱན྄ དྷཱརྨྨིཀཱན྄ ཛྙཱཏྭཱ པརཱན྄ ཏུཙྪཱིཀུཪྻྭནྟི ཨེཏཱདྲྀགྦྷྱཿ, ཀིཡདྦྷྱ ཨིམཾ དྲྀཥྚཱནྟཾ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ཨེཀཿ ཕིརཱུཤྱཔརཿ ཀརསཉྩཱཡཱི དྭཱཝིམཽ པྲཱརྠཡིཏུཾ མནྡིརཾ གཏཽ། ");
INSERT INTO santib_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ཏཏོ྅སཽ ཕིརཱུཤྱེཀཔཱརྴྭེ ཏིཥྛན྄ ཧེ ཨཱིཤྭར ཨཧམནྱལོཀཝཏ྄ ལོཋཡིཏཱནྱཱཡཱི པཱརདཱརིཀཤྩ ན བྷཝཱམི ཨསྱ ཀརསཉྩཱཡིནསྟུལྱཤྩ ན, ཏསྨཱཏྟྭཱཾ དྷནྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","སཔྟསུ དིནེཥུ དིནདྭཡམུཔཝསཱམི སཪྻྭསམྤཏྟེ རྡཤམཱཾཤཾ དདཱམི ཙ, ཨེཏཏྐཐཱཾ ཀཐཡན྄ པྲཱརྠཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ཀིནྟུ ས ཀརསཉྩཱཡི དཱུརེ ཏིཥྛན྄ སྭརྒཾ དྲཥྚུཾ ནེཙྪན྄ ཝཀྵསི ཀརཱགྷཱཏཾ ཀུཪྻྭན྄ ཧེ ཨཱིཤྭར པཱཔིཥྛཾ མཱཾ དཡསྭ, ཨིཏྠཾ པྲཱརྠཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ཡུཥྨཱནཧཾ ཝདཱམི, ཏཡོརྡྭཡོ རྨདྷྱེ ཀེཝལཿ ཀརསཉྩཱཡཱི པུཎྱཝཏྟྭེན གཎིཏོ ནིཛགྲྀཧཾ ཛགཱམ, ཡཏོ ཡཿ ཀཤྩིཏ྄ སྭམུནྣམཡཏི ས ནཱམཡིཥྱཏེ ཀིནྟུ ཡཿ ཀཤྩིཏ྄ སྭཾ ནམཡཏི ས ཨུནྣམཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ཨཐ ཤིཤཱུནཱཾ གཱཏྲསྤརྴཱརྠཾ ལོཀཱསྟཱན྄ ཏསྱ སམཱིཔམཱནིནྱུཿ ཤིཥྱཱསྟད྄ དྲྀཥྚྭཱནེཏྲྀན྄ ཏརྫཡཱམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ཀིནྟུ ཡཱིཤུསྟཱནཱཧཱུཡ ཛགཱད, མནྣིཀཊམ྄ ཨཱགནྟུཾ ཤིཤཱུན྄ ཨནུཛཱནཱིདྷྭཾ ཏཱཾཤྩ མཱ ཝཱརཡཏ; ཡཏ ཨཱིཤྭརརཱཛྱཱདྷིཀཱརིཎ ཨེཥཱཾ སདྲྀཤཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ཨཧཾ ཡུཥྨཱན྄ ཡཐཱརྠཾ ཝདཱམི, ཡོ ཛནཿ ཤིཤོཿ སདྲྀཤོ བྷཱུཏྭཱ ཨཱིཤྭརརཱཛྱཾ ན གྲྀཧླཱཏི ས ཀེནཱཔི པྲཀཱརེཎ ཏཏ྄ པྲཝེཥྚུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ཨཔརམ྄ ཨེཀོདྷིཔཏིསྟཾ པཔྲཙྪ, ཧེ པརམགུརོ, ཨནནྟཱཡུཥཿ པྲཱཔྟཡེ མཡཱ ཀིཾ ཀརྟྟཝྱཾ? ");
INSERT INTO santib_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ཡཱིཤུརུཝཱཙ, མཱཾ ཀུཏཿ པརམཾ ཝདསི? ཨཱིཤྭརཾ ཝིནཱ ཀོཔི པརམོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","པརདཱརཱན྄ མཱ གཙྪ, ནརཾ མཱ ཛཧི, མཱ ཙོརཡ, མིཐྱཱསཱཀྵྱཾ མཱ དེཧི, མཱཏརཾ པིཏརཉྩ སཾམནྱསྭ, ཨེཏཱ ཡཱ ཨཱཛྙཱཿ སནྟི ཏཱསྟྭཾ ཛཱནཱསི། ");
INSERT INTO santib_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ཏདཱ ས ཨུཝཱཙ, བཱལྱཀཱལཱཏ྄ སཪྻྭཱ ཨེཏཱ ཨཱཙརཱམི། ");
INSERT INTO santib_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ཨིཏི ཀཐཱཾ ཤྲུཏྭཱ ཡཱིཤུསྟམཝདཏ྄, ཏཐཱཔི ཏཝཻཀཾ ཀརྨྨ ནྱཱུནམཱསྟེ, ནིཛཾ སཪྻྭསྭཾ ཝིཀྲཱིཡ དརིདྲེབྷྱོ ཝིཏར, ཏསྨཱཏ྄ སྭརྒེ དྷནཾ པྲཱཔྶྱསི; ཏཏ ཨཱགཏྱ མམཱནུགཱམཱི བྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ཀིནྟྭེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ སོདྷིཔཏིཿ ཤུཤོཙ, ཡཏསྟསྱ བཧུདྷནམཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ཏདཱ ཡཱིཤུསྟམཏིཤོཀཱནྭིཏཾ དྲྀཥྚྭཱ ཛགཱད, དྷནཝཏཱམ྄ ཨཱིཤྭརརཱཛྱཔྲཝེཤཿ ཀཱིདྲྀག྄ དུཥྐརཿ། ");
INSERT INTO santib_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ཨཱིཤྭརརཱཛྱེ དྷནིནཿ པྲཝེཤཱཏ྄ སཱུཙེཤྪིདྲེཎ མཧཱངྒསྱ གམནཱགམནེ སུཀརེ། ");
INSERT INTO santib_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ཤྲོཏཱརཿ པཔྲཙྪུསྟརྷི ཀེན པརིཏྲཱཎཾ པྲཱཔྶྱཏེ? ");
INSERT INTO santib_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ས ཨུཀྟཝཱན྄, ཡན྄ མཱནུཥེཎཱཤཀྱཾ ཏད྄ ཨཱིཤྭརེཎ ཤཀྱཾ། ");
INSERT INTO santib_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ཏདཱ པིཏར ཨུཝཱཙ, པཤྱ ཝཡཾ སཪྻྭསྭཾ པརིཏྱཛྱ ཏཝ པཤྩཱདྒཱམིནོ྅བྷཝཱམ། ");
INSERT INTO santib_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ཏཏཿ ས ཨུཝཱཙ, ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཨཱིཤྭརརཱཛྱཱརྠཾ གྲྀཧཾ པིཏརཽ བྷྲཱཏྲྀགཎཾ ཛཱཡཱཾ སནྟཱནཱཾཤྩ ཏྱཀྟཝཱ ");
INSERT INTO santib_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ཨིཧ ཀཱལེ ཏཏོ྅དྷིཀཾ པརཀཱལེ ྅ནནྟཱཡུཤྩ ན པྲཱཔྶྱཏི ལོཀ ཨཱིདྲྀཤཿ ཀོཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ཨནནྟརཾ ས དྭཱདཤཤིཥྱཱནཱཧཱུཡ བབྷཱཥེ, པཤྱཏ ཝཡཾ ཡིརཱུཤཱལམྣགརཾ ཡཱམཿ, ཏསྨཱཏ྄ མནུཥྱཔུཏྲེ བྷཝིཥྱདྭཱདིབྷིརུཀྟཾ ཡདསྟི ཏདནུརཱུཔཾ ཏཾ པྲཏི གྷཊིཥྱཏེ; ");
INSERT INTO santib_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ཝསྟུཏསྟུ སོ྅ནྱདེཤཱིཡཱནཱཾ ཧསྟེཥུ སམརྤཡིཥྱཏེ, ཏེ ཏམུཔཧསིཥྱནྟི, ཨནྱཱཡམཱཙརིཥྱནྟི ཏདྭཔུཥི ནིཥྛཱིཝཾ ནིཀྵེཔྶྱནྟི, ཀཤཱབྷིཿ པྲཧྲྀཏྱ ཏཾ ཧནིཥྱནྟི ཙ, ");
INSERT INTO santib_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ཀིནྟུ ཏྲྀཏཱིཡདིནེ ས ཤྨཤཱནཱད྄ ཨུཏྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ཨེཏསྱཱཿ ཀཐཱཡཱ ཨབྷིཔྲཱཡཾ ཀིཉྩིདཔི ཏེ བོདྡྷུཾ ན ཤེཀུཿ ཏེཥཱཾ ནིཀཊེ྅སྤཥྚཏཝཱཏ྄ ཏསྱཻཏཱསཱཾ ཀཐཱནཱམ྄ ཨཱཤཡཾ ཏེ ཛྙཱཏུཾ ན ཤེཀུཤྩ། ");
INSERT INTO santib_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ཨཐ ཏསྨིན྄ ཡིརཱིཧོཿ པུརསྱཱནྟིཀཾ པྲཱཔྟེ ཀཤྩིདནྡྷཿ པཐཿ པཱརྴྭ ཨུཔཝིཤྱ བྷིཀྵཱམ྄ ཨཀརོཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ས ལོཀསམཱུཧསྱ གམནཤབྡཾ ཤྲུཏྭཱ ཏཏྐཱརཎཾ པྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ནཱསརཏཱིཡཡཱིཤུཪྻཱཏཱིཏི ལོཀཻརུཀྟེ ས ཨུཙྩཻཪྻཀྟུམཱརེབྷེ, ");
INSERT INTO santib_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ཧེ དཱཡཱུདཿ སནྟཱན ཡཱིཤོ མཱཾ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ཏཏོགྲགཱམིནསྟཾ མཽནཱི ཏིཥྛེཏི ཏརྫཡཱམཱསུཿ ཀིནྟུ ས པུནཱརུཝན྄ ཨུཝཱཙ, ཧེ དཱཡཱུདཿ སནྟཱན མཱཾ དཡསྭ། ");
INSERT INTO santib_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ཏདཱ ཡཱིཤུཿ སྠགིཏོ བྷཱུཏྭཱ སྭཱནྟིཀེ ཏམཱནེཏུམ྄ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ཏཏཿ ས ཏསྱཱནྟིཀམ྄ ཨཱགམཏ྄, ཏདཱ ས ཏཾ པཔྲཙྪ, ཏྭཾ ཀིམིཙྪསི? ཏྭདརྠམཧཾ ཀིཾ ཀརིཥྱཱམི? ས ཨུཀྟཝཱན྄, ཧེ པྲབྷོ྅ཧཾ དྲཥྚུཾ ལབྷཻ། ");
INSERT INTO santib_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ཏདཱ ཡཱིཤུརུཝཱཙ, དྲྀཥྚིཤཀྟིཾ གྲྀཧཱཎ ཏཝ པྲཏྱཡསྟྭཱཾ སྭསྠཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ཏཏསྟཏྐྵཎཱཏ྄ ཏསྱ ཙཀྵུཥཱི པྲསནྣེ; ཏསྨཱཏ྄ ས ཨཱིཤྭརཾ དྷནྱཾ ཝདན྄ ཏཏྤཤྩཱད྄ ཡཡཽ, ཏདཱལོཀྱ སཪྻྭེ ལོཀཱ ཨཱིཤྭརཾ པྲཤཾསིཏུམ྄ ཨཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ཡདཱ ཡཱིཤུ ཪྻིརཱིཧོཔུརཾ པྲཝིཤྱ ཏནྨདྷྱེན གཙྪཾསྟདཱ ");
INSERT INTO santib_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","སཀྐེཡནཱམཱ ཀརསཉྩཱཡིནཱཾ པྲདྷཱནོ དྷནཝཱནེཀོ ");
INSERT INTO santib_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ཡཱིཤུཿ ཀཱིདྲྀགིཏི དྲཥྚུཾ ཙེཥྚིཏཝཱན྄ ཀིནྟུ ཁཪྻྭཏྭཱལློཀསཾགྷམདྷྱེ ཏདྡརྴནམཔྲཱཔྱ ");
INSERT INTO santib_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ཡེན པཐཱ ས ཡཱསྱཏི ཏཏྤཐེ྅གྲེ དྷཱཝིཏྭཱ ཏཾ དྲཥྚུམ྄ ཨུཌུམྦརཏརུམཱརུརོཧ། ");
INSERT INTO santib_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","པཤྩཱད྄ ཡཱིཤུསྟཏྶྠཱནམ྄ ཨིཏྭཱ ཨཱུརྡྡྷྭཾ ཝིལོཀྱ ཏཾ དྲྀཥྚྭཱཝཱདཱིཏ྄, ཧེ སཀྐེཡ ཏྭཾ ཤཱིགྷྲམཝརོཧ མཡཱདྱ ཏྭདྒེཧེ ཝསྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ཏཏཿ ས ཤཱིགྷྲམཝརུཧྱ སཱཧླཱདཾ ཏཾ ཛགྲཱཧ། ");
INSERT INTO santib_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ཏད྄ དྲྀཥྚྭཱ སཪྻྭེ ཝིཝདམཱནཱ ཝཀྟུམཱརེབྷིརེ, སོཏིཐིཏྭེན དུཥྚལོཀགྲྀཧཾ གཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ཀིནྟུ སཀྐེཡོ དཎྜཱཡམཱནོ ཝཀྟུམཱརེབྷེ, ཧེ པྲབྷོ པཤྱ མམ ཡཱ སམྤཏྟིརསྟི ཏདརྡྡྷཾ དརིདྲེབྷྱོ དདེ, ཨཔརམ྄ ཨནྱཱཡཾ ཀྲྀཏྭཱ ཀསྨཱདཔི ཡདི ཀདཱཔི ཀིཉྩིཏ྄ མཡཱ གྲྀཧཱིཏཾ ཏརྷི ཏཙྩཏུརྒུཎཾ དདཱམི། ");
INSERT INTO santib_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ཏདཱ ཡཱིཤུསྟམུཀྟཝཱན྄ ཨཡམཔི ཨིབྲཱཧཱིམཿ སནྟཱནོ྅ཏཿ ཀཱརཎཱད྄ ཨདྱཱསྱ གྲྀཧེ ཏྲཱཎམུཔསྠིཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ཡད྄ ཧཱརིཏཾ ཏཏ྄ མྲྀགཡིཏུཾ རཀྵིཏུཉྩ མནུཥྱཔུཏྲ ཨཱགཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ཨཐ ས ཡིརཱུཤཱལམཿ སམཱིཔ ཨུཔཱཏིཥྛད྄ ཨཱིཤྭརརཱཛཏྭསྱཱནུཥྛཱནཾ ཏདཻཝ བྷཝིཥྱཏཱིཏི ལོཀཻརནྭབྷཱུཡཏ, ཏསྨཱཏ྄ ས ཤྲོཏྲྀབྷྱཿ པུནརྡྲྀཥྚཱནྟཀཐཱམ྄ ཨུཏྠཱཔྱ ཀཐཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ཀོཔི མཧཱལློཀོ ནིཛཱརྠཾ རཱཛཏྭཔདཾ གྲྀཧཱིཏྭཱ པུནརཱགནྟུཾ དཱུརདེཤཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ཡཱཏྲཱཀཱལེ ནིཛཱན྄ དཤདཱསཱན྄ ཨཱཧཱུཡ དཤསྭརྞམུདྲཱ དཏྟྭཱ མམཱགམནཔཪྻྱནྟཾ ཝཱཎིཛྱཾ ཀུརུཏེཏྱཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ཀིནྟུ ཏསྱ པྲཛཱསྟམཝཛྙཱཡ མནུཥྱམེནམ྄ ཨསྨཱཀམུཔརི རཱཛཏྭཾ ན ཀཱརཡིཝྱཱམ ཨིམཱཾ ཝཱརྟྟཱཾ ཏནྣིཀཊེ པྲེརཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ཨཐ ས རཱཛཏྭཔདཾ པྲཱཔྱཱགཏཝཱན྄ ཨེཀཻཀོ ཛནོ བཱཎིཛྱེན ཀིཾ ལབྡྷཝཱན྄ ཨིཏི ཛྙཱཏུཾ ཡེཥུ དཱསེཥུ མུདྲཱ ཨརྤཡཏ྄ ཏཱན྄ ཨཱཧཱུཡཱནེཏུམ྄ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ཏདཱ པྲཐམ ཨཱགཏྱ ཀཐིཏཝཱན྄, ཧེ པྲབྷོ ཏཝ ཏཡཻཀཡཱ མུདྲཡཱ དཤམུདྲཱ ལབྡྷཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ཏཏཿ ས ཨུཝཱཙ ཏྭམུཏྟམོ དཱསཿ སྭལྤེན ཝིཤྭཱསྱོ ཛཱཏ ཨིཏཿ ཀཱརཎཱཏ྄ ཏྭཾ དཤནགརཱཎཱམ྄ ཨདྷིཔོ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","དྭིཏཱིཡ ཨཱགཏྱ ཀཐིཏཝཱན྄, ཧེ པྲབྷོ ཏཝཻཀཡཱ མུདྲཡཱ པཉྩམུདྲཱ ལབྡྷཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ཏཏཿ ས ཨུཝཱཙ, ཏྭཾ པཉྩཱནཱཾ ནགརཱཎཱམདྷིཔཏི རྦྷཝ། ");
INSERT INTO santib_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ཏཏོནྱ ཨཱགཏྱ ཀཐཡཱམཱས, ཧེ པྲབྷོ པཤྱ ཏཝ ཡཱ མུདྲཱ ཨཧཾ ཝསྟྲེ བདྡྷྭཱསྠཱཔཡཾ སེཡཾ། ");
INSERT INTO santib_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ཏྭཾ ཀྲྀཔཎོ ཡནྣཱསྠཱཔཡསྟདཔི གྲྀཧླཱསི, ཡནྣཱཝཔསྟདེཝ ཙ ཚིནཏྶི ཏཏོཧཾ ཏྭཏྟོ བྷཱིཏཿ། ");
INSERT INTO santib_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ཏདཱ ས ཛགཱད, རེ དུཥྚདཱས ཏཝ ཝཱཀྱེན ཏྭཱཾ དོཥིཎཾ ཀརིཥྱཱམི, ཡདཧཾ ནཱསྠཱཔཡཾ ཏདེཝ གྲྀཧླཱམི, ཡདཧཾ ནཱཝཔཉྩ ཏདེཝ ཚིནདྨི, ཨེཏཱདྲྀཤཿ ཀྲྀཔཎོཧམིཏི ཡདི ཏྭཾ ཛཱནཱསི, ");
INSERT INTO santib_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ཏརྷི མམ མུདྲཱ བཎིཛཱཾ ནིཀཊེ ཀུཏོ ནཱསྠཱཔཡཿ? ཏཡཱ ཀྲྀཏེ྅ཧམ྄ ཨཱགཏྱ ཀུསཱིདེན སཱརྡྡྷཾ ནིཛམུདྲཱ ཨཔྲཱཔྶྱམ྄། ");
INSERT INTO santib_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","པཤྩཱཏ྄ ས སམཱིཔསྠཱན྄ ཛནཱན྄ ཨཱཛྙཱཔཡཏ྄ ཨསྨཱཏ྄ མུདྲཱ ཨཱནཱིཡ ཡསྱ དཤམུདྲཱཿ སནྟི ཏསྨཻ དཏྟ། ");
INSERT INTO santib_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ཏེ པྲོཙུཿ པྲབྷོ྅སྱ དཤམུདྲཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ཡུཥྨཱནཧཾ ཝདཱམི ཡསྱཱཤྲཡེ ཝདྡྷཏེ ྅དྷིཀཾ ཏསྨཻ དཱཡིཥྱཏེ, ཀིནྟུ ཡསྱཱཤྲཡེ ན ཝརྡྡྷཏེ ཏསྱ ཡདྱདསྟི ཏདཔི ཏསྨཱན྄ ནཱཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ཀིནྟུ མམཱདྷིཔཏིཏྭསྱ ཝཤཏྭེ སྠཱཏུམ྄ ཨསམྨནྱམཱནཱ ཡེ མམ རིཔཝསྟཱནཱནཱིཡ མམ སམཀྵཾ སཾཧརཏ། ");
INSERT INTO santib_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ཨིཏྱུཔདེཤཀཐཱཾ ཀཐཡིཏྭཱ སོགྲགཿ སན྄ ཡིརཱུཤཱལམཔུརཾ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ཏཏོ བཻཏྥགཱིབཻཐནཱིཡཱགྲཱམཡོཿ སམཱིཔེ ཛཻཏུནཱདྲེརནྟིཀམ྄ ཨིཏྭཱ ཤིཥྱདྭཡམ྄ ཨིཏྱུཀྟྭཱ པྲེཥཡཱམཱས, ");
INSERT INTO santib_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ཡུཝཱམམུཾ སམྨུཁསྠགྲཱམཾ པྲཝིཤྱཻཝ ཡཾ ཀོཔི མཱནུཥཿ ཀདཱཔི ནཱརོཧཏ྄ ཏཾ གརྡྡབྷཤཱཝཀཾ བདྡྷཾ དྲཀྵྱཐསྟཾ མོཙཡིཏྭཱནཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ཏཏྲ ཀུཏོ མོཙཡཐཿ? ཨིཏི ཙེཏ྄ ཀོཔི ཝཀྵྱཏི ཏརྷི ཝཀྵྱཐཿ པྲབྷེाརཏྲ པྲཡོཛནམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ཏདཱ ཏཽ པྲརིཏཽ གཏྭཱ ཏཏྐཐཱाནུསཱརེཎ སཪྻྭཾ པྲཱཔྟཽ། ");
INSERT INTO santib_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","གརྡབྷཤཱཝཀམོཙནཀཱལེ ཏཏྭཱམིན ཨཱུཙུཿ, གརྡབྷཤཱཝཀཾ ཀུཏོ མོཙཡཐཿ? ");
INSERT INTO santib_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ཏཱཝཱུཙཏུཿ པྲབྷོརཏྲ པྲཡོཛནམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","པཤྩཱཏ྄ ཏཽ ཏཾ གརྡབྷཤཱཝཀཾ ཡཱིཤོརནྟིཀམཱནཱིཡ ཏཏྤྲྀཥྛེ ནིཛཝསནཱནི པཱཏཡིཏྭཱ ཏདུཔརི ཡཱིཤུམཱརོཧཡཱམཱསཏུཿ། ");
INSERT INTO santib_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ཨཐ ཡཱཏྲཱཀཱལེ ལོཀཱཿ པཐི སྭཝསྟྲཱཎི པཱཏཡིཏུམ྄ ཨཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ཨཔརཾ ཛཻཏུནཱདྲེརུཔཏྱཀཱམ྄ ཨིཏྭཱ ཤིཥྱསཾགྷཿ པཱུཪྻྭདྲྀཥྚཱནི མཧཱཀརྨྨཱཎི སྨྲྀཏྭཱ, ");
INSERT INTO santib_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ཡོ རཱཛཱ པྲབྷོ རྣཱམྣཱཡཱཏི ས དྷནྱཿ སྭརྒེ ཀུཤལཾ སཪྻྭོཙྩེ ཛཡདྷྭནི རྦྷཝཏུ, ཀཐཱམེཏཱཾ ཀཐཡིཏྭཱ སཱནནྡམ྄ ཨུཙཻརཱིཤྭརཾ དྷནྱཾ ཝཀྟུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ཏདཱ ལོཀཱརཎྱམདྷྱསྠཱཿ ཀིཡནྟཿ ཕིརཱུཤིནསྟཏ྄ ཤྲུཏྭཱ ཡཱིཤུཾ པྲོཙུཿ, ཧེ ཨུཔདེཤཀ སྭཤིཥྱཱན྄ ཏརྫཡ། ");
INSERT INTO santib_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ས ཨུཝཱཙ, ཡུཥྨཱནཧཾ ཝདཱམི ཡདྱམཱི ནཱིརཝཱསྟིཥྛནྟི ཏརྷི པཱཥཱཎཱ ཨུཙཻཿ ཀཐཱཿ ཀཐཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","པཤྩཱཏ྄ ཏཏྤུརཱནྟིཀམེཏྱ ཏདཝལོཀྱ སཱཤྲུཔཱཏཾ ཛགཱད, ");
INSERT INTO santib_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ཧཱ ཧཱ ཙེཏ྄ ཏྭམགྲེ྅ཛྙཱསྱཐཱཿ, ཏཝཱསྨིནྣེཝ དིནེ ཝཱ ཡདི སྭམངྒལམ྄ ཨུཔཱལཔྶྱཐཱཿ, ཏརྷྱུཏྟམམ྄ ཨབྷཝིཥྱཏ྄, ཀིནྟུ ཀྵཎེསྨིན྄ ཏཏྟཝ དྲྀཥྚེརགོཙརམ྄ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ཏྭཾ སྭཏྲཱཎཀཱལེ ན མནོ ནྱདྷཏྠཱ ཨིཏི ཧེཏོ ཪྻཏྐཱལེ ཏཝ རིཔཝསྟྭཱཾ ཙཏུརྡིཀྵུ པྲཱཙཱིརེཎ ཝེཥྚཡིཏྭཱ རོཏྶྱནྟི ");
INSERT INTO santib_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","བཱལཀཻཿ སཱརྡྡྷཾ བྷཱུམིསཱཏ྄ ཀརིཥྱནྟི ཙ ཏྭནྨདྷྱེ པཱཥཱཎཻཀོཔི པཱཥཱཎོཔརི ན སྠཱསྱཏི ཙ, ཀཱལ ཨཱིདྲྀཤ ཨུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ཨཐ མདྷྱེམནྡིརཾ པྲཝིཤྱ ཏཏྲཏྱཱན྄ ཀྲཡིཝིཀྲཡིཎོ བཧིཥྐུཪྻྭན྄ ");
INSERT INTO santib_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ཨཝདཏ྄ མདྒྲྀཧཾ པྲཱརྠནཱགྲྀཧམིཏི ལིཔིརཱསྟེ ཀིནྟུ ཡཱུཡཾ ཏདེཝ ཙཻརཱཎཱཾ གཧྭརཾ ཀུརུཐ། ");
INSERT INTO santib_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","པཤྩཱཏ྄ ས པྲཏྱཧཾ མདྷྱེམནྡིརམ྄ ཨུཔདིདེཤ; ཏཏཿ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཿ པྲཱཙཱིནཱཤྩ ཏཾ ནཱཤཡིཏུཾ ཙིཙེཥྚིརེ; ");
INSERT INTO santib_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ཀིནྟུ ཏདུཔདེཤེ སཪྻྭེ ལོཀཱ ནིཝིཥྚཙིཏྟཱཿ སྠིཏཱསྟསྨཱཏ྄ ཏེ ཏཏྐརྟྟུཾ ནཱཝཀཱཤཾ པྲཱཔུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ཨཐཻཀདཱ ཡཱིཤུ རྨནིདརེ སུསཾཝཱདཾ པྲཙཱརཡན྄ ལོཀཱནུཔདིཤཏི, ཨེཏརྷི པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཿ པྲཱཉྩཤྩ ཏནྣིཀཊམཱགཏྱ པཔྲཙྪུཿ ");
INSERT INTO santib_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ཀཡཱཛྙཡཱ ཏྭཾ ཀརྨྨཱཎྱེཏཱནི ཀརོཥི? ཀོ ཝཱ ཏྭཱམཱཛྙཱཔཡཏ྄? ཏདསྨཱན྄ ཝད། ");
INSERT INTO santib_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ས པྲཏྱུཝཱཙ, ཏརྷི ཡུཥྨཱནཔི ཀཐཱམེཀཱཾ པྲྀཙྪཱམི ཏསྱོཏྟརཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ཡོཧནོ མཛྫནམ྄ ཨཱིཤྭརསྱ མཱནུཥཱཎཱཾ ཝཱཛྙཱཏོ ཛཱཏཾ? ");
INSERT INTO santib_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ཏཏསྟེ མིཐོ ཝིཝིཙྱ ཛགདུཿ, ཡདཱིཤྭརསྱ ཝདཱམསྟརྷི ཏཾ ཀུཏོ ན པྲཏྱཻཏ ས ཨིཏི ཝཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ཡདི མནུཥྱསྱེཏི ཝདཱམསྟརྷི སཪྻྭེ ལོཀཱ ཨསྨཱན྄ པཱཥཱཎཻ རྷནིཥྱནྟི ཡཏོ ཡོཧན྄ བྷཝིཥྱདྭཱདཱིཏི སཪྻྭེ དྲྀཌྷཾ ཛཱནནྟི། ");
INSERT INTO santib_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ཨཏཨེཝ ཏེ པྲཏྱཱུཙུཿ ཀསྱཱཛྙཡཱ ཛཱཏམ྄ ཨིཏི ཝཀྟུཾ ན ཤཀྣུམཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ཏདཱ ཡཱིཤུརཝདཏ྄ ཏརྷི ཀཡཱཛྙཡཱ ཀརྨྨཱཎྱེཏཱཏི ཀརོམཱིཏི ཙ ཡུཥྨཱན྄ ན ཝཀྵྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ཨཐ ལོཀཱནཱཾ སཱཀྵཱཏ྄ ས ཨིམཱཾ དྲྀཥྚཱནྟཀཐཱཾ ཝཀྟུམཱརེབྷེ, ཀཤྩིད྄ དྲཱཀྵཱཀྵེཏྲཾ ཀྲྀཏྭཱ ཏཏ྄ ཀྵེཏྲཾ ཀྲྀཥཱིཝལཱནཱཾ ཧསྟེཥུ སམརྤྱ བཧུཀཱལཱརྠཾ དཱུརདེཤཾ ཛགཱམ། ");
INSERT INTO santib_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ཨཐ ཕལཀཱལེ ཕལཱནི གྲཧཱིཏུ ཀྲྀཥཱིཝལཱནཱཾ སམཱིཔེ དཱསཾ པྲཱཧིཎོཏ྄ ཀིནྟུ ཀྲྀཥཱིཝལཱསྟཾ པྲཧྲྀཏྱ རིཀྟཧསྟཾ ཝིསསརྫུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ཏཏཿ སོདྷིཔཏིཿ པུནརནྱཾ དཱསཾ པྲེཥཡཱམཱས, ཏེ ཏམཔི པྲཧྲྀཏྱ ཀུཝྱཝཧྲྀཏྱ རིཀྟཧསྟཾ ཝིསསྲྀཛུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ཏཏཿ ས ཏྲྀཏཱིཡཝཱརམ྄ ཨནྱཾ པྲཱཧིཎོཏ྄ ཏེ ཏམཔི ཀྵཏཱངྒཾ ཀྲྀཏྭཱ བཧི རྣིཙིཀྵིཔུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ཏདཱ ཀྵེཏྲཔཏི ཪྻིཙཱརཡཱམཱས, མམེདཱནཱིཾ ཀིཾ ཀརྟྟཝྱཾ? མམ པྲིཡེ པུཏྲེ པྲཧིཏེ ཏེ ཏམཝཤྱཾ དྲྀཥྚྭཱ སམཱདརིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ཀིནྟུ ཀྲྀཥཱིཝལཱསྟཾ ནིརཱིཀྵྱ པརསྤརཾ ཝིཝིཙྱ པྲོཙུཿ, ཨཡམུཏྟརཱདྷིཀཱརཱི ཨཱགཙྪཏཻནཾ ཧནྨསྟཏོདྷིཀཱརོསྨཱཀཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ཏཏསྟེ ཏཾ ཀྵེཏྲཱད྄ བཧི རྣིཔཱཏྱ ཛགྷྣུསྟསྨཱཏ྄ ས ཀྵེཏྲཔཏིསྟཱན྄ པྲཏི ཀིཾ ཀརིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ས ཨཱགཏྱ ཏཱན྄ ཀྲྀཥཱིཝལཱན྄ ཧཏྭཱ པརེཥཱཾ ཧསྟེཥུ ཏཏྐྵེཏྲཾ སམརྤཡིཥྱཏི; ཨིཏི ཀཐཱཾ ཤྲུཏྭཱ ཏེ ྅ཝདན྄ ཨེཏཱདྲྀཤཱི གྷཊནཱ ན བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ཀིནྟུ ཡཱིཤུསྟཱནཝལོཀྱ ཛགཱད, ཏརྷི, སྠཔཏཡཿ ཀརིཥྱནྟི གྲཱཝཱཎཾ ཡནྟུ ཏུཙྪཀཾ། པྲདྷཱནཔྲསྟརཿ ཀོཎེ ས ཨེཝ ཧི བྷཝིཥྱཏི། ཨེཏསྱ ཤཱསྟྲཱིཡཝཙནསྱ ཀིཾ ཏཱཏྤཪྻྱཾ? ");
INSERT INTO santib_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ཨཔརཾ ཏཏྤཱཥཱཎོཔརི ཡཿ པཏིཥྱཏི ས བྷཾཀྵྱཏེ ཀིནྟུ ཡསྱོཔརི ས པཱཥཱཎཿ པཏིཥྱཏི ས ཏེན དྷཱུལིཝཙ྄ ཙཱུརྞཱིབྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","སོསྨཱཀཾ ཝིརུདྡྷཾ དྲྀཥྚཱནྟམིམཾ ཀཐིཏཝཱན྄ ཨིཏི ཛྙཱཏྭཱ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ ཏདཻཝ ཏཾ དྷརྟུཾ ཝཝཱཉྪུཿ ཀིནྟུ ལོཀེབྷྱོ བིབྷྱུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ཨཏཨེཝ ཏཾ པྲཏི སཏརྐཱཿ སནྟཿ ཀཐཾ ཏདྭཱཀྱདོཥཾ དྷྲྀཏྭཱ ཏཾ དེཤཱདྷིཔསྱ སཱདྷུཝེཤདྷཱརིཎཤྩརཱན྄ ཏསྱ སམཱིཔེ པྲེཥཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ཏདཱ ཏེ ཏཾ པཔྲཙྪུཿ, ཧེ ཨུཔདེཤཀ བྷཝཱན྄ ཡཐཱརྠཾ ཀཐཡན྄ ཨུཔདིཤཏི, ཀམཔྱནཔེཀྵྱ སཏྱཏྭེནཻཤྭརཾ མཱརྒམུཔདིཤཏི, ཝཡམེཏཛྫཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ཀཻསརརཱཛཱཡ ཀརོསྨཱབྷི རྡེཡོ ན ཝཱ? ");
INSERT INTO santib_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ས ཏེཥཱཾ ཝཉྩནཾ ཛྙཱཏྭཱཝདཏ྄ ཀུཏོ མཱཾ པརཱིཀྵདྷྭེ? མཱཾ མུདྲཱམེཀཾ དརྴཡཏ། ");
INSERT INTO santib_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ཨིཧ ལིཁིཏཱ མཱུརྟིརིཡཾ ནཱམ ཙ ཀསྱ? ཏེ྅ཝདན྄ ཀཻསརསྱ། ");
INSERT INTO santib_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ཏདཱ ས ཨུཝཱཙ, ཏརྷི ཀཻསརསྱ དྲཝྱཾ ཀཻསརཱཡ དཏྟ; ཨཱིཤྭརསྱ ཏུ དྲཝྱམཱིཤྭརཱཡ དཏྟ། ");
INSERT INTO santib_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ཏསྨཱལློཀཱནཱཾ སཱཀྵཱཏ྄ ཏཏྐཐཱཡཱཿ ཀམཔི དོཥཾ དྷརྟུམཔྲཱཔྱ ཏེ ཏསྱོཏྟརཱད྄ ཨཱཤྩཪྻྱཾ མནྱམཱནཱ མཽནིནསྟསྠུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ཨཔརཉྩ ཤྨཤཱནཱདུཏྠཱནཱནངྒཱིཀཱརིཎཱཾ སིདཱུཀིནཱཾ ཀིཡནྟོ ཛནཱ ཨཱགཏྱ ཏཾ པཔྲཙྪུཿ, ");
INSERT INTO santib_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ཧེ ཨུཔདེཤཀ ཤཱསྟྲེ མཱུསཱ ཨསྨཱན྄ པྲཏཱིཏི ལིལེཁ ཡསྱ བྷྲཱཏཱ བྷཱཪྻྱཱཡཱཾ སཏྱཱཾ ནིཿསནྟཱནོ མྲིཡཏེ ས ཏཛྫཱཡཱཾ ཝིཝཧྱ ཏདྭཾཤམ྄ ཨུཏྤཱདཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ཏཐཱཙ ཀེཙིཏ྄ སཔྟ བྷྲཱཏར ཨཱསན྄ ཏེཥཱཾ ཛྱེཥྛོ བྷྲཱཏཱ ཝིཝཧྱ ནིརཔཏྱཿ པྲཱཎཱན྄ ཛཧཽ། ");
INSERT INTO santib_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ཨཐ དྭིཏཱིཡསྟསྱ ཛཱཡཱཾ ཝིཝཧྱ ནིརཔཏྱཿ སན྄ མམཱར། ཏྲྀཏཱིཡཤྩ ཏཱམེཝ ཝྱུཝཱཧ; ");
INSERT INTO santib_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ཨིཏྠཾ སཔྟ བྷྲཱཏརསྟཱམེཝ ཝིཝཧྱ ནིརཔཏྱཱཿ སནྟོ མམྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ཤེཥེ སཱ སྟྲཱི ཙ མམཱར། ");
INSERT INTO santib_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ཨཏཨེཝ ཤྨཤཱནཱདུཏྠཱནཀཱལེ ཏེཥཱཾ སཔྟཛནཱནཱཾ ཀསྱ སཱ བྷཱཪྻྱཱ བྷཝིཥྱཏི? ཡཏཿ སཱ ཏེཥཱཾ སཔྟཱནཱམེཝ བྷཱཪྻྱཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ཏདཱ ཡཱིཤུཿ པྲཏྱུཝཱཙ, ཨེཏསྱ ཛགཏོ ལོཀཱ ཝིཝཧནྟི ཝཱགྡཏྟཱཤྩ བྷཝནྟི ");
INSERT INTO santib_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ཀིནྟུ ཡེ ཏཛྫགཏྤྲཱཔྟིཡོགྱཏྭེན གཎིཏཱཾ བྷཝིཥྱནྟི ཤྨཤཱནཱཙྩོཏྠཱསྱནྟི ཏེ ན ཝིཝཧནྟི ཝཱགྡཏྟཱཤྩ ན བྷཝནྟི, ");
INSERT INTO santib_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ཏེ པུན རྣ མྲིཡནྟེ ཀིནྟུ ཤྨཤཱནཱདུཏྠཱཔིཏཱཿ སནྟ ཨཱིཤྭརསྱ སནྟཱནཱཿ སྭརྒཱིཡདཱུཏཱནཱཾ སདྲྀཤཱཤྩ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ཨདྷིཀནྟུ མཱུསཱཿ སྟམྦོཔཱཁྱཱནེ པརམེཤྭར ཨཱིབྲཱཧཱིམ ཨཱིཤྭར ཨིསྷཱཀ ཨཱིཤྭརོ ཡཱཀཱུབཤྩེཤྭར ཨིཏྱུཀྟྭཱ མྲྀཏཱནཱཾ ཤྨཤཱནཱད྄ ཨུཏྠཱནསྱ པྲམཱཎཾ ལིལེཁ། ");
INSERT INTO santib_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ཨཏཨེཝ ཡ ཨཱིཤྭརཿ ས མྲྀཏཱནཱཾ པྲབྷུ རྣ ཀིནྟུ ཛཱིཝཏཱམེཝ པྲབྷུཿ, ཏནྣིཀཊེ སཪྻྭེ ཛཱིཝནྟཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ཨིཏི ཤྲུཏྭཱ ཀིཡནྟོདྷྱཱཔཀཱ ཨཱུཙུཿ, ཧེ ཨུཔདེཤཀ བྷཝཱན྄ བྷདྲཾ པྲཏྱུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ཨིཏཿ པརཾ ཏཾ ཀིམཔི པྲཥྚཾ ཏེཥཱཾ པྲགལྦྷཏཱ ནཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","པཤྩཱཏ྄ ས ཏཱན྄ ཨུཝཱཙ, ཡཿ ཁྲཱིཥྚཿ ས དཱཡཱུདཿ སནྟཱན ཨེཏཱཾ ཀཐཱཾ ལོཀཱཿ ཀཐཾ ཀཐཡནྟི? ");
INSERT INTO santib_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ཡཏཿ མམ པྲབྷུམིདཾ ཝཱཀྱམཝདཏ྄ པརམེཤྭརཿ། ཏཝ ཤཏྲཱུནཧཾ ཡཱཝཏ྄ པཱདཔཱིཋཾ ཀརོམི ན། ཏཱཝཏ྄ ཀཱལཾ མདཱིཡེ ཏྭཾ དཀྵཔཱརྴྭ ཨུཔཱཝིཤ། ");
INSERT INTO santib_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ཨིཏི ཀཐཱཾ དཱཡཱུད྄ སྭཡཾ གཱིཏགྲནྠེ྅ཝདཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ཨཏཨེཝ ཡདི དཱཡཱུད྄ ཏཾ པྲབྷུཾ ཝདཏི, ཏརྷི ས ཀཐཾ ཏསྱ སནྟཱནོ བྷཝཏི? ");
INSERT INTO santib_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","པཤྩཱད྄ ཡཱིཤུཿ སཪྻྭཛནཱནཱཾ ཀརྞགོཙརེ ཤིཥྱཱནུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ཡེ྅དྷྱཱཔཀཱ དཱིརྒྷཔརིཙྪདཾ པརིདྷཱཡ བྷྲམནྟི, ཧཊྚཱཔཎཡོ རྣམསྐཱརེ བྷཛནགེཧསྱ པྲོཙྩཱསནེ བྷོཛནགྲྀཧསྱ པྲདྷཱནསྠཱནེ ཙ པྲཱིཡནྟེ ");
INSERT INTO santib_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ཝིདྷཝཱནཱཾ སཪྻྭསྭཾ གྲསིཏྭཱ ཚལེན དཱིརྒྷཀཱལཾ པྲཱརྠཡནྟེ ཙ ཏེཥུ སཱཝདྷཱནཱ བྷཝཏ, ཏེཥཱམུགྲདཎྜོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ཨཐ དྷནིལོཀཱ བྷཱཎྜཱགཱརེ དྷནཾ ནིཀྵིཔནྟི ས ཏདེཝ པཤྱཏི, ");
INSERT INTO santib_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ཨེཏརྷི ཀཱཙིདྡཱིནཱ ཝིདྷཝཱ པཎདྭཡཾ ནིཀྵིཔཏི ཏད྄ དདརྴ། ");
INSERT INTO santib_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ཏཏོ ཡཱིཤུརུཝཱཙ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, དརིདྲེཡཾ ཝིདྷཝཱ སཪྻྭེབྷྱོདྷིཀཾ ནྱཀྵེཔྶཱིཏ྄, ");
INSERT INTO santib_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ཡཏོནྱེ སྭཔྲཱཛྱདྷནེབྷྱ ཨཱིཤྭརཱཡ ཀིཉྩིཏ྄ ནྱཀྵེཔྶུཿ, ཀིནྟུ དརིདྲེཡཾ ཝིདྷཝཱ དིནཡཱཔནཱརྠཾ སྭསྱ ཡཏ྄ ཀིཉྩིཏ྄ སྠིཏཾ ཏཏ྄ སཪྻྭཾ ནྱཀྵེཔྶཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ཨཔརཉྩ ཨུཏྟམཔྲསྟརཻརུཏྶྲྀཥྚཝྱཻཤྩ མནྡིརཾ སུཤོབྷཏེཏརཱཾ ཀཻཤྩིདིཏྱུཀྟེ ས པྲཏྱུཝཱཙ ");
INSERT INTO santib_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ཡཱུཡཾ ཡདིདཾ ནིཙཡནཾ པཤྱཐ, ཨསྱ པཱཥཱཎཻཀོཔྱནྱཔཱཥཱཎོཔརི ན སྠཱསྱཏི, སཪྻྭེ བྷཱུསཱདྦྷཝིཥྱནྟི ཀཱལོཡམཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ཏདཱ ཏེ པཔྲཙྪུཿ, ཧེ གུརོ གྷཊནེདྲྀཤཱི ཀདཱ བྷཝིཥྱཏི? གྷཊནཱཡཱ ཨེཏསྱསཤྩིཧྣཾ ཝཱ ཀིཾ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ཏདཱ ས ཛགཱད, སཱཝདྷཱནཱ བྷཝཏ ཡཐཱ ཡུཥྨཱཀཾ བྷྲམཾ ཀོཔི ན ཛནཡཏི, ཁཱིཥྚོཧམིཏྱུཀྟྭཱ མམ ནཱམྲཱ བཧཝ ཨུཔསྠཱསྱནྟི ས ཀཱལཿ པྲཱཡེཎོཔསྠིཏཿ, ཏེཥཱཾ པཤྩཱནྨཱ གཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ཡུདྡྷསྱོཔཔླཝསྱ ཙ ཝཱརྟྟཱཾ ཤྲུཏྭཱ མཱ ཤངྐདྷྭཾ, ཡཏཿ པྲཐམམ྄ ཨེཏཱ གྷཊནཱ ཨཝཤྱཾ བྷཝིཥྱནྟི ཀིནྟུ ནཱཔཱཏེ ཡུགཱནྟོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ཨཔརཉྩ ཀཐཡཱམཱས, ཏདཱ དེཤསྱ ཝིཔཀྵཏྭེན དེཤོ རཱཛྱསྱ ཝིཔཀྵཏྭེན རཱཛྱམ྄ ཨུཏྠཱསྱཏི, ");
INSERT INTO santib_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ནཱནཱསྠཱནེཥུ མཧཱབྷཱུཀམྤོ དུརྦྷིཀྵཾ མཱརཱི ཙ བྷཝིཥྱནྟི, ཏཐཱ ཝྱོམམཎྜལསྱ བྷཡངྐརདརྴནཱནྱཤྩཪྻྱལཀྵཎཱནི ཙ པྲཀཱཤཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ཀིནྟུ སཪྻྭཱསཱམེཏཱསཱཾ གྷཊནཱནཱཾ པཱུཪྻྭཾ ལོཀཱ ཡུཥྨཱན྄ དྷྲྀཏྭཱ ཏཱཌཡིཥྱནྟི, བྷཛནཱལཡེ ཀཱརཱཡཱཉྩ སམརྤཡིཥྱནྟི མམ ནཱམཀཱརཎཱད྄ ཡུཥྨཱན྄ བྷཱུཔཱནཱཾ ཤཱསཀཱནཱཉྩ སམྨུཁཾ ནེཥྱནྟི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","སཱཀྵྱཱརྠམ྄ ཨེཏཱནི ཡུཥྨཱན྄ པྲཏི གྷཊིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ཏདཱ ཀིམུཏྟརཾ ཝཀྟཝྱམ྄ ཨེཏཏ྄ ན ཙིནྟཡིཥྱཱམ ཨིཏི མནཿསུ ནིཤྩིཏནུཏ། ");
INSERT INTO santib_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ཝིཔཀྵཱ ཡསྨཱཏ྄ ཀིམཔྱུཏྟརམ྄ ཨཱཔཏྟིཉྩ ཀརྟྟུཾ ན ཤཀྵྱནྟི ཏཱདྲྀཤཾ ཝཱཀྤཊུཏྭཾ ཛྙཱནཉྩ ཡུཥྨབྷྱཾ དཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ཀིཉྩ ཡཱུཡཾ པིཏྲཱ མཱཏྲཱ བྷྲཱཏྲཱ བནྡྷུནཱ ཛྙཱཏྱཱ ཀུཊུམྦེན ཙ པརཀརེཥུ སམརྤཡིཥྱདྷྭེ; ཏཏསྟེ ཡུཥྨཱཀཾ ཀཉྩན ཀཉྩན གྷཱཏཡིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","མམ ནཱམྣཿ ཀཱརཎཱཏ྄ སཪྻྭཻ རྨནུཥྱཻ ཪྻཱུཡམ྄ ཨྲྀཏཱིཡིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ཀིནྟུ ཡུཥྨཱཀཾ ཤིརཿཀེཤཻཀོཔི ན ཝིནཾཀྵྱཏི, ");
INSERT INTO santib_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ཏསྨཱདེཝ དྷཻཪྻྱམཝལམྦྱ སྭསྭཔྲཱཎཱན྄ རཀྵཏ། ");
INSERT INTO santib_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ཨཔརཉྩ ཡིརཱུཤཱལམྤུརཾ སཻནྱཝེཥྚིཏཾ ཝིལོཀྱ ཏསྱོཙྪིནྣཏཱཡཱཿ སམཡཿ སམཱིཔ ཨིཏྱཝགམིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ཏདཱ ཡིཧཱུདཱདེཤསྠཱ ལོཀཱཿ པཪྻྭཏཾ པལཱཡནྟཱཾ, ཡེ ཙ ནགརེ ཏིཥྛནྟི ཏེ དེཤཱནྟརཾ པལཱཡནྟཱ, ཡེ ཙ གྲཱམེ ཏིཥྛནྟི ཏེ ནགརཾ ན པྲཝིཤནྟུ, ");
INSERT INTO santib_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ཡཏསྟདཱ སམུཙིཏདཎྜནཱཡ དྷརྨྨཔུསྟཀེ ཡཱནི སཪྻྭཱཎི ལིཁིཏཱནི ཏཱནི སཕལཱནི བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ཀིནྟུ ཡཱ ཡཱསྟདཱ གརྦྷཝཏྱཿ སྟནྱདཱཝྱཤྩ ཏཱམཱཾ དུརྒཏི རྦྷཝིཥྱཏི, ཡཏ ཨེཏཱལློཀཱན྄ པྲཏི ཀོཔོ དེཤེ ཙ ཝིཥམདུརྒཏི རྒྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ཝསྟུཏསྟུ ཏེ ཁངྒདྷཱརཔརིཝྺངྒཾ ལཔྶྱནྟེ བདྡྷཱཿ སནྟཿ སཪྻྭདེཤེཥུ ནཱཡིཥྱནྟེ ཙ ཀིཉྩཱནྱདེཤཱིཡཱནཱཾ སམཡོཔསྠིཏིཔཪྻྱནྟཾ ཡིརཱུཤཱལམྤུརཾ ཏཻཿ པདཏལཻ རྡལཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","སཱུཪྻྱཙནྡྲནཀྵཏྲེཥུ ལཀྵཎཱདི བྷཝིཥྱནྟི, བྷུཝི སཪྻྭདེཤཱིཡཱནཱཾ དུཿཁཾ ཙིནྟཱ ཙ སིནྡྷཽ ཝཱིཙཱིནཱཾ ཏརྫནཾ གརྫནཉྩ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","བྷཱུབྷཽ བྷཱཝིགྷཊནཱཾ ཙིནྟཡིཏྭཱ མནུཛཱ བྷིཡཱམྲྀཏཀལྤཱ བྷཝིཥྱནྟི, ཡཏོ ཝྱོམམཎྜལེ ཏེཛསྭིནོ དོལཱཡམཱནཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ཏདཱ པརཱཀྲམེཎཱ མཧཱཏེཛསཱ ཙ མེགྷཱརཱུཌྷཾ མནུཥྱཔུཏྲམ྄ ཨཱཡཱནྟཾ དྲཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ཀིནྟྭེཏཱསཱཾ གྷཊནཱནཱམཱརམྦྷེ སཏི ཡཱུཡཾ མསྟཀཱནྱུཏྟོལྱ ཨཱུརྡདྷྭཾ དྲཀྵྱཐ, ཡཏོ ཡུཥྨཱཀཾ མུཀྟེཿ ཀཱལཿ སཝིདྷོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ཏཏསྟེནཻཏདྲྀཥྚཱནྟཀཐཱ ཀཐིཏཱ, པཤྱཏ ཨུཌུམྦརཱདིཝྲྀཀྵཱཎཱཾ ");
INSERT INTO santib_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ནཝཱིནཔཏྲཱཎི ཛཱཏཱནཱིཏི དྲྀཥྚྭཱ ནིདཱཝཀཱལ ཨུཔསྠིཏ ཨིཏི ཡཐཱ ཡཱུཡཾ ཛྙཱཏུཾ ཤཀྣུཐ, ");
INSERT INTO santib_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ཏཐཱ སཪྻྭཱསཱམཱསཱཾ གྷཊནཱནཱམ྄ ཨཱརམྦྷེ དྲྀཥྚེ སཏཱིཤྭརསྱ རཱཛཏྭཾ ནིཀཊམ྄ ཨིཏྱཔི ཛྙཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཝིདྱམཱནལོཀཱནཱམེཥཱཾ གམནཱཏ྄ པཱུཪྻྭམ྄ ཨེཏཱནི གྷཊིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ནབྷོབྷུཝོརློཔོ བྷཝིཥྱཏི མམ ཝཱཀ྄ ཏུ ཀདཱཔི ལུཔྟཱ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ཨཏཨེཝ ཝིཥམཱཤནེན པཱནེན ཙ སཱཾམཱརིཀཙིནྟཱབྷིཤྩ ཡུཥྨཱཀཾ ཙིཏྟེཥུ མཏྟེཥུ ཏདྡིནམ྄ ཨཀསྨཱད྄ ཡུཥྨཱན྄ པྲཏི ཡཐཱ ནོཔཏིཥྛཏི ཏདརྠཾ སྭེཥུ སཱཝདྷཱནཱསྟིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","པྲྀཐིཝཱིསྠསཪྻྭལོཀཱན྄ པྲཏི ཏདྡིནམ྄ ཨུནྨཱཐ ཨིཝ ཨུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ཡཐཱ ཡཱུཡམ྄ ཨེཏདྦྷཱཝིགྷཊནཱ ཨུཏྟརྟྟུཾ མནུཛསུཏསྱ སམྨུཁེ སཾསྠཱཏུཉྩ ཡོགྱཱ བྷཝཐ ཀཱརཎཱདསྨཱཏ྄ སཱཝདྷཱནཱཿ སནྟོ ནིརནྟརཾ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ཨཔརཉྩ ས དིཝཱ མནྡིར ཨུཔདིཤྱ རཱཙཻ ཛཻཏུནཱདྲིཾ གཏྭཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ཏཏཿ པྲཏྱཱུཥེ ལཱཀཱསྟཏྐཐཱཾ ཤྲོཏུཾ མནྡིརེ ཏདནྟིཀམ྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ཨཔརཉྩ ཀིཎྭཤཱུནྱཔཱུཔོཏྶཝསྱ ཀཱལ ཨུཔསྠིཏེ ");
INSERT INTO santib_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཡཀཱཤྩ ཡཐཱ ཏཾ ཧནྟུཾ ཤཀྣུཝནྟི ཏཐོཔཱཡཱམ྄ ཨཙེཥྚནྟ ཀིནྟུ ལོཀེབྷྱོ བིབྷྱུཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ཨེཏསྟིན྄ སམཡེ དྭཱདཤཤིཥྱེཥུ གཎིཏ ཨཱིཥྐརིཡོཏཱིཡརཱུཌྷིམཱན྄ ཡོ ཡིཧཱུདཱསྟསྱཱནྟཿཀརཎཾ ཤཻཏཱནཱཤྲིཏཏྭཱཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ས གཏྭཱ ཡཐཱ ཡཱིཤུཾ ཏེཥཱཾ ཀརེཥུ སམརྤཡིཏུཾ ཤཀྣོཏི ཏཐཱ མནྟྲཎཱཾ པྲདྷཱནཡཱཛཀཻཿ སེནཱཔཏིབྷིཤྩ སཧ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ཏེན ཏེ ཏུཥྚཱསྟསྨཻ མུདྲཱཾ དཱཏུཾ པཎཾ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ཏཏཿ སོངྒཱིཀྲྀཏྱ ཡཐཱ ལོཀཱནཱམགོཙརེ ཏཾ པརཀརེཥུ སམརྤཡིཏུཾ ཤཀྣོཏི ཏཐཱཝཀཱཤཾ ཙེཥྚིཏུམཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ཨཐ ཀིཎྭཤཱུནྱཔཱུཔོཏྨཝདིནེ, ཨརྠཱཏ྄ ཡསྨིན྄ དིནེ ནིསྟཱརོཏྶཝསྱ མེཥོ ཧནྟཝྱསྟསྨིན྄ དིནེ ");
INSERT INTO santib_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ཡཱིཤུཿ པིཏརཾ ཡོཧནཉྩཱཧཱུཡ ཛགཱད, ཡུཝཱཾ གཏྭཱསྨཱཀཾ བྷོཛནཱརྠཾ ནིསྟཱརོཏྶཝསྱ དྲཝྱཱཎྱཱསཱདཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ཏདཱ ཏཽ པཔྲཙྪཏུཿ ཀུཙཱསཱདཡཱཝོ བྷཝཏཿ ཀེཙྪཱ? ");
INSERT INTO santib_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ཏདཱ སོཝཱདཱིཏ྄, ནགརེ པྲཝིཥྚེ ཀཤྩིཛྫལཀུམྦྷམཱདཱཡ ཡུཝཱཾ སཱཀྵཱཏ྄ ཀརིཥྱཏི ས ཡནྣིཝེཤནཾ པྲཝིཤཏི ཡུཝཱམཔི ཏནྣིཝེཤནཾ ཏཏྤཤྩཱདིཏྭཱ ནིཝེཤནཔཏིམ྄ ཨིཏི ཝཱཀྱཾ ཝདཏཾ, ");
INSERT INTO santib_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ཡཏྲཱཧཾ ནིསྟཱརོཏྶཝསྱ བྷོཛྱཾ ཤིཥྱཻཿ སཱརྡྡྷཾ བྷོཀྟུཾ ཤཀྣོམི སཱཏིཐིཤཱལཱा ཀུཏྲ? ཀཐཱམིམཱཾ པྲབྷུསྟྭཱཾ པྲྀཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ཏཏཿ ས ཛནོ དྭིཏཱིཡཔྲཀོཥྛཱིཡམ྄ ཨེཀཾ ཤསྟཾ ཀོཥྛཾ དརྴཡིཥྱཏི ཏཏྲ བྷོཛྱམཱསཱདཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ཏཏསྟཽ གཏྭཱ ཏདྭཱཀྱཱནུསཱརེཎ སཪྻྭཾ དྲྀཥྡྭཱ ཏཏྲ ནིསྟཱརོཏྶཝཱིཡཾ བྷོཛྱམཱསཱདཡཱམཱསཏུཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ཨཐ ཀཱལ ཨུཔསྠིཏེ ཡཱིཤུ རྡྭཱདཤབྷིཿ པྲེརིཏཻཿ སཧ བྷོཀྟུམུཔཝིཤྱ ཀཐིཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","མམ དུཿཁབྷོགཱཏ྄ པཱུཪྻྭཾ ཡུབྷཱབྷིཿ སཧ ནིསྟཱརོཏྶཝསྱཻཏསྱ བྷོཛྱཾ བྷོཀྟུཾ མཡཱཏིཝཱཉྪཱ ཀྲྀཏཱ། ");
INSERT INTO santib_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ཡུཥྨཱན྄ ཝདཱམི, ཡཱཝཏྐཱལམ྄ ཨཱིཤྭརརཱཛྱེ བྷོཛནཾ ན ཀརིཥྱེ ཏཱཝཏྐཱལམ྄ ཨིདཾ ན བྷོཀྵྱེ། ");
INSERT INTO santib_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ཏདཱ ས པཱནཔཱཏྲམཱདཱཡ ཨཱིཤྭརསྱ གུཎཱན྄ ཀཱིརྟྟཡིཏྭཱ ཏེབྷྱོ དཏྭཱཝདཏ྄, ཨིདཾ གྲྀཧླཱིཏ ཡཱུཡཾ ཝིབྷཛྱ པིཝཏ། ");
INSERT INTO santib_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ཡུཥྨཱན྄ ཝདཱམི ཡཱཝཏྐཱལམ྄ ཨཱིཤྭརརཱཛཏྭསྱ སཾསྠཱཔནཾ ན བྷཝཏི ཏཱཝད྄ དྲཱཀྵཱཕལརསཾ ན པཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ཏཏཿ པཱུཔཾ གྲྀཧཱིཏྭཱ ཨཱིཤྭརགུཎཱན྄ ཀཱིརྟྟཡིཏྭཱ བྷངྐྟཱ ཏེབྷྱོ དཏྭཱཝདཏ྄, ཡུཥྨདརྠཾ སམརྤིཏཾ ཡནྨམ ཝཔུསྟདིདཾ, ཨེཏཏ྄ ཀརྨྨ མམ སྨརཎཱརྠཾ ཀུརུདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ཨཐ བྷོཛནཱནྟེ ཏཱདྲྀཤཾ པཱཏྲཾ གྲྀཧཱིཏྭཱཝདཏ྄, ཡུཥྨཏྐྲྀཏེ པཱཏིཏཾ ཡནྨམ རཀྟཾ ཏེན ནིརྞཱིཏནཝནིཡམརཱུཔཾ པཱནཔཱཏྲམིདཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","པཤྱཏ ཡོ མཱཾ པརཀརེཥུ སམརྤཡིཥྱཏི ས མཡཱ སཧ བྷོཛནཱསན ཨུཔཝིཤཏི། ");
INSERT INTO santib_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ཡཐཱ ནིརཱུཔིཏམཱསྟེ ཏདནུསཱརེཎཱ མནུཥྱཔུुཏྲསྱ གཏི རྦྷཝིཥྱཏི ཀིནྟུ ཡསྟཾ པརཀརེཥུ སམརྤཡིཥྱཏི ཏསྱ སནྟཱཔོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ཏདཱ ཏེཥཱཾ ཀོ ཛན ཨེཏཏ྄ ཀརྨྨ ཀརིཥྱཏི ཏཏ྄ ཏེ པརསྤརཾ པྲཥྚུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ཨཔརཾ ཏེཥཱཾ ཀོ ཛནཿ ཤྲེཥྛཏྭེན གཎཡིཥྱཏེ, ཨཏྲཱརྠེ ཏེཥཱཾ ཝིཝཱདོབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ཨསྨཱཏ྄ ཀཱརཎཱཏ྄ སོཝདཏ྄, ཨནྱདེཤཱིཡཱནཱཾ རཱཛཱནཿ པྲཛཱནཱམུཔརི པྲབྷུཏྭཾ ཀུཪྻྭནྟི དཱརུཎཤཱསནཾ ཀྲྀཏྭཱཔི ཏེ བྷཱུཔཏིཏྭེན ཝིཁྱཱཏཱ བྷཝནྟི ཙ། ");
INSERT INTO santib_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ཀིནྟུ ཡུཥྨཱཀཾ ཏཐཱ ན བྷཝིཥྱཏི, ཡོ ཡུཥྨཱཀཾ ཤྲེཥྛོ བྷཝིཥྱཏི ས ཀནིཥྛཝད྄ བྷཝཏུ, ཡཤྩ མུཁྱོ བྷཝིཥྱཏི ས སེཝཀཝདྦྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","བྷོཛནོཔཝིཥྚཔརིཙཱརཀཡོཿ ཀཿ ཤྲེཥྛཿ? ཡོ བྷོཛནཱཡོཔཝིཤཏི ས ཀིཾ ཤྲེཥྛོ ན བྷཝཏི? ཀིནྟུ ཡུཥྨཱཀཾ མདྷྱེ྅ཧཾ པརིཙཱརཀཨིཝཱསྨི། ");
INSERT INTO santib_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ཨཔརཉྩ ཡུཡཾ མམ པརཱིཀྵཱཀཱལེ པྲཐམམཱརབྷྱ མཡཱ སཧ སྠིཏཱ ");
INSERT INTO santib_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ཨེཏཏྐཱརཎཱཏ྄ པིཏྲཱ ཡཐཱ མདརྠཾ རཱཛྱམེཀཾ ནིརཱུཔིཏཾ ཏཐཱཧམཔི ཡུཥྨདརྠཾ རཱཛྱཾ ནིརཱུཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ཏསྨཱན྄ མམ རཱཛྱེ བྷོཛནཱསནེ ཙ བྷོཛནཔཱནེ ཀརིཥྱདྷྭེ སིཾཧཱསནེཥཱུཔཝིཤྱ ཙེསྲཱཡེལཱིཡཱནཱཾ དྭཱདཤཝཾཤཱནཱཾ ཝིཙཱརཾ ཀརིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ཨཔརཾ པྲབྷུརུཝཱཙ, ཧེ ཤིམོན྄ པཤྱ ཏིཏཨུནཱ དྷཱནྱཱནཱིཝ ཡུཥྨཱན྄ ཤཻཏཱན྄ ཙཱལཡིཏུམ྄ ཨཻཙྪཏ྄, ");
INSERT INTO santib_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ཀིནྟུ ཏཝ ཝིཤྭཱསསྱ ལོཔོ ཡཐཱ ན བྷཝཏི ཨེཏཏ྄ ཏྭདརྠཾ པྲཱརྠིཏཾ མཡཱ, ཏྭནྨནསི པརིཝརྟྟིཏེ ཙ བྷྲཱཏྲྀཎཱཾ མནཱཾསི སྠིརཱིཀུརུ། ");
INSERT INTO santib_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ཏདཱ སོཝདཏ྄, ཧེ པྲབྷོཧཾ ཏྭཡཱ སཱརྡྡྷཾ ཀཱརཱཾ མྲྀཏིཉྩ ཡཱཏུཾ མཛྫིཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ཏཏཿ ས ཨུཝཱཙ, ཧེ པིཏར ཏྭཱཾ ཝདཱམི, ཨདྱ ཀུཀྐུཊརཝཱཏ྄ པཱུཪྻྭཾ ཏྭཾ མཏྤརིཙཡཾ ཝཱརཏྲཡམ྄ ཨཔཧྭོཥྱསེ། ");
INSERT INTO santib_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ཨཔརཾ ས པཔྲཙྪ, ཡདཱ མུདྲཱསམྤུཊཾ ཁཱདྱཔཱཏྲཾ པཱདུཀཱཉྩ ཝིནཱ ཡུཥྨཱན྄ པྲཱཧིཎཝཾ ཏདཱ ཡུཥྨཱཀཾ ཀསྱཱཔི ནྱཱུནཏཱསཱིཏ྄? ཏེ པྲོཙུཿ ཀསྱཱཔི ན། ");
INSERT INTO santib_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ཏདཱ སོཝདཏ྄ ཀིནྟྭིདཱནཱིཾ མུདྲཱསམྤུཊཾ ཁཱདྱཔཱཏྲཾ ཝཱ ཡསྱཱསྟི ཏེན ཏདྒྲཧཱིཏཝྱཾ, ཡསྱ ཙ ཀྲྀཔཱཎོे ནཱསྟི ཏེན སྭཝསྟྲཾ ཝིཀྲཱིཡ ས ཀྲེཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ཡཏོ ཡུཥྨཱནཧཾ ཝདཱམི, ཨཔརཱདྷིཛནཻཿ སཱརྡྡྷཾ གཎིཏཿ ས བྷཝིཥྱཏི། ཨིདཾ ཡཙྪཱསྟྲཱིཡཾ ཝཙནཾ ལིཁིཏམསྟི ཏནྨཡི ཕལིཥྱཏི ཡཏོ མམ སམྦནྡྷཱིཡཾ སཪྻྭཾ སེཏྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ཏདཱ ཏེ པྲོཙུཿ པྲབྷོ པཤྱ ཨིམཽ ཀྲྀཔཱཎཽ། ཏཏཿ སོཝདད྄ ཨེཏཽ ཡཐེཥྚཽ། ");
INSERT INTO santib_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ཨཐ ས ཏསྨཱདྭཧི རྒཏྭཱ སྭཱཙཱརཱནུསཱརེཎ ཛཻཏུནནཱམཱདྲིཾ ཛགཱམ ཤིཥྱཱཤྩ ཏཏྤཤྩཱད྄ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ཏཏྲོཔསྠཱཡ ས ཏཱནུཝཱཙ, ཡཐཱ པརཱིཀྵཱཡཱཾ ན པཏཐ ཏདརྠཾ པྲཱརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","པཤྩཱཏ྄ ས ཏསྨཱད྄ ཨེཀཤརཀྵེཔཱད྄ བཧི རྒཏྭཱ ཛཱནུནཱི པཱཏཡིཏྭཱ ཨེཏཏ྄ པྲཱརྠཡཱཉྩཀྲེ, ");
INSERT INTO santib_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ཧེ པིཏ ཪྻདི བྷཝཱན྄ སམྨནྱཏེ ཏརྷི ཀཾསམེནཾ མམཱནྟིཀཱད྄ དཱུརཡ ཀིནྟུ མདིཙྪཱནུརཱུཔཾ ན ཏྭདིཙྪཱནུརཱུཔཾ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ཏདཱ ཏསྨཻ ཤཀྟིཾ དཱཏུཾ སྭརྒཱིཡདཱུཏོ དརྴནཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","པཤྩཱཏ྄ སོཏྱནྟཾ ཡཱཏནཡཱ ཝྱཱཀུལོ བྷཱུཏྭཱ པུནརྡྲྀཌྷཾ པྲཱརྠཡཱཉྩཀྲེ, ཏསྨཱད྄ བྲྀཧཙྪོཎིཏབིནྡཝ ཨིཝ ཏསྱ སྭེདབིནྡཝཿ པྲྀཐིཝྱཱཾ པཏིཏུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ཨཐ པྲཱརྠནཱཏ ཨུཏྠཱཡ ཤིཥྱཱཎཱཾ སམཱིཔམེཏྱ ཏཱན྄ མནོདུཿཁིནོ ནིདྲིཏཱན྄ དྲྀཥྚྭཱཝདཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ཀུཏོ ནིདྲཱཐ? པརཱིཀྵཱཡཱམ྄ ཨཔཏནཱརྠཾ པྲརྠཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ཨེཏཏྐཐཱཡཱཿ ཀཐནཀཱལེ དྭཱདཤཤིཥྱཱཎཱཾ མདྷྱེ གཎིཏོ ཡིཧཱུདཱནཱམཱ ཛནཏཱསཧིཏསྟེཥཱམ྄ ཨགྲེ ཙལིཏྭཱ ཡཱིཤོཤྩུམྦནཱརྠཾ ཏདནྟིཀམ྄ ཨཱཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ཏདཱ ཡཱིཤུརུཝཱཙ, ཧེ ཡིཧཱུདཱ ཀིཾ ཙུམྦནེན མནུཥྱཔུཏྲཾ པརཀརེཥུ སམརྤཡསི? ");
INSERT INTO santib_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ཏདཱ ཡདྱད྄ གྷཊིཥྱཏེ ཏདནུམཱཡ སངྒིབྷིརུཀྟཾ, ཧེ པྲབྷོ ཝཡཾ ཀི ཁངྒེན གྷཱཏཡིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ཏཏ ཨེཀཿ ཀརཝཱལེནཱཧཏྱ པྲདྷཱནཡཱཛཀསྱ དཱསསྱ དཀྵིཎཾ ཀརྞཾ ཙིཙྪེད། ");
INSERT INTO santib_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ཨདྷཱུནཱ ནིཝརྟྟསྭ ཨིཏྱུཀྟྭཱ ཡཱིཤུསྟསྱ ཤྲུཏིཾ སྤྲྀཥྚྭཱ སྭསྱཾ ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","པཤྩཱད྄ ཡཱིཤུཿ སམཱིཔསྠཱན྄ པྲདྷཱནཡཱཛཀཱན྄ མནྡིརསྱ སེནཱཔཏཱིན྄ པྲཱཙཱིནཱཾཤྩ ཛགཱད, ཡཱུཡཾ ཀྲྀཔཱཎཱན྄ ཡཥྚཱིཾཤྩ གྲྀཧཱིཏྭཱ མཱཾ ཀིཾ ཙོརཾ དྷརྟྟུམཱཡཱཏཱཿ? ");
INSERT INTO santib_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ཡདཱཧཾ ཡུཥྨཱབྷིཿ སཧ པྲཏིདིནཾ མནྡིརེ྅ཏིཥྛཾ ཏདཱ མཱཾ དྷརྟྟཾ ན པྲཝྲྀཏྟཱཿ, ཀིནྟྭིདཱནཱིཾ ཡུཥྨཱཀཾ སམཡོནྡྷཀཱརསྱ ཙཱདྷིཔཏྱམསྟི། ");
INSERT INTO santib_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ཨཐ ཏེ ཏཾ དྷྲྀཏྭཱ མཧཱཡཱཛཀསྱ ནིཝེཤནཾ ནིནྱུཿ། ཏཏཿ པིཏརོ དཱུརེ དཱུརེ པཤྩཱདིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","བྲྀཧཏྐོཥྛསྱ མདྷྱེ ཡཏྲཱགྣིཾ ཛྭཱལཡིཏྭཱ ལོཀཱཿ སམེཏྱོཔཝིཥྚཱསྟཏྲ ཏཻཿ སཱརྡྡྷམ྄ ཨུཔཝིཝེཤ། ");
INSERT INTO santib_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ཨཐ ཝཧྣིསནྣིདྷཽ སམུཔཝེཤཀཱལེ ཀཱཙིདྡཱསཱི མནོ ནིཝིཤྱ ཏཾ ནིརཱིཀྵྱཱཝདཏ྄ པུམཱནཡཾ ཏསྱ སངྒེ྅སྠཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ཀིནྟུ ས ཏད྄ ཨཔཧྣུཏྱཱཝཱདཱིཏ྄ ཧེ ནཱརི ཏམཧཾ ན པརིཙིནོམི། ");
INSERT INTO santib_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ཀྵཎཱནྟརེ྅ནྱཛནསྟཾ དྲྀཥྚྭཱབྲཝཱིཏ྄ ཏྭམཔི ཏེཥཱཾ ནིཀརསྱཻཀཛནོསི། པིཏརཿ པྲཏྱུཝཱཙ ཧེ ནར ནཱཧམསྨི། ");
INSERT INTO santib_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ཏཏཿ སཱརྡྡྷདཎྜདྭཡཱཏ྄ པརཾ པུནརནྱོ ཛནོ ནིཤྩིཏྱ བབྷཱཥེ, ཨེཥ ཏསྱ སངྒཱིཏི སཏྱཾ ཡཏོཡཾ གཱལཱིལཱིཡོ ལོཀཿ། ");
INSERT INTO santib_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ཏདཱ པིཏར ཨུཝཱཙ ཧེ ནར ཏྭཾ ཡད྄ ཝདམི ཏདཧཾ བོདྡྷུཾ ན ཤཀྣོམི, ཨིཏི ཝཱཀྱེ ཀཐིཏམཱཏྲེ ཀུཀྐུཊོ རུརཱཝ། ");
INSERT INTO santib_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ཏདཱ པྲབྷུཎཱ ཝྱཱདྷུཊྱ པིཏརེ ནིརཱིཀྵིཏེ ཀྲྀཀཝཱཀུརཝཱཏ྄ པཱུཪྻྭཾ མཱཾ ཏྲིརཔཧྣོཥྱསེ ཨིཏི པཱུཪྻྭོཀྟཾ ཏསྱ ཝཱཀྱཾ པིཏརཿ སྨྲྀཏྭཱ ");
INSERT INTO santib_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","བཧིརྒཏྭཱ མཧཱཁེདེན ཙཀྲནྡ། ");
INSERT INTO santib_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ཏདཱ ཡཻ ཪྻཱིཤུརྡྷྲྀཏསྟེ ཏམུཔཧསྱ པྲཧརྟྟུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ཝསྟྲེཎ ཏསྱ དྲྀཤཽ བདྡྷྭཱ ཀཔོལེ ཙཔེཊཱགྷཱཏཾ ཀྲྀཏྭཱ པཔྲཙྪུཿ, ཀསྟེ ཀཔོལེ ཙཔེཊཱགྷཱཏཾ ཀྲྀཏཝཱན? གཎཡིཏྭཱ ཏད྄ ཝད། ");
INSERT INTO santib_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ཏདནྱཏ྄ ཏདྭིརུདྡྷཾ བཧུནིནྡཱཝཱཀྱཾ ཝཀྟུམཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ཨཐ པྲབྷཱཏེ སཏི ལོཀཔྲཱཉྩཿ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ སབྷཱཾ ཀྲྀཏྭཱ མདྷྱེསབྷཾ ཡཱིཤུམཱནཱིཡ པཔྲཙྪུཿ, ཏྭམ྄ ཨབྷིཥིཀཏོསི ན ཝཱསྨཱན྄ ཝད། ");
INSERT INTO santib_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ས པྲཏྱུཝཱཙ, མཡཱ ཏསྨིནྣུཀྟེ྅པི ཡཱུཡཾ ན ཝིཤྭསིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ཀསྨིཾཤྩིདྭཱཀྱེ ཡུཥྨཱན྄ པྲྀཥྚེ྅པི མཱཾ ན ཏདུཏྟརཾ ཝཀྵྱཐ ན མཱཾ ཏྱཀྵྱཐ ཙ། ");
INSERT INTO santib_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ཀིནྟྭིཏཿ པརཾ མནུཛསུཏཿ སཪྻྭཤཀྟིམཏ ཨཱིཤྭརསྱ དཀྵིཎེ པཱརྴྭེ སམུཔཝེཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ཏཏསྟེ པཔྲཙྪུཿ, རྟིཧ ཏྭམཱིཤྭརསྱ པུཏྲཿ? ས ཀཐཡཱམཱས, ཡཱུཡཾ ཡཐཱརྠཾ ཝདཐ ས ཨེཝཱཧཾ། ");
INSERT INTO santib_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ཏདཱ ཏེ སཪྻྭེ ཀཐཡཱམཱསུཿ, རྟིཧ སཱཀྵྱེ྅ནྶསྨིན྄ ཨསྨཱཀཾ ཀིཾ པྲཡོཛནཾ? ཨསྱ སྭམུཁཱདེཝ སཱཀྵྱཾ པྲཱཔྟམ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ཏཏཿ སབྷཱསྠཱཿ སཪྻྭལོཀཱ ཨུཏྠཱཡ ཏཾ པཱིལཱཏསམྨུཁཾ ནཱིཏྭཱཔྲོདྱ ཝཀྟུམཱརེབྷིརེ, ");
INSERT INTO santib_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","སྭམབྷིཥིཀྟཾ རཱཛཱནཾ ཝདནྟཾ ཀཻམརརཱཛཱཡ ཀརདཱནཾ ནིཥེདྷནྟཾ རཱཛྱཝིཔཪྻྱཡཾ ཀུརྟྟུཾ པྲཝརྟྟམཱནམ྄ ཨེན པྲཱཔྟཱ ཝཡཾ། ");
INSERT INTO santib_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ཏདཱ པཱིལཱཏསྟཾ པྲྀཥྚཝཱན྄ ཏྭཾ ཀིཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ? ས པྲཏྱུཝཱཙ ཏྭཾ སཏྱམུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ཏདཱ པཱིལཱཏཿ པྲདྷཱནཡཱཛཀཱདིལོཀཱན྄ ཛགཱད྄, ཨཧམེཏསྱ ཀམཔྱཔརཱདྷཾ ནཱཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ཏཏསྟེ པུནཿ སཱཧམིནོ བྷཱུཏྭཱཝདན྄, ཨེཥ གཱལཱིལ ཨེཏཏྶྠཱནཔཪྻྱནྟེ སཪྻྭསྨིན྄ ཡིཧཱུདཱདེཤེ སཪྻྭཱལློཀཱནུཔདིཤྱ ཀུཔྲཝྲྀཏྟིཾ གྲཱཧཱིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ཏདཱ པཱིལཱཏོ གཱལཱིལཔྲདེཤསྱ ནཱམ ཤྲུཏྭཱ པཔྲཙྪ, ཀིམཡཾ གཱལཱིལཱིཡོ ལོཀཿ? ");
INSERT INTO santib_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ཏཏཿ ས གཱལཱིལྤྲདེཤཱིཡཧེརོདྲཱཛསྱ ཏདཱ སྠིཏེསྟསྱ སམཱིཔེ ཡཱིཤུཾ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ཏདཱ ཧེརོད྄ ཡཱིཤུཾ ཝིལོཀྱ སནྟུཏོཥ, ཡཏཿ ས ཏསྱ བཧུཝྲྀཏྟཱནྟཤྲཝཎཱཏ྄ ཏསྱ ཀིཉ्ིཙདཱཤྩཪྻྱཀརྨྨ པཤྱཏི ཨིཏྱཱཤཱཾ ཀྲྀཏྭཱ བཧུཀཱལམཱརབྷྱ ཏཾ དྲཥྚུཾ པྲཡཱསཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ཏསྨཱཏ྄ ཏཾ བཧུཀཐཱཿ པཔྲཙྪ ཀིནྟུ ས ཏསྱ ཀསྱཱཔི ཝཱཀྱསྱ པྲཏྱུཏྟརཾ ནོཝཱཙ། ");
INSERT INTO santib_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ཨཐ པྲདྷཱནཡཱཛཀཱ ཨདྷྱཱཔཀཱཤྩ པྲོཏྟིཥྛནྟཿ སཱཧསེན ཏམཔཝདིཏུཾ པྲཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ཧེརོད྄ ཏསྱ སེནཱགཎཤྩ ཏམཝཛྙཱཡ ཨུཔཧཱསཏྭེན རཱཛཝསྟྲཾ པརིདྷཱཔྱ པུནཿ པཱིལཱཏཾ པྲཏི ཏཾ པྲཱཧིཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","པཱུཪྻྭཾ ཧེརོདྤཱིལཱཏཡོཿ པརསྤརཾ ཝཻརབྷཱཝ ཨཱསཱིཏ྄ ཀིནྟུ ཏདྡིནེ དྭཡོ རྨེལནཾ ཛཱཏམ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","པཤྩཱཏ྄ པཱིལཱཏཿ པྲདྷཱནཡཱཛཀཱན྄ ཤཱསཀཱན྄ ལོཀཱཾཤྩ ཡུགཔདཱཧཱུཡ བབྷཱཥེ, ");
INSERT INTO santib_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","རཱཛྱཝིཔཪྻྱཡཀཱརཀོཡམ྄ ཨིཏྱུཀྟྭཱ མནུཥྱམེནཾ མམ ནིཀཊམཱནཻཥྚ ཀིནྟུ པཤྱཏ ཡུཥྨཱཀཾ སམཀྵམ྄ ཨསྱ ཝིཙཱརཾ ཀྲྀཏྭཱཔི པྲོཀྟཱཔཝཱདཱནུརཱུཔེཎཱསྱ ཀོཔྱཔརཱདྷཿ སཔྲམཱཎོ ན ཛཱཏཿ, ");
INSERT INTO santib_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ཡཱུཡཉྩ ཧེརོདཿ སནྣིདྷཽ པྲེཥིཏཱ མཡཱ ཏཏྲཱསྱ ཀོཔྱཔརཱདྷསྟེནཱཔི ན པྲཱཔྟཿ། པཤྱཏཱནེན ཝདྷཧེेཏུཀཾ ཀིམཔི ནཱཔརཱདྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ཏསྨཱདེནཾ ཏཱཌཡིཏྭཱ ཝིཧཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ཏཏྲོཏྶཝེ ཏེཥཱམེཀོ མོཙཡིཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ཨིཏི ཧེཏོསྟེ པྲོཙྩཻརེཀདཱ པྲོཙུཿ, ཨེནཾ དཱུརཱིཀྲྀཏྱ བརབྦཱནཱམཱནཾ མོཙཡ། ");
INSERT INTO santib_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ས བརབྦཱ ནགར ཨུཔཔླཝཝདྷཱཔརཱདྷཱབྷྱཱཾ ཀཱརཱཡཱཾ བདྡྷ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ཀིནྟུ པཱིལཱཏོ ཡཱིཤུཾ མོཙཡིཏུཾ ཝཱཉྪན྄ པུནསྟཱནུཝཱཙ། ");
INSERT INTO santib_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ཏཐཱཔྱེནཾ ཀྲུཤེ ཝྱདྷ ཀྲུཤེ ཝྱདྷེཏི ཝདནྟསྟེ རུརུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ཏཏཿ ས ཏྲྀཏཱིཡཝཱརཾ ཛགཱད ཀུཏཿ? ས ཀིཾ ཀརྨྨ ཀྲྀཏཝཱན྄? ནཱཧམསྱ ཀམཔི ཝདྷཱཔརཱདྷཾ པྲཱཔྟཿ ཀེཝལཾ ཏཱཌཡིཏྭཱམུཾ ཏྱཛཱམི། ");
INSERT INTO santib_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ཏཐཱཔི ཏེ པུནརེནཾ ཀྲུཤེ ཝྱདྷ ཨིཏྱུཀྟྭཱ པྲོཙྩཻརྡྲྀཌྷཾ པྲཱརྠཡཱཉྩཀྲིརེ; ");
INSERT INTO santib_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ཏཏཿ པྲདྷཱནཡཱཛཀཱདཱིནཱཾ ཀལརཝེ པྲབལེ སཏི ཏེཥཱཾ པྲཱརྠནཱརཱུཔཾ ཀརྟྟུཾ པཱིལཱཏ ཨཱདིདེཤ། ");
INSERT INTO santib_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","རཱཛདྲོཧཝདྷཡོརཔརཱདྷེན ཀཱརཱསྠཾ ཡཾ ཛནཾ ཏེ ཡཡཱཙིརེ ཏཾ མོཙཡིཏྭཱ ཡཱིཤུཾ ཏེཥཱམིཙྪཱཡཱཾ སམཱརྤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ཨཐ ཏེ ཡཱིཤུཾ གྲྀཧཱིཏྭཱ ཡཱནྟི, ཨེཏརྷི གྲཱམཱདཱགཏཾ ཤིམོནནཱམཱནཾ ཀུརཱིཎཱིཡཾ ཛནཾ དྷྲྀཏྭཱ ཡཱིཤོཿ པཤྩཱནྣེཏུཾ ཏསྱ སྐནྡྷེ ཀྲུཤམརྤཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ཏཏོ ལོाཀཱརཎྱམདྷྱེ བཧུསྟྲིཡོ རུདཏྱོ ཝིལཔནྟྱཤྩ ཡཱིཤོཿ པཤྩཱད྄ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ཀིནྟུ ས ཝྱཱགྷུཊྱ ཏཱ ཨུཝཱཙ, ཧེ ཡིརཱུཤཱལམོ ནཱཪྻྱོ ཡུཡཾ མདརྠཾ ན རུདིཏྭཱ སྭཱརྠཾ སྭཱཔཏྱཱརྠཉྩ རུདིཏི; ");
INSERT INTO santib_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","པཤྱཏ ཡཿ ཀདཱཔི གརྦྷཝཏྱོ ནཱབྷཝན྄ སྟནྱཉྩ ནཱཔཱཡཡན྄ ཏཱདྲྀཤཱི ཪྻནྡྷྱཱ ཡདཱ དྷནྱཱ ཝཀྵྱནྟི ས ཀཱལ ཨཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ཏདཱ ཧེ ཤཻལཱ ཨསྨཱཀམུཔརི པཏཏ, ཧེ ཨུཔཤཻལཱ ཨསྨཱནཱཙྪཱདཡཏ ཀཐཱམཱིདྲྀཤཱིཾ ལོཀཱ ཝཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ཡཏཿ སཏེཛསི ཤཱཁིནི ཙེདེཏད྄ གྷཊཏེ ཏརྷི ཤུཥྐཤཱཁིནི ཀིཾ ན གྷཊིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ཏདཱ ཏེ ཧནྟུཾ དྭཱཝཔརཱདྷིནཽ ཏེན སཱརྡྡྷཾ ནིནྱུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ཨཔརཾ ཤིརཿཀཔཱལནཱམཀསྠཱནཾ པྲཱཔྱ ཏཾ ཀྲུཤེ ཝིཝིདྷུཿ; ཏདྡྭཡོརཔརཱདྷིནོརེཀཾ ཏསྱ དཀྵིཎོ ཏདནྱཾ ཝཱམེ ཀྲུཤེ ཝིཝིདྷུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ཏདཱ ཡཱིཤུརཀཐཡཏ྄, ཧེ པིཏརེཏཱན྄ ཀྵམསྭ ཡཏ ཨེཏེ ཡཏ྄ ཀརྨྨ ཀུཪྻྭནྟི ཏན྄ ན ཝིདུཿ; པཤྩཱཏྟེ གུཊིཀཱཔཱཏཾ ཀྲྀཏྭཱ ཏསྱ ཝསྟྲཱཎི ཝིབྷཛྱ ཛགྲྀཧུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ཏཏྲ ལོཀསཾགྷསྟིཥྛན྄ དདརྴ; ཏེ ཏེཥཱཾ ཤཱསཀཱཤྩ ཏམུཔཧསྱ ཛགདུཿ, ཨེཥ ཨིཏརཱན྄ རཀྵིཏཝཱན྄ ཡདཱིཤྭརེཎཱབྷིརུཙིཏོ ྅བྷིཥིཀྟསྟྲཱཏཱ བྷཝཏི ཏརྷི སྭམདྷུནཱ རཀྵཏུ། ");
INSERT INTO santib_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ཏདནྱཿ སེནཱགཎཱ ཨེཏྱ ཏསྨཻ ཨམླརསཾ དཏྭཱ པརིཧསྱ པྲོཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ཙེཏྟྭཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱསི ཏརྷི སྭཾ རཀྵ། ");
INSERT INTO santib_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ཡིཧཱུདཱིཡཱནཱཾ རཱཛེཏི ཝཱཀྱཾ ཡཱུནཱནཱིཡརོམཱིཡེབྲཱིཡཱཀྵརཻ རླིཁིཏཾ ཏཙྪིརས ཨཱུརྡྡྷྭེ྅སྠཱཔྱཏ། ");
INSERT INTO santib_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ཏདོབྷཡཔཱརྴྭཡོ ཪྻིདྡྷཽ ཡཱཝཔརཱདྷིནཽ ཏཡོརེཀསྟཾ ཝིནིནྡྱ བབྷཱཥེ, ཙེཏྟྭམ྄ ཨབྷིཥིཀྟོསི ཏརྷི སྭམཱཝཱཉྩ རཀྵ། ");
INSERT INTO santib_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ཀིནྟྭནྱསྟཾ ཏརྫཡིཏྭཱཝདཏ྄, ཨཱིཤྭརཱཏྟཝ ཀིཉྩིདཔི བྷཡཾ ནཱསྟི ཀིཾ? ཏྭམཔི སམཱནདཎྜོསི, ");
INSERT INTO santib_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ཡོགྱཔཱཏྲེ ཨཱཝཱཾ སྭསྭཀརྨྨཎཱཾ སམུཙིཏཕལཾ པྲཱཔྣུཝཿ ཀིནྟྭནེན ཀིམཔི ནཱཔརཱདྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ཨཐ ས ཡཱིཤུཾ ཛགཱད ཧེ པྲབྷེ བྷཝཱན྄ སྭརཱཛྱཔྲཝེཤཀཱལེ མཱཾ སྨརཏུ། ");
INSERT INTO santib_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ཏདཱ ཡཱིཤུཿ ཀཐིཏཝཱན྄ ཏྭཱཾ ཡཐཱརྠཾ ཝདཱམི ཏྭམདྱཻཝ མཡཱ སཱརྡྡྷཾ པརལོཀསྱ སུཁསྠཱནཾ པྲཱཔྶྱསི། ");
INSERT INTO santib_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ཨཔརཉྩ དྭིཏཱིཡཡཱམཱཏ྄ ཏྲྀཏཱིཡཡཱམཔཪྻྱནྟཾ རཝེསྟེཛསོནྟརྷིཏཏྭཱཏ྄ སཪྻྭདེཤོ྅ནྡྷཀཱརེཎཱཝྲྀཏོ ");
INSERT INTO santib_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","མནྡིརསྱ ཡཝནིཀཱ ཙ ཚིདྱམཱནཱ དྭིདྷཱ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ཏཏོ ཡཱིཤུརུཙྩཻརུཝཱཙ, ཧེ པིཏ རྨམཱཏྨཱནཾ ཏཝ ཀརེ སམརྤཡེ, ཨིཏྱུཀྟྭཱ ས པྲཱཎཱན྄ ཛཧཽ། ");
INSERT INTO santib_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ཏདཻཏཱ གྷཊནཱ དྲྀཥྚྭཱ ཤཏསེནཱཔཏིརཱིཤྭརཾ དྷནྱམུཀྟྭཱ ཀཐིཏཝཱན྄ ཨཡཾ ནིཏཱནྟཾ སཱདྷུམནུཥྱ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ཨཐ ཡཱཝནྟོ ལོཀཱ དྲཥྚུམ྄ ཨཱགཏཱསྟེ ཏཱ གྷཊནཱ དྲྀཥྚྭཱ ཝཀྵཿསུ ཀརཱགྷཱཏཾ ཀྲྀཏྭཱ ཝྱཱཙུཊྱ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ཡཱིཤོ རྫྙཱཏཡོ ཡཱ ཡཱ ཡོཥིཏཤྩ གཱལཱིལསྟེན སཱརྡྡྷམཱཡཱཏཱསྟཱ ཨཔི དཱུརེ སྠིཏྭཱ ཏཏ྄ སཪྻྭཾ དདྲྀཤུཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ཏདཱ ཡིཧཱུདཱིཡཱནཱཾ མནྟྲཎཱཾ ཀྲིཡཱཉྩཱསམྨནྱམཱན ཨཱིཤྭརསྱ རཱཛཏྭམ྄ ཨཔེཀྵམཱཎོ ");
INSERT INTO santib_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ཡིཧཱུདིདེཤཱིཡོ ྅རིམཐཱིཡནགརཱིཡོ ཡཱུཥཕྣཱམཱ མནྟྲཱི བྷདྲོ དྷཱརྨྨིཀཤྩ པུམཱན྄ ");
INSERT INTO santib_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","པཱིལཱཏཱནྟིཀཾ གཏྭཱ ཡཱིཤོ རྡེཧཾ ཡཡཱཙེ། ");
INSERT INTO santib_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","པཤྩཱད྄ ཝཔུརཝརོཧྱ ཝཱསསཱ སཾཝེཥྚྱ ཡཏྲ ཀོཔི མཱནུཥོ ནཱསྠཱཔྱཏ ཏསྨིན྄ ཤཻལེ སྭཱཏེ ཤྨཤཱནེ ཏདསྠཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ཏདྡིནམཱཡོཛནཱིཡཾ དིནཾ ཝིཤྲཱམཝཱརཤྩ སམཱིཔཿ། ");
INSERT INTO santib_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ཨཔརཾ ཡཱིཤུནཱ སཱརྡྡྷཾ གཱལཱིལ ཨཱགཏཱ ཡོཥིཏཿ པཤྩཱདིཏྭཱ ཤྨཤཱནེ ཏཏྲ ཡཐཱ ཝཔུཿ སྠཱཔིཏཾ ཏཙྩ དྲྀཥྚྭཱ ");
INSERT INTO santib_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ཝྱཱགྷུཊྱ སུགནྡྷིདྲཝྱཏཻལཱནི ཀྲྀཏྭཱ ཝིདྷིཝད྄ ཝིཤྲཱམཝཱརེ ཝིཤྲཱམཾ ཙཀྲུཿ། ");
INSERT INTO santib_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ཨཐ སཔྟཱཧཔྲཐམདིནེ྅ཏིཔྲཏྱཱུཥེ ཏཱ ཡོཥིཏཿ སམྤཱདིཏཾ སུགནྡྷིདྲཝྱཾ གྲྀཧཱིཏྭཱ ཏདནྱཱབྷིཿ ཀིཡཏཱིབྷིཿ སྟྲཱིབྷིཿ སཧ ཤྨཤཱནཾ ཡཡུཿ། ");
INSERT INTO santib_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ཀིནྟུ ཤྨཤཱནདྭཱརཱཏ྄ པཱཥཱཎམཔསཱརིཏཾ དྲྀཥྚྭཱ ");
INSERT INTO santib_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ཏཱཿ པྲཝིཤྱ པྲབྷོ རྡེཧམཔྲཱཔྱ ");
INSERT INTO santib_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ཝྱཱཀུལཱ བྷཝནྟི ཨེཏརྷི ཏེཛོམཡཝསྟྲཱནྭིཏཽ དྭཽ པུརུཥཽ ཏཱསཱཾ སམཱིཔེ སམུཔསྠིཏཽ ");
INSERT INTO santib_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ཏསྨཱཏྟཱཿ ཤངྐཱཡུཀྟཱ བྷཱུམཱཝདྷོམུཁྱསྱསྠུཿ། ཏདཱ ཏཽ ཏཱ ཨཱུཙཏུ རྨྲྀཏཱནཱཾ མདྷྱེ ཛཱིཝནྟཾ ཀུཏོ མྲྀགཡཐ? ");
INSERT INTO santib_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","སོཏྲ ནཱསྟི ས ཨུདསྠཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","པཱཔིནཱཾ ཀརེཥུ སམརྤིཏེན ཀྲུཤེ ཧཏེན ཙ མནུཥྱཔུཏྲེཎ ཏྲྀཏཱིཡདིཝསེ ཤྨཤཱནཱདུཏྠཱཏཝྱམ྄ ཨིཏི ཀཐཱཾ ས གལཱིལི ཏིཥྛན྄ ཡུཥྨབྷྱཾ ཀཐིཏཝཱན྄ ཏཱཾ སྨརཏ། ");
INSERT INTO santib_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ཏདཱ ཏསྱ སཱ ཀཐཱ ཏཱསཱཾ མནཿསུ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ཨནནྟརཾ ཤྨཤཱནཱད྄ གཏྭཱ ཏཱ ཨེཀཱདཤཤིཥྱཱདིབྷྱཿ སཪྻྭེབྷྱསྟཱཾ ཝཱརྟྟཱཾ ཀཐཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","མགྡལཱིནཱིམརིཡམ྄, ཡོཧནཱ, ཡཱཀཱུབོ མཱཏཱ མརིཡམ྄ ཏདནྱཱཿ སངྒིནྱོ ཡོཥིཏཤྩ པྲེརིཏེབྷྱ ཨེཏཱཿ སཪྻྭཱ ཝཱརྟྟཱཿ ཀཐཡཱམཱསུཿ ");
INSERT INTO santib_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ཀིནྟུ ཏཱསཱཾ ཀཐཱམ྄ ཨནརྠཀཱཁྱཱནམཱཏྲཾ བུདྡྷྭཱ ཀོཔི ན པྲཏྱཻཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ཏདཱ པིཏར ཨུཏྠཱཡ ཤྨཤཱནཱནྟིཀཾ དདྷཱཝ, ཏཏྲ ཙ པྲཧྭོ བྷཱུཏྭཱ པཱརྴྭཻཀསྠཱཔིཏཾ ཀེཝལཾ ཝསྟྲཾ དདརྴ; ཏསྨཱདཱཤྩཪྻྱཾ མནྱམཱནོ ཡདགྷཊཏ ཏནྨནསི ཝིཙཱརཡན྄ པྲཏསྠེ། ");
INSERT INTO santib_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ཏསྨིནྣེཝ དིནེ དྭཽ ཤིཡྻཽ ཡིརཱུཤཱལམཤྩཏུཥྐྲོཤཱནྟརིཏམ྄ ཨིམྨཱཡུགྲཱམཾ གཙྪནྟཽ ");
INSERT INTO santib_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ཏཱསཱཾ གྷཊནཱནཱཾ ཀཐཱམཀཐཡཏཱཾ ");
INSERT INTO santib_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ཏཡོརཱལཱཔཝིཙཱརཡོཿ ཀཱལེ ཡཱིཤུརཱགཏྱ ཏཱབྷྱཱཾ སཧ ཛགཱམ ");
INSERT INTO santib_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ཀིནྟུ ཡཐཱ ཏཽ ཏཾ ན པརིཙིནུཏསྟདརྠཾ ཏཡོ རྡྲྀཥྚིཿ སཾརུདྡྷཱ། ");
INSERT INTO santib_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ས ཏཽ པྲྀཥྚཝཱན྄ ཡུཝཱཾ ཝིཥཎྞཽ ཀིཾ ཝིཙཱརཡནྟཽ གཙྪཐཿ? ");
INSERT INTO santib_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ཏཏསྟཡོཿ ཀླིཡཔཱནཱམཱ པྲཏྱུཝཱཙ ཡིརཱུཤཱལམཔུརེ྅དྷུནཱ ཡཱནྱགྷཊནྟ ཏྭཾ ཀེཝལཝིདེཤཱི ཀིཾ ཏདྭྲྀཏྟཱནྟཾ ན ཛཱནཱསི? ");
INSERT INTO santib_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ས པཔྲཙྪ ཀཱ གྷཊནཱཿ? ཏདཱ ཏཽ ཝཀྟུམཱརེབྷཱཏེ ཡཱིཤུནཱམཱ ཡོ ནཱསརཏཱིཡོ བྷཝིཥྱདྭཱདཱི ཨཱིཤྭརསྱ མཱནུཥཱཎཱཉྩ སཱཀྵཱཏ྄ ཝཱཀྱེ ཀརྨྨཎི ཙ ཤཀྟིམཱནཱསཱིཏ྄ ");
INSERT INTO santib_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ཏམ྄ ཨསྨཱཀཾ པྲདྷཱནཡཱཛཀཱ ཝིཙཱརཀཱཤྩ ཀེནཱཔི པྲཀཱརེཎ ཀྲུཤེ ཝིདྡྷྭཱ ཏསྱ པྲཱཎཱནནཱཤཡན྄ ཏདཱིཡཱ གྷཊནཱཿ; ");
INSERT INTO santib_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ཀིནྟུ ཡ ཨིསྲཱཡེལཱིཡལོཀཱན྄ ཨུདྡྷཱརཡིཥྱཏི ས ཨེཝཱཡམ྄ ཨིཏྱཱཤཱསྨཱབྷིཿ ཀྲྀཏཱ། ཏདྱཐཱ ཏཐཱསྟུ ཏསྱཱ གྷཊནཱཡཱ ཨདྱ དིནཏྲཡཾ གཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ཨདྷིཀནྟྭསྨཱཀཾ སངྒིནཱིནཱཾ ཀིཡཏྶྟྲཱིཎཱཾ མུཁེབྷྱོ྅སམྦྷཝཝཱཀྱམིདཾ ཤྲུཏཾ; ");
INSERT INTO santib_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ཏཱཿ པྲཏྱཱུཥེ ཤྨཤཱནཾ གཏྭཱ ཏཏྲ ཏསྱ དེཧམ྄ ཨཔྲཱཔྱ ཝྱཱགྷུཊྱེཏྭཱ པྲོཀྟཝཏྱཿ སྭརྒཱིསདཱུཏཽ དྲྀཥྚཱཝསྨཱབྷིསྟཽ ཙཱཝཱདིཥྚཱཾ ས ཛཱིཝིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ཏཏོསྨཱཀཾ ཀཻཤྩིཏ྄ ཤྨཤཱནམགམྱཏ ཏེ྅པི སྟྲཱིཎཱཾ ཝཱཀྱཱནུརཱུཔཾ དྲྀཥྚཝནྟཿ ཀིནྟུ ཏཾ ནཱཔཤྱན྄། ");
INSERT INTO santib_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ཏདཱ ས ཏཱཝུཝཱཙ, ཧེ ཨབོདྷཽ ཧེ བྷཝིཥྱདྭཱདིབྷིརུཀྟཝཱཀྱཾ པྲཏྱེཏུཾ ཝིལམྦམཱནཽ; ");
INSERT INTO santib_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ཨེཏཏྶཪྻྭདུཿཁཾ བྷུཀྟྭཱ སྭབྷཱུཏིཔྲཱཔྟིཿ ཀིཾ ཁྲཱིཥྚསྱ ན ནྱཱཡྻཱ? ");
INSERT INTO santib_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ཏཏཿ ས མཱུསཱགྲནྠམཱརབྷྱ སཪྻྭབྷཝིཥྱདྭཱདིནཱཾ སཪྻྭཤཱསྟྲེ སྭསྨིན྄ ལིཁིཏཱཁྱཱནཱབྷིཔྲཱཡཾ བོདྷཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ཨཐ གམྱགྲཱམཱབྷྱརྞཾ པྲཱཔྱ ཏེནཱགྲེ གམནལཀྵཎེ དརྴིཏེ ");
INSERT INTO santib_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ཏཽ སཱདྷཡིཏྭཱཝདཏཱཾ སཧཱཝཱབྷྱཱཾ ཏིཥྛ དིནེ གཏེ སཏི རཱཏྲིརབྷཱུཏ྄; ཏཏཿ ས ཏཱབྷྱཱཾ སཱརྡྡྷཾ སྠཱཏུཾ གྲྀཧཾ ཡཡཽ། ");
INSERT INTO santib_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","པཤྩཱདྦྷོཛནོཔཝེཤཀཱལེ ས པཱུཔཾ གྲྀཧཱིཏྭཱ ཨཱིཤྭརགུཎཱན྄ ཛགཱད ཏཉྩ བྷཾཀྟྭཱ ཏཱབྷྱཱཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ཏདཱ ཏཡོ རྡྲྀཥྚཽ པྲསནྣཱཡཱཾ ཏཾ པྲཏྱབྷིཛྙཏུཿ ཀིནྟུ ས ཏཡོཿ སཱཀྵཱདནྟརྡདྷེ། ");
INSERT INTO santib_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ཏཏསྟཽ མིཐོབྷིདྷཱཏུམ྄ ཨཱརབྡྷཝནྟཽ གམནཀཱལེ ཡདཱ ཀཐཱམཀཐཡཏ྄ ཤཱསྟྲཱརྠཉྩབོདྷཡཏ྄ ཏདཱཝཡོ རྦུདྡྷིཿ ཀིཾ ན པྲཱཛྭལཏ྄? ");
INSERT INTO santib_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ཏཽ ཏཏྐྵཎཱདུཏྠཱཡ ཡིརཱུཤཱལམཔུརཾ པྲཏྱཱཡཡཏུཿ, ཏཏྶྠཱནེ ཤིཥྱཱཎཱམ྄ ཨེཀཱདཤཱནཱཾ སངྒིནཱཉྩ དརྴནཾ ཛཱཏཾ། ");
INSERT INTO santib_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ཏེ པྲོཙུཿ པྲབྷུརུདཏིཥྛད྄ ཨིཏི སཏྱཾ ཤིམོནེ དརྴནམདཱཙྩ། ");
INSERT INTO santib_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ཏཏཿ པཐཿ སཪྻྭགྷཊནཱཡཱཿ པཱུཔབྷཉྫནེན ཏཏྤརིཙཡསྱ ཙ སཪྻྭཝྲྀཏྟཱནྟཾ ཏཽ ཝཀྟུམཱརེབྷཱཏེ། ");
INSERT INTO santib_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ཨིཏྠཾ ཏེ པརསྤརཾ ཝདནྟི ཏཏྐཱལེ ཡཱིཤུཿ སྭཡཾ ཏེཥཱཾ མདྷྱ པྲོཏྠཡ ཡུཥྨཱཀཾ ཀལྱཱཎཾ བྷཱུཡཱད྄ ཨིཏྱུཝཱཙ, ");
INSERT INTO santib_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ཀིནྟུ བྷཱུཏཾ པཤྱཱམ ཨིཏྱནུམཱཡ ཏེ སམུདྭིཝིཛིརེ ཏྲེཥུཤྩ། ");
INSERT INTO santib_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ས ཨུཝཱཙ, ཀུཏོ དུཿཁིཏཱ བྷཝཐ? ཡུཥྨཱཀཾ མནཿསུ སནྡེཧ ཨུདེཏི ཙ ཀུཏཿ? ");
INSERT INTO santib_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ཨེཥོཧཾ, མམ ཀརཽ པཤྱཏ ཝརཾ སྤྲྀཥྚྭཱ པཤྱཏ, མམ ཡཱདྲྀཤཱནི པཤྱཐ ཏཱདྲྀཤཱནི བྷཱུཏསྱ མཱཾསཱསྠཱིནི ན སནྟི། ");
INSERT INTO santib_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ཨིཏྱུཀྟྭཱ ས ཧསྟཔཱདཱན྄ དརྴཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ཏེ྅སམྦྷཝཾ ཛྙཱཏྭཱ སཱནནྡཱ ན པྲཏྱཡན྄། ཏཏཿ ས ཏཱན྄ པཔྲཙྪ, ཨཏྲ ཡུཥྨཱཀཾ སམཱིཔེ ཁཱདྱཾ ཀིཉྩིདསྟི? ");
INSERT INTO santib_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ཏཏསྟེ ཀིཡདྡགྡྷམཏྶྱཾ མདྷུ ཙ དདུཿ ");
INSERT INTO santib_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ས ཏདཱདཱཡ ཏེཥཱཾ སཱཀྵཱད྄ བུབྷུཛེ ");
INSERT INTO santib_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ཀཐཡཱམཱས ཙ མཱུསཱཝྱཝསྠཱཡཱཾ བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ གཱིཏཔུསྟཀེ ཙ མཡི ཡཱནི སཪྻྭཱཎི ཝཙནཱནི ལིཁིཏཱནི ཏདནུརཱུཔཱཎི གྷཊིཥྱནྟེ ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ སྠིཏྭཱཧཾ ཡདེཏདྭཱཀྱམ྄ ཨཝདཾ ཏདིདཱནཱིཾ པྲཏྱཀྵམབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ཨཐ ཏེབྷྱཿ ཤཱསྟྲབོདྷཱདྷིཀཱརཾ དཏྭཱཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ཁྲཱིཥྚེནེཏྠཾ མྲྀཏིཡཱཏནཱ བྷོཀྟཝྱཱ ཏྲྀཏཱིཡདིནེ ཙ ཤྨཤཱནཱདུཏྠཱཏཝྱཉྩེཏི ལིཔིརསྟི; ");
INSERT INTO santib_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ཏནྣཱམྣཱ ཡིརཱུཤཱལམམཱརབྷྱ སཪྻྭདེཤེ མནཿཔརཱཝརྟྟནསྱ པཱཔམོཙནསྱ ཙ སུསཾཝཱདཿ པྲཙཱརཡིཏཝྱཿ, ");
INSERT INTO santib_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ཨེཥུ སཪྻྭེཥུ ཡཱུཡཾ སཱཀྵིཎཿ། ");
INSERT INTO santib_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ཨཔརཉྩ པཤྱཏ པིཏྲཱ ཡཏ྄ པྲཏིཛྙཱཏཾ ཏཏ྄ པྲེཥཡིཥྱཱམི, ཨཏཨེཝ ཡཱཝཏྐཱལཾ ཡཱུཡཾ སྭརྒཱིཡཱཾ ཤཀྟིཾ ན པྲཱཔྶྱཐ ཏཱཝཏྐཱལཾ ཡིརཱུཤཱལམྣགརེ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ཨཐ ས ཏཱན྄ བཻཐནཱིཡཱཔཪྻྱནྟཾ ནཱིཏྭཱ ཧསྟཱཝུཏྟོལྱ ཨཱཤིཥ ཝཀྟུམཱརེབྷེ ");
INSERT INTO santib_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ཨཱཤིཥཾ ཝདནྣེཝ ཙ ཏེབྷྱཿ པྲྀཐག྄ བྷཱུཏྭཱ སྭརྒཱཡ ནཱིཏོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ཏདཱ ཏེ ཏཾ བྷཛམཱནཱ མཧཱནནྡེན ཡིརཱུཤཱལམཾ པྲཏྱཱཛགྨུཿ། ");
INSERT INTO santib_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ཏཏོ ནིརནྟརཾ མནྡིརེ ཏིཥྛནྟ ཨཱིཤྭརསྱ པྲཤཾསཱཾ དྷནྱཝཱདཉྩ ཀརྟྟམ྄ ཨཱརེབྷིརེ། ཨིཏི༎ ");
INSERT INTO santib_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ཨཱདཽ ཝཱད ཨཱསཱིཏ྄ ས ཙ ཝཱད ཨཱིཤྭརེཎ སཱརྡྷམཱསཱིཏ྄ ས ཝཱདཿ སྭཡམཱིཤྭར ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ས ཨཱདཱཝཱིཤྭརེཎ སཧཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ཏེན སཪྻྭཾ ཝསྟུ སསྲྀཛེ སཪྻྭེཥུ སྲྀཥྚཝསྟུཥུ ཀིམཔི ཝསྟུ ཏེནཱསྲྀཥྚཾ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ས ཛཱིཝནསྱཱཀཱརཿ, ཏཙྩ ཛཱིཝནཾ མནུཥྱཱཎཱཾ ཛྱོཏིཿ ");
INSERT INTO santib_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ཏཛྫྱོཏིརནྡྷཀཱརེ པྲཙཀཱཤེ ཀིནྟྭནྡྷཀཱརསྟནྣ ཛགྲཱཧ། ");
INSERT INTO santib_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ཡོཧན྄ ནཱམཀ ཨེཀོ མནུཛ ཨཱིཤྭརེཎ པྲེཥཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ཏདྭཱརཱ ཡཐཱ སཪྻྭེ ཝིཤྭསནྟི ཏདརྠཾ ས ཏཛྫྱོཏིཥི པྲམཱཎཾ དཱཏུཾ སཱཀྵིསྭརཱུཔོ བྷཱུཏྭཱགམཏ྄, ");
INSERT INTO santib_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ས སྭཡཾ ཏཛྫྱོཏི རྣ ཀིནྟུ ཏཛྫྱོཏིཥི པྲམཱཎཾ དཱཏུམཱགམཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ཛགཏྱཱགཏྱ ཡཿ སཪྻྭམནུཛེབྷྱོ དཱིཔྟིཾ དདཱཏི ཏདེཝ སཏྱཛྱོཏིཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ས ཡཛྫགདསྲྀཛཏ྄ ཏནྨདྱ ཨེཝ ས ཨཱསཱིཏ྄ ཀིནྟུ ཛགཏོ ལོཀཱསྟཾ ནཱཛཱནན྄། ");
INSERT INTO santib_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ནིཛཱདྷིཀཱརཾ ས ཨཱགཙྪཏ྄ ཀིནྟུ པྲཛཱསྟཾ ནཱགྲྀཧླན྄། ");
INSERT INTO santib_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ཏཐཱཔི ཡེ ཡེ ཏམགྲྀཧླན྄ ཨརྠཱཏ྄ ཏསྱ ནཱམྣི ཝྱཤྭསན྄ ཏེབྷྱ ཨཱིཤྭརསྱ པུཏྲཱ བྷཝིཏུམ྄ ཨདྷིཀཱརམ྄ ཨདདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ཏེཥཱཾ ཛནིཿ ཤོཎིཏཱནྣ ཤཱརཱིརིཀཱབྷིལཱཥཱནྣ མཱནཝཱནཱམིཙྪཱཏོ ན ཀིནྟྭཱིཤྭརཱདབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ས ཝཱདོ མནུཥྱརཱུཔེཎཱཝཏཱིཪྻྱ སཏྱཏཱནུགྲཧཱབྷྱཱཾ པརིཔཱུརྞཿ སན྄ སཱརྡྷམ྄ ཨསྨཱབྷི རྣྱཝསཏ྄ ཏཏཿ པིཏུརདྭིཏཱིཡཔུཏྲསྱ ཡོགྱོ ཡོ མཧིམཱ ཏཾ མཧིམཱནཾ ཏསྱཱཔཤྱཱམ། ");
INSERT INTO santib_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ཏཏོ ཡོཧནཔི པྲཙཱཪྻྱ སཱཀྵྱམིདཾ དཏྟཝཱན྄ ཡོ མམ པཤྩཱད྄ ཨཱགམིཥྱཏི ས མཏྟོ གུརུཏརཿ; ཡཏོ མཏྤཱུཪྻྭཾ ས ཝིདྱམཱན ཨཱསཱིཏ྄; ཡདརྠམ྄ ཨཧཾ སཱཀྵྱམིདམ྄ ཨདཱཾ ས ཨེཥཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ཨཔརཉྩ ཏསྱ པཱུརྞཏཱཡཱ ཝཡཾ སཪྻྭེ ཀྲམཤཿ ཀྲམཤོནུགྲཧཾ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","མཱུསཱདྭཱརཱ ཝྱཝསྠཱ དཏྟཱ ཀིནྟྭནུགྲཧཿ སཏྱཏྭཉྩ ཡཱིཤུཁྲཱིཥྚདྭཱརཱ སམུཔཱཏིཥྛཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ཀོཔི མནུཛ ཨཱིཤྭརཾ ཀདཱཔི ནཱཔཤྱཏ྄ ཀིནྟུ པིཏུཿ ཀྲོཌསྠོ྅དྭིཏཱིཡཿ པུཏྲསྟཾ པྲཀཱཤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ཏྭཾ ཀཿ? ཨིཏི ཝཱཀྱཾ པྲེཥྚུཾ ཡདཱ ཡིཧཱུདཱིཡལོཀཱ ཡཱཛཀཱན྄ ལེཝིལོཀཱཾཤྩ ཡིརཱུཤཱལམོ ཡོཧནཿ སམཱིཔེ པྲེཥཡཱམཱསུཿ, ");
INSERT INTO santib_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ཏདཱ ས སྭཱིཀྲྀཏཝཱན྄ ནཱཔཧྣཱུཏཝཱན྄ ནཱཧམ྄ ཨབྷིཥིཀྟ ཨིཏྱངྒཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཏརྷི ཀོ བྷཝཱན྄? ཀིཾ ཨེལིཡཿ? སོཝདཏ྄ ན; ཏཏསྟེ྅པྲྀཙྪན྄ ཏརྷི བྷཝཱན྄ ས བྷཝིཥྱདྭཱདཱི? སོཝདཏ྄ ནཱཧཾ སཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཏརྷི བྷཝཱན྄ ཀཿ? ཝཡཾ གཏྭཱ པྲེརཀཱན྄ ཏྭཡི ཀིཾ ཝཀྵྱཱམཿ? སྭསྨིན྄ ཀིཾ ཝདསི? ");
INSERT INTO santib_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ཏདཱ སོཝདཏ྄། པརམེཤསྱ པནྠཱནཾ པརིཥྐུརུཏ སཪྻྭཏཿ། ཨིཏཱིདཾ པྲཱནྟརེ ཝཱཀྱཾ ཝདཏཿ ཀསྱཙིདྲཝཿ། ཀཐཱམིམཱཾ ཡསྨིན྄ ཡིཤཡིཡོ བྷཝིཥྱདྭཱདཱི ལིཁིཏཝཱན྄ སོཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ཡེ པྲེཥིཏཱསྟེ ཕིརཱུཤིལོཀཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཡདི ནཱབྷིཥིཀྟོསི ཨེལིཡོསི ན ས བྷཝིཥྱདྭཱདྱཔི ནཱསི ཙ, ཏརྷི ལོཀཱན྄ མཛྫཡསི ཀུཏཿ? ");
INSERT INTO santib_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ཏཏོ ཡོཧན྄ པྲཏྱཝོཙཏ྄, ཏོཡེ྅ཧཾ མཛྫཡཱམཱིཏི སཏྱཾ ཀིནྟུ ཡཾ ཡཱུཡཾ ན ཛཱནཱིཐ ཏཱདྲྀཤ ཨེཀོ ཛནོ ཡུཥྨཱཀཾ མདྷྱ ཨུཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ས མཏྤཤྩཱད྄ ཨཱགཏོཔི མཏྤཱུཪྻྭཾ ཝརྟྟམཱན ཨཱསཱིཏ྄ ཏསྱ པཱདུཀཱབནྡྷནཾ མོཙཡིཏུམཔི ནཱཧཾ ཡོགྱོསྨི། ");
INSERT INTO santib_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ཡརྡྡནནདྱཱཿ པཱརསྠབཻཐབཱརཱཡཱཾ ཡསྨིནྶྠཱནེ ཡོཧནམཛྫཡཏ྄ ཏསྨིན སྠཱནེ སཪྻྭམེཏད྄ ཨགྷཊཏ། ");
INSERT INTO santib_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","པརེ྅ཧནི ཡོཧན྄ སྭནིཀཊམཱགཙྪནྟཾ ཡིཤུཾ ཝིལོཀྱ པྲཱཝོཙཏ྄ ཛགཏཿ པཱཔམོཙཀམ྄ ཨཱིཤྭརསྱ མེཥཤཱཝཀཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ཡོ མམ པཤྩཱདཱགམིཥྱཏི ས མཏྟོ གུརུཏརཿ, ཡཏོ ཧེཏོརྨཏྤཱུཪྻྭཾ སོ྅ཝརྟྟཏ ཡསྨིནྣཧཾ ཀཐཱམིམཱཾ ཀཐིཏཝཱན྄ ས ཨེཝཱཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ཨཔརཾ ནཱཧམེནཾ པྲཏྱབྷིཛྙཱཏཝཱན྄ ཀིནྟུ ཨིསྲཱཡེལློཀཱ ཨེནཾ ཡཐཱ པརིཙིནྭནྟི ཏདབྷིཔྲཱཡེཎཱཧཾ ཛལེ མཛྫཡིཏུམཱགཙྪམ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","པུནཤྩ ཡོཧནཔརམེཀཾ པྲམཱཎཾ དཏྭཱ ཀཐིཏཝཱན྄ ཝིཧཱཡསཿ ཀཔོཏཝད྄ ཨཝཏརནྟམཱཏྨཱནམ྄ ཨསྱོཔཪྻྱཝཏིཥྛནྟཾ ཙ དྲྀཥྚཝཱནཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ནཱཧམེནཾ པྲཏྱབྷིཛྙཱཏཝཱན྄ ཨིཏི སཏྱཾ ཀིནྟུ ཡོ ཛལེ མཛྫཡིཏུཾ མཱཾ པྲཻརཡཏ྄ ས ཨེཝེམཱཾ ཀཐཱམཀཐཡཏ྄ ཡསྱོཔཪྻྱཱཏྨཱནམ྄ ཨཝཏརནྟམ྄ ཨཝཏིཥྛནྟཉྩ དྲཀྵཡསི སཨེཝ པཝིཏྲེ ཨཱཏྨནི མཛྫཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ཨཝསྟནྣིརཱིཀྵྱཱཡམ྄ ཨཱིཤྭརསྱ ཏནཡ ཨིཏི པྲམཱཎཾ དདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","པརེ྅ཧནི ཡོཧན྄ དྭཱབྷྱཱཾ ཤིཥྱཱབྷྱཱཾ སཱརྡྡྷེཾ ཏིཥྛན྄ ");
INSERT INTO santib_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ཡིཤུཾ གཙྪནྟཾ ཝིལོཀྱ གདིཏཝཱན྄, ཨཱིཤྭརསྱ མེཥཤཱཝཀཾ པཤྱཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ཨིམཱཾ ཀཐཱཾ ཤྲུཏྭཱ དྭཽ ཤིཥྱཽ ཡཱིཤོཿ པཤྩཱད྄ ཨཱིཡཏུཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ཏཏོ ཡཱིཤུཿ པརཱཝྲྀཏྱ ཏཽ པཤྩཱད྄ ཨཱགཙྪནྟཽ དྲྀཥྚྭཱ པྲྀཥྚཝཱན྄ ཡུཝཱཾ ཀིཾ གཝེཤཡཐཿ? ཏཱཝཔྲྀཙྪཏཱཾ ཧེ རབྦི ཨརྠཱཏ྄ ཧེ གུརོ བྷཝཱན྄ ཀུཏྲ ཏིཥྛཏི? ");
INSERT INTO santib_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ཏཏཿ སོཝཱདིཏ྄ ཨེཏྱ པཤྱཏཾ། ཏཏོ དིཝསསྱ ཏྲྀཏཱིཡཔྲཧརསྱ གཏཏྭཱཏ྄ ཏཽ ཏདྡིནཾ ཏསྱ སངྒེ྅སྠཱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ཡཽ དྭཽ ཡོཧནོ ཝཱཀྱཾ ཤྲུཏྭཱ ཡིཤོཿ པཤྩཱད྄ ཨཱགམཏཱཾ ཏཡོཿ ཤིམོནྤིཏརསྱ བྷྲཱཏཱ ཨཱནྡྲིཡཿ ");
INSERT INTO santib_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ས ཨིཏྭཱ པྲཐམཾ ནིཛསོདརཾ ཤིམོནཾ སཱཀྵཱཏྤྲཱཔྱ ཀཐིཏཝཱན྄ ཝཡཾ ཁྲཱིཥྚམ྄ ཨརྠཱཏ྄ ཨབྷིཥིཀྟཔུརུཥཾ སཱཀྵཱཏྐྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","པཤྩཱཏ྄ ས ཏཾ ཡིཤོཿ སམཱིཔམ྄ ཨཱནཡཏ྄། ཏདཱ ཡཱིཤུསྟཾ དྲྀཥྚྭཱཝདཏ྄ ཏྭཾ ཡཱུནསཿ པུཏྲཿ ཤིམོན྄ ཀིནྟུ ཏྭནྣཱམདྷེཡཾ ཀཻཕཱཿ ཝཱ པིཏརཿ ཨརྠཱཏ྄ པྲསྟརོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","པརེ྅ཧནི ཡཱིཤཽ གཱལཱིལཾ གནྟུཾ ནིཤྩིཏཙེཏསི སཏི ཕིལིཔནཱམཱནཾ ཛནཾ སཱཀྵཱཏྤྲཱཔྱཱཝོཙཏ྄ མམ པཤྩཱད྄ ཨཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","བཻཏྶཻདཱནཱམྣི ཡསྨིན྄ གྲཱམེ པིཏརཱནྡྲིཡཡོཪྻཱས ཨཱསཱིཏ྄ ཏསྨིན྄ གྲཱམེ ཏསྱ ཕིལིཔསྱ ཝསཏིརཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","པཤྩཱཏ྄ ཕིལིཔོ ནིཐནེལཾ སཱཀྵཱཏྤྲཱཔྱཱཝདཏ྄ མཱུསཱ ཝྱཝསྠཱ གྲནྠེ བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ ཙ ཡསྱཱཁྱཱནཾ ལིཁིཏམཱསྟེ ཏཾ ཡཱུཥཕཿ པུཏྲཾ ནཱསརཏཱིཡཾ ཡཱིཤུཾ སཱཀྵཱད྄ ཨཀཱརྵྨ ཝཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ཏདཱ ནིཐནེལ྄ ཀཐིཏཝཱན྄ ནཱསརནྣགརཱཏ ཀིཾ ཀཤྩིདུཏྟམ ཨུཏྤནྟུཾ ཤཀྣོཏི? ཏཏཿ ཕིལིཔོ ྅ཝོཙཏ྄ ཨེཏྱ པཤྱ། ");
INSERT INTO santib_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ཨཔརཉྩ ཡཱིཤུཿ སྭསྱ སམཱིཔཾ ཏམ྄ ཨཱགཙྪནྟཾ དྲྀཥྚྭཱ ཝྱཱཧྲྀཏཝཱན྄, པཤྱཱཡཾ ནིཥྐཔཊཿ སཏྱ ཨིསྲཱཡེལློཀཿ། ");
INSERT INTO santib_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ཏཏཿ སོཝདད྄, བྷཝཱན྄ མཱཾ ཀཐཾ པྲཏྱབྷིཛཱནཱཏི? ཡཱིཤུརཝཱདཱིཏ྄ ཕིལིཔསྱ ཨཱཧྭཱནཱཏ྄ པཱུཪྻྭཾ ཡདཱ ཏྭམུཌུམྦརསྱ ཏརོརྨཱུལེ྅སྠཱསྟདཱ ཏྭཱམདརྴམ྄། ");
INSERT INTO santib_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ནིཐནེལ྄ ཨཙཀཐཏ྄, ཧེ གུརོ བྷཝཱན྄ ནིཏཱནྟམ྄ ཨཱིཤྭརསྱ པུཏྲོསི, བྷཝཱན྄ ཨིསྲཱཡེལྭཾཤསྱ རཱཛཱ། ");
INSERT INTO santib_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ཏཏོ ཡཱིཤུ ཪྻྱཱཧརཏ྄, ཏྭཱམུཌུམྦརསྱ པཱདཔསྱ མཱུལེ དྲྀཥྚཝཱནཱཧཾ མམཻཏསྨཱདྭཱཀྱཱཏ྄ ཀིཾ ཏྭཾ ཝྱཤྭསཱིཿ? ཨེཏསྨཱདཔྱཱཤྩཪྻྱཱཎི ཀཱཪྻྱཱཎི དྲཀྵྱསི། ");
INSERT INTO santib_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ཨནྱཙྩཱཝཱདཱིད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཾ ཝདཱམི, ཨིཏཿ པརཾ མོཙིཏེ མེགྷདྭཱརེ ཏསྨཱནྨནུཛསཱུནུནཱ ཨཱིཤྭརསྱ དཱུཏགཎམ྄ ཨཝརོཧནྟམཱརོཧནྟཉྩ དྲཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ཨནནྟརཾ ཏྲུཏཱིཡདིཝསེ གཱལཱིལ྄ པྲདེཤིཡེ ཀཱནྣཱནཱམྣི ནགརེ ཝིཝཱཧ ཨཱསཱིཏ྄ ཏཏྲ ཙ ཡཱིཤོརྨཱཏཱ ཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ཏསྨཻ ཝིཝཱཧཱཡ ཡཱིཤུསྟསྱ ཤིཥྱཱཤྩ ནིམནྟྲིཏཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ཏདནནྟརཾ དྲཱཀྵཱརསསྱ ནྱཱུནཏྭཱད྄ ཡཱིཤོརྨཱཏཱ ཏམཝདཏ྄ ཨེཏེཥཱཾ དྲཱཀྵཱརསོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ཏདཱ ས ཏཱམཝོཙཏ྄ ཧེ ནཱརི མཡཱ སཧ ཏཝ ཀིཾ ཀཱཪྻྱཾ? མམ སམཡ ཨིདཱནཱིཾ ནོཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ཏཏསྟསྱ མཱཏཱ དཱསཱནཝོཙད྄ ཨཡཾ ཡད྄ ཝདཏི ཏདེཝ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ཏསྨིན྄ སྠཱནེ ཡིཧཱུདཱིཡཱནཱཾ ཤུཙིཏྭཀརཎཝྱཝཧཱརཱནུསཱརེཎཱཌྷཀཻཀཛལདྷརཱཎི པཱཥཱཎམཡཱནི ཥཌྭྲྀཧཏྤཱཏྲཱཎིཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ཏདཱ ཡཱིཤུསྟཱན྄ སཪྻྭཀལཤཱན྄ ཛལཻཿ པཱུརཡིཏུཾ ཏཱནཱཛྙཱཔཡཏ྄, ཏཏསྟེ སཪྻྭཱན྄ ཀུམྦྷཱནཱཀརྞཾ ཛལཻཿ པཪྻྱཔཱུརཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ཨཐ ཏེབྷྱཿ ཀིཉྩིདུཏྟཱཪྻྱ བྷོཛྱཱདྷིཔཱཏེཿསམཱིཔཾ ནེཏུཾ ས ཏཱནཱདིཤཏ྄, ཏེ ཏདནཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ཨཔརཉྩ ཏཛྫལཾ ཀཐཾ དྲཱཀྵཱརསོ྅བྷཝཏ྄ ཏཛྫལཝཱཧཀཱདཱསཱ ཛྙཱཏུཾ ཤཀྟཱཿ ཀིནྟུ ཏདྦྷོཛྱཱདྷིཔོ ཛྙཱཏུཾ ནཱཤཀྣོཏ྄ ཏདཝལིཧྱ ཝརཾ སཾམྦོདྱཱཝདཏ, ");
INSERT INTO santib_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ལོཀཱཿ པྲཐམཾ ཨུཏྟམདྲཱཀྵཱརསཾ དདཏི ཏཥུ ཡཐེཥྚཾ པིཏཝཏྶུ ཏསྨཱ ཀིཉྩིདནུཏྟམཉྩ དདཏི ཀིནྟུ ཏྭམིདཱནཱིཾ ཡཱཝཏ྄ ཨུཏྟམདྲཱཀྵཱརསཾ སྠཱཔཡསི། ");
INSERT INTO santib_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ཨིཏྠཾ ཡཱིཤུརྒཱལཱིལཔྲདེཤེ ཨཱཤྩཪྻྱཀཱརྨྨ པྲཱརམྦྷ ནིཛམཧིམཱནཾ པྲཱཀཱཤཡཏ྄ ཏཏཿ ཤིཥྱཱསྟསྨིན྄ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ཏཏཿ པརམ྄ ས ནིཛམཱཏྲུབྷྲཱཏྲུསྴིཥྱཻཿ སཱརྡྡྷ྄ཾ ཀཕརྣཱཧཱུམམ྄ ཨཱགམཏ྄ ཀིནྟུ ཏཏྲ བཧཱུདིནཱནི ཨཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ཏདནནྟརཾ ཡིཧཱུདིཡཱནཱཾ ནིསྟཱརོཏྶཝེ ནིཀཊམཱགཏེ ཡཱིཤུ ཪྻིརཱུཤཱལམ྄ ནགརམ྄ ཨཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ཏཏོ མནྡིརསྱ མདྷྱེ གོམེཥཔཱརཱཝཏཝིཀྲཡིཎོ ཝཱཎིཛཀྵྩོཔཝིཥྚཱན྄ ཝིལོཀྱ ");
INSERT INTO santib_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","རཛྫུབྷིཿ ཀཤཱཾ ནིརྨྨཱཡ སཪྻྭགོམེཥཱདིབྷིཿ སཱརྡྡྷཾ ཏཱན྄ མནྡིརཱད྄ དཱུརཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ཝཎིཛཱཾ མུདྲཱདི ཝིཀཱིཪྻྱ ཨཱསནཱནི ནྱཱུབྫཱིཀྲྀཏྱ པཱརཱཝཏཝིཀྲཡིབྷྱོ྅ཀཐཡད྄ ཨསྨཱཏ྄ སྠཱནཱཏ྄ སཪྻཱཎྱེཏཱནི ནཡཏ, མམ པིཏུགྲྀཧཾ ཝཱཎིཛྱགྲྀཧཾ མཱ ཀཱརྵྚ། ");
INSERT INTO santib_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ཏསྨཱཏ྄ ཏནྨནྡིརཱརྠ ཨུདྱོགོ ཡསྟུ ས གྲསཏཱིཝ མཱམ྄། ཨིམཱཾ ཤཱསྟྲཱིཡལིཔིཾ ཤིཥྱཱཿསམསྨརན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ཏཏཿ པརམ྄ ཡིཧཱུདཱིཡལོཀཱ ཡཱིཥིམཝདན྄ ཏཝམིདྲྀཤཀརྨྨཀརཎཱཏ྄ ཀིཾ ཙིཧྣམསྨཱན྄ དརྴཡསི? ");
INSERT INTO santib_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ཏཏོ ཡཱིཤུསྟཱནཝོཙད྄ ཡུཥྨཱབྷིརེ ཏསྨིན྄ མནྡིརེ ནཱཤིཏེ དིནཏྲཡམདྷྱེ྅ཧཾ ཏད྄ ཨུཏྠཱཔཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ཏདཱ ཡིཧཱུདིཡཱ ཝྱཱཧཱརྵུཿ, ཨེཏསྱ མནྡིརས ནིརྨྨཱཎེན ཥཊྩཏྭཱརིཾཤད྄ ཝཏྶརཱ གཏཱཿ, ཏྭཾ ཀིཾ དིནཏྲཡམདྷྱེ ཏད྄ ཨུཏྠཱཔཡིཥྱསི? ");
INSERT INTO santib_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ཀིནྟུ ས ནིཛདེཧརཱུཔམནྡིརེ ཀཐཱམིམཱཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ས ཡདེཏཱདྲྀཤཾ གདིཏཝཱན྄ ཏཙྪིཥྱཱཿ ཤྨཤཱནཱཏ྄ ཏདཱིཡོཏྠཱནེ སཏི སྨྲྀཏྭཱ དྷརྨྨགྲནྠེ ཡཱིཤུནོཀྟཀཐཱཡཱཾ ཙ ཝྱཤྭསིཥུཿ། ");
INSERT INTO santib_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ཨནནྟརཾ ནིསྟཱརོཏྶཝསྱ བྷོཛྱསམཡེ ཡིརཱུཤཱལམ྄ ནགརེ ཏཏྐྲུཏཱཤྩཪྻྱཀརྨྨཱཎི ཝིལོཀྱ བཧུབྷིསྟསྱ ནཱམནི ཝིཤྭསིཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ཀིནྟུ ས ཏེཥཱཾ ཀརེཥུ སྭཾ ན སམརྤཡཏ྄, ཡཏཿ ས སཪྻྭཱནཝཻཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ས མཱནཝེཥུ ཀསྱཙིཏ྄ པྲམཱཎཾ ནཱཔེཀྵཏ ཡཏོ མནུཛཱནཱཾ མདྷྱེ ཡདྱདསྟི ཏཏྟཏ྄ སོཛཱནཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ནིཀདིམནཱམཱ ཡིཧཱུདཱིཡཱནཱམ྄ ཨདྷིཔཏིཿ ཕིརཱུཤཱི ཀྵཎདཱཡཱཾ ");
INSERT INTO santib_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ཡཱིཤཽརབྷྱརྞམ྄ ཨཱཝྲཛྱ ཝྱཱཧཱརྵཱིཏ྄, ཧེ གུརོ བྷཝཱན྄ ཨཱིཤྭརཱད྄ ཨཱགཏ྄ ཨེཀ ཨུཔདེཥྚཱ, ཨེཏད྄ ཨསྨཱབྷིརྫྙཱཡཏེ; ཡཏོ བྷཝཏཱ ཡཱནྱཱཤྩཪྻྱཀརྨྨཱཎི ཀྲིཡནྟེ པརམེཤྭརསྱ སཱཧཱཡྻཾ ཝིནཱ ཀེནཱཔི ཏཏྟཏྐརྨྨཱཎི ཀརྟྟུཾ ན ཤཀྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ཏདཱ ཡཱིཤུརུཏྟརཾ དཏྟཝཱན྄ ཏཝཱཧཾ ཡཐཱརྠཏརཾ ཝྱཱཧརཱམི པུནརྫནྨནི ན སཏི ཀོཔི མཱནཝ ཨཱིཤྭརསྱ རཱཛྱཾ དྲཥྚུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ཏཏོ ནིཀདཱིམཿ པྲཏྱཝོཙཏ྄ མནུཛོ ཝྲྀདྡྷོ བྷཱུཏྭཱ ཀཐཾ ཛནིཥྱཏེ? ས ཀིཾ པུན རྨཱཏྲྀརྫཋརཾ པྲཝིཤྱ ཛནིཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ཡཱིཤུརཝཱདཱིད྄ ཡཐཱརྠཏརམ྄ ཨཧཾ ཀཐཡཱམི མནུཛེ ཏོཡཱཏྨབྷྱཱཾ པུན རྣ ཛཱཏེ ས ཨཱིཤྭརསྱ རཱཛྱཾ པྲཝེཥྚུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","མཱཾསཱད྄ ཡཏ྄ ཛཱཡཏེ ཏན྄ མཱཾསམེཝ ཏཐཱཏྨནོ ཡོ ཛཱཡཏེ ས ཨཱཏྨཻཝ། ");
INSERT INTO santib_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ཡུཥྨཱབྷིཿ པུན རྫནིཏཝྱཾ མམཻཏསྱཱཾ ཀཐཱཡཱམ྄ ཨཱཤྩཪྻཾ མཱ མཾསྠཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","སདཱགཏིཪྻཱཾ དིཤམིཙྪཏི ཏསྱཱམེཝ དིཤི ཝཱཏི, ཏྭཾ ཏསྱ སྭནཾ ཤུཎོཥི ཀིནྟུ ས ཀུཏ ཨཱཡཱཏི ཀུཏྲ ཡཱཏི ཝཱ ཀིམཔི ན ཛཱནཱསི ཏདྭཱད྄ ཨཱཏྨནཿ སཀཱཤཱཏ྄ སཪྻྭེཥཱཾ མནུཛཱནཱཾ ཛནྨ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ཏདཱ ནིཀདཱིམཿ པྲྀཥྚཝཱན྄ ཨེཏཏ྄ ཀཐཾ བྷཝིཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ཡཱིཤུཿ པྲཏྱཀྟཝཱན྄ ཏྭམིསྲཱཡེལོ གུརུརྦྷཱུཏྭཱཔི ཀིམེཏཱཾ ཀཐཱཾ ན ཝེཏྶི? ");
INSERT INTO santib_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ཏུབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི, ཝཡཾ ཡད྄ ཝིདྨསྟད྄ ཝཙྨཿ ཡཾཙྩ པཤྱཱམསྟསྱཻཝ སཱཀྵྱཾ དདྨཿ ཀིནྟུ ཡུཥྨཱབྷིརསྨཱཀཾ སཱཀྵིཏྭཾ ན གྲྀཧྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ཨེཏསྱ སཾསཱརསྱ ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ ཡདི ཡཱུཡཾ ན ཝིཤྭསིཐ ཏརྷི སྭརྒཱིཡཱཡཱཾ ཀཐཱཡཱཾ ཀཐཾ ཝིཤྭསིཥྱཐ? ");
INSERT INTO santib_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ཡཿ སྭརྒེ྅སྟི ཡཾ ཙ སྭརྒཱད྄ ཨཝཱརོཧཏ྄ ཏཾ མཱནཝཏནཡཾ ཝིནཱ ཀོཔི སྭརྒཾ ནཱརོཧཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ཨཔརཉྩ མཱུསཱ ཡཐཱ པྲཱནྟརེ སརྤཾ པྲོཏྠཱཔིཏཝཱན྄ མནུཥྱཔུཏྲོ྅པི ཏཐཻཝོཏྠཱཔིཏཝྱཿ; ");
INSERT INTO santib_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ཏསྨཱད྄ ཡཿ ཀཤྩིཏ྄ ཏསྨིན྄ ཝིཤྭསིཥྱཏི སོ྅ཝིནཱཤྱཿ སན྄ ཨནནྟཱཡུཿ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ཨཱིཤྭར ཨིཏྠཾ ཛགདདཡཏ ཡཏ྄ སྭམདྭིཏཱིཡཾ ཏནཡཾ པྲཱདདཱཏ྄ ཏཏོ ཡཿ ཀཤྩིཏ྄ ཏསྨིན྄ ཝིཤྭསིཥྱཏི སོ྅ཝིནཱཤྱཿ སན྄ ཨནནྟཱཡུཿ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ཨཱིཤྭརོ ཛགཏོ ལོཀཱན྄ དཎྜཡིཏུཾ སྭཔུཏྲཾ ན པྲེཥྱ ཏཱན྄ པརིཏྲཱཏུཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ཨཏཨེཝ ཡཿ ཀཤྩིཏ྄ ཏསྨིན྄ ཝིཤྭསིཏི ས དཎྜཱརྷོ ན བྷཝཏི ཀིནྟུ ཡཿ ཀཤྩིཏ྄ ཏསྨིན྄ ན ཝིཤྭསིཏི ས ཨིདཱནཱིམེཝ དཎྜཱརྷོ བྷཝཏི,ཡཏཿ ས ཨཱིཤྭརསྱཱདྭིཏཱིཡཔུཏྲསྱ ནཱམནི པྲཏྱཡཾ ན ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ཛགཏོ མདྷྱེ ཛྱོཏིཿ པྲཱཀཱཤཏ ཀིནྟུ མནུཥྱཱཎཱཾ ཀརྨྨཎཱཾ དྲྀཥྚཏྭཱཏ྄ ཏེ ཛྱོཏིཥོཔི ཏིམིརེ པྲཱིཡནྟེ ཨེཏདེཝ དཎྜསྱ ཀཱརཎཱཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ཡཿ ཀུཀརྨྨ ཀརོཏི ཏསྱཱཙཱརསྱ དྲྀཥྚཏྭཱཏ྄ ས ཛྱོཏིརྲཱྀཏཱིཡིཏྭཱ ཏནྣིཀཊཾ ནཱཡཱཏི; ");
INSERT INTO santib_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ཀིནྟུ ཡཿ སཏྐརྨྨ ཀརོཏི ཏསྱ སཪྻྭཱཎི ཀརྨྨཱཎཱིཤྭརེཎ ཀྲྀཏཱནཱིཏི སཐཱ པྲཀཱཤཏེ ཏདབྷིཔྲཱཡེཎ ས ཛྱོཏིཥཿ སནྣིདྷིམ྄ ཨཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ཏཏཿ པརམ྄ ཡཱིཤུཿ ཤིཥྱཻཿ སཱརྡྡྷཾ ཡིཧཱུདཱིཡདེཤཾ གཏྭཱ ཏཏྲ སྠིཏྭཱ མཛྫཡིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ཏདཱ ཤཱལམ྄ ནགརསྱ སམཱིཔསྠཱཡིནི ཨཻནན྄ གྲཱམེ བཧུཏརཏོཡསྠིཏེསྟཏྲ ཡོཧན྄ ཨམཛྫཡཏ྄ ཏཐཱ ཙ ལོཀཱ ཨཱགཏྱ ཏེན མཛྫིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ཏདཱ ཡོཧན྄ ཀཱརཱཡཱཾ ན བདྡྷཿ། ");
INSERT INTO santib_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ཨཔརཉྩ ཤཱཙཀརྨྨཎི ཡོཧཱནཿ ཤིཥྱཻཿ སཧ ཡིཧཱུདཱིཡལོཀཱནཱཾ ཝིཝཱདེ ཛཱཏེ, ཏེ ཡོཧནཿ སཾནྣིདྷིཾ གཏྭཱཀཐཡན྄, ");
INSERT INTO santib_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ཧེ གུརོ ཡརྡྡནནདྱཱཿ པཱརེ བྷཝཏཱ སཱརྡྡྷཾ ཡ ཨཱསཱིཏ྄ ཡསྨིཾཤྩ བྷཝཱན྄ སཱཀྵྱཾ པྲདདཱཏ྄ པཤྱཏུ སོཔི མཛྫཡཏི སཪྻྭེ ཏསྱ སམཱིཔཾ ཡཱནྟི ཙ། ");
INSERT INTO santib_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ཏདཱ ཡོཧན྄ པྲཏྱཝོཙད྄ ཨཱིཤྭརེཎ ན དཏྟེ ཀོཔི མནུཛཿ ཀིམཔི པྲཱཔྟུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ཨཧཾ ཨབྷིཥིཀྟོ ན བྷཝཱམི ཀིནྟུ ཏདགྲེ པྲེཥིཏོསྨི ཡཱམིམཱཾ ཀཐཱཾ ཀཐིཏཝཱནཱཧཾ ཏཏྲ ཡཱུཡཾ སཪྻྭེ སཱཀྵིཎཿ སྠ། ");
INSERT INTO santib_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ཡོ ཛནཿ ཀནྱཱཾ ལབྷཏེ ས ཨེཝ ཝརཿ ཀིནྟུ ཝརསྱ སནྣིདྷཽ དཎྜཱཡམཱནཾ ཏསྱ ཡནྨིཏྲཾ ཏེན ཝརསྱ ཤབྡེ ཤྲུཏེ྅ཏཱིཝཱཧླཱདྱཏེ མམཱཔི ཏདྭད྄ ཨཱནནྡསིདྡྷིརྫཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ཏེན ཀྲམཤོ ཝརྡྡྷིཏཝྱཾ ཀིནྟུ མཡཱ ཧྶིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ཡ ཨཱུརྡྷྭཱདཱགཙྪཏ྄ ས སཪྻྭེཥཱཾ མུཁྱོ ཡཤྩ སཾསཱརཱད྄ ཨུདཔདྱཏ ས སཱཾསཱརིཀཿ སཾསཱརཱིཡཱཾ ཀཐཱཉྩ ཀཐཡཏི ཡསྟུ སྭརྒཱདཱགཙྪཏ྄ ས སཪྻྭེཥཱཾ མུཁྱཿ། ");
INSERT INTO santib_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ས ཡདཔཤྱདཤྲྀཎོཙྩ ཏསྨིནྣེཝ སཱཀྵྱཾ དདཱཏི ཏཐཱཔི པྲཱཡཤཿ ཀཤྩིཏ྄ ཏསྱ སཱཀྵྱཾ ན གྲྀཧླཱཏི; ");
INSERT INTO santib_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ཀིནྟུ ཡོ གྲྀཧླཱཏི ས ཨཱིཤྭརསྱ སཏྱཝཱདིཏྭཾ མུདྲཱངྒིཏཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ཨཱིཤྭརེཎ ཡཿ པྲེརིཏཿ སཨེཝ ཨཱིཤྭརཱིཡཀཐཱཾ ཀཐཡཏི ཡཏ ཨཱིཤྭར ཨཱཏྨཱནཾ ཏསྨཻ ཨཔརིམིཏམ྄ ཨདདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","པིཏཱ པུཏྲེ སྣེཧཾ ཀྲྀཏྭཱ ཏསྱ ཧསྟེ སཪྻྭཱཎི སམརྤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ཡཿ ཀཤྩིཏ྄ པུཏྲེ ཝིཤྭསིཏི ས ཨེཝཱནནྟམ྄ པརམཱཡུཿ པྲཱཔྣོཏི ཀིནྟུ ཡཿ ཀཤྩིཏ྄ པུཏྲེ ན ཝིཤྭསིཏི ས པརམཱཡུཥོ དརྴནཾ ན པྲཱཔྣོཏི ཀིནྟྭཱིཤྭརསྱ ཀོཔབྷཱཛནཾ བྷཱུཏྭཱ ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ཡཱིཤུཿ སྭཡཾ ནཱམཛྫཡཏ྄ ཀེཝལཾ ཏསྱ ཤིཥྱཱ ཨམཛྫཡཏ྄ ཀིནྟུ ཡོཧནོ྅དྷིཀཤིཥྱཱན྄ ས ཀརོཏི མཛྫཡཏི ཙ, ");
INSERT INTO santib_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ཕིརཱུཤིན ཨིམཱཾ ཝཱརྟྟཱམཤྲྀཎྭན྄ ཨིཏི པྲབྷུརཝགཏྱ ");
INSERT INTO santib_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ཡིཧཱུདཱིཡདེཤཾ ཝིཧཱཡ པུན རྒཱལཱིལམ྄ ཨཱགཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ཏཏཿ ཤོམིརོཎཔྲདེཤསྱ མདྱེན ཏེན གནྟཝྱེ སཏི ");
INSERT INTO santib_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ཡཱཀཱུབ྄ ནིཛཔུཏྲཱཡ ཡཱུཥཕེ ཡཱཾ བྷཱུམིམ྄ ཨདདཱཏ྄ ཏཏྶམཱིཔསྠཱཡི ཤོམིརོཎཔྲདེཤསྱ སུཁཱར྄ ནཱམྣཱ ཝིཁྱཱཏསྱ ནགརསྱ སནྣིདྷཱཝུཔཱསྠཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ཏཏྲ ཡཱཀཱུབཿ པྲཧིརཱསཱིཏ྄; ཏདཱ དྭིཏཱིཡཡཱམཝེལཱཡཱཾ ཛཱཏཱཡཱཾ ས མཱརྒེ ཤྲམཱཔནྣསྟསྱ པྲཧེཿ པཱརྴྭེ ཨུཔཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ཨེཏརྷི ཀཱཙིཏ྄ ཤོམིརོཎཱིཡཱ ཡོཥིཏ྄ ཏོཡོཏྟོལནཱརྠམ྄ ཏཏྲཱགམཏ྄ ");
INSERT INTO santib_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ཏདཱ ཤིཥྱཱཿ ཁཱདྱདྲཝྱཱཎི ཀྲེཏུཾ ནགརམ྄ ཨགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ཡཱིཤུཿ ཤོམིརོཎཱིཡཱཾ ཏཱཾ ཡོཥིཏམ྄ ཝྱཱཧཱརྵཱིཏ྄ མཧྱཾ ཀིཉྩིཏ྄ པཱནཱིཡཾ པཱཏུཾ དེཧི། ཀིནྟུ ཤོམིརོཎཱིཡཻཿ སཱཀཾ ཡིཧཱུདཱིཡལོཀཱ ན ཝྱཝཱཧརན྄ ཏསྨཱདྡྷེཏོཿ སཱཀཐཡཏ྄ ཤོམིརོཎཱིཡཱ ཡོཥིཏདཧཾ ཏྭཾ ཡིཧཱུདཱིཡོསི ཀཐཾ མཏྟཿ པཱནཱིཡཾ པཱཏུམ྄ ཨིཙྪསི? ");
INSERT INTO santib_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ཏཏོ ཡཱིཤུརཝདད྄ ཨཱིཤྭརསྱ ཡདྡཱནཾ ཏཏྐཱིདྲྀཀ྄ པཱནཱིཡཾ པཱཏུཾ མཧྱཾ དེཧི ཡ ཨིཏྠཾ ཏྭཱཾ ཡཱཙཏེ ས ཝཱ ཀ ཨིཏི ཙེདཛྙཱསྱཐཱསྟརྷི ཏམཡཱཙིཥྱཐཱཿ ས ཙ ཏུབྷྱམམྲྀཏཾ ཏོཡམདཱསྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ཏདཱ སཱ སཱིམནྟིནཱི བྷཱཥིཏཝཏི, ཧེ མཧེཙྪ པྲཧིརྒམྦྷཱིརོ བྷཝཏོ ནཱིརོཏྟོལནཔཱཏྲཾ ནཱསྟཱི ཙ ཏསྨཱཏ྄ ཏདམྲྀཏཾ ཀཱིལཱལཾ ཀུཏཿ པྲཱཔྶྱསི? ");
INSERT INTO santib_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ཡོསྨབྷྱམ྄ ཨིམམནྡྷཱུཾ དདཽ, ཡསྱ ཙ པརིཛནཱ གོམེཥཱདཡཤྩ སཪྻྭེ྅སྱ པྲཧེཿ པཱནཱིཡཾ པཔུརེཏཱདྲྀཤོ ཡོསྨཱཀཾ པཱུཪྻྭཔུརུཥོ ཡཱཀཱུབ྄ ཏསྨཱདཔི བྷཝཱན྄ མཧཱན྄ ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ཏཏོ ཡཱིཤུརཀཐཡད྄ ཨིདཾ པཱནཱིཡཾ སཿ པིཝཏི ས པུནསྟྲྀཥཱརྟྟོ བྷཝིཥྱཏི, ");
INSERT INTO santib_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ཀིནྟུ མཡཱ དཏྟཾ པཱནཱིཡཾ ཡཿ པིཝཏི ས པུནཿ ཀདཱཔི ཏྲྀཥཱརྟྟོ ན བྷཝིཥྱཏི། མཡཱ དཏྟམ྄ ཨིདཾ ཏོཡཾ ཏསྱཱནྟཿ པྲསྲཝཎརཱུཔཾ བྷཱུཏྭཱ ཨནནྟཱཡུཪྻཱཝཏ྄ སྲོཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ཏདཱ སཱ ཝནིཏཱཀཐཡཏ྄ ཧེ མཧེཙྪ ཏརྷི མམ པུནཿ པཱིཔཱསཱ ཡཐཱ ན ཛཱཡཏེ ཏོཡོཏྟོལནཱཡ ཡཐཱཏྲཱགམནཾ ན བྷཝཏི ཙ ཏདརྠཾ མཧྱཾ ཏཏྟོཡཾ དེཧཱི། ");
INSERT INTO santib_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ཏཏོ ཡཱིཤཱུརཝདདྱཱཧི ཏཝ པཏིམཱཧཱུཡ སྠཱནེ྅ཏྲཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","སཱ ཝཱམཱཝདཏ྄ མམ པཏིརྣཱསྟི། ཡཱིཤུརཝདཏ྄ མམ པཏིརྣཱསྟཱིཏི ཝཱཀྱཾ བྷདྲམཝོཙཿ། ");
INSERT INTO santib_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ཡཏསྟཝ པཉྩ པཏཡོབྷཝན྄ ཨདྷུནཱ ཏུ ཏྭཡཱ སཱརྡྡྷཾ ཡསྟིཥྛཏི ས ཏཝ བྷརྟྟཱ ན ཝཱཀྱམིདཾ སཏྱམཝཱདིཿ། ");
INSERT INTO santib_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ཏདཱ སཱ མཧིལཱ གདིཏཝཏི ཧེ མཧེཙྪ བྷཝཱན྄ ཨེཀོ བྷཝིཥྱདྭཱདཱིཏི བུདྡྷཾ མཡཱ། ");
INSERT INTO santib_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ཨསྨཱཀཾ པིཏྲྀལོཀཱ ཨེཏསྨིན྄ ཤིལོཙྩཡེ྅བྷཛནྟ, ཀིནྟུ བྷཝདྦྷིརུཙྱཏེ ཡིརཱུཤཱལམ྄ ནགརེ བྷཛནཡོགྱཾ སྠཱནམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ཡཱིཤུརཝོཙཏ྄ ཧེ ཡོཥིཏ྄ མམ ཝཱཀྱེ ཝིཤྭསིཧི ཡདཱ ཡཱུཡཾ ཀེཝལཤཻལེ྅སྨིན྄ ཝཱ ཡིརཱུཤཱལམ྄ ནགརེ པིཏུརྦྷཛནཾ ན ཀརིཥྱདྷྭེ ཀཱལ ཨེཏཱདྲྀཤ ཨཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ཡཱུཡཾ ཡཾ བྷཛདྷྭེ ཏཾ ན ཛཱནཱིཐ, ཀིནྟུ ཝཡཾ ཡཾ བྷཛཱམཧེ ཏཾ ཛཱནཱིམཧེ, ཡཏོ ཡིཧཱུདཱིཡལོཀཱནཱཾ མདྷྱཱཏ྄ པརིཏྲཱཎཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ཀིནྟུ ཡདཱ སཏྱབྷཀྟཱ ཨཱཏྨནཱ སཏྱརཱུཔེཎ ཙ པིཏུརྦྷཛནཾ ཀརིཥྱནྟེ སམཡ ཨེཏཱདྲྀཤ ཨཱཡཱཏི, ཝརམ྄ ཨིདཱནཱིམཔི ཝིདྱཏེ ; ཡཏ ཨེཏཱདྲྀཤོ བྷཏྐཱན྄ པིཏཱ ཙེཥྚཏེ། ");
INSERT INTO santib_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ཨཱིཤྭར ཨཱཏྨཱ; ཏཏསྟསྱ ཡེ བྷཀྟཱསྟཻཿ ས ཨཱཏྨནཱ སཏྱརཱུཔེཎ ཙ བྷཛནཱིཡཿ། ");
INSERT INTO santib_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ཏདཱ སཱ མཧིལཱཝཱདཱིཏ྄ ཁྲཱིཥྚནཱམྣཱ ཝིཁྱཱཏོ྅བྷིཥིཀྟཿ པུརུཥ ཨཱགམིཥྱཏཱིཏི ཛཱནཱམི ས ཙ སཪྻྭཱཿ ཀཐཱ ཨསྨཱན྄ ཛྙཱཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ཏཏོ ཡཱིཤུརཝདཏ྄ ཏྭཡཱ སཱརྡྡྷཾ ཀཐནཾ ཀརོམི ཡོ྅ཧམ྄ ཨཧམེཝ ས པུརུཥཿ། ");
INSERT INTO santib_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ཨེཏསྨིན྄ སམཡེ ཤིཥྱཱ ཨཱགཏྱ ཏཐཱ སྟྲིཡཱ སཱརྡྡྷཾ ཏསྱ ཀཐོཔཀཐནེ མཧཱཤྩཪྻྱམ྄ ཨམནྱནྟ ཏཐཱཔི བྷཝཱན྄ ཀིམིཙྪཏི? ཡདྭཱ ཀིམརྠམ྄ ཨེཏཡཱ སཱརྡྡྷཾ ཀཐཱཾ ཀཐཡཏི? ཨིཏི ཀོཔི ནཱཔྲྀཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ཏཏཿ པརཾ སཱ ནཱརཱི ཀལཤཾ སྠཱཔཡིཏྭཱ ནགརམདྷྱཾ གཏྭཱ ལོཀེབྷྱོཀཐཱཡད྄ ");
INSERT INTO santib_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ཨཧཾ ཡདྱཏ྄ ཀརྨྨཱཀརཝཾ ཏཏྶཪྻྭཾ མཧྱམཀཐཡད྄ ཨེཏཱདྲྀཤཾ མཱནཝམེཀམ྄ ཨཱགཏྱ པཤྱཏ རུ ཀིམ྄ ཨབྷིཥིཀྟོ ན བྷཝཏི ? ");
INSERT INTO santib_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ཏཏསྟེ ནགརཱད྄ བཧིརཱགཏྱ ཏཱཏསྱ སམཱིཔམ྄ ཨཱཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ཨེཏརྷི ཤིཥྱཱཿ སཱདྷཡིཏྭཱ ཏཾ ཝྱཱཧཱརྵུཿ ཧེ གུརོ བྷཝཱན྄ ཀིཉྩིད྄ བྷཱུཀྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ཏཏཿ སོཝདད྄ ཡུཥྨཱབྷིཪྻནྣ ཛྙཱཡཏེ ཏཱདྲྀཤཾ བྷཀྵྱཾ མམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ཏདཱ ཤིཥྱཱཿ པརསྤརཾ པྲཥྚུམ྄ ཨཱརམྦྷནྟ, ཀིམསྨཻ ཀོཔི ཀིམཔི བྷཀྵྱམཱནཱིཡ དཏྟཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ཡཱིཤུརཝོཙཏ྄ མཏྤྲེརཀསྱཱབྷིམཏཱནུརཱུཔཀརཎཾ ཏསྱཻཝ ཀརྨྨསིདྡྷིཀཱརཎཉྩ མམ བྷཀྵྱཾ། ");
INSERT INTO santib_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","མཱསཙཏུཥྚཡེ ཛཱཏེ ཤསྱཀརྟྟནསམཡོ བྷཝིཥྱཏཱིཏི ཝཱཀྱཾ ཡུཥྨཱབྷིཿ ཀིཾ ནོདྱཏེ? ཀིནྟྭཧཾ ཝདཱམི, ཤིར ཨུཏྟོལྱ ཀྵེཏྲཱཎི པྲཏི ནིརཱིཀྵྱ པཤྱཏ, ཨིདཱནཱིཾ ཀརྟྟནཡོགྱཱནི ཤུཀླཝརྞཱནྱབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ཡཤྪིནཏྟི ས ཝེཏནཾ ལབྷཏེ ཨནནྟཱཡུཿསྭརཱུཔཾ ཤསྱཾ ས གྲྀཧླཱཏི ཙ, ཏེནཻཝ ཝཔྟཱ ཚེཏྟཱ ཙ ཡུགཔད྄ ཨཱནནྡཏཿ། ");
INSERT INTO santib_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ཨིཏྠཾ སཏི ཝཔཏྱེཀཤྪིནཏྱནྱ ཨིཏི ཝཙནཾ སིདྡྷྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ཡཏྲ ཡཱུཡཾ ན པཪྻྱཤྲཱམྱཏ ཏཱདྲྀཤཾ ཤསྱཾ ཚེཏྟུཾ ཡུཥྨཱན྄ པྲཻརཡམ྄ ཨནྱེ ཛནཱཿཔཪྻྱཤྲཱམྱན྄ ཡཱུཡཾ ཏེཥཱཾ ཤྲགསྱ ཕལམ྄ ཨལབྷདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ཡསྨིན྄ ཀཱལེ ཡདྱཏ྄ ཀརྨྨཱཀཱརྵཾ ཏཏྶཪྻྭཾ ས མཧྱམ྄ ཨཀཐཡཏ྄ ཏསྱཱ ཝནིཏཱཡཱ ཨིདཾ སཱཀྵྱཝཱཀྱཾ ཤྲུཏྭཱ ཏནྣགརནིཝཱསིནོ བཧཝཿ ཤོམིརོཎཱིཡལོཀཱ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ཏཐཱ ཙ ཏསྱཱནྟིཀེ སམུཔསྠཱཡ སྭེཥཱཾ སནྣིདྷཽ ཀཏིཙིད྄ དིནཱནི སྠཱཏུཾ ཏསྨིན྄ ཝིནཡམ྄ ཨཀུཪྻྭཱན ཏསྨཱཏ྄ ས དིནདྭཡཾ ཏཏྶྠཱནེ ནྱཝཥྚཏ྄ ");
INSERT INTO santib_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ཏཏསྟསྱོཔདེཤེན བཧཝོ྅པརེ ཝིཤྭསྱ ");
INSERT INTO santib_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ཏཱཾ ཡོཥཱམཝདན྄ ཀེཝལཾ ཏཝ ཝཱཀྱེན པྲཏཱིམ ཨིཏི ན, ཀིནྟུ ས ཛགཏོ྅བྷིཥིཀྟསྟྲཱཏེཏི ཏསྱ ཀཐཱཾ ཤྲུཏྭཱ ཝཡཾ སྭཡམེཝཱཛྙཱསམཧི། ");
INSERT INTO santib_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","སྭདེཤེ བྷཝིཥྱདྭཀྟུཿ སཏྐཱརོ ནཱསྟཱིཏི ཡདྱཔི ཡཱིཤུཿ པྲམཱཎཾ དཏྭཱཀཐཡཏ྄ ");
INSERT INTO santib_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ཏཐཱཔི དིཝསདྭཡཱཏ྄ པརཾ ས ཏསྨཱཏ྄ སྠཱནཱད྄ གཱལཱིལཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ཨནནྟརཾ ཡེ གཱལཱིལཱི ལིཡལོཀཱ ཨུཏྶཝེ གཏཱ ཨུཏྶཝསམཡེ ཡིརཱུཤལམ྄ ནགརེ ཏསྱ སཪྻྭཱཿ ཀྲིཡཱ ཨཔཤྱན྄ ཏེ གཱལཱིལམ྄ ཨཱགཏཾ ཏམ྄ ཨཱགྲྀཧླན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ཏཏཿ པརམ྄ ཡཱིཤུ ཪྻསྨིན྄ ཀཱནྣཱནགརེ ཛལཾ དྲཱཀྵཱརསམ྄ ཨཱཀརོཏ྄ ཏཏ྄ སྠཱནཾ པུནརགཱཏ྄། ཏསྨིནྣེཝ སམཡེ ཀསྱཙིད྄ རཱཛསབྷཱསྟཱརསྱ པུཏྲཿ ཀཕརྣཱཧཱུམཔུརཱི རོགགྲསྟ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ས ཡེཧཱུདཱིཡདེཤཱད྄ ཡཱིཤོ རྒཱལཱིལཱགམནཝཱརྟྟཱཾ ནིཤམྱ ཏསྱ སམཱིཔཾ གཏྭཱ པྲཱརྠྱ ཝྱཱཧྲྀཏཝཱན྄ མམ པུཏྲསྱ པྲཱཡེཎ ཀཱལ ཨཱསནྣཿ བྷཝཱན྄ ཨཱགཏྱ ཏཾ སྭསྠཾ ཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ཏདཱ ཡཱིཤུརཀཐཡད྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ ཙིཏྲཾ ཙིཧྣཾ ཙ ན དྲྀཥྚཱ ཡཱུཡཾ ན པྲཏྱེཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ཏཏཿ ས སབྷཱསདཝདཏ྄ ཧེ མཧེཙྪ མམ པུཏྲེ ན མྲྀཏེ བྷཝཱནཱགཙྪཏུ། ");
INSERT INTO santib_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ཡཱིཤུསྟམཝདད྄ གཙྪ ཏཝ པུཏྲོ྅ཛཱིཝཱིཏ྄ ཏདཱ ཡཱིཤུནོཀྟཝཱཀྱེ ས ཝིཤྭསྱ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","གམནཀཱལེ མཱརྒམདྷྱེ དཱསཱསྟཾ སཱཀྵཱཏྤྲཱཔྱཱཝདན྄ བྷཝཏཿ པུཏྲོ྅ཛཱིཝཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ཏཏཿ ཀཾ ཀཱལམཱརབྷྱ རོགཔྲཏཱིཀཱརཱརམྦྷོ ཛཱཏཱ ཨིཏི པྲྀཥྚེ ཏཻརུཀྟཾ ཧྱཿ སཱརྡྡྷདཎྜདྭཡཱདྷིཀདྭིཏཱིཡཡཱམེ ཏསྱ ཛྭརཏྱཱགོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ཏདཱ ཡཱིཤུསྟསྨིན྄ ཀྵཎེ པྲོཀྟཝཱན྄ ཏཝ པུཏྲོ྅ཛཱིཝཱིཏ྄ པིཏཱ ཏདྦུདྡྷྭཱ སཔརིཝཱརོ ཝྱཤྭསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ཡིཧཱུདཱིཡདེཤཱད྄ ཨཱགཏྱ གཱལཱིལི ཡཱིཤུརེཏད྄ དྭིཏཱིཡམ྄ ཨཱཤྩཪྻྱཀརྨྨཱཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ཏཏཿ པརཾ ཡིཧཱུདཱིཡཱནཱམ྄ ཨུཏྶཝ ཨུཔསྠིཏེ ཡཱིཤུ ཪྻིརཱུཤཱལམཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ཏསྨིནྣགརེ མེཥནཱམྣོ དྭཱརསྱ སམཱིཔེ ཨིབྲཱིཡབྷཱཥཡཱ བཻཐེསྡཱ ནཱམྣཱ པིཥྐརིཎཱི པཉྩགྷཊྚཡུཀྟཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ཏསྱཱསྟེཥུ གྷཊྚེཥུ ཀིལཱལཀམྤནམ྄ ཨཔེཀྵྱ ཨནྡྷཁཉྩཤུཥྐཱངྒཱདཡོ བཧཝོ རོགིཎཿ པཏནྟསྟིཥྛནྟི སྨ། ");
INSERT INTO santib_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ཡཏོ ཝིཤེཥཀཱལེ ཏསྱ སརསོ ཝཱརི སྭརྒཱིཡདཱུཏ ཨེཏྱཱཀམྤཡཏ྄ ཏཏྐཱིལཱལཀམྤནཱཏ྄ པརཾ ཡཿ ཀཤྩིད྄ རོགཱི པྲཐམཾ པཱནཱིཡམཝཱརོཧཏ྄ ས ཨེཝ ཏཏྐྵཎཱད྄ རོགམུཀྟོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ཏདཱཥྚཱཏྲིཾཤདྭརྵཱཎི ཡཱཝད྄ རོགགྲསྟ ཨེཀཛནསྟསྨིན྄ སྠཱནེ སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ཡཱིཤུསྟཾ ཤཡིཏཾ དྲྀཥྚྭཱ བཧུཀཱལིཀརོགཱིཏི ཛྙཱཏྭཱ ཝྱཱཧྲྀཏཝཱན྄ ཏྭཾ ཀིཾ སྭསྠོ བུབྷཱུཥསི? ");
INSERT INTO santib_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ཏཏོ རོགཱི ཀཐིཏཝཱན྄ ཧེ མཧེཙྪ ཡདཱ ཀཱིལཱལཾ ཀམྤཏེ ཏདཱ མཱཾ པུཥྐརིཎཱིམ྄ ཨཝརོཧཡིཏུཾ མམ ཀོཔི ནཱསྟི, ཏསྨཱན྄ མམ གམནཀཱལེ ཀཤྩིདནྱོ྅གྲོ གཏྭཱ ཨཝརོཧཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ཏདཱ ཡཱིཤུརཀཐཡད྄ ཨུཏྟིཥྛ, ཏཝ ཤཡྻཱམུཏྟོལྱ གྲྀཧཱིཏྭཱ ཡཱཧི། ");
INSERT INTO santib_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ས ཏཏྐྵཎཱཏ྄ སྭསྠོ བྷཱུཏྭཱ ཤཡྻཱམུཏྟོལྱཱདཱཡ གཏཝཱན྄ ཀིནྟུ ཏདྡིནཾ ཝིཤྲཱམཝཱརཿ། ");
INSERT INTO santib_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ཏསྨཱད྄ ཡིཧཱུདཱིཡཱཿ སྭསྠཾ ནརཾ ཝྱཱཧརན྄ ཨདྱ ཝིཤྲཱམཝཱརེ ཤཡནཱིཡམཱདཱཡ ན ཡཱཏཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ཏཏཿ ས པྲཏྱཝོཙད྄ ཡོ མཱཾ སྭསྠམ྄ ཨཀཱརྵཱིཏ྄ ཤཡནཱིཡམ྄ ཨུཏྟོལྱཱདཱཡ ཡཱཏུཾ མཱཾ ས ཨེཝཱདིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཤཡནཱིཡམ྄ ཨུཏྟོལྱཱདཱཡ ཡཱཏུཾ ཡ ཨཱཛྙཱཔཡཏ྄ ས ཀཿ? ");
INSERT INTO santib_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ཀིནྟུ ས ཀ ཨིཏི སྭསྠཱིབྷཱུཏོ ནཱཛཱནཱད྄ ཡཏསྟསྨིན྄ སྠཱནེ ཛནཏཱསཏྟྭཱད྄ ཡཱིཤུཿ སྠཱནཱནྟརམ྄ ཨཱགམཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ཏཏཿ པརཾ ཡེཤུ རྨནྡིརེ ཏཾ ནརཾ སཱཀྵཱཏྤྲཱཔྱཱཀཐཡཏ྄ པཤྱེདཱནཱིམ྄ ཨནཱམཡོ ཛཱཏོསི ཡཐཱདྷིཀཱ དུརྡཤཱ ན གྷཊཏེ ཏདྡྷེཏོཿ པཱཔཾ ཀརྨྨ པུནརྨཱཀཱརྵཱིཿ། ");
INSERT INTO santib_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ཏཏཿ ས གཏྭཱ ཡིཧཱུདཱིཡཱན྄ ཨཝདད྄ ཡཱིཤུ རྨཱམ྄ ཨརོགིཎམ྄ ཨཀཱརྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ཏཏོ ཡཱིཤུ ཪྻིཤྲཱམཝཱརེ ཀརྨྨེདྲྀཤཾ ཀྲྀཏཝཱན྄ ཨིཏི ཧེཏོ ཪྻིཧཱུདཱིཡཱསྟཾ ཏཱཌཡིཏྭཱ ཧནྟུམ྄ ཨཙེཥྚནྟ། ");
INSERT INTO santib_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ཡཱིཤུསྟཱནཱཁྱཏ྄ མམ པིཏཱ ཡཏ྄ ཀཱཪྻྱཾ ཀརོཏི ཏདནུརཱུཔམ྄ ཨཧམཔི ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ཏཏོ ཡིཧཱུདཱིཡཱསྟཾ ཧནྟུཾ པུནརཡཏནྟ ཡཏོ ཝིཤྲཱམཝཱརཾ ནཱམནྱཏ ཏདེཝ ཀེཝལཾ ན ཨདྷིཀནྟུ ཨཱིཤྭརཾ སྭཔིཏརཾ པྲོཙྱ སྭམཔཱིཤྭརཏུལྱཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","པཤྩཱད྄ ཡཱིཤུརཝདད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཏརཾ ཝདཱམི པུཏྲཿ པིཏརཾ ཡདྱཏ྄ ཀརྨྨ ཀུཪྻྭནྟཾ པཤྱཏི ཏདཏིརིཀྟཾ སྭེཙྪཱཏཿ ཀིམཔི ཀརྨྨ ཀརྟྟུཾ ན ཤཀྣོཏི། པིཏཱ ཡཏ྄ ཀརོཏི པུཏྲོཔི ཏདེཝ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","པིཏཱ པུཏྲེ སྣེཧཾ ཀརོཏི ཏསྨཱཏ྄ སྭཡཾ ཡདྱཏ྄ ཀརྨྨ ཀརོཏི ཏཏྶཪྻྭཾ པུཏྲཾ དརྴཡཏི ; ཡཐཱ ཙ ཡུཥྨཱཀཾ ཨཱཤྩཪྻྱཛྙཱནཾ ཛནིཥྱཏེ ཏདརྠམ྄ ཨིཏོཔི མཧཱཀརྨྨ ཏཾ དརྴཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ཝསྟུཏསྟུ པིཏཱ ཡཐཱ པྲམིཏཱན྄ ཨུཏྠཱཔྱ སཛིཝཱན྄ ཀརོཏི ཏདྭཏ྄ པུཏྲོཔི ཡཾ ཡཾ ཨིཙྪཏི ཏཾ ཏཾ སཛཱིཝཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","སཪྻྭེ པིཏརཾ ཡཐཱ སཏྐུཪྻྭནྟི ཏཐཱ པུཏྲམཔི སཏྐཱརཡིཏུཾ པིཏཱ སྭཡཾ ཀསྱཱཔི ཝིཙཱརམཀྲྀཏྭཱ སཪྻྭཝིཙཱརཱཎཱཾ བྷཱརཾ པུཏྲེ སམརྤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ཡཿ པུཏྲཾ སཏ྄ ཀརོཏི ས ཏསྱ པྲེརཀམཔི སཏ྄ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ཡུཥྨཱནཱཧཾ ཡཐཱརྠཏརཾ ཝདཱམི ཡོ ཛནོ མམ ཝཱཀྱཾ ཤྲུཏྭཱ མཏྤྲེརཀེ ཝིཤྭསིཏི སོནནྟཱཡུཿ པྲཱཔྣོཏི ཀདཱཔི དཎྜབཱཛནཾ ན བྷཝཏི ནིདྷནཱདུཏྠཱཡ པརམཱཡུཿ པྲཱཔྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི ཡདཱ མྲྀཏཱ ཨཱིཤྭརཔུཏྲསྱ ནིནཱདཾ ཤྲོཥྱནྟི ཡེ ཙ ཤྲོཥྱནྟི ཏེ སཛཱིཝཱ བྷཝིཥྱནྟི སམཡ ཨེཏཱདྲྀཤ ཨཱཡཱཏི ཝརམ྄ ཨིདཱནཱིམཔྱུཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","པིཏཱ ཡཐཱ སྭཡཉྫཱིཝཱི ཏཐཱ པུཏྲཱཡ སྭཡཉྫཱིཝིཏྭཱདྷིཀཱརཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ས མནུཥྱཔུཏྲཿ ཨེཏསྨཱཏ྄ ཀཱརཎཱཏ྄ པིཏཱ དཎྜཀརཎཱདྷིཀཱརམཔི ཏསྨིན྄ སམརྤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ཨེཏདརྠེ ཡཱུཡམ྄ ཨཱཤྩཪྻྱཾ ན མནྱདྷྭཾ ཡཏོ ཡསྨིན྄ སམཡེ ཏསྱ ནིནཱདཾ ཤྲུཏྭཱ ཤྨཤཱནསྠཱཿ སཪྻྭེ བཧིརཱགམིཥྱནྟི སམཡ ཨེཏཱདྲྀཤ ཨུཔསྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ཏསྨཱད྄ ཡེ སཏྐརྨྨཱཎི ཀྲྀཏཝནྟསྟ ཨུཏྠཱཡ ཨཱཡུཿ པྲཱཔྶྱནྟི ཡེ ཙ ཀུཀརྨཱཎི ཀྲྀཏཝནྟསྟ ཨུཏྠཱཡ དཎྜཾ པྲཱཔྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ཨཧཾ སྭཡཾ ཀིམཔི ཀརྟྟུཾ ན ཤཀྣོམི ཡཐཱ ཤུཎོམི ཏཐཱ ཝིཙཱརཡཱམི མམ ཝིཙཱརཉྩ ནྱཱཡྻཿ ཡཏོཧཾ སྭཱིཡཱབྷཱིཥྚཾ ནེཧིཏྭཱ མཏྤྲེརཡིཏུཿ པིཏུརིཥྚམ྄ ཨཱིཧེ། ");
INSERT INTO santib_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ཡདི སྭསྨིན྄ སྭཡཾ སཱཀྵྱཾ དདཱམི ཏརྷི ཏཏྶཱཀྵྱམ྄ ཨཱགྲཱཧྱཾ བྷཝཏི ; ");
INSERT INTO santib_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ཀིནྟུ མདརྠེ྅པརོ ཛནཿ སཱཀྵྱཾ དདཱཏི མདརྠེ ཏསྱ ཡཏ྄ སཱཀྵྱཾ ཏཏ྄ སཏྱམ྄ ཨེཏདཔྱཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ཡུཥྨཱབྷི ཪྻོཧནཾ པྲཏི ལོཀེཥུ པྲེརིཏེཥུ ས སཏྱཀཐཱཡཱཾ སཱཀྵྱམདདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","མཱནུཥཱདཧཾ སཱཀྵྱཾ ནོཔེཀྵེ ཏཐཱཔི ཡཱུཡཾ ཡཐཱ པརིཏྲཡདྷྭེ ཏདརྠམ྄ ཨིདཾ ཝཱཀྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ཡོཧན྄ དེདཱིཔྱམཱནོ དཱིཔ ཨིཝ ཏེཛསྭཱི སྠིཏཝཱན྄ ཡཱུཡམ྄ ཨལྤཀཱལཾ ཏསྱ དཱིཔྟྱཱནནྡིཏུཾ སམམནྱདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ཀིནྟུ ཏཏྤྲམཱཎཱདཔི མམ གུརུཏརཾ པྲམཱཎཾ ཝིདྱཏེ པིཏཱ མཱཾ པྲེཥྱ ཡདྱཏ྄ ཀརྨྨ སམཱཔཡིཏུཾ ཤཀྟྟིམདདཱཏ྄ མཡཱ ཀྲྀཏཾ ཏཏྟཏ྄ ཀརྨྨ མདརྠེ པྲམཱཎཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ཡཿ པིཏཱ མཱཾ པྲེརིཏཝཱན྄ མོཔི མདརྠེ པྲམཱཎཾ དདཱཏི། ཏསྱ ཝཱཀྱཾ ཡུཥྨཱབྷིཿ ཀདཱཔི ན ཤྲུཏཾ ཏསྱ རཱུཔཉྩ ན དྲྀཥྚཾ ");
INSERT INTO santib_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ཏསྱ ཝཱཀྱཉྩ ཡུཥྨཱཀམ྄ ཨནྟཿ ཀདཱཔི སྠཱནཾ ནཱཔྣོཏི ཡཏཿ ས ཡཾ པྲེཥིཏཝཱན྄ ཡཱུཡཾ ཏསྨིན྄ ན ཝིཤྭསིཐ། ");
INSERT INTO santib_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","དྷརྨྨཔུསྟཀཱནི ཡཱུཡམ྄ ཨཱལོཙཡདྷྭཾ ཏཻ ཪྻཱཀྱཻརནནྟཱཡུཿ པྲཱཔྶྱཱམ ཨིཏི ཡཱུཡཾ བུདྷྱདྷྭེ ཏདྡྷརྨྨཔུསྟཀཱནི མདརྠེ པྲམཱཎཾ དདཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ཏཐཱཔི ཡཱུཡཾ པརམཱཡུཿཔྲཱཔྟཡེ མམ སཾནིདྷིམ྄ ན ཛིགམིཥཐ། ");
INSERT INTO santib_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ཨཧཾ མཱནུཥེབྷྱཿ སཏྐཱརཾ ན གྲྀཧླཱམི། ");
INSERT INTO santib_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ཨཧཾ ཡུཥྨཱན྄ ཛཱནཱམི; ཡུཥྨཱཀམནྟར ཨཱིཤྭརཔྲེམ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ཨཧཾ ནིཛཔིཏུ རྣཱམྣཱགཏོསྨི ཏཐཱཔི མཱཾ ན གྲྀཧླཱིཐ ཀིནྟུ ཀཤྩིད྄ ཡདི སྭནཱམྣཱ སམཱགམིཥྱཏི ཏརྷི ཏཾ གྲཧཱིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ཡཱུཡམ྄ ཨཱིཤྭརཱཏ྄ སཏྐཱརཾ ན ཙིཥྚཏྭཱ ཀེཝལཾ པརསྤརཾ སཏྐཱརམ྄ ཙེད྄ ཨཱདདྷྭྭེ ཏརྷི ཀཐཾ ཝིཤྭསིཏུཾ ཤཀྣུཐ? ");
INSERT INTO santib_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","པུཏུཿ སམཱིཔེ྅ཧཾ ཡུཥྨཱན྄ ཨཔཝདིཥྱཱམཱིཏི མཱ ཙིནྟཡཏ ཡསྨིན྄ , ཡསྨིན྄ ཡུཥྨཱཀཾ ཝིཤྭསཿ སཨེཝ མཱུསཱ ཡུཥྨཱན྄ ཨཔཝདཏི། ");
INSERT INTO santib_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ཡདི ཡཱུཡཾ ཏསྨིན྄ ཝྱཤྭསིཥྱཏ ཏརྷི མཡྻཔི ཝྱཤྭསིཥྱཏ, ཡཏ྄ ས མཡི ལིཁིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ཏཏོ ཡདི ཏེན ལིཁིཏཝཱནི ན པྲཏིཐ ཏརྷི མམ ཝཱཀྱཱནི ཀཐཾ པྲཏྱེཥྱཐ? ");
INSERT INTO santib_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ཏཏཿ པརཾ ཡཱིཤུ རྒཱལཱིལ྄ པྲདེཤཱིཡསྱ ཏིཝིརིཡཱནཱམྣཿ སིནྡྷོཿ པཱརཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ཏཏོ ཝྱཱདྷིམལློཀསྭཱསྠྱཀརཎརཱུཔཱཎི ཏསྱཱཤྩཪྻྱཱཎི ཀརྨྨཱཎི དྲྀཥྚྭཱ བཧཝོ ཛནཱསྟཏྤཤྩཱད྄ ཨགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ཏཏོ ཡཱིཤུཿ པཪྻྭཏམཱརུཧྱ ཏཏྲ ཤིཥྱཻཿ སཱཀམ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ཏསྨིན྄ སམཡ ནིསྟཱརོཏྶཝནཱམྣི ཡིཧཱུདཱིཡཱནཱམ ཨུཏྶཝ ཨུཔསྠིཏེ ");
INSERT INTO santib_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ཡཱིཤུ རྣེཏྲེ ཨུཏྟོལྱ བཧུལོཀཱན྄ སྭསམཱིཔཱགཏཱན྄ ཝིལོཀྱ ཕིལིཔཾ པྲྀཥྚཝཱན྄ ཨེཏེཥཱཾ བྷོཛནཱཡ བྷོཛདྲཝྱཱཎི ཝཡཾ ཀུཏྲ ཀྲེཏུཾ ཤཀྲུམཿ? ");
INSERT INTO santib_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ཝཱཀྱམིདཾ ཏསྱ པརཱིཀྵཱརྠམ྄ ཨཝཱདཱིཏ྄ ཀིནྟུ ཡཏ྄ ཀརིཥྱཏི ཏཏ྄ སྭཡམ྄ ཨཛཱནཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ཕིལིཔཿ པྲཏྱཝོཙཏ྄ ཨེཏེཥཱམ྄ ཨེཀཻཀོ ཡདྱལྤམ྄ ཨལྤཾ པྲཱཔྣོཏི ཏརྷི མུདྲཱཔཱདདྭིཤཏེན ཀྲཱིཏཔཱུཔཱ ཨཔི ནྱཱུནཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ཤིམོན྄ པིཏརསྱ བྷྲཱཏཱ ཨཱནྡྲིཡཱཁྱཿ ཤིཥྱཱཎཱམེཀོ ཝྱཱཧྲྀཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ཨཏྲ ཀསྱཙིད྄ བཱལཀསྱ སམཱིཔེ པཉྩ ཡཱཝཔཱུཔཱཿ ཀྵུདྲམཏྶྱདྭཡཉྩ སནྟི ཀིནྟུ ལོཀཱནཱཾ ཨེཏཱཝཱཏཱཾ མདྷྱེ ཏཻཿ ཀིཾ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","པཤྩཱད྄ ཡཱིཤུརཝདཏ྄ ལོཀཱནུཔཝེཤཡཏ ཏཏྲ བཧུཡཝསསཏྟྭཱཏ྄ པཉྩསཧསྟྲེབྷྱོ ནྱཱུནཱ ཨདྷིཀཱ ཝཱ པུརུཥཱ བྷཱུམྱཱམ྄ ཨུཔཱཝིཤན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ཏཏོ ཡཱིཤུསྟཱན྄ པཱུཔཱནཱདཱཡ ཨཱིཤྭརསྱ གུཎཱན྄ ཀཱིརྟྟཡིཏྭཱ ཤིཥྱེཥུ སམཱརྤཡཏ྄ ཏཏསྟེ ཏེབྷྱ ཨུཔཝིཥྚལོཀེབྷྱཿ པཱུཔཱན྄ ཡཐེཥྚམཏྶྱཉྩ པྲཱདུཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ཏེཥུ ཏྲྀཔྟེཥུ ས ཏཱནཝོཙད྄ ཨེཏེཥཱཾ ཀིཉྩིདཔི ཡཐཱ ནཱཔཙཱིཡཏེ ཏཐཱ སཪྻྭཱཎྱཝཤིཥྚཱནི སཾགྲྀཧླཱིཏ། ");
INSERT INTO santib_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ཏཏཿ སཪྻྭེཥཱཾ བྷོཛནཱཏ྄ པརཾ ཏེ ཏེཥཱཾ པཉྩཱནཱཾ ཡཱཝཔཱུཔཱནཱཾ ཨཝཤིཥྚཱནྱཁིལཱནི སཾགྲྀཧྱ དྭཱདཤཌལླཀཱན྄ ཨཔཱུརཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ཨཔརཾ ཡཱིཤོརེཏཱདྲྀཤཱིམ྄ ཨཱཤྩཪྻྱཀྲིཡཱཾ དྲྀཥྚྭཱ ལོཀཱ མིཐོ ཝཀྟུམཱརེབྷིརེ ཛགཏི ཡསྱཱགམནཾ བྷཝིཥྱཏི ས ཨེཝཱཡམ྄ ཨཝཤྱཾ བྷཝིཥྱདྭཀྟྟཱ། ");
INSERT INTO santib_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ཨཏཨེཝ ལོཀཱ ཨཱགཏྱ ཏམཱཀྲམྱ རཱཛཱནཾ ཀརིཥྱནྟི ཡཱིཤུསྟེཥཱམ྄ ཨཱིདྲྀཤཾ མཱནསཾ ཝིཛྙཱཡ པུནཤྩ པཪྻྭཏམ྄ ཨེཀཱཀཱི གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","སཱཡཾཀཱལ ཨུཔསྠིཏེ ཤིཥྱཱ ཛལདྷིཏཊཾ ཝྲཛིཏྭཱ ནཱཝམཱརུཧྱ ནགརདིཤི སིནྡྷཽ ཝཱཧཡིཏྭཱགམན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ཏསྨིན྄ སམཡེ ཏིམིར ཨུཔཱཏིཥྛཏ྄ ཀིནྟུ ཡཱིཥུསྟེཥཱཾ སམཱིཔཾ ནཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ཏདཱ པྲབལཔཝནཝཧནཱཏ྄ སཱགརེ མཧཱཏརངྒོ བྷཝིཏུམ྄ ཨཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ཏཏསྟེ ཝཱཧཡིཏྭཱ དྭིཏྲཱན྄ ཀྲོཤཱན྄ གཏཱཿ པཤྩཱད྄ ཡཱིཤུཾ ཛལདྷེརུཔརི པདྦྷྱཱཾ ཝྲཛནྟཾ ནཽཀཱནྟིཀམ྄ ཨཱགཙྪནྟཾ ཝིལོཀྱ ཏྲཱསཡུཀྟཱ ཨབྷཝན྄ ");
INSERT INTO santib_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ཀིནྟུ ས ཏཱནུཀྟྟཝཱན྄ ཨཡམཧཾ མཱ བྷཻཥྚ། ");
INSERT INTO santib_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ཏདཱ ཏེ ཏཾ སྭཻརཾ ནཱཝི གྲྀཧཱིཏཝནྟཿ ཏདཱ ཏཏྐྵཎཱད྄ ཨུདྡིཥྚསྠཱནེ ནཽརུཔཱསྠཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ཡཡཱ ནཱཝཱ ཤིཥྱཱ ཨགཙྪན྄ ཏདནྱཱ ཀཱཔི ནཽཀཱ ཏསྨིན྄ སྠཱནེ ནཱསཱིཏ྄ ཏཏོ ཡཱིཤུཿ ཤིཥྱཻཿ སཱཀཾ ནཱགམཏ྄ ཀེཝལཱཿ ཤིཥྱཱ ཨགམན྄ ཨེཏཏ྄ པཱརསྠཱ ལོཀཱ ཛྙཱཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ཀིནྟུ ཏཏཿ པརཾ པྲབྷུ ཪྻཏྲ ཨཱིཤྭརསྱ གུཎཱན྄ ཨནུཀཱིརྟྟྱ ལོཀཱན྄ པཱུཔཱན྄ ཨབྷོཛཡཏ྄ ཏཏྶྠཱནསྱ སམཱིཔསྠཏིཝིརིཡཱཡཱ ཨཔརཱསྟརཎཡ ཨཱགམན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ཡཱིཤུསྟཏྲ ནཱསྟི ཤིཥྱཱ ཨཔི ཏཏྲ ནཱ སནྟི ལོཀཱ ཨིཏི ཝིཛྙཱཡ ཡཱིཤུཾ གཝེཥཡིཏུཾ ཏརཎིབྷིཿ ཀཕརྣཱཧཱུམ྄ པུརཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ཏཏསྟེ སརིཏྤཏེཿ པཱརེ ཏཾ སཱཀྵཱཏ྄ པྲཱཔྱ པྲཱཝོཙན྄ ཧེ གུརོ བྷཝཱན྄ ཨཏྲ སྠཱནེ ཀདཱགམཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ཏདཱ ཡཱིཤུསྟཱན྄ པྲཏྱཝཱདཱིད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཏརཾ ཝདཱམི ཨཱཤྩཪྻྱཀརྨྨདརྴནཱདྡྷེཏོ རྣ ཀིནྟུ པཱུཔབྷོཛནཱཏ྄ ཏེན ཏྲྀཔྟཏྭཱཉྩ མཱཾ གཝེཥཡཐ། ");
INSERT INTO santib_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ཀྵཡཎཱིཡབྷཀྵྱཱརྠཾ མཱ ཤྲཱམིཥྚ ཀིནྟྭནྟཱཡུརྦྷཀྵྱཱརྠཾ ཤྲཱམྱཏ, ཏསྨཱཏ྄ ཏཱདྲྀཤཾ བྷཀྵྱཾ མནུཛཔུཏྲོ ཡུཥྨཱབྷྱཾ དཱསྱཏི; ཏསྨིན྄ ཏཱཏ ཨཱིཤྭརཿ པྲམཱཎཾ པྲཱདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཨཱིཤྭརཱབྷིམཏཾ ཀརྨྨ ཀརྟྟུམ྄ ཨསྨཱབྷིཿ ཀིཾ ཀརྟྟཝྱཾ? ");
INSERT INTO santib_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ཏཏོ ཡཱིཤུརཝདད྄ ཨཱིཤྭརོ ཡཾ པྲཻརཡཏ྄ ཏསྨིན྄ ཝིཤྭསནམ྄ ཨཱིཤྭརཱབྷིམཏཾ ཀརྨྨ། ");
INSERT INTO santib_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ཏདཱ ཏེ ཝྱཱཧརན྄ བྷཝཏཱ ཀིཾ ལཀྵཎཾ དརྴིཏཾ ཡདྡྲྀཥྚྭཱ བྷཝཏི ཝིཤྭསིཥྱཱམཿ? ཏྭཡཱ ཀིཾ ཀརྨྨ ཀྲྀཏཾ? ");
INSERT INTO santib_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱ མཧཱཔྲཱནྟརེ མཱནྣཱཾ བྷོཀྟྟུཾ པྲཱཔུཿ ཡཐཱ ལིཔིརཱསྟེ། སྭརྒཱིཡཱཎི ཏུ བྷཀྵྱཱཎི པྲདདཽ པརམེཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ཏདཱ ཡཱིཤུརཝདད྄ ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི མཱུསཱ ཡུཥྨཱབྷྱཾ སྭརྒཱིཡཾ བྷཀྵྱཾ ནཱདཱཏ྄ ཀིནྟུ མམ པིཏཱ ཡུཥྨཱབྷྱཾ སྭརྒཱིཡཾ པརམཾ བྷཀྵྱཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ཡཿ སྭརྒཱདཝརུཧྱ ཛགཏེ ཛཱིཝནཾ དདཱཏི ས ཨཱིཤྭརདཏྟབྷཀྵྱརཱུཔཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ཏདཱ ཏེ པྲཱཝོཙན྄ ཧེ པྲབྷོ བྷཀྵྱམིདཾ ནིཏྱམསྨབྷྱཾ དདཱཏུ། ");
INSERT INTO santib_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ཡཱིཤུརཝདད྄ ཨཧམེཝ ཛཱིཝནརཱུཔཾ བྷཀྵྱཾ ཡོ ཛནོ མམ སནྣིདྷིམ྄ ཨཱགཙྪཏི ས ཛཱཏུ ཀྵུདྷཱརྟྟོ ན བྷཝིཥྱཏི, ཏཐཱ ཡོ ཛནོ མཱཾ པྲཏྱེཏི ས ཛཱཏུ ཏྲྀཥཱརྟྟོ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","མཱཾ དྲྀཥྚྭཱཔི ཡཱུཡཾ ན ཝིཤྭསིཐ ཡུཥྨཱནཧམ྄ ཨིཏྱཝོཙཾ། ");
INSERT INTO santib_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","པིཏཱ མཧྱཾ ཡཱཝཏོ ལོཀཱནདདཱཏ྄ ཏེ སཪྻྭ ཨེཝ མམཱནྟིཀམ྄ ཨཱགམིཥྱནྟི ཡཿ ཀཤྩིཙྩ མམ སནྣིདྷིམ྄ ཨཱཡཱསྱཏི ཏཾ ཀེནཱཔི པྲཀཱརེཎ ན དཱུརཱིཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ནིཛཱབྷིམཏཾ སཱདྷཡིཏུཾ ན ཧི ཀིནྟུ པྲེརཡིཏུརབྷིམཏཾ སཱདྷཡིཏུཾ སྭརྒཱད྄ ཨཱགཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ས ཡཱན྄ ཡཱན྄ ལོཀཱན྄ མཧྱམདདཱཏ྄ ཏེཥཱམེཀམཔི ན ཧཱརཡིཏྭཱ ཤེཥདིནེ སཪྻྭཱནཧམ྄ ཨུཏྠཱཔཡཱམི ཨིདཾ མཏྤྲེརཡིཏུཿ པིཏུརབྷིམཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ཡཿ ཀཤྩིན྄ མཱནཝསུཏཾ ཝིལོཀྱ ཝིཤྭསིཏི ས ཤེཥདིནེ མཡོཏྠཱཔིཏཿ སན྄ ཨནནྟཱཡུཿ པྲཱཔྶྱཏི ཨིཏི མཏྤྲེརཀསྱཱབྷིམཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ཏདཱ སྭརྒཱད྄ ཡད྄ བྷཀྵྱམ྄ ཨཝཱརོཧཏ྄ ཏད྄ བྷཀྵྱམ྄ ཨཧམེཝ ཡིཧཱུདཱིཡལོཀཱསྟསྱཻཏད྄ ཝཱཀྱེ ཝིཝདམཱནཱ ཝཀྟྟུམཱརེབྷིརེ ");
INSERT INTO santib_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ཡཱུཥཕཿ པུཏྲོ ཡཱིཤུ ཪྻསྱ མཱཏཱཔིཏརཽ ཝཡཾ ཛཱནཱིམ ཨེཥ ཀིཾ སཨེཝ ན? ཏརྷི སྭརྒཱད྄ ཨཝཱརོཧམ྄ ཨིཏི ཝཱཀྱཾ ཀཐཾ ཝཀྟྟི? ");
INSERT INTO santib_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ཏདཱ ཡཱིཤུསྟཱན྄ པྲཏྱཝདཏ྄ པརསྤརཾ མཱ ཝིཝདདྷྭཾ ");
INSERT INTO santib_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","མཏྤྲེརཀེཎ པིཏྲཱ ནཱཀྲྀཥྚཿ ཀོཔི ཛནོ མམཱནྟིཀམ྄ ཨཱཡཱཏུཾ ན ཤཀྣོཏི ཀིནྟྭཱགཏཾ ཛནཾ ཙརམེ྅ཧྣི པྲོཏྠཱཔཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ཏེ སཪྻྭ ཨཱིཤྭརེཎ ཤིཀྵིཏཱ བྷཝིཥྱནྟི བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ ལིཔིརིཏྠམཱསྟེ ཨཏོ ཡཿ ཀཤྩིཏ྄ པིཏུཿ སཀཱཤཱཏ྄ ཤྲུཏྭཱ ཤིཀྵཏེ ས ཨེཝ མམ སམཱིཔམ྄ ཨཱགམིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ཡ ཨཱིཤྭརཱད྄ ཨཛཱཡཏ ཏཾ ཝིནཱ ཀོཔི མནུཥྱོ ཛནཀཾ ནཱདརྴཏ྄ ཀེཝལཿ སཨེཝ ཏཱཏམ྄ ཨདྲཱཀྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ཨཧཾ ཡུཥྨཱན྄ ཡཐཱརྠཏརཾ ཝདཱམི ཡོ ཛནོ མཡི ཝིཤྭཱསཾ ཀརོཏི སོནནྟཱཡུཿ པྲཱཔྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ཨཧམེཝ ཏཛྫཱིཝནབྷཀྵྱཾ། ");
INSERT INTO santib_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥཱ མཧཱཔྲཱནྟརེ མནྣཱབྷཀྵྱཾ བྷཱུཀྟྟཱཔི མྲྀཏཱཿ ");
INSERT INTO santib_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ཀིནྟུ ཡདྦྷཀྵྱཾ སྭརྒཱདཱགཙྪཏ྄ ཏད྄ ཡདི ཀཤྩིད྄ བྷུངྐྟྟེ ཏརྷི ས ན མྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ཡཛྫཱིཝནབྷཀྵྱཾ སྭརྒཱདཱགཙྪཏ྄ སོཧམེཝ ཨིདཾ བྷཀྵྱཾ ཡོ ཛནོ བྷུངྐྟྟེ ས ནིཏྱཛཱིཝཱི བྷཝིཥྱཏི། པུནཤྩ ཛགཏོ ཛཱིཝནཱརྠམཧཾ ཡཏ྄ སྭཀཱིཡཔིཤིཏཾ དཱསྱཱམི ཏདེཝ མཡཱ ཝིཏརིཏཾ བྷཀྵྱམ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ཏསྨཱད྄ ཡིཧཱུདཱིཡཱཿ པརསྤརཾ ཝིཝདམཱནཱ ཝཀྟྟུམཱརེབྷིརེ ཨེཥ བྷོཛནཱརྠཾ སྭཱིཡཾ པལལཾ ཀཐམ྄ ཨསྨབྷྱཾ དཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ཏདཱ ཡཱིཤུསྟཱན྄ ཨཱཝོཙད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཏརཾ ཝདཱམི མནུཥྱཔུཏྲསྱཱམིཥེ ཡུཥྨཱབྷི རྣ བྷུཀྟྟེ ཏསྱ རུདྷིརེ ཙ ན པཱིཏེ ཛཱིཝནེན སཱརྡྡྷཾ ཡུཥྨཱཀཾ སམྦནྡྷོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ཡོ མམཱམིཥཾ སྭཱདཏི མམ སུདྷིརཉྩ པིཝཏི སོནནྟཱཡུཿ པྲཱཔྣོཏི ཏཏཿ ཤེཥེ྅ཧྣི ཏམཧམ྄ ཨུཏྠཱཔཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ཡཏོ མདཱིཡམཱམིཥཾ པརམཾ བྷཀྵྱཾ ཏཐཱ མདཱིཡཾ ཤོཎིཏཾ པརམཾ པེཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ཡོ ཛནོ མདཱིཡཾ པལལཾ སྭཱདཏི མདཱིཡཾ རུདྷིརཉྩ པིཝཏི ས མཡི ཝསཏི ཏསྨིནྣཧཉྩ ཝསཱམི། ");
INSERT INTO santib_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","མཏྤྲེརཡིཏྲཱ ཛཱིཝཏཱ ཏཱཏེན ཡཐཱཧཾ ཛཱིཝཱམི ཏདྭད྄ ཡཿ ཀཤྩིན྄ མཱམཏྟི སོཔི མཡཱ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ཡདྦྷཀྵྱཾ སྭརྒཱདཱགཙྪཏ྄ ཏདིདཾ ཡནྨཱནྣཱཾ སྭཱདིཏྭཱ ཡུཥྨཱཀཾ པིཏརོ྅མྲིཡནྟ ཏཱདྲྀཤམ྄ ཨིདཾ བྷཀྵྱཾ ན བྷཝཏི ཨིདཾ བྷཀྵྱཾ ཡོ བྷཀྵཏི ས ནིཏྱཾ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ཡདཱ ཀཕརྣཱཧཱུམ྄ པུཪྻྱཱཾ བྷཛནགེཧེ ཨུཔཱདིཤཏ྄ ཏདཱ ཀཐཱ ཨེཏཱ ཨཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ཏདེཏྠཾ ཤྲུཏྭཱ ཏསྱ ཤིཥྱཱཎཱམ྄ ཨནེཀེ པརསྤརམ྄ ཨཀཐཡན྄ ཨིདཾ གཱཌྷཾ ཝཱཀྱཾ ཝཱཀྱམཱིདྲྀཤཾ ཀཿ ཤྲོཏུཾ ཤཀྲུཡཱཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ཀིནྟུ ཡཱིཤུཿ ཤིཥྱཱཎཱམ྄ ཨིཏྠཾ ཝིཝཱདཾ སྭཙིཏྟེ ཝིཛྙཱཡ ཀཐིཏཝཱན྄ ཨིདཾ ཝཱཀྱཾ ཀིཾ ཡུཥྨཱཀཾ ཝིགྷྣཾ ཛནཡཏི? ");
INSERT INTO santib_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ཡདི མནུཛསུཏཾ པཱུཪྻྭཝཱསསྠཱནམ྄ ཨཱུརྡྭྭཾ གཙྪནྟཾ པཤྱཐ ཏརྷི ཀིཾ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ཨཱཏྨཻཝ ཛཱིཝནདཱཡཀཿ ཝཔུ རྣིཥྥལཾ ཡུཥྨབྷྱམཧཾ ཡཱནི ཝཙཱཾསི ཀཐཡཱམི ཏཱནྱཱཏྨཱ ཛཱིཝནཉྩ། ");
INSERT INTO santib_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ཀིནྟུ ཡུཥྨཱཀཾ མདྷྱེ ཀེཙན ཨཝིཤྭཱསིནཿ སནྟི ཀེ ཀེ ན ཝིཤྭསནྟི ཀོ ཝཱ ཏཾ པརཀརེཥུ སམརྤཡིཥྱཏི ཏཱན྄ ཡཱིཤུརཱཔྲཐམཱད྄ ཝེཏྟི། ");
INSERT INTO santib_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ཨཔརམཔི ཀཐིཏཝཱན྄ ཨསྨཱཏ྄ ཀཱརཎཱད྄ ཨཀཐཡཾ པིཏུཿ སཀཱཤཱཏ྄ ཤཀྟྟིམཔྲཱཔྱ ཀོཔི མམཱནྟིཀམ྄ ཨཱགནྟུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ཏཏྐཱལེ྅ནེཀེ ཤིཥྱཱ ཝྱཱགྷུཊྱ ཏེན སཱརྡྡྷཾ པུན རྣཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ཏདཱ ཡཱིཤུ རྡྭཱདཤཤིཥྱཱན྄ ཨུཀྟྟཝཱན྄ ཡཱུཡམཔི ཀིཾ ཡཱསྱཐ? ");
INSERT INTO santib_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ཏཏཿ ཤིམོན྄ པིཏརཿ པྲཏྱཝོཙཏ྄ ཧེ པྲབྷོ ཀསྱཱབྷྱརྞཾ གམིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ཨནནྟཛཱིཝནདཱཡིནྱོ ཡཱཿ ཀཐཱསྟཱསྟཝཻཝ། བྷཝཱན྄ ཨམརེཤྭརསྱཱབྷིཥིཀྟྟཔུཏྲ ཨིཏི ཝིཤྭསྱ ནིཤྩིཏཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ཏདཱ ཡཱིཤུརཝདཏ྄ ཀིམཧཾ ཡུཥྨཱཀཾ དྭཱདཤཛནཱན྄ མནོནཱིཏཱན྄ ན ཀྲྀཏཝཱན྄? ཀིནྟུ ཡུཥྨཱཀཾ མདྷྱེཔི ཀཤྩིདེཀོ ཝིགྷྣཀཱརཱི ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ཨིམཱཾ ཀཐཾ ས ཤིམོནཿ པུཏྲམ྄ ཨཱིཥྐརཱིཡོཏཱིཡཾ ཡིཧཱུདཱམ྄ ཨུདྡིཤྱ ཀཐིཏཝཱན྄ ཡཏོ དྭཱདཤཱནཱཾ མདྷྱེ གཎིཏཿ ས ཏཾ པརཀརེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ཏཏཿ པརཾ ཡིཧཱུདཱིཡལོཀཱསྟཾ ཧནྟུཾ སམཻཧནྟ ཏསྨཱད྄ ཡཱིཤུ ཪྻིཧཱུདཱཔྲདེཤེ པཪྻྱཊིཏུཾ ནེཙྪན྄ གཱལཱིལ྄ པྲདེཤེ པཪྻྱཊིཏུཾ པྲཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ཀིནྟུ ཏསྨིན྄ སམཡེ ཡིཧཱུདཱིཡཱནཱཾ དཱུཥྱཝཱསནཱམོཏྶཝ ཨུཔསྠིཏེ ");
INSERT INTO santib_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ཏསྱ བྷྲཱཏརསྟམ྄ ཨཝདན྄ ཡཱནི ཀརྨྨཱཎི ཏྭཡཱ ཀྲིཡནྟེ ཏཱནི ཡཐཱ ཏཝ ཤིཥྱཱཿ པཤྱནྟི ཏདརྠཾ ཏྭམིཏཿ སྠཱནཱད྄ ཡིཧཱུདཱིཡདེཤཾ ཝྲཛ། ");
INSERT INTO santib_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ཡཿ ཀཤྩིཏ྄ སྭཡཾ པྲཙིཀཱཤིཥཏི ས ཀདཱཔི གུཔྟཾ ཀརྨྨ ན ཀརོཏི ཡདཱིདྲྀཤཾ ཀརྨྨ ཀརོཥི ཏརྷི ཛགཏི ནིཛཾ པརིཙཱཡཡ། ");
INSERT INTO santib_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ཡཏསྟསྱ བྷྲཱཏརོཔི ཏཾ ན ཝིཤྭསནྟི། ");
INSERT INTO santib_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ཏདཱ ཡཱིཤུསྟཱན྄ ཨཝོཙཏ྄ མམ སམཡ ཨིདཱནཱིཾ ནོཔཏིཥྛཏི ཀིནྟུ ཡུཥྨཱཀཾ སམཡཿ སཏཏམ྄ ཨུཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ཛགཏོ ལོཀཱ ཡུཥྨཱན྄ ཨྲྀཏཱིཡིཏུཾ ན ཤཀྲུཝནྟི ཀིནྟུ མཱམེཝ ཨྲྀཏཱིཡནྟེ ཡཏསྟེཥཱཾ ཀརྨཱཎི དུཥྚཱནི ཏཏྲ སཱཀྵྱམིདམ྄ ཨཧཾ དདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ཨཏཨེཝ ཡཱུཡམ྄ ཨུཏྶཝེ྅སྨིན྄ ཡཱཏ ནཱཧམ྄ ཨིདཱནཱིམ྄ ཨསྨིནྣུཏྶཝེ ཡཱམི ཡཏོ མམ སམཡ ཨིདཱནཱིཾ ན སམྤཱུརྞཿ། ");
INSERT INTO santib_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ཨིཏི ཝཱཀྱམ྄ ཨུཀྟྟྭཱ ས གཱལཱིལི སྠིཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ཀིནྟུ ཏསྱ བྷྲཱཏྲྀཥུ ཏཏྲ པྲསྠིཏེཥུ སཏྶུ སོ྅པྲཀཊ ཨུཏྶཝམ྄ ཨགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ཨནནྟརམ྄ ཨུཏྶཝམ྄ ཨུཔསྠིཏཱ ཡིཧཱུདཱིཡཱསྟཾ མྲྀགཡིཏྭཱཔྲྀཙྪན྄ ས ཀུཏྲ? ");
INSERT INTO santib_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ཏཏོ ལོཀཱནཱཾ མདྷྱེ ཏསྨིན྄ ནཱནཱཝིདྷཱ ཝིཝཱདཱ བྷཝིཏུམ྄ ཨཱརབྡྷཝནྟཿ། ཀེཙིད྄ ཨཝོཙན྄ ས ཨུཏྟམཿ པུརུཥཿ ཀེཙིད྄ ཨཝོཙན྄ ན ཏཐཱ ཝརཾ ལོཀཱནཱཾ བྷྲམཾ ཛནཡཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ཀིནྟུ ཡིཧཱུདཱིཡཱནཱཾ བྷཡཱཏ྄ ཀོཔི ཏསྱ པཀྵེ སྤཥྚཾ ནཱཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ཏཏཿ པརམ྄ ཨུཏྶཝསྱ མདྷྱསམཡེ ཡཱིཤུ རྨནྡིརཾ གཏྭཱ སམུཔདིཤཏི སྨ། ");
INSERT INTO santib_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ཏཏོ ཡིཧཱུདཱིཡཱ ལོཀཱ ཨཱཤྩཪྻྱཾ ཛྙཱཏྭཱཀཐཡན྄ ཨེཥཱ མཱནུཥོ ནཱདྷཱིཏྱཱ ཀཐམ྄ ཨེཏཱདྲྀཤོ ཝིདྭཱནབྷཱུཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ཏདཱ ཡཱིཤུཿ པྲཏྱཝོཙད྄ ཨུཔདེཤོཡཾ ན མམ ཀིནྟུ ཡོ མཱཾ པྲེཥིཏཝཱན྄ ཏསྱ། ");
INSERT INTO santib_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ཡོ ཛནོ ནིདེཤཾ ཏསྱ གྲཧཱིཥྱཏི མམོཔདེཤོ མཏྟོ བྷཝཏི ཀིམ྄ ཨཱིཤྭརཱད྄ བྷཝཏི ས གནསྟཛྫྙཱཏུཾ ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ཡོ ཛནཿ སྭཏཿ ཀཐཡཏི ས སྭཱིཡཾ གཽརཝམ྄ ཨཱིཧཏེ ཀིནྟུ ཡཿ པྲེརཡིཏུ རྒཽརཝམ྄ ཨཱིཧཏེ ས སཏྱཝཱདཱི ཏསྨིན྄ ཀོཔྱདྷརྨྨོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","མཱུསཱ ཡུཥྨབྷྱཾ ཝྱཝསྠཱགྲནྠཾ ཀིཾ ནཱདདཱཏ྄? ཀིནྟུ ཡུཥྨཱཀཾ ཀོཔི ཏཱཾ ཝྱཝསྠཱཾ ན སམཱཙརཏི། མཱཾ ཧནྟུཾ ཀུཏོ ཡཏདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ཏདཱ ལོཀཱ ཨཝདན྄ ཏྭཾ བྷཱུཏགྲསྟསྟྭཱཾ ཧནྟུཾ ཀོ ཡཏཏེ? ");
INSERT INTO santib_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ཏཏོ ཡཱིཤུརཝོཙད྄ ཨེཀཾ ཀརྨྨ མཡཱཀཱརི ཏསྨཱད྄ ཡཱུཡཾ སཪྻྭ མཧཱཤྩཪྻྱཾ མནྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","མཱུསཱ ཡུཥྨབྷྱཾ ཏྭཀྪེདཝིདྷིཾ པྲདདཽ ས མཱུསཱཏོ ན ཛཱཏཿ ཀིནྟུ པིཏྲྀཔུརུཥེབྷྱོ ཛཱཏཿ ཏེན ཝིཤྲཱམཝཱརེ྅པི མཱནུཥཱཎཱཾ ཏྭཀྪེདཾ ཀུརུཐ། ");
INSERT INTO santib_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ཨཏཨེཝ ཝིཤྲཱམཝཱརེ མནུཥྱཱཎཱཾ ཏྭཀྪེདེ ཀྲྀཏེ ཡདི མཱུསཱཝྱཝསྠཱམངྒནཾ ན བྷཝཏི ཏརྷི མཡཱ ཝིཤྲཱམཝཱརེ མཱནུཥཿ སམྤཱུརྞརཱུཔེཎ སྭསྠོ྅ཀཱརི ཏཏྐཱརཎཱད྄ ཡཱུཡཾ ཀིཾ མཧྱཾ ཀུཔྱཐ? ");
INSERT INTO santib_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","སཔཀྵཔཱཏཾ ཝིཙཱརམཀྲྀཏྭཱ ནྱཱཡྻཾ ཝིཙཱརཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ཏདཱ ཡིརཱུཤཱལམ྄ ནིཝཱསིནཿ ཀཏིཔཡཛནཱ ཨཀཐཡན྄ ཨིམེ ཡཾ ཧནྟུཾ ཙེཥྚནྟེ ས ཨེཝཱཡཾ ཀིཾ ན? ");
INSERT INTO santib_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ཀིནྟུ པཤྱཏ ནིརྦྷཡཿ སན྄ ཀཐཱཾ ཀཐཡཏི ཏཐཱཔི ཀིམཔི ཨ ཝདནྟྱེཏེ ཨཡམེཝཱབྷིཥིཀྟྟོ བྷཝཏཱིཏི ནིཤྩིཏཾ ཀིམདྷིཔཏཡོ ཛཱནནྟི? ");
INSERT INTO santib_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","མནུཛོཡཾ ཀསྨཱདཱགམད྄ ཨིཏི ཝཡཾ ཛཱནོམཿ ཀིནྟྭབྷིཥིཀྟྟ ཨཱགཏེ ས ཀསྨཱདཱགཏཝཱན྄ ཨིཏི ཀོཔི ཛྙཱཏུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ཏདཱ ཡཱིཤུ རྨདྷྱེམནྡིརམ྄ ཨུཔདིཤན྄ ཨུཙྩཻཿཀཱརམ྄ ཨུཀྟྟཝཱན྄ ཡཱུཡཾ ཀིཾ མཱཾ ཛཱནཱིཐ? ཀསྨཱཙྩཱགཏོསྨི ཏདཔི ཀིཾ ཛཱནཱིཐ? ནཱཧཾ སྭཏ ཨཱགཏོསྨི ཀིནྟུ ཡཿ སཏྱཝཱདཱི སཨེཝ མཱཾ པྲེཥིཏཝཱན྄ ཡཱུཡཾ ཏཾ ན ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ཏམཧཾ ཛཱནེ ཏེནཱཧཾ པྲེརིཏ ཨགཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ཏསྨཱད྄ ཡིཧཱུདཱིཡཱསྟཾ དྷརྟྟུམ྄ ཨུདྱཏཱསྟཐཱཔི ཀོཔི ཏསྱ གཱཏྲེ ཧསྟཾ ནཱརྤཡད྄ ཡཏོ ཧེཏོསྟདཱ ཏསྱ སམཡོ ནོཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ཀིནྟུ བཧཝོ ལོཀཱསྟསྨིན྄ ཝིཤྭསྱ ཀཐིཏཝཱནྟོ྅བྷིཥིཀྟྟཔུརུཥ ཨཱགཏྱ མཱནུཥསྱཱསྱ ཀྲིཡཱབྷྱཿ ཀིམ྄ ཨདྷིཀཱ ཨཱཤྩཪྻྱཱཿ ཀྲིཡཱཿ ཀརིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ཏཏཿ པརཾ ལོཀཱསྟསྨིན྄ ཨིཏྠཾ ཝིཝདནྟེ ཕིརཱུཤིནཿ པྲདྷཱནཡཱཛཀཱཉྩེཏི ཤྲུཏཝནྟསྟཾ དྷྲྀཏྭཱ ནེཏུཾ པདཱཏིགཎཾ པྲེཥཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ཏཏོ ཡཱིཤུརཝདད྄ ཨཧམ྄ ཨལྤདིནཱནི ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ སྠིཏྭཱ མཏྤྲེརཡིཏུཿ སམཱིཔཾ ཡཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","མཱཾ མྲྀགཡིཥྱདྷྭེ ཀིནྟཱུདྡེཤཾ ན ལཔྶྱདྷྭེ རཏྲ སྠཱསྱཱམི ཏཏྲ ཡཱུཡཾ གནྟུཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ཏདཱ ཡིཧཱུདཱིཡཱཿ པརསྤརཾ ཝཀྟྟུམཱརེབྷིརེ ཨསྱོདྡེཤཾ ན པྲཱཔྶྱཱམ ཨེཏཱདྲྀཤཾ ཀིཾ སྠཱནཾ ཡཱསྱཏི? བྷིནྣདེཤེ ཝིཀཱིརྞཱནཱཾ ཡིཧཱུདཱིཡཱནཱཾ སནྣིདྷིམ྄ ཨེཥ གཏྭཱ ཏཱན྄ ཨུཔདེཀྵྱཏི ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ནོ ཙེཏ྄ མཱཾ གཝེཥཡིཥྱཐ ཀིནྟཱུདྡེཤཾ ན པྲཱཔྶྱཐ ཨེཥ ཀོདྲྀཤཾ ཝཱཀྱམིདཾ ཝདཏི? ");
INSERT INTO santib_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ཨནནྟརམ྄ ཨུཏྶཝསྱ ཙརམེ྅ཧནི ཨརྠཱཏ྄ པྲདྷཱནདིནེ ཡཱིཤུརུཏྟིཥྛན྄ ཨུཙྩཻཿཀཱརམ྄ ཨཱཧྭཡན྄ ཨུདིཏཝཱན྄ ཡདི ཀཤྩིཏ྄ ཏྲྀཥཱརྟྟོ བྷཝཏི ཏརྷི མམཱནྟིཀམ྄ ཨཱགཏྱ པིཝཏུ། ");
INSERT INTO santib_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ཡཿ ཀཤྩིནྨཡི ཝིཤྭསིཏི དྷརྨྨགྲནྠསྱ ཝཙནཱནུསཱརེཎ ཏསྱཱབྷྱནྟརཏོ྅མྲྀཏཏོཡསྱ སྲོཏཱཾསི ནིརྒམིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ཡེ ཏསྨིན྄ ཝིཤྭསནྟི ཏ ཨཱཏྨཱནཾ པྲཱཔྶྱནྟཱིཏྱརྠེ ས ཨིདཾ ཝཱཀྱཾ ཝྱཱཧྲྀཏཝཱན྄ ཨེཏཏྐཱལཾ ཡཱཝད྄ ཡཱིཤུ ཪྻིབྷཝཾ ན པྲཱཔྟསྟསྨཱཏ྄ པཝིཏྲ ཨཱཏྨཱ ནཱདཱིཡཏ། ");
INSERT INTO santib_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ཨེཏཱཾ ཝཱཎཱིཾ ཤྲུཏྭཱ བཧཝོ ལོཀཱ ཨཝདན྄ ཨཡམེཝ ནིཤྩིཏཾ ས བྷཝིཥྱདྭཱདཱི། ");
INSERT INTO santib_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ཀེཙིད྄ ཨཀཐཡན྄ ཨེཥཨེཝ སོབྷིཥིཀྟྟཿ ཀིནྟུ ཀེཙིད྄ ཨཝདན྄ སོབྷིཥིཀྟྟཿ ཀིཾ གཱལཱིལ྄ པྲདེཤེ ཛནིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","སོབྷིཥིཀྟྟོ དཱཡཱུདོ ཝཾཤེ དཱཡཱུདོ ཛནྨསྠཱནེ བཻཏླེཧམི པཏྟནེ ཛནིཥྱཏེ དྷརྨྨགྲནྠེ ཀིམིཏྠཾ ལིཁིཏཾ ནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ཨིཏྠཾ ཏསྨིན྄ ལོཀཱནཱཾ བྷིནྣཝཱཀྱཏཱ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ཀཏིཔཡལོཀཱསྟཾ དྷརྟྟུམ྄ ཨཻཙྪན྄ ཏཐཱཔི ཏདྭཔུཥི ཀོཔི ཧསྟཾ ནཱརྤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ཨནནྟརཾ པཱདཱཏིགཎེ པྲདྷཱནཡཱཛཀཱནཱཾ ཕིརཱུཤིནཱཉྩ སམཱིཔམཱགཏཝཏི ཏེ ཏཱན྄ ཨཔྲྀཙྪན྄ ཀུཏོ ཧེཏོསྟཾ ནཱནཡཏ? ");
INSERT INTO santib_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ཏདཱ པདཱཏཡཿ པྲཏྱཝདན྄ ས མཱནཝ ཨིཝ ཀོཔི ཀདཱཔི ནོཔཱདིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ཏཏཿ ཕིརཱུཤིནཿ པྲཱཝོཙན྄ ཡཱུཡམཔི ཀིམབྷྲཱམིཥྚ? ");
INSERT INTO santib_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ཨདྷིཔཏཱིནཱཾ ཕིརཱུཤིནཱཉྩ ཀོཔི ཀིཾ ཏསྨིན྄ ཝྱཤྭསཱིཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ཡེ ཤཱསྟྲཾ ན ཛཱནནྟི ཏ ཨིམེ྅དྷམལོཀཱཨེཝ ཤཱཔགྲསྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ཏདཱ ནིཀདཱིམནཱམཱ ཏེཥཱམེཀོ ཡཿ ཀྵཎདཱཡཱཾ ཡཱིཤོཿ སནྣིདྷིམ྄ ཨགཱཏ྄ ས ཨུཀྟྟཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ཏསྱ ཝཱཀྱེ ན ཤྲུཏེ ཀརྨྨཎི ཙ ན ཝིདིཏེ ྅སྨཱཀཾ ཝྱཝསྠཱ ཀིཾ ཀཉྩན མནུཛཾ དོཥཱིཀརོཏི? ");
INSERT INTO santib_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ཏཏསྟེ ཝྱཱཧརན྄ ཏྭམཔི ཀིཾ གཱལཱིལཱིཡལོཀཿ? ཝིཝིཙྱ པཤྱ གལཱིལི ཀོཔི བྷཝིཥྱདྭཱདཱི ནོཏྤདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ཏཏཿ པརཾ སཪྻྭེ སྭཾ སྭཾ གྲྀཧཾ གཏཱཿ ཀིནྟུ ཡཱིཤུ རྫཻཏུནནཱམཱནཾ ཤིལོཙྩཡཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","པྲཏྱཱུཥེ ཡཱིཤུཿ པནརྨནྡིརམ྄ ཨཱགཙྪཏ྄ ");
INSERT INTO santib_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ཏཏཿ སཪྻྭེཥུ ལོཀེཥུ ཏསྱ སམཱིཔ ཨཱགཏེཥུ ས ཨུཔཝིཤྱ ཏཱན྄ ཨུཔདེཥྚུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ཏདཱ ཨདྷྱཱཔཀཱཿ ཕིརཱུཤིནཉྩ ཝྱབྷིཙཱརཀརྨྨཎི དྷྲྀཏཾ སྟྲིཡམེཀཱམ྄ ཨཱནིཡ སཪྻྭེཥཱཾ མདྷྱེ སྠཱཔཡིཏྭཱ ཝྱཱཧརན྄ ");
INSERT INTO santib_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ཧེ གུརོ ཡོཥིཏམ྄ ཨིམཱཾ ཝྱབྷིཙཱརཀརྨྨ ཀུཪྻྭཱཎཱཾ ལོཀཱ དྷྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ཨེཏཱདྲྀཤལོཀཱཿ པཱཥཱཎཱགྷཱཏེན ཧནྟཝྱཱ ཨིཏི ཝིདྷིརྨཱུསཱཝྱཝསྠཱགྲནྠེ ལིཁིཏོསྟི ཀིནྟུ བྷཝཱན྄ ཀིམཱདིཤཏི? ");
INSERT INTO santib_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ཏེ ཏམཔཝདིཏུཾ པརཱིཀྵཱབྷིཔྲཱཡེཎ ཝཱཀྱམིདམ྄ ཨཔྲྀཙྪན྄ ཀིནྟུ ས པྲཧྭཱིབྷཱུཡ བྷཱུམཱཝངྒལྱཱ ལེཁིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ཏཏསྟཻཿ པུནཿ པུནཿ པྲྀཥྚ ཨུཏྠཱཡ ཀཐིཏཝཱན྄ ཡུཥྨཱཀཾ མདྷྱེ ཡོ ཛནོ ནིརཔརཱདྷཱི སཨེཝ པྲཐམམ྄ ཨེནཱཾ པཱཥཱཎེནཱཧནྟུ། ");
INSERT INTO santib_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","པཤྩཱཏ྄ ས པུནཤྩ པྲཧྭཱིབྷཱུཡ བྷཱུམཽ ལེཁིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ཏཱཾ ཀཐཾ ཤྲུཏྭཱ ཏེ སྭསྭམནསི པྲབོདྷཾ པྲཱཔྱ ཛྱེཥྛཱནུཀྲམཾ ཨེཀཻཀཤཿ སཪྻྭེ བཧིརགཙྪན྄ ཏཏོ ཡཱིཤུརེཀཱཀཱི ཏཡཀྟྟོབྷཝཏ྄ མདྷྱསྠཱནེ དཎྜཱཡམཱནཱ སཱ ཡོཥཱ ཙ སྠིཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ཏཏྤཤྩཱད྄ ཡཱིཤུརུཏྠཱཡ ཏཱཾ ཝནིཏཱཾ ཝིནཱ ཀམཔྱཔརཾ ན ཝིལོཀྱ པྲྀཥྚཝཱན྄ ཧེ ཝཱམེ ཏཝཱཔཝཱདཀཱཿ ཀུཏྲ? ཀོཔི ཏྭཱཾ ཀིཾ ན དཎྜཡཏི? ");
INSERT INTO santib_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","སཱཝདཏ྄ ཧེ མཧེཙྪ ཀོཔི ན ཏདཱ ཡཱིཤུརཝོཙཏ྄ ནཱཧམཔི དཎྜཡཱམི ཡཱཧི པུནཿ པཱཔཾ མཱཀཱརྵཱིཿ། ");
INSERT INTO santib_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ཏཏོ ཡཱིཤུཿ པུནརཔི ལོཀེབྷྱ ཨིཏྠཾ ཀཐཡིཏུམ྄ ཨཱརབྷཏ ཛགཏོཧཾ ཛྱོཏིཿསྭརཱུཔོ ཡཿ ཀཤྩིན྄ མཏྤཤྩཱད གཙྪཏི ས ཏིམིརེ ན བྷྲམིཏྭཱ ཛཱིཝནརཱུཔཱཾ དཱིཔྟིཾ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ཏཏཿ ཕིརཱུཤིནོ྅ཝཱདིཥུསྟྭཾ སྭཱརྠེ སྭཡཾ སཱཀྵྱཾ དདཱསི ཏསྨཱཏ྄ ཏཝ སཱཀྵྱཾ གྲཱཧྱཾ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ཏདཱ ཡཱིཤུཿ པྲཏྱུདིཏཝཱན྄ ཡདྱཔི སྭཱརྠེ྅ཧཾ སྭཡཾ སཱཀྵྱཾ དདཱམི ཏཐཱཔི མཏ྄ སཱཀྵྱཾ གྲཱཧྱཾ ཡསྨཱད྄ ཨཧཾ ཀུཏ ཨཱགཏོསྨི ཀྭ ཡཱམི ཙ ཏདཧཾ ཛཱནཱམི ཀིནྟུ ཀུཏ ཨཱགཏོསྨི ཀུཏྲ གཙྪཱམི ཙ ཏད྄ ཡཱུཡཾ ན ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ཡཱུཡཾ ལཽཀིཀཾ ཝིཙཱརཡཐ ནཱཧཾ ཀིམཔི ཝིཙཱརཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ཀིནྟུ ཡདི ཝིཙཱརཡཱམི ཏརྷི མམ ཝིཙཱརོ གྲཧཱིཏཝྱོ ཡཏོཧམ྄ ཨེཀཱཀཱི ནཱསྨི པྲེརཡིཏཱ པིཏཱ མཡཱ སཧ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","དྭཡོ རྫནཡོཿ སཱཀྵྱཾ གྲཧཎཱིཡཾ བྷཝཏཱིཏི ཡུཥྨཱཀཾ ཝྱཝསྠཱགྲནྠེ ལིཁིཏམསྟི། ");
INSERT INTO santib_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ཨཧཾ སྭཱརྠེ སྭཡཾ སཱཀྵིཏྭཾ དདཱམི ཡཤྩ མམ ཏཱཏོ མཱཾ པྲེརིཏཝཱན྄ སོཔི མདརྠེ སཱཀྵྱཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ཏདཱ ཏེ྅པྲྀཙྪན྄ ཏཝ ཏཱཏཿ ཀུཏྲ? ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིད྄ ཡཱུཡཾ མཱཾ ན ཛཱནཱིཐ མཏྤིཏརཉྩ ན ཛཱནཱིཐ ཡདི མཱམ྄ ཨཀྵཱསྱཏ ཏརྷི མམ ཏཱཏམཔྱཀྵཱསྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ཡཱིཤུ རྨནྡིར ཨུཔདིཤྱ བྷཎྜཱགཱརེ ཀཐཱ ཨེཏཱ ཨཀཐཡཏ྄ ཏཐཱཔི ཏཾ པྲཏི ཀོཔི ཀརཾ ནོདཏོལཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ཏཏཿ པརཾ ཡཱིཤུཿ པུནརུདིཏཝཱན྄ ཨདྷུནཱཧཾ གཙྪཱམི ཡཱུཡཾ མཱཾ གཝེཥཡིཥྱཐ ཀིནྟུ ནིཛཻཿ པཱཔཻ རྨརིཥྱཐ ཡཏ྄ སྠཱནམ྄ ཨཧཾ ཡཱསྱཱམི ཏཏ྄ སྠཱནམ྄ ཡཱུཡཾ ཡཱཏུཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ཏདཱ ཡིཧཱུདཱིཡཱཿ པྲཱཝོཙན྄ ཀིམཡམ྄ ཨཱཏྨགྷཱཏཾ ཀརིཥྱཏི? ཡཏོ ཡཏ྄ སྠཱནམ྄ ཨཧཾ ཡཱསྱཱམི ཏཏ྄ སྠཱནམ྄ ཡཱུཡཾ ཡཱཏུཾ ན ཤཀྵྱཐ ཨིཏི ཝཱཀྱཾ བྲཝཱིཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ཏཏོ ཡཱིཤུསྟེབྷྱཿ ཀཐིཏཝཱན྄ ཡཱུཡམ྄ ཨདྷཿསྠཱནཱིཡཱ ལོཀཱ ཨཧམ྄ ཨཱུརྡྭྭསྠཱནཱིཡཿ ཡཱུཡམ྄ ཨེཏཛྫགཏྶམྦནྡྷཱིཡཱ ཨཧམ྄ ཨེཏཛྫགཏྶམྦནྡྷཱིཡོ ན། ");
INSERT INTO santib_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ཏསྨཱཏ྄ ཀཐིཏཝཱན྄ ཡཱུཡཾ ནིཛཻཿ པཱཔཻ རྨརིཥྱཐ ཡཏོཧཾ ས པུམཱན྄ ཨིཏི ཡདི ན ཝིཤྭསིཐ ཏརྷི ནིཛཻཿ པཱཔཻ རྨརིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ཏདཱ ཏེ ྅པྲྀཙྪན྄ ཀསྟྭཾ? ཏཏོ ཡཱིཤུཿ ཀཐིཏཝཱན྄ ཡུཥྨཱཀཾ སནྣིདྷཽ ཡསྱ པྲསྟཱཝམ྄ ཨཱ པྲཐམཱཏ྄ ཀརོམི སཨེཝ པུརུཥོཧཾ། ");
INSERT INTO santib_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ཡུཥྨཱསུ མཡཱ བཧུཝཱཀྱཾ ཝཀྟྟཝྱཾ ཝིཙཱརཡིཏཝྱཉྩ ཀིནྟུ མཏྤྲེརཡིཏཱ སཏྱཝཱདཱི ཏསྱ སམཱིཔེ ཡདཧཾ ཤྲུཏཝཱན྄ ཏདེཝ ཛགཏེ ཀཐཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ཀིནྟུ ས ཛནཀེ ཝཱཀྱམིདཾ པྲོཀྟྟཝཱན྄ ཨིཏི ཏེ ནཱབུདྷྱནྟ། ");
INSERT INTO santib_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ཏཏོ ཡཱིཤུརཀཐཡད྄ ཡདཱ མནུཥྱཔུཏྲམ྄ ཨཱུརྡྭྭ ཨུཏྠཱཔཡིཥྱཐ ཏདཱཧཾ ས པུམཱན྄ ཀེཝལཿ སྭཡཾ ཀིམཔི ཀརྨྨ ན ཀརོམི ཀིནྟུ ཏཱཏོ ཡཐཱ ཤིཀྵཡཏི ཏདནུསཱརེཎ ཝཱཀྱམིདཾ ཝདཱམཱིཏི ཙ ཡཱུཡཾ ཛྙཱཏུཾ ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","མཏྤྲེརཡིཏཱ པིཏཱ མཱམ྄ ཨེཀཱཀིནཾ ན ཏྱཛཏི ས མཡཱ སཱརྡྡྷཾ ཏིཥྛཏི ཡཏོཧཾ ཏདབྷིམཏཾ ཀརྨྨ སདཱ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ཏདཱ ཏསྱཻཏཱནི ཝཱཀྱཱནི ཤྲུཏྭཱ བཧུཝསྟཱསྨིན྄ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ཡེ ཡིཧཱུདཱིཡཱ ཝྱཤྭསན྄ ཡཱིཤུསྟེབྷྱོ྅ཀཐཡཏ྄ ");
INSERT INTO santib_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","མམ ཝཱཀྱེ ཡདི ཡཱུཡམ྄ ཨཱསྠཱཾ ཀུརུཐ ཏརྷི མམ ཤིཥྱཱ བྷཱུཏྭཱ སཏྱཏྭཾ ཛྙཱསྱཐ ཏཏཿ སཏྱཏཡཱ ཡུཥྨཱཀཾ མོཀྵོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ཏདཱ ཏེ པྲཏྱཝཱདིཥུཿ ཝཡམ྄ ཨིབྲཱཧཱིམོ ཝཾཤཿ ཀདཱཔི ཀསྱཱཔི དཱསཱ ན ཛཱཏཱསྟརྷི ཡུཥྨཱཀཾ མུཀྟྟི རྦྷཝིཥྱཏཱིཏི ཝཱཀྱཾ ཀཐཾ བྲཝཱིཥི? ");
INSERT INTO santib_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ཏདཱ ཡཱིཤུཿ པྲཏྱཝདད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཏརཾ ཝདཱམི ཡཿ པཱཔཾ ཀརོཏི ས པཱཔསྱ དཱསཿ། ");
INSERT INTO santib_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","དཱསཤྩ ནིརནྟརཾ ནིཝེཤནེ ན ཏིཥྛཏི ཀིནྟུ པུཏྲོ ནིརནྟརཾ ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ཨཏཿ པུཏྲོ ཡདི ཡུཥྨཱན྄ མོཙཡཏི ཏརྷི ནིཏཱནྟམེཝ མུཀྟྟཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ཡུཡམ྄ ཨིབྲཱཧཱིམོ ཝཾཤ ཨིཏྱཧཾ ཛཱནཱམི ཀིནྟུ མམ ཀཐཱ ཡུཥྨཱཀམ྄ ཨནྟཿཀརཎེཥུ སྠཱནཾ ན པྲཱཔྣུཝནྟི ཏསྨཱདྡྷེཏོ རྨཱཾ ཧནྟུམ྄ ཨཱིཧདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ཨཧཾ སྭཔིཏུཿ སམཱིཔེ ཡདཔཤྱཾ ཏདེཝ ཀཐཡཱམི ཏཐཱ ཡཱུཡམཔི སྭཔིཏུཿ སམཱིཔེ ཡདཔཤྱཏ ཏདེཝ ཀུརུདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ཏདཱ ཏེ པྲཏྱཝོཙན྄ ཨིབྲཱཧཱིམ྄ ཨསྨཱཀཾ པིཏཱ ཏཏོ ཡཱིཤུརཀཐཡད྄ ཡདི ཡཱུཡམ྄ ཨིབྲཱཧཱིམཿ སནྟཱནཱ ཨབྷཝིཥྱཏ ཏརྷི ཨིབྲཱཧཱིམ ཨཱཙཱརཎཝད྄ ཨཱཙརིཥྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ཨཱིཤྭརསྱ མུཁཱཏ྄ སཏྱཾ ཝཱཀྱཾ ཤྲུཏྭཱ ཡུཥྨཱན྄ ཛྙཱཔཡཱམི ཡོཧཾ ཏཾ མཱཾ ཧནྟུཾ ཙེཥྚདྷྭེ ཨིབྲཱཧཱིམ྄ ཨེཏཱདྲྀཤཾ ཀརྨྨ ན ཙཀཱར། ");
INSERT INTO santib_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ཡཱུཡཾ སྭསྭཔིཏུཿ ཀརྨྨཱཎི ཀུརུཐ ཏདཱ ཏཻརུཀྟྟཾ ན ཝཡཾ ཛཱརཛཱཏཱ ཨསྨཱཀམ྄ ཨེཀཨེཝ པིཏཱསྟི ས ཨེཝེཤྭརཿ ");
INSERT INTO santib_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ཏཏོ ཡཱིཤུནཱ ཀཐིཏམ྄ ཨཱིཤྭརོ ཡདི ཡུཥྨཱཀཾ ཏཱཏོབྷཝིཥྱཏ྄ ཏརྷི ཡཱུཡཾ མཡི པྲེམཱཀརིཥྱཏ ཡཏོཧམ྄ ཨཱིཤྭརཱནྣིརྒཏྱཱགཏོསྨི སྭཏོ ནཱགཏོཧཾ ས མཱཾ པྲཱཧིཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ཡཱུཡཾ མམ ཝཱཀྱམིདཾ ན བུདྷྱདྷྭེ ཀུཏཿ? ཡཏོ ཡཱུཡཾ མམོཔདེཤཾ སོཌྷུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ཡཱུཡཾ ཤཻཏཱན྄ པིཏུཿ སནྟཱནཱ ཨེཏསྨཱད྄ ཡུཥྨཱཀཾ པིཏུརབྷིལཱཥཾ པཱུརཡཐ ས ཨཱ པྲཐམཱཏ྄ ནརགྷཱཏཱི ཏདནྟཿ སཏྱཏྭསྱ ལེཤོཔི ནཱསྟི ཀཱརཎཱདཏཿ ས སཏྱཏཱཡཱཾ ནཱཏིཥྛཏ྄ ས ཡདཱ མྲྀཥཱ ཀཐཡཏི ཏདཱ ནིཛསྭབྷཱཝཱནུསཱརེཎཻཝ ཀཐཡཏི ཡཏོ ས མྲྀཥཱབྷཱཥཱི མྲྀཥོཏྤཱདཀཤྩ། ");
INSERT INTO santib_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ཨཧཾ ཏཐྱཝཱཀྱཾ ཝདཱམི ཀཱརཎཱདསྨཱད྄ ཡཱུཡཾ མཱཾ ན པྲཏཱིཐ། ");
INSERT INTO santib_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","མཡི པཱཔམསྟཱིཏི པྲམཱཎཾ ཡུཥྨཱཀཾ ཀོ དཱཏུཾ ཤཀྣོཏི? ཡདྱཧཾ ཏཐྱཝཱཀྱཾ ཝདཱམི ཏརྷི ཀུཏོ མཱཾ ན པྲཏིཐ? ");
INSERT INTO santib_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ཡཿ ཀཤྩན ཨཱིཤྭརཱིཡོ ལོཀཿ ས ཨཱིཤྭརཱིཡཀཐཱཡཱཾ མནོ ནིདྷཏྟེ ཡཱུཡམ྄ ཨཱིཤྭརཱིཡལོཀཱ ན བྷཝཐ ཏནྣིདཱནཱཏ྄ ཏཏྲ ན མནཱཾསི ནིདྷདྭེ། ");
INSERT INTO santib_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ཏདཱ ཡིཧཱུདཱིཡཱཿ པྲཏྱཝཱདིཥུཿ ཏྭམེཀཿ ཤོམིརོཎཱིཡོ བྷཱུཏགྲསྟཤྩ ཝཡཾ ཀིམིདཾ བྷདྲཾ ནཱཝཱདིཥྨ? ");
INSERT INTO santib_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིཏ྄ ནཱཧཾ བྷཱུཏགྲསྟཿ ཀིནྟུ ནིཛཏཱཏཾ སམྨནྱེ ཏསྨཱད྄ ཡཱུཡཾ མཱམ྄ ཨཔམནྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ཨཧཾ སྭསུཁྱཱཏིཾ ན ཙེཥྚེ ཀིནྟུ ཙེཥྚིཏཱ ཝིཙཱརཡིཏཱ ཙཱཔར ཨེཀ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ཨཧཾ ཡུཥྨབྷྱམ྄ ཨཏཱིཝ ཡཐཱརྠཾ ཀཐཡཱམི ཡོ ནརོ མདཱིཡཾ ཝཱཙཾ མནྱཏེ ས ཀདཱཙན ནིདྷནཾ ན དྲཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ཡིཧཱུདཱིཡཱསྟམཝདན྄ ཏྭཾ བྷཱུཏགྲསྟ ཨིཏཱིདཱནཱིམ྄ ཨཝཻཥྨ། ཨིབྲཱཧཱིམ྄ བྷཝིཥྱདྭཱདིནཉྩ སཪྻྭེ མྲྀཏཱཿ ཀིནྟུ ཏྭཾ བྷཱཥསེ ཡོ ནརོ མམ བྷཱརཏཱིཾ གྲྀཧླཱཏི ས ཛཱཏུ ནིདྷཱནཱསྭཱདཾ ན ལཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ཏརྷི ཏྭཾ ཀིམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱད྄ ཨིབྲཱཧཱིམོཔི མཧཱན྄? ཡསྨཱཏ྄ སོཔི མྲྀཏཿ བྷཝིཥྱདྭཱདིནོཔི མྲྀཏཱཿ ཏྭཾ སྭཾ ཀཾ པུམཱཾསཾ མནུཥེ? ");
INSERT INTO santib_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ཡཱིཤུཿ པྲཏྱཝོཙད྄ ཡདྱཧཾ སྭཾ སྭཡཾ སམྨནྱེ ཏརྷི མམ ཏཏ྄ སམྨནནཾ ཀིམཔི ན ཀིནྟུ མམ ཏཱཏོ ཡཾ ཡཱུཡཾ སྭཱིཡམ྄ ཨཱིཤྭརཾ བྷཱཥདྷྭེ སཨེཝ མཱཾ སམྨནུཏེ། ");
INSERT INTO santib_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ཡཱུཡཾ ཏཾ ནཱཝགཙྪཐ ཀིནྟྭཧཾ ཏམཝགཙྪཱམི ཏཾ ནཱཝགཙྪཱམཱིཏི ཝཱཀྱཾ ཡདི ཝདཱམི ཏརྷི ཡཱུཡམིཝ མྲྀཥཱབྷཱཥཱི བྷཝཱམི ཀིནྟྭཧཾ ཏམཝགཙྪཱམི ཏདཱཀྵཱམཔི གྲྀཧླཱམི། ");
INSERT INTO santib_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥ ཨིབྲཱཧཱིམ྄ མམ སམཡཾ དྲཥྚུམ྄ ཨཏཱིཝཱཝཱཉྪཏ྄ ཏནྣིརཱིཀྵྱཱནནྡཙྩ། ");
INSERT INTO santib_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ཏདཱ ཡིཧཱུདཱིཡཱ ཨཔྲྀཙྪན྄ ཏཝ ཝཡཿ པཉྩཱཤདྭཏྶརཱ ན ཏྭཾ ཀིམ྄ ཨིབྲཱཧཱིམམ྄ ཨདྲཱཀྵཱིཿ? ");
INSERT INTO santib_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ཡཱིཤུཿ པྲཏྱཝཱདཱིད྄ ཡུཥྨཱནཧཾ ཡཐཱརྠཏརཾ ཝདཱམི ཨིབྲཱཧཱིམོ ཛནྨནཿ པཱུཪྻྭཀཱལམཱརབྷྱཱཧཾ ཝིདྱེ། ");
INSERT INTO santib_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ཏདཱ ཏེ པཱཥཱཎཱན྄ ཨུཏྟོལྱ ཏམཱཧནྟུམ྄ ཨུདཡཙྪན྄ ཀིནྟུ ཡཱིཤུ རྒུཔྟོ མནྟིརཱད྄ བཧིརྒཏྱ ཏེཥཱཾ མདྷྱེན པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ཏཏཿ པརཾ ཡཱིཤུརྒཙྪན྄ མཱརྒམདྷྱེ ཛནྨཱནྡྷཾ ནརམ྄ ཨཔཤྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ཏཏཿ ཤིཥྱཱསྟམ྄ ཨཔྲྀཙྪན྄ ཧེ གུརོ ནརོཡཾ སྭཔཱཔེན ཝཱ སྭཔིཏྲཱཿ པཱཔེནཱནྡྷོ྅ཛཱཡཏ? ");
INSERT INTO santib_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ཏཏཿ ས པྲཏྱུདིཏཝཱན྄ ཨེཏསྱ ཝཱསྱ པིཏྲོཿ པཱཔཱད྄ ཨེཏཱདྲྀཤོབྷཱུད ཨིཏི ནཧི ཀིནྟྭནེན ཡཐེཤྭརསྱ ཀརྨྨ པྲཀཱཤྱཏེ ཏདྡྷེཏོརེཝ། ");
INSERT INTO santib_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","དིནེ ཏིཥྛཏི མཏྤྲེརཡིཏུཿ ཀརྨྨ མཡཱ ཀརྟྟཝྱཾ ཡདཱ ཀིམཔི ཀརྨྨ ན ཀྲིཡཏེ ཏཱདྲྀཤཱི ནིཤཱགཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ཨཧཾ ཡཱཝཏྐཱལཾ ཛགཏི ཏིཥྛཱམི ཏཱཝཏྐཱལཾ ཛགཏོ ཛྱོཏིཿསྭརཱུཔོསྨི། ");
INSERT INTO santib_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ཨིཏྱུཀྟྟཱ བྷཱུམཽ ནིཥྛཱིཝཾ ནིཀྵིཔྱ ཏེན པངྐཾ ཀྲྀཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","པཤྩཱཏ྄ ཏཏྤངྐེན ཏསྱཱནྡྷསྱ ནེཏྲེ པྲལིཔྱ ཏམིཏྱཱདིཤཏ྄ གཏྭཱ ཤིལོཧེ ྅རྠཱཏ྄ པྲེརིཏནཱམྣི སརསི སྣཱཧི། ཏཏོནྡྷོ གཏྭཱ ཏཏྲཱསྣཱཏ྄ ཏཏཿ པྲནྣཙཀྵུ རྦྷཱུཏྭཱ ཝྱཱགྷུཊྱཱགཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ཨཔརཉྩ སམཱིཔཝཱསིནོ ལོཀཱ ཡེ ཙ ཏཾ པཱུཪྻྭམནྡྷམ྄ ཨཔཤྱན྄ ཏེ བཀྟྟུམ྄ ཨཱརབྷནྟ ཡོནྡྷལོཀོ ཝརྟྨནྱུཔཝིཤྱཱབྷིཀྵཏ ས ཨེཝཱཡཾ ཛནཿ ཀིཾ ན བྷཝཏི? ");
INSERT INTO santib_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ཀེཙིདཝདན྄ ས ཨེཝ ཀེཙིདཝོཙན྄ ཏཱདྲྀཤོ བྷཝཏི ཀིནྟུ ས སྭཡམབྲཝཱིཏ྄ ས ཨེཝཱཧཾ བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ཨཏཨེཝ ཏེ ྅པྲྀཙྪན྄ ཏྭཾ ཀཐཾ དྲྀཥྚིཾ པཱཔྟཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ཏཏཿ སོཝདད྄ ཡཱིཤནཱམཀ ཨེཀོ ཛནོ མམ ནཡནེ པངྐེན པྲལིཔྱ ཨིཏྱཱཛྙཱཔཡཏ྄ ཤིལོཧཀཱསཱརཾ གཏྭཱ ཏཏྲ སྣཱཧི། ཏཏསྟཏྲ གཏྭཱ མཡི སྣཱཏེ དྲྀཥྚིམཧཾ ལབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ཏདཱ ཏེ ྅ཝདན྄ ས པུམཱན྄ ཀུཏྲ? ཏེནོཀྟྟཾ ནཱཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ཨཔརཾ ཏསྨིན྄ པཱུཪྻྭཱནྡྷེ ཛནེ ཕིརཱུཤིནཱཾ ནིཀཊམ྄ ཨཱནཱིཏེ སཏི ཕིརཱུཤིནོཔི ཏམཔྲྀཙྪན྄ ཀཐཾ དྲྀཥྚིཾ པྲཱཔྟོསི? ");
INSERT INTO santib_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ཏཏཿ ས ཀཐིཏཝཱན྄ ས པངྐེན མམ ནེཏྲེ ྅ལིམྤཏ྄ པཤྩཱད྄ སྣཱཏྭཱ དྲྀཥྚིམལབྷེ། ");
INSERT INTO santib_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ཀིནྟུ ཡཱིཤུ ཪྻིཤྲཱམཝཱརེ ཀརྡྡམཾ ཀྲྀཏྭཱ ཏསྱ ནཡནེ པྲསནྣེ྅ཀརོད྄ ཨིཏིཀཱརཎཱཏ྄ ཀཏིཔཡཕིརཱུཤིནོ྅ཝདན྄ ");
INSERT INTO santib_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ས པུམཱན྄ ཨཱིཤྭརཱནྣ ཡཏཿ ས ཝིཤྲཱམཝཱརཾ ན མནྱཏེ། ཏཏོནྱེ ཀེཙིཏ྄ པྲཏྱཝདན྄ པཱཔཱི པུམཱན྄ ཀིམ྄ ཨེཏཱདྲྀཤམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ ཀརྟྟུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ཨིཏྠཾ ཏེཥཱཾ པརསྤརཾ བྷིནྣཝཱཀྱཏྭམ྄ ཨབྷཝཏ྄། པཤྩཱཏ྄ ཏེ པུནརཔི ཏཾ པཱུཪྻྭཱནྡྷཾ མཱནུཥམ྄ ཨཔྲཱཀྵུཿ ཡོ ཛནསྟཝ ཙཀྵུཥཱི པྲསནྣེ ཀྲྀཏཝཱན྄ ཏསྨིན྄ ཏྭཾ ཀིཾ ཝདསི? ས ཨུཀྟྟཝཱན྄ ས བྷཝིཤདྭཱདཱི། ");
INSERT INTO santib_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ས དྲྀཥྚིམ྄ ཨཱཔྟཝཱན྄ ཨིཏི ཡིཧཱུདཱིཡཱསྟསྱ དྲྀཥྚིཾ པྲཱཔྟསྱ ཛནསྱ པིཏྲོ རྨུཁཱད྄ ཨཤྲུཏྭཱ ན པྲཏྱཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ཨཏཨེཝ ཏེ ཏཱཝཔྲྀཙྪན྄ ཡུཝཡོ ཪྻཾ པུཏྲཾ ཛནྨཱནྡྷཾ ཝདཐཿ ས ཀིམཡཾ? ཏརྷཱིདཱནཱིཾ ཀཐཾ དྲཥྚུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ཏཏསྟསྱ པིཏརཽ པྲཏྱཝོཙཏཱམ྄ ཨཡམ྄ ཨཱཝཡོཿ པུཏྲ ཨཱ ཛནེརནྡྷཤྩ ཏདཔྱཱཝཱཾ ཛཱནཱིཝཿ ");
INSERT INTO santib_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ཀིནྟྭདྷུནཱ ཀཐཾ དྲྀཥྚིཾ པྲཱཔྟཝཱན྄ ཏདཱཝཱཾ ན྄ ཛཱནཱིཝཿ ཀོསྱ ཙཀྵུཥཱི པྲསནྣེ ཀྲྀཏཝཱན྄ ཏདཔི ན ཛཱནཱིཝ ཨེཥ ཝཡཿཔྲཱཔྟ ཨེནཾ པྲྀཙྪཏ སྭཀཐཱཾ སྭཡཾ ཝཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ཡིཧཱུདཱིཡཱནཱཾ བྷཡཱཏ྄ ཏསྱ པིཏརཽ ཝཱཀྱམིདམ྄ ཨཝདཏཱཾ ཡཏཿ ཀོཔི མནུཥྱོ ཡདི ཡཱིཤུམ྄ ཨབྷིཥིཀྟཾ ཝདཏི ཏརྷི ས བྷཛནགྲྀཧཱད྄ དཱུརཱིཀཱརིཥྱཏེ ཡིཧཱུདཱིཡཱ ཨིཏི མནྟྲཎཱམ྄ ཨཀུཪྻྭན྄ ");
INSERT INTO santib_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ཨཏསྟསྱ པིཏརཽ ཝྱཱཧརཏཱམ྄ ཨེཥ ཝཡཿཔྲཱཔྟ ཨེནཾ པྲྀཙྪཏ། ");
INSERT INTO santib_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ཏདཱ ཏེ པུནཤྩ ཏཾ པཱུཪྻྭཱནྡྷམ྄ ཨཱཧཱུཡ ཝྱཱཧརན྄ ཨཱིཤྭརསྱ གུཎཱན྄ ཝད ཨེཥ མནུཥྱཿ པཱཔཱིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ཏདཱ ས ཨུཀྟྟཝཱན྄ ས པཱཔཱི ན ཝེཏི ནཱཧཾ ཛཱནེ པཱུཪྻཱམནྡྷ ཨཱསམཧམ྄ ཨདྷུནཱ པཤྱཱམཱིཏི མཱཏྲཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ཏེ པུནརཔྲྀཙྪན྄ ས ཏྭཱཾ པྲཏི ཀིམཀརོཏ྄? ཀཐཾ ནེཏྲེ པྲསནྣེ ྅ཀརོཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ཏཏཿ སོཝཱདཱིད྄ ཨེཀཀྲྀཏྭོཀཐཡཾ ཡཱུཡཾ ན ཤྲྀཎུཐ ཏརྷི ཀུཏཿ པུནཿ ཤྲོཏུམ྄ ཨིཙྪཐ? ཡཱུཡམཔི ཀིཾ ཏསྱ ཤིཥྱཱ བྷཝིཏུམ྄ ཨིཙྪཐ? ");
INSERT INTO santib_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ཏདཱ ཏེ ཏཾ ཏིརསྐྲྀཏྱ ཝྱཱཧརན྄ ཏྭཾ ཏསྱ ཤིཥྱོ ཝཡཾ མཱུསཱཿ ཤིཥྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","མཱུསཱཝཀྟྲེཎེཤྭརོ ཛགཱད ཏཛྫཱནཱིམཿ ཀིནྟྭེཥ ཀུཏྲཏྱལོཀ ཨིཏི ན ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","སོཝདད྄ ཨེཥ མམ ལོཙནེ པྲསནྣེ ྅ཀརོཏ྄ ཏཐཱཔི ཀུཏྲཏྱལོཀ ཨིཏི ཡཱུཡཾ ན ཛཱནཱིཐ ཨེཏད྄ ཨཱཤྩཪྻྱཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ཨཱིཤྭརཿ པཱཔིནཱཾ ཀཐཱཾ ན ཤྲྀཎོཏི ཀིནྟུ ཡོ ཛནསྟསྨིན྄ བྷཀྟིཾ ཀྲྀཏྭཱ ཏདིཥྚཀྲིཡཱཾ ཀརོཏི ཏསྱཻཝ ཀཐཱཾ ཤྲྀཎོཏི ཨེཏད྄ ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ཀོཔི མནུཥྱོ ཛནྨཱནྡྷཱཡ ཙཀྵུཥཱི ཨདདཱཏ྄ ཛགདཱརམྦྷཱད྄ ཨེཏཱདྲྀཤཱིཾ ཀཐཱཾ ཀོཔི ཀདཱཔི ནཱཤྲྀཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ཨསྨཱད྄ ཨེཥ མནུཥྱོ ཡདཱིཤྭརཱནྣཱཛཱཡཏ ཏརྷི ཀིཉྩིདཔཱིདྲྀཤཾ ཀརྨྨ ཀརྟྟུཾ ནཱཤཀྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ཏེ ཝྱཱཧརན྄ ཏྭཾ པཱཔཱད྄ ཨཛཱཡཐཱཿ ཀིམསྨཱན྄ ཏྭཾ ཤིཀྵཡསི? པཤྩཱཏྟེ ཏཾ བཧིརཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ཏདནནྟརཾ ཡིཧཱུདཱིཡཻཿ ས བཧིརཀྲིཡཏ ཡཱིཤུརིཏི ཝཱརྟྟཱཾ ཤྲུཏྭཱ ཏཾ སཱཀྵཱཏ྄ པྲཱཔྱ པྲྀཥྚཝཱན྄ ཨཱིཤྭརསྱ པུཏྲེ ཏྭཾ ཝིཤྭསིཥི? ");
INSERT INTO santib_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ཏདཱ ས པྲཏྱཝོཙཏ྄ ཧེ པྲབྷོ ས ཀོ ཡཏ྄ ཏསྨིནྣཧཾ ཝིཤྭསིམི? ");
INSERT INTO santib_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ཏཏོ ཡཱིཤུཿ ཀཐིཏཝཱན྄ ཏྭཾ ཏཾ དྲྀཥྚཝཱན྄ ཏྭཡཱ སཱཀཾ ཡཿ ཀཐཾ ཀཐཡཏི སཨེཝ སཿ། ");
INSERT INTO santib_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ཏདཱ ཧེ པྲབྷོ ཝིཤྭསིམཱིཏྱུཀྟྭཱ ས ཏཾ པྲཎཱམཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","པཤྩཱད྄ ཡཱིཤུཿ ཀཐིཏཝཱན྄ ནཡནཧཱིནཱ ནཡནཱནི པྲཱཔྣུཝནྟི ནཡནཝནྟཤྩཱནྡྷཱ བྷཝནྟཱིཏྱབྷིཔྲཱཡེཎ ཛགདཱཧམ྄ ཨཱགཙྪམ྄། ");
INSERT INTO santib_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ཨེཏཏ྄ ཤྲུཏྭཱ ནིཀཊསྠཱཿ ཀཏིཔཡཱཿ ཕིརཱུཤིནོ ཝྱཱཧརན྄ ཝཡམཔི ཀིམནྡྷཱཿ? ");
INSERT INTO santib_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ཏདཱ ཡཱིཤུརཝཱདཱིད྄ ཡདྱནྡྷཱ ཨབྷཝཏ ཏརྷི པཱཔཱནི ནཱཏིཥྛན྄ ཀིནྟུ པཤྱཱམཱིཏི ཝཱཀྱཝདནཱད྄ ཡུཥྨཱཀཾ པཱཔཱནི ཏིཥྛནྟི། ");
INSERT INTO santib_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི, ཡོ ཛནོ དྭཱརེཎ ན པྲཝིཤྱ ཀེནཱཔྱནྱེན མེཥགྲྀཧཾ པྲཝིཤཏི ས ཨེཝ སྟེནོ དསྱུཤྩ། ");
INSERT INTO santib_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ཡོ དྭཱརེཎ པྲཝིཤཏི ས ཨེཝ མེཥཔཱལཀཿ། ");
INSERT INTO santib_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","དཽཝཱརིཀསྟསྨཻ དྭཱརཾ མོཙཡཏི མེཥགཎཤྩ ཏསྱ ཝཱཀྱཾ ཤྲྀཎོཏི ས ནིཛཱན྄ མེཥཱན྄ སྭསྭནཱམྣཱཧཱུཡ བཧིཿ ཀྲྀཏྭཱ ནཡཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ཏཐཱ ནིཛཱན྄ མེཥཱན྄ བཧིཿ ཀྲྀཏྭཱ སྭཡཾ ཏེཥཱམ྄ ཨགྲེ གཙྪཏི, ཏཏོ མེཥཱསྟསྱ ཤབྡཾ བུདྷྱནྟེ, ཏསྨཱཏ྄ ཏསྱ པཤྩཱད྄ ཝྲཛནྟི། ");
INSERT INTO santib_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ཀིནྟུ པརསྱ ཤབྡཾ ན བུདྷྱནྟེ ཏསྨཱཏ྄ ཏསྱ པཤྩཱད྄ ཝྲཛིཥྱནྟི ཝརཾ ཏསྱ སམཱིཔཱཏ྄ པལཱཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ཡཱིཤུསྟེབྷྱ ཨིམཱཾ དྲྀཥྚཱནྟཀཐཱམ྄ ཨཀཐཡཏ྄ ཀིནྟུ ཏེན ཀཐིཏཀཐཱཡཱསྟཱཏྤཪྻྱཾ ཏེ ནཱབུདྷྱནྟ། ");
INSERT INTO santib_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ཨཏོ ཡཱིཤུཿ པུནརཀཐཡཏ྄, ཡུཥྨཱནཱཧཾ ཡཐཱརྠཏརཾ ཝྱཱཧརཱམི, མེཥགྲྀཧསྱ དྭཱརམ྄ ཨཧམེཝ། ");
INSERT INTO santib_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","མཡཱ ན པྲཝིཤྱ ཡ ཨཱགཙྪན྄ ཏེ སྟེནཱ དསྱཝཤྩ ཀིནྟུ མེཥཱསྟེཥཱཾ ཀཐཱ ནཱཤྲྀཎྭན྄། ");
INSERT INTO santib_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ཨཧམེཝ དྭཱརསྭརཱུཔཿ, མཡཱ ཡཿ ཀཤྩིཏ པྲཝིཤཏི ས རཀྵཱཾ པྲཱཔྶྱཏི ཏཐཱ བཧིརནྟཤྩ གམནཱགམནེ ཀྲྀཏྭཱ ཙརཎསྠཱནཾ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ཡོ ཛནསྟེནཿ ས ཀེཝལཾ སྟཻནྱབདྷཝིནཱཤཱན྄ ཀརྟྟུམེཝ སམཱཡཱཏི ཀིནྟྭཧམ྄ ཨཱཡུ རྡཱཏུམ྄ ཨརྠཱཏ྄ བཱཧཱུལྱེན ཏདེཝ དཱཏུམ྄ ཨཱགཙྪམ྄། ");
INSERT INTO santib_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ཨཧམེཝ སཏྱམེཥཔཱལཀོ ཡསྟུ སཏྱོ མེཥཔཱལཀཿ ས མེཥཱརྠཾ པྲཱཎཏྱཱགཾ ཀརོཏི; ");
INSERT INTO santib_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ཀིནྟུ ཡོ ཛནོ མེཥཔཱལཀོ ན, ཨརྠཱད྄ ཡསྱ མེཥཱ ནིཛཱ ན བྷཝནྟི, ཡ ཨེཏཱདྲྀཤོ ཝཻཏནིཀཿ ས ཝྲྀཀམ྄ ཨཱགཙྪནྟཾ དྲྀཥྚྭཱ མེཛཝྲཛཾ ཝིཧཱཡ པལཱཡཏེ, ཏསྨཱད྄ ཝྲྀཀསྟཾ ཝྲཛཾ དྷྲྀཏྭཱ ཝིཀིརཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ཝཻཏནིཀཿ པལཱཡཏེ ཡཏཿ ས ཝེཏནཱརྠཱི མེཥཱརྠཾ ན ཙིནྟཡཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ཨཧམེཝ སཏྱོ མེཥཔཱལཀཿ, པིཏཱ མཱཾ ཡཐཱ ཛཱནཱཏི, ཨཧཉྩ ཡཐཱ པིཏརཾ ཛཱནཱམི, ");
INSERT INTO santib_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ཏཐཱ ནིཛཱན྄ མེཥཱནཔི ཛཱནཱམི, མེཥཱཤྩ མཱཾ ཛཱནཱནྟི, ཨཧཉྩ མེཥཱརྠཾ པྲཱཎཏྱཱགཾ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ཨཔརཉྩ ཨེཏད྄ གྲྀཧཱིཡ མེཥེབྷྱོ བྷིནྣཱ ཨཔི མེཥཱ མམ སནྟི ཏེ སཀལཱ ཨཱནཡིཏཝྱཱཿ; ཏེ མམ ཤབྡཾ ཤྲོཥྱནྟི ཏཏ ཨེཀོ ཝྲཛ ཨེཀོ རཀྵཀོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","པྲཱཎཱནཧཾ ཏྱཀྟྭཱ པུནཿ པྲཱཎཱན྄ གྲཧཱིཥྱཱམི, ཏསྨཱཏ྄ པིཏཱ མཡི སྣེཧཾ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ཀཤྩིཛྫནོ མམ པྲཱཎཱན྄ ཧནྟུཾ ན ཤཀྣོཏི ཀིནྟུ སྭཡཾ ཏཱན྄ སམརྤཡཱམི ཏཱན྄ སམརྤཡིཏུཾ པུནརྒྲཧཱིཏུཉྩ མམ ཤཀྟིརཱསྟེ བྷཱརམིམཾ སྭཔིཏུཿ སཀཱཤཱཏ྄ པྲཱཔྟོཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ཨསྨཱདུཔདེཤཱཏ྄ པུནཤྩ ཡིཧཱུདཱིཡཱནཱཾ མདྷྱེ བྷིནྣཝཱཀྱཏཱ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ཏཏོ བཧཝོ ཝྱཱཧརན྄ ཨེཥ བྷཱུཏགྲསྟ ཨུནྨཏྟཤྩ, ཀུཏ ཨེཏསྱ ཀཐཱཾ ཤྲྀཎུཐ? ");
INSERT INTO santib_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ཀེཙིད྄ ཨཝདན྄ ཨེཏསྱ ཀཐཱ བྷཱུཏགྲསྟསྱ ཀཐཱཝནྣ བྷཝནྟི, བྷཱུཏཿ ཀིམ྄ ཨནྡྷཱཡ ཙཀྵུཥཱི དཱཏུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ཤཱིཏཀཱལེ ཡིརཱུཤཱལམི མནྡིརོཏྶརྒཔཪྻྭཎྱུཔསྠིཏེ ");
INSERT INTO santib_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ཡཱིཤུཿ སུལེམཱནོ ནིཿསཱརེཎ གམནཱགམནེ ཀརོཏི, ");
INSERT INTO santib_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ཨེཏསྨིན྄ སམཡེ ཡིཧཱུདཱིཡཱསྟཾ ཝེཥྚཡིཏྭཱ ཝྱཱཧརན྄ ཀཏི ཀཱལཱན྄ ཨསྨཱཀཾ ཝིཙིཀིཏྶཱཾ སྠཱཔཡིཥྱཱམི? ཡདྱབྷིཥིཀྟོ བྷཝཏི ཏརྷི ཏཏ྄ སྤཥྚཾ ཝད། ");
INSERT INTO santib_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ཏདཱ ཡཱིཤུཿ པྲཏྱཝདད྄ ཨཧམ྄ ཨཙཀཐཾ ཀིནྟུ ཡཱུཡཾ ན པྲཏཱིཐ, ནིཛཔིཏུ རྣཱམྣཱ ཡཱཾ ཡཱཾ ཀྲིཡཱཾ ཀརོམི སཱ ཀྲིཡཻཝ མམ སཱཀྵིསྭརཱུཔཱ། ");
INSERT INTO santib_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ཀིནྟྭཧཾ པཱུཪྻྭམཀཐཡཾ ཡཱུཡཾ མམ མེཥཱ ན བྷཝཐ, ཀཱརཎཱདསྨཱན྄ ན ཝིཤྭསིཐ། ");
INSERT INTO santib_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","མམ མེཥཱ མམ ཤབྡཾ ཤྲྀཎྭནྟི ཏཱནཧཾ ཛཱནཱམི ཏེ ཙ མམ པཤྩཱད྄ གཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ཨཧཾ ཏེབྷྱོ྅ནནྟཱཡུ རྡདཱམི, ཏེ ཀདཱཔི ན ནཾཀྵྱནྟི ཀོཔི མམ ཀརཱཏ྄ ཏཱན྄ ཧརྟྟུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ཡོ མམ པིཏཱ ཏཱན྄ མཧྱཾ དཏྟཝཱན྄ ས སཪྻྭསྨཱཏ྄ མཧཱན྄, ཀོཔི མམ པིཏུཿ ཀརཱཏ྄ ཏཱན྄ ཧརྟྟུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ཨཧཾ པིཏཱ ཙ དྭཡོརེཀཏྭམ྄། ");
INSERT INTO santib_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ཏཏོ ཡིཧཱུདཱིཡཱཿ པུནརཔི ཏཾ ཧནྟུཾ པཱཥཱཎཱན྄ ཨུདཏོལཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ཡཱིཤུཿ ཀཐིཏཝཱན྄ པིཏུཿ སཀཱཤཱད྄ བཧཱུནྱུཏྟམཀརྨྨཱཎི ཡུཥྨཱཀཾ པྲཱཀཱཤཡཾ ཏེཥཱཾ ཀསྱ ཀརྨྨཎཿ ཀཱརཎཱན྄ མཱཾ པཱཥཱཎཻརཱཧནྟུམ྄ ཨུདྱཏཱཿ སྠ? ");
INSERT INTO santib_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ཡིཧཱུདཱིཡཱཿ པྲཏྱཝདན྄ པྲཤསྟཀརྨྨཧེཏོ རྣ ཀིནྟུ ཏྭཾ མཱནུཥཿ སྭམཱིཤྭརམ྄ ཨུཀྟྭེཤྭརཾ ནིནྡསི ཀཱརཎཱདསྨཱཏ྄ ཏྭཱཾ པཱཥཱཎཻརྷནྨཿ། ");
INSERT INTO santib_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ཏདཱ ཡཱིཤུཿ པྲཏྱུཀྟཝཱན྄ མཡཱ ཀཐིཏཾ ཡཱུཡམ྄ ཨཱིཤྭརཱ ཨེཏདྭཙནཾ ཡུཥྨཱཀཾ ཤཱསྟྲེ ལིཁིཏཾ ནཱསྟི ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ཏསྨཱད྄ ཡེཥཱམ྄ ཨུདྡེཤེ ཨཱིཤྭརསྱ ཀཐཱ ཀཐིཏཱ ཏེ ཡདཱིཤྭརགཎཱ ཨུཙྱནྟེ དྷརྨྨགྲནྠསྱཱཔྱནྱཐཱ བྷཝིཏུཾ ན ཤཀྱཾ, ");
INSERT INTO santib_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ཏརྷྱཱཧམ྄ ཨཱིཤྭརསྱ པུཏྲ ཨིཏི ཝཱཀྱསྱ ཀཐནཱཏ྄ ཡཱུཡཾ པིཏྲཱབྷིཥིཀྟཾ ཛགཏི པྲེརིཏཉྩ པུམཱཾསཾ ཀཐམ྄ ཨཱིཤྭརནིནྡཀཾ ཝཱདཡ? ");
INSERT INTO santib_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ཡདྱཧཾ པིཏུཿ ཀརྨྨ ན ཀརོམི ཏརྷི མཱཾ ན པྲཏཱིཏ; ");
INSERT INTO santib_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ཀིནྟུ ཡདི ཀརོམི ཏརྷི མཡི ཡུཥྨཱབྷིཿ པྲཏྱཡེ ན ཀྲྀཏེ྅པི ཀཱཪྻྱེ པྲཏྱཡཿ ཀྲིཡཏཱཾ, ཏཏོ མཡི པིཏཱསྟཱིཏི པིཏཪྻྱཧམ྄ ཨསྨཱིཏི ཙ ཀྵཱཏྭཱ ཝིཤྭསིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ཏདཱ ཏེ པུནརཔི ཏཾ དྷརྟྟུམ྄ ཨཙེཥྚནྟ ཀིནྟུ ས ཏེཥཱཾ ཀརེབྷྱོ ནིསྟཱིཪྻྱ ");
INSERT INTO santib_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","པུན ཪྻརྡྡན྄ ཨདྱཱསྟཊེ ཡཏྲ པུཪྻྭཾ ཡོཧན྄ ཨམཛྫཡཏ྄ ཏཏྲཱགཏྱ ནྱཝསཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ཏཏོ བཧཝོ ལོཀཱསྟཏྶམཱིཔམ྄ ཨཱགཏྱ ཝྱཱཧརན྄ ཡོཧན྄ ཀིམཔྱཱཤྩཪྻྱཾ ཀརྨྨ ནཱཀརོཏ྄ ཀིནྟྭསྨིན྄ མནུཥྱེ ཡཱ ཡཿ ཀཐཱ ཨཀཐཡཏ྄ ཏཱཿ སཪྻྭཱཿ སཏྱཱཿ; ");
INSERT INTO santib_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ཏཏྲ ཙ བཧཝོ ལོཀཱསྟསྨིན྄ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ཨནནྟརཾ མརིཡམ྄ ཏསྱཱ བྷགིནཱི མརྠཱ ཙ ཡསྨིན྄ ཝཻཐནཱིཡཱགྲཱམེ ཝསཏསྟསྨིན྄ གྲཱམེ ཨིལིཡཱསར྄ ནཱམཱ པཱིཌིཏ ཨེཀ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ཡཱ མརིཡམ྄ པྲབྷུཾ སུགནྡྷིཏེལཻན མརྡྡཡིཏྭཱ སྭཀེཤཻསྟསྱ ཙརཎཽ སམམཱརྫཏ྄ ཏསྱཱ བྷྲཱཏཱ ས ཨིལིཡཱསར྄ རོགཱི། ");
INSERT INTO santib_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ཨཔརཉྩ ཧེ པྲབྷོ བྷཝཱན྄ ཡསྨིན྄ པྲཱིཡཏེ ས ཨེཝ པཱིཌིཏོསྟཱིཏི ཀཐཱཾ ཀཐཡིཏྭཱ ཏསྱ བྷགིནྱཽ པྲེཥིཏཝཏྱཽ། ");
INSERT INTO santib_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ཏདཱ ཡཱིཤུརིམཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱཀཐཡཏ པཱིཌེཡཾ མརཎཱརྠཾ ན ཀིནྟྭཱིཤྭརསྱ མཧིམཱརྠམ྄ ཨཱིཤྭརཔུཏྲསྱ མཧིམཔྲཀཱཤཱརྠཉྩ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ཡཱིཤུ ཪྻདྱཔིམརྠཱཡཱཾ ཏདྦྷགིནྱཱམ྄ ཨིལིཡཱསརི ཙཱཔྲཱིཡཏ, ");
INSERT INTO santib_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ཏཐཱཔི ཨིལིཡཱསརཿ པཱིཌཱཡཱཿ ཀཐཾ ཤྲུཏྭཱ ཡཏྲ ཨཱསཱིཏ྄ ཏཏྲཻཝ དིནདྭཡམཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ཏཏཿ པརམ྄ ས ཤིཥྱཱནཀཐཡད྄ ཝཡཾ པུན ཪྻིཧཱུདཱིཡཔྲདེཤཾ ཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ཏཏསྟེ པྲཏྱཝདན྄, ཧེ གུརོ སྭལྤདིནཱནི གཏཱནི ཡིཧཱུདཱིཡཱསྟྭཱཾ པཱཥཱཎཻ རྷནྟུམ྄ ཨུདྱཏཱསྟཐཱཔི ཀིཾ པུནསྟཏྲ ཡཱསྱསི? ");
INSERT INTO santib_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཨེཀསྨིན྄ དིནེ ཀིཾ དྭཱདཤགྷཊིཀཱ ན བྷཝནྟི? ཀོཔི དིཝཱ གཙྪན྄ ན སྑལཏི ཡཏཿ ས ཨེཏཛྫགཏོ དཱིཔྟིཾ པྲཱཔྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ཀིནྟུ རཱཏྲཽ གཙྪན྄ སྑལཏི ཡཏོ ཧེཏོསྟཏྲ དཱིཔྟི རྣཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ཨིམཱཾ ཀཐཱཾ ཀཐཡིཏྭཱ ས ཏཱནཝདད྄, ཨསྨཱཀཾ བནྡྷུཿ ཨིལིཡཱསར྄ ནིདྲིཏོབྷཱུད྄ ཨིདཱནཱིཾ ཏཾ ནིདྲཱཏོ ཛཱགརཡིཏུཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ཡཱིཤུ རྨྲྀཏཽ ཀཐཱམིམཱཾ ཀཐིཏཝཱན྄ ཀིནྟུ ཝིཤྲཱམཱརྠཾ ནིདྲཱཡཱཾ ཀཐིཏཝཱན྄ ཨིཏི ཛྙཱཏྭཱ ཤིཥྱཱ ཨཀཐཡན྄, ");
INSERT INTO santib_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ཧེ གུརོ ས ཡདི ནིདྲཱཏི ཏརྷི བྷདྲམེཝ། ");
INSERT INTO santib_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ཏདཱ ཡཱིཤུཿ སྤཥྚཾ ཏཱན྄ ཝྱཱཧརཏ྄, ཨིལིཡཱསར྄ ཨམྲིཡཏ; ");
INSERT INTO santib_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ཀིནྟུ ཡཱུཡཾ ཡཐཱ པྲཏཱིཐ ཏདརྠམཧཾ ཏཏྲ ན སྠིཏཝཱན྄ ཨིཏྱསྨཱད྄ ཡུཥྨནྣིམིཏྟམ྄ ཨཱཧླཱདིཏོཧཾ, ཏཐཱཔི ཏསྱ སམཱིཔེ ཡཱམ། ");
INSERT INTO santib_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ཏདཱ ཐོམཱ ཡཾ དིདུམཾ ཝདནྟི ས སངྒིནཿ ཤིཥྱཱན྄ ཨཝདད྄ ཝཡམཔི གཏྭཱ ཏེན སཱརྡྡྷཾ མྲིཡཱམཧཻ། ");
INSERT INTO santib_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ཡཱིཤུསྟཏྲོཔསྠཱཡ ཨིལིཡཱསརཿ ཤྨཤཱནེ སྠཱཔནཱཏ྄ ཙཏྭཱརི དིནཱནི གཏཱནཱིཏི ཝཱརྟྟཱཾ ཤྲུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ཝཻཐནཱིཡཱ ཡིརཱུཤཱལམཿ སམཱིཔསྠཱ ཀྲོཤཻཀམཱཏྲཱནྟརིཏཱ; ");
INSERT INTO santib_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ཏསྨཱད྄ བཧཝོ ཡིཧཱུདཱིཡཱ མརྠཱཾ མརིཡམཉྩ བྷྱཱཏྲྀཤོཀཱཔནྣཱཾ སཱནྟྭཡིཏུཾ ཏཡོཿ སམཱིཔམ྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","མརྠཱ ཡཱིཤོརཱགམནཝཱརྟཱཾ ཤྲུཏྭཻཝ ཏཾ སཱཀྵཱད྄ ཨཀརོཏ྄ ཀིནྟུ མརིཡམ྄ གེཧ ཨུཔཝིཤྱ སྠིཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ཏདཱ མརྠཱ ཡཱིཤུམཝཱདཏ྄, ཧེ པྲབྷོ ཡདི བྷཝཱན྄ ཨཏྲཱསྠཱསྱཏ྄ ཏརྷི མམ བྷྲཱཏཱ ནཱམརིཥྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ཀིནྟྭིདཱནཱིམཔི ཡད྄ ཨཱིཤྭརེ པྲཱརྠཡིཥྱཏེ ཨཱིཤྭརསྟད྄ དཱསྱཏཱིཏི ཛཱནེ྅ཧཾ། ");
INSERT INTO santib_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ཡཱིཤུརཝཱདཱིཏ྄ ཏཝ བྷྲཱཏཱ སམུཏྠཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","མརྠཱ ཝྱཱཧརཏ྄ ཤེཥདིཝསེ ས ཨུཏྠཱནསམཡེ པྲོཏྠཱསྱཏཱིཏི ཛཱནེ྅ཧཾ། ");
INSERT INTO santib_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ཏདཱ ཡཱིཤུཿ ཀཐིཏཝཱན྄ ཨཧམེཝ ཨུཏྠཱཔཡིཏཱ ཛཱིཝཡིཏཱ ཙ ཡཿ ཀཤྩན མཡི ཝིཤྭསིཏི ས མྲྀཏྭཱཔི ཛཱིཝིཥྱཏི; ");
INSERT INTO santib_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ཡཿ ཀཤྩན ཙ ཛཱིཝན྄ མཡི ཝིཤྭསིཏི ས ཀདཱཔི ན མརིཥྱཏི, ཨསྱཱཾ ཀཐཱཡཱཾ ཀིཾ ཝིཤྭསིཥི? ");
INSERT INTO santib_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","སཱཝདཏ྄ པྲབྷོ ཡསྱཱཝཏརཎཱཔེཀྵཱསྟི བྷཝཱན྄ སཨེཝཱབྷིཥིཀྟྟ ཨཱིཤྭརཔུཏྲ ཨིཏི ཝིཤྭསིམི། ");
INSERT INTO santib_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ཨིཏི ཀཐཱཾ ཀཐཡིཏྭཱ སཱ གཏྭཱ སྭཱཾ བྷགིནཱིཾ མརིཡམཾ གུཔྟམཱཧཱུཡ ཝྱཱཧརཏ྄ གུརུརུཔཏིཥྛཏི ཏྭཱམཱཧཱུཡཏི ཙ། ");
INSERT INTO santib_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ཀཐཱམིམཱཾ ཤྲུཏྭཱ སཱ ཏཱུརྞམ྄ ཨུཏྠཱཡ ཏསྱ སམཱིཔམ྄ ཨགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ཡཱིཤུ རྒྲཱམམདྷྱཾ ན པྲཝིཤྱ ཡཏྲ མརྠཱ ཏཾ སཱཀྵཱད྄ ཨཀརོཏ྄ ཏཏྲ སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ཡེ ཡིཧཱུདཱིཡཱ མརིཡམཱ སཱཀཾ གྲྀཧེ ཏིཥྛནྟསྟཱམ྄ ཨསཱནྟྭཡན ཏེ ཏཱཾ ཀྵིཔྲམ྄ ཨུཏྠཱཡ གཙྪནྟིཾ ཝིལོཀྱ ཝྱཱཧརན྄, ས ཤྨཤཱནེ རོདིཏུཾ ཡཱཏི, ཨིཏྱུཀྟྭཱ ཏེ ཏསྱཱཿ པཤྩཱད྄ ཨགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ཡཏྲ ཡཱིཤུརཏིཥྛཏ྄ ཏཏྲ མརིཡམ྄ ཨུཔསྠཱཡ ཏཾ དྲྀཥྚྭཱ ཏསྱ ཙརཎཡོཿ པཏིཏྭཱ ཝྱཱཧརཏ྄ ཧེ པྲབྷོ ཡདི བྷཝཱན྄ ཨཏྲཱསྠཱསྱཏ྄ ཏརྷི མམ བྷྲཱཏཱ ནཱམརིཥྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ཡཱིཤུསྟཱཾ ཏསྱཱཿ སངྒིནོ ཡིཧཱུདཱིཡཱཾཤྩ རུདཏོ ཝིལོཀྱ ཤོཀཱརྟྟཿ སན྄ དཱིརྒྷཾ ནིཤྭསྱ ཀཐིཏཝཱན྄ ཏཾ ཀུཏྲཱསྠཱཔཡཏ? ");
INSERT INTO santib_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ཏེ ཝྱཱཧརན྄, ཧེ པྲབྷོ བྷཝཱན྄ ཨཱགཏྱ པཤྱཏུ། ");
INSERT INTO santib_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ཡཱིཤུནཱ ཀྲནྡིཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ཨཏཨེཝ ཡིཧཱུདཱིཡཱ ཨཝདན྄, པཤྱཏཱཡཾ ཏསྨིན྄ ཀིདྲྀག྄ ཨཔྲིཡཏ། ");
INSERT INTO santib_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ཏེཥཱཾ ཀེཙིད྄ ཨཝདན྄ ཡོནྡྷཱཡ ཙཀྵུཥཱི དཏྟཝཱན྄ ས ཀིམ྄ ཨསྱ མྲྀཏྱུཾ ནིཝཱརཡིཏུཾ ནཱཤཀྣོཏ྄? ");
INSERT INTO santib_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ཏཏོ ཡཱིཤུཿ པུནརནྟརྡཱིརྒྷཾ ནིཤྭསྱ ཤྨཤཱནཱནྟིཀམ྄ ཨགཙྪཏ྄། ཏཏ྄ ཤྨཤཱནམ྄ ཨེཀཾ གཧྭརཾ ཏནྨུཁེ པཱཥཱཎ ཨེཀ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ཏདཱ ཡཱིཤུརཝདད྄ ཨེནཾ པཱཥཱཎམ྄ ཨཔསཱརཡཏ, ཏཏཿ པྲམཱིཏསྱ བྷགིནཱི མརྠཱཝདཏ྄ པྲབྷོ, ཨདྷུནཱ ཏཏྲ དུརྒནྡྷོ ཛཱཏཿ, ཡཏོདྱ ཙཏྭཱརི དིནཱནི ཤྨཤཱནེ ས ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ཏདཱ ཡཱིཤུརཝཱདཱིཏ྄, ཡདི ཝིཤྭསིཥི ཏརྷཱིཤྭརསྱ མཧིམཔྲཀཱཤཾ དྲཀྵྱསི ཀཐཱམིམཱཾ ཀིཾ ཏུབྷྱཾ ནཱཀཐཡཾ? ");
INSERT INTO santib_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ཏདཱ མྲྀཏསྱ ཤྨཤཱནཱཏ྄ པཱཥཱཎོ྅པསཱརིཏེ ཡཱིཤུརཱུརྡྭྭཾ པཤྱན྄ ཨཀཐཡཏ྄, ཧེ པིཏ རྨམ ནེཝེསནམ྄ ཨཤྲྀཎོཿ ཀཱརཎཱདསྨཱཏ྄ ཏྭཱཾ དྷནྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ཏྭཾ སཏཏཾ ཤྲྀཎོཥི ཏདཔྱཧཾ ཛཱནཱམི, ཀིནྟུ ཏྭཾ མཱཾ ཡཏ྄ པྲཻརཡསྟད྄ ཡཐཱསྨིན྄ སྠཱནེ སྠིཏཱ ལོཀཱ ཝིཤྭསནྟི ཏདརྠམ྄ ཨིདཾ ཝཱཀྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ཨིམཱཾ ཀཐཱཾ ཀཐཡིཏྭཱ ས པྲོཙྩཻརཱཧྭཡཏ྄, ཧེ ཨིལིཡཱསར྄ བཧིརཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ཏཏཿ ས པྲམཱིཏཿ ཤྨཤཱནཝསྟྲཻ རྦདྡྷཧསྟཔཱདོ གཱཏྲམཱརྫནཝཱསསཱ བདྡྷམུཁཤྩ བཧིརཱགཙྪཏ྄། ཡཱིཤུརུདིཏཝཱན྄ བནྡྷནཱནི མོཙཡིཏྭཱ ཏྱཛཏཻནཾ། ");
INSERT INTO santib_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","མརིཡམཿ སམཱིཔམ྄ ཨཱགཏཱ ཡེ ཡིཧཱུདཱིཡལོཀཱསྟདཱ ཡཱིཤོརེཏཏ྄ ཀརྨྨཱཔཤྱན྄ ཏེཥཱཾ བཧཝོ ཝྱཤྭསན྄, ");
INSERT INTO santib_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ཀིནྟུ ཀེཙིདནྱེ ཕིརཱུཤིནཱཾ སམཱིཔཾ གཏྭཱ ཡཱིཤོརེཏསྱ ཀརྨྨཎོ ཝཱརྟྟཱམ྄ ཨཝདན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ཏཏཿ པརཾ པྲདྷཱནཡཱཛཀཱཿ ཕིརཱུཤིནཱཤྩ སབྷཱཾ ཀྲྀཏྭཱ ཝྱཱཧརན྄ ཝཡཾ ཀིཾ ཀུརྨྨཿ? ཨེཥ མཱནཝོ བཧཱུནྱཱཤྩཪྻྱཀརྨྨཱཎི ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ཡདཱིདྲྀཤཾ ཀརྨྨ ཀརྟྟུཾ ན ཝཱརཡཱམསྟརྷི སཪྻྭེ ལོཀཱསྟསྨིན྄ ཝིཤྭསིཥྱནྟི རོམིལོཀཱཤྩཱགཏྱཱསྨཱཀམ྄ ཨནཡཱ རཱཛདྷཱནྱཱ སཱརྡྡྷཾ རཱཛྱམ྄ ཨཱཚེཏྶྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ཏདཱ ཏེཥཱཾ ཀིཡཕཱནཱམཱ ཡསྟསྨིན྄ ཝཏྶརེ མཧཱཡཱཛཀཔདེ ནྱཡུཛྱཏ ས པྲཏྱཝདད྄ ཡཱུཡཾ ཀིམཔི ན ཛཱནཱིཐ; ");
INSERT INTO santib_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","སམགྲདེཤསྱ ཝིནཱཤཏོཔི སཪྻྭལོཀཱརྠམ྄ ཨེཀསྱ ཛནསྱ མརཎམ྄ ཨསྨཱཀཾ མངྒལཧེཏུཀམ྄ ཨེཏསྱ ཝིཝེཙནཱམཔི ན ཀུརུཐ། ");
INSERT INTO santib_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ཨེཏཱཾ ཀཐཱཾ ས ནིཛབུདྡྷྱཱ ཝྱཱཧརད྄ ཨིཏི ན, ");
INSERT INTO santib_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ཀིནྟུ ཡཱིཤཱུསྟདྡེཤཱིཡཱནཱཾ ཀཱརཎཱཏ྄ པྲཱཎཱན྄ ཏྱཀྵྱཏི, དིཤི དིཤི ཝིཀཱིརྞཱན྄ ཨཱིཤྭརསྱ སནྟཱནཱན྄ སཾགྲྀཧྱཻཀཛཱཏིཾ ཀརིཥྱཏི ཙ, ཏསྨིན྄ ཝཏྶརེ ཀིཡཕཱ མཧཱཡཱཛཀཏྭཔདེ ནིཡུཀྟཿ སན྄ ཨིདཾ བྷཝིཥྱདྭཱཀྱཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ཏདྡིནམཱརབྷྱ ཏེ ཀཐཾ ཏཾ ཧནྟུཾ ཤཀྣུཝནྟཱིཏི མནྟྲཎཱཾ ཀརྟྟུཾ པྲཱརེབྷིརེ། ");
INSERT INTO santib_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ཨཏཨེཝ ཡིཧཱུདཱིཡཱནཱཾ མདྷྱེ ཡཱིཤུཿ སཔྲཀཱཤཾ གམནཱགམནེ ཨཀྲྀཏྭཱ ཏསྨཱད྄ གཏྭཱ པྲཱནྟརསྱ སམཱིཔསྠཱཡིཔྲདེཤསྱེཕྲཱཡིམ྄ ནཱམྣི ནགརེ ཤིཥྱཻཿ སཱཀཾ ཀཱལཾ ཡཱཔཡིཏུཾ པྲཱརེབྷེ། ");
INSERT INTO santib_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ཨནནྟརཾ ཡིཧཱུདཱིཡཱནཱཾ ནིསྟཱརོཏྶཝེ ནིཀཊཝརྟྟིནི སཏི ཏདུཏྶཝཱཏ྄ པཱུཪྻྭཾ སྭཱན྄ ཤུཙཱིན྄ ཀརྟྟུཾ བཧཝོ ཛནཱ གྲཱམེབྷྱོ ཡིརཱུཤཱལམ྄ ནགརམ྄ ཨཱགཙྪན྄, ");
INSERT INTO santib_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ཡཱིཤོརནྭེཥཎཾ ཀྲྀཏྭཱ མནྡིརེ དཎྜཱཡམཱནཱཿ སནྟཿ པརསྤརཾ ཝྱཱཧརན྄, ཡུཥྨཱཀཾ ཀཱིདྲྀཤོ བོདྷོ ཛཱཡཏེ? ས ཀིམ྄ ཨུཏྶཝེ྅སྨིན྄ ཨཏྲཱགམིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ས ཙ ཀུཏྲཱསྟི ཡདྱེཏཏ྄ ཀཤྩིད྄ ཝེཏྟི ཏརྷི དརྴཡཏུ པྲདྷཱནཡཱཛཀཱཿ ཕིརཱུཤིནཤྩ ཏཾ དྷརྟྟུཾ པཱུཪྻྭམ྄ ཨིམཱམ྄ ཨཱཛྙཱཾ པྲཱཙཱརཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ནིསྟཱརོཏྶཝཱཏ྄ པཱུཪྻྭཾ དིནཥཊྐེ སྠིཏེ ཡཱིཤུ ཪྻཾ པྲམཱིཏམ྄ ཨིལིཡཱསརཾ ཤྨཤཱནཱད྄ ཨུདསྠཱཔརཏ྄ ཏསྱ ནིཝཱསསྠཱནཾ བཻཐནིཡཱགྲཱམམ྄ ཨཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ཏཏྲ ཏདརྠཾ རཛནྱཱཾ བྷོཛྱེ ཀྲྀཏེ མརྠཱ པཪྻྱཝེཥཡད྄ ཨིལིཡཱསར྄ ཙ ཏསྱ སངྒིབྷིཿ སཱརྡྡྷཾ བྷོཛནཱསན ཨུཔཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ཏདཱ མརིཡམ྄ ཨརྡྡྷསེཊཀཾ བཧུམཱུལྱཾ ཛཊཱམཱཾསཱིཡཾ ཏཻལམ྄ ཨཱནཱིཡ ཡཱིཤོཤྩརཎཡོ རྨརྡྡཡིཏྭཱ ནིཛཀེཤ རྨཱརྵྚུམ྄ ཨཱརབྷཏ; ཏདཱ ཏཻལསྱ པརིམལེན གྲྀཧམ྄ ཨཱམོདིཏམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ཡཿ ཤིམོནཿ པུཏྲ རིཥྐརིཡོཏཱིཡོ ཡིཧཱུདཱནཱམཱ ཡཱིཤུཾ པརཀརེཥུ སམརྤཡིཥྱཏི ས ཤིཥྱསྟདཱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ཨེཏཏྟཻལཾ ཏྲིབྷིཿ ཤཏཻ རྨུདྲཱཔདཻ ཪྻིཀྲཱིཏཾ སད྄ དརིདྲེབྷྱཿ ཀུཏོ ནཱདཱིཡཏ? ");
INSERT INTO santib_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ས དརིདྲལོཀཱརྠམ྄ ཨཙིནྟཡད྄ ཨིཏི ན, ཀིནྟུ ས ཙཽར ཨེཝཾ ཏནྣིཀཊེ མུདྲཱསམྤུཊཀསྠིཏྱཱ ཏནྨདྷྱེ ཡདཏིཥྛཏ྄ ཏདཔཱཧརཏ྄ ཏསྨཱཏ྄ ཀཱརཎཱད྄ ཨིམཱཾ ཀཐཱམཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ཏདཱ ཡཱིཤུརཀཐཡད྄ ཨེནཱཾ མཱ ཝཱརཡ སཱ མམ ཤྨཤཱནསྠཱཔནདིནཱརྠཾ ཏདརཀྵཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","དརིདྲཱ ཡུཥྨཱཀཾ སནྣིདྷཽ སཪྻྭདཱ ཏིཥྛནྟི ཀིནྟྭཧཾ སཪྻྭདཱ ཡུཥྨཱཀཾ སནྣིདྷཽ ན ཏིཥྛཱམི། ");
INSERT INTO santib_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ཏཏཿ པརཾ ཡཱིཤུསྟཏྲཱསྟཱིཏི ཝཱརྟྟཱཾ ཤྲུཏྭཱ བཧཝོ ཡིཧཱུདཱིཡཱསྟཾ ཤྨཤཱནཱདུཏྠཱཔིཏམ྄ ཨིལིཡཱསརཉྩ དྲཥྚུཾ ཏཏ྄ སྠཱནམ྄ ཨཱགཙྪན། ");
INSERT INTO santib_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ཏདཱ པྲདྷཱནཡཱཛཀཱསྟམ྄ ཨིལིཡཱསརམཔི སཾཧརྟྟུམ྄ ཨམནྟྲཡན྄ ; ");
INSERT INTO santib_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ཡཏསྟེན བཧཝོ ཡིཧཱུདཱིཡཱ གཏྭཱ ཡཱིཤཽ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ཨནནྟརཾ ཡཱིཤུ ཪྻིརཱུཤཱལམ྄ ནགརམ྄ ཨཱགཙྪཏཱིཏི ཝཱརྟྟཱཾ ཤྲུཏྭཱ པརེ྅ཧནི ཨུཏྶཝཱགཏཱ བཧཝོ ལོཀཱཿ ");
INSERT INTO santib_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ཁརྫྫཱུརཔཏྲཱདྱཱནཱིཡ ཏཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ བཧིརཱགཏྱ ཛཡ ཛཡེཏི ཝཱཙཾ པྲོཙྩཻ ཪྻཀྟུམ྄ ཨཱརབྷནྟ, ཨིསྲཱཡེལོ ཡོ རཱཛཱ པརམེཤྭརསྱ ནཱམྣཱགཙྪཏི ས དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ཏདཱ \"ཧེ སིཡོནཿ ཀནྱེ མཱ བྷཻཥཱིཿ པཤྱཱཡཾ ཏཝ རཱཛཱ གརྡྡབྷཤཱཝཀམ྄ ཨཱརུཧྱཱགཙྪཏི\" ");
INSERT INTO santib_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ཨིཏི ཤཱསྟྲཱིཡཝཙནཱནུསཱརེཎ ཡཱིཤུརེཀཾ ཡུཝགརྡྡབྷཾ པྲཱཔྱ ཏདུཔཪྻྱཱརོཧཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ཨསྱཱཿ གྷཊནཱཡཱསྟཱཏྤཪྻྱཾ ཤིཥྱཱཿ པྲཐམཾ ནཱབུདྷྱནྟ, ཀིནྟུ ཡཱིཤཽ མཧིམཱནཾ པྲཱཔྟེ སཏི ཝཱཀྱམིདཾ ཏསྨིན ཨཀཐྱཏ ལོཀཱཤྩ ཏམྤྲཏཱིཏྠམ྄ ཨཀུཪྻྭན྄ ཨིཏི ཏེ སྨྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ས ཨིལིཡཱསརཾ ཤྨཤཱནཱད྄ ཨཱགནྟུམ྄ ཨཱཧྭཏཝཱན྄ ཤྨཤཱནཱཉྩ ཨུདསྠཱཔཡད྄ ཡེ ཡེ ལོཀཱསྟཏྐརྨྱ སཱཀྵཱད྄ ཨཔཤྱན྄ ཏེ པྲམཱཎཾ དཱཏུམ྄ ཨཱརབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ས ཨེཏཱདྲྀཤམ྄ ཨདྦྷུཏཾ ཀརྨྨཀརོཏ྄ ཏསྱ ཛནཤྲུཏེ རློཀཱསྟཾ སཱཀྵཱཏ྄ ཀརྟྟུམ྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ཏཏཿ ཕིརཱུཤིནཿ པརསྤརཾ ཝཀྟུམ྄ ཨཱརབྷནྟ ཡུཥྨཱཀཾ སཪྻྭཱཤྩེཥྚཱ ཝྲྀཐཱ ཛཱཏཱཿ, ཨིཏི ཀིཾ ཡཱུཡཾ ན བུདྷྱདྷྭེ? པཤྱཏ སཪྻྭེ ལོཀཱསྟསྱ པཤྩཱདྭརྟྟིནོབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","བྷཛནཾ ཀརྟྟུམ྄ ཨུཏྶཝཱགཏཱནཱཾ ལོཀཱནཱཾ ཀཏིཔཡཱ ཛནཱ ཨནྱདེཤཱིཡཱ ཨཱསན྄ , ");
INSERT INTO santib_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ཏེ གཱལཱིལཱིཡབཻཏྶཻདཱནིཝཱསིནཿ ཕིལིཔསྱ སམཱིཔམ྄ ཨཱགཏྱ ཝྱཱཧརན྄ ཧེ མཧེཙྪ ཝཡཾ ཡཱིཤུཾ དྲཥྚུམ྄ ཨིཙྪཱམཿ། ");
INSERT INTO santib_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ཏཏཿ ཕིལིཔོ གཏྭཱ ཨཱནྡྲིཡམ྄ ཨཝདཏ྄ པཤྩཱད྄ ཨཱནྡྲིཡཕིལིཔཽ ཡཱིཤཝེ ཝཱརྟྟཱམ྄ ཨཀཐཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ཏདཱ ཡཱིཤུཿ པྲཏྱུདིཏཝཱན྄ མཱནཝསུཏསྱ མཧིམཔྲཱཔྟིསམཡ ཨུཔསྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི, དྷཱནྱབཱིཛཾ མྲྀཏྟིཀཱཡཱཾ པཏིཏྭཱ ཡདི ན མྲྀཡཏེ ཏརྷྱེཀཱཀཱི ཏིཥྛཏི ཀིནྟུ ཡདི མྲྀཡཏེ ཏརྷི བཧུགུཎཾ ཕལཾ ཕལཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ཡོ ཛནེा ནིཛཔྲཱཎཱན྄ པྲིཡཱན྄ ཛཱནཱཏི ས ཏཱན྄ ཧཱརཡིཥྱཏི ཀིནྟུ ཡེा ཛན ཨིཧལོཀེ ནིཛཔྲཱཎཱན྄ ཨཔྲིཡཱན྄ ཛཱནཱཏི སེाནནྟཱཡུཿ པྲཱཔྟུཾ ཏཱན྄ རཀྵིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ཀཤྩིད྄ ཡདི མམ སེཝཀོ བྷཝིཏུཾ ཝཱཉྪཏི ཏརྷི ས མམ པཤྩཱདྒཱམཱི བྷཝཏུ, ཏསྨཱད྄ ཨཧཾ ཡཏྲ ཏིཥྛཱམི མམ སེཝཀེाཔི ཏཏྲ སྠཱསྱཏི; ཡོ ཛནོ མཱཾ སེཝཏེ མམ པིཏཱཔི ཏཾ སམྨཾསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","སཱམྤྲཏཾ མམ པྲཱཎཱ ཝྱཱཀུལཱ བྷཝནྟི, ཏསྨཱད྄ ཧེ པིཏར ཨེཏསྨཱཏ྄ སམཡཱན྄ མཱཾ རཀྵ, ཨིཏྱཧཾ ཀིཾ པྲཱརྠཡིཥྱེ? ཀིནྟྭཧམ྄ ཨེཏཏྶམཡཱརྠམ྄ ཨཝཏཱིརྞཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ཧེ པིཏ: སྭནཱམྣོ མཧིམཱནཾ པྲཀཱཤཡ; ཏནཻཝ སྭནཱམྣོ མཧིམཱནམ྄ ཨཧཾ པྲཱཀཱཤཡཾ པུནརཔི པྲཀཱཤཡིཥྱཱམི, ཨེཥཱ གགཎཱིཡཱ ཝཱཎཱི ཏསྨིན྄ སམཡེ྅ཛཱཡཏ། ");
INSERT INTO santib_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ཏཙྴྲུཏྭཱ སམཱིཔསྠལོཀཱནཱཾ ཀེཙིད྄ ཨཝདན྄ མེགྷོ྅གརྫཱིཏ྄, ཀེཙིད྄ ཨཝདན྄ སྭརྒཱིཡདཱུཏོ྅ནེན སཧ ཀཐཱམཙཀཐཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ཏདཱ ཡཱིཤུཿ པྲཏྱཝཱདཱིཏ྄, མདརྠཾ ཤབྡོཡཾ ནཱབྷཱུཏ྄ ཡུཥྨདརྠམེཝཱབྷཱུཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ཨདྷུནཱ ཛགཏོསྱ ཝིཙཱར: སམྤཏྶྱཏེ, ཨདྷུནཱསྱ ཛགཏ: པཏཱི རཱཛྱཱཏ྄ ཙྱོཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ཡདྱཨཱི པྲྀཐིཝྱཱ ཨཱུརྡྭྭེ པྲོཏྠཱཔིཏོསྨི ཏརྷི སཪྻྭཱན྄ མཱནཝཱན྄ སྭསམཱིཔམ྄ ཨཱཀརྵིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ཀཐཾ ཏསྱ མྲྀཏི རྦྷཝིཥྱཏི, ཨེཏད྄ བོདྷཡིཏུཾ ས ཨིམཱཾ ཀཐཱམ྄ ཨཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ཏདཱ ལོཀཱ ཨཀཐཡན྄ སོབྷིཥིཀྟཿ སཪྻྭདཱ ཏིཥྛཏཱིཏི ཝྱཝསྠཱགྲནྠེ ཤྲུཏམ྄ ཨསྨཱབྷིཿ, ཏརྷི མནུཥྱཔུཏྲཿ པྲོཏྠཱཔིཏོ བྷཝིཥྱཏཱིཏི ཝཱཀྱཾ ཀཐཾ ཝདསི? མནུཥྱཔུཏྲོཡཾ ཀཿ? ");
INSERT INTO santib_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ཏདཱ ཡཱིཤུརཀཐཱཡད྄ ཡུཥྨཱབྷིཿ སཱརྡྡྷམ྄ ཨལྤདིནཱནི ཛྱོཏིརཱསྟེ, ཡཐཱ ཡུཥྨཱན྄ ཨནྡྷཀཱརོ ནཱཙྪཱདཡཏི ཏདརྠཾ ཡཱཝཏྐཱལཾ ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ ཛྱོཏིསྟིཥྛཏི ཏཱཝཏྐཱལཾ གཙྪཏ; ཡོ ཛནོ྅ནྡྷཀཱརེ གཙྪཏི ས ཀུཏྲ ཡཱཏཱིཏི ན ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ཨཏཨེཝ ཡཱཝཏྐཱལཾ ཡུཥྨཱཀཾ ནིཀཊེ ཛྱོཏིརཱསྟེ ཏཱཝཏྐཱལཾ ཛྱོཏཱིརཱུཔསནྟཱནཱ བྷཝིཏུཾ ཛྱོཏིཥི ཝིཤྭསིཏ; ཨིམཱཾ ཀཐཱཾ ཀཐཡིཏྭཱ ཡཱིཤུཿ པྲསྠཱཡ ཏེབྷྱཿ སྭཾ གུཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ཡདྱཔི ཡཱིཤུསྟེཥཱཾ སམཀྵམ྄ ཨེཏཱཝདཱཤྩཪྻྱཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཏཐཱཔི ཏེ ཏསྨིན྄ ན ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ཨཏཨེཝ ཀཿ པྲཏྱེཏི སུསཾཝཱདཾ པརེཤཱསྨཏ྄ པྲཙཱརིཏཾ? པྲཀཱཤཏེ པརེཤསྱ ཧསྟཿ ཀསྱ ཙ སནྣིདྷཽ? ཡིཤཡིཡབྷཝིཥྱདྭཱདིནཱ ཡདེཏད྄ ཝཱཀྱམུཀྟཾ ཏཏ྄ སཕལམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ཏེ པྲཏྱེཏུཾ ནཱཤནྐུཝན྄ ཏསྨིན྄ ཡིཤཡིཡབྷཝིཥྱདྭཱདི པུནརཝཱདཱིད྄, ");
INSERT INTO santib_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ཡདཱ, \"ཏེ ནཡནཻ རྣ པཤྱནྟི བུདྡྷིབྷིཤྩ ན བུདྷྱནྟེ ཏཻ རྨནཿསུ པརིཝརྟྟིཏེཥུ ཙ ཏཱནཧཾ ཡཐཱ སྭསྠཱན྄ ན ཀརོམི ཏཐཱ ས ཏེཥཱཾ ལོཙནཱནྱནྡྷཱནི ཀྲྀཏྭཱ ཏེཥཱམནྟཿཀརཎཱནི གཱཌྷཱནི ཀརིཥྱཏི། \" ");
INSERT INTO santib_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ཡིཤཡིཡོ ཡདཱ ཡཱིཤོ རྨཧིམཱནཾ ཝིལོཀྱ ཏསྨིན྄ ཀཐཱམཀཐཡཏ྄ ཏདཱ བྷཝིཥྱདྭཱཀྱམ྄ ཨཱིདྲྀཤཾ པྲཀཱཤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ཏཐཱཔྱདྷིཔཏིནཱཾ བཧཝསྟསྨིན྄ པྲཏྱཱཡན྄། ཀིནྟུ ཕིརཱུཤིནསྟཱན྄ བྷཛནགྲྀཧཱད྄ དཱུརཱིཀུཪྻྭནྟཱིཏི བྷཡཱཏ྄ ཏེ ཏཾ ན སྭཱིཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ཡཏ ཨཱིཤྭརསྱ པྲཤཾསཱཏོ མཱནཝཱནཱཾ པྲཤཾསཱཡཱཾ ཏེ྅པྲིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ཏདཱ ཡཱིཤུརུཙྩཻཿཀཱརམ྄ ཨཀཐཡད྄ ཡོ ཛནོ མཡི ཝིཤྭསིཏི ས ཀེཝལེ མཡི ཝིཤྭསིཏཱིཏི ན, ས མཏྤྲེརཀེ྅པི ཝིཤྭསིཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ཡོ ཛནོ མཱཾ པཤྱཏི ས མཏྤྲེརཀམཔི པཤྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ཡོ ཛནོ མཱཾ པྲཏྱེཏི ས ཡཐཱནྡྷཀཱརེ ན ཏིཥྛཏི ཏདརྠམ྄ ཨཧཾ ཛྱོཏིཿསྭརཱུཔོ བྷཱུཏྭཱ ཛགཏྱསྨིན྄ ཨཝཏཱིརྞཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","མམ ཀཐཱཾ ཤྲུཏྭཱ ཡདི ཀཤྩིན྄ ན ཝིཤྭསིཏི ཏརྷི ཏམཧཾ དོཥིཎཾ ན ཀརོམི, ཡཏོ ཧེཏོ རྫགཏོ ཛནཱནཱཾ དོཥཱན྄ ནིཤྩིཏཱན྄ ཀརྟྟུཾ ནཱགཏྱ ཏཱན྄ པརིཙཱཏུམ྄ ཨཱགཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ཡཿ ཀཤྩིན྄ མཱཾ ན ཤྲདྡྷཱཡ མམ ཀཐཾ ན གྲྀཧླཱཏི, ཨནྱསྟཾ དོཥིཎཾ ཀརིཥྱཏི ཝསྟུཏསྟུ ཡཱཾ ཀཐཱམཧམ྄ ཨཙཀཐཾ སཱ ཀཐཱ ཙརམེ྅ནྷི ཏཾ དོཥིཎཾ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ཡཏོ ཧེཏོརཧཾ སྭཏཿ ཀིམཔི ན ཀཐཡཱམི, ཀིཾ ཀིཾ མཡཱ ཀཐཡིཏཝྱཾ ཀིཾ སམུཔདེཥྚཝྱཉྩ ཨིཏི མཏྤྲེརཡིཏཱ པིཏཱ མཱམཱཛྙཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ཏསྱ སཱཛྙཱ ཨནནྟཱཡུརིཏྱཧཾ ཛཱནཱམི, ཨཏཨེཝཱཧཾ ཡཏ྄ ཀཐཡཱམི ཏཏ྄ པིཏཱ ཡཐཱཛྙཱཔཡཏ྄ ཏཐཻཝ ཀཐཡཱམྱཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ནིསྟཱརོཏྶཝསྱ ཀིཉྩིཏྐཱལཱཏ྄ པཱུཪྻྭཾ པྲྀཐིཝྱཱཿ པིཏུཿ སམཱིཔགམནསྱ སམཡཿ སནྣིཀརྵོབྷཱུད྄ ཨིཏི ཛྙཱཏྭཱ ཡཱིཤུརཱཔྲཐམཱད྄ ཡེཥུ ཛགཏྤྲཝཱསིཥྭཱཏྨཱིཡལོཀེཥ པྲེམ ཀརོཏི སྨ ཏེཥུ ཤེཥཾ ཡཱཝཏ྄ པྲེམ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","པིཏཱ ཏསྱ ཧསྟེ སཪྻྭཾ སམརྤིཏཝཱན྄ སྭཡམ྄ ཨཱིཤྭརསྱ སམཱིཔཱད྄ ཨཱགཙྪད྄ ཨཱིཤྭརསྱ སམཱིཔཾ ཡཱསྱཏི ཙ, སཪྻྭཱཎྱེཏཱནི ཛྙཱཏྭཱ རཛནྱཱཾ བྷོཛནེ སམྤཱུརྞེ སཏི, ");
INSERT INTO santib_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ཡདཱ ཤཻཏཱན྄ ཏཾ པརཧསྟེཥུ སམརྤཡིཏུཾ ཤིམོནཿ པུཏྲསྱ ཨཱིཥྐཱརིཡོཏིཡསྱ ཡིཧཱུདཱ ཨནྟཿཀརཎེ ཀུཔྲཝྲྀཏྟིཾ སམཱརྤཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ཏདཱ ཡཱིཤུ རྦྷོཛནཱསནཱད྄ ཨུཏྠཱཡ གཱཏྲཝསྟྲཾ མོཙཡིཏྭཱ གཱཏྲམཱརྫནཝསྟྲཾ གྲྀཧཱིཏྭཱ ཏེན སྭཀཊིམ྄ ཨབདྷྣཱཏ྄, ");
INSERT INTO santib_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","པཤྩཱད྄ ཨེཀཔཱཏྲེ ཛལམ྄ ཨབྷིཥིཙྱ ཤིཥྱཱཎཱཾ པཱདཱན྄ པྲཀྵཱལྱ ཏེན ཀཊིབདྡྷགཱཏྲམཱརྫནཝཱསསཱ མཱརྵྚུཾ པྲཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ཏཏཿ ཤིམོནྤིཏརསྱ སམཱིཔམཱགཏེ ས ཨུཀྟཝཱན྄ ཧེ པྲབྷོ བྷཝཱན྄ ཀིཾ མམ པཱདཽ པྲཀྵཱལཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ཡཱིཤུརུདིཏཝཱན྄ ཨཧཾ ཡཏ྄ ཀརོམི ཏཏ྄ སམྤྲཏི ན ཛཱནཱསི ཀིནྟུ པཤྩཱཛ྄ ཛྙཱསྱསི། ");
INSERT INTO santib_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ཏཏཿ པིཏརཿ ཀཐིཏཝཱན྄ བྷཝཱན྄ ཀདཱཔི མམ པཱདཽ ན པྲཀྵཱལཡིཥྱཏི། ཡཱིཤུརཀཐཡད྄ ཡདི ཏྭཱཾ ན པྲཀྵཱལཡེ ཏརྷི མཡི ཏཝ ཀོཔྱཾཤོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ཏདཱ ཤིམོནྤིཏརཿ ཀཐིཏཝཱན྄ ཧེ པྲབྷོ ཏརྷི ཀེཝལཔཱདཽ ན, མམ ཧསྟཽ ཤིརཤྩ པྲཀྵཱལཡཏུ། ");
INSERT INTO santib_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ཏཏོ ཡཱིཤུརཝདད྄ ཡོ ཛནོ དྷཽཏསྟསྱ སཪྻྭཱངྒཔརིཥྐྲྀཏཏྭཱཏ྄ པཱདཽ ཝིནཱནྱཱངྒསྱ པྲཀྵཱལནཱཔེཀྵཱ ནཱསྟི། ཡཱུཡཾ པརིཥྐྲྀཏཱ ཨིཏི སཏྱཾ ཀིནྟུ ན སཪྻྭེ, ");
INSERT INTO santib_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ཡཏོ ཡོ ཛནསྟཾ པརཀརེཥུ སམརྤཡིཥྱཏི ཏཾ ས ཛྙཱཏཝཱན; ཨཏཨེཝ ཡཱུཡཾ སཪྻྭེ ན པརིཥྐྲྀཏཱ ཨིམཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ཨིཏྠཾ ཡཱིཤུསྟེཥཱཾ པཱདཱན྄ པྲཀྵཱལྱ ཝསྟྲཾ པརིདྷཱཡཱསནེ སམུཔཝིཤྱ ཀཐིཏཝཱན྄ ཨཧཾ ཡུཥྨཱན྄ པྲཏི ཀིཾ ཀརྨྨཱཀཱརྵཾ ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ཡཱུཡཾ མཱཾ གུརུཾ པྲབྷུཉྩ ཝདཐ ཏཏ྄ སཏྱམེཝ ཝདཐ ཡཏོཧཾ སཨེཝ བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ཡདྱཧཾ པྲབྷུ རྒུརུཤྩ སན྄ ཡུཥྨཱཀཾ པཱདཱན྄ པྲཀྵཱལིཏཝཱན྄ ཏརྷི ཡུཥྨཱཀམཔི པརསྤརཾ པཱདཔྲཀྵཱལནམ྄ ཨུཙིཏམ྄། ");
INSERT INTO santib_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ཨཧཾ ཡུཥྨཱན྄ པྲཏི ཡཐཱ ཝྱཝཱཧརཾ ཡུཥྨཱན྄ ཏཐཱ ཝྱཝཧརྟྟུམ྄ ཨེཀཾ པནྠཱནཾ དརྴིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི, པྲབྷོ རྡཱསོ ན མཧཱན྄ པྲེརཀཱཙྩ པྲེརིཏོ ན མཧཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ཨིམཱཾ ཀཐཱཾ ཝིདིཏྭཱ ཡདི ཏདནུསཱརཏཿ ཀརྨྨཱཎི ཀུརུཐ ཏརྷི ཡཱུཡཾ དྷནྱཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","སཪྻྭེཥུ ཡུཥྨཱསུ ཀཐཱམིམཱཾ ཀཐཡཱམི ཨིཏི ན, ཡེ མམ མནོནཱིཏཱསྟཱནཧཾ ཛཱནཱམི, ཀིནྟུ མམ བྷཀྵྱཱཎི ཡོ བྷུངྐྟེ མཏྤྲཱཎཔྲཱཏིཀཱུལྱཏཿ། ཨུཏྠཱཔཡཏི པཱདསྱ མཱུལཾ ས ཨེཥ མཱནཝཿ། ཡདེཏད྄ དྷརྨྨཔུསྟཀསྱ ཝཙནཾ ཏདནུསཱརེཎཱཝཤྱཾ གྷཊིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ཨཧཾ ས ཛན ཨིཏྱཏྲ ཡཐཱ ཡུཥྨཱཀཾ ཝིཤྭཱསོ ཛཱཡཏེ ཏདརྠཾ ཨེཏཱདྲྀཤགྷཊནཱཏ྄ པཱུཪྻྭམ྄ ཨཧམིདཱནཱིཾ ཡུཥྨབྷྱམཀཐཡམ྄། ");
INSERT INTO santib_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ཨཧཾ ཡུཥྨཱནཏཱིཝ ཡཐཱརྠཾ ཝདཱམི, མཡཱ པྲེརིཏཾ ཛནཾ ཡོ གྲྀཧླཱཏི ས མཱམེཝ གྲྀཧླཱཏི ཡཤྩ མཱཾ གྲྀཧླཱཏི ས མཏྤྲེརཀཾ གྲྀཧླཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ཨེཏཱཾ ཀཐཱཾ ཀཐཡིཏྭཱ ཡཱིཤུ རྡུཿཁཱི སན྄ པྲམཱཎཾ དཏྟྭཱ ཀཐིཏཝཱན྄ ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི ཡུཥྨཱཀམ྄ ཨེཀོ ཛནོ མཱཾ པརཀརེཥུ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ཏཏཿ ས ཀམུདྡིཤྱ ཀཐཱམེཏཱཾ ཀཐིཏཝཱན྄ ཨིཏྱཏྲ སནྡིགྡྷཱཿ ཤིཥྱཱཿ པརསྤརཾ མུཁམཱལོཀཡིཏུཾ པྲཱརབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ཏསྨིན྄ སམཡེ ཡཱིཤུ ཪྻསྨིན྄ ཨཔྲཱིཡཏ ས ཤིཥྱསྟསྱ ཝཀྵཿསྠལམ྄ ཨཝཱལམྦཏ། ");
INSERT INTO santib_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ཤིམོནྤིཏརསྟཾ སངྐེཏེནཱཝདཏ྄, ཨཡཾ ཀམུདྡིཤྱ ཀཐཱམེཏཱམ྄ ཀཐཡཏཱིཏི པྲྀཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ཏདཱ ས ཡཱིཤོ ཪྻཀྵཿསྠལམ྄ ཨཝལམྦྱ པྲྀཥྛཝཱན྄, ཧེ པྲབྷོ ས ཛནཿ ཀཿ? ");
INSERT INTO santib_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ཏཏོ ཡཱིཤུཿ པྲཏྱཝདད྄ ཨེཀཁཎྜཾ པཱུཔཾ མཛྫཡིཏྭཱ ཡསྨཻ དཱསྱཱམི སཨེཝ སཿ; པཤྩཱཏ྄ པཱུཔཁཎྜམེཀཾ མཛྫཡིཏྭཱ ཤིམོནཿ པུཏྲཱཡ ཨཱིཥྐརིཡོཏཱིཡཱཡ ཡིཧཱུདཻ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ཏསྨིན྄ དཏྟེ སཏི ཤཻཏཱན྄ ཏམཱཤྲཡཏ྄; ཏདཱ ཡཱིཤུསྟམ྄ ཨཝདཏ྄ ཏྭཾ ཡཏ྄ ཀརིཥྱསི ཏཏ྄ ཀྵིཔྲཾ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ཀིནྟུ ས ཡེནཱཤཡེན ཏཱཾ ཀཐཱམཀཐཱཡཏ྄ ཏམ྄ ཨུཔཝིཥྚལོཀཱནཱཾ ཀོཔི ནཱབུདྷྱཏ; ");
INSERT INTO santib_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ཀིནྟུ ཡིཧཱུདཱཿ སམཱིཔེ མུདྲཱསམྤུཊཀསྠིཏེཿ ཀེཙིད྄ ཨིཏྠམ྄ ཨབུདྷྱནྟ པཱཪྻྭཎཱསཱདནཱརྠཾ ཀིམཔི དྲཝྱཾ ཀྲེཏུཾ ཝཱ དརིདྲེབྷྱཿ ཀིཉྩིད྄ ཝིཏརིཏུཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ཏདཱ པཱུཔཁཎྜགྲཧཎཱཏ྄ པརཾ ས ཏཱུརྞཾ བཧིརགཙྪཏ྄; རཱཏྲིཤྩ སམུཔསྱིཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ཡིཧཱུདེ བཧིརྒཏེ ཡཱིཤུརཀཐཡད྄ ཨིདཱནཱིཾ མཱནཝསུཏསྱ མཧིམཱ པྲཀཱཤཏེ ཏེནེཤྭརསྱཱཔི མཧིམཱ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ཡདི ཏེནེཤྭརསྱ མཧིམཱ པྲཀཱཤཏེ ཏརྷཱིཤྭརོཔི སྭེན ཏསྱ མཧིམཱནཾ པྲཀཱཤཡིཥྱཏི ཏཱུརྞམེཝ པྲཀཱཤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ཧེ ཝཏྶཱ ཨཧཾ ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ ཀིཉྩིཏྐཱལམཱཏྲམ྄ ཨཱསེ, ཏཏཿ པརཾ མཱཾ མྲྀགཡིཥྱདྷྭེ ཀིནྟྭཧཾ ཡཏྶྠཱནཾ ཡཱམི ཏཏྶྠཱནཾ ཡཱུཡཾ གནྟུཾ ན ཤཀྵྱཐ, ཡཱམིམཱཾ ཀཐཱཾ ཡིཧཱུདཱིཡེབྷྱཿ ཀཐིཏཝཱན྄ ཏཐཱདྷུནཱ ཡུཥྨབྷྱམཔི ཀཐཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ཡཱུཡཾ པརསྤརཾ པྲཱིཡདྷྭམ྄ ཨཧཾ ཡུཥྨཱསུ ཡཐཱ པྲཱིཡེ ཡཱུཡམཔི པརསྤརམ྄ ཏཐཻཝ པྲཱིཡདྷྭཾ, ཡུཥྨཱན྄ ཨིམཱཾ ནཝཱིནཱམ྄ ཨཱཛྙཱམ྄ ཨཱདིཤཱམི། ");
INSERT INTO santib_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ཏེནཻཝ ཡདི པརསྤརཾ པྲཱིཡདྷྭེ ཏརྷི ལཀྵཎེནཱནེན ཡཱུཡཾ མམ ཤིཥྱཱ ཨིཏི སཪྻྭེ ཛྙཱཏུཾ ཤཀྵྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ཤིམོནཔིཏརཿ པྲྀཥྛཝཱན྄ ཧེ པྲབྷོ བྷཝཱན྄ ཀུཏྲ ཡཱསྱཏི? ཏཏོ ཡཱིཤུཿ པྲཏྱཝདཏ྄, ཨཧཾ ཡཏྶྠཱནཾ ཡཱམི ཏཏྶྠཱནཾ སཱམྤྲཏཾ མམ པཤྩཱད྄ གནྟུཾ ན ཤཀྣོཥི ཀིནྟུ པཤྩཱད྄ གམིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ཏདཱ པིཏརཿ པྲཏྱུདིཏཝཱན྄, ཧེ པྲབྷོ སཱམྤྲཏཾ ཀུཏོ ཧེཏོསྟཝ པཤྩཱད྄ གནྟུཾ ན ཤཀྣོམི? ཏྭདརྠཾ པྲཱཎཱན྄ དཱཏུཾ ཤཀྣོམི། ");
INSERT INTO santib_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ཏཏོ ཡཱིཤུཿ པྲཏྱུཀྟཝཱན྄ མནྣིམིཏྟཾ ཀིཾ པྲཱཎཱན྄ དཱཏུཾ ཤཀྣོཥི? ཏྭཱམཧཾ ཡཐཱརྠཾ ཝདཱམི, ཀུཀྐུཊརཝཎཱཏ྄ པཱུཪྻྭཾ ཏྭཾ ཏྲི རྨཱམ྄ ཨཔཧྣོཥྱསེ། ");
INSERT INTO santib_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","མནོདུཿཁིནོ མཱ བྷཱུཏ; ཨཱིཤྭརེ ཝིཤྭསིཏ མཡི ཙ ཝིཤྭསིཏ། ");
INSERT INTO santib_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","མམ པིཏུ གྲྀཧེ བཧཱུནི ཝཱསསྠཱནི སནྟི ནོ ཙེཏ྄ པཱུཪྻྭཾ ཡུཥྨཱན྄ ཨཛྙཱཔཡིཥྱཾ ཡུཥྨདརྠཾ སྠཱནཾ སཛྫཡིཏུཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ཡདི གཏྭཱཧཾ ཡུཥྨནྣིམིཏྟཾ སྠཱནཾ སཛྫཡཱམི ཏརྷི པནརཱགཏྱ ཡུཥྨཱན྄ སྭསམཱིཔཾ ནེཥྱཱམི, ཏཏོ ཡཏྲཱཧཾ ཏིཥྛཱམི ཏཏྲ ཡཱུཡམཔི སྠཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ཨཧཾ ཡཏྶྠཱནཾ བྲཛཱམི ཏཏྶྠཱནཾ ཡཱུཡཾ ཛཱནཱིཐ ཏསྱ པནྠཱནམཔི ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ཏདཱ ཐོམཱ ཨཝདཏ྄, ཧེ པྲབྷོ བྷཝཱན྄ ཀུཏྲ ཡཱཏི ཏདྭཡཾ ན ཛཱནཱིམཿ, ཏརྷི ཀཐཾ པནྠཱནཾ ཛྙཱཏུཾ ཤཀྣུམཿ? ");
INSERT INTO santib_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ཡཱིཤུརཀཐཡད྄ ཨཧམེཝ སཏྱཛཱིཝནརཱུཔཔཐོ མཡཱ ན གནྟཱ ཀོཔི པིཏུཿ སམཱིཔཾ གནྟུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ཡདི མཱམ྄ ཨཛྙཱསྱཏ ཏརྷི མམ པིཏརམཔྱཛྙཱསྱཏ ཀིནྟྭདྷུནཱཏསྟཾ ཛཱནཱིཐ པཤྱཐ ཙ། ");
INSERT INTO santib_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ཏདཱ ཕིལིཔཿ ཀཐིཏཝཱན྄, ཧེ པྲབྷོ པིཏརཾ དརྴཡ ཏསྨཱདསྨཱཀཾ ཡཐེཥྚཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ཏཏོ ཡཱིཤུཿ པྲཏྱཱཝཱདཱིཏ྄, ཧེ ཕིལིཔ ཡུཥྨཱབྷིཿ སཱརྡྡྷམ྄ ཨེཏཱཝདྡིནཱནི སྠིཏམཔི མཱཾ ཀིཾ ན པྲཏྱབྷིཛཱནཱསི? ཡོ ཛནོ མཱམ྄ ཨཔཤྱཏ྄ ས པིཏརམཔྱཔཤྱཏ྄ ཏརྷི པིཏརམ྄ ཨསྨཱན྄ དརྴཡེཏི ཀཐཱཾ ཀཐཾ ཀཐཡསི? ");
INSERT INTO santib_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ཨཧཾ པིཏརི ཏིཥྛཱམི པིཏཱ མཡི ཏིཥྛཏཱིཏི ཀིཾ ཏྭཾ ན པྲཏྱཥི? ཨཧཾ ཡདྭཱཀྱཾ ཝདཱམི ཏཏ྄ སྭཏོ ན ཝདཱམི ཀིནྟུ ཡཿ པིཏཱ མཡི ཝིརཱཛཏེ ས ཨེཝ སཪྻྭཀརྨྨཱཎི ཀརཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ཨཏཨེཝ པིཏཪྻྱཧཾ ཏིཥྛཱམི པིཏཱ ཙ མཡི ཏིཥྛཏི མམཱསྱཱཾ ཀཐཱཡཱཾ པྲཏྱཡཾ ཀུརུཏ, ནོ ཙེཏ྄ ཀརྨྨཧེཏོཿ པྲཏྱཡཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ཨཧཾ ཡུཥྨཱནཏིཡཐཱརྠཾ ཝདཱམི, ཡོ ཛནོ མཡི ཝིཤྭསིཏི སོཧམིཝ ཀརྨྨཱཎི ཀརིཥྱཏི ཝརཾ ཏཏོཔི མཧཱཀརྨྨཱཎི ཀརིཥྱཏི ཡཏོ ཧེཏོརཧཾ པིཏུཿ སམཱིཔཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ཡཐཱ པུཏྲེཎ པིཏུ རྨཧིམཱ པྲཀཱཤཏེ ཏདརྠཾ མམ ནཱམ པྲོཙྱ ཡཏ྄ པྲཱརྠཡིཥྱདྷྭེ ཏཏ྄ སཕལཾ ཀརིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ཡདི མམ ནཱམྣཱ ཡཏ྄ ཀིཉྩིད྄ ཡཱཙདྷྭེ ཏརྷི ཏདཧཾ སཱདྷཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ཡདི མཡི པྲཱིཡདྷྭེ ཏརྷི མམཱཛྙཱཿ སམཱཙརཏ། ");
INSERT INTO santib_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ཏཏོ མཡཱ པིཏུཿ སམཱིཔེ པྲཱརྠིཏེ པིཏཱ ནིརནྟརཾ ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ སྠཱཏུམ྄ ཨིཏརམེཀཾ སཧཱཡམ྄ ཨརྠཱཏ྄ སཏྱམཡམ྄ ཨཱཏྨཱནཾ ཡུཥྨཱཀཾ ནིཀཊཾ པྲེཥཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ཨེཏཛྫགཏོ ལོཀཱསྟཾ གྲཧཱིཏུཾ ན ཤཀྣུཝནྟི ཡཏསྟེ ཏཾ ནཱཔཤྱན྄ ནཱཛནཾཤྩ ཀིནྟུ ཡཱུཡཾ ཛཱནཱིཐ ཡཏོ ཧེཏོཿ ས ཡུཥྨཱཀམནྟ རྣིཝསཏི ཡུཥྨཱཀཾ མདྷྱེ སྠཱསྱཏི ཙ། ");
INSERT INTO santib_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ཨཧཾ ཡུཥྨཱན྄ ཨནཱཐཱན྄ ཀྲྀཏྭཱ ན ཡཱསྱཱམི པུནརཔི ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགམིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ཀིཡཏྐཱལརཏ྄ པརམ྄ ཨསྱ ཛགཏོ ལོཀཱ མཱཾ པུན རྣ དྲཀྵྱནྟི ཀིནྟུ ཡཱུཡཾ དྲཀྵྱཐ;ཨཧཾ ཛཱིཝིཥྱཱམི ཏསྨཱཏ྄ ཀཱརཎཱད྄ ཡཱུཡམཔི ཛཱིཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","པིཏཪྻྱཧམསྨི མཡི ཙ ཡཱུཡཾ སྠ, ཏཐཱཧཾ ཡུཥྨཱསྭསྨི ཏདཔི ཏདཱ ཛྙཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ཡོ ཛནོ མམཱཛྙཱ གྲྀཧཱིཏྭཱ ཏཱ ཨཱཙརཏི སཨེཝ མཡི པྲཱིཡཏེ; ཡོ ཛནཤྩ མཡི པྲཱིཡཏེ སཨེཝ མམ པིཏུཿ པྲིཡཔཱཏྲཾ བྷཝིཥྱཏི, ཏཐཱཧམཔི ཏསྨིན྄ པྲཱིཏྭཱ ཏསྨཻ སྭཾ པྲཀཱཤཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ཏདཱ ཨཱིཥྐརིཡོཏཱིཡཱད྄ ཨནྱོ ཡིཧཱུདཱསྟམཝདཏ྄, ཧེ པྲབྷོ བྷཝཱན྄ ཛགཏོ ལོཀཱནཱཾ སནྣིདྷཽ པྲཀཱཤིཏོ ན བྷཱུཏྭཱསྨཱཀཾ སནྣིདྷཽ ཀུཏཿ པྲཀཱཤིཏོ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ཏཏོ ཡཱིཤུཿ པྲཏྱུདིཏཝཱན྄, ཡོ ཛནོ མཡི པྲཱིཡཏེ ས མམཱཛྙཱ ཨཔི གྲྀཧླཱཏི, ཏེན མམ པིཏཱཔི ཏསྨིན྄ པྲེཥྱཏེ, ཨཱཝཱཉྩ ཏནྣིཀཊམཱགཏྱ ཏེན སཧ ནིཝཏྶྱཱཝཿ། ");
INSERT INTO santib_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ཡོ ཛནོ མཡི ན པྲཱིཡཏེ ས མམ ཀཐཱ ཨཔི ན གྲྀཧླཱཏི པུནཤྩ ཡཱམིམཱཾ ཀཐཱཾ ཡཱུཡཾ ཤྲྀཎུཐ སཱ ཀཐཱ ཀེཝལསྱ མམ ན ཀིནྟུ མམ པྲེརཀོ ཡཿ པིཏཱ ཏསྱཱཔི ཀཐཱ། ");
INSERT INTO santib_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ཨིདཱནཱིཾ ཡུཥྨཱཀཾ ནིཀཊེ ཝིདྱམཱནོཧམ྄ ཨེཏཱཿ སཀལཱཿ ཀཐཱཿ ཀཐཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ཀིནྟྭིཏཿ པརཾ པིཏྲཱ ཡཿ སཧཱཡོ྅རྠཱཏ྄ པཝིཏྲ ཨཱཏྨཱ མམ ནཱམྣི པྲེརཡིཥྱཏི ས སཪྻྭཾ ཤིཀྵཡིཏྭཱ མཡོཀྟཱཿ སམསྟཱཿ ཀཐཱ ཡུཥྨཱན྄ སྨཱརཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ཨཧཾ ཡུཥྨཱཀཾ ནིཀཊེ ཤཱནྟིཾ སྠཱཔཡིཏྭཱ ཡཱམི, ནིཛཱཾ ཤཱནྟིཾ ཡུཥྨབྷྱཾ དདཱམི, ཛགཏོ ལོཀཱ ཡཐཱ དདཱཏི ཏཐཱཧཾ ན དདཱམི; ཡུཥྨཱཀམ྄ ཨནྟཿཀརཎཱནི དུཿཁིཏཱནི བྷཱིཏཱནི ཙ ན བྷཝནྟུ། ");
INSERT INTO santib_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ཨཧཾ གཏྭཱ པུནརཔི ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགམིཥྱཱམི མཡོཀྟཾ ཝཱཀྱམིདཾ ཡཱུཡམ྄ ཨཤྲཽཥྚ; ཡདི མཡྻཔྲེཥྱདྷྭཾ ཏརྷྱཧཾ པིཏུཿ སམཱིཔཾ གཙྪཱམི མམཱསྱཱཾ ཀཐཱཡཱཾ ཡཱུཡམ྄ ཨཧླཱདིཥྱདྷྭཾ ཡཏོ མམ པིཏཱ མཏྟོཔི མཧཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ཏསྱཱ གྷཊནཱཡཱཿ སམཡེ ཡཐཱ ཡུཥྨཱཀཾ ཤྲདྡྷཱ ཛཱཡཏེ ཏདརྠམ྄ ཨཧཾ ཏསྱཱ གྷཊནཱཡཱཿ པཱུཪྻྭམ྄ ཨིདཱནཱིཾ ཡུཥྨཱན྄ ཨེཏཱཾ ཝཱརྟྟཱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ཨིཏཿ པརཾ ཡུཥྨཱབྷིཿ སཧ མམ བཧཝ ཨཱལཱཔཱ ན བྷཝིཥྱནྟི ཡཏཿ ཀཱརཎཱད྄ ཨེཏསྱ ཛགཏཿ པཏིརཱགཙྪཏི ཀིནྟུ མཡཱ སཧ ཏསྱ ཀོཔི སམྦནྡྷོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ཨཧཾ པིཏརི པྲེམ ཀརོམི ཏཐཱ པིཏུ ཪྻིདྷིཝཏ྄ ཀརྨྨཱཎི ཀརོམཱིཏི ཡེན ཛགཏོ ལོཀཱ ཛཱནནྟི ཏདརྠམ྄ ཨུཏྟིཥྛཏ ཝཡཾ སྠཱནཱདསྨཱད྄ གཙྪཱམ། ");
INSERT INTO santib_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ཨཧཾ སཏྱདྲཱཀྵཱལཏཱསྭརཱུཔོ མམ པིཏཱ ཏཱུདྱཱནཔརིཙཱརཀསྭརཱུཔཉྩ། ");
INSERT INTO santib_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","མམ ཡཱསུ ཤཱཁཱསུ ཕལཱནི ན བྷཝནྟི ཏཱཿ ས ཚིནཏྟི ཏཐཱ ཕལཝཏྱཿ ཤཱཁཱ ཡཐཱདྷིཀཕལཱནི ཕལནྟི ཏདརྠཾ ཏཱཿ པརིཥྐརོཏི། ");
INSERT INTO santib_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ཨིདཱནཱིཾ མཡོཀྟོཔདེཤེན ཡཱུཡཾ པརིཥྐྲྀཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ཨཏཿ ཀཱརཎཱཏ྄ མཡི ཏིཥྛཏ ཏེནཱཧམཔི ཡུཥྨཱསུ ཏིཥྛཱམི, ཡཏོ ཧེཏོ རྡྲཱཀྵཱལཏཱཡཱམ྄ ཨསཾལགྣཱ ཤཱཁཱ ཡཐཱ ཕལཝཏཱི བྷཝིཏུཾ ན ཤཀྣོཏི ཏཐཱ ཡཱུཡམཔི མཡྻཏིཥྛནྟཿ ཕལཝནྟོ བྷཝིཏུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ཨཧཾ དྲཱཀྵཱལཏཱསྭརཱུཔོ ཡཱུཡཉྩ ཤཱཁཱསྭརཱུཔོཿ; ཡོ ཛནོ མཡི ཏིཥྛཏི ཡཏྲ ཙཱཧཾ ཏིཥྛཱམི, ས པྲཙཱུརཕལཻཿ ཕལཝཱན྄ བྷཝཏི, ཀིནྟུ མཱཾ ཝིནཱ ཡཱུཡཾ ཀིམཔི ཀརྟྟུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ཡཿ ཀཤྩིན྄ མཡི ན ཏིཥྛཏི ས ཤུཥྐཤཱཁེཝ བཧི རྣིཀྵིཔྱཏེ ལོཀཱཤྩ ཏཱ ཨཱཧྲྀཏྱ ཝཧྣཽ ནིཀྵིཔྱ དཱཧཡནྟི། ");
INSERT INTO santib_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ཡདི ཡཱུཡཾ མཡི ཏིཥྛཐ མམ ཀཐཱ ཙ ཡུཥྨཱསུ ཏིཥྛཏི ཏརྷི ཡད྄ ཝཱཉྪིཏྭཱ ཡཱཙིཥྱདྷྭེ ཡུཥྨཱཀཾ ཏདེཝ སཕལཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ཡདི ཡཱུཡཾ པྲཙཱུརཕལཝནྟོ བྷཝཐ ཏརྷི ཏདྭཱརཱ མམ པིཏུ རྨཧིམཱ པྲཀཱཤིཥྱཏེ ཏཐཱ ཡཱུཡཾ མམ ཤིཥྱཱ ཨིཏི པརིཀྵཱཡིཥྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","པིཏཱ ཡཐཱ མཡི པྲཱིཏཝཱན྄ ཨཧམཔི ཡུཥྨཱསུ ཏཐཱ པྲཱིཏཝཱན྄ ཨཏོ ཧེཏོ ཪྻཱུཡཾ ནིརནྟརཾ མམ པྲེམཔཱཏྲཱཎི བྷཱུཏྭཱ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ཨཧཾ ཡཐཱ པིཏུརཱཛྙཱ གྲྀཧཱིཏྭཱ ཏསྱ པྲེམབྷཱཛནཾ ཏིཥྛཱམི ཏཐཻཝ ཡཱུཡམཔི ཡདི མམཱཛྙཱ གུཧླཱིཐ ཏརྷི མམ པྲེམབྷཱཛནཱནི སྠཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ཡུཥྨནྣིམིཏྟཾ མམ ཡ ཨཱཧླཱདཿ ས ཡཐཱ ཙིརཾ ཏིཥྛཏི ཡུཥྨཱཀམ྄ ཨཱནནྡཤྩ ཡཐཱ པཱུཪྻྱཏེ ཏདརྠཾ ཡུཥྨབྷྱམ྄ ཨེཏཱཿ ཀཐཱ ཨཏྲཀཐམ྄། ");
INSERT INTO santib_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ཨཧཾ ཡུཥྨཱསུ ཡཐཱ པྲཱིཡེ ཡཱུཡམཔི པརསྤརཾ ཏཐཱ པྲཱིཡདྷྭམ྄ ཨེཥཱ མམཱཛྙཱ། ");
INSERT INTO santib_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","མིཏྲཱཎཱཾ ཀཱརཎཱཏ྄ སྭཔྲཱཎདཱནཔཪྻྱནྟཾ ཡཏ྄ པྲེམ ཏསྨཱན྄ མཧཱཔྲེམ ཀསྱཱཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ཨཧཾ ཡདྱད྄ ཨཱདིཤཱམི ཏཏྟདེཝ ཡདི ཡཱུཡམ྄ ཨཱཙརཏ ཏརྷི ཡཱུཡམེཝ མམ མིཏྲཱཎི། ");
INSERT INTO santib_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ཨདྱཱརབྷྱ ཡུཥྨཱན྄ དཱསཱན྄ ན ཝདིཥྱཱམི ཡཏ྄ པྲབྷུ ཪྻཏ྄ ཀརོཏི དཱསསྟད྄ ན ཛཱནཱཏི; ཀིནྟུ པིཏུཿ སམཱིཔེ ཡདྱད྄ ཨཤྲྀཎཝཾ ཏཏ྄ སཪྻྭཾ ཡཱུཥྨཱན྄ ཨཛྙཱཔཡམ྄ ཏཏྐཱརཎཱད྄ ཡུཥྨཱན྄ མིཏྲཱཎི པྲོཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ཡཱུཡཾ མཱཾ རོཙིཏཝནྟ ཨིཏི ན, ཀིནྟྭཧམེཝ ཡུཥྨཱན྄ རོཙིཏཝཱན྄ ཡཱུཡཾ གཏྭཱ ཡཐཱ ཕལཱནྱུཏྤཱདཡཐ ཏཱནི ཕལཱནི ཙཱཀྵཡཱཎི བྷཝནྟི, ཏདརྠཾ ཡུཥྨཱན྄ ནྱཛུནཛཾ ཏསྨཱན྄ མམ ནཱམ པྲོཙྱ པིཏརཾ ཡཏ྄ ཀིཉྩིད྄ ཡཱཙིཥྱདྷྭེ ཏདེཝ ས ཡུཥྨབྷྱཾ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ཡཱུཡཾ པརསྤརཾ པྲཱིཡདྷྭམ྄ ཨཧམ྄ ཨིཏྱཱཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ཛགཏོ ལོཀཻ ཪྻུཥྨཱསུ ཨྲྀཏཱིཡིཏེཥུ ཏེ པཱུཪྻྭཾ མཱམེཝཱརྟྟཱིཡནྟ ཨིཏི ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ཡདི ཡཱུཡཾ ཛགཏོ ལོཀཱ ཨབྷཝིཥྱཏ ཏརྷི ཛགཏོ ལོཀཱ ཡུཥྨཱན྄ ཨཱཏྨཱིཡཱན྄ བུདྡྷྭཱཔྲེཥྱནྟ; ཀིནྟུ ཡཱུཡཾ ཛགཏོ ལོཀཱ ན བྷཝཐ, ཨཧཾ ཡུཥྨཱན྄ ཨསྨཱཛྫགཏོ྅རོཙཡམ྄ ཨེཏསྨཱཏ྄ ཀཱརཎཱཛྫགཏོ ལོཀཱ ཡུཥྨཱན྄ ཨྲྀཏཱིཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","དཱསཿ པྲབྷོ རྨཧཱན྄ ན བྷཝཏི མམཻཏཏ྄ པཱུཪྻྭཱིཡཾ ཝཱཀྱཾ སྨརཏ; ཏེ ཡདི མཱམེཝཱཏཱཌཡན྄ ཏརྷི ཡུཥྨཱནཔི ཏཱཌཡིཥྱནྟི, ཡདི མམ ཝཱཀྱཾ གྲྀཧླནྟི ཏརྷི ཡུཥྨཱཀམཔི ཝཱཀྱཾ གྲཧཱིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ཀིནྟུ ཏེ མམ ནཱམཀཱརཎཱད྄ ཡུཥྨཱན྄ པྲཏི ཏཱདྲྀཤཾ ཝྱཝཧརིཥྱནྟི ཡཏོ ཡོ མཱཾ པྲེརིཏཝཱན྄ ཏཾ ཏེ ན ཛཱནནྟི། ");
INSERT INTO santib_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ཏེཥཱཾ སནྣིདྷིམ྄ ཨཱགཏྱ ཡདྱཧཾ ནཱཀཐཡིཥྱཾ ཏརྷི ཏེཥཱཾ པཱཔཾ ནཱབྷཝིཥྱཏ྄ ཀིནྟྭདྷུནཱ ཏེཥཱཾ པཱཔམཱཙྪཱདཡིཏུམ྄ ཨུཔཱཡོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ཡོ ཛནོ མཱམ྄ ཨྲྀཏཱིཡཏེ ས མམ པིཏརམཔི ཨྲྀཏཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ཡཱདྲྀཤཱནི ཀརྨྨཱཎི ཀེནཱཔི ཀདཱཔི ནཱཀྲིཡནྟ ཏཱདྲྀཤཱནི ཀརྨྨཱཎི ཡདི ཏེཥཱཾ སཱཀྵཱད྄ ཨཧཾ ནཱཀརིཥྱཾ ཏརྷི ཏེཥཱཾ པཱཔཾ ནཱབྷཝིཥྱཏ྄ ཀིནྟྭདྷུནཱ ཏེ དྲྀཥྚྭཱཔི མཱཾ མམ པིཏརཉྩཱརྟྟཱིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ཏསྨཱཏ྄ ཏེ྅ཀཱརཎཾ མཱམ྄ ཨྲྀཏཱིཡནྟེ ཡདེཏད྄ ཝཙནཾ ཏེཥཱཾ ཤཱསྟྲེ ལིཁིཏམཱསྟེ ཏཏ྄ སཕལམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ཀིནྟུ པིཏུ རྣིརྒཏཾ ཡཾ སཧཱཡམརྠཱཏ྄ སཏྱམཡམ྄ ཨཱཏྨཱནཾ པིཏུཿ སམཱིཔཱད྄ ཡུཥྨཱཀཾ སམཱིཔེ པྲེཥཡིཥྱཱམི ས ཨཱགཏྱ མཡི པྲམཱཎཾ དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ཡཱུཡཾ པྲཐམམཱརབྷྱ མཡཱ སཱརྡྡྷཾ ཏིཥྛཐ ཏསྨཱདྡྷེཏོ ཪྻཱུཡམཔི པྲམཱཎཾ དཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ཡུཥྨཱཀཾ ཡཐཱ ཝཱདྷཱ ན ཛཱཡཏེ ཏདརྠཾ ཡུཥྨཱན྄ ཨེཏཱནི སཪྻྭཝཱཀྱཱནི ཝྱཱཧརཾ། ");
INSERT INTO santib_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ལོཀཱ ཡུཥྨཱན྄ བྷཛནགྲྀཧེབྷྱོ དཱུརཱིཀརིཥྱནྟི ཏཐཱ ཡསྨིན྄ སམཡེ ཡུཥྨཱན྄ ཧཏྭཱ ཨཱིཤྭརསྱ ཏུཥྚི ཛནཀཾ ཀརྨྨཱཀུརྨྨ ཨིཏི མཾསྱནྟེ ས སམཡ ཨཱགཙྪནྟི། ");
INSERT INTO santib_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ཏེ པིཏརཾ མཱཉྩ ན ཛཱནནྟི, ཏསྨཱད྄ ཡུཥྨཱན྄ པྲཏཱིདྲྀཤམ྄ ཨཱཙརིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ཨཏོ ཧེཏཱཿ སམཡེ སམུཔསྠིཏེ ཡཐཱ མམ ཀཐཱ ཡུཥྨཱཀཾ མནཿསུཿ སམུཔཏིཥྛཏི ཏདརྠཾ ཡུཥྨཱབྷྱམ྄ ཨེཏཱཾ ཀཐཱཾ ཀཐཡཱམི ཡུཥྨཱབྷིཿ སཱརྡྡྷམ྄ ཨཧཾ ཏིཥྛན྄ པྲཐམཾ ཏཱཾ ཡུཥྨབྷྱཾ ནཱཀཐཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","སཱམྤྲཏཾ སྭསྱ པྲེརཡིཏུཿ སམཱིཔཾ གཙྪཱམི ཏཐཱཔི ཏྭཾ ཀྐ གཙྪསི ཀཐཱམེཏཱཾ ཡུཥྨཱཀཾ ཀོཔི མཱཾ ན པྲྀཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ཀིནྟུ མཡོཀྟཱབྷིརཱབྷིཿ ཀཐཱབྷི ཪྻཱུཥྨཱཀམ྄ ཨནྟཿཀརཎཱནི དུཿཁེན པཱུརྞཱནྱབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ཏཐཱཔྱཧཾ ཡཐཱརྠཾ ཀཐཡཱམི མམ གམནཾ ཡུཥྨཱཀཾ ཧིཏཱརྠམེཝ, ཡཏོ ཧེཏོ རྒམནེ ན ཀྲྀཏེ སཧཱཡོ ཡུཥྨཱཀཾ སམཱིཔཾ ནཱགམིཥྱཏི ཀིནྟུ ཡདི གཙྪཱམི ཏརྷི ཡུཥྨཱཀཾ སམཱིཔེ ཏཾ པྲེཥཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ཏཏཿ ས ཨཱགཏྱ པཱཔཔུཎྱདཎྜེཥུ ཛགཏོ ལོཀཱནཱཾ པྲབོདྷཾ ཛནཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ཏེ མཡི ན ཝིཤྭསནྟི ཏསྨཱདྡྷེཏོཿ པཱཔཔྲབོདྷཾ ཛནཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ཡུཥྨཱཀམ྄ ཨདྲྀཤྱཿ སནྣཧཾ པིཏུཿ སམཱིཔཾ གཙྪཱམི ཏསྨཱད྄ པུཎྱེ པྲབོདྷཾ ཛནཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ཨེཏཛྫགཏོ྅དྷིཔཏི རྡཎྜཱཛྙཱཾ པྲཱཔྣོཏི ཏསྨཱད྄ དཎྜེ པྲབོདྷཾ ཛནཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ཡུཥྨབྷྱཾ ཀཐཡིཏུཾ མམཱནེཀཱཿ ཀཐཱ ཨཱསཏེ, ཏཱཿ ཀཐཱ ཨིདཱནཱིཾ ཡཱུཡཾ སོཌྷུཾ ན ཤཀྣུཐ; ");
INSERT INTO santib_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ཀིནྟུ སཏྱམཡ ཨཱཏྨཱ ཡདཱ སམཱགམིཥྱཏི ཏདཱ སཪྻྭཾ སཏྱཾ ཡུཥྨཱན྄ ནེཥྱཏི, ས སྭཏཿ ཀིམཔི ན ཝདིཥྱཏི ཀིནྟུ ཡཙྪྲོཥྱཏི ཏདེཝ ཀཐཡིཏྭཱ བྷཱཝིཀཱཪྻྱཾ ཡུཥྨཱན྄ ཛྙཱཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","མམ མཧིམཱནཾ པྲཀཱཤཡིཥྱཏི ཡཏོ མདཱིཡཱཾ ཀཐཱཾ གྲྀཧཱིཏྭཱ ཡུཥྨཱན྄ བོདྷཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","པིཏུ ཪྻདྱད྄ ཨཱསྟེ ཏཏ྄ སཪྻྭཾ མམ ཏསྨཱད྄ ཀཱརཎཱད྄ ཨཝཱདིཥཾ ས མདཱིཡཱཾ ཀཐཱཾ གྲྀཧཱིཏྭཱ ཡུཥྨཱན྄ བོདྷཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ཀིཡཏྐཱལཱཏ྄ པརཾ ཡཱུཡཾ མཱཾ དྲཥྚུཾ ན ལཔྶྱདྷྭེ ཀིནྟུ ཀིཡཏྐཱལཱཏ྄ པརཾ པུན རྡྲཥྚུཾ ལཔྶྱདྷྭེ ཡཏོཧཾ པིཏུཿ སམཱིཔཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ཏཏཿ ཤིཥྱཱཎཱཾ ཀིཡནྟོ ཛནཱཿ པརསྤརཾ ཝདིཏུམ྄ ཨཱརབྷནྟ, ཀིཡཏྐཱལཱཏ྄ པརཾ མཱཾ དྲཥྚུཾ ན ལཔྶྱདྷྭེ ཀིནྟུ ཀིཡཏྐཱལཱཏ྄ པརཾ པུན རྡྲཥྚུཾ ལཔྶྱདྷྭེ ཡཏོཧཾ པིཏུཿ སམཱིཔཾ གཙྪཱམི, ཨིཏི ཡད྄ ཝཱཀྱམ྄ ཨཡཾ ཝདཏི ཏཏ྄ ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ཏཏཿ ཀིཡཏྐཱལཱཏ྄ པརམ྄ ཨིཏི ཏསྱ ཝཱཀྱཾ ཀིཾ? ཏསྱ ཝཱཀྱསྱཱབྷིཔྲཱཡཾ ཝཡཾ བོདྡྷུཾ ན ཤཀྣུམསྟཻརིཏི ");
INSERT INTO santib_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ནིགདིཏེ ཡཱིཤུསྟེཥཱཾ པྲཤྣེཙྪཱཾ ཛྙཱཏྭཱ ཏེབྷྱོ྅ཀཐཡཏ྄ ཀིཡཏྐཱལཱཏ྄ པརཾ མཱཾ དྲཥྚུཾ ན ལཔྶྱདྷྭེ, ཀིནྟུ ཀིཡཏྐཱལཱཏ྄ པརཾ པཱུན རྡྲཥྚུཾ ལཔྶྱདྷྭེ, ཡཱམིམཱཾ ཀཐཱམཀཐཡཾ ཏསྱཱ ཨབྷིཔྲཱཡཾ ཀིཾ ཡཱུཡཾ པརསྤརཾ མྲྀགཡདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ཡུཥྨཱནཧམ྄ ཨཏིཡཐཱརྠཾ ཝདཱམི ཡཱུཡཾ ཀྲནྡིཥྱཐ ཝིལཔིཥྱཐ ཙ, ཀིནྟུ ཛགཏོ ལོཀཱ ཨཱནནྡིཥྱནྟི; ཡཱུཡཾ ཤོཀཱཀུལཱ བྷཝིཥྱཐ ཀིནྟུ ཤོཀཱཏ྄ པརཾ ཨཱནནྡཡུཀྟཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","པྲསཝཀཱལ ཨུཔསྠིཏེ ནཱརཱི ཡཐཱ པྲསཝཝེདནཡཱ ཝྱཱཀུལཱ བྷཝཏི ཀིནྟུ པུཏྲེ བྷཱུམིཥྛེ སཏི མནུཥྱཻཀོ ཛནྨནཱ ནརལོཀེ པྲཝིཥྚ ཨིཏྱཱནནྡཱཏ྄ ཏསྱཱསྟཏྶཪྻྭཾ དུཿཁཾ མནསི ན ཏིཥྛཏི, ");
INSERT INTO santib_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ཏཐཱ ཡཱུཡམཔི སཱམྤྲཏཾ ཤོཀཱཀུལཱ བྷཝཐ ཀིནྟུ པུནརཔི ཡུཥྨབྷྱཾ དརྴནཾ དཱསྱཱམི ཏེན ཡུཥྨཱཀམ྄ ཨནྟཿཀརཎཱནི སཱནནྡཱནི བྷཝིཥྱནྟི, ཡུཥྨཱཀཾ ཏམ྄ ཨཱནནྡཉྩ ཀོཔི ཧརྟྟུཾ ན ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ཏསྨིན྄ དིཝསེ ཀཱམཔི ཀཐཱཾ མཱཾ ན པྲཀྵྱཐ། ཡུཥྨཱནཧམ྄ ཨཏིཡཐཱརྠཾ ཝདཱམི, མམ ནཱམྣཱ ཡཏ྄ ཀིཉྩིད྄ པིཏརཾ ཡཱཙིཥྱདྷྭེ ཏདེཝ ས དཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","པཱུཪྻྭེ མམ ནཱམྣཱ ཀིམཔི ནཱཡཱཙདྷྭཾ, ཡཱཙདྷྭཾ ཏཏཿ པྲཱཔྶྱཐ ཏསྨཱད྄ ཡུཥྨཱཀཾ སམྤཱུརྞཱནནྡོ ཛནིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ཨུཔམཱཀཐཱབྷིཿ སཪྻྭཱཎྱེཏཱནི ཡུཥྨཱན྄ ཛྙཱཔིཏཝཱན྄ ཀིནྟུ ཡསྨིན྄ སམཡེ ཨུཔམཡཱ ནོཀྟྭཱ པིཏུཿ ཀཐཱཾ སྤཥྚཾ ཛྙཱཔཡིཥྱཱམི སམཡ ཨེཏཱདྲྀཤ ཨཱགཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ཏདཱ མམ ནཱམྣཱ པྲཱརྠཡིཥྱདྷྭེ ྅ཧཾ ཡུཥྨནྣིམིཏྟཾ པིཏརཾ ཝིནེཥྱེ ཀཐཱམིམཱཾ ན ཝདཱམི; ");
INSERT INTO santib_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ཡཏོ ཡཱུཡཾ མཡི པྲེམ ཀུརུཐ, ཏཐཱཧམ྄ ཨཱིཤྭརསྱ སམཱིཔཱད྄ ཨཱགཏཝཱན྄ ཨིཏྱཔི པྲཏཱིཐ, ཏསྨཱད྄ ཀཱརཎཱཏ྄ ཀཱརཎཱཏ྄ པིཏཱ སྭཡཾ ཡུཥྨཱསུ པྲཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","པིཏུཿ སམཱིཔཱཛྫཛད྄ ཨཱགཏོསྨི ཛགཏ྄ པརིཏྱཛྱ ཙ པུནརཔི པིཏུཿ སམཱིཔཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ཏདཱ ཤིཥྱཱ ཨཝདན྄, ཧེ པྲབྷོ བྷཝཱན྄ ཨུཔམཡཱ ནོཀྟྭཱདྷུནཱ སྤཥྚཾ ཝདཏི། ");
INSERT INTO santib_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","བྷཝཱན྄ སཪྻྭཛྙཿ ཀེནཙིཏ྄ པྲྀཥྚོ བྷཝིཏུམཔི བྷཝཏཿ པྲཡོཛནཾ ནཱསྟཱིཏྱདྷུནཱསྨཱཀཾ སྠིརཛྙཱནཾ ཛཱཏཾ ཏསྨཱད྄ བྷཝཱན྄ ཨཱིཤྭརསྱ སམཱིཔཱད྄ ཨཱགཏཝཱན྄ ཨིཏྱཏྲ ཝཡཾ ཝིཤྭསིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ཏཏོ ཡཱིཤུཿ པྲཏྱཝཱདཱིད྄ ཨིདཱནཱིཾ ཀིཾ ཡཱུཡཾ ཝིཤྭསིཐ? ");
INSERT INTO santib_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","པཤྱཏ སཪྻྭེ ཡཱུཡཾ ཝིཀཱིརྞཱཿ སནྟོ མཱམ྄ ཨེཀཱཀིནཾ པཱིརཏྱཛྱ སྭཾ སྭཾ སྠཱནཾ གམིཥྱཐ, ཨེཏཱདྲྀཤཿ སམཡ ཨཱགཙྪཏི ཝརཾ པྲཱཡེཎོཔསྠིཏཝཱན྄; ཏཐཱཔྱཧཾ ནཻཀཱཀཱི བྷཝཱམི ཡཏཿ པིཏཱ མཡཱ སཱརྡྡྷམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ཡཐཱ མཡཱ ཡུཥྨཱཀཾ ཤཱནྟི རྫཱཡཏེ ཏདརྠམ྄ ཨེཏཱཿ ཀཐཱ ཡུཥྨབྷྱམ྄ ཨཙཀཐཾ; ཨསྨིན྄ ཛགཏི ཡུཥྨཱཀཾ ཀླེཤོ གྷཊིཥྱཏེ ཀིནྟྭཀྵོབྷཱ བྷཝཏ ཡཏོ མཡཱ ཛགཛྫིཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ཏཏཿ པརཾ ཡཱིཤུརེཏཱཿ ཀཐཱཿ ཀཐཡིཏྭཱ སྭརྒཾ ཝིལོཀྱཻཏཏ྄ པྲཱརྠཡཏ྄, ཧེ པིཏཿ སམཡ ཨུཔསྠིཏཝཱན྄; ཡཐཱ ཏཝ པུཏྲསྟཝ མཧིམཱནཾ པྲཀཱཤཡཏི ཏདརྠཾ ཏྭཾ ནིཛཔུཏྲསྱ མཧིམཱནཾ པྲཀཱཤཡ། ");
INSERT INTO santib_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ཏྭཾ ཡོལློཀཱན྄ ཏསྱ ཧསྟེ སམརྤིཏཝཱན྄ ས ཡཐཱ ཏེབྷྱོ྅ནནྟཱཡུ རྡདཱཏི ཏདརྠཾ ཏྭཾ པྲཱཎིམཱཏྲཱཎཱམ྄ ཨདྷིཔཏིཏྭབྷཱརཾ ཏསྨཻ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ཡསྟྭམ྄ ཨདྭིཏཱིཡཿ སཏྱ ཨཱིཤྭརསྟྭཡཱ པྲེརིཏཤྩ ཡཱིཤུཿ ཁྲཱིཥྚ ཨེཏཡོརུབྷཡོཿ པརིཙཡེ པྲཱཔྟེ྅ནནྟཱཡུ རྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ཏྭཾ ཡསྱ ཀརྨྨཎོ བྷཱརཾ མཧྱཾ དཏྟཝཱན྄, ཏཏ྄ སམྤནྣཾ ཀྲྀཏྭཱ ཛགཏྱསྨིན྄ ཏཝ མཧིམཱནཾ པྲཱཀཱཤཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ཨཏཨེཝ ཧེ པིཏ རྫགཏྱཝིདྱམཱནེ ཏྭཡཱ སཧ ཏིཥྛཏོ མམ ཡོ མཧིམཱསཱིཏ྄ སམྤྲཏི ཏཝ སམཱིཔེ མཱཾ ཏཾ མཧིམཱནཾ པྲཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ཨནྱཙྩ ཏྭམ྄ ཨེཏཛྫགཏོ ཡཱལློཀཱན྄ མཧྱམ྄ ཨདདཱ ཨཧཾ ཏེབྷྱསྟཝ ནཱམྣསྟཏྟྭཛྙཱནམ྄ ཨདདཱཾ, ཏེ ཏཝཻཝཱསན྄, ཏྭཾ ཏཱན྄ མཧྱམདདཱཿ, ཏསྨཱཏྟེ ཏཝོཔདེཤམ྄ ཨགྲྀཧླན྄། ");
INSERT INTO santib_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ཏྭཾ མཧྱཾ ཡཏ྄ ཀིཉྩིད྄ ཨདདཱསྟཏྶཪྻྭཾ ཏྭཏྟོ ཛཱཡཏེ ཨིཏྱདྷུནཱཛཱནན྄། ");
INSERT INTO santib_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","མཧྱཾ ཡམུཔདེཤམ྄ ཨདདཱ ཨཧམཔི ཏེབྷྱསྟམུཔདེཤམ྄ ཨདདཱཾ ཏེཔི ཏམགྲྀཧླན྄ ཏྭཏྟོཧཾ ནིརྒཏྱ ཏྭཡཱ པྲེརིཏོབྷཝམ྄ ཨཏྲ ཙ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ཏེཥཱམེཝ ནིམིཏྟཾ པྲཱརྠཡེ྅ཧཾ ཛགཏོ ལོཀནིམིཏྟཾ ན པྲཱརྠཡེ ཀིནྟུ ཡཱལློཀཱན྄ མཧྱམ྄ ཨདདཱསྟེཥཱམེཝ ནིམིཏྟཾ པྲཱརྠཡེ྅ཧཾ ཡཏསྟེ ཏཝཻཝཱསཏེ། ");
INSERT INTO santib_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ཡེ མམ ཏེ ཏཝ ཡེ ཙ ཏཝ ཏེ མམ ཏཐཱ ཏཻ རྨམ མཧིམཱ པྲཀཱཤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","སཱམྤྲཏམ྄ ཨསྨིན྄ ཛགཏི མམཱཝསྠིཏེཿ ཤེཥམ྄ ཨབྷཝཏ྄ ཨཧཾ ཏཝ སམཱིཔཾ གཙྪཱམི ཀིནྟུ ཏེ ཛགཏི སྠཱསྱནྟི; ཧེ པཝིཏྲ པིཏརཱཝཡོ ཪྻཐཻཀཏྭམཱསྟེ ཏཐཱ ཏེཥཱམཔྱེཀཏྭཾ བྷཝཏི ཏདརྠཾ ཡཱལློཀཱན྄ མཧྱམ྄ ཨདདཱསྟཱན྄ སྭནཱམྣཱ རཀྵ། ");
INSERT INTO santib_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ཡཱཝནྟི དིནཱནི ཛགཏྱསྨིན྄ ཏཻཿ སཧཱཧམཱསཾ ཏཱཝནྟི དིནཱནི ཏཱན྄ ཏཝ ནཱམྣཱཧཾ རཀྵིཏཝཱན྄; ཡཱལློཀཱན྄ མཧྱམ྄ ཨདདཱསྟཱན྄ སཪྻྭཱན྄ ཨཧམརཀྵཾ, ཏེཥཱཾ མདྷྱེ ཀེཝལཾ ཝིནཱཤཔཱཏྲཾ ཧཱརིཏཾ ཏེན དྷརྨྨཔུསྟཀསྱ ཝཙནཾ པྲཏྱཀྵཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ཀིནྟྭདྷུནཱ ཏཝ སནྣིདྷིཾ གཙྪཱམི མཡཱ ཡཐཱ ཏེཥཱཾ སམྤཱུརྞཱནནྡོ བྷཝཏི ཏདརྠམཧཾ ཛགཏི ཏིཥྛན྄ ཨེཏཱཿ ཀཐཱ ཨཀཐཡམ྄། ");
INSERT INTO santib_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ཏཝོཔདེཤཾ ཏེབྷྱོ྅དདཱཾ ཛགཏཱ སཧ ཡཐཱ མམ སམྦནྡྷོ ནཱསྟི ཏཐཱ ཛཛཏཱ སཧ ཏེཥཱམཔི སམྦནྡྷཱབྷཱཝཱཛ྄ ཛགཏོ ལོཀཱསྟཱན྄ ཨྲྀཏཱིཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ཏྭཾ ཛགཏསྟཱན྄ གྲྀཧཱཎེཏི ན པྲཱརྠཡེ ཀིནྟྭཤུབྷཱད྄ རཀྵེཏི པྲཱརྠཡེཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ཨཧཾ ཡཐཱ ཛགཏྶམྦནྡྷཱིཡོ ན བྷཝཱམི ཏཐཱ ཏེཔི ཛགཏྶམྦནྡྷཱིཡཱ ན བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ཏཝ སཏྱཀཐཡཱ ཏཱན྄ པཝིཏྲཱིཀུརུ ཏཝ ཝཱཀྱམེཝ སཏྱཾ། ");
INSERT INTO santib_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ཏྭཾ ཡཐཱ མཱཾ ཛགཏི པྲཻརཡསྟཐཱཧམཔི ཏཱན྄ ཛགཏི པྲཻརཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ཏེཥཱཾ ཧིཏཱརྠཾ ཡཐཱཧཾ སྭཾ པཝིཏྲཱིཀརོམི ཏཐཱ སཏྱཀཐཡཱ ཏེཔི པཝིཏྲཱིབྷཝནྟུ། ");
INSERT INTO santib_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ཀེཝལཾ ཨེཏེཥཱམརྠེ པྲཱརྠཡེ྅ཧམ྄ ཨིཏི ན ཀིནྟྭེཏེཥཱམུཔདེཤེན ཡེ ཛནཱ མཡི ཝིཤྭསིཥྱནྟི ཏེཥཱམཔྱརྠེ པྲཱརྠེཡེ྅ཧམ྄། ");
INSERT INTO santib_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ཧེ པིཏསྟེཥཱཾ སཪྻྭེཥཱམ྄ ཨེཀཏྭཾ བྷཝཏུ ཏཝ ཡཐཱ མཡི མམ ཙ ཡཐཱ ཏྭཡྻེཀཏྭཾ ཏཐཱ ཏེཥཱམཔྱཱཝཡོརེཀཏྭཾ བྷཝཏུ ཏེན ཏྭཾ མཱཾ པྲེརིཏཝཱན྄ ཨིཏི ཛགཏོ ལོཀཱཿ པྲཏིཡནྟུ། ");
INSERT INTO santib_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ཡཐཱཝཡོརེཀཏྭཾ ཏཐཱ ཏེཥཱམཔྱེཀཏྭཾ བྷཝཏུ ཏེཥྭཧཾ མཡི ཙ ཏྭམ྄ ཨིཏྠཾ ཏེཥཱཾ སམྤཱུརྞམེཀཏྭཾ བྷཝཏུ, ཏྭཾ པྲེརིཏཝཱན྄ ཏྭཾ མཡི ཡཐཱ པྲཱིཡསེ ཙ ཏཐཱ ཏེཥྭཔི པྲཱིཏཝཱན྄ ཨེཏདྱཐཱ ཛགཏོ ལོཀཱ ཛཱནནྟི ");
INSERT INTO santib_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ཏདརྠཾ ཏྭཾ ཡཾ མཧིམཱནཾ མཧྱམ྄ ཨདདཱསྟཾ མཧིམཱནམ྄ ཨཧམཔི ཏེབྷྱོ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ཧེ པིཏ རྫགཏོ ནིརྨྨཱཎཱཏ྄ པཱུཪྻྭཾ མཡི སྣེཧཾ ཀྲྀཏྭཱ ཡཾ མཧིམཱནཾ དཏྟཝཱན྄ མམ ཏཾ མཧིམཱནཾ ཡཐཱ ཏེ པཤྱནྟི ཏདརྠཾ ཡཱལློཀཱན྄ མཧྱཾ དཏྟཝཱན྄ ཨཧཾ ཡཏྲ ཏིཥྛཱམི ཏེཔི ཡཐཱ ཏཏྲ ཏིཥྛནྟི མམཻཥཱ ཝཱཉྪཱ། ");
INSERT INTO santib_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ཧེ ཡཐཱརྠིཀ པིཏ རྫགཏོ ལོཀཻསྟྭཡྻཛྙཱཏེཔི ཏྭཱམཧཾ ཛཱནེ ཏྭཾ མཱཾ པྲེརིཏཝཱན྄ ཨིཏཱིམེ ཤིཥྱཱ ཛཱནནྟི། ");
INSERT INTO santib_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ཡཐཱཧཾ ཏེཥུ ཏིཥྛཱམི ཏཐཱ མཡི ཡེན པྲེམྣཱ པྲེམཱཀརོསྟཏ྄ ཏེཥུ ཏིཥྛཏི ཏདརྠཾ ཏཝ ནཱམཱཧཾ ཏཱན྄ ཛྙཱཔིཏཝཱན྄ པུནརཔི ཛྙཱཔཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ཏཱཿ ཀཐཱཿ ཀཐཡིཏྭཱ ཡཱིཤུཿ ཤིཥྱཱནཱདཱཡ ཀིདྲོནྣཱམཀཾ སྲོཏ ཨུཏྟཱིཪྻྱ ཤིཥྱཻཿ སཧ ཏཏྲཏྱོདྱཱནཾ པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ཀིནྟུ ཝིཤྭཱསགྷཱཏིཡིཧཱུདཱསྟཏ྄ སྠཱནཾ པརིཙཱིཡཏེ ཡཏོ ཡཱིཤུཿ ཤིཥྱཻཿ སཱརྡྡྷཾ ཀདཱཙིཏ྄ ཏཏ྄ སྠཱནམ྄ ཨགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ཏདཱ ས ཡིཧཱུདཱཿ སཻནྱགཎཾ པྲདྷཱནཡཱཛཀཱནཱཾ ཕིརཱུཤིནཱཉྩ པདཱཏིགཎཉྩ གྲྀཧཱིཏྭཱ པྲདཱིཔཱན྄ ཨུལྐཱན྄ ཨསྟྲཱཎི ཙཱདཱཡ ཏསྨིན྄ སྠཱན ཨུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","སྭཾ པྲཏི ཡད྄ གྷཊིཥྱཏེ ཏཛ྄ ཛྙཱཏྭཱ ཡཱིཤུརགྲེསརཿ སན྄ ཏཱནཔྲྀཙྪཏ྄ ཀཾ གཝེཥཡཐ? ");
INSERT INTO santib_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ཏེ པྲཏྱཝདན྄, ནཱསརཏཱིཡཾ ཡཱིཤུཾ; ཏཏོ ཡཱིཤུརཝཱདཱིད྄ ཨཧམེཝ སཿ; ཏཻཿ སཧ ཝིཤྭཱསགྷཱཏཱི ཡིཧཱུདཱཤྩཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ཏདཱཧམེཝ ས ཏསྱཻཏཱཾ ཀཐཱཾ ཤྲུཏྭཻཝ ཏེ པཤྩཱདེཏྱ བྷཱུམཽ པཏིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ཏཏོ ཡཱིཤུཿ པུནརཔི པྲྀཥྛཝཱན྄ ཀཾ གཝེཥཡཐ? ཏཏསྟེ པྲཏྱཝདན྄ ནཱསརཏཱིཡཾ ཡཱིཤུཾ། ");
INSERT INTO santib_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ཏདཱ ཡཱིཤུཿ པྲཏྱུདིཏཝཱན྄ ཨཧམེཝ ས ཨིམཱཾ ཀཐཱམཙཀཐམ྄; ཡདི མཱམནྭིཙྪཐ ཏརྷཱིམཱན྄ གནྟུཾ མཱ ཝཱརཡཏ། ");
INSERT INTO santib_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ཨིཏྠཾ བྷཱུཏེ མཧྱཾ ཡཱལློཀཱན྄ ཨདདཱསྟེཥཱམ྄ ཨེཀམཔི ནཱཧཱརཡམ྄ ཨིམཱཾ ཡཱཾ ཀཐཱཾ ས སྭཡམཀཐཡཏ྄ སཱ ཀཐཱ སཕལཱ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ཏདཱ ཤིམོནྤིཏརསྱ ནིཀཊེ ཁངྒལྶྠིཏེཿ ས ཏཾ ནིཥྐོཥཾ ཀྲྀཏྭཱ མཧཱཡཱཛཀསྱ མཱལྑནཱམཱནཾ དཱསམ྄ ཨཱཧཏྱ ཏསྱ དཀྵིཎཀརྞཾ ཚིནྣཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ཏཏོ ཡཱིཤུཿ པིཏརམ྄ ཨཝདཏ྄, ཁངྒཾ ཀོཥེ སྠཱཔཡ མམ པིཏཱ མཧྱཾ པཱཏུཾ ཡཾ ཀཾསམ྄ ཨདདཱཏ྄ ཏེནཱཧཾ ཀིཾ ན པཱསྱཱམི? ");
INSERT INTO santib_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ཏདཱ སཻནྱགཎཿ སེནཱཔཏི ཪྻིཧཱུདཱིཡཱནཱཾ པདཱཏཡཤྩ ཡཱིཤུཾ གྷྲྀཏྭཱ བདྡྷྭཱ ཧཱནནྣཱམྣཿ ཀིཡཕཱཿ ཤྭཤུརསྱ སམཱིཔཾ པྲཐམམ྄ ཨནཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ས ཀིཡཕཱསྟསྨིན྄ ཝཏྶརེ མཧཱཡཱཛཏྭཔདེ ནིཡུཀྟཿ ");
INSERT INTO santib_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","སན྄ སཱདྷཱརཎལོཀཱནཱཾ མངྒལཱརྠམ྄ ཨེཀཛནསྱ མརཎམུཙིཏམ྄ ཨིཏི ཡིཧཱུདཱིཡཻཿ སཱརྡྡྷམ྄ ཨམནྟྲཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ཏདཱ ཤིམོནྤིཏརོ྅ནྱཻཀཤིཥྱཤྩ ཡཱིཤོཿ པཤྩཱད྄ ཨགཙྪཏཱཾ ཏསྱཱནྱཤིཥྱསྱ མཧཱཡཱཛཀེན པརིཙིཏཏྭཱཏ྄ ས ཡཱིཤུནཱ སཧ མཧཱཡཱཛཀསྱཱཊྚཱལིཀཱཾ པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ཀིནྟུ པིཏརོ བཧིརྡྭཱརསྱ སམཱིཔེ྅ཏིཥྛད྄ ཨཏཨེཝ མཧཱཡཱཛཀེན པརིཙིཏཿ ས ཤིཥྱཿ པུནརྦཧིརྒཏྭཱ དཽཝཱཡིཀཱཡཻ ཀཐཡིཏྭཱ པིཏརམ྄ ཨབྷྱནྟརམ྄ ཨཱནཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ཏདཱ ས དྭཱརརཀྵིཀཱ པིཏརམ྄ ཨཝདཏ྄ ཏྭཾ ཀིཾ ན ཏསྱ མཱནཝསྱ ཤིཥྱཿ? ཏཏཿ སོཝདད྄ ཨཧཾ ན བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ཏཏཿ པརཾ ཡཏྶྠཱནེ དཱསཱཿ པདཱཏཡཤྩ ཤཱིཏཧེཏོརངྒཱརཻ ཪྻཧྣིཾ པྲཛྭཱལྱ ཏཱཔཾ སེཝིཏཝནྟསྟཏྶྠཱནེ པིཏརསྟིཥྛན྄ ཏཻཿ སཧ ཝཧྣིཏཱཔཾ སེཝིཏུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ཏདཱ ཤིཥྱེཥཱུཔདེཤེ ཙ མཧཱཡཱཛཀེན ཡཱིཤུཿ པྲྀཥྚཿ ");
INSERT INTO santib_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","སན྄ པྲཏྱུཀྟཝཱན྄ སཪྻྭལོཀཱནཱཾ སམཀྵཾ ཀཐཱམཀཐཡཾ གུཔྟཾ ཀཱམཔི ཀཐཱཾ ན ཀཐཡིཏྭཱ ཡཏ྄ སྠཱནཾ ཡིཧཱུདཱིཡཱཿ སཏཏཾ གཙྪནྟི ཏཏྲ བྷཛནགེཧེ མནྡིརེ ཙཱཤིཀྵཡཾ། ");
INSERT INTO santib_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","མཏྟཿ ཀུཏཿ པྲྀཙྪསི? ཡེ ཛནཱ མདུཔདེཤམ྄ ཨཤྲྀཎྭན྄ ཏཱནེཝ པྲྀཙྪ ཡདྱད྄ ཨཝདཾ ཏེ ཏཏ྄ ཛཱནིནྟ། ");
INSERT INTO santib_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ཏདེཏྠཾ པྲཏྱུདིཏཏྭཱཏ྄ ནིཀཊསྠཔདཱཏི ཪྻཱིཤུཾ ཙཔེཊེནཱཧཏྱ ཝྱཱཧརཏ྄ མཧཱཡཱཛཀམ྄ ཨེཝཾ པྲཏིཝདསི? ");
INSERT INTO santib_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ཏཏོ ཡཱིཤུཿ པྲཏིགདིཏཝཱན྄ ཡདྱཡཐཱརྠམ྄ ཨཙཀཐཾ ཏརྷི ཏསྱཱཡཐཱརྠསྱ པྲམཱཎཾ དེཧི, ཀིནྟུ ཡདི ཡཐཱརྠཾ ཏརྷི ཀུཏོ ཧེཏོ རྨཱམ྄ ཨཏཱཌཡཿ? ");
INSERT INTO santib_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","པཱུཪྻྭཾ ཧཱནན྄ སབནྡྷནཾ ཏཾ ཀིཡཕཱམཧཱཡཱཛཀསྱ སམཱིཔཾ པྲཻཥཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ཤིམོནྤིཏརསྟིཥྛན྄ ཝཧྣིཏཱཔཾ སེཝཏེ, ཨེཏསྨིན྄ སམཡེ ཀིཡནྟསྟམ྄ ཨཔྲྀཙྪན྄ ཏྭཾ ཀིམ྄ ཨེཏསྱ ཛནསྱ ཤིཥྱོ ན? ཏཏཿ སོཔཧྣུཏྱཱབྲཝཱིད྄ ཨཧཾ ན བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ཏདཱ མཧཱཡཱཛཀསྱ ཡསྱ དཱསསྱ པིཏརཿ ཀརྞམཙྪིནཏ྄ ཏསྱ ཀུཊུམྦཿ པྲཏྱུདིཏཝཱན྄ ཨུདྱཱནེ ཏེན སཧ ཏིཥྛནྟཾ ཏྭཱཾ ཀིཾ ནཱཔཤྱཾ? ");
INSERT INTO santib_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ཀིནྟུ པིཏརཿ པུནརཔཧྣུཏྱ ཀཐིཏཝཱན྄; ཏདཱནཱིཾ ཀུཀྐུཊོ྅རཽཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ཏདནནྟརཾ པྲཏྱཱུཥེ ཏེ ཀིཡཕཱགྲྀཧཱད྄ ཨདྷིཔཏེ རྒྲྀཧཾ ཡཱིཤུམ྄ ཨནཡན྄ ཀིནྟུ ཡསྨིན྄ ཨཤུཙིཏྭེ ཛཱཏེ ཏཻ རྣིསྟཱརོཏྶཝེ ན བྷོཀྟཝྱཾ, ཏསྱ བྷཡཱད྄ ཡིཧཱུདཱིཡཱསྟདྒྲྀཧཾ ནཱཝིཤན྄། ");
INSERT INTO santib_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ཨཔརཾ པཱིལཱཏོ བཧིརཱགཏྱ ཏཱན྄ པྲྀཥྛཝཱན྄ ཨེཏསྱ མནུཥྱསྱ ཀཾ དོཥཾ ཝདཐ? ");
INSERT INTO santib_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ཏདཱ ཏེ པེཏྱཝདན྄ དུཥྐརྨྨཀཱརིཎི ན སཏི བྷཝཏཿ སམཱིཔེ ནཻནཾ སམཱརྤཡིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ཏཏཿ པཱིལཱཏོ྅ཝདད྄ ཡཱུཡམེནཾ གྲྀཧཱིཏྭཱ སྭེཥཱཾ ཝྱཝསྠཡཱ ཝིཙཱརཡཏ། ཏདཱ ཡིཧཱུདཱིཡཱཿ པྲཏྱཝདན྄ ཀསྱཱཔི མནུཥྱསྱ པྲཱཎདཎྜཾ ཀརྟྟུཾ ནཱསྨཱཀམ྄ ཨདྷིཀཱརོ྅སྟི། ");
INSERT INTO santib_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ཨེཝཾ སཏི ཡཱིཤུཿ སྭསྱ མྲྀཏྱཽ ཡཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄ སཱ སཕལཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ཏདནནྟརཾ པཱིལཱཏཿ པུནརཔི ཏད྄ རཱཛགྲྀཧཾ གཏྭཱ ཡཱིཤུམཱཧཱུཡ པྲྀཥྚཝཱན྄ ཏྭཾ ཀིཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ? ");
INSERT INTO santib_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ཡཱིཤུཿ པྲཏྱཝདཏ྄ ཏྭམ྄ ཨེཏཱཾ ཀཐཱཾ སྭཏཿ ཀཐཡསི ཀིམནྱཿ ཀཤྩིན྄ མཡི ཀཐིཏཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","པཱིལཱཏོ྅ཝདད྄ ཨཧཾ ཀིཾ ཡིཧཱུདཱིཡཿ? ཏཝ སྭདེཤཱིཡཱ ཝིཤེཥཏཿ པྲདྷཱནཡཱཛཀཱ མམ ནིཀཊེ ཏྭཱཾ སམཱརྤཡན, ཏྭཾ ཀིཾ ཀྲྀཏཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ཡཱིཤུཿ པྲཏྱཝདཏ྄ མམ རཱཛྱམ྄ ཨེཏཛྫགཏྶམྦནྡྷཱིཡཾ ན བྷཝཏི ཡདི མམ རཱཛྱཾ ཛགཏྶམྦནྡྷཱིཡམ྄ ཨབྷཝིཥྱཏ྄ ཏརྷི ཡིཧཱུདཱིཡཱནཱཾ ཧསྟེཥུ ཡཐཱ སམརྤིཏོ ནཱབྷཝཾ ཏདརྠཾ མམ སེཝཀཱ ཨཡོཏྶྱན྄ ཀིནྟུ མམ རཱཛྱམ྄ ཨཻཧིཀཾ ན། ");
INSERT INTO santib_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ཏདཱ པཱིལཱཏཿ ཀཐིཏཝཱན྄, ཏརྷི ཏྭཾ རཱཛཱ བྷཝསི? ཡཱིཤུཿ པྲཏྱུཀྟཝཱན྄ ཏྭཾ སཏྱཾ ཀཐཡསི, རཱཛཱཧཾ བྷཝཱམི; སཏྱཏཱཡཱཾ སཱཀྵྱཾ དཱཏུཾ ཛནིཾ གྲྀཧཱིཏྭཱ ཛགཏྱསྨིན྄ ཨཝཏཱིརྞཝཱན྄, ཏསྨཱཏ྄ སཏྱདྷརྨྨཔཀྵཔཱཏིནོ མམ ཀཐཱཾ ཤྲྀཎྭནྟི། ");
INSERT INTO santib_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ཏདཱ སཏྱཾ ཀིཾ? ཨེཏཱཾ ཀཐཱཾ པཥྚྭཱ པཱིལཱཏཿ པུནརཔི བཧིརྒཏྭཱ ཡིཧཱུདཱིཡཱན྄ ཨབྷཱཥཏ, ཨཧཾ ཏསྱ ཀམཔྱཔརཱདྷཾ ན པྲཱཔྣོམི། ");
INSERT INTO santib_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ནིསྟཱརོཏྶཝསམཡེ ཡུཥྨཱབྷིརབྷིརུཙིཏ ཨེཀོ ཛནོ མཡཱ མོཙཡིཏཝྱ ཨེཥཱ ཡུཥྨཱཀཾ རཱིཏིརསྟི, ཨཏཨེཝ ཡུཥྨཱཀཾ ནིཀཊེ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱནཾ ཀིཾ མོཙཡཱམི, ཡུཥྨཱཀམ྄ ཨིཙྪཱ ཀཱ? ");
INSERT INTO santib_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ཏདཱ ཏེ སཪྻྭེ རུཝནྟོ ཝྱཱཧརན྄ ཨེནཾ མཱནུཥཾ ནཧི བརབྦཱཾ མོཙཡ། ཀིནྟུ ས བརབྦཱ དསྱུརཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","པཱིལཱཏོ ཡཱིཤུམ྄ ཨཱནཱིཡ ཀཤཡཱ པྲཱཧཱརཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","པཤྩཱཏ྄ སེནཱགཎཿ ཀཎྚཀནིརྨྨིཏཾ མུཀུཊཾ ཏསྱ མསྟཀེ སམརྤྱ ཝཱརྟྟཱཀཱིཝརྞཾ རཱཛཔརིཙྪདཾ པརིདྷཱཔྱ, ");
INSERT INTO santib_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ཧེ ཡིཧཱུདཱིཡཱནཱཾ རཱཛན྄ ནམསྐཱར ཨིཏྱུཀྟྭཱ ཏཾ ཙཔེཊེནཱཧནྟུམ྄ ཨཱརབྷཏ། ");
INSERT INTO santib_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ཏདཱ པཱིལཱཏཿ པུནརཔི བཧིརྒཏྭཱ ལོཀཱན྄ ཨཝདཏ྄, ཨསྱ ཀམཔྱཔརཱདྷཾ ན ལབྷེ྅ཧཾ, པཤྱཏ ཏད྄ ཡུཥྨཱན྄ ཛྙཱཔཡིཏུཾ ཡུཥྨཱཀཾ སནྣིདྷཽ བཧིརེནམ྄ ཨཱནཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ཏཏཿ པརཾ ཡཱིཤུཿ ཀཎྚཀམུཀུཊཝཱན྄ ཝཱརྟྟཱཀཱིཝརྞཝསནཝཱཾཤྩ བཧིརཱགཙྪཏ྄། ཏཏཿ པཱིལཱཏ ཨུཀྟཝཱན྄ ཨེནཾ མནུཥྱཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ཏདཱ པྲདྷཱནཡཱཛཀཱཿ པདཱཏཡཤྩ ཏཾ དྲྀཥྚྭཱ, ཨེནཾ ཀྲུཤེ ཝིདྷ, ཨེནཾ ཀྲུཤེ ཝིདྷ, ཨིཏྱུཀྟྭཱ རཝིཏུཾ ཨཱརབྷནྟ། ཏཏཿ པཱིལཱཏཿ ཀཐིཏཝཱན྄ ཡཱུཡཾ སྭཡམ྄ ཨེནཾ ནཱིཏྭཱ ཀྲུཤེ ཝིདྷཏ, ཨཧམ྄ ཨེཏསྱ ཀམཔྱཔརཱདྷཾ ན པྲཱཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ཡིཧཱུདཱིཡཱཿ པྲཏྱཝདན྄ ཨསྨཱཀཾ ཡཱ ཝྱཝསྠཱསྟེ ཏདནུསཱརེཎཱསྱ པྲཱཎཧནནམ྄ ཨུཙིཏཾ ཡཏོཡཾ སྭམ྄ ཨཱིཤྭརསྱ པུཏྲམཝདཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","པཱིལཱཏ ཨིམཱཾ ཀཐཱཾ ཤྲུཏྭཱ མཧཱཏྲཱསཡུཀྟཿ ");
INSERT INTO santib_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","སན྄ པུནརཔི རཱཛགྲྀཧ ཨཱགཏྱ ཡཱིཤུཾ པྲྀཥྚཝཱན྄ ཏྭཾ ཀུཏྲཏྱོ ལོཀཿ? ཀིནྟུ ཡཱིཤསྟསྱ ཀིམཔི པྲཏྱུཏྟརཾ ནཱཝདཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","༡॰ ཏཏཿ པཱིལཱཏ྄ ཀཐིཏཝཱན ཏྭཾ ཀིཾ མཡཱ སཱརྡྡྷཾ ན སཾལཔིཥྱསི ? ཏྭཱཾ ཀྲུཤེ ཝེདྷིཏུཾ ཝཱ མོཙཡིཏུཾ ཤཀྟི རྨམཱསྟེ ཨིཏི ཀིཾ ཏྭཾ ན ཛཱནཱསི ? ཏདཱ ཡཱིཤུཿ པྲཏྱཝདད྄ ཨཱིཤྭརེཎཱདŸाཾ མམོཔརི ཏཝ ཀིམཔྱདྷིཔཏིཏྭཾ ན ཝིདྱཏེ, ཏཐཱཔི ཡོ ཛནོ མཱཾ ཏཝ ཧསྟེ སམཱརྤཡཏ྄ ཏསྱ མཧཱཔཱཏཀཾ ཛཱཏམ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ཏདཱ ཡཱིཤུཿ པྲཏྱཝདད྄ ཨཱིཤྭརེཎཱདཏྟཾ མམོཔརི ཏཝ ཀིམཔྱདྷིཔཏིཏྭཾ ན ཝིདྱཏེ, ཏཐཱཔི ཡོ ཛནོ མཱཾ ཏཝ ཧསྟེ སམཱརྤཡཏ྄ ཏསྱ མཧཱཔཱཏཀཾ ཛཱཏམ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ཏདཱརབྷྱ པཱིལཱཏསྟཾ མོཙཡིཏུཾ ཙེཥྚིཏཝཱན྄ ཀིནྟུ ཡིཧཱུདཱིཡཱ རུཝནྟོ ཝྱཱཧརན྄ ཡདཱིམཾ མཱནཝཾ ཏྱཛསི ཏརྷི ཏྭཾ ཀཻསརསྱ མིཏྲཾ ན བྷཝསི, ཡོ ཛནཿ སྭཾ རཱཛཱནཾ ཝཀྟི སཨེཝ ཀཻམརསྱ ཝིརུདྡྷཱཾ ཀཐཱཾ ཀཐཡཏི། ");
INSERT INTO santib_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ པཱིལཱཏོ ཡཱིཤུཾ བཧིརཱནཱིཡ ནིསྟཱརོཏྶཝསྱ ཨཱསཱདནདིནསྱ དྭིཏཱིཡཔྲཧརཱཏ྄ པཱུཪྻྭཾ པྲསྟརབནྡྷནནཱམྣི སྠཱནེ ྅རྠཱཏ྄ ཨིབྲཱིཡབྷཱཥཡཱ ཡད྄ གབྦིཐཱ ཀཐྱཏེ ཏསྨིན྄ སྠཱནེ ཝིཙཱརཱསན ཨུཔཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ཨནནྟརཾ པཱིལཱཏོ ཡིཧཱུདཱིཡཱན྄ ཨཝདཏ྄, ཡུཥྨཱཀཾ རཱཛཱནཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ཀིནྟུ ཨེནཾ དཱུརཱིཀུརུ, ཨེནཾ དཱུརཱིཀུརུ, ཨེནཾ ཀྲུཤེ ཝིདྷ, ཨིཏི ཀཐཱཾ ཀཐཡིཏྭཱ ཏེ རཝིཏུམ྄ ཨཱརབྷནྟ; ཏདཱ པཱིལཱཏཿ ཀཐིཏཝཱན྄ ཡུཥྨཱཀཾ རཱཛཱནཾ ཀིཾ ཀྲུཤེ ཝེདྷིཥྱཱམི? པྲདྷཱནཡཱཛཀཱ ཨུཏྟརམ྄ ཨཝདན྄ ཀཻསརཾ ཝིནཱ ཀོཔི རཱཛཱསྨཱཀཾ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ཏཏཿ པཱིལཱཏོ ཡཱིཤུཾ ཀྲུཤེ ཝེདྷིཏུཾ ཏེཥཱཾ ཧསྟེཥུ སམཱརྤཡཏ྄, ཏཏསྟེ ཏཾ དྷྲྀཏྭཱ ནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ཏཏཿ པརཾ ཡཱིཤུཿ ཀྲུཤཾ ཝཧན྄ ཤིརཿཀཔཱལམ྄ ཨརྠཱད྄ ཡད྄ ཨིབྲཱིཡབྷཱཥཡཱ གུལྒལྟཱཾ ཝདནྟི ཏསྨིན྄ སྠཱན ཨུཔསྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ཏཏསྟེ མདྷྱསྠཱནེ ཏཾ ཏསྱོབྷཡཔཱརྴྭེ དྭཱཝཔརཽ ཀྲུཤེ྅ཝིདྷན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ཨཔརམ྄ ཨེཥ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱ ནཱསརཏཱིཡཡཱིཤུཿ, ཨིཏི ཝིཛྙཱཔནཾ ལིཁིཏྭཱ པཱིལཱཏསྟསྱ ཀྲུཤོཔརི སམཡོཛཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","སཱ ལིཔིཿ ཨིབྲཱིཡཡཱུནཱནཱིཡརོམཱིཡབྷཱཥཱབྷི རླིཁིཏཱ; ཡཱིཤོཿ ཀྲུཤཝེདྷནསྠཱནཾ ནགརསྱ སམཱིཔཾ, ཏསྨཱད྄ བཧཝོ ཡིཧཱུདཱིཡཱསྟཱཾ པཋིཏུམ྄ ཨཱརབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ཡིཧཱུདཱིཡཱནཱཾ པྲདྷཱནཡཱཛཀཱཿ པཱིལཱཏམིཏི ནྱཝེདཡན྄ ཡིཧཱུདཱིཡཱནཱཾ རཱཛེཏི ཝཱཀྱཾ ན ཀིནྟུ ཨེཥ སྭཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛཱནམ྄ ཨཝདད྄ ཨིཏྠཾ ལིཁཏུ། ");
INSERT INTO santib_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ཏཏཿ པཱིལཱཏ ཨུཏྟརཾ དཏྟཝཱན྄ ཡལླེཁནཱིཡཾ ཏལླིཁིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ཨིཏྠཾ སེནཱགཎོ ཡཱིཤུཾ ཀྲུཤེ ཝིདྷིཏྭཱ ཏསྱ པརིདྷེཡཝསྟྲཾ ཙཏུརོ བྷཱགཱན྄ ཀྲྀཏྭཱ ཨེཀཻཀསེནཱ ཨེཀཻཀབྷཱགམ྄ ཨགྲྀཧླཏ྄ ཏསྱོཏྟརཱིཡཝསྟྲཉྩཱགྲྀཧླཏ྄། ཀིནྟཱུཏྟརཱིཡཝསྟྲཾ སཱུཙིསེཝནཾ ཝིནཱ སཪྻྭམ྄ ཨཱུཏཾ། ");
INSERT INTO santib_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ཏསྨཱཏྟེ ཝྱཱཧརན྄ ཨེཏཏ྄ ཀཿ པྲཱཔྶྱཏི? ཏནྣ ཁཎྜཡིཏྭཱ ཏཏྲ གུཊིཀཱཔཱཏཾ ཀརཝཱམ། ཝིབྷཛནྟེ྅དྷརཱིཡཾ མེ ཝསནཾ ཏེ པརསྤརཾ། མམོཏྟརཱིཡཝསྟྲཱརྠཾ གུཊིཀཱཾ པཱཏཡནྟི ཙ། ཨིཏི ཡདྭཱཀྱཾ དྷརྨྨཔུསྟཀེ ལིཁིཏམཱསྟེ ཏཏ྄ སེནཱགཎེནེཏྠཾ ཝྱཝཧརཎཱཏ྄ སིདྡྷམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ཏདཱནཱིཾ ཡཱིཤོ རྨཱཏཱ མཱཏུ རྦྷགིནཱི ཙ ཡཱ ཀླིཡཔཱ བྷཱཪྻྱཱ མརིཡམ྄ མགྡལཱིནཱི མརིཡམ྄ ཙ ཨེཏཱསྟསྱ ཀྲུཤསྱ སནྣིདྷཽ སམཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ཏཏོ ཡཱིཤུཿ སྭམཱཏརཾ པྲིཡཏམཤིཥྱཉྩ སམཱིཔེ དཎྜཱཡམཱནཽ ཝིལོཀྱ མཱཏརམ྄ ཨཝདཏ྄, ཧེ ཡོཥིད྄ ཨེནཾ ཏཝ པུཏྲཾ པཤྱ, ");
INSERT INTO santib_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ཤིཥྱནྟྭཝདཏ྄, ཨེནཱཾ ཏཝ མཱཏརཾ པཤྱ། ཏཏཿ ས ཤིཥྱསྟདྒྷཊིཀཱཡཱཾ ཏཱཾ ནིཛགྲྀཧཾ ནཱིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ཨནནྟརཾ སཪྻྭཾ ཀརྨྨཱདྷུནཱ སམྤནྣམབྷཱུཏ྄ ཡཱིཤུརིཏི ཛྙཱཏྭཱ དྷརྨྨཔུསྟཀསྱ ཝཙནཾ ཡཐཱ སིདྡྷཾ བྷཝཏི ཏདརྠམ྄ ཨཀཐཡཏ྄ མམ པིཔཱསཱ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ཏཏསྟསྨིན྄ སྠཱནེ ཨམླརསེན པཱུརྞཔཱཏྲསྠིཏྱཱ ཏེ སྤཉྫམེཀཾ ཏདམླརསེནཱརྡྲཱིཀྲྀཏྱ ཨེསོབྣལེ ཏད྄ ཡོཛཡིཏྭཱ ཏསྱ མུཁསྱ སནྣིདྷཱཝསྠཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ཏདཱ ཡཱིཤུརམླརསཾ གྲྀཧཱིཏྭཱ སཪྻྭཾ སིདྡྷམ྄ ཨིཏི ཀཐཱཾ ཀཐཡིཏྭཱ མསྟཀཾ ནམཡན྄ པྲཱཎཱན྄ པཪྻྱཏྱཛཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ཏདྭིནམ྄ ཨཱསཱདནདིནཾ ཏསྨཱཏ྄ པརེ྅ཧནི ཝིཤྲཱམཝཱརེ དེཧཱ ཡཐཱ ཀྲུཤོཔརི ན ཏིཥྛནྟི, ཡཏཿ ས ཝིཤྲཱམཝཱརོ མཧཱདིནམཱསཱིཏ྄, ཏསྨཱད྄ ཡིཧཱུདཱིཡཱཿ པཱིལཱཏནིཀཊཾ གཏྭཱ ཏེཥཱཾ པཱདབྷཉྫནསྱ སྠཱནཱནྟརནཡནསྱ ཙཱནུམཏིཾ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ཨཏཿ སེནཱ ཨཱགཏྱ ཡཱིཤུནཱ སཧ ཀྲུཤེ ཧཏཡོཿ པྲཐམདྭིཏཱིཡཙོརཡོཿ པཱདཱན྄ ཨབྷཉྫན྄; ");
INSERT INTO santib_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ཀིནྟུ ཡཱིཤོཿ སནྣིདྷིཾ གཏྭཱ ས མྲྀཏ ཨིཏི དྲྀཥྚྭཱ ཏསྱ པཱདཽ ནཱབྷཉྫན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","པཤྩཱད྄ ཨེཀོ ཡོདྡྷཱ ཤཱུལཱགྷཱཏེན ཏསྱ ཀུཀྵིམ྄ ཨཝིདྷཏ྄ ཏཏྐྵཎཱཏ྄ ཏསྨཱད྄ རཀྟཾ ཛལཉྩ ནིརགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ཡོ ཛནོ྅སྱ སཱཀྵྱཾ དདཱཏི ས སྭཡཾ དྲྀཥྚཝཱན྄ ཏསྱེདཾ སཱཀྵྱཾ སཏྱཾ ཏསྱ ཀཐཱ ཡུཥྨཱཀཾ ཝིཤྭཱསཾ ཛནཡིཏུཾ ཡོགྱཱ ཏཏ྄ ས ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ཏསྱཻཀམ྄ ཨསྡྷྱཔི ན བྷཾཀྵྱཏེ, ");
INSERT INTO santib_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ཏདྭད྄ ཨནྱཤཱསྟྲེཔི ལིཁྱཏེ, ཡཐཱ, \"དྲྀཥྚིཔཱཏཾ ཀརིཥྱནྟི ཏེ྅ཝིདྷན྄ ཡནྟུ ཏམྤྲཏི། \" ");
INSERT INTO santib_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ཨརིམཐཱིཡནགརསྱ ཡཱུཥཕྣཱམཱ ཤིཥྱ ཨེཀ ཨཱསཱིཏ྄ ཀིནྟུ ཡིཧཱུདཱིཡེབྷྱོ བྷཡཱཏ྄ པྲཀཱཤིཏོ ན བྷཝཏི; ས ཡཱིཤོ རྡེཧཾ ནེཏུཾ པཱིལཱཏསྱཱནུམཏིཾ པྲཱརྠཡཏ, ཏཏཿ པཱིལཱཏེནཱནུམཏེ སཏི ས གཏྭཱ ཡཱིཤོ རྡེཧམ྄ ཨནཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ཨཔརཾ ཡོ ནིཀདཱིམོ རཱཏྲཽ ཡཱིཤོཿ སམཱིཔམ྄ ཨགཙྪཏ྄ སོཔི གནྡྷརསེན མིཤྲིཏཾ པྲཱཡེཎ པཉྩཱཤཏྶེཊཀམགུརུཾ གྲྀཧཱིཏྭཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ཏཏསྟེ ཡིཧཱུདཱིཡཱནཱཾ ཤྨཤཱནེ སྠཱཔནརཱིཏྱནུསཱརེཎ ཏཏྶུགནྡྷིདྲཝྱེཎ སཧིཏཾ ཏསྱ དེཧཾ ཝསྟྲེཎཱཝེཥྚཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ཨཔརཉྩ ཡཏྲ སྠཱནེ ཏཾ ཀྲུཤེ྅ཝིདྷན྄ ཏསྱ ནིཀཊསྠོདྱཱནེ ཡཏྲ ཀིམཔི མྲྀཏདེཧཾ ཀདཱཔི ནཱསྠཱཔྱཏ ཏཱདྲྀཤམ྄ ཨེཀཾ ནཱུཏནཾ ཤྨཤཱནམ྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ཡིཧཱུདཱིཡཱནཱམ྄ ཨཱསཱདནདིནཱགམནཱཏ྄ ཏེ ཏསྨིན྄ སམཱིཔསྠཤྨཤཱནེ ཡཱིཤུམ྄ ཨཤཱཡཡན྄། ");
INSERT INTO santib_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ཨནནྟརཾ སཔྟཱཧསྱ པྲཐམདིནེ ྅ཏིཔྲཏྱཱུཥེ ྅ནྡྷཀཱརེ ཏིཥྛཏི མགྡལཱིནཱི མརིཡམ྄ ཏསྱ ཤྨཤཱནསྱ ནིཀཊཾ གཏྭཱ ཤྨཤཱནསྱ མུཁཱཏ྄ པྲསྟརམཔསཱརིཏམ྄ ཨཔཤྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","པཤྩཱད྄ དྷཱཝིཏྭཱ ཤིམོནྤིཏརཱཡ ཡཱིཤོཿ པྲིཡཏམཤིཥྱཱཡ ཙེདམ྄ ཨཀཐཡཏ྄, ལོཀཱཿ ཤྨཤཱནཱཏ྄ པྲབྷུཾ ནཱིཏྭཱ ཀུཏྲཱསྠཱཔཡན྄ ཏད྄ ཝཀྟུཾ ན ཤཀྣོམི། ");
INSERT INTO santib_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ཨཏཿ པིཏརཿ སོནྱཤིཥྱཤྩ བརྷི རྦྷུཏྭཱ ཤྨཤཱནསྠཱནཾ གནྟུམ྄ ཨཱརབྷེཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ཨུབྷཡོརྡྷཱཝཏོཿ སོནྱཤིཥྱཿ པིཏརཾ པཤྩཱཏ྄ ཏྱཀྟྭཱ པཱུཪྻྭཾ ཤྨཤཱནསྠཱན ཨུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ཏདཱ པྲཧྭཱིབྷཱུཡ སྠཱཔིཏཝསྟྲཱཎི དྲྀཥྚཝཱན྄ ཀིནྟུ ན པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ཨཔརཾ ཤིམོནྤིཏར ཨཱགཏྱ ཤྨཤཱནསྠཱནཾ པྲཝིཤྱ ");
INSERT INTO santib_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","སྠཱཔིཏཝསྟྲཱཎི མསྟཀསྱ ཝསྟྲཉྩ པྲྀཐཀ྄ སྠཱནཱནྟརེ སྠཱཔིཏཾ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ཏཏཿ ཤྨཤཱནསྠཱནཾ པཱུཪྻྭམ྄ ཨཱགཏོ ཡོནྱཤིཥྱཿ སོཔི པྲཝིཤྱ ཏཱདྲྀཤཾ དྲྀཥྚཱ ཝྱཤྭསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ཡཏཿ ཤྨཤཱནཱཏ྄ ས ཨུཏྠཱཔཡིཏཝྱ ཨེཏསྱ དྷརྨྨཔུསྟཀཝཙནསྱ བྷཱཝཾ ཏེ ཏདཱ ཝོདྡྷུཾ ནཱཤནྐུཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ཨནནྟརཾ ཏཽ དྭཽ ཤིཥྱཽ སྭཾ སྭཾ གྲྀཧཾ པརཱཝྲྀཏྱཱགཙྪཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ཏཏཿ པརཾ མརིཡམ྄ ཤྨཤཱནདྭཱརསྱ བཧིཿ སྠིཏྭཱ རོདིཏུམ྄ ཨཱརབྷཏ ཏཏོ རུདཏཱི པྲཧྭཱིབྷཱུཡ ཤྨཤཱནཾ ཝིལོཀྱ ");
INSERT INTO santib_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ཡཱིཤོཿ ཤཡནསྠཱནསྱ ཤིརཿསྠཱནེ པདཏལེ ཙ དྭཡོ རྡིཤོ དྭཽ སྭརྒཱིཡདཱུཏཱཝུཔཝིཥྚཽ སམཔཤྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ཏཽ པྲྀཥྚཝནྟཽ ཧེ ནཱརི ཀུཏོ རོདིཥི? སཱཝདཏ྄ ལོཀཱ མམ པྲབྷུཾ ནཱིཏྭཱ ཀུཏྲཱསྠཱཔཡན྄ ཨིཏི ན ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ཨིཏྱུཀྟྭཱ མུཁཾ པརཱཝྲྀཏྱ ཡཱིཤུཾ དཎྜཱཡམཱནམ྄ ཨཔཤྱཏ྄ ཀིནྟུ ས ཡཱིཤུརིཏི སཱ ཛྙཱཏུཾ ནཱཤཀྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ཏདཱ ཡཱིཤུསྟཱམ྄ ཨཔྲྀཙྪཏ྄ ཧེ ནཱརི ཀུཏོ རོདིཥི? ཀཾ ཝཱ མྲྀགཡསེ? ཏཏཿ སཱ ཏམ྄ ཨུདྱཱནསེཝཀཾ ཛྙཱཏྭཱ ཝྱཱཧརཏ྄, ཧེ མཧེཙྪ ཏྭཾ ཡདཱིཏཿ སྠཱནཱཏ྄ ཏཾ ནཱིཏཝཱན྄ ཏརྷི ཀུཏྲཱསྠཱཔཡསྟད྄ ཝད ཏཏྶྠཱནཱཏ྄ ཏམ྄ ཨཱནཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ཏདཱ ཡཱིཤུསྟཱམ྄ ཨཝདཏ྄ ཧེ མརིཡམ྄། ཏཏཿ སཱ པརཱཝྲྀཏྱ པྲཏྱཝདཏ྄ ཧེ རབྦཱུནཱི ཨརྠཱཏ྄ ཧེ གུརོ། ");
INSERT INTO santib_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ཏདཱ ཡཱིཤུརཝདཏ྄ མཱཾ མཱ དྷར, ཨིདཱནཱིཾ པིཏུཿ སམཱིཔེ ཨཱུརྡྡྷྭགམནཾ ན ཀརོམི ཀིནྟུ ཡོ མམ ཡུཥྨཱཀཉྩ པིཏཱ མམ ཡུཥྨཱཀཉྩེཤྭརསྟསྱ ནིཀཊ ཨཱུརྡྡྷྭགམནཾ ཀརྟྟུམ྄ ཨུདྱཏོསྨི, ཨིམཱཾ ཀཐཱཾ ཏྭཾ གཏྭཱ མམ བྷྲཱཏྲྀགཎཾ ཛྙཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ཏཏོ མགྡལཱིནཱིམརིཡམ྄ ཏཏྐྵཎཱད྄ གཏྭཱ པྲབྷུསྟསྱཻ དརྴནཾ དཏྟྭཱ ཀཐཱ ཨེཏཱ ཨཀཐཡད྄ ཨིཏི ཝཱརྟྟཱཾ ཤིཥྱེབྷྱོ྅ཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ཏཏཿ པརཾ སཔྟཱཧསྱ པྲཐམདིནསྱ སནྡྷྱཱསམཡེ ཤིཥྱཱ ཨེཀཏྲ མིལིཏྭཱ ཡིཧཱུདཱིཡེབྷྱོ བྷིཡཱ དྭཱརརུདྡྷམ྄ ཨཀུཪྻྭན྄, ཨེཏསྨིན྄ ཀཱལེ ཡཱིཤུསྟེཥཱཾ མདྷྱསྠཱནེ ཏིཥྛན྄ ཨཀཐཡད྄ ཡུཥྨཱཀཾ ཀལྱཱཎཾ བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ཨིཏྱུཀྟྭཱ ནིཛཧསྟཾ ཀུཀྵིཉྩ དརྴིཏཝཱན྄, ཏཏཿ ཤིཥྱཱཿ པྲབྷུཾ དྲྀཥྚྭཱ ཧྲྀཥྚཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ཡཱིཤུཿ པུནརཝདད྄ ཡུཥྨཱཀཾ ཀལྱཱཎཾ བྷཱུཡཱཏ྄ པིཏཱ ཡཐཱ མཱཾ པྲཻཥཡཏ྄ ཏཐཱཧམཔི ཡུཥྨཱན྄ པྲེཥཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ཨིཏྱུཀྟྭཱ ས ཏེཥཱམུཔརི དཱིརྒྷཔྲཤྭཱསཾ དཏྟྭཱ ཀཐིཏཝཱན྄ པཝིཏྲམ྄ ཨཱཏྨཱནཾ གྲྀཧླཱིཏ། ");
INSERT INTO santib_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ཡཱུཡཾ ཡེཥཱཾ པཱཔཱནི མོཙཡིཥྱཐ ཏེ མོཙཡིཥྱནྟེ ཡེཥཱཉྩ པཱཔཱཏི ན མོཙཡིཥྱཐ ཏེ ན མོཙཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","དྭཱདཤམདྷྱེ གཎིཏོ ཡམཛོ ཐོམཱནཱམཱ ཤིཥྱོ ཡཱིཤོརཱགམནཀཱལཻ ཏཻཿ སཱརྡྡྷཾ ནཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ཨཏོ ཝཡཾ པྲབྷཱུམ྄ ཨཔཤྱཱམེཏི ཝཱཀྱེ྅ནྱཤིཥྱཻརུཀྟེ སོཝདཏ྄, ཏསྱ ཧསྟཡོ རླཽཧཀཱིལཀཱནཱཾ ཙིཧྣཾ ན ཝིལོཀྱ ཏཙྩིཧྣམ྄ ཨངྒུལྱཱ ན སྤྲྀཥྚྭཱ ཏསྱ ཀུཀྵཽ ཧསྟཾ ནཱརོཔྱ ཙཱཧཾ ན ཝིཤྭསིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ཨཔརམ྄ ཨཥྚམེ྅ཧྣི གཏེ སཏི ཐོམཱསཧིཏཿ ཤིཥྱགཎ ཨེཀཏྲ མིལིཏྭཱ དྭཱརཾ རུདྡྷྭཱབྷྱནྟར ཨཱསཱིཏ྄, ཨེཏརྷི ཡཱིཤུསྟེཥཱཾ མདྷྱསྠཱནེ ཏིཥྛན྄ ཨཀཐཡཏ྄, ཡུཥྨཱཀཾ ཀུཤལཾ བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","པཤྩཱཏ྄ ཐཱམཻ ཀཐིཏཝཱན྄ ཏྭམ྄ ཨངྒུལཱིམ྄ ཨཏྲཱརྤཡིཏྭཱ མམ ཀརཽ པཤྱ ཀརཾ པྲསཱཪྻྱ མམ ཀུཀྵཱཝརྤཡ ནཱཝིཤྭསྱ། ");
INSERT INTO santib_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ཏདཱ ཐོམཱ ཨཝདཏ྄, ཧེ མམ པྲབྷོ ཧེ མདཱིཤྭར། ");
INSERT INTO santib_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ཡཱིཤུརཀཐཡཏ྄, ཧེ ཐོམཱ མཱཾ ནིརཱིཀྵྱ ཝིཤྭསིཥི ཡེ ན དྲྀཥྚྭཱ ཝིཤྭསནྟི ཏཨེཝ དྷནྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ཨེཏདནྱཱནི པུསྟཀེ྅སྨིན྄ ཨལིཁིཏཱནི བཧཱུནྱཱཤྩཪྻྱཀརྨྨཱཎི ཡཱིཤུཿ ཤིཥྱཱཎཱཾ པུརསྟཱད྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ཀིནྟུ ཡཱིཤུརཱིཤྭརསྱཱབྷིཥིཀྟཿ སུཏ ཨེཝེཏི ཡཐཱ ཡཱུཡཾ ཝིཤྭསིཐ ཝིཤྭསྱ ཙ ཏསྱ ནཱམྣཱ པརམཱཡུཿ པྲཱཔྣུཐ ཏདརྠམ྄ ཨེཏཱནི སཪྻྭཱཎྱལིཁྱནྟ། ");
INSERT INTO santib_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ཏཏཿ པརཾ ཏིབིརིཡཱཛལདྷེསྟཊེ ཡཱིཤུཿ པུནརཔི ཤིཥྱེབྷྱོ དརྴནཾ དཏྟཝཱན྄ དརྴནསྱཱཁྱཱནམིདམ྄། ");
INSERT INTO santib_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ཤིམོནྤིཏརཿ ཡམཛཐོམཱ གཱལཱིལཱིཡཀཱནྣཱནགརནིཝཱསཱི ནིཐནེལ྄ སིཝདེཿ པུཏྲཱཝནྱཽ དྭཽ ཤིཥྱཽ ཙཻཏེཥྭེཀཏྲ མིལིཏེཥུ ཤིམོནྤིཏརོ྅ཀཐཡཏ྄ མཏྶྱཱན྄ དྷརྟུཾ ཡཱམི། ");
INSERT INTO santib_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ཏཏསྟེ ཝྱཱཧརན྄ ཏརྷི ཝཡམཔི ཏྭཡཱ སཱརྡྡྷཾ ཡཱམཿ ཏདཱ ཏེ བཧིརྒཏཱཿ སནྟཿ ཀྵིཔྲཾ ནཱཝམ྄ ཨཱརོཧན྄ ཀིནྟུ ཏསྱཱཾ རཛནྱཱམ྄ ཨེཀམཔི ན པྲཱཔྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","པྲབྷཱཏེ སཏི ཡཱིཤུསྟཊེ སྠིཏཝཱན྄ ཀིནྟུ ས ཡཱིཤུརིཏི ཤིཥྱཱ ཛྙཱཏུཾ ནཱཤཀྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ཏདཱ ཡཱིཤུརཔྲྀཙྪཏ྄, ཧེ ཝཏྶཱ སནྣིདྷཽ ཀིཉྩིཏ྄ ཁཱདྱདྲཝྱམ྄ ཨཱསྟེ? ཏེ྅ཝདན྄ ཀིམཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ཏདཱ སོ྅ཝདཏ྄ ནཽཀཱཡཱ དཀྵིཎཔཱརྴྭེ ཛཱལཾ ནིཀྵིཔཏ ཏཏོ ལཔྶྱདྷྭེ, ཏསྨཱཏ྄ ཏཻ རྣིཀྵིཔྟེ ཛཱལེ མཏྶྱཱ ཨེཏཱཝནྟོ྅པཏན྄ ཡེན ཏེ ཛཱལམཱཀྲྀཥྱ ནོཏྟོལཡིཏུཾ ཤཀྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ཏསྨཱད྄ ཡཱིཤོཿ པྲིཡཏམཤིཥྱཿ པིཏརཱཡཱཀཐཡཏ྄ ཨེཥ པྲབྷུ རྦྷཝེཏ྄, ཨེཥ པྲབྷུརིཏི ཝཱཙཾ ཤྲུཏྭཻཝ ཤིམོན྄ ནགྣཏཱཧེཏོ རྨཏྶྱདྷཱརིཎ ཨུཏྟརཱིཡཝསྟྲཾ པརིདྷཱཡ ཧྲདཾ པྲཏྱུདལམྥཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ཨཔརེ ཤིཥྱཱ མཏྶྱཻཿ སཱརྡྡྷཾ ཛཱལམ྄ ཨཱཀརྵནྟཿ ཀྵུདྲནཽཀཱཾ ཝཱཧཡིཏྭཱ ཀཱུལམཱནཡན྄ ཏེ ཀཱུལཱད྄ ཨཏིདཱུརེ ནཱསན྄ དྭིཤཏཧསྟེབྷྱོ དཱུར ཨཱསན྄ ཨིཏྱནུམཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ཏཱིརཾ པྲཱཔྟཻསྟཻསྟཏྲ པྲཛྭལིཏཱགྣིསྟདུཔརི མཏྶྱཱཿ པཱུཔཱཤྩ དྲྀཥྚཱཿ། ");
INSERT INTO santib_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ཏཏོ ཡཱིཤུརཀཐཡད྄ ཡཱན྄ མཏྶྱཱན྄ ཨདྷརཏ ཏེཥཱཾ ཀཏིཔཡཱན྄ ཨཱནཡཏ། ");
INSERT INTO santib_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ཨཏཿ ཤིམོནྤིཏརཿ པརཱཝྲྀཏྱ གཏྭཱ བྲྀཧདྦྷིསྟྲིཔཉྩཱཤདདྷིཀཤཏམཏྶྱཻཿ པརིཔཱུརྞཾ ཏཛྫཱལམ྄ ཨཱཀྲྀཥྱོདཏོལཡཏ྄ ཀིནྟྭེཏཱཝདྦྷི རྨཏྶྱཻརཔི ཛཱལཾ ནཱཚིདྱཏ། ");
INSERT INTO santib_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ཨནནྟརཾ ཡཱིཤུསྟཱན྄ ཨཝཱདཱིཏ྄ ཡཱུཡམཱགཏྱ བྷུཾགྡྷྭཾ; ཏདཱ སཨེཝ པྲབྷུརིཏི ཛྙཱཏཏྭཱཏ྄ ཏྭཾ ཀཿ? ཨིཏི པྲཥྚུཾ ཤིཥྱཱཎཱཾ ཀསྱཱཔི པྲགལྦྷཏཱ ནཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ཏཏོ ཡཱིཤུརཱགཏྱ པཱུཔཱན྄ མཏྶྱཱཾཤྩ གྲྀཧཱིཏྭཱ ཏེབྷྱཿ པཪྻྱཝེཥཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ཨིཏྠཾ ཤྨཤཱནཱདུཏྠཱནཱཏ྄ པརཾ ཡཱིཤུཿ ཤིཥྱེབྷྱསྟྲྀཏཱིཡཝཱརཾ དརྴནཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","བྷོཛནེ སམཱཔྟེ སཏི ཡཱིཤུཿ ཤིམོནྤིཏརཾ པྲྀཥྚཝཱན྄, ཧེ ཡཱུནསཿ པུཏྲ ཤིམོན྄ ཏྭཾ ཀིམ྄ ཨེཏེབྷྱོདྷིཀཾ མཡི པྲཱིཡསེ? ཏཏཿ ས ཨུདིཏཝཱན྄ སཏྱཾ པྲབྷོ ཏྭཡི པྲཱིཡེ྅ཧཾ ཏད྄ བྷཝཱན྄ ཛཱནཱཏི; ཏདཱ ཡཱིཤུརཀཐཡཏ྄ ཏརྷི མམ མེཥཤཱཝཀགཎཾ པཱལཡ། ");
INSERT INTO santib_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ཏཏཿ ས དྭིཏཱིཡཝཱརཾ པྲྀཥྚཝཱན྄ ཧེ ཡཱུནསཿ པུཏྲ ཤིམོན྄ ཏྭཾ ཀིཾ མཡི པྲཱིཡསེ? ཏཏཿ ས ཨུཀྟཝཱན྄ སཏྱཾ པྲབྷོ ཏྭཡི པྲཱིཡེ྅ཧཾ ཏད྄ བྷཝཱན྄ ཛཱནཱཏི; ཏདཱ ཡཱིཤུརཀཐཡཏ ཏརྷི མམ མེཥགཎཾ པཱལཡ། ");
INSERT INTO santib_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","པཤྩཱཏ྄ ས ཏྲྀཏཱིཡཝཱརཾ པྲྀཥྚཝཱན྄, ཧེ ཡཱུནསཿ པུཏྲ ཤིམོན྄ ཏྭཾ ཀིཾ མཡི པྲཱིཡསེ? ཨེཏདྭཱཀྱཾ ཏྲྀཏཱིཡཝཱརཾ པྲྀཥྚཝཱན྄ ཏསྨཱཏ྄ པིཏརོ དུཿཁིཏོ བྷཱུཏྭཱ྅ཀཐཡཏ྄ ཧེ པྲབྷོ བྷཝཏཿ ཀིམཔྱགོཙརཾ ནཱསྟི ཏྭཡྻཧཾ པྲཱིཡེ ཏད྄ བྷཝཱན྄ ཛཱནཱཏི; ཏཏོ ཡཱིཤུརཝདཏ྄ ཏརྷི མམ མེཥགཎཾ པཱལཡ། ");
INSERT INTO santib_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ཨཧཾ ཏུབྷྱཾ ཡཐཱརྠཾ ཀཐཡཱམི ཡཽཝནཀཱལེ སྭཡཾ བདྡྷཀཊི ཪྻཏྲེཙྪཱ ཏཏྲ ཡཱཏཝཱན྄ ཀིནྟྭིཏཿ པརཾ ཝྲྀདྡྷེ ཝཡསི ཧསྟཾ ཝིསྟཱརཡིཥྱསི, ཨནྱཛནསྟྭཱཾ བདྡྷྭཱ ཡཏྲ གནྟུཾ ཏཝེཙྪཱ ན བྷཝཏི ཏྭཱཾ དྷྲྀཏྭཱ ཏཏྲ ནེཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ཕལཏཿ ཀཱིདྲྀཤེན མརཎེན ས ཨཱིཤྭརསྱ མཧིམཱནཾ པྲཀཱཤཡིཥྱཏི ཏད྄ བོདྷཡིཏུཾ ས ཨིཏི ཝཱཀྱཾ པྲོཀྟཝཱན྄། ཨིཏྱུཀྟེ སཏི ས ཏམཝོཙཏ྄ མམ པཤྩཱད྄ ཨཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ཡོ ཛནོ རཱཏྲིཀཱལེ ཡཱིཤོ ཪྻཀྵོ྅ཝལམྦྱ, ཧེ པྲབྷོ ཀོ བྷཝནྟཾ པརཀརེཥུ སམརྤཡིཥྱཏཱིཏི ཝཱཀྱཾ པྲྀཥྚཝཱན྄, ཏཾ ཡཱིཤོཿ པྲིཡཏམཤིཥྱཾ པཤྩཱད྄ ཨཱགཙྪནྟཾ ");
INSERT INTO santib_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","པིཏརོ མུཁཾ པརཱཝརྟྟྱ ཝིལོཀྱ ཡཱིཤུཾ པྲྀཥྚཝཱན྄, ཧེ པྲབྷོ ཨེཏསྱ མཱནཝསྱ ཀཱིདྲྀཤཱི གཏི རྦྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ས པྲཏྱཝདཏ྄, མམ པུནརཱགམནཔཪྻྱནྟཾ ཡདི ཏཾ སྠཱཔཡིཏུམ྄ ཨིཙྪཱམི ཏཏྲ ཏཝ ཀིཾ? ཏྭཾ མམ པཤྩཱད྄ ཨཱགཙྪ། ");
INSERT INTO santib_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ཏསྨཱཏ྄ ས ཤིཥྱོ ན མརིཥྱཏཱིཏི བྷྲཱཏྲྀགཎམདྷྱེ ཀིཾཝདནྟཱི ཛཱཏཱ ཀིནྟུ ས ན མརིཥྱཏཱིཏི ཝཱཀྱཾ ཡཱིཤུ རྣཱཝདཏ྄ ཀེཝལཾ མམ པུནརཱགམནཔཪྻྱནྟཾ ཡདི ཏཾ སྠཱཔཡིཏུམ྄ ཨིཙྪཱམི ཏཏྲ ཏཝ ཀིཾ? ཨིཏི ཝཱཀྱམ྄ ཨུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ཡོ ཛན ཨེཏཱནི སཪྻྭཱཎི ལིཁིཏཝཱན྄ ཨཏྲ སཱཀྵྱཉྩ དཏྟཝཱན྄ སཨེཝ ས ཤིཥྱཿ, ཏསྱ སཱཀྵྱཾ པྲམཱཎམིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ཡཱིཤུརེཏེབྷྱོ྅པརཱཎྱཔི བཧཱུནི ཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཏཱནི སཪྻྭཱཎི ཡདྱེཀཻཀཾ ཀྲྀཏྭཱ ལིཁྱནྟེ ཏརྷི གྲནྠཱ ཨེཏཱཝནྟོ བྷཝནྟི ཏེཥཱཾ དྷཱརཎེ པྲྀཐིཝྱཱཾ སྠཱནཾ ན བྷཝཏི། ཨིཏི༎ ");
INSERT INTO santib_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ཧེ ཐིཡཕིལ, ཡཱིཤུཿ སྭམནོནཱིཏཱན྄ པྲེརིཏཱན྄ པཝིཏྲེཎཱཏྨནཱ སམཱདིཤྱ ཡསྨིན྄ དིནེ སྭརྒམཱརོཧཏ྄ ཡཱཾ ཡཱཾ ཀྲིཡཱམཀརོཏ྄ ཡདྱད྄ ཨུཔཱདིཤཙྩ ཏཱནི སཪྻྭཱཎི པཱུཪྻྭཾ མཡཱ ལིཁིཏཱནི། ");
INSERT INTO santib_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ས སྭནིདྷནདུཿཁབྷོགཱཏ྄ པརམ྄ ཨནེཀཔྲཏྱཡཀྵཔྲམཱཎཽཿ སྭཾ སཛཱིཝཾ དརྴཡིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ཙཏྭཱརིཾཤདྡིནཱནི ཡཱཝཏ྄ ཏེབྷྱཿ པྲེརིཏེབྷྱོ དརྴནཾ དཏྟྭེཤྭརཱིཡརཱཛྱསྱ ཝརྞནམ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ཨནནྟརཾ ཏེཥཱཾ སབྷཱཾ ཀྲྀཏྭཱ ཨིཏྱཱཛྙཱཔཡཏ྄, ཡཱུཡཾ ཡིརཱུཤཱལམོ྅ནྱཏྲ གམནམཀྲྀཏྭཱ ཡསྟིན྄ པིཏྲཱངྒཱིཀྲྀཏེ མམ ཝདནཱཏ྄ ཀཐཱ ཨཤྲྀཎུཏ ཏཏྤྲཱཔྟིམ྄ ཨཔེཀྵྱ ཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ཡོཧན྄ ཛལེ མཛྫིཏཱཝཱན྄ ཀིནྟྭལྤདིནམདྷྱེ ཡཱུཡཾ པཝིཏྲ ཨཱཏྨནི མཛྫིཏཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","པཤྩཱཏ྄ ཏེ སཪྻྭེ མིལིཏྭཱ ཏམ྄ ཨཔྲྀཙྪན྄ ཧེ པྲབྷོ བྷཝཱན྄ ཀིམིདཱནཱིཾ པུནརཔི རཱཛྱམ྄ ཨིསྲཱཡེལཱིཡལོཀཱནཱཾ ཀརེཥུ སམརྤཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ཏཏཿ སོཝདཏ྄ ཡཱན྄ སཪྻྭཱན྄ ཀཱལཱན྄ སམཡཱཾཤྩ པིཏཱ སྭཝཤེ྅སྠཱཔཡཏ྄ ཏཱན྄ ཛྙཱཏྲྀཾ ཡུཥྨཱཀམ྄ ཨདྷིཀཱརོ ན ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ཀིནྟུ ཡུཥྨཱསུ པཝིཏྲསྱཱཏྨན ཨཱཝིརྦྷཱཝེ སཏི ཡཱུཡཾ ཤཀྟིཾ པྲཱཔྱ ཡིརཱུཤཱལམི སམསྟཡིཧཱུདཱཤོམིརོཎདེཤཡོཿ པྲྀཐིཝྱཱཿ སཱིམཱཾ ཡཱཝད྄ ཡཱཝནྟོ དེཤཱསྟེཥུ ཡཪྻྭེཥུ ཙ མཡི སཱཀྵྱཾ དཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ཨིཏི ཝཱཀྱམུཀྟྭཱ ས ཏེཥཱཾ སམཀྵཾ སྭརྒཾ ནཱིཏོ྅བྷཝཏ྄, ཏཏོ མེགྷམཱརུཧྱ ཏེཥཱཾ དྲྀཥྚེརགོཙརོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ཡསྨིན྄ སམཡེ ཏེ ཝིཧཱཡསཾ པྲཏྱནནྱདྲྀཥྚྱཱ ཏསྱ ཏཱདྲྀཤམ྄ ཨཱུརྡྭྭགམནམ྄ ཨཔཤྱན྄ ཏསྨིནྣེཝ སམཡེ ཤུཀླཝསྟྲཽ དྭཽ ཛནཽ ཏེཥཱཾ སནྣིདྷཽ དཎྜཱཡམཱནཽ ཀཐིཏཝནྟཽ, ");
INSERT INTO santib_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ཧེ གཱལཱིལཱིཡལོཀཱ ཡཱུཡཾ ཀིམརྠཾ གགཎཾ པྲཏི ནིརཱིཀྵྱ དཎྜཱཡམཱནཱསྟིཥྛཐ? ཡུཥྨཱཀཾ སམཱིཔཱཏ྄ སྭརྒཾ ནཱིཏོ ཡོ ཡཱིཤུསྟཾ ཡཱུཡཾ ཡཐཱ སྭརྒམ྄ ཨཱརོཧནྟམ྄ ཨདརྴམ྄ ཏཐཱ ས པུནཤྩཱགམིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ཏཏཿ པརཾ ཏེ ཛཻཏུནནཱམྣཿ པཪྻྭཏཱད྄ ཝིཤྲཱམཝཱརསྱ པཐཿ པརིམཱཎམ྄ ཨརྠཱཏ྄ པྲཱཡེཎཱརྡྡྷཀྲོཤཾ དུརསྠཾ ཡིརཱུཤཱལམྣགརཾ པརཱཝྲྀཏྱཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ནགརཾ པྲཝིཤྱ པིཏརོ ཡཱཀཱུབ྄ ཡོཧན྄ ཨཱནྡྲིཡཿ ཕིལིཔཿ ཐོམཱ བརྠཛམཡོ མཐིརཱལྥཱིཡཔུཏྲོ ཡཱཀཱུབ྄ ཨུདྱོགཱी ཤིམོན྄ ཡཱཀཱུབོ བྷྲཱཏཱ ཡིཧཱུདཱ ཨེཏེ སཪྻྭེ ཡཏྲ སྠཱནེ པྲཝསནྟི ཏསྨིན྄ ཨུཔརིཏནཔྲཀོཥྛེ པྲཱཝིཤན྄། ");
INSERT INTO santib_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","པཤྩཱད྄ ཨིམེ ཀིཡཏྱཿ སྟྲིཡཤྩ ཡཱིཤོ རྨཱཏཱ མརིཡམ྄ ཏསྱ བྷྲཱཏརཤྩཻཏེ སཪྻྭ ཨེཀཙིཏྟཱིབྷཱུཏ སཏཏཾ ཝིནཡེན ཝིནཡེན པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ཏསྨིན྄ སམཡེ ཏཏྲ སྠཱནེ སཱཀལྱེན ཝིཾཤཏྱདྷིཀཤཏཾ ཤིཥྱཱ ཨཱསན྄། ཏཏཿ པིཏརསྟེཥཱཾ མདྷྱེ ཏིཥྛན྄ ཨུཀྟཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ཧེ བྷྲཱཏྲྀགཎ ཡཱིཤུདྷཱརིཎཱཾ ལོཀཱནཱཾ པཐདརྴཀོ ཡོ ཡིཧཱུདཱསྟསྨིན྄ དཱཡཱུདཱ པཝིཏྲ ཨཱཏྨཱ ཡཱཾ ཀཐཱཾ ཀཐཡཱམཱས ཏསྱཱཿ པྲཏྱཀྵཱིབྷཝནསྱཱཝཤྱཀཏྭམ྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ས ཛནོ྅སྨཱཀཾ མདྷྱཝརྟྟཱི སན྄ ཨསྱཱཿ སེཝཱཡཱ ཨཾཤམ྄ ཨལབྷཏ། ");
INSERT INTO santib_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ཏདནནྟརཾ ཀུཀརྨྨཎཱ ལབྡྷཾ ཡནྨཱུལྱཾ ཏེན ཀྵེཏྲམེཀཾ ཀྲཱིཏམ྄ ཨཔརཾ ཏསྨིན྄ ཨདྷོམུཁེ བྷྲྀམཽ པཏིཏེ སཏི ཏསྱོདརསྱ ཝིདཱིརྞཏྭཱཏ྄ སཪྻྭཱ ནཱཌྱོ ནིརགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ཨེཏཱཾ ཀཐཱཾ ཡིརཱུཤཱལམྣིཝཱསིནཿ སཪྻྭེ ལོཀཱ ཝིདཱནྟི; ཏེཥཱཾ ནིཛབྷཱཥཡཱ ཏཏྐྵེཏྲཉྩ ཧཀལྡཱམཱ, ཨརྠཱཏ྄ རཀྟཀྵེཏྲམིཏི ཝིཁྱཱཏམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ཨནྱཙྩ, ནིཀེཏནཾ ཏདཱིཡནྟུ ཤུནྱམེཝ བྷཝིཥྱཏི། ཏསྱ དཱུཥྱེ ནིཝཱསཱརྠཾ ཀོཔི སྠཱསྱཏི ནཻཝ ཧི། ཨནྱ ཨེཝ ཛནསྟསྱ པདཾ སཾཔྲཱཔྶྱཏི དྷྲུཝཾ། ཨིཏྠཾ གཱིཏཔུསྟཀེ ལིཁིཏམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ཨཏོ ཡོཧནོ མཛྫནམ྄ ཨཱརབྷྱཱསྨཱཀཾ སམཱིཔཱཏ྄ པྲབྷོ ཪྻཱིཤོཿ སྭརྒཱརོཧཎདིནཾ ཡཱཝཏ྄ སོསྨཱཀཾ མདྷྱེ ཡཱཝནྟི དིནཱནི ཡཱཔིཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ཏཱཝནྟི དིནཱནི ཡེ མཱནཝཱ ཨསྨཱབྷིཿ སཱརྡྡྷཾ ཏིཥྛནྟི ཏེཥཱམ྄ ཨེཀེན ཛནེནཱསྨཱབྷིཿ སཱརྡྡྷཾ ཡཱིཤོརུཏྠཱནེ སཱཀྵིཎཱ བྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ཨཏོ ཡསྱ རཱུཌྷི ཪྻུཥྚོ ཡཾ བརྴབྦེཏྱུཀྟྭཱཧཱུཡནྟི ས ཡཱུཥཕ྄ མཏཐིཤྩ དྭཱཝེཏཽ པྲྀཐཀ྄ ཀྲྀཏྭཱ ཏ ཨཱིཤྭརསྱ སནྣིདྷཽ པྲཱཪྻྱ ཀཐིཏཝནྟཿ, ");
INSERT INTO santib_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ཧེ སཪྻྭཱནྟཪྻྱཱམིན྄ པརམེཤྭར, ཡིཧཱུདཱཿ སེཝནཔྲེརིཏཏྭཔདཙྱུཏཿ ");
INSERT INTO santib_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","སན྄ ནིཛསྠཱནམ྄ ཨགཙྪཏ྄, ཏཏྤདཾ ལབྡྷུམ྄ ཨེནཡོ རྫནཡོ རྨདྷྱེ བྷཝཏཱ ཀོ྅བྷིརུཙིཏསྟདསྨཱན྄ དརྴྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ཏཏོ གུཊིཀཱཔཱཊེ ཀྲྀཏེ མཏཐིརྣིརཙཱིཡཏ ཏསྨཱཏ྄ སོནྱེཥཱམ྄ ཨེཀཱདཤཱནཱཾ པྲརིཏཱནཱཾ མདྷྱེ གཎིཏོབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ཨཔརཉྩ ནིསྟཱརོཏྶཝཱཏ྄ པརཾ པཉྩཱཤཏྟམེ དིནེ སམུཔསྠིཏེ སཏི ཏེ སཪྻྭེ ཨེཀཱཙིཏྟཱིབྷཱུཡ སྠཱན ཨེཀསྨིན྄ མིལིཏཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ཨེཏསྨིནྣེཝ སམཡེ྅ཀསྨཱད྄ ཨཱཀཱཤཱཏ྄ པྲཙཎྜཱཏྱུགྲཝཱཡོཿ ཤབྡཝད྄ ཨེཀཿ ཤབྡ ཨཱགཏྱ ཡསྨིན྄ གྲྀཧེ ཏ ཨུཔཱཝིཤན྄ ཏད྄ གྲྀཧཾ སམསྟཾ ཝྱཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ཏཏཿ པརཾ ཝཧྣིཤིཁཱསྭརཱུཔཱ ཛིཧྭཱཿ པྲཏྱཀྵཱིབྷཱུཡ ཝིབྷཀྟཱཿ སཏྱཿ པྲཏིཛནོརྡྡྷྭེ སྠགིཏཱ ཨབྷཱུཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ཏསྨཱཏ྄ སཪྻྭེ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཱཿ སནྟ ཨཱཏྨཱ ཡཐཱ ཝཱཙིཏཝཱན྄ ཏདནུསཱརེཎཱནྱདེཤཱིཡཱནཱཾ བྷཱཥཱ ཨུཀྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ཏསྨིན྄ སམཡེ པྲྀཐིཝཱིསྠསཪྻྭདེཤེབྷྱོ ཡིཧཱུདཱིཡམཏཱཝལམྦིནོ བྷཀྟལོཀཱ ཡིརཱུཤཱལམི པྲཱཝསན྄; ");
INSERT INTO santib_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ཏསྱཱཿ ཀཐཱཡཱཿ ཀིཾཝདནྟྱཱ ཛཱཏཏྭཱཏ྄ སཪྻྭེ ལོཀཱ མིལིཏྭཱ ནིཛནིཛབྷཱཥཡཱ ཤིཥྱཱཎཱཾ ཀཐཱཀཐནཾ ཤྲུཏྭཱ སམུདྭིགྣཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","སཪྻྭཨེཝ ཝིསྨཡཱཔནྣཱ ཨཱཤྩཪྻྱཱནྭིཏཱཤྩ སནྟཿ པརསྤརཾ ཨུཀྟཝནྟཿ པཤྱཏ ཡེ ཀཐཱཾ ཀཐཡནྟི ཏེ སཪྻྭེ གཱལཱིལཱིཡལོཀཱཿ ཀིཾ ན བྷཝནྟི? ");
INSERT INTO santib_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ཏརྷི ཝཡཾ པྲཏྱེཀཤཿ སྭསྭཛནྨདེཤཱིཡབྷཱཥཱབྷིཿ ཀཐཱ ཨེཏེཥཱཾ ཤྲྀཎུམཿ ཀིམིདཾ? ");
INSERT INTO santib_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","པཱརྠཱི-མཱདཱི-ཨརཱམྣཧརཡིམྡེཤནིཝཱསིམནོ ཡིཧཱུདཱ-ཀཔྤདཀིཡཱ-པནྟ-ཨཱཤིཡཱ- ");
INSERT INTO santib_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ཕྲུགིཡཱ-པམྥུལིཡཱ-མིསརནིཝཱསིནཿ ཀུརཱིཎཱིནིཀཊཝརྟྟིལཱུབཱིཡཔྲདེཤནིཝཱསིནོ རོམནགརཱད྄ ཨཱགཏཱ ཡིཧཱུདཱིཡལོཀཱ ཡིཧཱུདཱིཡམཏགྲཱཧིཎཿ ཀྲཱིཏཱིཡཱ ཨརཱབཱིཡཱདཡོ ལོཀཱཤྩ ཡེ ཝཡམ྄ ");
INSERT INTO santib_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ཨསྨཱཀཾ ནིཛནིཛབྷཱཥཱབྷིརེཏེཥཱམ྄ ཨཱིཤྭརཱིཡམཧཱཀརྨྨཝྱཱཁྱཱནཾ ཤྲྀཎུམཿ། ");
INSERT INTO santib_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ཨིཏྠཾ ཏེ སཪྻྭཨེཝ ཝིསྨཡཱཔནྣཱཿ སནྡིགྡྷཙིཏྟཱཿ སནྟཿ པརསྤརམཱུཙུཿ, ཨསྱ ཀོ བྷཱཝཿ? ");
INSERT INTO santib_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ཨཔརེ ཀེཙིཏ྄ པརིཧསྱ ཀཐིཏཝནྟ ཨེཏེ ནཝཱིནདྲཱཀྵཱརསེན མཏྟཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ཏདཱ པིཏར ཨེཀཱདཤབྷི རྫནཻཿ སཱཀཾ ཏིཥྛན྄ ཏཱལློཀཱན྄ ཨུཙྩཻཿཀཱརམ྄ ཨཝདཏ྄, ཧེ ཡིཧཱུདཱིཡཱ ཧེ ཡིརཱུཤཱལམྣིཝཱསིནཿ སཪྻྭེ, ཨཝདྷཱནཾ ཀྲྀཏྭཱ མདཱིཡཝཱཀྱཾ བུདྷྱདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ཨིདཱནཱིམ྄ ཨེཀཡཱམཱད྄ ཨདྷིཀཱ ཝེལཱ ནཱསྟི ཏསྨཱད྄ ཡཱུཡཾ ཡད྄ ཨནུམཱཐ མཱནཝཱ ཨིམེ མདྱཔཱནེན མཏྟཱསྟནྣ། ");
INSERT INTO santib_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ཀིནྟུ ཡོཡེལྦྷཝིཥྱདྭཀྟྲཻཏདྭཱཀྱམུཀྟཾ ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ཨཱིཤྭརཿ ཀཐཡཱམཱས ཡུགཱནྟསམཡེ ཏྭཧམ྄། ཝརྵིཥྱཱམི སྭམཱཏྨཱནཾ སཪྻྭཔྲཱཎྱུཔརི དྷྲུཝམ྄། བྷཱཝིཝཱཀྱཾ ཝདིཥྱནྟི ཀནྱཱཿ པུཏྲཱཤྩ ཝསྟུཏཿ། པྲཏྱཱདེཤཉྩ པྲཱཔྶྱནྟི ཡུཥྨཱཀཾ ཡུཝམཱནཝཱཿ། ཏཐཱ པྲཱཙཱིནལོཀཱསྟུ སྭཔྣཱན྄ དྲཀྵྱནྟི ནིཤྩིཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ཝརྵིཥྱཱམི ཏདཱཏྨཱནཾ དཱསདཱསཱིཛནོཔིརི། ཏེནཻཝ བྷཱཝིཝཱཀྱཾ ཏེ ཝདིཥྱནྟི ཧི སཪྻྭཤཿ། ");
INSERT INTO santib_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ཨཱུརྡྡྷྭསྠེ གགཎེ ཙཻཝ ནཱིཙསྠེ པྲྀཐིཝཱིཏལེ། ཤོཎིཏཱནི བྲྀཧདྦྷཱནཱུན྄ གྷནདྷཱུམཱདིཀཱནི ཙ། ཙིཧྣཱནི དརྴཡིཥྱཱམི མཧཱཤྩཪྻྱཀྲིཡཱསྟཐཱ། ");
INSERT INTO santib_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","མཧཱབྷཡཱནཀསྱཻཝ ཏདྡིནསྱ པརེཤིཏུཿ། པུརཱགམཱད྄ རཝིཿ ཀྲྀཥྞོ རཀྟཤྩནྡྲོ བྷཝིཥྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ཀིནྟུ ཡཿ པརམེཤསྱ ནཱམྣི སམྤྲཱརྠཡིཥྱཏེ། སཨེཝ མནུཛོ ནཱུནཾ པརིཏྲཱཏོ བྷཝིཥྱཏི༎ ");
INSERT INTO santib_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ཨཏོ ཧེ ཨིསྲཱཡེལྭཾཤཱིཡལོཀཱཿ སཪྻྭེ ཀཐཱཡཱམེཏསྱཱམ྄ མནོ ནིདྷདྡྷྭཾ ནཱསརཏཱིཡོ ཡཱིཤུརཱིཤྭརསྱ མནོནཱིཏཿ པུམཱན྄ ཨེཏད྄ ཨཱིཤྭརསྟཏྐྲྀཏཻརཱཤྩཪྻྱཱདྦྷུཏཀརྨྨབྷི རླཀྵཎཻཤྩ ཡུཥྨཱཀཾ སཱཀྵཱདེཝ པྲཏིཔཱདིཏཝཱན྄ ཨིཏི ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ཏསྨིན྄ ཡཱིཤཽ ཨཱིཤྭརསྱ པཱུཪྻྭནིཤྩིཏམནྟྲཎཱནིརཱུཔཎཱནུསཱརེཎ མྲྀཏྱཽ སམརྤིཏེ སཏི ཡཱུཡཾ ཏཾ དྷྲྀཏྭཱ དུཥྚལོཀཱནཱཾ ཧསྟཻཿ ཀྲུཤེ ཝིདྷིཏྭཱཧཏ། ");
INSERT INTO santib_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ཀིནྟྭཱིཤྭརསྟཾ ནིདྷནསྱ བནྡྷནཱནྨོཙཡིཏྭཱ ཨུདསྠཱཔཡཏ྄ ཡཏཿ ས མྲྀཏྱུནཱ བདྡྷསྟིཥྛཏཱིཏི ན སམྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ཨེཏསྟིན྄ དཱཡཱུདཔི ཀཐིཏཝཱན྄ ཡཐཱ, སཪྻྭདཱ མམ སཱཀྵཱཏྟཾ སྠཱཔཡ པརམེཤྭརཾ། སྠིཏེ མདྡཀྵིཎེ ཏསྨིན྄ སྑལིཥྱཱམི ཏྭཧཾ ནཧི། ");
INSERT INTO santib_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ཨཱནནྡིཥྱཏི ཏདྡྷེཏོ རྨཱམཀཱིནཾ མནསྟུ ཝཻ། ཨཱཧླཱདིཥྱཏི ཛིཧྭཱཔི མདཱིཡཱ ཏུ ཏཐཻཝ ཙ། པྲཏྱཱཤཡཱ ཤརཱིརནྟུ མདཱིཡཾ ཝཻཤཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","པརལོཀེ ཡཏོ ཧེཏོསྟྭཾ མཱཾ ནཻཝ ཧི ཏྱཀྵྱསི། སྭཀཱིཡཾ པུཎྱཝནྟཾ ཏྭཾ ཀྵཡིཏུཾ ནཻཝ དཱསྱསི། ཨེཝཾ ཛཱིཝནམཱརྒཾ ཏྭཾ མཱམེཝ དརྴཡིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","སྭསམྨུཁེ ཡ ཨཱནནྡོ དཀྵིཎེ སྭསྱ ཡཏ྄ སུཁཾ། ཨནནྟཾ ཏེན མཱཾ པཱུརྞཾ ཀརིཥྱསི ན སཾཤཡཿ༎ ");
INSERT INTO santib_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ཧེ བྷྲཱཏརོ྅སྨཱཀཾ ཏསྱ པཱུཪྻྭཔུརུཥསྱ དཱཡཱུདཿ ཀཐཱཾ སྤཥྚཾ ཀཐཡིཏུཾ མཱམ྄ ཨནུམནྱདྷྭཾ, ས པྲཱཎཱན྄ ཏྱཀྟྭཱ ཤྨཤཱནེ སྠཱཔིཏོབྷཝད྄ ཨདྱཱཔི ཏཏ྄ ཤྨཤཱནམ྄ ཨསྨཱཀཾ སནྣིདྷཽ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ཕལཏོ ལཽཀིཀབྷཱཝེན དཱཡཱུདོ ཝཾཤེ ཁྲཱིཥྚཾ ཛནྨ གྲཱཧཡིཏྭཱ ཏསྱཻཝ སིཾཧཱསནེ སམུཝེཥྚུཾ ཏམུཏྠཱཔཡིཥྱཏི པརམེཤྭརཿ ཤཔཐཾ ཀུཏྭཱ དཱཡཱུདཿ སམཱིཔ ཨིམམ྄ ཨངྒཱིཀཱརཾ ཀྲྀཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ཨིཏི ཛྙཱཏྭཱ དཱཡཱུད྄ བྷཝིཥྱདྭཱདཱི སན྄ བྷཝིཥྱཏྐཱལཱིཡཛྙཱནེན ཁྲཱིཥྚོཏྠཱནེ ཀཐཱམིམཱཾ ཀཐཡཱམཱས ཡཐཱ ཏསྱཱཏྨཱ པརལོཀེ ན ཏྱཀྵྱཏེ ཏསྱ ཤརཱིརཉྩ ན ཀྵེཥྱཏི; ");
INSERT INTO santib_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ཨཏཿ པརམེཤྭར ཨེནཾ ཡཱིཤུཾ ཤྨཤཱནཱད྄ ཨུདསྠཱཔཡཏ྄ ཏཏྲ ཝཡཾ སཪྻྭེ སཱཀྵིཎ ཨཱསྨཧེ། ");
INSERT INTO santib_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ས ཨཱིཤྭརསྱ དཀྵིཎཀརེཎོནྣཏིཾ པྲཱཔྱ པཝིཏྲ ཨཱཏྨིན པིཏཱ ཡམངྒཱིཀཱརཾ ཀྲྀཏཝཱན྄ ཏསྱ ཕལཾ པྲཱཔྱ ཡཏ྄ པཤྱཐ ཤྲྀཎུཐ ཙ ཏདཝརྵཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ཡཏོ དཱཡཱུད྄ སྭརྒཾ ནཱརུརོཧ ཀིནྟུ སྭཡམ྄ ཨིམཱཾ ཀཐཱམ྄ ཨཀཐཡད྄ ཡཐཱ, མམ པྲབྷུམིདཾ ཝཱཀྱམཝདཏ྄ པརམེཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ཏཝ ཤཏྲཱུནཧཾ ཡཱཝཏ྄ པཱདཔཱིཋཾ ཀརོམི ན། ཏཱཝཏ྄ ཀཱལཾ མདཱིཡེ ཏྭཾ དཀྵཝཱརྴྭ ཨུཔཱཝིཤ། ");
INSERT INTO santib_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ཨཏོ ཡཾ ཡཱིཤུཾ ཡཱུཡཾ ཀྲུཤེ྅ཧཏ པརམེཤྭརསྟཾ པྲབྷུཏྭཱབྷིཥིཀྟཏྭཔདེ ནྱཡུཾཀྟེཏི ཨིསྲཱཡེལཱིཡཱ ལོཀཱ ནིཤྩིཏཾ ཛཱནནྟུ། ");
INSERT INTO santib_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ཨེཏཱདྲྀཤཱིཾ ཀཐཱཾ ཤྲུཏྭཱ ཏེཥཱཾ ཧྲྀདཡཱནཱཾ ཝིདཱིརྞཏྭཱཏ྄ ཏེ པིཏརཱཡ ཏདནྱཔྲེརིཏེབྷྱཤྩ ཀཐིཏཝནྟཿ, ཧེ བྷྲཱཏྲྀགཎ ཝཡཾ ཀིཾ ཀརིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ཏཏཿ པིཏརཿ པྲཏྱཝདད྄ ཡཱུཡཾ སཪྻྭེ སྭཾ སྭཾ མནཿ པརིཝརྟྟཡདྷྭཾ ཏཐཱ པཱཔམོཙནཱརྠཾ ཡཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ མཛྫིཏཱཤྩ བྷཝཏ, ཏསྨཱད྄ དཱནརཱུཔཾ པརིཏྲམ྄ ཨཱཏྨཱནཾ ལཔྶྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ཡཏོ ཡུཥྨཱཀཾ ཡུཥྨཏྶནྟཱནཱནཱཉྩ དཱུརསྠསཪྻྭལོཀཱནཱཉྩ ནིམིཏྟམ྄ ཨརྠཱད྄ ཨསྨཱཀཾ པྲབྷུཿ པརམེཤྭརོ ཡཱཝཏོ ལཱཀཱན྄ ཨཱཧྭཱསྱཏི ཏེཥཱཾ སཪྻྭེཥཱཾ ནིམིཏྟམ྄ ཨཡམངྒཱིཀཱར ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ཨེཏདནྱཱབྷི རྦཧུཀཐཱབྷིཿ པྲམཱཎཾ དཏྭཱཀཐཡཏ྄ ཨེཏེབྷྱོ ཝིཔཐགཱམིབྷྱོ ཝརྟྟམཱནལོཀེབྷྱཿ སྭཱན྄ རཀྵཏ། ");
INSERT INTO santib_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ཏཏཿ པརཾ ཡེ སཱནནྡཱསྟཱཾ ཀཐཱམ྄ ཨགྲྀཧླན྄ ཏེ མཛྫིཏཱ ཨབྷཝན྄། ཏསྨིན྄ དིཝསེ པྲཱཡེཎ ཏྲཱིཎི སཧསྲཱཎི ལོཀཱསྟེཥཱཾ སཔཀྵཱཿ སནྟཿ ");
INSERT INTO santib_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","པྲེརིཏཱནཱམ྄ ཨུཔདེཤེ སངྒཏཽ པཱུཔབྷཉྫནེ པྲཱརྠནཱསུ ཙ མནཿསཾཡོགཾ ཀྲྀཏྭཱཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","པྲེརིཏཻ རྣཱནཱཔྲཀཱརལཀྵཎེཥུ མཧཱཤྩཪྻྱཀརྨམསུ ཙ དརྴིཏེཥུ སཪྻྭལོཀཱནཱཾ བྷཡམུཔསྠིཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ཝིཤྭཱསཀཱརིཎཿ སཪྻྭ ཙ སཧ ཏིཥྛནཏཿ། སྭེཥཱཾ སཪྻྭཱཿ སམྤཏྟཱིཿ སཱདྷཱརཎྱེན སྠཱཔཡིཏྭཱབྷུཉྫཏ། ");
INSERT INTO santib_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ཕལཏོ གྲྀཧཱཎི དྲཝྱཱཎི ཙ སཪྻྭཱཎི ཝིཀྲཱིཡ སཪྻྭེཥཱཾ སྭསྭཔྲཡོཛནཱནུསཱརེཎ ཝིབྷཛྱ སཪྻྭེབྷྱོ྅དདན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","སཪྻྭ ཨེཀཙིཏྟཱིབྷཱུཡ དིནེ དིནེ མནྡིརེ སནྟིཥྛམཱནཱ གྲྀཧེ གྲྀཧེ ཙ པཱུཔཱནབྷཉྫནྟ ཨཱིཤྭརསྱ དྷནྱཝཱདཾ ཀུཪྻྭནྟོ ལོཀཻཿ སམཱདྲྀཏཱཿ པརམཱནནྡེན སརལཱནྟཿཀརཎེན བྷོཛནཾ པཱནཉྩཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","པརམེཤྭརོ དིནེ དིནེ པརིཏྲཱཎབྷཱཛནཻ རྨཎྜལཱིམ྄ ཨཝརྡྡྷཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ཏྲྀཏཱིཡཡཱམཝེལཱཡཱཾ སཏྱཱཾ པྲཱརྠནཱཡཱཿ སམཡེ པིཏརཡོཧནཽ སམྦྷཱུཡ མནྡིརཾ གཙྪཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ཏསྨིནྣེཝ སམཡེ མནྡིརཔྲཝེཤཀཱནཱཾ སམཱིཔེ བྷིཀྵཱརཎཱརྠཾ ཡཾ ཛནྨཁཉྫམཱནུཥཾ ལོཀཱ མནྡིརསྱ སུནྡརནཱམྣི དྭཱརེ པྲཏིདིནམ྄ ཨསྠཱཔཡན྄ ཏཾ ཝཧནྟསྟདྭཱརཾ ཨཱནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ཏདཱ པིཏརཡོཧནཽ མནྟིརཾ པྲཝེཥྚུམ྄ ཨུདྱཏཽ ཝིལོཀྱ ས ཁཉྫསྟཽ ཀིཉྩིད྄ བྷིཀྵིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ཏསྨཱད྄ ཡོཧནཱ སཧིཏཿ པིཏརསྟམ྄ ཨནནྱདྲྀཥྚྱཱ ནིརཱིཀྵྱ པྲོཀྟཝཱན྄ ཨཱཝཱཾ པྲཏི དྲྀཥྚིཾ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ཏཏཿ ས ཀིཉྩིཏ྄ པྲཱཔྟྱཱཤཡཱ ཏཽ པྲཏི དྲྀཥྚིཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ཏདཱ པིཏརོ གདིཏཝཱན྄ མམ ནིཀཊེ སྭརྞརཱུཔྱཱདི ཀིམཔི ནཱསྟི ཀིནྟུ ཡདཱསྟེ ཏད྄ དདཱམི ནཱསརཏཱིཡསྱ ཡཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ ཏྭམུཏྠཱཡ གམནཱགམནེ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ཏཏཿ པརཾ ས ཏསྱ དཀྵིཎཀརཾ དྷྲྀཏྭཱ ཏམ྄ ཨུདཏོལཡཏ྄; ཏེན ཏཏྐྵཎཱཏ྄ ཏསྱ ཛནསྱ པཱདགུལྥཡོཿ སབལཏྭཱཏ྄ ས ཨུལླམྥྱ པྲོཏྠཱཡ གམནཱགམནེ ྅ཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ཏཏོ གམནཱགམནེ ཀུཪྻྭན྄ ཨུལླམྥན྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདན྄ ཏཱབྷྱཱཾ སཱརྡྡྷཾ མནྡིརཾ པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ཏཏཿ སཪྻྭེ ལོཀཱསྟཾ གམནཱགམནེ ཀུཪྻྭནྟམ྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདནྟཉྩ ཝིལོཀྱ ");
INSERT INTO santib_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","མནྡིརསྱ སུནྡརེ དྭཱརེ ཡ ཨུཔཝིཤྱ བྷིཀྵིཏཝཱན྄ སཨེཝཱཡམ྄ ཨིཏི ཛྙཱཏྭཱ ཏཾ པྲཏི ཏཡཱ གྷཊནཡཱ ཙམཏྐྲྀཏཱ ཝིསྨཡཱཔནྣཱཤྩཱབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ཡཿ ཁཉྫཿ སྭསྠོབྷཝཏ྄ ཏེན པིཏརཡོཧནོཿ ཀརཡོརྡྷྚཏཡོཿ སཏོཿ སཪྻྭེ ལོཀཱ སནྣིདྷིམ྄ ཨཱགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ཏད྄ དྲྀཥྚྭཱ པིཏརསྟེབྷྱོ྅ཀཐཡཏ྄, ཧེ ཨིསྲཱཡེལཱིཡལོཀཱ ཡཱུཡཾ ཀུཏོ ྅ནེནཱཤྩཪྻྱཾ མནྱདྷྭེ? ཨཱཝཱཾ ནིཛཤཀྟྱཱ ཡདྭཱ ནིཛཔུཎྱེན ཁཉྫམནུཥྱམེནཾ གམིཏཝནྟཱཝིཏི ཙིནྟཡིཏྭཱ ཨཱཝཱཾ པྲཏི ཀུཏོ྅ནནྱདྲྀཥྚིཾ ཀུརུཐ? ");
INSERT INTO santib_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ཡཾ ཡཱིཤུཾ ཡཱུཡཾ པརཀརེཥུ སམཱརྤཡཏ ཏཏོ ཡཾ པཱིལཱཏོ མོཙཡིཏུམ྄ ཨེैཙྪཏ྄ ཏཐཱཔི ཡཱུཡཾ ཏསྱ སཱཀྵཱན྄ ནཱངྒཱིཀྲྀཏཝནྟ ཨིབྲཱཧཱིམ ཨིསྷཱཀོ ཡཱཀཱུབཤྩེཤྭརོ྅རྠཱད྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱཎཱམ྄ ཨཱིཤྭརཿ སྭཔུཏྲསྱ ཏསྱ ཡཱིཤོ རྨཧིམཱནཾ པྲཱཀཱཤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ཀིནྟུ ཡཱུཡཾ ཏཾ པཝིཏྲཾ དྷཱརྨྨིཀཾ པུམཱཾསཾ ནཱངྒཱིཀྲྀཏྱ ཧཏྱཱཀཱརིཎམེཀཾ སྭེབྷྱོ དཱཏུམ྄ ཨཡཱཙདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","པཤྩཱཏ྄ ཏཾ ཛཱིཝནསྱཱདྷིཔཏིམ྄ ཨཧཏ ཀིནྟྭཱིཤྭརཿ ཤྨཤཱནཱཏ྄ ཏམ྄ ཨུདསྠཱཔཡཏ ཏཏྲ ཝཡཾ སཱཀྵིཎ ཨཱསྨཧེ། ");
INSERT INTO santib_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ཨིམཾ ཡཾ མཱནུཥཾ ཡཱུཡཾ པཤྱཐ པརིཙིནུཐ ཙ ས ཏསྱ ནཱམྣི ཝིཤྭཱསཀརཎཱཏ྄ ཙལནཤཀྟིཾ ལབྡྷཝཱན྄ ཏསྨིན྄ ཏསྱ ཡོ ཝིཤྭཱསཿ ས ཏཾ ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ སཱཀྵཱཏ྄ སམྤཱུརྞརཱུཔེཎ སྭསྠམ྄ ཨཀཱརྵཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ཧེ བྷྲཱཏརོ ཡཱུཡཾ ཡུཥྨཱཀམ྄ ཨདྷིཔཏཡཤྩ ཨཛྙཱཏྭཱ ཀརྨྨཱཎྱེཏཱནི ཀྲྀཏཝནྟ ཨིདཱནཱིཾ མམཻཥ བོདྷོ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ཀིནྟྭཱིཤྭརཿ ཁྲཱིཥྚསྱ དུཿཁབྷོགེ བྷཝིཥྱདྭཱདིནཱཾ མུཁེབྷྱོ ཡཱཾ ཡཱཾ ཀཐཱཾ པཱུཪྻྭམཀཐཡཏ྄ ཏཱཿ ཀཐཱ ཨིཏྠཾ སིདྡྷཱ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ཨཏཿ སྭེཥཱཾ པཱཔམོཙནཱརྠཾ ཁེདཾ ཀྲྀཏྭཱ མནཱཾསི པརིཝརྟྟཡདྷྭཾ, ཏསྨཱད྄ ཨཱིཤྭརཱཏ྄ སཱནྟྭནཱཔྲཱཔྟེཿ སམཡ ཨུཔསྠཱསྱཏི; ");
INSERT INTO santib_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","པུནཤྩ པཱུཪྻྭཀཱལམ྄ ཨཱརབྷྱ པྲཙཱརིཏོ ཡོ ཡཱིཤུཁྲཱིཥྚསྟམ྄ ཨཱིཤྭརོ ཡུཥྨཱན྄ པྲཏི པྲེཥཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ཀིནྟུ ཛགཏཿ སྲྀཥྚིམཱརབྷྱ ཨཱིཤྭརོ ནིཛཔཝིཏྲབྷཝིཥྱདྭཱདིགཎོན ཡཐཱ ཀཐིཏཝཱན྄ ཏདནུསཱརེཎ སཪྻྭེཥཱཾ ཀཱཪྻྱཱཎཱཾ སིདྡྷིཔཪྻྱནྟཾ ཏེན སྭརྒེ ཝཱསཿ ཀརྟྟཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ཡུཥྨཱཀཾ པྲབྷུཿ པརམེཤྭརོ ཡུཥྨཱཀཾ བྷྲཱཏྲྀགཎམདྷྱཱཏ྄ མཏྶདྲྀཤཾ བྷཝིཥྱདྭཀྟཱརམ྄ ཨུཏྤཱདཡིཥྱཏི, ཏཏཿ ས ཡཏ྄ ཀིཉྩིཏ྄ ཀཐཡིཥྱཏི ཏཏྲ ཡཱུཡཾ མནཱཾསི ནིདྷདྡྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ པྲཱཎཱི ཏསྱ བྷཝིཥྱདྭཱདིནཿ ཀཐཱཾ ན གྲཧཱིཥྱཏི ས ནིཛལོཀཱནཱཾ མདྷྱཱད྄ ཨུཙྪེཏྶྱཏེ,\" ཨིམཱཾ ཀཐཱམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥེབྷྱཿ ཀེཝལོ མཱུསཱཿ ཀཐཡཱམཱས ཨིཏི ནཧི, ");
INSERT INTO santib_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ཤིམཱུཡེལྦྷཝིཥྱདྭཱདིནམ྄ ཨཱརབྷྱ ཡཱཝནྟོ བྷཝིཥྱདྭཱཀྱམ྄ ཨཀཐཡན྄ ཏེ སཪྻྭཨེཝ སམཡསྱཻཏསྱ ཀཐཱམ྄ ཨཀཐཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ཡཱུཡམཔི ཏེཥཱཾ བྷཝིཥྱདྭཱདིནཱཾ སནྟཱནཱཿ, \"ཏཝ ཝཾཤོདྦྷཝཔུཾསཱ སཪྻྭདེཤཱིཡཱ ལོཀཱ ཨཱཤིཥཾ པྲཱཔྟཱ བྷཝིཥྱནྟི\", ཨིབྲཱཧཱིམེ ཀཐཱམེཏཱཾ ཀཐཡིཏྭཱ ཨཱིཤྭརོསྨཱཀཾ པཱུཪྻྭཔུརུཥཻཿ སཱརྡྡྷཾ ཡཾ ནིཡམཾ སྠིརཱིཀྲྀཏཝཱན྄ ཏསྱ ནིཡམསྱཱདྷིཀཱརིཎོཔི ཡཱུཡཾ བྷཝཐ། ");
INSERT INTO santib_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ཨཏ ཨཱིཤྭརོ ནིཛཔུཏྲཾ ཡཱིཤུམ྄ ཨུཏྠཱཔྱ ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ སྭསྭཔཱཔཱཏ྄ པརཱཝརྟྟྱ ཡུཥྨབྷྱམ྄ ཨཱཤིཥཾ དཱཏུཾ པྲཐམཏསྟཾ ཡུཥྨཱཀཾ ནིཀཊཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ཡསྨིན྄ སམཡེ པིཏརཡོཧནཽ ལོཀཱན྄ ཨུཔདིཤཏསྟསྨིན྄ སམཡེ ཡཱཛཀཱ མནྡིརསྱ སེནཱཔཏཡཿ སིདཱུཀཱིགཎཤྩ ");
INSERT INTO santib_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ཏཡོར྄ ཨུཔདེཤཀརཎེ ཁྲཱིཥྚསྱོཏྠཱནམ྄ ཨུཔལཀྵྱ སཪྻྭེཥཱཾ མྲྀཏཱནཱམ྄ ཨུཏྠཱནཔྲསྟཱཝེ ཙ ཝྱགྲཱཿ སནྟསྟཱཝུཔཱགམན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ཏཽ དྷྲྀཏྭཱ དིནཱཝསཱནཀཱརཎཱཏ྄ པརདིནཔཪྻྱནནྟཾ རུདྡྷྭཱ སྠཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ཏཐཱཔི ཡེ ལོཀཱསྟཡོརུཔདེཤམ྄ ཨཤྲྀཎྭན྄ ཏེཥཱཾ པྲཱཡེཎ པཉྩསཧསྲཱཎི ཛནཱ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","པརེ྅ཧནི ཨདྷིཔཏཡཿ པྲཱཙཱིནཱ ཨདྷྱཱཔཀཱཤྩ ཧཱནནནཱམཱ མཧཱཡཱཛཀཿ ");
INSERT INTO santib_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ཀིཡཕཱ ཡོཧན྄ སིཀནྡར ཨིཏྱཱདཡོ མཧཱཡཱཛཀསྱ ཛྙཱཏཡཿ སཪྻྭེ ཡིརཱུཤཱལམྣགརེ མིལིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ཨནནྟརཾ པྲེརིཏཽ མདྷྱེ སྠཱཔཡིཏྭཱཔྲྀཙྪན྄ ཡུཝཱཾ ཀཡཱ ཤཀྟཡཱ ཝཱ ཀེན ནཱམྣཱ ཀརྨྨཱཎྱེཏཱནི ཀུརུཐཿ? ");
INSERT INTO santib_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ཏདཱ པིཏརཿ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཿ སན྄ པྲཏྱཝཱདཱིཏ྄, ཧེ ལོཀཱནཱམ྄ ཨདྷིཔཏིགཎ ཧེ ཨིསྲཱཡེལཱིཡཔྲཱཙཱིནཱཿ, ");
INSERT INTO santib_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ཨེཏསྱ དུརྦྦལམཱནུཥསྱ ཧིཏཾ ཡཏ྄ ཀརྨྨཱཀྲིཡཏ, ཨརྠཱཏ྄, ས ཡེན པྲཀཱརེཎ སྭསྠོབྷཝཏ྄ ཏཙྩེད྄ ཨདྱཱཝཱཾ པྲྀཙྪཐ, ");
INSERT INTO santib_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ཏརྷི སཪྻྭ ཨིསྲཱཡེेལཱིཡལོཀཱ ཡཱུཡཾ ཛཱནཱིཏ ནཱསརཏཱིཡོ ཡོ ཡཱིཤུཁྲཱིཥྚཿ ཀྲུཤེ ཡུཥྨཱབྷིརཝིདྷྱཏ ཡཤྩེཤྭརེཎ ཤྨཤཱནཱད྄ ཨུཏྠཱཔིཏཿ, ཏསྱ ནཱམྣཱ ཛནོཡཾ སྭསྠཿ སན྄ ཡུཥྨཱཀཾ སམྨུཁེ པྲོཏྟིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ནིཙེཏྲྀབྷི ཪྻུཥྨཱབྷིརཡཾ ཡཿ པྲསྟརོ྅ཝཛྙཱཏོ྅བྷཝཏ྄ ས པྲདྷཱནཀོཎསྱ པྲསྟརོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ཏདྦྷིནྣཱདཔརཱཏ྄ ཀསྨཱདཔི པརིཏྲཱཎཾ བྷཝིཏུཾ ན ཤཀྣོཏི, ཡེན ཏྲཱཎཾ པྲཱཔྱེཏ བྷཱུམཎྜལསྱལོཀཱནཱཾ མདྷྱེ ཏཱདྲྀཤཾ ཀིམཔི ནཱམ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ཏདཱ པིཏརཡོཧནོརེཏཱདྲྀཤཱིམ྄ ཨཀྵེབྷཏཱཾ དྲྀཥྚྭཱ ཏཱཝཝིདྭཱཾསཽ ནཱིཙལོཀཱཝིཏི བུདྡྷྭཱ ཨཱཤྩཪྻྱམ྄ ཨམནྱནྟ ཏཽ ཙ ཡཱིཤོཿ སངྒིནཽ ཛཱཏཱཝིཏི ཛྙཱཏུམ྄ ཨཤཀྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ཀིནྟུ ཏཱབྷྱཱཾ སཱརྡྡྷཾ ཏཾ སྭསྠམཱནུཥཾ ཏིཥྛནྟཾ དྲྀཥྚྭཱ ཏེ ཀཱམཔྱཔརཱམ྄ ཨཱཔཏྟིཾ ཀརྟྟཾ ནཱཤཀྣུན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ཏདཱ ཏེ སབྷཱཏཿ སྠཱནཱནྟརཾ གནྟུཾ ཏཱན྄ ཨཱཛྙཱཔྱ སྭཡཾ པརསྤརམ྄ ཨིཏི མནྟྲཎཱམཀུཪྻྭན྄ ");
INSERT INTO santib_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ཏཽ མཱནཝཽ པྲཏི ཀིཾ ཀརྟྟཝྱཾ? ཏཱཝེཀཾ པྲསིདྡྷམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨ ཀྲྀཏཝནྟཽ ཏད྄ ཡིརཱུཤཱལམྣིཝཱསིནཱཾ སཪྻྭེཥཱཾ ལོཀཱནཱཾ སམཱིཔེ པྲཱཀཱཤཏ ཏཙྩ ཝཡམཔཧྣོཏུཾ ན ཤཀྣུམཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ཀིནྟུ ལོཀཱནཱཾ མདྷྱམ྄ ཨེཏད྄ ཡཐཱ ན ཝྱཱཔྣོཏི ཏདརྠཾ ཏཽ བྷཡཾ པྲདརྴྱ ཏེན ནཱམྣཱ ཀམཔི མནུཥྱཾ ནོཔདིཤཏམ྄ ཨིཏི དྲྀཌྷཾ ནིཥེདྷཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ཏཏསྟེ པྲེརིཏཱཝཱཧཱུཡ ཨེཏདཱཛྙཱཔཡན྄ ཨིཏཿ པརཾ ཡཱིཤོ རྣཱམྣཱ ཀདཱཔི ཀཱམཔི ཀཐཱཾ མཱ ཀཐཡཏཾ ཀིམཔི ནོཔདིཤཉྩ། ");
INSERT INTO santib_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ཏཏཿ པིཏརཡོཧནཽ པྲཏྱཝདཏཱམ྄ ཨཱིཤྭརསྱཱཛྙཱགྲཧཎཾ ཝཱ ཡུཥྨཱཀམ྄ ཨཱཛྙཱགྲཧཎམ྄ ཨེཏཡོ རྨདྷྱེ ཨཱིཤྭརསྱ གོཙརེ ཀིཾ ཝིཧིཏཾ? ཡཱུཡཾ ཏསྱ ཝིཝེཙནཱཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ཝཡཾ ཡད྄ ཨཔཤྱཱམ ཡདཤྲྀཎུམ ཙ ཏནྣ པྲཙཱརཡིཥྱཱམ ཨེཏཏ྄ ཀདཱཔི བྷཝིཏུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ཡདགྷཊཏ ཏད྄ དྲྀཥྚཱ སཪྻྭེ ལོཀཱ ཨཱིཤྭརསྱ གུཎཱན྄ ཨནྭཝདན྄ ཏསྨཱཏ྄ ལོཀབྷཡཱཏ྄ ཏཽ དཎྜཡིཏུཾ ཀམཔྱུཔཱཡཾ ན པྲཱཔྱ ཏེ པུནརཔི ཏརྫཡིཏྭཱ ཏཱཝཏྱཛན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ཡསྱ མཱནུཥསྱཻཏཏ྄ སྭཱསྠྱཀརཎམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨཱཀྲིཡཏ ཏསྱ ཝཡཤྩཏྭཱརིཾཤདྭཏྶརཱ ཝྱཏཱིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ཏཏཿ པརཾ ཏཽ ཝིསྲྀཥྚཽ སནྟཽ སྭསངྒིནཱཾ སནྣིདྷིཾ གཏྭཱ པྲདྷཱནཡཱཛཀཻཿ པྲཱཙཱིནལོཀཻཤྩ པྲོཀྟཱཿ སཪྻྭཱཿ ཀཐཱ ཛྙཱཔིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ཏཙྪྲུཏྭཱ སཪྻྭ ཨེཀཙིཏྟཱིབྷཱུཡ ཨཱིཤྭརམུདྡིཤྱ པྲོཙྩཻརེཏཏ྄ པྲཱརྠཡནྟ, ཧེ པྲབྷོ གགཎཔྲྀཐིཝཱིཔཡོདྷཱིནཱཾ ཏེཥུ ཙ ཡདྱད྄ ཨཱསྟེ ཏེཥཱཾ སྲཥྚེཤྭརསྟྭཾ། ");
INSERT INTO santib_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ཏྭཾ ནིཛསེཝཀེན དཱཡཱུདཱ ཝཱཀྱམིདམ྄ ཨུཝཙིཐ, མནུཥྱཱ ཨནྱདེཤཱིཡཱཿ ཀུཪྻྭནྟི ཀལཧཾ ཀུཏཿ། ལོཀཱཿ སཪྻྭེ ཀིམརྠཾ ཝཱ ཙིནྟཱཾ ཀུཪྻྭནྟི ནིཥྥལཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","པརམེཤསྱ ཏེནཻཝཱབྷིཥིཀྟསྱ ཛནསྱ ཙ། ཝིརུདྡྷམབྷིཏིཥྛནྟི པྲྀཐིཝྱཱཿ པཏཡཿ ཀུཏཿ༎ ");
INSERT INTO santib_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ཕལཏསྟཝ ཧསྟེན མནྟྲཎཡཱ ཙ པཱུཪྻྭ ཡདྱཏ྄ སྠིརཱིཀྲྀཏཾ ཏད྄ ཡཐཱ སིདྡྷཾ བྷཝཏི ཏདརྠཾ ཏྭཾ ཡམ྄ ཨཐིཥིཀྟཝཱན྄ ས ཨེཝ པཝིཏྲོ ཡཱིཤུསྟསྱ པྲཱཏིཀཱུལྱེན ཧེརོད྄ པནྟཱིཡཔཱིལཱཏོ ");
INSERT INTO santib_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","྅ནྱདེཤཱིཡལོཀཱ ཨིསྲཱཡེལློཀཱཤྩ སཪྻྭ ཨེཏེ སབྷཱཡཱམ྄ ཨཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ཧེ པརམེཤྭར ཨདྷུནཱ ཏེཥཱཾ ཏརྫནཾ གརྫནཉྩ ཤྲྀཎུ; ");
INSERT INTO santib_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ཏཐཱ སྭཱསྠྱཀརཎཀརྨྨཎཱ ཏཝ བཱཧུབལཔྲཀཱཤཔཱུཪྻྭཀཾ ཏཝ སེཝཀཱན྄ ནིརྦྷཡེན ཏཝ ཝཱཀྱཾ པྲཙཱརཡིཏུཾ ཏཝ པཝིཏྲཔུཏྲསྱ ཡཱིཤོ རྣཱམྣཱ ཨཱཤྩཪྻྱཱཎྱསམྦྷཝཱནི ཙ ཀརྨྨཱཎི ཀརྟྟུཉྩཱཛྙཱཔཡ། ");
INSERT INTO santib_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ཨིཏྠཾ པྲཱརྠནཡཱ ཡཏྲ སྠཱནེ ཏེ སབྷཱཡཱམ྄ ཨཱསན྄ ཏཏ྄ སྠཱནཾ པྲཱཀམྤཏ; ཏཏཿ སཪྻྭེ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཱཿ སནྟ ཨཱིཤྭརསྱ ཀཐཱམ྄ ཨཀྵོབྷེཎ པྲཱཙཱརཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ཨཔརཉྩ པྲཏྱཡཀཱརིལོཀསམཱུཧཱ ཨེཀམནས ཨེཀཙིཏྟཱིབྷཱུཡ སྠིཏཱཿ། ཏེཥཱཾ ཀེཔི ནིཛསམྤཏྟིཾ སྭཱིཡཱཾ ནཱཛཱནན྄ ཀིནྟུ ཏེཥཱཾ སཪྻྭཱཿ སམྤཏྟྱཿ སཱདྷཱརཎྱེན སྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ཨནྱཙྩ པྲེརིཏཱ མཧཱཤཀྟིཔྲཀཱཤཔཱུཪྻྭཀཾ པྲབྷོ ཪྻཱིཤོརུཏྠཱནེ སཱཀྵྱམ྄ ཨདདུཿ, ཏེཥུ སཪྻྭེཥུ མཧཱནུགྲཧོ྅བྷཝཙྩ། ");
INSERT INTO santib_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ཏེཥཱཾ མདྷྱེ ཀསྱཱཔི དྲཝྱནྱཱུནཏཱ ནཱབྷཝད྄ ཡཏསྟེཥཱཾ གྲྀཧབྷཱུམྱཱདྱཱ ཡཱཿ སམྤཏྟཡ ཨཱསན྄ ཏཱ ཝིཀྲཱིཡ ");
INSERT INTO santib_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ཏནྨཱུལྱམཱནཱིཡ པྲེརིཏཱནཱཾ ཙརཎེཥུ ཏཻཿ སྠཱཔིཏཾ; ཏཏཿ པྲཏྱེཀཤཿ པྲཡོཛནཱནུསཱརེཎ དཏྟམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ཝིཤེཥཏཿ ཀུཔྲོཔདྭཱིཔཱིཡོ ཡོསིནཱམཀོ ལེཝིཝཾཤཛཱཏ ཨེཀོ ཛནོ བྷཱུམྱདྷིཀཱརཱི, ཡཾ པྲེརིཏཱ བརྞབྦཱ ཨརྠཱཏ྄ སཱནྟྭནཱདཱཡཀ ཨིཏྱུཀྟྭཱ སམཱཧཱུཡན྄, ");
INSERT INTO santib_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ས ཛནོ ནིཛབྷཱུམིཾ ཝིཀྲཱིཡ ཏནྨཱུལྱམཱནཱིཡ པྲེརིཏཱནཱཾ ཙརཎེཥུ སྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ཏདཱ ཨནཱནིཡནཱམཀ ཨེཀོ ཛནོ ཡསྱ བྷཱཪྻྱཱཡཱ ནཱམ སཕཱིརཱ ས སྭཱདྷིཀཱརཾ ཝིཀྲཱིཡ ");
INSERT INTO santib_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","སྭབྷཱཪྻྱཱཾ ཛྙཱཔཡིཏྭཱ ཏནྨཱུལྱསྱཻཀཱཾཤཾ སངྒོཔྱ སྠཱཔཡིཏྭཱ ཏདནྱཱཾཤམཱཏྲམཱནཱིཡ པྲེརིཏཱནཱཾ ཙརཎེཥུ སམརྤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ཏསྨཱཏ྄ པིཏརོཀཐཡཏ྄ ཧེ ཨནཱནིཡ བྷཱུམེ རྨཱུལྱཾ ཀིཉྩིཏ྄ སངྒོཔྱ སྠཱཔཡིཏུཾ པཝིཏྲསྱཱཏྨནཿ སནྣིདྷཽ མྲྀཥཱཝཱཀྱཾ ཀཐཡིཏུཉྩ ཤཻཏཱན྄ ཀུཏསྟཝཱནྟཿཀརཎེ པྲཝྲྀཏྟིམཛནཡཏ྄? ");
INSERT INTO santib_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","སཱ བྷཱུམི ཪྻདཱ ཏཝ ཧསྟགཏཱ ཏདཱ ཀིཾ ཏཝ སྭཱིཡཱ ནཱསཱིཏ྄? ཏརྷི སྭཱནྟཿཀརཎེ ཀུཏ ཨེཏཱདྲྀཤཱི ཀུཀལྤནཱ ཏྭཡཱ ཀྲྀཏཱ? ཏྭཾ ཀེཝལམནུཥྱསྱ ནིཀཊེ མྲྀཥཱཝཱཀྱཾ ནཱཝཱདཱིཿ ཀིནྟྭཱིཤྭརསྱ ནིཀཊེ྅པི། ");
INSERT INTO santib_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཻཝ སོ྅ནཱནིཡོ བྷཱུམཽ པཏན྄ པྲཱཎཱན྄ ཨཏྱཛཏ྄, ཏདྭྲྀཏྟཱནྟཾ ཡཱཝནྟོ ལོཀཱ ཨཤྲྀཎྭན྄ ཏེཥཱཾ སཪྻྭེཥཱཾ མཧཱབྷཡམ྄ ཨཛཱཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ཏདཱ ཡུཝལོཀཱསྟཾ ཝསྟྲེཎཱཙྪཱདྱ བཧི རྣཱིཏྭཱ ཤྨཤཱནེ྅སྠཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ཏཏཿ པྲཧརཻཀཱནནྟརཾ ཀིཾ ཝྲྀཏྟཾ ཏནྣཱཝགཏྱ ཏསྱ བྷཱཪྻྱཱཔི ཏཏྲ སམུཔསྠིཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ཏཏཿ པིཏརསྟཱམ྄ ཨཔྲྀཙྪཏ྄, ཡུཝཱབྷྱཱམ྄ ཨེཏཱཝནྨུདྲཱབྷྱོ བྷཱུམི ཪྻིཀྲཱིཏཱ ན ཝཱ? ཨེཏཏྭཾ ཝད; ཏདཱ སཱ པྲཏྱཝཱདཱིཏ྄ སཏྱམ྄ ཨེཏཱཝདྦྷྱོ མུདྲཱབྷྱ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ཏཏཿ པིཏརོཀཐཡཏ྄ ཡུཝཱཾ ཀཐཾ པརམེཤྭརསྱཱཏྨཱནཾ པརཱིཀྵིཏུམ྄ ཨེཀམནྟྲཎཱཝབྷཝཏཱཾ? པཤྱ ཡེ ཏཝ པཏིཾ ཤྨཤཱནེ སྠཱཔིཏཝནྟསྟེ དྭཱརསྱ སམཱིཔེ སམུཔཏིཥྛནྟི ཏྭཱམཔི བཧིརྣེཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ཏཏཿ སཱཔི ཏསྱ ཙརཎསནྣིདྷཽ པཏིཏྭཱ པྲཱཎཱན྄ ཨཏྱཱཀྵཱིཏ྄། པཤྩཱཏ྄ ཏེ ཡུཝཱནོ྅བྷྱནྟརམ྄ ཨཱགཏྱ ཏཱམཔི མྲྀཏཱཾ དྲྀཥྚྭཱ བཧི རྣཱིཏྭཱ ཏསྱཱཿ པཏྱུཿ པཱརྴྭེ ཤྨཤཱནེ སྠཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ཏསྨཱཏ྄ མཎྜལྱཱཿ སཪྻྭེ ལོཀཱ ཨནྱལོཀཱཤྩ ཏཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱ སཱདྷྭསཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ཏཏཿ པརཾ པྲེརིཏཱནཱཾ ཧསྟཻ རློཀཱནཱཾ མདྷྱེ བཧྭཱཤྩཪྻྱཱཎྱདྦྷུཏཱནི ཀརྨྨཱཎྱཀྲིཡནྟ; ཏདཱ ཤིཥྱཱཿ སཪྻྭ ཨེཀཙིཏྟཱིབྷཱུཡ སུལེམཱནོ ྅ལིནྡེ སམྦྷཱུཡཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ཏེཥཱཾ སངྒྷཱནྟརྒོ བྷཝིཏུཾ ཀོཔི པྲགལྦྷཏཱཾ ནཱགམཏ྄ ཀིནྟུ ལོཀཱསྟཱན྄ སམཱདྲིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","སྟྲིཡཿ པུརུཥཱཤྩ བཧཝོ ལོཀཱ ཝིཤྭཱསྱ པྲབྷུཾ ཤརཎམཱཔནྣཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","པིཏརསྱ གམནཱགམནཱབྷྱཱཾ ཀེནཱཔི པྲཀཱརེཎ ཏསྱ ཚཱཡཱ ཀསྨིཾཤྩིཛྫནེ ལགིཥྱཏཱིཏྱཱཤཡཱ ལོཀཱ རོགིཎཿ ཤིཝིཀཡཱ ཁཊྭཡཱ ཙཱནཱིཡ པཐི པཐི སྠཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ཙཏུརྡིཀྶྠནགརེབྷྱོ བཧཝོ ལོཀཱཿ སམྦྷཱུཡ རོགིཎོ྅པཝིཏྲབྷུཏགྲསྟཱཾཤྩ ཡིརཱུཤཱལམམ྄ ཨཱནཡན྄ ཏཏཿ སཪྻྭེ སྭསྠཱ ཨཀྲིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ཨནནྟརཾ མཧཱཡཱཛཀཿ སིདཱུཀིནཱཾ མཏགྲཱཧིཎསྟེཥཱཾ སཧཙརཱཤྩ ");
INSERT INTO santib_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","མཧཱཀྲོདྷཱནྟྭིཏཱཿ སནྟཿ པྲེརིཏཱན྄ དྷྲྀཏྭཱ ནཱིཙལོཀཱནཱཾ ཀཱརཱཡཱཾ བདྡྷྭཱ སྠཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ཀིནྟུ རཱཏྲཽ པརམེཤྭརསྱ དཱུཏཿ ཀཱརཱཡཱ དྭཱརཾ མོཙཡིཏྭཱ ཏཱན྄ བཧིརཱནཱིཡཱཀཐཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ཡཱུཡཾ གཏྭཱ མནྡིརེ དཎྜཱཡམཱནཱཿ སནྟོ ལོཀཱན྄ པྲཏཱིམཱཾ ཛཱིཝནདཱཡིཀཱཾ སཪྻྭཱཾ ཀཐཱཾ པྲཙཱརཡཏ། ");
INSERT INTO santib_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ཨིཏི ཤྲུཏྭཱ ཏེ པྲཏྱཱུཥེ མནྡིར ཨུཔསྠཱཡ ཨུཔདིཥྚཝནྟཿ། ཏདཱ སཧཙརགཎེན སཧིཏོ མཧཱཡཱཛཀ ཨཱགཏྱ མནྟྲིགཎམ྄ ཨིསྲཱཡེལྭཾཤསྱ སཪྻྭཱན྄ རཱཛསབྷཱསདཿ སབྷཱསྠཱན྄ ཀྲྀཏྭཱ ཀཱརཱཡཱསྟཱན྄ ཨཱཔཡིཏུཾ པདཱཏིགཎཾ པྲེརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ཏཏསྟེ གཏྭཱ ཀཱརཱཡཱཾ ཏཱན྄ ཨཔྲཱཔྱ པྲཏྱཱགཏྱ ཨིཏི ཝཱརྟྟཱམ྄ ཨཝཱདིཥུཿ, ");
INSERT INTO santib_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ཝཡཾ ཏཏྲ གཏྭཱ ནིཪྻྭིགྷྣཾ ཀཱརཱཡཱ དྭཱརཾ རུདྡྷཾ རཀྵཀཱཾཤྩ དྭཱརསྱ བཧིརྡཎྜཱཡམཱནཱན྄ ཨདརྴཱམ ཨེཝ ཀིནྟུ དྭཱརཾ མོཙཡིཏྭཱ ཏནྨདྷྱེ ཀམཔི དྲཥྚུཾ ན པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ མཧཱཡཱཛཀོ མནྡིརསྱ སེནཱཔཏིཿ པྲདྷཱནཡཱཛཀཱཤྩ, ཨིཏ པརཾ ཀིམཔརཾ བྷཝིཥྱཏཱིཏི ཙིནྟཡིཏྭཱ སནྡིགྡྷཙིཏྟཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ཨེཏསྨིནྣེཝ སམཡེ ཀཤྩིཏ྄ ཛན ཨཱགཏྱ ཝཱརྟྟཱམེཏཱམ྄ ཨཝདཏ྄ པཤྱཏ ཡཱུཡཾ ཡཱན྄ མཱནཝཱན྄ ཀཱརཱཡཱམ྄ ཨསྠཱཔཡཏ ཏེ མནྡིརེ ཏིཥྛནྟོ ལོཀཱན྄ ཨུཔདིཤནྟི། ");
INSERT INTO santib_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ཏདཱ མནྡིརསྱ སེནཱཔཏིཿ པདཱཏཡཤྩ ཏཏྲ གཏྭཱ ཙེལློཀཱཿ པཱཥཱཎཱན྄ ནིཀྵིཔྱཱསྨཱན྄ མཱརཡནྟཱིཏི བྷིཡཱ ཝིནཏྱཱཙཱརཾ ཏཱན྄ ཨཱནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ཏེ མཧཱསབྷཱཡཱ མདྷྱེ ཏཱན྄ ཨསྠཱཔཡན྄ ཏཏཿ པརཾ མཧཱཡཱཛཀསྟཱན྄ ཨཔྲྀཙྪཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ཨནེན ནཱམྣཱ སམུཔདེཥྚུཾ ཝཡཾ ཀིཾ དྲྀཌྷཾ ན ནྱཥེདྷཱམ? ཏཐཱཔི པཤྱཏ ཡཱུཡཾ སྭེཥཱཾ ཏེནོཔདེཤེནེ ཡིརཱུཤཱལམཾ པརིཔཱུརྞཾ ཀྲྀཏྭཱ ཏསྱ ཛནསྱ རཀྟཔཱཏཛནིཏཱཔརཱདྷམ྄ ཨསྨཱན྄ པྲཏྱཱནེཏུཾ ཙེཥྚདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ཏཏཿ པིཏརོནྱཔྲེརིཏཱཤྩ པྲཏྱཝདན྄ མཱནུཥསྱཱཛྙཱགྲཧཎཱད྄ ཨཱིཤྭརསྱཱཛྙཱགྲཧཎམ྄ ཨསྨཱཀམུཙིཏམ྄། ");
INSERT INTO santib_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ཡཾ ཡཱིཤུཾ ཡཱུཡཾ ཀྲུཤེ ཝེདྷིཏྭཱཧཏ ཏམ྄ ཨསྨཱཀཾ པཻཏྲྀཀ ཨཱིཤྭར ཨུཏྠཱཔྱ ");
INSERT INTO santib_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ཨིསྲཱཡེལྭཾཤཱནཱཾ མནཿཔརིཝརྟྟནཾ པཱཔཀྵམཱཉྩ ཀརྟྟུཾ རཱཛཱནཾ པརིཏྲཱཏཱརཉྩ ཀྲྀཏྭཱ སྭདཀྵིཎཔཱརྴྭེ ཏསྱཱནྣཏིམ྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ཨེཏསྨིན྄ ཝཡམཔི སཱཀྵིཎ ཨཱསྨཧེ, ཏཏ྄ ཀེཝལཾ ནཧི, ཨཱིཤྭར ཨཱཛྙཱགྲཱཧིབྷྱོ ཡཾ པཝིཏྲམ྄ ཨཱཏྨནཾ དཏྟཝཱན྄ སོཔི སཱཀྵྱསྟི། ");
INSERT INTO santib_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ཨེཏདྭཱཀྱེ ཤྲུཏེ ཏེཥཱཾ ཧྲྀདཡཱནི ཝིདྡྷཱནྱབྷཝན྄ ཏཏསྟེ ཏཱན྄ ཧནྟུཾ མནྟྲིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ཨེཏསྨིནྣེཝ སམཡེ ཏཏྶབྷཱསྠཱནཱཾ སཪྻྭལོཀཱནཱཾ མདྷྱེ སུཁྱཱཏོ གམིལཱིཡེལྣཱམཀ ཨེཀོ ཛནོ ཝྱཝསྠཱཔཀཿ ཕིརཱུཤིལོཀ ཨུཏྠཱཡ པྲེརིཏཱན྄ ཀྵཎཱརྠཾ སྠཱནཱནྟརཾ གནྟུམ྄ ཨཱདིཤྱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ཧེ ཨིསྲཱཡེལྭཾཤཱིཡཱཿ སཪྻྭེ ཡཱུཡམ྄ ཨེཏཱན྄ མཱནུཥཱན྄ པྲཏི ཡཏ྄ ཀརྟྟུམ྄ ཨུདྱཏཱསྟསྨིན྄ སཱཝདྷཱནཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ཨིཏཿ པཱུཪྻྭཾ ཐཱུདཱནཱམཻཀོ ཛན ཨུཔསྠཱཡ སྭཾ ཀམཔི མཧཱཔུརུཥམ྄ ཨཝདཏ྄, ཏཏཿ པྲཱཡེཎ ཙཏུཿཤཏལོཀཱསྟསྱ མཏགྲཱཧིཎོབྷཝན྄ པཤྩཱཏ྄ ས ཧཏོབྷཝཏ྄ ཏསྱཱཛྙཱགྲཱཧིཎོ ཡཱཝནྟོ ལོཀཱསྟེ སཪྻྭེ ཝིརྐཱིརྞཱཿ སནྟོ ྅ཀྲྀཏཀཱཪྻྱཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ཏསྨཱཛྫནཱཏ྄ པརཾ ནཱམལེཁནསམཡེ གཱལཱིལཱིཡཡིཧཱུདཱནཱམཻཀོ ཛན ཨུཔསྠཱཡ བཧཱུལློཀཱན྄ སྭམཏཾ གྲཱཧཱིཏཝཱན྄ ཏཏཿ སོཔི ཝྱནཤྱཏ྄ ཏསྱཱཛྙཱགྲཱཧིཎོ ཡཱཝནྟོ ལོཀཱ ཨཱསན྄ ཏེ སཪྻྭེ ཝིཀཱིརྞཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ཨདྷུནཱ ཝདཱམི, ཡཱུཡམ྄ ཨེཏཱན྄ མནུཥྱཱན྄ པྲཏི ཀིམཔི ན ཀྲྀཏྭཱ ཀྵཱནྟཱ བྷཝཏ, ཡཏ ཨེཥ སངྐལྤ ཨེཏཏ྄ ཀརྨྨ ཙ ཡདི མནུཥྱཱདབྷཝཏ྄ ཏརྷི ཝིཕལཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ཡདཱིཤྭརཱདབྷཝཏ྄ ཏརྷི ཡཱུཡཾ ཏསྱཱནྱཐཱ ཀརྟྟུཾ ན ཤཀྵྱཐ, ཝརམ྄ ཨཱིཤྭརརོདྷཀཱ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ཏདཱ ཏསྱ མནྟྲཎཱཾ སྭཱིཀྲྀཏྱ ཏེ པྲེརིཏཱན྄ ཨཱཧཱུཡ པྲཧྲྀཏྱ ཡཱིཤོ རྣཱམྣཱ ཀཱམཔི ཀཐཱཾ ཀཐཡིཏུཾ ནིཥིདྷྱ ཝྱསརྫན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ཀིནྟུ ཏསྱ ནཱམཱརྠཾ ཝཡཾ ལཛྫཱབྷོགསྱ ཡོགྱཏྭེན གཎིཏཱ ཨིཏྱཏྲ ཏེ སཱནནྡཱཿ སནྟཿ སབྷཱསྠཱནཱཾ སཱཀྵཱད྄ ཨགཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ཏཏཿ པརཾ པྲཏིདིནཾ མནྡིརེ གྲྀཧེ གྲྀཧེ ཙཱཝིཤྲཱམམ྄ ཨུཔདིཤྱ ཡཱིཤུཁྲཱིཥྚསྱ སུསཾཝཱདཾ པྲཙཱརིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ཏསྨིན྄ སམཡེ ཤིཥྱཱཎཱཾ བཱཧུལྱཱཏ྄ པྲཱཏྱཧིཀདཱནསྱ ཝིཤྲཱཎནཻ རྦྷིནྣདེཤཱིཡཱནཱཾ ཝིདྷཝཱསྟྲཱིགཎ ཨུཔེཀྵིཏེ སཏི ཨིབྲཱིཡལོཀཻཿ སཧཱནྱདེཤཱིཡཱནཱཾ ཝིཝཱད ཨུཔཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ཏདཱ དྭཱདཤཔྲེརིཏཱཿ སཪྻྭཱན྄ ཤིཥྱཱན྄ སཾགྲྀཧྱཱཀཐཡན྄ ཨཱིཤྭརསྱ ཀཐཱཔྲཙཱརཾ པརིཏྱཛྱ བྷོཛནགཝེཥཎམ྄ ཨསྨཱཀམ྄ ཨུཙིཏཾ ནཧི། ");
INSERT INTO santib_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ཨཏོ ཧེ བྷྲཱཏྲྀགཎ ཝཡམ྄ ཨེཏཏྐརྨྨཎོ བྷཱརཾ ཡེབྷྱོ དཱཏུཾ ཤཀྣུམ ཨེཏཱདྲྀཤཱན྄ སུཁྱཱཏྱཱཔནྣཱན྄ པཝིཏྲེཎཱཏྨནཱ ཛྙཱནེན ཙ པཱུརྞཱན྄ སཔྤྲཛནཱན྄ ཡཱུཡཾ སྭེཥཱཾ མདྷྱེ མནོནཱིཏཱན྄ ཀུརུཏ, ");
INSERT INTO santib_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ཀིནྟུ ཝཡཾ པྲཱརྠནཱཡཱཾ ཀཐཱཔྲཙཱརཀརྨྨཎི ཙ ནིཏྱཔྲཝྲྀཏྟཱཿ སྠཱསྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ཨེཏསྱཱཾ ཀཐཱཡཱཾ སཪྻྭེ ལོཀཱཿ སནྟུཥྚཱཿ སནྟཿ སྭེཥཱཾ མདྷྱཱཏ྄ སྟིཕཱནཿ ཕིལིཔཿ པྲཁརོ ནིཀཱནོར྄ ཏཱིམན྄ པརྨྨིཎཱ ཡིཧཱུདིམཏགྲཱཧཱི-ཨཱནྟིཡཁིཡཱནགརཱིཡོ ནིཀལཱ ཨེཏཱན྄ པརམབྷཀྟཱན྄ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཱན྄ སཔྟ ཛནཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","པྲེརིཏཱནཱཾ སམཀྵམ྄ ཨཱནཡན྄, ཏཏསྟེ པྲཱརྠནཱཾ ཀྲྀཏྭཱ ཏེཥཱཾ ཤིརཿསུ ཧསྟཱན྄ ཨཱརྤཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ཨཔརཉྩ ཨཱིཤྭརསྱ ཀཐཱ དེཤཾ ཝྱཱཔྣོཏ྄ ཝིཤེཥཏོ ཡིརཱུཤཱལམི ནགརེ ཤིཥྱཱཎཱཾ སཾཁྱཱ པྲབྷཱུཏརཱུཔེཎཱཝརྡྡྷཏ ཡཱཛཀཱནཱཾ མདྷྱེཔི བཧཝཿ ཁྲཱིཥྚམཏགྲཱཧིཎོ྅བྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","སྟིཕཱནོे ཝིཤྭཱསེན པརཱཀྲམེཎ ཙ པརིཔཱུརྞཿ སན྄ ལོཀཱནཱཾ མདྷྱེ བཧུཝིདྷམ྄ ཨདྦྷུཏམ྄ ཨཱཤྩཪྻྱཾ ཀརྨྨཱཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ཏེན ལིབརྟྟིནཱིཡནཱམྣཱ ཝིཁྱཱཏསངྒྷསྱ ཀཏིཔཡཛནཱཿ ཀུརཱིཎཱིཡསིཀནྡརཱིཡ-ཀིལིཀཱིཡཱཤཱིཡཱདེཤཱིཡཱཿ ཀིཡནྟོ ཛནཱཤྩོཏྠཱཡ སྟིཕཱནེན སཱརྡྡྷཾ ཝྱཝདནྟ། ");
INSERT INTO santib_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ཀིནྟུ སྟིཕཱནོ ཛྙཱནེན པཝིཏྲེཎཱཏྨནཱ ཙ ཨཱིདྲྀཤཱིཾ ཀཐཱཾ ཀཐིཏཝཱན྄ ཡསྱཱསྟེ ཨཱཔཏྟིཾ ཀརྟྟུཾ ནཱཤཀྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","པཤྩཱཏ྄ ཏཻ རློབྷིཏཱཿ ཀཏིཔཡཛནཱཿ ཀཐཱམེནཱམ྄ ཨཀཐཡན྄, ཝཡཾ ཏསྱ མུཁཏོ མཱུསཱ ཨཱིཤྭརསྱ ཙ ནིནྡཱཝཱཀྱམ྄ ཨཤྲཽཥྨ། ");
INSERT INTO santib_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ཏེ ལོཀཱནཱཾ ལོཀཔྲཱཙཱིནཱནཱམ྄ ཨདྷྱཱཔཀཱནཱཉྩ པྲཝྲྀཏྟིཾ ཛནཡིཏྭཱ སྟིཕཱནསྱ སནྣིདྷིམ྄ ཨཱགཏྱ ཏཾ དྷྲྀཏྭཱ མཧཱསབྷཱམདྷྱམ྄ ཨཱནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ཏདནནྟརཾ ཀཏིཔཡཛནེཥུ མིཐྱཱསཱཀྵིཥུ སམཱནཱིཏེཥུ ཏེ྅ཀཐཡན྄ ཨེཥ ཛན ཨེཏཏྤུཎྱསྠཱནཝྱཝསྠཡོ རྣིནྡཱཏཿ ཀདཱཔི ན ནིཝརྟྟཏེ། ");
INSERT INTO santib_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ཕལཏོ ནཱསརཏཱིཡཡཱིཤུཿ སྠཱནམེཏད྄ ཨུཙྪིནྣཾ ཀརིཥྱཏི མཱུསཱསམརྤིཏམ྄ ཨསྨཱཀཾ ཝྱཝཧརཎམ྄ ཨནྱརཱུཔཾ ཀརིཥྱཏི ཏསྱཻཏཱདྲྀཤཱིཾ ཀཐཱཾ ཝཡམ྄ ཨཤྲྀཎུམ། ");
INSERT INTO santib_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ཏདཱ མཧཱསབྷཱསྠཱཿ སཪྻྭེ ཏཾ པྲཏི སྠིརཱཾ དྲྀཥྚིཾ ཀྲྀཏྭཱ སྭརྒདཱུཏམུཁསདྲྀཤཾ ཏསྱ མུཁམ྄ ཨཔཤྱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ཏཏཿ པརཾ མཧཱཡཱཛཀཿ པྲྀཥྚཝཱན྄, ཨེཥཱ ཀཐཱཾ ཀིཾ སཏྱཱ? ");
INSERT INTO santib_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ཏཏཿ ས པྲཏྱཝདཏ྄, ཧེ པིཏརོ ཧེ བྷྲཱཏརཿ སཪྻྭེ ལཱཀཱ མནཱཾསི ནིདྷདྡྷྭཾ། ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥ ཨིབྲཱཧཱིམ྄ ཧཱརཎྣགརེ ཝཱསཀརཎཱཏ྄ པཱུཪྻྭཾ ཡདཱ ཨརཱམ྄-ནཧརཡིམདེཤེ ཨཱསཱིཏ྄ ཏདཱ ཏེཛོམཡ ཨཱིཤྭརོ དརྴནཾ དཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ཏམཝདཏ྄ ཏྭཾ སྭདེཤཛྙཱཏིམིཏྲཱཎི པརིཏྱཛྱ ཡཾ དེཤམཧཾ དརྴཡིཥྱཱམི ཏཾ དེཤཾ ཝྲཛ། ");
INSERT INTO santib_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ཨཏཿ ས ཀསྡཱིཡདེཤཾ ཝིཧཱཡ ཧཱརཎྣགརེ ནྱཝསཏ྄, ཏདནནྟརཾ ཏསྱ པིཏརི མྲྀཏེ ཡཏྲ དེཤེ ཡཱུཡཾ ནིཝསཐ ས ཨེནཾ དེཤམཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ཀིནྟྭཱིཤྭརསྟསྨཻ ཀམཔྱདྷིཀཱརམ྄ ཨརྠཱད྄ ཨེཀཔདཔརིམིཏཱཾ བྷཱུམིམཔི ནཱདདཱཏ྄; ཏདཱ ཏསྱ ཀོཔི སནྟཱནོ ནཱསཱིཏ྄ ཏཐཱཔི སནྟཱནཻཿ སཱརྡྡྷམ྄ ཨེཏསྱ དེཤསྱཱདྷིཀཱརཱི ཏྭཾ བྷཝིཥྱསཱིཏི ཏམྤྲཏྱངྒཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ཨཱིཤྭར ཨིཏྠམ྄ ཨཔརམཔི ཀཐིཏཝཱན྄ ཏཝ སནྟཱནཱཿ པརདེཤེ ནིཝཏྶྱནྟི ཏཏསྟདྡེཤཱིཡལོཀཱཤྩཏུཿཤཏཝཏྶརཱན྄ ཡཱཝཏ྄ ཏཱན྄ དཱསཏྭེ སྠཱཔཡིཏྭཱ ཏཱན྄ པྲཏི ཀུཝྱཝཧཱརཾ ཀརིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ཨཔརམ྄ ཨཱིཤྭར ཨེནཱཾ ཀཐཱམཔི ཀཐིཏཝཱན྄, ཡེ ལོཀཱསྟཱན྄ དཱསཏྭེ སྠཱཔཡིཥྱནྟི ཏཱལློཀཱན྄ ཨཧཾ དཎྜཡིཥྱཱམི, ཏཏཿ པརཾ ཏེ བཧིརྒཏཱཿ སནྟོ མཱམ྄ ཨཏྲ སྠཱནེ སེཝིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","པཤྩཱཏ྄ ས ཏསྨཻ ཏྭཀྪེདསྱ ནིཡམཾ དཏྟཝཱན྄, ཨཏ ཨིསྷཱཀནཱམྣི ཨིབྲཱཧཱིམ ཨེཀཔུཏྲེ ཛཱཏེ, ཨཥྚམདིནེ ཏསྱ ཏྭཀྪེདམ྄ ཨཀརོཏ྄། ཏསྱ ཨིསྷཱཀཿ པུཏྲོ ཡཱཀཱུབ྄, ཏཏསྟསྱ ཡཱཀཱུབོ྅སྨཱཀཾ དྭཱདཤ པཱུཪྻྭཔུརུཥཱ ཨཛཱཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ཏེ པཱུཪྻྭཔུརུཥཱ ཨཱིརྵྱཡཱ པརིཔཱུརྞཱ མིསརདེཤཾ པྲེཥཡིཏུཾ ཡཱུཥཕཾ ཝྱཀྲཱིཎན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ཀིནྟྭཱིཤྭརསྟསྱ སཧཱཡོ བྷཱུཏྭཱ སཪྻྭསྱཱ དུརྒཏེ རཀྵིཏྭཱ ཏསྨཻ བུདྡྷིཾ དཏྟྭཱ མིསརདེཤསྱ རཱཛྙཿ ཕིརཽཎཿ པྲིཡཔཱཏྲཾ ཀྲྀཏཝཱན྄ ཏཏོ རཱཛཱ མིསརདེཤསྱ སྭཱིཡསཪྻྭཔརིཝཱརསྱ ཙ ཤཱསནཔདཾ ཏསྨཻ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ཏསྨིན྄ སམཡེ མིསར-ཀིནཱནདེཤཡོ རྡུརྦྷིཀྵཧེཏོརཏིཀླིཥྚཏྭཱཏ྄ ནཿ པཱུཪྻྭཔུརུཥཱ བྷཀྵྱདྲཝྱཾ ནཱལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ཀིནྟུ མིསརདེཤེ ཤསྱཱནི སནྟི, ཡཱཀཱུབ྄ ཨིམཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱ པྲཐམམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱན྄ མིསརཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ཏཏོ དྭིཏཱིཡཝཱརགམནེ ཡཱུཥཕ྄ སྭབྷྲཱཏྲྀབྷིཿ པརིཙིཏོ྅བྷཝཏ྄; ཡཱུཥཕོ བྷྲཱཏརཿ ཕིརཽཎ྄ རཱཛེན པརིཙིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ཨནནྟརཾ ཡཱུཥཕ྄ བྷྲཱཏྲྀགཎཾ པྲེཥྱ ནིཛཔིཏརཾ ཡཱཀཱུབཾ ནིཛཱན྄ པཉྩཱདྷིཀསཔྟཏིསཾཁྱཀཱན྄ ཛྙཱཏིཛནཱཾཤྩ སམཱཧཱུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ཏསྨཱད྄ ཡཱཀཱུབ྄ མིསརདེཤཾ གཏྭཱ སྭཡམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱཤྩ ཏསྨིན྄ སྠཱནེ྅མྲིཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ཏཏསྟེ ཤིཁིམཾ ནཱིཏཱ ཡཏ྄ ཤྨཤཱནམ྄ ཨིབྲཱཧཱིམ྄ མུདྲཱདཏྭཱ ཤིཁིམཿ པིཏུ རྷམོརཿ པུཏྲེབྷྱཿ ཀྲཱིཏཝཱན྄ ཏཏྴྨཤཱནེ སྠཱཔཡཱཉྩཀྲིརེ། ");
INSERT INTO santib_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ཏཏཿ པརམ྄ ཨཱིཤྭར ཨིབྲཱཧཱིམཿ སནྣིདྷཽ ཤཔཐཾ ཀྲྀཏྭཱ ཡཱཾ པྲཏིཛྙཱཾ ཀྲྀཏཝཱན྄ ཏསྱཱཿ པྲཏིཛྙཱཡཱཿ ཕལནསམཡེ ནིཀཊེ སཏི ཨིསྲཱཡེལློཀཱ སིམརདེཤེ ཝརྡྡྷམཱནཱ བཧུསཾཁྱཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ཤེཥེ ཡཱུཥཕཾ ཡོ ན པརིཙིནོཏི ཏཱདྲྀཤ ཨེཀོ ནརཔཏིརུཔསྠཱཡ ");
INSERT INTO santib_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ཨསྨཱཀཾ ཛྙཱཏིབྷིཿ སཱརྡྡྷཾ དྷཱུརྟྟཏཱཾ ཝིདྷཱཡ པཱུཪྻྭཔུརུཥཱན྄ པྲཏི ཀུཝྱཝཧརཎཔཱུཪྻྭཀཾ ཏེཥཱཾ ཝཾཤནཱཤནཱཡ ཏེཥཱཾ ནཝཛཱཏཱན྄ ཤིཤཱུན྄ བཧི རྣིརཀྵེཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ཨེཏསྨིན྄ སམཡེ མཱུསཱ ཛཛྙེ, ས ཏུ པརམསུནྡརོ྅བྷཝཏ྄ ཏཐཱ པིཏྲྀགྲྀཧེ མཱསཏྲཡཔཪྻྱནྟཾ པཱལིཏོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ཀིནྟུ ཏསྨིན྄ བཧིརྣིཀྵིཔྟེ སཏི ཕིརཽཎརཱཛསྱ ཀནྱཱ ཏམ྄ ཨུཏྟོལྱ ནཱིཏྭཱ དཏྟཀཔུཏྲཾ ཀྲྀཏྭཱ པཱལིཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ཏསྨཱཏ྄ ས མཱུསཱ མིསརདེཤཱིཡཱཡཱཿ སཪྻྭཝིདྱཱཡཱཿ པཱརདྲྀཥྭཱ སན྄ ཝཱཀྱེ ཀྲིཡཱཡཱཉྩ ཤཀྟིམཱན྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ས སམྤཱུརྞཙཏྭཱརིཾཤདྭཏྶརཝཡསྐོ བྷཱུཏྭཱ ཨིསྲཱཡེལཱིཡཝཾཤནིཛབྷྲཱཏྲྀན྄ སཱཀྵཱཏ྄ ཀརྟུཾ མཏིཾ ཙཀྲེ། ");
INSERT INTO santib_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ཏེཥཱཾ ཛནམེཀཾ ཧིཾསིཏཾ དྲྀཥྚྭཱ ཏསྱ སཔཀྵཿ སན྄ ཧིཾསིཏཛནམ྄ ཨུཔཀྲྀཏྱ མིསརཱིཡཛནཾ ཛགྷཱན། ");
INSERT INTO santib_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ཏསྱ ཧསྟེནེཤྭརསྟཱན྄ ཨུདྡྷརིཥྱཏི ཏསྱ བྷྲཱཏྲྀགཎ ཨིཏི ཛྙཱསྱཏི ས ཨིཏྱནུམཱནཾ ཙཀཱར, ཀིནྟུ ཏེ ན བུབུདྷིརེ། ");
INSERT INTO santib_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ཏཏྤརེ ྅ཧནི ཏེཥཱམ྄ ཨུབྷཡོ རྫནཡོ ཪྻཱཀྐལཧ ཨུཔསྠིཏེ སཏི མཱུསཱཿ སམཱིཔཾ གཏྭཱ ཏཡོ རྨེལནཾ ཀརྟྟུཾ མཏིཾ ཀྲྀཏྭཱ ཀཐཡཱམཱས, ཧེ མཧཱཤཡཽ ཡུཝཱཾ བྷྲཱཏརཽ པརསྤརམ྄ ཨནྱཱཡཾ ཀུཏཿ ཀུརུཐཿ? ");
INSERT INTO santib_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ཏཏཿ སམཱིཔཝཱསིནཾ པྲཏི ཡོ ཛནོ྅ནྱཱཡཾ ཙཀཱར ས ཏཾ དཱུརཱིཀྲྀཏྱ ཀཐཡཱམཱས, ཨསྨཱཀམུཔརི ཤཱསྟྲྀཏྭཝིཙཱརཡིཏྲྀཏྭཔདཡོཿ ཀསྟྭཱཾ ནིཡུཀྟཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ཧྱོ ཡཐཱ མིསརཱིཡཾ ཧཏཝཱན྄ ཏཐཱ ཀིཾ མཱམཔི ཧནིཥྱསི? ");
INSERT INTO santib_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ཏདཱ མཱུསཱ ཨེཏཱདྲྀཤཱིཾ ཀཐཱཾ ཤྲུཏྭཱ པལཱཡནཾ ཙཀྲེ, ཏཏོ མིདིཡནདེཤཾ གཏྭཱ པྲཝཱསཱི སན྄ ཏསྠཽ, ཏཏསྟཏྲ དྭཽ པུཏྲཽ ཛཛྙཱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ཨནནྟརཾ ཙཏྭཱརིཾཤདྭཏྶརེཥུ གཏེཥུ སཱིནཡཔཪྻྭཏསྱ པྲཱནྟརེ པྲཛྭལིཏསྟམྦསྱ ཝཧྣིཤིཁཱཡཱཾ པརམེཤྭརདཱུཏསྟསྨཻ དརྴནཾ དདཽ། ");
INSERT INTO santib_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","མཱུསཱསྟསྨིན྄ དརྴནེ ཝིསྨཡཾ མཏྭཱ ཝིཤེཥཾ ཛྙཱཏུཾ ནིཀཊཾ གཙྪཏི, ");
INSERT INTO santib_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ཨེཏསྨིན྄ སམཡེ, ཨཧཾ ཏཝ པཱུཪྻྭཔུརུཥཱཎཱམ྄ ཨཱིཤྭརོ྅རྠཱད྄ ཨིབྲཱཧཱིམ ཨཱིཤྭར ཨིསྷཱཀ ཨཱིཤྭརོ ཡཱཀཱུབ ཨཱིཤྭརཤྩ, མཱུསཱམུདྡིཤྱ པརམེཤྭརསྱཻཏཱདྲྀཤཱི ཝིཧཱཡསཱིཡཱ ཝཱཎཱི བབྷཱུཝ, ཏཏཿ ས ཀམྤཱནྭིཏཿ སན྄ པུན རྣིརཱིཀྵིཏུཾ པྲགལྦྷོ ན བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","པརམེཤྭརསྟཾ ཛགཱད, ཏཝ པཱདཡོཿ པཱདུཀེ མོཙཡ ཡཏྲ ཏིཥྛསི སཱ པཝིཏྲབྷཱུམིཿ། ");
INSERT INTO santib_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ཨཧཾ མིསརདེཤསྠཱནཱཾ ནིཛལོཀཱནཱཾ དུརྡྡཤཱཾ ནིཏཱནྟམ྄ ཨཔཤྱཾ, ཏེཥཱཾ ཀཱཏཪྻྱོཀྟིཉྩ ཤྲུཏཝཱན྄ ཏསྨཱཏ྄ ཏཱན྄ ཨུདྡྷརྟྟུམ྄ ཨཝརུཧྱཱགམམ྄; ཨིདཱནཱིམ྄ ཨཱགཙྪ མིསརདེཤཾ ཏྭཱཾ པྲེཥཡཱམི། ");
INSERT INTO santib_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ཀསྟྭཱཾ ཤཱསྟྲྀཏྭཝིཙཱརཡིཏྲྀཏྭཔདཡོ རྣིཡུཀྟཝཱན྄, ཨིཏི ཝཱཀྱམུཀྟྭཱ ཏཻ ཪྻོ མཱུསཱ ཨཝཛྙཱཏསྟམེཝ ཨཱིཤྭརཿ སྟམྦམདྷྱེ དརྴནདཱཏྲཱ ཏེན དཱུཏེན ཤཱསྟཱརཾ མུཀྟིདཱཏཱརཉྩ ཀྲྀཏྭཱ པྲེཥཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ས ཙ མིསརདེཤེ སཱུཕྣཱམྣི སམུདྲེ ཙ པཤྩཱཏ྄ ཙཏྭཱརིཾཤདྭཏྶརཱན྄ ཡཱཝཏ྄ མཧཱཔྲཱནྟརེ ནཱནཱཔྲཀཱརཱཎྱདྦྷུཏཱནི ཀརྨྨཱཎི ལཀྵཎཱནི ཙ དརྴཡིཏྭཱ ཏཱན྄ བཧིཿ ཀྲྀཏྭཱ སམཱནིནཱཡ། ");
INSERT INTO santib_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","པྲབྷུཿ པརམེཤྭརོ ཡུཥྨཱཀཾ བྷྲཱཏྲྀགཎསྱ མདྷྱེ མཱདྲྀཤམ྄ ཨེཀཾ བྷཝིཥྱདྭཀྟཱརམ྄ ཨུཏྤཱདཡིཥྱཏི ཏསྱ ཀཐཱཡཱཾ ཡཱུཡཾ མནོ ནིདྷཱསྱཐ, ཡོ ཛན ཨིསྲཱཡེལཿ སནྟཱནེབྷྱ ཨེནཱཾ ཀཐཱཾ ཀཐཡཱམཱས ས ཨེཥ མཱུསཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","མཧཱཔྲཱནྟརསྠམཎྜལཱིམདྷྱེ྅པི ས ཨེཝ སཱིནཡཔཪྻྭཏོཔརི ཏེན སཱརྡྡྷཾ སཾལཱཔིནོ དཱུཏསྱ ཙཱསྨཏྤིཏྲྀགཎསྱ མདྷྱསྠཿ སན྄ ཨསྨབྷྱཾ དཱཏཝྱནི ཛཱིཝནདཱཡཀཱནི ཝཱཀྱཱནི ལེབྷེ། ");
INSERT INTO santib_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱསྟམ྄ ཨམཱནྱཾ ཀཏྭཱ སྭེབྷྱོ དཱུརཱིཀྲྀཏྱ མིསརདེཤཾ པརཱཝྲྀཏྱ གནྟུཾ མནོབྷིརབྷིལཥྱ ཧཱརོཎཾ ཛགདུཿ, ");
INSERT INTO santib_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ཨསྨཱཀམ྄ ཨགྲེ྅གྲེ གནྟུुམ྄ ཨསྨདརྠཾ དེཝགཎཾ ནིརྨྨཱཧི ཡཏོ ཡོ མཱུསཱ ཨསྨཱན྄ མིསརདེཤཱད྄ བཧིཿ ཀྲྀཏྭཱནཱིཏཝཱན྄ ཏསྱ ཀིཾ ཛཱཏཾ ཏདསྨཱབྷི རྣ ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ཏསྨིན྄ སམཡེ ཏེ གོཝཏྶཱཀྲྀཏིཾ པྲཏིམཱཾ ནིརྨྨཱཡ ཏཱམུདྡིཤྱ ནཻཝེདྱམུཏྨྲྀཛྱ སྭཧསྟཀྲྀཏཝསྟུནཱ ཨཱནནྡིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ཏསྨཱད྄ ཨཱིཤྭརསྟེཥཱཾ པྲཏི ཝིམུཁཿ སན྄ ཨཱཀཱཤསྠཾ ཛྱོཏིརྒཎཾ པཱུཛཡིཏུཾ ཏེབྷྱོ྅ནུམཏིཾ དདཽ, ཡཱདྲྀཤཾ བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ ལིཁིཏམཱསྟེ, ཡཐཱ, ཨིསྲཱཡེལཱིཡཝཾཤཱ རེ ཙཏྭཱརིཾཤཏྶམཱན྄ པུརཱ། མཧཏི པྲཱནྟརེ སཾསྠཱ ཡཱུཡནྟུ ཡཱནི ཙ། བལིཧོམཱདིཀརྨྨཱཎི ཀྲྀཏཝནྟསྟུ ཏཱནི ཀིཾ། མཱཾ སམུདྡིཤྱ ཡུཥྨཱབྷིཿ པྲཀྲྀཏཱནཱིཏི ནཻཝ ཙ། ");
INSERT INTO santib_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ཀིནྟུ ཝོ མོལཀཱཁྱསྱ དེཝསྱ དཱུཥྱམེཝ ཙ། ཡུཥྨཱཀཾ རིམྥནཱཁྱཱཡཱ དེཝཏཱཡཱཤྩ ཏཱརཀཱ། ཨེཏཡོརུབྷཡོ རྨཱུརྟཱི ཡུཥྨཱབྷིཿ པརིཔཱུཛིཏེ། ཨཏོ ཡུཥྨཱཾསྟུ བཱབེལཿ པཱརཾ ནེཥྱཱམི ནིཤྩིཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ཨཔརཉྩ ཡནྣིདརྴནམ྄ ཨཔཤྱསྟདནུསཱརེཎ དཱུཥྱཾ ནིརྨྨཱཧི ཡསྨིན྄ ཨཱིཤྭརོ མཱུསཱམ྄ ཨེཏདྭཱཀྱཾ བབྷཱཥེ ཏཏ྄ ཏསྱ ནིརཱུཔིཏཾ སཱཀྵྱསྭརཱུཔཾ དཱུཥྱམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཻཿ སཧ པྲཱནྟརེ ཏསྠཽ། ");
INSERT INTO santib_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","པཤྩཱཏ྄ ཡིཧོཤཱུཡེན སཧིཏཻསྟེཥཱཾ ཝཾཤཛཱཏཻརསྨཏྤཱུཪྻྭཔུརུཥཻཿ སྭེཥཱཾ སམྨུཁཱད྄ ཨཱིཤྭརེཎ དཱུརཱིཀྲྀཏཱནཱམ྄ ཨནྱདེཤཱིཡཱནཱཾ དེཤཱདྷིཀྲྀཏིཀཱལེ སམཱནཱིཏཾ ཏད྄ དཱུཥྱཾ དཱཡཱུདོདྷིཀཱརཾ ཡཱཝཏ྄ ཏཏྲ སྠཱན ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ས དཱཡཱུད྄ པརམེཤྭརསྱཱནུགྲཧཾ པྲཱཔྱ ཡཱཀཱུབ྄ ཨཱིཤྭརཱརྠམ྄ ཨེཀཾ དཱུཥྱཾ ནིརྨྨཱཏུཾ ཝཝཱཉྪ; ");
INSERT INTO santib_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ཀིནྟུ སུལེམཱན྄ ཏདརྠཾ མནྡིརམ྄ ཨེཀཾ ནིརྨྨིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ཏཐཱཔི ཡཿ སཪྻྭོཔརིསྠཿ ས ཀསྨིཾཤྩིད྄ ཧསྟཀྲྀཏེ མནྡིརེ ནིཝསཏཱིཏི ནཧི, བྷཝིཥྱདྭཱདཱི ཀཐཱམེཏཱཾ ཀཐཡཏི, ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","པརེཤོ ཝདཏི སྭརྒོ རཱཛསིཾཧཱསནཾ མམ། མདཱིཡཾ པཱདཔཱིཋཉྩ པྲྀཐིཝཱི བྷཝཏི དྷྲུཝཾ། ཏརྷི ཡཱུཡཾ ཀྲྀཏེ མེ ཀིཾ པྲནིརྨྨཱསྱཐ མནྡིརཾ། ཝིཤྲཱམཱཡ མདཱིཡཾ ཝཱ སྠཱནཾ ཀིཾ ཝིདྱཏེ ཏྭིཧ། ");
INSERT INTO santib_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","སཪྻྭཱཎྱེཏཱནི ཝསྟཱུནི ཀིཾ མེ ཧསྟཀྲྀཏཱནི ན༎ ");
INSERT INTO santib_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ཧེ ཨནཱཛྙཱགྲཱཧཀཱ ཨནྟཿཀརཎེ ཤྲཝཎེ ཙཱཔཝིཏྲལོཀཱཿ ཡཱུཡམ྄ ཨནཝརཏཾ པཝིཏྲསྱཱཏྨནཿ པྲཱཏིཀཱུལྱམ྄ ཨཱཙརཐ, ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥཱ ཡཱདྲྀཤཱ ཡཱུཡམཔི ཏཱདྲྀཤཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ཡུཥྨཱཀཾ པཱུཪྻྭཔུརུཥཱཿ ཀཾ བྷཝིཥྱདྭཱདིནཾ ནཱཏཱཌཡན྄? ཡེ ཏསྱ དྷཱརྨྨིཀསྱ ཛནསྱཱགམནཀཐཱཾ ཀཐིཏཝནྟསྟཱན྄ ཨགྷྣན྄ ཡཱུཡམ྄ ཨདྷཱུནཱ ཝིཤྭཱསགྷཱཏིནོ བྷཱུཏྭཱ ཏཾ དྷཱརྨྨིཀཾ ཛནམ྄ ཨཧཏ། ");
INSERT INTO santib_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ཡཱུཡཾ སྭརྒཱིཡདཱུཏགཎེན ཝྱཝསྠཱཾ པྲཱཔྱཱཔི ཏཱཾ ནཱཙརཐ། ");
INSERT INTO santib_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ཨིམཱཾ ཀཐཱཾ ཤྲུཏྭཱ ཏེ མནཿསུ བིདྡྷཱཿ སནྟསྟཾ པྲཏི དནྟགྷརྵཎམ྄ ཨཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ཀིནྟུ སྟིཕཱནཿ པཝིཏྲེཎཱཏྨནཱ པཱུརྞོ བྷཱུཏྭཱ གགཎཾ པྲཏི སྠིརདྲྀཥྚིཾ ཀྲྀཏྭཱ ཨཱིཤྭརསྱ དཀྵིཎེ དཎྜཱཡམཱནཾ ཡཱིཤུཉྩ ཝིལོཀྱ ཀཐིཏཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","པཤྱ,མེགྷདྭཱརཾ མུཀྟམ྄ ཨཱིཤྭརསྱ དཀྵིཎེ སྠིཏཾ མཱནཝསུཏཉྩ པཤྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ཏདཱ ཏེ པྲོཙྩཻཿ ཤབྡཾ ཀྲྀཏྭཱ ཀརྞེཥྭངྒུལཱི རྣིདྷཱཡ ཨེཀཙིཏྟཱིབྷཱུཡ ཏམ྄ ཨཱཀྲམན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","པཤྩཱཏ྄ ཏཾ ནགརཱད྄ བཧིཿ ཀྲྀཏྭཱ པྲསྟརཻརཱགྷྣན྄ སཱཀྵིཎོ ལཱཀཱཿ ཤཽལནཱམྣོ ཡཱུནཤྩརཎསནྣིདྷཽ ནིཛཝསྟྲཱཎི སྠཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ཨནནྟརཾ ཧེ པྲབྷོ ཡཱིཤེ མདཱིཡམཱཏྨཱནཾ གྲྀཧཱཎ སྟིཕཱནསྱེཏི པྲཱརྠནཝཱཀྱཝདནསམཡེ ཏེ ཏཾ པྲསྟརཻརཱགྷྣན྄། ");
INSERT INTO santib_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ཏསྨཱཏ྄ ས ཛཱནུནཱི པཱཏཡིཏྭཱ པྲོཙྩཻཿ ཤབྡཾ ཀྲྀཏྭཱ, ཧེ པྲབྷེ པཱཔམེཏད྄ ཨེཏེཥུ མཱ སྠཱཔཡ, ཨིཏྱུཀྟྭཱ མཧཱནིདྲཱཾ པྲཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ཏསྱ ཧཏྱཱཀརཎཾ ཤཽལོཔི སམམནྱཏ། ཏསྨིན྄ སམཡེ ཡིརཱུཤཱལམྣགརསྠཱཾ མཎྜལཱིཾ པྲཏི མཧཱཏཱཌནཱཡཱཾ ཛཱཏཱཡཱཾ པྲེརིཏལོཀཱན྄ ཧིཏྭཱ སཪྻྭེ྅པརེ ཡིཧཱུདཱཤོམིརོཎདེཤཡོ རྣཱནཱསྠཱནེ ཝིཀཱིརྞཱཿ སནྟོ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ཨནྱཙྩ བྷཀྟལོཀཱསྟཾ སྟིཕཱནཾ ཤྨཤཱནེ སྠཱཔཡིཏྭཱ བཧུ ཝྱལཔན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ཀིནྟུ ཤཽལོ གྲྀཧེ གྲྀཧེ བྷྲམིཏྭཱ སྟྲིཡཿ པུརུཥཱཾཤྩ དྷྲྀཏྭཱ ཀཱརཱཡཱཾ བདྡྷྭཱ མཎྜལྱཱ མཧོཏྤཱཏཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ཨནྱཙྩ ཡེ ཝིཀཱིརྞཱ ཨབྷཝན྄ ཏེ སཪྻྭཏྲ བྷྲམིཏྭཱ སུསཾཝཱདཾ པྲཱཙཱརཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ཏདཱ ཕིལིཔཿ ཤོམིརོཎྣགརཾ གཏྭཱ ཁྲཱིཥྚཱཁྱཱནཾ པྲཱཙཱརཡཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ཏཏོ྅ཤུཙི-བྷྲྀཏགྲསྟལོཀེབྷྱོ བྷཱུཏཱཤྩཱིཏྐྲྀཏྱཱགཙྪན྄ ཏཐཱ བཧཝཿ པཀྵཱགྷཱཏིནཿ ཁཉྫཱ ལོཀཱཤྩ སྭསྠཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ཏསྨཱཏ྄ ལཱཀཱ ཨཱིདྲྀཤཾ ཏསྱཱཤྩཪྻྱཾ ཀརྨྨ ཝིལོཀྱ ནིཤམྱ ཙ སཪྻྭ ཨེཀཙིཏྟཱིབྷཱུཡ ཏེནོཀྟཱཁྱཱནེ མནཱཾསི ནྱདདྷུཿ། ");
INSERT INTO santib_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ཏསྨིནྣགརེ མཧཱནནྡཤྩཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ཏཏཿ པཱུཪྻྭཾ ཏསྨིནྣགརེ ཤིམོནྣཱམཱ ཀཤྩིཛྫནོ བཧྭཱི རྨཱཡཱཀྲིཡཱཿ ཀྲྀཏྭཱ སྭཾ ཀཉྩན མཧཱཔུརུཥཾ པྲོཙྱ ཤོམིརོཎཱིཡཱནཱཾ མོཧཾ ཛནཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ཏསྨཱཏ྄ ས མཱནུཥ ཨཱིཤྭརསྱ མཧཱཤཀྟིསྭརཱུཔ ཨིཏྱུཀྟྭཱ བཱལཝྲྀདྡྷཝནིཏཱཿ སཪྻྭེ ལཱཀཱསྟསྨིན྄ མནཱཾསི ནྱདདྷུཿ། ");
INSERT INTO santib_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ས བཧུཀཱལཱན྄ མཱཡཱཝིཀྲིཡཡཱ སཪྻྭཱན྄ ཨཏཱིཝ མོཧཡཱཉྩཀཱར, ཏསྨཱཏ྄ ཏེ ཏཾ མེནིརེ། ");
INSERT INTO santib_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ཀིནྟྭཱིཤྭརསྱ རཱཛྱསྱ ཡཱིཤུཁྲཱིཥྚསྱ ནཱམྣཤྩཱཁྱཱནཔྲཙཱརིཎཿ ཕིལིཔསྱ ཀཐཱཡཱཾ ཝིཤྭསྱ ཏེཥཱཾ སྟྲཱིཔུརུཥོབྷཡལོཀཱ མཛྫིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ཤེཥེ ས ཤིམོནཔི སྭཡཾ པྲཏྱཻཏ྄ ཏཏོ མཛྫིཏཿ སན྄ ཕིལིཔེན ཀྲྀཏཱམ྄ ཨཱཤྩཪྻྱཀྲིཡཱཾ ལཀྵཎཉྩ ཝིལོཀྱཱསམྦྷཝཾ མནྱམཱནསྟེན སཧ སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ཨིཏྠཾ ཤོམིརོཎྡེཤཱིཡལོཀཱ ཨཱིཤྭརསྱ ཀཐཱམ྄ ཨགྲྀཧླན྄ ཨིཏི ཝཱརྟྟཱཾ ཡིརཱུཤཱལམྣགརསྠཔྲེརིཏཱཿ པྲཱཔྱ པིཏརཾ ཡོཧནཉྩ ཏེཥཱཾ ནིཀཊེ པྲེཥིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ཏཏསྟཽ ཏཏ྄ སྠཱནམ྄ ཨུཔསྠཱཡ ལོཀཱ ཡཐཱ པཝིཏྲམ྄ ཨཱཏྨཱནཾ པྲཱཔྣུཝནྟི ཏདརྠཾ པྲཱརྠཡེཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ཡཏསྟེ པུརཱ ཀེཝལཔྲབྷུཡཱིཤོ རྣཱམྣཱ མཛྫིཏམཱཏྲཱ ཨབྷཝན྄, ན ཏུ ཏེཥཱཾ མདྷྱེ ཀམཔི པྲཏི པཝིཏྲསྱཱཏྨན ཨཱཝིརྦྷཱཝོ ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ཀིནྟུ པྲེརིཏཱབྷྱཱཾ ཏེཥཱཾ གཱཏྲེཥུ ཀརེཥྭརྤིཏེཥུ སཏྶུ ཏེ པཝིཏྲམ྄ ཨཱཏྨཱནམ྄ པྲཱཔྣུཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ཨིཏྠཾ ལོཀཱནཱཾ གཱཏྲེཥུ པྲེརིཏཡོཿ ཀརཱརྤཎེན ཏཱན྄ པཝིཏྲམ྄ ཨཱཏྨཱནཾ པྲཱཔྟཱན྄ དྲྀཥྚྭཱ ས ཤིམོན྄ ཏཡོཿ སམཱིཔེ མུདྲཱ ཨཱནཱིཡ ཀཐིཏཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ཨཧཾ ཡསྱ གཱཏྲེ ཧསྟམ྄ ཨརྤཡིཥྱཱམི ཏསྱཱཔི ཡཐེཏྠཾ པཝིཏྲཱཏྨཔྲཱཔྟི རྦྷཝཏི ཏཱདྲྀཤཱིཾ ཤཀྟིཾ མཧྱཾ དཏྟཾ། ");
INSERT INTO santib_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ཀིནྟུ པིཏརསྟཾ པྲཏྱཝདཏ྄ ཏཝ མུདྲཱསྟྭཡཱ ཝིནཤྱནྟུ ཡཏ ཨཱིཤྭརསྱ དཱནཾ མུདྲཱབྷིཿ ཀྲཱིཡཏེ ཏྭམིཏྠཾ བུདྡྷཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ཨཱིཤྭརཱཡ ཏཱཝནྟཿཀརཎཾ སརལཾ ནཧི, ཏསྨཱད྄ ཨཏྲ ཏཝཱཾཤོ྅དྷིཀཱརཤྩ ཀོཔི ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ཨཏ ཨེཏཏྤཱཔཧེཏོཿ ཁེདཱནྭིཏཿ སན྄ ཀེནཱཔི པྲཀཱརེཎ ཏཝ མནས ཨེཏསྱཱཿ ཀུཀལྤནཱཡཱཿ ཀྵམཱ བྷཝཏི, ཨེཏདརྠམ྄ ཨཱིཤྭརེ པྲཱརྠནཱཾ ཀུརུ; ");
INSERT INTO santib_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ཡཏསྟྭཾ ཏིཀྟཔིཏྟེ པཱཔསྱ བནྡྷནེ ཙ ཡདསི ཏནྨཡཱ བུདྡྷམ྄། ");
INSERT INTO santib_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ཏདཱ ཤིམོན྄ ཨཀཐཡཏ྄ ཏརྷི ཡུཝཱབྷྱཱམུདིཏཱ ཀཐཱ མཡི ཡཐཱ ན ཕལཏི ཏདརྠཾ ཡུཝཱཾ མནྣིམིཏྟཾ པྲབྷཽ པྲཱརྠནཱཾ ཀུརུཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ཨནེན པྲཀཱརེཎ ཏཽ སཱཀྵྱཾ དཏྟྭཱ པྲབྷོཿ ཀཐཱཾ པྲཙཱརཡནྟཽ ཤོམིརོཎཱིཡཱནཱམ྄ ཨནེཀགྲཱམེཥུ སུསཾཝཱདཉྩ པྲཙཱརཡནྟཽ ཡིརཱུཤཱལམྣགརཾ པརཱཝྲྀཏྱ གཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ཏཏཿ པརམ྄ ཨཱིཤྭརསྱ དཱུཏཿ ཕིལིཔམ྄ ཨིཏྱཱདིཤཏ྄, ཏྭམུཏྠཱཡ དཀྵིཎསྱཱཾ དིཤི ཡོ མཱརྒོ པྲཱནྟརསྱ མདྷྱེན ཡིརཱུཤཱལམོ ྅སཱནགརཾ ཡཱཏི ཏཾ མཱརྒཾ གཙྪ། ");
INSERT INTO santib_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ཏཏཿ ས ཨུཏྠཱཡ གཏཝཱན྄; ཏདཱ ཀནྡཱཀཱིནཱམྣཿ ཀཱུཤློཀཱནཱཾ རཱཛྙྱཱཿ སཪྻྭསམྤཏྟེརདྷཱིཤཿ ཀཱུཤདེཤཱིཡ ཨེཀཿ ཥཎྜོ བྷཛནཱརྠཾ ཡིརཱུཤཱལམྣགརམ྄ ཨཱགཏྱ ");
INSERT INTO santib_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","པུནརཔི རཐམཱརུཧྱ ཡིཤཡིཡནཱམྣོ བྷཝིཥྱདྭཱདིནོ གྲནྠཾ པཋན྄ པྲཏྱཱགཙྪཏི། ");
INSERT INTO santib_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ཨེཏསྨིན྄ སམཡེ ཨཱཏྨཱ ཕིལིཔམ྄ ཨཝདཏ྄, ཏྭམ྄ རཐསྱ སམཱིཔཾ གཏྭཱ ཏེན སཱརྡྡྷཾ མིལ། ");
INSERT INTO santib_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ཏསྨཱཏ྄ ས དྷཱཝན྄ ཏསྱ སནྣིདྷཱཝུཔསྠཱཡ ཏེན པཋྱམཱནཾ ཡིཤཡིཡཐཝིཥྱདྭཱདིནོ ཝཱཀྱཾ ཤྲུཏྭཱ པྲྀཥྚཝཱན྄ ཡཏ྄ པཋསི ཏཏ྄ ཀིཾ བུདྷྱསེ? ");
INSERT INTO santib_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ཏཏཿ ས ཀཐིཏཝཱན྄ ཀེནཙིནྣ བོདྷིཏོཧཾ ཀཐཾ བུདྷྱེཡ? ཏཏཿ ས ཕིལིཔཾ རཐམཱརོཌྷུཾ སྭེན སཱརྡྡྷམ྄ ཨུཔཝེཥྚུཉྩ ནྱཝེདཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ས ཤཱསྟྲསྱེཏདྭཱཀྱཾ པཋིཏཝཱན྄ ཡཐཱ, སམཱནཱིཡཏ གྷཱཏཱཡ ས ཡཐཱ མེཥཤཱཝཀཿ། ལོམཙྪེདཀསཱཀྵཱཙྩ མེཥཤྩ ནཱིརཝོ ཡཐཱ། ཨཱབདྷྱ ཝདནཾ སྭཱིཡཾ ཏཐཱ ས སམཏིཥྛཏ། ");
INSERT INTO santib_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ཨནྱཱཡེན ཝིཙཱརེཎ ས ཨུཙྪིནྣོ ྅བྷཝཏ྄ ཏདཱ། ཏཏྐཱལཱིནམནུཥྱཱན྄ ཀོ ཛནོ ཝརྞཡིཏུཾ ཀྵམཿ། ཡཏོ ཛཱིཝནྣྲྀཎཱཾ དེཤཱཏ྄ ས ཨུཙྪིནྣོ ྅བྷཝཏ྄ དྷྲུཝཾ། ");
INSERT INTO santib_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ཨནནྟརཾ ས ཕིལིཔམ྄ ཨཝདཏ྄ ནིཝེདཡཱམི, བྷཝིཥྱདྭཱདཱི ཡཱམིམཱཾ ཀཐཱཾ ཀཐཡཱམཱས ས ཀིཾ སྭསྨིན྄ ཝཱ ཀསྨིཾཤྩིད྄ ཨནྱསྨིན྄? ");
INSERT INTO santib_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ཏཏཿ ཕིལིཔསྟཏྤྲཀརཎམ྄ ཨཱརབྷྱ ཡཱིཤོརུཔཱཁྱཱནཾ ཏསྱཱགྲེ པྲཱསྟཽཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ཨིཏྠཾ མཱརྒེཎ གཙྪནྟཽ ཛལཱཤཡསྱ སམཱིཔ ཨུཔསྠིཏཽ; ཏདཱ ཀླཱིབོ྅ཝཱདཱིཏ྄ པཤྱཱཏྲ སྠཱནེ ཛལམཱསྟེ མམ མཛྫནེ ཀཱ བཱདྷཱ? ");
INSERT INTO santib_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ཏཏཿ ཕིལིཔ ཨུཏྟརཾ ཝྱཱཧརཏ྄ སྭཱནྟཿཀརཎེན སཱཀཾ ཡདི པྲཏྱེཥི ཏརྷི བཱདྷཱ ནཱསྟི། ཏཏཿ ས ཀཐིཏཝཱན྄ ཡཱིཤུཁྲཱིཥྚ ཨཱིཤྭརསྱ པུཏྲ ཨིཏྱཧཾ པྲཏྱེམི། ");
INSERT INTO santib_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ཏདཱ རཐཾ སྠགིཏཾ ཀརྟྟུམ྄ ཨཱདིཥྚེ ཕིལིཔཀླཱིབཽ དྭཽ ཛལམ྄ ཨཝཱརུཧཏཱཾ; ཏདཱ ཕིལིཔསྟམ྄ མཛྫཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ཏཏྤཤྩཱཏ྄ ཛལམདྷྱཱད྄ ཨུཏྠིཏཡོཿ སཏོཿ པརམེཤྭརསྱཱཏྨཱ ཕིལིཔཾ ཧྲྀཏྭཱ ནཱིཏཝཱན྄, ཏསྨཱཏ྄ ཀླཱིབཿ པུནསྟཾ ན དྲྀཥྚཝཱན྄ ཏཐཱཔི ཧྲྀཥྚཙིཏྟཿ སན྄ སྭམཱརྒེཎ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ཕིལིཔཤྩཱསྡོདྣགརམ྄ ཨུཔསྠཱཡ ཏསྨཱཏ྄ ཀཻསརིཡཱནགར ཨུཔསྠིཏིཀཱལཔཪྻྱནཏཾ སཪྻྭསྨིནྣགརེ སུསཾཝཱདཾ པྲཙཱརཡན྄ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ཏཏྐཱལཔཪྻྱནཏཾ ཤཽལཿ པྲབྷོཿ ཤིཥྱཱཎཱཾ པྲཱཏིཀཱུལྱེན ཏཱཌནཱབདྷཡོཿ ཀཐཱཾ ནིཿསཱརཡན྄ མཧཱཡཱཛཀསྱ སནྣིདྷིཾ གཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","སྟྲིཡཾ པུརུཥཉྩ ཏནྨཏགྲཱཧིཎཾ ཡཾ ཀཉྩིཏ྄ པཤྱཏི ཏཱན྄ དྷྲྀཏྭཱ བདྡྷྭཱ ཡིརཱུཤཱལམམ྄ ཨཱནཡཏཱིཏྱཱཤཡེན དམྨེཥཀྣགརཱིཡཾ དྷརྨྨསམཱཛཱན྄ པྲཏི པཏྲཾ ཡཱཙིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","གཙྪན྄ ཏུ དམྨེཥཀྣགརནིཀཊ ཨུཔསྠིཏཝཱན྄; ཏཏོ྅ཀསྨཱད྄ ཨཱཀཱཤཱཏ྄ ཏསྱ ཙཏུརྡིཀྵུ ཏེཛསཿ པྲཀཱཤནཱཏ྄ ས བྷཱུམཱཝཔཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","པཤྩཱཏ྄ ཧེ ཤཽལ ཧེ ཤཽལ ཀུཏོ མཱཾ ཏཱཌཡསི? སྭཾ པྲཏི པྲོཀྟམ྄ ཨེཏཾ ཤབྡཾ ཤྲུཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ས པྲྀཥྚཝཱན྄, ཧེ པྲབྷོ བྷཝཱན྄ ཀཿ? ཏདཱ པྲབྷུརཀཐཡཏ྄ ཡཾ ཡཱིཤུཾ ཏྭཾ ཏཱཌཡསི ས ཨེཝཱཧཾ; ཀཎྚཀསྱ མུཁེ པདཱགྷཱཏཀརཎཾ ཏཝ ཀཥྚམ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ཏདཱ ཀམྤམཱནོ ཝིསྨཡཱཔནྣཤྩ སོཝདཏ྄ ཧེ པྲབྷོ མཡཱ ཀིཾ ཀརྟྟཝྱཾ? བྷཝཏ ཨིཙྪཱ ཀཱ? ཏཏཿ པྲབྷུརཱཛྙཱཔཡད྄ ཨུཏྠཱཡ ནགརཾ གཙྪ ཏཏྲ ཏྭཡཱ ཡཏ྄ ཀརྟྟཝྱཾ ཏད྄ ཝདིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ཏསྱ སངྒིནོ ལོཀཱ ཨཔི ཏཾ ཤབྡཾ ཤྲུཏཝནྟཿ ཀིནྟུ ཀམཔི ན དྲྀཥྚྭཱ སྟབྡྷཱཿ སནྟཿ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ཨནནྟརཾ ཤཽལོ བྷཱུམིཏ ཨུཏྠཱཡ ཙཀྵུཥཱི ཨུནྨཱིལྱ ཀམཔི ན དྲྀཥྚཝཱན྄། ཏདཱ ལོཀཱསྟསྱ ཧསྟཽ དྷྲྀཏྭཱ དམྨེཥཀྣགརམ྄ ཨཱནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ཏཏཿ ས དིནཏྲཡཾ ཡཱཝད྄ ཨནྡྷོ བྷཱུཏྭཱ ན བྷུཀྟཝཱན྄ པཱིཏཝཱཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ཏདནནྟརཾ པྲབྷུསྟདྡམྨེཥཀྣགརཝཱསིན ཨེཀསྨཻ ཤིཥྱཱཡ དརྴནཾ དཏྭཱ ཨཱཧཱུཏཝཱན྄ ཧེ ཨནནིཡ། ཏཏཿ ས པྲཏྱཝཱདཱིཏ྄, ཧེ པྲབྷོ པཤྱ ཤྲྀཎོམི། ");
INSERT INTO santib_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ཏདཱ པྲབྷུསྟམཱཛྙཱཔཡཏ྄ ཏྭམུཏྠཱཡ སརལནཱམཱནཾ མཱརྒཾ གཏྭཱ ཡིཧཱུདཱནིཝེཤནེ ཏཱརྵནགརཱིཡཾ ཤཽལནཱམཱནཾ ཛནཾ གཝེཥཡན྄ པྲྀཙྪ; ");
INSERT INTO santib_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","པཤྱ ས པྲཱརྠཡཏེ, ཏཐཱ ཨནནིཡནཱམཀ ཨེཀོ ཛནསྟསྱ སམཱིཔམ྄ ཨཱགཏྱ ཏསྱ གཱཏྲེ ཧསྟཱརྤཎཾ ཀྲྀཏྭཱ དྲྀཥྚིཾ དདཱཏཱིཏྠཾ སྭཔྣེ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ཏསྨཱད྄ ཨནནིཡཿ པྲཏྱཝདཏ྄ ཧེ པྲབྷོ ཡིརཱུཤཱལམི པཝིཏྲལོཀཱན྄ པྲཏི སོ྅ནེཀཧིཾསཱཾ ཀྲྀཏཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ཨཏྲ སྠཱནེ ཙ ཡེ ལོཀཱསྟཝ ནཱམྣི པྲཱརྠཡནྟི ཏཱནཔི བདྡྷུཾ ས པྲདྷཱནཡཱཛཀེབྷྱཿ ཤཀྟིཾ པྲཱཔྟཝཱན྄, ཨིམཱཾ ཀཐཱམ྄ ཨཧམ྄ ཨནེཀེཥཱཾ མུཁེབྷྱཿ ཤྲུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ཀིནྟུ པྲབྷུརཀཐཡཏ྄, ཡཱཧི བྷིནྣདེཤཱིཡལོཀཱནཱཾ བྷཱུཔཏཱིནཱམ྄ ཨིསྲཱཡེལློཀཱནཱཉྩ ནིཀཊེ མམ ནཱམ པྲཙཱརཡིཏུཾ ས ཛནོ མམ མནོནཱིཏཔཱཏྲམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","མམ ནཱམནིམིཏྟཉྩ ཏེན ཀིཡཱན྄ མཧཱན྄ ཀླེཤོ བྷོཀྟཝྱ ཨེཏཏ྄ ཏཾ དརྴཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ཏཏོ ྅ནནིཡོ གཏྭཱ གྲྀཧཾ པྲཝིཤྱ ཏསྱ གཱཏྲེ ཧསྟཱརྤྲཎཾ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄, ཧེ བྷྲཱཏཿ ཤཽལ ཏྭཾ ཡཐཱ དྲྀཥྚིཾ པྲཱཔྣོཥི པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞོ བྷཝསི ཙ, ཏདརྠཾ ཏཝཱགམནཀཱལེ ཡཿ པྲབྷུཡཱིཤུསྟུབྷྱཾ དརྴནམ྄ ཨདདཱཏ྄ ས མཱཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ཨིཏྱུཀྟམཱཏྲེ ཏསྱ ཙཀྵུརྦྷྱཱམ྄ མཱིནཤལྐཝད྄ ཝསྟུནི ནིརྒཏེ ཏཏྐྵཎཱཏ྄ ས པྲསནྣཙཀྵུ རྦྷཱུཏྭཱ པྲོཏྠཱཡ མཛྫིཏོ྅བྷཝཏ྄ བྷུཀྟྭཱ པཱིཏྭཱ སབལོབྷཝཙྩ། ");
INSERT INTO santib_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ཏཏཿ པརཾ ཤཽལཿ ཤིཥྱཻཿ སཧ ཀཏིཔཡདིཝསཱན྄ ཏསྨིན྄ དམྨེཥཀནགརེ སྠིཏྭཱ྅ཝིལམྦཾ ");
INSERT INTO santib_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","སཪྻྭབྷཛནབྷཝནཱནི གཏྭཱ ཡཱིཤུརཱིཤྭརསྱ པུཏྲ ཨིམཱཾ ཀཐཱཾ པྲཱཙཱརཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ཏསྨཱཏ྄ སཪྻྭེ ཤྲོཏཱརཤྩམཏྐྲྀཏྱ ཀཐིཏཝནྟོ ཡོ ཡིརཱུཤཱལམྣགར ཨེཏནྣཱམྣཱ པྲཱརྠཡིཏྲྀལོཀཱན྄ ཝིནཱཤིཏཝཱན྄ ཨེཝམ྄ ཨེཏཱདྲྀཤལོཀཱན྄ བདྡྷྭཱ པྲདྷཱནཡཱཛཀནིཀཊཾ ནཡཏཱིཏྱཱཤཡཱ ཨེཏཏྶྠཱནམཔྱཱགཙྪཏ྄ སཨེཝ ཀིམཡཾ ན བྷཝཏི? ");
INSERT INTO santib_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ཀིནྟུ ཤཽལཿ ཀྲམཤ ཨུཏྶཱཧཝཱན྄ བྷཱུཏྭཱ ཡཱིཤུརཱིཤྭརེཎཱབྷིཥིཀྟོ ཛན ཨེཏསྨིན྄ པྲམཱཎཾ དཏྭཱ དམྨེཥཀ྄-ནིཝཱསིཡིཧཱུདཱིཡལོཀཱན྄ ནིརུཏྟརཱན྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ཨིཏྠཾ བཧུཏིཐེ ཀཱལེ གཏེ ཡིཧཱུདཱིཡལོཀཱསྟཾ ཧནྟུཾ མནྟྲཡཱམཱསུཿ ");
INSERT INTO santib_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ཀིནྟུ ཤཽལསྟེཥཱམེཏསྱཱ མནྟྲཎཱཡཱ ཝཱརྟྟཱཾ པྲཱཔྟཝཱན྄། ཏེ ཏཾ ཧནྟུཾ ཏུ དིཝཱནིཤཾ གུཔྟཱཿ སནྟོ ནགརསྱ དྭཱརེ྅ཏིཥྛན྄; ");
INSERT INTO santib_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ཏསྨཱཏ྄ ཤིཥྱཱསྟཾ ནཱིཏྭཱ རཱཏྲཽ པིཊཀེ ནིདྷཱཡ པྲཱཙཱིརེཎཱཝཱརོཧཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ཏཏཿ པརཾ ཤཽལོ ཡིརཱུཤཱལམཾ གཏྭཱ ཤིཥྱགཎེན སཱརྡྡྷཾ སྠཱཏུམ྄ ཨཻཧཏ྄, ཀིནྟུ སཪྻྭེ ཏསྨཱདབིབྷཡུཿ ས ཤིཥྱ ཨིཏི ཙ ན པྲཏྱཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ཨེཏསྨཱད྄ བརྞབྦཱསྟཾ གྲྀཧཱིཏྭཱ པྲེརིཏཱནཱཾ སམཱིཔམཱནཱིཡ མཱརྒམདྷྱེ པྲབྷུཿ ཀཐཾ ཏསྨཻ དརྴནཾ དཏྟཝཱན྄ ཡཱཿ ཀཐཱཤྩ ཀཐིཏཝཱན྄ ས ཙ ཡཐཱཀྵོབྷཿ སན྄ དམྨེཥཀྣགརེ ཡཱིཤོ རྣཱམ པྲཱཙཱརཡཏ྄ ཨེཏཱན྄ སཪྻྭཝྲྀཏྟཱནྟཱན྄ ཏཱན྄ ཛྙཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ཏཏཿ ཤཽལསྟཻཿ སཧ ཡིརཱུཤཱལམི ཀཱལཾ ཡཱཔཡན྄ ནིརྦྷཡཾ པྲབྷོ ཪྻཱིཤོ རྣཱམ པྲཱཙཱརཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ཏསྨཱད྄ ཨནྱདེཤཱིཡལོཀཻཿ སཱརྡྡྷཾ ཝིཝཱདསྱོཔསྠིཏཏྭཱཏ྄ ཏེ ཏཾ ཧནྟུམ྄ ཨཙེཥྚནྟ། ");
INSERT INTO santib_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ཀིནྟུ བྷྲཱཏྲྀགཎསྟཛྫྙཱཏྭཱ ཏཾ ཀཻསརིཡཱནགརཾ ནཱིཏྭཱ ཏཱརྵནགརཾ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ཨིཏྠཾ སཏི ཡིཧཱུདིཡཱགཱལཱིལྴོམིརོཎདེཤཱིཡཱཿ སཪྻྭཱ མཎྜལྱོ ཝིཤྲཱམཾ པྲཱཔྟཱསྟཏསྟཱསཱཾ ནིཥྛཱབྷཝཏ྄ པྲབྷོ རྦྷིཡཱ པཝིཏྲསྱཱཏྨནཿ སཱནྟྭནཡཱ ཙ ཀཱལཾ ཀྵེཔཡིཏྭཱ བཧུསཾཁྱཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ཏཏཿ པརཾ པིཏརཿ སྠཱནེ སྠཱནེ བྷྲམིཏྭཱ ཤེཥེ ལོདྣགརནིཝཱསིཔཝིཏྲལོཀཱནཱཾ སམཱིཔེ སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ཏདཱ ཏཏྲ པཀྵཱགྷཱཏཝྱཱདྷིནཱཥྚཽ ཝཏྶརཱན྄ ཤཡྻཱགཏམ྄ ཨཻནེཡནཱམཱནཾ མནུཥྱཾ སཱཀྵཏ྄ པྲཱཔྱ ཏམཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ཧེ ཨཻནེཡ ཡཱིཤུཁྲཱིཥྚསྟྭཱཾ སྭསྠམ྄ ཨཀཱརྵཱིཏ྄, ཏྭམུཏྠཱཡ སྭཤཡྻཱཾ ནིཀྵིཔ, ཨིཏྱུཀྟམཱཏྲེ ས ཨུདཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ཨེཏཱདྲྀཤཾ དྲྀཥྚྭཱ ལོདྴཱརོཎནིཝཱསིནོ ལོཀཱཿ པྲབྷུཾ པྲཏི པརཱཝརྟྟནྟ། ");
INSERT INTO santib_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ཨཔརཉྩ བྷིཀྵཱདཱནཱདིཥུ ནཱནཀྲིཡཱསུ ནིཏྱཾ པྲཝྲྀཏྟཱ ཡཱ ཡཱཕོནགརནིཝཱསིནཱི ཊཱབིཐཱནཱམཱ ཤིཥྱཱ ཡཱཾ དརྐྐཱཾ ཨརྠཱད྄ ཧརིཎཱིམཡུཀྟྭཱ ཨཱཧྭཡན྄ སཱ ནཱརཱི ");
INSERT INTO santib_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ཏསྨིན྄ སམཡེ རུགྣཱ སཏཱི པྲཱཎཱན྄ ཨཏྱཛཏ྄, ཏཏོ ལོཀཱསྟཱཾ པྲཀྵཱལྱོཔརིསྠཔྲཀོཥྛེ ཤཱཡཡིཏྭཱསྠཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ལོདྣགརཾ ཡཱཕོནགརསྱ སམཱིཔསྠཾ ཏསྨཱཏྟཏྲ པིཏར ཨཱསྟེ, ཨིཏི ཝཱརྟྟཱཾ ཤྲུཏྭཱ ཏཱུརྞཾ ཏསྱཱགམནཱརྠཾ ཏསྨིན྄ ཝིནཡམུཀྟྭཱ ཤིཥྱགཎོ དྭཽ མནུཛཽ པྲེཥིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ཏསྨཱཏ྄ པིཏར ཨུཏྠཱཡ ཏཱབྷྱཱཾ སཱརྡྡྷམ྄ ཨཱགཙྪཏ྄, ཏཏྲ ཏསྨིན྄ ཨུཔསྠིཏ ཨུཔརིསྠཔྲཀོཥྛཾ སམཱནཱིཏེ ཙ ཝིདྷཝཱཿ སྭཱབྷིཿ སཧ སྠིཏིཀཱལེ དརྐྐཡཱ ཀྲྀཏཱནི ཡཱནྱུཏྟརཱིཡཱཎི པརིདྷེཡཱནི ཙ ཏཱནི སཪྻྭཱཎི ཏཾ དརྴཡིཏྭཱ རུདཏྱཤྩཏསྲྀཥུ དིཀྵྭཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ཀིནྟུ པིཏརསྟཱཿ སཪྻྭཱ བཧིཿ ཀྲྀཏྭཱ ཛཱནུནཱི པཱཏཡིཏྭཱ པྲཱརྠིཏཝཱན྄; པཤྩཱཏ྄ ཤཝཾ པྲཏི དྲྀཥྚིཾ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄, ཧེ ཊཱབཱིཐེ ཏྭམུཏྟིཥྛ, ཨིཏི ཝཱཀྱ ཨུཀྟེ སཱ སྟྲཱི ཙཀྵུཥཱི པྲོནྨཱིལྱ པིཏརམ྄ ཨཝལོཀྱོཏྠཱཡོཔཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ཏཏཿ པིཏརསྟསྱཱཿ ཀརཽ དྷྲྀཏྭཱ ཨུཏྟོལྱ པཝིཏྲལོཀཱན྄ ཝིདྷཝཱཤྩཱཧཱུཡ ཏེཥཱཾ ནིཀཊེ སཛཱིཝཱཾ ཏཱཾ སམཱརྤཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ཨེཥཱ ཀཐཱ སམསྟཡཱཕོནགརཾ ཝྱཱཔྟཱ ཏསྨཱད྄ ཨནེཀེ ལོཀཱཿ པྲབྷཽ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ཨཔརཉྩ པིཏརསྟདྱཱཕོནགརཱིཡསྱ ཀསྱཙིཏ྄ ཤིམོནྣཱམྣཤྩརྨྨཀཱརསྱ གྲྀཧེ བཧུདིནཱནི ནྱཝསཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ཀཻསརིཡཱནགར ཨིཏཱལིཡཱཁྱསཻནྱཱནྟརྒཏཿ ཀརྞཱིལིཡནཱམཱ སེནཱཔཏིརཱསཱིཏ྄ ");
INSERT INTO santib_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ས སཔརིཝཱརོ བྷཀྟ ཨཱིཤྭརཔརཱཡཎཤྩཱསཱིཏ྄; ལོཀེབྷྱོ བཧཱུནི དཱནཱདཱིནི དཏྭཱ ནིརནྟརམ྄ ཨཱིཤྭརེ པྲཱརྠཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ཨེཀདཱ ཏྲྀཏཱིཡཔྲཧརཝེལཱཡཱཾ ས དྲྀཥྚཝཱན྄ ཨཱིཤྭརསྱཻཀོ དཱུཏཿ སཔྲཀཱཤཾ ཏཏྶམཱིཔམ྄ ཨཱགཏྱ ཀཐིཏཝཱན྄, ཧེ ཀརྞཱིལིཡ། ");
INSERT INTO santib_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ཀིནྟུ ས ཏཾ དྲྀཥྚྭཱ བྷཱིཏོ྅ཀཐཡཏ྄, ཧེ པྲབྷོ ཀིཾ? ཏདཱ ཏམཝདཏ྄ ཏཝ པྲཱརྠནཱ དཱནཱདི ཙ སཱཀྵིསྭརཱུཔཾ བྷཱུཏྭེཤྭརསྱ གོཙརམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ཨིདཱནཱིཾ ཡཱཕོནགརཾ པྲཏི ལོཀཱན྄ པྲེཥྱ སམུདྲཏཱིརེ ཤིམོནྣཱམྣཤྩརྨྨཀཱརསྱ གྲྀཧེ པྲཝཱསཀཱརཱི པིཏརནཱམྣཱ ཝིཁྱཱཏོ ཡཿ ཤིམོན྄ ཏམ྄ ཨཱཧྭཱཡཡ; ");
INSERT INTO santib_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ཏསྨཱཏ྄ ཏྭཡཱ ཡདྱཏ྄ ཀརྟྟཝྱཾ ཏཏྟཏ྄ ས ཝདིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ཨིཏྱུཔདིཤྱ དཱུཏེ པྲསྠིཏེ སཏི ཀརྞཱིལིཡཿ སྭགྲྀཧསྠཱནཱཾ དཱསཱནཱཾ དྭཽ ཛནཽ ནིཏྱཾ སྭསངྒིནཱཾ སཻནྱཱནཱམ྄ ཨེཀཱཾ བྷཀྟསེནཱཉྩཱཧཱུཡ ");
INSERT INTO santib_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","སཀལམེཏཾ ཝྲྀཏྟཱནྟཾ ཝིཛྙཱཔྱ ཡཱཕོནགརཾ ཏཱན྄ པྲཱཧིཎོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","པརསྨིན྄ དིནེ ཏེ ཡཱཏྲཱཾ ཀྲྀཏྭཱ ཡདཱ ནགརསྱ སམཱིཔ ཨུཔཱཏིཥྛན྄, ཏདཱ པིཏརོ དྭིཏཱིཡཔྲཧརཝེལཱཡཱཾ པྲཱརྠཡིཏུཾ གྲྀཧཔྲྀཥྛམ྄ ཨཱརོཧཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ཨེཏསྨིན྄ སམཡེ ཀྵུདྷཱརྟྟཿ སན྄ ཀིཉྩིད྄ བྷོཀྟུམ྄ ཨཻཙྪཏ྄ ཀིནྟུ ཏེཥཱམ྄ ཨནྣཱསཱདནསམཡེ ས མཱུརྩྪིཏཿ སནྣཔཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ཏཏོ མེགྷདྭཱརཾ མུཀྟཾ ཙཏུརྦྷིཿ ཀོཎཻ རླམྦིཏཾ བྲྀཧདྭསྟྲམིཝ ཀིཉྩན བྷཱཛནམ྄ ཨཱཀཱཤཱཏ྄ པྲྀཐིཝཱིམ྄ ཨཝཱརོཧཏཱིཏི དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ཏནྨདྷྱེ ནཱནཔྲཀཱརཱ གྲཱམྱཝནྱཔཤཝཿ ཁེཙརོརོགཱམིཔྲབྷྲྀཏཡོ ཛནྟཝཤྩཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ཨནནྟརཾ ཧེ པིཏར ཨུཏྠཱཡ ཧཏྭཱ བྷུཾཀྵྭ ཏམྤྲཏཱིཡཾ གགཎཱིཡཱ ཝཱཎཱི ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ཏདཱ པིཏརཿ པྲཏྱཝདཏ྄, ཧེ པྲབྷོ ཨཱིདྲྀཤཾ མཱ བྷཝཏུ, ཨཧམ྄ ཨེཏཏ྄ ཀཱལཾ ཡཱཝཏ྄ ནིཥིདྡྷམ྄ ཨཤུཙི ཝཱ དྲཝྱཾ ཀིཉྩིདཔི ན བྷུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ཏཏཿ པུནརཔི ཏཱདྲྀཤཱི ཝིཧཡསཱིཡཱ ཝཱཎཱི ཛཱཏཱ ཡད྄ ཨཱིཤྭརཿ ཤུཙི ཀྲྀཏཝཱན྄ ཏཏ྄ ཏྭཾ ནིཥིདྡྷཾ ན ཛཱནཱིཧི། ");
INSERT INTO santib_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ཨིཏྠཾ ཏྲིཿ སཏི ཏཏ྄ པཱཏྲཾ པུནརཱཀྲྀཥྚཾ ཨཱཀཱཤམ྄ ཨགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ཏཏཿ པརཾ ཡད྄ དརྴནཾ པྲཱཔྟཝཱན྄ ཏསྱ ཀོ བྷཱཝ ཨིཏྱཏྲ པིཏརོ མནསཱ སནྡེགྡྷི, ཨེཏསྨིན྄ སམཡེ ཀརྞཱིལིཡསྱ ཏེ པྲེཥིཏཱ མནུཥྱཱ དྭཱརསྱ སནྣིདྷཱཝུཔསྠཱཡ, ");
INSERT INTO santib_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ཤིམོནོ གྲྀཧམནྭིཙྪནྟཿ སམྤྲྀཚྱཱཧཱུཡ ཀཐིཏཝནྟཿ པིཏརནཱམྣཱ ཝིཁྱཱཏོ ཡཿ ཤིམོན྄ ས ཀིམཏྲ པྲཝསཏི? ");
INSERT INTO santib_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ཡདཱ པིཏརསྟདྡརྴནསྱ བྷཱཝཾ མནསཱནྡོལཡཏི ཏདཱཏྨཱ ཏམཝདཏ྄, པཤྱ ཏྲཡོ ཛནཱསྟྭཱཾ མྲྀགཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ཏྭམ྄ ཨུཏྠཱཡཱཝརུཧྱ ནིཿསནྡེཧཾ ཏཻཿ སཧ གཙྪ མཡཻཝ ཏེ པྲེཥིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ཏསྨཱཏ྄ པིཏརོ྅ཝརུཧྱ ཀརྞཱིལིཡཔྲེརིཏལོཀཱནཱཾ ནིཀཊམཱགཏྱ ཀཐིཏཝཱན྄ པཤྱཏ ཡཱུཡཾ ཡཾ མྲྀགཡདྷྭེ ས ཛནོཧཾ, ཡཱུཡཾ ཀིནྣིམིཏྟམ྄ ཨཱགཏཱཿ? ");
INSERT INTO santib_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ཏཏསྟེ པྲཏྱཝདན྄ ཀརྞཱིལིཡནཱམཱ ཤུདྡྷསཏྟྭ ཨཱིཤྭརཔརཱཡཎོ ཡིཧཱུདཱིཡདེཤསྠཱནཱཾ སཪྻྭེཥཱཾ སནྣིདྷཽ སུཁྱཱཏྱཱཔནྣ ཨེཀཿ སེནཱཔཏི རྣིཛགྲྀཧཾ ཏྭཱམཱཧཱུཡ ནེཏུཾ ཏྭཏྟཿ ཀཐཱ ཤྲོཏུཉྩ པཝིཏྲདཱུཏེན སམཱདིཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ཏདཱ པིཏརསྟཱནབྷྱནྟརཾ ནཱིཏྭཱ ཏེཥཱམཱཏིཐྱཾ ཀྲྀཏཝཱན྄, པརེ྅ཧནི ཏཻཿ སཱརྡྡྷཾ ཡཱཏྲཱམཀརོཏ྄, ཡཱཕོནིཝཱསིནཱཾ བྷྲཱཏྲྀཎཱཾ ཀིཡནྟོ ཛནཱཤྩ ཏེན སཧ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","པརསྨིན྄ དིཝསེ ཀཻསརིཡཱནགརམདྷྱཔྲཝེཤསམཡེ ཀརྞཱིལིཡོ ཛྙཱཏིབནྡྷཱུན྄ ཨཱཧཱུཡཱནཱིཡ ཏཱན྄ ཨཔེཀྵྱ སྠིཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","པིཏརེ གྲྀཧ ཨུཔསྠིཏེ ཀརྞཱིལིཡསྟཾ སཱཀྵཱཏྐྲྀཏྱ ཙརཎཡོཿ པཏིཏྭཱ པྲཱཎམཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","པིཏརསྟམུཏྠཱཔྱ ཀཐིཏཝཱན྄, ཨུཏྟིཥྛཱཧམཔི མཱནུཥཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ཏདཱ ཀརྞཱིལིཡེན སཱཀམ྄ ཨཱལཔན྄ གྲྀཧཾ པྲཱཝིཤཏ྄ ཏནྨདྷྱེ ཙ བཧུལོཀཱནཱཾ སམཱགམཾ དྲྀཥྚྭཱ ཏཱན྄ ཨཝདཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ཨནྱཛཱཏཱིཡལོཀཻཿ མཧཱལཔནཾ ཝཱ ཏེཥཱཾ གྲྀཧམདྷྱེ པྲཝེཤནཾ ཡིཧཱུདཱིཡཱནཱཾ ནིཥིདྡྷམ྄ ཨསྟཱིཏི ཡཱུཡམ྄ ཨཝགཙྪཐ; ཀིནྟུ ཀམཔི མཱནུཥམ྄ ཨཝྱཝཧཱཪྻྱམ྄ ཨཤུཙིཾ ཝཱ ཛྙཱཏུཾ མམ ནོཙིཏམ྄ ཨིཏི པརམེཤྭརོ མཱཾ ཛྙཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ཨིཏི ཧེཏོརཱཧྭཱནཤྲཝཎམཱཏྲཱཏ྄ ཀཱཉྩནཱཔཏྟིམ྄ ཨཀྲྀཏྭཱ ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགཏོསྨི; པྲྀཙྪཱམི ཡཱུཡཾ ཀིནྣིམིཏྟཾ མཱམ྄ ཨཱཧཱུཡཏ? ");
INSERT INTO santib_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ཏདཱ ཀརྞཱིལིཡཿ ཀཐིཏཝཱན྄, ཨདྱ ཙཏྭཱརི དིནཱནི ཛཱཏཱནི ཨེཏཱཝདྭེལཱཾ ཡཱཝད྄ ཨཧམ྄ ཨནཱཧཱར ཨཱསན྄ ཏཏསྟྲྀཏཱིཡཔྲཧརེ སཏི གྲྀཧེ པྲཱརྠནསམཡེ ཏེཛོམཡཝསྟྲབྷྲྀད྄ ཨེཀོ ཛནོ མམ སམཀྵཾ ཏིཥྛན྄ ཨེཏཱཾ ཀཐཱམ྄ ཨཀཐཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ཧེ ཀརྞཱིལིཡ ཏྭདཱིཡཱ པྲཱརྠནཱ ཨཱིཤྭརསྱ ཀརྞགོཙརཱིབྷཱུཏཱ ཏཝ དཱནཱདི ཙ སཱཀྵིསྭརཱུཔཾ བྷཱུཏྭཱ ཏསྱ དྲྀཥྚིགོཙརམབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ཨཏོ ཡཱཕོནགརཾ པྲཏི ལོཀཱན྄ པྲཧིཏྱ ཏཏྲ སམུདྲཏཱིརེ ཤིམོནྣཱམྣཿ ཀསྱཙིཙྩརྨྨཀཱརསྱ གྲྀཧེ པྲཝཱསཀཱརཱི པིཏརནཱམྣཱ ཝིཁྱཱཏོ ཡཿ ཤིམོན྄ ཏམཱཧཱུाཡཡ; ཏཏཿ ས ཨཱགཏྱ ཏྭཱམ྄ ཨུཔདེཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ཨིཏི ཀཱརཎཱཏ྄ ཏཏྐྵཎཱཏ྄ ཏཝ ནིཀཊེ ལོཀཱན྄ པྲེཥིཏཝཱན྄, ཏྭམཱགཏཝཱན྄ ཨིཏི བྷདྲཾ ཀྲྀཏཝཱན྄། ཨཱིཤྭརོ ཡཱནྱཱཁྱཱནཱནི ཀཐཡིཏུམ྄ ཨཱདིཤཏ྄ ཏཱནི ཤྲོཏུཾ ཝཡཾ སཪྻྭེ སཱམྤྲཏམ྄ ཨཱིཤྭརསྱ སཱཀྵཱད྄ ཨུཔསྠིཏཱཿ སྨཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ཏདཱ པིཏར ཨིམཱཾ ཀཐཱཾ ཀཐཡིཏུམ྄ ཨཱརབྡྷཝཱན྄, ཨཱིཤྭརོ མནུཥྱཱཎཱམ྄ ཨཔཀྵཔཱཏཱི སན྄ ");
INSERT INTO santib_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ཡསྱ ཀསྱཙིད྄ དེཤསྱ ཡོ ལོཀཱསྟསྨཱདྦྷཱིཏྭཱ སཏྐརྨྨ ཀརོཏི ས ཏསྱ གྲཱཧྱོ བྷཝཏི, ཨེཏསྱ ནིཤྩཡམ྄ ཨུཔལབྡྷཝཱནཧམ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","སཪྻྭེཥཱཾ པྲབྷུ ཪྻོ ཡཱིཤུཁྲཱིཥྚསྟེན ཨཱིཤྭར ཨིསྲཱཡེལྭཾཤཱནཱཾ ནིཀཊེ སུསཾཝཱདཾ པྲེཥྱ སམྨེལནསྱ ཡཾ སཾཝཱདཾ པྲཱཙཱརཡཏ྄ ཏཾ སཾཝཱདཾ ཡཱུཡཾ ཤྲུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ཡཏོ ཡོཧནཱ མཛྫནེ པྲཙཱརིཏེ སཏི ས གཱལཱིལདེཤམཱརབྷྱ སམསྟཡིཧཱུདཱིཡདེཤཾ ཝྱཱཔྣོཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ཕལཏ ཨཱིཤྭརེཎ པཝིཏྲེཎཱཏྨནཱ ཤཀྟྱཱ ཙཱབྷིཥིཀྟོ ནཱསརཏཱིཡཡཱིཤུཿ སྠཱནེ སྠཱནེ བྷྲམན྄ སུཀྲིཡཱཾ ཀུཪྻྭན྄ ཤཻཏཱནཱ ཀླིཥྚཱན྄ སཪྻྭལོཀཱན྄ སྭསྠཱན྄ ཨཀརོཏ྄, ཡཏ ཨཱིཤྭརསྟསྱ སཧཱཡ ཨཱསཱིཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ཝཡཉྩ ཡིཧཱུདཱིཡདེཤེ ཡིརཱུཤཱལམྣགརེ ཙ ཏེན ཀྲྀཏཱནཱཾ སཪྻྭེཥཱཾ ཀརྨྨཎཱཾ སཱཀྵིཎོ བྷཝཱམཿ། ལོཀཱསྟཾ ཀྲུཤེ ཝིདྡྷྭཱ ཧཏཝནྟཿ, ");
INSERT INTO santib_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ཀིནྟུ ཏྲྀཏཱིཡདིཝསེ ཨཱིཤྭརསྟམུཏྠཱཔྱ སཔྲཀཱཤམ྄ ཨདརྴཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","སཪྻྭལོཀཱནཱཾ ནིཀཊ ཨིཏི ན ཧི, ཀིནྟུ ཏསྨིན྄ ཤྨཤཱནཱདུཏྠིཏེ སཏི ཏེན སཱརྡྡྷཾ བྷོཛནཾ པཱནཉྩ ཀྲྀཏཝནྟ ཨེཏཱདྲྀཤཱ ཨཱིཤྭརསྱ མནོནཱིཏཱཿ སཱཀྵིཎོ ཡེ ཝཡམ྄ ཨསྨཱཀཾ ནིཀཊེ ཏམདརྴཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ཛཱིཝིཏམྲྀཏོབྷཡལོཀཱནཱཾ ཝིཙཱརཾ ཀརྟྟུམ྄ ཨཱིཤྭརོ ཡཾ ནིཡུཀྟཝཱན྄ ས ཨེཝ ས ཛནཿ, ཨིམཱཾ ཀཐཱཾ པྲཙཱརཡིཏུཾ ཏསྨིན྄ པྲམཱཎཾ དཱཏུཉྩ སོ྅སྨཱན྄ ཨཱཛྙཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ཡསྟསྨིན྄ ཝིཤྭསིཏི ས ཏསྱ ནཱམྣཱ པཱཔཱནྨུཀྟོ བྷཝིཥྱཏི ཏསྨིན྄ སཪྻྭེ བྷཝིཥྱདྭཱདིནོཔི ཨེཏཱདྲྀཤཾ སཱཀྵྱཾ དདཏི། ");
INSERT INTO santib_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","པིཏརསྱཻཏཏྐཐཱཀཐནཀཱལེ སཪྻྭེཥཱཾ ཤྲོཏྲྀཎཱམུཔརི པཝིཏྲ ཨཱཏྨཱཝཱརོཧཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ཏཏཿ པིཏརེཎ སཱརྡྡྷམ྄ ཨཱགཏཱསྟྭཀྪེདིནོ ཝིཤྭཱསིནོ ལོཀཱ ཨནྱདེཤཱིཡེབྷྱཿ པཝིཏྲ ཨཱཏྨནི དཏྟེ སཏི ");
INSERT INTO santib_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ཏེ ནཱནཱཛཱཏཱིཡབྷཱཥཱབྷིཿ ཀཐཱཾ ཀཐཡནྟ ཨཱིཤྭརཾ པྲཤཾསནྟི, ཨིཏི དྲྀཥྚྭཱ ཤྲུཏྭཱ ཙ ཝིསྨཡམ྄ ཨཱཔདྱནྟ། ");
INSERT INTO santib_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ཏདཱ པིཏརཿ ཀཐིཏཝཱན྄, ཝཡམིཝ ཡེ པཝིཏྲམ྄ ཨཱཏྨཱནཾ པྲཱཔྟཱསྟེཥཱཾ ཛལམཛྫནཾ ཀིཾ ཀོཔི ནིཥེདྡྷུཾ ཤཀྣོཏི? ");
INSERT INTO santib_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ཏཏཿ པྲབྷོ རྣཱམྣཱ མཛྫིཏཱ བྷཝཏེཏི ཏཱནཱཛྙཱཔཡཏ྄། ཨནནྟརཾ ཏེ སྭཻཿ སཱརྡྡྷཾ ཀཏིཔཡདིནཱནི སྠཱཏུཾ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ཨིཏྠཾ བྷིནྣདེཤཱིཡལོཀཱ ཨཔཱིཤྭརསྱ ཝཱཀྱམ྄ ཨགྲྀཧླན྄ ཨིམཱཾ ཝཱརྟྟཱཾ ཡིཧཱུདཱིཡདེཤསྠཔྲེརིཏཱ བྷྲཱཏྲྀགཎཤྩ ཤྲུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ཏཏཿ པིཏརེ ཡིརཱུཤཱལམྣགརཾ གཏཝཏི ཏྭཀྪེདིནོ ལོཀཱསྟེན སཧ ཝིཝདམཱནཱ ཨཝདན྄, ");
INSERT INTO santib_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ཏྭམ྄ ཨཏྭཀྪེདིལོཀཱནཱཾ གྲྀཧཾ གཏྭཱ ཏཻཿ སཱརྡྡྷཾ བྷུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ཏཏཿ པིཏར ཨཱདིཏཿ ཀྲམཤསྟཏྐཱཪྻྱསྱ སཪྻྭཝྲྀཏྟཱནྟམཱཁྱཱཏུམ྄ ཨཱརབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ཡཱཕོནགར ཨེཀདཱཧཾ པྲཱརྠཡམཱནོ མཱུརྩྪིཏཿ སན྄ དརྴནེན ཙཏུརྵུ ཀོཎེཥུ ལམྦནམཱནཾ ཝྲྀཧདྭསྟྲམིཝ པཱཏྲམེཀམ྄ ཨཱཀཱཤདཝརུཧྱ མནྣིཀཊམ྄ ཨཱགཙྪད྄ ཨཔཤྱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","པཤྩཱཏ྄ ཏད྄ ཨནནྱདྲྀཥྚྱཱ དྲྀཥྚྭཱ ཝིཝིཙྱ ཏསྱ མདྷྱེ ནཱནཱཔྲཀཱརཱན྄ གྲཱམྱཝནྱཔཤཱུན྄ ཨུརོགཱམིཁེཙརཱཾཤྩ དྲྀཥྚཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ཧེ པིཏར ཏྭམུཏྠཱཡ གཏྭཱ བྷུཾཀྵྭ མཱཾ སམྦོདྷྱ ཀཐཡནྟཾ ཤབྡམེཀཾ ཤྲུཏཝཱཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ཏཏོཧཾ པྲཏྱཝདཾ, ཧེ པྲབྷོ ནེཏྠཾ བྷཝཏུ, ཡཏཿ ཀིཉྩན ནིཥིདྡྷམ྄ ཨཤུཙི དྲཝྱཾ ཝཱ མམ མུཁམདྷྱཾ ཀདཱཔི ན པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ཨཔརམ྄ ཨཱིཤྭརོ ཡཏ྄ ཤུཙི ཀྲྀཏཝཱན྄ ཏནྣིཥིདྡྷཾ ན ཛཱནཱིཧི དྭི རྨཱམྤྲཏཱིདྲྀཤཱི ཝིཧཱཡསཱིཡཱ ཝཱཎཱི ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ཏྲིརིཏྠཾ སཏི ཏཏ྄ སཪྻྭཾ པུནརཱཀཱཤམ྄ ཨཱཀྲྀཥྚཾ། ");
INSERT INTO santib_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","པཤྩཱཏ྄ ཀཻསརིཡཱནགརཱཏ྄ ཏྲཡོ ཛནཱ མནྣིཀཊཾ པྲེཥིཏཱ ཡཏྲ ནིཝེཤནེ སྠིཏོཧཾ ཏསྨིན྄ སམཡེ ཏཏྲོཔཱཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ཏདཱ ནིཿསནྡེཧཾ ཏཻཿ སཱརྡྡྷཾ ཡཱཏུམ྄ ཨཱཏྨཱ མཱམཱདིཥྚཝཱན྄; ཏཏཿ པརཾ མཡཱ སཧཻཏེཥུ ཥཌྦྷྲཱཏྲྀཥུ གཏེཥུ ཝཡཾ ཏསྱ མནུཛསྱ གྲྀཧཾ པྲཱཝིཤཱམ། ");
INSERT INTO santib_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","སོསྨཱཀཾ ནིཀཊེ ཀཐཱམེཏཱམ྄ ཨཀཐཡཏ྄ ཨེཀདཱ དཱུཏ ཨེཀཿ པྲཏྱཀྵཱིབྷཱུཡ མམ གྲྀཧམདྷྱེ ཏིཥྚན྄ མཱམིཏྱཱཛྙཱཔིཏཝཱན྄, ཡཱཕོནགརཾ པྲཏི ལོཀཱན྄ པྲཧིཏྱ པིཏརནཱམྣཱ ཝིཁྱཱཏཾ ཤིམོནམ྄ ཨཱཧཱུཡཡ; ");
INSERT INTO santib_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ཏཏསྟཝ ཏྭདཱིཡཔརིཝཱརཱཎཱཉྩ ཡེན པརིཏྲཱཎཾ བྷཝིཥྱཏི ཏཏ྄ ས ཨུཔདེཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ཨཧཾ ཏཱཾ ཀཐཱམུཏྠཱཔྱ ཀཐིཏཝཱན྄ ཏེན པྲཐམམ྄ ཨསྨཱཀམ྄ ཨུཔརི ཡཐཱ པཝིཏྲ ཨཱཏྨཱཝརཱུཌྷཝཱན྄ ཏཐཱ ཏེཥཱམཔྱུཔརི སམཝརཱུཌྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ཏེན ཡོཧན྄ ཛལེ མཛྫིཏཝཱན྄ ཨིཏི སཏྱཾ ཀིནྟུ ཡཱུཡཾ པཝིཏྲ ཨཱཏྨནི མཛྫིཏཱ བྷཝིཥྱཐ, ཨིཏི ཡདྭཱཀྱཾ པྲབྷུརུདིཏཝཱན྄ ཏཏ྄ ཏདཱ མཡཱ སྨྲྀཏམ྄། ");
INSERT INTO santib_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ཨཏཿ པྲབྷཱ ཡཱིཤུཁྲཱིཥྚེ པྲཏྱཡཀཱརིཎོ ཡེ ཝཡམ྄ ཨསྨབྷྱམ྄ ཨཱིཤྭརོ ཡད྄ དཏྟཝཱན྄ ཏཏ྄ ཏེབྷྱོ ལོཀེབྷྱོཔི དཏྟཝཱན྄ ཏཏཿ ཀོཧཾ? ཀིམཧམ྄ ཨཱིཤྭརཾ ཝཱརཡིཏུཾ ཤཀྣོམི? ");
INSERT INTO santib_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ཀཐཱམེཏཱཾ ཤྲུཝཱ ཏེ ཀྵཱནྟཱ ཨཱིཤྭརསྱ གུཎཱན྄ ཨནུཀཱིརྟྟྱ ཀཐིཏཝནྟཿ, ཏརྷི པརམཱཡུཿཔྲཱཔྟིནིམིཏྟམ྄ ཨཱིཤྭརོནྱདེཤཱིཡལོཀེབྷྱོཔི མནཿཔརིཝརྟྟནརཱུཔཾ དཱནམ྄ ཨདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","སྟིཕཱནཾ པྲཏི ཨུཔདྲཝེ གྷཊིཏེ ཡེ ཝིཀཱིརྞཱ ཨབྷཝན྄ ཏཻ ཕཻནཱིཀཱིཀུཔྲཱནྟིཡཁིཡཱསུ བྷྲམིཏྭཱ ཀེཝལཡིཧཱུདཱིཡལོཀཱན྄ ཝིནཱ ཀསྱཱཔྱནྱསྱ སམཱིཔ ཨཱིཤྭརསྱ ཀཐཱཾ ན པྲཱཙཱརཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ཨཔརཾ ཏེཥཱཾ ཀུཔྲཱིཡཱཿ ཀུརཱིནཱིཡཱཤྩ ཀིཡནྟོ ཛནཱ ཨཱནྟིཡཁིཡཱནགརཾ གཏྭཱ ཡཱུནཱནཱིཡལོཀཱནཱཾ སམཱིཔེཔི པྲབྷོཪྻཱིཤོཿ ཀཐཱཾ པྲཱཙཱརཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","པྲབྷོཿ ཀརསྟེཥཱཾ སཧཱཡ ཨཱསཱིཏ྄ ཏསྨཱད྄ ཨནེཀེ ལོཀཱ ཝིཤྭསྱ པྲབྷུཾ པྲཏི པརཱཝརྟྟནྟ། ");
INSERT INTO santib_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ཨིཏི ཝཱརྟྟཱཡཱཾ ཡིརཱུཤཱལམསྠམཎྜལཱིཡལོཀཱནཱཾ ཀརྞགོཙརཱིབྷཱུཏཱཡཱམ྄ ཨཱནྟིཡཁིཡཱནགརཾ གནྟུ ཏེ བརྞབྦཱཾ པྲཻརཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ཏཏོ བརྞབྦཱསྟཏྲ ཨུཔསྠིཏཿ སན྄ ཨཱིཤྭརསྱཱནུགྲཧསྱ ཕལཾ དྲྀཥྚྭཱ སཱནནྡོ ཛཱཏཿ, ");
INSERT INTO santib_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ས སྭཡཾ སཱདྷུ ཪྻིཤྭཱསེན པཝིཏྲེཎཱཏྨནཱ ཙ པརིཔཱུརྞཿ སན྄ གནོནིཥྚཡཱ པྲབྷཱཝཱསྠཱཾ ཀརྟྟུཾ སཪྻྭཱན྄ ཨུཔདིཥྚཝཱན྄ ཏེན པྲབྷོཿ ཤིཥྱཱ ཨནེཀེ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ཤེཥེ ཤཽལཾ མྲྀགཡིཏུཾ བརྞབྦཱསྟཱརྵནགརཾ པྲསྠིཏཝཱན྄། ཏཏྲ ཏསྱོདྡེཤཾ པྲཱཔྱ ཏམ྄ ཨཱནྟིཡཁིཡཱནགརམ྄ ཨཱནཡཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ཏཏསྟཽ མཎྜལཱིསྠལོཀཻཿ སབྷཱཾ ཀྲྀཏྭཱ སཾཝཏྶརམེཀཾ ཡཱཝད྄ བཧུལོཀཱན྄ ཨུཔཱདིཤཏཱཾ; ཏསྨིན྄ ཨཱནྟིཡཁིཡཱནགརེ ཤིཥྱཱཿ པྲཐམཾ ཁྲཱིཥྚཱིཡནཱམྣཱ ཝིཁྱཱཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ཏཏཿ པརཾ བྷཝིཥྱདྭཱདིགཎེ ཡིརཱུཤཱལམ ཨཱནྟིཡཁིཡཱནགརམ྄ ཨཱགཏེ སཏི ");
INSERT INTO santib_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ཨཱགཱབནཱམཱ ཏེཥཱམེཀ ཨུཏྠཱཡ ཨཱཏྨནཿ ཤིཀྵཡཱ སཪྻྭདེཤེ དུརྦྷིཀྵཾ བྷཝིཥྱཏཱིཏི ཛྙཱཔིཏཝཱན྄; ཏཏཿ ཀླཽདིཡཀཻསརསྱཱདྷིཀཱརེ སཏི ཏཏ྄ པྲཏྱཀྵམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ཏསྨཱཏ྄ ཤིཥྱཱ ཨེཀཻཀཤཿ སྭསྭཤཀྟྱནུསཱརཏོ ཡིཧཱུདཱིཡདེཤནིཝཱསིནཱཾ བྷྲཏྲྀཎཱཾ དིནཡཱཔནཱརྠཾ དྷནཾ པྲེཥཡིཏུཾ ནིཤྩིཏྱ ");
INSERT INTO santib_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","བརྞབྦཱཤཽལཡོ རྡྭཱརཱ པྲཱཙཱིནལོཀཱནཱཾ སམཱིཔཾ ཏཏ྄ པྲེཥིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ཏསྨིན྄ སམཡེ ཧེརོད྄རཱཛོ མཎྜལྱཱཿ ཀིཡཛྫནེབྷྱོ དུཿཁཾ དཱཏུཾ པྲཱརབྷཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ཝིཤེཥཏོ ཡོཧནཿ སོདརཾ ཡཱཀཱུབཾ ཀརཝཱལཱགྷཱཏེན྄ ཧཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ཏསྨཱད྄ ཡིཧཱུདཱིཡཱཿ སནྟུཥྚཱ ཨབྷཝན྄ ཨིཏི ཝིཛྙཱཡ ས པིཏརམཔི དྷརྟྟུཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ཏདཱ ཀིཎྭཤཱུནྱཔཱུཔོཏྶཝསམཡ ཨུཔཱཏིཥྚཏ྄; ཨཏ ཨུཏྶཝེ གཏེ སཏི ལོཀཱནཱཾ སམཀྵཾ ཏཾ བཧིརཱནེཡྻཱམཱིཏི མནསི སྠིརཱིཀྲྀཏྱ ས ཏཾ དྷཱརཡིཏྭཱ རཀྵྞཱརྠམ྄ ཡེཥཱམ྄ ཨེཀཻཀསཾགྷེ ཙཏྭཱརོ ཛནཱཿ སནྟི ཏེཥཱཾ ཙཏུརྞཱཾ རཀྵཀསཾགྷཱནཱཾ སམཱིཔེ ཏཾ སམརྤྱ ཀཱརཱཡཱཾ སྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ཀིནྟུཾ པིཏརསྱ ཀཱརཱསྠིཏིཀཱརཎཱཏ྄ མཎྜལྱཱ ལོཀཱ ཨཝིཤྲཱམམ྄ ཨཱིཤྭརསྱ སམཱིཔེ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ཨནནྟརཾ ཧེརོདི ཏཾ བཧིརཱནཱཡིཏུཾ ཨུདྱཏེ སཏི ཏསྱཱཾ རཱཏྲཽ པིཏརོ རཀྵཀདྭཡམདྷྱསྠཱནེ ཤྲྀངྑལདྭཡེན བདྡྷྭཿ སན྄ ནིདྲིཏ ཨཱསཱིཏ྄, དཽཝཱརིཀཱཤྩ ཀཱརཱཡཱཿ སམྨུཁེ ཏིཥྛནཏོ དྭཱརམ྄ ཨརཀྵིཥུཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ཨེཏསྨིན྄ སམཡེ པརམེཤྭརསྱ དཱུཏེ སམུཔསྠིཏེ ཀཱརཱ དཱིཔྟིམཏཱི ཛཱཏཱ; ཏཏཿ ས དཱུཏཿ པིཏརསྱ ཀུཀྵཱཝཱཝཱཏཾ ཀྲྀཏྭཱ ཏཾ ཛཱགརཡིཏྭཱ བྷཱཥིཏཝཱན྄ ཏཱུརྞམུཏྟིཥྛ; ཏཏསྟསྱ ཧསྟསྠཤྲྀངྑལདྭཡཾ གལཏ྄ པཏིཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ས དཱུཏསྟམཝདཏ྄, བདྡྷཀཊིཿ སན྄ པཱདཡོཿ པཱདུཀེ ཨརྤཡ; ཏེན ཏཐཱ ཀྲྀཏེ སཏི དཱུཏསྟམ྄ ཨུཀྟཝཱན྄ གཱཏྲཱིཡཝསྟྲཾ གཱཏྲེ ནིདྷཱཡ མམ པཤྩཱད྄ ཨེཧི། ");
INSERT INTO santib_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ཏཏཿ པིཏརསྟསྱ པཤྩཱད྄ ཝྲཛན བཧིརགཙྪཏ྄, ཀིནྟུ དཱུཏེན ཀརྨྨཻཏཏ྄ ཀྲྀཏམིཏི སཏྱམཛྙཱཏྭཱ སྭཔྣདརྴནཾ ཛྙཱཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ཨིཏྠཾ ཏཽ པྲཐམཱཾ དྭིཏཱིཡཱཉྩ ཀཱརཱཾ ལངྒྷིཏྭཱ ཡེན ལཽཧནིརྨྨིཏདྭཱརེཎ ནགརཾ གམྱཏེ ཏཏྶམཱིཔཾ པྲཱཔྣུཏཱཾ; ཏཏསྟསྱ ཀཝཱཊཾ སྭཡཾ མུཀྟམབྷཝཏ྄ ཏཏསྟཽ ཏཏྶྠཱནཱད྄ བཧི རྦྷཱུཏྭཱ མཱརྒཻཀསྱ སཱིམཱཾ ཡཱཝད྄ གཏཽ; ཏཏོ྅ཀསྨཱཏ྄ ས དཱུཏཿ པིཏརཾ ཏྱཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ཏདཱ ས ཙེཏནཱཾ པྲཱཔྱ ཀཐིཏཝཱན྄ ནིཛདཱུཏཾ པྲཧིཏྱ པརམེཤྭརོ ཧེརོདོ ཧསྟཱད྄ ཡིཧཱུདཱིཡལོཀཱནཱཾ སཪྻྭཱཤཱཡཱཤྩ མཱཾ སམུདྡྷྲྀཏཝཱན྄ ཨིཏྱཧཾ ནིཤྩཡཾ ཛྙཱཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ས ཝིཝིཙྱ མཱརྐནཱམྲཱ ཝིཁྱཱཏསྱ ཡོཧནོ མཱཏུ རྨརིཡམོ ཡསྨིན྄ གྲྀཧེ བཧཝཿ སམྦྷཱུཡ པྲཱརྠཡནྟ ཏནྣིཝེཤནཾ གཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","པིཏརེཎ བཧིརྡྭཱར ཨཱཧཏེ སཏི རོདཱནཱམཱ བཱལིཀཱ དྲཥྚུཾ གཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ཏཏཿ པིཏརསྱ སྭརཾ ཤྲུཝཱ སཱ ཧརྵཡུཀྟཱ སཏཱི དྭཱརཾ ན མོཙཡིཏྭཱ པིཏརོ དྭཱརེ ཏིཥྛཏཱིཏི ཝཱརྟྟཱཾ ཝཀྟུམ྄ ཨབྷྱནྟརཾ དྷཱཝིཏྭཱ གཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ཏེ པྲཱཝོཙན྄ ཏྭམུནྨཏྟཱ ཛཱཏཱསི ཀིནྟུ སཱ མུཧུརྨུཧུརུཀྟཝཏཱི སཏྱམེཝཻཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ཏདཱ ཏེ ཀཐིཏཝནྟསྟརྷི ཏསྱ དཱུཏོ བྷཝེཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","པིཏརོ དྭཱརམཱཧཏཝཱན྄ ཨེཏསྨིནྣནྟརེ དྭཱརཾ མོཙཡིཏྭཱ པིཏརཾ དྲྀཥྚྭཱ ཝིསྨཡཾ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ཏཏཿ པིཏརོ ནིཿཤབྡཾ སྠཱཏུཾ ཏཱན྄ པྲཏི ཧསྟེན སངྐེཏཾ ཀྲྀཏྭཱ པརམེཤྭརོ ཡེན པྲཀཱརེཎ ཏཾ ཀཱརཱཡཱ ཨུདྡྷྲྀཏྱཱནཱིཏཝཱན྄ ཏསྱ ཝྲྀཏྟཱནྟཾ ཏཱནཛྙཱཔཡཏ྄, ཡཱུཡཾ གཏྭཱ ཡཱཀུབཾ བྷྲཱཏྲྀགཎཉྩ ཝཱརྟྟཱམེཏཱཾ ཝདཏེཏྱུཀྟཱ སྠཱནཱནྟརཾ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","པྲབྷཱཏེ སཏི པིཏརཿ ཀྭ གཏ ཨིཏྱཏྲ རཀྵཀཱཎཱཾ མདྷྱེ མཧཱན྄ ཀལཧོ ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ཧེརོད྄ བཧུ མྲྀགཡིཏྭཱ ཏསྱོདྡེཤེ ན པྲཱཔྟེ སཏི རཀྵཀཱན྄ སཾཔྲྀཙྪྱ ཏེཥཱཾ པྲཱཎཱན྄ ཧནྟུམ྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","པཤྩཱཏ྄ ས ཡིཧཱུདཱིཡཔྲདེཤཱཏ྄ ཀཻསརིཡཱནགརཾ གཏྭཱ ཏཏྲཱཝཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","སོརསཱིདོནདེཤཡོ རློཀེབྷྱོ ཧེརོདི ཡུཡུཏྶཽ སཏི ཏེ སཪྻྭ ཨེཀམནྟྲཎཱཿ སནྟསྟསྱ སམཱིཔ ཨུཔསྠཱཡ ལྭཱསྟནཱམཱནཾ ཏསྱ ཝསྟྲགྲྀཧཱདྷཱིཤཾ སཧཱཡཾ ཀྲྀཏྭཱ ཧེརོདཱ སཱརྡྡྷཾ སནྡྷིཾ པྲཱརྠཡནྟ ཡཏསྟསྱ རཱཛྙོ དེཤེན ཏེཥཱཾ དེཤཱིཡཱནཱཾ བྷརཎམ྄ ཨབྷཝཏ྄ཾ ");
INSERT INTO santib_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ཨཏཿ ཀུཏྲཙིན྄ ནིརུཔིཏདིནེ ཧེརོད྄ རཱཛཀཱིཡཾ པརིཙྪདཾ པརིདྷཱཡ སིཾཧཱསནེ སམུཔཝིཤྱ ཏཱན྄ པྲཏི ཀཐཱམ྄ ཨུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ཏཏོ ལོཀཱ ཨུཙྩཻཿཀཱརཾ པྲཏྱཝདན྄, ཨེཥ མནུཛརཝོ ན ཧི, ཨཱིཤྭརཱིཡརཝཿ། ");
INSERT INTO santib_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ཏདཱ ཧེརོད྄ ཨཱིཤྭརསྱ སམྨཱནཾ ནཱཀརོཏ྄; ཏསྨཱདྡྷེཏོཿ པརམེཤྭརསྱ དཱུཏོ ཧཋཱཏ྄ ཏཾ པྲཱཧརཏ྄ ཏེནཻཝ ས ཀཱིཊཻཿ ཀྵཱིཎཿ སན྄ པྲཱཎཱན྄ ཨཛཧཱཏ྄། ཀིནྟྭཱིཤྭརསྱ ཀཐཱ དེཤཾ ཝྱཱཔྱ པྲབལཱབྷཝཏ྄། ཏཏཿ པརཾ བརྞབྦཱཤཽལཽ ཡསྱ ཀརྨྨཎོ བྷཱརཾ པྲཱཔྣུཏཱཾ ཏཱབྷྱཱཾ ཏསྨིན྄ སམྤཱདིཏེ སཏི མཱརྐནཱམྣཱ ཝིཁྱཱཏོ ཡོ ཡོཧན྄ ཏཾ སངྒིནཾ ཀྲྀཏྭཱ ཡིརཱུཤཱལམྣགརཱཏ྄ པྲཏྱཱགཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ཨཔརཉྩ བརྞབྦཱཿ, ཤིམོན྄ ཡཾ ནིགྲཾ ཝདནྟི, ཀུརཱིནཱིཡལཱུཀིཡོ ཧེརོདཱ རཱཛྙཱ སཧ ཀྲྀཏཝིདྱཱाབྷྱཱསོ མིནཧེམ྄, ཤཽལཤྩཻཏེ ཡེ ཀིཡནྟོ ཛནཱ བྷཝིཥྱདྭཱདིན ཨུཔདེཥྚཱརཤྩཱནྟིཡཁིཡཱནགརསྠམཎྜལྱཱམ྄ ཨཱསན྄, ");
INSERT INTO santib_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ཏེ ཡདོཔཝཱསཾ ཀྲྀཏྭེཤྭརམ྄ ཨསེཝནྟ ཏསྨིན྄ སམཡེ པཝིཏྲ ཨཱཏྨཱ ཀཐིཏཝཱན྄ ཨཧཾ ཡསྨིན྄ ཀརྨྨཎི བརྞབྦཱཤཻལཽ ནིཡུཀྟཝཱན྄ ཏཏྐརྨྨ ཀརྟྟུཾ ཏཽ པྲྀཐཀ྄ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ཏཏསྟཻརུཔཝཱསཔྲཱརྠནཡོཿ ཀྲྀཏཡོཿ སཏོསྟེ ཏཡོ རྒཱཏྲཡོ རྷསྟཱརྤཎཾ ཀྲྀཏྭཱ ཏཽ ཝྱསྲྀཛན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ཏཏཿ པརཾ ཏཽ པཝིཏྲེཎཱཏྨནཱ པྲེརིཏཽ སནྟཽ སིལཱུཀིཡཱནགརམ྄ ཨུཔསྠཱཡ སམུདྲཔཐེན ཀུཔྲོཔདྭཱིཔམ྄ ཨགཙྪཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ཏཏཿ སཱལཱམཱིནགརམ྄ ཨུཔསྠཱཡ ཏཏྲ ཡིཧཱུདཱིཡཱནཱཾ བྷཛནབྷཝནཱནི གཏྭེཤྭརསྱ ཀཐཱཾ པྲཱཙཱརཡཏཱཾ; ཡོཧནཔི ཏཏྶཧཙརོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ཨིཏྠཾ ཏེ ཏསྱོཔདྭཱིཔསྱ སཪྻྭཏྲ བྷྲམནྟཿ པཱཕནགརམ྄ ཨུཔསྠིཏཱཿ; ཏཏྲ སུཝིཝེཙཀེན སརྫིཡཔཽལནཱམྣཱ ཏདྡེཤཱདྷིཔཏིནཱ སཧ བྷཝིཥྱདྭཱདིནོ ཝེཤདྷཱརཱི བཪྻཱིཤུནཱམཱ ཡོ མཱཡཱཝཱི ཡིཧཱུདཱི ཨཱསཱིཏ྄ ཏཾ སཱཀྵཱཏ྄ པྲཱཔྟཝཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ཏདྡེཤཱདྷིཔ ཨཱིཤྭརསྱ ཀཐཱཾ ཤྲོཏུཾ ཝཱཉྪན྄ པཽལབརྞབྦཽ ནྱམནྟྲཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ཀིནྟྭིལུམཱ ཡཾ མཱཡཱཝིནཾ ཝདནྟི ས དེཤཱདྷིཔཏིཾ དྷརྨྨམཱརྒཱད྄ བཧིརྦྷཱུཏཾ ཀརྟྟུམ྄ ཨཡཏཏ། ");
INSERT INTO santib_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ཏསྨཱཏ྄ ཤོལོ྅རྠཱཏ྄ པཽལཿ པཝིཏྲེཎཱཏྨནཱ པརིཔཱུརྞཿ སན྄ ཏཾ མཱཡཱཝིནཾ པྲཏྱནནྱདྲྀཥྚིཾ ཀྲྀཏྭཱཀཐཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ཧེ ནརཀིན྄ དྷརྨྨདྭེཥིན྄ ཀཽཊིལྱདུཥྐརྨྨཔརིཔཱུརྞ, ཏྭཾ ཀིཾ པྲབྷོཿ སཏྱཔཐསྱ ཝིཔཪྻྱཡཀརཎཱཏ྄ ཀདཱཔི ན ནིཝརྟྟིཥྱསེ? ");
INSERT INTO santib_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ཨདྷུནཱ པརམེཤྭརསྟཝ སམུཙིཏཾ ཀརིཥྱཏི ཏེན ཀཏིཔཡདིནཱནི ཏྭམ྄ ཨནྡྷཿ སན྄ སཱུཪྻྱམཔི ན དྲཀྵྱསི། ཏཏྐྵཎཱད྄ རཱཏྲིཝད྄ ཨནྡྷཀཱརསྟསྱ དྲྀཥྚིམ྄ ཨཱཙྪཱདིཏཝཱན྄; ཏསྨཱཏ྄ ཏསྱ ཧསྟཾ དྷརྟྟུཾ ས ལོཀམནྭིཙྪན྄ ཨིཏསྟཏོ བྷྲམཎཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ཨེནཱཾ གྷཊནཱཾ དྲྀཥྚྭཱ ས དེཤཱདྷིཔཏིཿ པྲབྷཱུཔདེཤཱད྄ ཝིསྨིཏྱ ཝིཤྭཱསཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ཏདནནྟརཾ པཽལསྟཏྶངྒིནཽ ཙ པཱཕནགརཱཏ྄ པྲོཏཾ ཙཱལཡིཏྭཱ པམྥུལིཡཱདེཤསྱ པརྒཱིནགརམ྄ ཨགཙྪན྄ ཀིནྟུ ཡོཧན྄ ཏཡོཿ སམཱིཔཱད྄ ཨེཏྱ ཡིརཱུཤཱལམཾ པྲཏྱཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","པཤྩཱཏ྄ ཏཽ པརྒཱིཏོ ཡཱཏྲཱཾ ཀྲྀཏྭཱ པིསིདིཡཱདེཤསྱ ཨཱནྟིཡཁིཡཱནགརམ྄ ཨུཔསྠཱཡ ཝིཤྲཱམཝཱརེ བྷཛནབྷཝནཾ པྲཝིཤྱ སམུཔཱཝིཤཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ཝྱཝསྠཱབྷཝིཥྱདྭཱཀྱཡོཿ པཋིཏཡོཿ སཏོ རྷེ བྷྲཱཏརཽ ལོཀཱན྄ པྲཏི ཡུཝཡོཿ ཀཱཙིད྄ ཨུཔདེཤཀཐཱ ཡདྱསྟི ཏརྷི ཏཱཾ ཝདཏཾ ཏཽ པྲཏི ཏསྱ བྷཛནབྷཝནསྱཱདྷིཔཏཡཿ ཀཐཱམ྄ ཨེཏཱཾ ཀཐཡིཏྭཱ པྲཻཥཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ཨཏཿ པཽལ ཨུཏྟིཥྛན྄ ཧསྟེན སངྐེཏཾ ཀུཪྻྭན྄ ཀཐིཏཝཱན྄ ཧེ ཨིསྲཱཡེལཱིཡམནུཥྱཱ ཨཱིཤྭརཔརཱཡཎཱཿ སཪྻྭེ ལོཀཱ ཡཱུཡམ྄ ཨཝདྷདྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ཨེཏེཥཱམིསྲཱཡེལློཀཱནཱམ྄ ཨཱིཤྭརོ྅སྨཱཀཾ པཱུཪྻྭཔརུཥཱན྄ མནོནཱིཏཱན྄ ཀཏྭཱ གྲྀཧཱིཏཝཱན྄ ཏཏོ མིསརི དེཤེ པྲཝསནཀཱལེ ཏེཥཱམུནྣཏིཾ ཀྲྀཏྭཱ ཏསྨཱཏ྄ སྭཱིཡབཱཧུབལེན ཏཱན྄ བཧིཿ ཀྲྀཏྭཱ སམཱནཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ཙཏྭཱརིཾཤདྭཏྶརཱན྄ ཡཱཝཙྩ མཧཱཔྲཱནྟརེ ཏེཥཱཾ བྷརཎཾ ཀྲྀཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ཀིནཱནྡེཤཱནྟཪྻྭརྟྟཱིཎི སཔྟརཱཛྱཱནི ནཱཤཡིཏྭཱ གུཊིཀཱཔཱཏེན ཏེཥུ སཪྻྭདེཤེཥུ ཏེབྷྱོ྅དྷིཀཱརཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","པཉྩཱཤདདྷིཀཙཏུཿཤཏེཥུ ཝཏྶརེཥུ གཏེཥུ ཙ ཤིམཱུཡེལྦྷཝིཥྱདྭཱདིཔཪྻྱནྟཾ ཏེཥཱམུཔརི ཝིཙཱརཡིཏྲྀན྄ ནིཡུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ཏཻཤྩ རཱཛྙི པྲཱརྠིཏེ, ཨཱིཤྭརོ བིནྱཱམཱིནོ ཝཾཤཛཱཏསྱ ཀཱིཤཿ པུཏྲཾ ཤཽལཾ ཙཏྭཱརིཾཤདྭརྵཔཪྻྱནྟཾ ཏེཥཱམུཔརི རཱཛཱནཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","པཤྩཱཏ྄ ཏཾ པདཙྱུཏཾ ཀྲྀཏྭཱ ཡོ མདིཥྚཀྲིཡཱཿ སཪྻྭཱཿ ཀརིཥྱཏི ཏཱདྲྀཤཾ མམ མནོབྷིམཏམ྄ ཨེཀཾ ཛནཾ ཡིཤཡཿ པུཏྲཾ དཱཡཱུདཾ པྲཱཔྟཝཱན྄ ཨིདཾ པྲམཱཎཾ ཡསྨིན྄ དཱཡཱུདི ས དཏྟཝཱན྄ ཏཾ དཱཡཱུདཾ ཏེཥཱམུཔརི རཱཛཏྭཾ ཀརྟྟུམ྄ ཨུཏྤཱདིཏཝཱན། ");
INSERT INTO santib_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ཏསྱ སྭཔྲཏིཤྲུཏསྱ ཝཱཀྱསྱཱནུསཱརེཎ ཨིསྲཱཡེལློཀཱནཱཾ ནིམིཏྟཾ ཏེཥཱཾ མནུཥྱཱཎཱཾ ཝཾཤཱད྄ ཨཱིཤྭར ཨེཀཾ ཡཱིཤུཾ (ཏྲཱཏཱརམ྄) ཨུདཔཱདཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ཏསྱ པྲཀཱཤནཱཏ྄ པཱུཪྻྭཾ ཡོཧན྄ ཨིསྲཱཡེལློཀཱནཱཾ སནྣིདྷཽ མནཿཔརཱཝརྟྟནརཱུཔཾ མཛྫནཾ པྲཱཙཱརཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ཡསྱ ཙ ཀརྨྨཎོे བྷཱརཾ པྲཔྟཝཱན྄ ཡོཧན྄ ཏན྄ ནིཥྤཱདཡན྄ ཨེཏཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄, ཡཱུཡཾ མཱཾ ཀཾ ཛནཾ ཛཱནཱིཐ? ཨཧམ྄ ཨབྷིཥིཀྟཏྲཱཏཱ ནཧི, ཀིནྟུ པཤྱཏ ཡསྱ པཱདཡོཿ པཱདུཀཡོ རྦནྡྷནེ མོཙཡིཏུམཔི ཡོགྱོ ན བྷཝཱམི ཏཱདྲྀཤ ཨེཀོ ཛནོ མམ པཤྩཱད྄ ཨུཔཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ཧེ ཨིབྲཱཧཱིམོ ཝཾཤཛཱཏཱ བྷྲཱཏརོ ཧེ ཨཱིཤྭརབྷཱིཏཱཿ སཪྻྭལོཀཱ ཡུཥྨཱན྄ པྲཏི པརིཏྲཱཎསྱ ཀཐཻཥཱ པྲེརིཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ཡིརཱུཤཱལམྣིཝཱསིནསྟེཥཱམ྄ ཨདྷིཔཏཡཤྩ ཏསྱ ཡཱིཤོཿ པརིཙཡཾ ན པྲཱཔྱ པྲཏིཝིཤྲཱམཝཱརཾ པཋྱམཱནཱནཱཾ བྷཝིཥྱདྭཱདིཀཐཱནཱམ྄ ཨབྷིཔྲཱཡམ྄ ཨབུདྡྷྭཱ ཙ ཏསྱ ཝདྷེན ཏཱཿ ཀཐཱཿ སཕལཱ ཨཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","པྲཱཎཧནནསྱ ཀམཔི ཧེཏུམ྄ ཨཔྲཱཔྱཱཔི པཱིལཱཏསྱ ནིཀཊེ ཏསྱ ཝདྷཾ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ཏསྨིན྄ ཡཱཿ ཀཐཱ ལིཁིཏཱཿ སནྟི ཏདནུསཱརེཎ ཀརྨྨ སམྤཱདྱ ཏཾ ཀྲུཤཱད྄ ཨཝཏཱཪྻྱ ཤྨཤཱནེ ཤཱཡིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ཀིནྟྭཱིཤྭརཿ ཤྨཤཱནཱཏ྄ ཏམུདསྠཱཔཡཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","པུནཤྩ གཱལཱིལཔྲདེཤཱད྄ ཡིརཱུཤཱལམནགརཾ ཏེན སཱརྡྡྷཾ ཡེ ལོཀཱ ཨཱགཙྪན྄ ས བཧུདིནཱནི ཏེབྷྱོ དརྴནཾ དཏྟཝཱན྄, ཨཏསྟ ཨིདཱནཱིཾ ལོཀཱན྄ པྲཏི ཏསྱ སཱཀྵིཎཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱཎཱཾ སམཀྵམ྄ ཨཱིཤྭརོ ཡསྨིན྄ པྲཏིཛྙཱཏཝཱན྄ ཡཐཱ, ཏྭཾ མེ པུཏྲོསི ཙཱདྱ ཏྭཱཾ སམུཏྠཱཔིཏཝཱནཧམ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ཨིདཾ ཡདྭཙནཾ དྭིཏཱིཡགཱིཏེ ལིཁིཏམཱསྟེ ཏད྄ ཡཱིཤོརུཏྠཱནེན ཏེཥཱཾ སནྟཱནཱ ཡེ ཝཡམ྄ ཨསྨཱཀཾ སནྣིདྷཽ ཏེན པྲཏྱཀྵཱི ཀྲྀཏཾ, ཡུཥྨཱན྄ ཨིམཾ སུསཾཝཱདཾ ཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","པརམེཤྭརེཎ ཤྨཤཱནཱད྄ ཨུཏྠཱཔིཏཾ ཏདཱིཡཾ ཤརཱིརཾ ཀདཱཔི ན ཀྵེཥྱཏེ, ཨེཏསྨིན྄ ས སྭཡཾ ཀཐིཏཝཱན྄ ཡཐཱ དཱཡཱུདཾ པྲཏི པྲཏིཛྙཱཏོ ཡོ ཝརསྟམཧཾ ཏུབྷྱཾ དཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ཨེཏདནྱསྨིན྄ གཱིཏེ྅པི ཀཐིཏཝཱན྄། སྭཀཱིཡཾ པུཎྱཝནྟཾ ཏྭཾ ཀྵཡིཏུཾ ན ཙ དཱསྱསི། ");
INSERT INTO santib_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","དཱཡཱུདཱ ཨཱིཤྭརཱབྷིམཏསེཝཱཡཻ ནིཛཱཡུཥི ཝྱཡིཏེ སཏི ས མཧཱནིདྲཱཾ པྲཱཔྱ ནིཛཻཿ པཱུཪྻྭཔུརུཥཻཿ སཧ མིལིཏཿ སན྄ ཨཀྵཱིཡཏ; ");
INSERT INTO santib_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ཀིནྟུ ཡམཱིཤྭརཿ ཤྨཤཱནཱད྄ ཨུདསྠཱཔཡཏ྄ ས ནཱཀྵཱིཡཏ། ");
INSERT INTO santib_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ཨཏོ ཧེ བྷྲཱཏརཿ, ཨནེན ཛནེན པཱཔམོཙནཾ བྷཝཏཱིཏི ཡུཥྨཱན྄ པྲཏི པྲཙཱརིཏམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ཕལཏོ མཱུསཱཝྱཝསྠཡཱ ཡཱུཡཾ ཡེབྷྱོ དོཥེབྷྱོ མུཀྟཱ བྷཝིཏུཾ ན ཤཀྵྱཐ ཏེབྷྱཿ སཪྻྭདོཥེབྷྱ ཨེཏསྨིན྄ ཛནེ ཝིཤྭཱསིནཿ སཪྻྭེ མུཀྟཱ བྷཝིཥྱནྟཱིཏི ཡུཥྨཱབྷི རྫྙཱཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ཨཔརཉྩ། ཨཝཛྙཱཀཱརིཎོ ལོཀཱཤྩཀྵུརུནྨཱིལྱ པཤྱཏ། ཏཐཻཝཱསམྦྷཝཾ ཛྙཱཏྭཱ སྱཱཏ ཡཱུཡཾ ཝིལཛྫིཏཱཿ། ཡཏོ ཡུཥྨཱསུ ཏིཥྛཏྶུ ཀརིཥྱེ ཀརྨྨ ཏཱདྲྀཤཾ། ཡེནཻཝ ཏསྱ ཝྲྀཏྟཱནྟེ ཡུཥྨབྷྱཾ ཀཐིཏེ྅པི ཧི། ཡཱུཡཾ ན ཏནྟུ ཝྲྀཏྟཱནྟཾ པྲཏྱེཥྱཐ ཀདཱཙན༎ ");
INSERT INTO santib_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ཡེཡཾ ཀཐཱ བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེཥུ ལིཁིཏཱསྟེ སཱཝདྷཱནཱ བྷཝཏ ས ཀཐཱ ཡཐཱ ཡུཥྨཱན྄ པྲཏི ན གྷཊཏེ། ");
INSERT INTO santib_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ཡིཧཱུདཱིཡབྷཛནབྷཝནཱན྄ ནིརྒཏཡོསྟཡོ རྦྷིནྣདེཤཱིཡཻ ཪྻཀྵྱམཱཎཱ པྲཱརྠནཱ ཀྲྀཏཱ, ཨཱགཱམིནི ཝིཤྲཱམཝཱརེ྅པི ཀཐེཡམ྄ ཨསྨཱན྄ པྲཏི པྲཙཱརིཏཱ བྷཝཏྭིཏི། ");
INSERT INTO santib_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","སབྷཱཡཱ བྷངྒེ སཏི བཧཝོ ཡིཧཱུདཱིཡལོཀཱ ཡིཧཱུདཱིཡམཏགྲཱཧིཎོ བྷཀྟལོཀཱཤྩ བརྞབྦཱཔཽལཡོཿ པཤྩཱད྄ ཨཱགཙྪན྄, ཏེན ཏཽ ཏཻཿ སཧ ནཱནཱཀཐཱཿ ཀཐཡིཏྭེཤྭརཱནུགྲཧཱཤྲཡེ སྠཱཏུཾ ཏཱན྄ པྲཱཝརྟྟཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","པརཝིཤྲཱམཝཱརེ ནགརསྱ པྲཱཡེཎ སཪྻྭེ ལཱཀཱ ཨཱིཤྭརཱིཡཱཾ ཀཐཱཾ ཤྲོཏུཾ མིལིཏཱཿ, ");
INSERT INTO santib_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ཀིནྟུ ཡིཧཱུདཱིཡལོཀཱ ཛནནིཝཧཾ ཝིལོཀྱ ཨཱིརྵྱཡཱ པརིཔཱུརྞཱཿ སནྟོ ཝིཔརཱིཏཀཐཱཀཐནེནེཤྭརནིནྡཡཱ ཙ པཽལེནོཀྟཱཾ ཀཐཱཾ ཁཎྜཡིཏུཾ ཙེཥྚིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ཏཏཿ པཽैལབརྞབྦཱཝཀྵོབྷཽ ཀཐིཏཝནྟཽ པྲཐམཾ ཡུཥྨཱཀཾ སནྣིདྷཱཝཱིཤྭརཱིཡཀཐཱཡཱཿ པྲཙཱརཎམ྄ ཨུཙིཏམཱསཱིཏ྄ ཀིནྟུཾ ཏདགྲཱཧྱཏྭཀརཎེན ཡཱུཡཾ སྭཱན྄ ཨནནྟཱཡུཥོ྅ཡོགྱཱན྄ དརྴཡཐ, ཨེཏཏྐཱརཎཱད྄ ཝཡམ྄ ཨནྱདེཤཱིཡལོཀཱནཱཾ སམཱིཔཾ གཙྪཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","པྲབྷུརསྨཱན྄ ཨིཏྠམ྄ ཨཱདིཥྚཝཱན྄ ཡཐཱ, ཡཱཝཙྩ ཛགཏཿ སཱིམཱཾ ལོཀཱནཱཾ ཏྲཱཎཀཱརཎཱཏ྄། མཡཱནྱདེཤམདྷྱེ ཏྭཾ སྠཱཔིཏོ བྷཱུཿ པྲདཱིཔཝཏ྄༎ ");
INSERT INTO santib_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ཏདཱ ཀཐཱམཱིདྲྀཤཱིཾ ཤྲུཏྭཱ བྷིནྣདེཤཱིཡཱ ཨཱཧླཱདིཏཱཿ སནྟཿ པྲབྷོཿ ཀཐཱཾ དྷནྱཱཾ དྷནྱཱམ྄ ཨཝདན྄, ཡཱཝནྟོ ལོཀཱཤྩ པརམཱཡུཿ པྲཱཔྟིནིམིཏྟཾ ནིརཱུཔིཏཱ ཨཱསན྄ ཏེे ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ཨིཏྠཾ པྲབྷོཿ ཀཐཱ སཪྻྭེདེཤཾ ཝྱཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ཀིནྟུ ཡིཧཱུདཱིཡཱ ནགརསྱ པྲདྷཱནཔུརུཥཱན྄ སམྨཱནྱཱཿ ཀཐིཔཡཱ བྷཀྟཱ ཡོཥིཏཤྩ ཀུཔྲཝྲྀཏྟིཾ གྲཱཧཡིཏྭཱ པཽལབརྞབྦཽ ཏཱཌཡིཏྭཱ ཏསྨཱཏ྄ པྲདེཤཱད྄ དཱུརཱིཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ཨཏཿ ཀཱརཎཱཏ྄ ཏཽ ནིཛཔདདྷཱུལཱིསྟེཥཱཾ པྲཱཏིཀཱུལྱེན པཱཏཡིཏྭེेཀནིཡཾ ནགརཾ གཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ཏཏཿ ཤིཥྱགཎ ཨཱནནྡེན པཝིཏྲེཎཱཏྨནཱ ཙ པརིཔཱུརྞོབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ཏཽ དྭཽ ཛནཽ ཡུགཔད྄ ཨིཀནིཡནགརསྠཡིཧཱུདཱིཡཱནཱཾ བྷཛནབྷཝནཾ གཏྭཱ ཡཐཱ བཧཝོ ཡིཧཱུདཱིཡཱ ཨནྱདེेཤཱིཡལོཀཱཤྩ ཝྱཤྭསན྄ ཏཱདྲྀཤཱིཾ ཀཐཱཾ ཀཐིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ཀིནྟུ ཝིཤྭཱསཧཱིནཱ ཡིཧཱུདཱིཡཱ ཨནྱདེཤཱིཡལོཀཱན྄ ཀུཔྲཝྲྀཏྟིཾ གྲཱཧཡིཏྭཱ བྷྲཱཏྲྀགཎཾ པྲཏི ཏེཥཱཾ ཝཻརཾ ཛནིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ཨཏཿ སྭཱནུགྲཧཀཐཱཡཱཿ པྲམཱཎཾ དཏྭཱ ཏཡོ རྷསྟཻ རྦཧུལཀྵཎམ྄ ཨདྦྷུཏཀརྨྨ ཙ པྲཱཀཱཤཡད྄ ཡཿ པྲབྷུསྟསྱ ཀཐཱ ཨཀྵོབྷེན པྲཙཱཪྻྱ ཏཽ ཏཏྲ བཧུདིནཱནི སམཝཱཏིཥྛེཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ཀིནྟུ ཀིཡནྟོ ལོཀཱ ཡིཧཱུདཱིཡཱནཱཾ སཔཀྵཱཿ ཀིཡནྟོ ལོཀཱཿ པྲེརིཏཱནཱཾ སཔཀྵཱ ཛཱཏཱཿ, ཨཏོ ནཱགརིཀཛནནིཝཧམདྷྱེ བྷིནྣཝཱཀྱཏྭམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ཨནྱདེཤཱིཡཱ ཡིཧཱུདཱིཡཱསྟེཥཱམ྄ ཨདྷིཔཏཡཤྩ དཽརཱཏྨྱཾ ཀུཏྭཱ ཏཽ པྲསྟརཻརཱཧནྟུམ྄ ཨུདྱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ཏཽ ཏདྭཱརྟྟཱཾ པྲཱཔྱ པལཱཡིཏྭཱ ལུཀཱཡནིཡཱདེཤསྱཱནྟཪྻྭརྟྟིལུསྟྲཱདརྦྦོ ");
INSERT INTO santib_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ཏཏྶམཱིཔསྠདེཤཉྩ གཏྭཱ ཏཏྲ སུསཾཝཱདཾ པྲཙཱརཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ཏཏྲོབྷཡཔཱདཡོཤྩལནཤཀྟིཧཱིནོ ཛནྨཱརབྷྱ ཁཉྫཿ ཀདཱཔི གམནཾ ནཱཀརོཏ྄ ཨེཏཱདྲྀཤ ཨེཀོ མཱནུཥོ ལུསྟྲཱནགར ཨུཔཝིཤྱ པཽལསྱ ཀཐཱཾ ཤྲུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ཨེཏསྨིན྄ སམཡེ པཽལསྟམྤྲཏི དྲྀཥྚིཾ ཀྲྀཏྭཱ ཏསྱ སྭཱསྠྱེ ཝིཤྭཱསཾ ཝིདིཏྭཱ པྲོཙྩཻཿ ཀཐིཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","པདྦྷྱཱམུཏྟིཥྛན྄ ཨྲྀཛུ རྦྷཝ། ཏཏཿ ས ཨུལླམྥཾ ཀྲྀཏྭཱ གམནཱགམནེ ཀུཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ཏདཱ ལོཀཱཿ པཽལསྱ ཏཏ྄ ཀཱཪྻྱཾ ཝིལོཀྱ ལུཀཱཡནཱིཡབྷཱཥཡཱ པྲོཙྩཻཿ ཀཐཱམེཏཱཾ ཀཐིཏཝནྟཿ, དེཝཱ མནུཥྱརཱུཔཾ དྷྲྀཏྭཱསྨཱཀཾ སམཱིཔམ྄ ཨཝཱརོཧན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ཏེ བརྞབྦཱཾ ཡཱུཔིཏརམ྄ ཨཝདན྄ པཽལཤྩ མུཁྱོ ཝཀྟཱ ཏསྨཱཏ྄ ཏཾ མརྐུརིཡམ྄ ཨཝདན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ཏསྱ ནགརསྱ སམྨུཁེ སྠཱཔིཏསྱ ཡཱུཔིཏརཝིགྲཧསྱ ཡཱཛཀོ ཝྲྀཥཱན྄ པུཥྤམཱལཱཤྩ དྭཱརསམཱིཔམ྄ ཨཱནཱིཡ ལོཀཻཿ སརྡྡྷཾ ཏཱཝུདྡིཤྱ སམུཏྶྲྀཛྱ དཱཏུམ྄ ཨུདྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ཏདྭཱརྟྟཱཾ ཤྲུཏྭཱ བརྞབྦཱཔཽལཽ སྭཱིཡཝསྟྲཱཎི ཚིཏྭཱ ལོཀཱནཱཾ མདྷྱཾ ཝེགེན པྲཝིཤྱ པྲོཙྩཻཿ ཀཐིཏཝནྟཽ, ");
INSERT INTO santib_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ཧེ མཧེཙྪཱཿ ཀུཏ ཨེཏཱདྲྀཤཾ ཀརྨྨ ཀུརུཐ? ཨཱཝཱམཔི ཡུཥྨཱདྲྀཤཽ སུཁདུཿཁབྷོགིནཽ མནུཥྱཽ, ཡུཡམ྄ ཨེཏཱཿ སཪྻྭཱ ཝྲྀཐཱཀལྤནཱཿ པརིཏྱཛྱ ཡཐཱ གགཎཝསུནྡྷརཱཛལནིདྷཱིནཱཾ ཏནྨདྷྱསྠཱནཱཾ སཪྻྭེཥཱཉྩ སྲཥྚཱརམམརམ྄ ཨཱིཤྭརཾ པྲཏི པརཱཝརྟྟདྷྭེ ཏདརྠམ྄ ཨཱཝཱཾ ཡུཥྨཱཀཾ སནྣིདྷཽ སུསཾཝཱདཾ པྲཙཱརཡཱཝཿ། ");
INSERT INTO santib_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ས ཨཱིཤྭརཿ པཱུཪྻྭཀཱལེ སཪྻྭདེཤཱིཡལོཀཱན྄ སྭསྭམཱརྒེ ཙལིཏུམནུམཏིཾ དཏྟཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ཏཐཱཔི ཨཱཀཱཤཱཏ྄ ཏོཡཝརྵཎེན ནཱནཱཔྲཀཱརཤསྱོཏྤཏྱཱ ཙ ཡུཥྨཱཀཾ ཧིཏཻཥཱི སན྄ བྷཀྵྱཻརཱནནདེན ཙ ཡུཥྨཱཀམ྄ ཨནྟཿཀརཎཱནི ཏརྤཡན྄ ཏཱནི དཱནཱནི ནིཛསཱཀྵིསྭརཱུཔཱཎི སྠཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ཀིནྟུ ཏཱདྲྀཤཱཡཱཾ ཀཐཱཡཱཾ ཀཐིཏཱཡཱམཔི ཏཡོཿ སམཱིཔ ཨུཏྶརྫནཱཏ྄ ལོཀནིཝཧཾ པྲཱཡེཎ ནིཝརྟྟཡིཏུཾ ནཱཤཀྣུཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ཨཱནྟིཡཁིཡཱ-ཨིཀནིཡནགརཱབྷྱཱཾ ཀཏིཔཡཡིཧཱུདཱིཡལོཀཱ ཨཱགཏྱ ལོཀཱན྄ པྲཱཝརྟྟཡནྟ ཏསྨཱཏ྄ ཏཻ པཽལཾ པྲསྟརཻརཱགྷྣན྄ ཏེན ས མྲྀཏ ཨིཏི ཝིཛྙཱཡ ནགརསྱ བཧིསྟམ྄ ཨཱཀྲྀཥྱ ནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ཀིནྟུ ཤིཥྱགཎེ ཏསྱ ཙཏུརྡིཤི ཏིཥྛཏི སཏི ས སྭཡམ྄ ཨུཏྠཱཡ པུནརཔི ནགརམདྷྱཾ པྲཱཝིཤཏ྄ ཏཏྤརེ྅ཧནི བརྞབྦཱསཧིཏོ དརྦྦཱིནགརཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ཏཏྲ སུསཾཝཱདཾ པྲཙཱཪྻྱ བཧུལོཀཱན྄ ཤིཥྱཱན྄ ཀྲྀཏྭཱ ཏཽ ལུསྟྲཱམ྄ ཨིཀནིཡམ྄ ཨཱནྟིཡཁིཡཱཉྩ པརཱཝྲྀཏྱ གཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","བཧུདུཿཁཱནི བྷུཀྟྭཱཔཱིཤྭརརཱཛྱཾ པྲཝེཥྚཝྱམ྄ ཨིཏི ཀཱརཎཱད྄ དྷརྨྨམཱརྒེ སྠཱཏུཾ ཝིནཡཾ ཀྲྀཏྭཱ ཤིཥྱགཎསྱ མནཿསྠཻཪྻྱམ྄ ཨཀུརུཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","མཎྜལཱིནཱཾ པྲཱཙཱིནཝརྒཱན྄ ནིཡུཛྱ པྲཱརྠནོཔཝཱསཽ ཀྲྀཏྭཱ ཡཏྤྲབྷཽ ཏེ ཝྱཤྭསན྄ ཏསྱ ཧསྟེ ཏཱན྄ སམརྤྱ ");
INSERT INTO santib_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","པིསིདིཡཱམདྷྱེན པཱམྥུལིཡཱདེཤཾ གཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","པཤྩཱཏ྄ པརྒཱནགརཾ གཏྭཱ སུསཾཝཱདཾ པྲཙཱཪྻྱ ཨཏྟཱལིཡཱནགརཾ པྲསྠིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ཏསྨཱཏ྄ སམུདྲཔཐེན གཏྭཱ ཏཱབྷྱཱཾ ཡཏ྄ ཀརྨྨ སམྤནྣཾ ཏཏྐརྨྨ སཱདྷཡིཏུཾ ཡནྣགརེ དཡཱལོརཱིཤྭརསྱ ཧསྟེ སམརྤིཏཽ ཛཱཏཽ ཏད྄ ཨཱནྟིཡཁིཡཱནགརཾ གཏཝནྟཱ། ");
INSERT INTO santib_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ཏཏྲོཔསྠཱཡ ཏནྣགརསྠམཎྜལཱིཾ སཾགྲྀཧྱ སྭཱབྷྱཱམ ཨཱིཤྭརོ ཡདྱཏ྄ ཀརྨྨཀརོཏ྄ ཏཐཱ ཡེན པྲཀཱརེཎ བྷིནྣདེཤཱིཡལོཀཱན྄ པྲཏི ཝིཤྭཱསརཱུཔདྭཱརམ྄ ཨམོཙཡད྄ ཨེཏཱན྄ སཪྻྭཝྲྀཏྟཱནྟཱན྄ ཏཱན྄ ཛྙཱཔིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ཏཏསྟཽ ཤིཪྻྱཻཿ སཱརྡྡྷཾ ཏཏྲ བཧུདིནཱནི ནྱཝསཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ཡིཧཱུདཱདེཤཱཏ྄ ཀིཡནྟོ ཛནཱ ཨཱགཏྱ བྷྲཱཏྲྀགཎམིཏྠཾ ཤིཀྵིཏཝནྟོ མཱུསཱཝྱཝསྠཡཱ ཡདི ཡུཥྨཱཀཾ ཏྭཀྪེདོ ན བྷཝཏི ཏརྷི ཡཱུཡཾ པརིཏྲཱཎཾ པྲཱཔྟུཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","པཽལབརྞབྦཽ ཏཻཿ སཧ བཧཱུན྄ ཝིཙཱརཱན྄ ཝིཝཱདཱཾཤྩ ཀྲྀཏཝནྟཽ, ཏཏོ མཎྜལཱིཡནོཀཱ ཨེཏསྱཱཿ ཀཐཱཡཱསྟཏྟྭཾ ཛྙཱཏུཾ ཡིརཱུཤཱལམྣགརསྠཱན྄ པྲེརིཏཱན྄ པྲཱཙཱིནཱཾཤྩ པྲཏི པཽལབརྞབྦཱཔྲབྷྲྀཏཱིན྄ ཀཏིཔཡཛནཱན྄ པྲེཥཡིཏུཾ ནིཤྩཡཾ ཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ཏེ མཎྜལྱཱ པྲེརིཏཱཿ སནྟཿ ཕཻཎཱིཀཱིཤོམིརོནྡེཤཱབྷྱཱཾ གཏྭཱ བྷིནྣདེཤཱིཡཱནཱཾ མནཿཔརིཝརྟྟནསྱ ཝཱརྟྟཡཱ བྷྲཱཏྲྀཎཱཾ པརམཱཧླཱདམ྄ ཨཛནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ཡིརཱུཤཱལམྱུཔསྠཱཡ པྲེརིཏགཎེན ལོཀཔྲཱཙཱིནགཎེན སམཱཛེན ཙ སམུཔགྲྀཧཱིཏཱཿ སནྟཿ སྭཻརཱིཤྭརོ ཡཱནི ཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ཏེཥཱཾ སཪྻྭཝྲྀཏྟཱནྟཱན྄ ཏེཥཱཾ སམཀྵམ྄ ཨཀཐཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ཀིནྟུ ཝིཤྭཱསིནཿ ཀིཡནྟཿ ཕིརཱུཤིམཏགྲཱཧིཎོ ལོཀཱ ཨུཏྠཱཡ ཀཐཱམེཏཱཾ ཀཐིཏཝནྟོ བྷིནྣདེཤཱིཡཱནཱཾ ཏྭཀྪེདཾ ཀརྟྟུཾ མཱུསཱཝྱཝསྠཱཾ པཱལཡིཏུཉྩ སམཱདེཥྚཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ཏཏཿ པྲེརིཏཱ ལོཀཔྲཱཙཱིནཱཤྩ ཏསྱ ཝིཝེཙནཱཾ ཀརྟྟུཾ སབྷཱཡཱཾ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","བཧུཝིཙཱརེཥུ ཛཱཏཥུ པིཏར ཨུཏྠཱཡ ཀཐིཏཝཱན྄, ཧེ བྷྲཱཏརོ ཡཐཱ བྷིནྣདེཤཱིཡལོཀཱ མམ མུཁཱཏ྄ སུསཾཝཱདཾ ཤྲུཏྭཱ ཝིཤྭསནྟི ཏདརྠཾ བཧུདིནཱཏ྄ པཱུཪྻྭམ྄ ཨཱིཤྭརོསྨཱཀཾ མདྷྱེ མཱཾ ཝྲྀཏྭཱ ནིཡུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ཨནྟཪྻྱཱམཱིཤྭརོ ཡཐཱསྨབྷྱཾ ཏཐཱ བྷིནྣདེཤཱིཡེབྷྱཿ པཝིཏྲམཱཏྨཱནཾ པྲདཱཡ ཝིཤྭཱསེན ཏེཥཱམ྄ ཨནྟཿཀརཎཱནི པཝིཏྲཱཎི ཀྲྀཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ཏེཥཱམ྄ ཨསྨཱཀཉྩ མདྷྱེ ཀིམཔི ཝིཤེཥཾ ན སྠཱཔཡིཏྭཱ ཏཱནདྷི སྭཡཾ པྲམཱཎཾ དཏྟཝཱན྄ ཨིཏི ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ཨཏཨེཝཱསྨཱཀཾ པཱུཪྻྭཔུརུཥཱ ཝཡཉྩ སྭཡཾ ཡདྱུགསྱ བྷཱརཾ སོཌྷུཾ ན ཤཀྟཱཿ སམྤྲཏི ཏཾ ཤིཥྱགཎསྱ སྐནྡྷེཥུ ནྱསིཏུཾ ཀུཏ ཨཱིཤྭརསྱ པརཱིཀྵཱཾ ཀརིཥྱཐ? ");
INSERT INTO santib_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱཱནུགྲཧེཎ ཏེ ཡཐཱ ཝཡམཔི ཏཐཱ པརིཏྲཱཎཾ པྲཱཔྟུམ྄ ཨཱཤཱཾ ཀུརྨྨཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ཨནནྟརཾ བརྞབྦཱཔཽལཱབྷྱཱམ྄ ཨཱིཤྭརོ བྷིནྣདེཤཱིཡཱནཱཾ མདྷྱེ ཡདྱད྄ ཨཱཤྩཪྻྱམ྄ ཨདྦྷུཏཉྩ ཀརྨྨ ཀྲྀཏཝཱན྄ ཏདྭྲྀཏྟཱནྟཾ ཏཽ སྭམུཁཱབྷྱཱམ྄ ཨཝརྞཡཏཱཾ སབྷཱསྠཱཿ སཪྻྭེ ནཱིརཝཱཿ སནྟཿ ཤྲུཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ཏཡོཿ ཀཐཱཡཱཾ སམཱཔྟཱཡཱཾ སཏྱཱཾ ཡཱཀཱུབ྄ ཀཐཡིཏུམ྄ ཨཱརབྡྷཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ཧེ བྷྲཱཏརོ མམ ཀཐཱཡཱམ྄ མནོ ནིདྷཏྟ། ཨཱིཤྭརཿ སྭནཱམཱརྠཾ བྷིནྣདེཤཱིཡལོཀཱནཱམ྄ མདྷྱཱད྄ ཨེཀཾ ལོཀསཾགྷཾ གྲཧཱིཏུཾ མཏིཾ ཀྲྀཏྭཱ ཡེན པྲཀཱརེཎ པྲཐམཾ ཏཱན྄ པྲཏི ཀྲྀཔཱཝལེཀནཾ ཀྲྀཏཝཱན྄ ཏཾ ཤིམོན྄ ཝརྞིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","བྷཝིཥྱདྭཱདིབྷིརུཀྟཱནི ཡཱནི ཝཱཀྱཱནི ཏཻཿ སཱརྡྡྷམ྄ ཨེཏསྱཻཀྱཾ བྷཝཏི ཡཐཱ ལིཁིཏམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","སཪྻྭེཥཱཾ ཀརྨྨཎཱཾ ཡསྟུ སཱདྷཀཿ པརམེཤྭརཿ། ས ཨེཝེདཾ ཝདེདྭཱཀྱཾ ཤེཥཱཿ སཀལམཱནཝཱཿ། བྷིནྣདེཤཱིཡལོཀཱཤྩ ཡཱཝནྟོ མམ ནཱམཏཿ། བྷཝནྟི ཧི སུཝིཁྱཱཏཱསྟེ ཡཐཱ པརམེཤིཏུཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ཏཏྭཾ སམྱཀ྄ སམཱིཧནྟེ ཏནྣིམིཏྟམཧཾ ཀིལ། པརཱཝྲྀཏྱ སམཱགཏྱ དཱཡཱུདཿ པཏིཏཾ པུནཿ། དཱུཥྱམུཏྠཱཔཡིཥྱཱམི ཏདཱིཡཾ སཪྻྭཝསྟུ ཙ། པཏིཏཾ པུནརུཐཱཔྱ སཛྫཡིཥྱཱམི སཪྻྭཐཱ༎ ");
INSERT INTO santib_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ཨཱ པྲཐམཱད྄ ཨཱིཤྭརཿ སྭཱིཡཱནི སཪྻྭཀརྨྨཱཎི ཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ཨཏཨེཝ མམ ནིཝེདནམིདཾ བྷིནྣདེཤཱིཡལོཀཱནཱཾ མདྷྱེ ཡེ ཛནཱ ཨཱིཤྭརཾ པྲཏི པརཱཝརྟྟནྟ ཏེཥཱམུཔརི ཨནྱཾ ཀམཔི བྷཱརཾ ན ནྱསྱ ");
INSERT INTO santib_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","དེཝཏཱཔྲསཱདཱཤུཙིབྷཀྵྱཾ ཝྱབྷིཙཱརཀརྨྨ ཀཎྛསམྤཱིཌནམཱརིཏཔྲཱཎིབྷཀྵྱཾ རཀྟབྷཀྵྱཉྩ ཨེཏཱནི པརིཏྱཀྟུཾ ལིཁཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ཡཏཿ པཱུཪྻྭཀཱལཏོ མཱུསཱཝྱཝསྠཱཔྲཙཱརིཎོ ལོཀཱ ནགརེ ནགརེ སནྟི པྲཏིཝིཤྲཱམཝཱརཉྩ བྷཛནབྷཝནེ ཏསྱཱཿ པཱཋོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ཏཏཿ པརཾ པྲེརིཏགཎོ ལོཀཔྲཱཙཱིནགཎཿ སཪྻྭཱ མཎྜལཱི ཙ སྭེཥཱཾ མདྷྱེ བརྴབྦཱ ནཱམྣཱ ཝིཁྱཱཏོ མནོནཱིཏཽ ཀྲྀཏྭཱ པཽལབརྞབྦཱབྷྱཱཾ སཱརྡྡྷམ྄ ཨཱནྟིཡཁིཡཱནགརཾ པྲཏི པྲེཥཎམ྄ ཨུཙིཏཾ བུདྡྷྭཱ ཏཱབྷྱཱཾ པཏྲཾ པྲཻཥཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ཏསྨིན྄ པཏྲེ ལིཁིཏམིཾད, ཨཱནྟིཡཁིཡཱ-སུརིཡཱ-ཀིལིཀིཡཱདེཤསྠབྷིནྣདེཤཱིཡབྷྲཱཏྲྀགཎཱཡ པྲེརིཏགཎསྱ ལོཀཔྲཱཙཱིནགཎསྱ བྷྲཱཏྲྀགཎསྱ ཙ ནམསྐཱརཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ཝིཤེཥཏོ྅སྨཱཀམ྄ ཨཱཛྙཱམ྄ ཨཔྲཱཔྱཱཔི ཀིཡནྟོ ཛནཱ ཨསྨཱཀཾ མདྷྱཱད྄ གཏྭཱ ཏྭཀྪེདོ མཱུསཱཝྱཝསྠཱ ཙ པཱལཡིཏཝྱཱཝིཏི ཡུཥྨཱན྄ ཤིཀྵཡིཏྭཱ ཡུཥྨཱཀཾ མནསཱམསྠཻཪྻྱཾ ཀྲྀཏྭཱ ཡུཥྨཱན྄ སསནྡེཧཱན྄ ཨཀུཪྻྭན྄ ཨེཏཱཾ ཀཐཱཾ ཝཡམ྄ ཨཤྲྀནྨ། ");
INSERT INTO santib_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ཏཏྐཱརཎཱད྄ ཝཡམ྄ ཨེཀམནྟྲཎཱཿ སནྟཿ སབྷཱཡཱཾ སྠིཏྭཱ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ ནཱམནིམིཏྟཾ མྲྀཏྱུམུཁགཏཱབྷྱཱམསྨཱཀཾ ");
INSERT INTO santib_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","པྲིཡབརྞབྦཱཔཽལཱབྷྱཱཾ སཱརྡྡྷཾ མནོནཱིཏལོཀཱནཱཾ ཀེཥཱཉྩིད྄ ཡུཥྨཱཀཾ སནྣིདྷཽ པྲེཥཎམ྄ ཨུཙིཏཾ བུདྡྷཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ཨཏོ ཡིཧཱུདཱསཱིལཽ ཡུཥྨཱན྄ པྲཏི པྲེཥིཏཝནྟཿ, ཨེཏཡོ རྨུཁཱབྷྱཱཾ སཪྻྭཱཾ ཀཐཱཾ ཛྙཱསྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","དེཝཏཱཔྲསཱདབྷཀྵྱཾ རཀྟབྷཀྵྱཾ གལཔཱིཌནམཱརིཏཔྲཱཎིབྷཀྵྱཾ ཝྱབྷིཙཱརཀརྨྨ ཙེམཱནི སཪྻྭཱཎི ཡུཥྨཱབྷིསྟྱཱཛྱཱནི; ཨེཏཏྤྲཡོཛནཱིཡཱཛྙཱཝྱཏིརེཀེན ཡུཥྨཱཀམ྄ ཨུཔརི བྷཱརམནྱཾ ན ནྱསིཏུཾ པཝིཏྲསྱཱཏྨནོ྅སྨཱཀཉྩ ཨུཙིཏཛྙཱནམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ཨཏཨེཝ ཏེབྷྱཿ སཪྻྭེབྷྱཿ སྭེཥུ རཀྵིཏེཥུ ཡཱུཡཾ བྷདྲཾ ཀརྨྨ ཀརིཥྱཐ། ཡུཥྨཱཀཾ མངྒལཾ བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ཏེे ཝིསྲྀཥྚཱཿ སནྟ ཨཱནྟིཡཁིཡཱནགར ཨུཔསྠཱཡ ལོཀནིཝཧཾ སཾགྲྀཧྱ པཏྲམ྄ ཨདདན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ཏཏསྟེ ཏཏྤཏྲཾ པཋིཏྭཱ སཱནྟྭནཱཾ པྲཱཔྱ སཱནནྡཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ཡིཧཱུདཱསཱིལཽ ཙ སྭཡཾ པྲཙཱརཀཽ བྷཱུཏྭཱ བྷྲཱཏྲྀགཎཾ ནཱནོཔདིཤྱ ཏཱན྄ སུསྠིརཱན྄ ཨཀུརུཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ཨིཏྠཾ ཏཽ ཏཏྲ ཏཻཿ སཱཀཾ ཀཏིཔཡདིནཱནི ཡཱཔཡིཏྭཱ པཤྩཱཏ྄ པྲེརིཏཱནཱཾ སམཱིཔེ པྲཏྱཱགམནཱརྠཾ ཏེཥཱཾ སནྣིདྷེཿ ཀལྱཱཎེན ཝིསྲྀཥྚཱཝབྷཝཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ཀིནྟུ སཱིལསྟཏྲ སྠཱཏུཾ ཝཱཉྪིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ཨཔརཾ པཽལབརྞབྦཽ བཧཝཿ ཤིཥྱཱཤྩ ལོཀཱན྄ ཨུཔདིཤྱ པྲབྷོཿ སུསཾཝཱདཾ པྲཙཱརཡནྟ ཨཱནྟིཡཁིཡཱཡཱཾ ཀཱལཾ ཡཱཔིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ཀཏིཔཡདིནེཥུ གཏེཥུ པཽལོ བརྞབྦཱམ྄ ཨཝདཏ྄ ཨཱགཙྪཱཝཱཾ ཡེཥུ ནགརེཥྭཱིཤྭརསྱ སུསཾཝཱདཾ པྲཙཱརིཏཝནྟཽ ཏཱནི སཪྻྭནགརཱཎི པུནརྒཏྭཱ བྷྲཱཏརཿ ཀཱིདྲྀཤཱཿ སནྟཱིཏི དྲཥྚུཾ ཏཱན྄ སཱཀྵཱཏ྄ ཀུཪྻྭཿ། ");
INSERT INTO santib_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ཏེན མཱརྐནཱམྣཱ ཝིཁྱཱཏཾ ཡོཧནཾ སངྒིནཾ ཀརྟྟུཾ བརྞབྦཱ མཏིམཀརོཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ཀིནྟུ ས པཱུཪྻྭཾ ཏཱབྷྱཱཾ སཧ ཀཱཪྻྱཱརྠཾ ན གཏྭཱ པཱམྥཱུལིཡཱདེཤེ ཏཽ ཏྱཀྟཝཱན྄ ཏཏྐཱརཎཱཏ྄ པཽལསྟཾ སངྒིནཾ ཀརྟྟུམ྄ ཨནུཙིཏཾ ཛྙཱཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ཨིཏྠཾ ཏཡོརཏིཤཡཝིརོདྷསྱོཔསྠིཏཏྭཱཏ྄ ཏཽ པརསྤརཾ པྲྀཐགབྷཝཏཱཾ ཏཏོ བརྞབྦཱ མཱརྐཾ གྲྀཧཱིཏྭཱ པོཏེན ཀུཔྲོཔདྭཱིཔཾ གཏཝཱན྄; ");
INSERT INTO santib_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ཀིནྟུ པཽལཿ སཱིལཾ མནོནཱིཏཾ ཀྲྀཏྭཱ བྷྲཱཏྲྀབྷིརཱིཤྭརཱནུགྲཧེ སམརྤིཏཿ སན྄ པྲསྠཱཡ ");
INSERT INTO santib_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","སུརིཡཱཀིལིཀིཡཱདེཤཱབྷྱཱཾ མཎྜལཱིཿ སྠིརཱིཀུཪྻྭན྄ ཨགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","པཽལོ དརྦྦཱིལུསྟྲཱནགརཡོརུཔསྠིཏོབྷཝཏ྄ ཏཏྲ ཏཱིམཐིཡནཱམཱ ཤིཥྱ ཨེཀ ཨཱསཱིཏ྄; ས ཝིཤྭཱསིནྱཱ ཡིཧཱུདཱིཡཱཡཱ ཡོཥིཏོ གརྦྦྷཛཱཏཿ ཀིནྟུ ཏསྱ པིཏཱནྱདེཤཱིཡལོཀཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ས ཛནོ ལུསྟྲཱ-ཨིཀནིཡནགརསྠཱནཱཾ བྷྲཱཏྲྀཎཱཾ སམཱིཔེཔི སུཁྱཱཏིམཱན྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","པཽལསྟཾ སྭསངྒིནཾ ཀརྟྟུཾ མཏིཾ ཀྲྀཏྭཱ ཏཾ གྲྀཧཱིཏྭཱ ཏདྡེཤནིཝཱསིནཱཾ ཡིཧཱུདཱིཡཱནཱམ྄ ཨནུརོདྷཱཏ྄ ཏསྱ ཏྭཀྪེདཾ ཀྲྀཏཝཱན྄ ཡཏསྟསྱ པིཏཱ བྷིནྣདེཤཱིཡལོཀ ཨིཏི སཪྻྭཻརཛྙཱཡཏ། ");
INSERT INTO santib_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ཏཏཿ པརཾ ཏེ ནགརེ ནགརེ བྷྲམིཏྭཱ ཡིརཱུཤཱལམསྠཻཿ པྲེརིཏཻ རློཀཔྲཱཙཱིནཻཤྩ ནིརཱུཔིཏཾ ཡད྄ ཝྱཝསྠཱཔཏྲཾ ཏདནུསཱརེཎཱཙརིཏུཾ ལོཀེབྷྱསྟད྄ དཏྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ཏེནཻཝ སཪྻྭེ དྷརྨྨསམཱཛཱཿ ཁྲཱིཥྚདྷརྨྨེ སུསྠིརཱཿ སནྟཿ པྲཏིདིནཾ ཝརྡྡྷིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ཏེཥུ ཕྲུགིཡཱགཱལཱཏིཡཱདེཤམདྷྱེན གཏེཥུ སཏྶུ པཝིཏྲ ཨཱཏྨཱ ཏཱན྄ ཨཱཤིཡཱདེཤེ ཀཐཱཾ པྲཀཱཤཡིཏུཾ པྲཏིཥིདྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ཏཐཱ མུསིཡཱདེཤ ཨུཔསྠཱཡ བིཐུནིཡཱཾ གནྟུཾ ཏཻརུདྱོགེ ཀྲྀཏེ ཨཱཏྨཱ ཏཱན྄ ནཱནྭམནྱཏ། ");
INSERT INTO santib_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ཏསྨཱཏ྄ ཏེ མུསིཡཱདེཤཾ པརིཏྱཛྱ ཏྲོཡཱནགརཾ གཏྭཱ སམུཔསྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","རཱཏྲཽ པཽལཿ སྭཔྣེ དྲྀཥྚཝཱན྄ ཨེཀོ མཱཀིདནིཡལོཀསྟིཥྛན྄ ཝིནཡཾ ཀྲྀཏྭཱ ཏསྨཻ ཀཐཡཏི, མཱཀིདནིཡཱདེཤམ྄ ཨཱགཏྱཱསྨཱན྄ ཨུཔཀུཪྻྭིཏི། ");
INSERT INTO santib_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ཏསྱེཏྠཾ སྭཔྣདརྴནཱཏ྄ པྲབྷུསྟདྡེཤཱིཡལོཀཱན྄ པྲཏི སུསཾཝཱདཾ པྲཙཱརཡིཏུམ྄ ཨསྨཱན྄ ཨཱཧཱུཡཏཱིཏི ནིཤྩིཏཾ བུདྡྷྭཱ ཝཡཾ ཏཱུརྞཾ མཱཀིདནིཡཱདེཤཾ གནྟུམ྄ ཨུདྱོགམ྄ ཨཀུརྨྨ། ");
INSERT INTO santib_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ཏཏཿ པརཾ ཝཡཾ ཏྲོཡཱནགརཱད྄ པྲསྠཱཡ ཨྲྀཛུམཱརྒེཎ སཱམཐྲཱཀིཡོཔདྭཱིཔེན གཏྭཱ པརེ྅ཧནི ནིཡཱཔལིནགར ཨུཔསྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ཏསྨཱད྄ གཏྭཱ མཱཀིདནིཡཱནྟཪྻྭརྟྟི རོམཱིཡཝསཏིསྠཱནཾ ཡཏ྄ ཕིལིཔཱིནཱམཔྲདྷཱནནགརཾ ཏཏྲོཔསྠཱཡ ཀཏིཔཡདིནཱནི ཏཏྲ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ཝིཤྲཱམཝཱརེ ནགརཱད྄ བཧི རྒཏྭཱ ནདཱིཏཊེ ཡཏྲ པྲཱརྠནཱཙཱར ཨཱསཱིཏ྄ ཏཏྲོཔཝིཤྱ སམཱགཏཱ ནཱརཱིཿ པྲཏི ཀཐཱཾ པྲཱཙཱརཡཱམ། ");
INSERT INTO santib_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ཏཏཿ ཐུཡཱཏཱིརཱནགརཱིཡཱ དྷཱུཥརཱམྦརཝིཀྲཱཡིཎཱི ལུདིཡཱནཱམིཀཱ ཡཱ ཨཱིཤྭརསེཝིཀཱ ཡོཥིཏ྄ ཤྲོཏྲཱིཎཱཾ མདྷྱ ཨཱསཱིཏ྄ ཏཡཱ པཽལོཀྟཝཱཀྱཱནི ཡད྄ གྲྀཧྱནྟེ ཏདརྠཾ པྲབྷུསྟསྱཱ མནོདྭཱརཾ མུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ཨཏཿ སཱ ཡོཥིཏ྄ སཔརིཝཱརཱ མཛྫིཏཱ སཏཱི ཝིནཡཾ ཀྲྀཏྭཱ ཀཐིཏཝཏཱི, ཡུཥྨཱཀཾ ཝིཙཱརཱད྄ ཡདི པྲབྷཽ ཝིཤྭཱསིནཱི ཛཱཏཱཧཾ ཏརྷི མམ གྲྀཧམ྄ ཨཱགཏྱ ཏིཥྛཏ། ཨིཏྠཾ སཱ ཡཏྣེནཱསྨཱན྄ ཨསྠཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ཡསྱཱ གཎནཡཱ ཏདདྷིཔཏཱིནཱཾ བཧུདྷནོཔཱརྫནཾ ཛཱཏཾ ཏཱདྲྀཤཱི གཎཀབྷཱུཏགྲསྟཱ ཀཱཙན དཱསཱི པྲཱརྠནཱསྠཱནགམནཀཱལ ཨཱགཏྱཱསྨཱན྄ སཱཀྵཱཏ྄ ཀྲྀཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","སཱསྨཱཀཾ པཽལསྱ ཙ པཤྩཱད྄ ཨེཏྱ པྲོཙྩཻཿ ཀཐཱམིམཱཾ ཀཐིཏཝཏཱི, མནུཥྱཱ ཨེཏེ སཪྻྭོཔརིསྠསྱེཤྭརསྱ སེཝཀཱཿ སནྟོ྅སྨཱན྄ པྲཏི པརིཏྲཱཎསྱ མཱརྒཾ པྲཀཱཤཡནྟི། ");
INSERT INTO santib_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","སཱ ཀནྱཱ བཧུདིནཱནི ཏཱདྲྀཤམ྄ ཨཀརོཏ྄ ཏསྨཱཏ྄ པཽལོ དུཿཁིཏཿ སན྄ མུཁཾ པརཱཝརྟྱ ཏཾ བྷཱུཏམཝདད྄, ཨཧཾ ཡཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ ཏྭཱམཱཛྙཱཔཡཱམི ཏྭམསྱཱ བཧིརྒཙྪ; ཏེནཻཝ ཏཏྐྵཎཱཏ྄ ས བྷཱུཏསྟསྱཱ བཧིརྒཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ཏཏཿ སྭེཥཱཾ ལཱབྷསྱ པྲཏྱཱཤཱ ཝིཕལཱ ཛཱཏེཏི ཝིལོཀྱ ཏསྱཱཿ པྲབྷཝཿ པཽལཾ སཱིལཉྩ དྷྲྀཏྭཱཀྲྀཥྱ ཝིཙཱརསྠཱནེ྅དྷིཔཏཱིནཱཾ སམཱིཔམ྄ ཨཱནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ཏཏཿ ཤཱསཀཱནཱཾ ནིཀཊཾ ནཱིཏྭཱ རོམིལོཀཱ ཝཡམ྄ ཨསྨཱཀཾ ཡད྄ ཝྱཝཧརཎཾ གྲཧཱིཏུམ྄ ཨཱཙརིཏུཉྩ ནིཥིདྡྷཾ, ");
INSERT INTO santib_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ཨིམེ ཡིཧཱུདཱིཡལོཀཱཿ སནྟོཔི ཏདེཝ ཤིཀྵཡིཏྭཱ ནགརེ྅སྨཱཀམ྄ ཨཏཱིཝ ཀལཧཾ ཀུཪྻྭནྟི, ");
INSERT INTO santib_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ཨིཏི ཀཐིཏེ སཏི ལོཀནིཝཧསྟཡོཿ པྲཱཏིཀཱུལྱེནོདཏིཥྛཏ྄ ཏཐཱ ཤཱསཀཱསྟཡོ ཪྻསྟྲཱཎི ཚིཏྭཱ ཝེཏྲཱགྷཱཏཾ ཀརྟྟུམ྄ ཨཱཛྙཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ཨཔརཾ ཏེ ཏཽ བཧུ པྲཧཱཪྻྱ ཏྭམེཏཽ ཀཱརཱཾ ནཱིཏྭཱ སཱཝདྷཱནཾ རཀྵཡེཏི ཀཱརཱརཀྵཀམ྄ ཨཱདིཤན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ཨིཏྠམ྄ ཨཱཛྙཱཾ པྲཱཔྱ ས ཏཱཝབྷྱནྟརསྠཀཱརཱཾ ནཱིཏྭཱ པཱདེཥུ པཱདཔཱཤཱིབྷི རྦདྡྷྭཱ སྠཱཔིཏཱཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ཨཐ ནིཤཱིཐསམཡེ པཽལསཱིལཱཝཱིཤྭརམུདྡིཤྱ པྲཱཐནཱཾ གཱནཉྩ ཀྲྀཏཝནྟཽ, ཀཱརཱསྠིཏཱ ལོཀཱཤྩ ཏདཤྲྀཎྭན྄ ");
INSERT INTO santib_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ཏདཱཀསྨཱཏ྄ མཧཱན྄ བྷཱུམིཀམྤོ྅བྷཝཏ྄ ཏེན བྷིཏྟིམཱུལེན སཧ ཀཱརཱ ཀམྤིཏཱབྷཱུཏ྄ ཏཏྐྵཎཱཏ྄ སཪྻྭཱཎི དྭཱརཱཎི མུཀྟཱནི ཛཱཏཱནི སཪྻྭེཥཱཾ བནྡྷནཱནི ཙ མུཀྟཱནི། ");
INSERT INTO santib_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ཨཏཨེཝ ཀཱརཱརཀྵཀོ ནིདྲཱཏོ ཛཱགརིཏྭཱ ཀཱརཱཡཱ དྭཱརཱཎི མུཀྟཱནི དྲྀཥྚྭཱ བནྡིལོཀཱཿ པལཱཡིཏཱ ཨིཏྱནུམཱཡ ཀོཥཱཏ྄ ཁངྒཾ བཧིཿ ཀྲྀཏྭཱཏྨགྷཱཏཾ ཀརྟྟུམ྄ ཨུདྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ཀིནྟུ པཽལཿ པྲོཙྩཻསྟམཱཧཱུཡ ཀཐིཏཝཱན྄ པཤྱ ཝཡཾ སཪྻྭེ྅ཏྲཱསྨཧེ, ཏྭཾ ནིཛཔྲཱཎཧིཾསཱཾ མཱཀཱརྵཱིཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ཏདཱ པྲདཱིཔམ྄ ཨཱནེཏུམ྄ ཨུཀྟྭཱ ས ཀམྤམཱནཿ སན྄ ཨུལླམྤྱཱབྷྱནྟརམ྄ ཨཱགཏྱ པཽལསཱིལཡོཿ པཱདེཥུ པཏིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","པཤྩཱཏ྄ ས ཏཽ བཧིརཱནཱིཡ པྲྀཥྚཝཱན྄ ཧེ མཧེཙྪཽ པརིཏྲཱཎཾ པྲཱཔྟུཾ མཡཱ ཀིཾ ཀརྟྟཝྱཾ? ");
INSERT INTO santib_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","པཤྩཱཏ྄ ཏཽ སྭགྲྀཧམཱནཱིཡ ཏཡོཿ སམྨུཁེ ཁཱདྱདྲཝྱཱཎི སྠཱཔིཏཝཱན྄ ཏཐཱ ས སྭཡཾ ཏདཱིཡཱཿ སཪྻྭེ པརིཝཱརཱཤྩེཤྭརེ ཝིཤྭསནྟཿ སཱནནྡིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ཏསྨཻ ཏསྱ གྲྀཧསྠིཏསཪྻྭལོཀེབྷྱཤྩ པྲབྷོཿ ཀཐཱཾ ཀཐིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ཏཐཱ རཱཏྲེསྟསྨིནྣེཝ དཎྜེ ས ཏཽ གྲྀཧཱིཏྭཱ ཏཡོཿ པྲཧཱརཱཎཱཾ ཀྵཏཱནི པྲཀྵཱལིཏཝཱན྄ ཏཏཿ ས སྭཡཾ ཏསྱ སཪྻྭེ པརིཛནཱཤྩ མཛྫིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","པཤྩཱཏ྄ ཏཽ སྭགྲྀཧམཱནཱིཡ ཏཡོཿ སམྨུཁེ ཁཱདྱདྲཝྱཱཎི སྠཱཔིཏཝཱན྄ ཏཐཱ ས སྭཡཾ ཏདཱིཡཱཿ སཪྻྭེ པརིཝཱརཱཤྩེཤྭརེ ཝིཤྭསནྟཿ སཱནནྡིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","དིན ཨུཔསྠིཏེ ཏཽ ལོཀཽ མོཙཡེཏི ཀཐཱཾ ཀཐཡིཏུཾ ཤཱསཀཱཿ པདཱཏིགཎཾ པྲེཥིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ཏཏཿ ཀཱརཱརཀྵཀཿ པཽལཱཡ ཏཱཾ ཝཱརྟྟཱཾ ཀཐིཏཝཱན྄ ཡུཝཱཾ ཏྱཱཛཡིཏུཾ ཤཱསཀཱ ལོཀཱན པྲེཥིཏཝནྟ ཨིདཱནཱིཾ ཡུཝཱཾ བཧི རྦྷཱུཏྭཱ ཀུཤལེན པྲཏིཥྛེཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ཀིནྟུ པཽལསྟཱན྄ ཨཝདཏ྄ རོམིལོཀཡོརཱཝཡོཿ ཀམཔི དོཥམ྄ ན ནིཤྩིཏྱ སཪྻྭེཥཱཾ སམཀྵམ྄ ཨཱཝཱཾ ཀཤཡཱ ཏཱཌཡིཏྭཱ ཀཱརཱཡཱཾ བདྡྷཝནྟ ཨིདཱནཱིཾ ཀིམཱཝཱཾ གུཔྟཾ ཝིསྟྲཀྵྱནྟི? ཏནྣ བྷཝིཥྱཏི, སྭཡམཱགཏྱཱཝཱཾ བཧིཿ ཀྲྀཏྭཱ ནཡནྟུ། ");
INSERT INTO santib_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ཏདཱ པདཱཏིབྷིཿ ཤཱསཀེབྷྱ ཨེཏདྭཱརྟྟཱཡཱཾ ཀཐིཏཱཡཱཾ ཏཽ རོམིལོཀཱཝིཏི ཀཐཱཾ ཤྲུཏྭཱ ཏེ བྷཱིཏཱཿ ");
INSERT INTO santib_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","སནྟསྟཡོཿ སནྣིདྷིམཱགཏྱ ཝིནཡམ྄ ཨཀུཪྻྭན྄ ཨཔརཾ བཧིཿ ཀྲྀཏྭཱ ནགརཱཏ྄ པྲསྠཱཏུཾ པྲཱརྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ཏཏསྟཽ ཀཱརཱཡཱ ནིརྒཏྱ ལུདིཡཱཡཱ གྲྀཧཾ གཏཝནྟཽ ཏཏྲ བྷྲཱཏྲྀགཎཾ སཱཀྵཱཏྐྲྀཏྱ ཏཱན྄ སཱནྟྭཡིཏྭཱ ཏསྨཱཏ྄ སྠཱནཱཏ྄ པྲསྠིཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","པཽལསཱིལཽ ཨཱམྥིཔལྱཱཔལློནིཡཱནགརཱབྷྱཱཾ གཏྭཱ ཡཏྲ ཡིཧཱུདཱིཡཱནཱཾ བྷཛནབྷཝནམེཀམ྄ ཨཱསྟེ ཏཏྲ ཐིཥལནཱིཀཱིནགར ཨུཔསྠིཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ཏདཱ པཽལཿ སྭཱཙཱརཱནུསཱརེཎ ཏེཥཱཾ སམཱིཔཾ གཏྭཱ ཝིཤྲཱམཝཱརཏྲཡེ ཏཻཿ སཱརྡྡྷཾ དྷརྨྨཔུསྟཀཱིཡཀཐཱཡཱ ཝིཙཱརཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ཕལཏཿ ཁྲཱིཥྚེན དུཿཁབྷོགཿ ཀརྟྟཝྱཿ ཤྨཤཱནདུཏྠཱནཉྩ ཀརྟྟཝྱཾ ཡུཥྨཱཀཾ སནྣིདྷཽ ཡསྱ ཡཱིཤོཿ པྲསྟཱཝཾ ཀརོམི ས ཨཱིཤྭརེཎཱབྷིཥིཀྟཿ ས ཨེཏཱཿ ཀཐཱཿ པྲཀཱཤྱ པྲམཱཎཾ དཏྭཱ སྠིརཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ཏསྨཱཏ྄ ཏེཥཱཾ ཀཏིཔཡཛནཱ ཨནྱདེཤཱིཡཱ བཧཝོ བྷཀྟལོཀཱ བཧྱཿ པྲདྷཱནནཱཪྻྱཤྩ ཝིཤྭསྱ པཽལསཱིལཡོཿ པཤྩཱདྒཱམིནོ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ཀིནྟུ ཝིཤྭཱསཧཱིནཱ ཡིཧཱུདཱིཡལོཀཱ ཨཱིརྵྱཡཱ པརིཔཱུརྞཱཿ སནྟོ ཧཊཊྶྱ ཀཏིནཡལམྤཊལོཀཱན྄ སངྒིནཿ ཀྲྀཏྭཱ ཛནཏཡཱ ནགརམདྷྱེ མཧཱཀལཧཾ ཀྲྀཏྭཱ ཡཱསོནོ གྲྀཧམ྄ ཨཱཀྲམྱ པྲེརིཏཱན྄ དྷྲྀཏྭཱ ལོཀནིཝཧསྱ སམཱིཔམ྄ ཨཱནེཏུཾ ཙེཥྚིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ཏེཥཱམུདྡེཤམ྄ ཨཔྲཱཔྱ ཙ ཡཱསོནཾ ཀཏིཔཡཱན྄ བྷྲཱཏྲྀཾཤྩ དྷྲྀཏྭཱ ནགརཱདྷིཔཏཱིནཱཾ ནིཀཊམཱནཱིཡ པྲོཙྩཻཿ ཀཐིཏཝནྟོ ཡེ མནུཥྱཱ ཛགདུདྭཱཊིཏཝནྟསྟེ ྅ཏྲཱཔྱུཔསྠིཏཱཿ སནྟི, ");
INSERT INTO santib_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ཨེཥ ཡཱསོན྄ ཨཱཏིཐྱཾ ཀྲྀཏྭཱ ཏཱན྄ གྲྀཧཱིཏཝཱན྄། ཡཱིཤུནཱམཀ ཨེཀོ རཱཛསྟཱིཏི ཀཐཡནྟསྟེ ཀཻསརསྱཱཛྙཱཝིརུདྡྷཾ ཀརྨྨ ཀུཪྻྭཏི། ");
INSERT INTO santib_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ཏེཥཱཾ ཀཐཱམིམཱཾ ཤྲུཏྭཱ ལོཀནིཝཧོ ནགརཱདྷིཔཏཡཤྩ སམུདྭིགྣཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ཏདཱ ཡཱསོནསྟདནྱེཥཱཉྩ དྷནདཎྜཾ གྲྀཧཱིཏྭཱ ཏཱན྄ པརིཏྱཀྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ཏཏཿ པརཾ བྷྲཱཏྲྀགཎོ རཛནྱཱཾ པཽལསཱིལཽ ཤཱིགྷྲཾ བིརཡཱནགརཾ པྲེཥིཏཝཱན྄ ཏཽ ཏཏྲོཔསྠཱཡ ཡིཧཱུདཱིཡཱནཱཾ བྷཛནབྷཝནཾ གཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ཏཏྲསྠཱ ལོཀཱཿ ཐིཥལནཱིཀཱིསྠལོཀེབྷྱོ མཧཱཏྨཱན ཨཱསན྄ ཡཏ ཨིཏྠཾ བྷཝཏི ན ཝེཏི ཛྙཱཏུཾ དིནེ དིནེ དྷརྨྨགྲནྠསྱཱལོཙནཱཾ ཀྲྀཏྭཱ སྭཻརཾ ཀཐཱམ྄ ཨགྲྀཧླན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ཏསྨཱད྄ ཨནེཀེ ཡིཧཱུདཱིཡཱ ཨནྱདེཤཱིཡཱནཱཾ མཱནྱཱ སྟྲིཡཿ པུརུཥཱཤྩཱནེཀེ ཝྱཤྭསན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ཀིནྟུ བིརཡཱནགརེ པཽལེནེཤྭརཱིཡཱ ཀཐཱ པྲཙཱཪྻྱཏ ཨིཏི ཐིཥལནཱིཀཱིསྠཱ ཡིཧཱུདཱིཡཱ ཛྙཱཏྭཱ ཏཏྶྠཱནམཔྱཱགཏྱ ལོཀཱནཱཾ ཀུཔྲཝྲྀཏྟིམ྄ ཨཛནཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ཨཏཨེཝ ཏསྨཱཏ྄ སྠཱནཱཏ྄ སམུདྲེཎ ཡཱནྟཱིཏི དརྴཡིཏྭཱ བྷྲཱཏརཿ ཀྵིཔྲཾ པཽལཾ པྲཱཧིཎྭན྄ ཀིནྟུ སཱིལཏཱིམཐིཡཽ ཏཏྲ སྠིཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ཏཏཿ པརཾ པཽལསྱ མཱརྒདརྴཀཱསྟམ྄ ཨཱཐཱིནཱིནགར ཨུཔསྠཱཔཡན྄ པཤྩཱད྄ ཡུཝཱཾ ཏཱུརྞམ྄ ཨེཏཏ྄ སྠཱནཾ ཨཱགམིཥྱཐཿ སཱིལཏཱིམཐིཡཽ པྲཏཱིམཱམ྄ ཨཱཛྙཱཾ པྲཱཔྱ ཏེ པྲཏྱཱགཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","པཽལ ཨཱཐཱིནཱིནགརེ ཏཱཝཔེཀྵྱ ཏིཥྛན྄ ཏནྣགརཾ པྲཏིམཱབྷིཿ པརིཔཱུརྞཾ དྲྀཥྚྭཱ སནྟཔྟཧྲྀདཡོ ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ཏཏཿ ས བྷཛནབྷཝནེ ཡཱན྄ ཡིཧཱུདཱིཡཱན྄ བྷཀྟལོཀཱཾཤྩ ཧཊྚེ ཙ ཡཱན྄ ཨཔཤྱཏ྄ ཏཻཿ སཧ པྲཏིདིནཾ ཝིཙཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ཀིནྟྭིཔིཀཱུརཱིཡམཏགྲཧིཎཿ སྟོཡིཀཱིཡམཏགྲཱཧིཎཤྩ ཀིཡནྟོ ཛནཱསྟེན སཱརྡྡྷཾ ཝྱཝདནྟ། ཏཏྲ ཀེཙིད྄ ཨཀཐཡན྄ ཨེཥ ཝཱཙཱལཿ ཀིཾ ཝཀྟུམ྄ ཨིཙྪཏི? ཨཔརེ ཀེཙིད྄ ཨེཥ ཛནཿ ཀེཥཱཉྩིད྄ ཝིདེཤཱིཡདེཝཱནཱཾ པྲཙཱརཀ ཨིཏྱནུམཱིཡཏེ ཡཏཿ ས ཡཱིཤུམ྄ ཨུཏྠིཏིཉྩ པྲཙཱརཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ཏེ ཏམ྄ ཨརེཡཔཱགནཱམ ཝིཙཱརསྠཱནམ྄ ཨཱནཱིཡ པྲཱཝོཙན྄ ཨིདཾ ཡནྣཝཱིནཾ མཏཾ ཏྭཾ པྲཱཙཱིཀཤ ཨིདཾ ཀཱིདྲྀཤཾ ཨེཏད྄ ཨསྨཱན྄ ཤྲཱཝཡ; ");
INSERT INTO santib_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ཡཱམིམཱམ྄ ཨསམྦྷཝཀཐཱམ྄ ཨསྨཱཀཾ ཀརྞགོཙརཱིཀྲྀཏཝཱན྄ ཨསྱཱ བྷཱཝཱརྠཿ ཀ ཨིཏི ཝཡཾ ཛྙཱཏུམ྄ ཨིཙྪཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ཏདཱཐཱིནཱིནིཝཱསིནསྟནྣགརཔྲཝཱསིནཤྩ ཀེཝལཾ ཀསྱཱཤྩན ནཝཱིནཀཐཱཡཱཿ ཤྲཝཎེན པྲཙཱརཎེན ཙ ཀཱལམ྄ ཨཡཱཔཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","པཽལོ྅རེཡཔཱགསྱ མདྷྱེ ཏིཥྛན྄ ཨེཏཱཾ ཀཐཱཾ པྲཙཱརིཏཝཱན྄, ཧེ ཨཱཐཱིནཱིཡལོཀཱ ཡཱུཡཾ སཪྻྭཐཱ དེཝཔཱུཛཱཡཱམ྄ ཨཱསཀྟཱ ཨིཏྱཧ པྲཏྱཀྵཾ པཤྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ཡཏཿ པཪྻྱཊནཀཱལེ ཡུཥྨཱཀཾ པཱུཛནཱིཡཱནི པཤྱན྄ ‘ཨཝིཛྙཱཏེཤྭརཱཡ’ ཨེཏལླིཔིཡུཀྟཱཾ ཡཛྙཝེདཱིམེཀཱཾ དྲྀཥྚཝཱན྄; ཨཏོ ན ཝིདིཏྭཱ ཡཾ པཱུཛཡདྷྭེ ཏསྱཻཝ ཏཏྭཾ ཡུཥྨཱན྄ པྲཏི པྲཙཱརཡཱམི། ");
INSERT INTO santib_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ཛགཏོ ཛགཏྶྠཱནཱཾ སཪྻྭཝསྟཱུནཱཉྩ སྲཥྚཱ ཡ ཨཱིཤྭརཿ ས སྭརྒཔྲྀཐིཝྱོརེཀཱདྷིཔཏིཿ སན྄ ཀརནིརྨྨིཏམནྡིརེཥུ ན ནིཝསཏི; ");
INSERT INTO santib_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ས ཨེཝ སཪྻྭེབྷྱོ ཛཱིཝནཾ པྲཱཎཱན྄ སཪྻྭསཱམགྲཱིཤྩ པྲདདཱཏི; ཨཏཨེཝ ས ཀསྱཱཤྩིཏ྄ སཱམགྱྲཱ ཨབྷཱཝཧེཏོ རྨནུཥྱཱཎཱཾ ཧསྟཻཿ སེཝིཏོ བྷཝཏཱིཏི ན། ");
INSERT INTO santib_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ས བྷཱུམཎྜལེ ནིཝཱསཱརྠམ྄ ཨེཀསྨཱཏ྄ ཤོཎིཏཱཏ྄ སཪྻྭཱན྄ མནུཥྱཱན྄ སྲྀཥྚྭཱ ཏེཥཱཾ པཱུཪྻྭནིརཱུཔིཏསམཡཾ ཝསཏིསཱིམཱཉྩ ནིརཙིནོཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ཏསྨཱཏ྄ ལོཀཻཿ ཀེནཱཔི པྲཀཱརེཎ མྲྀགཡིཏྭཱ པརམེཤྭརསྱ ཏཏྭཾ པྲཱཔྟུཾ ཏསྱ གཝེཥཎཾ ཀརཎཱིཡམ྄། ");
INSERT INTO santib_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ཀིནྟུ སོ྅སྨཱཀཾ ཀསྨཱཙྩིདཔི དཱུརེ ཏིཥྛཏཱིཏི ནཧི, ཝཡཾ ཏེན ནིཤྭསནཔྲཤྭསནགམནཱགམནཔྲཱཎདྷཱརཎཱནི ཀུརྨྨཿ, པུुནཤྩ ཡུཥྨཱཀམེཝ ཀཏིཔཡཱཿ ཀཝཡཿ ཀཐཡནྟི ‘ཏསྱ ཝཾཤཱ ཝཡཾ སྨོ ཧི’ ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ཨཏཨེཝ ཡདི ཝཡམ྄ ཨཱིཤྭརསྱ ཝཾཤཱ བྷཝཱམསྟརྷི མནུཥྱཻ ཪྻིདྱཡཱ ཀཽཤལེན ཙ ཏཀྵིཏཾ སྭརྞཾ རཱུཔྱཾ དྲྀཥད྄ ཝཻཏེཥཱམཱིཤྭརཏྭམ྄ ཨསྨཱབྷི རྣ ཛྙཱཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ཏེཥཱཾ པཱུཪྻྭཱིཡལོཀཱནཱམ྄ ཨཛྙཱནཏཱཾ པྲཏཱིཤྭརོ ཡདྱཔི ནཱཝཱདྷཏྟ ཏཐཱཔཱིདཱནཱིཾ སཪྻྭཏྲ སཪྻྭཱན྄ མནཿ པརིཝརྟྟཡིཏུམ྄ ཨཱཛྙཱཔཡཏི, ");
INSERT INTO santib_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ཡཏཿ སྭནིཡུཀྟེན པུརུཥེཎ ཡདཱ ས པྲྀཐིཝཱིསྠཱནཱཾ སཪྻྭལོཀཱནཱཾ ཝིཙཱརཾ ཀརིཥྱཏི ཏདྡིནཾ ནྱརཱུཔཡཏ྄; ཏསྱ ཤྨཤཱནོཏྠཱཔནེན ཏསྨིན྄ སཪྻྭེབྷྱཿ པྲམཱཎཾ པྲཱདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ཏདཱ ཤྨཤཱནཱད྄ ཨུཏྠཱནསྱ ཀཐཱཾ ཤྲུཏྭཱ ཀེཙིད྄ ཨུཔཱཧམན྄, ཀེཙིདཝདན྄ ཨེནཱཾ ཀཐཱཾ པུནརཔི ཏྭཏྟཿ ཤྲོཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ཏཏཿ པཽལསྟེཥཱཾ སམཱིཔཱཏ྄ པྲསྠིाཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ཏཐཱཔི ཀེཙིལློཀཱསྟེན སཱརྡྡྷཾ མིལིཏྭཱ ཝྱཤྭསན྄ ཏེཥཱཾ མདྷྱེ ྅རེཡཔཱགཱིཡདིཡནུསིཡོ དཱམཱརཱིནཱམཱ ཀཱཙིནྣཱརཱི ཀིཡནྟོ ནརཱཤྩཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ཏདྒྷཊནཱཏཿ པརཾ པཽལ ཨཱཐཱིནཱིནགརཱད྄ ཡཱཏྲཱཾ ཀྲྀཏྭཱ ཀརིནྠནགརམ྄ ཨཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ཏསྨིན྄ སམཡེ ཀླཽདིཡཿ སཪྻྭཱན྄ ཡིཧཱུདཱིཡཱན྄ རོམཱནགརཾ ཝིཧཱཡ གནྟུམ྄ ཨཱཛྙཱཔཡཏ྄, ཏསྨཱཏ྄ པྲིསྐིལླཱནཱམྣཱ ཛཱཡཡཱ སཱརྡྡྷམ྄ ཨིཏཱལིཡཱདེཤཱཏ྄ ཀིཉྩིཏྤཱུཪྻྭམ྄ ཨཱགམཏ྄ ཡཿ པནྟདེཤེ ཛཱཏ ཨཱཀྐིལནཱམཱ ཡིཧཱུདཱིཡལོཀཿ པཽལསྟཾ སཱཀྵཱཏ྄ པྲཱཔྱ ཏཡོཿ སམཱིཔམིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ཏཽ དཱུཥྱནིརྨྨཱཎཛཱིཝིནཽ, ཏསྨཱཏ྄ པརསྤརམ྄ ཨེཀཝྲྀཏྟིཀཏྭཱཏ྄ ས ཏཱབྷྱཱཾ སཧ ཨུཥིཏྭཱ ཏཏ྄ ཀརྨྨཱཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","པཽལཿ པྲཏིཝིཤྲཱམཝཱརཾ བྷཛནབྷཝནཾ གཏྭཱ ཝིཙཱརཾ ཀྲྀཏྭཱ ཡིཧཱུདཱིཡཱན྄ ཨནྱདེཤཱིཡཱཾཤྩ པྲཝྲྀཏྟིཾ གྲཱཧིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","སཱིལཏཱིམཐིཡཡོ རྨཱཀིདནིཡཱདེཤཱཏ྄ སམེཏཡོཿ སཏོཿ པཽལ ཨུཏྟཔྟམནཱ བྷཱུཏྭཱ ཡཱིཤུརཱིཤྭརེཎཱབྷིཥིཀྟོ བྷཝཏཱིཏི པྲམཱཎཾ ཡིཧཱུདཱིཡཱནཱཾ སམཱིཔེ པྲཱདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ཀིནྟུ ཏེ ྅ཏཱིཝ ཝིརོདྷཾ ཝིདྷཱཡ པཱཥཎྜཱིཡཀཐཱཾ ཀཐིཏཝནྟསྟཏཿ པཽལོ ཝསྟྲཾ དྷུནྭན྄ ཨེཏཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄, ཡུཥྨཱཀཾ ཤོཎིཏཔཱཏཱཔརཱདྷོ ཡུཥྨཱན྄ པྲཏྱེཝ བྷཝཏུ, ཏེནཱཧཾ ནིརཔརཱདྷོ ྅དྱཱརབྷྱ བྷིནྣདེཤཱིཡཱནཱཾ སམཱིཔཾ ཡཱམི། ");
INSERT INTO santib_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ས ཏསྨཱཏ྄ པྲསྠཱཡ བྷཛནབྷཝནསམཱིཔསྠསྱ ཡུསྟནཱམྣ ཨཱིཤྭརབྷཀྟསྱ བྷིནྣདེཤཱིཡསྱ ནིཝེཤནཾ པྲཱཝིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ཏཏཿ ཀྲཱིཥྤནཱམཱ བྷཛནབྷཝནཱདྷིཔཏིཿ སཔརིཝཱརཿ པྲབྷཽ ཝྱཤྭསཱིཏ྄, ཀརིནྠནགརཱིཡཱ བཧཝོ ལོཀཱཤྩ སམཱཀརྞྱ ཝིཤྭསྱ མཛྫིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ཀྵཎདཱཡཱཾ པྲབྷུཿ པཽལཾ དརྴནཾ དཏྭཱ བྷཱཥིཏཝཱན྄, མཱ བྷཻཥཱིཿ, མཱ ནིརསཱིཿ ཀཐཱཾ པྲཙཱརཡ། ");
INSERT INTO santib_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ཨཧཾ ཏྭཡཱ སཱརྡྡྷམ྄ ཨཱས ཧིཾསཱརྠཾ ཀོཔི ཏྭཱཾ སྤྲཥྚུཾ ན ཤཀྵྱཏི ནགརེ྅སྨིན྄ མདཱིཡཱ ལོཀཱ བཧཝ ཨཱསཏེ། ");
INSERT INTO santib_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ཏསྨཱཏ྄ པཽལསྟནྣགརེ པྲཱཡེཎ སཱརྡྡྷཝཏྶརཔཪྻྱནྟཾ སཾསྠཱཡེཤྭརསྱ ཀཐཱམ྄ ཨུཔཱདིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","གཱལླིཡནཱམཱ ཀཤྩིད྄ ཨཱཁཱཡཱདེཤསྱ པྲཱཌྭིཝཱཀཿ སམབྷཝཏ྄, ཏཏོ ཡིཧཱུདཱིཡཱ ཨེཀཝཱཀྱཱཿ སནྟཿ པཽལམ྄ ཨཱཀྲམྱ ཝིཙཱརསྠཱནཾ ནཱིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","མཱནུཥ ཨེཥ ཝྱཝསྠཱཡ ཝིརུདྡྷམ྄ ཨཱིཤྭརབྷཛནཾ ཀརྟྟུཾ ལོཀཱན྄ ཀུཔྲཝྲྀཏྟིཾ གྲཱཧཡཏཱིཏི ནིཝེདིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ཏཏཿ པཽལེ པྲཏྱུཏྟརཾ དཱཏུམ྄ ཨུདྱཏེ སཏི གཱལླིཡཱ ཡིཧཱུདཱིཡཱན྄ ཝྱཱཧརཏ྄, ཡདི ཀསྱཙིད྄ ཨནྱཱཡསྱ ཝཱཏིཤཡདུཥྚཏཱཙརཎསྱ ཝིཙཱརོ྅བྷཝིཥྱཏ྄ ཏརྷི ཡུཥྨཱཀཾ ཀཐཱ མཡཱ སཧནཱིཡཱབྷཝིཥྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ཀིནྟུ ཡདི ཀེཝལཾ ཀཐཱཡཱ ཝཱ ནཱམྣོ ཝཱ ཡུཥྨཱཀཾ ཝྱཝསྠཱཡཱ ཝིཝཱདོ བྷཝཏི ཏརྷི ཏསྱ ཝིཙཱརམཧཾ ན ཀརིཥྱཱམི, ཡཱུཡཾ ཏསྱ མཱིམཱཾསཱཾ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ཏཏཿ ས ཏཱན྄ ཝིཙཱརསྠཱནཱད྄ དཱུརཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ཏདཱ བྷིནྣདེཤཱིཡཱཿ སོསྠིནིནཱམཱནཾ བྷཛནབྷཝནསྱ པྲདྷཱནཱདྷིཔཏིཾ དྷྲྀཏྭཱ ཝིཙཱརསྠཱནསྱ སམྨུཁེ པྲཱཧརན྄ ཏཐཱཔི གཱལླིཡཱ ཏེཥུ སཪྻྭཀརྨྨསུ ན མནོ ནྱདདྷཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","པཽལསྟཏྲ པུནརྦཧུདིནཱནི ནྱཝསཏ྄, ཏཏོ བྷྲཱཏྲྀགཎཱད྄ ཝིསརྫནཾ པྲཱཔྱ ཀིཉྩནཝྲཏནིམིཏྟཾ ཀིཾཀྲིཡཱནགརེ ཤིརོ མུཎྜཡིཏྭཱ པྲིསྐིལླཱཀྐིལཱབྷྱཱཾ སཧིཏོ ཛལཔཐེན སུརིཡཱདེཤཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ཏཏ ཨིཕིཥནགར ཨུཔསྠཱཡ ཏཏྲ ཏཽ ཝིསྲྀཛྱ སྭཡཾ བྷཛནབྷྭནཾ པྲཝིཤྱ ཡིཧཱུདཱིཡཻཿ སཧ ཝིཙཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ཏེ སྭཻཿ སཱརྡྡྷཾ པུནཿ ཀཏིཔཡདིནཱནི སྠཱཏུཾ ཏཾ ཝྱནཡན྄, ས ཏདནུརརཱིཀྲྀཏྱ ཀཐཱམེཏཱཾ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ཡིརཱུཤཱལམི ཨཱགཱམྱུཏྶཝཔཱལནཱརྠཾ མཡཱ གམནཱིཡཾ; པཤྩཱད྄ ཨཱིཤྭརེཙྪཱཡཱཾ ཛཱཏཱཡཱཾ ཡུཥྨཱཀཾ སམཱིཔཾ པྲཏྱཱགམིཥྱཱམི། ཏཏཿ པརཾ ས ཏཻ ཪྻིསྲྀཥྚཿ སན྄ ཛལཔཐེན ཨིཕིཥནགརཱཏ྄ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ཏཏཿ ཀཻསརིཡཱམ྄ ཨུཔསྠིཏཿ སན྄ ནགརཾ གཏྭཱ སམཱཛཾ ནམསྐྲྀཏྱ ཏསྨཱད྄ ཨཱནྟིཡཁིཡཱནགརཾ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ཏཏྲ ཀིཡཏྐཱལཾ ཡཱཔཡིཏྭཱ ཏསྨཱཏ྄ པྲསྠཱཡ སཪྻྭེཥཱཾ ཤིཥྱཱཎཱཾ མནཱཾསི སུསྠིརཱཎི ཀྲྀཏྭཱ ཀྲམཤོ གལཱཏིཡཱཕྲུགིཡཱདེཤཡོ རྦྷྲམིཏྭཱ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ཏསྨིནྣེཝ སམཡེ སིཀནྡརིཡཱནགརེ ཛཱཏ ཨཱཔལློནཱམཱ ཤཱསྟྲཝིཏ྄ སུཝཀྟཱ ཡིཧཱུདཱིཡ ཨེཀོ ཛན ཨིཕིཥནགརམ྄ ཨཱགཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ས ཤིཀྵིཏཔྲབྷུམཱརྒོ མནསོདྱོགཱི ཙ སན྄ ཡོཧནོ མཛྫནམཱཏྲཾ ཛྙཱཏྭཱ ཡཐཱརྠཏཡཱ པྲབྷོཿ ཀཐཱཾ ཀཐཡན྄ སམུཔཱདིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ཨེཥ ཛནོ ནིརྦྷཡཏྭེན བྷཛནབྷཝནེ ཀཐཡིཏུམ྄ ཨཱརབྡྷཝཱན྄, ཏཏཿ པྲིསྐིལླཱཀྐིལཽ ཏསྱོཔདེཤཀཐཱཾ ནིཤམྱ ཏཾ སྭཡོཿ སམཱིཔམ྄ ཨཱནཱིཡ ཤུདྡྷརཱུཔེཎེཤྭརསྱ ཀཐཱམ྄ ཨབོདྷཡཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","པཤྩཱཏ྄ ས ཨཱཁཱཡཱདེཤཾ གནྟུཾ མཏིཾ ཀྲྀཏཝཱན྄, ཏདཱ ཏཏྲཏྱཿ ཤིཥྱགཎོ ཡཐཱ ཏཾ གྲྀཧླཱཏི ཏདརྠཾ བྷྲཱཏྲྀགཎེན སམཱཤྭསྱ པཏྲེ ལིཁིཏེ སཏི, ཨཱཔལླཱསྟཏྲོཔསྠིཏཿ སན྄ ཨནུགྲཧེཎ པྲཏྱཡིནཱཾ བཧཱུཔཀཱརཱན྄ ཨཀརོཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ཕལཏོ ཡཱིཤུརབྷིཥིཀྟསྟྲཱཏེཏི ཤཱསྟྲཔྲམཱཎཾ དཏྭཱ པྲཀཱཤརཱུཔེཎ པྲཏིཔནྣཾ ཀྲྀཏྭཱ ཡིཧཱུདཱིཡཱན྄ ནིརུཏྟརཱན྄ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ཀརིནྠནགར ཨཱཔལླསཿ སྠིཏིཀཱལེ པཽལ ཨུཏྟརཔྲདེཤཻརཱགཙྪན྄ ཨིཕིཥནགརམ྄ ཨུཔསྠིཏཝཱན྄། ཏཏྲ ཀཏིཔཡཤིཥྱཱན྄ སཱཀྵཏ྄ པྲཱཔྱ ཏཱན྄ ཨཔྲྀཙྪཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ཡཱུཡཾ ཝིཤྭསྱ པཝིཏྲམཱཏྨཱནཾ པྲཱཔྟཱ ན ཝཱ? ཏཏསྟེ པྲཏྱཝདན྄ པཝིཏྲ ཨཱཏྨཱ དཱིཡཏེ ཨིཏྱསྨཱབྷིཿ ཤྲུཏམཔི ནཧི། ");
INSERT INTO santib_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ཏདཱ སཱ྅ཝདཏ྄ ཏརྷི ཡཱུཡཾ ཀེན མཛྫིཏཱ ཨབྷཝཏ? ཏེ྅ཀཐཡན྄ ཡོཧནོ མཛྫནེན། ");
INSERT INTO santib_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ཏདཱ པཽལ ཨུཀྟཝཱན྄ ཨིཏཿ པརཾ ཡ ཨུཔསྠཱསྱཏི ཏསྨིན྄ ཨརྠཏ ཡཱིཤུཁྲཱིཥྚེ ཝིཤྭསིཏཝྱམིཏྱུཀྟྭཱ ཡོཧན྄ མནཿཔརིཝརྟྟནསཱུཙཀེན མཛྫནེན ཛལེ ལོཀཱན྄ ཨམཛྫཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ཏཱདྲྀཤཱིཾ ཀཐཱཾ ཤྲུཏྭཱ ཏེ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ མཛྫིཏཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ཏཏཿ པཽལེན ཏེཥཱཾ གཱཏྲེཥུ ཀརེ྅རྤིཏེ ཏེཥཱམུཔརི པཝིཏྲ ཨཱཏྨཱཝརཱུཌྷཝཱན྄, ཏསྨཱཏ྄ ཏེ ནཱནཱདེཤཱིཡཱ བྷཱཥཱ བྷཝིཥྱཏྐཐཱཤྩ ཀཐིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ཏེ པྲཱཡེཎ དྭཱདཤཛནཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","པཽལོ བྷཛནབྷཝནཾ གཏྭཱ པྲཱཡེཎ མཱསཏྲཡམ྄ ཨཱིཤྭརསྱ རཱཛྱསྱ ཝིཙཱརཾ ཀྲྀཏྭཱ ལོཀཱན྄ པྲཝརྟྱ སཱཧསེན ཀཐཱམཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ཀིནྟུ ཀཋིནཱནྟཿཀརཎཏྭཱཏ྄ ཀིཡནྟོ ཛནཱ ན ཝིཤྭསྱ སཪྻྭེཥཱཾ སམཀྵམ྄ ཨེཏཏྤཐསྱ ནིནྡཱཾ ཀརྟྟུཾ པྲཝྲྀཏྟཱཿ, ཨཏཿ པཽལསྟེཥཱཾ སམཱིཔཱཏ྄ པྲསྠཱཡ ཤིཥྱགཎཾ པྲྀཐཀྐྲྀཏྭཱ པྲཏྱཧཾ ཏུརཱནྣནཱམྣཿ ཀསྱཙིཏ྄ ཛནསྱ པཱཋཤཱལཱཡཱཾ ཝིཙཱརཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ཨིཏྠཾ ཝཏྶརདྭཡཾ གཏཾ ཏསྨཱད྄ ཨཱཤིཡཱདེཤནིཝཱསིནཿ སཪྻྭེ ཡིཧཱུདཱིཡཱ ཨནྱདེཤཱིཡལོཀཱཤྩ པྲབྷོ ཪྻཱིཤོཿ ཀཐཱམ྄ ཨཤྲཽཥན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","པཽལེན ཙ ཨཱིཤྭར ཨེཏཱདྲྀཤཱནྱདྦྷུཏཱནི ཀརྨྨཱཎི ཀྲྀཏཝཱན྄ ");
INSERT INTO santib_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ཡཏ྄ པརིདྷེཡེ གཱཏྲམཱརྫནཝསྟྲེ ཝཱ ཏསྱ དེཧཱཏ྄ པཱིཌིཏལོཀཱནཱམ྄ སམཱིཔམ྄ ཨཱནཱིཏེ ཏེ ནིརཱམཡཱ ཛཱཏཱ ཨཔཝིཏྲཱ བྷཱུཏཱཤྩ ཏེབྷྱོ བཧིརྒཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ཏདཱ དེཤཱཊནཀཱརིཎཿ ཀིཡནྟོ ཡིཧཱུདཱིཡཱ བྷཱུཏཱཔསཱརིཎོ བྷཱུཏགྲསྟནོཀཱནཱཾ སནྣིདྷཽ པྲབྷེ ཪྻཱིཤོ རྣཱམ ཛཔྟྭཱ ཝཱཀྱམིདམ྄ ཨཝདན྄, ཡསྱ ཀཐཱཾ པཽལཿ པྲཙཱརཡཏི ཏསྱ ཡཱིཤོ རྣཱམྣཱ ཡུཥྨཱན྄ ཨཱཛྙཱཔཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","སྐིཝནཱམྣོ ཡིཧཱུདཱིཡཱནཱཾ པྲདྷཱནཡཱཛཀསྱ སཔྟབྷིཿ པུཏྟཻསྟཐཱ ཀྲྀཏེ སཏི ");
INSERT INTO santib_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ཀཤྩིད྄ ཨཔཝིཏྲོ བྷཱུཏཿ པྲཏྱུདིཏཝཱན྄, ཡཱིཤུཾ ཛཱནཱམི པཽལཉྩ པརིཙིནོམི ཀིནྟུ ཀེ ཡཱུཡཾ? ");
INSERT INTO santib_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ཨིཏྱུཀྟྭཱ སོཔཝིཏྲབྷཱུཏགྲསྟོ མནུཥྱོ ལམྥཾ ཀྲྀཏྭཱ ཏེཥཱམུཔརི པཏིཏྭཱ བལེན ཏཱན྄ ཛིཏཝཱན྄, ཏསྨཱཏྟེ ནགྣཱཿ ཀྵཏཱངྒཱཤྩ སནྟསྟསྨཱད྄ གེཧཱཏ྄ པལཱཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","སཱ ཝཱག྄ ཨིཕིཥནགརནིཝཱསིནསཾ སཪྻྭེཥཱཾ ཡིཧཱུདཱིཡཱནཱཾ བྷིནྣདེཤཱིཡཱནཱཾ ལོཀཱནཱཉྩ ཤྲཝོགོཙརཱིབྷཱུཏཱ; ཏཏཿ སཪྻྭེ བྷཡཾ གཏཱཿ པྲབྷོ ཪྻཱིཤོ རྣཱམྣོ ཡཤོ ྅ཝརྡྡྷཏ། ");
INSERT INTO santib_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ཡེཥཱམནེཀེཥཱཾ ལོཀཱནཱཾ པྲཏཱིཏིརཛཱཡཏ ཏ ཨཱགཏྱ སྭཻཿ ཀྲྀཏཱཿ ཀྲིཡཱཿ པྲཀཱཤརཱུཔེཎཱངྒཱིཀྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","བཧཝོ མཱཡཱཀརྨྨཀཱརིཎཿ སྭསྭགྲནྠཱན྄ ཨཱནཱིཡ རཱཤཱིཀྲྀཏྱ སཪྻྭེཥཱཾ སམཀྵམ྄ ཨདཱཧཡན྄, ཏཏོ གཎནཱཾ ཀྲྀཏྭཱབུདྷྱནྟ པཉྩཱཡུཏརཱུཔྱམུདྲཱམཱུལྱཔུསྟཀཱནི དགྡྷཱནི། ");
INSERT INTO santib_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ཨིཏྠཾ པྲབྷོཿ ཀཐཱ སཪྻྭདེཤཾ ཝྱཱཔྱ པྲབལཱ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","སཪྻྭེཥྭེཏེཥུ ཀརྨྨསུ སམྤནྣེཥུ སཏྶུ པཽལོ མཱཀིདནིཡཱཁཱཡཱདེཤཱབྷྱཱཾ ཡིརཱུཤཱལམཾ གནྟུཾ མཏིཾ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄ ཏཏྶྠཱནཾ ཡཱཏྲཱཡཱཾ ཀྲྀཏཱཡཱཾ སཏྱཱཾ མཡཱ རོམཱནགརཾ དྲཥྚཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","སྭཱནུགཏལོཀཱནཱཾ ཏཱིམཐིཡེརཱསྟཽ དྭཽ ཛནཽ མཱཀིདནིཡཱདེཤཾ པྲཏི པྲཧིཏྱ སྭཡམ྄ ཨཱཤིཡཱདེཤེ ཀཏིཔཡདིནཱནི སྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ཀིནྟུ ཏསྨིན྄ སམཡེ མཏེ྅སྨིན྄ ཀལཧོ ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ཏཏྐཱརཎམིདཾ, ཨརྟྟིམཱིདེཝྱཱ རཱུཔྱམནྡིརནིརྨྨཱཎེན སཪྻྭེཥཱཾ ཤིལྤིནཱཾ ཡཐེཥྚལཱབྷམ྄ ཨཛནཡཏ྄ ཡོ དཱིམཱིཏྲིཡནཱམཱ ནཱཌཱིནྡྷམཿ ");
INSERT INTO santib_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ས ཏཱན྄ ཏཏྐརྨྨཛཱིཝིནཿ སཪྻྭལོཀཱཾཤྩ སམཱཧཱུཡ བྷཱཥིཏཝཱན྄ ཧེ མཧེཙྪཱ ཨེཏེན མནྡིརནིརྨྨཱཎེནཱསྨཱཀཾ ཛཱིཝིཀཱ བྷཝཏི, ཨེཏད྄ ཡཱུཡཾ ཝིཏྠ; ");
INSERT INTO santib_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ཀིནྟུ ཧསྟནིརྨྨིཏེཤྭརཱ ཨཱིཤྭརཱ ནཧི པཽལནཱམྣཱ ཀེནཙིཛྫནེན ཀཐཱམིམཱཾ ཝྱཱཧྲྀཏྱ ཀེཝལེཕིཥནགརེ ནཧི པྲཱཡེཎ སཪྻྭསྨིན྄ ཨཱཤིཡཱདེཤེ པྲཝྲྀཏྟིཾ གྲཱཧཡིཏྭཱ བཧུལོཀཱནཱཾ ཤེམུཥཱི པརཱཝརྟྟིཏཱ, ཨེཏད྄ ཡུཥྨཱབྷི རྡྲྀཤྱཏེ ཤྲཱུཡཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ཏེནཱསྨཱཀཾ ཝཱཎིཛྱསྱ སཪྻྭཐཱ ཧཱནེཿ སམྦྷཝནཾ ཀེཝལམིཏི ནཧི, ཨཱཤིཡཱདེཤསྠཻ ཪྻཱ སཪྻྭཛགཏྶྠཻ རློཀཻཿ པཱུཛྱཱ ཡཱརྟིམཱི མཧཱདེཝཱི ཏསྱཱ མནྡིརསྱཱཝཛྙཱནསྱ ཏསྱཱ ཨཻཤྭཪྻྱསྱ ནཱཤསྱ ཙ སམྦྷཱཝནཱ ཝིདྱཏེे། ");
INSERT INTO santib_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ཨེཏཱདྲྀཤཱིཾ ཀཐཱཾ ཤྲུཏྭཱ ཏེ མཧཱཀྲོདྷཱནྭིཏཱཿ སནྟ ཨུཙྩཻཿཀཱརཾ ཀཐིཏཝནྟ ཨིཕིཥཱིཡཱནཱམ྄ ཨརྟྟིམཱི དེཝཱི མཧཏཱི བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ཏཏཿ སཪྻྭནགརཾ ཀལཧེན པརིཔཱུརྞམབྷཝཏ྄, ཏཏཿ པརཾ ཏེ མཱཀིདནཱིཡགཱཡཱརིསྟཱརྑནཱམཱནཽ པཽལསྱ དྭཽ སཧཙརཽ དྷྲྀཏྭཻཀཙིཏྟཱ རངྒབྷཱུམིཾ ཛཝེན དྷཱཝིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ཏཏཿ པཽལོ ལོཀཱནཱཾ སནྣིདྷིཾ ཡཱཏུམ྄ ཨུདྱཏཝཱན྄ ཀིནྟུ ཤིཥྱགཎསྟཾ ཝཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","པཽལསྱཏྨཱིཡཱ ཨཱཤིཡཱདེཤསྠཱཿ ཀཏིཔཡཱཿ པྲདྷཱནལོཀཱསྟསྱ སམཱིཔཾ ནརམེཀཾ པྲེཥྱ ཏྭཾ རངྒབྷཱུམིཾ མཱགཱ ཨིཏི ནྱཝེདཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ཏཏོ ནཱནཱལོཀཱནཱཾ ནཱནཱཀཐཱཀཐནཱཏ྄ སབྷཱ ཝྱཱཀུལཱ ཛཱཏཱ ཀིཾ ཀཱརཎཱད྄ ཨེཏཱཝཏཱི ཛནཏཱབྷཝཏ྄ ཨེཏད྄ ཨདྷིཀཻ རློཀཻ རྣཱཛྙཱཡི། ");
INSERT INTO santib_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ཏཏཿ པརཾ ཛནཏཱམདྷྱཱད྄ ཡིཧཱུདཱིཡཻརྦཧིཥྐྲྀཏཿ སིཀནྡརོ ཧསྟེན སངྐེཏཾ ཀྲྀཏྭཱ ལོཀེབྷྱ ཨུཏྟརཾ དཱཏུམུདྱཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ཀིནྟུ ས ཡིཧཱུདཱིཡལོཀ ཨིཏི ནིཤྩིཏེ སཏི ཨིཕིཥཱིཡཱནཱམ྄ ཨརྟྟིམཱི དེཝཱི མཧཏཱིཏི ཝཱཀྱཾ པྲཱཡེཎ པཉྩ དཎྜཱན྄ ཡཱཝད྄ ཨེཀསྭརེཎ ལོཀནིཝཧཻཿ པྲོཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ཏཏོ ནགརཱདྷིཔཏིསྟཱན྄ སྠིརཱན྄ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄ ཧེ ཨིཕིཥཱཡཱཿ སཪྻྭེ ལོཀཱ ཨཱཀརྞཡཏ, ཨརྟིམཱིམཧཱདེཝྱཱ མཧཱདེཝཱཏ྄ པཏིཏཱཡཱསྟཏྤྲཏིམཱཡཱཤྩ པཱུཛནམ ཨིཕིཥནགརསྠཱཿ སཪྻྭེ ལོཀཱཿ ཀུཪྻྭནྟི, ཨེཏཏ྄ ཀེ ན ཛཱནནྟི? ");
INSERT INTO santib_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ཏསྨཱད྄ ཨེཏཏྤྲཏིཀཱུལཾ ཀེཔི ཀཐཡིཏུཾ ན ཤཀྣུཝནྟི, ཨིཏི ཛྙཱཏྭཱ ཡུཥྨཱབྷིཿ སུསྠིརཏྭེན སྠཱཏཝྱམ྄ ཨཝིཝིཙྱ ཀིམཔི ཀརྨྨ ན ཀརྟྟཝྱཉྩ། ");
INSERT INTO santib_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ཡཱན྄ ཨེཏཱན྄ མནུཥྱཱན྄ ཡཱུཡམཏྲ སམཱནཡཏ ཏེ མནྡིརདྲཝྱཱཔཧཱརཀཱ ཡུཥྨཱཀཾ དེཝྱཱ ནིནྡཀཱཤྩ ན བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ཡདི ཀཉྩན པྲཏི དཱིམཱིཏྲིཡསྱ ཏསྱ སཧཱཡཱནཱཉྩ ཀཱཙིད྄ ཨཱཔཏྟི ཪྻིདྱཏེ ཏརྷི པྲཏིནིདྷིལོཀཱ ཝིཙཱརསྠཱནཉྩ སནྟི, ཏེ ཏཏ྄ སྠཱནཾ གཏྭཱ ཨུཏྟརཔྲཏྱུཏྟརེ ཀུཪྻྭནྟུ། ");
INSERT INTO santib_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ཀིནྟུ ཡུཥྨཱཀཾ ཀཱཙིདཔརཱ ཀཐཱ ཡདི ཏིཥྛཏི ཏརྷི ནིཡམིཏཱཡཱཾ སབྷཱཡཱཾ ཏསྱཱ ནིཥྤཏྟི རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ཀིནྟྭེཏསྱ ཝིརོདྷསྱོཏྟརཾ ཡེན དཱཏུཾ ཤཀྣུམ྄ ཨེཏཱདྲྀཤསྱ ཀསྱཙིཏ྄ ཀཱརཎསྱཱབྷཱཝཱད྄ ཨདྱཏནགྷཊནཱཧེཏོ རཱཛདྲོཧིཎཱམིཝཱསྨཱཀམ྄ ཨབྷིཡོགོ བྷཝིཥྱཏཱིཏི ཤངྐཱ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ཨིཏི ཀཐཡིཏྭཱ ས སབྷཱསྠལོཀཱན྄ ཝིསྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ཨིཏྠཾ ཀལཧེ ནིཝྲྀཏྟེ སཏི པཽལཿ ཤིཥྱགཎམ྄ ཨཱཧཱུཡ ཝིསརྫནཾ པྲཱཔྱ མཱཀིདནིཡཱདེཤཾ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ཏེན སྠཱནེན གཙྪན྄ ཏདྡེཤཱིཡཱན྄ ཤིཥྱཱན྄ བཧཱུཔདིཤྱ ཡཱུནཱནཱིཡདེཤམ྄ ཨུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ཏཏྲ མཱསཏྲཡཾ སྠིཏྭཱ ཏསྨཱཏ྄ སུརིཡཱདེཤཾ ཡཱཏུམ྄ ཨུདྱཏཿ, ཀིནྟུ ཡིཧཱུདཱིཡཱསྟཾ ཧནྟུཾ གུཔྟཱ ཨཏིཥྛན྄ ཏསྨཱཏ྄ ས པུནརཔི མཱཀིདནིཡཱམཱརྒེཎ པྲཏྱཱགནྟུཾ མཏིཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","བིརཡཱནགརཱིཡསོཔཱཏྲཿ ཐིཥལནཱིཀཱིཡཱརིསྟཱརྑསིཀུནྡཽ དརྦྦོནགརཱིཡགཱཡཏཱིམཐིཡཽ ཨཱཤིཡཱདེཤཱིཡཏུཁིཀཏྲཕིམཽ ཙ ཏེན སཱརྡྡྷཾ ཨཱཤིཡཱདེཤཾ ཡཱཝད྄ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ཨེཏེ སཪྻྭེ ྅གྲསརཱཿ སནྟོ ྅སྨཱན྄ ཨཔེཀྵྱ ཏྲོཡཱནགརེ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ཀིཎྭཤཱུནྱཔཱུཔོཏྶཝདིནེ ཙ གཏེ སཏི ཝཡཾ ཕིལིཔཱིནགརཱཏ྄ ཏོཡཔཐེན གཏྭཱ པཉྩབྷི རྡིནཻསྟྲོཡཱནགརམ྄ ཨུཔསྠཱཡ ཏཏྲ སཔྟདིནཱནྱཝཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","སཔྟཱཧསྱ པྲཐམདིནེ པཱུཔཱན྄ བྷཾཀྟུ ཤིཥྱེཥུ མིལིཏེཥུ པཽལཿ པརདིནེ ཏསྨཱཏ྄ པྲསྠཱཏུམ྄ ཨུདྱཏཿ སན྄ ཏདཧྣི པྲཱཡེཎ ཀྵཔཱཡཱ ཡཱམདྭཡཾ ཡཱཝཏ྄ ཤིཥྱེབྷྱོ དྷརྨྨཀཐཱམ྄ ཨཀཐཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ཨུཔརིསྠེ ཡསྨིན྄ པྲཀོཥྛེ སབྷཱཾ ཀྲྀཏྭཱསན྄ ཏཏྲ བཧཝཿ པྲདཱིཔཱཿ པྲཱཛྭལན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ཨུཏུཁནཱམཱ ཀཤྩན ཡུཝཱ ཙ ཝཱཏཱཡན ཨུཔཝིཤན྄ གྷོརཏརནིདྲཱགྲསྟོ ྅བྷཱུཏ྄ ཏདཱ པཽལེན བཧུཀྵཎཾ ཀཐཱཡཱཾ པྲཙཱརིཏཱཡཱཾ ནིདྲཱམགྣཿ ས ཏསྨཱད྄ ཨུཔརིསྠཏྲྀཏཱིཡཔྲཀོཥྛཱད྄ ཨཔཏཏ྄, ཏཏོ ལོཀཱསྟཾ མྲྀཏཀལྤཾ དྷྲྀཏྭོདཏོལཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ཏཏཿ པཽལོ྅ཝརུཧྱ ཏསྱ གཱཏྲེ པཏིཏྭཱ ཏཾ ཀྲོཌེ ནིདྷཱཡ ཀཐིཏཝཱན྄, ཡཱུཡཾ ཝྱཱཀུལཱ མཱ བྷཱུཏ ནཱཡཾ པྲཱཎཻ ཪྻིཡུཀྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","པཤྩཱཏ྄ ས པུནཤྩོཔརི གཏྭཱ པཱུཔཱན྄ བྷཾཀྟྭཱ པྲབྷཱཏཾ ཡཱཝཏ྄ ཀཐོཔཀཐནེ ཀྲྀཏྭཱ པྲསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ཏེ ཙ ཏཾ ཛཱིཝནྟཾ ཡུཝཱནཾ གྲྀཧཱིཏྭཱ གཏྭཱ པརམཱཔྱཱཡིཏཱ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ཨནནྟརཾ ཝཡཾ པོཏེནཱགྲསརཱ བྷཱུཏྭཱསྨནགརམ྄ ཨུཏྟཱིཪྻྱ པཽལཾ གྲཧཱིཏུཾ མཏིམ྄ ཨཀུརྨྨ ཡཏཿ ས ཏཏྲ པདྦྷྱཱཾ ཝྲཛིཏུཾ མཏིཾ ཀྲྀཏྭེཏི ནིརཱུཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ཏསྨཱཏ྄ ཏཏྲཱསྨཱབྷིཿ སཱརྡྡྷཾ ཏསྨིན྄ མིལིཏེ སཏི ཝཡཾ ཏཾ ནཱིཏྭཱ མིཏུལཱིནྱུཔདྭཱིཔཾ པྲཱཔྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ཏསྨཱཏ྄ པོཏཾ མོཙཡིཏྭཱ པརེ྅ཧནི ཁཱིཡོཔདྭཱིཔསྱ སམྨུཁཾ ལབྡྷཝནྟསྟསྨཱད྄ ཨེཀེནཱཧྣཱ སཱམོཔདྭཱིཔཾ གཏྭཱ པོཏཾ ལཱགཡིཏྭཱ ཏྲོགུལླིཡེ སྠིཏྭཱ པརསྨིན྄ དིཝསེे མིལཱིཏནགརམ྄ ཨུཔཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ཡཏཿ པཽལ ཨཱཤིཡཱདེཤེ ཀཱལཾ ཡཱཔཡིཏུམ྄ ནཱབྷིལཥན྄ ཨིཕིཥནགརཾ ཏྱཀྟྭཱ ཡཱཏུཾ མནྟྲཎཱཾ སྠིརཱིཀྲྀཏཝཱན྄; ཡསྨཱད྄ ཡདི སཱདྷྱཾ བྷཝཏི ཏརྷི ནིསྟཱརོཏྶཝསྱ པཉྩཱཤཏྟམདིནེ ས ཡིརཱུཤཱལམྱུཔསྠཱཏུཾ མཏིཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","པཽལོ མིལཱིཏཱད྄ ཨིཕིཥཾ པྲཏི ལོཀཾ པྲཧིཏྱ སམཱཛསྱ པྲཱཙཱིནཱན྄ ཨཱཧཱུཡཱནཱིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ཏེཥུ ཏསྱ སམཱིཔམ྄ ཨུཔསྠིཏེཥུ ས ཏེབྷྱ ཨིམཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄, ཨཧམ྄ ཨཱཤིཡཱདེཤེ པྲཐམཱགམནམ྄ ཨཱརབྷྱཱདྱ ཡཱཝད྄ ཡུཥྨཱཀཾ སནྣིདྷཽ སྠིཏྭཱ སཪྻྭསམཡེ ཡཐཱཙརིཏཝཱན྄ ཏད྄ ཡཱུཡཾ ཛཱནཱིཐ; ");
INSERT INTO santib_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ཕལཏཿ སཪྻྭཐཱ ནམྲམནཱཿ སན྄ བཧུཤྲུཔཱཏེན ཡིཧུདཱིཡཱནཱམ྄ ཀུམནྟྲཎཱཛཱཏནཱནཱཔརཱིཀྵཱབྷིཿ པྲབྷོཿ སེཝཱམཀརཝཾ། ");
INSERT INTO santib_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ཀཱམཔི ཧིཏཀཐཱाཾ ན གོཔཱཡིཏཝཱན྄ ཏཱཾ པྲཙཱཪྻྱ སཔྲཀཱཤཾ གྲྀཧེ གྲྀཧེ སམུཔདིཤྱེཤྭརཾ པྲཏི མནཿ པརཱཝརྟྟནཱིཡཾ པྲབྷཽ ཡཱིཤུཁྲཱིཥྚེ ཝིཤྭསནཱིཡཾ ");
INSERT INTO santib_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ཡིཧཱུདཱིཡཱནཱམ྄ ཨནྱདེཤཱིཡལོཀཱནཱཉྩ སམཱིཔ ཨེཏཱདྲྀཤཾ སཱཀྵྱཾ དདཱམི། ");
INSERT INTO santib_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","པཤྱཏ སཱམྤྲཏམ྄ ཨཱཏྨནཱཀྲྀཥྚཿ སན྄ ཡིརཱུཤཱལམྣགརེ ཡཱཏྲཱཾ ཀརོམི, ཏཏྲ མཱམྤྲཏི ཡདྱད྄ གྷཊིཥྱཏེ ཏཱནྱཧཾ ན ཛཱནཱམི; ");
INSERT INTO santib_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ཀིནྟུ མཡཱ བནྡྷནཾ ཀླེཤཤྩ བྷོཀྟཝྱ ཨིཏི པཝིཏྲ ཨཱཏྨཱ ནགརེ ནགརེ པྲམཱཎཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ཏཐཱཔི ཏཾ ཀླེཤམཧཾ ཏྲྀཎཱཡ ན མནྱེ; ཨཱིཤྭརསྱཱནུགྲཧཝིཥཡཀསྱ སུསཾཝཱདསྱ པྲམཱཎཾ དཱཏུཾ, པྲབྷོ ཪྻཱིཤོཿ སཀཱཤཱད ཡསྱཱཿ སེཝཱཡཱཿ བྷཱརཾ པྲཱཔྣཝཾ ཏཱཾ སེཝཱཾ སཱདྷཡིཏུཾ སཱནནྡཾ སྭམཱརྒཾ སམཱཔཡིཏུुཉྩ ནིཛཔྲཱཎཱནཔི པྲིཡཱན྄ ན མནྱེ། ");
INSERT INTO santib_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ཨདྷུནཱ པཤྱཏ ཡེཥཱཾ སམཱིཔེ྅ཧམ྄ ཨཱིཤྭརཱིཡརཱཛྱསྱ སུསཾཝཱདཾ པྲཙཱཪྻྱ བྷྲམཎཾ ཀྲྀཏཝཱན྄ ཨེཏཱདྲྀཤཱ ཡཱུཡཾ མམ ཝདནཾ པུན རྡྲཥྚུཾ ན པྲཱཔྶྱཐ ཨེཏདཔྱཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ཡུཥྨབྷྱམ྄ ཨཧམ྄ ཨཱིཤྭརསྱ སཪྻྭཱན྄ ཨཱདེཤཱན྄ པྲཀཱཤཡིཏུཾ ན ནྱཝརྟྟེ། ");
INSERT INTO santib_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ཨཧཾ སཪྻྭེཥཱཾ ལོཀཱནཱཾ རཀྟཔཱཏདོཥཱད྄ ཡནྣིརྡོཥ ཨཱསེ ཏསྱཱདྱ ཡུཥྨཱན྄ སཱཀྵིཎཿ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ཡཱུཡཾ སྭེཥུ ཏཐཱ ཡསྱ ཝྲཛསྱཱདྷྱཀྵན྄ ཨཱཏྨཱ ཡུཥྨཱན྄ ཝིདྷཱཡ ནྱཡུངྐྟ ཏཏྶཪྻྭསྨིན྄ སཱཝདྷཱནཱ བྷཝཏ, ཡ སམཱཛཉྩ པྲབྷུ རྣིཛརཀྟམཱུལྱེན ཀྲཱིཏཝཱན ཏམ྄ ཨཝཏ, ");
INSERT INTO santib_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ཡཏོ མཡཱ གམནེ ཀྲྀཏཨེཝ དུརྫཡཱ ཝྲྀཀཱ ཡུཥྨཱཀཾ མདྷྱཾ པྲཝིཤྱ ཝྲཛཾ པྲཏི ནིརྡཡཏཱམ྄ ཨཱཙརིཥྱནྟི, ");
INSERT INTO santib_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ཡུཥྨཱཀམེཝ མདྷྱཱདཔི ལོཀཱ ཨུཏྠཱཡ ཤིཥྱགཎམ྄ ཨཔཧནྟུཾ ཝིཔརཱིཏམ྄ ཨུཔདེཀྵྱནྟཱིཏྱཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ཨིཏི ཧེཏོ ཪྻཱུཡཾ སཙཻཏནྱཱཿ སནྟསྟིཥྚཏ, ཨཧཉྩ སཱཤྲུཔཱཏཿ སན྄ ཝཏྶརཏྲཡཾ ཡཱཝད྄ དིཝཱནིཤཾ པྲཏིཛནཾ བོདྷཡིཏུཾ ན ནྱཝརྟྟེ ཏདཔི སྨརཏ། ");
INSERT INTO santib_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ཨིདཱནཱིཾ ཧེ བྷྲཱཏརོ ཡུཥྨཱཀཾ ནིཥྛཱཾ ཛནཡིཏུཾ པཝིཏྲཱིཀྲྀཏལོཀཱནཱཾ མདྷྱེ྅དྷིཀཱརཉྩ དཱཏུཾ སམརྠོ ཡ ཨཱིཤྭརསྟསྱཱནུགྲཧསྱ ཡོ ཝཱདཤྩ ཏཡོརུབྷཡོ ཪྻུཥྨཱན྄ སམཱརྤཡམ྄། ");
INSERT INTO santib_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ཀསྱཱཔི སྭརྞཾ རཱུཔྱཾ ཝསྟྲཾ ཝཱ པྲཏི མཡཱ ལོབྷོ ན ཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ཀིནྟུ མམ མཏྶཧཙརལོཀཱནཱཉྩཱཝཤྱཀཝྱཡཱཡ མདཱིཡམིདཾ ཀརདྭཡམ྄ ཨཤྲཱམྱད྄ ཨེཏད྄ ཡཱུཡཾ ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ཨནེན པྲཀཱརེཎ གྲཧཎད྄ དཱནཾ བྷདྲམིཏི ཡདྭཱཀྱཾ པྲབྷུ ཪྻཱིཤུཿ ཀཐིཏཝཱན྄ ཏཏ྄ སྨརྟྟུཾ དརིདྲལོཀཱནཱམུཔཀཱརཱརྠཾ ཤྲམཾ ཀརྟྟུཉྩ ཡུཥྨཱཀམ྄ ཨུཙིཏམ྄ ཨེཏཏྶཪྻྭཾ ཡུཥྨཱནཧམ྄ ཨུཔདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ཨེཏཱཾ ཀཐཱཾ ཀཐཡིཏྭཱ ས ཛཱནུནཱི པཱཏཡིཏྭཱ སཪྻཻཿ སཧ པྲཱརྠཡཏ། ");
INSERT INTO santib_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ཏེན ཏེ ཀྲནྡྲནྟཿ ");
INSERT INTO santib_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","པུན རྨམ མུཁཾ ན དྲཀྵྱཐ ཝིཤེཥཏ ཨེཥཱ ཡཱ ཀཐཱ ཏེནཱཀཐི ཏཏྐཱརཎཱཏ྄ ཤོཀཾ ཝིལཱཔཉྩ ཀྲྀཏྭཱ ཀཎྛཾ དྷྲྀཏྭཱ ཙུམྦིཏཝནྟཿ། པཤྩཱཏ྄ ཏེ ཏཾ པོཏཾ ནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ཏཻ ཪྻིསྲྀཥྚཱཿ སནྟོ ཝཡཾ པོཏཾ བཱཧཡིཏྭཱ ཨྲྀཛུམཱརྒེཎ ཀོཥམ྄ ཨུཔདྭཱིཔམ྄ ཨཱགཏྱ པརེ྅ཧནི རོདིཡོཔདྭཱིཔམ྄ ཨཱགཙྪཱམ ཏཏསྟསྨཱཏ྄ པཱཏཱརཱཡཱམ྄ ཨུཔཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ཏཏྲ ཕཻནཱིཀིཡཱདེཤགཱམིནམ྄ པོཏམེཀཾ པྲཱཔྱ ཏམཱརུཧྱ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ཀུཔྲོཔདྭཱིཔཾ དྲྀཥྚྭཱ ཏཾ སཝྱདིཤི སྠཱཔཡིཏྭཱ སུརིཡཱདེཤཾ གཏྭཱ པོཏསྠདྲཝྱཱཎྱཝརོཧཡིཏུཾ སོརནགརེ ལཱགིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ཏཏྲ ཤིཥྱགཎསྱ སཱཀྵཱཏྐརཎཱཡ ཝཡཾ ཏཏྲ སཔྟདིནཱནི སྠིཏཝནྟཿ པཤྩཱཏྟེ པཝིཏྲེཎཱཏྨནཱ པཽལཾ ཝྱཱཧརན྄ ཏྭཾ ཡིརཱུཤཱལམྣགརཾ མཱ གམཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ཏཏསྟེཥུ སཔྟསུ དིནེཥུ ཡཱཔིཏེཥུ སཏྶུ ཝཡཾ ཏསྨཱཏ྄ སྠཱནཱཏ྄ ནིཛཝརྟྨནཱ གཏཝནྟཿ, ཏསྨཱཏ྄ ཏེ སབཱལཝྲྀདྡྷཝནིཏཱ ཨསྨཱབྷིཿ སཧ ནགརསྱ པརིསརཔཪྻྱནྟམ྄ ཨཱགཏཱཿ པཤྩཱདྭཡཾ ཛལདྷིཏཊེ ཛཱནུཔཱཏཾ པྲཱརྠཡཱམཧི། ");
INSERT INTO santib_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ཏཏཿ པརསྤརཾ ཝིསྲྀཥྚཱཿ སནྟོ ཝཡཾ པོཏཾ གཏཱསྟེ ཏུ སྭསྭགྲྀཧཾ པྲཏྱཱགཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ཝཡཾ སོརནགརཱཏ྄ ནཱཝཱ པྲསྠཱཡ ཏལིམཱཡིནགརམ྄ ཨུཔཱཏིཥྛཱམ ཏཏྲཱསྨཱཀཾ སམུདྲཱིཡམཱརྒསྱཱནྟོ྅བྷཝཏ྄ ཏཏྲ བྷྲཱཏྲྀགཎཾ ནམསྐྲྀཏྱ དིནམེཀཾ ཏཻཿ སཱརྡྡྷམ྄ ཨུཥཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","པརེ ྅ཧནི པཽལསྟསྱ སངྒིནོ ཝཡཉྩ པྲཏིཥྛམཱནཱཿ ཀཻསརིཡཱནགརམ྄ ཨཱགཏྱ སུསཾཝཱདཔྲཙཱརཀཱནཱཾ སཔྟཛནཱནཱཾ ཕིལིཔནཱམྣ ཨེཀསྱ གྲྀཧཾ པྲཝིཤྱཱཝཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ཏསྱ ཙཏསྲོ དུཧིཏརོ྅ནཱུཌྷཱ བྷཝིཥྱདྭཱདིནྱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ཏཏྲཱསྨཱསུ བཧུདིནཱནི པྲོཥིཏེཥུ ཡིཧཱུདཱིཡདེཤཱད྄ ཨཱགཏྱཱགཱབནཱམཱ བྷཝིཥྱདྭཱདཱི སམུཔསྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","སོསྨཱཀཾ སམཱིཔམེཏྱ པཽལསྱ ཀཊིབནྡྷནཾ གྲྀཧཱིཏྭཱ ནིཛཧསྟཱཔཱདཱན྄ བདྡྷྭཱ བྷཱཥིཏཝཱན྄ ཡསྱེདཾ ཀཊིབནྡྷནཾ ཏཾ ཡིཧཱུདཱིཡལོཀཱ ཡིརཱུཤཱལམནགར ཨིཏྠཾ བདྡྷྭཱ བྷིནྣདེཤཱིཡཱནཱཾ ཀརེཥུ སམརྤཡིཥྱནྟཱིཏི ཝཱཀྱཾ པཝིཏྲ ཨཱཏྨཱ ཀཐཡཏི། ");
INSERT INTO santib_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ཨེཏཱདྲྀཤཱིཾ ཀཐཱཾ ཤྲུཏྭཱ ཝཡཾ ཏནྣགརཝཱསིནོ བྷྲཱཏརཤྩ ཡིརཱུཤཱལམཾ ན ཡཱཏུཾ པཽལཾ ཝྱནཡཱམཧི; ");
INSERT INTO santib_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ཀིནྟུ ས པྲཏྱཱཝཱདཱིཏ྄, ཡཱུཡཾ ཀིཾ ཀུརུཐ? ཀིཾ ཀྲནྡནེན མམཱནྟཿཀརཎཾ ཝིདཱིརྞཾ ཀརིཥྱཐ? པྲབྷོ ཪྻཱིཤོ རྣཱམྣོ ནིམིཏྟཾ ཡིརཱུཤཱལམི བདྡྷོ བྷཝིཏུཾ ཀེཝལ ཏནྣ པྲཱཎཱན྄ དཱཏུམཔི སསཛྫོསྨི། ");
INSERT INTO santib_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ཏེནཱསྨཱཀཾ ཀཐཱཡཱམ྄ ཨགྲྀཧཱིཏཱཡཱམ྄ ཨཱིཤྭརསྱ ཡཐེཙྪཱ ཏཐཻཝ བྷཝཏྭིཏྱུཀྟྭཱ ཝཡཾ ནིརསྱཱམ། ");
INSERT INTO santib_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","པརེ྅ཧནི པཱཐེཡདྲཝྱཱཎི གྲྀཧཱིཏྭཱ ཡིརཱུཤཱལམཾ པྲཏི ཡཱཏྲཱམ྄ ཨཀུརྨྨ། ");
INSERT INTO santib_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ཏཏཿ ཀཻསརིཡཱནགརནིཝཱསིནཿ ཀཏིཔཡཱཿ ཤིཥྱཱ ཨསྨཱབྷིཿ སཱརྡྡྷམ྄ ཨིཏྭཱ ཀྲྀཔྲཱིཡེན མྣཱསནྣཱམྣཱ ཡེན པྲཱཙཱིནཤིཥྱེན སཱརྡྡྷམ྄ ཨསྨཱབྷི ཪྻསྟཝྱཾ ཏསྱ སམཱིཔམ྄ ཨསྨཱན྄ ནཱིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ཨསྨཱསུ ཡིརཱུཤཱལམྱུཔསྠིཏེཥུ ཏཏྲསྠབྷྲཱཏྲྀགཎོ྅སྨཱན྄ ཨཱཧླཱདེན གྲྀཧཱིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","པརསྨིན྄ དིཝསེ པཽལེ྅སྨཱབྷིཿ སཧ ཡཱཀཱུབོ གྲྀཧཾ པྲཝིཥྚེ ལོཀཔྲཱཙཱིནཱཿ སཪྻྭེ ཏཏྲ པརིཥདི སཾསྠིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ཨནནྟརཾ ས ཏཱན྄ ནཏྭཱ སྭཱིཡཔྲཙཱརཎེན བྷིནྣདེཤཱིཡཱན྄ པྲཏཱིཤྭརོ ཡཱནི ཀརྨྨཱཎི སཱདྷིཏཝཱན྄ ཏདཱིཡཱཾ ཀཐཱམ྄ ཨནུཀྲམཱཏ྄ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ཨིཏི ཤྲུཏྭཱ ཏེ པྲབྷུཾ དྷནྱཾ པྲོཙྱ ཝཱཀྱམིདམ྄ ཨབྷཱཥནྟ, ཧེ བྷྲཱཏ ཪྻིཧཱུདཱིཡཱནཱཾ མདྷྱེ བཧུསཧསྲཱཎི ལོཀཱ ཝིཤྭཱསིན ཨཱསཏེ ཀིནྟུ ཏེ སཪྻྭེ ཝྱཝསྠཱམཏཱཙཱརིཎ ཨེཏཏ྄ པྲཏྱཀྵཾ པཤྱསི། ");
INSERT INTO santib_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ཤིཤཱུནཱཾ ཏྭཀྪེདནཱདྱཱཙརཎཾ པྲཏིཥིདྷྱ ཏྭཾ བྷིནྣདེཤནིཝཱསིནོ ཡིཧཱུདཱིཡལོཀཱན྄ མཱུསཱཝཱཀྱམ྄ ཨཤྲདྡྷཱཏུམ྄ ཨུཔདིཤསཱིཏི ཏཻཿ ཤྲུཏམསྟི། ");
INSERT INTO santib_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ཏྭམཏྲཱགཏོསཱིཏི ཝཱརྟྟཱཾ སམཱཀརྞྱ ཛནནིཝཧོ མིལིཏྭཱཝཤྱམེཝཱགམིཥྱཏི; ཨཏཨེཝ ཀིཾ ཀརཎཱིཡམ྄? ཨཏྲ ཝཡཾ མནྟྲཡིཏྭཱ སམུཔཱཡཾ ཏྭཱཾ ཝདཱམསྟཾ ཏྭམཱཙར། ");
INSERT INTO santib_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ཝྲཏཾ ཀརྟྟུཾ ཀྲྀཏསངྐལྤཱ ཡེ྅སྨཱཾཀ ཙཏྭཱརོ མཱནཝཱཿ སནྟི ");
INSERT INTO santib_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ཏཱན྄ གྲྀཧཱིཏྭཱ ཏཻཿ སཧིཏཿ སྭཾ ཤུཙིཾ ཀུརུ ཏཐཱ ཏེཥཱཾ ཤིརོམུཎྜནེ ཡོ ཝྱཡོ བྷཝཏི ཏཾ ཏྭཾ དེཧི། ཏཐཱ ཀྲྀཏེ ཏྭདཱིཡཱཙཱརེ ཡཱ ཛནཤྲུཏི རྫཱཡཏེ སཱལཱིཀཱ ཀིནྟུ ཏྭཾ ཝིདྷིཾ པཱལཡན྄ ཝྱཝསྠཱནུསཱརེཎེཝཱཙརསཱིཏི ཏེ བྷོཏྶནྟེ། ");
INSERT INTO santib_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","བྷིནྣདེཤཱིཡཱནཱཾ ཝིཤྭཱསིལོཀཱནཱཾ ནིཀཊེ ཝཡཾ པཏྲཾ ལིཁིཏྭེཏྠཾ སྠིརཱིཀྲྀཏཝནྟཿ, དེཝཔྲསཱདབྷོཛནཾ རཀྟཾ གལཔཱིཌནམཱརིཏཔྲཱཎིབྷོཛནཾ ཝྱབྷིཙཱརཤྩཻཏེབྷྱཿ སྭརཀྵཎཝྱཏིརེཀེཎ ཏེཥཱམནྱཝིདྷིཔཱལནཾ ཀརཎཱིཡཾ ན། ");
INSERT INTO santib_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ཏཏཿ པཽལསྟཱན྄ མཱནུཥཱནཱདཱཡ པརསྨིན྄ དིཝསེ ཏཻཿ སཧ ཤུཙི རྦྷཱུཏྭཱ མནྡིརཾ གཏྭཱ ཤཽཙཀརྨྨཎོ དིནེཥུ སམྤཱུརྞེཥུ ཏེཥཱམ྄ ཨེཀཻཀཱརྠཾ ནཻཝེདྱཱདྱུཏྶརྒོ བྷཝིཥྱཏཱིཏི ཛྙཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ཏེཥུ སཔྟསུ དིནེཥུ སམཱཔྟཀལྤེཥུ ཨཱཤིཡཱདེཤནིཝཱསིནོ ཡིཧཱུདཱིཡཱསྟཾ མདྷྱེམནྡིརཾ ཝིལོཀྱ ཛནནིཝཧསྱ མནཿསུ ཀུཔྲཝྲྀཏྟིཾ ཛནཡིཏྭཱ ཏཾ དྷྲྀཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","པྲོཙྩཻཿ པྲཱཝོཙན྄, ཧེ ཨིསྲཱཡེལློཀཱཿ སཪྻྭེ སཱཧཱཡྻཾ ཀུརུཏ། ཡོ མནུཛ ཨེཏེཥཱཾ ལོཀཱནཱཾ མཱུསཱཝྱཝསྠཱཡཱ ཨེཏསྱ སྠཱནསྱཱཔི ཝིཔརཱིཏཾ སཪྻྭཏྲ སཪྻྭཱན྄ ཤིཀྵཡཏི ས ཨེཥཿ; ཝིཤེཥཏཿ ས བྷིནྣདེཤཱིཡལོཀཱན྄ མནྡིརམ྄ ཨཱནཱིཡ པཝིཏྲསྠཱནམེཏད྄ ཨཔཝིཏྲམཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","པཱུཪྻྭཾ ཏེ མདྷྱེནགརམ྄ ཨིཕིཥནགརཱིཡཾ ཏྲཕིམཾ པཽལེན སཧིཏཾ དྲྀཥྚཝནྟ ཨེཏསྨཱཏ྄ པཽལསྟཾ མནྡིརམདྷྱམ྄ ཨཱནཡད྄ ཨིཏྱནྭམིམཏ། ");
INSERT INTO santib_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ཨཏཨེཝ སཪྻྭསྨིན྄ ནགརེ ཀལཧོཏྤནྣཏྭཱཏ྄ དྷཱཝནྟོ ལོཀཱ ཨཱགཏྱ པཽལཾ དྷྲྀཏྭཱ མནྡིརསྱ བཧིརཱཀྲྀཥྱཱནཡན྄ ཏཏྐྵཎཱད྄ དྭཱརཱཎི སཪྻྭཱཎི ཙ རུདྡྷཱནི། ");
INSERT INTO santib_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ཏེཥུ ཏཾ ཧནྟུམུདྱཏེेཥུ ཡིརཱུཤཱལམྣགརེ མཧཱནུཔདྲཝོ ཛཱཏ ཨིཏི ཝཱརྟྟཱཡཱཾ སཧསྲསེནཱཔཏེཿ ཀརྞགོཙརཱིབྷཱུཏཱཡཱཾ སཏྱཱཾ ས ཏཏྐྵཎཱཏ྄ སཻནྱཱནི སེནཱཔཏིགཎཉྩ གྲྀཧཱིཏྭཱ ཛཝེནཱགཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ཏཏོ ལོཀཱཿ སེནཱགཎེན སཧ སཧསྲསེནཱཔཏིམ྄ ཨཱགཙྪནྟཾ དྲྀཥྚྭཱ པཽལཏཱཌནཱཏོ ནྱཝརྟྟནྟ། ");
INSERT INTO santib_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ས སཧསྲསེནཱཔཏིཿ སནྣིདྷཱཝཱགམྱ པཽལཾ དྷྲྀཏྭཱ ཤྲྀངྑལདྭཡེན བདྡྷམ྄ ཨཱདིཤྱ ཏཱན྄ པྲྀཥྚཝཱན྄ ཨེཥ ཀཿ? ཀིཾ ཀརྨྨ ཙཱཡཾ ཀྲྀཏཝཱན྄? ");
INSERT INTO santib_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ཏཏོ ཛནསམཱུཧསྱ ཀཤྩིད྄ ཨེཀཔྲཀཱརཾ ཀཤྩིད྄ ཨནྱཔྲཀཱརཾ ཝཱཀྱམ྄ ཨརཽཏ྄ ས ཏཏྲ སཏྱཾ ཛྙཱཏུམ྄ ཀལཧཀཱརཎཱད྄ ཨཤཀྟཿ སན྄ ཏཾ དུརྒཾ ནེཏུམ྄ ཨཱཛྙཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ཏེཥུ སོཔཱནསྱོཔརི པྲཱཔྟེཥུ ལོཀཱནཱཾ སཱཧསཀཱརཎཱཏ྄ སེནཱགཎཿ པཽལམུཏྟོལྱ ནཱིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ཏཏཿ སཪྻྭེ ལོཀཱཿ པཤྩཱདྒཱམིནཿ སནྟ ཨེནཾ དུརཱིཀུརུཏེཏི ཝཱཀྱམ྄ ཨུཙྩཻརཝདན྄། ");
INSERT INTO santib_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","པཽལསྱ དུརྒཱནཡནསམཡེ ས ཏསྨཻ སཧསྲསེནཱཔཏཡེ ཀཐིཏཝཱན྄, བྷཝཏཿ པུརསྟཱཏ྄ ཀཐཱཾ ཀཐཡིཏུཾ ཀིམ྄ ཨནུམནྱཏེ? ས ཏམཔྲྀཙྪཏ྄ ཏྭཾ ཀིཾ ཡཱུནཱནཱིཡཱཾ བྷཱཥཱཾ ཛཱནཱསི? ");
INSERT INTO santib_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ཡོ མིསརཱིཡོ ཛནཿ པཱུཪྻྭཾ ཝིརོདྷཾ ཀྲྀཏྭཱ ཙཏྭཱརི སཧསྲཱཎི གྷཱཏཀཱན྄ སངྒིནཿ ཀྲྀཏྭཱ ཝིཔིནཾ གཏཝཱན྄ ཏྭཾ ཀིཾ སཨེཝ ན བྷཝསི? ");
INSERT INTO santib_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ཏདཱ པཽལོ྅ཀཐཡཏ྄ ཨཧཾ ཀིལིཀིཡཱདེཤསྱ ཏཱརྵནགརཱིཡོ ཡིཧཱུདཱིཡོ, ནཱཧཾ སཱམཱནྱནགརཱིཡོ མཱནཝཿ; ཨཏཨེཝ ཝིནཡེ྅ཧཾ ལཱཀཱནཱཾ སམཀྵཾ ཀཐཱཾ ཀཐཡིཏུཾ མཱམནུཛཱནཱིཥྭ། ");
INSERT INTO santib_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ཏེནཱནུཛྙཱཏཿ པཽལཿ སོཔཱནོཔརི ཏིཥྛན྄ ཧསྟེནེངྒིཏཾ ཀྲྀཏཝཱན྄, ཏསྨཱཏ྄ སཪྻྭེ སུསྠིརཱ ཨབྷཝན྄། ཏདཱ པཽལ ཨིབྲཱིཡབྷཱཥཡཱ ཀཐཡིཏུམ྄ ཨཱརབྷཏ, ");
INSERT INTO santib_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ཧེ པིཏྲྀགཎཱ ཧེ བྷྲཱཏྲྀགཎཱཿ, ཨིདཱནཱིཾ མམ ནིཝེདནེ སམཝདྷཏྟ། ");
INSERT INTO santib_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ཏདཱ ས ཨིབྲཱིཡབྷཱཥཡཱ ཀཐཱཾ ཀཐཡཏཱིཏི ཤྲུཏྭཱ སཪྻྭེ ལོཀཱ ཨཏཱིཝ ནིཿཤབྡཱ སནྟོ྅ཏིཥྛན྄། ");
INSERT INTO santib_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","པཤྩཱཏ྄ སོ྅ཀཐཡད྄ ཨཧཾ ཡིཧཱུདཱིཡ ཨིཏི ནིཤྩཡཿ ཀིལིཀིཡཱདེཤསྱ ཏཱརྵནགརཾ མམ ཛནྨབྷཱུམིཿ,ཨེཏནྣགརཱིཡསྱ གམིལཱིཡེལནཱམྣོ྅དྷྱཱཔཀསྱ ཤིཥྱོ བྷཱུཏྭཱ པཱུཪྻྭཔུརུཥཱཎཱཾ ཝིདྷིཝྱཝསྠཱནུསཱརེཎ སམྤཱུརྞརཱུཔེཎ ཤིཀྵིཏོ྅བྷཝམ྄ ཨིདཱནཱིནྟནཱ ཡཱུཡཾ ཡཱདྲྀཤཱ བྷཝཐ ཏཱདྲྀཤོ྅ཧམཔཱིཤྭརསེཝཱཡཱམ྄ ཨུདྱོགཱི ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","མཏམེཏད྄ དྭིཥྚྭཱ ཏདྒྲཱཧིནཱརཱིཔུརུཥཱན྄ ཀཱརཱཡཱཾ བདྡྷྭཱ ཏེཥཱཾ པྲཱཎནཱཤཔཪྻྱནྟཱཾ ཝིཔཀྵཏཱམ྄ ཨཀརཝམ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","མཧཱཡཱཛཀཿ སབྷཱསདཿ པྲཱཙཱིནལོཀཱཤྩ མམཻཏསྱཱཿ ཀཐཱཡཱཿ པྲམཱཎཾ དཱཏུཾ ཤཀྣུཝནྟི, ཡསྨཱཏ྄ ཏེཥཱཾ སམཱིཔཱད྄ དམྨེཥཀནགརནིཝཱསིབྷྲཱཏྲྀགཎཱརྠམ྄ ཨཱཛྙཱཔཏྲཱཎི གྲྀཧཱིཏྭཱ ཡེ ཏཏྲ སྠིཏཱསྟཱན྄ དཎྜཡིཏུཾ ཡིརཱུཤཱལམམ྄ ཨཱནཡནཱརྠཾ དམྨེཥཀནགརཾ གཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ཀིནྟུ གཙྪན྄ ཏནྣགརསྱ སམཱིཔཾ པྲཱཔྟཝཱན྄ ཏདཱ དྭིཏཱིཡཔྲཧརཝེལཱཡཱཾ སཏྱཱམ྄ ཨཀསྨཱད྄ གགཎཱནྣིརྒཏྱ མཧཏཱི དཱིཔྟི རྨམ ཙཏུརྡིཤི པྲཀཱཤིཏཝཏཱི། ");
INSERT INTO santib_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ཏཏོ མཡི བྷཱུམཽै པཏིཏེ སཏི, ཧེ ཤཽལ ཧེ ཤཽལ ཀུཏོ མཱཾ ཏཱཌཡསི? མཱམྤྲཏི བྷཱཥིཏ ཨེཏཱདྲྀཤ ཨེཀོ རཝོཔི མཡཱ ཤྲུཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ཏདཱཧཾ པྲཏྱཝདཾ, ཧེ པྲབྷེ ཀོ བྷཝཱན྄? ཏཏཿ སོ྅ཝཱདཱིཏ྄ ཡཾ ཏྭཾ ཏཱཌཡསི ས ནཱསརཏཱིཡོ ཡཱིཤུརཧཾ། ");
INSERT INTO santib_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","མམ སངྒིནོ ལོཀཱསྟཱཾ དཱིཔྟིཾ དྲྀཥྚྭཱ བྷིཡཾ པྲཱཔྟཱཿ, ཀིནྟུ མཱམྤྲཏྱུདིཏཾ ཏདྭཱཀྱཾ ཏེे ནཱབུདྷྱནྟ། ");
INSERT INTO santib_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ཏཏཿ པརཾ པྲྀཥྚཝཱནཧཾ, ཧེ པྲབྷོ མཡཱ ཀིཾ ཀརྟྟཝྱཾ? ཏཏཿ པྲབྷུརཀཐཡཏ྄, ཨུཏྠཱཡ དམྨེཥཀནགརཾ ཡཱཧི ཏྭཡཱ ཡདྱཏ྄ ཀརྟྟཝྱཾ ནིརཱུཔིཏམཱསྟེ ཏཏ྄ ཏཏྲ ཏྭཾ ཛྙཱཔཡིཥྱསེ། ");
INSERT INTO santib_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ཨནནྟརཾ ཏསྱཱཿ ཁརཏརདཱིཔྟེཿ ཀཱརཎཱཏ྄ ཀིམཔི ན དྲྀཥྚྭཱ སངྒིགཎེན དྷྲྀཏཧསྟཿ སན྄ དམྨེཥཀནགརཾ ཝྲཛིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ཏནྣགརནིཝཱསིནཱཾ སཪྻྭེཥཱཾ ཡིཧཱུདཱིཡཱནཱཾ མཱནྱོ ཝྱཝསྠཱནུསཱརེཎ བྷཀྟཤྩ ཧནཱནཱིཡནཱམཱ མཱནཝ ཨེཀོ ");
INSERT INTO santib_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","མམ སནྣིདྷིམ྄ ཨེཏྱ ཏིཥྛན྄ ཨཀཐཡཏ྄, ཧེ བྷྲཱཏཿ ཤཽལ སུདྲྀཥྚི རྦྷཝ ཏསྨིན྄ དཎྜེ྅ཧཾ སམྱཀ྄ ཏཾ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ཏཏཿ ས མཧྱཾ ཀཐིཏཝཱན྄ ཡཐཱ ཏྭམ྄ ཨཱིཤྭརསྱཱབྷིཔྲཱཡཾ ཝེཏྶི ཏསྱ ཤུདྡྷསཏྟྭཛནསྱ དརྴནཾ པྲཱཔྱ ཏསྱ ཤྲཱིམུཁསྱ ཝཱཀྱཾ ཤྲྀཎོཥི ཏནྣིམིཏྟམ྄ ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥཱཎཱམ྄ ཨཱིཤྭརསྟྭཱཾ མནོནཱིཏཾ ཀྲྀཏཝཱནཾ། ");
INSERT INTO santib_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ཡཏོ ཡདྱད྄ ཨདྲཱཀྵཱིརཤྲཽཥཱིཤྩ སཪྻྭེཥཱཾ མཱནཝཱནཱཾ སམཱིཔེ ཏྭཾ ཏེཥཱཾ སཱཀྵཱི བྷཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ཨཏཨེཝ ཀུཏོ ཝིལམྦསེ? པྲབྷོ རྣཱམྣཱ པྲཱརྠྱ ནིཛཔཱཔཔྲཀྵཱལནཱརྠཾ མཛྫནཱཡ སམུཏྟིཥྛ། ");
INSERT INTO santib_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ཏཏཿ པརཾ ཡིརཱུཤཱལམྣགརཾ པྲཏྱཱགཏྱ མནྡིརེ྅ཧམ྄ ཨེཀདཱ པྲཱརྠཡེ, ཏསྨིན྄ སམཡེ྅ཧམ྄ ཨབྷིབྷཱུཏཿ སན྄ པྲབྷཱུཾ སཱཀྵཱཏ྄ པཤྱན྄, ");
INSERT INTO santib_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ཏྭཾ ཏྭརཡཱ ཡིརཱུཤཱལམཿ པྲཏིཥྛསྭ ཡཏོ ལོཀཱམཡི ཏཝ སཱཀྵྱཾ ན གྲཧཱིཥྱནྟི, མཱམྤྲཏྱུདིཏཾ ཏསྱེདཾ ཝཱཀྱམ྄ ཨཤྲཽཥམ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ཏཏོཧཾ པྲཏྱཝཱདིཥམ྄ ཧེ པྲབྷོ པྲཏིབྷཛནབྷཝནཾ ཏྭཡི ཝིཤྭཱསིནོ ལོཀཱན྄ བདྡྷྭཱ པྲཧྲྀཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ཏཐཱ ཏཝ སཱཀྵིཎཿ སྟིཕཱནསྱ རཀྟཔཱཏནསམཡེ ཏསྱ ཝིནཱཤཾ སམྨནྱ སནྣིདྷཽ ཏིཥྛན྄ ཧནྟྲྀལོཀཱནཱཾ ཝཱསཱཾསི རཀྵིཏཝཱན྄, ཨེཏཏ྄ ཏེ ཝིདུཿ། ");
INSERT INTO santib_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ཏཏཿ སོ྅ཀཐཡཏ྄ པྲཏིཥྛསྭ ཏྭཱཾ དཱུརསྠབྷིནྣདེཤཱིཡཱནཱཾ སམཱིཔཾ པྲེཥཡིཥྱེ། ");
INSERT INTO santib_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ཏདཱ ལོཀཱ ཨེཏཱཝཏྤཪྻྱནྟཱཾ ཏདཱིཡཱཾ ཀཐཱཾ ཤྲུཏྭཱ པྲོཙྩཻརཀཐཡན྄, ཨེནཾ བྷཱུམཎྜལཱད྄ དཱུརཱིཀུརུཏ, ཨེཏཱདྲྀཤཛནསྱ ཛཱིཝནཾ ནོཙིཏམ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ཨིཏྱུཙྩཻཿ ཀཐཡིཏྭཱ ཝསནཱནི པརིཏྱཛྱ གགཎཾ པྲཏི དྷཱུལཱིརཀྵིཔན྄ ");
INSERT INTO santib_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ཏཏཿ སཧསྲསེནཱཔཏིཿ པཽལཾ དུརྒཱབྷྱནྟར ནེཏུཾ སམཱདིཤཏ྄། ཨེཏསྱ པྲཏིཀཱུལཱཿ སནྟོ ལོཀཱཿ ཀིནྣིམིཏྟམ྄ ཨེཏཱཝདུཙྩཻཿསྭརམ྄ ཨཀུཪྻྭན྄, ཨེཏད྄ ཝེཏྟུཾ ཏཾ ཀཤཡཱ པྲཧྲྀཏྱ ཏསྱ པརཱིཀྵཱཾ ཀརྟྟུམཱདིཤཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","པདཱཏཡཤྩརྨྨནིརྨྨིཏརཛྫུབྷིསྟསྱ བནྡྷནཾ ཀརྟྟུམུདྱཏཱསྟཱསྟདཱནཱིཾ པཽལཿ སམྨུཁསྠིཏཾ ཤཏསེནཱཔཏིམ྄ ཨུཀྟཝཱན྄ དཎྜཱཛྙཱཡཱམ྄ ཨཔྲཱཔྟཱཡཱཾ ཀིཾ རོམིལོཀཾ པྲཧརྟྟུཾ ཡུཥྨཱཀམ྄ ཨདྷིཀཱརོསྟི? ");
INSERT INTO santib_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ཨེནཱཾ ཀཐཱཾ ཤྲུཏྭཱ ས སཧསྲསེནཱཔཏེཿ སནྣིདྷིཾ གཏྭཱ ཏཱཾ ཝཱརྟྟཱམཝདཏ྄ ས རོམིལོཀ ཨེཏསྨཱཏ྄ སཱཝདྷཱནཿ སན྄ ཀརྨྨ ཀུརུ། ");
INSERT INTO santib_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ཏསྨཱཏ྄ སཧསྲསེནཱཔཏི རྒཏྭཱ ཏམཔྲཱཀྵཱིཏ྄ ཏྭཾ ཀིཾ རོམིལོཀཿ? ཨིཏི མཱཾ བྲཱུཧི། སོ྅ཀཐཡཏ྄ སཏྱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ཏཏཿ སཧསྲསེནཱཔཏིཿ ཀཐིཏཝཱན྄ བཧུདྲཝིཎཾ དཏྟྭཱཧཾ ཏཏ྄ པཽརསཁྱཾ པྲཱཔྟཝཱན྄; ཀིནྟུ པཽལཿ ཀཐིཏཝཱན྄ ཨཧཾ ཛནུནཱ ཏཏ྄ པྲཱཔྟོ྅སྨི། ");
INSERT INTO santib_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ཨིཏྠཾ སཏི ཡེ པྲཧཱརེཎ ཏཾ པརཱིཀྵིཏུཾ སམུདྱཏཱ ཨཱསན྄ ཏེ ཏསྱ སམཱིཔཱཏ྄ པྲཱཏིཥྛནྟ; སཧསྲསེནཱཔཏིསྟཾ རོམིལོཀཾ ཝིཛྙཱཡ སྭཡཾ ཡཏ྄ ཏསྱ བནྡྷནམ྄ ཨཀཱརྵཱིཏ྄ ཏཏྐཱརཎཱད྄ ཨབིབྷེཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ཡིཧཱུདཱིཡལོཀཱཿ པཽལཾ ཀུཏོ྅པཝདནྟེ ཏསྱ ཝྲྀཏྟཱནྟཾ ཛྙཱཏུཾ ཝཱཉྪན྄ སཧསྲསེནཱཔཏིཿ པརེ྅ཧནི པཽལཾ བནྡྷནཱཏ྄ མོཙཡིཏྭཱ པྲདྷཱནཡཱཛཀཱན྄ མཧཱསབྷཱཡཱཿ སཪྻྭལོཀཱཤྩ སམུཔསྠཱཏུམ྄ ཨཱདིཤྱ ཏེཥཱཾ སནྣིདྷཽ པཽལམ྄ ཨཝརོཧྱ སྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","སབྷཱསདློཀཱན྄ པྲཏི པཽལོ྅ནནྱདྲྀཥྚྱཱ པཤྱན྄ ཨཀཐཡཏ྄, ཧེ བྷྲཱཏྲྀགཎཱ ཨདྱ ཡཱཝཏ྄ སརལེན སཪྻྭཱནྟཿཀརཎེནེཤྭརསྱ སཱཀྵཱད྄ ཨཱཙརཱམི། ");
INSERT INTO santib_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ཨནེན ཧནཱནཱིཡནཱམཱ མཧཱཡཱཛཀསྟཾ ཀཔོལེ ཙཔེཊེནཱཧནྟུཾ སམཱིཔསྠལོཀཱན྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ཏདཱ པཽལསྟམཝདཏ྄, ཧེ བཧིཥྤརིཥྐྲྀཏ, ཨཱིཤྭརསྟྭཱཾ པྲཧརྟྟུམ྄ ཨུདྱཏོསྟི, ཡཏོ ཝྱཝསྠཱནུསཱརེཎ ཝིཙཱརཡིཏུམ྄ ཨུཔཝིཤྱ ཝྱཝསྠཱཾ ལངྒྷིཏྭཱ མཱཾ པྲཧརྟྟུམ྄ ཨཱཛྙཱཔཡསི། ");
INSERT INTO santib_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ཏཏོ ནིཀཊསྠཱ ལོཀཱ ཨཀཐཡན྄, ཏྭཾ ཀིམ྄ ཨཱིཤྭརསྱ མཧཱཡཱཛཀཾ ནིནྡསི? ");
INSERT INTO santib_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ཏཏཿ པཽལཿ པྲཏིབྷཱཥིཏཝཱན྄ ཧེ བྷྲཱཏྲྀགཎ མཧཱཡཱཛཀ ཨེཥ ཨིཏི ན བུདྡྷཾ མཡཱ ཏདནྱཙྩ སྭལོཀཱནཱམ྄ ཨདྷིཔཏིཾ པྲཏི དུཪྻྭཱཀྱཾ མཱ ཀཐཡ, ཨེཏཱདྲྀཤཱི ལིཔིརསྟི། ");
INSERT INTO santib_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ཨནནྟརཾ པཽལསྟེཥཱམ྄ ཨརྡྡྷཾ སིདཱུཀིལོཀཱ ཨརྡྡྷཾ ཕིརཱུཤིལོཀཱ ཨིཏི དྲྀཥྚྭཱ པྲོཙྩཻཿ སབྷཱསྠལོཀཱན྄ ཨཝདཏ྄ ཧེ བྷྲཱཏྲྀགཎ ཨཧཾ ཕིརཱུཤིམཏཱཝལམྦཱི ཕིརཱུཤིནཿ སཏྣཱནཤྩ, མྲྀཏལོཀཱནཱམ྄ ཨུཏྠཱནེ པྲཏྱཱཤཱཀརཎཱད྄ ཨཧམཔཝཱདིཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ཨིཏི ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ ཕིརཱུཤིསིདཱུཀིནོཿ པརསྤརཾ བྷིནྣཝཱཀྱཏྭཱཏ྄ སབྷཱཡཱ མདྷྱེ དྭཽ སཾགྷཽ ཛཱཏཽ། ");
INSERT INTO santib_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ཡཏཿ སིདཱུཀིལོཀཱ ཨུཏྠཱནཾ སྭརྒཱིཡདཱུཏཱ ཨཱཏྨཱནཤྩ སཪྻྭེཥཱམ྄ ཨེཏེཥཱཾ ཀམཔི ན མནྱནྟེ, ཀིནྟུ ཕིརཱུཤིནཿ སཪྻྭམ྄ ཨངྒཱིཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ཏཏཿ པརསྤརམ྄ ཨཏིཤཡཀོལཱཧལེ སམུཔསྠིཏེ ཕིརཱུཤིནཱཾ པཀྵཱིཡཱཿ སབྷཱསྠཱ ཨདྷྱཱཔཀཱཿ པྲཏིཔཀྵཱ ཨུཏྟིཥྛནྟོ ྅ཀཐཡན྄, ཨེཏསྱ མཱནཝསྱ ཀམཔི དོཥཾ ན པཤྱཱམཿ; ཡདི ཀཤྩིད྄ ཨཱཏྨཱ ཝཱ ཀཤྩིད྄ དཱུཏ ཨེནཾ པྲཏྱཱདིཤཏ྄ ཏརྷི ཝཡམ྄ ཨཱིཤྭརསྱ པྲཱཏིཀཱུལྱེན ན ཡོཏྶྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ཏསྨཱད྄ ཨཏཱིཝ བྷིནྣཝཱཀྱཏྭེ སཏི ཏེ པཽལཾ ཁཎྜཾ ཁཎྜཾ ཀརིཥྱནྟཱིཏྱཱཤངྐཡཱ སཧསྲསེནཱཔཏིཿ སེནཱགཎཾ ཏཏྶྠཱནཾ ཡཱཏུཾ སབྷཱཏོ བལཱཏ྄ པཽལཾ དྷྲྀཏྭཱ དུརྒཾ ནེཏཉྩཱཛྙཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","རཱཏྲོ པྲབྷུསྟསྱ སམཱིཔེ ཏིཥྛན྄ ཀཐིཏཝཱན྄ ཧེ པཽལ ནིརྦྷཡོ བྷཝ ཡཐཱ ཡིརཱུཤཱལམྣགརེ མཡི སཱཀྵྱཾ དཏྟཝཱན྄ ཏཐཱ རོམཱནགརེཔི ཏྭཡཱ དཱཏཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","དིནེ སམུཔསྠིཏེ སཏི ཀིཡནྟོ ཡིཧཱུདཱིཡལོཀཱ ཨེཀམནྟྲཎཱཿ སནྟཿ པཽལཾ ན ཧཏྭཱ བྷོཛནཔཱནེ ཀརིཥྱཱམ ཨིཏི ཤཔཐེན སྭཱན྄ ཨབདྷྣན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ཙཏྭཱརིཾཤཛྫནེབྷྱོ྅དྷིཀཱ ལོཀཱ ཨིཏི པཎམ྄ ཨཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ཏེ མཧཱཡཱཛཀཱནཱཾ པྲཱཙཱིནལོཀཱནཱཉྩ སམཱིཔཾ གཏྭཱ ཀཐཡན྄, ཝཡཾ པཽལཾ ན ཧཏྭཱ ཀིམཔི ན བྷོཀྵྱཱམཧེ དྲྀཌྷེནཱནེན ཤཔཐེན བདྡྷྭཱ ཨབྷཝཱམ། ");
INSERT INTO santib_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ཨཏཨེཝ སཱམྤྲཏཾ སབྷཱསདློཀཻཿ སཧ ཝཡཾ ཏསྨིན྄ ཀཉྩིད྄ ཝིཤེཥཝིཙཱརཾ ཀརིཥྱཱམསྟདརྠཾ བྷཝཱན྄ ཤྭོ ྅སྨཱཀཾ སམཱིཔཾ ཏམ྄ ཨཱནཡཏྭིཏི སཧསྲསེནཱཔཏཡེ ནིཝེདནཾ ཀུརུཏ ཏེན ཡུཥྨཱཀཾ སམཱིཔཾ ཨུཔསྠིཏེཿ པཱུཪྻྭཾ ཝཡཾ ཏཾ ཧནྟུ སཛྫིཥྱཱམ། ");
INSERT INTO santib_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ཏདཱ པཽལསྱ བྷཱགིནེཡསྟེཥཱམིཏི མནྟྲཎཱཾ ཝིཛྙཱཡ དུརྒཾ གཏྭཱ ཏཱཾ ཝཱརྟྟཱཾ པཽལམ྄ ཨུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ཏསྨཱཏ྄ པཽལ ཨེཀཾ ཤཏསེནཱཔཏིམ྄ ཨཱཧཱུཡ ཝཱཀྱམིདམ྄ བྷཱཥིཏཝཱན྄ སཧསྲསེནཱཔཏེཿ སམཱིཔེ྅སྱ ཡུཝམནུཥྱསྱ ཀིཉྩིནྣིཝེདནམ྄ ཨཱསྟེ, ཏསྨཱཏ྄ ཏཏྶཝིདྷམ྄ ཨེནཾ ནཡ། ");
INSERT INTO santib_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ཏཏཿ ས ཏམཱདཱཡ སཧསྲསེནཱཔཏེཿ སམཱིཔམ྄ ཨུཔསྠཱཡ ཀཐིཏཝཱན྄, བྷཝཏཿ སམཱིཔེ྅སྱ ཀིམཔི ནིཝེདནམཱསྟེ ཏསྨཱཏ྄ བནྡིཿ པཽལོ མཱམཱཧཱུཡ བྷཝཏཿ སམཱིཔམ྄ ཨེནམ྄ ཨཱནེཏུཾ པྲཱརྠིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ཏདཱ སཧསྲསེནཱཔཏིསྟསྱ ཧསྟཾ དྷྲྀཏྭཱ ནིརྫནསྠཱནཾ ནཱིཏྭཱ པྲྀཥྛཝཱན྄ ཏཝ ཀིཾ ནིཝེདནཾ? ཏཏ྄ ཀཐཡ། ");
INSERT INTO santib_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ཏཏཿ སོཀཐཡཏ྄, ཡིཧཱུདཱིཡལཱཀཱཿ པཽལེ ཀམཔི ཝིཤེཥཝིཙཱརཾ ཚལཾ ཀྲྀཏྭཱ ཏཾ སབྷཱཾ ནེཏུཾ བྷཝཏཿ སམཱིཔེ ནིཝེདཡིཏུཾ ཨམནྟྲཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ཀིནྟུ མཝཏཱ ཏནྣ སྭཱིཀརྟྟཝྱཾ ཡཏསྟེཥཱཾ མདྷྱེཝརྟྟིནཤྩཏྭཱརིཾཤཛྫནེབྷྱོ ྅དྷིཀལོཀཱ ཨེཀམནྟྲཎཱ བྷཱུཏྭཱ པཽལཾ ན ཧཏྭཱ བྷོཛནཾ པཱནཉྩ ན ཀརིཥྱཱམ ཨིཏི ཤཔཐེན བདྡྷཱཿ སནྟོ གྷཱཏཀཱ ཨིཝ སཛྫིཏཱ ཨིདཱནཱིཾ ཀེཝལཾ བྷཝཏོ ྅ནུམཏིམ྄ ཨཔེཀྵནྟེ། ");
INSERT INTO santib_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ཡཱམིམཱཾ ཀཐཱཾ ཏྭཾ ནིཝེདིཏཝཱན྄ ཏཱཾ ཀསྨཻཙིདཔི མཱ ཀཐཡེཏྱུཀྟྭཱ སཧསྲསེནཱཔཏིསྟཾ ཡུཝཱནཾ ཝིསྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ཨནནྟརཾ སཧསྲསེནཱཔཏི རྡྭཽ ཤཏསེནཱཔཏཱི ཨཱཧཱུཡེདམ྄ ཨཱདིཤཏ྄, ཡུཝཱཾ རཱཏྲཽ པྲཧརཻཀཱཝཤིཥྚཱཡཱཾ སཏྱཱཾ ཀཻསརིཡཱནགརཾ ཡཱཏུཾ པདཱཏིསཻནྱཱནཱཾ དྭེ ཤཏེ གྷོཊཀཱརོཧིསཻནྱཱནཱཾ སཔྟཏིཾ ཤཀྟིདྷཱརིསཻནྱཱནཱཾ དྭེ ཤཏེ ཙ ཛནཱན྄ སཛྫིཏཱན྄ ཀུརུཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","པཽལམ྄ ཨཱརོཧཡིཏུཾ ཕཱིལིཀྵཱདྷིཔཏེཿ སམཱིཔཾ ནིཪྻྭིགྷྣཾ ནེཏུཉྩ ཝཱཧནཱནི སམུཔསྠཱཔཡཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ཨཔརཾ ས པཏྲཾ ལིཁིཏྭཱ དཏྟཝཱན྄ ཏལླིཁིཏམེཏཏ྄, ");
INSERT INTO santib_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","མཧཱམཧིམཤྲཱིཡུཀྟཕཱིལིཀྵཱདྷིཔཏཡེ ཀླཽདིཡལུཥིཡསྱ ནམསྐཱརཿ། ");
INSERT INTO santib_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ཡིཧཱུདཱིཡལོཀཱཿ པཱུཪྻྭམ྄ ཨེནཾ མཱནཝཾ དྷྲྀཏྭཱ སྭཧསྟཻ རྷནྟུམ྄ ཨུདྱཏཱ ཨེཏསྨིནྣནྟརེ སསཻནྱོཧཾ ཏཏྲོཔསྠཱཡ ཨེཥ ཛནོ རོམཱིཡ ཨིཏི ཝིཛྙཱཡ ཏཾ རཀྵིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ཀིནྣིམིཏྟཾ ཏེ ཏམཔཝདནྟེ ཏཛྫྙཱཏུཾ ཏེཥཱ སབྷཱཾ ཏམཱནཱཡིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ཏཏསྟེཥཱཾ ཝྱཝསྠཱཡཱ ཝིརུདྡྷཡཱ ཀཡཱཙན ཀཐཡཱ སོ྅པཝཱདིཏོ྅བྷཝཏ྄, ཀིནྟུ ས ཤྲྀངྑལབནྡྷནཱརྷོ ཝཱ པྲཱཎནཱཤཱརྷོ བྷཝཏཱིདྲྀཤཿ ཀོཔྱཔརཱདྷོ མཡཱསྱ ན དྲྀཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ཏཐཱཔི མནུཥྱསྱཱསྱ ཝདྷཱརྠཾ ཡིཧཱུདཱིཡཱ གྷཱཏཀཱཨིཝ སཛྫིཏཱ ཨེཏཱཾ ཝཱརྟྟཱཾ ཤྲུཏྭཱ ཏཏྐྵཎཱཏ྄ ཏཝ སམཱིཔམེནཾ པྲེཥིཏཝཱན྄ ཨསྱཱཔཝཱདཀཱཾཤྩ ཏཝ སམཱིཔཾ གཏྭཱཔཝདིཏུམ྄ ཨཱཛྙཱཔཡམ྄། བྷཝཏཿ ཀུཤལཾ བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","སཻནྱགཎ ཨཱཛྙཱནུསཱརེཎ པཽལཾ གྲྀཧཱིཏྭཱ ཏསྱཱཾ རཛནྱཱམ྄ ཨཱནྟིཔཱཏྲིནགརམ྄ ཨཱནཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","པརེ྅ཧནི ཏེན སཧ ཡཱཏུཾ གྷོཊཀཱརཱུཌྷསཻནྱགཎཾ སྠཱཔཡིཏྭཱ པརཱཝྲྀཏྱ དུརྒཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ཏཏཿ པརེ གྷོཊཀཱརོཧིསཻནྱགཎཿ ཀཻསརིཡཱནགརམ྄ ཨུཔསྠཱཡ ཏཏྤཏྲམ྄ ཨདྷིཔཏེཿ ཀརེ སམརྤྱ ཏསྱ སམཱིཔེ པཽལམ྄ ཨུཔསྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ཏདཱདྷིཔཏིསྟཏྤཏྲཾ པཋིཏྭཱ པྲྀཥྛཝཱན྄ ཨེཥ ཀིམྤྲདེཤཱིཡོ ཛནཿ? ས ཀིལིཀིཡཱཔྲདེཤཱིཡ ཨེཀོ ཛན ཨིཏི ཛྙཱཏྭཱ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ཏཝཱཔཝཱདཀགཎ ཨཱགཏེ ཏཝ ཀཐཱཾ ཤྲོཥྱཱམི། ཧེརོདྲཱཛགྲྀཧེ ཏཾ སྠཱཔཡིཏུམ྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","པཉྩབྷྱོ དིནེབྷྱཿ པརཾ ཧནཱནཱིཡནཱམཱ མཧཱཡཱཛཀོ྅དྷིཔཏེཿ སམཀྵཾ པཽལསྱ པྲཱཏིཀཱུལྱེན ནིཝེདཡིཏུཾ ཏརྟུལླནཱམཱནཾ ཀཉྩན ཝཀྟཱརཾ པྲཱཙཱིནཛནཱཾཤྩ སངྒིནཿ ཀྲྀཏྭཱ ཀཻསརིཡཱནགརམ྄ ཨཱགཙྪཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ཏཏཿ པཽལེ སམཱནཱིཏེ སཏི ཏརྟུལླསྟསྱཱཔཝཱདཀཐཱཾ ཀཐཡིཏུམ྄ ཨཱརབྷཏ ཧེ མཧཱམཧིམཕཱིལིཀྵ བྷཝཏོ ཝཡམ྄ ཨཏིནིཪྻྭིགྷྣཾ ཀཱལཾ ཡཱཔཡཱམོ བྷཝཏཿ པརིཎཱམདརྴིཏཡཱ ཨེཏདྡེཤཱིཡཱནཱཾ བཧཱུནི མངྒལཱནི གྷཊིཏཱནི, ");
INSERT INTO santib_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ཨིཏི ཧེཏོ ཪྻཡམཏིཀྲྀཏཛྙཱཿ སནྟཿ སཪྻྭཏྲ སཪྻྭདཱ བྷཝཏོ གུཎཱན྄ གཱཡམཿ། ");
INSERT INTO santib_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ཀིནྟུ བཧུབྷིཿ ཀཐཱབྷི རྦྷཝནྟཾ ཡེན ན ཝིརཉྫཡཱམི ཏསྨཱད྄ ཝིནཡེ བྷཝཱན྄ བནུཀམྤྱ མདལྤཀཐཱཾ ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ཨེཥ མཧཱམཱརཱིསྭརཱུཔོ ནཱསརཏཱིཡམཏགྲཱཧིསཾགྷཱཏསྱ མུཁྱོ བྷཱུཏྭཱ སཪྻྭདེཤེཥུ སཪྻྭེཥཱཾ ཡིཧཱུདཱིཡཱནཱཾ རཱཛདྲོཧཱཙརཎཔྲཝྲྀཏྟིཾ ཛནཡཏཱིཏྱསྨཱབྷི རྣིཤྩིཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ས མནྡིརམཔི ཨཤུཙི ཀརྟྟུཾ ཙེཥྚིཏཝཱན྄; ཨིཏི ཀཱརཎཱད྄ ཝཡམ྄ ཨེནཾ དྷྲྀཏྭཱ སྭཝྱཝསྠཱནུསཱརེཎ ཝིཙཱརཡིཏུཾ པྲཱཝརྟྟཱམཧི; ");
INSERT INTO santib_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ཀིནྟུ ལུཥིཡཿ སཧསྲསེནཱཔཏིརཱགཏྱ བལཱད྄ ཨསྨཱཀཾ ཀརེབྷྱ ཨེནཾ གྲྀཧཱིཏྭཱ ");
INSERT INTO santib_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ཨེཏསྱཱཔཝཱདཀཱན྄ བྷཝཏཿ སམཱིཔམ྄ ཨཱགནྟུམ྄ ཨཱཛྙཱཔཡཏ྄། ཝཡཾ ཡསྨིན྄ ཏམཔཝཱདཱམོ བྷཝཏཱ པདཔཝཱདཀཐཱཡཱཾ ཝིཙཱརིཏཱཡཱཾ སཏྱཱཾ སཪྻྭཾ ཝྲྀཏྟཱནྟཾ ཝེདིཏུཾ ཤཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ཏཏོ ཡིཧཱུདཱིཡཱ ཨཔི སྭཱིཀྲྀཏྱ ཀཐིཏཝནྟ ཨེཥཱ ཀཐཱ པྲམཱཎམ྄། ");
INSERT INTO santib_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ཨདྷིཔཏཽ ཀཐཱཾ ཀཐཡིཏུཾ པཽལཾ པྲཏཱིངྒིཏཾ ཀྲྀཏཝཏི ས ཀཐིཏཝཱན྄ བྷཝཱན྄ བཧཱུན྄ ཝཏྶརཱན྄ ཡཱཝད྄ ཨེཏདྡེཤསྱ ཤཱསནཾ ཀརོཏཱིཏི ཝིཛྙཱཡ པྲཏྱུཏྟརཾ དཱཏུམ྄ ཨཀྵོབྷོ྅བྷཝམ྄། ");
INSERT INTO santib_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ཨདྱ ཀེཝལཾ དྭཱདཤ དིནཱནི ཡཱཏཱནི, ཨཧམ྄ ཨཱརཱདྷནཱཾ ཀརྟྟུཾ ཡིརཱུཤཱལམནགརཾ གཏཝཱན྄ ཨེཥཱ ཀཐཱ བྷཝཏཱ ཛྙཱཏུཾ ཤཀྱཏེ; ");
INSERT INTO santib_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ཀིནྟྭིབྷེ མཱཾ མདྷྱེམནྡིརཾ ཀེནཱཔི སཧ ཝིཏཎྜཱཾ ཀུཪྻྭནྟཾ ཀུཏྲཱཔི བྷཛནབྷཝནེ ནགརེ ཝཱ ལོཀཱན྄ ཀུཔྲཝྲྀཏྟིཾ ཛནཡནྟུཾ ན དྲྀཥྚཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ཨིདཱནཱིཾ ཡསྨིན྄ ཡསྨིན྄ མཱམ྄ ཨཔཝདནྟེ ཏསྱ ཀིམཔི པྲམཱཎཾ དཱཏུཾ ན ཤཀྣུཝནྟི། ");
INSERT INTO santib_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ཀིནྟུ བྷཝིཥྱདྭཱཀྱགྲནྠེ ཝྱཝསྠཱགྲནྠེ ཙ ཡཱ ཡཱ ཀཐཱ ལིཁིཏཱསྟེ ཏཱསུ སཪྻྭཱསུ ཝིཤྭསྱ ཡནྨཏམ྄ ཨིམེ ཝིདྷརྨྨཾ ཛཱནནྟི ཏནྨཏཱནུསཱརེཎཱཧཾ ནིཛཔིཏྲྀཔུརུཥཱཎཱམ྄ ཨཱིཤྭརམ྄ ཨཱརཱདྷཡཱམཱིཏྱཧཾ བྷཝཏཿ སམཀྵམ྄ ཨངྒཱིཀརོམི། ");
INSERT INTO santib_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","དྷཱརྨྨིཀཱཎཱམ྄ ཨདྷཱརྨྨིཀཱཎཱཉྩ པྲམཱིཏལོཀཱནཱམེཝོཏྠཱནཾ བྷཝིཥྱཏཱིཏི ཀཐཱམིམེ སྭཱིཀུཪྻྭནྟི ཏཐཱཧམཔི ཏསྨིན྄ ཨཱིཤྭརེ པྲཏྱཱཤཱཾ ཀརོམི; ");
INSERT INTO santib_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ཨཱིཤྭརསྱ མཱནཝཱནཱཉྩ སམཱིཔེ ཡཐཱ ནིརྡོཥོ བྷཝཱམི ཏདརྠཾ སཏཏཾ ཡཏྣཝཱན྄ ཨསྨི། ");
INSERT INTO santib_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","བཧུཥུ ཝཏྶརེཥུ གཏེཥུ སྭདེཤཱིཡལོཀཱནཱཾ ནིམིཏྟཾ དཱནཱིཡདྲཝྱཱཎི ནཻཝེདྱཱནི ཙ སམཱདཱཡ པུནརཱགམནཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ཏཏོཧཾ ཤུཙི རྦྷཱུཏྭཱ ལོཀཱནཱཾ སམཱགམཾ ཀལཧཾ ཝཱ ན ཀཱརིཏཝཱན྄ ཏཐཱཔྱཱཤིཡཱདེཤཱིཡཱཿ ཀིཡནྟོ ཡིཧུདཱིཡལོཀཱ མདྷྱེམནྡིརཾ མཱཾ དྷྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","མམོཔརི ཡདི ཀཱཙིདཔཝཱདཀཐཱསྟི ཏརྷི བྷཝཏཿ སམཱིཔམ྄ ཨུཔསྠཱཡ ཏེཥཱམེཝ སཱཀྵྱདཱནམ྄ ཨུཙིཏམ྄། ");
INSERT INTO santib_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ནོཙེཏ྄ པཱུཪྻྭེ མཧཱསབྷཱསྠཱནཱཾ ལོཀཱནཱཾ སནྣིདྷཽ མམ དཎྜཱཡམཱནཏྭསམཡེ, ཨཧམདྱ མྲྀཏཱནཱམུཏྠཱནེ ཡུཥྨཱབྷི ཪྻིཙཱརིཏོསྨི, ");
INSERT INTO santib_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ཏེཥཱཾ མདྷྱེ ཏིཥྛནྣཧཾ ཡཱམིམཱཾ ཀཐཱམུཙྩཻཿ སྭརེཎ ཀཐིཏཝཱན྄ ཏདནྱོ མམ ཀོཔི དོཥོ྅ལབྷྱཏ ན ཝེཏི ཝརམ྄ ཨེཏེ སམུཔསྠིཏལོཀཱ ཝདནྟུ། ");
INSERT INTO santib_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ཏདཱ ཕཱིལིཀྵ ཨེཏཱཾ ཀཐཱཾ ཤྲུཏྭཱ ཏནྨཏསྱ ཝིཤེཥཝྲྀཏྟཱནྟཾ ཝིཛྙཱཏུཾ ཝིཙཱརཾ སྠགིཏཾ ཀྲྀཏྭཱ ཀཐིཏཝཱན྄ ལུཥིཡེ སཧསྲསེནཱཔཏཽ སམཱཡཱཏེ སཏི ཡུཥྨཱཀཾ ཝིཙཱརམ྄ ཨཧཾ ནིཥྤཱདཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ཨནནྟརཾ བནྡྷནཾ ཝིནཱ པཽལཾ རཀྵིཏུཾ ཏསྱ སེཝནཱཡ སཱཀྵཱཏྐརཎཱཡ ཝཱ ཏདཱིཡཱཏྨཱིཡབནྡྷུཛནཱན྄ ན ཝཱརཡིཏུཉྩ ཤམསེནཱཔཏིམ྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ཨལྤདིནཱཏ྄ པརཾ ཕཱིལིཀྵོ྅དྷིཔཏི རྡྲུཥིལླཱནཱམྣཱ ཡིཧཱུདཱིཡཡཱ སྭབྷཱཪྻྱཡཱ སཧཱགཏྱ པཽལམཱཧཱུཡ ཏསྱ མུཁཱཏ྄ ཁྲཱིཥྚདྷརྨྨསྱ ཝྲྀཏྟཱནྟམ྄ ཨཤྲཽཥཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","པཽལེན ནྱཱཡསྱ པརིམིཏབྷོགསྱ ཙརམཝིཙཱརསྱ ཙ ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ སཏྱཱཾ ཕཱིལིཀྵཿ ཀམྤམཱནཿ སན྄ ཝྱཱཧརད྄ ཨིདཱནཱིཾ ཡཱཧི, ཨཧམ྄ ཨཝཀཱཤཾ པྲཱཔྱ ཏྭཱམ྄ ཨཱཧཱུསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","མུཀྟིཔྲཔྟྱརྠཾ པཽལེན མཧྱཾ མུདྲཱདཱསྱནྟེ ཨིཏི པཏྱཱཤཱཾ ཀྲྀཏྭཱ ས པུནཿ པུནསྟམཱཧཱུཡ ཏེན སཱཀཾ ཀཐོཔཀཐནཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ཀིནྟུ ཝཏྶརདྭཡཱཏ྄ པརཾ པརྐིཡཕཱིཥྚ ཕཱལིཀྵསྱ པདཾ པྲཱཔྟེ སཏི ཕཱིལིཀྵོ ཡིཧཱུདཱིཡཱན྄ སནྟུཥྚཱན྄ ཙིཀཱིརྵན྄ པཽལཾ བདྡྷཾ སཾསྠཱཔྱ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ཨནནྟརཾ ཕཱིཥྚོ ནིཛརཱཛྱམ྄ ཨཱགཏྱ དིནཏྲཡཱཏ྄ པརཾ ཀཻསརིཡཱཏོ ཡིརཱུཤཱལམྣགརམ྄ ཨཱགམཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ཏདཱ མཧཱཡཱཛཀོ ཡིཧཱུདཱིཡཱནཱཾ པྲདྷཱནལོཀཱཤྩ ཏསྱ སམཀྵཾ པཽལམ྄ ཨཔཱཝདནྟ། ");
INSERT INTO santib_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","བྷཝཱན྄ ཏཾ ཡིརཱུཤཱལམམ྄ ཨཱནེཏུམ྄ ཨཱཛྙཱཔཡཏྭིཏི ཝིནཱིཡ ཏེ ཏསྨཱད྄ ཨནུགྲཧཾ ཝཱཉྪིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ཡཏཿ པཐིམདྷྱེ གོཔནེན པཽལཾ ཧནྟུཾ ཏཻ རྒྷཱཏཀཱ ནིཡུཀྟཱཿ། ཕཱིཥྚ ཨུཏྟརཾ དཏྟཝཱན྄ པཽལཿ ཀཻསརིཡཱཡཱཾ སྠཱསྱཏི པུནརལྤདིནཱཏ྄ པརམ྄ ཨཧཾ ཏཏྲ ཡཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ཏཏསྟསྱ མཱནུཥསྱ ཡདི ཀཤྩིད྄ ཨཔརཱདྷསྟིཥྛཏི ཏརྷི ཡུཥྨཱཀཾ ཡེ ཤཀྣུཝནྟི ཏེ མཡཱ སཧ ཏཏྲ གཏྭཱ ཏམཔཝདནྟུ ས ཨེཏཱཾ ཀཐཱཾ ཀཐིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","དཤདིཝསེབྷྱོ྅དྷིཀཾ ཝིལམྦྱ ཕཱིཥྚསྟསྨཱཏ྄ ཀཻསརིཡཱནགརཾ གཏྭཱ པརསྨིན྄ དིཝསེ ཝིཙཱརཱསན ཨུཔདིཤྱ པཽལམ྄ ཨཱནེཏུམ྄ ཨཱཛྙཱཔཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","པཽལེ སམུཔསྠིཏེ སཏི ཡིརཱུཤཱལམྣགརཱད྄ ཨཱགཏཱ ཡིཧཱུདཱིཡལོཀཱསྟཾ ཙཏུརྡིཤི སཾཝེཥྚྱ ཏསྱ ཝིརུདྡྷཾ བཧཱུན྄ མཧཱདོཥཱན྄ ཨུཏྠཱཔིཏཝནྟཿ ཀིནྟུ ཏེཥཱཾ ཀིམཔི པྲམཱཎཾ དཱཏུཾ ན ཤཀྣུཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ཏཏཿ པཽལཿ སྭསྨིན྄ ཨུཏྟརམིདམ྄ ཨུདིཏཝཱན྄, ཡིཧཱུདཱིཡཱནཱཾ ཝྱཝསྠཱཡཱ མནྡིརསྱ ཀཻསརསྱ ཝཱ པྲཏིཀཱུལཾ ཀིམཔི ཀརྨྨ ནཱཧཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ཀིནྟུ ཕཱིཥྚོ ཡིཧཱུདཱིཡཱན྄ སནྟུཥྚཱན྄ ཀརྟྟུམ྄ ཨབྷིལཥན྄ པཽལམ྄ ཨབྷཱཥཏ ཏྭཾ ཀིཾ ཡིརཱུཤཱལམཾ གཏྭཱསྨིན྄ ཨབྷིཡོགེ མམ སཱཀྵཱད྄ ཝིཙཱརིཏོ བྷཝིཥྱསི? ");
INSERT INTO santib_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ཏཏཿ པཽལ ཨུཏྟརཾ པྲོཀྟཝཱན྄, ཡཏྲ མམ ཝིཙཱརོ བྷཝིཏུཾ ཡོགྱཿ ཀཻསརསྱ ཏཏྲ ཝིཙཱརཱསན ཨེཝ སམུཔསྠིཏོསྨི; ཨཧཾ ཡིཧཱུདཱིཡཱནཱཾ ཀཱམཔི ཧཱནིཾ ནཱཀཱརྵམ྄ ཨིཏི བྷཝཱན྄ ཡཐཱརྠཏོ ཝིཛཱནཱཏི། ");
INSERT INTO santib_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ཀཉྩིདཔརཱདྷཾ ཀིཉྩན ཝདྷཱརྷཾ ཀརྨྨ ཝཱ ཡདྱཧམ྄ ཨཀརིཥྱཾ ཏརྷི པྲཱཎཧནནདཎྜམཔི བྷོཀྟུམ྄ ཨུདྱཏོ྅བྷཝིཥྱཾ, ཀིནྟུ ཏེ མམ སམཔཝཱདཾ ཀུཪྻྭནྟི ས ཡདི ཀལྤིཏམཱཏྲོ བྷཝཏི ཏརྷི ཏེཥཱཾ ཀརེཥུ མཱཾ སམརྤཡིཏུཾ ཀསྱཱཔྱདྷིཀཱརོ ནཱསྟི, ཀཻསརསྱ ནིཀཊེ མམ ཝིཙཱརོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ཏདཱ ཕཱིཥྚོ མནྟྲིབྷིཿ སཱརྡྡྷཾ སཾམནྟྲྱ པཽལཱཡ ཀཐིཏཝཱན྄, ཀཻསརསྱ ནིཀཊེ ཀིཾ ཏཝ ཝིཙཱརོ བྷཝིཥྱཏི? ཀཻསརསྱ སམཱིཔཾ གམིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ཀིཡདྡིནེབྷྱཿ པརམ྄ ཨཱགྲིཔྤརཱཛཱ བརྞཱིཀཱི ཙ ཕཱིཥྚཾ སཱཀྵཱཏ྄ ཀརྟྟུཾ ཀཻསརིཡཱནགརམ྄ ཨཱགཏཝནྟཽ། ");
INSERT INTO santib_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ཏདཱ ཏཽ བཧུདིནཱནི ཏཏྲ སྠིཏཽ ཏཏཿ ཕཱིཥྚསྟཾ རཱཛཱནཾ པཽལསྱ ཀཐཱཾ ཝིཛྙཱཔྱ ཀཐཡིཏུམ྄ ཨཱརབྷཏ པཽལནཱམཱནམ྄ ཨེཀཾ བནྡི ཕཱིལིཀྵོ བདྡྷཾ སཾསྠཱཔྱ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ཡིརཱུཤཱལམི མམ སྠིཏིཀཱལེ མཧཱཡཱཛཀོ ཡིཧཱུདཱིཡཱནཱཾ པྲཱཙཱིནལོཀཱཤྩ ཏམ྄ ཨཔོདྱ ཏམྤྲཏི དཎྜཱཛྙཱཾ པྲཱརྠཡནྟ། ");
INSERT INTO santib_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ཏཏོཧམ྄ ཨིཏྱུཏྟརམ྄ ཨཝདཾ ཡཱཝད྄ ཨཔོདིཏོ ཛནཿ སྭཱཔཝཱདཀཱན྄ སཱཀྵཱཏ྄ ཀྲྀཏྭཱ སྭསྨིན྄ ཡོ྅པརཱདྷ ཨཱརོཔིཏསྟསྱ པྲཏྱུཏྟརཾ དཱཏུཾ སུཡོགཾ ན པྲཱཔྣོཏི, ཏཱཝཏྐཱལཾ ཀསྱཱཔི མཱནུཥསྱ པྲཱཎནཱཤཱཛྙཱཔནཾ རོམིལོཀཱནཱཾ རཱིཏི རྣཧི། ");
INSERT INTO santib_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ཏཏསྟེཥྭཏྲཱགཏེཥུ པརསྨིན྄ དིཝསེ྅ཧམ྄ ཨཝིལམྦཾ ཝིཙཱརཱསན ཨུཔཝིཤྱ ཏཾ མཱནུཥམ྄ ཨཱནེཏུམ྄ ཨཱཛྙཱཔཡམ྄། ");
INSERT INTO santib_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ཏདནནྟརཾ ཏསྱཱཔཝཱདཀཱ ཨུཔསྠཱཡ ཡཱདྲྀཤམ྄ ཨཧཾ ཙིནྟིཏཝཱན྄ ཏཱདྲྀཤཾ ཀཉྩན མཧཱཔཝཱདཾ ནོཏྠཱཔྱ ");
INSERT INTO santib_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","སྭེཥཱཾ མཏེ ཏཐཱ པཽལོ ཡཾ སཛཱིཝཾ ཝདཏི ཏསྨིན྄ ཡཱིཤུནཱམནི མྲྀཏཛནེ ཙ ཏསྱ ཝིརུདྡྷཾ ཀཐིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ཏཏོཧཾ ཏཱདྲྀགྭིཙཱརེ སཾཤཡཱནཿ སན྄ ཀཐིཏཝཱན྄ ཏྭཾ ཡིརཱུཤཱལམཾ གཏྭཱ ཀིཾ ཏཏྲ ཝིཙཱརིཏོ བྷཝིཏུམ྄ ཨིཙྪསི? ");
INSERT INTO santib_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ཏདཱ པཽལོ མཧཱརཱཛསྱ ནིཀཊེ ཝིཙཱརིཏོ བྷཝིཏུཾ པྲཱརྠཡཏ, ཏསྨཱད྄ ཡཱཝཏྐཱལཾ ཏཾ ཀཻསརསྱ སམཱིཔཾ པྲེཥཡིཏུཾ ན ཤཀྣོམི ཏཱཝཏྐཱལཾ ཏམཏྲ སྠཱཔཡིཏུམ྄ ཨཱདིཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ཏཏ ཨཱགྲིཔྤཿ ཕཱིཥྚམ྄ ཨུཀྟཝཱན྄, ཨཧམཔི ཏསྱ མཱནུཥསྱ ཀཐཱཾ ཤྲོཏུམ྄ ཨབྷིལཥཱམི། ཏདཱ ཕཱིཥྚོ ཝྱཱཧརཏ྄ ཤྭསྟདཱིཡཱཾ ཀཐཱཾ ཏྭཾ ཤྲོཥྱསི། ");
INSERT INTO santib_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","པརསྨིན྄ དིཝསེ ཨཱགྲིཔྤོ བརྞཱིཀཱི ཙ མཧཱསམཱགམཾ ཀྲྀཏྭཱ པྲདྷཱནཝཱཧིནཱིཔཏིབྷི རྣགརསྠཔྲདྷཱནལོཀཻཤྩ སཧ མིལིཏྭཱ རཱཛགྲྀཧམཱགཏྱ སམུཔསྠིཏཽ ཏདཱ ཕཱིཥྚསྱཱཛྙཡཱ པཽལ ཨཱནཱིཏོ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ཏདཱ ཕཱིཥྚཿ ཀཐིཏཝཱན྄ ཧེ རཱཛན྄ ཨཱགྲིཔྤ ཧེ ཨུཔསྠིཏཱཿ སཪྻྭེ ལོཀཱ ཡིརཱུཤཱལམྣགརེ ཡིཧཱུདཱིཡལོཀསམཱུཧོ ཡསྨིན྄ མཱནུཥེ མམ སམཱིཔེ ནིཝེདནཾ ཀྲྀཏྭཱ པྲོཙྩཻཿ ཀཐཱམིམཱཾ ཀཐིཏཝཱན྄ པུནརལྤཀཱལམཔི ཏསྱ ཛཱིཝནཾ ནོཙིཏཾ ཏམེཏཾ མཱནུཥཾ པཤྱཏ། ");
INSERT INTO santib_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ཀིནྟྭེཥ ཛནཿ པྲཱཎནཱཤརྷཾ ཀིམཔི ཀརྨྨ ན ཀྲྀཏཝཱན྄ ཨིཏྱཛཱནཱཾ ཏཐཱཔི ས མཧཱརཱཛསྱ སནྣིདྷཽ ཝིཙཱརིཏོ བྷཝིཏུཾ པྲཱརྠཡཏ ཏསྨཱཏ྄ ཏསྱ སམཱིཔཾ ཏཾ པྲེཥཡིཏུཾ མཏིམཀརཝམ྄། ");
INSERT INTO santib_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ཀིནྟུ ཤྲཱིཡུཀྟསྱ སམཱིཔམ྄ ཨེཏསྨིན྄ ཀིཾ ལེཁནཱིཡམ྄ ཨིཏྱསྱ ཀསྱཙིན྄ ནིརྞཡསྱ ན ཛཱཏཏྭཱད྄ ཨེཏསྱ ཝིཙཱརེ སཏི ཡཐཱཧཾ ལེཁིཏུཾ ཀིཉྩན ནིཤྩིཏཾ པྲཱཔྣོམི ཏདརྠཾ ཡུཥྨཱཀཾ སམཀྵཾ ཝིཤེཥཏོ ཧེ ཨཱགྲིཔྤརཱཛ བྷཝཏཿ སམཀྵམ྄ ཨེཏམ྄ ཨཱནཡེ། ");
INSERT INTO santib_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ཡཏོ བནྡིཔྲེཥཎསམཡེ ཏསྱཱབྷིཡོགསྱ ཀིཉྩིདལེཁནམ྄ ཨཧམ྄ ཨཡུཀྟཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ཏཏ ཨཱགྲིཔྤཿ པཽལམ྄ ཨཝཱདཱིཏ྄, ནིཛཱཾ ཀཐཱཾ ཀཐཡིཏུཾ ཏུབྷྱམ྄ ཨནུམཏི རྡཱིཡཏེ། ཏསྨཱཏ྄ པཽལཿ ཀརཾ པྲསཱཪྻྱ སྭསྨིན྄ ཨུཏྟརམ྄ ཨཝཱདཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ཧེ ཨཱགྲིཔྤརཱཛ ཡཏྐཱརཎཱདཧཾ ཡིཧཱུདཱིཡཻརཔཝཱདིཏོ ྅བྷཝཾ ཏསྱ ཝྲྀཏྟཱནྟམ྄ ཨདྱ བྷཝཏཿ སཱཀྵཱན྄ ནིཝེདཡིཏུམནུམཏོཧམ྄ ཨིདཾ སྭཱིཡཾ པརམཾ བྷཱགྱཾ མནྱེ; ");
INSERT INTO santib_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ཡཏོ ཡིཧཱུདཱིཡལོཀཱནཱཾ མདྷྱེ ཡཱ ཡཱ རཱིཏིཿ སཱུཀྵྨཝིཙཱརཱཤྩ སནྟི ཏེཥུ བྷཝཱན྄ ཝིཛྙཏམཿ; ཨཏཨེཝ པྲཱརྠཡེ དྷཻཪྻྱམཝལམྦྱ མམ ནིཝེདནཾ ཤྲྀཎོཏུ། ");
INSERT INTO santib_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ཨཧཾ ཡིརཱུཤཱལམྣགརེ སྭདེཤཱིཡལོཀཱནཱཾ མདྷྱེ ཏིཥྛན྄ ཨཱ ཡཽཝནཀཱལཱད྄ ཡདྲཱུཔམ྄ ཨཱཙརིཏཝཱན྄ ཏད྄ ཡིཧཱུདཱིཡལོཀཱཿ སཪྻྭེ ཝིདནྟི། ");
INSERT INTO santib_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ཨསྨཱཀཾ སཪྻྭེབྷྱཿ ཤུདྡྷཏམཾ ཡཏ྄ ཕིརཱུཤཱིཡམཏཾ ཏདཝལམྦཱི བྷཱུཏྭཱཧཾ ཀཱལཾ ཡཱཔིཏཝཱན྄ ཡེ ཛནཱ ཨཱ བཱལྱཀཱལཱན྄ མཱཾ ཛཱནཱནྟི ཏེ ཨེཏཱདྲྀཤཾ སཱཀྵྱཾ ཡདི དདཱཏི ཏརྷི དཱཏུཾ ཤཀྣུཝནྟི། ");
INSERT INTO santib_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ཀིནྟུ ཧེ ཨཱགྲིཔྤརཱཛ ཨཱིཤྭརོ྅སྨཱཀཾ པཱུཪྻྭཔུརུཥཱཎཱཾ ནིཀཊེ ཡད྄ ཨངྒཱིཀྲྀཏཝཱན྄ ཏསྱ པྲཏྱཱཤཱཧེཏོརཧམ྄ ཨིདཱནཱིཾ ཝིཙཱརསྠཱནེ དཎྜཱཡམཱནོསྨི། ");
INSERT INTO santib_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ཏསྱཱངྒཱིཀཱརསྱ ཕལཾ པྲཱཔྟུམ྄ ཨསྨཱཀཾ དྭཱདཤཝཾཤཱ དིཝཱནིཤཾ མཧཱཡཏྣཱད྄ ཨཱིཤྭརསེཝནཾ ཀྲྀཏྭཱ ཡཱཾ པྲཏྱཱཤཱཾ ཀུཪྻྭནྟི ཏསྱཱཿ པྲཏྱཱཤཱཡཱ ཧེཏོརཧཾ ཡིཧཱུདཱིཡཻརཔཝཱདིཏོ྅བྷཝམ྄། ");
INSERT INTO santib_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ཨཱིཤྭརོ མྲྀཏཱན྄ ཨུཏྠཱཔཡིཥྱཏཱིཏི ཝཱཀྱཾ ཡུཥྨཱཀཾ ནིཀཊེ྅སམྦྷཝཾ ཀུཏོ བྷཝེཏ྄? ");
INSERT INTO santib_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ནཱསརཏཱིཡཡཱིཤོ རྣཱམྣོ ཝིརུདྡྷཾ ནཱནཱཔྲཀཱརཔྲཏིཀཱུལཱཙརཎམ྄ ཨུཙིཏམ྄ ཨིཏྱཧཾ མནསི ཡཐཱརྠཾ ཝིཛྙཱཡ ");
INSERT INTO santib_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ཡིརཱུཤཱལམནགརེ ཏདཀརཝཾ ཕལཏཿ པྲདྷཱནཡཱཛཀསྱ ནིཀཊཱཏ྄ ཀྵམཏཱཾ པྲཱཔྱ བཧཱུན྄ པཝིཏྲལོཀཱན྄ ཀཱརཱཡཱཾ བདྡྷཝཱན྄ ཝིཤེཥཏསྟེཥཱཾ ཧནནསམཡེ ཏེཥཱཾ ཝིརུདྡྷཱཾ ནིཛཱཾ སམྨཏིཾ པྲཀཱཤིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ཝཱརཾ ཝཱརཾ བྷཛནབྷཝནེཥུ ཏེབྷྱོ དཎྜཾ པྲདཏྟཝཱན྄ བལཱཏ྄ ཏཾ དྷརྨྨཾ ནིནྡཡིཏཝཱཾཤྩ པུནཤྩ ཏཱན྄ པྲཏི མཧཱཀྲོདྷཱད྄ ཨུནྨཏྟཿ སན྄ ཝིདེཤཱིཡནགརཱཎི ཡཱཝཏ྄ ཏཱན྄ ཏཱཌིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ཨིཏྠཾ པྲདྷཱནཡཱཛཀསྱ སམཱིཔཱཏ྄ ཤཀྟིམ྄ ཨཱཛྙཱཔཏྲཉྩ ལབྡྷྭཱ དམྨེཥཀྣགརཾ གཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ཏདཱཧཾ ཧེ རཱཛན྄ མཱརྒམདྷྱེ མདྷྱཱཧྣཀཱལེ མམ མདཱིཡསངྒིནཱཾ ལོཀཱནཱཉྩ ཙཏསྲྀཥུ དིཀྵུ གགཎཱཏ྄ པྲཀཱཤམཱནཱཾ བྷཱསྐརཏོཔི ཏེཛསྭཏཱིཾ དཱིཔྟིཾ དྲྀཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ཏསྨཱད྄ ཨསྨཱསུ སཪྻྭེཥུ བྷཱུམཽ པཏིཏེཥུ སཏྶུ ཧེ ཤཽལ ཧཻ ཤཽལ ཀུཏོ མཱཾ ཏཱཌཡསི? ཀཎྚཀཱནཱཾ མུཁེ པཱདཱཧནནཾ ཏཝ དུཿསཱདྷྱམ྄ ཨིབྲཱིཡབྷཱཥཡཱ གདིཏ ཨེཏཱདྲྀཤ ཨེཀཿ ཤབྡོ མཡཱ ཤྲུཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ཏདཱཧཾ པྲྀཥྚཝཱན྄ ཧེ པྲབྷོ ཀོ བྷཝཱན྄? ཏཏཿ ས ཀཐིཏཝཱན྄ ཡཾ ཡཱིཤུཾ ཏྭཾ ཏཱཌཡསི སོཧཾ, ");
INSERT INTO santib_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ཀིནྟུ སམུཏྟིཥྛ ཏྭཾ ཡད྄ དྲྀཥྚཝཱན྄ ཨིཏཿ པུནཉྩ ཡདྱཏ྄ ཏྭཱཾ དརྴཡིཥྱཱམི ཏེཥཱཾ སཪྻྭེཥཱཾ ཀཱཪྻྱཱཎཱཾ ཏྭཱཾ སཱཀྵིཎཾ མམ སེཝཀཉྩ ཀརྟྟུམ྄ དརྴནམ྄ ཨདཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ཝིཤེཥཏོ ཡིཧཱུདཱིཡལོཀེབྷྱོ བྷིནྣཛཱཏཱིཡེབྷྱཤྩ ཏྭཱཾ མནོནཱིཏཾ ཀྲྀཏྭཱ ཏེཥཱཾ ཡཐཱ པཱཔམོཙནཾ བྷཝཏི ");
INSERT INTO santib_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ཡཐཱ ཏེ མཡི ཝིཤྭསྱ པཝིཏྲཱིཀྲྀཏཱནཱཾ མདྷྱེ བྷཱགཾ པྲཱཔྣུཝནྟི ཏདབྷིཔྲཱཡེཎ ཏེཥཱཾ ཛྙཱནཙཀྵཱུཾཥི པྲསནྣཱནི ཀརྟྟུཾ ཏཐཱནྡྷཀཱརཱད྄ དཱིཔྟིཾ པྲཏི ཤཻཏཱནཱདྷིཀཱརཱཙྩ ཨཱིཤྭརཾ པྲཏི མཏཱིཿ པརཱཝརྟྟཡིཏུཾ ཏེཥཱཾ སམཱིཔཾ ཏྭཱཾ པྲེཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ཧེ ཨཱགྲིཔྤརཱཛ ཨེཏཱདྲྀཤཾ སྭརྒཱིཡཔྲཏྱཱདེཤཾ ཨགྲཱཧྱམ྄ ཨཀྲྀཏྭཱཧཾ ");
INSERT INTO santib_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","པྲཐམཏོ དམྨེཥཀྣགརེ ཏཏོ ཡིརཱུཤཱལམི སཪྻྭསྨིན྄ ཡིཧཱུདཱིཡདེཤེ ཨནྱེཥུ དེཤེཥུ ཙ ཡེेན ལོཀཱ མཏིཾ པརཱཝརྟྟྱ ཨཱིཤྭརཾ པྲཏི པརཱཝརྟྟཡནྟེ, མནཿཔརཱཝརྟྟནཡོགྱཱནི ཀརྨྨཱཎི ཙ ཀུཪྻྭནྟི ཏཱདྲྀཤམ྄ ཨུཔདེཤཾ པྲཙཱརིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ཨེཏཏྐཱརཎཱད྄ ཡིཧཱུདཱིཡཱ མདྷྱེམནྡིརཾ མཱཾ དྷྲྀཏྭཱ ཧནྟུམ྄ ཨུདྱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ཏཐཱཔི ཁྲཱིཥྚོ དུཿཁཾ བྷུཀྟྭཱ སཪྻྭེཥཱཾ པཱུཪྻྭཾ ཤྨཤཱནཱད྄ ཨུཏྠཱཡ ནིཛདེཤཱིཡཱནཱཾ བྷིནྣདེཤཱིཡཱནཱཉྩ སམཱིཔེ དཱིཔྟིཾ པྲཀཱཤཡིཥྱཏི ");
INSERT INTO santib_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","བྷཝིཥྱདྭཱདིགཎོ མཱུསཱཤྩ བྷཱཝིཀཱཪྻྱསྱ ཡདིདཾ པྲམཱཎམ྄ ཨདདུརེཏད྄ ཝིནཱནྱཱཾ ཀཐཱཾ ན ཀཐཡིཏྭཱ ཨཱིཤྭརཱད྄ ཨནུགྲཧཾ ལབྡྷྭཱ མཧཏཱཾ ཀྵུདྲཱཎཱཉྩ སཪྻྭེཥཱཾ སམཱིཔེ པྲམཱཎཾ དཏྟྭཱདྱ ཡཱཝཏ྄ ཏིཥྛཱམི། ");
INSERT INTO santib_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ཏསྱམཱཾ ཀཐཱཾ ནིཤམྱ ཕཱིཥྚ ཨུཙྩཻཿ སྭརེཎ ཀཐིཏཝཱན྄ ཧེ པཽལ ཏྭམ྄ ཨུནྨཏྟོསི བཧུཝིདྱཱབྷྱཱསེན ཏྭཾ ཧཏཛྙཱནོ ཛཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ས ཨུཀྟཝཱན྄ ཧེ མཧཱམཧིམ ཕཱིཥྚ ནཱཧམ྄ ཨུནྨཏྟཿ ཀིནྟུ སཏྱཾ ཝིཝེཙནཱིཡཉྩ ཝཱཀྱཾ པྲསྟཽམི། ");
INSERT INTO santib_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ཡསྱ སཱཀྵཱད྄ ཨཀྵོབྷཿ སན྄ ཀཐཱཾ ཀཐཡཱམི ས རཱཛཱ ཏདྭྲྀཏྟཱནྟཾ ཛཱནཱཏི ཏསྱ སམཱིཔེ ཀིམཔི གུཔྟཾ ནེཏི མཡཱ ནིཤྩིཏཾ བུདྷྱཏེ ཡཏསྟད྄ ཝིཛནེ ན ཀྲྀཏཾ། ");
INSERT INTO santib_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ཧེ ཨཱགྲིཔྤརཱཛ བྷཝཱན྄ ཀིཾ བྷཝིཥྱདྭཱདིགཎོཀྟཱནི ཝཱཀྱཱནི པྲཏྱེཏི? བྷཝཱན྄ པྲཏྱེཏི ཏདཧཾ ཛཱནཱམི། ");
INSERT INTO santib_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ཏཏ ཨཱགྲིཔྤཿ པཽལམ྄ ཨབྷིཧིཏཝཱན྄ ཏྭཾ པྲཝྲྀཏྟིཾ ཛནཡིཏྭཱ པྲཱཡེཎ མཱམཔི ཁྲཱིཥྚཱིཡཾ ཀརོཥི། ");
INSERT INTO santib_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ཏཏཿ སོ྅ཝཱདཱིཏ྄ བྷཝཱན྄ ཡེ ཡེ ལོཀཱཤྩ མམ ཀཐཱམ྄ ཨདྱ ཤྲྀཎྭནྟི པྲཱཡེཎ ཨིཏི ནཧི ཀིནྟྭེཏཏ྄ ཤྲྀངྑལབནྡྷནཾ ཝིནཱ སཪྻྭཐཱ ཏེ སཪྻྭེ མཱདྲྀཤཱ བྷཝནྟྭིཏཱིཤྭསྱ སམཱིཔེ པྲཱརྠཡེ྅ཧམ྄། ");
INSERT INTO santib_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ཨེཏསྱཱཾ ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ ས རཱཛཱ སོ྅དྷིཔཏི རྦརྞཱིཀཱི སབྷཱསྠཱ ལོཀཱཤྩ ཏསྨཱད྄ ཨུཏྠཱཡ ");
INSERT INTO santib_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","གོཔནེ པརསྤརཾ ཝིཝིཙྱ ཀཐིཏཝནྟ ཨེཥ ཛནོ བནྡྷནཱརྷཾ པྲཱཎཧནནཱརྷཾ ཝཱ ཀིམཔི ཀརྨྨ ནཱཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ཏཏ ཨཱགྲིཔྤཿ ཕཱིཥྚམ྄ ཨཝདཏ྄, ཡདྱེཥ མཱནུཥཿ ཀཻསརསྱ ནིཀཊེ ཝིཙཱརིཏོ བྷཝིཏུཾ ན པྲཱརྠཡིཥྱཏ྄ ཏརྷི མུཀྟོ བྷཝིཏུམ྄ ཨཤཀྵྱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ཛལཔཐེནཱསྨཱཀམ྄ ཨིཏོལིཡཱདེཤཾ པྲཏི ཡཱཏྲཱཡཱཾ ནིཤྩིཏཱཡཱཾ སཏྱཱཾ ཏེ ཡཱུལིཡནཱམྣོ མཧཱརཱཛསྱ སཾགྷཱཏཱནྟརྒཏསྱ སེནཱཔཏེཿ སམཱིཔེ པཽལཾ ཏདནྱཱན྄ ཀཏིནཡཛནཱཾཤྩ སམཱརྤཡན྄། ");
INSERT INTO santib_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ཝཡམ྄ ཨཱདྲཱམུཏྟཱིཡཾ པོཏམེཀམ྄ ཨཱརུཧྱ ཨཱཤིཡཱདེཤསྱ ཏཊསམཱིཔེན ཡཱཏུཾ མཏིཾ ཀྲྀཏྭཱ ལངྒརམ྄ ཨུཏྠཱཔྱ པོཏམ྄ ཨམོཙཡཱམ; མཱཀིདནིཡཱདེཤསྠཐིཥལནཱིཀཱིནིཝཱསྱཱརིསྟཱརྑནཱམཱ ཀཤྩིད྄ ཛནོ྅སྨཱབྷིཿ སཱརྡྡྷམ྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","པརསྨིན྄ དིཝསེ ྅སྨཱབྷིཿ སཱིདོནྣགརེ པོཏེ ལཱགིཏེ ཏཏྲ ཡཱུལིཡཿ སེནཱཔཏིཿ པཽལཾ པྲཏི སཽཛནྱཾ པྲདརྠྱ སཱནྟྭནཱརྠཾ བནྡྷུབཱནྡྷཝཱན྄ ཨུཔཡཱཏུམ྄ ཨནུཛཛྙཽ། ");
INSERT INTO santib_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ཏསྨཱཏ྄ པོཏེ མོཙིཏེ སཏི སམྨུཁཝཱཡོཿ སམྦྷཝཱད྄ ཝཡཾ ཀུཔྲོཔདྭཱིཔསྱ ཏཱིརསམཱིཔེན གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ཀིལིཀིཡཱཡཱཿ པཱམྥཱུལིཡཱཡཱཤྩ སམུདྲསྱ པཱརཾ གཏྭཱ ལཱུཀིཡཱདེཤཱནྟརྒཏཾ མུརཱནགརམ྄ ཨུཔཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ཏཏྶྠཱནཱད྄ ཨིཏཱལིཡཱདེཤཾ གཙྪཏི ཡཿ སིཀནྡརིཡཱནགརསྱ པོཏསྟཾ ཏཏྲ པྲཱཔྱ ཤཏསེནཱཔཏིསྟཾ པོཏམ྄ ཨསྨཱན྄ ཨཱརོཧཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ཏཏཿ པརཾ བཧཱུནི དིནཱནི ཤནཻཿ ཤནཻཿ རྒཏྭཱ ཀྣཱིདཔཱརྴྭོཔསྠྟིेཿ པཱུཪྻྭཾ པྲཏིཀཱུལེན པཝནེན ཝཡཾ སལྨོནྱཱཿ སམྨུཁམ྄ ཨུཔསྠཱཡ ཀྲཱིཏྱུཔདྭཱིཔསྱ ཏཱིརསམཱིཔེན གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ཀཥྚེན ཏམུཏྟཱིཪྻྱ ལཱསེཡཱནགརསྱཱདྷཿ སུནྡརནཱམཀཾ ཁཱཏམ྄ ཨུཔཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ཨིཏྠཾ བཧུཏིཐཿ ཀཱལོ ཡཱཔིཏ ཨུཔཝཱསདིནཉྩཱཏཱིཏཾ, ཏཏྐཱརཎཱཏ྄ ནཽཝརྟྨནི བྷཡངྐརེ སཏི པཽལོ ཝིནཡེན ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ཧེ མཧེཙྪཱ ཨཧཾ ནིཤྩཡཾ ཛཱནཱམི ཡཱཏྲཱཡཱམསྱཱམ྄ ཨསྨཱཀཾ ཀླེཤཱ བཧཱུནཱམཔཙཡཱཤྩ བྷཝིཥྱནྟི, ཏེ ཀེཝལཾ པོཏསཱམགྲྱོརིཏི ནཧི, ཀིནྟྭསྨཱཀཾ པྲཱཎཱནཱམཔི། ");
INSERT INTO santib_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ཏདཱ ཤཏསེནཱཔཏིཿ པཽैेལོཀྟཝཱཀྱཏོཔི ཀརྞདྷཱརསྱ པོཏཝཎིཛཤྩ ཝཱཀྱཾ བཧུམཾསྟ། ");
INSERT INTO santib_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ཏཏ྄ ཁཱཏཾ ཤཱིཏཀཱལེ ཝཱསཱརྷསྠཱནཾ ན ཏསྨཱད྄ ཨཝཱཙཱིཔྲཏཱིཙོརྡིཤོཿ ཀྲཱིཏྱཱཿ ཕཻནཱིཀིཡཁཱཏཾ ཡཱཏུཾ ཡདི ཤཀྣུཝནྟསྟརྷི ཏཏྲ ཤཱིཏཀཱལཾ ཡཱཔཡིཏུཾ པྲཱཡེཎ སཪྻྭེ མནྟྲཡཱམཱསུཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ཏཏཿ པརཾ དཀྵིཎཝཱཡུ རྨནྡཾ ཝཧཏཱིཏི ཝིལོཀྱ ནིཛཱབྷིཔྲཱཡསྱ སིདྡྷེཿ སུཡོགོ བྷཝཏཱིཏི བུདྡྷྭཱ པོཏཾ མོཙཡིཏྭཱ ཀྲཱིཏྱུཔདྭཱིཔསྱ ཏཱིརསམཱིཔེན ཙལིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ཀིནྟྭལྤཀྵཎཱཏ྄ པརམེཝ ཨུརཀླུདོནྣཱམཱ པྲཏིཀཱུལཿ པྲཙཎྜོ ཝཱཡུ ཪྻཧན྄ པོཏེ྅ལགཱིཏ྄ ");
INSERT INTO santib_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ཏསྱཱབྷིམུཁཾ གནྟུམ྄ པོཏསྱཱཤཀྟཏྭཱད྄ ཝཡཾ ཝཱཡུནཱ སྭཡཾ ནཱིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ཨནནྟརཾ ཀླཽདཱིནཱམྣ ཨུཔདྭཱིཔསྱ ཀཱུལསམཱིཔེན པོཏཾ གམཡིཏྭཱ བཧུནཱ ཀཥྚེན ཀྵུདྲནཱཝམ྄ ཨརཀྵཱམ། ");
INSERT INTO santib_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ཏེ ཏཱམཱརུཧྱ རཛྫྩཱ པོཏསྱཱདྷོབྷཱགམ྄ ཨབདྷྣན྄ ཏདནནྟརཾ ཙེཏ྄ པོཏོ སཻཀཏེ ལགཏཱིཏི བྷཡཱད྄ ཝཱཏཝསནཱནྱམོཙཡན྄ ཏཏཿ པོཏོ ཝཱཡུནཱ ཙཱལིཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ཀིནྟུ ཀྲམཤོ ཝཱཡོཿ པྲབལཏྭཱཏ྄ པོཏོ དོལཱཡམཱནོ྅བྷཝཏ྄ པརསྨིན྄ དིཝསེ པོཏསྠཱནི ཀཏིཔཡཱནི དྲཝྱཱཎི ཏོཡེ ནིཀྵིཔྟཱནི། ");
INSERT INTO santib_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ཏྲྀཏཱིཡདིཝསེ ཝཡཾ སྭཧསྟཻཿ པོཏསཛྫནདྲཝྱཱཎི ནིཀྵིཔྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ཏཏོ བཧུདིནཱནི ཡཱཝཏ྄ སཱུཪྻྱནཀྵཏྲཱདཱིནི སམཱཙྪནྣཱནི ཏཏོ ྅ཏཱིཝ ཝཱཏྱཱགམཱད྄ ཨསྨཱཀཾ པྲཱཎརཀྵཱཡཱཿ ཀཱཔི པྲཏྱཱཤཱ ནཱཏིཥྛཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","བཧུདིནེཥུ ལོཀཻརནཱཧཱརེཎ ཡཱཔིཏེཥུ སཪྻྭེཥཱཾ སཱཀྵཏ྄ པཽལསྟིཥྛན྄ ཨཀཐཡཏ྄, ཧེ མཧེཙྪཱཿ ཀྲཱིཏྱུཔདྭཱིཔཱཏ྄ པོཏཾ ན མོཙཡིཏུམ྄ ཨཧཾ པཱུཪྻྭཾ ཡད྄ ཨཝདཾ ཏདྒྲཧཎཾ ཡུཥྨཱཀམ྄ ཨུཙིཏམ྄ ཨཱསཱིཏ྄ ཏཐཱ ཀྲྀཏེ ཡུཥྨཱཀམ྄ ཨེཥཱ ཝིཔད྄ ཨེཥོ྅པཙཡཤྩ ནཱགྷཊིཥྱེཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ཀིནྟུ སཱམྤྲཏཾ ཡུཥྨཱན྄ ཝིནཱིཡ བྲཝཱིམྱཧཾ, ཡཱུཡཾ ན ཀྵུབྷྱཏ ཡུཥྨཱཀམ྄ ཨེཀསྱཱཔི པྲཱཎིནོ ཧཱནི རྣ བྷཝིཥྱཏི, ཀེཝལསྱ པོཏསྱ ཧཱནི རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ཡཏོ ཡསྱེཤྭརསྱ ལོཀོ྅ཧཾ ཡཉྩཱཧཾ པརིཙརཱམི ཏདཱིཡ ཨེཀོ དཱུཏོ ཧྱོ རཱཏྲཽ མམཱནྟིཀེ ཏིཥྛན྄ ཀཐིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ཧེ པཽལ མཱ བྷཻཥཱིཿ ཀཻསརསྱ སམྨུཁེ ཏྭཡོཔསྠཱཏཝྱཾ; ཏཝཻཏཱན྄ སངྒིནོ ལོཀཱན྄ ཨཱིཤྭརསྟུབྷྱཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ཨཏཨེཝ ཧེ མཧེཙྪཱ ཡཱུཡཾ སྠིརམནསོ བྷཝཏ མཧྱཾ ཡཱ ཀཐཱཀཐི སཱཝཤྱཾ གྷཊིཥྱཏེ མམཻཏཱདྲྀཤཱི ཝིཤྭཱས ཨཱིཤྭརེ ཝིདྱཏེ, ");
INSERT INTO santib_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ཀིནྟུ ཀསྱཙིད྄ ཨུཔདྭཱིཔསྱོཔརི པཏིཏཝྱམ྄ ཨསྨཱབྷིཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ཏཏཿ པརམ྄ ཨཱདྲིཡཱསམུདྲེ པོཏསྟཐཻཝ དོལཱཡམཱནཿ སན྄ ཨིཏསྟཏོ གཙྪན྄ ཙཏུརྡཤདིཝསསྱ རཱཏྲེ རྡྭིཏཱིཡཔྲཧརསམཡེ ཀསྱཙིཏ྄ སྠལསྱ སམཱིཔམུཔཏིཥྛཏཱིཏི པོཏཱིཡལོཀཱ ཨནྭམནྱནྟ། ");
INSERT INTO santib_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ཏཏསྟེ ཛལཾ པརིམཱཡ ཏཏྲ ཝིཾཤཏི ཪྻྱཱམཱ ཛལཱནཱིཏི ཛྙཱཏཝནྟཿ། ཀིཉྩིདྡཱུརཾ གཏྭཱ པུནརཔི ཛལཾ པརིམིཏཝནྟཿ། ཏཏྲ པཉྩདཤ ཝྱཱམཱ ཛལཱནི དྲྀཥྚྭཱ ");
INSERT INTO santib_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ཙེཏ྄ པཱཥཱཎེ ལགཏཱིཏི བྷཡཱཏ྄ པོཏསྱ པཤྩཱདྦྷཱགཏཤྩཏུརོ ལངྒརཱན྄ ནིཀྵིཔྱ དིཝཱཀརམ྄ ཨཔེཀྵྱ སཪྻྭེ སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ཀིནྟུ པོཏཱིཡལོཀཱཿ པོཏཱགྲབྷཱགེ ལངྒརནིཀྵེཔཾ ཚལཾ ཀྲྀཏྭཱ ཛལདྷཽ ཀྵུདྲནཱཝམ྄ ཨཝརོཧྱ པལཱཡིཏུམ྄ ཨཙེཥྚནྟ། ");
INSERT INTO santib_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ཏཏཿ པཽལཿ སེནཱཔཏཡེ སཻནྱགཎཱཡ ཙ ཀཐིཏཝཱན྄, ཨེཏེ ཡདི པོཏམདྷྱེ ན ཏིཥྛནྟི ཏརྷི ཡུཥྨཱཀཾ རཀྵཎཾ ན ཤཀྱཾ། ");
INSERT INTO santib_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ཏདཱ སེནཱགཎོ རཛྫཱུན྄ ཚིཏྭཱ ནཱཝཾ ཛལེ པཏིཏུམ྄ ཨདདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","པྲབྷཱཏསམཡེ པཽལཿ སཪྻྭཱན྄ ཛནཱན྄ བྷོཛནཱརྠཾ པྲཱརྠྱ ཝྱཱཧརཏ྄, ཨདྱ ཙཏུརྡཤདིནཱནི ཡཱཝད྄ ཡཱུཡམ྄ ཨཔེཀྵམཱནཱ ཨནཱཧཱརཱཿ ཀཱལམ྄ ཨཡཱཔཡཏ ཀིམཔི ནཱབྷུཾགྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ཨཏོ ཝིནཡེे྅ཧཾ བྷཀྵྱཾ བྷུཛྱཏཱཾ ཏཏོ ཡུཥྨཱཀཾ མངྒལཾ བྷཝིཥྱཏི, ཡུཥྨཱཀཾ ཀསྱཙིཛྫནསྱ ཤིརསཿ ཀེཤཻཀོཔི ན ནཾཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ཨིཏི ཝྱཱཧྲྀཏྱ པཽལཾ པཱུཔཾ གྲྀཧཱིཏྭེཤྭརཾ དྷནྱཾ བྷཱཥམཱཎསྟཾ བྷཾཀྟྭཱ བྷོཀྟུམ྄ ཨཱརབྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ཨནནྟརཾ སཪྻྭེ ཙ སུསྠིརཱཿ སནྟཿ ཁཱདྱཱནི པརྤྱགྲྀཧླན྄། ");
INSERT INTO santib_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ཨསྨཱཀཾ པོཏེ ཥཊྶཔྟཏྱདྷིཀཤཏདྭཡལོཀཱ ཨཱསན྄། ");
INSERT INTO santib_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","སཪྻྭེཥུ ལོཀེཥུ ཡཐེཥྚཾ བྷུཀྟཝཏྶུ པོཏསྠན྄ གོདྷཱུམཱན྄ ཛལདྷཽ ནིཀྵིཔྱ ཏཻཿ པོཏསྱ བྷཱརོ ལགྷཱུཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","དིནེ ཛཱཏེ྅པི ས ཀོ དེཤ ཨིཏི ཏདཱ ན པཪྻྱཙཱིཡཏ; ཀིནྟུ ཏཏྲ སམཏཊམ྄ ཨེཀཾ ཁཱཏཾ དྲྀཥྚྭཱ ཡདི ཤཀྣུམསྟརྷི ཝཡཾ ཏསྱཱབྷྱནྟརཾ པོཏཾ གམཡཱམ ཨིཏི མཏིཾ ཀྲྀཏྭཱ ཏེ ལངྒརཱན྄ ཚིཏྟྭཱ ཛལདྷཽ ཏྱཀྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ཏཐཱ ཀརྞབནྡྷནཾ མོཙཡིཏྭཱ པྲདྷཱནཾ ཝཱཏཝསནམ྄ ཨུཏྟོལྱ ཏཱིརསམཱིཔཾ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ཀིནྟུ དྭཡོཿ སམུདྲཡོཿ སངྒམསྠཱནེ སཻཀཏོཔརི པོཏེ ནིཀྵིཔྟེ ྅གྲབྷཱགེ བཱདྷིཏེ པཤྩཱདྦྷཱགེ པྲབལཏརངྒོ྅ལགཏ྄ ཏེན པོཏོ བྷགྣཿ། ");
INSERT INTO santib_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ཏསྨཱད྄ བནྡཡཤྩེད྄ བཱཧུབྷིསྟརནྟཿ པལཱཡནྟེ ཨིཏྱཱཤངྐཡཱ སེནཱགཎསྟཱན྄ ཧནྟུམ྄ ཨམནྟྲཡཏ྄; ");
INSERT INTO santib_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ཀིནྟུ ཤཏསེནཱཔཏིཿ པཽལཾ རཀྵིཏུཾ པྲཡཏྣཾ ཀྲྀཏྭཱ ཏཱན྄ ཏཙྩེཥྚཱཡཱ ནིཝརྟྱ ཨིཏྱཱདིཥྚཝཱན྄, ཡེ བཱཧུཏརཎཾ ཛཱནནྟི ཏེ྅གྲེ པྲོལླམྤྱ སམུདྲེ པཏིཏྭཱ བཱཧུབྷིསྟཱིརྟྟྭཱ ཀཱུལཾ ཡཱནྟུ། ");
INSERT INTO santib_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ཨཔརམ྄ ཨཝཤིཥྚཱ ཛནཱཿ ཀཱཥྛཾ པོཏཱིཡཾ དྲཝྱཾ ཝཱ ཡེན ཡཏ྄ པྲཱཔྱཏེ ཏདཝལམྦྱ ཡཱནྟུ; ཨིཏྠཾ སཪྻྭེ བྷཱུམིཾ པྲཱཔྱ པྲཱཎཻ རྫཱིཝིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ཨིཏྠཾ སཪྻྭེཥུ རཀྵཱཾ པྲཱཔྟེཥུ ཏཏྲཏྱོཔདྭཱིཔསྱ ནཱམ མིལཱིཏེཏི ཏེ ཛྙཱཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ཨསབྷྱལོཀཱ ཡཐེཥྚམ྄ ཨནུཀམྤཱཾ ཀྲྀཏྭཱ ཝརྟྟམཱནཝྲྀཥྚེཿ ཤཱིཏཱཙྩ ཝཧྣིཾ པྲཛྫྭཱལྱཱསྨཱཀམ྄ ཨཱཏིཐྱམ྄ ཨཀུཪྻྭན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ཀིནྟུ པཽལ ཨིནྡྷནཱནི སཾགྲྀཧྱ ཡདཱ ཏསྨིན྄ ཨགྲཽ ནིརཀྵིཔཏ྄, ཏདཱ ཝཧྣེཿ པྲཏཱཔཱཏ྄ ཨེཀཿ ཀྲྀཥྞསརྤོ ནིརྒཏྱ ཏསྱ ཧསྟེ དྲཥྚཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ཏེ྅སབྷྱལོཀཱསྟསྱ ཧསྟེ སརྤམ྄ ཨཝལམྦམཱནཾ དྲྀཥྚྭཱ པརསྤརམ྄ ཨུཀྟཝནྟ ཨེཥ ཛནོ྅ཝཤྱཾ ནརཧཱ བྷཝིཥྱཏི, ཡཏོ ཡདྱཔི ཛལདྷེ རཀྵཱཾ པྲཱཔྟཝཱན྄ ཏཐཱཔི པྲཏིཕལདཱཡཀ ཨེནཾ ཛཱིཝིཏུཾ ན དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ཀིནྟུ ས ཧསྟཾ ཝིདྷུནྭན྄ ཏཾ སརྤམ྄ ཨགྣིམདྷྱེ ནིཀྵིཔྱ ཀཱམཔི པཱིཌཱཾ ནཱཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ཏཏོ ཝིཥཛྭཱལཡཱ ཨེཏསྱ ཤརཱིརཾ སྥཱིཏཾ བྷཝིཥྱཏི ཡདྭཱ ཧཋཱདཡཾ པྲཱཎཱན྄ ཏྱཀྵྱཏཱིཏི ནིཤྩིཏྱ ལོཀཱ བཧུཀྵཎཱནི ཡཱཝཏ྄ ཏད྄ དྲཥྚུཾ སྠིཏཝནྟཿ ཀིནྟུ ཏསྱ ཀསྱཱཤྩིད྄ ཝིཔདོ྅གྷཊནཱཏ྄ ཏེ ཏདྭིཔརཱིཏཾ ཝིཛྙཱཡ བྷཱཥིཏཝནྟ ཨེཥ ཀཤྩིད྄ དེཝོ བྷཝེཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","པུབླིཡནཱམཱ ཛན ཨེཀསྟསྱོཔདྭཱིཔསྱཱདྷིཔཏིརཱསཱིཏ྄ ཏཏྲ ཏསྱ བྷཱུམྱཱདི ཙ སྠིཏཾ། ས ཛནོ྅སྨཱན྄ ནིཛགྲྀཧཾ ནཱིཏྭཱ སཽཛནྱཾ པྲཀཱཤྱ དིནཏྲཡཾ ཡཱཝད྄ ཨསྨཱཀཾ ཨཱཏིཐྱམ྄ ཨཀརོཏ྄། ");
INSERT INTO santib_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ཏདཱ ཏསྱ པུབླིཡསྱ པིཏཱ ཛྭརཱཏིསཱརེཎ པཱིཌྱམཱནཿ སན྄ ཤཡྻཱཡཱམ྄ ཨཱསཱིཏ྄; ཏཏཿ པཽལསྟསྱ སམཱིཔཾ གཏྭཱ པྲཱརྠནཱཾ ཀྲྀཏྭཱ ཏསྱ གཱཏྲེ ཧསྟཾ སམརྤྱ ཏཾ སྭསྠཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ཨིཏྠཾ བྷཱུཏེ ཏདྭཱིཔནིཝཱསིན ཨིཏརེཔི རོགིལོཀཱ ཨཱགཏྱ ནིརཱམཡཱ ཨབྷཝན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ཏསྨཱཏྟེ྅སྨཱཀམ྄ ཨཏཱིཝ སཏྐཱརཾ ཀྲྀཏཝནྟཿ, ཝིཤེཥཏཿ པྲསྠཱནསམཡེ པྲཡོཛནཱིཡཱནི ནཱནདྲཝྱཱཎི དཏྟཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ཨིཏྠཾ ཏཏྲ ཏྲིཥུ མཱསེཥུ གཏེཥུ ཡསྱ ཙིཧྣཾ དིཡསྐཱུརཱི ཏཱདྲྀཤ ཨེཀཿ སིཀནྡརཱིཡནགརསྱ པོཏཿ ཤཱིཏཀཱལཾ ཡཱཔཡན྄ ཏསྨིན྄ ཨུཔདྭཱིཔེ ྅ཏིཥྛཏ྄ ཏམེཝ པོཏཾ ཝཡམ྄ ཨཱརུཧྱ ཡཱཏྲཱམ྄ ཨཀུརྨྨ། ");
INSERT INTO santib_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ཏཏཿ པྲཐམཏཿ སུརཱཀཱུསནགརམ྄ ཨུཔསྠཱཡ ཏཏྲ ཏྲཱིཎི དིནཱནི སྠིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ཏསྨཱད྄ ཨཱཝྲྀཏྱ རཱིགིཡནགརམ྄ ཨུཔསྠིཏཱཿ དིནཻཀསྨཱཏ྄ པརཾ དཀྵིཎཝཡཽ སཱནུཀཱུལྱེ སཏི པརསྨིན྄ དིཝསེ པཏིཡལཱིནགརམ྄ ཨུཔཱཏིཥྛཱམ། ");
INSERT INTO santib_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ཏཏོ྅སྨཱསུ ཏཏྲཏྱཾ བྷྲཱཏྲྀགཎཾ པྲཱཔྟེཥུ ཏེ སྭཻཿ སཱརྡྡྷམ྄ ཨསྨཱན྄ སཔྟ དིནཱནི སྠཱཔཡིཏུམ྄ ཨཡཏནྟ, ཨིཏྠཾ ཝཡཾ རོམཱནགརམ྄ པྲཏྱགཙྪཱམ། ");
INSERT INTO santib_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ཏསྨཱཏ྄ ཏཏྲཏྱཱཿ བྷྲཱཏརོ྅སྨཱཀམ྄ ཨཱགམནཝཱརྟྟཱཾ ཤྲུཏྭཱ ཨཱཔྤིཡཕརཾ ཏྲིཥྚཱཝརྞཱིཉྩ ཡཱཝད྄ ཨགྲེསརཱཿ སནྟོསྨཱན྄ སཱཀྵཱཏ྄ ཀརྟྟུམ྄ ཨཱགམན྄; ཏེཥཱཾ དརྴནཱཏ྄ པཽལ ཨཱིཤྭརཾ དྷནྱཾ ཝདན྄ ཨཱཤྭཱསམ྄ ཨཱཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ཨསྨཱསུ རོམཱནགརཾ གཏེཥུ ཤཏསེནཱཔཏིཿ སཪྻྭཱན྄ བནྡཱིན྄ པྲདྷཱནསེནཱཔཏེཿ སམཱིཔེ སམཱརྤཡཏ྄ ཀིནྟུ པཽལཱཡ སྭརཀྵཀཔདཱཏིནཱ སཧ པྲྀཐག྄ ཝསྟུམ྄ ཨནུམཏིཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","དིནཏྲཡཱཏ྄ པརཾ པཽལསྟདྡེཤསྠཱན྄ པྲདྷཱནཡིཧཱུདིན ཨཱཧཱུཏཝཱན྄ ཏཏསྟེཥུ སམུཔསྠིཏེཥུ ས ཀཐིཏཝཱན྄, ཧེ བྷྲཱཏྲྀགཎ ནིཛལོཀཱནཱཾ པཱུཪྻྭཔུརུཥཱཎཱཾ ཝཱ རཱིཏེ ཪྻིཔརཱིཏཾ ཀིཉྩན ཀརྨྨཱཧཾ ནཱཀརཝཾ ཏཐཱཔི ཡིརཱུཤཱལམནིཝཱསིནོ ལོཀཱ མཱཾ བནྡིཾ ཀྲྀཏྭཱ རོམིལོཀཱནཱཾ ཧསྟེཥུ སམརྤིཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","རོམིལོཀཱ ཝིཙཱཪྻྱ མམ པྲཱཎཧནནཱརྷཾ ཀིམཔི ཀཱརཎཾ ན པྲཱཔྱ མཱཾ མོཙཡིཏུམ྄ ཨཻཙྪན྄; ");
INSERT INTO santib_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ཀིནྟུ ཡིཧཱུདིལོཀཱནཱམ྄ ཨཱཔཏྟྱཱ མཡཱ ཀཻསརརཱཛསྱ སམཱིཔེ ཝིཙཱརསྱ པྲཱརྠནཱ ཀརྟྟཝྱཱ ཛཱཏཱ ནོཙེཏ྄ ནིཛདེཤཱིཡལོཀཱན྄ པྲཏི མམ ཀོཔྱབྷིཡོགོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ཨེཏཏྐཱརཎཱད྄ ཨཧཾ ཡུཥྨཱན྄ དྲཥྚུཾ སཾལཔིཏུཉྩཱཧཱུཡམ྄ ཨིསྲཱཡེལྭཤཱིཡཱནཱཾ པྲཏྱཱཤཱཧེཏོཧམ྄ ཨེཏེན ཤུངྑལེན བདྡྷོ྅བྷཝམ྄། ");
INSERT INTO santib_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ཏདཱ ཏེ ཏམ྄ ཨཝཱདིཥུཿ, ཡིཧཱུདཱིཡདེཤཱད྄ ཝཡཾ ཏྭཱམདྷི ཀིམཔི པཏྲཾ ན པྲཱཔྟཱ ཡེ བྷྲཱཏརཿ སམཱཡཱཏཱསྟེཥཱཾ ཀོཔི ཏཝ ཀཱམཔི ཝཱརྟྟཱཾ ནཱཝདཏ྄ ཨབྷདྲམཔི ནཱཀཐཡཙྩ། ");
INSERT INTO santib_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ཏཝ མཏཾ ཀིམིཏི ཝཡཾ ཏྭཏྟཿ ཤྲོཏུམིཙྪཱམཿ། ཡད྄ ཨིདཾ ནཝཱིནཾ མཏམུཏྠིཏཾ ཏཏ྄ སཪྻྭཏྲ སཪྻྭེཥཱཾ ནིཀཊེ ནིནྡིཏཾ ཛཱཏམ ཨིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ཏཻསྟདརྠམ྄ ཨེཀསྨིན྄ དིནེ ནིརཱུཔིཏེ ཏསྨིན྄ དིནེ བཧཝ ཨེཀཏྲ མིལིཏྭཱ པཽལསྱ ཝཱསགྲྀཧམ྄ ཨཱགཙྪན྄ ཏསྨཱཏ྄ པཽལ ཨཱ པྲཱཏཿཀཱལཱཏ྄ སནྡྷྱཱཀཱལཾ ཡཱཝན྄ མཱུསཱཝྱཝསྠཱགྲནྠཱད྄ བྷཝིཥྱདྭཱདིནཱཾ གྲནྠེབྷྱཤྩ ཡཱིཤོཿ ཀཐཱམ྄ ཨུཏྠཱཔྱ ཨཱིཤྭརསྱ རཱཛྱེ པྲམཱཎཾ དཏྭཱ ཏེཥཱཾ པྲཝྲྀཏྟིཾ ཛནཡིཏུཾ ཙེཥྚིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ཀེཙིཏྟུ ཏསྱ ཀཐཱཾ པྲཏྱཱཡན྄ ཀེཙིཏྟུ ན པྲཏྱཱཡན྄; ");
INSERT INTO santib_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ཨེཏཏྐཱརཎཱཏ྄ ཏེཥཱཾ པརསྤརམ྄ ཨནཻཀྱཱཏ྄ སཪྻྭེ ཙལིཏཝནྟཿ; ཏཐཱཔི པཽལ ཨེཏཱཾ ཀཐཱམེཀཱཾ ཀཐིཏཝཱན྄ པཝིཏྲ ཨཱཏྨཱ ཡིཤཡིཡསྱ བྷཝིཥྱདྭཀྟུ ཪྻདནཱད྄ ཨསྨཱཀཾ པིཏྲྀཔུརུཥེབྷྱ ཨེཏཱཾ ཀཐཱཾ བྷདྲཾ ཀཐཡཱམཱས, ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ཨུཔགཏྱ ཛནཱནེཏཱན྄ ཏྭཾ བྷཱཥསྭ ཝཙསྟྭིདཾ། ཀརྞཻཿ ཤྲོཥྱཐ ཡཱུཡཾ ཧི ཀིནྟུ ཡཱུཡཾ ན བྷོཏྶྱཐ། ནེཏྲཻ རྡྲཀྵྱཐ ཡཱུཡཉྩ ཛྙཱཏུཾ ཡཱུཡཾ ན ཤཀྵྱཐ། ");
INSERT INTO santib_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ཏེ མཱནུཥཱ ཡཐཱ ནེཏྲཻཿ པརིཔཤྱནྟི ནཻཝ ཧི། ཀརྞཻཿ ཪྻཐཱ ན ཤྲྀཎྭནྟི བུདྷྱནྟེ ན ཙ མཱནསཻཿ། ཝྱཱཝརྟྟཡཏྶུ ཙིཏྟཱནི ཀཱལེ ཀུཏྲཱཔི ཏེཥུ ཝཻ། མཏྟསྟེ མནུཛཱཿ སྭསྠཱ ཡཐཱ ནཻཝ བྷཝནྟི ཙ། ཏཐཱ ཏེཥཱཾ མནུཥྱཱཎཱཾ སནྟི སྠཱུལཱ ཧི བུདྡྷཡཿ། བདྷིརཱིབྷཱུཏཀརྞཱཤྩ ཛཱཏཱཤྩ མུདྲིཏཱ དྲྀཤཿ༎ ");
INSERT INTO santib_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ཨཏ ཨཱིཤྭརཱད྄ ཡཏ྄ པརིཏྲཱཎཾ ཏསྱ ཝཱརྟྟཱ བྷིནྣདེཤཱིཡཱནཱཾ སམཱིཔཾ པྲེཥིཏཱ ཏཨེཝ ཏཱཾ གྲཧཱིཥྱནྟཱིཏི ཡཱུཡཾ ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ཨེཏཱདྲྀཤྱཱཾ ཀཐཱཡཱཾ ཀཐིཏཱཡཱཾ སཏྱཱཾ ཡིཧཱུདིནཿ པརསྤརཾ བཧུཝིཙཱརཾ ཀུཪྻྭནྟོ གཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ཨིཏྠཾ པཽལཿ སམྤཱུརྞཾ ཝཏྶརདྭཡཾ ཡཱཝད྄ བྷཱཊཀཱིཡེ ཝཱསགྲྀཧེ ཝསན྄ ཡེ ལོཀཱསྟསྱ སནྣིདྷིམ྄ ཨཱགཙྪནྟི ཏཱན྄ སཪྻྭཱནེཝ པརིགྲྀཧླན྄, ");
INSERT INTO santib_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ནིཪྻིགྷྣམ྄ ཨཏིཤཡནིཿཀྵོབྷམ྄ ཨཱིཤྭརཱིཡརཱཛཏྭསྱ ཀཐཱཾ པྲཙཱརཡན྄ པྲབྷཽ ཡཱིཤཽ ཁྲཱིཥྚེ ཀཐཱཿ སམུཔཱདིཤཏ྄། ཨིཏི༎ ");
INSERT INTO santib_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ཨཱིཤྭརོ ནིཛཔུཏྲམདྷི ཡཾ སུསཾཝཱདཾ བྷཝིཥྱདྭཱདིབྷི རྡྷརྨྨགྲནྠེ པྲཏིཤྲུཏཝཱན྄ ཏཾ སུསཾཝཱདཾ པྲཙཱརཡིཏུཾ པྲྀཐཀྐྲྀཏ ཨཱཧཱུཏཿ པྲེརིཏཤྩ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ སེཝཀོ ཡཿ པཽལཿ ");
INSERT INTO santib_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ས རོམཱནགརསྠཱན྄ ཨཱིཤྭརཔྲིཡཱན྄ ཨཱཧཱུཏཱཾཤྩ པཝིཏྲལོཀཱན྄ པྲཏི པཏྲཾ ལིཁཏི། ");
INSERT INTO santib_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ཨསྨཱཀཾ ས པྲབྷུ ཪྻཱིཤུཿ ཁྲཱིཥྚཿ ཤཱརཱིརིཀསམྦནྡྷེན དཱཡཱུདོ ཝཾཤོདྦྷཝཿ ");
INSERT INTO santib_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","པཝིཏྲསྱཱཏྨནཿ སམྦནྡྷེན ཙེཤྭརསྱ པྲབྷཱཝཝཱན྄ པུཏྲ ཨིཏི ཤྨཤཱནཱཏ྄ ཏསྱོཏྠཱནེན པྲཏིཔནྣཾ། ");
INSERT INTO santib_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ཨཔརཾ ཡེཥཱཾ མདྷྱེ ཡཱིཤུནཱ ཁྲཱིཥྚེན ཡཱུཡམཔྱཱཧཱུཏཱསྟེ ྅ནྱདེཤཱིཡལོཀཱསྟསྱ ནཱམྣི ཝིཤྭསྱ ནིདེཤགྲཱཧིཎོ ཡཐཱ བྷཝནྟི ");
INSERT INTO santib_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ཏདབྷིཔྲཱཡེཎ ཝཡཾ ཏསྨཱད྄ ཨནུགྲཧཾ པྲེརིཏཏྭཔདཉྩ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ཏཱཏེནཱསྨཱཀམ྄ ཨཱིཤྭརེཎ པྲབྷུཎཱ ཡཱིཤུཁྲཱིཥྚེན ཙ ཡུཥྨབྷྱམ྄ ཨནུགྲཧཿ ཤཱནྟིཤྩ པྲདཱིཡེཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","པྲཐམཏཿ སཪྻྭསྨིན྄ ཛགཏི ཡུཥྨཱཀཾ ཝིཤྭཱསསྱ པྲཀཱཤིཏཏྭཱད྄ ཨཧཾ ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ ནིམིཏྟཾ ཡཱིཤུཁྲཱིཥྚསྱ ནཱམ གྲྀཧླན྄ ཨཱིཤྭརསྱ དྷནྱཝཱདཾ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ཨཔརམ྄ ཨཱིཤྭརསྱ པྲསཱདཱད྄ བཧུཀཱལཱཏ྄ པརཾ སཱམྤྲཏཾ ཡུཥྨཱཀཾ སམཱིཔཾ ཡཱཏུཾ ཀཐམཔི ཡཏ྄ སུཡོགཾ པྲཱཔྣོམི, ཨེཏདརྠཾ ནིརནྟརཾ ནཱམཱནྱུཙྩཱརཡན྄ ནིཛཱསུ སཪྻྭཔྲཱརྠནཱསུ སཪྻྭདཱ ནིཝེདཡཱམི, ");
INSERT INTO santib_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ཨེཏསྨིན྄ ཡམཧཾ ཏཏྤུཏྲཱིཡསུསཾཝཱདཔྲཙཱརཎེན མནསཱ པརིཙརཱམི ས ཨཱིཤྭརོ མམ སཱཀྵཱི ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ཡཏོ ཡུཥྨཱཀཾ མམ ཙ ཝིཤྭཱསེན ཝཡམ྄ ཨུབྷཡེ ཡཐཱ ཤཱནྟིཡུཀྟཱ བྷཝཱམ ཨིཏི ཀཱརཎཱད྄ ");
INSERT INTO santib_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ཡུཥྨཱཀཾ སྠཻཪྻྱཀརཎཱརྠཾ ཡུཥྨབྷྱཾ ཀིཉྩིཏྤརམཱརྠདཱནདཱནཱཡ ཡུཥྨཱན྄ སཱཀྵཱཏ྄ ཀརྟྟུཾ མདཱིཡཱ ཝཱཉྪཱ། ");
INSERT INTO santib_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ཧེ བྷྲཱཏྲྀགཎ བྷིནྣདེཤཱིཡལོཀཱནཱཾ མདྷྱེ ཡདྭཏ྄ ཏདྭད྄ ཡུཥྨཱཀཾ མདྷྱེཔི ཡཐཱ ཕལཾ བྷུཉྫེ ཏདབྷིཔྲཱཡེཎ མུཧུརྨུཧུ ཪྻུཥྨཱཀཾ སམཱིཔཾ གནྟུམ྄ ཨུདྱཏོ྅ཧཾ ཀིནྟུ ཡཱཝད྄ ཨདྱ ཏསྨིན྄ གམནེ མམ ཝིགྷྣོ ཛཱཏ ཨིཏི ཡཱུཡཾ ཡད྄ ཨཛྙཱཏཱསྟིཥྛཐ ཏདཧམ྄ ཨུཙིཏཾ ན བུདྷྱེ། ");
INSERT INTO santib_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ཨཧཾ སབྷྱཱསབྷྱཱནཱཾ ཝིདྭདཝིདྭཏཱཉྩ སཪྻྭེཥཱམ྄ ཨྲྀཎཱི ཝིདྱེ། ");
INSERT INTO santib_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ཨཏཨེཝ རོམཱནིཝཱསིནཱཾ ཡུཥྨཱཀཾ སམཱིཔེ྅པི ཡཐཱཤཀྟི སུསཾཝཱདཾ པྲཙཱརཡིཏུམ྄ ཨཧམ྄ ཨུདྱཏོསྨི། ");
INSERT INTO santib_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ཡཏཿ ཁྲཱིཥྚསྱ སུསཾཝཱདོ མམ ལཛྫཱསྤདཾ ནཧི ས ཨཱིཤྭརསྱ ཤཀྟིསྭརཱུཔཿ སན྄ ཨཱ ཡིཧཱུདཱིཡེབྷྱོ ྅ནྱཛཱཏཱིཡཱན྄ ཡཱཝཏ྄ སཪྻྭཛཱཏཱིཡཱནཱཾ མདྷྱེ ཡཿ ཀཤྩིད྄ ཏཏྲ ཝིཤྭསིཏི ཏསྱཻཝ ཏྲཱཎཾ ཛནཡཏི། ");
INSERT INTO santib_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ཡཏཿ པྲཏྱཡསྱ སམཔརིམཱཎམ྄ ཨཱིཤྭརདཏྟཾ པུཎྱཾ ཏཏྶུསཾཝཱདེ པྲཀཱཤཏེ། ཏདདྷི དྷརྨྨཔུསྟཀེཔི ལིཁིཏམིདཾ \"པུཎྱཝཱན྄ ཛནོ ཝིཤྭཱསེན ཛཱིཝིཥྱཏི\"། ");
INSERT INTO santib_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ཨཏཨེཝ ཡེ མཱནཝཱཿ པཱཔཀརྨྨཎཱ སཏྱཏཱཾ རུནྡྷནྟི ཏེཥཱཾ སཪྻྭསྱ དུརཱཙརཎསྱཱདྷརྨྨསྱ ཙ ཝིརུདྡྷཾ སྭརྒཱད྄ ཨཱིཤྭརསྱ ཀོཔཿ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ཡཏ ཨཱིཤྭརམདྷི ཡདྱད྄ ཛྙེཡཾ ཏད྄ ཨཱིཤྭརཿ སྭཡཾ ཏཱན྄ པྲཏི པྲཀཱཤིཏཝཱན྄ ཏསྨཱཏ྄ ཏེཥཱམ྄ ཨགོཙརཾ ནཧི། ");
INSERT INTO santib_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ཕལཏསྟསྱཱནནྟཤཀྟཱིཤྭརཏྭཱདཱིནྱདྲྀཤྱཱནྱཔི སྲྀཥྚིཀཱལམ྄ ཨཱརབྷྱ ཀརྨྨསུ པྲཀཱཤམཱནཱནི དྲྀཤྱནྟེ ཏསྨཱཏ྄ ཏེཥཱཾ དོཥཔྲཀྵཱལནསྱ པནྠཱ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ཨཔརམ྄ ཨཱིཤྭརཾ ཛྙཱཏྭཱཔི ཏེ ཏམ྄ ཨཱིཤྭརཛྙཱནེན ནཱདྲིཡནྟ ཀྲྀཏཛྙཱ ཝཱ ན ཛཱཏཱཿ; ཏསྨཱཏ྄ ཏེཥཱཾ སཪྻྭེ ཏརྐཱ ཝིཕལཱིབྷཱུཏཱཿ, ཨཔརཉྩ ཏེཥཱཾ ཝིཝེཀཤཱུནྱཱནི མནཱཾསི ཏིམིརེ མགྣཱནི། ");
INSERT INTO santib_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ཏེ སྭཱན྄ ཛྙཱནིནོ ཛྙཱཏྭཱ ཛྙཱནཧཱིནཱ ཨབྷཝན྄ ");
INSERT INTO santib_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ཨནཤྭརསྱེཤྭརསྱ གཽརཝཾ ཝིཧཱཡ ནཤྭརམནུཥྱཔཤུཔཀྵྱུརོགཱམིཔྲབྷྲྀཏེརཱཀྲྀཏིཝིཤིཥྚཔྲཏིམཱསྟཻརཱཤྲིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ཨིཏྠཾ ཏ ཨཱིཤྭརསྱ སཏྱཏཱཾ ཝིཧཱཡ མྲྀཥཱམཏམ྄ ཨཱཤྲིཏཝནྟཿ སཙྩིདཱནནྡཾ སྲྀཥྚིཀརྟྟཱརཾ ཏྱཀྟྭཱ སྲྀཥྚཝསྟུནཿ པཱུཛཱཾ སེཝཱཉྩ ཀྲྀཏཝནྟཿ; ");
INSERT INTO santib_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ཨིཏི ཧེཏོརཱིཤྭརསྟཱན྄ ཀུཀྲིཡཱཡཱཾ སམརྤྱ ནིཛནིཛཀུཙིནྟཱབྷིལཱཥཱབྷྱཱཾ སྭཾ སྭཾ ཤརཱིརཾ པརསྤརམ྄ ཨཔམཱནིཏཾ ཀརྟྟུམ྄ ཨདདཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ཨཱིཤྭརེཎ ཏེཥུ ཀྭབྷིལཱཥེ སམརྤིཏེཥུ ཏེཥཱཾ ཡོཥིཏཿ སྭཱབྷཱཝིཀཱཙརཎམ྄ ཨཔཧཱཡ ཝིཔརཱིཏཀྲྀཏྱེ པྲཱཝརྟྟནྟ; ");
INSERT INTO santib_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ཏཐཱ པུརུཥཱ ཨཔི སྭཱབྷཱཝིཀཡོཥིཏྶངྒམཾ ཝིཧཱཡ པརསྤརཾ ཀཱམཀྲྀཤཱནུནཱ དགྡྷཱཿ སནྟཿ པུམཱཾསཿ པུཾབྷིཿ སཱཀཾ ཀུཀྲྀཏྱེ སམཱསཛྱ ནིཛནིཛབྷྲཱནྟེཿ སམུཙིཏཾ ཕལམ྄ ཨལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ཏེ སྭེཥཱཾ མནཿསྭཱིཤྭརཱཡ སྠཱནཾ དཱཏུམ྄ ཨནིཙྪུཀཱསྟཏོ ཧེཏོརཱིཤྭརསྟཱན྄ པྲཏི དུཥྚམནསྐཏྭམ྄ ཨཝིཧིཏཀྲིཡཏྭཉྩ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ཨཏཨེཝ ཏེ སཪྻྭེ ྅ནྱཱཡོ ཝྱབྷིཙཱརོ དུཥྚཏྭཾ ལོབྷོ ཛིགྷཱཾསཱ ཨཱིརྵྱཱ ཝདྷོ ཝིཝཱདཤྩཱཏུརཱི ཀུམཏིརིཏྱཱདིབྷི རྡུཥྐརྨྨབྷིཿ པརིཔཱུརྞཱཿ སནྟཿ ");
INSERT INTO santib_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ཀརྞེཛཔཱ ཨཔཝཱདིན ཨཱིཤྭརདྭེཥཀཱ ཧིཾསཀཱ ཨཧངྐཱརིཎ ཨཱཏྨཤླཱགྷིནཿ ཀུཀརྨྨོཏྤཱདཀཱཿ པིཏྲོརཱཛྙཱལངྒྷཀཱ ");
INSERT INTO santib_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ཨཝིཙཱརཀཱ ནིཡམལངྒྷིནཿ སྣེཧརཧིཏཱ ཨཏིདྭེཥིཎོ ནིརྡཡཱཤྩ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ཡེ ཛནཱ ཨེཏཱདྲྀཤཾ ཀརྨྨ ཀུཪྻྭནྟི ཏཨེཝ མྲྀཏིཡོགྱཱ ཨཱིཤྭརསྱ ཝིཙཱརམཱིདྲྀཤཾ ཛྙཱཏྭཱཔི ཏ ཨེཏཱདྲྀཤཾ ཀརྨྨ སྭཡཾ ཀུཪྻྭནྟི ཀེཝལམིཏི ནཧི ཀིནྟུ ཏཱདྲྀཤཀརྨྨཀཱརིཥུ ལོཀེཥྭཔི པྲཱིཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ཧེ པརདཱུཥཀ མནུཥྱ ཡཿ ཀཤྩན ཏྭཾ བྷཝསི ཏཝོཏྟརདཱནཱཡ པནྠཱ ནཱསྟི ཡཏོ ཡསྨཱཏ྄ ཀརྨྨཎཿ པརསྟྭཡཱ དཱུཥྱཏེ ཏསྨཱཏ྄ ཏྭམཔི དཱུཥྱསེ, ཡཏསྟཾ དཱུཥཡནྣཔི ཏྭཾ ཏདྭད྄ ཨཱཙརསི། ");
INSERT INTO santib_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ཀིནྟྭེཏཱདྲྀགཱཙཱརིབྷྱོ ཡཾ དཎྜམ྄ ཨཱིཤྭརོ ནིཤྩིནོཏི ས ཡཐཱརྠ ཨིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ཨཏཨེཝ ཧེ མཱནུཥ ཏྭཾ ཡཱདྲྀགཱཙཱརིཎོ དཱུཥཡསི སྭཡཾ ཡདི ཏཱདྲྀགཱཙརསི ཏརྷི ཏྭམ྄ ཨཱིཤྭརདཎྜཱཏ྄ པལཱཡིཏུཾ ཤཀྵྱསཱིཏི ཀིཾ བུདྷྱསེ? ");
INSERT INTO santib_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ཨཔརཾ ཏཝ མནསཿ པརིཝརྟྟནཾ ཀརྟྟུམ྄ ཨིཤྭརསྱཱནུགྲཧོ བྷཝཏི ཏནྣ བུདྡྷྭཱ ཏྭཾ ཀིཾ ཏདཱིཡཱནུགྲཧཀྵམཱཙིརསཧིཥྞུཏྭནིདྷིཾ ཏུཙྪཱིཀརོཥི? ");
INSERT INTO santib_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ཏཐཱ སྭཱནྟཿཀརཎསྱ ཀཋོརཏྭཱཏ྄ ཁེདརཱཧིཏྱཱཙྩེཤྭརསྱ ནྱཱཡྻཝིཙཱརཔྲཀཱཤནསྱ ཀྲོདྷསྱ ཙ དིནཾ ཡཱཝཏ྄ ཀིཾ སྭཱརྠཾ ཀོཔཾ སཉྩིནོཥི? ");
INSERT INTO santib_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ཀིནྟུ ས ཨེཀཻཀམནུཛཱཡ ཏཏྐརྨྨཱནུསཱརེཎ པྲཏིཕལཾ དཱསྱཏི; ");
INSERT INTO santib_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ཝསྟུཏསྟུ ཡེ ཛནཱ དྷཻཪྻྱཾ དྷྲྀཏྭཱ སཏྐརྨྨ ཀུཪྻྭནྟོ མཧིམཱ སཏྐཱརོ྅མརཏྭཉྩཻཏཱནི མྲྀགཡནྟེ ཏེབྷྱོ྅ནནྟཱཡུ རྡཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ཨཔརཾ ཡེ ཛནཱཿ སཏྱདྷརྨྨམ྄ ཨགྲྀཧཱིཏྭཱ ཝིཔརཱིཏདྷརྨྨམ྄ གྲྀཧླནྟི ཏཱདྲྀཤཱ ཝིརོདྷིཛནཱཿ ཀོཔཾ ཀྲོདྷཉྩ བྷོཀྵྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ཨཱ ཡིཧཱུདིནོ྅ནྱདེཤིནཿ པཪྻྱནྟཾ ཡཱཝནྟཿ ཀུཀརྨྨཀཱརིཎཿ པྲཱཎིནཿ སནྟི ཏེ སཪྻྭེ དུཿཁཾ ཡཱཏནཱཉྩ གམིཥྱནྟི; ");
INSERT INTO santib_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ཀིནྟུ ཨཱ ཡིཧཱུདིནོ བྷིནྣདེཤིཔཪྻྱནྟཱ ཡཱཝནྟཿ སཏྐརྨྨཀཱརིཎོ ལོཀཱཿ སནྟི ཏཱན྄ པྲཏི མཧིམཱ སཏྐཱརཿ ཤཱནྟིཤྩ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ཨཱིཤྭརསྱ ཝིཙཱརེ པཀྵཔཱཏོ ནཱསྟི། ");
INSERT INTO santib_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ཨལབྡྷཝྱཝསྠཱཤཱསྟྲཻ ཪྻཻཿ པཱཔཱནི ཀྲྀཏཱནི ཝྱཝསྠཱཤཱསྟྲཱལབྡྷཏྭཱནུརཱུཔསྟེཥཱཾ ཝིནཱཤོ བྷཝིཥྱཏི; ཀིནྟུ ལབྡྷཝྱཝསྠཱཤཱསྟྲཱ ཡེ པཱཔཱནྱཀུཪྻྭན྄ ཝྱཝསྠཱནུསཱརཱདེཝ ཏེཥཱཾ ཝིཙཱརོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ཝྱཝསྠཱཤྲོཏཱར ཨཱིཤྭརསྱ སམཱིཔེ ནིཥྤཱཔཱ བྷཝིཥྱནྟཱིཏི ནཧི ཀིནྟུ ཝྱཝསྠཱཙཱརིཎ ཨེཝ སཔུཎྱཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ཡཏོ ྅ལབྡྷཝྱཝསྠཱཤཱསྟྲཱ བྷིནྣདེཤཱིཡལོཀཱ ཡདི སྭབྷཱཝཏོ ཝྱཝསྠཱནུརཱུཔཱན྄ ཨཱཙཱརཱན྄ ཀུཪྻྭནྟི ཏརྷྱལབྡྷཤཱསྟྲཱཿ སནྟོ྅པི ཏེ སྭེཥཱཾ ཝྱཝསྠཱཤཱསྟྲམིཝ སྭཡམེཝ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ཏེཥཱཾ མནསི སཱཀྵིསྭརཱུཔེ སཏི ཏེཥཱཾ ཝིཏརྐེཥུ ཙ ཀདཱ ཏཱན྄ དོཥིཎཿ ཀདཱ ཝཱ ནིརྡོཥཱན྄ ཀྲྀཏཝཏྶུ ཏེ སྭཱནྟརླིཁིཏསྱ ཝྱཝསྠཱཤཱསྟྲསྱ པྲམཱཎཾ སྭཡམེཝ དདཏི། ");
INSERT INTO santib_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ཡསྨིན྄ དིནེ མཡཱ པྲཀཱཤིཏསྱ སུསཾཝཱདསྱཱནུསཱརཱད྄ ཨཱིཤྭརོ ཡཱིཤུཁྲཱིཥྚེན མཱནུཥཱཎཱམ྄ ཨནྟཿཀརཎཱནཱཾ གཱུཌྷཱབྷིཔྲཱཡཱན྄ དྷྲྀཏྭཱ ཝིཙཱརཡིཥྱཏི ཏསྨིན྄ ཝིཙཱརདིནེ ཏཏ྄ པྲཀཱཤིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","པཤྱ ཏྭཾ སྭཡཾ ཡིཧཱུདཱིཏི ཝིཁྱཱཏོ ཝྱཝསྠོཔརི ཝིཤྭཱསཾ ཀརོཥི, ");
INSERT INTO santib_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ཨཱིཤྭརམུདྡིཤྱ སྭཾ ཤླཱགྷསེ, ཏཐཱ ཝྱཝསྠཡཱ ཤིཀྵིཏོ བྷཱུཏྭཱ ཏསྱཱབྷིམཏཾ ཛཱནཱསི, སཪྻྭཱསཱཾ ཀཐཱནཱཾ སཱརཾ ཝིཝིཾཀྵེ, ");
INSERT INTO santib_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ཨཔརཾ ཛྙཱནསྱ སཏྱཏཱཡཱཤྩཱཀརསྭརཱུཔཾ ཤཱསྟྲཾ མམ སམཱིཔེ ཝིདྱཏ ཨཏོ ྅ནྡྷལོཀཱནཱཾ མཱརྒདརྴཡིཏཱ ");
INSERT INTO santib_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ཏིམིརསྠིཏལོཀཱནཱཾ མདྷྱེ དཱིཔྟིསྭརཱུཔོ྅ཛྙཱནལོཀེབྷྱོ ཛྙཱནདཱཏཱ ཤིཤཱུནཱཾ ཤིཀྵཡིཏཱཧམེཝེཏི མནྱསེ། ");
INSERT INTO santib_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","པརཱན྄ ཤིཀྵཡན྄ སྭཡཾ སྭཾ ཀིཾ ན ཤིཀྵཡསི? ཝསྟུཏཤྩཽཪྻྱནིཥེདྷཝྱཝསྠཱཾ པྲཙཱརཡན྄ ཏྭཾ ཀིཾ སྭཡམེཝ ཙོརཡསི? ");
INSERT INTO santib_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ཏཐཱ པརདཱརགམནཾ པྲཏིཥེདྷན྄ སྭཡཾ ཀིཾ པརདཱརཱན྄ གཙྪསི? ཏཐཱ ཏྭཾ སྭཡཾ པྲཏིམཱདྭེཥཱི སན྄ ཀིཾ མནྡིརསྱ དྲཝྱཱཎི ཧརསི? ");
INSERT INTO santib_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ཡསྟྭཾ ཝྱཝསྠཱཾ ཤླཱགྷསེ ས ཏྭཾ ཀིཾ ཝྱཝསྠཱམ྄ ཨཝམཏྱ ནེཤྭརཾ སམྨནྱསེ? ");
INSERT INTO santib_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ཤཱསྟྲེ ཡཐཱ ལིཁཏི \"བྷིནྣདེཤིནཱཾ སམཱིཔེ ཡུཥྨཱཀཾ དོཥཱད྄ ཨཱིཤྭརསྱ ནཱམྣོ ནིནྡཱ བྷཝཏི། \" ");
INSERT INTO santib_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ཡདི ཝྱཝསྠཱཾ པཱལཡསི ཏརྷི ཏཝ ཏྭཀྪེདཀྲིཡཱ སཕལཱ བྷཝཏི; ཡཏི ཝྱཝསྠཱཾ ལངྒྷསེ ཏརྷི ཏཝ ཏྭཀྪེདོ྅ཏྭཀྪེདོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ཡཏོ ཝྱཝསྠཱཤཱསྟྲཱདིཥྚདྷརྨྨཀརྨྨཱཙཱརཱི པུམཱན྄ ཨཏྭཀྪེདཱི སནྣཔི ཀིཾ ཏྭཀྪེདིནཱཾ མདྷྱེ ན གཎཡིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ཀིནྟུ ལབྡྷཤཱསྟྲཤྪིནྣཏྭཀ྄ ཙ ཏྭཾ ཡདི ཝྱཝསྠཱལངྒྷནཾ ཀརོཥི ཏརྷི ཝྱཝསྠཱཔཱལཀཱཿ སྭཱབྷཱཝིཀཱཙྪིནྣཏྭཙོ ལོཀཱསྟྭཱཾ ཀིཾ ན དཱུཥཡིཥྱནྟི? ");
INSERT INTO santib_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ཏསྨཱད྄ ཡོ བཱཧྱེ ཡིཧཱུདཱི ས ཡིཧཱུདཱི ནཧི ཏཐཱངྒསྱ ཡསྟྭཀྪེདཿ ས ཏྭཀྪེདོ ནཧི; ");
INSERT INTO santib_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ཀིནྟུ ཡོ ཛན ཨཱནྟརིཀོ ཡིཧཱུདཱི ས ཨེཝ ཡིཧཱུདཱི ཨཔརཉྩ ཀེཝལལིཁིཏཡཱ ཝྱཝསྠཡཱ ན ཀིནྟུ མཱནསིཀོ ཡསྟྭཀྪེདོ ཡསྱ ཙ པྲཤཾསཱ མནུཥྱེབྷྱོ ན བྷཱུཏྭཱ ཨཱིཤྭརཱད྄ བྷཝཏི ས ཨེཝ ཏྭཀྪེདཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ཨཔརཉྩ ཡིཧཱུདིནཿ ཀིཾ ཤྲེཥྛཏྭཾ? ཏཐཱ ཏྭཀྪེདསྱ ཝཱ ཀིཾ ཕལཾ? ");
INSERT INTO santib_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","སཪྻྭཐཱ བཧཱུནི ཕལཱནི སནྟི, ཝིཤེཥཏ ཨཱིཤྭརསྱ ཤཱསྟྲཾ ཏེབྷྱོ྅དཱིཡཏ། ");
INSERT INTO santib_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ཀཻཤྩིད྄ ཨཝིཤྭསནེ ཀྲྀཏེ ཏེཥཱམ྄ ཨཝིཤྭསནཱཏ྄ ཀིམ྄ ཨཱིཤྭརསྱ ཝིཤྭཱསྱཏཱཡཱ ཧཱནིརུཏྤཏྶྱཏེ? ");
INSERT INTO santib_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ཀེནཱཔི པྲཀཱརེཎ ནཧི། ཡདྱཔི སཪྻྭེ མནུཥྱཱ མིཐྱཱཝཱདིནསྟཐཱཔཱིཤྭརཿ སཏྱཝཱདཱི། ཤཱསྟྲེ ཡཐཱ ལིཁིཏམཱསྟེ, ཨཏསྟྭནྟུ སྭཝཱཀྱེན ནིརྡྡོཥོ ཧི བྷཝིཥྱསི། ཝིཙཱརེ ཙཻཝ ནིཥྤཱཔོ བྷཝིཥྱསི ན སཾཤཡཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ཨསྨཱཀམ྄ ཨནྱཱཡེན ཡདཱིཤྭརསྱ ནྱཱཡཿ པྲཀཱཤཏེ ཏརྷི ཀིཾ ཝདིཥྱཱམཿ? ཨཧཾ མཱནུཥཱཎཱཾ ཀཐཱམིཝ ཀཐཱཾ ཀཐཡཱམི, ཨཱིཤྭརཿ སམུཙིཏཾ དཎྜཾ དཏྟྭཱ ཀིམ྄ ཨནྱཱཡཱི བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ཨིཏྠཾ ན བྷཝཏུ, ཏཐཱ སཏཱིཤྭརཿ ཀཐཾ ཛགཏོ ཝིཙཱརཡིཏཱ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","མམ མིཐྱཱཝཱཀྱཝདནཱད྄ ཡདཱིཤྭརསྱ སཏྱཏྭེན ཏསྱ མཧིམཱ ཝརྡྡྷཏེ ཏརྷི ཀསྨཱདཧཾ ཝིཙཱརེ྅པརཱདྷིཏྭེན གཎྱོ བྷཝཱམི? ");
INSERT INTO santib_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","མངྒལཱརྠཾ པཱཔམཔི ཀརཎཱིཡམིཏི ཝཱཀྱཾ ཏྭཡཱ ཀུཏོ ནོཙྱཏེ? ཀིནྟུ ཡཻརུཙྱཏེ ཏེ ནིཏཱནྟཾ དཎྜསྱ པཱཏྲཱཎི བྷཝནྟི; ཏཐཱཔི ཏདྭཱཀྱམ྄ ཨསྨཱབྷིརཔྱུཙྱཏ ཨིཏྱསྨཱཀཾ གླཱནིཾ ཀུཪྻྭནྟཿ ཀིཡནྟོ ལོཀཱ ཝདནྟི། ");
INSERT INTO santib_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ཨནྱལོཀེབྷྱོ ཝཡཾ ཀིཾ ཤྲེཥྛཱཿ? ཀདཱཙན ནཧི ཡཏོ ཡིཧཱུདིནོ ྅ནྱདེཤིནཤྩ སཪྻྭཨེཝ པཱཔསྱཱཡཏྟཱ ཨིཏྱསྱ པྲམཱཎཾ ཝཡཾ པཱུཪྻྭམ྄ ཨདདཱམ། ");
INSERT INTO santib_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ལིཔི ཪྻཐཱསྟེ, ནཻཀོཔི དྷཱརྨྨིཀོ ཛནཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ཏཐཱ ཛྙཱནཱིཤྭརཛྙཱནཱི མཱནཝཿ ཀོཔི ནཱསྟི ཧི། ");
INSERT INTO santib_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ཝིམཱརྒགཱམིནཿ སཪྻྭེ སཪྻྭེ དུཥྐརྨྨཀཱརིཎཿ། ཨེཀོ ཛནོཔི ནོ ཏེཥཱཾ སཱདྷུཀརྨྨ ཀརོཏི ཙ། ");
INSERT INTO santib_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ཏཐཱ ཏེཥཱནྟུ ཝཻ ཀཎྛཱ ཨནཱཝྲྀཏཤྨཤཱནཝཏ྄། སྟུཏིཝཱདཾ པྲཀུཪྻྭནྟི ཛིཧྭཱབྷིསྟེ ཏུ ཀེཝལཾ། ཏེཥཱམོཥྛསྱ ནིམྣེ ཏུ ཝིཥཾ ཏིཥྛཏི སརྤྤཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","མུཁཾ ཏེཥཱཾ ཧི ཤཱཔེན ཀཔཊེན ཙ པཱུཪྻྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","རཀྟཔཱཏཱཡ ཏེཥཱཾ ཏུ པདཱནི ཀྵིཔྲགཱནི ཙ། ");
INSERT INTO santib_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","པཐི ཏེཥཱཾ མནུཥྱཱཎཱཾ ནཱཤཿ ཀླེཤཤྩ ཀེཝལཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ཏེ ཛནཱ ནཧི ཛཱནནྟི པནྠཱནཾ སུཁདཱཡིནཾ། ");
INSERT INTO santib_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","པརམེཤཱད྄ བྷཡཾ ཡཏྟཏ྄ ཏཙྩཀྵུཥོརགོཙརཾ། ");
INSERT INTO santib_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ཝྱཝསྠཱཡཱཾ ཡདྱལླིཁཏི ཏད྄ ཝྱཝསྠཱདྷཱིནཱན྄ ལོཀཱན྄ ཨུདྡིཤྱ ལིཁཏཱིཏི ཝཡཾ ཛཱནཱིམཿ། ཏཏོ མནུཥྱམཱཏྲོ ནིརུཏྟརཿ སན྄ ཨཱིཤྭརསྱ སཱཀྵཱད྄ ཨཔརཱདྷཱི བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ཨཏཨེཝ ཝྱཝསྠཱནུརཱུཔཻཿ ཀརྨྨབྷིཿ ཀཤྩིདཔི པྲཱཎཱིཤྭརསྱ སཱཀྵཱཏ྄ སཔུཎྱཱིཀྲྀཏོ བྷཝིཏུཾ ན ཤཀྵྱཏི ཡཏོ ཝྱཝསྠཡཱ པཱཔཛྙཱནམཱཏྲཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ཀིནྟུ ཝྱཝསྠཱཡཱཿ པྲྀཐག྄ ཨཱིཤྭརེཎ དེཡཾ ཡཏ྄ པུཎྱཾ ཏད྄ ཝྱཝསྠཱཡཱ བྷཝིཥྱདྭཱདིགཎསྱ ཙ ཝཙནཻཿ པྲམཱཎཱིཀྲྀཏཾ སད྄ ཨིདཱནཱིཾ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ཡཱིཤུཁྲཱིཥྚེ ཝིཤྭཱསཀརཎཱད྄ ཨཱིཤྭརེཎ དཏྟཾ ཏཏ྄ པུཎྱཾ སཀལེཥུ པྲཀཱཤིཏཾ སཏ྄ སཪྻྭཱན྄ ཝིཤྭཱསིནཿ པྲཏི ཝརྟྟཏེ། ");
INSERT INTO santib_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ཏེཥཱཾ ཀོཔི པྲབྷེདོ ནཱསྟི, ཡཏཿ སཪྻྭཨེཝ པཱཔིན ཨཱིཤྭརཱིཡཏེཛོཧཱིནཱཤྩ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ཏ ཨཱིཤྭརསྱཱནུགྲཧཱད྄ མཱུལྱཾ ཝིནཱ ཁྲཱིཥྚཀྲྀཏེན པརིཏྲཱཎེན སཔུཎྱཱིཀྲྀཏཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ཡསྨཱཏ྄ སྭཤོཎིཏེན ཝིཤྭཱསཱཏ྄ པཱཔནཱཤཀོ བལཱི བྷཝིཏུཾ ས ཨེཝ པཱུཪྻྭམ྄ ཨཱིཤྭརེཎ ནིཤྩིཏཿ, ཨིཏྠམ྄ ཨཱིཤྭརཱིཡསཧིཥྞུཏྭཱཏ྄ པུརཱཀྲྀཏཔཱཔཱནཱཾ མཱརྫྫནཀརཎེ སྭཱིཡཡཱཐཱརྠྱཾ ཏེན པྲཀཱཤྱཏེ, ");
INSERT INTO santib_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ཝརྟྟམཱནཀཱལཱིཡམཔི སྭཡཱཐཱརྠྱཾ ཏེན པྲཀཱཤྱཏེ, ཨཔརཾ ཡཱིཤཽ ཝིཤྭཱསིནཾ སཔུཎྱཱིཀུཪྻྭནྣཔི ས ཡཱཐཱརྠིཀསྟིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ཏརྷི ཀུཏྲཱཏྨཤླཱགྷཱ? སཱ དཱུརཱིཀྲྀཏཱ; ཀཡཱ ཝྱཝསྠཡཱ? ཀིཾ ཀྲིཡཱརཱུཔཝྱཝསྠཡཱ? ཨིཏྠཾ ནཧི ཀིནྟུ ཏཏ྄ ཀེཝལཝིཤྭཱསརཱུཔཡཱ ཝྱཝསྠཡཻཝ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ཨཏཨེཝ ཝྱཝསྠཱནུརཱུཔཱཿ ཀྲིཡཱ ཝིནཱ ཀེཝལེན ཝིཤྭཱསེན མཱནཝཿ སཔུཎྱཱིཀྲྀཏོ བྷཝིཏུཾ ཤཀྣོཏཱིཏྱསྱ རཱདྡྷཱནྟཾ དརྴཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ས ཀིཾ ཀེཝལཡིཧཱུདིནཱམ྄ ཨཱིཤྭརོ བྷཝཏི? བྷིནྣདེཤིནཱམ྄ ཨཱིཤྭརོ ན བྷཝཏི? བྷིནྣདེཤིནཱམཔི བྷཝཏི; ");
INSERT INTO santib_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ཡསྨཱད྄ ཨེཀ ཨཱིཤྭརོ ཝིཤྭཱསཱཏ྄ ཏྭཀྪེདིནོ ཝིཤྭཱསེནཱཏྭཀྪེདིནཤྩ སཔུཎྱཱིཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ཏརྷི ཝིཤྭཱསེན ཝཡཾ ཀིཾ ཝྱཝསྠཱཾ ལུམྤཱམ? ཨིཏྠཾ ན བྷཝཏུ ཝཡཾ ཝྱཝསྠཱཾ སཾསྠཱཔཡཱམ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ཨསྨཱཀཾ པཱུཪྻྭཔུརུཥ ཨིབྲཱཧཱིམ྄ ཀཱཡིཀཀྲིཡཡཱ ཀིཾ ལབྡྷཝཱན྄ ཨེཏདདྷི ཀིཾ ཝདིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ས ཡདི ནིཛཀྲིཡཱབྷྱཿ སཔུཎྱོ བྷཝེཏ྄ ཏརྷི ཏསྱཱཏྨཤླཱགྷཱཾ ཀརྟྟུཾ པནྠཱ བྷཝེདིཏི སཏྱཾ, ཀིནྟྭཱིཤྭརསྱ སམཱིཔེ ནཧི། ");
INSERT INTO santib_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ཤཱསྟྲེ ཀིཾ ལིཁཏི? ཨིབྲཱཧཱིམ྄ ཨཱིཤྭརེ ཝིཤྭསནཱཏ྄ ས ཝིཤྭཱསསྟསྨཻ པུཎྱཱརྠཾ གཎིཏོ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ཀརྨྨཀཱརིཎོ ཡད྄ ཝེཏནཾ ཏད྄ ཨནུགྲཧསྱ ཕལཾ ནཧི ཀིནྟུ ཏེནོཔཱརྫིཏཾ མནྟཝྱམ྄། ");
INSERT INTO santib_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ཀིནྟུ ཡཿ པཱཔིནཾ སཔུཎྱཱིཀརོཏི ཏསྨིན྄ ཝིཤྭཱསིནཿ ཀརྨྨཧཱིནསྱ ཛནསྱ ཡོ ཝིཤྭཱསཿ ས པུཎྱཱརྠཾ གཎྱོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ཨཔརཾ ཡཾ ཀྲིཡཱཧཱིནམ྄ ཨཱིཤྭརཿ སཔུཎྱཱིཀརོཏི ཏསྱ དྷནྱཝཱདཾ དཱཡཱུད྄ ཝརྞཡཱམཱས, ཡཐཱ, ");
INSERT INTO santib_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ས དྷནྱོ྅གྷཱནི མྲྀཥྚཱནི ཡསྱཱགཱཾསྱཱཝྲྀཏཱནི ཙ། ");
INSERT INTO santib_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ས ཙ དྷནྱཿ པརེཤེན པཱཔཾ ཡསྱ ན གཎྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ཨེཥ དྷནྱཝཱདསྟྭཀྪེདིནམ྄ ཨཏྭཀྪེདིནཾ ཝཱ ཀཾ པྲཏི བྷཝཏི? ཨིབྲཱཧཱིམོ ཝིཤྭཱསཿ པུཎྱཱརྠཾ གཎིཏ ཨིཏི ཝཡཾ ཝདཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ས ཝིཤྭཱསསྟསྱ ཏྭཀྪེདིཏྭཱཝསྠཱཡཱཾ ཀིམ྄ ཨཏྭཀྪེདིཏྭཱཝསྠཱཡཱཾ ཀསྨིན྄ སམཡེ པུཎྱམིཝ གཎིཏཿ? ཏྭཀྪེདིཏྭཱཝསྠཱཡཱཾ ནཧི ཀིནྟྭཏྭཀྪེདིཏྭཱཝསྠཱཡཱཾ། ");
INSERT INTO santib_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ཨཔརཉྩ ས ཡཏ྄ སཪྻྭེཥཱམ྄ ཨཏྭཀྪེདིནཱཾ ཝིཤྭཱསིནཱམ྄ ཨཱདིཔུརུཥོ བྷཝེཏ྄, ཏེ ཙ པུཎྱཝཏྟྭེན གཎྱེརན྄; ");
INSERT INTO santib_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ཡེ ཙ ལོཀཱཿ ཀེཝལཾ ཚིནྣཏྭཙོ ན སནྟོ ྅སྨཏྤཱུཪྻྭཔུརུཥ ཨིབྲཱཧཱིམ྄ ཨཚིནྣཏྭཀ྄ སན྄ ཡེན ཝིཤྭཱསམཱརྒེཎ གཏཝཱན྄ ཏེནཻཝ ཏསྱ པཱདཙིཧྣེན གཙྪནྟི ཏེཥཱཾ ཏྭཀྪེདིནཱམཔྱཱདིཔུརུཥོ བྷཝེཏ྄ ཏདརྠམ྄ ཨཏྭཀྪེདིནོ མཱནཝསྱ ཝིཤྭཱསཱཏ྄ པུཎྱམ྄ ཨུཏྤདྱཏ ཨིཏི པྲམཱཎསྭརཱུཔཾ ཏྭཀྪེདཙིཧྣཾ ས པྲཱཔྣོཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ཨིབྲཱཧཱིམ྄ ཛགཏོ྅དྷིཀཱརཱི བྷཝིཥྱཏི ཡཻཥཱ པྲཏིཛྙཱ ཏཾ ཏསྱ ཝཾཤཉྩ པྲཏི པཱུཪྻྭམ྄ ཨཀྲིཡཏ སཱ ཝྱཝསྠཱམཱུལིཀཱ ནཧི ཀིནྟུ ཝིཤྭཱསཛནྱཔུཎྱམཱུལིཀཱ། ");
INSERT INTO santib_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ཡཏོ ཝྱཝསྠཱཝལམྦིནོ ཡདྱདྷིཀཱརིཎོ བྷཝནྟི ཏརྷི ཝིཤྭཱསོ ཝིཕལོ ཛཱཡཏེ སཱ པྲཏིཛྙཱཔི ལུཔྟཻཝ། ");
INSERT INTO santib_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ཨདྷིཀནྟུ ཝྱཝསྠཱ ཀོཔཾ ཛནཡཏི ཡཏོ ྅ཝིདྱམཱནཱཡཱཾ ཝྱཝསྠཱཡཱམ྄ ཨཱཛྙཱལངྒྷནཾ ན སམྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ཨཏཨེཝ སཱ པྲཏིཛྙཱ ཡད྄ ཨནུགྲཧསྱ ཕལཾ བྷཝེཏ྄ ཏདརྠཾ ཝིཤྭཱསམཱུལིཀཱ ཡཏསྟཐཱཏྭེ ཏདྭཾཤསམུདཱཡཾ པྲཏི ཨརྠཏོ ཡེ ཝྱཝསྠཡཱ ཏདྭཾཤསམྦྷཝཱཿ ཀེཝལཾ ཏཱན྄ པྲཏི ནཧི ཀིནྟུ ཡ ཨིབྲཱཧཱིམཱིཡཝིཤྭཱསེན ཏཏྶམྦྷཝཱསྟཱནཔི པྲཏི སཱ པྲཏིཛྙཱ སྠཱསྣུརྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ཡོ ནིརྫཱིཝཱན྄ སཛཱིཝཱན྄ ཨཝིདྱམཱནཱནི ཝསྟཱུནི ཙ ཝིདྱམཱནཱནི ཀརོཏི ཨིབྲཱཧཱིམོ ཝིཤྭཱསབྷཱུམེསྟསྱེཤྭརསྱ སཱཀྵཱཏ྄ སོ྅སྨཱཀཾ སཪྻྭེཥཱམ྄ ཨཱདིཔུརུཥ ཨཱསྟེ, ཡཐཱ ལིཁིཏཾ ཝིདྱཏེ, ཨཧཾ ཏྭཱཾ བཧུཛཱཏཱིནཱམ྄ ཨཱདིཔུརུཥཾ ཀྲྀཏྭཱ ནིཡུཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ཏྭདཱིཡསྟཱདྲྀཤོ ཝཾཤོ ཛནིཥྱཏེ ཡདིདཾ ཝཱཀྱཾ པྲཏིཤྲུཏཾ ཏདནུསཱརཱད྄ ཨིབྲཱཧཱིམ྄ བཧུདེཤཱིཡལོཀཱནཱམ྄ ཨཱདིཔུརུཥོ ཡད྄ བྷཝཏི ཏདརྠཾ སོ྅ནཔེཀྵིཏཝྱམཔྱཔེཀྵམཱཎོ ཝིཤྭཱསཾ ཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ཨཔརཉྩ ཀྵཱིཎཝིཤྭཱསོ ན བྷཱུཏྭཱ ཤཏཝཏྶརཝཡསྐཏྭཱཏ྄ སྭཤརཱིརསྱ ཛརཱཾ སཱརཱནཱམྣཿ སྭབྷཱཪྻྱཱཡཱ རཛོནིཝྲྀཏྟིཉྩ ཏྲྀཎཱཡ ན མེནེ། ");
INSERT INTO santib_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ཨཔརམ྄ ཨཝིཤྭཱསཱད྄ ཨཱིཤྭརསྱ པྲཏིཛྙཱཝཙནེ ཀམཔི སཾཤཡཾ ན ཙཀཱར; ");
INSERT INTO santib_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ཀིནྟྭཱིཤྭརེཎ ཡཏ྄ པྲཏིཤྲུཏཾ ཏཏ྄ སཱདྷཡིཏུཾ ཤཀྱཏ ཨིཏི ནིཤྩིཏཾ ཝིཛྙཱཡ དྲྀཌྷཝིཤྭཱསཿ སན྄ ཨཱིཤྭརསྱ མཧིམཱནཾ པྲཀཱཤཡཱཉྩཀཱར། ");
INSERT INTO santib_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ཨིཏི ཧེཏོསྟསྱ ས ཝིཤྭཱསསྟདཱིཡཔུཎྱམིཝ གཎཡཱཉྩཀྲེ། ");
INSERT INTO santib_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","པུཎྱམིཝཱགཎྱཏ ཏཏ྄ ཀེཝལསྱ ཏསྱ ནིམིཏྟཾ ལིཁིཏཾ ནཧི, ཨསྨཱཀཾ ནིམིཏྟམཔི, ");
INSERT INTO santib_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ཡཏོ྅སྨཱཀཾ པཱཔནཱཤཱརྠཾ སམརྤིཏོ྅སྨཱཀཾ པུཎྱཔྲཱཔྟྱརྠཉྩོཏྠཱཔིཏོ྅བྷཝཏ྄ ཡོ྅སྨཱཀཾ པྲབྷུ ཪྻཱིཤུསྟསྱོཏྠཱཔཡིཏརཱིཤྭརེ ");
INSERT INTO santib_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ཡདི ཝཡཾ ཝིཤྭསཱམསྟརྷྱསྨཱཀམཔི སཨེཝ ཝིཤྭཱསཿ པུཎྱམིཝ གཎཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ཝིཤྭཱསེན སཔུཎྱཱིཀྲྀཏཱ ཝཡམ྄ ཨཱིཤྭརེཎ སཱརྡྡྷཾ པྲབྷུཎཱསྨཱཀཾ ཡཱིཤུཁྲཱིཥྚེན མེལནཾ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ཨཔརཾ ཝཡཾ ཡསྨིན྄ ཨནུགྲཧཱཤྲཡེ ཏིཥྛཱམསྟནྨདྷྱཾ ཝིཤྭཱསམཱརྒེཎ ཏེནཻཝཱནཱིཏཱ ཝཡམ྄ ཨཱིཤྭརཱིཡཝིབྷཝཔྲཱཔྟིཔྲཏྱཱཤཡཱ སམཱནནྡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ཏཏ྄ ཀེཝལཾ ནཧི ཀིནྟུ ཀླེཤབྷོགེ྅པྱཱནནྡཱམོ ཡཏཿ ཀླེཤཱाད྄ དྷཻཪྻྱཾ ཛཱཡཏ ཨིཏི ཝཡཾ ཛཱནཱིམཿ, ");
INSERT INTO santib_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","དྷཻཪྻྱཱཙྩ པརཱིཀྵིཏཏྭཾ ཛཱཡཏེ, པརཱིཀྵིཏཏྭཱཏ྄ པྲཏྱཱཤཱ ཛཱཡཏེ, ");
INSERT INTO santib_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","པྲཏྱཱཤཱཏོ ཝྲཱིཌིཏཏྭཾ ན ཛཱཡཏེ, ཡསྨཱད྄ ཨསྨབྷྱཾ དཏྟེན པཝིཏྲེཎཱཏྨནཱསྨཱཀམ྄ ཨནྟཿཀརཎཱནཱིཤྭརསྱ པྲེམཝཱརིཎཱ སིཀྟཱནི། ");
INSERT INTO santib_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ཨསྨཱསུ ནིརུཔཱཡེཥུ སཏྶུ ཁྲཱིཥྚ ཨུཔཡུཀྟེ སམཡེ པཱཔིནཱཾ ནིམིཏྟཾ སྭཱིཡཱན྄ པྲཎཱན྄ ཨཏྱཛཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ཧིཏཀཱརིཎོ ཛནསྱ ཀྲྀཏེ ཀོཔི པྲཎཱན྄ ཏྱཀྟུཾ སཱཧསཾ ཀརྟྟུཾ ཤཀྣོཏི, ཀིནྟུ དྷཱརྨྨིཀསྱ ཀྲྀཏེ པྲཱཡེཎ ཀོཔི པྲཱཎཱན྄ ན ཏྱཛཏི། ");
INSERT INTO santib_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ཀིནྟྭསྨཱསུ པཱཔིཥུ སཏྶྭཔི ནིམིཏྟམསྨཱཀཾ ཁྲཱིཥྚཿ སྭཔྲཱཎཱན྄ ཏྱཀྟཝཱན྄, ཏཏ ཨཱིཤྭརོསྨཱན྄ པྲཏི ནིཛཾ པརམཔྲེམཱཎཾ དརྴིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ཨཏཨེཝ ཏསྱ རཀྟཔཱཏེན སཔུཎྱཱིཀྲྀཏཱ ཝཡཾ ནིཏཱནྟཾ ཏེན ཀོཔཱད྄ ཨུདྡྷཱརིཥྱཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ཕལཏོ ཝཡཾ ཡདཱ རིཔཝ ཨཱསྨ ཏདེཤྭརསྱ པུཏྲསྱ མརཎེན ཏེན སཱརྡྡྷཾ ཡདྱསྨཱཀཾ མེལནཾ ཛཱཏཾ ཏརྷི མེལནཔྲཱཔྟཱཿ སནྟོ྅ཝཤྱཾ ཏསྱ ཛཱིཝནེན རཀྵཱཾ ལཔྶྱཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ཏཏ྄ ཀེཝལཾ ནཧི ཀིནྟུ ཡེན མེལནམ྄ ཨལབྷཱམཧི ཏེནཱསྨཱཀཾ པྲབྷུཎཱ ཡཱིཤུཁྲཱིཥྚེན སཱམྤྲཏམ྄ ཨཱིཤྭརེ སམཱནནྡཱམཤྩ། ");
INSERT INTO santib_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ཏཐཱ སཏི, ཨེཀེན མཱནུཥེཎ པཱཔཾ པཱཔེན ཙ མརཎཾ ཛགཏཱིཾ པྲཱཝིཤཏ྄ ཨཔརཾ སཪྻྭེཥཱཾ པཱཔིཏྭཱཏ྄ སཪྻྭེ མཱནུཥཱ མྲྀཏེ རྣིགྷྣཱ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ཡཏོ ཝྱཝསྠཱདཱནསམཡཾ ཡཱཝཏ྄ ཛགཏི པཱཔམ྄ ཨཱསཱིཏ྄ ཀིནྟུ ཡཏྲ ཝྱཝསྠཱ ན ཝིདྱཏེ ཏཏྲ པཱཔསྱཱཔི གཎནཱ ན ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ཏཐཱཔྱཱདམཱ ཡཱདྲྀཤཾ པཱཔཾ ཀྲྀཏཾ ཏཱདྲྀཤཾ པཱཔཾ ཡཻ རྣཱཀཱརི ཨཱདམམ྄ ཨཱརབྷྱ མཱུསཱཾ ཡཱཝཏ྄ ཏེཥཱམཔྱུཔརི མྲྀཏྱཱུ རཱཛཏྭམ྄ ཨཀརོཏ྄ ས ཨཱདམ྄ བྷཱཝྱཱདམོ ནིདརྴནམེཝཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ཀིནྟུ པཱཔཀརྨྨཎོ ཡཱདྲྀཤོ བྷཱཝསྟཱདྲྀག྄ དཱནཀརྨྨཎོ བྷཱཝོ ན བྷཝཏི ཡཏ ཨེཀསྱ ཛནསྱཱཔརཱདྷེན ཡདི བཧཱུནཱཾ མརཎམ྄ ཨགྷཊཏ ཏཐཱཔཱིཤྭརཱནུགྲཧསྟདནུགྲཧམཱུལཀཾ དཱནཉྩཻཀེན ཛནེནཱརྠཱད྄ ཡཱིཤུནཱ ཁྲཱིཥྚེན བཧུཥུ བཱཧུལྱཱཏིབཱཧུལྱེན ཕལཏི། ");
INSERT INTO santib_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ཨཔརམ྄ ཨེཀསྱ ཛནསྱ པཱཔཀརྨྨ ཡཱདྲྀཀ྄ ཕལཡུཀྟཾ དཱནཀརྨྨ ཏཱདྲྀཀ྄ ན བྷཝཏི ཡཏོ ཝིཙཱརཀརྨྨཻཀཾ པཱཔམ྄ ཨཱརབྷྱ དཎྜཛནཀཾ བབྷཱུཝ, ཀིནྟུ དཱནཀརྨྨ བཧུཔཱཔཱནྱཱརབྷྱ པུཎྱཛནཀཾ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ཡཏ ཨེཀསྱ ཛནསྱ པཱཔཀརྨྨཏསྟེནཻཀེན ཡདི མརཎསྱ རཱཛཏྭཾ ཛཱཏཾ ཏརྷི ཡེ ཛནཱ ཨནུགྲཧསྱ བཱཧུལྱཾ པུཎྱདཱནཉྩ པྲཱཔྣུཝནྟི ཏ ཨེཀེན ཛནེན, ཨརྠཱཏ྄ ཡཱིཤུཁྲཱིཥྚེན, ཛཱིཝནེ རཱཛཏྭམ྄ ཨཝཤྱཾ ཀརིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ཨེཀོ྅པརཱདྷོ ཡདྭཏ྄ སཪྻྭམཱནཝཱནཱཾ དཎྜགཱམཱི མཱརྒོ ྅བྷཝཏ྄ ཏདྭད྄ ཨེཀཾ པུཎྱདཱནཾ སཪྻྭམཱནཝཱནཱཾ ཛཱིཝནཡུཀྟཔུཎྱགཱམཱི མཱརྒ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ཨཔརམ྄ ཨེཀསྱ ཛནསྱཱཛྙཱལངྒྷནཱད྄ ཡཐཱ བཧཝོ ྅པརཱདྷིནོ ཛཱཏཱསྟདྭད྄ ཨེཀསྱཱཛྙཱཙརཎཱད྄ བཧཝཿ སཔུཎྱཱིཀྲྀཏཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ཨདྷིཀནྟུ ཝྱཝསྠཱགམནཱད྄ ཨཔརཱདྷསྱ བཱཧུལྱཾ ཛཱཏཾ ཀིནྟུ ཡཏྲ པཱཔསྱ བཱཧུལྱཾ ཏཏྲཻཝ ཏསྨཱད྄ ཨནུགྲཧསྱ བཱཧུལྱམ྄ ཨབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ཏེན མྲྀཏྱུནཱ ཡདྭཏ྄ པཱཔསྱ རཱཛཏྭམ྄ ཨབྷཝཏ྄ ཏདྭད྄ ཨསྨཱཀཾ པྲབྷུཡཱིཤུཁྲཱིཥྚདྭཱརཱནནྟཛཱིཝནདཱཡིཔུཎྱེནཱནུགྲཧསྱ རཱཛཏྭཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","པྲབྷཱུཏརཱུཔེཎ ཡད྄ ཨནུགྲཧཿ པྲཀཱཤཏེ ཏདརྠཾ པཱཔེ ཏིཥྛཱམ ཨིཏི ཝཱཀྱཾ ཀིཾ ཝཡཾ ཝདིཥྱཱམཿ? ཏནྣ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","པཱཔཾ པྲཏི མྲྀཏཱ ཝཡཾ པུནསྟསྨིན྄ ཀཐམ྄ ཛཱིཝིཥྱཱམཿ? ");
INSERT INTO santib_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ཝཡཾ ཡཱཝནྟོ ལོཀཱ ཡཱིཤུཁྲཱིཥྚེ མཛྫིཏཱ ཨབྷཝཱམ ཏཱཝནྟ ཨེཝ ཏསྱ མརཎེ མཛྫིཏཱ ཨིཏི ཀིཾ ཡཱུཡཾ ན ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ཏཏོ ཡཐཱ པིཏུཿ པརཱཀྲམེཎ ཤྨཤཱནཱཏ྄ ཁྲཱིཥྚ ཨུཏྠཱཔིཏསྟཐཱ ཝཡམཔི ཡཏ྄ ནཱུཏནཛཱིཝིན ཨིཝཱཙརཱམསྟདརྠཾ མཛྫནེན ཏེན སཱརྡྡྷཾ མྲྀཏྱུརཱུཔེ ཤྨཤཱནེ སཾསྠཱཔིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ཨཔརཾ ཝཡཾ ཡདི ཏེན སཾཡུཀྟཱཿ སནྟཿ ས ཨིཝ མརཎབྷཱགིནོ ཛཱཏཱསྟརྷི ས ཨིཝོཏྠཱནབྷཱགིནོ྅པི བྷཝིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ཝཡཾ ཡཏ྄ པཱཔསྱ དཱསཱཿ པུན རྣ བྷཝཱམསྟདརྠམ྄ ཨསྨཱཀཾ པཱཔརཱུཔཤརཱིརསྱ ཝིནཱཤཱརྠམ྄ ཨསྨཱཀཾ པུརཱཏནཔུརུཥསྟེན སཱཀཾ ཀྲུཤེ྅ཧནྱཏེཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ཡོ ཧཏཿ ས པཱཔཱཏ྄ མུཀྟ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ཨཏཨེཝ ཡདི ཝཡཾ ཁྲཱིཥྚེན སཱརྡྡྷམ྄ ཨཧནྱཱམཧི ཏརྷི པུནརཔི ཏེན སཧིཏཱ ཛཱིཝིཥྱཱམ ཨིཏྱཏྲཱསྨཱཀཾ ཝིཤྭཱསོ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ཡཏཿ ཤྨཤཱནཱད྄ ཨུཏྠཱཔིཏཿ ཁྲཱིཥྚོ པུན རྣ མྲིཡཏ ཨིཏི ཝཡཾ ཛཱནཱིམཿ། ཏསྨིན྄ ཀོཔྱདྷིཀཱརོ མྲྀཏྱོ རྣཱསྟི། ");
INSERT INTO santib_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ཨཔརཉྩ ས ཡད྄ ཨམྲིཡཏ ཏེནཻཀདཱ པཱཔམ྄ ཨུདྡིཤྱཱམྲིཡཏ, ཡཙྩ ཛཱིཝཏི ཏེནེཤྭརམ྄ ཨུདྡིཤྱ ཛཱིཝཏི; ");
INSERT INTO santib_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ཏདྭད྄ ཡཱུཡམཔི སྭཱན྄ པཱཔམ྄ ཨུདྡིཤྱ མྲྀཏཱན྄ ཨསྨཱཀཾ པྲབྷུཎཱ ཡཱིཤུཁྲཱིཥྚེནེཤྭརམ྄ ཨུདྡིཤྱ ཛཱིཝནྟོ ཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ཨཔརཉྩ ཀུཏྶིཏཱབྷིལཱཥཱाན྄ པཱུརཡིཏུཾ ཡུཥྨཱཀཾ མརྟྱདེཧེཥུ པཱཔམ྄ ཨཱདྷིཔཏྱཾ ན ཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ཨཔརཾ སྭཾ སྭམ྄ ཨངྒམ྄ ཨདྷརྨྨསྱཱསྟྲཾ ཀྲྀཏྭཱ པཱཔསེཝཱཡཱཾ ན སམརྤཡཏ, ཀིནྟུ ཤྨཤཱནཱད྄ ཨུཏྠིཏཱནིཝ སྭཱན྄ ཨཱིཤྭརེ སམརྤཡཏ སྭཱནྱངྒཱནི ཙ དྷརྨྨཱསྟྲསྭརཱུཔཱཎཱིཤྭརམ྄ ཨུདྡིཤྱ སམརྤཡཏ། ");
INSERT INTO santib_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ཡུཥྨཱཀམ྄ ཨུཔརི པཱཔསྱཱདྷིཔཏྱཾ པུན རྣ བྷཝིཥྱཏི, ཡསྨཱད྄ ཡཱུཡཾ ཝྱཝསྠཱཡཱ ཨནཱཡཏྟཱ ཨནུགྲཧསྱ ཙཱཡཏྟཱ ཨབྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ཀིནྟུ ཝཡཾ ཝྱཝསྠཱཡཱ ཨནཱཡཏྟཱ ཨནུགྲཧསྱ ཙཱཡཏྟཱ ཨབྷཝཱམ, ཨིཏི ཀཱརཎཱཏ྄ ཀིཾ པཱཔཾ ཀརིཥྱཱམཿ? ཏནྣ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ཡཏོ མྲྀཏིཛནཀཾ པཱཔཾ པུཎྱཛནཀཾ ནིདེཤཱཙརཎཉྩཻཏཡོརྡྭཡོ ཪྻསྨིན྄ ཨཱཛྙཱཔཱལནཱརྠཾ བྷྲྀཏྱཱནིཝ སྭཱན྄ སམརྤཡཐ, ཏསྱཻཝ བྷྲྀཏྱཱ བྷཝཐ, ཨེཏཏ྄ ཀིཾ ཡཱུཡཾ ན ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ཨཔརཉྩ པཱུཪྻྭཾ ཡཱུཡཾ པཱཔསྱ བྷྲྀཏྱཱ ཨཱསྟེཏི སཏྱཾ ཀིནྟུ ཡསྱཱཾ ཤིཀྵཱརཱུཔཱཡཱཾ མཱུཥཱཡཱཾ ནིཀྵིཔྟཱ ཨབྷཝཏ ཏསྱཱ ཨཱཀྲྀཏིཾ མནོབྷི རླབྡྷཝནྟ ཨིཏི ཀཱརཎཱད྄ ཨཱིཤྭརསྱ དྷནྱཝཱདོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ཨིཏྠཾ ཡཱུཡཾ པཱཔསེཝཱཏོ མུཀྟཱཿ སནྟོ དྷརྨྨསྱ བྷྲྀཏྱཱ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ཡུཥྨཱཀཾ ཤཱརཱིརིཀྱཱ དུརྦྦལཏཱཡཱ ཧེཏོ རྨཱནཝཝད྄ ཨཧམ྄ ཨེཏད྄ བྲཝཱིམི; པུནཿ པུནརདྷརྨྨཀརཎཱརྠཾ ཡདྭཏ྄ པཱུཪྻྭཾ པཱཔཱམེདྷྱཡོ རྦྷྲྀཏྱཏྭེ ནིཛཱངྒཱནི སམཱརྤཡཏ ཏདྭད྄ ཨིདཱནཱིཾ སཱདྷུཀརྨྨཀརཎཱརྠཾ དྷརྨྨསྱ བྷྲྀཏྱཏྭེ ནིཛཱངྒཱནི སམརྤཡཏ། ");
INSERT INTO santib_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ཡདཱ ཡཱུཡཾ པཱཔསྱ བྷྲྀཏྱཱ ཨཱསྟ ཏདཱ དྷརྨྨསྱ ནཱཡཏྟཱ ཨཱསྟ། ");
INSERT INTO santib_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ཏརྷི ཡཱནི ཀརྨྨཱཎི ཡཱུཡམ྄ ཨིདཱནཱིཾ ལཛྫཱཛནཀཱནི བུདྷྱདྷྭེ པཱུཪྻྭཾ ཏཻ ཪྻུཥྨཱཀཾ ཀོ ལཱབྷ ཨཱསཱིཏ྄? ཏེཥཱཾ ཀརྨྨཎཱཾ ཕལཾ མརཎམེཝ། ");
INSERT INTO santib_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ཀིནྟུ སཱམྤྲཏཾ ཡཱུཡཾ པཱཔསེཝཱཏོ མུཀྟཱཿ སནྟ ཨཱིཤྭརསྱ བྷྲྀཏྱཱ྅བྷཝཏ ཏསྨཱད྄ ཡུཥྨཱཀཾ པཝིཏྲཏྭརཱུཔཾ ལབྷྱམ྄ ཨནནྟཛཱིཝནརཱུཔཉྩ ཕལམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ཡཏཿ པཱཔསྱ ཝེཏནཾ མརཎཾ ཀིནྟྭསྨཱཀཾ པྲབྷུཎཱ ཡཱིཤུཁྲཱིཥྚེནཱནནྟཛཱིཝནམ྄ ཨཱིཤྭརདཏྟཾ པཱརིཏོཥིཀམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ཧེ བྷྲཱཏྲྀགཎ ཝྱཝསྠཱཝིདཿ པྲཏི མམེདཾ ནིཝེདནཾ། ཝིདྷིཿ ཀེཝལཾ ཡཱཝཛྫཱིཝཾ མཱནཝོཔཪྻྱདྷིཔཏིཏྭཾ ཀརོཏཱིཏི ཡཱུཡཾ ཀིཾ ན ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ཡཱཝཏྐཱལཾ པཏི རྫཱིཝཏི ཏཱཝཏྐཱལམ྄ ཨཱུཌྷཱ བྷཱཪྻྱཱ ཝྱཝསྠཡཱ ཏསྨིན྄ བདྡྷཱ ཏིཥྛཏི ཀིནྟུ ཡདི པཏི རྨྲིཡཏེ ཏརྷི སཱ ནཱརཱི པཏྱུ ཪྻྱཝསྠཱཏོ མུཙྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ཨེཏཏྐཱརཎཱཏ྄ པཏྱུརྫཱིཝནཀཱལེ ནཱརཱི ཡདྱནྱཾ པུརུཥཾ ཝིཝཧཏི ཏརྷི སཱ ཝྱབྷིཙཱརིཎཱི བྷཝཏི ཀིནྟུ ཡདི ས པཏི རྨྲིཡཏེ ཏརྷི སཱ ཏསྱཱ ཝྱཝསྠཱཡཱ མུཀྟཱ སཏཱི པུརུཥཱནྟརེཎ ཝྱཱུཌྷཱཔི ཝྱབྷིཙཱརིཎཱི ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ཧེ མམ བྷྲཱཏྲྀགཎ, ཨཱིཤྭརནིམིཏྟཾ ཡདསྨཱཀཾ ཕལཾ ཛཱཡཏེ ཏདརྠཾ ཤྨཤཱནཱད྄ ཨུཏྠཱཔིཏེན པུརུཥེཎ སཧ ཡུཥྨཱཀཾ ཝིཝཱཧོ ཡད྄ བྷཝེཏ྄ ཏདརྠཾ ཁྲཱིཥྚསྱ ཤརཱིརེཎ ཡཱུཡཾ ཝྱཝསྠཱཾ པྲཏི མྲྀཏཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ཡཏོ྅སྨཱཀཾ ཤཱརཱིརིཀཱཙརཎསམཡེ མརཎནིམིཏྟཾ ཕལམ྄ ཨུཏྤཱདཡིཏུཾ ཝྱཝསྠཡཱ དཱུཥིཏཿ པཱཔཱབྷིལཱཥོ྅སྨཱཀམ྄ ཨངྒེཥུ ཛཱིཝན྄ ཨཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ཀིནྟུ ཏདཱ ཡསྱཱ ཝྱཝསྠཱཡཱ ཝཤེ ཨཱསྨཧི སཱམྤྲཏཾ ཏཱཾ པྲཏི མྲྀཏཏྭཱད྄ ཝཡཾ ཏསྱཱ ཨདྷཱིནཏྭཱཏ྄ མུཀྟཱ ཨིཏི ཧེཏོརཱིཤྭརོ྅སྨཱབྷིཿ པུརཱཏནལིཁིཏཱནུསཱརཱཏ྄ ན སེཝིཏཝྱཿ ཀིནྟུ ནཝཱིནསྭབྷཱཝེནཻཝ སེཝིཏཝྱཿ ");
INSERT INTO santib_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ཏརྷི ཝཡཾ ཀིཾ བྲཱུམཿ? ཝྱཝསྠཱ ཀིཾ པཱཔཛནིཀཱ བྷཝཏི? ནེཏྠཾ བྷཝཏུ། ཝྱཝསྠཱམ྄ ཨཝིདྱམཱནཱཡཱཾ པཱཔཾ ཀིམ྄ ཨིཏྱཧཾ ནཱཝེདཾ; ཀིཉྩ ལོབྷཾ མཱ ཀཱརྵཱིརིཏི ཙེད྄ ཝྱཝསྠཱགྲནྠེ ལིཁིཏཾ ནཱབྷཝིཥྱཏ྄ ཏརྷི ལོབྷཿ ཀིམྦྷཱུཏསྟདཧཾ ནཱཛྙཱསྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ཀིནྟུ ཝྱཝསྠཡཱ པཱཔཾ ཚིདྲཾ པྲཱཔྱཱསྨཱཀམ྄ ཨནྟཿ སཪྻྭཝིདྷཾ ཀུཏྶིཏཱབྷིལཱཥམ྄ ཨཛནཡཏ྄; ཡཏོ ཝྱཝསྠཱཡཱམ྄ ཨཝིདྱམཱནཱཡཱཾ པཱཔཾ མྲྀཏཾ། ");
INSERT INTO santib_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ཨཔརཾ པཱུཪྻྭཾ ཝྱཝསྠཱཡཱམ྄ ཨཝིདྱམཱནཱཡཱམ྄ ཨཧམ྄ ཨཛཱིཝཾ ཏཏཿ པརམ྄ ཨཱཛྙཱཡཱམ྄ ཨུཔསྠིཏཱཡཱམ྄ པཱཔམ྄ ཨཛཱིཝཏ྄ ཏདཱཧམ྄ ཨམྲིཡེ། ");
INSERT INTO santib_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ཨིཏྠཾ སཏི ཛཱིཝནནིམིཏྟཱ ཡཱཛྙཱ སཱ མམ མྲྀཏྱུཛནིཀཱབྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ཡཏཿ པཱཔཾ ཚིདྲཾ པྲཱཔྱ ཝྱཝསྠིཏཱདེཤེན མཱཾ ཝཉྩཡིཏྭཱ ཏེན མཱམ྄ ཨཧན྄། ");
INSERT INTO santib_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ཨཏཨེཝ ཝྱཝསྠཱ པཝིཏྲཱ, ཨཱདེཤཤྩ པཝིཏྲོ ནྱཱཡྻོ ཧིཏཀཱརཱི ཙ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ཏརྷི ཡཏ྄ སྭཡཾ ཧིཏཀྲྀཏ྄ ཏཏ྄ ཀིཾ མམ མྲྀཏྱུཛནཀམ྄ ཨབྷཝཏ྄? ནེཏྠཾ བྷཝཏུ; ཀིནྟུ པཱཔཾ ཡཏ྄ པཱཏཀམིཝ པྲཀཱཤཏེ ཏཐཱ ནིདེཤེན པཱཔཾ ཡདཏཱིཝ པཱཏཀམིཝ པྲཀཱཤཏེ ཏདརྠཾ ཧིཏོཔཱཡེན མམ མརཎམ྄ ཨཛནཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ཝྱཝསྠཱཏྨབོདྷིཀེཏི ཝཡཾ ཛཱནཱིམཿ ཀིནྟྭཧཾ ཤཱརཱིརཏཱཙཱརཱི པཱཔསྱ ཀྲཱིཏཀིངྐརོ ཝིདྱེ། ");
INSERT INTO santib_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ཡཏོ ཡཏ྄ ཀརྨྨ ཀརོམི ཏཏ྄ མམ མནོ྅བྷིམཏཾ ནཧི; ཨཔརཾ ཡན྄ མམ མནོ྅བྷིམཏཾ ཏནྣ ཀརོམི ཀིནྟུ ཡད྄ ཨྲྀཏཱིཡེ ཏཏ྄ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ཏཐཱཏྭེ ཡན྄ མམཱནབྷིམཏཾ ཏད྄ ཡདི ཀརོམི ཏརྷི ཝྱཝསྠཱ སཱུཏྟམེཏི སྭཱིཀརོམི། ");
INSERT INTO santib_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ཨཏཨེཝ སམྤྲཏི ཏཏ྄ ཀརྨྨ མཡཱ ཀྲིཡཏ ཨིཏི ནཧི ཀིནྟུ མམ ཤརཱིརསྠེན པཱཔེནཻཝ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ཡཏོ མཡི, ཨརྠཏོ མམ ཤརཱིརེ, ཀིམཔྱུཏྟམཾ ན ཝསཏི, ཨེཏད྄ ཨཧཾ ཛཱནཱམི; མམེཙྪུཀཏཱཡཱཾ ཏིཥྛནྟྱཱམཔྱཧམ྄ ཨུཏྟམཀརྨྨསཱདྷནེ སམརྠོ ན བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ཡཏོ ཡཱམུཏྟམཱཾ ཀྲིཡཱཾ ཀརྟྟུམཧཾ ཝཱཉྪཱམི ཏཱཾ ན ཀརོམི ཀིནྟུ ཡཏ྄ ཀུཏྶིཏཾ ཀརྨྨ ཀརྟྟུམ྄ ཨནིཙྪུཀོ྅སྨི ཏདེཝ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ཨཏཨེཝ ཡདྱཏ྄ ཀརྨྨ ཀརྟྟུཾ མམེཙྪཱ ན བྷཝཏི ཏད྄ ཡདི ཀརོམི ཏརྷི ཏཏ྄ མཡཱ ན ཀྲིཡཏེ, མམཱནྟཪྻརྟྟིནཱ པཱཔེནཻཝ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","བྷདྲཾ ཀརྟྟུམ྄ ཨིཙྪུཀཾ མཱཾ ཡོ ྅བྷདྲཾ ཀརྟྟུཾ པྲཝརྟྟཡཏི ཏཱདྲྀཤཾ སྭབྷཱཝམེཀཾ མཡི པཤྱཱམི། ");
INSERT INTO santib_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ཨཧམ྄ ཨཱནྟརིཀཔུརུཥེཎེཤྭརཝྱཝསྠཱཡཱཾ སནྟུཥྚ ཨཱསེ; ");
INSERT INTO santib_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ཀིནྟུ ཏདྭིཔརཱིཏཾ ཡུདྷྱནྟཾ ཏདནྱམེཀཾ སྭབྷཱཝཾ མདཱིཡཱངྒསྠིཏཾ པྲཔཤྱཱམི, ས མདཱིཡཱངྒསྠིཏཔཱཔསྭབྷཱཝསྱཱཡཏྟཾ མཱཾ ཀརྟྟུཾ ཙེཥྚཏེ། ");
INSERT INTO santib_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ཧཱ ཧཱ ཡོ྅ཧཾ དུརྦྷཱགྱོ མནུཛསྟཾ མཱམ྄ ཨེཏསྨཱན྄ མྲྀཏཱཙྪརཱིརཱཏ྄ ཀོ ནིསྟཱརཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ཨསྨཱཀཾ པྲབྷུཎཱ ཡཱིཤུཁྲཱིཥྚེན ནིསྟཱརཡིཏཱརམ྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདཱམི། ཨཏཨེཝ ཤརཱིརེཎ པཱཔཝྱཝསྠཱཡཱ མནསཱ ཏུ ཨཱིཤྭརཝྱཝསྠཱཡཱཿ སེཝནཾ ཀརོམི། ");
INSERT INTO santib_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ཡེ ཛནཱཿ ཁྲཱིཥྚཾ ཡཱིཤུམ྄ ཨཱཤྲིཏྱ ཤཱརཱིརིཀཾ ནཱཙརནྟ ཨཱཏྨིཀམཱཙརནྟི ཏེ྅དྷུནཱ དཎྜཱརྷཱ ན བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ཛཱིཝནདཱཡཀསྱཱཏྨནོ ཝྱཝསྠཱ ཁྲཱིཥྚཡཱིཤུནཱ པཱཔམརཎཡོ ཪྻྱཝསྠཱཏོ མཱམམོཙཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ཡསྨཱཙྪཱརཱིརསྱ དུརྦྦལཏྭཱད྄ ཝྱཝསྠཡཱ ཡཏ྄ ཀརྨྨཱསཱདྷྱམ྄ ཨཱིཤྭརོ ནིཛཔུཏྲཾ པཱཔིཤརཱིརརཱུཔཾ པཱཔནཱཤཀབལིརཱུཔཉྩ པྲེཥྱ ཏསྱ ཤརཱིརེ པཱཔསྱ དཎྜཾ ཀུཪྻྭན྄ ཏཏྐརྨྨ སཱདྷིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ཏཏཿ ཤཱརཱིརིཀཾ ནཱཙརིཏྭཱསྨཱབྷིརཱཏྨིཀམ྄ ཨཱཙརདྦྷིཪྻྱཝསྠཱགྲནྠེ ནིརྡྡིཥྚཱནི པུཎྱཀརྨྨཱཎི སཪྻྭཱཎི སཱདྷྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ཡེ ཤཱརཱིརིཀཱཙཱརིཎསྟེ ཤཱརཱིརིཀཱན྄ ཝིཥཡཱན྄ བྷཱཝཡནྟི ཡེ ཙཱཏྨིཀཱཙཱརིཎསྟེ ཨཱཏྨནོ ཝིཥཡཱན྄ བྷཱཝཡནྟི། ");
INSERT INTO santib_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ཤཱརཱིརིཀབྷཱཝསྱ ཕལཾ མྲྀཏྱུཿ ཀིཉྩཱཏྨིཀབྷཱཝསྱ ཕལེ ཛཱིཝནཾ ཤཱནྟིཤྩ། ");
INSERT INTO santib_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ཡཏཿ ཤཱརཱིརིཀབྷཱཝ ཨཱིཤྭརསྱ ཝིརུདྡྷཿ ཤཏྲུཏཱབྷཱཝ ཨེཝ ས ཨཱིཤྭརསྱ ཝྱཝསྠཱཡཱ ཨདྷཱིནོ ན བྷཝཏི བྷཝིཏུཉྩ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ཨེཏསྨཱཏ྄ ཤཱརཱིརིཀཱཙཱརིཥུ ཏོཥྚུམ྄ ཨཱིཤྭརེཎ ན ཤཀྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ཀིནྟྭཱིཤྭརསྱཱཏྨཱ ཡདི ཡུཥྨཱཀཾ མདྷྱེ ཝསཏི ཏརྷི ཡཱུཡཾ ཤཱརཱིརིཀཱཙཱརིཎོ ན སནྟ ཨཱཏྨིཀཱཙཱརིཎོ བྷཝཐཿ། ཡསྨིན྄ ཏུ ཁྲཱིཥྚསྱཱཏྨཱ ན ཝིདྱཏེ ས ཏཏྶམྦྷཝོ ནཧི། ");
INSERT INTO santib_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ཡདི ཁྲཱིཥྚོ ཡུཥྨཱན྄ ཨདྷིཏིཥྛཏི ཏརྷི པཱཔམ྄ ཨུདྡིཤྱ ཤརཱིརཾ མྲྀཏཾ ཀིནྟུ པུཎྱམུདྡིཤྱཱཏྨཱ ཛཱིཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","མྲྀཏགཎཱད྄ ཡཱིཤུ ཪྻེནོཏྠཱཔིཏསྟསྱཱཏྨཱ ཡདི ཡུཥྨནྨདྷྱེ ཝསཏི ཏརྷི མྲྀཏགཎཱཏ྄ ཁྲཱིཥྚསྱ ས ཨུཏྠཱཔཡིཏཱ ཡུཥྨནྨདྷྱཝཱསིནཱ སྭཀཱིཡཱཏྨནཱ ཡུཥྨཱཀཾ མྲྀཏདེཧཱནཔི པུན རྫཱིཝཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ཧེ བྷྲཱཏྲྀགཎ ཤརཱིརསྱ ཝཡམདྷམརྞཱ ན བྷཝཱམོ྅ཏཿ ཤཱརཱིརིཀཱཙཱརོ྅སྨཱབྷི རྣ ཀརྟྟཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ཡདི ཡཱུཡཾ ཤརཱིརིཀཱཙཱརིཎོ བྷཝེཏ ཏརྷི ཡུཥྨཱབྷི རྨརྟྟཝྱམེཝ ཀིནྟྭཱཏྨནཱ ཡདི ཤརཱིརཀརྨྨཱཎི གྷཱཏཡེཏ ཏརྷི ཛཱིཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ཡཏོ ཡཱཝནྟོ ལོཀཱ ཨཱིཤྭརསྱཱཏྨནཱཀྲྀཥྱནྟེ ཏེ སཪྻྭ ཨཱིཤྭརསྱ སནྟཱནཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ཡཱུཡཾ པུནརཔི བྷཡཛནཀཾ དཱསྱབྷཱཝཾ ན པྲཱཔྟཱཿ ཀིནྟུ ཡེན བྷཱཝེནེཤྭརཾ པིཏཿ པིཏརིཏི པྲོཙྱ སམྦོདྷཡཐ ཏཱདྲྀཤཾ དཏྟཀཔུཏྲཏྭབྷཱཝམ྄ པྲཱཔྣུཏ། ");
INSERT INTO santib_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ཨཔརཉྩ ཝཡམ྄ ཨཱིཤྭརསྱ སནྟཱནཱ ཨེཏསྨིན྄ པཝིཏྲ ཨཱཏྨཱ སྭཡམ྄ ཨསྨཱཀམ྄ ཨཱཏྨཱབྷིཿ སཱརྡྡྷཾ པྲམཱཎཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ཨཏཨེཝ ཝཡཾ ཡདི སནྟཱནཱསྟརྷྱདྷིཀཱརིཎཿ, ཨརྠཱད྄ ཨཱིཤྭརསྱ སྭཏྟྭཱདྷིཀཱརིཎཿ ཁྲཱིཥྚེན སཧཱདྷིཀཱརིཎཤྩ བྷཝཱམཿ; ཨཔརཾ ཏེན སཱརྡྡྷཾ ཡདི དུཿཁབྷཱགིནོ བྷཝཱམསྟརྷི ཏསྱ ཝིབྷཝསྱཱཔི བྷཱགིནོ བྷཝིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ཀིནྟྭསྨཱསུ ཡོ བྷཱཝཱིཝིབྷཝཿ པྲཀཱཤིཥྱཏེ ཏསྱ སམཱིཔེ ཝརྟྟམཱནཀཱལཱིནཾ དུཿཁམཧཾ ཏྲྀཎཱཡ མནྱེ། ");
INSERT INTO santib_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ཡཏཿ པྲཱཎིགཎ ཨཱིཤྭརསྱ སནྟཱནཱནཱཾ ཝིབྷཝཔྲཱཔྟིམ྄ ཨཱཀཱངྐྵན྄ ནིཏཱནྟམ྄ ཨཔེཀྵཏེ། ");
INSERT INTO santib_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ཨཔརཉྩ པྲཱཎིགཎཿ སྭཻརམ྄ ཨལཱིཀཏཱཡཱ ཝཤཱིཀྲྀཏོ ནཱབྷཝཏ྄ ");
INSERT INTO santib_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ཀིནྟུ པྲཱཎིགཎོ྅པི ནཤྭརཏཱདྷཱིནཏྭཱཏ྄ མུཀྟཿ སན྄ ཨཱིཤྭརསྱ སནྟཱནཱནཱཾ པརམམུཀྟིཾ པྲཱཔྶྱཏཱིཏྱབྷིཔྲཱཡེཎ ཝཤཱིཀརྟྲཱ ཝཤཱིཙཀྲེ། ");
INSERT INTO santib_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ཨཔརཉྩ པྲསཱུཡམཱནཱཝད྄ ཝྱཐིཏཿ སན྄ ཨིདཱནཱིཾ ཡཱཝཏ྄ ཀྲྀཏྶྣཿ པྲཱཎིགཎ ཨཱརྟྟསྭརཾ ཀརོཏཱིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ཀེཝལཿ ས ཨིཏི ནཧི ཀིནྟུ པྲཐམཛཱཏཕལསྭརཱུཔམ྄ ཨཱཏྨཱནཾ པྲཱཔྟཱ ཝཡམཔི དཏྟཀཔུཏྲཏྭཔདཔྲཱཔྟིམ྄ ཨརྠཱཏ྄ ཤརཱིརསྱ མུཀྟིཾ པྲཏཱིཀྵམཱཎཱསྟདྭད྄ ཨནྟརཱརྟྟརཱཝཾ ཀུརྨྨཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ཝཡཾ པྲཏྱཱཤཡཱ ཏྲཱཎམ྄ ཨལབྷཱམཧི ཀིནྟུ པྲཏྱཀྵཝསྟུནོ ཡཱ པྲཏྱཱཤཱ སཱ པྲཏྱཱཤཱ ནཧི, ཡཏོ མནུཥྱོ ཡཏ྄ སམཱིཀྵཏེ ཏསྱ པྲཏྱཱཤཱཾ ཀུཏཿ ཀརིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ཡད྄ ཨཔྲཏྱཀྵཾ ཏསྱ པྲཏྱཱཤཱཾ ཡདི ཝཡཾ ཀུཪྻྭཱིམཧི ཏརྷི དྷཻཪྻྱམ྄ ཨཝལམྦྱ པྲཏཱིཀྵཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ཏཏ ཨཱཏྨཱཔི སྭཡམ྄ ཨསྨཱཀཾ དུརྦྦལཏཱཡཱཿ སཧཱཡཏྭཾ ཀརོཏི; ཡཏཿ ཀིཾ པྲཱརྠིཏཝྱཾ ཏད྄ བོདྡྷུཾ ཝཡཾ ན ཤཀྣུམཿ, ཀིནྟྭསྤཥྚཻརཱརྟྟརཱཝཻརཱཏྨཱ སྭཡམ྄ ཨསྨནྣིམིཏྟཾ ནིཝེདཡཏི། ");
INSERT INTO santib_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ཨཔརམ྄ ཨཱིཤྭརཱབྷིམཏརཱུཔེཎ པཝིཏྲལོཀཱནཱཾ ཀྲྀཏེ ནིཝེདཡཏི ཡ ཨཱཏྨཱ ཏསྱཱབྷིཔྲཱཡོ྅ནྟཪྻྱཱམིནཱ ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ཨཔརམ྄ ཨཱིཤྭརཱིཡནིརཱུཔཎཱནུསཱརེཎཱཧཱུཏཱཿ སནྟོ ཡེ ཏསྨིན྄ པྲཱིཡནྟེ སཪྻྭཱཎི མིལིཏྭཱ ཏེཥཱཾ མངྒལཾ སཱདྷཡནྟི, ཨེཏད྄ ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ཡཏ ཨཱིཤྭརོ བཧུབྷྲཱཏྲྀཎཱཾ མདྷྱེ སྭཔུཏྲཾ ཛྱེཥྛཾ ཀརྟྟུམ྄ ཨིཙྪན྄ ཡཱན྄ པཱུཪྻྭཾ ལཀྵྱཱིཀྲྀཏཝཱན྄ ཏཱན྄ ཏསྱ པྲཏིམཱུརྟྱཱཿ སཱདྲྀཤྱཔྲཱཔྟྱརྠཾ ནྱཡུཾཀྟ། ");
INSERT INTO santib_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ཨཔརཉྩ ཏེན ཡེ ནིཡུཀྟཱསྟ ཨཱཧཱུཏཱ ཨཔི ཡེ ཙ ཏེནཱཧཱུཏཱསྟེ སཔུཎྱཱིཀྲྀཏཱཿ, ཡེ ཙ ཏེན སཔུཎྱཱིཀྲྀཏཱསྟེ ཝིབྷཝཡུཀྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ཨིཏྱཏྲ ཝཡཾ ཀིཾ བྲཱུམཿ? ཨཱིཤྭརོ ཡདྱསྨཱཀཾ སཔཀྵོ བྷཝཏི ཏརྷི ཀོ ཝིཔཀྵོ྅སྨཱཀཾ? ");
INSERT INTO santib_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ཨཱཏྨཔུཏྲཾ ན རཀྵིཏྭཱ ཡོ྅སྨཱཀཾ སཪྻྭེཥཱཾ ཀྲྀཏེ ཏཾ པྲདཏྟཝཱན྄ ས ཀིཾ ཏེན སཧཱསྨབྷྱམ྄ ཨནྱཱནི སཪྻྭཱཎི ན དཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ཨཱིཤྭརསྱཱབྷིརུཙིཏེཥུ ཀེན དོཥ ཨཱརོཔཡིཥྱཏེ? ཡ ཨཱིཤྭརསྟཱན྄ པུཎྱཝཏ ཨིཝ གཎཡཏི ཀིཾ ཏེན? ");
INSERT INTO santib_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ཨཔརཾ ཏེབྷྱོ དཎྜདཱནཱཛྙཱ ཝཱ ཀེན ཀརིཥྱཏེ? ཡོ྅སྨནྣིམིཏྟཾ པྲཱཎཱན྄ ཏྱཀྟཝཱན྄ ཀེཝལཾ ཏནྣ ཀིནྟུ མྲྀཏགཎམདྷྱཱད྄ ཨུཏྠིཏཝཱན྄, ཨཔི ཙེཤྭརསྱ དཀྵིཎེ པཱརྴྭེ ཏིཥྛན྄ ཨདྱཱཔྱསྨཱཀཾ ནིམིཏྟཾ པྲཱརྠཏ ཨེཝམྦྷཱུཏོ ཡཿ ཁྲཱིཥྚཿ ཀིཾ ཏེན? ");
INSERT INTO santib_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ཨསྨཱབྷིཿ སཧ ཁྲཱིཥྚསྱ པྲེམཝིཙྪེདཾ ཛནཡིཏུཾ ཀཿ ཤཀྣོཏི? ཀླེཤོ ཝྱསནཾ ཝཱ ཏཱཌནཱ ཝཱ དུརྦྷིཀྵཾ ཝཱ ཝསྟྲཧཱིནཏྭཾ ཝཱ པྲཱཎསཾཤཡོ ཝཱ ཁངྒོ ཝཱ ཀིམེཏཱནི ཤཀྣུཝནྟི? ");
INSERT INTO santib_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ཀིནྟུ ལིཁིཏམ྄ ཨཱསྟེ, ཡཐཱ, ཝཡཾ ཏཝ ནིམིཏྟཾ སྨོ མྲྀཏྱུཝཀྟྲེ྅ཁིལཾ དིནཾ། བལིརྡེཡོ ཡཐཱ མེཥོ ཝཡཾ གཎྱཱམཧེ ཏཐཱ། ");
INSERT INTO santib_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ཨཔརཾ ཡོ྅སྨཱསུ པྲཱིཡཏེ ཏེནཻཏཱསུ ཝིཔཏྶུ ཝཡཾ སམྱག྄ ཝིཛཡཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ཡཏོ྅སྨཱཀཾ པྲབྷུནཱ ཡཱིཤུཁྲཱིཥྚེནེཤྭརསྱ ཡཏ྄ པྲེམ ཏསྨཱད྄ ཨསྨཱཀཾ ཝིཙྪེདཾ ཛནཡིཏུཾ མྲྀཏྱུ རྫཱིཝནཾ ཝཱ དིཝྱདཱུཏཱ ཝཱ བལཝནྟོ མུཁྱདཱུཏཱ ཝཱ ཝརྟྟམཱནོ ཝཱ བྷཝིཥྱན྄ ཀཱལོ ཝཱ ཨུཙྩཔདཾ ཝཱ ནཱིཙཔདཾ ཝཱཔརཾ ཀིམཔི སྲྀཥྚཝསྟུ ");
INSERT INTO santib_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ཝཻཏེཥཱཾ ཀེནཱཔི ན ཤཀྱམིཏྱསྨིན྄ དྲྀཌྷཝིཤྭཱསོ མམཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ཨཧཾ ཀཱཉྩིད྄ ཀལྤིཏཱཾ ཀཐཱཾ ན ཀཐཡཱམི, ཁྲཱིཥྚསྱ སཱཀྵཱཏ྄ སཏྱམེཝ བྲཝཱིམི པཝིཏྲསྱཱཏྨནཿ སཱཀྵཱན྄ མདཱིཡཾ མན ཨེཏཏ྄ སཱཀྵྱཾ དདཱཏི། ");
INSERT INTO santib_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","མམཱནྟརཏིཤཡདུཿཁཾ ནིརནྟརཾ ཁེདཤྩ ");
INSERT INTO santib_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ཏསྨཱད྄ ཨཧཾ སྭཛཱཏཱིཡབྷྲཱཏྲྀཎཱཾ ནིམིཏྟཱཏ྄ སྭཡཾ ཁྲཱིཥྚཱཙྪཱཔཱཀྲཱནྟོ བྷཝིཏུམ྄ ཨཻཙྪམ྄། ");
INSERT INTO santib_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ཡཏསྟ ཨིསྲཱཡེལསྱ ཝཾཤཱ ཨཔི ཙ དཏྟཀཔུཏྲཏྭཾ ཏེཛོ ནིཡམོ ཝྱཝསྠཱདཱནཾ མནྡིརེ བྷཛནཾ པྲཏིཛྙཱཿ པིཏྲྀཔུརུཥགཎཤྩཻཏེཥུ སཪྻྭེཥུ ཏེཥཱམ྄ ཨདྷིཀཱརོ྅སྟི། ");
INSERT INTO santib_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ཏཏ྄ ཀེཝལཾ ནཧི ཀིནྟུ སཪྻྭཱདྷྱཀྵཿ སཪྻྭདཱ སཙྩིདཱནནྡ ཨཱིཤྭརོ ཡཿ ཁྲཱིཥྚཿ སོ྅པི ཤཱརཱིརིཀསམྦནྡྷེན ཏེཥཱཾ ཝཾཤསམྦྷཝཿ། ");
INSERT INTO santib_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ཨཱིཤྭརསྱ ཝཱཀྱཾ ཝིཕལཾ ཛཱཏམ྄ ཨིཏི ནཧི ཡཏྐཱརཎཱད྄ ཨིསྲཱཡེལོ ཝཾཤེ ཡེ ཛཱཏཱསྟེ སཪྻྭེ ཝསྟུཏ ཨིསྲཱཡེལཱིཡཱ ན བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ཨཔརམ྄ ཨིབྲཱཧཱིམོ ཝཾཤེ ཛཱཏཱ ཨཔི སཪྻྭེ ཏསྱཻཝ སནྟཱནཱ ན བྷཝནྟི ཀིནྟུ ཨིསྷཱཀོ ནཱམྣཱ ཏཝ ཝཾཤོ ཝིཁྱཱཏོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ཨརྠཱཏ྄ ཤཱརཱིརིཀསཾསརྒཱཏ྄ ཛཱཏཱཿ སནྟཱནཱ ཡཱཝནྟསྟཱཝནྟ ཨེཝེཤྭརསྱ སནྟཱནཱ ན བྷཝནྟི ཀིནྟུ པྲཏིཤྲཝཎཱད྄ ཡེ ཛཱཡནྟེ ཏཨེཝེཤྭརཝཾཤོ གཎྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ཡཏསྟཏྤྲཏིཤྲུཏེ ཪྻཱཀྱམེཏཏ྄, ཨེཏཱདྲྀཤེ སམཡེ ྅ཧཾ པུནརཱགམིཥྱཱམི ཏཏྤཱུཪྻྭཾ སཱརཱཡཱཿ པུཏྲ ཨེཀོ ཛནིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ཨཔརམཔི ཝདཱམི སྭམནོ྅བྷིལཱཥཏ ཨཱིཤྭརེཎ ཡནྣིརཱུཔིཏཾ ཏཏ྄ ཀརྨྨཏོ ནཧི ཀིནྟྭཱཧྭཡིཏུ རྫཱཏམེཏད྄ ཡཐཱ སིདྡྷྱཏི ");
INSERT INTO santib_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ཏདརྠཾ རིབྐཱནཱམིཀཡཱ ཡོཥིཏཱ ཛནཻཀསྨཱད྄ ཨརྠཱད྄ ཨསྨཱཀམ྄ ཨིསྷཱཀཿ པཱུཪྻྭཔུརུཥཱད྄ གརྦྷེ དྷྲྀཏེ ཏསྱཱཿ སནྟཱནཡོཿ པྲསཝཱཏ྄ པཱུཪྻྭཾ ཀིཉྩ ཏཡོཿ ཤུབྷཱཤུབྷཀརྨྨཎཿ ཀརཎཱཏ྄ པཱུཪྻྭཾ ");
INSERT INTO santib_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ཏཱཾ པྲཏཱིདཾ ཝཱཀྱམ྄ ཨུཀྟཾ, ཛྱེཥྛཿ ཀནིཥྛཾ སེཝིཥྱཏེ, ");
INSERT INTO santib_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, ཏཐཱཔྱེཥཱཝི ན པྲཱིཏྭཱ ཡཱཀཱུབི པྲཱིཏཝཱན྄ ཨཧཾ། ");
INSERT INTO santib_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ཏརྷི ཝཡཾ ཀིཾ བྲཱུམཿ? ཨཱིཤྭརཿ ཀིམ྄ ཨནྱཱཡཀཱརཱི? ཏཐཱ ན བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ཡཏཿ ས སྭཡཾ མཱུསཱམ྄ ཨཝདཏ྄; ཨཧཾ ཡསྨིན྄ ཨནུགྲཧཾ ཙིཀཱིརྵཱམི ཏམེཝཱནུགྲྀཧླཱམི, ཡཉྩ དཡིཏུམ྄ ཨིཙྪཱམི ཏམེཝ དཡེ། ");
INSERT INTO santib_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ཨཏཨེཝེཙྪཏཱ ཡཏམཱནེན ཝཱ མཱནཝེན ཏནྣ སཱདྷྱཏེ དཡཱཀཱརིཎེཤྭརེཎཻཝ སཱདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ཕིརཽཎི ཤཱསྟྲེ ལིཁཏི, ཨཧཾ ཏྭདྡྭཱརཱ མཏྤརཱཀྲམཾ དརྴཡིཏུཾ སཪྻྭཔྲྀཐིཝྱཱཾ ནིཛནཱམ པྲཀཱཤཡིཏུཉྩ ཏྭཱཾ སྠཱཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ཨཏཿ ས ཡམ྄ ཨནུགྲཧཱིཏུམ྄ ཨིཙྪཏི ཏམེཝཱནུགྲྀཧླཱཏི, ཡཉྩ ནིགྲཧཱིཏུམ྄ ཨིཙྪཏི ཏཾ ནིགྲྀཧླཱཏི། ");
INSERT INTO santib_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ཡདི ཝདསི ཏརྷི ས དོཥཾ ཀུཏོ གྲྀཧླཱཏི? ཏདཱིཡེཙྪཱཡཱཿ པྲཏིབནྡྷཀཏྭཾ ཀརྟྟཾ ཀསྱ སཱམརྠྱཾ ཝིདྱཏེ? ");
INSERT INTO santib_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ཧེ ཨཱིཤྭརསྱ པྲཏིཔཀྵ མརྟྱ ཏྭཾ ཀཿ? ཨེཏཱདྲྀཤཾ མཱཾ ཀུཏཿ སྲྀཥྚཝཱན྄? ཨིཏི ཀཐཱཾ སྲྀཥྚཝསྟུ སྲཥྚྲེ ཀིཾ ཀཐཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ཨེཀསྨཱན྄ མྲྀཏྤིཎྜཱད྄ ཨུཏྐྲྀཥྚཱཔཀྲྀཥྚཽ དྭིཝིདྷཽ ཀལཤཽ ཀརྟྟུཾ ཀིཾ ཀུལཱལསྱ སཱམརྠྱཾ ནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ཨཱིཤྭརཿ ཀོཔཾ པྲཀཱཤཡིཏུཾ ནིཛཤཀྟིཾ ཛྙཱཔཡིཏུཉྩེཙྪན྄ ཡདི ཝིནཱཤསྱ ཡོགྱཱནི ཀྲོདྷབྷཱཛནཱནི པྲཏི བཧུཀཱལཾ དཱིརྒྷསཧིཥྞུཏཱམ྄ ཨཱཤྲཡཏི; ");
INSERT INTO santib_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ཨཔརཉྩ ཝིབྷཝཔྲཱཔྟྱརྠཾ པཱུཪྻྭཾ ནིཡུཀྟཱནྱནུགྲཧཔཱཏྲཱཎི པྲཏི ནིཛཝིབྷཝསྱ བཱཧུལྱཾ པྲཀཱཤཡིཏུཾ ཀེཝལཡིཧཱུདིནཱཾ ནཧི བྷིནྣདེཤིནཱམཔི མདྷྱཱད྄ ");
INSERT INTO santib_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ཨསྨཱནིཝ ཏཱནྱཱཧྭཡཏི ཏཏྲ ཏཝ ཀིཾ? ");
INSERT INTO santib_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ཧོཤེཡགྲནྠེ ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, ཡོ ལོཀོ མམ ནཱསཱིཏ྄ ཏཾ ཝདིཥྱཱམི མདཱིཡཀཾ། ཡཱ ཛཱཏི རྨེ྅པྲིཡཱ ཙཱསཱིཏ྄ ཏཱཾ ཝདིཥྱཱམྱཧཾ པྲིཡཱཾ། ");
INSERT INTO santib_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ཡཱུཡཾ མདཱིཡལོཀཱ ན ཡཏྲེཏི ཝཱཀྱམཽཙྱཏ། ཨམརེཤསྱ སནྟཱནཱ ཨིཏི ཁྱཱསྱནྟི ཏཏྲ ཏེ། ");
INSERT INTO santib_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ཨིསྲཱཡེལཱིཡལོཀེཥུ ཡིཤཱཡིཡོ྅པི ཝཱཙམེཏཱཾ པྲཱཙཱརཡཏ྄, ཨིསྲཱཡེལཱིཡཝཾཤཱནཱཾ ཡཱ སཾཁྱཱ སཱ ཏུ ནིཤྩིཏཾ། སམུདྲསིཀཏཱསཾཁྱཱསམཱནཱ ཡདི ཛཱཡཏེ། ཏཐཱཔི ཀེཝལཾ ལོཀཻརལྤཻསྟྲཱཎཾ ཝྲཛིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ཡཏོ ནྱཱཡེན སྭཾ ཀརྨྨ པརེཤཿ སཱདྷཡིཥྱཏི། དེཤེ སཨེཝ སཾཀྵེཔཱནྣིཛཾ ཀརྨྨ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ཡིཤཱཡིཡོ྅པརམཔི ཀཐཡཱམཱས, སཻནྱཱདྷྱཀྵཔརེཤེན ཙེཏ྄ ཀིཉྩིནྣོདཤིཥྱཏ། ཏདཱ ཝཡཾ སིདོམེཝཱབྷཝིཥྱཱམ ཝིནིཤྩིཏཾ། ཡདྭཱ ཝཡམ྄ ཨམོརཱཡཱ ཨགམིཥྱཱམ ཏུལྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ཏརྷི ཝཡཾ ཀིཾ ཝཀྵྱཱམཿ? ཨིཏརདེཤཱིཡཱ ལོཀཱ ཨཔི པུཎྱཱརྠམ྄ ཨཡཏམཱནཱ ཝིཤྭཱསེན པུཎྱམ྄ ཨལབྷནྟ; ");
INSERT INTO santib_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ཀིནྟྭིསྲཱཡེལློཀཱ ཝྱཝསྠཱཔཱལནེན པུཎྱཱརྠཾ ཡཏམཱནཱསྟན྄ ནཱལབྷནྟ། ");
INSERT INTO santib_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ཏསྱ ཀིཾ ཀཱརཎཾ? ཏེ ཝིཤྭཱསེན ནཧི ཀིནྟུ ཝྱཝསྠཱཡཱཿ ཀྲིཡཡཱ ཙེཥྚིཏྭཱ ཏསྨིན྄ སྑལནཛནཀེ པཱཥཱཎེ པཱདསྑལནཾ པྲཱཔྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ལིཁིཏཾ ཡཱདྲྀཤམ྄ ཨཱསྟེ, པཤྱ པཱདསྑལཱརྠཾ ཧི སཱིཡོནི པྲསྟརནྟཐཱ། བཱདྷཱཀཱརཉྩ པཱཥཱཎཾ པརིསྠཱཔིཏཝཱནཧམ྄། ཝིཤྭསིཥྱཏི ཡསྟཏྲ ས ཛནོ ན ཏྲཔིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ཧེ བྷྲཱཏར ཨིསྲཱཡེལཱིཡལོཀཱ ཡཏ྄ པརིཏྲཱཎཾ པྲཱཔྣུཝནྟི ཏདཧཾ མནསཱབྷིལཥན྄ ཨཱིཤྭརསྱ སམཱིཔེ པྲཱརྠཡེ། ");
INSERT INTO santib_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ཡཏ ཨཱིཤྭརེ ཏེཥཱཾ ཙེཥྚཱ ཝིདྱཏ ཨིཏྱཏྲཱཧཾ སཱཀྵྱསྨི; ཀིནྟུ ཏེཥཱཾ སཱ ཙེཥྚཱ སཛྙཱནཱ ནཧི, ");
INSERT INTO santib_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ཡཏསྟ ཨཱིཤྭརདཏྟཾ པུཎྱམ྄ ཨཝིཛྙཱཡ སྭཀྲྀཏཔུཎྱཾ སྠཱཔཡིཏུམ྄ ཙེཥྚམཱནཱ ཨཱིཤྭརདཏྟསྱ པུཎྱསྱ ནིགྷྣཏྭཾ ན སྭཱིཀུཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ཁྲཱིཥྚ ཨེཀཻཀཝིཤྭཱསིཛནཱཡ པུཎྱཾ དཱཏུཾ ཝྱཝསྠཱཡཱཿ ཕལསྭརཱུཔོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ཝྱཝསྠཱཔཱལནེན ཡཏ྄ པུཎྱཾ ཏཏ྄ མཱུསཱ ཝརྞཡཱམཱས, ཡཐཱ, ཡོ ཛནསྟཱཾ པཱལཡིཥྱཏི ས ཏདྡྭཱརཱ ཛཱིཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ཀིནྟུ པྲཏྱཡེན ཡཏ྄ པུཎྱཾ ཏད྄ ཨེཏཱདྲྀཤཾ ཝཱཀྱཾ ཝདཏི, ཀཿ སྭརྒམ྄ ཨཱརུཧྱ ཁྲཱིཥྚམ྄ ཨཝརོཧཡིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ཀོ ཝཱ པྲེཏལོཀམ྄ ཨཝརུཧྱ ཁྲཱིཥྚཾ མྲྀཏགཎམདྷྱཱད྄ ཨཱནེཥྱཏཱིཏི ཝཱཀ྄ མནསི ཏྭཡཱ ན གདིཏཝྱཱ། ");
INSERT INTO santib_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ཏརྷི ཀིཾ བྲཝཱིཏི? ཏད྄ ཝཱཀྱཾ ཏཝ སམཱིཔསྠམ྄ ཨརྠཱཏ྄ ཏཝ ཝདནེ མནསི ཙཱསྟེ, ཏཙྩ ཝཱཀྱམ྄ ཨསྨཱབྷིཿ པྲཙཱཪྻྱམཱཎཾ ཝིཤྭཱསསྱ ཝཱཀྱམེཝ། ");
INSERT INTO santib_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ཝསྟུཏཿ པྲབྷུཾ ཡཱིཤུཾ ཡདི ཝདནེན སྭཱིཀརོཥི, ཏཐེཤྭརསྟཾ ཤྨཤཱནཱད྄ ཨུདསྠཱཔཡད྄ ཨིཏི ཡདྱནྟཿཀརཎེན ཝིཤྭསིཥི ཏརྷི པརིཏྲཱཎཾ ལཔྶྱསེ། ");
INSERT INTO santib_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ཡསྨཱཏ྄ པུཎྱཔྲཱཔྟྱརྠམ྄ ཨནྟཿཀརཎེན ཝིཤྭསིཏཝྱཾ པརིཏྲཱཎཱརྠཉྩ ཝདནེན སྭཱིཀརྟྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ཤཱསྟྲེ ཡཱདྲྀཤཾ ལིཁཏི ཝིཤྭསིཥྱཏི ཡསྟཏྲ ས ཛནོ ན ཏྲཔིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ཨིཏྱཏྲ ཡིཧཱུདིནི ཏདནྱལོཀེ ཙ ཀོཔི ཝིཤེཥོ ནཱསྟི ཡསྨཱད྄ ཡཿ སཪྻྭེཥཱམ྄ ཨདྭིཏཱིཡཿ པྲབྷུཿ ས ནིཛཡཱཙཀཱན སཪྻྭཱན྄ པྲཏི ཝདཱནྱོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ཡཏཿ, ཡཿ ཀཤྩིཏ྄ པརམེཤསྱ ནཱམྣཱ ཧི པྲཱརྠཡིཥྱཏེ། ས ཨེཝ མནུཛོ ནཱུནཾ པརིཏྲཱཏོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ཡཾ ཡེ ཛནཱ ན པྲཏྱཱཡན྄ ཏེ ཏམུདྡིཤྱ ཀཐཾ པྲཱརྠཡིཥྱནྟེ? ཡེ ཝཱ ཡསྱཱཁྱཱནཾ ཀདཱཔི ན ཤྲུཏཝནྟསྟེ ཏཾ ཀཐཾ པྲཏྱེཥྱནྟི? ཨཔརཾ ཡདི པྲཙཱརཡིཏཱརོ ན ཏིཥྛནྟི ཏདཱ ཀཐཾ ཏེ ཤྲོཥྱནྟི? ");
INSERT INTO santib_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ཡདི ཝཱ པྲེརིཏཱ ན བྷཝནྟི ཏདཱ ཀཐཾ པྲཙཱརཡིཥྱནྟི? ཡཱདྲྀཤཾ ལིཁིཏམ྄ ཨཱསྟེ, ཡཐཱ, མཱངྒལིཀཾ སུསཾཝཱདཾ དདཏྱཱནཱིཡ ཡེ ནརཱཿ། པྲཙཱརཡནྟི ཤཱནྟེཤྩ སུསཾཝཱདཾ ཛནཱསྟུ ཡེ། ཏེཥཱཾ ཙརཎཔདྨཱནི ཀཱིདྲྀཀ྄ ཤོབྷཱནྭིཏཱནི ཧི། ");
INSERT INTO santib_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ཀིནྟུ ཏེ སཪྻྭེ ཏཾ སུསཾཝཱདཾ ན གྲྀཧཱིཏཝནྟཿ། ཡིཤཱཡིཡོ ཡཐཱ ལིཁིཏཝཱན྄། ཨསྨཏྤྲཙཱརིཏེ ཝཱཀྱེ ཝིཤྭཱསམཀརོདྡྷི ཀཿ། ");
INSERT INTO santib_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ཨཏཨེཝ ཤྲཝཎཱད྄ ཝིཤྭཱས ཨཻཤྭརཝཱཀྱཔྲཙཱརཱཏ྄ ཤྲཝཎཉྩ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ཏརྷྱཧཾ བྲཝཱིམི ཏཻཿ ཀིཾ ནཱཤྲཱཝི? ཨཝཤྱམ྄ ཨཤྲཱཝི, ཡསྨཱཏ྄ ཏེཥཱཾ ཤབྡོ མཧཱིཾ ཝྱཱཔྣོད྄ ཝཱཀྱཉྩ ནིཁིལཾ ཛགཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ཨཔརམཔི ཝདཱམི, ཨིསྲཱཡེལཱིཡལོཀཱཿ ཀིམ྄ ཨེཏཱཾ ཀཐཱཾ ན བུདྷྱནྟེ? པྲཐམཏོ མཱུསཱ ཨིདཾ ཝཱཀྱཾ པྲོཝཱཙ, ཨཧམུཏྟཱཔཡིཥྱེ ཏཱན྄ ཨགཎྱམཱནཝཻརཔི། ཀླེཀྵྱཱམི ཛཱཏིམ྄ ཨེཏཱཉྩ པྲོནྨཏྟབྷིནྣཛཱཏིབྷིཿ། ");
INSERT INTO santib_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ཨཔརཉྩ ཡིཤཱཡིཡོ྅ཏིཤཡཱཀྵོབྷེཎ ཀཐཡཱམཱས, ཡཐཱ, ཨདྷི མཱཾ ཡཻསྟུ ནཱཙེཥྚི སམྤྲཱཔྟསྟཻ རྫནཻརཧཾ། ཨདྷི མཱཾ ཡཻ རྣ སམྤྲྀཥྚཾ ཝིཛྙཱཏསྟཻ རྫནཻརཧཾ༎ ");
INSERT INTO santib_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ཀིནྟྭིསྲཱཡེལཱིཡལོཀཱན྄ ཨདྷི ཀཐཡཱཉྩཀཱར, ཡཻརཱཛྙཱལངྒྷིབྷི རློཀཻ ཪྻིརུདྡྷཾ ཝཱཀྱམུཙྱཏེ། ཏཱན྄ པྲཏྱེཝ དིནཾ ཀྲྀཏྶྣཾ ཧསྟཽ ཝིསྟཱརཡཱམྱཧཾ༎ ");
INSERT INTO santib_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ཨཱིཤྭརེཎ སྭཱིཀཱིཡལོཀཱ ཨཔསཱརིཏཱ ཨཧཾ ཀིམ྄ ཨཱིདྲྀཤཾ ཝཱཀྱཾ བྲཝཱིམི? ཏནྣ བྷཝཏུ ཡཏོ྅ཧམཔི བིནྱཱམཱིནགོཏྲཱིཡ ཨིབྲཱཧཱིམཝཾཤཱིཡ ཨིསྲཱཡེལཱིཡལོཀོ྅སྨི། ");
INSERT INTO santib_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ཨཱིཤྭརེཎ པཱུཪྻྭཾ ཡེ པྲདྲྀཥྚཱསྟེ སྭཀཱིཡལོཀཱ ཨཔསཱརིཏཱ ཨིཏི ནཧི། ཨཔརམ྄ ཨེལིཡོཔཱཁྱཱནེ ཤཱསྟྲེ ཡལླིཁིཏམ྄ ཨཱསྟེ ཏད྄ ཡཱུཡཾ ཀིཾ ན ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ཧེ པརམེཤྭར ལོཀཱསྟྭདཱིཡཱཿ སཪྻྭཱ ཡཛྙཝེདཱིརབྷཉྫན྄ ཏཐཱ ཏཝ བྷཝིཥྱདྭཱདིནཿ སཪྻྭཱན྄ ཨགྷྣན྄ ཀེཝལ ཨེཀོ྅ཧམ྄ ཨཝཤིཥྚ ཨཱསེ ཏེ མམཱཔི པྲཱཎཱན྄ ནཱཤཡིཏུཾ ཙེཥྚནཏེ, ཨེཏཱཾ ཀཐཱམ྄ ཨིསྲཱཡེལཱིཡལོཀཱནཱཾ ཝིརུདྡྷམ྄ ཨེལིཡ ཨཱིཤྭརཱཡ ནིཝེདཡཱམཱས། ");
INSERT INTO santib_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ཏཏསྟཾ པྲཏཱིཤྭརསྱོཏྟརཾ ཀིཾ ཛཱཏཾ? བཱལྣཱམྣོ དེཝསྱ སཱཀྵཱཏ྄ ཡཻ རྫཱནཱུནི ན པཱཏིཏཱནི ཏཱདྲྀཤཱཿ སཔྟ སཧསྲཱཎི ལོཀཱ ཨཝཤེཥིཏཱ མཡཱ། ");
INSERT INTO santib_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ཏདྭད྄ ཨེཏསྨིན྄ ཝརྟྟམཱནཀཱལེ྅པི ཨནུགྲཧེཎཱབྷིརུཙིཏཱསྟེཥཱམ྄ ཨཝཤིཥྚཱཿ ཀཏིཔཡཱ ལོཀཱཿ སནྟི། ");
INSERT INTO santib_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ཨཏཨེཝ ཏད྄ ཡདྱནུགྲཧེཎ བྷཝཏི ཏརྷི ཀྲིཡཡཱ ན བྷཝཏི ནོ ཙེད྄ ཨནུགྲཧོ྅ནནུགྲཧ ཨེཝ, ཡདི ཝཱ ཀྲིཡཡཱ བྷཝཏི ཏརྷྱནུགྲཧེཎ ན བྷཝཏི ནོ ཙེཏ྄ ཀྲིཡཱ ཀྲིཡཻཝ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ཏརྷི ཀིཾ? ཨིསྲཱཡེལཱིཡལོཀཱ ཡད྄ ཨམྲྀགཡནྟ ཏནྣ པྲཱཔུཿ། ཀིནྟྭབྷིརུཙིཏལོཀཱསྟཏ྄ པྲཱཔུསྟདནྱེ སཪྻྭ ཨནྡྷཱིབྷཱུཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, གྷོརནིདྲཱལུཏཱབྷཱཝཾ དྲྀཥྚིཧཱིནེ ཙ ལོཙནེ། ཀརྞཽ ཤྲུཏིཝིཧཱིནཽ ཙ པྲདདཽ ཏེབྷྱ ཨཱིཤྭརཿ༎ ");
INSERT INTO santib_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ཨེཏེསྨིན྄ དཱཡཱུདཔི ལིཁིཏཝཱན྄ ཡཐཱ, ཨཏོ བྷུཀྟྱཱསནཾ ཏེཥཱམ྄ ཨུནྨཱཐཝད྄ བྷཝིཥྱཏི། ཝཱ ཝཾཤཡནྟྲཝད྄ བཱདྷཱ དཎྜཝད྄ ཝཱ བྷཝིཥྱཏི༎ ");
INSERT INTO santib_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","བྷཝིཥྱནྟི ཏཐཱནྡྷཱསྟེ ནེཏྲཻཿ པཤྱནྟི ནོ ཡཐཱ། ཝེཔཐུཿ ཀཊིདེཤསྱ ཏེཥཱཾ ནིཏྱཾ བྷཝིཥྱཏི༎ ");
INSERT INTO santib_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","པཏནཱརྠཾ ཏེ སྑལིཏཝནྟ ཨིཏི ཝཱཙཾ ཀིམཧཾ ཝདཱམི? ཏནྣ བྷཝཏུ ཀིནྟུ ཏཱན྄ ཨུདྱོགིནཿ ཀརྟྟུཾ ཏེཥཱཾ པཏནཱད྄ ཨིཏརདེཤཱིཡལོཀཻཿ པརིཏྲཱཎཾ པྲཱཔྟཾ། ");
INSERT INTO santib_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ཏེཥཱཾ པཏནཾ ཡདི ཛགཏོ ལོཀཱནཱཾ ལཱབྷཛནཀམ྄ ཨབྷཝཏ྄ ཏེཥཱཾ ཧྲཱསོ྅པི ཡདི བྷིནྣདེཤིནཱཾ ལཱབྷཛནཀོ྅བྷཝཏ྄ ཏརྷི ཏེཥཱཾ ཝྲྀདྡྷིཿ ཀཏི ལཱབྷཛནིཀཱ བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ཨཏོ ཧེ ཨནྱདེཤིནོ ཡུཥྨཱན྄ སམྦོདྷྱ ཀཐཡཱམི ནིཛཱནཱཾ ཛྙཱཏིབནྡྷཱུནཱཾ མནཿསཱུདྱོགཾ ཛནཡན྄ ཏེཥཱཾ མདྷྱེ ཀིཡཏཱཾ ལོཀཱནཱཾ ཡཐཱ པརིཏྲཱཎཾ སཱདྷཡཱམི ");
INSERT INTO santib_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ཏནྣིམིཏྟམ྄ ཨནྱདེཤིནཱཾ ནིཀཊེ པྲེརིཏཿ སན྄ ཨཧཾ སྭཔདསྱ མཧིམཱནཾ པྲཀཱཤཡཱམི། ");
INSERT INTO santib_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ཏེཥཱཾ ནིགྲཧེཎ ཡདཱིཤྭརེཎ སཧ ཛགཏོ ཛནཱནཱཾ མེལནཾ ཛཱཏཾ ཏརྷི ཏེཥཱམ྄ ཨནུགྲྀཧཱིཏཏྭཾ མྲྀཏདེཧེ ཡཐཱ ཛཱིཝནལཱབྷསྟདྭཏ྄ ཀིཾ ན བྷཝིཥྱཏི? ");
INSERT INTO santib_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ཨཔརཾ པྲཐམཛཱཏཾ ཕལཾ ཡདི པཝིཏྲཾ བྷཝཏི ཏརྷི སཪྻྭམེཝ ཕལཾ པཝིཏྲཾ བྷཝིཥྱཏི; ཏཐཱ མཱུལཾ ཡདི པཝིཏྲཾ བྷཝཏི ཏརྷི ཤཱཁཱ ཨཔི ཏཐཻཝ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ཀིཡཏཱིནཱཾ ཤཱཁཱནཱཾ ཚེདནེ ཀྲྀཏེ ཏྭཾ ཝནྱཛིཏཝྲྀཀྵསྱ ཤཱཁཱ བྷཱུཏྭཱ ཡདི ཏཙྪཱཁཱནཱཾ སྠཱནེ རོཔིཏཱ སཏི ཛིཏཝྲྀཀྵཱིཡམཱུལསྱ རསཾ བྷུཾཀྵེ, ");
INSERT INTO santib_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ཏརྷི ཏཱསཱཾ བྷིནྣཤཱཁཱནཱཾ ཝིརུདྡྷཾ མཱཾ གཪྻྭཱིཿ; ཡདི གཪྻྭསི ཏརྷི ཏྭཾ མཱུལཾ ཡནྣ དྷཱརཡསི ཀིནྟུ མཱུལཾ ཏྭཱཾ དྷཱརཡཏཱིཏི སཾསྨར། ");
INSERT INTO santib_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ཨཔརཉྩ ཡདི ཝདསི མཱཾ རོཔཡིཏུཾ ཏཱཿ ཤཱཁཱ ཝིབྷནྣཱ ཨབྷཝན྄; ");
INSERT INTO santib_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","བྷདྲམ྄, ཨཔྲཏྱཡཀཱརཎཱཏ྄ ཏེ ཝིབྷིནྣཱ ཛཱཏཱསྟཐཱ ཝིཤྭཱསཀཱརཎཱཏ྄ ཏྭཾ རོཔིཏོ ཛཱཏསྟསྨཱད྄ ཨཧངྐཱརམ྄ ཨཀྲྀཏྭཱ སསཱདྷྭསོ བྷཝ། ");
INSERT INTO santib_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ཡཏ ཨཱིཤྭརོ ཡདི སྭཱབྷཱཝིཀཱིཿ ཤཱཁཱ ན རཀྵཏི ཏརྷི སཱཝདྷཱནོ བྷཝ ཙེཏ྄ ཏྭཱམཔི ན སྠཱཔཡཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ཨིཏྱཏྲེཤྭརསྱ ཡཱདྲྀཤཱི ཀྲྀཔཱ ཏཱདྲྀཤཾ བྷཡཱནཀཏྭམཔི ཏྭཡཱ དྲྀཤྱཏཱཾ; ཡེ པཏིཏཱསྟཱན྄ པྲཏི ཏསྱ བྷཡཱནཀཏྭཾ དྲྀཤྱཏཱཾ, ཏྭཉྩ ཡདི ཏཏྐྲྀཔཱཤྲིཏསྟིཥྛསི ཏརྷི ཏྭཱཾ པྲཏི ཀྲྀཔཱ དྲཀྵྱཏེ; ནོ ཙེཏ྄ ཏྭམཔི ཏདྭཏ྄ ཚིནྣོ བྷཝིཥྱསི། ");
INSERT INTO santib_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ཨཔརཉྩ ཏེ ཡདྱཔྲཏྱཡེ ན ཏིཥྛནྟི ཏརྷི པུནརཔི རོཔཡིཥྱནྟེ ཡསྨཱཏ྄ ཏཱན྄ པུནརཔི རོཔཡིཏུམ྄ ཨིཤྭརསྱ ཤཀྟིརཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ཝནྱཛིཏཝྲྀཀྵསྱ ཤཱཁཱ སན྄ ཏྭཾ ཡདི ཏཏཤྪིནྣོ རཱིཏིཝྱཏྱཡེནོཏྟམཛིཏཝྲྀཀྵེ རོेेཔིཏོ྅བྷཝསྟརྷི ཏསྱ ཝྲྀཀྵསྱ སྭཱིཡཱ ཡཱཿ ཤཱཁཱསྟཱཿ ཀིཾ པུནཿ སྭཝྲྀཀྵེ སཾལགིཏུཾ ན ཤཀྣུཝནྟི? ");
INSERT INTO santib_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ཧེ བྷྲཱཏརོ ཡུཥྨཱཀམ྄ ཨཱཏྨཱབྷིམཱནོ ཡནྣ ཛཱཡཏེ ཏདརྠཾ མམེདྲྀཤཱི ཝཱཉྪཱ བྷཝཏི ཡཱུཡཾ ཨེཏནྣིགཱུཌྷཏཏྟྭམ྄ ཨཛཱནནྟོ ཡནྣ ཏིཥྛཐ; ཝསྟུཏོ ཡཱཝཏྐཱལཾ སམྤཱུརྞརཱུཔེཎ བྷིནྣདེཤིནཱཾ སཾགྲཧོ ན བྷཝིཥྱཏི ཏཱཝཏྐཱལམ྄ ཨཾཤཏྭེན ཨིསྲཱཡེལཱིཡལོཀཱནཱམ྄ ཨནྡྷཏཱ སྠཱསྱཏི; ");
INSERT INTO santib_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","པཤྩཱཏ྄ ཏེ སཪྻྭེ པརིཏྲཱསྱནྟེ; ཨེཏཱདྲྀཤཾ ལིཁིཏམཔྱཱསྟེ, ཨཱགམིཥྱཏི སཱིཡོནཱད྄ ཨེཀོ ཡསྟྲཱཎདཱཡཀཿ། ཨདྷརྨྨཾ ཡཱཀུབོ ཝཾཤཱཏ྄ ས ཏུ དཱུརཱིཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ཏཐཱ དཱུརཱིཀརིཥྱཱམི ཏེཥཱཾ པཱཔཱནྱཧཾ ཡདཱ། ཏདཱ ཏཻརེཝ སཱརྡྡྷཾ མེ ནིཡམོ྅ཡཾ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","སུསཾཝཱདཱཏ྄ ཏེ ཡུཥྨཱཀཾ ཝིཔཀྵཱ ཨབྷཝན྄ ཀིནྟྭབྷིརུཙིཏཏྭཱཏ྄ ཏེ པིཏྲྀལོཀཱནཱཾ ཀྲྀཏེ པྲིཡཔཱཏྲཱཎི བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ཡཏ ཨཱིཤྭརསྱ དཱནཱད྄ ཨཱཧྭཱནཱཉྩ པཤྩཱཏྟཱཔོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ཨཏཨེཝ པཱུཪྻྭམ྄ ཨཱིཤྭརེ྅ཝིཤྭཱསིནཿ སནྟོ྅པི ཡཱུཡཾ ཡདྭཏ྄ སམྤྲཏི ཏེཥཱམ྄ ཨཝིཤྭཱསཀཱརཎཱད྄ ཨཱིཤྭརསྱ ཀྲྀཔཱཔཱཏྲཱཎི ཛཱཏཱསྟདྭད྄ ");
INSERT INTO santib_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ཨིདཱནཱིཾ ཏེ྅ཝིཤྭཱསིནཿ སནྟི ཀིནྟུ ཡུཥྨཱབྷི རླབྡྷཀྲྀཔཱཀཱརཎཱཏ྄ ཏཻརཔི ཀྲྀཔཱ ལཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ཨཱིཤྭརཿ སཪྻྭཱན྄ པྲཏི ཀྲྀཔཱཾ པྲཀཱཤཡིཏུཾ སཪྻྭཱན྄ ཨཝིཤྭཱསིཏྭེན གཎཡཏི། ");
INSERT INTO santib_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ཨཧོ ཨཱིཤྭརསྱ ཛྙཱནབུདྡྷིརཱུཔཡོ རྡྷནཡོཿ ཀཱིདྲྀཀ྄ པྲཱཙུཪྻྱཾ། ཏསྱ རཱཛཤཱསནསྱ ཏཏྟྭཾ ཀཱིདྲྀག྄ ཨཔྲཱཔྱཾ། ཏསྱ མཱརྒཱཤྩ ཀཱིདྲྀག྄ ཨནུཔལཀྵྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","པརམེཤྭརསྱ སངྐལྤཾ ཀོ ཛྙཱཏཝཱན྄? ཏསྱ མནྟྲཱི ཝཱ ཀོ྅བྷཝཏ྄? ");
INSERT INTO santib_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ཀོ ཝཱ ཏསྱོཔཀཱརཱི བྷྲྀཏྭཱ ཏཏྐྲྀཏེ ཏེན པྲཏྱུཔཀརྟྟཝྱཿ? ");
INSERT INTO santib_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ཡཏོ ཝསྟུམཱཏྲམེཝ ཏསྨཱཏ྄ ཏེན ཏསྨཻ ཙཱབྷཝཏ྄ ཏདཱིཡོ མཧིམཱ སཪྻྭདཱ པྲཀཱཤིཏོ བྷཝཏུ། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ཧེ བྷྲཱཏར ཨཱིཤྭརསྱ ཀྲྀཔཡཱཧཾ ཡུཥྨཱན྄ ཝིནཡེ ཡཱུཡཾ སྭཾ སྭཾ ཤརཱིརཾ སཛཱིཝཾ པཝིཏྲཾ གྲཱཧྱཾ བལིམ྄ ཨཱིཤྭརམུདྡིཤྱ སམུཏྶྲྀཛཏ, ཨེཥཱ སེཝཱ ཡུཥྨཱཀཾ ཡོགྱཱ། ");
INSERT INTO santib_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ཨཔརཾ ཡཱུཡཾ སཱཾསཱརིཀཱ ཨིཝ མཱཙརཏ, ཀིནྟུ སྭཾ སྭཾ སྭབྷཱཝཾ པརཱཝརྟྱ ནཱུཏནཱཙཱརིཎོ བྷཝཏ, ཏཏ ཨཱིཤྭརསྱ ནིདེཤཿ ཀཱིདྲྀག྄ ཨུཏྟམོ གྲཧཎཱིཡཿ སམྤཱུརྞཤྩེཏི ཡུཥྨཱབྷིརནུབྷཱཝིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ཀཤྩིདཔི ཛནོ ཡོགྱཏྭཱདདྷིཀཾ སྭཾ ན མནྱཏཱཾ ཀིནྟུ ཨཱིཤྭརོ ཡསྨཻ པྲཏྱཡསྱ ཡཏྤརིམཱཎམ྄ ཨདདཱཏ྄ ས ཏདནུསཱརཏོ ཡོགྱརཱུཔཾ སྭཾ མནུཏཱམ྄, ཨཱིཤྭརཱད྄ ཨནུགྲཧཾ པྲཱཔྟཿ སན྄ ཡུཥྨཱཀམ྄ ཨེཀཻཀཾ ཛནམ྄ ཨིཏྱཱཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ཡཏོ ཡདྭདསྨཱཀམ྄ ཨེཀསྨིན྄ ཤརཱིརེ བཧཱུནྱངྒཱནི སནྟི ཀིནྟུ སཪྻྭེཥཱམངྒཱནཱཾ ཀཱཪྻྱཾ སམཱནཾ ནཧི; ");
INSERT INTO santib_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ཏདྭདསྨཱཀཾ བཧུཏྭེ྅པི སཪྻྭེ ཝཡཾ ཁྲཱིཥྚེ ཨེཀཤརཱིརཱཿ པརསྤརམ྄ ཨངྒཔྲཏྱངྒཏྭེན བྷཝཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ཨསྨཱད྄ ཨཱིཤྭརཱནུགྲཧེཎ ཝིཤེཥཾ ཝིཤེཥཾ དཱནམ྄ ཨསྨཱསུ པྲཱཔྟེཥུ སཏྶུ ཀོཔི ཡདི བྷཝིཥྱདྭཱཀྱཾ ཝདཏི ཏརྷི པྲཏྱཡསྱ པརིམཱཎཱནུསཱརཏཿ ས ཏད྄ ཝདཏུ; ");
INSERT INTO santib_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ཡདྭཱ ཡདི ཀཤྩིཏ྄ སེཝནཀཱརཱི བྷཝཏི ཏརྷི ས ཏཏྶེཝནཾ ཀརོཏུ; ཨཐཝཱ ཡདི ཀཤྩིད྄ ཨདྷྱཱཔཡིཏཱ བྷཝཏི ཏརྷི སོ྅དྷྱཱཔཡཏུ; ");
INSERT INTO santib_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ཏཐཱ ཡ ཨུཔདེཥྚཱ བྷཝཏི ས ཨུཔདིཤཏུ ཡཤྩ དཱཏཱ ས སརལཏཡཱ དདཱཏུ ཡསྟྭདྷིཔཏིཿ ས ཡཏྣེནཱདྷིཔཏིཏྭཾ ཀརོཏུ ཡཤྩ དཡཱལུཿ ས ཧྲྀཥྚམནསཱ དཡཏཱམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ཨཔརཉྩ ཡུཥྨཱཀཾ པྲེམ ཀཱཔཊྱཝརྫིཏཾ བྷཝཏུ ཡད྄ ཨབྷདྲཾ ཏད྄ ཨྲྀཏཱིཡདྷྭཾ ཡཙྩ བྷདྲཾ ཏསྨིན྄ ཨནུརཛྱདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ཨཔརཾ བྷྲཱཏྲྀཏྭཔྲེམྣཱ པརསྤརཾ པྲཱིཡདྷྭཾ སམཱདརཱད྄ ཨེཀོ྅པརཛནཾ ཤྲེཥྛཾ ཛཱནཱིདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ཏཐཱ ཀཱཪྻྱེ ནིརཱལསྱཱ མནསི ཙ སོདྱོགཱཿ སནྟཿ པྲབྷུཾ སེཝདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ཨཔརཾ པྲཏྱཱཤཱཡཱམ྄ ཨཱནནྡིཏཱ དུཿཁསམཡེ ཙ དྷཻཪྻྱཡུཀྟཱ བྷཝཏ; པྲཱརྠནཱཡཱཾ སཏཏཾ པྲཝརྟྟདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","པཝིཏྲཱཎཱཾ དཱིནཏཱཾ དཱུརཱིཀུརུདྷྭམ྄ ཨཏིཐིསེཝཱཡཱམ྄ ཨནུརཛྱདྷྭམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ཡེ ཛནཱ ཡུཥྨཱན྄ ཏཱཌཡནྟི ཏཱན྄ ཨཱཤིཥཾ ཝདཏ ཤཱཔམ྄ ཨདཏྟྭཱ དདྡྷྭམཱཤིཥམ྄། ");
INSERT INTO santib_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ཡེ ཛནཱ ཨཱནནྡནྟི ཏཻཿ སཱརྡྡྷམ྄ ཨཱནནྡཏ ཡེ ཙ རུདནྟི ཏཻཿ སཧ རུདིཏ། ");
INSERT INTO santib_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ཨཔརཉྩ ཡུཥྨཱཀཾ མནསཱཾ པརསྤརམ྄ ཨེཀོབྷཱཝོ བྷཝཏུ; ཨཔརམ྄ ཨུཙྩཔདམ྄ ཨནཱཀཱངྐྵྱ ནཱིཙལོཀཻཿ སཧཱཔི མཱརྡཝམ྄ ཨཱཙརཏ; སྭཱན྄ ཛྙཱནིནོ ན མནྱདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","པརསྨཱད྄ ཨཔཀཱརཾ པྲཱཔྱཱཔི པརཾ ནཱཔཀུརུཏ། སཪྻྭེཥཱཾ དྲྀཥྚིཏོ ཡཏ྄ ཀརྨྨོཏྟམཾ ཏདེཝ ཀུརུཏ། ");
INSERT INTO santib_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ཡདི བྷཝིཏུཾ ཤཀྱཏེ ཏརྷི ཡཐཱཤཀྟི སཪྻྭལོཀཻཿ སཧ ནིཪྻྭིརོདྷེན ཀཱལཾ ཡཱཔཡཏ། ");
INSERT INTO santib_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ཧེ པྲིཡབནྡྷཝཿ, ཀསྨཻཙིད྄ ཨཔཀཱརསྱ སམུཙིཏཾ དཎྜཾ སྭཡཾ ན དདྡྷྭཾ, ཀིནྟྭཱིཤྭརཱིཡཀྲོདྷཱཡ སྠཱནཾ དཏྟ ཡཏོ ལིཁིཏམཱསྟེ པརམེཤྭརཿ ཀཐཡཏི, དཱནཾ ཕལསྱ མཏྐརྨྨ སཱུཙིཏཾ པྲདདཱམྱཧཾ། ");
INSERT INTO santib_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ཨིཏིཀཱརཎཱད྄ རིཔུ ཪྻདི ཀྵུདྷཱརྟྟསྟེ ཏརྷི ཏཾ ཏྭཾ པྲབྷོཛཡ། ཏཐཱ ཡདི ཏྲྀཥཱརྟྟཿ སྱཱཏ྄ ཏརྷི ཏཾ པརིཔཱཡཡ། ཏེན ཏྭཾ མསྟཀེ ཏསྱ ཛྭལདགྣིཾ ནིདྷཱསྱསི། ");
INSERT INTO santib_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ཀུཀྲིཡཡཱ པརཱཛིཏཱ ན སནྟ ཨུཏྟམཀྲིཡཡཱ ཀུཀྲིཡཱཾ པརཱཛཡཏ། ");
INSERT INTO santib_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ཡུཥྨཱཀམ྄ ཨེཀཻཀཛནཿ ཤཱསནཔདསྱ ནིགྷྣོ བྷཝཏུ ཡཏོ ཡཱནི ཤཱསནཔདཱནི སནྟི ཏཱནི སཪྻྭཱཎཱིཤྭརེཎ སྠཱཔིཏཱནི; ཨཱིཤྭརཾ ཝིནཱ པདསྠཱཔནཾ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ཨིཏི ཧེཏོཿ ཤཱསནཔདསྱ ཡཏ྄ པྲཱཏིཀཱུལྱཾ ཏད྄ ཨཱིཤྭརཱིཡནིརཱུཔཎསྱ པྲཱཏིཀཱུལྱམེཝ; ཨཔརཾ ཡེ པྲཱཏིཀཱུལྱམ྄ ཨཱཙརནྟི ཏེ སྭེཥཱཾ སམུཙིཏཾ དཎྜཾ སྭཡམེཝ གྷཊཡནྟེ། ");
INSERT INTO santib_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ཤཱསྟཱ སདཱཙཱརིཎཱཾ བྷཡཔྲདོ ནཧི དུརཱཙཱརིཎཱམེཝ བྷཡཔྲདོ བྷཝཏི; ཏྭཾ ཀིཾ ཏསྨཱན྄ ནིརྦྷཡོ བྷཝིཏུམ྄ ཨིཙྪསི? ཏརྷི སཏྐརྨྨཱཙར, ཏསྨཱད྄ ཡཤོ ལཔྶྱསེ, ");
INSERT INTO santib_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ཡཏསྟཝ སདཱཙརཎཱཡ ས ཨཱིཤྭརསྱ བྷྲྀཏྱོ྅སྟི། ཀིནྟུ ཡདི ཀུཀརྨྨཱཙརསི ཏརྷི ཏྭཾ ཤངྐསྭ ཡཏཿ ས ནིརརྠཀཾ ཁངྒཾ ན དྷཱརཡཏི; ཀུཀརྨྨཱཙཱརིཎཾ སམུཙིཏཾ དཎྜཡིཏུམ྄ ས ཨཱིཤྭརསྱ དཎྜདབྷྲྀཏྱ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ཨཏཨེཝ ཀེཝལདཎྜབྷཡཱནྣཧི ཀིནྟུ སདསདྦོདྷཱདཔི ཏསྱ ཝཤྱེན བྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ཨེཏསྨཱད྄ ཡུཥྨཱཀཾ རཱཛཀརདཱནམཔྱུཙིཏཾ ཡསྨཱད྄ ཡེ ཀརཾ གྲྀཧླནྟི ཏ ཨཱིཤྭརསྱ ཀིངྐརཱ བྷཱུཏྭཱ སཏཏམ྄ ཨེཏསྨིན྄ ཀརྨྨཎི ནིཝིཥྚཱསྟིཥྛནྟི། ");
INSERT INTO santib_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ཨསྨཱཏ྄ ཀརགྲཱཧིཎེ ཀརཾ དཏྟ, ཏཐཱ ཤུལྐགྲཱཧིཎེ ཤུལྐཾ དཏྟ, ཨཔརཾ ཡསྨཱད྄ བྷེཏཝྱཾ ཏསྨཱད྄ བིབྷཱིཏ, ཡཤྩ སམཱདརཎཱིཡསྟཾ སམཱདྲིཡདྷྭམ྄; ཨིཏྠཾ ཡསྱ ཡཏ྄ པྲཱཔྱཾ ཏཏ྄ ཏསྨཻ དཏྟ། ");
INSERT INTO santib_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ཡུཥྨཱཀཾ པརསྤརཾ པྲེམ ཝིནཱ ྅ནྱཏ྄ ཀིམཔི དེཡམ྄ ཨྲྀཎཾ ན བྷཝཏུ, ཡཏོ ཡཿ པརསྨིན྄ པྲེམ ཀརོཏི ཏེན ཝྱཝསྠཱ སིདྷྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ཝསྟུཏཿ པརདཱརཱན྄ མཱ གཙྪ, ནརཧཏྱཱཾ མཱ ཀཱརྵཱིཿ, ཙཻཪྻྱཾ མཱ ཀཱརྵཱིཿ, མིཐྱཱསཱཀྵྱཾ མཱ དེཧི, ལོབྷཾ མཱ ཀཱརྵཱིཿ, ཨེཏཱཿ སཪྻྭཱ ཨཱཛྙཱ ཨེཏཱབྷྱོ བྷིནྣཱ ཡཱ ཀཱཙིད྄ ཨཱཛྙཱསྟི སཱཔི སྭསམཱིཔཝཱསིནི སྭཝཏ྄ པྲེམ ཀུཪྻྭིཏྱནེན ཝཙནེན ཝེདིཏཱ། ");
INSERT INTO santib_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ཡཏཿ པྲེམ སམཱིཔཝཱསིནོ྅ཤུབྷཾ ན ཛནཡཏི ཏསྨཱཏ྄ པྲེམྣཱ སཪྻྭཱ ཝྱཝསྠཱ པཱལྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","པྲཏྱཡཱིབྷཝནཀཱལེ྅སྨཱཀཾ པརིཏྲཱཎསྱ སཱམཱིཔྱཱད྄ ཨིདཱནཱིཾ ཏསྱ སཱམཱིཔྱམ྄ ཨཝྱཝཧིཏཾ; ཨཏཿ སམཡཾ ཝིཝིཙྱཱསྨཱབྷིཿ སཱམྤྲཏམ྄ ཨཝཤྱམེཝ ནིདྲཱཏོ ཛཱགརྟྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","བཧུཏརཱ ཡཱམིནཱི གཏཱ པྲབྷཱཏཾ སནྣིདྷིཾ པྲཱཔྟཾ ཏསྨཱཏ྄ ཏཱམསཱིཡཱཿ ཀྲིཡཱཿ པརིཏྱཛྱཱསྨཱབྷི ཪྻཱསརཱིཡཱ སཛྫཱ པརིདྷཱཏཝྱཱ། ");
INSERT INTO santib_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ཨཏོ ཧེཏོ ཪྻཡཾ དིཝཱ ཝིཧིཏཾ སདཱཙརཎམ྄ ཨཱཙརིཥྱཱམཿ། རངྒརསོ མཏྟཏྭཾ ལམྤཊཏྭཾ ཀཱམུཀཏྭཾ ཝིཝཱད ཨཱིརྵྱཱ ཙཻཏཱནི པརིཏྱཀྵྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ཡཱུཡཾ པྲབྷུཡཱིཤུཁྲཱིཥྚརཱུཔཾ པརིཙྪདཾ པརིདྷདྡྷྭཾ སུཁཱབྷིལཱཥཔཱུརཎཱཡ ཤཱརཱིརིཀཱཙརཎཾ མཱཙརཏ། ");
INSERT INTO santib_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ཡོ ཛནོ྅དྲྀཌྷཝིཤྭཱསསྟཾ ཡུཥྨཱཀཾ སངྒིནཾ ཀུརུཏ ཀིནྟུ སནྡེཧཝིཙཱརཱརྠཾ ནཧི། ");
INSERT INTO santib_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ཡཏོ ནིཥིདྡྷཾ ཀིམཔི ཁཱདྱདྲཝྱཾ ནཱསྟི, ཀསྱཙིཛྫནསྱ པྲཏྱཡ ཨེཏཱདྲྀཤོ ཝིདྱཏེ ཀིནྟྭདྲྀཌྷཝིཤྭཱསཿ ཀཤྩིདཔརོ ཛནཿ ཀེཝལཾ ཤཱཀཾ བྷུངྐྟཾ། ");
INSERT INTO santib_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ཏརྷི ཡོ ཛནཿ སཱདྷཱརཎཾ དྲཝྱཾ བྷུངྐྟེ ས ཝིཤེཥདྲཝྱབྷོཀྟཱརཾ ནཱཝཛཱནཱིཡཱཏ྄ ཏཐཱ ཝིཤེཥདྲཝྱབྷོཀྟཱཔི སཱདྷཱརཎདྲཝྱབྷོཀྟཱརཾ དོཥིཎཾ ན ཀུཪྻྱཱཏ྄, ཡསྨཱད྄ ཨཱིཤྭརསྟམ྄ ཨགྲྀཧླཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ཧེ པརདཱསསྱ དཱུཥཡིཏསྟྭཾ ཀཿ? ནིཛཔྲབྷོཿ སམཱིཔེ ཏེན པདསྠེན པདཙྱུཏེན ཝཱ བྷཝིཏཝྱཾ ས ཙ པདསྠ ཨེཝ བྷཝིཥྱཏི ཡཏ ཨཱིཤྭརསྟཾ པདསྠཾ ཀརྟྟུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ཨཔརཉྩ ཀཤྩིཛྫནོ དིནཱད྄ དིནཾ ཝིཤེཥཾ མནྱཏེ ཀཤྩིཏྟུु སཪྻྭཱཎི དིནཱནི སམཱནཱནི མནྱཏེ, ཨེཀཻཀོ ཛནཿ སྭཱིཡམནསི ཝིཝིཙྱ ནིཤྩིནོཏུ། ");
INSERT INTO santib_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ཡོ ཛནཿ ཀིཉྩན དིནཾ ཝིཤེཥཾ མནྱཏེ ས པྲབྷུབྷཀྟྱཱ ཏན྄ མནྱཏེ, ཡཤྩ ཛནཿ ཀིམཔི དིནཾ ཝིཤེཥཾ ན མནྱཏེ སོ྅པི པྲབྷུབྷཀྟྱཱ ཏནྣ མནྱཏེ; ཨཔརཉྩ ཡཿ སཪྻྭཱཎི བྷཀྵྱདྲཝྱཱཎི བྷུངྐྟེ ས པྲབྷུབྷཀྟཡཱ ཏཱནི བྷུངྐྟེ ཡཏཿ ས ཨཱིཤྭརཾ དྷནྱཾ ཝཀྟི, ཡཤྩ ན བྷུངྐྟེ སོ྅པི པྲབྷུབྷཀྟྱཻཝ ན བྷུཉྫཱན ཨཱིཤྭརཾ དྷནྱཾ བྲཱུཏེ། ");
INSERT INTO santib_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ཨཔརམ྄ ཨསྨཱཀཾ ཀཤྩིཏ྄ ནིཛནིམིཏྟཾ པྲཱཎཱན྄ དྷཱརཡཏི ནིཛནིམིཏྟཾ མྲིཡཏེ ཝཱ ཏནྣ; ");
INSERT INTO santib_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ཀིནྟུ ཡདི ཝཡཾ པྲཱཎཱན྄ དྷཱརཡཱམསྟརྷི པྲབྷུནིམིཏྟཾ དྷཱརཡཱམཿ, ཡདི ཙ པྲཱཎཱན྄ ཏྱཛཱམསྟརྷྱཔི པྲབྷུནིམིཏྟཾ ཏྱཛཱམཿ, ཨཏཨེཝ ཛཱིཝནེ མརཎེ ཝཱ ཝཡཾ པྲབྷོརེཝཱསྨཧེ། ");
INSERT INTO santib_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ཡཏོ ཛཱིཝནྟོ མྲྀཏཱཤྩེཏྱུབྷཡེཥཱཾ ལོཀཱནཱཾ པྲབྷུཏྭཔྲཱཔྟྱརྠཾ ཁྲཱིཥྚོ མྲྀཏ ཨུཏྠིཏཿ པུནརྫཱིཝིཏཤྩ། ");
INSERT INTO santib_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ཀིནྟུ ཏྭཾ ནིཛཾ བྷྲཱཏརཾ ཀུཏོ དཱུཥཡསི? ཏཐཱ ཏྭཾ ནིཛཾ བྷྲཱཏརཾ ཀུཏསྟུཙྪཾ ཛཱནཱསི? ཁྲཱིཥྚསྱ ཝིཙཱརསིཾཧཱསནསྱ སམྨུཁེ སཪྻྭཻརསྨཱབྷིརུཔསྠཱཏཝྱཾ; ");
INSERT INTO santib_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ཡཱདྲྀཤཾ ལིཁིཏམ྄ ཨཱསྟེ, པརེཤཿ ཤཔཐཾ ཀུཪྻྭན྄ ཝཱཀྱམེཏཏ྄ པུརཱཝདཏ྄། སཪྻྭོ ཛནཿ སམཱིཔེ མེ ཛཱནུཔཱཏཾ ཀརིཥྱཏི། ཛིཧྭཻཀཻཀཱ ཏཐེཤསྱ ནིགྷྣཏྭཾ སྭཱིཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ཨཏཨེཝ ཨཱིཤྭརསམཱིཔེ྅སྨཱཀམ྄ ཨེཀཻཀཛནེན ནིཛཱ ཀཐཱ ཀཐཡིཏཝྱཱ། ");
INSERT INTO santib_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ཨིཏྠཾ སཏི ཝཡམ྄ ཨདྱཱརབྷྱ པརསྤརཾ ན དཱུཥཡནྟཿ སྭབྷྲཱཏུ ཪྻིགྷྣོ ཝྱཱགྷཱཏོ ཝཱ ཡནྣ ཛཱཡེཏ ཏཱདྲྀཤཱིམཱིཧཱཾ ཀུརྨྨཧེ། ");
INSERT INTO santib_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ཀིམཔི ཝསྟུ སྭབྷཱཝཏོ ནཱཤུཙི བྷཝཏཱིཏྱཧཾ ཛཱནེ ཏཐཱ པྲབྷུནཱ ཡཱིཤུཁྲཱིཥྚེནཱཔི ནིཤྩིཏཾ ཛཱནེ, ཀིནྟུ ཡོ ཛནོ ཡད྄ དྲཝྱམ྄ ཨཔཝིཏྲཾ ཛཱནཱིཏེ ཏསྱ ཀྲྀཏེ ཏད྄ ཨཔཝིཏྲམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ཨཏཨེཝ ཏཝ བྷཀྵྱདྲཝྱེཎ ཏཝ བྷྲཱཏཱ ཤོཀཱནྭིཏོ བྷཝཏི ཏརྷི ཏྭཾ བྷྲཱཏརཾ པྲཏི པྲེམྣཱ ནཱཙརསི། ཁྲཱིཥྚོ ཡསྱ ཀྲྀཏེ སྭཔྲཱཎཱན྄ ཝྱཡིཏཝཱན྄ ཏྭཾ ནིཛེན བྷཀྵྱདྲཝྱེཎ ཏཾ ན ནཱཤཡ། ");
INSERT INTO santib_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ཨཔརཾ ཡུཥྨཱཀམ྄ ཨུཏྟམཾ ཀརྨྨ ནིནྡིཏཾ ན བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","བྷཀྵྱཾ པེཡཉྩེཤྭརརཱཛྱསྱ སཱརོ ནཧི, ཀིནྟུ པུཎྱཾ ཤཱནྟིཤྩ པཝིཏྲེཎཱཏྨནཱ ཛཱཏ ཨཱནནྡཤྩ། ");
INSERT INTO santib_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ཨེཏཻ ཪྻོ ཛནཿ ཁྲཱིཥྚཾ སེཝཏེ, ས ཨེཝེཤྭརསྱ ཏུཥྚིཀརོ མནུཥྱཻཤྩ སུཁྱཱཏཿ། ");
INSERT INTO santib_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ཨཏཨེཝ ཡེནཱསྨཱཀཾ སཪྻྭེཥཱཾ པརསྤརམ྄ ཨཻཀྱཾ ནིཥྛཱ ཙ ཛཱཡཏེ ཏདེཝཱསྨཱབྷི ཪྻཏིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","བྷཀྵྱཱརྠམ྄ ཨཱིཤྭརསྱ ཀརྨྨཎོ ཧཱནིཾ མཱ ཛནཡཏ; སཪྻྭཾ ཝསྟུ པཝིཏྲམིཏི སཏྱཾ ཏཐཱཔི ཡོ ཛནོ ཡད྄ བྷུཀྟྭཱ ཝིགྷྣཾ ལབྷཏེ ཏདརྠཾ ཏད྄ བྷདྲཾ ནཧི། ");
INSERT INTO santib_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ཏཝ མཱཾསབྷཀྵཎསུརཱཔཱནཱདིབྷིཿ ཀྲིཡཱབྷི ཪྻདི ཏཝ བྷྲཱཏུཿ པཱདསྑལནཾ ཝིགྷྣོ ཝཱ ཙཱཉྩལྱཾ ཝཱ ཛཱཡཏེ ཏརྷི ཏདྦྷོཛནཔཱནཡོསྟྱཱགོ བྷདྲཿ། ");
INSERT INTO santib_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ཡདི ཏཝ པྲཏྱཡསྟིཥྛཏི ཏརྷཱིཤྭརསྱ གོཙརེ སྭཱནྟརེ ཏཾ གོཔཡ; ཡོ ཛནཿ སྭམཏེན སྭཾ དོཥིཎཾ ན ཀརོཏི ས ཨེཝ དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ སཾཤཡྻ བྷུངྐྟེ྅རྠཱཏ྄ ན པྲཏཱིཏྱ བྷུངྐྟེ, ས ཨེཝཱཝཤྱཾ དཎྜཱརྷོ བྷཝིཥྱཏི, ཡཏོ ཡཏ྄ པྲཏྱཡཛཾ ནཧི ཏདེཝ པཱཔམཡཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","བལཝདྦྷིརསྨཱབྷི རྡུརྦྦལཱནཱཾ དཽརྦྦལྱཾ སོཌྷཝྱཾ ན ཙ སྭེཥཱམ྄ ཨིཥྚཱཙཱར ཨཱཙརིཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ཨསྨཱཀམ྄ ཨེཀཻཀོ ཛནཿ སྭསམཱིཔཝཱསིནོ ཧིཏཱརྠཾ ནིཥྛཱརྠཉྩ ཏསྱཻཝེཥྚཱཙཱརམ྄ ཨཱཙརཏུ། ");
INSERT INTO santib_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ཡཏཿ ཁྲཱིཥྚོ྅པི ནིཛེཥྚཱཙཱརཾ ནཱཙརིཏཝཱན྄, ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, ཏྭནྣིནྡཀགཎསྱཻཝ ནིནྡཱབྷི རྣིནྡིཏོ྅སྨྱཧཾ། ");
INSERT INTO santib_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ཨཔརཉྩ ཝཡཾ ཡཏ྄ སཧིཥྞུཏཱསཱནྟྭནཡོ རྫནཀེན ཤཱསྟྲེཎ པྲཏྱཱཤཱཾ ལབྷེམཧི ཏནྣིམིཏྟཾ པཱུཪྻྭཀཱལེ ལིཁིཏཱནི སཪྻྭཝཙནཱནྱསྨཱཀམ྄ ཨུཔདེཤཱརྠམེཝ ལིལིཁིརེ། ");
INSERT INTO santib_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","སཧིཥྞུཏཱསཱནྟྭནཡོརཱཀརོ ཡ ཨཱིཤྭརཿ ས ཨེཝཾ ཀརོཏུ ཡཏ྄ པྲབྷུ ཪྻཱིཤུཁྲཱིཥྚ ཨིཝ ཡུཥྨཱཀམ྄ ཨེཀཛནོ྅ནྱཛནེན སཱརྡྡྷཾ མནས ཨཻཀྱམ྄ ཨཱཙརེཏ྄; ");
INSERT INTO santib_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ཡཱུཡཉྩ སཪྻྭ ཨེཀཙིཏྟཱ བྷཱུཏྭཱ མུཁཻཀེནེཝཱསྨཏྤྲབྷུཡཱིཤུཁྲཱིཥྚསྱ པིཏུརཱིཤྭརསྱ གུཎཱན྄ ཀཱིརྟྟཡེཏ། ");
INSERT INTO santib_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ཨཔརམ྄ ཨཱིཤྭརསྱ མཧིམྣཿ པྲཀཱཤཱརྠཾ ཁྲཱིཥྚོ ཡཐཱ ཡུཥྨཱན྄ པྲཏྱགྲྀཧླཱཏ྄ ཏཐཱ ཡུཥྨཱཀམཔྱེཀོ ཛནོ྅ནྱཛནཾ པྲཏིགྲྀཧླཱཏུ། ");
INSERT INTO santib_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, ཨཏོ྅ཧཾ སམྨུཁེ ཏིཥྛན྄ བྷིནྣདེཤནིཝཱསིནཱཾ། སྟུཝཾསྟྭཱཾ པརིགཱསྱཱམི ཏཝ ནཱམྣི པརེཤྭར༎ ");
INSERT INTO santib_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ཏསྱ དཡཱལུཏྭཱཙྩ བྷིནྣཛཱཏཱིཡཱ ཡད྄ ཨཱིཤྭརསྱ གུཎཱན྄ ཀཱིརྟྟཡེཡུསྟདརྠཾ ཡཱིཤུཿ ཁྲཱིཥྚསྟྭཀྪེདནིཡམསྱ ནིགྷྣོ྅བྷཝད྄ ཨིཏྱཧཾ ཝདཱམི། ཡཐཱ ལིཁིཏམ྄ ཨཱསྟེ, ཨཏོ྅ཧཾ སམྨུཁེ ཏིཥྛན྄ བྷིནྣདེཤནིཝཱསིནཱཾ། སྟུཝཾསྟྭཱཾ པརིགཱསྱཱམི ཏཝ ནཱམྣི པརེཤྭར༎ ");
INSERT INTO santib_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ཨཔརམཔི ལིཁིཏམ྄ ཨཱསྟེ, ཧེ ཨནྱཛཱཏཡོ ཡཱུཡཾ སམཾ ནནྡཏ ཏཛྫནཻཿ། ");
INSERT INTO santib_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","པུནཤྩ ལིཁིཏམ྄ ཨཱསྟེ, ཧེ སཪྻྭདེཤིནོ ཡཱུཡཾ དྷནྱཾ བྲཱུཏ པརེཤྭརཾ། ཧེ ཏདཱིཡནརཱ ཡཱུཡཾ ཀུརུདྷྭཾ ཏཏྤྲཤཾསནཾ༎ ");
INSERT INTO santib_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ཨཔར ཡཱིཤཱཡིཡོ྅པི ལིལེཁ, ཡཱིཤཡསྱ ཏུ ཡཏ྄ མཱུལཾ ཏཏ྄ པྲཀཱཤིཥྱཏེ ཏདཱ། སཪྻྭཛཱཏཱིཡནྲྀཎཱཉྩ ཤཱསཀཿ སམུདེཥྱཏི། ཏཏྲཱནྱདེཤིལོཀཻཤྩ པྲཏྱཱཤཱ པྲཀརིཥྱཏེ༎ ");
INSERT INTO santib_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ཨཏཨེཝ ཡཱུཡཾ པཝིཏྲསྱཱཏྨནཿ པྲབྷཱཝཱད྄ ཡཏ྄ སམྤཱུརྞཱཾ པྲཏྱཱཤཱཾ ལཔྶྱདྷྭེ ཏདརྠཾ ཏཏྤྲཏྱཱཤཱཛནཀ ཨཱིཤྭརཿ པྲཏྱཡེན ཡུཥྨཱན྄ ཤཱནྟྱཱནནྡཱབྷྱཱཾ སམྤཱུརྞཱན྄ ཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ཧེ བྷྲཱཏརོ ཡཱུཡཾ སདྦྷཱཝཡུཀྟཱཿ སཪྻྭཔྲཀཱརེཎ ཛྙཱནེན ཙ སམྤཱུརྞཱཿ པརསྤརོཔདེཤེ ཙ ཏཏྤརཱ ཨིཏྱཧཾ ནིཤྩིཏཾ ཛཱནཱམི, ");
INSERT INTO santib_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ཏཐཱཔྱཧཾ ཡཏ྄ པྲགལྦྷཏརོ བྷཝན྄ ཡུཥྨཱན྄ པྲབོདྷཡཱམི ཏསྱཻཀཾ ཀཱརཎམིདཾ། ");
INSERT INTO santib_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","བྷིནྣཛཱཏཱིཡཱཿ པཝིཏྲེཎཱཏྨནཱ པཱཝིཏནཻཝེདྱརཱུཔཱ བྷཱུཏྭཱ ཡད྄ གྲཱཧྱཱ བྷཝེཡུསྟནྣིམིཏྟམཧམ྄ ཨཱིཤྭརསྱ སུསཾཝཱདཾ པྲཙཱརཡིཏུཾ བྷིནྣཛཱཏཱིཡཱནཱཾ མདྷྱེ ཡཱིཤུཁྲཱིཥྚསྱ སེཝཀཏྭཾ དཱནཾ ཨཱིཤྭརཱཏ྄ ལབྡྷཝཱནསྨི། ");
INSERT INTO santib_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ཨཱིཤྭརཾ པྲཏི ཡཱིཤུཁྲཱིཥྚེན མམ ཤླཱགྷཱཀརཎསྱ ཀཱརཎམ྄ ཨཱསྟེ། ");
INSERT INTO santib_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","བྷིནྣདེཤིན ཨཱཛྙཱགྲཱཧིཎཿ ཀརྟྟུཾ ཁྲཱིཥྚོ ཝཱཀྱེན ཀྲིཡཡཱ ཙ, ཨཱཤྩཪྻྱལཀྵཎཻཤྩིཏྲཀྲིཡཱབྷིཿ པཝིཏྲསྱཱཏྨནཿ པྲབྷཱཝེན ཙ ཡཱནི ཀརྨྨཱཎི མཡཱ སཱདྷིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ཀེཝལཾ ཏཱནྱེཝ ཝིནཱནྱསྱ ཀསྱཙིཏ྄ ཀརྨྨཎོ ཝརྞནཱཾ ཀརྟྟུཾ པྲགལྦྷོ ན བྷཝཱམི། ཏསྨཱཏ྄ ཨཱ ཡིརཱུཤཱལམ ཨིལླཱུརིཀཾ ཡཱཝཏ྄ སཪྻྭཏྲ ཁྲཱིཥྚསྱ སུསཾཝཱདཾ པྲཱཙཱརཡཾ། ");
INSERT INTO santib_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ཨནྱེན ནིཙིཏཱཡཱཾ བྷིཏྟཱཝཧཾ ཡནྣ ནིཙིནོམི ཏནྣིམིཏྟཾ ཡཏྲ ཡཏྲ སྠཱནེ ཁྲཱིཥྚསྱ ནཱམ ཀདཱཔི ཀེནཱཔི ན ཛྙཱཔིཏཾ ཏཏྲ ཏཏྲ སུསཾཝཱདཾ པྲཙཱརཡིཏུམ྄ ཨཧཾ ཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ཡཱདྲྀཤཾ ལིཁིཏམ྄ ཨཱསྟེ, ཡཻ ཪྻཱརྟྟཱ ཏསྱ ན པྲཱཔྟཱ དརྴནཾ ཏཻསྟུ ལཔྶྱཏེ། ཡཻཤྩ ནཻཝ ཤྲུཏཾ ཀིཉྩིཏ྄ བོདྡྷུཾ ཤཀྵྱནྟི ཏེ ཛནཱཿ༎ ");
INSERT INTO santib_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ཏསྨཱད྄ ཡུཥྨཏྶམཱིཔགམནཱད྄ ཨཧཾ མུཧུརྨུཧུ རྣིཝཱརིཏོ྅བྷཝཾ། ");
INSERT INTO santib_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ཀིནྟྭིདཱནཱིམ྄ ཨཏྲ པྲདེཤེཥུ མཡཱ ན གཏཾ སྠཱནཾ ཀིམཔི ནཱཝཤིཥྱཏེ ཡུཥྨཏྶམཱིཔཾ གནྟུཾ བཧུཝཏྶརཱནཱརབྷྱ མཱམཀཱིནཱཀཱངྐྵཱ ཙ ཝིདྱཏ ཨིཏི ཧེཏོཿ ");
INSERT INTO santib_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","སྤཱནིཡཱདེཤགམནཀཱལེ྅ཧཾ ཡུཥྨནྨདྷྱེན གཙྪན྄ ཡུཥྨཱན྄ ཨཱལོཀིཥྱེ, ཏཏཿ པརཾ ཡུཥྨཏྶམྦྷཱཥཎེན ཏྲྀཔྟིཾ པརིལབྷྱ ཏདྡེཤགམནཱརྠཾ ཡུཥྨཱབྷི ཪྻིསརྫཡིཥྱེ, ཨཱིདྲྀཤཱི མདཱིཡཱ པྲཏྱཱཤཱ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ཀིནྟུ སཱམྤྲཏཾ པཝིཏྲལོཀཱནཱཾ སེཝནཱཡ ཡིརཱུཤཱལམྣགརཾ ཝྲཛཱམི། ");
INSERT INTO santib_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ཡཏོ ཡིརཱུཤཱལམསྠཔཝིཏྲལོཀཱནཱཾ མདྷྱེ ཡེ དརིདྲཱ ཨརྠཝིཤྲཱཎནེན ཏཱནུཔཀརྟྟུཾ མཱཀིདནིཡཱདེཤཱིཡཱ ཨཱཁཱཡཱདེཤཱིཡཱཤྩ ལོཀཱ ཨཻཙྪན྄། ");
INSERT INTO santib_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ཨེཥཱ ཏེཥཱཾ སདིཙྪཱ ཡཏསྟེ ཏེཥཱམ྄ ཨྲྀཎིནཿ སནྟི ཡཏོ ཧེཏོ རྦྷིནྣཛཱཏཱིཡཱ ཡེཥཱཾ པརམཱརྠསྱཱཾཤིནོ ཛཱཏཱ ཨཻཧིཀཝིཥཡེ ཏེཥཱམུཔཀཱརསྟཻཿ ཀརྟྟཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ཨཏོ མཡཱ ཏཏ྄ ཀརྨྨ སཱདྷཡིཏྭཱ ཏསྨིན྄ ཕལེ ཏེབྷྱཿ སམརྤིཏེ ཡུཥྨནྨདྷྱེན སྤཱནིཡཱདེཤོ གམིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ཡུཥྨཏྶམཱིཔེ མམཱགམནསམཡེ ཁྲཱིཥྚསྱ སུསཾཝཱདསྱ པཱུརྞཝརེཎ སམྦལིཏཿ སན྄ ཨཧམ྄ ཨཱགམིཥྱཱམི ཨིཏི མཡཱ ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ཧེ བྷྲཱཏྲྀགཎ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ པཝིཏྲསྱཱཏྨཱནཿ པྲེམྣཱ ཙ ཝིནཡེ྅ཧཾ ");
INSERT INTO santib_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ཡིཧཱུདཱདེཤསྠཱནཱམ྄ ཨཝིཤྭཱསིལོཀཱནཱཾ ཀརེབྷྱོ ཡདཧཾ རཀྵཱཾ ལབྷེཡ མདཱིཡཻཏེན སེཝནཀརྨྨཎཱ ཙ ཡད྄ ཡིརཱུཤཱལམསྠཱཿ པཝིཏྲལོཀཱསྟུཥྱེཡུཿ, ");
INSERT INTO santib_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ཏདརྠཾ ཡཱུཡཾ མཏྐྲྀཏ ཨཱིཤྭརཱཡ པྲཱརྠཡམཱཎཱ ཡཏདྷྭཾ ཏེནཱཧམ྄ ཨཱིཤྭརེཙྪཡཱ སཱནནྡཾ ཡུཥྨཏྶམཱིཔཾ གཏྭཱ ཡུཥྨཱབྷིཿ སཧིཏཿ པྲཱཎཱན྄ ཨཱཔྱཱཡིཏུཾ པཱརཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ཤཱནྟིདཱཡཀ ཨཱིཤྭརོ ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ སངྒཱི བྷཱུཡཱཏ྄། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ཀིཾཀྲཱིཡཱནགརཱིཡདྷརྨྨསམཱཛསྱ པརིཙཱརིཀཱ ཡཱ ཕཻབཱིནཱམིཀཱསྨཱཀཾ དྷརྨྨབྷགིནཱི ཏསྱཱཿ ཀྲྀཏེ྅ཧཾ ཡུཥྨཱན྄ ནིཝེདཡཱམི, ");
INSERT INTO santib_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ཡཱུཡཾ ཏཱཾ པྲབྷུམཱཤྲིཏཱཾ ཝིཛྙཱཡ ཏསྱཱ ཨཱཏིཐྱཾ པཝིཏྲལོཀཱརྷཾ ཀུརུདྷྭཾ, ཡུཥྨཏྟསྟསྱཱ ཡ ཨུཔཀཱརོ བྷཝིཏུཾ ཤཀྣོཏི ཏཾ ཀུརུདྷྭཾ, ཡསྨཱཏ྄ ཏཡཱ བཧཱུནཱཾ མམ ཙོཔཀཱརཿ ཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ཨཔརཉྩ ཁྲཱིཥྚསྱ ཡཱིཤོཿ ཀརྨྨཎི མམ སཧཀཱརིཎཽ མམ པྲཱཎརཀྵཱརྠཉྩ སྭཔྲཱཎཱན྄ པཎཱིཀྲྀཏཝནྟཽ ཡཽ པྲིཥྐིལླཱཀྐིལཽ ཏཽ མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ཏཱབྷྱཱམ྄ ཨུཔཀཱརཱཔྟིཿ ཀེཝལཾ མཡཱ སྭཱིཀརྟྟཝྱེཏི ནཧི བྷིནྣདེཤཱིཡཻཿ སཪྻྭདྷརྨྨསམཱཛཻརཔི། ");
INSERT INTO santib_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ཨཔརཉྩ ཏཡོ རྒྲྀཧེ སྠིཏཱན྄ དྷརྨྨསམཱཛལོཀཱན྄ མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ཏདྭཏ྄ ཨཱཤིཡཱདེཤེ ཁྲཱིཥྚསྱ པཀྵེ པྲཐམཛཱཏཕལསྭརཱུཔོ ཡ ཨིཔེནིཏནཱམཱ མམ པྲིཡབནྡྷུསྟམཔི མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ཨཔརཾ བཧུཤྲམེཎཱསྨཱན྄ ཨསེཝཏ ཡཱ མརིཡམ྄ ཏཱམཔི ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ཨཔརཉྩ པྲེརིཏེཥུ ཁྱཱཏཀཱིརྟྟཱི མདགྲེ ཁྲཱིཥྚཱཤྲིཏཽ མམ སྭཛཱཏཱིཡཽ སཧབནྡིནཽ ཙ ཡཱཝཱནྡྲནཱིཀཡཱུནིཡཽ ཏཽ མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ཏཐཱ པྲབྷཽ མཏྤྲིཡཏམམ྄ ཨཱམྤླིཡམཔི མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ཨཔརཾ ཁྲཱིཥྚསེཝཱཡཱཾ མམ སཧཀཱརིཎམ྄ ཨཱུརྦྦཱཎཾ མམ པྲིཡཏམཾ སྟཱཁུཉྩ མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ཨཔརཾ ཁྲཱིཥྚེན པརཱིཀྵིཏམ྄ ཨཱཔིལླིཾ མམ ནམསྐཱརཾ ཝདཏ, ཨཱརིཥྚབཱུལསྱ པརིཛནཱཾཤྩ མམ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ཨཔརཾ མམ ཛྙཱཏིཾ ཧེརོདིཡོནཾ མམ ནམསྐཱརཾ ཝདཏ, ཏཐཱ ནཱརྐིསསྱ པརིཝཱརཱཎཱཾ མདྷྱེ ཡེ པྲབྷུམཱཤྲིཏཱསྟཱན྄ མམ ནམསྐཱརཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ཨཔརཾ པྲབྷོཿ སེཝཱཡཱཾ པརིཤྲམཀཱརིཎྱཽ ཏྲུཕེནཱཏྲུཕོཥེ མམ ནམསྐཱརཾ ཝདཏ, ཏཐཱ པྲབྷོཿ སེཝཱཡཱམ྄ ཨཏྱནྟཾ པརིཤྲམཀཱརིཎཱི ཡཱ པྲིཡཱ པརྵིསྟཱཾ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ཨཔརཾ པྲབྷོརབྷིརུཙིཏཾ རཱུཕཾ མམ དྷརྨྨམཱཏཱ ཡཱ ཏསྱ མཱཏཱ ཏཱམཔི ནམསྐཱརཾ ཝདཏ། ");
INSERT INTO santib_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ཨཔརམ྄ ཨསུཾཀྲྀཏཾ ཕླིགོནཾ ཧརྨྨཾ པཱཏྲབཾ ཧརྨྨིམ྄ ཨེཏེཥཱཾ སངྒིབྷྲཱཏྲྀགཎཉྩ ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ཨཔརཾ ཕིལལགོ ཡཱུལིཡཱ ནཱིརིཡསྟསྱ བྷགིནྱལུམྤཱ ཙཻཏཱན྄ ཨེཏཻཿ སཱརྡྡྷཾ ཡཱཝནྟཿ པཝིཏྲལོཀཱ ཨཱསཏེ ཏཱནཔི ནམསྐཱརཾ ཛྙཱཔཡདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ཡཱུཡཾ པརསྤརཾ པཝིཏྲཙུམྦནེན ནམསྐུརུདྷྭཾ། ཁྲཱིཥྚསྱ དྷརྨྨསམཱཛགཎོ ཡུཥྨཱན྄ ནམསྐུརུཏེ། ");
INSERT INTO santib_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ཧེ བྷྲཱཏརོ ཡུཥྨཱན྄ ཝིནཡེ྅ཧཾ ཡུཥྨཱབྷི ཪྻཱ ཤིཀྵཱ ལབྡྷཱ ཏཱམ྄ ཨཏིཀྲམྱ ཡེ ཝིཙྪེདཱན྄ ཝིགྷྣཱཾཤྩ ཀུཪྻྭནྟི ཏཱན྄ ནིཤྩིནུཏ ཏེཥཱཾ སངྒཾ ཝརྫཡཏ ཙ། ");
INSERT INTO santib_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ཡཏསྟཱདྲྀཤཱ ལོཀཱ ཨསྨཱཀཾ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ དཱསཱ ཨིཏི ནཧི ཀིནྟུ སྭོདརསྱཻཝ དཱསཱཿ; ཨཔརཾ པྲཎཡཝཙནཻ རྨདྷུརཝཱཀྱཻཤྩ སརལལོཀཱནཱཾ མནཱཾསི མོཧཡནྟི། ");
INSERT INTO santib_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ཡུཥྨཱཀམ྄ ཨཱཛྙཱགྲཱཧིཏྭཾ སཪྻྭཏྲ སཪྻྭཻ རྫྙཱཏཾ ཏཏོ྅ཧཾ ཡུཥྨཱསུ སཱནནྡོ྅བྷཝཾ ཏཐཱཔི ཡཱུཡཾ ཡཏ྄ སཏྫྙཱནེན ཛྙཱནིནཿ ཀུཛྙཱནེे ཙཱཏཏྤརཱ བྷཝེཏེཏི མམཱབྷིལཱཥཿ། ");
INSERT INTO santib_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ཨདྷིཀནྟུ ཤཱནྟིདཱཡཀ ཨཱིཤྭརཿ ཤཻཏཱནམ྄ ཨཝིལམྦཾ ཡུཥྨཱཀཾ པདཱནཱམ྄ ཨདྷོ མརྡྡིཥྱཏི། ཨསྨཱཀཾ པྲབྷུ ཪྻཱིཤུཁྲཱིཥྚོ ཡུཥྨཱསུ པྲསཱདཾ ཀྲིཡཱཏ྄། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","མམ སཧཀཱརཱི ཏཱིམཐིཡོ མམ ཛྙཱཏཡོ ལཱུཀིཡོ ཡཱསོན྄ སོསིཔཱཏྲཤྩེམེ ཡུཥྨཱན྄ ནམསྐུཪྻྭནྟེ། ");
INSERT INTO santib_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ཨཔརམ྄ ཨེཏཏྤཏྲལེཁཀསྟརྟྟིཡནཱམཱཧམཔི པྲབྷོ རྣཱམྣཱ ཡུཥྨཱན྄ ནམསྐརོམི། ");
INSERT INTO santib_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ཏཐཱ ཀྲྀཏྶྣདྷརྨྨསམཱཛསྱ མམ ཙཱཏིཐྱཀཱརཱི གཱཡོ ཡུཥྨཱན྄ ནམསྐརོཏི། ཨཔརམ྄ ཨེཏནྣགརསྱ དྷནརཀྵཀ ཨིརཱསྟཿ ཀྐཱརྟྟནཱམཀཤྩཻཀོ བྷྲཱཏཱ ཏཱཝཔི ཡུཥྨཱན྄ ནམསྐུརུཏཿ། ");
INSERT INTO santib_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ཨསྨཱཀཾ པྲབྷུ ཪྻཱིཤུཁྲཱིཥྚཱ ཡུཥྨཱསུ སཪྻྭེཥུ པྲསཱདཾ ཀྲིཡཱཏ྄། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","པཱུཪྻྭཀཱལིཀཡུགེཥུ པྲཙྪནྣཱ ཡཱ མནྟྲཎཱདྷུནཱ པྲཀཱཤིཏཱ བྷཱུཏྭཱ བྷཝིཥྱདྭཱདིལིཁིཏགྲནྠགཎསྱ པྲམཱཎཱད྄ ཝིཤྭཱསེན གྲཧཎཱརྠཾ སདཱཏནསྱེཤྭརསྱཱཛྙཡཱ སཪྻྭདེཤཱིཡལོཀཱན྄ ཛྙཱཔྱཏེ, ");
INSERT INTO santib_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ཏསྱཱ མནྟྲཎཱཡཱ ཛྙཱནཾ ལབྡྷྭཱ མཡཱ ཡཿ སུསཾཝཱདོ ཡཱིཤུཁྲཱིཥྚམདྷི པྲཙཱཪྻྱཏེ, ཏདནུསཱརཱད྄ ཡུཥྨཱན྄ དྷརྨྨེ སུསྠིརཱན྄ ཀརྟྟུཾ སམརྠོ ཡོ྅དྭིཏཱིཡཿ ");
INSERT INTO santib_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","སཪྻྭཛྙ ཨཱིཤྭརསྟསྱ དྷནྱཝཱདོ ཡཱིཤུཁྲཱིཥྚེན སནྟཏཾ བྷཱུཡཱཏ྄། ཨིཏི། ");
INSERT INTO santib_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ཡཱཝནྟཿ པཝིཏྲཱ ལོཀཱཿ སྭེཥཱམ྄ ཨསྨཱཀཉྩ ཝསཏིསྠཱནེཥྭསྨཱཀཾ པྲབྷོ ཪྻཱིཤོཿ ཁྲཱིཥྚསྱ ནཱམྣཱ པྲཱརྠཡནྟེ ཏཻཿ སཧཱཧཱུཏཱནཱཾ ཁྲཱིཥྚེན ཡཱིཤུནཱ པཝིཏྲཱིཀྲྀཏཱནཱཾ ལོཀཱནཱཾ ཡ ཨཱིཤྭརཱིཡདྷརྨྨསམཱཛཿ ཀརིནྠནགརེ ཝིདྱཏེ ");
INSERT INTO santib_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ཏཾ པྲཏཱིཤྭརསྱེཙྪཡཱཧཱུཏོ ཡཱིཤུཁྲཱིཥྚསྱ པྲེརིཏཿ པཽལཿ སོསྠིནིནཱམཱ བྷྲཱཏཱ ཙ པཏྲཾ ལིཁཏི། ");
INSERT INTO santib_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ཨསྨཱཀཾ པིཏྲེཤྭརེཎ པྲབྷུནཱ ཡཱིཤུཁྲཱིཥྚེན ཙ པྲསཱདཿ ཤཱནྟིཤྩ ཡུཥྨབྷྱཾ དཱིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ཨཱིཤྭརོ ཡཱིཤུཁྲཱིཥྚེན ཡུཥྨཱན྄ པྲཏི པྲསཱདཾ པྲཀཱཤིཏཝཱན྄, ཏསྨཱདཧཾ ཡུཥྨནྣིམིཏྟཾ སཪྻྭདཱ མདཱིཡེཤྭརཾ དྷནྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ཁྲཱིཥྚསམྦནྡྷཱིཡཾ སཱཀྵྱཾ ཡུཥྨཱཀཾ མདྷྱེ ཡེན པྲཀཱརེཎ སཔྲམཱཎམ྄ ཨབྷཝཏ྄ ");
INSERT INTO santib_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ཏེན ཡཱུཡཾ ཁྲཱིཥྚཱཏ྄ སཪྻྭཝིདྷཝཀྟྲྀཏཱཛྙཱནཱདཱིནི སཪྻྭདྷནཱནི ལབྡྷཝནྟཿ། ");
INSERT INTO santib_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ཏཏོ྅སྨཏྤྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ པུནརཱགམནཾ པྲཏཱིཀྵམཱཎཱནཱཾ ཡུཥྨཱཀཾ ཀསྱཱཔི ཝརསྱཱབྷཱཝོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ཨཔརམ྄ ཨསྨཱཀཾ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ དིཝསེ ཡཱུཡཾ ཡནྣིརྡྡོཥཱ བྷཝེཏ ཏདརྠཾ སཨེཝ ཡཱཝདནྟཾ ཡུཥྨཱན྄ སུསྠིརཱན྄ ཀརིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ཡ ཨཱིཤྭརཿ སྭཔུཏྲསྱཱསྨཏྤྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱཱཾཤིནཿ ཀརྟྟུཾ ཡུཥྨཱན྄ ཨཱཧཱུཏཝཱན྄ ས ཝིཤྭསནཱིཡཿ། ");
INSERT INTO santib_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ཧེ བྷྲཱཏརཿ, ཨསྨཱཀཾ པྲབྷུཡཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ ཡུཥྨཱན྄ ཝིནཡེ྅ཧཾ སཪྻྭཻ ཪྻུཥྨཱབྷིརེཀརཱུཔཱཎི ཝཱཀྱཱནི ཀཐྱནྟཱཾ ཡུཥྨནྨདྷྱེ བྷིནྣསངྒྷཱཏཱ ན བྷཝནྟུ མནོཝིཙཱརཡོརཻཀྱེན ཡུཥྨཱཀཾ སིདྡྷཏྭཾ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ཧེ མམ བྷྲཱཏརོ ཡུཥྨནྨདྷྱེ ཝིཝཱདཱ ཛཱཏཱ ཨིཏི ཝཱརྟྟཱམཧཾ ཀློཡྻཱཿ པརིཛནཻ རྫྙཱཔིཏཿ། ");
INSERT INTO santib_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","མམཱབྷིཔྲེཏམིདཾ ཡུཥྨཱཀཾ ཀཤྩིཏ྄ ཀཤྩིད྄ ཝདཏི པཽལསྱ ཤིཥྱོ྅ཧམ྄ ཨཱཔལློཿ ཤིཥྱོ྅ཧཾ ཀཻཕཱཿ ཤིཥྱོ྅ཧཾ ཁྲཱིཥྚསྱ ཤིཥྱོ྅ཧམིཏི ཙ། ");
INSERT INTO santib_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ཁྲཱིཥྚསྱ ཀིཾ ཝིབྷེདཿ ཀྲྀཏཿ? པཽལཿ ཀིཾ ཡུཥྨཏྐྲྀཏེ ཀྲུཤེ ཧཏཿ? པཽལསྱ ནཱམྣཱ ཝཱ ཡཱུཡཾ ཀིཾ མཛྫིཏཱཿ? ");
INSERT INTO santib_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ཀྲིཥྤགཱཡཽ ཝིནཱ ཡུཥྨཱཀཾ མདྷྱེ྅ནྱཿ ཀོ྅པི མཡཱ ན མཛྫིཏ ཨིཏི ཧེཏོརཧམ྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ཨེཏེན མམ ནཱམྣཱ མཱནཝཱ མཡཱ མཛྫིཏཱ ཨིཏི ཝཀྟུཾ ཀེནཱཔི ན ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ཨཔརཾ སྟིཕཱནསྱ པརིཛནཱ མཡཱ མཛྫིཏཱསྟདནྱཿ ཀཤྩིད྄ ཡནྨཡཱ མཛྫིཏསྟདཧཾ ན ཝེདྨི། ");
INSERT INTO santib_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ཁྲཱིཥྚེནཱཧཾ མཛྫནཱརྠཾ ན པྲེརིཏཿ ཀིནྟུ སུསཾཝཱདསྱ པྲཙཱརཱརྠམེཝ; སོ྅པི ཝཱཀྤཊུཏཡཱ མཡཱ ན པྲཙཱརིཏཝྱཿ, ཡཏསྟཐཱ པྲཙཱརིཏེ ཁྲཱིཥྚསྱ ཀྲུཤེ མྲྀཏྱུཿ ཕལཧཱིནོ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ཡཏོ ཧེཏོ ཪྻེ ཝིནཤྱནྟི ཏེ ཏཱཾ ཀྲུཤསྱ ཝཱརྟྟཱཾ པྲལཱཔམིཝ མནྱནྟེ ཀིཉྩ པརིཏྲཱཎཾ ལབྷམཱནེཥྭསྨཱསུ སཱ ཨཱིཤྭརཱིཡཤཀྟིསྭརཱུཔཱ། ");
INSERT INTO santib_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ཏསྨཱདིཏྠཾ ལིཁིཏམཱསྟེ, ཛྙཱནཝཏཱནྟུ ཡཏ྄ ཛྙཱནཾ ཏནྨཡཱ ནཱཤཡིཥྱཏེ། ཝིལོཔཡིཥྱཏེ ཏདྭད྄ བུདྡྷི རྦདྡྷིམཏཱཾ མཡཱ༎ ");
INSERT INTO santib_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ཛྙཱནཱི ཀུཏྲ? ཤཱསྟྲཱི ཝཱ ཀུཏྲ? ཨིཧལོཀསྱ ཝིཙཱརཏཏྤརོ ཝཱ ཀུཏྲ? ཨིཧལོཀསྱ ཛྙཱནཾ ཀིམཱིཤྭརེཎ མོཧཱིཀྲྀཏཾ ནཧི? ");
INSERT INTO santib_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ཨཱིཤྭརསྱ ཛྙཱནཱད྄ ཨིཧལོཀསྱ མཱནཝཱཿ སྭཛྙཱནེནེཤྭརསྱ ཏཏྟྭབོདྷཾ ན པྲཱཔྟཝནྟསྟསྨཱད྄ ཨཱིཤྭརཿ པྲཙཱརརཱུཔིཎཱ པྲལཱཔེན ཝིཤྭཱསིནཿ པརིཏྲཱཏུཾ རོཙིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ཡིཧཱུདཱིཡལོཀཱ ལཀྵཎཱནི དིདྲྀཀྵནྟི བྷིནྣདེཤཱིཡལོཀཱསྟུ ཝིདྱཱཾ མྲྀགཡནྟེ, ");
INSERT INTO santib_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ཝཡཉྩ ཀྲུཤེ ཧཏཾ ཁྲཱིཥྚཾ པྲཙཱརཡཱམཿ། ཏསྱ པྲཙཱརོ ཡིཧཱུདཱིཡཻ ཪྻིགྷྣ ཨིཝ བྷིནྣདེཤཱིཡཻཤྩ པྲལཱཔ ཨིཝ མནྱཏེ, ");
INSERT INTO santib_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ཀིནྟུ ཡིཧཱུདཱིཡཱནཱཾ བྷིནྣདེཤཱིཡཱནཱཉྩ མདྷྱེ ཡེ ཨཱཧཱུཏཱསྟེཥུ ས ཁྲཱིཥྚ ཨཱིཤྭརཱིཡཤཀྟིརིཝེཤྭརཱིཡཛྙཱནམིཝ ཙ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ཡཏ ཨཱིཤྭརེ ཡཿ པྲལཱཔ ཨཱརོཔྱཏེ ས མཱནཝཱཏིརིཀྟཾ ཛྙཱནམེཝ ཡཙྩ དཽརྦྦལྱམ྄ ཨཱིཤྭར ཨཱརོཔྱཏེ ཏཏ྄ མཱནཝཱཏིརིཀྟཾ བལམེཝ། ");
INSERT INTO santib_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ཧེ བྷྲཱཏརཿ, ཨཱཧཱུཏཡུཥྨདྒཎོ ཡཥྨཱབྷིརཱལོཀྱཏཱཾ ཏནྨདྷྱེ སཱཾསཱརིཀཛྙཱནེན ཛྙཱནཝནྟཿ པརཱཀྲམིཎོ ཝཱ ཀུལཱིནཱ ཝཱ བཧཝོ ན ཝིདྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ཡཏ ཨཱིཤྭརོ ཛྙཱནཝཏསྟྲཔཡིཏུཾ མཱུརྑལོཀཱན྄ རོཙིཏཝཱན྄ བལཱནི ཙ ཏྲཔཡིཏུམ྄ ཨཱིཤྭརོ དུརྦྦལཱན྄ རོཙིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ཏཐཱ ཝརྟྟམཱནལོཀཱན྄ སཾསྠིཏིབྷྲཥྚཱན྄ ཀརྟྟུམ྄ ཨཱིཤྭརོ ཛགཏོ྅པཀྲྀཥྚཱན྄ ཧེཡཱན྄ ཨཝརྟྟམཱནཱཾཤྩཱབྷིརོཙིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ཏཏ ཨཱིཤྭརསྱ སཱཀྵཱཏ྄ ཀེནཱཔྱཱཏྨཤླཱགྷཱ ན ཀརྟྟཝྱཱ། ");
INSERT INTO santib_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ཡཱུཡཉྩ ཏསྨཱཏ྄ ཁྲཱིཥྚེ ཡཱིཤཽ སཾསྠིཏིཾ པྲཱཔྟཝནྟཿ ས ཨཱིཤྭརཱད྄ ཡུཥྨཱཀཾ ཛྙཱནཾ པུཎྱཾ པཝིཏྲཏྭཾ མུཀྟིཤྩ ཛཱཏཱ། ");
INSERT INTO santib_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ཨཏཨེཝ ཡདྭད྄ ལིཁིཏམཱསྟེ ཏདྭཏ྄, ཡཿ ཀཤྩིཏ྄ ཤླཱགྷམཱནཿ སྱཱཏ྄ ཤླཱགྷཏཱཾ པྲབྷུནཱ ས ཧི། ");
INSERT INTO santib_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ཧེ བྷྲཱཏརོ ཡུཥྨཏྶམཱིཔེ མམཱགམནཀཱལེ྅ཧཾ ཝཀྟྲྀཏཱཡཱ ཝིདྱཱཡཱ ཝཱ ནཻཔུཎྱེནེཤྭརསྱ སཱཀྵྱཾ པྲཙཱརིཏཝཱན྄ ཏནྣཧི; ");
INSERT INTO santib_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ཡཏོ ཡཱིཤུཁྲཱིཥྚཾ ཏསྱ ཀྲུཤེ ཧཏཏྭཉྩ ཝིནཱ ནཱནྱཏ྄ ཀིམཔི ཡུཥྨནྨདྷྱེ ཛྙཱཔཡིཏུཾ ཝིཧིཏཾ བུདྡྷཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ཨཔརཉྩཱཏཱིཝ དཽརྦྦལྱབྷཱིཏིཀམྤཡུཀྟོ ཡུཥྨཱབྷིཿ སཱརྡྡྷམཱསཾ། ");
INSERT INTO santib_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ཨཔརཾ ཡུཥྨཱཀཾ ཝིཤྭཱསོ ཡཏ྄ མཱནུཥིཀཛྙཱནསྱ ཕལཾ ན བྷཝེཏ྄ ཀིནྟྭཱིཤྭརཱིཡཤཀྟེཿ ཕལཾ བྷཝེཏ྄, ");
INSERT INTO santib_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ཏདརྠཾ མམ ཝཀྟྲྀཏཱ མདཱིཡཔྲཙཱརཤྩ མཱནུཥིཀཛྙཱནསྱ མདྷུརཝཱཀྱསམྦལིཏཽ ནཱསྟཱཾ ཀིནྟྭཱཏྨནཿ ཤཀྟེཤྩ པྲམཱཎཡུཀྟཱཝཱསྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ཝཡཾ ཛྙཱནཾ བྷཱཥཱམཧེ ཏཙྩ སིདྡྷལོཀཻ རྫྙཱནམིཝ མནྱཏེ, ཏདིཧལོཀསྱ ཛྙཱནཾ ནཧི, ཨིཧལོཀསྱ ནཤྭརཱཎཱམ྄ ཨདྷིཔཏཱིནཱཾ ཝཱ ཛྙཱནཾ ནཧི; ");
INSERT INTO santib_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ཀིནྟུ ཀཱལཱཝསྠཱཡཱཿ པཱུཪྻྭསྨཱད྄ ཡཏ྄ ཛྙཱནམ྄ ཨསྨཱཀཾ ཝིབྷཝཱརྠམ྄ ཨཱིཤྭརེཎ ནིཤྩིཏྱ པྲཙྪནྣཾ ཏནྣིགཱུཌྷམ྄ ཨཱིཤྭརཱིཡཛྙཱནཾ པྲབྷཱཥཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ཨིཧལོཀསྱཱདྷིཔཏཱིནཱཾ ཀེནཱཔི ཏཏ྄ ཛྙཱནཾ ན ལབྡྷཾ, ལབྡྷེ སཏི ཏེ པྲབྷཱཝཝིཤིཥྚཾ པྲབྷུཾ ཀྲུཤེ ནཱཧནིཥྱན྄། ");
INSERT INTO santib_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ཏདྭལླིཁིཏམཱསྟེ, ནེཏྲེཎ ཀྐཱཔི ནོ དྲྀཥྚཾ ཀརྞེནཱཔི ཙ ན ཤྲུཏཾ། མནོམདྷྱེ ཏུ ཀསྱཱཔི ན པྲཝིཥྚཾ ཀདཱཔི ཡཏ྄། ཨཱིཤྭརེ པྲཱིཡམཱཎཱནཱཾ ཀྲྀཏེ ཏཏ྄ ཏེན སཉྩིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ཨཔརམཱིཤྭརཿ སྭཱཏྨནཱ ཏདསྨཱཀཾ སཱཀྵཱཏ྄ པྲཱཀཱཤཡཏ྄; ཡཏ ཨཱཏྨཱ སཪྻྭམེཝཱནུསནྡྷཏྟེ ཏེན ཙེཤྭརསྱ མརྨྨཏཏྟྭམཔི བུདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","མནུཛསྱཱནྟཿསྠམཱཏྨཱནཾ ཝིནཱ ཀེན མནུཛེན ཏསྱ མནུཛསྱ ཏཏྟྭཾ བུདྷྱཏེ? ཏདྭདཱིཤྭརསྱཱཏྨཱནཾ ཝིནཱ ཀེནཱཔཱིཤྭརསྱ ཏཏྟྭཾ ན བུདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ཝཡཉྩེཧལོཀསྱཱཏྨཱནཾ ལབྡྷཝནྟསྟནྣཧི ཀིནྟྭཱིཤྭརསྱཻཝཱཏྨཱནཾ ལབྡྷཝནྟཿ, ཏཏོ ཧེཏོརཱིཤྭརེཎ སྭཔྲསཱདཱད྄ ཨསྨབྷྱཾ ཡད྄ ཡད྄ དཏྟཾ ཏཏྶཪྻྭམ྄ ཨསྨཱབྷི རྫྙཱཏུཾ ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ཏཙྩཱསྨཱབྷི རྨཱནུཥིཀཛྙཱནསྱ ཝཱཀྱཱནི ཤིཀྵིཏྭཱ ཀཐྱཏ ཨིཏི ནཧི ཀིནྟྭཱཏྨཏོ ཝཱཀྱཱནི ཤིཀྵིཏྭཱཏྨིཀཻ ཪྻཱཀྱཻརཱཏྨིཀཾ བྷཱཝཾ པྲཀཱཤཡདྦྷིཿ ཀཐྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","པྲཱཎཱི མནུཥྱ ཨཱིཤྭརཱིཡཱཏྨནཿ ཤིཀྵཱཾ ན གྲྀཧླཱཏི ཡཏ ཨཱཏྨིཀཝིཙཱརེཎ སཱ ཝིཙཱཪྻྱེཏི ཧེཏོཿ ས ཏཱཾ པྲལཱཔམིཝ མནྱཏེ བོདྡྷུཉྩ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ཨཱཏྨིཀོ མཱནཝཿ སཪྻྭཱཎི ཝིཙཱརཡཏི ཀིནྟུ སྭཡཾ ཀེནཱཔི ན ཝིཙཱཪྻྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ཡཏ ཨཱིཤྭརསྱ མནོ ཛྙཱཏྭཱ ཏམུཔདེཥྚུཾ ཀཿ ཤཀྣོཏི? ཀིནྟུ ཁྲཱིཥྚསྱ མནོ྅སྨཱབྷི རླབྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ཧེ བྷྲཱཏརཿ, ཨཧམཱཏྨིཀཻརིཝ ཡུཥྨཱབྷིཿ སམཾ སམྦྷཱཥིཏུཾ ནཱཤཀྣཝཾ ཀིནྟུ ཤཱརཱིརིཀཱཙཱརིབྷིཿ ཁྲཱིཥྚདྷརྨྨེ ཤིཤུཏུལྱཻཤྩ ཛནཻརིཝ ཡུཥྨཱབྷིཿ སཧ སམབྷཱཥེ། ");
INSERT INTO santib_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ཡུཥྨཱན྄ ཀཋིནབྷཀྵྱཾ ན བྷོཛཡན྄ དུགྡྷམ྄ ཨཔཱཡཡཾ ཡཏོ ཡཱུཡཾ བྷཀྵྱཾ གྲཧཱིཏུཾ ཏདཱ ནཱཤཀྣུཏ ཨིདཱནཱིམཔི ན ཤཀྣུཐ, ཡཏོ ཧེཏོརདྷུནཱཔི ཤཱརཱིརིཀཱཙཱརིཎ ཨཱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ཡུཥྨནྨདྷྱེ མཱཏྶཪྻྱཝིཝཱདབྷེདཱ བྷཝནྟི ཏཏཿ ཀིཾ ཤཱརཱིརིཀཱཙཱརིཎོ ནཱདྷྭེ མཱནུཥིཀམཱརྒེཎ ཙ ན ཙརཐ? ");
INSERT INTO santib_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","པཽལསྱཱཧམིཏྱཱཔལློརཧམིཏི ཝཱ ཡདྭཱཀྱཾ ཡུཥྨཱཀཾ ཀཻཤྩིཏ྄ ཀཻཤྩིཏ྄ ཀཐྱཏེ ཏསྨཱད྄ ཡཱུཡཾ ཤཱརཱིརིཀཱཙཱརིཎ ན བྷཝཐ? ");
INSERT INTO santib_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","པཽལཿ ཀཿ? ཨཱཔལློ ཪྻཱ ཀཿ? ཏཽ པརིཙཱརཀམཱཏྲཽ ཏཡོརེཀཻཀསྨཻ ཙ པྲབྷུ ཪྻཱདྲྀཀ྄ ཕལམདདཱཏ྄ ཏདྭཏ྄ ཏཡོརྡྭཱརཱ ཡཱུཡཾ ཝིཤྭཱསིནོ ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ཨཧཾ རོཔིཏཝཱན྄ ཨཱཔལློཤྩ ནིཥིཀྟཝཱན྄ ཨཱིཤྭརཤྩཱཝརྡྡྷཡཏ྄། ");
INSERT INTO santib_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ཨཏོ རོཔཡིཏྲྀསེཀྟཱརཱཝསཱརཽ ཝརྡྡྷཡིཏེཤྭར ཨེཝ སཱརཿ། ");
INSERT INTO santib_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","རོཔཡིཏྲྀསེཀྟཱརཽ ཙ སམཽ ཏཡོརེཀཻཀཤྩ སྭཤྲམཡོགྱཾ སྭཝེཏནཾ ལཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ཨཱཝཱམཱིཤྭརེཎ སཧ ཀརྨྨཀཱརིཎཽ, ཨཱིཤྭརསྱ ཡཏ྄ ཀྵེཏྲམ྄ ཨཱིཤྭརསྱ ཡཱ ནིརྨྨིཏིཿ སཱ ཡཱུཡམེཝ། ");
INSERT INTO santib_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ཨཱིཤྭརསྱ པྲསཱདཱཏ྄ མཡཱ ཡཏ྄ པདཾ ལབྡྷཾ ཏསྨཱཏ྄ ཛྙཱནིནཱ གྲྀཧཀཱརིཎེཝ མཡཱ བྷིཏྟིམཱུལཾ སྠཱཔིཏཾ ཏདུཔརི ཙཱནྱེན ནིཙཱིཡཏེ། ཀིནྟུ ཡེན ཡནྣིཙཱིཡཏེ ཏཏ྄ ཏེན ཝིཝིཙྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ཡཏོ ཡཱིཤུཁྲཱིཥྚརཱུཔཾ ཡད྄ བྷིཏྟིམཱུལཾ སྠཱཔིཏཾ ཏདནྱཏ྄ ཀིམཔི བྷིཏྟིམཱུལཾ སྠཱཔཡིཏུཾ ཀེནཱཔི ན ཤཀྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ཨེཏདྦྷིཏྟིམཱུལསྱོཔརི ཡདི ཀེཙིཏ྄ སྭརྞརཱུཔྱམཎིཀཱཥྛཏྲྀཎནལཱན྄ ནིཙིནྭནྟི, ");
INSERT INTO santib_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ཏརྷྱེཀཻཀསྱ ཀརྨྨ པྲཀཱཤིཥྱཏེ ཡཏཿ ས དིཝསསྟཏ྄ པྲཀཱཤཡིཥྱཏི། ཡཏོ ཧཏོསྟན དིཝསེན ཝཧྣིམཡེནོདེཏཝྱཾ ཏཏ ཨེཀཻཀསྱ ཀརྨྨ ཀཱིདྲྀཤམེཏསྱ པརཱིཀྵཱ བཧྣིནཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ཡསྱ ནིཙཡནརཱུཔཾ ཀརྨྨ སྠཱསྣུ བྷཝིཥྱཏི ས ཝེཏནཾ ལཔྶྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ཡསྱ ཙ ཀརྨྨ དྷཀྵྱཏེ ཏསྱ ཀྵཏི རྦྷཝིཥྱཏི ཀིནྟུ ཝཧྣེ རྣིརྒཏཛན ཨིཝ ས སྭཡཾ པརིཏྲཱཎཾ པྲཱཔྶྱཏི། ");
INSERT INTO santib_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ཡཱུཡམ྄ ཨཱིཤྭརསྱ མནྡིརཾ ཡུཥྨནྨདྷྱེ ཙེཤྭརསྱཱཏྨཱ ནིཝསཏཱིཏི ཀིཾ ན ཛཱནཱིཐ? ");
INSERT INTO santib_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ཨཱིཤྭརསྱ མནྡིརཾ ཡེན ཝིནཱཤྱཏེ སོ྅པཱིཤྭརེཎ ཝིནཱཤཡིཥྱཏེ ཡཏ ཨཱིཤྭརསྱ མནྡིརཾ པཝིཏྲམེཝ ཡཱུཡཾ ཏུ ཏནྨནྡིརམ྄ ཨཱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ཀོཔི སྭཾ ན ཝཉྩཡཏཱཾ། ཡུཥྨཱཀཾ ཀཤྩན ཙེདིཧལོཀསྱ ཛྙཱནེན ཛྙཱནཝཱནཧམིཏི བུདྷྱཏེ ཏརྷི ས ཡཏ྄ ཛྙཱནཱི བྷཝེཏ྄ ཏདརྠཾ མཱུཌྷོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ཡསྨཱདིཧལོཀསྱ ཛྙཱནམ྄ ཨཱིཤྭརསྱ སཱཀྵཱཏ྄ མཱུཌྷཏྭམེཝ། ཨེཏསྨིན྄ ལིཁིཏམཔྱཱསྟེ, ཏཱིཀྵྞཱ ཡཱ ཛྙཱནིནཱཾ བུདྡྷིསྟཡཱ ཏཱན྄ དྷརཏཱིཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","པུནཤྩ། ཛྙཱནིནཱཾ ཀལྤནཱ ཝེཏྟི པརམེཤོ ནིརརྠཀཱཿ། ");
INSERT INTO santib_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ཨཏཨེཝ ཀོ྅པི མནུཛཻརཱཏྨཱནཾ ན ཤླཱགྷཏཱཾ ཡཏཿ སཪྻྭཱཎི ཡུཥྨཱཀམེཝ, ");
INSERT INTO santib_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","པཽལ ཝཱ ཨཱཔལློ ཪྻཱ ཀཻཕཱ ཝཱ ཛགད྄ ཝཱ ཛཱིཝནཾ ཝཱ མརཎཾ ཝཱ ཝརྟྟམཱནཾ ཝཱ བྷཝིཥྱདྭཱ སཪྻྭཱཎྱེཝ ཡུཥྨཱཀཾ, ");
INSERT INTO santib_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ཡཱུཡཉྩ ཁྲཱིཥྚསྱ, ཁྲཱིཥྚཤྩེཤྭརསྱ། ");
INSERT INTO santib_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ལོཀཱ ཨསྨཱན྄ ཁྲཱིཥྚསྱ པརིཙཱརཀཱན྄ ཨཱིཤྭརསྱ ནིགཱུཋཝཱཀྱདྷནསྱཱདྷྱཀྵཱཾཤྩ མནྱནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ཀིཉྩ དྷནཱདྷྱཀྵེཎ ཝིཤྭསནཱིཡེན བྷཝིཏཝྱམེཏདེཝ ལོཀཻ ཪྻཱཙྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ཨཏོ ཝིཙཱརཡདྦྷི ཪྻུཥྨཱབྷིརནྱཻཿ ཀཻཤྩིན྄ མནུཛཻ ཪྻཱ མམ པརཱིཀྵཎཾ མཡཱཏཱིཝ ལགྷུ མནྱཏེ ྅ཧམཔྱཱཏྨཱནཾ ན ཝིཙཱརཡཱམི། ");
INSERT INTO santib_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","མཡཱ ཀིམཔྱཔརཱདྡྷམིཏྱཧཾ ན ཝེདྨི ཀིནྟྭེཏེན མམ ནིརཔརཱདྷཏྭཾ ན ནིཤྩཱིཡཏེ པྲབྷུརེཝ མམ ཝིཙཱརཡིཏཱསྟི། ");
INSERT INTO santib_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ཨཏ ཨུཔཡུཀྟསམཡཱཏ྄ པཱུཪྻྭམ྄ ཨརྠཏཿ པྲབྷོརཱགམནཱཏ྄ པཱུཪྻྭཾ ཡུཥྨཱབྷི ཪྻིཙཱརོ ན ཀྲིཡཏཱཾ། པྲབྷུརཱགཏྱ ཏིམིརེཎ པྲཙྪནྣཱནི སཪྻྭཱཎི དཱིཔཡིཥྱཏི མནསཱཾ མནྟྲཎཱཤྩ པྲཀཱཤཡིཥྱཏི ཏསྨིན྄ སམཡ ཨཱིཤྭརཱད྄ ཨེཀཻཀསྱ པྲཤཾསཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ཧེ བྷྲཱཏརཿ སཪྻྭཱཎྱེཏཱནི མཡཱཏྨཱནམ྄ ཨཱཔལླཝཉྩོདྡིཤྱ ཀཐིཏཱནི ཏསྱཻཏཏ྄ ཀཱརཎཾ ཡུཡཾ ཡཐཱ ཤཱསྟྲཱིཡཝིདྷིམཏིཀྲམྱ མཱནཝམ྄ ཨཏཱིཝ ནཱདརིཥྱདྷྦ ཨཱིཏྠཉྩཻཀེན ཝཻཔརཱིཏྱཱད྄ ཨཔརེཎ ན ཤླཱགྷིཥྱདྷྦ ཨེཏཱདྲྀཤཱིཾ ཤིཀྵཱམཱཝཡོརྡྲྀཥྚཱནྟཱཏ྄ ལཔྶྱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ཨཔརཱཏ྄ ཀསྟྭཱཾ ཝིཤེཥཡཏི? ཏུབྷྱཾ ཡནྣ དཏྟ ཏཱདྲྀཤཾ ཀིཾ དྷཱརཡསི? ཨདཏྟེནེཝ དཏྟེན ཝསྟུནཱ ཀུཏཿ ཤླཱགྷསེ? ");
INSERT INTO santib_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ཨིདཱནཱིམེཝ ཡཱུཡཾ ཀིཾ ཏྲྀཔྟཱ ལབྡྷདྷནཱ ཝཱ? ཨསྨཱསྭཝིདྱམཱནེཥུ ཡཱུཡཾ ཀིཾ རཱཛཏྭཔདཾ པྲཱཔྟཱཿ? ཡུཥྨཱཀཾ རཱཛཏྭཾ མཡཱབྷིལཥིཏཾ ཡཏསྟེན ཡུཥྨཱབྷིཿ སཧ ཝཡམཔི རཱཛྱཱཾཤིནོ བྷཝིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","པྲེརིཏཱ ཝཡཾ ཤེཥཱ ཧནྟཝྱཱཤྩེཝེཤྭརེཎ ནིདརྴིཏཱཿ། ཡཏོ ཝཡཾ སཪྻྭལོཀཱནཱམ྄ ཨརྠཏཿ སྭརྒཱིཡདཱུཏཱནཱཾ མཱནཝཱནཱཉྩ ཀཽཏུཀཱསྤདཱནི ཛཱཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ཁྲཱིཥྚསྱ ཀྲྀཏེ ཝཡཾ མཱུཌྷཱཿ ཀིནྟུ ཡཱུཡཾ ཁྲཱིཥྚེན ཛྙཱནིནཿ, ཝཡཾ དུརྦྦལཱ ཡཱུཡཉྩ སབལཱཿ, ཡཱུཡཾ སམྨཱནིཏཱ ཝཡཉྩཱཔམཱནིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ཝཡམདྱཱཔི ཀྵུདྷཱརྟྟཱསྟྲྀཥྞཱརྟྟཱ ཝསྟྲཧཱིནཱསྟཱཌིཏཱ ཨཱཤྲམརཧིཏཱཤྩ སནྟཿ ");
INSERT INTO santib_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ཀརྨྨཎི སྭཀརཱན྄ ཝྱཱཔཱརཡནྟཤྩ དུཿཁཻཿ ཀཱལཾ ཡཱཔཡཱམཿ། གརྷིཏཻརསྨཱབྷིརཱཤཱིཿ ཀཐྱཏེ དཱུརཱིཀྲྀཏཻཿ སཧྱཏེ ནིནྡིཏཻཿ པྲསཱདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ཝཡམདྱཱཔི ཛགཏཿ སམྨཱརྫནཱིཡོགྱཱ ཨཝཀརཱ ཨིཝ སཪྻྭཻ རྨནྱཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ཡུཥྨཱན྄ ཏྲཔཡིཏུམཧམེཏཱནི ལིཁཱམཱིཏི ནཧི ཀིནྟུ པྲིཡཱཏྨཛཱནིཝ ཡུཥྨཱན྄ པྲབོདྷཡཱམི། ");
INSERT INTO santib_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ཡཏཿ ཁྲཱིཥྚདྷརྨྨེ ཡདྱཔི ཡུཥྨཱཀཾ དཤསཧསྲཱཎི ཝིནེཏཱརོ བྷཝནྟི ཏཐཱཔི བཧཝོ ཛནཀཱ ན བྷཝནྟི ཡཏོ྅ཧམེཝ སུསཾཝཱདེན ཡཱིཤུཁྲཱིཥྚེ ཡུཥྨཱན྄ ཨཛནཡཾ། ");
INSERT INTO santib_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ཨཏོ ཡུཥྨཱན྄ ཝིནཡེ྅ཧཾ ཡཱུཡཾ མདནུགཱམིནོ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ཨིཏྱརྠཾ སཪྻྭེཥུ དྷརྨྨསམཱཛེཥུ སཪྻྭཏྲ ཁྲཱིཥྚདྷརྨྨཡོགྱཱ ཡེ ཝིདྷཡོ མཡོཔདིཤྱནྟེ ཏཱན྄ ཡོ ཡུཥྨཱན྄ སྨཱརཡིཥྱཏྱེཝམྦྷཱུཏཾ པྲབྷོཿ ཀྲྀཏེ པྲིཡཾ ཝིཤྭཱསིནཉྩ མདཱིཡཏནཡཾ ཏཱིམཐིཡཾ ཡུཥྨཱཀཾ སམཱིཔཾ པྲེཥིཏཝཱནཧཾ། ");
INSERT INTO santib_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ཨཔརམཧཾ ཡུཥྨཱཀཾ སམཱིཔཾ ན གམིཥྱཱམཱིཏི བུདྡྷྭཱ ཡུཥྨཱཀཾ ཀིཡནྟོ ལོཀཱ གཪྻྭནྟི། ");
INSERT INTO santib_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ཀིནྟུ ཡདི པྲབྷེརིཙྪཱ བྷཝཏི ཏརྷྱཧམཝིལམྦཾ ཡུཥྨཏྶམཱིཔམུཔསྠཱཡ ཏེཥཱཾ དརྤདྷྨཱཏཱནཱཾ ལོཀཱནཱཾ ཝཱཙཾ ཛྙཱསྱཱམཱིཏི ནཧི སཱམརྠྱམེཝ ཛྙཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ཡསྨཱདཱིཤྭརསྱ རཱཛཏྭཾ ཝཱགྱུཀྟཾ ནཧི ཀིནྟུ སཱམརྠྱཡུཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ཡུཥྨཱཀཾ ཀཱ ཝཱཉྪཱ? ཡུཥྨཏྶམཱིཔེ མཡཱ ཀིཾ དཎྜཔཱཎིནཱ གནྟཝྱམུཏ པྲེམནམྲཏཱཏྨཡུཀྟེན ཝཱ? ");
INSERT INTO santib_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ཨཔརཾ ཡུཥྨཱཀཾ མདྷྱེ ཝྱབྷིཙཱརོ ཝིདྱཏེ ས ཙ ཝྱབྷིཙཱརསྟཱདྲྀཤོ ཡད྄ དེཝཔཱུཛཀཱནཱཾ མདྷྱེ྅པི ཏཏྟུལྱོ ན ཝིདྱཏེ ཕལཏོ ཡུཥྨཱཀམེཀོ ཛནོ ཝིམཱཏྲྀགམནཾ ཀྲྀརུཏ ཨིཏི ཝཱརྟྟཱ སཪྻྭཏྲ ཝྱཱཔྟཱ། ");
INSERT INTO santib_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ཏཐཱཙ ཡཱུཡཾ དརྤདྷྨཱཏཱ ཨཱདྷྦེ, ཏཏ྄ ཀརྨྨ ཡེན ཀྲྀཏཾ ས ཡཐཱ ཡུཥྨནྨདྷྱཱད྄ དཱུརཱིཀྲིཡཏེ ཏཐཱ ཤོཀོ ཡུཥྨཱབྷི རྣ ཀྲིཡཏེ ཀིམ྄ ཨེཏཏ྄? ");
INSERT INTO santib_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ཨཝིདྱམཱནེ མདཱིཡཤརཱིརེ མམཱཏྨཱ ཡུཥྨནྨདྷྱེ ཝིདྱཏེ ཨཏོ྅ཧཾ ཝིདྱམཱན ཨིཝ ཏཏྐརྨྨཀཱརིཎོ ཝིཙཱརཾ ནིཤྩིཏཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ཨསྨཏྤྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ ནཱམྣཱ ཡུཥྨཱཀཾ མདཱིཡཱཏྨནཤྩ མིལནེ ཛཱཏེ ྅སྨཏྤྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ ཤཀྟེཿ སཱཧཱཡྻེན ");
INSERT INTO santib_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ས ནརཿ ཤརཱིརནཱཤཱརྠམསྨཱབྷིཿ ཤཡཏཱནོ ཧསྟེ སམརྤཡིཏཝྱསྟཏོ྅སྨཱཀཾ པྲབྷོ ཪྻཱིཤོ རྡིཝསེ ཏསྱཱཏྨཱ རཀྵཱཾ གནྟུཾ ཤཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ཡུཥྨཱཀཾ དརྤོ ན བྷདྲཱཡ ཡཱུཡཾ ཀིམེཏནྣ ཛཱནཱིཐ, ཡཐཱ, ཝིཀཱརཿ ཀྲྀཏྶྣཤཀྟཱུནཱཾ སྭལྤཀིཎྭེན ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ཡཱུཡཾ ཡཏ྄ ནཝཱིནཤཀྟུསྭརཱུཔཱ བྷཝེཏ ཏདརྠཾ པུརཱཏནཾ ཀིཎྭམ྄ ཨཝམཱརྫྫཏ ཡཏོ ཡུཥྨཱབྷིཿ ཀིཎྭཤཱུནྱཻ རྦྷཝིཏཝྱཾ། ཨཔརམ྄ ཨསྨཱཀཾ ནིསྟཱརོཏྶཝཱིཡམེཥཤཱཝཀོ ཡཿ ཁྲཱིཥྚཿ སོ྅སྨདརྠཾ བལཱིཀྲྀཏོ ྅བྷཝཏ྄། ");
INSERT INTO santib_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ཨཏཿ པུརཱཏནཀིཎྭེནཱརྠཏོ དུཥྚཏཱཛིགྷཱཾསཱརཱུཔེཎ ཀིཎྭེན ཏནྣཧི ཀིནྟུ སཱརལྱསཏྱཏྭརཱུཔཡཱ ཀིཎྭཤཱུནྱཏཡཱསྨཱབྷིརུཏྶཝཿ ཀརྟྟཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ཝྱཱབྷིཙཱརིཎཱཾ སཾསརྒོ ཡུཥྨཱབྷི ཪྻིཧཱཏཝྱ ཨིཏི མཡཱ པཏྲེ ལིཁིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ཀིནྟྭཻཧིཀལོཀཱནཱཾ མདྷྱེ ཡེ ཝྱབྷིཙཱརིཎོ ལོབྷིན ཨུཔདྲཱཝིཎོ དེཝཔཱུཛཀཱ ཝཱ ཏེཥཱཾ སཾསརྒཿ སཪྻྭཐཱ ཝིཧཱཏཝྱ ཨིཏི ནཧི, ཝིཧཱཏཝྱེ སཏི ཡུཥྨཱབྷི རྫགཏོ ནིརྒནྟཝྱམེཝ། ");
INSERT INTO santib_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ཀིནྟུ བྷྲཱཏྲྀཏྭེན ཝིཁྱཱཏཿ ཀཤྩིཛྫནོ ཡདི ཝྱབྷིཙཱརཱི ལོབྷཱི དེཝཔཱུཛཀོ ནིནྡཀོ མདྱཔ ཨུཔདྲཱཝཱི ཝཱ བྷཝེཏ྄ ཏརྷི ཏཱདྲྀཤེན མཱནཝེན སཧ བྷོཛནཔཱནེ྅པི ཡུཥྨཱབྷི རྣ ཀརྟྟཝྱེ ཨིཏྱདྷུནཱ མཡཱ ལིཁིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","སམཱཛབཧིཿསྠིཏཱནཱཾ ལོཀཱནཱཾ ཝིཙཱརཀརཎེ མམ ཀོ྅དྷིཀཱརཿ? ཀིནྟུ ཏདནྟརྒཏཱནཱཾ ཝིཙཱརཎཾ ཡུཥྨཱབྷིཿ ཀིཾ ན ཀརྟྟཝྱཾ བྷཝེཏ྄? ");
INSERT INTO santib_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","བཧིཿསྠཱནཱཾ ཏུ ཝིཙཱར ཨཱིཤྭརེཎ ཀཱརིཥྱཏེ། ཨཏོ ཡུཥྨཱབྷིཿ ས པཱཏཀཱི སྭམདྷྱཱད྄ བཧིཥྐྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ཡུཥྨཱཀམེཀསྱ ཛནསྱཱཔརེཎ སཧ ཝིཝཱདེ ཛཱཏེ ས པཝིཏྲལོཀཻ ཪྻིཙཱརམཀཱརཡན྄ ཀིམ྄ ཨདྷཱརྨྨིཀལོཀཻ ཪྻིཙཱརཡིཏུཾ པྲོཏྶཧཏེ? ");
INSERT INTO santib_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ཛགཏོ྅པི ཝིཙཱརཎཾ པཝིཏྲལོཀཻཿ ཀཱརིཥྱཏ ཨེཏད྄ ཡཱུཡཾ ཀིཾ ན ཛཱནཱིཐ? ཨཏོ ཛགད྄ ཡདི ཡུཥྨཱབྷི ཪྻིཙཱརཡིཏཝྱཾ ཏརྷི ཀྵུདྲཏམཝིཙཱརེཥུ ཡཱུཡཾ ཀིམསམརྠཱཿ? ");
INSERT INTO santib_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","དཱུཏཱ ཨཔྱསྨཱབྷི ཪྻིཙཱརཡིཥྱནྟ ཨིཏི ཀིཾ ན ཛཱནཱིཐ? ཨཏ ཨཻཧིཀཝིཥཡཱཿ ཀིམ྄ ཨསྨཱབྷི རྣ ཝིཙཱརཡིཏཝྱཱ བྷཝེཡུཿ? ");
INSERT INTO santib_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ཨཻཧིཀཝིཥཡསྱ ཝིཙཱརེ ཡུཥྨཱབྷིཿ ཀརྟྟཝྱེ ཡེ ལོཀཱཿ སམིཏཽ ཀྵུདྲཏམཱསྟ ཨེཝ ནིཡུཛྱནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ཨཧཾ ཡུཥྨཱན྄ ཏྲཔཡིཏུམིཙྪན྄ ཝདཱམི ཡྲྀཥྨནྨདྷྱེ ཀིམེཀོ྅པི མནུཥྱསྟཱདྲྀག྄ བུདྡྷིམཱནྣཧི ཡོ བྷྲཱཏྲྀཝིཝཱདཝིཙཱརཎེ སམརྠཿ སྱཱཏ྄? ");
INSERT INTO santib_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ཀིཉྩཻཀོ བྷྲཱཏཱ བྷྲཱཏྲཱནྱེན ཀིམཝིཤྭཱསིནཱཾ ཝིཙཱརཀཱཎཱཾ སཱཀྵཱད྄ ཝིཝདཏེ? ཡཥྨནྨདྷྱེ ཝིཝཱདཱ ཝིདྱནྟ ཨེཏདཔི ཡུཥྨཱཀཾ དོཥཿ། ");
INSERT INTO santib_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ཡཱུཡཾ ཀུཏོ྅ནྱཱཡསཧནཾ ཀྵཏིསཧནཾ ཝཱ ཤྲེཡོ ན མནྱདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ཀིནྟུ ཡཱུཡམཔི བྷྲཱཏྲྀནེཝ པྲཏྱནྱཱཡཾ ཀྵཏིཉྩ ཀུརུཐ ཀིམེཏཏ྄? ");
INSERT INTO santib_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ཨཱིཤྭརསྱ རཱཛྱེ྅ནྱཱཡཀཱརིཎཱཾ ལོཀཱནཱམདྷིཀཱརོ ནཱསྟྱེཏད྄ ཡཱུཡཾ ཀིཾ ན ཛཱནཱིཐ? མཱ ཝཉྩྱདྷྭཾ, ཡེ ཝྱབྷིཙཱརིཎོ དེཝཱརྩྩིནཿ པཱརདཱརིཀཱཿ སྟྲཱིཝདཱཙཱརིཎཿ པུཾམཻཐུནཀཱརིཎསྟསྐརཱ ");
INSERT INTO santib_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ལོབྷིནོ མདྱཔཱ ནིནྡཀཱ ཨུཔདྲཱཝིཎོ ཝཱ ཏ ཨཱིཤྭརསྱ རཱཛྱབྷཱགིནོ ན བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ཡཱུཡཉྩཻཝཾཝིདྷཱ ལོཀཱ ཨཱསྟ ཀིནྟུ པྲབྷོ ཪྻཱིཤོ རྣཱམྣཱསྨདཱིཤྭརསྱཱཏྨནཱ ཙ ཡཱུཡཾ པྲཀྵཱལིཏཱཿ པཱཝིཏཱཿ སཔུཎྱཱིཀྲྀཏཱཤྩ། ");
INSERT INTO santib_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","མདརྠཾ སཪྻྭཾ དྲཝྱམ྄ ཨཔྲཏིཥིདྡྷཾ ཀིནྟུ ན སཪྻྭཾ ཧིཏཛནཀཾ། མདརྠཾ སཪྻྭམཔྲཏིཥིདྡྷཾ ཏཐཱཔྱཧཾ ཀསྱཱཔི དྲཝྱསྱ ཝཤཱིཀྲྀཏོ ན བྷཝིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ཨུདརཱཡ བྷཀྵྱཱཎི བྷཀྵྱེབྷྱཤྩོདརཾ, ཀིནྟུ བྷཀྵྱོདརེ ཨཱིཤྭརེཎ ནཱཤཡིཥྱེཏེ; ཨཔརཾ དེཧོ ན ཝྱབྷིཙཱརཱཡ ཀིནྟུ པྲབྷཝེ པྲབྷུཤྩ དེཧཱཡ། ");
INSERT INTO santib_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ཡཤྩེཤྭརཿ པྲབྷུམུཏྠཱཔིཏཝཱན྄ ས སྭཤཀྟྱཱསྨཱནཔྱུཏྠཱཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ཡུཥྨཱཀཾ ཡཱནི ཤརཱིརཱཎི ཏཱནི ཁྲཱིཥྚསྱཱངྒཱནཱིཏི ཀིཾ ཡཱུཡཾ ན ཛཱནཱིཐ? ཨཏཿ ཁྲཱིཥྚསྱ ཡཱནྱངྒཱནི ཏཱནི མཡཱཔཧྲྀཏྱ ཝེཤྱཱཡཱ ཨངྒཱནི ཀིཾ ཀཱརིཥྱནྟེ? ཏནྣ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ཡཿ ཀཤྩིད྄ ཝེཤྱཱཡཱམ྄ ཨཱསཛྱཏེ ས ཏཡཱ སཧཻཀདེཧོ བྷཝཏི ཀིཾ ཡཱུཡམེཏནྣ ཛཱནཱིཐ? ཡཏོ ལིཁིཏམཱསྟེ, ཡཐཱ, ཏཽ དྭཽ ཛནཱཝེཀཱངྒཽ བྷཝིཥྱཏཿ། ");
INSERT INTO santib_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","མཱནཝཱ ཡཱནྱནྱཱནི ཀལུཥཱཎི ཀུཪྻྭཏེ ཏཱནི ཝཔུ རྣ སམཱཝིཤནྟི ཀིནྟུ ཝྱབྷིཙཱརིཎཱ སྭཝིགྲཧསྱ ཝིརུདྡྷཾ ཀལྨཥཾ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","མཱནཝཱ ཡཱནྱནྱཱནི ཀལུཥཱཎི ཀུཪྻྭཏེ ཏཱནི ཝཔུ རྣ སམཱཝིཤནྟི ཀིནྟུ ཝྱབྷིཙཱརིཎཱ སྭཝིགྲཧསྱ ཝིརུདྡྷཾ ཀལྨཥཾ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ཡུཥྨཱཀཾ ཡཱནི ཝཔཱུཾསི ཏཱནི ཡུཥྨདནྟཿསྠིཏསྱེཤྭརཱལླབྡྷསྱ པཝིཏྲསྱཱཏྨནོ མནྡིརཱཎི ཡཱུཡཉྩ སྭེཥཱཾ སྭཱམིནོ ནཱདྷྭེ ཀིམེཏད྄ ཡུཥྨཱབྷི རྣ ཛྙཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ཡཱུཡཾ མཱུལྱེན ཀྲཱིཏཱ ཨཏོ ཝཔུརྨནོབྷྱཱམ྄ ཨཱིཤྭརོ ཡུཥྨཱབྷིཿ པཱུཛྱཏཱཾ ཡཏ ཨཱིཤྭར ཨེཝ ཏཡོཿ སྭཱམཱི། ");
INSERT INTO santib_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ཨཔརཉྩ ཡུཥྨཱབྷི རྨཱཾ པྲཏི ཡཏ྄ པཏྲམལེཁི ཏསྱོཏྟརམེཏཏ྄, ཡོཥིཏོ྅སྤརྴནཾ མནུཛསྱ ཝརཾ; ");
INSERT INTO santib_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ཀིནྟུ ཝྱབྷིཙཱརབྷཡཱད྄ ཨེཀཻཀསྱ པུཾསཿ སྭཀཱིཡབྷཱཪྻྱཱ བྷཝཏུ ཏདྭད྄ ཨེཀཻཀསྱཱ ཡོཥིཏོ ྅པི སྭཀཱིཡབྷརྟྟཱ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","བྷཱཪྻྱཱཡཻ བྷརྟྲཱ ཡདྱད྄ ཝིཏརཎཱིཡཾ ཏད྄ ཝིཏཱིཪྻྱཏཱཾ ཏདྭད྄ བྷརྟྲེ྅པི བྷཱཪྻྱཡཱ ཝིཏརཎཱིཡཾ ཝིཏཱིཪྻྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","བྷཱཪྻྱཱཡཱཿ སྭདེཧེ སྭཏྭཾ ནཱསྟི བྷརྟྟུརེཝ, ཏདྭད྄ བྷརྟྟུརཔི སྭདེཧེ སྭཏྭཾ ནཱསྟི བྷཱཪྻྱཱཡཱ ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ཨུཔོཥཎཔྲཱརྠནཡོཿ སེཝནཱརྠམ྄ ཨེཀམནྟྲཎཱནཱཾ ཡུཥྨཱཀཾ ཀིཡཏྐཱལཾ ཡཱཝད྄ ཡཱ པྲྀཐཀྶྠིཏི རྦྷཝཏི ཏདནྱོ ཝིཙྪེདོ ཡུཥྨནྨདྷྱེ ན བྷཝཏུ, ཏཏཿ པརམ྄ ཨིནྡྲིཡཱཎཱམ྄ ཨདྷཻཪྻྱཱཏ྄ ཤཡཏཱན྄ ཡད྄ ཡུཥྨཱན྄ པརཱིཀྵཱཾ ན ནཡེཏ྄ ཏདརྠཾ པུནརེཀཏྲ མིལཏ། ");
INSERT INTO santib_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ཨེཏད྄ ཨཱདེཤཏོ ནཧི ཀིནྟྭནུཛྙཱཏ ཨེཝ མཡཱ ཀཐྱཏེ, ");
INSERT INTO santib_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ཡཏོ མམཱཝསྠེཝ སཪྻྭམཱནཝཱནཱམཝསྠཱ བྷཝཏྭིཏི མམ ཝཱཉྪཱ ཀིནྟྭཱིཤྭརཱད྄ ཨེཀེནཻཀོ ཝརོ྅ནྱེན ཙཱནྱོ ཝར ཨིཏྠམེཀཻཀེན སྭཀཱིཡཝརོ ལབྡྷཿ། ");
INSERT INTO santib_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ཨཔརམ྄ ཨཀྲྀཏཝིཝཱཧཱན྄ ཝིདྷཝཱཤྩ པྲཏི མམཻཏནྣིཝེདནཾ མམེཝ ཏེཥཱམཝསྠིཏི རྦྷདྲཱ; ");
INSERT INTO santib_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ཀིཉྩ ཡདི ཏཻརིནྡྲིཡཱཎི ནིཡནྟུཾ ན ཤཀྱནྟེ ཏརྷི ཝིཝཱཧཿ ཀྲིཡཏཱཾ ཡཏཿ ཀཱམདཧནཱད྄ ཝྱཱུཌྷཏྭཾ བྷདྲཾ། ");
INSERT INTO santib_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ཡེ ཙ ཀྲྀཏཝིཝཱཧཱསྟེ མཡཱ ནཧི པྲབྷུནཻཝཻཏད྄ ཨཱཛྙཱཔྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","བྷཱཪྻྱཱ བྷརྟྟྲྀཏཿ པྲྀཐཀ྄ ན བྷཝཏུ། ཡདི ཝཱ པྲྀཐགྦྷཱུཏཱ སྱཱཏ྄ ཏརྷི ནིཪྻིཝཱཧཱ ཏིཥྛཏུ སྭཱིཡཔཏིནཱ ཝཱ སནྡདྷཱཏུ བྷརྟྟཱཔི བྷཱཪྻྱཱཾ ན ཏྱཛཏུ། ");
INSERT INTO santib_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ཨིཏརཱན྄ ཛནཱན྄ པྲཏི པྲབྷུ རྣ བྲཝཱིཏི ཀིནྟྭཧཾ བྲཝཱིམི; ཀསྱཙིད྄ བྷྲཱཏུཪྻོཥིད྄ ཨཝིཤྭཱསིནཱི སཏྱཔི ཡདི ཏེན སཧཝཱསེ ཏུཥྱཏི ཏརྷི སཱ ཏེན ན ཏྱཛྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ཏདྭཏ྄ ཀསྱཱཤྩིད྄ ཡོཥིཏཿ པཏིརཝིཤྭཱསཱི སནྣཔི ཡདི ཏཡཱ སཧཝཱསེ ཏུཥྱཏི ཏརྷི ས ཏཡཱ ན ཏྱཛྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ཡཏོ྅ཝིཤྭཱསཱི བྷརྟྟཱ བྷཱཪྻྱཡཱ པཝིཏྲཱིབྷཱུཏཿ, ཏདྭདཝིཤྭཱསིནཱི བྷཱཪྻྱཱ བྷརྟྲཱ པཝིཏྲཱིབྷཱུཏཱ; ནོཙེད྄ ཡུཥྨཱཀམཔཏྱཱནྱཤུཙཱིནྱབྷཝིཥྱན྄ ཀིནྟྭདྷུནཱ ཏཱནི པཝིཏྲཱཎི སནྟི། ");
INSERT INTO santib_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ཨཝིཤྭཱསཱི ཛནོ ཡདི ཝཱ པྲྀཐག྄ བྷཝཏི ཏརྷི པྲྀཐག྄ བྷཝཏུ; ཨེཏེན བྷྲཱཏཱ བྷགིནཱི ཝཱ ན ནིབདྷྱཏེ ཏཐཱཔི ཝཡམཱིཤྭརེཎ ཤཱནྟཡེ སམཱཧཱུཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ཧེ ནཱརི ཏཝ བྷརྟྟུཿ པརིཏྲཱཎཾ ཏྭཏྟོ བྷཝིཥྱཏི ན ཝེཏི ཏྭཡཱ ཀིཾ ཛྙཱཡཏེ? ཧེ ནར ཏཝ ཛཱཡཱཡཱཿ པརིཏྲཱཎཾ ཏྭཏྟེा བྷཝིཥྱཏི ན ཝེཏི ཏྭཡཱ ཀིཾ ཛྙཱཡཏེ? ");
INSERT INTO santib_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ཨེཀཻཀོ ཛནཿ པརམེཤྭརཱལླབྡྷཾ ཡད྄ བྷཛཏེ ཡསྱཱཉྩཱཝསྠཱཡཱམ྄ ཨཱིཤྭརེཎཱཧྭཱཡི ཏདནུསཱརེཎཻཝཱཙརཏུ ཏདཧཾ སཪྻྭསམཱཛསྠཱན྄ ཨཱདིཤཱམི། ");
INSERT INTO santib_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ཚིནྣཏྭག྄ བྷྲྀཏྭཱ ཡ ཨཱཧཱུཏཿ ས པྲཀྲྀཥྚཏྭཀ྄ ན བྷཝཏུ, ཏདྭད྄ ཨཚིནྣཏྭག྄ བྷཱུཏྭཱ ཡ ཨཱཧཱུཏཿ ས ཚིནྣཏྭཀ྄ ན བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ཏྭཀྪེདཿ སཱརོ ནཧི ཏདྭདཏྭཀྪེདོ྅པི སཱརོ ནཧི ཀིནྟྭཱིཤྭརསྱཱཛྙཱནཱཾ པཱལནམེཝ། ");
INSERT INTO santib_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ཡོ ཛནོ ཡསྱཱམཝསྠཱཡཱམཱཧྭཱཡི ས ཏསྱཱམེཝཱཝཏིཥྛཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","དཱསཿ སན྄ ཏྭཾ ཀིམཱཧཱུཏོ྅སི? ཏནྨཱ ཙིནྟཡ, ཏཐཱཙ ཡདི སྭཏནྟྲོ བྷཝིཏུཾ ཤཀྣུཡཱསྟརྷི ཏདེཝ ཝྲྀཎུ། ");
INSERT INTO santib_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ཡཏཿ པྲབྷུནཱཧཱུཏོ ཡོ དཱསཿ ས པྲབྷོ རྨོཙིཏཛནཿ། ཏདྭད྄ ཏེནཱཧཱུཏཿ སྭཏནྟྲོ ཛནོ྅པི ཁྲཱིཥྚསྱ དཱས ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ཡཱུཡཾ མཱུལྱེན ཀྲཱིཏཱ ཨཏོ ཧེཏོ རྨཱནཝཱནཱཾ དཱསཱ མཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ཧེ བྷྲཱཏརོ ཡསྱཱམཝསྠཱཡཱཾ ཡསྱཱཧྭཱནམབྷཝཏ྄ ཏཡཱ ས ཨཱིཤྭརསྱ སཱཀྵཱཏ྄ ཏིཥྛཏུ། ");
INSERT INTO santib_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ཨཔརམ྄ ཨཀྲྀཏཝིཝཱཧཱན྄ ཛནཱན྄ པྲཏི པྲབྷོཿ ཀོ྅པྱཱདེཤོ མཡཱ ན ལབྡྷཿ ཀིནྟུ པྲབྷོརནུཀམྤཡཱ ཝིཤྭཱསྱོ བྷཱུཏོ྅ཧཾ ཡད྄ བྷདྲཾ མནྱེ ཏད྄ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ཝརྟྟམཱནཱཏ྄ ཀླེཤསམཡཱཏ྄ མནུཥྱསྱཱནཱུཌྷཏྭཾ བྷདྲམིཏི མཡཱ བུདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ཏྭཾ ཀིཾ ཡོཥིཏི ནིབདྡྷོ྅སི ཏརྷི མོཙནཾ པྲཱཔྟུཾ མཱ ཡཏསྭ། ཀིཾ ཝཱ ཡོཥིཏོ མུཀྟོ྅སི? ཏརྷི ཛཱཡཱཾ མཱ གཝེཥཡ། ");
INSERT INTO santib_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ཝིཝཱཧཾ ཀུཪྻྭཏཱ ཏྭཡཱ ཀིམཔི ནཱཔཱརཱདྷྱཏེ ཏདྭད྄ ཝྱཱུཧྱམཱནཡཱ ཡུཝཏྱཱཔི ཀིམཔི ནཱཔརཱདྷྱཏེ ཏཐཱཙ ཏཱདྲྀཤཽ དྭཽ ཛནཽ ཤཱརཱིརིཀཾ ཀླེཤཾ ལཔྶྱེཏེ ཀིནྟུ ཡུཥྨཱན྄ པྲཏི མམ ཀརུཎཱ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ཧེ བྷྲཱཏརོ྅ཧམིདཾ བྲཝཱིམི, ཨིཏཿ པརཾ སམཡོ྅ཏཱིཝ སཾཀྵིཔྟཿ, ");
INSERT INTO santib_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ཨཏཿ ཀྲྀཏདཱརཻརཀྲྀཏདཱརཻརིཝ རུདདྦྷིཤྩཱརུདདྦྷིརིཝ སཱནནྡཻཤྩ ནིརཱནནྡཻརིཝ ཀྲེཏྲྀབྷིཤྩཱབྷཱགིབྷིརིཝཱཙརིཏཝྱཾ ");
INSERT INTO santib_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ཡེ ཙ སཾསཱརེ ཙརནྟི ཏཻ རྣཱཏིཙརིཏཝྱཾ ཡཏ ཨིཧལེाཀསྱ ཀཽཏུཀོ ཝིཙལཏི། ");
INSERT INTO santib_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ཀིནྟུ ཡཱུཡཾ ཡནྣིཤྩིནྟཱ བྷཝེཏེཏི མམ ཝཱཉྪཱ། ཨཀྲྀཏཝིཝཱཧོ ཛནོ ཡཐཱ པྲབྷུཾ པརིཏོཥཡེཏ྄ ཏཐཱ པྲབྷུཾ ཙིནྟཡཏི, ");
INSERT INTO santib_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ཀིནྟུ ཀྲྀཏཝིཝཱཧོ ཛནོ ཡཐཱ བྷཱཪྻྱཱཾ པརིཏོཥཡེཏ྄ ཏཐཱ སཾསཱརཾ ཙིནྟཡཏི། ");
INSERT INTO santib_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ཏདྭད྄ ཨཱུཌྷཡོཥིཏོ ྅ནཱུཌྷཱ ཝིཤིཥྱཏེ། ཡཱནཱུཌྷཱ སཱ ཡཐཱ ཀཱཡམནསོཿ པཝིཏྲཱ བྷཝེཏ྄ ཏཐཱ པྲབྷུཾ ཙིནྟཡཏི ཡཱ ཙོཌྷཱ སཱ ཡཐཱ བྷརྟྟཱརཾ པརིཏོཥཡེཏ྄ ཏཐཱ སཾསཱརཾ ཙིནྟཡཏི། ");
INSERT INTO santib_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ཨཧཾ ཡད྄ ཡུཥྨཱན྄ མྲྀགབནྡྷིནྱཱ པརིཀྵིཔེཡཾ ཏདརྠཾ ནཧི ཀིནྟུ ཡཱུཡཾ ཡདནིནྡིཏཱ བྷཱུཏྭཱ པྲབྷོཿ སེཝནེ྅བཱདྷམ྄ ཨཱསཀྟཱ བྷཝེཏ ཏདརྠམེཏཱནི སཪྻྭཱཎི ཡུཥྨཱཀཾ ཧིཏཱཡ མཡཱ ཀཐྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ཀསྱཙིཏ྄ ཀནྱཱཡཱཾ ཡཽཝནཔྲཱཔྟཱཡཱཾ ཡདི ས ཏསྱཱ ཨནཱུཌྷཏྭཾ ནིནྡནཱིཡཾ ཝིཝཱཧཤྩ སཱདྷཡིཏཝྱ ཨིཏི མནྱཏེ ཏརྷི ཡཐཱབྷིལཱཥཾ ཀརོཏུ, ཨེཏེན ཀིམཔི ནཱཔརཱཏྶྱཏི ཝིཝཱཧཿ ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ཀིནྟུ དུཿཁེནཱཀླིཥྚཿ ཀཤྩིཏ྄ པིཏཱ ཡདི སྠིརམནོགཏཿ སྭམནོ྅བྷིལཱཥསཱདྷནེ སམརྠཤྩ སྱཱཏ྄ མམ ཀནྱཱ མཡཱ རཀྵིཏཝྱེཏི མནསི ནིཤྩིནོཏི ཙ ཏརྷི ས བྷདྲཾ ཀརྨྨ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ཨཏོ ཡོ ཝིཝཱཧཾ ཀརོཏི ས བྷདྲཾ ཀརྨྨ ཀརོཏི ཡཤྩ ཝིཝཱཧཾ ན ཀརོཏི ས བྷདྲཏརཾ ཀརྨྨ ཀརོཏི། ");
INSERT INTO santib_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ཡཱཝཏྐཱལཾ པཏི རྫཱིཝཏི ཏཱཝད྄ བྷཱཪྻྱཱ ཝྱཝསྠཡཱ ནིབདྡྷཱ ཏིཥྛཏི ཀིནྟུ པཏྱཽ མཧཱནིདྲཱཾ གཏེ སཱ མུཀྟཱིབྷཱུཡ ཡམབྷིལཥཏི ཏེན སཧ ཏསྱཱ ཝིཝཱཧོ བྷཝིཏུཾ ཤཀྣོཏི, ཀིནྟྭེཏཏ྄ ཀེཝལཾ པྲབྷུབྷཀྟཱནཱཾ མདྷྱེ། ");
INSERT INTO santib_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ཏཐཱཙ སཱ ཡདི ནིཥྤཏིཀཱ ཏིཥྛཏི ཏརྷི ཏསྱཱཿ ཀྵེམཾ བྷཝིཥྱཏཱིཏི མམ བྷཱཝཿ། ཨཔརམ྄ ཨཱིཤྭརསྱཱཏྨཱ མམཱཔྱནྟ ཪྻིདྱཏ ཨིཏི མཡཱ བུདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","དེཝཔྲསཱདེ སཪྻྭེཥཱམ྄ ཨསྨཱཀཾ ཛྙཱནམཱསྟེ ཏདྭཡཾ ཝིདྨཿ། ཏཐཱཔི ཛྙཱནཾ གཪྻྭཾ ཛནཡཏི ཀིནྟུ པྲེམཏོ ནིཥྛཱ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ཨཏཿ ཀཤྩན ཡདི མནྱཏེ མམ ཛྙཱནམཱསྟ ཨིཏི ཏརྷི ཏེན ཡཱདྲྀཤཾ ཛྙཱནཾ ཙེཥྚིཏཝྱཾ ཏཱདྲྀཤཾ ཀིམཔི ཛྙཱནམདྱཱཔི ན ལབྡྷཾ། ");
INSERT INTO santib_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ཀིནྟུ ཡ ཨཱིཤྭརེ པྲཱིཡཏེ ས ཨཱིཤྭརེཎཱཔི ཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","དེཝཏཱབལིཔྲསཱདབྷཀྵཎེ ཝཡམིདཾ ཝིདྨོ ཡཏ྄ ཛགནྨདྷྱེ ཀོ྅པི དེཝོ ན ཝིདྱཏེ, ཨེཀཤྩེཤྭརོ དྭིཏཱིཡོ ནཱསྟཱིཏི། ");
INSERT INTO santib_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","སྭརྒེ པྲྀཐིཝྱཱཾ ཝཱ ཡདྱཔི ཀེཥུཙིད྄ ཨཱིཤྭར ཨིཏི ནཱམཱརོཔྱཏེ ཏཱདྲྀཤཱཤྩ བཧཝ ཨཱིཤྭརཱ བཧཝཤྩ པྲབྷཝོ ཝིདྱནྟེ ");
INSERT INTO santib_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ཏཐཱཔྱསྨཱཀམདྭིཏཱིཡ ཨཱིཤྭརཿ ས པིཏཱ ཡསྨཱཏ྄ སཪྻྭེཥཱཾ ཡདརྠཉྩཱསྨཱཀཾ སྲྀཥྚི རྫཱཏཱ, ཨསྨཱཀཉྩཱདྭིཏཱིཡཿ པྲབྷུཿ ས ཡཱིཤུཿ ཁྲཱིཥྚོ ཡེན སཪྻྭཝསྟཱུནཱཾ ཡེནཱསྨཱཀམཔི སྲྀཥྚིཿ ཀྲྀཏཱ། ");
INSERT INTO santib_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ཨདྷིཀནྟུ ཛྙཱནཾ སཪྻྭེཥཱཾ ནཱསྟི ཡཏཿ ཀེཙིདདྱཱཔི དེཝཏཱཾ སམྨནྱ དེཝཔྲསཱདམིཝ ཏད྄ བྷཀྵྱཾ བྷུཉྫཏེ ཏེན དུརྦྦལཏཡཱ ཏེཥཱཾ སྭཱནྟཱནི མལཱིམསཱནི བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ཀིནྟུ བྷཀྵྱདྲཝྱཱད྄ ཝཡམ྄ ཨཱིཤྭརེཎ གྲཱཧྱཱ བྷཝཱམསྟནྣཧི ཡཏོ བྷུངྐྟྭཱ ཝཡམུཏྐྲྀཥྚཱ ན བྷཝཱམསྟདྭདབྷུངྐྟྭཱཔྱཔཀྲྀཥྚཱ ན བྷཝཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ཨཏོ ཡུཥྨཱཀཾ ཡཱ ཀྵམཏཱ སཱ དུརྦྦལཱནཱམ྄ ཨུནྨཱཐསྭརཱུཔཱ ཡནྣ བྷཝེཏ྄ ཏདརྠཾ སཱཝདྷཱནཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ཡཏོ ཛྙཱནཝིཤིཥྚསྟྭཾ ཡདི དེཝཱལཡེ ཨུཔཝིཥྚཿ ཀེནཱཔི དྲྀཤྱསེ ཏརྷི ཏསྱ དུརྦྦལསྱ མནསི ཀིཾ པྲསཱདབྷཀྵཎ ཨུཏྶཱཧོ ན ཛནིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ཏཐཱ སཏི ཡསྱ ཀྲྀཏེ ཁྲཱིཥྚོ མམཱར ཏཝ ས དུརྦྦལོ བྷྲཱཏཱ ཏཝ ཛྙཱནཱཏ྄ ཀིཾ ན ཝིནཾཀྵྱཏི? ");
INSERT INTO santib_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ཨིཏྱནེན པྲཀཱརེཎ བྷྲཱཏྲྀཎཱཾ ཝིརུདྡྷམ྄ ཨཔརཱདྷྱདྦྷིསྟེཥཱཾ དུརྦྦལཱནི མནཱཾསི ཝྱཱགྷཱཏཡདྦྷིཤྩ ཡུཥྨཱབྷིཿ ཁྲཱིཥྚསྱ ཝཻཔརཱིཏྱེནཱཔརཱདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ཨཏོ ཧེཏོཿ པིཤིཏཱཤནཾ ཡདི མམ བྷྲཱཏུ ཪྻིགྷྣསྭརཱུཔཾ བྷཝེཏ྄ ཏརྷྱཧཾ ཡཏ྄ སྭབྷྲཱཏུ ཪྻིགྷྣཛནཀོ ན བྷཝེཡཾ ཏདརྠཾ ཡཱཝཛྫཱིཝནཾ པིཤིཏཾ ན བྷོཀྵྱེ། ");
INSERT INTO santib_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ཨཧཾ ཀིམ྄ ཨེཀཿ པྲེརིཏོ ནཱསྨི? ཀིམཧཾ སྭཏནྟྲོ ནཱསྨི? ཨསྨཱཀཾ པྲབྷུ ཪྻཱིཤུཿ ཁྲཱིཥྚཿ ཀིཾ མཡཱ ནཱདརྴི? ཡཱུཡམཔི ཀིཾ པྲབྷུནཱ མདཱིཡཤྲམཕལསྭརཱུཔཱ ན བྷཝཐ? ");
INSERT INTO santib_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ཨནྱལོཀཱནཱཾ ཀྲྀཏེ ཡདྱཔྱཧཾ པྲེརིཏོ ན བྷཝེཡཾ ཏཐཱཙ ཡུཥྨཏྐྲྀཏེ པྲེརིཏོ྅སྨི ཡཏཿ པྲབྷུནཱ མམ པྲེརིཏཏྭཔདསྱ མུདྲཱསྭརཱུཔཱ ཡཱུཡམེཝཱདྷྭེ། ");
INSERT INTO santib_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ཡེ ལོཀཱ མཡི དོཥམཱརོཔཡནྟི ཏཱན྄ པྲཏི མམ པྲཏྱུཏྟརམེཏཏ྄། ");
INSERT INTO santib_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","བྷོཛནཔཱནཡོཿ ཀིམསྨཱཀཾ ཀྵམཏཱ ནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ཨནྱེ པྲེརིཏཱཿ པྲབྷོ རྦྷྲཱཏརཽ ཀཻཕཱཤྩ ཡཏ྄ ཀུཪྻྭནྟི ཏདྭཏ྄ ཀཱཉྩིཏ྄ དྷརྨྨབྷགིནཱིཾ ཝྱཱུཧྱ ཏཡཱ སཱརྡྡྷཾ པཪྻྱཊིཏུཾ ཝཡཾ ཀིཾ ན ཤཀྣུམཿ? ");
INSERT INTO santib_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","སཱཾསཱརིཀཤྲམསྱ པརིཏྱཱགཱཏ྄ ཀིཾ ཀེཝལམཧཾ བརྞབྦཱཤྩ ནིཝཱརིཏཽ? ");
INSERT INTO santib_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ནིཛདྷནཝྱཡེན ཀཿ སཾགྲཱམཾ ཀརོཏི? ཀོ ཝཱ དྲཱཀྵཱཀྵེཏྲཾ ཀྲྀཏྭཱ ཏཏྥལཱནི ན བྷུངྐྟེ? ཀོ ཝཱ པཤུཝྲཛཾ པཱལཡན྄ ཏཏྤཡོ ན པིཝཏི? ");
INSERT INTO santib_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ཀིམཧཾ ཀེཝལཱཾ མཱནུཥིཀཱཾ ཝཱཙཾ ཝདཱམི? ཝྱཝསྠཱཡཱཾ ཀིམེཏཱདྲྀཤཾ ཝཙནཾ ན ཝིདྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","མཱུསཱཝྱཝསྠཱགྲནྠེ ལིཁིཏམཱསྟེ, ཏྭཾ ཤསྱམརྡྡཀཝྲྀཥསྱཱསྱཾ ན བྷཾཏྶྱསཱིཏི། ཨཱིཤྭརེཎ བལཱིཝརྡྡཱནཱམེཝ ཙིནྟཱ ཀིཾ ཀྲིཡཏེ? ");
INSERT INTO santib_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ཀིཾ ཝཱ སཪྻྭཐཱསྨཱཀཾ ཀྲྀཏེ ཏདྭཙནཾ ཏེནོཀྟཾ? ཨསྨཱཀམེཝ ཀྲྀཏེ ཏལླིཁིཏཾ། ཡཿ ཀྵེཏྲཾ ཀརྵཏི ཏེན པྲཏྱཱཤཱཡུཀྟེན ཀརྵྚཝྱཾ, ཡཤྩ ཤསྱཱནི མརྡྡཡཏི ཏེན ལཱབྷཔྲཏྱཱཤཱཡུཀྟེན མརྡྡིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ཡུཥྨཏྐྲྀཏེ྅སྨཱབྷིཿ པཱརཏྲིཀཱཎི བཱིཛཱནི རོཔིཏཱནི, ཨཏོ ཡུཥྨཱཀམཻཧིཀཕལཱནཱཾ ཝཡམ྄ ཨཾཤིནོ བྷཝིཥྱཱམཿ ཀིམེཏཏ྄ མཧཏ྄ ཀརྨྨ? ");
INSERT INTO santib_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ཡུཥྨཱསུ ཡོ྅དྷིཀཱརསྟསྱ བྷཱགིནོ ཡདྱནྱེ བྷཝེཡུསྟརྷྱསྨཱབྷིསྟཏོ྅དྷིཀཾ ཀིཾ ཏསྱ བྷཱགིབྷི རྣ བྷཝིཏཝྱཾ? ཨདྷིཀནྟུ ཝཡཾ ཏེནཱདྷིཀཱརེཎ ན ཝྱཝཧྲྀཏཝནྟཿ ཀིནྟུ ཁྲཱིཥྚཱིཡསུསཾཝཱདསྱ ཀོ྅པི ཝྱཱགྷཱཏོ྅སྨཱབྷིཪྻནྣ ཛཱཡེཏ ཏདརྠཾ སཪྻྭཾ སཧཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ཨཔརཾ ཡེ པཝིཏྲཝསྟཱུནཱཾ པརིཙཪྻྱཱཾ ཀུཪྻྭནྟི ཏེ པཝིཏྲཝསྟུཏོ བྷཀྵྱཱཎི ལབྷནྟེ, ཡེ ཙ ཝེདྱཱཿ པརིཙཪྻྱཱཾ ཀུཪྻྭནྟི ཏེ ཝེདིསྠཝསྟཱུནཱམ྄ ཨཾཤིནོ བྷཝནྟྱེཏད྄ ཡཱུཡཾ ཀིཾ ན ཝིད? ");
INSERT INTO santib_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ཏདྭད྄ ཡེ སུསཾཝཱདཾ གྷོཥཡནྟི ཏཻཿ སུསཾཝཱདེན ཛཱིཝིཏཝྱམིཏི པྲབྷུནཱདིཥྚཾ། ");
INSERT INTO santib_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ཨཧམེཏེཥཱཾ སཪྻྭེཥཱཾ ཀིམཔི ནཱཤྲིཏཝཱན྄ མཱཾ པྲཏི ཏདནུསཱརཱཏ྄ ཨཱཙརིཏཝྱམིཏྱཱཤཡེནཱཔི པཏྲམིདཾ མཡཱ ན ལིཁྱཏེ ཡཏཿ ཀེནཱཔི ཛནེན མམ ཡཤསོ མུདྷཱཀརཎཱཏ྄ མམ མརཎཾ ཝརཾ། ");
INSERT INTO santib_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","སུསཾཝཱདགྷེཥཎཱཏ྄ མམ ཡཤོ ན ཛཱཡཏེ ཡཏསྟདྒྷོཥཎཾ མམཱཝཤྱཀཾ ཡདྱཧཾ སུསཾཝཱདཾ ན གྷོཥཡེཡཾ ཏརྷི མཱཾ དྷིཀ྄། ");
INSERT INTO santib_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ཨིཙྪུཀེན ཏཏ྄ ཀུཪྻྭཏཱ མཡཱ ཕལཾ ལཔྶྱཏེ ཀིནྟྭནིཙྪུཀེ྅པི མཡི ཏཏྐརྨྨཎོ བྷཱརོ྅རྤིཏོ྅སྟི། ");
INSERT INTO santib_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ཨེཏེན མཡཱ ལབྷྱཾ ཕལཾ ཀིཾ? སུསཾཝཱདེན མམ ཡོ྅དྷིཀཱར ཨཱསྟེ ཏཾ ཡདབྷདྲབྷཱཝེན ནཱཙརེཡཾ ཏདརྠཾ སུསཾཝཱདགྷོཥཎསམཡེ ཏསྱ ཁྲཱིཥྚཱིཡསུསཾཝཱདསྱ ནིཪྻྱཡཱིཀརཎམེཝ མམ ཕལཾ། ");
INSERT INTO santib_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","སཪྻྭེཥཱམ྄ ཨནཱཡཏྟོ྅ཧཾ ཡད྄ བྷཱུརིཤོ ལོཀཱན྄ པྲཏིཔདྱེ ཏདརྠཾ སཪྻྭེཥཱཾ དཱསཏྭམངྒཱིཀྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ཡིཧཱུདཱིཡཱན྄ ཡཏ྄ པྲཏིཔདྱེ ཏདརྠཾ ཡིཧཱུདཱིཡཱནཱཾ ཀྲྀཏེ ཡིཧཱུདཱིཡཨིཝཱབྷཝཾ། ཡེ ཙ ཝྱཝསྠཱཡཏྟཱསྟཱན྄ ཡཏ྄ པྲཏིཔདྱེ ཏདརྠཾ ཝྱཝསྠཱནཱཡཏྟོ ཡོ྅ཧཾ སོ྅ཧཾ ཝྱཝསྠཱཡཏྟཱནཱཾ ཀྲྀཏེ ཝྱཝསྠཱཡཏྟཨིཝཱབྷཝཾ། ");
INSERT INTO santib_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ཡེ ཙཱལབྡྷཝྱཝསྠཱསྟཱན྄ ཡཏ྄ པྲཏིཔདྱེ ཏདརྠམ྄ ཨཱིཤྭརསྱ སཱཀྵཱད྄ ཨལབྡྷཝྱཝསྠོ ན བྷཱུཏྭཱ ཁྲཱིཥྚེན ལབྡྷཝྱཝསྠོ ཡོ྅ཧཾ སོ྅ཧམ྄ ཨལབྡྷཝྱཝསྠཱནཱཾ ཀྲྀཏེ྅ལབྡྷཝྱཝསྠ ཨིཝཱབྷཝཾ། ");
INSERT INTO santib_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","དུརྦྦལཱན྄ ཡཏ྄ པྲཏིཔདྱེ ཏདརྠམཧཾ དུརྦྦལཱནཱཾ ཀྲྀཏེ དུརྦྦལཨིཝཱབྷཝཾ། ཨིཏྠཾ ཀེནཱཔི པྲཀཱརེཎ ཀཏིཔཡཱ ལོཀཱ ཡནྨཡཱ པརིཏྲཱཎཾ པྲཱཔྣུཡུསྟདརྠཾ ཡོ ཡཱདྲྀཤ ཨཱསཱིཏ྄ ཏསྱ ཀྲྀཏེ ྅ཧཾ ཏཱདྲྀཤཨིཝཱབྷཝཾ། ");
INSERT INTO santib_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ཨིདྲྀཤ ཨཱཙཱརཿ སུསཾཝཱདཱརྠཾ མཡཱ ཀྲིཡཏེ ཡཏོ྅ཧཾ ཏསྱ ཕལཱནཱཾ སཧབྷཱགཱི བྷཝིཏུམིཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","པཎྱལཱབྷཱརྠཾ ཡེ དྷཱཝནྟི དྷཱཝཏཱཾ ཏེཥཱཾ སཪྻྭེཥཱཾ ཀེཝལ ཨེཀཿ པཎྱཾ ལབྷཏེ ཡུཥྨཱབྷིཿ ཀིམེཏནྣ ཛྙཱཡཏེ? ཨཏོ ཡཱུཡཾ ཡཐཱ པཎྱཾ ལཔྶྱདྷྭེ ཏཐཻཝ དྷཱཝཏ། ");
INSERT INTO santib_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","མལླཱ ཨཔི སཪྻྭབྷོགེ པརིམིཏབྷོགིནོ བྷཝནྟི ཏེ ཏུ མླཱནཱཾ སྲཛཾ ལིཔྶནྟེ ཀིནྟུ ཝཡམ྄ ཨམླཱནཱཾ ལིཔྶཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ཏསྨཱད྄ ཨཧམཔི དྷཱཝཱམི ཀིནྟུ ལཀྵྱམནུདྡིཤྱ དྷཱཝཱམི ཏནྣཧི། ཨཧཾ མལླཨིཝ ཡུདྷྱཱམི ཙ ཀིནྟུ ཚཱཡཱམཱགྷཱཏཡནྣིཝ ཡུདྷྱཱམི ཏནྣཧི། ");
INSERT INTO santib_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ཨིཏརཱན྄ པྲཏི སུསཾཝཱདཾ གྷོཥཡིཏྭཱཧཾ ཡཏ྄ སྭཡམགྲཱཧྱོ ན བྷཝཱམི ཏདརྠཾ དེཧམ྄ ཨཱཧནྨི ཝཤཱིཀུཪྻྭེ ཙ། ");
INSERT INTO santib_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ཧེ བྷྲཱཏརཿ, ཨསྨཏྤིཏྲྀཔུརུཥཱནདྷི ཡཱུཡཾ ཡདཛྙཱཏཱ ན ཏིཥྛཏེཏི མམ ཝཱཉྪཱ, ཏེ སཪྻྭེ མེགྷཱདྷཿསྠིཏཱ བབྷཱུཝུཿ སཪྻྭེ སམུདྲམདྷྱེན ཝཝྲཛུཿ, ");
INSERT INTO santib_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","སཪྻྭེ མཱུསཱམུདྡིཤྱ མེགྷསམུདྲཡོ རྨཛྫིཏཱ བབྷཱུཝུཿ ");
INSERT INTO santib_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","སཪྻྭ ཨེཀམ྄ ཨཱཏྨིཀཾ བྷཀྵྱཾ བུབྷུཛིར ཨེཀམ྄ ཨཱཏྨིཀཾ པེཡཾ པཔུཤྩ ");
INSERT INTO santib_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ཡཏསྟེ྅ནུཙརཏ ཨཱཏྨིཀཱད྄ ཨཙལཱཏ྄ ལབྡྷཾ ཏོཡཾ པཔུཿ སོ྅ཙལཿ ཁྲཱིཥྚཨེཝ། ");
INSERT INTO santib_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ཏཐཱ སཏྱཔི ཏེཥཱཾ མདྷྱེ྅དྷིཀེཥུ ལོཀེཥྭཱིཤྭརོ ན སནྟུཏོཥེཏི ཧེཏོསྟེ པྲནྟརེ ནིཔཱཏིཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ཨེཏསྨིན྄ ཏེ ྅སྨཱཀཾ ནིདརྴནསྭརཱུཔཱ བབྷཱུཝུཿ; ཨཏསྟེ ཡཐཱ ཀུཏྶིཏཱབྷིལཱཥིཎོ བབྷཱུཝུརསྨཱབྷིསྟཐཱ ཀུཏྶིཏཱབྷིལཱཥིབྷི རྣ བྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ལིཁིཏམཱསྟེ, ལོཀཱ བྷོཀྟུཾ པཱཏུཉྩོཔཝིཝིཤུསྟཏཿ ཀྲཱིཌིཏུམུཏྠིཏཱ ཨིཏཡནེན པྲཀཱརེཎ ཏེཥཱཾ ཀཻཤྩིད྄ ཡདྭད྄ དེཝཔཱུཛཱ ཀྲྀཏཱ ཡུཥྨཱབྷིསྟདྭཏ྄ ན ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ཨཔརཾ ཏེཥཱཾ ཀཻཤྩིད྄ ཡདྭད྄ ཝྱབྷིཙཱརཿ ཀྲྀཏསྟེན ཙཻཀསྨིན྄ དིནེ ཏྲཡོཝིཾཤཏིསཧསྲཱཎི ལོཀཱ ནིཔཱཏིཏཱསྟདྭད྄ ཨསྨཱབྷི ཪྻྱབྷིཙཱརོ ན ཀརྟྟཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ཏེཥཱཾ ཀེཙིད྄ ཡདྭཏ྄ ཁྲཱིཥྚཾ པརཱིཀྵིཏཝནྟསྟསྨཱད྄ བྷུཛངྒཻ རྣཥྚཱཤྩ ཏདྭད྄ ཨསྨཱབྷིཿ ཁྲཱིཥྚོ ན པརཱིཀྵིཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ཏེཥཱཾ ཀེཙིད྄ ཡཐཱ ཝཱཀྐལཧཾ ཀྲྀཏཝནྟསྟཏྐཱརཎཱཏ྄ ཧནྟྲཱ ཝིནཱཤིཏཱཤྩ ཡུཥྨཱབྷིསྟདྭད྄ ཝཱཀྐལཧོ ན ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ཏཱན྄ པྲཏི ཡཱནྱེཏཱནི ཛགྷཊིརེ ཏཱནྱསྨཱཀཾ ནིདརྴནཱནི ཛགཏཿ ཤེཥཡུགེ ཝརྟྟམཱནཱནཱམ྄ ཨསྨཱཀཾ ཤིཀྵཱརྠཾ ལིཁིཏཱནི ཙ བབྷཱུཝུཿ། ");
INSERT INTO santib_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ཨཏཨེཝ ཡཿ ཀཤྩིད྄ སུསྠིརཾམནྱཿ ས ཡནྣ པཏེཏ྄ ཏཏྲ སཱཝདྷཱནོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","མཱནུཥིཀཔརཱིཀྵཱཏིརིཀྟཱ ཀཱཔི པརཱིཀྵཱ ཡུཥྨཱན྄ ནཱཀྲཱམཏ྄, ཨཱིཤྭརཤྩ ཝིཤྭཱསྱཿ སོ྅ཏིཤཀྟྱཱཾ པརཱིཀྵཱཡཱཾ པཏནཱཏ྄ ཡུཥྨཱན྄ རཀྵིཥྱཏི, པརཱིཀྵཱ ཙ ཡད྄ ཡུཥྨཱབྷིཿ སོཌྷུཾ ཤཀྱཏེ ཏདརྠཾ ཏཡཱ སཧ ནིསྟཱརསྱ པནྠཱནཾ ནིརཱུཔཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ཧེ པྲིཡབྷྲཱཏརཿ, དེཝཔཱུཛཱཏོ དཱུརམ྄ ཨཔསརཏ། ");
INSERT INTO santib_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ཨཧཾ ཡུཥྨཱན྄ ཝིཛྙཱན྄ མཏྭཱ པྲབྷཱཥེ མཡཱ ཡཏ྄ ཀཐྱཏེ ཏད྄ ཡུཥྨཱབྷི ཪྻིཝིཙྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ཡད྄ དྷནྱཝཱདཔཱཏྲམ྄ ཨསྨཱབྷི རྡྷནྱཾ གདྱཏེ ཏཏ྄ ཀིཾ ཁྲཱིཥྚསྱ ཤོཎིཏསྱ སཧབྷཱགིཏྭཾ ནཧི? ཡཤྩ པཱུཔོ྅སྨཱབྷི རྦྷཛྱཏེ ས ཀིཾ ཁྲཱིཥྚསྱ ཝཔུཥཿ སཧབྷཱགིཏྭཾ ནཧི? ");
INSERT INTO santib_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ཝཡཾ བཧཝཿ སནྟོ྅པྱེཀཔཱུཔསྭརཱུཔཱ ཨེཀཝཔུཿསྭརཱུཔཱཤྩ བྷཝཱམཿ, ཡཏོ ཝཡཾ སཪྻྭ ཨེཀཔཱུཔསྱ སཧབྷཱགིནཿ། ");
INSERT INTO santib_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ཡཱུཡཾ ཤཱརཱིརིཀམ྄ ཨིསྲཱཡེལཱིཡཝཾཤཾ ནིརཱིཀྵདྷྭཾ། ཡེ བལཱིནཱཾ མཱཾསཱནི བྷུཉྫཏེ ཏེ ཀིཾ ཡཛྙཝེདྱཱཿ སཧབྷཱགིནོ ན བྷཝནྟི? ");
INSERT INTO santib_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ཨིཏྱནེན མཡཱ ཀིཾ ཀཐྱཏེ? དེཝཏཱ ཝཱསྟཝིཀཱི དེཝཏཱཡཻ བལིདཱནཾ ཝཱ ཝཱསྟཝིཀཾ ཀིཾ བྷཝེཏ྄? ");
INSERT INTO santib_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ཏནྣཧི ཀིནྟུ བྷིནྣཛཱཏིབྷི ཪྻེ བལཡོ དཱིཡནྟེ ཏ ཨཱིཤྭརཱཡ ཏནྣཧི བྷཱུཏེབྷྱཨེཝ དཱིཡནྟེ ཏསྨཱད྄ ཡཱུཡཾ ཡད྄ བྷཱུཏཱནཱཾ སཧབྷཱགིནོ བྷཝཐེཏྱཧཾ ནཱབྷིལཥཱམི། ");
INSERT INTO santib_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","པྲབྷོཿ ཀཾསེན བྷཱུཏཱནཱམཔི ཀཾསེན པཱནཾ ཡུཥྨཱབྷིརསཱདྷྱཾ; ཡཱུཡཾ པྲབྷོ རྦྷོཛྱསྱ བྷཱུཏཱནཱམཔི བྷོཛྱསྱ སཧབྷཱགིནོ བྷཝིཏུཾ ན ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ཝཡཾ ཀིཾ པྲབྷུཾ སྤརྡྡྷིཥྱཱམཧེ? ཝཡཾ ཀིཾ ཏསྨཱད྄ བལཝནྟཿ? ");
INSERT INTO santib_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","མཱཾ པྲཏི སཪྻྭཾ ཀརྨྨཱཔྲཏིཥིདྡྷཾ ཀིནྟུ ན སཪྻྭཾ ཧིཏཛནཀཾ སཪྻྭམ྄ ཨཔྲཏིཥིདྡྷཾ ཀིནྟུ ན སཪྻྭཾ ནིཥྛཱཛནཀཾ། ");
INSERT INTO santib_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ཨཱཏྨཧིཏཿ ཀེནཱཔི ན ཙེཥྚིཏཝྱཿ ཀིནྟུ སཪྻྭཻཿ པརཧིཏཤྩེཥྚིཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ཨཱཔཎེ ཡཏ྄ ཀྲཡྻཾ ཏད྄ ཡུཥྨཱབྷིཿ སཾཝེདསྱཱརྠཾ ཀིམཔི ན པྲྀཥྚྭཱ བྷུཛྱཏཱཾ ");
INSERT INTO santib_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ཡཏཿ པྲྀཐིཝཱི ཏནྨདྷྱསྠཉྩ སཪྻྭཾ པརམེཤྭརསྱ། ");
INSERT INTO santib_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ཨཔརམ྄ ཨཝིཤྭཱསིལོཀཱནཱཾ ཀེནཙིཏ྄ ནིམནྟྲིཏཱ ཡཱུཡཾ ཡདི ཏཏྲ ཛིགམིཥཐ ཏརྷི ཏེན ཡད྄ ཡད྄ ཨུཔསྠཱཔྱཏེ ཏད྄ ཡུཥྨཱབྷིཿ སཾཝེདསྱཱརྠཾ ཀིམཔི ན པྲྀཥྚྭཱ བྷུཛྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ཀིནྟུ ཏཏྲ ཡདི ཀཤྩིད྄ ཡུཥྨཱན྄ ཝདེཏ྄ བྷཀྵྱམེཏད྄ དེཝཏཱཡཱཿ པྲསཱད ཨིཏི ཏརྷི ཏསྱ ཛྙཱཔཡིཏུརནུརོདྷཱཏ྄ སཾཝེདསྱཱརྠཉྩ ཏད྄ ཡུཥྨཱབྷི རྣ བྷོཀྟཝྱཾ། པྲྀཐིཝཱི ཏནྨདྷྱསྠཉྩ སཪྻྭཾ པརམེཤྭརསྱ, ");
INSERT INTO santib_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","སཏྱམེཏཏ྄, ཀིནྟུ མཡཱ ཡཿ སཾཝེདོ ནིརྡྡིཤྱཏེ ས ཏཝ ནཧི པརསྱཻཝ། ");
INSERT INTO santib_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ཨནུགྲཧཔཱཏྲེཎ མཡཱ དྷནྱཝཱདཾ ཀྲྀཏྭཱ ཡད྄ བྷུཛྱཏེ ཏཏྐཱརཎཱད྄ ཨཧཾ ཀུཏོ ནིནྡིཥྱེ? ");
INSERT INTO santib_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ཏསྨཱད྄ བྷོཛནཾ པཱནམ྄ ཨནྱདྭཱ ཀརྨྨ ཀུཪྻྭདྦྷི ཪྻུཥྨཱབྷིཿ སཪྻྭམེཝེཤྭརསྱ མཧིམྣཿ པྲཀཱཤཱརྠཾ ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ཡིཧཱུདཱིཡཱནཱཾ བྷིནྣཛཱཏཱིཡཱནཱམ྄ ཨཱིཤྭརསྱ སམཱཛསྱ ཝཱ ཝིགྷྣཛནཀཻ ཪྻུཥྨཱབྷི རྣ བྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ཨཧམཔྱཱཏྨཧིཏམ྄ ཨཙེཥྚམཱནོ བཧཱུནཱཾ པརིཏྲཱཎཱརྠཾ ཏེཥཱཾ ཧིཏཾ ཙེཥྚམཱནཿ སཪྻྭཝིཥཡེ སཪྻྭེཥཱཾ ཏུཥྚིཀརོ བྷཝཱམཱིཏྱནེནཱཧཾ ཡདྭཏ྄ ཁྲཱིཥྚསྱཱནུགཱམཱི ཏདྭད྄ ཡཱུཡཾ མམཱནུགཱམིནོ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ཧེ བྷྲཱཏརཿ, ཡཱུཡཾ སཪྻྭསྨིན྄ ཀཱཪྻྱེ མཱཾ སྨརཐ མཡཱ ཙ ཡཱདྲྀགུཔདིཥྚཱསྟཱདྲྀགཱཙརཐཻཏཏྐཱརཎཱཏ྄ མཡཱ པྲཤཾསནཱིཡཱ ཨཱདྷྦེ། ");
INSERT INTO santib_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ཏཐཱཔི མམཻཥཱ ཝཱཉྪཱ ཡད྄ ཡཱུཡམིདམ྄ ཨཝགཏཱ བྷཝཐ, ");
INSERT INTO santib_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ཨེཀཻཀསྱ པུརུཥསྱོཏྟམཱངྒསྭརཱུཔཿ ཁྲཱིཥྚཿ, ཡོཥིཏཤྩོཏྟམཱངྒསྭརཱུཔཿ པུམཱན྄, ཁྲཱིཥྚསྱ ཙོཏྟམཱངྒསྭརཱུཔ ཨཱིཤྭརཿ། ");
INSERT INTO santib_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ཨཔརམ྄ ཨཱཙྪཱདིཏོཏྟམཱངྒེན ཡེན པུཾསཱ པྲཱརྠནཱ ཀྲིཡཏ ཨཱིཤྭརཱིཡཝཱཎཱི ཀཐྱཏེ ཝཱ ཏེན སྭཱིཡོཏྟམཱངྒམ྄ ཨཝཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ཨནཱཙྪཱདིཏོཏྟམཱངྒཡཱ ཡཡཱ ཡོཥིཏཱ ཙ པྲཱརྠནཱ ཀྲིཡཏ ཨཱིཤྭརཱིཡཝཱཎཱི ཀཐྱཏེ ཝཱ ཏཡཱཔི སྭཱིཡོཏྟམཱངྒམ྄ ཨཝཛྙཱཡཏེ ཡཏཿ སཱ མུཎྜིཏཤིརཿསདྲྀཤཱ། ");
INSERT INTO santib_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ཨནཱཙྪཱདིཏམསྟཀཱ ཡཱ ཡོཥིཏ྄ ཏསྱཱཿ ཤིརཿ མུཎྜནཱིཡམེཝ ཀིནྟུ ཡོཥིཏཿ ཀེཤཙྪེདནཾ ཤིརོམུཎྜནཾ ཝཱ ཡདི ལཛྫཱཛནཀཾ བྷཝེཏ྄ ཏརྷི ཏཡཱ སྭཤིར ཨཱཙྪཱདྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","པུམཱན྄ ཨཱིཤྭརསྱ པྲཏིམཱུརྟྟིཿ པྲཏིཏེཛཿསྭརཱུཔཤྩ ཏསྨཱཏ྄ ཏེན ཤིརོ ནཱཙྪཱདནཱིཡཾ ཀིནྟུ སཱིམནྟིནཱི པུཾསཿ པྲཏིབིམྦསྭརཱུཔཱ། ");
INSERT INTO santib_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ཡཏོ ཡོཥཱཏཿ པུམཱན྄ ནོདཔཱདི ཀིནྟུ པུཾསོ ཡོཥིད྄ ཨུདཔཱདི། ");
INSERT INTO santib_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ཨདྷིཀནྟུ ཡོཥིཏཿ ཀྲྀཏེ པུཾསཿ སྲྀཥྚི རྣ བབྷཱུཝ ཀིནྟུ པུཾསཿ ཀྲྀཏེ ཡོཥིཏཿ སྲྀཥྚི རྦབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ཨིཏི ཧེཏོ རྡཱུཏཱནཱམ྄ ཨཱདརཱད྄ ཡོཥིཏཱ ཤིརསྱདྷཱིནཏཱསཱུཙཀམ྄ ཨཱཝརཎཾ དྷརྟྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ཏཐཱཔི པྲབྷོ ཪྻིདྷིནཱ པུམཱཾསཾ ཝིནཱ ཡོཥིནྣ ཛཱཡཏེ ཡོཥིཏཉྩ ཝིནཱ པུམཱན྄ ན ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ཡཏོ ཡཐཱ པུཾསོ ཡོཥིད྄ ཨུདཔཱདི ཏཐཱ ཡོཥིཏཿ པུམཱན྄ ཛཱཡཏེ, སཪྻྭཝསྟཱུནི ཙེཤྭརཱད྄ ཨུཏྤདྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ཡུཥྨཱབྷིརེཝཻཏད྄ ཝིཝིཙྱཏཱཾ, ཨནཱཝྲྀཏཡཱ ཡོཥིཏཱ པྲཱརྠནཾ ཀིཾ སུདྲྀཤྱཾ བྷཝེཏ྄? ");
INSERT INTO santib_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","པུརུཥསྱ དཱིརྒྷཀེཤཏྭཾ ཏསྱ ལཛྫཱཛནཀཾ, ཀིནྟུ ཡོཥིཏོ དཱིརྒྷཀེཤཏྭཾ ཏསྱཱ གཽརཝཛནཀཾ ");
INSERT INTO santib_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ཡཏ ཨཱཙྪཱདནཱཡ ཏསྱཻ ཀེཤཱ དཏྟཱ ཨིཏི ཀིཾ ཡུཥྨཱབྷིཿ སྭབྷཱཝཏོ ན ཤིཀྵྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ཨཏྲ ཡདི ཀཤྩིད྄ ཝིཝདིཏུམ྄ ཨིཙྪེཏ྄ ཏརྷྱསྨཱཀམ྄ ཨཱིཤྭརཱིཡསམིཏཱིནཱཉྩ ཏཱདྲྀཤཱི རཱིཏི རྣ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ཡུཥྨཱབྷི རྣ བྷདྲཱཡ ཀིནྟུ ཀུཏྶིཏཱཡ སམཱགམྱཏེ ཏསྨཱད྄ ཨེཏཱནི བྷཱཥམཱཎེན མཡཱ ཡཱུཡཾ ན པྲཤཾསནཱིཡཱཿ། ");
INSERT INTO santib_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","པྲཐམཏཿ སམིཏཽ སམཱགཏཱནཱཾ ཡུཥྨཱཀཾ མདྷྱེ བྷེདཱཿ སནྟཱིཏི ཝཱརྟྟཱ མཡཱ ཤྲཱུཡཏེ ཏནྨདྷྱེ ཀིཉྩིཏ྄ སཏྱཾ མནྱཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ཡཏོ ཧེཏོ ཪྻུཥྨནྨདྷྱེ ཡེ པརཱིཀྵིཏཱསྟེ ཡཏ྄ པྲཀཱཤྱནྟེ ཏདརྠཾ བྷེདཻ རྦྷཝིཏཝྱམེཝ། ");
INSERT INTO santib_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ཨེཀཏྲ སམཱགཏཻ ཪྻུཥྨཱབྷིཿ པྲབྷཱཝཾ བྷེाཛྱཾ བྷུཛྱཏ ཨིཏི ནཧི; ");
INSERT INTO santib_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ཡཏོ བྷོཛནཀཱལེ ཡུཥྨཱཀམེཀཻཀེན སྭཀཱིཡཾ བྷཀྵྱཾ ཏཱུརྞཾ གྲསྱཏེ ཏསྨཱད྄ ཨེཀོ ཛནོ བུབྷུཀྵིཏསྟིཥྛཏི, ཨནྱཤྩ པརིཏྲྀཔྟོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","བྷོཛནཔཱནཱརྠཾ ཡུཥྨཱཀཾ ཀིཾ ཝེཤྨཱནི ན སནྟི? ཡུཥྨཱབྷི ཪྻཱ ཀིམ྄ ཨཱིཤྭརསྱ སམིཏིཾ ཏུཙྪཱིཀྲྀཏྱ དཱིནཱ ལོཀཱ ཨཝཛྙཱཡནྟེ? ཨིཏྱནེན མཡཱ ཀིཾ ཝཀྟཝྱཾ? ཡཱུཡཾ ཀིཾ མཡཱ པྲཤཾསནཱིཡཱཿ? ཨེཏསྨིན྄ ཡཱུཡཾ ན པྲཤཾསནཱིཡཱཿ། ");
INSERT INTO santib_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","པྲབྷུཏོ ཡ ཨུཔདེཤོ མཡཱ ལབྡྷོ ཡུཥྨཱསུ སམརྤིཏཤྩ ས ཨེཥཿ། ");
INSERT INTO santib_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","པརཀརསམརྤཎཀྵཔཱཡཱཾ པྲབྷུ ཪྻཱིཤུཿ པཱུཔམཱདཱཡེཤྭརཾ དྷནྱཾ ཝྱཱཧྲྀཏྱ ཏཾ བྷངྐྟྭཱ བྷཱཥིཏཝཱན྄ ཡུཥྨཱབྷིརེཏད྄ གྲྀཧྱཏཱཾ བྷུཛྱཏཱཉྩ ཏད྄ ཡུཥྨཏྐྲྀཏེ བྷགྣཾ མམ ཤརཱིརཾ; མམ སྨརཎཱརྠཾ ཡུཥྨཱབྷིརེཏཏ྄ ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","པུནཤྩ བྷེཛནཱཏ྄ པརཾ ཏཐཻཝ ཀཾསམ྄ ཨཱདཱཡ ཏེནོཀྟཾ ཀཾསོ྅ཡཾ མམ ཤོཎིཏེན སྠཱཔིཏོ ནཱུཏནནིཡམཿ; ཡཏིཝཱརཾ ཡུཥྨཱབྷིརེཏཏ྄ པཱིཡཏེ ཏཏིཝཱརཾ མམ སྨརཎཱརྠཾ པཱིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ཡཏིཝཱརཾ ཡུཥྨཱབྷིརེཥ པཱུཔོ བྷུཛྱཏེ བྷཱཛནེནཱནེན པཱིཡཏེ ཙ ཏཏིཝཱརཾ པྲབྷོརཱགམནཾ ཡཱཝཏ྄ ཏསྱ མྲྀཏྱུཿ པྲཀཱཤྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ཨཔརཉྩ ཡཿ ཀཤྩིད྄ ཨཡོགྱཏྭེན པྲབྷོརིམཾ པཱུཔམ྄ ཨཤྣཱཏི ཏསྱཱནེན བྷཱཛནེན པིཝཏི ཙ ས པྲབྷོཿ ཀཱཡརུདྷིརཡོ རྡཎྜདཱཡཱི བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ཏསྨཱཏ྄ མཱནཝེནཱགྲ ཨཱཏྨཱན པརཱིཀྵྱ པཤྩཱད྄ ཨེཥ པཱུཔོ བྷུཛྱཏཱཾ ཀཾསེནཱནེན ཙ པཱིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ཡེན ཙཱནརྷཏྭེན བྷུཛྱཏེ པཱིཡཏེ ཙ པྲབྷོཿ ཀཱཡམ྄ ཨཝིམྲྀཤཏཱ ཏེན དཎྜཔྲཱཔྟཡེ བྷུཛྱཏེ པཱིཡཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ཨེཏཏྐཱརཎཱད྄ ཡུཥྨཱཀཾ བྷཱུརིཤོ ལོཀཱ དུརྦྦལཱ རོགིཎཤྩ སནྟི བཧཝཤྩ མཧཱནིདྲཱཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ཨསྨཱབྷི ཪྻདྱཱཏྨཝིཙཱརོ྅ཀཱརིཥྱཏ ཏརྷི དཎྜོ ནཱལཔྶྱཏ; ");
INSERT INTO santib_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ཀིནྟུ ཡདཱསྨཱཀཾ ཝིཙཱརོ བྷཝཏི ཏདཱ ཝཡཾ ཛགཏོ ཛནཻཿ སམཾ ཡད྄ དཎྜཾ ན ལབྷཱམཧེ ཏདརྠཾ པྲབྷུནཱ ཤཱསྟིཾ བྷུཾཛྨཧེ། ");
INSERT INTO santib_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ཧེ མམ བྷྲཱཏརཿ, བྷོཛནཱརྠཾ མིལིཏཱནཱཾ ཡུཥྨཱཀམ྄ ཨེཀེནེཏརོ྅ནུགྲྀཧྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ཡཤྩ བུབྷུཀྵིཏཿ ས སྭགྲྀཧེ བྷུངྐྟཱཾ། དཎྜཔྲཱཔྟཡེ ཡུཥྨཱབྷི རྣ སམཱགམྱཏཱཾ། ཨེཏདྦྷིནྣཾ ཡད྄ ཨཱདེཥྚཝྱཾ ཏད྄ ཡུཥྨཏྶམཱིཔཱགམནཀཱལེ མཡཱདེཀྵྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ཧེ བྷྲཱཏརཿ, ཡཱུཡཾ ཡད྄ ཨཱཏྨིཀཱན྄ དཱཡཱན྄ ཨནཝགཏཱསྟིཥྛཐ ཏདཧཾ ནཱབྷིལཥཱམི། ");
INSERT INTO santib_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","པཱུཪྻྭཾ བྷིནྣཛཱཏཱིཡཱ ཡཱུཡཾ ཡདྭད྄ ཝིནཱིཏཱསྟདྭད྄ ཨཝཱཀྤྲཏིམཱནཱམ྄ ཨནུགཱམིན ཨཱདྷྦམ྄ ཨིཏི ཛཱནཱིཐ། ");
INSERT INTO santib_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ཨིཏི ཧེཏོརཧཾ ཡུཥྨབྷྱཾ ནིཝེདཡཱམི, ཨཱིཤྭརསྱཱཏྨནཱ བྷཱཥམཱཎཿ ཀོ྅པི ཡཱིཤུཾ ཤཔྟ ཨིཏི ན ཝྱཱཧརཏི, པུནཤྩ པཝིཏྲེཎཱཏྨནཱ ཝིནཱིཏཾ ཝིནཱནྱཿ ཀོ྅པི ཡཱིཤུཾ པྲབྷུརིཏི ཝྱཱཧརྟྟུཾ ན ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","དཱཡཱ བཧུཝིདྷཱཿ ཀིནྟྭེཀ ཨཱཏྨཱ ");
INSERT INTO santib_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","པརིཙཪྻྱཱཤྩ བཧུཝིདྷཱཿ ཀིནྟྭེཀཿ པྲབྷུཿ། ");
INSERT INTO santib_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","སཱདྷནཱནི བཧུཝིདྷཱནི ཀིནྟུ སཪྻྭེཥུ སཪྻྭསཱདྷཀ ཨཱིཤྭར ཨེཀཿ། ");
INSERT INTO santib_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ཨེཀཻཀསྨཻ ཏསྱཱཏྨནོ དརྴནཾ པརཧིཏཱརྠཾ དཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ཨེཀསྨཻ ཏེནཱཏྨནཱ ཛྙཱནཝཱཀྱཾ དཱིཡཏེ, ཨནྱསྨཻ ཏེནཻཝཱཏྨནཱདིཥྚཾ ཝིདྱཱཝཱཀྱམ྄, ");
INSERT INTO santib_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ཨནྱསྨཻ ཏེནཻཝཱཏྨནཱ ཝིཤྭཱསཿ, ཨནྱསྨཻ ཏེནཻཝཱཏྨནཱ སྭཱསྠྱདཱནཤཀྟིཿ, ");
INSERT INTO santib_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ཨནྱསྨཻ དུཿསཱདྷྱསཱདྷནཤཀྟིརནྱསྨཻ ཙེཤྭརཱིཡཱདེཤཿ, ཨནྱསྨཻ ཙཱཏིམཱནུཥིཀསྱཱདེཤསྱ ཝིཙཱརསཱམརྠྱམ྄, ཨནྱསྨཻ པརབྷཱཥཱབྷཱཥཎཤཀྟིརནྱསྨཻ ཙ བྷཱཥཱརྠབྷཱཥཎསཱམཪྻཾ དཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ཨེཀེནཱདྭིཏཱིཡེནཱཏྨནཱ ཡཐཱབྷིལཱཥམ྄ ཨེཀཻཀསྨཻ ཛནཱཡཻཀཻཀཾ དཱནཾ ཝིཏརཏཱ ཏཱནི སཪྻྭཱཎི སཱདྷྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","དེཧ ཨེཀཿ སནྣཔི ཡདྭད྄ བཧྭངྒཡུཀྟོ བྷཝཏི, ཏསྱཻཀསྱ ཝཔུཥོ ྅ངྒཱནཱཾ བཧུཏྭེན ཡདྭད྄ ཨེཀཾ ཝཔུ རྦྷཝཏི, ཏདྭཏ྄ ཁྲཱིཥྚཿ། ");
INSERT INTO santib_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ཡཏོ ཧེཏོ ཪྻིཧཱུདིབྷིནྣཛཱཏཱིཡདཱསསྭཏནྟྲཱ ཝཡཾ སཪྻྭེ མཛྫནེནཻཀེནཱཏྨནཻཀདེཧཱིཀྲྀཏཱཿ སཪྻྭེ ཙཻཀཱཏྨབྷུཀྟཱ ཨབྷཝཱམ། ");
INSERT INTO santib_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ཨེཀེནཱངྒེན ཝཔུ རྣ བྷཝཏི ཀིནྟུ བཧུབྷིཿ། ");
INSERT INTO santib_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ཏཏྲ ཙརཎཾ ཡདི ཝདེཏ྄ ནཱཧཾ ཧསྟསྟསྨཱཏ྄ ཤརཱིརསྱ བྷཱགོ ནཱསྨཱིཏི ཏརྷྱནེན ཤརཱིརཱཏ྄ ཏསྱ ཝིཡོགོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ཤྲོཏྲཾ ཝཱ ཡདི ཝདེཏ྄ ནཱཧཾ ནཡནཾ ཏསྨཱཏ྄ ཤརཱིརསྱཱཾཤོ ནཱསྨཱིཏི ཏརྷྱནེན ཤརཱིརཱཏ྄ ཏསྱ ཝིཡོགོ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ཀྲྀཏྶྣཾ ཤརཱིརཾ ཡདི དརྴནེནྡྲིཡཾ བྷཝེཏ྄ ཏརྷི ཤྲཝཎེནྡྲིཡཾ ཀུཏྲ སྠཱསྱཏི? ཏཏ྄ ཀྲྀཏྶྣཾ ཡདི ཝཱ ཤྲཝཎེནྡྲིཡཾ བྷཝེཏ྄ ཏརྷི གྷྲཎེནྡྲིཡཾ ཀུཏྲ སྠཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ཀིནྟྭིདཱནཱིམ྄ ཨཱིཤྭརེཎ ཡཐཱབྷིལཥིཏཾ ཏཐཻཝཱངྒཔྲཏྱངྒཱནཱམ྄ ཨེཀཻཀཾ ཤརཱིརེ སྠཱཔིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ཏཏ྄ ཀྲྀཏྶྣཾ ཡདྱེཀཱངྒརཱུཔི བྷཝེཏ྄ ཏརྷི ཤརཱིརེ ཀུཏྲ སྠཱསྱཏི? ");
INSERT INTO santib_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ཏསྨཱད྄ ཨངྒཱནི བཧཱུནི སནྟི ཤརཱིརཾ ཏྭེཀམེཝ། ");
INSERT INTO santib_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ཨཏཨེཝ ཏྭཡཱ མམ པྲཡོཛནཾ ནཱསྟཱིཏི ཝཱཙཾ པཱཎིཾ ཝདིཏུཾ ནཡནཾ ན ཤཀྣོཏི, ཏཐཱ ཡུཝཱབྷྱཱཾ མམ པྲཡོཛནཾ ནཱསྟཱིཏི མཱུརྡྡྷཱ ཙརཎཽ ཝདིཏུཾ ན ཤཀྣོཏིཿ; ");
INSERT INTO santib_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ཝསྟུཏསྟུ ཝིགྲཧསྱ ཡཱནྱངྒཱནྱསྨཱབྷི རྡུརྦྦལཱནི བུདྷྱནྟེ ཏཱནྱེཝ སཔྲཡོཛནཱནི སནྟི། ");
INSERT INTO santib_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ཡཱནི ཙ ཤརཱིརམདྷྱེ྅ཝམནྱཱནི བུདྷྱཏེ ཏཱནྱསྨཱབྷིརདྷིཀཾ ཤོབྷྱནྟེ། ཡཱནི ཙ ཀུདྲྀཤྱཱནི ཏཱནི སུདྲྀཤྱཏརཱཎི ཀྲིཡནྟེ ");
INSERT INTO santib_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ཀིནྟུ ཡཱནི སྭཡཾ སུདྲྀཤྱཱནི ཏེཥཱཾ ཤོབྷནམ྄ ནིཥྤྲཡོཛནཾ། ");
INSERT INTO santib_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ཤརཱིརམདྷྱེ ཡད྄ བྷེདོ ན བྷཝེཏ྄ ཀིནྟུ སཪྻྭཱཎྱངྒཱནི ཡད྄ ཨཻཀྱབྷཱཝེན སཪྻྭེཥཱཾ ཧིཏཾ ཙིནྟཡནྟི ཏདརྠམ྄ ཨཱིཤྭརེཎཱཔྲདྷཱནམ྄ ཨཱདརཎཱིཡཾ ཀྲྀཏྭཱ ཤརཱིརཾ ཝིརཙིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ཏསྨཱད྄ ཨེཀསྱཱངྒསྱ པཱིཌཱཡཱཾ ཛཱཏཱཡཱཾ སཪྻྭཱཎྱངྒཱནི ཏེན སཧ པཱིཌྱནྟེ, ཨེཀསྱ སམཱདརེ ཛཱཏེ ཙ སཪྻྭཱཎི ཏེན སཧ སཾཧྲྀཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ཡཱུཡཉྩ ཁྲཱིཥྚསྱ ཤརཱིརཾ, ཡུཥྨཱཀམ྄ ཨེཀཻཀཤྩ ཏསྱཻཀཻཀམ྄ ཨངྒཾ། ");
INSERT INTO santib_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ཀེཙིཏ྄ ཀེཙིཏ྄ སམིཏཱཝཱིཤྭརེཎ པྲཐམཏཿ པྲེརིཏཱ དྭིཏཱིཡཏ ཨཱིཤྭརཱིཡཱདེཤཝཀྟཱརསྟྲྀཏཱིཡཏ ཨུཔདེཥྚཱརོ ནིཡུཀྟཱཿ, ཏཏཿ པརཾ ཀེབྷྱོ྅པི ཙིཏྲཀཱཪྻྱསཱདྷནསཱམརྠྱམ྄ ཨནཱམཡཀརཎཤཀྟིརུཔཀྲྀཏཽ ལོཀཤཱསནེ ཝཱ ནཻཔུཎྱཾ ནཱནཱབྷཱཥཱབྷཱཥཎསཱམརྠྱཾ ཝཱ ཏེན ཝྱཏཱརི། ");
INSERT INTO santib_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","སཪྻྭེ ཀིཾ པྲེརིཏཱཿ? སཪྻྭེ ཀིམ྄ ཨཱིཤྭརཱིཡཱདེཤཝཀྟཱརཿ? སཪྻྭེ ཀིམ྄ ཨུཔདེཥྚཱརཿ? སཪྻྭེ ཀིཾ ཙིཏྲཀཱཪྻྱསཱདྷཀཱཿ? ");
INSERT INTO santib_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","སཪྻྭེ ཀིམ྄ ཨནཱམཡཀརཎཤཀྟིཡུཀྟཱཿ? སཪྻྭེ ཀིཾ པརབྷཱཥཱཝཱདིནཿ? སཪྻྭེ ཝཱ ཀིཾ པརབྷཱཥཱརྠཔྲཀཱཤཀཱཿ? ");
INSERT INTO santib_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ཡཱུཡཾ ཤྲེཥྛདཱཡཱན྄ ལབྡྷུཾ ཡཏདྷྭཾ། ཨནེན ཡཱུཡཾ མཡཱ སཪྻྭོཏྟམམཱརྒཾ དརྴཡིཏཝྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","མརྟྱསྭརྒཱིཡཱཎཱཾ བྷཱཥཱ བྷཱཥམཱཎོ྅ཧཾ ཡདི པྲེམཧཱིནོ བྷཝེཡཾ ཏརྷི ཝཱདཀཏཱལསྭརཱུཔོ ནིནཱདཀཱརིབྷེརཱིསྭརཱུཔཤྩ བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ཨཔརཉྩ ཡདྱཧམ྄ ཨཱིཤྭརཱིཡཱདེཤཱཌྷྱཿ སྱཱཾ སཪྻྭཱཎི གུཔྟཝཱཀྱཱནི སཪྻྭཝིདྱཱཉྩ ཛཱནཱིཡཱཾ པཱུརྞཝིཤྭཱསཿ སན྄ ཤཻལཱན྄ སྠཱནཱནྟརཱིཀརྟྟུཾ ཤཀྣུཡཱཉྩ ཀིནྟུ ཡདི པྲེམཧཱིནོ བྷཝེཡཾ ཏརྷྱགཎནཱིཡ ཨེཝ བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ཨཔརཾ ཡདྱཧམ྄ ཨནྣདཱནེན སཪྻྭསྭཾ ཏྱཛེཡཾ དཱཧནཱཡ སྭཤརཱིརཾ སམརྤཡེཡཉྩ ཀིནྟུ ཡདི པྲེམཧཱིནོ བྷཝེཡཾ ཏརྷི ཏཏྶཪྻྭཾ མདརྠཾ ནིཥྥལཾ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","པྲེམ ཙིརསཧིཥྞུ ཧིཏཻཥི ཙ, པྲེམ ནིརྡྭེཥམ྄ ཨཤཋཾ ནིརྒཪྻྭཉྩ། ");
INSERT INTO santib_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ཨཔརཾ ཏཏ྄ ཀུཏྶིཏཾ ནཱཙརཏི, ཨཱཏྨཙེཥྚཱཾ ན ཀུརུཏེ སཧསཱ ན ཀྲུདྷྱཏི པརཱནིཥྚཾ ན ཙིནྟཡཏི, ");
INSERT INTO santib_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ཨདྷརྨྨེ ན ཏུཥྱཏི སཏྱ ཨེཝ སནྟུཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ཏཏ྄ སཪྻྭཾ ཏིཏིཀྵཏེ སཪྻྭཏྲ ཝིཤྭསིཏི སཪྻྭཏྲ བྷདྲཾ པྲཏཱིཀྵཏེ སཪྻྭཾ སཧཏེ ཙ། ");
INSERT INTO santib_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","པྲེམྣོ ལོཔཿ ཀདཱཔི ན བྷཝིཥྱཏི, ཨཱིཤྭརཱིཡཱདེཤཀཐནཾ ལོཔྶྱཏེ པརབྷཱཥཱབྷཱཥཎཾ ནིཝརྟྟིཥྱཏེ ཛྙཱནམཔི ལོཔཾ ཡཱསྱཏི། ");
INSERT INTO santib_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ཡཏོ྅སྨཱཀཾ ཛྙཱནཾ ཁཎྜམཱཏྲམ྄ ཨཱིཤྭརཱིཡཱདེཤཀཐནམཔི ཁཎྜམཱཏྲཾ། ");
INSERT INTO santib_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ཀིནྟྭསྨཱསུ སིདྡྷཏཱཾ གཏེཥུ ཏཱནི ཁཎྜམཱཏྲཱཎི ལོཔཾ ཡཱསྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","བཱལྱཀཱལེ྅ཧཾ བཱལ ཨིཝཱབྷཱཥེ བཱལ ཨིཝཱཙིནྟཡཉྩ ཀིནྟུ ཡཽཝནེ ཛཱཏེ ཏཏྶཪྻྭཾ བཱལྱཱཙརཎཾ པརིཏྱཀྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ཨིདཱནཱིམ྄ ཨབྷྲམདྷྱེནཱསྤཥྚཾ དརྴནམ྄ ཨསྨཱབྷི རླབྷྱཏེ ཀིནྟུ ཏདཱ སཱཀྵཱཏ྄ དརྴནཾ ལཔྶྱཏེ། ཨདྷུནཱ མམ ཛྙཱནམ྄ ཨལྤིཥྛཾ ཀིནྟུ ཏདཱཧཾ ཡཐཱཝགམྱསྟཐཻཝཱཝགཏོ བྷཝིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ཨིདཱནཱིཾ པྲཏྱཡཿ པྲཏྱཱཤཱ པྲེམ ཙ ཏྲཱིཎྱེཏཱནི ཏིཥྛནྟི ཏེཥཱཾ མདྷྱེ ཙ པྲེམ ཤྲེཥྛཾ། ");
INSERT INTO santib_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ཡཱུཡཾ པྲེམཱཙརཎེ པྲཡཏདྷྭམ྄ ཨཱཏྨིཀཱན྄ དཱཡཱནཔི ཝིཤེཥཏ ཨཱིཤྭརཱིཡཱདེཤཀཐནསཱམརྠྱཾ པྲཱཔྟུཾ ཙེཥྚདྷྭཾ། ");
INSERT INTO santib_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ཡོ ཛནཿ པརབྷཱཥཱཾ བྷཱཥཏེ ས མཱནུཥཱན྄ ན སམྦྷཱཥཏེ ཀིནྟྭཱིཤྭརམེཝ ཡཏཿ ཀེནཱཔི ཀིམཔི ན བུདྷྱཏེ ས ཙཱཏྨནཱ ནིགཱུཌྷཝཱཀྱཱནི ཀཐཡཏི; ");
INSERT INTO santib_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ཀིནྟུ ཡོ ཛན ཨཱིཤྭརཱིཡཱདེཤཾ ཀཐཡཏི ས པརེཥཱཾ ནིཥྛཱཡཻ ཧིཏོཔདེཤཱཡ སཱནྟྭནཱཡཻ ཙ བྷཱཥཏེ། ");
INSERT INTO santib_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","པརབྷཱཥཱཝཱདྱཱཏྨན ཨེཝ ནིཥྛཱཾ ཛནཡཏི ཀིནྟྭཱིཤྭརཱིཡཱདེཤཝཱདཱི སམིཏེ རྣིཥྛཱཾ ཛནཡཏི། ");
INSERT INTO santib_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ པརབྷཱཥཱབྷཱཥཎམ྄ ཨིཙྪཱམྱཧཾ ཀིནྟྭཱིཤྭརཱིཡཱདེཤཀཐནམ྄ ཨདྷིཀམཔཱིཙྪཱམི། ཡཏཿ སམིཏེ རྣིཥྛཱཡཻ ཡེན སྭཝཱཀྱཱནཱམ྄ ཨརྠོ ན ཀྲིཡཏེ ཏསྨཱཏ྄ པརབྷཱཥཱཝཱདིཏ ཨཱིཤྭརཱིཡཱདེཤཝཱདཱི ཤྲེཡཱན྄། ");
INSERT INTO santib_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ཧེ བྷྲཱཏརཿ, ཨིདཱནཱིཾ མཡཱ ཡདི ཡུཥྨཏྶམཱིཔཾ གམྱཏེ ཏརྷཱིཤྭརཱིཡདརྴནསྱ ཛྙཱནསྱ ཝེཤྭརཱིཡཱདེཤསྱ ཝཱ ཤིཀྵཱཡཱ ཝཱ ཝཱཀྱཱནི ན བྷཱཥིཏྭཱ པརབྷཱཥཱཾ བྷཱཥམཱཎེན མཡཱ ཡཱུཡཾ ཀིམུཔཀཱརིཥྱདྷྭེ? ");
INSERT INTO santib_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ཨཔརཾ ཝཾཤཱིཝལླཀྱཱདིཥུ ནིཥྤྲཱཎིཥུ ཝཱདྱཡནྟྲེཥུ ཝཱདིཏེཥུ ཡདི ཀྐཎཱ ན ཝིཤིཥྱནྟེ ཏརྷི ཀིཾ ཝཱདྱཾ ཀིཾ ཝཱ གཱནཾ བྷཝཏི ཏཏ྄ ཀེན བོདྡྷུཾ ཤཀྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ཨཔརཾ རཎཏཱུཪྻྱཱ ནིསྭཎོ ཡདྱཝྱཀྟོ བྷཝེཏ྄ ཏརྷི ཡུདྡྷཱཡ ཀཿ སཛྫིཥྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ཏདྭཏ྄ ཛིཧྭཱབྷི ཪྻདི སུགམྱཱ ཝཱཀ྄ ཡུཥྨཱབྷི རྣ གདྱེཏ ཏརྷི ཡད྄ གདྱཏེ ཏཏ྄ ཀེན བྷོཏྶྱཏེ? ཝསྟུཏོ ཡཱུཡཾ དིགཱལཱཔིན ཨིཝ བྷཝིཥྱཐ། ");
INSERT INTO santib_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ཛགཏི ཀཏིཔྲཀཱརཱ ཨུཀྟཡོ ཝིདྱནྟེ? ཏཱསཱམེཀཱཔི ནིརརྠིཀཱ ནཧི; ");
INSERT INTO santib_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ཀིནྟཱུཀྟེརརྠོ ཡདི མཡཱ ན བུདྷྱཏེ ཏརྷྱཧཾ ཝཀྟྲཱ མླེཙྪ ཨིཝ མཾསྱེ ཝཀྟཱཔི མཡཱ མླེཙྪ ཨིཝ མཾསྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ཏསྨཱད྄ ཨཱཏྨིཀདཱཡལིཔྶཝོ ཡཱུཡཾ སམིཏེ རྣིཥྛཱརྠཾ པྲཱཔྟབཧུཝརཱ བྷཝིཏུཾ ཡཏདྷྭཾ, ");
INSERT INTO santib_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ཨཏཨེཝ པརབྷཱཥཱཝཱདཱི ཡད྄ ཨརྠཀརོ྅པི བྷཝེཏ྄ ཏཏ྄ པྲཱརྠཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ཡདྱཧཾ པརབྷཱཥཡཱ པྲརྠནཱཾ ཀུཪྻྱཱཾ ཏརྷི མདཱིཡ ཨཱཏྨཱ པྲཱརྠཡཏེ, ཀིནྟུ མམ བུདྡྷི རྣིཥྥལཱ ཏིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ཨིཏྱནེན ཀིཾ ཀརཎཱིཡཾ? ཨཧམ྄ ཨཱཏྨནཱ པྲཱརྠཡིཥྱེ བུདྡྷྱཱཔི པྲཱརྠཡིཥྱེ; ཨཔརཾ ཨཱཏྨནཱ གཱསྱཱམི བུདྡྷྱཱཔི གཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ཏྭཾ ཡདཱཏྨནཱ དྷནྱཝཱདཾ ཀརོཥི ཏདཱ ཡད྄ ཝདསི ཏད྄ ཡདི ཤིཥྱེནེཝོཔསྠིཏེན ཛནེན ན བུདྡྷྱཏེ ཏརྷི ཏཝ དྷནྱཝཱདསྱཱནྟེ ཏཐཱསྟྭིཏི ཏེན ཝཀྟཾ ཀཐཾ ཤཀྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ཏྭཾ སམྱག྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདསཱིཏི སཏྱཾ ཏཐཱཔི ཏཏྲ པརསྱ ནིཥྛཱ ན བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ཡུཥྨཱཀཾ སཪྻྭེབྷྱོ྅ཧཾ པརབྷཱཥཱབྷཱཥཎེ སམརྠོ྅སྨཱིཏི ཀཱརཎཱད྄ ཨཱིཤྭརཾ དྷནྱཾ ཝདཱམི; ");
INSERT INTO santib_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ཏཐཱཔི སམིཏཽ པརོཔདེཤཱརྠཾ མཡཱ ཀཐིཏཱནི པཉྩ ཝཱཀྱཱནི ཝརཾ ན ཙ ལཀྵཾ པརབྷཱཥཱིཡཱནི ཝཱཀྱཱནི། ");
INSERT INTO santib_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ཧེ བྷྲཱཏརཿ,ཡཱུཡཾ བུདྡྷྱཱ བཱལཀཱཨིཝ མཱ བྷཱུཏ པརནྟུ དུཥྚཏཡཱ ཤིཤཝཨིཝ བྷཱུཏྭཱ བུདྡྷྱཱ སིདྡྷཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ཤཱསྟྲ ཨིདཾ ལིཁིཏམཱསྟེ, ཡཐཱ, ཨིཏྱཝོཙཏ྄ པརེཤོ྅ཧམ྄ ཨཱབྷཱཥིཥྱ ཨིམཱན྄ ཛནཱན྄། བྷཱཥཱབྷིཿ པརཀཱིཡཱབྷི ཪྻཀྟྲཻཤྩ པརདེཤིབྷིཿ། ཏཐཱ མཡཱ ཀྲྀཏེ྅པཱིམེ ན གྲཧཱིཥྱནྟི མདྭཙཿ༎ ");
INSERT INTO santib_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ཨཏཨེཝ ཏཏ྄ པརབྷཱཥཱབྷཱཥཎཾ ཨཝིཤྩཱསིནཿ པྲཏི ཙིཧྣརཱུཔཾ བྷཝཏི ན ཙ ཝིཤྭཱསིནཿ པྲཏི; ཀིནྟྭཱིཤྭརཱིཡཱདེཤཀཐནཾ ནཱཝིཤྭཱསིནཿ པྲཏི ཏད྄ ཝིཤྭཱསིནཿ པྲཏྱེཝ། ");
INSERT INTO santib_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","སམིཏིབྷུཀྟེཥུ སཪྻྭེཥུ ཨེཀསྨིན྄ སྠཱནེ མིལིཏྭཱ པརབྷཱཥཱཾ བྷཱཥམཱཎེཥུ ཡདི ཛྙཱནཱཀཱངྐྵིཎོ྅ཝིཤྭཱསིནོ ཝཱ ཏཏྲཱགཙྪེཡུསྟརྷི ཡུཥྨཱན྄ ཨུནྨཏྟཱན྄ ཀིཾ ན ཝདིཥྱནྟི? ");
INSERT INTO santib_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ཀིནྟུ སཪྻྭེཥྭཱིཤྭརཱིཡཱདེཤཾ པྲཀཱཤཡཏྶུ ཡདྱཝིཤྭཱསཱི ཛྙཱནཱཀཱངྐྵཱི ཝཱ ཀཤྩིཏ྄ ཏཏྲཱགཙྪཏི ཏརྷི སཪྻྭཻརེཝ ཏསྱ པཱཔཛྙཱནཾ པརཱིཀྵཱ ཙ ཛཱཡཏེ, ");
INSERT INTO santib_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ཏཏསྟསྱཱནྟཿཀརཎསྱ གུཔྟཀལྤནཱསུ ཝྱཀྟཱིབྷཱུཏཱསུ སོ྅དྷོམུཁཿ པཏན྄ ཨཱིཤྭརམཱརཱདྷྱ ཡུཥྨནྨདྷྱ ཨཱིཤྭརོ ཝིདྱཏེ ཨིཏི སཏྱཾ ཀཐཱམེཏཱཾ ཀཐཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ཧེ བྷྲཱཏརཿ, སམྨིལིཏཱནཱཾ ཡུཥྨཱཀམ྄ ཨེཀེན གཱིཏམ྄ ཨནྱེནོཔདེཤོ྅ནྱེན པརབྷཱཥཱནྱེན ཨཻཤྭརིཀདརྴནམ྄ ཨནྱེནཱརྠབོདྷཀཾ ཝཱཀྱཾ ལབྷྱཏེ ཀིམེཏཏ྄? སཪྻྭམེཝ པརནིཥྛཱརྠཾ ཡུཥྨཱབྷིཿ ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ཡདི ཀཤྩིད྄ བྷཱཥཱནྟརཾ ཝིཝཀྵཏི ཏརྷྱེཀསྨིན྄ དིནེ དྭིཛནེན ཏྲིཛནེན ཝཱ པརབྷཱाཥཱ ཀཐྱཏཱཾ ཏདདྷིཀཻརྣ ཀཐྱཏཱཾ ཏཻརཔི པཪྻྱཱཡཱནུསཱརཱཏ྄ ཀཐྱཏཱཾ, ཨེཀེན ཙ ཏདརྠོ བོདྷྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ཀིནྟྭརྠཱབྷིདྷཱཡཀཿ ཀོ྅པི ཡདི ན ཝིདྱཏེ ཏརྷི ས སམིཏཽ ཝཱཙཾཡམཿ སྠིཏྭེཤྭརཱཡཱཏྨནེ ཙ ཀཐཱཾ ཀཐཡཏུ། ");
INSERT INTO santib_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ཨཔརཾ དྭཽ ཏྲཡོ ཝེཤྭརཱིཡཱདེཤཝཀྟཱརཿ སྭཾ སྭམཱདེཤཾ ཀཐཡནྟུ ཏདནྱེ ཙ ཏཾ ཝིཙཱརཡནྟུ། ");
INSERT INTO santib_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ཀིནྟུ ཏཏྲཱཔརེཎ ཀེནཙིཏ྄ ཛནེནེཤྭརཱིཡཱདེཤེ ལབྡྷེ པྲཐམེན ཀཐནཱཏ྄ ནིཝརྟྟིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","སཪྻྭེ ཡཏ྄ ཤིཀྵཱཾ སཱནྟྭནཱཉྩ ལབྷནྟེ ཏདརྠཾ ཡཱུཡཾ སཪྻྭེ པཪྻྱཱཡེཎེཤྭརཱིཡཱདེཤཾ ཀཐཡིཏུཾ ཤཀྣུཐ། ");
INSERT INTO santib_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ཨཱིཤྭརཱིཡཱདེཤཝཀྟྲྀཎཱཾ མནཱཾསི ཏེཥཱམ྄ ཨདྷཱིནཱནི བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ཡཏ ཨཱིཤྭརཿ ཀུཤཱསནཛནཀོ ནཧི སུཤཱསནཛནཀ ཨེཝེཏི པཝིཏྲལོཀཱནཱཾ སཪྻྭསམིཏིཥུ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ཨཔརཉྩ ཡུཥྨཱཀཾ ཝནིཏཱཿ སམིཏིཥུ ཏཱུཥྞཱིམྦྷཱུཏཱསྟིཥྛནྟུ ཡཏཿ ཤཱསྟྲལིཁིཏེན ཝིདྷིནཱ ཏཱཿ ཀཐཱཔྲཙཱརཎཱཏ྄ ནིཝཱརིཏཱསྟཱབྷི རྣིགྷྲཱབྷི རྦྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ཨཏསྟཱ ཡདི ཀིམཔི ཛིཛྙཱསནྟེ ཏརྷི གེཧེཥུ པཏཱིན྄ པྲྀཙྪནྟུ ཡཏཿ སམིཏིམདྷྱེ ཡོཥིཏཱཾ ཀཐཱཀཐནཾ ནིནྡནཱིཡཾ། ");
INSERT INTO santib_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ཨཻཤྭརཾ ཝཙཿ ཀིཾ ཡུཥྨཏྟོ ནིརགམཏ? ཀེཝལཾ ཡུཥྨཱན྄ ཝཱ ཏཏ྄ ཀིམ྄ ཨུཔཱགཏཾ? ");
INSERT INTO santib_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ཡཿ ཀཤྩིད྄ ཨཱཏྨཱནམ྄ ཨཱིཤྭརཱིཡཱདེཤཝཀྟཱརམ྄ ཨཱཏྨནཱཝིཥྚཾ ཝཱ མནྱཏེ ས ཡུཥྨཱན྄ པྲཏི མཡཱ ཡད྄ ཡཏ྄ ལིཁྱཏེ ཏཏྤྲབྷུནཱཛྙཱཔིཏམ྄ ཨཱིཏྱུརརཱི ཀརོཏུ། ");
INSERT INTO santib_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ཀིནྟུ ཡཿ ཀཤྩིཏ྄ ཨཛྙོ བྷཝཏི སོ྅ཛྙ ཨེཝ ཏིཥྛཏུ། ");
INSERT INTO santib_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ཨཏཨེཝ ཧེ བྷྲཱཏརཿ, ཡཱུཡམ྄ ཨཱིཤྭརཱིཡཱདེཤཀཐནསཱམརྠྱཾ ལབྡྷུཾ ཡཏདྷྭཾ པརབྷཱཥཱབྷཱཥཎམཔི ཡུཥྨཱབྷི རྣ ནིཝཱཪྻྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","སཪྻྭཀརྨྨཱཎི ཙ ཝིདྷྱནུསཱརཏཿ སུཔརིཔཱཊྱཱ ཀྲིཡནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ཧེ བྷྲཱཏརཿ, ཡཿ སུསཾཝཱདོ མཡཱ ཡུཥྨཏྶམཱིཔེ ནིཝེདིཏོ ཡཱུཡཉྩ ཡཾ གྲྀཧཱིཏཝནྟ ཨཱཤྲིཏཝནྟཤྩ ཏཾ པུན ཪྻུཥྨཱན྄ ཝིཛྙཱཔཡཱམི། ");
INSERT INTO santib_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ཡུཥྨཱཀཾ ཝིཤྭཱསོ ཡདི ཝིཏཐོ ན བྷཝེཏ྄ ཏརྷི སུསཾཝཱདཡུཀྟཱནི མམ ཝཱཀྱཱནི སྨརཏཱཾ ཡུཥྨཱཀཾ ཏེན སུསཾཝཱདེན པརིཏྲཱཎཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ཡཏོ྅ཧཾ ཡད྄ ཡཏ྄ ཛྙཱཔིཏསྟདནུསཱརཱཏ྄ ཡུཥྨཱསུ མུཁྱཱཾ ཡཱཾ ཤིཀྵཱཾ སམཱརྤཡཾ སེཡཾ, ཤཱསྟྲཱནུསཱརཱཏ྄ ཁྲཱིཥྚོ྅སྨཱཀཾ པཱཔམོཙནཱརྠཾ པྲཱཎཱན྄ ཏྱཀྟཝཱན྄, ");
INSERT INTO santib_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ཤྨཤཱནེ སྠཱཔིཏཤྩ ཏྲྀཏཱིཡདིནེ ཤཱསྟྲཱནུསཱརཱཏ྄ པུནརུཏྠཱཔིཏཿ། ");
INSERT INTO santib_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ས ཙཱགྲེ ཀཻཕཻ ཏཏཿ པརཾ དྭཱདཤཤིཥྱེབྷྱོ དརྴནཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ཏཏཿ པརཾ པཉྩཤཏཱདྷིཀསཾཁྱཀེབྷྱོ བྷྲཱཏྲྀབྷྱོ ཡུགཔད྄ དརྴནཾ དཏྟཝཱན྄ ཏེཥཱཾ ཀེཙིཏ྄ མཧཱནིདྲཱཾ གཏཱ བཧུཏརཱཤྩཱདྱཱཔི ཝརྟྟནྟེ། ");
INSERT INTO santib_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ཏདནནྟརཾ ཡཱཀཱུབཱཡ ཏཏྤཤྩཱཏ྄ སཪྻྭེབྷྱཿ པྲེརིཏེབྷྱོ དརྴནཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","སཪྻྭཤེཥེ྅ཀཱལཛཱཏཏུལྱོ ཡོ྅ཧཾ, སོ྅ཧམཔི ཏསྱ དརྴནཾ པྲཱཔྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ཨཱིཤྭརསྱ སམིཏིཾ པྲཏི དཽརཱཏྨྱཱཙརཎཱད྄ ཨཧཾ པྲེརིཏནཱམ དྷརྟྟུམ྄ ཨཡོགྱསྟསྨཱཏ྄ པྲེརིཏཱནཱཾ མདྷྱེ ཀྵུདྲཏམཤྩཱསྨི། ");
INSERT INTO santib_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ཡཱདྲྀཤོ྅སྨི ཏཱདྲྀཤ ཨཱིཤྭརསྱཱནུགྲཧེཎཻཝཱསྨི; ཨཔརཾ མཱཾ པྲཏི ཏསྱཱནུགྲཧོ ནིཥྥལོ ནཱབྷཝཏ྄, ཨནྱེབྷྱཿ སཪྻྭེབྷྱོ མཡཱདྷིཀཿ ཤྲམཿ ཀྲྀཏཿ, ཀིནྟུ ས མཡཱ ཀྲྀཏསྟནྣཧི མཏྶཧཀཱརིཎེཤྭརསྱཱནུགྲཧེཎཻཝ། ");
INSERT INTO santib_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ཨཏཨེཝ མཡཱ བྷཝེཏ྄ ཏཻ ཪྻཱ བྷཝེཏ྄ ཨསྨཱབྷིསྟཱདྲྀཤཱི ཝཱརྟྟཱ གྷོཥྱཏེ སཻཝ ཙ ཡུཥྨཱབྷི ཪྻིཤྭཱསེན གྲྀཧཱིཏཱ། ");
INSERT INTO santib_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","མྲྀཏྱུདཤཱཏཿ ཁྲཱིཥྚ ཨུཏྠཱཔིཏ ཨིཏི ཝཱརྟྟཱ ཡདི ཏམདྷི གྷོཥྱཏེ ཏརྷི མྲྀཏལོཀཱནཱམ྄ ཨུཏྠིཏི རྣཱསྟཱིཏི ཝཱག྄ ཡུཥྨཱཀཾ མདྷྱེ ཀཻཤྩིཏ྄ ཀུཏཿ ཀཐྱཏེ? ");
INSERT INTO santib_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","མྲྀཏཱནཱམ྄ ཨུཏྠིཏི ཪྻདི ན བྷཝེཏ྄ ཏརྷི ཁྲཱིཥྚོ྅པི ནོཏྠཱཔིཏཿ ");
INSERT INTO santib_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ཁྲཱིཥྚཤྩ ཡདྱནུཏྠཱཔིཏཿ སྱཱཏ྄ ཏརྷྱསྨཱཀཾ གྷོཥཎཾ ཝིཏཐཾ ཡུཥྨཱཀཾ ཝིཤྭཱསོ྅པི ཝིཏཐཿ། ");
INSERT INTO santib_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ཝཡཉྩེཤྭརསྱ མྲྀཥཱསཱཀྵིཎོ བྷཝཱམཿ, ཡཏཿ ཁྲཱིཥྚ སྟེནོཏྠཱཔིཏཿ ཨིཏི སཱཀྵྱམ྄ ཨསྨཱབྷིརཱིཤྭརམདྷི དཏྟཾ ཀིནྟུ མྲྀཏཱནཱམུཏྠིཏི ཪྻདི ན བྷཝེཏ྄ ཏརྷི ས ཏེན ནོཏྠཱཔིཏཿ། ");
INSERT INTO santib_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ཡཏོ མྲྀཏཱནཱམུཏྠིཏི ཪྻཏི ན བྷཝེཏ྄ ཏརྷི ཁྲཱིཥྚོ྅པྱུཏྠཱཔིཏཏྭཾ ན གཏཿ། ");
INSERT INTO santib_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ཁྲཱིཥྚསྱ ཡདྱནུཏྠཱཔིཏཿ སྱཱཏ྄ ཏརྷི ཡུཥྨཱཀཾ ཝིཤྭཱསོ ཝིཏཐཿ, ཡཱུཡམ྄ ཨདྱཱཔི སྭཔཱཔེཥུ མགྣཱསྟིཥྛཐ། ");
INSERT INTO santib_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ཨཔརཾ ཁྲཱིཥྚཱཤྲིཏཱ ཡེ མཱནཝཱ མཧཱནིདྲཱཾ གཏཱསྟེ྅པི ནཱཤཾ གཏཱཿ། ");
INSERT INTO santib_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ཁྲཱིཥྚོ ཡདི ཀེཝལམིཧལོཀེ ྅སྨཱཀཾ པྲཏྱཱཤཱབྷཱུམིཿ སྱཱཏ྄ ཏརྷི སཪྻྭམརྟྱེབྷྱོ ཝཡམེཝ དུརྦྷཱགྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ཨིདཱནཱིཾ ཁྲཱིཥྚོ མྲྀཏྱུདཤཱཏ ཨུཏྠཱཔིཏོ མཧཱནིདྲཱགཏཱནཱཾ མདྷྱེ པྲཐམཕལསྭརཱུཔོ ཛཱཏཤྩ། ");
INSERT INTO santib_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ཡཏོ ཡདྭཏ྄ མཱནུཥདྭཱརཱ མྲྀཏྱུཿ པྲཱདུརྦྷཱུཏསྟདྭཏ྄ མཱནུཥདྭཱརཱ མྲྀཏཱནཱཾ པུནརུཏྠིཏིརཔི པྲདུརྦྷཱུཏཱ། ");
INSERT INTO santib_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ཨཱདམཱ ཡཐཱ སཪྻྭེ མརཎཱདྷཱིནཱ ཛཱཏཱསྟཐཱ ཁྲཱིཥྚེན སཪྻྭེ ཛཱིཝཡིཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ཀིནྟྭེཀཻཀེན ཛནེན ནིཛེ ནིཛེ པཪྻྱཱཡ ཨུཏྠཱཏཝྱཾ པྲཐམཏཿ པྲཐམཛཱཏཕལསྭརཱུཔེན ཁྲཱིཥྚེན, དྭིཏཱིཡཏསྟསྱཱགམནསམཡེ ཁྲཱིཥྚསྱ ལོཀཻཿ། ");
INSERT INTO santib_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ཏཏཿ པརམ྄ ཨནྟོ བྷཝིཥྱཏི ཏདཱནཱིཾ ས སཪྻྭཾ ཤཱསནམ྄ ཨདྷིཔཏིཏྭཾ པརཱཀྲམཉྩ ལུཔྟྭཱ སྭཔིཏརཱིཤྭརེ རཱཛཏྭཾ སམརྤཡིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ཡཏཿ ཁྲཱིཥྚསྱ རིཔཝཿ སཪྻྭེ ཡཱཝཏ྄ ཏེན སྭཔཱདཡོརདྷོ ན ནིཔཱཏཡིཥྱནྟེ ཏཱཝཏ྄ ཏེནཻཝ རཱཛཏྭཾ ཀརྟྟཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ཏེན ཝིཛེཏཝྱོ ཡཿ ཤེཥརིཔུཿ ས མྲྀཏྱུརེཝ། ");
INSERT INTO santib_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ལིཁིཏམཱསྟེ སཪྻྭཱཎི ཏསྱ པཱདཡོ ཪྻཤཱིཀྲྀཏཱནི། ཀིནྟུ སཪྻྭཱཎྱེཝ ཏསྱ ཝཤཱིཀྲྀཏཱནཱིཏྱུཀྟེ སཏི སཪྻྭཱཎི ཡེན ཏསྱ ཝཤཱིཀྲྀཏཱནི ས སྭཡཾ ཏསྱ ཝཤཱིབྷཱུཏོ ན ཛཱཏ ཨིཏི ཝྱཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","སཪྻྭེཥུ ཏསྱ ཝཤཱིབྷཱུཏེཥུ སཪྻྭཱཎི ཡེན པུཏྲསྱ ཝཤཱིཀྲྀཏཱནི སྭཡཾ པུཏྲོ྅པི ཏསྱ ཝཤཱིབྷཱུཏོ བྷཝིཥྱཏི ཏཏ ཨཱིཤྭརཿ སཪྻྭེཥུ སཪྻྭ ཨེཝ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ཨཔརཾ པརེཏལོཀཱནཱཾ ཝིནིམཡེན ཡེ མཛྫྱནྟེ ཏཻཿ ཀིཾ ལཔྶྱཏེ? ཡེཥཱཾ པརེཏལོཀཱནཱམ྄ ཨུཏྠིཏིཿ ཀེནཱཔི པྲཀཱརེཎ ན བྷཝིཥྱཏི ཏེཥཱཾ ཝིནིམཡེན ཀུཏོ མཛྫནམཔི ཏཻརངྒཱིཀྲིཡཏེ? ");
INSERT INTO santib_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ཝཡམཔི ཀུཏཿ པྲཏིདཎྜཾ པྲཱཎབྷཱིཏིམ྄ ཨངྒཱིཀུརྨྨཧེ? ");
INSERT INTO santib_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ཨསྨཏྤྲབྷུནཱ ཡཱིཤུཁྲཱིཥྚེན ཡུཥྨཏྟོ མམ ཡཱ ཤླཱགྷཱསྟེ ཏསྱཱཿ ཤཔཐཾ ཀྲྀཏྭཱ ཀཐཡཱམི དིནེ དིནེ྅ཧཾ མྲྀཏྱུཾ གཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ཨིཕིཥནགརེ ཝནྱཔཤུབྷིཿ སཱརྡྡྷཾ ཡདི ལཽཀིཀབྷཱཝཱཏ྄ མཡཱ ཡུདྡྷཾ ཀྲྀཏཾ ཏརྷི ཏེན མམ ཀོ ལཱབྷཿ? མྲྀཏཱནཱམ྄ ཨུཏྠིཏི ཪྻདི ན བྷཝེཏ྄ ཏརྷི, ཀུརྨྨོ བྷོཛནཔཱནེ྅དྱ ཤྭསྟུ མྲྀཏྱུ རྦྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ཨིཏྱནེན དྷརྨྨཱཏ྄ མཱ བྷྲཾཤདྷྭཾ། ཀུསཾསརྒེཎ ལོཀཱནཱཾ སདཱཙཱརོ ཝིནཤྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ཡཱུཡཾ ཡཐོཙིཏཾ སཙཻཏནྱཱསྟིཥྛཏ, པཱཔཾ མཱ ཀུརུདྷྭཾ, ཡཏོ ཡུཥྨཱཀཾ མདྷྱ ཨཱིཤྭརཱིཡཛྙཱནཧཱིནཱཿ ཀེ྅པི ཝིདྱནྟེ ཡུཥྨཱཀཾ ཏྲཔཱཡཻ མཡེདཾ གདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ཨཔརཾ མྲྀཏལོཀཱཿ ཀཐམ྄ ཨུཏྠཱསྱནྟི? ཀཱིདྲྀཤཾ ཝཱ ཤརཱིརཾ ལབྡྷྭཱ པུནརེཥྱནྟཱིཏི ཝཱཀྱཾ ཀཤྩིཏ྄ པྲཀྵྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ཧེ ཨཛྙ ཏྭཡཱ ཡད྄ བཱིཛམ྄ ཨུཔྱཏེ ཏད྄ ཡདི ན མྲིཡེཏ ཏརྷི ན ཛཱིཝཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ཡཡཱ མཱུརྟྟྱཱ ནིརྒནྟཝྱཾ སཱ ཏྭཡཱ ནོཔྱཏེ ཀིནྟུ ཤུཥྐཾ བཱིཛམེཝ; ཏཙྩ གོདྷཱུམཱདཱིནཱཾ ཀིམཔི བཱིཛཾ བྷཝིཏུཾ ཤཀྣོཏི། ");
INSERT INTO santib_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ཨཱིཤྭརེཎེཝ ཡཐཱབྷིལཱཥཾ ཏསྨཻ མཱུརྟྟི རྡཱིཡཏེ, ཨེཀཻཀསྨཻ བཱིཛཱཡ སྭཱ སྭཱ མཱུརྟྟིརེཝ དཱིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","སཪྻྭཱཎི པལལཱནི ནཻཀཝིདྷཱནི སནྟི, མནུཥྱཔཤུཔཀྵིམཏྶྱཱདཱིནཱཾ བྷིནྣརཱུཔཱཎི པལལཱནི སནྟི། ");
INSERT INTO santib_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ཨཔརཾ སྭརྒཱིཡཱ མཱུརྟྟཡཿ པཱརྠིཝཱ མཱུརྟྟཡཤྩ ཝིདྱནྟེ ཀིནྟུ སྭརྒཱིཡཱནཱམ྄ ཨེཀརཱུཔཾ ཏེཛཿ པཱརྠིཝཱནཱཉྩ ཏདནྱརཱུཔཾ ཏེཛོ྅སྟི། ");
INSERT INTO santib_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","སཱུཪྻྱསྱ ཏེཛ ཨེཀཝིདྷཾ ཙནྡྲསྱ ཏེཛསྟདནྱཝིདྷཾ ཏཱརཱཎཱཉྩ ཏེཛོ྅ནྱཝིདྷཾ, ཏཱརཱཎཱཾ མདྷྱེ྅པི ཏེཛསསྟཱརཏམྱཾ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ཏཏྲ ལིཁིཏམཱསྟེ ཡཐཱ, ‘ཨཱདིཔུརུཥ ཨཱདམ྄ ཛཱིཝཏྤྲཱཎཱི བབྷཱུཝ,’ ཀིནྟྭནྟིམ ཨཱདམ྄ (ཁྲཱིཥྚོ) ཛཱིཝནདཱཡཀ ཨཱཏྨཱ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ཡད྄ ཨུཔྱཏེ ཏཏ྄ ཏུཙྪཾ ཡཙྩོཏྠཱསྱཏི ཏད྄ གཽརཝཱནྭིཏཾ; ཡད྄ ཨུཔྱཏེ ཏནྣིརྦྦལཾ ཡཙྩོཏྠཱསྱཏི ཏཏ྄ ཤཀྟིཡུཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ཡཏ྄ ཤརཱིརམ྄ ཨུཔྱཏེ ཏཏ྄ པྲཱཎཱནཱཾ སདྨ, ཡཙྩ ཤརཱིརམ྄ ཨུཏྠཱསྱཏི ཏད྄ ཨཱཏྨནཿ སདྨ། པྲཱཎསདྨསྭརཱུཔཾ ཤརཱིརཾ ཝིདྱཏེ, ཨཱཏྨསདྨསྭརཱུཔམཔི ཤརཱིརཾ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ཏཏྲ ལིཁིཏམཱསྟེ ཡཐཱ, ཨཱདིཔུརུཥ ཨཱདམ྄ ཛཱིཝཏྤྲཱཎཱི བབྷཱུཝ, ཀིནྟྭནྟིམ ཨཱདམ྄ (ཁྲཱིཥྚོ) ཛཱིཝནདཱཡཀ ཨཱཏྨཱ བབྷཱུཝ། ");
INSERT INTO santib_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ཨཱཏྨསདྨ ན པྲཐམཾ ཀིནྟུ པྲཱཎསདྨཻཝ ཏཏྤཤྩཱད྄ ཨཱཏྨསདྨ། ");
INSERT INTO santib_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ཨཱདྱཿ པུརུཥེ མྲྀད ཨུཏྤནྣཏྭཱཏ྄ མྲྀཎྨཡོ དྭིཏཱིཡཤྩ པུརུཥཿ སྭརྒཱད྄ ཨཱགཏཿ པྲབྷུཿ། ");
INSERT INTO santib_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","མྲྀཎྨཡོ ཡཱདྲྀཤ ཨཱསཱིཏ྄ མྲྀཎྨཡཱཿ སཪྻྭེ ཏཱདྲྀཤཱ བྷཝནྟི སྭརྒཱིཡཤྩ ཡཱདྲྀཤོ྅སྟི སྭརྒཱིཡཱཿ སཪྻྭེ ཏཱདྲྀཤཱ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","མྲྀཎྨཡསྱ རཱུཔཾ ཡདྭད྄ ཨསྨཱབྷི རྡྷཱརིཏཾ ཏདྭཏ྄ སྭརྒཱིཡསྱ རཱུཔམཔི དྷཱརཡིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ཧེ བྷྲཱཏརཿ, ཡུཥྨཱན྄ པྲཏི ཝྱཱཧརཱམི, ཨཱིཤྭརསྱ རཱཛྱེ རཀྟམཱཾསཡོརདྷིཀཱརོ བྷཝིཏུཾ ན ཤཀྣོཏི, ཨཀྵཡཏྭེ ཙ ཀྵཡསྱཱདྷིཀཱརོ ན བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","པཤྱཏཱཧཾ ཡུཥྨབྷྱཾ ནིགཱུཌྷཱཾ ཀཐཱཾ ནིཝེདཡཱམི། ");
INSERT INTO santib_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","སཪྻྭཻརསྨཱབྷི རྨཧཱནིདྲཱ ན གམིཥྱཏེ ཀིནྟྭནྟིམདིནེ ཏཱུཪྻྱཱཾ ཝཱདིཏཱཡཱམ྄ ཨེཀསྨིན྄ ཝིཔལེ ནིམིཥཻཀམདྷྱེ སཪྻྭཻ རཱུཔཱནྟརཾ གམིཥྱཏེ, ཡཏསྟཱུརཱི ཝཱདིཥྱཏེ, མྲྀཏལོཀཱཤྩཱཀྵཡཱིབྷཱུཏཱ ཨུཏྠཱསྱནྟི ཝཡཉྩ རཱུཔཱནྟརཾ གམིཥྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ཡཏཿ ཀྵཡཎཱིཡེནཻཏེན ཤརཱིརེཎཱཀྵཡཏྭཾ པརིཧིཏཝྱཾ, མརཎཱདྷཱིནེནཻཏེན དེཧེན ཙཱམརཏྭཾ པརིཧིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ཨེཏསྨིན྄ ཀྵཡཎཱིཡེ ཤརཱིརེ ྅ཀྵཡཏྭཾ གཏེ, ཨེཏསྨན྄ མརཎཱདྷཱིནེ དེཧེ ཙཱམརཏྭཾ གཏེ ཤཱསྟྲེ ལིཁིཏཾ ཝཙནམིདཾ སེཏྶྱཏི, ཡཐཱ, ཛཡེན གྲསྱཏེ མྲྀཏྱུཿ། ");
INSERT INTO santib_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","མྲྀཏྱོ ཏེ ཀཎྚཀཾ ཀུཏྲ པརལོཀ ཛཡཿ ཀྐ ཏེ༎ ");
INSERT INTO santib_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","མྲྀཏྱོཿ ཀཎྚཀཾ པཱཔམེཝ པཱཔསྱ ཙ བལཾ ཝྱཝསྠཱ། ");
INSERT INTO santib_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ཨཱིཤྭརཤྩ དྷནྱོ བྷཝཏུ ཡཏཿ སོ྅སྨཱཀཾ པྲབྷུནཱ ཡཱིཤུཁྲཱིཥྚེནཱསྨཱན྄ ཛཡཡུཀྟཱན྄ ཝིདྷཱཔཡཏི། ");
INSERT INTO santib_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ཨཏོ ཧེ མམ པྲིཡབྷྲཱཏརཿ; ཡཱུཡཾ སུསྠིརཱ ནིཤྩལཱཤྩ བྷཝཏ པྲབྷོཿ སེཝཱཡཱཾ ཡུཥྨཱཀཾ པརིཤྲམོ ནིཥྥལོ ན བྷཝིཥྱཏཱིཏི ཛྙཱཏྭཱ པྲབྷོཿ ཀཱཪྻྱེ སདཱ ཏཏྤརཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","པཝིཏྲལོཀཱནཱཾ ཀྲྀཏེ ཡོ྅རྠསཾགྲཧསྟམདྷི གཱལཱཏཱིཡདེཤསྱ སམཱཛཱ མཡཱ ཡད྄ ཨཱདིཥྚཱསྟད྄ ཡུཥྨཱབྷིརཔི ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","མམཱགམནཀཱལེ ཡད྄ ཨརྠསཾགྲཧོ ན བྷཝེཏ྄ ཏནྣིམིཏྟཾ ཡུཥྨཱཀམེཀཻཀེན སྭསམྤདཱནུསཱརཱཏ྄ སཉྩཡཾ ཀྲྀཏྭཱ སཔྟཱཧསྱ པྲཐམདིཝསེ སྭསམཱིཔེ ཀིཉྩིཏ྄ ནིཀྵིཔྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ཏཏོ མམཱགམནསམཡེ ཡཱུཡཾ ཡཱནེཝ ཝིཤྭཱསྱཱ ཨིཏི ཝེདིཥྱཐ ཏེབྷྱོ྅ཧཾ པཏྲཱཎི དཏྟྭཱ ཡུཥྨཱཀཾ ཏདྡཱནསྱ ཡིརཱུཤཱལམཾ ནཡནཱརྠཾ ཏཱན྄ པྲེཥཡིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ཀིནྟུ ཡདི ཏཏྲ མམཱཔི གམནམ྄ ཨུཙིཏཾ བྷཝེཏ྄ ཏརྷི ཏེ མཡཱ སཧ ཡཱསྱནྟི། ");
INSERT INTO santib_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","སཱམྤྲཏཾ མཱཀིདནིཡཱདེཤམཧཾ པཪྻྱཊཱམི ཏཾ པཪྻྱཊྱ ཡུཥྨཏྶམཱིཔམ྄ ཨཱགམིཥྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ཨནནྟརཾ ཀིཾ ཛཱནཱམི ཡུཥྨཏྶནྣིདྷིམ྄ ཨཝསྠཱསྱེ ཤཱིཏཀཱལམཔི ཡཱཔཡིཥྱཱམི ཙ པཤྩཱཏ྄ མམ ཡཏ྄ སྠཱནཾ གནྟཝྱཾ ཏཏྲཻཝ ཡུཥྨཱབྷིརཧཾ པྲེརཡིཏཝྱཿ། ");
INSERT INTO santib_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ཡཏོ྅ཧཾ ཡཱཏྲཱཀཱལེ ཀྵཎམཱཏྲཾ ཡུཥྨཱན྄ དྲཥྚུཾ ནེཙྪཱམི ཀིནྟུ པྲབྷུ ཪྻདྱནུཛཱནཱིཡཱཏ྄ ཏརྷི ཀིཉྩིད྄ དཱིརྒྷཀཱལཾ ཡུཥྨཏྶམཱིཔེ པྲཝསྟུམ྄ ཨིཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ཏཐཱཔི ནིསྟཱརོཏྶཝཱཏ྄ པརཾ པཉྩཱཤཏྟམདིནཾ ཡཱཝད྄ ཨིཕིཥཔུཪྻྱཱཾ སྠཱསྱཱམི། ");
INSERT INTO santib_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ཡསྨཱད྄ ཨཏྲ ཀཱཪྻྱསཱདྷནཱརྠཾ མམཱནྟིཀེ བྲྀཧད྄ དྭཱརཾ མུཀྟཾ བཧཝོ ཝིཔཀྵཱ ཨཔི ཝིདྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ཏིམཐི ཪྻདི ཡུཥྨཱཀཾ སམཱིཔམ྄ ཨཱགཙྪེཏ྄ ཏརྷི ཡེན ནིརྦྷཡཾ ཡུཥྨནྨདྷྱེ ཝརྟྟེཏ ཏཏྲ ཡུཥྨཱབྷི རྨནོ ནིདྷཱིཡཏཱཾ ཡསྨཱད྄ ཨཧཾ ཡཱདྲྀཀ྄ སོ྅པི ཏཱདྲྀཀ྄ པྲབྷོཿ ཀརྨྨཎེ ཡཏཏེ། ");
INSERT INTO santib_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ཀོ྅པི ཏཾ པྲཏྱནཱདརཾ ན ཀརོཏུ ཀིནྟུ ས མམཱནྟིཀཾ ཡད྄ ཨཱགནྟུཾ ཤཀྣུཡཱཏ྄ ཏདརྠཾ ཡུཥྨཱབྷིཿ སཀུཤལཾ པྲེཥྱཏཱཾ། བྷྲཱཏྲྀབྷིཿ སཱརྡྡྷམཧཾ ཏཾ པྲཏཱིཀྵེ། ");
INSERT INTO santib_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ཨཱཔལླུཾ བྷྲཱཏརམདྷྱཧཾ ནིཝེདཡཱམི བྷྲཱཏྲྀབྷིཿ སཱཀཾ སོ྅པི ཡད྄ ཡུཥྨཱཀཾ སམཱིཔཾ ཝྲཛེཏ྄ ཏདརྠཾ མཡཱ ས པུནཿ པུནཪྻཱཙིཏཿ ཀིནྟྭིདཱནཱིཾ གམནཾ སཪྻྭཐཱ ཏསྨཻ ནཱརོཙཏ, ཨིཏཿཔརཾ སུསམཡཾ པྲཱཔྱ ས གམིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ཡཱུཡཾ ཛཱགྲྀཏ ཝིཤྭཱསེ སུསྠིརཱ བྷཝཏ པཽརུཥཾ པྲཀཱཤཡཏ བལཝནྟོ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ཡུཥྨཱབྷིཿ སཪྻྭཱཎི ཀརྨྨཱཎི པྲེམྣཱ ནིཥྤཱདྱནྟཱཾ། ");
INSERT INTO santib_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ཧེ བྷྲཱཏརཿ, ཨཧཾ ཡུཥྨཱན྄ ཨིདམ྄ ཨབྷིཡཱཙེ སྟིཕཱནསྱ པརིཛནཱ ཨཱཁཱཡཱདེཤསྱ པྲཐམཛཱཏཕལསྭརཱུཔཱཿ, པཝིཏྲལོཀཱནཱཾ པརིཙཪྻྱཱཡཻ ཙ ཏ ཨཱཏྨནོ ནྱཝེདཡན྄ ཨིཏི ཡུཥྨཱབྷི རྫྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ཨཏོ ཡཱུཡམཔི ཏཱདྲྀཤལོཀཱནཱམ྄ ཨསྨཏྶཧཱཡཱནཱཾ ཤྲམཀཱརིཎཱཉྩ སཪྻྭེཥཱཾ ཝཤྱཱ བྷཝཏ། ");
INSERT INTO santib_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","སྟིཕཱནཿ ཕརྟྟཱུནཱཏ ཨཱཁཱཡིཀཤྩ ཡད྄ ཨཏྲཱགམན྄ ཏེནཱཧམ྄ ཨཱནནྡཱམི ཡཏོ ཡུཥྨཱབྷིཪྻཏ྄ ནྱཱུནིཏཾ ཏཏ྄ ཏཻཿ སམྤཱུརིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ཏཻ ཪྻུཥྨཱཀཾ མམ ཙ མནཱཾསྱཱཔྱཱཡིཏཱནི། ཏསྨཱཏ྄ ཏཱདྲྀཤཱ ལོཀཱ ཡུཥྨཱབྷིཿ སམྨནྟཝྱཱཿ། ");
INSERT INTO santib_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ཡུཥྨབྷྱམ྄ ཨཱཤིཡཱདེཤསྠསམཱཛཱནཱཾ ནམསྐྲྀཏིམ྄ ཨཱཀྐིལཔྲིསྐིལླཡོསྟནྨཎྜཔསྠསམིཏེཤྩ བཧུནམསྐྲྀཏིཾ པྲཛཱནཱིཏ། ");
INSERT INTO santib_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","སཪྻྭེ བྷྲཱཏརོ ཡུཥྨཱན྄ ནམསྐུཪྻྭནྟེ། ཡཱུཡཾ པཝིཏྲཙུམྦནེན མིཐོ ནམཏ། ");
INSERT INTO santib_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","པཽལོ྅ཧཾ སྭཀརལིཁིཏཾ ནམསྐྲྀཏིཾ ཡུཥྨཱན྄ ཝེདཡེ། ");
INSERT INTO santib_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ཡདི ཀཤྩིད྄ ཡཱིཤུཁྲཱིཥྚེ ན པྲཱིཡཏེ ཏརྷི ས ཤཱཔགྲསྟོ བྷཝེཏ྄ པྲབྷུརཱཡཱཏི། ");
INSERT INTO santib_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ཨསྨཱཀཾ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱཱནུགྲཧོ ཡུཥྨཱན྄ པྲཏི བྷཱུཡཱཏ྄། ");
INSERT INTO santib_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ཁྲཱིཥྚཾ ཡཱིཤུམ྄ ཨཱཤྲིཏཱན྄ ཡུཥྨཱན྄ པྲཏི མམ པྲེམ ཏིཥྛཏུ། ཨིཏི༎ ");
INSERT INTO santib_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ཨཱིཤྭརསྱེཙྪཡཱ ཡཱིཤུཁྲཱིཥྚསྱ པྲེརིཏཿ པཽལསྟིམཐིརྦྷྲཱཏཱ ཙ དྭཱཝེཏཽ ཀརིནྠནགརསྠཱཡཻ ཨཱིཤྭརཱིཡསམིཏཡ ཨཱཁཱཡཱདེཤསྠེབྷྱཿ སཪྻྭེབྷྱཿ པཝིཏྲལོཀེབྷྱཤྩ པཏྲཾ ལིཁཏཿ། ");
INSERT INTO santib_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ཨསྨཱཀཾ ཏཱཏསྱེཤྭརསྱ པྲབྷོཪྻཱིཤུཁྲཱིཥྚསྱ ཙཱནུགྲཧཿ ཤཱནྟིཤྩ ཡུཥྨཱསུ ཝརྟྟཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ཀྲྀཔཱལུཿ པིཏཱ སཪྻྭསཱནྟྭནཱཀཱརཱིཤྭརཤྩ ཡོ྅སྨཏྤྲབྷོཪྻཱིཤུཁྲཱིཥྚསྱ ཏཱཏ ཨཱིཤྭརཿ ས དྷནྱོ བྷཝཏུ། ");
INSERT INTO santib_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ཡཏོ ཝཡམ྄ ཨཱིཤྭརཱཏ྄ སཱནྟྭནཱཾ པྲཱཔྱ ཏཡཱ སཱནྟྭནཡཱ ཡཏ྄ སཪྻྭཝིདྷཀླིཥྚཱན྄ ལོཀཱན྄ སཱནྟྭཡིཏུཾ ཤཀྣུཡཱམ ཏདརྠཾ སོ྅སྨཱཀཾ སཪྻྭཀླེཤསམཡེ྅སྨཱན྄ སཱནྟྭཡཏི། ");
INSERT INTO santib_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ཡཏཿ ཁྲཱིཥྚསྱ ཀླེཤཱ ཡདྭད྄ བཱཧུལྱེནཱསྨཱསུ ཝརྟྟནྟེ ཏདྭད྄ ཝཡཾ ཁྲཱིཥྚེན བཧུསཱནྟྭནཱཌྷྱཱ ཨཔི བྷཝཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ཝཡཾ ཡདི ཀླིཤྱཱམཧེ ཏརྷི ཡུཥྨཱཀཾ སཱནྟྭནཱཔརིཏྲཱཎཡོཿ ཀྲྀཏེ ཀླིཤྱཱམཧེ ཡཏོ྅སྨཱབྷི ཪྻཱདྲྀཤཱནི དུཿཁཱནི སཧྱནྟེ ཡུཥྨཱཀཾ ཏཱདྲྀཤདུཿཁཱནཱཾ སཧནེན ཏཽ སཱདྷཡིཥྱེཏེ ཨིཏྱསྨིན྄ ཡུཥྨཱནདྷི མམ དྲྀཌྷཱ པྲཏྱཱཤཱ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ཡདི ཝཱ ཝཡཾ སཱནྟྭནཱཾ ལབྷཱམཧེ ཏརྷི ཡུཥྨཱཀཾ སཱནྟྭནཱཔརིཏྲཱཎཡོཿ ཀྲྀཏེ ཏཱམཔི ལབྷཱམཧེ། ཡཏོ ཡཱུཡཾ ཡཱདྲྀག྄ དུཿཁཱནཱཾ བྷཱགིནོ྅བྷཝཏ ཏཱདྲྀཀ྄ སཱནྟྭནཱཡཱ ཨཔི བྷཱགིནོ བྷཝིཥྱཐེཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ཧེ བྷྲཱཏརཿ, ཨཱཤིཡཱདེཤེ ཡཿ ཀླེཤོ྅སྨཱན྄ ཨཱཀྲཱམྱཏ྄ ཏཾ ཡཱུཡཾ ཡད྄ ཨནཝགཏཱསྟིཥྛཏ ཏནྨཡཱ བྷདྲཾ ན མནྱཏེ། ཏེནཱཏིཤཀྟིཀླེཤེན ཝཡམཏཱིཝ པཱིཌིཏཱསྟསྨཱཏ྄ ཛཱིཝནརཀྵཎེ ནིརུཔཱཡཱ ཛཱཏཱཤྩ, ");
INSERT INTO santib_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ཨཏོ ཝཡཾ སྭེཥུ ན ཝིཤྭསྱ མྲྀཏལོཀཱནཱམ྄ ཨུཏྠཱཔཡིཏརཱིཤྭརེ ཡད྄ ཝིཤྭཱསཾ ཀུརྨྨསྟདརྠམ྄ ཨསྨཱབྷིཿ པྲཱཎདཎྜོ བྷོཀྟཝྱ ཨིཏི སྭམནསི ནིཤྩིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ཨེཏཱདྲྀཤབྷཡངྐརཱཏ྄ མྲྀཏྱོ ཪྻོ ྅སྨཱན྄ ཨཏྲཱཡཏེདཱནཱིམཔི ཏྲཱཡཏེ ས ཨིཏཿ པརམཔྱསྨཱན྄ ཏྲཱསྱཏེ ྅སྨཱཀམ྄ ཨེཏཱདྲྀཤཱི པྲཏྱཱཤཱ ཝིདྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ཨེཏདརྠམསྨཏྐྲྀཏེ པྲཱརྠནཡཱ ཝཡཾ ཡུཥྨཱབྷིརུཔཀརྟྟཝྱཱསྟཐཱ ཀྲྀཏེ བཧུབྷི ཪྻཱཙིཏོ ཡོ྅ནུགྲཧོ྅སྨཱསུ ཝརྟྟིཥྱཏེ ཏཏྐྲྀཏེ བཧུབྷིརཱིཤྭརསྱ དྷནྱཝཱདོ྅པི ཀཱརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ཨཔརཉྩ སཾསཱརམདྷྱེ ཝིཤེཥཏོ ཡུཥྨནྨདྷྱེ ཝཡཾ སཱཾསཱརིཀྱཱ དྷིཡཱ ནཧི ཀིནྟྭཱིཤྭརསྱཱནུགྲཧེཎཱཀུཊིལཏཱམ྄ ཨཱིཤྭརཱིཡསཱརལྱཉྩཱཙརིཏཝནྟོ྅ཏྲཱསྨཱཀཾ མནོ ཡཏ྄ པྲམཱཎཾ དདཱཏི ཏེན ཝཡཾ ཤླཱགྷཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ཡུཥྨཱབྷི ཪྻད྄ ཡཏ྄ པཋྱཏེ གྲྀཧྱཏེ ཙ ཏདནྱཏ྄ ཀིམཔི ཡུཥྨབྷྱམ྄ ཨསྨཱབྷི རྣ ལིཁྱཏེ ཏཙྩཱནྟཾ ཡཱཝད྄ ཡུཥྨཱབྷི རྒྲཧཱིཥྱཏ ཨིཏྱསྨཱཀམ྄ ཨཱཤཱ། ");
INSERT INTO santib_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ཡཱུཡམིཏཿ པཱུཪྻྭམཔྱསྨཱན྄ ཨཾཤཏོ གྲྀཧཱིཏཝནྟཿ, ཡཏཿ པྲབྷོ ཪྻཱིཤུཁྲཱིཥྚསྱ དིནེ ཡདྭད྄ ཡུཥྨཱསྭསྨཱཀཾ ཤླཱགྷཱ ཏདྭད྄ ཨསྨཱསུ ཡུཥྨཱཀམཔི ཤླཱགྷཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ཨཔརཾ ཡཱུཡཾ ཡད྄ དྭིཏཱིཡཾ ཝརཾ ལབྷདྷྭེ ཏདརྠམིཏཿ པཱུཪྻྭཾ ཏཡཱ པྲཏྱཱཤཡཱ ཡུཥྨཏྶམཱིཔཾ གམིཥྱཱམི ");
INSERT INTO santib_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ཡུཥྨདྡེཤེན མཱཀིདནིཡཱདེཤཾ ཝྲཛིཏྭཱ པུནསྟསྨཱཏ྄ མཱཀིདནིཡཱདེཤཱཏ྄ ཡུཥྨཏྶམཱིཔམ྄ ཨེཏྱ ཡུཥྨཱབྷི ཪྻིཧཱུདཱདེཤཾ པྲེཥཡིཥྱེ ཙེཏི མམ ཝཱཉྪཱསཱིཏ྄། ");
INSERT INTO santib_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ཨེཏཱདྲྀཤཱི མནྟྲཎཱ མཡཱ ཀིཾ ཙཱཉྩལྱེན ཀྲྀཏཱ? ཡད྄ ཡད྄ ཨཧཾ མནྟྲཡེ ཏཏ྄ ཀིཾ ཝིཥཡིལོཀཨིཝ མནྟྲཡཱཎ ཨཱདཽ སྭཱིཀྲྀཏྱ པཤྩཱད྄ ཨསྭཱིཀུཪྻྭེ? ");
INSERT INTO santib_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ཡུཥྨཱན྄ པྲཏི མཡཱ ཀཐིཏཱནི ཝཱཀྱཱནྱགྲེ སྭཱིཀྲྀཏཱནི ཤེཥེ྅སྭཱིཀྲྀཏཱནི ནཱབྷཝན྄ ཨེཏེནེཤྭརསྱ ཝིཤྭསྟཏཱ པྲཀཱཤཏེ། ");
INSERT INTO santib_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","མཡཱ སིལྭཱནེན ཏིམཐིནཱ ཙེཤྭརསྱ པུཏྲོ ཡོ ཡཱིཤུཁྲཱིཥྚོ ཡུཥྨནྨདྷྱེ གྷོཥིཏཿ ས ཏེན སྭཱིཀྲྀཏཿ པུནརསྭཱིཀྲྀཏཤྩ ཏནྣཧི ཀིནྟུ ས ཏསྱ སྭཱིཀཱརསྭརཱུཔཨེཝ། ");
INSERT INTO santib_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ཨཱིཤྭརསྱ མཧིམཱ ཡད྄ ཨསྨཱབྷིཿ པྲཀཱཤེཏ ཏདརྠམ྄ ཨཱིཤྭརེཎ ཡད྄ ཡཏ྄ པྲཏིཛྙཱཏཾ ཏཏྶཪྻྭཾ ཁྲཱིཥྚེན སྭཱིཀྲྀཏཾ སཏྱཱིབྷཱུཏཉྩ། ");
INSERT INTO santib_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ཡུཥྨཱན྄ ཨསྨཱཾཤྩཱབྷིཥིཙྱ ཡཿ ཁྲཱིཥྚེ སྠཱསྣཱུན྄ ཀརོཏི ས ཨཱིཤྭར ཨེཝ། ");
INSERT INTO santib_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ས ཙཱསྨཱན྄ མུདྲཱངྐིཏཱན྄ ཨཀཱརྵཱིཏ྄ སཏྱཱངྐཱརསྱ པཎཁརཱུཔམ྄ ཨཱཏྨཱནཾ ཨསྨཱཀམ྄ ཨནྟཿཀརཎེཥུ ནིརཀྵིཔཙྩ། ");
INSERT INTO santib_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ཨཔརཾ ཡུཥྨཱསུ ཀརུཎཱཾ ཀུཪྻྭན྄ ཨཧམ྄ ཨེཏཱཝཏྐཱལཾ ཡཱཝཏ྄ ཀརིནྠནགརཾ ན གཏཝཱན྄ ཨིཏི སཏྱམེཏསྨིན྄ ཨཱིཤྭརཾ སཱཀྵིཎཾ ཀྲྀཏྭཱ མཡཱ སྭཔྲཱཎཱནཱཾ ཤཔཐཿ ཀྲིཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ཝཡཾ ཡུཥྨཱཀཾ ཝིཤྭཱསསྱ ནིཡནྟཱརོ ན བྷཝཱམཿ ཀིནྟུ ཡུཥྨཱཀམ྄ ཨཱནནྡསྱ སཧཱཡཱ བྷཝཱམཿ, ཡསྨཱད྄ ཝིཤྭཱསེ ཡུཥྨཱཀཾ སྠིཏི རྦྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ཨཔརཉྩཱཧཾ པུནཿ ཤོཀཱཡ ཡུཥྨཏྶནྣིདྷིཾ ན གམིཥྱཱམཱིཏི མནསི ནིརཙཻཥཾ། ");
INSERT INTO santib_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ཡསྨཱད྄ ཨཧཾ ཡདི ཡུཥྨཱན྄ ཤོཀཡུཀྟཱན྄ ཀརོམི ཏརྷི མཡཱ ཡཿ ཤོཀཡུཀྟཱིཀྲྀཏསྟཾ ཝིནཱ ཀེནཱཔརེཎཱཧཾ ཧརྵཡིཥྱེ? ");
INSERT INTO santib_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","མམ ཡོ ཧརྵཿ ས ཡུཥྨཱཀཾ སཪྻྭེཥཱཾ ཧརྵ ཨེཝེཏི ནིཤྩིཏཾ མཡཱབོདྷི; ཨཏཨེཝ ཡཻརཧཾ ཧརྵཡིཏཝྱསྟཻ རྨདུཔསྠིཏིསམཡེ ཡནྨམ ཤོཀོ ན ཛཱཡེཏ ཏདརྠམེཝ ཡུཥྨབྷྱམ྄ ཨེཏཱདྲྀཤཾ པཏྲཾ མཡཱ ལིཁིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ཝསྟུཏསྟུ བཧུཀླེཤསྱ མནཿཔཱིཌཱཡཱཤྩ སམཡེ྅ཧཾ བཧྭཤྲུཔཱཏེན པཏྲམེཀཾ ལིཁིཏཝཱན྄ ཡུཥྨཱཀཾ ཤོཀཱརྠཾ ཏནྣཧི ཀིནྟུ ཡུཥྨཱསུ མདཱིཡཔྲེམབཱཧུལྱསྱ ཛྙཱཔནཱརྠཾ། ");
INSERT INTO santib_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ཡེནཱཧཾ ཤོཀཡུཀྟཱིཀྲྀཏསྟེན ཀེཝལམཧཾ ཤོཀཡུཀྟཱིཀྲྀཏསྟནྣཧི ཀིནྟྭཾཤཏོ ཡཱུཡཾ སཪྻྭེ྅པི ཡཏོ྅ཧམཏྲ ཀསྨིཾཤྩིད྄ དོཥམཱརོཔཡིཏུཾ ནེཙྪཱམི། ");
INSERT INTO santib_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","བཧཱུནཱཾ ཡཏ྄ ཏརྫྫནཾ ཏེན ཛནེནཱལམྦྷི ཏཏ྄ ཏདརྠཾ པྲཙུརཾ། ");
INSERT INTO santib_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ཨཏཿ ས དུཿཁསཱགརེ ཡནྣ ནིམཛྫཏི ཏདརྠཾ ཡུཥྨཱབྷིཿ ས ཀྵནྟཝྱཿ སཱནྟྭཡིཏཝྱཤྩ། ");
INSERT INTO santib_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ཨིཏི ཧེཏོཿ པྲརྠཡེ྅ཧཾ ཡུཥྨཱབྷིསྟསྨིན྄ དཡཱ ཀྲིཡཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ཡཱུཡཾ སཪྻྭཀརྨྨཎི མམཱདེཤཾ གྲྀཧླཱིཐ ན ཝེཏི པརཱིཀྵིཏུམ྄ ཨཧཾ ཡུཥྨཱན྄ པྲཏི ལིཁིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ཡསྱ ཡོ དོཥོ ཡུཥྨཱབྷིཿ ཀྵམྱཏེ ཏསྱ ས དོཥོ མཡཱཔི ཀྵམྱཏེ ཡཤྩ དོཥོ མཡཱ ཀྵམྱཏེ ས ཡུཥྨཱཀཾ ཀྲྀཏེ ཁྲཱིཥྚསྱ སཱཀྵཱཏ྄ ཀྵམྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ཤཡཏཱནཿ ཀལྤནཱསྨཱབྷིརཛྙཱཏཱ ནཧི, ཨཏོ ཝཡཾ ཡཏ྄ ཏེན ན ཝཉྩྱཱམཧེ ཏདརྠམ྄ ཨསྨཱབྷིཿ སཱཝདྷཱནཻ རྦྷཝིཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ཨཔརཉྩ ཁྲཱིཥྚསྱ སུསཾཝཱདགྷོཥཎཱརྠཾ མཡི ཏྲོཡཱནགརམཱགཏེ པྲབྷོཿ ཀརྨྨཎེ ཙ མདརྠཾ དྭཱརེ མུཀྟེ ");
INSERT INTO santib_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","སཏྱཔི སྭབྷྲཱཏུསྟཱིཏསྱཱཝིདྱམཱནཏྭཱཏ྄ མདཱིཡཱཏྨནཿ ཀཱཔི ཤཱནྟི རྣ བབྷཱུཝ, ཏསྨཱད྄ ཨཧཾ ཏཱན྄ ཝིསརྫྫནཾ ཡཱཙིཏྭཱ མཱཀིདནིཡཱདེཤཾ གནྟུཾ པྲསྠཱནམ྄ ཨཀརཝཾ། ");
INSERT INTO santib_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ཡ ཨཱིཤྭརཿ སཪྻྭདཱ ཁྲཱིཥྚེནཱསྨཱན྄ ཛཡིནཿ ཀརོཏི སཪྻྭཏྲ ཙཱསྨཱབྷིསྟདཱིཡཛྙཱནསྱ གནྡྷཾ པྲཀཱཤཡཏི ས དྷནྱཿ། ");
INSERT INTO santib_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ཡསྨཱད྄ ཡེ ཏྲཱཎཾ ལཔྶྱནྟེ ཡེ ཙ ཝིནཱཤཾ གམིཥྱནྟི ཏཱན྄ པྲཏི ཝཡམ྄ ཨཱིཤྭརེཎ ཁྲཱིཥྚསྱ སཽགནྡྷྱཾ བྷཝཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ཝཡམ྄ ཨེཀེཥཱཾ མྲྀཏྱཝེ མྲྀཏྱུགནྡྷཱ ཨཔརེཥཱཉྩ ཛཱིཝནཱཡ ཛཱིཝནགནྡྷཱ བྷཝཱམཿ, ཀིནྟྭེཏཱདྲྀཤཀརྨྨསཱདྷནེ ཀཿ སམརྠོ྅སྟི? ");
INSERT INTO santib_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ཨནྱེ བཧཝོ ལོཀཱ ཡདྭད྄ ཨཱིཤྭརསྱ ཝཱཀྱཾ མྲྀཥཱཤིཀྵཡཱ མིཤྲཡནྟི ཝཡཾ ཏདྭཏ྄ ཏནྣ མིཤྲཡནྟཿ སརལབྷཱཝེནེཤྭརསྱ སཱཀྵཱད྄ ཨཱིཤྭརསྱཱདེཤཱཏ྄ ཁྲཱིཥྚེན ཀཐཱཾ བྷཱཥཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ཝཡཾ ཀིམ྄ ཨཱཏྨཔྲཤཾསནཾ པུནརཱརབྷཱམཧེ? ཡུཥྨཱན྄ པྲཏི ཡུཥྨཏྟོ ཝཱ པརེཥཱཾ ཀེཥཱཉྩིད྄ ཨིཝཱསྨཱཀམཔི ཀིཾ པྲཤཾསཱཔཏྲེཥུ པྲཡོཛནམ྄ ཨཱསྟེ? ");
INSERT INTO santib_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ཡཱུཡམེཝཱསྨཱཀཾ པྲཤཾསཱཔཏྲཾ ཏཙྩཱསྨཱཀམ྄ ཨནྟཿཀརཎེཥུ ལིཁིཏཾ སཪྻྭམཱནཝཻཤྩ ཛྙེཡཾ པཋནཱིཡཉྩ། ");
INSERT INTO santib_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ཡཏོ ྅སྨཱབྷིཿ སེཝིཏཾ ཁྲཱིཥྚསྱ པཏྲཾ ཡཱུཡཔེཝ, ཏཙྩ ན མསྱཱ ཀིནྟྭམརསྱེཤྭརསྱཱཏྨནཱ ལིཁིཏཾ པཱཥཱཎཔཏྲེཥུ ཏནྣཧི ཀིནྟུ ཀྲཝྱམཡེཥུ ཧྲྀཏྤཏྲེཥུ ལིཁིཏམིཏི སུསྤཥྚཾ། ");
INSERT INTO santib_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ཁྲཱིཥྚེནེཤྭརཾ པྲཏྱསྨཱཀམ྄ ཨཱིདྲྀཤོ དྲྀཌྷཝིཤྭཱསོ ཝིདྱཏེ; ");
INSERT INTO santib_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ཝཡཾ ནིཛགུཎེན ཀིམཔི ཀལྤཡིཏུཾ སམརྠཱ ཨིཏི ནཧི ཀིནྟྭཱིཤྭརཱདསྨཱཀཾ སཱམརྠྱཾ ཛཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ཏེན ཝཡཾ ནཱུཏནནིཡམསྱཱརྠཏོ ྅ཀྵརསཾསྠཱནསྱ ཏནྣཧི ཀིནྟྭཱཏྨན ཨེཝ སེཝནསཱམརྠྱཾ པྲཱཔྟཱཿ། ཨཀྵརསཾསྠཱནཾ མྲྀཏྱུཛནཀཾ ཀིནྟྭཱཏྨཱ ཛཱིཝནདཱཡཀཿ། ");
INSERT INTO santib_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ཨཀྵརཻ ཪྻིལིཁིཏཔཱཥཱཎརཱུཔིཎཱི ཡཱ མྲྀཏྱོཿ སེཝཱ སཱ ཡདཱིདྲྀཀ྄ ཏེཛསྭིནཱི ཛཱཏཱ ཡཏྟསྱཱཙིརསྠཱཡིནསྟེཛསཿ ཀཱརཎཱཏ྄ མཱུསསོ མུཁམ྄ ཨིསྲཱཡེལཱིཡལོཀཻཿ སཾདྲཥྚུཾ ནཱཤཀྱཏ, ");
INSERT INTO santib_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ཏརྷྱཱཏྨནཿ སེཝཱ ཀིཾ ཏཏོ྅པི བཧུཏེཛསྭིནཱི ན བྷཝེཏ྄? ");
INSERT INTO santib_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","དཎྜཛནིཀཱ སེཝཱ ཡདི ཏེཛོཡུཀྟཱ བྷཝེཏ྄ ཏརྷི པུཎྱཛནིཀཱ སེཝཱ ཏཏོ྅དྷིཀཾ བཧུཏེཛོཡུཀྟཱ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ཨུབྷཡོསྟུལནཱཡཱཾ ཀྲྀཏཱཡཱམ྄ ཨེཀསྱཱསྟེཛོ དྭིཏཱིཡཱཡཱཿ པྲཁརཏརེཎ ཏེཛསཱ ཧཱིནཏེཛོ བྷཝཏི། ");
INSERT INTO santib_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ཡསྨཱད྄ ཡཏ྄ ལོཔནཱིཡཾ ཏད྄ ཡདི ཏེཛོཡུཀྟཾ བྷཝེཏ྄ ཏརྷི ཡཏ྄ ཙིརསྠཱཡི ཏད྄ བཧུཏརཏེཛོཡུཀྟམེཝ བྷཝིཥྱཏི། ");
INSERT INTO santib_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ཨཱིདྲྀཤཱིཾ པྲཏྱཱཤཱཾ ལབྡྷྭཱ ཝཡཾ མཧཏཱིཾ པྲགལྦྷཏཱཾ པྲཀཱཤཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ཨིསྲཱཡེལཱིཡལོཀཱ ཡཏ྄ ཏསྱ ལོཔནཱིཡསྱ ཏེཛསཿ ཤེཥཾ ན ཝིལོཀཡེཡུསྟདརྠཾ མཱུསཱ ཡཱདྲྀག྄ ཨཱཝརཎེན སྭམུཁམ྄ ཨཱཙྪཱདཡཏ྄ ཝཡཾ ཏཱདྲྀཀ྄ ན ཀུརྨྨཿ། ");
INSERT INTO santib_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ཏེཥཱཾ མནཱཾསི ཀཋིནཱིབྷཱུཏཱནི ཡཏསྟེཥཱཾ པཋནསམཡེ ས པུརཱཏནོ ནིཡམསྟེནཱཝརཎེནཱདྱཱཔི པྲཙྪནྣསྟིཥྛཏི། ");
INSERT INTO santib_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ཏཙྩ ན དཱུརཱིབྷཝཏི ཡཏཿ ཁྲཱིཥྚེནཻཝ ཏཏ྄ ལུཔྱཏེ། མཱུསསཿ ཤཱསྟྲསྱ པཱཋསམཡེ྅དྱཱཔི ཏེཥཱཾ མནཱཾསི ཏེནཱཝརཎེན པྲཙྪཱདྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ཀིནྟུ པྲབྷུཾ པྲཏི མནསི པརཱཝྲྀཏྟེ ཏད྄ ཨཱཝརཎཾ དཱུརཱིཀཱརིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ཡཿ པྲབྷུཿ ས ཨེཝ ས ཨཱཏྨཱ ཡཏྲ ཙ པྲབྷོརཱཏྨཱ ཏཏྲཻཝ མུཀྟིཿ། ");
INSERT INTO santib_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ཝཡཉྩ སཪྻྭེ྅ནཱཙྪཱདིཏེནཱསྱེན པྲབྷོསྟེཛསཿ པྲཏིབིམྦཾ གྲྀཧླནྟ ཨཱཏྨསྭརཱུཔེཎ པྲབྷུནཱ རཱུཔཱནྟརཱིཀྲྀཏཱ ཝརྡྡྷམཱནཏེཛོཡུཀྟཱཾ ཏཱམེཝ པྲཏིམཱུརྟྟིཾ པྲཱཔྣུམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ཨཔརཉྩ ཝཡཾ ཀརུཎཱབྷཱཛོ བྷཱུཏྭཱ ཡད྄ ཨེཏཏ྄ པརིཙཱརཀཔདམ྄ ཨལབྷཱམཧི ནཱཏྲ ཀླཱམྱཱམཿ, ");
INSERT INTO santib_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ཀིནྟུ ཏྲཔཱཡུཀྟཱནི པྲཙྪནྣཀརྨྨཱཎི ཝིཧཱཡ ཀུཊིལཏཱཙརཎམཀུཪྻྭནྟ ཨཱིཤྭརཱིཡཝཱཀྱཾ མིཐྱཱཝཱཀྱཻརམིཤྲཡནྟཿ སཏྱདྷརྨྨསྱ པྲཀཱཤནེནེཤྭརསྱ སཱཀྵཱཏ྄ སཪྻྭམཱནཝཱནཱཾ སཾཝེདགོཙརེ སྭཱན྄ པྲཤཾསནཱིཡཱན྄ དརྴཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ཨསྨཱབྷི རྒྷོཥིཏཿ སུསཾཝཱདོ ཡདི པྲཙྪནྣཿ; སྱཱཏ྄ ཏརྷི ཡེ ཝིནཾཀྵྱནྟི ཏེཥཱམེཝ དྲྀཥྚིཏཿ ས པྲཙྪནྣཿ; ");
INSERT INTO santib_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ཡཏ ཨཱིཤྭརསྱ པྲཏིམཱུརྟྟི ཪྻཿ ཁྲཱིཥྚསྟསྱ ཏེཛསཿ སུསཾཝཱདསྱ པྲབྷཱ ཡཏ྄ ཏཱན྄ ན དཱིཔཡེཏ྄ ཏདརྠམ྄ ཨིཧ ལོཀསྱ དེཝོ྅ཝིཤྭཱསིནཱཾ ཛྙཱནནཡནམ྄ ཨནྡྷཱིཀྲྀཏཝཱན྄ ཨེཏསྱོདཱཧརཎཾ ཏེ བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ཝཡཾ སྭཱན྄ གྷོཥཡཱམ ཨིཏི ནཧི ཀིནྟུ ཁྲཱིཥྚཾ ཡཱིཤུཾ པྲབྷུམེཝཱསྨཱཾཤྩ ཡཱིཤོཿ ཀྲྀཏེ ཡུཥྨཱཀཾ པརིཙཱརཀཱན྄ གྷོཥཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","ཡ ཨཱིཤྭརོ མདྷྱེཏིམིརཾ པྲབྷཱཾ དཱིཔནཱཡཱདིཤཏ྄ ས ཡཱིཤུཁྲཱིཥྚསྱཱསྱ ཨཱིཤྭརཱིཡཏེཛསོ ཛྙཱནཔྲབྷཱཡཱ ཨུདཡཱརྠམ྄ ཨསྨཱཀམ྄ ཨནྟཿཀརཎེཥུ དཱིཔིཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ཨཔརཾ ཏད྄ དྷནམ྄ ཨསྨཱབྷི རྨྲྀཎྨཡེཥུ བྷཱཛནེཥུ དྷཱཪྻྱཏེ ཡཏཿ སཱདྦྷུཏཱ ཤཀྟི རྣཱསྨཱཀཾ ཀིནྟྭཱིཤྭརསྱཻཝེཏི ཛྙཱཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ཝཡཾ པདེ པདེ པཱིཌྱཱམཧེ ཀིནྟུ ནཱཝསཱིདཱམཿ, ཝཡཾ ཝྱཱཀུལཱཿ སནྟོ྅པི ནིརུཔཱཡཱ ན བྷཝཱམཿ; ");
INSERT INTO santib_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ཝཡཾ པྲདྲཱཝྱམཱནཱ ཨཔི ན ཀླཱམྱཱམཿ, ནིཔཱཏིཏཱ ཨཔི ན ཝིནཤྱཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ཨསྨཱཀཾ ཤརཱིརེ ཁྲཱིཥྚསྱ ཛཱིཝནཾ ཡཏ྄ པྲཀཱཤེཏ ཏདརྠཾ ཏསྨིན྄ ཤརཱིརེ ཡཱིཤོ རྨརཎམཔི དྷཱརཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","ཡཱིཤོ རྫཱིཝནཾ ཡད྄ ཨསྨཱཀཾ མརྟྟྱདེཧེ པྲཀཱཤེཏ ཏདརྠཾ ཛཱིཝནྟོ ཝཡཾ ཡཱིཤོཿ ཀྲྀཏེ ནིཏྱཾ མྲྀཏྱཽ སམརྤྱཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ཨིཏྠཾ ཝཡཾ མྲྀཏྱཱཀྲཱནྟཱ ཡཱུཡཉྩ ཛཱིཝནཱཀྲཱནྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ཝིཤྭཱསཀཱརཎཱདེཝ སམབྷཱཥི མཡཱ ཝཙཿ། ཨིཏི ཡཐཱ ཤཱསྟྲེ ལིཁིཏཾ ཏཐཻཝཱསྨཱབྷིརཔི ཝིཤྭཱསཛནཀམ྄ ཨཱཏྨཱནཾ པྲཱཔྱ ཝིཤྭཱསཿ ཀྲིཡཏེ ཏསྨཱཙྩ ཝཙཱཾསི བྷཱཥྱནྟེ། ");
INSERT INTO santib_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","པྲབྷུ ཪྻཱིཤུ ཪྻེནོཏྠཱཔིཏཿ ས ཡཱིཤུནཱསྨཱནཔྱུཏྠཱཔཡིཥྱཏི ཡུཥྨཱབྷིཿ སཱརྡྡྷཾ སྭསམཱིཔ ཨུཔསྠཱཔཡིཥྱཏི ཙ, ཝཡམ྄ ཨེཏཏ྄ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ཨཏཨེཝ ཡུཥྨཱཀཾ ཧིཏཱཡ སཪྻྭམེཝ བྷཝཏི ཏསྨཱད྄ བཧཱུནཱཾ པྲཙུརཱནུुགྲཧཔྲཱཔྟེ རྦཧུལོཀཱནཱཾ དྷནྱཝཱདེནེཤྭརསྱ མཧིམཱ སམྱཀ྄ པྲཀཱཤིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ཏཏོ ཧེཏོ ཪྻཡཾ ན ཀླཱམྱཱམཿ ཀིནྟུ བཱཧྱཔུརུཥོ ཡདྱཔི ཀྵཱིཡཏེ ཏཐཱཔྱཱནྟརིཀཿ པུརུཥོ དིནེ དིནེ ནཱུཏནཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ཀྵཎམཱཏྲསྠཱཡི ཡདེཏཏ྄ ལགྷིཥྛཾ དུཿཁཾ ཏད྄ ཨཏིབཱཧུལྱེནཱསྨཱཀམ྄ ཨནནྟཀཱལསྠཱཡི གརིཥྛསུཁཾ སཱདྷཡཏི, ");
INSERT INTO santib_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ཡཏོ ཝཡཾ པྲཏྱཀྵཱན྄ ཝིཥཡཱན྄ ཨནུདྡིཤྱཱཔྲཏྱཀྵཱན྄ ཨུདྡིཤཱམཿ། ཡཏོ ཧེཏོཿ པྲཏྱཀྵཝིཥཡཱཿ ཀྵཎམཱཏྲསྠཱཡིནཿ ཀིནྟྭཔྲཏྱཀྵཱ ཨནནྟཀཱལསྠཱཡིནཿ། ");
INSERT INTO santib_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ཨཔརམ྄ ཨསྨཱཀམ྄ ཨེཏསྨིན྄ པཱརྠིཝེ དཱུཥྱརཱུཔེ ཝེཤྨནི ཛཱིརྞེ སཏཱིཤྭརེཎ ནིརྨྨིཏམ྄ ཨཀརཀྲྀཏམ྄ ཨསྨཱཀམ྄ ཨནནྟཀཱལསྠཱཡི ཝེཤྨཻཀཾ སྭརྒེ ཝིདྱཏ ཨིཏི ཝཡཾ ཛཱནཱིམཿ། ");
INSERT INTO santib_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ཡཏོ ཧེཏོརེཏསྨིན྄ ཝེཤྨནི ཏིཥྛནྟོ ཝཡཾ ཏཾ སྭརྒཱིཡཾ ཝཱསཾ པརིདྷཱཏུམ྄ ཨཱཀཱངྐྵྱམཱཎཱ ནིཿཤྭསཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ཏཐཱཔཱིདཱནཱིམཔི ཝཡཾ ཏེན ན ནགྣཱཿ ཀིནྟུ པརིཧིཏཝསནཱ མནྱཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ཨེཏསྨིན྄ དཱུཥྱེ ཏིཥྛནཏོ ཝཡཾ ཀླིཤྱམཱནཱ ནིཿཤྭསཱམཿ, ཡཏོ ཝཡཾ ཝཱསཾ ཏྱཀྟུམ྄ ཨིཙྪཱམསྟནྣཧི ཀིནྟུ ཏཾ དྭིཏཱིཡཾ ཝཱསཾ པརིདྷཱཏུམ྄ ཨིཙྪཱམཿ, ཡཏསྟཐཱ ཀྲྀཏེ ཛཱིཝནེན མརྟྱཾ གྲསིཥྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ཨེཏདརྠཾ ཝཡཾ ཡེན སྲྀཥྚཱཿ ས ཨཱིཤྭར ཨེཝ ས ཙཱསྨབྷྱཾ སཏྱངྐཱརསྱ པཎསྭརཱུཔམ྄ ཨཱཏྨཱནཾ དཏྟཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ཨཏཨེཝ ཝཡཾ སཪྻྭདོཏྶུཀཱ བྷཝཱམཿ ཀིཉྩ ཤརཱིརེ ཡཱཝད྄ ཨསྨཱབྷི རྣྱུཥྱཏེ ཏཱཝཏ྄ པྲབྷུཏོ དཱུརེ པྲོཥྱཏ ཨིཏི ཛཱནཱིམཿ, ");
INSERT INTO santib_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ཡཏོ ཝཡཾ དྲྀཥྚིམཱརྒེ ན ཙརཱམཿ ཀིནྟུ ཝིཤྭཱསམཱརྒེ། ");
INSERT INTO santib_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ཨཔརཉྩ ཤརཱིརཱད྄ དཱུརེ པྲཝསྟུཾ པྲབྷོཿ སནྣིདྷཽ ནིཝསྟུཉྩཱཀཱངྐྵྱམཱཎཱ ཨུཏྶུཀཱ བྷཝཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ཏསྨཱདེཝ ཀཱརཎཱད྄ ཝཡཾ ཏསྱ སནྣིདྷཽ ནིཝསནྟསྟསྨཱད྄ དཱུརེ པྲཝསནྟོ ཝཱ ཏསྨཻ རོཙིཏུཾ ཡཏཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ཡསྨཱཏ྄ ཤརཱིརཱཝསྠཱཡཱམ྄ ཨེཀཻཀེན ཀྲྀཏཱནཱཾ ཀརྨྨཎཱཾ ཤུབྷཱཤུབྷཕལཔྲཱཔྟཡེ སཪྻྭཻསྨཱབྷིཿ ཁྲཱིཥྚསྱ ཝིཙཱརཱསནསམྨུཁ ཨུཔསྠཱཏཝྱཾ། ");
INSERT INTO santib_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ཨཏཨེཝ པྲབྷོ རྦྷཡཱནཀཏྭཾ ཝིཛྙཱཡ ཝཡཾ མནུཛཱན྄ ཨནུནཡཱམཿ ཀིཉྩེཤྭརསྱ གོཙརེ སཔྲཀཱཤཱ བྷཝཱམཿ, ཡུཥྨཱཀཾ སཾཝེདགོཙརེ྅པི སཔྲཀཱཤཱ བྷཝཱམ ཨིཏྱཱཤཾསཱམཧེ། ");
INSERT INTO santib_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ཨནེན ཝཡཾ ཡུཥྨཱཀཾ སནྣིདྷཽ པུནཿ སྭཱན྄ པྲཤཾསཱམ ཨིཏི ནཧི ཀིནྟུ ཡེ མནོ ཝིནཱ མུཁཻཿ ཤླཱགྷནྟེ ཏེབྷྱཿ པྲཏྱུཏྟརདཱནཱཡ ཡཱུཡཾ ཡཐཱསྨཱབྷིཿ ཤླཱགྷིཏུཾ ཤཀྣུཐ ཏཱདྲྀཤམ྄ ཨུཔཱཡཾ ཡུཥྨབྷྱཾ ཝིཏརཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ཡདི ཝཡཾ ཧཏཛྙཱནཱ བྷཝཱམསྟརྷི ཏད྄ ཨཱིཤྭརཱརྠཀཾ ཡདི ཙ སཛྙཱནཱ བྷཝཱམསྟརྷི ཏད྄ ཡུཥྨདརྠཀཾ། ");
INSERT INTO santib_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ཝཡཾ ཁྲཱིཥྚསྱ པྲེམྣཱ སམཱཀྲྀཥྱཱམཧེ ཡཏཿ སཪྻྭེཥཱཾ ཝིནིམཡེན ཡདྱེཀོ ཛནོ྅མྲིཡཏ ཏརྷི ཏེ སཪྻྭེ མྲྀཏཱ ཨིཏྱཱསྨཱབྷི རྦུདྷྱཏེ། ");
INSERT INTO santib_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ཨཔརཉྩ ཡེ ཛཱིཝནྟི ཏེ ཡཏ྄ སྭཱརྠཾ ན ཛཱིཝནྟི ཀིནྟུ ཏེཥཱཾ ཀྲྀཏེ ཡོ ཛནོ མྲྀཏཿ པུནརུཏྠཱཔིཏཤྩ ཏམུདྡིཤྱ ཡཏ྄ ཛཱིཝནྟི ཏདརྠམེཝ ས སཪྻྭེཥཱཾ ཀྲྀཏེ མྲྀཏཝཱན྄། ");
INSERT INTO santib_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ཨཏོ ཧེཏོརིཏཿ པརཾ ཀོ྅པྱསྨཱབྷི རྫཱཏིཏོ ན པྲཏིཛྙཱཏཝྱཿ། ཡདྱཔི པཱུཪྻྭཾ ཁྲཱིཥྚོ ཛཱཏིཏོ྅སྨཱབྷིཿ པྲཏིཛྙཱཏསྟཐཱཔཱིདཱནཱིཾ ཛཱཏིཏཿ པུན རྣ པྲཏིཛྙཱཡཏེ། ");
INSERT INTO santib_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ཀེནཙིཏ྄ ཁྲཱིཥྚ ཨཱཤྲིཏེ ནཱུཏནཱ སྲྀཥྚི རྦྷཝཏི པུརཱཏནཱནི ལུཔྱནྟེ པཤྱ ནིཁིལཱནི ནཝཱིནཱནི བྷཝནྟི། ");
INSERT INTO santib_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","སཪྻྭཉྩཻཏད྄ ཨཱིཤྭརསྱ ཀརྨྨ ཡཏོ ཡཱིཤུཁྲཱིཥྚེན ས ཨེཝཱསྨཱན྄ སྭེན སཱརྡྡྷཾ སཾཧིཏཝཱན྄ སནྡྷཱནསམྦནྡྷཱིཡཱཾ པརིཙཪྻྱཱམ྄ ཨསྨཱསུ སམརྤིཏཝཱཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ཡཏཿ ཨཱིཤྭརཿ ཁྲཱིཥྚམ྄ ཨདྷིཥྛཱཡ ཛགཏོ ཛནཱནཱམ྄ ཨཱགཱཾསི ཏེཥཱམ྄ ཨྲྀཎམིཝ ན གཎཡན྄ སྭེན སཱརྡྡྷཾ ཏཱན྄ སཾཧིཏཝཱན྄ སནྡྷིཝཱརྟྟཱམ྄ ཨསྨཱསུ སམརྤིཏཝཱཾཤྩ། ");
INSERT INTO santib_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ཨཏོ ཝཡཾ ཁྲཱིཥྚསྱ ཝིནིམཡེན དཽཏྱཾ ཀརྨྨ སམྤཱདཡཱམཧེ, ཨཱིཤྭརཤྩཱསྨཱབྷི ཪྻུཥྨཱན྄ ཡཱཡཱཙྱཏེ ཏཏཿ ཁྲཱིཥྚསྱ ཝིནིམཡེན ཝཡཾ ཡུཥྨཱན྄ པྲཱརྠཡཱམཧེ ཡཱུཡམཱིཤྭརེཎ སནྡྷཏྟ། ");
INSERT INTO santib_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ཡཏོ ཝཡཾ ཏེན ཡད྄ ཨཱིཤྭརཱིཡཔུཎྱཾ བྷཝཱམསྟདརྠཾ པཱཔེན སཧ ཡསྱ ཛྙཱཏེཡཾ ནཱསཱིཏ྄ ས ཨེཝ ཏེནཱསྨཱཀཾ ཝིནིམཡེན པཱཔཿ ཀྲྀཏཿ། ");
INSERT INTO santib_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ཏསྱ སཧཱཡཱ ཝཡཾ ཡུཥྨཱན྄ པྲཱརྠཡཱམཧེ, ཨཱིཤྭརསྱཱནུགྲཧོ ཡུཥྨཱབྷི ཪྻྲྀཐཱ ན གྲྀཧྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ཏེནོཀྟམེཏཏ྄, སཾཤྲོཥྱཱམི ཤུབྷེ ཀཱལེ ཏྭདཱིཡཱཾ པྲཱརྠནཱམ྄ ཨཧཾ། ཨུཔཀཱརཾ ཀརིཥྱཱམི པརིཏྲཱཎདིནེ ཏཝ། པཤྱཏཱཡཾ ཤུབྷཀཱལཿ པཤྱཏེདཾ ཏྲཱཎདིནཾ། ");
INSERT INTO santib_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ཨསྨཱཀཾ པརིཙཪྻྱཱ ཡནྣིཥྐལངྐཱ བྷཝེཏ྄ ཏདརྠཾ ཝཡཾ ཀུཏྲཱཔི ཝིགྷྣཾ ན ཛནཡཱམཿ, ");
INSERT INTO santib_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ཀིནྟུ པྲཙུརསཧིཥྞུཏཱ ཀླེཤོ དཻནྱཾ ཝིཔཏ྄ ཏཱཌནཱ ཀཱརཱབནྡྷནཾ ནིཝཱསཧཱིནཏྭཾ པརིཤྲམོ ཛཱགརཎམ྄ ཨུཔཝསནཾ ");
INSERT INTO santib_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ནིརྨྨལཏྭཾ ཛྙཱནཾ མྲྀདུཤཱིལཏཱ ཧིཏཻཥིཏཱ ");
INSERT INTO santib_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","པཝིཏྲ ཨཱཏྨཱ ནིཥྐཔཊཾ པྲེམ སཏྱཱལཱཔ ཨཱིཤྭརཱིཡཤཀྟི ");
INSERT INTO santib_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","རྡཀྵིཎཝཱམཱབྷྱཱཾ ཀརཱབྷྱཱཾ དྷརྨྨཱསྟྲདྷཱརཎཾ ");
INSERT INTO santib_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","མཱནཱཔམཱནཡོརཁྱཱཏིསུཁྱཱཏྱོ རྦྷཱགིཏྭམ྄ ཨེཏཻཿ སཪྻྭཻརཱིཤྭརསྱ པྲཤཾསྱཱན྄ པརིཙཱརཀཱན྄ སྭཱན྄ པྲཀཱཤཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","བྷྲམཀསམཱ ཝཡཾ སཏྱཝཱདིནོ བྷཝཱམཿ, ཨཔརིཙིཏསམཱ ཝཡཾ སུཔརིཙིཏཱ བྷཝཱམཿ, མྲྀཏཀལྤཱ ཝཡཾ ཛཱིཝཱམཿ, དཎྜྱམཱནཱ ཝཡཾ ན ཧནྱཱམཧེ, ");
INSERT INTO santib_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ཤོཀཡུཀྟཱཤྩ ཝཡཾ སདཱནནྡཱམཿ, དརིདྲཱ ཝཡཾ བཧཱུན྄ དྷནིནཿ ཀུརྨྨཿ, ཨཀིཉྩནཱཤྩ ཝཡཾ སཪྻྭཾ དྷཱརཡཱམཿ། ");
INSERT INTO santib_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ཧེ ཀརིནྠིནཿ, ཡུཥྨཱཀཾ པྲཏི མམཱསྱཾ མུཀྟཾ མམཱནྟཿཀརཎཱཉྩ ཝིཀསིཏཾ། ");
INSERT INTO santib_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ཡཱུཡཾ མམཱནྟརེ ན སངྐོཙིཏཱཿ ཀིཉྩ ཡཱུཡམེཝ སངྐོཙིཏཙིཏྟཱཿ། ");
INSERT INTO santib_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ཀིནྟུ མཧྱཾ ནྱཱཡྻཕལདཱནཱརྠཾ ཡུཥྨཱབྷིརཔི ཝིཀསིཏཻ རྦྷཝིཏཝྱམ྄ ཨིཏྱཧཾ ནིཛབཱལཀཱནིཝ ཡུཥྨཱན྄ ཝདཱམི། ");
INSERT INTO santib_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ཨཔརམ྄ ཨཔྲཏྱཡིབྷིཿ སཱརྡྡྷཾ ཡཱུཡམ྄ ཨེཀཡུགེ བདྡྷཱ མཱ བྷཱུཏ, ཡསྨཱད྄ དྷརྨྨཱདྷརྨྨཡོཿ ཀཿ སམྦནྡྷོ྅སྟི? ཏིམིརེཎ སརྡྡྷཾ པྲབྷཱཡཱ ཝཱ ཀཱ ཏུལནཱསྟི? ");
INSERT INTO santib_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","བིལཱིཡཱལདེཝེན སཱཀཾ ཁྲཱིཥྚསྱ ཝཱ ཀཱ སནྡྷིཿ? ཨཝིཤྭཱསིནཱ སཱརྡྡྷཾ ཝཱ ཝིཤྭཱསིལོཀསྱཱཾཤཿ ཀཿ? ");
INSERT INTO santib_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ཨཱིཤྭརསྱ མནྡིརེཎ སཧ ཝཱ དེཝཔྲཏིམཱནཱཾ ཀཱ ཏུལནཱ? ཨམརསྱེཤྭརསྱ མནྡིརཾ ཡཱུཡམེཝ། ཨཱིཤྭརེཎ ཏདུཀྟཾ ཡཐཱ, ཏེཥཱཾ མདྷྱེ྅ཧཾ སྭཱཝཱསཾ ནིདྷཱསྱཱམི ཏེཥཱཾ མདྷྱེ ཙ ཡཱཏཱཡཱཏཾ ཀུཪྻྭན྄ ཏེཥཱམ྄ ཨཱིཤྭརོ བྷཝིཥྱཱམི ཏེ ཙ མལློཀཱ བྷཝིཥྱནྟི། ");
INSERT INTO santib_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ཨཏོ ཧེཏོཿ པརམེཤྭརཿ ཀཐཡཏི ཡཱུཡཾ ཏེཥཱཾ མདྷྱཱད྄ བཧིརྦྷཱུཡ པྲྀཐག྄ བྷཝཏ, ཀིམཔྱམེདྷྱཾ ན སྤྲྀཤཏ; ཏེནཱཧཾ ཡུཥྨཱན྄ གྲཧཱིཥྱཱམི, ");
INSERT INTO santib_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ཡུཥྨཱཀཾ པིཏཱ བྷཝིཥྱཱམི ཙ, ཡཱུཡཉྩ མམ ཀནྱཱཔུཏྲཱ བྷཝིཥྱཐེཏི སཪྻྭཤཀྟིམཏཱ པརམེཤྭརེཎོཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ཨཏཨེཝ ཧེ པྲིཡཏམཱཿ, ཨེཏཱདྲྀཤཱིཿ པྲཏིཛྙཱཿ པྲཱཔྟཻརསྨཱབྷིཿ ཤརཱིརཱཏྨནོཿ སཪྻྭམཱལིནྱམ྄ ཨཔམྲྀཛྱེཤྭརསྱ བྷཀྟྱཱ པཝིཏྲཱཙཱརཿ སཱདྷྱཏཱཾ། ");
INSERT INTO santib_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ཡཱུཡམ྄ ཨསྨཱན྄ གྲྀཧླཱིཏ། ཨསྨཱབྷིཿ ཀསྱཱཔྱནྱཱཡོ ན ཀྲྀཏཿ ཀོ྅པི ན ཝཉྩིཏཿ། ");
INSERT INTO santib_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ཡུཥྨཱན྄ དོཥིཎཿ ཀརྟྟམཧཾ ཝཱཀྱམེཏད྄ ཝདཱམཱིཏི ནཧི ཡུཥྨཱབྷིཿ སཧ ཛཱིཝནཱཡ མརཎཱཡ ཝཱ ཝཡཾ ཡུཥྨཱན྄ སྭཱནྟཿཀརཎཻ རྡྷཱརཡཱམ ཨིཏི པཱུཪྻྭཾ མཡོཀྟཾ། ");
INSERT INTO santib_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ཡུཥྨཱན྄ པྲཏི མམ མཧེཏྶཱཧོ ཛཱཡཏེ ཡུཥྨཱན྄ ཨདྷྱཧཾ བཧུ ཤླཱགྷེ ཙ ཏེན སཪྻྭཀླེཤསམཡེ྅ཧཾ སཱནྟྭནཡཱ པཱུརྞོ ཧརྵེཎ པྲཕུལླིཏཤྩ བྷཝཱམི། ");
INSERT INTO santib_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ཨསྨཱསུ མཱཀིདནིཡཱདེཤམ྄ ཨཱགཏེ