﻿USE sofia;
DROP TABLE IF EXISTS sofia.santha_vpl;
CREATE TABLE santha_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES santha_vpl WRITE;
INSERT INTO santha_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","อิพฺราหีม: สนฺตาโน ทายูทฺ ตสฺย สนฺตาโน ยีศุขฺรีษฺฏสฺตสฺย ปูรฺวฺวปุรุษวํศเศฺรณีฯ ");
INSERT INTO santha_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","อิพฺราหีม: ปุตฺร อิสฺหากฺ ตสฺย ปุโตฺร ยากูพฺ ตสฺย ปุโตฺร ยิหูทาสฺตสฺย ภฺราตรศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ตสฺมาทฺ ยิหูทาตสฺตามโร ครฺเภ เปรเสฺสรเหา ชชฺญาเต, ตสฺย เปรส: ปุโตฺร หิโษฺรณฺ ตสฺย ปุโตฺร 'รามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ตสฺย ปุโตฺร 'มฺมีนาทพฺ ตสฺย ปุโตฺร นหโศนฺ ตสฺย ปุตฺร: สลฺโมนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ตสฺมาทฺ ราหโพ ครฺเภ โพยมฺ ชชฺเญ, ตสฺมาทฺ รูโต ครฺเภ โอเพทฺ ชชฺเญ, ตสฺย ปุโตฺร ยิศย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ตสฺย ปุโตฺร ทายูทฺ ราช: ตสฺมาทฺ มฺฤโตริยสฺย ชายายำ สุเลมานฺ ชชฺเญฯ ");
INSERT INTO santha_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ตสฺย ปุโตฺร ริหพิยามฺ, ตสฺย ปุโตฺร'พิย:, ตสฺย ปุตฺร อาสา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ตสฺย สุโต ยิโหศาผฏฺ ตสฺย สุโต ยิโหราม ตสฺย สุต อุษิย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ตสฺย สุโต โยถมฺ ตสฺย สุต อาหมฺ ตสฺย สุโต หิษฺกิย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ตสฺย สุโต มินศิ:, ตสฺย สุต อาโมนฺ ตสฺย สุโต โยศิย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","พาพิลฺนคเร ปฺรวสนาตฺ ปูรฺวฺวํ ส โยศิโย ยิขนิยํ ตสฺย ภฺราตฺฤํศฺจ ชนยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ตโต พาพิลิ ปฺรวสนกาเล ยิขนิย: ศลฺตีเยลํ ชนยามาส, ตสฺย สุต: สิรุพฺพาวิลฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ตสฺย สุโต 'โพหุทฺ ตสฺย สุต อิลียากีมฺ ตสฺย สุโต'โสรฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","อโสร: สุต: สาโทกฺ ตสฺย สุต อาขีมฺ ตสฺย สุต อิลีหูทฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ตสฺย สุต อิลิยาสรฺ ตสฺย สุโต มตฺตนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ตสฺย สุโต ยากูพฺ ตสฺย สุโต ยูษผฺ ตสฺย ชายา มริยมฺ; ตสฺย ครฺเภ ยีศุรชนิ, ตเมว ขฺรีษฺฏมฺ (อรฺถาทฺ อภิษิกฺตํ) วทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","อิตฺถมฺ อิพฺราหีโม ทายูทํ ยาวตฺ สากเลฺยน จตุรฺทศปุรุษา:; อา ทายูท: กาลาทฺ พาพิลิ ปฺรวสนกาลํ ยาวตฺ จตุรฺทศปุรุษา ภวนฺติฯ พาพิลิ ปฺรวาสนกาลาตฺ ขฺรีษฺฏสฺย กาลํ ยาวตฺ จตุรฺทศปุรุษา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ยีศุขฺรีษฺฏสฺย ชนฺม กถฺถเตฯ มริยมฺ นามิกา กนฺยา ยูษเผ วาคฺทตฺตาสีตฺ, ตทา ตโย: สงฺคมาตฺ ปฺรากฺ สา กนฺยา  ปวิเตฺรณาตฺมนา ครฺภวตี พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ตตฺร ตสฺยา: ปติ รฺยูษผฺ เสาชนฺยาตฺ ตสฺยา: กลงฺคํ ปฺรกาศยิตุมฺ อนิจฺฉนฺ โคปเนเน ตำ ปาริตฺยกฺตุํ มนศฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ส ตไถว ภาวยติ, ตทานีํ ปรเมศฺวรสฺย ทูต: สฺวปฺเน ตํ ทรฺศนํ ทตฺตฺวา วฺยาชหาร, เห ทายูท: สนฺตาน ยูษผฺ ตฺวํ นิชำ ชายำ มริยมมฺ อาทาตุํ มา ไภษี:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ยตสฺตสฺยา ครฺภ: ปวิตฺราทาตฺมโน'ภวตฺ, สา จ ปุตฺรํ ปฺรสวิษฺยเต, ตทา ตฺวํ ตสฺย นาม ยีศุมฺ (อรฺถาตฺ ตฺราตารํ) กรีษฺยเส, ยสฺมาตฺ ส นิชมนุชานฺ เตษำ กลุเษภฺย อุทฺธริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","อิตฺถํ สติ, ปศฺย ครฺภวตี กนฺยา ตนยํ ปฺรสวิษฺยเตฯ อิมฺมานูเยลฺ ตทียญฺจ นามเธยํ ภวิษฺยติ๚ อิมฺมานูเยลฺ อสฺมากํ สงฺคีศฺวรอิตฺยรฺถ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","อิติ ยทฺ วจนํ ปุรฺวฺวํ ภวิษฺยทฺวกฺตฺรา อีศฺวร: กถายามาส, ตตฺ ตทานีํ สิทฺธมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","อนนฺตรํ ยูษผฺ นิทฺราโต ชาคริต อุตฺถาย ปรเมศฺวรียทูตสฺย นิเทศานุสาเรณ นิชำ ชายำ ชคฺราห, ");
INSERT INTO santha_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","กินฺตุ ยาวตฺ สา นิชํ ปฺรถมสุตํ อ สุษุเว, ตาวตฺ ตำ โนปาคจฺฉตฺ, ตต: สุตสฺย นาม ยีศุํ จเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","อนนฺตรํ เหโรทฺ สํชฺญเก ราชฺญิ ราชฺยํ ศาสติ ยิหูทียเทศสฺย ไพเตฺลหมิ นคเร ยีเศา ชาตวติ จ, กติปยา โชฺยติรฺวฺวุท: ปูรฺวฺวสฺยา ทิโศ ยิรูศาลมฺนครํ สเมตฺย กถยมาสุ:, ");
INSERT INTO santha_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","โย ยิหูทียานำ ราชา ชาตวานฺ, ส กุตฺราเสฺต? วยํ ปูรฺวฺวสฺยำ ทิศิ ติษฺฐนฺตสฺตทียำ ตารกามฺ อปศฺยาม ตสฺมาตฺ ตํ ปฺรณนฺตุมฺ อाคมามฯ ");
INSERT INTO santha_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ตทา เหโรทฺ ราชา กถาเมตำ นิศมฺย ยิรูศาลมฺนครสฺถิไต: สรฺวฺวมานไว: สารฺทฺธมฺ อุทฺวิชฺย ");
INSERT INTO santha_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","สรฺวฺวานฺ ปฺรธานยาชกานฺ อธฺยาปกำศฺจ สมาหูยานีย ปปฺรจฺฉ, ขฺรีษฺฏ: กุตฺร ชนิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ตทา เต กถยามาสุ:, ยิหูทียเทศสฺย ไพเตฺลหมิ นคเร, ยโต ภวิษฺยทฺวาทินา อิตฺถํ ลิขิตมาเสฺต, ");
INSERT INTO santha_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","สรฺวฺวาโภฺย ราชธานีโภฺย ยิหูทียสฺย นีวฺฤต:ฯ เห ยีหูทียเทศเสฺย ไพเตฺลหมฺ ตฺวํ น จาวราฯ อิสฺราเยลียโลกานฺ เม ยโต ย: ปาลยิษฺยติฯ ตาทฺฤเคโก มหาราชสฺตฺวนฺมธฺย อุทฺภวิษฺยตี๚ ");
INSERT INTO santha_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ตทานีํ เหโรทฺ ราชา ตานฺ โชฺยติรฺวฺวิโท โคปนมฺ อาหูย สา ตารกา กทา ทฺฤษฺฏาภวตฺ , ตทฺ วินิศฺจยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","อปรํ ตานฺ ไพเตฺลหมํ ปฺรหีตฺย คทิตวานฺ, ยูยํ ยาต, ยตฺนาตฺ ตํ ศิศุมฺ อนฺวิษฺย ตทุทฺเทเศ ปฺราปฺเต มหฺยํ วารฺตฺตำ ทาสฺยถ, ตโต มยาปิ คตฺวา ส ปฺรณํสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ตทานีํ ราชฺญ เอตาทฺฤศีมฺ อาชฺญำ ปฺราปฺย เต ปฺรตสฺถิเร, ตต: ปูรฺวฺวรฺสฺยำ ทิศิ สฺถิไตไสฺต รฺยา ตารกา ทฺฤษฺฏา สา ตารกา เตษามเคฺร คตฺวา ยตฺร สฺถาเน ศิศูราเสฺต, ตสฺย สฺถานโสฺยปริ สฺถคิตา ตเสฺยาฯ ");
INSERT INTO santha_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ตทฺ ทฺฤษฺฏฺวา เต มหานนฺทิตา พภูวุ:, ");
INSERT INTO santha_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ตโต เคหมธฺย ปฺรวิศฺย ตสฺย มาตฺรา มริยมา สาทฺธํ ตํ ศิศุํ นิรีกฺษย ทณฺฑวทฺ ภูตฺวา ปฺรเณมุ:, อปรํ เสฺวษำ ฆนสมฺปตฺตึ โมจยิตฺวา สุวรฺณํ กุนฺทุรุํ คนฺธรมญฺจ ตไสฺม ทรฺศนียํ ทตฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ปศฺจาทฺ เหโรทฺ ราชสฺย สมีปํ ปุนรปิ คนฺตุํ สฺวปฺน อีศฺวเรณ นิษิทฺธา: สนฺโต 'เนฺยน ปถา เต นิชเทศํ ปฺรติ ปฺรตสฺถิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","อนนฺตรํ เตษุ คตวตฺมุ ปรเมศฺวรสฺย ทูโต ยูษเผ สฺวปฺเน ทรฺศนํ ทตฺวา ชคาท, ตฺวมฺ อุตฺถาย ศิศุํ ตนฺมาตรญฺจ คฺฤหีตฺวา มิสรฺเทศํ ปลายสฺว, อปรํ ยาวทหํ ตุภฺยํ วารฺตฺตำ น กถยิษฺยามิ, ตาวตฺ ตไตฺรว นิวส, ยโต ราชา เหโรทฺ ศิศุํ นาศยิตุํ มฺฤคยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ตทานีํ ยูษผฺ อุตฺถาย รชนฺยำ ศิศุํ ตนฺมาตรญฺจ คฺฤหีตฺวา มิสรฺเทศํ ปฺรติ ปฺรตเสฺถ, ");
INSERT INTO santha_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","คตฺวา จ เหโรโท นฺฤปเต รฺมรณปรฺยฺยนฺตํ ตตฺร เทเศ นฺยุวาส, เตน มิสรฺเทศาทหํ ปุตฺรํ สฺวกียํ สมุปาหูยมฺฯ ยเทตทฺวจนมฺ อีศฺวเรณ ภวิษฺยทฺวาทินา กถิตํ ตตฺ สผลมภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","อนนฺตรํ เหโรทฺ โชฺยติรฺวิทฺภิราตฺมานํ ปฺรวญฺจิตํ วิชฺญาย ภฺฤศํ จุโกป; อปรํ โชฺยติรฺวฺวิทฺภฺยเสฺตน วินิศฺจิตํ ยทฺ ทินํ ตทฺทินาทฺ คณยิตฺวา ทฺวิตียวตฺสรํ ปฺรวิษฺฏา ยาวนฺโต พาลกา อสฺมินฺ ไพเตฺลหมฺนคเร ตตฺสีมมเธฺย จาสนฺ, โลกานฺ ปฺรหิตฺย ตานฺ สรฺวฺวานฺ ฆาตยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","อต: อเนกสฺย วิลาปสฺย นินาท: กฺรนฺทนสฺย จฯ โศเกน กฺฤตศพฺทศฺจ รามายำ สํนิศมฺยเตฯ สฺวพาลคณเหโตไรฺว ราเหลฺ นารี ตุ โรทินีฯ น มนฺยเต ปฺรโพธนฺตุ ยตเสฺต ไนว มนฺติ หิ๚ ");
INSERT INTO santha_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ยเทตทฺ วจนํ ยิรีมิยนามกภวิษฺยทฺวาทินา กถิตํ ตตฺ ตทานีํ สผลมฺ อภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ตทนนฺตรํ เหเรทิ ราชนิ มฺฤเต ปรเมศฺวรสฺย ทูโต มิสรฺเทเศ สฺวปฺเน ทรฺศนํ ทตฺตฺวา ยูษเผ กถิตวานฺ ");
INSERT INTO santha_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ตฺวมฺ อุตฺถาย ศิศุํ ตนฺมาตรญฺจ คฺฤหีตฺวา ปุนรปีสฺราเยโล เทศํ ยาหี, เย ชนา: ศิศุํ นาศยิตุมฺ อมฺฤคยนฺต, เต มฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ตทานีํ ส อุตฺถาย ศิศุํ ตนฺมาตรญฺจ คฺฤหฺลนฺ อิสฺราเยลฺเทศมฺ อาชคามฯ ");
INSERT INTO santha_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","กินฺตุ ยิหูทียเทเศ อรฺขิลายนาม ราชกุมาโร นิชปิตุ เรฺหโรท: ปทํ ปฺราปฺย ราชตฺวํ กโรตีติ นิศมฺย ตตฺ สฺถานํ ยาตุํ ศงฺกิตวานฺ, ปศฺจาตฺ สฺวปฺน อีศฺวราตฺ ปฺรโพธํ ปฺราปฺย คาลีลฺเทศสฺย ปฺรเทไศกํ ปฺรสฺถาย นาสรนฺนาม นครํ คตฺวา ตตฺร นฺยุษิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","เตน ตํ นาสรตียํ กถยิษฺยนฺติ, ยเทตทฺวากฺยํ ภวิษฺยทฺวาทิภิรุกฺตฺตํ ตตฺ สผลมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ตทาโนํ โยหฺนฺนามา มชฺชยิตา ยิหูทียเทศสฺย ปฺรานฺตรมฺ อุปสฺถาย ปฺรจารยนฺ กถยามาส, ");
INSERT INTO santha_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","มนำสิ ปราวรฺตฺตยต, สฺวรฺคียราชตฺวํ สมีปมาคตมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ปรเมศสฺย ปนฺถานํ ปริษฺกุรุต สรฺวฺวต:ฯ ตสฺย ราชปถำศฺไจว สมีกุรุต สรฺวฺวถาฯ อิเตฺยตตฺ ปฺรานฺตเร วากฺยํ วทต: กสฺยจิทฺ รว:๚ ");
INSERT INTO santha_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","เอตทฺวจนํ ยิศยิยภวิษฺยทฺวาทินา โยหนมุทฺทิศฺย ภาษิตมฺฯ โยหโน วสนํ มหางฺคโรมชํ ตสฺย กเฏา จรฺมฺมกฏิพนฺธนํ; ส จ ศูกกีฏานฺ มธุ จ ภุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ตทานีํ ยิรูศาลมฺนครนิวาสิน: สรฺเวฺว ยิหูทิเทศียา ยรฺทฺทนฺตฏินฺยา อุภยตฏสฺถาศฺจ มานวา พหิราคตฺย ตสฺย สมีเป ");
INSERT INTO santha_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","สฺวียํ สฺวียํ ทุริตมฺ องฺคีกฺฤตฺย ตสฺยำ ยรฺทฺทนิ เตน มชฺชิตา พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","อปรํ พหูนฺ ผิรูศิน: สิทูกินศฺจ มนุชานฺ มํกฺตุํ สฺวสมีปมฺ อาคจฺจฺโหฺต วิโลกฺย ส ตานฺ อภิทเธา, เร เร ภุชควํศา อาคามีน: โกปาตฺ ปลายิตุํ ยุษฺมานฺ กศฺเจติตวานฺ? ");
INSERT INTO santha_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","มน:ปราวรฺตฺตนสฺย สมุจิตํ ผลํ ผลตฯ ");
INSERT INTO santha_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","กินฺตฺวสฺมากํ ตาต อิพฺราหีมฺ อสฺตีติ เสฺวษุ มน:สุ จีนฺตยนฺโต มา วฺยาหรตฯ ยโต ยุษฺมานฺ อหํ วทามิ, อีศฺวร เอเตภฺย: ปาษาเณภฺย อิพฺราหีม: สนฺตานานฺ อุตฺปาทยิตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","อปรํ ปาทปานำ มูเล กุฐาร อิทานีมปิ ลคนฺ อาเสฺต, ตสฺมาทฺ ยสฺมินฺ ปาทเป อุตฺตมํ ผลํ น ภวติ, ส กฺฤตฺโต มเธฺย'คฺนึ นิกฺเษปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","อปรมฺ อหํ มน:ปราวรฺตฺตนสูจเกน มชฺชเนน ยุษฺมานฺ มชฺชยามีติ สตฺยํ, กินฺตุ มม ปศฺจาทฺ ย อาคจฺฉติ, ส มตฺโตปิ มหานฺ, อหํ ตทีโยปานเหา โวฒุมปิ นหิ โยโคฺยสฺมิ, ส ยุษฺมานฺ วหฺนิรูเป ปวิตฺร อาตฺมนิ สํมชฺชยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ตสฺย กาเร สูรฺป อาเสฺต, ส สฺวียศสฺยานิ สมฺยกฺ ปฺรโสฺผฏฺย นิชานฺ สกลโคธูมานฺ สํคฺฤหฺย ภาณฺฑาคาเร สฺถาปยิษฺยติ, กึนฺตุ สรฺวฺวาณิ วุษาณฺยนิรฺวฺวาณวหฺนินา ทาหยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","อนนฺตรํ ยีศุ โรฺยหนา มชฺชิโต ภวิตุํ คาลีลฺปฺรเทศาทฺ ยรฺทฺทนิ ตสฺย สมีปมฺ อาชคามฯ ");
INSERT INTO santha_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","กินฺตุ โยหนฺ ตํ นิษิธฺย พภาเษ, ตฺวํ กึ มม สมีปมฺ อาคจฺฉสิ? วรํ ตฺวยา มชฺชนํ มม ปฺรโยชนมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ตทานีํ ยีศุ: ปฺรตฺยโวจตฺ; อีทานีมฺ อนุมนฺยสฺว, ยต อิตฺถํ สรฺวฺวธรฺมฺมสาธนมฺ อสฺมากํ กรฺตฺตวฺยํ, ตต: โส'นฺวมนฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","อนนฺตรํ ยีศุรมฺมสิ มชฺชิตุ: สนฺ ตตฺกฺษณาตฺ โตยมธฺยาทฺ อุตฺถาย ชคาม, ตทา ชีมูตทฺวาเร มุกฺเต ชาเต, ส อีศฺวรสฺยาตฺมานํ กโปตวทฺ อวรุหฺย โสฺวปรฺยฺยาคจฺฉนฺตํ วีกฺษาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","อปรมฺ เอษ มม ปฺริย: ปุตฺร เอตสฺมินฺเนว มม มหาสนฺโตษ เอตาทฺฤศี โวฺยมชา วาคฺ พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ตต: ปรํ ยีศุ: ปฺรตารเกณ ปรีกฺษิโต ภวิตุมฺ อาตฺมนา ปฺรานฺตรมฺ อากฺฤษฺฏ: ");
INSERT INTO santha_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","สนฺ จตฺวารึศทโหราตฺรานฺ อนาหารสฺติษฺฐนฺ กฺษุธิโต พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ตทานีํ ปรีกฺษิตา ตตฺสมีปมฺ อาคตฺย วฺยาหฺฤตวานฺ, ยทิ ตฺวมีศฺวราตฺมโช ภเวสฺตรฺหฺยาชฺญยา ปาษาณาเนตานฺ ปูปานฺ วิเธหิฯ ");
INSERT INTO santha_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ตต: ส ปฺรตฺยพฺรวีตฺ, อิตฺถํ ลิขิตมาเสฺต, \"มนุช: เกวลปูเปน น ชีวิษฺยติ, กินฺตฺวีศฺวรสฺย วทนาทฺ ยานิ ยานิ วจำสิ นิ:สรนฺติ ไตเรว ชีวิษฺยติฯ \" ");
INSERT INTO santha_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ตทา ปฺรตารกสฺตํ ปุณฺยนครํ นีตฺวา มนฺทิรสฺย จูโฑปริ นิธาย คทิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ตฺวํ ยทิศฺวรสฺย ตนโย ภเวสฺตรฺหีโต'ธ: ปต, ยต อิตฺถํ ลิขิตมาเสฺต, อาเทกฺษฺยติ นิชานฺ ทูตานฺ รกฺษิตุํ ตฺวำ ปรเมศฺวร:ฯ ยถา สรฺเวฺวษุ มารฺเคษุ ตฺวทียจรณทฺวเยฯ น ลเคตฺ ปฺรสฺตราฆาตสฺตฺวำ ฆริษฺยนฺติ เต กไร:๚ ");
INSERT INTO santha_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ตทานีํ ยีศุสฺตไสฺม กถิตวานฺ เอตทปิ ลิขิตมาเสฺต, \"ตฺวํ นิชปฺรภุํ ปรเมศฺวรํ มา ปรีกฺษสฺวฯ \" ");
INSERT INTO santha_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","อนนฺตรํ ปฺรตารก: ปุนรปิ ตมฺ อตฺยุญฺจธราธโรปริ นีตฺวา ชคต: สกลราชฺยานิ ตไทศฺวรฺยฺยาณิ จ ทรฺศยาศฺจการ กถยาญฺจการ จ, ");
INSERT INTO santha_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ยทิ ตฺวํ ทณฺฑวทฺ ภวนฺ มำ ปฺรณเมสฺตรฺหฺยหมฺ เอตานิ ตุภฺยํ ปฺรทาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ตทานีํ ยีศุสฺตมโวจตฺ, ทูรีภว ปฺรตารก, ลิขิตมิทมฺ อาเสฺต, \"ตฺวยา นิช: ปฺรภุ: ปรเมศฺวร: ปฺรณมฺย: เกวล: ส เสวฺยศฺจฯ \" ");
INSERT INTO santha_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ตต: ปฺรตารเกณ ส ปรฺยฺยตฺยาชิ, ตทา สฺวรฺคียทูไตราคตฺย ส สิเษเวฯ ");
INSERT INTO santha_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ตทนนฺตรํ โยหนฺ การายำ พพนฺเธ, ตทฺวารฺตฺตำ นิศมฺย ยีศุนา คาลีลฺ ปฺราสฺถียตฯ ");
INSERT INTO santha_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ตต: ปรํ ส นาสรนฺนครํ วิหาย ชลเฆสฺตเฏ สิพูลูนฺนปฺตาลี เอตโยรุวภโย: ปฺรเทศโย: สีมฺโนรฺมธฺยวรฺตฺตี ย: กผรฺนาหูมฺ ตนฺนครมฺ อิตฺวา นฺยวสตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ตสฺมาตฺ, อนฺยาเทศียคาลีลิ ยรฺทฺทนฺปาเร'พฺธิโรธสิฯ นปฺตาลิสิพูลูนฺเทเศา ยตฺร สฺถาเน สฺถิเตา ปุราฯ ");
INSERT INTO santha_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ตตฺรตฺยา มนุชา เย เย ปรฺยฺยภฺรามฺยนฺ ตมิสฺรเกฯ ไตรฺชไนรฺพฺฤหทาโลก: ปริทรฺศิษฺยเต ตทาฯ อวสนฺ เย ชนา เทเศ มฺฤตฺยุจฺฉายาสฺวรูปเกฯ เตษามุปริ โลกานามาโลก: สํปฺรกาศิต:๚ ");
INSERT INTO santha_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ยเทตทฺวจนํ ยิศยิยภวิษฺยทฺวาทินา โปฺรกฺตํ, ตตฺ ตทา สผลมฺ อภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","อนนฺตรํ ยีศุ: สุสํวาทํ ปฺรจารยนฺ เอตำ กถำ กถยิตุมฺ อาเรเภ, มนำสิ ปราวรฺตฺตยต, สฺวรฺคียราชตฺวํ สวิธมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ตต: ปรํ ยีศุ รฺคาลีโล ชลเธสฺตเฏน คจฺฉนฺ คจฺฉนฺ อานฺทฺริยสฺตสฺย ภฺราตา ศิโมนฺ อรฺถโต ยํ ปิตรํ วทนฺติ เอตาวุเภา ชลเฆา ชาลํ กฺษิปนฺเตา ททรฺศ, ยตเสฺตา มีนธาริณาวาสฺตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ตทา ส ตาวาหูย วฺยาชหาร, ยุวำ มม ปศฺจาทฺ อาคจฺฉตํ, ยุวามหํ มนุชธาริเณา กริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","เตไนว เตา ชาลํ วิหาย ตสฺย ปศฺจาตฺ อาคจฺฉตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","อนนฺตรํ ตสฺมาตฺ สฺถานาตฺ วฺรชนฺ วฺรชนฺ สิวทิยสฺย สุเตา ยากูพฺ โยหนฺนามาเนา เทฺวา สหเชา ตาเตน สารฺทฺธํ เนาโกปริ ชาลสฺย ชีรฺโณทฺธารํ กุรฺวฺวนฺเตา วีกฺษฺย ตาวาหูตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ตตฺกฺษณาตฺ เตา นาวํ สฺวตาตญฺจ วิหาย ตสฺย ปศฺจาทฺคามิเนา พภูวตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","อนนฺตรํ ภชนภวเน สมุปทิศนฺ ราชฺยสฺย สุสํวาทํ ปฺรจารยนฺ มนุชานำ สรฺวฺวปฺรการานฺ โรคานฺ สรฺวฺวปฺรการปีฑาศฺจ ศมยนฺ ยีศุ: กฺฤตฺสฺนํ คาลีลฺเทศํ ภฺรมิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","เตน กฺฤตฺสฺนสุริยาเทศสฺย มธฺยํ ตสฺย ยโศ วฺยาปฺโนตฺ, อปรํ ภูตคฺรสฺตา อปสฺมารรฺคีณ: ปกฺษาธาติปฺรภฺฤตยศฺจ ยาวนฺโต มนุชา นานาวิธวฺยาธิภิ: กฺลิษฺฏา อาสนฺ, เตษุ สรฺเวฺวษุ ตสฺย สมีปมฺ อานีเตษุ ส ตานฺ สฺวสฺถานฺ จการฯ ");
INSERT INTO santha_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","เอเตน คาลีลฺ-ทิกาปนิ-ยิรูศาลมฺ-ยิหูทียเทเศโภฺย ยรฺทฺทน: ปาราญฺจ พหโว มนุชาสฺตสฺย ปศฺจาทฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","อนนฺตรํ ส ชนนิวหํ นิรีกฺษฺย ภูธโรปริ วฺรชิตฺวา สมุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ตทานีํ ศิเษฺยษุ ตสฺย สมีปมาคเตษุ เตน เตภฺย เอษา กถา กถฺยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","อภิมานหีนา ชนา ธนฺยา:, ยตเสฺต สฺวรฺคียราชฺยมฺ อธิกริษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ขิทฺยมานา มนุชา ธนฺยา:, ยสฺมาตฺ เต สานฺตฺวนำ ปฺราปฺสนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","นมฺรา มานวาศฺจ ธนฺยา:, ยสฺมาตฺ เต เมทินีมฺ อธิกริษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ธรฺมฺมาย พุภุกฺษิตา: ตฺฤษารฺตฺตาศฺจ มนุชา ธนฺยา:, ยสฺมาตฺ เต ปริตรฺปฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","กฺฤปาลโว มานวา ธนฺยา:, ยสฺมาตฺ เต กฺฤปำ ปฺราปฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","นิรฺมฺมลหฺฤทยา มนุชาศฺจ ธนฺยา:, ยสฺมาตฺ ต อีศฺจรํ ทฺรกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","เมลยิตาโร มานวา ธนฺยา:, ยสฺมาตฺ ต อีศฺจรสฺย สนฺตานเตฺวน วิขฺยาสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ธรฺมฺมการณาตฺ ตาฑิตา มนุชา ธนฺยา, ยสฺมาตฺ สฺวรฺคียราเชฺย เตษามธิกโร วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ยทา มนุชา มม นามกฺฤเต ยุษฺมานฺ นินฺทนฺติ ตาฑยนฺติ มฺฤษา นานาทุรฺวฺวากฺยานิ วทนฺติ จ, ตทา ยุยํ ธนฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ตทา อานนฺทต, ตถา ภฺฤศํ หฺลาทธฺวญฺจ, ยต: สฺวรฺเค ภูยำสิ ผลานิ ลปฺสฺยเธฺว; เต ยุษฺมากํ ปุราตนานฺ ภวิษฺยทฺวาทิโน'ปิ ตาทฺฤคฺ อตาฑยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ยุยํ เมทินฺยำ ลวณรูปา:, กินฺตุ ยทิ ลวณสฺย ลวณตฺวมฺ อปยาติ, ตรฺหิ ตตฺ เกน ปฺรกาเรณ สฺวาทุยุกฺตํ ภวิษฺยติ? ตตฺ กสฺยาปิ การฺยฺยสฺยาโยคฺยตฺวาตฺ เกวลํ พหิ: ปฺรกฺเษปฺตุํ นราณำ ปทตเลน ทลยิตุญฺจ โยคฺยํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ยูยํ ชคติ ทีปฺติรูปา:, ภูธโรปริ สฺถิตํ นครํ คุปฺตํ ภวิตุํ นหิ ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","อปรํ มนุชา: ปฺรทีปานฺ ปฺรชฺวาลฺย โทฺรณาโธ น สฺถาปยนฺติ, กินฺตุ ทีปาธาโรปรฺเยฺยว สฺถาปยนฺติ, เตน เต ทีปา เคหสฺถิตานฺ สกลานฺ ปฺรกาศยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","เยน มานวา ยุษฺมากํ สตฺกรฺมฺมาณิ วิโลกฺย ยุษฺมากํ สฺวรฺคสฺถํ ปิตรํ ธนฺยํ วทนฺติ, เตษำ สมกฺษํ ยุษฺมากํ ทีปฺติสฺตาทฺฤกฺ ปฺรกาศตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","อหํ วฺยวสฺถำ ภวิษฺยทฺวากฺยญฺจ โลปฺตุมฺ อาคตวานฺ, อิตฺถํ มานุภวต, เต เทฺว โลปฺตุํ นาคตวานฺ, กินฺตุ สผเล กรฺตฺตุมฺ อาคโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","อปรํ ยุษฺมานฺ อหํ ตถฺยํ วทามิ ยาวตฺ โวฺยมเมทิโนฺย รฺธฺวํโส น ภวิษฺยติ, ตาวตฺ สรฺวฺวสฺมินฺ สผเล น ชาเต วฺยวสฺถายา เอกา มาตฺรา พินฺทุเรโกปิ วา น โลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ตสฺมาตฺ โย ชน เอตาสามฺ อาชฺญานามฺ อติกฺษุทฺรามฺ เอกาชฺญามปี ลํฆเต มนุชำญฺจ ตไถว ศิกฺษยติ, ส สฺวรฺคียราเชฺย สรฺเวฺวภฺย: กฺษุทฺรเตฺวน วิขฺยาสฺยเต, กินฺตุ โย ชนสฺตำ ปาลยติ, ตไถว ศิกฺษยติ จ, ส สฺวรฺคียราเชฺย ปฺรธานเตฺวน วิขฺยาสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","อปรํ ยุษฺมานฺ อหํ วทามิ, อธฺยาปกผิรูศิมานวานำ ธรฺมฺมานุษฺฐานาตฺ ยุษฺมากํ ธรฺมฺมานุษฺฐาเน โนตฺตเม ชาเต ยูยมฺ อีศฺวรียราชฺยํ ปฺรเวษฺฏุํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","อปรญฺจ ตฺวํ นรํ มา วธี:, ยสฺมาตฺ โย นรํ หนฺติ, ส วิจารสภายำ ทณฺฑาโรฺห ภวิษฺยติ, ปูรฺวฺวกาลีนชเนภฺย อิติ กถิตมาสีตฺ, ยุษฺมาภิรศฺราวิฯ ");
INSERT INTO santha_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","กินฺตฺวหํ ยุษฺมานฺ วทามิ, ย: กศฺจิตฺ การณํ วินา นิชภฺราเตฺร กุปฺยติ, ส วิจารสภายำ ทณฺฑาโรฺห ภวิษฺยติ; ย: กศฺจิจฺจ สฺวียสหชํ นิรฺพฺโพธํ วทติ, ส มหาสภายำ ทณฺฑาโรฺห ภวิษฺยติ; ปุนศฺจ ตฺวํ มูฒ อิติ วากฺยํ ยทิ กศฺจิตฺ สฺวียภฺราตรํ วกฺติ, ตรฺหิ นรกาคฺเนา ส ทณฺฑาโรฺห ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","อโต เวทฺยา: สมีปํ นิชไนเวเทฺย สมานีเต'ปิ นิชภฺราตรํ ปฺรติ กสฺมาจฺจิตฺ การณาตฺ ตฺวํ ยทิ โทษี วิทฺยเส, ตทานีํ ตว ตสฺย สฺมฺฤติ รฺชายเต จ, ");
INSERT INTO santha_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ตรฺหิ ตสฺยา เวทฺยา: สมีเป นิชไนไวทฺยํ นิธาย ตไทว คตฺวา ปูรฺวฺวํ เตน สารฺทฺธํ มิล, ปศฺจาตฺ อาคตฺย นิชไนเวทฺยํ นิเวทยฯ ");
INSERT INTO santha_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","อนฺยญฺจ ยาวตฺ วิวาทินา สารฺทฺธํ วรฺตฺมนิ ติษฺฐสิ, ตาวตฺ เตน สารฺทฺธํ เมลนํ กุรุ; โน เจตฺ วิวาที วิจารยิตุ: สมีเป ตฺวำ สมรฺปยติ วิจารยิตา จ รกฺษิณ: สนฺนิเธา สมรฺปยติ ตทา ตฺวํ การายำ พเธฺยถา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ตรฺหิ ตฺวามหํ ตถฺถํ พฺรวีมิ, เศษกปรฺทเก'ปิ น ปริโศธิเต ตสฺมาตฺ สฺถานาตฺ กทาปิ พหิราคนฺตุํ น ศกฺษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","อปรํ ตฺวํ มา วฺยภิจร, ยเทตทฺ วจนํ ปูรฺวฺวกาลีนโลเกภฺย: กถิตมาสีตฺ, ตทฺ ยูยํ ศฺรุตวนฺต:; ");
INSERT INTO santha_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","กินฺตฺวหํ ยุษฺมานฺ วทามิ, ยทิ กศฺจิตฺ กามต: กาญฺจน โยษิตํ ปศฺยติ, ตรฺหิ ส มนสา ตไทว วฺยภิจริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ตสฺมาตฺ ตว ทกฺษิณํ เนตฺรํ ยทิ ตฺวำ พาธเต, ตรฺหิ ตนฺเนตฺรมฺ อุตฺปาฏฺย ทูเร นิกฺษิป, ยสฺมาตฺ ตว สรฺวฺววปุโษ นรเก นิกฺเษปาตฺ ตไวกางฺคสฺย นาโศ วรํฯ ");
INSERT INTO santha_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ยทฺวา ตว ทกฺษิณ: กโร ยทิ ตฺวำ พาธเต, ตรฺหิ ตํ กรํ ฉิตฺตฺวา ทูเร นิกฺษิป, ยต: สรฺวฺววปุโษ นรเก นิกฺเษปาตฺ เอกางฺคสฺย นาโศ วรํฯ ");
INSERT INTO santha_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","อุกฺตมาเสฺต, ยทิ กศฺจินฺ นิชชายำ ปริตฺยกฺตฺตุมฺ อิจฺฉติ, ตรฺหิ ส ตไสฺย ตฺยาคปตฺรํ ททาตุฯ ");
INSERT INTO santha_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","กินฺตฺวหํ ยุษฺมานฺ วฺยาหรามิ, วฺยภิจารโทเษ น ชาเต ยทิ กศฺจินฺ นิชชายำ ปริตฺยชติ, ตรฺหิ ส ตำ วฺยภิจารยติ; ยศฺจ ตำ ตฺยกฺตำ สฺตฺริยํ วิวหติ, โสปิ วฺยภิจรติฯ ");
INSERT INTO santha_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ปุนศฺจ ตฺวํ มฺฤษา ศปถมฺ น กุรฺวฺวนฺ อีศฺจราย นิชศปถํ ปาลย, ปูรฺวฺวกาลีนโลเกโภฺย ไยษา กถา กถิตา, ตามปิ ยูยํ ศฺรุตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","กินฺตฺวหํ ยุษฺมานฺ วทามิ, กมปิ ศปถํ มา การฺษฺฏ, อรฺถต: สฺวรฺคนามฺนา น, ยต: ส อีศฺวรสฺย สึหาสนํ; ");
INSERT INTO santha_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ปฺฤถิวฺยา นามฺนาปิ น, ยต: สา ตสฺย ปาทปีฐํ; ยิรูศาลโม นามฺนาปิ น, ยต: สา มหาราชสฺย ปุรี; ");
INSERT INTO santha_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","นิชศิโรนามฺนาปิ น, ยสฺมาตฺ ตไสฺยกํ กจมปิ สิตมฺ อสิตํ วา กรฺตฺตุํ ตฺวยา น ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","อปรํ ยูยํ สํลาปสมเย เกวลํ ภวตีติ น ภวตีติ จ วทต ยต อิโต'ธิกํ ยตฺ ตตฺ ปาปาตฺมโน ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","อปรํ โลจนสฺย วินิมเยน โลจนํ ทนฺตสฺย วินิมเยน ทนฺต: ปูรฺวฺวกฺตมิทํ วจนญฺจ ยุษฺมาภิรศฺรูยตฯ ");
INSERT INTO santha_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","กินฺตฺวหํ ยุษฺมานฺ วทามิ ยูยํ หึสกํ นรํ มา วฺยาฆาตยตฯ กินฺตุ เกนจิตฺ ตว ทกฺษิณกโปเล จเปฏาฆาเต กฺฤเต ตํ ปฺรติ วามํ กโปลญฺจ วฺยาโฆฏยฯ ");
INSERT INTO santha_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","อปรํ เกนจิตฺ ตฺวยา สารฺธฺทํ วิวาทํ กฺฤตฺวา ตว ปริเธยวสเน ชิฆฺฤติเต ตสฺมายุตฺตรียวสนมปิ เทหิฯ ");
INSERT INTO santha_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ยทิ กศฺจิตฺ ตฺวำ โกฺรศเมกํ นยนารฺถํ อนฺยายโต ธรติ, ตทา เตน สารฺธฺทํ โกฺรศทฺวยํ ยาหิฯ ");
INSERT INTO santha_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ยศฺจ มานวสฺตฺวำ ยาจเต, ตไสฺม เทหิ, ยทิ กศฺจิตฺ ตุภฺยํ ธารยิตุมฺ อิจฺฉติ, ตรฺหิ ตํ ปฺรติ ปรำมุโข มา ภู:ฯ ");
INSERT INTO santha_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","นิชสมีปวสินิ เปฺรม กุรุ, กินฺตุ ศตฺรุํ ปฺรติ เทฺวษํ กุรุ, ยเทตตฺ ปุโรกฺตํ วจนํ เอตทปิ ยูยํ ศฺรุตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","กินฺตฺวหํ ยุษฺมานฺ วทามิ, ยูยํ ริปุวฺวปิ เปฺรม กุรุต, เย จ ยุษฺมานฺ ศปนฺเต, ตาน, อาศิษํ วทต, เย จ ยุษฺมานฺ ฤृตียนฺเต, เตษำ มงฺคลํ กุรุต, เย จ ยุษฺมานฺ นินฺทนฺติ, ตาฑยนฺติ จ, เตษำ กฺฤเต ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ตตฺร ย: สตามสตาญฺโจปริ ปฺรภากรมฺ อุทายยติ, ตถา ธารฺมฺมิกานามธารฺมฺมิกานาญฺโจปริ นีรํ วรฺษยติ ตาทฺฤโศ โย ยุษฺมากํ สฺวรฺคสฺถ: ปิตา, ยูยํ ตไสฺยว สนฺตานา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","เย ยุษฺมาสุ เปฺรม กุรฺวฺวนฺติ, ยูยํ ยทิ เกวลํ เตเวฺวว เปฺรม กุรุถ, ตรฺหิ ยุษฺมากํ กึ ผลํ ภวิษฺยติ? จณฺฑาลา อปิ ตาทฺฤศํ กึ น กุรฺวฺวนฺติ? ");
INSERT INTO santha_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","อปรํ ยูยํ ยทิ เกวลํ สฺวียภฺราตฺฤเตฺวน นมต, ตรฺหิ กึ มหตฺ กรฺมฺม กุรุถ? จณฺฑาลา อปิ ตาทฺฤศํ กึ น กุรฺวฺวนฺติ? ");
INSERT INTO santha_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ตสฺมาตฺ ยุษฺมากํ สฺวรฺคสฺถ: ปิตา ยถา ปูรฺโณ ภวติ, ยูยมปิ ตาทฺฤศา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","สาวธานา ภวต, มนุชานฺ ทรฺศยิตุํ เตษำ โคจเร ธรฺมฺมกรฺมฺม มา กุรุต, ตถา กฺฤเต ยุษฺมากํ สฺวรฺคสฺถปิตุ: สกาศาตฺ กิญฺจน ผลํ น ปฺราปฺสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ตฺวํ ยทา ททาสิ ตทา กปฏิโน ชนา ยถา มนุเชภฺย: ปฺรศํสำ ปฺราปฺตุํ ภชนภวเน ราชมารฺเค จ ตูรีํ วาทยนฺติ, ตถา มา กุริु, อหํ ตุภฺยํ ยถารฺถํ กถยามิ, เต สฺวกายํ ผลมฺ อลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","กินฺตุ ตฺวํ ยทา ททาสิ, ตทา นิชทกฺษิณกโร ยตฺ กโรติ, ตทฺ วามกรํ มา ชฺญาปยฯ ");
INSERT INTO santha_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","เตน ตว ทานํ คุปฺตํ ภวิษฺยติ ยสฺตุ ตว ปิตา คุปฺตทรฺศี, ส ปฺรกาศฺย ตุภฺยํ ผลํ ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","อปรํ ยทา ปฺรารฺถยเส, ตทา กปฏินอิว มา กุรุ, ยสฺมาตฺ เต ภชนภวเน ราชมารฺคสฺย โกเณ ติษฺฐนฺโต โลกานฺ ทรฺศยนฺต: ปฺรารฺถยิตุํ ปฺรียนฺเต; อหํ ยุษฺมานฺ ตถฺยํ วทามิ, เต สฺวกียผลํ ปฺราปฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ตสฺมาตฺ ปฺรารฺถนากาเล อนฺตราคารํ ปฺรวิศฺย ทฺวารํ รุทฺวฺวา คุปฺตํ ปศฺยตสฺตว ปิตุ: สมีเป ปฺรารฺถยสฺว; เตน ตว ย: ปิตา คุปฺตทรฺศี, ส ปฺรกาศฺย ตุภฺยํ ผลํ ทาสฺยติl ");
INSERT INTO santha_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","อปรํ ปฺรารฺถนากาเล เทวปูชกาอิว มุธา ปุนรุกฺตึ มา กุรุ, ยสฺมาตฺ เต โพธนฺเต, พหุวารํ กถายำ กถิตายำ เตษำ ปฺรารฺถนา คฺราหิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ยูยํ เตษามิว มา กุรุต, ยสฺมาตฺ ยุษฺมากํ ยทฺ ยตฺ ปฺรโยชนํ ยาจนาต: ปฺราเคว ยุษฺมากํ ปิตา ตตฺ ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","อเตอว ยูยม อีทฺฤกฺ ปฺรารฺถยธฺวํ, เห อสฺมากํ สฺวรฺคสฺถปิต:, ตว นาม ปูชฺยํ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ตว ราชตฺวํ ภวตุ; ตเวจฺฉา สฺวรฺเค ยถา ตไถว เมทินฺยามปิ สผลา ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","อสฺมากํ ปฺรโยชนียมฺ อาหารมฺ อทฺย เทหิฯ ");
INSERT INTO santha_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","วยํ ยถา นิชาปราธิน: กฺษมามเห, ตไถวาสฺมากมฺ อปราธานฺ กฺษมสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","อสฺมานฺ ปรีกฺษำ มานย, กินฺตุ ปาปาตฺมโน รกฺษ; ราชตฺวํ เคารวํ ปรากฺรม: เอเต สรฺเวฺว สรฺวฺวทา ตว; ตถาสฺตุฯ ");
INSERT INTO santha_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ยทิ ยูยมฺ อเนฺยษามฺ อปราธานฺ กฺษมเธฺว ตรฺหิ ยุษฺมากํ สฺวรฺคสฺถปิตาปิ ยุษฺมานฺ กฺษมิษฺยเต; ");
INSERT INTO santha_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","กินฺตุ ยทิ ยูยมฺ อเนฺยษามฺ อปราธานฺ น กฺษมเธฺว, ตรฺหิ ยุษฺมากํ ชนโกปิ ยุษฺมากมฺ อปราธานฺ น กฺษมิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","อปรมฺ อุปวาสกาเล กปฏิโน ชนา มานุษานฺ อุปวาสํ ชฺญาปยิตุํ เสฺวษำ วทนานิ มฺลานานิ กุรฺวฺวนฺติ, ยูยํ ตอิว วิษณวทนา มา ภวต; อหํ ยุษฺมานฺ ตถฺยํ วทามิ เต สฺวกียผลมฺ อลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ยทา ตฺวมฺ อุปวสสิ, ตทา ยถา โลไกสฺตฺวํ อุปวาสีว น ทฺฤศฺยเส, กินฺตุ ตว โย'โคจร: ปิตา เตไนว ทฺฤศฺยเส, ตตฺกฺฤเต นิชศิรสิ ไตลํ มรฺทฺทย วทนญฺจ ปฺรกฺษาลย; ");
INSERT INTO santha_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","เตน ตว ย: ปิตา คุปฺตทรฺศี ส ปฺรกาศฺย ตุภฺยํ ผลํ ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","อปรํ ยตฺร สฺถาเน กีฏา: กลงฺกาศฺจ กฺษยํ นยนฺติ, เจาราศฺจ สนฺธึ กรฺตฺตยิตฺวา โจรยิตุํ ศกฺนุวนฺติ, ตาทฺฤศฺยำ เมทินฺยำ สฺวารฺถํ ธนํ มา สํจินุตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","กินฺตุ ยตฺร สฺถาเน กีฏา: กลงฺกาศฺจ กฺษยํ น นยนฺติ, เจาราศฺจ สนฺธึ กรฺตฺตยิตฺวา โจรยิตุํ น ศกฺนุวนฺติ, ตาทฺฤเศ สฺวรฺเค ธนํ สญฺจินุตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ยสฺมาตฺ ยตฺร สฺถาเน ยุษฺมำก ธนํ ตไตฺรว ขาเน ยุษฺมากํ มนำสิฯ ");
INSERT INTO santha_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","โลจนํ เทหสฺย ปฺรทีปกํ, ตสฺมาตฺ ยทิ ตว โลจนํ ปฺรสนฺนํ ภวติ, ตรฺหิ ตว กฺฤตฺสฺนํ วปุ รฺทีปฺติยุกฺตํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","กินฺตุ โลจเน'ปฺรสนฺเน ตว กฺฤตฺสฺนํ วปุ: ตมิสฺรยุกฺตํ ภวิษฺยติฯ อเตอว ยา ทีปฺติสฺตฺวยิ วิทฺยเต, สา ยทิ ตมิสฺรยุกฺตา ภวติ, ตรฺหิ ตตฺ ตมิสฺรํ กิยนฺ มหตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","โกปิ มนุโช เทฺวา ปฺรภู เสวิตุํ น ศกฺโนติ, ยสฺมาทฺ เอกํ สํมนฺย ตทนฺยํ น สมฺมนฺยเต, ยทฺวา เอกตฺร มโน นิธาย ตทนฺยมฺ อวมนฺยเต; ตถา ยูยมปีศฺวรํ ลกฺษฺมีญฺเจตฺยุเภ เสวิตุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","อปรมฺ อหํ ยุษฺมภฺยํ ตถฺยํ กถยามิ, กึ ภกฺษิษฺยาม:? กึ ปาสฺยาม:? อิติ ปฺราณธารณาย มา จินฺตยต; กึ ปริธาสฺยาม:? อิติ กายรกฺษณาย น จินฺตยต; ภกฺษฺยาตฺ ปฺราณา วสนาญฺจ วปูํษิ กึ เศฺรษฺฐาณิ น หิ? ");
INSERT INTO santha_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","วิหายโส วิหงฺคมานฺ วิโลกยต; ไต โรฺนปฺยเต น กฺฤตฺยเต ภาณฺฑาคาเร น สญฺจียเต'ปิ; ตถาปิ ยุษฺมากํ สฺวรฺคสฺถ: ปิตา เตภฺย อาหารํ วิตรติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ยูยํ เตภฺย: กึ เศฺรษฺฐา น ภวถ? ยุษฺมากํ กศฺจิตฺ มนุช: จินฺตยนฺ นิชายุษ: กฺษณมปิ วรฺทฺธยิตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","อปรํ วสนาย กุตศฺจินฺตยต? เกฺษโตฺรตฺปนฺนานิ ปุษฺปาณิ กถํ วรฺทฺธนฺเต ตทาโลจยตฯ ตานิ ตนฺตูนฺ โนตฺปาทยนฺติ กิมปิ การฺยฺยํ น กุรฺวฺวนฺติ; ");
INSERT INTO santha_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ตถาปฺยหํ ยุษฺมานฺ วทามิ, สุเลมานฺ ตาทฺฤคฺ ไอศฺวรฺยฺยวานปิ ตตฺปุษฺปมิว วิภูษิโต นาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ตสฺมาตฺ กฺษทฺย วิทฺยมานํ ศฺจ: จุลฺลฺยำ นิกฺเษปฺสฺยเต ตาทฺฤศํ ยตฺ เกฺษตฺรสฺถิตํ กุสุมํ ตตฺ ยทีศฺจร อิตฺถํ พิภูษยติ, ตรฺหิ เห โสฺตกปฺรตฺยยิโน ยุษฺมานฺ กึ น ปริธาปยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ตสฺมาตฺ อสฺมาภิ: กิมตฺสฺยเต? กิญฺจ ปายิษฺยเต? กึ วา ปริธายิษฺยเต, อิติ น จินฺตยตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ยสฺมาตฺ เทวารฺจฺจกา อปีติ เจษฺฏนฺเต; เอเตษุ ทฺรเวฺยษุ ปฺรโยชนมสฺตีติ ยุษฺมากํ สฺวรฺคสฺถ: ปิตา ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","อเตอว ปฺรถมต อีศฺวรียราชฺยํ ธรฺมฺมญฺจ เจษฺฏธฺวํ, ตต เอตานิ วสฺตูนิ ยุษฺมภฺยํ ปฺรทายิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ศฺว: กฺฤเต มา จินฺตยต, ศฺเวอว สฺวยํ สฺวมุทฺทิศฺย จินฺตยิษฺยติ; อทฺยตนี ยา จินฺตา สาทฺยกฺฤเต ปฺรจุรตราฯ ");
INSERT INTO santha_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ยถา ยูยํ โทษีกฺฤตา น ภวถ, ตตฺกฺฤเต'นฺยํ โทษิณํ มา กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ยโต ยาทฺฤเศน โทเษณ ยูยํ ปรานฺ โทษิณ: กุรุถ, ตาทฺฤเศน โทเษณ ยูยมปิ โทษีกฺฤตา ภวิษฺยถ, อนฺยญฺจ เยน ปริมาเณน ยุษฺมาภิ: ปริมียเต, เตไนว ปริมาเณน ยุษฺมตฺกฺฤเต ปริมายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","อปรญฺจ นิชนยเน ยา นาสา วิทฺยเต, ตามฺ อนาโลจฺย ตว สหชสฺย โลจเน ยตฺ ตฺฤณมฺ อาเสฺต, ตเทว กุโต วีกฺษเส? ");
INSERT INTO santha_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ตว นิชโลจเน นาสายำ วิทฺยมานายำ, เห ภฺราต:, ตว นยนาตฺ ตฺฤณํ พหิษฺยรฺตุํ อนุชานีหิ, กถาเมตำ นิชสหชาย กถํ กถยิตุํ ศกฺโนษิ? ");
INSERT INTO santha_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","เห กปฏินฺ, อาเทา นิชนยนาตฺ นาสำ พหิษฺกุรุ ตโต นิชทฺฤษฺเฏา สุปฺรสนฺนายำ ตว ภฺราตฺฤ โรฺลจนาตฺ ตฺฤณํ พหิษฺกรฺตุํ ศกฺษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","อนฺยญฺจ สารเมเยภฺย: ปวิตฺรวสฺตูนิ มา วิตรต, วราหาณำ สมกฺษญฺจ มุกฺตา มา นิกฺษิปต; นิกฺเษปณาตฺ เต ตา: สรฺวฺวา: ปไท รฺทลยิษฺยนฺติ, ปราวฺฤตฺย ยุษฺมานปิ วิทารยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ยาจธฺวํ ตโต ยุษฺมภฺยํ ทายิษฺยเต; มฺฤคยธฺวํ ตต อุทฺเทศํ ลปฺสฺยเธฺว; ทฺวารมฺ อาหต, ตโต ยุษฺมตฺกฺฤเต มุกฺตํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ยสฺมาทฺ เยน ยาจฺยเต, เตน ลภฺยเต; เยน มฺฤคฺยเต เตโนทฺเทศ: ปฺราปฺยเต; เยน จ ทฺวารมฺ อาหนฺยเต, ตตฺกฺฤเต ทฺวารํ โมจฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","อาตฺมเชน ปูเป ปฺรารฺถิเต ตไสฺม ปาษาณํ วิศฺราณยติ, ");
INSERT INTO santha_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","มีเน ยาจิเต จ ตไสฺม ภุชคํ วิตรติ, เอตาทฺฤศ: ปิตา ยุษฺมากํ มเธฺย ก อาเสฺต? ");
INSERT INTO santha_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ตสฺมาทฺ ยูยมฺ อภทฺรา: สนฺโต'ปิ ยทิ นิชพาลเกภฺย อุตฺตมํ ทฺรวฺยํ ทาตุํ ชานีถ, ตรฺหิ ยุษฺมากํ สฺวรฺคสฺถ: ปิตา สฺวียยาจเกภฺย: กิมุตฺตมานิ วสฺตูนิ น ทาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ยูษฺมานฺ ปฺรตีตเรษำ ยาทฺฤโศ วฺยวหาโร ยุษฺมากํ ปฺริย:, ยูยํ ตานฺ ปฺรติ ตาทฺฤศาเนว วฺยวหารานฺ วิธตฺต; ยสฺมาทฺ วฺยวสฺถาภวิษฺยทฺวาทินำ วจนานามฺ อิติ สารมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","สงฺกีรฺณทฺวาเรณ ปฺรวิศต; ยโต นรกคมนาย ยทฺ ทฺวารํ ตทฺ วิสฺตีรฺณํ ยจฺจ วรฺตฺม ตทฺ พฺฤหตฺ เตน พหว: ปฺรวิศนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","อปรํ สฺวรฺคคมนาย ยทฺ ทฺวารํ ตตฺ กีทฺฤกฺ สํกีรฺณํฯ ยจฺจ วรฺตฺม ตตฺ กีทฺฤคฺ ทุรฺคมมฺฯ ตทุทฺเทษฺฏาร: กิยนฺโต'ลฺปา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","อปรญฺจ เย ชนา เมษเวเศน ยุษฺมากํ สมีปมฺ อาคจฺฉนฺติ, กินฺตฺวนฺตรฺทุรนฺตา วฺฤกา เอตาทฺฤเศโภฺย ภวิษฺยทฺวาทิภฺย: สาวธานา ภวต, ยูยํ ผเลน ตานฺ ปริเจตุํ ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","มนุชา: กึ กณฺฏกิโน วฺฤกฺษาทฺ ทฺรากฺษาผลานิ ศฺฤคาลโกลิตศฺจ อุฑุมฺพรผลานิ ศาตยนฺติ? ");
INSERT INTO santha_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ตทฺวทฺ อุตฺตม เอว ปาทป อุตฺตมผลานิ ชนยติ, อธมปาทเปอวาธมผลานิ ชนยติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","กินฺตูตฺตมปาทป: กทาปฺยธมผลานิ ชนยิตุํ น ศกฺโนติ, ตถาธโมปิ ปาทป อุตฺตมผลานิ ชนยิตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","อปรํ เย เย ปาทปา อธมผลานิ ชนยนฺติ, เต กฺฤตฺตา วเหฺนา กฺษิปฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","อเตอว ยูยํ ผเลน ตานฺ ปริเจษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","เย ชนา มำ ปฺรภุํ วทนฺติ, เต สรฺเวฺว สฺวรฺคราชฺยํ ปฺรเวกฺษฺยนฺติ ตนฺน, กินฺตุ โย มานโว มม สฺวรฺคสฺถสฺย ปิตุริษฺฏํ กรฺมฺม กโรติ ส เอว ปฺรเวกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ตทฺ ทิเน พหโว มำ วทิษฺยนฺติ, เห ปฺรโภ เห ปฺรโภ, ตว นามฺนา กิมสฺมามิ รฺภวิษฺยทฺวากฺยํ น วฺยาหฺฤตํ? ตว นามฺนา ภูตา: กึ น ตฺยาชิตา:? ตว นามฺนา กึ นานาทฺภุตานิ กรฺมฺมาณิ น กฺฤตานิ? ");
INSERT INTO santha_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ตทาหํ วทิษฺยามิ, เห กุกรฺมฺมการิโณ ยุษฺมานฺ อหํ น เวทฺมิ, ยูยํ มตฺสมีปาทฺ ทูรีภวตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ย: กศฺจิตฺ มไมตา: กถา: ศฺรุตฺวา ปาลยติ, ส ปาษาโณปริ คฺฤหนิรฺมฺมาตฺรา ชฺญานินา สห มโยปมียเตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ยโต วฺฤษฺเฏา สตฺยามฺ อาปฺลาว อาคเต วาเยา วาเต จ เตษุ ตทฺเคหํ ลคฺเนษุ ปาษาโณปริ ตสฺย ภิตฺเตสฺตนฺน ปตติl ");
INSERT INTO santha_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","กินฺตุ ย: กศฺจิตฺ มไมตา: กถา: ศฺรุตฺวา น ปาลยติ ส ไสกเต เคหนิรฺมฺมาตฺรา 'ชฺญานินา อุปมียเตฯ ");
INSERT INTO santha_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ยโต ชลวฺฤษฺเฏา สตฺยามฺ อาปฺลาว อาคเต ปวเน วาเต จ ไต รฺคฺฤเห สมาฆาเต ตตฺ ปตติ ตตฺปตนํ มหทฺ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ยีศุไนเตษุ วาเกฺยษุ สมาปิเตษุ มานวาสฺตทีโยปเทศมฺ อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ยสฺมาตฺ ส อุปาธฺยายา อิว ตานฺ โนปทิเทศ กินฺตุ สมรฺถปุรุษอิว สมุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ยทา ส ปรฺวฺวตาทฺ อวาโรหตฺ ตทา พหโว มานวาสฺตตฺปศฺจาทฺ ววฺรชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","เอก: กุษฺฐวานฺ อาคตฺย ตํ ปฺรณมฺย พภาเษ, เห ปฺรโภ, ยทิ ภวานฺ สํมนฺยเต, ตรฺหิ มำ นิรามยํ กรฺตฺตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ตโต ยีศุ: กรํ ปฺรสารฺยฺย ตสฺยางฺคํ สฺปฺฤศนฺ วฺยาชหาร, สมฺมเนฺย'หํ ตฺวํ นิรามโย ภว; เตน ส ตตฺกฺษณาตฺ กุษฺเฐนาโมจิฯ ");
INSERT INTO santha_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ตโต ยีศุสฺตํ ชคาท, อวเธหิ กถาเมตำ กศฺจิทปิ มา พฺรูหิ, กินฺตุ ยาชกสฺย สนฺนิธึ คตฺวา สฺวาตฺมานํ ทรฺศย มนุเชโภฺย นิชนิรามยตฺวํ ปฺรมาณยิตุํ มูสานิรูปิตํ ทฺรวฺยมฺ อุตฺสฺฤช จฯ ");
INSERT INTO santha_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ตทนนฺตรํ ยีศุนา กผรฺนาหูมฺนามนิ นคเร ปฺรวิษฺเฏ กศฺจิตฺ ศตเสนาปติสฺตตฺสมีปมฺ อาคตฺย วินีย พภาเษ, ");
INSERT INTO santha_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","เห ปฺรโภ, มทีย เอโก ทาส: ปกฺษาฆาตวฺยาธินา ภฺฤศํ วฺยถิต:, สตุ ศยนีย อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ตทานีํ ยีศุสฺตไสฺม กถิตวานฺ, อหํ คตฺวา ตํ นิรามยํ กริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ตต: ส ศตเสนาปติ: ปฺรตฺยวทตฺ, เห ปฺรโภ, ภวานฺ ยตฺ มม เคหมธฺยํ ยาติ ตโทฺยคฺยภาชนํ นาหมสฺมิ; วางฺมาตฺรมฺ อาทิศตุ, เตไนว มม ทาโส นิรามโย ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ยโต มยิ ปรนิทฺเหฺน'ปิ มม นิเทศวศฺยา: กติ กติ เสนา: สนฺติ, ตต เอกสฺมินฺ ยาหีตฺยุกฺเต ส ยาติ, ตทนฺยสฺมินฺ เอหีตฺยุกฺเต ส อายาติ, ตถา มม นิชทาเส กรฺมฺไมตตฺ กุรฺวฺวิตฺยุกฺเต ส ตตฺ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ตทานีํ ยีศุสฺตไสฺยตตฺ วโจ นิศมฺย วิสฺมยาปนฺโน'ภูตฺ; นิชปศฺจาทฺคามิโน มานวานฺ อโวจฺจ, ยุษฺมานฺ ตถฺยํ วจฺมิ, อิสฺราเยลียโลกานำ มเธฺย'ปิ ไนตาทฺฤโศ วิศฺวาโส มยา ปฺราปฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","อนฺยจฺจาหํ ยุษฺมานฺ วทามิ, พหว: ปูรฺวฺวสฺยา: ปศฺจิมายาศฺจ ทิศ อาคตฺย อิพฺราหีมา อิสฺหากา ยากูพา จ สากมฺ มิลิตฺวา สมุปเวกฺษฺยนฺติ; ");
INSERT INTO santha_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","กินฺตุ ยตฺร สฺถาเน โรทนทนฺตฆรฺษเณ ภวตสฺตสฺมินฺ พหิรฺภูตตมิเสฺร ราชฺยสฺย สนฺตานา นิกฺเษสฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ตต: ปรํ ยีศุสฺตํ ศตเสนาปตึ ชคาท, ยาหิ, ตว ปฺรตีตฺยนุสารโต มงฺคลํ ภูยาตฺ; ตทา ตสฺมินฺเนว ทณฺเฑ ตทียทาโส นิรามโย พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","อนนฺตรํ ยีศุ: ปิตรสฺย เคหมุปสฺถาย ชฺวเรณ ปีฑิตำ ศยนียสฺถิตำ ตสฺย ศฺวศฺรูํ วีกฺษาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ตตเสฺตน ตสฺยา: กรสฺย สฺปฺฤษฺฏตวาตฺ ชฺวรสฺตำ ตตฺยาช, ตทา สา สมุตฺถาย ตานฺ สิเษเวฯ ");
INSERT INTO santha_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","อนนฺตรํ สนฺธฺยายำ สตฺยำ พหุโศ ภูตคฺรสฺตมนุชานฺ ตสฺย สมีปมฺ อานินฺยุ: ส จ วาเกฺยน ภูตานฺ ตฺยาชยามาส, สรฺวฺวปฺรการปีฑิตชนำศฺจ นิรามยานฺ จการ; ");
INSERT INTO santha_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ตสฺมาตฺ, สรฺวฺวา ทุรฺพฺพลตาสฺมากํ เตไนว ปริธาริตาฯ อสฺมากํ สกลํ วฺยาธึ เสอว สํคฺฤหีตวานฺฯ ยเทตทฺวจนํ ยิศยิยภวิษฺยทฺวาทิโนกฺตมาสีตฺ, ตตฺตทา สผลมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","อนนฺตรํ ยีศุศฺจตุรฺทิกฺษุ ชนนิวหํ วิโลกฺย ตฏินฺยา: ปารํ ยาตุํ ศิษฺยานฺ อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ตทานีมฺ เอก อุปาธฺยาย อาคตฺย กถิตวานฺ, เห คุโร, ภวานฺ ยตฺร ยาสฺยติ ตตฺราหมปิ ภวต: ปศฺจาทฺ ยาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ตโต ยีศุ รฺชคาท, โกฺรษฺฏุ: สฺถาตุํ สฺถานํ วิทฺยเต, วิหายโส วิหงฺคมานำ นีฑานิ จ สนฺติ; กินฺตุ มนุษฺยปุตฺรสฺย ศิร: สฺถาปยิตุํ สฺถานํ น วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","อนนฺตรมฺ อปร เอก: ศิษฺยสฺตํ พภาเษ, เห ปฺรโภ, ปฺรถมโต มม ปิตรํ ศฺมศาเน นิธาตุํ คมนารฺถํ มามฺ อนุมนฺยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ตโต ยีศุรุกฺตวานฺ มฺฤตา มฺฤตานฺ ศฺมศาเน นิทธตุ, ตฺวํ มม ปศฺจาทฺ อาคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","อนนฺตรํ ตสฺมินฺ นาวมารูเฒ ตสฺย ศิษฺยาสฺตตฺปศฺจาตฺ ชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ปศฺจาตฺ สาครสฺย มธฺยํ เตษุ คเตษุ ตาทฺฤศ: ปฺรพโล ฌญฺภฺศนิล อุทติษฺฐตฺ, เยน มหาตรงฺค อุตฺถาย ตรณึ ฉาทิตวานฺ, กินฺตุ ส นิทฺริต อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ตทา ศิษฺยา อาคตฺย ตสฺย นิทฺราภงฺคํ กฺฤตฺวา กถยามาสุ:, เห ปฺรโภ, วยํ มฺริยามเห, ภวานฺ อสฺมากํ ปฺราณานฺ รกฺษตุฯ ");
INSERT INTO santha_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ตทา ส ตานฺ อุกฺตวานฺ, เห อลฺปวิศฺวาสิโน ยูยํ กุโต วิภีถ? ตต: ส อุตฺถาย วาตํ สาครญฺจ ตรฺชยามาส, ตโต นิรฺวฺวาตมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","อปรํ มนุชา วิสฺมยํ วิโลกฺย กถยามาสุ:, อโห วาตสริตฺปตี อสฺย กิมาชฺญาคฺราหิเณา? กีทฺฤโศ'ยํ มานว:ฯ ");
INSERT INTO santha_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","อนนฺตรํ ส ปารํ คตฺวา คิเทรียเทศมฺ อุปสฺถิตวานฺ; ตทา เทฺวา ภูตคฺรสฺตมนุเชา ศฺมศานสฺถานาทฺ พหิ รฺภูตฺวา ตํ สากฺษาตฺ กฺฤตวนฺเตา, ตาเวตาทฺฤเศา ปฺรจณฺฑาวาสฺตำ ยตฺ เตน สฺถาเนน โกปิ ยาตุํ นาศกฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ตาวุไจ: กถยามาสตุ:, เห อีศฺวรสฺย สูโน ยีโศ, ตฺวยา สากมฺ อาวโย: ก: สมฺพนฺธ:? นิรูปิตกาลาตฺ ปฺราเคว กิมาวาภฺยำ ยาตนำ ทาตุมฺ อตฺราคโตสิ? ");
INSERT INTO santha_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ตทานีํ ตาภฺยำ กิญฺจิทฺ ทูเร วราหาณามฺ เอโก มหาวฺรโช'จรตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ตโต ภูเตา เตา ตสฺยานฺติเก วินีย กถยามาสตุ:, ยทฺยาวำ ตฺยาชยสิ, ตรฺหิ วราหาณำ มเธฺยวฺรชมฺ อาวำ เปฺรรยฯ ");
INSERT INTO santha_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ตทา ยีศุรวทตฺ ยาตํ, อนนฺตรํ เตา ยทา มนุเชา วิหาย วราหานฺ อาศฺริตวนฺเตา, ตทา เต สรฺเวฺว วราหา อุจฺจสฺถานาตฺ มหาชเวน ธาวนฺต: สาครียโตเย มชฺชนฺโต มมฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ตโต วราหรกฺษกา: ปลายมานา มเธฺยนครํ เตา ภูตคฺรเสฺตา ปฺรติ ยทฺยทฺ อฆฏต, ตา: สรฺวฺววารฺตฺตา อวทนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ตโต นาคริกา: สรฺเวฺว มนุชา ยีศุํ สากฺษาตฺ กรฺตฺตุํ พหิรายาตา: ตญฺจ วิโลกฺย ปฺรารฺถยาญฺจกฺริเร ภวานฺ อสฺมากํ สีมาโต ยาตุฯ ");
INSERT INTO santha_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","อนนฺตรํ ยีศุ เรฺนากามารุหฺย ปุน: ปารมาคตฺย นิชคฺรามมฺ อายเยาฯ ");
INSERT INTO santha_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ตต: กติปยา ชนา เอกํ ปกฺษาฆาตินํ สฺวฏฺโฏปริ ศายยิตฺวา ตตฺสมีปมฺ อานยนฺ; ตโต ยีศุเสฺตษำ ปฺรตีตึ วิชฺญาย ตํ ปกฺษาฆาตินํ ชคาท, เห ปุตฺร, สุสฺถิโร ภว, ตว กลุษสฺย มรฺษณํ ชาตมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ตำ กถำ นิศมฺย กิยนฺต อุปาธฺยายา มน:สุ จินฺติตวนฺต เอษ มนุช อีศฺวรํ นินฺทติฯ ");
INSERT INTO santha_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ตต: ส เตษามฺ เอตาทฺฤศีํ จินฺตำ วิชฺญาย กถิตวานฺ, ยูยํ มน:สุ กฺฤต เอตาทฺฤศีํ กุจินฺตำ กุรุถ? ");
INSERT INTO santha_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ตว ปาปมรฺษณํ ชาตํ, ยทฺวา ตฺวมุตฺถาย คจฺฉ, ทฺวโยรนโย รฺวากฺยโย: กึ วากฺยํ วกฺตุํ สุคมํ? ");
INSERT INTO santha_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","กินฺตุ เมทินฺยำ กลุษํ กฺษมิตุํ มนุชสุตสฺย สามรฺถฺยมสฺตีติ ยูยํ ยถา ชานีถ, ตทรฺถํ ส ตํ ปกฺษาฆาตินํ คทิตวานฺ, อุตฺติษฺฐ, นิชศยนียํ อาทาย เคหํ คจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ตต: ส ตตฺกฺษณาทฺ อุตฺถาย นิชเคหํ ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","มานวา อิตฺถํ วิโลกฺย วิสฺมยํ เมนิเร, อีศฺวเรณ มานวาย สามรฺถฺยมฺ อีทฺฤศํ ทตฺตํ อิติ การณาตฺ ตํ ธนฺยํ พภาษิเร จฯ ");
INSERT INTO santha_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","อนนฺตรํ ยีศุสฺตตฺสฺถานาทฺ คจฺฉนฺ คจฺฉนฺ กรสํคฺรหสฺถาเน สมุปวิษฺฏํ มถินามานมฺ เอกํ มนุชํ วิโลกฺย ตํ พภาเษ, มม ปศฺจาทฺ อาคจฺฉ, ตต: ส อุตฺถาย ตสฺย ปศฺจาทฺ ววฺราชฯ ");
INSERT INTO santha_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ตต: ปรํ ยีเศา คฺฤเห โภกฺตุมฺ อุปวิษฺเฏ พหว: กรสํคฺราหิณ: กลุษิณศฺจ มานวา อาคตฺย เตน สากํ ตสฺย ศิไษฺยศฺจ สากมฺ อุปวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ผิรูศินสฺตทฺ ทฺฤษฺฏฺวา ตสฺย ศิษฺยานฺ พภาษิเร, ยุษฺมากํ คุรุ: กึ นิมิตฺตํ กรสํคฺราหิภิ: กลุษิภิศฺจ สากํ ภุํกฺเต? ");
INSERT INTO santha_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ยีศุสฺตตฺ ศฺรุตฺวา ตานฺ ปฺรตฺยวทตฺ, นิรามยโลกานำ จิกิตฺสเกน ปฺรโยชนํ นาสฺติ, กินฺตุ สามยโลกานำ ปฺรโยชนมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","อโต ยูยํ ยาตฺวา วจนสฺยาสฺยารฺถํ ศิกฺษธฺวมฺ, ทยายำ เม ยถา ปฺรีติ รฺน ตถา ยชฺญกรฺมฺมณิฯ ยโต'หํ ธารฺมฺมิกานฺ อาหฺวาตุํ นาคโต'สฺมิ กินฺตุ มน: ปริวรฺตฺตยิตุํ ปาปิน อาหฺวาตุมฺ อาคโต'สฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","อนนฺตรํ โยหน: ศิษฺยาสฺตสฺย สมีปมฺ อาคตฺย กถยามาสุ:, ผิรูศิโน วยญฺจ ปุน: ปุนรุปวสาม:, กินฺตุ ตว ศิษฺยา โนปวสนฺติ, กุต:? ");
INSERT INTO santha_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ตทา ยีศุสฺตานฺ อโวจตฺ ยาวตฺ สขีนำ สํงฺเค กนฺยายา วรสฺติษฺฐติ, ตาวตฺ กึ เต วิลาปํ กรฺตฺตุํ ศกฺลุวนฺติ? กินฺตุ ยทา เตษำ สํงฺคาทฺ วรํ นยนฺติ, ตาทฺฤศ: สมย อาคมิษฺยติ, ตทา เต อุปวตฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ปุราตนวสเน โกปิ นวีนวสฺตฺรํ น โยชยติ, ยสฺมาตฺ เตน โยชิเตน ปุราตนวสนํ ฉินตฺติ ตจฺฉิทฺรญฺจ พหุกุตฺสิตํ ทฺฤศฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","อนฺยญฺจ ปุราตนกุตฺวำ โกปิ นวานโคสฺตนีรสํ น นิทธาติ, ยสฺมาตฺ ตถา กฺฤเต กุตู รฺวิทีรฺยฺยเต เตน โคสฺตนีรส: ปตติ กุตูศฺจ นศฺยติ; ตสฺมาตฺ นวีนายำ กุตฺวำ นวีโน โคสฺตนีรส: สฺถาปฺยเต, เตน ทฺวโยรวนํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","อปรํ เตไนตตฺกถากถนกาเล เอโก'ธิปติสฺตํ ปฺรณมฺย พภาเษ, มม ทุหิตา ปฺราเยไณตาวตฺกาเล มฺฤตา, ตสฺมาทฺ ภวานาคตฺย ตสฺยา คาเตฺร หสฺตมรฺปยตุ, เตน สา ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ตทานีํ ยีศุ: ศิไษฺย: สากมฺ อุตฺถาย ตสฺย ปศฺจาทฺ ววฺราชฯ ");
INSERT INTO santha_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","อิตฺยนนฺตเร ทฺวาทศวตฺสรานฺ ยาวตฺ ปฺรทรามเยน ศีรฺไณกา นารี ตสฺย ปศฺจาทฺ อาคตฺย ตสฺย วสนสฺย คฺรนฺถึ ปสฺปรฺศ; ");
INSERT INTO santha_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ยสฺมาตฺ มยา เกวลํ ตสฺย วสนํ สฺปฺฤษฺฏฺวา สฺวาสฺถฺยํ ปฺราปฺสฺยเต, สา นารีติ มนสิ นิศฺจิตวตีฯ ");
INSERT INTO santha_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ตโต ยีศุรฺวทนํ ปราวรฺตฺตฺย ตำ ชคาท, เห กเนฺย, ตฺวํ สุสฺถิรา ภว, ตว วิศฺวาสสฺตฺวำ สฺวสฺถามการฺษีตฺฯ เอตทฺวาเกฺย คทิเตอว สา โยษิตฺ สฺวสฺถาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","อปรํ ยีศุสฺตสฺยาธฺยกฺษสฺย เคหํ คตฺวา วาทกปฺรภฺฤตีนฺ พหูนฺ โลกานฺ ศพฺทายมานานฺ วิโลกฺย ตานฺ อวทตฺ, ");
INSERT INTO santha_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ปนฺถานํ ตฺยช, กเนฺยยํ นามฺริยต นิทฺริตาเสฺต; กถาเมตำ ศฺรุตฺวา เต ตมุปชหสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","กินฺตุ สรฺเวฺวษุ พหิษฺกฺฤเตษุ โส'ภฺยนฺตรํ คตฺวา กนฺยายา: กรํ ธฺฤตวานฺ, เตน โสทติษฺฐตฺ; ");
INSERT INTO santha_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ตตสฺตตฺกรฺมฺมโณ ยศ: กฺฤตฺสฺนํ ตํ เทศํ วฺยาปฺตวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ตต: ปรํ ยีศุสฺตสฺมาตฺ สฺถานาทฺ ยาตฺรำ จการ; ตทา เห ทายูท: สนฺตาน, อสฺมานฺ ทยสฺว, อิติ วทนฺเตา เทฺวา ชนาวนฺเธา โปฺรไจราหูยนฺเตา ตตฺปศฺจาทฺ ววฺรชตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ตโต ยีเศา เคหมธฺยํ ปฺรวิษฺฏํ ตาวปิ ตสฺย สมีปมฺ อุปสฺถิตวนฺเตา, ตทานีํ ส เตา ปฺฤษฺฏวานฺ กรฺมฺไมตตฺ กรฺตฺตุํ มม สามรฺถฺยมฺ อาเสฺต, ยุวำ กิมิติ ปฺรตีถ:? ตทา เตา ปฺรตฺยูจตุ:, สตฺยํ ปฺรโภฯ ");
INSERT INTO santha_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ตทานีํ ส ตโย โรฺลจนานิ สฺปฺฤศนฺ พภาเษ, ยุวโย: ปฺรตีตฺยนุสาราทฺ ยุวโย รฺมงฺคลํ ภูยาตฺฯ เตน ตตฺกฺษณาตฺ ตโย เรฺนตฺราณิ ปฺรสนฺนานฺยภวนฺ, ");
INSERT INTO santha_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ปศฺจาทฺ ยีศุเสฺตา ทฺฤฒมาชฺญาปฺย ชคาท, อวธตฺตมฺ เอตำ กถำ โกปิ มนุโช ม ชานียาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","กินฺตุ เตา ปฺรสฺถาย ตสฺมินฺ กฺฤตฺเสฺน เทเศ ตสฺย กีรฺตฺตึ ปฺรกาศยามาสตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","อปรํ เตา พหิรฺยาต เอตสฺมินฺนนฺตเร มนุชา เอกํ ภูตคฺรสฺตมูกํ ตสฺย สมีปมฺ อานีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","เตน ภูเต ตฺยาชิเต ส มูก: กถำ กถยิตุํ ปฺรารภต, เตน ชนา วิสฺมยํ วิชฺญาย กถยามาสุ:, อิสฺราเยโล วํเศ กทาปิ เนทฺฤคทฺฤศฺยต; ");
INSERT INTO santha_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","กินฺตุ ผิรูศิน: กถยาญฺจกฺรุ: ภูตาธิปตินา ส ภูตานฺ ตฺยาชยติฯ ");
INSERT INTO santha_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ตต: ปรํ ยีศุเสฺตษำ ภชนภวน อุปทิศนฺ ราชฺยสฺย สุสํวาทํ ปฺรจารยนฺ โลกานำ ยสฺย ย อามโย ยา จ ปีฑาสีตฺ, ตานฺ ศมยนฺ ศมยํศฺจ สรฺวฺวาณิ นคราณิ คฺรามำศฺจ พภฺรามฯ ");
INSERT INTO santha_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","อนฺยญฺจ มนุชานฺ วฺยากุลานฺ อรกฺษกเมษานิว จ ตฺยกฺตานฺ นิรีกฺษฺย เตษุ การุณิก: สนฺ ศิษฺยานฺ อวทตฺ, ");
INSERT INTO santha_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ศสฺยานิ ปฺรจุราณิ สนฺติ, กินฺตุ เฉตฺตาร: โสฺตกา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","เกฺษตฺรํ ปฺรตฺยปรานฺ เฉทกานฺ ปฺรเหตุํ ศสฺยสฺวามินํ ปฺรารฺถยธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","อนนฺตรํ ยีศุ รฺทฺวาทศศิษฺยานฺ อาหูยาเมธฺยภูตานฺ ตฺยาชยิตุํ สรฺวฺวปฺรการโรคานฺ ปีฑาศฺจ ศมยิตุํ เตภฺย: สามรฺถฺยมทาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","เตษำ ทฺวาทศเปฺรษฺยาณำ นามาเนฺยตานิฯ ปฺรถมํ ศิโมนฺ ยํ ปิตรํ วทนฺติ, ตต: ปรํ ตสฺย สหช อานฺทฺริย:, สิวทิยสฺย ปุโตฺร ยากูพฺ ");
INSERT INTO santha_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ตสฺย สหโช โยหนฺ; ผิลิปฺ พรฺถลมยฺ โถมา: กรสํคฺราหี มถิ:, อาลฺเผยปุโตฺร ยากูพฺ, ");
INSERT INTO santha_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","กินานีย: ศิโมนฺ, ย อีษฺกริโยตียยิหูทา: ขฺรีษฺฏํ ปรกเร'รฺปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","เอตานฺ ทฺวาทศศิษฺยานฺ ยีศุ: เปฺรษยนฺ อิตฺยาชฺญาปยตฺ, ยูยมฺ อนฺยเทศียานำ ปทวีํ เศมิโรณียานำ กิมปิ นครญฺจ น ปฺรวิเศฺย ");
INSERT INTO santha_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","อิสฺราเยลฺโคตฺรสฺย หาริตา เย เย เมษาเสฺตษาเมว สมีปํ ยาตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","คตฺวา คตฺวา สฺวรฺคสฺย ราชตฺวํ สวิธมภวตฺ, เอตำ กถำ ปฺรจารยตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","อามยคฺรสฺตานฺ สฺวสฺถานฺ กุรุต, กุษฺฐิน: ปริษฺกุรุต, มฺฤตโลกานฺ ชีวยต, ภูตานฺ ตฺยาชยต, วินา มูลฺยํ ยูยมฺ อลภธฺวํ วิไนว มูลฺยํ วิศฺราณยตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","กินฺตุ เสฺวษำ กฏิพนฺเธษุ สฺวรฺณรูปฺยตามฺราณำ กิมปิ น คฺฤหฺลีตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","อนฺยจฺจ ยาตฺราไย เจลสมฺปุฏํ วา ทฺวิตียวสนํ วา ปาทุเก วา ยษฺฏิ:, เอตานฺ มา คฺฤหฺลีต, ยต: การฺยฺยกฺฤตฺ ภรฺตฺตุํ โยโคฺย ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","อปรํ ยูยํ ยตฺ ปุรํ ยญฺจ คฺรามํ ปฺรวิศถ, ตตฺร โย ชโน โยคฺยปาตฺรํ ตมวคตฺย ยานกาลํ ยาวตฺ ตตฺร ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ยทา ยูยํ ตทฺเคหํ ปฺรวิศถ, ตทา ตมาศิษํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ยทิ ส โยคฺยปาตฺรํ ภวติ, ตรฺหิ ตตฺกลฺยาณํ ตไสฺม ภวิษฺยติ, โนเจตฺ สาศีรฺยุษฺมภฺยเมว ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","กินฺตุ เย ชนา ยุษฺมากมาติถฺยํ น วิทธติ ยุษฺมากํ กถาญฺจ น ศฺฤณฺวนฺติ เตษำ เคหาตฺ ปุราทฺวา ปฺรสฺถานกาเล สฺวปทูลี: ปาตยตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ยุษฺมานหํ ตถฺยํ วจฺมิ วิจารทิเน ตตฺปุรสฺย ทศาต: สิโทมโมราปุรโยรฺทศา สหฺยตรา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ปศฺยต, วฺฤกยูถมเธฺย เมษ: ยถาวิสฺตถา ยุษฺมาน ปฺรหิโณมิ, ตสฺมาทฺ ยูยมฺ อหิริว สตรฺกา: กโปตาอิวาหึสกา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","นฺฤภฺย: สาวธานา ภวต; ยตไสฺต รฺยูยํ ราชสํสทิ สมรฺปิษฺยเธฺว เตษำ ภชนเคเห ปฺรหาริษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ยูยํ มนฺนามเหโต: ศาสฺตฺฤณำ ราชฺญาญฺจ สมกฺษํ ตานนฺยเทศินศฺจาธิ สากฺษิตฺวารฺถมาเนษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","กินฺตฺวิตฺถํ สมรฺปิตา ยูยํ กถํ กิมุตฺตรํ วกฺษฺยถ ตตฺร มา จินฺตยต, ยตสฺตทา ยุษฺมาภิ รฺยทฺ วกฺตวฺยํ ตตฺ ตทฺทณฺเฑ ยุษฺมนฺมน: สุ สมุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ยสฺมาตฺ ตทา โย วกฺษฺยติ ส น ยูยํ กินฺตุ ยุษฺมากมนฺตรสฺถ: ปิตฺราตฺมาฯ ");
INSERT INTO santha_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","สหช: สหชํ ตาต: สุตญฺจ มฺฤเตา สมรฺปยิษฺยติ, อปตฺยาคิ สฺวสฺวปิโตฺรे รฺวิปกฺษีภูย เตา ฆาตยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","มนฺนมเหโต: สรฺเวฺว ชนา ยุษฺมานฺ ฤृตียิษฺยนฺเต, กินฺตุ ย: เศษํ ยาวทฺ ไธรฺยฺยํ ฆฺฤตฺวา สฺถาสฺยติ, ส ตฺรายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ไต รฺยทา ยูยเมกปุเร ตาฑิษฺยเธฺว, ตทา ยูยมนฺยปุรํ ปลายธฺวํ ยุษฺมานหํ ตถฺยํ วจฺมิ ยาวนฺมนุชสุโต ไนติ ตาวทฺ อิสฺราเยลฺเทศียสรฺวฺวนครภฺรมณํ สมาปยิตุํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","คุโร: ศิโษฺย น มหานฺ, ปฺรโภรฺทาโส น มหานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ยทิ ศิโษฺย นิชคุโร รฺทาสศฺจ สฺวปฺรโภ: สมาโน ภวติ ตรฺหิ ตทฺ ยเถษฺฏํฯ เจตฺไตรฺคฺฤหปติรฺภูตราช อุจฺยเต, ตรฺหิ ปริวารา: กึ ตถา น วกฺษฺยนฺเต? ");
INSERT INTO santha_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","กินฺตุ เตโภฺย ยูยํ มา พิภีต, ยโต ยนฺน ปฺรกาศิษฺยเต, ตาทฺฤกฺ ฉาทิตํ กิมปิ นาสฺติ, ยจฺจ น วฺยญฺจิษฺยเต, ตาทฺฤคฺ คุปฺตํ กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ยทหํ ยุษฺมานฺ ตมสิ วจฺมิ ตทฺ ยุษฺมาภิรฺทีปฺเตา กถฺยตำ; กรฺณาภฺยำ ยตฺ ศฺรูยเต ตทฺ เคโหปริ ปฺรจารฺยฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","เย กายํ หนฺตุํ ศกฺนุวนฺติ นาตฺมานํ, เตโภฺย มา ไภษฺฏ; ย: กายาตฺมาเนา นิรเย นาศยิตุํ, ศกฺโนติ, ตโต พิภีตฯ ");
INSERT INTO santha_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","เทฺวา จฏเกา กิเมกตามฺรมุทฺรยา น วิกฺรีเยเต? ตถาปิ ยุษฺมตฺตาตานุมตึ วินา เตษาเมโกปิ ภุวิ น ปตติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ยุษฺมจฺฉิรสำ สรฺวฺวกจา คณิตำ: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","อโต มา พิภีต, ยูยํ พหุจฏเกโภฺย พหุมูลฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","โย มนุชสากฺษานฺมามงฺคีกุรุเต ตมหํ สฺวรฺคสฺถตาตสากฺษาทงฺคีกริเษฺยฯ ");
INSERT INTO santha_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ปฺฤถฺวฺยามหํ ศานฺตึ ทาตุมาคตอิติ มานุภวต, ศานฺตึ ทาตุํ น กินฺตฺวสึฯ ");
INSERT INTO santha_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ปิตฺฤมาตฺฤศฺจศฺรูภิ: สากํ สุตสุตาพธู รฺวิโรธยิตุญฺจาคเตाสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ตต: สฺวสฺวปริวาเรอว นฺฤศตฺรุ รฺภวิตาฯ ");
INSERT INTO santha_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ย: ปิตริ มาตริ วา มตฺโตธิกํ ปฺรียเต, ส น มทรฺห:; ");
INSERT INTO santha_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ยศฺจ สุเต สุตายำ วา มตฺโตธิกํ ปฺรียเต, เสाปิ น มทรฺห:ฯ ");
INSERT INTO santha_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ย: สฺวกฺรุศํ คฺฤหฺลนฺ มตฺปศฺจานฺไนติ, เสाปิ น มทรฺห:ฯ ");
INSERT INTO santha_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ย: สฺวปฺราณานวติ, ส ตานฺ หารยิษฺยเต, ยสฺตุ มตฺกฺฤเต สฺวปฺราณานฺ หารยติ, ส ตานวติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","โย ยุษฺมากมาติถฺยํ วิทธาติ, ส มมาติถฺยํ วิทธาติ, ยศฺจ มมาติถฺยํ วิทธาติ, ส มตฺเปฺรรกสฺยาติถฺยํ วิทธาติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","โย ภวิษฺยทฺวาทีติ ชฺญาตฺวา ตสฺยาติถฺยํ วิธตฺเต, ส ภวิษฺยทฺวาทิน: ผลํ ลปฺสฺยเต, ยศฺจ ธารฺมฺมิก อิติ วิทิตฺวา ตสฺยาติถฺยํ วิธตฺเต ส ธารฺมฺมิกมานวสฺย ผลํ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ยศฺจ กศฺจิตฺ เอเตษำ กฺษุทฺรนราณามฺ ยํ กญฺจไนกํ ศิษฺย อิติ วิทิตฺวา กํไสกํ ศีตลสลิลํ ตไสฺม ทตฺเต, ยุษฺมานหํ ตถฺยํ วทามิ, ส เกนาปิ ปฺรกาเรณ ผเลน น วญฺจิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","อิตฺถํ ยีศุ: สฺวทฺวาทศศิษฺยาณามาชฺญาปนํ สมาปฺย ปุเร ปุร อุปเทษฺฏุํ สุสํวาทํ ปฺรจารยิตุํ ตตฺสฺถานาตฺ ปฺรตเสฺถฯ ");
INSERT INTO santha_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","อนนฺตรํ โยหนฺ การายำ ติษฺฐนฺ ขฺริษฺฏสฺย กรฺมฺมณำ วารฺตฺตํ ปฺราปฺย ยสฺยาคมนวารฺตฺตาสีตฺ เสอว กึ ตฺวํ? วา วยมนฺยมฺ อเปกฺษิษฺยามเห? ");
INSERT INTO santha_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","เอตตฺ ปฺรษฺฏุํ นิเชา เทฺวา ศิเษฺยา ปฺราหิโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ยีศุ: ปฺรตฺยโวจตฺ, อนฺธา เนตฺราณิ ลภนฺเต, ขญฺจา คจฺฉนฺติ, กุษฺฐิน: สฺวสฺถา ภวนฺติ, พธิรา: ศฺฤณฺวนฺติ, มฺฤตา ชีวนฺต อุตฺติษฺฐนฺติ, ทริทฺราณำ สมีเป สุสํวาท: ปฺรจารฺยฺยต, ");
INSERT INTO santha_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","เอตานิ ยทฺยทฺ ยุวำ ศฺฤณุถ: ปศฺยถศฺจ คตฺวา ตทฺวารฺตฺตำ โยหนํ คทตํฯ ");
INSERT INTO santha_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ยสฺยาหํ น วิฆฺนีภวามิ, เสอว ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","อนนฺตรํ ตโย: ปฺรสฺถิตโย รฺยีศุ โรฺยหนมฺ อุทฺทิศฺย ชนานฺ ชคาท, ยูยํ กึ ทฺรษฺฏุํ วหิรฺมเธฺยปฺรานฺตรมฺ อคจฺฉต? กึ วาเตน กมฺปิตํ นลํ? ");
INSERT INTO santha_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","วา กึ วีกฺษิตุํ วหิรฺคตวนฺต:? กึ ปริหิตสูกฺษฺมวสนํ มนุชเมกํ? ปศฺยต, เย สูกฺษฺมวสนานิ ปริทธติ, เต ราชธานฺยำ ติษฺฐนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ตรฺหิ ยูยํ กึ ทฺรษฺฏุํ พหิรคมต, กิเมกํ ภวิษฺยทฺวาทินํ? ตเทว สตฺยํฯ ยุษฺมานหํ วทามิ, ส ภวิษฺยทฺวาทิโนปิ มหานฺ; ");
INSERT INTO santha_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ยต:, ปศฺย สฺวกียทูโตยํ ตฺวทเคฺร เปฺรษฺยเต มยาฯ ส คตฺวา ตว ปนฺถานํ สฺมยกฺ ปริษฺกริษฺยติ๚ เอตทฺวจนํ ยมธิ ลิขิตมาเสฺต โส'ยํ โยหนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","อปรํ ยุษฺมานหํ ตถฺยํ พฺรวีมิ, มชฺชยิตุ โรฺยหน: เศฺรษฺฐ: โกปิ นารีโต นาชายต; ตถาปิ สฺวรฺคราชฺยมเธฺย สรฺเวฺวโภฺย ย: กฺษุทฺร: ส โยหน: เศฺรษฺฐ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","อปรญฺจ อา โยหโน'ทฺย ยาวตฺ สฺวรฺคราชฺยํ พลาทากฺรานฺตํ ภวติ อากฺรมินศฺจ ชนา พเลน ตทธิกุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ยโต โยหนํ ยาวตฺ สรฺวฺวภวิษฺยทฺวาทิภิ รฺวฺยวสฺถยา จ อุปเทศ: ปฺรากาศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ยทิ ยูยมิทํ วากฺยํ คฺรหีตุํ ศกฺนุถ, ตรฺหิ เศฺรย:, ยสฺยาคมนสฺย วจนมาเสฺต โส'ยมฺ เอลิย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ยสฺย โศฺรตุํ กรฺเณา สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","เอเต วิทฺยมานชนา: ไก รฺมโยปมียนฺเต? เย พาลกา หฏฺฏ อุปวิศฺย สฺวํ สฺวํ พนฺธุมาหูย วทนฺติ, ");
INSERT INTO santha_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","วยํ ยุษฺมากํ สมีเป วํศีรวาทยาม, กินฺตุ ยูยํ นานฺฤตฺยต; ยุษฺมากํ สมีเป จ วยมโรทิม, กินฺตุ ยูยํ น วฺยลปต, ตาทฺฤไศ รฺพาลไกสฺต อุปมายิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ยโต โยหนฺ อาคตฺย น ภุกฺตวานฺ น ปีตวำศฺจ, เตน โลกา วทนฺติ, ส ภูตคฺรสฺต อิติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","มนุชสุต อาคตฺย ภุกฺตวานฺ ปีตวำศฺจ, เตน โลกา วทนฺติ, ปศฺยต เอษ โภกฺตา มทฺยปาตา จณฺฑาลปาปินำ พนฺธศฺจ, กินฺตุ ชฺญานิโน ชฺญานวฺยวหารํ นิรฺโทษํ ชานนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ส ยตฺร ยตฺร ปุเร พหฺวาศฺจรฺยฺยํ กรฺมฺม กฺฤตวานฺ, ตนฺนิวาสินำ มน:ปราวฺฤตฺตฺยภาวาตฺ ตานิ นคราณิ ปฺรติ หนฺเตตฺยุกฺตา กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","หา โกราสีนฺ, หา ไพตฺไสเท, ยุษฺมนฺมเธฺย ยทฺยทาศฺจรฺยฺยํ กรฺมฺม กฺฤตํ ยทิ ตตฺ โสรสีโทนฺนคร อการิษฺยต, ตรฺหิ ปูรฺวฺวเมว ตนฺนิวาสิน: ศาณวสเน ภสฺมนิ โจปวิศนฺโต มนำสิ ปราวรฺตฺติษฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ตสฺมาทหํ ยุษฺมานฺ วทามิ, วิจารทิเน ยุษฺมากํ ทศาต: โสรสีโทโน รฺทศา สหฺยตรา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","อปรญฺจ พต กผรฺนาหูมฺ, ตฺวํ สฺวรฺคํ ยาวทุนฺนโตสิ, กินฺตุ นรเก นิกฺเษปฺสฺยเส, ยสฺมาตฺ ตฺวยิ ยานฺยาศฺจรฺยฺยาณิ กรฺมฺมณฺยการิษต, ยทิ ตานิ สิโทมฺนคร อการิษฺยนฺต, ตรฺหิ ตททฺย ยาวทสฺถาสฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","กินฺตฺวหํ ยุษฺมานฺ วทามิ, วิจารทิเน ตว ทณฺฑต: สิโทโม ทณฺโฑ สหฺยตโร ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","เอตสฺมินฺเนว สมเย ยีศุ: ปุนรุวาจ, เห สฺวรฺคปฺฤถิโวฺยเรกาธิปเต ปิตสฺตฺวํ ชฺญานวโต วิทุษศฺจ โลกานฺ ปฺรเตฺยตานิ น ปฺรกาศฺย พาลกานฺ ปฺรติ ปฺรกาศิตวานฺ, อิติ เหโตสฺตฺวำ ธนฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","เห ปิต:, อิตฺถํ ภเวตฺ ยต อิทํ ตฺวทฺฤษฺฏาวุตฺตมํฯ ");
INSERT INTO santha_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ปิตฺรา มยิ สรฺวฺวาณิ สมรฺปิตานิ, ปิตรํ วินา โกปิ ปุตฺรํ น ชานาติ, ยานฺ ปฺรติ ปุเตฺรณ ปิตา ปฺรกาศฺยเต ตานฺ วินา ปุตฺราทฺ อนฺย: โกปิ ปิตรํ น ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","เห ปริศฺรานฺตา ภารากฺรานฺตาศฺจ โลกา ยูยํ มตฺสนฺนิธิมฺ อาคจฺฉต, อหํ ยุษฺมานฺ วิศฺรมยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","อหํ กฺษมณศีโล นมฺรมนาศฺจ, ตสฺมาตฺ มม ยุคํ เสฺวษามุปริ ธารยต มตฺต: ศิกฺษธฺวญฺจ, เตน ยูยํ เสฺว เสฺว มนสิ วิศฺรามํ ลปฺสฺยทฺเหฺพฯ ");
INSERT INTO santha_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ยโต มม ยุคมฺ อนายาสํ มม ภารศฺจ ลฆุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","อนนฺตรํ ยีศุ รฺวิศฺรามวาเร ศฺสฺยมเธฺยน คจฺฉติ, ตทา ตจฺฉิษฺยา พุภุกฺษิตา: สนฺต: ศฺสฺยมญฺชรีศฺฉตฺวา ฉิตฺวา ขาทิตุมารภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ตทฺ วิโลกฺย ผิรูศิโน ยีศุํ ชคทุ:, ปศฺย วิศฺรามวาเร ยตฺ กรฺมฺมากรฺตฺตวฺยํ ตเทว ตว ศิษฺยา: กุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ส ตานฺ ปฺรตฺยาวทต, ทายูทฺ ตตฺสงฺคินศฺจ พุภุกฺษิตา: สนฺโต ยตฺ กรฺมฺมากุรฺวฺวนฺ ตตฺ กึ ยุษฺมาภิ รฺนาปาฐิ? ");
INSERT INTO santha_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","เย ทรฺศนียา: ปูปา: ยาชกานฺ วินา ตสฺย ตตฺสงฺคิมนุชานาญฺจาโภชนียาสฺต อีศฺวราวาสํ ปฺรวิษฺเฏน เตน ภุกฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","อนฺยจฺจ วิศฺรามวาเร มเธฺยมนฺทิรํ วิศฺรามวารียํ นิยมํ ลงฺวนฺโตปิ ยาชกา นิรฺโทษา ภวนฺติ, ศาสฺตฺรมเธฺย กิมิทมปิ ยุษฺมาภิ รฺน ปฐิตํ? ");
INSERT INTO santha_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ยุษฺมานหํ วทามิ, อตฺร สฺถาเน มนฺทิราทปิ ครียานฺ เอก อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","กินฺตุ ทยายำ เม ยถา ปฺรีติ รฺน ตถา ยชฺญกรฺมฺมณิฯ เอตทฺวจนสฺยารฺถํ ยทิ ยุยมฺ อชฺญาสิษฺฏ ตรฺหิ นิรฺโทษานฺ โทษิโณ นาการฺษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","อนฺยจฺจ มนุชสุโต วิศฺรามวารสฺยาปิ ปติราเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","อนนฺตรํ ส ตตฺสฺถานาตฺ ปฺรสฺถาย เตษำ ภชนภวนํ ปฺรวิษฺฏวานฺ, ตทานีมฺ เอก: ศุษฺกกรามยวานฺ อุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ตโต ยีศุมฺ อปวทิตุํ มานุษา: ปปฺรจฺฉุ:, วิศฺรามวาเร นิรามยตฺวํ กรณียํ น วา? ");
INSERT INTO santha_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","เตน ส ปฺรตฺยุวาจ, วิศฺรามวาเร ยทิ กสฺยจิทฺ อวิ รฺครฺตฺเต ปตติ, ตรฺหิ ยสฺตํ ฆฺฤตฺวา น โตลยติ, เอตาทฺฤโศ มนุโช ยุษฺมากํ มเธฺย ก อาเสฺต? ");
INSERT INTO santha_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","อเว รฺมานว: กึ นหิ เศฺรยานฺ? อโต วิศฺรามวาเร หิตกรฺมฺม กรฺตฺตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","อนนฺตรํ ส ตํ มานวํ คทิตวานฺ, กรํ ปฺรสารย; เตน กเร ปฺรสาริเต โสนฺยกรวตฺ สฺวโสฺถ'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ตทา ผิรูศิโน พหิรฺภูย กถํ ตํ หนิษฺยาม อิติ กุมนฺตฺรณำ ตตฺปฺราติกูเลฺยน จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ตโต ยีศุสฺตทฺ วิทิตฺวา สฺถนานฺตรํ คตวานฺ; อเนฺยษุ พหุนเรษุ ตตฺปศฺจาทฺ คเตษุ ตานฺ ส นิรามยานฺ กฺฤตฺวา อิตฺยาชฺญาปยตฺ, ");
INSERT INTO santha_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ยูยํ มำ น ปริจายยตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ตสฺมาตฺ มม ปฺรีโย มโนนีโต มนสสฺตุษฺฏิการก:ฯ มทีย: เสวโก ยสฺตุ วิทฺยเต ตํ สมีกฺษตำฯ ตโสฺยปริ สฺวกียาตฺมา มยา สํสฺถาปยิษฺยเตฯ เตนานฺยเทศชาเตษุ วฺยวสฺถา สํปฺรกาศฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","เกนาปิ น วิโรธํ ส วิวาทญฺจ กริษฺยติฯ น จ ราชปเถ เตน วจนํ ศฺราวยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","วฺยวสฺถา จลิตา ยาวตฺ นหิ เตน กริษฺยเตฯ ตาวตฺ นโล วิทีรฺโณ'ปิ ภํกฺษฺยเต นหิ เตน จฯ ตถา สธูมวรฺตฺติญฺจ น ส นิรฺวฺวาปยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ปฺรตฺยาศาญฺจ กริษฺยนฺติ ตนฺนามฺนิ ภินฺนเทศชา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ยาเนฺยตานิ วจนานิ ยิศยิยภวิษฺยทฺวาทินา โปฺรกฺตานฺยาสนฺ, ตานิ สผลานฺยภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","อนนฺตรํ โลไก สฺตตฺสมีปมฺ อานีโต ภูตคฺรสฺตานฺธมูไกกมนุชเสฺตน สฺวสฺถีกฺฤต:, ตต: โส'โนฺธ มูโก ทฺรษฺฏุํ วกฺตุญฺจารพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","อเนน สรฺเวฺว วิสฺมิตา: กถยาญฺจกฺรุ:, เอษ: กึ ทายูท: สนฺตาโน นหิ? ");
INSERT INTO santha_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","กินฺตุ ผิรูศินสฺตตฺ ศฺรุตฺวา คทิตวนฺต:, พาลฺสิพูพฺนามฺโน ภูตราชสฺย สาหายฺยํ วินา นายํ ภูตานฺ ตฺยาชยติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ตทานีํ ยีศุเสฺตษามฺ อิติ มานสํ วิชฺญาย ตานฺ อวทตฺ กิญฺจน ราชฺยํ ยทิ สฺววิปกฺษาทฺ ภิทฺยเต, ตรฺหิ ตตฺ อุจฺฉิทฺยเต; ยจฺจ กิญฺจน นครํ วา คฺฤหํ สฺววิปกฺษาทฺ วิภิทฺยเต, ตตฺ สฺถาตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ตทฺวตฺ ศยตาโน ยทิ ศยตานํ พหิ: กฺฤตฺวา สฺววิปกฺษาตฺ ปฺฤถกฺ ปฺฤถกฺ ภวติ, ตรฺหิ ตสฺย ราชฺยํ เกน ปฺรกาเรณ สฺถาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","อหญฺจ ยทิ พาลฺสิพูพา ภูตานฺ ตฺยาชยามิ, ตรฺหิ ยุษฺมากํ สนฺตานา: เกน ภูตานฺ ตฺยาชยนฺติ? ตสฺมาทฺ ยุษฺมากมฺ เอตทฺวิจารยิตารสฺต เอว ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","กินฺตวหํ ยทีศฺวราตฺมนา ภูตานฺ ตฺยาชยามิ, ตรฺหีศฺวรสฺย ราชฺยํ ยุษฺมากํ สนฺนิธิมาคตวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","อนฺยญฺจ โกปิ พลวนฺต ชนํ ปฺรถมโต น พทฺวฺวา เกน ปฺรกาเรณ ตสฺย คฺฤหํ ปฺรวิศฺย ตทฺทฺรวฺยาทิ โลฐยิตุํ ศกฺโนติ? กินฺตุ ตตฺ กฺฤตฺวา ตทียคฺฤสฺย ทฺรวฺยาทิ โลฐยิตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ย: กศฺจิตฺ มม สฺวปกฺษีโย นหิ ส วิปกฺษีย อาเสฺต, ยศฺจ มยา สากํ น สํคฺฤหฺลาติ, ส วิกิรติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","อเตอว ยุษฺมานหํ วทามิ, มนุชานำ สรฺวฺวปฺรการปาปานำ นินฺทายาศฺจ มรฺษณํ ภวิตุํ ศกฺโนติ, กินฺตุ ปวิตฺรสฺยาตฺมโน วิรุทฺธนินฺทายา มรฺษณํ ภวิตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","โย มนุชสุตสฺย วิรุทฺธำ กถำ กถยติ, ตสฺยาปราธสฺย กฺษมา ภวิตุํ ศกฺโนติ, กินฺตุ ย: กศฺจิตฺ ปวิตฺรสฺยาตฺมโน วิรุทฺธำ กถำ กถยติ เนหโลเก น เปฺรตฺย ตสฺยาปราธสฺย กฺษมา ภวิตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ปาทปํ ยทิ ภทฺรํ วทถ, ตรฺหิ ตสฺย ผลมปิ สาธุ วกฺตวฺยํ, ยทิ จ ปาทปํ อสาธุํ วทถ, ตรฺหิ ตสฺย ผลมปฺยสาธุ วกฺตวฺยํ; ยต: สฺวียสฺวียผเลน ปาทป: ปริจียเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","เร ภุชควํศา ยูยมสาธว: สนฺต: กถํ สาธุ วากฺยํ วกฺตุํ ศกฺษฺยถ? ยสฺมาทฺ อนฺต:กรณสฺย ปูรฺณภาวานุสาราทฺ วทนาทฺ วโจ นิรฺคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","เตน สาธุรฺมานโว'นฺต:กรณรูปาตฺ สาธุภาณฺฑาคาราตฺ สาธุ ทฺรวฺยํ นิรฺคมยติ, อสาธุรฺมานุษสฺตฺวสาธุภาณฺฑาคาราทฺ อสาธุวสฺตูนิ นิรฺคมยติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","กินฺตฺวหํ ยุษฺมานฺ วทามิ, มนุชา ยาวนฺตฺยาลสฺยวจำสิ วทนฺติ, วิจารทิเน ตทุตฺตรมวศฺยํ ทาตวฺยํ, ");
INSERT INTO santha_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ยตสฺตฺวํ สฺวียวโจภิ รฺนิรปราธ: สฺวียวโจภิศฺจ สาปราโธ คณิษฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ตทานีํ กติปยา อุปาธฺยายา: ผิรูศินศฺจ ชคทุ:, เห คุโร วยํ ภวตฺต: กิญฺจน ลกฺษฺม ทิทฺฤกฺษาม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ตทา ส ปฺรตฺยุกฺตวานฺ, ทุษฺโฏ วฺยภิจารี จ วํโศ ลกฺษฺม มฺฤคยเต, กินฺตุ ภวิษฺยทฺวาทิโน ยูนโส ลกฺษฺม วิหายานฺยตฺ กิมปิ ลกฺษฺม เต น ปฺรทรฺศยิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ยโต ยูนมฺ ยถา ตฺรฺยโหราตฺรํ พฺฤหนฺมีนสฺย กุกฺษาวาสีตฺ, ตถา มนุชปุโตฺรปิ ตฺรฺยโหราตฺรํ เมทินฺยา มเธฺย สฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","อปรํ นีนิวียา มานวา วิจารทิน เอตทฺวํศียานำ ปฺรติกูลมฺ อุตฺถาย ตานฺ โทษิณ: กริษฺยนฺติ, ยสฺมาตฺเต ยูนส อุปเทศาตฺ มนำสิ ปราวรฺตฺตยาญฺจกฺริเร, กินฺตฺวตฺร ยูนโสปิ คุรุตร เอก อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ปุนศฺจ ทกฺษิณเทศียา ราชฺญี วิจารทิน เอตทฺวํศียานำ ปฺรติกูลมุตฺถาย ตานฺ โทษิณ: กริษฺยติ ยต: สา ราชฺญี สุเลมโน วิทฺยายา: กถำ โศฺรตุํ เมทินฺยา: สีมฺน อาคจฺฉตฺ, กินฺตุ สุเลมโนปิ คุรุตร เอโก ชโน'ตฺร อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","อปรํ มนุชาทฺ พหิรฺคโต 'ปวิตฺรภูต: ศุษฺกสฺถาเนน คตฺวา วิศฺรามํ คเวษยติ, กินฺตุ ตทลภมาน: ส วกฺติ, ยสฺมา; นิเกตนาทฺ อาคมํ, ตเทว เวศฺม ปกาวฺฤตฺย ยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ปศฺจาตฺ ส ตตฺ สฺถานมฺ อุปสฺถาย ตตฺ ศูนฺยํ มารฺชฺชิตํ โศภิตญฺจ วิโลกฺย วฺรชนฺ สฺวโตปิ ทุษฺฏตรานฺ อนฺยสปฺตภูตานฺ สงฺคิน: กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ตตเสฺต ตตฺ สฺถานํ ปฺรวิศฺย นิวสนฺติ, เตน ตสฺย มนุชสฺย เศษทศา ปูรฺวฺวทศาโตตีวาศุภา ภวติ, เอเตษำ ทุษฺฏวํศฺยานามปิ ตไถว ฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","มานเวภฺย เอตาสำ กถนำ กถนกาเล ตสฺย มาตา สหชาศฺจ เตน สากํ กาญฺจิตฺ กถำ กถยิตุํ วาญฺฉนฺโต พหิเรว สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ตต: กศฺจิตฺ ตไสฺม กถิตวานฺ, ปศฺย ตว ชนนี สหชาศฺจ ตฺวยา สากํ กาญฺจน กถำ กถยิตุํ กามยมานา พหิสฺติษฺฐนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","กินฺตุ ส ตํ ปฺรตฺยวทตฺ, มม กา ชนนี? เก วา มม สหชา:? ");
INSERT INTO santha_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ปศฺจาตฺ ศิษฺยานฺ ปฺรติ กรํ ปฺรสารฺยฺย กถิตวานฺ, ปศฺย มม ชนนี มม สหชาศฺไจเต; ");
INSERT INTO santha_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ย: กศฺจิตฺ มม สฺวรฺคสฺถสฺย ปิตุริษฺฏํ กรฺมฺม กุรุเต, เสอว มม ภฺราตา ภคินี ชนนี จฯ ");
INSERT INTO santha_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","อปรญฺจ ตสฺมินฺ ทิเน ยีศุ: สทฺมโน คตฺวา สริตฺปเต โรธสิ สมุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ตตฺร ตตฺสนฺนิเธา พหุชนานำ นิวโหปสฺถิเต: ส ตรณิมารุหฺย สมุปาวิศตฺ, เตน มานวา โรธสิ สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ตทานีํ ส ทฺฤษฺฏานฺไตสฺตานฺ อิตฺถํ พหุศ อุปทิษฺฏวานฺฯ ปศฺยต, กศฺจิตฺ กฺฤษีวโล พีชานิ วปฺตุํ พหิรฺชคาม, ");
INSERT INTO santha_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ตสฺย วปนกาเล กติปยพีเชษุ มารฺคปารฺเศฺว ปติเตษุ วิหคาสฺตานิ ภกฺษิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","อปรํ กติปยพีเชษุ โสฺตกมฺฤทฺยุกฺตปาษาเณ ปติเตษุ มฺฤทลฺปตฺวาตฺ ตตฺกฺษณาตฺ ตานฺยงฺกุริตานิ, ");
INSERT INTO santha_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","กินฺตุ รวาวุทิเต ทคฺธานิ เตษำ มูลาปฺรวิษฺฏตฺวาตฺ ศุษฺกตำ คตานิ จฯ ");
INSERT INTO santha_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","อปรํ กติปยพีเชษุ กณฺฏกานำ มเธฺย ปติเตษุ กณฺฏกาเนฺยธิตฺวา ตานิ ชคฺรสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","อปรญฺจ กติปยพีชานิ อุรฺวฺวรายำ ปติตานิ; เตษำ มเธฺย กานิจิตฺ ศตคุณานิ กานิจิตฺ ษษฺฏิคุณานิ กานิจิตฺ ตฺรึศคุํณานิ ผลานิ ผลิตวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","โศฺรตุํ ยสฺย ศฺรุตี อาสาเต ส ศฺฤณุยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","อนนฺตรํ ศิไษฺยราคตฺย โส'ปฺฤจฺฉฺยต, ภวตา เตภฺย: กุโต ทฺฤษฺฏานฺตกถา กถฺยเต? ");
INSERT INTO santha_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ตต: ส ปฺรตฺยวทตฺ, สฺวรฺคราชฺยสฺย นิคูฒำ กถำ เวทิตุํ ยุษฺมภฺยํ สามรฺถฺยมทายิ, กินฺตุ เตโภฺย นาทายิฯ ");
INSERT INTO santha_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ยสฺมาทฺ ยสฺยานฺติเก วรฺทฺธเต, ตสฺมาเยว ทายิษฺยเต, ตสฺมาตฺ ตสฺย พาหุลฺยํ ภวิษฺยติ, กินฺตุ ยสฺยานฺติเก น วรฺทฺธเต, ตสฺย ยตฺ กิญฺจนาเสฺต, ตทปิ ตสฺมาทฺ อาทายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","เต ปศฺยนฺโตปิ น ปศฺยนฺติ, ศฺฤณฺวนฺโตปิ น ศฺฤณฺวนฺติ, พุธฺยมานา อปิ น พุธฺยนฺเต จ, ตสฺมาตฺ เตโภฺย ทฺฤษฺฏานฺตกถา กถฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ยถา กรฺไณ: โศฺรษฺยถ ยูยํ ไว กินฺตุ ยูยํ น โภตฺสฺยถฯ เนไตฺรรฺทฺรกฺษฺยถ ยูยญฺจ ปริชฺญาตุํ น ศกฺษฺยถฯ เต มานุษา ยถา ไนว ปริปศฺยนฺติ โลจไน:ฯ กรฺไณ รฺยถา น ศฺฤณฺวนฺติ น พุธฺยนฺเต จ มานไส:ฯ วฺยาวรฺตฺติเตษุ จิตฺเตษุ กาเล กุตฺราปิ ไตรฺชไน:ฯ มตฺตเสฺต มนุชา: สฺวสฺถา ยถา ไนว ภวนฺติ จฯ ตถา เตษำ มนุษฺยาณำ กฺริยนฺเต สฺถูลพุทฺธย:ฯ พธิรีภูตกรฺณาศฺจ ชาตาศฺจ มุทฺริตา ทฺฤศ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ยเทตานิ วจนานิ ยิศยิยภวิษฺยทฺวาทินา โปฺรกฺตานิ เตษุ ตานิ ผลนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","กินฺตุ ยุษฺมากํ นยนานิ ธนฺยานิ, ยสฺมาตฺ ตานิ วีกฺษนฺเต; ธนฺยาศฺจ ยุษฺมากํ ศพฺทคฺรหา:, ยสฺมาตฺ ไตรากรฺณฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","มยา ยูยํ ตถฺยํ วจามิ ยุษฺมาภิ รฺยทฺยทฺ วีกฺษฺยเต, ตทฺ พหโว ภวิษฺยทฺวาทิโน ธารฺมฺมิกาศฺจ มานวา ทิทฺฤกฺษนฺโตปิ ทฺรษฺฏุํ นาลภนฺต, ปุนศฺจ ยูยํ ยทฺยตฺ ศฺฤณุถ, ตตฺ เต ศุศฺรูษมาณา อปิ โศฺรตุํ นาลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","กฺฤษีวลียทฺฤษฺฏานฺตสฺยารฺถํ ศฺฤณุตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","มารฺคปารฺเศฺว พีชานฺยุปฺตานิ ตสฺยารฺถ เอษ:, ยทา กศฺจิตฺ ราชฺยสฺย กถำ นิศมฺย น พุธฺยเต, ตทา ปาปาตฺมาคตฺย ตทียมนส อุปฺตำ กถำ หรนฺ นยติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","อปรํ ปาษาณสฺถเล พีชานฺยุปฺตานิ ตสฺยารฺถ เอษ:; กศฺจิตฺ กถำ ศฺรุไตฺวว หรฺษจิตฺเตน คฺฤหฺลาติ, ");
INSERT INTO santha_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","กินฺตุ ตสฺย มนสิ มูลาปฺรวิษฺฏตฺวาตฺ ส กิญฺจิตฺกาลมาตฺรํ สฺถิรสฺติษฺฐติ; ปศฺจาต ตตฺกถาการณาตฺ โกปิ เกฺลสฺตาฑนา วา เจตฺ ชายเต, ตรฺหิ ส ตตฺกฺษณาทฺ วิฆฺนเมติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","อปรํ กณฺฏกานำ มเธฺย พีชานฺยุปฺตานิ ตทรฺถ เอษ:; เกนจิตฺ กถายำ ศฺรุตายำ สำสาริกจินฺตาภิ รฺภฺรานฺติภิศฺจ สา คฺรสฺยเต, เตน สา มา วิผลา ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","อปรมฺ อุรฺวฺวรายำ พีชานฺยุปฺตานิ ตทรฺถ เอษ:; เย ตำ กถำ ศฺรุตฺวา วุธฺยนฺเต, เต ผลิตา: สนฺต: เกจิตฺ ศตคุณานิ เกจิต ษษฺฏิคุณานิ เกจิจฺจ ตฺรึศทฺคุณานิ ผลานิ ชนยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","อนนฺตรํ โสปราเมกำ ทฺฤษฺฏานฺตกถามุปสฺถาปฺย เตภฺย: กถยามาส; สฺวรฺคียราชฺยํ ตาทฺฤเศน เกนจิทฺ คฺฤหเสฺถโนปมียเต, เยน สฺวียกฺเษเตฺร ปฺรศสฺตพีชาเนฺยาปฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","กินฺตุ กฺษณทายำ สกลโลเกษุ สุปฺเตษุ ตสฺย ริปุราคตฺย เตษำ โคธูมพีชานำ มเธฺย วนฺยยวมพีชานฺยุปฺตฺวา ววฺราชฯ ");
INSERT INTO santha_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ตโต ยทา พีเชโภฺย'งฺกรา ชายมานา: กณิศานิ ฆฺฤตวนฺต:; ตทา วนฺยยวสานฺยปิ ทฺฤศฺยมานานฺยภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ตโต คฺฤหสฺถสฺย ทาเสยา อาคมฺย ตไสฺม กถยาญฺจกฺรุ:, เห มเหจฺฉ, ภวตา กึ เกฺษเตฺร ภทฺรพีชานิ เนาปฺยนฺต? ตถาเตฺว วนฺยยวสานิ กฺฤต อายนฺ? ");
INSERT INTO santha_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ตทานีํ เตน เต ปฺรติคทิตา:, เกนจิตฺ ริปุณา กรฺมฺมทมการิฯ ทาเสยา: กถยามาสุ:, วยํ คตฺวา ตานฺยุตฺปายฺย กฺษิปาโม ภวต: กีทฺฤศีจฺฉา ชายเต? ");
INSERT INTO santha_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","เตนาวาทิ, นหิ, ศงฺเก'หํ วนฺยยวโสตฺปาฏนกาเล ยุษฺมาภิไสฺต: สากํ โคธูมา อปฺยุตฺปาฏิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","อต: ศฺสฺยกรฺตฺตนกาลํ ยาวทฺ อุภยานฺยปิ สห วรฺทฺธนฺตำ, ปศฺจาตฺ กรฺตฺตนกาเล กรฺตฺตกานฺ วกฺษฺยามิ, ยูยมาเทา วนฺยยวสานิ สํคฺฤหฺย ทาหยิตุํ วีฏิกา พทฺวฺวา สฺถาปยต; กินฺตุ สรฺเวฺว โคธูมา ยุษฺมาภิ รฺภาณฺฑาคารํ นีตฺวา สฺถาปฺยนฺตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","อนนฺตรํ โสปราเมกำ ทฺฤษฺฏานฺตกถามุตฺถาปฺย เตภฺย: กถิตวานฺ กศฺจินฺมนุช: สรฺษปพีชเมกํ นีตฺวา สฺวกฺเษตฺร อุวาปฯ ");
INSERT INTO santha_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","สรฺษปพีชํ สรฺวฺวสฺมาทฺ พีชาตฺ กฺษุทฺรมปิ สทงฺกุริตํ สรฺวฺวสฺมาตฺ ศากาตฺ พฺฤหทฺ ภวติ; ส ตาทฺฤศสฺตรุ รฺภวติ, ยสฺย ศาขาสุ นภส: ขคา อาคตฺย นิวสนฺติ; สฺวรฺคียราชฺยํ ตาทฺฤศสฺย สรฺษไปกสฺย สมมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ปุนรปิ ส อุปมากถาเมกำ เตภฺย: กถยาญฺจการ; กาจน โยษิตฺ ยตฺ กิณฺวมาทาย โทฺรณตฺรยมิตโคธูมจูรฺณานำ มเธฺย สรฺเวฺวษำ มิศฺรีภวนปรฺยฺยนฺตํ สมาจฺฉาทฺย นิธตฺตวตี, ตตฺกิณฺวมิว สฺวรฺคราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","อิตฺถํ ยีศุ รฺมนุชนิวหานำ สนฺนิธาวุปมากถาภิเรตานฺยาขฺยานานิ กถิตวานฺ อุปมำ วินา เตภฺย: กิมปิ กถำ นากถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","เอเตน ทฺฤษฺฏานฺตีเยน วาเกฺยน วฺยาทาย วทนํ นิชํฯ อหํ ปฺรกาศยิษฺยามิ คุปฺตวากฺยํ ปุราภวํฯ ยเทตทฺวจนํ ภวิษฺยทฺวาทินา โปฺรกฺตมาสีตฺ, ตตฺ สิทฺธมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","สรฺวฺวานฺ มนุชานฺ วิสฺฤชฺย ยีเศา คฺฤหํ ปฺรวิษฺเฏ ตจฺฉิษฺยา อาคตฺย ยีศเว กถิตวนฺต:, เกฺษตฺรสฺย วนฺยยวสียทฺฤษฺฏานฺตกถามฺ ภวาน อสฺมานฺ สฺปษฺฏีกฺฤตฺย วทตุฯ ");
INSERT INTO santha_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ตต: ส ปฺรตฺยุวาจ, เยน ภทฺรพีชานฺยุปฺยนฺเต ส มนุชปุตฺร:, ");
INSERT INTO santha_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","เกฺษตฺรํ ชคตฺ, ภทฺรพีชานี ราชฺยสฺย สนฺตานา:, ");
INSERT INTO santha_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","วนฺยยวสานิ ปาปาตฺมน: สนฺตานา:ฯ เยน ริปุณา ตานฺยุปฺตานิ ส ศยตาน:, กรฺตฺตนสมยศฺจ ชคต: เศษ:, กรฺตฺตกา: สฺวรฺคียทูตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ยถา วนฺยยวสานิ สํคฺฤหฺย ทาหฺยนฺเต, ตถา ชคต: เศเษ ภวิษฺยติ; ");
INSERT INTO santha_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","อรฺถาตฺ มนุชสุต: สฺวำยทูตานฺ เปฺรษยิษฺยติ, เตน เต จ ตสฺย ราชฺยาตฺ สรฺวฺวานฺ วิฆฺนการิโณ'ธารฺมฺมิกโลกำศฺจ สํคฺฤหฺย ");
INSERT INTO santha_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ยตฺร โรทนํ ทนฺตฆรฺษณญฺจ ภวติ, ตตฺราคฺนิกุณฺเฑ นิกฺเษปฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ตทานีํ ธารฺมฺมิกโลกา: เสฺวษำ ปิตู ราเชฺย ภาสฺกรอิว เตชสฺวิโน ภวิษฺยนฺติฯ โศฺรตุํ ยสฺย ศฺรุตี อาสาเต, ม ศฺฤณุยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","อปรญฺจ เกฺษตฺรมเธฺย นิธึ ปศฺยนฺ โย โคปยติ, ตต: ปรํ สานนฺโท คตฺวา สฺวียสรฺวฺวสฺวํ วิกฺรีย ตฺตกฺเษตฺรํ กฺรีณาติ, ส อิว สฺวรฺคราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","อนฺยญฺจ โย วณิกฺ อุตฺตมำ มุกฺตำ คเวษยนฺ ");
INSERT INTO santha_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","มหารฺฆำ มุกฺตำ วิโลกฺย นิชสรฺวฺวสฺวํ วิกฺรีย ตำ กฺรีณาติ, ส อิว สฺวรฺคราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ปุนศฺจ สมุโทฺร นิกฺษิปฺต: สรฺวฺวปฺรการมีนสํคฺราหฺยานายอิว สฺวรฺคราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ตสฺมินฺ อานาเย ปูรฺเณ ชนา ยถา โรธสฺยุตฺโตลฺย สมุปวิศฺย ปฺรศสฺตมีนานฺ สํคฺรหฺย ภาชเนษุ นิทธเต, กุตฺสิตานฺ นิกฺษิปนฺติ; ");
INSERT INTO santha_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ตไถว ชคต: เศเษ ภวิษฺยติ, ผลต: สฺวรฺคียทูตา อาคตฺย ปุณฺยวชฺชนานำ มธฺยาตฺ ปาปิน: ปฺฤถกฺ กฺฤตฺวา วหฺนิกุณฺเฑ นิกฺเษปฺสฺยนฺติ, ");
INSERT INTO santha_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ตตฺร โรทนํ ทนฺไต รฺทนฺตฆรฺษณญฺจ ภวิษฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ยีศุนา เต ปฺฤษฺฏา ยุษฺมาภิ: กิเมตานฺยาขฺยานานฺยพุธฺยนฺต? ตทา เต ปฺรตฺยวทนฺ, สตฺยํ ปฺรโภฯ ");
INSERT INTO santha_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ตทานีํ ส กถิตวานฺ, นิชภาณฺฑาคาราตฺ นวีนปุราตนานิ วสฺตูนิ นิรฺคมยติ โย คฺฤหสฺถ: ส อิว สฺวรฺคราชฺยมธิ ศิกฺษิตา: สฺวรฺว อุปเทษฺฏาร:ฯ ");
INSERT INTO santha_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","อนนฺตรํ ยีศุเรตา: สรฺวฺวา ทฺฤษฺฏานฺตกถา: สมาปฺย ตสฺมาตฺ สฺถานาตฺ ปฺรตเสฺถฯ อปรํ สฺวเทศมาคตฺย ชนานฺ ภชนภวน อุปทิษฺฏวานฺ; ");
INSERT INTO santha_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","เต วิสฺมยํ คตฺวา กถิตวนฺต เอตไสฺยตาทฺฤศํ ชฺญานมฺ อาศฺจรฺยฺยํ กรฺมฺม จ กสฺมาทฺ อชายต? ");
INSERT INTO santha_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","กิมยํ สูตฺรธารสฺย ปุโตฺร นหิ? เอตสฺย มาตุ รฺนาม จ กึ มริยมฺ นหิ? ยากุพฺ-ยูษผฺ-ศิโมนฺ-ยิหูทาศฺจ กิเมตสฺย ภฺราตโร นหิ? ");
INSERT INTO santha_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","เอตสฺย ภคินฺยศฺจ กิมสฺมากํ มเธฺย น สนฺติ? ตรฺหิ กสฺมาทยเมตานิ ลพฺธวานฺ? อิตฺถํ ส เตษำ วิฆฺนรูโป พภูว; ");
INSERT INTO santha_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ตโต ยีศุนา นิคทิตํ สฺวเทศียชนานำ มธฺยํ วินา ภวิษฺยทฺวาที กุตฺราปฺยนฺยตฺร นาสมฺมาโนฺย ภวตีฯ ");
INSERT INTO santha_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","เตษามวิศฺวาสเหโต: ส ตตฺร สฺถาเน พหฺวาศฺจรฺยฺยกรฺมฺมาณิ น กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ตทานีํ ราชา เหโรทฺ ยีโศ รฺยศ: ศฺรุตฺวา นิชทาเสยานฺ ชคาทฺ, ");
INSERT INTO santha_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","เอษ มชฺชยิตา โยหนฺ, ปฺรมิเตภยสฺตโสฺยตฺถานาตฺ เตเนตฺถมทฺภุตํ กรฺมฺม ปฺรกาศฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ปุรา เหโรทฺ นิชภฺราตุ: ผิลิโป ชายายา เหโรทียายา อนุโรธาทฺ โยหนํ ธารยิตฺวา พทฺธา การายำ สฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ยโต โยหนฺ อุกฺตวานฺ, เอตฺสยา: สํคฺรโห ภวโต โนจิต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ตสฺมาตฺ นฺฤปติสฺตํ หนฺตุมิจฺฉนฺนปิ โลเกโภฺย วิภยาญฺจการ; ยต: สรฺเวฺว โยหนํ ภวิษฺยทฺวาทินํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","กินฺตุ เหโรโท ชนฺมาหียมห อุปสฺถิเต เหโรทียายา ทุหิตา เตษำ สมกฺษํ นฺฤติตฺวา เหโรทมปฺรีณฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ตสฺมาตฺ ภูปติ: ศปถํ กุรฺวฺวนฺ อิติ ปฺรตฺยชฺญาสีตฺ, ตฺวยา ยทฺ ยาจฺยเต, ตเทวาหํ ทาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","สา กุมารี สฺวียมาตุ: ศิกฺษำ ลพฺธา พภาเษ, มชฺชยิตุโรฺยหน อุตฺตมางฺคํ ภาชเน สมานีย มหฺยํ วิศฺราณยฯ ");
INSERT INTO santha_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ตโต ราชา ศุโศจ, กินฺตุ โภชนาโยปวิศตำ สงฺคินำ สฺวกฺฤตศปถสฺย จานุโรธาตฺ ตตฺ ปฺรทาตุม อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ปศฺจาตฺ การำ ปฺรติ นรํ ปฺรหิตฺย โยหน อุตฺตมางฺคํ ฉิตฺตฺวา ");
INSERT INTO santha_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ตตฺ ภาชน อานายฺย ตไสฺย กุมารฺไยฺย วฺยศฺราณยตฺ, ตต: สา สฺวชนนฺยา: สมีปํ ตนฺนินายฯ ");
INSERT INTO santha_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ปศฺจาตฺ โยหน: ศิษฺยา อาคตฺย กายํ นีตฺวา ศฺมศาเน สฺถาปยามาสุสฺตโต ยีโศ: สนฺนิธึ วฺรชิตฺวา ตทฺวารฺตฺตำ พภาษิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","อนนฺตรํ ยีศุริติ นิศภฺย นาวา นิรฺชนสฺถานมฺ เอกากี คตวานฺ, ปศฺจาตฺ มานวาสฺตตฺ ศฺรุตฺวา นานานคเรภฺย อาคตฺย ปไทสฺตตฺปศฺจาทฺ อียุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ตทานีํ ยีศุ รฺพหิราคตฺย มหานฺตํ ชนนิวหํ นิรีกฺษฺย เตษุ การุณิก: มนฺ เตษำ ปีฑิตชนานฺ นิรามยานฺ จการฯ ");
INSERT INTO santha_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ตต: ปรํ สนฺธฺยายำ ศิษฺยาสฺตทนฺติกมาคตฺย กถยาญฺจกฺรุ:, อิทํ นิรฺชนสฺถานํ เวลาปฺยวสนฺนา; ตสฺมาตฺ มนุชานฺ สฺวสฺวคฺรามํ คนฺตุํ สฺวารฺถํ ภกฺษฺยาณิ เกฺรตุญฺจ ภวานฺ ตานฺ วิสฺฤชตุฯ ");
INSERT INTO santha_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","กินฺตุ ยีศุสฺตานวาทีตฺ, เตษำ คมเน ปฺรโยชนํ นาสฺติ, ยูยเมว ตานฺ โภชยตฯ ");
INSERT INTO santha_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ตทา เต ปฺรตฺยวทนฺ, อสฺมากมตฺร ปูปปญฺจกํ มีนทฺวยญฺจาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ตทานีํ เตโนกฺตํ ตานิ มทนฺติกมานยตฯ ");
INSERT INTO santha_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","อนนฺตรํ ส มนุชานฺ ยวโสปรฺยฺยุปเวษฺฏุมฺ อาชฺญาปยามาส; อปร ตตฺ ปูปปญฺจกํ มีนทฺวยญฺจ คฺฤหฺลนฺ สฺวรฺคํ ปฺรติ นิรีกฺเษฺยศฺวรียคุณานฺ อนูทฺย ภํกฺตฺวา ศิเษฺยโภฺย ทตฺตวานฺ, ศิษฺยาศฺจ โลเกโภฺย ททุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ตต: สรฺเวฺว ภุกฺตฺวา ปริตฺฤปฺตวนฺต:, ตตสฺตทวศิษฺฏภกฺไษฺย: ปูรฺณานฺ ทฺวาทศฑลกานฺ คฺฤหีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","เต โภกฺตาร: สฺตฺรีรฺพาลกำศฺจ วิหาย ปฺราเยณ ปญฺจ สหสฺราณิ ปุมำส อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ตทนนฺตรํ ยีศุ โรฺลกานำ วิสรฺชนกาเล ศิษฺยานฺ ตรณิมาโรฒุํ สฺวาเคฺร ปารํ ยาตุญฺจ คาฒมาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ตโต โลเกษุ วิสฺฤษฺเฏษุ ส วิวิกฺเต ปฺรารฺถยิตุํ คิริเมกํ คตฺวา สนฺธฺยำ ยาวตฺ ตไตฺรกากี สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","กินฺตุ ตทานีํ สมฺมุขวาตตฺวาตฺ สริตฺปเต รฺมเธฺย ตรงฺไคสฺตรณิรฺโทลายมานาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ตทา ส ยามินฺยาศฺจตุรฺถปฺรหเร ปทฺภฺยำ วฺรชนฺ เตษามนฺติกํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","กินฺตุ ศิษฺยาสฺตํ สาคโรปริ วฺรชนฺตํ วิโลกฺย สมุทฺวิคฺนา ชคทุ:, เอษ ภูต อิติ ศงฺกมานา อุจฺไจ: ศพฺทายาญฺจกฺริเร จฯ ");
INSERT INTO santha_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ตไทว ยีศุสฺตานวทตฺ, สุสฺถิรา ภวต, มา ไภษฺฏ, เอโษ'หมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ตต: ปิตร อิตฺยุกฺตวานฺ, เห ปฺรโภ, ยทิ ภวาเนว, ตรฺหิ มำ ภวตฺสมีปํ ยาตุมาชฺญาปยตุฯ ");
INSERT INTO santha_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ตต: เตนาทิษฺฏ: ปิตรสฺตรณิโต'วรุหฺย ยีเศाรนฺติกํ ปฺราปฺตุํ โตโยปริ ววฺราชฯ ");
INSERT INTO santha_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","กินฺตุ ปฺรจณฺฑํ ปวนํ วิโลกฺย ภยาตฺ โตเย มํกฺตุมฺ อาเรเภ, ตสฺมาทฺ อุจฺไจ: ศพฺทายมาน: กถิตวานฺ, เห ปฺรโภ, มามวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ยีศุสฺตตฺกฺษณาตฺ กรํ ปฺรสารฺยฺย ตํ ธรนฺ อุกฺตวานฺ, ห โสฺตกปฺรตฺยยินฺ ตฺวํ กุต: สมเศถา:? ");
INSERT INTO santha_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","อนนฺตรํ ตโยสฺตรณิมารูฒโย: ปวโน นิววฺฤเตฯ ");
INSERT INTO santha_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ตทานีํ เย ตรณฺยามาสนฺ, ต อาคตฺย ตํ ปฺรณภฺย กถิตวนฺต:, ยถารฺถสฺตฺวเมเวศฺวรสุต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","อนนฺตรํ ปารํ ปฺราปฺย เต คิเนษรนฺนามกํ นครมุปตสฺถุ:, ");
INSERT INTO santha_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ตทา ตตฺรตฺยา ชนา ยีศุํ ปริจีย ตทฺเทศฺสฺย จตุรฺทิโศ วารฺตฺตำ ปฺรหิตฺย ยตฺร ยาวนฺต: ปีฑิตา อาสนฺ, ตาวเตอว ตทนฺติกมานยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","อปรํ ตทียวสนสฺย คฺรนฺถิมาตฺรํ สฺปฺรษฺฏุํ วินีย ยาวนฺโต ชนาสฺตตฺ สฺปรฺศํ จกฺริเร, เต สรฺวฺเวอว นิรามยา พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","อปรํ ยิรูศาลมฺนครียา: กติปยา อธฺยาปกา: ผิรูศินศฺจ ยีโศ: สมีปมาคตฺย กถยามาสุ:, ");
INSERT INTO santha_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ตว ศิษฺยา: กิมรฺถมฺ อปฺรกฺษาลิตกไร รฺภกฺษิตฺวา ปรมฺปราคตํ ปฺราจีนานำ วฺยวหารํ ลงฺวนฺเต? ");
INSERT INTO santha_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ตโต ยีศุ: ปฺรตฺยุวาจ, ยูยํ ปรมฺปราคตาจาเรณ กุต อีศฺวราชฺญำ ลงฺวเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","อีศฺวร อิตฺยาชฺญาปยตฺ, ตฺวํ นิชปิตเรา สํมเนฺยถา:, เยน จ นิชปิตเรา นินฺเทฺยเต, ส นิศฺจิตํ มฺริเยต; ");
INSERT INTO santha_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","กินฺตุ ยูยํ วทถ, ย: สฺวชนกํ สฺวชนนีํ วา วากฺยมิทํ วทติ, ยุวำ มตฺโต ยลฺลเภเถ, ตตฺ นฺยวิทฺยต, ");
INSERT INTO santha_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ส นิชปิตเรา ปุน รฺน สํมํสฺยเตฯ อิตฺถํ ยูยํ ปรมฺปราคเตน เสฺวษามาจาเรเณศฺวรียาชฺญำ ลุมฺปถฯ ");
INSERT INTO santha_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","เร กปฏิน: สรฺเวฺว ยิศยิโย ยุษฺมานธิ ภวิษฺยทฺวจนาเนฺยตานิ สมฺยคฺ อุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","วทไน รฺมนุชา เอเต สมายานฺติ มทนฺติกํฯ ตถาธไร รฺมทียญฺจ มานํ กุรฺวฺวนฺติ เต นรา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","กินฺตุ เตษำ มโน มตฺโต วิทูเรอว ติษฺฐติฯ ศิกฺษยนฺโต วิธีนฺ นฺราชฺญา ภชนฺเต มำ มุไธว เตฯ ");
INSERT INTO santha_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ตโต ยีศุ โรฺลกานฺ อาหูย โปฺรกฺตวานฺ, ยูยํ ศฺรุตฺวา พุธฺยธฺพํฯ ");
INSERT INTO santha_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ยนฺมุขํ ปฺรวิศติ, ตตฺ มนุชมฺ อเมธฺยํ น กโรติ, กินฺตุ ยทาสฺยาตฺ นิรฺคจฺฉติ, ตเทว มานุษมเมธฺยี กโรตีฯ ");
INSERT INTO santha_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ตทานีํ ศิษฺยา อาคตฺย ตไสฺม กถยาญฺจกฺรุ:, เอตำ กถำ ศฺรุตฺวา ผิรูศิโน วฺยรชฺยนฺต, ตตฺ กึ ภวตา ชฺญายเต? ");
INSERT INTO santha_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ส ปฺรตฺยวทตฺ, มม สฺวรฺคสฺถ: ปิตา ยํ กญฺจิทงฺกุรํ นาโรปยตฺ, ส อุตฺปาวฺทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","เต ติษฺฐนฺตุ, เต อนฺธมนุชานามฺ อนฺธมารฺคทรฺศกา เอว; ยทฺยนฺโธ'นฺธํ ปนฺถานํ ทรฺศยติ, ตรฺหฺยุเภา ครฺตฺเต ปตต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ตทา ปิตรสฺตํ ปฺรตฺยวทตฺ, ทฺฤษฺฏานฺตมิมมสฺมานฺ โพธยตุฯ ");
INSERT INTO santha_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ยีศุนา โปฺรกฺตํ, ยูยมทฺย ยาวตฺ กิมโพธา: สฺถ? ");
INSERT INTO santha_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","กถามิมำ กึ น พุธฺยทฺเหฺพ ? ยทาสฺยํ เปฺรวิศติ, ตทฺ อุทเร ปตนฺ พหิรฺนิรฺยาติ, ");
INSERT INTO santha_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","กินฺตฺวาสฺยาทฺ ยนฺนิรฺยาติ, ตทฺ อนฺต:กรณาตฺ นิรฺยาตตฺวาตฺ มนุชมเมธฺยํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ยโต'นฺต:กรณาตฺ กุจินฺตา พธ: ปารทาริกตา เวศฺยาคมนํ ไจรฺยฺยํ มิถฺยาสากฺษฺยมฺ อีศฺวรนินฺทา ไจตานิ สรฺวฺวาณิ นิรฺยฺยานฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","เอตานิ มนุษฺยมปวิตฺรี กุรฺวฺวนฺติ กินฺตฺวปฺรกฺษาลิตกเรณ โภชนํ มนุชมเมธฺยํ น กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","อนนฺตรํ ยีศุสฺตสฺมาตฺ สฺถานาตฺ ปฺรสฺถาย โสรสีโทนฺนครโย: สีมามุปตเสฺยาฯ ");
INSERT INTO santha_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ตทา ตตฺสีมาต: กาจิตฺ กินานียา โยษิทฺ อาคตฺย ตมุจฺไจรุวาจ, เห ปฺรโภ ทายูท: สนฺตาน, มไมกา ทุหิตาเสฺต สา ภูตคฺรสฺตา สตี มหาเกฺลศํ ปฺราปฺโนติ มม ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","กินฺตุ ยีศุสฺตำ กิมปิ โนกฺตวานฺ, ตต: ศิษฺยา อาคตฺย ตํ นิเวทยามาสุ:, เอษา โยษิทฺ อสฺมากํ ปศฺจาทฺ อุจฺไจราหูยาคจฺฉติ, เอนำ วิสฺฤชตุฯ ");
INSERT INTO santha_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ตทา ส ปฺรตฺยวทตฺ, อิสฺราเยลฺโคตฺรสฺย หาริตเมษานฺ วินา กสฺยาปฺยนฺยสฺย สมีปํ นาหํ เปฺรษิโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ตต: สา นารีสมาคตฺย ตํ ปฺรณมฺย ชคาท, เห ปฺรโภ มามุปกุรุฯ ");
INSERT INTO santha_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ส อุกฺตวานฺ, พาลกานำ ภกฺษฺยมาทาย สารเมเยโภฺย ทานํ โนจิตํฯ ");
INSERT INTO santha_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ตทา สา พภาเษ, เห ปฺรโภ, ตตฺ สตฺยํ, ตถาปิ ปฺรโภ รฺภญฺจาทฺ ยทุจฺฉิษฺฏํ ปตติ, ตตฺ สารเมยา: ขาทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ตโต ยีศุ: ปฺรตฺยวทตฺ, เห โยษิตฺ, ตว วิศฺวาโส มหานฺ ตสฺมาตฺ ตว มโนภิลษิตํ สิทฺยฺยตุ, เตน ตสฺยา: กนฺยา ตสฺมินฺเนว ทณฺเฑ นิรามยาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","อนนฺตรํ ยีศสฺตสฺมาตฺ สฺถานาตฺ ปฺรสฺถาย คาลีลฺสาครสฺย สนฺนิธิมาคตฺย ธราธรมารุหฺย ตโตฺรปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ปศฺจาตฺ ชนนิวโห พหูนฺ ขญฺจานฺธมูกศุษฺกกรมานุษานฺ อาทาย ยีโศ: สมีปมาคตฺย ตจฺจรณานฺติเก สฺถาปยามาสุ:, ตต: สา ตานฺ นิรามยานฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","อิตฺถํ มูกา วากฺยํ วทนฺติ, ศุษฺกกรา: สฺวาสฺถฺยมายานฺติ, ปงฺคโว คจฺฉนฺติ, อนฺธา วีกฺษนฺเต, อิติ วิโลกฺย โลกา วิสฺมยํ มนฺยมานา อิสฺราเยล อีศฺวรํ ธนฺยํ พภาษิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ตทานีํ ยีศุ: สฺวศิษฺยานฺ อาหูย คทิตวานฺ, เอตชฺชนนิวเหษุ มม ทยา ชายเต, เอเต ทินตฺรยํ มยา สากํ สนฺติ, เอษำ ภกฺษฺยวสฺตุ จ กญฺจิทปิ นาสฺติ, ตสฺมาทหเมตานกฺฤตาหารานฺ น วิสฺรกฺษฺยามิ, ตถาเตฺว วรฺตฺมมเธฺย กฺลาเมฺยษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ตทา ศิษฺยา อูจุ:, เอตสฺมินฺ ปฺรานฺตรมธฺย เอตาวโต มรฺตฺยานฺ ตรฺปยิตุํ วยํ กุตฺร ปูปานฺ ปฺราปฺสฺยาม:? ");
INSERT INTO santha_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ยีศุรปฺฤจฺฉตฺ, ยุษฺมากํ นิกเฏ กติ ปูปา อาสเต? ต อูจุ:, สปฺตปูปา อลฺปา: กฺษุทฺรมีนาศฺจ สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ตทานีํ ส โลกนิวหํ ภูมาวุปเวษฺฏุมฺ อาทิศฺย ");
INSERT INTO santha_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ตานฺ สปฺตปูปานฺ มีนำศฺจ คฺฤหฺลนฺ อีศฺวรียคุณานฺ อนูทฺย ภํกฺตฺวา ศิเษฺยโภฺย ทเทา, ศิษฺยา โลเกโภฺย ททุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ตต: สรฺเวฺว ภุกฺตฺวา ตฺฤปฺตวนฺต:; ตทวศิษฺฏภกฺเษฺยณ สปฺตฑลกานฺ ปริปูรฺยฺย สํชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","เต โภกฺตาโร โยษิโต พาลกำศฺจ วิหาย ปฺราเยณ จตุ:สหสฺราณิ ปุรุษา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ตต: ปรํ ส ชนนิวหํ วิสฺฤชฺย ตริมารุหฺย มคฺทลาปฺรเทศํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ตทานีํ ผิรูศิน: สิทูกินศฺจาคตฺย ตํ ปรีกฺษิตุํ นภมียํ กิญฺจน ลกฺษฺม ทรฺศยิตุํ ตไสฺม นิเวทยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ตต: ส อุกฺตวานฺ, สนฺธฺยายำ นภโส รกฺตตฺวาทฺ ยูยํ วทถ, โศฺว นิรฺมฺมลํ ทินํ ภวิษฺยติ; ");
INSERT INTO santha_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ปฺราต:กาเล จ นภโส รกฺตตฺวาตฺ มลินตฺวาญฺจ วทถ, ฌญฺภฺศทฺย ภวิษฺยติฯ เห กปฏิโน ยทิ ยูยมฺ อนฺตรีกฺษสฺย ลกฺษฺม โพทฺธุํ ศกฺนุถ, ตรฺหิ กาลไสฺยตสฺย ลกฺษฺม กถํ โพทฺธุํ น ศกฺนุถ? ");
INSERT INTO santha_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","เอตตฺกาลสฺย ทุษฺโฏ วฺยภิจารี จ วํโศ ลกฺษฺม คเวษยติ, กินฺตุ ยูนโส ภวิษฺยทฺวาทิโน ลกฺษฺม วินานฺยตฺ กิมปิ ลกฺษฺม ตานฺ น ทรฺศยิยฺยเตฯ ตทานีํ ส ตานฺ วิหาย ปฺรตเสฺถฯ ");
INSERT INTO santha_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","อนนฺตรมนฺยปารคมนกาเล ตสฺย ศิษฺยา: ปูปมาเนตุํ วิสฺมฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ยีศุสฺตานวาทีตฺ, ยูยํ ผิรูศินำ สิทูกินาญฺจ กิณฺวํ ปฺรติ สาวธานา: สตรฺกาศฺจ ภวตฯ ");
INSERT INTO santha_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","เตน เต ปรสฺปรํ วิวิจฺย กถยิตุมาเรภิเร, วยํ ปูปานาเนตุํ วิสฺมฺฤตวนฺต เอตตฺการณาทฺ อิติ กถยติฯ ");
INSERT INTO santha_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","กินฺตุ ยีศุสฺตทฺวิชฺญาย ตานโวจตฺ, เห โสฺตกวิศฺวาสิโน ยูยํ ปูปานานยนมธิ กุต: ปรสฺปรเมตทฺ วิวึกฺย? ");
INSERT INTO santha_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ยุษฺมาภิ: กิมทฺยาปิ น ชฺญายเต? ปญฺจภิ: ปูไป: ปญฺจสหสฺรปุรุเษษุ โภชิเตษุ ภกฺโษฺยจฺฉิษฺฏปูรฺณานฺ กติ ฑลกานฺ สมคฺฤหฺลีตํ; ");
INSERT INTO santha_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ตถา สปฺตภิ: ปูไปศฺจตุ:สหสฺรปุรุเษษุ เภชิเตษุ กติ ฑลกานฺ สมคฺฤหฺลีต, ตตฺ กึ ยุษฺมาภิรฺน สฺมรฺยฺยเต? ");
INSERT INTO santha_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ตสฺมาตฺ ผิรูศินำ สิทูกินาญฺจ กิณฺวํ ปฺรติ สาวธานาสฺติษฺฐต, กถามิมามฺ อหํ ปูปานธิ นากถยํ, เอตทฺ ยูยํ กุโต น พุธฺยเธฺว? ");
INSERT INTO santha_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ตทานีํ ปูปกิณฺวํ ปฺรติ สาวธานาสฺติษฺฐเตติ โนกฺตฺวา ผิรูศินำ สิทูกินาญฺจ อุปเทศํ ปฺรติ สาวธานาสฺติษฺฐเตติ กถิตวานฺ, อิติ ไตรโพธิฯ ");
INSERT INTO santha_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","อปรญฺจ ยีศุ: ไกสริยา-ผิลิปิปฺรเทศมาคตฺย ศิษฺยานฺ อปฺฤจฺฉตฺ, โย'หํ มนุชสุต: โส'หํ ก:? โลไกรหํ กิมุเจฺย? ");
INSERT INTO santha_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ตทานีํ เต กถิตวนฺต:, เกจิทฺ วทนฺติ ตฺวํ มชฺชยิตา โยหนฺ, เกจิทฺวทนฺติ, ตฺวมฺ เอลิย:, เกจิจฺจ วทนฺติ, ตฺวํ ยิริมิโย วา กศฺจิทฺ ภวิษฺยทฺวาทีติฯ ");
INSERT INTO santha_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ปศฺจาตฺ ส ตานฺ ปปฺรจฺฉ, ยูยํ มำ กํ วทถ? ตต: ศิโมนฺ ปิตร อุวาจ, ");
INSERT INTO santha_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ตฺวมมเรศฺวรสฺยาภิษิกฺตปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ตโต ยีศุ: กถิตวานฺ, เห ยูนส: ปุตฺร ศิโมนฺ ตฺวํ ธนฺย:; ยต: โกปิ อนุชสฺตฺวเยฺยตชฺชฺญานํ โนทปาทยตฺ, กินฺตุ มม สฺวรฺคสฺย: ปิโตทปาทยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","อโต'หํ ตฺวำ วทามิ, ตฺวํ ปิตร: (ปฺรสฺตร:) อหญฺจ ตสฺย ปฺรสฺตรโสฺยปริ สฺวมณฺฑลีํ นิรฺมฺมาสฺยามิ, เตน นิรโย พลาตฺ ตำ ปราเชตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","อหํ ตุภฺยํ สฺวรฺคียราชฺยสฺย กุญฺชิกำ ทาสฺยามิ, เตน ยตฺ กิญฺจน ตฺวํ ปฺฤถิวฺยำ ภํตฺสฺยสิ ตตฺสฺวรฺเค ภํตฺสฺยเต, ยจฺจ กิญฺจน มหฺยำ โมกฺษฺยสิ ตตฺ สฺวรฺเค โมกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ปศฺจาตฺ ส ศิษฺยานาทิศตฺ, อหมภิษิกฺโต ยีศุริติ กถำ กไสฺมจิทปิ ยูยํ มา กถยตฯ ");
INSERT INTO santha_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","อนฺยญฺจ ยิรูศาลมฺนครํ คตฺวา ปฺราจีนโลเกภฺย: ปฺรธานยาชเกภฺย อุปาธฺยาเยภฺยศฺจ พหุทุ:ขโภคไสฺต รฺหตตฺวํ ตฺฤตียทิเน ปุนรุตฺถานญฺจ มมาวศฺยกมฺ เอตา: กถา ยีศุสฺตตฺกาลมารภฺย ศิษฺยานฺ ชฺญาปยิตุมฺ อารพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ตทานีํ ปิตรสฺตสฺย กรํ ฆฺฤตฺวา ตรฺชยิตฺวา กถยิตุมารพฺธวานฺ, เห ปฺรโภ, ตตฺ ตฺวตฺโต ทูรํ ยาตุ, ตฺวำ ปฺรติ กทาปิ น ฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","กินฺตุ ส วทนํ ปราวรฺตฺย ปิตรํ ชคาท, เห วิฆฺนการินฺ, มตฺสมฺมุขาทฺ ทูรีภว, ตฺวํ มำ พาธเส, อีศฺวรียการฺยฺยาตฺ มานุษียการฺยฺยํ ตุภฺยํ โรจเตฯ ");
INSERT INTO santha_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","อนนฺตรํ ยีศุ: สฺวียศิษฺยานฺ อุกฺตวานฺ ย: กศฺจิตฺ มม ปศฺจาทฺคามี ภวิตุมฺ อิจฺฉติ, ส สฺวํ ทามฺยตุ, ตถา สฺวกฺรุศํ คฺฤหฺลนฺ มตฺปศฺจาทายาตุฯ ");
INSERT INTO santha_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ยโต ย: ปฺราณานฺ รกฺษิตุมิจฺฉติ, ส ตานฺ หารยิษฺยติ, กินฺตุ โย มทรฺถํ นิชปฺราณานฺ หารยติ, ส ตานฺ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","มานุโษ ยทิ สรฺวฺวํ ชคตฺ ลภเต นิชปฺรณานฺ หารยติ, ตรฺหิ ตสฺย โก ลาภ:? มนุโช นิชปฺราณานำ วินิมเยน วา กึ ทาตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","มนุชสุต: สฺวทูไต: สากํ ปิตุ: ปฺรภาเวณาคมิษฺยติ; ตทา ปฺรติมนุชํ สฺวสฺวกรฺมฺมานุสาราตฺ ผลํ ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","อหํ ยุษฺมานฺ ตถฺยํ วจฺมิ, สราชฺยํ มนุชสุตมฺ อาคตํ น ปศฺยนฺโต มฺฤตฺยุํ น สฺวาทิษฺยนฺติ, เอตาทฺฤศา: กติปยชนา อตฺราปิ ทณฺฑายมานา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","อนนฺตรํ ษฑฺทิเนภฺย: ปรํ ยีศุ: ปิตรํ ยากูพํ ตตฺสหชํ โยหนญฺจ คฺฤหฺลนฺ อุจฺจาเทฺร รฺวิวิกฺตสฺถานมฺ อาคตฺย เตษำ สมกฺษํ รูปมนฺยตฺ ทธารฯ ");
INSERT INTO santha_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","เตน ตทาสฺยํ เตชสฺวิ, ตทาภรณมฺ อาโลกวตฺ ปาณฺฑรมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","อนฺยจฺจ เตน สากํ สํลปนฺเตา มูสา เอลิยศฺจ เตโภฺย ทรฺศนํ ททตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ตทานีํ ปิตโร ยีศุํ ชคาท, เห ปฺรโภ สฺถิติรตฺราสฺมากํ ศุภา, ยทิ ภวตานุมนฺยเต, ตรฺหิ ภวทรฺถเมกํ มูสารฺถเมกมฺ เอลิยารฺถญฺไจกมฺ อิติ ตฺรีณิ ทูษฺยาณิ นิรฺมฺมมฯ ");
INSERT INTO santha_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","เอตตฺกถนกาล เอก อุชฺชวล: ปโยทเสฺตษามุปริ ฉายำ กฺฤตวานฺ, วาริทาทฺ เอษา นภสียา วาคฺ พภูว, มมายํ ปฺริย: ปุตฺร:, อสฺมินฺ มม มหาสนฺโตษ เอตสฺย วากฺยํ ยูยํ นิศามยตฯ ");
INSERT INTO santha_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","กินฺตุ วาจเมตำ ศฺฤณฺวนฺเตอว ศิษฺยา มฺฤศํ ศงฺกมานา นฺยุพฺชา นฺยปตนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ตทา ยีศุราคตฺย เตษำ คาตฺราณิ สฺปฺฤศนฺ อุวาจ, อุตฺติษฺฐต, มา ไภษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ตทานีํ เนตฺราณฺยุนฺมีลฺย ยีศุํ วินา กมปิ น ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ตต: ปรมฺ อเทฺรรวโรหณกาเล ยีศุสฺตานฺ อิตฺยาทิเทศ, มนุชสุตสฺย มฺฤตานำ มธฺยาทุตฺถานํ ยาวนฺน ชายเต, ตาวตฺ ยุษฺมาภิเรตทฺทรฺศนํ กไสฺมจิทปิ น กถยิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ตทา ศิษฺยาสฺตํ ปปฺรจฺฉุ:, ปฺรถมมฺ เอลิย อายาสฺยตีติ กุต อุปาธฺยาไยรุจฺยเต? ");
INSERT INTO santha_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ตโต ยีศุ: ปฺรตฺยวาทีตฺ, เอลิย: ปฺราเคตฺย สรฺวฺวาณิ สาธยิษฺยตีติ สตฺยํ, ");
INSERT INTO santha_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","กินฺตฺวหํ ยุษฺมานฺ วจฺมิ, เอลิย เอตฺย คต:, เต ตมปริจิตฺย ตสฺมินฺ ยเถจฺฉํ วฺยวชหุ:; มนุชสุเตนาปิ เตษามนฺติเก ตาทฺฤคฺ ทุ:ขํ โภกฺตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ตทานีํ ส มชฺชยิตารํ โยหนมธิ กถาเมตำ วฺยาหฺฤตวานฺ, อิตฺถํ ตจฺฉิษฺยา พุพุธิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ปศฺจาตฺ เตษุ ชนนิวหสฺยานฺติกมาคเตษุ กศฺจิตฺ มนุชสฺตทนฺติกเมตฺย ชานูนี ปาตยิตฺวา กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","เห ปฺรโภ, มตฺปุตฺรํ ปฺรติ กฺฤปำ วิทธาตุ, โสปสฺมารามเยน ภฺฤศํ วฺยถิต: สนฺ ปุน: ปุน รฺวเหฺนา มุหุ รฺชลมเธฺย ปตติฯ ");
INSERT INTO santha_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ตสฺมาทฺ ภวต: ศิษฺยาณำ สมีเป ตมานยํ กินฺตุ เต ตํ สฺวาสฺถํ กรฺตฺตุํ น ศกฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ตทา ยีศุ: กถิตวานฺ เร อวิศฺวาสิน:, เร วิปถคามิน:, ปุน: กติกาลานฺ อหํ ยุษฺมากํ สนฺนิเธา สฺถาสฺยามิ? กติกาลานฺ วา ยุษฺมานฺ สหิเษฺย? ตมตฺร มมานฺติกมานยตฯ ");
INSERT INTO santha_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ปศฺจาทฺ ยีศุนา ตรฺชเตอว ส ภูตสฺตํ วิหาย คตวานฺ, ตทฺทณฺเฑอว ส พาลโก นิรามโย'ภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ตต: ศิษฺยา คุปฺตํ ยีศุมุปาคตฺย พภาษิเร, กุโต วยํ ตํ ภูตํ ตฺยาชยิตุํ น ศกฺตา:? ");
INSERT INTO santha_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ยีศุนา เต โปฺรกฺตา:, ยุษฺมากมปฺรตฺยยาตฺ; ");
INSERT INTO santha_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ยุษฺมานหํ ตถฺยํ วจฺมิ ยทิ ยุษฺมากํ สรฺษไปกมาโตฺรปิ วิศฺวาโส ชายเต, ตรฺหิ ยุษฺมาภิรสฺมินฺ ไศเล ตฺวมิต: สฺถานาตฺ ตตฺ สฺถานํ ยาหีติ พฺรูเต ส ตไทว จลิษฺยติ, ยุษฺมากํ กิมปฺยสาธฺยญฺจ กรฺมฺม น สฺถาสฺยาติฯ กินฺตุ ปฺรารฺถโนปวาเสา วิไนตาทฺฤโศ ภูโต น ตฺยาเชฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","อปรํ เตษำ คาลีลฺปฺรเทเศ ภฺรมณกาเล ยีศุนา เต คทิตา:, มนุชสุโต ชนานำ กเรษุ สมรฺปยิษฺยเต ไต รฺหนิษฺยเต จ, ");
INSERT INTO santha_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","กินฺตุ ตฺฤตีเย'หิ्น ม อุตฺถาปิษฺยเต, เตน เต ภฺฤศํ ทุ:ขิตา พภูว:ฯ ");
INSERT INTO santha_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ตทนนฺตรํ เตษุ กผรฺนาหูมฺนครมาคเตษุ กรสํคฺราหิณ: ปิตรานฺติกมาคตฺย ปปฺรจฺฉุ:, ยุษฺมากํ คุรุ: กึ มนฺทิรารฺถํ กรํ น ททาติ? ตต: ปิตร: กถิตวานฺ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ตตสฺตสฺมินฺ คฺฤหมธฺยมาคเต ตสฺย กถากถนาตฺ ปูรฺวฺวเมว ยีศุรุวาจ, เห ศิโมนฺ, เมทินฺยา ราชาน: สฺวสฺวาปเตฺยภฺย: กึ วิเทศิภฺย: เกภฺย: กรํ คฺฤหฺลนฺติ? อตฺร ตฺวํ กึ พุธฺยเส? ตต: ปิตร อุกฺตวานฺ, วิเทศิภฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ตทา ยีศุรุกฺตวานฺ, ตรฺหิ สนฺตานา มุกฺตา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ตถาปิ ยถาสฺมาภิเสฺตษามนฺตราโย น ชนฺยเต, ตตฺกฺฤเต ชลเธสฺตีรํ คตฺวา วฑิศํ กฺษิป, เตนาเทา โย มีน อุตฺถาสฺยติ, ตํ ฆฺฤตฺวา ตนฺมุเข โมจิเต โตลไกกํ รูปฺยํ ปฺราปฺสฺยสิ, ตทฺ คฺฤหีตฺวา ตว มม จ กฺฤเต เตโภฺย เทหิฯ ");
INSERT INTO santha_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ตทานีํ ศิษฺยา ยีโศ: สมีปมาคตฺย ปฺฤษฺฏวนฺต: สฺวรฺคราเชฺย ก: เศฺรษฺฐ:? ");
INSERT INTO santha_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ตโต ยีศุ: กฺษุทฺรเมกํ พาลกํ สฺวสมีปมานีย เตษำ มเธฺย นิธาย ชคาท, ");
INSERT INTO santha_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ยุษฺมานหํ สตฺยํ พฺรวีมิ, ยูยํ มโนวินิมเยน กฺษุทฺรพาลวตฺ น สนฺต: สฺวรฺคราชฺยํ ปฺรเวษฺฏุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ย: กศฺจิทฺ เอตสฺย กฺษุทฺรพาลกสฺย สมมาตฺมานํ นมฺรีกโรติ, เสอว สฺวรฺคราชเย เศฺรษฺฐ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ย: กศฺจิทฺ เอตาทฺฤศํ กฺษุทฺรพาลกเมกํ มม นามฺนิ คฺฤหฺลาติ, ส มาเมว คฺฤหฺลาติฯ ");
INSERT INTO santha_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","กินฺตุ โย ชโน มยิ กฺฤตวิศฺวาสานาเมเตษำ กฺษุทฺรปฺราณินามฺ เอกสฺยาปิ วิธฺนึ ชนยติ, กณฺฐพทฺธเปษณีกสฺย ตสฺย สาคราคาธชเล มชฺชนํ เศฺรย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","วิฆฺนาตฺ ชคต: สนฺตาโป ภวิษฺยติ, วิคฺโหฺน'วศฺยํ ชนยิษฺยเต, กินฺตุ เยน มนุเชน วิคฺโหฺน ชนิษฺยเต ตไสฺยว สนฺตาโป ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ตสฺมาตฺ ตว กรศฺจรโณ วา ยทิ ตฺวำ พาธเต, ตรฺหิ ตํ ฉิตฺตฺวา นิกฺษิป, ทฺวิกรสฺย ทฺวิปทสฺย วา ตวานปฺตวเหฺนา นิกฺเษปาตฺ, ขญฺชสฺย วา ฉินฺนหสฺตสฺย ตว ชีวเน ปฺรเวโศ วรํฯ ");
INSERT INTO santha_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","อปรํ ตว เนตฺรํ ยทิ ตฺวำ พาธเต, ตรฺหิ ตทปฺยุตฺปาวฺย นิกฺษิป, ทฺวิเนตฺรสฺย นรกาคฺเนา นิกฺเษปาตฺ กาณสฺย ตว ชีวเน ปฺรเวโศ วรํฯ ");
INSERT INTO santha_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ตสฺมาทวธทฺธํ, เอเตษำ กฺษุทฺรปฺราณินามฺ เอกมปิ มา ตุจฺฉีกุรุต, ");
INSERT INTO santha_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ยโต ยุษฺมานหํ ตถฺยํ พฺรวีมิ, สฺวรฺเค เตษำ ทูตา มม สฺวรฺคสฺถสฺย ปิตุราสฺยํ นิตฺยํ ปศฺยนฺติฯ เอวํ เย เย หาริตาสฺตานฺ รกฺษิตุํ มนุชปุตฺร อาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ยูยมตฺร กึ วิวึคฺเฆฺว? กสฺยจิทฺ ยทิ ศตํ เมษา: สนฺติ, เตษาเมโก หารฺยฺยเต จ, ตรฺหิ ส เอโกนศตํ เมษานฺ วิหาย ปรฺวฺวตํ คตฺวา ตํ หาริตเมกํ กึ น มฺฤคยเต? ");
INSERT INTO santha_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ยทิ จ กทาจิตฺ ตนฺเมโษทฺเทศํ ลมเต, ตรฺหิ ยุษฺมานหํ สตฺยํ กถยามิ, โส'วิปถคามิภฺย เอโกนศตเมเษโภฺยปิ ตเทกเหโตรธิกมฺ อาหฺลาทเตฯ ");
INSERT INTO santha_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ตทฺวทฺ เอเตษำ กฺษุทฺรปฺราเอिนามฺ เอโกปิ นศฺยตีติ ยุษฺมากํ สฺวรฺคสฺถปิตุ รฺนาภิมตมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ยทฺยปิ ตว ภฺราตา ตฺวยิ กิมปฺยปราธฺยติ, ตรฺหิ คตฺวา ยุวโยรฺทฺวโย: สฺถิตโยสฺตสฺยาปราธํ ตํ ชฺญาปยฯ ตตฺร ส ยทิ ตว วากฺยํ ศฺฤโณติ, ตรฺหิ ตฺวํ สฺวภฺราตรํ ปฺราปฺตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","กินฺตุ ยทิ น ศฺฤโณติ, ตรฺหิ ทฺวาภฺยำ ตฺริภิ รฺวา สากฺษีภิ: สรฺวฺวํ วากฺยํ ยถา นิศฺจิตํ ชายเต, ตทรฺถมฺ เอกํ เทฺวา วา สากฺษิเณา คฺฤหีตฺวา ยาหิฯ ");
INSERT INTO santha_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","เตน ส ยทิ ตโย รฺวากฺยํ น มานฺยเต, ตรฺหิ สมาชํ ตชฺชฺญาปย, กินฺตุ ยทิ สมาชสฺยาปิ วากฺยํ น มานฺยเต,ตรฺหิ ส ตว สมีเป เทวปูชกอิว จณฺฑาลอิว จ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","อหํ ยุษฺมานฺ สตฺยํ วทามิ, ยุษฺมาภิ: ปฺฤถิวฺยำ ยทฺ พธฺยเต ตตฺ สฺวรฺเค ภํตฺสฺยเต; เมทินฺยำ ยตฺ โภจฺยเต, สฺวรฺเค'ปิ ตตฺ โมกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ปุนรหํ ยุษฺมานฺ วทามิ, เมทินฺยำ ยุษฺมากํ ยทิ ทฺวาเวกวากฺยีภูย กิญฺจิตฺ ปฺรารฺถเยเต, ตรฺหิ มม สฺวรฺคสฺถปิตฺรา ตตฺ ตโย: กฺฤเต สมฺปนฺนํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ยโต ยตฺร เทฺวา ตฺรโย วา มม นานฺนิ มิลนฺติ, ตไตฺรวาหํ เตษำ มเธฺย'สฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ตทานีํ ปิตรสฺตตฺสมีปมาคตฺย กถิตวานฺ เห ปฺรโภ, มม ภฺราตา มม ยทฺยปราธฺยติ, ตรฺหิ ตํ กติกฺฤตฺว: กฺษมิเษฺย? ");
INSERT INTO santha_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","กึ สปฺตกฺฤตฺว:? ยีศุสฺตํ ชคาท, ตฺวำ เกวลํ สปฺตกฺฤโตฺว ยาวตฺ น วทามิ, กินฺตุ สปฺตตฺยา คุณิตํ สปฺตกฺฤโตฺว ยาวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","อปรํ นิชทาไส: สห ชิคณยิษุ: กศฺจิทฺ ราเชว สฺวรฺคราชยํฯ ");
INSERT INTO santha_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","อารพฺเธ ตสฺมินฺ คณเน สารฺทฺธสหสฺรมุทฺราปูริตานำ ทศสหสฺรปุฏกานามฺ เอโก'ฆมรฺณสฺตตฺสมกฺษมานายิฯ ");
INSERT INTO santha_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ตสฺย ปริโศธนาย ทฺรวฺยาภาวาตฺ ปริโศธนารฺถํ ส ตทียภารฺยฺยาปุตฺราทิสรฺวฺวสฺวญฺจ วิกฺรียตามิติ ตตฺปฺรภุราทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","เตน ส ทาสสฺตสฺย ปาทโย: ปตนฺ ปฺรณมฺย กถิตวานฺ , เห ปฺรโภ ภวตา ไฆรฺเยฺย กฺฤเต มยา สรฺวฺวํ ปริโศธิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ตทานีํ ทาสสฺย ปฺรภุ: สกรุณ: สนฺ สกลรฺณํ กฺษมิตฺวา ตํ ตตฺยาชฯ ");
INSERT INTO santha_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","กินฺตุ ตสฺมินฺ ทาเส พหิ รฺยาเต, ตสฺย ศตํ มุทฺราจตุรฺถำศานฺ โย ธารยติ, ตํ สหทาสํ ทฺฤษฺทฺวา ตสฺย กณฺฐํ นิษฺปีฑฺย คทิตวานฺ, มม ยตฺ ปฺราปฺยํ ตตฺ ปริโศธยฯ ");
INSERT INTO santha_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ตทา ตสฺย สหทาสสฺตตฺปาทโย: ปติตฺวา วินีย พภาเษ, ตฺวยา ไธรฺเยฺย กฺฤเต มยา สรฺวฺวํ ปริโศธิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ตถาปิ ส ตตฺ นางคีกฺฤตฺย ยาวตฺ สรฺวฺวมฺฤณํ น ปริโศธิตวานฺ ตาวตฺ ตํ การายำ สฺถาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ตทา ตสฺย สหทาสาสฺตไสฺยตาทฺฤคฺ อาจรณํ วิโลกฺย ปฺรโภ: สมีปํ คตฺวา สรฺวฺวํ วฺฤตฺตานฺตํ นิเวทยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ตทา ตสฺย ปฺรภุสฺตมาหูย ชคาท, เร ทุษฺฏ ทาส, ตฺวยา มตฺสนฺนิเธา ปฺรารฺถิเต มยา ตว สรฺวฺวมฺฤณํ ตฺยกฺตํ; ");
INSERT INTO santha_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ยถา จาหํ ตฺวยิ กรุณำ กฺฤตวานฺ, ตไถว ตฺวตฺสหทาเส กรุณากรณํ กึ ตว โนจิตํ? ");
INSERT INTO santha_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","อิติ กถยิตฺวา ตสฺย ปฺรภุ: กฺรุทฺธฺยนฺ นิชปฺราปฺยํ ยาวตฺ ส น ปริโศธิตวานฺ, ตาวตฺ ปฺรหารกานำ กเรษุ ตํ สมรฺปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ยทิ ยูยํ สฺวานฺต:กรไณ: สฺวสฺวสหชานามฺ อปราธานฺ น กฺษมเธฺว, ตรฺหิ มม สฺวรฺคสฺย: ปิตาปิ ยุษฺมานฺ ปฺรตีตฺถํ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","อนนฺตรมฺ เอตาสุ กถาสุ สมาปฺตาสุ ยีศุ รฺคาลีลปฺรเทศาตฺ ปฺรสฺถาย ยรฺทนฺตีรสฺถํ ยิหูทาปฺรเทศํ ปฺราปฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ตทา ตตฺปศฺจาตฺ ชนนิวเห คเต ส ตตฺร ตานฺ นิรามยานฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ตทนนฺตรํ ผิรูศินสฺตตฺสมีปมาคตฺย ปารีกฺษิตุํ ตํ ปปฺรจฺฉุ:, กสฺมาทปิ การณาตฺ นเรณ สฺวชายา ปริตฺยาชฺยา น วา? ");
INSERT INTO santha_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ส ปฺรตฺยุวาจ, ปฺรถมมฺ อีศฺวโร นรเตฺวน นารีเตฺวน จ มนุชานฺ สสรฺช, ตสฺมาตฺ กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","มานุษ: สฺวปิตเรา ปริตฺยชฺย สฺวปตฺนฺยามฺ อาสกฺษฺยเต, เตา เทฺวา ชนาเวกางฺเคา ภวิษฺยต:, กิเมตทฺ ยุษฺมาภิ รฺน ปฐิตมฺ? ");
INSERT INTO santha_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","อตเสฺตา ปุน รฺน เทฺวา ตโยเรกางฺคตฺวํ ชาตํ, อีศฺวเรณ ยจฺจ สมยุชฺยต, มนุโช น ตทฺ ภินฺทฺยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ตทานีํ เต ตํ ปฺรตฺยวทนฺ, ตถาเตฺว ตฺยาชฺยปตฺรํ ทตฺตฺวา สฺวำ สฺวำ ชายำ ตฺยกฺตุํ วฺยวสฺถำ มูสา: กถํ ลิเลข? ");
INSERT INTO santha_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ตต: ส กถิตวานฺ, ยุษฺมากํ มนสำ กาฐินฺยาทฺ ยุษฺมานฺ สฺวำ สฺวำ ชายำ ตฺยกฺตุมฺ อนฺวมนฺยต กินฺตุ ปฺรถมาทฺ เอโษ วิธิรฺนาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","อโต ยุษฺมานหํ วทามิ, วฺยภิจารํ วินา โย นิชชายำ ตฺยเชตฺ อนฺยาญฺจ วิวเหตฺ, ส ปรทารานฺ คจฺฉติ; ยศฺจ ตฺยกฺตำ นารีํ วิวหติ โสปิ ปรทาเรษุ รมเตฯ ");
INSERT INTO santha_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ตทา ตสฺย ศิษฺยาสฺตํ พภาษิเร, ยทิ สฺวชายยา สากํ ปุํส เอตาทฺฤกฺ สมฺพนฺโธ ชายเต, ตรฺหิ วิวหนเมว น ภทฺรํฯ ");
INSERT INTO santha_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ตต: ส อุกฺตวานฺ, เยภฺยสฺตตฺสามรฺถฺยํ อาทายิ, ตานฺ วินานฺย: โกปิ มนุช เอตนฺมตํ คฺรหีตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","กติปยา ชนนกฺลีพ: กติปยา นรกฺฤตกฺลีพ: สฺวรฺคราชฺยาย กติปยา: สฺวกฺฤตกฺลีพาศฺจ สนฺติ, เย คฺรหีตุํ ศกฺนุวนฺติ เต คฺฤหฺลนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","อปรมฺ ยถา ส ศิศูนำ คาเตฺรษุ หสฺตํ ทตฺวา ปฺรารฺถยเต, ตทรฺถํ ตตฺสมีํปํ ศิศว อานียนฺต, ตต อานยิตฺฤนฺ ศิษฺยาสฺติรสฺกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","กินฺตุ ยีศุรุวาจ, ศิศโว มทนฺติกมฺ อาคจฺฉนฺตุ, ตานฺ มา วารยต, เอตาทฺฤศำ ศิศูนาเมว สฺวรฺคราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ตต: ส เตษำ คาเตฺรษุ หสฺตํ ทตฺวา ตสฺมาตฺ สฺถานาตฺ ปฺรตเสฺถฯ ");
INSERT INTO santha_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","อปรมฺ เอก อาคตฺย ตํ ปปฺรจฺฉ, เห ปรมคุโร, อนนฺตายุ: ปฺราปฺตุํ มยา กึ กึ สตฺกรฺมฺม กรฺตฺตวฺยํ? ");
INSERT INTO santha_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ตต: ส อุวาจ, มำ ปรมํ กุโต วทสิ? วิเนศฺจรํ น โกปิ ปรม:, กินฺตุ ยทฺยนนฺตายุ: ปฺราปฺตุํ วาญฺฉสิ, ตรฺหฺยาชฺญา: ปาลยฯ ");
INSERT INTO santha_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ตทา ส ปฺฤษฺฏวานฺ, กา: กา อาชฺญา:? ตโต ยีศุ: กถิตวานฺ, นรํ มา หนฺยา:, ปรทารานฺ มา คจฺเฉ:, มา โจรเย:, มฺฤษาสากฺษฺยํ มา ททฺยา:, ");
INSERT INTO santha_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","นิชปิตเรา สํมนฺยสฺว, สฺวสมีปวาสินิ สฺววตฺ เปฺรม กุรุฯ ");
INSERT INTO santha_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ส ยุวา กถิตวานฺ, อา พาลฺยาทฺ เอตา: ปาลยามิ, อิทานีํ กึ นฺยูนมาเสฺต? ");
INSERT INTO santha_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ตโต ยีศุรวทตฺ, ยทิ สิทฺโธ ภวิตุํ วาญฺฉสิ, ตรฺหิ คตฺวา นิชสรฺวฺวสฺวํ วิกฺรีย ทริเทฺรโภฺย วิตร, ตต: สฺวรฺเค วิตฺตํ ลปฺสฺยเส; อาคจฺฉ, มตฺปศฺจาทฺวรฺตฺตี จ ภวฯ ");
INSERT INTO santha_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","เอตำ วาจํ ศฺรุตฺวา ส ยุวา สฺวียพหุสมฺปตฺเต รฺวิษณ: สนฺ จลิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ตทา ยีศุ: สฺวศิษฺยานฺ อวทตฺ, ธนินำ สฺวรฺคราชฺยปฺรเวโศ มหาทุษฺกร อิติ ยุษฺมานหํ ตถฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ปุนรปิ ยุษฺมานหํ วทามิ, ธนินำ สฺวรฺคราชฺยปฺรเวศาตฺ สูจีฉิเทฺรณ มหางฺคคมนํ สุกรํฯ ");
INSERT INTO santha_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","อิติ วากฺยํ นิศมฺย ศิษฺยา อติจมตฺกฺฤตฺย กถยามาสุ:; ตรฺหิ กสฺย ปริตฺราณํ ภวิตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ตทา ส ตานฺ ทฺฤษฺทฺวา กถยามาส, ตตฺ มานุษาณามศกฺยํ ภวติ, กินฺตฺวีศฺวรสฺย สรฺวฺวํ ศกฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ตทา ปิตรสฺตํ คทิตวานฺ, ปศฺย, วยํ สรฺวฺวํ ปริตฺยชฺย ภวต: ปศฺจาทฺวรฺตฺติโน 'ภวาม; วยํ กึ ปฺราปฺสฺยาม:? ");
INSERT INTO santha_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ตโต ยีศุ: กถิตวานฺ, ยุษฺมานหํ ตถฺยํ วทามิ, ยูยํ มม ปศฺจาทฺวรฺตฺติโน ชาตา อิติ การณาตฺ นวีนสฺฤษฺฏิกาเล ยทา มนุชสุต: สฺวีไยศฺจรฺยฺยสึหาสน อุปเวกฺษฺยติ, ตทา ยูยมปิ ทฺวาทศสึหาสเนษูปวิศฺย อิสฺราเยลียทฺวาทศวํศานำ วิจารํ กริษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","อนฺยจฺจ ย: กศฺจิตฺ มม นามการณาตฺ คฺฤหํ วา ภฺราตรํ วา ภคินีํ วา ปิตรํ วา มาตรํ วา ชายำ วา พาลกํ วา ภูมึ ปริตฺยชติ, ส เตษำ ศตคุณํ ลปฺสฺยเต, อนนฺตายุโม'ธิการิตฺวญฺจ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","กินฺตุ อคฺรียา อเนเก ชนา: ปศฺจาตฺ, ปศฺจาตียาศฺจาเนเก โลกา อเคฺร ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","สฺวรฺคราชฺยมฺ เอตาทฺฤศา เกนจิทฺ คฺฤหเสฺยน สมํ, โย'ติปฺรภาเต นิชทฺรากฺษากฺเษเตฺร กฺฤษกานฺ นิโยกฺตุํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ปศฺจาตฺ ไต: สากํ ทิไนกภฺฤตึ มุทฺราจตุรฺถำศํ นิรูปฺย ตานฺ ทฺรากฺษากฺเษตฺรํ เปฺรรยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","อนนฺตรํ ปฺรหไรกเวลายำ คตฺวา หฏฺเฏ กติปยานฺ นิษฺกรฺมฺมกานฺ วิโลกฺย ตานวทตฺ, ");
INSERT INTO santha_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ยูยมปิ มม ทฺรากฺษากฺเษตฺรํ ยาต, ยุษฺมภฺยมหํ โยคฺยภฺฤตึ ทาสฺยามิ, ตตเสฺต ววฺรชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ปุนศฺจ ส ทฺวิตียตฺฤตียโย: ปฺรหรโย รฺพหิ รฺคตฺวา ตไถว กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ตโต ทณฺฑทฺวยาวศิษฺฏายำ เวลายำ พหิ รฺคตฺวาปรานฺ กติปยชนานฺ นิษฺกรฺมฺมกานฺ วิโลกฺย ปฺฤษฺฏวานฺ, ยูยํ กิมรฺถมฺ อตฺร สรฺวฺวํ ทินํ นิษฺกรฺมฺมาณสฺติษฺฐถ? ");
INSERT INTO santha_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","เต ปฺรตฺยวทนฺ, อสฺมานฺ น โกปิ กรฺมมณิ นิยุํกฺเตฯ ตทานีํ ส กถิตวานฺ, ยูยมปิ มม ทฺรากฺษากฺเษตฺรํ ยาต, เตน โยคฺยำ ภฺฤตึ ลปฺสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ตทนนฺตรํ สนฺธฺยายำ สตฺยำ เสอว ทฺรากฺษากฺเษตฺรปติรธฺยกฺษํ คทิวานฺ, กฺฤษกานฺ อาหูย เศษชนมารภฺย ปฺรถมํ ยาวตฺ เตโภฺย ภฺฤตึ เทหิฯ ");
INSERT INTO santha_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","เตน เย ทณฺฑทฺวยาวสฺถิเต สมายาตาเสฺตษามฺ เอไกโก ชโน มุทฺราจตุรฺถำศํ ปฺราปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ตทานีํ ปฺรถมนิยุกฺตา ชนา อาคตฺยานุมิตวนฺโต วยมธิกํ ปฺรปฺสฺยาม:, กินฺตุ ไตรปิ มุทฺราจตุรฺถำโศ'ลาภิฯ ");
INSERT INTO santha_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ตตเสฺต ตํ คฺฤหีตฺวา เตน เกฺษตฺรปตินา สากํ วาคฺยุทฺธํ กุรฺวฺวนฺต: กถยามาสุ:, ");
INSERT INTO santha_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","วยํ กฺฤตฺสฺนํ ทินํ ตาปเกฺลเศา โสฒวนฺต:, กินฺตุ ปศฺจาตายา เส ชนา ทณฺฑทฺวยมาตฺรํ ปริศฺรานฺตวนฺตเสฺต'สฺมาภิ: สมานำศา: กฺฤตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ตต: ส เตษาเมกํ ปฺรตฺยุวาจ, เห วตฺส, มยา ตฺวำ ปฺรติ โกปฺยนฺยาโย น กฺฤต: กึ ตฺวยา มตฺสมกฺษํ มุทฺราจตุรฺถำโศ นางฺคีกฺฤต:? ");
INSERT INTO santha_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ตสฺมาตฺ ตว ยตฺ ปฺราปฺยํ ตทาทาย ยาหิ, ตุภฺยํ ยติ, ปศฺจาตียนิยุกฺตโลกายาปิ ตติ ทาตุมิจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","เสฺวจฺฉยา นิชทฺรวฺยวฺยวหรณํ กึ มยา น กรฺตฺตวฺยํ? มม ทาตฺฤตฺวาตฺ ตฺวยา กิมฺ อีรฺษฺยาทฺฤษฺฏิ: กฺริยเต? ");
INSERT INTO santha_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","อิตฺถมฺ อคฺรียโลกา: ปศฺจตียา ภวิษฺยนฺติ, ปศฺจาตียชนาศฺจคฺรียา ภวิษฺยนฺติ, อหูตา พหว: กินฺตฺวลฺเป มโนภิลษิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ตทนนฺตรํ ยีศุ รฺยิรูศาลมฺนครํ คจฺฉนฺ มารฺคมเธฺย ศิษฺยานฺ เอกานฺเต วภาเษ, ");
INSERT INTO santha_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ปศฺย วยํ ยิรูศาลมฺนครํ ยาม:, ตตฺร ปฺรธานยาชกาธฺยาปกานำ กเรษุ มนุษฺยปุตฺร: สมรฺปิษฺยเต; ");
INSERT INTO santha_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","เต จ ตํ หนฺตุมาชฺญาปฺย ติรสฺกฺฤตฺย เวเตฺรณ ปฺรหรฺตฺตุํ กฺรุเศ ธาตยิตุญฺจานฺยเทศียานำ กเรษุ สมรฺปยิษฺยนฺติ, กินฺตุ ส ตฺฤตียทิวเส ศฺมศานาทฺ อุตฺถาปิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ตทานีํ สิวทียสฺย นารี สฺวปุตฺราวาทาย ยีโศ: สมีปมฺ เอตฺย ปฺรณมฺย กญฺจนานุคฺรหํ ตํ ยยาเจฯ ");
INSERT INTO santha_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ตทา ยีศุสฺตำ โปฺรกฺตวานฺ, ตฺวํ กึ ยาจเส? ตต: สา พภาเษ, ภวโต ราชเตฺว มมานโย: สุตโยเรกํ ภวทฺทกฺษิณปารฺเศฺว ทฺวิตียํ วามปารฺศฺว อุปเวษฺฏุมฺ อาชฺญาปยตุฯ ");
INSERT INTO santha_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ยีศุ: ปฺรตฺยุวาจ, ยุวาภฺยำ ยทฺ ยาจฺยเต, ตนฺน พุธฺยเต, อหํ เยน กํเสน ปาสฺยามิ ยุวาภฺยำ กึ เตน ปาตุํ ศกฺยเต? อหญฺจ เยน มชฺเชเนน มชฺชิเษฺย, ยุวาภฺยำ กึ เตน มชฺชยิตุํ ศกฺยเต? เต ชคทุ: ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ตทา ส อุกฺตวานฺ, ยุวำ มม กํเสนาวศฺยํ ปาสฺยถ:, มม มชฺชเนน จ ยุวามปิ มชฺชิเษฺยเถ, กินฺตุ เยษำ กฺฤเต มตฺตาเตน นิรูปิตมฺ อิทํ ตานฺ วิหายานฺยํ กมปิ มทฺทกฺษิณปารฺเศฺว วามปารฺเศฺว จ สมุปเวศยิตุํ มมาธิกาโร นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","เอตำ กถำ ศฺรุตฺวาเนฺย ทศศิษฺยาเสฺตา ภฺราตเรา ปฺรติ จุกุปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","กินฺตุ ยีศุ: สฺวสมีปํ ตานาหูย ชคาท, อนฺยเทศียโลกานำ นรปตยสฺตานฺ อธิกุรฺวฺวนฺติ, เย ตุ มหานฺตเสฺต ตานฺ ศาสติ, อิติ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","กินฺตุ ยุษฺมากํ มเธฺย น ตถา ภเวตฺ, ยุษฺมากํ ย: กศฺจิตฺ มหานฺ พุภูษติ, ส ยุษฺมานฺ เสเวต; ");
INSERT INTO santha_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ยศฺจ ยุษฺมากํ มเธฺย มุโขฺย พุภูษติ, ส ยุษฺมากํ ทาโส ภเวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","อิตฺถํ มนุชปุตฺร: เสโวฺย ภวิตุํ นหิ, กินฺตุ เสวิตุํ พหูนำ ปริตฺราณมูลฺยารฺถํ สฺวปฺราณานฺ ทาตุญฺจาคต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","อนนฺตรํ ยิรีโหนคราตฺ เตษำ พหิรฺคมนสมเย ตสฺย ปศฺจาทฺ พหโว โลกา ววฺรชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","อปรํ วรฺตฺมปารฺศฺว อุปวิศนฺเตา ทฺวาวนฺเธา เตน มารฺเคณ ยีโศ รฺคมนํ นิศมฺย โปฺรจฺไจ: กถยามาสตุ:, เห ปฺรโภ ทายูท: สนฺตาน, อาวโย รฺทยำ วิเธหิฯ ");
INSERT INTO santha_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ตโต โลกา: สรฺเวฺว ตุษฺณีมฺภวตมิตฺยุกฺตฺวา เตา ตรฺชยามาสุ:; ตถาปิ เตา ปุนรุจฺไจ: กถยามาสตุ: เห ปฺรโภ ทายูท: สนฺตาน, อาวำ ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ตทานีํ ยีศุ: สฺถคิต: สนฺ ตาวาหูย ภาษิตวานฺ, ยุวโย: กฺฤเต มยา กึ กรฺตฺตรฺวฺยํ? ยุวำ กึ กามเยเถ? ");
INSERT INTO santha_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ตทา ตาวุกฺตวนฺเตา, ปฺรโภ เนตฺราณิ เนา ปฺรสนฺนานิ ภเวยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ตทานีํ ยีศุเสฺตา ปฺรติ ปฺรมนฺน: สนฺ ตโย เรฺนตฺราณิ ปสฺปรฺศ, เตไนว เตา สุวีกฺษาญฺจกฺราเต ตตฺปศฺจาตฺ ชคฺมุตุศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","อนนฺตรํ เตษุ ยิรูศาลมฺนครสฺย สมีปเวรฺตฺติโน ไชตุนนามกธราธรสฺย สมีปสฺถฺตึ ไพตฺผคิคฺรามมฺ อาคเตษุ, ยีศุ: ศิษฺยทฺวยํ เปฺรษยนฺ ชคาท, ");
INSERT INTO santha_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ยุวำ สมฺมุขสฺถคฺรามํ คตฺวา พทฺธำ ยำ สวตฺสำ ครฺทฺทภีํ หฐาตฺ ปฺราปฺสฺยถ:, ตำ โมจยิตฺวา มทนฺติกมฺ อานยตํฯ ");
INSERT INTO santha_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ตตฺร ยทิ กศฺจิตฺ กิญฺจิทฺ วกฺษฺยติ, ตรฺหิ วทิษฺยถ:, เอตสฺยำ ปฺรโภ: ปฺรโยชนมาเสฺต, เตน ส ตตฺกฺษณาตฺ ปฺรเหษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","สีโยน: กนฺยกำ ยูยํ ภาษธฺวมิติ ภารตีํฯ ปศฺย เต นมฺรศีล: สนฺ นฺฤป อารุหฺย ครฺทภีํฯ อรฺถาทารุหฺย ตทฺวตฺสมายาสฺยติ ตฺวทนฺติกํฯ ");
INSERT INTO santha_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ภวิษฺยทฺวาทิโนกฺตํ วจนมิทํ ตทา สผลมภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","อนนฺตรํ เตา ศฺษฺยิौ ยีโศ รฺยถานิเทศํ ตํ คฺรามํ คตฺวา ");
INSERT INTO santha_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ครฺทภีํ ตทฺวตฺสญฺจ สมานีตวนฺเตา, ปศฺจาตฺ ตทุปริ สฺวียวสนานี ปาตยิตฺวา ตมาโรหยามาสตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ตโต พหโว โลกา นิชวสนานิ ปถิ ปฺรสารยิตุมาเรภิเร, กติปยา ชนาศฺจ ปาทปปรฺณาทิกํ ฉิตฺวา ปถิ วิสฺตารยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","อคฺรคามิน: ปศฺจาทฺคามินศฺจ มนุชา อุจฺไจรฺชย ชย ทายูท: สนฺตาเนติ ชคทุ: ปรเมศฺวรสฺย นามฺนา ย อายาติ ส ธนฺย:, สรฺโวฺวปริสฺถสฺวรฺเคปิ ชยติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","อิตฺถํ ตสฺมินฺ ยิรูศาลมํ ปฺรวิษฺเฏ โก'ยมิติ กถนาตฺ กฺฤตฺสฺนํ นครํ จญฺจลมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ตตฺร โลโก: กถยามาสุ:, เอษ คาลีลฺปฺรเทศีย-นาสรตีย-ภวิษฺยทฺวาที ยีศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","อนนฺตรํ ยีศุรีศฺวรสฺย มนฺทิรํ ปฺรวิศฺย ตนฺมธฺยาตฺ กฺรยวิกฺรยิโณ วหิศฺจการ; วณิชำ มุทฺราสนานี กโปตวิกฺรยิณาญฺจสนานี จ นฺยุวฺชยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","อปรํ ตานุวาจ, เอษา ลิปิราเสฺต, \"มม คฺฤหํ ปฺรารฺถนาคฺฤหมิติ วิขฺยาสฺยติ\", กินฺตุ ยูยํ ตทฺ ทสฺยูนำ คหฺวรํ กฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ตทนนฺตรมฺ อนฺธขญฺจโลกาสฺตสฺย สมีปมาคตา:, ส ตานฺ นิรามยานฺ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ยทา ปฺรธานยาชกา อธฺยาปกาศฺจ เตน กฺฤตาเนฺยตานิ จิตฺรกรฺมฺมาณิ ททฺฤศุ:, ชย ชย ทายูท: สนฺตาน, มนฺทิเร พาลกานามฺ เอตาทฺฤศมฺ อุจฺจธฺวนึ ศุศฺรุวุศฺจ, ตทา มหากฺรุทฺธา พภูว:, ");
INSERT INTO santha_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ตํ ปปฺรจฺฉุศฺจ, อิเม ยทฺ วทนฺติ, ตตฺ กึ ตฺวํ ศฺฤโณษิ? ตโต ยีศุสฺตานฺ อโวจตฺ, สตฺยมฺ; สฺตนฺยปายิศิศูนาญฺจ พาลกานาญฺจ วกฺตฺรต:ฯ สฺวกียํ มหิมานํ ตฺวํ สํปฺรกาศยสิ สฺวยํฯ เอตทฺวากฺยํ ยูยํ กึ นาปฐต? ");
INSERT INTO santha_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ตตสฺตานฺ วิหาย ส นคราทฺ ไพถนิยาคฺรามํ คตฺวา ตตฺร รชนีํ ยาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","อนนฺตรํ ปฺรภาเต สติ ยีศุ: ปุนรปิ นครมาคจฺฉนฺ กฺษุธารฺตฺโต พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ตโต มารฺคปารฺศฺว อุฑุมฺพรวฺฤกฺษเมกํ วิโลกฺย ตตฺสมีปํ คตฺวา ปตฺราณิ วินา กิมปิ น ปฺราปฺย ตํ ปาทปํ โปฺรวาจ, อทฺยารภฺย กทาปิ ตฺวยิ ผลํ น ภวตุ; เตน ตตฺกฺษณาตฺ ส อุฑุมฺพรมาหีรุห: ศุษฺกตำ คต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ตทฺ ทฺฤษฺฏฺวา ศิษฺยา อาศฺจรฺยฺยํ วิชฺญาย กถยามาสุ:, อา:, อุฑุมฺวรปาทโป'ติตูรฺณํ ศุษฺโก'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ตโต ยีศุสฺตานุวาจ, ยุษฺมานหํ สตฺยํ วทามิ, ยทิ ยูยมสนฺทิคฺธา: ปฺรตีถ, ตรฺหิ ยูยมปิ เกวโลฑุมฺวรปาทปํ ปฺรตีตฺถํ กรฺตฺตุํ ศกฺษฺยถ, ตนฺน, ตฺวํ จลิตฺวา สาคเร ปเตติ วากฺยํ ยุษฺมาภิรสฺมิน ไศเล โปฺรกฺเตปิ ตไทว ตทฺ ฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ตถา วิศฺวสฺย ปฺรารฺถฺย ยุษฺมาภิ รฺยทฺ ยาจิษฺยเต, ตเทว ปฺราปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","อนนฺตรํ มนฺทิรํ ปฺรวิโศฺยปเทศนสมเย ตตฺสมีปํ ปฺรธานยาชกา: ปฺราจีนโลกาศฺจาคตฺย ปปฺรจฺฉุ:, ตฺวยา เกน สามรฺถฺยไนตานิ กรฺมฺมาณิ กฺริยนฺเต? เกน วา ตุภฺยเมตานิ สามรฺถฺยานิ ทตฺตานิ? ");
INSERT INTO santha_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ตโต ยีศุ: ปฺรตฺยวทตฺ, อหมปิ ยุษฺมานฺ วาจเมกำ ปฺฤจฺฉามิ, ยทิ ยูยํ ตทุตฺตรํ ทาตุํ ศกฺษฺยถ, ตทา เกน สามรฺเถฺยน กรฺมฺมาเณฺยตานิ กโรมิ, ตทหํ ยุษฺมานฺ วกฺษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","โยหโน มชฺชนํ กสฺยาชฺญยาภวตฺ? กิมีศฺวรสฺย มนุษฺยสฺย วา? ตตเสฺต ปรสฺปรํ วิวิจฺย กถยามาสุ:, ยทีศฺวรเสฺยติ วทามสฺตรฺหิ ยูยํ ตํ กุโต น ปฺรไตฺยต? วาจเมตำ วกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","มนุษฺยเสฺยติ วกฺตุมปิ โลเกโภฺย พิภีม:, ยต: สรฺไวฺวรปิ โยหนฺ ภวิษฺยทฺวาทีติ ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ตสฺมาตฺ เต ยีศุํ ปฺรตฺยวทนฺ, ตทฺ วยํ น วิทฺม:ฯ ตทา ส ตานุกฺตวานฺ, ตรฺหิ เกน สามรเถฺยน กรฺมฺมาเณฺยตานฺยหํ กโรมิ, ตทปฺยหํ ยุษฺมานฺ น วกฺษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","กสฺยจิชฺชนสฺย เทฺวา สุตาวาสฺตำ ส เอกสฺย สุตสฺย สมีปํ คตฺวา ชคาท, เห สุต, ตฺวมทฺย มม ทฺรากฺษากฺเษเตฺร กรฺมฺม กรฺตุํ วฺรชฯ ");
INSERT INTO santha_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ตต: ส อุกฺตวานฺ, น ยาสฺยามิ, กินฺตุ เศเษ'นุตปฺย ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","อนนฺตรํ โสนฺยสุตสฺย สมีปํ คตฺวา ตไถว กถฺติวานฺ; ตต: ส ปฺรตฺยุวาจ, มเหจฺฉ ยามิ, กินฺตุ น คต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","เอตโย: ปุตฺรโย รฺมเธฺย ปิตุรภิมตํ เกน ปาลิตํ? ยุษฺมาภิ: กึ พุธฺยเต? ตตเสฺต ปฺรตฺยูจุ:, ปฺรถเมน ปุुเตฺรณฯ ตทานีํ ยีศุสฺตานุวาจ, อหํ ยุษฺมานฺ ตถฺยํ วทามิ, จณฺฑาลา คณิกาศฺจ ยุษฺมากมคฺรต อีศฺวรสฺย ราชฺยํ ปฺรวิศนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ยโต ยุษฺมากํ สมีปํ โยหนิ ธรฺมฺมปเถนาคเต ยูยํ ตํ น ปฺรตีถ, กินฺตุ จณฺฑาลา คณิกาศฺจ ตํ ปฺรตฺยายนฺ, ตทฺ วิโลกฺยาปิ ยูยํ ปฺรเตฺยตุํ นาขิทฺยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","อปรเมกํ ทฺฤษฺฏานฺตํ ศฺฤณุต, กศฺจิทฺ คฺฤหสฺถ: เกฺษเตฺร ทฺรากฺษาลตา โรปยิตฺวา ตจฺจตุรฺทิกฺษุ วารณีํ วิธาย ตนฺมเธฺย ทฺรากฺษายนฺตฺรํ สฺถาปิตวานฺ, มาญฺจญฺจ นิรฺมฺมิตวานฺ, ตต: กฺฤษเกษุ ตตฺ เกฺษตฺรํ สมรฺปฺย สฺวยํ ทูรเทศํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ตทนนฺตรํ ผลสมย อุปสฺถิเต ส ผลานิ ปฺราปฺตุํ กฺฤษีวลานำ สมีปํ นิชทาสานฺ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","กินฺตุ กฺฤษีวลาสฺตสฺย ตานฺ ทาเสยานฺ ธฺฤตฺวา กญฺจน ปฺรหฺฤตวนฺต:, กญฺจน ปาษาไณราหตวนฺต:, กญฺจน จ หตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ปุนรปิ ส ปฺรภุ: ปฺรถมโต'ธิกทาเสยานฺ เปฺรษยามาส, กินฺตุ เต ตานฺ ปฺรตฺยปิ ตไถว จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","อนนฺตรํ มม สุเต คเต ตํ สมาทริษฺยนฺเต, อิตฺยุกฺตฺวา เศเษ ส นิชสุตํ เตษำ สนฺนิธึ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","กินฺตุ เต กฺฤษีวลา: สุตํ วีกฺษฺย ปรสฺปรมฺ อิติ มนฺตฺรยิตุมฺ อาเรภิเร, อยมุตฺตราธิการี วยเมนํ นิหตฺยาสฺยาธิการํ สฺววศีกริษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ปศฺจาตฺ เต ตํ ธฺฤตฺวา ทฺรากฺษากฺเษตฺราทฺ พหิ: ปาตยิตฺวาพธิษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ยทา ส ทฺรากฺษากฺเษตฺรปติราคมิษฺยติ, ตทา ตานฺ กฺฤษีวลานฺ กึ กริษฺยติ? ");
INSERT INTO santha_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ตตเสฺต ปฺรตฺยวทนฺ, ตานฺ กลุษิโณ ทารุณยาตนาภิราหนิษฺยติ, เย จ สมยานุกฺรมาตฺ ผลานิ ทาสฺยนฺติ, ตาทฺฤเศษุ กฺฤษีวเลษุ เกฺษตฺรํ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ตทา ยีศุนา เต คทิตา:, คฺรหณํ น กฺฤตํ ยสฺย ปาษาณสฺย นิจายไก:ฯ ปฺรธานปฺรสฺตร: โกเณ เสอว สํภวิษฺยติฯ เอตตฺ ปเรศิตุ: กรฺมฺมาสฺมทฺฤษฺฏาวทฺภุตํ ภเวตฺฯ ธรฺมฺมคฺรนฺเถ ลิขิตเมตทฺวจนํ ยุษฺมาภิ: กึ นาปาฐิ? ");
INSERT INTO santha_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ตสฺมาทหํ ยุษฺมานฺ วทามิ, ยุษฺมตฺต อีศฺวรียราชฺยมปนีย ผโลตฺปาทยิตฺรนฺยชาตเย ทายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","โย ชน เอตตฺปาษาโณปริ ปติษฺยติ, ตํ ส ภํกฺษฺยเต, กินฺตฺวยํ ปาษาโณ ยโสฺยปริ ปติษฺยติ, ตํ ส ธูลิวตฺ จูรฺณีกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ตทานีํ ปฺราธนยาชกา: ผิรูศินศฺจ ตเสฺยมำ ทฺฤษฺฏานฺตกถำ ศฺรุตฺวา โส'สฺมานุทฺทิศฺย กถิตวานฺ, อิติ วิชฺญาย ตํ ธรฺตฺตุํ เจษฺฏิตวนฺต:; ");
INSERT INTO santha_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","กินฺตุ โลเกโภฺย พิภฺยุ:, ยโต โลไก: ส ภวิษฺยทฺวาทีตฺยชฺญายิฯ ");
INSERT INTO santha_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","อนนฺตรํ ยีศุ: ปุนรปิ ทฺฤษฺฏานฺเตน ตานฺ อวาทีตฺ, ");
INSERT INTO santha_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","สฺวรฺคียราชฺยมฺ เอตาทฺฤศสฺย นฺฤปเต: สมํ, โย นิช ปุตฺรํ วิวาหยนฺ สรฺวฺวานฺ นิมนฺตฺริตานฺ อาเนตุํ ทาเสยานฺ ปฺรหิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","กินฺตุ เต สมาคนฺตุํ เนษฺฏวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ตโต ราชา ปุนรปิ ทาสานนฺยานฺ อิตฺยุกฺตฺวา เปฺรษยามาส, นิมนฺตฺริตานฺ วทต, ปศฺยต, มม เภชฺยมาสาทิตมาเสฺต, นิชวฺฏษาทิปุษฺฏชนฺตูนฺ มารยิตฺวา สรฺวฺวํ ขาทฺยทฺรวฺยมาสาทิตวานฺ, ยูยํ วิวาหมาคจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ตถปิ เต ตุจฺฉีกฺฤตฺย เกจิตฺ นิชกฺเษตฺรํ เกจิทฺ วาณิชฺยํ ปฺรติ สฺวสฺวมารฺเคณ จลิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","อเนฺย โลกาสฺตสฺย ทาเสยานฺ ธฺฤตฺวา เทาราตฺมฺยํ วฺยวหฺฤตฺย ตานวธิษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","อนนฺตรํ ส นฺฤปติสฺตำ วารฺตฺตำ ศฺรุตฺวา กฺรุธฺยนฺ ไสนฺยานิ ปฺรหิตฺย ตานฺ ฆาตกานฺ หตฺวา เตษำ นครํ ทาหยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ตต: ส นิชทาเสยานฺ พภาเษ, วิวาหียํ โภชฺยมาสาทิตมาเสฺต, กินฺตุ นิมนฺตฺริตา ชนา อโยคฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ตสฺมาทฺ ยูยํ ราชมารฺคํ คตฺวา ยาวโต มนุชานฺ ปศฺยต, ตาวเตอว วิวาหียโภชฺยาย นิมนฺตฺรยตฯ ");
INSERT INTO santha_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ตทา เต ทาเสยา ราชมารฺคํ คตฺวา ภทฺรานฺ อภทฺรานฺ วา ยาวโต ชนานฺ ททฺฤศุ:, ตาวเตอว สํคฺฤหฺยานยนฺ; ตโต'ภฺยาคตมนุไช รฺวิวาหคฺฤหมฺ อปูรฺยฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ตทานีํ ส ราชา สรฺวฺวานภฺยาคตานฺ ทฺรษฺฏุมฺ อภฺยนฺตรมาคตวานฺ; ตทา ตตฺร วิวาหียวสนหีนเมกํ ชนํ วีกฺษฺย ตํ ชคาทฺ, ");
INSERT INTO santha_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","เห มิตฺร,ตฺวํ วิวาหียวสนํ วินา กถมตฺร ปฺรวิษฺฏวานฺ? เตน ส นิรุตฺตโร พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ตทา ราชา นิชานุจรานฺ อวทตฺ, เอตสฺย กรจรณานฺ พทฺธา ยตฺร โรทนํ ทนฺไตรฺทนฺตฆรฺษณญฺจ ภวติ, ตตฺร วหิรฺภูตตมิเสฺร ตํ นิกฺษิปตฯ ");
INSERT INTO santha_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","อิตฺถํ พหว อาหูตา อลฺเป มโนภิมตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","อนนฺตรํ ผิรูศิน: ปฺรคตฺย ยถา สํลาเปน ตมฺ อุนฺมาเถ ปาตเยยุสฺตถา มนฺตฺรยิตฺวา ");
INSERT INTO santha_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","เหโรทียมนุไช: สากํ นิชศิษฺยคเณน ตํ ปฺรติ กถยามาสุ:, เห คุโร, ภวานฺ สตฺย: สตฺยมีศฺวรียมารฺคมุปทิศติ, กมปิ มานุษํ นานุรุธฺยเต, กมปิ นาเปกฺษเต จ, ตทฺ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","อต: ไกสรภูปาย กโร'สฺมากํ ทาตโวฺย น วา? อตฺร ภวตา กึ พุธฺยเต? ตทฺ อสฺมานฺ วทตุฯ ");
INSERT INTO santha_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ตโต ยีศุเสฺตษำ ขลตำ วิชฺญาย กถิตวานฺ, เร กปฏิน: ยุยํ กุโต มำ ปริกฺษเธฺว? ");
INSERT INTO santha_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ตตฺกรทานสฺย มุทฺรำ มำ ทรฺศยตฯ ตทานีํ ไตสฺตสฺย สมีปํ มุทฺราจตุรฺถภาค อานีเต ");
INSERT INTO santha_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ส ตานฺ ปปฺรจฺฉ, อตฺร กเสฺยยํ มูรฺตฺติ รฺนาม จาเสฺต? เต ชคทุ:, ไกสรภูปสฺยฯ ");
INSERT INTO santha_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ตต: ส อุกฺตวาน, ไกสรสฺย ยตฺ ตตฺ ไกสราย ทตฺต, อีศฺวรสฺย ยตฺ ตทฺ อีศฺวราย ทตฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","อิติ วากฺยํ นิศมฺย เต วิสฺมยํ วิชฺญาย ตํ วิหาย จลิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ตสฺมินฺนหนิ สิทูกิโน'รฺถาตฺ ศฺมศานาตฺ โนตฺถาสฺยนฺตีติ วากฺยํ เย วทนฺติ, เต ยีเศाรนฺติกมฺ อาคตฺย ปปฺรจฺฉุ:, ");
INSERT INTO santha_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","เห คุโร, กศฺจินฺมนุชศฺเจตฺ นิ:สนฺตาน: สนฺ ปฺราณานฺ ตฺยชติ, ตรฺหิ ตสฺย ภฺราตา ตสฺย ชายำ วฺยุหฺย ภฺราตุ: สนฺตานมฺ อุตฺปาทยิษฺยตีติ มูสา อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","กินฺตฺวสฺมากมตฺร เก'ปิ ชนา: สปฺตสโหทรา อาสนฺ, เตษำ เชฺยษฺฐ เอกำ กนฺยำ วฺยวหาตฺ, อปรํ ปฺราณตฺยาคกาเล สฺวยํ นิ:สนฺตาน: สนฺ ตำ สฺตฺริยํ สฺวภฺราตริ สมรฺปิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ตโต ทฺวิตียาทิสปฺตมานฺตาศฺจ ตไถว จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","เศเษ สาปี นารี มมารฯ ");
INSERT INTO santha_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","มฺฤตานามฺ อุตฺถานสมเย เตษำ สปฺตานำ มเธฺย สา นารี กสฺย ภารฺยฺยา ภวิษฺยติ? ยสฺมาตฺ สรฺวฺเวอว ตำ วฺยวหนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ตโต ยีศุ: ปฺรตฺยวาทีตฺ, ยูยํ ธรฺมฺมปุสฺตกมฺ อีศฺวรียำ ศกฺติญฺจ น วิชฺญาย ภฺรานฺติมนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","อุตฺถานปฺราปฺตา โลกา น วิวหนฺติ, น จ วาจา ทียนฺเต, กินฺตฺวีศฺวรสฺย สฺวรฺคสฺถทูตานำ สทฺฤศา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","อปรํ มฺฤตานามุตฺถานมธิ ยุษฺมานฺ ปฺรตียมีศฺวโรกฺติ:, ");
INSERT INTO santha_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"อหมิพฺราหีม อีศฺวร อิสฺหาก อีศฺวโร ยากูพ อีศฺวร\" อิติ กึ ยุษฺมาภิ รฺนาปาฐิ? กินฺตฺวีศฺวโร ชีวตามฺ อีศฺวร:, ส มฺฤตานามีศฺวโร นหิฯ ");
INSERT INTO santha_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","อิติ ศฺรุตฺวา สรฺเวฺว โลกาสฺตโสฺยปเทศาทฺ วิสฺมยํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","อนนฺตรํ สิทูกินามฺ นิรุตฺตรตฺววารฺตำ นิศมฺย ผิรูศิน เอกตฺร มิลิตวนฺต:, ");
INSERT INTO santha_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","เตษาเมโก วฺยวสฺถาปโก ยีศุํ ปรีกฺษิตุํ ปปจฺฉ, ");
INSERT INTO santha_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","เห คุโร วฺยวสฺถาศาสฺตฺรมเธฺย กาชฺญา เศฺรษฺฐา? ");
INSERT INTO santha_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ตโต ยีศุรุวาจ, ตฺวํ สรฺวฺวานฺต:กรไณ: สรฺวฺวปฺราไณ: สรฺวฺวจิตฺไตศฺจ สากํ ปฺรเภา ปรเมศฺวเร ปฺรียสฺว, ");
INSERT INTO santha_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","เอษา ปฺรถมมหาชฺญาฯ ตสฺยา: สทฺฤศี ทฺวิตียาชฺไญษา, ");
INSERT INTO santha_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ตว สมีปวาสินิ สฺวาตฺมนีว เปฺรม กุรุฯ ");
INSERT INTO santha_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","อนโย รฺทฺวโยราชฺญโย: กฺฤตฺสฺนวฺยวสฺถายา ภวิษฺยทฺวกฺตฺฤคฺรนฺถสฺย จ ภารสฺติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","อนนฺตรํ ผิรูศินามฺ เอกตฺร สฺถิติกาเล ยีศุสฺตานฺ ปปฺรจฺฉ, ");
INSERT INTO santha_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ขฺรีษฺฏมธิ ยุษฺมากํ กีทฺฤคฺโพโธ ชายเต? ส กสฺย สนฺตาน:? ตตเสฺต ปฺรตฺยวทนฺ, ทายูท: สนฺตาน:ฯ ");
INSERT INTO santha_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ตทา ส อุกฺตวานฺ, ตรฺหิ ทายูทฺ กถมฺ อาตฺมาธิษฺฐาเนน ตํ ปฺรภุํ วทติ ? ");
INSERT INTO santha_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ยถา มม ปฺรภุมิทํ วากฺยมวทตฺ ปรเมศฺวร:ฯ ตวารีนฺ ปาทปีฐํ เต ยาวนฺนหิ กโรมฺยหํฯ ตาวตฺ กาลํ มทีเย ตฺวํ ทกฺษปารฺศฺว อุปาวิศฯ อโต ยทิ ทายูทฺ ตํ ปฺรภุํ วทติ, รฺติห ส กถํ ตสฺย สนฺตาโน ภวติ? ");
INSERT INTO santha_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ตทานีํ เตษำ โกปิ ตทฺวากฺยสฺย กิมปฺยุตฺตรํ ทาตุํ นาศกฺโนตฺ; ");
INSERT INTO santha_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ตทฺทินมารภฺย ตํ กิมปิ วากฺยํ ปฺรษฺฏุํ กสฺยาปิ สาหโส นาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","อนนฺตรํ ยีศุ รฺชนนิวหํ ศิษฺยำศฺจาวทตฺ, ");
INSERT INTO santha_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","อธฺยาปกา: ผิรูศินศฺจ มูสาสเน อุปวิศนฺติ, ");
INSERT INTO santha_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","อตเสฺต ยุษฺมานฺ ยทฺยตฺ มนฺตุมฺ อาชฺญาปยนฺติ, ตตฺ มนฺยธฺวํ ปาลยธฺวญฺจ, กินฺตุ เตษำ กรฺมฺมานุรูปํ กรฺมฺม น กุรุธฺวํ; ยตเสฺตษำ วากฺยมาตฺรํ สารํ การฺเยฺย กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","เต ทุรฺวฺวหานฺ คุรุตรานฺ ภารานฺ พทฺวฺวา มนุษฺยาณำ สฺกนฺเธปริ สมรฺปยนฺติ, กินฺตุ สฺวยมงฺคุไลฺยกยาปิ น จาลยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","เกวลํ โลกทรฺศนาย สรฺวฺวกรฺมฺมาณิ กุรฺวฺวนฺติ; ผลต: ปฏฺฏพนฺธานฺ ปฺรสารฺยฺย ธารยนฺติ, สฺววสฺเตฺรษุ จ ทีรฺฆคฺรนฺถีนฺ ธารยนฺติ; ");
INSERT INTO santha_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","โภชนภวน อุจฺจสฺถานํ, ภชนภวเน ปฺรธานมาสนํ, ");
INSERT INTO santha_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","หฏฺเฐ นมสฺการํ คุรุริติ สมฺโพธนญฺไจตานิ สรฺวฺวาณิ วาญฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","กินฺตุ ยูยํ คุรว อิติ สมฺโพธนียา มา ภวต, ยโต ยุษฺมากมฺ เอก: ขฺรีษฺเฏอว คุรุ ");
INSERT INTO santha_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","รฺยูยํ สรฺเวฺว มิโถ ภฺราตรศฺจฯ ปุน: ปฺฤถิวฺยำ กมปิ ปิเตติ มา สมฺพุธฺยธฺวํ, ยโต ยุษฺมากเมก: สฺวรฺคสฺเถอว ปิตาฯ ");
INSERT INTO santha_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ยูยํ นายเกติ สมฺภาษิตา มา ภวต, ยโต ยุษฺมากเมก: ขฺรีษฺเฏอว นายก:ฯ ");
INSERT INTO santha_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","อปรํ ยุษฺมากํ มเธฺย ย: ปุมานฺ เศฺรษฺฐ: ส ยุษฺมานฺ เสวิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ยโต ย: สฺวมุนฺนมติ, ส นต: กริษฺยเต; กินฺตุ ย: กศฺจิตฺ สฺวมวนตํ กโรติ, ส อุนฺนต: กริษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","หนฺต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยํ มนุชานำ สมกฺษํ สฺวรฺคทฺวารํ รุนฺธ, ยูยํ สฺวยํ เตน น ปฺรวิศถ, ปฺรวิวิกฺษูนปิ วารยถฯ วต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ ยูยํ ฉลาทฺ ทีรฺฆํ ปฺรารฺถฺย วิธวานำ สรฺวฺวสฺวํ คฺรสถ, ยุษฺมากํ โฆรตรทณฺโฑ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","หนฺต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยเมกํ สฺวธรฺมฺมาวลมฺพินํ กรฺตฺตุํ สาครํ ภูมณฺฑลญฺจ ปฺรทกฺษิณีกุรุถ, ");
INSERT INTO santha_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","กญฺจน ปฺราปฺย สฺวโต ทฺวิคุณนรกภาชนํ ตํ กุรุถฯ ");
INSERT INTO santha_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","วต อนฺธปถทรฺศกา: สรฺเวฺว, ยูยํ วทถ, มนฺทิรสฺย ศปถกรณาตฺ กิมปิ น เทยํ; กินฺตุ มนฺทิรสฺถสุวรฺณสฺย ศปถกรณาทฺ เทยํฯ ");
INSERT INTO santha_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","เห มูฒา เห อนฺธา: สุวรฺณํ ตตฺสุวรฺณปาวกมนฺทิรมฺ เอตโยรุภโย รฺมเธฺย กึ เศฺรย:? ");
INSERT INTO santha_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","อนฺยจฺจ วทถ, ยชฺญเวทฺยา: ศปถกรณาตฺ กิมปิ น เทยํ, กินฺตุ ตทุปริสฺถิตสฺย ไนเวทฺยสฺย ศปถกรณาทฺ เทยํฯ ");
INSERT INTO santha_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","เห มูฒา เห อนฺธา:, ไนเวทฺยํ ตนฺไนเวทฺยปาวกเวทิเรตโยรุภโย รฺมเธฺย กึ เศฺรย:? ");
INSERT INTO santha_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","อต: เกนจิทฺ ยชฺญเวทฺยา: ศปเถ กฺฤเต ตทุปริสฺถสฺย สรฺวฺวสฺย ศปถ: กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","เกนจิตฺ มนฺทิรสฺย ศปเถ กฺฤเต มนฺทิรตนฺนิวาสิโน: ศปถ: กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","เกนจิตฺ สฺวรฺคสฺย ศปเถ กฺฤเต อีศฺวรียสึหาสนตทุปรฺยฺยุปวิษฺฏโย: ศปถ: กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","หนฺต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยํ โปทินายา: สิตจฺฉตฺรายา ชีรกสฺย จ ทศมำศานฺ ทตฺถ, กินฺตุ วฺยวสฺถายา คุรุตรานฺ นฺยายทยาวิศฺวาสานฺ ปริตฺยชถ; อิเม ยุษฺมาภิราจรณียา อมี จ น ลํฆนียา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","เห อนฺธปถทรฺศกา ยูยํ มศกานฺ อปสารยถ, กินฺตุ มหางฺคานฺ คฺรสถฯ ");
INSERT INTO santha_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","หนฺต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยํ ปานปาตฺราณำ โภชนปาตฺราณาญฺจ พหิ: ปริษฺกุรุถ; กินฺตุ ตทภฺยนฺตรํ ทุราตฺมตยา กลุเษณ จ ปริปูรฺณมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","เห อนฺธา: ผิรูศิโลกา อาเทา ปานปาตฺราณำ โภชนปาตฺราณาญฺจาภฺยนฺตรํ ปริษฺกุรุต, เตน เตษำ พหิรปิ ปริษฺการิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","หนฺต กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยํ ศุกฺลีกฺฤตศฺมศานสฺวรูปา ภวถ, ยถา ศฺมศานภวนสฺย พหิศฺจารุ, กินฺตฺวภฺยนฺตรํ มฺฤตโลกานำ กีกไศ: สรฺวฺวปฺรการมเลน จ ปริปูรฺณมฺ; ");
INSERT INTO santha_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ตไถว ยูยมปิ โลกานำ สมกฺษํ พหิรฺธารฺมฺมิกา: กินฺตฺวนฺต:กรเณษุ เกวลกาปฏฺยาธรฺมฺมาภฺยำ ปริปูรฺณา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","หา หา กปฏิน อุปาธฺยายา: ผิรูศินศฺจ, ยูยํ ภวิษฺยทฺวาทินำ ศฺมศานเคหํ นิรฺมฺมาถ, สาธูนำ ศฺมศานนิเกตนํ โศภยถ ");
INSERT INTO santha_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","วทถ จ ยทิ วยํ เสฺวษำ ปูรฺวฺวปุรุษาณำ กาล อสฺถาสฺยาม, ตรฺหิ ภวิษฺยทฺวาทินำ โศณิตปาตเน เตษำ สหภาคิโน นาภวิษฺยามฯ ");
INSERT INTO santha_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","อโต ยูยํ ภวิษฺยทฺวาทิฆาตกานำ สนฺตานา อิติ สฺวยเมว เสฺวษำ สากฺษฺยํ ทตฺถฯ ");
INSERT INTO santha_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","อโต ยูยํ นิชปูรฺวฺวปุรุษาณำ ปริมาณปาตฺรํ ปริปูรยตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","เร ภุชคา: กฺฤษฺณภุชควํศา:, ยูยํ กถํ นรกทณฺฑาทฺ รกฺษิษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ปศฺยต, ยุษฺมากมนฺติกมฺ อหํ ภวิษฺยทฺวาทิโน พุทฺธิมต อุปาธฺยายำศฺจ เปฺรษยิษฺยามิ, กินฺตุ เตษำ กติปยา ยุษฺมาภิ รฺฆานิษฺยนฺเต, กฺรุเศ จ ฆานิษฺยนฺเต, เกจิทฺ ภชนภวเน กษาภิราฆานิษฺยนฺเต, นคเร นคเร ตาฑิษฺยนฺเต จ; ");
INSERT INTO santha_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","เตน สตฺปุรุษสฺย หาพิโล รกฺตปาตมารภฺย เพริขิย: ปุตฺรํ ยํ สิขริยํ ยูยํ มนฺทิรยชฺญเวโทฺย รฺมเธฺย หตวนฺต:, ตทียโศณิตปาตํ ยาวทฺ อสฺมินฺ เทเศ ยาวตำ สาธุปุรุษาณำ โศณิตปาโต 'ภวตฺ ตตฺ สรฺเวฺวษามาคสำ ทณฺฑา ยุษฺมาสุ วรฺตฺติษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","อหํ ยุษฺมานฺต ตถฺยํ วทามิ, วิทฺยมาเน'สฺมินฺ ปุรุเษ สรฺเวฺว วรฺตฺติษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","เห ยิรูศาลมฺ เห ยิรูศาลมฺ นคริ ตฺวํ ภวิษฺยทฺวาทิโน หตวตี, ตว สมีปํ เปฺรริตำศฺจ ปาษาไณราหตวตี, ยถา กุกฺกุฏี ศาวกานฺ ปกฺษาธ: สํคฺฤหฺลาติ, ตถา ตว สนฺตานานฺ สํคฺรหีตุํ อหํ พหุวารมฺ ไอจฺฉํ; กินฺตุ ตฺวํ น สมมนฺยถา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ปศฺยต ยษฺมากํ วาสสฺถานมฺ อุจฺฉินฺนํ ตฺยกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","อหํ ยุษฺมานฺ ตถฺยํ วทามิ, ย: ปรเมศฺวรสฺย นามฺนาคจฺฉติ, ส ธนฺย อิติ วาณีํ ยาวนฺน วทิษฺยถ, ตาวตฺ มำ ปุน รฺน ทฺรกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","อนนฺตรํ ยีศุ รฺยทา มนฺทิราทฺ พหิ รฺคจฺฉติ, ตทานีํ ศิษฺยาสฺตํ มนฺทิรนิรฺมฺมาณํ ทรฺศยิตุมาคตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ตโต ยีศุสฺตานุวาจ, ยูยํ กิเมตานิ น ปศฺยถ? ยุษฺมานหํ สตฺยํ วทามิ, เอตนฺนิจยนสฺย ปาษาไณกมปฺยนฺยปาษาเณाปริ น สฺถาสฺยติ สรฺวฺวาณิ ภูมิสาตฺ การิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","อนนฺตรํ ตสฺมินฺ ไชตุนปรฺวฺวโตปริ สมุปวิษฺเฏ ศิษฺยาสฺตสฺย สมีปมาคตฺย คุปฺตํ ปปฺรจฺฉุ:, เอตา ฆฏนา: กทา ภวิษฺยนฺติ? ภวต อาคมนสฺย ยุคานฺตสฺย จ กึ ลกฺษฺม? ตทสฺมานฺ วทตุฯ ");
INSERT INTO santha_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ตทานีํ ยีศุสฺตานโวจตฺ, อวธทฺวฺวํ, โกปิ ยุษฺมานฺ น ภฺรมเยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","พหโว มม นาม คฺฤหฺลนฺต อาคมิษฺยนฺติ, ขฺรีษฺโฏ'หเมเวติ วาจํ วทนฺโต พหูนฺ ภฺรมยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ยูยญฺจ สํคฺรามสฺย รณสฺย จาฑมฺพรํ โศฺรษฺยถ, อวธทฺวฺวํ เตน จญฺจลา มา ภวต, เอตานฺยวศฺยํ ฆฏิษฺยนฺเต, กินฺตุ ตทา ยุคานฺโต นหิฯ ");
INSERT INTO santha_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","อปรํ เทศสฺย วิปกฺโษ เทโศ ราชฺยสฺย วิปกฺโษ ราชฺยํ ภวิษฺยติ, สฺถาเน สฺถาเน จ ทุรฺภิกฺษํ มหามารี ภูกมฺปศฺจ ภวิษฺยนฺติ, ");
INSERT INTO santha_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","เอตานิ ทุ:โขปกฺรมา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ตทานีํ โลกา ทุ:ขํ โภชยิตุํ ยุษฺมานฺ ปรกเรษุ สมรฺปยิษฺยนฺติ หนิษฺยนฺติ จ, ตถา มม นามการณาทฺ ยูยํ สรฺวฺวเทศียมนุชานำ สมีเป ฆฺฤณารฺหา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","พหุษุ วิฆฺนํ ปฺราปฺตวตฺสุ ปรสฺปรมฺ ฤृตียำ กฺฤตวตฺสุ จ เอโก'ปรํ ปรกเรษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ตถา พหโว มฺฤษาภวิษฺยทฺวาทิน อุปสฺถาย พหูนฺ ภฺรมยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ทุษฺกรฺมฺมณำ พาหุลฺยาญฺจ พหูนำ เปฺรม ศีตลํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","กินฺตุ ย: กศฺจิตฺ เศษํ ยาวทฺ ไธรฺยฺยมาศฺรยเต, เสอว ปริตฺรายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","อปรํ สรฺวฺวเทศียโลกานฺ ปฺรติมากฺษี ภวิตุํ ราชสฺย ศุภสมาจาร: สรฺวฺวชคติ ปฺรจาริษฺยเต, เอตาทฺฤศิ สติ ยุคานฺต อุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","อโต ยตฺ สรฺวฺวนาศกฺฤทฺฆฺฤณารฺหํ วสฺตุ ทานิเยลฺภวิษฺยทฺวทินา โปฺรกฺตํ ตทฺ ยทา ปุณฺยสฺถาเน สฺถาปิตํ ทฺรกฺษฺยถ, (ย: ปฐติ, ส พุธฺยตำ) ");
INSERT INTO santha_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ตทานีํ เย ยิหูทียเทเศ ติษฺฐนฺติ, เต ปรฺวฺวเตษุ ปลายนฺตำฯ ");
INSERT INTO santha_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ย: กศฺจิทฺ คฺฤหปฺฤษฺเฐ ติษฺฐติ, ส คฺฤหาตฺ กิมปิ วสฺตฺวาเนตุมฺ อเธा นาวโรเหตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ยศฺจ เกฺษเตฺร ติษฺฐติ, โสปิ วสฺตฺรมาเนตุํ ปราวฺฤตฺย น ยายาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ตทานีํ ครฺภิณีสฺตนฺยปายยิตฺรีณำ ทุรฺคติ รฺภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","อโต ยษฺมากํ ปลายนํ ศีตกาเล วิศฺรามวาเร วา ยนฺน ภเวตฺ, ตทรฺถํ ปฺรารฺถยธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","อา ชคทารมฺภาทฺ เอตตฺกาลปรฺยฺยนนฺตํ ยาทฺฤศ: กทาปิ นาภวตฺ น จ ภวิษฺยติ ตาทฺฤโศ มหาเกฺลศสฺตทานีมฺ อุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ตสฺย เกฺลศสฺย สมโย ยทิ หฺโสฺว น กฺริเยต, ตรฺหิ กสฺยาปิ ปฺราณิโน รกฺษณํ ภวิตุํ น ศกฺนุยาตฺ, กินฺตุ มโนนีตมนุชานำ กฺฤเต ส กาโล หฺสฺวีกริษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","อปรญฺจ ปศฺยต, ขฺรีษฺโฏ'ตฺร วิทฺยเต, วา ตตฺร วิทฺยเต, ตทานีํ ยที กศฺจิทฺ ยุษฺมาน อิติ วากฺยํ วทติ, ตถาปิ ตตฺ น ปฺรตีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ยโต ภากฺตขฺรีษฺฏา ภากฺตภวิษฺยทฺวาทินศฺจ อุปสฺถาย ยานิ มหนฺติ ลกฺษฺมาณิ จิตฺรกรฺมฺมาณิ จ ปฺรกาศยิษฺยนฺติ, ไต รฺยทิ สมฺภเวตฺ ตรฺหิ มโนนีตมานวา อปิ ภฺรามิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ปศฺยต, ฆฏนาต: ปูรฺวฺวํ ยุษฺมานฺ วารฺตฺตามฺ อวาทิษมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","อต: ปศฺยต, ส ปฺรานฺตเร วิทฺยต อิติ วาเกฺย เกนจิตฺ กถิเตปิ พหิ รฺมา คจฺฉต, วา ปศฺยต, โสนฺต:ปุเร วิทฺยเต, เอตทฺวากฺย อุกฺเตปิ มา ปฺรตีตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ยโต ยถา วิทฺยุตฺ ปูรฺวฺวทิโศ นิรฺคตฺย ปศฺจิมทิศํ ยาวตฺ ปฺรกาศเต, ตถา มานุษปุตฺรสฺยาปฺยาคมนํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ยตฺร ศวสฺติษฺฐติ, ตเตฺรว คฺฤธฺรา มิลนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","อปรํ ตสฺย เกฺลศสมยสฺยาวฺยวหิตปรตฺร สูรฺยฺยสฺย เตโช โลปฺสฺยเต, จนฺทฺรมา โชฺยสฺนำ น กริษฺยติ, นภโส นกฺษตฺราณิ ปติษฺยนฺติ, คคณียา คฺรหาศฺจ วิจลิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ตทานีมฺ อากาศมเธฺย มนุชสุตสฺย ลกฺษฺม ทรฺศิษฺยเต, ตโต นิชปรากฺรเมณ มหาเตชสา จ เมฆารูฒํ มนุชสุตํ นภสาคจฺฉนฺตํ วิโลกฺย ปฺฤถิวฺยา: สรฺวฺววํศียา วิลปิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ตทานีํ ส มหาศพฺทายมานตูรฺยฺยา วาทกานฺ นิชทูตานฺ ปฺรเหษฺยติ, เต โวฺยมฺน เอกสีมาโต'ปรสีมำ ยาวตฺ จตุรฺทิศสฺตสฺย มโนนีตชนานฺ อานีย เมลยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","อุฑุมฺพรปาทปสฺย ทฺฤษฺฏานฺตํ ศิกฺษธฺวํ; ยทา ตสฺย นวีนา: ศาขา ชายนฺเต, ปลฺลวาทิศฺจ นิรฺคจฺฉติ, ตทา นิทาฆกาล: สวิโธ ภวตีติ ยูยํ ชานีถ; ");
INSERT INTO santha_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ตทฺวทฺ เอตา ฆฏนา ทฺฤษฺฏฺวา ส สมโย ทฺวาร อุปาสฺถาทฺ อิติ ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ยุษฺมานหํ ตถฺยํ วทามิ, อิทานีนฺตนชนานำ คมนาตฺ ปูรฺวฺวเมว ตานิ สรฺวฺวาณิ ฆฏิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","นโภเมทิโนฺย รฺลุปฺตโยรปิ มม วากฺ กทาปิ น โลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","อปรํ มม ตาตํ วินา มานุษ: สฺวรฺคโสฺถ ทูโต วา โกปิ ตทฺทินํ ตทฺทณฺฑญฺจ น ชฺญาปยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","อปรํ โนเห วิทฺยมาเน ยาทฺฤศมภวตฺ ตาทฺฤศํ มนุชสุตสฺยาคมนกาเลปิ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ผลโต ชลาปฺลาวนาตฺ ปูรฺวฺวํ ยทฺทินํ ยาวตฺ โนห: โปตํ นาโรหตฺ, ตาวตฺกาลํ ยถา มนุษฺยา โภชเน ปาเน วิวหเน วิวาหเน จ ปฺรวฺฤตฺตา อาสนฺ; ");
INSERT INTO santha_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","อปรมฺ อาปฺลาวิโตยมาคตฺย ยาวตฺ สกลมนุชานฺ ปฺลาวยิตฺวา นานยตฺ, ตาวตฺ เต ยถา น วิทามาสุ:, ตถา มนุชสุตาคมเนปิ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ตทา เกฺษตฺรสฺถิตโยรฺทฺวโยเรโก ธาริษฺยเต, อปรสฺตฺยาชิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ตถา เปษณฺยา ปึษโตฺยรุภโย โรฺยษิโตเรกา ธาริษฺยเต'ปรา ตฺยาชิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ยุษฺมากํ ปฺรภุ: กสฺมินฺ ทณฺฑ อาคมิษฺยติ, ตทฺ ยุษฺมาภิ รฺนาวคมฺยเต, ตสฺมาตฺ ชาคฺรต: สนฺตสฺติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","กุตฺร ยาเม เสฺตน อาคมิษฺยตีติ เจทฺ คฺฤหโสฺถ ชฺญาตุมฺ อศกฺษฺยตฺ, ตรฺหิ ชาคริตฺวา ตํ สนฺธึ กรฺตฺติตุมฺ อวารยิษฺยตฺ ตทฺ ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ยุษฺมาภิรวธียตำ, ยโต ยุษฺมาภิ รฺยตฺร น พุธฺยเต, ตไตฺรว ทณฺเฑ มนุชสุต อายาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ปฺรภุ รฺนิชปริวารานฺ ยถากาลํ โภชยิตุํ ยํ ทาสมฺ อธฺยกฺษีกฺฤตฺย สฺถาปยติ, ตาทฺฤโศ วิศฺวาโสฺย ธีมานฺ ทาส: ก:? ");
INSERT INTO santha_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ปฺรภุราคตฺย ยํ ทาสํ ตถาจรนฺตํ วีกฺษเต, เสอว ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ยุษฺมานหํ สตฺยํ วทามิ, ส ตํ นิชสรฺวฺวสฺวสฺยาธิปํ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","กินฺตุ ปฺรภุราคนฺตุํ วิลมฺพต อิติ มนสิ จินฺตยิตฺวา โย ทุษฺโฏ ทาโส ");
INSERT INTO santha_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'ปรทาสานฺ ปฺรหรฺตฺตุํ มตฺตานำ สงฺเค โภกฺตุํ ปาตุญฺจ ปฺรวรฺตฺตเต, ");
INSERT INTO santha_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ส ทาโส ยทา นาเปกฺษเต, ยญฺจ ทณฺฑํ น ชานาติ, ตตฺกาเลอว ตตฺปฺรภุรุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ตทา ตํ ทณฺฑยิตฺวา ยตฺร สฺถาเน โรทนํ ทนฺตฆรฺษณญฺจาสาเต, ตตฺร กปฏิภิ: สากํ ตทฺทศำ นิรูปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ยา ทศ กนฺยา: ปฺรทีปานฺ คฺฤหฺลโตฺย วรํ สากฺษาตฺ กรฺตฺตุํ พหิริตา:, ตาภิสฺตทา สฺวรฺคียราชฺยสฺย สาทฺฤศฺยํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ตาสำ กนฺยานำ มเธฺย ปญฺจ สุธิย: ปญฺจ ทุรฺธิย อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ยา ทุรฺธิยสฺตา: ปฺรทีปานฺ สงฺเค คฺฤหีตฺวา ไตลํ น ชคฺฤหุ:, ");
INSERT INTO santha_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","กินฺตุ สุธิย: ปฺรทีปานฺ ปาเตฺรณ ไตลญฺจ ชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","อนนฺตรํ วเร วิลมฺพิเต ตา: สรฺวฺวา นิทฺราวิษฺฏา นิทฺรำ ชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","อนนฺตรมฺ อรฺทฺธราเตฺร ปศฺยต วร อาคจฺฉติ, ตํ สากฺษาตฺ กรฺตฺตุํ พหิรฺยาเตติ ชนรวาตฺ ");
INSERT INTO santha_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ตา: สรฺวฺวา: กนฺยา อุตฺถาย ปฺรทีปานฺ อาสาทยิตุํ อารภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ตโต ทุรฺธิย: สุธิย อูจุ:, กิญฺจิตฺ ไตลํ ทตฺต, ปฺรทีปา อสฺมากํ นิรฺวฺวาณา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","กินฺตุ สุธิย: ปฺรตฺยวทนฺ, ทตฺเต ยุษฺมานสฺมำศฺจ ปฺรติ ไตลํ นฺยูนีภเวตฺ, ตสฺมาทฺ วิเกฺรตฺฤณำ สมีปํ คตฺวา สฺวารฺถํ ไตลํ กฺรีณีตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ตทา ตาสุ เกฺรตุํ คตาสุ วร อาชคาม, ตโต ยา: สชฺชิตา อาสนฺ, ตาเสฺตน สากํ วิวาหียํ เวศฺม ปฺรวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","อนนฺตรํ ทฺวาเร รุทฺเธ อปรา: กนฺยา อาคตฺย ชคทุ:, เห ปฺรโภ, เห ปฺรโภ, อสฺมานฺ ปฺรติ ทฺวารํ โมจยฯ ");
INSERT INTO santha_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","กินฺตุ ส อุกฺตวานฺ, ตถฺยํ วทามิ, ยุษฺมานหํ น เวทฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","อโต ชาคฺรต: สนฺตสฺติษฺฐต, มนุชสุต: กสฺมินฺ ทิเน กสฺมินฺ ทณฺเฑ วาคมิษฺยติ, ตทฺ ยุษฺมาภิ รฺน ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","อปรํ ส เอตาทฺฤศ: กสฺยจิตฺ ปุํสสฺตุลฺย:, โย ทูรเทศํ ปฺรติ ยาตฺรากาเล นิชทาสานฺ อาหูย เตษำ สฺวสฺวสามรฺถฺยานุรูปมฺ ");
INSERT INTO santha_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","เอกสฺมินฺ มุทฺราณำ ปญฺจ โปฏลิกา: อนฺยสฺมึศฺจ เทฺว โปฏลิเก อปรสฺมึศฺจ โปฏลิไกกามฺ อิตฺถํ ปฺรติชนํ สมรฺปฺย สฺวยํ ปฺรวาสํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","อนนฺตรํ โย ทาส: ปญฺจ โปฏลิกา: ลพฺธวานฺ, ส คตฺวา วาณิชฺยํ วิธาย ตา ทฺวิคุณีจการฯ ");
INSERT INTO santha_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ยศฺจ ทาโส เทฺว โปฏลิเก อลภต, โสปิ ตา มุทฺรา ทฺวิคุณีจการฯ ");
INSERT INTO santha_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","กินฺตุ โย ทาส เอกำ โปฏลิกำ ลพฺธวานฺ, ส คตฺวา ภูมึ ขนิตฺวา ตนฺมเธฺย นิชปฺรโภสฺตา มุทฺรา โคปยาญฺจการฯ ");
INSERT INTO santha_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ตทนนฺตรํ พหุติเถ กาเล คเต เตษำ ทาสานำ ปฺรภุราคตฺย ไตรฺทาไส: สมํ คณยาญฺจการฯ ");
INSERT INTO santha_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ตทานีํ ย: ปญฺจ โปฏลิกา: ปฺราปฺตวานฺ ส ตา ทฺวิคุณีกฺฤตมุทฺรา อานีย ชคาท; เห ปฺรโภ, ภวตา มยิ ปญฺจ โปฏลิกา: สมรฺปิตา:, ปศฺยตุ, ตา มยา ทฺวิคุณีกฺฤตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ตทานีํ ตสฺย ปฺรภุสฺตมุวาจ, เห อุตฺตม วิศฺวาสฺย ทาส, ตฺวํ ธโนฺยสิ, โสฺตเกน วิศฺวาโสฺย ชาต:, ตสฺมาตฺ ตฺวำ พหุวิตฺตาธิปํ กโรมิ, ตฺวํ สฺวปฺรโภ: สุขสฺย ภาคี ภวฯ ");
INSERT INTO santha_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ตโต เยน เทฺว โปฏลิเก ลพฺเธ โสปฺยาคตฺย ชคาท, เห ปฺรโภ, ภวตา มยิ เทฺว โปฏลิเก สมรฺปิเต, ปศฺยตุ เต มยา ทฺวิคุณีกฺฤเตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","เตน ตสฺย ปฺรภุสฺตมโวจตฺ, เห อุตฺตม วิศฺวาสฺย ทาส, ตฺวํ ธโนฺยสิ, โสฺตเกน วิศฺวาโสฺย ชาต:, ตสฺมาตฺ ตฺวำ พหุทฺรวิณาธิปํ กโรมิ, ตฺวํ นิชปฺรโภ: สุขสฺย ภาคี ภวฯ ");
INSERT INTO santha_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","อนนฺตรํ ย เอกำ โปฏลิกำ ลพฺธวานฺ, ส เอตฺย กถิตวานฺ, เห ปฺรโภ, ตฺวำ กฐินนรํ ชฺญาตวานฺ, ตฺวยา ยตฺร โนปฺตํ, ตไตฺรว กฺฤตฺยเต, ยตฺร จ น กีรฺณํ, ตไตฺรว สํคฺฤหฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","อโตหํ สศงฺก: สนฺ คตฺวา ตว มุทฺรา ภูมเธฺย สํโคปฺย สฺถาปิตวานฺ, ปศฺย, ตว ยตฺ ตเทว คฺฤหาณฯ ");
INSERT INTO santha_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ตทา ตสฺย ปฺรภุ: ปฺรตฺยวทตฺ เร ทุษฺฏาลส ทาส, ยตฺราหํ น วปามิ, ตตฺร ฉินทฺมิ, ยตฺร จ น กิรามิ, ตเตฺรว สํคฺฤหฺลามีติ เจทชานาสฺตรฺหิ ");
INSERT INTO santha_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","วณิกฺษุ มม วิตฺตารฺปณํ ตโวจิตมาสีตฺ, เยนาหมาคตฺย วฺฤทฺวฺยา สากํ มูลมุทฺรา: ปฺราปฺสฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","อโตสฺมาตฺ ตำ โปฏลิกามฺ อาทาย ยสฺย ทศ โปฏลิกา: สนฺติ ตสฺมินฺนรฺปยตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","เยน วรฺทฺวฺยเต ตสฺมินฺไนวารฺปิษฺยเต, ตไสฺยว จ พาหุลฺยํ ภวิษฺยติ, กินฺตุ เยน น วรฺทฺวฺยเต, ตสฺยานฺติเก ยตฺ กิญฺจน ติษฺฐติ, ตทปิ ปุนรฺเนษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","อปรํ ยูยํ ตมกรฺมฺมณฺยํ ทาสํ นีตฺวา ยตฺร สฺถาเน กฺรนฺทนํ ทนฺตฆรฺษณญฺจ วิเทฺยเต, ตสฺมินฺ พหิรฺภูตตมสิ นิกฺษิปตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ยทา มนุชสุต: ปวิตฺรทูตานฺ สงฺคิน: กฺฤตฺวา นิชปฺรภาเวนาคตฺย นิชเตโชมเย สึหาสเน นิเวกฺษฺยติ, ");
INSERT INTO santha_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ตทา ตตฺสมฺมุเข สรฺวฺวชาตียา ชนา สํเมลิษฺยนฺติฯ ตโต เมษปาลโก ยถา ฉาเคโภฺย'วีนฺ ปฺฤถกฺ กโรติ ตถา โสเปฺยกสฺมาทนฺยมฺ อิตฺถํ ตานฺ ปฺฤถก กฺฤตฺวาวีนฺ ");
INSERT INTO santha_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ทกฺษิเณ ฉาคำศฺจ วาเม สฺถาปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ตต: ปรํ ราชา ทกฺษิณสฺถิตานฺ มานวานฺ วทิษฺยติ, อาคจฺฉต มตฺตาตสฺยานุคฺรหภาชนานิ, ยุษฺมตฺกฺฤต อา ชคทารมฺภตฺ ยทฺ ราชฺยมฺ อาสาทิตํ ตทธิกุรุตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ยโต พุภุกฺษิตาย มหฺยํ โภชฺยมฺ อทตฺต, ปิปาสิตาย เปยมทตฺต, วิเทศินํ มำ สฺวสฺถานมนยต, ");
INSERT INTO santha_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","วสฺตฺรหีนํ มำ วสนํ ปรฺยฺยธาปยต, ปีฑีตํ มำ ทฺรษฺฏุมาคจฺฉต, การาสฺถญฺจ มำ วีกฺษิตุม อาคจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ตทา ธารฺมฺมิกา: ปฺรติวทิษฺยนฺติ, เห ปฺรโภ, กทา ตฺวำ กฺษุธิตํ วีกฺษฺย วยมโภชยาม? วา ปิปาสิตํ วีกฺษฺย อปายยาม? ");
INSERT INTO santha_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","กทา วา ตฺวำ วิเทศินํ วิโลกฺย สฺวสฺถานมนยาม? กทา วา ตฺวำ นคฺนํ วีกฺษฺย วสนํ ปรฺยฺยธาปยาม? ");
INSERT INTO santha_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","กทา วา ตฺวำ ปีฑิตํ การาสฺถญฺจ วีกฺษฺย ตฺวทนฺติกมคจฺฉาม? ");
INSERT INTO santha_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ตทานีํ ราชา ตานฺ ปฺรติวทิษฺยติ, ยุษฺมานหํ สตฺยํ วทามิ, มไมเตษำ ภฺราตฺฤณำ มเธฺย กญฺจไนกํ กฺษุทฺรตมํ ปฺรติ ยทฺ อกุรุต, ตนฺมำ ปฺรตฺยกุรุตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ปศฺจาตฺ ส วามสฺถิตานฺ ชนานฺ วทิษฺยติ, เร ศาปคฺรสฺตา: สรฺเวฺว, ไศตาเน ตสฺย ทูเตภฺยศฺจ โย'นนฺตวหฺนิราสาทิต อาเสฺต, ยูยํ มทนฺติกาตฺ ตมคฺนึ คจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ยโต กฺษุธิตาย มหฺยมาหารํ นาทตฺต, ปิปาสิตาย มหฺยํ เปยํ นาทตฺต, ");
INSERT INTO santha_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","วิเทศินํ มำ สฺวสฺถานํ นานยต, วสนหีนํ มำ วสนํ น ปรฺยฺยธาปยต, ปีฑิตํ การาสฺถญฺจ มำ วีกฺษิตุํ นาคจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ตทา เต ปฺรติวทิษฺยนฺติ, เห ปฺรโภ, กทา ตฺวำ กฺษุธิตํ วา ปิปาสิตํ วา วิเทศินํ วา นคฺนํ วา ปีฑิตํ วา การาสฺถํ วีกฺษฺย ตฺวำ นาเสวามหิ? ");
INSERT INTO santha_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ตทา ส ตานฺ วทิษฺยติ, ตถฺยมหํ ยุษฺมานฺ พฺรวีมิ, ยุษฺมาภิเรษำ กญฺจน โกฺษทิษฺฐํ ปฺรติ ยนฺนาการิ, ตนฺมำ ปฺรเตฺยว นาการิฯ ");
INSERT INTO santha_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ปศฺจาทมฺยนนฺตศาสฺตึ กินฺตุ ธารฺมฺมิกา อนนฺตายุษํ โภกฺตุํ ยาสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ยีศุเรตานฺ ปฺรสฺตาวานฺ สมาปฺย ศิษฺยานูเจ, ");
INSERT INTO santha_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ยุษฺมาภิ รฺชฺญาตํ ทินทฺวยาตฺ ปรํ นิสฺตารมห อุปสฺถาสฺยติ, ตตฺร มนุชสุต: กฺรุเศน หนฺตุํ ปรกเรษุ สมรฺปิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ตต: ปรํ ปฺรธานยาชกาธฺยาปกปฺราญฺจ: กิยผานามฺโน มหายาชกสฺยาฏฺฏาลิกายำ มิลิตฺวา ");
INSERT INTO santha_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","เกโนปาเยน ยีศุํ ธฺฤตฺวา หนฺตุํ ศกฺนุยุริติ มนฺตฺรยาญฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","กินฺตุ ไตรุกฺตํ มหกาเล น ธรฺตฺตวฺย:, ธฺฤเต ปฺรชานำ กลเหน ภวิตุํ ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ตโต ไพถนิยาปุเร ศิโมนาขฺยสฺย กุษฺฐิโน เวศฺมนิ ยีเศา ติษฺฐติ ");
INSERT INTO santha_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","กาจน โยษา เศฺวโตปลภาชเนน มหารฺฆฺยํ สุคนฺธิ ไตลมานีย โภชนาโยปวิศตสฺตสฺย ศิโรภฺยเษจตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","กินฺตุ ตทาโลกฺย ตจฺฉิไษฺย: กุปิไตรุกฺตํ, กุต อิตฺถมปวฺยยเต? ");
INSERT INTO santha_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","เจทิทํ วฺยเกฺรษฺยต, ตรฺหิ ภูริมูลฺยํ ปฺราปฺย ทริเทฺรโภฺย วฺยตาริษฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ยีศุนา ตทวคตฺย เต สมุทิตา:, โยษาเมนำ กุโต ทุ:ขินีํ กุรุถ, สา มำ ปฺรติ สาธุ กรฺมฺมาการฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ยุษฺมากมํ สมีเป ทริทฺรา: สตตเมวาสเต, กินฺตุ ยุษฺมากมนฺติเกหํ นาเส สตตํฯ ");
INSERT INTO santha_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","สา มม กาโยปริ สุคนฺธิไตลํ สิกฺตฺวา มม ศฺมศานทานกรฺมฺมาการฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","อโตหํ ยุษฺมานฺ ตถฺยํ วทามิ สรฺวฺวสฺมินฺ ชคติ ยตฺร ยไตฺรษ สุสมาจาร: ปฺรจาริษฺยเต, ตตฺร ตไตฺรตสฺยา นารฺยฺยา: สฺมรณารฺถมฺ กรฺมฺเมทํ ปฺรจาริษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ตโต ทฺวาทศศิษฺยาณามฺ อีษฺกริโยตียยิหูทานามก เอก: ศิษฺย: ปฺรธานยาชกานามนฺติกํ คตฺวา กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ยทิ ยุษฺมากํ กเรษุ ยีศุํ สมรฺปยามิ, ตรฺหิ กึ ทาสฺยถ? ตทานีํ เต ตไสฺม ตฺรึศนฺมุทฺรา ทาตุํ สฺถิรีกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ส ตทารภฺย ตํ ปรกเรษุ สมรฺปยิตุํ สุโยคํ เจษฺฏิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","อนนฺตรํ กิณฺวศูนฺยปูปปรฺวฺวณ: ปฺรถเมหฺนิ ศิษฺยา ยีศุมฺ อุปคตฺย ปปฺรจฺฉุ: ภวตฺกฺฤเต กุตฺร วยํ นิสฺตารมหโภชฺยมฺ อาโยชยิษฺยาม:? ภวต: เกจฺฉา? ");
INSERT INTO santha_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ตทา ส คทิตวานฺ, มเธฺยนครมมุกปุํส: สมีปํ วฺรชิตฺวา วทต, คุรุ รฺคทิตวานฺ, มตฺกาล: สวิธ:, สห ศิไษฺยสฺตฺวทาลเย นิสฺตารมหโภชฺยํ โภกฺเษฺยฯ ");
INSERT INTO santha_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ตทา ศิษฺยา ยีโศสฺตาทฺฤศนิเทศานุรูปกรฺมฺม วิธาย ตตฺร นิสฺตารมหโภชฺยมาสาทยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ตต: สนฺธฺยายำ สตฺยำ ทฺวาทศภิ: ศิไษฺย: สากํ ส นฺยวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","อปรํ ภุญฺชาน อุกฺตวานฺ ยุษฺมานฺ ตถฺยํ วทามิ, ยุษฺมากเมโก มำ ปรกเรษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ตทา เต'ตีว ทุ:ขิตา เอไกกโศ วกฺตุมาเรภิเร, เห ปฺรโภ, ส กิมหํ? ");
INSERT INTO santha_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ตต: ส ชคาท, มยา สากํ โย ชโน โภชนปาเตฺร กรํ สํกฺษิปติ, ส เอว มำ ปรกเรษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","มนุชสุตมธิ ยาทฺฤศํ ลิขิตมาเสฺต, ตทนุรูปา ตทฺคติ รฺภวิษฺยติ; กินฺตุ เยน ปุํสา ส ปรกเรษุ สมรฺปยิษฺยเต, หา หา เจตฺ ส นาชนิษฺยต, ตทา ตสฺย เกฺษมมภวิษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ตทา ยิหูทานามา โย ชนสฺตํ ปรกเรษุ สมรฺปยิษฺยติ, ส อุกฺตวานฺ, เห คุโร, ส กิมหํ? ตต: ส ปฺรตฺยุกฺตวานฺ, ตฺวยา สตฺยํ คทิตมฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","อนนฺตรํ เตษามศนกาเล ยีศุ: ปูปมาทาเยศฺวรียคุณานนูทฺย ภํกฺตฺวา ศิเษฺยภฺย: ปฺรทาย ชคาท, มทฺวปุ:สฺวรูปมิมํ คฺฤหีตฺวา ขาทตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ปศฺจาตฺ ส กํสํ คฺฤหฺลนฺ อีศฺวรียคุณานนูทฺย เตภฺย: ปฺรทาย กถิตวานฺ, สรฺไวฺว รฺยุษฺมาภิรเนน ปาตวฺยํ, ");
INSERT INTO santha_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ยสฺมาทเนเกษำ ปาปมรฺษณาย ปาติตํ ยนฺมนฺนูตฺนนิยมรูปโศณิตํ ตเทตตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","อปรมหํ นูตฺนโคสฺตนีรสํ น ปาสฺยามิ, ตาวตฺ โคสฺตนีผลรสํ ปุน: กทาปิ น ปาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ปศฺจาตฺ เต คีตเมกํ สํคีย ไชตุนาขฺยคิรึ คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ตทานีํ ยีศุสฺตานโวจตฺ, อสฺยำ รชนฺยามหํ ยุษฺมากํ สรฺเวฺวษำ วิฆฺนรูโป ภวิษฺยามิ, ยโต ลิขิตมาเสฺต, \"เมษาณำ รกฺษโก ยสฺตํ ปฺรหริษฺยามฺยหํ ตต:ฯ เมษาณำ นิวโห นูนํ ปฺรวิกีรฺโณ ภวิษฺยติ\"๚ ");
INSERT INTO santha_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","กินฺตุ ศฺมศานาตฺ สมุตฺถาย ยุษฺมากมเคฺร'หํ คาลีลํ คมิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ปิตรสฺตํ โปฺรวาจ, ภวำศฺเจตฺ สรฺเวฺวษำ วิฆฺนรูโป ภวติ, ตถาปิ มม น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ตโต ยีศุนา ส อุกฺต:, ตุภฺยมหํ ตถฺยํ กถยามิ, ยามินฺยามสฺยำ จรณายุธสฺย รวาตฺ ปูรฺวฺวํ ตฺวํ มำ ตฺริ รฺนางฺคีกริษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ตต: ปิตร อุทิตวานฺ, ยทฺยปิ ตฺวยา สมํ มรฺตฺตวฺยํ, ตถาปิ กทาปิ ตฺวำ น นางฺคีกริษฺยามิ; ตไถว สรฺเวฺว ศิษฺยาศฺโจจุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","อนนฺตรํ ยีศุ: ศิไษฺย: สากํ เคตฺศิมานีนามกํ สฺถานํ ปฺรสฺถาย เตภฺย: กถิตวานฺ, อท: สฺถานํ คตฺวา ยาวทหํ ปฺรารฺถยิเษฺย ตาวทฺ ยูยมโตฺรปวิศตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ปศฺจาตฺ ส ปิตรํ สิวทิยสุเตา จ สงฺคิน: กฺฤตฺวา คตวานฺ, โศกากุโล'ตีว วฺยถิตศฺจ พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ตานวาทีจฺจ มฺฤติยาตเนว มตฺปฺราณานำ ยาตนา ชายเต, ยูยมตฺร มยา สารฺทฺธํ ชาคฺฤตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ตต: ส กิญฺจิทฺทูรํ คตฺวาโธมุข: ปตนฺ ปฺรารฺถยาญฺจเกฺร, เห มตฺปิตรฺยทิ ภวิตุํ ศกฺโนติ, ตรฺหิ กํโส'ยํ มตฺโต ทูรํ ยาตุ; กินฺตุ มทิจฺฉาวตฺ น ภวตุ, ตฺวทิจฺฉาวทฺ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ตต: ส ศิษฺยานุเปตฺย ตานฺ นิทฺรโต นิรีกฺษฺย ปิตราย กถยามาส, ยูยํ มยา สากํ ทณฺฑเมกมปิ ชาคริตุํ นาศนฺกุต? ");
INSERT INTO santha_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ปรีกฺษายำ น ปติตุํ ชาคฺฤต ปฺรารฺถยธฺวญฺจ; อาตฺมา สมุทฺยโตสฺติ, กินฺตุ วปุ รฺทุรฺพฺพลํฯ ");
INSERT INTO santha_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ส ทฺวิตียวารํ ปฺรารฺถยาญฺจเกฺร, เห มตฺตาต, น ปีเต ยทิ กํสมิทํ มตฺโต ทูรํ ยาตุํ น ศกฺโนติ, ตรฺหิ ตฺวทิจฺฉาวทฺ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ส ปุนเรตฺย ตานฺ นิทฺรโต ททรฺศ, ยตเสฺตษำ เนตฺราณิ นิทฺรยา ปูรฺณานฺยาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ปศฺจาตฺ ส ตานฺ วิหาย วฺรชิตฺวา ตฺฤตียวารํ ปูรฺวฺววตฺ กถยนฺ ปฺรารฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ตต: ศิษฺยานุปาคตฺย คทิตวานฺ, สามฺปฺรตํ ศยานา: กึ วิศฺรามฺยถ? ปศฺยต, สมย อุปาสฺถาตฺ, มนุชสุต: ปาปินำ กเรษุ สมรฺปฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","อุตฺติษฺฐต, วยํ ยาม:, โย มำ ปรกเรษุ มสรฺปยิษฺยติ, ปศฺยต, ส สมีปมายาติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","เอตตฺกถากถนกาเล ทฺวาทศศิษฺยาณาเมโก ยิหูทานามโก มุขฺยยาชกโลกปฺราจีไน: ปฺรหิตานฺ อสิธาริยษฺฏิธาริโณ มนุชานฺ คฺฤหีตฺวา ตตฺสมีปมุปตเสฺถาฯ ");
INSERT INTO santha_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","อเสา ปรกเรษฺวรฺปยิตา ปูรฺวฺวํ ตานฺ อิตฺถํ สงฺเกตยามาส, ยมหํ จุมฺพิเษฺย, โส'เสา มนุช:,เสอว ยุษฺมาภิ รฺธารฺยฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ตทา ส สปทิ ยีศุมุปาคตฺย เห คุโร, ปฺรณมามีตฺยุกฺตฺวา ตํ จุจุมฺเพฯ ");
INSERT INTO santha_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ตทา ยีศุสฺตมุวาจ, เห มิตฺรํ กิมรฺถมาคโตสิ? ตทา ไตราคตฺย ยีศุรากฺรมฺย ทเฆฺรฯ ");
INSERT INTO santha_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ตโต ยีโศ: สงฺคินาเมก: กรํ ปฺรสารฺยฺย โกษาทสึ พหิษฺกฺฤตฺย มหายาชกสฺย ทาสเมกมาหตฺย ตสฺย กรฺณํ จิจฺเฉทฯ ");
INSERT INTO santha_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ตโต ยีศุสฺตํ ชคาท, ขฑฺคํ สฺวสฺถาเนे นิเธหิ ยโต เย เย ชนา อสึ ธารยนฺติ, เตอวาสินา วินศฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","อปรํ ปิตา ยถา มทนฺติกํ สฺวรฺคียทูตานำ ทฺวาทศวาหินีโต'ธิกํ ปฺรหิณุยาตฺ มยา ตมุทฺทิเศฺยทานีเมว ตถา ปฺรารฺถยิตุํ น ศกฺยเต, ตฺวยา กิมิตฺถํ ชฺญายเต? ");
INSERT INTO santha_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ตถา สตีตฺถํ ฆฏิษฺยเต ธรฺมฺมปุสฺตกสฺย ยทิทํ วากฺยํ ตตฺ กถํ สิเธฺยตฺ? ");
INSERT INTO santha_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ตทานีํ ยีศุ รฺชนนิวหํ ชคาท, ยูยํ ขฑฺคยษฺฏีนฺ อาทาย มำ กึ เจารํ ธรฺตฺตุมายาตา:? อหํ ปฺรตฺยหํ ยุษฺมาภิ: สากมุปวิศฺย สมุปาทิศํ, ตทา มำ นาธรต; ");
INSERT INTO santha_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","กินฺตุ ภวิษฺยทฺวาทินำ วากฺยานำ สํสิทฺธเย สรฺวฺวเมตทภูตฺฯ ตทา สรฺเวฺว ศิษฺยาสฺตํ วิหาย ปลายนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","อนนฺตรํ เต มนุชา ยีศุํ ธฺฤตฺวา ยตฺราธฺยาปกปฺราญฺจ: ปริษทํ กุรฺวฺวนฺต อุปาวิศนฺ ตตฺร กิยผานาाมกมหายาชกสฺยานฺติกํ นินฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","กินฺตุ เศเษ กึ ภวิษฺยตีติ เวตฺตุํ ปิตโร ทูเร ตตฺปศฺจาทฺ วฺรชิตฺวา มหายาชกสฺยาฏฺฏาลิกำ ปฺรวิศฺย ทาไส: สหิต อุปาวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ตทานีํ ปฺรธานยาชกปฺราจีนมนฺตฺริณ: สรฺเวฺว ยีศุํ หนฺตุํ มฺฤษาสากฺษฺยมฺ อลิปฺสนฺต, ");
INSERT INTO santha_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","กินฺตุ น เลภิเรฯ อเนเกษุ มฺฤษาสากฺษิษฺวาคเตษฺวปิ ตนฺน ปฺราปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","เศเษ เทฺวา มฺฤษาสากฺษิณาวาคตฺย ชคทตุ:, ปุมานยมกถยตฺ, อหมีศฺวรมนฺทิรํ ภํกฺตฺวา ทินตฺรยมเธฺย ตนฺนิรฺมฺมาตุํ ศกฺโนมิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ตทา มหายาชก อุตฺถาย ยีศุมฺ อวาทีตฺฯ ตฺวํ กิมปิ น ปฺรติวทสิ? ตฺวามธิ กิเมเต สากฺษฺยํ วทนฺติ? ");
INSERT INTO santha_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","กินฺตุ ยีศุ เรฺมานีภูย ตเสฺยาฯ ตโต มหายาชก อุกฺตวานฺ, ตฺวามฺ อมเรศฺวรนามฺนา ศปยามิ, ตฺวมีศฺวรสฺย ปุโตฺร'ภิษิกฺโต ภวสิ นเวติ วทฯ ");
INSERT INTO santha_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ยีศุ: ปฺรตฺยวทตฺ, ตฺวํ สตฺยมุกฺตวานฺ; อหํ ยุษฺมานฺ ตถฺยํ วทามิ, อิต:ปรํ มนุชสุตํ สรฺวฺวศกฺติมโต ทกฺษิณปารฺเศฺว สฺถาตุํ คคณสฺถํ ชลธรานารุหฺยายานฺตํ วีกฺษเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ตทา มหายาชโก นิชวสนํ ฉิตฺตฺวา ชคาท, เอษ อีศฺวรํ นินฺทิตวานฺ, อสฺมากมปรสากฺเษฺยณ กึ ปฺรโยชนํ? ปศฺยต, ยูยเมวาสฺยาสฺยาทฺ อีศฺวรนินฺทำ ศฺรุตวนฺต:, ");
INSERT INTO santha_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ยุษฺมาภิ: กึ วิวิจฺยเต? เต ปฺรตฺยูจุ:, วธาโรฺห'ยํฯ ");
INSERT INTO santha_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ตโต โลไกสฺตทาเสฺย นิษฺฐีวิตํ เกจิตฺ ปฺรตลมาหตฺย เกจิจฺจ จเปฏมาหตฺย พภาษิเร, ");
INSERT INTO santha_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","เห ขฺรีษฺฏ ตฺวำ กศฺจเปฏมาหตวานฺ? อิติ คณยิตฺวา วทาสฺมานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ปิตโร พหิรงฺคน อุปวิศติ, ตทานีเมกา ทาสี ตมุปาคตฺย พภาเษ, ตฺวํ คาลีลียยีโศ: สหจเรอก:ฯ ");
INSERT INTO santha_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","กินฺตุ ส สรฺเวฺวษำ สมกฺษมฺ อนงฺคีกฺฤตฺยาวาทีตฺ, ตฺวยา ยทุจฺยเต, ตทรฺถมหํ น เวทฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ตทา ตสฺมินฺ พหิรฺทฺวารํ คเต 'นฺยา ทาสี ตํ นิรีกฺษฺย ตตฺรตฺยชนานวทตฺ, อยมปิ นาสรตียยีศุนา สารฺทฺธมฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ตต: ส ศปเถน ปุนรนงฺคีกฺฤตฺย กถิตวานฺ, ตํ นรํ น ปริจิโนมิฯ ");
INSERT INTO santha_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","กฺษณาตฺ ปรํ ติษฺฐนฺโต ชนา เอตฺย ปิตรมฺ อวทนฺ, ตฺวมวศฺยํ เตษาเมก อิติ ตฺวทุจฺจารณเมว โทฺยตยติฯ ");
INSERT INTO santha_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","กินฺตุ โส'ภิศปฺย กถิตวานฺ, ตํ ชนํ นาหํ ปริจิโนมิ, ตทา สปทิ กุกฺกุโฏ รุราวฯ ");
INSERT INTO santha_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","กุกฺกุฏรวาตฺ ปฺรากฺ ตฺวํ มำ ตฺริรปาโหฺนษฺยเส, ไยษา วาคฺ ยีศุนาวาทิ ตำ ปิตร: สํสฺมฺฤตฺย พหิริตฺวา เขทาทฺ ภฺฤศํ จกฺรนฺทฯ ");
INSERT INTO santha_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ปฺรภาเต ชาเต ปฺรธานยาชกโลกปฺราจีนา ยีศุํ หนฺตุํ ตตฺปฺรติกูลํ มนฺตฺรยิตฺวา ");
INSERT INTO santha_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ตํ พทฺวฺวา นีตฺวา ปนฺตียปีลาตาขฺยาธิเป สมรฺปยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ตโต ยีโศ: ปรกเรวฺวรฺปยิตา ยิหูทาสฺตตฺปฺราณาทณฺฑาชฺญำ วิทิตฺวา สนฺตปฺตมนา: ปฺรธานยาชกโลกปฺราจีนานำ สมกฺษํ ตาสฺตฺรีํศนฺมุทฺรา: ปฺรติทายาวาทีตฺ, ");
INSERT INTO santha_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","เอตนฺนิราโคนรปฺราณปรกรารฺปณาตฺ กลุษํ กฺฤตวานหํฯ ตทา ต อุทิตวนฺต:, เตนาสฺมากํ กึ? ตฺวยา ตทฺ พุธฺยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ตโต ยิหูทา มนฺทิรมเธฺย ตา มุทฺรา นิกฺษิปฺย ปฺรสฺถิตวานฺ อิตฺวา จ สฺวยมาตฺมานมุทฺพพนฺธฯ ");
INSERT INTO santha_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ปศฺจาตฺ ปฺรธานยาชกาสฺตา มุทฺรา อาทาย กถิตวนฺต:, เอตา มุทฺรา: โศณิตมูลฺยํ ตสฺมาทฺ ภาณฺฑาคาเร น นิธาตวฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","อนนฺตรํ เต มนฺตฺรยิตฺวา วิเทศินำ ศฺมศานสฺถานาย ตาภิ: กุลาลสฺย เกฺษตฺรมกฺรีณนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","อโต'ทฺยาปิ ตตฺสฺถานํ รกฺตกฺเษตฺรํ วทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","อิตฺถํ สติ อิสฺราเยลียสนฺตาไน รฺยสฺย มูลฺยํ นิรุปิตํ, ตสฺย ตฺรึศนฺมุทฺรามานํ มูลฺยํ ");
INSERT INTO santha_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","มำ ปฺรติ ปรเมศฺวรสฺยาเทศาตฺ เตภฺย อาทียต, เตน จ กุลาลสฺย เกฺษตฺรํ กฺรีตมิติ ยทฺวจนํ ยิริมิยภวิษฺยทฺวาทินา โปฺรกฺตํ ตตฺ ตทาสิธฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","อนนฺตรํ ยีเศา ตทธิปเต: สมฺมุข อุปติษฺฐติ ส ตํ ปปฺรจฺฉ, ตฺวํ กึ ยิหูทียานำ ราชา? ตทา ยีศุสฺตมวทตฺ, ตฺวํ สตฺยมุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","กินฺตุ ปฺรธานยาชกปฺราจีไนรภิยุกฺเตน เตน กิมปิ น ปฺรตฺยวาทิฯ ");
INSERT INTO santha_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ตต: ปีลาเตน ส อุทิต:, อิเม ตฺวตฺปฺรติกูลต: กติ กติ สากฺษฺยํ ททติ, ตตฺ ตฺวํ น ศฺฤโณษิ? ");
INSERT INTO santha_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ตถาปิ ส เตษาเมกสฺยาปิ วจส อุตฺตรํ โนทิตวานฺ; เตน โส'ธิปติ รฺมหาจิตฺรํ วิทามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","อนฺยจฺจ ตนฺมหกาเล'ธิปเตเรตาทฺฤศี ราติราสีตฺ, ปฺรชา ยํ กญฺจน พนฺธินํ ยาจนฺเต, ตเมว ส โมจยตีติฯ ");
INSERT INTO santha_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ตทานีํ พรพฺพานามา กศฺจิตฺ ขฺยาตพนฺธฺยาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ตต: ปีลาตสฺตตฺร มิลิตานฺ โลกานฺ อปฺฤจฺฉตฺ, เอษ พรพฺพา พนฺธี ขฺรีษฺฏวิขฺยาโต ยีศุศฺไจตโย: กํ โมจยิษฺยามิ? ยุษฺมากํ กิมีปฺสิตํ? ");
INSERT INTO santha_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ไตรีรฺษฺยยา ส สมรฺปิต อิติ ส ชฺญาตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","อปรํ วิจาราสโนปเวศนกาเล ปีลาตสฺย ปตฺนี ภฺฤตฺยํ ปฺรหิตฺย ตไสฺม กถยามาส, ตํ ธารฺมฺมิกมนุชํ ปฺรติ ตฺวยา กิมปิ น กรฺตฺตวฺยํ; ยสฺมาตฺ ตตฺกฺฤเต'ทฺยาหํ สฺวปฺเน ปฺรภูตกษฺฏมลเภฯ ");
INSERT INTO santha_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","อนนฺตรํ ปฺรธานยาชกปฺราจีนา พรพฺพำ ยาจิตฺวาทาตุํ ยีศุญฺจ หนฺตุํ สกลโลกานฺ ปฺราวรฺตฺตยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ตโต'ธิปติสฺตานฺ ปฺฤษฺฏวานฺ, เอตโย: กมหํ โมจยิษฺยามิ? ยุษฺมากํ เกจฺฉา? เต โปฺรจุ รฺพรพฺพำฯ ");
INSERT INTO santha_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ตทา ปีลาต: ปปฺรจฺฉ, ตรฺหิ ยํ ขฺรีษฺฏํ วทนฺติ, ตํ ยีศุํ กึ กริษฺยามิ? สรฺเวฺว กถยามาสุ:, ส กฺรุเศน วิธฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ตโต'ธิปติรวาทีตฺ, กุต:? กึ เตนาปราทฺธํ? กินฺตุ เต ปุนรุไจ รฺชคทุ:, ส กฺรุเศน วิธฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ตทา นิชวากฺยมคฺราหฺยมภูตฺ, กลหศฺจาปฺยภูตฺ, ปีลาต อิติ วิโลกฺย โลกานำ สมกฺษํ โตยมาทาย กเรา ปฺรกฺษาลฺยาโวจตฺ, เอตสฺย ธารฺมฺมิกมนุษฺยสฺย โศณิตปาเต นิรฺโทโษ'หํ, ยุษฺมาภิเรว ตทฺ พุธฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ตทา สรฺวฺวา: ปฺรชา: ปฺรตฺยโวจนฺ, ตสฺย โศณิตปาตาปราโธ'สฺมากมฺ อสฺมตฺสนฺตานานาญฺโจปริ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ตต: ส เตษำ สมีเป พรพฺพำ โมจยามาส ยีศุนฺตุ กษาภิราหตฺย กฺรุเศน เวธิตุํ สมรฺปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","อนนฺตรมฺ อธิปเต: เสนา อธิปเต รฺคฺฤหํ ยีศุมานีย ตสฺย สมีเป เสนาสมูหํ สํชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ตตเสฺต ตสฺย วสนํ โมจยิตฺวา กฺฤษฺณโลหิตวรฺณวสนํ ปริธาปยามาสุ: ");
INSERT INTO santha_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","กณฺฏกานำ มุกุฏํ นิรฺมฺมาย ตจฺฉิรสิ ททุ:, ตสฺย ทกฺษิณกเร เวตฺรเมกํ ทตฺตฺวา ตสฺย สมฺมุเข ชานูนิ ปาตยิตฺวา, เห ยิหูทียานำ ราชนฺ, ตุภฺยํ นม อิตฺยุกฺตฺวา ตํ ติรศฺจกฺรุ:, ");
INSERT INTO santha_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ตตสฺตสฺย คาเตฺร นิษฺฐีวํ ทตฺวา เตน เวเตฺรณ ศิร อาชฆฺนุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","อิตฺถํ ตํ ติรสฺกฺฤตฺย ตทฺ วสนํ โมจยิตฺวา ปุนรฺนิชวสนํ ปริธาปยาญฺจกฺรุ:, ตํ กฺรุเศน เวธิตุํ นีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ปศฺจาตฺเต พหิรฺภูย กุรีณียํ ศิโมนฺนามกเมกํ วิโลกฺย กฺรุศํ โวฒุํ ตมาททิเรฯ ");
INSERT INTO santha_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","อนนฺตรํ คุลฺคลฺตามฺ อรฺถาตฺ ศิรสฺกปาลนามกสฺถานมุ ปสฺถาย เต ยีศเว ปิตฺตมิศฺริตามฺลรสํ ปาตุํ ททุ:, ");
INSERT INTO santha_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","กินฺตุ ส ตมาสฺวาทฺย น ปเปาฯ ");
INSERT INTO santha_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ตทานีํ เต ตํ กฺรุเศน สํวิธฺย ตสฺย วสนานิ คุฏิกาปาเตน วิภชฺย ชคฺฤหุ:, ตสฺมาตฺ, วิภชนฺเต'ธรียํ เม เต มนุษฺยา: ปรสฺปรํฯ มทุตฺตรียวสฺตฺรารฺถํ คุฏิกำ ปาตยนฺติ จ๚ ยเทตทฺวจนํ ภวิษฺยทฺวาทิภิรุกฺตมาสีตฺ, ตทา ตทฺ อสิธฺยตฺ, ");
INSERT INTO santha_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ปศฺจาตฺ เต ตโตฺรปวิศฺย ตทฺรกฺษณกรฺวฺวณิ นิยุกฺตาสฺตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","อปรมฺ เอษ ยิหูทียานำ ราชา ยีศุริตฺยปวาทลิปิปตฺรํ ตจฺฉิรส อูรฺทฺเวฺว โยชยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ตตสฺตสฺย วาเม ทกฺษิเณ จ เทฺวา ไจเรา เตน สากํ กฺรุเศน วิวิธุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ตทา ปานฺถา นิชศิโร ลาฑยิตฺวา ตํ นินฺทนฺโต ชคทุ:, ");
INSERT INTO santha_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","เห อีศฺวรมนฺทิรภญฺชก ทินตฺรเย ตนฺนิรฺมฺมาต: สฺวํ รกฺษ, เจตฺตฺวมีศฺวรสุตสฺตรฺหิ กฺรุศาทวโรหฯ ");
INSERT INTO santha_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ปฺรธานยาชกาธฺยาปกปฺราจีนาศฺจ ตถา ติรสฺกฺฤตฺย ชคทุ:, ");
INSERT INTO santha_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","โส'นฺยชนานาวตฺ, กินฺตุ สฺวมวิตุํ น ศกฺโนติฯ ยทีสฺราเยโล ราชา ภเวตฺ, ตรฺหีทานีเมว กฺรุศาทวโรหตุ, เตน ตํ วยํ ปฺรเตฺยษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ส อีศฺวเร ปฺรตฺยาศามกโรตฺ, ยทีศฺวรสฺตสฺมินฺ สนฺตุษฺฏสฺตรฺหีทานีเมว ตมเวตฺ, ยต: ส อุกฺตวานฺ อหมีศฺวรสุต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","เยา เสฺตเนา สากํ เตน กฺรุเศน วิทฺเธา เตา ตทฺวเทว ตํ นินินฺทตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ตทา ทฺวิตียยามาตฺ ตฺฤตียยามํ ยาวตฺ สรฺวฺวเทเศ ตมิรํ พภูว, ");
INSERT INTO santha_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ตฺฤตียยาเม \"เอลี เอลี ลามา ศิวกฺตนี\", อรฺถาตฺ มทีศฺวร มทีศฺวร กุโต มามตฺยากฺษี:? ยีศุรุจฺไจริติ ชคาทฯ ");
INSERT INTO santha_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ตทา ตตฺร สฺถิตา: เกจิตฺ ตตฺ ศฺรุตฺวา พภาษิเร, อยมฺ เอลิยมาหูยติฯ ");
INSERT INTO santha_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","เตษำ มธฺยาทฺ เอก: ศีฆฺรํ คตฺวา สฺปญฺชํ คฺฤหีตฺวา ตตฺรามฺลรสํ ทตฺตฺวา นเลน ปาตุํ ตไสฺม ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","อิตเร'กถยนฺ ติษฺฐต, ตํ รกฺษิตุมฺ เอลิย อายาติ นเวติ ปศฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ยีศุ: ปุนรุไจราหูย ปฺราณานฺ ชเหาฯ ");
INSERT INTO santha_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ตโต มนฺทิรสฺย วิจฺเฉทวสนมฺ อูรฺทฺวฺวาทโธ ยาวตฺ ฉิทฺยมานํ ทฺวิธาภวตฺ, ");
INSERT INTO santha_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ภูมิศฺจกมฺเป ภูธโรวฺยทีรฺยฺยต จฯ ศฺมศาเน มุกฺเต ภูริปุณฺยวตำ สุปฺตเทหา อุทติษฺฐนฺ, ");
INSERT INTO santha_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ศฺมศานาทฺ วหิรฺภูย ตทุตฺถานาตฺ ปรํ ปุณฺยปุรํ คตฺวา พหุชนานฺ ทรฺศยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ยีศุรกฺษณาย นิยุกฺต: ศตเสนาปติสฺตตฺสงฺคินศฺจ ตาทฺฤศีํ ภูกมฺปาทิฆฏนำ ทฺฤษฺฏฺวา ภีตา อวทนฺ, เอษ อีศฺวรปุโตฺร ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ยา พหุโยษิโต ยีศุํ เสวมานา คาลีลสฺตตฺปศฺจาทาคตาสฺตาสำ มเธฺย ");
INSERT INTO santha_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","มคฺทลีนี มริยมฺ ยากูโพฺยโศฺย รฺมาตา ยา มริยมฺ สิพทิยปุตฺรโย รฺมาตา จ โยษิต เอตา ทูเร ติษฺฐนฺโตฺย ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","สนฺธฺยายำ สตฺยมฺ อริมถิยานครสฺย ยูษผฺนามา ธนี มนุโช ยีโศ: ศิษฺยตฺวาตฺ ");
INSERT INTO santha_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ปีลาตสฺย สมีปํ คตฺวา ยีโศ: กายํ ยยาเจ, เตน ปีลาต: กายํ ทาตุมฺ อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ยูษผฺ ตตฺกายํ นีตฺวา ศุจิวสฺเตฺรณาจฺฉาทฺย ");
INSERT INTO santha_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","สฺวารฺถํ ไศเล ยตฺ ศฺมศานํ จขาน, ตนฺมเธฺย ตตฺกายํ นิธาย ตสฺย ทฺวาริ วฺฤหตฺปาษาณํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","กินฺตุ มคฺทลีนี มริยมฺ อนฺยมริยมฺ เอเต สฺตฺริเยา ตตฺร ศฺมศานสมฺมุข อุปวิวิศตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ตทนนฺตรํ นิสฺตาโรตฺสวสฺยาโยชนทินาตฺ ปเร'หนิ ปฺรธานยาชกา: ผิรูศินศฺจ มิลิตฺวา ปีลาตมุปาคตฺยากถยนฺ, ");
INSERT INTO santha_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","เห มเหจฺฉ ส ปฺรตารโก ชีวน อกถยตฺ, ทินตฺรยาตฺ ปรํ ศฺมศานาทุตฺถาสฺยามิ ตทฺวากฺยํ สฺมราโม วยํ; ");
INSERT INTO santha_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ตสฺมาตฺ ตฺฤตียทินํ ยาวตฺ ตตฺ ศฺมศานํ รกฺษิตุมาทิศตุ, โนเจตฺ ตจฺฉิษฺยา ยามินฺยามาคตฺย ตํ หฺฤตฺวา โลกานฺ วทิษฺยนฺติ, ส ศฺมศานาทุทติษฺฐตฺ, ตถา สติ ปฺรถมภฺรานฺเต: เศษียภฺรานฺติ รฺมหตี ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ตทา ปีลาต อวาทีตฺ, ยุษฺมากํ สมีเป รกฺษิคณ อาเสฺต, ยูยํ คตฺวา ยถา สาธฺยํ รกฺษยตฯ ");
INSERT INTO santha_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ตตเสฺต คตฺวา ตทฺทูाรปาษาณํ มุทฺรางฺกิตํ กฺฤตฺวา รกฺษิคณํ นิโยชฺย ศฺมศานํ รกฺษยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ตต: ปรํ วิศฺรามวารสฺย เศเษ สปฺตาหปฺรถมทินสฺย ปฺรโภเต ชาเต มคฺทลีนี มริยมฺ อนฺยมริยมฺ จ ศฺมศานํ ทฺรษฺฏุมาคตาฯ ");
INSERT INTO santha_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ตทา มหานฺ ภูกมฺโป'ภวตฺ; ปรเมศฺวรียทูต: สฺวรฺคาทวรุหฺย ศฺมศานทฺวาราตฺ ปาษาณมปสารฺยฺย ตทุปรฺยฺยุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ตทฺวทนํ วิทฺยุทฺวตฺ เตโชมยํ วสนํ หิมศุภฺรญฺจฯ ");
INSERT INTO santha_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ตทานีํ รกฺษิณสฺตทฺภยาตฺ กมฺปิตา มฺฤตวทฺ พภูว:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ส ทูโต โยษิโต ชคาท, ยูยํ มา ไภษฺฏ, กฺรุศหตยีศุํ มฺฤคยเธฺว ตทหํ เวทฺมิฯ ");
INSERT INTO santha_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","โส'ตฺร นาสฺติ, ยถาวทตฺ ตโถตฺถิตวานฺ; เอตตฺ ปฺรโภ: ศยนสฺถานํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ตูรฺณํ คตฺวา ตจฺฉิษฺยานฺ อิติ วทต, ส ศฺมศานาทฺ อุทติษฺฐตฺ, ยุษฺมากมเคฺร คาลีลํ ยาสฺยติ ยูยํ ตตฺร ตํ วีกฺษิษฺยเธฺว, ปศฺยตาหํ วารฺตฺตามิมำ ยุษฺมานวาทิษํฯ ");
INSERT INTO santha_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ตตสฺตา ภยาตฺ มหานนฺทาญฺจ ศฺมศานาตฺ ตูรฺณํ พหิรฺภูย ตจฺฉิษฺยานฺ วารฺตฺตำ วกฺตุํ ธาวิตวตฺย:ฯ กินฺตุ ศิษฺยานฺ วารฺตฺตำ วกฺตุํ ยานฺติ, ตทา ยีศุ รฺทรฺศนํ ทตฺตฺวา ตา ชคาท, ");
INSERT INTO santha_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ยุษฺมากํ กลฺยาณํ ภูยาตฺ, ตตสฺตา อาคตฺย ตตฺปาทโย: ปติตฺวา ปฺรเณมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ยีศุสฺตา อวาทีตฺ, มา พิภีต, ยูยํ คตฺวา มม ภฺราตฺฤนฺ คาลีลํ ยาตุํ วทต, ตตฺร เต มำ ทฺรกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","สฺตฺริโย คจฺฉนฺติ, ตทา รกฺษิณำ เกจิตฺ ปุรํ คตฺวา ยทฺยทฺ ฆฏิตํ ตตฺสรฺวฺวํ ปฺรธานยาชกานฺ ชฺญาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","เต ปฺราจีไน: สมํ สํสทํ กฺฤตฺวา มนฺตฺรยนฺโต พหุมุทฺรา: เสนาโภฺย ทตฺตฺวาวทนฺ, ");
INSERT INTO santha_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","อสฺมาสุ นิทฺริเตษุ ตจฺฉิษฺยา ยามินฺยามาคตฺย ตํ หฺฤตฺวานยนฺ, อิติ ยูยํ ปฺรจารยตฯ ");
INSERT INTO santha_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ยเทฺยตทธิปเต: โศฺรตฺรโคจรีภเวตฺ, ตรฺหิ ตํ โพธยิตฺวา ยุษฺมานวิษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ตตเสฺต มุทฺรา คฺฤหีตฺวา ศิกฺษานุรูปํ กรฺมฺม จกฺรุ:, ยิหูทียานำ มเธฺย ตสฺยาทฺยาปิ กึวทนฺตี วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","เอกาทศ ศิษฺยา ยีศุนิรูปิตาคาลีลสฺยาทฺรึ คตฺวา ");
INSERT INTO santha_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ตตฺร ตํ สํวีกฺษฺย ปฺรเณมุ:, กินฺตุ เกจิตฺ สนฺทิคฺธวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ยีศุเสฺตษำ สมีปมาคตฺย วฺยาหฺฤตวานฺ, สฺวรฺคเมทิโนฺย: สรฺวฺวาธิปติตฺวภาโร มยฺยรฺปิต อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","อโต ยูยํ ปฺรยาย สรฺวฺวเทศียานฺ ศิษฺยานฺ กฺฤตฺวา ปิตุ: ปุตฺรสฺย ปวิตฺรสฺยาตฺมนศฺจ นามฺนา ตานวคาหยต; อหํ ยุษฺมานฺ ยทฺยทาทิศํ ตทปิ ปาลยิตุํ ตานุปาทิศตฯ ");
INSERT INTO santha_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ปศฺยต, ชคทนฺตํ ยาวตฺ สทาหํ ยุษฺมาภิ: สากํ ติษฺฐามิฯ อิติฯ");
INSERT INTO santha_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","อีศฺวรปุตฺรสฺย ยีศุขฺรีษฺฏสฺย สุสํวาทารมฺภ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ภวิษฺยทฺวาทินำ คฺรนฺเถษุ ลิปิริตฺถมาเสฺต, ปศฺย สฺวกียทูตนฺตุ ตวาเคฺร เปฺรษยามฺยหมฺฯ คตฺวา ตฺวทียปนฺถานํ ส หิ ปริษฺกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"ปรเมศสฺย ปนฺถานํ ปริษฺกุรุต สรฺวฺวต:ฯ ตสฺย ราชปถญฺไจว สมานํ กุรุตาธุนาฯ \" อิเตฺยตตฺ ปฺรานฺตเร วากฺยํ วทต: กสฺยจิทฺรว:๚ ");
INSERT INTO santha_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","เสอว โยหนฺ ปฺรานฺตเร มชฺชิตวานฺ ตถา ปาปมารฺชนนิมิตฺตํ มโนวฺยาวรฺตฺตกมชฺชนสฺย กถาญฺจ ปฺรจาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ตโต ยิหูทาเทศยิรูศาลมฺนครนิวาสิน: สรฺเวฺว โลกา พหิ รฺภูตฺวา ตสฺย สมีปมาคตฺย สฺวานิ สฺวานิ ปาปานฺยงฺคีกฺฤตฺย ยรฺทฺทนนทฺยำ เตน มชฺชิตา พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","อสฺย โยหน: ปริเธยานิ กฺรเมลกโลมชานิ, ตสฺย กฏิพนฺธนํ จรฺมฺมชาตมฺ, ตสฺย ภกฺษฺยาณิ จ ศูกกีฏา วนฺยมธูนิ จาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ส ปฺรจารยนฺ กถยาญฺจเกฺร, อหํ นมฺรีภูย ยสฺย ปาทุกาพนฺธนํ โมจยิตุมปิ น โยโคฺยสฺมิ, ตาทฺฤโศ มตฺโต คุรุตร เอก: ปุรุโษ มตฺปศฺจาทาคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","อหํ ยุษฺมานฺ ชเล มชฺชิตวานฺ กินฺตุ ส ปวิตฺร อาตฺมานิ สํมชฺชยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","อปรญฺจ ตสฺมินฺเนว กาเล คาลีลฺปฺรเทศสฺย นาสรทฺคฺรามาทฺ ยีศุราคตฺย โยหนา ยรฺทฺทนนทฺยำ มชฺชิโต'ภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ส ชลาทุตฺถิตมาโตฺร เมฆทฺวารํ มุกฺตํ กโปตวตฺ สฺวโสฺยปริ อวโรหนฺตมาตฺมานญฺจ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ตฺวํ มม ปฺริย: ปุตฺรสฺตฺวเยฺยว มมมหาสนฺโตษ อิยมากาศียา วาณี พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ตสฺมินฺ กาเล อาตฺมา ตํ ปฺรานฺตรมธฺยํ นินายฯ ");
INSERT INTO santha_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","อถ ส จตฺวารึศทฺทินานิ ตสฺมินฺ สฺถาเน วนฺยปศุภิ: สห ติษฺฐนฺ ไศตานา ปรีกฺษิต:; ปศฺจาตฺ สฺวรฺคียทูตาสฺตํ สิเษวิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","อนนฺตรํ โยหนิ พนฺธนาลเย พทฺเธ สติ ยีศุ รฺคาลีลฺปฺรเทศมาคตฺย อีศฺวรราชฺยสฺย สุสํวาทํ ปฺรจารยนฺ กถยามาส, ");
INSERT INTO santha_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","กาล: สมฺปูรฺณ อีศฺวรราชฺยญฺจ สมีปมาคตํ; อโตเหโต รฺยูยํ มนำสิ วฺยาวรฺตฺตยธฺวํ สุสํวาเท จ วิศฺวาสิตฯ ");
INSERT INTO santha_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ตทนนฺตรํ ส คาลีลียสมุทฺรสฺย ตีเร คจฺฉนฺ ศิโมนฺ ตสฺย ภฺราตา อนฺทฺริยนามา จ อิเมา เทฺวา ชเนา มตฺสฺยธาริเณา สาครมเธฺย ชาลํ ปฺรกฺษิปนฺเตา ทฺฤษฺฏฺวา ตาววทตฺ, ");
INSERT INTO santha_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ยุวำ มม ปศฺจาทาคจฺฉตํ, ยุวามหํ มนุษฺยธาริเณา กริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ตตเสฺตา ตตฺกฺษณเมว ชาลานิ ปริตฺยชฺย ตสฺย ปศฺจาตฺ ชคฺมตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ตต: ปรํ ตตฺสฺถานาตฺ กิญฺจิทฺ ทูรํ คตฺวา ส สิวทีปุตฺรยากูพฺ ตทฺภฺราตฺฤโยหนฺ จ อิเมา เนากายำ ชาลานำ ชีรฺณมุทฺธารยนฺเตา ทฺฤษฺฏฺวา ตาวาหูยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ตตเสฺตา เนากายำ เวตนภุคฺภิ: สหิตํ สฺวปิตรํ วิหาย ตตฺปศฺจาทียตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ตต: ปรํ กผรฺนาหูมฺนามกํ นครมุปสฺถาย ส วิศฺรามทิวเส ภชนคฺรหํ ปฺรวิศฺย สมุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ตโสฺยปเทศาโลฺลกา อาศฺจรฺยฺยํ เมนิเร ยต: โสธฺยาปกาอิว โนปทิศนฺ ปฺรภาววานิว โปฺรปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","อปรญฺจ ตสฺมินฺ ภชนคฺฤเห อปวิตฺรภูเตน คฺรสฺต เอโก มานุษ อาสีตฺฯ ส จีตฺศพฺทํ กฺฤตฺวา กถยาญฺจเก ");
INSERT INTO santha_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","โภ นาสรตีย ยีโศ ตฺวมสฺมานฺ ตฺยช, ตฺวยา สหาสฺมากํ ก: สมฺพนฺธ:? ตฺวํ กิมสฺมานฺ นาศยิตุํ สมาคต:? ตฺวมีศฺวรสฺย ปวิตฺรโลก อิตฺยหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ตทา ยีศุสฺตํ ตรฺชยิตฺวา ชคาท ตูษฺณีํ ภว อิโต พหิรฺภว จฯ ");
INSERT INTO santha_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ตต: โส'ปวิตฺรภูตสฺตํ สมฺปีฑฺย อตฺยุไจศฺจีตฺกฺฤตฺย นิรฺชคามฯ ");
INSERT INTO santha_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","เตไนว สรฺเวฺว จมตฺกฺฤตฺย ปรสฺปรํ กถยาญฺจกฺริเร, อโห กิมิทํ? กีทฺฤโศ'ยํ นวฺย อุปเทศ:? อเนน ปฺรภาเวนาปวิตฺรภูเตษฺวาชฺญาปิเตษุ เต ตทาชฺญานุวรฺตฺติโน ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ตทา ตสฺย ยโศ คาลีลศฺจตุรฺทิกฺสฺถสรฺวฺวเทศานฺ วฺยาปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","อปรญฺจ เต ภชนคฺฤหาทฺ พหิ รฺภูตฺวา ยากูโพฺยหนฺภฺยำ สห ศิโมน อานฺทฺริยสฺย จ นิเวศนํ ปฺรวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ตทา ปิตรสฺย ศฺวศฺรูรฺชฺวรปีฑิตา ศยฺยายามาสฺต อิติ เต ตํ ฌฏิติ วิชฺญาปยาญฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ตต: ส อาคตฺย ตสฺยา หสฺตํ ธฺฤตฺวา ตามุทสฺถาปยตฺ; ตไทว ตำ ชฺวโร'ตฺยากฺษีตฺ ตต: ปรํ สา ตานฺ สิเษเวฯ ");
INSERT INTO santha_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","อถาสฺตํ คเต รเวา สนฺธฺยากาเล สติ โลกาสฺตตฺสมีปํ สรฺวฺวานฺ โรคิโณ ภูตธฺฤตำศฺจ สมานินฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","สรฺเวฺว นาคริกา โลกา ทฺวาริ สํมิลิตาศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ตต: ส นานาวิธโรคิโณ พหูนฺ มนุชานโรคิณศฺจการ ตถา พหูนฺ ภูตานฺ ตฺยาชยาญฺจการ ตานฺ ภูตานฺ กิมปิ วากฺยํ วกฺตุํ นิษิเษธ จ ยโตเหโตเสฺต ตมชานนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","อปรญฺจ โส'ติปฺรตฺยูเษ วสฺตุตสฺตุ ราตฺริเศเษ สมุตฺถาย พหิรฺภูย นิรฺชนํ สฺถานํ คตฺวา ตตฺร ปฺรารฺถยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","อนนฺตรํ ศิโมนฺ ตตฺสงฺคินศฺจ ตสฺย ปศฺจาทฺ คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ตทุทฺเทศํ ปฺราปฺย ตมวทนฺ สรฺเวฺว โลกาสฺตฺวำ มฺฤคยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ตทา โส'กถยตฺ อาคจฺฉต วยํ สมีปสฺถานิ นคราณิ ยาม:, ยโต'หํ ตตฺร กถำ ปฺรจารยิตุํ พหิราคมมฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","อถ ส เตษำ คาลีลฺปฺรเทศสฺย สรฺเวฺวษุ ภชนคฺฤเหษุ กถา: ปฺรจารยาญฺจเกฺร ภูตานตฺยาชยญฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","อนนฺตรเมก: กุษฺฐี สมาคตฺย ตตฺสมฺมุเข ชานุปาตํ วินยญฺจ กฺฤตฺวา กถิตวานฺ ยทิ ภวานฺ อิจฺฉติ ตรฺหิ มำ ปริษฺกรฺตฺตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ตต: กฺฤปาลุ รฺยีศุ: กเรา ปฺรสารฺยฺย ตํ สฺปษฺฏฺวา กถยามาส ");
INSERT INTO santha_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","มเมจฺฉา วิทฺยเต ตฺวํ ปริษฺกฺฤโต ภวฯ เอตตฺกถายา: กถนมาตฺราตฺ ส กุษฺฐี โรคานฺมุกฺต: ปริษฺกฺฤโต'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ตทา ส ตํ วิสฺฤชนฺ คาฒมาทิศฺย ชคาท ");
INSERT INTO santha_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","สาวธาโน ภว กถามิมำ กมปิ มา วท; สฺวาตฺมานํ ยาชกํ ทรฺศย, โลเกภฺย: สฺวปริษฺกฺฤเต: ปฺรมาณทานาย มูสานิรฺณีตํ ยทฺทานํ ตทุตฺสฺฤชสฺว จฯ ");
INSERT INTO santha_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","กินฺตุ ส คตฺวา ตตฺ กรฺมฺม อิตฺถํ วิสฺตารฺยฺย ปฺรจารยิตุํ ปฺราเรเภ เตไนว ยีศุ: ปุน: สปฺรกาศํ นครํ ปฺรเวษฺฏุํ นาศกฺโนตฺ ตโตเหโตรฺพหิ: กานนสฺถาเน ตเสฺยา; ตถาปิ จตุรฺทฺทิคฺโภฺย โลกาสฺตสฺย สมีปมายยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ตทนนฺตรํ ยีไศ กติปยทินานิ วิลมฺพฺย ปุน: กผรฺนาหูมฺนครํ ปฺรวิษฺเฏ ส คฺฤห อาสฺต อิติ กึวทนฺตฺยา ตตฺกฺษณํ ตตฺสมีปํ พหโว โลกา อาคตฺย สมุปตสฺถุ:, ");
INSERT INTO santha_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ตสฺมาทฺ คฺฤหมเธฺย สรฺเวฺวษำ กฺฤเต สฺถานํ นาภวทฺ ทฺวารสฺย จตุรฺทิกฺษฺวปิ นาภวตฺ, ตตฺกาเล ส ตานฺ ปฺรติ กถำ ปฺรจารยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ตต: ปรํ โลกาศฺจตุรฺภิ รฺมานไวเรกํ ปกฺษาฆาตินํ วาหยิตฺวา ตตฺสมีปมฺ อานินฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","กินฺตุ ชนานำ พหุตฺวาตฺ ตํ ยีโศ: สมฺมุขมาเนตุํ น ศกฺนุวนฺโต ยสฺมินฺ สฺถาเน ส อาเสฺต ตทุปริคฺฤหปฺฤษฺฐํ ขนิตฺวา ฉิทฺรํ กฺฤตฺวา เตน มารฺเคณ สศยฺยํ ปกฺษาฆาตินมฺ อวโรหยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ตโต ยีศุเสฺตษำ วิศฺวาสํ ทฺฤษฺฏฺวา ตํ ปกฺษาฆาตินํ พภาเษ เห วตฺส ตว ปาปานำ มารฺชนํ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ตทา กิยนฺโต'ธฺยาปกาสฺตโตฺรปวิศนฺโต มโนภิ รฺวิตรฺกยาญฺจกฺรุ:, เอษ มนุษฺย เอตาทฺฤศีมีศฺวรนินฺทำ กถำ กุต: กถยติ? ");
INSERT INTO santha_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","อีศฺวรํ วินา ปาปานิ มารฺษฺฏุํ กสฺย สามรฺถฺยมฺ อาเสฺต? ");
INSERT INTO santha_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","อิตฺถํ เต วิตรฺกยนฺติ ยีศุสฺตตฺกฺษณํ มนสา ตทฺ พุทฺวฺวา ตานวททฺ ยูยมนฺต:กรไณ: กุต เอตานิ วิตรฺกยถ? ");
INSERT INTO santha_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ตทนนฺตรํ ยีศุสฺตตฺสฺถานาตฺ ปุน: สมุทฺรตฏํ ยเยา; โลกนิวเห ตตฺสมีปมาคเต ส ตานฺ สมุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","กินฺตุ ปฺฤถิวฺยำ ปาปานิ มารฺษฺฏุํ มนุษฺยปุตฺรสฺย สามรฺถฺยมสฺติ, เอตทฺ ยุษฺมานฺ ชฺญาปยิตุํ (ส ตไสฺม ปกฺษาฆาติเน กถยามาส) ");
INSERT INTO santha_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","อุตฺติษฺฐ ตว ศยฺยำ คฺฤหีตฺวา สฺวคฺฤหํ ยาหิ, อหํ ตฺวามิทมฺ อาชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ตต: ส ตตฺกฺษณมฺ อุตฺถาย ศยฺยำ คฺฤหีตฺวา สรฺเวฺวษำ สากฺษาตฺ ชคาม; สรฺเวฺว วิสฺมิตา เอตาทฺฤศํ กรฺมฺม วยมฺ กทาปิ นาปศฺยาม, อิมำ กถำ กถยิเตฺวศฺวรํ ธนฺยมพฺรุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ตทนนฺตรํ ยีศุสฺตตฺสฺถานาตฺ ปุน: สมุทฺรตฏํ ยเยา; โลกนิวเห ตตฺสมีปมาคเต ส ตานฺ สมุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","อถ คจฺฉนฺ กรสญฺจยคฺฤห อุปวิษฺฏมฺ อาลฺผียปุตฺรํ เลวึ ทฺฤษฺฏฺวา ตมาหูย กถิตวานฺ มตฺปศฺจาตฺ ตฺวามามจฺฉ ตต: ส อุตฺถาย ตตฺปศฺจาทฺ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","อนนฺตรํ ยีเศา ตสฺย คฺฤเห โภกฺตุมฺ อุปวิษฺเฏ พหว: กรมญฺจายิน: ปาปินศฺจ เตน ตจฺฉิไษฺยศฺจ สโหปวิวิศุ:, ยโต พหวสฺตตฺปศฺจาทาชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ตทา ส กรมญฺจายิภิ: ปาปิภิศฺจ สห ขาทติ, ตทฺ ทฺฤษฺฏฺวาธฺยาปกา: ผิรูศินศฺจ ตสฺย ศิษฺยานูจุ: กรมญฺจายิภิ: ปาปิภิศฺจ สหายํ กุโต ภุํกฺเต ปิวติ จ? ");
INSERT INTO santha_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ตทฺวากฺยํ ศฺรุตฺวา ยีศุ: ปฺรตฺยุวาจ,อโรคิโลกานำ จิกิตฺสเกน ปฺรโยชนํ นาสฺติ, กินฺตุ โรคิณาเมว; อหํ ธารฺมฺมิกานาหฺวาตุํ นาคต: กินฺตุ มโน วฺยาวรฺตฺตยิตุํ ปาปิน เอวฯ ");
INSERT INTO santha_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ตต: ปรํ โยหน: ผิรูศินาญฺโจปวาสาจาริศิษฺยา ยีโศ: สมีปมฺ อาคตฺย กถยามาสุ:, โยหน: ผิรูศินาญฺจ ศิษฺยา อุปวสนฺติ กินฺตุ ภวต: ศิษฺยา โนปวสนฺติ กึ การณมสฺย? ");
INSERT INTO santha_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ตทา ยีศุสฺตานฺ พภาเษ ยาวตฺ กาลํ สขิภิ: สห กนฺยายา วรสฺติษฺฐติ ตาวตฺกาลํ เต กิมุปวสฺตุํ ศกฺนุวนฺติ? ยาวตฺกาลํ วรไสฺต: สห ติษฺฐติ ตาวตฺกาลํ ต อุปวสฺตุํ น ศกฺนุวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ยสฺมินฺ กาเล เตภฺย: สกาศาทฺ วโร เนษฺยเต ส กาล อาคจฺฉติ, ตสฺมินฺ กาเล เต ชนา อุปวตฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","โกปิ ชน: ปุราตนวสฺเตฺร นูตนวสฺตฺรํ น สีวฺยติ, ยโต นูตนวสฺเตฺรณ สห เสวเน กฺฤเต ชีรฺณํ วสฺตฺรํ ฉิทฺยเต ตสฺมาตฺ ปุน รฺมหตฺ ฉิทฺรํ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","โกปิ ชน: ปุราตนกุตูษุ นูตนํ ทฺรากฺษารสํ น สฺถาปยติ, ยโต นูตนทฺรากฺษารสสฺย เตชสา ตา: กุโตฺว วิทีรฺยฺยนฺเต ตโต ทฺรากฺษารสศฺจ ปตติ กุตฺวศฺจ นศฺยนฺติ, อเตอว นูตนทฺรากฺษารโส นูตนกุตูษุ สฺถาปนีย:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ตทนนฺตรํ ยีศุ รฺยทา วิศฺรามวาเร ศสฺยกฺเษเตฺรณ คจฺฉติ ตทา ตสฺย ศิษฺยา คจฺฉนฺต: ศสฺยมญฺชรีศฺเฉตฺตุํ ปฺรวฺฤตฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","อต: ผิรูศิโน ยีศเว กถยามาสุ: ปศฺยตุ วิศฺรามวาสเร ยตฺ กรฺมฺม น กรฺตฺตวฺยํ ตทฺ อิเม กุต: กุรฺวฺวนฺติ? ");
INSERT INTO santha_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ตทา ส เตโภฺย'กถยตฺ ทายูทฺ ตตฺสํงฺคินศฺจ ภกฺษฺยาภาวาตฺ กฺษุธิตา: สนฺโต ยตฺ กรฺมฺม กฺฤตวนฺตสฺตตฺ กึ ยุษฺมาภิ รฺน ปฐิตมฺ? ");
INSERT INTO santha_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","อพิยาถรฺนามเก มหายาชกตำ กุรฺวฺวติ ส กถมีศฺวรสฺยาวาสํ ปฺรวิศฺย เย ทรฺศนียปูปา ยาชกานฺ วินานฺยสฺย กสฺยาปิ น ภกฺษฺยาสฺตาเนว พุภุเช สงฺคิโลเกโภฺย'ปิ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","โส'ปรมปิ ชคาท, วิศฺรามวาโร มนุษฺยารฺถเมว นิรูปิโต'สฺติ กินฺตุ มนุโษฺย วิศฺรามวารารฺถํ ไนวฯ ");
INSERT INTO santha_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","มนุษฺยปุโตฺร วิศฺรามวารสฺยาปิ ปฺรภุราเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","อนนฺตรํ ยีศุ: ปุน รฺภชนคฺฤหํ ปฺรวิษฺฏสฺตสฺมินฺ สฺถาเน ศุษฺกหสฺต เอโก มานว อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ส วิศฺรามวาเร ตมโรคิณํ กริษฺยติ นเวตฺยตฺร พหวสฺตมฺ อปวทิตุํ ฉิทฺรมเปกฺษิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ตทา ส ตํ ศุษฺกหสฺตํ มนุษฺยํ ชคาท มธฺยสฺถาเน ตฺวมุตฺติษฺฐฯ ");
INSERT INTO santha_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ตต: ปรํ ส ตานฺ ปปฺรจฺฉ วิศฺรามวาเร หิตมหิตํ ตถา หิ ปฺราณรกฺษา วา ปฺราณนาศ เอษำ มเธฺย กึ กรณียํ ? กินฺตุ เต นิ:ศพฺทาสฺตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ตทา ส เตษามนฺต:กรณานำ กาฐินฺยาทฺเธโต รฺทุ:ขิต: โกฺรธาตฺ จรฺตุिทโศ ทฺฤษฺฏวานฺ ตํ มานุษํ คทิตวานฺ ตํ หสฺตํ วิสฺตารย, ตตเสฺตน หเสฺต วิสฺตฺฤเต ตทฺธโสฺต'นฺยหสฺตวทฺ อโรโค ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","อถ ผิรูศิน: ปฺรสฺถาย ตํ นาศยิตุํ เหโรทีไย: สห มนฺตฺรยิตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","อเตอว ยีศุสฺตตฺสฺถานํ ปริตฺยชฺย ศิไษฺย: สห ปุน: สาครสมีปํ คต:; ");
INSERT INTO santha_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ตโต คาลีลฺยิหูทา-ยิรูศาลมฺ-อิโทมฺ-ยรฺทนฺนทีปารสฺถาเนโภฺย โลกสมูหสฺตสฺย ปศฺจาทฺ คต:; ตทนฺย: โสรสีทโน: สมีปวาสิโลกสมูหศฺจ ตสฺย มหากรฺมฺมณำ วารฺตฺตํ ศฺรุตฺวา ตสฺย สนฺนิธิมาคต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ตทา โลกสมูหศฺเจตฺ ตโสฺยปริ ปตติ อิตฺยาศงฺกฺย ส นาวเมกำ นิกเฏ สฺถาปยิตุํ ศิษฺยานาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ยโต'เนกมนุษฺยาณามาโรคฺยกรณาทฺ วฺยาธิคฺรสฺตา: สรฺเวฺว ตํ สฺปฺรษฺฏุํ ปรสฺปรํ พเลน ยตฺนวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","อปรญฺจ อปวิตฺรภูตาสฺตํ ทฺฤษฺฏฺวา ตจฺจรณโย: ปติตฺวา โปฺรไจ: โปฺรจุ:, ตฺวมีศฺวรสฺย ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","กินฺตุ ส ตานฺ ทฺฤฒมฺ อาชฺญาปฺย สฺวํ ปริจายิตุํ นิษิทฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","อนนฺตรํ ส ปรฺวฺวตมารุหฺย ยํ ยํ ปฺรติจฺฉา ตํ ตมาหูตวานฺ ตตเสฺต ตตฺสมีปมาคตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ตทา ส ทฺวาทศชนานฺ เสฺวน สห สฺถาตุํ สุสํวาทปฺรจาราย เปฺรริตา ภวิตุํ ");
INSERT INTO santha_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","สรฺวฺวปฺรการวฺยาธีนำ ศมนกรณาย ปฺรภาวํ ปฺราปฺตุํ ภูตานฺ ตฺยาชยิตุญฺจ นิยุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","เตษำ นามานีมานิ, ศิโมนฺ สิวทิปุโตฺร ");
INSERT INTO santha_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ยากูพฺ ตสฺย ภฺราตา โยหนฺ จ อานฺทฺริย: ผิลิโป พรฺถลมย:, ");
INSERT INTO santha_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","มถี โถมา จ อาลฺผียปุโตฺร ยากูพฺ ถทฺทีย: กินานีย: ศิโมนฺ ยสฺตํ ปรหเสฺตษฺวรฺปยิษฺยติ ส อีษฺกริโยตียยิหูทาศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ส ศิโมเน ปิตร อิตฺยุปนาม ทเทา ยากูโพฺยหนฺภฺยำ จ พิเนริคิศฺ อรฺถโต เมฆนาทปุตฺราวิตฺยุปนาม ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","อนนฺตรํ เต นิเวศนํ คตา:, กินฺตุ ตตฺราปิ ปุนรฺมหานฺ ชนสมาคโม 'ภวตฺ ตสฺมาตฺเต โภกฺตุมปฺยวกาศํ น ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ตตสฺตสฺย สุหฺฤโลฺลกา อิมำ วารฺตฺตำ ปฺราปฺย ส หตชฺญาโนภูทฺ อิติ กถำ กถยิตฺวา ตํ ธฺฤตฺวาเนตุํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","อปรญฺจ ยิรูศาลม อาคตา เย เย'ธฺยาปกาเสฺต ชคทุรยํ ปุรุโษ ภูตปตฺยาพิษฺฏเสฺตน ภูตปตินา ภูตานฺ ตฺยาชยติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ตตสฺตานาหูย ยีศุ รฺทฺฤษฺฏานฺไต: กถำ กถิตวานฺ ไศตานฺ กถํ ไศตานํ ตฺยาชยิตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","กิญฺจน ราชฺยํ ยทิ สฺววิโรเธน ปฺฤถคฺ ภวติ ตรฺหิ ตทฺ ราชฺยํ สฺถิรํ สฺถาตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ตถา กสฺยาปิ ปริวาโร ยทิ ปรสฺปรํ วิโรธี ภวติ ตรฺหิ โสปิ ปริวาร: สฺถิรํ สฺถาตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ตทฺวตฺ ไศตานฺ ยทิ สฺววิปกฺษตยา อุตฺติษฺฐนฺ ภินฺโน ภวติ ตรฺหิ โสปิ สฺถิรํ สฺถาตุํ น ศกฺโนติ กินฺตูจฺฉินฺโน ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","อปรญฺจ ปฺรพลํ ชนํ ปฺรถมํ น พทฺธา โกปิ ตสฺย คฺฤหํ ปฺรวิศฺย ทฺรวฺยาณิ ลุณฺฐยิตุํ น ศกฺโนติ, ตํ พทฺไวฺวว ตสฺย คฺฤหสฺย ทฺรวฺยาณิ ลุณฺฐยิตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","อโตเหโต รฺยุษฺมภฺยมหํ สตฺยํ กถยามิ มนุษฺยาณำ สนฺตานา ยานิ ยานิ ปาปานีศฺวรนินฺทาญฺจ กุรฺวฺวนฺติ เตษำ ตตฺสรฺเวฺวษามปราธานำ กฺษมา ภวิตุํ ศกฺโนติ, ");
INSERT INTO santha_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","กินฺตุ ย: กศฺจิตฺ ปวิตฺรมาตฺมานํ นินฺทติ ตสฺยาปราธสฺย กฺษมา กทาปิ น ภวิษฺยติ โสนนฺตทณฺฑสฺยาโรฺห ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ตสฺยาปวิตฺรภูโต'สฺติ เตษาเมตตฺกถาเหโต: ส อิตฺถํ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","อถ ตสฺย มาตา ภฺราตฺฤคณศฺจาคตฺย พหิสฺติษฺฐนโต โลกานฺ เปฺรษฺย ตมาหูตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ตตสฺตตฺสนฺนิเธา สมุปวิษฺฏา โลกาสฺตํ พภาษิเร ปศฺย พหิสฺตว มาตา ภฺราตรศฺจ ตฺวามฺ อนฺวิจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ตทา ส ตานฺ ปฺรตฺยุวาจ มม มาตา กา ภฺราตโร วา เก? ตต: ปรํ ส สฺวมีโปปวิษฺฏานฺ ศิษฺยานฺ ปฺรติ อวโลกนํ กฺฤตฺวา กถยามาส ");
INSERT INTO santha_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ปศฺยไตเต มม มาตา ภฺราตรศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ย: กศฺจิทฺ อีศฺวรเสฺยษฺฏำ กฺริยำ กโรติ ส เอว มม ภฺราตา ภคินี มาตา จฯ ");
INSERT INTO santha_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","อนนฺตรํ ส สมุทฺรตเฏ ปุนรุปเทษฺฏุํ ปฺราเรเภ, ตตสฺตตฺร พหุชนานำ สมาคมาตฺ ส สาคโรปริ เนากามารุหฺย สมุปวิษฺฏ:; สรฺเวฺว โลกา: สมุทฺรกูเล ตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ตทา ส ทฺฤษฺฏานฺตกถาภิ รฺพหูปทิษฺฏวานฺ อุปทิศํศฺจ กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","อวธานํ กุรุต, เอโก พีชวปฺตา พีชานิ วปฺตุํ คต:; ");
INSERT INTO santha_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","วปนกาเล กิยนฺติ พีชานิ มารฺคปาเศฺว ปติตานิ, ตต อากาศียปกฺษิณ เอตฺย ตานิ จขาทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","กิยนฺติ พีชานิ สฺวลฺปมฺฤตฺติกาวตฺปาษาณภูเมา ปติตานิ ตานิ มฺฤโทลฺปตฺวาตฺ ศีฆฺรมงฺกุริตานิ; ");
INSERT INTO santha_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","กินฺตูทิเต สูรฺเยฺย ทคฺธานิ ตถา มูลาโน นาโธคตตฺวาตฺ ศุษฺกาณิ จฯ ");
INSERT INTO santha_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","กิยนฺติ พีชานิ กณฺฏกิวนมเธฺย ปติตานิ ตต: กณฺฏกานิ สํวฺฤทฺวฺย ตานิ ชคฺรสุสฺตานิ น จ ผลิตานิฯ ");
INSERT INTO santha_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ตถา กิยนฺติ พีชานฺยุตฺตมภูเมา ปติตานิ ตานิ สํวฺฤทฺวฺย ผลานฺยุตฺปาทิตานิ กิยนฺติ พีชานิ ตฺรึศทฺคุณานิ กิยนฺติ ษษฺฏิคุณานิ กิยนฺติ ศตคุณานิ ผลานิ ผลิตวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","อถ ส ตานวทตฺ ยสฺย โศฺรตุํ กรฺเณา สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ตทนนฺตรํ นิรฺชนสมเย ตตฺสงฺคิโน ทฺวาทศศิษฺยาศฺจ ตํ ตทฺทฺฤษฺฏานฺตวากฺยสฺยารฺถํ ปปฺรจฺฉุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ตทา ส ตานุทิตวานฺ อีศฺวรราชฺยสฺย นิคูฒวากฺยํ โพทฺธุํ ยุษฺมากมธิกาโร'สฺติ; ");
INSERT INTO santha_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","กินฺตุ เย วหิรฺภูตา: \"เต ปศฺยนฺต: ปศฺยนฺติ กินฺตุ น ชานนฺติ, ศฺฤณฺวนฺต: ศฺฤณฺวนฺติ กินฺตุ น พุธฺยนฺเต, เจตฺไต รฺมน:สุ กทาปิ ปริวรฺตฺติเตษุ เตษำ ปาปานฺยโมจยิษฺยนฺต,\" อโตเหโตสฺตานฺ ปฺรติ ทฺฤษฺฏานฺไตเรว ตานิ มยา กถิตานิฯ ");
INSERT INTO santha_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","อถ ส กถิตวานฺ ยูยํ กิเมตทฺ ทฺฤษฺฏานฺตวากฺยํ น พุธฺยเธฺว? ตรฺหิ กถํ สรฺวฺวานฺ ทฺฤษฺฏานฺตาน โภตฺสฺยเธฺว? ");
INSERT INTO santha_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","พีชวปฺตา วากฺยรูปาณิ พีชานิ วปติ; ");
INSERT INTO santha_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ตตฺร เย เย โลกา วากฺยํ ศฺฤณฺวนฺติ, กินฺตุ ศฺรุตมาตฺราตฺ ไศตานฺ ศีฆฺรมาคตฺย เตษำ มน:สูปฺตานิ ตานิ วากฺยรูปาณิ พีชานฺยปนยติ เตอว อุปฺตพีชมารฺคปารฺเศฺวสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","เย ชนา วากฺยํ ศฺรุตฺวา สหสา ปรมานนฺเทน คฺฤหฺลนฺติ, กินฺตุ หฺฤทิ ไสฺถรฺยฺยาภาวาตฺ กิญฺจิตฺ กาลมาตฺรํ ติษฺฐนฺติ ตตฺปศฺจาตฺ ตทฺวากฺยเหโต: ");
INSERT INTO santha_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","กุตฺรจิตฺ เกฺลเศ อุปทฺรเว วา สมุปสฺถิเต ตไทว วิฆฺนํ ปฺราปฺนุวนฺติ เตอว อุปฺตพีชปาษาณภูมิสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","เย ชนา: กถำ ศฺฤณฺวนฺติ กินฺตุ สำสาริกี จินฺตา ธนภฺรานฺติ รฺวิษยโลภศฺจ เอเต สรฺเวฺว อุปสฺถาย ตำ กถำ คฺรสนฺติ ตต: มา วิผลา ภวติ ");
INSERT INTO santha_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","เตอว อุปฺตพีชสกณฺฏกภูมิสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","เย ชนา วากฺยํ ศฺรุตฺวา คฺฤหฺลนฺติ เตษำ กสฺย วา ตฺรึศทฺคุณานิ กสฺย วา ษษฺฏิคุณานิ กสฺย วา ศตคุณานิ ผลานิ ภวนฺติ เตอว อุปฺตพีโชรฺวฺวรภูมิสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ตทา โส'ปรมปิ กถิตวานฺ โกปิ ชโน ทีปาธารํ ปริตฺยชฺย โทฺรณสฺยาธ: ขฏฺวายา อเธ วา สฺถาปยิตุํ ทีปมานยติ กึ? ");
INSERT INTO santha_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","อโตเหโต รฺยนฺน ปฺรกาศยิษฺยเต ตาทฺฤคฺ ลุกฺกายิตํ กิมปิ วสฺตุ นาสฺติ; ยทฺ วฺยกฺตํ น ภวิษฺยติ ตาทฺฤศํ คุปฺตํ กิมปิ วสฺตุ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ยสฺย โศฺรตุํ กรฺเณา สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","อปรมปิ กถิตวานฺ ยูยํ ยทฺ ยทฺ วากฺยํ ศฺฤณุถ ตตฺร สาวธานา ภวต, ยโต ยูยํ เยน ปริมาเณน ปริมาถ เตไนว ปริมาเณน ยุษฺมทรฺถมปิ ปริมาสฺยเต; โศฺรตาโร ยูยํ ยุษฺมภฺยมธิกํ ทาสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ยสฺยาศฺรเย วรฺทฺธเต ตไสฺม อปรมปิ ทาสฺยเต, กินฺตุ ยสฺยาศฺรเย น วรฺทฺธเต ตสฺย ยตฺ กิญฺจิทสฺติ ตทปิ ตสฺมานฺ เนษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","อนนฺตรํ ส กถิตวานฺ เอโก โลก: เกฺษเตฺร พีชานฺยุปฺตฺวา ");
INSERT INTO santha_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ชาครณนิทฺราภฺยำ ทิวานิศํ คมยติ, ปรนฺตุ ตทฺวีชํ ตสฺยาชฺญาตรูเปณางฺกุรยติ วรฺทฺธเต จ; ");
INSERT INTO santha_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ยโตเหโต: ปฺรถมต: ปตฺราณิ ตต: ปรํ กณิศานิ ตตฺปศฺจาตฺ กณิศปูรฺณานิ ศสฺยานิ ภูมิ: สฺวยมุตฺปาทยติ; ");
INSERT INTO santha_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","กินฺตุ ผเลษุ ปกฺเกษุ ศสฺยจฺเฉทนกาลํ ชฺญาตฺวา ส ตตฺกฺษณํ ศสฺยานิ ฉินตฺติ, อเนน ตุลฺยมีศฺวรราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ปุน: โส'กถยทฺ อีศฺวรราชฺยํ เกน สมํ? เกน วสฺตุนา สห วา ตทุปมาสฺยามิ? ");
INSERT INTO santha_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ตตฺ สรฺษไปเกน ตุลฺยํ ยโต มฺฤทิ วปนกาเล สรฺษปพีชํ สรฺวฺวปฺฤถิวีสฺถพีชาตฺ กฺษุทฺรํ ");
INSERT INTO santha_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","กินฺตุ วปนาตฺ ปรมฺ องฺกุรยิตฺวา สรฺวฺวศากาทฺ พฺฤหทฺ ภวติ, ตสฺย พฺฤหตฺย: ศาขาศฺจ ชายนฺเต ตตสฺตจฺฉายำ ปกฺษิณ อาศฺรยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","อิตฺถํ เตษำ โพธานุรูปํ โส'เนกทฺฤษฺฏานฺไตสฺตานุปทิษฺฏวานฺ, ");
INSERT INTO santha_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ทฺฤษฺฏานฺตํ วินา กามปิ กถำ เตโภฺย น กถิตวานฺ ปศฺจานฺ นิรฺชเน ส ศิษฺยานฺ สรฺวฺวทฺฤษฺฏานฺตารฺถํ โพธิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ตทฺทินสฺย สนฺธฺยายำ ส เตโภฺย'กถยทฺ อาคจฺฉต วยํ ปารํ ยามฯ ");
INSERT INTO santha_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ตทา เต โลกานฺ วิสฺฤชฺย ตมวิลมฺพํ คฺฤหีตฺวา เนากยา ปฺรตสฺถิเร; อปรา อปิ นาวสฺตยา สห สฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ตต: ปรํ มหาฌญฺภฺศคมาตฺ เนา โรฺทลายมานา ตรงฺเคณ ชไล: ปูรฺณาภวจฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ตทา ส เนากาจศฺจาทฺภาเค อุปธาเน ศิโร นิธาย นิทฺริต อาสีตฺ ตตเสฺต ตํ ชาครยิตฺวา ชคทุ:, เห ปฺรโภ, อสฺมากํ ปฺราณา ยานฺติ กิมตฺร ภวตศฺจินฺตา นาสฺติ? ");
INSERT INTO santha_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ตทา ส อุตฺถาย วายุํ ตรฺชิตวานฺ สมุทฺรญฺโจกฺตวานฺ ศานฺต: สุสฺถิรศฺจ ภว; ตโต วาเยา นิวฺฤตฺเต'พฺธิรฺนิสฺตรงฺโคภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ตทา ส ตานุวาจ ยูยํ กุต เอตาทฺฤกฺศงฺกากุลา ภวต? กึ โว วิศฺวาโส นาสฺติ? ");
INSERT INTO santha_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ตสฺมาตฺเต'ตีวภีตา: ปรสฺปรํ วกฺตุมาเรภิเร, อโห วายุ: สินฺธุศฺจาสฺย นิเทศคฺราหิเณา กีทฺฤคยํ มนุช:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","อถ ตู สินฺธุปารํ คตฺวา คิเทรียปฺรเทศ อุปตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","เนากาโต นิรฺคตมาตฺราทฺ อปวิตฺรภูตคฺรสฺต เอก: ศฺมศานาเทตฺย ตํ สากฺษาจฺ จการฯ ");
INSERT INTO santha_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ส ศฺมศาเน'วาตฺสีตฺ โกปิ ตํ ศฺฤงฺขเลน พทฺวฺวา สฺถาปยิตุํ นาศกฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ชไนรฺวารํ นิคไฑ: ศฺฤงฺขไลศฺจ ส พทฺโธปิ ศฺฤงฺขลานฺยากฺฤษฺย โมจิตวานฺ นิคฑานิ จ ภํกฺตฺวา ขณฺฑํ ขณฺฑํ กฺฤตวานฺ โกปิ ตํ วศีกรฺตฺตุํ น ศศกฯ ");
INSERT INTO santha_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ทิวานิศํ สทา ปรฺวฺวตํ ศฺมศานญฺจ ภฺรมิตฺวา จีตฺศพฺทํ กฺฤตวานฺ คฺราวภิศฺจ สฺวยํ สฺวํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ส ยีศุํ ทูราตฺ ปศฺยนฺเนว ธาวนฺ ตํ ปฺรณนาม อุไจรุวํศฺโจวาจ, ");
INSERT INTO santha_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","เห สรฺโวฺวปริเสฺถศฺวรปุตฺร ยีโศ ภวตา สห เม ก: สมฺพนฺธ:? อหํ ตฺวามีศฺวเรณ ศาปเย มำ มา ยาตยฯ ");
INSERT INTO santha_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ยโต ยีศุสฺตํ กถิตวานฺ เร อปวิตฺรภูต, อสฺมานฺนราทฺ พหิรฺนิรฺคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","อถ ส ตํ ปฺฤษฺฏวานฺ กินฺเต นาม? เตน ปฺรตฺยุกฺตํ วยมเนเก 'สฺมสฺตโต'สฺมนฺนาม พาหินีฯ ");
INSERT INTO santha_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ตโตสฺมานฺ เทศานฺน เปฺรษเยติ เต ตํ ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ตทานีํ ปรฺวฺวตํ นิกษา พฺฤหนฺ วราหวฺรชศฺจรนฺนาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ตสฺมาทฺ ภูตา วินเยน ชคทุ:, อมุํ วราหวฺรชมฺ อาศฺรยิตุมฺ อสฺมานฺ ปฺรหิณุฯ ");
INSERT INTO santha_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ยีศุนานุชฺญาตาเสฺต'ปวิตฺรภูตา พหิรฺนิรฺยาย วราหวฺรชํ ปฺราวิศนฺ ตต: สรฺเวฺว วราหา วสฺตุตสฺตุ ปฺราโยทฺวิสหสฺรสํงฺขฺยกา: กฏเกน มหาชวาทฺ ธาวนฺต: สินฺเธา ปฺราณานฺ ชหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ตสฺมาทฺ วราหปาลกา: ปลายมานา: ปุเร คฺราเม จ ตทฺวารฺตฺตํ กถยาญฺจกฺรุ:ฯ ตทา โลกา ฆฏิตํ ตตฺการฺยฺยํ ทฺรษฺฏุํ พหิรฺชคฺมุ: ");
INSERT INTO santha_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ยีโศ: สนฺนิธึ คตฺวา ตํ ภูตคฺรสฺตมฺ อรฺถาทฺ พาหินีภูตคฺรสฺตํ นรํ สวสฺตฺรํ สเจตนํ สมุปวิษฺฏญฺจ ทฺฤृษฺฏฺวา พิภฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ตโต ทฺฤษฺฏตตฺการฺยฺยโลกาสฺตสฺย ภูตคฺรสฺตนรสฺย วราหวฺรชสฺยาปิ ตำ ธฏนำ วรฺณยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ตตเสฺต สฺวสีมาโต พหิรฺคนฺตุํ ยีศุํ วิเนตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","อถ ตสฺย เนากาโรหณกาเล ส ภูตมุกฺโต นา ยีศุนา สห สฺถาตุํ ปฺรารฺถยเต; ");
INSERT INTO santha_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","กินฺตุ ส ตมนนุมตฺย กถิตวานฺ ตฺวํ นิชาตฺมียานำ สมีปํ คฺฤหญฺจ คจฺฉ ปฺรภุสฺตฺวยิ กฺฤปำ กฺฤตฺวา ยานิ กรฺมฺมาณิ กฺฤตวานฺ ตานิ ตานฺ ชฺญาปยฯ ");
INSERT INTO santha_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","อต: ส ปฺรสฺถาย ยีศุนา กฺฤตํ ตตฺสรฺวฺวาศฺจรฺยฺยํ กรฺมฺม ทิกาปลิเทเศ ปฺรจารยิตุํ ปฺรารพฺธวานฺ ตต: สรฺเวฺว โลกา อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","อนนฺตรํ ยีเศา นาวา ปุนรนฺยปาร อุตฺตีรฺเณ สินฺธุตเฏ จ ติษฺฐติ สติ ตตฺสมีเป พหุโลกานำ สมาคโม'ภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","อปรํ ยายีรฺ นามฺนา กศฺจิทฺ ภชนคฺฤหสฺยาธิป อาคตฺย ตํ ทฺฤษฺไฏฺวว จรณโย: ปติตฺวา พหุ นิเวทฺย กถิตวานฺ; ");
INSERT INTO santha_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","มม กนฺยา มฺฤตปฺรายาภูทฺ อโต ภวาเนตฺย ตทาโรคฺยาย ตสฺยา คาเตฺร หสฺตมฺ อรฺปยตุ เตไนว สา ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ตทา ยีศุเสฺตน สห จลิต: กินฺตุ ตตฺปศฺจาทฺ พหุโลกาศฺจลิตฺวา ตาทฺคาเตฺร ปติตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","อถ ทฺวาทศวรฺษาณิ ปฺรทรโรเคณ ");
INSERT INTO santha_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ศีรฺณา จิกิตฺสกานำ นานาจิกิตฺสาภิศฺจ ทุ:ขํ ภุกฺตวตี จ สรฺวฺวสฺวํ วฺยยิตฺวาปิ นาโรคฺยํ ปฺราปฺตา จ ปุนรปิ ปีฑิตาสีจฺจ ");
INSERT INTO santha_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ยา สฺตฺรี สา ยีโศ รฺวารฺตฺตำ ปฺราปฺย มนสากถยตฺ ยทฺยหํ ตสฺย วสฺตฺรมาตฺร สฺปฺรษฺฏุํ ลเภยํ ตทา โรคหีนา ภวิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","อโตเหโต: สา โลการณฺยมเธฺย ตตฺปศฺจาทาคตฺย ตสฺย วสฺตฺรํ ปสฺปรฺศฯ ");
INSERT INTO santha_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","เตไนว ตตฺกฺษณํ ตสฺยา รกฺตโสฺรต: ศุษฺกํ สฺวยํ ตสฺมาทฺ โรคานฺมุกฺตา อิตฺยปิ เทเห'นุภูตาฯ ");
INSERT INTO santha_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","อถ สฺวสฺมาตฺ ศกฺติ รฺนิรฺคตา ยีศุเรตนฺมนสา ชฺญาตฺวา โลกนิวหํ ปฺรติ มุขํ วฺยาวฺฤตฺย ปฺฤษฺฏวานฺ เกน มทฺวสฺตฺรํ สฺปฺฤษฺฏํ? ");
INSERT INTO santha_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ตตสฺตสฺย ศิษฺยา อูจุ: ภวโต วปุษิ โลกา: สํฆรฺษนฺติ ตทฺ ทฺฤษฺฏฺวา เกน มทฺวสฺตฺรํ สฺปฺฤษฺฏมิติ กุต: กถยติ? ");
INSERT INTO santha_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","กินฺตุ เกน ตตฺ กรฺมฺม กฺฤตํ ตทฺ ทฺรษฺฏุํ ยีศุศฺจตุรฺทิโศ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ตต: สา สฺตฺรี ภีตา กมฺปิตา จ สตี สฺวสฺยา รุกฺปฺรติกฺริยา ชาเตติ ชฺญาตฺวาคตฺย ตตฺสมฺมุเข ปติตฺวา สรฺวฺววฺฤตฺตานฺตํ สตฺยํ ตไสฺม กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ตทานีํ ยีศุสฺตำ คทิตวานฺ, เห กเนฺย ตว ปฺรตีติสฺตฺวามฺ อโรคามกโรตฺ ตฺวํ เกฺษเมณ วฺรช สฺวโรคานฺมุกฺตา จ ติษฺฐฯ ");
INSERT INTO santha_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","อิติวากฺยวทนกาเล ภชนคฺฤหาธิปสฺย นิเวศนาลฺ โลกา เอตฺยาธิปํ พภาษิเร ตว กนฺยา มฺฤตา ตสฺมาทฺ คุรุํ ปุน: กุต: กฺลิศฺนาสิ? ");
INSERT INTO santha_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","กินฺตุ ยีศุสฺตทฺ วากฺยํ ศฺรุไตฺวว ภชนคฺฤหาธิปํ คทิตวานฺ มา ไภษี: เกวลํ วิศฺวาสิหิฯ ");
INSERT INTO santha_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","อถ ปิตโร ยากูพฺ ตทฺภฺราตา โยหนฺ จ เอตานฺ วินา กมปิ สฺวปศฺจาทฺ ยาตุํ นานฺวมนฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ตสฺย ภชนคฺฤหาธิปสฺย นิเวศนสมีปมฺ อาคตฺย กลหํ พหุโรทนํ วิลาปญฺจ กุรฺวฺวโต โลกานฺ ททรฺศฯ ");
INSERT INTO santha_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ตสฺมานฺ นิเวศนํ ปฺรวิศฺย โปฺรกฺตวานฺ ยูยํ กุต อิตฺถํ กลหํ โรทนญฺจ กุรุถ? กนฺยา น มฺฤตา นิทฺราติฯ ");
INSERT INTO santha_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ตสฺมาตฺเต ตมุปชหสุ: กินฺตุ ยีศุ: สรฺวฺวาน พหิษฺกฺฤตฺย กนฺยายา: ปิตเรา สฺวสงฺคินศฺจ คฺฤหีตฺวา ยตฺร กนฺยาสีตฺ ตตฺ สฺถานํ ปฺรวิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","อถ ส ตสฺยา: กนฺยายา หเสฺตา ธฺฤตฺวา ตำ พภาเษ ฏาลีถา กูมี, อรฺถโต เห กเนฺย ตฺวมุตฺติษฺฐ อิตฺยาชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ตุไนว ตตฺกฺษณํ สา ทฺวาทศวรฺษวยสฺกา กนฺยา โปตฺถาย จลิตุมาเรเภ, อิต: สรฺเวฺว มหาวิสฺมยํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ตต เอตไสฺย กิญฺจิตฺ ขาทฺยํ ทตฺเตติ กถยิตฺวา เอตตฺกรฺมฺม กมปิ น ชฺญาปยเตติ ทฺฤฒมาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","อนนฺตรํ ส ตตฺสฺถานาตฺ ปฺรสฺถาย สฺวปฺรเทศมาคต: ศิษฺยาศฺจ ตตฺปศฺจาทฺ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","อถ วิศฺรามวาเร สติ ส ภชนคฺฤเห อุปเทษฺฏุมารพฺธวานฺ ตโต'เนเก โลกาสฺตตฺกถำ ศฺรุตฺวา วิสฺมิตฺย ชคทุ:, อสฺย มนุชสฺย อีทฺฤศี อาศฺจรฺยฺยกฺริยา กสฺมาชฺ ชาตา? ตถา สฺวกราภฺยามฺ อิตฺถมทฺภุตํ กรฺมฺม กรฺตฺตาुมฺ เอตไสฺม กถํ ชฺญานํ ทตฺตมฺ? ");
INSERT INTO santha_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","กิมยํ มริยม: ปุตฺรสฺตชฺญา โน? กิมยํ ยากูพฺ-โยสิ-ยิหุทา-ศิโมนำ ภฺราตา โน? อสฺย ภคินฺย: กิมิหาสฺมาภิ: สห โน? อิตฺถํ เต ตทรฺเถ ปฺรตฺยูหํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ตทา ยีศุเสฺตโภฺย'กถยตฺ สฺวเทศํ สฺวกุฏุมฺพานฺ สฺวปริชนำศฺจ วินา กุตฺราปิ ภวิษฺยทฺวาที อสตฺกฺฤโต น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","อปรญฺจ เตษามปฺรตฺยยาตฺ ส วิสฺมิต: กิยตำ โรคิณำ วปุ:ษุ หสฺตมฺ อรฺปยิตฺวา เกวลํ เตษามาโรคฺยกรณาทฺ อนฺยตฺ กิมปิ จิตฺรการฺยฺยํ กรฺตฺตำ น ศกฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","อถ ส จตุรฺทิกฺสฺถ คฺรามานฺ ภฺรมิตฺวา อุปทิษฺฏวานฺ ");
INSERT INTO santha_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ทฺวาทศศิษฺยานฺ อาหูย อเมธฺยภูตานฺ วศีกรฺตฺตำ ศกฺตึ ทตฺตฺวา เตษำ เทฺวา เทฺวา ชโน เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ปุนริตฺยาทิศทฺ ยูยมฺ เอไกกำ ยษฺฏึ วินา วสฺตฺรสํปุฏ: ปูป: กฏิพนฺเธ ตามฺรขณฺฑญฺจ เอษำ กิมปิ มา คฺรหฺลีต, ");
INSERT INTO santha_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","มารฺคยาตฺราไย ปาเทษูปานเหา ทตฺตฺวา เทฺว อุตฺตรีเย มา ปริธทฺวฺวํฯ ");
INSERT INTO santha_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","อปรมปฺยุกฺตํ เตน ยูยํ ยสฺยำ ปุรฺยฺยำ ยสฺย นิเวศนํ ปฺรเวกฺษฺยถ ตำ ปุรีํ ยาวนฺน ตฺยกฺษฺยถ ตาวตฺ ตนฺนิเวศเน สฺถาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ตตฺร ยทิ เกปิ ยุษฺมากมาติถฺยํ น วิทธติ ยุษฺมากํ กถาศฺจ น ศฺฤณฺวนฺติ ตรฺหิ ตตฺสฺถานาตฺ ปฺรสฺถานสมเย เตษำ วิรุทฺธํ สากฺษฺยํ ทาตุํ สฺวปาทานาสฺผาลฺย รช: สมฺปาตยต; อหํ ยุษฺมานฺ ยถารฺถํ วจฺมิ วิจารทิเน ตนฺนครสฺยาวสฺถาต: สิโทมาโมรโย รฺนครโยรวสฺถา สหฺยตรา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","อถ เต คตฺวา โลกานำ มน:ปราวรฺตฺตนี: กถา ปฺรจาริตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","เอวมเนกานฺ ภูตำศฺจ ตฺยาชิตวนฺตสฺตถา ไตเลน มรฺทฺทยิตฺวา พหูนฺ ชนานโรคานการฺษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","อิตฺถํ ตสฺย สุขฺยาติศฺจตุรฺทิโศ วฺยาปฺตา ตทา เหโรทฺ ราชา ตนฺนิศมฺย กถิตวานฺ, โยหนฺ มชฺชก: ศฺมศานาทฺ อุตฺถิต อโตเหโตเสฺตน สรฺวฺวา เอตา อทฺภุตกฺริยา: ปฺรกาศนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","อเนฺย'กถยนฺ อยมฺ เอลิย:, เกปิ กถิตวนฺต เอษ ภวิษฺยทฺวาที ยทฺวา ภวิษฺยทฺวาทินำ สทฺฤศ เอโกยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","กินฺตุ เหโรทฺ อิตฺยากรฺณฺย ภาษิตวานฺ ยสฺยาหํ ศิรศฺฉินฺนวานฺ ส เอว โยหนยํ ส ศฺมศานาทุทติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ปูรฺวฺวํ สฺวภฺราตุ: ผิลิปสฺย ปตฺนฺยา อุทฺวาหํ กฺฤตวนฺตํ เหโรทํ โยหนวาทีตฺ สฺวภาตฺฤวธู รฺน วิวาหฺยาฯ ");
INSERT INTO santha_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","อต: การณาตฺ เหโรทฺ โลกํ ปฺรหิตฺย โยหนํ ธฺฤตฺวา พนฺธนาลเย พทฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","เหโรทิยา ตไสฺม โยหเน ปฺรกุปฺย ตํ หนฺตุมฺ ไอจฺฉตฺ กินฺตุ น ศกฺตา, ");
INSERT INTO santha_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ยสฺมาทฺ เหโรทฺ ตํ ธารฺมฺมิกํ สตฺปุรุษญฺจ ชฺญาตฺวา สมฺมนฺย รกฺษิตวานฺ; ตตฺกถำ ศฺรุตฺวา ตทนุสาเรณ พหูนิ กรฺมฺมาณิ กฺฤตวานฺ หฺฤษฺฏมนาสฺตทุปเทศํ ศฺรุตวำศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","กินฺตุ เหโรทฺ ยทา สฺวชนฺมทิเน ปฺรธานโลเกภฺย: เสนานีภฺยศฺจ คาลีลฺปฺรเทศียเศฺรษฺฐโลเกภฺยศฺจ ราเตฺรา โภชฺยเมกํ กฺฤตวานฺ ");
INSERT INTO santha_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ตสฺมินฺ ศุภทิเน เหโรทิยายา: กนฺยา สเมตฺย เตษำ สมกฺษํ สํนฺฤตฺย เหโรทเสฺตน สโหปวิษฺฏานาญฺจ โตษมชีชนตฺ ตตา นฺฤป: กนฺยามาห สฺม มตฺโต ยทฺ ยาจเส ตเทว ตุภฺยํ ทาเสฺยฯ ");
INSERT INTO santha_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ศปถํ กฺฤตฺวากถยตฺ เจทฺ ราชฺยารฺทฺธมปิ ยาจเส ตทปิ ตุภฺยํ ทาเสฺยฯ ");
INSERT INTO santha_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ตต: สา พหิ รฺคตฺวา สฺวมาตรํ ปปฺรจฺฉ กิมหํ ยาจิเษฺย? ตทา สากถยตฺ โยหโน มชฺชกสฺย ศิร:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","อถ ตูรฺณํ ภูปสมีปมฺ เอตฺย ยาจมานาวทตฺ กฺษเณสฺมินฺ โยหโน มชฺชกสฺย ศิร: ปาเตฺร นิธาย เทหิ, เอตทฺ ยาเจ'หํฯ ");
INSERT INTO santha_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ตสฺมาตฺ ภูโป'ติทุ:ขิต:, ตถาปิ สฺวศปถสฺย สหโภชินาญฺจานุโรธาตฺ ตทนงฺคีกรฺตฺตุํ น ศกฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ตตฺกฺษณํ ราชา ฆาตกํ เปฺรษฺย ตสฺย ศิร อาเนตุมาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ตต: ส การาคารํ คตฺวา ตจฺฉิรศฺฉิตฺวา ปาเตฺร นิธายานีย ตไสฺย กนฺยาไย ทตฺตวานฺ กนฺยา จ สฺวมาเตฺร ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","อนนตรํ โยหน: ศิษฺยาสฺตทฺวารฺตฺตำ ปฺราปฺยาคตฺย ตสฺย กุณปํ ศฺมศาเน'สฺถาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","อถ เปฺรษิตา ยีโศ: สนฺนิเธา มิลิตา ยทฺ ยจฺ จกฺรุ: ศิกฺษยามาสุศฺจ ตตฺสรฺวฺววารฺตฺตาสฺตไสฺม กถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ส ตานุวาจ ยูยํ วิชนสฺถานํ คตฺวา วิศฺรามฺยต ยตสฺตตฺสนฺนิเธา พหุโลกานำ สมาคมาตฺ เต โภกฺตุํ นาวกาศํ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ตตเสฺต นาวา วิชนสฺถานํ คุปฺตํ คคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ตโต โลกนิวหเสฺตษำ สฺถานานฺตรยานํ ททรฺศ, อเนเก ตํ ปริจิตฺย นานาปุเรภฺย: ปไทรฺวฺรชิตฺวา ชเวน ไตษามเคฺร ยีโศ: สมีป อุปตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ตทา ยีศุ รฺนาโว พหิรฺคตฺย โลการณฺยานีํ ทฺฤษฺฏฺวา เตษุ กรุณำ กฺฤตวานฺ ยตเสฺต'รกฺษกเมษา อิวาสนฺ ตทา ส ตาน นานาปฺรสงฺคานฺ อุปทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","อถ ทิวานฺเต สติ ศิษฺยา เอตฺย ยีศุมูจิเร, อิทํ วิชนสฺถานํ ทินญฺจาวสนฺนํฯ ");
INSERT INTO santha_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","โลกานำ กิมปิ ขาทฺยํ นาสฺติ, อตศฺจตุรฺทิกฺษุ คฺรามานฺ คนฺตุํ โภชฺยทฺรวฺยาณิ เกฺรตุญฺจ ภวานฺ ตานฺ วิสฺฤชตุฯ ");
INSERT INTO santha_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ตทา ส ตานุวาจ ยูยเมว ตานฺ โภชยต; ตตเสฺต ชคทุ รฺวยํ คตฺวา ทฺวิศตสํขฺยไก รฺมุทฺราปาไท: ปูปานฺ กฺรีตฺวา กึ ตานฺ โภชยิษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ตทา ส ตานฺ ปฺฤษฺฐวานฺ ยุษฺมากํ สนฺนิเธา กติ ปูปา อาสเต? คตฺวา ปศฺยต; ตตเสฺต ทฺฤษฺฏฺวา ตมวทนฺ ปญฺจ ปูปา เทฺวา มตฺเสฺยา จ สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ตทา ส โลกานฺ ศโสฺปปริ ปํกฺติภิรุปเวศยิตุมฺ อาทิษฺฏวานฺ, ");
INSERT INTO santha_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ตตเสฺต ศตํ ศตํ ชนา: ปญฺจาศตฺ ปญฺจาศชฺชนาศฺจ ปํกฺติภิ รฺภุวิ สมุปวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","อถ ส ตานฺ ปญฺจปูปานฺ มตฺสฺยทฺวยญฺจ ธฺฤตฺวา สฺวรฺคํ ปศฺยนฺ อีศฺวรคุณานฺ อนฺวกีรฺตฺตยตฺ ตานฺ ปูปานฺ ภํกฺตฺวา โลเกภฺย: ปริเวษยิตุํ ศิเษฺยโภฺย ทตฺตวานฺ ทฺวา มตฺเสฺยา จ วิภชฺย สรฺเวฺวโภฺย ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ตต: สรฺเวฺว ภุกฺตฺวาตฺฤปฺยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","อนนฺตรํ ศิษฺยา อวศิษฺไฏ: ปูไป รฺมตฺไสฺยศฺจ ปูรฺณานฺ ทฺวทศ ฑลฺลกานฺ ชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","เต โภกฺตาร: ปฺราย: ปญฺจ สหสฺราณิ ปุรุษา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","อถ ส โลกานฺ วิสฺฤชนฺเนว นาวมาโรฒุํ สฺวสฺมาทเคฺร ปาเร ไพตฺไสทาปุรํ ยาตุญฺจ ศฺษฺยิाนฺ วาฒมาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ตทา ส สรฺวฺวานฺ วิสฺฤชฺย ปฺรารฺถยิตุํ ปรฺวฺวตํ คต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ตต: สนฺธฺยายำ สตฺยำ เนา: สินฺธุมธฺย อุปสฺถิตา กินฺตุ ส เอกากี สฺถเล สฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","อถ สมฺมุขวาตวหนาตฺ ศิษฺยา นาวํ วาหยิตฺวา ปริศฺรานฺตา อิติ ชฺญาตฺวา ส นิศาจตุรฺถยาเม สินฺธูปริ ปทฺภฺยำ วฺรชนฺ เตษำ สมีปเมตฺย เตษามเคฺร ยาตุมฺ อุทฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","กินฺตุ ศิษฺยา: สินฺธูปริ ตํ วฺรชนฺตํ ทฺฤษฺฏฺวา ภูตมนุมาย รุรุวุ:, ");
INSERT INTO santha_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ยต: สรฺเวฺว ตํ ทฺฤษฺฏฺวา วฺยากุลิตา:ฯ อเตอว ยีศุสฺตตฺกฺษณํ ไต: สหาลปฺย กถิตวานฺ, สุสฺถิรา ภูต, อยมหํ มา ไภษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","อถ เนากามารุหฺย ตสฺมินฺ เตษำ สนฺนิธึ คเต วาโต นิวฺฤตฺต:; ตสฺมาตฺเต มน:สุ วิสฺมิตา อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ยตเสฺต มนสำ กาฐินฺยาตฺ ตตฺ ปูปียมฺ อาศฺจรฺยฺยํ กรฺมฺม น วิวิกฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","อถ เต ปารํ คตฺวา คิเนษรตฺปฺรเทศเมตฺย ตฏ อุปสฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","เตษุ เนากาโต พหิรฺคเตษุ ตตฺปฺรเทศียา โลกาสฺตํ ปริจิตฺย ");
INSERT INTO santha_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","จตุรฺทิกฺษุ ธาวนฺโต ยตฺร ยตฺร โรคิโณ นรา อาสนฺ ตานฺ สรฺวฺวาน ขโฏฺวปริ นิธาย ยตฺร กุตฺรจิตฺ ตทฺวารฺตฺตำ ปฺราปุ: ตตฺ สฺถานมฺ อาเนตุมฺ อาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ตถา ยตฺร ยตฺร คฺราเม ยตฺร ยตฺร ปุเร ยตฺร ยตฺร ปลฺลฺยาญฺจ เตน ปฺรเวศ: กฺฤตสฺตทฺวรฺตฺมมเธฺย โลกา: ปีฑิตานฺ สฺถาปยิตฺวา ตสฺย เจลคฺรนฺถิมาตฺรํ สฺปฺรษฺฏุมฺ เตษามรฺเถ ตทนุชฺญำ ปฺรารฺถยนฺต: ยาวนฺโต โลกา: ปสฺปฺฤศุสฺตาวนฺต เอว คทานฺมุกฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","อนนฺตรํ ยิรูศาลม อาคตา: ผิรูศิโน'ธฺยาปกาศฺจ ยีโศ: สมีปมฺ อาคตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","เต ตสฺย กิยต: ศิษฺยานฺ อศุจิกไรรรฺถาท อปฺรกฺษาลิตหไสฺต รฺภุญฺชโต ทฺฤษฺฏฺวา ตานทูษยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ยต: ผิรูศิน: สรฺวฺวยิหูทียาศฺจ ปฺราจำ ปรมฺปราคตวากฺยํ สมฺมนฺย ปฺรตเลน หสฺตานฺ อปฺรกฺษาลฺย น ภุญฺชเตฯ ");
INSERT INTO santha_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","อาปนาทาคตฺย มชฺชนํ วินา น ขาทนฺติ; ตถา ปานปาตฺราณำ ชลปาตฺราณำ ปิตฺตลปาตฺราณามฺ อาสนานาญฺจ ชเล มชฺชนมฺ อิตฺยาทโยเนฺยปิ พหวเสฺตษามาจารา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","เต ผิรูศิโน'ธฺยาปกาศฺจ ยีศุํ ปปฺรจฺฉุ:, ตว ศิษฺยา: ปฺราจำ ปรมฺปราคตวากฺยานุสาเรณ นาจรนฺโต'ปฺรกฺษาลิตกไร: กุโต ภุชํเต? ");
INSERT INTO santha_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ตต: ส ปฺรตฺยุวาจ กปฏิโน ยุษฺมานฺ อุทฺทิศฺย ยิศยิยภวิษฺยทฺวาที ยุกฺตมวาทีตฺฯ ยถา สฺวกีไยรธไรเรเต สมฺมนฺยนเต สไทว มำฯ กินฺตุ มตฺโต วิปฺรกรฺเษ สนฺติ เตษำ มนำสิ จฯ ");
INSERT INTO santha_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ศิกฺษยนฺโต พิธีนฺ นฺนาชฺญา ภชนฺเต มำ มุไธว เตฯ ");
INSERT INTO santha_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ยูยํ ชลปาตฺรปานปาตฺราทีนิ มชฺชยนฺโต มนุชปรมฺปราคตวากฺยํ รกฺษถ กินฺตุ อีศฺวราชฺญำ ลํฆเธฺว; อปรา อีทฺฤโศฺยเนกา: กฺริยา อปิ กุรุเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","อนฺยญฺจากถยตฺ ยูยํ สฺวปรมฺปราคตวากฺยสฺย รกฺษารฺถํ สฺปษฺฏรูเปณ อีศฺวราชฺญำ โลปยถฯ ");
INSERT INTO santha_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ยโต มูสาทฺวารา โปฺรกฺตมสฺติ สฺวปิตเรา สมฺมนฺยธฺวํ ยสฺตุ มาตรํ ปิตรํ วา ทุรฺวฺวากฺยํ วกฺติ ส นิตานฺตํ หนฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","กินฺตุ มทีเยน เยน ทฺรเวฺยณ ตโวปกาโรภวตฺ ตตฺ กรฺพฺพาณมรฺถาทฺ อีศฺวราย นิเวทิตมฺ อิทํ วากฺยํ ยทิ โกปิ ปิตรํ มาตรํ วา วกฺติ ");
INSERT INTO santha_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ตรฺหิ ยูยํ มาตุ: ปิตุ โรฺวปการํ กรฺตฺตำ ตํ วารยถฯ ");
INSERT INTO santha_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","อิตฺถํ สฺวปฺรจาริตปรมฺปราคตวาเกฺยน ยูยมฺ อีศฺวราชฺญำ มุธา วิธทฺเวฺว, อีทฺฤศานฺยนฺยานฺยเนกานิ กรฺมฺมาณิ กุรุเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","อถ ส โลกานาหูย พภาเษ ยูยํ สรฺเวฺว มทฺวากฺยํ ศฺฤณุต พุธฺยธฺวญฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","พาหฺยาทนฺตรํ ปฺรวิศฺย นรมเมธฺยํ กรฺตฺตำ ศกฺโนติ อีทฺฤศํ กิมปิ วสฺตุ นาสฺติ, วรมฺ อนฺตราทฺ พหิรฺคตํ ยทฺวสฺตุ ตนฺมนุชมฺ อเมธฺยํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ยสฺย โศฺรตุํ โศฺรเตฺร สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ตต: ส โลกานฺ หิตฺวา คฺฤหมธฺยํ ปฺรวิษฺฏสฺตทา ศิษฺยาสฺตทฺฤษฺฏานฺตวากฺยารฺถํ ปปฺรจฺฉุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ตสฺมาตฺ ส ตานฺ ชคาท ยูยมปิ กิเมตาทฺฤคโพธา:? กิมปิ ทฺรวฺยํ พาหฺยาทนฺตรํ ปฺรวิศฺย นรมเมธฺยํ กรฺตฺตำ น ศกฺโนติ กถามิมำ กึ น พุธฺยเธฺว? ");
INSERT INTO santha_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ตตฺ ตทนฺตรฺน ปฺรวิศติ กินฺตุ กุกฺษิมธฺยํ ปฺรวิศติ เศเษ สรฺวฺวภุกฺตวสฺตุคฺราหิณิ พหิรฺเทเศ นิรฺยาติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","อปรมปฺยวาทีทฺ ยนฺนรานฺนิเรติ ตเทว นรมเมธฺยํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ยโต'นฺตราทฺ อรฺถานฺ มานวานำ มโนภฺย: กุจินฺตา ปรสฺตฺรีเวศฺยาคมนํ ");
INSERT INTO santha_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","นรวธศฺเจารฺยฺยํ โลโภ ทุษฺฏตา ปฺรวญฺจนา กามุกตา กุทฺฤษฺฏิรีศฺวรนินฺทา ครฺวฺวสฺตม อิตฺยาทีนิ นิรฺคจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","เอตานิ สรฺวฺวาณิ ทุริตานฺยนฺตราเทตฺย นรมเมธฺยํ กุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","อถ ส อุตฺถาย ตตฺสฺถานาตฺ โสรสีโทนฺปุรปฺรเทศํ ชคาม ตตฺร กิมปิ นิเวศนํ ปฺรวิศฺย สรฺไวฺวรชฺญาต: สฺถาตุํ มติญฺจเกฺร กินฺตุ คุปฺต: สฺถาตุํ น ศศากฯ ");
INSERT INTO santha_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ยต: สุรไผนิกีเทศียยูนานีวํโศทฺภวสฺตฺริยา: กนฺยา ภูตคฺรสฺตาสีตฺฯ สา สฺตฺรี ตทฺวารฺตฺตำ ปฺราปฺย ตตฺสมีปมาคตฺย ตจฺจรณโย: ปติตฺวา ");
INSERT INTO santha_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","สฺวกนฺยาโต ภูตํ นิรากรฺตฺตำ ตสฺมินฺ วินยํ กฺฤตวตีฯ ");
INSERT INTO santha_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","กินฺตุ ยีศุสฺตามวทตฺ ปฺรถมํ พาลกาสฺตฺฤปฺยนฺตุ ยโต พาลกานำ ขาทฺยํ คฺฤหีตฺวา กุกฺกุเรโภฺย นิกฺเษโป'นุจิต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ตทา สา สฺตฺรี ตมวาทีตฺ โภ: ปฺรโภ ตตฺ สตฺยํ ตถาปิ มญฺจาธ:สฺถา: กุกฺกุรา พาลานำ กรปติตานิ ขาทฺยขณฺฑานิ ขาทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ตต: โส'กถยทฺ เอตตฺกถาเหโต: สกุศลา ยาหิ ตว กนฺยำ ตฺยกฺตฺวา ภูโต คต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","อถ สา สฺตฺรี คฺฤหํ คตฺวา กนฺยำ ภูตตฺยกฺตำ ศยฺยาสฺถิตำ ททรฺศฯ ");
INSERT INTO santha_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ปุนศฺจ ส โสรสีโทนฺปุรปฺรเทศาตฺ ปฺรสฺถาย ทิกาปลิเทศสฺย ปฺรานฺตรภาเคน คาลีลฺชลเธ: สมีปํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ตทา โลไกเรกํ พธิรํ กทฺวทญฺจ นรํ ตนฺนิกฏมานีย ตสฺย คาเตฺร หสฺตมรฺปยิตุํ วินย: กฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ตโต ยีศุ โรฺลการณฺยาตฺ ตํ นิรฺชนมานีย ตสฺย กรฺณโยงฺคุลี รฺทเทา นิษฺฐีวํ ทตฺตฺวา จ ตชฺชิหฺวำ ปสฺปรฺศฯ ");
INSERT INTO santha_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","อนนฺตรํ สฺวรฺคํ นิรีกฺษฺย ทีรฺฆํ นิศฺวสฺย ตมวทตฺ อิตผต: อรฺถานฺ มุกฺโต ภูยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ตตสฺตตฺกฺษณํ ตสฺย กรฺเณา มุกฺเตา ชิหฺวายาศฺจ ชาฑฺยาปคมาตฺ ส สุสฺปษฺฏวากฺยมกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","อถ ส ตานฺ วาฒมิตฺยาทิเทศ ยูยมิมำ กถำ กไสฺมจิทปิ มา กถยต, กินฺตุ ส ยติ นฺยเษธตฺ เต ตติ พาหุเลฺยน ปฺราจารยนฺ; ");
INSERT INTO santha_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","เต'ติจมตฺกฺฤตฺย ปรสฺปรํ กถยามาสุ: ส พธิราย ศฺรวณศกฺตึ มูกาย จ กถนศกฺตึ ทตฺตฺวา สรฺวฺวํ กรฺมฺโมตฺตมรูเปณ จการฯ ");
INSERT INTO santha_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ตทา ตตฺสมีปํ พหโว โลกา อายาตา อตเสฺตษำ โภชฺยทฺรวฺยาภาวาทฺ ยีศุ: ศิษฺยานาหูย ชคาท,ฯ ");
INSERT INTO santha_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","โลกนิวเห มม กฺฤปา ชายเต เต ทินตฺรยํ มยา สารฺทฺธํ สนฺติ เตษำ โภชฺยํ กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","เตษำ มเธฺย'เนเก ทูราทฺ อาคตา:, อภุกฺเตษุ เตษุ มยา สฺวคฺฤหมภิปฺรหิเตษุ เต ปถิ กฺลมิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ศิษฺยา อวาทิษุ:, เอตาวโต โลกานฺ ตรฺปยิตุมฺ อตฺร ปฺรนฺตเร ปูปานฺ ปฺราปฺตุํ เกน ศกฺยเต? ");
INSERT INTO santha_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ตต: ส ตานฺ ปปฺรจฺฉ ยุษฺมากํ กติ ปูปา: สนฺติ? เต'กถยนฺ สปฺตฯ ");
INSERT INTO santha_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ตต: ส ตาโลฺลกานฺ ภุวิ สมุปเวษฺฏุมฺ อาทิศฺย ตานฺ สปฺต ปูปานฺ ธฺฤตฺวา อีศฺวรคุณานฺ อนุกีรฺตฺตยามาส, ภํกฺตฺวา ปริเวษยิตุํ ศิษฺยานฺ ปฺรติ ทเทา, ตตเสฺต โลเกภฺย: ปริเวษยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ตถา เตษำ สมีเป เย กฺษุทฺรมตฺสฺยา อาสนฺ ตานปฺยาทาย อีศฺวรคุณานฺ สํกีรฺตฺย ปริเวษยิตุมฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ตโต โลกา ภุกฺตฺวา ตฺฤปฺตึ คตา อวศิษฺฏขาไทฺย: ปูรฺณา: สปฺตฑลฺลกา คฺฤหีตาศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","เอเต โภกฺตาร: ปฺรายศฺจตุ: สหสฺรปุรุษา อาสนฺ ตต: ส ตานฺ วิสสรฺชฯ ");
INSERT INTO santha_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","อถ ส ศิษฺย: สห นาวมารุหฺย ทลฺมานูถาสีมามาคต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ตต: ปรํ ผิรูศิน อาคตฺย เตน สห วิวทมานาสฺตสฺย ปรีกฺษารฺถมฺ อากาศียจิหฺนํ ทฺรษฺฏุํ ยาจิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ตทา โส'นฺตรฺทีรฺฆํ นิศฺวสฺยากถยตฺ, เอเต วิทฺยมานนรา: กุตศฺจินฺหํ มฺฤคยนฺเต? ยุษฺมานหํ ยถารฺถํ พฺรวีมิ โลกาเนตานฺ กิมปิ จิหฺนํ น ทรฺศยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","อถ ตานฺ หิตฺวา ปุน รฺนาวมฺ อารุหฺย ปารมคาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","เอตรฺหิ ศิไษฺย: ปูเปษุ วิสฺมฺฤเตษุ นาวิ เตษำ สนฺนิเธา ปูป เอเกอว สฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ตทานีํ ยีศุสฺตานฺ อาทิษฺฏวานฺ ผิรูศินำ เหโรทศฺจ กิณฺวํ ปฺรติ สตรฺกา: สาวธานาศฺจ ภวตฯ ");
INSERT INTO santha_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ตตเสฺต'โนฺยนฺยํ วิเวจนํ กรฺตุมฺ อาเรภิเร, อสฺมากํ สนฺนิเธา ปูโป นาสฺตีติ เหโตริทํ กถยติฯ ");
INSERT INTO santha_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ตทฺ พุทฺวฺวา ยีศุเสฺตโภฺย'กถยตฺ ยุษฺมากํ สฺถาเน ปูปาภาวาตฺ กุต อิตฺถํ วิตรฺกยถ? ยูยํ กิมทฺยาปิ กิมปิ น ชานีถ? โพทฺธุญฺจ น ศกฺนุถ? ยาวททฺย กึ ยุษฺมากํ มนำสิ กฐินานิ สนฺติ? ");
INSERT INTO santha_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","สตฺสุ เนเตฺรษุ กึ น ปศฺยถ? สตฺสุ กรฺเณษุ กึ น ศฺฤณุถ? น สฺมรถ จ? ");
INSERT INTO santha_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ยทาหํ ปญฺจปูปานฺ ปญฺจสหสฺราณำ ปุรุษาณำ มเธฺย ภํกฺตฺวา ทตฺตวานฺ ตทานีํ ยูยมฺ อวศิษฺฏปูไป: ปูรฺณานฺ กติ ฑลฺลกานฺ คฺฤหีตวนฺต:? เต'กถยนฺ ทฺวาทศฑลฺลกานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","อปรญฺจ ยทา จตุ:สหสฺราณำ ปุรุษาณำ มเธฺย ปูปานฺ ภํกฺตฺวาททำ ตทา ยูยมฺ อติริกฺตปูปานำ กติ ฑลฺลกานฺ คฺฤหีตวนฺต:? เต กถยามาสุ: สปฺตฑลฺลกานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ตทา ส กถิตวานฺ ตรฺหิ ยูยมฺ อธุนาปิ กุโต โพทฺวฺวุํ น ศกฺนุถ? ");
INSERT INTO santha_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","อนนฺตรํ ตสฺมินฺ ไพตฺไสทานคเร ปฺราปฺเต โลกา อนฺธเมกํ นรํ ตตฺสมีปมานีย ตํ สฺปฺรษฺฏุํ ตํ ปฺรารฺถยาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ตทา ตสฺยานฺธสฺย กเรา คฺฤหีตฺวา นคราทฺ พหิรฺเทศํ ตํ นีตวานฺ; ตนฺเนเตฺร นิษฺฐีวํ ทตฺตฺวา ตทฺคาเตฺร หสฺตาวรฺปยิตฺวา ตํ ปปฺรจฺฉ, กิมปิ ปศฺยสิ? ");
INSERT INTO santha_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ส เนเตฺร อุนฺมีลฺย ชคาท, วฺฤกฺษวตฺ มนุชานฺ คจฺฉโต นิรีกฺเษฯ ");
INSERT INTO santha_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ตโต ยีศุ: ปุนสฺตสฺย นยนโย รฺหสฺตาวรฺปยิตฺวา ตสฺย เนเตฺร อุนฺมีลยามาส; ตสฺมาตฺ ส สฺวโสฺถ ภูตฺวา สฺปษฺฏรูปํ สรฺวฺวโลกานฺ ททรฺศฯ ");
INSERT INTO santha_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ตต: ปรํ ตฺวํ คฺรามํ มา คจฺฉ คฺรามสฺถํ กมปิ จ กิมปฺยนุกฺตฺวา นิชคฺฤหํ ยาหีตฺยาทิศฺย ยีศุสฺตํ นิชคฺฤหํ ปฺรหิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","อนนฺตรํ ศิไษฺย: สหิโต ยีศุ: ไกสรียาผิลิปิปุรํ ชคาม, ปถิ คจฺฉนฺ ตานปฺฤจฺฉตฺ โก'หมฺ อตฺร โลกา: กึ วทนฺติ? ");
INSERT INTO santha_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","เต ปฺรตฺยูจุ: ตฺวำ โยหนํ มชฺชกํ วทนฺติ กินฺตุ เกปิ เกปิ เอลิยํ วทนฺติ; อปเร เกปิ เกปิ ภวิษฺยทฺวาทินามฺ เอโก ชน อิติ วทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","อถ ส ตานปฺฤจฺฉตฺ กินฺตุ โกหมฺ? อิตฺยตฺร ยูยํ กึ วทถ? ตทา ปิตร: ปฺรตฺยวทตฺ ภวานฺ อภิษิกฺตสฺตฺราตาฯ ");
INSERT INTO santha_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ตต: ส ตานฺ คาฒมาทิศทฺ ยูยํ มม กถา กไสฺมจิทปิ มา กถยตฯ ");
INSERT INTO santha_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","มนุษฺยปุเตฺรณาวศฺยํ พหโว ยาตนา โภกฺตวฺยา: ปฺราจีนโลไก: ปฺรธานยาชไกรธฺยาปไกศฺจ ส นินฺทิต: สนฺ ฆาตยิษฺยเต ตฺฤตียทิเน อุตฺถาสฺยติ จ, ยีศุ: ศิษฺยานุปเทษฺฏุมารภฺย กถามิมำ สฺปษฺฏมาจษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ตสฺมาตฺ ปิตรสฺตสฺย หเสฺตา ธฺฤตฺวา ตํ ตรฺชฺชิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","กินฺตุ ส มุขํ ปราวรฺตฺย ศิษฺยคณํ นิรีกฺษฺย ปิตรํ ตรฺชยิตฺวาวาทีทฺ ทูรีภว วิฆฺนการินฺ อีศฺวรียการฺยฺยาทปิ มนุษฺยการฺยฺยํ ตุภฺยํ โรจตตรำฯ ");
INSERT INTO santha_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","อถ ส โลกานฺ ศิษฺยำศฺจาหูย ชคาท ย: กศฺจินฺ มามนุคนฺตุมฺ อิจฺฉติ ส อาตฺมานํ ทามฺยตุ, สฺวกฺรุศํ คฺฤหีตฺวา มตฺปศฺจาทฺ อายาตุฯ ");
INSERT INTO santha_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ยโต ย: กศฺจิตฺ สฺวปฺราณํ รกฺษิตุมิจฺฉติ ส ตํ หารยิษฺยติ, กินฺตุ ย: กศฺจินฺ มทรฺถํ สุสํวาทารฺถญฺจ ปฺราณํ หารยติ ส ตํ รกฺษิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","อปรญฺจ มนุช: สรฺวฺวํ ชคตฺ ปฺราปฺย ยทิ สฺวปฺราณํ หารยติ ตรฺหิ ตสฺย โก ลาภ:? ");
INSERT INTO santha_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","นร: สฺวปฺราณวินิมเยน กึ ทาตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","เอเตษำ วฺยภิจาริณำ ปาปินาญฺจ โลกานำ สากฺษาทฺ ยทิ โกปิ มำ มตฺกถาญฺจ ลชฺชาสฺปทํ ชานาติ ตรฺหิ มนุชปุโตฺร ยทา ธรฺมฺมทูไต: สห ปิตุ: ปฺรภาเวณาคมิษฺยติ ตทา โสปิ ตํ ลชฺชาสฺปทํ ชฺญาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","อถ ส ตานวาทีตฺ ยุษฺมภฺยมหํ ยถารฺถํ กถยามิ, อีศฺวรราชฺยํ ปรากฺรเมโณปสฺถิตํ น ทฺฤษฺฏฺวา มฺฤตฺยุํ นาสฺวาทิษฺยนฺเต, อตฺร ทณฺฑายมานานำ มเธฺยปิ ตาทฺฤศา โลกา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","อถ ษฑฺทิเนภฺย: ปรํ ยีศุ: ปิตรํ ยากูพํ โยหนญฺจ คฺฤหีตฺวา คิเรรุจฺจสฺย นิรฺชนสฺถานํ คตฺวา เตษำ ปฺรตฺยกฺเษ มูรฺตฺยนฺตรํ ทธารฯ ");
INSERT INTO santha_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ตตสฺตสฺย ปริเธยมฺ อีทฺฤศมฺ อุชฺชฺวลหิมปาณฑรํ ชาตํ ยทฺ ชคติ โกปิ รชโก น ตาทฺฤกฺ ปาณฑรํ กรฺตฺตำ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","อปรญฺจ เอลิโย มูสาศฺจ เตโภฺย ทรฺศนํ ทตฺตฺวา ยีศุนา สห กถนํ กรฺตฺตุมาเรภาเตฯ ");
INSERT INTO santha_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ตทา ปิตโร ยีศุมวาทีตฺ เห คุโร'สฺมากมตฺร สฺถิติรุตฺตมา, ตเตอว วยํ ตฺวตฺกฺฤเต เอกำ มูสากฺฤเต เอกามฺ เอลิยกฺฤเต ไจกำ, เอตาสฺติสฺร: กุฏี รฺนิรฺมฺมามฯ ");
INSERT INTO santha_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","กินฺตุ ส ยทุกฺตวานฺ ตตฺ สฺวยํ น พุพุเธ ตต: สรฺเวฺว พิภยาญฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","เอตรฺหิ ปโยทสฺตานฺ ฉาทยามาส, มมยำ ปฺริย: ปุตฺร: กถาสุ ตสฺย มนำสิ นิเวศยเตติ นโภวาณี ตนฺเมทฺยานฺนิรฺยเยาฯ ");
INSERT INTO santha_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","อถ หฐาตฺเต จตุรฺทิโศ ทฺฤษฺฏฺวา ยีศุํ วินา ไสฺว: สหิตํ กมปิ น ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ตต: ปรํ คิเรรวโรหณกาเล ส ตานฺ คาฒมฺ ทูตฺยาทิเทศ ยาวนฺนรสูโน: ศฺมศานาทุตฺถานํ น ภวติ, ตาวตฺ ทรฺศนสฺยาสฺย วารฺตฺตา ยุษฺมาภิ: กไสฺมจิทปิ น วกฺตวฺยาฯ ");
INSERT INTO santha_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ตทา ศฺมศานาทุตฺถานสฺย โกภิปฺราย อิติ วิจารฺยฺย เต ตทฺวากฺยํ เสฺวษุ โคปายาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","อถ เต ยีศุํ ปปฺรจฺฉุ: ปฺรถมต เอลิเยนาคนฺตวฺยมฺ อิติ วากฺยํ กุต อุปาธฺยายา อาหุ:? ");
INSERT INTO santha_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ตทา ส ปฺรตฺยุวาจ , เอลิย: ปฺรถมเมตฺย สรฺวฺวการฺยฺยาณิ สาธยิษฺยติ; นรปุเตฺร จ ลิปิ รฺยถาเสฺต ตไถว โสปิ พหุทุ:ขํ ปฺราปฺยาวชฺญาสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","กินฺตฺวหํ ยุษฺมานฺ วทามิ , เอลิยารฺเถ ลิปิ รฺยถาเสฺต ตไถว ส เอตฺย ยเยา, โลกา: เสฺวจฺฉานุรูปํ ตมภิวฺยวหรนฺติ สฺมฯ ");
INSERT INTO santha_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","อนนฺตรํ ส ศิษฺยสมีปเมตฺย เตษำ จตุ:ปารฺเศฺว ไต: สห พหุชนานฺ วิวทมานานฺ อธฺยาปกำศฺจ ทฺฤษฺฏวานฺ; ");
INSERT INTO santha_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","กินฺตุ สรฺวฺวโลกาสฺตํ ทฺฤษฺไฏฺวว จมตฺกฺฤตฺย ตทาสนฺนํ ธาวนฺตสฺตํ ปฺรเณมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ตทา ยีศุรธฺยาปกานปฺรากฺษีทฺ เอไต: สห ยูยํ กึ วิวทเธฺว? ");
INSERT INTO santha_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ตโต โลกานำ กศฺจิเทก: ปฺรตฺยวาทีตฺ เห คุโร มม สูนุํ มูกํ ภูตธฺฤตญฺจ ภวทาสนฺนมฺ อานยํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ยทาเสา ภูตสฺตมากฺรมเต ตไทว ปาตสติ ตถา ส เผณายเต, ทนฺไตรฺทนฺตานฺ ฆรฺษติ กฺษีโณ ภวติ จ; ตโต เหโตสฺตํ ภูตํ ตฺยาชยิตุํ ภวจฺฉิษฺยานฺ นิเวทิตวานฺ กินฺตุ เต น เศกุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ตทา ส ตมวาทีตฺ, เร อวิศฺวาสิน: สนฺตานา ยุษฺมาภิ: สห กติ กาลานหํ สฺถาสฺยามิ? อปรานฺ กติ กาลานฺ วา ว อาจารานฺ สหิเษฺย? ตํ มทาสนฺนมานยตฯ ");
INSERT INTO santha_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ตตสฺตตฺสนฺนิธึ ส อานียต กินฺตุ ตํ ทฺฤษฺไฏฺวว ภูโต พาลกํ ธฺฤตวานฺ; ส จ ภูเมา ปติตฺวา เผณายมาโน ลุโลฐฯ ");
INSERT INTO santha_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ตทา ส ตตฺปิตรํ ปปฺรจฺฉ, อเสฺยทฺฤศี ทศา กติ ทินานิ ภูตา? ตต: โสวาทีตฺ พาลฺยกาลาตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ภูโตยํ ตํ นาศยิตุํ พหุวารานฺ วเหฺนา ชเล จ นฺยกฺษิปตฺ กินฺตุ ยทิ ภวาน กิมปิ กรฺตฺตำ ศกฺโนติ ตรฺหิ ทยำ กฺฤตฺวาสฺมานฺ อุปกโรตุฯ ");
INSERT INTO santha_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ตทา ยีศุสฺตมวทตฺ ยทิ ปฺรเตฺยตุํ ศกฺโนษิ ตรฺหิ ปฺรตฺยยิเน ชนาย สรฺวฺวํ สาธฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ตตสฺตตฺกฺษณํ ตทฺพาลกสฺย ปิตา โปฺรจฺไจ รูวนฺ สาศฺรุเนตฺร: โปฺรวาจ, ปฺรโภ ปฺรเตฺยมิ มมาปฺรตฺยยํ ปฺรติกุรุฯ ");
INSERT INTO santha_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","อถ ยีศุ โรฺลกสงฺฆํ ธาวิตฺวายานฺตํ ทฺฤษฺฏฺวา ตมปูตภูตํ ตรฺชยิตฺวา ชคาท, เร พธิร มูก ภูต ตฺวเมตสฺมาทฺ พหิรฺภว ปุน: กทาปิ มาศฺรไยนํ ตฺวามหมฺ อิตฺยาทิศามิฯ ");
INSERT INTO santha_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ตทา ส ภูตศฺจีตฺศพฺทํ กฺฤตฺวา ตมาปีฑฺย พหิรฺชชาม, ตโต พาลโก มฺฤตกลฺโป พภูว ตสฺมาทยํ มฺฤตอิตฺยเนเก กถยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","กินฺตุ กรํ ธฺฤตฺวา ยีศุโนตฺถาปิต: ส อุตฺตเสฺถาฯ ");
INSERT INTO santha_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","อถ ยีเศา คฺฤหํ ปฺรวิษฺเฏ ศิษฺยา คุปฺตํ ตํ ปปฺรจฺฉุ:, วยเมนํ ภูตํ ตฺยาชยิตุํ กุโต น ศกฺตา:? ");
INSERT INTO santha_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ส อุวาจ, ปฺรารฺถโนปวาเสา วินา เกนาปฺยเนฺยน กรฺมฺมณา ภูตมีทฺฤศํ ตฺยาชยิตุํ น ศกฺยํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","อนนฺตรํ ส ตตฺสฺถานาทิตฺวา คาลีลฺมเธฺยน ยเยา, กินฺตุ ตตฺ โกปิ ชานียาทิติ ส ไนจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","อปรญฺจ ส ศิษฺยานุปทิศนฺ พภาเษ, นรปุโตฺร นรหเสฺตษุ สมรฺปยิษฺยเต เต จ ตํ หนิษฺยนฺติ ไตสฺตสฺมินฺ หเต ตฺฤตียทิเน ส อุตฺถาสฺยตีติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","กินฺตุ ตตฺกถำ เต นาพุธฺยนฺต ปฺรษฺฏุญฺจ พิภฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","อถ ยีศุ: กผรฺนาหูมฺปุรมาคตฺย มเธฺยคฺฤหญฺเจตฺย ตานปฺฤจฺฉทฺ วรฺตฺมมเธฺย ยูยมโนฺยนฺยํ กึ วิวทเธฺว สฺม? ");
INSERT INTO santha_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","กินฺตุ เต นิรุตฺตราสฺตสฺถุ รฺยสฺมาตฺเตษำ โก มุขฺย อิติ วรฺตฺมานิ เต'โนฺยนฺยํ วฺยวทนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ตต: ส อุปวิศฺย ทฺวาทศศิษฺยานฺ อาหูย พภาเษ ย: กศฺจิตฺ มุโขฺย ภวิตุมิจฺฉติ ส สรฺเวฺวโภฺย เคาณ: สรฺเวฺวษำ เสวกศฺจ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ตทา ส พาลกเมกํ คฺฤหีตฺวา มเธฺย สมุปาเวศยตฺ ตตสฺตํ โกฺรเฑ กฺฤตฺวา ตานวาทาตฺ ");
INSERT INTO santha_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ย: กศฺจิทีทฺฤศสฺย กสฺยาปิ พาลสฺยาติถฺยํ กโรติ ส มมาติถฺยํ กโรติ; ย: กศฺจินฺมมาติถฺยํ กโรติ ส เกวลมฺ มมาติถฺยํ กโรติ ตนฺน มตฺเปฺรรกสฺยาปฺยาติถฺยํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","อถ โยหนฺ ตมพฺรวีตฺ เห คุโร, อสฺมากมนนุคามินมฺ เอกํ ตฺวานฺนามฺนา ภูตานฺ ตฺยาชยนฺตํ วยํ ทฺฤษฺฏวนฺต:, อสฺมากมปศฺจาทฺคามิตฺวาจฺจ ตํ นฺยเษธามฯ ");
INSERT INTO santha_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","กินฺตุ ยีศุรวทตฺ ตํ มา นิเษธตฺ, ยโต ย: กศฺจินฺ มนฺนามฺนา จิตฺรํ กรฺมฺม กโรติ ส สหสา มำ นินฺทิตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ตถา ย: กศฺจิทฺ ยุษฺมากํ วิปกฺษตำ น กโรติ ส ยุษฺมากเมว สปกฺษ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ย: กศฺจิทฺ ยุษฺมานฺ ขฺรีษฺฏศิษฺยานฺ ชฺญาตฺวา มนฺนามฺนา กํไสเกน ปานียํ ปาตุํ ททาติ, ยุษฺมานหํ ยถารฺถํ วจฺมิ, ส ผเลน วญฺจิโต น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","กินฺตุ ยทิ กศฺจินฺ มยิ วิศฺวาสินาเมษำ กฺษุทฺรปฺราณินามฺ เอกสฺยาปิ วิฆฺนํ ชนยติ, ตรฺหิ ตไสฺยตตฺกรฺมฺม กรณาตฺ กณฺฐพทฺธเปษณีกสฺย ตสฺย สาคราคาธชล มชฺชนํ ภทฺรํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","อต: สฺวกโร ยทิ ตฺวำ พาธเต ตรฺหิ ตํ ฉินฺธิ; ");
INSERT INTO santha_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ยสฺมาตฺ ยตฺร กีฏา น มฺริยนฺเต วหฺนิศฺจ น นิรฺวฺวาติ, ตสฺมินฺ อนิรฺวฺวาณานลนรเก กรทฺวยวสฺตว คมนาตฺ กรหีนสฺย สฺวรฺคปฺรเวศสฺตว เกฺษมํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ยทิ ตว ปาโท วิฆฺนํ ชนยติ ตรฺหิ ตํ ฉินฺธิ, ");
INSERT INTO santha_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ยโต ยตฺร กีฏา น มฺริยนฺเต วหฺนิศฺจ น นิรฺวฺวาติ, ตสฺมินฺ 'นิรฺวฺวาณวเหฺนา นรเก ทฺวิปาทวตสฺตว นิกฺเษปาตฺ ปาทหีนสฺย สฺวรฺคปฺรเวศสฺตว เกฺษมํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","สฺวเนตฺรํ ยทิ ตฺวำ พาธเต ตรฺหิ ตทปฺยุตฺปาฏย, ยโต ยตฺร กีฏา น มฺริยนฺเต วหฺนิศฺจ น นิรฺวฺวาติ, ");
INSERT INTO santha_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ตสฺมิน 'นิรฺวฺวาณวเหฺนา นรเก ทฺวิเนตฺรสฺย ตว นิกฺเษปาทฺ เอกเนตฺรวต อีศฺวรราเชฺย ปฺรเวศสฺตว เกฺษมํฯ ");
INSERT INTO santha_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ยถา สรฺโวฺว พลิ รฺลวณากฺต: กฺริยเต ตถา สรฺโวฺว ชโน วหฺนิรูเปณ ลวณากฺต: การิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ลวณํ ภทฺรํ กินฺตุ ยทิ ลวเณ สฺวาทุตา น ติษฺฐติ, ตรฺหิ กถมฺ อาสฺวาทฺยุกฺตํ กริษฺยถ? ยูยํ ลวณยุกฺตา ภวต ปรสฺปรํ เปฺรม กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","อนนฺตรํ ส ตตฺสฺถานาตฺ ปฺรสฺถาย ยรฺทฺทนนทฺยา: ปาเร ยิหูทาปฺรเทศ อุปสฺถิตวานฺ, ตตฺร ตทนฺติเก โลกานำ สมาคเม ชาเต ส นิชรีตฺยนุสาเรณ ปุนสฺตานฺ อุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ตทา ผิรูศินสฺตตฺสมีปมฺ เอตฺย ตํ ปรีกฺษิตุํ ปปฺรจฺฉ: สฺวชายา มนุชานำ ตฺยชฺยา น เวติ? ");
INSERT INTO santha_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ตต: ส ปฺรตฺยวาทีตฺ, อตฺร การฺเยฺย มูสา ยุษฺมานฺ ปฺรติ กิมาชฺญาปยตฺ? ");
INSERT INTO santha_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ต อูจุ: ตฺยาคปตฺรํ เลขิตุํ สฺวปตฺนีํ ตฺยกฺตุญฺจ มูสา'นุมนฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ตทา ยีศุ: ปฺรตฺยุวาจ, ยุษฺมากํ มนสำ กาฐินฺยาทฺเธโต รฺมูสา นิเทศมิมมฺ อลิขตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","กินฺตุ สฺฤษฺเฏราเทา อีศฺวโร นรานฺ ปุํรูเปณ สฺตฺรีรูเปณ จ สสรฺชฯ ");
INSERT INTO santha_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ตต: การณาตฺ ปุมานฺ ปิตรํ มาตรญฺจ ตฺยกฺตฺวา สฺวชายายามฺ อาสกฺโต ภวิษฺยติ, ");
INSERT INTO santha_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","เตา ทฺวาวฺ เอกางฺเคา ภวิษฺยต:ฯ \" ตสฺมาตฺ ตตฺกาลมารภฺย เตา น ทฺวาวฺ เอกางฺเคาฯ ");
INSERT INTO santha_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","อต: การณาทฺ อีศฺวโร ยทโยชยตฺ โกปิ นรสฺตนฺน วิเยชเยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","อถ ยีศุ รฺคฺฤหํ ปฺรวิษฺฏสฺตทา ศิษฺยา: ปุนสฺตตฺกถำ ตํ ปปฺรจฺฉุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ตต: โสวทตฺ กศฺจิทฺ ยทิ สฺวภารฺยฺยำ ตฺยกฺตวานฺยามฺ อุทฺวหติ ตรฺหิ ส สฺวภารฺยฺยายา: ปฺราติกูเลฺยน วฺยภิจารี ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","กาจินฺนารี ยทิ สฺวปตึ หิตฺวานฺยปุํสา วิวาหิตา ภวติ ตรฺหิ สาปิ วฺยภิจาริณี ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","อถ ส ยถา ศิศูนฺ สฺปฺฤเศตฺ, ตทรฺถํ โลไกสฺตทนฺติกํ ศิศว อานียนฺต, กินฺตุ ศิษฺยาสฺตานานีตวตสฺตรฺชยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ยีศุสฺตทฺ ทฺฤษฺฏฺวา กฺรุธฺยนฺ ชคาท, มนฺนิกฏมฺ อาคนฺตุํ ศิศูนฺ มา วารยต, ยต เอตาทฺฤศา อีศฺวรราชฺยาธิการิณ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ยุษฺมานหํ ยถารฺถํ วจฺมิ, ย: กศฺจิตฺ ศิศุวทฺ ภูตฺวา ราชฺยมีศฺวรสฺย น คฺฤหฺลียาตฺ ส กทาปิ ตทฺราชฺยํ ปฺรเวษฺฏุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","อนนตรํ ส ศิศูนงฺเก นิธาย เตษำ คาเตฺรษุ หเสฺตา ทตฺตฺวาศิษํ พภาเษฯ ");
INSERT INTO santha_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","อถ ส วรฺตฺมนา ยาติ, เอตรฺหิ ชน เอโก ธาวนฺ อาคตฺย ตตฺสมฺมุเข ชานุนี ปาตยิตฺวา ปฺฤษฺฏวานฺ, โภ: ปรมคุโร, อนนฺตายุ: ปฺราปฺตเย มยา กึ กรฺตฺตวฺยํ? ");
INSERT INTO santha_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ตทา ยีศุรุวาจ, มำ ปรมํ กุโต วทสิ? วิเนศฺวรํ โกปิ ปรโม น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ปรสฺตฺรีํ นาภิคจฺฉ; นรํ มา ฆาตย; เสฺตยํ มา กุรุ; มฺฤษาสากฺษฺยํ มา เทหิ; หึสาญฺจ มา กุรุ; ปิตเรา สมฺมนฺยสฺว; นิเทศา เอเต ตฺวยา ชฺญาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ตตสฺตน ปฺรตฺยุกฺตํ, เห คุโร พาลฺยกาลาทหํ สรฺวฺวาเนตานฺ อาจรามิฯ ");
INSERT INTO santha_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ตทา ยีศุสฺตํ วิโลกฺย เสฺนเหน พภาเษ, ตไวกสฺยาภาว อาเสฺต; ตฺวํ คตฺวา สรฺวฺวสฺวํ วิกฺรีย ทริเทฺรโภฺย วิศฺราณย, ตต: สฺวรฺเค ธนํ ปฺราปฺสฺยสิ; ตต: ปรมฺ เอตฺย กฺรุศํ วหนฺ มทนุวรฺตฺตี ภวฯ ");
INSERT INTO santha_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","กินฺตุ ตสฺย พหุสมฺปทฺวิทฺยมานตฺวาตฺ ส อิมำ กถามากรฺณฺย วิษโณ ทุ:ขิตศฺจ สนฺ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","อถ ยีศุศฺจตุรฺทิโศ นิรีกฺษฺย ศิษฺยานฺ อวาทีตฺ, ธนิโลกานามฺ อีศฺวรราชฺยปฺรเวศ: กีทฺฤคฺ ทุษฺกร:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ตสฺย กถาต: ศิษฺยาศฺจมจฺจกฺรุ:, กินฺตุ ส ปุนรวทตฺ, เห พาลกา เย ธเน วิศฺวสนฺติ เตษามฺ อีศฺวรราชฺยปฺรเวศ: กีทฺฤคฺ ทุษฺกร:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","อีศฺวรราเชฺย ธนินำ ปฺรเวศาตฺ สูจิรนฺเธฺรณ มหางฺคสฺย คมนาคมนํ สุกรํฯ ");
INSERT INTO santha_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ตทา ศิษฺยา อตีว วิสฺมิตา: ปรสฺปรํ โปฺรจุ:, ตรฺหิ ก: ปริตฺราณํ ปฺราปฺตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ตโต ยีศุสฺตานฺ วิโลกฺย พภาเษ, ตนฺ นรสฺยาสาธฺยํ กินฺตุ เนศฺวรสฺย, ยโต เหโตรีศฺวรสฺย สรฺวฺวํ สาธฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ตทา ปิตร อุวาจ, ปศฺย วยํ สรฺวฺวํ ปริตฺยชฺย ภวโตนุคามิโน ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ตโต ยีศุ: ปฺรตฺยวทตฺ, ยุษฺมานหํ ยถารฺถํ วทามิ, มทรฺถํ สุสํวาทารฺถํ วา โย ชน: สทนํ ภฺราตรํ ภคินีํ ปิตรํ มาตรํ ชายำ สนฺตานานฺ ภูมิ วา ตฺยกฺตฺวา ");
INSERT INTO santha_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","คฺฤหภฺราตฺฤภคินีปิตฺฤมาตฺฤปตฺนีสนฺตานภูมีนามิห ศตคุณานฺ เปฺรตฺยานนฺตายุศฺจ น ปฺราปฺโนติ ตาทฺฤศ: โกปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","กินฺตฺวคฺรียา อเนเก โลกา: เศษา:, เศษียา อเนเก โลกาศฺจาคฺรา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","อถ ยิรูศาลมฺยานกาเล ยีศุเสฺตษามฺ อคฺรคามี พภูว, ตสฺมาตฺเต จิตฺรํ ชฺญาตฺวา ปศฺจาทฺคามิโน ภูตฺวา พิภฺยุ:ฯ ตทา ส ปุน รฺทฺวาทศศิษฺยานฺ คฺฤหีตฺวา สฺวียํ ยทฺยทฺ ฆฏิษฺยเต ตตฺตตฺ เตภฺย: กถยิตุํ ปฺราเรเภ; ");
INSERT INTO santha_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ปศฺยต วยํ ยิรูศาลมฺปุรํ ยาม:, ตตฺร มนุษฺยปุตฺร: ปฺรธานยาชกานามฺ อุปาธฺยายานาญฺจ กเรษุ สมรฺปยิษฺยเต; เต จ วธทณฺฑาชฺญำ ทาปยิตฺวา ปรเทศียานำ กเรษุ ตํ สมรฺปยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","เต ตมุปหสฺย กศยา ปฺรหฺฤตฺย ตทฺวปุษิ นิษฺฐีวํ นิกฺษิปฺย ตํ หนิษฺยนฺติ, ตต: ส ตฺฤตียทิเน โปฺรตฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ตต: สิวเท: ปุเตฺรา ยากูโพฺยหเนา ตทนฺติกมฺ เอตฺย โปฺรจตุ:, เห คุโร ยทฺ อาวาภฺยำ ยาจิษฺยเต ตทสฺมทรฺถํ ภวานฺ กโรตุ นิเวทนมิทมาวโย:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ตต: ส กถิตวานฺ, ยุวำ กิมิจฺฉถ:? กึ มยา ยุษฺมทรฺถํ กรณียํ? ");
INSERT INTO santha_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ตทา เตา โปฺรจตุ:, อาวโยเรกํ ทกฺษิณปารฺเศฺว วามปารฺเศฺว ไจกํ ตไวศฺวรฺยฺยปเท สมุปเวษฺฏุมฺ อาชฺญาปยฯ ");
INSERT INTO santha_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","กินฺตุ ยีศุ: ปฺรตฺยุวาจ ยุวามชฺญาเตฺวทํ ปฺรารฺถเยเถ, เยน กํเสนาหํ ปาสฺยามิ เตน ยุวาภฺยำ กึ ปาตุํ ศกฺษฺยเต? ยสฺมินฺ มชฺชเนนาหํ มชฺชิเษฺย ตนฺมชฺชเน มชฺชยิตุํ กึ ยุวาภฺยำ ศกฺษฺยเต? เตา ปฺรตฺยูจตุ: ศกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ตทา ยีศุรวทตฺ เยน กํเสนาหํ ปาสฺยามิ เตนาวศฺยํ ยุวามปิ ปาสฺยถ:, เยน มชฺชเนน จาหํ มชฺชิเยฺย ตตฺร ยุวามปิ มชฺชิเษฺยเถฯ ");
INSERT INTO santha_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","กินฺตุ เยษามรฺถมฺ อิทํ นิรูปิตํ, ตานฺ วิหายานฺยํ กมปิ มม ทกฺษิณปารฺเศฺว วามปารฺเศฺว วา สมุปเวศยิตุํ มมาธิกาโร นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","อถานฺยทศศิษฺยา อิมำ กถำ ศฺรุตฺวา ยากูโพฺยหนฺภฺยำ จุกุปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","กินฺตุ ยีศุสฺตานฺ สมาหูย พภาเษ, อนฺยเทศียานำ ราชตฺวํ เย กุรฺวฺวนฺติ เต เตษาเมว ปฺรภุตฺวํ กุรฺวฺวนฺติ, ตถา เย มหาโลกาเสฺต เตษามฺ อธิปติตฺวํ กุรฺวฺวนฺตีติ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","กินฺตุ ยุษฺมากํ มเธฺย น ตถา ภวิษฺยติ, ยุษฺมากํ มเธฺย ย: ปฺราธานฺยํ วาญฺฉติ ส ยุษฺมากํ เสวโก ภวิษฺยติ, ");
INSERT INTO santha_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ยุษฺมากํ โย มหานฺ ภวิตุมิจฺฉติ ส สรฺเวฺวษำ กิงฺกโร ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ยโต มนุษฺยปุตฺร: เสโวฺย ภวิตุํ นาคต: เสวำ กรฺตฺตำ ตถาเนเกษำ ปริตฺราณสฺย มูลฺยรูปสฺวปฺราณํ ทาตุญฺจาคต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","อถ เต ยิรีโหนครํ ปฺราปฺตาสฺตสฺมาตฺ ศิไษฺย โรฺลไกศฺจ สห ยีโศ รฺคมนกาเล ฏีมยสฺย ปุโตฺร พรฺฏีมยนามา อนฺธสฺตนฺมารฺคปารฺเศฺว ภิกฺษารฺถมฺ อุปวิษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ส นาสรตียสฺย ยีโศราคมนวารฺตฺตำ ปฺราปฺย โปฺรไจ รฺวกฺตุมาเรเภ, เห ยีโศ ทายูท: สนฺตาน มำ ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ตโตเนเก โลกา เมานีภเวติ ตํ ตรฺชยามาสุ:, กินฺตุ ส ปุนรธิกมุจฺไจ รฺชคาท, เห ยีโศ ทายูท: สนฺตาน มำ ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ตทา ยีศุ: สฺถิตฺวา ตมาหฺวาตุํ สมาทิเทศ, ตโต โลกาสฺตมนฺธมาหูย พภาษิเร, เห นร, สฺถิโร ภว, อุตฺติษฺฐ, ส ตฺวามาหฺวยติฯ ");
INSERT INTO santha_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ตทา ส อุตฺตรียวสฺตฺรํ นิกฺษิปฺย โปฺรตฺถาย ยีโศ: สมีปํ คต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ตโต ยีศุสฺตมวทตฺ ตฺวยา กึ ปฺรารฺถฺยเต? ตุภฺยมหํ กึ กริษฺยามี? ตทา โสนฺธสฺตมุวาจ, เห คุโร มทียา ทฺฤษฺฏิรฺภเวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ตโต ยีศุสฺตมุวาจ ยาหิ ตว วิศฺวาสสฺตฺวำ สฺวสฺถมการฺษีตฺ, ตสฺมาตฺ ตตฺกฺษณํ ส ทฺฤษฺฏึ ปฺราปฺย ปถา ยีโศ: ปศฺจาทฺ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","อนนฺตรํ เตษุ ยิรูศาลม: สมีปสฺถโย ไรฺพตฺผคีไพถนียปุรโยรนฺติกสฺถํ ไชตุนนามาทฺริมาคเตษุ ยีศุ: เปฺรษณกาเล เทฺวา ศิษฺยาวิทํ วากฺยํ ชคาท, ");
INSERT INTO santha_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ยุวามมุํ สมฺมุขสฺถํ คฺรามํ ยาตํ, ตตฺร ปฺรวิศฺย โย นรํ นาวหตฺ ตํ ครฺทฺทภศาวกํ ทฺรกฺษฺยถสฺตํ โมจยิตฺวานยตํฯ ");
INSERT INTO santha_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","กินฺตุ ยุวำ กรฺมฺเมทํ กุต: กุรุถ:? กถามิมำ ยทิ โกปิ ปฺฤจฺฉติ ตรฺหิ ปฺรโภรตฺร ปฺรโยชนมสฺตีติ กถิเต ส ศีฆฺรํ ตมตฺร เปฺรษยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ตตเสฺตา คตฺวา ทฺวิมารฺคเมลเน กสฺยจิทฺ ทฺวารสฺย ปารฺเศฺว ตํ ครฺทฺทภศาวกํ ปฺราปฺย โมจยต:, ");
INSERT INTO santha_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","เอตรฺหิ ตโตฺรปสฺถิตโลกานำ กศฺจิทฺ อปฺฤจฺฉตฺ, ครฺทฺทภศิศุํ กุโต โมจยถ:? ");
INSERT INTO santha_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ตทา ยีโศราชฺญานุสาเรณ เตภฺย: ปฺรตฺยุทิเต ตตฺกฺษณํ ตมาทาตุํ เต'นุชชฺญุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","อถ เตา ยีโศ: สนฺนิธึ ครฺทฺทภศิศุมฺ อานีย ตทุปริ สฺววสฺตฺราณิ ปาตยามาสตุ:; ตต: ส ตทุปริ สมุปวิษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ตทาเนเก ปถิ สฺววาสำสิ ปาตยามาสุ:, ปไรศฺจ ตรุศาขาศฺฉิตวา มารฺเค วิกีรฺณา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","อปรญฺจ ปศฺจาทฺคามิโน'คฺรคามินศฺจ สรฺเวฺว ชนา อุไจ:สฺวเรณ วกฺตุมาเรภิเร, ชย ชย ย: ปรเมศฺวรสฺย นามฺนาคจฺฉติ ส ธนฺย อิติฯ ");
INSERT INTO santha_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ตถาสฺมากมํ ปูรฺวฺวปุรุษสฺย ทายูโท ยทฺราชฺยํ ปรเมศฺวรนามฺนายาติ ตทปิ ธนฺยํ, สรฺวฺวสฺมาทุจฺฉฺราเย สฺวรฺเค อีศฺวรสฺย ชโย ภเวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","อิตฺถํ ยีศุ รฺยิรูศาลมิ มนฺทิรํ ปฺรวิศฺย จตุรฺทิกฺสฺถานิ สรฺวฺวาณิ วสฺตูนิ ทฺฤษฺฏวานฺ; อถ สายํกาล อุปสฺถิเต ทฺวาทศศิษฺยสหิโต ไพถนิยํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","อปเรหนิ ไพถนิยาทฺ อาคมนสมเย กฺษุธารฺตฺโต พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ตโต ทูเร สปตฺรมุฑุมฺพรปาทปํ วิโลกฺย ตตฺร กิญฺจิตฺ ผลํ ปฺราปฺตุํ ตสฺย สนฺนิกฺฤษฺฏํ ยเยา, ตทานีํ ผลปาตนสฺย สมโย นาคจฺฉติฯ ตตสฺตโตฺรปสฺถิต: ปตฺราณิ วินา กิมปฺยปรํ น ปฺราปฺย ส กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","อทฺยารภฺย โกปิ มานวสฺตฺวตฺต: ผลํ น ภุญฺชีต; อิมำ กถำ ตสฺย ศิษฺยา: ศุศฺรุวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ตทนนฺตรํ เตษุ ยิรูศาลมมายาเตษุ ยีศุ รฺมนฺทิรํ คตฺวา ตตฺรสฺถานำ พณิชำ มุทฺราสนานิ ปาราวตวิเกฺรตฺฤณามฺ อาสนานิ จ นฺยุพฺชยาญฺจการ สรฺวฺวานฺ เกฺรตฺฤนฺ วิเกฺรตฺฤํศฺจ พหิศฺจการฯ ");
INSERT INTO santha_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","อปรํ มนฺทิรมเธฺยน กิมปิ ปาตฺรํ โวฒุํ สรฺวฺวชนํ นิวารยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","โลกานุปทิศนฺ ชคาท, มม คฺฤหํ สรฺวฺวชาตียานำ ปฺรารฺถนาคฺฤหมฺ อิติ นามฺนา ปฺรถิตํ ภวิษฺยติ เอตตฺ กึ ศาสฺเตฺร ลิขิตํ นาสฺติ? กินฺตุ ยูยํ ตเทว โจราณำ คหฺวรํ กุรุถฯ ");
INSERT INTO santha_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","อิมำ วาณีํ ศฺรุตฺวาธฺยาปกา: ปฺรธานยาชกาศฺจ ตํ ยถา นาศยิตุํ ศกฺนุวนฺติ ตโถेปายํ มฺฤคยามาสุ:, กินฺตุ ตโสฺยปเทศาตฺ สรฺเวฺว โลกา วิสฺมยํ คตา อตเสฺต ตสฺมาทฺ พิภฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","อถ สายํสมย อุปสฺถิเต ยีศุรฺนคราทฺ พหิรฺววฺราชฯ ");
INSERT INTO santha_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","อนนฺตรํ ปฺราต:กาเล เต เตน มารฺเคณ คจฺฉนฺตสฺตมุฑุมฺพรมหีรุหํ สมูลํ ศุษฺกํ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ตต: ปิตร: ปูรฺวฺววากฺยํ สฺมรนฺ ยีศุํ พภาษํ, เห คุโร ปศฺยตุ ย อุฑุมฺพรวิฏปี ภวตา ศปฺต: ส ศุษฺโก พภูวฯ ");
INSERT INTO santha_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ตโต ยีศุ: ปฺรตฺยวาทีตฺ, ยูยมีศฺวเร วิศฺวสิตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ยุษฺมานหํ ยถารฺถํ วทามิ โกปิ ยเทฺยตทฺคิรึ วทติ, ตฺวมุตฺถาย คตฺวา ชลเธา ปต, โปฺรกฺตมิทํ วากฺยมวศฺยํ ฆฏิษฺยเต, มนสา กิมปิ น สนฺทิหฺย เจทิทํ วิศฺวเสตฺ ตรฺหิ ตสฺย วากฺยานุสาเรณ ตทฺ ฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","อโต เหโตรหํ ยุษฺมานฺ วจฺมิ, ปฺรารฺถนากาเล ยทฺยทากำกฺษิษฺยเธฺว ตตฺตทวศฺยํ ปฺราปฺสฺยถ, อิตฺถํ วิศฺวสิต, ตต: ปฺราปฺสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","อปรญฺจ ยุษฺมาสุ ปฺรารฺถยิตุํ สมุตฺถิเตษุ ยทิ โกปิ ยุษฺมากมฺ อปราธี ติษฺฐติ, ตรฺหิ ตํ กฺษมธฺวํ, ตถา กฺฤเต ยุษฺมากํ สฺวรฺคสฺถ: ปิตาปิ ยุษฺมากมาคำมิ กฺษมิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","กินฺตุ ยทิ น กฺษมเธฺว ตรฺหิ ว: สฺวรฺคสฺถ: ปิตาปิ ยุษฺมากมาคำสิ น กฺษมิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","อนนฺตรํ เต ปุน รฺยิรูศาลมํ ปฺรวิวิศุ:, ยีศุ รฺยทา มเธฺยมนฺทิรมฺ อิตสฺตโต คจฺฉติ, ตทานีํ ปฺรธานยาชกา อุปาธฺยายา: ปฺราญฺจศฺจ ตทนฺติกเมตฺย กถามิมำ ปปฺรจฺฉุ:, ");
INSERT INTO santha_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ตฺวํ เกนาเทเศน กรฺมฺมาเณฺยตานิ กโรษิ? ตไถตานิ กรฺมฺมาณิ กรฺตฺตำ เกนาทิษฺโฏสิ? ");
INSERT INTO santha_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ตโต ยีศุ: ปฺรติคทิตวานฺ อหมปิ ยุษฺมานฺ เอกกถำ ปฺฤจฺฉามิ, ยทิ ยูยํ ตสฺยา อุตฺตรํ กุรุถ, ตรฺหิ กยาชฺญยาหํ กรฺมฺมาเณฺยตานิ กโรมิ ตทฺ ยุษฺมภฺยํ กถยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","โยหโน มชฺชนมฺ อีศฺวราตฺ ชาตํ กึ มานวาตฺ? ตนฺมหฺยํ กถยตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","เต ปรสฺปรํ วิเวกฺตุํ ปฺราเรภิเร, ตทฺ อีศฺวราทฺ พภูเวติ เจทฺ วทามสฺตรฺหิ กุตสฺตํ น ปฺรไตฺยต? กถเมตำ กถยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","มานวาทฺ อภวทิติ เจทฺ วทามสฺตรฺหิ โลเกโภฺย ภยมสฺติ ยโต เหโต: สรฺเวฺว โยหนํ สตฺยํ ภวิษฺยทฺวาทินํ มนฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","อเตอว เต ยีศุํ ปฺรตฺยวาทิษุ รฺวยํ ตทฺ วกฺตุํ น ศกฺนุม:ฯ ยีศุรุวาจ, ตรฺหิ เยนาเทเศน กรฺมฺมาเณฺยตานิ กโรมิ, อหมปิ ยุษฺมภฺยํ ตนฺน กถยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","อนนฺตรํ ยีศุ รฺทฺฤษฺฏานฺเตน เตภฺย: กถยิตุมาเรเภ, กศฺจิเทโก ทฺรากฺษากฺเษตฺรํ วิธาย ตจฺจตุรฺทิกฺษุ วารณีํ กฺฤตฺวา ตนฺมเธฺย ทฺรากฺษาเปษณกุณฺฑมฺ อขนตฺ, ตถา ตสฺย คฑมปิ นิรฺมฺมิตวานฺ ตตสฺตตฺกฺเษตฺรํ กฺฤษีวเลษุ สมรฺปฺย ทูรเทศํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ตทนนฺตรํ ผลกาเล กฺฤษีวเลโภฺย ทฺรากฺษากฺเษตฺรผลานิ ปฺราปฺตุํ เตษำ สวิเธ ภฺฤตฺยมฺ เอกํ ปฺราหิโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","กินฺตุ กฺฤษีวลาสฺตํ ธฺฤตฺวา ปฺรหฺฤตฺย ริกฺตหสฺตํ วิสสฺฤชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ตต: ส ปุนรนฺยเมกํ ภฺฤตฺยํ ปฺรษยามาส, กินฺตุ เต กฺฤษีวลา: ปาษาณาฆาไตสฺตสฺย ศิโร ภงฺกฺตฺวา สาปมานํ ตํ วฺยสรฺชนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ตต: ปรํ โสปรํ ทาสํ ปฺราหิโณตฺ ตทา เต ตํ ชฆฺนุ:, เอวมฺ อเนเกษำ กสฺยจิตฺ ปฺรหาร: กสฺยจิทฺ วธศฺจ ไต: กฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ตต: ปรํ มยา สฺวปุเตฺร ปฺรหิเต เต ตมวศฺยํ สมฺมํสฺยนฺเต, อิตฺยุกฺตฺวาวเศเษ เตษำ สนฺนิเธา นิชปฺริยมฺ อทฺวิตียํ ปุตฺรํ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","กินฺตุ กฺฤษีวลา: ปรสฺปรํ ชคทุ:, เอษ อุตฺตราธิการี, อาคจฺฉต วยเมนํ หนฺมสฺตถา กฺฤเต 'ธิกาโรยมฺ อสฺมากํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ตตสฺตํ ธฺฤตฺวา หตฺวา ทฺรากฺษากฺเษตฺราทฺ พหิ: ปฺรากฺษิปนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","อเนนาเสา ทฺรากฺษากฺเษตฺรปติ: กึ กริษฺยติ? ส เอตฺย ตานฺ กฺฤษีวลานฺ สํหตฺย ตตฺกฺเษตฺรมฺ อเนฺยษุ กฺฤษีวเลษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","อปรญฺจ, \"สฺถปตย: กริษฺยนฺติ คฺราวาณํ ยนฺตุ ตุจฺฉกํฯ ปฺราธานปฺรสฺตร: โกเณ ส เอว สํภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","เอตตฺ กรฺมฺม ปเรศสฺยำทฺภุตํ โน ทฺฤษฺฏิโต ภเวตฺ๚ \" อิมำ ศาสฺตฺรียำ ลิปึ ยูยํ กึ นาปาฐิษฺฏ? ");
INSERT INTO santha_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ตทานีํ ส ตานุทฺทิศฺย ตำ ทฺฤษฺฏานฺตกถำ กถิตวานฺ, ต อิตฺถํ พุทฺวฺวา ตํ ธรฺตฺตามุทฺยตา:, กินฺตุ โลเกโภฺย พิภฺยุ:, ตทนนฺตรํ เต ตํ วิหาย ววฺรชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","อปรญฺจ เต ตสฺย วากฺยโทษํ ธรฺตฺตำ กติปยานฺ ผิรูศิโน เหโรทียำศฺจ โลกานฺ ตทนฺติกํ เปฺรษยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ต อาคตฺย ตมวทนฺ, เห คุโร ภวานฺ ตถฺยภาษี กสฺยาปฺยนุโรธํ น มนฺยเต, ปกฺษปาตญฺจ น กโรติ, ยถารฺถต อีศฺวรียํ มารฺคํ ทรฺศยติ วยเมตตฺ ปฺรชานีม:, ไกสราย กโร เทโย น วำ? วยํ ทาสฺยาโม น วา? ");
INSERT INTO santha_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","กินฺตุ ส เตษำ กปฏํ ชฺญาตฺวา ชคาท, กุโต มำ ปรีกฺษเธฺว? เอกํ มุทฺราปาทํ สมานีย มำ ทรฺศยตฯ ");
INSERT INTO santha_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ตทา ไตเรกสฺมินฺ มุทฺราปาเท สมานีเต ส ตานฺ ปปฺรจฺฉ, อตฺร ลิขิตํ นาม มูรฺตฺติ รฺวา กสฺย? เต ปฺรตฺยูจุ:, ไกสรสฺยฯ ");
INSERT INTO santha_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ตทา ยีศุรวทตฺ ตรฺหิ ไกสรสฺย ทฺรวฺยาณิ ไกสราย ทตฺต, อีศฺวรสฺย ทฺรวฺยาณิ ตุ อีศฺวราย ทตฺต; ตตเสฺต วิสฺมยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","อถ มฺฤตานามุตฺถานํ เย น มนฺยนฺเต เต สิทูกิโน ยีโศ: สมีปมาคตฺย ตํ ปปฺรจฺฉุ:; ");
INSERT INTO santha_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","เห คุโร กศฺจิชฺชโน ยทิ นิ:สนฺตติ: สนฺ ภารฺยฺยายำ สตฺยำ มฺริยเต ตรฺหิ ตสฺย ภฺราตา ตสฺย ภารฺยฺยำ คฺฤหีตฺวา ภฺราตุ รฺวํโศตฺปตฺตึ กริษฺยติ, วฺยวสฺถามิมำ มูสา อสฺมานฺ ปฺรติ วฺยลิขตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","กินฺตุ เกจิตฺ สปฺต ภฺราตร อาสนฺ, ตตเสฺตษำ เชฺยษฺฐภฺราตา วิวหฺย นิ:สนฺตติ: สนฺ อมฺริยตฯ ");
INSERT INTO santha_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ตโต ทฺวิตีโย ภฺราตา ตำ สฺตฺริยมคฺฤหณตฺ กินฺตุ โสปิ นิ:สนฺตติ: สนฺ อมฺริยต; อถ ตฺฤตีโยปิ ภฺราตา ตาทฺฤโศภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","อิตฺถํ สปฺไตว ภฺราตรสฺตำ สฺตฺริยํ คฺฤหีตฺวา นิ:สนฺตานา: สนฺโต'มฺริยนฺต, สรฺวฺวเศเษ สาปิ สฺตฺรี มฺริยเต สฺมฯ ");
INSERT INTO santha_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","อถ มฺฤตานามุตฺถานกาเล ยทา ต อุตฺถาสฺยนฺติ ตทา เตษำ กสฺย ภารฺยฺยา สา ภวิษฺยติ? ยตเสฺต สปฺไตว ตำ วฺยวหนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ตโต ยีศุ: ปฺรตฺยุวาจ ศาสฺตฺรมฺ อีศฺวรศกฺติญฺจ ยูยมชฺญาตฺวา กิมภฺรามฺยต น? ");
INSERT INTO santha_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","มฺฤตโลกานามุตฺถานํ สติ เต น วิวหนฺติ วาคฺทตฺตา อปิ น ภวนฺติ, กินฺตุ สฺวรฺคียทูตานำ สทฺฤศา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ปุนศฺจ \"อหมฺ อิพฺราหีม อีศฺวร อิสฺหาก อีศฺวโร ยากูพศฺเจศฺวร:\" ยามิมำ กถำ สฺตมฺพมเธฺย ติษฺฐนฺ อีศฺวโร มูสามวาทีตฺ มฺฤตานามุตฺถานารฺเถ สา กถา มูสาลิขิเต ปุสฺตเก กึ ยุษฺมาภิ รฺนาปาฐิ? ");
INSERT INTO santha_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","อีศฺวโร ชีวตำ ปฺรภุ: กินฺตุ มฺฤตานำ ปฺรภุ รฺน ภวติ, ตสฺมาทฺเธโต รฺยูยํ มหาภฺรเมณ ติษฺฐถฯ ");
INSERT INTO santha_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","เอตรฺหิ เอโกธฺยาปก เอตฺย เตษามิตฺถํ วิจารํ ศุศฺราว; ยีศุเสฺตษำ วากฺยสฺย สทุตฺตรํ ทตฺตวานฺ อิติ พุทฺวฺวา ตํ ปฺฤษฺฏวานฺ สรฺวฺวาสามฺ อาชฺญานำ กา เศฺรษฺฐา? ตโต ยีศุ: ปฺรตฺยุวาจ, ");
INSERT INTO santha_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"เห อิสฺราเยโลฺลกา อวธตฺต, อสฺมากํ ปฺรภุ: ปรเมศฺวร เอก เอว, ");
INSERT INTO santha_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ยูยํ สรฺวฺวนฺต:กรไณ: สรฺวฺวปฺราไณ: สรฺวฺวจิตฺไต: สรฺวฺวศกฺติภิศฺจ ตสฺมินฺ ปฺรเภา ปรเมศฺวเร ปฺรียธฺวํ,\" อิตฺยาชฺญา เศฺรษฺฐาฯ ");
INSERT INTO santha_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ตถา \"สฺวปฺรติวาสินิ สฺววตฺ เปฺรม กุรุธฺวํ,\" เอษา ยา ทฺวิตียาชฺญา สา ตาทฺฤศี; เอตาภฺยำ ทฺวาภฺยามฺ อาชฺญาภฺยามฺ อนฺยา กาปฺยาชฺญา เศฺรษฺฐา นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ตทา โสธฺยาปกสฺตมวทตฺ, เห คุโร สตฺยํ ภวานฺ ยถารฺถํ โปฺรกฺตวานฺ ยต เอกสฺมาทฺ อีศฺวราทฺ อโนฺย ทฺวิตีย อีศฺวโร นาสฺติ; ");
INSERT INTO santha_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","อปรํ สรฺวฺวานฺต:กรไณ: สรฺวฺวปฺราไณ: สรฺวฺวจิตฺไต: สรฺวฺวศกฺติภิศฺจ อีศฺวเร เปฺรมกรณํ ตถา สฺวมีปวาสินิ สฺววตฺ เปฺรมกรณญฺจ สรฺเวฺวโภฺย โหมพลิทานาทิภฺย: ศฺรษฺฐํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ตโต ยีศุ: สุพุทฺเธริว ตเสฺยทมฺ อุตฺตรํ ศฺรุตฺวา ตํ ภาษิตวานฺ ตฺวมีศฺวรสฺย ราชฺยานฺน ทูโรสิฯ อิต: ปรํ เตน สห กสฺยาปิ วากฺยสฺย วิจารํ กรฺตฺตำ กสฺยาปิ ปฺรคลฺภตา น ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","อนนฺตรํ มเธฺยมนฺทิรมฺ อุปทิศนฺ ยีศุริมํ ปฺรศฺนํ จการ, อธฺยาปกา อภิษิกฺตํ (ตารกํ) กุโต ทายูท: สนฺตานํ วทนฺติ? ");
INSERT INTO santha_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","สฺวยํ ทายูทฺ ปวิตฺรสฺยาตฺมน อาเวเศเนทํ กถยามาสฯ ยถาฯ \"มม ปฺรภุมิทํ วากฺยวทตฺ ปรเมศฺวร:ฯ ตว ศตฺรูนหํ ยาวตฺ ปาทปีฐํ กโรมิ นฯ ตาวตฺ กาลํ มทีเย ตฺวํ ทกฺษปารฺศฺวฺ อุปาวิศฯ \" ");
INSERT INTO santha_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ยทิ ทายูทฺ ตํ ปฺรภูํ วทติ ตรฺหิ กถํ ส ตสฺย สนฺตาโน ภวิตุมรฺหติ? อิตเร โลกาสฺตตฺกถำ ศฺรุตฺวานนนฺทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ตทานีํ ส ตานุปทิศฺย กถิตวานฺ เย นรา ทีรฺฆปริเธยานิ หฏฺเฏ วิปเนา จ ");
INSERT INTO santha_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","โลกกฺฤตนมสฺการานฺ ภชนคฺฤเห ปฺรธานาสนานิ โภชนกาเล ปฺรธานสฺถานานิ จ กางฺกฺษนฺเต; ");
INSERT INTO santha_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","วิธวานำ สรฺวฺวสฺวํ คฺรสิตฺวา ฉลาทฺ ทีรฺฆกาลํ ปฺรารฺถยนฺเต เตภฺย อุปาธฺยาเยภฺย: สาวธานา ภวต; เต'ธิกตรานฺ ทณฺฑานฺ ปฺราปฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ตทนนฺตรํ โลกา ภาณฺฑาคาเร มุทฺรา ยถา นิกฺษิปนฺติ ภาณฺฑาคารสฺย สมฺมุเข สมุปวิศฺย ยีศุสฺตทวลุโลก; ตทานีํ พหโว ธนินสฺตสฺย มเธฺย พหูนิ ธนานิ นิรกฺษิปนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ปศฺจาทฺ เอกา ทริทฺรา วิธวา สมาคตฺย ทฺวิปณมูลฺยำ มุไทฺรกำ ตตฺร นิรกฺษิปตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ตทา ยีศุ: ศิษฺยานฺ อาหูย กถิตวานฺ ยุษฺมานหํ ยถารฺถํ วทามิ เย เย ภาณฺฑาคาเร'สฺมิน ธนานิ นิ:กฺษิปนฺติ สฺม เตภฺย: สรฺเวฺวภฺย อิยํ วิธวา ทริทฺราธิกมฺ นิ:กฺษิปติ สฺมฯ ");
INSERT INTO santha_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ยตเสฺต ปฺรภูตธนสฺย กิญฺจิตฺ นิรกฺษิปนฺ กินฺตุ ทีเนยํ สฺวทินยาปนโยคฺยํ กิญฺจิทปิ น สฺถาปยิตฺวา สรฺวฺวสฺวํ นิรกฺษิปตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","อนนฺตรํ มนฺทิราทฺ พหิรฺคมนกาเล ตสฺย ศิษฺยาณาเมกสฺตํ วฺยาหฺฤตวานฺ เห คุโร ปศฺยตุ กีทฺฤศา: ปาษาณา: กีทฺฤกฺ จ นิจยนํฯ ");
INSERT INTO santha_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ตทา ยีศุสฺตมฺ อวทตฺ ตฺวํ กิเมตทฺ พฺฤหนฺนิจยนํ ปศฺยสิ? อไสฺยกปาษาโณปิ ทฺวิตียปาษาโณปริ น สฺถาสฺยติ สรฺเวฺว 'ธ:กฺเษปฺสฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","อถ ยสฺมินฺ กาเล ไชตุนฺคิเรา มนฺทิรสฺย สมฺมุเข ส สมุปวิษฺฏสฺตสฺมินฺ กาเล ปิตโร ยากูพฺ โยหนฺ อานฺทฺริยศฺไจเต ตํ รหสิ ปปฺรจฺฉุ:, ");
INSERT INTO santha_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","เอตา ฆฏนา: กทา ภวิษฺยนฺติ? ตไถตตฺสรฺวฺวาสำ สิทฺธฺยุปกฺรมสฺย วา กึ จิหฺนํ? ตทสฺมภฺยํ กถยตุ ภวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ตโต ยาศุสฺตานฺ วกฺตุมาเรเภ, โกปิ ยถา ยุษฺมานฺ น ภฺรามยติ ตถาตฺร ยูยํ สาวธานา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ยต: ขฺรีษฺโฏหมิติ กถยิตฺวา มม นามฺนาเนเก สมาคตฺย โลกานำ ภฺรมํ ชนยิษฺยนฺติ; ");
INSERT INTO santha_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","กินฺตุ ยูยํ รณสฺย วารฺตฺตำ รณาฑมฺพรญฺจ ศฺรุตฺวา มา วฺยากุลา ภวต, ฆฏนา เอตา อวศฺยมฺมาวินฺย:; กินฺตฺวาปาตโต น ยุคานฺโต ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","เทศสฺย วิปกฺษตยา เทโศ ราชฺยสฺย วิปกฺษตยา จ ราชฺยมุตฺถาสฺยติ, ตถา สฺถาเน สฺถาเน ภูมิกมฺโป ทุรฺภิกฺษํ มหาเกฺลศาศฺจ สมุปสฺถาสฺยนฺติ, สรฺวฺว เอเต ทุ:ขสฺยารมฺภา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","กินฺตุ ยูยมฺ อาตฺมารฺเถ สาวธานาสฺติษฺฐต, ยโต โลกา ราชสภายำ ยุษฺมานฺ สมรฺปยิษฺยนฺติ, ตถา ภชนคฺฤเห ปฺรหริษฺยนฺติ; ยูยํ มทรฺเถ เทศาธิปานฺ ภูปำศฺจ ปฺรติ สากฺษฺยทานาย เตษำ สมฺมุเข อุปสฺถาปยิษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","เศษีภวนาตฺ ปูรฺวฺวํ สรฺวฺวานฺ เทศียานฺ ปฺรติ สุสํวาท: ปฺรจารยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","กินฺตุ ยทา เต ยุษฺมานฺ ธฺฤตฺวา สมรฺปยิษฺยนฺติ ตทา ยูยํ ยทฺยทฺ อุตฺตรํ ทาสฺยถ, ตทคฺร ตสฺย วิเวจนํ มา กุรุต ตทรฺถํ กิญฺจิทปิ มา จินฺตยต จ, ตทานีํ ยุษฺมากํ มน:สุ ยทฺยทฺ วากฺยมฺ อุปสฺถาปยิษฺยเต ตเทว วทิษฺยถ, ยโต ยูยํ น ตทฺวกฺตาร: กินฺตุ ปวิตฺร อาตฺมา ตสฺย วกฺตาฯ ");
INSERT INTO santha_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ตทา ภฺราตา ภฺราตรํ ปิตา ปุตฺรํ ฆาตนารฺถํ ปรหเสฺตษุ สมรฺปยิษฺยเต, ตถา ปตฺยานิ มาตาปิโตฺร รฺวิปกฺษตยา เตา ฆาตยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","มม นามเหโต: สรฺเวฺวษำ สวิเธ ยูยํ ชุคุปฺสิตา ภวิษฺยถ, กินฺตุ ย: กศฺจิตฺ เศษปรฺยฺยนฺตํ ไธรฺยฺยมฺ อาลมฺพิษฺยเต เสอว ปริตฺราสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ทานิเยลฺภวิษฺยทฺวาทินา โปฺรกฺตํ สรฺวฺวนาศิ ชุคุปฺสิตญฺจ วสฺตุ ยทา ตฺวโยคฺยสฺถาเน วิทฺยมานํ ทฺรกฺษถ (โย ชน: ปฐติ ส พุธฺยตำ) ตทา เย ยิหูทียเทเศ ติษฺฐนฺติ เต มหีธฺรํ ปฺรติ ปลายนฺตำ; ");
INSERT INTO santha_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ตถา โย นโร คฺฤโหปริ ติษฺฐติ ส คฺฤหมธฺยํ นาวโรหตุ, ตถา กิมปิ วสฺตุ คฺรหีตุํ มเธฺยคฺฤหํ น ปฺรวิศตุ; ");
INSERT INTO santha_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ตถา จ โย นร: เกฺษเตฺร ติษฺฐติ โสปิ สฺววสฺตฺรํ คฺรหีตุํ ปราวฺฤตฺย น วฺรชตุฯ ");
INSERT INTO santha_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ตทานีํ ครฺพฺภวตีนำ สฺตนฺยทาตฺรีณาญฺจ โยษิตำ ทุรฺคติ รฺภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ยุษฺมากํ ปลายนํ ศีตกาเล ยถา น ภวติ ตทรฺถํ ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ยตสฺตทา ยาทฺฤศี ทุรฺฆฏนา ฆฏิษฺยเต ตาทฺฤศี ทุรฺฆฏนา อีศฺวรสฺฤษฺเฏ: ปฺรถมมารภฺยาทฺย ยาวตฺ กทาปิ น ชาตา น ชนิษฺยเต จฯ ");
INSERT INTO santha_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","อปรญฺจ ปรเมศฺวโร ยทิ ตสฺย สมยสฺย สํกฺเษปํ น กโรติ ตรฺหิ กสฺยาปิ ปฺราณภฺฤโต รกฺษา ภวิตุํ น ศกฺษฺยติ, กินฺตุ ยานฺ ชนานฺ มโนนีตานฺ อกโรตฺ เตษำ สฺวมโนนีตานำ เหโต: ส ตทเนหสํ สํกฺเษปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","อนฺยจฺจ ปศฺยต ขฺรีษฺโฏตฺร สฺถาเน วา ตตฺร สฺถาเน วิทฺยเต, ตสฺมินฺกาเล ยทิ กศฺจิทฺ ยุษฺมานฺ เอตาทฺฤศํ วากฺยํ วฺยาหรติ, ตรฺหิ ตสฺมินฺ วาเกฺย ไภว วิศฺวสิตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ยโตเนเก มิถฺยาขฺรีษฺฏา มิถฺยาภวิษฺยทฺวาทินศฺจ สมุปสฺถาย พหูนิ จิหฺนานฺยทฺภุตานิ กรฺมฺมาณิ จ ทรฺศยิษฺยนฺติ; ตถา ยทิ สมฺภวติ ตรฺหิ มโนนีตโลกานามปิ มิถฺยามตึ ชนยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ปศฺยต ฆฏนาต: ปูรฺวฺวํ สรฺวฺวการฺยฺยสฺย วารฺตฺตำ ยุษฺมภฺยมทามฺ, ยูยํ สาวธานาสฺติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","อปรญฺจ ตสฺย เกฺลศกาลสฺยาวฺยวหิเต ปรกาเล ภาสฺกร: สานฺธกาโร ภวิษฺยติ ตไถว จนฺทฺรศฺจนฺทฺริกำ น ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","นภ:สฺถานิ นกฺษตฺราณิ ปติษฺยนฺติ, โวฺยมมณฺฑลสฺถา คฺรหาศฺจ วิจลิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ตทานีํ มหาปรากฺรเมณ มไหศฺวรฺเยฺยณ จ เมฆมารุหฺย สมายานฺตํ มานวสุตํ มานวา: สมีกฺษิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","อนฺยจฺจ ส นิชทูตานฺ ปฺรหิตฺย นโภภูโมฺย: สีมำ ยาวทฺ ชคตศฺจตุรฺทิคฺภฺย: สฺวมโนนีตโลกานฺ สํคฺรหีษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","อุฑุมฺพรตโร รฺทฺฤษฺฏานฺตํ ศิกฺษธฺวํ ยโทฑุมฺพรสฺย ตโร รฺนวีนา: ศาขา ชายนฺเต ปลฺลวาทีนิ จ รฺนิคจฺฉนฺติ, ตทา นิทาฆกาล: สวิโธ ภวตีติ ยูยํ ชฺญาตุํ ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ตทฺวทฺ เอตา ฆฏนา ทฺฤษฺฏฺวา ส กาโล ทฺวารฺยฺยุปสฺถิต อิติ ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ยุษฺมานหํ ยถารฺถํ วทามิ, อาธุนิกโลกานำ คมนาตฺ ปูรฺวฺวํ ตานิ สรฺวฺวาณิ ฆฏิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ทฺยาวาปฺฤถิโวฺย รฺวิจลิตโย: สโตฺย รฺมทียา วาณี น วิจลิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","อปรญฺจ สฺวรฺคสฺถทูตคโณ วา ปุโตฺร วา ตาตาทนฺย: โกปิ ตํ ทิวสํ ตํ ทณฺฑํ วา น ชฺญาปยติฯ ");
INSERT INTO santha_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","อต: ส สมย: กทา ภวิษฺยติ, เอตชฺชฺญานาภาวาทฺ ยูยํ สาวธานาสฺติษฺฐต, สตรฺกาศฺจ ภูตฺวา ปฺรารฺถยธฺวํ; ");
INSERT INTO santha_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ยทฺวตฺ กศฺจิตฺ ปุมานฺ สฺวนิเวศนาทฺ ทูรเทศํ ปฺรติ ยาตฺรากรณกาเล ทาเสษุ สฺวการฺยฺยสฺย ภารมรฺปยิตฺวา สรฺวฺวานฺ เสฺว เสฺว กรฺมฺมณิ นิโยชยติ; อปรํ เทาวาริกํ ชาคริตุํ สมาทิศฺย ยาติ, ตทฺวนฺ นรปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","คฺฤหปติ: สายํกาเล นิศีเถ วา ตฺฤตียยาเม วา ปฺราต:กาเล วา กทาคมิษฺยติ ตทฺ ยูยํ น ชานีถ; ");
INSERT INTO santha_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ส หฐาทาคตฺย ยถา ยุษฺมานฺ นิทฺริตานฺ น ปศฺยติ, ตทรฺถํ ชาคริตาสฺติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ยุษฺมานหํ ยทฺ วทามิ ตเทว สรฺวฺวานฺ วทามิ, ชาคริตาสฺติษฺฐเตติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ตทา นิสฺตาโรตฺสวกิณฺวหีนปูโปตฺสวโยรารมฺภสฺย ทินทฺวเย 'วศิษฺเฏ ปฺรธานยาชกา อธฺยาปกาศฺจ เกนาปิ ฉเลน ยีศุํ ธรฺตฺตำ หนฺตุญฺจ มฺฤคยาญฺจกฺริเร; ");
INSERT INTO santha_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","กินฺตุ โลกานำ กลหภยาทูจิเร, นโจตฺสวกาล อุจิตเมตทิติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","อนนฺตรํ ไพถนิยาปุुเร ศิโมนกุษฺฐิโน คฺฤเห โยเศา โภตฺกุมุปวิษฺเฏ สติ กาจิทฺ โยษิตฺ ปาณฺฑรปาษาณสฺย สมฺปุฏเกน มหารฺโฆฺยตฺตมไตลมฺ อานีย สมฺปุฏกํ ภํกฺตฺวา ตโสฺยตฺตมางฺเค ไตลธารำ ปาตยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ตสฺมาตฺ เกจิตฺ สฺวานฺเต กุปฺยนฺต: กถิตวํนฺต: กุโตยํ ไตลาปวฺยย:? ");
INSERT INTO santha_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ยเทฺยตตฺ ไตล วฺยเกฺรษฺยต ตรฺหิ มุทฺราปาทศตตฺรยาทปฺยธิกํ ตสฺย ปฺราปฺตมูลฺยํ ทริทฺรโลเกโภฺย ทาตุมศกฺษฺยต, กถาเมตำ กถยิตฺวา ตยา โยษิตา สากํ วาจายุหฺยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","กินฺตุ ยีศุรุวาจ, กุต เอตไสฺย กฺฤจฺฉฺรํ ททาสิ? มหฺยมิยํ กรฺมฺโมตฺตมํ กฺฤตวตีฯ ");
INSERT INTO santha_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ทริทฺรา: สรฺวฺวทา ยุษฺมาภิ: สห ติษฺฐนฺติ, ตสฺมาทฺ ยูยํ ยเทจฺฉถ ตไทว ตานุปกรฺตฺตำ ศกฺนุถ, กินฺตฺวหํ ยุภาภิ: สห นิรนฺตรํ น ติษฺฐามิฯ ");
INSERT INTO santha_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","อสฺยา ยถาสาธฺยํ ตไถวากโรทิยํ, ศฺมศานยาปนาตฺ ปูรฺวฺวํ สเมตฺย มทฺวปุษิ ไตลมฺ อมรฺทฺทยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","อหํ ยุษฺมภฺยํ ยถารฺถํ กถยามิ, ชคตำ มเธฺย ยตฺร ยตฺร สุสํวาโทยํ ปฺรจารยิษฺยเต ตตฺร ตตฺร โยษิต เอตสฺยา: สฺมรณารฺถํ ตตฺกฺฤตกรฺมฺไมตตฺ ปฺรจารยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ตต: ปรํ ทฺวาทศานำ ศิษฺยาณาเมก อีษฺกริโยตียยิหูทาโขฺย ยีศุํ ปรกเรษุ สมรฺปยิตุํ ปฺรธานยาชกานำ สมีปมิยายฯ ");
INSERT INTO santha_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","เต ตสฺย วากฺยํ สมากรฺณฺย สนฺตุษฺฏา: สนฺตสฺตไสฺม มุทฺรา ทาตุํ ปฺรตฺยชานต; ตสฺมาตฺ ส ตํ เตษำ กเรษุ สมรฺปณาโยปายํ มฺฤคยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","อนนฺตรํ กิณฺวศูนฺยปูโปตฺสวสฺย ปฺรถเม'หนิ นิสฺตาโรตฺมวารฺถํ เมษมารณาสมเย ศิษฺยาสฺตํ ปปฺรจฺฉ: กุตฺร คตฺวา วยํ นิสฺตาโรตฺสวสฺย โภชฺยมาสาทยิษฺยาม:? กิมิจฺฉติ ภวานฺ? ");
INSERT INTO santha_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ตทานีํ ส เตษำ ทฺวยํ เปฺรรยนฺ พภาเษ ยุวโย: ปุรมธฺยํ คตโย: สโต โรฺย ชน: สชลกุมฺภํ วหนฺ ยุวำ สากฺษาตฺ กริษฺยติ ตไสฺยว ปศฺจาทฺ ยาตํ; ");
INSERT INTO santha_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ส ยตฺ สทนํ ปฺรเวกฺษฺยติ ตทฺภวนปตึ วทตํ, คุรุราห ยตฺร สศิโษฺยหํ นิสฺตาโรตฺสวียํ โภชนํ กริษฺยามิ, สา โภชนศาลา กุตฺราสฺติ? ");
INSERT INTO santha_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ตต: ส ปริษฺกฺฤตำ สุสชฺชิตำ พฺฤหตีจญฺจ ยำ ศาลำ ทรฺศยิษฺยติ ตสฺยามสฺมทรฺถํ โภชฺยทฺรวฺยาณฺยาสาทยตํฯ ");
INSERT INTO santha_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ตต: ศิเษฺยา ปฺรสฺถาย ปุรํ ปฺรวิศฺย ส ยโถกฺตวานฺ ตไถว ปฺราปฺย นิสฺตาโรตฺสวสฺย โภชฺยทฺรวฺยาณิ สมาสาทเยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","อนนฺตรํ ยีศุ: สายํกาเล ทฺวาทศภิ: ศิไษฺย: สารฺทฺธํ ชคาม; ");
INSERT INTO santha_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","สรฺเวฺวษุ โภชนาย โปฺรปวิษฺเฏษุ ส ตานุทิตวานฺ ยุษฺมานหํ ยถารฺถํ วฺยาหรามิ, อตฺร ยุษฺมากเมโก ชโน โย มยา สห ภุํกฺเต มำ ปรเกเรษุ สมรฺปยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ตทานีํ เต ทุ:ขิตา: สนฺต เอไกกศสฺตํ ปฺรษฺฏุมารพฺธวนฺต: ส กิมหํ? ปศฺจาทฺ อนฺย เอโกภิทเธ ส กิมหํ? ");
INSERT INTO santha_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ตต: ส ปฺรตฺยวททฺ เอเตษำ ทฺวาทศานำ โย ชโน มยา สมํ โภชนาปาเตฺร ปาณึ มชฺชยิษฺยติ ส เอวฯ ");
INSERT INTO santha_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","มนุชตนยมธิ ยาทฺฤศํ ลิขิตมาเสฺต ตทนุรูปา คติสฺตสฺย ภวิษฺยติ, กินฺตุ โย ชโน มานวสุตํ สมรฺปยิษฺยเต หนฺต ตสฺย ชนฺมาภาเว สติ ภทฺรมภวิษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","อปรญฺจ เตษำ โภชนสมเย ยีศุ: ปูปํ คฺฤหีเตฺวศฺวรคุณานฺ อนุกีรฺตฺย ภงฺกฺตฺวา เตโภฺย ทตฺตฺวา พภาเษ, เอตทฺ คฺฤหีตฺวา ภุญฺชีธฺวมฺ เอตนฺมม วิคฺรหรูปํฯ ");
INSERT INTO santha_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","อนนฺตรํ ส กํสํ คฺฤหีเตฺวศฺวรสฺย คุณานฺ กีรฺตฺตยิตฺวา เตโภฺย ทเทา, ตตเสฺต สรฺเวฺว ปปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","อปรํ ส ตานวาทีทฺ พหูนำ นิมิตฺตํ ปาติตํ มม นวีนนิยมรูปํ โศณิตเมตตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ยุษฺมานหํ ยถารฺถํ วทามิ, อีศฺวรสฺย ราเชฺย ยาวตฺ สโทฺยชาตํ ทฺรากฺษารสํ น ปาสฺยามิ,ตาวทหํ ทฺรากฺษาผลรสํ ปุน รฺน ปาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ตทนนฺตรํ เต คีตเมกํ สํคีย พหิ ไรฺชตุนํ ศิขริณํ ยยุ: ");
INSERT INTO santha_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","อถ ยีศุสฺตานุวาจ นิศายามสฺยำ มยิ ยุษฺมากํ สรฺเวฺวษำ ปฺรตฺยูโห ภวิษฺยติ ยโต ลิขิตมาเสฺต ยถา, เมษาณำ รกฺษกญฺจาหํ ปฺรหริษฺยามิ ไว ตต:ฯ เมษาณำ นิวโห นูนํ ปฺรวิกีรฺโณ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","กนฺตุ มทุตฺถาเน ชาเต ยุษฺมากมเคฺร'หํ คาลีลํ วฺรชิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ตทา ปิตร: ปฺรติพภาเษ, ยทฺยปิ สรฺเวฺวษำ ปฺรตฺยูโห ภวติ ตถาปิ มม ไนว ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ตโต ยีศุรุกฺตาวานฺ อหํ ตุภฺยํ ตถฺยํ กถยามิ, กฺษณาทายามทฺย กุกฺกุฏสฺย ทฺวิตียวารรวณาตฺ ปูรฺวฺวํ ตฺวํ วารตฺรยํ มามปโหฺนษฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","กินฺตุ ส คาฒํ วฺยาหรทฺ ยทฺยปิ ตฺวยา สารฺทฺธํ มม ปฺราโณ ยาติ ตถาปิ กถมปิ ตฺวำ นาปโหฺนเษฺย; สรฺเวฺว'ปีตเร ตไถว พภาษิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","อปรญฺจ เตษุ เคตฺศิมานีนามกํ สฺถาน คเตษุ ส ศิษฺยานฺ ชคาท, ยาวทหํ ปฺรารฺถเย ตาวทตฺร สฺถาเน ยูยํ สมุปวิศตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","อถ ส ปิตรํ ยากูพํ โยหนญฺจ คฺฤหีตฺวา ววฺราช; อตฺยนฺตํ ตฺราสิโต วฺยากุลิตศฺจ เตภฺย: กถยามาส, ");
INSERT INTO santha_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","นิธนกาลวตฺ ปฺราโณ เม'ตีว ท:ขเมติ, ยูยํ ชาคฺรโตตฺร สฺถาเน ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ตต: ส กิญฺจิทฺทูรํ คตฺวา ภูมาวโธมุข: ปติตฺวา ปฺรารฺถิตวาเนตตฺ, ยทิ ภวิตุํ ศกฺยํ ตรฺหิ ทุ:ขสมโยยํ มตฺโต ทูรีภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","อปรมุทิตวานฺ เห ปิต เรฺห ปิต: สรฺเวฺวํ ตฺวยา สาธฺยํ, ตโต เหโตริมํ กํสํ มตฺโต ทูรีกุรุ, กินฺตุ ตนฺ มเมจฺฉาโต น ตเวจฺฉาโต ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ตต: ปรํ ส เอตฺย ตานฺ นิทฺริตานฺ นิรีกฺษฺย ปิตรํ โปฺรวาจ, ศิโมนฺ ตฺวํ กึ นิทฺราสิ? ฆฏิกาเมกามฺ อปิ ชาคริตุํ น ศกฺโนษิ? ");
INSERT INTO santha_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ปรีกฺษายำ ยถา น ปตถ ตทรฺถํ สเจตนา: สนฺต: ปฺรารฺถยธฺวํ; มน อุทฺยุกฺตมิติ สตฺยํ กินฺตุ วปุรศกฺติกํฯ ");
INSERT INTO santha_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","อถ ส ปุนรฺวฺรชิตฺวา ปูรฺวฺววตฺ ปฺรารฺถยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ปราวฺฤตฺยาคตฺย ปุนรปิ ตานฺ นิทฺริตานฺ ททรฺศ ตทา เตษำ โลจนานิ นิทฺรยา ปูรฺณานิ, ตสฺมาตฺตไสฺม กา กถา กถยิตวฺยา ต เอตทฺ โพทฺธุํ น เศกุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ตต:ปรํ ตฺฤตียวารํ อาคตฺย เตโภฺย 'กถยทฺ อิทานีมปิ ศยิตฺวา วิศฺรามฺยถ? ยเถษฺฏํ ชาตํ, สมยศฺโจปสฺถิต: ปศฺยต มานวตนย: ปาปิโลกานำ ปาณิษุ สมรฺปฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","อุตฺติษฺฐต, วยํ วฺรชาโม โย ชโน มำ ปรปาณิษุ สมรฺปยิษฺยเต ปศฺยต ส สมีปมายาต:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","อิมำ กถำ กถยติ ส, เอตรฺหิทฺวาทศานาเมโก ยิหูทา นามา ศิษฺย: ปฺรธานยาชกานามฺ อุปาธฺยายานำ ปฺราจีนโลกานาญฺจ สนฺนิเธ: ขงฺคลคุฑธาริโณ พหุโลกานฺ คฺฤหีตฺวา ตสฺย สมีป อุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","อปรญฺจาเสา ปรปาณิษุ สมรฺปยิตา ปูรฺวฺวมิติ สงฺเกตํ กฺฤตวานฺ ยมหํ จุมฺพิษฺยามิ ส เอวาเสา ตเมว ธฺฤตฺวา สาวธานํ นยตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","อโต เหโต: ส อาคไตฺยว โยโศ: สวิธํ คตฺวา เห คุโร เห คุโร, อิตฺยุกฺตฺวา ตํ จุจุมฺพฯ ");
INSERT INTO santha_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ตทา เต ตทุปริ ปาณีนรฺปยิตฺวา ตํ ทธฺนุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ตตสฺตสฺย ปารฺศฺวสฺถานำ โลกานาเมก: ขงฺคํ นิษฺโกษยนฺ มหายาชกสฺย ทาสเมกํ ปฺรหฺฤตฺย ตสฺย กรฺณํ จิจฺเฉทฯ ");
INSERT INTO santha_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ปศฺจาทฺ ยีศุสฺตานฺ วฺยาชหาร ขงฺคานฺ ลคุฑำศฺจ คฺฤหีตฺวา มำ กึ เจารํ ธรฺตฺตำ สมายาตา:? ");
INSERT INTO santha_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","มเธฺยมนฺทิรํ สมุปทิศนฺ ปฺรตฺยหํ ยุษฺมาภิ: สห สฺถิตวานตหํ, ตสฺมินฺ กาเล ยูยํ มำ นาทีธรต, กินฺตฺวเนน ศาสฺตฺรียํ วจนํ เสธนียํฯ ");
INSERT INTO santha_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ตทา สรฺเวฺว ศิษฺยาสฺตํ ปริตฺยชฺย ปลายาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","อไถโก ยุวา มานโว นคฺนกาเย วสฺตฺรเมกํ นิธาย ตสฺย ปศฺจาทฺ วฺรชนฺ ยุวโลไก รฺธฺฤโต ");
INSERT INTO santha_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","วสฺตฺรํ วิหาย นคฺน: ปลายาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","อปรญฺจ ยสฺมินฺ สฺถาเน ปฺรธานยาชกา อุปาธฺยายา: ปฺราจีนโลกาศฺจ มหายาชเกน สห สทสิ สฺถิตาสฺตสฺมินฺ สฺถาเน มหายาชกสฺย สมีปํ ยีศุํ นินฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ปิตโร ทูเร ตตฺปศฺจาทฺ อิตฺวา มหายาชกสฺยาฏฺฏาลิกำ ปฺรวิศฺย กิงฺกไร: สโหปวิศฺย วหฺนิตาปํ ชคฺราหฯ ");
INSERT INTO santha_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ตทานีํ ปฺรธานยาชกา มนฺตฺริณศฺจ ยีศุํ ฆาตยิตุํ ตตฺปฺราติกูเลฺยน สากฺษิโณ มฺฤคยาญฺจกฺริเร, กินฺตุ น ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","อเนไกสฺตทฺวิรุทฺธํ มฺฤษาสากฺเษฺย ทตฺเตปิ เตษำ วากฺยานิ น สมคจฺฉนฺตฯ ");
INSERT INTO santha_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","สรฺวฺวเศเษ กิยนฺต อุตฺถาย ตสฺย ปฺราติกูเลฺยน มฺฤษาสากฺษฺยํ ทตฺตฺวา กถยามาสุ:, ");
INSERT INTO santha_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","อิทํ กรกฺฤตมนฺทิรํ วินาศฺย ทินตฺรยมเธฺย ปุนรปรมฺ อกรกฺฤตํ มนฺทิรํ นิรฺมฺมาสฺยามิ, อิติ วากฺยมฺ อสฺย มุขาตฺ ศฺรุตมสฺมาภิริติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","กินฺตุ ตตฺราปิ เตษำ สากฺษฺยกถา น สงฺคาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","อถ มหายาชโก มเธฺยสภมฺ อุตฺถาย ยีศุํ วฺยาชหาร, เอเต ชนาสฺตฺวยิ ยตฺ สากฺษฺยมทุ: ตฺวเมตสฺย กิมปฺยุตฺตรํ กึ น ทาสฺยสิ? ");
INSERT INTO santha_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","กินฺตุ ส กิมปฺยุตฺตรํ น ทตฺวา เมานีภูย ตเสฺยา; ตโต มหายาชก: ปุนรปิ ตํ ปฺฤษฺฏาวานฺ ตฺวํ สจฺจิทานนฺทสฺย ตนโย 'ภิษิกฺตสฺตฺรตา? ");
INSERT INTO santha_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ตทา ยีศุสฺตํ โปฺรวาจ ภวามฺยหมฺ ยูยญฺจ สรฺวฺวศกฺติมโต ทกฺษีณปารฺเศฺว สมุปวิศนฺตํ เมฆ มารุหฺย สมายานฺตญฺจ มนุษฺยปุตฺรํ สนฺทฺรกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ตทา มหายาชก: สฺวํ วมนํ ฉิตฺวา วฺยาวหรตฺ ");
INSERT INTO santha_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","กิมสฺมากํ สากฺษิภิ: ปฺรโยชนมฺ? อีศฺวรนินฺทาวากฺยํ ยุษฺมาภิรศฺราวิ กึ วิจารยถ? ตทานีํ สรฺเวฺว ชคทุรยํ นิธนทณฺฑมรฺหติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ตต: กศฺจิตฺ กศฺจิตฺ ตทฺวปุษิ นิษฺฐีวํ นิจิกฺเษป ตถา ตนฺมุขมาจฺฉาทฺย จเปเฏน หตฺวา คทิตวานฺ คณยิตฺวา วท, อนุจราศฺจ จเปไฏสฺตมาชฆฺนุ: ");
INSERT INTO santha_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ตต: ปรํ ปิตเร'ฏฺฏาลิกาธ:โกษฺเฐ ติษฺฐติ มหายาชกไสฺยกา ทาสี สเมตฺย ");
INSERT INTO santha_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ตํ วิหฺนิตาปํ คฺฤหฺลนฺตํ วิโลกฺย ตํ สุนิรีกฺษฺย พภาเษ ตฺวมปิ นาสรตียยีโศ: สงฺคินามฺ เอโก ชน อาสี:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","กินฺตุ โสปหฺนุตฺย ชคาท ตมหํ น วทฺมิ ตฺวํ ยตฺ กถยมิ ตทปฺยหํ น พุทฺเธฺยฯ ตทานีํ ปิตเร จตฺวรํ คตวติ กุेกฺกุโฏ รุราวฯ ");
INSERT INTO santha_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","อถานฺยา ทาสี ปิตรํ ทฺฤษฺฏฺวา สมีปสฺถานฺ ชนานฺ ชคาท อยํ เตษาเมโก ชน:ฯ ");
INSERT INTO santha_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ตต: ส ทฺวิตียวารมฺ อปหฺนุตวานฺ ปศฺจาตฺ ตตฺรสฺถา โลกา: ปิตรํ โปฺรจุสฺตฺวมวศฺยํ เตษาเมโก ชน: ยตสฺตฺวํ คาลีลีโย นร อิติ ตโวจฺจารณํ ปฺรกาศยติฯ ");
INSERT INTO santha_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ตทา ส ศปถาภิศาเปา กฺฤตฺวา โปฺรวาจ ยูยํ กถำ กถยถ ตํ นรํ น ชาเน'หํฯ ");
INSERT INTO santha_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ตทานีํ ทฺวิตียวารํ กุกฺกุโฏ 'ราวีตฺฯ กุกฺกุฏสฺย ทฺวิตียรวาตฺ ปูรฺวฺวํ ตฺวํ มำ วารตฺรยมฺ อปโหฺนษฺยสิ, อิติ ยทฺวากฺยํ ยีศุนา สมุทิตํ ตตฺ ตทา สํสฺมฺฤตฺย ปิตโร โรทิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","อถ ปฺรภาเต สติ ปฺรธานยาชกา: ปฺราญฺจ อุปาธฺยายา: สรฺเวฺว มนฺตฺริณศฺจ สภำ กฺฤตฺวา ยีศุृํ พนฺธยิตฺว ปีลาตาขฺยสฺย เทศาธิปเต: สวิธํ นีตฺวา สมรฺปยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ตทา ปีลาตสฺตํ ปฺฤษฺฏวานฺ ตฺวํ กึ ยิหูทียโลกานำ ราชา? ตต: ส ปฺรตฺยุกฺตวานฺ สตฺยํ วทสิฯ ");
INSERT INTO santha_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","อปรํ ปฺรธานยาชกาสฺตสฺย พหุษุ วาเกฺยษุ โทษมาโรปยาญฺจกฺรุ: กินฺตุ ส กิมปิ น ปฺรตฺยุวาจฯ ");
INSERT INTO santha_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ตทานีํ ปีลาตสฺตํ ปุน: ปปฺรจฺฉ ตฺวํ กึ โนตฺตรยสิ? ปไศฺยเต ตฺวทฺวิรุทฺธํ กติษุ สาเธฺยษุ สากฺษํ ททติฯ ");
INSERT INTO santha_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","กนฺตุ ยีศุสฺตทาปิ โนตฺตรํ ทเทา ตต: ปีลาต อาศฺจรฺยฺยํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","อปรญฺจ การาพทฺเธ กสฺตึศฺจิตฺ ชเน ตนฺมโหตฺสวกาเล โลไก รฺยาจิเต เทศาธิปติสฺตํ โมจยติฯ ");
INSERT INTO santha_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","เย จ ปูรฺวฺวมุปปฺลวมการฺษุรุปปฺลเว วธมปิ กฺฤตวนฺตเสฺตษำ มเธฺย ตทาโนํ พรพฺพานามก เอโก พทฺธ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","อโต เหโต: ปูรฺวฺวาปรียำ รีติกถำ กถยิตฺวา โลกา อุจฺไจรุวนฺต: ปีลาตสฺย สมกฺษํ นิเวทยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ตทา ปีลาตสฺตานาจเขฺยา ตรฺหิ กึ ยิหูทียานำ ราชานํ โมจยิษฺยามิ? ยุษฺมาภิ: กิมิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ยต: ปฺรธานยาชกา อีรฺษฺยาต เอว ยีศุํ สมารฺปยนฺนิติ ส วิเวทฯ ");
INSERT INTO santha_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","กินฺตุ ยถา พรพฺพำ โมจยติ ตถา ปฺรารฺถยิตุํ ปฺรธานยาชกา โลกานฺ ปฺรวรฺตฺตยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","อถ ปีลาต: ปุน: ปฺฤษฺฏวานฺ ตรฺหิ ยํ ยิหูทียานำ ราเชติ วทถ ตสฺย กึ กริษฺยามิ ยุษฺมาภิ: กิมิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ตทา เต ปุนรปิ โปฺรจฺไจ: โปฺรจุสฺตํ กฺรุเศ เวธยฯ ");
INSERT INTO santha_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ตสฺมาตฺ ปีลาต: กถิตวานฺ กุต:? ส กึ กุกรฺมฺม กฺฤตวานฺ? กินฺตุ เต ปุนศฺจ รุวนฺโต วฺยาชหฺรุสฺตํ กฺรุเศ เวธยฯ ");
INSERT INTO santha_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ตทา ปีลาต: สรฺวฺวาโลฺลกานฺ โตษยิตุมิจฺฉนฺ พรพฺพำ โมจยิตฺวา ยีศุํ กศาภิ: ปฺรหฺฤตฺย กฺรุเศ เวทฺธุํ ตํ สมรฺปยามฺพภูวฯ ");
INSERT INTO santha_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","อนนฺตรํ ไสนฺยคโณ'ฏฺฏาลิกามฺ อรฺถาทฺ อธิปเต รฺคฺฤหํ ยีศุํ นีตฺวา เสนานิวหํ สมาหุยตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ปศฺจาตฺ เต ตํ ธูมลวรฺณวสฺตฺรํ ปริธาปฺย กณฺฏกมุกุฏํ รจยิตฺวา ศิรสิ สมาโรปฺย ");
INSERT INTO santha_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","เห ยิหูทียานำ ราชนฺ นมสฺการ อิตฺยุกฺตฺวา ตํ นมสฺกรฺตฺตามาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ตโสฺยตฺตมางฺเค เวตฺราฆาตํ จกฺรุสฺตทฺคาเตฺร นิษฺฐีวญฺจ นิจิกฺษิปุ:, ตถา ตสฺย สมฺมุเข ชานุปาตํ ปฺรโณมุ: ");
INSERT INTO santha_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","อิตฺถมุปหสฺย ธูมฺรวรฺณวสฺตฺรมฺ อุตฺตารฺยฺย ตสฺย วสฺตฺรํ ตํ ปรฺยฺยธาปยนฺ กฺรุเศ เวทฺธุํ พหิรฺนินฺยุศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ตต: ปรํ เสกนฺทรสฺย รุผสฺย จ ปิตา ศิโมนฺนามา กุรีณียโลก เอก: กุตศฺจิทฺ คฺรามาเทตฺย ปถิ ยาติ ตํ เต ยีโศ: กฺรุศํ โวฒุํ พลาทฺ ทธฺนุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","อถ คุลฺคลฺตา อรฺถาตฺ ศิร:กปาลนามกํ สฺถานํ ยีศุมานีย ");
INSERT INTO santha_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","เต คนฺธรสมิศฺริตํ ทฺรากฺษารสํ ปาตุํ ตไสฺม ททุ: กินฺตุ ส น ชคฺราหฯ ");
INSERT INTO santha_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ตสฺมินฺ กฺรุเศ วิทฺเธ สติ เตษาเมไกกศ: กึ ปฺราปฺสฺยตีติ นิรฺณยาย ");
INSERT INTO santha_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ตสฺย ปริเธยานำ วิภาคารฺถํ คุฏิกาปาตํ จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","อปรมฺ เอษ ยิหูทียานำ ราเชติ ลิขิตํ โทษปตฺรํ ตสฺย ศิรอูรฺทฺวฺวมฺ อาโรปยาญฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ตสฺย วามทกฺษิณโย รฺเทฺวา เจาเรา กฺรุศโย รฺวิวิธาเตฯ ");
INSERT INTO santha_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","เตไนว \"อปราธิชไน: สารฺทฺธํ ส คณิโต ภวิษฺยติ,\" อิติ ศาสฺโตฺรกฺตํ วจนํ สิทฺธมภูตฯ ");
INSERT INTO santha_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","อนนฺตรํ มารฺเค เย เย โลกา คมนาคมเน จกฺรุเสฺต สรฺวฺว เอว ศิรำสฺยานฺโทลฺย นินฺทนฺโต ชคทุ:, เร มนฺทิรนาศก เร ทินตฺรยมเธฺย ตนฺนิรฺมฺมายก, ");
INSERT INTO santha_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","อธุนาตฺมานมฺ อวิตฺวา กฺรุศาทวโรหฯ ");
INSERT INTO santha_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","กิญฺจ ปฺรธานยาชกา อธฺยาปกาศฺจ ตทฺวตฺ ติรสฺกฺฤตฺย ปรสฺปรํ จจกฺษิเร เอษ ปรานาวตฺ กินฺตุ สฺวมวิตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ยทีสฺราเยโล ราชาภิษิกฺตสฺตฺราตา ภวติ ตรฺหฺยธุไนน กฺรุศาทวโรหตุ วยํ ตทฺ ทฺฤษฺฏฺวา วิศฺวสิษฺยาม:; กิญฺจ เยา โลเกา เตน สารฺทฺธํ กฺรุเศ 'วิเธฺยตำ ตาวปิ ตํ นิรฺภรฺตฺสยามาสตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","อถ ทฺวิตียยามาตฺ ตฺฤตียยามํ ยาวตฺ สรฺโวฺว เทศ: สานฺธกาโรภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ตตสฺตฺฤตียปฺรหเร ยีศุรุจฺไจรวทตฺ เอลี เอลี ลามา ศิวกฺตนี อรฺถาทฺ \"เห มทีศ มทีศ ตฺวํ ปรฺยฺยตฺยากฺษี: กุโต หิ มำ?\" ");
INSERT INTO santha_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ตทา สมีปสฺถโลกานำ เกจิตฺ ตทฺวากฺยํ นิศมฺยาจขฺยุ: ปไศฺยษ เอลิยมฺ อาหูยติฯ ");
INSERT INTO santha_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ตต เอโก ชโน ธาวิตฺวาคตฺย สฺปญฺเช 'มฺลรสํ ปูรยิตฺวา ตํ นฑาเคฺร นิธาย ปาตุํ ตไสฺม ทตฺตฺวาวทตฺ ติษฺฐ เอลิย เอนมวโรหยิตุมฺ เอติ น เวติ ปศฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","อถ ยีศุรุจฺไจ: สมาหูย ปฺราณานฺ ชเหาฯ ");
INSERT INTO santha_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ตทา มนฺทิรสฺย ชวนิโกรฺทฺวฺวาทธ:รฺยฺยนฺตา วิทีรฺณา ทฺวิขณฺฑาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","กิญฺจ อิตฺถมุจฺไจราหูย ปฺราณานฺ ตฺยชนฺตํ ตํ ทฺฤษฺทฺวา ตทฺรกฺษณาย นิยุกฺโต ย: เสนาปติราสีตฺ โสวทตฺ นโรยมฺ อีศฺวรปุตฺร อิติ สตฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ตทานีํ มคฺทลีนี มริสมฺ กนิษฺฐยากูโพ โยเสศฺจ มาตานฺยมริยมฺ ศาโลมี จ ยา: สฺตฺริโย ");
INSERT INTO santha_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","คาลีลฺปฺรเทเศ ยีศุํ เสวิตฺวา ตทนุคามิโนฺย ชาตา อิมาสฺตทนฺยาศฺจ ยา อเนกา นาโรฺย ยีศุนา สารฺทฺธํ ยิรูศาลมมายาตาสฺตาศฺจ ทูราตฺ ตานิ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","อถาสาทนทินสฺยารฺถาทฺ วิศฺรามวาราตฺ ปูรฺวฺวทินสฺย สายํกาล อาคต ");
INSERT INTO santha_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","อีศฺวรราชฺยาเปกฺษฺยริมถียยูษผนามา มานฺยมนฺตฺรี สเมตฺย ปีลาตสวิธํ นิรฺภโย คตฺวา ยีโศรฺเทหํ ยยาเจฯ ");
INSERT INTO santha_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","กินฺตุ ส อิทานีํ มฺฤต: ปีลาต อิตฺยสมฺภวํ มตฺวา ศตเสนาปติมาหูย ส กทา มฺฤต อิติ ปปฺรจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ศตเสมนาปติมุขาตฺ ตชฺชฺญาตฺวา ยูษเผ ยีโศรฺเทหํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ปศฺจาตฺ ส สูกฺษฺมํ วาส: กฺรีตฺวา ยีโศ: กายมวโรหฺย เตน วาสสา เวษฺฏายิตฺวา คิเรา ขาตศฺมศาเน สฺถาปิตวานฺ ปาษาณํ โลฐยิตฺวา ทฺวาริ นิทเธฯ ");
INSERT INTO santha_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","กินฺตุ ยตฺร โสสฺถาปฺยต ตต มคฺทลีนี มริยมฺ โยสิมาตฺฤมริยมฺ จ ททฺฤศตฺฤ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","อถ วิศฺรามวาเร คเต มคฺทลีนี มริยมฺ ยากูพมาตา มริยมฺ ศาโลมี เจมาสฺตํ มรฺทฺทยิตุํ สุคนฺธิทฺรวฺยาณิ กฺรีตฺวา ");
INSERT INTO santha_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","สปฺตาหปฺรถมทิเน'ติปฺรตฺยูเษ สูรฺโยฺยทยกาเล ศฺมศานมุปคตา:ฯ ");
INSERT INTO santha_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","กินฺตุ ศฺมศานทฺวารปาษาโณ'ติพฺฤหนฺ ตํ โก'ปสารยิษฺยตีติ ตา: ปรสฺปรํ คทนฺติ! ");
INSERT INTO santha_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","เอตรฺหิ นิรีกฺษฺย ปาษาโณ ทฺวาโร 'ปสาริต อิติ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ปศฺจาตฺตา: ศฺมศานํ ปฺรวิศฺย ศุกฺลวรฺณทีรฺฆปริจฺฉทาวฺฤตเมกํ ยุวานํ ศฺมศานทกฺษิณปารฺศฺว อุปวิษฺฏํ ทฺฤษฺฏฺวา จมจฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","โส'วทตฺ, มาไภษฺฏ ยูยํ กฺรุเศ หตํ นาสรตียยีศุํ คเวษยถ โสตฺร นาสฺติ ศฺมศานาทุทสฺถาตฺ; ไต รฺยตฺร ส สฺถาปิต: สฺถานํ ตทิทํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","กินฺตุ เตน ยโถกฺตํ ตถา ยุษฺมากมเคฺร คาลีลํ ยาสฺยเต ตตฺร ส ยุษฺมานฺ สากฺษาตฺ กริษฺยเต ยูยํ คตฺวา ตสฺย ศิเษฺยภฺย: ปิตราย จ วารฺตฺตามิมำ กถยตฯ ");
INSERT INTO santha_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ตา: กมฺปิตา วิสฺติตาศฺจ ตูรฺณํ ศฺมศานาทฺ พหิรฺคตฺวา ปลายนฺต ภยาตฺ กมปิ กิมปิ นาวทํศฺจฯ ");
INSERT INTO santha_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","อปรํ ยีศุ: สปฺตาหปฺรถมทิเน ปฺรตฺยูเษ ศฺมศานาทุตฺถาย ยสฺยา: สปฺตภูตาสฺตฺยาชิตาสฺตไสฺย มคฺทลีนีมริยเม ปฺรถมํ ทรฺศนํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ตต: สา คตฺวา โศกโรทนกฺฤทฺโภฺย'นุคตโลเกภฺยสฺตำ วารฺตฺตำ กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","กินฺตุ ยีศุ: ปุนรฺชีวนฺ ตไสฺย ทรฺศนํ ทตฺตวานิติ ศฺรุตฺวา เต น ปฺรตฺยยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ปศฺจาตฺ เตษำ ทฺวาโย รฺคฺรามยานกาเล ยีศุรนฺยเวศํ ธฺฤตฺวา ตาภฺยำ ทรฺศน ทเทา! ");
INSERT INTO santha_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ตาวปิ คตฺวานฺยศิเษฺยภฺยสฺตำ กถำ กถยาญฺจกฺรตุ: กินฺตุ ตโย: กถามปิ เต น ปฺรตฺยยนฺฯ ");
INSERT INTO santha_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","เศษต เอกาทศศิเษฺยษุ โภชโนปวิษฺเฏษุ ยีศุเสฺตโภฺย ทรฺศนํ ทเทา ตโถตฺถานาตฺ ปรํ ตทฺทรฺศนปฺราปฺตโลกานำ กถายามวิศฺวาสกรณาตฺ เตษามวิศฺวาสมน:กาฐินฺยาภฺยำ เหตุภฺยำ ส ตำสฺตรฺชิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","อถ ตานาจเขฺยา ยูยํ สรฺวฺวชคทฺ คตฺวา สรฺวฺวชนานฺ ปฺรติ สุสํวาทํ ปฺรจารยตฯ ");
INSERT INTO santha_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ตตฺร ย: กศฺจิทฺ วิศฺวสฺย มชฺชิโต ภเวตฺ ส ปริตฺราสฺยเต กินฺตุ โย น วิศฺวสิษฺยติ ส ทณฺฑยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","กิญฺจ เย ปฺรเตฺยษฺยนฺติ ไตรีทฺฤคฺ อาศฺจรฺยฺยํ กรฺมฺม ปฺรกาศยิษฺยเต เต มนฺนามฺนา ภูตานฺ ตฺยาชยิษฺยนฺติ ภาษา อนฺยาศฺจ วทิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","อปรํ ไต: สรฺเปษุ ธฺฤเตษุ ปฺราณนาศกวสฺตุนิ ปีเต จ เตษำ กาปิ กฺษติ รฺน ภวิษฺยติ; โรคิณำ คาเตฺรษุ กรารฺปิเต เต'โรคา ภวิษฺยนฺติ จฯ ");
INSERT INTO santha_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","อถ ปฺรภุสฺตานิตฺยาทิศฺย สฺวรฺคํ นีต: สนฺ ปรเมศฺวรสฺย ทกฺษิณ อุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ตตเสฺต ปฺรสฺถาย สรฺวฺวตฺร สุสํวาทียกถำ ปฺรจารยิตุมาเรภิเร ปฺรภุสฺตุ เตษำ สหาย: สนฺ ปฺรกาศิตาศฺจรฺยฺยกฺริยาภิสฺตำ กถำ ปฺรมาณวตีํ จการฯ อิติฯ");
INSERT INTO santha_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ปฺรถมโต เย สากฺษิโณ วากฺยปฺรจารกาศฺจาสนฺ เต'สฺมากํ มเธฺย ยทฺยตฺ สปฺรมาณํ วากฺยมรฺปยนฺติ สฺม ");
INSERT INTO santha_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ตทนุสารโต'เนฺยปิ พหวสฺตทฺวฺฤตฺตานฺตํ รจยิตุํ ปฺรวฺฤตฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","อเตอว เห มหามหิมถิยผิลฺ ตฺวํ ยา ยา: กถา อศิกฺษฺยถาสฺตาสำ ทฺฤฒปฺรมาณานิ ยถา ปฺราปฺโนษิ ");
INSERT INTO santha_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ตทรฺถํ ปฺรถมมารภฺย ตานิ สรฺวฺวาณิ ชฺญาตฺวาหมปิ อนุกฺรมาตฺ สรฺวฺววฺฤตฺตานฺตานฺ ตุภฺยํ เลขิตุํ มติมการฺษมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ยิหูทาเทศียเหโรทฺนามเก ราชตฺวํ กุรฺวฺวติ อพียยาชกสฺย ปรฺยฺยายาธิการี สิขริยนามก เอโก ยาชโก หาโรณวํโศทฺภวา อิลีเศวาขฺยา ");
INSERT INTO santha_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ตสฺย ชายา ทฺวาวิเมา นิรฺโทเษา ปฺรโภ: สรฺวฺวาชฺญา วฺยวสฺถาศฺจ สํมนฺย อีศฺวรทฺฤษฺเฏา ธารฺมฺมิกาวาสฺตามฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ตโย: สนฺตาน เอโกปิ นาสีตฺ, ยต อิลีเศวา พนฺธฺยา เตา ทฺวาเวว วฺฤทฺธาวภวตามฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ยทา สฺวปรฺยฺยานุกฺรเมณ สิขริย อีศฺวาสฺย สมกฺษํ ยาชกียํ กรฺมฺม กโรติ ");
INSERT INTO santha_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ตทา ยชฺญสฺย ทินปริปายฺยา ปรเมศฺวรสฺย มนฺทิเร ปฺรเวศกาเล ธูปชฺวาลนํ กรฺมฺม ตสฺย กรณียมาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ตทฺธูปชฺวาลนกาเล โลกนิวเห ปฺรารฺถนำ กรฺตุํ พหิสฺติษฺฐติ ");
INSERT INTO santha_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","สติ สิขริโย ยสฺยำ เวทฺยำ ธูปํ ชฺวาลยติ ตทฺทกฺษิณปารฺเศฺว ปรเมศฺวรสฺย ทูต เอก อุปสฺถิโต ทรฺศนํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ตํ ทฺฤษฺฏฺวา สิขริย อุทฺวิวิเช ศศงฺเก จฯ ");
INSERT INTO santha_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ตทา ส ทูตสฺตํ พภาเษ เห สิขริย มา ไภสฺตว ปฺรารฺถนา คฺราหฺยา ชาตา ตว ภารฺยฺยา อิลีเศวา ปุตฺรํ ปฺรโสษฺยเต ตสฺย นาม โยेหนฺ อิติ กริษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","กิญฺจ ตฺวํ สานนฺท: สหรฺษศฺจ ภวิษฺยสิ ตสฺย ชนฺมนิ พหว อานนฺทิษฺยนฺติ จฯ ");
INSERT INTO santha_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ยโต เหโต: ส ปรเมศฺวรสฺย โคจเร มหานฺ ภวิษฺยติ ตถา ทฺรากฺษารสํ สุรำ วา กิมปิ น ปาสฺยติ, อปรํ ชนฺมารภฺย ปวิเตฺรณาตฺมนา ปริปูรฺณ: ");
INSERT INTO santha_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","สนฺ อิสฺราเยลฺวํศียานฺ อเนกานฺ ปฺรโภ: ปรเมศฺวรสฺย มารฺคมาเนษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","สนฺตานานฺ ปฺรติ ปิตฺฤณำ มนำสิ ธรฺมฺมชฺญานํ ปฺรตฺยนาชฺญาคฺราหิณศฺจ ปราวรฺตฺตยิตุํ, ปฺรโภ: ปรเมศฺวรสฺย เสวารฺถมฺ เอกำ สชฺชิตชาตึ วิธาตุญฺจ ส เอลิยรูปาตฺมศกฺติปฺราปฺตสฺตสฺยาเคฺร คมิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ตทา สิขริโย ทูตมวาทีตฺ กถเมตทฺ เวตฺสฺยามิ? ยโตหํ วฺฤทฺโธ มม ภารฺยฺยา จ วฺฤทฺธาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ตโต ทูต: ปฺรตฺยุวาจ ปเศฺยศฺวรสฺย สากฺษาทฺวรฺตฺตี ชิพฺราเยลฺนามา ทูโตหํ ตฺวยา สห กถำ คทิตุํ ตุภฺยมิมำ ศุภวารฺตฺตำ ทาตุญฺจ เปฺรษิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","กินฺตุ มทียํ วากฺยํ กาเล ผลิษฺยติ ตตฺ ตฺวยา น ปฺรตีตมฺ อต: การณาทฺ ยาวเทว ตานิ น เสตฺสฺยนฺติ ตาวตฺ ตฺวํ วกฺตุํมศกฺโต มูโก ภวฯ ");
INSERT INTO santha_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ตทานีํ เย เย โลกา: สิขริยมไปกฺษนฺต เต มเธฺยมนฺทิรํ ตสฺย พหุวิลมฺพาทฺ อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ส พหิราคโต ยทา กิมปิ วากฺยํ วกฺตุมศกฺต: สงฺเกตํ กฺฤตฺวา นิ:ศพฺทสฺตเสฺยา ตทา มเธฺยมนฺทิรํ กสฺยจิทฺ ทรฺศนํ เตน ปฺราปฺตมฺ อิติ สรฺเวฺว พุพุธิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","อนนฺตรํ ตสฺย เสวนปรฺยฺยาเย สมฺปูรฺเณ สติ ส นิชเคหํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","กติปยทิเนษุ คเตษุ ตสฺย ภารฺยฺยา อิลีเศวา ครฺพฺภวตี พภูว ");
INSERT INTO santha_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ปศฺจาตฺ สา ปญฺจมาสานฺ สํโคปฺยากถยตฺ โลกานำ สมกฺษํ มมาปมานํ ขณฺฑยิตุํ ปรเมศฺวโร มยิ ทฺฤษฺฏึ ปาตยิตฺวา กรฺมฺเมทฺฤศํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","อปรญฺจ ตสฺยา ครฺพฺภสฺย ษษฺเฐ มาเส ชาเต คาลีลฺปฺรเทศียนาสรตฺปุเร ");
INSERT INTO santha_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ทายูโท วํศียาย ยูษผฺนามฺเน ปุรุษาย ยา มริยมฺนามกุมารี วาคฺทตฺตาสีตฺ ตสฺยา: สมีปํ ชิพฺราเยลฺ ทูต อีศฺวเรณ ปฺรหิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ส คตฺวา ชคาท เห อีศฺวรานุคฺฤหีตกเนฺย ตว ศุภํ ภูยาตฺ ปฺรภุ: ปรเมศฺวรสฺตว สหาโยสฺติ นารีณำ มเธฺย ตฺวเมว ธนฺยาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ตทานีํ สา ตํ ทฺฤษฺฏฺวา ตสฺย วากฺยต อุทฺวิชฺย กีทฺฤศํ ภาษณมิทมฺ อิติ มนสา จินฺตยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ตโต ทูโต'วทตฺ เห มริยมฺ ภยํ มาการฺษี:, ตฺวยิ ปรเมศฺวรสฺยานุคฺรโหสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ปศฺย ตฺวํ ครฺพฺภํ ธฺฤตฺวา ปุตฺรํ ปฺรโสษฺยเส ตสฺย นาม ยีศุริติ กริษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ส มหานฺ ภวิษฺยติ ตถา สรฺเวฺวภฺย: เศฺรษฺฐสฺย ปุตฺร อิติ ขฺยาสฺยติ; อปรํ ปฺรภุ: ปรเมศฺวรสฺตสฺย ปิตุรฺทายูท: สึหาสนํ ตไสฺม ทาสฺยติ; ");
INSERT INTO santha_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ตถา ส ยากูโพ วํโศปริ สรฺวฺวทา ราชตฺวํ กริษฺยติ, ตสฺย ราชตฺวสฺยานฺโต น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ตทา มริยมฺ ตํ ทูตํ พภาเษ นาหํ ปุรุษสงฺคํ กโรมิ ตรฺหิ กถเมตตฺ สมฺภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ตโต ทูโต'กถยตฺ ปวิตฺร อาตฺมา ตฺวามาศฺรายิษฺยติ ตถา สรฺวฺวเศฺรษฺฐสฺย ศกฺติสฺตโวปริ ฉายำ กริษฺยติ ตโต เหโตสฺตว ครฺพฺภาทฺ ย: ปวิตฺรพาลโก ชนิษฺยเต ส อีศฺวรปุตฺร อิติ ขฺยาตึ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","อปรญฺจ ปศฺย ตว ชฺญาติริลีเศวา ยำ สรฺเวฺว พนฺธฺยามวทนฺ อิทานีํ สา วารฺทฺธเกฺย สนฺตานเมกํ ครฺพฺเภ'ธารยตฺ ตสฺย ษษฺฐมาโสภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","กิมปิ กรฺมฺม นาสาธฺยมฺ อีศฺวรสฺยฯ ");
INSERT INTO santha_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ตทา มริยมฺ ชคาท, ปศฺย ปฺรเภรหํ ทาสี มหฺยํ ตว วากฺยานุสาเรณ สรฺวฺวเมตทฺ ฆฏตามฺ; อนนตรํ ทูตสฺตสฺยา: สมีปาตฺ ปฺรตเสฺถฯ ");
INSERT INTO santha_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","อถ กติปยทินาตฺ ปรํ มริยมฺ ตสฺมาตฺ ปรฺวฺวตมยปฺรเทศียยิหูทายา นครเมกํ ศีฆฺรํ คตฺวา ");
INSERT INTO santha_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","สิขริยยาชกสฺย คฺฤหํ ปฺรวิศฺย ตสฺย ชายามฺ อิลีเศวำ สมฺโพธฺยาวทตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ตโต มริยม: สมฺโพธนวาเกฺย อิลีเศวายา: กรฺณโย: ปฺรวิษฺฏมาเตฺร สติ ตสฺยา ครฺพฺภสฺถพาลโก นนรฺตฺตฯ ตต อิลีเศวา ปวิเตฺรณาตฺมนา ปริปูรฺณา สตี ");
INSERT INTO santha_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","โปฺรจฺไจรฺคทิตุมาเรเภ, โยษิตำ มเธฺย ตฺวเมว ธนฺยา, ตว ครฺพฺภสฺถ: ศิศุศฺจ ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ตฺวํ ปฺรโภรฺมาตา, มม นิเวศเน ตฺวยา จรณาวรฺปิเตา, มมาทฺย เสาภาคฺยเมตตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ปศฺย ตว วาเกฺย มม กรฺณโย: ปฺรวิษฺฏมาเตฺร สติ มโมทรสฺถ: ศิศุรานนฺทานฺ นนรฺตฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ยา สฺตฺรี วฺยศฺวสีตฺ สา ธนฺยา, ยโต เหโตสฺตำ ปฺรติ ปรเมศฺวโรกฺตํ วากฺยํ สรฺวฺวํ สิทฺธํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ตทานีํ มริยมฺ ชคาทฯ ธนฺยวาทํ ปเรศสฺย กโรติ มามกํ มน:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","มมาตฺมา ตารเกเศ จ สมุลฺลาสํ ปฺรคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","อกโรตฺ ส ปฺรภุ รฺทุษฺฏึ สฺวทาสฺยา ทุรฺคตึ ปฺรติฯ ปศฺยาทฺยารภฺย มำ ธนฺยำ วกฺษฺยนฺติ ปุรุษา: สทาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ย: สรฺวฺวศกฺติมานฺ ยสฺย นามาปิ จ ปวิตฺรกํฯ ส เอว สุมหตฺกรฺมฺม กฺฤตวานฺ มนฺนิมิตฺตกํฯ ");
INSERT INTO santha_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","เย พิภฺยติ ชนาสฺตสฺมาตฺ เตษำ สนฺตานปํกฺติษุฯ อนุกมฺปา ตทียา จ สรฺวฺวไทว สุติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","สฺวพาหุพลตเสฺตน ปฺรากาศฺยต ปรากฺรม:ฯ มน:กุมนฺตฺรณาสารฺทฺธํ วิกีรฺยฺยนฺเต'ภิมานิน:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","สึหาสนคตาโลฺลกานฺ พลินศฺจาวโรหฺย ส:ฯ ปเทษูจฺเจษุ โลกำสฺตุ กฺษุทฺรานฺ สํสฺถาปยตฺยปิฯ ");
INSERT INTO santha_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","กฺษุธิตานฺ มานวานฺ ทฺรไวฺยรุตฺตไม: ปริตรฺปฺย ส:ฯ สกลานฺ ธนิโน โลกานฺ วิสฺฤเชทฺ ริกฺตหสฺตกานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","อิพฺราหีมิ จ ตทฺวํเศ ยา ทยาสฺติ สไทว ตำฯ สฺมฺฤตฺวา ปุรา ปิตฺฤณำ โน ยถา สากฺษาตฺ ปฺรติศฺรุตํฯ ");
INSERT INTO santha_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","อิสฺราเยลฺเสวกเสฺตน ตโถปกฺริยเต สฺวยํ๚ ");
INSERT INTO santha_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","อนนฺตรํ มริยมฺ ปฺราเยณ มาสตฺรยมฺ อิลีเศวยา สโหษิตฺวา วฺยาฆุยฺย นิชนิเวศนํ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ตทนนฺตรมฺ อิลีเศวายา: ปฺรสวกาล อุปสฺถิเต สติ สา ปุตฺรํ ปฺราโสษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ตต: ปรเมศฺวรสฺตสฺยำ มหานุคฺรหํ กฺฤตวานฺ เอตตฺ ศฺรุตฺวา สมีปวาสิน: กุฏุมฺพาศฺจาคตฺย ตยา สห มุมุทิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ตถาษฺฏเม ทิเน เต พาลกสฺย ตฺวจํ เฉตฺตุมฺ เอตฺย ตสฺย ปิตฺฤนามานุรูปํ ตนฺนาม สิขริย อิติ กรฺตฺตุมีษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","กินฺตุ ตสฺย มาตากถยตฺ ตนฺน, นามาสฺย โยหนฺ อิติ กรฺตฺตวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ตทา เต วฺยาหรนฺ ตว วํศมเธฺย นาเมทฺฤศํ กสฺยาปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ตต: ปรํ ตสฺย ปิตรํ สิขริยํ ปฺรติ สงฺเกตฺย ปปฺรจฺฉุ: ศิโศ: กึ นาม การิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ตต: ส ผลกเมกํ ยาจิตฺวา ลิเลข ตสฺย นาม โยหนฺ ภวิษฺยติฯ ตสฺมาตฺ สรฺเวฺว อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ตตฺกฺษณํ สิขริยสฺย ชิหฺวาชาเฑฺย'ปคเต ส มุขํ วฺยาทาย สฺปษฺฏวรฺณมุจฺจารฺยฺย อีศฺวรสฺย คุณานุวาทํ จการฯ ");
INSERT INTO santha_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ตสฺมาจฺจตุรฺทิกฺสฺถา: สมีปวาสิโลกา ภีตา เอวเมตา: สรฺวฺวา: กถา ยิหูทายา: ปรฺวฺวตมยปฺรเทศสฺย สรฺวฺวตฺร ปฺรจาริตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ตสฺมาตฺ โศฺรตาโร มน:สุ สฺถาปยิตฺวา กถยามฺพภูวุ: กีทฺฤโศยํ พาโล ภวิษฺยติ? อถ ปรเมศฺวรสฺตสฺย สหาโยภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ตทา โยหน: ปิตา สิขริย: ปวิเตฺรณาตฺมนา ปริปูรฺณ: สนฺ เอตาทฺฤศํ ภวิษฺยทฺวากฺยํ กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","อิสฺราเยล: ปฺรภุ รฺยสฺตุ ส ธนฺย: ปรเมศฺวร:ฯ อนุคฺฤหฺย นิชาโลฺลกานฺ ส เอว ปริโมจเยตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","วิปกฺษชนหเสฺตโภฺย ยถา โมจฺยามเห วยํฯ ยาวชฺชีวญฺจ ธรฺมฺเมณ สารเลฺยน จ นิรฺภยา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","เสวามไห ตเมไวกมฺ เอตตฺการณเมว จฯ สฺวกียํ สุปวิตฺรญฺจ สํสฺมฺฤตฺย นิยมํ สทาฯ ");
INSERT INTO santha_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","กฺฤปยา ปุรุษานฺ ปูรฺวฺวานฺ นิกษารฺถาตฺตุ น: ปิตุ:ฯ อิพฺราหีม: สมีเป ยํ ศปถํ กฺฤตวานฺ ปุราฯ ");
INSERT INTO santha_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ตเมว สผลํ กรฺตฺตํ ตถา ศตฺรุคณสฺย จฯ ฤृตียาการิณศฺไจว กเรโภฺย รกฺษณาย น:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","สฺฤษฺเฏ: ปฺรถมต: สฺวีไย: ปวิไตฺร รฺภาวิวาทิภิ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ยโถกฺตวานฺ ตถา สฺวสฺย ทายูท: เสวกสฺย ตุฯ ");
INSERT INTO santha_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","วํเศ ตฺราตารเมกํ ส สมุตฺปาทิตวานฺ สฺวยมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","อโต เห พาลก ตฺวนฺตุ สรฺเวฺวภฺย: เศฺรษฺฐ เอว ย:ฯ ตไสฺยว ภาวิวาทีติ ปฺรวิขฺยาโต ภวิษฺยสิฯ อสฺมากํ จรณานฺ เกฺษเม มารฺเค จาลยิตุํ สทาฯ เอวํ ธฺวานฺเต'รฺถโต มฺฤโตฺยศฺฉายายำ เย ตุ มานวา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","อุปวิษฺฏาสฺตุ ตาเนว ปฺรกาศยิตุเมว หิฯ กฺฤตฺวา มหานุกมฺปำ หิ ยาเมว ปรเมศฺวร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","อูรฺทฺวฺวาตฺ สูรฺยฺยมุทาไยฺยวาสฺมภฺยํ ปฺราทาตฺตุ ทรฺศนํฯ ตยานุกมฺปยา สฺวสฺย โลกานำ ปาปโมจเนฯ ");
INSERT INTO santha_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ปริตฺราณสฺย เตโภฺย หิ ชฺญานวิศฺราณนาย จฯ ปฺรโภ รฺมารฺคํ ปริษฺกรฺตฺตุํ ตสฺยาคฺรายี ภวิษฺยสิ๚ ");
INSERT INTO santha_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","อถ พาลก: ศรีเรณ พุทฺธฺยา จ วรฺทฺธิตุมาเรเภ; อปรญฺจ ส อิสฺราเยโล วํศียโลกานำ สมีเป ยาวนฺน ปฺรกฏีภูตสฺตาสฺตาวตฺ ปฺรานฺตเร นฺยวสตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","อปรญฺจ ตสฺมินฺ กาเล ราชฺยสฺย สรฺเวฺวษำ โลกานำ นามานิ เลขยิตุมฺ อคสฺตไกสร อาชฺญาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ตทนุสาเรณ กุรีณิยนามนิ สุริยาเทศสฺย ศาสเก สติ นามเลขนํ ปฺราเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","อโต เหโต รฺนาม เลขิตุํ สรฺเวฺว ชนา: สฺวียํ สฺวียํ นครํ ชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ตทานีํ ยูษผฺ นาม เลขิตุํ วาคฺทตฺตยา สฺวภารฺยฺยยา ครฺพฺภวตฺยา มริยมา สห สฺวยํ ทายูท: สชาติวํศ อิติ การณาทฺ คาลีลฺปฺรเทศสฺย นาสรตฺนคราทฺ ");
INSERT INTO santha_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ยิหูทาปฺรเทศสฺย ไพเตฺลหมาขฺยํ ทายูทฺนครํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","อนฺยจฺจ ตตฺร สฺถาเน ตโยสฺติษฺฐโต: สโต รฺมริยม: ปฺรสูติกาล อุปสฺถิเต ");
INSERT INTO santha_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","สา ตํ ปฺรถมสุตํ ปฺราโสษฺฏ กินฺตุ ตสฺมินฺ วาสคฺฤเห สฺถานาภาวาทฺ พาลกํ วสฺเตฺรณ เวษฺฏยิตฺวา โคศาลายำ สฺถาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","อนนฺตรํ เย กิยนฺโต เมษปาลกา: สฺวเมษวฺรชรกฺษาไย ตตฺปฺรเทเศ สฺถิตฺวา รชนฺยำ ปฺรานฺตเร ปฺรหริณ: กรฺมฺม กุรฺวฺวนฺติ, ");
INSERT INTO santha_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","เตษำ สมีปํ ปรเมศฺวรสฺย ทูต อาคโตฺยปตเสฺถา; ตทา จตุษฺปารฺเศฺว ปรเมศฺวรสฺย เตชส: ปฺรกาศิตตฺวาตฺ เต'ติศศงฺกิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ตทา ส ทูต อุวาจ มา ไภษฺฏ ปศฺยตาทฺย ทายูท: ปุเร ยุษฺมนฺนิมิตฺตํ ตฺราตา ปฺรภุ: ขฺรีษฺโฏ'ชนิษฺฏ, ");
INSERT INTO santha_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","สรฺเวฺวษำ โลกานำ มหานนฺทชนกมฺ อิมํ มงฺคลวฺฤตฺตานฺตํ ยุษฺมานฺ ชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ยูยํ (ตตฺสฺถานํ คตฺวา) วสฺตฺรเวษฺฏิตํ ตํ พาลกํ โคศาลายำ ศยนํ ทฺรกฺษฺยถ ยุษฺมานฺ ปฺรตีทํ จิหฺนํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ทูต อิมำ กถำ กถิตวติ ตตฺรากสฺมาตฺ สฺวรฺคียา: ปฺฤตนา อาคตฺย กถามฺ อิมำ กถยิเตฺวศฺวรสฺย คุณานนฺววาทิษุ:, ยถา, ");
INSERT INTO santha_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","สรฺโวฺวรฺทฺวฺวไสฺถรีศฺวรสฺย มหิมา สมฺปฺรกาศฺยตำฯ ศานฺติรฺภูยาตฺ ปฺฤถิวฺยาสฺตุ สนฺโตษศฺจ นรานฺ ปฺรติ๚ ");
INSERT INTO santha_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ตต: ปรํ เตษำ สนฺนิเธ รฺทูตคเณ สฺวรฺคํ คเต เมษปาลกา: ปรสฺปรมฺ อเวจนฺ อาคจฺฉต ปฺรภุ: ปรเมศฺวโร ยำ ฆฏนำ ชฺญาปิตวานฺ ตสฺยา ยาถรฺยํ ชฺญาตุํ วยมธุนา ไพเตฺลหมฺปุรํ ยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ปศฺจาตฺ เต ตูรฺณํ วฺรชิตฺวา มริยมํ ยูษผํ โคศาลายำ ศยนํ พาลกญฺจ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","อิตฺถํ ทฺฤษฺฏฺวา พาลกสฺยารฺเถ โปฺรกฺตำ สรฺวฺวกถำ เต ปฺราจารยาญฺจกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ตโต เย โลกา เมษรกฺษกาณำ วทเนภฺยสฺตำ วารฺตฺตำ ศุศฺรุวุเสฺต มหาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","กินฺตุ มริยมฺ เอตตฺสรฺวฺวฆฏนานำ ตาตฺปรฺยฺยํ วิวิจฺย มนสิ สฺถาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ตตฺปศฺจาทฺ ทูตวิชฺญปฺตานุรูปํ ศฺรุตฺวา ทฺฤษฺฏฺวา จ เมษปาลกา อีศฺวรสฺย คุณานุวาทํ ธนฺยวาทญฺจ กุรฺวฺวาณา: ปราวฺฤตฺย ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","อถ พาลกสฺย ตฺวกฺเฉทนกาเล'ษฺฏมทิวเส สมุปสฺถิเต ตสฺย ครฺพฺภสฺถิเต: ปุรฺวฺวํ สฺวรฺคียทูโต ยถาชฺญาปยตฺ ตทนุรูปํ เต ตนฺนามเธยํ ยีศุริติ จกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ตต: ปรํ มูสาลิขิตวฺยวสฺถายา อนุสาเรณ มริยม: ศุจิตฺวกาล อุปสฺถิเต, ");
INSERT INTO santha_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ปฺรถมช: สรฺวฺว: ปุรุษสนฺตาน: ปรเมศฺวเร สมรฺปฺยตำ,\" อิติ ปรเมศฺวรสฺย วฺยวสฺถยา ");
INSERT INTO santha_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ยีศุํ ปรเมศฺวเร สมรฺปยิตุมฺ ศาสฺตฺรียวิธฺยุกฺตํ กโปตทฺวยํ ปาราวตศาวกทฺวยํ วา พลึ ทาตุํ เต ตํ คฺฤหีตฺวา ยิรูศาลมมฺ อายยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ยิรูศาลมฺปุรนิวาสี ศิมิโยนฺนามา ธารฺมฺมิก เอก อาสีตฺ ส อิสฺราเยล: สานฺตฺวนามเปกฺษฺย ตเสฺถา กิญฺจ ปวิตฺร อาตฺมา ตสฺมินฺนาวิรฺภูต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","อปรํ ปฺรภุณา ปรเมศฺวเรณาภิษิกฺเต ตฺราตริ ตฺวยา น ทฺฤษฺเฏ ตฺวํ น มริษฺยสีติ วากฺยํ ปวิเตฺรณ อาตฺมนา ตสฺม ปฺรากถฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","อปรญฺจ ยทา ยีโศ: ปิตา มาตา จ ตทรฺถํ วฺยวสฺถานุรูปํ กรฺมฺม กรฺตฺตุํ ตํ มนฺทิรมฺ อานินฺยตุสฺตทา ");
INSERT INTO santha_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ศิมิโยนฺ อาตฺมน อากรฺษเณน มนฺทิรมาคตฺย ตํ โกฺรเฑ นิธาย อีศฺวรสฺย ธนฺยวาทํ กฺฤตฺวา กถยามาส, ยถา, ");
INSERT INTO santha_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","เห ปฺรโภ ตว ทาโสยํ นิชวากฺยานุสารต:ฯ อิทานีนฺตุ สกลฺยาโณ ภวตา สํวิสฺฤชฺยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ยต: สกลเทศสฺย ทีปฺตเย ทีปฺติรูปกํฯ ");
INSERT INTO santha_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","อิสฺราเยลียโลกสฺย มหาเคารวรูปกํฯ ");
INSERT INTO santha_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ยํ ตฺรายกํ ชนานานฺตุ สมฺมุเข ตฺวมชีชน:ฯ เสอว วิทฺยเต'สฺมากํ ธฺรวํ นยนนโคจเร๚ ");
INSERT INTO santha_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ตทานีํ เตโนกฺตา เอตา: สกลา: กถา: ศฺรุตฺวา ตสฺย มาตา ยูษผฺ จ วิสฺมยํ เมนาเตฯ ");
INSERT INTO santha_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ตต: ปรํ ศิมิโยนฺ เตภฺย อาศิษํ ทตฺตฺวา ตนฺมาตรํ มริยมมฺ อุวาจ, ปศฺย อิสฺราเยโล วํศมเธฺย พหูนำ ปาตนาโยตฺถาปนาย จ ตถา วิโรธปาตฺรํ ภวิตุํ, พหูนำ คุปฺตมโนคตานำ ปฺรกฏีกรณาย พาลโกยํ นิยุกฺโตสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ตสฺมาตฺ ตวาปิ ปฺราณา: ศูเลน วฺยตฺสฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","อปรญฺจ อาเศรสฺย วํศียผินูเยโล ทุหิตา หนฺนาขฺยา อติชรตี ภวิษฺยทฺวาทิเนฺยกา ยา วิวาหาตฺ ปรํ สปฺต วตฺสรานฺ ปตฺยา สห นฺยวสตฺ ตโต วิธวา ภูตฺวา จตุรศีติวรฺษวย:ปรฺยฺยนตํ ");
INSERT INTO santha_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","มนฺทิเร สฺถิตฺวา ปฺรารฺถโนปวาไสรฺทิวานิศมฺ อีศฺวรมฺ อเสวต สาปิ สฺตฺรี ตสฺมินฺ สมเย มนฺทิรมาคตฺย ");
INSERT INTO santha_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ปรเมศฺวรสฺย ธนฺยวาทํ จการ, ยิรูศาลมฺปุรวาสิโน ยาวนฺโต โลกา มุกฺติมเปกฺษฺย สฺถิตาสฺตานฺ ยีโศรฺวฺฤตฺตานฺตํ ชฺญาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","อิตฺถํ ปรเมศฺวรสฺย วฺยวสฺถานุสาเรณ สรฺเวฺวษุ กรฺมฺมสุ กฺฤเตษุ เตา ปุนศฺจ คาลีโล นาสรตฺนามกํ นิชนครํ ปฺรตสฺถาเตฯ ");
INSERT INTO santha_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ตตฺปศฺจาทฺ พาลก: ศรีเรณ วฺฤทฺธิเมตฺย ชฺญาเนน ปริปูรฺณ อาตฺมนา ศกฺติมำศฺจ ภวิตุมาเรเภ ตถา ตสฺมินฺ อีศฺวรานุคฺรโห พภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ตสฺย ปิตา มาตา จ ปฺรติวรฺษํ นิสฺตาโรตฺสวสมเย ยิรูศาลมมฺ อคจฺฉตามฺฯ ");
INSERT INTO santha_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","อปรญฺจ ยีเศา ทฺวาทศวรฺษวยเสฺก สติ เตา ปรฺวฺวสมยสฺย รีตฺยนุสาเรณ ยิรูศาลมํ คตฺวา ");
INSERT INTO santha_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ปารฺวฺวณํ สมฺปาทฺย ปุนรปิ วฺยาฆุยฺย ยาต: กินฺตุ ยีศุรฺพาลโก ยิรูศาลมิ ติษฺฐติฯ ยูษผฺ ตนฺมาตา จ ตทฺ อวิทิตฺวา ");
INSERT INTO santha_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ส สงฺคิภิ: สห วิทฺยต เอตจฺจ พุทฺวฺวา ทิไนกคมฺยมารฺคํ ชคฺมตุ:ฯ กินฺตุ เศเษ ชฺญาติพนฺธูนำ สมีเป มฺฤคยิตฺวา ตทุทฺเทेศมปฺราปฺย ");
INSERT INTO santha_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","เตา ปุนรปิ ยิรูศาลมมฺ ปราวฺฤตฺยาคตฺย ตํ มฺฤคยาญฺจกฺรตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","อถ ทินตฺรยาตฺ ปรํ ปณฺฑิตานำ มเธฺย เตษำ กถา: ศฺฤณฺวนฺ ตตฺตฺวํ ปฺฤจฺฉํศฺจ มนฺทิเร สมุปวิษฺฏ: ส ตาภฺยำ ทฺฤษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ตทา ตสฺย พุทฺธฺยา ปฺรตฺยุตฺตไรศฺจ สรฺเวฺว โศฺรตาโร วิสฺมยมาปทฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ตาทฺฤศํ ทฺฤษฺฏฺวา ตสฺย ชนโก ชนนี จ จมจฺจกฺรตุ: กิญฺจ ตสฺย มาตา ตมวทตฺ, เห ปุตฺร, กถมาวำ ปฺรตีตฺถํ สมาจรสฺตฺวมฺ? ปศฺย ตว ปิตาหญฺจ โศกากุเลา สนฺเตา ตฺวามนฺวิจฺฉาว: สฺมฯ ");
INSERT INTO santha_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ตต: โสวทตฺ กุโต มามฺ อไนฺวจฺฉตํ? ปิตุรฺคฺฤเห มยา สฺถาตวฺยมฺ เอตตฺ กึ ยุวาภฺยำ น ชฺญายเต? ");
INSERT INTO santha_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","กินฺตุ เตา ตไสฺยตทฺวากฺยสฺย ตาตฺปรฺยฺยํ โพทฺธุํ นาศกฺนุตำฯ ");
INSERT INTO santha_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ตต: ปรํ ส ตาภฺยำ สห นาสรตํ คตฺวา ตโยรฺวศีภูตสฺตเสฺถา กินฺตุ สรฺวฺวา เอตา: กถาสฺตสฺย มาตา มนสิ สฺถาปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","อถ ยีโศ รฺพุทฺธิ: ศรีรญฺจ ตถา ตสฺมินฺ อีศฺวรสฺย มานวานาญฺจานุคฺรโห วรฺทฺธิตุมฺ อาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","อนนฺตรํ ติพิริยไกสรสฺย ราชตฺวสฺย ปญฺจทเศ วตฺสเร สติ ยทา ปนฺตียปีลาโต ยิหูทาเทศาธิปติ เรฺหโรทฺ ตุ คาลีลฺปฺรเทศสฺย ราชา ผิลิปนามา ตสฺย ภฺราตา ตุ ยิตูริยายาสฺตฺราโขนีติยาปฺรเทศสฺย จ ราชาสีตฺ ลุษานียนามา อวิลีนีเทศสฺย ราชาสีตฺ ");
INSERT INTO santha_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","หานนฺ กิยผาศฺเจเมา ปฺรธานยาชากาวาสฺตำ ตทานีํ สิขริยสฺย ปุตฺราย โยหเน มเธฺยปฺรานฺตรมฺ อีศฺวรสฺย วาเกฺย ปฺรกาศิเต สติ ");
INSERT INTO santha_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ส ยรฺทฺทน อุภยตฏปฺรเทศานฺ สเมตฺย ปาปโมจนารฺถํ มน:ปราวรฺตฺตนสฺย จิหฺนรูปํ ยนฺมชฺชนํ ตทียา: กถา: สรฺวฺวตฺร ปฺรจารยิตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ยิศยิยภวิษฺยทฺวกฺตฺฤคฺรนฺเถ ยาทฺฤศี ลิปิราเสฺต ยถา, ปรเมศสฺย ปนฺถานํ ปริษฺกุรุต สรฺวฺวต:ฯ ตสฺย ราชปถญฺไจว สมานํ กุรุตาธุนาฯ ");
INSERT INTO santha_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","การิษฺยนฺเต สมุจฺฉฺรายา: สกลา นิมฺนภูมย:ฯ การิษฺยนฺเต นตา: สรฺเวฺว ปรฺวฺวตาศฺโจปปรฺวฺวตา:ฯ การิษฺยนฺเต จ ยา วกฺราสฺตา: สรฺวฺวา: สรลา ภุว:ฯ การิษฺยนฺเต สมานาสฺตา ยา อุจฺจนีจภูมย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","อีศฺวเรณ กฺฤตํ ตฺราณํ ทฺรกฺษฺยนฺติ สรฺวฺวมานวา:ฯ อิเตฺยตตฺ ปฺรานฺตเร วากฺยํ วทต: กสฺยจิทฺ รว:๚ ");
INSERT INTO santha_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","เย เย โลกา มชฺชนารฺถํ พหิรายยุสฺตานฺ โสวทตฺ เร เร สรฺปวํศา อาคามิน: โกปาตฺ ปลายิตุํ ยุษฺมานฺ กศฺเจตยามาส? ");
INSERT INTO santha_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ตสฺมาทฺ อิพฺราหีมฺ อสฺมากํ ปิตา กถามีทฺฤศีํ มโนภิ รฺน กถยิตฺวา ยูยํ มน:ปริวรฺตฺตนโยคฺยํ ผลํ ผลต; ยุษฺมานหํ ยถารฺถํ วทามิ ปาษาเณภฺย เอเตภฺย อีศฺวร อิพฺราหีม: สนฺตาโนตฺปาทเน สมรฺถ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","อปรญฺจ ตรุมูเล'ธุนาปิ ปรศุ: สํลคฺโนสฺติ ยสฺตรุรุตฺตมํ ผลํ น ผลติ ส ฉิทฺยเต'เคฺนา นิกฺษิปฺยเต จฯ ");
INSERT INTO santha_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ตทานีํ โลกาสฺตํ ปปฺรจฺฉุสฺตรฺหิ กึ กรฺตฺตวฺยมสฺมาภิ:? ");
INSERT INTO santha_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ตต: โสวาทีตฺ ยสฺย เทฺว วสเน วิเทฺยเต ส วสฺตฺรหีนาไยกํ วิตรตุ กึญฺจ ยสฺย ขาทฺยทฺรวฺยํ วิทฺยเต โสปิ ตไถว กโรตุฯ ");
INSERT INTO santha_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ตต: ปรํ กรสญฺจายิโน มชฺชนารฺถมฺ อาคตฺย ปปฺรจฺฉุ: เห คุโร กึ กรฺตฺตวฺยมสฺมาภิ:? ");
INSERT INTO santha_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ตต: โสกถยตฺ นิรูปิตาทธิกํ น คฺฤหฺลิตฯ ");
INSERT INTO santha_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","อนนฺตรํ เสนาคณ เอตฺย ปปฺรจฺฉ กิมสฺมาภิ รฺวา กรฺตฺตวฺยมฺ? ตต: โสภิทเธ กสฺย กามปิ หานึ มา การฺษฺฏ ตถา มฺฤษาปวาทํ มา กุรุต นิชเวตเนน จ สนฺตุษฺย ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","อปรญฺจ โลกา อเปกฺษยา สฺถิตฺวา สรฺเวฺวปีติ มโนภิ รฺวิตรฺกยาญฺจกฺรุ:, โยหนยมฺ อภิษิกฺตสฺตฺราตา น เวติ? ");
INSERT INTO santha_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ตทา โยหนฺ สรฺวฺวานฺ วฺยาชหาร, ชเล'หํ ยุษฺมานฺ มชฺชยามิ สตฺยํ กินฺตุ ยสฺย ปาทุกาพนฺธนํ โมจยิตุมปิ น โยโคฺยสฺมิ ตาทฺฤศ เอโก มตฺโต คุรุตร: ปุมานฺ เอติ, ส ยุษฺมานฺ วหฺนิรูเป ปวิตฺร อาตฺมนิ มชฺชยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","อปรญฺจ ตสฺย หเสฺต ศูรฺป อาเสฺต ส สฺวศสฺยานิ ศุทฺธรูปํ ปฺรโสฺผฏฺย โคธูมานฺ สรฺวฺวานฺ ภาณฺฑาคาเร สํคฺรหีษฺยติ กินฺตุ พูษาณิ สรฺวฺวาณฺยนิรฺวฺวาณวหฺนินา ทาหยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","โยหนฺ อุปเทเศเนตฺถํ นานากถา โลกานำ สมกฺษํ ปฺรจารยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","อปรญฺจ เหโรทฺ ราชา ผิลิปฺนามฺน: สโหทรสฺย ภารฺยฺยำ เหโรทิยามธิ ตถานฺยานิ ยานิ ยานิ กุกรฺมฺมาณิ กฺฤตวานฺ ตทธิ จ ");
INSERT INTO santha_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","โยหนา ติรสฺกฺฤโต ภูตฺวา การาคาเร ตสฺย พนฺธนาทฺ อปรมปิ กุกรฺมฺม จการฯ ");
INSERT INTO santha_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","อิต: ปูรฺวฺวํ ยสฺมินฺ สมเย สรฺเวฺว โยหนา มชฺชิตาสฺตทานีํ ยีศุรปฺยาคตฺย มชฺชิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ตทนนฺตรํ เตน ปฺรารฺถิเต เมฆทฺวารํ มุกฺตํ ตสฺมาจฺจ ปวิตฺร อาตฺมา มูรฺตฺติมานฺ ภูตฺวา กโปตวตฺ ตทุปรฺยฺยวรุโรห; ตทา ตฺวํ มม ปฺริย: ปุตฺรสฺตฺวยิ มม ปรม: สนฺโตษ อิตฺยากาศวาณี พภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ตทานีํ ยีศุ: ปฺราเยณ ตฺรึศทฺวรฺษวยสฺก อาสีตฺฯ เลากิกชฺญาเน ตุ ส ยูษผ: ปุตฺร:, ");
INSERT INTO santha_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ยูษผฺ เอเล: ปุตฺร:, เอลิรฺมตฺตต: ปุตฺร:, มตฺตตฺ เลเว: ปุตฺร:, เลวิ รฺมลฺเก: ปุตฺร:, มลฺกิรฺยานฺนสฺย ปุตฺร:; ยานฺโน ยูษผ: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ยูษผฺ มตฺตถิยสฺย ปุตฺร:, มตฺตถิย อาโมส: ปุตฺร:, อาโมสฺ นหูม: ปุตฺร:, นหูมฺ อิเษฺล: ปุตฺร: อิษฺลิรฺนเค: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","นคิรฺมาฏ: ปุตฺร:, มาฏฺ มตฺตถิยสฺย ปุตฺร:, มตฺตถิย: ศิมิเย: ปุตฺร:, ศิมิยิรฺยูษผ: ปุตฺร:, ยูษผฺ ยิหูทา: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ยิหูทา โยหานา: ปุตฺร:, โยหานา รีษา: ปุตฺร:, รีษา: สิรุพฺพาพิล: ปุตฺร:, สิรุพฺพาพิลฺ ศลฺตีเยล: ปุตฺร:, ศลฺตีเยลฺ เนเร: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","เนริรฺมลฺเก: ปุตฺร:, มลฺกิ: อทฺย: ปุตฺร:, อทฺที โกษม: ปุตฺร:, โกษมฺ อิลฺโมทท: ปุตฺร:, อิลฺโมททฺ เอร: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","เอรฺ โยเศ: ปุตฺร:, โยศิ: อิลีเยษร: ปุตฺร:, อิลีเยษรฺ โยรีม: ปุตฺร:, โยรีมฺ มตฺตต: ปุตฺร:, มตฺตต เลเว: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","เลวิ: ศิมิโยน: ปุตฺร:, ศิมิโยนฺ ยิหูทา: ปุตฺร:, ยิหูทา ยูษุผ: ปุตฺร:, ยูษุผฺ โยนน: ปุตฺร:, ยานนฺ อิลียากีม: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","อิลิยากีมฺ: มิเลยา: ปุตฺร:, มิเลยา ไมนน: ปุตฺร:, ไมนนฺ มตฺตตฺตสฺย ปุตฺร:, มตฺตตฺโต นาถน: ปุตฺร:, นาถนฺ ทายูท: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ทายูทฺ ยิศย: ปุตฺร:, ยิศย โอเพท: ปุตฺร, โอเพทฺ โพยส: ปุตฺร:, โพยสฺ สลฺโมน: ปุตฺร:, สลฺโมนฺ นหโศน: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","นหโศนฺ อมฺมีนาทพ: ปุตฺร:, อมฺมีนาทพฺ อราม: ปุตฺร:, อรามฺ หิโษฺรณ: ปุตฺร:, หิโษฺรณฺ เปรส: ปุตฺร:, เปรสฺ ยิหูทา: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ยิหูทา ยากูพ: ปุตฺร:, ยากูพฺ อิสฺหาก: ปุตฺร:, อิสฺหากฺ อิพฺราหีม: ปุตฺร:, อิพฺราหีมฺ เตรห: ปุตฺร:, เตรหฺ นาโหร: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","นาโหรฺ สิรุค: ปุตฺร:, สิรุคฺ ริยฺว: ปุตฺร:, ริยู: เปลค: ปุตฺร:, เปลคฺ เอวร: ปุตฺร:, เอวรฺ เศลห: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","เศลหฺ ไกนน: ปุตฺร:, ไกนนฺ อรฺผกฺษท: ปุตฺร:, อรฺผกฺษทฺ ศาม: ปุตฺร:, ศามฺ โนห: ปุตฺร:, โนโห เลมก: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","เลมกฺ มิถูเศลห: ปุตฺร:, มิถูเศลหฺ หโนก: ปุตฺร:, หโนกฺ เยรท: ปุตฺร:, เยรทฺ มหลเลล: ปุตฺร:, มหลเลลฺ ไกนน: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ไกนนฺ อิโนศ: ปุตฺร:, อิโนศฺ เศต: ปุตฺร:, เศตฺ อาทม: ปุตฺร, อาทมฺ อีศฺวรสฺย ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ตต: ปรํ ยีศุ: ปวิเตฺรณาตฺมนา ปูรฺณ: สนฺ ยรฺทฺทนนทฺยา: ปราวฺฤตฺยาตฺมนา ปฺรานฺตรํ นีต: สนฺ จตฺวารึศทฺทินานิ ยาวตฺ ไศตานา ปรีกฺษิโต'ภูตฺ, ");
INSERT INTO santha_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","กิญฺจ ตานิ สรฺวฺวทินานิ โภชนํ วินา สฺถิตตฺวาตฺ กาเล ปูรฺเณ ส กฺษุธิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ตต: ไศตานาคตฺย ตมวทตฺ ตฺวํ เจทีศฺวรสฺย ปุตฺรสฺตรฺหิ ปฺรสฺตราเนตานฺ อาชฺญยา ปูปานฺ กุรุฯ ");
INSERT INTO santha_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ตทา ยีศุรุวาจ, ลิปิรีทฺฤศี วิทฺยเต มนุช: เกวเลน ปูเปน น ชีวติ กินฺตฺวีศฺวรสฺย สรฺวฺวาภิราชฺญาภิ รฺชีวติฯ ");
INSERT INTO santha_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ตทา ไศตานฺ ตมุจฺจํ ปรฺวฺวตํ นีตฺวา นิมิไษกมเธฺย ชคต: สรฺวฺวราชฺยานิ ทรฺศิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ปศฺจาตฺ ตมวาทีตฺ สรฺวฺวมฺ เอตทฺ วิภวํ ปฺรตาปญฺจ ตุภฺยํ ทาสฺยามิ ตนฺ มยิ สมรฺปิตมาเสฺต ยํ ปฺรติ มเมจฺฉา ชายเต ตไสฺม ทาตุํ ศกฺโนมิ, ");
INSERT INTO santha_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ตฺวํ เจนฺมำ ภชเส ตรฺหิ สรฺวฺวเมตตฺ ตไวว ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ตทา ยีศุสฺตํ ปฺรตฺยุกฺตวานฺ ทูรี ภว ไศตานฺ ลิปิราเสฺต, นิชํ ปฺรภุํ ปรเมศฺวรํ ภชสฺว เกวลํ ตเมว เสวสฺว จฯ ");
INSERT INTO santha_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","อถ ไศตานฺ ตํ ยิรูศาลมํ นีตฺวา มนฺทิรสฺย จูฑายา อุปริ สมุปเวศฺย ชคาท ตฺวํ เจทีศฺวรสฺย ปุตฺรสฺตรฺหิ สฺถานาทิโต ลมฺผิตฺวาธ: ");
INSERT INTO santha_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ปต ยโต ลิปิราเสฺต, อาชฺญาปยิษฺยติ สฺวียานฺ ทูตานฺ ส ปรเมศฺวร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","รกฺษิตุํ สรฺวฺวมารฺเค ตฺวำ เตน ตฺวจฺจรเณ ยถาฯ น ลเคตฺ ปฺรสฺตราฆาตสฺตฺวำ ธริษฺยนฺติ เต ตถาฯ ");
INSERT INTO santha_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ตทา ยีศุนา ปฺรตฺยุกฺตมฺ อิทมปฺยุกฺตมสฺติ ตฺวํ สฺวปฺรภุํ ปเรศํ มา ปรีกฺษสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ปศฺจาตฺ ไศตานฺ สรฺวฺวปรีกฺษำ สมาปฺย กฺษณาตฺตํ ตฺยกฺตฺวา ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ตทา ยีศุราตฺมปฺรภาวาตฺ ปุนรฺคาลีลฺปฺรเทศํ คตสฺตทา ตตฺสุขฺยาติศฺจตุรฺทิศํ วฺยานเศฯ ");
INSERT INTO santha_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ส เตษำ ภชนคฺฤเหษุ อุปทิศฺย สรฺไวฺว: ปฺรศํสิโต พภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","อถ ส สฺวปาลนสฺถานํ นาสรตฺปุรเมตฺย วิศฺรามวาเร สฺวาจาราทฺ ภชนเคหํ ปฺรวิศฺย ปฐิตุมุตฺตเสฺถาฯ ");
INSERT INTO santha_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ตโต ยิศยิยภวิษฺยทฺวาทิน: ปุสฺตเก ตสฺย กรทตฺเต สติ ส ตตฺ ปุสฺตกํ วิสฺตารฺยฺย ยตฺร วกฺษฺยมาณานิ วจนานิ สนฺติ ตตฺ สฺถานํ ปฺราปฺย ปปาฐฯ ");
INSERT INTO santha_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","อาตฺมา ตุ ปรเมศสฺย มทีโยปริ วิทฺยเตฯ ทริเทฺรษุ สุสํวาทํ วกฺตุํ มำ โสภิษิกฺตวานฺฯ ภคฺนานฺต: กรณาโลฺลกานฺ สุสฺวสฺถานฺ กรฺตฺตุเมว จฯ พนฺทีกฺฤเตษุ โลเกษุ มุกฺเต โรฺฆษยิตุํ วจ:ฯ เนตฺราณิ ทาตุมนฺเธภฺยสฺตฺราตุํ พทฺธชนานปิฯ ");
INSERT INTO santha_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ปเรศานุคฺรเห กาลํ ปฺรจารยิตุเมว จฯ สรฺไวฺวตตฺกรณารฺถาย มาเมว ปฺรหิโณติ ส:๚ ");
INSERT INTO santha_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ตต: ปุสฺตกํ พทฺวฺวา ปริจารกสฺย หเสฺต สมรฺปฺย จาสเน สมุปวิษฺฏ:, ตโต ภชนคฺฤเห ยาวนฺโต โลกา อาสนฺ เต สรฺเวฺว'นนฺยทฺฤษฺฏฺยา ตํ วิลุโลกิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","อนนฺตรมฺ อไทฺยตานิ สรฺวฺวาณิ ลิขิตวจนานิ ยุษฺมากํ มเธฺย สิทฺธานิ ส อิมำ กถำ เตภฺย: กถยิตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ตต: สรฺเวฺว ตสฺมินฺ อนฺวรชฺยนฺต, กิญฺจ ตสฺย มุขานฺนิรฺคตาภิรนุคฺรหสฺย กถาภิศฺจมตฺกฺฤตฺย กถยามาสุ: กิมยํ ยูษผ: ปุโตฺร น? ");
INSERT INTO santha_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ตทา โส'วาทีทฺ เห จิกิตฺสก สฺวเมว สฺวสฺถํ กุรุ กผรฺนาหูมิ ยทฺยตฺ กฺฤตวานฺ ตทเศฺราษฺม ตา: สรฺวา: กฺริยา อตฺร สฺวเทเศ กุรุ กถาเมตำ ยูยเมวาวศฺยํ มำ วทิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ปุน: โสวาทีทฺ ยุษฺมานหํ ยถารฺถํ วทามิ, โกปิ ภวิษฺยทฺวาที สฺวเทเศ สตฺการํ น ปฺราปฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","อปรญฺจ ยถารฺถํ วจฺมิ, เอลิยสฺย ชีวนกาเล ยทา สารฺทฺธตฺริตยวรฺษาณิ ยาวตฺ ชลทปฺรติพนฺธาตฺ สรฺวฺวสฺมินฺ เทเศ มหาทุรฺภิกฺษมฺ อชนิษฺฏ ตทานีมฺ อิสฺราเยโล เทศสฺย มเธฺย พหฺโวฺย วิธวา อาสนฺ, ");
INSERT INTO santha_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","กินฺตุ สีโทนฺปฺรเทศียสาริผตฺปุรนิวาสินีมฺ เอกำ วิธวำ วินา กสฺยาศฺจิทปิ สมีเป เอลิย: เปฺรริโต นาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","อปรญฺจ อิลีศายภวิษฺยทฺวาทิวิทฺยมานตากาเล อิสฺราเยลฺเทเศ พหว: กุษฺฐิน อาสนฺ กินฺตุ สุรียเทศียํ นามานฺกุษฺฐินํ วินา โกปฺยนฺย: ปริษฺกฺฤโต นาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","อิมำ กถำ ศฺรุตฺวา ภชนเคหสฺถิตา โลกา: สโกฺรธมฺ อุตฺถาย ");
INSERT INTO santha_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","นคราตฺตํ พหิษฺกฺฤตฺย ยสฺย ศิขริณ อุปริ เตษำ นครํ สฺถาปิตมาเสฺต ตสฺมานฺนิกฺเษปฺตุํ ตสฺย ศิขรํ ตํ นินฺยุ: ");
INSERT INTO santha_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","กินฺตุ ส เตษำ มธฺยาทปสฺฤตฺย สฺถานานฺตรํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ตต: ปรํ ยีศุรฺคาลีลฺปฺรเทศียกผรฺนาหูมฺนคร อุปสฺถาย วิศฺรามวาเร โลกานุปเทษฺฏุมฺ อารพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ตทุปเทศาตฺ สรฺเวฺว จมจฺจกฺรุ รฺยตสฺตสฺย กถา คุรุตรา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ตทานีํ ตทฺภชนเคหสฺถิโต'เมธฺยภูตคฺรสฺต เอโก ชน อุจฺไจ: กถยามาส, ");
INSERT INTO santha_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","เห นาสรตียยีโศ'สฺมานฺ ตฺยช, ตฺวยา สหาสฺมากํ ก: สมฺพนฺธ:? กิมสฺมานฺ วินาศยิตุมายาสิ? ตฺวมีศฺวรสฺย ปวิโตฺร ชน เอตทหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ตทา ยีศุสฺตํ ตรฺชยิตฺวาวทตฺ เมานี ภว อิโต พหิรฺภว; ตต: โสเมธฺยภูตสฺตํ มธฺยสฺถาเน ปาตยิตฺวา กิญฺจิทปฺยหึสิตฺวา ตสฺมาทฺ พหิรฺคตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ตต: สรฺเวฺว โลกาศฺจมตฺกฺฤตฺย ปรสฺปรํ วกฺตุมาเรภิเร โกยํ จมตฺการ:ฯ เอษ ปฺรภาเวณ ปรากฺรเมณ จาเมธฺยภูตานฺ อาชฺญาปยติ เตไนว เต พหิรฺคจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","อนนฺตรํ จตุรฺทิกฺสฺถเทศานฺ ตสฺย สุขฺยาติรฺวฺยาปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ตทนนฺตรํ ส ภชนเคหาทฺ พหิราคตฺย ศิโมโน นิเวศนํ ปฺรวิเวศ ตทา ตสฺย ศฺวศฺรูรฺชฺวเรณาตฺยนฺตํ ปีฑิตาสีตฺ ศิษฺยาสฺตทรฺถํ ตสฺมินฺ วินยํ จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ตต: ส ตสฺยา: สมีเป สฺถิตฺวา ชฺวรํ ตรฺชยามาส เตไนว ตำ ชฺวโร'ตฺยากฺษีตฺ ตต: สา ตตฺกฺษณมฺ อุตฺถาย ตานฺ สิเษเวฯ ");
INSERT INTO santha_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","อถ สูรฺยฺยาสฺตกาเล เสฺวษำ เย เย ชนา นานาโรไค: ปีฑิตา อาสนฺ โลกาสฺตานฺ ยีโศ: สมีปมฺ อานินฺยุ:, ตทา ส เอไกกสฺย คาเตฺร กรมรฺปยิตฺวา ตานโรคานฺ จการฯ ");
INSERT INTO santha_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ตโต ภูตา พหุโภฺย นิรฺคตฺย จีตฺศพฺทํ กฺฤตฺวา จ พภาษิเร ตฺวมีศฺวรสฺย ปุโตฺร'ภิษิกฺตตฺราตา; กินฺตุ โสภิษิกฺตตฺราเตติ เต วิวิทุเรตสฺมาตฺ การณาตฺ ตานฺ ตรฺชยิตฺวา ตทฺวกฺตุํ นิษิเษธฯ ");
INSERT INTO santha_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","อปรญฺจ ปฺรภาเต สติ ส วิชนสฺถานํ ปฺรตเสฺถ ปศฺจาตฺ ชนาสฺตมนฺวิจฺฉนฺตสฺตนฺนิกฏํ คตฺวา สฺถานานฺตรคมนารฺถํ ตมนฺวรุนฺธนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","กินฺตุ ส ตานฺ ชคาท, อีศฺวรียราชฺยสฺย สุสํวาทํ ปฺรจารยิตุมฺ อนฺยานิ ปุราณฺยปิ มยา ยาตวฺยานิ ยตสฺตทรฺถเมว เปฺรริโตหํฯ ");
INSERT INTO santha_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","อถ คาลีโล ภชนเคเหษุ ส อุปทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","อนนฺตรํ ยีศุเรกทา คิเนษรถฺทสฺย ตีร อุตฺติษฺฐติ, ตทา โลกา อีศฺวรียกถำ โศฺรตุํ ตทุปริ ปฺรปติตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ตทานีํ ส หฺทสฺย ตีรสมีเป เนาทฺวยํ ททรฺศ กิญฺจ มตฺโสฺยปชีวิโน นาวํ วิหาย ชาลํ ปฺรกฺษาลยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ตตสฺตโยรฺทฺวโย รฺมเธฺย ศิโมโน นาวมารุหฺย ตีราตฺ กิญฺจิทฺทูรํ ยาตุํ ตสฺมินฺ วินยํ กฺฤตฺวา เนากายามุปวิศฺย โลกานฺ โปฺรปทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ปศฺจาตฺ ตํ ปฺรสฺตาวํ สมาปฺย ส ศิโมนํ วฺยาชหาร, คภีรํ ชลํ คตฺวา มตฺสฺยานฺ ธรฺตฺตุํ ชาลํ นิกฺษิปฯ ");
INSERT INTO santha_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ตต: ศิโมน พภาเษ, เห คุโร ยทฺยปิ วยํ กฺฤตฺสฺนำ ยามินีํ ปริศฺรมฺย มตฺไสฺยกมปิ น ปฺราปฺตาสฺตถาปิ ภวโต นิเทศโต ชาลํ กฺษิปาม:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","อถ ชาเล กฺษิปฺเต พหุมตฺสฺยปตนาทฺ อานาย: ปฺรจฺฉินฺน:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ตสฺมาทฺ อุปกรฺตฺตุมฺ อนฺยเนาสฺถานฺ สงฺคิน อายาตุมฺ อิงฺคิเตน สมาหฺวยนฺ ตตสฺต อาคตฺย มตฺไสฺย เรฺนาทฺวยํ ปฺรปูรยามาสุ ไรฺย เรฺนาทฺวยํ ปฺรมคฺนมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ตทา ศิโมนฺปิตรสฺตทฺ วิโลกฺย ยีโศศฺจรณโย: ปติตฺวา, เห ปฺรโภหํ ปาปี นโร มม นิกฏาทฺ ภวานฺ ยาตุ, อิติ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ยโต ชาเล ปติตานำ มตฺสฺยานำ ยูถาตฺ ศิโมนฺ ตตฺสงฺคินศฺจ จมตฺกฺฤตวนฺต:; ศิโมน: สหการิเณา สิวเท: ปุเตฺรา ยากูพฺ โยหนฺ เจเมา ตาทฺฤเศา พภูวตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ตทา ยีศุ: ศิโมนํ ชคาท มา ไภษีรทฺยารภฺย ตฺวํ มนุษฺยธโร ภวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","อนนฺตรํ สรฺวฺวาสุ เนาสุ ตีรมฺ อานีตาสุ เต สรฺวฺวานฺ ปริตฺยชฺย ตสฺย ปศฺจาทฺคามิโน พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ตต: ปรํ ยีเศา กสฺมึศฺจิตฺ ปุเร ติษฺฐติ ชน เอก: สรฺวฺวางฺคกุษฺฐสฺตํ วิโลกฺย ตสฺย สมีเป นฺยุพฺช: ปติตฺวา สวินยํ วกฺตุมาเรเภ, เห ปฺรโภ ยทิ ภวานิจฺฉติ ตรฺหิ มำ ปริษฺกรฺตฺตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ตทานีํ ส ปาณึ ปฺรสารฺยฺย ตทงฺคํ สฺปฺฤศนฺ พภาเษ ตฺวํ ปริษฺกฺริยเสฺวติ มเมจฺฉาสฺติ ตตสฺตตฺกฺษณํ ส กุษฺฐาตฺ มุกฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ปศฺจาตฺ ส ตมาชฺญาปยามาส กถามิมำ กไสฺมจิทฺ อกถยิตฺวา ยาชกสฺย สมีปญฺจ คตฺวา สฺวํ ทรฺศย, โลเกโภฺย นิชปริษฺกฺฤตตฺวสฺย ปฺรมาณทานาย มูสาชฺญานุสาเรณ ทฺรวฺยมุตฺมฺฤชสฺว จฯ ");
INSERT INTO santha_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ตถาปิ ยีโศ: สุขฺยาติ รฺพหุ วฺยาปฺตุมาเรเภ กิญฺจ ตสฺย กถำ โศฺรตุํ สฺวียโรเคโภฺย โมกฺตุญฺจ โลกา อาชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","อถ ส ปฺรานฺตรํ คตฺวา ปฺรารฺถยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","อปรญฺจ เอกทา ยีศุรุปทิศติ, เอตรฺหิ คาลีลฺยิหูทาปฺรเทศโย: สรฺวฺวนคเรโภฺย ยิรูศาลมศฺจ กิยนฺต: ผิรูศิโลกา วฺยวสฺถาปกาศฺจ สมาคตฺย ตทนฺติเก สมุปวิวิศุ:, ตสฺมินฺ กาเล โลกานามาโรคฺยการณาตฺ ปฺรโภ: ปฺรภาว: ปฺรจกาเศฯ ");
INSERT INTO santha_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ปศฺจาตฺ กิยนฺโต โลกา เอกํ ปกฺษาฆาตินํ ขฏฺวายำ นิธาย ยีโศ: สมีปมาเนตุํ สมฺมุเข สฺถาปยิตุญฺจ วฺยาปฺริยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","กินฺตุ พหุชนนิวหสมฺวาธาตฺ น ศกฺนุวนฺโต คฺฤโหปริ คตฺวา คฺฤหปฺฤษฺฐํ ขนิตฺวา ตํ ปกฺษาฆาตินํ สขฏฺวํ คฺฤหมเธฺย ยีโศ: สมฺมุเข 'วโรหยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ตทา ยีศุเสฺตษามฺ อีทฺฤศํ วิศฺวาสํ วิโลกฺย ตํ ปกฺษาฆาตินํ วฺยาชหาร, เห มานว ตว ปาปมกฺษมฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ตสฺมาทฺ อธฺยาปกา: ผิรูศินศฺจ จิตฺไตริตฺถํ ปฺรจินฺติตวนฺต:, เอษ ชน อีศฺวรํ นินฺทติ โกยํ? เกวลมีศฺวรํ วินา ปาปํ กฺษนฺตุํ ก: ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ตทา ยีศุเสฺตษามฺ อิตฺถํ จินฺตนํ วิทิตฺวา เตโภฺยกถยทฺ ยูยํ มโนภิ: กุโต วิตรฺกยถ? ");
INSERT INTO santha_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ตว ปาปกฺษมา ชาตา ยทฺวา ตฺวมุตฺถาย วฺรช เอตโย รฺมเธฺย กา กถา สุกถฺยา? ");
INSERT INTO santha_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","กินฺตุ ปฺฤถิวฺยำ ปาปํ กฺษนฺตุํ มานวสุตสฺย สามรฺถฺยมสฺตีติ ยถา ยูยํ ชฺญาตุํ ศกฺนุถ ตทรฺถํ (ส ตํ ปกฺษาฆาตินํ ชคาท) อุตฺติษฺฐ สฺวศยฺยำ คฺฤหีตฺวา คฺฤหํ ยาหีติ ตฺวามาทิศามิฯ ");
INSERT INTO santha_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ตสฺมาตฺ ส ตตฺกฺษณมฺ อุตฺถาย สรฺเวฺวษำ สากฺษาตฺ นิชศยนียํ คฺฤหีตฺวา อีศฺวรํ ธนฺยํ วทนฺ นิชนิเวศนํ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ตสฺมาตฺ สรฺเวฺว วิสฺมย ปฺราปฺตา มน:สุ ภีตาศฺจ วยมทฺยาสมฺภวการฺยฺยาณฺยทรฺศาม อิตฺยุกฺตฺวา ปรเมศฺวรํ ธนฺยํ โปฺรทิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ตต: ปรํ พหิรฺคจฺฉนฺ กรสญฺจยสฺถาเน เลวินามานํ กรสญฺจายกํ ทฺฤษฺฏฺวา ยีศุสฺตมภิทเธ มม ปศฺจาเทหิฯ ");
INSERT INTO santha_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ตสฺมาตฺ ส ตตฺกฺษณาตฺ สรฺวฺวํ ปริตฺยชฺย ตสฺย ปศฺจาทิยายฯ ");
INSERT INTO santha_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","อนนฺตรํ เลวิ รฺนิชคฺฤเห ตทรฺถํ มหาโภชฺยํ จการ, ตทา ไต: สหาเนเก กรสญฺจายินสฺตทนฺยโลกาศฺจ โภกฺตุมุปวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ตสฺมาตฺ การณาตฺ จณฺฑาลานำ ปาปิโลกานาญฺจ สงฺเค ยูยํ กุโต ภํคฺเธฺว ปิวถ เจติ กถำ กถยิตฺวา ผิรูศิโน'ธฺยาปกาศฺจ ตสฺย ศิไษฺย: สห วาคฺยุทฺธํ กรฺตฺตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ตสฺมาทฺ ยีศุสฺตานฺ ปฺรตฺยโวจทฺ อโรคโลกานำ จิกิตฺสเกน ปฺรโยชนํ นาสฺติ กินฺตุ สโรคาณาเมวฯ ");
INSERT INTO santha_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","อหํ ธารฺมฺมิกานฺ อาหฺวาตุํ นาคโตสฺมิ กินฺตุ มน: ปราวรฺตฺตยิตุํ ปาปิน เอวฯ ");
INSERT INTO santha_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ตตเสฺต โปฺรจุ:, โยหน: ผิรูศินาญฺจ ศิษฺยา วารํวารมฺ อุปวสนฺติ ปฺรารฺถยนฺเต จ กินฺตุ ตว ศิษฺยา: กุโต ภุญฺชเต ปิวนฺติ จ? ");
INSERT INTO santha_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ตทา ส ตานาจเขฺยา วเร สงฺเค ติษฺฐติ วรสฺย สขิคณํ กิมุปวาสยิตุํ ศกฺนุถ? ");
INSERT INTO santha_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","กินฺตุ ยทา เตษำ นิกฏาทฺ วโร เนษฺยเต ตทา เต สมุปวตฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","โสปรมปิ ทฺฤษฺฏานฺตํ กถยามฺพภูว ปุราตนวสฺเตฺร โกปิ นุตนวสฺตฺรํ น สีวฺยติ ยตเสฺตน เสวเนน ชีรฺณวสฺตฺรํ ฉิทฺยเต, นูตนปุราตนวสฺตฺรโย เรฺมลญฺจ น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ปุราตนฺยำ กุตฺวำ โกปิ นุตนํ ทฺรากฺษารสํ น นิทธาติ, ยโต นวีนทฺรากฺษารสสฺย เตชสา ปุราตนี กุตู รฺวิทีรฺยฺยเต ตโต ทฺรากฺษารส: ปตติ กุตูศฺจ นศฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ตโต เหโต รฺนูตนฺยำ กุตฺวำ นวีนทฺรากฺษารส: นิธาตวฺยเสฺตโนภยสฺย รกฺษา ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","อปรญฺจ ปุราตนํ ทฺรากฺษารสํ ปีตฺวา โกปิ นูตนํ น วาญฺฉติ, ยต: ส วกฺติ นูตนาตฺ ปุราตนมฺ ปฺรศสฺตมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","อจรญฺจ ปรฺวฺวโณ ทฺวิตียทินาตฺ ปรํ ปฺรถมวิศฺรามวาเร ศสฺยกฺเษเตฺรณ ยีโศรฺคมนกาเล ตสฺย ศิษฺยา: กณิศํ ฉิตฺตฺวา กเรษุ มรฺทฺทยิตฺวา ขาทิตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ตสฺมาตฺ กิยนฺต: ผิรูศินสฺตานวทนฺ วิศฺรามวาเร ยตฺ กรฺมฺม น กรฺตฺตวฺยํ ตตฺ กุต: กุรุถ? ");
INSERT INTO santha_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ยีศุ: ปฺรตฺยุวาจ ทายูทฺ ตสฺย สงฺคินศฺจ กฺษุธารฺตฺตา: กึ จกฺรุ: ส กถมฺ อีศฺวรสฺย มนฺทิรํ ปฺรวิศฺย ");
INSERT INTO santha_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","เย ทรฺศนียา: ปูปา ยาชกานฺ วินานฺยสฺย กสฺยาปฺยโภชนียาสฺตานานีย สฺวยํ พุภเช สงฺคิโภฺยปิ ทเทา ตตฺ กึ ยุษฺมาภิ: กทาปิ นาปาฐิ? ");
INSERT INTO santha_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ปศฺจาตฺ ส ตานวทตฺ มนุชสุโต วิศฺรามวารสฺยาปิ ปฺรภุ รฺภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","อนนฺตรมฺ อนฺยวิศฺรามวาเร ส ภชนเคหํ ปฺรวิศฺย สมุปทิศติฯ ตทา ตตฺสฺถาเน ศุษฺกทกฺษิณกร เอก: ปุมานฺ อุปตสฺถิวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ตสฺมาทฺ อธฺยาปกา: ผิรูศินศฺจ ตสฺมินฺ โทษมาโรปยิตุํ ส วิศฺรามวาเร ตสฺย สฺวาสฺถฺยํ กโรติ นเวติ ปฺรตีกฺษิตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ตทา ยีศุเสฺตษำ จินฺตำ วิทิตฺวา ตํ ศุษฺกกรํ ปุมำสํ โปฺรวาจ, ตฺวมุตฺถาย มธฺยสฺถาเน ติษฺฐฯ ");
INSERT INTO santha_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ตสฺมาตฺ ตสฺมินฺ อุตฺถิตวติ ยีศุสฺตานฺ วฺยาชหาร, ยุษฺมานฺ อิมำ กถำ ปฺฤจฺฉามิ, วิศฺรามวาเร หิตมฺ อหิตํ วา, ปฺราณรกฺษณํ ปฺราณนาศนํ วา, เอเตษำ กึ กรฺมฺมกรณียมฺ? ");
INSERT INTO santha_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ปศฺจาตฺ จตุรฺทิกฺษุ สรฺวฺวานฺ วิโลกฺย ตํ มานวํ พภาเษ, นิชกรํ ปฺรสารย; ตตเสฺตน ตถา กฺฤต อิตรกรวตฺ ตสฺย หสฺต: สฺวโสฺถภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ตสฺมาตฺ เต ปฺรจณฺฑโกปานฺวิตา ยีศุํ กึ กริษฺยนฺตีติ ปรสฺปรํ ปฺรมนฺตฺริตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ตต: ปรํ ส ปรฺวฺวตมารุเหฺยศฺวรมุทฺทิศฺย ปฺรารฺถยมาน: กฺฤตฺสฺนำ ราตฺรึ ยาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","อถ ทิเน สติ ส สรฺวฺวานฺ ศิษฺยานฺ อาหูตวานฺ เตษำ มเธฺย ");
INSERT INTO santha_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ปิตรนามฺนา ขฺยาต: ศิโมนฺ ตสฺย ภฺราตา อานฺทฺริยศฺจ ยากูพฺ โยหนฺ จ ผิลิปฺ พรฺถลมยศฺจ ");
INSERT INTO santha_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","มถิ: โถมา อาลฺผียสฺย ปุโตฺร ยากูพฺ ชฺวลนฺตนามฺนา ขฺยาต: ศิโมนฺ ");
INSERT INTO santha_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","จ ยากูโพ ภฺราตา ยิหูทาศฺจ ตํ ย: ปรกเรษุ สมรฺปยิษฺยติ ส อีษฺกรีโยตียยิหูทาศฺไจตานฺ ทฺวาทศ ชนานฺ มโนนีตานฺ กฺฤตฺวา ส ชคฺราห ตถา เปฺรริต อิติ เตษำ นาม จการฯ ");
INSERT INTO santha_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ตต: ปรํ ส ไต: สห ปรฺวฺวตาทวรุหฺย อุปตฺยกายำ ตเสฺถา ตตสฺตสฺย ศิษฺยสงฺโฆ ยิหูทาเทศาทฺ ยิรูศาลมศฺจ โสร: สีโทนศฺจ ชลเธ โรธโส ชนนิหาศฺจ เอตฺย ตสฺย กถาศฺรวณารฺถํ โรคมุกฺตฺยรฺถญฺจ ตสฺย สมีเป ตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","อเมธฺยภูตคฺรสฺตาศฺจ ตนฺนิกฏมาคตฺย สฺวาสฺถฺยํ ปฺราปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","สรฺเวฺวษำ สฺวาสฺถฺยกรณปฺรภาวสฺย ปฺรกาศิตตฺวาตฺ สรฺเวฺว โลกา เอตฺย ตํ สฺปฺรษฺฏุํ เยติเรฯ ");
INSERT INTO santha_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ปศฺจาตฺ ส ศิษฺยานฺ ปฺรติ ทฺฤษฺฏึ กุตฺวา ชคาท, เห ทริทฺรา ยูยํ ธนฺยา ยต อีศฺวรีเย ราเชฺย โว'ธิกาโรสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","เห อธุนา กฺษุธิตโลกา ยูยํ ธนฺยา ยโต ยูยํ ตรฺปฺสฺยถ; เห อิห โรทิโน ชนา ยูยํ ธนฺยา ยโต ยูยํ หสิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ยทา โลกา มนุษฺยสูโน รฺนามเหโต รฺยุษฺมานฺ ฤृตียิษฺยนฺเต ปฺฤถกฺ กฺฤตฺวา นินฺทิษฺยนฺติ, อธมานิว ยุษฺมานฺ สฺวสมีปาทฺ ทูรีกริษฺยนฺติ จ ตทา ยูยํ ธนฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","สฺวรฺเค ยุษฺมากํ ยเถษฺฏํ ผลํ ภวิษฺยติ, เอตทรฺถํ ตสฺมินฺ ทิเน โปฺรลฺลสต อานนฺเทน นฺฤตฺยต จ, เตษำ ปูรฺวฺวปุรุษาศฺจ ภวิษฺยทฺวาทิน: ปฺรติ ตไถว วฺยวาหรนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","กินฺตุ หา หา ธนวนฺโต ยูยํ สุขํ ปฺราปฺนุตฯ หนฺต ปริตฺฤปฺตา ยูยํ กฺษุธิตา ภวิษฺยถ; ");
INSERT INTO santha_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","อิห หสนฺโต ยูยํ วต ยุษฺมาภิ: โศจิตวฺยํ โรทิตวฺยญฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","สรฺไวฺวลาไก รฺยุษฺมากํ สุขฺยาเตา กฺฤตายำ ยุษฺมากํ ทุรฺคติ รฺภวิษฺยติ ยุษฺมากํ ปูรฺวฺวปุรุษา มฺฤษาภวิษฺยทฺวาทิน: ปฺรติ ตทฺวตฺ กฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","เห โศฺรตาโร ยุษฺมภฺยมหํ กถยามิ, ยูยํ ศตฺรุษุ ปฺรียธฺวํ เย จ ยุษฺมานฺ ทฺวิษนฺติ เตษามปิ หิตํ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","เย จ ยุษฺมานฺ ศปนฺติ เตภฺย อาศิษํ ทตฺต เย จ ยุษฺมานฺ อวมนฺยนฺเต เตษำ มงฺคลํ ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ยทิ กศฺจิตฺ ตว กโปเล จเปฏาฆาตํ กโรติ ตรฺหิ ตํ ปฺรติ กโปลมฺ อนฺยํ ปราวรฺตฺตฺย สมฺมุขีกุรุ ปุนศฺจ ยทิ กศฺจิตฺ ตว คาตฺรียวสฺตฺรํ หรติ ตรฺหิ ตํ ปริเธยวสฺตฺรมฺ อปิ คฺรหีตุํ มา วารยฯ ");
INSERT INTO santha_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ยสฺตฺวำ ยาจเต ตไสฺม เทหิ, ยศฺจ ตว สมฺปตฺตึ หรติ ตํ มา ยาจสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ปเรภฺย: สฺวานฺ ปฺรติ ยถาจรณมฺ อเปกฺษเธฺว ปรานฺ ปฺรติ ยูยมปิ ตถาจรตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","เย ชนา ยุษฺมาสุ ปฺรียนฺเต เกวลํ เตษุ ปฺรียมาเณษุ ยุษฺมากํ กึ ผลํ? ปาปิโลกา อปิ เสฺวษุ ปฺรียมาเณษุ ปฺรียนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ยทิ หิตการิณ เอว หิตํ กุรุถ ตรฺหิ ยุษฺมากํ กึ ผลํ? ปาปิโลกา อปิ ตถา กุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","เยภฺย ฤณปริโศธสฺย ปฺราปฺติปฺรตฺยาศาเสฺต เกวลํ เตษุ ฤเณ สมรฺปิเต ยุษฺมากํ กึ ผลํ? ปุน: ปฺราปฺตฺยาศยา ปาปีโลกา อปิ ปาปิชเนษุ ฤณมฺ อรฺปยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","อโต ยูยํ ริปุษฺวปิ ปฺรียธฺวํ, ปรหิตํ กุรุต จ; ปุน: ปฺราปฺตฺยาศำ ตฺยกฺตฺวา ฤณมรฺปยต, ตถา กฺฤเต ยุษฺมากํ มหาผลํ ภวิษฺยติ, ยูยญฺจ สรฺวฺวปฺรธานสฺย สนฺตานา อิติ ขฺยาตึ ปฺราปฺสฺยถ, ยโต ยุษฺมากํ ปิตา กฺฤตฆฺนานำ ทุรฺวฺฏตฺตานาญฺจ หิตมาจรติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","อต เอว ส ยถา ทยาลุ รฺยูยมปิ ตาทฺฤศา ทยาลโว ภวตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","อปรญฺจ ปรานฺ โทษิโณ มา กุรุต ตสฺมาทฺ ยูยํ โทษีกฺฤตา น ภวิษฺยถ; อทณฺฑฺยานฺ มา ทณฺฑยต ตสฺมาทฺ ยูยมปิ ทณฺฑํ น ปฺราปฺสฺยถ; ปเรษำ โทษานฺ กฺษมธฺวํ ตสฺมาทฺ ยุษฺมากมปิ โทษา: กฺษมิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ทานานิทตฺต ตสฺมาทฺ ยูยํ ทานานิ ปฺราปฺสฺยถ, วรญฺจ โลกา: ปริมาณปาตฺรํ ปฺรทลยฺย สญฺจาลฺย โปฺรญฺจาลฺย ปริปูรฺยฺย ยุษฺมากํ โกฺรเฑษุ สมรฺปยิษฺยนฺติ; ยูยํ เยน ปริมาเณน ปริมาถ เตไนว ปริมาเณน ยุษฺมตฺกฺฤเต ปริมาสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","อถ ส เตโภฺย ทฺฤษฺฏานฺตกถามกถยตฺ, อนฺโธ ชน: กิมนฺธํ ปนฺถานํ ทรฺศยิตุํ ศกฺโนติ? ตสฺมาทฺ อุภาวปิ กึ ครฺตฺเต น ปติษฺยต:? ");
INSERT INTO santha_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","คุโร: ศิโษฺย น เศฺรษฺฐ: กินฺตุ ศิเษฺย สิทฺเธ สติ ส คุรุตุโลฺย ภวิตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","อปรญฺจ ตฺวํ สฺวจกฺษุुษิ นาสามฺ อทฺฤษฺฏฺวา ตว ภฺราตุศฺจกฺษุษิ ยตฺตฺฤณมสฺติ ตเทว กุต: ปศฺยมิ? ");
INSERT INTO santha_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","สฺวจกฺษุษิ ยา นาสา วิทฺยเต ตามฺ อชฺญาตฺวา, ภฺราตสฺตว เนตฺราตฺ ตฺฤณํ พหิ: กโรมีติ วากฺยํ ภฺราตรํ กถํ วกฺตุํ ศกฺโนษิ? เห กปฏินฺ ปูรฺวฺวํ สฺวนยนาตฺ นาสำ พหิ: กุรุ ตโต ภฺราตุศฺจกฺษุษสฺตฺฤณํ พหิ: กรฺตฺตุํ สุทฺฤษฺฏึ ปฺราปฺสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","อนฺยญฺจ อุตฺตมสฺตรุ: กทาปิ ผลมนุตฺตมํ น ผลติ, อนุตฺตมตรุศฺจ ผลมุตฺตมํ น ผลติ การณาทต: ผไลสฺตรโว ชฺญายนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","กณฺฏกิปาทปาตฺ โกปิ อุฑุมฺพรผลานิ น ปาตยติ ตถา ศฺฤคาลโกลิวฺฤกฺษาทปิ โกปิ ทฺรากฺษาผลํ น ปาตยติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ตทฺวตฺ สาธุโลโก'นฺต:กรณรูปาตฺ สุภาณฺฑาคาราทฺ อุตฺตมานิ ทฺรวฺยาณิ พหิ: กโรติ, ทุษฺโฏ โลกศฺจานฺต:กรณรูปาตฺ กุภาณฺฑาคาราตฺ กุตฺสิตานิ ทฺรวฺยาณิ นิรฺคมยติ ยโต'นฺต:กรณานำ ปูรฺณภาวานุรูปาณิ วจำสิ มุขานฺนิรฺคจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","อปรญฺจ มมาชฺญานุรูปํ นาจริตฺวา กุโต มำ ปฺรโภ ปฺรโภ อิติ วทถ? ");
INSERT INTO santha_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ย: กศฺจินฺ มม นิกฏมฺ อาคตฺย มม กถา นิศมฺย ตทนุรูปํ กรฺมฺม กโรติ ส กสฺย สทฺฤโศ ภวติ ตทหํ ยุษฺมานฺ ชฺญาाปยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","โย ชโน คภีรํ ขนิตฺวา ปาษาณสฺถเล ภิตฺตึ นิรฺมฺมาย สฺวคฺฤหํ รจยติ เตน สห ตโสฺยปมา ภวติ; ยต อาปฺลาวิชลเมตฺย ตสฺย มูเล เวเคน วหทปิ ตทฺเคหํ ลาฑยิตุํ น ศกฺโนติ ยตสฺตสฺย ภิตฺติ: ปาษาโณปริ ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","กินฺตุ ย: กศฺจินฺ มม กถา: ศฺรุตฺวา ตทนุรูปํ นาจรติ ส ภิตฺตึ วินา มฺฤृทุปริ คฺฤหนิรฺมฺมาตฺรา สมาโน ภวติ; ยต อาปฺลาวิชลมาคตฺย เวเคน ยทา วหติ ตทา ตทฺคฺฤหํ ปตติ ตสฺย มหตฺ ปตนํ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ตต: ปรํ ส โลกานำ กรฺณโคจเร ตานฺ สรฺวฺวานฺ อุปเทศานฺ สมาปฺย ยทา กผรฺนาหูมฺปุรํ ปฺรวิศติ ");
INSERT INTO santha_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ตทา ศตเสนาปเต: ปฺริยทาส เอโก มฺฤตกลฺป: ปีฑิต อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","อต: เสนาปติ รฺยีโศ รฺวารฺตฺตำ นิศมฺย ทาสสฺยาโรคฺยกรณาย ตสฺยาคมนารฺถํ วินยกรณาย ยิหูทียานฺ กิยต: ปฺราจ: เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","เต ยีโศรนฺติกํ คตฺวา วินยาติศยํ วกฺตุมาเรภิเร, ส เสนาปติ รฺภวโตนุคฺรหํ ปฺราปฺตุมฺ อรฺหติฯ ");
INSERT INTO santha_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ยต: โสสฺมชฺชาตีเยษุ โลเกษุ ปฺรียเต ตถาสฺมตฺกฺฤเต ภชนเคหํ นิรฺมฺมิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ตสฺมาทฺ ยีศุไสฺต: สห คตฺวา นิเวศนสฺย สมีปํ ปฺราป, ตทา ส ศตเสนาปติ รฺวกฺษฺยมาณวากฺยํ ตํ วกฺตุํ พนฺธูนฺ ปฺราหิโณตฺฯ เห ปฺรโภ สฺวยํ ศฺรโม น กรฺตฺตโวฺย ยทฺ ภวตา มทฺเคหมเธฺย ปาทารฺปณํ กฺริเยต ตทปฺยหํ นารฺหามิ, ");
INSERT INTO santha_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","กิญฺจาหํ ภวตฺสมีปํ ยาตุมปิ นาตฺมานํ โยคฺยํ พุทฺธวานฺ, ตโต ภวานฺ วากฺยมาตฺรํ วทตุ เตไนว มม ทาส: สฺวโสฺถ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ยสฺมาทฺ อหํ ปราธีโนปิ มมาธีนา ยา: เสนา: สนฺติ ตาสามฺ เอกชนํ ปฺรติ ยาหีติ มยา โปฺรกฺเต ส ยาติ; ตทนฺยํ ปฺรติ อายาหีติ โปฺรกฺเต ส อายาติ; ตถา นิชทาสํ ปฺรติ เอตตฺ กุรฺวฺวิติ โปฺรกฺเต ส ตเทว กโรติฯ ");
INSERT INTO santha_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ยีศุริทํ วากฺยํ ศฺรุตฺวา วิสฺมยํ ยเยา, มุขํ ปราวรฺตฺย ปศฺจาทฺวรฺตฺติโน โลกานฺ พภาเษ จ, ยุษฺมานหํ วทามิ อิสฺราเยโล วํศมเธฺยปิ วิศฺวาสมีทฺฤศํ น ปฺราปฺนวํฯ ");
INSERT INTO santha_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ตตเสฺต เปฺรษิตา คฺฤหํ คตฺวา ตํ ปีฑิตํ ทาสํ สฺวสฺถํ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ปเร'หนิ ส นายีนาขฺยํ นครํ ชคาม ตสฺยาเนเก ศิษฺยา อเนฺย จ โลกาเสฺตน สารฺทฺธํ ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","เตษุ ตนฺนครสฺย ทฺวารสนฺนิธึ ปฺราปฺเตษุ กิยนฺโต โลกา เอกํ มฺฤตมนุชํ วหนฺโต นครสฺย พหิรฺยานฺติ, ส ตนฺมาตุเรกปุตฺรสฺตนฺมาตา จ วิธวา; ตยา สารฺทฺธํ ตนฺนครียา พหโว โลกา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ปฺรภุสฺตำ วิโลกฺย สานุกมฺป: กถยามาส, มา โรที:ฯ ส สมีปมิตฺวา ขฏฺวำ ปสฺปรฺศ ตสฺมาทฺ วาหกา: สฺถคิตาสฺตมฺยุ:; ");
INSERT INTO santha_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ตทา ส อุวาจ เห ยุวมนุษฺย ตฺวมุตฺติษฺฐ, ตฺวามหมฺ อาชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ตสฺมาตฺ ส มฺฤโต ชนสฺตตฺกฺษณมุตฺถาย กถำ ปฺรกถิต:; ตโต ยีศุสฺตสฺย มาตริ ตํ สมรฺปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ตสฺมาตฺ สรฺเวฺว โลกา: ศศงฺกิเร; เอโก มหาภวิษฺยทฺวาที มเธฺย'สฺมากมฺ สมุไทตฺ, อีศฺวรศฺจ สฺวโลกานนฺวคฺฤหฺลาตฺ กถามิมำ กถยิตฺวา อีศฺวรํ ธนฺยํ ชคทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ตต: ปรํ สมสฺตํ ยิหูทาเทศํ ตสฺย จตุรฺทิกฺสฺถเทศญฺจ ตไสฺยตตฺกีรฺตฺติ รฺวฺยานเศฯ ");
INSERT INTO santha_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ตต: ปรํ โยหน: ศิเษฺยษุ ตํ ตทฺวฺฤตฺตานฺตํ ชฺญาปิตวตฺสุ ");
INSERT INTO santha_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ส สฺวศิษฺยาณำ เทฺวา ชนาวาหูย ยีศุํ ปฺรติ วกฺษฺยมาณํ วากฺยํ วกฺตุํ เปฺรษยามาส, ยสฺยาคมนมฺ อเปกฺษฺย ติษฺฐาโม วยํ กึ ส เอว ชนสฺตฺวํ? กึ วยมนฺยมเปกฺษฺย สฺถาสฺยาม:? ");
INSERT INTO santha_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ปศฺจาตฺเตา มานเวา คตฺวา กถยามาสตุ:, ยสฺยาคมนมฺ อเปกฺษฺย ติษฺฐาโม วยํ, กึ เสอว ชนสฺตฺวํ? กึ วยมนฺยมเปกฺษฺย สฺถาสฺยาม:? กถามิมำ ตุภฺยํ กถยิตุํ โยหนฺ มชฺชก อาวำ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ตสฺมินฺ ทณฺเฑ ยีศูโรคิโณ มหาวฺยาธิมโต ทุษฺฏภูตคฺรสฺตำศฺจ พหูนฺ สฺวสฺถานฺ กฺฤตฺวา, อเนกานฺเธภฺยศฺจกฺษุํษิ ทตฺตฺวา ปฺรตฺยุวาจ, ");
INSERT INTO santha_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ยุวำ วฺรชตมฺ อนฺธา เนตฺราณิ ขญฺชาศฺจรณานิ จ ปฺราปฺนุวนฺติ, กุษฺฐิน: ปริษฺกฺริยนฺเต, พธิรา: ศฺรวณานิ มฺฤตาศฺจ ชีวนานิ ปฺราปฺนุวนฺติ, ทริทฺราณำ สมีเปษุ สุสํวาท: ปฺรจารฺยฺยเต, ยํ ปฺรติ วิฆฺนสฺวรูโปหํ น ภวามิ ส ธนฺย:, ");
INSERT INTO santha_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","เอตานิ ยานิ ปศฺยถ: ศฺฤณุถศฺจ ตานิ โยหนํ ชฺญาปยตมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ตโย รฺทูตโย รฺคตโย: สโต โรฺยหนิ ส โลกานฺ วกฺตุมุปจกฺรเม, ยูยํ มเธฺยปฺรานฺตรํ กึ ทฺรษฺฏุํ นิรคมต? กึ วายุนา กมฺปิตํ นฑํ? ");
INSERT INTO santha_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ยูยํ กึ ทฺรษฺฏุํ นิรคมต? กึ สูกฺษฺมวสฺตฺรปริธายินํ กมปิ นรํ? กินฺตุ เย สูกฺษฺมมฺฤทุวสฺตฺราณิ ปริทธติ สูตฺตมานิ ทฺรวฺยาณิ ภุญฺชเต จ เต ราชธานีษุ ติษฺฐนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ตรฺหิ ยูยํ กึ ทฺรษฺฏุํ นิรคมต? กิเมกํ ภวิษฺยทฺวาทินํ? ตเทว สตฺยํ กินฺตุ ส ปุมานฺ ภวิษฺยทฺวาทิโนปิ เศฺรษฺฐ อิตฺยหํ ยุษฺมานฺ วทามิ; ");
INSERT INTO santha_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ปศฺย สฺวกียทูตนฺตุ ตวาคฺร เปฺรษยามฺยหํฯ คตฺวา ตฺวทียมารฺคนฺตุ ส หิ ปริษฺกริษฺยติฯ ยทรฺเถ ลิปิริยมฺ อาเสฺต ส เอว โยหนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","อโต ยุษฺมานหํ วทามิ สฺตฺริยา ครฺพฺภชาตานำ ภวิษฺยทฺวาทินำ มเธฺย โยหโน มชฺชกาตฺ เศฺรษฺฐ: โกปิ นาสฺติ, ตตฺราปิ อีศฺวรสฺย ราเชฺย ย: สรฺวฺวสฺมาตฺ กฺษุทฺร: ส โยหโนปิ เศฺรษฺฐ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","อปรญฺจ สรฺเวฺว โลกา: กรมญฺจายินศฺจ ตสฺย วากฺยานิ ศฺรุตฺวา โยหนา มชฺชเนน มชฺชิตา: ปรเมศฺวรํ นิรฺโทษํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","กินฺตุ ผิรูศิโน วฺยวสฺถาปกาศฺจ เตน น มชฺชิตา: สฺวานฺ ปฺรตีศฺวรโสฺยปเทศํ นิษฺผลมฺ อกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","อถ ปฺรภุ: กถยามาส, อิทานีนฺตนชนานฺ เกโนปมามิ? เต กสฺย สทฺฤศา:? ");
INSERT INTO santha_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","เย พาลกา วิปณฺยามฺ อุปวิศฺย ปรสฺปรมฺ อาหูย วากฺยมิทํ วทนฺติ, วยํ ยุษฺมากํ นิกเฏ วํศีรวาทิษฺม, กินฺตุ ยูยํ นานรฺตฺติษฺฏ, วยํ ยุษฺมากํ นิกฏ อโรทิษฺม, กินฺตุ ยุยํ น วฺยลปิษฺฏ, พาลไกเรตาทฺฤไศเสฺตษามฺ อุปมา ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ยโต โยหนฺ มชฺชก อาคตฺย ปูปํ นาขาทตฺ ทฺรากฺษารสญฺจ นาปิวตฺ ตสฺมาทฺ ยูยํ วทถ, ภูตคฺรโสฺตยมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ตต: ปรํ มานวสุต อาคตฺยาขาททปิวญฺจ ตสฺมาทฺ ยูยํ วทถ, ขาทก: สุราปศฺจาณฺฑาลปาปินำ พนฺธุเรโก ชโน ทฺฤศฺยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","กินฺตุ ชฺญานิโน ชฺญานํ นิรฺโทษํ วิทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ปศฺจาเทก: ผิรูศี ยีศุํ โภชนาย นฺยมนฺตฺรยตฺ ตต: ส ตสฺย คฺฤหํ คตฺวา โภกฺตุมุปวิษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","เอตรฺหิ ตตฺผิรูศิโน คฺฤเห ยีศุ เรฺภกฺตุมฺ อุปาเวกฺษีตฺ ตจฺฉฺรุตฺวา ตนฺนครวาสินี กาปิ ทุษฺฏา นารี ปาณฺฑรปฺรสฺตรสฺย สมฺปุฏเก สุคนฺธิไตลมฺ อานีย ");
INSERT INTO santha_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ตสฺย ปศฺจาตฺ ปาทโย: สนฺนิเธา ตเสฺยา รุทตี จ เนตฺรามฺพุภิสฺตสฺย จรเณา ปฺรกฺษาลฺย นิชกไจรมารฺกฺษีตฺ, ตตสฺตสฺย จรเณา จุมฺพิตฺวา เตน สุคนฺธิไตเลน มมรฺทฯ ");
INSERT INTO santha_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ตสฺมาตฺ ส นิมนฺตฺรยิตา ผิรูศี มนสา จินฺตยามาส, ยทฺยยํ ภวิษฺยทฺวาที ภเวตฺ ตรฺหิ เอนํ สฺปฺฤศติ ยา สฺตฺรี สา กา กีทฺฤศี เจติ ชฺญาตุํ ศกฺนุยาตฺ ยต: สา ทุษฺฏาฯ ");
INSERT INTO santha_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ตทา ยาศุสฺตํ ชคาท, เห ศิโมนฺ ตฺวำ ปฺรติ มม กิญฺจิทฺ วกฺตวฺยมสฺติ; ตสฺมาตฺ ส พภาเษ, เห คุโร ตทฺ วทตุฯ ");
INSERT INTO santha_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","เอโกตฺตมรฺณสฺย ทฺวาวธมรฺณาวาสฺตำ, ตโยเรก: ปญฺจศตานิ มุทฺราปาทานฺ อปรศฺจ ปญฺจาศตฺ มุทฺราปาทานฺ ธารยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ตทนนฺตรํ ตโย: โศธฺยาภาวาตฺ ส อุตฺตมรฺณสฺตโย รฺฤเณ จกฺษเม; ตสฺมาตฺ ตโยรฺทฺวโย: กสฺตสฺมินฺ เปฺรษฺยเต พหุ? ตทฺ พฺรูหิฯ ");
INSERT INTO santha_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ศิโมนฺ ปฺรตฺยุวาจ, มยา พุธฺยเต ยสฺยาธิกมฺ ฤณํ จกฺษเม ส อิติ; ตโต ยีศุสฺตํ วฺยาชหาร, ตฺวํ ยถารฺถํ วฺยจารย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","อถ ตำ นารีํ ปฺรติ วฺยาฆุฐฺย ศิโมนมโวจตฺ, สฺตฺรีมิมำ ปศฺยสิ? ตว คฺฤเห มยฺยาคเต ตฺวํ ปาทปฺรกฺษาลนารฺถํ ชลํ นาทา: กินฺตุ โยษิเทษา นยนชไล รฺมม ปาเทา ปฺรกฺษาลฺย เกไศรมารฺกฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ตฺวํ มำ นาจุมฺพี: กินฺตุ โยษิเทษา สฺวียาคมนาทารภฺย มทียปาเทา จุมฺพิตุํ น วฺยรํสฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ตฺวญฺจ มทีโยตฺตมางฺเค กิญฺจิทปิ ไตลํ นามรฺที: กินฺตุ โยษิเทษา มม จรเณา สุคนฺธิไตเลนามรฺทฺทีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","อตสฺตฺวำ วฺยาหรามิ, เอตสฺยา พหุ ปาปมกฺษมฺยต ตโต พหุ ปฺรียเต กินฺตุ ยสฺยาลฺปปาปํ กฺษมฺยเต โสลฺปํ ปฺรียเตฯ ");
INSERT INTO santha_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ตต: ปรํ ส ตำ พภาเษ, ตฺวทียํ ปาปมกฺษมฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ตทา เตน สารฺทฺธํ เย โภกฺตุมฺ อุปวิวิศุเสฺต ปรสฺปรํ วกฺตุมาเรภิเร, อยํ ปาปํ กฺษมเต ก เอษ:? ");
INSERT INTO santha_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","กินฺตุ ส ตำ นารีํ ชคาท, ตว วิศฺวาสสฺตฺวำ ปรฺยฺยตฺราสฺต ตฺวํ เกฺษเมณ วฺรชฯ ");
INSERT INTO santha_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","อปรญฺจ ยีศุ รฺทฺวาทศภิ: ศิไษฺย: สารฺทฺธํ นานานคเรษุ นานาคฺราเมษุ จ คจฺฉนฺ อิศฺวรียราชตฺวสฺย สุสํวาทํ ปฺรจารยิตุํ ปฺราเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ตทา ยสฺยา: สปฺต ภูตา นิรคจฺฉนฺ สา มคฺทลีนีติ วิขฺยาตา มริยมฺ เหโรทฺราชสฺย คฺฤหาธิปเต: โหเษ รฺภารฺยฺยา โยหนา ศูศานา ");
INSERT INTO santha_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ปฺรภฺฤตโย ยา พหฺวฺย: สฺตฺริย: ทุษฺฏภูเตโภฺย โรเคภฺยศฺจ มุกฺตา: สโตฺย นิชวิภูตี รฺวฺยยิตฺวา ตมเสวนฺต, ตา: สรฺวฺวาเสฺตน สารฺทฺธมฺ อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","อนนฺตรํ นานานคเรโภฺย พหโว โลกา อาคตฺย ตสฺย สมีเป'มิลนฺ, ตทา ส เตภฺย เอกำ ทฺฤษฺฏานฺตกถำ กถยามาสฯ เอก: กฺฤษีพโล พีชานิ วปฺตุํ พหิรฺชคาม, ");
INSERT INTO santha_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ตโต วปนกาเล กติปยานิ พีชานิ มารฺคปารฺเศฺว เปตุ:, ตตสฺตานิ ปทตไล รฺทลิตานิ ปกฺษิภิ รฺภกฺษิตานิ จฯ ");
INSERT INTO santha_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","กติปยานิ พีชานิ ปาษาณสฺถเล ปติตานิ ยทฺยปิ ตานฺยงฺกุริตานิ ตถาปิ รสาภาวาตฺ ศุศุษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","กติปยานิ พีชานิ กณฺฏกิวนมเธฺย ปติตานิ ตต: กณฺฏกิวนานิ สํวฺฤทฺธฺย ตานิ ชคฺรสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ตทนฺยานิ กติปยพีชานิ จ ภูมฺยามุตฺตมายำ เปตุสฺตตสฺตานฺยงฺกุรยิตฺวา ศตคุณานิ ผลานิ เผลุ:ฯ ส อิมา กถำ กถยิตฺวา โปฺรจฺไจ: โปฺรวาจ, ยสฺย โศฺรตุํ โศฺรเตฺร สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ตต: ปรํ ศิษฺยาสฺตํ ปปฺรจฺฉุรสฺย ทฺฤษฺฏานฺตสฺย กึ ตาตฺปรฺยฺยํ? ");
INSERT INTO santha_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ตต: ส วฺยาชหาร, อีศฺวรียราชฺยสฺย คุหฺยานิ ชฺญาตุํ ยุษฺมภฺยมธิกาโร ทียเต กินฺตฺวเนฺย ยถา ทฺฤษฺฏฺวาปิ น ปศฺยนฺติ ศฺรุตฺวาปิ ม พุธฺยนฺเต จ ตทรฺถํ เตษำ ปุรสฺตาตฺ ตา: สรฺวฺวา: กถา ทฺฤษฺฏานฺเตน กถฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ทฺฤษฺฏานฺตสฺยาสฺยาภิปฺราย:, อีศฺวรียกถา พีชสฺวรูปาฯ ");
INSERT INTO santha_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","เย กถามาตฺรํ ศฺฤณฺวนฺติ กินฺตุ ปศฺจาทฺ วิศฺวสฺย ยถา ปริตฺราณํ น ปฺราปฺนุวนฺติ ตทาศเยน ไศตาเนตฺย หฺฤทยาตฺฤ ตำ กถามฺ อปหรติ ต เอว มารฺคปารฺศฺวสฺถภูมิสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","เย กถํ ศฺรุตฺวา สานนฺทํ คฺฤหฺลนฺติ กินฺตฺวพทฺธมูลตฺวาตฺ สฺวลฺปกาลมาตฺรํ ปฺรตีตฺย ปรีกฺษากาเล ภฺรศฺยนฺติ เตอว ปาษาณภูมิสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","เย กถำ ศฺรุตฺวา ยานฺติ วิษยจินฺตายำ ธนโลเภน เอेหิกสุเข จ มชฺชนฺต อุปยุกฺตผลานิ น ผลนฺติ ต เอโวปฺตพีชกณฺฏกิภูสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","กินฺตุ เย ศฺรุตฺวา สรไล: ศุทฺไธศฺจานฺต:กรไณ: กถำ คฺฤหฺลนฺติ ไธรฺยฺยมฺ อวลมฺพฺย ผลานฺยุตฺปาทยนฺติ จ ต เอโวตฺตมมฺฤตฺสฺวรูปา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","อปรญฺจ ปฺรทีปํ ปฺรชฺวาลฺย โกปิ ปาเตฺรณ นาจฺฉาทยติ ตถา ขฏฺวาโธปิ น สฺถาปยติ, กินฺตุ ทีปาธาโรปรฺเยฺยว สฺถาปยติ, ตสฺมาตฺ ปฺรเวศกา ทีปฺตึ ปศฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ยนฺน ปฺรกาศยิษฺยเต ตาทฺฤคฺ อปฺรกาศิตํ วสฺตุ กิมปิ นาสฺติ ยจฺจ น สุวฺยกฺตํ ปฺรจารยิษฺยเต ตาทฺฤคฺ คฺฤปฺตํ วสฺตุ กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","อโต ยูยํ เกน ปฺรกาเรณ ศฺฤณุถ ตตฺร สาวธานา ภวต, ยสฺย สมีเป พรฺทฺธเต ตไสฺม ปุนรฺทาสฺยเต กินฺตุ ยสฺยาศฺรเย น พรฺทฺธเต ตสฺย ยทฺยทสฺติ ตทปิ ตสฺมาตฺ เนษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","อปรญฺจ ยีโศ รฺมาตา ภฺราตรศฺจ ตสฺย สมีปํ ชิคมิษว: ");
INSERT INTO santha_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","กินฺตุ ชนตาสมฺพาธาตฺ ตตฺสนฺนิธึ ปฺราปฺตุํ น เศกุ:ฯ ตตฺปศฺจาตฺ ตว มาตา ภฺราตรศฺจ ตฺวำ สากฺษาตฺ จิกีรฺษนฺโต พหิสฺติษฺฐนตีติ วารฺตฺตายำ ตไสฺม กถิตายำ ");
INSERT INTO santha_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ส ปฺรตฺยุวาจ; เย ชนา อีศฺวรสฺย กถำ ศฺรุตฺวา ตทนุรูปมาจรนฺติ เตอว มม มาตา ภฺราตรศฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","อนนฺตรํ เอกทา ยีศุ: ศิไษฺย: สารฺทฺธํ นาวมารุหฺย ชคาท, อายาต วยํ หฺรทสฺย ปารํ ยาม:, ตตเสฺต ชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","เตษุ เนากำ วาหยตฺสุ ส นิทเทฺรา; ");
INSERT INTO santha_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","อถากสฺมาตฺ ปฺรพลฌญฺภฺศคมาทฺ หฺรเท เนากายำ ตรงฺไคราจฺฉนฺนายำ วิปตฺ ตานฺ ชคฺราสฯ ตสฺมาทฺ ยีโศรนฺติกํ คตฺวา เห คุโร เห คุโร ปฺราณา โน ยานฺตีติ คทิตฺวา ตํ ชาครยามฺพภูวุ:ฯ ตทา ส อุตฺถาย วายุํ ตรงฺคำศฺจ ตรฺชยามาส ตสฺมาทุเภา นิวฺฤตฺย สฺถิเรา พภูวตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ส ตานฺ พภาเษ ยุษฺมากํ วิศฺวาส: ก? ตสฺมาตฺเต ภีตา วิสฺมิตาศฺจ ปรสฺปรํ ชคทุ:, อโห กีทฺฤคยํ มนุช: ปวนํ ปานียญฺจาทิศติ ตทุภยํ ตทาเทศํ วหติฯ ");
INSERT INTO santha_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ตต: ปรํ คาลีลฺปฺรเทศสฺย สมฺมุขสฺถคิเทรียปฺรเทเศ เนากายำ ลคนฺตฺยำ ตเฏ'วโรหมาวาทฺ ");
INSERT INTO santha_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","พหุติถกาลํ ภูตคฺรสฺต เอโก มานุษ: ปุราทาคตฺย ตํ สากฺษาจฺจการฯ ส มนุโษ วาโส น ปริทธตฺ คฺฤเห จ น วสนฺ เกวลํ ศฺมศานมฺ อธฺยุวาสฯ ");
INSERT INTO santha_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ส ยีศุํ ทฺฤษฺไฏฺวว จีจฺฉพฺทํ จการ ตสฺย สมฺมุเข ปติตฺวา โปฺรจฺไจรฺชคาท จ, เห สรฺวฺวปฺรธาเนศฺวรสฺย ปุตฺร, มยา สห ตว ก: สมฺพนฺธ:? ตฺวยิ วินยํ กโรมิ มำ มา ยาตยฯ ");
INSERT INTO santha_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ยต: ส ตํ มานุษํ ตฺยกฺตฺวา ยาตุมฺ อเมธฺยภูตมฺ อาทิเทศ; ส ภูตสฺตํ มานุษมฺ อสกฺฤทฺ ทธาร ตสฺมาโลฺลกา: ศฺฤงฺขเลน นิคเฑน จ พพนฺธุ:; ส ตทฺ ภํกฺตฺวา ภูตวศตฺวาตฺ มเธฺยปฺรานฺตรํ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","อนนฺตรํ ยีศุสฺตํ ปปฺรจฺฉ ตว กินฺนาม? ส อุวาจ, มม นาม พาหิโน ยโต พหโว ภูตาสฺตมาศิศฺริยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","อถ ภูตา วินเยน ชคทุ:, คภีรํ ครฺตฺตํ คนฺตุํ มาชฺญาปยาสฺมานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ตทา ปรฺวฺวโตปริ วราหวฺรชศฺจรติ ตสฺมาทฺ ภูตา วินเยน โปฺรจุ:, อมุํ วราหวฺรชมฺ อาศฺรยิตุมฺ อสฺมานฺ อนุชานีหิ; ตต: โสนุชชฺเญาฯ ");
INSERT INTO santha_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ตต: ปรํ ภูตาสฺตํ มานุษํ วิหาย วราหวฺรชมฺ อาศิศฺริยุ: วราหวฺรชาศฺจ ตตฺกฺษณาตฺ กฏเกน ธาวนฺโต หฺรเท ปฺราณานฺ วิชฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ตทฺ ทฺฤษฺฏฺวา ศูกรรกฺษกา: ปลายมานา นครํ คฺรามญฺจ คตฺวา ตตฺสรฺวฺววฺฤตฺตานฺตํ กถยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ตต: กึ วฺฤตฺตมฺ เอตทฺทรฺศนารฺถํ โลกา นิรฺคตฺย ยีโศ: สมีปํ ยยุ:, ตํ มานุษํ ตฺยกฺตภูตํ ปริหิตวสฺตฺรํ สฺวสฺถมานุษวทฺ ยีโศศฺจรณสนฺนิเธา สูปวิศนฺตํ วิโลกฺย พิภฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","เย โลกาสฺตสฺย ภูตคฺรสฺตสฺย สฺวาสฺถฺยกรณํ ททฺฤศุเสฺต เตภฺย: สรฺวฺววฺฤตฺตานฺตํ กถยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ตทนนฺตรํ ตสฺย คิเทรียปฺรเทศสฺย จตุรฺทิกฺสฺถา พหโว ชนา อติตฺรสฺตา วินเยน ตํ ชคทุ:, ภวานฺ อสฺมากํ นิกฏาทฺ วฺรชตุ ตสฺมาตฺ ส นาวมารุหฺย ตโต วฺยาฆุฏฺย ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ตทานีํ ตฺยกฺตภูตมนุชเสฺตน สห สฺถาตุํ ปฺรารฺถยาญฺจเกฺร ");
INSERT INTO santha_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","กินฺตุ ตทรฺถมฺ อีศฺวร: กีทฺฤงฺมหากรฺมฺม กฺฤตวานฺ อิติ นิเวศนํ คตฺวา วิชฺญาปย, ยีศุ: กถาเมตำ กถยิตฺวา ตํ วิสสรฺชฯ ตต: ส วฺรชิตฺวา ยีศุสฺตทรฺถํ ยนฺมหากรฺมฺม จการ ตตฺ ปุรสฺย สรฺวฺวตฺร ปฺรกาศยิตุํ ปฺราเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","อถ ยีเศา ปราวฺฤตฺยาคเต โลกาสฺตํ อาทเรณ ชคฺฤหุ รฺยสฺมาตฺเต สรฺเวฺว ตมเปกฺษาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ตทนนฺตรํ ยายีรฺนามฺโน ภชนเคหไสฺยโกธิป อาคตฺย ยีโศศฺจรณโย: ปติตฺวา สฺวนิเวศนาคมนารฺถํ ตสฺมินฺ วินยํ จการ, ");
INSERT INTO santha_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ยตสฺตสฺย ทฺวาทศวรฺษวยสฺกา กไนฺยกาสีตฺ สา มฺฤตกลฺปาภวตฺฯ ตตสฺตสฺย คมนกาเล มารฺเค โลกานำ มหานฺ สมาคโม พภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ทฺวาทศวรฺษาณิ ปฺรทรโรคคฺรสฺตา นานา ไวไทฺยศฺจิกิตฺสิตา สรฺวฺวสฺวํ วฺยยิตฺวาปิ สฺวาสฺถฺยํ น ปฺราปฺตา ยา โยษิตฺ สา ยีโศ: ปศฺจาทาคตฺย ตสฺย วสฺตฺรคฺรนฺถึ ปสฺปรฺศฯ ");
INSERT INTO santha_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ตสฺมาตฺ ตตฺกฺษณาตฺ ตสฺยา รกฺตสฺราโว รุทฺธ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ตทานีํ ยีศุรวทตฺ เกนาหํ สฺปฺฤษฺฏ:? ตโต'เนไกรนงฺคีกฺฤเต ปิตรสฺตสฺย สงฺคินศฺจาวทนฺ, เห คุโร โลกา นิกฏสฺถา: สนฺตสฺตว เทเห ฆรฺษยนฺติ, ตถาปิ เกนาหํ สฺปฺฤษฺฏอิติ ภวานฺ กุต: ปฺฤจฺฉติ? ");
INSERT INTO santha_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ยีศุ: กถยามาส, เกนาปฺยหํ สฺปฺฤษฺโฏ, ยโต มตฺต: ศกฺติ รฺนิรฺคเตติ มยา นิศฺจิตมชฺญายิฯ ");
INSERT INTO santha_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ตทา สา นารี สฺวยํ น คุปฺเตติ วิทิตฺวา กมฺปมานา สตี ตสฺย สมฺมุเข ปปาต; เยน นิมิตฺเตน ตํ ปสฺปรฺศ สฺปรฺศมาตฺราจฺจ เยน ปฺรกาเรณ สฺวสฺถาภวตฺ ตตฺ สรฺวฺวํ ตสฺย สากฺษาทาจเขฺยาฯ ");
INSERT INTO santha_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ตต: ส ตำ ชคาท เห กเนฺย สุสฺถิรา ภว, ตว วิศฺวาสสฺตฺวำ สฺวสฺถามฺ อการฺษีตฺ ตฺวํ เกฺษเมณ ยาหิฯ ");
INSERT INTO santha_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ยีโศเรตทฺวากฺยวทนกาเล ตสฺยาธิปเต รฺนิเวศนาตฺ กศฺจิโลฺลก อาคตฺย ตํ พภาเษ, ตว กนฺยา มฺฤตา คุรุํ มา กฺลิศานฯ ");
INSERT INTO santha_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","กินฺตุ ยีศุสฺตทากรฺณฺยาธิปตึ วฺยาชหาร, มา ไภษี: เกวลํ วิศฺวสิหิ ตสฺมาตฺ สา ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","อถ ตสฺย นิเวศเน ปฺราปฺเต ส ปิตรํ โยหนํ ยากูพญฺจ กนฺยายา มาตรํ ปิตรญฺจ วินา, อนฺยํ กญฺจน ปฺรเวษฺฏุํ วารยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","อปรญฺจ เย รุทนฺติ วิลปนฺติ จ ตานฺ สรฺวฺวานฺ ชนานฺ อุวาจ, ยูยํ มา โรทิษฺฏ กนฺยา น มฺฤตา นิทฺราติฯ ");
INSERT INTO santha_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","กินฺตุ สา นิศฺจิตํ มฺฤเตติ ชฺญาตฺวา เต ตมุปชหสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ปศฺจาตฺ ส สรฺวฺวานฺ พหิ: กฺฤตฺวา กนฺยายา: กเรา ธฺฤตฺวาชุหุเว, เห กเนฺย ตฺวมุตฺติษฺฐ, ");
INSERT INTO santha_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ตสฺมาตฺ ตสฺยา: ปฺราเณษุ ปุนราคเตษุ สา ตตฺกฺษณาทฺ อุตฺตเสฺยาฯ ตทานีํ ตไสฺย กิญฺจิทฺ ภกฺษฺยํ ทาตุมฺ อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ตตสฺตสฺยา: ปิตเรา วิสฺมยํ คเตา กินฺตุ ส ตาวาทิเทศ ฆฏนายา เอตสฺยา: กถำ กไสฺมจิทปิ มา กถยตํฯ ");
INSERT INTO santha_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ตต: ปรํ ส ทฺวาทศศิษฺยานาหูย ภูตานฺ ตฺยาชยิตุํ โรคานฺ ปฺรติกรฺตฺตุญฺจ เตภฺย: ศกฺติมาธิปตฺยญฺจ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","อปรญฺจ อีศฺวรียราชฺยสฺย สุสํวาทํ ปฺรกาศยิตุมฺ โรคิณามาโรคฺยํ กรฺตฺตุญฺจ เปฺรรณกาเล ตานฺ ชคาทฯ ");
INSERT INTO santha_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ยาตฺรารฺถํ ยษฺฏิ รฺวสฺตฺรปุฏกํ ภกฺษฺยํ มุทฺรา ทฺวิตียวสฺตฺรมฺ, เอษำ กิมปิ มา คฺฤหฺลีตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ยูยญฺจ ยนฺนิเวศนํ ปฺรวิศถ นครตฺยาคปรฺยฺยนตํ ตนฺนิเวศเน ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ตตฺร ยทิ กสฺยจิตฺ ปุรสฺย โลกา ยุษฺมากมาติถฺยํ น กุรฺวฺวนฺติ ตรฺหิ ตสฺมานฺนคราทฺ คมนกาเล เตษำ วิรุทฺธํ สากฺษฺยารฺถํ ยุษฺมากํ ปทธูลี: สมฺปาตยตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","อถ เต ปฺรสฺถาย สรฺวฺวตฺร สุสํวาทํ ปฺรจารยิตุํ ปีฑิตานฺ สฺวสฺถานฺ กรฺตฺตุญฺจ คฺราเมษุ ภฺรมิตุํ ปฺราเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","เอตรฺหิ เหโรทฺ ราชา ยีโศ: สรฺวฺวกรฺมฺมณำ วารฺตฺตำ ศฺรุตฺวา ภฺฤศมุทฺวิวิเช ");
INSERT INTO santha_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ยต: เกจิทูจุโรฺยหนฺ ศฺมศานาทุทติษฺฐตฺฯ เกจิทูจุ:, เอลิโย ทรฺศนํ ทตฺตวานฺ; เอวมนฺยโลกา อูจุ: ปูรฺวฺวีย: กศฺจิทฺ ภวิษฺยทฺวาที สมุตฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","กินฺตุ เหโรทุวาจ โยหน: ศิโร'หมฉินทมฺ อิทานีํ ยเสฺยทฺฤกฺกรฺมฺมณำ วารฺตฺตำ ปฺราปฺโนมิ ส ก:? อถ ส ตํ ทฺรษฺฏุมฺ ไอจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","อนนฺตรํ เปฺรริตา: ปฺรตฺยาคตฺย ยานิ ยานิ กรฺมฺมาณิ จกฺรุสฺตานิ ยีศเว กถยามาสุ: ตต: ส ตานฺ ไพตฺไสทานามกนครสฺย วิชนํ สฺถานํ นีตฺวา คุปฺตํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ปศฺจาลฺ โลกาสฺตทฺ วิทิตฺวา ตสฺย ปศฺจาทฺ ยยุ:; ตต: ส ตานฺ นยนฺ อีศฺวรียราชฺยสฺย ปฺรสงฺคมุกฺตวานฺ, เยษำ จิกิตฺสยา ปฺรโยชนมฺ อาสีตฺ ตานฺ สฺวสฺถานฺ จการ จฯ ");
INSERT INTO santha_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","อปรญฺจ ทิวาวสนฺเน สติ ทฺวาทศศิษฺยา ยีโศรนฺติกมฺ เอตฺย กถยามาสุ:, วยมตฺร ปฺรานฺตรสฺถาเน ติษฺฐาม:, ตโต นคราณิ คฺรามาณิ คตฺวา วาสสฺถานานิ ปฺราปฺย ภกฺษฺยทฺรวฺยาณิ เกฺรตุํ ชนนิวหํ ภวานฺ วิสฺฤชตุฯ ");
INSERT INTO santha_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ตทา ส อุวาจ, ยูยเมว ตานฺ เภชยธฺวํ; ตตเสฺต โปฺรจุรสฺมากํ นิกเฏ เกวลํ ปญฺจ ปูปา เทฺวา มตฺเสฺยา จ วิทฺยนฺเต, อเตอว สฺถานานฺตรมฺ อิตฺวา นิมิตฺตเมเตษำ ภกฺษฺยทฺรเวฺยษุ น กฺรีเตษุ น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ตตฺร ปฺราเยณ ปญฺจสหสฺราณิ ปุรุษา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ตทา ส ศิษฺยานฺ ชคาท ปญฺจาศตฺ ปญฺจาศชฺชไน: ปํกฺตีกฺฤตฺย ตานุปเวศยต, ตสฺมาตฺ เต ตทนุสาเรณ สรฺวฺวโลกานุปเวศยาปาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ตต: ส ตานฺ ปญฺจ ปูปานฺ มีนทฺวยญฺจ คฺฤหีตฺวา สฺวรฺคํ วิโลเกฺยศฺวรคุณานฺ กีรฺตฺตยาญฺจเกฺร ภงฺกฺตา จ โลเกภฺย: ปริเวษณารฺถํ ศิเษฺยษุ สมรฺปยามฺพภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ตต: สรฺเวฺว ภุกฺตฺวา ตฺฤปฺตึ คตา อวศิษฺฏานาญฺจ ทฺวาทศ ฑลฺลกานฺ สํชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","อไถกทา นิรฺชเน ศิไษฺย: สห ปฺรารฺถนากาเล ตานฺ ปปฺรจฺฉ, โลกา มำ กํ วทนฺติ? ");
INSERT INTO santha_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ตตเสฺต ปฺราจุ:, ตฺวำ โยหนฺมชฺชกํ วทนฺติ; เกจิตฺ ตฺวามฺ เอลิยํ วทนฺติ, ปูรฺวฺวกาลิก: กศฺจิทฺ ภวิษฺยทฺวาที ศฺมศานาทฺ อุทติษฺฐทฺ อิตฺยปิ เกจิทฺ วทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ตทา ส อุวาจ, ยูยํ มำ กํ วทถ? ตต: ปิตร อุกฺตวานฺ ตฺวมฺ อีศฺวราภิษิกฺต: ปุรุษ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ตทา ส ตานฺ ทฺฤฒมาทิเทศ, กถาเมตำ กไสฺมจิทปิ มา กถยตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ส ปุนรุวาจ, มนุษฺยปุเตฺรณ วหุยาตนา โภกฺตวฺยา: ปฺราจีนโลไก: ปฺรธานยาชไกรธฺยาปไกศฺจ โสวชฺญาย หนฺตวฺย: กินฺตุ ตฺฤตียทิวเส ศฺมศานาตฺ เตโนตฺถาตวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","อปรํ ส สรฺวฺวานุวาจ, กศฺจิทฺ ยทิ มม ปศฺจาทฺ คนฺตุํ วาญฺฉติ ตรฺหิ ส สฺวํ ทามฺยตุ, ทิเน ทิเน กฺรุศํ คฺฤหีตฺวา จ มม ปศฺจาทาคจฺฉตุฯ ");
INSERT INTO santha_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ยโต ย: กศฺจิตฺ สฺวปฺราณานฺ ริรกฺษิษติ ส ตานฺ หารยิษฺยติ, ย: กศฺจินฺ มทรฺถํ ปฺราณานฺ หารยิษฺยติ ส ตานฺ รกฺษิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","กศฺจิทฺ ยทิ สรฺวฺวํ ชคตฺ ปฺราปฺโนติ กินฺตุ สฺวปฺราณานฺ หารยติ สฺวยํ วินศฺยติ จ ตรฺหิ ตสฺย โก ลาภ:? ");
INSERT INTO santha_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ปุน รฺย: กศฺจินฺ มำ มม วากฺยํ วา ลชฺชาสฺปทํ ชานาติ มนุษฺยปุโตฺร ยทา สฺวสฺย ปิตุศฺจ ปวิตฺราณำ ทูตานาญฺจ เตโชภิ: ปริเวษฺฏิต อาคมิษฺยติ ตทา โสปิ ตํ ลชฺชาสฺปทํ ชฺญาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","กินฺตุ ยุษฺมานหํ ยถารฺถํ วทามิ, อีศฺวรียราชตฺวํ น ทฺฤษฺฏวา มฺฤตฺยุํ นาสฺวาทิษฺยนฺเต, เอตาทฺฤศา: กิยนฺโต โลกา อตฺร สฺถเน'ปิ ทณฺฑายมานา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","เอตทาขฺยานกถนาตฺ ปรํ ปฺราเยณาษฺฏสุ ทิเนษุ คเตษุ ส ปิตรํ โยหนํ ยากูพญฺจ คฺฤหีตฺวา ปฺรารฺถยิตุํ ปรฺวฺวตเมกํ สมารุโรหฯ ");
INSERT INTO santha_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","อถ ตสฺย ปฺรารฺถนกาเล ตสฺย มุขากฺฤติรนฺยรูปา ชาตา, ตทียํ วสฺตฺรมุชฺชฺวลศุกฺลํ ชาตํฯ ");
INSERT INTO santha_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","อปรญฺจ มูสา เอลิยศฺโจเภา เตชสฺวิเนา ทฺฤษฺเฏา ");
INSERT INTO santha_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","เตา เตน ยิรูศาลมฺปุเร โย มฺฤตฺยุ: สาธิษฺยเต ตทียำ กถำ เตน สารฺทฺธํ กถยิตุมฺ อาเรภาเตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ตทา ปิตราทย: สฺวสฺย สงฺคิโน นิทฺรยากฺฤษฺฏา อาสนฺ กินฺตุ ชาคริตฺวา ตสฺย เตชเสฺตน สารฺทฺธมฺ อุตฺติษฺฐนฺเตา ชเนา จ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","อถ ตโยรุภโย รฺคมนกาเล ปิตโร ยีศุํ พภาเษ, เห คุโร'สฺมากํ สฺถาเน'สฺมินฺ สฺถิติ: ศุภา, ตต เอกา ตฺวทรฺถา, เอกา มูสารฺถา, เอกา เอลิยารฺถา, อิติ ติสฺร: กุโฏฺยสฺมาภิ รฺนิรฺมฺมียนฺตำ, อิมำ กถำ ส น วิวิจฺย กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","อปรญฺจ ตทฺวากฺยวทนกาเล ปโยท เอก อาคตฺย เตษามุปริ ฉายำ จการ, ตตสฺตนฺมเธฺย ตโย: ปฺรเวศาตฺ เต ศศงฺกิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ตทา ตสฺมาตฺ ปโยทาทฺ อิยมากาศียา วาณี นิรฺชคาม, มมายํ ปฺริย: ปุตฺร เอตสฺย กถายำ มโน นิธตฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","อิติ ศพฺเท ชาเต เต ยีศุเมกากินํ ททฺฤศุ: กินฺตุ เต ตทานีํ ตสฺย ทรฺศนสฺย วาจเมกามปิ โนกฺตฺวา มน:สุ สฺถาปยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ปเร'หนิ เตษุ ตสฺมาจฺไฉลาทฺ อวรูเฒษุ ตํ สากฺษาตฺ กรฺตฺตุํ พหโว โลกา อาชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","เตษำ มธฺยาทฺ เอโก ชน อุจฺไจรุวาจ, เห คุโร อหํ วินยํ กโรมิ มม ปุตฺรํ ปฺรติ กฺฤปาทฺฤษฺฏึ กโรตุ, มม ส เอไวก: ปุตฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ภูเตน ธฺฤต: สนฺ สํ ปฺรสภํ จีจฺฉพฺทํ กโรติ ตนฺมุขาตฺ เผณา นิรฺคจฺฉนฺติ จ, ภูต อิตฺถํ วิทารฺยฺย กฺลิษฺฏฺวา ปฺรายศสฺตํ น ตฺยชติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ตสฺมาตฺ ตํ ภูตํ ตฺยาชยิตุํ ตว ศิษฺยสมีเป นฺยเวทยํ กินฺตุ เต น เศกุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ตทา ยีศุรวาทีตฺ, เร อาวิศฺวาสินฺ วิปถคามินฺ วํศ กติกาลานฺ ยุษฺมาภิ: สห สฺถาสฺยามฺยหํ ยุษฺมากมฺ อาจรณานิ จ สหิเษฺย? ตว ปุตฺรมิหานยฯ ");
INSERT INTO santha_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ตตสฺตสฺมินฺนาคตมาเตฺร ภูตสฺตํ ภูเมา ปาตยิตฺวา วิททาร; ตทา ยีศุสฺตมเมธฺยํ ภูตํ ตรฺชยิตฺวา พาลกํ สฺวสฺถํ กฺฤตฺวา ตสฺย ปิตริ สมรฺปยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","อีศฺวรสฺย มหาศกฺติมฺ อิมำ วิโลกฺย สรฺเวฺว จมจฺจกฺรุ:; อิตฺถํ ยีโศ: สรฺวฺวาภิ: กฺริยาภิ: สรฺไวฺวโรฺลไกราศฺจรฺเยฺย มนฺยมาเน สติ ส ศิษฺยานฺ พภาเษ, ");
INSERT INTO santha_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","กเถยํ ยุษฺมากํ กรฺเณษุ ปฺรวิศตุ, มนุษฺยปุโตฺร มนุษฺยาณำ กเรษุ สมรฺปยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","กินฺตุ เต ตำ กถำ น พุพุธิเร, สฺปษฺฏตฺวาภาวาตฺ ตสฺยา อภิปฺรายเสฺตษำ โพธคโมฺย น พภูว; ตสฺยา อาศย: ก อิตฺยปิ เต ภยาตฺ ปฺรษฺฏุํ น เศกุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ตทนนฺตรํ เตษำ มเธฺย ก: เศฺรษฺฐ: กถาเมตำ คฺฤหีตฺวา เต มิโถ วิวาทํ จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ตโต ยีศุเสฺตษำ มโนภิปฺรายํ วิทิตฺวา พาลกเมกํ คฺฤหีตฺวา สฺวสฺย นิกเฏ สฺถาปยิตฺวา ตานฺ ชคาท, ");
INSERT INTO santha_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","โย ชโน มม นามฺนาสฺย พาลาสฺยาติถฺยํ วิทธาติ ส มมาติถฺยํ วิทธาติ, ยศฺจ มมาติถฺยํ วิทธาติ ส มม เปฺรรกสฺยาติถฺยํ วิทธาติ, ยุษฺมากํ มเธฺยย: สฺวํ สรฺวฺวสฺมาตฺ กฺษุทฺรํ ชานีเต ส เอว เศฺรษฺโฐ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","อปรญฺจ โยหนฺ วฺยาชหาร เห ปฺรเภा ตว นามฺนา ภูตานฺ ตฺยาชยนฺตํ มานุษมฺ เอกํ ทฺฤษฺฏวนฺโต วยํ, กินฺตฺวสฺมากมฺ อปศฺจาทฺ คามิตฺวาตฺ ตํ นฺยเษธามฺฯ ตทานีํ ยีศุรุวาจ, ");
INSERT INTO santha_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ตํ มา นิเษธต, ยโต โย ชโนสฺมากํ น วิปกฺษ: ส เอวาสฺมากํ สปกฺโษ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","อนนฺตรํ ตสฺยาโรหณสมย อุปสฺถิเต ส สฺถิรเจตา ยิรูศาลมํ ปฺรติ ยาตฺรำ กรฺตฺตุํ นิศฺจิตฺยาเคฺร ทูตานฺ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ตสฺมาตฺ เต คตฺวา ตสฺย ปฺรโยชนียทฺรวฺยาณิ สํคฺรหีตุํ โศมิโรณียานำ คฺรามํ ปฺรวิวิศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","กินฺตุ ส ยิรูศาลมํ นครํ ยาติ ตโต เหโต โรฺลกาสฺตสฺยาติถฺยํ น จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","อเตอว ยากูโพฺยหเนา ตสฺย ศิเษฺยา ตทฺ ทฺฤษฺฏฺวา ชคทตุ:, เห ปฺรโภ เอลิโย ยถา จการ ตถา วยมปิ กึ คคณาทฺ อาคนฺตุมฺ เอตานฺ ภสฺมีกรฺตฺตุญฺจ วหฺนิมาชฺญาปยาม:? ภวานฺ กิมิจฺฉติ? ");
INSERT INTO santha_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","กินฺตุ ส มุขํ ปราวรฺตฺย ตานฺ ตรฺชยิตฺวา คทิตวานฺ ยุษฺมากํ มโนภาว: ก:, อิติ ยูยํ น ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","มนุชสุโต มนุชานำ ปฺราณานฺ นาศยิตุํ นาคจฺฉตฺ, กินฺตุ รกฺษิตุมฺ อาคจฺฉตฺฯ ปศฺจาทฺ อิตรคฺรามํ เต ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ตทนนฺตรํ ปถิ คมนกาเล ชน เอกสฺตํ พภาเษ, เห ปฺรโภ ภวานฺ ยตฺร ยาติ ภวตา สหาหมปิ ตตฺร ยาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ตทานีํ ยีศุสฺตมุวาจ, โคมายูนำ ครฺตฺตา อาสเต, วิหายสียวิหคาाนำ นีฑานิ จ สนฺติ, กินฺตุ มานวตนยสฺย ศิร: สฺถาปยิตุํ สฺถานํ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ตต: ปรํ ส อิตรชนํ ชคาท, ตฺวํ มม ปศฺจาทฺ เอหิ; ตต: ส อุวาจ, เห ปฺรโภ ปูรฺวฺวํ ปิตรํ ศฺมศาเน สฺถาปยิตุํ มามาทิศตุฯ ");
INSERT INTO santha_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ตทา ยีศุรุวาจ, มฺฤตา มฺฤตานฺ ศฺมศาเน สฺถาปยนฺตุ กินฺตุ ตฺวํ คเตฺวศฺวรียราชฺยสฺย กถำ ปฺรจารยฯ ");
INSERT INTO santha_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ตโตนฺย: กถยามาส, เห ปฺรโภ มยาปิ ภวต: ปศฺจาทฺ คํสฺยเต, กินฺตุ ปูรฺวฺวํ มม นิเวศนสฺย ปริชนานามฺ อนุมตึ คฺรหีตุมฺ อหมาทิไศฺย ภวตาฯ ");
INSERT INTO santha_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ตทานีํ ยีศุสฺตํ โปฺรกฺตวานฺ, โย ชโน ลางฺคเล กรมรฺปยิตฺวา ปศฺจาตฺ ปศฺยติ ส อีศฺวรียราชฺยํ นารฺหติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ตต: ปรํ ปฺรภุรปรานฺ สปฺตติศิษฺยานฺ นิยุชฺย สฺวยํ ยานิ นคราณิ ยานิ สฺถานานิ จ คมิษฺยติ ตานิ นคราณิ ตานิ สฺถานานิ จ ปฺรติ เทฺวา เทฺวา ชเนา ปฺรหิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","เตภฺย: กถยามาส จ ศสฺยานิ พหูนีติ สตฺยํ กินฺตุ เฉทกา อลฺเป; ตสฺมาทฺเธโต: ศสฺยกฺเษเตฺร เฉทกานฺ อปรานปิ เปฺรษยิตุํ เกฺษตฺรสฺวามินํ ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ยูยํ ยาต, ปศฺยต, วฺฤกาณำ มเธฺย เมษศาวกานิว ยุษฺมานฺ ปฺรหิโณมิฯ ");
INSERT INTO santha_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ยูยํ กฺษุทฺรํ มหทฺ วา วสนสมฺปุฏกํ ปาทุกาศฺจ มา คฺฤหฺลีต, มารฺคมเธฺย กมปิ มา นมต จฯ ");
INSERT INTO santha_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","อปรญฺจ ยูยํ ยทฺ ยตฺ นิเวศนํ ปฺรวิศถ ตตฺร นิเวศนสฺยาสฺย มงฺคลํ ภูยาทิติ วากฺยํ ปฺรถมํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ตสฺมาตฺ ตสฺมินฺ นิเวศเน ยทิ มงฺคลปาตฺรํ สฺถาสฺยติ ตรฺหิ ตนฺมงฺคลํ ตสฺย ภวิษฺยติ, โนเจตฺ ยุษฺมานฺ ปฺรติ ปราวรฺตฺติษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","อปรญฺจ เต ยตฺกิญฺจิทฺ ทาสฺยนฺติ ตเทว ภุกฺตฺวา ปีตฺวา ตสฺมินฺนิเวศเน สฺถาสฺยถ; ยต: กรฺมฺมการี ชโน ภฺฤติมฺ อรฺหติ; คฺฤหาทฺ คฺฤหํ มา ยาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","อนฺยจฺจ ยุษฺมาสุ กิมปิ นครํ ปฺรวิษฺเฏษุ โลกา ยทิ ยุษฺมากมฺ อาติถฺยํ กริษฺยนฺติ, ตรฺหิ ยตฺ ขาทฺยมฺ อุปสฺถาสฺยนฺติ ตเทว ขาทิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ตนฺนครสฺถานฺ โรคิณ: สฺวสฺถานฺ กริษฺยถ, อีศฺวรียํ ราชฺยํ ยุษฺมากมฺ อนฺติกมฺ อาคมตฺ กถาเมตาญฺจ ปฺรจารยิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","กินฺตุ กิมปิ ปุรํ ยุษฺมาสุ ปฺรวิษฺเฏษุ โลกา ยทิ ยุษฺมากมฺ อาติถฺยํ น กริษฺยนฺติ, ตรฺหิ ตสฺย นครสฺย ปนฺถานํ คตฺวา กถาเมตำ วทิษฺยถ, ");
INSERT INTO santha_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ยุษฺมากํ นครียา ยา ธูโลฺย'สฺมาสุ สมลคนฺ ตา อปิ ยุษฺมากํ ปฺราติกูเลฺยน สากฺษฺยารฺถํ สมฺปาตยาม:; ตถาปีศฺวรราชฺยํ ยุษฺมากํ สมีปมฺ อาคตมฺ อิติ นิศฺจิตํ ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","อหํ ยุษฺมภฺยํ ยถารฺถํ กถยามิ, วิจารทิเน ตสฺย นครสฺย ทศาต: สิโทโม ทศา สหฺยา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","หา หา โกราสีนฺ นคร, หา หา ไพตฺไสทานคร ยุวโยรฺมเธฺย ยาทฺฤศานิ อาศฺจรฺยฺยาณิ กรฺมฺมาณฺยกฺริยนฺต, ตานิ กรฺมฺมาณิ ยทิ โสรสีโทโน รฺนครโยรการิษฺยนฺต, ตทา อิโต พหุทินปูรฺวฺวํ ตนฺนิวาสิน: ศณวสฺตฺราณิ ปริธาย คาเตฺรษุ ภสฺม วิลิปฺย สมุปวิศฺย สมเขตฺสฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","อโต วิจารทิวเส ยุษฺมากํ ทศาต: โสรสีโทนฺนิวาสินำ ทศา สหฺยา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","เห กผรฺนาหูมฺ, ตฺวํ สฺวรฺคํ ยาวทฺ อุนฺนตา กินฺตุ นรกํ ยาวตฺ นฺยคฺภวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","โย ชโน ยุษฺมากํ วากฺยํ คฺฤหฺลาติ ส มไมว วากฺยํ คฺฤหฺลาติ; กิญฺจ โย ชโน ยุษฺมากมฺ อวชฺญำ กโรติ ส มไมวาวชฺญำ กโรติ; โย ชโน มมาวชฺญำ กโรติ จ ส มตฺเปฺรรกไสฺยวาวชฺญำ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","อถ เต สปฺตติศิษฺยา อานนฺเทน ปฺรตฺยาคตฺย กถยามาสุ:, เห ปฺรโภ ภวโต นามฺนา ภูตา อปฺยสฺมากํ วศีภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ตทานีํ ส ตานฺ ชคาท, วิทฺยุตมิว สฺวรฺคาตฺ ปตนฺตํ ไศตานมฺ อทรฺศมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ปศฺยต สรฺปานฺ วฺฤศฺจิกานฺ ริโป: สรฺวฺวปรากฺรมำศฺจ ปทตไล รฺทลยิตุํ ยุษฺมภฺยํ ศกฺตึ ททามิ ตสฺมาทฺ ยุษฺมากํ กาปิ หานิ รฺน ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ภูตา ยุษฺมากํ วศีภวนฺติ, เอตนฺนิมิตฺตตฺ มา สมุลฺลสต, สฺวรฺเค ยุษฺมากํ นามานิ ลิขิตานิ สนฺตีติ นิมิตฺตํ สมุลฺลสตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ตทฺฆฏิกายำ ยีศุ รฺมนสิ ชาตาหฺลาท: กถยามาส เห สฺวรฺคปฺฤถิโวฺยเรกาธิปเต ปิตสฺตฺวํ ชฺญานวตำ วิทุษาญฺจ โลกานำ ปุรสฺตาตฺ สรฺวฺวเมตทฺ อปฺรกาศฺย พาลกานำ ปุรสฺตาตฺ ปฺรากาศย เอตสฺมาทฺเธโตสฺตฺวำ ธนฺยํ วทามิ, เห ปิตริตฺถํ ภวตุ ยทฺ เอตเทว ตว โคจร อุตฺตมมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ปิตฺรา สรฺวฺวาณิ มยิ สมรฺปิตานิ ปิตรํ วินา โกปิ ปุตฺรํ น ชานาติ กิญฺจ ปุตฺรํ วินา ยไสฺม ชนาย ปุตฺรสฺตํ ปฺรกาศิตวานฺ ตญฺจ วินา โกปิ ปิตรํ น ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ตป: ปรํ ส ศิษฺยานฺ ปฺรติ ปราวฺฤตฺย คุปฺตํ ชคาท, ยูยเมตานิ สรฺวฺวาณิ ปศฺยถ ตโต ยุษฺมากํ จกฺษูํษิ ธนฺยานิฯ ");
INSERT INTO santha_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ยุษฺมานหํ วทามิ, ยูยํ ยานิ สรฺวฺวาณิ ปศฺยถ ตานิ พหโว ภวิษฺยทฺวาทิโน ภูปตยศฺจ ทฺรษฺฏุมิจฺฉนฺโตปิ ทฺรษฺฏุํ น ปฺราปฺนุวนฺ, ยุษฺมาภิ รฺยา ยา: กถาศฺจ ศฺรูยนฺเต ตา: โศฺรตุมิจฺฉนฺโตปิ โศฺรตุํ นาลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","อนนฺตรมฺ เอโก วฺยวสฺถาปก อุตฺถาย ตํ ปรีกฺษิตุํ ปปฺรจฺฉ, เห อุปเทศก อนนฺตายุษ: ปฺราปฺตเย มยา กึ กรณียํ? ");
INSERT INTO santha_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ยีศุ: ปฺรตฺยุวาจ, อตฺรารฺเถ วฺยวสฺถายำ กึ ลิขิตมสฺติ? ตฺวํ กีทฺฤกฺ ปฐสิ? ");
INSERT INTO santha_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ตต: โสวทตฺ, ตฺวํ สรฺวฺวานฺต:กรไณ: สรฺวฺวปฺราไณ: สรฺวฺวศกฺติภิ: สรฺวฺวจิตฺไตศฺจ ปฺรเภา ปรเมศฺวเร เปฺรม กุรุ, สมีปวาสินิ สฺววตฺ เปฺรม กุรุ จฯ ");
INSERT INTO santha_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ตทา ส กถยามาส, ตฺวํ ยถารฺถํ ปฺรตฺยโวจ:, อิตฺถมฺ อาจร เตไนว ชีวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","กินฺตุ ส ชน: สฺวํ นิรฺทฺโทษํ ชฺญาปยิตุํ ยีศุํ ปปฺรจฺฉ, มม สมีปวาสี ก:? ตโต ยีศุ: ปฺรตฺยุวาจ, ");
INSERT INTO santha_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","เอโก ชโน ยิรูศาลมฺปุราทฺ ยิรีโหปุรํ ยาติ, เอตรฺหิ ทสฺยูนำ กเรษุ ปติเต เต ตสฺย วสฺตฺราทิกํ หฺฤตวนฺต: ตมาหตฺย มฺฤตปฺรายํ กฺฤตฺวา ตฺยกฺตฺวา ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","อกสฺมาทฺ เอโก ยาชกเสฺตน มารฺเคณ คจฺฉนฺ ตํ ทฺฤษฺฏฺวา มารฺคานฺยปารฺเศฺวน ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","อิตฺถมฺ เอโก เลวียสฺตตฺสฺถานํ ปฺราปฺย ตสฺยานฺติกํ คตฺวา ตํ วิโลกฺยาเนฺยน ปารฺเศฺวน ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","กินฺเตฺวก: โศมิโรณีโย คจฺฉนฺ ตตฺสฺถานํ ปฺราปฺย ตํ ทฺฤษฺฏฺวาทยตฯ ");
INSERT INTO santha_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ตสฺยานฺติกํ คตฺวา ตสฺย กฺษเตษุ ไตลํ ทฺรากฺษารสญฺจ ปฺรกฺษิปฺย กฺษตานิ พทฺธฺวา นิชวาหโนปริ ตมุปเวศฺย ปฺรวาสียคฺฤหมฺ อานีย ตํ สิเษเวฯ ");
INSERT INTO santha_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ปรสฺมินฺ ทิวเส นิชคมนกาเล เทฺวา มุทฺราปาเทา ตทฺคฺฤหสฺวามิเน ทตฺตฺวาวทตฺ ชนเมนํ เสวสฺว ตตฺร โย'ธิโก วฺยโย ภวิษฺยติ ตมหํ ปุนราคมนกาเล ปริโศตฺสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","เอษำ ตฺรยาณำ มเธฺย ตสฺย ทสฺยุหสฺตปติตสฺย ชนสฺย สมีปวาสี ก:? ตฺวยา กึ พุธฺยเต? ");
INSERT INTO santha_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ตต: ส วฺยวสฺถาปก: กถยามาส ยสฺตสฺมินฺ ทยำ จการฯ ตทา ยีศุ: กถยามาส ตฺวมปิ คตฺวา ตถาจรฯ ");
INSERT INTO santha_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ตต: ปรํ เต คจฺฉนฺต เอกํ คฺรามํ ปฺรวิวิศุ:; ตทา มรฺถานามา สฺตฺรี สฺวคฺฤเห ตสฺยาติถฺยํ จการฯ ");
INSERT INTO santha_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ตสฺมาตฺ มริยมฺ นามเธยา ตสฺยา ภคินี ยีโศ: ปทสมีป อุววิศฺย ตโสฺยปเทศกถำ โศฺรตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","กินฺตุ มรฺถา นานาปริจรฺยฺยายำ วฺยคฺรา พภูว ตสฺมาทฺเธโตสฺตสฺย สมีปมาคตฺย พภาเษ; เห ปฺรโภ มม ภคินี เกวลํ มโมปริ สรฺวฺวกรฺมฺมณำ ภารมฺ อรฺปิตวตี ตตฺร ภวตา กิญฺจิทปิ น มโน นิธียเต กิมฺ? มม สาหายฺยํ กรฺตฺตุํ ภวานฺ ตามาทิศตุฯ ");
INSERT INTO santha_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ตโต ยีศุ: ปฺรตฺยุวาจ เห มรฺเถ เห มรฺเถ, ตฺวํ นานาการฺเยฺยษุ จินฺติตวตี วฺยคฺรา จาสิ, ");
INSERT INTO santha_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","กินฺตุ ปฺรโยชนียมฺ เอกมาตฺรมฺ อาเสฺตฯ อปรญฺจ ยมุตฺตมํ ภาคํ โกปิ หรฺตฺตุํ น ศกฺโนติ เสอว มริยมา วฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","อนนฺตรํ ส กสฺมึศฺจิตฺ สฺถาเน ปฺรารฺถยต ตตฺสมาปฺเตา สตฺยำ ตไสฺยก: ศิษฺยสฺตํ ชคาท เห ปฺรโภ โยหนฺ ยถา สฺวศิษฺยานฺ ปฺรารฺถยิตุมฺ อุปทิษฺฏวานฺ ตถา ภวานปฺยสฺมานฺ อุปทิศตุฯ ");
INSERT INTO santha_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ตสฺมาตฺ ส กถยามาส, ปฺรารฺถนกาเล ยูยมฺ อิตฺถํ กถยธฺวํ, เห อสฺมากํ สฺวรฺคสฺถปิตสฺตว นาม ปูชฺยํ ภวตุ; ตว ราชตฺวํ ภวตุ; สฺวรฺเค ยถา ตถา ปฺฤถิวฺยามปิ ตเวจฺฉยา สรฺวฺวํ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ปฺรตฺยหมฺ อสฺมากํ ปฺรโยชนียํ โภชฺยํ เทหิฯ ");
INSERT INTO santha_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ยถา วยํ สรฺวฺวานฺ อปราธิน: กฺษมามเห ตถา ตฺวมปิ ปาปานฺยสฺมากํ กฺษมสฺวฯ อสฺมานฺ ปรีกฺษำ มานย กินฺตุ ปาปาตฺมโน รกฺษฯ ");
INSERT INTO santha_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ปศฺจาตฺ โสปรมปิ กถิตวานฺ ยทิ ยุษฺมากํ กสฺยจิทฺ พนฺธุสฺติษฺฐติ นิศีเถ จ ตสฺย สมีปํ ส คตฺวา วทติ, ");
INSERT INTO santha_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","เห พนฺโธ ปถิก เอโก พนฺธุ รฺมม นิเวศนมฺ อายาต: กินฺตุ ตสฺยาติถฺยํ กรฺตฺตุํ มมานฺติเก กิมปิ นาสฺติ, อเตอว ปูปตฺรยํ มหฺยมฺ ฤณํ เทหิ; ");
INSERT INTO santha_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ตทา ส ยทิ คฺฤหมธฺยาตฺ ปฺรติวทติ มำ มา กฺลิศาน, อิทานีํ ทฺวารํ รุทฺธํ ศยเน มยา สห พาลกาศฺจ ติษฺฐนฺติ ตุภฺยํ ทาตุมฺ อุตฺถาตุํ น ศกฺโนมิ, ");
INSERT INTO santha_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ตรฺหิ ยุษฺมานหํ วทามิ, ส ยทิ มิตฺรตยา ตไสฺม กิมปิ ทาตุํ โนตฺติษฺฐติ ตถาปิ วารํ วารํ ปฺรารฺถนาต อุตฺถาปิต: สนฺ ยสฺมินฺ ตสฺย ปฺรโยชนํ ตเทว ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","อต: การณาตฺ กถยามิ, ยาจธฺวํ ตโต ยุษฺมภฺยํ ทาสฺยเต, มฺฤคยธฺวํ ตต อุทฺเทศํ ปฺราปฺสฺยถ, ทฺวารมฺ อาหต ตโต ยุษฺมภฺยํ ทฺวารํ โมกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","โย ยาจเต ส ปฺราปฺโนติ, โย มฺฤคยเต ส เอโวทฺเทศํ ปฺราปฺโนติ, โย ทฺวารมฺ อาหนฺติ ตทรฺถํ ทฺวารํ โมจฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ปุเตฺรณ ปูเป ยาจิเต ตไสฺม ปาษาณํ ททาติ วา มตฺเสฺย ยาจิเต ตไสฺม สรฺปํ ททาติ ");
INSERT INTO santha_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","วา อณฺเฑ ยาจิเต ตไสฺม วฺฤศฺจิกํ ททาติ ยุษฺมากํ มเธฺย ก เอตาทฺฤศ: ปิตาเสฺต? ");
INSERT INTO santha_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ตสฺมาเทว ยูยมภทฺรา อปิ ยทิ สฺวสฺวพาลเกภฺย อุตฺตมานิ ทฺรวฺยาณิ ทาตุํ ชานีถ ตรฺหฺยสฺมากํ สฺวรฺคสฺถ: ปิตา นิชยาจเกภฺย: กึ ปวิตฺรมฺ อาตฺมานํ น ทาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","อนนฺตรํ ยีศุนา กสฺมาจฺจิทฺ เอกสฺมินฺ มูกภูเต ตฺยาชิเต สติ ส ภูตตฺยกฺโต มานุโษ วากฺยํ วกฺตุมฺ อาเรเภ; ตโต โลกา: สกลา อาศฺจรฺยฺยํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","กินฺตุ เตษำ เกจิทูจุ รฺชโนยํ พาลสิพูพา อรฺถาทฺ ภูตราเชน ภูตานฺ ตฺยาชยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ตํ ปรีกฺษิตุํ เกจิทฺ อากาศียมฺ เอกํ จิหฺนํ ทรฺศยิตุํ ตํ ปฺรารฺถยาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ตทา ส เตษำ มน:กลฺปนำ ชฺญาตฺวา กถยามาส, กสฺยจิทฺ ราชฺยสฺย โลกา ยทิ ปรสฺปรํ วิรุนฺธนฺติ ตรฺหิ ตทฺ ราชฺยมฺ นศฺยติ; เกจิทฺ คฺฤหสฺถา ยทิ ปรสฺปรํ วิรุนฺธนฺติ ตรฺหิ เตปิ นศฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ตไถว ไศตานปิ สฺวโลกานฺ ยทิ วิรุณทฺธิ ตทา ตสฺย ราชฺยํ กถํ สฺถาสฺยติ? พาลสิพูพาหํ ภูตานฺ ตฺยาชยามิ ยูยมิติ วทถฯ ");
INSERT INTO santha_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ยทฺยหํ พาลสิพูพา ภูตานฺ ตฺยาชยามิ ตรฺหิ ยุษฺมากํ สนฺตานา: เกน ตฺยาชยนฺติ? ตสฺมาตฺ เตอว กถายา เอตสฺยา วิจารยิตาโร ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","กินฺตุ ยทฺยหมฺ อีศฺวรสฺย ปรากฺรเมณ ภูตานฺ ตฺยาชยามิ ตรฺหิ ยุษฺมากํ นิกฏมฺ อีศฺวรสฺย ราชฺยมวศฺยมฺ อุปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","พลวานฺ ปุมานฺ สุสชฺชมาโน ยติกาลํ นิชาฏฺฏาลิกำ รกฺษติ ตติกาลํ ตสฺย ทฺรวฺยํ นิรุปทฺรวํ ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","กินฺตุ ตสฺมาทฺ อธิกพล: กศฺจิทาคตฺย ยทิ ตํ ชยติ ตรฺหิ เยษุ ศสฺตฺราสฺเตฺรษุ ตสฺย วิศฺวาส อาสีตฺ ตานิ สรฺวฺวาณิ หฺฤตฺวา ตสฺย ทฺรวฺยาณิ คฺฤหฺลาติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","อต: การณาทฺ โย มม สปกฺโษ น ส วิปกฺษ:, โย มยา สห น สํคฺฤหฺลาติ ส วิกิรติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","อปรญฺจ อเมธฺยภูโต มานุษสฺยานฺตรฺนิรฺคตฺย ศุษฺกสฺถาเน ภฺรานฺตฺวา วิศฺรามํ มฺฤคยเต กินฺตุ น ปฺราปฺย วทติ มม ยสฺมาทฺ คฺฤหาทฺ อาคโตหํ ปุนสฺตทฺ คฺฤหํ ปราวฺฤตฺย ยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ตโต คตฺวา ตทฺ คฺฤหํ มารฺชิตํ โศภิตญฺจ ทฺฤษฺฏฺวา ");
INSERT INTO santha_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ตตฺกฺษณมฺ อปคตฺย สฺวสฺมาทปิ ทุรฺมฺมตีนฺ อปรานฺ สปฺตภูตานฺ สหานยติ เต จ ตทฺคฺฤหํ ปวิศฺย นิวสนฺติฯ ตสฺมาตฺ ตสฺย มนุษฺยสฺย ปฺรถมทศาต: เศษทศา ทุ:ขตรา ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","อสฺยา: กถายา: กถนกาเล ชนตามธฺยสฺถา กาจินฺนารี ตมุจฺไจ:สฺวรํ โปฺรวาจ, ยา โยษิตฺ ตฺวำ ครฺพฺเภ'ธารยตฺ สฺตนฺยมปายยจฺจ ไสว ธนฺยาฯ ");
INSERT INTO santha_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","กินฺตุ โสกถยตฺ เย ปรเมศฺวรสฺย กถำ ศฺรุตฺวา ตทนุรูปมฺ อาจรนฺติ เตอว ธนฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ตต: ปรํ ตสฺยานฺติเก พหุโลกานำ สมาคเม ชาเต ส วกฺตุมาเรเภ, อาธุนิกา ทุษฺฏโลกาศฺจิหฺนํ ทฺรษฺฏุมิจฺฉนฺติ กินฺตุ ยูนสฺภวิษฺยทฺวาทินศฺจิหฺนํ วินานฺยตฺ กิญฺจิจฺจิหฺนํ ตานฺ น ทรฺศยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ยูนสฺ ตุ ยถา นีนิวียโลกานำ สมีเป จิหฺนรูโปภวตฺ ตถา วิทฺยมานโลกานามฺ เอษำ สมีเป มนุษฺยปุโตฺรปิ จิหฺนรูโป ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","วิจารสมเย อิทานีนฺตนโลกานำ ปฺราติกูเลฺยน ทกฺษิณเทศียา ราชฺญี โปฺรตฺถาย ตานฺ โทษิณ: กริษฺยติ, ยต: สา ราชฺญี สุเลมาน อุปเทศกถำ โศฺรตุํ ปฺฤถิวฺยา: สีมาต อาคจฺฉตฺ กินฺตุ ปศฺยต สุเลมาโนปิ คุรุตร เอโก ชโน'สฺมินฺ สฺถาเน วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","อปรญฺจ วิจารสมเย นีนิวียโลกา อปิ วรฺตฺตมานกาลิกานำ โลกานำ ไวปรีเตฺยน โปฺรตฺถาย ตานฺ โทษิณ: กริษฺยนฺติ, ยโต เหโตเสฺต ยูนโส วากฺยาตฺ จิตฺตานิ ปริวรฺตฺตยามาสุ: กินฺตุ ปศฺยต ยูนโสติคุรุตร เอโก ชโน'สฺมินฺ สฺถาเน วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ปฺรทีปํ ปฺรชฺวาลฺย โทฺรณสฺยาธ: กุตฺราปิ คุปฺตสฺถาเน วา โกปิ น สฺถาปยติ กินฺตุ คฺฤหปฺรเวศิโภฺย ทีปฺตึ ทาตํ ทีปาธาโรปรฺเยฺยว สฺถาปยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","เทหสฺย ปฺรทีปศฺจกฺษุสฺตสฺมาเทว จกฺษุ รฺยทิ ปฺรสนฺนํ ภวติ ตรฺหิ ตว สรฺวฺวศรีรํ ทีปฺติมทฺ ภวิษฺยติ กินฺตุ จกฺษุ รฺยทิ มลีมสํ ติษฺฐติ ตรฺหิ สรฺวฺวศรีรํ สานฺธการํ สฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","อสฺมาตฺ การณาตฺ ตวานฺต:สฺถํ โชฺยติ รฺยถานฺธการมยํ น ภวติ ตทรฺเถ สาวธาโน ภวฯ ");
INSERT INTO santha_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ยต: ศรีรสฺย กุตฺราปฺยํเศ สานฺธกาเร น ชาเต สรฺวฺวํ ยทิ ทีปฺติมตฺ ติษฺฐติ ตรฺหิ ตุภฺยํ ทีปฺติทายิโปฺรชฺชฺวลนฺ ปฺรทีป อิว ตว สวรฺวศรีรํ ทีปฺติมทฺ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","เอตตฺกถายา: กถนกาเล ผิรุเศฺยโก เภชนาย ตํ นิมนฺตฺรยามาส, ตต: ส คตฺวา โภกฺตุมฺ อุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","กินฺตุ โภชนาตฺ ปูรฺวฺวํ นามางฺกฺษีตฺ เอตทฺ ทฺฤษฺฏฺวา ส ผิรุศฺยาศฺจรฺยฺยํ เมเนฯ ");
INSERT INTO santha_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ตทา ปฺรภุสฺตํ โปฺรวาจ ยูยํ ผิรูศิโลกา: ปานปาตฺราณำ โภชนปาตฺราณาญฺจ พหิ: ปริษฺกุรุถ กินฺตุ ยุษฺมากมนฺต เรฺทาราตฺไมฺย รฺทุษฺกฺริยาภิศฺจ ปริปูรฺณํ ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","เห สรฺเวฺว นิรฺโพธา โย พหิ: สสรฺช ส เอว กิมนฺต รฺน สสรฺช? ");
INSERT INTO santha_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ตต เอว ยุษฺมาภิรนฺต:กรณํ (อีศฺวราย) นิเวทฺยตำ ตสฺมินฺ กฺฤเต ยุษฺมากํ สรฺวฺวาณิ ศุจิตำ ยาสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","กินฺตุ หนฺต ผิรูศิคณา ยูยํ นฺยายมฺ อีศฺวเร เปฺรม จ ปริตฺยชฺย โปทินายา อรุทาทีนำ สรฺเวฺวษำ ศากานาญฺจ ทศมำศานฺ ทตฺถ กินฺตุ ปฺรถมํ ปาลยิตฺวา เศษสฺยาลงฺฆนํ ยุษฺมากมฺ อุจิตมาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","หา หา ผิรูศิโน ยูยํ ภชนเคเห โปฺรจฺจาสเน อาปเณษุ จ นมสฺกาเรษุ ปฺรียเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","วต กปฏิโน'ธฺยาปกา: ผิรูศินศฺจ โลกายตฺ ศฺมศานมฺ อนุปลภฺย ตทุปริ คจฺฉนฺติ ยูยมฺ ตาทฺฤคปฺรกาศิตศฺมศานวาทฺ ภวถฯ ");
INSERT INTO santha_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ตทานีํ วฺยวสฺถาปกานามฺ เอกา ยีศุมวทตฺ, เห อุปเทศก วาเกฺยเนทฺฤเศนาสฺมาสฺวปิ โทษมฺ อาโรปยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ตต: ส อุวาจ, หา หา วฺยวสฺถาปกา ยูยมฺ มานุษาณามฺ อุปริ ทุ:สหฺยานฺ ภารานฺ นฺยสฺยถ กินฺตุ สฺวยมฺ เอกางฺคุुลฺยาปิ ตานฺ ภารานฺ น สฺปฺฤศถฯ ");
INSERT INTO santha_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","หนฺต ยุษฺมากํ ปูรฺวฺวปุรุษา ยานฺ ภวิษฺยทฺวาทิโน'วธิษุเสฺตษำ ศฺมศานานิ ยูยํ นิรฺมฺมาถฯ ");
INSERT INTO santha_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","เตไนว ยูยํ สฺวปูรฺวฺวปุรุษาณำ กรฺมฺมาณิ สํมนฺยเธฺว ตเทว สปฺรมาณํ กุรุถ จ, ยตเสฺต ตานวธิษุ: ยูยํ เตษำ ศฺมศานานิ นิรฺมฺมาถฯ ");
INSERT INTO santha_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","อเตอว อีศฺวรสฺย ศาสฺเตฺร โปฺรกฺตมสฺติ เตษามนฺติเก ภวิษฺยทฺวาทิน: เปฺรริตำศฺจ เปฺรษยิษฺยามิ ตตเสฺต เตษำ กำศฺจน หนิษฺยนฺติ กำศฺจน ตาฑศฺษฺยินฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","เอตสฺมาตฺ การณาตฺ หาพิล: โศณิตปาตมารภฺย มนฺทิรยชฺญเวโทฺย รฺมเธฺย หตสฺย สิขริยสฺย รกฺตปาตปรฺยฺยนฺตํ ");
INSERT INTO santha_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ชคต: สฺฤษฺฏิมารภฺย ปฺฤถิวฺยำ ภวิษฺยทฺวาทินำ ยติรกฺตปาตา ชาตาสฺตตีนามฺ อปราธทณฺฑา เอษำ วรฺตฺตมานโลกานำ ภวิษฺยนฺติ, ยุษฺมานหํ นิศฺจิตํ วทามิ สรฺเวฺว ทณฺฑา วํศสฺยาสฺย ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","หา หา วฺยวสฺถปกา ยูยํ ชฺญานสฺย กุญฺจิกำ หฺฤตฺวา สฺวยํ น ปฺรวิษฺฏา เย ปฺรเวษฺฏุญฺจ ปฺรยาสินสฺตานปิ ปฺรเวษฺฏุํ วาริตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","อิตฺถํ กถากถนาทฺ อธฺยาปกา: ผิรูศินศฺจ สตรฺกา: ");
INSERT INTO santha_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","สนฺตสฺตมปวทิตุํ ตสฺย กถายา โทษํ ธรฺตฺตมิจฺฉนฺโต นานาขฺยานกถนาย ตํ ปฺรวรฺตฺตยิตุํ โกปยิตุญฺจ ปฺราเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ตทานีํ โลกา: สหสฺรํ สหสฺรมฺ อาคตฺย สมุปสฺถิตาสฺตต เอไกโก 'เนฺยษามุปริ ปติตุมฺ อุปจกฺรเม; ตทา ยีศุ: ศิษฺยานฺ พภาเษ, ยูยํ ผิรูศินำ กิณฺวรูปกาปเฏฺย วิเศเษณ สาวธานาสฺติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ยโต ยนฺน ปฺรกาศยิษฺยเต ตทาจฺฉนฺนํ วสฺตุ กิมปิ นาสฺติ; ตถา ยนฺน ชฺญาสฺยเต ตทฺ คุปฺตํ วสฺตุ กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","อนฺธกาเร ติษฺฐนโต ยา: กถา อกถยต ตา: สรฺวฺวา: กถา ทีปฺเตา โศฺรษฺยนฺเต นิรฺชเน กรฺเณ จ ยทกถยต คฺฤหปฺฤษฺฐาตฺ ตตฺ ปฺรจารยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","เห พนฺธโว ยุษฺมานหํ วทามิ, เย ศรีรสฺย นาศํ วินา กิมปฺยปรํ กรฺตฺตุํ น ศกฺรุวนฺติ เตโภฺย มา ไภษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ตรฺหิ กสฺมาทฺ เภตวฺยมฺ อิตฺยหํ วทามิ, ย: ศรีรํ นาศยิตฺวา นรกํ นิกฺเษปฺตุํ ศกฺโนติ ตสฺมาเทว ภยํ กุรุต, ปุนรปิ วทามิ ตสฺมาเทว ภยํ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ปญฺจ จฏกปกฺษิณ: กึ ทฺวาภฺยำ ตามฺรขณฺฑาภฺยำ น วิกฺรียนฺเต? ตถาปีศฺวรเสฺตษามฺ เอกมปิ น วิสฺมรติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ยุษฺมากํ ศิร:เกศา อปิ คณิตา: สนฺติ ตสฺมาตฺ มา วิภีต พหุจฏกปกฺษิโภฺยปิ ยูยํ พหุมูลฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","อปรํ ยุษฺมภฺยํ กถยามิ ย: กศฺจินฺ มานุษาณำ สากฺษานฺ มำ สฺวีกโรติ มนุษฺยปุตฺร อีศฺวรทูตานำ สากฺษาตฺ ตํ สฺวีกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","กินฺตุ ย: กศฺจินฺมานุษาณำ สากฺษานฺมามฺ อสฺวีกโรติ ตมฺ อีศฺวรสฺย ทูตานำ สากฺษาทฺ อหมฺ อสฺวีกริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","อนฺยจฺจ ย: กศฺจินฺ มนุชสุตสฺย นินฺทาภาเวน กาญฺจิตฺ กถำ กถยติ ตสฺย ตตฺปาปสฺย โมจนํ ภวิษฺยติ กินฺตุ ยทิ กศฺจิตฺ ปวิตฺรมฺ อาตฺมานํ นินฺทติ ตรฺหิ ตสฺย ตตฺปาปสฺย โมจนํ น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ยทา โลกา ยุษฺมานฺ ภชนเคหํ วิจารกรฺตฺฤราชฺยกรฺตฺฤณำ สมฺมุขญฺจ เนษฺยนฺติ ตทา เกน ปฺรกาเรณ กิมุตฺตรํ วทิษฺยถ กึ กถยิษฺยถ เจตฺยตฺร มา จินฺตยต; ");
INSERT INTO santha_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ยโต ยุษฺมาภิรฺยทฺ ยทฺ วกฺตวฺยํ ตตฺ ตสฺมินฺ สมเยอว ปวิตฺร อาตฺมา ยุษฺมานฺ ศิกฺษยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ตต: ปรํ ชนตามธฺยสฺถ: กศฺจิชฺชนสฺตํ ชคาท เห คุโร มยา สห ไปตฺฤกํ ธนํ วิภกฺตุํ มม ภฺราตรมาชฺญาปยตุ ภวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","กินฺตุ ส ตมวทตฺ เห มนุษฺย ยุวโย รฺวิจารํ วิภาคญฺจ กรฺตฺตุํ มำ โก นิยุกฺตวานฺ? ");
INSERT INTO santha_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","อนนฺตรํ ส โลกานวทตฺ โลเภ สาวธานา: สตรฺกาศฺจ ติษฺฐต, ยโต พหุสมฺปตฺติปฺราปฺตฺยา มนุษฺยสฺยายุ รฺน ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ปศฺจาทฺ ทฺฤษฺฏานฺตกถามุตฺถาปฺย กถยามาส, เอกสฺย ธนิโน ภูเมา พหูนิ ศสฺยานิ ชาตานิฯ ");
INSERT INTO santha_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ตต: ส มนสา จินฺตยิตฺวา กถยามฺพภูว มไมตานิ สมุตฺปนฺนานิ ทฺรวฺยาณิ สฺถาปยิตุํ สฺถานํ นาสฺติ กึ กริษฺยามิ? ");
INSERT INTO santha_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ตโตวททฺ อิตฺถํ กริษฺยามิ, มม สรฺวฺวภาณฺฑาคาราณิ ภงฺกฺตฺวา พฺฤหทฺภาณฺฑาคาราณิ นิรฺมฺมาย ตนฺมเธฺย สรฺวฺวผลานิ ทฺรวฺยาณิ จ สฺถาปยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","อปรํ นิชมโน วทิษฺยามิ, เห มโน พหุวตฺสรารฺถํ นานาทฺรวฺยาณิ สญฺจิตานิ สนฺติ วิศฺรามํ กุรุ ภุกฺตฺวา ปีตฺวา เกาตุกญฺจ กุรุฯ กินฺตฺวีศฺวรสฺตมฺ อวทตฺ, ");
INSERT INTO santha_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","เร นิรฺโพธ อทฺย ราเตฺรา ตว ปฺราณาสฺตฺวตฺโต เนษฺยนฺเต ตต เอตานิ ยานิ ทฺรวฺยาณิ ตฺวยาสาทิตานิ ตานิ กสฺย ภวิษฺยนฺติ? ");
INSERT INTO santha_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","อเตอว ย: กศฺจิทฺ อีศฺวรสฺย สมีเป ธนสญฺจยมกฺฤตฺวา เกวลํ สฺวนิกเฏ สญฺจยํ กโรติ โสปิ ตาทฺฤศ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","อถ ส ศิเษฺยภฺย: กถยามาส, ยุษฺมานหํ วทามิ, กึ ขาทิษฺยาม:? กึ ปริธาสฺยาม:? อิตฺยุกฺตฺวา ชีวนสฺย ศรีรสฺย จารฺถํ จินฺตำ มา การฺษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ภกฺษฺยาชฺชีวนํ ภูษณาจฺฉรีรญฺจ เศฺรษฺฐํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","กากปกฺษิณำ การฺยฺยํ วิจารยต, เต น วปนฺติ ศสฺยานิ จ น ฉินฺทนฺติ, เตษำ ภาณฺฑาคาราณิ น สนฺติ โกษาศฺจ น สนฺติ, ตถาปีศฺวรเสฺตโภฺย ภกฺษฺยาณิ ททาติ, ยูยํ ปกฺษิภฺย: เศฺรษฺฐตรา น กึ? ");
INSERT INTO santha_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","อปรญฺจ ภาวยิตฺวา นิชายุษ: กฺษณมาตฺรํ วรฺทฺธยิตุํ ศกฺโนติ, เอตาทฺฤโศ ลาโก ยุษฺมากํ มเธฺย โกสฺติ? ");
INSERT INTO santha_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","อเตอว กฺษุทฺรํ การฺยฺยํ สาธยิตุมฺ อสมรฺถา ยูยมฺ อนฺยสฺมินฺ การฺเยฺย กุโต ภาวยถ? ");
INSERT INTO santha_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","อนฺยจฺจ กามฺปิลปุษฺปํ กถํ วรฺทฺธเต ตทาปิ วิจารยต, ตตฺ กญฺจน ศฺรมํ น กโรติ ตนฺตูํศฺจ น ชนยติ กินฺตุ ยุษฺมภฺยํ ยถารฺถํ กถยามิ สุเลมานฺ พไหฺวศฺวรฺยฺยานฺวิโตปิ ปุษฺปสฺยาสฺย สทฺฤโศ วิภูษิโต นาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","อทฺย เกฺษเตฺร วรฺตฺตมานํ ศฺวศฺจูลฺลฺยำ เกฺษปฺสฺยมานํ ยตฺ ตฺฤณํ, ตไสฺม ยทีศฺวร อิตฺถํ ภูษยติ ตรฺหิ เห อลฺปปฺรตฺยยิโน ยุษฺมาน กึ น ปริธาปยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","อเตอว กึ ขาทิษฺยาม:? กึ ปริธาสฺยาม:? เอตทรฺถํ มา เจษฺฏธฺวํ มา สํทิคฺธฺวญฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ชคโต เทวารฺจฺจกา เอตานิ สรฺวฺวาณิ เจษฺฏนเต; เอษุ วสฺตุษุ ยุษฺมากํ ปฺรโยชนมาเสฺต อิติ ยุษฺมากํ ปิตา ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","อเตอเวศฺวรสฺย ราชฺยารฺถํ สเจษฺฏา ภวต ตถา กฺฤเต สรฺวฺวาเณฺยตานิ ทฺรวฺยาณิ ยุษฺมภฺยํ ปฺรทายิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","เห กฺษุทฺรเมษวฺรช ยูยํ มา ไภษฺฏ ยุษฺมภฺยํ ราชฺยํ ทาตุํ ยุษฺมากํ ปิตุ: สมฺมติรสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","อเตอว ยุษฺมากํ ยา ยา สมฺปตฺติรสฺติ ตำ ตำ วิกฺรีย วิตรต, ยตฺ สฺถานํ เจารา นาคจฺฉนฺติ, กีฏาศฺจ น กฺษายยนฺติ ตาทฺฤเศ สฺวรฺเค นิชารฺถมฺ อชเร สมฺปุฏเก 'กฺษยํ ธนํ สญฺจินุต จ; ");
INSERT INTO santha_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ยโต ยตฺร ยุษฺมากํ ธนํ วรฺตฺตเต ตเตฺรว ยุษฺมากํ มน:ฯ ");
INSERT INTO santha_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","อปรญฺจ ยูยํ ปฺรทีปํ ชฺวาลยิตฺวา พทฺธกฏยสฺติษฺฐต; ");
INSERT INTO santha_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ปฺรภุ รฺวิวาหาทาคตฺย ยไทว ทฺวารมาหนฺติ ตไทว ทฺวารํ โมจยิตุํ ยถา ภฺฤตฺยา อเปกฺษฺย ติษฺฐนฺติ ตถา ยูยมปิ ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ยต: ปฺรภุราคตฺย ยานฺ ทาสานฺ สเจตนานฺ ติษฺฐโต ทฺรกฺษฺยติ เตอว ธนฺยา:; อหํ ยุษฺมานฺ ยถารฺถํ วทามิ ปฺรภุสฺตานฺ โภชนารฺถมฺ อุปเวศฺย สฺวยํ พทฺธกฏิ: สมีปเมตฺย ปริเวษยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ยทิ ทฺวิตีเย ตฺฤตีเย วา ปฺรหเร สมาคตฺย ตไถว ปศฺยติ, ตรฺหิ เตอว ทาสา ธนฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","อปรญฺจ กสฺมินฺ กฺษเณ เจารา อาคมิษฺยนฺติ อิติ ยทิ คฺฤหปติ รฺชฺญาตุํ ศกฺโนติ ตทาวศฺยํ ชาคฺรนฺ นิชคฺฤเห สนฺธึ กรฺตฺตยิตุํ วารยติ ยูยเมตทฺ วิตฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","อเตอว ยูยมปิ สชฺชมานาสฺติษฺฐต ยโต ยสฺมินฺ กฺษเณ ตํ นาเปฺรกฺษเธฺว ตสฺมินฺเนว กฺษเณ มนุษฺยปุตฺร อาคมิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ตทา ปิตร: ปปฺรจฺฉ, เห ปฺรโภ ภวานฺ กิมสฺมานฺ อุทฺทิศฺย กึ สรฺวฺวานฺ อุทฺทิศฺย ทฺฤษฺฏานฺตกถามิมำ วทติ? ");
INSERT INTO santha_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ตต: ปฺรภุ: โปฺรวาจ, ปฺรภุ: สมุจิตกาเล นิชปริวารารฺถํ โภชฺยปริเวษณาย ยํ ตตฺปเท นิโยกฺษฺยติ ตาทฺฤโศ วิศฺวาโสฺย โพทฺธา กรฺมฺมาธีศ: โกสฺติ? ");
INSERT INTO santha_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ปฺรภุราคตฺย ยมฺ เอตาทฺฤเศ กรฺมฺมณิ ปฺรวฺฤตฺตํ ทฺรกฺษฺยติ เสอว ทาโส ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","อหํ ยุษฺมานฺ ยถารฺถํ วทามิ ส ตํ นิชสรฺวฺวสฺวสฺยาธิปตึ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","กินฺตุ ปฺรภุรฺวิลมฺเพนาคมิษฺยติ, อิติ วิจินฺตฺย ส ทาโส ยทิ ตทนฺยทาสีทาสานฺ ปฺรหรฺตฺตุมฺ โภกฺตุํ ปาตุํ มทิตุญฺจ ปฺรารภเต, ");
INSERT INTO santha_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ตรฺหิ ยทา ปฺรภุํ นาเปกฺษิษฺยเต ยสฺมินฺ กฺษเณ โส'เจตนศฺจ สฺถาสฺยติ ตสฺมินฺเนว กฺษเณ ตสฺย ปฺรภุราคตฺย ตํ ปทภฺรษฺฏํ กฺฤตฺวา วิศฺวาสหีไน: สห ตสฺย อํศํ นิรูปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","โย ทาส: ปฺรเภाราชฺญำ ชฺญาตฺวาปิ สชฺชิโต น ติษฺฐติ ตทาชฺญานุสาเรณ จ การฺยฺยํ น กโรติ โสเนกานฺ ปฺรหารานฺ ปฺราปฺสฺยติ; ");
INSERT INTO santha_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","กินฺตุ โย ชโน'ชฺญาตฺวา ปฺรหารารฺหํ กรฺมฺม กโรติ โสลฺปปฺรหารานฺ ปฺราปฺสฺยติฯ ยโต ยไสฺม พาหุเลฺยน ทตฺตํ ตสฺมาเทว พาหุเลฺยน คฺรหีษฺยเต, มานุษา ยสฺย นิกเฏ พหุ สมรฺปยนฺติ ตสฺมาทฺ พหุ ยาจนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","อหํ ปฺฤถิวฺยามฺ อไนกฺยรูปํ วหฺนิ นิกฺเษปฺตุมฺ อาคโตสฺมิ, ส เจทฺ อิทานีเมว ปฺรชฺวลติ ตตฺร มม กา จินฺตา? ");
INSERT INTO santha_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","กินฺตุ เยน มชฺชเนนาหํ มคฺโน ภวิษฺยามิ ยาวตฺกาลํ ตสฺย สิทฺธิ รฺน ภวิษฺยติ ตาวทหํ กติกษฺฏํ ปฺราปฺสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","เมลนํ กรฺตฺตุํ ชคทฺ อาคโตสฺมิ ยูยํ กิมิตฺถํ โพธเธฺว? ยุษฺมานฺ วทามิ น ตถา, กินฺตฺวหํ เมลนาภาวํ กรฺตฺตุํมฺ อาคโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ยสฺมาเทตตฺกาลมารภฺย เอกตฺรสฺถปริชนานำ มเธฺย ปญฺจชนา: ปฺฤถคฺ ภูตฺวา ตฺรโย ชนา ทฺวโยรฺชนโย: ปฺรติกูลา เทฺวา ชเนา จ ตฺรยาณำ ชนานำ ปฺรติกูเลา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ปิตา ปุตฺรสฺย วิปกฺษ: ปุตฺรศฺจ ปิตุ รฺวิปกฺโษ ภวิษฺยติ มาตา กนฺยายา วิปกฺษา กนฺยา จ มาตุ รฺวิปกฺษา ภวิษฺยติ, ตถา ศฺวศฺรูรฺพธฺวา วิปกฺษา พธูศฺจ ศฺวศฺรฺวา วิปกฺษา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ส โลเกโภฺยปรมปิ กถยามาส, ปศฺจิมทิศิ เมโฆทฺคมํ ทฺฤษฺฏฺวา ยูยํ หฐาทฺ วทถ วฺฤษฺฏิ รฺภวิษฺยติ ตตสฺตไถว ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","อปรํ ทกฺษิณโต วาเยา วาติ สติ วทถ นิทาโฆ ภวิษฺยติ ตต: โสปิ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","เร เร กปฏิน อากาศสฺย ภูมฺยาศฺจ ลกฺษณํ โพทฺธุํ ศกฺนุถ, ");
INSERT INTO santha_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","กินฺตุ กาลสฺยาสฺย ลกฺษณํ กุโต โพทฺธุํ น ศกฺนุถ? ยูยญฺจ สฺวยํ กุโต น นฺยาษฺยํ วิจารยถ? ");
INSERT INTO santha_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","อปรญฺจ วิวาทินา สารฺทฺธํ วิจารยิตุ: สมีปํ คจฺฉนฺ ปถิ ตสฺมาทุทฺธารํ ปฺราปฺตุํ ยตสฺว โนเจตฺ ส ตฺวำ ธฺฤตฺวา วิจารยิตุ: สมีปํ นยติฯ วิจารยิตา ยทิ ตฺวำ ปฺรหรฺตฺตุ: สมีปํ สมรฺปยติ ปฺรหรฺตฺตา ตฺวำ การายำ พธฺนาติ ");
INSERT INTO santha_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ตรฺหิ ตฺวามหํ วทามิ ตฺวยา นิ:เศษํ กปรฺทเกษุ น ปริโศธิเตษุ ตฺวํ ตโต มุกฺตึ ปฺราปฺตุํ น ศกฺษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","อปรญฺจ ปีลาโต เยษำ คาลีลียานำ รกฺตานิ พลีนำ รกฺไต: สหามิศฺรยตฺ เตษำ คาลีลียานำ วฺฤตฺตานฺตํ กติปยชนา อุปสฺถาปฺย ยีศเว กถยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ตต: ส ปฺรตฺยุวาจ เตษำ โลกานามฺ เอตาทฺฤศี ทุรฺคติ รฺฆฏิตา ตตฺการณาทฺ ยูยํ กิมเนฺยโภฺย คาลีลีเยโภฺยปฺยธิกปาปินสฺตานฺ โพธเธฺว? ");
INSERT INTO santha_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ยุษฺมานหํ วทามิ ตถา น กินฺตุ มน:สุ น ปราวรฺตฺติเตษุ ยูยมปิ ตถา นํกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","อปรญฺจ ศีโลหนามฺน อุจฺจคฺฤหสฺย ปตนาทฺ เย'ษฺฏาทศชนา มฺฤตาเสฺต ยิรูศาลมิ นิวาสิสรฺวฺวโลเกโภฺย'ธิกาปราธิน: กึ ยูยมิตฺยํ โพธเธฺว? ");
INSERT INTO santha_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ยุษฺมานหํ วทามิ ตถา น กินฺตุ มน:สุ น ปริวรฺตฺติเตษุ ยูยมปิ ตถา นํกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","อนนฺตรํ ส อิมำ ทฺฤษฺฏานฺตกถามกถยทฺ เอโก ชโน ทฺรากฺษากฺเษตฺรมธฺย เอกมุฑุมฺพรวฺฤกฺษํ โรปิตวานฺฯ ปศฺจาตฺ ส อาคตฺย ตสฺมินฺ ผลานิ คเวษยามาส, ");
INSERT INTO santha_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","กินฺตุ ผลาปฺราปฺเต: การณาทฺ อุทฺยานการํ ภฺฤตฺยํ ชคาท, ปศฺย วตฺสรตฺรยํ ยาวทาคตฺย เอตสฺมินฺนุฑุมฺพรตเรา กฺษลานฺยนฺวิจฺฉามิ, กินฺตุ ไนกมปิ ปฺรปฺโนมิ ตรุรยํ กุโต วฺฤถา สฺถานํ วฺยาปฺย ติษฺฐติ? เอนํ ฉินฺธิฯ ");
INSERT INTO santha_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ตโต ภฺฤตฺย: ปฺรตฺยุวาจ, เห ปฺรโภ ปุนรฺวรฺษเมกํ สฺถาตุมฺ อาทิศ; เอตสฺย มูลสฺย จตุรฺทิกฺษุ ขนิตฺวาหมฺ อาลวาลํ สฺถาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ตต: ผลิตุํ ศกฺโนติ ยทิ น ผลติ ตรฺหิ ปศฺจาตฺ เฉตฺสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","อถ วิศฺรามวาเร ภชนเคเห ยีศุรุปทิศติ ");
INSERT INTO santha_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ตสฺมิตฺ สมเย ภูตคฺรสฺตตฺวาตฺ กุพฺชีภูยาษฺฏาทศวรฺษาณิ ยาวตฺ เกนาปฺยุปาเยน ฤชุ รฺภวิตุํ น ศกฺโนติ ยา ทุรฺพฺพลา สฺตฺรี, ");
INSERT INTO santha_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ตำ ตโตฺรปสฺถิตำ วิโลกฺย ยีศุสฺตามาหูย กถิตวานฺ เห นาริ ตว เทารฺพฺพลฺยาตฺ ตฺวํ มุกฺตา ภวฯ ");
INSERT INTO santha_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ตต: ปรํ ตสฺยา คาเตฺร หสฺตารฺปณมาตฺราตฺ สา ฤชุรฺภูเตฺวศฺวรสฺย ธนฺยวาทํ กรฺตฺตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","กินฺตุ วิศฺรามวาเร ยีศุนา ตสฺยา: สฺวาสฺถฺยกรณาทฺ ภชนเคหสฺยาธิปติ: ปฺรกุปฺย โลกานฺ อุวาจ, ษฏฺสุ ทิเนษุ โลไก: กรฺมฺม กรฺตฺตวฺยํ ตสฺมาทฺเธโต: สฺวาสฺถฺยารฺถํ เตษุ ทิเนษุ อาคจฺฉต, วิศฺรามวาเร มาคจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ตทา ปภุ: ปฺรตฺยุวาจ เร กปฏิโน ยุษฺมากมฺ เอไกโก ชโน วิศฺรามวาเร สฺวียํ สฺวียํ วฺฤษภํ ครฺทภํ วา พนฺธนานฺโมจยิตฺวา ชลํ ปายยิตุํ กึ น นยติ? ");
INSERT INTO santha_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ตรฺหฺยาษฺฏาทศวตฺสรานฺ ยาวตฺ ไศตานา พทฺธา อิพฺราหีม: สนฺตติริยํ นารี กึ วิศฺรามวาเร น โมจยิตวฺยา? ");
INSERT INTO santha_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","เอษุ วาเกฺยษุ กถิเตษุ ตสฺย วิปกฺษา: สลชฺชา ชาตา: กินฺตุ เตน กฺฤตสรฺวฺวมหากรฺมฺมการณาตฺ โลกนิวห: สานนฺโท'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","อนนฺตรํ โสวททฺ อีศฺวรสฺย ราชฺยํ กสฺย สทฺฤศํ? เกน ตทุปมาสฺยามิ? ");
INSERT INTO santha_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ยตฺ สรฺษปพีชํ คฺฤหีตฺวา กศฺจิชฺชน อุทฺยาน อุปฺตวานฺ ตทฺ พีชมงฺกุริตํ สตฺ มหาวฺฤกฺโษ'ชายต, ตตสฺตสฺย ศาขาสุ วิหายสียวิหคา อาคตฺย นฺยูษุ:, ตทฺราชฺยํ ตาทฺฤเศน สรฺษปพีเชน ตุลฺยํฯ ");
INSERT INTO santha_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ปุน: กถยามาส, อีศฺวรสฺย ราชฺยํ กสฺย สทฺฤศํ วทิษฺยามิ? ยตฺ กิณฺวํ กาจิตฺ สฺตฺรี คฺฤหีตฺวา โทฺรณตฺรยปริมิตโคธูมจูรฺเณษุ สฺถาปยามาส, ");
INSERT INTO santha_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ตต: กฺรเมณ ตตฺ สรฺวฺวโคธูมจูรฺณํ วฺยาปฺโนติ, ตสฺย กิณฺวสฺย ตุลฺยมฺ อีศฺวรสฺย ราชฺยํฯ ");
INSERT INTO santha_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ตต: ส ยิรูศาลมฺนครํ ปฺรติ ยาตฺรำ กฺฤตฺวา นคเร นคเร คฺราเม คฺราเม สมุปทิศนฺ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ตทา กศฺจิชฺชนสฺตํ ปปฺรจฺฉ, เห ปฺรโภ กึ เกวลมฺ อลฺเป โลกา: ปริตฺราสฺยนฺเต? ");
INSERT INTO santha_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ตต: ส โลกานฺ อุวาจ, สํกีรฺณทฺวาเรณ ปฺรเวษฺฏุํ ยตฆฺวํ, ยโตหํ ยุษฺมานฺ วทามิ, พหว: ปฺรเวษฺฏุํ เจษฺฏิษฺยนฺเต กินฺตุ น ศกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","คฺฤหปติโนตฺถาย ทฺวาเร รุทฺเธ สติ ยทิ ยูยํ พหิ: สฺถิตฺวา ทฺวารมาหตฺย วทถ, เห ปฺรโภ เห ปฺรโภ อสฺมตฺการณาทฺ ทฺวารํ โมจยตุ, ตต: ส อิติ ปฺรติวกฺษฺยติ, ยูยํ กุตฺรตฺยา โลกา อิตฺยหํ น ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ตทา ยูยํ วทิษฺยถ, ตว สากฺษาทฺ วยํ เภाชนํ ปานญฺจ กฺฤตวนฺต:, ตฺวญฺจาสฺมากํ นครสฺย ปถิ สมุปทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","กินฺตุ ส วกฺษฺยติ, ยุษฺมานหํ วทามิ, ยูยํ กุตฺรตฺยา โลกา อิตฺยหํ น ชานามิ; เห ทุราจาริโณ ยูยํ มตฺโต ทูรีภวตฯ ");
INSERT INTO santha_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ตทา อิพฺราหีมํ อิสฺหากํ ยากูพญฺจ สรฺวฺวภวิษฺยทฺวาทินศฺจ อีศฺวรสฺย ราชฺยํ ปฺราปฺตานฺ สฺวำศฺจ พหิษฺกฺฤตานฺ ทฺฤษฺฏฺวา ยูยํ โรทนํ ทนฺไตรฺทนฺตฆรฺษณญฺจ กริษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","อปรญฺจ ปูรฺวฺวปศฺจิมทกฺษิโณตฺตรทิคฺโภฺย โลกา อาคตฺย อีศฺวรสฺย ราเชฺย นิวตฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ปศฺยเตตฺถํ เศษียา โลกา อคฺรา ภวิษฺยนฺติ, อคฺรียา โลกาศฺจ เศษา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","อปรญฺจ ตสฺมินฺ ทิเน กิยนฺต: ผิรูศิน อาคตฺย ยีศุํ โปฺรจุ:, พหิรฺคจฺฉ, สฺถานาทสฺมาตฺ ปฺรสฺถานํ กุรุ, เหโรทฺ ตฺวำ ชิฆำสติฯ ");
INSERT INTO santha_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ตต: ส ปฺรตฺยโวจตฺ ปศฺยตาทฺย ศฺวศฺจ ภูตานฺ วิหาปฺย โรคิโณ'โรคิณ: กฺฤตฺวา ตฺฤตีเยหฺนิ เสตฺสฺยามิ, กถาเมตำ ยูยมิตฺวา ตํ ภูริมายํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ตตฺราปฺยทฺย ศฺว: ปรศฺวศฺจ มยา คมนาคมเน กรฺตฺตเวฺย, ยโต เหโต รฺยิรูศาลโม พหิ: กุตฺราปิ โกปิ ภวิษฺยทฺวาที น ฆานิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","เห ยิรูศาลมฺ เห ยิรูศาลมฺ ตฺวํ ภวิษฺยทฺวาทิโน หํสิ ตวานฺติเก เปฺรริตานฺ ปฺรสฺตไรรฺมารยสิ จ, ยถา กุกฺกุฏี นิชปกฺษาธ: สฺวศาวกานฺ สํคฺฤหฺลาติ, ตถาหมปิ ตว ศิศูนฺ สํคฺรหีตุํ กติวารานฺ ไอจฺฉํ กินฺตุ ตฺวํ ไนจฺฉ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ปศฺยต ยุษฺมากํ วาสสฺถานานิ โปฺรจฺฉิทฺยมานานิ ปริตฺยกฺตานิ จ ภวิษฺยนฺติ; ยุษฺมานหํ ยถารฺถํ วทามิ, ย: ปฺรโภ รฺนามฺนาคจฺฉติ ส ธนฺย อิติ วาจํ ยาวตฺกาลํ น วทิษฺยถ, ตาวตฺกาลํ ยูยํ มำ น ทฺรกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","อนนฺตรํ วิศฺรามวาเร ยีเศา ปฺรธานสฺย ผิรูศิโน คฺฤเห โภกฺตุํ คตวติ เต ตํ วีกฺษิตุมฺ อาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ตทา ชโลทรี ตสฺย สมฺมุเข สฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ตต: ส วฺยวสฺถาปกานฺ ผิรูศินศฺจ ปปฺรจฺฉ, วิศฺรามวาเร สฺวาสฺถฺยํ กรฺตฺตวฺยํ น วา? ตตเสฺต กิมปิ น ปฺรตฺยูจุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ตทา ส ตํ โรคิณํ สฺวสฺถํ กฺฤตฺวา วิสสรฺช; ");
INSERT INTO santha_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ตานุวาจ จ ยุษฺมากํ กสฺยจิทฺ ครฺทฺทโภ วฺฤษโภ วา เจทฺ ครฺตฺเต ปตติ ตรฺหิ วิศฺรามวาเร ตตฺกฺษณํ ส กึ ตํ โนตฺถาปยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ตตเสฺต กถายา เอตสฺยา: กิมปิ ปฺรติวกฺตุํ น เศกุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","อปรญฺจ ปฺรธานสฺถานมโนนีตตฺวกรณํ วิโลกฺย ส นิมนฺตฺริตานฺ เอตทุปเทศกถำ ชคาท, ");
INSERT INTO santha_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ตฺวํ วิวาหาทิโภเชฺยษุ นิมนฺตฺริต: สนฺ ปฺรธานสฺถาเน โมปาเวกฺษี:ฯ ตฺวตฺโต เคารวานฺวิตนิมนฺตฺริตชน อายาเต ");
INSERT INTO santha_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","นิมนฺตฺรยิตาคตฺย มนุษฺยาไยตไสฺม สฺถานํ เทหีติ วากฺยํ เจทฺ วกฺษฺยติ ตรฺหิ ตฺวํ สงฺกุจิโต ภูตฺวา สฺถาน อิตรสฺมินฺ อุปเวษฺฏุมฺ อุทฺยํสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","อสฺมาตฺ การณาเทว ตฺวํ นิมนฺตฺริโต คตฺวา'ปฺรธานสฺถาน อุปวิศ, ตโต นิมนฺตฺรยิตาคตฺย วทิษฺยติ, เห พนฺโธ โปฺรจฺจสฺถานํ คโตฺวปวิศ, ตถา สติ โภชโนปวิษฺฏานำ สกลานำ สากฺษาตฺ ตฺวํ มาโนฺย ภวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ย: กศฺจิตฺ สฺวมุนฺนมยติ ส นมยิษฺยเต, กินฺตุ ย: กศฺจิตฺ สฺวํ นมยติ ส อุนฺนมยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ตทา ส นิมนฺตฺรยิตารํ ชนมปิ ชคาท, มธฺยาเหฺน ราเตฺรา วา โภเชฺย กฺฤเต นิชพนฺธุคโณ วา ภฺราตฺฤृคโณ วา ชฺญาติคโณ วา ธนิคโณ วา สมีปวาสิคโณ วา เอตานฺ น นิมนฺตฺรย, ตถา กฺฤเต เจตฺ เต ตฺวำ นิมนฺตฺรยิษฺยนฺติ, ตรฺหิ ปริโศโธ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","กินฺตุ ยทา เภชฺยํ กโรษิ ตทา ทริทฺรศุษฺกกรขญฺชานฺธานฺ นิมนฺตฺรย, ");
INSERT INTO santha_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ตต อาศิษํ ลปฺสฺยเส, เตษุ ปริโศธํ กรฺตฺตุมศกฺนุวตฺสุ ศฺมศานาทฺธารฺมฺมิกานามุตฺถานกาเล ตฺวํ ผลำ ลปฺสฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","อนนฺตรํ ตำ กถำ นิศมฺย โภชโนปวิษฺฏ: กศฺจิตฺ กถยามาส, โย ชน อีศฺวรสฺย ราเชฺย โภกฺตุํ ลปฺสฺยเต เสอว ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ตต: ส อุวาจ, กศฺจิตฺ ชโน ราเตฺรา เภाชฺยํ กฺฤตฺวา พหูนฺ นิมนฺตฺรยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ตโต โภชนสมเย นิมนฺตฺริตโลกานฺ อาหฺวาตุํ ทาสทฺวารา กถยามาส, ขทฺยทฺรวฺยาณิ สรฺวฺวาณิ สมาสาทิตานิ สนฺติ, ยูยมาคจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","กินฺตุ เต สรฺวฺว เอไกกํ ฉลํ กฺฤตฺวา กฺษมำ ปฺรารฺถยาญฺจกฺริเรฯ ปฺรถโม ชน: กถยามาส, เกฺษตฺรเมกํ กฺรีตวานหํ ตเทว ทฺรษฺฏุํ มยา คนฺตวฺยมฺ, อเตอว มำ กฺษนฺตุํ ตํ นิเวทยฯ ");
INSERT INTO santha_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","อโนฺย ชน: กถยามาส, ทศวฺฤษานหํ กฺรีตวานฺ ตานฺ ปรีกฺษิตุํ ยามิ ตสฺมาเทว มำ กฺษนฺตุํ ตํ นิเวทยฯ ");
INSERT INTO santha_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","อปร: กถยามาส, วฺยูฒวานหํ ตสฺมาตฺ การณาทฺ ยาตุํ น ศกฺโนมิฯ ");
INSERT INTO santha_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ปศฺจาตฺ ส ทาโส คตฺวา นิชปฺรโภ: สากฺษาตฺ สรฺวฺววฺฤตฺตานฺตํ นิเวทยามาส, ตโตเสา คฺฤหปติ: กุปิตฺวา สฺวทาสํ วฺยาชหาร, ตฺวํ สตฺวรํ นครสฺย สนฺนิเวศานฺ มารฺคำศฺจ คตฺวา ทริทฺรศุษฺกกรขญฺชานฺธานฺ อตฺรานยฯ ");
INSERT INTO santha_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ตโต ทาโส'วทตฺ, เห ปฺรโภ ภวต อาชฺญานุสาเรณากฺริยต ตถาปิ สฺถานมสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ตทา ปฺรภุ: ปุน รฺทาสายากถยตฺ, ราชปถานฺ วฺฤกฺษมูลานิ จ ยาตฺวา มทียคฺฤหปูรณารฺถํ โลกานาคนฺตุํ ปฺรวรฺตฺตยฯ ");
INSERT INTO santha_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","อหํ ยุษฺมภฺยํ กถยามิ, ปูรฺวฺวนิมนฺตฺริตานเมโกปิ มมาสฺย ราตฺริโภชฺยสฺยาสฺวาทํ น ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","อนนฺตรํ พหุษุ โลเกษุ ยีโศ: ปศฺจาทฺ วฺรชิเตษุ สตฺสุ ส วฺยาฆุฏฺย เตภฺย: กถยามาส, ");
INSERT INTO santha_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ย: กศฺจินฺ มม สมีปมฺ อาคตฺย สฺวสฺย มาตา ปิตา ปตฺนี สนฺตานา ภฺราตโร ภคิโมฺย นิชปฺราณาศฺจ, เอเตภฺย: สรฺเวฺวโภฺย มยฺยธิกํ เปฺรม น กโรติ, ส มม ศิโษฺย ภวิตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ย: กศฺจิตฺ สฺวียํ กฺรุศํ วหนฺ มม ปศฺจานฺน คจฺฉติ, โสปิ มม ศิโษฺย ภวิตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ทุรฺคนิรฺมฺมาเณ กติวฺยโย ภวิษฺยติ, ตถา ตสฺย สมาปฺติกรณารฺถํ สมฺปตฺติรสฺติ น วา, ปฺรถมมุปวิศฺย เอตนฺน คณยติ, ยุษฺมากํ มธฺย เอตาทฺฤศ: โกสฺติ? ");
INSERT INTO santha_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","โนเจทฺ ภิตฺตึ กฺฤตฺวา เศเษ ยทิ สมาปยิตุํ น ศกฺษฺยติ, ");
INSERT INTO santha_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ตรฺหิ มานุโษยํ นิเจตุมฺ อารภต สมาปยิตุํ นาศกฺโนตฺ, อิติ วฺยาหฺฤตฺย สรฺเวฺว ตมุปหสิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","อปรญฺจ ภินฺนภูปตินา สห ยุทฺธํ กรฺตฺตุมฺ อุทฺยมฺย ทศสหสฺราณิ ไสนฺยานิ คฺฤหีตฺวา วึศติสหเสฺร: ไสไนฺย: สหิตสฺย สมีปวาสิน: สมฺมุขํ ยาตุํ ศกฺษฺยามิ น เวติ ปฺรถมํ อุปวิศฺย น วิจารยติ เอตาทฺฤโศ ภูมิปติ: ก:? ");
INSERT INTO santha_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ยทิ น ศกฺโนติ ตรฺหิ ริปาวติทูเร ติษฺฐติ สติ นิชทูตํ เปฺรษฺย สนฺธึ กรฺตฺตุํ ปฺรารฺถเยตฯ ");
INSERT INTO santha_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ตทฺวทฺ ยุษฺมากํ มเธฺย ย: กศฺจินฺ มทรฺถํ สรฺวฺวสฺวํ หาตุํ น ศกฺโนติ ส มม ศิโษฺย ภวิตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ลวณมฺ อุตฺตมมฺ อิติ สตฺยํ, กินฺตุ ยทิ ลวณสฺย ลวณตฺวมฺ อปคจฺฉติ ตรฺหิ ตตฺ กถํ สฺวาทุยุกฺตํ ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ตท ภูมฺยรฺถมฺ อาลวาลราศฺยรฺถมปิ ภทฺรํ น ภวติ; โลกาสฺตทฺ พหิ: กฺษิปนฺติฯ ยสฺย โศฺรตุํ โศฺรเตฺร สฺต: ส ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ตทา กรสญฺจายิน: ปาปินศฺจ โลกา อุปเทศฺกถำ โศฺรตุํ ยีโศ: สมีปมฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ตต: ผิรูศิน อุปาธฺยายาศฺจ วิวทมานา: กถยามาสุ: เอษ มานุษ: ปาปิภิ: สห ปฺรณยํ กฺฤตฺวา ไต: สารฺทฺธํ ภุํกฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ตทา ส เตภฺย อิมำ ทฺฤษฺฏานฺตกถำ กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","กสฺยจิตฺ ศตเมเษษุ ติษฺฐตฺมุ เตษาเมกํ ส ยทิ หารยติ ตรฺหิ มเธฺยปฺรานฺตรมฺ เอโกนศตเมษานฺ วิหาย หาริตเมษสฺย อุทฺเทศปฺราปฺติปรฺยฺยนตํ น คเวษยติ, เอตาทฺฤโศ โลโก ยุษฺมากํ มเธฺย ก อาเสฺต? ");
INSERT INTO santha_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ตโสฺยทฺเทศํ ปฺราปฺย หฺฤษฺฏมนาสฺตํ สฺกนฺเธ นิธาย สฺวสฺถานมฺ อานีย พนฺธุพานฺธวสมีปวาสิน อาหูย วกฺติ, ");
INSERT INTO santha_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","หาริตํ เมษํ ปฺราปฺโตหมฺ อโต เหโต รฺมยา สารฺทฺธมฺ อานนฺทตฯ ");
INSERT INTO santha_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ตทฺวทหํ ยุษฺมานฺ วทามิ, เยษำ มน:ปราวรฺตฺตนสฺย ปฺรโยชนํ นาสฺติ, ตาทฺฤไศโกนศตธารฺมฺมิกการณาทฺ ย อานนฺทสฺตสฺมาทฺ เอกสฺย มน:ปริวรฺตฺติน: ปาปิน: การณาตฺ สฺวรฺเค 'ธิกานนฺโท ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","อปรญฺจ ทศานำ รูปฺยขณฺฑานามฺ เอกขณฺเฑ หาริเต ปฺรทีปํ ปฺรชฺวาลฺย คฺฤหํ สมฺมารฺชฺย ตสฺย ปฺราปฺตึ ยาวทฺ ยตฺเนน น คเวษยติ, เอตาทฺฤศี โยษิตฺ กาเสฺต? ");
INSERT INTO santha_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ปฺราปฺเต สติ พนฺธุพานฺธวสมีปวาสินีราหูย กถยติ, หาริตํ รูปฺยขณฺฑํ ปฺราปฺตาหํ ตสฺมาเทว มยา สารฺทฺธมฺ อานนฺทตฯ ");
INSERT INTO santha_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ตทฺวทหํ ยุษฺมานฺ วฺยาหรามิ, เอเกน ปาปินา มนสิ ปริวรฺตฺติเต, อีศฺวรสฺย ทูตานำ มเธฺยปฺยานนฺโท ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","อปรญฺจ ส กถยามาส, กสฺยจิทฺ เทฺวา ปุตฺราวาสฺตำ, ");
INSERT INTO santha_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ตโย: กนิษฺฐ: ปุตฺร: ปิเตฺร กถยามาส, เห ปิตสฺตว สมฺปตฺตฺยา ยมํศํ ปฺราปฺสฺยามฺยหํ วิภชฺย ตํ เทหิ, ตต: ปิตา นิชำ สมฺปตฺตึ วิภชฺย ตาภฺยำ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","กติปยาตฺ กาลาตฺ ปรํ ส กนิษฺฐปุตฺร: สมสฺตํ ธนํ สํคฺฤหฺย ทูรเทศํ คตฺวา ทุษฺฏาจรเณน สรฺวฺวำ สมฺปตฺตึ นาศยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ตสฺย สรฺวฺวธเน วฺยยํ คเต ตทฺเทเศ มหาทุรฺภิกฺษํ พภูว, ตตสฺตสฺย ไทนฺยทศา ภวิตุมฺ อาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ตต: ปรํ ส คตฺวา ตทฺเทศียํ คฺฤหสฺถเมกมฺ อาศฺรยต; ตต: สตํ ศูกรวฺรชํ จารยิตุํ ปฺรานฺตรํ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","เกนาปิ ตไสฺม ภกฺษฺยาทานาตฺ ส ศูกรผลวลฺกเลน ปิจิณฺฑปูรณำ ววาญฺฉฯ ");
INSERT INTO santha_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","เศเษ ส มนสิ เจตนำ ปฺราปฺย กถยามาส, หา มม ปิตุ: สมีเป กติ กติ เวตนภุโช ทาสา ยเถษฺฏํ ตโตธิกญฺจ ภกฺษฺยํ ปฺราปฺนุวนฺติ กินฺตฺวหํ กฺษุธา มุมูรฺษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","อหมุตฺถาย ปิตุ: สมีปํ คตฺวา กถาเมตำ วทิษฺยามิ, เห ปิตรฺ อีศฺวรสฺย ตว จ วิรุทฺธํ ปาปมกรวมฺ ");
INSERT INTO santha_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ตว ปุตฺรอิติ วิขฺยาโต ภวิตุํ น โยโคฺยสฺมิ จ, มำ ตว ไวตนิกํ ทาสํ กฺฤตฺวา สฺถาปยฯ ");
INSERT INTO santha_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ปศฺจาตฺ ส อุตฺถาย ปิตุ: สมีปํ ชคาม; ตตสฺตสฺย ปิตาติทูเร ตํ นิรีกฺษฺย ทยาญฺจเกฺร, ธาวิตฺวา ตสฺย กณฺฐํ คฺฤหีตฺวา ตํ จุจุมฺพ จฯ ");
INSERT INTO santha_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ตทา ปุตฺร อุวาจ, เห ปิตรฺ อีศฺวรสฺย ตว จ วิรุทฺธํ ปาปมกรวํ, ตว ปุตฺรอิติ วิขฺยาโต ภวิตุํ น โยโคฺยสฺมิ จฯ ");
INSERT INTO santha_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","กินฺตุ ตสฺย ปิตา นิชทาสานฺ อาทิเทศ, สรฺโวฺวตฺตมวสฺตฺราณฺยานีย ปริธาปยไตนํ หเสฺต จางฺคุรียกมฺ อรฺปยต ปาทโยศฺโจปานเหา สมรฺปยต; ");
INSERT INTO santha_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ปุษฺฏํ โควตฺสมฺ อานีย มารยต จ ตํ ภุกฺตฺวา วยมฺ อานนฺทามฯ ");
INSERT INTO santha_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ยโต มม ปุโตฺรยมฺ อมฺริยต ปุนรชีวีทฺ หาริตศฺจ ลพฺโธภูตฺ ตตสฺต อานนฺทิตุมฺ อาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ตตฺกาเล ตสฺย เชฺยษฺฐ: ปุตฺร: เกฺษตฺร อาสีตฺฯ อถ ส นิเวศนสฺย นิกฏํ อาคจฺฉนฺ นฺฤตฺยานำ วาทฺยานาญฺจ ศพฺทํ ศฺรุตฺวา ");
INSERT INTO santha_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ทาสานามฺ เอกมฺ อาหูย ปปฺรจฺฉ, กึ การณมสฺย? ");
INSERT INTO santha_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ตต: โสวาทีตฺ, ตว ภฺราตาคมตฺ, ตว ตาตศฺจ ตํ สุศรีรํ ปฺราปฺย ปุษฺฏํ โควตฺสํ มาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ตต: ส ปฺรกุปฺย นิเวศนานฺต: ปฺรเวษฺฏุํ น สมฺเมเน; ตตสฺตสฺย ปิตา พหิราคตฺย ตํ สาธยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ตต: ส ปิตรํ ปฺรตฺยุวาจ, ปศฺย ตว กาญฺจิทปฺยาชฺญำ น วิลํฆฺย พหูนฺ วตฺสรานฺ อหํ ตฺวำ เสเว ตถาปิ มิไตฺร: สารฺทฺธมฺ อุตฺสวํ กรฺตฺตุํ กทาปิ ฉาคเมกมปิ มหฺยํ นาททา:; ");
INSERT INTO santha_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","กินฺตุ ตว ย: ปุโตฺร เวศฺยาคมนาทิภิสฺตว สมฺปตฺติมฺ อปวฺยยิตวานฺ ตสฺมินฺนาคตมาเตฺร ตไสฺยว นิมิตฺตํ ปุษฺฏํ โควตฺสํ มาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ตทา ตสฺย ปิตาโวจตฺ, เห ปุตฺร ตฺวํ สรฺวฺวทา มยา สหาสิ ตสฺมานฺ มม ยทฺยทาเสฺต ตตฺสรฺวฺวํ ตวฯ ");
INSERT INTO santha_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","กินฺตุ ตวายํ ภฺราตา มฺฤต: ปุนรชีวีทฺ หาริตศฺจ ภูตฺวา ปฺราปฺโตภูตฺ, เอตสฺมาตฺ การณาทฺ อุตฺสวานนฺเทา กรฺตฺตุมฺ อุจิตมสฺมากมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","อปรญฺจ ยีศุ: ศิเษฺยโภฺยนฺยาเมกำ กถำ กถยามาส กสฺยจิทฺ ธนวโต มนุษฺยสฺย คฺฤหการฺยฺยาธีเศ สมฺปตฺเตรปวฺยเย'ปวาทิเต สติ ");
INSERT INTO santha_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ตสฺย ปฺรภุสฺตมฺ อาหูย ชคาท, ตฺวยิ ยามิมำ กถำ ศฺฤโณมิ สา กีทฺฤศี? ตฺวํ คฺฤหการฺยฺยาธีศกรฺมฺมโณ คณนำ ทรฺศย คฺฤหการฺยฺยาธีศปเท ตฺวํ น สฺถาสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ตทา ส คฺฤหการฺยฺยาธีโศ มนสา จินฺตยามาส, ปฺรภุ รฺยทิ มำ คฺฤหการฺยฺยาธีศปทาทฺ ภฺรํศยติ ตรฺหิ กึ กริเษฺย'หํ? มฺฤทํ ขนิตุํ มม ศกฺติ รฺนาสฺติ ภิกฺษิตุญฺจ ลชฺชิเษฺย'หํฯ ");
INSERT INTO santha_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","อเตอว มยิ คฺฤหการฺยฺยาธีศปทาตฺ จฺยุเต สติ ยถา โลกา มหฺยมฺ อาศฺรยํ ทาสฺยนฺติ ตทรฺถํ ยตฺกรฺมฺม มยา กรณียํ ตนฺ นิรฺณียเตฯ ");
INSERT INTO santha_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ปศฺจาตฺ ส สฺวปฺรโภเรไกกมฺ อธมรฺณมฺ อาหูย ปฺรถมํ ปปฺรจฺฉ, ตฺวตฺโต เม ปฺรภุณา กติ ปฺราปฺยมฺ? ");
INSERT INTO santha_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ตต: ส อุวาจ, เอกศตาฒกไตลานิ; ตทา คฺฤหการฺยฺยาธีศ: โปฺรวาจ, ตว ปตฺรมานีย ศีฆฺรมุปวิศฺย ตตฺร ปญฺจาศตํ ลิขฯ ");
INSERT INTO santha_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ปศฺจาทนฺยเมกํ ปปฺรจฺฉ, ตฺวตฺโต เม ปฺรภุณา กติ ปฺราปฺยมฺ? ตต: โสวาทีทฺ เอกศตาฒกโคธูมา:; ตทา ส กถยามาส, ตว ปตฺรมานีย อศีตึ ลิขฯ ");
INSERT INTO santha_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","เตไนว ปฺรภุสฺตมยถารฺถกฺฤตมฺ อธีศํ ตทฺพุทฺธิไนปุณฺยาตฺ ปฺรศศํส; อิตฺถํ ทีปฺติรูปสนฺตาเนภฺย เอตตฺสํสารสฺย สนฺตานา วรฺตฺตมานกาเล'ธิกพุทฺธิมนฺโต ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","อโต วทามิ ยูยมปฺยยถารฺเถน ธเนน มิตฺราณิ ลภธฺวํ ตโต ยุษฺมาสุ ปทภฺรษฺเฏษฺวปิ ตานิ จิรกาลมฺ อาศฺรยํ ทาสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ย: กศฺจิตฺ กฺษุเทฺร การฺเยฺย วิศฺวาโสฺย ภวติ ส มหติ การฺเยฺยปิ วิศฺวาโสฺย ภวติ, กินฺตุ ย: กศฺจิตฺ กฺษุเทฺร การฺเยฺย'วิศฺวาโสฺย ภวติ ส มหติ การฺเยฺยปฺยวิศฺวาโสฺย ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","อเตอว อยถารฺเถน ธเนน ยทิ ยูยมวิศฺวาสฺยา ชาตาสฺตรฺหิ สตฺยํ ธนํ ยุษฺมากํ กเรษุ ก: สมรฺปยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ยทิ จ ปรธเนน ยูยมฺ อวิศฺวาสฺยา ภวถ ตรฺหิ ยุษฺมากํ สฺวกียธนํ ยุษฺมภฺยํ โก ทาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","โกปิ ทาส อุเภา ปฺรภู เสวิตุํ น ศกฺโนติ, ยต เอกสฺมินฺ ปฺรียมาโณ'นฺยสฺมินฺนปฺรียเต ยทฺวา เอกํ ชนํ สมาทฺฤตฺย ตทนฺยํ ตุจฺฉีกโรติ ตทฺวทฺ ยูยมปิ ธเนศฺวเรา เสวิตุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ตไทตา: สรฺวฺวา: กถา: ศฺรุตฺวา โลภิผิรูศินสฺตมุปชหสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ตต: ส อุวาจ, ยูยํ มนุษฺยาณำ นิกเฏ สฺวานฺ นิรฺโทษานฺ ทรฺศยถ กินฺตุ ยุษฺมากมฺ อนฺต:กรณานีศฺวโร ชานาติ, ยตฺ มนุษฺยาณามฺ อติ ปฺรศํสฺยํ ตทฺ อีศฺวรสฺย ฆฺฤณฺยํฯ ");
INSERT INTO santha_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","โยหน อาคมนปรฺยฺยนตํ ยุษฺมากํ สมีเป วฺยวสฺถาภวิษฺยทฺวาทินำ เลขนานิ จาสนฺ ตต: ปฺรภฺฤติ อีศฺวรราชฺยสฺย สุสํวาท: ปฺรจรติ, เอไกโก โลกสฺตนฺมธฺยํ ยตฺเนน ปฺรวิศติ จฯ ");
INSERT INTO santha_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","วรํ นภส: ปฺฤถิวฺยาศฺจ โลโป ภวิษฺยติ ตถาปิ วฺยวสฺถายา เอกพินฺโทรปิ โลโป น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ย: กศฺจิตฺ สฺวียำ ภารฺยฺยำ วิหาย สฺตฺริยมนฺยำ วิวหติ ส ปรทารานฺ คจฺฉติ, ยศฺจ ตา ตฺยกฺตำ นารีํ วิวหติ โสปิ ปรทาราน คจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","เอโก ธนี มนุษฺย: ศุกฺลานิ สูกฺษฺมาณิ วสฺตฺราณิ ปรฺยฺยทธาตฺ ปฺรติทินํ ปริโตษรูเปณาภุํกฺตาปิวจฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","สรฺวฺวางฺเค กฺษตยุกฺต อิลิยาสรนามา กศฺจิทฺ ทริทฺรสฺตสฺย ธนวโต โภชนปาตฺราตฺ ปติตมฺ อุจฺฉิษฺฏํ โภกฺตุํ วาญฺฉนฺ ตสฺย ทฺวาเร ปติตฺวาติษฺฐตฺ; ");
INSERT INTO santha_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","อถ ศฺวาน อาคตฺย ตสฺย กฺษตานฺยลิหนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","กิยตฺกาลาตฺปรํ ส ทริทฺร: ปฺราณานฺ ชเหา; ตต: สฺวรฺคียทูตาสฺตํ นีตฺวา อิพฺราหีม: โกฺรฑ อุปเวศยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ปศฺจาตฺ ส ธนวานปิ มมาร, ตํ ศฺมศาเน สฺถาปยามาสุศฺจ; กินฺตุ ปรโลเก ส เวทนากุล: สนฺ อูรฺทฺธฺวำ นิรีกฺษฺย พหุทูราทฺ อิพฺราหีมํ ตตฺโกฺรฑ อิลิยาสรญฺจ วิโลกฺย รุวนฺนุวาจ; ");
INSERT INTO santha_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","เห ปิตรฺ อิพฺราหีมฺ อนุคฺฤหฺย องฺคุลฺยคฺรภาคํ ชเล มชฺชยิตฺวา มม ชิหฺวำ ศีตลำ กรฺตฺตุมฺ อิลิยาสรํ เปฺรรย, ยโต วหฺนิศิขาโตหํ วฺยถิโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ตทา อิพฺราหีมฺ พภาเษ, เห ปุตฺร ตฺวํ ชีวนฺ สมฺปทํ ปฺราปฺตวานฺ อิลิยาสรสฺตุ วิปทํ ปฺราปฺตวานฺ เอตตฺ สฺมร, กินฺตุ สมฺปฺรติ ตสฺย สุขํ ตว จ ทุ:ขํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","อปรมปิ ยุษฺมากมฺ อสฺมากญฺจ สฺถานโย รฺมเธฺย มหทฺวิจฺเฉโท'สฺติ ตต เอตตฺสฺถานสฺย โลกาสฺตตฺ สฺถานํ ยาตุํ ยทฺวา ตตฺสฺถานสฺย โลกา เอตตฺ สฺถานมายาตุํ น ศกฺนุวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ตทา ส อุกฺตวานฺ, เห ปิตสฺตรฺหิ ตฺวำ นิเวทยามิ มม ปิตุ เรฺคเห เย มม ปญฺจ ภฺราตร: สนฺติ ");
INSERT INTO santha_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","เต ยไถตทฺ ยาตนาสฺถานํ นายาสฺยนฺติ ตถา มนฺตฺรณำ ทาตุํ เตษำ สมีปมฺ อิลิยาสรํ เปฺรรยฯ ");
INSERT INTO santha_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ตต อิพฺราหีมฺ อุวาจ, มูสาภวิษฺยทฺวาทินาญฺจ ปุสฺตกานิ เตษำ นิกเฏ สนฺติ เต ตทฺวจนานิ มนฺยนฺตำฯ ");
INSERT INTO santha_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ตทา ส นิเวทยามาส, เห ปิตรฺ อิพฺราหีมฺ น ตถา, กินฺตุ ยทิ มฺฤตโลกานำ กศฺจิตฺ เตษำ สมีปํ ยาติ ตรฺหิ เต มนำสิ วฺยาโฆฏยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ตต อิพฺราหีมฺ ชคาท, เต ยทิ มูสาภวิษฺยทฺวาทินาญฺจ วจนานิ น มนฺยนฺเต ตรฺหิ มฺฤตโลกานำ กสฺมึศฺจิทฺ อุตฺถิเตปิ เต ตสฺย มนฺตฺรณำ น มํสฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","อิต: ปรํ ยีศุ: ศิษฺยานฺ อุวาจ, วิคฺไหฺนรวศฺยมฺ อาคนฺตวฺยํ กินฺตุ วิฆฺนา เยน ฆฏิษฺยนฺเต ตสฺย ทุรฺคติ รฺภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","เอเตษำ กฺษุทฺรปฺราณินามฺ เอกสฺยาปิ วิฆฺนชนนาตฺ กณฺฐพทฺธเปษณีกสฺย ตสฺย สาคราคาธชเล มชฺชนํ ภทฺรํฯ ");
INSERT INTO santha_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ยูยํ เสฺวษุ สาวธานาสฺติษฺฐต; ตว ภฺราตา ยทิ ตว กิญฺจิทฺ อปราธฺยติ ตรฺหิ ตํ ตรฺชย, เตน ยทิ มน: ปริวรฺตฺตยติ ตรฺหิ ตํ กฺษมสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ปุนเรกทินมเธฺย ยทิ ส ตว สปฺตกฺฤโตฺว'ปราธฺยติ กินฺตุ สปฺตกฺฤตฺว อาคตฺย มน: ปริวรฺตฺย มยาปราทฺธมฺ อิติ วทติ ตรฺหิ ตํ กฺษมสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ตทา เปฺรริตา: ปฺรภุมฺ อวทนฺ อสฺมากํ วิศฺวาสํ วรฺทฺธยฯ ");
INSERT INTO santha_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ปฺรภุรุวาจ, ยทิ ยุษฺมากํ สรฺษไปกปฺรมาโณ วิศฺวาโสสฺติ ตรฺหิ ตฺวํ สมูลมุตฺปาฏิโต ภูตฺวา สมุเทฺร โรปิโต ภว กถายามฺ เอตสฺยามฺ เอตทุฑุมฺพราย กถิตายำ ส ยุษฺมากมาชฺญาวโห ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","อปรํ สฺวทาเส หลํ วาหยิตฺวา วา ปศูนฺ จารยิตฺวา เกฺษตฺราทฺ อาคเต สติ ตํ วทติ, เอหิ โภกฺตุมุปวิศ, ยุษฺมากมฺ เอตาทฺฤศ: โกสฺติ? ");
INSERT INTO santha_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","วรญฺจ ปูรฺวฺวํ มม ขาทฺยมาสาทฺย ยาวทฺ ภุญฺเช ปิวามิ จ ตาวทฺ พทฺธกฏิ: ปริจร ปศฺจาตฺ ตฺวมปิ โภกฺษฺยเส ปาสฺยสิ จ กถามีทฺฤศีํ กึ น วกฺษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","เตน ทาเสน ปฺรโภราชฺญานุรูเป กรฺมฺมณิ กฺฤเต ปฺรภุ: กึ ตสฺมินฺ พาธิโต ชาต:? เนตฺถํ พุธฺยเต มยาฯ ");
INSERT INTO santha_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","อิตฺถํ นิรูปิเตษุ สรฺวฺวกรฺมฺมสุ กฺฤเตษุ สตฺมุ ยูยมปีทํ วากฺยํ วทถ, วยมฺ อนุปการิโณ ทาสา อสฺมาภิรฺยทฺยตฺกรฺตฺตวฺยํ ตนฺมาตฺรเมว กฺฤตํฯ ");
INSERT INTO santha_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ส ยิรูศาลมิ ยาตฺรำ กุรฺวฺวนฺ โศมิโรณฺคาลีลฺปฺรเทศมเธฺยน คจฺฉติ, ");
INSERT INTO santha_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","เอตรฺหิ กุตฺรจิทฺ คฺราเม ปฺรเวศมาเตฺร ทศกุษฺฐินสฺตํ สากฺษาตฺ กฺฤตฺวา ");
INSERT INTO santha_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ทูเร ติษฺฐนต อุจฺไจ รฺวกฺตุมาเรภิเร, เห ปฺรโภ ยีโศ ทยสฺวาสฺมานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ตต: ส ตานฺ ทฺฤษฺฏฺวา ชคาท, ยูยํ ยาชกานำ สมีเป สฺวานฺ ทรฺศยต, ตตเสฺต คจฺฉนฺโต โรคาตฺ ปริษฺกฺฤตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ตทา เตษาเมก: สฺวํ สฺวสฺถํ ทฺฤษฺฏฺวา โปฺรจฺไจรีศฺวรํ ธนฺยํ วทนฺ วฺยาฆุฏฺยายาโต ยีโศ รฺคุณานนุวทนฺ ตจฺจรณาโธภูเมา ปปาต; ");
INSERT INTO santha_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ส จาสีตฺ โศมิโรณีฯ ");
INSERT INTO santha_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ตทา ยีศุรวทตฺ, ทศชนา: กึ น ปริษฺกฺฤตา:? ตหฺยเนฺย นวชนา: กุตฺร? ");
INSERT INTO santha_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","อีศฺวรํ ธนฺยํ วทนฺตมฺ เอนํ วิเทศินํ วินา โกปฺยโนฺย น ปฺราปฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ตทา ส ตมุวาจ, ตฺวมุตฺถาย ยาหิ วิศฺวาสเสฺต ตฺวำ สฺวสฺถํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","อถ กเทศฺวรสฺย ราชตฺวํ ภวิษฺยตีติ ผิรูศิภิ: ปฺฤษฺเฏ ส ปฺรตฺยุวาจ, อีศฺวรสฺย ราชตฺวมฺ ไอศฺวรฺยฺยทรฺศเนน น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","อต เอตสฺมินฺ ปศฺย ตสฺมินฺ วา ปศฺย, อิติ วากฺยํ โลกา วกฺตุํ น ศกฺษฺยนฺติ, อีศฺวรสฺย ราชตฺวํ ยุษฺมากมฺ อนฺตเรวาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ตต: ส ศิษฺยานฺ ชคาท, ยทา ยุษฺมาภิ รฺมนุชสุตสฺย ทินเมกํ ทฺรษฺฏุมฺ วาญฺฉิษฺยเต กินฺตุ น ทรฺศิษฺยเต, อีทฺฤกฺกาล อายาติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ตทาตฺร ปศฺย วา ตตฺร ปเศฺยติ วากฺยํ โลกา วกฺษฺยนฺติ, กินฺตุ เตษำ ปศฺจาตฺ มา ยาต, มานุคจฺฉต จฯ ");
INSERT INTO santha_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ยตสฺตฑิทฺ ยถากาไศกทิศฺยุทิย ตทนฺยามปิ ทิศํ วฺยาปฺย ปฺรกาศเต ตทฺวตฺ นิชทิเน มนุชสูนุ: ปฺรกาศิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","กินฺตุ ตตฺปูรฺวฺวํ เตนาเนกานิ ทุ:ขานิ โภกฺตวฺยาเนฺยตทฺวรฺตฺตมานโลไกศฺจ โส'วชฺญาตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","โนหสฺย วิทฺยมานกาเล ยถาภวตฺ มนุษฺยสูโน: กาเลปิ ตถา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ยาวตฺกาลํ โนโห มหาโปตํ นาโรหทฺ อาปฺลาวิวารฺเยฺยตฺย สรฺวฺวํ นานาศยจฺจ ตาวตฺกาลํ ยถา โลกา อภุญฺชตาปิวนฺ วฺยวหนฺ วฺยวาหยํศฺจ; ");
INSERT INTO santha_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","อิตฺถํ โลโฏ วรฺตฺตมานกาเลปิ ยถา โลกา โภชนปานกฺรยวิกฺรยโรปณคฺฤหนิรฺมฺมาณกรฺมฺมสุ ปฺราวรฺตฺตนฺต, ");
INSERT INTO santha_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","กินฺตุ ยทา โลฏฺ สิโทโม นิรฺชคาม ตทา นภส: สคนฺธกาคฺนิวฺฤษฺฏิ รฺภูตฺวา สรฺวฺวํ วฺยนาศยตฺ ");
INSERT INTO santha_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ตทฺวนฺ มานวปุตฺรปฺรกาศทิเนปิ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ตทา ยทิ กศฺจิทฺ คฺฤโหปริ ติษฺฐติ ตรฺหิ ส คฺฤหมธฺยาตฺ กิมปิ ทฺรวฺยมาเนตุมฺ อวรุหฺย ไนตุ; ยศฺจ เกฺษเตฺร ติษฺฐติ โสปิ วฺยาฆุฏฺย นายาตุฯ ");
INSERT INTO santha_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","โลฏ: ปตฺนีํ สฺมรตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ย: ปฺราณานฺ รกฺษิตุํ เจษฺฏิษฺยเต ส ปฺราณานฺ หารยิษฺยติ ยสฺตุ ปฺราณานฺ หารยิษฺยติ เสอว ปฺราณานฺ รกฺษิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ยุษฺมานหํ วจฺมิ ตสฺยำ ราเตฺรา ศไยฺยกคตโย โรฺลกโยเรโก ธาริษฺยเต ปรสฺตฺยกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","สฺตฺริเยา ยุคปตฺ เปษณีํ วฺยาวรฺตฺตยิษฺยตสฺตโยเรกา ธาริษฺยเต ปราตฺยกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ปุรุเษา เกฺษเตฺร สฺถาสฺยตสฺตโยเรโก ธาริษฺยเต ปรสฺตฺยกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ตทา เต ปปฺรจฺฉุ:, เห ปฺรโภ กุเตฺรตฺถํ ภวิษฺยติ? ตต: ส อุวาจ, ยตฺร ศวสฺติษฺฐติ ตตฺร คฺฤธฺรา มิลนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","อปรญฺจ โลไกรกฺลานฺไต รฺนิรนฺตรํ ปฺรารฺถยิตวฺยมฺ อิตฺยาศเยน ยีศุนา ทฺฤษฺฏานฺต เอก: กถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","กุตฺรจินฺนคเร กศฺจิตฺ ปฺราฑฺวิวาก อาสีตฺ ส อีศฺวรานฺนาพิเภตฺ มานุษำศฺจ นามนฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","อถ ตตฺปุรวาสินี กาจิทฺวิธวา ตตฺสมีปเมตฺย วิวาทินา สห มม วิวาทํ ปริษฺกุรฺวฺวิติ นิเวทยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ตต: ส ปฺราฑฺวิวาก: กิยทฺทินานิ น ตทงฺคีกฺฤตวานฺ ปศฺจาจฺจิตฺเต จินฺตยามาส, ยทฺยปีศฺวรานฺน พิเภมิ มนุษฺยานปิ น มเนฺย ");
INSERT INTO santha_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ตถาเปฺยษา วิธวา มำ กฺลิศฺนาติ ตสฺมาทสฺยา วิวาทํ ปริษฺกริษฺยามิ โนเจตฺ สา สทาคตฺย มำ วฺยคฺรํ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ปศฺจาตฺ ปฺรภุรวททฺ อสาวนฺยายปฺราฑฺวิวาโก ยทาห ตตฺร มโน นิธธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","อีศฺวรสฺย เย 'ภิรุจิตโลกา ทิวานิศํ ปฺรารฺถยนฺเต ส พหุทินานิ วิลมฺพฺยาปิ เตษำ วิวาทานฺ กึ น ปริษฺกริษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ยุษฺมานหํ วทามิ ตฺวรยา ปริษฺกริษฺยติ, กินฺตุ ยทา มนุษฺยปุตฺร อาคมิษฺยติ ตทา ปฺฤถิวฺยำ กิมีทฺฤศํ วิศฺวาสํ ปฺราปฺสฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","เย สฺวานฺ ธารฺมฺมิกานฺ ชฺญาตฺวา ปรานฺ ตุจฺฉีกุรฺวฺวนฺติ เอตาทฺฤคฺภฺย:, กิยทฺภฺย อิมํ ทฺฤษฺฏานฺตํ กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","เอก: ผิรูศฺยปร: กรสญฺจายี ทฺวาวิเมา ปฺรารฺถยิตุํ มนฺทิรํ คเตาฯ ");
INSERT INTO santha_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ตโต'เสา ผิรูเศฺยกปารฺเศฺว ติษฺฐนฺ เห อีศฺวร อหมนฺยโลกวตฺ โลฐยิตานฺยายี ปารทาริกศฺจ น ภวามิ อสฺย กรสญฺจายินสฺตุลฺยศฺจ น, ตสฺมาตฺตฺวำ ธนฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","สปฺตสุ ทิเนษุ ทินทฺวยมุปวสามิ สรฺวฺวสมฺปตฺเต รฺทศมำศํ ททามิ จ, เอตตฺกถำ กถยนฺ ปฺรารฺถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","กินฺตุ ส กรสญฺจายิ ทูเร ติษฺฐนฺ สฺวรฺคํ ทฺรษฺฏุํ เนจฺฉนฺ วกฺษสิ กราฆาตํ กุรฺวฺวนฺ เห อีศฺวร ปาปิษฺฐํ มำ ทยสฺว, อิตฺถํ ปฺรารฺถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ยุษฺมานหํ วทามิ, ตโยรฺทฺวโย รฺมเธฺย เกวล: กรสญฺจายี ปุณฺยวตฺเตฺวน คณิโต นิชคฺฤหํ ชคาม, ยโต ย: กศฺจิตฺ สฺวมุนฺนมยติ ส นามยิษฺยเต กินฺตุ ย: กศฺจิตฺ สฺวํ นมยติ ส อุนฺนมยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","อถ ศิศูนำ คาตฺรสฺปรฺศารฺถํ โลกาสฺตานฺ ตสฺย สมีปมานินฺยุ: ศิษฺยาสฺตทฺ ทฺฤษฺฏฺวาเนตฺฤนฺ ตรฺชยามาสุ:, ");
INSERT INTO santha_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","กินฺตุ ยีศุสฺตานาหูย ชคาท, มนฺนิกฏมฺ อาคนฺตุํ ศิศูนฺ อนุชานีธฺวํ ตำศฺจ มา วารยต; ยต อีศฺวรราชฺยาธิการิณ เอษำ สทฺฤศา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","อหํ ยุษฺมานฺ ยถารฺถํ วทามิ, โย ชน: ศิโศ: สทฺฤโศ ภูตฺวา อีศฺวรราชฺยํ น คฺฤหฺลาติ ส เกนาปิ ปฺรกาเรณ ตตฺ ปฺรเวษฺฏุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","อปรมฺ เอโกธิปติสฺตํ ปปฺรจฺฉ, เห ปรมคุโร, อนนฺตายุษ: ปฺราปฺตเย มยา กึ กรฺตฺตวฺยํ? ");
INSERT INTO santha_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ยีศุรุวาจ, มำ กุต: ปรมํ วทสิ? อีศฺวรํ วินา โกปิ ปรโม น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ปรทารานฺ มา คจฺฉ, นรํ มา ชหิ, มา โจรย, มิถฺยาสากฺษฺยํ มา เทหิ, มาตรํ ปิตรญฺจ สํมนฺยสฺว, เอตา ยา อาชฺญา: สนฺติ ตาสฺตฺวํ ชานาสิฯ ");
INSERT INTO santha_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ตทา ส อุวาจ, พาลฺยกาลาตฺ สรฺวฺวา เอตา อาจรามิฯ ");
INSERT INTO santha_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","อิติ กถำ ศฺรุตฺวา ยีศุสฺตมวทตฺ, ตถาปิ ตไวกํ กรฺมฺม นฺยูนมาเสฺต, นิชํ สรฺวฺวสฺวํ วิกฺรีย ทริเทฺรโภฺย วิตร, ตสฺมาตฺ สฺวรฺเค ธนํ ปฺราปฺสฺยสิ; ตต อาคตฺย มมานุคามี ภวฯ ");
INSERT INTO santha_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","กินฺเตฺวตำ กถำ ศฺรุตฺวา โสธิปติ: ศุโศจ, ยตสฺตสฺย พหุธนมาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ตทา ยีศุสฺตมติโศกานฺวิตํ ทฺฤษฺฏฺวา ชคาท, ธนวตามฺ อีศฺวรราชฺยปฺรเวศ: กีทฺฤคฺ ทุษฺกร:ฯ ");
INSERT INTO santha_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","อีศฺวรราเชฺย ธนิน: ปฺรเวศาตฺ สูเจศฺฉิเทฺรณ มหางฺคสฺย คมนาคมเน สุกเรฯ ");
INSERT INTO santha_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","โศฺรตาร: ปปฺรจฺฉุสฺตรฺหิ เกน ปริตฺราณํ ปฺราปฺสฺยเต? ");
INSERT INTO santha_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ส อุกฺตวานฺ, ยนฺ มานุเษณาศกฺยํ ตทฺ อีศฺวเรณ ศกฺยํฯ ");
INSERT INTO santha_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ตทา ปิตร อุวาจ, ปศฺย วยํ สรฺวฺวสฺวํ ปริตฺยชฺย ตว ปศฺจาทฺคามิโน'ภวามฯ ");
INSERT INTO santha_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ตต: ส อุวาจ, ยุษฺมานหํ ยถารฺถํ วทามิ, อีศฺวรราชฺยารฺถํ คฺฤหํ ปิตเรา ภฺราตฺฤคณํ ชายำ สนฺตานำศฺจ ตฺยกฺตวา ");
INSERT INTO santha_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","อิห กาเล ตโต'ธิกํ ปรกาเล 'นนฺตายุศฺจ น ปฺราปฺสฺยติ โลก อีทฺฤศ: โกปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","อนนฺตรํ ส ทฺวาทศศิษฺยานาหูย พภาเษ, ปศฺยต วยํ ยิรูศาลมฺนครํ ยาม:, ตสฺมาตฺ มนุษฺยปุเตฺร ภวิษฺยทฺวาทิภิรุกฺตํ ยทสฺติ ตทนุรูปํ ตํ ปฺรติ ฆฏิษฺยเต; ");
INSERT INTO santha_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","วสฺตุตสฺตุ โส'นฺยเทศียานำ หเสฺตษุ สมรฺปยิษฺยเต, เต ตมุปหสิษฺยนฺติ, อนฺยายมาจริษฺยนฺติ ตทฺวปุษิ นิษฺฐีวํ นิกฺเษปฺสฺยนฺติ, กศาภิ: ปฺรหฺฤตฺย ตํ หนิษฺยนฺติ จ, ");
INSERT INTO santha_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","กินฺตุ ตฺฤตียทิเน ส ศฺมศานาทฺ อุตฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","เอตสฺยา: กถายา อภิปฺรายํ กิญฺจิทปิ เต โพทฺธุํ น เศกุ: เตษำ นิกเฏ'สฺปษฺฏตวาตฺ ตไสฺยตาสำ กถานามฺ อาศยํ เต ชฺญาตุํ น เศกุศฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","อถ ตสฺมินฺ ยิรีโห: ปุรสฺยานฺติกํ ปฺราปฺเต กศฺจิทนฺธ: ปถ: ปารฺศฺว อุปวิศฺย ภิกฺษามฺ อกโรตฺ ");
INSERT INTO santha_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ส โลกสมูหสฺย คมนศพฺทํ ศฺรุตฺวา ตตฺการณํ ปฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","นาสรตียยีศุรฺยาตีติ โลไกรุกฺเต ส อุจฺไจรฺวกฺตุมาเรเภ, ");
INSERT INTO santha_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","เห ทายูท: สนฺตาน ยีโศ มำ ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ตโตคฺรคามินสฺตํ เมานี ติษฺเฐติ ตรฺชยามาสุ: กินฺตุ ส ปุนารุวนฺ อุวาจ, เห ทายูท: สนฺตาน มำ ทยสฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ตทา ยีศุ: สฺถคิโต ภูตฺวา สฺวานฺติเก ตมาเนตุมฺ อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ตต: ส ตสฺยานฺติกมฺ อาคมตฺ, ตทา ส ตํ ปปฺรจฺฉ, ตฺวํ กิมิจฺฉสิ? ตฺวทรฺถมหํ กึ กริษฺยามิ? ส อุกฺตวานฺ, เห ปฺรโภ'หํ ทฺรษฺฏุํ ลไภฯ ");
INSERT INTO santha_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ตทา ยีศุรุวาจ, ทฺฤษฺฏิศกฺตึ คฺฤหาณ ตว ปฺรตฺยยสฺตฺวำ สฺวสฺถํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ตตสฺตตฺกฺษณาตฺ ตสฺย จกฺษุษี ปฺรสนฺเน; ตสฺมาตฺ ส อีศฺวรํ ธนฺยํ วทนฺ ตตฺปศฺจาทฺ ยเยา, ตทาโลกฺย สรฺเวฺว โลกา อีศฺวรํ ปฺรศํสิตุมฺ อาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ยทา ยีศุ รฺยิรีโหปุรํ ปฺรวิศฺย ตนฺมเธฺยน คจฺฉํสฺตทา ");
INSERT INTO santha_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","สกฺเกยนามา กรสญฺจายินำ ปฺรธาโน ธนวาเนโก ");
INSERT INTO santha_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ยีศุ: กีทฺฤคิติ ทฺรษฺฏุํ เจษฺฏิตวานฺ กินฺตุ ขรฺวฺวตฺวาโลฺลกสํฆมเธฺย ตทฺทรฺศนมปฺราปฺย ");
INSERT INTO santha_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","เยน ปถา ส ยาสฺยติ ตตฺปเถ'เคฺร ธาวิตฺวา ตํ ทฺรษฺฏุมฺ อุฑุมฺพรตรุมารุโรหฯ ");
INSERT INTO santha_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ปศฺจาทฺ ยีศุสฺตตฺสฺถานมฺ อิตฺวา อูรฺทฺธฺวํ วิโลกฺย ตํ ทฺฤษฺฏฺวาวาทีตฺ, เห สกฺเกย ตฺวํ ศีฆฺรมวโรห มยาทฺย ตฺวทฺเคเห วสฺตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ตต: ส ศีฆฺรมวรุหฺย สาหฺลาทํ ตํ ชคฺราหฯ ");
INSERT INTO santha_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ตทฺ ทฺฤษฺฏฺวา สรฺเวฺว วิวทมานา วกฺตุมาเรภิเร, โสติถิเตฺวน ทุษฺฏโลกคฺฤหํ คจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","กินฺตุ สกฺเกโย ทณฺฑายมาโน วกฺตุมาเรเภ, เห ปฺรโภ ปศฺย มม ยา สมฺปตฺติรสฺติ ตทรฺทฺธํ ทริเทฺรโภฺย ทเท, อปรมฺ อนฺยายํ กฺฤตฺวา กสฺมาทปิ ยทิ กทาปิ กิญฺจิตฺ มยา คฺฤหีตํ ตรฺหิ ตจฺจตุรฺคุณํ ททามิฯ ");
INSERT INTO santha_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ตทา ยีศุสฺตมุกฺตวานฺ อยมปิ อิพฺราหีม: สนฺตาโน'ต: การณาทฺ อทฺยาสฺย คฺฤเห ตฺราณมุปสฺถิตํฯ ");
INSERT INTO santha_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ยทฺ หาริตํ ตตฺ มฺฤคยิตุํ รกฺษิตุญฺจ มนุษฺยปุตฺร อาคตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","อถ ส ยิรูศาลม: สมีป อุปาติษฺฐทฺ อีศฺวรราชตฺวสฺยานุษฺฐานํ ตไทว ภวิษฺยตีติ โลไกรนฺวภูยต, ตสฺมาตฺ ส โศฺรตฺฤภฺย: ปุนรฺทฺฤษฺฏานฺตกถามฺ อุตฺถาปฺย กถยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","โกปิ มหาโลฺลโก นิชารฺถํ ราชตฺวปทํ คฺฤหีตฺวา ปุนราคนฺตุํ ทูรเทศํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ยาตฺรากาเล นิชานฺ ทศทาสานฺ อาหูย ทศสฺวรฺณมุทฺรา ทตฺตฺวา มมาคมนปรฺยฺยนฺตํ วาณิชฺยํ กุรุเตตฺยาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","กินฺตุ ตสฺย ปฺรชาสฺตมวชฺญาย มนุษฺยเมนมฺ อสฺมากมุปริ ราชตฺวํ น การยิวฺยาม อิมำ วารฺตฺตำ ตนฺนิกเฏ เปฺรรยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","อถ ส ราชตฺวปทํ ปฺราปฺยาคตวานฺ เอไกโก ชโน พาณิเชฺยน กึ ลพฺธวานฺ อิติ ชฺญาตุํ เยษุ ทาเสษุ มุทฺรา อรฺปยตฺ ตานฺ อาหูยาเนตุมฺ อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ตทา ปฺรถม อาคตฺย กถิตวานฺ, เห ปฺรโภ ตว ตไยกยา มุทฺรยา ทศมุทฺรา ลพฺธา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ตต: ส อุวาจ ตฺวมุตฺตโม ทาส: สฺวลฺเปน วิศฺวาโสฺย ชาต อิต: การณาตฺ ตฺวํ ทศนคราณามฺ อธิโป ภวฯ ");
INSERT INTO santha_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ทฺวิตีย อาคตฺย กถิตวานฺ, เห ปฺรโภ ตไวกยา มุทฺรยา ปญฺจมุทฺรา ลพฺธา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ตต: ส อุวาจ, ตฺวํ ปญฺจานำ นคราณามธิปติ รฺภวฯ ");
INSERT INTO santha_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ตโตนฺย อาคตฺย กถยามาส, เห ปฺรโภ ปศฺย ตว ยา มุทฺรา อหํ วสฺเตฺร พทฺธฺวาสฺถาปยํ เสยํฯ ");
INSERT INTO santha_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ตฺวํ กฺฤปโณ ยนฺนาสฺถาปยสฺตทปิ คฺฤหฺลาสิ, ยนฺนาวปสฺตเทว จ ฉินตฺสิ ตโตหํ ตฺวตฺโต ภีต:ฯ ");
INSERT INTO santha_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ตทา ส ชคาท, เร ทุษฺฏทาส ตว วาเกฺยน ตฺวำ โทษิณํ กริษฺยามิ, ยทหํ นาสฺถาปยํ ตเทว คฺฤหฺลามิ, ยทหํ นาวปญฺจ ตเทว ฉินทฺมิ, เอตาทฺฤศ: กฺฤปโณหมิติ ยทิ ตฺวํ ชานาสิ, ");
INSERT INTO santha_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ตรฺหิ มม มุทฺรา พณิชำ นิกเฏ กุโต นาสฺถาปย:? ตยา กฺฤเต'หมฺ อาคตฺย กุสีเทน สารฺทฺธํ นิชมุทฺรา อปฺราปฺสฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ปศฺจาตฺ ส สมีปสฺถานฺ ชนานฺ อาชฺญาปยตฺ อสฺมาตฺ มุทฺรา อานีย ยสฺย ทศมุทฺรา: สนฺติ ตไสฺม ทตฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","เต โปฺรจุ: ปฺรโภ'สฺย ทศมุทฺรา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ยุษฺมานหํ วทามิ ยสฺยาศฺรเย วทฺธเต 'ธิกํ ตไสฺม ทายิษฺยเต, กินฺตุ ยสฺยาศฺรเย น วรฺทฺธเต ตสฺย ยทฺยทสฺติ ตทปิ ตสฺมานฺ นายิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","กินฺตุ มมาธิปติตฺวสฺย วศเตฺว สฺถาตุมฺ อสมฺมนฺยมานา เย มม ริปวสฺตานานีย มม สมกฺษํ สํหรตฯ ");
INSERT INTO santha_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","อิตฺยุปเทศกถำ กถยิตฺวา โสคฺรค: สนฺ ยิรูศาลมปุรํ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ตโต ไพตฺผคีไพถนียาคฺรามโย: สมีเป ไชตุนาเทฺรรนฺติกมฺ อิตฺวา ศิษฺยทฺวยมฺ อิตฺยุกฺตฺวา เปฺรษยามาส, ");
INSERT INTO santha_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ยุวามมุํ สมฺมุขสฺถคฺรามํ ปฺรวิไศฺยว ยํ โกปิ มานุษ: กทาปิ นาโรหตฺ ตํ ครฺทฺทภศาวกํ พทฺธํ ทฺรกฺษฺยถสฺตํ โมจยิตฺวานยตํฯ ");
INSERT INTO santha_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ตตฺร กุโต โมจยถ:? อิติ เจตฺ โกปิ วกฺษฺยติ ตรฺหิ วกฺษฺยถ: ปฺรเภाรตฺร ปฺรโยชนมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ตทา เตา ปฺรริเตา คตฺวา ตตฺกถาाนุสาเรณ สรฺวฺวํ ปฺราปฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ครฺทภศาวกโมจนกาเล ตตฺวามิน อูจุ:, ครฺทภศาวกํ กุโต โมจยถ:? ");
INSERT INTO santha_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ตาวูจตุ: ปฺรโภรตฺร ปฺรโยชนมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ปศฺจาตฺ เตา ตํ ครฺทภศาวกํ ยีโศรนฺติกมานีย ตตฺปฺฤษฺเฐ นิชวสนานิ ปาตยิตฺวา ตทุปริ ยีศุมาโรหยามาสตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","อถ ยาตฺรากาเล โลกา: ปถิ สฺววสฺตฺราณิ ปาตยิตุมฺ อาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","อปรํ ไชตุนาเทฺรรุปตฺยกามฺ อิตฺวา ศิษฺยสํฆ: ปูรฺวฺวทฺฤษฺฏานิ มหากรฺมฺมาณิ สฺมฺฤตฺวา, ");
INSERT INTO santha_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","โย ราชา ปฺรโภ รฺนามฺนายาติ ส ธนฺย: สฺวรฺเค กุศลํ สรฺโวฺวจฺเจ ชยธฺวนิ รฺภวตุ, กถาเมตำ กถยิตฺวา สานนฺทมฺ อุไจรีศฺวรํ ธนฺยํ วกฺตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ตทา โลการณฺยมธฺยสฺถา: กิยนฺต: ผิรูศินสฺตตฺ ศฺรุตฺวา ยีศุํ โปฺรจุ:, เห อุปเทศก สฺวศิษฺยานฺ ตรฺชยฯ ");
INSERT INTO santha_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ส อุวาจ, ยุษฺมานหํ วทามิ ยทฺยมี นีรวาสฺติษฺฐนฺติ ตรฺหิ ปาษาณา อุไจ: กถา: กถยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ปศฺจาตฺ ตตฺปุรานฺติกเมตฺย ตทวโลกฺย สาศฺรุปาตํ ชคาท, ");
INSERT INTO santha_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","หา หา เจตฺ ตฺวมเคฺร'ชฺญาสฺยถา:, ตวาสฺมินฺเนว ทิเน วา ยทิ สฺวมงฺคลมฺ อุปาลปฺสฺยถา:, ตรฺหฺยุตฺตมมฺ อภวิษฺยตฺ, กินฺตุ กฺษเณสฺมินฺ ตตฺตว ทฺฤษฺเฏรโคจรมฺ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ตฺวํ สฺวตฺราณกาเล น มโน นฺยธตฺถา อิติ เหโต รฺยตฺกาเล ตว ริปวสฺตฺวำ จตุรฺทิกฺษุ ปฺราจีเรณ เวษฺฏยิตฺวา โรตฺสฺยนฺติ ");
INSERT INTO santha_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","พาลไก: สารฺทฺธํ ภูมิสาตฺ กริษฺยนฺติ จ ตฺวนฺมเธฺย ปาษาไณโกปิ ปาษาโณปริ น สฺถาสฺยติ จ, กาล อีทฺฤศ อุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","อถ มเธฺยมนฺทิรํ ปฺรวิศฺย ตตฺรตฺยานฺ กฺรยิวิกฺรยิโณ พหิษฺกุรฺวฺวนฺ ");
INSERT INTO santha_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","อวทตฺ มทฺคฺฤหํ ปฺรารฺถนาคฺฤหมิติ ลิปิราเสฺต กินฺตุ ยูยํ ตเทว ไจราณำ คหฺวรํ กุรุถฯ ");
INSERT INTO santha_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ปศฺจาตฺ ส ปฺรตฺยหํ มเธฺยมนฺทิรมฺ อุปทิเทศ; ตต: ปฺรธานยาชกา อธฺยาปกา: ปฺราจีนาศฺจ ตํ นาศยิตุํ จิเจษฺฏิเร; ");
INSERT INTO santha_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","กินฺตุ ตทุปเทเศ สรฺเวฺว โลกา นิวิษฺฏจิตฺตา: สฺถิตาสฺตสฺมาตฺ เต ตตฺกรฺตฺตุํ นาวกาศํ ปฺราปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","อไถกทา ยีศุ รฺมนิทเร สุสํวาทํ ปฺรจารยนฺ โลกานุปทิศติ, เอตรฺหิ ปฺรธานยาชกา อธฺยาปกา: ปฺราญฺจศฺจ ตนฺนิกฏมาคตฺย ปปฺรจฺฉุ: ");
INSERT INTO santha_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","กยาชฺญยา ตฺวํ กรฺมฺมาเณฺยตานิ กโรษิ? โก วา ตฺวามาชฺญาปยตฺ? ตทสฺมานฺ วทฯ ");
INSERT INTO santha_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ส ปฺรตฺยุวาจ, ตรฺหิ ยุษฺมานปิ กถาเมกำ ปฺฤจฺฉามิ ตโสฺยตฺตรํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","โยหโน มชฺชนมฺ อีศฺวรสฺย มานุษาณำ วาชฺญาโต ชาตํ? ");
INSERT INTO santha_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ตตเสฺต มิโถ วิวิจฺย ชคทุ:, ยทีศฺวรสฺย วทามสฺตรฺหิ ตํ กุโต น ปฺรไตฺยต ส อิติ วกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ยทิ มนุษฺยเสฺยติ วทามสฺตรฺหิ สรฺเวฺว โลกา อสฺมานฺ ปาษาไณ รฺหนิษฺยนฺติ ยโต โยหนฺ ภวิษฺยทฺวาทีติ สรฺเวฺว ทฺฤฒํ ชานนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","อเตอว เต ปฺรตฺยูจุ: กสฺยาชฺญยา ชาตมฺ อิติ วกฺตุํ น ศกฺนุม:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ตทา ยีศุรวทตฺ ตรฺหิ กยาชฺญยา กรฺมฺมาเณฺยตาติ กโรมีติ จ ยุษฺมานฺ น วกฺษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","อถ โลกานำ สากฺษาตฺ ส อิมำ ทฺฤษฺฏานฺตกถำ วกฺตุมาเรเภ, กศฺจิทฺ ทฺรากฺษากฺเษตฺรํ กฺฤตฺวา ตตฺ เกฺษตฺรํ กฺฤษีวลานำ หเสฺตษุ สมรฺปฺย พหุกาลารฺถํ ทูรเทศํ ชคามฯ ");
INSERT INTO santha_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","อถ ผลกาเล ผลานิ คฺรหีตุ กฺฤษีวลานำ สมีเป ทาสํ ปฺราหิโณตฺ กินฺตุ กฺฤษีวลาสฺตํ ปฺรหฺฤตฺย ริกฺตหสฺตํ วิสสรฺชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ตต: โสธิปติ: ปุนรนฺยํ ทาสํ เปฺรษยามาส, เต ตมปิ ปฺรหฺฤตฺย กุวฺยวหฺฤตฺย ริกฺตหสฺตํ วิสสฺฤชุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ตต: ส ตฺฤตียวารมฺ อนฺยํ ปฺราหิโณตฺ เต ตมปิ กฺษตางฺคํ กฺฤตฺวา พหิ รฺนิจิกฺษิปุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ตทา เกฺษตฺรปติ รฺวิจารยามาส, มเมทานีํ กึ กรฺตฺตวฺยํ? มม ปฺริเย ปุเตฺร ปฺรหิเต เต ตมวศฺยํ ทฺฤษฺฏฺวา สมาทริษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","กินฺตุ กฺฤษีวลาสฺตํ นิรีกฺษฺย ปรสฺปรํ วิวิจฺย โปฺรจุ:, อยมุตฺตราธิการี อาคจฺฉไตนํ หนฺมสฺตโตธิกาโรสฺมากํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ตตเสฺต ตํ เกฺษตฺราทฺ พหิ รฺนิปาตฺย ชฆฺนุสฺตสฺมาตฺ ส เกฺษตฺรปติสฺตานฺ ปฺรติ กึ กริษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ส อาคตฺย ตานฺ กฺฤษีวลานฺ หตฺวา ปเรษำ หเสฺตษุ ตตฺกฺเษตฺรํ สมรฺปยิษฺยติ; อิติ กถำ ศฺรุตฺวา เต 'วทนฺ เอตาทฺฤศี ฆฏนา น ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","กินฺตุ ยีศุสฺตานวโลกฺย ชคาท, ตรฺหิ, สฺถปตย: กริษฺยนฺติ คฺราวาณํ ยนฺตุ ตุจฺฉกํฯ ปฺรธานปฺรสฺตร: โกเณ ส เอว หิ ภวิษฺยติฯ เอตสฺย ศาสฺตฺรียวจนสฺย กึ ตาตฺปรฺยฺยํ? ");
INSERT INTO santha_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","อปรํ ตตฺปาษาโณปริ ย: ปติษฺยติ ส ภํกฺษฺยเต กินฺตุ ยโสฺยปริ ส ปาษาณ: ปติษฺยติ ส เตน ธูลิวจฺ จูรฺณีภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","โสสฺมากํ วิรุทฺธํ ทฺฤษฺฏานฺตมิมํ กถิตวานฺ อิติ ชฺญาตฺวา ปฺรธานยาชกา อธฺยาปกาศฺจ ตไทว ตํ ธรฺตุํ ววาญฺฉุ: กินฺตุ โลเกโภฺย พิภฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","อเตอว ตํ ปฺรติ สตรฺกา: สนฺต: กถํ ตทฺวากฺยโทษํ ธฺฤตฺวา ตํ เทศาธิปสฺย สาธุเวศธาริณศฺจรานฺ ตสฺย สมีเป เปฺรษยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ตทา เต ตํ ปปฺรจฺฉุ:, เห อุปเทศก ภวานฺ ยถารฺถํ กถยนฺ อุปทิศติ, กมปฺยนเปกฺษฺย สตฺยเตฺวไนศฺวรํ มารฺคมุปทิศติ, วยเมตชฺชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ไกสรราชาย กโรสฺมาภิ เรฺทโย น วา? ");
INSERT INTO santha_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ส เตษำ วญฺจนํ ชฺญาตฺวาวทตฺ กุโต มำ ปรีกฺษเธฺว? มำ มุทฺราเมกํ ทรฺศยตฯ ");
INSERT INTO santha_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","อิห ลิขิตา มูรฺติริยํ นาม จ กสฺย? เต'วทนฺ ไกสรสฺยฯ ");
INSERT INTO santha_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ตทา ส อุวาจ, ตรฺหิ ไกสรสฺย ทฺรวฺยํ ไกสราย ทตฺต; อีศฺวรสฺย ตุ ทฺรวฺยมีศฺวราย ทตฺตฯ ");
INSERT INTO santha_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ตสฺมาโลฺลกานำ สากฺษาตฺ ตตฺกถายา: กมปิ โทษํ ธรฺตุมปฺราปฺย เต ตโสฺยตฺตราทฺ อาศฺจรฺยฺยํ มนฺยมานา เมานินสฺตสฺถุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","อปรญฺจ ศฺมศานาทุตฺถานานงฺคีการิณำ สิทูกินำ กิยนฺโต ชนา อาคตฺย ตํ ปปฺรจฺฉุ:, ");
INSERT INTO santha_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","เห อุปเทศก ศาสฺเตฺร มูสา อสฺมานฺ ปฺรตีติ ลิเลข ยสฺย ภฺราตา ภารฺยฺยายำ สตฺยำ นิ:สนฺตาโน มฺริยเต ส ตชฺชายำ วิวหฺย ตทฺวํศมฺ อุตฺปาทยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ตถาจ เกจิตฺ สปฺต ภฺราตร อาสนฺ เตษำ เชฺยษฺโฐ ภฺราตา วิวหฺย นิรปตฺย: ปฺราณานฺ ชเหาฯ ");
INSERT INTO santha_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","อถ ทฺวิตียสฺตสฺย ชายำ วิวหฺย นิรปตฺย: สนฺ มมารฯ ตฺฤตียศฺจ ตาเมว วฺยุวาห; ");
INSERT INTO santha_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","อิตฺถํ สปฺต ภฺราตรสฺตาเมว วิวหฺย นิรปตฺยา: สนฺโต มมฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","เศเษ สา สฺตฺรี จ มมารฯ ");
INSERT INTO santha_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","อเตอว ศฺมศานาทุตฺถานกาเล เตษำ สปฺตชนานำ กสฺย สา ภารฺยฺยา ภวิษฺยติ? ยต: สา เตษำ สปฺตานาเมว ภารฺยฺยาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ตทา ยีศุ: ปฺรตฺยุวาจ, เอตสฺย ชคโต โลกา วิวหนฺติ วาคฺทตฺตาศฺจ ภวนฺติ ");
INSERT INTO santha_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","กินฺตุ เย ตชฺชคตฺปฺราปฺติโยคฺยเตฺวน คณิตำ ภวิษฺยนฺติ ศฺมศานาจฺโจตฺถาสฺยนฺติ เต น วิวหนฺติ วาคฺทตฺตาศฺจ น ภวนฺติ, ");
INSERT INTO santha_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","เต ปุน รฺน มฺริยนฺเต กินฺตุ ศฺมศานาทุตฺถาปิตา: สนฺต อีศฺวรสฺย สนฺตานา: สฺวรฺคียทูตานำ สทฺฤศาศฺจ ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","อธิกนฺตุ มูสา: สฺตมฺโพปาขฺยาเน ปรเมศฺวร อีพฺราหีม อีศฺวร อิสฺหาก อีศฺวโร ยากูพศฺเจศฺวร อิตฺยุกฺตฺวา มฺฤตานำ ศฺมศานาทฺ อุตฺถานสฺย ปฺรมาณํ ลิเลขฯ ");
INSERT INTO santha_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","อเตอว ย อีศฺวร: ส มฺฤตานำ ปฺรภุ รฺน กินฺตุ ชีวตาเมว ปฺรภุ:, ตนฺนิกเฏ สรฺเวฺว ชีวนฺต: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","อิติ ศฺรุตฺวา กิยนฺโตธฺยาปกา อูจุ:, เห อุปเทศก ภวานฺ ภทฺรํ ปฺรตฺยุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","อิต: ปรํ ตํ กิมปิ ปฺรษฺฏํ เตษำ ปฺรคลฺภตา นาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ปศฺจาตฺ ส ตานฺ อุวาจ, ย: ขฺรีษฺฏ: ส ทายูท: สนฺตาน เอตำ กถำ โลกา: กถํ กถยนฺติ? ");
INSERT INTO santha_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ยต: มม ปฺรภุมิทํ วากฺยมวทตฺ ปรเมศฺวร:ฯ ตว ศตฺรูนหํ ยาวตฺ ปาทปีฐํ กโรมิ นฯ ตาวตฺ กาลํ มทีเย ตฺวํ ทกฺษปารฺศฺว อุปาวิศฯ ");
INSERT INTO santha_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","อิติ กถำ ทายูทฺ สฺวยํ คีตคฺรนฺเถ'วทตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","อเตอว ยทิ ทายูทฺ ตํ ปฺรภุํ วทติ, ตรฺหิ ส กถํ ตสฺย สนฺตาโน ภวติ? ");
INSERT INTO santha_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ปศฺจาทฺ ยีศุ: สรฺวฺวชนานำ กรฺณโคจเร ศิษฺยานุวาจ, ");
INSERT INTO santha_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","เย'ธฺยาปกา ทีรฺฆปริจฺฉทํ ปริธาย ภฺรมนฺติ, หฏฺฏาปณโย รฺนมสฺกาเร ภชนเคหสฺย โปฺรจฺจาสเน โภชนคฺฤหสฺย ปฺรธานสฺถาเน จ ปฺรียนฺเต ");
INSERT INTO santha_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","วิธวานำ สรฺวฺวสฺวํ คฺรสิตฺวา ฉเลน ทีรฺฆกาลํ ปฺรารฺถยนฺเต จ เตษุ สาวธานา ภวต, เตษามุคฺรทณฺโฑ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","อถ ธนิโลกา ภาณฺฑาคาเร ธนํ นิกฺษิปนฺติ ส ตเทว ปศฺยติ, ");
INSERT INTO santha_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","เอตรฺหิ กาจิทฺทีนา วิธวา ปณทฺวยํ นิกฺษิปติ ตทฺ ททรฺศฯ ");
INSERT INTO santha_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ตโต ยีศุรุวาจ ยุษฺมานหํ ยถารฺถํ วทามิ, ทริเทฺรยํ วิธวา สรฺเวฺวโภฺยธิกํ นฺยกฺเษปฺสีตฺ, ");
INSERT INTO santha_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ยโตเนฺย สฺวปฺราชฺยธเนภฺย อีศฺวราย กิญฺจิตฺ นฺยกฺเษปฺสุ:, กินฺตุ ทริเทฺรยํ วิธวา ทินยาปนารฺถํ สฺวสฺย ยตฺ กิญฺจิตฺ สฺถิตํ ตตฺ สรฺวฺวํ นฺยกฺเษปฺสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","อปรญฺจ อุตฺตมปฺรสฺตไรรุตฺสฺฤษฺฏไวฺยศฺจ มนฺทิรํ สุโศภเตตรำ ไกศฺจิทิตฺยุกฺเต ส ปฺรตฺยุวาจ ");
INSERT INTO santha_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ยูยํ ยทิทํ นิจยนํ ปศฺยถ, อสฺย ปาษาไณโกปฺยนฺยปาษาโณปริ น สฺถาสฺยติ, สรฺเวฺว ภูสาทฺภวิษฺยนฺติ กาโลยมายาติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ตทา เต ปปฺรจฺฉุ:, เห คุโร ฆฏเนทฺฤศี กทา ภวิษฺยติ? ฆฏนายา เอตสฺยสศฺจิหฺนํ วา กึ ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ตทา ส ชคาท, สาวธานา ภวต ยถา ยุษฺมากํ ภฺรมํ โกปิ น ชนยติ, ขีษฺโฏหมิตฺยุกฺตฺวา มม นามฺรา พหว อุปสฺถาสฺยนฺติ ส กาล: ปฺราเยโณปสฺถิต:, เตษำ ปศฺจานฺมา คจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ยุทฺธโสฺยปปฺลวสฺย จ วารฺตฺตำ ศฺรุตฺวา มา ศงฺกธฺวํ, ยต: ปฺรถมมฺ เอตา ฆฏนา อวศฺยํ ภวิษฺยนฺติ กินฺตุ นาปาเต ยุคานฺโต ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","อปรญฺจ กถยามาส, ตทา เทศสฺย วิปกฺษเตฺวน เทโศ ราชฺยสฺย วิปกฺษเตฺวน ราชฺยมฺ อุตฺถาสฺยติ, ");
INSERT INTO santha_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","นานาสฺถาเนษุ มหาภูกมฺโป ทุรฺภิกฺษํ มารี จ ภวิษฺยนฺติ, ตถา โวฺยมมณฺฑลสฺย ภยงฺกรทรฺศนานฺยศฺจรฺยฺยลกฺษณานิ จ ปฺรกาศยิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","กินฺตุ สรฺวฺวาสาเมตาสำ ฆฏนานำ ปูรฺวฺวํ โลกา ยุษฺมานฺ ธฺฤตฺวา ตาฑยิษฺยนฺติ, ภชนาลเย การายาญฺจ สมรฺปยิษฺยนฺติ มม นามการณาทฺ ยุษฺมานฺ ภูปานำ ศาสกานาญฺจ สมฺมุขํ เนษฺยนฺติ จฯ ");
INSERT INTO santha_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","สากฺษฺยารฺถมฺ เอตานิ ยุษฺมานฺ ปฺรติ ฆฏิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ตทา กิมุตฺตรํ วกฺตวฺยมฺ เอตตฺ น จินฺตยิษฺยาม อิติ มน:สุ นิศฺจิตนุตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","วิปกฺษา ยสฺมาตฺ กิมปฺยุตฺตรมฺ อาปตฺติญฺจ กรฺตฺตุํ น ศกฺษฺยนฺติ ตาทฺฤศํ วากฺปฏุตฺวํ ชฺญานญฺจ ยุษฺมภฺยํ ทาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","กิญฺจ ยูยํ ปิตฺรา มาตฺรา ภฺราตฺรา พนฺธุนา ชฺญาตฺยา กุฏุมฺเพน จ ปรกเรษุ สมรฺปยิษฺยเธฺว; ตตเสฺต ยุษฺมากํ กญฺจน กญฺจน ฆาตยิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","มม นามฺน: การณาตฺ สรฺไวฺว รฺมนุไษฺย รฺยูยมฺ ฤตียิษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","กินฺตุ ยุษฺมากํ ศิร:เกไศโกปิ น วินํกฺษฺยติ, ");
INSERT INTO santha_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ตสฺมาเทว ไธรฺยฺยมวลมฺพฺย สฺวสฺวปฺราณานฺ รกฺษตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","อปรญฺจ ยิรูศาลมฺปุรํ ไสนฺยเวษฺฏิตํ วิโลกฺย ตโสฺยจฺฉินฺนตายา: สมย: สมีป อิตฺยวคมิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ตทา ยิหูทาเทศสฺถา โลกา: ปรฺวฺวตํ ปลายนฺตำ, เย จ นคเร ติษฺฐนฺติ เต เทศานฺตรํ ปลายนฺตา, เย จ คฺราเม ติษฺฐนฺติ เต นครํ น ปฺรวิศนฺตุ, ");
INSERT INTO santha_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ยตสฺตทา สมุจิตทณฺฑนาย ธรฺมฺมปุสฺตเก ยานิ สรฺวฺวาณิ ลิขิตานิ ตานิ สผลานิ ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","กินฺตุ ยา ยาสฺตทา ครฺภวตฺย: สฺตนฺยทาวฺยศฺจ ตามำ ทุรฺคติ รฺภวิษฺยติ, ยต เอตาโลฺลกานฺ ปฺรติ โกโป เทเศ จ วิษมทุรฺคติ รฺฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","วสฺตุตสฺตุ เต ขงฺคธารปริวฺวงฺคํ ลปฺสฺยนฺเต พทฺธา: สนฺต: สรฺวฺวเทเศษุ นายิษฺยนฺเต จ กิญฺจานฺยเทศียานำ สมโยปสฺถิติปรฺยฺยนฺตํ ยิรูศาลมฺปุรํ ไต: ปทตไล รฺทลยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","สูรฺยฺยจนฺทฺรนกฺษเตฺรษุ ลกฺษณาทิ ภวิษฺยนฺติ, ภุวิ สรฺวฺวเทศียานำ ทุ:ขํ จินฺตา จ สินฺเธา วีจีนำ ตรฺชนํ ครฺชนญฺจ ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ภูเภา ภาวิฆฏนำ จินฺตยิตฺวา มนุชา ภิยามฺฤตกลฺปา ภวิษฺยนฺติ, ยโต โวฺยมมณฺฑเล เตชสฺวิโน โทลายมานา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ตทา ปรากฺรเมณา มหาเตชสา จ เมฆารูฒํ มนุษฺยปุตฺรมฺ อายานฺตํ ทฺรกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","กินฺเตฺวตาสำ ฆฏนานามารมฺเภ สติ ยูยํ มสฺตกานฺยุตฺโตลฺย อูรฺทธฺวํ ทฺรกฺษฺยถ, ยโต ยุษฺมากํ มุกฺเต: กาล: สวิโธ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ตตเสฺตไนตทฺฤษฺฏานฺตกถา กถิตา, ปศฺยต อุฑุมฺพราทิวฺฤกฺษาณำ ");
INSERT INTO santha_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","นวีนปตฺราณิ ชาตานีติ ทฺฤษฺฏฺวา นิทาวกาล อุปสฺถิต อิติ ยถา ยูยํ ชฺญาตุํ ศกฺนุถ, ");
INSERT INTO santha_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ตถา สรฺวฺวาสามาสำ ฆฏนานามฺ อารมฺเภ ทฺฤษฺเฏ สตีศฺวรสฺย ราชตฺวํ นิกฏมฺ อิตฺยปิ ชฺญาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ยุษฺมานหํ ยถารฺถํ วทามิ, วิทฺยมานโลกานาเมษำ คมนาตฺ ปูรฺวฺวมฺ เอตานิ ฆฏิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","นโภภุโวโรฺลโป ภวิษฺยติ มม วากฺ ตุ กทาปิ ลุปฺตา น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","อเตอว วิษมาศเนน ปาเนน จ สำมาริกจินฺตาภิศฺจ ยุษฺมากํ จิตฺเตษุ มตฺเตษุ ตทฺทินมฺ อกสฺมาทฺ ยุษฺมานฺ ปฺรติ ยถา โนปติษฺฐติ ตทรฺถํ เสฺวษุ สาวธานาสฺติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ปฺฤถิวีสฺถสรฺวฺวโลกานฺ ปฺรติ ตทฺทินมฺ อุนฺมาถ อิว อุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ยถา ยูยมฺ เอตทฺภาวิฆฏนา อุตฺตรฺตฺตุํ มนุชสุตสฺย สมฺมุเข สํสฺถาตุญฺจ โยคฺยา ภวถ การณาทสฺมาตฺ สาวธานา: สนฺโต นิรนฺตรํ ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","อปรญฺจ ส ทิวา มนฺทิร อุปทิศฺย ราไจ ไชตุนาทฺรึ คตฺวาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ตต: ปฺรตฺยูเษ ลากาสฺตตฺกถำ โศฺรตุํ มนฺทิเร ตทนฺติกมฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","อปรญฺจ กิณฺวศูนฺยปูโปตฺสวสฺย กาล อุปสฺถิเต ");
INSERT INTO santha_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ปฺรธานยาชกา อธฺยายกาศฺจ ยถา ตํ หนฺตุํ ศกฺนุวนฺติ ตโถปายามฺ อเจษฺฏนฺต กินฺตุ โลเกโภฺย พิภฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","เอตสฺตินฺ สมเย ทฺวาทศศิเษฺยษุ คณิต อีษฺกริโยตียรูฒิมานฺ โย ยิหูทาสฺตสฺยานฺต:กรณํ ไศตานาศฺริตตฺวาตฺ ");
INSERT INTO santha_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ส คตฺวา ยถา ยีศุํ เตษำ กเรษุ สมรฺปยิตุํ ศกฺโนติ ตถา มนฺตฺรณำ ปฺรธานยาชไก: เสนาปติภิศฺจ สห จการฯ ");
INSERT INTO santha_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","เตน เต ตุษฺฏาสฺตไสฺม มุทฺรำ ทาตุํ ปณํ จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ตต: โสงฺคีกฺฤตฺย ยถา โลกานามโคจเร ตํ ปรกเรษุ สมรฺปยิตุํ ศกฺโนติ ตถาวกาศํ เจษฺฏิตุมาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","อถ กิณฺวศูนฺยปูโปตฺมวทิเน, อรฺถาตฺ ยสฺมินฺ ทิเน นิสฺตาโรตฺสวสฺย เมโษ หนฺตวฺยสฺตสฺมินฺ ทิเน ");
INSERT INTO santha_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ยีศุ: ปิตรํ โยหนญฺจาหูย ชคาท, ยุวำ คตฺวาสฺมากํ โภชนารฺถํ นิสฺตาโรตฺสวสฺย ทฺรวฺยาณฺยาสาทยตํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ตทา เตา ปปฺรจฺฉตุ: กุจาสาทยาโว ภวต: เกจฺฉา? ");
INSERT INTO santha_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ตทา โสวาทีตฺ, นคเร ปฺรวิษฺเฏ กศฺจิชฺชลกุมฺภมาทาย ยุวำ สากฺษาตฺ กริษฺยติ ส ยนฺนิเวศนํ ปฺรวิศติ ยุวามปิ ตนฺนิเวศนํ ตตฺปศฺจาทิตฺวา นิเวศนปติมฺ อิติ วากฺยํ วทตํ, ");
INSERT INTO santha_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ยตฺราหํ นิสฺตาโรตฺสวสฺย โภชฺยํ ศิไษฺย: สารฺทฺธํ โภกฺตุํ ศกฺโนมิ สาติถิศาลาा กุตฺร? กถามิมำ ปฺรภุสฺตฺวำ ปฺฤจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ตต: ส ชโน ทฺวิตียปฺรโกษฺฐียมฺ เอกํ ศสฺตํ โกษฺฐํ ทรฺศยิษฺยติ ตตฺร โภชฺยมาสาทยตํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ตตเสฺตา คตฺวา ตทฺวากฺยานุสาเรณ สรฺวฺวํ ทฺฤษฺทฺวา ตตฺร นิสฺตาโรตฺสวียํ โภชฺยมาสาทยามาสตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","อถ กาล อุปสฺถิเต ยีศุ รฺทฺวาทศภิ: เปฺรริไต: สห โภกฺตุมุปวิศฺย กถิตวานฺ ");
INSERT INTO santha_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","มม ทุ:ขโภคาตฺ ปูรฺวฺวํ ยุภาภิ: สห นิสฺตาโรตฺสวไสฺยตสฺย โภชฺยํ โภกฺตุํ มยาติวาญฺฉา กฺฤตาฯ ");
INSERT INTO santha_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ยุษฺมานฺ วทามิ, ยาวตฺกาลมฺ อีศฺวรราเชฺย โภชนํ น กริเษฺย ตาวตฺกาลมฺ อิทํ น โภกฺเษฺยฯ ");
INSERT INTO santha_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ตทา ส ปานปาตฺรมาทาย อีศฺวรสฺย คุณานฺ กีรฺตฺตยิตฺวา เตโภฺย ทตฺวาวทตฺ, อิทํ คฺฤหฺลีต ยูยํ วิภชฺย ปิวตฯ ");
INSERT INTO santha_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ยุษฺมานฺ วทามิ ยาวตฺกาลมฺ อีศฺวรราชตฺวสฺย สํสฺถาปนํ น ภวติ ตาวทฺ ทฺรากฺษาผลรสํ น ปาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ตต: ปูปํ คฺฤหีตฺวา อีศฺวรคุณานฺ กีรฺตฺตยิตฺวา ภงฺกฺตา เตโภฺย ทตฺวาวทตฺ, ยุษฺมทรฺถํ สมรฺปิตํ ยนฺมม วปุสฺตทิทํ, เอตตฺ กรฺมฺม มม สฺมรณารฺถํ กุรุธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","อถ โภชนานฺเต ตาทฺฤศํ ปาตฺรํ คฺฤหีตฺวาวทตฺ, ยุษฺมตฺกฺฤเต ปาติตํ ยนฺมม รกฺตํ เตน นิรฺณีตนวนิยมรูปํ ปานปาตฺรมิทํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ปศฺยต โย มำ ปรกเรษุ สมรฺปยิษฺยติ ส มยา สห โภชนาสน อุปวิศติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ยถา นิรูปิตมาเสฺต ตทนุสาเรณา มนุษฺยปุुตฺรสฺย คติ รฺภวิษฺยติ กินฺตุ ยสฺตํ ปรกเรษุ สมรฺปยิษฺยติ ตสฺย สนฺตาโป ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ตทา เตษำ โก ชน เอตตฺ กรฺมฺม กริษฺยติ ตตฺ เต ปรสฺปรํ ปฺรษฺฏุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","อปรํ เตษำ โก ชน: เศฺรษฺฐเตฺวน คณยิษฺยเต, อตฺรารฺเถ เตษำ วิวาโทภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","อสฺมาตฺ การณาตฺ โสวทตฺ, อนฺยเทศียานำ ราชาน: ปฺรชานามุปริ ปฺรภุตฺวํ กุรฺวฺวนฺติ ทารุณศาสนํ กฺฤตฺวาปิ เต ภูปติเตฺวน วิขฺยาตา ภวนฺติ จฯ ");
INSERT INTO santha_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","กินฺตุ ยุษฺมากํ ตถา น ภวิษฺยติ, โย ยุษฺมากํ เศฺรษฺโฐ ภวิษฺยติ ส กนิษฺฐวทฺ ภวตุ, ยศฺจ มุโขฺย ภวิษฺยติ ส เสวกวทฺภวตุฯ ");
INSERT INTO santha_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","โภชโนปวิษฺฏปริจารกโย: ก: เศฺรษฺฐ:? โย โภชนาโยปวิศติ ส กึ เศฺรษฺโฐ น ภวติ? กินฺตุ ยุษฺมากํ มเธฺย'หํ ปริจารกอิวาสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","อปรญฺจ ยุยํ มม ปรีกฺษากาเล ปฺรถมมารภฺย มยา สห สฺถิตา ");
INSERT INTO santha_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","เอตตฺการณาตฺ ปิตฺรา ยถา มทรฺถํ ราชฺยเมกํ นิรูปิตํ ตถาหมปิ ยุษฺมทรฺถํ ราชฺยํ นิรูปยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ตสฺมานฺ มม ราเชฺย โภชนาสเน จ โภชนปาเน กริษฺยเธฺว สึหาสเนษูปวิศฺย เจสฺราเยลียานำ ทฺวาทศวํศานำ วิจารํ กริษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","อปรํ ปฺรภุรุวาจ, เห ศิโมนฺ ปศฺย ติตอุนา ธานฺยานีว ยุษฺมานฺ ไศตานฺ จาลยิตุมฺ ไอจฺฉตฺ, ");
INSERT INTO santha_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","กินฺตุ ตว วิศฺวาสสฺย โลโป ยถา น ภวติ เอตตฺ ตฺวทรฺถํ ปฺรารฺถิตํ มยา, ตฺวนฺมนสิ ปริวรฺตฺติเต จ ภฺราตฺฤณำ มนำสิ สฺถิรีกุรุฯ ");
INSERT INTO santha_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ตทา โสวทตฺ, เห ปฺรโภหํ ตฺวยา สารฺทฺธํ การำ มฺฤติญฺจ ยาตุํ มชฺชิโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ตต: ส อุวาจ, เห ปิตร ตฺวำ วทามิ, อทฺย กุกฺกุฏรวาตฺ ปูรฺวฺวํ ตฺวํ มตฺปริจยํ วารตฺรยมฺ อปโหฺวษฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","อปรํ ส ปปฺรจฺฉ, ยทา มุทฺราสมฺปุฏํ ขาทฺยปาตฺรํ ปาทุกาญฺจ วินา ยุษฺมานฺ ปฺราหิณวํ ตทา ยุษฺมากํ กสฺยาปิ นฺยูนตาสีตฺ? เต โปฺรจุ: กสฺยาปิ นฯ ");
INSERT INTO santha_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ตทา โสวทตฺ กินฺตฺวิทานีํ มุทฺราสมฺปุฏํ ขาทฺยปาตฺรํ วา ยสฺยาสฺติ เตน ตทฺคฺรหีตวฺยํ, ยสฺย จ กฺฤปาโณे นาสฺติ เตน สฺววสฺตฺรํ วิกฺรีย ส เกฺรตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ยโต ยุษฺมานหํ วทามิ, อปราธิชไน: สารฺทฺธํ คณิต: ส ภวิษฺยติฯ อิทํ ยจฺฉาสฺตฺรียํ วจนํ ลิขิตมสฺติ ตนฺมยิ ผลิษฺยติ ยโต มม สมฺพนฺธียํ สรฺวฺวํ เสตฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ตทา เต โปฺรจุ: ปฺรโภ ปศฺย อิเมา กฺฤปาเณาฯ ตต: โสวททฺ เอเตา ยเถษฺเฏาฯ ");
INSERT INTO santha_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","อถ ส ตสฺมาทฺวหิ รฺคตฺวา สฺวาจารานุสาเรณ ไชตุนนามาทฺรึ ชคาม ศิษฺยาศฺจ ตตฺปศฺจาทฺ ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ตโตฺรปสฺถาย ส ตานุวาจ, ยถา ปรีกฺษายำ น ปตถ ตทรฺถํ ปฺรารฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ปศฺจาตฺ ส ตสฺมาทฺ เอกศรกฺเษปาทฺ พหิ รฺคตฺวา ชานุนี ปาตยิตฺวา เอตตฺ ปฺรารฺถยาญฺจเกฺร, ");
INSERT INTO santha_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","เห ปิต รฺยทิ ภวานฺ สมฺมนฺยเต ตรฺหิ กํสเมนํ มมานฺติกาทฺ ทูรย กินฺตุ มทิจฺฉานุรูปํ น ตฺวทิจฺฉานุรูปํ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ตทา ตไสฺม ศกฺตึ ทาตุํ สฺวรฺคียทูโต ทรฺศนํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ปศฺจาตฺ โสตฺยนฺตํ ยาตนยา วฺยากุโล ภูตฺวา ปุนรฺทฺฤฒํ ปฺรารฺถยาญฺจเกฺร, ตสฺมาทฺ พฺฤหจฺโฉณิตพินฺทว อิว ตสฺย เสฺวทพินฺทว: ปฺฤถิวฺยำ ปติตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","อถ ปฺรารฺถนาต อุตฺถาย ศิษฺยาณำ สมีปเมตฺย ตานฺ มโนทุ:ขิโน นิทฺริตานฺ ทฺฤษฺฏฺวาวทตฺ ");
INSERT INTO santha_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","กุโต นิทฺราถ? ปรีกฺษายามฺ อปตนารฺถํ ปฺรรฺถยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","เอตตฺกถายา: กถนกาเล ทฺวาทศศิษฺยาณำ มเธฺย คณิโต ยิหูทานามา ชนตาสหิตเสฺตษามฺ อเคฺร จลิตฺวา ยีโศศฺจุมฺพนารฺถํ ตทนฺติกมฺ อายเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ตทา ยีศุรุวาจ, เห ยิหูทา กึ จุมฺพเนน มนุษฺยปุตฺรํ ปรกเรษุ สมรฺปยสิ? ");
INSERT INTO santha_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ตทา ยทฺยทฺ ฆฏิษฺยเต ตทนุมาย สงฺคิภิรุกฺตํ, เห ปฺรโภ วยํ กิ ขงฺเคน ฆาตยิษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ตต เอก: กรวาเลนาหตฺย ปฺรธานยาชกสฺย ทาสสฺย ทกฺษิณํ กรฺณํ จิจฺเฉทฯ ");
INSERT INTO santha_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","อธูนา นิวรฺตฺตสฺว อิตฺยุกฺตฺวา ยีศุสฺตสฺย ศฺรุตึ สฺปฺฤษฺฏฺวา สฺวสฺยํ จการฯ ");
INSERT INTO santha_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ปศฺจาทฺ ยีศุ: สมีปสฺถานฺ ปฺรธานยาชกานฺ มนฺทิรสฺย เสนาปตีนฺ ปฺราจีนำศฺจ ชคาท, ยูยํ กฺฤปาณานฺ ยษฺฏีํศฺจ คฺฤหีตฺวา มำ กึ โจรํ ธรฺตฺตุมายาตา:? ");
INSERT INTO santha_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ยทาหํ ยุษฺมาภิ: สห ปฺรติทินํ มนฺทิเร'ติษฺฐํ ตทา มำ ธรฺตฺตํ น ปฺรวฺฤตฺตา:, กินฺตฺวิทานีํ ยุษฺมากํ สมโยนฺธการสฺย จาธิปตฺยมสฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","อถ เต ตํ ธฺฤตฺวา มหายาชกสฺย นิเวศนํ นินฺยุ:ฯ ตต: ปิตโร ทูเร ทูเร ปศฺจาทิตฺวา ");
INSERT INTO santha_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","พฺฤหตฺโกษฺฐสฺย มเธฺย ยตฺราคฺนึ ชฺวาลยิตฺวา โลกา: สเมโตฺยปวิษฺฏาสฺตตฺร ไต: สารฺทฺธมฺ อุปวิเวศฯ ");
INSERT INTO santha_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","อถ วหฺนิสนฺนิเธา สมุปเวศกาเล กาจิทฺทาสี มโน นิวิศฺย ตํ นิรีกฺษฺยาวทตฺ ปุมานยํ ตสฺย สงฺเค'สฺถาตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","กินฺตุ ส ตทฺ อปหฺนุตฺยาวาทีตฺ เห นาริ ตมหํ น ปริจิโนมิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","กฺษณานฺตเร'นฺยชนสฺตํ ทฺฤษฺฏฺวาพฺรวีตฺ ตฺวมปิ เตษำ นิกรไสฺยกชโนสิฯ ปิตร: ปฺรตฺยุวาจ เห นร นาหมสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ตต: สารฺทฺธทณฺฑทฺวยาตฺ ปรํ ปุนรโนฺย ชโน นิศฺจิตฺย พภาเษ, เอษ ตสฺย สงฺคีติ สตฺยํ ยโตยํ คาลีลีโย โลก:ฯ ");
INSERT INTO santha_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ตทา ปิตร อุวาจ เห นร ตฺวํ ยทฺ วทมิ ตทหํ โพทฺธุํ น ศกฺโนมิ, อิติ วาเกฺย กถิตมาเตฺร กุกฺกุโฏ รุราวฯ ");
INSERT INTO santha_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ตทา ปฺรภุณา วฺยาธุฏฺย ปิตเร นิรีกฺษิเต กฺฤกวากุรวาตฺ ปูรฺวฺวํ มำ ตฺริรปโหฺนษฺยเส อิติ ปูรฺโวฺวกฺตํ ตสฺย วากฺยํ ปิตร: สฺมฺฤตฺวา ");
INSERT INTO santha_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","พหิรฺคตฺวา มหาเขเทน จกฺรนฺทฯ ");
INSERT INTO santha_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ตทา ไย รฺยีศุรฺธฺฤตเสฺต ตมุปหสฺย ปฺรหรฺตฺตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","วสฺเตฺรณ ตสฺย ทฺฤเศา พทฺธฺวา กโปเล จเปฏาฆาตํ กฺฤตฺวา ปปฺรจฺฉุ:, กเสฺต กโปเล จเปฏาฆาตํ กฺฤตวาน? คณยิตฺวา ตทฺ วทฯ ");
INSERT INTO santha_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ตทนฺยตฺ ตทฺวิรุทฺธํ พหุนินฺทาวากฺยํ วกฺตุมาเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","อถ ปฺรภาเต สติ โลกปฺราญฺจ: ปฺรธานยาชกา อธฺยาปกาศฺจ สภำ กฺฤตฺวา มเธฺยสภํ ยีศุมานีย ปปฺรจฺฉุ:, ตฺวมฺ อภิษิกโตสิ น วาสฺมานฺ วทฯ ");
INSERT INTO santha_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ส ปฺรตฺยุวาจ, มยา ตสฺมินฺนุกฺเต'ปิ ยูยํ น วิศฺวสิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","กสฺมึศฺจิทฺวาเกฺย ยุษฺมานฺ ปฺฤษฺเฏ'ปิ มำ น ตทุตฺตรํ วกฺษฺยถ น มำ ตฺยกฺษฺยถ จฯ ");
INSERT INTO santha_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","กินฺตฺวิต: ปรํ มนุชสุต: สรฺวฺวศกฺติมต อีศฺวรสฺย ทกฺษิเณ ปารฺเศฺว สมุปเวกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ตตเสฺต ปปฺรจฺฉุ:, รฺติห ตฺวมีศฺวรสฺย ปุตฺร:? ส กถยามาส, ยูยํ ยถารฺถํ วทถ ส เอวาหํฯ ");
INSERT INTO santha_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ตทา เต สรฺเวฺว กถยามาสุ:, รฺติห สากฺเษฺย'นฺสสฺมินฺ อสฺมากํ กึ ปฺรโยชนํ? อสฺย สฺวมุขาเทว สากฺษฺยํ ปฺราปฺตมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ตต: สภาสฺถา: สรฺวฺวโลกา อุตฺถาย ตํ ปีลาตสมฺมุขํ นีตฺวาโปฺรทฺย วกฺตุมาเรภิเร, ");
INSERT INTO santha_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","สฺวมภิษิกฺตํ ราชานํ วทนฺตํ ไกมรราชาย กรทานํ นิเษธนฺตํ ราชฺยวิปรฺยฺยยํ กุรฺตฺตุํ ปฺรวรฺตฺตมานมฺ เอน ปฺราปฺตา วยํฯ ");
INSERT INTO santha_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ตทา ปีลาตสฺตํ ปฺฤษฺฏวานฺ ตฺวํ กึ ยิหูทียานำ ราชา? ส ปฺรตฺยุวาจ ตฺวํ สตฺยมุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ตทา ปีลาต: ปฺรธานยาชกาทิโลกานฺ ชคาทฺ, อหเมตสฺย กมปฺยปราธํ นาปฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ตตเสฺต ปุน: สาหมิโน ภูตฺวาวทนฺ, เอษ คาลีล เอตตฺสฺถานปรฺยฺยนฺเต สรฺวฺวสฺมินฺ ยิหูทาเทเศ สรฺวฺวาโลฺลกานุปทิศฺย กุปฺรวฺฤตฺตึ คฺราหีตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ตทา ปีลาโต คาลีลปฺรเทศสฺย นาม ศฺรุตฺวา ปปฺรจฺฉ, กิมยํ คาลีลีโย โลก:? ");
INSERT INTO santha_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ตต: ส คาลีลฺปฺรเทศียเหโรทฺราชสฺย ตทา สฺถิเตสฺตสฺย สมีเป ยีศุํ เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ตทา เหโรทฺ ยีศุํ วิโลกฺย สนฺตุโตษ, ยต: ส ตสฺย พหุวฺฤตฺตานฺตศฺรวณาตฺ ตสฺย กิญิ्จทาศฺจรฺยฺยกรฺมฺม ปศฺยติ อิตฺยาศำ กฺฤตฺวา พหุกาลมารภฺย ตํ ทฺรษฺฏุํ ปฺรยาสํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ตสฺมาตฺ ตํ พหุกถา: ปปฺรจฺฉ กินฺตุ ส ตสฺย กสฺยาปิ วากฺยสฺย ปฺรตฺยุตฺตรํ โนวาจฯ ");
INSERT INTO santha_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","อถ ปฺรธานยาชกา อธฺยาปกาศฺจ โปฺรตฺติษฺฐนฺต: สาหเสน ตมปวทิตุํ ปฺราเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","เหโรทฺ ตสฺย เสนาคณศฺจ ตมวชฺญาย อุปหาสเตฺวน ราชวสฺตฺรํ ปริธาปฺย ปุน: ปีลาตํ ปฺรติ ตํ ปฺราหิโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ปูรฺวฺวํ เหโรทฺปีลาตโย: ปรสฺปรํ ไวรภาว อาสีตฺ กินฺตุ ตทฺทิเน ทฺวโย เรฺมลนํ ชาตมฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ปศฺจาตฺ ปีลาต: ปฺรธานยาชกานฺ ศาสกานฺ โลกำศฺจ ยุคปทาหูย พภาเษ, ");
INSERT INTO santha_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ราชฺยวิปรฺยฺยยการโกยมฺ อิตฺยุกฺตฺวา มนุษฺยเมนํ มม นิกฏมาไนษฺฏ กินฺตุ ปศฺยต ยุษฺมากํ สมกฺษมฺ อสฺย วิจารํ กฺฤตฺวาปิ โปฺรกฺตาปวาทานุรูเปณาสฺย โกปฺยปราธ: สปฺรมาโณ น ชาต:, ");
INSERT INTO santha_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ยูยญฺจ เหโรท: สนฺนิเธา เปฺรษิตา มยา ตตฺราสฺย โกปฺยปราธเสฺตนาปิ น ปฺราปฺต:ฯ ปศฺยตาเนน วธเหेตุกํ กิมปิ นาปราทฺธํฯ ");
INSERT INTO santha_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ตสฺมาเทนํ ตาฑยิตฺวา วิหาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ตโตฺรตฺสเว เตษาเมโก โมจยิตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","อิติ เหโตเสฺต โปฺรจฺไจเรกทา โปฺรจุ:, เอนํ ทูรีกฺฤตฺย พรพฺพานามานํ โมจยฯ ");
INSERT INTO santha_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ส พรพฺพา นคร อุปปฺลววธาปราธาภฺยำ การายำ พทฺธ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","กินฺตุ ปีลาโต ยีศุํ โมจยิตุํ วาญฺฉนฺ ปุนสฺตานุวาจฯ ");
INSERT INTO santha_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ตถาเปฺยนํ กฺรุเศ วฺยธ กฺรุเศ วฺยเธติ วทนฺตเสฺต รุรุวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ตต: ส ตฺฤตียวารํ ชคาท กุต:? ส กึ กรฺมฺม กฺฤตวานฺ? นาหมสฺย กมปิ วธาปราธํ ปฺราปฺต: เกวลํ ตาฑยิตฺวามุํ ตฺยชามิฯ ");
INSERT INTO santha_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ตถาปิ เต ปุนเรนํ กฺรุเศ วฺยธ อิตฺยุกฺตฺวา โปฺรจฺไจรฺทฺฤฒํ ปฺรารฺถยาญฺจกฺริเร; ");
INSERT INTO santha_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ตต: ปฺรธานยาชกาทีนำ กลรเว ปฺรพเล สติ เตษำ ปฺรารฺถนารูปํ กรฺตฺตุํ ปีลาต อาทิเทศฯ ");
INSERT INTO santha_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ราชโทฺรหวธโยรปราเธน การาสฺถํ ยํ ชนํ เต ยยาจิเร ตํ โมจยิตฺวา ยีศุํ เตษามิจฺฉายำ สมารฺปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","อถ เต ยีศุํ คฺฤหีตฺวา ยานฺติ, เอตรฺหิ คฺรามาทาคตํ ศิโมนนามานํ กุรีณียํ ชนํ ธฺฤตฺวา ยีโศ: ปศฺจานฺเนตุํ ตสฺย สฺกนฺเธ กฺรุศมรฺปยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ตโต โลाการณฺยมเธฺย พหุสฺตฺริโย รุทโตฺย วิลปนฺตฺยศฺจ ยีโศ: ปศฺจาทฺ ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","กินฺตุ ส วฺยาฆุฏฺย ตา อุวาจ, เห ยิรูศาลโม นารฺโยฺย ยุยํ มทรฺถํ น รุทิตฺวา สฺวารฺถํ สฺวาปตฺยารฺถญฺจ รุทิติ; ");
INSERT INTO santha_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ปศฺยต ย: กทาปิ ครฺภวโตฺย นาภวนฺ สฺตนฺยญฺจ นาปายยนฺ ตาทฺฤศี รฺวนฺธฺยา ยทา ธนฺยา วกฺษฺยนฺติ ส กาล อายาติฯ ");
INSERT INTO santha_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ตทา เห ไศลา อสฺมากมุปริ ปตต, เห อุปไศลา อสฺมานาจฺฉาทยต กถามีทฺฤศีํ โลกา วกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ยต: สเตชสิ ศาขินิ เจเทตทฺ ฆฏเต ตรฺหิ ศุษฺกศาขินิ กึ น ฆฏิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ตทา เต หนฺตุํ ทฺวาวปราธิเนา เตน สารฺทฺธํ นินฺยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","อปรํ ศิร:กปาลนามกสฺถานํ ปฺราปฺย ตํ กฺรุเศ วิวิธุ:; ตทฺทฺวโยรปราธิโนเรกํ ตสฺย ทกฺษิโณ ตทนฺยํ วาเม กฺรุเศ วิวิธุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ตทา ยีศุรกถยตฺ, เห ปิตเรตานฺ กฺษมสฺว ยต เอเต ยตฺ กรฺมฺม กุรฺวฺวนฺติ ตนฺ น วิทุ:; ปศฺจาตฺเต คุฏิกาปาตํ กฺฤตฺวา ตสฺย วสฺตฺราณิ วิภชฺย ชคฺฤหุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ตตฺร โลกสํฆสฺติษฺฐนฺ ททรฺศ; เต เตษำ ศาสกาศฺจ ตมุปหสฺย ชคทุ:, เอษ อิตรานฺ รกฺษิตวานฺ ยทีศฺวเรณาภิรุจิโต 'ภิษิกฺตสฺตฺราตา ภวติ ตรฺหิ สฺวมธุนา รกฺษตุฯ ");
INSERT INTO santha_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ตทนฺย: เสนาคณา เอตฺย ตไสฺม อมฺลรสํ ทตฺวา ปริหสฺย โปฺรวาจ, ");
INSERT INTO santha_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","เจตฺตฺวํ ยิหูทียานำ ราชาสิ ตรฺหิ สฺวํ รกฺษฯ ");
INSERT INTO santha_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ยิหูทียานำ ราเชติ วากฺยํ ยูนานียโรมีเยพฺรียากฺษไร รฺลิขิตํ ตจฺฉิรส อูรฺทฺเธฺว'สฺถาปฺยตฯ ");
INSERT INTO santha_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ตโทภยปารฺศฺวโย รฺวิทฺเธา ยาวปราธิเนา ตโยเรกสฺตํ วินินฺทฺย พภาเษ, เจตฺตฺวมฺ อภิษิกฺโตสิ ตรฺหิ สฺวมาวาญฺจ รกฺษฯ ");
INSERT INTO santha_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","กินฺตฺวนฺยสฺตํ ตรฺชยิตฺวาวทตฺ, อีศฺวราตฺตว กิญฺจิทปิ ภยํ นาสฺติ กึ? ตฺวมปิ สมานทณฺโฑสิ, ");
INSERT INTO santha_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","โยคฺยปาเตฺร อาวำ สฺวสฺวกรฺมฺมณำ สมุจิตผลํ ปฺราปฺนุว: กินฺตฺวเนน กิมปิ นาปราทฺธํฯ ");
INSERT INTO santha_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","อถ ส ยีศุํ ชคาท เห ปฺรเภ ภวานฺ สฺวราชฺยปฺรเวศกาเล มำ สฺมรตุฯ ");
INSERT INTO santha_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ตทา ยีศุ: กถิตวานฺ ตฺวำ ยถารฺถํ วทามิ ตฺวมไทฺยว มยา สารฺทฺธํ ปรโลกสฺย สุขสฺถานํ ปฺราปฺสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","อปรญฺจ ทฺวิตียยามาตฺ ตฺฤตียยามปรฺยฺยนฺตํ รเวเสฺตชโสนฺตรฺหิตตฺวาตฺ สรฺวฺวเทโศ'นฺธกาเรณาวฺฤโต ");
INSERT INTO santha_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","มนฺทิรสฺย ยวนิกา จ ฉิทฺยมานา ทฺวิธา พภูวฯ ");
INSERT INTO santha_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ตโต ยีศุรุจฺไจรุวาจ, เห ปิต รฺมมาตฺมานํ ตว กเร สมรฺปเย, อิตฺยุกฺตฺวา ส ปฺราณานฺ ชเหาฯ ");
INSERT INTO santha_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ตไทตา ฆฏนา ทฺฤษฺฏฺวา ศตเสนาปติรีศฺวรํ ธนฺยมุกฺตฺวา กถิตวานฺ อยํ นิตานฺตํ สาธุมนุษฺย อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","อถ ยาวนฺโต โลกา ทฺรษฺฏุมฺ อาคตาเสฺต ตา ฆฏนา ทฺฤษฺฏฺวา วกฺษ:สุ กราฆาตํ กฺฤตฺวา วฺยาจุฏฺย คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ยีโศ รฺชฺญาตโย ยา ยา โยษิตศฺจ คาลีลเสฺตน สารฺทฺธมายาตาสฺตา อปิ ทูเร สฺถิตฺวา ตตฺ สรฺวฺวํ ททฺฤศุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ตทา ยิหูทียานำ มนฺตฺรณำ กฺริยาญฺจาสมฺมนฺยมาน อีศฺวรสฺย ราชตฺวมฺ อเปกฺษมาโณ ");
INSERT INTO santha_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ยิหูทิเทศีโย 'ริมถียนครีโย ยูษผฺนามา มนฺตฺรี ภโทฺร ธารฺมฺมิกศฺจ ปุมานฺ ");
INSERT INTO santha_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ปีลาตานฺติกํ คตฺวา ยีโศ เรฺทหํ ยยาเจฯ ");
INSERT INTO santha_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ปศฺจาทฺ วปุรวโรหฺย วาสสา สํเวษฺฏฺย ยตฺร โกปิ มานุโษ นาสฺถาปฺยต ตสฺมินฺ ไศเล สฺวาเต ศฺมศาเน ตทสฺถาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ตทฺทินมาโยชนียํ ทินํ วิศฺรามวารศฺจ สมีป:ฯ ");
INSERT INTO santha_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","อปรํ ยีศุนา สารฺทฺธํ คาลีล อาคตา โยษิต: ปศฺจาทิตฺวา ศฺมศาเน ตตฺร ยถา วปุ: สฺถาปิตํ ตจฺจ ทฺฤษฺฏฺวา ");
INSERT INTO santha_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","วฺยาฆุฏฺย สุคนฺธิทฺรวฺยไตลานิ กฺฤตฺวา วิธิวทฺ วิศฺรามวาเร วิศฺรามํ จกฺรุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","อถ สปฺตาหปฺรถมทิเน'ติปฺรตฺยูเษ ตา โยษิต: สมฺปาทิตํ สุคนฺธิทฺรวฺยํ คฺฤหีตฺวา ตทนฺยาภิ: กิยตีภิ: สฺตฺรีภิ: สห ศฺมศานํ ยยุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","กินฺตุ ศฺมศานทฺวาราตฺ ปาษาณมปสาริตํ ทฺฤษฺฏฺวา ");
INSERT INTO santha_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ตา: ปฺรวิศฺย ปฺรโภ เรฺทหมปฺราปฺย ");
INSERT INTO santha_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","วฺยากุลา ภวนฺติ เอตรฺหิ เตโชมยวสฺตฺรานฺวิเตา เทฺวา ปุรุเษา ตาสำ สมีเป สมุปสฺถิเตา ");
INSERT INTO santha_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ตสฺมาตฺตา: ศงฺกายุกฺตา ภูมาวโธมุขฺยสฺยสฺถุ:ฯ ตทา เตา ตา อูจตุ รฺมฺฤตานำ มเธฺย ชีวนฺตํ กุโต มฺฤคยถ? ");
INSERT INTO santha_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","โสตฺร นาสฺติ ส อุทสฺถาตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ปาปินำ กเรษุ สมรฺปิเตน กฺรุเศ หเตน จ มนุษฺยปุเตฺรณ ตฺฤตียทิวเส ศฺมศานาทุตฺถาตวฺยมฺ อิติ กถำ ส คลีลิ ติษฺฐนฺ ยุษฺมภฺยํ กถิตวานฺ ตำ สฺมรตฯ ");
INSERT INTO santha_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ตทา ตสฺย สา กถา ตาสำ มน:สุ ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","อนนฺตรํ ศฺมศานาทฺ คตฺวา ตา เอกาทศศิษฺยาทิภฺย: สรฺเวฺวภฺยสฺตำ วารฺตฺตำ กถยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","มคฺทลีนีมริยมฺ, โยหนา, ยากูโพ มาตา มริยมฺ ตทนฺยา: สงฺคิโนฺย โยษิตศฺจ เปฺรริเตภฺย เอตา: สรฺวฺวา วารฺตฺตา: กถยามาสุ: ");
INSERT INTO santha_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","กินฺตุ ตาสำ กถามฺ อนรฺถกาขฺยานมาตฺรํ พุทฺธฺวา โกปิ น ปฺรไตฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ตทา ปิตร อุตฺถาย ศฺมศานานฺติกํ ทธาว, ตตฺร จ ปฺรโหฺว ภูตฺวา ปารฺไศฺวกสฺถาปิตํ เกวลํ วสฺตฺรํ ททรฺศ; ตสฺมาทาศฺจรฺยฺยํ มนฺยมาโน ยทฆฏต ตนฺมนสิ วิจารยนฺ ปฺรตเสฺถฯ ");
INSERT INTO santha_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ตสฺมินฺเนว ทิเน เทฺวา ศิเยฺยา ยิรูศาลมศฺจตุษฺโกฺรศานฺตริตมฺ อิมฺมายุคฺรามํ คจฺฉนฺเตา ");
INSERT INTO santha_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ตาสำ ฆฏนานำ กถามกถยตำ ");
INSERT INTO santha_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ตโยราลาปวิจารโย: กาเล ยีศุราคตฺย ตาภฺยำ สห ชคาม ");
INSERT INTO santha_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","กินฺตุ ยถา เตา ตํ น ปริจินุตสฺตทรฺถํ ตโย รฺทฺฤษฺฏิ: สํรุทฺธาฯ ");
INSERT INTO santha_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ส เตา ปฺฤษฺฏวานฺ ยุวำ วิษณฺเณา กึ วิจารยนฺเตา คจฺฉถ:? ");
INSERT INTO santha_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ตตสฺตโย: กฺลิยปานามา ปฺรตฺยุวาจ ยิรูศาลมปุเร'ธุนา ยานฺยฆฏนฺต ตฺวํ เกวลวิเทศี กึ ตทฺวฺฤตฺตานฺตํ น ชานาสิ? ");
INSERT INTO santha_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ส ปปฺรจฺฉ กา ฆฏนา:? ตทา เตา วกฺตุมาเรภาเต ยีศุนามา โย นาสรตีโย ภวิษฺยทฺวาที อีศฺวรสฺย มานุษาณาญฺจ สากฺษาตฺ วาเกฺย กรฺมฺมณิ จ ศกฺติมานาสีตฺ ");
INSERT INTO santha_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ตมฺ อสฺมากํ ปฺรธานยาชกา วิจารกาศฺจ เกนาปิ ปฺรกาเรณ กฺรุเศ วิทฺธฺวา ตสฺย ปฺราณานนาศยนฺ ตทียา ฆฏนา:; ");
INSERT INTO santha_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","กินฺตุ ย อิสฺราเยลียโลกานฺ อุทฺธารยิษฺยติ ส เอวายมฺ อิตฺยาศาสฺมาภิ: กฺฤตาฯ ตทฺยถา ตถาสฺตุ ตสฺยา ฆฏนายา อทฺย ทินตฺรยํ คตํฯ ");
INSERT INTO santha_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","อธิกนฺตฺวสฺมากํ สงฺคินีนำ กิยตฺสฺตฺรีณำ มุเขโภฺย'สมฺภววากฺยมิทํ ศฺรุตํ; ");
INSERT INTO santha_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ตา: ปฺรตฺยูเษ ศฺมศานํ คตฺวา ตตฺร ตสฺย เทหมฺ อปฺราปฺย วฺยาฆุเฏฺยตฺวา โปฺรกฺตวตฺย: สฺวรฺคีสทูเตา ทฺฤษฺฏาวสฺมาภิเสฺตา จาวาทิษฺฏำ ส ชีวิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ตโตสฺมากํ ไกศฺจิตฺ ศฺมศานมคมฺยต เต'ปิ สฺตฺรีณำ วากฺยานุรูปํ ทฺฤษฺฏวนฺต: กินฺตุ ตํ นาปศฺยนฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ตทา ส ตาวุวาจ, เห อโพเธา เห ภวิษฺยทฺวาทิภิรุกฺตวากฺยํ ปฺรเตฺยตุํ วิลมฺพมาเนา; ");
INSERT INTO santha_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","เอตตฺสรฺวฺวทุ:ขํ ภุกฺตฺวา สฺวภูติปฺราปฺติ: กึ ขฺรีษฺฏสฺย น นฺยายฺยา? ");
INSERT INTO santha_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ตต: ส มูสาคฺรนฺถมารภฺย สรฺวฺวภวิษฺยทฺวาทินำ สรฺวฺวศาสฺเตฺร สฺวสฺมินฺ ลิขิตาขฺยานาภิปฺรายํ โพธยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","อถ คมฺยคฺรามาภฺยรฺณํ ปฺราปฺย เตนาเคฺร คมนลกฺษเณ ทรฺศิเต ");
INSERT INTO santha_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","เตา สาธยิตฺวาวทตำ สหาวาภฺยำ ติษฺฐ ทิเน คเต สติ ราตฺริรภูตฺ; ตต: ส ตาภฺยำ สารฺทฺธํ สฺถาตุํ คฺฤหํ ยเยาฯ ");
INSERT INTO santha_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ปศฺจาทฺโภชโนปเวศกาเล ส ปูปํ คฺฤหีตฺวา อีศฺวรคุณานฺ ชคาท ตญฺจ ภํกฺตฺวา ตาภฺยำ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ตทา ตโย รฺทฺฤษฺเฏา ปฺรสนฺนายำ ตํ ปฺรตฺยภิชฺญตุ: กินฺตุ ส ตโย: สากฺษาทนฺตรฺทเธฯ ");
INSERT INTO santha_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ตตเสฺตา มิโถภิธาตุมฺ อารพฺธวนฺเตา คมนกาเล ยทา กถามกถยตฺ ศาสฺตฺรารฺถญฺจโพธยตฺ ตทาวโย รฺพุทฺธิ: กึ น ปฺราชฺวลตฺ? ");
INSERT INTO santha_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","เตา ตตฺกฺษณาทุตฺถาย ยิรูศาลมปุรํ ปฺรตฺยายยตุ:, ตตฺสฺถาเน ศิษฺยาณามฺ เอกาทศานำ สงฺคินาญฺจ ทรฺศนํ ชาตํฯ ");
INSERT INTO santha_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","เต โปฺรจุ: ปฺรภุรุทติษฺฐทฺ อิติ สตฺยํ ศิโมเน ทรฺศนมทาจฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ตต: ปถ: สรฺวฺวฆฏนายา: ปูปภญฺชเนน ตตฺปริจยสฺย จ สรฺวฺววฺฤตฺตานฺตํ เตา วกฺตุมาเรภาเตฯ ");
INSERT INTO santha_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","อิตฺถํ เต ปรสฺปรํ วทนฺติ ตตฺกาเล ยีศุ: สฺวยํ เตษำ มธฺย โปฺรตฺถย ยุษฺมากํ กลฺยาณํ ภูยาทฺ อิตฺยุวาจ, ");
INSERT INTO santha_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","กินฺตุ ภูตํ ปศฺยาม อิตฺยนุมาย เต สมุทฺวิวิชิเร เตฺรษุศฺจฯ ");
INSERT INTO santha_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ส อุวาจ, กุโต ทุ:ขิตา ภวถ? ยุษฺมากํ มน:สุ สนฺเทห อุเทติ จ กุต:? ");
INSERT INTO santha_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","เอโษหํ, มม กเรา ปศฺยต วรํ สฺปฺฤษฺฏฺวา ปศฺยต, มม ยาทฺฤศานิ ปศฺยถ ตาทฺฤศานิ ภูตสฺย มำสาสฺถีนิ น สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","อิตฺยุกฺตฺวา ส หสฺตปาทานฺ ทรฺศยามาสฯ ");
INSERT INTO santha_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","เต'สมฺภวํ ชฺญาตฺวา สานนฺทา น ปฺรตฺยยนฺฯ ตต: ส ตานฺ ปปฺรจฺฉ, อตฺร ยุษฺมากํ สมีเป ขาทฺยํ กิญฺจิทสฺติ? ");
INSERT INTO santha_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ตตเสฺต กิยทฺทคฺธมตฺสฺยํ มธุ จ ททุ: ");
INSERT INTO santha_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ส ตทาทาย เตษำ สากฺษาทฺ พุภุเช ");
INSERT INTO santha_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","กถยามาส จ มูสาวฺยวสฺถายำ ภวิษฺยทฺวาทินำ คฺรนฺเถษุ คีตปุสฺตเก จ มยิ ยานิ สรฺวฺวาณิ วจนานิ ลิขิตานิ ตทนุรูปาณิ ฆฏิษฺยนฺเต ยุษฺมาภิ: สารฺทฺธํ สฺถิตฺวาหํ ยเทตทฺวากฺยมฺ อวทํ ตทิทานีํ ปฺรตฺยกฺษมภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","อถ เตภฺย: ศาสฺตฺรโพธาธิการํ ทตฺวาวทตฺ, ");
INSERT INTO santha_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ขฺรีษฺเฏเนตฺถํ มฺฤติยาตนา โภกฺตวฺยา ตฺฤตียทิเน จ ศฺมศานาทุตฺถาตวฺยญฺเจติ ลิปิรสฺติ; ");
INSERT INTO santha_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ตนฺนามฺนา ยิรูศาลมมารภฺย สรฺวฺวเทเศ มน:ปราวรฺตฺตนสฺย ปาปโมจนสฺย จ สุสํวาท: ปฺรจารยิตวฺย:, ");
INSERT INTO santha_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","เอษุ สรฺเวฺวษุ ยูยํ สากฺษิณ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","อปรญฺจ ปศฺยต ปิตฺรา ยตฺ ปฺรติชฺญาตํ ตตฺ เปฺรษยิษฺยามิ, อเตอว ยาวตฺกาลํ ยูยํ สฺวรฺคียำ ศกฺตึ น ปฺราปฺสฺยถ ตาวตฺกาลํ ยิรูศาลมฺนคเร ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","อถ ส ตานฺ ไพถนียาปรฺยฺยนฺตํ นีตฺวา หสฺตาวุตฺโตลฺย อาศิษ วกฺตุมาเรเภ ");
INSERT INTO santha_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","อาศิษํ วทนฺเนว จ เตภฺย: ปฺฤถคฺ ภูตฺวา สฺวรฺคาย นีโต'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ตทา เต ตํ ภชมานา มหานนฺเทน ยิรูศาลมํ ปฺรตฺยาชคฺมุ:ฯ ");
INSERT INTO santha_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ตโต นิรนฺตรํ มนฺทิเร ติษฺฐนฺต อีศฺวรสฺย ปฺรศํสำ ธนฺยวาทญฺจ กรฺตฺตมฺ อาเรภิเรฯ อิติ๚");
INSERT INTO santha_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","อาเทา วาท อาสีตฺ ส จ วาท อีศฺวเรณ สารฺธมาสีตฺ ส วาท: สฺวยมีศฺวร เอวฯ ");
INSERT INTO santha_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ส อาทาวีศฺวเรณ สหาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","เตน สรฺวฺวํ วสฺตุ สสฺฤเช สรฺเวฺวษุ สฺฤษฺฏวสฺตุษุ กิมปิ วสฺตุ เตนาสฺฤษฺฏํ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ส ชีวนสฺยาการ:, ตจฺจ ชีวนํ มนุษฺยาณำ โชฺยติ: ");
INSERT INTO santha_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ตชฺโชฺยติรนฺธกาเร ปฺรจกาเศ กินฺตฺวนฺธการสฺตนฺน ชคฺราหฯ ");
INSERT INTO santha_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","โยหนฺ นามก เอโก มนุช อีศฺวเรณ เปฺรษยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ตทฺวารา ยถา สรฺเวฺว วิศฺวสนฺติ ตทรฺถํ ส ตชฺโชฺยติษิ ปฺรมาณํ ทาตุํ สากฺษิสฺวรูโป ภูตฺวาคมตฺ, ");
INSERT INTO santha_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ส สฺวยํ ตชฺโชฺยติ รฺน กินฺตุ ตชฺโชฺยติษิ ปฺรมาณํ ทาตุมาคมตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ชคตฺยาคตฺย ย: สรฺวฺวมนุเชโภฺย ทีปฺตึ ททาติ ตเทว สตฺยโชฺยติ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ส ยชฺชคทสฺฤชตฺ ตนฺมทฺย เอว ส อาสีตฺ กินฺตุ ชคโต โลกาสฺตํ นาชานนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","นิชาธิการํ ส อาคจฺฉตฺ กินฺตุ ปฺรชาสฺตํ นาคฺฤหฺลนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ตถาปิ เย เย ตมคฺฤหฺลนฺ อรฺถาตฺ ตสฺย นามฺนิ วฺยศฺวสนฺ เตภฺย อีศฺวรสฺย ปุตฺรา ภวิตุมฺ อธิการมฺ อททาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","เตษำ ชนิ: โศณิตานฺน ศารีริกาภิลาษานฺน มานวานามิจฺฉาโต น กินฺตฺวีศฺวราทภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ส วาโท มนุษฺยรูเปณาวตีรฺยฺย สตฺยตานุคฺรหาภฺยำ ปริปูรฺณ: สนฺ สารฺธมฺ อสฺมาภิ รฺนฺยวสตฺ ตต: ปิตุรทฺวิตียปุตฺรสฺย โยโคฺย โย มหิมา ตํ มหิมานํ ตสฺยาปศฺยามฯ ");
INSERT INTO santha_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ตโต โยหนปิ ปฺรจารฺยฺย สากฺษฺยมิทํ ทตฺตวานฺ โย มม ปศฺจาทฺ อาคมิษฺยติ ส มตฺโต คุรุตร:; ยโต มตฺปูรฺวฺวํ ส วิทฺยมาน อาสีตฺ; ยทรฺถมฺ อหํ สากฺษฺยมิทมฺ อทำ ส เอษ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","อปรญฺจ ตสฺย ปูรฺณตายา วยํ สรฺเวฺว กฺรมศ: กฺรมโศนุคฺรหํ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","มูสาทฺวารา วฺยวสฺถา ทตฺตา กินฺตฺวนุคฺรห: สตฺยตฺวญฺจ ยีศุขฺรีษฺฏทฺวารา สมุปาติษฺฐตำฯ ");
INSERT INTO santha_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","โกปิ มนุช อีศฺวรํ กทาปิ นาปศฺยตฺ กินฺตุ ปิตุ: โกฺรฑโสฺถ'ทฺวิตีย: ปุตฺรสฺตํ ปฺรกาศยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ตฺวํ ก:? อิติ วากฺยํ เปฺรษฺฏุํ ยทา ยิหูทียโลกา ยาชกานฺ เลวิโลกำศฺจ ยิรูศาลโม โยหน: สมีเป เปฺรษยามาสุ:, ");
INSERT INTO santha_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ตทา ส สฺวีกฺฤตวานฺ นาปหฺนูตวานฺ นาหมฺ อภิษิกฺต อิตฺยงฺคีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ตทา เต'ปฺฤจฺฉนฺ ตรฺหิ โก ภวานฺ? กึ เอลิย:? โสวทตฺ น; ตตเสฺต'ปฺฤจฺฉนฺ ตรฺหิ ภวานฺ ส ภวิษฺยทฺวาที? โสวทตฺ นาหํ ส:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ตทา เต'ปฺฤจฺฉนฺ ตรฺหิ ภวานฺ ก:? วยํ คตฺวา เปฺรรกานฺ ตฺวยิ กึ วกฺษฺยาม:? สฺวสฺมินฺ กึ วทสิ? ");
INSERT INTO santha_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ตทา โสวทตฺฯ ปรเมศสฺย ปนฺถานํ ปริษฺกุรุต สรฺวฺวต:ฯ อิตีทํ ปฺรานฺตเร วากฺยํ วทต: กสฺยจิทฺรว:ฯ กถามิมำ ยสฺมินฺ ยิศยิโย ภวิษฺยทฺวาที ลิขิตวานฺ โสหมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","เย เปฺรษิตาเสฺต ผิรูศิโลกา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ตทา เต'ปฺฤจฺฉนฺ ยทิ นาภิษิกฺโตสิ เอลิโยสิ น ส ภวิษฺยทฺวาทฺยปิ นาสิ จ, ตรฺหิ โลกานฺ มชฺชยสิ กุต:? ");
INSERT INTO santha_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ตโต โยหนฺ ปฺรตฺยโวจตฺ, โตเย'หํ มชฺชยามีติ สตฺยํ กินฺตุ ยํ ยูยํ น ชานีถ ตาทฺฤศ เอโก ชโน ยุษฺมากํ มธฺย อุปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ส มตฺปศฺจาทฺ อาคโตปิ มตฺปูรฺวฺวํ วรฺตฺตมาน อาสีตฺ ตสฺย ปาทุกาพนฺธนํ โมจยิตุมปิ นาหํ โยโคฺยสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ยรฺทฺทนนทฺยา: ปารสฺถไพถพารายำ ยสฺมินฺสฺถาเน โยหนมชฺชยตฺ ตสฺมิน สฺถาเน สรฺวฺวเมตทฺ อฆฏตฯ ");
INSERT INTO santha_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ปเร'หนิ โยหนฺ สฺวนิกฏมาคจฺฉนฺตํ ยิศุํ วิโลกฺย ปฺราโวจตฺ ชคต: ปาปโมจกมฺ อีศฺวรสฺย เมษศาวกํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","โย มม ปศฺจาทาคมิษฺยติ ส มตฺโต คุรุตร:, ยโต เหโตรฺมตฺปูรฺวฺวํ โส'วรฺตฺตต ยสฺมินฺนหํ กถามิมำ กถิตวานฺ ส เอวายํฯ ");
INSERT INTO santha_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","อปรํ นาหเมนํ ปฺรตฺยภิชฺญาตวานฺ กินฺตุ อิสฺราเยโลฺลกา เอนํ ยถา ปริจินฺวนฺติ ตทภิปฺราเยณาหํ ชเล มชฺชยิตุมาคจฺฉมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ปุนศฺจ โยหนปรเมกํ ปฺรมาณํ ทตฺวา กถิตวานฺ วิหายส: กโปตวทฺ อวตรนฺตมาตฺมานมฺ อโสฺยปรฺยฺยวติษฺฐนฺตํ จ ทฺฤษฺฏวานหมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","นาหเมนํ ปฺรตฺยภิชฺญาตวานฺ อิติ สตฺยํ กินฺตุ โย ชเล มชฺชยิตุํ มำ ไปฺรรยตฺ ส เอเวมำ กถามกถยตฺ ยโสฺยปรฺยฺยาตฺมานมฺ อวตรนฺตมฺ อวติษฺฐนฺตญฺจ ทฺรกฺษยสิ เสอว ปวิเตฺร อาตฺมนิ มชฺชยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","อวสฺตนฺนิรีกฺษฺยายมฺ อีศฺวรสฺย ตนย อิติ ปฺรมาณํ ททามิฯ ");
INSERT INTO santha_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ปเร'หนิ โยหนฺ ทฺวาภฺยำ ศิษฺยาภฺยำ สารฺทฺเธํ ติษฺฐนฺ ");
INSERT INTO santha_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ยิศุํ คจฺฉนฺตํ วิโลกฺย คทิตวานฺ, อีศฺวรสฺย เมษศาวกํ ปศฺยตํฯ ");
INSERT INTO santha_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","อิมำ กถำ ศฺรุตฺวา เทฺวา ศิเษฺยา ยีโศ: ปศฺจาทฺ อียตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ตโต ยีศุ: ปราวฺฤตฺย เตา ปศฺจาทฺ อาคจฺฉนฺเตา ทฺฤษฺฏฺวา ปฺฤษฺฏวานฺ ยุวำ กึ คเวศยถ:? ตาวปฺฤจฺฉตำ เห รพฺพิ อรฺถาตฺ เห คุโร ภวานฺ กุตฺร ติษฺฐติ? ");
INSERT INTO santha_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ตต: โสวาทิตฺ เอตฺย ปศฺยตํฯ ตโต ทิวสสฺย ตฺฤตียปฺรหรสฺย คตตฺวาตฺ เตา ตทฺทินํ ตสฺย สงฺเค'สฺถาตำฯ ");
INSERT INTO santha_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","เยา เทฺวา โยหโน วากฺยํ ศฺรุตฺวา ยิโศ: ปศฺจาทฺ อาคมตำ ตโย: ศิโมนฺปิตรสฺย ภฺราตา อานฺทฺริย: ");
INSERT INTO santha_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ส อิตฺวา ปฺรถมํ นิชโสทรํ ศิโมนํ สากฺษาตฺปฺราปฺย กถิตวานฺ วยํ ขฺรีษฺฏมฺ อรฺถาตฺ อภิษิกฺตปุรุษํ สากฺษาตฺกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ปศฺจาตฺ ส ตํ ยิโศ: สมีปมฺ อานยตฺฯ ตทา ยีศุสฺตํ ทฺฤษฺฏฺวาวทตฺ ตฺวํ ยูนส: ปุตฺร: ศิโมนฺ กินฺตุ ตฺวนฺนามเธยํ ไกผา: วา ปิตร: อรฺถาตฺ ปฺรสฺตโร ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ปเร'หนิ ยีเศา คาลีลํ คนฺตุํ นิศฺจิตเจตสิ สติ ผิลิปนามานํ ชนํ สากฺษาตฺปฺราปฺยาโวจตฺ มม ปศฺจาทฺ อาคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ไพตฺไสทานามฺนิ ยสฺมินฺ คฺราเม ปิตรานฺทฺริยโยรฺวาส อาสีตฺ ตสฺมินฺ คฺราเม ตสฺย ผิลิปสฺย วสติราสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ปศฺจาตฺ ผิลิโป นิถเนลํ สากฺษาตฺปฺราปฺยาวทตฺ มูสา วฺยวสฺถา คฺรนฺเถ ภวิษฺยทฺวาทินำ คฺรนฺเถษุ จ ยสฺยาขฺยานํ ลิขิตมาเสฺต ตํ ยูษผ: ปุตฺรํ นาสรตียํ ยีศุํ สากฺษาทฺ อการฺษฺม วยํฯ ");
INSERT INTO santha_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ตทา นิถเนลฺ กถิตวานฺ นาสรนฺนคราต กึ กศฺจิทุตฺตม อุตฺปนฺตุํ ศกฺโนติ? ตต: ผิลิโป 'โวจตฺ เอตฺย ปศฺยฯ ");
INSERT INTO santha_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","อปรญฺจ ยีศุ: สฺวสฺย สมีปํ ตมฺ อาคจฺฉนฺตํ ทฺฤษฺฏฺวา วฺยาหฺฤตวานฺ, ปศฺยายํ นิษฺกปฏ: สตฺย อิสฺราเยโลฺลก:ฯ ");
INSERT INTO santha_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ตต: โสวททฺ, ภวานฺ มำ กถํ ปฺรตฺยภิชานาติ? ยีศุรวาทีตฺ ผิลิปสฺย อาหฺวานาตฺ ปูรฺวฺวํ ยทา ตฺวมุฑุมฺพรสฺย ตโรรฺมูเล'สฺถาสฺตทา ตฺวามทรฺศมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","นิถเนลฺ อจกถตฺ, เห คุโร ภวานฺ นิตานฺตมฺ อีศฺวรสฺย ปุโตฺรสิ, ภวานฺ อิสฺราเยลฺวํศสฺย ราชาฯ ");
INSERT INTO santha_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ตโต ยีศุ รฺวฺยาหรตฺ, ตฺวามุฑุมฺพรสฺย ปาทปสฺย มูเล ทฺฤษฺฏวานาหํ มไมตสฺมาทฺวากฺยาตฺ กึ ตฺวํ วฺยศฺวสี:? เอตสฺมาทปฺยาศฺจรฺยฺยาณิ การฺยฺยาณิ ทฺรกฺษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","อนฺยจฺจาวาทีทฺ ยุษฺมานหํ ยถารฺถํ วทามิ, อิต: ปรํ โมจิเต เมฆทฺวาเร ตสฺมานฺมนุชสูนุนา อีศฺวรสฺย ทูตคณมฺ อวโรหนฺตมาโรหนฺตญฺจ ทฺรกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","อนนฺตรํ ตฺรุตียทิวเส คาลีลฺ ปฺรเทศิเย กานฺนานามฺนิ นคเร วิวาห อาสีตฺ ตตฺร จ ยีโศรฺมาตา ติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ตไสฺม วิวาหาย ยีศุสฺตสฺย ศิษฺยาศฺจ นิมนฺตฺริตา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ตทนนฺตรํ ทฺรากฺษารสสฺย นฺยูนตฺวาทฺ ยีโศรฺมาตา ตมวทตฺ เอเตษำ ทฺรากฺษารโส นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ตทา ส ตามโวจตฺ เห นาริ มยา สห ตว กึ การฺยฺยํ? มม สมย อิทานีํ โนปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ตตสฺตสฺย มาตา ทาสานโวจทฺ อยํ ยทฺ วทติ ตเทว กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ตสฺมินฺ สฺถาเน ยิหูทียานำ ศุจิตฺวกรณวฺยวหารานุสาเรณาฒไกกชลธราณิ ปาษาณมยานิ ษฑฺวฺฤหตฺปาตฺราณิอาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ตทา ยีศุสฺตานฺ สรฺวฺวกลศานฺ ชไล: ปูรยิตุํ ตานาชฺญาปยตฺ, ตตเสฺต สรฺวฺวานฺ กุมฺภานากรฺณํ ชไล: ปรฺยฺยปูรยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","อถ เตภฺย: กิญฺจิทุตฺตารฺยฺย โภชฺยาธิปาเต:สมีปํ เนตุํ ส ตานาทิศตฺ, เต ตทนยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","อปรญฺจ ตชฺชลํ กถํ ทฺรากฺษารโส'ภวตฺ ตชฺชลวาหกาทาสา ชฺญาตุํ ศกฺตา: กินฺตุ ตทฺโภชฺยาธิโป ชฺญาตุํ นาศกฺโนตฺ ตทวลิหฺย วรํ สํมฺโพทฺยาวทต, ");
INSERT INTO santha_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","โลกา: ปฺรถมํ อุตฺตมทฺรากฺษารสํ ททติ ตษุ ยเถษฺฏํ ปิตวตฺสุ ตสฺมา กิญฺจิทนุตฺตมญฺจ ททติ กินฺตุ ตฺวมิทานีํ ยาวตฺ อุตฺตมทฺรากฺษารสํ สฺถาปยสิฯ ");
INSERT INTO santha_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","อิตฺถํ ยีศุรฺคาลีลปฺรเทเศ อาศฺจรฺยฺยการฺมฺม ปฺรารมฺภ นิชมหิมานํ ปฺรากาศยตฺ ตต: ศิษฺยาสฺตสฺมินฺ วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ตต: ปรมฺ ส นิชมาตฺรุภฺราตฺรุสฺศิไษฺย: สารฺทฺธฺํ กผรฺนาหูมมฺ อาคมตฺ กินฺตุ ตตฺร พหูทินานิ อาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ตทนนฺตรํ ยิหูทิยานำ นิสฺตาโรตฺสเว นิกฏมาคเต ยีศุ รฺยิรูศาลมฺ นครมฺ อาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ตโต มนฺทิรสฺย มเธฺย โคเมษปาราวตวิกฺรยิโณ วาณิชกฺษฺโจปวิษฺฏานฺ วิโลกฺย ");
INSERT INTO santha_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","รชฺชุภิ: กศำ นิรฺมฺมาย สรฺวฺวโคเมษาทิภิ: สารฺทฺธํ ตานฺ มนฺทิราทฺ ทูรีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","วณิชำ มุทฺราทิ วิกีรฺยฺย อาสนานิ นฺยูพฺชีกฺฤตฺย ปาราวตวิกฺรยิโภฺย'กถยทฺ อสฺมาตฺ สฺถานาตฺ สรฺวาเณฺยตานิ นยต, มม ปิตุคฺฤหํ วาณิชฺยคฺฤหํ มา การฺษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ตสฺมาตฺ ตนฺมนฺทิรารฺถ อุโทฺยโค ยสฺตุ ส คฺรสตีว มามฺฯ อิมำ ศาสฺตฺรียลิปึ ศิษฺยา:สมสฺมรนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ตต: ปรมฺ ยิหูทียโลกา ยีษิมวทนฺ ตวมิทฺฤศกรฺมฺมกรณาตฺ กึ จิหฺนมสฺมานฺ ทรฺศยสิ? ");
INSERT INTO santha_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ตโต ยีศุสฺตานโวจทฺ ยุษฺมาภิเร ตสฺมินฺ มนฺทิเร นาศิเต ทินตฺรยมเธฺย'หํ ตทฺ อุตฺถาปยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ตทา ยิหูทิยา วฺยาหารฺษุ:, เอตสฺย มนฺทิรส นิรฺมฺมาเณน ษฏฺจตฺวารึศทฺ วตฺสรา คตา:, ตฺวํ กึ ทินตฺรยมเธฺย ตทฺ อุตฺถาปยิษฺยสิ? ");
INSERT INTO santha_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","กินฺตุ ส นิชเทหรูปมนฺทิเร กถามิมำ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ส ยเทตาทฺฤศํ คทิตวานฺ ตจฺฉิษฺยา: ศฺมศานาตฺ ตทีโยตฺถาเน สติ สฺมฺฤตฺวา ธรฺมฺมคฺรนฺเถ ยีศุโนกฺตกถายำ จ วฺยศฺวสิษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","อนนฺตรํ นิสฺตาโรตฺสวสฺย โภชฺยสมเย ยิรูศาลมฺ นคเร ตตฺกฺรุตาศฺจรฺยฺยกรฺมฺมาณิ วิโลกฺย พหุภิสฺตสฺย นามนิ วิศฺวสิตํฯ ");
INSERT INTO santha_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","กินฺตุ ส เตษำ กเรษุ สฺวํ น สมรฺปยตฺ, ยต: ส สรฺวฺวานไวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ส มานเวษุ กสฺยจิตฺ ปฺรมาณํ นาเปกฺษต ยโต มนุชานำ มเธฺย ยทฺยทสฺติ ตตฺตตฺ โสชานาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","นิกทิมนามา ยิหูทียานามฺ อธิปติ: ผิรูศี กฺษณทายำ ");
INSERT INTO santha_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ยีเศารภฺยรฺณมฺ อาวฺรชฺย วฺยาหารฺษีตฺ, เห คุโร ภวานฺ อีศฺวราทฺ อาคตฺ เอก อุปเทษฺฏา, เอตทฺ อสฺมาภิรฺชฺญายเต; ยโต ภวตา ยานฺยาศฺจรฺยฺยกรฺมฺมาณิ กฺริยนฺเต ปรเมศฺวรสฺย สาหายฺยํ วินา เกนาปิ ตตฺตตฺกรฺมฺมาณิ กรฺตฺตุํ น ศกฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ตทา ยีศุรุตฺตรํ ทตฺตวานฺ ตวาหํ ยถารฺถตรํ วฺยาหรามิ ปุนรฺชนฺมนิ น สติ โกปิ มานว อีศฺวรสฺย ราชฺยํ ทฺรษฺฏุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ตโต นิกทีม: ปฺรตฺยโวจตฺ มนุโช วฺฤทฺโธ ภูตฺวา กถํ ชนิษฺยเต? ส กึ ปุน รฺมาตฺฤรฺชฐรํ ปฺรวิศฺย ชนิตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ยีศุรวาทีทฺ ยถารฺถตรมฺ อหํ กถยามิ มนุเช โตยาตฺมภฺยำ ปุน รฺน ชาเต ส อีศฺวรสฺย ราชฺยํ ปฺรเวษฺฏุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","มำสาทฺ ยตฺ ชายเต ตนฺ มำสเมว ตถาตฺมโน โย ชายเต ส อาตฺไมวฯ ");
INSERT INTO santha_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ยุษฺมาภิ: ปุน รฺชนิตวฺยํ มไมตสฺยำ กถายามฺ อาศฺจรฺยํ มา มํสฺถา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","สทาคติรฺยำ ทิศมิจฺฉติ ตสฺยาเมว ทิศิ วาติ, ตฺวํ ตสฺย สฺวนํ ศุโณษิ กินฺตุ ส กุต อายาติ กุตฺร ยาติ วา กิมปิ น ชานาสิ ตทฺวาทฺ อาตฺมน: สกาศาตฺ สรฺเวฺวษำ มนุชานำ ชนฺม ภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ตทา นิกทีม: ปฺฤษฺฏวานฺ เอตตฺ กถํ ภวิตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ยีศุ: ปฺรตฺยกฺตวานฺ ตฺวมิสฺราเยโล คุรุรฺภูตฺวาปิ กิเมตำ กถำ น เวตฺสิ? ");
INSERT INTO santha_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ตุภฺยํ ยถารฺถํ กถยามิ, วยํ ยทฺ วิทฺมสฺตทฺ วจฺม: ยํจฺจ ปศฺยามสฺตไสฺยว สากฺษฺยํ ททฺม: กินฺตุ ยุษฺมาภิรสฺมากํ สากฺษิตฺวํ น คฺฤหฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","เอตสฺย สํสารสฺย กถายำ กถิตายำ ยทิ ยูยํ น วิศฺวสิถ ตรฺหิ สฺวรฺคียายำ กถายำ กถํ วิศฺวสิษฺยถ? ");
INSERT INTO santha_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ย: สฺวรฺเค'สฺติ ยํ จ สฺวรฺคาทฺ อวาโรหตฺ ตํ มานวตนยํ วินา โกปิ สฺวรฺคํ นาโรหตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","อปรญฺจ มูสา ยถา ปฺรานฺตเร สรฺปํ โปฺรตฺถาปิตวานฺ มนุษฺยปุโตฺร'ปิ ตไถโวตฺถาปิตวฺย:; ");
INSERT INTO santha_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ตสฺมาทฺ ย: กศฺจิตฺ ตสฺมินฺ วิศฺวสิษฺยติ โส'วินาศฺย: สนฺ อนนฺตายุ: ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","อีศฺวร อิตฺถํ ชคททยต ยตฺ สฺวมทฺวิตียํ ตนยํ ปฺราททาตฺ ตโต ย: กศฺจิตฺ ตสฺมินฺ วิศฺวสิษฺยติ โส'วินาศฺย: สนฺ อนนฺตายุ: ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","อีศฺวโร ชคโต โลกานฺ ทณฺฑยิตุํ สฺวปุตฺรํ น เปฺรษฺย ตานฺ ปริตฺราตุํ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","อเตอว ย: กศฺจิตฺ ตสฺมินฺ วิศฺวสิติ ส ทณฺฑาโรฺห น ภวติ กินฺตุ ย: กศฺจิตฺ ตสฺมินฺ น วิศฺวสิติ ส อิทานีเมว ทณฺฑาโรฺห ภวติ,ยต: ส อีศฺวรสฺยาทฺวิตียปุตฺรสฺย นามนิ ปฺรตฺยยํ น กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ชคโต มเธฺย โชฺยติ: ปฺรากาศต กินฺตุ มนุษฺยาณำ กรฺมฺมณำ ทฺฤษฺฏตฺวาตฺ เต โชฺยติโษปิ ติมิเร ปฺรียนฺเต เอตเทว ทณฺฑสฺย การณำ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ย: กุกรฺมฺม กโรติ ตสฺยาจารสฺย ทฺฤษฺฏตฺวาตฺ ส โชฺยติรฺฤาตียิตฺวา ตนฺนิกฏํ นายาติ; ");
INSERT INTO santha_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","กินฺตุ ย: สตฺกรฺมฺม กโรติ ตสฺย สรฺวฺวาณิ กรฺมฺมาณีศฺวเรณ กฺฤตานีติ สถา ปฺรกาศเต ตทภิปฺราเยณ ส โชฺยติษ: สนฺนิธิมฺ อายาติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ตต: ปรมฺ ยีศุ: ศิไษฺย: สารฺทฺธํ ยิหูทียเทศํ คตฺวา ตตฺร สฺถิตฺวา มชฺชยิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ตทา ศาลมฺ นครสฺย สมีปสฺถายินิ ไอนนฺ คฺราเม พหุตรโตยสฺถิเตสฺตตฺร โยหนฺ อมชฺชยตฺ ตถา จ โลกา อาคตฺย เตน มชฺชิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ตทา โยหนฺ การายำ น พทฺธ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","อปรญฺจ ศาจกรฺมฺมณิ โยหาน: ศิไษฺย: สห ยิหูทียโลกานำ วิวาเท ชาเต, เต โยหน: สํนฺนิธึ คตฺวากถยนฺ, ");
INSERT INTO santha_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","เห คุโร ยรฺทฺทนนทฺยา: ปาเร ภวตา สารฺทฺธํ ย อาสีตฺ ยสฺมึศฺจ ภวานฺ สากฺษฺยํ ปฺรททาตฺ ปศฺยตุ โสปิ มชฺชยติ สรฺเวฺว ตสฺย สมีปํ ยานฺติ จฯ ");
INSERT INTO santha_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ตทา โยหนฺ ปฺรตฺยโวจทฺ อีศฺวเรณ น ทตฺเต โกปิ มนุช: กิมปิ ปฺราปฺตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","อหํ อภิษิกฺโต น ภวามิ กินฺตุ ตทเคฺร เปฺรษิโตสฺมิ ยามิมำ กถำ กถิตวานาหํ ตตฺร ยูยํ สรฺเวฺว สากฺษิณ: สฺถฯ ");
INSERT INTO santha_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","โย ชน: กนฺยำ ลภเต ส เอว วร: กินฺตุ วรสฺย สนฺนิเธา ทณฺฑายมานํ ตสฺย ยนฺมิตฺรํ เตน วรสฺย ศพฺเท ศฺรุเต'ตีวาหฺลาทฺยเต มมาปิ ตทฺวทฺ อานนฺทสิทฺธิรฺชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","เตน กฺรมโศ วรฺทฺธิตวฺยํ กินฺตุ มยา หฺสิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ย อูรฺธฺวาทาคจฺฉตฺ ส สรฺเวฺวษำ มุโขฺย ยศฺจ สํสาราทฺ อุทปทฺยต ส สำสาริก: สํสารียำ กถาญฺจ กถยติ ยสฺตุ สฺวรฺคาทาคจฺฉตฺ ส สรฺเวฺวษำ มุขฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ส ยทปศฺยทศฺฤโณจฺจ ตสฺมินฺเนว สากฺษฺยํ ททาติ ตถาปิ ปฺรายศ: กศฺจิตฺ ตสฺย สากฺษฺยํ น คฺฤหฺลาติ; ");
INSERT INTO santha_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","กินฺตุ โย คฺฤหฺลาติ ส อีศฺวรสฺย สตฺยวาทิตฺวํ มุทฺรางฺคิตํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","อีศฺวเรณ ย: เปฺรริต: เสอว อีศฺวรียกถำ กถยติ ยต อีศฺวร อาตฺมานํ ตไสฺม อปริมิตมฺ อททาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ปิตา ปุเตฺร เสฺนหํ กฺฤตฺวา ตสฺย หเสฺต สรฺวฺวาณิ สมรฺปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ย: กศฺจิตฺ ปุเตฺร วิศฺวสิติ ส เอวานนฺตมฺ ปรมายุ: ปฺราปฺโนติ กินฺตุ ย: กศฺจิตฺ ปุเตฺร น วิศฺวสิติ ส ปรมายุโษ ทรฺศนํ น ปฺราปฺโนติ กินฺตฺวีศฺวรสฺย โกปภาชนํ ภูตฺวา ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ยีศุ: สฺวยํ นามชฺชยตฺ เกวลํ ตสฺย ศิษฺยา อมชฺชยตฺ กินฺตุ โยหโน'ธิกศิษฺยานฺ ส กโรติ มชฺชยติ จ, ");
INSERT INTO santha_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ผิรูศิน อิมำ วารฺตฺตามศฺฤณฺวนฺ อิติ ปฺรภุรวคตฺย ");
INSERT INTO santha_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ยิหูทียเทศํ วิหาย ปุน รฺคาลีลมฺ อาคตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ตต: โศมิโรณปฺรเทศสฺย มเทฺยน เตน คนฺตเวฺย สติ ");
INSERT INTO santha_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ยากูพฺ นิชปุตฺราย ยูษเผ ยำ ภูมิมฺ อททาตฺ ตตฺสมีปสฺถายิ โศมิโรณปฺรเทศสฺย สุขารฺ นามฺนา วิขฺยาตสฺย นครสฺย สนฺนิธาวุปาสฺถาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ตตฺร ยากูพ: ปฺรหิราสีตฺ; ตทา ทฺวิตียยามเวลายำ ชาตายำ ส มารฺเค ศฺรมาปนฺนสฺตสฺย ปฺรเห: ปารฺเศฺว อุปาวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","เอตรฺหิ กาจิตฺ โศมิโรณียา โยษิตฺ โตโยตฺโตลนารฺถมฺ ตตฺราคมตฺ ");
INSERT INTO santha_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ตทา ศิษฺยา: ขาทฺยทฺรวฺยาณิ เกฺรตุํ นครมฺ อคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ยีศุ: โศมิโรณียำ ตำ โยษิตมฺ วฺยาหารฺษีตฺ มหฺยํ กิญฺจิตฺ ปานียํ ปาตุํ เทหิฯ กินฺตุ โศมิโรณีไย: สากํ ยิหูทียโลกา น วฺยวาหรนฺ ตสฺมาทฺเธโต: สากถยตฺ โศมิโรณียา โยษิตทหํ ตฺวํ ยิหูทีโยสิ กถํ มตฺต: ปานียํ ปาตุมฺ อิจฺฉสิ? ");
INSERT INTO santha_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ตโต ยีศุรวททฺ อีศฺวรสฺย ยทฺทานํ ตตฺกีทฺฤกฺ ปานียํ ปาตุํ มหฺยํ เทหิ ย อิตฺถํ ตฺวำ ยาจเต ส วา ก อิติ เจทชฺญาสฺยถาสฺตรฺหิ ตมยาจิษฺยถา: ส จ ตุภฺยมมฺฤตํ โตยมทาสฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ตทา สา สีมนฺตินี ภาษิตวติ, เห มเหจฺฉ ปฺรหิรฺคมฺภีโร ภวโต นีโรตฺโตลนปาตฺรํ นาสฺตี จ ตสฺมาตฺ ตทมฺฤตํ กีลาลํ กุต: ปฺราปฺสฺยสิ? ");
INSERT INTO santha_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","โยสฺมภฺยมฺ อิมมนฺธูํ ทเทา, ยสฺย จ ปริชนา โคเมษาทยศฺจ สรฺเวฺว'สฺย ปฺรเห: ปานียํ ปปุเรตาทฺฤโศ โยสฺมากํ ปูรฺวฺวปุรุโษ ยากูพฺ ตสฺมาทปิ ภวานฺ มหานฺ กึ? ");
INSERT INTO santha_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ตโต ยีศุรกถยทฺ อิทํ ปานียํ ส: ปิวติ ส ปุนสฺตฺฤษารฺตฺโต ภวิษฺยติ, ");
INSERT INTO santha_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","กินฺตุ มยา ทตฺตํ ปานียํ ย: ปิวติ ส ปุน: กทาปิ ตฺฤษารฺตฺโต น ภวิษฺยติฯ มยา ทตฺตมฺ อิทํ โตยํ ตสฺยานฺต: ปฺรสฺรวณรูปํ ภูตฺวา อนนฺตายุรฺยาวตฺ โสฺรษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ตทา สา วนิตากถยตฺ เห มเหจฺฉ ตรฺหิ มม ปุน: ปีปาสา ยถา น ชายเต โตโยตฺโตลนาย ยถาตฺราคมนํ น ภวติ จ ตทรฺถํ มหฺยํ ตตฺโตยํ เทหีฯ ");
INSERT INTO santha_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ตโต ยีศูรวททฺยาหิ ตว ปติมาหูย สฺถาเน'ตฺราคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","สา วามาวทตฺ มม ปติรฺนาสฺติฯ ยีศุรวทตฺ มม ปติรฺนาสฺตีติ วากฺยํ ภทฺรมโวจ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ยตสฺตว ปญฺจ ปตโยภวนฺ อธุนา ตุ ตฺวยา สารฺทฺธํ ยสฺติษฺฐติ ส ตว ภรฺตฺตา น วากฺยมิทํ สตฺยมวาทิ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ตทา สา มหิลา คทิตวติ เห มเหจฺฉ ภวานฺ เอโก ภวิษฺยทฺวาทีติ พุทฺธํ มยาฯ ");
INSERT INTO santha_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","อสฺมากํ ปิตฺฤโลกา เอตสฺมินฺ ศิโลจฺจเย'ภชนฺต, กินฺตุ ภวทฺภิรุจฺยเต ยิรูศาลมฺ นคเร ภชนโยคฺยํ สฺถานมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ยีศุรโวจตฺ เห โยษิตฺ มม วาเกฺย วิศฺวสิหิ ยทา ยูยํ เกวลไศเล'สฺมินฺ วา ยิรูศาลมฺ นคเร ปิตุรฺภชนํ น กริษฺยเธฺว กาล เอตาทฺฤศ อายาติฯ ");
INSERT INTO santha_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ยูยํ ยํ ภชเธฺว ตํ น ชานีถ, กินฺตุ วยํ ยํ ภชามเห ตํ ชานีมเห, ยโต ยิหูทียโลกานำ มธฺยาตฺ ปริตฺราณํ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","กินฺตุ ยทา สตฺยภกฺตา อาตฺมนา สตฺยรูเปณ จ ปิตุรฺภชนํ กริษฺยนฺเต สมย เอตาทฺฤศ อายาติ, วรมฺ อิทานีมปิ วิทฺยเต ; ยต เอตาทฺฤโศ ภตฺกานฺ ปิตา เจษฺฏเตฯ ");
INSERT INTO santha_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","อีศฺวร อาตฺมา; ตตสฺตสฺย เย ภกฺตาไสฺต: ส อาตฺมนา สตฺยรูเปณ จ ภชนีย:ฯ ");
INSERT INTO santha_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ตทา สา มหิลาวาทีตฺ ขฺรีษฺฏนามฺนา วิขฺยาโต'ภิษิกฺต: ปุรุษ อาคมิษฺยตีติ ชานามิ ส จ สรฺวฺวา: กถา อสฺมานฺ ชฺญาปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ตโต ยีศุรวทตฺ ตฺวยา สารฺทฺธํ กถนํ กโรมิ โย'หมฺ อหเมว ส ปุรุษ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","เอตสฺมินฺ สมเย ศิษฺยา อาคตฺย ตถา สฺตฺริยา สารฺทฺธํ ตสฺย กโถปกถเน มหาศฺจรฺยฺยมฺ อมนฺยนฺต ตถาปิ ภวานฺ กิมิจฺฉติ? ยทฺวา กิมรฺถมฺ เอตยา สารฺทฺธํ กถำ กถยติ? อิติ โกปิ นาปฺฤจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ตต: ปรํ สา นารี กลศํ สฺถาปยิตฺวา นครมธฺยํ คตฺวา โลเกโภฺยกถายทฺ ");
INSERT INTO santha_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","อหํ ยทฺยตฺ กรฺมฺมากรวํ ตตฺสรฺวฺวํ มหฺยมกถยทฺ เอตาทฺฤศํ มานวเมกมฺ อาคตฺย ปศฺยต รุ กิมฺ อภิษิกฺโต น ภวติ ? ");
INSERT INTO santha_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ตตเสฺต นคราทฺ พหิราคตฺย ตาตสฺย สมีปมฺ อายนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","เอตรฺหิ ศิษฺยา: สาธยิตฺวา ตํ วฺยาหารฺษุ: เห คุโร ภวานฺ กิญฺจิทฺ ภูกฺตำฯ ");
INSERT INTO santha_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ตต: โสวททฺ ยุษฺมาภิรฺยนฺน ชฺญายเต ตาทฺฤศํ ภกฺษฺยํ มมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ตทา ศิษฺยา: ปรสฺปรํ ปฺรษฺฏุมฺ อารมฺภนฺต, กิมไสฺม โกปิ กิมปิ ภกฺษฺยมานีย ทตฺตวานฺ? ");
INSERT INTO santha_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ยีศุรโวจตฺ มตฺเปฺรรกสฺยาภิมตานุรูปกรณํ ตไสฺยว กรฺมฺมสิทฺธิการณญฺจ มม ภกฺษฺยํฯ ");
INSERT INTO santha_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","มาสจตุษฺฏเย ชาเต ศสฺยกรฺตฺตนสมโย ภวิษฺยตีติ วากฺยํ ยุษฺมาภิ: กึ โนทฺยเต? กินฺตฺวหํ วทามิ, ศิร อุตฺโตลฺย เกฺษตฺราณิ ปฺรติ นิรีกฺษฺย ปศฺยต, อิทานีํ กรฺตฺตนโยคฺยานิ ศุกฺลวรฺณานฺยภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ยศฺฉินตฺติ ส เวตนํ ลภเต อนนฺตายุ:สฺวรูปํ ศสฺยํ ส คฺฤหฺลาติ จ, เตไนว วปฺตา เฉตฺตา จ ยุคปทฺ อานนฺทต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","อิตฺถํ สติ วปเตฺยกศฺฉินตฺยนฺย อิติ วจนํ สิทฺธฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ยตฺร ยูยํ น ปรฺยฺยศฺรามฺยต ตาทฺฤศํ ศสฺยํ เฉตฺตุํ ยุษฺมานฺ ไปฺรรยมฺ อเนฺย ชนา:ปรฺยฺยศฺรามฺยนฺ ยูยํ เตษำ ศฺรคสฺย ผลมฺ อลภธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ยสฺมินฺ กาเล ยทฺยตฺ กรฺมฺมาการฺษํ ตตฺสรฺวฺวํ ส มหฺยมฺ อกถยตฺ ตสฺยา วนิตายา อิทํ สากฺษฺยวากฺยํ ศฺรุตฺวา ตนฺนครนิวาสิโน พหว: โศมิโรณียโลกา วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ตถา จ ตสฺยานฺติเก สมุปสฺถาย เสฺวษำ สนฺนิเธา กติจิทฺ ทินานิ สฺถาตุํ ตสฺมินฺ วินยมฺ อกุรฺวฺวาน ตสฺมาตฺ ส ทินทฺวยํ ตตฺสฺถาเน นฺยวษฺฏตฺ ");
INSERT INTO santha_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ตตสฺตโสฺยปเทเศน พหโว'ปเร วิศฺวสฺย ");
INSERT INTO santha_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ตำ โยษามวทนฺ เกวลํ ตว วาเกฺยน ปฺรตีม อิติ น, กินฺตุ ส ชคโต'ภิษิกฺตสฺตฺราเตติ ตสฺย กถำ ศฺรุตฺวา วยํ สฺวยเมวาชฺญาสมหิฯ ");
INSERT INTO santha_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","สฺวเทเศ ภวิษฺยทฺวกฺตุ: สตฺกาโร นาสฺตีติ ยทฺยปิ ยีศุ: ปฺรมาณํ ทตฺวากถยตฺ ");
INSERT INTO santha_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ตถาปิ ทิวสทฺวยาตฺ ปรํ ส ตสฺมาตฺ สฺถานาทฺ คาลีลํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","อนนฺตรํ เย คาลีลี ลิยโลกา อุตฺสเว คตา อุตฺสวสมเย ยิรูศลมฺ นคเร ตสฺย สรฺวฺวา: กฺริยา อปศฺยนฺ เต คาลีลมฺ อาคตํ ตมฺ อาคฺฤหฺลนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ตต: ปรมฺ ยีศุ รฺยสฺมินฺ กานฺนานคเร ชลํ ทฺรากฺษารสมฺ อากโรตฺ ตตฺ สฺถานํ ปุนรคาตฺฯ ตสฺมินฺเนว สมเย กสฺยจิทฺ ราชสภาสฺตารสฺย ปุตฺร: กผรฺนาหูมปุรี โรคคฺรสฺต อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ส เยหูทียเทศาทฺ ยีโศ รฺคาลีลาคมนวารฺตฺตำ นิศมฺย ตสฺย สมีปํ คตฺวา ปฺรารฺถฺย วฺยาหฺฤตวานฺ มม ปุตฺรสฺย ปฺราเยณ กาล อาสนฺน: ภวานฺ อาคตฺย ตํ สฺวสฺถํ กโรตุฯ ");
INSERT INTO santha_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ตทา ยีศุรกถยทฺ อาศฺจรฺยฺยํ กรฺมฺม จิตฺรํ จิหฺนํ จ น ทฺฤษฺฏา ยูยํ น ปฺรเตฺยษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ตต: ส สภาสทวทตฺ เห มเหจฺฉ มม ปุเตฺร น มฺฤเต ภวานาคจฺฉตุฯ ");
INSERT INTO santha_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ยีศุสฺตมวททฺ คจฺฉ ตว ปุโตฺร'ชีวีตฺ ตทา ยีศุโนกฺตวาเกฺย ส วิศฺวสฺย คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","คมนกาเล มารฺคมเธฺย ทาสาสฺตํ สากฺษาตฺปฺราปฺยาวทนฺ ภวต: ปุโตฺร'ชีวีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ตต: กํ กาลมารภฺย โรคปฺรตีการารมฺโภ ชาตา อิติ ปฺฤษฺเฏ ไตรุกฺตํ หฺย: สารฺทฺธทณฺฑทฺวยาธิกทฺวิตียยาเม ตสฺย ชฺวรตฺยาโค'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ตทา ยีศุสฺตสฺมินฺ กฺษเณ โปฺรกฺตวานฺ ตว ปุโตฺร'ชีวีตฺ ปิตา ตทฺพุทฺธฺวา สปริวาโร วฺยศฺวสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ยิหูทียเทศาทฺ อาคตฺย คาลีลิ ยีศุเรตทฺ ทฺวิตียมฺ อาศฺจรฺยฺยกรฺมฺมากโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ตต: ปรํ ยิหูทียานามฺ อุตฺสว อุปสฺถิเต ยีศุ รฺยิรูศาลมํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ตสฺมินฺนคเร เมษนามฺโน ทฺวารสฺย สมีเป อิพฺรียภาษยา ไพเถสฺทา นามฺนา ปิษฺกริณี ปญฺจฆฏฺฏยุกฺตาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ตสฺยาเสฺตษุ ฆฏฺเฏษุ กิลาลกมฺปนมฺ อเปกฺษฺย อนฺธขญฺจศุษฺกางฺคาทโย พหโว โรคิณ: ปตนฺตสฺติษฺฐนฺติ สฺมฯ ");
INSERT INTO santha_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ยโต วิเศษกาเล ตสฺย สรโส วาริ สฺวรฺคียทูต เอตฺยากมฺปยตฺ ตตฺกีลาลกมฺปนาตฺ ปรํ ย: กศฺจิทฺ โรคี ปฺรถมํ ปานียมวาโรหตฺ ส เอว ตตฺกฺษณาทฺ โรคมุกฺโต'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ตทาษฺฏาตฺรึศทฺวรฺษาณิ ยาวทฺ โรคคฺรสฺต เอกชนสฺตสฺมินฺ สฺถาเน สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ยีศุสฺตํ ศยิตํ ทฺฤษฺฏฺวา พหุกาลิกโรคีติ ชฺญาตฺวา วฺยาหฺฤตวานฺ ตฺวํ กึ สฺวโสฺถ พุภูษสิ? ");
INSERT INTO santha_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ตโต โรคี กถิตวานฺ เห มเหจฺฉ ยทา กีลาลํ กมฺปเต ตทา มำ ปุษฺกริณีมฺ อวโรหยิตุํ มม โกปิ นาสฺติ, ตสฺมานฺ มม คมนกาเล กศฺจิทโนฺย'โคฺร คตฺวา อวโรหติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ตทา ยีศุรกถยทฺ อุตฺติษฺฐ, ตว ศยฺยามุตฺโตลฺย คฺฤหีตฺวา ยาหิฯ ");
INSERT INTO santha_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ส ตตฺกฺษณาตฺ สฺวโสฺถ ภูตฺวา ศยฺยามุตฺโตลฺยาทาย คตวานฺ กินฺตุ ตทฺทินํ วิศฺรามวาร:ฯ ");
INSERT INTO santha_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ตสฺมาทฺ ยิหูทียา: สฺวสฺถํ นรํ วฺยาหรนฺ อทฺย วิศฺรามวาเร ศยนียมาทาย น ยาตวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ตต: ส ปฺรตฺยโวจทฺ โย มำ สฺวสฺถมฺ อการฺษีตฺ ศยนียมฺ อุตฺโตลฺยาทาย ยาตุํ มำ ส เอวาทิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ตทา เต'ปฺฤจฺฉนฺ ศยนียมฺ อุตฺโตลฺยาทาย ยาตุํ ย อาชฺญาปยตฺ ส ก:? ");
INSERT INTO santha_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","กินฺตุ ส ก อิติ สฺวสฺถีภูโต นาชานาทฺ ยตสฺตสฺมินฺ สฺถาเน ชนตาสตฺตฺวาทฺ ยีศุ: สฺถานานฺตรมฺ อาคมตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ตต: ปรํ เยศุ รฺมนฺทิเร ตํ นรํ สากฺษาตฺปฺราปฺยากถยตฺ ปเศฺยทานีมฺ อนามโย ชาโตสิ ยถาธิกา ทุรฺทศา น ฆฏเต ตทฺเธโต: ปาปํ กรฺมฺม ปุนรฺมาการฺษี:ฯ ");
INSERT INTO santha_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ตต: ส คตฺวา ยิหูทียานฺ อวททฺ ยีศุ รฺมามฺ อโรคิณมฺ อการฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ตโต ยีศุ รฺวิศฺรามวาเร กรฺมฺเมทฺฤศํ กฺฤตวานฺ อิติ เหโต รฺยิหูทียาสฺตํ ตาฑยิตฺวา หนฺตุมฺ อเจษฺฏนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ยีศุสฺตานาขฺยตฺ มม ปิตา ยตฺ การฺยฺยํ กโรติ ตทนุรูปมฺ อหมปิ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ตโต ยิหูทียาสฺตํ หนฺตุํ ปุนรยตนฺต ยโต วิศฺรามวารํ นามนฺยต ตเทว เกวลํ น อธิกนฺตุ อีศฺวรํ สฺวปิตรํ โปฺรจฺย สฺวมปีศฺวรตุลฺยํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ปศฺจาทฺ ยีศุรวททฺ ยุษฺมานหํ ยถารฺถตรํ วทามิ ปุตฺร: ปิตรํ ยทฺยตฺ กรฺมฺม กุรฺวฺวนฺตํ ปศฺยติ ตทติริกฺตํ เสฺวจฺฉาต: กิมปิ กรฺมฺม กรฺตฺตุํ น ศกฺโนติฯ ปิตา ยตฺ กโรติ ปุโตฺรปิ ตเทว กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ปิตา ปุเตฺร เสฺนหํ กโรติ ตสฺมาตฺ สฺวยํ ยทฺยตฺ กรฺมฺม กโรติ ตตฺสรฺวฺวํ ปุตฺรํ ทรฺศยติ ; ยถา จ ยุษฺมากํ อาศฺจรฺยฺยชฺญานํ ชนิษฺยเต ตทรฺถมฺ อิโตปิ มหากรฺมฺม ตํ ทรฺศยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","วสฺตุตสฺตุ ปิตา ยถา ปฺรมิตานฺ อุตฺถาปฺย สชิวานฺ กโรติ ตทฺวตฺ ปุโตฺรปิ ยํ ยํ อิจฺฉติ ตํ ตํ สชีวํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","สรฺเวฺว ปิตรํ ยถา สตฺกุรฺวฺวนฺติ ตถา ปุตฺรมปิ สตฺการยิตุํ ปิตา สฺวยํ กสฺยาปิ วิจารมกฺฤตฺวา สรฺวฺววิจาราณำ ภารํ ปุเตฺร สมรฺปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ย: ปุตฺรํ สตฺ กโรติ ส ตสฺย เปฺรรกมปิ สตฺ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ยุษฺมานาหํ ยถารฺถตรํ วทามิ โย ชโน มม วากฺยํ ศฺรุตฺวา มตฺเปฺรรเก วิศฺวสิติ โสนนฺตายุ: ปฺราปฺโนติ กทาปิ ทณฺฑพาชนํ น ภวติ นิธนาทุตฺถาย ปรมายุ: ปฺราปฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","อหํ ยุษฺมานติยถารฺถํ วทามิ ยทา มฺฤตา อีศฺวรปุตฺรสฺย นินาทํ โศฺรษฺยนฺติ เย จ โศฺรษฺยนฺติ เต สชีวา ภวิษฺยนฺติ สมย เอตาทฺฤศ อายาติ วรมฺ อิทานีมปฺยุปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ปิตา ยถา สฺวยญฺชีวี ตถา ปุตฺราย สฺวยญฺชีวิตฺวาธิการํ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ส มนุษฺยปุตฺร: เอตสฺมาตฺ การณาตฺ ปิตา ทณฺฑกรณาธิการมปิ ตสฺมินฺ สมรฺปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","เอตทรฺเถ ยูยมฺ อาศฺจรฺยฺยํ น มนฺยธฺวํ ยโต ยสฺมินฺ สมเย ตสฺย นินาทํ ศฺรุตฺวา ศฺมศานสฺถา: สรฺเวฺว พหิราคมิษฺยนฺติ สมย เอตาทฺฤศ อุปสฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ตสฺมาทฺ เย สตฺกรฺมฺมาณิ กฺฤตวนฺตสฺต อุตฺถาย อายุ: ปฺราปฺสฺยนฺติ เย จ กุกรฺมาณิ กฺฤตวนฺตสฺต อุตฺถาย ทณฺฑํ ปฺราปฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","อหํ สฺวยํ กิมปิ กรฺตฺตุํ น ศกฺโนมิ ยถา ศุโณมิ ตถา วิจารยามิ มม วิจารญฺจ นฺยายฺย: ยโตหํ สฺวียาภีษฺฏํ เนหิตฺวา มตฺเปฺรรยิตุ: ปิตุริษฺฏมฺ อีเหฯ ");
INSERT INTO santha_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ยทิ สฺวสฺมินฺ สฺวยํ สากฺษฺยํ ททามิ ตรฺหิ ตตฺสากฺษฺยมฺ อาคฺราหฺยํ ภวติ ; ");
INSERT INTO santha_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","กินฺตุ มทรฺเถ'ปโร ชน: สากฺษฺยํ ททาติ มทรฺเถ ตสฺย ยตฺ สากฺษฺยํ ตตฺ สตฺยมฺ เอตทปฺยหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ยุษฺมาภิ โรฺยหนํ ปฺรติ โลเกษุ เปฺรริเตษุ ส สตฺยกถายำ สากฺษฺยมททาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","มานุษาทหํ สากฺษฺยํ โนเปกฺเษ ตถาปิ ยูยํ ยถา ปริตฺรยเธฺว ตทรฺถมฺ อิทํ วากฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","โยหนฺ เททีปฺยมาโน ทีป อิว เตชสฺวี สฺถิตวานฺ ยูยมฺ อลฺปกาลํ ตสฺย ทีปฺตฺยานนฺทิตุํ สมมนฺยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","กินฺตุ ตตฺปฺรมาณาทปิ มม คุรุตรํ ปฺรมาณํ วิทฺยเต ปิตา มำ เปฺรษฺย ยทฺยตฺ กรฺมฺม สมาปยิตุํ ศกฺตฺติมททาตฺ มยา กฺฤตํ ตตฺตตฺ กรฺมฺม มทรฺเถ ปฺรมาณํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ย: ปิตา มำ เปฺรริตวานฺ โมปิ มทรฺเถ ปฺรมาณํ ททาติฯ ตสฺย วากฺยํ ยุษฺมาภิ: กทาปิ น ศฺรุตํ ตสฺย รูปญฺจ น ทฺฤษฺฏํ ");
INSERT INTO santha_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ตสฺย วากฺยญฺจ ยุษฺมากมฺ อนฺต: กทาปิ สฺถานํ นาปฺโนติ ยต: ส ยํ เปฺรษิตวานฺ ยูยํ ตสฺมินฺ น วิศฺวสิถฯ ");
INSERT INTO santha_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ธรฺมฺมปุสฺตกานิ ยูยมฺ อาโลจยธฺวํ ไต รฺวาไกฺยรนนฺตายุ: ปฺราปฺสฺยาม อิติ ยูยํ พุธฺยเธฺว ตทฺธรฺมฺมปุสฺตกานิ มทรฺเถ ปฺรมาณํ ททติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ตถาปิ ยูยํ ปรมายุ:ปฺราปฺตเย มม สํนิธิมฺ น ชิคมิษถฯ ");
INSERT INTO santha_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","อหํ มานุเษภฺย: สตฺการํ น คฺฤหฺลามิฯ ");
INSERT INTO santha_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","อหํ ยุษฺมานฺ ชานามิ; ยุษฺมากมนฺตร อีศฺวรเปฺรม นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","อหํ นิชปิตุ รฺนามฺนาคโตสฺมิ ตถาปิ มำ น คฺฤหฺลีถ กินฺตุ กศฺจิทฺ ยทิ สฺวนามฺนา สมาคมิษฺยติ ตรฺหิ ตํ คฺรหีษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ยูยมฺ อีศฺวราตฺ สตฺการํ น จิษฺฏตฺวา เกวลํ ปรสฺปรํ สตฺการมฺ เจทฺ อาทธฺเวฺว ตรฺหิ กถํ วิศฺวสิตุํ ศกฺนุถ? ");
INSERT INTO santha_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ปุตุ: สมีเป'หํ ยุษฺมานฺ อปวทิษฺยามีติ มา จินฺตยต ยสฺมินฺ , ยสฺมินฺ ยุษฺมากํ วิศฺวส: เสอว มูสา ยุษฺมานฺ อปวทติฯ ");
INSERT INTO santha_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ยทิ ยูยํ ตสฺมินฺ วฺยศฺวสิษฺยต ตรฺหิ มยฺยปิ วฺยศฺวสิษฺยต, ยตฺ ส มยิ ลิขิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ตโต ยทิ เตน ลิขิตวานิ น ปฺรติถ ตรฺหิ มม วากฺยานิ กถํ ปฺรเตฺยษฺยถ? ");
INSERT INTO santha_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ตต: ปรํ ยีศุ รฺคาลีลฺ ปฺรเทศียสฺย ติวิริยานามฺน: สินฺโธ: ปารํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ตโต วฺยาธิมโลฺลกสฺวาสฺถฺยกรณรูปาณิ ตสฺยาศฺจรฺยฺยาณิ กรฺมฺมาณิ ทฺฤษฺฏฺวา พหโว ชนาสฺตตฺปศฺจาทฺ อคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ตโต ยีศุ: ปรฺวฺวตมารุหฺย ตตฺร ศิไษฺย: สากมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ตสฺมินฺ สมย นิสฺตาโรตฺสวนามฺนิ ยิหูทียานาม อุตฺสว อุปสฺถิเต ");
INSERT INTO santha_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ยีศุ เรฺนเตฺร อุตฺโตลฺย พหุโลกานฺ สฺวสมีปาคตานฺ วิโลกฺย ผิลิปํ ปฺฤษฺฏวานฺ เอเตษำ โภชนาย โภชทฺรวฺยาณิ วยํ กุตฺร เกฺรตุํ ศกฺรุม:? ");
INSERT INTO santha_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","วากฺยมิทํ ตสฺย ปรีกฺษารฺถมฺ อวาทีตฺ กินฺตุ ยตฺ กริษฺยติ ตตฺ สฺวยมฺ อชานาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ผิลิป: ปฺรตฺยโวจตฺ เอเตษามฺ เอไกโก ยทฺยลฺปมฺ อลฺปํ ปฺราปฺโนติ ตรฺหิ มุทฺราปาททฺวิศเตน กฺรีตปูปา อปิ นฺยูนา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ศิโมนฺ ปิตรสฺย ภฺราตา อานฺทฺริยาขฺย: ศิษฺยาณาเมโก วฺยาหฺฤตวานฺ ");
INSERT INTO santha_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","อตฺร กสฺยจิทฺ พาลกสฺย สมีเป ปญฺจ ยาวปูปา: กฺษุทฺรมตฺสฺยทฺวยญฺจ สนฺติ กินฺตุ โลกานำ เอตาวาตำ มเธฺย ไต: กึ ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ปศฺจาทฺ ยีศุรวทตฺ โลกานุปเวศยต ตตฺร พหุยวสสตฺตฺวาตฺ ปญฺจสหสฺเตฺรโภฺย นฺยูนา อธิกา วา ปุรุษา ภูมฺยามฺ อุปาวิศนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ตโต ยีศุสฺตานฺ ปูปานาทาย อีศฺวรสฺย คุณานฺ กีรฺตฺตยิตฺวา ศิเษฺยษุ สมารฺปยตฺ ตตเสฺต เตภฺย อุปวิษฺฏโลเกภฺย: ปูปานฺ ยเถษฺฏมตฺสฺยญฺจ ปฺราทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","เตษุ ตฺฤปฺเตษุ ส ตานโวจทฺ เอเตษำ กิญฺจิทปิ ยถา นาปจียเต ตถา สรฺวฺวาณฺยวศิษฺฏานิ สํคฺฤหฺลีตฯ ");
INSERT INTO santha_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ตต: สรฺเวฺวษำ โภชนาตฺ ปรํ เต เตษำ ปญฺจานำ ยาวปูปานำ อวศิษฺฏานฺยขิลานิ สํคฺฤหฺย ทฺวาทศฑลฺลกานฺ อปูรยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","อปรํ ยีโศเรตาทฺฤศีมฺ อาศฺจรฺยฺยกฺริยำ ทฺฤษฺฏฺวา โลกา มิโถ วกฺตุมาเรภิเร ชคติ ยสฺยาคมนํ ภวิษฺยติ ส เอวายมฺ อวศฺยํ ภวิษฺยทฺวกฺตฺตาฯ ");
INSERT INTO santha_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","อเตอว โลกา อาคตฺย ตมากฺรมฺย ราชานํ กริษฺยนฺติ ยีศุเสฺตษามฺ อีทฺฤศํ มานสํ วิชฺญาย ปุนศฺจ ปรฺวฺวตมฺ เอกากี คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","สายํกาล อุปสฺถิเต ศิษฺยา ชลธิตฏํ วฺรชิตฺวา นาวมารุหฺย นครทิศิ สินฺเธา วาหยิตฺวาคมนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ตสฺมินฺ สมเย ติมิร อุปาติษฺฐตฺ กินฺตุ ยีษุเสฺตษำ สมีปํ นาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ตทา ปฺรพลปวนวหนาตฺ สาคเร มหาตรงฺโค ภวิตุมฺ อาเรเภฯ ");
INSERT INTO santha_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ตตเสฺต วาหยิตฺวา ทฺวิตฺรานฺ โกฺรศานฺ คตา: ปศฺจาทฺ ยีศุํ ชลเธรุปริ ปทฺภฺยำ วฺรชนฺตํ เนากานฺติกมฺ อาคจฺฉนฺตํ วิโลกฺย ตฺราสยุกฺตา อภวนฺ ");
INSERT INTO santha_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","กินฺตุ ส ตานุกฺตฺตวานฺ อยมหํ มา ไภษฺฏฯ ");
INSERT INTO santha_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ตทา เต ตํ ไสฺวรํ นาวิ คฺฤหีตวนฺต: ตทา ตตฺกฺษณาทฺ อุทฺทิษฺฏสฺถาเน เนารุปาสฺถาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ยยา นาวา ศิษฺยา อคจฺฉนฺ ตทนฺยา กาปิ เนากา ตสฺมินฺ สฺถาเน นาสีตฺ ตโต ยีศุ: ศิไษฺย: สากํ นาคมตฺ เกวลา: ศิษฺยา อคมนฺ เอตตฺ ปารสฺถา โลกา ชฺญาตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","กินฺตุ ตต: ปรํ ปฺรภุ รฺยตฺร อีศฺวรสฺย คุณานฺ อนุกีรฺตฺตฺย โลกานฺ ปูปานฺ อโภชยตฺ ตตฺสฺถานสฺย สมีปสฺถติวิริยายา อปราสฺตรณย อาคมนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ยีศุสฺตตฺร นาสฺติ ศิษฺยา อปิ ตตฺร นา สนฺติ โลกา อิติ วิชฺญาย ยีศุํ คเวษยิตุํ ตรณิภิ: กผรฺนาหูมฺ ปุรํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ตตเสฺต สริตฺปเต: ปาเร ตํ สากฺษาตฺ ปฺราปฺย ปฺราโวจนฺ เห คุโร ภวานฺ อตฺร สฺถาเน กทาคมตฺ? ");
INSERT INTO santha_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ตทา ยีศุสฺตานฺ ปฺรตฺยวาทีทฺ ยุษฺมานหํ ยถารฺถตรํ วทามิ อาศฺจรฺยฺยกรฺมฺมทรฺศนาทฺเธโต รฺน กินฺตุ ปูปโภชนาตฺ เตน ตฺฤปฺตตฺวาญฺจ มำ คเวษยถฯ ");
INSERT INTO santha_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","กฺษยณียภกฺษฺยารฺถํ มา ศฺรามิษฺฏ กินฺตฺวนฺตายุรฺภกฺษฺยารฺถํ ศฺรามฺยต, ตสฺมาตฺ ตาทฺฤศํ ภกฺษฺยํ มนุชปุโตฺร ยุษฺมาภฺยํ ทาสฺยติ; ตสฺมินฺ ตาต อีศฺวร: ปฺรมาณํ ปฺราทาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ตทา เต'ปฺฤจฺฉนฺ อีศฺวราภิมตํ กรฺมฺม กรฺตฺตุมฺ อสฺมาภิ: กึ กรฺตฺตวฺยํ? ");
INSERT INTO santha_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ตโต ยีศุรวททฺ อีศฺวโร ยํ ไปฺรรยตฺ ตสฺมินฺ วิศฺวสนมฺ อีศฺวราภิมตํ กรฺมฺมฯ ");
INSERT INTO santha_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ตทา เต วฺยาหรนฺ ภวตา กึ ลกฺษณํ ทรฺศิตํ ยทฺทฺฤษฺฏฺวา ภวติ วิศฺวสิษฺยาม:? ตฺวยา กึ กรฺมฺม กฺฤตํ? ");
INSERT INTO santha_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","อสฺมากํ ปูรฺวฺวปุรุษา มหาปฺรานฺตเร มานฺนำ โภกฺตฺตุํ ปฺราปุ: ยถา ลิปิราเสฺตฯ สฺวรฺคียาณิ ตุ ภกฺษฺยาณิ ปฺรทเทา ปรเมศฺวร:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ตทา ยีศุรวททฺ อหํ ยุษฺมานติยถารฺถํ วทามิ มูสา ยุษฺมาภฺยํ สฺวรฺคียํ ภกฺษฺยํ นาทาตฺ กินฺตุ มม ปิตา ยุษฺมาภฺยํ สฺวรฺคียํ ปรมํ ภกฺษฺยํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ย: สฺวรฺคาทวรุหฺย ชคเต ชีวนํ ททาติ ส อีศฺวรทตฺตภกฺษฺยรูป:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ตทา เต ปฺราโวจนฺ เห ปฺรโภ ภกฺษฺยมิทํ นิตฺยมสฺมภฺยํ ททาตุฯ ");
INSERT INTO santha_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ยีศุรวททฺ อหเมว ชีวนรูปํ ภกฺษฺยํ โย ชโน มม สนฺนิธิมฺ อาคจฺฉติ ส ชาตุ กฺษุธารฺตฺโต น ภวิษฺยติ, ตถา โย ชโน มำ ปฺรเตฺยติ ส ชาตุ ตฺฤษารฺตฺโต น ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","มำ ทฺฤษฺฏฺวาปิ ยูยํ น วิศฺวสิถ ยุษฺมานหมฺ อิตฺยโวจํฯ ");
INSERT INTO santha_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ปิตา มหฺยํ ยาวโต โลกานททาตฺ เต สรฺวฺว เอว มมานฺติกมฺ อาคมิษฺยนฺติ ย: กศฺจิจฺจ มม สนฺนิธิมฺ อายาสฺยติ ตํ เกนาปิ ปฺรกาเรณ น ทูรีกริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","นิชาภิมตํ สาธยิตุํ น หิ กินฺตุ เปฺรรยิตุรภิมตํ สาธยิตุํ สฺวรฺคาทฺ อาคโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ส ยานฺ ยานฺ โลกานฺ มหฺยมททาตฺ เตษาเมกมปิ น หารยิตฺวา เศษทิเน สรฺวฺวานหมฺ อุตฺถาปยามิ อิทํ มตฺเปฺรรยิตุ: ปิตุรภิมตํฯ ");
INSERT INTO santha_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ย: กศฺจินฺ มานวสุตํ วิโลกฺย วิศฺวสิติ ส เศษทิเน มโยตฺถาปิต: สนฺ อนนฺตายุ: ปฺราปฺสฺยติ อิติ มตฺเปฺรรกสฺยาภิมตํฯ ");
INSERT INTO santha_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ตทา สฺวรฺคาทฺ ยทฺ ภกฺษฺยมฺ อวาโรหตฺ ตทฺ ภกฺษฺยมฺ อหเมว ยิหูทียโลกาสฺตไสฺยตทฺ วาเกฺย วิวทมานา วกฺตฺตุมาเรภิเร ");
INSERT INTO santha_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ยูษผ: ปุโตฺร ยีศุ รฺยสฺย มาตาปิตเรา วยํ ชานีม เอษ กึ เสอว น? ตรฺหิ สฺวรฺคาทฺ อวาโรหมฺ อิติ วากฺยํ กถํ วกฺตฺติ? ");
INSERT INTO santha_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ตทา ยีศุสฺตานฺ ปฺรตฺยวทตฺ ปรสฺปรํ มา วิวทธฺวํ ");
INSERT INTO santha_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","มตฺเปฺรรเกณ ปิตฺรา นากฺฤษฺฏ: โกปิ ชโน มมานฺติกมฺ อายาตุํ น ศกฺโนติ กินฺตฺวาคตํ ชนํ จรเม'หฺนิ โปฺรตฺถาปยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","เต สรฺวฺว อีศฺวเรณ ศิกฺษิตา ภวิษฺยนฺติ ภวิษฺยทฺวาทินำ คฺรนฺเถษุ ลิปิริตฺถมาเสฺต อโต ย: กศฺจิตฺ ปิตุ: สกาศาตฺ ศฺรุตฺวา ศิกฺษเต ส เอว มม สมีปมฺ อาคมิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ย อีศฺวราทฺ อชายต ตํ วินา โกปิ มนุโษฺย ชนกํ นาทรฺศตฺ เกวล: เสอว ตาตมฺ อทฺรากฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","อหํ ยุษฺมานฺ ยถารฺถตรํ วทามิ โย ชโน มยิ วิศฺวาสํ กโรติ โสนนฺตายุ: ปฺราปฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","อหเมว ตชฺชีวนภกฺษฺยํฯ ");
INSERT INTO santha_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ยุษฺมากํ ปูรฺวฺวปุรุษา มหาปฺรานฺตเร มนฺนาภกฺษฺยํ ภูกฺตฺตาปิ มฺฤตา: ");
INSERT INTO santha_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","กินฺตุ ยทฺภกฺษฺยํ สฺวรฺคาทาคจฺฉตฺ ตทฺ ยทิ กศฺจิทฺ ภุงฺกฺตฺเต ตรฺหิ ส น มฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ยชฺชีวนภกฺษฺยํ สฺวรฺคาทาคจฺฉตฺ โสหเมว อิทํ ภกฺษฺยํ โย ชโน ภุงฺกฺตฺเต ส นิตฺยชีวี ภวิษฺยติฯ ปุนศฺจ ชคโต ชีวนารฺถมหํ ยตฺ สฺวกียปิศิตํ ทาสฺยามิ ตเทว มยา วิตริตํ ภกฺษฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ตสฺมาทฺ ยิหูทียา: ปรสฺปรํ วิวทมานา วกฺตฺตุมาเรภิเร เอษ โภชนารฺถํ สฺวียํ ปลลํ กถมฺ อสฺมภฺยํ ทาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ตทา ยีศุสฺตานฺ อาโวจทฺ ยุษฺมานหํ ยถารฺถตรํ วทามิ มนุษฺยปุตฺรสฺยามิเษ ยุษฺมาภิ รฺน ภุกฺตฺเต ตสฺย รุธิเร จ น ปีเต ชีวเนน สารฺทฺธํ ยุษฺมากํ สมฺพนฺโธ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","โย มมามิษํ สฺวาทติ มม สุธิรญฺจ ปิวติ โสนนฺตายุ: ปฺราปฺโนติ ตต: เศเษ'หฺนิ ตมหมฺ อุตฺถาปยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ยโต มทียมามิษํ ปรมํ ภกฺษฺยํ ตถา มทียํ โศณิตํ ปรมํ เปยํฯ ");
INSERT INTO santha_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","โย ชโน มทียํ ปลลํ สฺวาทติ มทียํ รุธิรญฺจ ปิวติ ส มยิ วสติ ตสฺมินฺนหญฺจ วสามิฯ ");
INSERT INTO santha_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","มตฺเปฺรรยิตฺรา ชีวตา ตาเตน ยถาหํ ชีวามิ ตทฺวทฺ ย: กศฺจินฺ มามตฺติ โสปิ มยา ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ยทฺภกฺษฺยํ สฺวรฺคาทาคจฺฉตฺ ตทิทํ ยนฺมานฺนำ สฺวาทิตฺวา ยุษฺมากํ ปิตโร'มฺริยนฺต ตาทฺฤศมฺ อิทํ ภกฺษฺยํ น ภวติ อิทํ ภกฺษฺยํ โย ภกฺษติ ส นิตฺยํ ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ยทา กผรฺนาหูมฺ ปุรฺยฺยำ ภชนเคเห อุปาทิศตฺ ตทา กถา เอตา อกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ตเทตฺถํ ศฺรุตฺวา ตสฺย ศิษฺยาณามฺ อเนเก ปรสฺปรมฺ อกถยนฺ อิทํ คาฒํ วากฺยํ วากฺยมีทฺฤศํ ก: โศฺรตุํ ศกฺรุยาตฺ? ");
INSERT INTO santha_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","กินฺตุ ยีศุ: ศิษฺยาณามฺ อิตฺถํ วิวาทํ สฺวจิตฺเต วิชฺญาย กถิตวานฺ อิทํ วากฺยํ กึ ยุษฺมากํ วิฆฺนํ ชนยติ? ");
INSERT INTO santha_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ยทิ มนุชสุตํ ปูรฺวฺววาสสฺถานมฺ อูรฺทฺวฺวํ คจฺฉนฺตํ ปศฺยถ ตรฺหิ กึ ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","อาตฺไมว ชีวนทายก: วปุ รฺนิษฺผลํ ยุษฺมภฺยมหํ ยานิ วจำสิ กถยามิ ตานฺยาตฺมา ชีวนญฺจฯ ");
INSERT INTO santha_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","กินฺตุ ยุษฺมากํ มเธฺย เกจน อวิศฺวาสิน: สนฺติ เก เก น วิศฺวสนฺติ โก วา ตํ ปรกเรษุ สมรฺปยิษฺยติ ตานฺ ยีศุราปฺรถมาทฺ เวตฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","อปรมปิ กถิตวานฺ อสฺมาตฺ การณาทฺ อกถยํ ปิตุ: สกาศาตฺ ศกฺตฺติมปฺราปฺย โกปิ มมานฺติกมฺ อาคนฺตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ตตฺกาเล'เนเก ศิษฺยา วฺยาฆุฏฺย เตน สารฺทฺธํ ปุน รฺนาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ตทา ยีศุ รฺทฺวาทศศิษฺยานฺ อุกฺตฺตวานฺ ยูยมปิ กึ ยาสฺยถ? ");
INSERT INTO santha_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ตต: ศิโมนฺ ปิตร: ปฺรตฺยโวจตฺ เห ปฺรโภ กสฺยาภฺยรฺณํ คมิษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","อนนฺตชีวนทายิโนฺย ยา: กถาสฺตาสฺตไววฯ ภวานฺ อมเรศฺวรสฺยาภิษิกฺตฺตปุตฺร อิติ วิศฺวสฺย นิศฺจิตํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ตทา ยีศุรวทตฺ กิมหํ ยุษฺมากํ ทฺวาทศชนานฺ มโนนีตานฺ น กฺฤตวานฺ? กินฺตุ ยุษฺมากํ มเธฺยปิ กศฺจิเทโก วิฆฺนการี วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","อิมำ กถํ ส ศิโมน: ปุตฺรมฺ อีษฺกรีโยตียํ ยิหูทามฺ อุทฺทิศฺย กถิตวานฺ ยโต ทฺวาทศานำ มเธฺย คณิต: ส ตํ ปรกเรษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ตต: ปรํ ยิหูทียโลกาสฺตํ หนฺตุํ สไมหนฺต ตสฺมาทฺ ยีศุ รฺยิหูทาปฺรเทเศ ปรฺยฺยฏิตุํ เนจฺฉนฺ คาลีลฺ ปฺรเทเศ ปรฺยฺยฏิตุํ ปฺรารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","กินฺตุ ตสฺมินฺ สมเย ยิหูทียานำ ทูษฺยวาสนาโมตฺสว อุปสฺถิเต ");
INSERT INTO santha_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ตสฺย ภฺราตรสฺตมฺ อวทนฺ ยานิ กรฺมฺมาณิ ตฺวยา กฺริยนฺเต ตานิ ยถา ตว ศิษฺยา: ปศฺยนฺติ ตทรฺถํ ตฺวมิต: สฺถานาทฺ ยิหูทียเทศํ วฺรชฯ ");
INSERT INTO santha_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ย: กศฺจิตฺ สฺวยํ ปฺรจิกาศิษติ ส กทาปิ คุปฺตํ กรฺมฺม น กโรติ ยทีทฺฤศํ กรฺมฺม กโรษิ ตรฺหิ ชคติ นิชํ ปริจายยฯ ");
INSERT INTO santha_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ยตสฺตสฺย ภฺราตโรปิ ตํ น วิศฺวสนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ตทา ยีศุสฺตานฺ อโวจตฺ มม สมย อิทานีํ โนปติษฺฐติ กินฺตุ ยุษฺมากํ สมย: สตตมฺ อุปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ชคโต โลกา ยุษฺมานฺ ฤตียิตุํ น ศกฺรุวนฺติ กินฺตุ มาเมว ฤตียนฺเต ยตเสฺตษำ กรฺมาณิ ทุษฺฏานิ ตตฺร สากฺษฺยมิทมฺ อหํ ททามิฯ ");
INSERT INTO santha_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","อเตอว ยูยมฺ อุตฺสเว'สฺมินฺ ยาต นาหมฺ อิทานีมฺ อสฺมินฺนุตฺสเว ยามิ ยโต มม สมย อิทานีํ น สมฺปูรฺณ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","อิติ วากฺยมฺ อุกฺตฺตฺวา ส คาลีลิ สฺถิตวานฺ ");
INSERT INTO santha_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","กินฺตุ ตสฺย ภฺราตฺฤษุ ตตฺร ปฺรสฺถิเตษุ สตฺสุ โส'ปฺรกฏ อุตฺสวมฺ อคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","อนนฺตรมฺ อุตฺสวมฺ อุปสฺถิตา ยิหูทียาสฺตํ มฺฤคยิตฺวาปฺฤจฺฉนฺ ส กุตฺร? ");
INSERT INTO santha_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ตโต โลกานำ มเธฺย ตสฺมินฺ นานาวิธา วิวาทา ภวิตุมฺ อารพฺธวนฺต:ฯ เกจิทฺ อโวจนฺ ส อุตฺตม: ปุรุษ: เกจิทฺ อโวจนฺ น ตถา วรํ โลกานำ ภฺรมํ ชนยติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","กินฺตุ ยิหูทียานำ ภยาตฺ โกปิ ตสฺย ปกฺเษ สฺปษฺฏํ นากถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ตต: ปรมฺ อุตฺสวสฺย มธฺยสมเย ยีศุ รฺมนฺทิรํ คตฺวา สมุปทิศติ สฺมฯ ");
INSERT INTO santha_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ตโต ยิหูทียา โลกา อาศฺจรฺยฺยํ ชฺญาตฺวากถยนฺ เอษา มานุโษ นาธีตฺยา กถมฺ เอตาทฺฤโศ วิทฺวานภูตฺ? ");
INSERT INTO santha_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ตทา ยีศุ: ปฺรตฺยโวจทฺ อุปเทโศยํ น มม กินฺตุ โย มำ เปฺรษิตวานฺ ตสฺยฯ ");
INSERT INTO santha_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","โย ชโน นิเทศํ ตสฺย คฺรหีษฺยติ มโมปเทโศ มตฺโต ภวติ กิมฺ อีศฺวราทฺ ภวติ ส คนสฺตชฺชฺญาตุํ ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","โย ชน: สฺวต: กถยติ ส สฺวียํ เคารวมฺ อีหเต กินฺตุ ย: เปฺรรยิตุ เรฺคารวมฺ อีหเต ส สตฺยวาที ตสฺมินฺ โกปฺยธรฺมฺโม นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","มูสา ยุษฺมภฺยํ วฺยวสฺถาคฺรนฺถํ กึ นาททาตฺ? กินฺตุ ยุษฺมากํ โกปิ ตำ วฺยวสฺถำ น สมาจรติฯ มำ หนฺตุํ กุโต ยตเธฺว? ");
INSERT INTO santha_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ตทา โลกา อวทนฺ ตฺวํ ภูตคฺรสฺตสฺตฺวำ หนฺตุํ โก ยตเต? ");
INSERT INTO santha_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ตโต ยีศุรโวจทฺ เอกํ กรฺมฺม มยาการิ ตสฺมาทฺ ยูยํ สรฺวฺว มหาศฺจรฺยฺยํ มนฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","มูสา ยุษฺมภฺยํ ตฺวกฺเฉทวิธึ ปฺรทเทา ส มูสาโต น ชาต: กินฺตุ ปิตฺฤปุรุเษโภฺย ชาต: เตน วิศฺรามวาเร'ปิ มานุษาณำ ตฺวกฺเฉทํ กุรุถฯ ");
INSERT INTO santha_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","อเตอว วิศฺรามวาเร มนุษฺยาณำ ตฺวกฺเฉเท กฺฤเต ยทิ มูสาวฺยวสฺถามงฺคนํ น ภวติ ตรฺหิ มยา วิศฺรามวาเร มานุษ: สมฺปูรฺณรูเปณ สฺวโสฺถ'การิ ตตฺการณาทฺ ยูยํ กึ มหฺยํ กุปฺยถ? ");
INSERT INTO santha_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","สปกฺษปาตํ วิจารมกฺฤตฺวา นฺยายฺยํ วิจารํ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ตทา ยิรูศาลมฺ นิวาสิน: กติปยชนา อกถยนฺ อิเม ยํ หนฺตุํ เจษฺฏนฺเต ส เอวายํ กึ น? ");
INSERT INTO santha_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","กินฺตุ ปศฺยต นิรฺภย: สนฺ กถำ กถยติ ตถาปิ กิมปิ อ วทนฺเตฺยเต อยเมวาภิษิกฺตฺโต ภวตีติ นิศฺจิตํ กิมธิปตโย ชานนฺติ? ");
INSERT INTO santha_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","มนุโชยํ กสฺมาทาคมทฺ อิติ วยํ ชาโนม: กินฺตฺวภิษิกฺตฺต อาคเต ส กสฺมาทาคตวานฺ อิติ โกปิ ชฺญาตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ตทา ยีศุ รฺมเธฺยมนฺทิรมฺ อุปทิศนฺ อุจฺไจ:การมฺ อุกฺตฺตวานฺ ยูยํ กึ มำ ชานีถ? กสฺมาจฺจาคโตสฺมิ ตทปิ กึ ชานีถ? นาหํ สฺวต อาคโตสฺมิ กินฺตุ ย: สตฺยวาที เสอว มำ เปฺรษิตวานฺ ยูยํ ตํ น ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ตมหํ ชาเน เตนาหํ เปฺรริต อคโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ตสฺมาทฺ ยิหูทียาสฺตํ ธรฺตฺตุมฺ อุทฺยตาสฺตถาปิ โกปิ ตสฺย คาเตฺร หสฺตํ นารฺปยทฺ ยโต เหโตสฺตทา ตสฺย สมโย โนปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","กินฺตุ พหโว โลกาสฺตสฺมินฺ วิศฺวสฺย กถิตวานฺโต'ภิษิกฺตฺตปุรุษ อาคตฺย มานุษสฺยาสฺย กฺริยาภฺย: กิมฺ อธิกา อาศฺจรฺยฺยา: กฺริยา: กริษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ตต: ปรํ โลกาสฺตสฺมินฺ อิตฺถํ วิวทนฺเต ผิรูศิน: ปฺรธานยาชกาญฺเจติ ศฺรุตวนฺตสฺตํ ธฺฤตฺวา เนตุํ ปทาติคณํ เปฺรษยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ตโต ยีศุรวททฺ อหมฺ อลฺปทินานิ ยุษฺมาภิ: สารฺทฺธํ สฺถิตฺวา มตฺเปฺรรยิตุ: สมีปํ ยาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","มำ มฺฤคยิษฺยเธฺว กินฺตูทฺเทศํ น ลปฺสฺยเธฺว รตฺร สฺถาสฺยามิ ตตฺร ยูยํ คนฺตุํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ตทา ยิหูทียา: ปรสฺปรํ วกฺตฺตุมาเรภิเร อโสฺยทฺเทศํ น ปฺราปฺสฺยาม เอตาทฺฤศํ กึ สฺถานํ ยาสฺยติ? ภินฺนเทเศ วิกีรฺณานำ ยิหูทียานำ สนฺนิธิมฺ เอษ คตฺวา ตานฺ อุปเทกฺษฺยติ กึ? ");
INSERT INTO santha_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","โน เจตฺ มำ คเวษยิษฺยถ กินฺตูทฺเทศํ น ปฺราปฺสฺยถ เอษ โกทฺฤศํ วากฺยมิทํ วทติ? ");
INSERT INTO santha_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","อนนฺตรมฺ อุตฺสวสฺย จรเม'หนิ อรฺถาตฺ ปฺรธานทิเน ยีศุรุตฺติษฺฐนฺ อุจฺไจ:การมฺ อาหฺวยนฺ อุทิตวานฺ ยทิ กศฺจิตฺ ตฺฤษารฺตฺโต ภวติ ตรฺหิ มมานฺติกมฺ อาคตฺย ปิวตุฯ ");
INSERT INTO santha_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ย: กศฺจินฺมยิ วิศฺวสิติ ธรฺมฺมคฺรนฺถสฺย วจนานุสาเรณ ตสฺยาภฺยนฺตรโต'มฺฤตโตยสฺย โสฺรตำสิ นิรฺคมิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","เย ตสฺมินฺ วิศฺวสนฺติ ต อาตฺมานํ ปฺราปฺสฺยนฺตีตฺยรฺเถ ส อิทํ วากฺยํ วฺยาหฺฤตวานฺ เอตตฺกาลํ ยาวทฺ ยีศุ รฺวิภวํ น ปฺราปฺตสฺตสฺมาตฺ ปวิตฺร อาตฺมา นาทียตฯ ");
INSERT INTO santha_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","เอตำ วาณีํ ศฺรุตฺวา พหโว โลกา อวทนฺ อยเมว นิศฺจิตํ ส ภวิษฺยทฺวาทีฯ ");
INSERT INTO santha_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","เกจิทฺ อกถยนฺ เอเษอว โสภิษิกฺตฺต: กินฺตุ เกจิทฺ อวทนฺ โสภิษิกฺตฺต: กึ คาลีลฺ ปฺรเทเศ ชนิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","โสภิษิกฺตฺโต ทายูโท วํเศ ทายูโท ชนฺมสฺถาเน ไพเตฺลหมิ ปตฺตเน ชนิษฺยเต ธรฺมฺมคฺรนฺเถ กิมิตฺถํ ลิขิตํ นาสฺติ? ");
INSERT INTO santha_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","อิตฺถํ ตสฺมินฺ โลกานำ ภินฺนวากฺยตา ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","กติปยโลกาสฺตํ ธรฺตฺตุมฺ ไอจฺฉนฺ ตถาปิ ตทฺวปุษิ โกปิ หสฺตํ นารฺปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","อนนฺตรํ ปาทาติคเณ ปฺรธานยาชกานำ ผิรูศินาญฺจ สมีปมาคตวติ เต ตานฺ อปฺฤจฺฉนฺ กุโต เหโตสฺตํ นานยต? ");
INSERT INTO santha_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ตทา ปทาตย: ปฺรตฺยวทนฺ ส มานว อิว โกปิ กทาปิ โนปาทิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ตต: ผิรูศิน: ปฺราโวจนฺ ยูยมปิ กิมภฺรามิษฺฏ? ");
INSERT INTO santha_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","อธิปตีนำ ผิรูศินาญฺจ โกปิ กึ ตสฺมินฺ วฺยศฺวสีตฺ? ");
INSERT INTO santha_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","เย ศาสฺตฺรํ น ชานนฺติ ต อิเม'ธมโลกาเอว ศาปคฺรสฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ตทา นิกทีมนามา เตษาเมโก ย: กฺษณทายำ ยีโศ: สนฺนิธิมฺ อคาตฺ ส อุกฺตฺตวานฺ ");
INSERT INTO santha_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ตสฺย วาเกฺย น ศฺรุเต กรฺมฺมณิ จ น วิทิเต 'สฺมากํ วฺยวสฺถา กึ กญฺจน มนุชํ โทษีกโรติ? ");
INSERT INTO santha_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ตตเสฺต วฺยาหรนฺ ตฺวมปิ กึ คาลีลียโลก:? วิวิจฺย ปศฺย คลีลิ โกปิ ภวิษฺยทฺวาที โนตฺปทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ตต: ปรํ สรฺเวฺว สฺวํ สฺวํ คฺฤหํ คตา: กินฺตุ ยีศุ ไรฺชตุนนามานํ ศิโลจฺจยํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ปฺรตฺยูเษ ยีศุ: ปนรฺมนฺทิรมฺ อาคจฺฉตฺ ");
INSERT INTO santha_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ตต: สรฺเวฺวษุ โลเกษุ ตสฺย สมีป อาคเตษุ ส อุปวิศฺย ตานฺ อุปเทษฺฏุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ตทา อธฺยาปกา: ผิรูศินญฺจ วฺยภิจารกรฺมฺมณิ ธฺฤตํ สฺตฺริยเมกามฺ อานิย สรฺเวฺวษำ มเธฺย สฺถาปยิตฺวา วฺยาหรนฺ ");
INSERT INTO santha_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","เห คุโร โยษิตมฺ อิมำ วฺยภิจารกรฺมฺม กุรฺวฺวาณำ โลกา ธฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","เอตาทฺฤศโลกา: ปาษาณาฆาเตน หนฺตวฺยา อิติ วิธิรฺมูสาวฺยวสฺถาคฺรนฺเถ ลิขิโตสฺติ กินฺตุ ภวานฺ กิมาทิศติ? ");
INSERT INTO santha_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","เต ตมปวทิตุํ ปรีกฺษาภิปฺราเยณ วากฺยมิทมฺ อปฺฤจฺฉนฺ กินฺตุ ส ปฺรหฺวีภูย ภูมาวงฺคลฺยา เลขิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ตตไสฺต: ปุน: ปุน: ปฺฤษฺฏ อุตฺถาย กถิตวานฺ ยุษฺมากํ มเธฺย โย ชโน นิรปราธี เสอว ปฺรถมมฺ เอนำ ปาษาเณนาหนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ปศฺจาตฺ ส ปุนศฺจ ปฺรหฺวีภูย ภูเมา เลขิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ตำ กถํ ศฺรุตฺวา เต สฺวสฺวมนสิ ปฺรโพธํ ปฺราปฺย เชฺยษฺฐานุกฺรมํ เอไกกศ: สรฺเวฺว พหิรคจฺฉนฺ ตโต ยีศุเรกากี ตยกฺตฺโตภวตฺ มธฺยสฺถาเน ทณฺฑายมานา สา โยษา จ สฺถิตาฯ ");
INSERT INTO santha_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ตตฺปศฺจาทฺ ยีศุรุตฺถาย ตำ วนิตำ วินา กมปฺยปรํ น วิโลกฺย ปฺฤษฺฏวานฺ เห วาเม ตวาปวาทกา: กุตฺร? โกปิ ตฺวำ กึ น ทณฺฑยติ? ");
INSERT INTO santha_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","สาวทตฺ เห มเหจฺฉ โกปิ น ตทา ยีศุรโวจตฺ นาหมปิ ทณฺฑยามิ ยาหิ ปุน: ปาปํ มาการฺษี:ฯ ");
INSERT INTO santha_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ตโต ยีศุ: ปุนรปิ โลเกภฺย อิตฺถํ กถยิตุมฺ อารภต ชคโตหํ โชฺยติ:สฺวรูโป ย: กศฺจินฺ มตฺปศฺจาท คจฺฉติ ส ติมิเร น ภฺรมิตฺวา ชีวนรูปำ ทีปฺตึ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ตต: ผิรูศิโน'วาทิษุสฺตฺวํ สฺวารฺเถ สฺวยํ สากฺษฺยํ ททาสิ ตสฺมาตฺ ตว สากฺษฺยํ คฺราหฺยํ น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ตทา ยีศุ: ปฺรตฺยุทิตวานฺ ยทฺยปิ สฺวารฺเถ'หํ สฺวยํ สากฺษฺยํ ททามิ ตถาปิ มตฺ สากฺษฺยํ คฺราหฺยํ ยสฺมาทฺ อหํ กุต อาคโตสฺมิ กฺว ยามิ จ ตทหํ ชานามิ กินฺตุ กุต อาคโตสฺมิ กุตฺร คจฺฉามิ จ ตทฺ ยูยํ น ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ยูยํ เลากิกํ วิจารยถ นาหํ กิมปิ วิจารยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","กินฺตุ ยทิ วิจารยามิ ตรฺหิ มม วิจาโร คฺรหีตโวฺย ยโตหมฺ เอกากี นาสฺมิ เปฺรรยิตา ปิตา มยา สห วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ทฺวโย รฺชนโย: สากฺษฺยํ คฺรหณียํ ภวตีติ ยุษฺมากํ วฺยวสฺถาคฺรนฺเถ ลิขิตมสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","อหํ สฺวารฺเถ สฺวยํ สากฺษิตฺวํ ททามิ ยศฺจ มม ตาโต มำ เปฺรริตวานฺ โสปิ มทรฺเถ สากฺษฺยํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ตทา เต'ปฺฤจฺฉนฺ ตว ตาต: กุตฺร? ตโต ยีศุ: ปฺรตฺยวาทีทฺ ยูยํ มำ น ชานีถ มตฺปิตรญฺจ น ชานีถ ยทิ มามฺ อกฺษาสฺยต ตรฺหิ มม ตาตมปฺยกฺษาสฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ยีศุ รฺมนฺทิร อุปทิศฺย ภณฺฑาคาเร กถา เอตา อกถยตฺ ตถาปิ ตํ ปฺรติ โกปิ กรํ โนทโตลยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ตต: ปรํ ยีศุ: ปุนรุทิตวานฺ อธุนาหํ คจฺฉามิ ยูยํ มำ คเวษยิษฺยถ กินฺตุ นิไช: ปาไป รฺมริษฺยถ ยตฺ สฺถานมฺ อหํ ยาสฺยามิ ตตฺ สฺถานมฺ ยูยํ ยาตุํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ตทา ยิหูทียา: ปฺราโวจนฺ กิมยมฺ อาตฺมฆาตํ กริษฺยติ? ยโต ยตฺ สฺถานมฺ อหํ ยาสฺยามิ ตตฺ สฺถานมฺ ยูยํ ยาตุํ น ศกฺษฺยถ อิติ วากฺยํ พฺรวีติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ตโต ยีศุเสฺตภฺย: กถิตวานฺ ยูยมฺ อธ:สฺถานียา โลกา อหมฺ อูรฺทฺวฺวสฺถานีย: ยูยมฺ เอตชฺชคตฺสมฺพนฺธียา อหมฺ เอตชฺชคตฺสมฺพนฺธีโย นฯ ");
INSERT INTO santha_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ตสฺมาตฺ กถิตวานฺ ยูยํ นิไช: ปาไป รฺมริษฺยถ ยโตหํ ส ปุมานฺ อิติ ยทิ น วิศฺวสิถ ตรฺหิ นิไช: ปาไป รฺมริษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ตทา เต 'ปฺฤจฺฉนฺ กสฺตฺวํ? ตโต ยีศุ: กถิตวานฺ ยุษฺมากํ สนฺนิเธา ยสฺย ปฺรสฺตาวมฺ อา ปฺรถมาตฺ กโรมิ เสอว ปุรุโษหํฯ ");
INSERT INTO santha_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ยุษฺมาสุ มยา พหุวากฺยํ วกฺตฺตวฺยํ วิจารยิตวฺยญฺจ กินฺตุ มตฺเปฺรรยิตา สตฺยวาที ตสฺย สมีเป ยทหํ ศฺรุตวานฺ ตเทว ชคเต กถยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","กินฺตุ ส ชนเก วากฺยมิทํ โปฺรกฺตฺตวานฺ อิติ เต นาพุธฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ตโต ยีศุรกถยทฺ ยทา มนุษฺยปุตฺรมฺ อูรฺทฺวฺว อุตฺถาปยิษฺยถ ตทาหํ ส ปุมานฺ เกวล: สฺวยํ กิมปิ กรฺมฺม น กโรมิ กินฺตุ ตาโต ยถา ศิกฺษยติ ตทนุสาเรณ วากฺยมิทํ วทามีติ จ ยูยํ ชฺญาตุํ ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","มตฺเปฺรรยิตา ปิตา มามฺ เอกากินํ น ตฺยชติ ส มยา สารฺทฺธํ ติษฺฐติ ยโตหํ ตทภิมตํ กรฺมฺม สทา กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ตทา ตไสฺยตานิ วากฺยานิ ศฺรุตฺวา พหุวสฺตาสฺมินฺ วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","เย ยิหูทียา วฺยศฺวสนฺ ยีศุเสฺตโภฺย'กถยตฺ ");
INSERT INTO santha_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","มม วาเกฺย ยทิ ยูยมฺ อาสฺถำ กุรุถ ตรฺหิ มม ศิษฺยา ภูตฺวา สตฺยตฺวํ ชฺญาสฺยถ ตต: สตฺยตยา ยุษฺมากํ โมกฺโษ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ตทา เต ปฺรตฺยวาทิษุ: วยมฺ อิพฺราหีโม วํศ: กทาปิ กสฺยาปิ ทาสา น ชาตาสฺตรฺหิ ยุษฺมากํ มุกฺตฺติ รฺภวิษฺยตีติ วากฺยํ กถํ พฺรวีษิ? ");
INSERT INTO santha_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ตทา ยีศุ: ปฺรตฺยวททฺ ยุษฺมานหํ ยถารฺถตรํ วทามิ ย: ปาปํ กโรติ ส ปาปสฺย ทาส:ฯ ");
INSERT INTO santha_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ทาสศฺจ นิรนฺตรํ นิเวศเน น ติษฺฐติ กินฺตุ ปุโตฺร นิรนฺตรํ ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","อต: ปุโตฺร ยทิ ยุษฺมานฺ โมจยติ ตรฺหิ นิตานฺตเมว มุกฺตฺตา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ยุยมฺ อิพฺราหีโม วํศ อิตฺยหํ ชานามิ กินฺตุ มม กถา ยุษฺมากมฺ อนฺต:กรเณษุ สฺถานํ น ปฺราปฺนุวนฺติ ตสฺมาทฺเธโต รฺมำ หนฺตุมฺ อีหเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","อหํ สฺวปิตุ: สมีเป ยทปศฺยํ ตเทว กถยามิ ตถา ยูยมปิ สฺวปิตุ: สมีเป ยทปศฺยต ตเทว กุรุเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ตทา เต ปฺรตฺยโวจนฺ อิพฺราหีมฺ อสฺมากํ ปิตา ตโต ยีศุรกถยทฺ ยทิ ยูยมฺ อิพฺราหีม: สนฺตานา อภวิษฺยต ตรฺหิ อิพฺราหีม อาจารณวทฺ อาจริษฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","อีศฺวรสฺย มุขาตฺ สตฺยํ วากฺยํ ศฺรุตฺวา ยุษฺมานฺ ชฺญาปยามิ โยหํ ตํ มำ หนฺตุํ เจษฺฏเธฺว อิพฺราหีมฺ เอตาทฺฤศํ กรฺมฺม น จการฯ ");
INSERT INTO santha_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ยูยํ สฺวสฺวปิตุ: กรฺมฺมาณิ กุรุถ ตทา ไตรุกฺตฺตํ น วยํ ชารชาตา อสฺมากมฺ เอเกอว ปิตาสฺติ ส เอเวศฺวร: ");
INSERT INTO santha_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ตโต ยีศุนา กถิตมฺ อีศฺวโร ยทิ ยุษฺมากํ ตาโตภวิษฺยตฺ ตรฺหิ ยูยํ มยิ เปฺรมากริษฺยต ยโตหมฺ อีศฺวรานฺนิรฺคตฺยาคโตสฺมิ สฺวโต นาคโตหํ ส มำ ปฺราหิโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ยูยํ มม วากฺยมิทํ น พุธฺยเธฺว กุต:? ยโต ยูยํ มโมปเทศํ โสฒุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ยูยํ ไศตานฺ ปิตุ: สนฺตานา เอตสฺมาทฺ ยุษฺมากํ ปิตุรภิลาษํ ปูรยถ ส อา ปฺรถมาตฺ นรฆาตี ตทนฺต: สตฺยตฺวสฺย เลโศปิ นาสฺติ การณาทต: ส สตฺยตายำ นาติษฺฐตฺ ส ยทา มฺฤษา กถยติ ตทา นิชสฺวภาวานุสาเรไณว กถยติ ยโต ส มฺฤษาภาษี มฺฤโษตฺปาทกศฺจฯ ");
INSERT INTO santha_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","อหํ ตถฺยวากฺยํ วทามิ การณาทสฺมาทฺ ยูยํ มำ น ปฺรตีถฯ ");
INSERT INTO santha_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","มยิ ปาปมสฺตีติ ปฺรมาณํ ยุษฺมากํ โก ทาตุํ ศกฺโนติ? ยทฺยหํ ตถฺยวากฺยํ วทามิ ตรฺหิ กุโต มำ น ปฺรติถ? ");
INSERT INTO santha_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ย: กศฺจน อีศฺวรีโย โลก: ส อีศฺวรียกถายำ มโน นิธตฺเต ยูยมฺ อีศฺวรียโลกา น ภวถ ตนฺนิทานาตฺ ตตฺร น มนำสิ นิธเทฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ตทา ยิหูทียา: ปฺรตฺยวาทิษุ: ตฺวเมก: โศมิโรณีโย ภูตคฺรสฺตศฺจ วยํ กิมิทํ ภทฺรํ นาวาทิษฺม? ");
INSERT INTO santha_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ตโต ยีศุ: ปฺรตฺยวาทีตฺ นาหํ ภูตคฺรสฺต: กินฺตุ นิชตาตํ สมฺมเนฺย ตสฺมาทฺ ยูยํ มามฺ อปมนฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","อหํ สฺวสุขฺยาตึ น เจษฺเฏ กินฺตุ เจษฺฏิตา วิจารยิตา จาปร เอก อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","อหํ ยุษฺมภฺยมฺ อตีว ยถารฺถํ กถยามิ โย นโร มทียํ วาจํ มนฺยเต ส กทาจน นิธนํ น ทฺรกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ยิหูทียาสฺตมวทนฺ ตฺวํ ภูตคฺรสฺต อิตีทานีมฺ อไวษฺมฯ อิพฺราหีมฺ ภวิษฺยทฺวาทินญฺจ สรฺเวฺว มฺฤตา: กินฺตุ ตฺวํ ภาษเส โย นโร มม ภารตีํ คฺฤหฺลาติ ส ชาตุ นิธานาสฺวาทํ น ลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ตรฺหิ ตฺวํ กิมฺ อสฺมากํ ปูรฺวฺวปุรุษาทฺ อิพฺราหีโมปิ มหานฺ? ยสฺมาตฺ โสปิ มฺฤต: ภวิษฺยทฺวาทิโนปิ มฺฤตา: ตฺวํ สฺวํ กํ ปุมำสํ มนุเษ? ");
INSERT INTO santha_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ยีศุ: ปฺรตฺยโวจทฺ ยทฺยหํ สฺวํ สฺวยํ สมฺมเนฺย ตรฺหิ มม ตตฺ สมฺมนนํ กิมปิ น กินฺตุ มม ตาโต ยํ ยูยํ สฺวียมฺ อีศฺวรํ ภาษเธฺว เสอว มำ สมฺมนุเตฯ ");
INSERT INTO santha_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ยูยํ ตํ นาวคจฺฉถ กินฺตฺวหํ ตมวคจฺฉามิ ตํ นาวคจฺฉามีติ วากฺยํ ยทิ วทามิ ตรฺหิ ยูยมิว มฺฤษาภาษี ภวามิ กินฺตฺวหํ ตมวคจฺฉามิ ตทากฺษามปิ คฺฤหฺลามิฯ ");
INSERT INTO santha_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ยุษฺมากํ ปูรฺวฺวปุรุษ อิพฺราหีมฺ มม สมยํ ทฺรษฺฏุมฺ อตีวาวาญฺฉตฺ ตนฺนิรีกฺษฺยานนฺทจฺจฯ ");
INSERT INTO santha_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ตทา ยิหูทียา อปฺฤจฺฉนฺ ตว วย: ปญฺจาศทฺวตฺสรา น ตฺวํ กิมฺ อิพฺราหีมมฺ อทฺรากฺษี:? ");
INSERT INTO santha_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ยีศุ: ปฺรตฺยวาทีทฺ ยุษฺมานหํ ยถารฺถตรํ วทามิ อิพฺราหีโม ชนฺมน: ปูรฺวฺวกาลมารภฺยาหํ วิเทฺยฯ ");
INSERT INTO santha_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ตทา เต ปาษาณานฺ อุตฺโตลฺย ตมาหนฺตุมฺ อุทยจฺฉนฺ กินฺตุ ยีศุ รฺคุปฺโต มนฺติราทฺ พหิรฺคตฺย เตษำ มเธฺยน ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ตต: ปรํ ยีศุรฺคจฺฉนฺ มารฺคมเธฺย ชนฺมานฺธํ นรมฺ อปศฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ตต: ศิษฺยาสฺตมฺ อปฺฤจฺฉนฺ เห คุโร นโรยํ สฺวปาเปน วา สฺวปิตฺรา: ปาเปนานฺโธ'ชายต? ");
INSERT INTO santha_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ตต: ส ปฺรตฺยุทิตวานฺ เอตสฺย วาสฺย ปิโตฺร: ปาปาทฺ เอตาทฺฤโศภูท อิติ นหิ กินฺตฺวเนน ยเถศฺวรสฺย กรฺมฺม ปฺรกาศฺยเต ตทฺเธโตเรวฯ ");
INSERT INTO santha_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ทิเน ติษฺฐติ มตฺเปฺรรยิตุ: กรฺมฺม มยา กรฺตฺตวฺยํ ยทา กิมปิ กรฺมฺม น กฺริยเต ตาทฺฤศี นิศาคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","อหํ ยาวตฺกาลํ ชคติ ติษฺฐามิ ตาวตฺกาลํ ชคโต โชฺยติ:สฺวรูโปสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","อิตฺยุกฺตฺตา ภูเมา นิษฺฐีวํ นิกฺษิปฺย เตน ปงฺกํ กฺฤตวานฺ ");
INSERT INTO santha_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ปศฺจาตฺ ตตฺปงฺเกน ตสฺยานฺธสฺย เนเตฺร ปฺรลิปฺย ตมิตฺยาทิศตฺ คตฺวา ศิโลเห 'รฺถาตฺ เปฺรริตนามฺนิ สรสิ สฺนาหิฯ ตโตนฺโธ คตฺวา ตตฺราสฺนาตฺ ตต: ปฺรนฺนจกฺษุ รฺภูตฺวา วฺยาฆุฏฺยาคาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","อปรญฺจ สมีปวาสิโน โลกา เย จ ตํ ปูรฺวฺวมนฺธมฺ อปศฺยนฺ เต พกฺตฺตุมฺ อารภนฺต โยนฺธโลโก วรฺตฺมนฺยุปวิศฺยาภิกฺษต ส เอวายํ ชน: กึ น ภวติ? ");
INSERT INTO santha_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","เกจิทวทนฺ ส เอว เกจิทโวจนฺ ตาทฺฤโศ ภวติ กินฺตุ ส สฺวยมพฺรวีตฺ ส เอวาหํ ภวามิฯ ");
INSERT INTO santha_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","อเตอว เต 'ปฺฤจฺฉนฺ ตฺวํ กถํ ทฺฤษฺฏึ ปาปฺตวานฺ? ");
INSERT INTO santha_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ตต: โสวททฺ ยีศนามก เอโก ชโน มม นยเน ปงฺเกน ปฺรลิปฺย อิตฺยาชฺญาปยตฺ ศิโลหกาสารํ คตฺวา ตตฺร สฺนาหิฯ ตตสฺตตฺร คตฺวา มยิ สฺนาเต ทฺฤษฺฏิมหํ ลพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ตทา เต 'วทนฺ ส ปุมานฺ กุตฺร? เตโนกฺตฺตํ นาหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","อปรํ ตสฺมินฺ ปูรฺวฺวานฺเธ ชเน ผิรูศินำ นิกฏมฺ อานีเต สติ ผิรูศิโนปิ ตมปฺฤจฺฉนฺ กถํ ทฺฤษฺฏึ ปฺราปฺโตสิ? ");
INSERT INTO santha_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ตต: ส กถิตวานฺ ส ปงฺเกน มม เนเตฺร 'ลิมฺปตฺ ปศฺจาทฺ สฺนาตฺวา ทฺฤษฺฏิมลเภฯ ");
INSERT INTO santha_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","กินฺตุ ยีศุ รฺวิศฺรามวาเร กรฺทฺทมํ กฺฤตฺวา ตสฺย นยเน ปฺรสนฺเน'กโรทฺ อิติการณาตฺ กติปยผิรูศิโน'วทนฺ ");
INSERT INTO santha_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ส ปุมานฺ อีศฺวรานฺน ยต: ส วิศฺรามวารํ น มนฺยเตฯ ตโตเนฺย เกจิตฺ ปฺรตฺยวทนฺ ปาปี ปุมานฺ กิมฺ เอตาทฺฤศมฺ อาศฺจรฺยฺยํ กรฺมฺม กรฺตฺตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","อิตฺถํ เตษำ ปรสฺปรํ ภินฺนวากฺยตฺวมฺ อภวตฺฯ ปศฺจาตฺ เต ปุนรปิ ตํ ปูรฺวฺวานฺธํ มานุษมฺ อปฺรากฺษุ: โย ชนสฺตว จกฺษุษี ปฺรสนฺเน กฺฤตวานฺ ตสฺมินฺ ตฺวํ กึ วทสิ? ส อุกฺตฺตวานฺ ส ภวิศทฺวาทีฯ ");
INSERT INTO santha_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ส ทฺฤษฺฏิมฺ อาปฺตวานฺ อิติ ยิหูทียาสฺตสฺย ทฺฤษฺฏึ ปฺราปฺตสฺย ชนสฺย ปิโตฺร รฺมุขาทฺ อศฺรุตฺวา น ปฺรตฺยยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","อเตอว เต ตาวปฺฤจฺฉนฺ ยุวโย รฺยํ ปุตฺรํ ชนฺมานฺธํ วทถ: ส กิมยํ? ตรฺหีทานีํ กถํ ทฺรษฺฏุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ตตสฺตสฺย ปิตเรา ปฺรตฺยโวจตามฺ อยมฺ อาวโย: ปุตฺร อา ชเนรนฺธศฺจ ตทปฺยาวำ ชานีว: ");
INSERT INTO santha_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","กินฺตฺวธุนา กถํ ทฺฤษฺฏึ ปฺราปฺตวานฺ ตทาวำ นฺ ชานีว: โกสฺย จกฺษุษี ปฺรสนฺเน กฺฤตวานฺ ตทปิ น ชานีว เอษ วย:ปฺราปฺต เอนํ ปฺฤจฺฉต สฺวกถำ สฺวยํ วกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ยิหูทียานำ ภยาตฺ ตสฺย ปิตเรา วากฺยมิทมฺ อวทตำ ยต: โกปิ มนุโษฺย ยทิ ยีศุมฺ อภิษิกฺตํ วทติ ตรฺหิ ส ภชนคฺฤหาทฺ ทูรีการิษฺยเต ยิหูทียา อิติ มนฺตฺรณามฺ อกุรฺวฺวนฺ ");
INSERT INTO santha_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","อตสฺตสฺย ปิตเรา วฺยาหรตามฺ เอษ วย:ปฺราปฺต เอนํ ปฺฤจฺฉตฯ ");
INSERT INTO santha_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ตทา เต ปุนศฺจ ตํ ปูรฺวฺวานฺธมฺ อาหูย วฺยาหรนฺ อีศฺวรสฺย คุณานฺ วท เอษ มนุษฺย: ปาปีติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ตทา ส อุกฺตฺตวานฺ ส ปาปี น เวติ นาหํ ชาเน ปูรฺวามนฺธ อาสมหมฺ อธุนา ปศฺยามีติ มาตฺรํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","เต ปุนรปฺฤจฺฉนฺ ส ตฺวำ ปฺรติ กิมกโรตฺ? กถํ เนเตฺร ปฺรสนฺเน 'กโรตฺ? ");
INSERT INTO santha_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ตต: โสวาทีทฺ เอกกฺฤโตฺวกถยํ ยูยํ น ศฺฤณุถ ตรฺหิ กุต: ปุน: โศฺรตุมฺ อิจฺฉถ? ยูยมปิ กึ ตสฺย ศิษฺยา ภวิตุมฺ อิจฺฉถ? ");
INSERT INTO santha_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ตทา เต ตํ ติรสฺกฺฤตฺย วฺยาหรนฺ ตฺวํ ตสฺย ศิโษฺย วยํ มูสา: ศิษฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","มูสาวกฺเตฺรเณศฺวโร ชคาท ตชฺชานีม: กินฺเตฺวษ กุตฺรตฺยโลก อิติ น ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","โสวททฺ เอษ มม โลจเน ปฺรสนฺเน 'กโรตฺ ตถาปิ กุตฺรตฺยโลก อิติ ยูยํ น ชานีถ เอตทฺ อาศฺจรฺยฺยํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","อีศฺวร: ปาปินำ กถำ น ศฺฤโณติ กินฺตุ โย ชนสฺตสฺมินฺ ภกฺตึ กฺฤตฺวา ตทิษฺฏกฺริยำ กโรติ ตไสฺยว กถำ ศฺฤโณติ เอตทฺ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","โกปิ มนุโษฺย ชนฺมานฺธาย จกฺษุษี อททาตฺ ชคทารมฺภาทฺ เอตาทฺฤศีํ กถำ โกปิ กทาปิ นาศฺฤโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","อสฺมาทฺ เอษ มนุโษฺย ยทีศฺวรานฺนาชายต ตรฺหิ กิญฺจิทปีทฺฤศํ กรฺมฺม กรฺตฺตุํ นาศกฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","เต วฺยาหรนฺ ตฺวํ ปาปาทฺ อชายถา: กิมสฺมานฺ ตฺวํ ศิกฺษยสิ? ปศฺจาตฺเต ตํ พหิรกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ตทนนฺตรํ ยิหูทีไย: ส พหิรกฺริยต ยีศุริติ วารฺตฺตำ ศฺรุตฺวา ตํ สากฺษาตฺ ปฺราปฺย ปฺฤษฺฏวานฺ อีศฺวรสฺย ปุเตฺร ตฺวํ วิศฺวสิษิ? ");
INSERT INTO santha_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ตทา ส ปฺรตฺยโวจตฺ เห ปฺรโภ ส โก ยตฺ ตสฺมินฺนหํ วิศฺวสิมิ? ");
INSERT INTO santha_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ตโต ยีศุ: กถิตวานฺ ตฺวํ ตํ ทฺฤษฺฏวานฺ ตฺวยา สากํ ย: กถํ กถยติ เสอว ส:ฯ ");
INSERT INTO santha_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ตทา เห ปฺรโภ วิศฺวสิมีตฺยุกฺตฺวา ส ตํ ปฺรณามตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ปศฺจาทฺ ยีศุ: กถิตวานฺ นยนหีนา นยนานิ ปฺราปฺนุวนฺติ นยนวนฺตศฺจานฺธา ภวนฺตีตฺยภิปฺราเยณ ชคทาหมฺ อาคจฺฉมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","เอตตฺ ศฺรุตฺวา นิกฏสฺถา: กติปยา: ผิรูศิโน วฺยาหรนฺ วยมปิ กิมนฺธา:? ");
INSERT INTO santha_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ตทา ยีศุรวาทีทฺ ยทฺยนฺธา อภวต ตรฺหิ ปาปานิ นาติษฺฐนฺ กินฺตุ ปศฺยามีติ วากฺยวทนาทฺ ยุษฺมากํ ปาปานิ ติษฺฐนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","อหํ ยุษฺมานติยถารฺถํ วทามิ, โย ชโน ทฺวาเรณ น ปฺรวิศฺย เกนาปฺยเนฺยน เมษคฺฤหํ ปฺรวิศติ ส เอว เสฺตโน ทสฺยุศฺจฯ ");
INSERT INTO santha_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","โย ทฺวาเรณ ปฺรวิศติ ส เอว เมษปาลก:ฯ ");
INSERT INTO santha_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","เทาวาริกสฺตไสฺม ทฺวารํ โมจยติ เมษคณศฺจ ตสฺย วากฺยํ ศฺฤโณติ ส นิชานฺ เมษานฺ สฺวสฺวนามฺนาหูย พหิ: กฺฤตฺวา นยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ตถา นิชานฺ เมษานฺ พหิ: กฺฤตฺวา สฺวยํ เตษามฺ อเคฺร คจฺฉติ, ตโต เมษาสฺตสฺย ศพฺทํ พุธฺยนฺเต, ตสฺมาตฺ ตสฺย ปศฺจาทฺ วฺรชนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","กินฺตุ ปรสฺย ศพฺทํ น พุธฺยนฺเต ตสฺมาตฺ ตสฺย ปศฺจาทฺ วฺรชิษฺยนฺติ วรํ ตสฺย สมีปาตฺ ปลายิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ยีศุเสฺตภฺย อิมำ ทฺฤษฺฏานฺตกถามฺ อกถยตฺ กินฺตุ เตน กถิตกถายาสฺตาตฺปรฺยฺยํ เต นาพุธฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","อโต ยีศุ: ปุนรกถยตฺ, ยุษฺมานาหํ ยถารฺถตรํ วฺยาหรามิ, เมษคฺฤหสฺย ทฺวารมฺ อหเมวฯ ");
INSERT INTO santha_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","มยา น ปฺรวิศฺย ย อาคจฺฉนฺ เต เสฺตนา ทสฺยวศฺจ กินฺตุ เมษาเสฺตษำ กถา นาศฺฤณฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","อหเมว ทฺวารสฺวรูป:, มยา ย: กศฺจิต ปฺรวิศติ ส รกฺษำ ปฺราปฺสฺยติ ตถา พหิรนฺตศฺจ คมนาคมเน กฺฤตฺวา จรณสฺถานํ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","โย ชนเสฺตน: ส เกวลํ ไสฺตนฺยพธวินาศานฺ กรฺตฺตุเมว สมายาติ กินฺตฺวหมฺ อายุ รฺทาตุมฺ อรฺถาตฺ พาหูเลฺยน ตเทว ทาตุมฺ อาคจฺฉมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","อหเมว สตฺยเมษปาลโก ยสฺตุ สโตฺย เมษปาลก: ส เมษารฺถํ ปฺราณตฺยาคํ กโรติ; ");
INSERT INTO santha_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","กินฺตุ โย ชโน เมษปาลโก น, อรฺถาทฺ ยสฺย เมษา นิชา น ภวนฺติ, ย เอตาทฺฤโศ ไวตนิก: ส วฺฤกมฺ อาคจฺฉนฺตํ ทฺฤษฺฏฺวา เมชวฺรชํ วิหาย ปลายเต, ตสฺมาทฺ วฺฤกสฺตํ วฺรชํ ธฺฤตฺวา วิกิรติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ไวตนิก: ปลายเต ยต: ส เวตนารฺถี เมษารฺถํ น จินฺตยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","อหเมว สโตฺย เมษปาลก:, ปิตา มำ ยถา ชานาติ, อหญฺจ ยถา ปิตรํ ชานามิ, ");
INSERT INTO santha_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ตถา นิชานฺ เมษานปิ ชานามิ, เมษาศฺจ มำ ชานานฺติ, อหญฺจ เมษารฺถํ ปฺราณตฺยาคํ กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","อปรญฺจ เอตทฺ คฺฤหีย เมเษโภฺย ภินฺนา อปิ เมษา มม สนฺติ เต สกลา อานยิตวฺยา:; เต มม ศพฺทํ โศฺรษฺยนฺติ ตต เอโก วฺรช เอโก รกฺษโก ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ปฺราณานหํ ตฺยกฺตฺวา ปุน: ปฺราณานฺ คฺรหีษฺยามิ, ตสฺมาตฺ ปิตา มยิ เสฺนหํ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","กศฺจิชฺชโน มม ปฺราณานฺ หนฺตุํ น ศกฺโนติ กินฺตุ สฺวยํ ตานฺ สมรฺปยามิ ตานฺ สมรฺปยิตุํ ปุนรฺคฺรหีตุญฺจ มม ศกฺติราเสฺต ภารมิมํ สฺวปิตุ: สกาศาตฺ ปฺราปฺโตหมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","อสฺมาทุปเทศาตฺ ปุนศฺจ ยิหูทียานำ มเธฺย ภินฺนวากฺยตา ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ตโต พหโว วฺยาหรนฺ เอษ ภูตคฺรสฺต อุนฺมตฺตศฺจ, กุต เอตสฺย กถำ ศฺฤณุถ? ");
INSERT INTO santha_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","เกจิทฺ อวทนฺ เอตสฺย กถา ภูตคฺรสฺตสฺย กถาวนฺน ภวนฺติ, ภูต: กิมฺ อนฺธาย จกฺษุษี ทาตุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ศีตกาเล ยิรูศาลมิ มนฺทิโรตฺสรฺคปรฺวฺวณฺยุปสฺถิเต ");
INSERT INTO santha_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ยีศุ: สุเลมาโน นิ:สาเรณ คมนาคมเน กโรติ, ");
INSERT INTO santha_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","เอตสฺมินฺ สมเย ยิหูทียาสฺตํ เวษฺฏยิตฺวา วฺยาหรนฺ กติ กาลานฺ อสฺมากํ วิจิกิตฺสำ สฺถาปยิษฺยามิ? ยทฺยภิษิกฺโต ภวติ ตรฺหิ ตตฺ สฺปษฺฏํ วทฯ ");
INSERT INTO santha_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ตทา ยีศุ: ปฺรตฺยวททฺ อหมฺ อจกถํ กินฺตุ ยูยํ น ปฺรตีถ, นิชปิตุ รฺนามฺนา ยำ ยำ กฺริยำ กโรมิ สา กฺริไยว มม สากฺษิสฺวรูปาฯ ");
INSERT INTO santha_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","กินฺตฺวหํ ปูรฺวฺวมกถยํ ยูยํ มม เมษา น ภวถ, การณาทสฺมานฺ น วิศฺวสิถฯ ");
INSERT INTO santha_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","มม เมษา มม ศพฺทํ ศฺฤณฺวนฺติ ตานหํ ชานามิ เต จ มม ปศฺจาทฺ คจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","อหํ เตโภฺย'นนฺตายุ รฺททามิ, เต กทาปิ น นํกฺษฺยนฺติ โกปิ มม กราตฺ ตานฺ หรฺตฺตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","โย มม ปิตา ตานฺ มหฺยํ ทตฺตวานฺ ส สรฺวฺวสฺมาตฺ มหานฺ, โกปิ มม ปิตุ: กราตฺ ตานฺ หรฺตฺตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","อหํ ปิตา จ ทฺวโยเรกตฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ตโต ยิหูทียา: ปุนรปิ ตํ หนฺตุํ ปาษาณานฺ อุทโตลยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ยีศุ: กถิตวานฺ ปิตุ: สกาศาทฺ พหูนฺยุตฺตมกรฺมฺมาณิ ยุษฺมากํ ปฺรากาศยํ เตษำ กสฺย กรฺมฺมณ: การณานฺ มำ ปาษาไณราหนฺตุมฺ อุทฺยตา: สฺถ? ");
INSERT INTO santha_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ยิหูทียา: ปฺรตฺยวทนฺ ปฺรศสฺตกรฺมฺมเหโต รฺน กินฺตุ ตฺวํ มานุษ: สฺวมีศฺวรมฺ อุกฺเตฺวศฺวรํ นินฺทสิ การณาทสฺมาตฺ ตฺวำ ปาษาไณรฺหนฺม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ตทา ยีศุ: ปฺรตฺยุกฺตวานฺ มยา กถิตํ ยูยมฺ อีศฺวรา เอตทฺวจนํ ยุษฺมากํ ศาสฺเตฺร ลิขิตํ นาสฺติ กึ? ");
INSERT INTO santha_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ตสฺมาทฺ เยษามฺ อุทฺเทเศ อีศฺวรสฺย กถา กถิตา เต ยทีศฺวรคณา อุจฺยนฺเต ธรฺมฺมคฺรนฺถสฺยาปฺยนฺยถา ภวิตุํ น ศกฺยํ, ");
INSERT INTO santha_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ตรฺหฺยาหมฺ อีศฺวรสฺย ปุตฺร อิติ วากฺยสฺย กถนาตฺ ยูยํ ปิตฺราภิษิกฺตํ ชคติ เปฺรริตญฺจ ปุมำสํ กถมฺ อีศฺวรนินฺทกํ วาทย? ");
INSERT INTO santha_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ยทฺยหํ ปิตุ: กรฺมฺม น กโรมิ ตรฺหิ มำ น ปฺรตีต; ");
INSERT INTO santha_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","กินฺตุ ยทิ กโรมิ ตรฺหิ มยิ ยุษฺมาภิ: ปฺรตฺยเย น กฺฤเต'ปิ การฺเยฺย ปฺรตฺยย: กฺริยตำ, ตโต มยิ ปิตาสฺตีติ ปิตรฺยฺยหมฺ อสฺมีติ จ กฺษาตฺวา วิศฺวสิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ตทา เต ปุนรปิ ตํ ธรฺตฺตุมฺ อเจษฺฏนฺต กินฺตุ ส เตษำ กเรโภฺย นิสฺตีรฺยฺย ");
INSERT INTO santha_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ปุน รฺยรฺทฺทนฺ อทฺยาสฺตเฏ ยตฺร ปุรฺวฺวํ โยหนฺ อมชฺชยตฺ ตตฺราคตฺย นฺยวสตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ตโต พหโว โลกาสฺตตฺสมีปมฺ อาคตฺย วฺยาหรนฺ โยหนฺ กิมปฺยาศฺจรฺยฺยํ กรฺมฺม นากโรตฺ กินฺตฺวสฺมินฺ มนุเษฺย ยา ย: กถา อกถยตฺ ตา: สรฺวฺวา: สตฺยา:; ");
INSERT INTO santha_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ตตฺร จ พหโว โลกาสฺตสฺมินฺ วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","อนนฺตรํ มริยมฺ ตสฺยา ภคินี มรฺถา จ ยสฺมินฺ ไวถนียาคฺราเม วสตสฺตสฺมินฺ คฺราเม อิลิยาสรฺ นามา ปีฑิต เอก อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ยา มริยมฺ ปฺรภุํ สุคนฺธิเตไลน มรฺทฺทยิตฺวา สฺวเกไศสฺตสฺย จรเณา สมมารฺชตฺ ตสฺยา ภฺราตา ส อิลิยาสรฺ โรคีฯ ");
INSERT INTO santha_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","อปรญฺจ เห ปฺรโภ ภวานฺ ยสฺมินฺ ปฺรียเต ส เอว ปีฑิโตสฺตีติ กถำ กถยิตฺวา ตสฺย ภคิเนฺยา เปฺรษิตวเตฺยาฯ ");
INSERT INTO santha_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ตทา ยีศุริมำ วารฺตฺตำ ศฺรุตฺวากถยต ปีเฑยํ มรณารฺถํ น กินฺตฺวีศฺวรสฺย มหิมารฺถมฺ อีศฺวรปุตฺรสฺย มหิมปฺรกาศารฺถญฺจ ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ยีศุ รฺยทฺยปิมรฺถายำ ตทฺภคินฺยามฺ อิลิยาสริ จาปฺรียต, ");
INSERT INTO santha_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ตถาปิ อิลิยาสร: ปีฑายา: กถํ ศฺรุตฺวา ยตฺร อาสีตฺ ตไตฺรว ทินทฺวยมติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ตต: ปรมฺ ส ศิษฺยานกถยทฺ วยํ ปุน รฺยิหูทียปฺรเทศํ ยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ตตเสฺต ปฺรตฺยวทนฺ, เห คุโร สฺวลฺปทินานิ คตานิ ยิหูทียาสฺตฺวำ ปาษาไณ รฺหนฺตุมฺ อุทฺยตาสฺตถาปิ กึ ปุนสฺตตฺร ยาสฺยสิ? ");
INSERT INTO santha_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ยีศุ: ปฺรตฺยวทตฺ, เอกสฺมินฺ ทิเน กึ ทฺวาทศฆฏิกา น ภวนฺติ? โกปิ ทิวา คจฺฉนฺ น สฺขลติ ยต: ส เอตชฺชคโต ทีปฺตึ ปฺราปฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","กินฺตุ ราเตฺรา คจฺฉนฺ สฺขลติ ยโต เหโตสฺตตฺร ทีปฺติ รฺนาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","อิมำ กถำ กถยิตฺวา ส ตานวททฺ, อสฺมากํ พนฺธุ: อิลิยาสรฺ นิทฺริโตภูทฺ อิทานีํ ตํ นิทฺราโต ชาครยิตุํ คจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ยีศุ รฺมฺฤเตา กถามิมำ กถิตวานฺ กินฺตุ วิศฺรามารฺถํ นิทฺรายำ กถิตวานฺ อิติ ชฺญาตฺวา ศิษฺยา อกถยนฺ, ");
INSERT INTO santha_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","เห คุโร ส ยทิ นิทฺราติ ตรฺหิ ภทฺรเมวฯ ");
INSERT INTO santha_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ตทา ยีศุ: สฺปษฺฏํ ตานฺ วฺยาหรตฺ, อิลิยาสรฺ อมฺริยต; ");
INSERT INTO santha_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","กินฺตุ ยูยํ ยถา ปฺรตีถ ตทรฺถมหํ ตตฺร น สฺถิตวานฺ อิตฺยสฺมาทฺ ยุษฺมนฺนิมิตฺตมฺ อาหฺลาทิโตหํ, ตถาปิ ตสฺย สมีเป ยามฯ ");
INSERT INTO santha_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ตทา โถมา ยํ ทิทุมํ วทนฺติ ส สงฺคิน: ศิษฺยานฺ อวททฺ วยมปิ คตฺวา เตน สารฺทฺธํ มฺริยามไหฯ ");
INSERT INTO santha_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ยีศุสฺตโตฺรปสฺถาย อิลิยาสร: ศฺมศาเน สฺถาปนาตฺ จตฺวาริ ทินานิ คตานีติ วารฺตฺตำ ศฺรุตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ไวถนียา ยิรูศาลม: สมีปสฺถา โกฺรไศกมาตฺรานฺตริตา; ");
INSERT INTO santha_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ตสฺมาทฺ พหโว ยิหูทียา มรฺถำ มริยมญฺจ ภฺยาตฺฤโศกาปนฺนำ สานฺตฺวยิตุํ ตโย: สมีปมฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","มรฺถา ยีโศราคมนวารฺตำ ศฺรุไตฺวว ตํ สากฺษาทฺ อกโรตฺ กินฺตุ มริยมฺ เคห อุปวิศฺย สฺถิตาฯ ");
INSERT INTO santha_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ตทา มรฺถา ยีศุมวาทตฺ, เห ปฺรโภ ยทิ ภวานฺ อตฺราสฺถาสฺยตฺ ตรฺหิ มม ภฺราตา นามริษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","กินฺตฺวิทานีมปิ ยทฺ อีศฺวเร ปฺรารฺถยิษฺยเต อีศฺวรสฺตทฺ ทาสฺยตีติ ชาเน'หํฯ ");
INSERT INTO santha_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ยีศุรวาทีตฺ ตว ภฺราตา สมุตฺถาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","มรฺถา วฺยาหรตฺ เศษทิวเส ส อุตฺถานสมเย โปฺรตฺถาสฺยตีติ ชาเน'หํฯ ");
INSERT INTO santha_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ตทา ยีศุ: กถิตวานฺ อหเมว อุตฺถาปยิตา ชีวยิตา จ ย: กศฺจน มยิ วิศฺวสิติ ส มฺฤตฺวาปิ ชีวิษฺยติ; ");
INSERT INTO santha_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ย: กศฺจน จ ชีวนฺ มยิ วิศฺวสิติ ส กทาปิ น มริษฺยติ, อสฺยำ กถายำ กึ วิศฺวสิษิ? ");
INSERT INTO santha_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","สาวทตฺ ปฺรโภ ยสฺยาวตรณาเปกฺษาสฺติ ภวานฺ เสอวาภิษิกฺตฺต อีศฺวรปุตฺร อิติ วิศฺวสิมิฯ ");
INSERT INTO santha_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","อิติ กถำ กถยิตฺวา สา คตฺวา สฺวำ ภคินีํ มริยมํ คุปฺตมาหูย วฺยาหรตฺ คุรุรุปติษฺฐติ ตฺวามาหูยติ จฯ ");
INSERT INTO santha_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","กถามิมำ ศฺรุตฺวา สา ตูรฺณมฺ อุตฺถาย ตสฺย สมีปมฺ อคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ยีศุ รฺคฺรามมธฺยํ น ปฺรวิศฺย ยตฺร มรฺถา ตํ สากฺษาทฺ อกโรตฺ ตตฺร สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","เย ยิหูทียา มริยมา สากํ คฺฤเห ติษฺฐนฺตสฺตามฺ อสานฺตฺวยน เต ตำ กฺษิปฺรมฺ อุตฺถาย คจฺฉนฺตึ วิโลกฺย วฺยาหรนฺ, ส ศฺมศาเน โรทิตุํ ยาติ, อิตฺยุกฺตฺวา เต ตสฺยา: ปศฺจาทฺ อคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ยตฺร ยีศุรติษฺฐตฺ ตตฺร มริยมฺ อุปสฺถาย ตํ ทฺฤษฺฏฺวา ตสฺย จรณโย: ปติตฺวา วฺยาหรตฺ เห ปฺรโภ ยทิ ภวานฺ อตฺราสฺถาสฺยตฺ ตรฺหิ มม ภฺราตา นามริษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ยีศุสฺตำ ตสฺยา: สงฺคิโน ยิหูทียำศฺจ รุทโต วิโลกฺย โศการฺตฺต: สนฺ ทีรฺฆํ นิศฺวสฺย กถิตวานฺ ตํ กุตฺราสฺถาปยต? ");
INSERT INTO santha_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","เต วฺยาหรนฺ, เห ปฺรโภ ภวานฺ อาคตฺย ปศฺยตุฯ ");
INSERT INTO santha_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ยีศุนา กฺรนฺทิตํฯ ");
INSERT INTO santha_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","อเตอว ยิหูทียา อวทนฺ, ปศฺยตายํ ตสฺมินฺ กิทฺฤคฺ อปฺริยตฯ ");
INSERT INTO santha_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","เตษำ เกจิทฺ อวทนฺ โยนฺธาย จกฺษุษี ทตฺตวานฺ ส กิมฺ อสฺย มฺฤตฺยุํ นิวารยิตุํ นาศกฺโนตฺ? ");
INSERT INTO santha_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ตโต ยีศุ: ปุนรนฺตรฺทีรฺฆํ นิศฺวสฺย ศฺมศานานฺติกมฺ อคจฺฉตฺฯ ตตฺ ศฺมศานมฺ เอกํ คหฺวรํ ตนฺมุเข ปาษาณ เอก อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ตทา ยีศุรวททฺ เอนํ ปาษาณมฺ อปสารยต, ตต: ปฺรมีตสฺย ภคินี มรฺถาวทตฺ ปฺรโภ, อธุนา ตตฺร ทุรฺคนฺโธ ชาต:, ยโตทฺย จตฺวาริ ทินานิ ศฺมศาเน ส ติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ตทา ยีศุรวาทีตฺ, ยทิ วิศฺวสิษิ ตรฺหีศฺวรสฺย มหิมปฺรกาศํ ทฺรกฺษฺยสิ กถามิมำ กึ ตุภฺยํ นากถยํ? ");
INSERT INTO santha_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ตทา มฺฤตสฺย ศฺมศานาตฺ ปาษาโณ'ปสาริเต ยีศุรูรฺทฺวฺวํ ปศฺยนฺ อกถยตฺ, เห ปิต รฺมม เนเวสนมฺ อศฺฤโณ: การณาทสฺมาตฺ ตฺวำ ธนฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ตฺวํ สตตํ ศฺฤโณษิ ตทปฺยหํ ชานามิ, กินฺตุ ตฺวํ มำ ยตฺ ไปฺรรยสฺตทฺ ยถาสฺมินฺ สฺถาเน สฺถิตา โลกา วิศฺวสนฺติ ตทรฺถมฺ อิทํ วากฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","อิมำ กถำ กถยิตฺวา ส โปฺรจฺไจราหฺวยตฺ, เห อิลิยาสรฺ พหิราคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ตต: ส ปฺรมีต: ศฺมศานวสฺไตฺร รฺพทฺธหสฺตปาโท คาตฺรมารฺชนวาสสา พทฺธมุขศฺจ พหิราคจฺฉตฺฯ ยีศุรุทิตวานฺ พนฺธนานิ โมจยิตฺวา ตฺยชไตนํฯ ");
INSERT INTO santha_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","มริยม: สมีปมฺ อาคตา เย ยิหูทียโลกาสฺตทา ยีโศเรตตฺ กรฺมฺมาปศฺยนฺ เตษำ พหโว วฺยศฺวสนฺ, ");
INSERT INTO santha_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","กินฺตุ เกจิทเนฺย ผิรูศินำ สมีปํ คตฺวา ยีโศเรตสฺย กรฺมฺมโณ วารฺตฺตามฺ อวทนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ตต: ปรํ ปฺรธานยาชกา: ผิรูศินาศฺจ สภำ กฺฤตฺวา วฺยาหรนฺ วยํ กึ กุรฺมฺม:? เอษ มานโว พหูนฺยาศฺจรฺยฺยกรฺมฺมาณิ กโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ยทีทฺฤศํ กรฺมฺม กรฺตฺตุํ น วารยามสฺตรฺหิ สรฺเวฺว โลกาสฺตสฺมินฺ วิศฺวสิษฺยนฺติ โรมิโลกาศฺจาคตฺยาสฺมากมฺ อนยา ราชธานฺยา สารฺทฺธํ ราชฺยมฺ อาเฉตฺสฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ตทา เตษำ กิยผานามา ยสฺตสฺมินฺ วตฺสเร มหายาชกปเท นฺยยุชฺยต ส ปฺรตฺยวททฺ ยูยํ กิมปิ น ชานีถ; ");
INSERT INTO santha_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","สมคฺรเทศสฺย วินาศโตปิ สรฺวฺวโลการฺถมฺ เอกสฺย ชนสฺย มรณมฺ อสฺมากํ มงฺคลเหตุกมฺ เอตสฺย วิเวจนามปิ น กุรุถฯ ");
INSERT INTO santha_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","เอตำ กถำ ส นิชพุทฺธฺยา วฺยาหรทฺ อิติ น, ");
INSERT INTO santha_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","กินฺตุ ยีศูสฺตทฺเทศียานำ การณาตฺ ปฺราณานฺ ตฺยกฺษฺยติ, ทิศิ ทิศิ วิกีรฺณานฺ อีศฺวรสฺย สนฺตานานฺ สํคฺฤไหฺยกชาตึ กริษฺยติ จ, ตสฺมินฺ วตฺสเร กิยผา มหายาชกตฺวปเท นิยุกฺต: สนฺ อิทํ ภวิษฺยทฺวากฺยํ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ตทฺทินมารภฺย เต กถํ ตํ หนฺตุํ ศกฺนุวนฺตีติ มนฺตฺรณำ กรฺตฺตุํ ปฺราเรภิเรฯ ");
INSERT INTO santha_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","อเตอว ยิหูทียานำ มเธฺย ยีศุ: สปฺรกาศํ คมนาคมเน อกฺฤตฺวา ตสฺมาทฺ คตฺวา ปฺรานฺตรสฺย สมีปสฺถายิปฺรเทศเสฺยผฺรายิมฺ นามฺนิ นคเร ศิไษฺย: สากํ กาลํ ยาปยิตุํ ปฺราเรเภฯ ");
INSERT INTO santha_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","อนนฺตรํ ยิหูทียานำ นิสฺตาโรตฺสเว นิกฏวรฺตฺตินิ สติ ตทุตฺสวาตฺ ปูรฺวฺวํ สฺวานฺ ศุจีนฺ กรฺตฺตุํ พหโว ชนา คฺราเมโภฺย ยิรูศาลมฺ นครมฺ อาคจฺฉนฺ, ");
INSERT INTO santha_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ยีโศรเนฺวษณํ กฺฤตฺวา มนฺทิเร ทณฺฑายมานา: สนฺต: ปรสฺปรํ วฺยาหรนฺ, ยุษฺมากํ กีทฺฤโศ โพโธ ชายเต? ส กิมฺ อุตฺสเว'สฺมินฺ อตฺราคมิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ส จ กุตฺราสฺติ ยเทฺยตตฺ กศฺจิทฺ เวตฺติ ตรฺหิ ทรฺศยตุ ปฺรธานยาชกา: ผิรูศินศฺจ ตํ ธรฺตฺตุํ ปูรฺวฺวมฺ อิมามฺ อาชฺญำ ปฺราจารยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","นิสฺตาโรตฺสวาตฺ ปูรฺวฺวํ ทินษฏฺเก สฺถิเต ยีศุ รฺยํ ปฺรมีตมฺ อิลิยาสรํ ศฺมศานาทฺ อุทสฺถาปรตฺ ตสฺย นิวาสสฺถานํ ไพถนิยาคฺรามมฺ อาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ตตฺร ตทรฺถํ รชนฺยำ โภเชฺย กฺฤเต มรฺถา ปรฺยฺยเวษยทฺ อิลิยาสรฺ จ ตสฺย สงฺคิภิ: สารฺทฺธํ โภชนาสน อุปาวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ตทา มริยมฺ อรฺทฺธเสฏกํ พหุมูลฺยํ ชฏามำสียํ ไตลมฺ อานีย ยีโศศฺจรณโย รฺมรฺทฺทยิตฺวา นิชเกศ รฺมารฺษฺฏุมฺ อารภต; ตทา ไตลสฺย ปริมเลน คฺฤหมฺ อาโมทิตมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ย: ศิโมน: ปุตฺร ริษฺกริโยตีโย ยิหูทานามา ยีศุํ ปรกเรษุ สมรฺปยิษฺยติ ส ศิษฺยสฺตทา กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","เอตตฺไตลํ ตฺริภิ: ศไต รฺมุทฺราปไท รฺวิกฺรีตํ สทฺ ทริเทฺรภฺย: กุโต นาทียต? ");
INSERT INTO santha_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ส ทริทฺรโลการฺถมฺ อจินฺตยทฺ อิติ น, กินฺตุ ส เจาร เอวํ ตนฺนิกเฏ มุทฺราสมฺปุฏกสฺถิตฺยา ตนฺมเธฺย ยทติษฺฐตฺ ตทปาหรตฺ ตสฺมาตฺ การณาทฺ อิมำ กถามกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ตทา ยีศุรกถยทฺ เอนำ มา วารย สา มม ศฺมศานสฺถาปนทินารฺถํ ตทรกฺษยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ทริทฺรา ยุษฺมากํ สนฺนิเธา สรฺวฺวทา ติษฺฐนฺติ กินฺตฺวหํ สรฺวฺวทา ยุษฺมากํ สนฺนิเธา น ติษฺฐามิฯ ");
INSERT INTO santha_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ตต: ปรํ ยีศุสฺตตฺราสฺตีติ วารฺตฺตำ ศฺรุตฺวา พหโว ยิหูทียาสฺตํ ศฺมศานาทุตฺถาปิตมฺ อิลิยาสรญฺจ ทฺรษฺฏุํ ตตฺ สฺถานมฺ อาคจฺฉนฯ ");
INSERT INTO santha_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ตทา ปฺรธานยาชกาสฺตมฺ อิลิยาสรมปิ สํหรฺตฺตุมฺ อมนฺตฺรยนฺ ; ");
INSERT INTO santha_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ยตเสฺตน พหโว ยิหูทียา คตฺวา ยีเศา วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","อนนฺตรํ ยีศุ รฺยิรูศาลมฺ นครมฺ อาคจฺฉตีติ วารฺตฺตำ ศฺรุตฺวา ปเร'หนิ อุตฺสวาคตา พหโว โลกา: ");
INSERT INTO santha_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ขรฺชฺชูรปตฺราทฺยานีย ตํ สากฺษาตฺ กรฺตฺตุํ พหิราคตฺย ชย ชเยติ วาจํ โปฺรจฺไจ รฺวกฺตุมฺ อารภนฺต, อิสฺราเยโล โย ราชา ปรเมศฺวรสฺย นามฺนาคจฺฉติ ส ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ตทา \"เห สิโยน: กเนฺย มา ไภษี: ปศฺยายํ ตว ราชา ครฺทฺทภศาวกมฺ อารุหฺยาคจฺฉติ\" ");
INSERT INTO santha_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","อิติ ศาสฺตฺรียวจนานุสาเรณ ยีศุเรกํ ยุวครฺทฺทภํ ปฺราปฺย ตทุปรฺยฺยาโรหตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","อสฺยา: ฆฏนายาสฺตาตฺปรฺยฺยํ ศิษฺยา: ปฺรถมํ นาพุธฺยนฺต, กินฺตุ ยีเศา มหิมานํ ปฺราปฺเต สติ วากฺยมิทํ ตสฺมิน อกถฺยต โลกาศฺจ ตมฺปฺรตีตฺถมฺ อกุรฺวฺวนฺ อิติ เต สฺมฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ส อิลิยาสรํ ศฺมศานาทฺ อาคนฺตุมฺ อาหฺวตวานฺ ศฺมศานาญฺจ อุทสฺถาปยทฺ เย เย โลกาสฺตตฺกรฺมฺย สากฺษาทฺ อปศฺยนฺ เต ปฺรมาณํ ทาตุมฺ อารภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ส เอตาทฺฤศมฺ อทฺภุตํ กรฺมฺมกโรตฺ ตสฺย ชนศฺรุเต โรฺลกาสฺตํ สากฺษาตฺ กรฺตฺตุมฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ตต: ผิรูศิน: ปรสฺปรํ วกฺตุมฺ อารภนฺต ยุษฺมากํ สรฺวฺวาศฺเจษฺฏา วฺฤถา ชาตา:, อิติ กึ ยูยํ น พุธฺยเธฺว? ปศฺยต สรฺเวฺว โลกาสฺตสฺย ปศฺจาทฺวรฺตฺติโนภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ภชนํ กรฺตฺตุมฺ อุตฺสวาคตานำ โลกานำ กติปยา ชนา อนฺยเทศียา อาสนฺ , ");
INSERT INTO santha_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","เต คาลีลียไพตฺไสทานิวาสิน: ผิลิปสฺย สมีปมฺ อาคตฺย วฺยาหรนฺ เห มเหจฺฉ วยํ ยีศุํ ทฺรษฺฏุมฺ อิจฺฉาม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ตต: ผิลิโป คตฺวา อานฺทฺริยมฺ อวทตฺ ปศฺจาทฺ อานฺทฺริยผิลิเปา ยีศเว วารฺตฺตามฺ อกถยตำฯ ");
INSERT INTO santha_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ตทา ยีศุ: ปฺรตฺยุทิตวานฺ มานวสุตสฺย มหิมปฺราปฺติสมย อุปสฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","อหํ ยุษฺมานติยถารฺถํ วทามิ, ธานฺยพีชํ มฺฤตฺติกายำ ปติตฺวา ยทิ น มฺฤยเต ตเรฺหฺยกากี ติษฺฐติ กินฺตุ ยทิ มฺฤยเต ตรฺหิ พหุคุณํ ผลํ ผลติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","โย ชเนा นิชปฺราณานฺ ปฺริยานฺ ชานาติ ส ตานฺ หารยิษฺยติ กินฺตุ เยा ชน อิหโลเก นิชปฺราณานฺ อปฺริยานฺ ชานาติ เสाนนฺตายุ: ปฺราปฺตุํ ตานฺ รกฺษิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","กศฺจิทฺ ยทิ มม เสวโก ภวิตุํ วาญฺฉติ ตรฺหิ ส มม ปศฺจาทฺคามี ภวตุ, ตสฺมาทฺ อหํ ยตฺร ติษฺฐามิ มม เสวเกाปิ ตตฺร สฺถาสฺยติ; โย ชโน มำ เสวเต มม ปิตาปิ ตํ สมฺมํสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","สามฺปฺรตํ มม ปฺราณา วฺยากุลา ภวนฺติ, ตสฺมาทฺ เห ปิตร เอตสฺมาตฺ สมยานฺ มำ รกฺษ, อิตฺยหํ กึ ปฺรารฺถยิเษฺย? กินฺตฺวหมฺ เอตตฺสมยารฺถมฺ อวตีรฺณวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","เห ปิต: สฺวนามฺโน มหิมานํ ปฺรกาศย; ตไนว สฺวนามฺโน มหิมานมฺ อหํ ปฺรากาศยํ ปุนรปิ ปฺรกาศยิษฺยามิ, เอษา คคณียา วาณี ตสฺมินฺ สมเย'ชายตฯ ");
INSERT INTO santha_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ตจฺศฺรุตฺวา สมีปสฺถโลกานำ เกจิทฺ อวทนฺ เมโฆ'ครฺชีตฺ, เกจิทฺ อวทนฺ สฺวรฺคียทูโต'เนน สห กถามจกถตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ตทา ยีศุ: ปฺรตฺยวาทีตฺ, มทรฺถํ ศพฺโทยํ นาภูตฺ ยุษฺมทรฺถเมวาภูตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","อธุนา ชคโตสฺย วิจาร: สมฺปตฺสฺยเต, อธุนาสฺย ชคต: ปตี ราชฺยาตฺ โจฺยษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ยทฺยอี ปฺฤถิวฺยา อูรฺทฺเวฺว โปฺรตฺถาปิโตสฺมิ ตรฺหิ สรฺวฺวานฺ มานวานฺ สฺวสมีปมฺ อากรฺษิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","กถํ ตสฺย มฺฤติ รฺภวิษฺยติ, เอตทฺ โพธยิตุํ ส อิมำ กถามฺ อกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ตทา โลกา อกถยนฺ โสภิษิกฺต: สรฺวฺวทา ติษฺฐตีติ วฺยวสฺถาคฺรนฺเถ ศฺรุตมฺ อสฺมาภิ:, ตรฺหิ มนุษฺยปุตฺร: โปฺรตฺถาปิโต ภวิษฺยตีติ วากฺยํ กถํ วทสิ? มนุษฺยปุโตฺรยํ ก:? ");
INSERT INTO santha_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ตทา ยีศุรกถายทฺ ยุษฺมาภิ: สารฺทฺธมฺ อลฺปทินานิ โชฺยติราเสฺต, ยถา ยุษฺมานฺ อนฺธกาโร นาจฺฉาทยติ ตทรฺถํ ยาวตฺกาลํ ยุษฺมาภิ: สารฺทฺธํ โชฺยติสฺติษฺฐติ ตาวตฺกาลํ คจฺฉต; โย ชโน'นฺธกาเร คจฺฉติ ส กุตฺร ยาตีติ น ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","อเตอว ยาวตฺกาลํ ยุษฺมากํ นิกเฏ โชฺยติราเสฺต ตาวตฺกาลํ โชฺยตีรูปสนฺตานา ภวิตุํ โชฺยติษิ วิศฺวสิต; อิมำ กถำ กถยิตฺวา ยีศุ: ปฺรสฺถาย เตภฺย: สฺวํ คุปฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ยทฺยปิ ยีศุเสฺตษำ สมกฺษมฺ เอตาวทาศฺจรฺยฺยกรฺมฺมาณิ กฺฤตวานฺ ตถาปิ เต ตสฺมินฺ น วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","อเตอว ก: ปฺรเตฺยติ สุสํวาทํ ปเรศาสฺมตฺ ปฺรจาริตํ? ปฺรกาศเต ปเรศสฺย หสฺต: กสฺย จ สนฺนิเธา? ยิศยิยภวิษฺยทฺวาทินา ยเทตทฺ วากฺยมุกฺตํ ตตฺ สผลมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","เต ปฺรเตฺยตุํ นาศนฺกุวนฺ ตสฺมินฺ ยิศยิยภวิษฺยทฺวาทิ ปุนรวาทีทฺ, ");
INSERT INTO santha_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ยทา, \"เต นยไน รฺน ปศฺยนฺติ พุทฺธิภิศฺจ น พุธฺยนฺเต ไต รฺมน:สุ ปริวรฺตฺติเตษุ จ ตานหํ ยถา สฺวสฺถานฺ น กโรมิ ตถา ส เตษำ โลจนานฺยนฺธานิ กฺฤตฺวา เตษามนฺต:กรณานิ คาฒานิ กริษฺยติฯ \" ");
INSERT INTO santha_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ยิศยิโย ยทา ยีโศ รฺมหิมานํ วิโลกฺย ตสฺมินฺ กถามกถยตฺ ตทา ภวิษฺยทฺวากฺยมฺ อีทฺฤศํ ปฺรกาศยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ตถาปฺยธิปตินำ พหวสฺตสฺมินฺ ปฺรตฺยายนฺฯ กินฺตุ ผิรูศินสฺตานฺ ภชนคฺฤหาทฺ ทูรีกุรฺวฺวนฺตีติ ภยาตฺ เต ตํ น สฺวีกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ยต อีศฺวรสฺย ปฺรศํสาโต มานวานำ ปฺรศํสายำ เต'ปฺริยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ตทา ยีศุรุจฺไจ:การมฺ อกถยทฺ โย ชโน มยิ วิศฺวสิติ ส เกวเล มยิ วิศฺวสิตีติ น, ส มตฺเปฺรรเก'ปิ วิศฺวสิติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","โย ชโน มำ ปศฺยติ ส มตฺเปฺรรกมปิ ปศฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","โย ชโน มำ ปฺรเตฺยติ ส ยถานฺธกาเร น ติษฺฐติ ตทรฺถมฺ อหํ โชฺยติ:สฺวรูโป ภูตฺวา ชคตฺยสฺมินฺ อวตีรฺณวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","มม กถำ ศฺรุตฺวา ยทิ กศฺจินฺ น วิศฺวสิติ ตรฺหิ ตมหํ โทษิณํ น กโรมิ, ยโต เหโต รฺชคโต ชนานำ โทษานฺ นิศฺจิตานฺ กรฺตฺตุํ นาคตฺย ตานฺ ปริจาตุมฺ อาคโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ย: กศฺจินฺ มำ น ศฺรทฺธาย มม กถํ น คฺฤหฺลาติ, อนฺยสฺตํ โทษิณํ กริษฺยติ วสฺตุตสฺตุ ยำ กถามหมฺ อจกถํ สา กถา จรเม'นฺหิ ตํ โทษิณํ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ยโต เหโตรหํ สฺวต: กิมปิ น กถยามิ, กึ กึ มยา กถยิตวฺยํ กึ สมุปเทษฺฏวฺยญฺจ อิติ มตฺเปฺรรยิตา ปิตา มามาชฺญาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ตสฺย สาชฺญา อนนฺตายุริตฺยหํ ชานามิ, อเตอวาหํ ยตฺ กถยามิ ตตฺ ปิตา ยถาชฺญาปยตฺ ตไถว กถยามฺยหมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","นิสฺตาโรตฺสวสฺย กิญฺจิตฺกาลาตฺ ปูรฺวฺวํ ปฺฤถิวฺยา: ปิตุ: สมีปคมนสฺย สมย: สนฺนิกรฺโษภูทฺ อิติ ชฺญาตฺวา ยีศุราปฺรถมาทฺ เยษุ ชคตฺปฺรวาสิษฺวาตฺมียโลเกษ เปฺรม กโรติ สฺม เตษุ เศษํ ยาวตฺ เปฺรม กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ปิตา ตสฺย หเสฺต สรฺวฺวํ สมรฺปิตวานฺ สฺวยมฺ อีศฺวรสฺย สมีปาทฺ อาคจฺฉทฺ อีศฺวรสฺย สมีปํ ยาสฺยติ จ, สรฺวฺวาเณฺยตานิ ชฺญาตฺวา รชนฺยำ โภชเน สมฺปูรฺเณ สติ, ");
INSERT INTO santha_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ยทา ไศตานฺ ตํ ปรหเสฺตษุ สมรฺปยิตุํ ศิโมน: ปุตฺรสฺย อีษฺการิโยติยสฺย ยิหูทา อนฺต:กรเณ กุปฺรวฺฤตฺตึ สมารฺปยตฺ, ");
INSERT INTO santha_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ตทา ยีศุ โรฺภชนาสนาทฺ อุตฺถาย คาตฺรวสฺตฺรํ โมจยิตฺวา คาตฺรมารฺชนวสฺตฺรํ คฺฤหีตฺวา เตน สฺวกฏิมฺ อพธฺนาตฺ, ");
INSERT INTO santha_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ปศฺจาทฺ เอกปาเตฺร ชลมฺ อภิษิจฺย ศิษฺยาณำ ปาทานฺ ปฺรกฺษาลฺย เตน กฏิพทฺธคาตฺรมารฺชนวาสสา มารฺษฺฏุํ ปฺรารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ตต: ศิโมนฺปิตรสฺย สมีปมาคเต ส อุกฺตวานฺ เห ปฺรโภ ภวานฺ กึ มม ปาเทา ปฺรกฺษาลยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ยีศุรุทิตวานฺ อหํ ยตฺ กโรมิ ตตฺ สมฺปฺรติ น ชานาสิ กินฺตุ ปศฺจาชฺ ชฺญาสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ตต: ปิตร: กถิตวานฺ ภวานฺ กทาปิ มม ปาเทา น ปฺรกฺษาลยิษฺยติฯ ยีศุรกถยทฺ ยทิ ตฺวำ น ปฺรกฺษาลเย ตรฺหิ มยิ ตว โกปฺยํโศ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ตทา ศิโมนฺปิตร: กถิตวานฺ เห ปฺรโภ ตรฺหิ เกวลปาเทา น, มม หเสฺตา ศิรศฺจ ปฺรกฺษาลยตุฯ ");
INSERT INTO santha_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ตโต ยีศุรวททฺ โย ชโน เธาตสฺตสฺย สรฺวฺวางฺคปริษฺกฺฤตตฺวาตฺ ปาเทา วินานฺยางฺคสฺย ปฺรกฺษาลนาเปกฺษา นาสฺติฯ ยูยํ ปริษฺกฺฤตา อิติ สตฺยํ กินฺตุ น สรฺเวฺว, ");
INSERT INTO santha_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ยโต โย ชนสฺตํ ปรกเรษุ สมรฺปยิษฺยติ ตํ ส ชฺญาตวาน; อเตอว ยูยํ สรฺเวฺว น ปริษฺกฺฤตา อิมำ กถำ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","อิตฺถํ ยีศุเสฺตษำ ปาทานฺ ปฺรกฺษาลฺย วสฺตฺรํ ปริธายาสเน สมุปวิศฺย กถิตวานฺ อหํ ยุษฺมานฺ ปฺรติ กึ กรฺมฺมาการฺษํ ชานีถ? ");
INSERT INTO santha_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ยูยํ มำ คุรุํ ปฺรภุญฺจ วทถ ตตฺ สตฺยเมว วทถ ยโตหํ เสอว ภวามิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ยทฺยหํ ปฺรภุ รฺคุรุศฺจ สนฺ ยุษฺมากํ ปาทานฺ ปฺรกฺษาลิตวานฺ ตรฺหิ ยุษฺมากมปิ ปรสฺปรํ ปาทปฺรกฺษาลนมฺ อุจิตมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","อหํ ยุษฺมานฺ ปฺรติ ยถา วฺยวาหรํ ยุษฺมานฺ ตถา วฺยวหรฺตฺตุมฺ เอกํ ปนฺถานํ ทรฺศิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","อหํ ยุษฺมานติยถารฺถํ วทามิ, ปฺรโภ รฺทาโส น มหานฺ เปฺรรกาจฺจ เปฺรริโต น มหานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","อิมำ กถำ วิทิตฺวา ยทิ ตทนุสารต: กรฺมฺมาณิ กุรุถ ตรฺหิ ยูยํ ธนฺยา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","สรฺเวฺวษุ ยุษฺมาสุ กถามิมำ กถยามิ อิติ น, เย มม มโนนีตาสฺตานหํ ชานามิ, กินฺตุ มม ภกฺษฺยาณิ โย ภุงฺกฺเต มตฺปฺราณปฺราติกูลฺยต:ฯ อุตฺถาปยติ ปาทสฺย มูลํ ส เอษ มานว:ฯ ยเทตทฺ ธรฺมฺมปุสฺตกสฺย วจนํ ตทนุสาเรณาวศฺยํ ฆฏิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","อหํ ส ชน อิตฺยตฺร ยถา ยุษฺมากํ วิศฺวาโส ชายเต ตทรฺถํ เอตาทฺฤศฆฏนาตฺ ปูรฺวฺวมฺ อหมิทานีํ ยุษฺมภฺยมกถยมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","อหํ ยุษฺมานตีว ยถารฺถํ วทามิ, มยา เปฺรริตํ ชนํ โย คฺฤหฺลาติ ส มาเมว คฺฤหฺลาติ ยศฺจ มำ คฺฤหฺลาติ ส มตฺเปฺรรกํ คฺฤหฺลาติฯ ");
INSERT INTO santha_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","เอตำ กถำ กถยิตฺวา ยีศุ รฺทุ:ขี สนฺ ปฺรมาณํ ทตฺตฺวา กถิตวานฺ อหํ ยุษฺมานติยถารฺถํ วทามิ ยุษฺมากมฺ เอโก ชโน มำ ปรกเรษุ สมรฺปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ตต: ส กมุทฺทิศฺย กถาเมตำ กถิตวานฺ อิตฺยตฺร สนฺทิคฺธา: ศิษฺยา: ปรสฺปรํ มุขมาโลกยิตุํ ปฺรารภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ตสฺมินฺ สมเย ยีศุ รฺยสฺมินฺ อปฺรียต ส ศิษฺยสฺตสฺย วกฺษ:สฺถลมฺ อวาลมฺพตฯ ");
INSERT INTO santha_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ศิโมนฺปิตรสฺตํ สงฺเกเตนาวทตฺ, อยํ กมุทฺทิศฺย กถาเมตามฺ กถยตีติ ปฺฤจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ตทา ส ยีโศ รฺวกฺษ:สฺถลมฺ อวลมฺพฺย ปฺฤษฺฐวานฺ, เห ปฺรโภ ส ชน: ก:? ");
INSERT INTO santha_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ตโต ยีศุ: ปฺรตฺยวททฺ เอกขณฺฑํ ปูปํ มชฺชยิตฺวา ยไสฺม ทาสฺยามิ เสอว ส:; ปศฺจาตฺ ปูปขณฺฑเมกํ มชฺชยิตฺวา ศิโมน: ปุตฺราย อีษฺกริโยตียาย ยิหูไท ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ตสฺมินฺ ทตฺเต สติ ไศตานฺ ตมาศฺรยตฺ; ตทา ยีศุสฺตมฺ อวทตฺ ตฺวํ ยตฺ กริษฺยสิ ตตฺ กฺษิปฺรํ กุรุฯ ");
INSERT INTO santha_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","กินฺตุ ส เยนาศเยน ตำ กถามกถายตฺ ตมฺ อุปวิษฺฏโลกานำ โกปิ นาพุธฺยต; ");
INSERT INTO santha_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","กินฺตุ ยิหูทา: สมีเป มุทฺราสมฺปุฏกสฺถิเต: เกจิทฺ อิตฺถมฺ อพุธฺยนฺต ปารฺวฺวณาสาทนารฺถํ กิมปิ ทฺรวฺยํ เกฺรตุํ วา ทริเทฺรภฺย: กิญฺจิทฺ วิตริตุํ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ตทา ปูปขณฺฑคฺรหณาตฺ ปรํ ส ตูรฺณํ พหิรคจฺฉตฺ; ราตฺริศฺจ สมุปสฺยิตาฯ ");
INSERT INTO santha_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ยิหูเท พหิรฺคเต ยีศุรกถยทฺ อิทานีํ มานวสุตสฺย มหิมา ปฺรกาศเต เตเนศฺวรสฺยาปิ มหิมา ปฺรกาศเตฯ ");
INSERT INTO santha_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ยทิ เตเนศฺวรสฺย มหิมา ปฺรกาศเต ตรฺหีศฺวโรปิ เสฺวน ตสฺย มหิมานํ ปฺรกาศยิษฺยติ ตูรฺณเมว ปฺรกาศยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","เห วตฺสา อหํ ยุษฺมาภิ: สารฺทฺธํ กิญฺจิตฺกาลมาตฺรมฺ อาเส, ตต: ปรํ มำ มฺฤคยิษฺยเธฺว กินฺตฺวหํ ยตฺสฺถานํ ยามิ ตตฺสฺถานํ ยูยํ คนฺตุํ น ศกฺษฺยถ, ยามิมำ กถำ ยิหูทีเยภฺย: กถิตวานฺ ตถาธุนา ยุษฺมภฺยมปิ กถยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ยูยํ ปรสฺปรํ ปฺรียธฺวมฺ อหํ ยุษฺมาสุ ยถา ปฺรีเย ยูยมปิ ปรสฺปรมฺ ตไถว ปฺรียธฺวํ, ยุษฺมานฺ อิมำ นวีนามฺ อาชฺญามฺ อาทิศามิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","เตไนว ยทิ ปรสฺปรํ ปฺรียเธฺว ตรฺหิ ลกฺษเณนาเนน ยูยํ มม ศิษฺยา อิติ สรฺเวฺว ชฺญาตุํ ศกฺษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ศิโมนปิตร: ปฺฤษฺฐวานฺ เห ปฺรโภ ภวานฺ กุตฺร ยาสฺยติ? ตโต ยีศุ: ปฺรตฺยวทตฺ, อหํ ยตฺสฺถานํ ยามิ ตตฺสฺถานํ สามฺปฺรตํ มม ปศฺจาทฺ คนฺตุํ น ศกฺโนษิ กินฺตุ ปศฺจาทฺ คมิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ตทา ปิตร: ปฺรตฺยุทิตวานฺ, เห ปฺรโภ สามฺปฺรตํ กุโต เหโตสฺตว ปศฺจาทฺ คนฺตุํ น ศกฺโนมิ? ตฺวทรฺถํ ปฺราณานฺ ทาตุํ ศกฺโนมิฯ ");
INSERT INTO santha_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ตโต ยีศุ: ปฺรตฺยุกฺตวานฺ มนฺนิมิตฺตํ กึ ปฺราณานฺ ทาตุํ ศกฺโนษิ? ตฺวามหํ ยถารฺถํ วทามิ, กุกฺกุฏรวณาตฺ ปูรฺวฺวํ ตฺวํ ตฺริ รฺมามฺ อปโหฺนษฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","มโนทุ:ขิโน มา ภูต; อีศฺวเร วิศฺวสิต มยิ จ วิศฺวสิตฯ ");
INSERT INTO santha_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","มม ปิตุ คฺฤเห พหูนิ วาสสฺถานิ สนฺติ โน เจตฺ ปูรฺวฺวํ ยุษฺมานฺ อชฺญาปยิษฺยํ ยุษฺมทรฺถํ สฺถานํ สชฺชยิตุํ คจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ยทิ คตฺวาหํ ยุษฺมนฺนิมิตฺตํ สฺถานํ สชฺชยามิ ตรฺหิ ปนราคตฺย ยุษฺมานฺ สฺวสมีปํ เนษฺยามิ, ตโต ยตฺราหํ ติษฺฐามิ ตตฺร ยูยมปิ สฺถาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","อหํ ยตฺสฺถานํ พฺรชามิ ตตฺสฺถานํ ยูยํ ชานีถ ตสฺย ปนฺถานมปิ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ตทา โถมา อวทตฺ, เห ปฺรโภ ภวานฺ กุตฺร ยาติ ตทฺวยํ น ชานีม:, ตรฺหิ กถํ ปนฺถานํ ชฺญาตุํ ศกฺนุม:? ");
INSERT INTO santha_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ยีศุรกถยทฺ อหเมว สตฺยชีวนรูปปโถ มยา น คนฺตา โกปิ ปิตุ: สมีปํ คนฺตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ยทิ มามฺ อชฺญาสฺยต ตรฺหิ มม ปิตรมปฺยชฺญาสฺยต กินฺตฺวธุนาตสฺตํ ชานีถ ปศฺยถ จฯ ");
INSERT INTO santha_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ตทา ผิลิป: กถิตวานฺ, เห ปฺรโภ ปิตรํ ทรฺศย ตสฺมาทสฺมากํ ยเถษฺฏํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ตโต ยีศุ: ปฺรตฺยาวาทีตฺ, เห ผิลิป ยุษฺมาภิ: สารฺทฺธมฺ เอตาวทฺทินานิ สฺถิตมปิ มำ กึ น ปฺรตฺยภิชานาสิ? โย ชโน มามฺ อปศฺยตฺ ส ปิตรมปฺยปศฺยตฺ ตรฺหิ ปิตรมฺ อสฺมานฺ ทรฺศเยติ กถำ กถํ กถยสิ? ");
INSERT INTO santha_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","อหํ ปิตริ ติษฺฐามิ ปิตา มยิ ติษฺฐตีติ กึ ตฺวํ น ปฺรตฺยษิ? อหํ ยทฺวากฺยํ วทามิ ตตฺ สฺวโต น วทามิ กินฺตุ ย: ปิตา มยิ วิราชเต ส เอว สรฺวฺวกรฺมฺมาณิ กราติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","อเตอว ปิตรฺยฺยหํ ติษฺฐามิ ปิตา จ มยิ ติษฺฐติ มมาสฺยำ กถายำ ปฺรตฺยยํ กุรุต, โน เจตฺ กรฺมฺมเหโต: ปฺรตฺยยํ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","อหํ ยุษฺมานติยถารฺถํ วทามิ, โย ชโน มยิ วิศฺวสิติ โสหมิว กรฺมฺมาณิ กริษฺยติ วรํ ตโตปิ มหากรฺมฺมาณิ กริษฺยติ ยโต เหโตรหํ ปิตุ: สมีปํ คจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ยถา ปุเตฺรณ ปิตุ รฺมหิมา ปฺรกาศเต ตทรฺถํ มม นาม โปฺรจฺย ยตฺ ปฺรารฺถยิษฺยเธฺว ตตฺ สผลํ กริษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ยทิ มม นามฺนา ยตฺ กิญฺจิทฺ ยาจเธฺว ตรฺหิ ตทหํ สาธยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ยทิ มยิ ปฺรียเธฺว ตรฺหิ มมาชฺญา: สมาจรตฯ ");
INSERT INTO santha_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ตโต มยา ปิตุ: สมีเป ปฺรารฺถิเต ปิตา นิรนฺตรํ ยุษฺมาภิ: สารฺทฺธํ สฺถาตุมฺ อิตรเมกํ สหายมฺ อรฺถาตฺ สตฺยมยมฺ อาตฺมานํ ยุษฺมากํ นิกฏํ เปฺรษยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","เอตชฺชคโต โลกาสฺตํ คฺรหีตุํ น ศกฺนุวนฺติ ยตเสฺต ตํ นาปศฺยนฺ นาชนํศฺจ กินฺตุ ยูยํ ชานีถ ยโต เหโต: ส ยุษฺมากมนฺต รฺนิวสติ ยุษฺมากํ มเธฺย สฺถาสฺยติ จฯ ");
INSERT INTO santha_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","อหํ ยุษฺมานฺ อนาถานฺ กฺฤตฺวา น ยาสฺยามิ ปุนรปิ ยุษฺมากํ สมีปมฺ อาคมิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","กิยตฺกาลรตฺ ปรมฺ อสฺย ชคโต โลกา มำ ปุน รฺน ทฺรกฺษฺยนฺติ กินฺตุ ยูยํ ทฺรกฺษฺยถ;อหํ ชีวิษฺยามิ ตสฺมาตฺ การณาทฺ ยูยมปิ ชีวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ปิตรฺยฺยหมสฺมิ มยิ จ ยูยํ สฺถ, ตถาหํ ยุษฺมาสฺวสฺมิ ตทปิ ตทา ชฺญาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","โย ชโน มมาชฺญา คฺฤหีตฺวา ตา อาจรติ เสอว มยิ ปฺรียเต; โย ชนศฺจ มยิ ปฺรียเต เสอว มม ปิตุ: ปฺริยปาตฺรํ ภวิษฺยติ, ตถาหมปิ ตสฺมินฺ ปฺรีตฺวา ตไสฺม สฺวํ ปฺรกาศยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ตทา อีษฺกริโยตียาทฺ อโนฺย ยิหูทาสฺตมวทตฺ, เห ปฺรโภ ภวานฺ ชคโต โลกานำ สนฺนิเธา ปฺรกาศิโต น ภูตฺวาสฺมากํ สนฺนิเธา กุต: ปฺรกาศิโต ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ตโต ยีศุ: ปฺรตฺยุทิตวานฺ, โย ชโน มยิ ปฺรียเต ส มมาชฺญา อปิ คฺฤหฺลาติ, เตน มม ปิตาปิ ตสฺมินฺ เปฺรษฺยเต, อาวาญฺจ ตนฺนิกฏมาคตฺย เตน สห นิวตฺสฺยาว:ฯ ");
INSERT INTO santha_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","โย ชโน มยิ น ปฺรียเต ส มม กถา อปิ น คฺฤหฺลาติ ปุนศฺจ ยามิมำ กถำ ยูยํ ศฺฤณุถ สา กถา เกวลสฺย มม น กินฺตุ มม เปฺรรโก ย: ปิตา ตสฺยาปิ กถาฯ ");
INSERT INTO santha_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","อิทานีํ ยุษฺมากํ นิกเฏ วิทฺยมาโนหมฺ เอตา: สกลา: กถา: กถยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","กินฺตฺวิต: ปรํ ปิตฺรา ย: สหาโย'รฺถาตฺ ปวิตฺร อาตฺมา มม นามฺนิ เปฺรรยิษฺยติ ส สรฺวฺวํ ศิกฺษยิตฺวา มโยกฺตา: สมสฺตา: กถา ยุษฺมานฺ สฺมารยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","อหํ ยุษฺมากํ นิกเฏ ศานฺตึ สฺถาปยิตฺวา ยามิ, นิชำ ศานฺตึ ยุษฺมภฺยํ ททามิ, ชคโต โลกา ยถา ททาติ ตถาหํ น ททามิ; ยุษฺมากมฺ อนฺต:กรณานิ ทุ:ขิตานิ ภีตานิ จ น ภวนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","อหํ คตฺวา ปุนรปิ ยุษฺมากํ สมีปมฺ อาคมิษฺยามิ มโยกฺตํ วากฺยมิทํ ยูยมฺ อเศฺราษฺฏ; ยทิ มยฺยเปฺรษฺยธฺวํ ตรฺหฺยหํ ปิตุ: สมีปํ คจฺฉามิ มมาสฺยำ กถายำ ยูยมฺ อหฺลาทิษฺยธฺวํ ยโต มม ปิตา มตฺโตปิ มหานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ตสฺยา ฆฏนายา: สมเย ยถา ยุษฺมากํ ศฺรทฺธา ชายเต ตทรฺถมฺ อหํ ตสฺยา ฆฏนายา: ปูรฺวฺวมฺ อิทานีํ ยุษฺมานฺ เอตำ วารฺตฺตำ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","อิต: ปรํ ยุษฺมาภิ: สห มม พหว อาลาปา น ภวิษฺยนฺติ ยต: การณาทฺ เอตสฺย ชคต: ปติราคจฺฉติ กินฺตุ มยา สห ตสฺย โกปิ สมฺพนฺโธ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","อหํ ปิตริ เปฺรม กโรมิ ตถา ปิตุ รฺวิธิวตฺ กรฺมฺมาณิ กโรมีติ เยน ชคโต โลกา ชานนฺติ ตทรฺถมฺ อุตฺติษฺฐต วยํ สฺถานาทสฺมาทฺ คจฺฉามฯ ");
INSERT INTO santha_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","อหํ สตฺยทฺรากฺษาลตาสฺวรูโป มม ปิตา ตูทฺยานปริจารกสฺวรูปญฺจฯ ");
INSERT INTO santha_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","มม ยาสุ ศาขาสุ ผลานิ น ภวนฺติ ตา: ส ฉินตฺติ ตถา ผลวตฺย: ศาขา ยถาธิกผลานิ ผลนฺติ ตทรฺถํ ตา: ปริษฺกโรติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","อิทานีํ มโยกฺโตปเทเศน ยูยํ ปริษฺกฺฤตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","อต: การณาตฺ มยิ ติษฺฐต เตนาหมปิ ยุษฺมาสุ ติษฺฐามิ, ยโต เหโต รฺทฺรากฺษาลตายามฺ อสํลคฺนา ศาขา ยถา ผลวตี ภวิตุํ น ศกฺโนติ ตถา ยูยมปิ มยฺยติษฺฐนฺต: ผลวนฺโต ภวิตุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","อหํ ทฺรากฺษาลตาสฺวรูโป ยูยญฺจ ศาขาสฺวรูโป:; โย ชโน มยิ ติษฺฐติ ยตฺร จาหํ ติษฺฐามิ, ส ปฺรจูรผไล: ผลวานฺ ภวติ, กินฺตุ มำ วินา ยูยํ กิมปิ กรฺตฺตุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ย: กศฺจินฺ มยิ น ติษฺฐติ ส ศุษฺกศาเขว พหิ รฺนิกฺษิปฺยเต โลกาศฺจ ตา อาหฺฤตฺย วเหฺนา นิกฺษิปฺย ทาหยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ยทิ ยูยํ มยิ ติษฺฐถ มม กถา จ ยุษฺมาสุ ติษฺฐติ ตรฺหิ ยทฺ วาญฺฉิตฺวา ยาจิษฺยเธฺว ยุษฺมากํ ตเทว สผลํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ยทิ ยูยํ ปฺรจูรผลวนฺโต ภวถ ตรฺหิ ตทฺวารา มม ปิตุ รฺมหิมา ปฺรกาศิษฺยเต ตถา ยูยํ มม ศิษฺยา อิติ ปริกฺษายิษฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ปิตา ยถา มยิ ปฺรีตวานฺ อหมปิ ยุษฺมาสุ ตถา ปฺรีตวานฺ อโต เหโต รฺยูยํ นิรนฺตรํ มม เปฺรมปาตฺราณิ ภูตฺวา ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","อหํ ยถา ปิตุราชฺญา คฺฤหีตฺวา ตสฺย เปฺรมภาชนํ ติษฺฐามิ ตไถว ยูยมปิ ยทิ มมาชฺญา คุหฺลีถ ตรฺหิ มม เปฺรมภาชนานิ สฺถาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ยุษฺมนฺนิมิตฺตํ มม ย อาหฺลาท: ส ยถา จิรํ ติษฺฐติ ยุษฺมากมฺ อานนฺทศฺจ ยถา ปูรฺยฺยเต ตทรฺถํ ยุษฺมภฺยมฺ เอตา: กถา อตฺรกถมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","อหํ ยุษฺมาสุ ยถา ปฺรีเย ยูยมปิ ปรสฺปรํ ตถา ปฺรียธฺวมฺ เอษา มมาชฺญาฯ ");
INSERT INTO santha_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","มิตฺราณำ การณาตฺ สฺวปฺราณทานปรฺยฺยนฺตํ ยตฺ เปฺรม ตสฺมานฺ มหาเปฺรม กสฺยาปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","อหํ ยทฺยทฺ อาทิศามิ ตตฺตเทว ยทิ ยูยมฺ อาจรต ตรฺหิ ยูยเมว มม มิตฺราณิฯ ");
INSERT INTO santha_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","อทฺยารภฺย ยุษฺมานฺ ทาสานฺ น วทิษฺยามิ ยตฺ ปฺรภุ รฺยตฺ กโรติ ทาสสฺตทฺ น ชานาติ; กินฺตุ ปิตุ: สมีเป ยทฺยทฺ อศฺฤณวํ ตตฺ สรฺวฺวํ ยูษฺมานฺ อชฺญาปยมฺ ตตฺการณาทฺ ยุษฺมานฺ มิตฺราณิ โปฺรกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ยูยํ มำ โรจิตวนฺต อิติ น, กินฺตฺวหเมว ยุษฺมานฺ โรจิตวานฺ ยูยํ คตฺวา ยถา ผลานฺยุตฺปาทยถ ตานิ ผลานิ จากฺษยาณิ ภวนฺติ, ตทรฺถํ ยุษฺมานฺ นฺยชุนชํ ตสฺมานฺ มม นาม โปฺรจฺย ปิตรํ ยตฺ กิญฺจิทฺ ยาจิษฺยเธฺว ตเทว ส ยุษฺมภฺยํ ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ยูยํ ปรสฺปรํ ปฺรียธฺวมฺ อหมฺ อิตฺยาชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ชคโต โลไก รฺยุษฺมาสุ ฤตียิเตษุ เต ปูรฺวฺวํ มาเมวารฺตฺตียนฺต อิติ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ยทิ ยูยํ ชคโต โลกา อภวิษฺยต ตรฺหิ ชคโต โลกา ยุษฺมานฺ อาตฺมียานฺ พุทฺธฺวาเปฺรษฺยนฺต; กินฺตุ ยูยํ ชคโต โลกา น ภวถ, อหํ ยุษฺมานฺ อสฺมาชฺชคโต'โรจยมฺ เอตสฺมาตฺ การณาชฺชคโต โลกา ยุษฺมานฺ ฤตียนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ทาส: ปฺรโภ รฺมหานฺ น ภวติ มไมตตฺ ปูรฺวฺวียํ วากฺยํ สฺมรต; เต ยทิ มาเมวาตาฑยนฺ ตรฺหิ ยุษฺมานปิ ตาฑยิษฺยนฺติ, ยทิ มม วากฺยํ คฺฤหฺลนฺติ ตรฺหิ ยุษฺมากมปิ วากฺยํ คฺรหีษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","กินฺตุ เต มม นามการณาทฺ ยุษฺมานฺ ปฺรติ ตาทฺฤศํ วฺยวหริษฺยนฺติ ยโต โย มำ เปฺรริตวานฺ ตํ เต น ชานนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","เตษำ สนฺนิธิมฺ อาคตฺย ยทฺยหํ นากถยิษฺยํ ตรฺหิ เตษำ ปาปํ นาภวิษฺยตฺ กินฺตฺวธุนา เตษำ ปาปมาจฺฉาทยิตุมฺ อุปาโย นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","โย ชโน มามฺ ฤตียเต ส มม ปิตรมปิ ฤตียเตฯ ");
INSERT INTO santha_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ยาทฺฤศานิ กรฺมฺมาณิ เกนาปิ กทาปิ นากฺริยนฺต ตาทฺฤศานิ กรฺมฺมาณิ ยทิ เตษำ สากฺษาทฺ อหํ นากริษฺยํ ตรฺหิ เตษำ ปาปํ นาภวิษฺยตฺ กินฺตฺวธุนา เต ทฺฤษฺฏฺวาปิ มำ มม ปิตรญฺจารฺตฺตียนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ตสฺมาตฺ เต'การณํ มามฺ ฤตียนฺเต ยเทตทฺ วจนํ เตษำ ศาสฺเตฺร ลิขิตมาเสฺต ตตฺ สผลมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","กินฺตุ ปิตุ รฺนิรฺคตํ ยํ สหายมรฺถาตฺ สตฺยมยมฺ อาตฺมานํ ปิตุ: สมีปาทฺ ยุษฺมากํ สมีเป เปฺรษยิษฺยามิ ส อาคตฺย มยิ ปฺรมาณํ ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ยูยํ ปฺรถมมารภฺย มยา สารฺทฺธํ ติษฺฐถ ตสฺมาทฺเธโต รฺยูยมปิ ปฺรมาณํ ทาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ยุษฺมากํ ยถา วาธา น ชายเต ตทรฺถํ ยุษฺมานฺ เอตานิ สรฺวฺววากฺยานิ วฺยาหรํฯ ");
INSERT INTO santha_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","โลกา ยุษฺมานฺ ภชนคฺฤเหโภฺย ทูรีกริษฺยนฺติ ตถา ยสฺมินฺ สมเย ยุษฺมานฺ หตฺวา อีศฺวรสฺย ตุษฺฏิ ชนกํ กรฺมฺมากุรฺมฺม อิติ มํสฺยนฺเต ส สมย อาคจฺฉนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","เต ปิตรํ มาญฺจ น ชานนฺติ, ตสฺมาทฺ ยุษฺมานฺ ปฺรตีทฺฤศมฺ อาจริษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","อโต เหตา: สมเย สมุปสฺถิเต ยถา มม กถา ยุษฺมากํ มน:สุ: สมุปติษฺฐติ ตทรฺถํ ยุษฺมาภฺยมฺ เอตำ กถำ กถยามิ ยุษฺมาภิ: สารฺทฺธมฺ อหํ ติษฺฐนฺ ปฺรถมํ ตำ ยุษฺมภฺยํ นากถยํฯ ");
INSERT INTO santha_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","สามฺปฺรตํ สฺวสฺย เปฺรรยิตุ: สมีปํ คจฺฉามิ ตถาปิ ตฺวํ กฺก คจฺฉสิ กถาเมตำ ยุษฺมากํ โกปิ มำ น ปฺฤจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","กินฺตุ มโยกฺตาภิราภิ: กถาภิ รฺยูษฺมากมฺ อนฺต:กรณานิ ทุ:เขน ปูรฺณานฺยภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ตถาปฺยหํ ยถารฺถํ กถยามิ มม คมนํ ยุษฺมากํ หิตารฺถเมว, ยโต เหโต รฺคมเน น กฺฤเต สหาโย ยุษฺมากํ สมีปํ นาคมิษฺยติ กินฺตุ ยทิ คจฺฉามิ ตรฺหิ ยุษฺมากํ สมีเป ตํ เปฺรษยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ตต: ส อาคตฺย ปาปปุณฺยทณฺเฑษุ ชคโต โลกานำ ปฺรโพธํ ชนยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","เต มยิ น วิศฺวสนฺติ ตสฺมาทฺเธโต: ปาปปฺรโพธํ ชนยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ยุษฺมากมฺ อทฺฤศฺย: สนฺนหํ ปิตุ: สมีปํ คจฺฉามิ ตสฺมาทฺ ปุเณฺย ปฺรโพธํ ชนยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","เอตชฺชคโต'ธิปติ รฺทณฺฑาชฺญำ ปฺราปฺโนติ ตสฺมาทฺ ทณฺเฑ ปฺรโพธํ ชนยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ยุษฺมภฺยํ กถยิตุํ มมาเนกา: กถา อาสเต, ตา: กถา อิทานีํ ยูยํ โสฒุํ น ศกฺนุถ; ");
INSERT INTO santha_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","กินฺตุ สตฺยมย อาตฺมา ยทา สมาคมิษฺยติ ตทา สรฺวฺวํ สตฺยํ ยุษฺมานฺ เนษฺยติ, ส สฺวต: กิมปิ น วทิษฺยติ กินฺตุ ยจฺโฉฺรษฺยติ ตเทว กถยิตฺวา ภาวิการฺยฺยํ ยุษฺมานฺ ชฺญาปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","มม มหิมานํ ปฺรกาศยิษฺยติ ยโต มทียำ กถำ คฺฤหีตฺวา ยุษฺมานฺ โพธยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ปิตุ รฺยทฺยทฺ อาเสฺต ตตฺ สรฺวฺวํ มม ตสฺมาทฺ การณาทฺ อวาทิษํ ส มทียำ กถำ คฺฤหีตฺวา ยุษฺมานฺ โพธยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","กิยตฺกาลาตฺ ปรํ ยูยํ มำ ทฺรษฺฏุํ น ลปฺสฺยเธฺว กินฺตุ กิยตฺกาลาตฺ ปรํ ปุน รฺทฺรษฺฏุํ ลปฺสฺยเธฺว ยโตหํ ปิตุ: สมีปํ คจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ตต: ศิษฺยาณำ กิยนฺโต ชนา: ปรสฺปรํ วทิตุมฺ อารภนฺต, กิยตฺกาลาตฺ ปรํ มำ ทฺรษฺฏุํ น ลปฺสฺยเธฺว กินฺตุ กิยตฺกาลาตฺ ปรํ ปุน รฺทฺรษฺฏุํ ลปฺสฺยเธฺว ยโตหํ ปิตุ: สมีปํ คจฺฉามิ, อิติ ยทฺ วากฺยมฺ อยํ วทติ ตตฺ กึ? ");
INSERT INTO santha_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ตต: กิยตฺกาลาตฺ ปรมฺ อิติ ตสฺย วากฺยํ กึ? ตสฺย วากฺยสฺยาภิปฺรายํ วยํ โพทฺธุํ น ศกฺนุมไสฺตริติ ");
INSERT INTO santha_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","นิคทิเต ยีศุเสฺตษำ ปฺรศฺเนจฺฉำ ชฺญาตฺวา เตโภฺย'กถยตฺ กิยตฺกาลาตฺ ปรํ มำ ทฺรษฺฏุํ น ลปฺสฺยเธฺว, กินฺตุ กิยตฺกาลาตฺ ปรํ ปูน รฺทฺรษฺฏุํ ลปฺสฺยเธฺว, ยามิมำ กถามกถยํ ตสฺยา อภิปฺรายํ กึ ยูยํ ปรสฺปรํ มฺฤคยเธฺว? ");
INSERT INTO santha_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ยุษฺมานหมฺ อติยถารฺถํ วทามิ ยูยํ กฺรนฺทิษฺยถ วิลปิษฺยถ จ, กินฺตุ ชคโต โลกา อานนฺทิษฺยนฺติ; ยูยํ โศกากุลา ภวิษฺยถ กินฺตุ โศกาตฺ ปรํ อานนฺทยุกฺตา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ปฺรสวกาล อุปสฺถิเต นารี ยถา ปฺรสวเวทนยา วฺยากุลา ภวติ กินฺตุ ปุเตฺร ภูมิษฺเฐ สติ มนุไษฺยโก ชนฺมนา นรโลเก ปฺรวิษฺฏ อิตฺยานนฺทาตฺ ตสฺยาสฺตตฺสรฺวฺวํ ทุ:ขํ มนสิ น ติษฺฐติ, ");
INSERT INTO santha_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ตถา ยูยมปิ สามฺปฺรตํ โศกากุลา ภวถ กินฺตุ ปุนรปิ ยุษฺมภฺยํ ทรฺศนํ ทาสฺยามิ เตน ยุษฺมากมฺ อนฺต:กรณานิ สานนฺทานิ ภวิษฺยนฺติ, ยุษฺมากํ ตมฺ อานนฺทญฺจ โกปิ หรฺตฺตุํ น ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ตสฺมินฺ ทิวเส กามปิ กถำ มำ น ปฺรกฺษฺยถฯ ยุษฺมานหมฺ อติยถารฺถํ วทามิ, มม นามฺนา ยตฺ กิญฺจิทฺ ปิตรํ ยาจิษฺยเธฺว ตเทว ส ทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ปูรฺเวฺว มม นามฺนา กิมปิ นายาจธฺวํ, ยาจธฺวํ ตต: ปฺราปฺสฺยถ ตสฺมาทฺ ยุษฺมากํ สมฺปูรฺณานนฺโท ชนิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","อุปมากถาภิ: สรฺวฺวาเณฺยตานิ ยุษฺมานฺ ชฺญาปิตวานฺ กินฺตุ ยสฺมินฺ สมเย อุปมยา โนกฺตฺวา ปิตุ: กถำ สฺปษฺฏํ ชฺญาปยิษฺยามิ สมย เอตาทฺฤศ อาคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ตทา มม นามฺนา ปฺรารฺถยิษฺยเธฺว 'หํ ยุษฺมนฺนิมิตฺตํ ปิตรํ วิเนเษฺย กถามิมำ น วทามิ; ");
INSERT INTO santha_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ยโต ยูยํ มยิ เปฺรม กุรุถ, ตถาหมฺ อีศฺวรสฺย สมีปาทฺ อาคตวานฺ อิตฺยปิ ปฺรตีถ, ตสฺมาทฺ การณาตฺ การณาตฺ ปิตา สฺวยํ ยุษฺมาสุ ปฺรียเตฯ ");
INSERT INTO santha_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ปิตุ: สมีปาชฺชชทฺ อาคโตสฺมิ ชคตฺ ปริตฺยชฺย จ ปุนรปิ ปิตุ: สมีปํ คจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ตทา ศิษฺยา อวทนฺ, เห ปฺรโภ ภวานฺ อุปมยา โนกฺตฺวาธุนา สฺปษฺฏํ วทติฯ ");
INSERT INTO santha_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ภวานฺ สรฺวฺวชฺญ: เกนจิตฺ ปฺฤษฺโฏ ภวิตุมปิ ภวต: ปฺรโยชนํ นาสฺตีตฺยธุนาสฺมากํ สฺถิรชฺญานํ ชาตํ ตสฺมาทฺ ภวานฺ อีศฺวรสฺย สมีปาทฺ อาคตวานฺ อิตฺยตฺร วยํ วิศฺวสิม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ตโต ยีศุ: ปฺรตฺยวาทีทฺ อิทานีํ กึ ยูยํ วิศฺวสิถ? ");
INSERT INTO santha_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ปศฺยต สรฺเวฺว ยูยํ วิกีรฺณา: สนฺโต มามฺ เอกากินํ ปีรตฺยชฺย สฺวํ สฺวํ สฺถานํ คมิษฺยถ, เอตาทฺฤศ: สมย อาคจฺฉติ วรํ ปฺราเยโณปสฺถิตวานฺ; ตถาปฺยหํ ไนกากี ภวามิ ยต: ปิตา มยา สารฺทฺธมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ยถา มยา ยุษฺมากํ ศานฺติ รฺชายเต ตทรฺถมฺ เอตา: กถา ยุษฺมภฺยมฺ อจกถํ; อสฺมินฺ ชคติ ยุษฺมากํ เกฺลโศ ฆฏิษฺยเต กินฺตฺวกฺโษภา ภวต ยโต มยา ชคชฺชิตํฯ ");
INSERT INTO santha_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ตต: ปรํ ยีศุเรตา: กถา: กถยิตฺวา สฺวรฺคํ วิโลไกฺยตตฺ ปฺรารฺถยตฺ, เห ปิต: สมย อุปสฺถิตวานฺ; ยถา ตว ปุตฺรสฺตว มหิมานํ ปฺรกาศยติ ตทรฺถํ ตฺวํ นิชปุตฺรสฺย มหิมานํ ปฺรกาศยฯ ");
INSERT INTO santha_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ตฺวํ โยโลฺลกานฺ ตสฺย หเสฺต สมรฺปิตวานฺ ส ยถา เตโภฺย'นนฺตายุ รฺททาติ ตทรฺถํ ตฺวํ ปฺราณิมาตฺราณามฺ อธิปติตฺวภารํ ตไสฺม ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ยสฺตฺวมฺ อทฺวิตีย: สตฺย อีศฺวรสฺตฺวยา เปฺรริตศฺจ ยีศุ: ขฺรีษฺฏ เอตโยรุภโย: ปริจเย ปฺราปฺเต'นนฺตายุ รฺภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ตฺวํ ยสฺย กรฺมฺมโณ ภารํ มหฺยํ ทตฺตวานฺ, ตตฺ สมฺปนฺนํ กฺฤตฺวา ชคตฺยสฺมินฺ ตว มหิมานํ ปฺรากาศยํฯ ");
INSERT INTO santha_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","อเตอว เห ปิต รฺชคตฺยวิทฺยมาเน ตฺวยา สห ติษฺฐโต มม โย มหิมาสีตฺ สมฺปฺรติ ตว สมีเป มำ ตํ มหิมานํ ปฺราปยฯ ");
INSERT INTO santha_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","อนฺยจฺจ ตฺวมฺ เอตชฺชคโต ยาโลฺลกานฺ มหฺยมฺ อททา อหํ เตภฺยสฺตว นามฺนสฺตตฺตฺวชฺญานมฺ อททำ, เต ตไววาสนฺ, ตฺวํ ตานฺ มหฺยมททา:, ตสฺมาตฺเต ตโวปเทศมฺ อคฺฤหฺลนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ตฺวํ มหฺยํ ยตฺ กิญฺจิทฺ อททาสฺตตฺสรฺวฺวํ ตฺวตฺโต ชายเต อิตฺยธุนาชานนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","มหฺยํ ยมุปเทศมฺ อททา อหมปิ เตภฺยสฺตมุปเทศมฺ อททำ เตปิ ตมคฺฤหฺลนฺ ตฺวตฺโตหํ นิรฺคตฺย ตฺวยา เปฺรริโตภวมฺ อตฺร จ วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","เตษาเมว นิมิตฺตํ ปฺรารฺถเย'หํ ชคโต โลกนิมิตฺตํ น ปฺรารฺถเย กินฺตุ ยาโลฺลกานฺ มหฺยมฺ อททาเสฺตษาเมว นิมิตฺตํ ปฺรารฺถเย'หํ ยตเสฺต ตไววาสเตฯ ");
INSERT INTO santha_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","เย มม เต ตว เย จ ตว เต มม ตถา ไต รฺมม มหิมา ปฺรกาศฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","สามฺปฺรตมฺ อสฺมินฺ ชคติ มมาวสฺถิเต: เศษมฺ อภวตฺ อหํ ตว สมีปํ คจฺฉามิ กินฺตุ เต ชคติ สฺถาสฺยนฺติ; เห ปวิตฺร ปิตราวโย รฺยไถกตฺวมาเสฺต ตถา เตษามเปฺยกตฺวํ ภวติ ตทรฺถํ ยาโลฺลกานฺ มหฺยมฺ อททาสฺตานฺ สฺวนามฺนา รกฺษฯ ");
INSERT INTO santha_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ยาวนฺติ ทินานิ ชคตฺยสฺมินฺ ไต: สหาหมาสํ ตาวนฺติ ทินานิ ตานฺ ตว นามฺนาหํ รกฺษิตวานฺ; ยาโลฺลกานฺ มหฺยมฺ อททาสฺตานฺ สรฺวฺวานฺ อหมรกฺษํ, เตษำ มเธฺย เกวลํ วินาศปาตฺรํ หาริตํ เตน ธรฺมฺมปุสฺตกสฺย วจนํ ปฺรตฺยกฺษํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","กินฺตฺวธุนา ตว สนฺนิธึ คจฺฉามิ มยา ยถา เตษำ สมฺปูรฺณานนฺโท ภวติ ตทรฺถมหํ ชคติ ติษฺฐนฺ เอตา: กถา อกถยมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ตโวปเทศํ เตโภฺย'ททำ ชคตา สห ยถา มม สมฺพนฺโธ นาสฺติ ตถา ชชตา สห เตษามปิ สมฺพนฺธาภาวาชฺ ชคโต โลกาสฺตานฺ ฤตียนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ตฺวํ ชคตสฺตานฺ คฺฤหาเณติ น ปฺรารฺถเย กินฺตฺวศุภาทฺ รกฺเษติ ปฺรารฺถเยหมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","อหํ ยถา ชคตฺสมฺพนฺธีโย น ภวามิ ตถา เตปิ ชคตฺสมฺพนฺธียา น ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ตว สตฺยกถยา ตานฺ ปวิตฺรีกุรุ ตว วากฺยเมว สตฺยํฯ ");
INSERT INTO santha_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ตฺวํ ยถา มำ ชคติ ไปฺรรยสฺตถาหมปิ ตานฺ ชคติ ไปฺรรยํฯ ");
INSERT INTO santha_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","เตษำ หิตารฺถํ ยถาหํ สฺวํ ปวิตฺรีกโรมิ ตถา สตฺยกถยา เตปิ ปวิตฺรีภวนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","เกวลํ เอเตษามรฺเถ ปฺรารฺถเย'หมฺ อิติ น กินฺเตฺวเตษามุปเทเศน เย ชนา มยิ วิศฺวสิษฺยนฺติ เตษามปฺยรฺเถ ปฺรารฺเถเย'หมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","เห ปิตเสฺตษำ สรฺเวฺวษามฺ เอกตฺวํ ภวตุ ตว ยถา มยิ มม จ ยถา ตฺวเยฺยกตฺวํ ตถา เตษามปฺยาวโยเรกตฺวํ ภวตุ เตน ตฺวํ มำ เปฺรริตวานฺ อิติ ชคโต โลกา: ปฺรติยนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ยถาวโยเรกตฺวํ ตถา เตษามเปฺยกตฺวํ ภวตุ เตษฺวหํ มยิ จ ตฺวมฺ อิตฺถํ เตษำ สมฺปูรฺณเมกตฺวํ ภวตุ, ตฺวํ เปฺรริตวานฺ ตฺวํ มยิ ยถา ปฺรียเส จ ตถา เตษฺวปิ ปฺรีตวานฺ เอตทฺยถา ชคโต โลกา ชานนฺติ ");
INSERT INTO santha_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ตทรฺถํ ตฺวํ ยํ มหิมานํ มหฺยมฺ อททาสฺตํ มหิมานมฺ อหมปิ เตโภฺย ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","เห ปิต รฺชคโต นิรฺมฺมาณาตฺ ปูรฺวฺวํ มยิ เสฺนหํ กฺฤตฺวา ยํ มหิมานํ ทตฺตวานฺ มม ตํ มหิมานํ ยถา เต ปศฺยนฺติ ตทรฺถํ ยาโลฺลกานฺ มหฺยํ ทตฺตวานฺ อหํ ยตฺร ติษฺฐามิ เตปิ ยถา ตตฺร ติษฺฐนฺติ มไมษา วาญฺฉาฯ ");
INSERT INTO santha_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","เห ยถารฺถิก ปิต รฺชคโต โลไกสฺตฺวยฺยชฺญาเตปิ ตฺวามหํ ชาเน ตฺวํ มำ เปฺรริตวานฺ อิตีเม ศิษฺยา ชานนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ยถาหํ เตษุ ติษฺฐามิ ตถา มยิ เยน เปฺรมฺนา เปฺรมากโรสฺตตฺ เตษุ ติษฺฐติ ตทรฺถํ ตว นามาหํ ตานฺ ชฺญาปิตวานฺ ปุนรปิ ชฺญาปยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ตา: กถา: กถยิตฺวา ยีศุ: ศิษฺยานาทาย กิโทฺรนฺนามกํ โสฺรต อุตฺตีรฺยฺย ศิไษฺย: สห ตตฺรโตฺยทฺยานํ ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","กินฺตุ วิศฺวาสฆาติยิหูทาสฺตตฺ สฺถานํ ปริจียเต ยโต ยีศุ: ศิไษฺย: สารฺทฺธํ กทาจิตฺ ตตฺ สฺถานมฺ อคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ตทา ส ยิหูทา: ไสนฺยคณํ ปฺรธานยาชกานำ ผิรูศินาญฺจ ปทาติคณญฺจ คฺฤหีตฺวา ปฺรทีปานฺ อุลฺกานฺ อสฺตฺราณิ จาทาย ตสฺมินฺ สฺถาน อุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","สฺวํ ปฺรติ ยทฺ ฆฏิษฺยเต ตชฺ ชฺญาตฺวา ยีศุรเคฺรสร: สนฺ ตานปฺฤจฺฉตฺ กํ คเวษยถ? ");
INSERT INTO santha_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","เต ปฺรตฺยวทนฺ, นาสรตียํ ยีศุํ; ตโต ยีศุรวาทีทฺ อหเมว ส:; ไต: สห วิศฺวาสฆาตี ยิหูทาศฺจาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ตทาหเมว ส ตไสฺยตำ กถำ ศฺรุไตฺวว เต ปศฺจาเทตฺย ภูเมา ปติตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ตโต ยีศุ: ปุนรปิ ปฺฤษฺฐวานฺ กํ คเวษยถ? ตตเสฺต ปฺรตฺยวทนฺ นาสรตียํ ยีศุํฯ ");
INSERT INTO santha_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ตทา ยีศุ: ปฺรตฺยุทิตวานฺ อหเมว ส อิมำ กถามจกถมฺ; ยทิ มามนฺวิจฺฉถ ตรฺหีมานฺ คนฺตุํ มา วารยตฯ ");
INSERT INTO santha_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","อิตฺถํ ภูเต มหฺยํ ยาโลฺลกานฺ อททาเสฺตษามฺ เอกมปิ นาหารยมฺ อิมำ ยำ กถำ ส สฺวยมกถยตฺ สา กถา สผลา ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ตทา ศิโมนฺปิตรสฺย นิกเฏ ขงฺคลฺสฺถิเต: ส ตํ นิษฺโกษํ กฺฤตฺวา มหายาชกสฺย มาลฺขนามานํ ทาสมฺ อาหตฺย ตสฺย ทกฺษิณกรฺณํ ฉินฺนวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ตโต ยีศุ: ปิตรมฺ อวทตฺ, ขงฺคํ โกเษ สฺถาปย มม ปิตา มหฺยํ ปาตุํ ยํ กํสมฺ อททาตฺ เตนาหํ กึ น ปาสฺยามิ? ");
INSERT INTO santha_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ตทา ไสนฺยคณ: เสนาปติ รฺยิหูทียานำ ปทาตยศฺจ ยีศุํ ฆฺฤตฺวา พทฺธฺวา หานนฺนามฺน: กิยผา: ศฺวศุรสฺย สมีปํ ปฺรถมมฺ อนยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ส กิยผาสฺตสฺมินฺ วตฺสเร มหายาชตฺวปเท นิยุกฺต: ");
INSERT INTO santha_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","สนฺ สาธารณโลกานำ มงฺคลารฺถมฺ เอกชนสฺย มรณมุจิตมฺ อิติ ยิหูทีไย: สารฺทฺธมฺ อมนฺตฺรยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ตทา ศิโมนฺปิตโร'ไนฺยกศิษฺยศฺจ ยีโศ: ปศฺจาทฺ อคจฺฉตำ ตสฺยานฺยศิษฺยสฺย มหายาชเกน ปริจิตตฺวาตฺ ส ยีศุนา สห มหายาชกสฺยาฏฺฏาลิกำ ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","กินฺตุ ปิตโร พหิรฺทฺวารสฺย สมีเป'ติษฺฐทฺ อเตอว มหายาชเกน ปริจิต: ส ศิษฺย: ปุนรฺพหิรฺคตฺวา เทาวายิกาไย กถยิตฺวา ปิตรมฺ อภฺยนฺตรมฺ อานยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ตทา ส ทฺวารรกฺษิกา ปิตรมฺ อวทตฺ ตฺวํ กึ น ตสฺย มานวสฺย ศิษฺย:? ตต: โสวททฺ อหํ น ภวามิฯ ");
INSERT INTO santha_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ตต: ปรํ ยตฺสฺถาเน ทาสา: ปทาตยศฺจ ศีตเหโตรงฺคาไร รฺวหฺนึ ปฺรชฺวาลฺย ตาปํ เสวิตวนฺตสฺตตฺสฺถาเน ปิตรสฺติษฺฐนฺ ไต: สห วหฺนิตาปํ เสวิตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ตทา ศิเษฺยษูปเทเศ จ มหายาชเกน ยีศุ: ปฺฤษฺฏ: ");
INSERT INTO santha_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","สนฺ ปฺรตฺยุกฺตวานฺ สรฺวฺวโลกานำ สมกฺษํ กถามกถยํ คุปฺตํ กามปิ กถำ น กถยิตฺวา ยตฺ สฺถานํ ยิหูทียา: สตตํ คจฺฉนฺติ ตตฺร ภชนเคเห มนฺทิเร จาศิกฺษยํฯ ");
INSERT INTO santha_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","มตฺต: กุต: ปฺฤจฺฉสิ? เย ชนา มทุปเทศมฺ อศฺฤณฺวนฺ ตาเนว ปฺฤจฺฉ ยทฺยทฺ อวทํ เต ตตฺ ชานินฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ตเทตฺถํ ปฺรตฺยุทิตตฺวาตฺ นิกฏสฺถปทาติ รฺยีศุํ จเปเฏนาหตฺย วฺยาหรตฺ มหายาชกมฺ เอวํ ปฺรติวทสิ? ");
INSERT INTO santha_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ตโต ยีศุ: ปฺรติคทิตวานฺ ยทฺยยถารฺถมฺ อจกถํ ตรฺหิ ตสฺยายถารฺถสฺย ปฺรมาณํ เทหิ, กินฺตุ ยทิ ยถารฺถํ ตรฺหิ กุโต เหโต รฺมามฺ อตาฑย:? ");
INSERT INTO santha_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ปูรฺวฺวํ หานนฺ สพนฺธนํ ตํ กิยผามหายาชกสฺย สมีปํ ไปฺรษยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ศิโมนฺปิตรสฺติษฺฐนฺ วหฺนิตาปํ เสวเต, เอตสฺมินฺ สมเย กิยนฺตสฺตมฺ อปฺฤจฺฉนฺ ตฺวํ กิมฺ เอตสฺย ชนสฺย ศิโษฺย น? ตต: โสปหฺนุตฺยาพฺรวีทฺ อหํ น ภวามิฯ ");
INSERT INTO santha_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ตทา มหายาชกสฺย ยสฺย ทาสสฺย ปิตร: กรฺณมจฺฉินตฺ ตสฺย กุฏุมฺพ: ปฺรตฺยุทิตวานฺ อุทฺยาเน เตน สห ติษฺฐนฺตํ ตฺวำ กึ นาปศฺยํ? ");
INSERT INTO santha_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","กินฺตุ ปิตร: ปุนรปหฺนุตฺย กถิตวานฺ; ตทานีํ กุกฺกุโฏ'เราตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ตทนนฺตรํ ปฺรตฺยูเษ เต กิยผาคฺฤหาทฺ อธิปเต รฺคฺฤหํ ยีศุมฺ อนยนฺ กินฺตุ ยสฺมินฺ อศุจิเตฺว ชาเต ไต รฺนิสฺตาโรตฺสเว น โภกฺตวฺยํ, ตสฺย ภยาทฺ ยิหูทียาสฺตทฺคฺฤหํ นาวิศนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","อปรํ ปีลาโต พหิราคตฺย ตานฺ ปฺฤษฺฐวานฺ เอตสฺย มนุษฺยสฺย กํ โทษํ วทถ? ");
INSERT INTO santha_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ตทา เต เปตฺยวทนฺ ทุษฺกรฺมฺมการิณิ น สติ ภวต: สมีเป ไนนํ สมารฺปยิษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ตต: ปีลาโต'วททฺ ยูยเมนํ คฺฤหีตฺวา เสฺวษำ วฺยวสฺถยา วิจารยตฯ ตทา ยิหูทียา: ปฺรตฺยวทนฺ กสฺยาปิ มนุษฺยสฺย ปฺราณทณฺฑํ กรฺตฺตุํ นาสฺมากมฺ อธิกาโร'สฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","เอวํ สติ ยีศุ: สฺวสฺย มฺฤเตฺยา ยำ กถำ กถิตวานฺ สา สผลาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ตทนนฺตรํ ปีลาต: ปุนรปิ ตทฺ ราชคฺฤหํ คตฺวา ยีศุมาหูย ปฺฤษฺฏวานฺ ตฺวํ กึ ยิหูทียานำ ราชา? ");
INSERT INTO santha_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ยีศุ: ปฺรตฺยวทตฺ ตฺวมฺ เอตำ กถำ สฺวต: กถยสิ กิมนฺย: กศฺจินฺ มยิ กถิตวานฺ? ");
INSERT INTO santha_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ปีลาโต'วททฺ อหํ กึ ยิหูทีย:? ตว สฺวเทศียา วิเศษต: ปฺรธานยาชกา มม นิกเฏ ตฺวำ สมารฺปยน, ตฺวํ กึ กฺฤตวานฺ? ");
INSERT INTO santha_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ยีศุ: ปฺรตฺยวทตฺ มม ราชฺยมฺ เอตชฺชคตฺสมฺพนฺธียํ น ภวติ ยทิ มม ราชฺยํ ชคตฺสมฺพนฺธียมฺ อภวิษฺยตฺ ตรฺหิ ยิหูทียานำ หเสฺตษุ ยถา สมรฺปิโต นาภวํ ตทรฺถํ มม เสวกา อโยตฺสฺยนฺ กินฺตุ มม ราชฺยมฺ ไอหิกํ นฯ ");
INSERT INTO santha_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ตทา ปีลาต: กถิตวานฺ, ตรฺหิ ตฺวํ ราชา ภวสิ? ยีศุ: ปฺรตฺยุกฺตวานฺ ตฺวํ สตฺยํ กถยสิ, ราชาหํ ภวามิ; สตฺยตายำ สากฺษฺยํ ทาตุํ ชนึ คฺฤหีตฺวา ชคตฺยสฺมินฺ อวตีรฺณวานฺ, ตสฺมาตฺ สตฺยธรฺมฺมปกฺษปาติโน มม กถำ ศฺฤณฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ตทา สตฺยํ กึ? เอตำ กถำ ปษฺฏฺวา ปีลาต: ปุนรปิ พหิรฺคตฺวา ยิหูทียานฺ อภาษต, อหํ ตสฺย กมปฺยปราธํ น ปฺราปฺโนมิฯ ");
INSERT INTO santha_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","นิสฺตาโรตฺสวสมเย ยุษฺมาภิรภิรุจิต เอโก ชโน มยา โมจยิตวฺย เอษา ยุษฺมากํ รีติรสฺติ, อเตอว ยุษฺมากํ นิกเฏ ยิหูทียานำ ราชานํ กึ โมจยามิ, ยุษฺมากมฺ อิจฺฉา กา? ");
INSERT INTO santha_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ตทา เต สรฺเวฺว รุวนฺโต วฺยาหรนฺ เอนํ มานุษํ นหิ พรพฺพำ โมจยฯ กินฺตุ ส พรพฺพา ทสฺยุราสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ปีลาโต ยีศุมฺ อานีย กศยา ปฺราหารยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ปศฺจาตฺ เสนาคณ: กณฺฏกนิรฺมฺมิตํ มุกุฏํ ตสฺย มสฺตเก สมรฺปฺย วารฺตฺตากีวรฺณํ ราชปริจฺฉทํ ปริธาปฺย, ");
INSERT INTO santha_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","เห ยิหูทียานำ ราชนฺ นมสฺการ อิตฺยุกฺตฺวา ตํ จเปเฏนาหนฺตุมฺ อารภตฯ ");
INSERT INTO santha_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ตทา ปีลาต: ปุนรปิ พหิรฺคตฺวา โลกานฺ อวทตฺ, อสฺย กมปฺยปราธํ น ลเภ'หํ, ปศฺยต ตทฺ ยุษฺมานฺ ชฺญาปยิตุํ ยุษฺมากํ สนฺนิเธา พหิเรนมฺ อานยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ตต: ปรํ ยีศุ: กณฺฏกมุกุฏวานฺ วารฺตฺตากีวรฺณวสนวำศฺจ พหิราคจฺฉตฺฯ ตต: ปีลาต อุกฺตวานฺ เอนํ มนุษฺยํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ตทา ปฺรธานยาชกา: ปทาตยศฺจ ตํ ทฺฤษฺฏฺวา, เอนํ กฺรุเศ วิธ, เอนํ กฺรุเศ วิธ, อิตฺยุกฺตฺวา รวิตุํ อารภนฺตฯ ตต: ปีลาต: กถิตวานฺ ยูยํ สฺวยมฺ เอนํ นีตฺวา กฺรุเศ วิธต, อหมฺ เอตสฺย กมปฺยปราธํ น ปฺราปฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ยิหูทียา: ปฺรตฺยวทนฺ อสฺมากํ ยา วฺยวสฺถาเสฺต ตทนุสาเรณาสฺย ปฺราณหนนมฺ อุจิตํ ยโตยํ สฺวมฺ อีศฺวรสฺย ปุตฺรมวทตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ปีลาต อิมำ กถำ ศฺรุตฺวา มหาตฺราสยุกฺต: ");
INSERT INTO santha_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","สนฺ ปุนรปิ ราชคฺฤห อาคตฺย ยีศุํ ปฺฤษฺฏวานฺ ตฺวํ กุตฺรโตฺย โลก:? กินฺตุ ยีศสฺตสฺย กิมปิ ปฺรตฺยุตฺตรํ นาวทตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","๑॰ ตต: ปีลาตฺ กถิตวาน ตฺวํ กึ มยา สารฺทฺธํ น สํลปิษฺยสิ ? ตฺวำ กฺรุเศ เวธิตุํ วา โมจยิตุํ ศกฺติ รฺมมาเสฺต อิติ กึ ตฺวํ น ชานาสิ ? ตทา ยีศุ: ปฺรตฺยวททฺ อีศฺวเรณาทŸाํ มโมปริ ตว กิมปฺยธิปติตฺวํ น วิทฺยเต, ตถาปิ โย ชโน มำ ตว หเสฺต สมารฺปยตฺ ตสฺย มหาปาตกํ ชาตมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ตทา ยีศุ: ปฺรตฺยวททฺ อีศฺวเรณาทตฺตํ มโมปริ ตว กิมปฺยธิปติตฺวํ น วิทฺยเต, ตถาปิ โย ชโน มำ ตว หเสฺต สมารฺปยตฺ ตสฺย มหาปาตกํ ชาตมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ตทารภฺย ปีลาตสฺตํ โมจยิตุํ เจษฺฏิตวานฺ กินฺตุ ยิหูทียา รุวนฺโต วฺยาหรนฺ ยทีมํ มานวํ ตฺยชสิ ตรฺหิ ตฺวํ ไกสรสฺย มิตฺรํ น ภวสิ, โย ชน: สฺวํ ราชานํ วกฺติ เสอว ไกมรสฺย วิรุทฺธำ กถำ กถยติฯ ");
INSERT INTO santha_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","เอตำ กถำ ศฺรุตฺวา ปีลาโต ยีศุํ พหิรานีย นิสฺตาโรตฺสวสฺย อาสาทนทินสฺย ทฺวิตียปฺรหราตฺ ปูรฺวฺวํ ปฺรสฺตรพนฺธนนามฺนิ สฺถาเน 'รฺถาตฺ อิพฺรียภาษยา ยทฺ คพฺพิถา กถฺยเต ตสฺมินฺ สฺถาเน วิจาราสน อุปาวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","อนนฺตรํ ปีลาโต ยิหูทียานฺ อวทตฺ, ยุษฺมากํ ราชานํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","กินฺตุ เอนํ ทูรีกุรุ, เอนํ ทูรีกุรุ, เอนํ กฺรุเศ วิธ, อิติ กถำ กถยิตฺวา เต รวิตุมฺ อารภนฺต; ตทา ปีลาต: กถิตวานฺ ยุษฺมากํ ราชานํ กึ กฺรุเศ เวธิษฺยามิ? ปฺรธานยาชกา อุตฺตรมฺ อวทนฺ ไกสรํ วินา โกปิ ราชาสฺมากํ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ตต: ปีลาโต ยีศุํ กฺรุเศ เวธิตุํ เตษำ หเสฺตษุ สมารฺปยตฺ, ตตเสฺต ตํ ธฺฤตฺวา นีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ตต: ปรํ ยีศุ: กฺรุศํ วหนฺ ศิร:กปาลมฺ อรฺถาทฺ ยทฺ อิพฺรียภาษยา คุลฺคลฺตำ วทนฺติ ตสฺมินฺ สฺถาน อุปสฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ตตเสฺต มธฺยสฺถาเน ตํ ตโสฺยภยปารฺเศฺว ทฺวาวปเรา กฺรุเศ'วิธนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","อปรมฺ เอษ ยิหูทียานำ ราชา นาสรตียยีศุ:, อิติ วิชฺญาปนํ ลิขิตฺวา ปีลาตสฺตสฺย กฺรุโศปริ สมโยชยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","สา ลิปิ: อิพฺรียยูนานียโรมียภาษาภิ รฺลิขิตา; ยีโศ: กฺรุศเวธนสฺถานํ นครสฺย สมีปํ, ตสฺมาทฺ พหโว ยิหูทียาสฺตำ ปฐิตุมฺ อารภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ยิหูทียานำ ปฺรธานยาชกา: ปีลาตมิติ นฺยเวทยนฺ ยิหูทียานำ ราเชติ วากฺยํ น กินฺตุ เอษ สฺวํ ยิหูทียานำ ราชานมฺ อวททฺ อิตฺถํ ลิขตุฯ ");
INSERT INTO santha_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ตต: ปีลาต อุตฺตรํ ทตฺตวานฺ ยเลฺลขนียํ ตลฺลิขิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","อิตฺถํ เสนาคโณ ยีศุํ กฺรุเศ วิธิตฺวา ตสฺย ปริเธยวสฺตฺรํ จตุโร ภาคานฺ กฺฤตฺวา เอไกกเสนา เอไกกภาคมฺ อคฺฤหฺลตฺ ตโสฺยตฺตรียวสฺตฺรญฺจาคฺฤหฺลตฺฯ กินฺตูตฺตรียวสฺตฺรํ สูจิเสวนํ วินา สรฺวฺวมฺ อูตํฯ ");
INSERT INTO santha_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ตสฺมาตฺเต วฺยาหรนฺ เอตตฺ ก: ปฺราปฺสฺยติ? ตนฺน ขณฺฑยิตฺวา ตตฺร คุฏิกาปาตํ กรวามฯ วิภชนฺเต'ธรียํ เม วสนํ เต ปรสฺปรํฯ มโมตฺตรียวสฺตฺรารฺถํ คุฏิกำ ปาตยนฺติ จฯ อิติ ยทฺวากฺยํ ธรฺมฺมปุสฺตเก ลิขิตมาเสฺต ตตฺ เสนาคเณเนตฺถํ วฺยวหรณาตฺ สิทฺธมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ตทานีํ ยีโศ รฺมาตา มาตุ รฺภคินี จ ยา กฺลิยปา ภารฺยฺยา มริยมฺ มคฺทลีนี มริยมฺ จ เอตาสฺตสฺย กฺรุศสฺย สนฺนิเธา สมติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ตโต ยีศุ: สฺวมาตรํ ปฺริยตมศิษฺยญฺจ สมีเป ทณฺฑายมาเนา วิโลกฺย มาตรมฺ อวทตฺ, เห โยษิทฺ เอนํ ตว ปุตฺรํ ปศฺย, ");
INSERT INTO santha_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ศิษฺยนฺตฺววทตฺ, เอนำ ตว มาตรํ ปศฺยฯ ตต: ส ศิษฺยสฺตทฺฆฏิกายำ ตำ นิชคฺฤหํ นีตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","อนนฺตรํ สรฺวฺวํ กรฺมฺมาธุนา สมฺปนฺนมภูตฺ ยีศุริติ ชฺญาตฺวา ธรฺมฺมปุสฺตกสฺย วจนํ ยถา สิทฺธํ ภวติ ตทรฺถมฺ อกถยตฺ มม ปิปาสา ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ตตสฺตสฺมินฺ สฺถาเน อมฺลรเสน ปูรฺณปาตฺรสฺถิตฺยา เต สฺปญฺชเมกํ ตทมฺลรเสนารฺทฺรีกฺฤตฺย เอโสพฺนเล ตทฺ โยชยิตฺวา ตสฺย มุขสฺย สนฺนิธาวสฺถาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ตทา ยีศุรมฺลรสํ คฺฤหีตฺวา สรฺวฺวํ สิทฺธมฺ อิติ กถำ กถยิตฺวา มสฺตกํ นมยนฺ ปฺราณานฺ ปรฺยฺยตฺยชตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ตทฺวินมฺ อาสาทนทินํ ตสฺมาตฺ ปเร'หนิ วิศฺรามวาเร เทหา ยถา กฺรุโศปริ น ติษฺฐนฺติ, ยต: ส วิศฺรามวาโร มหาทินมาสีตฺ, ตสฺมาทฺ ยิหูทียา: ปีลาตนิกฏํ คตฺวา เตษำ ปาทภญฺชนสฺย สฺถานานฺตรนยนสฺย จานุมตึ ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","อต: เสนา อาคตฺย ยีศุนา สห กฺรุเศ หตโย: ปฺรถมทฺวิตียโจรโย: ปาทานฺ อภญฺชนฺ; ");
INSERT INTO santha_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","กินฺตุ ยีโศ: สนฺนิธึ คตฺวา ส มฺฤต อิติ ทฺฤษฺฏฺวา ตสฺย ปาเทา นาภญฺชนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ปศฺจาทฺ เอโก โยทฺธา ศูลาฆาเตน ตสฺย กุกฺษิมฺ อวิธตฺ ตตฺกฺษณาตฺ ตสฺมาทฺ รกฺตํ ชลญฺจ นิรคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","โย ชโน'สฺย สากฺษฺยํ ททาติ ส สฺวยํ ทฺฤษฺฏวานฺ ตเสฺยทํ สากฺษฺยํ สตฺยํ ตสฺย กถา ยุษฺมากํ วิศฺวาสํ ชนยิตุํ โยคฺยา ตตฺ ส ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ตไสฺยกมฺ อสฺธฺยปิ น ภํกฺษฺยเต, ");
INSERT INTO santha_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ตทฺวทฺ อนฺยศาสฺเตฺรปิ ลิขฺยเต, ยถา, \"ทฺฤษฺฏิปาตํ กริษฺยนฺติ เต'วิธนฺ ยนฺตุ ตมฺปฺรติฯ \" ");
INSERT INTO santha_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","อริมถียนครสฺย ยูษผฺนามา ศิษฺย เอก อาสีตฺ กินฺตุ ยิหูทีเยโภฺย ภยาตฺ ปฺรกาศิโต น ภวติ; ส ยีโศ เรฺทหํ เนตุํ ปีลาตสฺยานุมตึ ปฺรารฺถยต, ตต: ปีลาเตนานุมเต สติ ส คตฺวา ยีโศ เรฺทหมฺ อนยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","อปรํ โย นิกทีโม ราเตฺรา ยีโศ: สมีปมฺ อคจฺฉตฺ โสปิ คนฺธรเสน มิศฺริตํ ปฺราเยณ ปญฺจาศตฺเสฏกมคุรุํ คฺฤหีตฺวาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ตตเสฺต ยิหูทียานำ ศฺมศาเน สฺถาปนรีตฺยนุสาเรณ ตตฺสุคนฺธิทฺรเวฺยณ สหิตํ ตสฺย เทหํ วสฺเตฺรณาเวษฺฏยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","อปรญฺจ ยตฺร สฺถาเน ตํ กฺรุเศ'วิธนฺ ตสฺย นิกฏโสฺถทฺยาเน ยตฺร กิมปิ มฺฤตเทหํ กทาปิ นาสฺถาปฺยต ตาทฺฤศมฺ เอกํ นูตนํ ศฺมศานมฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ยิหูทียานามฺ อาสาทนทินาคมนาตฺ เต ตสฺมินฺ สมีปสฺถศฺมศาเน ยีศุมฺ อศายยนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","อนนฺตรํ สปฺตาหสฺย ปฺรถมทิเน 'ติปฺรตฺยูเษ 'นฺธกาเร ติษฺฐติ มคฺทลีนี มริยมฺ ตสฺย ศฺมศานสฺย นิกฏํ คตฺวา ศฺมศานสฺย มุขาตฺ ปฺรสฺตรมปสาริตมฺ อปศฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ปศฺจาทฺ ธาวิตฺวา ศิโมนฺปิตราย ยีโศ: ปฺริยตมศิษฺยาย เจทมฺ อกถยตฺ, โลกา: ศฺมศานาตฺ ปฺรภุํ นีตฺวา กุตฺราสฺถาปยนฺ ตทฺ วกฺตุํ น ศกฺโนมิฯ ");
INSERT INTO santha_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","อต: ปิตร: โสนฺยศิษฺยศฺจ พรฺหิ รฺภุตฺวา ศฺมศานสฺถานํ คนฺตุมฺ อารเภตำฯ ");
INSERT INTO santha_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","อุภโยรฺธาวโต: โสนฺยศิษฺย: ปิตรํ ปศฺจาตฺ ตฺยกฺตฺวา ปูรฺวฺวํ ศฺมศานสฺถาน อุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ตทา ปฺรหฺวีภูย สฺถาปิตวสฺตฺราณิ ทฺฤษฺฏวานฺ กินฺตุ น ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","อปรํ ศิโมนฺปิตร อาคตฺย ศฺมศานสฺถานํ ปฺรวิศฺย ");
INSERT INTO santha_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","สฺถาปิตวสฺตฺราณิ มสฺตกสฺย วสฺตฺรญฺจ ปฺฤถกฺ สฺถานานฺตเร สฺถาปิตํ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ตต: ศฺมศานสฺถานํ ปูรฺวฺวมฺ อาคโต โยนฺยศิษฺย: โสปิ ปฺรวิศฺย ตาทฺฤศํ ทฺฤษฺฏา วฺยศฺวสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ยต: ศฺมศานาตฺ ส อุตฺถาปยิตวฺย เอตสฺย ธรฺมฺมปุสฺตกวจนสฺย ภาวํ เต ตทา โวทฺธุํ นาศนฺกุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","อนนฺตรํ เตา เทฺวา ศิเษฺยา สฺวํ สฺวํ คฺฤหํ ปราวฺฤตฺยาคจฺฉตามฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ตต: ปรํ มริยมฺ ศฺมศานทฺวารสฺย พหิ: สฺถิตฺวา โรทิตุมฺ อารภต ตโต รุทตี ปฺรหฺวีภูย ศฺมศานํ วิโลกฺย ");
INSERT INTO santha_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ยีโศ: ศยนสฺถานสฺย ศิร:สฺถาเน ปทตเล จ ทฺวโย รฺทิโศ เทฺวา สฺวรฺคียทูตาวุปวิษฺเฏา สมปศฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","เตา ปฺฤษฺฏวนฺเตา เห นาริ กุโต โรทิษิ? สาวทตฺ โลกา มม ปฺรภุํ นีตฺวา กุตฺราสฺถาปยนฺ อิติ น ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","อิตฺยุกฺตฺวา มุขํ ปราวฺฤตฺย ยีศุํ ทณฺฑายมานมฺ อปศฺยตฺ กินฺตุ ส ยีศุริติ สา ชฺญาตุํ นาศกฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ตทา ยีศุสฺตามฺ อปฺฤจฺฉตฺ เห นาริ กุโต โรทิษิ? กํ วา มฺฤคยเส? ตต: สา ตมฺ อุทฺยานเสวกํ ชฺญาตฺวา วฺยาหรตฺ, เห มเหจฺฉ ตฺวํ ยทีต: สฺถานาตฺ ตํ นีตวานฺ ตรฺหิ กุตฺราสฺถาปยสฺตทฺ วท ตตฺสฺถานาตฺ ตมฺ อานยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ตทา ยีศุสฺตามฺ อวทตฺ เห มริยมฺฯ ตต: สา ปราวฺฤตฺย ปฺรตฺยวทตฺ เห รพฺพูนี อรฺถาตฺ เห คุโรฯ ");
INSERT INTO santha_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ตทา ยีศุรวทตฺ มำ มา ธร, อิทานีํ ปิตุ: สมีเป อูรฺทฺธฺวคมนํ น กโรมิ กินฺตุ โย มม ยุษฺมากญฺจ ปิตา มม ยุษฺมากญฺเจศฺวรสฺตสฺย นิกฏ อูรฺทฺธฺวคมนํ กรฺตฺตุมฺ อุทฺยโตสฺมิ, อิมำ กถำ ตฺวํ คตฺวา มม ภฺราตฺฤคณํ ชฺญาปยฯ ");
INSERT INTO santha_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ตโต มคฺทลีนีมริยมฺ ตตฺกฺษณาทฺ คตฺวา ปฺรภุสฺตไสฺย ทรฺศนํ ทตฺตฺวา กถา เอตา อกถยทฺ อิติ วารฺตฺตำ ศิเษฺยโภฺย'กถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ตต: ปรํ สปฺตาหสฺย ปฺรถมทินสฺย สนฺธฺยาสมเย ศิษฺยา เอกตฺร มิลิตฺวา ยิหูทีเยโภฺย ภิยา ทฺวารรุทฺธมฺ อกุรฺวฺวนฺ, เอตสฺมินฺ กาเล ยีศุเสฺตษำ มธฺยสฺถาเน ติษฺฐนฺ อกถยทฺ ยุษฺมากํ กลฺยาณํ ภูยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","อิตฺยุกฺตฺวา นิชหสฺตํ กุกฺษิญฺจ ทรฺศิตวานฺ, ตต: ศิษฺยา: ปฺรภุํ ทฺฤษฺฏฺวา หฺฤษฺฏา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ยีศุ: ปุนรวททฺ ยุษฺมากํ กลฺยาณํ ภูยาตฺ ปิตา ยถา มำ ไปฺรษยตฺ ตถาหมปิ ยุษฺมานฺ เปฺรษยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","อิตฺยุกฺตฺวา ส เตษามุปริ ทีรฺฆปฺรศฺวาสํ ทตฺตฺวา กถิตวานฺ ปวิตฺรมฺ อาตฺมานํ คฺฤหฺลีตฯ ");
INSERT INTO santha_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ยูยํ เยษำ ปาปานิ โมจยิษฺยถ เต โมจยิษฺยนฺเต เยษาญฺจ ปาปาติ น โมจยิษฺยถ เต น โมจยิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ทฺวาทศมเธฺย คณิโต ยมโช โถมานามา ศิโษฺย ยีโศราคมนกาไล ไต: สารฺทฺธํ นาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","อโต วยํ ปฺรภูมฺ อปศฺยาเมติ วาเกฺย'นฺยศิไษฺยรุกฺเต โสวทตฺ, ตสฺย หสฺตโย เรฺลาหกีลกานำ จิหฺนํ น วิโลกฺย ตจฺจิหฺนมฺ องฺคุลฺยา น สฺปฺฤษฺฏฺวา ตสฺย กุกฺเษา หสฺตํ นาโรปฺย จาหํ น วิศฺวสิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","อปรมฺ อษฺฏเม'หฺนิ คเต สติ โถมาสหิต: ศิษฺยคณ เอกตฺร มิลิตฺวา ทฺวารํ รุทฺธฺวาภฺยนฺตร อาสีตฺ, เอตรฺหิ ยีศุเสฺตษำ มธฺยสฺถาเน ติษฺฐนฺ อกถยตฺ, ยุษฺมากํ กุศลํ ภูยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ปศฺจาตฺ ถาไม กถิตวานฺ ตฺวมฺ องฺคุลีมฺ อตฺรารฺปยิตฺวา มม กเรา ปศฺย กรํ ปฺรสารฺยฺย มม กุกฺษาวรฺปย นาวิศฺวสฺยฯ ");
INSERT INTO santha_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ตทา โถมา อวทตฺ, เห มม ปฺรโภ เห มทีศฺวรฯ ");
INSERT INTO santha_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ยีศุรกถยตฺ, เห โถมา มำ นิรีกฺษฺย วิศฺวสิษิ เย น ทฺฤษฺฏฺวา วิศฺวสนฺติ เตอว ธนฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","เอตทนฺยานิ ปุสฺตเก'สฺมินฺ อลิขิตานิ พหูนฺยาศฺจรฺยฺยกรฺมฺมาณิ ยีศุ: ศิษฺยาณำ ปุรสฺตาทฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","กินฺตุ ยีศุรีศฺวรสฺยาภิษิกฺต: สุต เอเวติ ยถา ยูยํ วิศฺวสิถ วิศฺวสฺย จ ตสฺย นามฺนา ปรมายุ: ปฺราปฺนุถ ตทรฺถมฺ เอตานิ สรฺวฺวาณฺยลิขฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ตต: ปรํ ติพิริยาชลเธสฺตเฏ ยีศุ: ปุนรปิ ศิเษฺยโภฺย ทรฺศนํ ทตฺตวานฺ ทรฺศนสฺยาขฺยานมิทมฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ศิโมนฺปิตร: ยมชโถมา คาลีลียกานฺนานครนิวาสี นิถเนลฺ สิวเท: ปุตฺราวเนฺยา เทฺวา ศิเษฺยา ไจเตเษฺวกตฺร มิลิเตษุ ศิโมนฺปิตโร'กถยตฺ มตฺสฺยานฺ ธรฺตุํ ยามิฯ ");
INSERT INTO santha_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ตตเสฺต วฺยาหรนฺ ตรฺหิ วยมปิ ตฺวยา สารฺทฺธํ ยาม: ตทา เต พหิรฺคตา: สนฺต: กฺษิปฺรํ นาวมฺ อาโรหนฺ กินฺตุ ตสฺยำ รชนฺยามฺ เอกมปิ น ปฺราปฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ปฺรภาเต สติ ยีศุสฺตเฏ สฺถิตวานฺ กินฺตุ ส ยีศุริติ ศิษฺยา ชฺญาตุํ นาศกฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ตทา ยีศุรปฺฤจฺฉตฺ, เห วตฺสา สนฺนิเธา กิญฺจิตฺ ขาทฺยทฺรวฺยมฺ อาเสฺต? เต'วทนฺ กิมปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ตทา โส'วทตฺ เนากายา ทกฺษิณปารฺเศฺว ชาลํ นิกฺษิปต ตโต ลปฺสฺยเธฺว, ตสฺมาตฺ ไต รฺนิกฺษิปฺเต ชาเล มตฺสฺยา เอตาวนฺโต'ปตนฺ เยน เต ชาลมากฺฤษฺย โนตฺโตลยิตุํ ศกฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ตสฺมาทฺ ยีโศ: ปฺริยตมศิษฺย: ปิตรายากถยตฺ เอษ ปฺรภุ รฺภเวตฺ, เอษ ปฺรภุริติ วาจํ ศฺรุไตฺวว ศิโมนฺ นคฺนตาเหโต รฺมตฺสฺยธาริณ อุตฺตรียวสฺตฺรํ ปริธาย หฺรทํ ปฺรตฺยุทลมฺผยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","อปเร ศิษฺยา มตฺไสฺย: สารฺทฺธํ ชาลมฺ อากรฺษนฺต: กฺษุทฺรเนากำ วาหยิตฺวา กูลมานยนฺ เต กูลาทฺ อติทูเร นาสนฺ ทฺวิศตหเสฺตโภฺย ทูร อาสนฺ อิตฺยนุมียเตฯ ");
INSERT INTO santha_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ตีรํ ปฺราปฺไตไสฺตสฺตตฺร ปฺรชฺวลิตาคฺนิสฺตทุปริ มตฺสฺยา: ปูปาศฺจ ทฺฤษฺฏา:ฯ ");
INSERT INTO santha_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ตโต ยีศุรกถยทฺ ยานฺ มตฺสฺยานฺ อธรต เตษำ กติปยานฺ อานยตฯ ");
INSERT INTO santha_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","อต: ศิโมนฺปิตร: ปราวฺฤตฺย คตฺวา พฺฤหทฺภิสฺตฺริปญฺจาศทธิกศตมตฺไสฺย: ปริปูรฺณํ ตชฺชาลมฺ อากฺฤโษฺยทโตลยตฺ กินฺเตฺวตาวทฺภิ รฺมตฺไสฺยรปิ ชาลํ นาฉิทฺยตฯ ");
INSERT INTO santha_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","อนนฺตรํ ยีศุสฺตานฺ อวาทีตฺ ยูยมาคตฺย ภุํคฺธฺวํ; ตทา เสอว ปฺรภุริติ ชฺญาตตฺวาตฺ ตฺวํ ก:? อิติ ปฺรษฺฏุํ ศิษฺยาณำ กสฺยาปิ ปฺรคลฺภตา นาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ตโต ยีศุราคตฺย ปูปานฺ มตฺสฺยำศฺจ คฺฤหีตฺวา เตภฺย: ปรฺยฺยเวษยตฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","อิตฺถํ ศฺมศานาทุตฺถานาตฺ ปรํ ยีศุ: ศิเษฺยภฺยสฺตฺฤตียวารํ ทรฺศนํ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","โภชเน สมาปฺเต สติ ยีศุ: ศิโมนฺปิตรํ ปฺฤษฺฏวานฺ, เห ยูนส: ปุตฺร ศิโมนฺ ตฺวํ กิมฺ เอเตโภฺยธิกํ มยิ ปฺรียเส? ตต: ส อุทิตวานฺ สตฺยํ ปฺรโภ ตฺวยิ ปฺรีเย'หํ ตทฺ ภวานฺ ชานาติ; ตทา ยีศุรกถยตฺ ตรฺหิ มม เมษศาวกคณํ ปาลยฯ ");
INSERT INTO santha_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ตต: ส ทฺวิตียวารํ ปฺฤษฺฏวานฺ เห ยูนส: ปุตฺร ศิโมนฺ ตฺวํ กึ มยิ ปฺรียเส? ตต: ส อุกฺตวานฺ สตฺยํ ปฺรโภ ตฺวยิ ปฺรีเย'หํ ตทฺ ภวานฺ ชานาติ; ตทา ยีศุรกถยต ตรฺหิ มม เมษคณํ ปาลยฯ ");
INSERT INTO santha_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ปศฺจาตฺ ส ตฺฤตียวารํ ปฺฤษฺฏวานฺ, เห ยูนส: ปุตฺร ศิโมนฺ ตฺวํ กึ มยิ ปฺรียเส? เอตทฺวากฺยํ ตฺฤตียวารํ ปฺฤษฺฏวานฺ ตสฺมาตฺ ปิตโร ทุ:ขิโต ภูตฺวา'กถยตฺ เห ปฺรโภ ภวต: กิมปฺยโคจรํ นาสฺติ ตฺวยฺยหํ ปฺรีเย ตทฺ ภวานฺ ชานาติ; ตโต ยีศุรวทตฺ ตรฺหิ มม เมษคณํ ปาลยฯ ");
INSERT INTO santha_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","อหํ ตุภฺยํ ยถารฺถํ กถยามิ เยาวนกาเล สฺวยํ พทฺธกฏิ รฺยเตฺรจฺฉา ตตฺร ยาตวานฺ กินฺตฺวิต: ปรํ วฺฤทฺเธ วยสิ หสฺตํ วิสฺตารยิษฺยสิ, อนฺยชนสฺตฺวำ พทฺธฺวา ยตฺร คนฺตุํ ตเวจฺฉา น ภวติ ตฺวำ ธฺฤตฺวา ตตฺร เนษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ผลต: กีทฺฤเศน มรเณน ส อีศฺวรสฺย มหิมานํ ปฺรกาศยิษฺยติ ตทฺ โพธยิตุํ ส อิติ วากฺยํ โปฺรกฺตวานฺฯ อิตฺยุกฺเต สติ ส ตมโวจตฺ มม ปศฺจาทฺ อาคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","โย ชโน ราตฺริกาเล ยีโศ รฺวกฺโษ'วลมฺพฺย, เห ปฺรโภ โก ภวนฺตํ ปรกเรษุ สมรฺปยิษฺยตีติ วากฺยํ ปฺฤษฺฏวานฺ, ตํ ยีโศ: ปฺริยตมศิษฺยํ ปศฺจาทฺ อาคจฺฉนฺตํ ");
INSERT INTO santha_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ปิตโร มุขํ ปราวรฺตฺตฺย วิโลกฺย ยีศุํ ปฺฤษฺฏวานฺ, เห ปฺรโภ เอตสฺย มานวสฺย กีทฺฤศี คติ รฺภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ส ปฺรตฺยวทตฺ, มม ปุนราคมนปรฺยฺยนฺตํ ยทิ ตํ สฺถาปยิตุมฺ อิจฺฉามิ ตตฺร ตว กึ? ตฺวํ มม ปศฺจาทฺ อาคจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ตสฺมาตฺ ส ศิโษฺย น มริษฺยตีติ ภฺราตฺฤคณมเธฺย กึวทนฺตี ชาตา กินฺตุ ส น มริษฺยตีติ วากฺยํ ยีศุ รฺนาวทตฺ เกวลํ มม ปุนราคมนปรฺยฺยนฺตํ ยทิ ตํ สฺถาปยิตุมฺ อิจฺฉามิ ตตฺร ตว กึ? อิติ วากฺยมฺ อุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","โย ชน เอตานิ สรฺวฺวาณิ ลิขิตวานฺ อตฺร สากฺษฺยญฺจ ทตฺตวานฺ เสอว ส ศิษฺย:, ตสฺย สากฺษฺยํ ปฺรมาณมิติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ยีศุเรเตโภฺย'ปราณฺยปิ พหูนิ กรฺมฺมาณิ กฺฤตวานฺ ตานิ สรฺวฺวาณิ ยเทฺยไกกํ กฺฤตฺวา ลิขฺยนฺเต ตรฺหิ คฺรนฺถา เอตาวนฺโต ภวนฺติ เตษำ ธารเณ ปฺฤถิวฺยำ สฺถานํ น ภวติฯ อิติ๚");
INSERT INTO santha_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","เห ถิยผิล, ยีศุ: สฺวมโนนีตานฺ เปฺรริตานฺ ปวิเตฺรณาตฺมนา สมาทิศฺย ยสฺมินฺ ทิเน สฺวรฺคมาโรหตฺ ยำ ยำ กฺริยามกโรตฺ ยทฺยทฺ อุปาทิศจฺจ ตานิ สรฺวฺวาณิ ปูรฺวฺวํ มยา ลิขิตานิฯ ");
INSERT INTO santha_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ส สฺวนิธนทุ:ขโภคาตฺ ปรมฺ อเนกปฺรตฺยยกฺษปฺรมาเณา: สฺวํ สชีวํ ทรฺศยิตฺวา ");
INSERT INTO santha_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","จตฺวารึศทฺทินานิ ยาวตฺ เตภฺย: เปฺรริเตโภฺย ทรฺศนํ ทตฺเตฺวศฺวรียราชฺยสฺย วรฺณนม อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","อนนฺตรํ เตษำ สภำ กฺฤตฺวา อิตฺยาชฺญาปยตฺ, ยูยํ ยิรูศาลโม'นฺยตฺร คมนมกฺฤตฺวา ยสฺตินฺ ปิตฺรางฺคีกฺฤเต มม วทนาตฺ กถา อศฺฤณุต ตตฺปฺราปฺติมฺ อเปกฺษฺย ติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","โยหนฺ ชเล มชฺชิตาวานฺ กินฺตฺวลฺปทินมเธฺย ยูยํ ปวิตฺร อาตฺมนิ มชฺชิตา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ปศฺจาตฺ เต สรฺเวฺว มิลิตฺวา ตมฺ อปฺฤจฺฉนฺ เห ปฺรโภ ภวานฺ กิมิทานีํ ปุนรปิ ราชฺยมฺ อิสฺราเยลียโลกานำ กเรษุ สมรฺปยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ตต: โสวทตฺ ยานฺ สรฺวฺวานฺ กาลานฺ สมยำศฺจ ปิตา สฺววเศ'สฺถาปยตฺ ตานฺ ชฺญาตฺฤํ ยุษฺมากมฺ อธิกาโร น ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","กินฺตุ ยุษฺมาสุ ปวิตฺรสฺยาตฺมน อาวิรฺภาเว สติ ยูยํ ศกฺตึ ปฺราปฺย ยิรูศาลมิ สมสฺตยิหูทาโศมิโรณเทศโย: ปฺฤถิวฺยา: สีมำ ยาวทฺ ยาวนฺโต เทศาเสฺตษุ ยรฺเวฺวษุ จ มยิ สากฺษฺยํ ทาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","อิติ วากฺยมุกฺตฺวา ส เตษำ สมกฺษํ สฺวรฺคํ นีโต'ภวตฺ, ตโต เมฆมารุหฺย เตษำ ทฺฤษฺเฏรโคจโร'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ยสฺมินฺ สมเย เต วิหายสํ ปฺรตฺยนนฺยทฺฤษฺฏฺยา ตสฺย ตาทฺฤศมฺ อูรฺทฺวฺวคมนมฺ อปศฺยนฺ ตสฺมินฺเนว สมเย ศุกฺลวสฺเตฺรา เทฺวา ชเนา เตษำ สนฺนิเธา ทณฺฑายมาเนา กถิตวนฺเตา, ");
INSERT INTO santha_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","เห คาลีลียโลกา ยูยํ กิมรฺถํ คคณํ ปฺรติ นิรีกฺษฺย ทณฺฑายมานาสฺติษฺฐถ? ยุษฺมากํ สมีปาตฺ สฺวรฺคํ นีโต โย ยีศุสฺตํ ยูยํ ยถา สฺวรฺคมฺ อาโรหนฺตมฺ อทรฺศมฺ ตถา ส ปุนศฺจาคมิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ตต: ปรํ เต ไชตุนนามฺน: ปรฺวฺวตาทฺ วิศฺรามวารสฺย ปถ: ปริมาณมฺ อรฺถาตฺ ปฺราเยณารฺทฺธโกฺรศํ ทุรสฺถํ ยิรูศาลมฺนครํ ปราวฺฤตฺยาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","นครํ ปฺรวิศฺย ปิตโร ยากูพฺ โยหนฺ อานฺทฺริย: ผิลิป: โถมา พรฺถชมโย มถิราลฺผียปุโตฺร ยากูพฺ อุโทฺยคาी ศิโมนฺ ยากูโพ ภฺราตา ยิหูทา เอเต สรฺเวฺว ยตฺร สฺถาเน ปฺรวสนฺติ ตสฺมินฺ อุปริตนปฺรโกษฺเฐ ปฺราวิศนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ปศฺจาทฺ อิเม กิยตฺย: สฺตฺริยศฺจ ยีโศ รฺมาตา มริยมฺ ตสฺย ภฺราตรศฺไจเต สรฺวฺว เอกจิตฺตีภูต สตตํ วินเยน วินเยน ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ตสฺมินฺ สมเย ตตฺร สฺถาเน สากเลฺยน วึศตฺยธิกศตํ ศิษฺยา อาสนฺฯ ตต: ปิตรเสฺตษำ มเธฺย ติษฺฐนฺ อุกฺตวานฺ ");
INSERT INTO santha_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","เห ภฺราตฺฤคณ ยีศุธาริณำ โลกานำ ปถทรฺศโก โย ยิหูทาสฺตสฺมินฺ ทายูทา ปวิตฺร อาตฺมา ยำ กถำ กถยามาส ตสฺยา: ปฺรตฺยกฺษีภวนสฺยาวศฺยกตฺวมฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ส ชโน'สฺมากํ มธฺยวรฺตฺตี สนฺ อสฺยา: เสวายา อํศมฺ อลภตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ตทนนฺตรํ กุกรฺมฺมณา ลพฺธํ ยนฺมูลฺยํ เตน เกฺษตฺรเมกํ กฺรีตมฺ อปรํ ตสฺมินฺ อโธมุเข ภฺฤเมา ปติเต สติ ตโสฺยทรสฺย วิทีรฺณตฺวาตฺ สรฺวฺวา นาโฑฺย นิรคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","เอตำ กถำ ยิรูศาลมฺนิวาสิน: สรฺเวฺว โลกา วิทานฺติ; เตษำ นิชภาษยา ตตฺกฺเษตฺรญฺจ หกลฺทามา, อรฺถาตฺ รกฺตกฺเษตฺรมิติ วิขฺยาตมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","อนฺยจฺจ, นิเกตนํ ตทียนฺตุ ศุนฺยเมว ภวิษฺยติฯ ตสฺย ทูเษฺย นิวาสารฺถํ โกปิ สฺถาสฺยติ ไนว หิฯ อนฺย เอว ชนสฺตสฺย ปทํ สํปฺราปฺสฺยติ ธฺรุวํฯ อิตฺถํ คีตปุสฺตเก ลิขิตมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","อโต โยหโน มชฺชนมฺ อารภฺยาสฺมากํ สมีปาตฺ ปฺรโภ รฺยีโศ: สฺวรฺคาโรหณทินํ ยาวตฺ โสสฺมากํ มเธฺย ยาวนฺติ ทินานิ ยาปิตวานฺ ");
INSERT INTO santha_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ตาวนฺติ ทินานิ เย มานวา อสฺมาภิ: สารฺทฺธํ ติษฺฐนฺติ เตษามฺ เอเกน ชเนนาสฺมาภิ: สารฺทฺธํ ยีโศรุตฺถาเน สากฺษิณา ภวิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","อโต ยสฺย รูฒิ รฺยุษฺโฏ ยํ พรฺศพฺเพตฺยุกฺตฺวาหูยนฺติ ส ยูษผฺ มตถิศฺจ ทฺวาเวเตา ปฺฤถกฺ กฺฤตฺวา ต อีศฺวรสฺย สนฺนิเธา ปฺรารฺยฺย กถิตวนฺต:, ");
INSERT INTO santha_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","เห สรฺวฺวานฺตรฺยฺยามินฺ ปรเมศฺวร, ยิหูทา: เสวนเปฺรริตตฺวปทจฺยุต: ");
INSERT INTO santha_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","สนฺ นิชสฺถานมฺ อคจฺฉตฺ, ตตฺปทํ ลพฺธุมฺ เอนโย รฺชนโย รฺมเธฺย ภวตา โก'ภิรุจิตสฺตทสฺมานฺ ทรฺศฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ตโต คุฏิกาปาเฏ กฺฤเต มตถิรฺนิรจียต ตสฺมาตฺ โสเนฺยษามฺ เอกาทศานำ ปฺรริตานำ มเธฺย คณิโตภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","อปรญฺจ นิสฺตาโรตฺสวาตฺ ปรํ ปญฺจาศตฺตเม ทิเน สมุปสฺถิเต สติ เต สรฺเวฺว เอกาจิตฺตีภูย สฺถาน เอกสฺมินฺ มิลิตา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","เอตสฺมินฺเนว สมเย'กสฺมาทฺ อากาศาตฺ ปฺรจณฺฑาตฺยุคฺรวาโย: ศพฺทวทฺ เอก: ศพฺท อาคตฺย ยสฺมินฺ คฺฤเห ต อุปาวิศนฺ ตทฺ คฺฤหํ สมสฺตํ วฺยาปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ตต: ปรํ วหฺนิศิขาสฺวรูปา ชิหฺวา: ปฺรตฺยกฺษีภูย วิภกฺตา: สตฺย: ปฺรติชโนรฺทฺเธฺว สฺถคิตา อภูวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ตสฺมาตฺ สรฺเวฺว ปวิเตฺรณาตฺมนา ปริปูรฺณา: สนฺต อาตฺมา ยถา วาจิตวานฺ ตทนุสาเรณานฺยเทศียานำ ภาษา อุกฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ตสฺมินฺ สมเย ปฺฤถิวีสฺถสรฺวฺวเทเศโภฺย ยิหูทียมตาวลมฺพิโน ภกฺตโลกา ยิรูศาลมิ ปฺราวสนฺ; ");
INSERT INTO santha_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ตสฺยา: กถายา: กึวทนฺตฺยา ชาตตฺวาตฺ สรฺเวฺว โลกา มิลิตฺวา นิชนิชภาษยา ศิษฺยาณำ กถากถนํ ศฺรุตฺวา สมุทฺวิคฺนา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","สรฺวฺเวอว วิสฺมยาปนฺนา อาศฺจรฺยฺยานฺวิตาศฺจ สนฺต: ปรสฺปรํ อุกฺตวนฺต: ปศฺยต เย กถำ กถยนฺติ เต สรฺเวฺว คาลีลียโลกา: กึ น ภวนฺติ? ");
INSERT INTO santha_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ตรฺหิ วยํ ปฺรเตฺยกศ: สฺวสฺวชนฺมเทศียภาษาภิ: กถา เอเตษำ ศฺฤณุม: กิมิทํ? ");
INSERT INTO santha_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ปารฺถี-มาที-อรามฺนหรยิมฺเทศนิวาสิมโน ยิหูทา-กปฺปทกิยา-ปนฺต-อาศิยา- ");
INSERT INTO santha_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ผฺรุคิยา-ปมฺผุลิยา-มิสรนิวาสิน: กุรีณีนิกฏวรฺตฺติลูพียปฺรเทศนิวาสิโน โรมนคราทฺ อาคตา ยิหูทียโลกา ยิหูทียมตคฺราหิณ: กฺรีตียา อราพียาทโย โลกาศฺจ เย วยมฺ ");
INSERT INTO santha_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","อสฺมากํ นิชนิชภาษาภิเรเตษามฺ อีศฺวรียมหากรฺมฺมวฺยาขฺยานํ ศฺฤณุม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","อิตฺถํ เต สรฺวฺเวอว วิสฺมยาปนฺนา: สนฺทิคฺธจิตฺตา: สนฺต: ปรสฺปรมูจุ:, อสฺย โก ภาว:? ");
INSERT INTO santha_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","อปเร เกจิตฺ ปริหสฺย กถิตวนฺต เอเต นวีนทฺรากฺษารเสน มตฺตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ตทา ปิตร เอกาทศภิ รฺชไน: สากํ ติษฺฐนฺ ตาโลฺลกานฺ อุจฺไจ:การมฺ อวทตฺ, เห ยิหูทียา เห ยิรูศาลมฺนิวาสิน: สรฺเวฺว, อวธานํ กฺฤตฺวา มทียวากฺยํ พุธฺยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","อิทานีมฺ เอกยามาทฺ อธิกา เวลา นาสฺติ ตสฺมาทฺ ยูยํ ยทฺ อนุมาถ มานวา อิเม มทฺยปาเนน มตฺตาสฺตนฺนฯ ");
INSERT INTO santha_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","กินฺตุ โยเยลฺภวิษฺยทฺวกฺไตฺรตทฺวากฺยมุกฺตํ ยถา, ");
INSERT INTO santha_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","อีศฺวร: กถยามาส ยุคานฺตสมเย ตฺวหมฺฯ วรฺษิษฺยามิ สฺวมาตฺมานํ สรฺวฺวปฺราณฺยุปริ ธฺรุวมฺฯ ภาวิวากฺยํ วทิษฺยนฺติ กนฺยา: ปุตฺราศฺจ วสฺตุต:ฯ ปฺรตฺยาเทศญฺจ ปฺราปฺสฺยนฺติ ยุษฺมากํ ยุวมานวา:ฯ ตถา ปฺราจีนโลกาสฺตุ สฺวปฺนานฺ ทฺรกฺษฺยนฺติ นิศฺจิตํฯ ");
INSERT INTO santha_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","วรฺษิษฺยามิ ตทาตฺมานํ ทาสทาสีชโนปิริฯ เตไนว ภาวิวากฺยํ เต วทิษฺยนฺติ หิ สรฺวฺวศ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","อูรฺทฺธฺวเสฺถ คคเณ ไจว นีจเสฺถ ปฺฤถิวีตเลฯ โศณิตานิ พฺฤหทฺภานูนฺ ฆนธูมาทิกานิ จฯ จิหฺนานิ ทรฺศยิษฺยามิ มหาศฺจรฺยฺยกฺริยาสฺตถาฯ ");
INSERT INTO santha_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","มหาภยานกไสฺยว ตทฺทินสฺย ปเรศิตุ:ฯ ปุราคมาทฺ รวิ: กฺฤษฺโณ รกฺตศฺจนฺโทฺร ภวิษฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","กินฺตุ ย: ปรเมศสฺย นามฺนิ สมฺปฺรารฺถยิษฺยเตฯ เสอว มนุโช นูนํ ปริตฺราโต ภวิษฺยติ๚ ");
INSERT INTO santha_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","อโต เห อิสฺราเยลฺวํศียโลกา: สรฺเวฺว กถายาเมตสฺยามฺ มโน นิธทฺธฺวํ นาสรตีโย ยีศุรีศฺวรสฺย มโนนีต: ปุมานฺ เอตทฺ อีศฺวรสฺตตฺกฺฤไตราศฺจรฺยฺยาทฺภุตกรฺมฺมภิ รฺลกฺษไณศฺจ ยุษฺมากํ สากฺษาเทว ปฺรติปาทิตวานฺ อิติ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ตสฺมินฺ ยีเศา อีศฺวรสฺย ปูรฺวฺวนิศฺจิตมนฺตฺรณานิรูปณานุสาเรณ มฺฤเตฺยา สมรฺปิเต สติ ยูยํ ตํ ธฺฤตฺวา ทุษฺฏโลกานำ หไสฺต: กฺรุเศ วิธิตฺวาหตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","กินฺตฺวีศฺวรสฺตํ นิธนสฺย พนฺธนานฺโมจยิตฺวา อุทสฺถาปยตฺ ยต: ส มฺฤตฺยุนา พทฺธสฺติษฺฐตีติ น สมฺภวติฯ ");
INSERT INTO santha_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","เอตสฺตินฺ ทายูทปิ กถิตวานฺ ยถา, สรฺวฺวทา มม สากฺษาตฺตํ สฺถาปย ปรเมศฺวรํฯ สฺถิเต มทฺทกฺษิเณ ตสฺมินฺ สฺขลิษฺยามิ ตฺวหํ นหิฯ ");
INSERT INTO santha_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","อานนฺทิษฺยติ ตทฺเธโต รฺมามกีนํ มนสฺตุ ไวฯ อาหฺลาทิษฺยติ ชิหฺวาปิ มทียา ตุ ตไถว จฯ ปฺรตฺยาศยา ศรีรนฺตุ มทียํ ไวศยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ปรโลเก ยโต เหโตสฺตฺวํ มำ ไนว หิ ตฺยกฺษฺยสิฯ สฺวกียํ ปุณฺยวนฺตํ ตฺวํ กฺษยิตุํ ไนว ทาสฺยสิฯ เอวํ ชีวนมารฺคํ ตฺวํ มาเมว ทรฺศยิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","สฺวสมฺมุเข ย อานนฺโท ทกฺษิเณ สฺวสฺย ยตฺ สุขํฯ อนนฺตํ เตน มำ ปูรฺณํ กริษฺยสิ น สํศย:๚ ");
INSERT INTO santha_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","เห ภฺราตโร'สฺมากํ ตสฺย ปูรฺวฺวปุรุษสฺย ทายูท: กถำ สฺปษฺฏํ กถยิตุํ มามฺ อนุมนฺยธฺวํ, ส ปฺราณานฺ ตฺยกฺตฺวา ศฺมศาเน สฺถาปิโตภวทฺ อทฺยาปิ ตตฺ ศฺมศานมฺ อสฺมากํ สนฺนิเธา วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ผลโต เลากิกภาเวน ทายูโท วํเศ ขฺรีษฺฏํ ชนฺม คฺราหยิตฺวา ตไสฺยว สึหาสเน สมุเวษฺฏุํ ตมุตฺถาปยิษฺยติ ปรเมศฺวร: ศปถํ กุตฺวา ทายูท: สมีป อิมมฺ องฺคีการํ กฺฤตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","อิติ ชฺญาตฺวา ทายูทฺ ภวิษฺยทฺวาที สนฺ ภวิษฺยตฺกาลียชฺญาเนน ขฺรีษฺโฏตฺถาเน กถามิมำ กถยามาส ยถา ตสฺยาตฺมา ปรโลเก น ตฺยกฺษฺยเต ตสฺย ศรีรญฺจ น เกฺษษฺยติ; ");
INSERT INTO santha_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","อต: ปรเมศฺวร เอนํ ยีศุํ ศฺมศานาทฺ อุทสฺถาปยตฺ ตตฺร วยํ สรฺเวฺว สากฺษิณ อาสฺมเหฯ ");
INSERT INTO santha_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ส อีศฺวรสฺย ทกฺษิณกเรโณนฺนตึ ปฺราปฺย ปวิตฺร อาตฺมิน ปิตา ยมงฺคีการํ กฺฤตวานฺ ตสฺย ผลํ ปฺราปฺย ยตฺ ปศฺยถ ศฺฤณุถ จ ตทวรฺษตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ยโต ทายูทฺ สฺวรฺคํ นารุโรห กินฺตุ สฺวยมฺ อิมำ กถามฺ อกถยทฺ ยถา, มม ปฺรภุมิทํ วากฺยมวทตฺ ปรเมศฺวร:ฯ ");
INSERT INTO santha_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ตว ศตฺรูนหํ ยาวตฺ ปาทปีฐํ กโรมิ นฯ ตาวตฺ กาลํ มทีเย ตฺวํ ทกฺษวารฺศฺว อุปาวิศฯ ");
INSERT INTO santha_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","อโต ยํ ยีศุํ ยูยํ กฺรุเศ'หต ปรเมศฺวรสฺตํ ปฺรภุตฺวาภิษิกฺตตฺวปเท นฺยยุํกฺเตติ อิสฺราเยลียา โลกา นิศฺจิตํ ชานนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","เอตาทฺฤศีํ กถำ ศฺรุตฺวา เตษำ หฺฤทยานำ วิทีรฺณตฺวาตฺ เต ปิตราย ตทนฺยเปฺรริเตภฺยศฺจ กถิตวนฺต:, เห ภฺราตฺฤคณ วยํ กึ กริษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ตต: ปิตร: ปฺรตฺยวททฺ ยูยํ สรฺเวฺว สฺวํ สฺวํ มน: ปริวรฺตฺตยธฺวํ ตถา ปาปโมจนารฺถํ ยีศุขฺรีษฺฏสฺย นามฺนา มชฺชิตาศฺจ ภวต, ตสฺมาทฺ ทานรูปํ ปริตฺรมฺ อาตฺมานํ ลปฺสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ยโต ยุษฺมากํ ยุษฺมตฺสนฺตานานาญฺจ ทูรสฺถสรฺวฺวโลกานาญฺจ นิมิตฺตมฺ อรฺถาทฺ อสฺมากํ ปฺรภุ: ปรเมศฺวโร ยาวโต ลากานฺ อาหฺวาสฺยติ เตษำ สรฺเวฺวษำ นิมิตฺตมฺ อยมงฺคีการ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","เอตทนฺยาภิ รฺพหุกถาภิ: ปฺรมาณํ ทตฺวากถยตฺ เอเตโภฺย วิปถคามิโภฺย วรฺตฺตมานโลเกภฺย: สฺวานฺ รกฺษตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ตต: ปรํ เย สานนฺทาสฺตำ กถามฺ อคฺฤหฺลนฺ เต มชฺชิตา อภวนฺฯ ตสฺมินฺ ทิวเส ปฺราเยณ ตฺรีณิ สหสฺราณิ โลกาเสฺตษำ สปกฺษา: สนฺต: ");
INSERT INTO santha_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","เปฺรริตานามฺ อุปเทเศ สงฺคเตา ปูปภญฺชเน ปฺรารฺถนาสุ จ มน:สํโยคํ กฺฤตฺวาติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","เปฺรริไต รฺนานาปฺรการลกฺษเณษุ มหาศฺจรฺยฺยกรฺมมสุ จ ทรฺศิเตษุ สรฺวฺวโลกานำ ภยมุปสฺถิตํฯ ");
INSERT INTO santha_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","วิศฺวาสการิณ: สรฺวฺว จ สห ติษฺฐนต:ฯ เสฺวษำ สรฺวฺวา: สมฺปตฺตี: สาธารเณฺยน สฺถาปยิตฺวาภุญฺชตฯ ");
INSERT INTO santha_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ผลโต คฺฤหาณิ ทฺรวฺยาณิ จ สรฺวฺวาณิ วิกฺรีย สรฺเวฺวษำ สฺวสฺวปฺรโยชนานุสาเรณ วิภชฺย สรฺเวฺวโภฺย'ททนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","สรฺวฺว เอกจิตฺตีภูย ทิเน ทิเน มนฺทิเร สนฺติษฺฐมานา คฺฤเห คฺฤเห จ ปูปานภญฺชนฺต อีศฺวรสฺย ธนฺยวาทํ กุรฺวฺวนฺโต โลไก: สมาทฺฤตา: ปรมานนฺเทน สรลานฺต:กรเณน โภชนํ ปานญฺจกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ปรเมศฺวโร ทิเน ทิเน ปริตฺราณภาชไน รฺมณฺฑลีมฺ อวรฺทฺธยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ตฺฤตียยามเวลายำ สตฺยำ ปฺรารฺถนายา: สมเย ปิตรโยหเนา สมฺภูย มนฺทิรํ คจฺฉต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ตสฺมินฺเนว สมเย มนฺทิรปฺรเวศกานำ สมีเป ภิกฺษารณารฺถํ ยํ ชนฺมขญฺชมานุษํ โลกา มนฺทิรสฺย สุนฺทรนามฺนิ ทฺวาเร ปฺรติทินมฺ อสฺถาปยนฺ ตํ วหนฺตสฺตทฺวารํ อานยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ตทา ปิตรโยหเนา มนฺติรํ ปฺรเวษฺฏุมฺ อุทฺยเตา วิโลกฺย ส ขญฺชเสฺตา กิญฺจิทฺ ภิกฺษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ตสฺมาทฺ โยหนา สหิต: ปิตรสฺตมฺ อนนฺยทฺฤษฺฏฺยา นิรีกฺษฺย โปฺรกฺตวานฺ อาวำ ปฺรติ ทฺฤษฺฏึ กุรุฯ ");
INSERT INTO santha_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ตต: ส กิญฺจิตฺ ปฺราปฺตฺยาศยา เตา ปฺรติ ทฺฤษฺฏึ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ตทา ปิตโร คทิตวานฺ มม นิกเฏ สฺวรฺณรูปฺยาทิ กิมปิ นาสฺติ กินฺตุ ยทาเสฺต ตทฺ ททามิ นาสรตียสฺย ยีศุขฺรีษฺฏสฺย นามฺนา ตฺวมุตฺถาย คมนาคมเน กุรุฯ ");
INSERT INTO santha_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ตต: ปรํ ส ตสฺย ทกฺษิณกรํ ธฺฤตฺวา ตมฺ อุทโตลยตฺ; เตน ตตฺกฺษณาตฺ ตสฺย ชนสฺย ปาทคุลฺผโย: สพลตฺวาตฺ ส อุลฺลมฺผฺย โปฺรตฺถาย คมนาคมเน 'กโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ตโต คมนาคมเน กุรฺวฺวนฺ อุลฺลมฺผนฺ อีศฺวรํ ธนฺยํ วทนฺ ตาภฺยำ สารฺทฺธํ มนฺทิรํ ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ตต: สรฺเวฺว โลกาสฺตํ คมนาคมเน กุรฺวฺวนฺตมฺ อีศฺวรํ ธนฺยํ วทนฺตญฺจ วิโลกฺย ");
INSERT INTO santha_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","มนฺทิรสฺย สุนฺทเร ทฺวาเร ย อุปวิศฺย ภิกฺษิตวานฺ เสอวายมฺ อิติ ชฺญาตฺวา ตํ ปฺรติ ตยา ฆฏนยา จมตฺกฺฤตา วิสฺมยาปนฺนาศฺจาภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ย: ขญฺช: สฺวโสฺถภวตฺ เตน ปิตรโยหโน: กรโยรฺธฺฏตโย: สโต: สรฺเวฺว โลกา สนฺนิธิมฺ อาคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ตทฺ ทฺฤษฺฏฺวา ปิตรเสฺตโภฺย'กถยตฺ, เห อิสฺราเยลียโลกา ยูยํ กุโต 'เนนาศฺจรฺยฺยํ มนฺยเธฺว? อาวำ นิชศกฺตฺยา ยทฺวา นิชปุเณฺยน ขญฺชมนุษฺยเมนํ คมิตวนฺตาวิติ จินฺตยิตฺวา อาวำ ปฺรติ กุโต'นนฺยทฺฤษฺฏึ กุรุถ? ");
INSERT INTO santha_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ยํ ยีศุํ ยูยํ ปรกเรษุ สมารฺปยต ตโต ยํ ปีลาโต โมจยิตุมฺ เอैจฺฉตฺ ตถาปิ ยูยํ ตสฺย สากฺษานฺ นางฺคีกฺฤตวนฺต อิพฺราหีม อิสฺหาโก ยากูพศฺเจศฺวโร'รฺถาทฺ อสฺมากํ ปูรฺวฺวปุรุษาณามฺ อีศฺวร: สฺวปุตฺรสฺย ตสฺย ยีโศ รฺมหิมานํ ปฺรากาศยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","กินฺตุ ยูยํ ตํ ปวิตฺรํ ธารฺมฺมิกํ ปุมำสํ นางฺคีกฺฤตฺย หตฺยาการิณเมกํ เสฺวโภฺย ทาตุมฺ อยาจธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ปศฺจาตฺ ตํ ชีวนสฺยาธิปติมฺ อหต กินฺตฺวีศฺวร: ศฺมศานาตฺ ตมฺ อุทสฺถาปยต ตตฺร วยํ สากฺษิณ อาสฺมเหฯ ");
INSERT INTO santha_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","อิมํ ยํ มานุษํ ยูยํ ปศฺยถ ปริจินุถ จ ส ตสฺย นามฺนิ วิศฺวาสกรณาตฺ จลนศกฺตึ ลพฺธวานฺ ตสฺมินฺ ตสฺย โย วิศฺวาส: ส ตํ ยุษฺมากํ สรฺเวฺวษำ สากฺษาตฺ สมฺปูรฺณรูเปณ สฺวสฺถมฺ อการฺษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","เห ภฺราตโร ยูยํ ยุษฺมากมฺ อธิปตยศฺจ อชฺญาตฺวา กรฺมฺมาเณฺยตานิ กฺฤตวนฺต อิทานีํ มไมษ โพโธ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","กินฺตฺวีศฺวร: ขฺรีษฺฏสฺย ทุ:ขโภเค ภวิษฺยทฺวาทินำ มุเขโภฺย ยำ ยำ กถำ ปูรฺวฺวมกถยตฺ ตา: กถา อิตฺถํ สิทฺธา อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","อต: เสฺวษำ ปาปโมจนารฺถํ เขทํ กฺฤตฺวา มนำสิ ปริวรฺตฺตยธฺวํ, ตสฺมาทฺ อีศฺวราตฺ สานฺตฺวนาปฺราปฺเต: สมย อุปสฺถาสฺยติ; ");
INSERT INTO santha_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ปุนศฺจ ปูรฺวฺวกาลมฺ อารภฺย ปฺรจาริโต โย ยีศุขฺรีษฺฏสฺตมฺ อีศฺวโร ยุษฺมานฺ ปฺรติ เปฺรษยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","กินฺตุ ชคต: สฺฤษฺฏิมารภฺย อีศฺวโร นิชปวิตฺรภวิษฺยทฺวาทิคโณน ยถา กถิตวานฺ ตทนุสาเรณ สรฺเวฺวษำ การฺยฺยาณำ สิทฺธิปรฺยฺยนฺตํ เตน สฺวรฺเค วาส: กรฺตฺตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ยุษฺมากํ ปฺรภุ: ปรเมศฺวโร ยุษฺมากํ ภฺราตฺฤคณมธฺยาตฺ มตฺสทฺฤศํ ภวิษฺยทฺวกฺตารมฺ อุตฺปาทยิษฺยติ, ตต: ส ยตฺ กิญฺจิตฺ กถยิษฺยติ ตตฺร ยูยํ มนำสิ นิธทฺธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","กินฺตุ ย: กศฺจิตฺ ปฺราณี ตสฺย ภวิษฺยทฺวาทิน: กถำ น คฺรหีษฺยติ ส นิชโลกานำ มธฺยาทฺ อุจฺเฉตฺสฺยเต,\" อิมำ กถามฺ อสฺมากํ ปูรฺวฺวปุรุเษภฺย: เกวโล มูสา: กถยามาส อิติ นหิ, ");
INSERT INTO santha_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ศิมูเยลฺภวิษฺยทฺวาทินมฺ อารภฺย ยาวนฺโต ภวิษฺยทฺวากฺยมฺ อกถยนฺ เต สรฺวฺเวอว สมยไสฺยตสฺย กถามฺ อกถยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ยูยมปิ เตษำ ภวิษฺยทฺวาทินำ สนฺตานา:, \"ตว วํโศทฺภวปุํสา สรฺวฺวเทศียา โลกา อาศิษํ ปฺราปฺตา ภวิษฺยนฺติ\", อิพฺราหีเม กถาเมตำ กถยิตฺวา อีศฺวโรสฺมากํ ปูรฺวฺวปุรุไษ: สารฺทฺธํ ยํ นิยมํ สฺถิรีกฺฤตวานฺ ตสฺย นิยมสฺยาธิการิโณปิ ยูยํ ภวถฯ ");
INSERT INTO santha_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","อต อีศฺวโร นิชปุตฺรํ ยีศุมฺ อุตฺถาปฺย ยุษฺมากํ สรฺเวฺวษำ สฺวสฺวปาปาตฺ ปราวรฺตฺตฺย ยุษฺมภฺยมฺ อาศิษํ ทาตุํ ปฺรถมตสฺตํ ยุษฺมากํ นิกฏํ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ยสฺมินฺ สมเย ปิตรโยหเนา โลกานฺ อุปทิศตสฺตสฺมินฺ สมเย ยาชกา มนฺทิรสฺย เสนาปตย: สิทูกีคณศฺจ ");
INSERT INTO santha_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ตโยรฺ อุปเทศกรเณ ขฺรีษฺฏโสฺยตฺถานมฺ อุปลกฺษฺย สรฺเวฺวษำ มฺฤตานามฺ อุตฺถานปฺรสฺตาเว จ วฺยคฺรา: สนฺตสฺตาวุปาคมนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","เตา ธฺฤตฺวา ทินาวสานการณาตฺ ปรทินปรฺยฺยนนฺตํ รุทฺธฺวา สฺถาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ตถาปิ เย โลกาสฺตโยรุปเทศมฺ อศฺฤณฺวนฺ เตษำ ปฺราเยณ ปญฺจสหสฺราณิ ชนา วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ปเร'หนิ อธิปตย: ปฺราจีนา อธฺยาปกาศฺจ หานนนามา มหายาชก: ");
INSERT INTO santha_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","กิยผา โยหนฺ สิกนฺทร อิตฺยาทโย มหายาชกสฺย ชฺญาตย: สรฺเวฺว ยิรูศาลมฺนคเร มิลิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","อนนฺตรํ เปฺรริเตา มเธฺย สฺถาปยิตฺวาปฺฤจฺฉนฺ ยุวำ กยา ศกฺตยา วา เกน นามฺนา กรฺมฺมาเณฺยตานิ กุรุถ:? ");
INSERT INTO santha_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ตทา ปิตร: ปวิเตฺรณาตฺมนา ปริปูรฺณ: สนฺ ปฺรตฺยวาทีตฺ, เห โลกานามฺ อธิปติคณ เห อิสฺราเยลียปฺราจีนา:, ");
INSERT INTO santha_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","เอตสฺย ทุรฺพฺพลมานุษสฺย หิตํ ยตฺ กรฺมฺมากฺริยต, อรฺถาตฺ, ส เยน ปฺรกาเรณ สฺวโสฺถภวตฺ ตจฺเจทฺ อทฺยาวำ ปฺฤจฺฉถ, ");
INSERT INTO santha_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ตรฺหิ สรฺวฺว อิสฺราเยेลียโลกา ยูยํ ชานีต นาสรตีโย โย ยีศุขฺรีษฺฏ: กฺรุเศ ยุษฺมาภิรวิธฺยต ยศฺเจศฺวเรณ ศฺมศานาทฺ อุตฺถาปิต:, ตสฺย นามฺนา ชโนยํ สฺวสฺถ: สนฺ ยุษฺมากํ สมฺมุเข โปฺรตฺติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","นิเจตฺฤภิ รฺยุษฺมาภิรยํ ย: ปฺรสฺตโร'วชฺญาโต'ภวตฺ ส ปฺรธานโกณสฺย ปฺรสฺตโร'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ตทฺภินฺนาทปราตฺ กสฺมาทปิ ปริตฺราณํ ภวิตุํ น ศกฺโนติ, เยน ตฺราณํ ปฺราเปฺยต ภูมณฺฑลสฺยโลกานำ มเธฺย ตาทฺฤศํ กิมปิ นาม นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ตทา ปิตรโยหโนเรตาทฺฤศีมฺ อกฺเษภตำ ทฺฤษฺฏฺวา ตาววิทฺวำเสา นีจโลกาวิติ พุทฺธฺวา อาศฺจรฺยฺยมฺ อมนฺยนฺต เตา จ ยีโศ: สงฺคิเนา ชาตาวิติ ชฺญาตุมฺ อศกฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","กินฺตุ ตาภฺยำ สารฺทฺธํ ตํ สฺวสฺถมานุษํ ติษฺฐนฺตํ ทฺฤษฺฏฺวา เต กามปฺยปรามฺ อาปตฺตึ กรฺตฺตํ นาศกฺนุนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ตทา เต สภาต: สฺถานานฺตรํ คนฺตุํ ตานฺ อาชฺญาปฺย สฺวยํ ปรสฺปรมฺ อิติ มนฺตฺรณามกุรฺวฺวนฺ ");
INSERT INTO santha_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","เตา มานเวา ปฺรติ กึ กรฺตฺตวฺยํ? ตาเวกํ ปฺรสิทฺธมฺ อาศฺจรฺยฺยํ กรฺมฺม กฺฤตวนฺเตา ตทฺ ยิรูศาลมฺนิวาสินำ สรฺเวฺวษำ โลกานำ สมีเป ปฺรากาศต ตจฺจ วยมปโหฺนตุํ น ศกฺนุม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","กินฺตุ โลกานำ มธฺยมฺ เอตทฺ ยถา น วฺยาปฺโนติ ตทรฺถํ เตา ภยํ ปฺรทรฺศฺย เตน นามฺนา กมปิ มนุษฺยํ โนปทิศตมฺ อิติ ทฺฤฒํ นิเษธาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ตตเสฺต เปฺรริตาวาหูย เอตทาชฺญาปยนฺ อิต: ปรํ ยีโศ รฺนามฺนา กทาปิ กามปิ กถำ มา กถยตํ กิมปิ โนปทิศญฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ตต: ปิตรโยหเนา ปฺรตฺยวทตามฺ อีศฺวรสฺยาชฺญาคฺรหณํ วา ยุษฺมากมฺ อาชฺญาคฺรหณมฺ เอตโย รฺมเธฺย อีศฺวรสฺย โคจเร กึ วิหิตํ? ยูยํ ตสฺย วิเวจนำ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","วยํ ยทฺ อปศฺยาม ยทศฺฤณุม จ ตนฺน ปฺรจารยิษฺยาม เอตตฺ กทาปิ ภวิตุํ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ยทฆฏต ตทฺ ทฺฤษฺฏา สรฺเวฺว โลกา อีศฺวรสฺย คุณานฺ อนฺววทนฺ ตสฺมาตฺ โลกภยาตฺ เตา ทณฺฑยิตุํ กมปฺยุปายํ น ปฺราปฺย เต ปุนรปิ ตรฺชยิตฺวา ตาวตฺยชนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ยสฺย มานุษไสฺยตตฺ สฺวาสฺถฺยกรณมฺ อาศฺจรฺยฺยํ กรฺมฺมากฺริยต ตสฺย วยศฺจตฺวารึศทฺวตฺสรา วฺยตีตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ตต: ปรํ เตา วิสฺฤษฺเฏา สนฺเตา สฺวสงฺคินำ สนฺนิธึ คตฺวา ปฺรธานยาชไก: ปฺราจีนโลไกศฺจ โปฺรกฺตา: สรฺวฺวา: กถา ชฺญาปิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ตจฺฉฺรุตฺวา สรฺวฺว เอกจิตฺตีภูย อีศฺวรมุทฺทิศฺย โปฺรจฺไจเรตตฺ ปฺรารฺถยนฺต, เห ปฺรโภ คคณปฺฤถิวีปโยธีนำ เตษุ จ ยทฺยทฺ อาเสฺต เตษำ สฺรษฺเฏศฺวรสฺตฺวํฯ ");
INSERT INTO santha_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ตฺวํ นิชเสวเกน ทายูทา วากฺยมิทมฺ อุวจิถ, มนุษฺยา อนฺยเทศียา: กุรฺวฺวนฺติ กลหํ กุต:ฯ โลกา: สรฺเวฺว กิมรฺถํ วา จินฺตำ กุรฺวฺวนฺติ นิษฺผลำฯ ");
INSERT INTO santha_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ปรเมศสฺย เตไนวาภิษิกฺตสฺย ชนสฺย จฯ วิรุทฺธมภิติษฺฐนฺติ ปฺฤถิวฺยา: ปตย: กุต:๚ ");
INSERT INTO santha_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ผลตสฺตว หเสฺตน มนฺตฺรณยา จ ปูรฺวฺว ยทฺยตฺ สฺถิรีกฺฤตํ ตทฺ ยถา สิทฺธํ ภวติ ตทรฺถํ ตฺวํ ยมฺ อถิษิกฺตวานฺ ส เอว ปวิโตฺร ยีศุสฺตสฺย ปฺราติกูเลฺยน เหโรทฺ ปนฺตียปีลาโต ");
INSERT INTO santha_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'นฺยเทศียโลกา อิสฺราเยโลฺลกาศฺจ สรฺวฺว เอเต สภายามฺ อติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","เห ปรเมศฺวร อธุนา เตษำ ตรฺชนํ ครฺชนญฺจ ศฺฤณุ; ");
INSERT INTO santha_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ตถา สฺวาสฺถฺยกรณกรฺมฺมณา ตว พาหุพลปฺรกาศปูรฺวฺวกํ ตว เสวกานฺ นิรฺภเยน ตว วากฺยํ ปฺรจารยิตุํ ตว ปวิตฺรปุตฺรสฺย ยีโศ รฺนามฺนา อาศฺจรฺยฺยาณฺยสมฺภวานิ จ กรฺมฺมาณิ กรฺตฺตุญฺจาชฺญาปยฯ ");
INSERT INTO santha_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","อิตฺถํ ปฺรารฺถนยา ยตฺร สฺถาเน เต สภายามฺ อาสนฺ ตตฺ สฺถานํ ปฺรากมฺปต; ตต: สรฺเวฺว ปวิเตฺรณาตฺมนา ปริปูรฺณา: สนฺต อีศฺวรสฺย กถามฺ อกฺโษเภณ ปฺราจารยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","อปรญฺจ ปฺรตฺยยการิโลกสมูหา เอกมนส เอกจิตฺตีภูย สฺถิตา:ฯ เตษำ เกปิ นิชสมฺปตฺตึ สฺวียำ นาชานนฺ กินฺตุ เตษำ สรฺวฺวา: สมฺปตฺตฺย: สาธารเณฺยน สฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","อนฺยจฺจ เปฺรริตา มหาศกฺติปฺรกาศปูรฺวฺวกํ ปฺรโภ รฺยีโศรุตฺถาเน สากฺษฺยมฺ อททุ:, เตษุ สรฺเวฺวษุ มหานุคฺรโห'ภวจฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","เตษำ มเธฺย กสฺยาปิ ทฺรวฺยนฺยูนตา นาภวทฺ ยตเสฺตษำ คฺฤหภูมฺยาทฺยา ยา: สมฺปตฺตย อาสนฺ ตา วิกฺรีย ");
INSERT INTO santha_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ตนฺมูลฺยมานีย เปฺรริตานำ จรเณษุ ไต: สฺถาปิตํ; ตต: ปฺรเตฺยกศ: ปฺรโยชนานุสาเรณ ทตฺตมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","วิเศษต: กุโปฺรปทฺวีปีโย โยสินามโก เลวิวํศชาต เอโก ชโน ภูมฺยธิการี, ยํ เปฺรริตา พรฺณพฺพา อรฺถาตฺ สานฺตฺวนาทายก อิตฺยุกฺตฺวา สมาหูยนฺ, ");
INSERT INTO santha_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ส ชโน นิชภูมึ วิกฺรีย ตนฺมูลฺยมานีย เปฺรริตานำ จรเณษุ สฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ตทา อนานิยนามก เอโก ชโน ยสฺย ภารฺยฺยายา นาม สผีรา ส สฺวาธิการํ วิกฺรีย ");
INSERT INTO santha_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","สฺวภารฺยฺยำ ชฺญาปยิตฺวา ตนฺมูลฺยไสฺยกำศํ สงฺโคปฺย สฺถาปยิตฺวา ตทนฺยำศมาตฺรมานีย เปฺรริตานำ จรเณษุ สมรฺปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ตสฺมาตฺ ปิตโรกถยตฺ เห อนานิย ภูเม รฺมูลฺยํ กิญฺจิตฺ สงฺโคปฺย สฺถาปยิตุํ ปวิตฺรสฺยาตฺมน: สนฺนิเธา มฺฤษาวากฺยํ กถยิตุญฺจ ไศตานฺ กุตสฺตวานฺต:กรเณ ปฺรวฺฤตฺติมชนยตฺ? ");
INSERT INTO santha_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","สา ภูมิ รฺยทา ตว หสฺตคตา ตทา กึ ตว สฺวียา นาสีตฺ? ตรฺหิ สฺวานฺต:กรเณ กุต เอตาทฺฤศี กุกลฺปนา ตฺวยา กฺฤตา? ตฺวํ เกวลมนุษฺยสฺย นิกเฏ มฺฤษาวากฺยํ นาวาที: กินฺตฺวีศฺวรสฺย นิกเฏ'ปิฯ ");
INSERT INTO santha_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","เอตำ กถำ ศฺรุไตฺวว โส'นานิโย ภูเมา ปตนฺ ปฺราณานฺ อตฺยชตฺ, ตทฺวฺฤตฺตานฺตํ ยาวนฺโต โลกา อศฺฤณฺวนฺ เตษำ สรฺเวฺวษำ มหาภยมฺ อชายตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ตทา ยุวโลกาสฺตํ วสฺเตฺรณาจฺฉาทฺย พหิ รฺนีตฺวา ศฺมศาเน'สฺถาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ตต: ปฺรหไรกานนฺตรํ กึ วฺฤตฺตํ ตนฺนาวคตฺย ตสฺย ภารฺยฺยาปิ ตตฺร สมุปสฺถิตาฯ ");
INSERT INTO santha_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ตต: ปิตรสฺตามฺ อปฺฤจฺฉตฺ, ยุวาภฺยามฺ เอตาวนฺมุทฺราโภฺย ภูมิ รฺวิกฺรีตา น วา? เอตตฺวํ วท; ตทา สา ปฺรตฺยวาทีตฺ สตฺยมฺ เอตาวทฺโภฺย มุทฺราภฺย เอวฯ ");
INSERT INTO santha_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ตต: ปิตโรกถยตฺ ยุวำ กถํ ปรเมศฺวรสฺยาตฺมานํ ปรีกฺษิตุมฺ เอกมนฺตฺรณาวภวตำ? ปศฺย เย ตว ปตึ ศฺมศาเน สฺถาปิตวนฺตเสฺต ทฺวารสฺย สมีเป สมุปติษฺฐนฺติ ตฺวามปิ พหิรฺเนษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ตต: สาปิ ตสฺย จรณสนฺนิเธา ปติตฺวา ปฺราณานฺ อตฺยากฺษีตฺฯ ปศฺจาตฺ เต ยุวาโน'ภฺยนฺตรมฺ อาคตฺย ตามปิ มฺฤตำ ทฺฤษฺฏฺวา พหิ รฺนีตฺวา ตสฺยา: ปตฺยุ: ปารฺเศฺว ศฺมศาเน สฺถาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ตสฺมาตฺ มณฺฑลฺยา: สรฺเวฺว โลกา อนฺยโลกาศฺจ ตำ วารฺตฺตำ ศฺรุตฺวา สาธฺวสํ คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ตต: ปรํ เปฺรริตานำ หไสฺต โรฺลกานำ มเธฺย พหฺวาศฺจรฺยฺยาณฺยทฺภุตานิ กรฺมฺมาณฺยกฺริยนฺต; ตทา ศิษฺยา: สรฺวฺว เอกจิตฺตีภูย สุเลมาโน 'ลินฺเท สมฺภูยาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","เตษำ สงฺฆานฺตรฺโค ภวิตุํ โกปิ ปฺรคลฺภตำ นาคมตฺ กินฺตุ โลกาสฺตานฺ สมาทฺริยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","สฺตฺริย: ปุรุษาศฺจ พหโว โลกา วิศฺวาสฺย ปฺรภุํ ศรณมาปนฺนา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ปิตรสฺย คมนาคมนาภฺยำ เกนาปิ ปฺรกาเรณ ตสฺย ฉายา กสฺมึศฺจิชฺชเน ลคิษฺยตีตฺยาศยา โลกา โรคิณ: ศิวิกยา ขฏฺวยา จานีย ปถิ ปถิ สฺถาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","จตุรฺทิกฺสฺถนคเรโภฺย พหโว โลกา: สมฺภูย โรคิโณ'ปวิตฺรภุตคฺรสฺตำศฺจ ยิรูศาลมมฺ อานยนฺ ตต: สรฺเวฺว สฺวสฺถา อกฺริยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","อนนฺตรํ มหายาชก: สิทูกินำ มตคฺราหิณเสฺตษำ สหจราศฺจ ");
INSERT INTO santha_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","มหาโกฺรธานฺตฺวิตา: สนฺต: เปฺรริตานฺ ธฺฤตฺวา นีจโลกานำ การายำ พทฺธฺวา สฺถาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","กินฺตุ ราเตฺรา ปรเมศฺวรสฺย ทูต: การายา ทฺวารํ โมจยิตฺวา ตานฺ พหิรานียากถยตฺ, ");
INSERT INTO santha_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ยูยํ คตฺวา มนฺทิเร ทณฺฑายมานา: สนฺโต โลกานฺ ปฺรตีมำ ชีวนทายิกำ สรฺวฺวำ กถำ ปฺรจารยตฯ ");
INSERT INTO santha_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","อิติ ศฺรุตฺวา เต ปฺรตฺยูเษ มนฺทิร อุปสฺถาย อุปทิษฺฏวนฺต:ฯ ตทา สหจรคเณน สหิโต มหายาชก อาคตฺย มนฺตฺริคณมฺ อิสฺราเยลฺวํศสฺย สรฺวฺวานฺ ราชสภาสท: สภาสฺถานฺ กฺฤตฺวา การายาสฺตานฺ อาปยิตุํ ปทาติคณํ เปฺรริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ตตเสฺต คตฺวา การายำ ตานฺ อปฺราปฺย ปฺรตฺยาคตฺย อิติ วารฺตฺตามฺ อวาทิษุ:, ");
INSERT INTO santha_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","วยํ ตตฺร คตฺวา นิรฺวฺวิฆฺนํ การายา ทฺวารํ รุทฺธํ รกฺษกำศฺจ ทฺวารสฺย พหิรฺทณฺฑายมานานฺ อทรฺศาม เอว กินฺตุ ทฺวารํ โมจยิตฺวา ตนฺมเธฺย กมปิ ทฺรษฺฏุํ น ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","เอตำ กถำ ศฺรุตฺวา มหายาชโก มนฺทิรสฺย เสนาปติ: ปฺรธานยาชกาศฺจ, อิต ปรํ กิมปรํ ภวิษฺยตีติ จินฺตยิตฺวา สนฺทิคฺธจิตฺตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","เอตสฺมินฺเนว สมเย กศฺจิตฺ ชน อาคตฺย วารฺตฺตาเมตามฺ อวทตฺ ปศฺยต ยูยํ ยานฺ มานวานฺ การายามฺ อสฺถาปยต เต มนฺทิเร ติษฺฐนฺโต โลกานฺ อุปทิศนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ตทา มนฺทิรสฺย เสนาปติ: ปทาตยศฺจ ตตฺร คตฺวา เจโลฺลกา: ปาษาณานฺ นิกฺษิปฺยาสฺมานฺ มารยนฺตีติ ภิยา วินตฺยาจารํ ตานฺ อานยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","เต มหาสภายา มเธฺย ตานฺ อสฺถาปยนฺ ตต: ปรํ มหายาชกสฺตานฺ อปฺฤจฺฉตฺ, ");
INSERT INTO santha_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","อเนน นามฺนา สมุปเทษฺฏุํ วยํ กึ ทฺฤฒํ น นฺยเษธาม? ตถาปิ ปศฺยต ยูยํ เสฺวษำ เตโนปเทเศเน ยิรูศาลมํ ปริปูรฺณํ กฺฤตฺวา ตสฺย ชนสฺย รกฺตปาตชนิตาปราธมฺ อสฺมานฺ ปฺรตฺยาเนตุํ เจษฺฏเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ตต: ปิตโรนฺยเปฺรริตาศฺจ ปฺรตฺยวทนฺ มานุษสฺยาชฺญาคฺรหณาทฺ อีศฺวรสฺยาชฺญาคฺรหณมฺ อสฺมากมุจิตมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ยํ ยีศุํ ยูยํ กฺรุเศ เวธิตฺวาหต ตมฺ อสฺมากํ ไปตฺฤก อีศฺวร อุตฺถาปฺย ");
INSERT INTO santha_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","อิสฺราเยลฺวํศานำ มน:ปริวรฺตฺตนํ ปาปกฺษมาญฺจ กรฺตฺตุํ ราชานํ ปริตฺราตารญฺจ กฺฤตฺวา สฺวทกฺษิณปารฺเศฺว ตสฺยานฺนติมฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","เอตสฺมินฺ วยมปิ สากฺษิณ อาสฺมเห, ตตฺ เกวลํ นหิ, อีศฺวร อาชฺญาคฺราหิโภฺย ยํ ปวิตฺรมฺ อาตฺมนํ ทตฺตวานฺ โสปิ สากฺษฺยสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","เอตทฺวาเกฺย ศฺรุเต เตษำ หฺฤทยานิ วิทฺธานฺยภวนฺ ตตเสฺต ตานฺ หนฺตุํ มนฺตฺริตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","เอตสฺมินฺเนว สมเย ตตฺสภาสฺถานำ สรฺวฺวโลกานำ มเธฺย สุขฺยาโต คมิลีเยลฺนามก เอโก ชโน วฺยวสฺถาปก: ผิรูศิโลก อุตฺถาย เปฺรริตานฺ กฺษณารฺถํ สฺถานานฺตรํ คนฺตุมฺ อาทิศฺย กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","เห อิสฺราเยลฺวํศียา: สรฺเวฺว ยูยมฺ เอตานฺ มานุษานฺ ปฺรติ ยตฺ กรฺตฺตุมฺ อุทฺยตาสฺตสฺมินฺ สาวธานา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","อิต: ปูรฺวฺวํ ถูทานาไมโก ชน อุปสฺถาย สฺวํ กมปิ มหาปุรุษมฺ อวทตฺ, ตต: ปฺราเยณ จตุ:ศตโลกาสฺตสฺย มตคฺราหิโณภวนฺ ปศฺจาตฺ ส หโตภวตฺ ตสฺยาชฺญาคฺราหิโณ ยาวนฺโต โลกาเสฺต สรฺเวฺว วิรฺกีรฺณา: สนฺโต 'กฺฤตการฺยฺยา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ตสฺมาชฺชนาตฺ ปรํ นามเลขนสมเย คาลีลียยิหูทานาไมโก ชน อุปสฺถาย พหูโลฺลกานฺ สฺวมตํ คฺราหีตวานฺ ตต: โสปิ วฺยนศฺยตฺ ตสฺยาชฺญาคฺราหิโณ ยาวนฺโต โลกา อาสนฺ เต สรฺเวฺว วิกีรฺณา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","อธุนา วทามิ, ยูยมฺ เอตานฺ มนุษฺยานฺ ปฺรติ กิมปิ น กฺฤตฺวา กฺษานฺตา ภวต, ยต เอษ สงฺกลฺป เอตตฺ กรฺมฺม จ ยทิ มนุษฺยาทภวตฺ ตรฺหิ วิผลํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ยทีศฺวราทภวตฺ ตรฺหิ ยูยํ ตสฺยานฺยถา กรฺตฺตุํ น ศกฺษฺยถ, วรมฺ อีศฺวรโรธกา ภวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ตทา ตสฺย มนฺตฺรณำ สฺวีกฺฤตฺย เต เปฺรริตานฺ อาหูย ปฺรหฺฤตฺย ยีโศ รฺนามฺนา กามปิ กถำ กถยิตุํ นิษิธฺย วฺยสรฺชนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","กินฺตุ ตสฺย นามารฺถํ วยํ ลชฺชาโภคสฺย โยคฺยเตฺวน คณิตา อิตฺยตฺร เต สานนฺทา: สนฺต: สภาสฺถานำ สากฺษาทฺ อคจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ตต: ปรํ ปฺรติทินํ มนฺทิเร คฺฤเห คฺฤเห จาวิศฺรามมฺ อุปทิศฺย ยีศุขฺรีษฺฏสฺย สุสํวาทํ ปฺรจาริตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ตสฺมินฺ สมเย ศิษฺยาณำ พาหุลฺยาตฺ ปฺราตฺยหิกทานสฺย วิศฺราณไน รฺภินฺนเทศียานำ วิธวาสฺตฺรีคณ อุเปกฺษิเต สติ อิพฺรียโลไก: สหานฺยเทศียานำ วิวาท อุปาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ตทา ทฺวาทศเปฺรริตา: สรฺวฺวานฺ ศิษฺยานฺ สํคฺฤหฺยากถยนฺ อีศฺวรสฺย กถาปฺรจารํ ปริตฺยชฺย โภชนคเวษณมฺ อสฺมากมฺ อุจิตํ นหิฯ ");
INSERT INTO santha_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","อโต เห ภฺราตฺฤคณ วยมฺ เอตตฺกรฺมฺมโณ ภารํ เยโภฺย ทาตุํ ศกฺนุม เอตาทฺฤศานฺ สุขฺยาตฺยาปนฺนานฺ ปวิเตฺรณาตฺมนา ชฺญาเนน จ ปูรฺณานฺ สปฺปฺรชนานฺ ยูยํ เสฺวษำ มเธฺย มโนนีตานฺ กุรุต, ");
INSERT INTO santha_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","กินฺตุ วยํ ปฺรารฺถนายำ กถาปฺรจารกรฺมฺมณิ จ นิตฺยปฺรวฺฤตฺตา: สฺถาสฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","เอตสฺยำ กถายำ สรฺเวฺว โลกา: สนฺตุษฺฏา: สนฺต: เสฺวษำ มธฺยาตฺ สฺติผาน: ผิลิป: ปฺรขโร นิกาโนรฺ ตีมนฺ ปรฺมฺมิณา ยิหูทิมตคฺราหี-อานฺติยขิยานครีโย นิกลา เอตานฺ ปรมภกฺตานฺ ปวิเตฺรณาตฺมนา ปริปูรฺณานฺ สปฺต ชนานฺ ");
INSERT INTO santha_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","เปฺรริตานำ สมกฺษมฺ อานยนฺ, ตตเสฺต ปฺรารฺถนำ กฺฤตฺวา เตษำ ศิร:สุ หสฺตานฺ อารฺปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","อปรญฺจ อีศฺวรสฺย กถา เทศํ วฺยาปฺโนตฺ วิเศษโต ยิรูศาลมิ นคเร ศิษฺยาณำ สํขฺยา ปฺรภูตรูเปณาวรฺทฺธต ยาชกานำ มเธฺยปิ พหว: ขฺรีษฺฏมตคฺราหิโณ'ภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","สฺติผาโนे วิศฺวาเสน ปรากฺรเมณ จ ปริปูรฺณ: สนฺ โลกานำ มเธฺย พหุวิธมฺ อทฺภุตมฺ อาศฺจรฺยฺยํ กรฺมฺมากโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","เตน ลิพรฺตฺตินียนามฺนา วิขฺยาตสงฺฆสฺย กติปยชนา: กุรีณียสิกนฺทรีย-กิลิกียาศียาเทศียา: กิยนฺโต ชนาศฺโจตฺถาย สฺติผาเนน สารฺทฺธํ วฺยวทนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","กินฺตุ สฺติผาโน ชฺญาเนน ปวิเตฺรณาตฺมนา จ อีทฺฤศีํ กถำ กถิตวานฺ ยสฺยาเสฺต อาปตฺตึ กรฺตฺตุํ นาศกฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ปศฺจาตฺ ไต โรฺลภิตา: กติปยชนา: กถาเมนามฺ อกถยนฺ, วยํ ตสฺย มุขโต มูสา อีศฺวรสฺย จ นินฺทาวากฺยมฺ อเศฺราษฺมฯ ");
INSERT INTO santha_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","เต โลกานำ โลกปฺราจีนานามฺ อธฺยาปกานาญฺจ ปฺรวฺฤตฺตึ ชนยิตฺวา สฺติผานสฺย สนฺนิธิมฺ อาคตฺย ตํ ธฺฤตฺวา มหาสภามธฺยมฺ อานยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ตทนนฺตรํ กติปยชเนษุ มิถฺยาสากฺษิษุ สมานีเตษุ เต'กถยนฺ เอษ ชน เอตตฺปุณฺยสฺถานวฺยวสฺถโย รฺนินฺทาต: กทาปิ น นิวรฺตฺตเตฯ ");
INSERT INTO santha_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ผลโต นาสรตียยีศุ: สฺถานเมตทฺ อุจฺฉินฺนํ กริษฺยติ มูสาสมรฺปิตมฺ อสฺมากํ วฺยวหรณมฺ อนฺยรูปํ กริษฺยติ ตไสฺยตาทฺฤศีํ กถำ วยมฺ อศฺฤณุมฯ ");
INSERT INTO santha_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ตทา มหาสภาสฺถา: สรฺเวฺว ตํ ปฺรติ สฺถิรำ ทฺฤษฺฏึ กฺฤตฺวา สฺวรฺคทูตมุขสทฺฤศํ ตสฺย มุขมฺ อปศฺยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ตต: ปรํ มหายาชก: ปฺฤษฺฏวานฺ, เอษา กถำ กึ สตฺยา? ");
INSERT INTO santha_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ตต: ส ปฺรตฺยวทตฺ, เห ปิตโร เห ภฺราตร: สรฺเวฺว ลากา มนำสิ นิธทฺธฺวํฯ อสฺมากํ ปูรฺวฺวปุรุษ อิพฺราหีมฺ หารณฺนคเร วาสกรณาตฺ ปูรฺวฺวํ ยทา อรามฺ-นหรยิมเทเศ อาสีตฺ ตทา เตโชมย อีศฺวโร ทรฺศนํ ทตฺวา ");
INSERT INTO santha_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ตมวทตฺ ตฺวํ สฺวเทศชฺญาติมิตฺราณิ ปริตฺยชฺย ยํ เทศมหํ ทรฺศยิษฺยามิ ตํ เทศํ วฺรชฯ ");
INSERT INTO santha_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","อต: ส กสฺทียเทศํ วิหาย หารณฺนคเร นฺยวสตฺ, ตทนนฺตรํ ตสฺย ปิตริ มฺฤเต ยตฺร เทเศ ยูยํ นิวสถ ส เอนํ เทศมาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","กินฺตฺวีศฺวรสฺตไสฺม กมปฺยธิการมฺ อรฺถาทฺ เอกปทปริมิตำ ภูมิมปิ นาททาตฺ; ตทา ตสฺย โกปิ สนฺตาโน นาสีตฺ ตถาปิ สนฺตาไน: สารฺทฺธมฺ เอตสฺย เทศสฺยาธิการี ตฺวํ ภวิษฺยสีติ ตมฺปฺรตฺยงฺคีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","อีศฺวร อิตฺถมฺ อปรมปิ กถิตวานฺ ตว สนฺตานา: ปรเทเศ นิวตฺสฺยนฺติ ตตสฺตทฺเทศียโลกาศฺจตุ:ศตวตฺสรานฺ ยาวตฺ ตานฺ ทาสเตฺว สฺถาปยิตฺวา ตานฺ ปฺรติ กุวฺยวหารํ กริษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","อปรมฺ อีศฺวร เอนำ กถามปิ กถิตวานฺ, เย โลกาสฺตานฺ ทาสเตฺว สฺถาปยิษฺยนฺติ ตาโลฺลกานฺ อหํ ทณฺฑยิษฺยามิ, ตต: ปรํ เต พหิรฺคตา: สนฺโต มามฺ อตฺร สฺถาเน เสวิษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ปศฺจาตฺ ส ตไสฺม ตฺวกฺเฉทสฺย นิยมํ ทตฺตวานฺ, อต อิสฺหากนามฺนิ อิพฺราหีม เอกปุเตฺร ชาเต, อษฺฏมทิเน ตสฺย ตฺวกฺเฉทมฺ อกโรตฺฯ ตสฺย อิสฺหาก: ปุโตฺร ยากูพฺ, ตตสฺตสฺย ยากูโพ'สฺมากํ ทฺวาทศ ปูรฺวฺวปุรุษา อชายนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","เต ปูรฺวฺวปุรุษา อีรฺษฺยยา ปริปูรฺณา มิสรเทศํ เปฺรษยิตุํ ยูษผํ วฺยกฺรีณนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","กินฺตฺวีศฺวรสฺตสฺย สหาโย ภูตฺวา สรฺวฺวสฺยา ทุรฺคเต รกฺษิตฺวา ตไสฺม พุทฺธึ ทตฺตฺวา มิสรเทศสฺย ราชฺญ: ผิเราณ: ปฺริยปาตฺรํ กฺฤตวานฺ ตโต ราชา มิสรเทศสฺย สฺวียสรฺวฺวปริวารสฺย จ ศาสนปทํ ตไสฺม ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ตสฺมินฺ สมเย มิสร-กินานเทศโย รฺทุรฺภิกฺษเหโตรติกฺลิษฺฏตฺวาตฺ น: ปูรฺวฺวปุรุษา ภกฺษฺยทฺรวฺยํ นาลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","กินฺตุ มิสรเทเศ ศสฺยานิ สนฺติ, ยากูพฺ อิมำ วารฺตฺตำ ศฺรุตฺวา ปฺรถมมฺ อสฺมากํ ปูรฺวฺวปุรุษานฺ มิสรํ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ตโต ทฺวิตียวารคมเน ยูษผฺ สฺวภฺราตฺฤภิ: ปริจิโต'ภวตฺ; ยูษโผ ภฺราตร: ผิเราณฺ ราเชน ปริจิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","อนนฺตรํ ยูษผฺ ภฺราตฺฤคณํ เปฺรษฺย นิชปิตรํ ยากูพํ นิชานฺ ปญฺจาธิกสปฺตติสํขฺยกานฺ ชฺญาติชนำศฺจ สมาหูตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ตสฺมาทฺ ยากูพฺ มิสรเทศํ คตฺวา สฺวยมฺ อสฺมากํ ปูรฺวฺวปุรุษาศฺจ ตสฺมินฺ สฺถาเน'มฺริยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ตตเสฺต ศิขิมํ นีตา ยตฺ ศฺมศานมฺ อิพฺราหีมฺ มุทฺราทตฺวา ศิขิม: ปิตุ รฺหโมร: ปุเตฺรภฺย: กฺรีตวานฺ ตตฺศฺมศาเน สฺถาปยาญฺจกฺริเรฯ ");
INSERT INTO santha_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ตต: ปรมฺ อีศฺวร อิพฺราหีม: สนฺนิเธา ศปถํ กฺฤตฺวา ยำ ปฺรติชฺญำ กฺฤตวานฺ ตสฺยา: ปฺรติชฺญายา: ผลนสมเย นิกเฏ สติ อิสฺราเยโลฺลกา สิมรเทเศ วรฺทฺธมานา พหุสํขฺยา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","เศเษ ยูษผํ โย น ปริจิโนติ ตาทฺฤศ เอโก นรปติรุปสฺถาย ");
INSERT INTO santha_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","อสฺมากํ ชฺญาติภิ: สารฺทฺธํ ธูรฺตฺตตำ วิธาย ปูรฺวฺวปุรุษานฺ ปฺรติ กุวฺยวหรณปูรฺวฺวกํ เตษำ วํศนาศนาย เตษำ นวชาตานฺ ศิศูนฺ พหิ รฺนิรกฺเษปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","เอตสฺมินฺ สมเย มูสา ชชฺเญ, ส ตุ ปรมสุนฺทโร'ภวตฺ ตถา ปิตฺฤคฺฤเห มาสตฺรยปรฺยฺยนฺตํ ปาลิโต'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","กินฺตุ ตสฺมินฺ พหิรฺนิกฺษิปฺเต สติ ผิเราณราชสฺย กนฺยา ตมฺ อุตฺโตลฺย นีตฺวา ทตฺตกปุตฺรํ กฺฤตฺวา ปาลิตวตีฯ ");
INSERT INTO santha_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ตสฺมาตฺ ส มูสา มิสรเทศียายา: สรฺวฺววิทฺยายา: ปารทฺฤษฺวา สนฺ วาเกฺย กฺริยายาญฺจ ศกฺติมานฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ส สมฺปูรฺณจตฺวารึศทฺวตฺสรวยโสฺก ภูตฺวา อิสฺราเยลียวํศนิชภฺราตฺฤนฺ สากฺษาตฺ กรฺตุํ มตึ จเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","เตษำ ชนเมกํ หึสิตํ ทฺฤษฺฏฺวา ตสฺย สปกฺษ: สนฺ หึสิตชนมฺ อุปกฺฤตฺย มิสรียชนํ ชฆานฯ ");
INSERT INTO santha_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ตสฺย หเสฺตเนศฺวรสฺตานฺ อุทฺธริษฺยติ ตสฺย ภฺราตฺฤคณ อิติ ชฺญาสฺยติ ส อิตฺยนุมานํ จการ, กินฺตุ เต น พุพุธิเรฯ ");
INSERT INTO santha_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ตตฺปเร 'หนิ เตษามฺ อุภโย รฺชนโย รฺวากฺกลห อุปสฺถิเต สติ มูสา: สมีปํ คตฺวา ตโย เรฺมลนํ กรฺตฺตุํ มตึ กฺฤตฺวา กถยามาส, เห มหาศเยา ยุวำ ภฺราตเรา ปรสฺปรมฺ อนฺยายํ กุต: กุรุถ:? ");
INSERT INTO santha_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ตต: สมีปวาสินํ ปฺรติ โย ชโน'นฺยายํ จการ ส ตํ ทูรีกฺฤตฺย กถยามาส, อสฺมากมุปริ ศาสฺตฺฤตฺววิจารยิตฺฤตฺวปทโย: กสฺตฺวำ นิยุกฺตวานฺ? ");
INSERT INTO santha_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","โหฺย ยถา มิสรียํ หตวานฺ ตถา กึ มามปิ หนิษฺยสิ? ");
INSERT INTO santha_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ตทา มูสา เอตาทฺฤศีํ กถำ ศฺรุตฺวา ปลายนํ จเกฺร, ตโต มิทิยนเทศํ คตฺวา ปฺรวาสี สนฺ ตเสฺถา, ตตสฺตตฺร เทฺวา ปุเตฺรา ชชฺญาเตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","อนนฺตรํ จตฺวารึศทฺวตฺสเรษุ คเตษุ สีนยปรฺวฺวตสฺย ปฺรานฺตเร ปฺรชฺวลิตสฺตมฺพสฺย วหฺนิศิขายำ ปรเมศฺวรทูตสฺตไสฺม ทรฺศนํ ทเทาฯ ");
INSERT INTO santha_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","มูสาสฺตสฺมินฺ ทรฺศเน วิสฺมยํ มตฺวา วิเศษํ ชฺญาตุํ นิกฏํ คจฺฉติ, ");
INSERT INTO santha_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","เอตสฺมินฺ สมเย, อหํ ตว ปูรฺวฺวปุรุษาณามฺ อีศฺวโร'รฺถาทฺ อิพฺราหีม อีศฺวร อิสฺหาก อีศฺวโร ยากูพ อีศฺวรศฺจ, มูสามุทฺทิศฺย ปรเมศฺวรไสฺยตาทฺฤศี วิหายสียา วาณี พภูว, ตต: ส กมฺปานฺวิต: สนฺ ปุน รฺนิรีกฺษิตุํ ปฺรคลฺโภ น พภูวฯ ");
INSERT INTO santha_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ปรเมศฺวรสฺตํ ชคาท, ตว ปาทโย: ปาทุเก โมจย ยตฺร ติษฺฐสิ สา ปวิตฺรภูมิ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","อหํ มิสรเทศสฺถานำ นิชโลกานำ ทุรฺทฺทศำ นิตานฺตมฺ อปศฺยํ, เตษำ กาตรฺโยฺยกฺติญฺจ ศฺรุตวานฺ ตสฺมาตฺ ตานฺ อุทฺธรฺตฺตุมฺ อวรุหฺยาคมมฺ; อิทานีมฺ อาคจฺฉ มิสรเทศํ ตฺวำ เปฺรษยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","กสฺตฺวำ ศาสฺตฺฤตฺววิจารยิตฺฤตฺวปทโย รฺนิยุกฺตวานฺ, อิติ วากฺยมุกฺตฺวา ไต โรฺย มูสา อวชฺญาตสฺตเมว อีศฺวร: สฺตมฺพมเธฺย ทรฺศนทาตฺรา เตน ทูเตน ศาสฺตารํ มุกฺติทาตารญฺจ กฺฤตฺวา เปฺรษยามาสฯ ");
INSERT INTO santha_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ส จ มิสรเทเศ สูผฺนามฺนิ สมุเทฺร จ ปศฺจาตฺ จตฺวารึศทฺวตฺสรานฺ ยาวตฺ มหาปฺรานฺตเร นานาปฺรการาณฺยทฺภุตานิ กรฺมฺมาณิ ลกฺษณานิ จ ทรฺศยิตฺวา ตานฺ พหิ: กฺฤตฺวา สมานินายฯ ");
INSERT INTO santha_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ปฺรภุ: ปรเมศฺวโร ยุษฺมากํ ภฺราตฺฤคณสฺย มเธฺย มาทฺฤศมฺ เอกํ ภวิษฺยทฺวกฺตารมฺ อุตฺปาทยิษฺยติ ตสฺย กถายำ ยูยํ มโน นิธาสฺยถ, โย ชน อิสฺราเยล: สนฺตาเนภฺย เอนำ กถำ กถยามาส ส เอษ มูสา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","มหาปฺรานฺตรสฺถมณฺฑลีมเธฺย'ปิ ส เอว สีนยปรฺวฺวโตปริ เตน สารฺทฺธํ สํลาปิโน ทูตสฺย จาสฺมตฺปิตฺฤคณสฺย มธฺยสฺถ: สนฺ อสฺมภฺยํ ทาตวฺยนิ ชีวนทายกานิ วากฺยานิ เลเภฯ ");
INSERT INTO santha_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","อสฺมากํ ปูรฺวฺวปุรุษาสฺตมฺ อมานฺยํ กตฺวา เสฺวโภฺย ทูรีกฺฤตฺย มิสรเทศํ ปราวฺฤตฺย คนฺตุํ มโนภิรภิลษฺย หาโรณํ ชคทุ:, ");
INSERT INTO santha_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","อสฺมากมฺ อเคฺร'เคฺร คนฺตุुมฺ อสฺมทรฺถํ เทวคณํ นิรฺมฺมาหิ ยโต โย มูสา อสฺมานฺ มิสรเทศาทฺ พหิ: กฺฤตฺวานีตวานฺ ตสฺย กึ ชาตํ ตทสฺมาภิ รฺน ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ตสฺมินฺ สมเย เต โควตฺสากฺฤตึ ปฺรติมำ นิรฺมฺมาย ตามุทฺทิศฺย ไนเวทฺยมุตฺมฺฤชฺย สฺวหสฺตกฺฤตวสฺตุนา อานนฺทิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ตสฺมาทฺ อีศฺวรเสฺตษำ ปฺรติ วิมุข: สนฺ อากาศสฺถํ โชฺยติรฺคณํ ปูชยิตุํ เตโภฺย'นุมตึ ทเทา, ยาทฺฤศํ ภวิษฺยทฺวาทินำ คฺรนฺเถษุ ลิขิตมาเสฺต, ยถา, อิสฺราเยลียวํศา เร จตฺวารึศตฺสมานฺ ปุราฯ มหติ ปฺรานฺตเร สํสฺถา ยูยนฺตุ ยานิ จฯ พลิโหมาทิกรฺมฺมาณิ กฺฤตวนฺตสฺตุ ตานิ กึฯ มำ สมุทฺทิศฺย ยุษฺมาภิ: ปฺรกฺฤตานีติ ไนว จฯ ");
INSERT INTO santha_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","กินฺตุ โว โมลกาขฺยสฺย เทวสฺย ทูษฺยเมว จฯ ยุษฺมากํ ริมฺผนาขฺยายา เทวตายาศฺจ ตารกาฯ เอตโยรุภโย รฺมูรฺตี ยุษฺมาภิ: ปริปูชิเตฯ อโต ยุษฺมำสฺตุ พาเพล: ปารํ เนษฺยามิ นิศฺจิตํฯ ");
INSERT INTO santha_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","อปรญฺจ ยนฺนิทรฺศนมฺ อปศฺยสฺตทนุสาเรณ ทูษฺยํ นิรฺมฺมาหิ ยสฺมินฺ อีศฺวโร มูสามฺ เอตทฺวากฺยํ พภาเษ ตตฺ ตสฺย นิรูปิตํ สากฺษฺยสฺวรูปํ ทูษฺยมฺ อสฺมากํ ปูรฺวฺวปุรุไษ: สห ปฺรานฺตเร ตเสฺถาฯ ");
INSERT INTO santha_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ปศฺจาตฺ ยิโหศูเยน สหิไตเสฺตษำ วํศชาไตรสฺมตฺปูรฺวฺวปุรุไษ: เสฺวษำ สมฺมุขาทฺ อีศฺวเรณ ทูรีกฺฤตานามฺ อนฺยเทศียานำ เทศาธิกฺฤติกาเล สมานีตํ ตทฺ ทูษฺยํ ทายูโทธิการํ ยาวตฺ ตตฺร สฺถาน อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ส ทายูทฺ ปรเมศฺวรสฺยานุคฺรหํ ปฺราปฺย ยากูพฺ อีศฺวรารฺถมฺ เอกํ ทูษฺยํ นิรฺมฺมาตุํ ววาญฺฉ; ");
INSERT INTO santha_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","กินฺตุ สุเลมานฺ ตทรฺถํ มนฺทิรมฺ เอกํ นิรฺมฺมิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ตถาปิ ย: สรฺโวฺวปริสฺถ: ส กสฺมึศฺจิทฺ หสฺตกฺฤเต มนฺทิเร นิวสตีติ นหิ, ภวิษฺยทฺวาที กถาเมตำ กถยติ, ยถา, ");
INSERT INTO santha_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ปเรโศ วทติ สฺวรฺโค ราชสึหาสนํ มมฯ มทียํ ปาทปีฐญฺจ ปฺฤถิวี ภวติ ธฺรุวํฯ ตรฺหิ ยูยํ กฺฤเต เม กึ ปฺรนิรฺมฺมาสฺยถ มนฺทิรํฯ วิศฺรามาย มทียํ วา สฺถานํ กึ วิทฺยเต ตฺวิหฯ ");
INSERT INTO santha_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","สรฺวฺวาเณฺยตานิ วสฺตูนิ กึ เม หสฺตกฺฤตานิ น๚ ");
INSERT INTO santha_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","เห อนาชฺญาคฺราหกา อนฺต:กรเณ ศฺรวเณ จาปวิตฺรโลกา: ยูยมฺ อนวรตํ ปวิตฺรสฺยาตฺมน: ปฺราติกูลฺยมฺ อาจรถ, ยุษฺมากํ ปูรฺวฺวปุรุษา ยาทฺฤศา ยูยมปิ ตาทฺฤศา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ยุษฺมากํ ปูรฺวฺวปุรุษา: กํ ภวิษฺยทฺวาทินํ นาตาฑยนฺ? เย ตสฺย ธารฺมฺมิกสฺย ชนสฺยาคมนกถำ กถิตวนฺตสฺตานฺ อฆฺนนฺ ยูยมฺ อธูนา วิศฺวาสฆาติโน ภูตฺวา ตํ ธารฺมฺมิกํ ชนมฺ อหตฯ ");
INSERT INTO santha_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ยูยํ สฺวรฺคียทูตคเณน วฺยวสฺถำ ปฺราปฺยาปิ ตำ นาจรถฯ ");
INSERT INTO santha_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","อิมำ กถำ ศฺรุตฺวา เต มน:สุ พิทฺธา: สนฺตสฺตํ ปฺรติ ทนฺตฆรฺษณมฺ อกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","กินฺตุ สฺติผาน: ปวิเตฺรณาตฺมนา ปูรฺโณ ภูตฺวา คคณํ ปฺรติ สฺถิรทฺฤษฺฏึ กฺฤตฺวา อีศฺวรสฺย ทกฺษิเณ ทณฺฑายมานํ ยีศุญฺจ วิโลกฺย กถิตวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ปศฺย,เมฆทฺวารํ มุกฺตมฺ อีศฺวรสฺย ทกฺษิเณ สฺถิตํ มานวสุตญฺจ ปศฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ตทา เต โปฺรจฺไจ: ศพฺทํ กฺฤตฺวา กรฺเณษฺวงฺคุลี รฺนิธาย เอกจิตฺตีภูย ตมฺ อากฺรมนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ปศฺจาตฺ ตํ นคราทฺ พหิ: กฺฤตฺวา ปฺรสฺตไรราฆฺนนฺ สากฺษิโณ ลากา: เศาลนามฺโน ยูนศฺจรณสนฺนิเธา นิชวสฺตฺราณิ สฺถาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","อนนฺตรํ เห ปฺรโภ ยีเศ มทียมาตฺมานํ คฺฤหาณ สฺติผานเสฺยติ ปฺรารฺถนวากฺยวทนสมเย เต ตํ ปฺรสฺตไรราฆฺนนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ตสฺมาตฺ ส ชานุนี ปาตยิตฺวา โปฺรจฺไจ: ศพฺทํ กฺฤตฺวา, เห ปฺรเภ ปาปเมตทฺ เอเตษุ มา สฺถาปย, อิตฺยุกฺตฺวา มหานิทฺรำ ปฺราปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ตสฺย หตฺยากรณํ เศาโลปิ สมมนฺยตฯ ตสฺมินฺ สมเย ยิรูศาลมฺนครสฺถำ มณฺฑลีํ ปฺรติ มหาตาฑนายำ ชาตายำ เปฺรริตโลกานฺ หิตฺวา สรฺเวฺว'ปเร ยิหูทาโศมิโรณเทศโย รฺนานาสฺถาเน วิกีรฺณา: สนฺโต คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","อนฺยจฺจ ภกฺตโลกาสฺตํ สฺติผานํ ศฺมศาเน สฺถาปยิตฺวา พหุ วฺยลปนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","กินฺตุ เศาโล คฺฤเห คฺฤเห ภฺรมิตฺวา สฺตฺริย: ปุรุษำศฺจ ธฺฤตฺวา การายำ พทฺธฺวา มณฺฑลฺยา มโหตฺปาตํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","อนฺยจฺจ เย วิกีรฺณา อภวนฺ เต สรฺวฺวตฺร ภฺรมิตฺวา สุสํวาทํ ปฺราจารยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ตทา ผิลิป: โศมิโรณฺนครํ คตฺวา ขฺรีษฺฏาขฺยานํ ปฺราจารยตฺ; ");
INSERT INTO santha_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ตโต'ศุจิ-ภฺฤตคฺรสฺตโลเกโภฺย ภูตาศฺจีตฺกฺฤตฺยาคจฺฉนฺ ตถา พหว: ปกฺษาฆาติน: ขญฺชา โลกาศฺจ สฺวสฺถา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ตสฺมาตฺ ลากา อีทฺฤศํ ตสฺยาศฺจรฺยฺยํ กรฺมฺม วิโลกฺย นิศมฺย จ สรฺวฺว เอกจิตฺตีภูย เตโนกฺตาขฺยาเน มนำสิ นฺยทธุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ตสฺมินฺนคเร มหานนฺทศฺจาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ตต: ปูรฺวฺวํ ตสฺมินฺนคเร ศิโมนฺนามา กศฺจิชฺชโน พหฺวี รฺมายากฺริยา: กฺฤตฺวา สฺวํ กญฺจน มหาปุรุษํ โปฺรจฺย โศมิโรณียานำ โมหํ ชนยามาสฯ ");
INSERT INTO santha_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ตสฺมาตฺ ส มานุษ อีศฺวรสฺย มหาศกฺติสฺวรูป อิตฺยุกฺตฺวา พาลวฺฤทฺธวนิตา: สรฺเวฺว ลากาสฺตสฺมินฺ มนำสิ นฺยทธุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ส พหุกาลานฺ มายาวิกฺริยยา สรฺวฺวานฺ อตีว โมหยาญฺจการ, ตสฺมาตฺ เต ตํ เมนิเรฯ ");
INSERT INTO santha_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","กินฺตฺวีศฺวรสฺย ราชฺยสฺย ยีศุขฺรีษฺฏสฺย นามฺนศฺจาขฺยานปฺรจาริณ: ผิลิปสฺย กถายำ วิศฺวสฺย เตษำ สฺตฺรีปุรุโษภยโลกา มชฺชิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","เศเษ ส ศิโมนปิ สฺวยํ ปฺรไตฺยตฺ ตโต มชฺชิต: สนฺ ผิลิเปน กฺฤตามฺ อาศฺจรฺยฺยกฺริยำ ลกฺษณญฺจ วิโลกฺยาสมฺภวํ มนฺยมานเสฺตน สห สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","อิตฺถํ โศมิโรณฺเทศียโลกา อีศฺวรสฺย กถามฺ อคฺฤหฺลนฺ อิติ วารฺตฺตำ ยิรูศาลมฺนครสฺถเปฺรริตา: ปฺราปฺย ปิตรํ โยหนญฺจ เตษำ นิกเฏ เปฺรษิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ตตเสฺตา ตตฺ สฺถานมฺ อุปสฺถาย โลกา ยถา ปวิตฺรมฺ อาตฺมานํ ปฺราปฺนุวนฺติ ตทรฺถํ ปฺรารฺถเยตำฯ ");
INSERT INTO santha_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ยตเสฺต ปุรา เกวลปฺรภุยีโศ รฺนามฺนา มชฺชิตมาตฺรา อภวนฺ, น ตุ เตษำ มเธฺย กมปิ ปฺรติ ปวิตฺรสฺยาตฺมน อาวิรฺภาโว ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","กินฺตุ เปฺรริตาภฺยำ เตษำ คาเตฺรษุ กเรษฺวรฺปิเตษุ สตฺสุ เต ปวิตฺรมฺ อาตฺมานมฺ ปฺราปฺนุวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","อิตฺถํ โลกานำ คาเตฺรษุ เปฺรริตโย: กรารฺปเณน ตานฺ ปวิตฺรมฺ อาตฺมานํ ปฺราปฺตานฺ ทฺฤษฺฏฺวา ส ศิโมนฺ ตโย: สมีเป มุทฺรา อานีย กถิตวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","อหํ ยสฺย คาเตฺร หสฺตมฺ อรฺปยิษฺยามิ ตสฺยาปิ ยเถตฺถํ ปวิตฺราตฺมปฺราปฺติ รฺภวติ ตาทฺฤศีํ ศกฺตึ มหฺยํ ทตฺตํฯ ");
INSERT INTO santha_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","กินฺตุ ปิตรสฺตํ ปฺรตฺยวทตฺ ตว มุทฺราสฺตฺวยา วินศฺยนฺตุ ยต อีศฺวรสฺย ทานํ มุทฺราภิ: กฺรียเต ตฺวมิตฺถํ พุทฺธวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","อีศฺวราย ตาวนฺต:กรณํ สรลํ นหิ, ตสฺมาทฺ อตฺร ตวำโศ'ธิการศฺจ โกปิ นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","อต เอตตฺปาปเหโต: เขทานฺวิต: สนฺ เกนาปิ ปฺรกาเรณ ตว มนส เอตสฺยา: กุกลฺปนายา: กฺษมา ภวติ, เอตทรฺถมฺ อีศฺวเร ปฺรารฺถนำ กุรุ; ");
INSERT INTO santha_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ยตสฺตฺวํ ติกฺตปิตฺเต ปาปสฺย พนฺธเน จ ยทสิ ตนฺมยา พุทฺธมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ตทา ศิโมนฺ อกถยตฺ ตรฺหิ ยุวาภฺยามุทิตา กถา มยิ ยถา น ผลติ ตทรฺถํ ยุวำ มนฺนิมิตฺตํ ปฺรเภา ปฺรารฺถนำ กุรุตํฯ ");
INSERT INTO santha_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","อเนน ปฺรกาเรณ เตา สากฺษฺยํ ทตฺตฺวา ปฺรโภ: กถำ ปฺรจารยนฺเตา โศมิโรณียานามฺ อเนกคฺราเมษุ สุสํวาทญฺจ ปฺรจารยนฺเตา ยิรูศาลมฺนครํ ปราวฺฤตฺย คเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ตต: ปรมฺ อีศฺวรสฺย ทูต: ผิลิปมฺ อิตฺยาทิศตฺ, ตฺวมุตฺถาย ทกฺษิณสฺยำ ทิศิ โย มารฺโค ปฺรานฺตรสฺย มเธฺยน ยิรูศาลโม 'สานครํ ยาติ ตํ มารฺคํ คจฺฉฯ ");
INSERT INTO santha_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ตต: ส อุตฺถาย คตวานฺ; ตทา กนฺทากีนามฺน: กูโศฺลกานำ ราชฺญฺยา: สรฺวฺวสมฺปตฺเตรธีศ: กูศเทศีย เอก: ษณฺโฑ ภชนารฺถํ ยิรูศาลมฺนครมฺ อาคตฺย ");
INSERT INTO santha_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ปุนรปิ รถมารุหฺย ยิศยิยนามฺโน ภวิษฺยทฺวาทิโน คฺรนฺถํ ปฐนฺ ปฺรตฺยาคจฺฉติฯ ");
INSERT INTO santha_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","เอตสฺมินฺ สมเย อาตฺมา ผิลิปมฺ อวทตฺ, ตฺวมฺ รถสฺย สมีปํ คตฺวา เตน สารฺทฺธํ มิลฯ ");
INSERT INTO santha_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ตสฺมาตฺ ส ธาวนฺ ตสฺย สนฺนิธาวุปสฺถาย เตน ปฐฺยมานํ ยิศยิยถวิษฺยทฺวาทิโน วากฺยํ ศฺรุตฺวา ปฺฤษฺฏวานฺ ยตฺ ปฐสิ ตตฺ กึ พุธฺยเส? ");
INSERT INTO santha_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ตต: ส กถิตวานฺ เกนจินฺน โพธิโตหํ กถํ พุเธฺยย? ตต: ส ผิลิปํ รถมาโรฒุํ เสฺวน สารฺทฺธมฺ อุปเวษฺฏุญฺจ นฺยเวทยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ส ศาสฺตฺรเสฺยตทฺวากฺยํ ปฐิตวานฺ ยถา, สมานียต ฆาตาย ส ยถา เมษศาวก:ฯ โลมจฺเฉทกสากฺษาจฺจ เมษศฺจ นีรโว ยถาฯ อาพธฺย วทนํ สฺวียํ ตถา ส สมติษฺฐตฯ ");
INSERT INTO santha_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","อนฺยาเยน วิจาเรณ ส อุจฺฉินฺโน 'ภวตฺ ตทาฯ ตตฺกาลีนมนุษฺยานฺ โก ชโน วรฺณยิตุํ กฺษม:ฯ ยโต ชีวนฺนฺฤณำ เทศาตฺ ส อุจฺฉินฺโน 'ภวตฺ ธฺรุวํฯ ");
INSERT INTO santha_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","อนนฺตรํ ส ผิลิปมฺ อวทตฺ นิเวทยามิ, ภวิษฺยทฺวาที ยามิมำ กถำ กถยามาส ส กึ สฺวสฺมินฺ วา กสฺมึศฺจิทฺ อนฺยสฺมินฺ? ");
INSERT INTO santha_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ตต: ผิลิปสฺตตฺปฺรกรณมฺ อารภฺย ยีโศรุปาขฺยานํ ตสฺยาเคฺร ปฺราเสฺตาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","อิตฺถํ มารฺเคณ คจฺฉนฺเตา ชลาศยสฺย สมีป อุปสฺถิเตา; ตทา กฺลีโพ'วาทีตฺ ปศฺยาตฺร สฺถาเน ชลมาเสฺต มม มชฺชเน กา พาธา? ");
INSERT INTO santha_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ตต: ผิลิป อุตฺตรํ วฺยาหรตฺ สฺวานฺต:กรเณน สากํ ยทิ ปฺรเตฺยษิ ตรฺหิ พาธา นาสฺติฯ ตต: ส กถิตวานฺ ยีศุขฺรีษฺฏ อีศฺวรสฺย ปุตฺร อิตฺยหํ ปฺรเตฺยมิฯ ");
INSERT INTO santha_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ตทา รถํ สฺถคิตํ กรฺตฺตุมฺ อาทิษฺเฏ ผิลิปกฺลีเพา เทฺวา ชลมฺ อวารุหตำ; ตทา ผิลิปสฺตมฺ มชฺชยามาสฯ ");
INSERT INTO santha_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ตตฺปศฺจาตฺ ชลมธฺยาทฺ อุตฺถิตโย: สโต: ปรเมศฺวรสฺยาตฺมา ผิลิปํ หฺฤตฺวา นีตวานฺ, ตสฺมาตฺ กฺลีพ: ปุนสฺตํ น ทฺฤษฺฏวานฺ ตถาปิ หฺฤษฺฏจิตฺต: สนฺ สฺวมารฺเคณ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ผิลิปศฺจาโสฺททฺนครมฺ อุปสฺถาย ตสฺมาตฺ ไกสริยานคร อุปสฺถิติกาลปรฺยฺยนตํ สรฺวฺวสฺมินฺนคเร สุสํวาทํ ปฺรจารยนฺ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ตตฺกาลปรฺยฺยนตํ เศาล: ปฺรโภ: ศิษฺยาณำ ปฺราติกูเลฺยน ตาฑนาพธโย: กถำ นิ:สารยนฺ มหายาชกสฺย สนฺนิธึ คตฺวา ");
INSERT INTO santha_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","สฺตฺริยํ ปุรุษญฺจ ตนฺมตคฺราหิณํ ยํ กญฺจิตฺ ปศฺยติ ตานฺ ธฺฤตฺวา พทฺธฺวา ยิรูศาลมมฺ อานยตีตฺยาศเยน ทมฺเมษกฺนครียํ ธรฺมฺมสมาชานฺ ปฺรติ ปตฺรํ ยาจิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","คจฺฉนฺ ตุ ทมฺเมษกฺนครนิกฏ อุปสฺถิตวานฺ; ตโต'กสฺมาทฺ อากาศาตฺ ตสฺย จตุรฺทิกฺษุ เตชส: ปฺรกาศนาตฺ ส ภูมาวปตตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ปศฺจาตฺ เห เศาล เห เศาล กุโต มำ ตาฑยสิ? สฺวํ ปฺรติ โปฺรกฺตมฺ เอตํ ศพฺทํ ศฺรุตฺวา ");
INSERT INTO santha_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ส ปฺฤษฺฏวานฺ, เห ปฺรโภ ภวานฺ ก:? ตทา ปฺรภุรกถยตฺ ยํ ยีศุํ ตฺวํ ตาฑยสิ ส เอวาหํ; กณฺฏกสฺย มุเข ปทาฆาตกรณํ ตว กษฺฏมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ตทา กมฺปมาโน วิสฺมยาปนฺนศฺจ โสวทตฺ เห ปฺรโภ มยา กึ กรฺตฺตวฺยํ? ภวต อิจฺฉา กา? ตต: ปฺรภุราชฺญาปยทฺ อุตฺถาย นครํ คจฺฉ ตตฺร ตฺวยา ยตฺ กรฺตฺตวฺยํ ตทฺ วทิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ตสฺย สงฺคิโน โลกา อปิ ตํ ศพฺทํ ศฺรุตวนฺต: กินฺตุ กมปิ น ทฺฤษฺฏฺวา สฺตพฺธา: สนฺต: สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","อนนฺตรํ เศาโล ภูมิต อุตฺถาย จกฺษุษี อุนฺมีลฺย กมปิ น ทฺฤษฺฏวานฺฯ ตทา โลกาสฺตสฺย หเสฺตา ธฺฤตฺวา ทมฺเมษกฺนครมฺ อานยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ตต: ส ทินตฺรยํ ยาวทฺ อนฺโธ ภูตฺวา น ภุกฺตวานฺ ปีตวำศฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ตทนนฺตรํ ปฺรภุสฺตทฺทมฺเมษกฺนครวาสิน เอกไสฺม ศิษฺยาย ทรฺศนํ ทตฺวา อาหูตวานฺ เห อนนิยฯ ตต: ส ปฺรตฺยวาทีตฺ, เห ปฺรโภ ปศฺย ศฺฤโณมิฯ ");
INSERT INTO santha_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ตทา ปฺรภุสฺตมาชฺญาปยตฺ ตฺวมุตฺถาย สรลนามานํ มารฺคํ คตฺวา ยิหูทานิเวศเน ตารฺษนครียํ เศาลนามานํ ชนํ คเวษยนฺ ปฺฤจฺฉ; ");
INSERT INTO santha_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ปศฺย ส ปฺรารฺถยเต, ตถา อนนิยนามก เอโก ชนสฺตสฺย สมีปมฺ อาคตฺย ตสฺย คาเตฺร หสฺตารฺปณํ กฺฤตฺวา ทฺฤษฺฏึ ททาตีตฺถํ สฺวปฺเน ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ตสฺมาทฺ อนนิย: ปฺรตฺยวทตฺ เห ปฺรโภ ยิรูศาลมิ ปวิตฺรโลกานฺ ปฺรติ โส'เนกหึสำ กฺฤตวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","อตฺร สฺถาเน จ เย โลกาสฺตว นามฺนิ ปฺรารฺถยนฺติ ตานปิ พทฺธุํ ส ปฺรธานยาชเกภฺย: ศกฺตึ ปฺราปฺตวานฺ, อิมำ กถามฺ อหมฺ อเนเกษำ มุเขภฺย: ศฺรุตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","กินฺตุ ปฺรภุรกถยตฺ, ยาหิ ภินฺนเทศียโลกานำ ภูปตีนามฺ อิสฺราเยโลฺลกานาญฺจ นิกเฏ มม นาม ปฺรจารยิตุํ ส ชโน มม มโนนีตปาตฺรมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","มม นามนิมิตฺตญฺจ เตน กิยานฺ มหานฺ เกฺลโศ โภกฺตวฺย เอตตฺ ตํ ทรฺศยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ตโต 'นนิโย คตฺวา คฺฤหํ ปฺรวิศฺย ตสฺย คาเตฺร หสฺตารฺปฺรณํ กฺฤตฺวา กถิตวานฺ, เห ภฺราต: เศาล ตฺวํ ยถา ทฺฤษฺฏึ ปฺราปฺโนษิ ปวิเตฺรณาตฺมนา ปริปูรฺโณ ภวสิ จ, ตทรฺถํ ตวาคมนกาเล ย: ปฺรภุยีศุสฺตุภฺยํ ทรฺศนมฺ อททาตฺ ส มำ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","อิตฺยุกฺตมาเตฺร ตสฺย จกฺษุรฺภฺยามฺ มีนศลฺกวทฺ วสฺตุนิ นิรฺคเต ตตฺกฺษณาตฺ ส ปฺรสนฺนจกฺษุ รฺภูตฺวา โปฺรตฺถาย มชฺชิโต'ภวตฺ ภุกฺตฺวา ปีตฺวา สพโลภวจฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ตต: ปรํ เศาล: ศิไษฺย: สห กติปยทิวสานฺ ตสฺมินฺ ทมฺเมษกนคเร สฺถิตฺวา'วิลมฺพํ ");
INSERT INTO santha_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","สรฺวฺวภชนภวนานิ คตฺวา ยีศุรีศฺวรสฺย ปุตฺร อิมำ กถำ ปฺราจารยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ตสฺมาตฺ สรฺเวฺว โศฺรตารศฺจมตฺกฺฤตฺย กถิตวนฺโต โย ยิรูศาลมฺนคร เอตนฺนามฺนา ปฺรารฺถยิตฺฤโลกานฺ วินาศิตวานฺ เอวมฺ เอตาทฺฤศโลกานฺ พทฺธฺวา ปฺรธานยาชกนิกฏํ นยตีตฺยาศยา เอตตฺสฺถานมปฺยาคจฺฉตฺ เสอว กิมยํ น ภวติ? ");
INSERT INTO santha_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","กินฺตุ เศาล: กฺรมศ อุตฺสาหวานฺ ภูตฺวา ยีศุรีศฺวเรณาภิษิกฺโต ชน เอตสฺมินฺ ปฺรมาณํ ทตฺวา ทมฺเมษกฺ-นิวาสิยิหูทียโลกานฺ นิรุตฺตรานฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","อิตฺถํ พหุติเถ กาเล คเต ยิหูทียโลกาสฺตํ หนฺตุํ มนฺตฺรยามาสุ: ");
INSERT INTO santha_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","กินฺตุ เศาลเสฺตษาเมตสฺยา มนฺตฺรณายา วารฺตฺตำ ปฺราปฺตวานฺฯ เต ตํ หนฺตุํ ตุ ทิวานิศํ คุปฺตา: สนฺโต นครสฺย ทฺวาเร'ติษฺฐนฺ; ");
INSERT INTO santha_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ตสฺมาตฺ ศิษฺยาสฺตํ นีตฺวา ราเตฺรา ปิฏเก นิธาย ปฺราจีเรณาวาโรหยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ตต: ปรํ เศาโล ยิรูศาลมํ คตฺวา ศิษฺยคเณน สารฺทฺธํ สฺถาตุมฺ ไอหตฺ, กินฺตุ สรฺเวฺว ตสฺมาทพิภยุ: ส ศิษฺย อิติ จ น ปฺรตฺยยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","เอตสฺมาทฺ พรฺณพฺพาสฺตํ คฺฤหีตฺวา เปฺรริตานำ สมีปมานีย มารฺคมเธฺย ปฺรภุ: กถํ ตไสฺม ทรฺศนํ ทตฺตวานฺ ยา: กถาศฺจ กถิตวานฺ ส จ ยถากฺโษภ: สนฺ ทมฺเมษกฺนคเร ยีโศ รฺนาม ปฺราจารยตฺ เอตานฺ สรฺวฺววฺฤตฺตานฺตานฺ ตานฺ ชฺญาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ตต: เศาลไสฺต: สห ยิรูศาลมิ กาลํ ยาปยนฺ นิรฺภยํ ปฺรโภ รฺยีโศ รฺนาม ปฺราจารยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ตสฺมาทฺ อนฺยเทศียโลไก: สารฺทฺธํ วิวาทโสฺยปสฺถิตตฺวาตฺ เต ตํ หนฺตุมฺ อเจษฺฏนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","กินฺตุ ภฺราตฺฤคณสฺตชฺชฺญาตฺวา ตํ ไกสริยานครํ นีตฺวา ตารฺษนครํ เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","อิตฺถํ สติ ยิหูทิยาคาลีลฺโศมิโรณเทศียา: สรฺวฺวา มณฺฑโลฺย วิศฺรามํ ปฺราปฺตาสฺตตสฺตาสำ นิษฺฐาภวตฺ ปฺรโภ รฺภิยา ปวิตฺรสฺยาตฺมน: สานฺตฺวนยา จ กาลํ เกฺษปยิตฺวา พหุสํขฺยา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ตต: ปรํ ปิตร: สฺถาเน สฺถาเน ภฺรมิตฺวา เศเษ โลทฺนครนิวาสิปวิตฺรโลกานำ สมีเป สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ตทา ตตฺร ปกฺษาฆาตวฺยาธินาษฺเฏา วตฺสรานฺ ศยฺยาคตมฺ ไอเนยนามานํ มนุษฺยํ สากฺษตฺ ปฺราปฺย ตมวทตฺ, ");
INSERT INTO santha_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","เห ไอเนย ยีศุขฺรีษฺฏสฺตฺวำ สฺวสฺถมฺ อการฺษีตฺ, ตฺวมุตฺถาย สฺวศยฺยำ นิกฺษิป, อิตฺยุกฺตมาเตฺร ส อุทติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","เอตาทฺฤศํ ทฺฤษฺฏฺวา โลทฺศาโรณนิวาสิโน โลกา: ปฺรภุํ ปฺรติ ปราวรฺตฺตนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","อปรญฺจ ภิกฺษาทานาทิษุ นานกฺริยาสุ นิตฺยํ ปฺรวฺฤตฺตา ยา ยาโผนครนิวาสินี ฏาพิถานามา ศิษฺยา ยำ ทรฺกฺกำ อรฺถาทฺ หริณีมยุกฺตฺวา อาหฺวยนฺ สา นารี ");
INSERT INTO santha_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ตสฺมินฺ สมเย รุคฺนา สตี ปฺราณานฺ อตฺยชตฺ, ตโต โลกาสฺตำ ปฺรกฺษาโลฺยปริสฺถปฺรโกษฺเฐ ศายยิตฺวาสฺถาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","โลทฺนครํ ยาโผนครสฺย สมีปสฺถํ ตสฺมาตฺตตฺร ปิตร อาเสฺต, อิติ วารฺตฺตำ ศฺรุตฺวา ตูรฺณํ ตสฺยาคมนารฺถํ ตสฺมินฺ วินยมุกฺตฺวา ศิษฺยคโณ เทฺวา มนุเชา เปฺรษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ตสฺมาตฺ ปิตร อุตฺถาย ตาภฺยำ สารฺทฺธมฺ อาคจฺฉตฺ, ตตฺร ตสฺมินฺ อุปสฺถิต อุปริสฺถปฺรโกษฺฐํ สมานีเต จ วิธวา: สฺวาภิ: สห สฺถิติกาเล ทรฺกฺกยา กฺฤตานิ ยานฺยุตฺตรียาณิ ปริเธยานิ จ ตานิ สรฺวฺวาณิ ตํ ทรฺศยิตฺวา รุทตฺยศฺจตสฺฤษุ ทิกฺษฺวติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","กินฺตุ ปิตรสฺตา: สรฺวฺวา พหิ: กฺฤตฺวา ชานุนี ปาตยิตฺวา ปฺรารฺถิตวานฺ; ปศฺจาตฺ ศวํ ปฺรติ ทฺฤษฺฏึ กฺฤตฺวา กถิตวานฺ, เห ฏาพีเถ ตฺวมุตฺติษฺฐ, อิติ วากฺย อุกฺเต สา สฺตฺรี จกฺษุษี โปฺรนฺมีลฺย ปิตรมฺ อวโลโกฺยตฺถาโยปาวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ตต: ปิตรสฺตสฺยา: กเรา ธฺฤตฺวา อุตฺโตลฺย ปวิตฺรโลกานฺ วิธวาศฺจาหูย เตษำ นิกเฏ สชีวำ ตำ สมารฺปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","เอษา กถา สมสฺตยาโผนครํ วฺยาปฺตา ตสฺมาทฺ อเนเก โลกา: ปฺรเภา วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","อปรญฺจ ปิตรสฺตทฺยาโผนครียสฺย กสฺยจิตฺ ศิโมนฺนามฺนศฺจรฺมฺมการสฺย คฺฤเห พหุทินานิ นฺยวสตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ไกสริยานคร อิตาลิยาขฺยไสนฺยานฺตรฺคต: กรฺณีลิยนามา เสนาปติราสีตฺ ");
INSERT INTO santha_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ส สปริวาโร ภกฺต อีศฺวรปรายณศฺจาสีตฺ; โลเกโภฺย พหูนิ ทานาทีนิ ทตฺวา นิรนฺตรมฺ อีศฺวเร ปฺรารฺถยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","เอกทา ตฺฤตียปฺรหรเวลายำ ส ทฺฤษฺฏวานฺ อีศฺวรไสฺยโก ทูต: สปฺรกาศํ ตตฺสมีปมฺ อาคตฺย กถิตวานฺ, เห กรฺณีลิยฯ ");
INSERT INTO santha_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","กินฺตุ ส ตํ ทฺฤษฺฏฺวา ภีโต'กถยตฺ, เห ปฺรโภ กึ? ตทา ตมวทตฺ ตว ปฺรารฺถนา ทานาทิ จ สากฺษิสฺวรูปํ ภูเตฺวศฺวรสฺย โคจรมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","อิทานีํ ยาโผนครํ ปฺรติ โลกานฺ เปฺรษฺย สมุทฺรตีเร ศิโมนฺนามฺนศฺจรฺมฺมการสฺย คฺฤเห ปฺรวาสการี ปิตรนามฺนา วิขฺยาโต ย: ศิโมนฺ ตมฺ อาหฺวายย; ");
INSERT INTO santha_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ตสฺมาตฺ ตฺวยา ยทฺยตฺ กรฺตฺตวฺยํ ตตฺตตฺ ส วทิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","อิตฺยุปทิศฺย ทูเต ปฺรสฺถิเต สติ กรฺณีลิย: สฺวคฺฤหสฺถานำ ทาสานำ เทฺวา ชเนา นิตฺยํ สฺวสงฺคินำ ไสนฺยานามฺ เอกำ ภกฺตเสนาญฺจาหูย ");
INSERT INTO santha_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","สกลเมตํ วฺฤตฺตานฺตํ วิชฺญาปฺย ยาโผนครํ ตานฺ ปฺราหิโณตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ปรสฺมินฺ ทิเน เต ยาตฺรำ กฺฤตฺวา ยทา นครสฺย สมีป อุปาติษฺฐนฺ, ตทา ปิตโร ทฺวิตียปฺรหรเวลายำ ปฺรารฺถยิตุํ คฺฤหปฺฤษฺฐมฺ อาโรหตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","เอตสฺมินฺ สมเย กฺษุธารฺตฺต: สนฺ กิญฺจิทฺ โภกฺตุมฺ ไอจฺฉตฺ กินฺตุ เตษามฺ อนฺนาสาทนสมเย ส มูรฺจฺฉิต: สนฺนปตตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ตโต เมฆทฺวารํ มุกฺตํ จตุรฺภิ: โกไณ รฺลมฺพิตํ พฺฤหทฺวสฺตฺรมิว กิญฺจน ภาชนมฺ อากาศาตฺ ปฺฤถิวีมฺ อวาโรหตีติ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ตนฺมเธฺย นานปฺรการา คฺรามฺยวนฺยปศว: เขจโรโรคามิปฺรภฺฤตโย ชนฺตวศฺจาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","อนนฺตรํ เห ปิตร อุตฺถาย หตฺวา ภุํกฺษฺว ตมฺปฺรตียํ คคณียา วาณี ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ตทา ปิตร: ปฺรตฺยวทตฺ, เห ปฺรโภ อีทฺฤศํ มา ภวตุ, อหมฺ เอตตฺ กาลํ ยาวตฺ นิษิทฺธมฺ อศุจิ วา ทฺรวฺยํ กิญฺจิทปิ น ภุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ตต: ปุนรปิ ตาทฺฤศี วิหยสียา วาณี ชาตา ยทฺ อีศฺวร: ศุจิ กฺฤตวานฺ ตตฺ ตฺวํ นิษิทฺธํ น ชานีหิฯ ");
INSERT INTO santha_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","อิตฺถํ ตฺริ: สติ ตตฺ ปาตฺรํ ปุนรากฺฤษฺฏํ อากาศมฺ อคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ตต: ปรํ ยทฺ ทรฺศนํ ปฺราปฺตวานฺ ตสฺย โก ภาว อิตฺยตฺร ปิตโร มนสา สนฺเทคฺธิ, เอตสฺมินฺ สมเย กรฺณีลิยสฺย เต เปฺรษิตา มนุษฺยา ทฺวารสฺย สนฺนิธาวุปสฺถาย, ");
INSERT INTO santha_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ศิโมโน คฺฤหมนฺวิจฺฉนฺต: สมฺปฺฤฉฺยาหูย กถิตวนฺต: ปิตรนามฺนา วิขฺยาโต ย: ศิโมนฺ ส กิมตฺร ปฺรวสติ? ");
INSERT INTO santha_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ยทา ปิตรสฺตทฺทรฺศนสฺย ภาวํ มนสานฺโทลยติ ตทาตฺมา ตมวทตฺ, ปศฺย ตฺรโย ชนาสฺตฺวำ มฺฤคยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ตฺวมฺ อุตฺถายาวรุหฺย นิ:สนฺเทหํ ไต: สห คจฺฉ มไยว เต เปฺรษิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ตสฺมาตฺ ปิตโร'วรุหฺย กรฺณีลิยเปฺรริตโลกานำ นิกฏมาคตฺย กถิตวานฺ ปศฺยต ยูยํ ยํ มฺฤคยเธฺว ส ชโนหํ, ยูยํ กินฺนิมิตฺตมฺ อาคตา:? ");
INSERT INTO santha_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ตตเสฺต ปฺรตฺยวทนฺ กรฺณีลิยนามา ศุทฺธสตฺตฺว อีศฺวรปรายโณ ยิหูทียเทศสฺถานำ สรฺเวฺวษำ สนฺนิเธา สุขฺยาตฺยาปนฺน เอก: เสนาปติ รฺนิชคฺฤหํ ตฺวามาหูย เนตุํ ตฺวตฺต: กถา โศฺรตุญฺจ ปวิตฺรทูเตน สมาทิษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ตทา ปิตรสฺตานภฺยนฺตรํ นีตฺวา เตษามาติถฺยํ กฺฤตวานฺ, ปเร'หนิ ไต: สารฺทฺธํ ยาตฺรามกโรตฺ, ยาโผนิวาสินำ ภฺราตฺฤณำ กิยนฺโต ชนาศฺจ เตน สห คตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ปรสฺมินฺ ทิวเส ไกสริยานครมธฺยปฺรเวศสมเย กรฺณีลิโย ชฺญาติพนฺธูนฺ อาหูยานีย ตานฺ อเปกฺษฺย สฺถิต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ปิตเร คฺฤห อุปสฺถิเต กรฺณีลิยสฺตํ สากฺษาตฺกฺฤตฺย จรณโย: ปติตฺวา ปฺราณมตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ปิตรสฺตมุตฺถาปฺย กถิตวานฺ, อุตฺติษฺฐาหมปิ มานุษ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ตทา กรฺณีลิเยน สากมฺ อาลปนฺ คฺฤหํ ปฺราวิศตฺ ตนฺมเธฺย จ พหุโลกานำ สมาคมํ ทฺฤษฺฏฺวา ตานฺ อวทตฺ, ");
INSERT INTO santha_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","อนฺยชาตียโลไก: มหาลปนํ วา เตษำ คฺฤหมเธฺย ปฺรเวศนํ ยิหูทียานำ นิษิทฺธมฺ อสฺตีติ ยูยมฺ อวคจฺฉถ; กินฺตุ กมปิ มานุษมฺ อวฺยวหารฺยฺยมฺ อศุจึ วา ชฺญาตุํ มม โนจิตมฺ อิติ ปรเมศฺวโร มำ ชฺญาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","อิติ เหโตราหฺวานศฺรวณมาตฺราตฺ กาญฺจนาปตฺติมฺ อกฺฤตฺวา ยุษฺมากํ สมีปมฺ อาคโตสฺมิ; ปฺฤจฺฉามิ ยูยํ กินฺนิมิตฺตํ มามฺ อาหูยต? ");
INSERT INTO santha_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ตทา กรฺณีลิย: กถิตวานฺ, อทฺย จตฺวาริ ทินานิ ชาตานิ เอตาวเทฺวลำ ยาวทฺ อหมฺ อนาหาร อาสนฺ ตตสฺตฺฤตียปฺรหเร สติ คฺฤเห ปฺรารฺถนสมเย เตโชมยวสฺตฺรภฺฤทฺ เอโก ชโน มม สมกฺษํ ติษฺฐนฺ เอตำ กถามฺ อกถยตฺ, ");
INSERT INTO santha_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","เห กรฺณีลิย ตฺวทียา ปฺรารฺถนา อีศฺวรสฺย กรฺณโคจรีภูตา ตว ทานาทิ จ สากฺษิสฺวรูปํ ภูตฺวา ตสฺย ทฺฤษฺฏิโคจรมภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","อโต ยาโผนครํ ปฺรติ โลกานฺ ปฺรหิตฺย ตตฺร สมุทฺรตีเร ศิโมนฺนามฺน: กสฺยจิจฺจรฺมฺมการสฺย คฺฤเห ปฺรวาสการี ปิตรนามฺนา วิขฺยาโต ย: ศิโมนฺ ตมาหูाยย; ตต: ส อาคตฺย ตฺวามฺ อุปเทกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","อิติ การณาตฺ ตตฺกฺษณาตฺ ตว นิกเฏ โลกานฺ เปฺรษิตวานฺ, ตฺวมาคตวานฺ อิติ ภทฺรํ กฺฤตวานฺฯ อีศฺวโร ยานฺยาขฺยานานิ กถยิตุมฺ อาทิศตฺ ตานิ โศฺรตุํ วยํ สรฺเวฺว สามฺปฺรตมฺ อีศฺวรสฺย สากฺษาทฺ อุปสฺถิตา: สฺม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ตทา ปิตร อิมำ กถำ กถยิตุมฺ อารพฺธวานฺ, อีศฺวโร มนุษฺยาณามฺ อปกฺษปาตี สนฺ ");
INSERT INTO santha_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ยสฺย กสฺยจิทฺ เทศสฺย โย โลกาสฺตสฺมาทฺภีตฺวา สตฺกรฺมฺม กโรติ ส ตสฺย คฺราโหฺย ภวติ, เอตสฺย นิศฺจยมฺ อุปลพฺธวานหมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","สรฺเวฺวษำ ปฺรภุ โรฺย ยีศุขฺรีษฺฏเสฺตน อีศฺวร อิสฺราเยลฺวํศานำ นิกเฏ สุสํวาทํ เปฺรษฺย สมฺเมลนสฺย ยํ สํวาทํ ปฺราจารยตฺ ตํ สํวาทํ ยูยํ ศฺรุตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ยโต โยหนา มชฺชเน ปฺรจาริเต สติ ส คาลีลเทศมารภฺย สมสฺตยิหูทียเทศํ วฺยาปฺโนตฺ; ");
INSERT INTO santha_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ผลต อีศฺวเรณ ปวิเตฺรณาตฺมนา ศกฺตฺยา จาภิษิกฺโต นาสรตียยีศุ: สฺถาเน สฺถาเน ภฺรมนฺ สุกฺริยำ กุรฺวฺวนฺ ไศตานา กฺลิษฺฏานฺ สรฺวฺวโลกานฺ สฺวสฺถานฺ อกโรตฺ, ยต อีศฺวรสฺตสฺย สหาย อาสีตฺ; ");
INSERT INTO santha_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","วยญฺจ ยิหูทียเทเศ ยิรูศาลมฺนคเร จ เตน กฺฤตานำ สรฺเวฺวษำ กรฺมฺมณำ สากฺษิโณ ภวาม:ฯ โลกาสฺตํ กฺรุเศ วิทฺธฺวา หตวนฺต:, ");
INSERT INTO santha_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","กินฺตุ ตฺฤตียทิวเส อีศฺวรสฺตมุตฺถาปฺย สปฺรกาศมฺ อทรฺศยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","สรฺวฺวโลกานำ นิกฏ อิติ น หิ, กินฺตุ ตสฺมินฺ ศฺมศานาทุตฺถิเต สติ เตน สารฺทฺธํ โภชนํ ปานญฺจ กฺฤตวนฺต เอตาทฺฤศา อีศฺวรสฺย มโนนีตา: สากฺษิโณ เย วยมฺ อสฺมากํ นิกเฏ ตมทรฺศยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ชีวิตมฺฤโตภยโลกานำ วิจารํ กรฺตฺตุมฺ อีศฺวโร ยํ นิยุกฺตวานฺ ส เอว ส ชน:, อิมำ กถำ ปฺรจารยิตุํ ตสฺมินฺ ปฺรมาณํ ทาตุญฺจ โส'สฺมานฺ อาชฺญาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ยสฺตสฺมินฺ วิศฺวสิติ ส ตสฺย นามฺนา ปาปานฺมุกฺโต ภวิษฺยติ ตสฺมินฺ สรฺเวฺว ภวิษฺยทฺวาทิโนปิ เอตาทฺฤศํ สากฺษฺยํ ททติฯ ");
INSERT INTO santha_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ปิตรไสฺยตตฺกถากถนกาเล สรฺเวฺวษำ โศฺรตฺฤณามุปริ ปวิตฺร อาตฺมาวาโรหตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ตต: ปิตเรณ สารฺทฺธมฺ อาคตาสฺตฺวกฺเฉทิโน วิศฺวาสิโน โลกา อนฺยเทศีเยภฺย: ปวิตฺร อาตฺมนิ ทตฺเต สติ ");
INSERT INTO santha_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","เต นานาชาตียภาษาภิ: กถำ กถยนฺต อีศฺวรํ ปฺรศํสนฺติ, อิติ ทฺฤษฺฏฺวา ศฺรุตฺวา จ วิสฺมยมฺ อาปทฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ตทา ปิตร: กถิตวานฺ, วยมิว เย ปวิตฺรมฺ อาตฺมานํ ปฺราปฺตาเสฺตษำ ชลมชฺชนํ กึ โกปิ นิเษทฺธุํ ศกฺโนติ? ");
INSERT INTO santha_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ตต: ปฺรโภ รฺนามฺนา มชฺชิตา ภวเตติ ตานาชฺญาปยตฺฯ อนนฺตรํ เต ไสฺว: สารฺทฺธํ กติปยทินานิ สฺถาตุํ ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","อิตฺถํ ภินฺนเทศียโลกา อปีศฺวรสฺย วากฺยมฺ อคฺฤหฺลนฺ อิมำ วารฺตฺตำ ยิหูทียเทศสฺถเปฺรริตา ภฺราตฺฤคณศฺจ ศฺรุตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ตต: ปิตเร ยิรูศาลมฺนครํ คตวติ ตฺวกฺเฉทิโน โลกาเสฺตน สห วิวทมานา อวทนฺ, ");
INSERT INTO santha_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ตฺวมฺ อตฺวกฺเฉทิโลกานำ คฺฤหํ คตฺวา ไต: สารฺทฺธํ ภุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ตต: ปิตร อาทิต: กฺรมศสฺตตฺการฺยฺยสฺย สรฺวฺววฺฤตฺตานฺตมาขฺยาตุมฺ อารพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ยาโผนคร เอกทาหํ ปฺรารฺถยมาโน มูรฺจฺฉิต: สนฺ ทรฺศเนน จตุรฺษุ โกเณษุ ลมฺพนมานํ วฺฤหทฺวสฺตฺรมิว ปาตฺรเมกมฺ อากาศทวรุหฺย มนฺนิกฏมฺ อาคจฺฉทฺ อปศฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ปศฺจาตฺ ตทฺ อนนฺยทฺฤษฺฏฺยา ทฺฤษฺฏฺวา วิวิจฺย ตสฺย มเธฺย นานาปฺรการานฺ คฺรามฺยวนฺยปศูนฺ อุโรคามิเขจรำศฺจ ทฺฤษฺฏวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","เห ปิตร ตฺวมุตฺถาย คตฺวา ภุํกฺษฺว มำ สมฺโพธฺย กถยนฺตํ ศพฺทเมกํ ศฺรุตวำศฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ตโตหํ ปฺรตฺยวทํ, เห ปฺรโภ เนตฺถํ ภวตุ, ยต: กิญฺจน นิษิทฺธมฺ อศุจิ ทฺรวฺยํ วา มม มุขมธฺยํ กทาปิ น ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","อปรมฺ อีศฺวโร ยตฺ ศุจิ กฺฤตวานฺ ตนฺนิษิทฺธํ น ชานีหิ ทฺวิ รฺมามฺปฺรตีทฺฤศี วิหายสียา วาณี ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ตฺริริตฺถํ สติ ตตฺ สรฺวฺวํ ปุนรากาศมฺ อากฺฤษฺฏํฯ ");
INSERT INTO santha_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ปศฺจาตฺ ไกสริยานคราตฺ ตฺรโย ชนา มนฺนิกฏํ เปฺรษิตา ยตฺร นิเวศเน สฺถิโตหํ ตสฺมินฺ สมเย ตโตฺรปาติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ตทา นิ:สนฺเทหํ ไต: สารฺทฺธํ ยาตุมฺ อาตฺมา มามาทิษฺฏวานฺ; ตต: ปรํ มยา สไหเตษุ ษฑฺภฺราตฺฤษุ คเตษุ วยํ ตสฺย มนุชสฺย คฺฤหํ ปฺราวิศามฯ ");
INSERT INTO santha_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","โสสฺมากํ นิกเฏ กถาเมตามฺ อกถยตฺ เอกทา ทูต เอก: ปฺรตฺยกฺษีภูย มม คฺฤหมเธฺย ติษฺฏนฺ มามิตฺยาชฺญาปิตวานฺ, ยาโผนครํ ปฺรติ โลกานฺ ปฺรหิตฺย ปิตรนามฺนา วิขฺยาตํ ศิโมนมฺ อาหูยย; ");
INSERT INTO santha_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ตตสฺตว ตฺวทียปริวาราณาญฺจ เยน ปริตฺราณํ ภวิษฺยติ ตตฺ ส อุปเทกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","อหํ ตำ กถามุตฺถาปฺย กถิตวานฺ เตน ปฺรถมมฺ อสฺมากมฺ อุปริ ยถา ปวิตฺร อาตฺมาวรูฒวานฺ ตถา เตษามปฺยุปริ สมวรูฒวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","เตน โยหนฺ ชเล มชฺชิตวานฺ อิติ สตฺยํ กินฺตุ ยูยํ ปวิตฺร อาตฺมนิ มชฺชิตา ภวิษฺยถ, อิติ ยทฺวากฺยํ ปฺรภุรุทิตวานฺ ตตฺ ตทา มยา สฺมฺฤตมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","อต: ปฺรภา ยีศุขฺรีษฺเฏ ปฺรตฺยยการิโณ เย วยมฺ อสฺมภฺยมฺ อีศฺวโร ยทฺ ทตฺตวานฺ ตตฺ เตโภฺย โลเกโภฺยปิ ทตฺตวานฺ ตต: โกหํ? กิมหมฺ อีศฺวรํ วารยิตุํ ศกฺโนมิ? ");
INSERT INTO santha_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","กถาเมตำ ศฺรุวา เต กฺษานฺตา อีศฺวรสฺย คุณานฺ อนุกีรฺตฺตฺย กถิตวนฺต:, ตรฺหิ ปรมายุ:ปฺราปฺตินิมิตฺตมฺ อีศฺวโรนฺยเทศียโลเกโภฺยปิ มน:ปริวรฺตฺตนรูปํ ทานมฺ อทาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","สฺติผานํ ปฺรติ อุปทฺรเว ฆฏิเต เย วิกีรฺณา อภวนฺ ไต ไผนีกีกุปฺรานฺติยขิยาสุ ภฺรมิตฺวา เกวลยิหูทียโลกานฺ วินา กสฺยาปฺยนฺยสฺย สมีป อีศฺวรสฺย กถำ น ปฺราจารยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","อปรํ เตษำ กุปฺรียา: กุรีนียาศฺจ กิยนฺโต ชนา อานฺติยขิยานครํ คตฺวา ยูนานียโลกานำ สมีเปปิ ปฺรโภรฺยีโศ: กถำ ปฺราจารยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ปฺรโภ: กรเสฺตษำ สหาย อาสีตฺ ตสฺมาทฺ อเนเก โลกา วิศฺวสฺย ปฺรภุํ ปฺรติ ปราวรฺตฺตนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","อิติ วารฺตฺตายำ ยิรูศาลมสฺถมณฺฑลียโลกานำ กรฺณโคจรีภูตายามฺ อานฺติยขิยานครํ คนฺตุ เต พรฺณพฺพำ ไปฺรรยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ตโต พรฺณพฺพาสฺตตฺร อุปสฺถิต: สนฺ อีศฺวรสฺยานุคฺรหสฺย ผลํ ทฺฤษฺฏฺวา สานนฺโท ชาต:, ");
INSERT INTO santha_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ส สฺวยํ สาธุ รฺวิศฺวาเสน ปวิเตฺรณาตฺมนา จ ปริปูรฺณ: สนฺ คโนนิษฺฏยา ปฺรภาวาสฺถำ กรฺตฺตุํ สรฺวฺวานฺ อุปทิษฺฏวานฺ เตน ปฺรโภ: ศิษฺยา อเนเก พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","เศเษ เศาลํ มฺฤคยิตุํ พรฺณพฺพาสฺตารฺษนครํ ปฺรสฺถิตวานฺฯ ตตฺร ตโสฺยทฺเทศํ ปฺราปฺย ตมฺ อานฺติยขิยานครมฺ อานยตฺ; ");
INSERT INTO santha_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ตตเสฺตา มณฺฑลีสฺถโลไก: สภำ กฺฤตฺวา สํวตฺสรเมกํ ยาวทฺ พหุโลกานฺ อุปาทิศตำ; ตสฺมินฺ อานฺติยขิยานคเร ศิษฺยา: ปฺรถมํ ขฺรีษฺฏียนามฺนา วิขฺยาตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ตต: ปรํ ภวิษฺยทฺวาทิคเณ ยิรูศาลม อานฺติยขิยานครมฺ อาคเต สติ ");
INSERT INTO santha_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","อาคาพนามา เตษาเมก อุตฺถาย อาตฺมน: ศิกฺษยา สรฺวฺวเทเศ ทุรฺภิกฺษํ ภวิษฺยตีติ ชฺญาปิตวานฺ; ตต: เกฺลาทิยไกสรสฺยาธิกาเร สติ ตตฺ ปฺรตฺยกฺษมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ตสฺมาตฺ ศิษฺยา เอไกกศ: สฺวสฺวศกฺตฺยนุสารโต ยิหูทียเทศนิวาสินำ ภฺรตฺฤณำ ทินยาปนารฺถํ ธนํ เปฺรษยิตุํ นิศฺจิตฺย ");
INSERT INTO santha_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","พรฺณพฺพาเศาลโย รฺทฺวารา ปฺราจีนโลกานำ สมีปํ ตตฺ เปฺรษิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ตสฺมินฺ สมเย เหโรทฺราโช มณฺฑลฺยา: กิยชฺชเนโภฺย ทุ:ขํ ทาตุํ ปฺรารภตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","วิเศษโต โยหน: โสทรํ ยากูพํ กรวาลาฆาเตนฺ หตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ตสฺมาทฺ ยิหูทียา: สนฺตุษฺฏา อภวนฺ อิติ วิชฺญาย ส ปิตรมปิ ธรฺตฺตุํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ตทา กิณฺวศูนฺยปูโปตฺสวสมย อุปาติษฺฏตฺ; อต อุตฺสเว คเต สติ โลกานำ สมกฺษํ ตํ พหิราเนยฺยามีติ มนสิ สฺถิรีกฺฤตฺย ส ตํ ธารยิตฺวา รกฺษฺณารฺถมฺ เยษามฺ เอไกกสํเฆ จตฺวาโร ชนา: สนฺติ เตษำ จตุรฺณำ รกฺษกสํฆานำ สมีเป ตํ สมรฺปฺย การายำ สฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","กินฺตุํ ปิตรสฺย การาสฺถิติการณาตฺ มณฺฑลฺยา โลกา อวิศฺรามมฺ อีศฺวรสฺย สมีเป ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","อนนฺตรํ เหโรทิ ตํ พหิรานายิตุํ อุทฺยเต สติ ตสฺยำ ราเตฺรา ปิตโร รกฺษกทฺวยมธฺยสฺถาเน ศฺฤงฺขลทฺวเยน พทฺธฺว: สนฺ นิทฺริต อาสีตฺ, เทาวาริกาศฺจ การายา: สมฺมุเข ติษฺฐนโต ทฺวารมฺ อรกฺษิษุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","เอตสฺมินฺ สมเย ปรเมศฺวรสฺย ทูเต สมุปสฺถิเต การา ทีปฺติมตี ชาตา; ตต: ส ทูต: ปิตรสฺย กุกฺษาวาวาตํ กฺฤตฺวา ตํ ชาครยิตฺวา ภาษิตวานฺ ตูรฺณมุตฺติษฺฐ; ตตสฺตสฺย หสฺตสฺถศฺฤงฺขลทฺวยํ คลตฺ ปติตํฯ ");
INSERT INTO santha_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ส ทูตสฺตมวทตฺ, พทฺธกฏิ: สนฺ ปาทโย: ปาทุเก อรฺปย; เตน ตถา กฺฤเต สติ ทูตสฺตมฺ อุกฺตวานฺ คาตฺรียวสฺตฺรํ คาเตฺร นิธาย มม ปศฺจาทฺ เอหิฯ ");
INSERT INTO santha_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ตต: ปิตรสฺตสฺย ปศฺจาทฺ วฺรชน พหิรคจฺฉตฺ, กินฺตุ ทูเตน กรฺมฺไมตตฺ กฺฤตมิติ สตฺยมชฺญาตฺวา สฺวปฺนทรฺศนํ ชฺญาตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","อิตฺถํ เตา ปฺรถมำ ทฺวิตียาญฺจ การำ ลงฺฆิตฺวา เยน เลาหนิรฺมฺมิตทฺวาเรณ นครํ คมฺยเต ตตฺสมีปํ ปฺราปฺนุตำ; ตตสฺตสฺย กวาฏํ สฺวยํ มุกฺตมภวตฺ ตตเสฺตา ตตฺสฺถานาทฺ พหิ รฺภูตฺวา มารฺไคกสฺย สีมำ ยาวทฺ คเตา; ตโต'กสฺมาตฺ ส ทูต: ปิตรํ ตฺยกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ตทา ส เจตนำ ปฺราปฺย กถิตวานฺ นิชทูตํ ปฺรหิตฺย ปรเมศฺวโร เหโรโท หสฺตาทฺ ยิหูทียโลกานำ สรฺวฺวาศายาศฺจ มำ สมุทฺธฺฤตวานฺ อิตฺยหํ นิศฺจยํ ชฺญาตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ส วิวิจฺย มารฺกนามฺรา วิขฺยาตสฺย โยหโน มาตุ รฺมริยโม ยสฺมินฺ คฺฤเห พหว: สมฺภูย ปฺรารฺถยนฺต ตนฺนิเวศนํ คต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ปิตเรณ พหิรฺทฺวาร อาหเต สติ โรทานามา พาลิกา ทฺรษฺฏุํ คตาฯ ");
INSERT INTO santha_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ตต: ปิตรสฺย สฺวรํ ศฺรุวา สา หรฺษยุกฺตา สตี ทฺวารํ น โมจยิตฺวา ปิตโร ทฺวาเร ติษฺฐตีติ วารฺตฺตำ วกฺตุมฺ อภฺยนฺตรํ ธาวิตฺวา คตวตีฯ ");
INSERT INTO santha_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","เต ปฺราโวจนฺ ตฺวมุนฺมตฺตา ชาตาสิ กินฺตุ สา มุหุรฺมุหุรุกฺตวตี สตฺยเมไวตตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ตทา เต กถิตวนฺตสฺตรฺหิ ตสฺย ทูโต ภเวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ปิตโร ทฺวารมาหตวานฺ เอตสฺมินฺนนฺตเร ทฺวารํ โมจยิตฺวา ปิตรํ ทฺฤษฺฏฺวา วิสฺมยํ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ตต: ปิตโร นิ:ศพฺทํ สฺถาตุํ ตานฺ ปฺรติ หเสฺตน สงฺเกตํ กฺฤตฺวา ปรเมศฺวโร เยน ปฺรกาเรณ ตํ การายา อุทฺธฺฤตฺยานีตวานฺ ตสฺย วฺฤตฺตานฺตํ ตานชฺญาปยตฺ, ยูยํ คตฺวา ยากุพํ ภฺราตฺฤคณญฺจ วารฺตฺตาเมตำ วทเตตฺยุกฺตา สฺถานานฺตรํ ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ปฺรภาเต สติ ปิตร: กฺว คต อิตฺยตฺร รกฺษกาณำ มเธฺย มหานฺ กลโห ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","เหโรทฺ พหุ มฺฤคยิตฺวา ตโสฺยทฺเทเศ น ปฺราปฺเต สติ รกฺษกานฺ สํปฺฤจฺฉฺย เตษำ ปฺราณานฺ หนฺตุมฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ปศฺจาตฺ ส ยิหูทียปฺรเทศาตฺ ไกสริยานครํ คตฺวา ตตฺราวาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","โสรสีโทนเทศโย โรฺลเกโภฺย เหโรทิ ยุยุตฺเสา สติ เต สรฺวฺว เอกมนฺตฺรณา: สนฺตสฺตสฺย สมีป อุปสฺถาย ลฺวาสฺตนามานํ ตสฺย วสฺตฺรคฺฤหาธีศํ สหายํ กฺฤตฺวา เหโรทา สารฺทฺธํ สนฺธึ ปฺรารฺถยนฺต ยตสฺตสฺย ราชฺโญ เทเศน เตษำ เทศียานำ ภรณมฺ อภวตฺํ ");
INSERT INTO santha_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","อต: กุตฺรจินฺ นิรุปิตทิเน เหโรทฺ ราชกียํ ปริจฺฉทํ ปริธาย สึหาสเน สมุปวิศฺย ตานฺ ปฺรติ กถามฺ อุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ตโต โลกา อุจฺไจ:การํ ปฺรตฺยวทนฺ, เอษ มนุชรโว น หิ, อีศฺวรียรว:ฯ ");
INSERT INTO santha_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ตทา เหโรทฺ อีศฺวรสฺย สมฺมานํ นากโรตฺ; ตสฺมาทฺเธโต: ปรเมศฺวรสฺย ทูโต หฐาตฺ ตํ ปฺราหรตฺ เตไนว ส กีไฏ: กฺษีณ: สนฺ ปฺราณานฺ อชหาตฺฯ กินฺตฺวีศฺวรสฺย กถา เทศํ วฺยาปฺย ปฺรพลาภวตฺฯ ตต: ปรํ พรฺณพฺพาเศาเลา ยสฺย กรฺมฺมโณ ภารํ ปฺราปฺนุตำ ตาภฺยำ ตสฺมินฺ สมฺปาทิเต สติ มารฺกนามฺนา วิขฺยาโต โย โยหนฺ ตํ สงฺคินํ กฺฤตฺวา ยิรูศาลมฺนคราตฺ ปฺรตฺยาคเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","อปรญฺจ พรฺณพฺพา:, ศิโมนฺ ยํ นิคฺรํ วทนฺติ, กุรีนียลูกิโย เหโรทา ราชฺญา สห กฺฤตวิทฺยาाภฺยาโส มินเหมฺ, เศาลศฺไจเต เย กิยนฺโต ชนา ภวิษฺยทฺวาทิน อุปเทษฺฏารศฺจานฺติยขิยานครสฺถมณฺฑลฺยามฺ อาสนฺ, ");
INSERT INTO santha_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","เต ยโทปวาสํ กฺฤเตฺวศฺวรมฺ อเสวนฺต ตสฺมินฺ สมเย ปวิตฺร อาตฺมา กถิตวานฺ อหํ ยสฺมินฺ กรฺมฺมณิ พรฺณพฺพาไศเลา นิยุกฺตวานฺ ตตฺกรฺมฺม กรฺตฺตุํ เตา ปฺฤถกฺ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ตตไสฺตรุปวาสปฺรารฺถนโย: กฺฤตโย: สโตเสฺต ตโย รฺคาตฺรโย รฺหสฺตารฺปณํ กฺฤตฺวา เตา วฺยสฺฤชนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ตต: ปรํ เตา ปวิเตฺรณาตฺมนา เปฺรริเตา สนฺเตา สิลูกิยานครมฺ อุปสฺถาย สมุทฺรปเถน กุโปฺรปทฺวีปมฺ อคจฺฉตำฯ ");
INSERT INTO santha_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ตต: สาลามีนครมฺ อุปสฺถาย ตตฺร ยิหูทียานำ ภชนภวนานิ คเตฺวศฺวรสฺย กถำ ปฺราจารยตำ; โยหนปิ ตตฺสหจโร'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","อิตฺถํ เต ตโสฺยปทฺวีปสฺย สรฺวฺวตฺร ภฺรมนฺต: ปาผนครมฺ อุปสฺถิตา:; ตตฺร สุวิเวจเกน สรฺชิยเปาลนามฺนา ตทฺเทศาธิปตินา สห ภวิษฺยทฺวาทิโน เวศธารี พรฺยีศุนามา โย มายาวี ยิหูที อาสีตฺ ตํ สากฺษาตฺ ปฺราปฺตวต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ตทฺเทศาธิป อีศฺวรสฺย กถำ โศฺรตุํ วาญฺฉนฺ เปาลพรฺณพฺเพา นฺยมนฺตฺรยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","กินฺตฺวิลุมา ยํ มายาวินํ วทนฺติ ส เทศาธิปตึ ธรฺมฺมมารฺคาทฺ พหิรฺภูตํ กรฺตฺตุมฺ อยตตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ตสฺมาตฺ โศโล'รฺถาตฺ เปาล: ปวิเตฺรณาตฺมนา ปริปูรฺณ: สนฺ ตํ มายาวินํ ปฺรตฺยนนฺยทฺฤษฺฏึ กฺฤตฺวากถยตฺ, ");
INSERT INTO santha_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","เห นรกินฺ ธรฺมฺมเทฺวษินฺ เกาฏิลฺยทุษฺกรฺมฺมปริปูรฺณ, ตฺวํ กึ ปฺรโภ: สตฺยปถสฺย วิปรฺยฺยยกรณาตฺ กทาปิ น นิวรฺตฺติษฺยเส? ");
INSERT INTO santha_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","อธุนา ปรเมศฺวรสฺตว สมุจิตํ กริษฺยติ เตน กติปยทินานิ ตฺวมฺ อนฺธ: สนฺ สูรฺยฺยมปิ น ทฺรกฺษฺยสิฯ ตตฺกฺษณาทฺ ราตฺริวทฺ อนฺธการสฺตสฺย ทฺฤษฺฏิมฺ อาจฺฉาทิตวานฺ; ตสฺมาตฺ ตสฺย หสฺตํ ธรฺตฺตุํ ส โลกมนฺวิจฺฉนฺ อิตสฺตโต ภฺรมณํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","เอนำ ฆฏนำ ทฺฤษฺฏฺวา ส เทศาธิปติ: ปฺรภูปเทศาทฺ วิสฺมิตฺย วิศฺวาสํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ตทนนฺตรํ เปาลสฺตตฺสงฺคิเนา จ ปาผนคราตฺ โปฺรตํ จาลยิตฺวา ปมฺผุลิยาเทศสฺย ปรฺคีนครมฺ อคจฺฉนฺ กินฺตุ โยหนฺ ตโย: สมีปาทฺ เอตฺย ยิรูศาลมํ ปฺรตฺยาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ปศฺจาตฺ เตา ปรฺคีโต ยาตฺรำ กฺฤตฺวา ปิสิทิยาเทศสฺย อานฺติยขิยานครมฺ อุปสฺถาย วิศฺรามวาเร ภชนภวนํ ปฺรวิศฺย สมุปาวิศตำฯ ");
INSERT INTO santha_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","วฺยวสฺถาภวิษฺยทฺวากฺยโย: ปฐิตโย: สโต เรฺห ภฺราตเรา โลกานฺ ปฺรติ ยุวโย: กาจิทฺ อุปเทศกถา ยทฺยสฺติ ตรฺหิ ตำ วทตํ เตา ปฺรติ ตสฺย ภชนภวนสฺยาธิปตย: กถามฺ เอตำ กถยิตฺวา ไปฺรษยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","อต: เปาล อุตฺติษฺฐนฺ หเสฺตน สงฺเกตํ กุรฺวฺวนฺ กถิตวานฺ เห อิสฺราเยลียมนุษฺยา อีศฺวรปรายณา: สรฺเวฺว โลกา ยูยมฺ อวธทฺธํฯ ");
INSERT INTO santha_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","เอเตษามิสฺราเยโลฺลกานามฺ อีศฺวโร'สฺมากํ ปูรฺวฺวปรุษานฺ มโนนีตานฺ กตฺวา คฺฤหีตวานฺ ตโต มิสริ เทเศ ปฺรวสนกาเล เตษามุนฺนตึ กฺฤตฺวา ตสฺมาตฺ สฺวียพาหุพเลน ตานฺ พหิ: กฺฤตฺวา สมานยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","จตฺวารึศทฺวตฺสรานฺ ยาวจฺจ มหาปฺรานฺตเร เตษำ ภรณํ กฺฤตฺวา ");
INSERT INTO santha_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","กินานฺเทศานฺตรฺวฺวรฺตฺตีณิ สปฺตราชฺยานิ นาศยิตฺวา คุฏิกาปาเตน เตษุ สรฺวฺวเทเศษุ เตโภฺย'ธิการํ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ปญฺจาศทธิกจตุ:ศเตษุ วตฺสเรษุ คเตษุ จ ศิมูเยลฺภวิษฺยทฺวาทิปรฺยฺยนฺตํ เตษามุปริ วิจารยิตฺฤนฺ นิยุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ไตศฺจ ราชฺญิ ปฺรารฺถิเต, อีศฺวโร พินฺยามีโน วํศชาตสฺย กีศ: ปุตฺรํ เศาลํ จตฺวารึศทฺวรฺษปรฺยฺยนฺตํ เตษามุปริ ราชานํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ปศฺจาตฺ ตํ ปทจฺยุตํ กฺฤตฺวา โย มทิษฺฏกฺริยา: สรฺวฺวา: กริษฺยติ ตาทฺฤศํ มม มโนภิมตมฺ เอกํ ชนํ ยิศย: ปุตฺรํ ทายูทํ ปฺราปฺตวานฺ อิทํ ปฺรมาณํ ยสฺมินฺ ทายูทิ ส ทตฺตวานฺ ตํ ทายูทํ เตษามุปริ ราชตฺวํ กรฺตฺตุมฺ อุตฺปาทิตวานฯ ");
INSERT INTO santha_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ตสฺย สฺวปฺรติศฺรุตสฺย วากฺยสฺยานุสาเรณ อิสฺราเยโลฺลกานำ นิมิตฺตํ เตษำ มนุษฺยาณำ วํศาทฺ อีศฺวร เอกํ ยีศุํ (ตฺราตารมฺ) อุทปาทยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ตสฺย ปฺรกาศนาตฺ ปูรฺวฺวํ โยหนฺ อิสฺราเยโลฺลกานำ สนฺนิเธา มน:ปราวรฺตฺตนรูปํ มชฺชนํ ปฺราจารยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ยสฺย จ กรฺมฺมโณे ภารํ ปฺรปฺตวานฺ โยหนฺ ตนฺ นิษฺปาทยนฺ เอตำ กถำ กถิตวานฺ, ยูยํ มำ กํ ชนํ ชานีถ? อหมฺ อภิษิกฺตตฺราตา นหิ, กินฺตุ ปศฺยต ยสฺย ปาทโย: ปาทุกโย รฺพนฺธเน โมจยิตุมปิ โยโคฺย น ภวามิ ตาทฺฤศ เอโก ชโน มม ปศฺจาทฺ อุปติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","เห อิพฺราหีโม วํศชาตา ภฺราตโร เห อีศฺวรภีตา: สรฺวฺวโลกา ยุษฺมานฺ ปฺรติ ปริตฺราณสฺย กไถษา เปฺรริตาฯ ");
INSERT INTO santha_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ยิรูศาลมฺนิวาสินเสฺตษามฺ อธิปตยศฺจ ตสฺย ยีโศ: ปริจยํ น ปฺราปฺย ปฺรติวิศฺรามวารํ ปฐฺยมานานำ ภวิษฺยทฺวาทิกถานามฺ อภิปฺรายมฺ อพุทฺธฺวา จ ตสฺย วเธน ตา: กถา: สผลา อกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ปฺราณหนนสฺย กมปิ เหตุมฺ อปฺราปฺยาปิ ปีลาตสฺย นิกเฏ ตสฺย วธํ ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ตสฺมินฺ ยา: กถา ลิขิตา: สนฺติ ตทนุสาเรณ กรฺมฺม สมฺปาทฺย ตํ กฺรุศาทฺ อวตารฺยฺย ศฺมศาเน ศายิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","กินฺตฺวีศฺวร: ศฺมศานาตฺ ตมุทสฺถาปยตฺ, ");
INSERT INTO santha_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ปุนศฺจ คาลีลปฺรเทศาทฺ ยิรูศาลมนครํ เตน สารฺทฺธํ เย โลกา อาคจฺฉนฺ ส พหุทินานิ เตโภฺย ทรฺศนํ ทตฺตวานฺ, อตสฺต อิทานีํ โลกานฺ ปฺรติ ตสฺย สากฺษิณ: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","อสฺมากํ ปูรฺวฺวปุรุษาณำ สมกฺษมฺ อีศฺวโร ยสฺมินฺ ปฺรติชฺญาตวานฺ ยถา, ตฺวํ เม ปุโตฺรสิ จาทฺย ตฺวำ สมุตฺถาปิตวานหมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","อิทํ ยทฺวจนํ ทฺวิตียคีเต ลิขิตมาเสฺต ตทฺ ยีโศรุตฺถาเนน เตษำ สนฺตานา เย วยมฺ อสฺมากํ สนฺนิเธา เตน ปฺรตฺยกฺษี กฺฤตํ, ยุษฺมานฺ อิมํ สุสํวาทํ ชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ปรเมศฺวเรณ ศฺมศานาทฺ อุตฺถาปิตํ ตทียํ ศรีรํ กทาปิ น เกฺษษฺยเต, เอตสฺมินฺ ส สฺวยํ กถิตวานฺ ยถา ทายูทํ ปฺรติ ปฺรติชฺญาโต โย วรสฺตมหํ ตุภฺยํ ทาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","เอตทนฺยสฺมินฺ คีเต'ปิ กถิตวานฺฯ สฺวกียํ ปุณฺยวนฺตํ ตฺวํ กฺษยิตุํ น จ ทาสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ทายูทา อีศฺวราภิมตเสวาไย นิชายุษิ วฺยยิเต สติ ส มหานิทฺรำ ปฺราปฺย นิไช: ปูรฺวฺวปุรุไษ: สห มิลิต: สนฺ อกฺษียต; ");
INSERT INTO santha_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","กินฺตุ ยมีศฺวร: ศฺมศานาทฺ อุทสฺถาปยตฺ ส นากฺษียตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","อโต เห ภฺราตร:, อเนน ชเนน ปาปโมจนํ ภวตีติ ยุษฺมานฺ ปฺรติ ปฺรจาริตมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ผลโต มูสาวฺยวสฺถยา ยูยํ เยโภฺย โทเษโภฺย มุกฺตา ภวิตุํ น ศกฺษฺยถ เตภฺย: สรฺวฺวโทเษภฺย เอตสฺมินฺ ชเน วิศฺวาสิน: สรฺเวฺว มุกฺตา ภวิษฺยนฺตีติ ยุษฺมาภิ รฺชฺญายตำฯ ");
INSERT INTO santha_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","อปรญฺจฯ อวชฺญาการิโณ โลกาศฺจกฺษุรุนฺมีลฺย ปศฺยตฯ ตไถวาสมฺภวํ ชฺญาตฺวา สฺยาต ยูยํ วิลชฺชิตา:ฯ ยโต ยุษฺมาสุ ติษฺฐตฺสุ กริเษฺย กรฺมฺม ตาทฺฤศํฯ เยไนว ตสฺย วฺฤตฺตานฺเต ยุษฺมภฺยํ กถิเต'ปิ หิฯ ยูยํ น ตนฺตุ วฺฤตฺตานฺตํ ปฺรเตฺยษฺยถ กทาจน๚ ");
INSERT INTO santha_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","เยยํ กถา ภวิษฺยทฺวาทินำ คฺรนฺเถษุ ลิขิตาเสฺต สาวธานา ภวต ส กถา ยถา ยุษฺมานฺ ปฺรติ น ฆฏเตฯ ");
INSERT INTO santha_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ยิหูทียภชนภวนานฺ นิรฺคตโยสฺตโย รฺภินฺนเทศีไย รฺวกฺษฺยมาณา ปฺรารฺถนา กฺฤตา, อาคามินิ วิศฺรามวาเร'ปิ กเถยมฺ อสฺมานฺ ปฺรติ ปฺรจาริตา ภวตฺวิติฯ ");
INSERT INTO santha_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","สภายา ภงฺเค สติ พหโว ยิหูทียโลกา ยิหูทียมตคฺราหิโณ ภกฺตโลกาศฺจ พรฺณพฺพาเปาลโย: ปศฺจาทฺ อาคจฺฉนฺ, เตน เตา ไต: สห นานากถา: กถยิเตฺวศฺวรานุคฺรหาศฺรเย สฺถาตุํ ตานฺ ปฺราวรฺตฺตยตำฯ ");
INSERT INTO santha_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ปรวิศฺรามวาเร นครสฺย ปฺราเยณ สรฺเวฺว ลากา อีศฺวรียำ กถำ โศฺรตุํ มิลิตา:, ");
INSERT INTO santha_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","กินฺตุ ยิหูทียโลกา ชนนิวหํ วิโลกฺย อีรฺษฺยยา ปริปูรฺณา: สนฺโต วิปรีตกถากถเนเนศฺวรนินฺทยา จ เปาเลโนกฺตำ กถำ ขณฺฑยิตุํ เจษฺฏิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ตต: เปาैลพรฺณพฺพาวกฺโษเภา กถิตวนฺเตา ปฺรถมํ ยุษฺมากํ สนฺนิธาวีศฺวรียกถายา: ปฺรจารณมฺ อุจิตมาสีตฺ กินฺตุํ ตทคฺราหฺยตฺวกรเณน ยูยํ สฺวานฺ อนนฺตายุโษ'โยคฺยานฺ ทรฺศยถ, เอตตฺการณาทฺ วยมฺ อนฺยเทศียโลกานำ สมีปํ คจฺฉาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ปฺรภุรสฺมานฺ อิตฺถมฺ อาทิษฺฏวานฺ ยถา, ยาวจฺจ ชคต: สีมำ โลกานำ ตฺราณการณาตฺฯ มยานฺยเทศมเธฺย ตฺวํ สฺถาปิโต ภู: ปฺรทีปวตฺ๚ ");
INSERT INTO santha_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ตทา กถามีทฺฤศีํ ศฺรุตฺวา ภินฺนเทศียา อาหฺลาทิตา: สนฺต: ปฺรโภ: กถำ ธนฺยำ ธนฺยามฺ อวทนฺ, ยาวนฺโต โลกาศฺจ ปรมายุ: ปฺราปฺตินิมิตฺตํ นิรูปิตา อาสนฺ เตे วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","อิตฺถํ ปฺรโภ: กถา สรฺเวฺวเทศํ วฺยาปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","กินฺตุ ยิหูทียา นครสฺย ปฺรธานปุรุษานฺ สมฺมานฺยา: กถิปยา ภกฺตา โยษิตศฺจ กุปฺรวฺฤตฺตึ คฺราหยิตฺวา เปาลพรฺณพฺเพา ตาฑยิตฺวา ตสฺมาตฺ ปฺรเทศาทฺ ทูรีกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","อต: การณาตฺ เตา นิชปทธูลีเสฺตษำ ปฺราติกูเลฺยน ปาตยิเตฺวेกนิยํ นครํ คเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ตต: ศิษฺยคณ อานนฺเทน ปวิเตฺรณาตฺมนา จ ปริปูรฺโณภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","เตา เทฺวา ชเนา ยุคปทฺ อิกนิยนครสฺถยิหูทียานำ ภชนภวนํ คตฺวา ยถา พหโว ยิหูทียา อนฺยเทेศียโลกาศฺจ วฺยศฺวสนฺ ตาทฺฤศีํ กถำ กถิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","กินฺตุ วิศฺวาสหีนา ยิหูทียา อนฺยเทศียโลกานฺ กุปฺรวฺฤตฺตึ คฺราหยิตฺวา ภฺราตฺฤคณํ ปฺรติ เตษำ ไวรํ ชนิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","อต: สฺวานุคฺรหกถายา: ปฺรมาณํ ทตฺวา ตโย รฺหไสฺต รฺพหุลกฺษณมฺ อทฺภุตกรฺมฺม จ ปฺรากาศยทฺ ย: ปฺรภุสฺตสฺย กถา อกฺโษเภน ปฺรจารฺยฺย เตา ตตฺร พหุทินานิ สมวาติษฺเฐตำฯ ");
INSERT INTO santha_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","กินฺตุ กิยนฺโต โลกา ยิหูทียานำ สปกฺษา: กิยนฺโต โลกา: เปฺรริตานำ สปกฺษา ชาตา:, อโต นาคริกชนนิวหมเธฺย ภินฺนวากฺยตฺวมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","อนฺยเทศียา ยิหูทียาเสฺตษามฺ อธิปตยศฺจ เทาราตฺมฺยํ กุตฺวา เตา ปฺรสฺตไรราหนฺตุมฺ อุทฺยตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","เตา ตทฺวารฺตฺตำ ปฺราปฺย ปลายิตฺวา ลุกายนิยาเทศสฺยานฺตรฺวฺวรฺตฺติลุสฺตฺราทรฺพฺโพ ");
INSERT INTO santha_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ตตฺสมีปสฺถเทศญฺจ คตฺวา ตตฺร สุสํวาทํ ปฺรจารยตำฯ ");
INSERT INTO santha_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ตโตฺรภยปาทโยศฺจลนศกฺติหีโน ชนฺมารภฺย ขญฺช: กทาปิ คมนํ นากโรตฺ เอตาทฺฤศ เอโก มานุโษ ลุสฺตฺรานคร อุปวิศฺย เปาลสฺย กถำ ศฺรุตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","เอตสฺมินฺ สมเย เปาลสฺตมฺปฺรติ ทฺฤษฺฏึ กฺฤตฺวา ตสฺย สฺวาสฺเถฺย วิศฺวาสํ วิทิตฺวา โปฺรจฺไจ: กถิตวานฺ ");
INSERT INTO santha_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ปทฺภฺยามุตฺติษฺฐนฺ ฤชุ รฺภวฯ ตต: ส อุลฺลมฺผํ กฺฤตฺวา คมนาคมเน กุตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ตทา โลกา: เปาลสฺย ตตฺ การฺยฺยํ วิโลกฺย ลุกายนียภาษยา โปฺรจฺไจ: กถาเมตำ กถิตวนฺต:, เทวา มนุษฺยรูปํ ธฺฤตฺวาสฺมากํ สมีปมฺ อวาโรหนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","เต พรฺณพฺพำ ยูปิตรมฺ อวทนฺ เปาลศฺจ มุโขฺย วกฺตา ตสฺมาตฺ ตํ มรฺกุริยมฺ อวทนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ตสฺย นครสฺย สมฺมุเข สฺถาปิตสฺย ยูปิตรวิคฺรหสฺย ยาชโก วฺฤษานฺ ปุษฺปมาลาศฺจ ทฺวารสมีปมฺ อานีย โลไก: สรฺทฺธํ ตาวุทฺทิศฺย สมุตฺสฺฤชฺย ทาตุมฺ อุทฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ตทฺวารฺตฺตำ ศฺรุตฺวา พรฺณพฺพาเปาเลา สฺวียวสฺตฺราณิ ฉิตฺวา โลกานำ มธฺยํ เวเคน ปฺรวิศฺย โปฺรจฺไจ: กถิตวนฺเตา, ");
INSERT INTO santha_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","เห มเหจฺฉา: กุต เอตาทฺฤศํ กรฺมฺม กุรุถ? อาวามปิ ยุษฺมาทฺฤเศา สุขทุ:ขโภคิเนา มนุเษฺยา, ยุยมฺ เอตา: สรฺวฺวา วฺฤถากลฺปนา: ปริตฺยชฺย ยถา คคณวสุนฺธราชลนิธีนำ ตนฺมธฺยสฺถานำ สรฺเวฺวษาญฺจ สฺรษฺฏารมมรมฺ อีศฺวรํ ปฺรติ ปราวรฺตฺตเธฺว ตทรฺถมฺ อาวำ ยุษฺมากํ สนฺนิเธา สุสํวาทํ ปฺรจารยาว:ฯ ");
INSERT INTO santha_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ส อีศฺวร: ปูรฺวฺวกาเล สรฺวฺวเทศียโลกานฺ สฺวสฺวมารฺเค จลิตุมนุมตึ ทตฺตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ตถาปิ อากาศาตฺ โตยวรฺษเณน นานาปฺรการศโสฺยตฺปตฺยา จ ยุษฺมากํ หิไตษี สนฺ ภกฺไษฺยรานนเทน จ ยุษฺมากมฺ อนฺต:กรณานิ ตรฺปยนฺ ตานิ ทานานิ นิชสากฺษิสฺวรูปาณิ สฺถปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","กินฺตุ ตาทฺฤศายำ กถายำ กถิตายามปิ ตโย: สมีป อุตฺสรฺชนาตฺ โลกนิวหํ ปฺราเยณ นิวรฺตฺตยิตุํ นาศกฺนุตามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","อานฺติยขิยา-อิกนิยนคราภฺยำ กติปยยิหูทียโลกา อาคตฺย โลกานฺ ปฺราวรฺตฺตยนฺต ตสฺมาตฺ ไต เปาลํ ปฺรสฺตไรราฆฺนนฺ เตน ส มฺฤต อิติ วิชฺญาย นครสฺย พหิสฺตมฺ อากฺฤษฺย นีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","กินฺตุ ศิษฺยคเณ ตสฺย จตุรฺทิศิ ติษฺฐติ สติ ส สฺวยมฺ อุตฺถาย ปุนรปิ นครมธฺยํ ปฺราวิศตฺ ตตฺปเร'หนิ พรฺณพฺพาสหิโต ทรฺพฺพีนครํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ตตฺร สุสํวาทํ ปฺรจารฺยฺย พหุโลกานฺ ศิษฺยานฺ กฺฤตฺวา เตา ลุสฺตฺรามฺ อิกนิยมฺ อานฺติยขิยาญฺจ ปราวฺฤตฺย คเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","พหุทุ:ขานิ ภุกฺตฺวาปีศฺวรราชฺยํ ปฺรเวษฺฏวฺยมฺ อิติ การณาทฺ ธรฺมฺมมารฺเค สฺถาตุํ วินยํ กฺฤตฺวา ศิษฺยคณสฺย มน:ไสฺถรฺยฺยมฺ อกุรุตำฯ ");
INSERT INTO santha_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","มณฺฑลีนำ ปฺราจีนวรฺคานฺ นิยุชฺย ปฺรารฺถโนปวาเสา กฺฤตฺวา ยตฺปฺรเภา เต วฺยศฺวสนฺ ตสฺย หเสฺต ตานฺ สมรฺปฺย ");
INSERT INTO santha_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ปิสิทิยามเธฺยน ปามฺผุลิยาเทศํ คตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ปศฺจาตฺ ปรฺคานครํ คตฺวา สุสํวาทํ ปฺรจารฺยฺย อตฺตาลิยานครํ ปฺรสฺถิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ตสฺมาตฺ สมุทฺรปเถน คตฺวา ตาภฺยำ ยตฺ กรฺมฺม สมฺปนฺนํ ตตฺกรฺมฺม สาธยิตุํ ยนฺนคเร ทยาโลรีศฺวรสฺย หเสฺต สมรฺปิเตา ชาเตา ตทฺ อานฺติยขิยานครํ คตวนฺตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ตโตฺรปสฺถาย ตนฺนครสฺถมณฺฑลีํ สํคฺฤหฺย สฺวาภฺยาม อีศฺวโร ยทฺยตฺ กรฺมฺมกโรตฺ ตถา เยน ปฺรกาเรณ ภินฺนเทศียโลกานฺ ปฺรติ วิศฺวาสรูปทฺวารมฺ อโมจยทฺ เอตานฺ สรฺวฺววฺฤตฺตานฺตานฺ ตานฺ ชฺญาปิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ตตเสฺตา ศิรฺไยฺย: สารฺทฺธํ ตตฺร พหุทินานิ นฺยวสตามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ยิหูทาเทศาตฺ กิยนฺโต ชนา อาคตฺย ภฺราตฺฤคณมิตฺถํ ศิกฺษิตวนฺโต มูสาวฺยวสฺถยา ยทิ ยุษฺมากํ ตฺวกฺเฉโท น ภวติ ตรฺหิ ยูยํ ปริตฺราณํ ปฺราปฺตุํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","เปาลพรฺณพฺเพา ไต: สห พหูนฺ วิจารานฺ วิวาทำศฺจ กฺฤตวนฺเตา, ตโต มณฺฑลียโนกา เอตสฺยา: กถายาสฺตตฺตฺวํ ชฺญาตุํ ยิรูศาลมฺนครสฺถานฺ เปฺรริตานฺ ปฺราจีนำศฺจ ปฺรติ เปาลพรฺณพฺพาปฺรภฺฤตีนฺ กติปยชนานฺ เปฺรษยิตุํ นิศฺจยํ กฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","เต มณฺฑลฺยา เปฺรริตา: สนฺต: ไผณีกีโศมิโรนฺเทศาภฺยำ คตฺวา ภินฺนเทศียานำ มน:ปริวรฺตฺตนสฺย วารฺตฺตยา ภฺราตฺฤณำ ปรมาหฺลาทมฺ อชนยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ยิรูศาลมฺยุปสฺถาย เปฺรริตคเณน โลกปฺราจีนคเณน สมาเชน จ สมุปคฺฤหีตา: สนฺต: ไสฺวรีศฺวโร ยานิ กรฺมฺมาณิ กฺฤตวานฺ เตษำ สรฺวฺววฺฤตฺตานฺตานฺ เตษำ สมกฺษมฺ อกถยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","กินฺตุ วิศฺวาสิน: กิยนฺต: ผิรูศิมตคฺราหิโณ โลกา อุตฺถาย กถาเมตำ กถิตวนฺโต ภินฺนเทศียานำ ตฺวกฺเฉทํ กรฺตฺตุํ มูสาวฺยวสฺถำ ปาลยิตุญฺจ สมาเทษฺฏวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ตต: เปฺรริตา โลกปฺราจีนาศฺจ ตสฺย วิเวจนำ กรฺตฺตุํ สภายำ สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","พหุวิจาเรษุ ชาตษุ ปิตร อุตฺถาย กถิตวานฺ, เห ภฺราตโร ยถา ภินฺนเทศียโลกา มม มุขาตฺ สุสํวาทํ ศฺรุตฺวา วิศฺวสนฺติ ตทรฺถํ พหุทินาตฺ ปูรฺวฺวมฺ อีศฺวโรสฺมากํ มเธฺย มำ วฺฤตฺวา นิยุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","อนฺตรฺยฺยามีศฺวโร ยถาสฺมภฺยํ ตถา ภินฺนเทศีเยภฺย: ปวิตฺรมาตฺมานํ ปฺรทาย วิศฺวาเสน เตษามฺ อนฺต:กรณานิ ปวิตฺราณิ กฺฤตฺวา ");
INSERT INTO santha_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","เตษามฺ อสฺมากญฺจ มเธฺย กิมปิ วิเศษํ น สฺถาปยิตฺวา ตานธิ สฺวยํ ปฺรมาณํ ทตฺตวานฺ อิติ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","อเตอวาสฺมากํ ปูรฺวฺวปุรุษา วยญฺจ สฺวยํ ยทฺยุคสฺย ภารํ โสฒุํ น ศกฺตา: สมฺปฺรติ ตํ ศิษฺยคณสฺย สฺกนฺเธษุ นฺยสิตุํ กุต อีศฺวรสฺย ปรีกฺษำ กริษฺยถ? ");
INSERT INTO santha_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ปฺรโภ รฺยีศุขฺรีษฺฏสฺยานุคฺรเหณ เต ยถา วยมปิ ตถา ปริตฺราณํ ปฺราปฺตุมฺ อาศำ กุรฺมฺม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","อนนฺตรํ พรฺณพฺพาเปาลาภฺยามฺ อีศฺวโร ภินฺนเทศียานำ มเธฺย ยทฺยทฺ อาศฺจรฺยฺยมฺ อทฺภุตญฺจ กรฺมฺม กฺฤตวานฺ ตทฺวฺฤตฺตานฺตํ เตา สฺวมุขาภฺยามฺ อวรฺณยตำ สภาสฺถา: สรฺเวฺว นีรวา: สนฺต: ศฺรุตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ตโย: กถายำ สมาปฺตายำ สตฺยำ ยากูพฺ กถยิตุมฺ อารพฺธวานฺ ");
INSERT INTO santha_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","เห ภฺราตโร มม กถายามฺ มโน นิธตฺตฯ อีศฺวร: สฺวนามารฺถํ ภินฺนเทศียโลกานามฺ มธฺยาทฺ เอกํ โลกสํฆํ คฺรหีตุํ มตึ กฺฤตฺวา เยน ปฺรกาเรณ ปฺรถมํ ตานฺ ปฺรติ กฺฤปาวเลกนํ กฺฤตวานฺ ตํ ศิโมนฺ วรฺณิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ภวิษฺยทฺวาทิภิรุกฺตานิ ยานิ วากฺยานิ ไต: สารฺทฺธมฺ เอตไสฺยกฺยํ ภวติ ยถา ลิขิตมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","สรฺเวฺวษำ กรฺมฺมณำ ยสฺตุ สาธก: ปรเมศฺวร:ฯ ส เอเวทํ วเททฺวากฺยํ เศษา: สกลมานวา:ฯ ภินฺนเทศียโลกาศฺจ ยาวนฺโต มม นามต:ฯ ภวนฺติ หิ สุวิขฺยาตาเสฺต ยถา ปรเมศิตุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ตตฺวํ สมฺยกฺ สมีหนฺเต ตนฺนิมิตฺตมหํ กิลฯ ปราวฺฤตฺย สมาคตฺย ทายูท: ปติตํ ปุน:ฯ ทูษฺยมุตฺถาปยิษฺยามิ ตทียํ สรฺวฺววสฺตุ จฯ ปติตํ ปุนรุถาปฺย สชฺชยิษฺยามิ สรฺวฺวถา๚ ");
INSERT INTO santha_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","อา ปฺรถมาทฺ อีศฺวร: สฺวียานิ สรฺวฺวกรฺมฺมาณิ ชานาติฯ ");
INSERT INTO santha_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","อเตอว มม นิเวทนมิทํ ภินฺนเทศียโลกานำ มเธฺย เย ชนา อีศฺวรํ ปฺรติ ปราวรฺตฺตนฺต เตษามุปริ อนฺยํ กมปิ ภารํ น นฺยสฺย ");
INSERT INTO santha_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","เทวตาปฺรสาทาศุจิภกฺษฺยํ วฺยภิจารกรฺมฺม กณฺฐสมฺปีฑนมาริตปฺราณิภกฺษฺยํ รกฺตภกฺษฺยญฺจ เอตานิ ปริตฺยกฺตุํ ลิขาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ยต: ปูรฺวฺวกาลโต มูสาวฺยวสฺถาปฺรจาริโณ โลกา นคเร นคเร สนฺติ ปฺรติวิศฺรามวารญฺจ ภชนภวเน ตสฺยา: ปาโฐ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ตต: ปรํ เปฺรริตคโณ โลกปฺราจีนคณ: สรฺวฺวา มณฺฑลี จ เสฺวษำ มเธฺย พรฺศพฺพา นามฺนา วิขฺยาโต มโนนีเตา กฺฤตฺวา เปาลพรฺณพฺพาภฺยำ สารฺทฺธมฺ อานฺติยขิยานครํ ปฺรติ เปฺรษณมฺ อุจิตํ พุทฺธฺวา ตาภฺยำ ปตฺรํ ไปฺรษยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ตสฺมินฺ ปเตฺร ลิขิตมึท, อานฺติยขิยา-สุริยา-กิลิกิยาเทศสฺถภินฺนเทศียภฺราตฺฤคณาย เปฺรริตคณสฺย โลกปฺราจีนคณสฺย ภฺราตฺฤคณสฺย จ นมสฺการ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","วิเศษโต'สฺมากมฺ อาชฺญามฺ อปฺราปฺยาปิ กิยนฺโต ชนา อสฺมากํ มธฺยาทฺ คตฺวา ตฺวกฺเฉโท มูสาวฺยวสฺถา จ ปาลยิตวฺยาวิติ ยุษฺมานฺ ศิกฺษยิตฺวา ยุษฺมากํ มนสามไสฺถรฺยฺยํ กฺฤตฺวา ยุษฺมานฺ สสนฺเทหานฺ อกุรฺวฺวนฺ เอตำ กถำ วยมฺ อศฺฤนฺมฯ ");
INSERT INTO santha_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ตตฺการณาทฺ วยมฺ เอกมนฺตฺรณา: สนฺต: สภายำ สฺถิตฺวา ปฺรโภ รฺยีศุขฺรีษฺฏสฺย นามนิมิตฺตํ มฺฤตฺยุมุขคตาภฺยามสฺมากํ ");
INSERT INTO santha_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ปฺริยพรฺณพฺพาเปาลาภฺยำ สารฺทฺธํ มโนนีตโลกานำ เกษาญฺจิทฺ ยุษฺมากํ สนฺนิเธา เปฺรษณมฺ อุจิตํ พุทฺธวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","อโต ยิหูทาสีเลา ยุษฺมานฺ ปฺรติ เปฺรษิตวนฺต:, เอตโย รฺมุขาภฺยำ สรฺวฺวำ กถำ ชฺญาสฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","เทวตาปฺรสาทภกฺษฺยํ รกฺตภกฺษฺยํ คลปีฑนมาริตปฺราณิภกฺษฺยํ วฺยภิจารกรฺมฺม เจมานิ สรฺวฺวาณิ ยุษฺมาภิสฺตฺยาชฺยานิ; เอตตฺปฺรโยชนียาชฺญาวฺยติเรเกน ยุษฺมากมฺ อุปริ ภารมนฺยํ น นฺยสิตุํ ปวิตฺรสฺยาตฺมโน'สฺมากญฺจ อุจิตชฺญานมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","อเตอว เตภฺย: สรฺเวฺวภฺย: เสฺวษุ รกฺษิเตษุ ยูยํ ภทฺรํ กรฺมฺม กริษฺยถฯ ยุษฺมากํ มงฺคลํ ภูยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","เตे วิสฺฤษฺฏา: สนฺต อานฺติยขิยานคร อุปสฺถาย โลกนิวหํ สํคฺฤหฺย ปตฺรมฺ อททนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ตตเสฺต ตตฺปตฺรํ ปฐิตฺวา สานฺตฺวนำ ปฺราปฺย สานนฺทา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ยิหูทาสีเลา จ สฺวยํ ปฺรจารเกา ภูตฺวา ภฺราตฺฤคณํ นาโนปทิศฺย ตานฺ สุสฺถิรานฺ อกุรุตามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","อิตฺถํ เตา ตตฺร ไต: สากํ กติปยทินานิ ยาปยิตฺวา ปศฺจาตฺ เปฺรริตานำ สมีเป ปฺรตฺยาคมนารฺถํ เตษำ สนฺนิเธ: กลฺยาเณน วิสฺฤษฺฏาวภวตำฯ ");
INSERT INTO santha_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","กินฺตุ สีลสฺตตฺร สฺถาตุํ วาญฺฉิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","อปรํ เปาลพรฺณพฺเพา พหว: ศิษฺยาศฺจ โลกานฺ อุปทิศฺย ปฺรโภ: สุสํวาทํ ปฺรจารยนฺต อานฺติยขิยายำ กาลํ ยาปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","กติปยทิเนษุ คเตษุ เปาโล พรฺณพฺพามฺ อวทตฺ อาคจฺฉาวำ เยษุ นคเรษฺวีศฺวรสฺย สุสํวาทํ ปฺรจาริตวนฺเตา ตานิ สรฺวฺวนคราณิ ปุนรฺคตฺวา ภฺราตร: กีทฺฤศา: สนฺตีติ ทฺรษฺฏุํ ตานฺ สากฺษาตฺ กุรฺวฺว:ฯ ");
INSERT INTO santha_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","เตน มารฺกนามฺนา วิขฺยาตํ โยหนํ สงฺคินํ กรฺตฺตุํ พรฺณพฺพา มติมกโรตฺ, ");
INSERT INTO santha_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","กินฺตุ ส ปูรฺวฺวํ ตาภฺยำ สห การฺยฺยารฺถํ น คตฺวา ปามฺผูลิยาเทเศ เตา ตฺยกฺตวานฺ ตตฺการณาตฺ เปาลสฺตํ สงฺคินํ กรฺตฺตุมฺ อนุจิตํ ชฺญาตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","อิตฺถํ ตโยรติศยวิโรธโสฺยปสฺถิตตฺวาตฺ เตา ปรสฺปรํ ปฺฤถคภวตำ ตโต พรฺณพฺพา มารฺกํ คฺฤหีตฺวา โปเตน กุโปฺรปทฺวีปํ คตวานฺ; ");
INSERT INTO santha_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","กินฺตุ เปาล: สีลํ มโนนีตํ กฺฤตฺวา ภฺราตฺฤภิรีศฺวรานุคฺรเห สมรฺปิต: สนฺ ปฺรสฺถาย ");
INSERT INTO santha_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","สุริยากิลิกิยาเทศาภฺยำ มณฺฑลี: สฺถิรีกุรฺวฺวนฺ อคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","เปาโล ทรฺพฺพีลุสฺตฺรานครโยรุปสฺถิโตภวตฺ ตตฺร ตีมถิยนามา ศิษฺย เอก อาสีตฺ; ส วิศฺวาสินฺยา ยิหูทียายา โยษิโต ครฺพฺภชาต: กินฺตุ ตสฺย ปิตานฺยเทศียโลก:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ส ชโน ลุสฺตฺรา-อิกนิยนครสฺถานำ ภฺราตฺฤณำ สมีเปปิ สุขฺยาติมานฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","เปาลสฺตํ สฺวสงฺคินํ กรฺตฺตุํ มตึ กฺฤตฺวา ตํ คฺฤหีตฺวา ตทฺเทศนิวาสินำ ยิหูทียานามฺ อนุโรธาตฺ ตสฺย ตฺวกฺเฉทํ กฺฤตวานฺ ยตสฺตสฺย ปิตา ภินฺนเทศียโลก อิติ สรฺไวฺวรชฺญายตฯ ");
INSERT INTO santha_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ตต: ปรํ เต นคเร นคเร ภฺรมิตฺวา ยิรูศาลมไสฺถ: เปฺรริไต โรฺลกปฺราจีไนศฺจ นิรูปิตํ ยทฺ วฺยวสฺถาปตฺรํ ตทนุสาเรณาจริตุํ โลเกภฺยสฺตทฺ ทตฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","เตไนว สรฺเวฺว ธรฺมฺมสมาชา: ขฺรีษฺฏธรฺมฺเม สุสฺถิรา: สนฺต: ปฺรติทินํ วรฺทฺธิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","เตษุ ผฺรุคิยาคาลาติยาเทศมเธฺยน คเตษุ สตฺสุ ปวิตฺร อาตฺมา ตานฺ อาศิยาเทเศ กถำ ปฺรกาศยิตุํ ปฺรติษิทฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ตถา มุสิยาเทศ อุปสฺถาย พิถุนิยำ คนฺตุํ ไตรุโทฺยเค กฺฤเต อาตฺมา ตานฺ นานฺวมนฺยตฯ ");
INSERT INTO santha_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ตสฺมาตฺ เต มุสิยาเทศํ ปริตฺยชฺย โตฺรยานครํ คตฺวา สมุปสฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ราเตฺรา เปาล: สฺวปฺเน ทฺฤษฺฏวานฺ เอโก มากิทนิยโลกสฺติษฺฐนฺ วินยํ กฺฤตฺวา ตไสฺม กถยติ, มากิทนิยาเทศมฺ อาคตฺยาสฺมานฺ อุปกุรฺวฺวิติฯ ");
INSERT INTO santha_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ตเสฺยตฺถํ สฺวปฺนทรฺศนาตฺ ปฺรภุสฺตทฺเทศียโลกานฺ ปฺรติ สุสํวาทํ ปฺรจารยิตุมฺ อสฺมานฺ อาหูยตีติ นิศฺจิตํ พุทฺธฺวา วยํ ตูรฺณํ มากิทนิยาเทศํ คนฺตุมฺ อุโทฺยคมฺ อกุรฺมฺมฯ ");
INSERT INTO santha_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ตต: ปรํ วยํ โตฺรยานคราทฺ ปฺรสฺถาย ฤชุมารฺเคณ สามถฺรากิโยปทฺวีเปน คตฺวา ปเร'หนิ นิยาปลินคร อุปสฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ตสฺมาทฺ คตฺวา มากิทนิยานฺตรฺวฺวรฺตฺติ โรมียวสติสฺถานํ ยตฺ ผิลิปีนามปฺรธานนครํ ตโตฺรปสฺถาย กติปยทินานิ ตตฺร สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","วิศฺรามวาเร นคราทฺ พหิ รฺคตฺวา นทีตเฏ ยตฺร ปฺรารฺถนาจาร อาสีตฺ ตโตฺรปวิศฺย สมาคตา นารี: ปฺรติ กถำ ปฺราจารยามฯ ");
INSERT INTO santha_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ตต: ถุยาตีรานครียา ธูษรามฺพรวิกฺรายิณี ลุทิยานามิกา ยา อีศฺวรเสวิกา โยษิตฺ โศฺรตฺรีณำ มธฺย อาสีตฺ ตยา เปาโลกฺตวากฺยานิ ยทฺ คฺฤหฺยนฺเต ตทรฺถํ ปฺรภุสฺตสฺยา มโนทฺวารํ มุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","อต: สา โยษิตฺ สปริวารา มชฺชิตา สตี วินยํ กฺฤตฺวา กถิตวตี, ยุษฺมากํ วิจาราทฺ ยทิ ปฺรเภา วิศฺวาสินี ชาตาหํ ตรฺหิ มม คฺฤหมฺ อาคตฺย ติษฺฐตฯ อิตฺถํ สา ยตฺเนนาสฺมานฺ อสฺถาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ยสฺยา คณนยา ตทธิปตีนำ พหุธโนปารฺชนํ ชาตํ ตาทฺฤศี คณกภูตคฺรสฺตา กาจน ทาสี ปฺรารฺถนาสฺถานคมนกาล อาคตฺยาสฺมานฺ สากฺษาตฺ กฺฤตวตีฯ ");
INSERT INTO santha_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","สาสฺมากํ เปาลสฺย จ ปศฺจาทฺ เอตฺย โปฺรจฺไจ: กถามิมำ กถิตวตี, มนุษฺยา เอเต สรฺโวฺวปริสฺถเสฺยศฺวรสฺย เสวกา: สนฺโต'สฺมานฺ ปฺรติ ปริตฺราณสฺย มารฺคํ ปฺรกาศยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","สา กนฺยา พหุทินานิ ตาทฺฤศมฺ อกโรตฺ ตสฺมาตฺ เปาโล ทุ:ขิต: สนฺ มุขํ ปราวรฺตฺย ตํ ภูตมวททฺ, อหํ ยีศุขฺรีษฺฏสฺย นามฺนา ตฺวามาชฺญาปยามิ ตฺวมสฺยา พหิรฺคจฺฉ; เตไนว ตตฺกฺษณาตฺ ส ภูตสฺตสฺยา พหิรฺคต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ตต: เสฺวษำ ลาภสฺย ปฺรตฺยาศา วิผลา ชาเตติ วิโลกฺย ตสฺยา: ปฺรภว: เปาลํ สีลญฺจ ธฺฤตฺวากฺฤษฺย วิจารสฺถาเน'ธิปตีนำ สมีปมฺ อานยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ตต: ศาสกานำ นิกฏํ นีตฺวา โรมิโลกา วยมฺ อสฺมากํ ยทฺ วฺยวหรณํ คฺรหีตุมฺ อาจริตุญฺจ นิษิทฺธํ, ");
INSERT INTO santha_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","อิเม ยิหูทียโลกา: สนฺโตปิ ตเทว ศิกฺษยิตฺวา นคเร'สฺมากมฺ อตีว กลหํ กุรฺวฺวนฺติ, ");
INSERT INTO santha_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","อิติ กถิเต สติ โลกนิวหสฺตโย: ปฺราติกูเลฺยโนทติษฺฐตฺ ตถา ศาสกาสฺตโย รฺวสฺตฺราณิ ฉิตฺวา เวตฺราฆาตํ กรฺตฺตุมฺ อาชฺญาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","อปรํ เต เตา พหุ ปฺรหารฺยฺย ตฺวเมเตา การำ นีตฺวา สาวธานํ รกฺษเยติ การารกฺษกมฺ อาทิศนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","อิตฺถมฺ อาชฺญำ ปฺราปฺย ส ตาวภฺยนฺตรสฺถการำ นีตฺวา ปาเทษุ ปาทปาศีภิ รฺพทฺธฺวา สฺถาปิตาวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","อถ นิศีถสมเย เปาลสีลาวีศฺวรมุทฺทิศฺย ปฺราถนำ คานญฺจ กฺฤตวนฺเตา, การาสฺถิตา โลกาศฺจ ตทศฺฤณฺวนฺ ");
INSERT INTO santha_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ตทากสฺมาตฺ มหานฺ ภูมิกมฺโป'ภวตฺ เตน ภิตฺติมูเลน สห การา กมฺปิตาภูตฺ ตตฺกฺษณาตฺ สรฺวฺวาณิ ทฺวาราณิ มุกฺตานิ ชาตานิ สรฺเวฺวษำ พนฺธนานิ จ มุกฺตานิฯ ");
INSERT INTO santha_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","อเตอว การารกฺษโก นิทฺราโต ชาคริตฺวา การายา ทฺวาราณิ มุกฺตานิ ทฺฤษฺฏฺวา พนฺทิโลกา: ปลายิตา อิตฺยนุมาย โกษาตฺ ขงฺคํ พหิ: กฺฤตฺวาตฺมฆาตํ กรฺตฺตุมฺ อุทฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","กินฺตุ เปาล: โปฺรจฺไจสฺตมาหูย กถิตวานฺ ปศฺย วยํ สรฺเวฺว'ตฺราสฺมเห, ตฺวํ นิชปฺราณหึสำ มาการฺษี:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ตทา ปฺรทีปมฺ อาเนตุมฺ อุกฺตฺวา ส กมฺปมาน: สนฺ อุลฺลมฺปฺยาภฺยนฺตรมฺ อาคตฺย เปาลสีลโย: ปาเทษุ ปติตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ปศฺจาตฺ ส เตา พหิรานีย ปฺฤษฺฏวานฺ เห มเหจฺเฉา ปริตฺราณํ ปฺราปฺตุํ มยา กึ กรฺตฺตวฺยํ? ");
INSERT INTO santha_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ปศฺจาตฺ เตา สฺวคฺฤหมานีย ตโย: สมฺมุเข ขาทฺยทฺรวฺยาณิ สฺถาปิตวานฺ ตถา ส สฺวยํ ตทียา: สรฺเวฺว ปริวาราศฺเจศฺวเร วิศฺวสนฺต: สานนฺทิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ตไสฺม ตสฺย คฺฤหสฺถิตสรฺวฺวโลเกภฺยศฺจ ปฺรโภ: กถำ กถิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ตถา ราเตฺรสฺตสฺมินฺเนว ทณฺเฑ ส เตา คฺฤหีตฺวา ตโย: ปฺรหาราณำ กฺษตานิ ปฺรกฺษาลิตวานฺ ตต: ส สฺวยํ ตสฺย สรฺเวฺว ปริชนาศฺจ มชฺชิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ปศฺจาตฺ เตา สฺวคฺฤหมานีย ตโย: สมฺมุเข ขาทฺยทฺรวฺยาณิ สฺถาปิตวานฺ ตถา ส สฺวยํ ตทียา: สรฺเวฺว ปริวาราศฺเจศฺวเร วิศฺวสนฺต: สานนฺทิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ทิน อุปสฺถิเต เตา โลเกา โมจเยติ กถำ กถยิตุํ ศาสกา: ปทาติคณํ เปฺรษิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ตต: การารกฺษก: เปาลาย ตำ วารฺตฺตำ กถิตวานฺ ยุวำ ตฺยาชยิตุํ ศาสกา โลกาน เปฺรษิตวนฺต อิทานีํ ยุวำ พหิ รฺภูตฺวา กุศเลน ปฺรติษฺเฐตำฯ ");
INSERT INTO santha_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","กินฺตุ เปาลสฺตานฺ อวทตฺ โรมิโลกโยราวโย: กมปิ โทษมฺ น นิศฺจิตฺย สรฺเวฺวษำ สมกฺษมฺ อาวำ กศยา ตาฑยิตฺวา การายำ พทฺธวนฺต อิทานีํ กิมาวำ คุปฺตํ วิสฺตฺรกฺษฺยนฺติ? ตนฺน ภวิษฺยติ, สฺวยมาคตฺยาวำ พหิ: กฺฤตฺวา นยนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ตทา ปทาติภิ: ศาสเกภฺย เอตทฺวารฺตฺตายำ กถิตายำ เตา โรมิโลกาวิติ กถำ ศฺรุตฺวา เต ภีตา: ");
INSERT INTO santha_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","สนฺตสฺตโย: สนฺนิธิมาคตฺย วินยมฺ อกุรฺวฺวนฺ อปรํ พหิ: กฺฤตฺวา นคราตฺ ปฺรสฺถาตุํ ปฺรารฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ตตเสฺตา การายา นิรฺคตฺย ลุทิยายา คฺฤหํ คตวนฺเตา ตตฺร ภฺราตฺฤคณํ สากฺษาตฺกฺฤตฺย ตานฺ สานฺตฺวยิตฺวา ตสฺมาตฺ สฺถานาตฺ ปฺรสฺถิเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","เปาลสีเลา อามฺผิปลฺยาปโลฺลนิยานคราภฺยำ คตฺวา ยตฺร ยิหูทียานำ ภชนภวนเมกมฺ อาเสฺต ตตฺร ถิษลนีกีนคร อุปสฺถิเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ตทา เปาล: สฺวาจารานุสาเรณ เตษำ สมีปํ คตฺวา วิศฺรามวารตฺรเย ไต: สารฺทฺธํ ธรฺมฺมปุสฺตกียกถายา วิจารํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ผลต: ขฺรีษฺเฏน ทุ:ขโภค: กรฺตฺตวฺย: ศฺมศานทุตฺถานญฺจ กรฺตฺตวฺยํ ยุษฺมากํ สนฺนิเธา ยสฺย ยีโศ: ปฺรสฺตาวํ กโรมิ ส อีศฺวเรณาภิษิกฺต: ส เอตา: กถา: ปฺรกาศฺย ปฺรมาณํ ทตฺวา สฺถิรีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ตสฺมาตฺ เตษำ กติปยชนา อนฺยเทศียา พหโว ภกฺตโลกา พหฺย: ปฺรธานนารฺยฺยศฺจ วิศฺวสฺย เปาลสีลโย: ปศฺจาทฺคามิโน ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","กินฺตุ วิศฺวาสหีนา ยิหูทียโลกา อีรฺษฺยยา ปริปูรฺณา: สนฺโต หฏฏฺสฺย กตินยลมฺปฏโลกานฺ สงฺคิน: กฺฤตฺวา ชนตยา นครมเธฺย มหากลหํ กฺฤตฺวา ยาโสโน คฺฤหมฺ อากฺรมฺย เปฺรริตานฺ ธฺฤตฺวา โลกนิวหสฺย สมีปมฺ อาเนตุํ เจษฺฏิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","เตษามุทฺเทศมฺ อปฺราปฺย จ ยาโสนํ กติปยานฺ ภฺราตฺฤํศฺจ ธฺฤตฺวา นคราธิปตีนำ นิกฏมานีย โปฺรจฺไจ: กถิตวนฺโต เย มนุษฺยา ชคทุทฺวาฏิตวนฺตเสฺต 'ตฺราปฺยุปสฺถิตา: สนฺติ, ");
INSERT INTO santha_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","เอษ ยาโสนฺ อาติถฺยํ กฺฤตฺวา ตานฺ คฺฤหีตวานฺฯ ยีศุนามก เอโก ราชสฺตีติ กถยนฺตเสฺต ไกสรสฺยาชฺญาวิรุทฺธํ กรฺมฺม กุรฺวฺวติฯ ");
INSERT INTO santha_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","เตษำ กถามิมำ ศฺรุตฺวา โลกนิวโห นคราธิปตยศฺจ สมุทฺวิคฺนา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ตทา ยาโสนสฺตทเนฺยษาญฺจ ธนทณฺฑํ คฺฤหีตฺวา ตานฺ ปริตฺยกฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ตต: ปรํ ภฺราตฺฤคโณ รชนฺยำ เปาลสีเลา ศีฆฺรํ พิรยานครํ เปฺรษิตวานฺ เตา ตโตฺรปสฺถาย ยิหูทียานำ ภชนภวนํ คตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ตตฺรสฺถา โลกา: ถิษลนีกีสฺถโลเกโภฺย มหาตฺมาน อาสนฺ ยต อิตฺถํ ภวติ น เวติ ชฺญาตุํ ทิเน ทิเน ธรฺมฺมคฺรนฺถสฺยาโลจนำ กฺฤตฺวา ไสฺวรํ กถามฺ อคฺฤหฺลนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ตสฺมาทฺ อเนเก ยิหูทียา อนฺยเทศียานำ มานฺยา สฺตฺริย: ปุรุษาศฺจาเนเก วฺยศฺวสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","กินฺตุ พิรยานคเร เปาเลเนศฺวรียา กถา ปฺรจารฺยฺยต อิติ ถิษลนีกีสฺถา ยิหูทียา ชฺญาตฺวา ตตฺสฺถานมปฺยาคตฺย โลกานำ กุปฺรวฺฤตฺติมฺ อชนยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","อเตอว ตสฺมาตฺ สฺถานาตฺ สมุเทฺรณ ยานฺตีติ ทรฺศยิตฺวา ภฺราตร: กฺษิปฺรํ เปาลํ ปฺราหิณฺวนฺ กินฺตุ สีลตีมถิเยา ตตฺร สฺถิตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ตต: ปรํ เปาลสฺย มารฺคทรฺศกาสฺตมฺ อาถีนีนคร อุปสฺถาปยนฺ ปศฺจาทฺ ยุวำ ตูรฺณมฺ เอตตฺ สฺถานํ อาคมิษฺยถ: สีลตีมถิเยา ปฺรตีมามฺ อาชฺญำ ปฺราปฺย เต ปฺรตฺยาคตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","เปาล อาถีนีนคเร ตาวเปกฺษฺย ติษฺฐนฺ ตนฺนครํ ปฺรติมาภิ: ปริปูรฺณํ ทฺฤษฺฏฺวา สนฺตปฺตหฺฤทโย 'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ตต: ส ภชนภวเน ยานฺ ยิหูทียานฺ ภกฺตโลกำศฺจ หฏฺเฏ จ ยานฺ อปศฺยตฺ ไต: สห ปฺรติทินํ วิจาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","กินฺตฺวิปิกูรียมตคฺรหิณ: โสฺตยิกียมตคฺราหิณศฺจ กิยนฺโต ชนาเสฺตน สารฺทฺธํ วฺยวทนฺตฯ ตตฺร เกจิทฺ อกถยนฺ เอษ วาจาล: กึ วกฺตุมฺ อิจฺฉติ? อปเร เกจิทฺ เอษ ชน: เกษาญฺจิทฺ วิเทศียเทวานำ ปฺรจารก อิตฺยนุมียเต ยต: ส ยีศุมฺ อุตฺถิติญฺจ ปฺรจารยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","เต ตมฺ อเรยปาคนาม วิจารสฺถานมฺ อานีย ปฺราโวจนฺ อิทํ ยนฺนวีนํ มตํ ตฺวํ ปฺราจีกศ อิทํ กีทฺฤศํ เอตทฺ อสฺมานฺ ศฺราวย; ");
INSERT INTO santha_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ยามิมามฺ อสมฺภวกถามฺ อสฺมากํ กรฺณโคจรีกฺฤตวานฺ อสฺยา ภาวารฺถ: ก อิติ วยํ ชฺญาตุมฺ อิจฺฉาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ตทาถีนีนิวาสินสฺตนฺนครปฺรวาสินศฺจ เกวลํ กสฺยาศฺจน นวีนกถายา: ศฺรวเณน ปฺรจารเณน จ กาลมฺ อยาปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","เปาโล'เรยปาคสฺย มเธฺย ติษฺฐนฺ เอตำ กถำ ปฺรจาริตวานฺ, เห อาถีนียโลกา ยูยํ สรฺวฺวถา เทวปูชายามฺ อาสกฺตา อิตฺยห ปฺรตฺยกฺษํ ปศฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ยต: ปรฺยฺยฏนกาเล ยุษฺมากํ ปูชนียานิ ปศฺยนฺ ‘อวิชฺญาเตศฺวราย’ เอตลฺลิปิยุกฺตำ ยชฺญเวทีเมกำ ทฺฤษฺฏวานฺ; อโต น วิทิตฺวา ยํ ปูชยเธฺว ตไสฺยว ตตฺวํ ยุษฺมานฺ ปฺรติ ปฺรจารยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ชคโต ชคตฺสฺถานำ สรฺวฺววสฺตูนาญฺจ สฺรษฺฏา ย อีศฺวร: ส สฺวรฺคปฺฤถิโวฺยเรกาธิปติ: สนฺ กรนิรฺมฺมิตมนฺทิเรษุ น นิวสติ; ");
INSERT INTO santha_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ส เอว สรฺเวฺวโภฺย ชีวนํ ปฺราณานฺ สรฺวฺวสามคฺรีศฺจ ปฺรททาติ; อเตอว ส กสฺยาศฺจิตฺ สามคฺยฺรา อภาวเหโต รฺมนุษฺยาณำ หไสฺต: เสวิโต ภวตีติ นฯ ");
INSERT INTO santha_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ส ภูมณฺฑเล นิวาสารฺถมฺ เอกสฺมาตฺ โศณิตาตฺ สรฺวฺวานฺ มนุษฺยานฺ สฺฤษฺฏฺวา เตษำ ปูรฺวฺวนิรูปิตสมยํ วสติสีมาญฺจ นิรจิโนตฺ; ");
INSERT INTO santha_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ตสฺมาตฺ โลไก: เกนาปิ ปฺรกาเรณ มฺฤคยิตฺวา ปรเมศฺวรสฺย ตตฺวํ ปฺราปฺตุํ ตสฺย คเวษณํ กรณียมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","กินฺตุ โส'สฺมากํ กสฺมาจฺจิทปิ ทูเร ติษฺฐตีติ นหิ, วยํ เตน นิศฺวสนปฺรศฺวสนคมนาคมนปฺราณธารณานิ กุรฺมฺม:, ปุुนศฺจ ยุษฺมากเมว กติปยา: กวย: กถยนฺติ ‘ตสฺย วํศา วยํ โสฺม หิ’ อิติฯ ");
INSERT INTO santha_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","อเตอว ยทิ วยมฺ อีศฺวรสฺย วํศา ภวามสฺตรฺหิ มนุไษฺย รฺวิทฺยยา เกาศเลน จ ตกฺษิตํ สฺวรฺณํ รูปฺยํ ทฺฤษทฺ ไวเตษามีศฺวรตฺวมฺ อสฺมาภิ รฺน ชฺญาตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","เตษำ ปูรฺวฺวียโลกานามฺ อชฺญานตำ ปฺรตีศฺวโร ยทฺยปิ นาวาธตฺต ตถาปีทานีํ สรฺวฺวตฺร สรฺวฺวานฺ มน: ปริวรฺตฺตยิตุมฺ อาชฺญาปยติ, ");
INSERT INTO santha_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ยต: สฺวนิยุกฺเตน ปุรุเษณ ยทา ส ปฺฤถิวีสฺถานำ สรฺวฺวโลกานำ วิจารํ กริษฺยติ ตทฺทินํ นฺยรูปยตฺ; ตสฺย ศฺมศาโนตฺถาปเนน ตสฺมินฺ สรฺเวฺวภฺย: ปฺรมาณํ ปฺราทาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ตทา ศฺมศานาทฺ อุตฺถานสฺย กถำ ศฺรุตฺวา เกจิทฺ อุปาหมนฺ, เกจิทวทนฺ เอนำ กถำ ปุนรปิ ตฺวตฺต: โศฺรษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ตต: เปาลเสฺตษำ สมีปาตฺ ปฺรสฺถิाตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ตถาปิ เกจิโลฺลกาเสฺตน สารฺทฺธํ มิลิตฺวา วฺยศฺวสนฺ เตษำ มเธฺย 'เรยปาคียทิยนุสิโย ทามารีนามา กาจินฺนารี กิยนฺโต นราศฺจาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ตทฺฆฏนาต: ปรํ เปาล อาถีนีนคราทฺ ยาตฺรำ กฺฤตฺวา กรินฺถนครมฺ อาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ตสฺมินฺ สมเย เกฺลาทิย: สรฺวฺวานฺ ยิหูทียานฺ โรมานครํ วิหาย คนฺตุมฺ อาชฺญาปยตฺ, ตสฺมาตฺ ปฺริสฺกิลฺลานามฺนา ชายยา สารฺทฺธมฺ อิตาลิยาเทศาตฺ กิญฺจิตฺปูรฺวฺวมฺ อาคมตฺ ย: ปนฺตเทเศ ชาต อากฺกิลนามา ยิหูทียโลก: เปาลสฺตํ สากฺษาตฺ ปฺราปฺย ตโย: สมีปมิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","เตา ทูษฺยนิรฺมฺมาณชีวิเนา, ตสฺมาตฺ ปรสฺปรมฺ เอกวฺฤตฺติกตฺวาตฺ ส ตาภฺยำ สห อุษิตฺวา ตตฺ กรฺมฺมากโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","เปาล: ปฺรติวิศฺรามวารํ ภชนภวนํ คตฺวา วิจารํ กฺฤตฺวา ยิหูทียานฺ อนฺยเทศียำศฺจ ปฺรวฺฤตฺตึ คฺราหิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","สีลตีมถิยโย รฺมากิทนิยาเทศาตฺ สเมตโย: สโต: เปาล อุตฺตปฺตมนา ภูตฺวา ยีศุรีศฺวเรณาภิษิกฺโต ภวตีติ ปฺรมาณํ ยิหูทียานำ สมีเป ปฺราทาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","กินฺตุ เต 'ตีว วิโรธํ วิธาย ปาษณฺฑียกถำ กถิตวนฺตสฺตต: เปาโล วสฺตฺรํ ธุนฺวนฺ เอตำ กถำ กถิตวานฺ, ยุษฺมากํ โศณิตปาตาปราโธ ยุษฺมานฺ ปฺรเตฺยว ภวตุ, เตนาหํ นิรปราโธ 'ทฺยารภฺย ภินฺนเทศียานำ สมีปํ ยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ส ตสฺมาตฺ ปฺรสฺถาย ภชนภวนสมีปสฺถสฺย ยุสฺตนามฺน อีศฺวรภกฺตสฺย ภินฺนเทศียสฺย นิเวศนํ ปฺราวิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ตต: กฺรีษฺปนามา ภชนภวนาธิปติ: สปริวาร: ปฺรเภา วฺยศฺวสีตฺ, กรินฺถนครียา พหโว โลกาศฺจ สมากรฺณฺย วิศฺวสฺย มชฺชิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","กฺษณทายำ ปฺรภุ: เปาลํ ทรฺศนํ ทตฺวา ภาษิตวานฺ, มา ไภษี:, มา นิรสี: กถำ ปฺรจารยฯ ");
INSERT INTO santha_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","อหํ ตฺวยา สารฺทฺธมฺ อาส หึสารฺถํ โกปิ ตฺวำ สฺปฺรษฺฏุํ น ศกฺษฺยติ นคเร'สฺมินฺ มทียา โลกา พหว อาสเตฯ ");
INSERT INTO santha_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ตสฺมาตฺ เปาลสฺตนฺนคเร ปฺราเยณ สารฺทฺธวตฺสรปรฺยฺยนฺตํ สํสฺถาเยศฺวรสฺย กถามฺ อุปาทิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","คาลฺลิยนามา กศฺจิทฺ อาขายาเทศสฺย ปฺราฑฺวิวาก: สมภวตฺ, ตโต ยิหูทียา เอกวากฺยา: สนฺต: เปาลมฺ อากฺรมฺย วิจารสฺถานํ นีตฺวา ");
INSERT INTO santha_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","มานุษ เอษ วฺยวสฺถาย วิรุทฺธมฺ อีศฺวรภชนํ กรฺตฺตุํ โลกานฺ กุปฺรวฺฤตฺตึ คฺราหยตีติ นิเวทิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ตต: เปาเล ปฺรตฺยุตฺตรํ ทาตุมฺ อุทฺยเต สติ คาลฺลิยา ยิหูทียานฺ วฺยาหรตฺ, ยทิ กสฺยจิทฺ อนฺยายสฺย วาติศยทุษฺฏตาจรณสฺย วิจาโร'ภวิษฺยตฺ ตรฺหิ ยุษฺมากํ กถา มยา สหนียาภวิษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","กินฺตุ ยทิ เกวลํ กถายา วา นามฺโน วา ยุษฺมากํ วฺยวสฺถายา วิวาโท ภวติ ตรฺหิ ตสฺย วิจารมหํ น กริษฺยามิ, ยูยํ ตสฺย มีมำสำ กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ตต: ส ตานฺ วิจารสฺถานาทฺ ทูรีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ตทา ภินฺนเทศียา: โสสฺถินินามานํ ภชนภวนสฺย ปฺรธานาธิปตึ ธฺฤตฺวา วิจารสฺถานสฺย สมฺมุเข ปฺราหรนฺ ตถาปิ คาลฺลิยา เตษุ สรฺวฺวกรฺมฺมสุ น มโน นฺยทธาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","เปาลสฺตตฺร ปุนรฺพหุทินานิ นฺยวสตฺ, ตโต ภฺราตฺฤคณาทฺ วิสรฺชนํ ปฺราปฺย กิญฺจนวฺรตนิมิตฺตํ กึกฺริยานคเร ศิโร มุณฺฑยิตฺวา ปฺริสฺกิลฺลากฺกิลาภฺยำ สหิโต ชลปเถน สุริยาเทศํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ตต อิผิษนคร อุปสฺถาย ตตฺร เตา วิสฺฤชฺย สฺวยํ ภชนภฺวนํ ปฺรวิศฺย ยิหูทีไย: สห วิจาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","เต ไสฺว: สารฺทฺธํ ปุน: กติปยทินานิ สฺถาตุํ ตํ วฺยนยนฺ, ส ตทนุรรีกฺฤตฺย กถาเมตำ กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ยิรูศาลมิ อาคามฺยุตฺสวปาลนารฺถํ มยา คมนียํ; ปศฺจาทฺ อีศฺวเรจฺฉายำ ชาตายำ ยุษฺมากํ สมีปํ ปฺรตฺยาคมิษฺยามิฯ ตต: ปรํ ส ไต รฺวิสฺฤษฺฏ: สนฺ ชลปเถน อิผิษนคราตฺ ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ตต: ไกสริยามฺ อุปสฺถิต: สนฺ นครํ คตฺวา สมาชํ นมสฺกฺฤตฺย ตสฺมาทฺ อานฺติยขิยานครํ ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ตตฺร กิยตฺกาลํ ยาปยิตฺวา ตสฺมาตฺ ปฺรสฺถาย สรฺเวฺวษำ ศิษฺยาณำ มนำสิ สุสฺถิราณิ กฺฤตฺวา กฺรมโศ คลาติยาผฺรุคิยาเทศโย รฺภฺรมิตฺวา คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ตสฺมินฺเนว สมเย สิกนฺทริยานคเร ชาต อาปโลฺลนามา ศาสฺตฺรวิตฺ สุวกฺตา ยิหูทีย เอโก ชน อิผิษนครมฺ อาคตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ส ศิกฺษิตปฺรภุมารฺโค มนโสโทฺยคี จ สนฺ โยหโน มชฺชนมาตฺรํ ชฺญาตฺวา ยถารฺถตยา ปฺรโภ: กถำ กถยนฺ สมุปาทิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","เอษ ชโน นิรฺภยเตฺวน ภชนภวเน กถยิตุมฺ อารพฺธวานฺ, ตต: ปฺริสฺกิลฺลากฺกิเลา ตโสฺยปเทศกถำ นิศมฺย ตํ สฺวโย: สมีปมฺ อานีย ศุทฺธรูเปเณศฺวรสฺย กถามฺ อโพธยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ปศฺจาตฺ ส อาขายาเทศํ คนฺตุํ มตึ กฺฤตวานฺ, ตทา ตตฺรตฺย: ศิษฺยคโณ ยถา ตํ คฺฤหฺลาติ ตทรฺถํ ภฺราตฺฤคเณน สมาศฺวสฺย ปเตฺร ลิขิเต สติ, อาปลฺลาสฺตโตฺรปสฺถิต: สนฺ อนุคฺรเหณ ปฺรตฺยยินำ พหูปการานฺ อกโรตฺ, ");
INSERT INTO santha_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ผลโต ยีศุรภิษิกฺตสฺตฺราเตติ ศาสฺตฺรปฺรมาณํ ทตฺวา ปฺรกาศรูเปณ ปฺรติปนฺนํ กฺฤตฺวา ยิหูทียานฺ นิรุตฺตรานฺ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","กรินฺถนคร อาปลฺลส: สฺถิติกาเล เปาล อุตฺตรปฺรเทไศราคจฺฉนฺ อิผิษนครมฺ อุปสฺถิตวานฺฯ ตตฺร กติปยศิษฺยานฺ สากฺษตฺ ปฺราปฺย ตานฺ อปฺฤจฺฉตฺ, ");
INSERT INTO santha_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ยูยํ วิศฺวสฺย ปวิตฺรมาตฺมานํ ปฺราปฺตา น วา? ตตเสฺต ปฺรตฺยวทนฺ ปวิตฺร อาตฺมา ทียเต อิตฺยสฺมาภิ: ศฺรุตมปิ นหิฯ ");
INSERT INTO santha_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ตทา สา'วทตฺ ตรฺหิ ยูยํ เกน มชฺชิตา อภวต? เต'กถยนฺ โยหโน มชฺชเนนฯ ");
INSERT INTO santha_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ตทา เปาล อุกฺตวานฺ อิต: ปรํ ย อุปสฺถาสฺยติ ตสฺมินฺ อรฺถต ยีศุขฺรีษฺเฏ วิศฺวสิตวฺยมิตฺยุกฺตฺวา โยหนฺ มน:ปริวรฺตฺตนสูจเกน มชฺชเนน ชเล โลกานฺ อมชฺชยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ตาทฺฤศีํ กถำ ศฺรุตฺวา เต ปฺรโภ รฺยีศุขฺรีษฺฏสฺย นามฺนา มชฺชิตา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ตต: เปาเลน เตษำ คาเตฺรษุ กเร'รฺปิเต เตษามุปริ ปวิตฺร อาตฺมาวรูฒวานฺ, ตสฺมาตฺ เต นานาเทศียา ภาษา ภวิษฺยตฺกถาศฺจ กถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","เต ปฺราเยณ ทฺวาทศชนา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","เปาโล ภชนภวนํ คตฺวา ปฺราเยณ มาสตฺรยมฺ อีศฺวรสฺย ราชฺยสฺย วิจารํ กฺฤตฺวา โลกานฺ ปฺรวรฺตฺย สาหเสน กถามกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","กินฺตุ กฐินานฺต:กรณตฺวาตฺ กิยนฺโต ชนา น วิศฺวสฺย สรฺเวฺวษำ สมกฺษมฺ เอตตฺปถสฺย นินฺทำ กรฺตฺตุํ ปฺรวฺฤตฺตา:, อต: เปาลเสฺตษำ สมีปาตฺ ปฺรสฺถาย ศิษฺยคณํ ปฺฤถกฺกฺฤตฺวา ปฺรตฺยหํ ตุรานฺนนามฺน: กสฺยจิตฺ ชนสฺย ปาฐศาลายำ วิจารํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","อิตฺถํ วตฺสรทฺวยํ คตํ ตสฺมาทฺ อาศิยาเทศนิวาสิน: สรฺเวฺว ยิหูทียา อนฺยเทศียโลกาศฺจ ปฺรโภ รฺยีโศ: กถามฺ อเศฺราษนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","เปาเลน จ อีศฺวร เอตาทฺฤศานฺยทฺภุตานิ กรฺมฺมาณิ กฺฤตวานฺ ");
INSERT INTO santha_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ยตฺ ปริเธเย คาตฺรมารฺชนวสฺเตฺร วา ตสฺย เทหาตฺ ปีฑิตโลกานามฺ สมีปมฺ อานีเต เต นิรามยา ชาตา อปวิตฺรา ภูตาศฺจ เตโภฺย พหิรฺคตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ตทา เทศาฏนการิณ: กิยนฺโต ยิหูทียา ภูตาปสาริโณ ภูตคฺรสฺตโนกานำ สนฺนิเธา ปฺรเภ รฺยีโศ รฺนาม ชปฺตฺวา วากฺยมิทมฺ อวทนฺ, ยสฺย กถำ เปาล: ปฺรจารยติ ตสฺย ยีโศ รฺนามฺนา ยุษฺมานฺ อาชฺญาปยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","สฺกิวนามฺโน ยิหูทียานำ ปฺรธานยาชกสฺย สปฺตภิ: ปุตฺไตสฺตถา กฺฤเต สติ ");
INSERT INTO santha_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","กศฺจิทฺ อปวิโตฺร ภูต: ปฺรตฺยุทิตวานฺ, ยีศุํ ชานามิ เปาลญฺจ ปริจิโนมิ กินฺตุ เก ยูยํ? ");
INSERT INTO santha_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","อิตฺยุกฺตฺวา โสปวิตฺรภูตคฺรโสฺต มนุโษฺย ลมฺผํ กฺฤตฺวา เตษามุปริ ปติตฺวา พเลน ตานฺ ชิตวานฺ, ตสฺมาตฺเต นคฺนา: กฺษตางฺคาศฺจ สนฺตสฺตสฺมาทฺ เคหาตฺ ปลายนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","สา วาคฺ อิผิษนครนิวาสินสํ สรฺเวฺวษำ ยิหูทียานำ ภินฺนเทศียานำ โลกานาญฺจ ศฺรโวโคจรีภูตา; ตต: สรฺเวฺว ภยํ คตา: ปฺรโภ รฺยีโศ รฺนามฺโน ยโศ 'วรฺทฺธตฯ ");
INSERT INTO santha_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","เยษามเนเกษำ โลกานำ ปฺรตีติรชายต ต อาคตฺย ไสฺว: กฺฤตา: กฺริยา: ปฺรกาศรูเปณางฺคีกฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","พหโว มายากรฺมฺมการิณ: สฺวสฺวคฺรนฺถานฺ อานีย ราศีกฺฤตฺย สรฺเวฺวษำ สมกฺษมฺ อทาหยนฺ, ตโต คณนำ กฺฤตฺวาพุธฺยนฺต ปญฺจายุตรูปฺยมุทฺรามูลฺยปุสฺตกานิ ทคฺธานิฯ ");
INSERT INTO santha_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","อิตฺถํ ปฺรโภ: กถา สรฺวฺวเทศํ วฺยาปฺย ปฺรพลา ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","สรฺเวฺวเษฺวเตษุ กรฺมฺมสุ สมฺปนฺเนษุ สตฺสุ เปาโล มากิทนิยาขายาเทศาภฺยำ ยิรูศาลมํ คนฺตุํ มตึ กฺฤตฺวา กถิตวานฺ ตตฺสฺถานํ ยาตฺรายำ กฺฤตายำ สตฺยำ มยา โรมานครํ ทฺรษฺฏวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","สฺวานุคตโลกานำ ตีมถิเยราเสฺตา เทฺวา ชเนา มากิทนิยาเทศํ ปฺรติ ปฺรหิตฺย สฺวยมฺ อาศิยาเทเศ กติปยทินานิ สฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","กินฺตุ ตสฺมินฺ สมเย มเต'สฺมินฺ กลโห ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ตตฺการณมิทํ, อรฺตฺติมีเทวฺยา รูปฺยมนฺทิรนิรฺมฺมาเณน สรฺเวฺวษำ ศิลฺปินำ ยเถษฺฏลาภมฺ อชนยตฺ โย ทีมีตฺริยนามา นาฑีนฺธม: ");
INSERT INTO santha_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ส ตานฺ ตตฺกรฺมฺมชีวิน: สรฺวฺวโลกำศฺจ สมาหูย ภาษิตวานฺ เห มเหจฺฉา เอเตน มนฺทิรนิรฺมฺมาเณนาสฺมากํ ชีวิกา ภวติ, เอตทฺ ยูยํ วิตฺถ; ");
INSERT INTO santha_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","กินฺตุ หสฺตนิรฺมฺมิเตศฺวรา อีศฺวรา นหิ เปาลนามฺนา เกนจิชฺชเนน กถามิมำ วฺยาหฺฤตฺย เกวเลผิษนคเร นหิ ปฺราเยณ สรฺวฺวสฺมินฺ อาศิยาเทเศ ปฺรวฺฤตฺตึ คฺราหยิตฺวา พหุโลกานำ เศมุษี ปราวรฺตฺติตา, เอตทฺ ยุษฺมาภิ รฺทฺฤศฺยเต ศฺรูยเต จฯ ");
INSERT INTO santha_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","เตนาสฺมากํ วาณิชฺยสฺย สรฺวฺวถา หาเน: สมฺภวนํ เกวลมิติ นหิ, อาศิยาเทศไสฺถ รฺวา สรฺวฺวชคตฺไสฺถ โรฺลไก: ปูชฺยา ยารฺติมี มหาเทวี ตสฺยา มนฺทิรสฺยาวชฺญานสฺย ตสฺยา ไอศฺวรฺยฺยสฺย นาศสฺย จ สมฺภาวนา วิทฺยเตेฯ ");
INSERT INTO santha_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","เอตาทฺฤศีํ กถำ ศฺรุตฺวา เต มหาโกฺรธานฺวิตา: สนฺต อุจฺไจ:การํ กถิตวนฺต อิผิษียานามฺ อรฺตฺติมี เทวี มหตี ภวติฯ ");
INSERT INTO santha_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ตต: สรฺวฺวนครํ กลเหน ปริปูรฺณมภวตฺ, ตต: ปรํ เต มากิทนียคายาริสฺตารฺขนามาเนา เปาลสฺย เทฺวา สหจเรา ธฺฤไตฺวกจิตฺตา รงฺคภูมึ ชเวน ธาวิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ตต: เปาโล โลกานำ สนฺนิธึ ยาตุมฺ อุทฺยตวานฺ กินฺตุ ศิษฺยคณสฺตํ วาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","เปาลสฺยตฺมียา อาศิยาเทศสฺถา: กติปยา: ปฺรธานโลกาสฺตสฺย สมีปํ นรเมกํ เปฺรษฺย ตฺวํ รงฺคภูมึ มาคา อิติ นฺยเวทยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ตโต นานาโลกานำ นานากถากถนาตฺ สภา วฺยากุลา ชาตา กึ การณาทฺ เอตาวตี ชนตาภวตฺ เอตทฺ อธิไก โรฺลไก รฺนาชฺญายิฯ ");
INSERT INTO santha_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ตต: ปรํ ชนตามธฺยาทฺ ยิหูทีไยรฺพหิษฺกฺฤต: สิกนฺทโร หเสฺตน สงฺเกตํ กฺฤตฺวา โลเกภฺย อุตฺตรํ ทาตุมุทฺยตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","กินฺตุ ส ยิหูทียโลก อิติ นิศฺจิเต สติ อิผิษียานามฺ อรฺตฺติมี เทวี มหตีติ วากฺยํ ปฺราเยณ ปญฺจ ทณฺฑานฺ ยาวทฺ เอกสฺวเรณ โลกนิวไห: โปฺรกฺตํฯ ");
INSERT INTO santha_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ตโต นคราธิปติสฺตานฺ สฺถิรานฺ กฺฤตฺวา กถิตวานฺ เห อิผิษายา: สรฺเวฺว โลกา อากรฺณยต, อรฺติมีมหาเทวฺยา มหาเทวาตฺ ปติตายาสฺตตฺปฺรติมายาศฺจ ปูชนม อิผิษนครสฺถา: สรฺเวฺว โลกา: กุรฺวฺวนฺติ, เอตตฺ เก น ชานนฺติ? ");
INSERT INTO santha_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ตสฺมาทฺ เอตตฺปฺรติกูลํ เกปิ กถยิตุํ น ศกฺนุวนฺติ, อิติ ชฺญาตฺวา ยุษฺมาภิ: สุสฺถิรเตฺวน สฺถาตวฺยมฺ อวิวิจฺย กิมปิ กรฺมฺม น กรฺตฺตวฺยญฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ยานฺ เอตานฺ มนุษฺยานฺ ยูยมตฺร สมานยต เต มนฺทิรทฺรวฺยาปหารกา ยุษฺมากํ เทวฺยา นินฺทกาศฺจ น ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ยทิ กญฺจน ปฺรติ ทีมีตฺริยสฺย ตสฺย สหายานาญฺจ กาจิทฺ อาปตฺติ รฺวิทฺยเต ตรฺหิ ปฺรตินิธิโลกา วิจารสฺถานญฺจ สนฺติ, เต ตตฺ สฺถานํ คตฺวา อุตฺตรปฺรตฺยุตฺตเร กุรฺวฺวนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","กินฺตุ ยุษฺมากํ กาจิทปรา กถา ยทิ ติษฺฐติ ตรฺหิ นิยมิตายำ สภายำ ตสฺยา นิษฺปตฺติ รฺภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","กินฺเตฺวตสฺย วิโรธโสฺยตฺตรํ เยน ทาตุํ ศกฺนุมฺ เอตาทฺฤศสฺย กสฺยจิตฺ การณสฺยาภาวาทฺ อทฺยตนฆฏนาเหโต ราชโทฺรหิณามิวาสฺมากมฺ อภิโยโค ภวิษฺยตีติ ศงฺกา วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","อิติ กถยิตฺวา ส สภาสฺถโลกานฺ วิสฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","อิตฺถํ กลเห นิวฺฤตฺเต สติ เปาล: ศิษฺยคณมฺ อาหูย วิสรฺชนํ ปฺราปฺย มากิทนิยาเทศํ ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","เตน สฺถาเนน คจฺฉนฺ ตทฺเทศียานฺ ศิษฺยานฺ พหูปทิศฺย ยูนานียเทศมฺ อุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ตตฺร มาสตฺรยํ สฺถิตฺวา ตสฺมาตฺ สุริยาเทศํ ยาตุมฺ อุทฺยต:, กินฺตุ ยิหูทียาสฺตํ หนฺตุํ คุปฺตา อติษฺฐนฺ ตสฺมาตฺ ส ปุนรปิ มากิทนิยามารฺเคณ ปฺรตฺยาคนฺตุํ มตึ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","พิรยานครียโสปาตฺร: ถิษลนีกียาริสฺตารฺขสิกุนฺเทา ทรฺพฺโพนครียคายตีมถิเยา อาศิยาเทศียตุขิกตฺรผิเมา จ เตน สารฺทฺธํ อาศิยาเทศํ ยาวทฺ คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","เอเต สรฺเวฺว 'คฺรสรา: สนฺโต 'สฺมานฺ อเปกฺษฺย โตฺรยานคเร สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","กิณฺวศูนฺยปูโปตฺสวทิเน จ คเต สติ วยํ ผิลิปีนคราตฺ โตยปเถน คตฺวา ปญฺจภิ รฺทิไนสฺโตฺรยานครมฺ อุปสฺถาย ตตฺร สปฺตทินานฺยวาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","สปฺตาหสฺย ปฺรถมทิเน ปูปานฺ ภํกฺตุ ศิเษฺยษุ มิลิเตษุ เปาล: ปรทิเน ตสฺมาตฺ ปฺรสฺถาตุมฺ อุทฺยต: สนฺ ตทหฺนิ ปฺราเยณ กฺษปายา ยามทฺวยํ ยาวตฺ ศิเษฺยโภฺย ธรฺมฺมกถามฺ อกถยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","อุปริเสฺถ ยสฺมินฺ ปฺรโกษฺเฐ สภำ กฺฤตฺวาสนฺ ตตฺร พหว: ปฺรทีปา: ปฺราชฺวลนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","อุตุขนามา กศฺจน ยุวา จ วาตายน อุปวิศนฺ โฆรตรนิทฺราคฺรโสฺต 'ภูตฺ ตทา เปาเลน พหุกฺษณํ กถายำ ปฺรจาริตายำ นิทฺรามคฺน: ส ตสฺมาทฺ อุปริสฺถตฺฤตียปฺรโกษฺฐาทฺ อปตตฺ, ตโต โลกาสฺตํ มฺฤตกลฺปํ ธฺฤโตฺวทโตลยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ตต: เปาโล'วรุหฺย ตสฺย คาเตฺร ปติตฺวา ตํ โกฺรเฑ นิธาย กถิตวานฺ, ยูยํ วฺยากุลา มา ภูต นายํ ปฺราไณ รฺวิยุกฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ปศฺจาตฺ ส ปุนศฺโจปริ คตฺวา ปูปานฺ ภํกฺตฺวา ปฺรภาตํ ยาวตฺ กโถปกถเน กฺฤตฺวา ปฺรสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","เต จ ตํ ชีวนฺตํ ยุวานํ คฺฤหีตฺวา คตฺวา ปรมาปฺยายิตา ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","อนนฺตรํ วยํ โปเตนาคฺรสรา ภูตฺวาสฺมนครมฺ อุตฺตีรฺยฺย เปาลํ คฺรหีตุํ มติมฺ อกุรฺมฺม ยต: ส ตตฺร ปทฺภฺยำ วฺรชิตุํ มตึ กฺฤเตฺวติ นิรูปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ตสฺมาตฺ ตตฺราสฺมาภิ: สารฺทฺธํ ตสฺมินฺ มิลิเต สติ วยํ ตํ นีตฺวา มิตุลีนฺยุปทฺวีปํ ปฺราปฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ตสฺมาตฺ โปตํ โมจยิตฺวา ปเร'หนิ ขีโยปทฺวีปสฺย สมฺมุขํ ลพฺธวนฺตสฺตสฺมาทฺ เอเกนาหฺนา สาโมปทฺวีปํ คตฺวา โปตํ ลาคยิตฺวา โตฺรคุลฺลิเย สฺถิตฺวา ปรสฺมินฺ ทิวเสे มิลีตนครมฺ อุปาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ยต: เปาล อาศิยาเทเศ กาลํ ยาปยิตุมฺ นาภิลษนฺ อิผิษนครํ ตฺยกฺตฺวา ยาตุํ มนฺตฺรณำ สฺถิรีกฺฤตวานฺ; ยสฺมาทฺ ยทิ สาธฺยํ ภวติ ตรฺหิ นิสฺตาโรตฺสวสฺย ปญฺจาศตฺตมทิเน ส ยิรูศาลมฺยุปสฺถาตุํ มตึ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","เปาโล มิลีตาทฺ อิผิษํ ปฺรติ โลกํ ปฺรหิตฺย สมาชสฺย ปฺราจีนานฺ อาหูยานีตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","เตษุ ตสฺย สมีปมฺ อุปสฺถิเตษุ ส เตภฺย อิมำ กถำ กถิตวานฺ, อหมฺ อาศิยาเทเศ ปฺรถมาคมนมฺ อารภฺยาทฺย ยาวทฺ ยุษฺมากํ สนฺนิเธา สฺถิตฺวา สรฺวฺวสมเย ยถาจริตวานฺ ตทฺ ยูยํ ชานีถ; ");
INSERT INTO santha_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ผลต: สรฺวฺวถา นมฺรมนา: สนฺ พหุศฺรุปาเตน ยิหุทียานามฺ กุมนฺตฺรณาชาตนานาปรีกฺษาภิ: ปฺรโภ: เสวามกรวํฯ ");
INSERT INTO santha_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","กามปิ หิตกถาाํ น โคปายิตวานฺ ตำ ปฺรจารฺยฺย สปฺรกาศํ คฺฤเห คฺฤเห สมุปทิเศฺยศฺวรํ ปฺรติ มน: ปราวรฺตฺตนียํ ปฺรเภา ยีศุขฺรีษฺเฏ วิศฺวสนียํ ");
INSERT INTO santha_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ยิหูทียานามฺ อนฺยเทศียโลกานาญฺจ สมีป เอตาทฺฤศํ สากฺษฺยํ ททามิฯ ");
INSERT INTO santha_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ปศฺยต สามฺปฺรตมฺ อาตฺมนากฺฤษฺฏ: สนฺ ยิรูศาลมฺนคเร ยาตฺรำ กโรมิ, ตตฺร มามฺปฺรติ ยทฺยทฺ ฆฏิษฺยเต ตานฺยหํ น ชานามิ; ");
INSERT INTO santha_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","กินฺตุ มยา พนฺธนํ เกฺลศศฺจ โภกฺตวฺย อิติ ปวิตฺร อาตฺมา นคเร นคเร ปฺรมาณํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ตถาปิ ตํ เกฺลศมหํ ตฺฤณาย น มเนฺย; อีศฺวรสฺยานุคฺรหวิษยกสฺย สุสํวาทสฺย ปฺรมาณํ ทาตุํ, ปฺรโภ รฺยีโศ: สกาศาท ยสฺยา: เสวายา: ภารํ ปฺราปฺนวํ ตำ เสวำ สาธยิตุํ สานนฺทํ สฺวมารฺคํ สมาปยิตุुญฺจ นิชปฺราณานปิ ปฺริยานฺ น มเนฺยฯ ");
INSERT INTO santha_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","อธุนา ปศฺยต เยษำ สมีเป'หมฺ อีศฺวรียราชฺยสฺย สุสํวาทํ ปฺรจารฺยฺย ภฺรมณํ กฺฤตวานฺ เอตาทฺฤศา ยูยํ มม วทนํ ปุน รฺทฺรษฺฏุํ น ปฺราปฺสฺยถ เอตทปฺยหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ยุษฺมภฺยมฺ อหมฺ อีศฺวรสฺย สรฺวฺวานฺ อาเทศานฺ ปฺรกาศยิตุํ น นฺยวรฺตฺเตฯ ");
INSERT INTO santha_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","อหํ สรฺเวฺวษำ โลกานำ รกฺตปาตโทษาทฺ ยนฺนิรฺโทษ อาเส ตสฺยาทฺย ยุษฺมานฺ สากฺษิณ: กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ยูยํ เสฺวษุ ตถา ยสฺย วฺรชสฺยาธฺยกฺษนฺ อาตฺมา ยุษฺมานฺ วิธาย นฺยยุงฺกฺต ตตฺสรฺวฺวสฺมินฺ สาวธานา ภวต, ย สมาชญฺจ ปฺรภุ รฺนิชรกฺตมูเลฺยน กฺรีตวาน ตมฺ อวต, ");
INSERT INTO santha_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ยโต มยา คมเน กฺฤเตอว ทุรฺชยา วฺฤกา ยุษฺมากํ มธฺยํ ปฺรวิศฺย วฺรชํ ปฺรติ นิรฺทยตามฺ อาจริษฺยนฺติ, ");
INSERT INTO santha_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ยุษฺมากเมว มธฺยาทปิ โลกา อุตฺถาย ศิษฺยคณมฺ อปหนฺตุํ วิปรีตมฺ อุปเทกฺษฺยนฺตีตฺยหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","อิติ เหโต รฺยูยํ สไจตนฺยา: สนฺตสฺติษฺฏต, อหญฺจ สาศฺรุปาต: สนฺ วตฺสรตฺรยํ ยาวทฺ ทิวานิศํ ปฺรติชนํ โพธยิตุํ น นฺยวรฺตฺเต ตทปิ สฺมรตฯ ");
INSERT INTO santha_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","อิทานีํ เห ภฺราตโร ยุษฺมากํ นิษฺฐำ ชนยิตุํ ปวิตฺรีกฺฤตโลกานำ มเธฺย'ธิการญฺจ ทาตุํ สมรฺโถ ย อีศฺวรสฺตสฺยานุคฺรหสฺย โย วาทศฺจ ตโยรุภโย รฺยุษฺมานฺ สมารฺปยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","กสฺยาปิ สฺวรฺณํ รูปฺยํ วสฺตฺรํ วา ปฺรติ มยา โลโภ น กฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","กินฺตุ มม มตฺสหจรโลกานาญฺจาวศฺยกวฺยยาย มทียมิทํ กรทฺวยมฺ อศฺรามฺยทฺ เอตทฺ ยูยํ ชานีถฯ ");
INSERT INTO santha_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","อเนน ปฺรกาเรณ คฺรหณทฺ ทานํ ภทฺรมิติ ยทฺวากฺยํ ปฺรภุ รฺยีศุ: กถิตวานฺ ตตฺ สฺมรฺตฺตุํ ทริทฺรโลกานามุปการารฺถํ ศฺรมํ กรฺตฺตุญฺจ ยุษฺมากมฺ อุจิตมฺ เอตตฺสรฺวฺวํ ยุษฺมานหมฺ อุปทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","เอตำ กถำ กถยิตฺวา ส ชานุนี ปาตยิตฺวา สไรฺว: สห ปฺรารฺถยตฯ ");
INSERT INTO santha_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","เตน เต กฺรนฺทฺรนฺต: ");
INSERT INTO santha_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ปุน รฺมม มุขํ น ทฺรกฺษฺยถ วิเศษต เอษา ยา กถา เตนากถิ ตตฺการณาตฺ โศกํ วิลาปญฺจ กฺฤตฺวา กณฺฐํ ธฺฤตฺวา จุมฺพิตวนฺต:ฯ ปศฺจาตฺ เต ตํ โปตํ นีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ไต รฺวิสฺฤษฺฏา: สนฺโต วยํ โปตํ พาหยิตฺวา ฤชุมารฺเคณ โกษมฺ อุปทฺวีปมฺ อาคตฺย ปเร'หนิ โรทิโยปทฺวีปมฺ อาคจฺฉาม ตตสฺตสฺมาตฺ ปาตารายามฺ อุปาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ตตฺร ไผนีกิยาเทศคามินมฺ โปตเมกํ ปฺราปฺย ตมารุหฺย คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","กุโปฺรปทฺวีปํ ทฺฤษฺฏฺวา ตํ สวฺยทิศิ สฺถาปยิตฺวา สุริยาเทศํ คตฺวา โปตสฺถทฺรวฺยาณฺยวโรหยิตุํ โสรนคเร ลาคิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ตตฺร ศิษฺยคณสฺย สากฺษาตฺกรณาย วยํ ตตฺร สปฺตทินานิ สฺถิตวนฺต: ปศฺจาตฺเต ปวิเตฺรณาตฺมนา เปาลํ วฺยาหรนฺ ตฺวํ ยิรูศาลมฺนครํ มา คม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ตตเสฺตษุ สปฺตสุ ทิเนษุ ยาปิเตษุ สตฺสุ วยํ ตสฺมาตฺ สฺถานาตฺ นิชวรฺตฺมนา คตวนฺต:, ตสฺมาตฺ เต สพาลวฺฤทฺธวนิตา อสฺมาภิ: สห นครสฺย ปริสรปรฺยฺยนฺตมฺ อาคตา: ปศฺจาทฺวยํ ชลธิตเฏ ชานุปาตํ ปฺรารฺถยามหิฯ ");
INSERT INTO santha_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ตต: ปรสฺปรํ วิสฺฤษฺฏา: สนฺโต วยํ โปตํ คตาเสฺต ตุ สฺวสฺวคฺฤหํ ปฺรตฺยาคตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","วยํ โสรนคราตฺ นาวา ปฺรสฺถาย ตลิมายินครมฺ อุปาติษฺฐาม ตตฺราสฺมากํ สมุทฺรียมารฺคสฺยานฺโต'ภวตฺ ตตฺร ภฺราตฺฤคณํ นมสฺกฺฤตฺย ทินเมกํ ไต: สารฺทฺธมฺ อุษตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ปเร 'หนิ เปาลสฺตสฺย สงฺคิโน วยญฺจ ปฺรติษฺฐมานา: ไกสริยานครมฺ อาคตฺย สุสํวาทปฺรจารกานำ สปฺตชนานำ ผิลิปนามฺน เอกสฺย คฺฤหํ ปฺรวิศฺยาวติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ตสฺย จตโสฺร ทุหิตโร'นูฒา ภวิษฺยทฺวาทินฺย อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ตตฺราสฺมาสุ พหุทินานิ โปฺรษิเตษุ ยิหูทียเทศาทฺ อาคตฺยาคาพนามา ภวิษฺยทฺวาที สมุปสฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","โสสฺมากํ สมีปเมตฺย เปาลสฺย กฏิพนฺธนํ คฺฤหีตฺวา นิชหสฺตาปาทานฺ พทฺธฺวา ภาษิตวานฺ ยเสฺยทํ กฏิพนฺธนํ ตํ ยิหูทียโลกา ยิรูศาลมนคร อิตฺถํ พทฺธฺวา ภินฺนเทศียานำ กเรษุ สมรฺปยิษฺยนฺตีติ วากฺยํ ปวิตฺร อาตฺมา กถยติฯ ");
INSERT INTO santha_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","เอตาทฺฤศีํ กถำ ศฺรุตฺวา วยํ ตนฺนครวาสิโน ภฺราตรศฺจ ยิรูศาลมํ น ยาตุํ เปาลํ วฺยนยามหิ; ");
INSERT INTO santha_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","กินฺตุ ส ปฺรตฺยาวาทีตฺ, ยูยํ กึ กุรุถ? กึ กฺรนฺทเนน มมานฺต:กรณํ วิทีรฺณํ กริษฺยถ? ปฺรโภ รฺยีโศ รฺนามฺโน นิมิตฺตํ ยิรูศาลมิ พทฺโธ ภวิตุํ เกวล ตนฺน ปฺราณานฺ ทาตุมปิ สสชฺโชสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","เตนาสฺมากํ กถายามฺ อคฺฤหีตายามฺ อีศฺวรสฺย ยเถจฺฉา ตไถว ภวตฺวิตฺยุกฺตฺวา วยํ นิรสฺยามฯ ");
INSERT INTO santha_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ปเร'หนิ ปาเถยทฺรวฺยาณิ คฺฤหีตฺวา ยิรูศาลมํ ปฺรติ ยาตฺรามฺ อกุรฺมฺมฯ ");
INSERT INTO santha_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ตต: ไกสริยานครนิวาสิน: กติปยา: ศิษฺยา อสฺมาภิ: สารฺทฺธมฺ อิตฺวา กฺฤปฺรีเยน มฺนาสนฺนามฺนา เยน ปฺราจีนศิเษฺยน สารฺทฺธมฺ อสฺมาภิ รฺวสฺตวฺยํ ตสฺย สมีปมฺ อสฺมานฺ นีตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","อสฺมาสุ ยิรูศาลมฺยุปสฺถิเตษุ ตตฺรสฺถภฺราตฺฤคโณ'สฺมานฺ อาหฺลาเทน คฺฤหีตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ปรสฺมินฺ ทิวเส เปาเล'สฺมาภิ: สห ยากูโพ คฺฤหํ ปฺรวิษฺเฏ โลกปฺราจีนา: สรฺเวฺว ตตฺร ปริษทิ สํสฺถิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","อนนฺตรํ ส ตานฺ นตฺวา สฺวียปฺรจารเณน ภินฺนเทศียานฺ ปฺรตีศฺวโร ยานิ กรฺมฺมาณิ สาธิตวานฺ ตทียำ กถามฺ อนุกฺรมาตฺ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","อิติ ศฺรุตฺวา เต ปฺรภุํ ธนฺยํ โปฺรจฺย วากฺยมิทมฺ อภาษนฺต, เห ภฺราต รฺยิหูทียานำ มเธฺย พหุสหสฺราณิ โลกา วิศฺวาสิน อาสเต กินฺตุ เต สรฺเวฺว วฺยวสฺถามตาจาริณ เอตตฺ ปฺรตฺยกฺษํ ปศฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ศิศูนำ ตฺวกฺเฉทนาทฺยาจรณํ ปฺรติษิธฺย ตฺวํ ภินฺนเทศนิวาสิโน ยิหูทียโลกานฺ มูสาวากฺยมฺ อศฺรทฺธาตุมฺ อุปทิศสีติ ไต: ศฺรุตมสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ตฺวมตฺราคโตสีติ วารฺตฺตำ สมากรฺณฺย ชนนิวโห มิลิตฺวาวศฺยเมวาคมิษฺยติ; อเตอว กึ กรณียมฺ? อตฺร วยํ มนฺตฺรยิตฺวา สมุปายํ ตฺวำ วทามสฺตํ ตฺวมาจรฯ ");
INSERT INTO santha_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","วฺรตํ กรฺตฺตุํ กฺฤตสงฺกลฺปา เย'สฺมำก จตฺวาโร มานวา: สนฺติ ");
INSERT INTO santha_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ตานฺ คฺฤหีตฺวา ไต: สหิต: สฺวํ ศุจึ กุรุ ตถา เตษำ ศิโรมุณฺฑเน โย วฺยโย ภวติ ตํ ตฺวํ เทหิฯ ตถา กฺฤเต ตฺวทียาจาเร ยา ชนศฺรุติ รฺชายเต สาลีกา กินฺตุ ตฺวํ วิธึ ปาลยนฺ วฺยวสฺถานุสาเรเณวาจรสีติ เต โภตฺสนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ภินฺนเทศียานำ วิศฺวาสิโลกานำ นิกเฏ วยํ ปตฺรํ ลิขิเตฺวตฺถํ สฺถิรีกฺฤตวนฺต:, เทวปฺรสาทโภชนํ รกฺตํ คลปีฑนมาริตปฺราณิโภชนํ วฺยภิจารศฺไจเตภฺย: สฺวรกฺษณวฺยติเรเกณ เตษามนฺยวิธิปาลนํ กรณียํ นฯ ");
INSERT INTO santha_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ตต: เปาลสฺตานฺ มานุษานาทาย ปรสฺมินฺ ทิวเส ไต: สห ศุจิ รฺภูตฺวา มนฺทิรํ คตฺวา เศาจกรฺมฺมโณ ทิเนษุ สมฺปูรฺเณษุ เตษามฺ เอไกการฺถํ ไนเวทฺยาทฺยุตฺสรฺโค ภวิษฺยตีติ ชฺญาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","เตษุ สปฺตสุ ทิเนษุ สมาปฺตกลฺเปษุ อาศิยาเทศนิวาสิโน ยิหูทียาสฺตํ มเธฺยมนฺทิรํ วิโลกฺย ชนนิวหสฺย มน:สุ กุปฺรวฺฤตฺตึ ชนยิตฺวา ตํ ธฺฤตฺวา ");
INSERT INTO santha_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","โปฺรจฺไจ: ปฺราโวจนฺ, เห อิสฺราเยโลฺลกา: สรฺเวฺว สาหายฺยํ กุรุตฯ โย มนุช เอเตษำ โลกานำ มูสาวฺยวสฺถายา เอตสฺย สฺถานสฺยาปิ วิปรีตํ สรฺวฺวตฺร สรฺวฺวานฺ ศิกฺษยติ ส เอษ:; วิเศษต: ส ภินฺนเทศียโลกานฺ มนฺทิรมฺ อานีย ปวิตฺรสฺถานเมตทฺ อปวิตฺรมกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ปูรฺวฺวํ เต มเธฺยนครมฺ อิผิษนครียํ ตฺรผิมํ เปาเลน สหิตํ ทฺฤษฺฏวนฺต เอตสฺมาตฺ เปาลสฺตํ มนฺทิรมธฺยมฺ อานยทฺ อิตฺยนฺวมิมตฯ ");
INSERT INTO santha_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","อเตอว สรฺวฺวสฺมินฺ นคเร กลโหตฺปนฺนตฺวาตฺ ธาวนฺโต โลกา อาคตฺย เปาลํ ธฺฤตฺวา มนฺทิรสฺย พหิรากฺฤษฺยานยนฺ ตตฺกฺษณาทฺ ทฺวาราณิ สรฺวฺวาณิ จ รุทฺธานิฯ ");
INSERT INTO santha_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","เตษุ ตํ หนฺตุมุทฺยเตेษุ ยิรูศาลมฺนคเร มหานุปทฺรโว ชาต อิติ วารฺตฺตายำ สหสฺรเสนาปเต: กรฺณโคจรีภูตายำ สตฺยำ ส ตตฺกฺษณาตฺ ไสนฺยานิ เสนาปติคณญฺจ คฺฤหีตฺวา ชเวนาคตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ตโต โลกา: เสนาคเณน สห สหสฺรเสนาปติมฺ อาคจฺฉนฺตํ ทฺฤษฺฏฺวา เปาลตาฑนาโต นฺยวรฺตฺตนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ส สหสฺรเสนาปติ: สนฺนิธาวาคมฺย เปาลํ ธฺฤตฺวา ศฺฤงฺขลทฺวเยน พทฺธมฺ อาทิศฺย ตานฺ ปฺฤษฺฏวานฺ เอษ ก:? กึ กรฺมฺม จายํ กฺฤตวานฺ? ");
INSERT INTO santha_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ตโต ชนสมูหสฺย กศฺจิทฺ เอกปฺรการํ กศฺจิทฺ อนฺยปฺรการํ วากฺยมฺ อเราตฺ ส ตตฺร สตฺยํ ชฺญาตุมฺ กลหการณาทฺ อศกฺต: สนฺ ตํ ทุรฺคํ เนตุมฺ อาชฺญาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","เตษุ โสปานโสฺยปริ ปฺราปฺเตษุ โลกานำ สาหสการณาตฺ เสนาคณ: เปาลมุตฺโตลฺย นีตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ตต: สรฺเวฺว โลกา: ปศฺจาทฺคามิน: สนฺต เอนํ ทุรีกุรุเตติ วากฺยมฺ อุจฺไจรวทนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","เปาลสฺย ทุรฺคานยนสมเย ส ตไสฺม สหสฺรเสนาปตเย กถิตวานฺ, ภวต: ปุรสฺตาตฺ กถำ กถยิตุํ กิมฺ อนุมนฺยเต? ส ตมปฺฤจฺฉตฺ ตฺวํ กึ ยูนานียำ ภาษำ ชานาสิ? ");
INSERT INTO santha_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","โย มิสรีโย ชน: ปูรฺวฺวํ วิโรธํ กฺฤตฺวา จตฺวาริ สหสฺราณิ ฆาตกานฺ สงฺคิน: กฺฤตฺวา วิปินํ คตวานฺ ตฺวํ กึ เสอว น ภวสิ? ");
INSERT INTO santha_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ตทา เปาโล'กถยตฺ อหํ กิลิกิยาเทศสฺย ตารฺษนครีโย ยิหูทีโย, นาหํ สามานฺยนครีโย มานว:; อเตอว วินเย'หํ ลากานำ สมกฺษํ กถำ กถยิตุํ มามนุชานีษฺวฯ ");
INSERT INTO santha_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","เตนานุชฺญาต: เปาล: โสปาโนปริ ติษฺฐนฺ หเสฺตเนงฺคิตํ กฺฤตวานฺ, ตสฺมาตฺ สรฺเวฺว สุสฺถิรา อภวนฺฯ ตทา เปาล อิพฺรียภาษยา กถยิตุมฺ อารภต, ");
INSERT INTO santha_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","เห ปิตฺฤคณา เห ภฺราตฺฤคณา:, อิทานีํ มม นิเวทเน สมวธตฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ตทา ส อิพฺรียภาษยา กถำ กถยตีติ ศฺรุตฺวา สรฺเวฺว โลกา อตีว นิ:ศพฺทา สนฺโต'ติษฺฐนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ปศฺจาตฺ โส'กถยทฺ อหํ ยิหูทีย อิติ นิศฺจย: กิลิกิยาเทศสฺย ตารฺษนครํ มม ชนฺมภูมิ:,เอตนฺนครียสฺย คมิลีเยลนามฺโน'ธฺยาปกสฺย ศิโษฺย ภูตฺวา ปูรฺวฺวปุรุษาณำ วิธิวฺยวสฺถานุสาเรณ สมฺปูรฺณรูเปณ ศิกฺษิโต'ภวมฺ อิทานีนฺตนา ยูยํ ยาทฺฤศา ภวถ ตาทฺฤโศ'หมปีศฺวรเสวายามฺ อุโทฺยคี ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","มตเมตทฺ ทฺวิษฺฏฺวา ตทฺคฺราหินารีปุรุษานฺ การายำ พทฺธฺวา เตษำ ปฺราณนาศปรฺยฺยนฺตำ วิปกฺษตามฺ อกรวมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","มหายาชก: สภาสท: ปฺราจีนโลกาศฺจ มไมตสฺยา: กถายา: ปฺรมาณํ ทาตุํ ศกฺนุวนฺติ, ยสฺมาตฺ เตษำ สมีปาทฺ ทมฺเมษกนครนิวาสิภฺราตฺฤคณารฺถมฺ อาชฺญาปตฺราณิ คฺฤหีตฺวา เย ตตฺร สฺถิตาสฺตานฺ ทณฺฑยิตุํ ยิรูศาลมมฺ อานยนารฺถํ ทมฺเมษกนครํ คโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","กินฺตุ คจฺฉนฺ ตนฺนครสฺย สมีปํ ปฺราปฺตวานฺ ตทา ทฺวิตียปฺรหรเวลายำ สตฺยามฺ อกสฺมาทฺ คคณานฺนิรฺคตฺย มหตี ทีปฺติ รฺมม จตุรฺทิศิ ปฺรกาศิตวตีฯ ");
INSERT INTO santha_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ตโต มยิ ภูเมาै ปติเต สติ, เห เศาล เห เศาล กุโต มำ ตาฑยสิ? มามฺปฺรติ ภาษิต เอตาทฺฤศ เอโก รโวปิ มยา ศฺรุต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ตทาหํ ปฺรตฺยวทํ, เห ปฺรเภ โก ภวานฺ? ตต: โส'วาทีตฺ ยํ ตฺวํ ตาฑยสิ ส นาสรตีโย ยีศุรหํฯ ");
INSERT INTO santha_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","มม สงฺคิโน โลกาสฺตำ ทีปฺตึ ทฺฤษฺฏฺวา ภิยํ ปฺราปฺตา:, กินฺตุ มามฺปฺรตฺยุทิตํ ตทฺวากฺยํ เตे นาพุธฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ตต: ปรํ ปฺฤษฺฏวานหํ, เห ปฺรโภ มยา กึ กรฺตฺตวฺยํ? ตต: ปฺรภุรกถยตฺ, อุตฺถาย ทมฺเมษกนครํ ยาหิ ตฺวยา ยทฺยตฺ กรฺตฺตวฺยํ นิรูปิตมาเสฺต ตตฺ ตตฺร ตฺวํ ชฺญาปยิษฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","อนนฺตรํ ตสฺยา: ขรตรทีปฺเต: การณาตฺ กิมปิ น ทฺฤษฺฏฺวา สงฺคิคเณน ธฺฤตหสฺต: สนฺ ทมฺเมษกนครํ วฺรชิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ตนฺนครนิวาสินำ สรฺเวฺวษำ ยิหูทียานำ มาโนฺย วฺยวสฺถานุสาเรณ ภกฺตศฺจ หนานียนามา มานว เอโก ");
INSERT INTO santha_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","มม สนฺนิธิมฺ เอตฺย ติษฺฐนฺ อกถยตฺ, เห ภฺราต: เศาล สุทฺฤษฺฏิ รฺภว ตสฺมินฺ ทณฺเฑ'หํ สมฺยกฺ ตํ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ตต: ส มหฺยํ กถิตวานฺ ยถา ตฺวมฺ อีศฺวรสฺยาภิปฺรายํ เวตฺสิ ตสฺย ศุทฺธสตฺตฺวชนสฺย ทรฺศนํ ปฺราปฺย ตสฺย ศฺรีมุขสฺย วากฺยํ ศฺฤโณษิ ตนฺนิมิตฺตมฺ อสฺมากํ ปูรฺวฺวปุรุษาณามฺ อีศฺวรสฺตฺวำ มโนนีตํ กฺฤตวานํฯ ");
INSERT INTO santha_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ยโต ยทฺยทฺ อทฺรากฺษีรเศฺราษีศฺจ สรฺเวฺวษำ มานวานำ สมีเป ตฺวํ เตษำ สากฺษี ภวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","อเตอว กุโต วิลมฺพเส? ปฺรโภ รฺนามฺนา ปฺรารฺถฺย นิชปาปปฺรกฺษาลนารฺถํ มชฺชนาย สมุตฺติษฺฐฯ ");
INSERT INTO santha_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ตต: ปรํ ยิรูศาลมฺนครํ ปฺรตฺยาคตฺย มนฺทิเร'หมฺ เอกทา ปฺรารฺถเย, ตสฺมินฺ สมเย'หมฺ อภิภูต: สนฺ ปฺรภูํ สากฺษาตฺ ปศฺยนฺ, ");
INSERT INTO santha_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ตฺวํ ตฺวรยา ยิรูศาลม: ปฺรติษฺฐสฺว ยโต โลกามยิ ตว สากฺษฺยํ น คฺรหีษฺยนฺติ, มามฺปฺรตฺยุทิตํ ตเสฺยทํ วากฺยมฺ อเศฺราษมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ตโตหํ ปฺรตฺยวาทิษมฺ เห ปฺรโภ ปฺรติภชนภวนํ ตฺวยิ วิศฺวาสิโน โลกานฺ พทฺธฺวา ปฺรหฺฤตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ตถา ตว สากฺษิณ: สฺติผานสฺย รกฺตปาตนสมเย ตสฺย วินาศํ สมฺมนฺย สนฺนิเธา ติษฺฐนฺ หนฺตฺฤโลกานำ วาสำสิ รกฺษิตวานฺ, เอตตฺ เต วิทุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ตต: โส'กถยตฺ ปฺรติษฺฐสฺว ตฺวำ ทูรสฺถภินฺนเทศียานำ สมีปํ เปฺรษยิเษฺยฯ ");
INSERT INTO santha_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ตทา โลกา เอตาวตฺปรฺยฺยนฺตำ ตทียำ กถำ ศฺรุตฺวา โปฺรจฺไจรกถยนฺ, เอนํ ภูมณฺฑลาทฺ ทูรีกุรุต, เอตาทฺฤศชนสฺย ชีวนํ โนจิตมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","อิตฺยุจฺไจ: กถยิตฺวา วสนานิ ปริตฺยชฺย คคณํ ปฺรติ ธูลีรกฺษิปนฺ ");
INSERT INTO santha_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ตต: สหสฺรเสนาปติ: เปาลํ ทุรฺคาภฺยนฺตร เนตุํ สมาทิศตฺฯ เอตสฺย ปฺรติกูลา: สนฺโต โลกา: กินฺนิมิตฺตมฺ เอตาวทุจฺไจ:สฺวรมฺ อกุรฺวฺวนฺ, เอตทฺ เวตฺตุํ ตํ กศยา ปฺรหฺฤตฺย ตสฺย ปรีกฺษำ กรฺตฺตุมาทิศตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ปทาตยศฺจรฺมฺมนิรฺมฺมิตรชฺชุภิสฺตสฺย พนฺธนํ กรฺตฺตุมุทฺยตาสฺตาสฺตทานีํ เปาล: สมฺมุขสฺถิตํ ศตเสนาปติมฺ อุกฺตวานฺ ทณฺฑาชฺญายามฺ อปฺราปฺตายำ กึ โรมิโลกํ ปฺรหรฺตฺตุํ ยุษฺมากมฺ อธิกาโรสฺติ? ");
INSERT INTO santha_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","เอนำ กถำ ศฺรุตฺวา ส สหสฺรเสนาปเต: สนฺนิธึ คตฺวา ตำ วารฺตฺตามวทตฺ ส โรมิโลก เอตสฺมาตฺ สาวธาน: สนฺ กรฺมฺม กุรุฯ ");
INSERT INTO santha_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ตสฺมาตฺ สหสฺรเสนาปติ รฺคตฺวา ตมปฺรากฺษีตฺ ตฺวํ กึ โรมิโลก:? อิติ มำ พฺรูหิฯ โส'กถยตฺ สตฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ตต: สหสฺรเสนาปติ: กถิตวานฺ พหุทฺรวิณํ ทตฺตฺวาหํ ตตฺ เปารสขฺยํ ปฺราปฺตวานฺ; กินฺตุ เปาล: กถิตวานฺ อหํ ชนุนา ตตฺ ปฺราปฺโต'สฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","อิตฺถํ สติ เย ปฺรหาเรณ ตํ ปรีกฺษิตุํ สมุทฺยตา อาสนฺ เต ตสฺย สมีปาตฺ ปฺราติษฺฐนฺต; สหสฺรเสนาปติสฺตํ โรมิโลกํ วิชฺญาย สฺวยํ ยตฺ ตสฺย พนฺธนมฺ อการฺษีตฺ ตตฺการณาทฺ อพิเภตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ยิหูทียโลกา: เปาลํ กุโต'ปวทนฺเต ตสฺย วฺฤตฺตานฺตํ ชฺญาตุํ วาญฺฉนฺ สหสฺรเสนาปติ: ปเร'หนิ เปาลํ พนฺธนาตฺ โมจยิตฺวา ปฺรธานยาชกานฺ มหาสภายา: สรฺวฺวโลกาศฺจ สมุปสฺถาตุมฺ อาทิศฺย เตษำ สนฺนิเธา เปาลมฺ อวโรหฺย สฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","สภาสโทฺลกานฺ ปฺรติ เปาโล'นนฺยทฺฤษฺฏฺยา ปศฺยนฺ อกถยตฺ, เห ภฺราตฺฤคณา อทฺย ยาวตฺ สรเลน สรฺวฺวานฺต:กรเณเนศฺวรสฺย สากฺษาทฺ อาจรามิฯ ");
INSERT INTO santha_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","อเนน หนานียนามา มหายาชกสฺตํ กโปเล จเปเฏนาหนฺตุํ สมีปสฺถโลกานฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ตทา เปาลสฺตมวทตฺ, เห พหิษฺปริษฺกฺฤต, อีศฺวรสฺตฺวำ ปฺรหรฺตฺตุมฺ อุทฺยโตสฺติ, ยโต วฺยวสฺถานุสาเรณ วิจารยิตุมฺ อุปวิศฺย วฺยวสฺถำ ลงฺฆิตฺวา มำ ปฺรหรฺตฺตุมฺ อาชฺญาปยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ตโต นิกฏสฺถา โลกา อกถยนฺ, ตฺวํ กิมฺ อีศฺวรสฺย มหายาชกํ นินฺทสิ? ");
INSERT INTO santha_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ตต: เปาล: ปฺรติภาษิตวานฺ เห ภฺราตฺฤคณ มหายาชก เอษ อิติ น พุทฺธํ มยา ตทนฺยจฺจ สฺวโลกานามฺ อธิปตึ ปฺรติ ทุรฺวฺวากฺยํ มา กถย, เอตาทฺฤศี ลิปิรสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","อนนฺตรํ เปาลเสฺตษามฺ อรฺทฺธํ สิทูกิโลกา อรฺทฺธํ ผิรูศิโลกา อิติ ทฺฤษฺฏฺวา โปฺรจฺไจ: สภาสฺถโลกานฺ อวทตฺ เห ภฺราตฺฤคณ อหํ ผิรูศิมตาวลมฺพี ผิรูศิน: สตฺนานศฺจ, มฺฤตโลกานามฺ อุตฺถาเน ปฺรตฺยาศากรณาทฺ อหมปวาทิโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","อิติ กถายำ กถิตายำ ผิรูศิสิทูกิโน: ปรสฺปรํ ภินฺนวากฺยตฺวาตฺ สภายา มเธฺย เทฺวา สํเฆา ชาเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ยต: สิทูกิโลกา อุตฺถานํ สฺวรฺคียทูตา อาตฺมานศฺจ สรฺเวฺวษามฺ เอเตษำ กมปิ น มนฺยนฺเต, กินฺตุ ผิรูศิน: สรฺวฺวมฺ องฺคีกุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ตต: ปรสฺปรมฺ อติศยโกลาหเล สมุปสฺถิเต ผิรูศินำ ปกฺษียา: สภาสฺถา อธฺยาปกา: ปฺรติปกฺษา อุตฺติษฺฐนฺโต 'กถยนฺ, เอตสฺย มานวสฺย กมปิ โทษํ น ปศฺยาม:; ยทิ กศฺจิทฺ อาตฺมา วา กศฺจิทฺ ทูต เอนํ ปฺรตฺยาทิศตฺ ตรฺหิ วยมฺ อีศฺวรสฺย ปฺราติกูเลฺยน น โยตฺสฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ตสฺมาทฺ อตีว ภินฺนวากฺยเตฺว สติ เต เปาลํ ขณฺฑํ ขณฺฑํ กริษฺยนฺตีตฺยาศงฺกยา สหสฺรเสนาปติ: เสนาคณํ ตตฺสฺถานํ ยาตุํ สภาโต พลาตฺ เปาลํ ธฺฤตฺวา ทุรฺคํ เนตญฺจาชฺญาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ราโตฺร ปฺรภุสฺตสฺย สมีเป ติษฺฐนฺ กถิตวานฺ เห เปาล นิรฺภโย ภว ยถา ยิรูศาลมฺนคเร มยิ สากฺษฺยํ ทตฺตวานฺ ตถา โรมานคเรปิ ตฺวยา ทาตวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ทิเน สมุปสฺถิเต สติ กิยนฺโต ยิหูทียโลกา เอกมนฺตฺรณา: สนฺต: เปาลํ น หตฺวา โภชนปาเน กริษฺยาม อิติ ศปเถน สฺวานฺ อพธฺนนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","จตฺวารึศชฺชเนโภฺย'ธิกา โลกา อิติ ปณมฺ อกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","เต มหายาชกานำ ปฺราจีนโลกานาญฺจ สมีปํ คตฺวา กถยนฺ, วยํ เปาลํ น หตฺวา กิมปิ น โภกฺษฺยามเห ทฺฤเฒนาเนน ศปเถน พทฺธฺวา อภวามฯ ");
INSERT INTO santha_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","อเตอว สามฺปฺรตํ สภาสโทฺลไก: สห วยํ ตสฺมินฺ กญฺจิทฺ วิเศษวิจารํ กริษฺยามสฺตทรฺถํ ภวานฺ โศฺว 'สฺมากํ สมีปํ ตมฺ อานยตฺวิติ สหสฺรเสนาปตเย นิเวทนํ กุรุต เตน ยุษฺมากํ สมีปํ อุปสฺถิเต: ปูรฺวฺวํ วยํ ตํ หนฺตุ สชฺชิษฺยามฯ ");
INSERT INTO santha_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ตทา เปาลสฺย ภาคิเนยเสฺตษามิติ มนฺตฺรณำ วิชฺญาย ทุรฺคํ คตฺวา ตำ วารฺตฺตำ เปาลมฺ อุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ตสฺมาตฺ เปาล เอกํ ศตเสนาปติมฺ อาหูย วากฺยมิทมฺ ภาษิตวานฺ สหสฺรเสนาปเต: สมีเป'สฺย ยุวมนุษฺยสฺย กิญฺจินฺนิเวทนมฺ อาเสฺต, ตสฺมาตฺ ตตฺสวิธมฺ เอนํ นยฯ ");
INSERT INTO santha_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ตต: ส ตมาทาย สหสฺรเสนาปเต: สมีปมฺ อุปสฺถาย กถิตวานฺ, ภวต: สมีเป'สฺย กิมปิ นิเวทนมาเสฺต ตสฺมาตฺ พนฺทิ: เปาโล มามาหูย ภวต: สมีปมฺ เอนมฺ อาเนตุํ ปฺรารฺถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ตทา สหสฺรเสนาปติสฺตสฺย หสฺตํ ธฺฤตฺวา นิรฺชนสฺถานํ นีตฺวา ปฺฤษฺฐวานฺ ตว กึ นิเวทนํ? ตตฺ กถยฯ ");
INSERT INTO santha_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ตต: โสกถยตฺ, ยิหูทียลากา: เปาเล กมปิ วิเศษวิจารํ ฉลํ กฺฤตฺวา ตํ สภำ เนตุํ ภวต: สมีเป นิเวทยิตุํ อมนฺตฺรยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","กินฺตุ มวตา ตนฺน สฺวีกรฺตฺตวฺยํ ยตเสฺตษำ มเธฺยวรฺตฺตินศฺจตฺวารึศชฺชเนโภฺย 'ธิกโลกา เอกมนฺตฺรณา ภูตฺวา เปาลํ น หตฺวา โภชนํ ปานญฺจ น กริษฺยาม อิติ ศปเถน พทฺธา: สนฺโต ฆาตกา อิว สชฺชิตา อิทานีํ เกวลํ ภวโต 'นุมติมฺ อเปกฺษนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ยามิมำ กถำ ตฺวํ นิเวทิตวานฺ ตำ กไสฺมจิทปิ มา กถเยตฺยุกฺตฺวา สหสฺรเสนาปติสฺตํ ยุวานํ วิสฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","อนนฺตรํ สหสฺรเสนาปติ รฺเทฺวา ศตเสนาปตี อาหูเยทมฺ อาทิศตฺ, ยุวำ ราเตฺรา ปฺรหไรกาวศิษฺฏายำ สตฺยำ ไกสริยานครํ ยาตุํ ปทาติไสนฺยานำ เทฺว ศเต โฆฏกาโรหิไสนฺยานำ สปฺตตึ ศกฺติธาริไสนฺยานำ เทฺว ศเต จ ชนานฺ สชฺชิตานฺ กุรุตํฯ ");
INSERT INTO santha_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","เปาลมฺ อาโรหยิตุํ ผีลิกฺษาธิปเต: สมีปํ นิรฺวฺวิฆฺนํ เนตุญฺจ วาหนานิ สมุปสฺถาปยตํฯ ");
INSERT INTO santha_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","อปรํ ส ปตฺรํ ลิขิตฺวา ทตฺตวานฺ ตลฺลิขิตเมตตฺ, ");
INSERT INTO santha_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","มหามหิมศฺรียุกฺตผีลิกฺษาธิปตเย เกฺลาทิยลุษิยสฺย นมสฺการ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ยิหูทียโลกา: ปูรฺวฺวมฺ เอนํ มานวํ ธฺฤตฺวา สฺวหไสฺต รฺหนฺตุมฺ อุทฺยตา เอตสฺมินฺนนฺตเร สไสโนฺยหํ ตโตฺรปสฺถาย เอษ ชโน โรมีย อิติ วิชฺญาย ตํ รกฺษิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","กินฺนิมิตฺตํ เต ตมปวทนฺเต ตชฺชฺญาตุํ เตษา สภำ ตมานายิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ตตเสฺตษำ วฺยวสฺถายา วิรุทฺธยา กยาจน กถยา โส'ปวาทิโต'ภวตฺ, กินฺตุ ส ศฺฤงฺขลพนฺธนาโรฺห วา ปฺราณนาศาโรฺห ภวตีทฺฤศ: โกปฺยปราโธ มยาสฺย น ทฺฤษฺฏ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ตถาปิ มนุษฺยสฺยาสฺย วธารฺถํ ยิหูทียา ฆาตกาอิว สชฺชิตา เอตำ วารฺตฺตำ ศฺรุตฺวา ตตฺกฺษณาตฺ ตว สมีปเมนํ เปฺรษิตวานฺ อสฺยาปวาทกำศฺจ ตว สมีปํ คตฺวาปวทิตุมฺ อาชฺญาปยมฺฯ ภวต: กุศลํ ภูยาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ไสนฺยคณ อาชฺญานุสาเรณ เปาลํ คฺฤหีตฺวา ตสฺยำ รชนฺยามฺ อานฺติปาตฺรินครมฺ อานยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ปเร'หนิ เตน สห ยาตุํ โฆฏการูฒไสนฺยคณํ สฺถาปยิตฺวา ปราวฺฤตฺย ทุรฺคํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ตต: ปเร โฆฏกาโรหิไสนฺยคณ: ไกสริยานครมฺ อุปสฺถาย ตตฺปตฺรมฺ อธิปเต: กเร สมรฺปฺย ตสฺย สมีเป เปาลมฺ อุปสฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ตทาธิปติสฺตตฺปตฺรํ ปฐิตฺวา ปฺฤษฺฐวานฺ เอษ กิมฺปฺรเทศีโย ชน:? ส กิลิกิยาปฺรเทศีย เอโก ชน อิติ ชฺญาตฺวา กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ตวาปวาทกคณ อาคเต ตว กถำ โศฺรษฺยามิฯ เหโรทฺราชคฺฤเห ตํ สฺถาปยิตุมฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ปญฺจโภฺย ทิเนภฺย: ปรํ หนานียนามา มหายาชโก'ธิปเต: สมกฺษํ เปาลสฺย ปฺราติกูเลฺยน นิเวทยิตุํ ตรฺตุลฺลนามานํ กญฺจน วกฺตารํ ปฺราจีนชนำศฺจ สงฺคิน: กฺฤตฺวา ไกสริยานครมฺ อาคจฺฉตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ตต: เปาเล สมานีเต สติ ตรฺตุลฺลสฺตสฺยาปวาทกถำ กถยิตุมฺ อารภต เห มหามหิมผีลิกฺษ ภวโต วยมฺ อตินิรฺวฺวิฆฺนํ กาลํ ยาปยาโม ภวต: ปริณามทรฺศิตยา เอตทฺเทศียานำ พหูนิ มงฺคลานิ ฆฏิตานิ, ");
INSERT INTO santha_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","อิติ เหโต รฺวยมติกฺฤตชฺญา: สนฺต: สรฺวฺวตฺร สรฺวฺวทา ภวโต คุณานฺ คายม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","กินฺตุ พหุภิ: กถาภิ รฺภวนฺตํ เยน น วิรญฺชยามิ ตสฺมาทฺ วินเย ภวานฺ พนุกมฺปฺย มทลฺปกถำ ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","เอษ มหามารีสฺวรูโป นาสรตียมตคฺราหิสํฆาตสฺย มุโขฺย ภูตฺวา สรฺวฺวเทเศษุ สรฺเวฺวษำ ยิหูทียานำ ราชโทฺรหาจรณปฺรวฺฤตฺตึ ชนยตีตฺยสฺมาภิ รฺนิศฺจิตํฯ ");
INSERT INTO santha_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ส มนฺทิรมปิ อศุจิ กรฺตฺตุํ เจษฺฏิตวานฺ; อิติ การณาทฺ วยมฺ เอนํ ธฺฤตฺวา สฺววฺยวสฺถานุสาเรณ วิจารยิตุํ ปฺราวรฺตฺตามหิ; ");
INSERT INTO santha_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","กินฺตุ ลุษิย: สหสฺรเสนาปติราคตฺย พลาทฺ อสฺมากํ กเรภฺย เอนํ คฺฤหีตฺวา ");
INSERT INTO santha_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","เอตสฺยาปวาทกานฺ ภวต: สมีปมฺ อาคนฺตุมฺ อาชฺญาปยตฺฯ วยํ ยสฺมินฺ ตมปวาทาโม ภวตา ปทปวาทกถายำ วิจาริตายำ สตฺยำ สรฺวฺวํ วฺฤตฺตานฺตํ เวทิตุํ ศกฺษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ตโต ยิหูทียา อปิ สฺวีกฺฤตฺย กถิตวนฺต เอษา กถา ปฺรมาณมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","อธิปเตา กถำ กถยิตุํ เปาลํ ปฺรตีงฺคิตํ กฺฤตวติ ส กถิตวานฺ ภวานฺ พหูนฺ วตฺสรานฺ ยาวทฺ เอตทฺเทศสฺย ศาสนํ กโรตีติ วิชฺญาย ปฺรตฺยุตฺตรํ ทาตุมฺ อกฺโษโภ'ภวมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","อทฺย เกวลํ ทฺวาทศ ทินานิ ยาตานิ, อหมฺ อาราธนำ กรฺตฺตุํ ยิรูศาลมนครํ คตวานฺ เอษา กถา ภวตา ชฺญาตุํ ศกฺยเต; ");
INSERT INTO santha_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","กินฺตฺวิเภ มำ มเธฺยมนฺทิรํ เกนาปิ สห วิตณฺฑำ กุรฺวฺวนฺตํ กุตฺราปิ ภชนภวเน นคเร วา โลกานฺ กุปฺรวฺฤตฺตึ ชนยนฺตุํ น ทฺฤษฺฏวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","อิทานีํ ยสฺมินฺ ยสฺมินฺ มามฺ อปวทนฺเต ตสฺย กิมปิ ปฺรมาณํ ทาตุํ น ศกฺนุวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","กินฺตุ ภวิษฺยทฺวากฺยคฺรนฺเถ วฺยวสฺถาคฺรนฺเถ จ ยา ยา กถา ลิขิตาเสฺต ตาสุ สรฺวฺวาสุ วิศฺวสฺย ยนฺมตมฺ อิเม วิธรฺมฺมํ ชานนฺติ ตนฺมตานุสาเรณาหํ นิชปิตฺฤปุรุษาณามฺ อีศฺวรมฺ อาราธยามีตฺยหํ ภวต: สมกฺษมฺ องฺคีกโรมิฯ ");
INSERT INTO santha_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ธารฺมฺมิกาณามฺ อธารฺมฺมิกาณาญฺจ ปฺรมีตโลกานาเมโวตฺถานํ ภวิษฺยตีติ กถามิเม สฺวีกุรฺวฺวนฺติ ตถาหมปิ ตสฺมินฺ อีศฺวเร ปฺรตฺยาศำ กโรมิ; ");
INSERT INTO santha_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","อีศฺวรสฺย มานวานาญฺจ สมีเป ยถา นิรฺโทโษ ภวามิ ตทรฺถํ สตตํ ยตฺนวานฺ อสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","พหุษุ วตฺสเรษุ คเตษุ สฺวเทศียโลกานำ นิมิตฺตํ ทานียทฺรวฺยาณิ ไนเวทฺยานิ จ สมาทาย ปุนราคมนํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ตโตหํ ศุจิ รฺภูตฺวา โลกานำ สมาคมํ กลหํ วา น การิตวานฺ ตถาปฺยาศิยาเทศียา: กิยนฺโต ยิหุทียโลกา มเธฺยมนฺทิรํ มำ ธฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","มโมปริ ยทิ กาจิทปวาทกถาสฺติ ตรฺหิ ภวต: สมีปมฺ อุปสฺถาย เตษาเมว สากฺษฺยทานมฺ อุจิตมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","โนเจตฺ ปูรฺเวฺว มหาสภาสฺถานำ โลกานำ สนฺนิเธา มม ทณฺฑายมานตฺวสมเย, อหมทฺย มฺฤตานามุตฺถาเน ยุษฺมาภิ รฺวิจาริโตสฺมิ, ");
INSERT INTO santha_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","เตษำ มเธฺย ติษฺฐนฺนหํ ยามิมำ กถามุจฺไจ: สฺวเรณ กถิตวานฺ ตทโนฺย มม โกปิ โทโษ'ลภฺยต น เวติ วรมฺ เอเต สมุปสฺถิตโลกา วทนฺตุฯ ");
INSERT INTO santha_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ตทา ผีลิกฺษ เอตำ กถำ ศฺรุตฺวา ตนฺมตสฺย วิเศษวฺฤตฺตานฺตํ วิชฺญาตุํ วิจารํ สฺถคิตํ กฺฤตฺวา กถิตวานฺ ลุษิเย สหสฺรเสนาปเตา สมายาเต สติ ยุษฺมากํ วิจารมฺ อหํ นิษฺปาทยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","อนนฺตรํ พนฺธนํ วินา เปาลํ รกฺษิตุํ ตสฺย เสวนาย สากฺษาตฺกรณาย วา ตทียาตฺมียพนฺธุชนานฺ น วารยิตุญฺจ ศมเสนาปติมฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","อลฺปทินาตฺ ปรํ ผีลิกฺโษ'ธิปติ รฺทฺรุษิลฺลานามฺนา ยิหูทียยา สฺวภารฺยฺยยา สหาคตฺย เปาลมาหูย ตสฺย มุขาตฺ ขฺรีษฺฏธรฺมฺมสฺย วฺฤตฺตานฺตมฺ อเศฺราษีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","เปาเลน นฺยายสฺย ปริมิตโภคสฺย จรมวิจารสฺย จ กถายำ กถิตายำ สตฺยำ ผีลิกฺษ: กมฺปมาน: สนฺ วฺยาหรทฺ อิทานีํ ยาหิ, อหมฺ อวกาศํ ปฺราปฺย ตฺวามฺ อาหูสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","มุกฺติปฺรปฺตฺยรฺถํ เปาเลน มหฺยํ มุทฺราทาสฺยนฺเต อิติ ปตฺยาศำ กฺฤตฺวา ส ปุน: ปุนสฺตมาหูย เตน สากํ กโถปกถนํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","กินฺตุ วตฺสรทฺวยาตฺ ปรํ ปรฺกิยผีษฺฏ ผาลิกฺษสฺย ปทํ ปฺราปฺเต สติ ผีลิกฺโษ ยิหูทียานฺ สนฺตุษฺฏานฺ จิกีรฺษนฺ เปาลํ พทฺธํ สํสฺถาปฺย คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","อนนฺตรํ ผีษฺโฏ นิชราชฺยมฺ อาคตฺย ทินตฺรยาตฺ ปรํ ไกสริยาโต ยิรูศาลมฺนครมฺ อาคมตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ตทา มหายาชโก ยิหูทียานำ ปฺรธานโลกาศฺจ ตสฺย สมกฺษํ เปาลมฺ อปาวทนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ภวานฺ ตํ ยิรูศาลมมฺ อาเนตุมฺ อาชฺญาปยตฺวิติ วินีย เต ตสฺมาทฺ อนุคฺรหํ วาญฺฉิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ยต: ปถิมเธฺย โคปเนน เปาลํ หนฺตุํ ไต รฺฆาตกา นิยุกฺตา:ฯ ผีษฺฏ อุตฺตรํ ทตฺตวานฺ เปาล: ไกสริยายำ สฺถาสฺยติ ปุนรลฺปทินาตฺ ปรมฺ อหํ ตตฺร ยาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ตตสฺตสฺย มานุษสฺย ยทิ กศฺจิทฺ อปราธสฺติษฺฐติ ตรฺหิ ยุษฺมากํ เย ศกฺนุวนฺติ เต มยา สห ตตฺร คตฺวา ตมปวทนฺตุ ส เอตำ กถำ กถิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ทศทิวเสโภฺย'ธิกํ วิลมฺพฺย ผีษฺฏสฺตสฺมาตฺ ไกสริยานครํ คตฺวา ปรสฺมินฺ ทิวเส วิจาราสน อุปทิศฺย เปาลมฺ อาเนตุมฺ อาชฺญาปยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","เปาเล สมุปสฺถิเต สติ ยิรูศาลมฺนคราทฺ อาคตา ยิหูทียโลกาสฺตํ จตุรฺทิศิ สํเวษฺฏฺย ตสฺย วิรุทฺธํ พหูนฺ มหาโทษานฺ อุตฺถาปิตวนฺต: กินฺตุ เตษำ กิมปิ ปฺรมาณํ ทาตุํ น ศกฺนุวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ตต: เปาล: สฺวสฺมินฺ อุตฺตรมิทมฺ อุทิตวานฺ, ยิหูทียานำ วฺยวสฺถายา มนฺทิรสฺย ไกสรสฺย วา ปฺรติกูลํ กิมปิ กรฺมฺม นาหํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","กินฺตุ ผีษฺโฏ ยิหูทียานฺ สนฺตุษฺฏานฺ กรฺตฺตุมฺ อภิลษนฺ เปาลมฺ อภาษต ตฺวํ กึ ยิรูศาลมํ คตฺวาสฺมินฺ อภิโยเค มม สากฺษาทฺ วิจาริโต ภวิษฺยสิ? ");
INSERT INTO santha_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ตต: เปาล อุตฺตรํ โปฺรกฺตวานฺ, ยตฺร มม วิจาโร ภวิตุํ โยคฺย: ไกสรสฺย ตตฺร วิจาราสน เอว สมุปสฺถิโตสฺมิ; อหํ ยิหูทียานำ กามปิ หานึ นาการฺษมฺ อิติ ภวานฺ ยถารฺถโต วิชานาติฯ ");
INSERT INTO santha_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","กญฺจิทปราธํ กิญฺจน วธารฺหํ กรฺมฺม วา ยทฺยหมฺ อกริษฺยํ ตรฺหิ ปฺราณหนนทณฺฑมปิ โภกฺตุมฺ อุทฺยโต'ภวิษฺยํ, กินฺตุ เต มม สมปวาทํ กุรฺวฺวนฺติ ส ยทิ กลฺปิตมาโตฺร ภวติ ตรฺหิ เตษำ กเรษุ มำ สมรฺปยิตุํ กสฺยาปฺยธิกาโร นาสฺติ, ไกสรสฺย นิกเฏ มม วิจาโร ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ตทา ผีษฺโฏ มนฺตฺริภิ: สารฺทฺธํ สํมนฺตฺรฺย เปาลาย กถิตวานฺ, ไกสรสฺย นิกเฏ กึ ตว วิจาโร ภวิษฺยติ? ไกสรสฺย สมีปํ คมิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","กิยทฺทิเนภฺย: ปรมฺ อาคฺริปฺปราชา พรฺณีกี จ ผีษฺฏํ สากฺษาตฺ กรฺตฺตุํ ไกสริยานครมฺ อาคตวนฺเตาฯ ");
INSERT INTO santha_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ตทา เตา พหุทินานิ ตตฺร สฺถิเตา ตต: ผีษฺฏสฺตํ ราชานํ เปาลสฺย กถำ วิชฺญาปฺย กถยิตุมฺ อารภต เปาลนามานมฺ เอกํ พนฺทิ ผีลิกฺโษ พทฺธํ สํสฺถาปฺย คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ยิรูศาลมิ มม สฺถิติกาเล มหายาชโก ยิหูทียานำ ปฺราจีนโลกาศฺจ ตมฺ อโปทฺย ตมฺปฺรติ ทณฺฑาชฺญำ ปฺรารฺถยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ตโตหมฺ อิตฺยุตฺตรมฺ อวทํ ยาวทฺ อโปทิโต ชน: สฺวาปวาทกานฺ สากฺษาตฺ กฺฤตฺวา สฺวสฺมินฺ โย'ปราธ อาโรปิตสฺตสฺย ปฺรตฺยุตฺตรํ ทาตุํ สุโยคํ น ปฺราปฺโนติ, ตาวตฺกาลํ กสฺยาปิ มานุษสฺย ปฺราณนาศาชฺญาปนํ โรมิโลกานำ รีติ รฺนหิฯ ");
INSERT INTO santha_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ตตเสฺตษฺวตฺราคเตษุ ปรสฺมินฺ ทิวเส'หมฺ อวิลมฺพํ วิจาราสน อุปวิศฺย ตํ มานุษมฺ อาเนตุมฺ อาชฺญาปยมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ตทนนฺตรํ ตสฺยาปวาทกา อุปสฺถาย ยาทฺฤศมฺ อหํ จินฺติตวานฺ ตาทฺฤศํ กญฺจน มหาปวาทํ โนตฺถาปฺย ");
INSERT INTO santha_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","เสฺวษำ มเต ตถา เปาโล ยํ สชีวํ วทติ ตสฺมินฺ ยีศุนามนิ มฺฤตชเน จ ตสฺย วิรุทฺธํ กถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ตโตหํ ตาทฺฤคฺวิจาเร สํศยาน: สนฺ กถิตวานฺ ตฺวํ ยิรูศาลมํ คตฺวา กึ ตตฺร วิจาริโต ภวิตุมฺ อิจฺฉสิ? ");
INSERT INTO santha_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ตทา เปาโล มหาราชสฺย นิกเฏ วิจาริโต ภวิตุํ ปฺรารฺถยต, ตสฺมาทฺ ยาวตฺกาลํ ตํ ไกสรสฺย สมีปํ เปฺรษยิตุํ น ศกฺโนมิ ตาวตฺกาลํ ตมตฺร สฺถาปยิตุมฺ อาทิษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ตต อาคฺริปฺป: ผีษฺฏมฺ อุกฺตวานฺ, อหมปิ ตสฺย มานุษสฺย กถำ โศฺรตุมฺ อภิลษามิฯ ตทา ผีษฺโฏ วฺยาหรตฺ ศฺวสฺตทียำ กถำ ตฺวํ โศฺรษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ปรสฺมินฺ ทิวเส อาคฺริปฺโป พรฺณีกี จ มหาสมาคมํ กฺฤตฺวา ปฺรธานวาหินีปติภิ รฺนครสฺถปฺรธานโลไกศฺจ สห มิลิตฺวา ราชคฺฤหมาคตฺย สมุปสฺถิเตา ตทา ผีษฺฏสฺยาชฺญยา เปาล อานีโต'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ตทา ผีษฺฏ: กถิตวานฺ เห ราชนฺ อาคฺริปฺป เห อุปสฺถิตา: สรฺเวฺว โลกา ยิรูศาลมฺนคเร ยิหูทียโลกสมูโห ยสฺมินฺ มานุเษ มม สมีเป นิเวทนํ กฺฤตฺวา โปฺรจฺไจ: กถามิมำ กถิตวานฺ ปุนรลฺปกาลมปิ ตสฺย ชีวนํ โนจิตํ ตเมตํ มานุษํ ปศฺยตฯ ");
INSERT INTO santha_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","กินฺเตฺวษ ชน: ปฺราณนาศรฺหํ กิมปิ กรฺมฺม น กฺฤตวานฺ อิตฺยชานำ ตถาปิ ส มหาราชสฺย สนฺนิเธา วิจาริโต ภวิตุํ ปฺรารฺถยต ตสฺมาตฺ ตสฺย สมีปํ ตํ เปฺรษยิตุํ มติมกรวมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","กินฺตุ ศฺรียุกฺตสฺย สมีปมฺ เอตสฺมินฺ กึ เลขนียมฺ อิตฺยสฺย กสฺยจินฺ นิรฺณยสฺย น ชาตตฺวาทฺ เอตสฺย วิจาเร สติ ยถาหํ เลขิตุํ กิญฺจน นิศฺจิตํ ปฺราปฺโนมิ ตทรฺถํ ยุษฺมากํ สมกฺษํ วิเศษโต เห อาคฺริปฺปราช ภวต: สมกฺษมฺ เอตมฺ อานเยฯ ");
INSERT INTO santha_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ยโต พนฺทิเปฺรษณสมเย ตสฺยาภิโยคสฺย กิญฺจิทเลขนมฺ อหมฺ อยุกฺตํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ตต อาคฺริปฺป: เปาลมฺ อวาทีตฺ, นิชำ กถำ กถยิตุํ ตุภฺยมฺ อนุมติ รฺทียเตฯ ตสฺมาตฺ เปาล: กรํ ปฺรสารฺยฺย สฺวสฺมินฺ อุตฺตรมฺ อวาทีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","เห อาคฺริปฺปราช ยตฺการณาทหํ ยิหูทีไยรปวาทิโต 'ภวํ ตสฺย วฺฤตฺตานฺตมฺ อทฺย ภวต: สากฺษานฺ นิเวทยิตุมนุมโตหมฺ อิทํ สฺวียํ ปรมํ ภาคฺยํ มเนฺย; ");
INSERT INTO santha_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ยโต ยิหูทียโลกานำ มเธฺย ยา ยา รีติ: สูกฺษฺมวิจาราศฺจ สนฺติ เตษุ ภวานฺ วิชฺญตม:; อเตอว ปฺรารฺถเย ไธรฺยฺยมวลมฺพฺย มม นิเวทนํ ศฺฤโณตุฯ ");
INSERT INTO santha_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","อหํ ยิรูศาลมฺนคเร สฺวเทศียโลกานำ มเธฺย ติษฺฐนฺ อา เยาวนกาลาทฺ ยทฺรูปมฺ อาจริตวานฺ ตทฺ ยิหูทียโลกา: สรฺเวฺว วิทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","อสฺมากํ สรฺเวฺวภฺย: ศุทฺธตมํ ยตฺ ผิรูศียมตํ ตทวลมฺพี ภูตฺวาหํ กาลํ ยาปิตวานฺ เย ชนา อา พาลฺยกาลานฺ มำ ชานานฺติ เต เอตาทฺฤศํ สากฺษฺยํ ยทิ ททาติ ตรฺหิ ทาตุํ ศกฺนุวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","กินฺตุ เห อาคฺริปฺปราช อีศฺวโร'สฺมากํ ปูรฺวฺวปุรุษาณำ นิกเฏ ยทฺ องฺคีกฺฤตวานฺ ตสฺย ปฺรตฺยาศาเหโตรหมฺ อิทานีํ วิจารสฺถาเน ทณฺฑายมาโนสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ตสฺยางฺคีการสฺย ผลํ ปฺราปฺตุมฺ อสฺมากํ ทฺวาทศวํศา ทิวานิศํ มหายตฺนาทฺ อีศฺวรเสวนํ กฺฤตฺวา ยำ ปฺรตฺยาศำ กุรฺวฺวนฺติ ตสฺยา: ปฺรตฺยาศายา เหโตรหํ ยิหูทีไยรปวาทิโต'ภวมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","อีศฺวโร มฺฤตานฺ อุตฺถาปยิษฺยตีติ วากฺยํ ยุษฺมากํ นิกเฏ'สมฺภวํ กุโต ภเวตฺ? ");
INSERT INTO santha_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","นาสรตียยีโศ รฺนามฺโน วิรุทฺธํ นานาปฺรการปฺรติกูลาจรณมฺ อุจิตมฺ อิตฺยหํ มนสิ ยถารฺถํ วิชฺญาย ");
INSERT INTO santha_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ยิรูศาลมนคเร ตทกรวํ ผลต: ปฺรธานยาชกสฺย นิกฏาตฺ กฺษมตำ ปฺราปฺย พหูนฺ ปวิตฺรโลกานฺ การายำ พทฺธวานฺ วิเศษตเสฺตษำ หนนสมเย เตษำ วิรุทฺธำ นิชำ สมฺมตึ ปฺรกาศิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","วารํ วารํ ภชนภวเนษุ เตโภฺย ทณฺฑํ ปฺรทตฺตวานฺ พลาตฺ ตํ ธรฺมฺมํ นินฺทยิตวำศฺจ ปุนศฺจ ตานฺ ปฺรติ มหาโกฺรธาทฺ อุนฺมตฺต: สนฺ วิเทศียนคราณิ ยาวตฺ ตานฺ ตาฑิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","อิตฺถํ ปฺรธานยาชกสฺย สมีปาตฺ ศกฺติมฺ อาชฺญาปตฺรญฺจ ลพฺธฺวา ทมฺเมษกฺนครํ คตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ตทาหํ เห ราชนฺ มารฺคมเธฺย มธฺยาหฺนกาเล มม มทียสงฺคินำ โลกานาญฺจ จตสฺฤษุ ทิกฺษุ คคณาตฺ ปฺรกาศมานำ ภาสฺกรโตปิ เตชสฺวตีํ ทีปฺตึ ทฺฤษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ตสฺมาทฺ อสฺมาสุ สรฺเวฺวษุ ภูเมา ปติเตษุ สตฺสุ เห เศาล ไห เศาล กุโต มำ ตาฑยสิ? กณฺฏกานำ มุเข ปาทาหนนํ ตว ทุ:สาธฺยมฺ อิพฺรียภาษยา คทิต เอตาทฺฤศ เอก: ศพฺโท มยา ศฺรุต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ตทาหํ ปฺฤษฺฏวานฺ เห ปฺรโภ โก ภวานฺ? ตต: ส กถิตวานฺ ยํ ยีศุํ ตฺวํ ตาฑยสิ โสหํ, ");
INSERT INTO santha_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","กินฺตุ สมุตฺติษฺฐ ตฺวํ ยทฺ ทฺฤษฺฏวานฺ อิต: ปุนญฺจ ยทฺยตฺ ตฺวำ ทรฺศยิษฺยามิ เตษำ สรฺเวฺวษำ การฺยฺยาณำ ตฺวำ สากฺษิณํ มม เสวกญฺจ กรฺตฺตุมฺ ทรฺศนมฺ อทามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","วิเศษโต ยิหูทียโลเกโภฺย ภินฺนชาตีเยภฺยศฺจ ตฺวำ มโนนีตํ กฺฤตฺวา เตษำ ยถา ปาปโมจนํ ภวติ ");
INSERT INTO santha_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ยถา เต มยิ วิศฺวสฺย ปวิตฺรีกฺฤตานำ มเธฺย ภาคํ ปฺราปฺนุวนฺติ ตทภิปฺราเยณ เตษำ ชฺญานจกฺษูํษิ ปฺรสนฺนานิ กรฺตฺตุํ ตถานฺธการาทฺ ทีปฺตึ ปฺรติ ไศตานาธิการาจฺจ อีศฺวรํ ปฺรติ มตี: ปราวรฺตฺตยิตุํ เตษำ สมีปํ ตฺวำ เปฺรษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","เห อาคฺริปฺปราช เอตาทฺฤศํ สฺวรฺคียปฺรตฺยาเทศํ อคฺราหฺยมฺ อกฺฤตฺวาหํ ");
INSERT INTO santha_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ปฺรถมโต ทมฺเมษกฺนคเร ตโต ยิรูศาลมิ สรฺวฺวสฺมินฺ ยิหูทียเทเศ อเนฺยษุ เทเศษุ จ เยेน โลกา มตึ ปราวรฺตฺตฺย อีศฺวรํ ปฺรติ ปราวรฺตฺตยนฺเต, มน:ปราวรฺตฺตนโยคฺยานิ กรฺมฺมาณิ จ กุรฺวฺวนฺติ ตาทฺฤศมฺ อุปเทศํ ปฺรจาริตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","เอตตฺการณาทฺ ยิหูทียา มเธฺยมนฺทิรํ มำ ธฺฤตฺวา หนฺตุมฺ อุทฺยตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ตถาปิ ขฺรีษฺโฏ ทุ:ขํ ภุกฺตฺวา สรฺเวฺวษำ ปูรฺวฺวํ ศฺมศานาทฺ อุตฺถาย นิชเทศียานำ ภินฺนเทศียานาญฺจ สมีเป ทีปฺตึ ปฺรกาศยิษฺยติ ");
INSERT INTO santha_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ภวิษฺยทฺวาทิคโณ มูสาศฺจ ภาวิการฺยฺยสฺย ยทิทํ ปฺรมาณมฺ อททุเรตทฺ วินานฺยำ กถำ น กถยิตฺวา อีศฺวราทฺ อนุคฺรหํ ลพฺธฺวา มหตำ กฺษุทฺราณาญฺจ สรฺเวฺวษำ สมีเป ปฺรมาณํ ทตฺตฺวาทฺย ยาวตฺ ติษฺฐามิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ตสฺยมำ กถำ นิศมฺย ผีษฺฏ อุจฺไจ: สฺวเรณ กถิตวานฺ เห เปาล ตฺวมฺ อุนฺมตฺโตสิ พหุวิทฺยาภฺยาเสน ตฺวํ หตชฺญาโน ชาต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ส อุกฺตวานฺ เห มหามหิม ผีษฺฏ นาหมฺ อุนฺมตฺต: กินฺตุ สตฺยํ วิเวจนียญฺจ วากฺยํ ปฺรเสฺตามิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ยสฺย สากฺษาทฺ อกฺโษภ: สนฺ กถำ กถยามิ ส ราชา ตทฺวฺฤตฺตานฺตํ ชานาติ ตสฺย สมีเป กิมปิ คุปฺตํ เนติ มยา นิศฺจิตํ พุธฺยเต ยตสฺตทฺ วิชเน น กฺฤตํฯ ");
INSERT INTO santha_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","เห อาคฺริปฺปราช ภวานฺ กึ ภวิษฺยทฺวาทิคโณกฺตานิ วากฺยานิ ปฺรเตฺยติ? ภวานฺ ปฺรเตฺยติ ตทหํ ชานามิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ตต อาคฺริปฺป: เปาลมฺ อภิหิตวานฺ ตฺวํ ปฺรวฺฤตฺตึ ชนยิตฺวา ปฺราเยณ มามปิ ขฺรีษฺฏียํ กโรษิฯ ");
INSERT INTO santha_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ตต: โส'วาทีตฺ ภวานฺ เย เย โลกาศฺจ มม กถามฺ อทฺย ศฺฤณฺวนฺติ ปฺราเยณ อิติ นหิ กินฺเตฺวตตฺ ศฺฤงฺขลพนฺธนํ วินา สรฺวฺวถา เต สรฺเวฺว มาทฺฤศา ภวนฺตฺวิตีศฺวสฺย สมีเป ปฺรารฺถเย'หมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","เอตสฺยำ กถายำ กถิตายำ ส ราชา โส'ธิปติ รฺพรฺณีกี สภาสฺถา โลกาศฺจ ตสฺมาทฺ อุตฺถาย ");
INSERT INTO santha_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","โคปเน ปรสฺปรํ วิวิจฺย กถิตวนฺต เอษ ชโน พนฺธนารฺหํ ปฺราณหนนารฺหํ วา กิมปิ กรฺมฺม นากโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ตต อาคฺริปฺป: ผีษฺฏมฺ อวทตฺ, ยเทฺยษ มานุษ: ไกสรสฺย นิกเฏ วิจาริโต ภวิตุํ น ปฺรารฺถยิษฺยตฺ ตรฺหิ มุกฺโต ภวิตุมฺ อศกฺษฺยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ชลปเถนาสฺมากมฺ อิโตลิยาเทศํ ปฺรติ ยาตฺรายำ นิศฺจิตายำ สตฺยำ เต ยูลิยนามฺโน มหาราชสฺย สํฆาตานฺตรฺคตสฺย เสนาปเต: สมีเป เปาลํ ตทนฺยานฺ กตินยชนำศฺจ สมารฺปยนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","วยมฺ อาทฺรามุตฺตียํ โปตเมกมฺ อารุหฺย อาศิยาเทศสฺย ตฏสมีเปน ยาตุํ มตึ กฺฤตฺวา ลงฺครมฺ อุตฺถาปฺย โปตมฺ อโมจยาม; มากิทนิยาเทศสฺถถิษลนีกีนิวาสฺยาริสฺตารฺขนามา กศฺจิทฺ ชโน'สฺมาภิ: สารฺทฺธมฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ปรสฺมินฺ ทิวเส 'สฺมาภิ: สีโทนฺนคเร โปเต ลาคิเต ตตฺร ยูลิย: เสนาปติ: เปาลํ ปฺรติ เสาชนฺยํ ปฺรทรฺถฺย สานฺตฺวนารฺถํ พนฺธุพานฺธวานฺ อุปยาตุมฺ อนุชชฺเญาฯ ");
INSERT INTO santha_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ตสฺมาตฺ โปเต โมจิเต สติ สมฺมุขวาโย: สมฺภวาทฺ วยํ กุโปฺรปทฺวีปสฺย ตีรสมีเปน คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","กิลิกิยายา: ปามฺผูลิยายาศฺจ สมุทฺรสฺย ปารํ คตฺวา ลูกิยาเทศานฺตรฺคตํ มุรานครมฺ อุปาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ตตฺสฺถานาทฺ อิตาลิยาเทศํ คจฺฉติ ย: สิกนฺทริยานครสฺย โปตสฺตํ ตตฺร ปฺราปฺย ศตเสนาปติสฺตํ โปตมฺ อสฺมานฺ อาโรหยตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ตต: ปรํ พหูนิ ทินานิ ศไน: ศไน: รฺคตฺวา กฺนีทปารฺโศฺวปสฺถฺติे: ปูรฺวฺวํ ปฺรติกูเลน ปวเนน วยํ สลฺโมนฺยา: สมฺมุขมฺ อุปสฺถาย กฺรีตฺยุปทฺวีปสฺย ตีรสมีเปน คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","กษฺเฏน ตมุตฺตีรฺยฺย ลาเสยานครสฺยาธ: สุนฺทรนามกํ ขาตมฺ อุปาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","อิตฺถํ พหุติถ: กาโล ยาปิต อุปวาสทินญฺจาตีตํ, ตตฺการณาตฺ เนาวรฺตฺมนิ ภยงฺกเร สติ เปาโล วินเยน กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","เห มเหจฺฉา อหํ นิศฺจยํ ชานามิ ยาตฺรายามสฺยามฺ อสฺมากํ เกฺลศา พหูนามปจยาศฺจ ภวิษฺยนฺติ, เต เกวลํ โปตสามคฺโรฺยริติ นหิ, กินฺตฺวสฺมากํ ปฺราณานามปิฯ ");
INSERT INTO santha_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ตทา ศตเสนาปติ: เปาैेโลกฺตวากฺยโตปิ กรฺณธารสฺย โปตวณิชศฺจ วากฺยํ พหุมํสฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ตตฺ ขาตํ ศีตกาเล วาสารฺหสฺถานํ น ตสฺมาทฺ อวาจีปฺรตีโจรฺทิโศ: กฺรีตฺยา: ไผนีกิยขาตํ ยาตุํ ยทิ ศกฺนุวนฺตสฺตรฺหิ ตตฺร ศีตกาลํ ยาปยิตุํ ปฺราเยณ สรฺเวฺว มนฺตฺรยามาสุ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ตต: ปรํ ทกฺษิณวายุ รฺมนฺทํ วหตีติ วิโลกฺย นิชาภิปฺรายสฺย สิทฺเธ: สุโยโค ภวตีติ พุทฺธฺวา โปตํ โมจยิตฺวา กฺรีตฺยุปทฺวีปสฺย ตีรสมีเปน จลิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","กินฺตฺวลฺปกฺษณาตฺ ปรเมว อุรกฺลุโทนฺนามา ปฺรติกูล: ปฺรจณฺโฑ วายุ รฺวหนฺ โปเต'ลคีตฺ ");
INSERT INTO santha_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ตสฺยาภิมุขํ คนฺตุมฺ โปตสฺยาศกฺตตฺวาทฺ วยํ วายุนา สฺวยํ นีตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","อนนฺตรํ เกฺลาทีนามฺน อุปทฺวีปสฺย กูลสมีเปน โปตํ คมยิตฺวา พหุนา กษฺเฏน กฺษุทฺรนาวมฺ อรกฺษามฯ ");
INSERT INTO santha_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","เต ตามารุหฺย รชฺชฺจา โปตสฺยาโธภาคมฺ อพธฺนนฺ ตทนนฺตรํ เจตฺ โปโต ไสกเต ลคตีติ ภยาทฺ วาตวสนานฺยโมจยนฺ ตต: โปโต วายุนา จาลิต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","กินฺตุ กฺรมโศ วาโย: ปฺรพลตฺวาตฺ โปโต โทลายมาโน'ภวตฺ ปรสฺมินฺ ทิวเส โปตสฺถานิ กติปยานิ ทฺรวฺยาณิ โตเย นิกฺษิปฺตานิฯ ");
INSERT INTO santha_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ตฺฤตียทิวเส วยํ สฺวหไสฺต: โปตสชฺชนทฺรวฺยาณิ นิกฺษิปฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ตโต พหุทินานิ ยาวตฺ สูรฺยฺยนกฺษตฺราทีนิ สมาจฺฉนฺนานิ ตโต 'ตีว วาตฺยาคมาทฺ อสฺมากํ ปฺราณรกฺษายา: กาปิ ปฺรตฺยาศา นาติษฺฐตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","พหุทิเนษุ โลไกรนาหาเรณ ยาปิเตษุ สรฺเวฺวษำ สากฺษตฺ เปาลสฺติษฺฐนฺ อกถยตฺ, เห มเหจฺฉา: กฺรีตฺยุปทฺวีปาตฺ โปตํ น โมจยิตุมฺ อหํ ปูรฺวฺวํ ยทฺ อวทํ ตทฺคฺรหณํ ยุษฺมากมฺ อุจิตมฺ อาสีตฺ ตถา กฺฤเต ยุษฺมากมฺ เอษา วิปทฺ เอโษ'ปจยศฺจ นาฆฏิเษฺยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","กินฺตุ สามฺปฺรตํ ยุษฺมานฺ วินีย พฺรวีมฺยหํ, ยูยํ น กฺษุภฺยต ยุษฺมากมฺ เอกสฺยาปิ ปฺราณิโน หานิ รฺน ภวิษฺยติ, เกวลสฺย โปตสฺย หานิ รฺภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ยโต ยเสฺยศฺวรสฺย โลโก'หํ ยญฺจาหํ ปริจรามิ ตทีย เอโก ทูโต โหฺย ราเตฺรา มมานฺติเก ติษฺฐนฺ กถิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","เห เปาล มา ไภษี: ไกสรสฺย สมฺมุเข ตฺวโยปสฺถาตวฺยํ; ตไวตานฺ สงฺคิโน โลกานฺ อีศฺวรสฺตุภฺยํ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","อเตอว เห มเหจฺฉา ยูยํ สฺถิรมนโส ภวต มหฺยํ ยา กถากถิ สาวศฺยํ ฆฏิษฺยเต มไมตาทฺฤศี วิศฺวาส อีศฺวเร วิทฺยเต, ");
INSERT INTO santha_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","กินฺตุ กสฺยจิทฺ อุปทฺวีปโสฺยปริ ปติตวฺยมฺ อสฺมาภิ:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ตต: ปรมฺ อาทฺริยาสมุเทฺร โปตสฺตไถว โทลายมาน: สนฺ อิตสฺตโต คจฺฉนฺ จตุรฺทศทิวสสฺย ราเตฺร รฺทฺวิตียปฺรหรสมเย กสฺยจิตฺ สฺถลสฺย สมีปมุปติษฺฐตีติ โปตียโลกา อนฺวมนฺยนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ตตเสฺต ชลํ ปริมาย ตตฺร วึศติ รฺวฺยามา ชลานีติ ชฺญาตวนฺต:ฯ กิญฺจิทฺทูรํ คตฺวา ปุนรปิ ชลํ ปริมิตวนฺต:ฯ ตตฺร ปญฺจทศ วฺยามา ชลานิ ทฺฤษฺฏฺวา ");
INSERT INTO santha_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","เจตฺ ปาษาเณ ลคตีติ ภยาตฺ โปตสฺย ปศฺจาทฺภาคตศฺจตุโร ลงฺครานฺ นิกฺษิปฺย ทิวากรมฺ อเปกฺษฺย สรฺเวฺว สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","กินฺตุ โปตียโลกา: โปตาคฺรภาเค ลงฺครนิกฺเษปํ ฉลํ กฺฤตฺวา ชลเธา กฺษุทฺรนาวมฺ อวโรหฺย ปลายิตุมฺ อเจษฺฏนฺตฯ ");
INSERT INTO santha_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ตต: เปาล: เสนาปตเย ไสนฺยคณาย จ กถิตวานฺ, เอเต ยทิ โปตมเธฺย น ติษฺฐนฺติ ตรฺหิ ยุษฺมากํ รกฺษณํ น ศกฺยํฯ ");
INSERT INTO santha_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ตทา เสนาคโณ รชฺชูนฺ ฉิตฺวา นาวํ ชเล ปติตุมฺ อททาตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ปฺรภาตสมเย เปาล: สรฺวฺวานฺ ชนานฺ โภชนารฺถํ ปฺรารฺถฺย วฺยาหรตฺ, อทฺย จตุรฺทศทินานิ ยาวทฺ ยูยมฺ อเปกฺษมานา อนาหารา: กาลมฺ อยาปยต กิมปิ นาภุํคฺธํฯ ");
INSERT INTO santha_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","อโต วินเยे'หํ ภกฺษฺยํ ภุชฺยตำ ตโต ยุษฺมากํ มงฺคลํ ภวิษฺยติ, ยุษฺมากํ กสฺยจิชฺชนสฺย ศิรส: เกไศโกปิ น นํกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","อิติ วฺยาหฺฤตฺย เปาลํ ปูปํ คฺฤหีเตฺวศฺวรํ ธนฺยํ ภาษมาณสฺตํ ภํกฺตฺวา โภกฺตุมฺ อารพฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","อนนฺตรํ สรฺเวฺว จ สุสฺถิรา: สนฺต: ขาทฺยานิ ปรฺปฺยคฺฤหฺลนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","อสฺมากํ โปเต ษฏฺสปฺตตฺยธิกศตทฺวยโลกา อาสนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","สรฺเวฺวษุ โลเกษุ ยเถษฺฏํ ภุกฺตวตฺสุ โปตสฺถนฺ โคธูมานฺ ชลเธา นิกฺษิปฺย ไต: โปตสฺย ภาโร ลฆูกฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ทิเน ชาเต'ปิ ส โก เทศ อิติ ตทา น ปรฺยฺยจียต; กินฺตุ ตตฺร สมตฏมฺ เอกํ ขาตํ ทฺฤษฺฏฺวา ยทิ ศกฺนุมสฺตรฺหิ วยํ ตสฺยาภฺยนฺตรํ โปตํ คมยาม อิติ มตึ กฺฤตฺวา เต ลงฺครานฺ ฉิตฺตฺวา ชลเธา ตฺยกฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ตถา กรฺณพนฺธนํ โมจยิตฺวา ปฺรธานํ วาตวสนมฺ อุตฺโตลฺย ตีรสมีปํ คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","กินฺตุ ทฺวโย: สมุทฺรโย: สงฺคมสฺถาเน ไสกโตปริ โปเต นิกฺษิปฺเต 'คฺรภาเค พาธิเต ปศฺจาทฺภาเค ปฺรพลตรงฺโค'ลคตฺ เตน โปโต ภคฺน:ฯ ");
INSERT INTO santha_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ตสฺมาทฺ พนฺทยศฺเจทฺ พาหุภิสฺตรนฺต: ปลายนฺเต อิตฺยาศงฺกยา เสนาคณสฺตานฺ หนฺตุมฺ อมนฺตฺรยตฺ; ");
INSERT INTO santha_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","กินฺตุ ศตเสนาปติ: เปาลํ รกฺษิตุํ ปฺรยตฺนํ กฺฤตฺวา ตานฺ ตจฺเจษฺฏายา นิวรฺตฺย อิตฺยาทิษฺฏวานฺ, เย พาหุตรณํ ชานนฺติ เต'เคฺร โปฺรลฺลมฺปฺย สมุเทฺร ปติตฺวา พาหุภิสฺตีรฺตฺตฺวา กูลํ ยานฺตุฯ ");
INSERT INTO santha_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","อปรมฺ อวศิษฺฏา ชนา: กาษฺฐํ โปตียํ ทฺรวฺยํ วา เยน ยตฺ ปฺราปฺยเต ตทวลมฺพฺย ยานฺตุ; อิตฺถํ สรฺเวฺว ภูมึ ปฺราปฺย ปฺราไณ รฺชีวิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","อิตฺถํ สรฺเวฺวษุ รกฺษำ ปฺราปฺเตษุ ตตฺรโตฺยปทฺวีปสฺย นาม มิลีเตติ เต ชฺญาตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","อสภฺยโลกา ยเถษฺฏมฺ อนุกมฺปำ กฺฤตฺวา วรฺตฺตมานวฺฤษฺเฏ: ศีตาจฺจ วหฺนึ ปฺรชฺชฺวาลฺยาสฺมากมฺ อาติถฺยมฺ อกุรฺวฺวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","กินฺตุ เปาล อินฺธนานิ สํคฺฤหฺย ยทา ตสฺมินฺ อเคฺรา นิรกฺษิปตฺ, ตทา วเหฺน: ปฺรตาปาตฺ เอก: กฺฤษฺณสรฺโป นิรฺคตฺย ตสฺย หเสฺต ทฺรษฺฏวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","เต'สภฺยโลกาสฺตสฺย หเสฺต สรฺปมฺ อวลมฺพมานํ ทฺฤษฺฏฺวา ปรสฺปรมฺ อุกฺตวนฺต เอษ ชโน'วศฺยํ นรหา ภวิษฺยติ, ยโต ยทฺยปิ ชลเธ รกฺษำ ปฺราปฺตวานฺ ตถาปิ ปฺรติผลทายก เอนํ ชีวิตุํ น ททาติฯ ");
INSERT INTO santha_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","กินฺตุ ส หสฺตํ วิธุนฺวนฺ ตํ สรฺปมฺ อคฺนิมเธฺย นิกฺษิปฺย กามปิ ปีฑำ นาปฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ตโต วิษชฺวาลยา เอตสฺย ศรีรํ สฺผีตํ ภวิษฺยติ ยทฺวา หฐาทยํ ปฺราณานฺ ตฺยกฺษฺยตีติ นิศฺจิตฺย โลกา พหุกฺษณานิ ยาวตฺ ตทฺ ทฺรษฺฏุํ สฺถิตวนฺต: กินฺตุ ตสฺย กสฺยาศฺจิทฺ วิปโท'ฆฏนาตฺ เต ตทฺวิปรีตํ วิชฺญาย ภาษิตวนฺต เอษ กศฺจิทฺ เทโว ภเวตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ปุพฺลิยนามา ชน เอกสฺตโสฺยปทฺวีปสฺยาธิปติราสีตฺ ตตฺร ตสฺย ภูมฺยาทิ จ สฺถิตํฯ ส ชโน'สฺมานฺ นิชคฺฤหํ นีตฺวา เสาชนฺยํ ปฺรกาศฺย ทินตฺรยํ ยาวทฺ อสฺมากํ อาติถฺยมฺ อกโรตฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ตทา ตสฺย ปุพฺลิยสฺย ปิตา ชฺวราติสาเรณ ปีฑฺยมาน: สนฺ ศยฺยายามฺ อาสีตฺ; ตต: เปาลสฺตสฺย สมีปํ คตฺวา ปฺรารฺถนำ กฺฤตฺวา ตสฺย คาเตฺร หสฺตํ สมรฺปฺย ตํ สฺวสฺถํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","อิตฺถํ ภูเต ตทฺวีปนิวาสิน อิตเรปิ โรคิโลกา อาคตฺย นิรามยา อภวนฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ตสฺมาตฺเต'สฺมากมฺ อตีว สตฺการํ กฺฤตวนฺต:, วิเศษต: ปฺรสฺถานสมเย ปฺรโยชนียานิ นานทฺรวฺยาณิ ทตฺตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","อิตฺถํ ตตฺร ตฺริษุ มาเสษุ คเตษุ ยสฺย จิหฺนํ ทิยสฺกูรี ตาทฺฤศ เอก: สิกนฺทรียนครสฺย โปต: ศีตกาลํ ยาปยนฺ ตสฺมินฺ อุปทฺวีเป 'ติษฺฐตฺ ตเมว โปตํ วยมฺ อารุหฺย ยาตฺรามฺ อกุรฺมฺมฯ ");
INSERT INTO santha_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ตต: ปฺรถมต: สุรากูสนครมฺ อุปสฺถาย ตตฺร ตฺรีณิ ทินานิ สฺถิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ตสฺมาทฺ อาวฺฤตฺย รีคิยนครมฺ อุปสฺถิตา: ทิไนกสฺมาตฺ ปรํ ทกฺษิณวเยา สานุกูเลฺย สติ ปรสฺมินฺ ทิวเส ปติยลีนครมฺ อุปาติษฺฐามฯ ");
INSERT INTO santha_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ตโต'สฺมาสุ ตตฺรตฺยํ ภฺราตฺฤคณํ ปฺราปฺเตษุ เต ไสฺว: สารฺทฺธมฺ อสฺมานฺ สปฺต ทินานิ สฺถาปยิตุมฺ อยตนฺต, อิตฺถํ วยํ โรมานครมฺ ปฺรตฺยคจฺฉามฯ ");
INSERT INTO santha_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ตสฺมาตฺ ตตฺรตฺยา: ภฺราตโร'สฺมากมฺ อาคมนวารฺตฺตำ ศฺรุตฺวา อาปฺปิยผรํ ตฺริษฺฏาวรฺณีญฺจ ยาวทฺ อเคฺรสรา: สนฺโตสฺมานฺ สากฺษาตฺ กรฺตฺตุมฺ อาคมนฺ; เตษำ ทรฺศนาตฺ เปาล อีศฺวรํ ธนฺยํ วทนฺ อาศฺวาสมฺ อาปฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","อสฺมาสุ โรมานครํ คเตษุ ศตเสนาปติ: สรฺวฺวานฺ พนฺทีนฺ ปฺรธานเสนาปเต: สมีเป สมารฺปยตฺ กินฺตุ เปาลาย สฺวรกฺษกปทาตินา สห ปฺฤถคฺ วสฺตุมฺ อนุมตึ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ทินตฺรยาตฺ ปรํ เปาลสฺตทฺเทศสฺถานฺ ปฺรธานยิหูทิน อาหูตวานฺ ตตเสฺตษุ สมุปสฺถิเตษุ ส กถิตวานฺ, เห ภฺราตฺฤคณ นิชโลกานำ ปูรฺวฺวปุรุษาณำ วา รีเต รฺวิปรีตํ กิญฺจน กรฺมฺมาหํ นากรวํ ตถาปิ ยิรูศาลมนิวาสิโน โลกา มำ พนฺทึ กฺฤตฺวา โรมิโลกานำ หเสฺตษุ สมรฺปิตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","โรมิโลกา วิจารฺยฺย มม ปฺราณหนนารฺหํ กิมปิ การณํ น ปฺราปฺย มำ โมจยิตุมฺ ไอจฺฉนฺ; ");
INSERT INTO santha_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","กินฺตุ ยิหูทิโลกานามฺ อาปตฺตฺยา มยา ไกสรราชสฺย สมีเป วิจารสฺย ปฺรารฺถนา กรฺตฺตวฺยา ชาตา โนเจตฺ นิชเทศียโลกานฺ ปฺรติ มม โกปฺยภิโยโค นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","เอตตฺการณาทฺ อหํ ยุษฺมานฺ ทฺรษฺฏุํ สํลปิตุญฺจาหูยมฺ อิสฺราเยลฺวศียานำ ปฺรตฺยาศาเหโตหมฺ เอเตน ศุงฺขเลน พทฺโธ'ภวมฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ตทา เต ตมฺ อวาทิษุ:, ยิหูทียเทศาทฺ วยํ ตฺวามธิ กิมปิ ปตฺรํ น ปฺราปฺตา เย ภฺราตร: สมายาตาเสฺตษำ โกปิ ตว กามปิ วารฺตฺตำ นาวทตฺ อภทฺรมปิ นากถยจฺจฯ ");
INSERT INTO santha_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ตว มตํ กิมิติ วยํ ตฺวตฺต: โศฺรตุมิจฺฉาม:ฯ ยทฺ อิทํ นวีนํ มตมุตฺถิตํ ตตฺ สรฺวฺวตฺร สรฺเวฺวษำ นิกเฏ นินฺทิตํ ชาตม อิติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ไตสฺตทรฺถมฺ เอกสฺมินฺ ทิเน นิรูปิเต ตสฺมินฺ ทิเน พหว เอกตฺร มิลิตฺวา เปาลสฺย วาสคฺฤหมฺ อาคจฺฉนฺ ตสฺมาตฺ เปาล อา ปฺราต:กาลาตฺ สนฺธฺยากาลํ ยาวนฺ มูสาวฺยวสฺถาคฺรนฺถาทฺ ภวิษฺยทฺวาทินำ คฺรนฺเถภฺยศฺจ ยีโศ: กถามฺ อุตฺถาปฺย อีศฺวรสฺย ราเชฺย ปฺรมาณํ ทตฺวา เตษำ ปฺรวฺฤตฺตึ ชนยิตุํ เจษฺฏิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","เกจิตฺตุ ตสฺย กถำ ปฺรตฺยายนฺ เกจิตฺตุ น ปฺรตฺยายนฺ; ");
INSERT INTO santha_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","เอตตฺการณาตฺ เตษำ ปรสฺปรมฺ อไนกฺยาตฺ สรฺเวฺว จลิตวนฺต:; ตถาปิ เปาล เอตำ กถาเมกำ กถิตวานฺ ปวิตฺร อาตฺมา ยิศยิยสฺย ภวิษฺยทฺวกฺตุ รฺวทนาทฺ อสฺมากํ ปิตฺฤปุรุเษภฺย เอตำ กถำ ภทฺรํ กถยามาส, ยถา, ");
INSERT INTO santha_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"อุปคตฺย ชนาเนตานฺ ตฺวํ ภาษสฺว วจสฺตฺวิทํฯ กรฺไณ: โศฺรษฺยถ ยูยํ หิ กินฺตุ ยูยํ น โภตฺสฺยถฯ เนไตฺร รฺทฺรกฺษฺยถ ยูยญฺจ ชฺญาตุํ ยูยํ น ศกฺษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","เต มานุษา ยถา เนไตฺร: ปริปศฺยนฺติ ไนว หิฯ กรฺไณ: รฺยถา น ศฺฤณฺวนฺติ พุธฺยนฺเต น จ มานไส:ฯ วฺยาวรฺตฺตยตฺสุ จิตฺตานิ กาเล กุตฺราปิ เตษุ ไวฯ มตฺตเสฺต มนุชา: สฺวสฺถา ยถา ไนว ภวนฺติ จฯ ตถา เตษำ มนุษฺยาณำ สนฺติ สฺถูลา หิ พุทฺธย:ฯ พธิรีภูตกรฺณาศฺจ ชาตาศฺจ มุทฺริตา ทฺฤศ:๚ ");
INSERT INTO santha_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","อต อีศฺวราทฺ ยตฺ ปริตฺราณํ ตสฺย วารฺตฺตา ภินฺนเทศียานำ สมีปํ เปฺรษิตา เตอว ตำ คฺรหีษฺยนฺตีติ ยูยํ ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","เอตาทฺฤศฺยำ กถายำ กถิตายำ สตฺยำ ยิหูทิน: ปรสฺปรํ พหุวิจารํ กุรฺวฺวนฺโต คตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","อิตฺถํ เปาล: สมฺปูรฺณํ วตฺสรทฺวยํ ยาวทฺ ภาฏกีเย วาสคฺฤเห วสนฺ เย โลกาสฺตสฺย สนฺนิธิมฺ อาคจฺฉนฺติ ตานฺ สรฺวฺวาเนว ปริคฺฤหฺลนฺ, ");
INSERT INTO santha_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","นิรฺวิฆฺนมฺ อติศยนิ:กฺโษภมฺ อีศฺวรียราชตฺวสฺย กถำ ปฺรจารยนฺ ปฺรเภา ยีเศา ขฺรีษฺเฏ กถา: สมุปาทิศตฺฯ อิติ๚");
INSERT INTO santha_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","อีศฺวโร นิชปุตฺรมธิ ยํ สุสํวาทํ ภวิษฺยทฺวาทิภิ รฺธรฺมฺมคฺรนฺเถ ปฺรติศฺรุตวานฺ ตํ สุสํวาทํ ปฺรจารยิตุํ ปฺฤถกฺกฺฤต อาหูต: เปฺรริตศฺจ ปฺรโภ รฺยีศุขฺรีษฺฏสฺย เสวโก ย: เปาล: ");
INSERT INTO santha_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ส โรมานครสฺถานฺ อีศฺวรปฺริยานฺ อาหูตำศฺจ ปวิตฺรโลกานฺ ปฺรติ ปตฺรํ ลิขติฯ ");
INSERT INTO santha_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","อสฺมากํ ส ปฺรภุ รฺยีศุ: ขฺรีษฺฏ: ศารีริกสมฺพนฺเธน ทายูโท วํโศทฺภว: ");
INSERT INTO santha_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ปวิตฺรสฺยาตฺมน: สมฺพนฺเธน เจศฺวรสฺย ปฺรภาววานฺ ปุตฺร อิติ ศฺมศานาตฺ ตโสฺยตฺถาเนน ปฺรติปนฺนํฯ ");
INSERT INTO santha_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","อปรํ เยษำ มเธฺย ยีศุนา ขฺรีษฺเฏน ยูยมปฺยาหูตาเสฺต 'นฺยเทศียโลกาสฺตสฺย นามฺนิ วิศฺวสฺย นิเทศคฺราหิโณ ยถา ภวนฺติ ");
INSERT INTO santha_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ตทภิปฺราเยณ วยํ ตสฺมาทฺ อนุคฺรหํ เปฺรริตตฺวปทญฺจ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ตาเตนาสฺมากมฺ อีศฺวเรณ ปฺรภุณา ยีศุขฺรีษฺเฏน จ ยุษฺมภฺยมฺ อนุคฺรห: ศานฺติศฺจ ปฺรทีเยตำฯ ");
INSERT INTO santha_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ปฺรถมต: สรฺวฺวสฺมินฺ ชคติ ยุษฺมากํ วิศฺวาสสฺย ปฺรกาศิตตฺวาทฺ อหํ ยุษฺมากํ สรฺเวฺวษำ นิมิตฺตํ ยีศุขฺรีษฺฏสฺย นาม คฺฤหฺลนฺ อีศฺวรสฺย ธนฺยวาทํ กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","อปรมฺ อีศฺวรสฺย ปฺรสาทาทฺ พหุกาลาตฺ ปรํ สามฺปฺรตํ ยุษฺมากํ สมีปํ ยาตุํ กถมปิ ยตฺ สุโยคํ ปฺราปฺโนมิ, เอตทรฺถํ นิรนฺตรํ นามานฺยุจฺจารยนฺ นิชาสุ สรฺวฺวปฺรารฺถนาสุ สรฺวฺวทา นิเวทยามิ, ");
INSERT INTO santha_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","เอตสฺมินฺ ยมหํ ตตฺปุตฺรียสุสํวาทปฺรจารเณน มนสา ปริจรามิ ส อีศฺวโร มม สากฺษี วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ยโต ยุษฺมากํ มม จ วิศฺวาเสน วยมฺ อุภเย ยถา ศานฺติยุกฺตา ภวาม อิติ การณาทฺ ");
INSERT INTO santha_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ยุษฺมากํ ไสฺถรฺยฺยกรณารฺถํ ยุษฺมภฺยํ กิญฺจิตฺปรมารฺถทานทานาย ยุษฺมานฺ สากฺษาตฺ กรฺตฺตุํ มทียา วาญฺฉาฯ ");
INSERT INTO santha_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","เห ภฺราตฺฤคณ ภินฺนเทศียโลกานำ มเธฺย ยทฺวตฺ ตทฺวทฺ ยุษฺมากํ มเธฺยปิ ยถา ผลํ ภุญฺเช ตทภิปฺราเยณ มุหุรฺมุหุ รฺยุษฺมากํ สมีปํ คนฺตุมฺ อุทฺยโต'หํ กินฺตุ ยาวทฺ อทฺย ตสฺมินฺ คมเน มม วิคฺโหฺน ชาต อิติ ยูยํ ยทฺ อชฺญาตาสฺติษฺฐถ ตทหมฺ อุจิตํ น พุเธฺยฯ ");
INSERT INTO santha_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","อหํ สภฺยาสภฺยานำ วิทฺวทวิทฺวตาญฺจ สรฺเวฺวษามฺ ฤณี วิเทฺยฯ ");
INSERT INTO santha_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","อเตอว โรมานิวาสินำ ยุษฺมากํ สมีเป'ปิ ยถาศกฺติ สุสํวาทํ ปฺรจารยิตุมฺ อหมฺ อุทฺยโตสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ยต: ขฺรีษฺฏสฺย สุสํวาโท มม ลชฺชาสฺปทํ นหิ ส อีศฺวรสฺย ศกฺติสฺวรูป: สนฺ อา ยิหูทีเยโภฺย 'นฺยชาตียานฺ ยาวตฺ สรฺวฺวชาตียานำ มเธฺย ย: กศฺจิทฺ ตตฺร วิศฺวสิติ ตไสฺยว ตฺราณํ ชนยติฯ ");
INSERT INTO santha_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ยต: ปฺรตฺยยสฺย สมปริมาณมฺ อีศฺวรทตฺตํ ปุณฺยํ ตตฺสุสํวาเท ปฺรกาศเตฯ ตทธิ ธรฺมฺมปุสฺตเกปิ ลิขิตมิทํ \"ปุณฺยวานฺ ชโน วิศฺวาเสน ชีวิษฺยติ\"ฯ ");
INSERT INTO santha_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","อเตอว เย มานวา: ปาปกรฺมฺมณา สตฺยตำ รุนฺธนฺติ เตษำ สรฺวฺวสฺย ทุราจรณสฺยาธรฺมฺมสฺย จ วิรุทฺธํ สฺวรฺคาทฺ อีศฺวรสฺย โกป: ปฺรกาศเตฯ ");
INSERT INTO santha_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ยต อีศฺวรมธิ ยทฺยทฺ เชฺญยํ ตทฺ อีศฺวร: สฺวยํ ตานฺ ปฺรติ ปฺรกาศิตวานฺ ตสฺมาตฺ เตษามฺ อโคจรํ นหิฯ ");
INSERT INTO santha_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ผลตสฺตสฺยานนฺตศกฺตีศฺวรตฺวาทีนฺยทฺฤศฺยานฺยปิ สฺฤษฺฏิกาลมฺ อารภฺย กรฺมฺมสุ ปฺรกาศมานานิ ทฺฤศฺยนฺเต ตสฺมาตฺ เตษำ โทษปฺรกฺษาลนสฺย ปนฺถา นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","อปรมฺ อีศฺวรํ ชฺญาตฺวาปิ เต ตมฺ อีศฺวรชฺญาเนน นาทฺริยนฺต กฺฤตชฺญา วา น ชาตา:; ตสฺมาตฺ เตษำ สรฺเวฺว ตรฺกา วิผลีภูตา:, อปรญฺจ เตษำ วิเวกศูนฺยานิ มนำสิ ติมิเร มคฺนานิฯ ");
INSERT INTO santha_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","เต สฺวานฺ ชฺญานิโน ชฺญาตฺวา ชฺญานหีนา อภวนฺ ");
INSERT INTO santha_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","อนศฺวรเสฺยศฺวรสฺย เคารวํ วิหาย นศฺวรมนุษฺยปศุปกฺษฺยุโรคามิปฺรภฺฤเตรากฺฤติวิศิษฺฏปฺรติมาไสฺตราศฺริตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","อิตฺถํ ต อีศฺวรสฺย สตฺยตำ วิหาย มฺฤษามตมฺ อาศฺริตวนฺต: สจฺจิทานนฺทํ สฺฤษฺฏิกรฺตฺตารํ ตฺยกฺตฺวา สฺฤษฺฏวสฺตุน: ปูชำ เสวาญฺจ กฺฤตวนฺต:; ");
INSERT INTO santha_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","อิติ เหโตรีศฺวรสฺตานฺ กุกฺริยายำ สมรฺปฺย นิชนิชกุจินฺตาภิลาษาภฺยำ สฺวํ สฺวํ ศรีรํ ปรสฺปรมฺ อปมานิตํ กรฺตฺตุมฺ อททาตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","อีศฺวเรณ เตษุ กฺวภิลาเษ สมรฺปิเตษุ เตษำ โยษิต: สฺวาภาวิกาจรณมฺ อปหาย วิปรีตกฺฤเตฺย ปฺราวรฺตฺตนฺต; ");
INSERT INTO santha_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ตถา ปุรุษา อปิ สฺวาภาวิกโยษิตฺสงฺคมํ วิหาย ปรสฺปรํ กามกฺฤศานุนา ทคฺธา: สนฺต: ปุมำส: ปุํภิ: สากํ กุกฺฤเตฺย สมาสชฺย นิชนิชภฺรานฺเต: สมุจิตํ ผลมฺ อลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","เต เสฺวษำ มน:สฺวีศฺวราย สฺถานํ ทาตุมฺ อนิจฺฉุกาสฺตโต เหโตรีศฺวรสฺตานฺ ปฺรติ ทุษฺฏมนสฺกตฺวมฺ อวิหิตกฺริยตฺวญฺจ ทตฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","อเตอว เต สรฺเวฺว 'นฺยาโย วฺยภิจาโร ทุษฺฏตฺวํ โลโภ ชิฆำสา อีรฺษฺยา วโธ วิวาทศฺจาตุรี กุมติริตฺยาทิภิ รฺทุษฺกรฺมฺมภิ: ปริปูรฺณา: สนฺต: ");
INSERT INTO santha_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","กรฺเณชปา อปวาทิน อีศฺวรเทฺวษกา หึสกา อหงฺการิณ อาตฺมศฺลาฆิน: กุกรฺมฺโมตฺปาทกา: ปิโตฺรราชฺญาลงฺฆกา ");
INSERT INTO santha_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","อวิจารกา นิยมลงฺฆิน: เสฺนหรหิตา อติเทฺวษิโณ นิรฺทยาศฺจ ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","เย ชนา เอตาทฺฤศํ กรฺมฺม กุรฺวฺวนฺติ เตอว มฺฤติโยคฺยา อีศฺวรสฺย วิจารมีทฺฤศํ ชฺญาตฺวาปิ ต เอตาทฺฤศํ กรฺมฺม สฺวยํ กุรฺวฺวนฺติ เกวลมิติ นหิ กินฺตุ ตาทฺฤศกรฺมฺมการิษุ โลเกษฺวปิ ปฺรียนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","เห ปรทูษก มนุษฺย ย: กศฺจน ตฺวํ ภวสิ ตโวตฺตรทานาย ปนฺถา นาสฺติ ยโต ยสฺมาตฺ กรฺมฺมณ: ปรสฺตฺวยา ทูษฺยเต ตสฺมาตฺ ตฺวมปิ ทูษฺยเส, ยตสฺตํ ทูษยนฺนปิ ตฺวํ ตทฺวทฺ อาจรสิฯ ");
INSERT INTO santha_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","กินฺเตฺวตาทฺฤคาจาริโภฺย ยํ ทณฺฑมฺ อีศฺวโร นิศฺจิโนติ ส ยถารฺถ อิติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","อเตอว เห มานุษ ตฺวํ ยาทฺฤคาจาริโณ ทูษยสิ สฺวยํ ยทิ ตาทฺฤคาจรสิ ตรฺหิ ตฺวมฺ อีศฺวรทณฺฑาตฺ ปลายิตุํ ศกฺษฺยสีติ กึ พุธฺยเส? ");
INSERT INTO santha_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","อปรํ ตว มนส: ปริวรฺตฺตนํ กรฺตฺตุมฺ อิศฺวรสฺยานุคฺรโห ภวติ ตนฺน พุทฺธฺวา ตฺวํ กึ ตทียานุคฺรหกฺษมาจิรสหิษฺณุตฺวนิธึ ตุจฺฉีกโรษิ? ");
INSERT INTO santha_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ตถา สฺวานฺต:กรณสฺย กโฐรตฺวาตฺ เขทราหิตฺยาจฺเจศฺวรสฺย นฺยายฺยวิจารปฺรกาศนสฺย โกฺรธสฺย จ ทินํ ยาวตฺ กึ สฺวารฺถํ โกปํ สญฺจิโนษิ? ");
INSERT INTO santha_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","กินฺตุ ส เอไกกมนุชาย ตตฺกรฺมฺมานุสาเรณ ปฺรติผลํ ทาสฺยติ; ");
INSERT INTO santha_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","วสฺตุตสฺตุ เย ชนา ไธรฺยฺยํ ธฺฤตฺวา สตฺกรฺมฺม กุรฺวฺวนฺโต มหิมา สตฺกาโร'มรตฺวญฺไจตานิ มฺฤคยนฺเต เตโภฺย'นนฺตายุ รฺทาสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","อปรํ เย ชนา: สตฺยธรฺมฺมมฺ อคฺฤหีตฺวา วิปรีตธรฺมฺมมฺ คฺฤหฺลนฺติ ตาทฺฤศา วิโรธิชนา: โกปํ โกฺรธญฺจ โภกฺษฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","อา ยิหูทิโน'นฺยเทศิน: ปรฺยฺยนฺตํ ยาวนฺต: กุกรฺมฺมการิณ: ปฺราณิน: สนฺติ เต สรฺเวฺว ทุ:ขํ ยาตนาญฺจ คมิษฺยนฺติ; ");
INSERT INTO santha_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","กินฺตุ อา ยิหูทิโน ภินฺนเทศิปรฺยฺยนฺตา ยาวนฺต: สตฺกรฺมฺมการิโณ โลกา: สนฺติ ตานฺ ปฺรติ มหิมา สตฺการ: ศานฺติศฺจ ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","อีศฺวรสฺย วิจาเร ปกฺษปาโต นาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","อลพฺธวฺยวสฺถาศาสฺไตฺร ไรฺย: ปาปานิ กฺฤตานิ วฺยวสฺถาศาสฺตฺราลพฺธตฺวานุรูปเสฺตษำ วินาโศ ภวิษฺยติ; กินฺตุ ลพฺธวฺยวสฺถาศาสฺตฺรา เย ปาปานฺยกุรฺวฺวนฺ วฺยวสฺถานุสาราเทว เตษำ วิจาโร ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","วฺยวสฺถาโศฺรตาร อีศฺวรสฺย สมีเป นิษฺปาปา ภวิษฺยนฺตีติ นหิ กินฺตุ วฺยวสฺถาจาริณ เอว สปุณฺยา ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ยโต 'ลพฺธวฺยวสฺถาศาสฺตฺรา ภินฺนเทศียโลกา ยทิ สฺวภาวโต วฺยวสฺถานุรูปานฺ อาจารานฺ กุรฺวฺวนฺติ ตรฺหฺยลพฺธศาสฺตฺรา: สนฺโต'ปิ เต เสฺวษำ วฺยวสฺถาศาสฺตฺรมิว สฺวยเมว ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","เตษำ มนสิ สากฺษิสฺวรูเป สติ เตษำ วิตรฺเกษุ จ กทา ตานฺ โทษิณ: กทา วา นิรฺโทษานฺ กฺฤตวตฺสุ เต สฺวานฺตรฺลิขิตสฺย วฺยวสฺถาศาสฺตฺรสฺย ปฺรมาณํ สฺวยเมว ททติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ยสฺมินฺ ทิเน มยา ปฺรกาศิตสฺย สุสํวาทสฺยานุสาราทฺ อีศฺวโร ยีศุขฺรีษฺเฏน มานุษาณามฺ อนฺต:กรณานำ คูฒาภิปฺรายานฺ ธฺฤตฺวา วิจารยิษฺยติ ตสฺมินฺ วิจารทิเน ตตฺ ปฺรกาศิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ปศฺย ตฺวํ สฺวยํ ยิหูทีติ วิขฺยาโต วฺยวโสฺถปริ วิศฺวาสํ กโรษิ, ");
INSERT INTO santha_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","อีศฺวรมุทฺทิศฺย สฺวํ ศฺลาฆเส, ตถา วฺยวสฺถยา ศิกฺษิโต ภูตฺวา ตสฺยาภิมตํ ชานาสิ, สรฺวฺวาสำ กถานำ สารํ วิวึกฺเษ, ");
INSERT INTO santha_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","อปรํ ชฺญานสฺย สตฺยตายาศฺจากรสฺวรูปํ ศาสฺตฺรํ มม สมีเป วิทฺยต อโต 'นฺธโลกานำ มารฺคทรฺศยิตา ");
INSERT INTO santha_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ติมิรสฺถิตโลกานำ มเธฺย ทีปฺติสฺวรูโป'ชฺญานโลเกโภฺย ชฺญานทาตา ศิศูนำ ศิกฺษยิตาหเมเวติ มนฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ปรานฺ ศิกฺษยนฺ สฺวยํ สฺวํ กึ น ศิกฺษยสิ? วสฺตุตศฺเจารฺยฺยนิเษธวฺยวสฺถำ ปฺรจารยนฺ ตฺวํ กึ สฺวยเมว โจรยสิ? ");
INSERT INTO santha_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ตถา ปรทารคมนํ ปฺรติเษธนฺ สฺวยํ กึ ปรทารานฺ คจฺฉสิ? ตถา ตฺวํ สฺวยํ ปฺรติมาเทฺวษี สนฺ กึ มนฺทิรสฺย ทฺรวฺยาณิ หรสิ? ");
INSERT INTO santha_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ยสฺตฺวํ วฺยวสฺถำ ศฺลาฆเส ส ตฺวํ กึ วฺยวสฺถามฺ อวมตฺย เนศฺวรํ สมฺมนฺยเส? ");
INSERT INTO santha_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ศาสฺเตฺร ยถา ลิขติ \"ภินฺนเทศินำ สมีเป ยุษฺมากํ โทษาทฺ อีศฺวรสฺย นามฺโน นินฺทา ภวติฯ \" ");
INSERT INTO santha_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ยทิ วฺยวสฺถำ ปาลยสิ ตรฺหิ ตว ตฺวกฺเฉทกฺริยา สผลา ภวติ; ยติ วฺยวสฺถำ ลงฺฆเส ตรฺหิ ตว ตฺวกฺเฉโท'ตฺวกฺเฉโท ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ยโต วฺยวสฺถาศาสฺตฺราทิษฺฏธรฺมฺมกรฺมฺมาจารี ปุมานฺ อตฺวกฺเฉที สนฺนปิ กึ ตฺวกฺเฉทินำ มเธฺย น คณยิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","กินฺตุ ลพฺธศาสฺตฺรศฺฉินฺนตฺวกฺ จ ตฺวํ ยทิ วฺยวสฺถาลงฺฆนํ กโรษิ ตรฺหิ วฺยวสฺถาปาลกา: สฺวาภาวิกาจฺฉินฺนตฺวโจ โลกาสฺตฺวำ กึ น ทูษยิษฺยนฺติ? ");
INSERT INTO santha_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ตสฺมาทฺ โย พาเหฺย ยิหูที ส ยิหูที นหิ ตถางฺคสฺย ยสฺตฺวกฺเฉท: ส ตฺวกฺเฉโท นหิ; ");
INSERT INTO santha_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","กินฺตุ โย ชน อานฺตริโก ยิหูที ส เอว ยิหูที อปรญฺจ เกวลลิขิตยา วฺยวสฺถยา น กินฺตุ มานสิโก ยสฺตฺวกฺเฉโท ยสฺย จ ปฺรศํสา มนุเษฺยโภฺย น ภูตฺวา อีศฺวราทฺ ภวติ ส เอว ตฺวกฺเฉท:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","อปรญฺจ ยิหูทิน: กึ เศฺรษฺฐตฺวํ? ตถา ตฺวกฺเฉทสฺย วา กึ ผลํ? ");
INSERT INTO santha_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","สรฺวฺวถา พหูนิ ผลานิ สนฺติ, วิเศษต อีศฺวรสฺย ศาสฺตฺรํ เตโภฺย'ทียตฯ ");
INSERT INTO santha_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ไกศฺจิทฺ อวิศฺวสเน กฺฤเต เตษามฺ อวิศฺวสนาตฺ กิมฺ อีศฺวรสฺย วิศฺวาสฺยตายา หานิรุตฺปตฺสฺยเต? ");
INSERT INTO santha_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","เกนาปิ ปฺรกาเรณ นหิฯ ยทฺยปิ สรฺเวฺว มนุษฺยา มิถฺยาวาทินสฺตถาปีศฺวร: สตฺยวาทีฯ ศาสฺเตฺร ยถา ลิขิตมาเสฺต, อตสฺตฺวนฺตุ สฺววาเกฺยน นิรฺทฺโทโษ หิ ภวิษฺยสิฯ วิจาเร ไจว นิษฺปาโป ภวิษฺยสิ น สํศย:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","อสฺมากมฺ อนฺยาเยน ยทีศฺวรสฺย นฺยาย: ปฺรกาศเต ตรฺหิ กึ วทิษฺยาม:? อหํ มานุษาณำ กถามิว กถำ กถยามิ, อีศฺวร: สมุจิตํ ทณฺฑํ ทตฺตฺวา กิมฺ อนฺยายี ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","อิตฺถํ น ภวตุ, ตถา สตีศฺวร: กถํ ชคโต วิจารยิตา ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","มม มิถฺยาวากฺยวทนาทฺ ยทีศฺวรสฺย สตฺยเตฺวน ตสฺย มหิมา วรฺทฺธเต ตรฺหิ กสฺมาทหํ วิจาเร'ปราธิเตฺวน คโณฺย ภวามิ? ");
INSERT INTO santha_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","มงฺคลารฺถํ ปาปมปิ กรณียมิติ วากฺยํ ตฺวยา กุโต โนจฺยเต? กินฺตุ ไยรุจฺยเต เต นิตานฺตํ ทณฺฑสฺย ปาตฺราณิ ภวนฺติ; ตถาปิ ตทฺวากฺยมฺ อสฺมาภิรปฺยุจฺยต อิตฺยสฺมากํ คฺลานึ กุรฺวฺวนฺต: กิยนฺโต โลกา วทนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","อนฺยโลเกโภฺย วยํ กึ เศฺรษฺฐา:? กทาจน นหิ ยโต ยิหูทิโน 'นฺยเทศินศฺจ สรฺวฺเวอว ปาปสฺยายตฺตา อิตฺยสฺย ปฺรมาณํ วยํ ปูรฺวฺวมฺ อททามฯ ");
INSERT INTO santha_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ลิปิ รฺยถาเสฺต, ไนโกปิ ธารฺมฺมิโก ชน:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ตถา ชฺญานีศฺวรชฺญานี มานว: โกปิ นาสฺติ หิฯ ");
INSERT INTO santha_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","วิมารฺคคามิน: สรฺเวฺว สรฺเวฺว ทุษฺกรฺมฺมการิณ:ฯ เอโก ชโนปิ โน เตษำ สาธุกรฺมฺม กโรติ จฯ ");
INSERT INTO santha_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ตถา เตษานฺตุ ไว กณฺฐา อนาวฺฤตศฺมศานวตฺฯ สฺตุติวาทํ ปฺรกุรฺวฺวนฺติ ชิหฺวาภิเสฺต ตุ เกวลํฯ เตษาโมษฺฐสฺย นิมฺเน ตุ วิษํ ติษฺฐติ สรฺปฺปวตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","มุขํ เตษำ หิ ศาเปน กปเฏน จ ปูรฺยฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","รกฺตปาตาย เตษำ ตุ ปทานิ กฺษิปฺรคานิ จฯ ");
INSERT INTO santha_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ปถิ เตษำ มนุษฺยาณำ นาศ: เกฺลศศฺจ เกวล:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","เต ชนา นหิ ชานนฺติ ปนฺถานํ สุขทายินํฯ ");
INSERT INTO santha_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ปรเมศาทฺ ภยํ ยตฺตตฺ ตจฺจกฺษุโษรโคจรํฯ ");
INSERT INTO santha_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","วฺยวสฺถายำ ยทฺยลฺลิขติ ตทฺ วฺยวสฺถาธีนานฺ โลกานฺ อุทฺทิศฺย ลิขตีติ วยํ ชานีม:ฯ ตโต มนุษฺยมาโตฺร นิรุตฺตร: สนฺ อีศฺวรสฺย สากฺษาทฺ อปราธี ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","อเตอว วฺยวสฺถานุรูไป: กรฺมฺมภิ: กศฺจิทปิ ปฺราณีศฺวรสฺย สากฺษาตฺ สปุณฺยีกฺฤโต ภวิตุํ น ศกฺษฺยติ ยโต วฺยวสฺถยา ปาปชฺญานมาตฺรํ ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","กินฺตุ วฺยวสฺถายา: ปฺฤถคฺ อีศฺวเรณ เทยํ ยตฺ ปุณฺยํ ตทฺ วฺยวสฺถายา ภวิษฺยทฺวาทิคณสฺย จ วจไน: ปฺรมาณีกฺฤตํ สทฺ อิทานีํ ปฺรกาศเตฯ ");
INSERT INTO santha_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ยีศุขฺรีษฺเฏ วิศฺวาสกรณาทฺ อีศฺวเรณ ทตฺตํ ตตฺ ปุณฺยํ สกเลษุ ปฺรกาศิตํ สตฺ สรฺวฺวานฺ วิศฺวาสิน: ปฺรติ วรฺตฺตเตฯ ");
INSERT INTO santha_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","เตษำ โกปิ ปฺรเภโท นาสฺติ, ยต: สรฺวฺเวอว ปาปิน อีศฺวรียเตโชหีนาศฺจ ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ต อีศฺวรสฺยานุคฺรหาทฺ มูลฺยํ วินา ขฺรีษฺฏกฺฤเตน ปริตฺราเณน สปุณฺยีกฺฤตา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ยสฺมาตฺ สฺวโศณิเตน วิศฺวาสาตฺ ปาปนาศโก พลี ภวิตุํ ส เอว ปูรฺวฺวมฺ อีศฺวเรณ นิศฺจิต:, อิตฺถมฺ อีศฺวรียสหิษฺณุตฺวาตฺ ปุรากฺฤตปาปานำ มารฺชฺชนกรเณ สฺวียยาถารฺถฺยํ เตน ปฺรกาศฺยเต, ");
INSERT INTO santha_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","วรฺตฺตมานกาลียมปิ สฺวยาถารฺถฺยํ เตน ปฺรกาศฺยเต, อปรํ ยีเศา วิศฺวาสินํ สปุณฺยีกุรฺวฺวนฺนปิ ส ยาถารฺถิกสฺติษฺฐติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ตรฺหิ กุตฺราตฺมศฺลาฆา? สา ทูรีกฺฤตา; กยา วฺยวสฺถยา? กึ กฺริยารูปวฺยวสฺถยา? อิตฺถํ นหิ กินฺตุ ตตฺ เกวลวิศฺวาสรูปยา วฺยวสฺถไยว ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","อเตอว วฺยวสฺถานุรูปา: กฺริยา วินา เกวเลน วิศฺวาเสน มานว: สปุณฺยีกฺฤโต ภวิตุํ ศกฺโนตีตฺยสฺย ราทฺธานฺตํ ทรฺศยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ส กึ เกวลยิหูทินามฺ อีศฺวโร ภวติ? ภินฺนเทศินามฺ อีศฺวโร น ภวติ? ภินฺนเทศินามปิ ภวติ; ");
INSERT INTO santha_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ยสฺมาทฺ เอก อีศฺวโร วิศฺวาสาตฺ ตฺวกฺเฉทิโน วิศฺวาเสนาตฺวกฺเฉทินศฺจ สปุณฺยีกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ตรฺหิ วิศฺวาเสน วยํ กึ วฺยวสฺถำ ลุมฺปาม? อิตฺถํ น ภวตุ วยํ วฺยวสฺถำ สํสฺถาปยาม เอวฯ ");
INSERT INTO santha_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","อสฺมากํ ปูรฺวฺวปุรุษ อิพฺราหีมฺ กายิกกฺริยยา กึ ลพฺธวานฺ เอตทธิ กึ วทิษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ส ยทิ นิชกฺริยาภฺย: สปุโณฺย ภเวตฺ ตรฺหิ ตสฺยาตฺมศฺลาฆำ กรฺตฺตุํ ปนฺถา ภเวทิติ สตฺยํ, กินฺตฺวีศฺวรสฺย สมีเป นหิฯ ");
INSERT INTO santha_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ศาสฺเตฺร กึ ลิขติ? อิพฺราหีมฺ อีศฺวเร วิศฺวสนาตฺ ส วิศฺวาสสฺตไสฺม ปุณฺยารฺถํ คณิโต พภูวฯ ");
INSERT INTO santha_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","กรฺมฺมการิโณ ยทฺ เวตนํ ตทฺ อนุคฺรหสฺย ผลํ นหิ กินฺตุ เตโนปารฺชิตํ มนฺตวฺยมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","กินฺตุ ย: ปาปินํ สปุณฺยีกโรติ ตสฺมินฺ วิศฺวาสิน: กรฺมฺมหีนสฺย ชนสฺย โย วิศฺวาส: ส ปุณฺยารฺถํ คโณฺย ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","อปรํ ยํ กฺริยาหีนมฺ อีศฺวร: สปุณฺยีกโรติ ตสฺย ธนฺยวาทํ ทายูทฺ วรฺณยามาส, ยถา, ");
INSERT INTO santha_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ส ธโนฺย'ฆานิ มฺฤษฺฏานิ ยสฺยาคำสฺยาวฺฤตานิ จฯ ");
INSERT INTO santha_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ส จ ธนฺย: ปเรเศน ปาปํ ยสฺย น คณฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","เอษ ธนฺยวาทสฺตฺวกฺเฉทินมฺ อตฺวกฺเฉทินํ วา กํ ปฺรติ ภวติ? อิพฺราหีโม วิศฺวาส: ปุณฺยารฺถํ คณิต อิติ วยํ วทาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ส วิศฺวาสสฺตสฺย ตฺวกฺเฉทิตฺวาวสฺถายำ กิมฺ อตฺวกฺเฉทิตฺวาวสฺถายำ กสฺมินฺ สมเย ปุณฺยมิว คณิต:? ตฺวกฺเฉทิตฺวาวสฺถายำ นหิ กินฺตฺวตฺวกฺเฉทิตฺวาวสฺถายำฯ ");
INSERT INTO santha_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","อปรญฺจ ส ยตฺ สรฺเวฺวษามฺ อตฺวกฺเฉทินำ วิศฺวาสินามฺ อาทิปุรุโษ ภเวตฺ, เต จ ปุณฺยวตฺเตฺวน คเณฺยรนฺ; ");
INSERT INTO santha_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","เย จ โลกา: เกวลํ ฉินฺนตฺวโจ น สนฺโต 'สฺมตฺปูรฺวฺวปุรุษ อิพฺราหีมฺ อฉินฺนตฺวกฺ สนฺ เยน วิศฺวาสมารฺเคณ คตวานฺ เตไนว ตสฺย ปาทจิเหฺนน คจฺฉนฺติ เตษำ ตฺวกฺเฉทินามปฺยาทิปุรุโษ ภเวตฺ ตทรฺถมฺ อตฺวกฺเฉทิโน มานวสฺย วิศฺวาสาตฺ ปุณฺยมฺ อุตฺปทฺยต อิติ ปฺรมาณสฺวรูปํ ตฺวกฺเฉทจิหฺนํ ส ปฺราปฺโนตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","อิพฺราหีมฺ ชคโต'ธิการี ภวิษฺยติ ไยษา ปฺรติชฺญา ตํ ตสฺย วํศญฺจ ปฺรติ ปูรฺวฺวมฺ อกฺริยต สา วฺยวสฺถามูลิกา นหิ กินฺตุ วิศฺวาสชนฺยปุณฺยมูลิกาฯ ");
INSERT INTO santha_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ยโต วฺยวสฺถาวลมฺพิโน ยทฺยธิการิโณ ภวนฺติ ตรฺหิ วิศฺวาโส วิผโล ชายเต สา ปฺรติชฺญาปิ ลุปฺไตวฯ ");
INSERT INTO santha_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","อธิกนฺตุ วฺยวสฺถา โกปํ ชนยติ ยโต 'วิทฺยมานายำ วฺยวสฺถายามฺ อาชฺญาลงฺฆนํ น สมฺภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","อเตอว สา ปฺรติชฺญา ยทฺ อนุคฺรหสฺย ผลํ ภเวตฺ ตทรฺถํ วิศฺวาสมูลิกา ยตสฺตถาเตฺว ตทฺวํศสมุทายํ ปฺรติ อรฺถโต เย วฺยวสฺถยา ตทฺวํศสมฺภวา: เกวลํ ตานฺ ปฺรติ นหิ กินฺตุ ย อิพฺราหีมียวิศฺวาเสน ตตฺสมฺภวาสฺตานปิ ปฺรติ สา ปฺรติชฺญา สฺถาสฺนุรฺภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","โย นิรฺชีวานฺ สชีวานฺ อวิทฺยมานานิ วสฺตูนิ จ วิทฺยมานานิ กโรติ อิพฺราหีโม วิศฺวาสภูเมสฺตเสฺยศฺวรสฺย สากฺษาตฺ โส'สฺมากํ สรฺเวฺวษามฺ อาทิปุรุษ อาเสฺต, ยถา ลิขิตํ วิทฺยเต, อหํ ตฺวำ พหุชาตีนามฺ อาทิปุรุษํ กฺฤตฺวา นิยุกฺตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ตฺวทียสฺตาทฺฤโศ วํโศ ชนิษฺยเต ยทิทํ วากฺยํ ปฺรติศฺรุตํ ตทนุสาราทฺ อิพฺราหีมฺ พหุเทศียโลกานามฺ อาทิปุรุโษ ยทฺ ภวติ ตทรฺถํ โส'นเปกฺษิตวฺยมปฺยเปกฺษมาโณ วิศฺวาสํ กฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","อปรญฺจ กฺษีณวิศฺวาโส น ภูตฺวา ศตวตฺสรวยสฺกตฺวาตฺ สฺวศรีรสฺย ชรำ สารานามฺน: สฺวภารฺยฺยายา รโชนิวฺฤตฺติญฺจ ตฺฤณาย น เมเนฯ ");
INSERT INTO santha_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","อปรมฺ อวิศฺวาสาทฺ อีศฺวรสฺย ปฺรติชฺญาวจเน กมปิ สํศยํ น จการ; ");
INSERT INTO santha_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","กินฺตฺวีศฺวเรณ ยตฺ ปฺรติศฺรุตํ ตตฺ สาธยิตุํ ศกฺยต อิติ นิศฺจิตํ วิชฺญาย ทฺฤฒวิศฺวาส: สนฺ อีศฺวรสฺย มหิมานํ ปฺรกาศยาญฺจการฯ ");
INSERT INTO santha_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","อิติ เหโตสฺตสฺย ส วิศฺวาสสฺตทียปุณฺยมิว คณยาญฺจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ปุณฺยมิวาคณฺยต ตตฺ เกวลสฺย ตสฺย นิมิตฺตํ ลิขิตํ นหิ, อสฺมากํ นิมิตฺตมปิ, ");
INSERT INTO santha_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ยโต'สฺมากํ ปาปนาศารฺถํ สมรฺปิโต'สฺมากํ ปุณฺยปฺราปฺตฺยรฺถญฺโจตฺถาปิโต'ภวตฺ โย'สฺมากํ ปฺรภุ รฺยีศุสฺตโสฺยตฺถาปยิตรีศฺวเร ");
INSERT INTO santha_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ยทิ วยํ วิศฺวสามสฺตรฺหฺยสฺมากมปิ เสอว วิศฺวาส: ปุณฺยมิว คณยิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","วิศฺวาเสน สปุณฺยีกฺฤตา วยมฺ อีศฺวเรณ สารฺทฺธํ ปฺรภุณาสฺมากํ ยีศุขฺรีษฺเฏน เมลนํ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","อปรํ วยํ ยสฺมินฺ อนุคฺรหาศฺรเย ติษฺฐามสฺตนฺมธฺยํ วิศฺวาสมารฺเคณ เตไนวานีตา วยมฺ อีศฺวรียวิภวปฺราปฺติปฺรตฺยาศยา สมานนฺทาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ตตฺ เกวลํ นหิ กินฺตุ เกฺลศโภเค'ปฺยานนฺทาโม ยต: เกฺลศาाทฺ ไธรฺยฺยํ ชายต อิติ วยํ ชานีม:, ");
INSERT INTO santha_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ไธรฺยฺยาจฺจ ปรีกฺษิตตฺวํ ชายเต, ปรีกฺษิตตฺวาตฺ ปฺรตฺยาศา ชายเต, ");
INSERT INTO santha_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ปฺรตฺยาศาโต วฺรีฑิตตฺวํ น ชายเต, ยสฺมาทฺ อสฺมภฺยํ ทตฺเตน ปวิเตฺรณาตฺมนาสฺมากมฺ อนฺต:กรณานีศฺวรสฺย เปฺรมวาริณา สิกฺตานิฯ ");
INSERT INTO santha_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","อสฺมาสุ นิรุปาเยษุ สตฺสุ ขฺรีษฺฏ อุปยุกฺเต สมเย ปาปินำ นิมิตฺตํ สฺวียานฺ ปฺรณานฺ อตฺยชตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","หิตการิโณ ชนสฺย กฺฤเต โกปิ ปฺรณานฺ ตฺยกฺตุํ สาหสํ กรฺตฺตุํ ศกฺโนติ, กินฺตุ ธารฺมฺมิกสฺย กฺฤเต ปฺราเยณ โกปิ ปฺราณานฺ น ตฺยชติฯ ");
INSERT INTO santha_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","กินฺตฺวสฺมาสุ ปาปิษุ สตฺสฺวปิ นิมิตฺตมสฺมากํ ขฺรีษฺฏ: สฺวปฺราณานฺ ตฺยกฺตวานฺ, ตต อีศฺวโรสฺมานฺ ปฺรติ นิชํ ปรมเปฺรมาณํ ทรฺศิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","อเตอว ตสฺย รกฺตปาเตน สปุณฺยีกฺฤตา วยํ นิตานฺตํ เตน โกปาทฺ อุทฺธาริษฺยามเหฯ ");
INSERT INTO santha_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ผลโต วยํ ยทา ริปว อาสฺม ตเทศฺวรสฺย ปุตฺรสฺย มรเณน เตน สารฺทฺธํ ยทฺยสฺมากํ เมลนํ ชาตํ ตรฺหิ เมลนปฺราปฺตา: สนฺโต'วศฺยํ ตสฺย ชีวเนน รกฺษำ ลปฺสฺยามเหฯ ");
INSERT INTO santha_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ตตฺ เกวลํ นหิ กินฺตุ เยน เมลนมฺ อลภามหิ เตนาสฺมากํ ปฺรภุณา ยีศุขฺรีษฺเฏน สามฺปฺรตมฺ อีศฺวเร สมานนฺทามศฺจฯ ");
INSERT INTO santha_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ตถา สติ, เอเกน มานุเษณ ปาปํ ปาเปน จ มรณํ ชคตีํ ปฺราวิศตฺ อปรํ สรฺเวฺวษำ ปาปิตฺวาตฺ สรฺเวฺว มานุษา มฺฤเต รฺนิฆฺนา อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ยโต วฺยวสฺถาทานสมยํ ยาวตฺ ชคติ ปาปมฺ อาสีตฺ กินฺตุ ยตฺร วฺยวสฺถา น วิทฺยเต ตตฺร ปาปสฺยาปิ คณนา น วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ตถาปฺยาทมา ยาทฺฤศํ ปาปํ กฺฤตํ ตาทฺฤศํ ปาปํ ไย รฺนาการิ อาทมมฺ อารภฺย มูสำ ยาวตฺ เตษามปฺยุปริ มฺฤตฺยู ราชตฺวมฺ อกโรตฺ ส อาทมฺ ภาวฺยาทโม นิทรฺศนเมวาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","กินฺตุ ปาปกรฺมฺมโณ ยาทฺฤโศ ภาวสฺตาทฺฤคฺ ทานกรฺมฺมโณ ภาโว น ภวติ ยต เอกสฺย ชนสฺยาปราเธน ยทิ พหูนำ มรณมฺ อฆฏต ตถาปีศฺวรานุคฺรหสฺตทนุคฺรหมูลกํ ทานญฺไจเกน ชเนนารฺถาทฺ ยีศุนา ขฺรีษฺเฏน พหุษุ พาหุลฺยาติพาหุเลฺยน ผลติฯ ");
INSERT INTO santha_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","อปรมฺ เอกสฺย ชนสฺย ปาปกรฺมฺม ยาทฺฤกฺ ผลยุกฺตํ ทานกรฺมฺม ตาทฺฤกฺ น ภวติ ยโต วิจารกรฺมฺไมกํ ปาปมฺ อารภฺย ทณฺฑชนกํ พภูว, กินฺตุ ทานกรฺมฺม พหุปาปานฺยารภฺย ปุณฺยชนกํ พภูวฯ ");
INSERT INTO santha_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ยต เอกสฺย ชนสฺย ปาปกรฺมฺมตเสฺตไนเกน ยทิ มรณสฺย ราชตฺวํ ชาตํ ตรฺหิ เย ชนา อนุคฺรหสฺย พาหุลฺยํ ปุณฺยทานญฺจ ปฺราปฺนุวนฺติ ต เอเกน ชเนน, อรฺถาตฺ ยีศุขฺรีษฺเฏน, ชีวเน ราชตฺวมฺ อวศฺยํ กริษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","เอโก'ปราโธ ยทฺวตฺ สรฺวฺวมานวานำ ทณฺฑคามี มารฺโค 'ภวตฺ ตทฺวทฺ เอกํ ปุณฺยทานํ สรฺวฺวมานวานำ ชีวนยุกฺตปุณฺยคามี มารฺค เอวฯ ");
INSERT INTO santha_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","อปรมฺ เอกสฺย ชนสฺยาชฺญาลงฺฆนาทฺ ยถา พหโว 'ปราธิโน ชาตาสฺตทฺวทฺ เอกสฺยาชฺญาจรณาทฺ พหว: สปุณฺยีกฺฤตา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","อธิกนฺตุ วฺยวสฺถาคมนาทฺ อปราธสฺย พาหุลฺยํ ชาตํ กินฺตุ ยตฺร ปาปสฺย พาหุลฺยํ ตไตฺรว ตสฺมาทฺ อนุคฺรหสฺย พาหุลฺยมฺ อภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","เตน มฺฤตฺยุนา ยทฺวตฺ ปาปสฺย ราชตฺวมฺ อภวตฺ ตทฺวทฺ อสฺมากํ ปฺรภุยีศุขฺรีษฺฏทฺวารานนฺตชีวนทายิปุเณฺยนานุคฺรหสฺย ราชตฺวํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ปฺรภูตรูเปณ ยทฺ อนุคฺรห: ปฺรกาศเต ตทรฺถํ ปาเป ติษฺฐาม อิติ วากฺยํ กึ วยํ วทิษฺยาม:? ตนฺน ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ปาปํ ปฺรติ มฺฤตา วยํ ปุนสฺตสฺมินฺ กถมฺ ชีวิษฺยาม:? ");
INSERT INTO santha_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","วยํ ยาวนฺโต โลกา ยีศุขฺรีษฺเฏ มชฺชิตา อภวาม ตาวนฺต เอว ตสฺย มรเณ มชฺชิตา อิติ กึ ยูยํ น ชานีถ? ");
INSERT INTO santha_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ตโต ยถา ปิตุ: ปรากฺรเมณ ศฺมศานาตฺ ขฺรีษฺฏ อุตฺถาปิตสฺตถา วยมปิ ยตฺ นูตนชีวิน อิวาจรามสฺตทรฺถํ มชฺชเนน เตน สารฺทฺธํ มฺฤตฺยุรูเป ศฺมศาเน สํสฺถาปิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","อปรํ วยํ ยทิ เตน สํยุกฺตา: สนฺต: ส อิว มรณภาคิโน ชาตาสฺตรฺหิ ส อิโวตฺถานภาคิโน'ปิ ภวิษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","วยํ ยตฺ ปาปสฺย ทาสา: ปุน รฺน ภวามสฺตทรฺถมฺ อสฺมากํ ปาปรูปศรีรสฺย วินาศารฺถมฺ อสฺมากํ ปุราตนปุรุษเสฺตน สากํ กฺรุเศ'หนฺยเตติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","โย หต: ส ปาปาตฺ มุกฺต เอวฯ ");
INSERT INTO santha_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","อเตอว ยทิ วยํ ขฺรีษฺเฏน สารฺทฺธมฺ อหนฺยามหิ ตรฺหิ ปุนรปิ เตน สหิตา ชีวิษฺยาม อิตฺยตฺราสฺมากํ วิศฺวาโส วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ยต: ศฺมศานาทฺ อุตฺถาปิต: ขฺรีษฺโฏ ปุน รฺน มฺริยต อิติ วยํ ชานีม:ฯ ตสฺมินฺ โกปฺยธิกาโร มฺฤโตฺย รฺนาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","อปรญฺจ ส ยทฺ อมฺริยต เตไนกทา ปาปมฺ อุทฺทิศฺยามฺริยต, ยจฺจ ชีวติ เตเนศฺวรมฺ อุทฺทิศฺย ชีวติ; ");
INSERT INTO santha_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ตทฺวทฺ ยูยมปิ สฺวานฺ ปาปมฺ อุทฺทิศฺย มฺฤตานฺ อสฺมากํ ปฺรภุณา ยีศุขฺรีษฺเฏเนศฺวรมฺ อุทฺทิศฺย ชีวนฺโต ชานีตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","อปรญฺจ กุตฺสิตาภิลาษาाนฺ ปูรยิตุํ ยุษฺมากํ มรฺตฺยเทเหษุ ปาปมฺ อาธิปตฺยํ น กโรตุฯ ");
INSERT INTO santha_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","อปรํ สฺวํ สฺวมฺ องฺคมฺ อธรฺมฺมสฺยาสฺตฺรํ กฺฤตฺวา ปาปเสวายำ น สมรฺปยต, กินฺตุ ศฺมศานาทฺ อุตฺถิตานิว สฺวานฺ อีศฺวเร สมรฺปยต สฺวานฺยงฺคานิ จ ธรฺมฺมาสฺตฺรสฺวรูปาณีศฺวรมฺ อุทฺทิศฺย สมรฺปยตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ยุษฺมากมฺ อุปริ ปาปสฺยาธิปตฺยํ ปุน รฺน ภวิษฺยติ, ยสฺมาทฺ ยูยํ วฺยวสฺถายา อนายตฺตา อนุคฺรหสฺย จายตฺตา อภวตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","กินฺตุ วยํ วฺยวสฺถายา อนายตฺตา อนุคฺรหสฺย จายตฺตา อภวาม, อิติ การณาตฺ กึ ปาปํ กริษฺยาม:? ตนฺน ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ยโต มฺฤติชนกํ ปาปํ ปุณฺยชนกํ นิเทศาจรณญฺไจตโยรฺทฺวโย รฺยสฺมินฺ อาชฺญาปาลนารฺถํ ภฺฤตฺยานิว สฺวานฺ สมรฺปยถ, ตไสฺยว ภฺฤตฺยา ภวถ, เอตตฺ กึ ยูยํ น ชานีถ? ");
INSERT INTO santha_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","อปรญฺจ ปูรฺวฺวํ ยูยํ ปาปสฺย ภฺฤตฺยา อาเสฺตติ สตฺยํ กินฺตุ ยสฺยำ ศิกฺษารูปายำ มูษายำ นิกฺษิปฺตา อภวต ตสฺยา อากฺฤตึ มโนภิ รฺลพฺธวนฺต อิติ การณาทฺ อีศฺวรสฺย ธนฺยวาโท ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","อิตฺถํ ยูยํ ปาปเสวาโต มุกฺตา: สนฺโต ธรฺมฺมสฺย ภฺฤตฺยา ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ยุษฺมากํ ศารีริกฺยา ทุรฺพฺพลตายา เหโต รฺมานววทฺ อหมฺ เอตทฺ พฺรวีมิ; ปุน: ปุนรธรฺมฺมกรณารฺถํ ยทฺวตฺ ปูรฺวฺวํ ปาปาเมธฺยโย รฺภฺฤตฺยเตฺว นิชางฺคานิ สมารฺปยต ตทฺวทฺ อิทานีํ สาธุกรฺมฺมกรณารฺถํ ธรฺมฺมสฺย ภฺฤตฺยเตฺว นิชางฺคานิ สมรฺปยตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ยทา ยูยํ ปาปสฺย ภฺฤตฺยา อาสฺต ตทา ธรฺมฺมสฺย นายตฺตา อาสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ตรฺหิ ยานิ กรฺมฺมาณิ ยูยมฺ อิทานีํ ลชฺชาชนกานิ พุธฺยเธฺว ปูรฺวฺวํ ไต รฺยุษฺมากํ โก ลาภ อาสีตฺ? เตษำ กรฺมฺมณำ ผลํ มรณเมวฯ ");
INSERT INTO santha_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","กินฺตุ สามฺปฺรตํ ยูยํ ปาปเสวาโต มุกฺตา: สนฺต อีศฺวรสฺย ภฺฤตฺยา'ภวต ตสฺมาทฺ ยุษฺมากํ ปวิตฺรตฺวรูปํ ลภฺยมฺ อนนฺตชีวนรูปญฺจ ผลมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ยต: ปาปสฺย เวตนํ มรณํ กินฺตฺวสฺมากํ ปฺรภุณา ยีศุขฺรีษฺเฏนานนฺตชีวนมฺ อีศฺวรทตฺตํ ปาริโตษิกมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","เห ภฺราตฺฤคณ วฺยวสฺถาวิท: ปฺรติ มเมทํ นิเวทนํฯ วิธิ: เกวลํ ยาวชฺชีวํ มานโวปรฺยฺยธิปติตฺวํ กโรตีติ ยูยํ กึ น ชานีถ? ");
INSERT INTO santha_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ยาวตฺกาลํ ปติ รฺชีวติ ตาวตฺกาลมฺ อูฒา ภารฺยฺยา วฺยวสฺถยา ตสฺมินฺ พทฺธา ติษฺฐติ กินฺตุ ยทิ ปติ รฺมฺริยเต ตรฺหิ สา นารี ปตฺยุ รฺวฺยวสฺถาโต มุจฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","เอตตฺการณาตฺ ปตฺยุรฺชีวนกาเล นารี ยทฺยนฺยํ ปุรุษํ วิวหติ ตรฺหิ สา วฺยภิจาริณี ภวติ กินฺตุ ยทิ ส ปติ รฺมฺริยเต ตรฺหิ สา ตสฺยา วฺยวสฺถายา มุกฺตา สตี ปุรุษานฺตเรณ วฺยูฒาปิ วฺยภิจาริณี น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","เห มม ภฺราตฺฤคณ, อีศฺวรนิมิตฺตํ ยทสฺมากํ ผลํ ชายเต ตทรฺถํ ศฺมศานาทฺ อุตฺถาปิเตน ปุรุเษณ สห ยุษฺมากํ วิวาโห ยทฺ ภเวตฺ ตทรฺถํ ขฺรีษฺฏสฺย ศรีเรณ ยูยํ วฺยวสฺถำ ปฺรติ มฺฤตวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ยโต'สฺมากํ ศารีริกาจรณสมเย มรณนิมิตฺตํ ผลมฺ อุตฺปาทยิตุํ วฺยวสฺถยา ทูษิต: ปาปาภิลาโษ'สฺมากมฺ องฺเคษุ ชีวนฺ อาสีตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","กินฺตุ ตทา ยสฺยา วฺยวสฺถายา วเศ อาสฺมหิ สามฺปฺรตํ ตำ ปฺรติ มฺฤตตฺวาทฺ วยํ ตสฺยา อธีนตฺวาตฺ มุกฺตา อิติ เหโตรีศฺวโร'สฺมาภิ: ปุราตนลิขิตานุสาราตฺ น เสวิตวฺย: กินฺตุ นวีนสฺวภาเวไนว เสวิตวฺย: ");
INSERT INTO santha_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ตรฺหิ วยํ กึ พฺรูม:? วฺยวสฺถา กึ ปาปชนิกา ภวติ? เนตฺถํ ภวตุฯ วฺยวสฺถามฺ อวิทฺยมานายำ ปาปํ กิมฺ อิตฺยหํ นาเวทํ; กิญฺจ โลภํ มา การฺษีริติ เจทฺ วฺยวสฺถาคฺรนฺเถ ลิขิตํ นาภวิษฺยตฺ ตรฺหิ โลภ: กิมฺภูตสฺตทหํ นาชฺญาสฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","กินฺตุ วฺยวสฺถยา ปาปํ ฉิทฺรํ ปฺราปฺยาสฺมากมฺ อนฺต: สรฺวฺววิธํ กุตฺสิตาภิลาษมฺ อชนยตฺ; ยโต วฺยวสฺถายามฺ อวิทฺยมานายำ ปาปํ มฺฤตํฯ ");
INSERT INTO santha_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","อปรํ ปูรฺวฺวํ วฺยวสฺถายามฺ อวิทฺยมานายามฺ อหมฺ อชีวํ ตต: ปรมฺ อาชฺญายามฺ อุปสฺถิตายามฺ ปาปมฺ อชีวตฺ ตทาหมฺ อมฺริเยฯ ");
INSERT INTO santha_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","อิตฺถํ สติ ชีวนนิมิตฺตา ยาชฺญา สา มม มฺฤตฺยุชนิกาภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ยต: ปาปํ ฉิทฺรํ ปฺราปฺย วฺยวสฺถิตาเทเศน มำ วญฺจยิตฺวา เตน มามฺ อหนฺฯ ");
INSERT INTO santha_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","อเตอว วฺยวสฺถา ปวิตฺรา, อาเทศศฺจ ปวิโตฺร นฺยาโยฺย หิตการี จ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ตรฺหิ ยตฺ สฺวยํ หิตกฺฤตฺ ตตฺ กึ มม มฺฤตฺยุชนกมฺ อภวตฺ? เนตฺถํ ภวตุ; กินฺตุ ปาปํ ยตฺ ปาตกมิว ปฺรกาศเต ตถา นิเทเศน ปาปํ ยทตีว ปาตกมิว ปฺรกาศเต ตทรฺถํ หิโตปาเยน มม มรณมฺ อชนยตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","วฺยวสฺถาตฺมโพธิเกติ วยํ ชานีม: กินฺตฺวหํ ศารีรตาจารี ปาปสฺย กฺรีตกิงฺกโร วิเทฺยฯ ");
INSERT INTO santha_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ยโต ยตฺ กรฺมฺม กโรมิ ตตฺ มม มโน'ภิมตํ นหิ; อปรํ ยนฺ มม มโน'ภิมตํ ตนฺน กโรมิ กินฺตุ ยทฺ ฤตีเย ตตฺ กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ตถาเตฺว ยนฺ มมานภิมตํ ตทฺ ยทิ กโรมิ ตรฺหิ วฺยวสฺถา สูตฺตเมติ สฺวีกโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","อเตอว สมฺปฺรติ ตตฺ กรฺมฺม มยา กฺริยต อิติ นหิ กินฺตุ มม ศรีรเสฺถน ปาเปไนว กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ยโต มยิ, อรฺถโต มม ศรีเร, กิมปฺยุตฺตมํ น วสติ, เอตทฺ อหํ ชานามิ; มเมจฺฉุกตายำ ติษฺฐนฺตฺยามปฺยหมฺ อุตฺตมกรฺมฺมสาธเน สมรฺโถ น ภวามิฯ ");
INSERT INTO santha_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ยโต ยามุตฺตมำ กฺริยำ กรฺตฺตุมหํ วาญฺฉามิ ตำ น กโรมิ กินฺตุ ยตฺ กุตฺสิตํ กรฺมฺม กรฺตฺตุมฺ อนิจฺฉุโก'สฺมิ ตเทว กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","อเตอว ยทฺยตฺ กรฺมฺม กรฺตฺตุํ มเมจฺฉา น ภวติ ตทฺ ยทิ กโรมิ ตรฺหิ ตตฺ มยา น กฺริยเต, มมานฺตรฺวรฺตฺตินา ปาเปไนว กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ภทฺรํ กรฺตฺตุมฺ อิจฺฉุกํ มำ โย 'ภทฺรํ กรฺตฺตุํ ปฺรวรฺตฺตยติ ตาทฺฤศํ สฺวภาวเมกํ มยิ ปศฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","อหมฺ อานฺตริกปุรุเษเณศฺวรวฺยวสฺถายำ สนฺตุษฺฏ อาเส; ");
INSERT INTO santha_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","กินฺตุ ตทฺวิปรีตํ ยุธฺยนฺตํ ตทนฺยเมกํ สฺวภาวํ มทียางฺคสฺถิตํ ปฺรปศฺยามิ, ส มทียางฺคสฺถิตปาปสฺวภาวสฺยายตฺตํ มำ กรฺตฺตุํ เจษฺฏเตฯ ");
INSERT INTO santha_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","หา หา โย'หํ ทุรฺภาโคฺย มนุชสฺตํ มามฺ เอตสฺมานฺ มฺฤตาจฺฉรีราตฺ โก นิสฺตารยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","อสฺมากํ ปฺรภุณา ยีศุขฺรีษฺเฏน นิสฺตารยิตารมฺ อีศฺวรํ ธนฺยํ วทามิฯ อเตอว ศรีเรณ ปาปวฺยวสฺถายา มนสา ตุ อีศฺวรวฺยวสฺถายา: เสวนํ กโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","เย ชนา: ขฺรีษฺฏํ ยีศุมฺ อาศฺริตฺย ศารีริกํ นาจรนฺต อาตฺมิกมาจรนฺติ เต'ธุนา ทณฺฑารฺหา น ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ชีวนทายกสฺยาตฺมโน วฺยวสฺถา ขฺรีษฺฏยีศุนา ปาปมรณโย รฺวฺยวสฺถาโต มามโมจยตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ยสฺมาจฺฉารีรสฺย ทุรฺพฺพลตฺวาทฺ วฺยวสฺถยา ยตฺ กรฺมฺมาสาธฺยมฺ อีศฺวโร นิชปุตฺรํ ปาปิศรีรรูปํ ปาปนาศกพลิรูปญฺจ เปฺรษฺย ตสฺย ศรีเร ปาปสฺย ทณฺฑํ กุรฺวฺวนฺ ตตฺกรฺมฺม สาธิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ตต: ศารีริกํ นาจริตฺวาสฺมาภิราตฺมิกมฺ อาจรทฺภิรฺวฺยวสฺถาคฺรนฺเถ นิรฺทฺทิษฺฏานิ ปุณฺยกรฺมฺมาณิ สรฺวฺวาณิ สาธฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","เย ศารีริกาจาริณเสฺต ศารีริกานฺ วิษยานฺ ภาวยนฺติ เย จาตฺมิกาจาริณเสฺต อาตฺมโน วิษยานฺ ภาวยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ศารีริกภาวสฺย ผลํ มฺฤตฺยุ: กิญฺจาตฺมิกภาวสฺย ผเล ชีวนํ ศานฺติศฺจฯ ");
INSERT INTO santha_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ยต: ศารีริกภาว อีศฺวรสฺย วิรุทฺธ: ศตฺรุตาภาว เอว ส อีศฺวรสฺย วฺยวสฺถายา อธีโน น ภวติ ภวิตุญฺจ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","เอตสฺมาตฺ ศารีริกาจาริษุ โตษฺฏุมฺ อีศฺวเรณ น ศกฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","กินฺตฺวีศฺวรสฺยาตฺมา ยทิ ยุษฺมากํ มเธฺย วสติ ตรฺหิ ยูยํ ศารีริกาจาริโณ น สนฺต อาตฺมิกาจาริโณ ภวถ:ฯ ยสฺมินฺ ตุ ขฺรีษฺฏสฺยาตฺมา น วิทฺยเต ส ตตฺสมฺภโว นหิฯ ");
INSERT INTO santha_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ยทิ ขฺรีษฺโฏ ยุษฺมานฺ อธิติษฺฐติ ตรฺหิ ปาปมฺ อุทฺทิศฺย ศรีรํ มฺฤตํ กินฺตุ ปุณฺยมุทฺทิศฺยาตฺมา ชีวติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","มฺฤตคณาทฺ ยีศุ เรฺยโนตฺถาปิตสฺตสฺยาตฺมา ยทิ ยุษฺมนฺมเธฺย วสติ ตรฺหิ มฺฤตคณาตฺ ขฺรีษฺฏสฺย ส อุตฺถาปยิตา ยุษฺมนฺมธฺยวาสินา สฺวกียาตฺมนา ยุษฺมากํ มฺฤตเทหานปิ ปุน รฺชีวยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","เห ภฺราตฺฤคณ ศรีรสฺย วยมธมรฺณา น ภวาโม'ต: ศารีริกาจาโร'สฺมาภิ รฺน กรฺตฺตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ยทิ ยูยํ ศรีริกาจาริโณ ภเวต ตรฺหิ ยุษฺมาภิ รฺมรฺตฺตวฺยเมว กินฺตฺวาตฺมนา ยทิ ศรีรกรฺมฺมาณิ ฆาตเยต ตรฺหิ ชีวิษฺยถฯ ");
INSERT INTO santha_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ยโต ยาวนฺโต โลกา อีศฺวรสฺยาตฺมนากฺฤษฺยนฺเต เต สรฺวฺว อีศฺวรสฺย สนฺตานา ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ยูยํ ปุนรปิ ภยชนกํ ทาสฺยภาวํ น ปฺราปฺตา: กินฺตุ เยน ภาเวเนศฺวรํ ปิต: ปิตริติ โปฺรจฺย สมฺโพธยถ ตาทฺฤศํ ทตฺตกปุตฺรตฺวภาวมฺ ปฺราปฺนุตฯ ");
INSERT INTO santha_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","อปรญฺจ วยมฺ อีศฺวรสฺย สนฺตานา เอตสฺมินฺ ปวิตฺร อาตฺมา สฺวยมฺ อสฺมากมฺ อาตฺมาภิ: สารฺทฺธํ ปฺรมาณํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","อเตอว วยํ ยทิ สนฺตานาสฺตรฺหฺยธิการิณ:, อรฺถาทฺ อีศฺวรสฺย สฺวตฺตฺวาธิการิณ: ขฺรีษฺเฏน สหาธิการิณศฺจ ภวาม:; อปรํ เตน สารฺทฺธํ ยทิ ทุ:ขภาคิโน ภวามสฺตรฺหิ ตสฺย วิภวสฺยาปิ ภาคิโน ภวิษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","กินฺตฺวสฺมาสุ โย ภาวีวิภว: ปฺรกาศิษฺยเต ตสฺย สมีเป วรฺตฺตมานกาลีนํ ทุ:ขมหํ ตฺฤณาย มเนฺยฯ ");
INSERT INTO santha_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ยต: ปฺราณิคณ อีศฺวรสฺย สนฺตานานำ วิภวปฺราปฺติมฺ อากางฺกฺษนฺ นิตานฺตมฺ อเปกฺษเตฯ ");
INSERT INTO santha_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","อปรญฺจ ปฺราณิคณ: ไสฺวรมฺ อลีกตายา วศีกฺฤโต นาภวตฺ ");
INSERT INTO santha_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","กินฺตุ ปฺราณิคโณ'ปิ นศฺวรตาธีนตฺวาตฺ มุกฺต: สนฺ อีศฺวรสฺย สนฺตานานำ ปรมมุกฺตึ ปฺราปฺสฺยตีตฺยภิปฺราเยณ วศีกรฺตฺรา วศีจเกฺรฯ ");
INSERT INTO santha_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","อปรญฺจ ปฺรสูยมานาวทฺ วฺยถิต: สนฺ อิทานีํ ยาวตฺ กฺฤตฺสฺน: ปฺราณิคณ อารฺตฺตสฺวรํ กโรตีติ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","เกวล: ส อิติ นหิ กินฺตุ ปฺรถมชาตผลสฺวรูปมฺ อาตฺมานํ ปฺราปฺตา วยมปิ ทตฺตกปุตฺรตฺวปทปฺราปฺติมฺ อรฺถาตฺ ศรีรสฺย มุกฺตึ ปฺรตีกฺษมาณาสฺตทฺวทฺ อนฺตรารฺตฺตราวํ กุรฺมฺม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","วยํ ปฺรตฺยาศยา ตฺราณมฺ อลภามหิ กินฺตุ ปฺรตฺยกฺษวสฺตุโน ยา ปฺรตฺยาศา สา ปฺรตฺยาศา นหิ, ยโต มนุโษฺย ยตฺ สมีกฺษเต ตสฺย ปฺรตฺยาศำ กุต: กริษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ยทฺ อปฺรตฺยกฺษํ ตสฺย ปฺรตฺยาศำ ยทิ วยํ กุรฺวฺวีมหิ ตรฺหิ ไธรฺยฺยมฺ อวลมฺพฺย ปฺรตีกฺษามเหฯ ");
INSERT INTO santha_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ตต อาตฺมาปิ สฺวยมฺ อสฺมากํ ทุรฺพฺพลตายา: สหายตฺวํ กโรติ; ยต: กึ ปฺรารฺถิตวฺยํ ตทฺ โพทฺธุํ วยํ น ศกฺนุม:, กินฺตฺวสฺปษฺไฏรารฺตฺตราไวราตฺมา สฺวยมฺ อสฺมนฺนิมิตฺตํ นิเวทยติฯ ");
INSERT INTO santha_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","อปรมฺ อีศฺวราภิมตรูเปณ ปวิตฺรโลกานำ กฺฤเต นิเวทยติ ย อาตฺมา ตสฺยาภิปฺราโย'นฺตรฺยฺยามินา ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","อปรมฺ อีศฺวรียนิรูปณานุสาเรณาหูตา: สนฺโต เย ตสฺมินฺ ปฺรียนฺเต สรฺวฺวาณิ มิลิตฺวา เตษำ มงฺคลํ สาธยนฺติ, เอตทฺ วยํ ชานีม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ยต อีศฺวโร พหุภฺราตฺฤณำ มเธฺย สฺวปุตฺรํ เชฺยษฺฐํ กรฺตฺตุมฺ อิจฺฉนฺ ยานฺ ปูรฺวฺวํ ลกฺษฺยีกฺฤตวานฺ ตานฺ ตสฺย ปฺรติมูรฺตฺยา: สาทฺฤศฺยปฺราปฺตฺยรฺถํ นฺยยุํกฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","อปรญฺจ เตน เย นิยุกฺตาสฺต อาหูตา อปิ เย จ เตนาหูตาเสฺต สปุณฺยีกฺฤตา:, เย จ เตน สปุณฺยีกฺฤตาเสฺต วิภวยุกฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","อิตฺยตฺร วยํ กึ พฺรูม:? อีศฺวโร ยทฺยสฺมากํ สปกฺโษ ภวติ ตรฺหิ โก วิปกฺโษ'สฺมากํ? ");
INSERT INTO santha_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","อาตฺมปุตฺรํ น รกฺษิตฺวา โย'สฺมากํ สรฺเวฺวษำ กฺฤเต ตํ ปฺรทตฺตวานฺ ส กึ เตน สหาสฺมภฺยมฺ อนฺยานิ สรฺวฺวาณิ น ทาสฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","อีศฺวรสฺยาภิรุจิเตษุ เกน โทษ อาโรปยิษฺยเต? ย อีศฺวรสฺตานฺ ปุณฺยวต อิว คณยติ กึ เตน? ");
INSERT INTO santha_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","อปรํ เตโภฺย ทณฺฑทานาชฺญา วา เกน กริษฺยเต? โย'สฺมนฺนิมิตฺตํ ปฺราณานฺ ตฺยกฺตวานฺ เกวลํ ตนฺน กินฺตุ มฺฤตคณมธฺยาทฺ อุตฺถิตวานฺ, อปิ เจศฺวรสฺย ทกฺษิเณ ปารฺเศฺว ติษฺฐนฺ อทฺยาปฺยสฺมากํ นิมิตฺตํ ปฺรารฺถต เอวมฺภูโต ย: ขฺรีษฺฏ: กึ เตน? ");
INSERT INTO santha_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","อสฺมาภิ: สห ขฺรีษฺฏสฺย เปฺรมวิจฺเฉทํ ชนยิตุํ ก: ศกฺโนติ? เกฺลโศ วฺยสนํ วา ตาฑนา วา ทุรฺภิกฺษํ วา วสฺตฺรหีนตฺวํ วา ปฺราณสํศโย วา ขงฺโค วา กิเมตานิ ศกฺนุวนฺติ? ");
INSERT INTO santha_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","กินฺตุ ลิขิตมฺ อาเสฺต, ยถา, วยํ ตว นิมิตฺตํ โสฺม มฺฤตฺยุวกฺเตฺร'ขิลํ ทินํฯ พลิรฺเทโย ยถา เมโษ วยํ คณฺยามเห ตถาฯ ");
INSERT INTO santha_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","อปรํ โย'สฺมาสุ ปฺรียเต เตไนตาสุ วิปตฺสุ วยํ สมฺยคฺ วิชยามเหฯ ");
INSERT INTO santha_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ยโต'สฺมากํ ปฺรภุนา ยีศุขฺรีษฺเฏเนศฺวรสฺย ยตฺ เปฺรม ตสฺมาทฺ อสฺมากํ วิจฺเฉทํ ชนยิตุํ มฺฤตฺยุ รฺชีวนํ วา ทิวฺยทูตา วา พลวนฺโต มุขฺยทูตา วา วรฺตฺตมาโน วา ภวิษฺยนฺ กาโล วา อุจฺจปทํ วา นีจปทํ วาปรํ กิมปิ สฺฤษฺฏวสฺตุ ");
INSERT INTO santha_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ไวเตษำ เกนาปิ น ศกฺยมิตฺยสฺมินฺ ทฺฤฒวิศฺวาโส มมาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","อหํ กาญฺจิทฺ กลฺปิตำ กถำ น กถยามิ, ขฺรีษฺฏสฺย สากฺษาตฺ สตฺยเมว พฺรวีมิ ปวิตฺรสฺยาตฺมน: สากฺษานฺ มทียํ มน เอตตฺ สากฺษฺยํ ททาติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","มมานฺตรติศยทุ:ขํ นิรนฺตรํ เขทศฺจ ");
INSERT INTO santha_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ตสฺมาทฺ อหํ สฺวชาตียภฺราตฺฤณำ นิมิตฺตาตฺ สฺวยํ ขฺรีษฺฏาจฺฉาปากฺรานฺโต ภวิตุมฺ ไอจฺฉมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ยตสฺต อิสฺราเยลสฺย วํศา อปิ จ ทตฺตกปุตฺรตฺวํ เตโช นิยโม วฺยวสฺถาทานํ มนฺทิเร ภชนํ ปฺรติชฺญา: ปิตฺฤปุรุษคณศฺไจเตษุ สรฺเวฺวษุ เตษามฺ อธิกาโร'สฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ตตฺ เกวลํ นหิ กินฺตุ สรฺวฺวาธฺยกฺษ: สรฺวฺวทา สจฺจิทานนฺท อีศฺวโร ย: ขฺรีษฺฏ: โส'ปิ ศารีริกสมฺพนฺเธน เตษำ วํศสมฺภว:ฯ ");
INSERT INTO santha_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","อีศฺวรสฺย วากฺยํ วิผลํ ชาตมฺ อิติ นหิ ยตฺการณาทฺ อิสฺราเยโล วํเศ เย ชาตาเสฺต สรฺเวฺว วสฺตุต อิสฺราเยลียา น ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","อปรมฺ อิพฺราหีโม วํเศ ชาตา อปิ สรฺเวฺว ตไสฺยว สนฺตานา น ภวนฺติ กินฺตุ อิสฺหาโก นามฺนา ตว วํโศ วิขฺยาโต ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","อรฺถาตฺ ศารีริกสํสรฺคาตฺ ชาตา: สนฺตานา ยาวนฺตสฺตาวนฺต เอเวศฺวรสฺย สนฺตานา น ภวนฺติ กินฺตุ ปฺรติศฺรวณาทฺ เย ชายนฺเต เตอเวศฺวรวํโศ คณฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ยตสฺตตฺปฺรติศฺรุเต รฺวากฺยเมตตฺ, เอตาทฺฤเศ สมเย 'หํ ปุนราคมิษฺยามิ ตตฺปูรฺวฺวํ สารายา: ปุตฺร เอโก ชนิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","อปรมปิ วทามิ สฺวมโน'ภิลาษต อีศฺวเรณ ยนฺนิรูปิตํ ตตฺ กรฺมฺมโต นหิ กินฺตฺวาหฺวยิตุ รฺชาตเมตทฺ ยถา สิทฺธฺยติ ");
INSERT INTO santha_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ตทรฺถํ ริพฺกานามิกยา โยษิตา ชไนกสฺมาทฺ อรฺถาทฺ อสฺมากมฺ อิสฺหาก: ปูรฺวฺวปุรุษาทฺ ครฺเภ ธฺฤเต ตสฺยา: สนฺตานโย: ปฺรสวาตฺ ปูรฺวฺวํ กิญฺจ ตโย: ศุภาศุภกรฺมฺมณ: กรณาตฺ ปูรฺวฺวํ ");
INSERT INTO santha_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ตำ ปฺรตีทํ วากฺยมฺ อุกฺตํ, เชฺยษฺฐ: กนิษฺฐํ เสวิษฺยเต, ");
INSERT INTO santha_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ยถา ลิขิตมฺ อาเสฺต, ตถาเปฺยษาวิ น ปฺรีตฺวา ยากูพิ ปฺรีตวานฺ อหํฯ ");
INSERT INTO santha_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ตรฺหิ วยํ กึ พฺรูม:? อีศฺวร: กิมฺ อนฺยายการี? ตถา น ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ยต: ส สฺวยํ มูสามฺ อวทตฺ; อหํ ยสฺมินฺ อนุคฺรหํ จิกีรฺษามิ ตเมวานุคฺฤหฺลามิ, ยญฺจ ทยิตุมฺ อิจฺฉามิ ตเมว ทเยฯ ");
INSERT INTO santha_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","อเตอเวจฺฉตา ยตมาเนน วา มานเวน ตนฺน สาธฺยเต ทยาการิเณศฺวเรไณว สาธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ผิเราณิ ศาสฺเตฺร ลิขติ, อหํ ตฺวทฺทฺวารา มตฺปรากฺรมํ ทรฺศยิตุํ สรฺวฺวปฺฤถิวฺยำ นิชนาม ปฺรกาศยิตุญฺจ ตฺวำ สฺถาปิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","อต: ส ยมฺ อนุคฺรหีตุมฺ อิจฺฉติ ตเมวานุคฺฤหฺลาติ, ยญฺจ นิคฺรหีตุมฺ อิจฺฉติ ตํ นิคฺฤหฺลาติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ยทิ วทสิ ตรฺหิ ส โทษํ กุโต คฺฤหฺลาติ? ตทีเยจฺฉายา: ปฺรติพนฺธกตฺวํ กรฺตฺตํ กสฺย สามรฺถฺยํ วิทฺยเต? ");
INSERT INTO santha_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","เห อีศฺวรสฺย ปฺรติปกฺษ มรฺตฺย ตฺวํ ก:? เอตาทฺฤศํ มำ กุต: สฺฤษฺฏวานฺ? อิติ กถำ สฺฤษฺฏวสฺตุ สฺรษฺเฏฺร กึ กถยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","เอกสฺมานฺ มฺฤตฺปิณฺฑาทฺ อุตฺกฺฤษฺฏาปกฺฤษฺเฏา ทฺวิวิเธา กลเศา กรฺตฺตุํ กึ กุลาลสฺย สามรฺถฺยํ นาสฺติ? ");
INSERT INTO santha_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","อีศฺวร: โกปํ ปฺรกาศยิตุํ นิชศกฺตึ ชฺญาปยิตุญฺเจจฺฉนฺ ยทิ วินาศสฺย โยคฺยานิ โกฺรธภาชนานิ ปฺรติ พหุกาลํ ทีรฺฆสหิษฺณุตามฺ อาศฺรยติ; ");
INSERT INTO santha_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","อปรญฺจ วิภวปฺราปฺตฺยรฺถํ ปูรฺวฺวํ นิยุกฺตานฺยนุคฺรหปาตฺราณิ ปฺรติ นิชวิภวสฺย พาหุลฺยํ ปฺรกาศยิตุํ เกวลยิหูทินำ นหิ ภินฺนเทศินามปิ มธฺยาทฺ ");
INSERT INTO santha_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","อสฺมานิว ตานฺยาหฺวยติ ตตฺร ตว กึ? ");
INSERT INTO santha_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","โหเศยคฺรนฺเถ ยถา ลิขิตมฺ อาเสฺต, โย โลโก มม นาสีตฺ ตํ วทิษฺยามิ มทียกํฯ ยา ชาติ เรฺม'ปฺริยา จาสีตฺ ตำ วทิษฺยามฺยหํ ปฺริยำฯ ");
INSERT INTO santha_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ยูยํ มทียโลกา น ยเตฺรติ วากฺยเมาจฺยตฯ อมเรศสฺย สนฺตานา อิติ ขฺยาสฺยนฺติ ตตฺร เตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","อิสฺราเยลียโลเกษุ ยิศายิโย'ปิ วาจเมตำ ปฺราจารยตฺ, อิสฺราเยลียวํศานำ ยา สํขฺยา สา ตุ นิศฺจิตํฯ สมุทฺรสิกตาสํขฺยาสมานา ยทิ ชายเตฯ ตถาปิ เกวลํ โลไกรลฺไปสฺตฺราณํ วฺรชิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ยโต นฺยาเยน สฺวํ กรฺมฺม ปเรศ: สาธยิษฺยติฯ เทเศ เสอว สํกฺเษปานฺนิชํ กรฺมฺม กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ยิศายิโย'ปรมปิ กถยามาส, ไสนฺยาธฺยกฺษปเรเศน เจตฺ กิญฺจินฺโนทศิษฺยตฯ ตทา วยํ สิโทเมวาภวิษฺยาม วินิศฺจิตํฯ ยทฺวา วยมฺ อโมรายา อคมิษฺยาม ตุลฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ตรฺหิ วยํ กึ วกฺษฺยาม:? อิตรเทศียา โลกา อปิ ปุณฺยารฺถมฺ อยตมานา วิศฺวาเสน ปุณฺยมฺ อลภนฺต; ");
INSERT INTO santha_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","กินฺตฺวิสฺราเยโลฺลกา วฺยวสฺถาปาลเนน ปุณฺยารฺถํ ยตมานาสฺตนฺ นาลภนฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ตสฺย กึ การณํ? เต วิศฺวาเสน นหิ กินฺตุ วฺยวสฺถายา: กฺริยยา เจษฺฏิตฺวา ตสฺมินฺ สฺขลนชนเก ปาษาเณ ปาทสฺขลนํ ปฺราปฺตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ลิขิตํ ยาทฺฤศมฺ อาเสฺต, ปศฺย ปาทสฺขลารฺถํ หิ สีโยนิ ปฺรสฺตรนฺตถาฯ พาธาการญฺจ ปาษาณํ ปริสฺถาปิตวานหมฺฯ วิศฺวสิษฺยติ ยสฺตตฺร ส ชโน น ตฺรปิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","เห ภฺราตร อิสฺราเยลียโลกา ยตฺ ปริตฺราณํ ปฺราปฺนุวนฺติ ตทหํ มนสาภิลษนฺ อีศฺวรสฺย สมีเป ปฺรารฺถเยฯ ");
INSERT INTO santha_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ยต อีศฺวเร เตษำ เจษฺฏา วิทฺยต อิตฺยตฺราหํ สากฺษฺยสฺมิ; กินฺตุ เตษำ สา เจษฺฏา สชฺญานา นหิ, ");
INSERT INTO santha_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ยตสฺต อีศฺวรทตฺตํ ปุณฺยมฺ อวิชฺญาย สฺวกฺฤตปุณฺยํ สฺถาปยิตุมฺ เจษฺฏมานา อีศฺวรทตฺตสฺย ปุณฺยสฺย นิฆฺนตฺวํ น สฺวีกุรฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ขฺรีษฺฏ เอไกกวิศฺวาสิชนาย ปุณฺยํ ทาตุํ วฺยวสฺถายา: ผลสฺวรูโป ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","วฺยวสฺถาปาลเนน ยตฺ ปุณฺยํ ตตฺ มูสา วรฺณยามาส, ยถา, โย ชนสฺตำ ปาลยิษฺยติ ส ตทฺทฺวารา ชีวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","กินฺตุ ปฺรตฺยเยน ยตฺ ปุณฺยํ ตทฺ เอตาทฺฤศํ วากฺยํ วทติ, ก: สฺวรฺคมฺ อารุหฺย ขฺรีษฺฏมฺ อวโรหยิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","โก วา เปฺรตโลกมฺ อวรุหฺย ขฺรีษฺฏํ มฺฤตคณมธฺยาทฺ อาเนษฺยตีติ วากฺ มนสิ ตฺวยา น คทิตวฺยาฯ ");
INSERT INTO santha_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ตรฺหิ กึ พฺรวีติ? ตทฺ วากฺยํ ตว สมีปสฺถมฺ อรฺถาตฺ ตว วทเน มนสิ จาเสฺต, ตจฺจ วากฺยมฺ อสฺมาภิ: ปฺรจารฺยฺยมาณํ วิศฺวาสสฺย วากฺยเมวฯ ");
INSERT INTO santha_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","วสฺตุต: ปฺรภุํ ยีศุํ ยทิ วทเนน สฺวีกโรษิ, ตเถศฺวรสฺตํ ศฺมศานาทฺ อุทสฺถาปยทฺ อิติ ยทฺยนฺต:กรเณน วิศฺวสิษิ ตรฺหิ ปริตฺราณํ ลปฺสฺยเสฯ ");
INSERT INTO santha_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ยสฺมาตฺ ปุณฺยปฺราปฺตฺยรฺถมฺ อนฺต:กรเณน วิศฺวสิตวฺยํ ปริตฺราณารฺถญฺจ วทเนน สฺวีกรฺตฺตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ศาสฺเตฺร ยาทฺฤศํ ลิขติ วิศฺวสิษฺยติ ยสฺตตฺร ส ชโน น ตฺรปิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","อิตฺยตฺร ยิหูทินิ ตทนฺยโลเก จ โกปิ วิเศโษ นาสฺติ ยสฺมาทฺ ย: สรฺเวฺวษามฺ อทฺวิตีย: ปฺรภุ: ส นิชยาจกาน สรฺวฺวานฺ ปฺรติ วทาโนฺย ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ยต:, ย: กศฺจิตฺ ปรเมศสฺย นามฺนา หิ ปฺรารฺถยิษฺยเตฯ ส เอว มนุโช นูนํ ปริตฺราโต ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ยํ เย ชนา น ปฺรตฺยายนฺ เต ตมุทฺทิศฺย กถํ ปฺรารฺถยิษฺยนฺเต? เย วา ยสฺยาขฺยานํ กทาปิ น ศฺรุตวนฺตเสฺต ตํ กถํ ปฺรเตฺยษฺยนฺติ? อปรํ ยทิ ปฺรจารยิตาโร น ติษฺฐนฺติ ตทา กถํ เต โศฺรษฺยนฺติ? ");
INSERT INTO santha_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ยทิ วา เปฺรริตา น ภวนฺติ ตทา กถํ ปฺรจารยิษฺยนฺติ? ยาทฺฤศํ ลิขิตมฺ อาเสฺต, ยถา, มางฺคลิกํ สุสํวาทํ ททตฺยานีย เย นรา:ฯ ปฺรจารยนฺติ ศานฺเตศฺจ สุสํวาทํ ชนาสฺตุ เยฯ เตษำ จรณปทฺมานิ กีทฺฤกฺ โศภานฺวิตานิ หิฯ ");
INSERT INTO santha_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","กินฺตุ เต สรฺเวฺว ตํ สุสํวาทํ น คฺฤหีตวนฺต:ฯ ยิศายิโย ยถา ลิขิตวานฺฯ อสฺมตฺปฺรจาริเต วาเกฺย วิศฺวาสมกโรทฺธิ ก:ฯ ");
INSERT INTO santha_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","อเตอว ศฺรวณาทฺ วิศฺวาส ไอศฺวรวากฺยปฺรจาราตฺ ศฺรวณญฺจ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ตรฺหฺยหํ พฺรวีมิ ไต: กึ นาศฺราวิ? อวศฺยมฺ อศฺราวิ, ยสฺมาตฺ เตษำ ศพฺโท มหีํ วฺยาปฺโนทฺ วากฺยญฺจ นิขิลํ ชคตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","อปรมปิ วทามิ, อิสฺราเยลียโลกา: กิมฺ เอตำ กถำ น พุธฺยนฺเต? ปฺรถมโต มูสา อิทํ วากฺยํ โปฺรวาจ, อหมุตฺตาปยิเษฺย ตานฺ อคณฺยมานไวรปิฯ เกฺลกฺษฺยามิ ชาติมฺ เอตาญฺจ โปฺรนฺมตฺตภินฺนชาติภิ:ฯ ");
INSERT INTO santha_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","อปรญฺจ ยิศายิโย'ติศยากฺโษเภณ กถยามาส, ยถา, อธิ มำ ไยสฺตุ นาเจษฺฏิ สมฺปฺราปฺตไสฺต รฺชไนรหํฯ อธิ มำ ไย รฺน สมฺปฺฤษฺฏํ วิชฺญาตไสฺต รฺชไนรหํ๚ ");
INSERT INTO santha_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","กินฺตฺวิสฺราเยลียโลกานฺ อธิ กถยาญฺจการ, ไยราชฺญาลงฺฆิภิ โรฺลไก รฺวิรุทฺธํ วากฺยมุจฺยเตฯ ตานฺ ปฺรเตฺยว ทินํ กฺฤตฺสฺนํ หเสฺตา วิสฺตารยามฺยหํ๚ ");
INSERT INTO santha_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","อีศฺวเรณ สฺวีกียโลกา อปสาริตา อหํ กิมฺ อีทฺฤศํ วากฺยํ พฺรวีมิ? ตนฺน ภวตุ ยโต'หมปิ พินฺยามีนโคตฺรีย อิพฺราหีมวํศีย อิสฺราเยลียโลโก'สฺมิฯ ");
INSERT INTO santha_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","อีศฺวเรณ ปูรฺวฺวํ เย ปฺรทฺฤษฺฏาเสฺต สฺวกียโลกา อปสาริตา อิติ นหิฯ อปรมฺ เอลิโยปาขฺยาเน ศาสฺเตฺร ยลฺลิขิตมฺ อาเสฺต ตทฺ ยูยํ กึ น ชานีถ? ");
INSERT INTO santha_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","เห ปรเมศฺวร โลกาสฺตฺวทียา: สรฺวฺวา ยชฺญเวทีรภญฺชนฺ ตถา ตว ภวิษฺยทฺวาทิน: สรฺวฺวานฺ อฆฺนนฺ เกวล เอโก'หมฺ อวศิษฺฏ อาเส เต มมาปิ ปฺราณานฺ นาศยิตุํ เจษฺฏนเต, เอตำ กถามฺ อิสฺราเยลียโลกานำ วิรุทฺธมฺ เอลิย อีศฺวราย นิเวทยามาสฯ ");
INSERT INTO santha_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ตตสฺตํ ปฺรตีศฺวรโสฺยตฺตรํ กึ ชาตํ? พาลฺนามฺโน เทวสฺย สากฺษาตฺ ไย รฺชานูนิ น ปาติตานิ ตาทฺฤศา: สปฺต สหสฺราณิ โลกา อวเศษิตา มยาฯ ");
INSERT INTO santha_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ตทฺวทฺ เอตสฺมินฺ วรฺตฺตมานกาเล'ปิ อนุคฺรเหณาภิรุจิตาเสฺตษามฺ อวศิษฺฏา: กติปยา โลกา: สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","อเตอว ตทฺ ยทฺยนุคฺรเหณ ภวติ ตรฺหิ กฺริยยา น ภวติ โน เจทฺ อนุคฺรโห'นนุคฺรห เอว, ยทิ วา กฺริยยา ภวติ ตรฺหฺยนุคฺรเหณ น ภวติ โน เจตฺ กฺริยา กฺริไยว น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ตรฺหิ กึ? อิสฺราเยลียโลกา ยทฺ อมฺฤคยนฺต ตนฺน ปฺราปุ:ฯ กินฺตฺวภิรุจิตโลกาสฺตตฺ ปฺราปุสฺตทเนฺย สรฺวฺว อนฺธีภูตา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ยถา ลิขิตมฺ อาเสฺต, โฆรนิทฺราลุตาภาวํ ทฺฤษฺฏิหีเน จ โลจเนฯ กรฺเณา ศฺรุติวิหีเนา จ ปฺรทเทา เตภฺย อีศฺวร:๚ ");
INSERT INTO santha_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","เอเตสฺมินฺ ทายูทปิ ลิขิตวานฺ ยถา, อโต ภุกฺตฺยาสนํ เตษามฺ อุนฺมาถวทฺ ภวิษฺยติฯ วา วํศยนฺตฺรวทฺ พาธา ทณฺฑวทฺ วา ภวิษฺยติ๚ ");
INSERT INTO santha_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ภวิษฺยนฺติ ตถานฺธาเสฺต เนไตฺร: ปศฺยนฺติ โน ยถาฯ เวปถุ: กฏิเทศสฺย เตษำ นิตฺยํ ภวิษฺยติ๚ ");
INSERT INTO santha_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ปตนารฺถํ เต สฺขลิตวนฺต อิติ วาจํ กิมหํ วทามิ? ตนฺน ภวตุ กินฺตุ ตานฺ อุโทฺยคิน: กรฺตฺตุํ เตษำ ปตนาทฺ อิตรเทศียโลไก: ปริตฺราณํ ปฺราปฺตํฯ ");
INSERT INTO santha_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","เตษำ ปตนํ ยทิ ชคโต โลกานำ ลาภชนกมฺ อภวตฺ เตษำ หฺราโส'ปิ ยทิ ภินฺนเทศินำ ลาภชนโก'ภวตฺ ตรฺหิ เตษำ วฺฤทฺธิ: กติ ลาภชนิกา ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","อโต เห อนฺยเทศิโน ยุษฺมานฺ สมฺโพธฺย กถยามิ นิชานำ ชฺญาติพนฺธูนำ มน:สูโทฺยคํ ชนยนฺ เตษำ มเธฺย กิยตำ โลกานำ ยถา ปริตฺราณํ สาธยามิ ");
INSERT INTO santha_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ตนฺนิมิตฺตมฺ อนฺยเทศินำ นิกเฏ เปฺรริต: สนฺ อหํ สฺวปทสฺย มหิมานํ ปฺรกาศยามิฯ ");
INSERT INTO santha_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","เตษำ นิคฺรเหณ ยทีศฺวเรณ สห ชคโต ชนานำ เมลนํ ชาตํ ตรฺหิ เตษามฺ อนุคฺฤหีตตฺวํ มฺฤตเทเห ยถา ชีวนลาภสฺตทฺวตฺ กึ น ภวิษฺยติ? ");
INSERT INTO santha_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","อปรํ ปฺรถมชาตํ ผลํ ยทิ ปวิตฺรํ ภวติ ตรฺหิ สรฺวฺวเมว ผลํ ปวิตฺรํ ภวิษฺยติ; ตถา มูลํ ยทิ ปวิตฺรํ ภวติ ตรฺหิ ศาขา อปิ ตไถว ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","กิยตีนำ ศาขานำ เฉทเน กฺฤเต ตฺวํ วนฺยชิตวฺฤกฺษสฺย ศาขา ภูตฺวา ยทิ ตจฺฉาขานำ สฺถาเน โรปิตา สติ ชิตวฺฤกฺษียมูลสฺย รสํ ภุํกฺเษ, ");
INSERT INTO santha_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ตรฺหิ ตาสำ ภินฺนศาขานำ วิรุทฺธํ มำ ครฺวฺวี:; ยทิ ครฺวฺวสิ ตรฺหิ ตฺวํ มูลํ ยนฺน ธารยสิ กินฺตุ มูลํ ตฺวำ ธารยตีติ สํสฺมรฯ ");
INSERT INTO santha_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","อปรญฺจ ยทิ วทสิ มำ โรปยิตุํ ตา: ศาขา วิภนฺนา อภวนฺ; ");
INSERT INTO santha_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ภทฺรมฺ, อปฺรตฺยยการณาตฺ เต วิภินฺนา ชาตาสฺตถา วิศฺวาสการณาตฺ ตฺวํ โรปิโต ชาตสฺตสฺมาทฺ อหงฺการมฺ อกฺฤตฺวา สสาธฺวโส ภวฯ ");
INSERT INTO santha_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ยต อีศฺวโร ยทิ สฺวาภาวิกี: ศาขา น รกฺษติ ตรฺหิ สาวธาโน ภว เจตฺ ตฺวามปิ น สฺถาปยติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","อิตฺยเตฺรศฺวรสฺย ยาทฺฤศี กฺฤปา ตาทฺฤศํ ภยานกตฺวมปิ ตฺวยา ทฺฤศฺยตำ; เย ปติตาสฺตานฺ ปฺรติ ตสฺย ภยานกตฺวํ ทฺฤศฺยตำ, ตฺวญฺจ ยทิ ตตฺกฺฤปาศฺริตสฺติษฺฐสิ ตรฺหิ ตฺวำ ปฺรติ กฺฤปา ทฺรกฺษฺยเต; โน เจตฺ ตฺวมปิ ตทฺวตฺ ฉินฺโน ภวิษฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","อปรญฺจ เต ยทฺยปฺรตฺยเย น ติษฺฐนฺติ ตรฺหิ ปุนรปิ โรปยิษฺยนฺเต ยสฺมาตฺ ตานฺ ปุนรปิ โรปยิตุมฺ อิศฺวรสฺย ศกฺติราเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","วนฺยชิตวฺฤกฺษสฺย ศาขา สนฺ ตฺวํ ยทิ ตตศฺฉินฺโน รีติวฺยตฺยเยโนตฺตมชิตวฺฤกฺเษ โรेेปิโต'ภวสฺตรฺหิ ตสฺย วฺฤกฺษสฺย สฺวียา ยา: ศาขาสฺตา: กึ ปุน: สฺววฺฤกฺเษ สํลคิตุํ น ศกฺนุวนฺติ? ");
INSERT INTO santha_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","เห ภฺราตโร ยุษฺมากมฺ อาตฺมาภิมาโน ยนฺน ชายเต ตทรฺถํ มเมทฺฤศี วาญฺฉา ภวติ ยูยํ เอตนฺนิคูฒตตฺตฺวมฺ อชานนฺโต ยนฺน ติษฺฐถ; วสฺตุโต ยาวตฺกาลํ สมฺปูรฺณรูเปณ ภินฺนเทศินำ สํคฺรโห น ภวิษฺยติ ตาวตฺกาลมฺ อํศเตฺวน อิสฺราเยลียโลกานามฺ อนฺธตา สฺถาสฺยติ; ");
INSERT INTO santha_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ปศฺจาตฺ เต สรฺเวฺว ปริตฺราสฺยนฺเต; เอตาทฺฤศํ ลิขิตมปฺยาเสฺต, อาคมิษฺยติ สีโยนาทฺ เอโก ยสฺตฺราณทายก:ฯ อธรฺมฺมํ ยากุโพ วํศาตฺ ส ตุ ทูรีกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ตถา ทูรีกริษฺยามิ เตษำ ปาปานฺยหํ ยทาฯ ตทา ไตเรว สารฺทฺธํ เม นิยโม'ยํ ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","สุสํวาทาตฺ เต ยุษฺมากํ วิปกฺษา อภวนฺ กินฺตฺวภิรุจิตตฺวาตฺ เต ปิตฺฤโลกานำ กฺฤเต ปฺริยปาตฺราณิ ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ยต อีศฺวรสฺย ทานาทฺ อาหฺวานาญฺจ ปศฺจาตฺตาโป น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","อเตอว ปูรฺวฺวมฺ อีศฺวเร'วิศฺวาสิน: สนฺโต'ปิ ยูยํ ยทฺวตฺ สมฺปฺรติ เตษามฺ อวิศฺวาสการณาทฺ อีศฺวรสฺย กฺฤปาปาตฺราณิ ชาตาสฺตทฺวทฺ ");
INSERT INTO santha_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","อิทานีํ เต'วิศฺวาสิน: สนฺติ กินฺตุ ยุษฺมาภิ รฺลพฺธกฺฤปาการณาตฺ ไตรปิ กฺฤปา ลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","อีศฺวร: สรฺวฺวานฺ ปฺรติ กฺฤปำ ปฺรกาศยิตุํ สรฺวฺวานฺ อวิศฺวาสิเตฺวน คณยติฯ ");
INSERT INTO santha_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","อโห อีศฺวรสฺย ชฺญานพุทฺธิรูปโย รฺธนโย: กีทฺฤกฺ ปฺราจุรฺยฺยํฯ ตสฺย ราชศาสนสฺย ตตฺตฺวํ กีทฺฤคฺ อปฺราปฺยํฯ ตสฺย มารฺคาศฺจ กีทฺฤคฺ อนุปลกฺษฺยา:ฯ ");
INSERT INTO santha_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ปรเมศฺวรสฺย สงฺกลฺปํ โก ชฺญาตวานฺ? ตสฺย มนฺตฺรี วา โก'ภวตฺ? ");
INSERT INTO santha_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","โก วา ตโสฺยปการี ภฺฤตฺวา ตตฺกฺฤเต เตน ปฺรตฺยุปกรฺตฺตวฺย:? ");
INSERT INTO santha_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ยโต วสฺตุมาตฺรเมว ตสฺมาตฺ เตน ตไสฺม จาภวตฺ ตทีโย มหิมา สรฺวฺวทา ปฺรกาศิโต ภวตุฯ อิติฯ ");
INSERT INTO santha_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","เห ภฺราตร อีศฺวรสฺย กฺฤปยาหํ ยุษฺมานฺ วินเย ยูยํ สฺวํ สฺวํ ศรีรํ สชีวํ ปวิตฺรํ คฺราหฺยํ พลิมฺ อีศฺวรมุทฺทิศฺย สมุตฺสฺฤชต, เอษา เสวา ยุษฺมากํ โยคฺยาฯ ");
INSERT INTO santha_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","อปรํ ยูยํ สำสาริกา อิว มาจรต, กินฺตุ สฺวํ สฺวํ สฺวภาวํ ปราวรฺตฺย นูตนาจาริโณ ภวต, ตต อีศฺวรสฺย นิเทศ: กีทฺฤคฺ อุตฺตโม คฺรหณีย: สมฺปูรฺณศฺเจติ ยุษฺมาภิรนุภาวิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","กศฺจิทปิ ชโน โยคฺยตฺวาทธิกํ สฺวํ น มนฺยตำ กินฺตุ อีศฺวโร ยไสฺม ปฺรตฺยยสฺย ยตฺปริมาณมฺ อททาตฺ ส ตทนุสารโต โยคฺยรูปํ สฺวํ มนุตามฺ, อีศฺวราทฺ อนุคฺรหํ ปฺราปฺต: สนฺ ยุษฺมากมฺ เอไกกํ ชนมฺ อิตฺยาชฺญาปยามิฯ ");
INSERT INTO santha_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ยโต ยทฺวทสฺมากมฺ เอกสฺมินฺ ศรีเร พหูนฺยงฺคานิ สนฺติ กินฺตุ สรฺเวฺวษามงฺคานำ การฺยฺยํ สมานํ นหิ; ");
INSERT INTO santha_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ตทฺวทสฺมากํ พหุเตฺว'ปิ สรฺเวฺว วยํ ขฺรีษฺเฏ เอกศรีรา: ปรสฺปรมฺ องฺคปฺรตฺยงฺคเตฺวน ภวาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","อสฺมาทฺ อีศฺวรานุคฺรเหณ วิเศษํ วิเศษํ ทานมฺ อสฺมาสุ ปฺราปฺเตษุ สตฺสุ โกปิ ยทิ ภวิษฺยทฺวากฺยํ วทติ ตรฺหิ ปฺรตฺยยสฺย ปริมาณานุสารต: ส ตทฺ วทตุ; ");
INSERT INTO santha_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ยทฺวา ยทิ กศฺจิตฺ เสวนการี ภวติ ตรฺหิ ส ตตฺเสวนํ กโรตุ; อถวา ยทิ กศฺจิทฺ อธฺยาปยิตา ภวติ ตรฺหิ โส'ธฺยาปยตุ; ");
INSERT INTO santha_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ตถา ย อุปเทษฺฏา ภวติ ส อุปทิศตุ ยศฺจ ทาตา ส สรลตยา ททาตุ ยสฺตฺวธิปติ: ส ยตฺเนนาธิปติตฺวํ กโรตุ ยศฺจ ทยาลุ: ส หฺฤษฺฏมนสา ทยตามฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","อปรญฺจ ยุษฺมากํ เปฺรม กาปฏฺยวรฺชิตํ ภวตุ ยทฺ อภทฺรํ ตทฺ ฤตียธฺวํ ยจฺจ ภทฺรํ ตสฺมินฺ อนุรชฺยธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","อปรํ ภฺราตฺฤตฺวเปฺรมฺนา ปรสฺปรํ ปฺรียธฺวํ สมาทราทฺ เอโก'ปรชนํ เศฺรษฺฐํ ชานีธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ตถา การฺเยฺย นิราลสฺยา มนสิ จ โสโทฺยคา: สนฺต: ปฺรภุํ เสวธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","อปรํ ปฺรตฺยาศายามฺ อานนฺทิตา ทุ:ขสมเย จ ไธรฺยฺยยุกฺตา ภวต; ปฺรารฺถนายำ สตตํ ปฺรวรฺตฺตธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ปวิตฺราณำ ทีนตำ ทูรีกุรุธฺวมฺ อติถิเสวายามฺ อนุรชฺยธฺวมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","เย ชนา ยุษฺมานฺ ตาฑยนฺติ ตานฺ อาศิษํ วทต ศาปมฺ อทตฺตฺวา ททฺธฺวมาศิษมฺฯ ");
INSERT INTO santha_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","เย ชนา อานนฺทนฺติ ไต: สารฺทฺธมฺ อานนฺทต เย จ รุทนฺติ ไต: สห รุทิตฯ ");
INSERT INTO santha_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","อปรญฺจ ยุษฺมากํ มนสำ ปรสฺปรมฺ เอโกภาโว ภวตุ; อปรมฺ อุจฺจปทมฺ อนากางฺกฺษฺย นีจโลไก: สหาปิ มารฺทวมฺ อาจรต; สฺวานฺ ชฺญานิโน น มนฺยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ปรสฺมาทฺ อปการํ ปฺราปฺยาปิ ปรํ นาปกุรุตฯ สรฺเวฺวษำ ทฺฤษฺฏิโต ยตฺ กรฺมฺโมตฺตมํ ตเทว กุรุตฯ ");
INSERT INTO santha_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ยทิ ภวิตุํ ศกฺยเต ตรฺหิ ยถาศกฺติ สรฺวฺวโลไก: สห นิรฺวฺวิโรเธน กาลํ ยาปยตฯ ");
INSERT INTO santha_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","เห ปฺริยพนฺธว:, กไสฺมจิทฺ อปการสฺย สมุจิตํ ทณฺฑํ สฺวยํ น ททฺธฺวํ, กินฺตฺวีศฺวรียโกฺรธาย สฺถานํ ทตฺต ยโต ลิขิตมาเสฺต ปรเมศฺวร: กถยติ, ทานํ ผลสฺย มตฺกรฺมฺม สูจิตํ ปฺรททามฺยหํฯ ");
INSERT INTO santha_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","อิติการณาทฺ ริปุ รฺยทิ กฺษุธารฺตฺตเสฺต ตรฺหิ ตํ ตฺวํ ปฺรโภชยฯ ตถา ยทิ ตฺฤษารฺตฺต: สฺยาตฺ ตรฺหิ ตํ ปริปายยฯ เตน ตฺวํ มสฺตเก ตสฺย ชฺวลทคฺนึ นิธาสฺยสิฯ ");
INSERT INTO santha_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","กุกฺริยยา ปราชิตา น สนฺต อุตฺตมกฺริยยา กุกฺริยำ ปราชยตฯ ");
INSERT INTO santha_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ยุษฺมากมฺ เอไกกชน: ศาสนปทสฺย นิคฺโหฺน ภวตุ ยโต ยานิ ศาสนปทานิ สนฺติ ตานิ สรฺวฺวาณีศฺวเรณ สฺถาปิตานิ; อีศฺวรํ วินา ปทสฺถาปนํ น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","อิติ เหโต: ศาสนปทสฺย ยตฺ ปฺราติกูลฺยํ ตทฺ อีศฺวรียนิรูปณสฺย ปฺราติกูลฺยเมว; อปรํ เย ปฺราติกูลฺยมฺ อาจรนฺติ เต เสฺวษำ สมุจิตํ ทณฺฑํ สฺวยเมว ฆฏยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ศาสฺตา สทาจาริณำ ภยปฺรโท นหิ ทุราจาริณาเมว ภยปฺรโท ภวติ; ตฺวํ กึ ตสฺมานฺ นิรฺภโย ภวิตุมฺ อิจฺฉสิ? ตรฺหิ สตฺกรฺมฺมาจร, ตสฺมาทฺ ยโศ ลปฺสฺยเส, ");
INSERT INTO santha_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ยตสฺตว สทาจรณาย ส อีศฺวรสฺย ภฺฤโตฺย'สฺติฯ กินฺตุ ยทิ กุกรฺมฺมาจรสิ ตรฺหิ ตฺวํ ศงฺกสฺว ยต: ส นิรรฺถกํ ขงฺคํ น ธารยติ; กุกรฺมฺมาจาริณํ สมุจิตํ ทณฺฑยิตุมฺ ส อีศฺวรสฺย ทณฺฑทภฺฤตฺย เอวฯ ");
INSERT INTO santha_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","อเตอว เกวลทณฺฑภยานฺนหิ กินฺตุ สทสทฺโพธาทปิ ตสฺย วเศฺยน ภวิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","เอตสฺมาทฺ ยุษฺมากํ ราชกรทานมปฺยุจิตํ ยสฺมาทฺ เย กรํ คฺฤหฺลนฺติ ต อีศฺวรสฺย กิงฺกรา ภูตฺวา สตตมฺ เอตสฺมินฺ กรฺมฺมณิ นิวิษฺฏาสฺติษฺฐนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","อสฺมาตฺ กรคฺราหิเณ กรํ ทตฺต, ตถา ศุลฺกคฺราหิเณ ศุลฺกํ ทตฺต, อปรํ ยสฺมาทฺ เภตวฺยํ ตสฺมาทฺ พิภีต, ยศฺจ สมาทรณียสฺตํ สมาทฺริยธฺวมฺ; อิตฺถํ ยสฺย ยตฺ ปฺราปฺยํ ตตฺ ตไสฺม ทตฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ยุษฺมากํ ปรสฺปรํ เปฺรม วินา 'นฺยตฺ กิมปิ เทยมฺ ฤณํ น ภวตุ, ยโต ย: ปรสฺมินฺ เปฺรม กโรติ เตน วฺยวสฺถา สิธฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","วสฺตุต: ปรทารานฺ มา คจฺฉ, นรหตฺยำ มา การฺษี:, ไจรฺยฺยํ มา การฺษี:, มิถฺยาสากฺษฺยํ มา เทหิ, โลภํ มา การฺษี:, เอตา: สรฺวฺวา อาชฺญา เอตาโภฺย ภินฺนา ยา กาจิทฺ อาชฺญาสฺติ สาปิ สฺวสมีปวาสินิ สฺววตฺ เปฺรม กุรฺวฺวิตฺยเนน วจเนน เวทิตาฯ ");
INSERT INTO santha_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ยต: เปฺรม สมีปวาสิโน'ศุภํ น ชนยติ ตสฺมาตฺ เปฺรมฺนา สรฺวฺวา วฺยวสฺถา ปาลฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ปฺรตฺยยีภวนกาเล'สฺมากํ ปริตฺราณสฺย สามีปฺยาทฺ อิทานีํ ตสฺย สามีปฺยมฺ อวฺยวหิตํ; อต: สมยํ วิวิจฺยาสฺมาภิ: สามฺปฺรตมฺ อวศฺยเมว นิทฺราโต ชาครฺตฺตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","พหุตรา ยามินี คตา ปฺรภาตํ สนฺนิธึ ปฺราปฺตํ ตสฺมาตฺ ตามสียา: กฺริยา: ปริตฺยชฺยาสฺมาภิ รฺวาสรียา สชฺชา ปริธาตวฺยาฯ ");
INSERT INTO santha_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","อโต เหโต รฺวยํ ทิวา วิหิตํ สทาจรณมฺ อาจริษฺยาม:ฯ รงฺครโส มตฺตตฺวํ ลมฺปฏตฺวํ กามุกตฺวํ วิวาท อีรฺษฺยา ไจตานิ ปริตฺยกฺษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ยูยํ ปฺรภุยีศุขฺรีษฺฏรูปํ ปริจฺฉทํ ปริธทฺธฺวํ สุขาภิลาษปูรณาย ศารีริกาจรณํ มาจรตฯ ");
INSERT INTO santha_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","โย ชโน'ทฺฤฒวิศฺวาสสฺตํ ยุษฺมากํ สงฺคินํ กุรุต กินฺตุ สนฺเทหวิจารารฺถํ นหิฯ ");
INSERT INTO santha_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ยโต นิษิทฺธํ กิมปิ ขาทฺยทฺรวฺยํ นาสฺติ, กสฺยจิชฺชนสฺย ปฺรตฺยย เอตาทฺฤโศ วิทฺยเต กินฺตฺวทฺฤฒวิศฺวาส: กศฺจิทปโร ชน: เกวลํ ศากํ ภุงฺกฺตํฯ ");
INSERT INTO santha_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ตรฺหิ โย ชน: สาธารณํ ทฺรวฺยํ ภุงฺกฺเต ส วิเศษทฺรวฺยโภกฺตารํ นาวชานียาตฺ ตถา วิเศษทฺรวฺยโภกฺตาปิ สาธารณทฺรวฺยโภกฺตารํ โทษิณํ น กุรฺยฺยาตฺ, ยสฺมาทฺ อีศฺวรสฺตมฺ อคฺฤหฺลาตฺฯ ");
INSERT INTO santha_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","เห ปรทาสสฺย ทูษยิตสฺตฺวํ ก:? นิชปฺรโภ: สมีเป เตน ปทเสฺถน ปทจฺยุเตน วา ภวิตวฺยํ ส จ ปทสฺถ เอว ภวิษฺยติ ยต อีศฺวรสฺตํ ปทสฺถํ กรฺตฺตุํ ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","อปรญฺจ กศฺจิชฺชโน ทินาทฺ ทินํ วิเศษํ มนฺยเต กศฺจิตฺตุु สรฺวฺวาณิ ทินานิ สมานานิ มนฺยเต, เอไกโก ชน: สฺวียมนสิ วิวิจฺย นิศฺจิโนตุฯ ");
INSERT INTO santha_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","โย ชน: กิญฺจน ทินํ วิเศษํ มนฺยเต ส ปฺรภุภกฺตฺยา ตนฺ มนฺยเต, ยศฺจ ชน: กิมปิ ทินํ วิเศษํ น มนฺยเต โส'ปิ ปฺรภุภกฺตฺยา ตนฺน มนฺยเต; อปรญฺจ ย: สรฺวฺวาณิ ภกฺษฺยทฺรวฺยาณิ ภุงฺกฺเต ส ปฺรภุภกฺตยา ตานิ ภุงฺกฺเต ยต: ส อีศฺวรํ ธนฺยํ วกฺติ, ยศฺจ น ภุงฺกฺเต โส'ปิ ปฺรภุภกฺไตฺยว น ภุญฺชาน อีศฺวรํ ธนฺยํ พฺรูเตฯ ");
INSERT INTO santha_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","อปรมฺ อสฺมากํ กศฺจิตฺ นิชนิมิตฺตํ ปฺราณานฺ ธารยติ นิชนิมิตฺตํ มฺริยเต วา ตนฺน; ");
INSERT INTO santha_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","กินฺตุ ยทิ วยํ ปฺราณานฺ ธารยามสฺตรฺหิ ปฺรภุนิมิตฺตํ ธารยาม:, ยทิ จ ปฺราณานฺ ตฺยชามสฺตรฺหฺยปิ ปฺรภุนิมิตฺตํ ตฺยชาม:, อเตอว ชีวเน มรเณ วา วยํ ปฺรโภเรวาสฺมเหฯ ");
INSERT INTO santha_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ยโต ชีวนฺโต มฺฤตาศฺเจตฺยุภเยษำ โลกานำ ปฺรภุตฺวปฺราปฺตฺยรฺถํ ขฺรีษฺโฏ มฺฤต อุตฺถิต: ปุนรฺชีวิตศฺจฯ ");
INSERT INTO santha_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","กินฺตุ ตฺวํ นิชํ ภฺราตรํ กุโต ทูษยสิ? ตถา ตฺวํ นิชํ ภฺราตรํ กุตสฺตุจฺฉํ ชานาสิ? ขฺรีษฺฏสฺย วิจารสึหาสนสฺย สมฺมุเข สรฺไวฺวรสฺมาภิรุปสฺถาตวฺยํ; ");
INSERT INTO santha_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ยาทฺฤศํ ลิขิตมฺ อาเสฺต, ปเรศ: ศปถํ กุรฺวฺวนฺ วากฺยเมตตฺ ปุราวทตฺฯ สรฺโวฺว ชน: สมีเป เม ชานุปาตํ กริษฺยติฯ ชิไหฺวไกกา ตเถศสฺย นิฆฺนตฺวํ สฺวีกริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","อเตอว อีศฺวรสมีเป'สฺมากมฺ เอไกกชเนน นิชา กถา กถยิตวฺยาฯ ");
INSERT INTO santha_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","อิตฺถํ สติ วยมฺ อทฺยารภฺย ปรสฺปรํ น ทูษยนฺต: สฺวภฺราตุ รฺวิคฺโหฺน วฺยาฆาโต วา ยนฺน ชาเยต ตาทฺฤศีมีหำ กุรฺมฺมเหฯ ");
INSERT INTO santha_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","กิมปิ วสฺตุ สฺวภาวโต นาศุจิ ภวตีตฺยหํ ชาเน ตถา ปฺรภุนา ยีศุขฺรีษฺเฏนาปิ นิศฺจิตํ ชาเน, กินฺตุ โย ชโน ยทฺ ทฺรวฺยมฺ อปวิตฺรํ ชานีเต ตสฺย กฺฤเต ตทฺ อปวิตฺรมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","อเตอว ตว ภกฺษฺยทฺรเวฺยณ ตว ภฺราตา โศกานฺวิโต ภวติ ตรฺหิ ตฺวํ ภฺราตรํ ปฺรติ เปฺรมฺนา นาจรสิฯ ขฺรีษฺโฏ ยสฺย กฺฤเต สฺวปฺราณานฺ วฺยยิตวานฺ ตฺวํ นิเชน ภกฺษฺยทฺรเวฺยณ ตํ น นาศยฯ ");
INSERT INTO santha_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","อปรํ ยุษฺมากมฺ อุตฺตมํ กรฺมฺม นินฺทิตํ น ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ภกฺษฺยํ เปยญฺเจศฺวรราชฺยสฺย สาโร นหิ, กินฺตุ ปุณฺยํ ศานฺติศฺจ ปวิเตฺรณาตฺมนา ชาต อานนฺทศฺจฯ ");
INSERT INTO santha_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","เอไต โรฺย ชน: ขฺรีษฺฏํ เสวเต, ส เอเวศฺวรสฺย ตุษฺฏิกโร มนุไษฺยศฺจ สุขฺยาต:ฯ ");
INSERT INTO santha_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","อเตอว เยนาสฺมากํ สรฺเวฺวษำ ปรสฺปรมฺ ไอกฺยํ นิษฺฐา จ ชายเต ตเทวาสฺมาภิ รฺยติตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ภกฺษฺยารฺถมฺ อีศฺวรสฺย กรฺมฺมโณ หานึ มา ชนยต; สรฺวฺวํ วสฺตุ ปวิตฺรมิติ สตฺยํ ตถาปิ โย ชโน ยทฺ ภุกฺตฺวา วิฆฺนํ ลภเต ตทรฺถํ ตทฺ ภทฺรํ นหิฯ ");
INSERT INTO santha_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ตว มำสภกฺษณสุราปานาทิภิ: กฺริยาภิ รฺยทิ ตว ภฺราตุ: ปาทสฺขลนํ วิคฺโหฺน วา จาญฺจลฺยํ วา ชายเต ตรฺหิ ตทฺโภชนปานโยสฺตฺยาโค ภทฺร:ฯ ");
INSERT INTO santha_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ยทิ ตว ปฺรตฺยยสฺติษฺฐติ ตรฺหีศฺวรสฺย โคจเร สฺวานฺตเร ตํ โคปย; โย ชน: สฺวมเตน สฺวํ โทษิณํ น กโรติ ส เอว ธนฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","กินฺตุ ย: กศฺจิตฺ สํศยฺย ภุงฺกฺเต'รฺถาตฺ น ปฺรตีตฺย ภุงฺกฺเต, ส เอวาวศฺยํ ทณฺฑาโรฺห ภวิษฺยติ, ยโต ยตฺ ปฺรตฺยยชํ นหิ ตเทว ปาปมยํ ภวติฯ ");
INSERT INTO santha_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","พลวทฺภิรสฺมาภิ รฺทุรฺพฺพลานำ เทารฺพฺพลฺยํ โสฒวฺยํ น จ เสฺวษามฺ อิษฺฏาจาร อาจริตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","อสฺมากมฺ เอไกโก ชน: สฺวสมีปวาสิโน หิตารฺถํ นิษฺฐารฺถญฺจ ตไสฺยเวษฺฏาจารมฺ อาจรตุฯ ");
INSERT INTO santha_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ยต: ขฺรีษฺโฏ'ปิ นิเชษฺฏาจารํ นาจริตวานฺ, ยถา ลิขิตมฺ อาเสฺต, ตฺวนฺนินฺทกคณไสฺยว นินฺทาภิ รฺนินฺทิโต'สฺมฺยหํฯ ");
INSERT INTO santha_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","อปรญฺจ วยํ ยตฺ สหิษฺณุตาสานฺตฺวนโย รฺชนเกน ศาสฺเตฺรณ ปฺรตฺยาศำ ลเภมหิ ตนฺนิมิตฺตํ ปูรฺวฺวกาเล ลิขิตานิ สรฺวฺววจนานฺยสฺมากมฺ อุปเทศารฺถเมว ลิลิขิเรฯ ");
INSERT INTO santha_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","สหิษฺณุตาสานฺตฺวนโยรากโร ย อีศฺวร: ส เอวํ กโรตุ ยตฺ ปฺรภุ รฺยีศุขฺรีษฺฏ อิว ยุษฺมากมฺ เอกชโน'นฺยชเนน สารฺทฺธํ มนส ไอกฺยมฺ อาจเรตฺ; ");
INSERT INTO santha_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ยูยญฺจ สรฺวฺว เอกจิตฺตา ภูตฺวา มุไขเกเนวาสฺมตฺปฺรภุยีศุขฺรีษฺฏสฺย ปิตุรีศฺวรสฺย คุณานฺ กีรฺตฺตเยตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","อปรมฺ อีศฺวรสฺย มหิมฺน: ปฺรกาศารฺถํ ขฺรีษฺโฏ ยถา ยุษฺมานฺ ปฺรตฺยคฺฤหฺลาตฺ ตถา ยุษฺมากมเปฺยโก ชโน'นฺยชนํ ปฺรติคฺฤหฺลาตุฯ ");
INSERT INTO santha_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ยถา ลิขิตมฺ อาเสฺต, อโต'หํ สมฺมุเข ติษฺฐนฺ ภินฺนเทศนิวาสินำฯ สฺตุวํสฺตฺวำ ปริคาสฺยามิ ตว นามฺนิ ปเรศฺวร๚ ");
INSERT INTO santha_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ตสฺย ทยาลุตฺวาจฺจ ภินฺนชาตียา ยทฺ อีศฺวรสฺย คุณานฺ กีรฺตฺตเยยุสฺตทรฺถํ ยีศุ: ขฺรีษฺฏสฺตฺวกฺเฉทนิยมสฺย นิคฺโหฺน'ภวทฺ อิตฺยหํ วทามิฯ ยถา ลิขิตมฺ อาเสฺต, อโต'หํ สมฺมุเข ติษฺฐนฺ ภินฺนเทศนิวาสินำฯ สฺตุวํสฺตฺวำ ปริคาสฺยามิ ตว นามฺนิ ปเรศฺวร๚ ");
INSERT INTO santha_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","อปรมปิ ลิขิตมฺ อาเสฺต, เห อนฺยชาตโย ยูยํ สมํ นนฺทต ตชฺชไน:ฯ ");
INSERT INTO santha_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ปุนศฺจ ลิขิตมฺ อาเสฺต, เห สรฺวฺวเทศิโน ยูยํ ธนฺยํ พฺรูต ปเรศฺวรํฯ เห ตทียนรา ยูยํ กุรุธฺวํ ตตฺปฺรศํสนํ๚ ");
INSERT INTO santha_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","อปร ยีศายิโย'ปิ ลิเลข, ยีศยสฺย ตุ ยตฺ มูลํ ตตฺ ปฺรกาศิษฺยเต ตทาฯ สรฺวฺวชาตียนฺฤณาญฺจ ศาสก: สมุเทษฺยติฯ ตตฺรานฺยเทศิโลไกศฺจ ปฺรตฺยาศา ปฺรกริษฺยเต๚ ");
INSERT INTO santha_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","อเตอว ยูยํ ปวิตฺรสฺยาตฺมน: ปฺรภาวาทฺ ยตฺ สมฺปูรฺณำ ปฺรตฺยาศำ ลปฺสฺยเธฺว ตทรฺถํ ตตฺปฺรตฺยาศาชนก อีศฺวร: ปฺรตฺยเยน ยุษฺมานฺ ศานฺตฺยานนฺทาภฺยำ สมฺปูรฺณานฺ กโรตุฯ ");
INSERT INTO santha_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","เห ภฺราตโร ยูยํ สทฺภาวยุกฺตา: สรฺวฺวปฺรกาเรณ ชฺญาเนน จ สมฺปูรฺณา: ปรสฺปโรปเทเศ จ ตตฺปรา อิตฺยหํ นิศฺจิตํ ชานามิ, ");
INSERT INTO santha_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ตถาปฺยหํ ยตฺ ปฺรคลฺภตโร ภวนฺ ยุษฺมานฺ ปฺรโพธยามิ ตไสฺยกํ การณมิทํฯ ");
INSERT INTO santha_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ภินฺนชาตียา: ปวิเตฺรณาตฺมนา ปาวิตไนเวทฺยรูปา ภูตฺวา ยทฺ คฺราหฺยา ภเวยุสฺตนฺนิมิตฺตมหมฺ อีศฺวรสฺย สุสํวาทํ ปฺรจารยิตุํ ภินฺนชาตียานำ มเธฺย ยีศุขฺรีษฺฏสฺย เสวกตฺวํ ทานํ อีศฺวราตฺ ลพฺธวานสฺมิฯ ");
INSERT INTO santha_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","อีศฺวรํ ปฺรติ ยีศุขฺรีษฺเฏน มม ศฺลาฆากรณสฺย การณมฺ อาเสฺตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ภินฺนเทศิน อาชฺญาคฺราหิณ: กรฺตฺตุํ ขฺรีษฺโฏ วาเกฺยน กฺริยยา จ, อาศฺจรฺยฺยลกฺษไณศฺจิตฺรกฺริยาภิ: ปวิตฺรสฺยาตฺมน: ปฺรภาเวน จ ยานิ กรฺมฺมาณิ มยา สาธิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","เกวลํ ตาเนฺยว วินานฺยสฺย กสฺยจิตฺ กรฺมฺมโณ วรฺณนำ กรฺตฺตุํ ปฺรคลฺโภ น ภวามิฯ ตสฺมาตฺ อา ยิรูศาลม อิลฺลูริกํ ยาวตฺ สรฺวฺวตฺร ขฺรีษฺฏสฺย สุสํวาทํ ปฺราจารยํฯ ");
INSERT INTO santha_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","อเนฺยน นิจิตายำ ภิตฺตาวหํ ยนฺน นิจิโนมิ ตนฺนิมิตฺตํ ยตฺร ยตฺร สฺถาเน ขฺรีษฺฏสฺย นาม กทาปิ เกนาปิ น ชฺญาปิตํ ตตฺร ตตฺร สุสํวาทํ ปฺรจารยิตุมฺ อหํ ยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ยาทฺฤศํ ลิขิตมฺ อาเสฺต, ไย รฺวารฺตฺตา ตสฺย น ปฺราปฺตา ทรฺศนํ ไตสฺตุ ลปฺสฺยเตฯ ไยศฺจ ไนว ศฺรุตํ กิญฺจิตฺ โพทฺธุํ ศกฺษฺยนฺติ เต ชนา:๚ ");
INSERT INTO santha_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ตสฺมาทฺ ยุษฺมตฺสมีปคมนาทฺ อหํ มุหุรฺมุหุ รฺนิวาริโต'ภวํฯ ");
INSERT INTO santha_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","กินฺตฺวิทานีมฺ อตฺร ปฺรเทเศษุ มยา น คตํ สฺถานํ กิมปิ นาวศิษฺยเต ยุษฺมตฺสมีปํ คนฺตุํ พหุวตฺสรานารภฺย มามกีนากางฺกฺษา จ วิทฺยต อิติ เหโต: ");
INSERT INTO santha_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","สฺปานิยาเทศคมนกาเล'หํ ยุษฺมนฺมเธฺยน คจฺฉนฺ ยุษฺมานฺ อาโลกิเษฺย, ตต: ปรํ ยุษฺมตฺสมฺภาษเณน ตฺฤปฺตึ ปริลภฺย ตทฺเทศคมนารฺถํ ยุษฺมาภิ รฺวิสรฺชยิเษฺย, อีทฺฤศี มทียา ปฺรตฺยาศา วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","กินฺตุ สามฺปฺรตํ ปวิตฺรโลกานำ เสวนาย ยิรูศาลมฺนครํ วฺรชามิฯ ");
INSERT INTO santha_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ยโต ยิรูศาลมสฺถปวิตฺรโลกานำ มเธฺย เย ทริทฺรา อรฺถวิศฺราณเนน ตานุปกรฺตฺตุํ มากิทนิยาเทศียา อาขายาเทศียาศฺจ โลกา ไอจฺฉนฺฯ ");
INSERT INTO santha_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","เอษา เตษำ สทิจฺฉา ยตเสฺต เตษามฺ ฤณิน: สนฺติ ยโต เหโต รฺภินฺนชาตียา เยษำ ปรมารฺถสฺยำศิโน ชาตา ไอหิกวิษเย เตษามุปการไสฺต: กรฺตฺตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","อโต มยา ตตฺ กรฺมฺม สาธยิตฺวา ตสฺมินฺ ผเล เตภฺย: สมรฺปิเต ยุษฺมนฺมเธฺยน สฺปานิยาเทโศ คมิษฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ยุษฺมตฺสมีเป มมาคมนสมเย ขฺรีษฺฏสฺย สุสํวาทสฺย ปูรฺณวเรณ สมฺพลิต: สนฺ อหมฺ อาคมิษฺยามิ อิติ มยา ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","เห ภฺราตฺฤคณ ปฺรโภ รฺยีศุขฺรีษฺฏสฺย นามฺนา ปวิตฺรสฺยาตฺมาน: เปฺรมฺนา จ วินเย'หํ ");
INSERT INTO santha_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ยิหูทาเทศสฺถานามฺ อวิศฺวาสิโลกานำ กเรโภฺย ยทหํ รกฺษำ ลเภย มทีไยเตน เสวนกรฺมฺมณา จ ยทฺ ยิรูศาลมสฺถา: ปวิตฺรโลกาสฺตุเษฺยยุ:, ");
INSERT INTO santha_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ตทรฺถํ ยูยํ มตฺกฺฤต อีศฺวราย ปฺรารฺถยมาณา ยตธฺวํ เตนาหมฺ อีศฺวเรจฺฉยา สานนฺทํ ยุษฺมตฺสมีปํ คตฺวา ยุษฺมาภิ: สหิต: ปฺราณานฺ อาปฺยายิตุํ ปารยิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ศานฺติทายก อีศฺวโร ยุษฺมากํ สรฺเวฺวษำ สงฺคี ภูยาตฺฯ อิติฯ ");
INSERT INTO santha_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","กึกฺรียานครียธรฺมฺมสมาชสฺย ปริจาริกา ยา ไผพีนามิกาสฺมากํ ธรฺมฺมภคินี ตสฺยา: กฺฤเต'หํ ยุษฺมานฺ นิเวทยามิ, ");
INSERT INTO santha_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ยูยํ ตำ ปฺรภุมาศฺริตำ วิชฺญาย ตสฺยา อาติถฺยํ ปวิตฺรโลการฺหํ กุรุธฺวํ, ยุษฺมตฺตสฺตสฺยา ย อุปกาโร ภวิตุํ ศกฺโนติ ตํ กุรุธฺวํ, ยสฺมาตฺ ตยา พหูนำ มม โจปการ: กฺฤต:ฯ ");
INSERT INTO santha_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","อปรญฺจ ขฺรีษฺฏสฺย ยีโศ: กรฺมฺมณิ มม สหการิเณา มม ปฺราณรกฺษารฺถญฺจ สฺวปฺราณานฺ ปณีกฺฤตวนฺเตา เยา ปฺริษฺกิลฺลากฺกิเลา เตา มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ตาภฺยามฺ อุปการาปฺติ: เกวลํ มยา สฺวีกรฺตฺตเวฺยติ นหิ ภินฺนเทศีไย: สรฺวฺวธรฺมฺมสมาไชรปิฯ ");
INSERT INTO santha_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","อปรญฺจ ตโย รฺคฺฤเห สฺถิตานฺ ธรฺมฺมสมาชโลกานฺ มม นมสฺการํ ชฺญาปยธฺวํฯ ตทฺวตฺ อาศิยาเทเศ ขฺรีษฺฏสฺย ปกฺเษ ปฺรถมชาตผลสฺวรูโป ย อิเปนิตนามา มม ปฺริยพนฺธุสฺตมปิ มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","อปรํ พหุศฺรเมณาสฺมานฺ อเสวต ยา มริยมฺ ตามปิ นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","อปรญฺจ เปฺรริเตษุ ขฺยาตกีรฺตฺตี มทเคฺร ขฺรีษฺฏาศฺริเตา มม สฺวชาตีเยา สหพนฺทิเนา จ ยาวานฺทฺรนีกยูนิเยา เตา มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ตถา ปฺรเภา มตฺปฺริยตมมฺ อามฺปฺลิยมปิ มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","อปรํ ขฺรีษฺฏเสวายำ มม สหการิณมฺ อูรฺพฺพาณํ มม ปฺริยตมํ สฺตาขุญฺจ มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","อปรํ ขฺรีษฺเฏน ปรีกฺษิตมฺ อาปิลฺลึ มม นมสฺการํ วทต, อาริษฺฏพูลสฺย ปริชนำศฺจ มม นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","อปรํ มม ชฺญาตึ เหโรทิโยนํ มม นมสฺการํ วทต, ตถา นารฺกิสสฺย ปริวาราณำ มเธฺย เย ปฺรภุมาศฺริตาสฺตานฺ มม นมสฺการํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","อปรํ ปฺรโภ: เสวายำ ปริศฺรมการิเณฺยา ตฺรุเผนาตฺรุโผเษ มม นมสฺการํ วทต, ตถา ปฺรโภ: เสวายามฺ อตฺยนฺตํ ปริศฺรมการิณี ยา ปฺริยา ปรฺษิสฺตำ นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","อปรํ ปฺรโภรภิรุจิตํ รูผํ มม ธรฺมฺมมาตา ยา ตสฺย มาตา ตามปิ นมสฺการํ วทตฯ ");
INSERT INTO santha_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","อปรมฺ อสุํกฺฤตํ ผฺลิโคนํ หรฺมฺมํ ปาตฺรพํ หรฺมฺมิมฺ เอเตษำ สงฺคิภฺราตฺฤคณญฺจ นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","อปรํ ผิลลโค ยูลิยา นีริยสฺตสฺย ภคินฺยลุมฺปา ไจตานฺ เอไต: สารฺทฺธํ ยาวนฺต: ปวิตฺรโลกา อาสเต ตานปิ นมสฺการํ ชฺญาปยธฺวํฯ ");
INSERT INTO santha_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ยูยํ ปรสฺปรํ ปวิตฺรจุมฺพเนน นมสฺกุรุธฺวํฯ ขฺรีษฺฏสฺย ธรฺมฺมสมาชคโณ ยุษฺมานฺ นมสฺกุรุเตฯ ");
INSERT INTO santha_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","เห ภฺราตโร ยุษฺมานฺ วินเย'หํ ยุษฺมาภิ รฺยา ศิกฺษา ลพฺธา ตามฺ อติกฺรมฺย เย วิจฺเฉทานฺ วิฆฺนำศฺจ กุรฺวฺวนฺติ ตานฺ นิศฺจินุต เตษำ สงฺคํ วรฺชยต จฯ ");
INSERT INTO santha_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ยตสฺตาทฺฤศา โลกา อสฺมากํ ปฺรโภ รฺยีศุขฺรีษฺฏสฺย ทาสา อิติ นหิ กินฺตุ โสฺวทรไสฺยว ทาสา:; อปรํ ปฺรณยวจไน รฺมธุรวาไกฺยศฺจ สรลโลกานำ มนำสิ โมหยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ยุษฺมากมฺ อาชฺญาคฺราหิตฺวํ สรฺวฺวตฺร สรฺไวฺว รฺชฺญาตํ ตโต'หํ ยุษฺมาสุ สานนฺโท'ภวํ ตถาปิ ยูยํ ยตฺ สตฺชฺญาเนน ชฺญานิน: กุชฺญาเนे จาตตฺปรา ภเวเตติ มมาภิลาษ:ฯ ");
INSERT INTO santha_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","อธิกนฺตุ ศานฺติทายก อีศฺวร: ไศตานมฺ อวิลมฺพํ ยุษฺมากํ ปทานามฺ อโธ มรฺทฺทิษฺยติฯ อสฺมากํ ปฺรภุ รฺยีศุขฺรีษฺโฏ ยุษฺมาสุ ปฺรสาทํ กฺริยาตฺฯ อิติฯ ");
INSERT INTO santha_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","มม สหการี ตีมถิโย มม ชฺญาตโย ลูกิโย ยาโสนฺ โสสิปาตฺรศฺเจเม ยุษฺมานฺ นมสฺกุรฺวฺวนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","อปรมฺ เอตตฺปตฺรเลขกสฺตรฺตฺติยนามาหมปิ ปฺรโภ รฺนามฺนา ยุษฺมานฺ นมสฺกโรมิฯ ");
INSERT INTO santha_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ตถา กฺฤตฺสฺนธรฺมฺมสมาชสฺย มม จาติถฺยการี คาโย ยุษฺมานฺ นมสฺกโรติฯ อปรมฺ เอตนฺนครสฺย ธนรกฺษก อิราสฺต: กฺการฺตฺตนามกศฺไจโก ภฺราตา ตาวปิ ยุษฺมานฺ นมสฺกุรุต:ฯ ");
INSERT INTO santha_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","อสฺมากํ ปฺรภุ รฺยีศุขฺรีษฺฏา ยุษฺมาสุ สรฺเวฺวษุ ปฺรสาทํ กฺริยาตฺฯ อิติฯ ");
INSERT INTO santha_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ปูรฺวฺวกาลิกยุเคษุ ปฺรจฺฉนฺนา ยา มนฺตฺรณาธุนา ปฺรกาศิตา ภูตฺวา ภวิษฺยทฺวาทิลิขิตคฺรนฺถคณสฺย ปฺรมาณาทฺ วิศฺวาเสน คฺรหณารฺถํ สทาตนเสฺยศฺวรสฺยาชฺญยา สรฺวฺวเทศียโลกานฺ ชฺญาปฺยเต, ");
INSERT INTO santha_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ตสฺยา มนฺตฺรณายา ชฺญานํ ลพฺธฺวา มยา ย: สุสํวาโท ยีศุขฺรีษฺฏมธิ ปฺรจารฺยฺยเต, ตทนุสาราทฺ ยุษฺมานฺ ธรฺมฺเม สุสฺถิรานฺ กรฺตฺตุํ สมรฺโถ โย'ทฺวิตีย: ");
INSERT INTO santha_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","สรฺวฺวชฺญ อีศฺวรสฺตสฺย ธนฺยวาโท ยีศุขฺรีษฺเฏน สนฺตตํ ภูยาตฺฯ อิติฯ");
INSERT INTO santha_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ยาวนฺต: ปวิตฺรา โลกา: เสฺวษามฺ อสฺมากญฺจ วสติสฺถาเนษฺวสฺมากํ ปฺรโภ รฺยีโศ: ขฺรีษฺฏสฺย นามฺนา ปฺรารฺถยนฺเต ไต: สหาหูตานำ ขฺรีษฺเฏน ยีศุนา ปวิตฺรีกฺฤตานำ โลกานำ ย อีศฺวรียธรฺมฺมสมาช: กรินฺถนคเร วิทฺยเต ");
INSERT INTO santha_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ตํ ปฺรตีศฺวรเสฺยจฺฉยาหูโต ยีศุขฺรีษฺฏสฺย เปฺรริต: เปาล: โสสฺถินินามา ภฺราตา จ ปตฺรํ ลิขติฯ ");
INSERT INTO santha_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","อสฺมากํ ปิเตฺรศฺวเรณ ปฺรภุนา ยีศุขฺรีษฺเฏน จ ปฺรสาท: ศานฺติศฺจ ยุษฺมภฺยํ ทียตำฯ ");
INSERT INTO santha_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","อีศฺวโร ยีศุขฺรีษฺเฏน ยุษฺมานฺ ปฺรติ ปฺรสาทํ ปฺรกาศิตวานฺ, ตสฺมาทหํ ยุษฺมนฺนิมิตฺตํ สรฺวฺวทา มทีเยศฺวรํ ธนฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ขฺรีษฺฏสมฺพนฺธียํ สากฺษฺยํ ยุษฺมากํ มเธฺย เยน ปฺรกาเรณ สปฺรมาณมฺ อภวตฺ ");
INSERT INTO santha_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","เตน ยูยํ ขฺรีษฺฏาตฺ สรฺวฺววิธวกฺตฺฤตาชฺญานาทีนิ สรฺวฺวธนานิ ลพฺธวนฺต:ฯ ");
INSERT INTO santha_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ตโต'สฺมตฺปฺรโภ รฺยีศุขฺรีษฺฏสฺย ปุนราคมนํ ปฺรตีกฺษมาณานำ ยุษฺมากํ กสฺยาปิ วรสฺยาภาโว น ภวติฯ ");
INSERT INTO santha_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","อปรมฺ อสฺมากํ ปฺรโภ รฺยีศุขฺรีษฺฏสฺย ทิวเส ยูยํ ยนฺนิรฺทฺโทษา ภเวต ตทรฺถํ เสอว ยาวทนฺตํ ยุษฺมานฺ สุสฺถิรานฺ กริษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ย อีศฺวร: สฺวปุตฺรสฺยาสฺมตฺปฺรโภ รฺยีศุขฺรีษฺฏสฺยำศิน: กรฺตฺตุํ ยุษฺมานฺ อาหูตวานฺ ส วิศฺวสนีย:ฯ ");
INSERT INTO santha_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","เห ภฺราตร:, อสฺมากํ ปฺรภุยีศุขฺรีษฺฏสฺย นามฺนา ยุษฺมานฺ วินเย'หํ สรฺไวฺว รฺยุษฺมาภิเรกรูปาณิ วากฺยานิ กถฺยนฺตำ ยุษฺมนฺมเธฺย ภินฺนสงฺฆาตา น ภวนฺตุ มโนวิจารโยไรเกฺยน ยุษฺมากํ สิทฺธตฺวํ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","เห มม ภฺราตโร ยุษฺมนฺมเธฺย วิวาทา ชาตา อิติ วารฺตฺตามหํ โกฺลยฺยา: ปริชไน รฺชฺญาปิต:ฯ ");
INSERT INTO santha_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","มมาภิเปฺรตมิทํ ยุษฺมากํ กศฺจิตฺ กศฺจิทฺ วทติ เปาลสฺย ศิโษฺย'หมฺ อาปโลฺล: ศิโษฺย'หํ ไกผา: ศิโษฺย'หํ ขฺรีษฺฏสฺย ศิโษฺย'หมิติ จฯ ");
INSERT INTO santha_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ขฺรีษฺฏสฺย กึ วิเภท: กฺฤต:? เปาล: กึ ยุษฺมตฺกฺฤเต กฺรุเศ หต:? เปาลสฺย นามฺนา วา ยูยํ กึ มชฺชิตา:? ");
INSERT INTO santha_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","กฺริษฺปคาเยา วินา ยุษฺมากํ มเธฺย'นฺย: โก'ปิ มยา น มชฺชิต อิติ เหโตรหมฺ อีศฺวรํ ธนฺยํ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","เอเตน มม นามฺนา มานวา มยา มชฺชิตา อิติ วกฺตุํ เกนาปิ น ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","อปรํ สฺติผานสฺย ปริชนา มยา มชฺชิตาสฺตทนฺย: กศฺจิทฺ ยนฺมยา มชฺชิตสฺตทหํ น เวทฺมิฯ ");
INSERT INTO santha_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ขฺรีษฺเฏนาหํ มชฺชนารฺถํ น เปฺรริต: กินฺตุ สุสํวาทสฺย ปฺรจารารฺถเมว; โส'ปิ วากฺปฏุตยา มยา น ปฺรจาริตวฺย:, ยตสฺตถา ปฺรจาริเต ขฺรีษฺฏสฺย กฺรุเศ มฺฤตฺยุ: ผลหีโน ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ยโต เหโต เรฺย วินศฺยนฺติ เต ตำ กฺรุศสฺย วารฺตฺตำ ปฺรลาปมิว มนฺยนฺเต กิญฺจ ปริตฺราณํ ลภมาเนษฺวสฺมาสุ สา อีศฺวรียศกฺติสฺวรูปาฯ ");
INSERT INTO santha_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ตสฺมาทิตฺถํ ลิขิตมาเสฺต, ชฺญานวตานฺตุ ยตฺ ชฺญานํ ตนฺมยา นาศยิษฺยเตฯ วิโลปยิษฺยเต ตทฺวทฺ พุทฺธิ รฺพทฺธิมตำ มยา๚ ");
INSERT INTO santha_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ชฺญานี กุตฺร? ศาสฺตฺรี วา กุตฺร? อิหโลกสฺย วิจารตตฺปโร วา กุตฺร? อิหโลกสฺย ชฺญานํ กิมีศฺวเรณ โมหีกฺฤตํ นหิ? ");
INSERT INTO santha_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","อีศฺวรสฺย ชฺญานาทฺ อิหโลกสฺย มานวา: สฺวชฺญาเนเนศฺวรสฺย ตตฺตฺวโพธํ น ปฺราปฺตวนฺตสฺตสฺมาทฺ อีศฺวร: ปฺรจารรูปิณา ปฺรลาเปน วิศฺวาสิน: ปริตฺราตุํ โรจิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ยิหูทียโลกา ลกฺษณานิ ทิทฺฤกฺษนฺติ ภินฺนเทศียโลกาสฺตุ วิทฺยำ มฺฤคยนฺเต, ");
INSERT INTO santha_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","วยญฺจ กฺรุเศ หตํ ขฺรีษฺฏํ ปฺรจารยาม:ฯ ตสฺย ปฺรจาโร ยิหูทีไย รฺวิฆฺน อิว ภินฺนเทศีไยศฺจ ปฺรลาป อิว มนฺยเต, ");
INSERT INTO santha_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","กินฺตุ ยิหูทียานำ ภินฺนเทศียานาญฺจ มเธฺย เย อาหูตาเสฺตษุ ส ขฺรีษฺฏ อีศฺวรียศกฺติริเวศฺวรียชฺญานมิว จ ปฺรกาศเตฯ ");
INSERT INTO santha_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ยต อีศฺวเร ย: ปฺรลาป อาโรปฺยเต ส มานวาติริกฺตํ ชฺญานเมว ยจฺจ เทารฺพฺพลฺยมฺ อีศฺวร อาโรปฺยเต ตตฺ มานวาติริกฺตํ พลเมวฯ ");
INSERT INTO santha_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","เห ภฺราตร:, อาหูตยุษฺมทฺคโณ ยษฺมาภิราโลกฺยตำ ตนฺมเธฺย สำสาริกชฺญาเนน ชฺญานวนฺต: ปรากฺรมิโณ วา กุลีนา วา พหโว น วิทฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ยต อีศฺวโร ชฺญานวตสฺตฺรปยิตุํ มูรฺขโลกานฺ โรจิตวานฺ พลานิ จ ตฺรปยิตุมฺ อีศฺวโร ทุรฺพฺพลานฺ โรจิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ตถา วรฺตฺตมานโลกานฺ สํสฺถิติภฺรษฺฏานฺ กรฺตฺตุมฺ อีศฺวโร ชคโต'ปกฺฤษฺฏานฺ เหยานฺ อวรฺตฺตมานำศฺจาภิโรจิตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ตต อีศฺวรสฺย สากฺษาตฺ เกนาปฺยาตฺมศฺลาฆา น กรฺตฺตวฺยาฯ ");
INSERT INTO santha_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ยูยญฺจ ตสฺมาตฺ ขฺรีษฺเฏ ยีเศา สํสฺถิตึ ปฺราปฺตวนฺต: ส อีศฺวราทฺ ยุษฺมากํ ชฺญานํ ปุณฺยํ ปวิตฺรตฺวํ มุกฺติศฺจ ชาตาฯ ");
INSERT INTO santha_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","อเตอว ยทฺวทฺ ลิขิตมาเสฺต ตทฺวตฺ, ย: กศฺจิตฺ ศฺลาฆมาน: สฺยาตฺ ศฺลาฆตำ ปฺรภุนา ส หิฯ ");
INSERT INTO santha_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","เห ภฺราตโร ยุษฺมตฺสมีเป มมาคมนกาเล'หํ วกฺตฺฤตายา วิทฺยายา วา ไนปุเณฺยเนศฺวรสฺย สากฺษฺยํ ปฺรจาริตวานฺ ตนฺนหิ; ");
INSERT INTO santha_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ยโต ยีศุขฺรีษฺฏํ ตสฺย กฺรุเศ หตตฺวญฺจ วินา นานฺยตฺ กิมปิ ยุษฺมนฺมเธฺย ชฺญาปยิตุํ วิหิตํ พุทฺธวานฺฯ ");
INSERT INTO santha_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","อปรญฺจาตีว เทารฺพฺพลฺยภีติกมฺปยุกฺโต ยุษฺมาภิ: สารฺทฺธมาสํฯ ");
INSERT INTO santha_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","อปรํ ยุษฺมากํ วิศฺวาโส ยตฺ มานุษิกชฺญานสฺย ผลํ น ภเวตฺ กินฺตฺวีศฺวรียศกฺเต: ผลํ ภเวตฺ, ");
INSERT INTO santha_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ตทรฺถํ มม วกฺตฺฤตา มทียปฺรจารศฺจ มานุษิกชฺญานสฺย มธุรวากฺยสมฺพลิเตา นาสฺตำ กินฺตฺวาตฺมน: ศกฺเตศฺจ ปฺรมาณยุกฺตาวาสฺตำฯ ");
INSERT INTO santha_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","วยํ ชฺญานํ ภาษามเห ตจฺจ สิทฺธโลไก รฺชฺญานมิว มนฺยเต, ตทิหโลกสฺย ชฺญานํ นหิ, อิหโลกสฺย นศฺวราณามฺ อธิปตีนำ วา ชฺญานํ นหิ; ");
INSERT INTO santha_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","กินฺตุ กาลาวสฺถายา: ปูรฺวฺวสฺมาทฺ ยตฺ ชฺญานมฺ อสฺมากํ วิภวารฺถมฺ อีศฺวเรณ นิศฺจิตฺย ปฺรจฺฉนฺนํ ตนฺนิคูฒมฺ อีศฺวรียชฺญานํ ปฺรภาษามเหฯ ");
INSERT INTO santha_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","อิหโลกสฺยาธิปตีนำ เกนาปิ ตตฺ ชฺญานํ น ลพฺธํ, ลพฺเธ สติ เต ปฺรภาววิศิษฺฏํ ปฺรภุํ กฺรุเศ นาหนิษฺยนฺฯ ");
INSERT INTO santha_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ตทฺวลฺลิขิตมาเสฺต, เนเตฺรณ กฺกาปิ โน ทฺฤษฺฏํ กรฺเณนาปิ จ น ศฺรุตํฯ มโนมเธฺย ตุ กสฺยาปิ น ปฺรวิษฺฏํ กทาปิ ยตฺฯ อีศฺวเร ปฺรียมาณานำ กฺฤเต ตตฺ เตน สญฺจิตํฯ ");
INSERT INTO santha_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","อปรมีศฺวร: สฺวาตฺมนา ตทสฺมากํ สากฺษาตฺ ปฺรากาศยตฺ; ยต อาตฺมา สรฺวฺวเมวานุสนฺธตฺเต เตน เจศฺวรสฺย มรฺมฺมตตฺตฺวมปิ พุธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","มนุชสฺยานฺต:สฺถมาตฺมานํ วินา เกน มนุเชน ตสฺย มนุชสฺย ตตฺตฺวํ พุธฺยเต? ตทฺวทีศฺวรสฺยาตฺมานํ วินา เกนาปีศฺวรสฺย ตตฺตฺวํ น พุธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","วยญฺเจหโลกสฺยาตฺมานํ ลพฺธวนฺตสฺตนฺนหิ กินฺตฺวีศฺวรไสฺยวาตฺมานํ ลพฺธวนฺต:, ตโต เหโตรีศฺวเรณ สฺวปฺรสาทาทฺ อสฺมภฺยํ ยทฺ ยทฺ ทตฺตํ ตตฺสรฺวฺวมฺ อสฺมาภิ รฺชฺญาตุํ ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ตจฺจาสฺมาภิ รฺมานุษิกชฺญานสฺย วากฺยานิ ศิกฺษิตฺวา กถฺยต อิติ นหิ กินฺตฺวาตฺมโต วากฺยานิ ศิกฺษิตฺวาตฺมิไก รฺวาไกฺยราตฺมิกํ ภาวํ ปฺรกาศยทฺภิ: กถฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ปฺราณี มนุษฺย อีศฺวรียาตฺมน: ศิกฺษำ น คฺฤหฺลาติ ยต อาตฺมิกวิจาเรณ สา วิจารฺเยฺยติ เหโต: ส ตำ ปฺรลาปมิว มนฺยเต โพทฺธุญฺจ น ศกฺโนติฯ ");
INSERT INTO santha_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","อาตฺมิโก มานว: สรฺวฺวาณิ วิจารยติ กินฺตุ สฺวยํ เกนาปิ น วิจารฺยฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ยต อีศฺวรสฺย มโน ชฺญาตฺวา ตมุปเทษฺฏุํ ก: ศกฺโนติ? กินฺตุ ขฺรีษฺฏสฺย มโน'สฺมาภิ รฺลพฺธํฯ ");
INSERT INTO santha_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","เห ภฺราตร:, อหมาตฺมิไกริว ยุษฺมาภิ: สมํ สมฺภาษิตุํ นาศกฺนวํ กินฺตุ ศารีริกาจาริภิ: ขฺรีษฺฏธรฺมฺเม ศิศุตุไลฺยศฺจ ชไนริว ยุษฺมาภิ: สห สมภาเษฯ ");
INSERT INTO santha_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ยุษฺมานฺ กฐินภกฺษฺยํ น โภชยนฺ ทุคฺธมฺ อปายยํ ยโต ยูยํ ภกฺษฺยํ คฺรหีตุํ ตทา นาศกฺนุต อิทานีมปิ น ศกฺนุถ, ยโต เหโตรธุนาปิ ศารีริกาจาริณ อาเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ยุษฺมนฺมเธฺย มาตฺสรฺยฺยวิวาทเภทา ภวนฺติ ตต: กึ ศารีริกาจาริโณ นาเธฺว มานุษิกมารฺเคณ จ น จรถ? ");
INSERT INTO santha_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","เปาลสฺยาหมิตฺยาปโลฺลรหมิติ วา ยทฺวากฺยํ ยุษฺมากํ ไกศฺจิตฺ ไกศฺจิตฺ กถฺยเต ตสฺมาทฺ ยูยํ ศารีริกาจาริณ น ภวถ? ");
INSERT INTO santha_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","เปาล: ก:? อาปโลฺล รฺวา ก:? เตา ปริจารกมาเตฺรา ตโยเรไกกไสฺม จ ปฺรภุ รฺยาทฺฤกฺ ผลมททาตฺ ตทฺวตฺ ตโยรฺทฺวารา ยูยํ วิศฺวาสิโน ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","อหํ โรปิตวานฺ อาปโลฺลศฺจ นิษิกฺตวานฺ อีศฺวรศฺจาวรฺทฺธยตฺฯ ");
INSERT INTO santha_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","อโต โรปยิตฺฤเสกฺตาราวสาเรา วรฺทฺธยิเตศฺวร เอว สาร:ฯ ");
INSERT INTO santha_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","โรปยิตฺฤเสกฺตาเรา จ สเมา ตโยเรไกกศฺจ สฺวศฺรมโยคฺยํ สฺวเวตนํ ลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","อาวามีศฺวเรณ สห กรฺมฺมการิเณา, อีศฺวรสฺย ยตฺ เกฺษตฺรมฺ อีศฺวรสฺย ยา นิรฺมฺมิติ: สา ยูยเมวฯ ");
INSERT INTO santha_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","อีศฺวรสฺย ปฺรสาทาตฺ มยา ยตฺ ปทํ ลพฺธํ ตสฺมาตฺ ชฺญานินา คฺฤหการิเณว มยา ภิตฺติมูลํ สฺถาปิตํ ตทุปริ จาเนฺยน นิจียเตฯ กินฺตุ เยน ยนฺนิจียเต ตตฺ เตน วิวิจฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ยโต ยีศุขฺรีษฺฏรูปํ ยทฺ ภิตฺติมูลํ สฺถาปิตํ ตทนฺยตฺ กิมปิ ภิตฺติมูลํ สฺถาปยิตุํ เกนาปิ น ศกฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","เอตทฺภิตฺติมูลโสฺยปริ ยทิ เกจิตฺ สฺวรฺณรูปฺยมณิกาษฺฐตฺฤณนลานฺ นิจินฺวนฺติ, ");
INSERT INTO santha_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ตเรฺหฺยไกกสฺย กรฺมฺม ปฺรกาศิษฺยเต ยต: ส ทิวสสฺตตฺ ปฺรกาศยิษฺยติฯ ยโต หโตสฺตน ทิวเสน วหฺนิมเยโนเทตวฺยํ ตต เอไกกสฺย กรฺมฺม กีทฺฤศเมตสฺย ปรีกฺษา พหฺนินา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ยสฺย นิจยนรูปํ กรฺมฺม สฺถาสฺนุ ภวิษฺยติ ส เวตนํ ลปฺสฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ยสฺย จ กรฺมฺม ธกฺษฺยเต ตสฺย กฺษติ รฺภวิษฺยติ กินฺตุ วเหฺน รฺนิรฺคตชน อิว ส สฺวยํ ปริตฺราณํ ปฺราปฺสฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ยูยมฺ อีศฺวรสฺย มนฺทิรํ ยุษฺมนฺมเธฺย เจศฺวรสฺยาตฺมา นิวสตีติ กึ น ชานีถ? ");
INSERT INTO santha_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","อีศฺวรสฺย มนฺทิรํ เยน วินาศฺยเต โส'ปีศฺวเรณ วินาศยิษฺยเต ยต อีศฺวรสฺย มนฺทิรํ ปวิตฺรเมว ยูยํ ตุ ตนฺมนฺทิรมฺ อาเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","โกปิ สฺวํ น วญฺจยตำฯ ยุษฺมากํ กศฺจน เจทิหโลกสฺย ชฺญาเนน ชฺญานวานหมิติ พุธฺยเต ตรฺหิ ส ยตฺ ชฺญานี ภเวตฺ ตทรฺถํ มูโฒ ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ยสฺมาทิหโลกสฺย ชฺญานมฺ อีศฺวรสฺย สากฺษาตฺ มูฒตฺวเมวฯ เอตสฺมินฺ ลิขิตมปฺยาเสฺต, ตีกฺษฺณา ยา ชฺญานินำ พุทฺธิสฺตยา ตานฺ ธรตีศฺวร:ฯ ");
INSERT INTO santha_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ปุนศฺจฯ ชฺญานินำ กลฺปนา เวตฺติ ปรเมโศ นิรรฺถกา:ฯ ");
INSERT INTO santha_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","อเตอว โก'ปิ มนุไชราตฺมานํ น ศฺลาฆตำ ยต: สรฺวฺวาณิ ยุษฺมากเมว, ");
INSERT INTO santha_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","เปาล วา อาปโลฺล รฺวา ไกผา วา ชคทฺ วา ชีวนํ วา มรณํ วา วรฺตฺตมานํ วา ภวิษฺยทฺวา สรฺวฺวาเณฺยว ยุษฺมากํ, ");
INSERT INTO santha_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ยูยญฺจ ขฺรีษฺฏสฺย, ขฺรีษฺฏศฺเจศฺวรสฺยฯ ");
INSERT INTO santha_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","โลกา อสฺมานฺ ขฺรีษฺฏสฺย ปริจารกานฺ อีศฺวรสฺย นิคูฐวากฺยธนสฺยาธฺยกฺษำศฺจ มนฺยนฺตำฯ ");
INSERT INTO santha_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","กิญฺจ ธนาธฺยกฺเษณ วิศฺวสนีเยน ภวิตวฺยเมตเทว โลไก รฺยาจฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","อโต วิจารยทฺภิ รฺยุษฺมาภิรไนฺย: ไกศฺจินฺ มนุไช รฺวา มม ปรีกฺษณํ มยาตีว ลฆุ มนฺยเต 'หมปฺยาตฺมานํ น วิจารยามิฯ ");
INSERT INTO santha_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","มยา กิมปฺยปราทฺธมิตฺยหํ น เวทฺมิ กินฺเตฺวเตน มม นิรปราธตฺวํ น นิศฺจียเต ปฺรภุเรว มม วิจารยิตาสฺติฯ ");
INSERT INTO santha_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","อต อุปยุกฺตสมยาตฺ ปูรฺวฺวมฺ อรฺถต: ปฺรโภราคมนาตฺ ปูรฺวฺวํ ยุษฺมาภิ รฺวิจาโร น กฺริยตำฯ ปฺรภุราคตฺย ติมิเรณ ปฺรจฺฉนฺนานิ สรฺวฺวาณิ ทีปยิษฺยติ มนสำ มนฺตฺรณาศฺจ ปฺรกาศยิษฺยติ ตสฺมินฺ สมย อีศฺวราทฺ เอไกกสฺย ปฺรศํสา ภวิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","เห ภฺราตร: สรฺวฺวาเณฺยตานิ มยาตฺมานมฺ อาปลฺลวญฺโจทฺทิศฺย กถิตานิ ตไสฺยตตฺ การณํ ยุยํ ยถา ศาสฺตฺรียวิธิมติกฺรมฺย มานวมฺ อตีว นาทริษฺยธฺพ อีตฺถญฺไจเกน ไวปรีตฺยาทฺ อปเรณ น ศฺลาฆิษฺยธฺพ เอตาทฺฤศีํ ศิกฺษามาวโยรฺทฺฤษฺฏานฺตาตฺ ลปฺสฺยเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","อปราตฺ กสฺตฺวำ วิเศษยติ? ตุภฺยํ ยนฺน ทตฺต ตาทฺฤศํ กึ ธารยสิ? อทตฺเตเนว ทตฺเตน วสฺตุนา กุต: ศฺลาฆเส? ");
INSERT INTO santha_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","อิทานีเมว ยูยํ กึ ตฺฤปฺตา ลพฺธธนา วา? อสฺมาสฺววิทฺยมาเนษุ ยูยํ กึ ราชตฺวปทํ ปฺราปฺตา:? ยุษฺมากํ ราชตฺวํ มยาภิลษิตํ ยตเสฺตน ยุษฺมาภิ: สห วยมปิ ราชฺยำศิโน ภวิษฺยาม:ฯ ");
INSERT INTO santha_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","เปฺรริตา วยํ เศษา หนฺตวฺยาศฺเจเวศฺวเรณ นิทรฺศิตา:ฯ ยโต วยํ สรฺวฺวโลกานามฺ อรฺถต: สฺวรฺคียทูตานำ มานวานาญฺจ เกาตุกาสฺปทานิ ชาตา:ฯ ");
INSERT INTO santha_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ขฺรีษฺฏสฺย กฺฤเต วยํ มูฒา: กินฺตุ ยูยํ ขฺรีษฺเฏน ชฺญานิน:, วยํ ทุรฺพฺพลา ยูยญฺจ สพลา:, ยูยํ สมฺมานิตา วยญฺจาปมานิตา:ฯ ");
INSERT INTO santha_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","วยมทฺยาปิ กฺษุธารฺตฺตาสฺตฺฤษฺณารฺตฺตา วสฺตฺรหีนาสฺตาฑิตา อาศฺรมรหิตาศฺจ สนฺต: ");
INSERT INTO santha_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","กรฺมฺมณิ สฺวกรานฺ วฺยาปารยนฺตศฺจ ทุ:ไข: กาลํ ยาปยาม:ฯ ครฺหิไตรสฺมาภิราศี: กถฺยเต ทูรีกฺฤไต: สหฺยเต นินฺทิไต: ปฺรสาทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","วยมทฺยาปิ ชคต: สมฺมารฺชนีโยคฺยา อวกรา อิว สรฺไวฺว รฺมนฺยามเหฯ ");
INSERT INTO santha_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ยุษฺมานฺ ตฺรปยิตุมหเมตานิ ลิขามีติ นหิ กินฺตุ ปฺริยาตฺมชานิว ยุษฺมานฺ ปฺรโพธยามิฯ ");
INSERT INTO santha_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ยต: ขฺรีษฺฏธรฺมฺเม ยทฺยปิ ยุษฺมากํ ทศสหสฺราณิ วิเนตาโร ภวนฺติ ตถาปิ พหโว ชนกา น ภวนฺติ ยโต'หเมว สุสํวาเทน ยีศุขฺรีษฺเฏ ยุษฺมานฺ อชนยํฯ ");
INSERT INTO santha_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","อโต ยุษฺมานฺ วินเย'หํ ยูยํ มทนุคามิโน ภวตฯ ");
INSERT INTO santha_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","อิตฺยรฺถํ สรฺเวฺวษุ ธรฺมฺมสมาเชษุ สรฺวฺวตฺร ขฺรีษฺฏธรฺมฺมโยคฺยา เย วิธโย มโยปทิศฺยนฺเต ตานฺ โย ยุษฺมานฺ สฺมารยิษฺยเตฺยวมฺภูตํ ปฺรโภ: กฺฤเต ปฺริยํ วิศฺวาสินญฺจ มทียตนยํ ตีมถิยํ ยุษฺมากํ สมีปํ เปฺรษิตวานหํฯ ");
INSERT INTO santha_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","อปรมหํ ยุษฺมากํ สมีปํ น คมิษฺยามีติ พุทฺธฺวา ยุษฺมากํ กิยนฺโต โลกา ครฺวฺวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","กินฺตุ ยทิ ปฺรเภริจฺฉา ภวติ ตรฺหฺยหมวิลมฺพํ ยุษฺมตฺสมีปมุปสฺถาย เตษำ ทรฺปธฺมาตานำ โลกานำ วาจํ ชฺญาสฺยามีติ นหิ สามรฺถฺยเมว ชฺญาสฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ยสฺมาทีศฺวรสฺย ราชตฺวํ วาคฺยุกฺตํ นหิ กินฺตุ สามรฺถฺยยุกฺตํฯ ");
INSERT INTO santha_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ยุษฺมากํ กา วาญฺฉา? ยุษฺมตฺสมีเป มยา กึ ทณฺฑปาณินา คนฺตวฺยมุต เปฺรมนมฺรตาตฺมยุกฺเตน วา? ");
INSERT INTO santha_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","อปรํ ยุษฺมากํ มเธฺย วฺยภิจาโร วิทฺยเต ส จ วฺยภิจารสฺตาทฺฤโศ ยทฺ เทวปูชกานำ มเธฺย'ปิ ตตฺตุโลฺย น วิทฺยเต ผลโต ยุษฺมากเมโก ชโน วิมาตฺฤคมนํ กฺฤรุต อิติ วารฺตฺตา สรฺวฺวตฺร วฺยาปฺตาฯ ");
INSERT INTO santha_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ตถาจ ยูยํ ทรฺปธฺมาตา อาทฺเหฺพ, ตตฺ กรฺมฺม เยน กฺฤตํ ส ยถา ยุษฺมนฺมธฺยาทฺ ทูรีกฺริยเต ตถา โศโก ยุษฺมาภิ รฺน กฺริยเต กิมฺ เอตตฺ? ");
INSERT INTO santha_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","อวิทฺยมาเน มทียศรีเร มมาตฺมา ยุษฺมนฺมเธฺย วิทฺยเต อโต'หํ วิทฺยมาน อิว ตตฺกรฺมฺมการิโณ วิจารํ นิศฺจิตวานฺ, ");
INSERT INTO santha_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","อสฺมตฺปฺรโภ รฺยีศุขฺรีษฺฏสฺย นามฺนา ยุษฺมากํ มทียาตฺมนศฺจ มิลเน ชาเต 'สฺมตฺปฺรโภ รฺยีศุขฺรีษฺฏสฺย ศกฺเต: สาหาเยฺยน ");
INSERT INTO santha_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ส นร: ศรีรนาศารฺถมสฺมาภิ: ศยตาโน หเสฺต สมรฺปยิตวฺยสฺตโต'สฺมากํ ปฺรโภ รฺยีโศ รฺทิวเส ตสฺยาตฺมา รกฺษำ คนฺตุํ ศกฺษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ยุษฺมากํ ทรฺโป น ภทฺราย ยูยํ กิเมตนฺน ชานีถ, ยถา, วิการ: กฺฤตฺสฺนศกฺตูนำ สฺวลฺปกิเณฺวน ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ยูยํ ยตฺ นวีนศกฺตุสฺวรูปา ภเวต ตทรฺถํ ปุราตนํ กิณฺวมฺ อวมารฺชฺชต ยโต ยุษฺมาภิ: กิณฺวศูไนฺย รฺภวิตวฺยํฯ อปรมฺ อสฺมากํ นิสฺตาโรตฺสวียเมษศาวโก ย: ขฺรีษฺฏ: โส'สฺมทรฺถํ พลีกฺฤโต 'ภวตฺฯ ");
INSERT INTO santha_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","อต: ปุราตนกิเณฺวนารฺถโต ทุษฺฏตาชิฆำสารูเปณ กิเณฺวน ตนฺนหิ กินฺตุ สารลฺยสตฺยตฺวรูปยา กิณฺวศูนฺยตยาสฺมาภิรุตฺสว: กรฺตฺตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","วฺยาภิจาริณำ สํสรฺโค ยุษฺมาภิ รฺวิหาตวฺย อิติ มยา ปเตฺร ลิขิตํฯ ");
INSERT INTO santha_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","กินฺไตฺวหิกโลกานำ มเธฺย เย วฺยภิจาริโณ โลภิน อุปทฺราวิโณ เทวปูชกา วา เตษำ สํสรฺค: สรฺวฺวถา วิหาตวฺย อิติ นหิ, วิหาตเวฺย สติ ยุษฺมาภิ รฺชคโต นิรฺคนฺตวฺยเมวฯ ");
INSERT INTO santha_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","กินฺตุ ภฺราตฺฤเตฺวน วิขฺยาต: กศฺจิชฺชโน ยทิ วฺยภิจารี โลภี เทวปูชโก นินฺทโก มทฺยป อุปทฺราวี วา ภเวตฺ ตรฺหิ ตาทฺฤเศน มานเวน สห โภชนปาเน'ปิ ยุษฺมาภิ รฺน กรฺตฺตเวฺย อิตฺยธุนา มยา ลิขิตํฯ ");
INSERT INTO santha_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","สมาชพหิ:สฺถิตานำ โลกานำ วิจารกรเณ มม โก'ธิการ:? กินฺตุ ตทนฺตรฺคตานำ วิจารณํ ยุษฺมาภิ: กึ น กรฺตฺตวฺยํ ภเวตฺ? ");
INSERT INTO santha_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","พหิ:สฺถานำ ตุ วิจาร อีศฺวเรณ การิษฺยเตฯ อโต ยุษฺมาภิ: ส ปาตกี สฺวมธฺยาทฺ พหิษฺกฺริยตำฯ ");
INSERT INTO santha_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ยุษฺมากเมกสฺย ชนสฺยาปเรณ สห วิวาเท ชาเต ส ปวิตฺรโลไก รฺวิจารมการยนฺ กิมฺ อธารฺมฺมิกโลไก รฺวิจารยิตุํ โปฺรตฺสหเต? ");
INSERT INTO santha_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ชคโต'ปิ วิจารณํ ปวิตฺรโลไก: การิษฺยต เอตทฺ ยูยํ กึ น ชานีถ? อโต ชคทฺ ยทิ ยุษฺมาภิ รฺวิจารยิตวฺยํ ตรฺหิ กฺษุทฺรตมวิจาเรษุ ยูยํ กิมสมรฺถา:? ");
INSERT INTO santha_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ทูตา อปฺยสฺมาภิ รฺวิจารยิษฺยนฺต อิติ กึ น ชานีถ? อต ไอหิกวิษยา: กิมฺ อสฺมาภิ รฺน วิจารยิตวฺยา ภเวยุ:? ");
INSERT INTO santha_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ไอหิกวิษยสฺย วิจาเร ยุษฺมาภิ: กรฺตฺตเวฺย เย โลกา: สมิเตา กฺษุทฺรตมาสฺต เอว นิยุชฺยนฺตำฯ ");
INSERT INTO santha_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","อหํ ยุษฺมานฺ ตฺรปยิตุมิจฺฉนฺ วทามิ ยฺฤษฺมนฺมเธฺย กิเมโก'ปิ มนุษฺยสฺตาทฺฤคฺ พุทฺธิมานฺนหิ โย ภฺราตฺฤวิวาทวิจารเณ สมรฺถ: สฺยาตฺ? ");
INSERT INTO santha_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","กิญฺไจโก ภฺราตา ภฺราตฺราเนฺยน กิมวิศฺวาสินำ วิจารกาณำ สากฺษาทฺ วิวทเต? ยษฺมนฺมเธฺย วิวาทา วิทฺยนฺต เอตทปิ ยุษฺมากํ โทษ:ฯ ");
INSERT INTO santha_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ยูยํ กุโต'นฺยายสหนํ กฺษติสหนํ วา เศฺรโย น มนฺยเธฺว? ");
INSERT INTO santha_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","กินฺตุ ยูยมปิ ภฺราตฺฤเนว ปฺรตฺยนฺยายํ กฺษติญฺจ กุรุถ กิเมตตฺ? ");
INSERT INTO santha_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","อีศฺวรสฺย ราเชฺย'นฺยายการิณำ โลกานามธิกาโร นาสฺเตฺยตทฺ ยูยํ กึ น ชานีถ? มา วญฺจฺยธฺวํ, เย วฺยภิจาริโณ เทวารฺจฺจิน: ปารทาริกา: สฺตฺรีวทาจาริณ: ปุํไมถุนการิณสฺตสฺกรา ");
INSERT INTO santha_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","โลภิโน มทฺยปา นินฺทกา อุปทฺราวิโณ วา ต อีศฺวรสฺย ราชฺยภาคิโน น ภวิษฺยนฺติฯ ");
INSERT INTO santha_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ยูยญฺไจวํวิธา โลกา อาสฺต กินฺตุ ปฺรโภ รฺยีโศ รฺนามฺนาสฺมทีศฺวรสฺยาตฺมนา จ ยูยํ ปฺรกฺษาลิตา: ปาวิตา: สปุณฺยีกฺฤตาศฺจฯ ");
INSERT INTO santha_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","มทรฺถํ สรฺวฺวํ ทฺรวฺยมฺ อปฺรติษิทฺธํ กินฺตุ น สรฺวฺวํ หิตชนกํฯ มทรฺถํ สรฺวฺวมปฺรติษิทฺธํ ตถาปฺยหํ กสฺยาปิ ทฺรวฺยสฺย วศีกฺฤโต น ภวิษฺยามิฯ ");
INSERT INTO santha_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","อุทราย ภกฺษฺยาณิ ภกฺเษฺยภฺยศฺโจทรํ, กินฺตุ ภกฺโษฺยทเร อีศฺวเรณ นาศยิเษฺยเต; อปรํ เทโห น วฺยภิจาราย กินฺตุ ปฺรภเว ปฺรภุศฺจ เทหายฯ ");
INSERT INTO santha_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ยศฺเจศฺวร: ปฺรภุมุตฺถาปิตวานฺ ส สฺวศกฺตฺยาสฺมานปฺยุตฺถาปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ยุษฺมากํ ยานิ ศรีราณิ ตานิ ขฺรีษฺฏสฺยางฺคานีติ กึ ยูยํ น ชานีถ? อต: ขฺรีษฺฏสฺย ยานฺยงฺคานิ ตานิ มยาปหฺฤตฺย เวศฺยายา องฺคานิ กึ การิษฺยนฺเต? ตนฺน ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ย: กศฺจิทฺ เวศฺยายามฺ อาสชฺยเต ส ตยา สไหกเทโห ภวติ กึ ยูยเมตนฺน ชานีถ? ยโต ลิขิตมาเสฺต, ยถา, เตา เทฺวา ชนาเวกางฺเคา ภวิษฺยต:ฯ ");
INSERT INTO santha_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","มานวา ยานฺยนฺยานิ กลุษาณิ กุรฺวฺวเต ตานิ วปุ รฺน สมาวิศนฺติ กินฺตุ วฺยภิจาริณา สฺววิคฺรหสฺย วิรุทฺธํ กลฺมษํ กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","มานวา ยานฺยนฺยานิ กลุษาณิ กุรฺวฺวเต ตานิ วปุ รฺน สมาวิศนฺติ กินฺตุ วฺยภิจาริณา สฺววิคฺรหสฺย วิรุทฺธํ กลฺมษํ กฺริยเตฯ ");
INSERT INTO santha_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ยุษฺมากํ ยานิ วปูํสิ ตานิ ยุษฺมทนฺต:สฺถิตเสฺยศฺวราลฺลพฺธสฺย ปวิตฺรสฺยาตฺมโน มนฺทิราณิ ยูยญฺจ เสฺวษำ สฺวามิโน นาเธฺว กิเมตทฺ ยุษฺมาภิ รฺน ชฺญายเต? ");
INSERT INTO santha_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ยูยํ มูเลฺยน กฺรีตา อโต วปุรฺมโนภฺยามฺ อีศฺวโร ยุษฺมาภิ: ปูชฺยตำ ยต อีศฺวร เอว ตโย: สฺวามีฯ ");
INSERT INTO santha_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","อปรญฺจ ยุษฺมาภิ รฺมำ ปฺรติ ยตฺ ปตฺรมเลขิ ตโสฺยตฺตรเมตตฺ, โยษิโต'สฺปรฺศนํ มนุชสฺย วรํ; ");
INSERT INTO santha_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","กินฺตุ วฺยภิจารภยาทฺ เอไกกสฺย ปุํส: สฺวกียภารฺยฺยา ภวตุ ตทฺวทฺ เอไกกสฺยา โยษิโต 'ปิ สฺวกียภรฺตฺตา ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ภารฺยฺยาไย ภรฺตฺรา ยทฺยทฺ วิตรณียํ ตทฺ วิตีรฺยฺยตำ ตทฺวทฺ ภรฺเตฺร'ปิ ภารฺยฺยยา วิตรณียํ วิตีรฺยฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ภารฺยฺยายา: สฺวเทเห สฺวตฺวํ นาสฺติ ภรฺตฺตุเรว, ตทฺวทฺ ภรฺตฺตุรปิ สฺวเทเห สฺวตฺวํ นาสฺติ ภารฺยฺยายา เอวฯ ");
INSERT INTO santha_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","อุโปษณปฺรารฺถนโย: เสวนารฺถมฺ เอกมนฺตฺรณานำ ยุษฺมากํ กิยตฺกาลํ ยาวทฺ ยา ปฺฤถกฺสฺถิติ รฺภวติ ตทโนฺย วิจฺเฉโท ยุษฺมนฺมเธฺย น ภวตุ, ตต: ปรมฺ อินฺทฺริยาณามฺ อไธรฺยฺยาตฺ ศยตานฺ ยทฺ ยุษฺมานฺ ปรีกฺษำ น นเยตฺ ตทรฺถํ ปุนเรกตฺร มิลตฯ ");
INSERT INTO santha_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","เอตทฺ อาเทศโต นหิ กินฺตฺวนุชฺญาต เอว มยา กถฺยเต, ");
INSERT INTO santha_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ยโต มมาวเสฺถว สรฺวฺวมานวานามวสฺถา ภวตฺวิติ มม วาญฺฉา กินฺตฺวีศฺวราทฺ เอเกไนโก วโร'เนฺยน จาโนฺย วร อิตฺถเมไกเกน สฺวกียวโร ลพฺธ:ฯ ");
INSERT INTO santha_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","อปรมฺ อกฺฤตวิวาหานฺ วิธวาศฺจ ปฺรติ มไมตนฺนิเวทนํ มเมว เตษามวสฺถิติ รฺภทฺรา; ");
INSERT INTO santha_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","กิญฺจ ยทิ ไตรินฺทฺริยาณิ นิยนฺตุํ น ศกฺยนฺเต ตรฺหิ วิวาห: กฺริยตำ ยต: กามทหนาทฺ วฺยูฒตฺวํ ภทฺรํฯ ");
INSERT INTO santha_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","เย จ กฺฤตวิวาหาเสฺต มยา นหิ ปฺรภุไนไวตทฺ อาชฺญาปฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ภารฺยฺยา ภรฺตฺตฺฤต: ปฺฤถกฺ น ภวตุฯ ยทิ วา ปฺฤถคฺภูตา สฺยาตฺ ตรฺหิ นิรฺวิวาหา ติษฺฐตุ สฺวียปตินา วา สนฺทธาตุ ภรฺตฺตาปิ ภารฺยฺยำ น ตฺยชตุฯ ");
INSERT INTO santha_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","อิตรานฺ ชนานฺ ปฺรติ ปฺรภุ รฺน พฺรวีติ กินฺตฺวหํ พฺรวีมิ; กสฺยจิทฺ ภฺราตุโรฺยษิทฺ อวิศฺวาสินี สตฺยปิ ยทิ เตน สหวาเส ตุษฺยติ ตรฺหิ สา เตน น ตฺยชฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ตทฺวตฺ กสฺยาศฺจิทฺ โยษิต: ปติรวิศฺวาสี สนฺนปิ ยทิ ตยา สหวาเส ตุษฺยติ ตรฺหิ ส ตยา น ตฺยชฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ยโต'วิศฺวาสี ภรฺตฺตา ภารฺยฺยยา ปวิตฺรีภูต:, ตทฺวทวิศฺวาสินี ภารฺยฺยา ภรฺตฺรา ปวิตฺรีภูตา; โนเจทฺ ยุษฺมากมปตฺยานฺยศุจีนฺยภวิษฺยนฺ กินฺตฺวธุนา ตานิ ปวิตฺราณิ สนฺติฯ ");
INSERT INTO santha_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","อวิศฺวาสี ชโน ยทิ วา ปฺฤถคฺ ภวติ ตรฺหิ ปฺฤถคฺ ภวตุ; เอเตน ภฺราตา ภคินี วา น นิพธฺยเต ตถาปิ วยมีศฺวเรณ ศานฺตเย สมาหูตา:ฯ ");
INSERT INTO santha_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","เห นาริ ตว ภรฺตฺตุ: ปริตฺราณํ ตฺวตฺโต ภวิษฺยติ น เวติ ตฺวยา กึ ชฺญายเต? เห นร ตว ชายายา: ปริตฺราณํ ตฺวตฺเตा ภวิษฺยติ น เวติ ตฺวยา กึ ชฺญายเต? ");
INSERT INTO santha_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","เอไกโก ชน: ปรเมศฺวราลฺลพฺธํ ยทฺ ภชเต ยสฺยาญฺจาวสฺถายามฺ อีศฺวเรณาหฺวายิ ตทนุสาเรไณวาจรตุ ตทหํ สรฺวฺวสมาชสฺถานฺ อาทิศามิฯ ");
INSERT INTO santha_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ฉินฺนตฺวคฺ ภฺฤตฺวา ย อาหูต: ส ปฺรกฺฤษฺฏตฺวกฺ น ภวตุ, ตทฺวทฺ อฉินฺนตฺวคฺ ภูตฺวา ย อาหูต: ส ฉินฺนตฺวกฺ น ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ตฺวกฺเฉท: สาโร นหิ ตทฺวทตฺวกฺเฉโท'ปิ สาโร นหิ กินฺตฺวีศฺวรสฺยาชฺญานำ ปาลนเมวฯ ");
INSERT INTO santha_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","โย ชโน ยสฺยามวสฺถายามาหฺวายิ ส ตสฺยาเมวาวติษฺฐตำฯ ");
INSERT INTO santha_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ทาส: สนฺ ตฺวํ กิมาหูโต'สิ? ตนฺมา จินฺตย, ตถาจ ยทิ สฺวตนฺโตฺร ภวิตุํ ศกฺนุยาสฺตรฺหิ ตเทว วฺฤณุฯ ");
INSERT INTO santha_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ยต: ปฺรภุนาหูโต โย ทาส: ส ปฺรโภ โรฺมจิตชน:ฯ ตทฺวทฺ เตนาหูต: สฺวตนฺโตฺร ชโน'ปิ ขฺรีษฺฏสฺย ทาส เอวฯ ");
INSERT INTO santha_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ยูยํ มูเลฺยน กฺรีตา อโต เหโต รฺมานวานำ ทาสา มา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","เห ภฺราตโร ยสฺยามวสฺถายำ ยสฺยาหฺวานมภวตฺ ตยา ส อีศฺวรสฺย สากฺษาตฺ ติษฺฐตุฯ ");
INSERT INTO santha_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","อปรมฺ อกฺฤตวิวาหานฺ ชนานฺ ปฺรติ ปฺรโภ: โก'ปฺยาเทโศ มยา น ลพฺธ: กินฺตุ ปฺรโภรนุกมฺปยา วิศฺวาโสฺย ภูโต'หํ ยทฺ ภทฺรํ มเนฺย ตทฺ วทามิฯ ");
INSERT INTO santha_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","วรฺตฺตมานาตฺ เกฺลศสมยาตฺ มนุษฺยสฺยานูฒตฺวํ ภทฺรมิติ มยา พุธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ตฺวํ กึ โยษิติ นิพทฺโธ'สิ ตรฺหิ โมจนํ ปฺราปฺตุํ มา ยตสฺวฯ กึ วา โยษิโต มุกฺโต'สิ? ตรฺหิ ชายำ มา คเวษยฯ ");
INSERT INTO santha_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","วิวาหํ กุรฺวฺวตา ตฺวยา กิมปิ นาปาราธฺยเต ตทฺวทฺ วฺยูหฺยมานยา ยุวตฺยาปิ กิมปิ นาปราธฺยเต ตถาจ ตาทฺฤเศา เทฺวา ชเนา ศารีริกํ เกฺลศํ ลปฺเสฺยเต กินฺตุ ยุษฺมานฺ ปฺรติ มม กรุณา วิทฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","เห ภฺราตโร'หมิทํ พฺรวีมิ, อิต: ปรํ สมโย'ตีว สํกฺษิปฺต:, ");
INSERT INTO santha_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","อต: กฺฤตทาไรรกฺฤตทาไรริว รุททฺภิศฺจารุททฺภิริว สานนฺไทศฺจ นิรานนฺไทริว เกฺรตฺฤภิศฺจาภาคิภิริวาจริตวฺยํ ");
INSERT INTO santha_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","เย จ สํสาเร จรนฺติ ไต รฺนาติจริตวฺยํ ยต อิหเลाกสฺย เกาตุโก วิจลติฯ ");
INSERT INTO santha_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","กินฺตุ ยูยํ ยนฺนิศฺจินฺตา ภเวเตติ มม วาญฺฉาฯ อกฺฤตวิวาโห ชโน ยถา ปฺรภุํ ปริโตษเยตฺ ตถา ปฺรภุํ จินฺตยติ, ");
INSERT INTO santha_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","กินฺตุ กฺฤตวิวาโห ชโน ยถา ภารฺยฺยำ ปริโตษเยตฺ ตถา สํสารํ จินฺตยติฯ ");
INSERT INTO santha_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ตทฺวทฺ อูฒโยษิโต 'นูฒา วิศิษฺยเตฯ ยานูฒา สา ยถา กายมนโส: ปวิตฺรา ภเวตฺ ตถา ปฺรภุํ จินฺตยติ ยา โจฒา สา ยถา ภรฺตฺตารํ ปริโตษเยตฺ ตถา สํสารํ จินฺตยติฯ ");
INSERT INTO santha_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","อหํ ยทฺ ยุษฺมานฺ มฺฤคพนฺธินฺยา ปริกฺษิเปยํ ตทรฺถํ นหิ กินฺตุ ยูยํ ยทนินฺทิตา ภูตฺวา ปฺรโภ: เสวเน'พาธมฺ อาสกฺตา ภเวต ตทรฺถเมตานิ สรฺวฺวาณิ ยุษฺมากํ หิตาย มยา กถฺยนฺเตฯ ");
INSERT INTO santha_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","กสฺยจิตฺ กนฺยายำ เยาวนปฺราปฺตายำ ยทิ ส ตสฺยา อนูฒตฺวํ นินฺทนียํ วิวาหศฺจ สาธยิตวฺย อิติ มนฺยเต ตรฺหิ ยถาภิลาษํ กโรตุ, เอเตน กิมปิ นาปราตฺสฺยติ วิวาห: กฺริยตำฯ ");
INSERT INTO santha_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","กินฺตุ ทุ:เขนากฺลิษฺฏ: กศฺจิตฺ ปิตา ยทิ สฺถิรมโนคต: สฺวมโน'ภิลาษสาธเน สมรฺถศฺจ สฺยาตฺ มม กนฺยา มยา รกฺษิตเวฺยติ มนสิ นิศฺจิโนติ จ ตรฺหิ ส ภทฺรํ กรฺมฺม กโรติฯ ");
INSERT INTO santha_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","อโต โย วิวาหํ กโรติ ส ภทฺรํ กรฺมฺม กโรติ ยศฺจ วิวาหํ น กโรติ ส ภทฺรตรํ กรฺมฺม กโรติฯ ");
INSERT INTO santha_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ยาวตฺกาลํ ปติ รฺชีวติ ตาวทฺ ภารฺยฺยา วฺยวสฺถยา นิพทฺธา ติษฺฐติ กินฺตุ ปเตฺยา มหานิทฺรำ คเต สา มุกฺตีภูย ยมภิลษติ เตน สห ตสฺยา วิวาโห ภวิตุํ ศกฺโนติ, กินฺเตฺวตตฺ เกวลํ ปฺรภุภกฺตานำ มเธฺยฯ ");
INSERT INTO santha_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ตถาจ สา ยทิ นิษฺปติกา ติษฺฐติ ตรฺหิ ตสฺยา: เกฺษมํ ภวิษฺยตีติ มม ภาว:ฯ อปรมฺ อีศฺวรสฺยาตฺมา มมาปฺยนฺต รฺวิทฺยต อิติ มยา พุธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","เทวปฺรสาเท สรฺเวฺวษามฺ อสฺมากํ ชฺญานมาเสฺต ตทฺวยํ วิทฺม:ฯ ตถาปิ ชฺญานํ ครฺวฺวํ ชนยติ กินฺตุ เปฺรมโต นิษฺฐา ชายเตฯ ");
INSERT INTO santha_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","อต: กศฺจน ยทิ มนฺยเต มม ชฺญานมาสฺต อิติ ตรฺหิ เตน ยาทฺฤศํ ชฺญานํ เจษฺฏิตวฺยํ ตาทฺฤศํ กิมปิ ชฺญานมทฺยาปิ น ลพฺธํฯ ");
INSERT INTO santha_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","กินฺตุ ย อีศฺวเร ปฺรียเต ส อีศฺวเรณาปิ ชฺญายเตฯ ");
INSERT INTO santha_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","เทวตาพลิปฺรสาทภกฺษเณ วยมิทํ วิทฺโม ยตฺ ชคนฺมเธฺย โก'ปิ เทโว น วิทฺยเต, เอกศฺเจศฺวโร ทฺวิตีโย นาสฺตีติฯ ");
INSERT INTO santha_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","สฺวรฺเค ปฺฤถิวฺยำ วา ยทฺยปิ เกษุจิทฺ อีศฺวร อิติ นามาโรปฺยเต ตาทฺฤศาศฺจ พหว อีศฺวรา พหวศฺจ ปฺรภโว วิทฺยนฺเต ");
INSERT INTO santha_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ตถาปฺยสฺมากมทฺวิตีย อีศฺวร: ส ปิตา ยสฺมาตฺ สรฺเวฺวษำ ยทรฺถญฺจาสฺมากํ สฺฤษฺฏิ รฺชาตา, อสฺมากญฺจาทฺวิตีย: ปฺรภุ: ส ยีศุ: ขฺรีษฺโฏ เยน สรฺวฺววสฺตูนำ เยนาสฺมากมปิ สฺฤษฺฏิ: กฺฤตาฯ ");
INSERT INTO santha_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","อธิกนฺตุ ชฺญานํ สรฺเวฺวษำ นาสฺติ ยต: เกจิททฺยาปิ เทวตำ สมฺมนฺย เทวปฺรสาทมิว ตทฺ ภกฺษฺยํ ภุญฺชเต เตน ทุรฺพฺพลตยา เตษำ สฺวานฺตานิ มลีมสานิ ภวนฺติฯ ");
INSERT INTO santha_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","กินฺตุ ภกฺษฺยทฺรวฺยาทฺ วยมฺ อีศฺวเรณ คฺราหฺยา ภวามสฺตนฺนหิ ยโต ภุงฺกฺตฺวา วยมุตฺกฺฤษฺฏา น ภวามสฺตทฺวทภุงฺกฺตฺวาปฺยปกฺฤษฺฏา น ภวาม:ฯ ");
INSERT INTO santha_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","อโต ยุษฺมากํ ยา กฺษมตา สา ทุรฺพฺพลานามฺ อุนฺมาถสฺวรูปา ยนฺน ภเวตฺ ตทรฺถํ สาวธานา ภวตฯ ");
INSERT INTO santha_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ยโต ชฺญานวิศิษฺฏสฺตฺวํ ยทิ เทวาลเย อุปวิษฺฏ: เกนาปิ ทฺฤศฺยเส ตรฺหิ ตสฺย ทุรฺพฺพลสฺย มนสิ กึ ปฺรสาทภกฺษณ อุตฺสาโห น ชนิษฺยเต? ");
INSERT INTO santha_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ตถา สติ ยสฺย กฺฤเต ขฺรีษฺโฏ มมาร ตว ส ทุรฺพฺพโล ภฺราตา ตว ชฺญานาตฺ กึ น วินํกฺษฺยติ? ");
INSERT INTO santha_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","อิตฺยเนน ปฺรกาเรณ ภฺราตฺฤณำ วิรุทฺธมฺ อปราธฺยทฺภิเสฺตษำ ทุรฺพฺพลานิ มนำสิ วฺยาฆาตยทฺภิศฺจ ยุษฺมาภิ: ขฺรีษฺฏสฺย ไวปรีเตฺยนาปราธฺยเตฯ ");
INSERT INTO santha_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","อโต เหโต: ปิศิตาศนํ ยทิ มม ภฺราตุ รฺวิฆฺนสฺวรูปํ ภเวตฺ ตรฺหฺยหํ ยตฺ สฺวภฺราตุ รฺวิฆฺนชนโก น ภเวยํ ตทรฺถํ ยาวชฺชีวนํ ปิศิตํ น โภกฺเษฺยฯ ");
INSERT INTO santha_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","อหํ กิมฺ เอก: เปฺรริโต นาสฺมิ? กิมหํ สฺวตนฺโตฺร นาสฺมิ? อสฺมากํ ปฺรภุ รฺยีศุ: ขฺรีษฺฏ: กึ มยา นาทรฺศิ? ยูยมปิ กึ ปฺรภุนา มทียศฺรมผลสฺวรูปา น ภวถ? ");
INSERT INTO santha_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","อนฺยโลกานำ กฺฤเต ยทฺยปฺยหํ เปฺรริโต น ภเวยํ ตถาจ ยุษฺมตฺกฺฤเต เปฺรริโต'สฺมิ ยต: ปฺรภุนา มม เปฺรริตตฺวปทสฺย มุทฺราสฺวรูปา ยูยเมวาเธฺวฯ ");
INSERT INTO santha_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","เย โลกา มยิ โทษมาโรปยนฺติ ตานฺ ปฺรติ มม ปฺรตฺยุตฺตรเมตตฺฯ ");
INSERT INTO santha_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","โภชนปานโย: กิมสฺมากํ กฺษมตา นาสฺติ? ");
INSERT INTO santha_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","อเนฺย เปฺรริตา: ปฺรโภ รฺภฺราตเรา ไกผาศฺจ ยตฺ กุรฺวฺวนฺติ ตทฺวตฺ กาญฺจิตฺ ธรฺมฺมภคินีํ วฺยูหฺย ตยา สารฺทฺธํ ปรฺยฺยฏิตุํ วยํ กึ น ศกฺนุม:? ");
INSERT INTO santha_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","สำสาริกศฺรมสฺย ปริตฺยาคาตฺ กึ เกวลมหํ พรฺณพฺพาศฺจ นิวาริเตา? ");
INSERT INTO santha_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","นิชธนวฺยเยน ก: สํคฺรามํ กโรติ? โก วา ทฺรากฺษากฺเษตฺรํ กฺฤตฺวา ตตฺผลานิ น ภุงฺกฺเต? โก วา ปศุวฺรชํ ปาลยนฺ ตตฺปโย น ปิวติ? ");
INSERT INTO santha_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","กิมหํ เกวลำ มานุษิกำ วาจํ วทามิ? วฺยวสฺถายำ กิเมตาทฺฤศํ วจนํ น วิทฺยเต? ");
INSERT INTO santha_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","มูสาวฺยวสฺถาคฺรนฺเถ ลิขิตมาเสฺต, ตฺวํ ศสฺยมรฺทฺทกวฺฤษสฺยาสฺยํ น ภํตฺสฺยสีติฯ อีศฺวเรณ พลีวรฺทฺทานาเมว จินฺตา กึ กฺริยเต? ");
INSERT INTO santha_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","กึ วา สรฺวฺวถาสฺมากํ กฺฤเต ตทฺวจนํ เตโนกฺตํ? อสฺมากเมว กฺฤเต ตลฺลิขิตํฯ ย: เกฺษตฺรํ กรฺษติ เตน ปฺรตฺยาศายุกฺเตน กรฺษฺฏวฺยํ, ยศฺจ ศสฺยานิ มรฺทฺทยติ เตน ลาภปฺรตฺยาศายุกฺเตน มรฺทฺทิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ยุษฺมตฺกฺฤเต'สฺมาภิ: ปารตฺริกาณิ พีชานิ โรปิตานิ, อโต ยุษฺมากไมหิกผลานำ วยมฺ อํศิโน ภวิษฺยาม: กิเมตตฺ มหตฺ กรฺมฺม? ");
INSERT INTO santha_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ยุษฺมาสุ โย'ธิการสฺตสฺย ภาคิโน ยทฺยเนฺย ภเวยุสฺตรฺหฺยสฺมาภิสฺตโต'ธิกํ กึ ตสฺย ภาคิภิ รฺน ภวิตวฺยํ? อธิกนฺตุ วยํ เตนาธิกาเรณ น วฺยวหฺฤตวนฺต: กินฺตุ ขฺรีษฺฏียสุสํวาทสฺย โก'ปิ วฺยาฆาโต'สฺมาภิรฺยนฺน ชาเยต ตทรฺถํ สรฺวฺวํ สหามเหฯ ");
INSERT INTO santha_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","อปรํ เย ปวิตฺรวสฺตูนำ ปริจรฺยฺยำ กุรฺวฺวนฺติ เต ปวิตฺรวสฺตุโต ภกฺษฺยาณิ ลภนฺเต, เย จ เวทฺยา: ปริจรฺยฺยำ กุรฺวฺวนฺติ เต เวทิสฺถวสฺตูนามฺ อํศิโน ภวนฺเตฺยตทฺ ยูยํ กึ น วิท? ");
INSERT INTO santha_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ตทฺวทฺ เย สุสํวาทํ โฆษยนฺติ ไต: สุสํวาเทน ชีวิตวฺยมิติ ปฺรภุนาทิษฺฏํฯ ");
INSERT INTO santha_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","อหเมเตษำ สรฺเวฺวษำ กิมปิ นาศฺริตวานฺ มำ ปฺรติ ตทนุสาราตฺ อาจริตวฺยมิตฺยาศเยนาปิ ปตฺรมิทํ มยา น ลิขฺยเต ยต: เกนาปิ ชเนน มม ยศโส มุธากรณาตฺ มม มรณํ วรํฯ ");
INSERT INTO santha_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","สุสํวาทเฆษณาตฺ มม ยโศ น ชายเต ยตสฺตทฺโฆษณํ มมาวศฺยกํ ยทฺยหํ สุสํวาทํ น โฆษเยยํ ตรฺหิ มำ ธิกฺฯ ");
INSERT INTO santha_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","อิจฺฉุเกน ตตฺ กุรฺวฺวตา มยา ผลํ ลปฺสฺยเต กินฺตฺวนิจฺฉุเก'ปิ มยิ ตตฺกรฺมฺมโณ ภาโร'รฺปิโต'สฺติฯ ");
INSERT INTO santha_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","เอเตน มยา ลภฺยํ ผลํ กึ? สุสํวาเทน มม โย'ธิการ อาเสฺต ตํ ยทภทฺรภาเวน นาจเรยํ ตทรฺถํ สุสํวาทโฆษณสมเย ตสฺย ขฺรีษฺฏียสุสํวาทสฺย นิรฺวฺยยีกรณเมว มม ผลํฯ ");
INSERT INTO santha_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","สรฺเวฺวษามฺ อนายตฺโต'หํ ยทฺ ภูริโศ โลกานฺ ปฺรติปเทฺย ตทรฺถํ สรฺเวฺวษำ ทาสตฺวมงฺคีกฺฤตวานฺฯ ");
INSERT INTO santha_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ยิหูทียานฺ ยตฺ ปฺรติปเทฺย ตทรฺถํ ยิหูทียานำ กฺฤเต ยิหูทียอิวาภวํฯ เย จ วฺยวสฺถายตฺตาสฺตานฺ ยตฺ ปฺรติปเทฺย ตทรฺถํ วฺยวสฺถานายตฺโต โย'หํ โส'หํ วฺยวสฺถายตฺตานำ กฺฤเต วฺยวสฺถายตฺตอิวาภวํฯ ");
INSERT INTO santha_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","เย จาลพฺธวฺยวสฺถาสฺตานฺ ยตฺ ปฺรติปเทฺย ตทรฺถมฺ อีศฺวรสฺย สากฺษาทฺ อลพฺธวฺยวโสฺถ น ภูตฺวา ขฺรีษฺเฏน ลพฺธวฺยวโสฺถ โย'หํ โส'หมฺ อลพฺธวฺยวสฺถานำ กฺฤเต'ลพฺธวฺยวสฺถ อิวาภวํฯ ");
INSERT INTO santha_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ทุรฺพฺพลานฺ ยตฺ ปฺรติปเทฺย ตทรฺถมหํ ทุรฺพฺพลานำ กฺฤเต ทุรฺพฺพลอิวาภวํฯ อิตฺถํ เกนาปิ ปฺรกาเรณ กติปยา โลกา ยนฺมยา ปริตฺราณํ ปฺราปฺนุยุสฺตทรฺถํ โย ยาทฺฤศ อาสีตฺ ตสฺย กฺฤเต 'หํ ตาทฺฤศอิวาภวํฯ ");
INSERT INTO santha_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","อิทฺฤศ อาจาร: สุสํวาทารฺถํ มยา กฺริยเต ยโต'หํ ตสฺย ผลานำ สหภาคี ภวิตุมิจฺฉามิฯ ");
INSERT INTO santha_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ปณฺยลาภารฺถํ เย ธาวนฺติ ธาวตำ เตษำ สรฺเวฺวษำ เกวล เอก: ปณฺยํ ลภเต ยุษฺมาภิ: กิเมตนฺน ชฺญายเต? อโต ยูยํ ยถา ปณฺยํ ลปฺสฺยเธฺว ตไถว ธาวตฯ ");
INSERT INTO santha_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","มลฺลา อปิ สรฺวฺวโภเค ปริมิตโภคิโน ภวนฺติ เต ตุ มฺลานำ สฺรชํ ลิปฺสนฺเต กินฺตุ วยมฺ อมฺลานำ ลิปฺสามเหฯ ");
INSERT INTO santha_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ตสฺมาทฺ อหมปิ ธาวามิ กินฺตุ ลกฺษฺยมนุทฺทิศฺย ธาวามิ ตนฺนหิฯ อหํ มลฺลอิว ยุธฺยามิ จ กินฺตุ ฉายามาฆาตยนฺนิว ยุธฺยามิ ตนฺนหิฯ ");
INSERT INTO santha_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","อิตรานฺ ปฺรติ สุสํวาทํ โฆษยิตฺวาหํ ยตฺ สฺวยมคฺราโหฺย น ภวามิ ตทรฺถํ เทหมฺ อาหนฺมิ วศีกุรฺเวฺว จฯ ");
INSERT INTO santha_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","เห ภฺราตร:, อสฺมตฺปิตฺฤปุรุษานธิ ยูยํ ยทชฺญาตา น ติษฺฐเตติ มม วาญฺฉา, เต สรฺเวฺว เมฆาธ:สฺถิตา พภูวุ: สรฺเวฺว สมุทฺรมเธฺยน ววฺรชุ:, ");
INSERT INTO santha_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","สรฺเวฺว มูสามุทฺทิศฺย เมฆสมุทฺรโย รฺมชฺชิตา พภูวุ: ");
INSERT INTO santha_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","สรฺวฺว เอกมฺ อาตฺมิกํ ภกฺษฺยํ พุภุชิร เอกมฺ อาตฺมิกํ เปยํ ปปุศฺจ ");
INSERT INTO santha_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ยตเสฺต'นุจรต อาตฺมิกาทฺ อจลาตฺ ลพฺธํ โตยํ ปปุ: โส'จล: ขฺรีษฺเฏอวฯ ");
INSERT INTO santha_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ตถา สตฺยปิ เตษำ มเธฺย'ธิเกษุ โลเกษฺวีศฺวโร น สนฺตุโตเษติ เหโตเสฺต ปฺรนฺตเร นิปาติตา:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","เอตสฺมินฺ เต 'สฺมากํ นิทรฺศนสฺวรูปา พภูวุ:; อตเสฺต ยถา กุตฺสิตาภิลาษิโณ พภูวุรสฺมาภิสฺตถา กุตฺสิตาภิลาษิภิ รฺน ภวิตวฺยํฯ ");
INSERT INTO santha_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ลิขิตมาเสฺต, โลกา โภกฺตุํ ปาตุญฺโจปวิวิศุสฺตต: กฺรีฑิตุมุตฺถิตา อิตยเนน ปฺรกาเรณ เตษำ ไกศฺจิทฺ ยทฺวทฺ เทวปูชา กฺฤตา ยุษฺมาภิสฺตทฺวตฺ น กฺริยตำฯ ");
INSERT INTO santha_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","อปรํ เตษำ ไกศฺจิทฺ ยทฺวทฺ วฺยภิจาร: กฺฤตเสฺตน ไจกสฺมินฺ ทิเน ตฺรโยวึศติสหสฺราณิ โลกา นิปาติตาสฺตทฺวทฺ อสฺมาภิ รฺวฺยภิจาโร น กรฺตฺตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","เตษำ เกจิทฺ ยทฺวตฺ ขฺรีษฺฏํ ปรีกฺษิตวนฺตสฺตสฺมาทฺ ภุชงฺไค รฺนษฺฏาศฺจ ตทฺวทฺ อสฺมาภิ: ขฺรีษฺโฏ น ปรีกฺษิตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","เตษำ เกจิทฺ ยถา วากฺกลหํ กฺฤตวนฺตสฺตตฺการณาตฺ หนฺตฺรา วินาศิตาศฺจ ยุษฺมาภิสฺตทฺวทฺ วากฺกลโห น กฺริยตำฯ ");
INSERT INTO santha_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ตานฺ ปฺรติ ยาเนฺยตานิ ชฆฏิเร ตานฺยสฺมากํ นิทรฺศนานิ ชคต: เศษยุเค วรฺตฺตมานานามฺ อสฺมากํ ศิกฺษารฺถํ ลิขิตานิ จ พภูวุ:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","อเตอว ย: กศฺจิทฺ สุสฺถิรํมนฺย: ส ยนฺน ปเตตฺ ตตฺร สาวธาโน ภวตุฯ ");
INSERT INTO santha_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","มานุษิกปรีกฺษาติริกฺตา กาปิ ปรีกฺษา ยุษฺมานฺ นากฺรามตฺ, อีศฺวรศฺจ วิศฺวาสฺย: โส'ติศกฺตฺยำ ปรีกฺษายำ ปตนาตฺ ยุษฺมานฺ รกฺษิษฺยติ, ปรีกฺษา จ ยทฺ ยุษฺมาภิ: โสฒุํ ศกฺยเต ตทรฺถํ ตยา สห นิสฺตารสฺย ปนฺถานํ นิรูปยิษฺยติฯ ");
INSERT INTO santha_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","เห ปฺริยภฺราตร:, เทวปูชาโต ทูรมฺ อปสรตฯ ");
INSERT INTO santha_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","อหํ ยุษฺมานฺ วิชฺญานฺ มตฺวา ปฺรภาเษ มยา ยตฺ กถฺยเต ตทฺ ยุษฺมาภิ รฺวิวิจฺยตำฯ ");
INSERT INTO santha_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ยทฺ ธนฺยวาทปาตฺรมฺ อสฺมาภิ รฺธนฺยํ คทฺยเต ตตฺ กึ ขฺรีษฺฏสฺย โศณิตสฺย สหภาคิตฺวํ นหิ? ยศฺจ ปูโป'สฺมาภิ รฺภชฺยเต ส กึ ขฺรีษฺฏสฺย วปุษ: สหภาคิตฺวํ นหิ? ");
INSERT INTO santha_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","วยํ พหว: สนฺโต'เปฺยกปูปสฺวรูปา เอกวปุ:สฺวรูปาศฺจ ภวาม:, ยโต วยํ สรฺวฺว เอกปูปสฺย สหภาคิน:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ยูยํ ศารีริกมฺ อิสฺราเยลียวํศํ นิรีกฺษธฺวํฯ เย พลีนำ มำสานิ ภุญฺชเต เต กึ ยชฺญเวทฺยา: สหภาคิโน น ภวนฺติ? ");
INSERT INTO santha_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","อิตฺยเนน มยา กึ กถฺยเต? เทวตา วาสฺตวิกี เทวตาไย พลิทานํ วา วาสฺตวิกํ กึ ภเวตฺ? ");
INSERT INTO santha_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ตนฺนหิ กินฺตุ ภินฺนชาติภิ เรฺย พลโย ทียนฺเต ต อีศฺวราย ตนฺนหิ ภูเตภฺเยอว ทียนฺเต ตสฺมาทฺ ยูยํ ยทฺ ภูตานำ สหภาคิโน ภวเถตฺยหํ นาภิลษามิฯ ");
INSERT INTO santha_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ปฺรโภ: กํเสน ภูตานามปิ กํเสน ปานํ ยุษฺมาภิรสาธฺยํ; ยูยํ ปฺรโภ โรฺภชฺยสฺย ภูตานามปิ โภชฺยสฺย สหภาคิโน ภวิตุํ น ศกฺนุถฯ ");
INSERT INTO santha_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","วยํ กึ ปฺรภุํ สฺปรฺทฺธิษฺยามเห? วยํ กึ ตสฺมาทฺ พลวนฺต:? ");
INSERT INTO santha_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","มำ ปฺรติ สรฺวฺวํ กรฺมฺมาปฺรติษิทฺธํ กินฺตุ น สรฺวฺวํ หิตชนกํ สรฺวฺวมฺ อปฺรติษิทฺธํ กินฺตุ น สรฺวฺวํ นิษฺฐาชนกํฯ ");
INSERT INTO santha_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","อาตฺมหิต: เกนาปิ น เจษฺฏิตวฺย: กินฺตุ สรฺไวฺว: ปรหิตศฺเจษฺฏิตวฺย:ฯ ");
INSERT INTO santha_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","อาป