﻿USE sofia;
DROP TABLE IF EXISTS sofia.santel_vpl;
CREATE TABLE santel_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES santel_vpl WRITE;
INSERT INTO santel_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ఇబ్రాహీమః సన్తానో దాయూద్ తస్య సన్తానో యీశుఖ్రీష్టస్తస్య పూర్వ్వపురుషవంశశ్రేణీ| ");
INSERT INTO santel_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ఇబ్రాహీమః పుత్ర ఇస్హాక్ తస్య పుత్రో యాకూబ్ తస్య పుత్రో యిహూదాస్తస్య భ్రాతరశ్చ| ");
INSERT INTO santel_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","తస్మాద్ యిహూదాతస్తామరో గర్భే పేరస్సేరహౌ జజ్ఞాతే, తస్య పేరసః పుత్రో హిష్రోణ్ తస్య పుత్రో ఽరామ్| ");
INSERT INTO santel_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","తస్య పుత్రో ఽమ్మీనాదబ్ తస్య పుత్రో నహశోన్ తస్య పుత్రః సల్మోన్| ");
INSERT INTO santel_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","తస్మాద్ రాహబో గర్భే బోయమ్ జజ్ఞే, తస్మాద్ రూతో గర్భే ఓబేద్ జజ్ఞే, తస్య పుత్రో యిశయః| ");
INSERT INTO santel_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","తస్య పుత్రో దాయూద్ రాజః తస్మాద్ మృతోరియస్య జాయాయాం సులేమాన్ జజ్ఞే| ");
INSERT INTO santel_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","తస్య పుత్రో రిహబియామ్, తస్య పుత్రోఽబియః, తస్య పుత్ర ఆసా:| ");
INSERT INTO santel_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","తస్య సుతో యిహోశాఫట్ తస్య సుతో యిహోరామ తస్య సుత ఉషియః| ");
INSERT INTO santel_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","తస్య సుతో యోథమ్ తస్య సుత ఆహమ్ తస్య సుతో హిష్కియః| ");
INSERT INTO santel_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","తస్య సుతో మినశిః, తస్య సుత ఆమోన్ తస్య సుతో యోశియః| ");
INSERT INTO santel_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","బాబిల్నగరే ప్రవసనాత్ పూర్వ్వం స యోశియో యిఖనియం తస్య భ్రాతృంశ్చ జనయామాస| ");
INSERT INTO santel_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","తతో బాబిలి ప్రవసనకాలే యిఖనియః శల్తీయేలం జనయామాస, తస్య సుతః సిరుబ్బావిల్| ");
INSERT INTO santel_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","తస్య సుతో ఽబోహుద్ తస్య సుత ఇలీయాకీమ్ తస్య సుతోఽసోర్| ");
INSERT INTO santel_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","అసోరః సుతః సాదోక్ తస్య సుత ఆఖీమ్ తస్య సుత ఇలీహూద్| ");
INSERT INTO santel_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","తస్య సుత ఇలియాసర్ తస్య సుతో మత్తన్| ");
INSERT INTO santel_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","తస్య సుతో యాకూబ్ తస్య సుతో యూషఫ్ తస్య జాయా మరియమ్; తస్య గర్భే యీశురజని, తమేవ ఖ్రీష్టమ్ (అర్థాద్ అభిషిక్తం) వదన్తి| ");
INSERT INTO santel_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ఇత్థమ్ ఇబ్రాహీమో దాయూదం యావత్ సాకల్యేన చతుర్దశపురుషాః; ఆ దాయూదః కాలాద్ బాబిలి ప్రవసనకాలం యావత్ చతుర్దశపురుషా భవన్తి| బాబిలి ప్రవాసనకాలాత్ ఖ్రీష్టస్య కాలం యావత్ చతుర్దశపురుషా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","యీశుఖ్రీష్టస్య జన్మ కథ్థతే| మరియమ్ నామికా కన్యా యూషఫే వాగ్దత్తాసీత్, తదా తయోః సఙ్గమాత్ ప్రాక్ సా కన్యా  పవిత్రేణాత్మనా గర్భవతీ బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","తత్ర తస్యాః పతి ర్యూషఫ్ సౌజన్యాత్ తస్యాః కలఙ్గం ప్రకాశయితుమ్ అనిచ్ఛన్ గోపనేనే తాం పారిత్యక్తుం మనశ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","స తథైవ భావయతి, తదానీం పరమేశ్వరస్య దూతః స్వప్నే తం దర్శనం దత్త్వా వ్యాజహార, హే దాయూదః సన్తాన యూషఫ్ త్వం నిజాం జాయాం మరియమమ్ ఆదాతుం మా భైషీః| ");
INSERT INTO santel_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","యతస్తస్యా గర్భః పవిత్రాదాత్మనోఽభవత్, సా చ పుత్రం ప్రసవిష్యతే, తదా త్వం తస్య నామ యీశుమ్ (అర్థాత్ త్రాతారం) కరీష్యసే, యస్మాత్ స నిజమనుజాన్ తేషాం కలుషేభ్య ఉద్ధరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ఇత్థం సతి, పశ్య గర్భవతీ కన్యా తనయం ప్రసవిష్యతే| ఇమ్మానూయేల్ తదీయఞ్చ నామధేయం భవిష్యతి|| ఇమ్మానూయేల్ అస్మాకం సఙ్గీశ్వరఇత్యర్థః| ");
INSERT INTO santel_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ఇతి యద్ వచనం పుర్వ్వం భవిష్యద్వక్త్రా ఈశ్వరః కథాయామాస, తత్ తదానీం సిద్ధమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","అనన్తరం యూషఫ్ నిద్రాతో జాగరిత ఉత్థాయ పరమేశ్వరీయదూతస్య నిదేశానుసారేణ నిజాం జాయాం జగ్రాహ, ");
INSERT INTO santel_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","కిన్తు యావత్ సా నిజం ప్రథమసుతం అ సుషువే, తావత్ తాం నోపాగచ్ఛత్, తతః సుతస్య నామ యీశుం చక్రే| ");
INSERT INTO santel_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","అనన్తరం హేరోద్ సంజ్ఞకే రాజ్ఞి రాజ్యం శాసతి యిహూదీయదేశస్య బైత్లేహమి నగరే యీశౌ జాతవతి చ, కతిపయా జ్యోతిర్వ్వుదః పూర్వ్వస్యా దిశో యిరూశాలమ్నగరం సమేత్య కథయమాసుః, ");
INSERT INTO santel_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","యో యిహూదీయానాం రాజా జాతవాన్, స కుత్రాస్తే? వయం పూర్వ్వస్యాం దిశి తిష్ఠన్తస్తదీయాం తారకామ్ అపశ్యామ తస్మాత్ తం ప్రణన్తుమ్ అाగమామ| ");
INSERT INTO santel_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","తదా హేరోద్ రాజా కథామేతాం నిశమ్య యిరూశాలమ్నగరస్థితైః సర్వ్వమానవైః సార్ద్ధమ్ ఉద్విజ్య ");
INSERT INTO santel_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","సర్వ్వాన్ ప్రధానయాజకాన్ అధ్యాపకాంశ్చ సమాహూయానీయ పప్రచ్ఛ, ఖ్రీష్టః కుత్ర జనిష్యతే? ");
INSERT INTO santel_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","తదా తే కథయామాసుః, యిహూదీయదేశస్య బైత్లేహమి నగరే, యతో భవిష్యద్వాదినా ఇత్థం లిఖితమాస్తే, ");
INSERT INTO santel_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","సర్వ్వాభ్యో రాజధానీభ్యో యిహూదీయస్య నీవృతః| హే యీహూదీయదేశస్యే బైత్లేహమ్ త్వం న చావరా| ఇస్రాయేలీయలోకాన్ మే యతో యః పాలయిష్యతి| తాదృగేకో మహారాజస్త్వన్మధ్య ఉద్భవిష్యతీ|| ");
INSERT INTO santel_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","తదానీం హేరోద్ రాజా తాన్ జ్యోతిర్వ్విదో గోపనమ్ ఆహూయ సా తారకా కదా దృష్టాభవత్ , తద్ వినిశ్చయామాస| ");
INSERT INTO santel_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","అపరం తాన్ బైత్లేహమం ప్రహీత్య గదితవాన్, యూయం యాత, యత్నాత్ తం శిశుమ్ అన్విష్య తదుద్దేశే ప్రాప్తే మహ్యం వార్త్తాం దాస్యథ, తతో మయాపి గత్వా స ప్రణంస్యతే| ");
INSERT INTO santel_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","తదానీం రాజ్ఞ ఏతాదృశీమ్ ఆజ్ఞాం ప్రాప్య తే ప్రతస్థిరే, తతః పూర్వ్వర్స్యాం దిశి స్థితైస్తై ర్యా తారకా దృష్టా సా తారకా తేషామగ్రే గత్వా యత్ర స్థానే శిశూరాస్తే, తస్య స్థానస్యోపరి స్థగితా తస్యౌ| ");
INSERT INTO santel_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","తద్ దృష్ట్వా తే మహానన్దితా బభూవుః, ");
INSERT INTO santel_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","తతో గేహమధ్య ప్రవిశ్య తస్య మాత్రా మరియమా సాద్ధం తం శిశుం నిరీక్షయ దణ్డవద్ భూత్వా ప్రణేముః, అపరం స్వేషాం ఘనసమ్పత్తిం మోచయిత్వా సువర్ణం కున్దురుం గన్ధరమఞ్చ తస్మై దర్శనీయం దత్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","పశ్చాద్ హేరోద్ రాజస్య సమీపం పునరపి గన్తుం స్వప్న ఈశ్వరేణ నిషిద్ధాః సన్తో ఽన్యేన పథా తే నిజదేశం ప్రతి ప్రతస్థిరే| ");
INSERT INTO santel_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","అనన్తరం తేషు గతవత్ము పరమేశ్వరస్య దూతో యూషఫే స్వప్నే దర్శనం దత్వా జగాద, త్వమ్ ఉత్థాయ శిశుం తన్మాతరఞ్చ గృహీత్వా మిసర్దేశం పలాయస్వ, అపరం యావదహం తుభ్యం వార్త్తాం న కథయిష్యామి, తావత్ తత్రైవ నివస, యతో రాజా హేరోద్ శిశుం నాశయితుం మృగయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","తదానీం యూషఫ్ ఉత్థాయ రజన్యాం శిశుం తన్మాతరఞ్చ గృహీత్వా మిసర్దేశం ప్రతి ప్రతస్థే, ");
INSERT INTO santel_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","గత్వా చ హేరోదో నృపతే ర్మరణపర్య్యన్తం తత్ర దేశే న్యువాస, తేన మిసర్దేశాదహం పుత్రం స్వకీయం సముపాహూయమ్| యదేతద్వచనమ్ ఈశ్వరేణ భవిష్యద్వాదినా కథితం తత్ సఫలమభూత్| ");
INSERT INTO santel_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","అనన్తరం హేరోద్ జ్యోతిర్విద్భిరాత్మానం ప్రవఞ్చితం విజ్ఞాయ భృశం చుకోప; అపరం జ్యోతిర్వ్విద్భ్యస్తేన వినిశ్చితం యద్ దినం తద్దినాద్ గణయిత్వా ద్వితీయవత్సరం ప్రవిష్టా యావన్తో బాలకా అస్మిన్ బైత్లేహమ్నగరే తత్సీమమధ్యే చాసన్, లోకాన్ ప్రహిత్య తాన్ సర్వ్వాన్ ఘాతయామాస| ");
INSERT INTO santel_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","అతః అనేకస్య విలాపస్య నినాద: క్రన్దనస్య చ| శోకేన కృతశబ్దశ్చ రామాయాం సంనిశమ్యతే| స్వబాలగణహేతోర్వై రాహేల్ నారీ తు రోదినీ| న మన్యతే ప్రబోధన్తు యతస్తే నైవ మన్తి హి|| ");
INSERT INTO santel_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","యదేతద్ వచనం యిరీమియనామకభవిష్యద్వాదినా కథితం తత్ తదానీం సఫలమ్ అభూత్| ");
INSERT INTO santel_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","తదనన్తరం హేరేది రాజని మృతే పరమేశ్వరస్య దూతో మిసర్దేశే స్వప్నే దర్శనం దత్త్వా యూషఫే కథితవాన్ ");
INSERT INTO santel_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","త్వమ్ ఉత్థాయ శిశుం తన్మాతరఞ్చ గృహీత్వా పునరపీస్రాయేలో దేశం యాహీ, యే జనాః శిశుం నాశయితుమ్ అమృగయన్త, తే మృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","తదానీం స ఉత్థాయ శిశుం తన్మాతరఞ్చ గృహ్లన్ ఇస్రాయేల్దేశమ్ ఆజగామ| ");
INSERT INTO santel_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","కిన్తు యిహూదీయదేశే అర్ఖిలాయనామ రాజకుమారో నిజపితు ర్హేరోదః పదం ప్రాప్య రాజత్వం కరోతీతి నిశమ్య తత్ స్థానం యాతుం శఙ్కితవాన్, పశ్చాత్ స్వప్న ఈశ్వరాత్ ప్రబోధం ప్రాప్య గాలీల్దేశస్య ప్రదేశైకం ప్రస్థాయ నాసరన్నామ నగరం గత్వా తత్ర న్యుషితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","తేన తం నాసరతీయం కథయిష్యన్తి, యదేతద్వాక్యం భవిష్యద్వాదిభిరుక్త్తం తత్ సఫలమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","తదానోం యోహ్న్నామా మజ్జయితా యిహూదీయదేశస్య ప్రాన్తరమ్ ఉపస్థాయ ప్రచారయన్ కథయామాస, ");
INSERT INTO santel_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","మనాంసి పరావర్త్తయత, స్వర్గీయరాజత్వం సమీపమాగతమ్| ");
INSERT INTO santel_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","పరమేశస్య పన్థానం పరిష్కురుత సర్వ్వతః| తస్య రాజపథాంశ్చైవ సమీకురుత సర్వ్వథా| ఇత్యేతత్ ప్రాన్తరే వాక్యం వదతః కస్యచిద్ రవః|| ");
INSERT INTO santel_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ఏతద్వచనం యిశయియభవిష్యద్వాదినా యోహనముద్దిశ్య భాషితమ్| యోహనో వసనం మహాఙ్గరోమజం తస్య కటౌ చర్మ్మకటిబన్ధనం; స చ శూకకీటాన్ మధు చ భుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","తదానీం యిరూశాలమ్నగరనివాసినః సర్వ్వే యిహూదిదేశీయా యర్ద్దన్తటిన్యా ఉభయతటస్థాశ్చ మానవా బహిరాగత్య తస్య సమీపే ");
INSERT INTO santel_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","స్వీయం స్వీయం దురితమ్ అఙ్గీకృత్య తస్యాం యర్ద్దని తేన మజ్జితా బభూవుః| ");
INSERT INTO santel_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","అపరం బహూన్ ఫిరూశినః సిదూకినశ్చ మనుజాన్ మంక్తుం స్వసమీపమ్ ఆగచ్ఛ్తో విలోక్య స తాన్ అభిదధౌ, రే రే భుజగవంశా ఆగామీనః కోపాత్ పలాయితుం యుష్మాన్ కశ్చేతితవాన్? ");
INSERT INTO santel_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","మనఃపరావర్త్తనస్య సముచితం ఫలం ఫలత| ");
INSERT INTO santel_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","కిన్త్వస్మాకం తాత ఇబ్రాహీమ్ అస్తీతి స్వేషు మనఃసు చీన్తయన్తో మా వ్యాహరత| యతో యుష్మాన్ అహం వదామి, ఈశ్వర ఏతేభ్యః పాషాణేభ్య ఇబ్రాహీమః సన్తానాన్ ఉత్పాదయితుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","అపరం పాదపానాం మూలే కుఠార ఇదానీమపి లగన్ ఆస్తే, తస్మాద్ యస్మిన్ పాదపే ఉత్తమం ఫలం న భవతి, స కృత్తో మధ్యేఽగ్నిం నిక్షేప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","అపరమ్ అహం మనఃపరావర్త్తనసూచకేన మజ్జనేన యుష్మాన్ మజ్జయామీతి సత్యం, కిన్తు మమ పశ్చాద్ య ఆగచ్ఛతి, స మత్తోపి మహాన్, అహం తదీయోపానహౌ వోఢుమపి నహి యోగ్యోస్మి, స యుష్మాన్ వహ్నిరూపే పవిత్ర ఆత్మని సంమజ్జయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","తస్య కారే సూర్ప ఆస్తే, స స్వీయశస్యాని సమ్యక్ ప్రస్ఫోట్య నిజాన్ సకలగోధూమాన్ సంగృహ్య భాణ్డాగారే స్థాపయిష్యతి, కింన్తు సర్వ్వాణి వుషాణ్యనిర్వ్వాణవహ్నినా దాహయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","అనన్తరం యీశు ర్యోహనా మజ్జితో భవితుం గాలీల్ప్రదేశాద్ యర్ద్దని తస్య సమీపమ్ ఆజగామ| ");
INSERT INTO santel_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","కిన్తు యోహన్ తం నిషిధ్య బభాషే, త్వం కిం మమ సమీపమ్ ఆగచ్ఛసి? వరం త్వయా మజ్జనం మమ ప్రయోజనమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","తదానీం యీశుః ప్రత్యవోచత్; ఈదానీమ్ అనుమన్యస్వ, యత ఇత్థం సర్వ్వధర్మ్మసాధనమ్ అస్మాకం కర్త్తవ్యం, తతః సోఽన్వమన్యత| ");
INSERT INTO santel_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","అనన్తరం యీశురమ్మసి మజ్జితుః సన్ తత్క్షణాత్ తోయమధ్యాద్ ఉత్థాయ జగామ, తదా జీమూతద్వారే ముక్తే జాతే, స ఈశ్వరస్యాత్మానం కపోతవద్ అవరుహ్య స్వోపర్య్యాగచ్ఛన్తం వీక్షాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","అపరమ్ ఏష మమ ప్రియః పుత్ర ఏతస్మిన్నేవ మమ మహాసన్తోష ఏతాదృశీ వ్యోమజా వాగ్ బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","తతః పరం యీశుః ప్రతారకేణ పరీక్షితో భవితుమ్ ఆత్మనా ప్రాన్తరమ్ ఆకృష్టః ");
INSERT INTO santel_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","సన్ చత్వారింశదహోరాత్రాన్ అనాహారస్తిష్ఠన్ క్షుధితో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","తదానీం పరీక్షితా తత్సమీపమ్ ఆగత్య వ్యాహృతవాన్, యది త్వమీశ్వరాత్మజో భవేస్తర్హ్యాజ్ఞయా పాషాణానేతాన్ పూపాన్ విధేహి| ");
INSERT INTO santel_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","తతః స ప్రత్యబ్రవీత్, ఇత్థం లిఖితమాస్తే, \"మనుజః కేవలపూపేన న జీవిష్యతి, కిన్త్వీశ్వరస్య వదనాద్ యాని యాని వచాంసి నిఃసరన్తి తైరేవ జీవిష్యతి| \" ");
INSERT INTO santel_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","తదా ప్రతారకస్తం పుణ్యనగరం నీత్వా మన్దిరస్య చూడోపరి నిధాయ గదితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","త్వం యదిశ్వరస్య తనయో భవేస్తర్హీతోఽధః పత, యత ఇత్థం లిఖితమాస్తే, ఆదేక్ష్యతి నిజాన్ దూతాన్ రక్షితుం త్వాం పరమేశ్వరః| యథా సర్వ్వేషు మార్గేషు త్వదీయచరణద్వయే| న లగేత్ ప్రస్తరాఘాతస్త్వాం ఘరిష్యన్తి తే కరైః|| ");
INSERT INTO santel_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","తదానీం యీశుస్తస్మై కథితవాన్ ఏతదపి లిఖితమాస్తే, \"త్వం నిజప్రభుం పరమేశ్వరం మా పరీక్షస్వ| \" ");
INSERT INTO santel_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","అనన్తరం ప్రతారకః పునరపి తమ్ అత్యుఞ్చధరాధరోపరి నీత్వా జగతః సకలరాజ్యాని తదైశ్వర్య్యాణి చ దర్శయాశ్చకార కథయాఞ్చకార చ, ");
INSERT INTO santel_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","యది త్వం దణ్డవద్ భవన్ మాం ప్రణమేస్తర్హ్యహమ్ ఏతాని తుభ్యం ప్రదాస్యామి| ");
INSERT INTO santel_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","తదానీం యీశుస్తమవోచత్, దూరీభవ ప్రతారక, లిఖితమిదమ్ ఆస్తే, \"త్వయా నిజః ప్రభుః పరమేశ్వరః ప్రణమ్యః కేవలః స సేవ్యశ్చ| \" ");
INSERT INTO santel_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","తతః ప్రతారకేణ స పర్య్యత్యాజి, తదా స్వర్గీయదూతైరాగత్య స సిషేవే| ");
INSERT INTO santel_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","తదనన్తరం యోహన్ కారాయాం బబన్ధే, తద్వార్త్తాం నిశమ్య యీశునా గాలీల్ ప్రాస్థీయత| ");
INSERT INTO santel_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","తతః పరం స నాసరన్నగరం విహాయ జలఘేస్తటే సిబూలూన్నప్తాలీ ఏతయోరువభయోః ప్రదేశయోః సీమ్నోర్మధ్యవర్త్తీ య: కఫర్నాహూమ్ తన్నగరమ్ ఇత్వా న్యవసత్| ");
INSERT INTO santel_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","తస్మాత్, అన్యాదేశీయగాలీలి యర్ద్దన్పారేఽబ్ధిరోధసి| నప్తాలిసిబూలూన్దేశౌ యత్ర స్థానే స్థితౌ పురా| ");
INSERT INTO santel_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","తత్రత్యా మనుజా యే యే పర్య్యభ్రామ్యన్ తమిస్రకే| తైర్జనైర్బృహదాలోకః పరిదర్శిష్యతే తదా| అవసన్ యే జనా దేశే మృత్యుచ్ఛాయాస్వరూపకే| తేషాముపరి లోకానామాలోకః సంప్రకాశితః|| ");
INSERT INTO santel_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","యదేతద్వచనం యిశయియభవిష్యద్వాదినా ప్రోక్తం, తత్ తదా సఫలమ్ అభూత్| ");
INSERT INTO santel_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","అనన్తరం యీశుః సుసంవాదం ప్రచారయన్ ఏతాం కథాం కథయితుమ్ ఆరేభే, మనాంసి పరావర్త్తయత, స్వర్గీయరాజత్వం సవిధమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","తతః పరం యీశు ర్గాలీలో జలధేస్తటేన గచ్ఛన్ గచ్ఛన్ ఆన్ద్రియస్తస్య భ్రాతా శిమోన్ అర్థతో యం పితరం వదన్తి ఏతావుభౌ జలఘౌ జాలం క్షిపన్తౌ దదర్శ, యతస్తౌ మీనధారిణావాస్తామ్| ");
INSERT INTO santel_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","తదా స తావాహూయ వ్యాజహార, యువాం మమ పశ్చాద్ ఆగచ్ఛతం, యువామహం మనుజధారిణౌ కరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","తేనైవ తౌ జాలం విహాయ తస్య పశ్చాత్ ఆగచ్ఛతామ్| ");
INSERT INTO santel_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","అనన్తరం తస్మాత్ స్థానాత్ వ్రజన్ వ్రజన్ సివదియస్య సుతౌ యాకూబ్ యోహన్నామానౌ ద్వౌ సహజౌ తాతేన సార్ద్ధం నౌకోపరి జాలస్య జీర్ణోద్ధారం కుర్వ్వన్తౌ వీక్ష్య తావాహూతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","తత్క్షణాత్ తౌ నావం స్వతాతఞ్చ విహాయ తస్య పశ్చాద్గామినౌ బభూవతుః| ");
INSERT INTO santel_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","అనన్తరం భజనభవనే సముపదిశన్ రాజ్యస్య సుసంవాదం ప్రచారయన్ మనుజానాం సర్వ్వప్రకారాన్ రోగాన్ సర్వ్వప్రకారపీడాశ్చ శమయన్ యీశుః కృత్స్నం గాలీల్దేశం భ్రమితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","తేన కృత్స్నసురియాదేశస్య మధ్యం తస్య యశో వ్యాప్నోత్, అపరం భూతగ్రస్తా అపస్మారర్గీణః పక్షాధాతిప్రభృతయశ్చ యావన్తో మనుజా నానావిధవ్యాధిభిః క్లిష్టా ఆసన్, తేషు సర్వ్వేషు తస్య సమీపమ్ ఆనీతేషు స తాన్ స్వస్థాన్ చకార| ");
INSERT INTO santel_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ఏతేన గాలీల్-దికాపని-యిరూశాలమ్-యిహూదీయదేశేభ్యో యర్ద్దనః పారాఞ్చ బహవో మనుజాస్తస్య పశ్చాద్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","అనన్తరం స జననివహం నిరీక్ష్య భూధరోపరి వ్రజిత్వా సముపవివేశ| ");
INSERT INTO santel_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","తదానీం శిష్యేషు తస్య సమీపమాగతేషు తేన తేభ్య ఏషా కథా కథ్యాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","అభిమానహీనా జనా ధన్యాః, యతస్తే స్వర్గీయరాజ్యమ్ అధికరిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ఖిద్యమానా మనుజా ధన్యాః, యస్మాత్ తే సాన్త్వనాం ప్రాప్సన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","నమ్రా మానవాశ్చ ధన్యాః, యస్మాత్ తే మేదినీమ్ అధికరిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ధర్మ్మాయ బుభుక్షితాః తృషార్త్తాశ్చ మనుజా ధన్యాః, యస్మాత్ తే పరితర్ప్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","కృపాలవో మానవా ధన్యాః, యస్మాత్ తే కృపాం ప్రాప్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","నిర్మ్మలహృదయా మనుజాశ్చ ధన్యాః, యస్మాత్ త ఈశ్చరం ద్రక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","మేలయితారో మానవా ధన్యాః, యస్మాత్ త ఈశ్చరస్య సన్తానత్వేన విఖ్యాస్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ధర్మ్మకారణాత్ తాడితా మనుజా ధన్యా, యస్మాత్ స్వర్గీయరాజ్యే తేషామధికరో విద్యతే| ");
INSERT INTO santel_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","యదా మనుజా మమ నామకృతే యుష్మాన్ నిన్దన్తి తాడయన్తి మృషా నానాదుర్వ్వాక్యాని వదన్తి చ, తదా యుయం ధన్యాః| ");
INSERT INTO santel_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","తదా ఆనన్దత, తథా భృశం హ్లాదధ్వఞ్చ, యతః స్వర్గే భూయాంసి ఫలాని లప్స్యధ్వే; తే యుష్మాకం పురాతనాన్ భవిష్యద్వాదినోఽపి తాదృగ్ అతాడయన్| ");
INSERT INTO santel_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","యుయం మేదిన్యాం లవణరూపాః, కిన్తు యది లవణస్య లవణత్వమ్ అపయాతి, తర్హి తత్ కేన ప్రకారేణ స్వాదుయుక్తం భవిష్యతి? తత్ కస్యాపి కార్య్యస్యాయోగ్యత్వాత్ కేవలం బహిః ప్రక్షేప్తుం నరాణాం పదతలేన దలయితుఞ్చ యోగ్యం భవతి| ");
INSERT INTO santel_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","యూయం జగతి దీప్తిరూపాః, భూధరోపరి స్థితం నగరం గుప్తం భవితుం నహి శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","అపరం మనుజాః ప్రదీపాన్ ప్రజ్వాల్య ద్రోణాధో న స్థాపయన్తి, కిన్తు దీపాధారోపర్య్యేవ స్థాపయన్తి, తేన తే దీపా గేహస్థితాన్ సకలాన్ ప్రకాశయన్తి| ");
INSERT INTO santel_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","యేన మానవా యుష్మాకం సత్కర్మ్మాణి విలోక్య యుష్మాకం స్వర్గస్థం పితరం ధన్యం వదన్తి, తేషాం సమక్షం యుష్మాకం దీప్తిస్తాదృక్ ప్రకాశతామ్| ");
INSERT INTO santel_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","అహం వ్యవస్థాం భవిష్యద్వాక్యఞ్చ లోప్తుమ్ ఆగతవాన్, ఇత్థం మానుభవత, తే ద్వే లోప్తుం నాగతవాన్, కిన్తు సఫలే కర్త్తుమ్ ఆగతోస్మి| ");
INSERT INTO santel_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","అపరం యుష్మాన్ అహం తథ్యం వదామి యావత్ వ్యోమమేదిన్యో ర్ధ్వంసో న భవిష్యతి, తావత్ సర్వ్వస్మిన్ సఫలే న జాతే వ్యవస్థాయా ఏకా మాత్రా బిన్దురేకోపి వా న లోప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","తస్మాత్ యో జన ఏతాసామ్ ఆజ్ఞానామ్ అతిక్షుద్రామ్ ఏకాజ్ఞామపీ లంఘతే మనుజాంఞ్చ తథైవ శిక్షయతి, స స్వర్గీయరాజ్యే సర్వ్వేభ్యః క్షుద్రత్వేన విఖ్యాస్యతే, కిన్తు యో జనస్తాం పాలయతి, తథైవ శిక్షయతి చ, స స్వర్గీయరాజ్యే ప్రధానత్వేన విఖ్యాస్యతే| ");
INSERT INTO santel_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","అపరం యుష్మాన్ అహం వదామి, అధ్యాపకఫిరూశిమానవానాం ధర్మ్మానుష్ఠానాత్ యుష్మాకం ధర్మ్మానుష్ఠానే నోత్తమే జాతే యూయమ్ ఈశ్వరీయరాజ్యం ప్రవేష్టుం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","అపరఞ్చ త్వం నరం మా వధీః, యస్మాత్ యో నరం హన్తి, స విచారసభాయాం దణ్డార్హో భవిష్యతి, పూర్వ్వకాలీనజనేభ్య ఇతి కథితమాసీత్, యుష్మాభిరశ్రావి| ");
INSERT INTO santel_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","కిన్త్వహం యుష్మాన్ వదామి, యః కశ్చిత్ కారణం వినా నిజభ్రాత్రే కుప్యతి, స విచారసభాయాం దణ్డార్హో భవిష్యతి; యః కశ్చిచ్చ స్వీయసహజం నిర్బ్బోధం వదతి, స మహాసభాయాం దణ్డార్హో భవిష్యతి; పునశ్చ త్వం మూఢ ఇతి వాక్యం యది కశ్చిత్ స్వీయభ్రాతరం వక్తి, తర్హి నరకాగ్నౌ స దణ్డార్హో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","అతో వేద్యాః సమీపం నిజనైవేద్యే సమానీతేఽపి నిజభ్రాతరం ప్రతి కస్మాచ్చిత్ కారణాత్ త్వం యది దోషీ విద్యసే, తదానీం తవ తస్య స్మృతి ర్జాయతే చ, ");
INSERT INTO santel_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","తర్హి తస్యా వేద్యాః సమీపే నిజనైవైద్యం నిధాయ తదైవ గత్వా పూర్వ్వం తేన సార్ద్ధం మిల, పశ్చాత్ ఆగత్య నిజనైవేద్యం నివేదయ| ");
INSERT INTO santel_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","అన్యఞ్చ యావత్ వివాదినా సార్ద్ధం వర్త్మని తిష్ఠసి, తావత్ తేన సార్ద్ధం మేలనం కురు; నో చేత్ వివాదీ విచారయితుః సమీపే త్వాం సమర్పయతి విచారయితా చ రక్షిణః సన్నిధౌ సమర్పయతి తదా త్వం కారాయాం బధ్యేథాః| ");
INSERT INTO santel_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","తర్హి త్వామహం తథ్థం బ్రవీమి, శేషకపర్దకేఽపి న పరిశోధితే తస్మాత్ స్థానాత్ కదాపి బహిరాగన్తుం న శక్ష్యసి| ");
INSERT INTO santel_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","అపరం త్వం మా వ్యభిచర, యదేతద్ వచనం పూర్వ్వకాలీనలోకేభ్యః కథితమాసీత్, తద్ యూయం శ్రుతవన్తః; ");
INSERT INTO santel_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","కిన్త్వహం యుష్మాన్ వదామి, యది కశ్చిత్ కామతః కాఞ్చన యోషితం పశ్యతి, తర్హి స మనసా తదైవ వ్యభిచరితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","తస్మాత్ తవ దక్షిణం నేత్రం యది త్వాం బాధతే, తర్హి తన్నేత్రమ్ ఉత్పాట్య దూరే నిక్షిప, యస్మాత్ తవ సర్వ్వవపుషో నరకే నిక్షేపాత్ తవైకాఙ్గస్య నాశో వరం| ");
INSERT INTO santel_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","యద్వా తవ దక్షిణః కరో యది త్వాం బాధతే, తర్హి తం కరం ఛిత్త్వా దూరే నిక్షిప, యతః సర్వ్వవపుషో నరకే నిక్షేపాత్ ఏకాఙ్గస్య నాశో వరం| ");
INSERT INTO santel_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ఉక్తమాస్తే, యది కశ్చిన్ నిజజాయాం పరిత్యక్త్తుమ్ ఇచ్ఛతి, తర్హి స తస్యై త్యాగపత్రం దదాతు| ");
INSERT INTO santel_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","కిన్త్వహం యుష్మాన్ వ్యాహరామి, వ్యభిచారదోషే న జాతే యది కశ్చిన్ నిజజాయాం పరిత్యజతి, తర్హి స తాం వ్యభిచారయతి; యశ్చ తాం త్యక్తాం స్త్రియం వివహతి, సోపి వ్యభిచరతి| ");
INSERT INTO santel_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","పునశ్చ త్వం మృషా శపథమ్ న కుర్వ్వన్ ఈశ్చరాయ నిజశపథం పాలయ, పూర్వ్వకాలీనలోకేభ్యో యైషా కథా కథితా, తామపి యూయం శ్రుతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","కిన్త్వహం యుష్మాన్ వదామి, కమపి శపథం మా కార్ష్ట, అర్థతః స్వర్గనామ్నా న, యతః స ఈశ్వరస్య సింహాసనం; ");
INSERT INTO santel_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","పృథివ్యా నామ్నాపి న, యతః సా తస్య పాదపీఠం; యిరూశాలమో నామ్నాపి న, యతః సా మహారాజస్య పురీ; ");
INSERT INTO santel_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","నిజశిరోనామ్నాపి న, యస్మాత్ తస్యైకం కచమపి సితమ్ అసితం వా కర్త్తుం త్వయా న శక్యతే| ");
INSERT INTO santel_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","అపరం యూయం సంలాపసమయే కేవలం భవతీతి న భవతీతి చ వదత యత ఇతోఽధికం యత్ తత్ పాపాత్మనో జాయతే| ");
INSERT INTO santel_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","అపరం లోచనస్య వినిమయేన లోచనం దన్తస్య వినిమయేన దన్తః పూర్వ్వక్తమిదం వచనఞ్చ యుష్మాభిరశ్రూయత| ");
INSERT INTO santel_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","కిన్త్వహం యుష్మాన్ వదామి యూయం హింసకం నరం మా వ్యాఘాతయత| కిన్తు కేనచిత్ తవ దక్షిణకపోలే చపేటాఘాతే కృతే తం ప్రతి వామం కపోలఞ్చ వ్యాఘోటయ| ");
INSERT INTO santel_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","అపరం కేనచిత్ త్వయా సార్ధ్దం వివాదం కృత్వా తవ పరిధేయవసనే జిఘృతితే తస్మాయుత్తరీయవసనమపి దేహి| ");
INSERT INTO santel_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","యది కశ్చిత్ త్వాం క్రోశమేకం నయనార్థం అన్యాయతో ధరతి, తదా తేన సార్ధ్దం క్రోశద్వయం యాహి| ");
INSERT INTO santel_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","యశ్చ మానవస్త్వాం యాచతే, తస్మై దేహి, యది కశ్చిత్ తుభ్యం ధారయితుమ్ ఇచ్ఛతి, తర్హి తం ప్రతి పరాంముఖో మా భూః| ");
INSERT INTO santel_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","నిజసమీపవసిని ప్రేమ కురు, కిన్తు శత్రుం ప్రతి ద్వేషం కురు, యదేతత్ పురోక్తం వచనం ఏతదపి యూయం శ్రుతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","కిన్త్వహం యుష్మాన్ వదామి, యూయం రిపువ్వపి ప్రేమ కురుత, యే చ యుష్మాన్ శపన్తే, తాన, ఆశిషం వదత, యే చ యుష్మాన్ ఋृతీయన్తే, తేషాం మఙ్గలం కురుత, యే చ యుష్మాన్ నిన్దన్తి, తాడయన్తి చ, తేషాం కృతే ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","తత్ర యః సతామసతాఞ్చోపరి ప్రభాకరమ్ ఉదాయయతి, తథా ధార్మ్మికానామధార్మ్మికానాఞ్చోపరి నీరం వర్షయతి తాదృశో యో యుష్మాకం స్వర్గస్థః పితా, యూయం తస్యైవ సన్తానా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","యే యుష్మాసు ప్రేమ కుర్వ్వన్తి, యూయం యది కేవలం తేవ్వేవ ప్రేమ కురుథ, తర్హి యుష్మాకం కిం ఫలం భవిష్యతి? చణ్డాలా అపి తాదృశం కిం న కుర్వ్వన్తి? ");
INSERT INTO santel_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","అపరం యూయం యది కేవలం స్వీయభ్రాతృత్వేన నమత, తర్హి కిం మహత్ కర్మ్మ కురుథ? చణ్డాలా అపి తాదృశం కిం న కుర్వ్వన్తి? ");
INSERT INTO santel_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","తస్మాత్ యుష్మాకం స్వర్గస్థః పితా యథా పూర్ణో భవతి, యూయమపి తాదృశా భవత| ");
INSERT INTO santel_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","సావధానా భవత, మనుజాన్ దర్శయితుం తేషాం గోచరే ధర్మ్మకర్మ్మ మా కురుత, తథా కృతే యుష్మాకం స్వర్గస్థపితుః సకాశాత్ కిఞ్చన ఫలం న ప్రాప్స్యథ| ");
INSERT INTO santel_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","త్వం యదా దదాసి తదా కపటినో జనా యథా మనుజేభ్యః ప్రశంసాం ప్రాప్తుం భజనభవనే రాజమార్గే చ తూరీం వాదయన్తి, తథా మా కురిु, అహం తుభ్యం యథార్థం కథయామి, తే స్వకాయం ఫలమ్ అలభన్త| ");
INSERT INTO santel_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","కిన్తు త్వం యదా దదాసి, తదా నిజదక్షిణకరో యత్ కరోతి, తద్ వామకరం మా జ్ఞాపయ| ");
INSERT INTO santel_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","తేన తవ దానం గుప్తం భవిష్యతి యస్తు తవ పితా గుప్తదర్శీ, స ప్రకాశ్య తుభ్యం ఫలం దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","అపరం యదా ప్రార్థయసే, తదా కపటినఇవ మా కురు, యస్మాత్ తే భజనభవనే రాజమార్గస్య కోణే తిష్ఠన్తో లోకాన్ దర్శయన్తః ప్రార్థయితుం ప్రీయన్తే; అహం యుష్మాన్ తథ్యం వదామి, తే స్వకీయఫలం ప్రాప్నువన్| ");
INSERT INTO santel_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","తస్మాత్ ప్రార్థనాకాలే అన్తరాగారం ప్రవిశ్య ద్వారం రుద్వ్వా గుప్తం పశ్యతస్తవ పితుః సమీపే ప్రార్థయస్వ; తేన తవ యః పితా గుప్తదర్శీ, స ప్రకాశ్య తుభ్యం ఫలం దాస్యతిl ");
INSERT INTO santel_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","అపరం ప్రార్థనాకాలే దేవపూజకాఇవ ముధా పునరుక్తిం మా కురు, యస్మాత్ తే బోధన్తే, బహువారం కథాయాం కథితాయాం తేషాం ప్రార్థనా గ్రాహిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","యూయం తేషామివ మా కురుత, యస్మాత్ యుష్మాకం యద్ యత్ ప్రయోజనం యాచనాతః ప్రాగేవ యుష్మాకం పితా తత్ జానాతి| ");
INSERT INTO santel_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","అతఏవ యూయమ ఈదృక్ ప్రార్థయధ్వం, హే అస్మాకం స్వర్గస్థపితః, తవ నామ పూజ్యం భవతు| ");
INSERT INTO santel_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","తవ రాజత్వం భవతు; తవేచ్ఛా స్వర్గే యథా తథైవ మేదిన్యామపి సఫలా భవతు| ");
INSERT INTO santel_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","అస్మాకం ప్రయోజనీయమ్ ఆహారమ్ అద్య దేహి| ");
INSERT INTO santel_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","వయం యథా నిజాపరాధినః క్షమామహే, తథైవాస్మాకమ్ అపరాధాన్ క్షమస్వ| ");
INSERT INTO santel_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","అస్మాన్ పరీక్షాం మానయ, కిన్తు పాపాత్మనో రక్ష; రాజత్వం గౌరవం పరాక్రమః ఏతే సర్వ్వే సర్వ్వదా తవ; తథాస్తు| ");
INSERT INTO santel_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","యది యూయమ్ అన్యేషామ్ అపరాధాన్ క్షమధ్వే తర్హి యుష్మాకం స్వర్గస్థపితాపి యుష్మాన్ క్షమిష్యతే; ");
INSERT INTO santel_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","కిన్తు యది యూయమ్ అన్యేషామ్ అపరాధాన్ న క్షమధ్వే, తర్హి యుష్మాకం జనకోపి యుష్మాకమ్ అపరాధాన్ న క్షమిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","అపరమ్ ఉపవాసకాలే కపటినో జనా మానుషాన్ ఉపవాసం జ్ఞాపయితుం స్వేషాం వదనాని మ్లానాని కుర్వ్వన్తి, యూయం తఇవ విషణవదనా మా భవత; అహం యుష్మాన్ తథ్యం వదామి తే స్వకీయఫలమ్ అలభన్త| ");
INSERT INTO santel_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","యదా త్వమ్ ఉపవససి, తదా యథా లోకైస్త్వం ఉపవాసీవ న దృశ్యసే, కిన్తు తవ యోఽగోచరః పితా తేనైవ దృశ్యసే, తత్కృతే నిజశిరసి తైలం మర్ద్దయ వదనఞ్చ ప్రక్షాలయ; ");
INSERT INTO santel_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","తేన తవ యః పితా గుప్తదర్శీ స ప్రకాశ్య తుభ్యం ఫలం దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","అపరం యత్ర స్థానే కీటాః కలఙ్కాశ్చ క్షయం నయన్తి, చౌరాశ్చ సన్ధిం కర్త్తయిత్వా చోరయితుం శక్నువన్తి, తాదృశ్యాం మేదిన్యాం స్వార్థం ధనం మా సంచినుత| ");
INSERT INTO santel_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","కిన్తు యత్ర స్థానే కీటాః కలఙ్కాశ్చ క్షయం న నయన్తి, చౌరాశ్చ సన్ధిం కర్త్తయిత్వా చోరయితుం న శక్నువన్తి, తాదృశే స్వర్గే ధనం సఞ్చినుత| ");
INSERT INTO santel_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","యస్మాత్ యత్ర స్థానే యుష్మాంక ధనం తత్రైవ ఖానే యుష్మాకం మనాంసి| ");
INSERT INTO santel_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","లోచనం దేహస్య ప్రదీపకం, తస్మాత్ యది తవ లోచనం ప్రసన్నం భవతి, తర్హి తవ కృత్స్నం వపు ర్దీప్తియుక్తం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","కిన్తు లోచనేఽప్రసన్నే తవ కృత్స్నం వపుః తమిస్రయుక్తం భవిష్యతి| అతఏవ యా దీప్తిస్త్వయి విద్యతే, సా యది తమిస్రయుక్తా భవతి, తర్హి తత్ తమిస్రం కియన్ మహత్| ");
INSERT INTO santel_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","కోపి మనుజో ద్వౌ ప్రభూ సేవితుం న శక్నోతి, యస్మాద్ ఏకం సంమన్య తదన్యం న సమ్మన్యతే, యద్వా ఏకత్ర మనో నిధాయ తదన్యమ్ అవమన్యతే; తథా యూయమపీశ్వరం లక్ష్మీఞ్చేత్యుభే సేవితుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","అపరమ్ అహం యుష్మభ్యం తథ్యం కథయామి, కిం భక్షిష్యామః? కిం పాస్యామః? ఇతి ప్రాణధారణాయ మా చిన్తయత; కిం పరిధాస్యామః? ఇతి కాయరక్షణాయ న చిన్తయత; భక్ష్యాత్ ప్రాణా వసనాఞ్చ వపూంషి కిం శ్రేష్ఠాణి న హి? ");
INSERT INTO santel_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","విహాయసో విహఙ్గమాన్ విలోకయత; తై ర్నోప్యతే న కృత్యతే భాణ్డాగారే న సఞ్చీయతేఽపి; తథాపి యుష్మాకం స్వర్గస్థః పితా తేభ్య ఆహారం వితరతి| ");
INSERT INTO santel_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","యూయం తేభ్యః కిం శ్రేష్ఠా న భవథ? యుష్మాకం కశ్చిత్ మనుజః చిన్తయన్ నిజాయుషః క్షణమపి వర్ద్ధయితుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","అపరం వసనాయ కుతశ్చిన్తయత? క్షేత్రోత్పన్నాని పుష్పాణి కథం వర్ద్ధన్తే తదాలోచయత| తాని తన్తూన్ నోత్పాదయన్తి కిమపి కార్య్యం న కుర్వ్వన్తి; ");
INSERT INTO santel_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","తథాప్యహం యుష్మాన్ వదామి, సులేమాన్ తాదృగ్ ఐశ్వర్య్యవానపి తత్పుష్పమివ విభూషితో నాసీత్| ");
INSERT INTO santel_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","తస్మాత్ క్షద్య విద్యమానం శ్చః చుల్ల్యాం నిక్షేప్స్యతే తాదృశం యత్ క్షేత్రస్థితం కుసుమం తత్ యదీశ్చర ఇత్థం బిభూషయతి, తర్హి హే స్తోకప్రత్యయినో యుష్మాన్ కిం న పరిధాపయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","తస్మాత్ అస్మాభిః కిమత్స్యతే? కిఞ్చ పాయిష్యతే? కిం వా పరిధాయిష్యతే, ఇతి న చిన్తయత| ");
INSERT INTO santel_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","యస్మాత్ దేవార్చ్చకా అపీతి చేష్టన్తే; ఏతేషు ద్రవ్యేషు ప్రయోజనమస్తీతి యుష్మాకం స్వర్గస్థః పితా జానాతి| ");
INSERT INTO santel_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","అతఏవ ప్రథమత ఈశ్వరీయరాజ్యం ధర్మ్మఞ్చ చేష్టధ్వం, తత ఏతాని వస్తూని యుష్మభ్యం ప్రదాయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","శ్వః కృతే మా చిన్తయత, శ్వఏవ స్వయం స్వముద్దిశ్య చిన్తయిష్యతి; అద్యతనీ యా చిన్తా సాద్యకృతే ప్రచురతరా| ");
INSERT INTO santel_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","యథా యూయం దోషీకృతా న భవథ, తత్కృతేఽన్యం దోషిణం మా కురుత| ");
INSERT INTO santel_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","యతో యాదృశేన దోషేణ యూయం పరాన్ దోషిణః కురుథ, తాదృశేన దోషేణ యూయమపి దోషీకృతా భవిష్యథ, అన్యఞ్చ యేన పరిమాణేన యుష్మాభిః పరిమీయతే, తేనైవ పరిమాణేన యుష్మత్కృతే పరిమాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","అపరఞ్చ నిజనయనే యా నాసా విద్యతే, తామ్ అనాలోచ్య తవ సహజస్య లోచనే యత్ తృణమ్ ఆస్తే, తదేవ కుతో వీక్షసే? ");
INSERT INTO santel_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","తవ నిజలోచనే నాసాయాం విద్యమానాయాం, హే భ్రాతః, తవ నయనాత్ తృణం బహిష్యర్తుం అనుజానీహి, కథామేతాం నిజసహజాయ కథం కథయితుం శక్నోషి? ");
INSERT INTO santel_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","హే కపటిన్, ఆదౌ నిజనయనాత్ నాసాం బహిష్కురు తతో నిజదృష్టౌ సుప్రసన్నాయాం తవ భ్రాతృ ర్లోచనాత్ తృణం బహిష్కర్తుం శక్ష్యసి| ");
INSERT INTO santel_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","అన్యఞ్చ సారమేయేభ్యః పవిత్రవస్తూని మా వితరత, వరాహాణాం సమక్షఞ్చ ముక్తా మా నిక్షిపత; నిక్షేపణాత్ తే తాః సర్వ్వాః పదై ర్దలయిష్యన్తి, పరావృత్య యుష్మానపి విదారయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","యాచధ్వం తతో యుష్మభ్యం దాయిష్యతే; మృగయధ్వం తత ఉద్దేశం లప్స్యధ్వే; ద్వారమ్ ఆహత, తతో యుష్మత్కృతే ముక్తం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","యస్మాద్ యేన యాచ్యతే, తేన లభ్యతే; యేన మృగ్యతే తేనోద్దేశః ప్రాప్యతే; యేన చ ద్వారమ్ ఆహన్యతే, తత్కృతే ద్వారం మోచ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ఆత్మజేన పూపే ప్రార్థితే తస్మై పాషాణం విశ్రాణయతి, ");
INSERT INTO santel_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","మీనే యాచితే చ తస్మై భుజగం వితరతి, ఏతాదృశః పితా యుష్మాకం మధ్యే క ఆస్తే? ");
INSERT INTO santel_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","తస్మాద్ యూయమ్ అభద్రాః సన్తోఽపి యది నిజబాలకేభ్య ఉత్తమం ద్రవ్యం దాతుం జానీథ, తర్హి యుష్మాకం స్వర్గస్థః పితా స్వీయయాచకేభ్యః కిముత్తమాని వస్తూని న దాస్యతి? ");
INSERT INTO santel_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","యూష్మాన్ ప్రతీతరేషాం యాదృశో వ్యవహారో యుష్మాకం ప్రియః, యూయం తాన్ ప్రతి తాదృశానేవ వ్యవహారాన్ విధత్త; యస్మాద్ వ్యవస్థాభవిష్యద్వాదినాం వచనానామ్ ఇతి సారమ్| ");
INSERT INTO santel_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","సఙ్కీర్ణద్వారేణ ప్రవిశత; యతో నరకగమనాయ యద్ ద్వారం తద్ విస్తీర్ణం యచ్చ వర్త్మ తద్ బృహత్ తేన బహవః ప్రవిశన్తి| ");
INSERT INTO santel_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","అపరం స్వర్గగమనాయ యద్ ద్వారం తత్ కీదృక్ సంకీర్ణం| యచ్చ వర్త్మ తత్ కీదృగ్ దుర్గమమ్| తదుద్దేష్టారః కియన్తోఽల్పాః| ");
INSERT INTO santel_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","అపరఞ్చ యే జనా మేషవేశేన యుష్మాకం సమీపమ్ ఆగచ్ఛన్తి, కిన్త్వన్తర్దురన్తా వృకా ఏతాదృశేభ్యో భవిష్యద్వాదిభ్యః సావధానా భవత, యూయం ఫలేన తాన్ పరిచేతుం శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","మనుజాః కిం కణ్టకినో వృక్షాద్ ద్రాక్షాఫలాని శృగాలకోలితశ్చ ఉడుమ్బరఫలాని శాతయన్తి? ");
INSERT INTO santel_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","తద్వద్ ఉత్తమ ఏవ పాదప ఉత్తమఫలాని జనయతి, అధమపాదపఏవాధమఫలాని జనయతి| ");
INSERT INTO santel_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","కిన్తూత్తమపాదపః కదాప్యధమఫలాని జనయితుం న శక్నోతి, తథాధమోపి పాదప ఉత్తమఫలాని జనయితుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","అపరం యే యే పాదపా అధమఫలాని జనయన్తి, తే కృత్తా వహ్నౌ క్షిప్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","అతఏవ యూయం ఫలేన తాన్ పరిచేష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","యే జనా మాం ప్రభుం వదన్తి, తే సర్వ్వే స్వర్గరాజ్యం ప్రవేక్ష్యన్తి తన్న, కిన్తు యో మానవో మమ స్వర్గస్థస్య పితురిష్టం కర్మ్మ కరోతి స ఏవ ప్రవేక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","తద్ దినే బహవో మాం వదిష్యన్తి, హే ప్రభో హే ప్రభో, తవ నామ్నా కిమస్మామి ర్భవిష్యద్వాక్యం న వ్యాహృతం? తవ నామ్నా భూతాః కిం న త్యాజితాః? తవ నామ్నా కిం నానాద్భుతాని కర్మ్మాణి న కృతాని? ");
INSERT INTO santel_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","తదాహం వదిష్యామి, హే కుకర్మ్మకారిణో యుష్మాన్ అహం న వేద్మి, యూయం మత్సమీపాద్ దూరీభవత| ");
INSERT INTO santel_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","యః కశ్చిత్ మమైతాః కథాః శ్రుత్వా పాలయతి, స పాషాణోపరి గృహనిర్మ్మాత్రా జ్ఞానినా సహ మయోపమీయతే| ");
INSERT INTO santel_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","యతో వృష్టౌ సత్యామ్ ఆప్లావ ఆగతే వాయౌ వాతే చ తేషు తద్గేహం లగ్నేషు పాషాణోపరి తస్య భిత్తేస్తన్న పతతిl ");
INSERT INTO santel_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","కిన్తు యః కశ్చిత్ మమైతాః కథాః శ్రుత్వా న పాలయతి స సైకతే గేహనిర్మ్మాత్రా ఽజ్ఞానినా ఉపమీయతే| ");
INSERT INTO santel_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","యతో జలవృష్టౌ సత్యామ్ ఆప్లావ ఆగతే పవనే వాతే చ తై ర్గృహే సమాఘాతే తత్ పతతి తత్పతనం మహద్ భవతి| ");
INSERT INTO santel_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","యీశునైతేషు వాక్యేషు సమాపితేషు మానవాస్తదీయోపదేశమ్ ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","యస్మాత్ స ఉపాధ్యాయా ఇవ తాన్ నోపదిదేశ కిన్తు సమర్థపురుషఇవ సముపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","యదా స పర్వ్వతాద్ అవారోహత్ తదా బహవో మానవాస్తత్పశ్చాద్ వవ్రజుః| ");
INSERT INTO santel_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ఏకః కుష్ఠవాన్ ఆగత్య తం ప్రణమ్య బభాషే, హే ప్రభో, యది భవాన్ సంమన్యతే, తర్హి మాం నిరామయం కర్త్తుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","తతో యీశుః కరం ప్రసార్య్య తస్యాఙ్గం స్పృశన్ వ్యాజహార, సమ్మన్యేఽహం త్వం నిరామయో భవ; తేన స తత్క్షణాత్ కుష్ఠేనామోచి| ");
INSERT INTO santel_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","తతో యీశుస్తం జగాద, అవధేహి కథామేతాం కశ్చిదపి మా బ్రూహి, కిన్తు యాజకస్య సన్నిధిం గత్వా స్వాత్మానం దర్శయ మనుజేభ్యో నిజనిరామయత్వం ప్రమాణయితుం మూసానిరూపితం ద్రవ్యమ్ ఉత్సృజ చ| ");
INSERT INTO santel_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","తదనన్తరం యీశునా కఫర్నాహూమ్నామని నగరే ప్రవిష్టే కశ్చిత్ శతసేనాపతిస్తత్సమీపమ్ ఆగత్య వినీయ బభాషే, ");
INSERT INTO santel_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","హే ప్రభో, మదీయ ఏకో దాసః పక్షాఘాతవ్యాధినా భృశం వ్యథితః, సతు శయనీయ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","తదానీం యీశుస్తస్మై కథితవాన్, అహం గత్వా తం నిరామయం కరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","తతః స శతసేనాపతిః ప్రత్యవదత్, హే ప్రభో, భవాన్ యత్ మమ గేహమధ్యం యాతి తద్యోగ్యభాజనం నాహమస్మి; వాఙ్మాత్రమ్ ఆదిశతు, తేనైవ మమ దాసో నిరామయో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","యతో మయి పరనిధ్నేఽపి మమ నిదేశవశ్యాః కతి కతి సేనాః సన్తి, తత ఏకస్మిన్ యాహీత్యుక్తే స యాతి, తదన్యస్మిన్ ఏహీత్యుక్తే స ఆయాతి, తథా మమ నిజదాసే కర్మ్మైతత్ కుర్వ్విత్యుక్తే స తత్ కరోతి| ");
INSERT INTO santel_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","తదానీం యీశుస్తస్యైతత్ వచో నిశమ్య విస్మయాపన్నోఽభూత్; నిజపశ్చాద్గామినో మానవాన్ అవోచ్చ, యుష్మాన్ తథ్యం వచ్మి, ఇస్రాయేలీయలోకానాం మధ్యేఽపి నైతాదృశో విశ్వాసో మయా ప్రాప్తః| ");
INSERT INTO santel_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","అన్యచ్చాహం యుష్మాన్ వదామి, బహవః పూర్వ్వస్యాః పశ్చిమాయాశ్చ దిశ ఆగత్య ఇబ్రాహీమా ఇస్హాకా యాకూబా చ సాకమ్ మిలిత్వా సముపవేక్ష్యన్తి; ");
INSERT INTO santel_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","కిన్తు యత్ర స్థానే రోదనదన్తఘర్షణే భవతస్తస్మిన్ బహిర్భూతతమిస్రే రాజ్యస్య సన్తానా నిక్షేస్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","తతః పరం యీశుస్తం శతసేనాపతిం జగాద, యాహి, తవ ప్రతీత్యనుసారతో మఙ్గలం భూయాత్; తదా తస్మిన్నేవ దణ్డే తదీయదాసో నిరామయో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","అనన్తరం యీశుః పితరస్య గేహముపస్థాయ జ్వరేణ పీడితాం శయనీయస్థితాం తస్య శ్వశ్రూం వీక్షాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","తతస్తేన తస్యాః కరస్య స్పృష్టతవాత్ జ్వరస్తాం తత్యాజ, తదా సా సముత్థాయ తాన్ సిషేవే| ");
INSERT INTO santel_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","అనన్తరం సన్ధ్యాయాం సత్యాం బహుశో భూతగ్రస్తమనుజాన్ తస్య సమీపమ్ ఆనిన్యుః స చ వాక్యేన భూతాన్ త్యాజయామాస, సర్వ్వప్రకారపీడితజనాంశ్చ నిరామయాన్ చకార; ");
INSERT INTO santel_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","తస్మాత్, సర్వ్వా దుర్బ్బలతాస్మాకం తేనైవ పరిధారితా| అస్మాకం సకలం వ్యాధిం సఏవ సంగృహీతవాన్| యదేతద్వచనం యిశయియభవిష్యద్వాదినోక్తమాసీత్, తత్తదా సఫలమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","అనన్తరం యీశుశ్చతుర్దిక్షు జననివహం విలోక్య తటిన్యాః పారం యాతుం శిష్యాన్ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","తదానీమ్ ఏక ఉపాధ్యాయ ఆగత్య కథితవాన్, హే గురో, భవాన్ యత్ర యాస్యతి తత్రాహమపి భవతః పశ్చాద్ యాస్యామి| ");
INSERT INTO santel_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","తతో యీశు ర్జగాద, క్రోష్టుః స్థాతుం స్థానం విద్యతే, విహాయసో విహఙ్గమానాం నీడాని చ సన్తి; కిన్తు మనుష్యపుత్రస్య శిరః స్థాపయితుం స్థానం న విద్యతే| ");
INSERT INTO santel_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","అనన్తరమ్ అపర ఏకః శిష్యస్తం బభాషే, హే ప్రభో, ప్రథమతో మమ పితరం శ్మశానే నిధాతుం గమనార్థం మామ్ అనుమన్యస్వ| ");
INSERT INTO santel_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","తతో యీశురుక్తవాన్ మృతా మృతాన్ శ్మశానే నిదధతు, త్వం మమ పశ్చాద్ ఆగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","అనన్తరం తస్మిన్ నావమారూఢే తస్య శిష్యాస్తత్పశ్చాత్ జగ్ముః| ");
INSERT INTO santel_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","పశ్చాత్ సాగరస్య మధ్యం తేషు గతేషు తాదృశః ప్రబలో ఝఞ్భ్శనిల ఉదతిష్ఠత్, యేన మహాతరఙ్గ ఉత్థాయ తరణిం ఛాదితవాన్, కిన్తు స నిద్రిత ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","తదా శిష్యా ఆగత్య తస్య నిద్రాభఙ్గం కృత్వా కథయామాసుః, హే ప్రభో, వయం మ్రియామహే, భవాన్ అస్మాకం ప్రాణాన్ రక్షతు| ");
INSERT INTO santel_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","తదా స తాన్ ఉక్తవాన్, హే అల్పవిశ్వాసినో యూయం కుతో విభీథ? తతః స ఉత్థాయ వాతం సాగరఞ్చ తర్జయామాస, తతో నిర్వ్వాతమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","అపరం మనుజా విస్మయం విలోక్య కథయామాసుః, అహో వాతసరిత్పతీ అస్య కిమాజ్ఞాగ్రాహిణౌ? కీదృశోఽయం మానవః| ");
INSERT INTO santel_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","అనన్తరం స పారం గత్వా గిదేరీయదేశమ్ ఉపస్థితవాన్; తదా ద్వౌ భూతగ్రస్తమనుజౌ శ్మశానస్థానాద్ బహి ర్భూత్వా తం సాక్షాత్ కృతవన్తౌ, తావేతాదృశౌ ప్రచణ్డావాస్తాం యత్ తేన స్థానేన కోపి యాతుం నాశక్నోత్| ");
INSERT INTO santel_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","తావుచైః కథయామాసతుః, హే ఈశ్వరస్య సూనో యీశో, త్వయా సాకమ్ ఆవయోః కః సమ్బన్ధః? నిరూపితకాలాత్ ప్రాగేవ కిమావాభ్యాం యాతనాం దాతుమ్ అత్రాగతోసి? ");
INSERT INTO santel_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","తదానీం తాభ్యాం కిఞ్చిద్ దూరే వరాహాణామ్ ఏకో మహావ్రజోఽచరత్| ");
INSERT INTO santel_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","తతో భూతౌ తౌ తస్యాన్తికే వినీయ కథయామాసతుః, యద్యావాం త్యాజయసి, తర్హి వరాహాణాం మధ్యేవ్రజమ్ ఆవాం ప్రేరయ| ");
INSERT INTO santel_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","తదా యీశురవదత్ యాతం, అనన్తరం తౌ యదా మనుజౌ విహాయ వరాహాన్ ఆశ్రితవన్తౌ, తదా తే సర్వ్వే వరాహా ఉచ్చస్థానాత్ మహాజవేన ధావన్తః సాగరీయతోయే మజ్జన్తో మమ్రుః| ");
INSERT INTO santel_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","తతో వరాహరక్షకాః పలాయమానా మధ్యేనగరం తౌ భూతగ్రస్తౌ ప్రతి యద్యద్ అఘటత, తాః సర్వ్వవార్త్తా అవదన్| ");
INSERT INTO santel_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","తతో నాగరికాః సర్వ్వే మనుజా యీశుం సాక్షాత్ కర్త్తుం బహిరాయాతాః తఞ్చ విలోక్య ప్రార్థయాఞ్చక్రిరే భవాన్ అస్మాకం సీమాతో యాతు| ");
INSERT INTO santel_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","అనన్తరం యీశు ర్నౌకామారుహ్య పునః పారమాగత్య నిజగ్రామమ్ ఆయయౌ| ");
INSERT INTO santel_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","తతః కతిపయా జనా ఏకం పక్షాఘాతినం స్వట్టోపరి శాయయిత్వా తత్సమీపమ్ ఆనయన్; తతో యీశుస్తేషాం ప్రతీతిం విజ్ఞాయ తం పక్షాఘాతినం జగాద, హే పుత్ర, సుస్థిరో భవ, తవ కలుషస్య మర్షణం జాతమ్| ");
INSERT INTO santel_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","తాం కథాం నిశమ్య కియన్త ఉపాధ్యాయా మనఃసు చిన్తితవన్త ఏష మనుజ ఈశ్వరం నిన్దతి| ");
INSERT INTO santel_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","తతః స తేషామ్ ఏతాదృశీం చిన్తాం విజ్ఞాయ కథితవాన్, యూయం మనఃసు కృత ఏతాదృశీం కుచిన్తాం కురుథ? ");
INSERT INTO santel_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","తవ పాపమర్షణం జాతం, యద్వా త్వముత్థాయ గచ్ఛ, ద్వయోరనయో ర్వాక్యయోః కిం వాక్యం వక్తుం సుగమం? ");
INSERT INTO santel_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","కిన్తు మేదిన్యాం కలుషం క్షమితుం మనుజసుతస్య సామర్థ్యమస్తీతి యూయం యథా జానీథ, తదర్థం స తం పక్షాఘాతినం గదితవాన్, ఉత్తిష్ఠ, నిజశయనీయం ఆదాయ గేహం గచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","తతః స తత్క్షణాద్ ఉత్థాయ నిజగేహం ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","మానవా ఇత్థం విలోక్య విస్మయం మేనిరే, ఈశ్వరేణ మానవాయ సామర్థ్యమ్ ఈదృశం దత్తం ఇతి కారణాత్ తం ధన్యం బభాషిరే చ| ");
INSERT INTO santel_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","అనన్తరం యీశుస్తత్స్థానాద్ గచ్ఛన్ గచ్ఛన్ కరసంగ్రహస్థానే సముపవిష్టం మథినామానమ్ ఏకం మనుజం విలోక్య తం బభాషే, మమ పశ్చాద్ ఆగచ్ఛ, తతః స ఉత్థాయ తస్య పశ్చాద్ వవ్రాజ| ");
INSERT INTO santel_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","తతః పరం యీశౌ గృహే భోక్తుమ్ ఉపవిష్టే బహవః కరసంగ్రాహిణః కలుషిణశ్చ మానవా ఆగత్య తేన సాకం తస్య శిష్యైశ్చ సాకమ్ ఉపవివిశుః| ");
INSERT INTO santel_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ఫిరూశినస్తద్ దృష్ట్వా తస్య శిష్యాన్ బభాషిరే, యుష్మాకం గురుః కిం నిమిత్తం కరసంగ్రాహిభిః కలుషిభిశ్చ సాకం భుంక్తే? ");
INSERT INTO santel_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","యీశుస్తత్ శ్రుత్వా తాన్ ప్రత్యవదత్, నిరామయలోకానాం చికిత్సకేన ప్రయోజనం నాస్తి, కిన్తు సామయలోకానాం ప్రయోజనమాస్తే| ");
INSERT INTO santel_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","అతో యూయం యాత్వా వచనస్యాస్యార్థం శిక్షధ్వమ్, దయాయాం మే యథా ప్రీతి ర్న తథా యజ్ఞకర్మ్మణి| యతోఽహం ధార్మ్మికాన్ ఆహ్వాతుం నాగతోఽస్మి కిన్తు మనః పరివర్త్తయితుం పాపిన ఆహ్వాతుమ్ ఆగతోఽస్మి| ");
INSERT INTO santel_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","అనన్తరం యోహనః శిష్యాస్తస్య సమీపమ్ ఆగత్య కథయామాసుః, ఫిరూశినో వయఞ్చ పునః పునరుపవసామః, కిన్తు తవ శిష్యా నోపవసన్తి, కుతః? ");
INSERT INTO santel_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","తదా యీశుస్తాన్ అవోచత్ యావత్ సఖీనాం సంఙ్గే కన్యాయా వరస్తిష్ఠతి, తావత్ కిం తే విలాపం కర్త్తుం శక్లువన్తి? కిన్తు యదా తేషాం సంఙ్గాద్ వరం నయన్తి, తాదృశః సమయ ఆగమిష్యతి, తదా తే ఉపవత్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","పురాతనవసనే కోపి నవీనవస్త్రం న యోజయతి, యస్మాత్ తేన యోజితేన పురాతనవసనం ఛినత్తి తచ్ఛిద్రఞ్చ బహుకుత్సితం దృశ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","అన్యఞ్చ పురాతనకుత్వాం కోపి నవానగోస్తనీరసం న నిదధాతి, యస్మాత్ తథా కృతే కుతూ ర్విదీర్య్యతే తేన గోస్తనీరసః పతతి కుతూశ్చ నశ్యతి; తస్మాత్ నవీనాయాం కుత్వాం నవీనో గోస్తనీరసః స్థాప్యతే, తేన ద్వయోరవనం భవతి| ");
INSERT INTO santel_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","అపరం తేనైతత్కథాకథనకాలే ఏకోఽధిపతిస్తం ప్రణమ్య బభాషే, మమ దుహితా ప్రాయేణైతావత్కాలే మృతా, తస్మాద్ భవానాగత్య తస్యా గాత్రే హస్తమర్పయతు, తేన సా జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","తదానీం యీశుః శిష్యైః సాకమ్ ఉత్థాయ తస్య పశ్చాద్ వవ్రాజ| ");
INSERT INTO santel_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ఇత్యనన్తరే ద్వాదశవత్సరాన్ యావత్ ప్రదరామయేన శీర్ణైకా నారీ తస్య పశ్చాద్ ఆగత్య తస్య వసనస్య గ్రన్థిం పస్పర్శ; ");
INSERT INTO santel_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","యస్మాత్ మయా కేవలం తస్య వసనం స్పృష్ట్వా స్వాస్థ్యం ప్రాప్స్యతే, సా నారీతి మనసి నిశ్చితవతీ| ");
INSERT INTO santel_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","తతో యీశుర్వదనం పరావర్త్త్య తాం జగాద, హే కన్యే, త్వం సుస్థిరా భవ, తవ విశ్వాసస్త్వాం స్వస్థామకార్షీత్| ఏతద్వాక్యే గదితఏవ సా యోషిత్ స్వస్థాభూత్| ");
INSERT INTO santel_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","అపరం యీశుస్తస్యాధ్యక్షస్య గేహం గత్వా వాదకప్రభృతీన్ బహూన్ లోకాన్ శబ్దాయమానాన్ విలోక్య తాన్ అవదత్, ");
INSERT INTO santel_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","పన్థానం త్యజ, కన్యేయం నామ్రియత నిద్రితాస్తే; కథామేతాం శ్రుత్వా తే తముపజహసుః| ");
INSERT INTO santel_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","కిన్తు సర్వ్వేషు బహిష్కృతేషు సోఽభ్యన్తరం గత్వా కన్యాయాః కరం ధృతవాన్, తేన సోదతిష్ఠత్; ");
INSERT INTO santel_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","తతస్తత్కర్మ్మణో యశః కృత్స్నం తం దేశం వ్యాప్తవత్| ");
INSERT INTO santel_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","తతః పరం యీశుస్తస్మాత్ స్థానాద్ యాత్రాం చకార; తదా హే దాయూదః సన్తాన, అస్మాన్ దయస్వ, ఇతి వదన్తౌ ద్వౌ జనావన్ధౌ ప్రోచైరాహూయన్తౌ తత్పశ్చాద్ వవ్రజతుః| ");
INSERT INTO santel_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","తతో యీశౌ గేహమధ్యం ప్రవిష్టం తావపి తస్య సమీపమ్ ఉపస్థితవన్తౌ, తదానీం స తౌ పృష్టవాన్ కర్మ్మైతత్ కర్త్తుం మమ సామర్థ్యమ్ ఆస్తే, యువాం కిమితి ప్రతీథః? తదా తౌ ప్రత్యూచతుః, సత్యం ప్రభో| ");
INSERT INTO santel_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","తదానీం స తయో ర్లోచనాని స్పృశన్ బభాషే, యువయోః ప్రతీత్యనుసారాద్ యువయో ర్మఙ్గలం భూయాత్| తేన తత్క్షణాత్ తయో ర్నేత్రాణి ప్రసన్నాన్యభవన్, ");
INSERT INTO santel_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","పశ్చాద్ యీశుస్తౌ దృఢమాజ్ఞాప్య జగాద, అవధత్తమ్ ఏతాం కథాం కోపి మనుజో మ జానీయాత్| ");
INSERT INTO santel_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","కిన్తు తౌ ప్రస్థాయ తస్మిన్ కృత్స్నే దేశే తస్య కీర్త్తిం ప్రకాశయామాసతుః| ");
INSERT INTO santel_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","అపరం తౌ బహిర్యాత ఏతస్మిన్నన్తరే మనుజా ఏకం భూతగ్రస్తమూకం తస్య సమీపమ్ ఆనీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","తేన భూతే త్యాజితే స మూకః కథాం కథయితుం ప్రారభత, తేన జనా విస్మయం విజ్ఞాయ కథయామాసుః, ఇస్రాయేలో వంశే కదాపి నేదృగదృశ్యత; ");
INSERT INTO santel_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","కిన్తు ఫిరూశినః కథయాఞ్చక్రుః భూతాధిపతినా స భూతాన్ త్యాజయతి| ");
INSERT INTO santel_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","తతః పరం యీశుస్తేషాం భజనభవన ఉపదిశన్ రాజ్యస్య సుసంవాదం ప్రచారయన్ లోకానాం యస్య య ఆమయో యా చ పీడాసీత్, తాన్ శమయన్ శమయంశ్చ సర్వ్వాణి నగరాణి గ్రామాంశ్చ బభ్రామ| ");
INSERT INTO santel_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","అన్యఞ్చ మనుజాన్ వ్యాకులాన్ అరక్షకమేషానివ చ త్యక్తాన్ నిరీక్ష్య తేషు కారుణికః సన్ శిష్యాన్ అవదత్, ");
INSERT INTO santel_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","శస్యాని ప్రచురాణి సన్తి, కిన్తు ఛేత్తారః స్తోకాః| ");
INSERT INTO santel_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","క్షేత్రం ప్రత్యపరాన్ ఛేదకాన్ ప్రహేతుం శస్యస్వామినం ప్రార్థయధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","అనన్తరం యీశు ర్ద్వాదశశిష్యాన్ ఆహూయామేధ్యభూతాన్ త్యాజయితుం సర్వ్వప్రకారరోగాన్ పీడాశ్చ శమయితుం తేభ్యః సామర్థ్యమదాత్| ");
INSERT INTO santel_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","తేషాం ద్వాదశప్రేష్యాణాం నామాన్యేతాని| ప్రథమం శిమోన్ యం పితరం వదన్తి, తతః పరం తస్య సహజ ఆన్ద్రియః, సివదియస్య పుత్రో యాకూబ్ ");
INSERT INTO santel_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","తస్య సహజో యోహన్; ఫిలిప్ బర్థలమయ్ థోమాః కరసంగ్రాహీ మథిః, ఆల్ఫేయపుత్రో యాకూబ్, ");
INSERT INTO santel_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","కినానీయః శిమోన్, య ఈష్కరియోతీయయిహూదాః ఖ్రీష్టం పరకరేఽర్పయత్| ");
INSERT INTO santel_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ఏతాన్ ద్వాదశశిష్యాన్ యీశుః ప్రేషయన్ ఇత్యాజ్ఞాపయత్, యూయమ్ అన్యదేశీయానాం పదవీం శేమిరోణీయానాం కిమపి నగరఞ్చ న ప్రవిశ్యే ");
INSERT INTO santel_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ఇస్రాయేల్గోత్రస్య హారితా యే యే మేషాస్తేషామేవ సమీపం యాత| ");
INSERT INTO santel_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","గత్వా గత్వా స్వర్గస్య రాజత్వం సవిధమభవత్, ఏతాం కథాం ప్రచారయత| ");
INSERT INTO santel_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ఆమయగ్రస్తాన్ స్వస్థాన్ కురుత, కుష్ఠినః పరిష్కురుత, మృతలోకాన్ జీవయత, భూతాన్ త్యాజయత, వినా మూల్యం యూయమ్ అలభధ్వం వినైవ మూల్యం విశ్రాణయత| ");
INSERT INTO santel_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","కిన్తు స్వేషాం కటిబన్ధేషు స్వర్ణరూప్యతామ్రాణాం కిమపి న గృహ్లీత| ");
INSERT INTO santel_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","అన్యచ్చ యాత్రాయై చేలసమ్పుటం వా ద్వితీయవసనం వా పాదుకే వా యష్టిః, ఏతాన్ మా గృహ్లీత, యతః కార్య్యకృత్ భర్త్తుం యోగ్యో భవతి| ");
INSERT INTO santel_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","అపరం యూయం యత్ పురం యఞ్చ గ్రామం ప్రవిశథ, తత్ర యో జనో యోగ్యపాత్రం తమవగత్య యానకాలం యావత్ తత్ర తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","యదా యూయం తద్గేహం ప్రవిశథ, తదా తమాశిషం వదత| ");
INSERT INTO santel_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","యది స యోగ్యపాత్రం భవతి, తర్హి తత్కల్యాణం తస్మై భవిష్యతి, నోచేత్ సాశీర్యుష్మభ్యమేవ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","కిన్తు యే జనా యుష్మాకమాతిథ్యం న విదధతి యుష్మాకం కథాఞ్చ న శృణ్వన్తి తేషాం గేహాత్ పురాద్వా ప్రస్థానకాలే స్వపదూలీః పాతయత| ");
INSERT INTO santel_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","యుష్మానహం తథ్యం వచ్మి విచారదినే తత్పురస్య దశాతః సిదోమమోరాపురయోర్దశా సహ్యతరా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","పశ్యత, వృకయూథమధ్యే మేషః యథావిస్తథా యుష్మాన ప్రహిణోమి, తస్మాద్ యూయమ్ అహిరివ సతర్కాః కపోతాఇవాహింసకా భవత| ");
INSERT INTO santel_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","నృభ్యః సావధానా భవత; యతస్తై ర్యూయం రాజసంసది సమర్పిష్యధ్వే తేషాం భజనగేహే ప్రహారిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","యూయం మన్నామహేతోః శాస్తృణాం రాజ్ఞాఞ్చ సమక్షం తానన్యదేశినశ్చాధి సాక్షిత్వార్థమానేష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","కిన్త్విత్థం సమర్పితా యూయం కథం కిముత్తరం వక్ష్యథ తత్ర మా చిన్తయత, యతస్తదా యుష్మాభి ర్యద్ వక్తవ్యం తత్ తద్దణ్డే యుష్మన్మనః సు సముపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","యస్మాత్ తదా యో వక్ష్యతి స న యూయం కిన్తు యుష్మాకమన్తరస్థః పిత్రాత్మా| ");
INSERT INTO santel_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","సహజః సహజం తాతః సుతఞ్చ మృతౌ సమర్పయిష్యతి, అపత్యాగి స్వస్వపిత్రోे ర్విపక్షీభూయ తౌ ఘాతయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","మన్నమహేతోః సర్వ్వే జనా యుష్మాన్ ఋृతీయిష్యన్తే, కిన్తు యః శేషం యావద్ ధైర్య్యం ఘృత్వా స్థాస్యతి, స త్రాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","తై ర్యదా యూయమేకపురే తాడిష్యధ్వే, తదా యూయమన్యపురం పలాయధ్వం యుష్మానహం తథ్యం వచ్మి యావన్మనుజసుతో నైతి తావద్ ఇస్రాయేల్దేశీయసర్వ్వనగరభ్రమణం సమాపయితుం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","గురోః శిష్యో న మహాన్, ప్రభోర్దాసో న మహాన్| ");
INSERT INTO santel_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","యది శిష్యో నిజగురో ర్దాసశ్చ స్వప్రభోః సమానో భవతి తర్హి తద్ యథేష్టం| చేత్తైర్గృహపతిర్భూతరాజ ఉచ్యతే, తర్హి పరివారాః కిం తథా న వక్ష్యన్తే? ");
INSERT INTO santel_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","కిన్తు తేభ్యో యూయం మా బిభీత, యతో యన్న ప్రకాశిష్యతే, తాదృక్ ఛాదితం కిమపి నాస్తి, యచ్చ న వ్యఞ్చిష్యతే, తాదృగ్ గుప్తం కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","యదహం యుష్మాన్ తమసి వచ్మి తద్ యుష్మాభిర్దీప్తౌ కథ్యతాం; కర్ణాభ్యాం యత్ శ్రూయతే తద్ గేహోపరి ప్రచార్య్యతాం| ");
INSERT INTO santel_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","యే కాయం హన్తుం శక్నువన్తి నాత్మానం, తేభ్యో మా భైష్ట; యః కాయాత్మానౌ నిరయే నాశయితుం, శక్నోతి, తతో బిభీత| ");
INSERT INTO santel_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ద్వౌ చటకౌ కిమేకతామ్రముద్రయా న విక్రీయేతే? తథాపి యుష్మత్తాతానుమతిం వినా తేషామేకోపి భువి న పతతి| ");
INSERT INTO santel_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","యుష్మచ్ఛిరసాం సర్వ్వకచా గణితాంః సన్తి| ");
INSERT INTO santel_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","అతో మా బిభీత, యూయం బహుచటకేభ్యో బహుమూల్యాః| ");
INSERT INTO santel_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","యో మనుజసాక్షాన్మామఙ్గీకురుతే తమహం స్వర్గస్థతాతసాక్షాదఙ్గీకరిష్యే| ");
INSERT INTO santel_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","పృథ్వ్యామహం శాన్తిం దాతుమాగతఇతి మానుభవత, శాన్తిం దాతుం న కిన్త్వసిం| ");
INSERT INTO santel_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","పితృమాతృశ్చశ్రూభిః సాకం సుతసుతాబధూ ర్విరోధయితుఞ్చాగతేाస్మి| ");
INSERT INTO santel_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","తతః స్వస్వపరివారఏవ నృశత్రు ర్భవితా| ");
INSERT INTO santel_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","యః పితరి మాతరి వా మత్తోధికం ప్రీయతే, స న మదర్హః; ");
INSERT INTO santel_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","యశ్చ సుతే సుతాయాం వా మత్తోధికం ప్రీయతే, సేाపి న మదర్హః| ");
INSERT INTO santel_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","యః స్వక్రుశం గృహ్లన్ మత్పశ్చాన్నైతి, సేाపి న మదర్హః| ");
INSERT INTO santel_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","యః స్వప్రాణానవతి, స తాన్ హారయిష్యతే, యస్తు మత్కృతే స్వప్రాణాన్ హారయతి, స తానవతి| ");
INSERT INTO santel_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","యో యుష్మాకమాతిథ్యం విదధాతి, స మమాతిథ్యం విదధాతి, యశ్చ మమాతిథ్యం విదధాతి, స మత్ప్రేరకస్యాతిథ్యం విదధాతి| ");
INSERT INTO santel_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","యో భవిష్యద్వాదీతి జ్ఞాత్వా తస్యాతిథ్యం విధత్తే, స భవిష్యద్వాదినః ఫలం లప్స్యతే, యశ్చ ధార్మ్మిక ఇతి విదిత్వా తస్యాతిథ్యం విధత్తే స ధార్మ్మికమానవస్య ఫలం ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","యశ్చ కశ్చిత్ ఏతేషాం క్షుద్రనరాణామ్ యం కఞ్చనైకం శిష్య ఇతి విదిత్వా కంసైకం శీతలసలిలం తస్మై దత్తే, యుష్మానహం తథ్యం వదామి, స కేనాపి ప్రకారేణ ఫలేన న వఞ్చిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ఇత్థం యీశుః స్వద్వాదశశిష్యాణామాజ్ఞాపనం సమాప్య పురే పుర ఉపదేష్టుం సుసంవాదం ప్రచారయితుం తత్స్థానాత్ ప్రతస్థే| ");
INSERT INTO santel_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","అనన్తరం యోహన్ కారాయాం తిష్ఠన్ ఖ్రిష్టస్య కర్మ్మణాం వార్త్తం ప్రాప్య యస్యాగమనవార్త్తాసీత్ సఏవ కిం త్వం? వా వయమన్యమ్ అపేక్షిష్యామహే? ");
INSERT INTO santel_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ఏతత్ ప్రష్టుం నిజౌ ద్వౌ శిష్యౌ ప్రాహిణోత్| ");
INSERT INTO santel_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","యీశుః ప్రత్యవోచత్, అన్ధా నేత్రాణి లభన్తే, ఖఞ్చా గచ్ఛన్తి, కుష్ఠినః స్వస్థా భవన్తి, బధిరాః శృణ్వన్తి, మృతా జీవన్త ఉత్తిష్ఠన్తి, దరిద్రాణాం సమీపే సుసంవాదః ప్రచార్య్యత, ");
INSERT INTO santel_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ఏతాని యద్యద్ యువాం శృణుథః పశ్యథశ్చ గత్వా తద్వార్త్తాం యోహనం గదతం| ");
INSERT INTO santel_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","యస్యాహం న విఘ్నీభవామి, సఏవ ధన్యః| ");
INSERT INTO santel_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","అనన్తరం తయోః ప్రస్థితయో ర్యీశు ర్యోహనమ్ ఉద్దిశ్య జనాన్ జగాద, యూయం కిం ద్రష్టుం వహిర్మధ్యేప్రాన్తరమ్ అగచ్ఛత? కిం వాతేన కమ్పితం నలం? ");
INSERT INTO santel_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","వా కిం వీక్షితుం వహిర్గతవన్తః? కిం పరిహితసూక్ష్మవసనం మనుజమేకం? పశ్యత, యే సూక్ష్మవసనాని పరిదధతి, తే రాజధాన్యాం తిష్ఠన్తి| ");
INSERT INTO santel_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","తర్హి యూయం కిం ద్రష్టుం బహిరగమత, కిమేకం భవిష్యద్వాదినం? తదేవ సత్యం| యుష్మానహం వదామి, స భవిష్యద్వాదినోపి మహాన్; ");
INSERT INTO santel_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","యతః, పశ్య స్వకీయదూతోయం త్వదగ్రే ప్రేష్యతే మయా| స గత్వా తవ పన్థానం స్మయక్ పరిష్కరిష్యతి|| ఏతద్వచనం యమధి లిఖితమాస్తే సోఽయం యోహన్| ");
INSERT INTO santel_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","అపరం యుష్మానహం తథ్యం బ్రవీమి, మజ్జయితు ర్యోహనః శ్రేష్ఠః కోపి నారీతో నాజాయత; తథాపి స్వర్గరాజ్యమధ్యే సర్వ్వేభ్యో యః క్షుద్రః స యోహనః శ్రేష్ఠః| ");
INSERT INTO santel_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","అపరఞ్చ ఆ యోహనోఽద్య యావత్ స్వర్గరాజ్యం బలాదాక్రాన్తం భవతి ఆక్రమినశ్చ జనా బలేన తదధికుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","యతో యోహనం యావత్ సర్వ్వభవిష్యద్వాదిభి ర్వ్యవస్థయా చ ఉపదేశః ప్రాకాశ్యత| ");
INSERT INTO santel_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","యది యూయమిదం వాక్యం గ్రహీతుం శక్నుథ, తర్హి శ్రేయః, యస్యాగమనస్య వచనమాస్తే సోఽయమ్ ఏలియః| ");
INSERT INTO santel_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","యస్య శ్రోతుం కర్ణౌ స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ఏతే విద్యమానజనాః కై ర్మయోపమీయన్తే? యే బాలకా హట్ట ఉపవిశ్య స్వం స్వం బన్ధుమాహూయ వదన్తి, ");
INSERT INTO santel_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","వయం యుష్మాకం సమీపే వంశీరవాదయామ, కిన్తు యూయం నానృత్యత; యుష్మాకం సమీపే చ వయమరోదిమ, కిన్తు యూయం న వ్యలపత, తాదృశై ర్బాలకైస్త ఉపమాయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","యతో యోహన్ ఆగత్య న భుక్తవాన్ న పీతవాంశ్చ, తేన లోకా వదన్తి, స భూతగ్రస్త ఇతి| ");
INSERT INTO santel_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","మనుజసుత ఆగత్య భుక్తవాన్ పీతవాంశ్చ, తేన లోకా వదన్తి, పశ్యత ఏష భోక్తా మద్యపాతా చణ్డాలపాపినాం బన్ధశ్చ, కిన్తు జ్ఞానినో జ్ఞానవ్యవహారం నిర్దోషం జానన్తి| ");
INSERT INTO santel_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","స యత్ర యత్ర పురే బహ్వాశ్చర్య్యం కర్మ్మ కృతవాన్, తన్నివాసినాం మనఃపరావృత్త్యభావాత్ తాని నగరాణి ప్రతి హన్తేత్యుక్తా కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","హా కోరాసీన్, హా బైత్సైదే, యుష్మన్మధ్యే యద్యదాశ్చర్య్యం కర్మ్మ కృతం యది తత్ సోరసీదోన్నగర అకారిష్యత, తర్హి పూర్వ్వమేవ తన్నివాసినః శాణవసనే భస్మని చోపవిశన్తో మనాంసి పరావర్త్తిష్యన్త| ");
INSERT INTO santel_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","తస్మాదహం యుష్మాన్ వదామి, విచారదినే యుష్మాకం దశాతః సోరసీదోనో ర్దశా సహ్యతరా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","అపరఞ్చ బత కఫర్నాహూమ్, త్వం స్వర్గం యావదున్నతోసి, కిన్తు నరకే నిక్షేప్స్యసే, యస్మాత్ త్వయి యాన్యాశ్చర్య్యాణి కర్మ్మణ్యకారిషత, యది తాని సిదోమ్నగర అకారిష్యన్త, తర్హి తదద్య యావదస్థాస్యత్| ");
INSERT INTO santel_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","కిన్త్వహం యుష్మాన్ వదామి, విచారదినే తవ దణ్డతః సిదోమో దణ్డో సహ్యతరో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ఏతస్మిన్నేవ సమయే యీశుః పునరువాచ, హే స్వర్గపృథివ్యోరేకాధిపతే పితస్త్వం జ్ఞానవతో విదుషశ్చ లోకాన్ ప్రత్యేతాని న ప్రకాశ్య బాలకాన్ ప్రతి ప్రకాశితవాన్, ఇతి హేతోస్త్వాం ధన్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","హే పితః, ఇత్థం భవేత్ యత ఇదం త్వదృష్టావుత్తమం| ");
INSERT INTO santel_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","పిత్రా మయి సర్వ్వాణి సమర్పితాని, పితరం వినా కోపి పుత్రం న జానాతి, యాన్ ప్రతి పుత్రేణ పితా ప్రకాశ్యతే తాన్ వినా పుత్రాద్ అన్యః కోపి పితరం న జానాతి| ");
INSERT INTO santel_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","హే పరిశ్రాన్తా భారాక్రాన్తాశ్చ లోకా యూయం మత్సన్నిధిమ్ ఆగచ్ఛత, అహం యుష్మాన్ విశ్రమయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","అహం క్షమణశీలో నమ్రమనాశ్చ, తస్మాత్ మమ యుగం స్వేషాముపరి ధారయత మత్తః శిక్షధ్వఞ్చ, తేన యూయం స్వే స్వే మనసి విశ్రామం లప్స్యధ్బే| ");
INSERT INTO santel_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","యతో మమ యుగమ్ అనాయాసం మమ భారశ్చ లఘుః| ");
INSERT INTO santel_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","అనన్తరం యీశు ర్విశ్రామవారే శ్స్యమధ్యేన గచ్ఛతి, తదా తచ్ఛిష్యా బుభుక్షితాః సన్తః శ్స్యమఞ్జరీశ్ఛత్వా ఛిత్వా ఖాదితుమారభన్త| ");
INSERT INTO santel_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","తద్ విలోక్య ఫిరూశినో యీశుం జగదుః, పశ్య విశ్రామవారే యత్ కర్మ్మాకర్త్తవ్యం తదేవ తవ శిష్యాః కుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","స తాన్ ప్రత్యావదత, దాయూద్ తత్సఙ్గినశ్చ బుభుక్షితాః సన్తో యత్ కర్మ్మాకుర్వ్వన్ తత్ కిం యుష్మాభి ర్నాపాఠి? ");
INSERT INTO santel_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","యే దర్శనీయాః పూపాః యాజకాన్ వినా తస్య తత్సఙ్గిమనుజానాఞ్చాభోజనీయాస్త ఈశ్వరావాసం ప్రవిష్టేన తేన భుక్తాః| ");
INSERT INTO santel_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","అన్యచ్చ విశ్రామవారే మధ్యేమన్దిరం విశ్రామవారీయం నియమం లఙ్వన్తోపి యాజకా నిర్దోషా భవన్తి, శాస్త్రమధ్యే కిమిదమపి యుష్మాభి ర్న పఠితం? ");
INSERT INTO santel_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","యుష్మానహం వదామి, అత్ర స్థానే మన్దిరాదపి గరీయాన్ ఏక ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","కిన్తు దయాయాం మే యథా ప్రీతి ర్న తథా యజ్ఞకర్మ్మణి| ఏతద్వచనస్యార్థం యది యుయమ్ అజ్ఞాసిష్ట తర్హి నిర్దోషాన్ దోషిణో నాకార్ష్ట| ");
INSERT INTO santel_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","అన్యచ్చ మనుజసుతో విశ్రామవారస్యాపి పతిరాస్తే| ");
INSERT INTO santel_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","అనన్తరం స తత్స్థానాత్ ప్రస్థాయ తేషాం భజనభవనం ప్రవిష్టవాన్, తదానీమ్ ఏకః శుష్కకరామయవాన్ ఉపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","తతో యీశుమ్ అపవదితుం మానుషాః పప్రచ్ఛుః, విశ్రామవారే నిరామయత్వం కరణీయం న వా? ");
INSERT INTO santel_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","తేన స ప్రత్యువాచ, విశ్రామవారే యది కస్యచిద్ అవి ర్గర్త్తే పతతి, తర్హి యస్తం ఘృత్వా న తోలయతి, ఏతాదృశో మనుజో యుష్మాకం మధ్యే క ఆస్తే? ");
INSERT INTO santel_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","అవే ర్మానవః కిం నహి శ్రేయాన్? అతో విశ్రామవారే హితకర్మ్మ కర్త్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","అనన్తరం స తం మానవం గదితవాన్, కరం ప్రసారయ; తేన కరే ప్రసారితే సోన్యకరవత్ స్వస్థోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","తదా ఫిరూశినో బహిర్భూయ కథం తం హనిష్యామ ఇతి కుమన్త్రణాం తత్ప్రాతికూల్యేన చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","తతో యీశుస్తద్ విదిత్వా స్థనాన్తరం గతవాన్; అన్యేషు బహునరేషు తత్పశ్చాద్ గతేషు తాన్ స నిరామయాన్ కృత్వా ఇత్యాజ్ఞాపయత్, ");
INSERT INTO santel_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","యూయం మాం న పరిచాయయత| ");
INSERT INTO santel_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","తస్మాత్ మమ ప్రీయో మనోనీతో మనసస్తుష్టికారకః| మదీయః సేవకో యస్తు విద్యతే తం సమీక్షతాం| తస్యోపరి స్వకీయాత్మా మయా సంస్థాపయిష్యతే| తేనాన్యదేశజాతేషు వ్యవస్థా సంప్రకాశ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","కేనాపి న విరోధం స వివాదఞ్చ కరిష్యతి| న చ రాజపథే తేన వచనం శ్రావయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","వ్యవస్థా చలితా యావత్ నహి తేన కరిష్యతే| తావత్ నలో విదీర్ణోఽపి భంక్ష్యతే నహి తేన చ| తథా సధూమవర్త్తిఞ్చ న స నిర్వ్వాపయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ప్రత్యాశాఞ్చ కరిష్యన్తి తన్నామ్ని భిన్నదేశజాః| ");
INSERT INTO santel_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","యాన్యేతాని వచనాని యిశయియభవిష్యద్వాదినా ప్రోక్తాన్యాసన్, తాని సఫలాన్యభవన్| ");
INSERT INTO santel_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","అనన్తరం లోకై స్తత్సమీపమ్ ఆనీతో భూతగ్రస్తాన్ధమూకైకమనుజస్తేన స్వస్థీకృతః, తతః సోఽన్ధో మూకో ద్రష్టుం వక్తుఞ్చారబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","అనేన సర్వ్వే విస్మితాః కథయాఞ్చక్రుః, ఏషః కిం దాయూదః సన్తానో నహి? ");
INSERT INTO santel_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","కిన్తు ఫిరూశినస్తత్ శ్రుత్వా గదితవన్తః, బాల్సిబూబ్నామ్నో భూతరాజస్య సాహాయ్యం వినా నాయం భూతాన్ త్యాజయతి| ");
INSERT INTO santel_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","తదానీం యీశుస్తేషామ్ ఇతి మానసం విజ్ఞాయ తాన్ అవదత్ కిఞ్చన రాజ్యం యది స్వవిపక్షాద్ భిద్యతే, తర్హి తత్ ఉచ్ఛిద్యతే; యచ్చ కిఞ్చన నగరం వా గృహం స్వవిపక్షాద్ విభిద్యతే, తత్ స్థాతుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","తద్వత్ శయతానో యది శయతానం బహిః కృత్వా స్వవిపక్షాత్ పృథక్ పృథక్ భవతి, తర్హి తస్య రాజ్యం కేన ప్రకారేణ స్థాస్యతి? ");
INSERT INTO santel_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","అహఞ్చ యది బాల్సిబూబా భూతాన్ త్యాజయామి, తర్హి యుష్మాకం సన్తానాః కేన భూతాన్ త్యాజయన్తి? తస్మాద్ యుష్మాకమ్ ఏతద్విచారయితారస్త ఏవ భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","కిన్తవహం యదీశ్వరాత్మనా భూతాన్ త్యాజయామి, తర్హీశ్వరస్య రాజ్యం యుష్మాకం సన్నిధిమాగతవత్| ");
INSERT INTO santel_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","అన్యఞ్చ కోపి బలవన్త జనం ప్రథమతో న బద్వ్వా కేన ప్రకారేణ తస్య గృహం ప్రవిశ్య తద్ద్రవ్యాది లోఠయితుం శక్నోతి? కిన్తు తత్ కృత్వా తదీయగృస్య ద్రవ్యాది లోఠయితుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","యః కశ్చిత్ మమ స్వపక్షీయో నహి స విపక్షీయ ఆస్తే, యశ్చ మయా సాకం న సంగృహ్లాతి, స వికిరతి| ");
INSERT INTO santel_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","అతఏవ యుష్మానహం వదామి, మనుజానాం సర్వ్వప్రకారపాపానాం నిన్దాయాశ్చ మర్షణం భవితుం శక్నోతి, కిన్తు పవిత్రస్యాత్మనో విరుద్ధనిన్దాయా మర్షణం భవితుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","యో మనుజసుతస్య విరుద్ధాం కథాం కథయతి, తస్యాపరాధస్య క్షమా భవితుం శక్నోతి, కిన్తు యః కశ్చిత్ పవిత్రస్యాత్మనో విరుద్ధాం కథాం కథయతి నేహలోకే న ప్రేత్య తస్యాపరాధస్య క్షమా భవితుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","పాదపం యది భద్రం వదథ, తర్హి తస్య ఫలమపి సాధు వక్తవ్యం, యది చ పాదపం అసాధుం వదథ, తర్హి తస్య ఫలమప్యసాధు వక్తవ్యం; యతః స్వీయస్వీయఫలేన పాదపః పరిచీయతే| ");
INSERT INTO santel_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","రే భుజగవంశా యూయమసాధవః సన్తః కథం సాధు వాక్యం వక్తుం శక్ష్యథ? యస్మాద్ అన్తఃకరణస్య పూర్ణభావానుసారాద్ వదనాద్ వచో నిర్గచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","తేన సాధుర్మానవోఽన్తఃకరణరూపాత్ సాధుభాణ్డాగారాత్ సాధు ద్రవ్యం నిర్గమయతి, అసాధుర్మానుషస్త్వసాధుభాణ్డాగారాద్ అసాధువస్తూని నిర్గమయతి| ");
INSERT INTO santel_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","కిన్త్వహం యుష్మాన్ వదామి, మనుజా యావన్త్యాలస్యవచాంసి వదన్తి, విచారదినే తదుత్తరమవశ్యం దాతవ్యం, ");
INSERT INTO santel_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","యతస్త్వం స్వీయవచోభి ర్నిరపరాధః స్వీయవచోభిశ్చ సాపరాధో గణిష్యసే| ");
INSERT INTO santel_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","తదానీం కతిపయా ఉపాధ్యాయాః ఫిరూశినశ్చ జగదుః, హే గురో వయం భవత్తః కిఞ్చన లక్ష్మ దిదృక్షామః| ");
INSERT INTO santel_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","తదా స ప్రత్యుక్తవాన్, దుష్టో వ్యభిచారీ చ వంశో లక్ష్మ మృగయతే, కిన్తు భవిష్యద్వాదినో యూనసో లక్ష్మ విహాయాన్యత్ కిమపి లక్ష్మ తే న ప్రదర్శయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","యతో యూనమ్ యథా త్ర్యహోరాత్రం బృహన్మీనస్య కుక్షావాసీత్, తథా మనుజపుత్రోపి త్ర్యహోరాత్రం మేదిన్యా మధ్యే స్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","అపరం నీనివీయా మానవా విచారదిన ఏతద్వంశీయానాం ప్రతికూలమ్ ఉత్థాయ తాన్ దోషిణః కరిష్యన్తి, యస్మాత్తే యూనస ఉపదేశాత్ మనాంసి పరావర్త్తయాఞ్చక్రిరే, కిన్త్వత్ర యూనసోపి గురుతర ఏక ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","పునశ్చ దక్షిణదేశీయా రాజ్ఞీ విచారదిన ఏతద్వంశీయానాం ప్రతికూలముత్థాయ తాన్ దోషిణః కరిష్యతి యతః సా రాజ్ఞీ సులేమనో విద్యాయాః కథాం శ్రోతుం మేదిన్యాః సీమ్న ఆగచ్ఛత్, కిన్తు సులేమనోపి గురుతర ఏకో జనోఽత్ర ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","అపరం మనుజాద్ బహిర్గతో ఽపవిత్రభూతః శుష్కస్థానేన గత్వా విశ్రామం గవేషయతి, కిన్తు తదలభమానః స వక్తి, యస్మా; నికేతనాద్ ఆగమం, తదేవ వేశ్మ పకావృత్య యామి| ");
INSERT INTO santel_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","పశ్చాత్ స తత్ స్థానమ్ ఉపస్థాయ తత్ శూన్యం మార్జ్జితం శోభితఞ్చ విలోక్య వ్రజన్ స్వతోపి దుష్టతరాన్ అన్యసప్తభూతాన్ సఙ్గినః కరోతి| ");
INSERT INTO santel_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","తతస్తే తత్ స్థానం ప్రవిశ్య నివసన్తి, తేన తస్య మనుజస్య శేషదశా పూర్వ్వదశాతోతీవాశుభా భవతి, ఏతేషాం దుష్టవంశ్యానామపి తథైవ ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","మానవేభ్య ఏతాసాం కథనాం కథనకాలే తస్య మాతా సహజాశ్చ తేన సాకం కాఞ్చిత్ కథాం కథయితుం వాఞ్ఛన్తో బహిరేవ స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","తతః కశ్చిత్ తస్మై కథితవాన్, పశ్య తవ జననీ సహజాశ్చ త్వయా సాకం కాఞ్చన కథాం కథయితుం కామయమానా బహిస్తిష్ఠన్తి| ");
INSERT INTO santel_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","కిన్తు స తం ప్రత్యవదత్, మమ కా జననీ? కే వా మమ సహజాః? ");
INSERT INTO santel_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","పశ్చాత్ శిష్యాన్ ప్రతి కరం ప్రసార్య్య కథితవాన్, పశ్య మమ జననీ మమ సహజాశ్చైతే; ");
INSERT INTO santel_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","యః కశ్చిత్ మమ స్వర్గస్థస్య పితురిష్టం కర్మ్మ కురుతే, సఏవ మమ భ్రాతా భగినీ జననీ చ| ");
INSERT INTO santel_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","అపరఞ్చ తస్మిన్ దినే యీశుః సద్మనో గత్వా సరిత్పతే రోధసి సముపవివేశ| ");
INSERT INTO santel_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","తత్ర తత్సన్నిధౌ బహుజనానాం నివహోపస్థితేః స తరణిమారుహ్య సముపావిశత్, తేన మానవా రోధసి స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","తదానీం స దృష్టాన్తైస్తాన్ ఇత్థం బహుశ ఉపదిష్టవాన్| పశ్యత, కశ్చిత్ కృషీవలో బీజాని వప్తుం బహిర్జగామ, ");
INSERT INTO santel_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","తస్య వపనకాలే కతిపయబీజేషు మార్గపార్శ్వే పతితేషు విహగాస్తాని భక్షితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","అపరం కతిపయబీజేషు స్తోకమృద్యుక్తపాషాణే పతితేషు మృదల్పత్వాత్ తత్క్షణాత్ తాన్యఙ్కురితాని, ");
INSERT INTO santel_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","కిన్తు రవావుదితే దగ్ధాని తేషాం మూలాప్రవిష్టత్వాత్ శుష్కతాం గతాని చ| ");
INSERT INTO santel_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","అపరం కతిపయబీజేషు కణ్టకానాం మధ్యే పతితేషు కణ్టకాన్యేధిత్వా తాని జగ్రసుః| ");
INSERT INTO santel_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","అపరఞ్చ కతిపయబీజాని ఉర్వ్వరాయాం పతితాని; తేషాం మధ్యే కానిచిత్ శతగుణాని కానిచిత్ షష్టిగుణాని కానిచిత్ త్రింశగుంణాని ఫలాని ఫలితవన్తి| ");
INSERT INTO santel_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","శ్రోతుం యస్య శ్రుతీ ఆసాతే స శృణుయాత్| ");
INSERT INTO santel_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","అనన్తరం శిష్యైరాగత్య సోఽపృచ్ఛ్యత, భవతా తేభ్యః కుతో దృష్టాన్తకథా కథ్యతే? ");
INSERT INTO santel_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","తతః స ప్రత్యవదత్, స్వర్గరాజ్యస్య నిగూఢాం కథాం వేదితుం యుష్మభ్యం సామర్థ్యమదాయి, కిన్తు తేభ్యో నాదాయి| ");
INSERT INTO santel_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","యస్మాద్ యస్యాన్తికే వర్ద్ధతే, తస్మాయేవ దాయిష్యతే, తస్మాత్ తస్య బాహుల్యం భవిష్యతి, కిన్తు యస్యాన్తికే న వర్ద్ధతే, తస్య యత్ కిఞ్చనాస్తే, తదపి తస్మాద్ ఆదాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","తే పశ్యన్తోపి న పశ్యన్తి, శృణ్వన్తోపి న శృణ్వన్తి, బుధ్యమానా అపి న బుధ్యన్తే చ, తస్మాత్ తేభ్యో దృష్టాన్తకథా కథ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","యథా కర్ణైః శ్రోష్యథ యూయం వై కిన్తు యూయం న భోత్స్యథ| నేత్రైర్ద్రక్ష్యథ యూయఞ్చ పరిజ్ఞాతుం న శక్ష్యథ| తే మానుషా యథా నైవ పరిపశ్యన్తి లోచనైః| కర్ణై ర్యథా న శృణ్వన్తి న బుధ్యన్తే చ మానసైః| వ్యావర్త్తితేషు చిత్తేషు కాలే కుత్రాపి తైర్జనైః| మత్తస్తే మనుజాః స్వస్థా యథా నైవ భవన్తి చ| తథా తేషాం మనుష్యాణాం క్రియన్తే స్థూలబుద్ధయః| బధిరీభూతకర్ణాశ్చ జాతాశ్చ ముద్రితా దృశః| ");
INSERT INTO santel_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","యదేతాని వచనాని యిశయియభవిష్యద్వాదినా ప్రోక్తాని తేషు తాని ఫలన్తి| ");
INSERT INTO santel_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","కిన్తు యుష్మాకం నయనాని ధన్యాని, యస్మాత్ తాని వీక్షన్తే; ధన్యాశ్చ యుష్మాకం శబ్దగ్రహాః, యస్మాత్ తైరాకర్ణ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","మయా యూయం తథ్యం వచామి యుష్మాభి ర్యద్యద్ వీక్ష్యతే, తద్ బహవో భవిష్యద్వాదినో ధార్మ్మికాశ్చ మానవా దిదృక్షన్తోపి ద్రష్టుం నాలభన్త, పునశ్చ యూయం యద్యత్ శృణుథ, తత్ తే శుశ్రూషమాణా అపి శ్రోతుం నాలభన్త| ");
INSERT INTO santel_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","కృషీవలీయదృష్టాన్తస్యార్థం శృణుత| ");
INSERT INTO santel_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","మార్గపార్శ్వే బీజాన్యుప్తాని తస్యార్థ ఏషః, యదా కశ్చిత్ రాజ్యస్య కథాం నిశమ్య న బుధ్యతే, తదా పాపాత్మాగత్య తదీయమనస ఉప్తాం కథాం హరన్ నయతి| ");
INSERT INTO santel_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","అపరం పాషాణస్థలే బీజాన్యుప్తాని తస్యార్థ ఏషః; కశ్చిత్ కథాం శ్రుత్వైవ హర్షచిత్తేన గృహ్లాతి, ");
INSERT INTO santel_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","కిన్తు తస్య మనసి మూలాప్రవిష్టత్వాత్ స కిఞ్చిత్కాలమాత్రం స్థిరస్తిష్ఠతి; పశ్చాత తత్కథాకారణాత్ కోపి క్లేస్తాడనా వా చేత్ జాయతే, తర్హి స తత్క్షణాద్ విఘ్నమేతి| ");
INSERT INTO santel_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","అపరం కణ్టకానాం మధ్యే బీజాన్యుప్తాని తదర్థ ఏషః; కేనచిత్ కథాయాం శ్రుతాయాం సాంసారికచిన్తాభి ర్భ్రాన్తిభిశ్చ సా గ్రస్యతే, తేన సా మా విఫలా భవతి| ");
INSERT INTO santel_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","అపరమ్ ఉర్వ్వరాయాం బీజాన్యుప్తాని తదర్థ ఏషః; యే తాం కథాం శ్రుత్వా వుధ్యన్తే, తే ఫలితాః సన్తః కేచిత్ శతగుణాని కేచిత షష్టిగుణాని కేచిచ్చ త్రింశద్గుణాని ఫలాని జనయన్తి| ");
INSERT INTO santel_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","అనన్తరం సోపరామేకాం దృష్టాన్తకథాముపస్థాప్య తేభ్యః కథయామాస; స్వర్గీయరాజ్యం తాదృశేన కేనచిద్ గృహస్థేనోపమీయతే, యేన స్వీయక్షేత్రే ప్రశస్తబీజాన్యౌప్యన్త| ");
INSERT INTO santel_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","కిన్తు క్షణదాయాం సకలలోకేషు సుప్తేషు తస్య రిపురాగత్య తేషాం గోధూమబీజానాం మధ్యే వన్యయవమబీజాన్యుప్త్వా వవ్రాజ| ");
INSERT INTO santel_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","తతో యదా బీజేభ్యోఽఙ్కరా జాయమానాః కణిశాని ఘృతవన్తః; తదా వన్యయవసాన్యపి దృశ్యమానాన్యభవన్| ");
INSERT INTO santel_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","తతో గృహస్థస్య దాసేయా ఆగమ్య తస్మై కథయాఞ్చక్రుః, హే మహేచ్ఛ, భవతా కిం క్షేత్రే భద్రబీజాని నౌప్యన్త? తథాత్వే వన్యయవసాని కృత ఆయన్? ");
INSERT INTO santel_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","తదానీం తేన తే ప్రతిగదితాః, కేనచిత్ రిపుణా కర్మ్మదమకారి| దాసేయాః కథయామాసుః, వయం గత్వా తాన్యుత్పాయ్య క్షిపామో భవతః కీదృశీచ్ఛా జాయతే? ");
INSERT INTO santel_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","తేనావాది, నహి, శఙ్కేఽహం వన్యయవసోత్పాటనకాలే యుష్మాభిస్తైః సాకం గోధూమా అప్యుత్పాటిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","అతః శ్స్యకర్త్తనకాలం యావద్ ఉభయాన్యపి సహ వర్ద్ధన్తాం, పశ్చాత్ కర్త్తనకాలే కర్త్తకాన్ వక్ష్యామి, యూయమాదౌ వన్యయవసాని సంగృహ్య దాహయితుం వీటికా బద్వ్వా స్థాపయత; కిన్తు సర్వ్వే గోధూమా యుష్మాభి ర్భాణ్డాగారం నీత్వా స్థాప్యన్తామ్| ");
INSERT INTO santel_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","అనన్తరం సోపరామేకాం దృష్టాన్తకథాముత్థాప్య తేభ్యః కథితవాన్ కశ్చిన్మనుజః సర్షపబీజమేకం నీత్వా స్వక్షేత్ర ఉవాప| ");
INSERT INTO santel_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","సర్షపబీజం సర్వ్వస్మాద్ బీజాత్ క్షుద్రమపి సదఙ్కురితం సర్వ్వస్మాత్ శాకాత్ బృహద్ భవతి; స తాదృశస్తరు ర్భవతి, యస్య శాఖాసు నభసః ఖగా ఆగత్య నివసన్తి; స్వర్గీయరాజ్యం తాదృశస్య సర్షపైకస్య సమమ్| ");
INSERT INTO santel_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","పునరపి స ఉపమాకథామేకాం తేభ్యః కథయాఞ్చకార; కాచన యోషిత్ యత్ కిణ్వమాదాయ ద్రోణత్రయమితగోధూమచూర్ణానాం మధ్యే సర్వ్వేషాం మిశ్రీభవనపర్య్యన్తం సమాచ్ఛాద్య నిధత్తవతీ, తత్కిణ్వమివ స్వర్గరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ఇత్థం యీశు ర్మనుజనివహానాం సన్నిధావుపమాకథాభిరేతాన్యాఖ్యానాని కథితవాన్ ఉపమాం వినా తేభ్యః కిమపి కథాం నాకథయత్| ");
INSERT INTO santel_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ఏతేన దృష్టాన్తీయేన వాక్యేన వ్యాదాయ వదనం నిజం| అహం ప్రకాశయిష్యామి గుప్తవాక్యం పురాభవం| యదేతద్వచనం భవిష్యద్వాదినా ప్రోక్తమాసీత్, తత్ సిద్ధమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","సర్వ్వాన్ మనుజాన్ విసృజ్య యీశౌ గృహం ప్రవిష్టే తచ్ఛిష్యా ఆగత్య యీశవే కథితవన్తః, క్షేత్రస్య వన్యయవసీయదృష్టాన్తకథామ్ భవాన అస్మాన్ స్పష్టీకృత్య వదతు| ");
INSERT INTO santel_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","తతః స ప్రత్యువాచ, యేన భద్రబీజాన్యుప్యన్తే స మనుజపుత్రః, ");
INSERT INTO santel_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","క్షేత్రం జగత్, భద్రబీజానీ రాజ్యస్య సన్తానాః, ");
INSERT INTO santel_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","వన్యయవసాని పాపాత్మనః సన్తానాః| యేన రిపుణా తాన్యుప్తాని స శయతానః, కర్త్తనసమయశ్చ జగతః శేషః, కర్త్తకాః స్వర్గీయదూతాః| ");
INSERT INTO santel_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","యథా వన్యయవసాని సంగృహ్య దాహ్యన్తే, తథా జగతః శేషే భవిష్యతి; ");
INSERT INTO santel_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","అర్థాత్ మనుజసుతః స్వాంయదూతాన్ ప్రేషయిష్యతి, తేన తే చ తస్య రాజ్యాత్ సర్వ్వాన్ విఘ్నకారిణోఽధార్మ్మికలోకాంశ్చ సంగృహ్య ");
INSERT INTO santel_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","యత్ర రోదనం దన్తఘర్షణఞ్చ భవతి, తత్రాగ్నికుణ్డే నిక్షేప్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","తదానీం ధార్మ్మికలోకాః స్వేషాం పితూ రాజ్యే భాస్కరఇవ తేజస్వినో భవిష్యన్తి| శ్రోతుం యస్య శ్రుతీ ఆసాతే, మ శృణుయాత్| ");
INSERT INTO santel_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","అపరఞ్చ క్షేత్రమధ్యే నిధిం పశ్యన్ యో గోపయతి, తతః పరం సానన్దో గత్వా స్వీయసర్వ్వస్వం విక్రీయ త్తక్షేత్రం క్రీణాతి, స ఇవ స్వర్గరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","అన్యఞ్చ యో వణిక్ ఉత్తమాం ముక్తాం గవేషయన్ ");
INSERT INTO santel_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","మహార్ఘాం ముక్తాం విలోక్య నిజసర్వ్వస్వం విక్రీయ తాం క్రీణాతి, స ఇవ స్వర్గరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","పునశ్చ సముద్రో నిక్షిప్తః సర్వ్వప్రకారమీనసంగ్రాహ్యానాయఇవ స్వర్గరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","తస్మిన్ ఆనాయే పూర్ణే జనా యథా రోధస్యుత్తోల్య సముపవిశ్య ప్రశస్తమీనాన్ సంగ్రహ్య భాజనేషు నిదధతే, కుత్సితాన్ నిక్షిపన్తి; ");
INSERT INTO santel_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","తథైవ జగతః శేషే భవిష్యతి, ఫలతః స్వర్గీయదూతా ఆగత్య పుణ్యవజ్జనానాం మధ్యాత్ పాపినః పృథక్ కృత్వా వహ్నికుణ్డే నిక్షేప్స్యన్తి, ");
INSERT INTO santel_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","తత్ర రోదనం దన్తై ర్దన్తఘర్షణఞ్చ భవిష్యతః| ");
INSERT INTO santel_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","యీశునా తే పృష్టా యుష్మాభిః కిమేతాన్యాఖ్యానాన్యబుధ్యన్త? తదా తే ప్రత్యవదన్, సత్యం ప్రభో| ");
INSERT INTO santel_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","తదానీం స కథితవాన్, నిజభాణ్డాగారాత్ నవీనపురాతనాని వస్తూని నిర్గమయతి యో గృహస్థః స ఇవ స్వర్గరాజ్యమధి శిక్షితాః స్వర్వ ఉపదేష్టారః| ");
INSERT INTO santel_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","అనన్తరం యీశురేతాః సర్వ్వా దృష్టాన్తకథాః సమాప్య తస్మాత్ స్థానాత్ ప్రతస్థే| అపరం స్వదేశమాగత్య జనాన్ భజనభవన ఉపదిష్టవాన్; ");
INSERT INTO santel_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","తే విస్మయం గత్వా కథితవన్త ఏతస్యైతాదృశం జ్ఞానమ్ ఆశ్చర్య్యం కర్మ్మ చ కస్మాద్ అజాయత? ");
INSERT INTO santel_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","కిమయం సూత్రధారస్య పుత్రో నహి? ఏతస్య మాతు ర్నామ చ కిం మరియమ్ నహి? యాకుబ్-యూషఫ్-శిమోన్-యిహూదాశ్చ కిమేతస్య భ్రాతరో నహి? ");
INSERT INTO santel_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ఏతస్య భగిన్యశ్చ కిమస్మాకం మధ్యే న సన్తి? తర్హి కస్మాదయమేతాని లబ్ధవాన్? ఇత్థం స తేషాం విఘ్నరూపో బభూవ; ");
INSERT INTO santel_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","తతో యీశునా నిగదితం స్వదేశీయజనానాం మధ్యం వినా భవిష్యద్వాదీ కుత్రాప్యన్యత్ర నాసమ్మాన్యో భవతీ| ");
INSERT INTO santel_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","తేషామవిశ్వాసహేతోః స తత్ర స్థానే బహ్వాశ్చర్య్యకర్మ్మాణి న కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","తదానీం రాజా హేరోద్ యీశో ర్యశః శ్రుత్వా నిజదాసేయాన్ జగాద్, ");
INSERT INTO santel_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ఏష మజ్జయితా యోహన్, ప్రమితేభయస్తస్యోత్థానాత్ తేనేత్థమద్భుతం కర్మ్మ ప్రకాశ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","పురా హేరోద్ నిజభ్రాతు: ఫిలిపో జాయాయా హేరోదీయాయా అనురోధాద్ యోహనం ధారయిత్వా బద్ధా కారాయాం స్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","యతో యోహన్ ఉక్తవాన్, ఏత్సయాః సంగ్రహో భవతో నోచితః| ");
INSERT INTO santel_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","తస్మాత్ నృపతిస్తం హన్తుమిచ్ఛన్నపి లోకేభ్యో విభయాఞ్చకార; యతః సర్వ్వే యోహనం భవిష్యద్వాదినం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","కిన్తు హేరోదో జన్మాహీయమహ ఉపస్థితే హేరోదీయాయా దుహితా తేషాం సమక్షం నృతిత్వా హేరోదమప్రీణ్యత్| ");
INSERT INTO santel_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","తస్మాత్ భూపతిః శపథం కుర్వ్వన్ ఇతి ప్రత్యజ్ఞాసీత్, త్వయా యద్ యాచ్యతే, తదేవాహం దాస్యామి| ");
INSERT INTO santel_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","సా కుమారీ స్వీయమాతుః శిక్షాం లబ్ధా బభాషే, మజ్జయితుర్యోహన ఉత్తమాఙ్గం భాజనే సమానీయ మహ్యం విశ్రాణయ| ");
INSERT INTO santel_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","తతో రాజా శుశోచ, కిన్తు భోజనాయోపవిశతాం సఙ్గినాం స్వకృతశపథస్య చానురోధాత్ తత్ ప్రదాతుమ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","పశ్చాత్ కారాం ప్రతి నరం ప్రహిత్య యోహన ఉత్తమాఙ్గం ఛిత్త్వా ");
INSERT INTO santel_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","తత్ భాజన ఆనాయ్య తస్యై కుమార్య్యై వ్యశ్రాణయత్, తతః సా స్వజనన్యాః సమీపం తన్నినాయ| ");
INSERT INTO santel_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","పశ్చాత్ యోహనః శిష్యా ఆగత్య కాయం నీత్వా శ్మశానే స్థాపయామాసుస్తతో యీశోః సన్నిధిం వ్రజిత్వా తద్వార్త్తాం బభాషిరే| ");
INSERT INTO santel_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","అనన్తరం యీశురితి నిశభ్య నావా నిర్జనస్థానమ్ ఏకాకీ గతవాన్, పశ్చాత్ మానవాస్తత్ శ్రుత్వా నానానగరేభ్య ఆగత్య పదైస్తత్పశ్చాద్ ఈయుః| ");
INSERT INTO santel_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","తదానీం యీశు ర్బహిరాగత్య మహాన్తం జననివహం నిరీక్ష్య తేషు కారుణికః మన్ తేషాం పీడితజనాన్ నిరామయాన్ చకార| ");
INSERT INTO santel_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","తతః పరం సన్ధ్యాయాం శిష్యాస్తదన్తికమాగత్య కథయాఞ్చక్రుః, ఇదం నిర్జనస్థానం వేలాప్యవసన్నా; తస్మాత్ మనుజాన్ స్వస్వగ్రామం గన్తుం స్వార్థం భక్ష్యాణి క్రేతుఞ్చ భవాన్ తాన్ విసృజతు| ");
INSERT INTO santel_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","కిన్తు యీశుస్తానవాదీత్, తేషాం గమనే ప్రయోజనం నాస్తి, యూయమేవ తాన్ భోజయత| ");
INSERT INTO santel_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","తదా తే ప్రత్యవదన్, అస్మాకమత్ర పూపపఞ్చకం మీనద్వయఞ్చాస్తే| ");
INSERT INTO santel_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","తదానీం తేనోక్తం తాని మదన్తికమానయత| ");
INSERT INTO santel_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","అనన్తరం స మనుజాన్ యవసోపర్య్యుపవేష్టుమ్ ఆజ్ఞాపయామాస; అపర తత్ పూపపఞ్చకం మీనద్వయఞ్చ గృహ్లన్ స్వర్గం ప్రతి నిరీక్ష్యేశ్వరీయగుణాన్ అనూద్య భంక్త్వా శిష్యేభ్యో దత్తవాన్, శిష్యాశ్చ లోకేభ్యో దదుః| ");
INSERT INTO santel_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","తతః సర్వ్వే భుక్త్వా పరితృప్తవన్తః, తతస్తదవశిష్టభక్ష్యైః పూర్ణాన్ ద్వాదశడలకాన్ గృహీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","తే భోక్తారః స్త్రీర్బాలకాంశ్చ విహాయ ప్రాయేణ పఞ్చ సహస్రాణి పుమాంస ఆసన్| ");
INSERT INTO santel_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","తదనన్తరం యీశు ర్లోకానాం విసర్జనకాలే శిష్యాన్ తరణిమారోఢుం స్వాగ్రే పారం యాతుఞ్చ గాఢమాదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","తతో లోకేషు విసృష్టేషు స వివిక్తే ప్రార్థయితుం గిరిమేకం గత్వా సన్ధ్యాం యావత్ తత్రైకాకీ స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","కిన్తు తదానీం సమ్ముఖవాతత్వాత్ సరిత్పతే ర్మధ్యే తరఙ్గైస్తరణిర్దోలాయమానాభవత్| ");
INSERT INTO santel_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","తదా స యామిన్యాశ్చతుర్థప్రహరే పద్భ్యాం వ్రజన్ తేషామన్తికం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","కిన్తు శిష్యాస్తం సాగరోపరి వ్రజన్తం విలోక్య సముద్విగ్నా జగదుః, ఏష భూత ఇతి శఙ్కమానా ఉచ్చైః శబ్దాయాఞ్చక్రిరే చ| ");
INSERT INTO santel_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","తదైవ యీశుస్తానవదత్, సుస్థిరా భవత, మా భైష్ట, ఏషోఽహమ్| ");
INSERT INTO santel_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","తతః పితర ఇత్యుక్తవాన్, హే ప్రభో, యది భవానేవ, తర్హి మాం భవత్సమీపం యాతుమాజ్ఞాపయతు| ");
INSERT INTO santel_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","తతః తేనాదిష్టః పితరస్తరణితోఽవరుహ్య యీశేाరన్తికం ప్రాప్తుం తోయోపరి వవ్రాజ| ");
INSERT INTO santel_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","కిన్తు ప్రచణ్డం పవనం విలోక్య భయాత్ తోయే మంక్తుమ్ ఆరేభే, తస్మాద్ ఉచ్చైః శబ్దాయమానః కథితవాన్, హే ప్రభో, మామవతు| ");
INSERT INTO santel_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","యీశుస్తత్క్షణాత్ కరం ప్రసార్య్య తం ధరన్ ఉక్తవాన్, హ స్తోకప్రత్యయిన్ త్వం కుతః సమశేథాః? ");
INSERT INTO santel_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","అనన్తరం తయోస్తరణిమారూఢయోః పవనో నివవృతే| ");
INSERT INTO santel_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","తదానీం యే తరణ్యామాసన్, త ఆగత్య తం ప్రణభ్య కథితవన్తః, యథార్థస్త్వమేవేశ్వరసుతః| ");
INSERT INTO santel_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","అనన్తరం పారం ప్రాప్య తే గినేషరన్నామకం నగరముపతస్థుః, ");
INSERT INTO santel_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","తదా తత్రత్యా జనా యీశుం పరిచీయ తద్దేశ్స్య చతుర్దిశో వార్త్తాం ప్రహిత్య యత్ర యావన్తః పీడితా ఆసన్, తావతఏవ తదన్తికమానయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","అపరం తదీయవసనస్య గ్రన్థిమాత్రం స్ప్రష్టుం వినీయ యావన్తో జనాస్తత్ స్పర్శం చక్రిరే, తే సర్వ్వఏవ నిరామయా బభూవుః| ");
INSERT INTO santel_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","అపరం యిరూశాలమ్నగరీయాః కతిపయా అధ్యాపకాః ఫిరూశినశ్చ యీశోః సమీపమాగత్య కథయామాసుః, ");
INSERT INTO santel_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","తవ శిష్యాః కిమర్థమ్ అప్రక్షాలితకరై ర్భక్షిత్వా పరమ్పరాగతం ప్రాచీనానాం వ్యవహారం లఙ్వన్తే? ");
INSERT INTO santel_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","తతో యీశుః ప్రత్యువాచ, యూయం పరమ్పరాగతాచారేణ కుత ఈశ్వరాజ్ఞాం లఙ్వధ్వే| ");
INSERT INTO santel_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ఈశ్వర ఇత్యాజ్ఞాపయత్, త్వం నిజపితరౌ సంమన్యేథాః, యేన చ నిజపితరౌ నిన్ద్యేతే, స నిశ్చితం మ్రియేత; ");
INSERT INTO santel_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","కిన్తు యూయం వదథ, యః స్వజనకం స్వజననీం వా వాక్యమిదం వదతి, యువాం మత్తో యల్లభేథే, తత్ న్యవిద్యత, ");
INSERT INTO santel_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","స నిజపితరౌ పున ర్న సంమంస్యతే| ఇత్థం యూయం పరమ్పరాగతేన స్వేషామాచారేణేశ్వరీయాజ్ఞాం లుమ్పథ| ");
INSERT INTO santel_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","రే కపటినః సర్వ్వే యిశయియో యుష్మానధి భవిష్యద్వచనాన్యేతాని సమ్యగ్ ఉక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","వదనై ర్మనుజా ఏతే సమాయాన్తి మదన్తికం| తథాధరై ర్మదీయఞ్చ మానం కుర్వ్వన్తి తే నరాః| ");
INSERT INTO santel_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","కిన్తు తేషాం మనో మత్తో విదూరఏవ తిష్ఠతి| శిక్షయన్తో విధీన్ న్రాజ్ఞా భజన్తే మాం ముధైవ తే| ");
INSERT INTO santel_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","తతో యీశు ర్లోకాన్ ఆహూయ ప్రోక్తవాన్, యూయం శ్రుత్వా బుధ్యధ్బం| ");
INSERT INTO santel_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","యన్ముఖం ప్రవిశతి, తత్ మనుజమ్ అమేధ్యం న కరోతి, కిన్తు యదాస్యాత్ నిర్గచ్ఛతి, తదేవ మానుషమమేధ్యీ కరోతీ| ");
INSERT INTO santel_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","తదానీం శిష్యా ఆగత్య తస్మై కథయాఞ్చక్రుః, ఏతాం కథాం శ్రుత్వా ఫిరూశినో వ్యరజ్యన్త, తత్ కిం భవతా జ్ఞాయతే? ");
INSERT INTO santel_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","స ప్రత్యవదత్, మమ స్వర్గస్థః పితా యం కఞ్చిదఙ్కురం నారోపయత్, స ఉత్పావ్ద్యతే| ");
INSERT INTO santel_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","తే తిష్ఠన్తు, తే అన్ధమనుజానామ్ అన్ధమార్గదర్శకా ఏవ; యద్యన్ధోఽన్ధం పన్థానం దర్శయతి, తర్హ్యుభౌ గర్త్తే పతతః| ");
INSERT INTO santel_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","తదా పితరస్తం ప్రత్యవదత్, దృష్టాన్తమిమమస్మాన్ బోధయతు| ");
INSERT INTO santel_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","యీశునా ప్రోక్తం, యూయమద్య యావత్ కిమబోధాః స్థ? ");
INSERT INTO santel_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","కథామిమాం కిం న బుధ్యధ్బే ? యదాస్యం ప్రేవిశతి, తద్ ఉదరే పతన్ బహిర్నిర్యాతి, ");
INSERT INTO santel_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","కిన్త్వాస్యాద్ యన్నిర్యాతి, తద్ అన్తఃకరణాత్ నిర్యాతత్వాత్ మనుజమమేధ్యం కరోతి| ");
INSERT INTO santel_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","యతోఽన్తఃకరణాత్ కుచిన్తా బధః పారదారికతా వేశ్యాగమనం చైర్య్యం మిథ్యాసాక్ష్యమ్ ఈశ్వరనిన్దా చైతాని సర్వ్వాణి నిర్య్యాన్తి| ");
INSERT INTO santel_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ఏతాని మనుష్యమపవిత్రీ కుర్వ్వన్తి కిన్త్వప్రక్షాలితకరేణ భోజనం మనుజమమేధ్యం న కరోతి| ");
INSERT INTO santel_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","అనన్తరం యీశుస్తస్మాత్ స్థానాత్ ప్రస్థాయ సోరసీదోన్నగరయోః సీమాముపతస్యౌ| ");
INSERT INTO santel_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","తదా తత్సీమాతః కాచిత్ కినానీయా యోషిద్ ఆగత్య తముచ్చైరువాచ, హే ప్రభో దాయూదః సన్తాన, మమైకా దుహితాస్తే సా భూతగ్రస్తా సతీ మహాక్లేశం ప్రాప్నోతి మమ దయస్వ| ");
INSERT INTO santel_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","కిన్తు యీశుస్తాం కిమపి నోక్తవాన్, తతః శిష్యా ఆగత్య తం నివేదయామాసుః, ఏషా యోషిద్ అస్మాకం పశ్చాద్ ఉచ్చైరాహూయాగచ్ఛతి, ఏనాం విసృజతు| ");
INSERT INTO santel_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","తదా స ప్రత్యవదత్, ఇస్రాయేల్గోత్రస్య హారితమేషాన్ వినా కస్యాప్యన్యస్య సమీపం నాహం ప్రేషితోస్మి| ");
INSERT INTO santel_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","తతః సా నారీసమాగత్య తం ప్రణమ్య జగాద, హే ప్రభో మాముపకురు| ");
INSERT INTO santel_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","స ఉక్తవాన్, బాలకానాం భక్ష్యమాదాయ సారమేయేభ్యో దానం నోచితం| ");
INSERT INTO santel_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","తదా సా బభాషే, హే ప్రభో, తత్ సత్యం, తథాపి ప్రభో ర్భఞ్చాద్ యదుచ్ఛిష్టం పతతి, తత్ సారమేయాః ఖాదన్తి| ");
INSERT INTO santel_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","తతో యీశుః ప్రత్యవదత్, హే యోషిత్, తవ విశ్వాసో మహాన్ తస్మాత్ తవ మనోభిలషితం సిద్య్యతు, తేన తస్యాః కన్యా తస్మిన్నేవ దణ్డే నిరామయాభవత్| ");
INSERT INTO santel_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","అనన్తరం యీశస్తస్మాత్ స్థానాత్ ప్రస్థాయ గాలీల్సాగరస్య సన్నిధిమాగత్య ధరాధరమారుహ్య తత్రోపవివేశ| ");
INSERT INTO santel_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","పశ్చాత్ జననివహో బహూన్ ఖఞ్చాన్ధమూకశుష్కకరమానుషాన్ ఆదాయ యీశోః సమీపమాగత్య తచ్చరణాన్తికే స్థాపయామాసుః, తతః సా తాన్ నిరామయాన్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ఇత్థం మూకా వాక్యం వదన్తి, శుష్కకరాః స్వాస్థ్యమాయాన్తి, పఙ్గవో గచ్ఛన్తి, అన్ధా వీక్షన్తే, ఇతి విలోక్య లోకా విస్మయం మన్యమానా ఇస్రాయేల ఈశ్వరం ధన్యం బభాషిరే| ");
INSERT INTO santel_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","తదానీం యీశుః స్వశిష్యాన్ ఆహూయ గదితవాన్, ఏతజ్జననివహేషు మమ దయా జాయతే, ఏతే దినత్రయం మయా సాకం సన్తి, ఏషాం భక్ష్యవస్తు చ కఞ్చిదపి నాస్తి, తస్మాదహమేతానకృతాహారాన్ న విస్రక్ష్యామి, తథాత్వే వర్త్మమధ్యే క్లామ్యేషుః| ");
INSERT INTO santel_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","తదా శిష్యా ఊచుః, ఏతస్మిన్ ప్రాన్తరమధ్య ఏతావతో మర్త్యాన్ తర్పయితుం వయం కుత్ర పూపాన్ ప్రాప్స్యామః? ");
INSERT INTO santel_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","యీశురపృచ్ఛత్, యుష్మాకం నికటే కతి పూపా ఆసతే? త ఊచుః, సప్తపూపా అల్పాః క్షుద్రమీనాశ్చ సన్తి| ");
INSERT INTO santel_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","తదానీం స లోకనివహం భూమావుపవేష్టుమ్ ఆదిశ్య ");
INSERT INTO santel_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","తాన్ సప్తపూపాన్ మీనాంశ్చ గృహ్లన్ ఈశ్వరీయగుణాన్ అనూద్య భంక్త్వా శిష్యేభ్యో దదౌ, శిష్యా లోకేభ్యో దదుః| ");
INSERT INTO santel_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","తతః సర్వ్వే భుక్త్వా తృప్తవన్తః; తదవశిష్టభక్ష్యేణ సప్తడలకాన్ పరిపూర్య్య సంజగృహుః| ");
INSERT INTO santel_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","తే భోక్తారో యోషితో బాలకాంశ్చ విహాయ ప్రాయేణ చతుఃసహస్రాణి పురుషా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","తతః పరం స జననివహం విసృజ్య తరిమారుహ్య మగ్దలాప్రదేశం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","తదానీం ఫిరూశినః సిదూకినశ్చాగత్య తం పరీక్షితుం నభమీయం కిఞ్చన లక్ష్మ దర్శయితుం తస్మై నివేదయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","తతః స ఉక్తవాన్, సన్ధ్యాయాం నభసో రక్తత్వాద్ యూయం వదథ, శ్వో నిర్మ్మలం దినం భవిష్యతి; ");
INSERT INTO santel_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ప్రాతఃకాలే చ నభసో రక్తత్వాత్ మలినత్వాఞ్చ వదథ, ఝఞ్భ్శద్య భవిష్యతి| హే కపటినో యది యూయమ్ అన్తరీక్షస్య లక్ష్మ బోద్ధుం శక్నుథ, తర్హి కాలస్యైతస్య లక్ష్మ కథం బోద్ధుం న శక్నుథ? ");
INSERT INTO santel_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ఏతత్కాలస్య దుష్టో వ్యభిచారీ చ వంశో లక్ష్మ గవేషయతి, కిన్తు యూనసో భవిష్యద్వాదినో లక్ష్మ వినాన్యత్ కిమపి లక్ష్మ తాన్ న దర్శయియ్యతే| తదానీం స తాన్ విహాయ ప్రతస్థే| ");
INSERT INTO santel_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","అనన్తరమన్యపారగమనకాలే తస్య శిష్యాః పూపమానేతుం విస్మృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","యీశుస్తానవాదీత్, యూయం ఫిరూశినాం సిదూకినాఞ్చ కిణ్వం ప్రతి సావధానాః సతర్కాశ్చ భవత| ");
INSERT INTO santel_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","తేన తే పరస్పరం వివిచ్య కథయితుమారేభిరే, వయం పూపానానేతుం విస్మృతవన్త ఏతత్కారణాద్ ఇతి కథయతి| ");
INSERT INTO santel_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","కిన్తు యీశుస్తద్విజ్ఞాయ తానవోచత్, హే స్తోకవిశ్వాసినో యూయం పూపానానయనమధి కుతః పరస్పరమేతద్ వివింక్య? ");
INSERT INTO santel_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","యుష్మాభిః కిమద్యాపి న జ్ఞాయతే? పఞ్చభిః పూపైః పఞ్చసహస్రపురుషేషు భోజితేషు భక్ష్యోచ్ఛిష్టపూర్ణాన్ కతి డలకాన్ సమగృహ్లీతం; ");
INSERT INTO santel_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","తథా సప్తభిః పూపైశ్చతుఃసహస్రపురుషేషు భేజితేషు కతి డలకాన్ సమగృహ్లీత, తత్ కిం యుష్మాభిర్న స్మర్య్యతే? ");
INSERT INTO santel_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","తస్మాత్ ఫిరూశినాం సిదూకినాఞ్చ కిణ్వం ప్రతి సావధానాస్తిష్ఠత, కథామిమామ్ అహం పూపానధి నాకథయం, ఏతద్ యూయం కుతో న బుధ్యధ్వే? ");
INSERT INTO santel_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","తదానీం పూపకిణ్వం ప్రతి సావధానాస్తిష్ఠతేతి నోక్త్వా ఫిరూశినాం సిదూకినాఞ్చ ఉపదేశం ప్రతి సావధానాస్తిష్ఠతేతి కథితవాన్, ఇతి తైరబోధి| ");
INSERT INTO santel_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","అపరఞ్చ యీశుః కైసరియా-ఫిలిపిప్రదేశమాగత్య శిష్యాన్ అపృచ్ఛత్, యోఽహం మనుజసుతః సోఽహం కః? లోకైరహం కిముచ్యే? ");
INSERT INTO santel_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","తదానీం తే కథితవన్తః, కేచిద్ వదన్తి త్వం మజ్జయితా యోహన్, కేచిద్వదన్తి, త్వమ్ ఏలియః, కేచిచ్చ వదన్తి, త్వం యిరిమియో వా కశ్చిద్ భవిష్యద్వాదీతి| ");
INSERT INTO santel_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","పశ్చాత్ స తాన్ పప్రచ్ఛ, యూయం మాం కం వదథ? తతః శిమోన్ పితర ఉవాచ, ");
INSERT INTO santel_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","త్వమమరేశ్వరస్యాభిషిక్తపుత్రః| ");
INSERT INTO santel_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","తతో యీశుః కథితవాన్, హే యూనసః పుత్ర శిమోన్ త్వం ధన్యః; యతః కోపి అనుజస్త్వయ్యేతజ్జ్ఞానం నోదపాదయత్, కిన్తు మమ స్వర్గస్యః పితోదపాదయత్| ");
INSERT INTO santel_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","అతోఽహం త్వాం వదామి, త్వం పితరః (ప్రస్తరః) అహఞ్చ తస్య ప్రస్తరస్యోపరి స్వమణ్డలీం నిర్మ్మాస్యామి, తేన నిరయో బలాత్ తాం పరాజేతుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","అహం తుభ్యం స్వర్గీయరాజ్యస్య కుఞ్జికాం దాస్యామి, తేన యత్ కిఞ్చన త్వం పృథివ్యాం భంత్స్యసి తత్స్వర్గే భంత్స్యతే, యచ్చ కిఞ్చన మహ్యాం మోక్ష్యసి తత్ స్వర్గే మోక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","పశ్చాత్ స శిష్యానాదిశత్, అహమభిషిక్తో యీశురితి కథాం కస్మైచిదపి యూయం మా కథయత| ");
INSERT INTO santel_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","అన్యఞ్చ యిరూశాలమ్నగరం గత్వా ప్రాచీనలోకేభ్యః ప్రధానయాజకేభ్య ఉపాధ్యాయేభ్యశ్చ బహుదుఃఖభోగస్తై ర్హతత్వం తృతీయదినే పునరుత్థానఞ్చ మమావశ్యకమ్ ఏతాః కథా యీశుస్తత్కాలమారభ్య శిష్యాన్ జ్ఞాపయితుమ్ ఆరబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","తదానీం పితరస్తస్య కరం ఘృత్వా తర్జయిత్వా కథయితుమారబ్ధవాన్, హే ప్రభో, తత్ త్వత్తో దూరం యాతు, త్వాం ప్రతి కదాపి న ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","కిన్తు స వదనం పరావర్త్య పితరం జగాద, హే విఘ్నకారిన్, మత్సమ్ముఖాద్ దూరీభవ, త్వం మాం బాధసే, ఈశ్వరీయకార్య్యాత్ మానుషీయకార్య్యం తుభ్యం రోచతే| ");
INSERT INTO santel_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","అనన్తరం యీశుః స్వీయశిష్యాన్ ఉక్తవాన్ యః కశ్చిత్ మమ పశ్చాద్గామీ భవితుమ్ ఇచ్ఛతి, స స్వం దామ్యతు, తథా స్వక్రుశం గృహ్లన్ మత్పశ్చాదాయాతు| ");
INSERT INTO santel_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","యతో యః ప్రాణాన్ రక్షితుమిచ్ఛతి, స తాన్ హారయిష్యతి, కిన్తు యో మదర్థం నిజప్రాణాన్ హారయతి, స తాన్ ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","మానుషో యది సర్వ్వం జగత్ లభతే నిజప్రణాన్ హారయతి, తర్హి తస్య కో లాభః? మనుజో నిజప్రాణానాం వినిమయేన వా కిం దాతుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","మనుజసుతః స్వదూతైః సాకం పితుః ప్రభావేణాగమిష్యతి; తదా ప్రతిమనుజం స్వస్వకర్మ్మానుసారాత్ ఫలం దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","అహం యుష్మాన్ తథ్యం వచ్మి, సరాజ్యం మనుజసుతమ్ ఆగతం న పశ్యన్తో మృత్యుం న స్వాదిష్యన్తి, ఏతాదృశాః కతిపయజనా అత్రాపి దణ్డాయమానాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","అనన్తరం షడ్దినేభ్యః పరం యీశుః పితరం యాకూబం తత్సహజం యోహనఞ్చ గృహ్లన్ ఉచ్చాద్రే ర్వివిక్తస్థానమ్ ఆగత్య తేషాం సమక్షం రూపమన్యత్ దధార| ");
INSERT INTO santel_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","తేన తదాస్యం తేజస్వి, తదాభరణమ్ ఆలోకవత్ పాణ్డరమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","అన్యచ్చ తేన సాకం సంలపన్తౌ మూసా ఏలియశ్చ తేభ్యో దర్శనం దదతుః| ");
INSERT INTO santel_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","తదానీం పితరో యీశుం జగాద, హే ప్రభో స్థితిరత్రాస్మాకం శుభా, యది భవతానుమన్యతే, తర్హి భవదర్థమేకం మూసార్థమేకమ్ ఏలియార్థఞ్చైకమ్ ఇతి త్రీణి దూష్యాణి నిర్మ్మమ| ");
INSERT INTO santel_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ఏతత్కథనకాల ఏక ఉజ్జవలః పయోదస్తేషాముపరి ఛాయాం కృతవాన్, వారిదాద్ ఏషా నభసీయా వాగ్ బభూవ, మమాయం ప్రియః పుత్రః, అస్మిన్ మమ మహాసన్తోష ఏతస్య వాక్యం యూయం నిశామయత| ");
INSERT INTO santel_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","కిన్తు వాచమేతాం శృణ్వన్తఏవ శిష్యా మృశం శఙ్కమానా న్యుబ్జా న్యపతన్| ");
INSERT INTO santel_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","తదా యీశురాగత్య తేషాం గాత్రాణి స్పృశన్ ఉవాచ, ఉత్తిష్ఠత, మా భైష్ట| ");
INSERT INTO santel_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","తదానీం నేత్రాణ్యున్మీల్య యీశుం వినా కమపి న దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","తతః పరమ్ అద్రేరవరోహణకాలే యీశుస్తాన్ ఇత్యాదిదేశ, మనుజసుతస్య మృతానాం మధ్యాదుత్థానం యావన్న జాయతే, తావత్ యుష్మాభిరేతద్దర్శనం కస్మైచిదపి న కథయితవ్యం| ");
INSERT INTO santel_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","తదా శిష్యాస్తం పప్రచ్ఛుః, ప్రథమమ్ ఏలియ ఆయాస్యతీతి కుత ఉపాధ్యాయైరుచ్యతే? ");
INSERT INTO santel_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","తతో యీశుః ప్రత్యవాదీత్, ఏలియః ప్రాగేత్య సర్వ్వాణి సాధయిష్యతీతి సత్యం, ");
INSERT INTO santel_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","కిన్త్వహం యుష్మాన్ వచ్మి, ఏలియ ఏత్య గతః, తే తమపరిచిత్య తస్మిన్ యథేచ్ఛం వ్యవజహుః; మనుజసుతేనాపి తేషామన్తికే తాదృగ్ దుఃఖం భోక్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","తదానీం స మజ్జయితారం యోహనమధి కథామేతాం వ్యాహృతవాన్, ఇత్థం తచ్ఛిష్యా బుబుధిరే| ");
INSERT INTO santel_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","పశ్చాత్ తేషు జననివహస్యాన్తికమాగతేషు కశ్చిత్ మనుజస్తదన్తికమేత్య జానూనీ పాతయిత్వా కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","హే ప్రభో, మత్పుత్రం ప్రతి కృపాం విదధాతు, సోపస్మారామయేన భృశం వ్యథితః సన్ పునః పున ర్వహ్నౌ ముహు ర్జలమధ్యే పతతి| ");
INSERT INTO santel_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","తస్మాద్ భవతః శిష్యాణాం సమీపే తమానయం కిన్తు తే తం స్వాస్థం కర్త్తుం న శక్తాః| ");
INSERT INTO santel_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","తదా యీశుః కథితవాన్ రే అవిశ్వాసినః, రే విపథగామినః, పునః కతికాలాన్ అహం యుష్మాకం సన్నిధౌ స్థాస్యామి? కతికాలాన్ వా యుష్మాన్ సహిష్యే? తమత్ర మమాన్తికమానయత| ");
INSERT INTO santel_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","పశ్చాద్ యీశునా తర్జతఏవ స భూతస్తం విహాయ గతవాన్, తద్దణ్డఏవ స బాలకో నిరామయోఽభూత్| ");
INSERT INTO santel_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","తతః శిష్యా గుప్తం యీశుముపాగత్య బభాషిరే, కుతో వయం తం భూతం త్యాజయితుం న శక్తాః? ");
INSERT INTO santel_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","యీశునా తే ప్రోక్తాః, యుష్మాకమప్రత్యయాత్; ");
INSERT INTO santel_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","యుష్మానహం తథ్యం వచ్మి యది యుష్మాకం సర్షపైకమాత్రోపి విశ్వాసో జాయతే, తర్హి యుష్మాభిరస్మిన్ శైలే త్వమితః స్థానాత్ తత్ స్థానం యాహీతి బ్రూతే స తదైవ చలిష్యతి, యుష్మాకం కిమప్యసాధ్యఞ్చ కర్మ్మ న స్థాస్యాతి| కిన్తు ప్రార్థనోపవాసౌ వినైతాదృశో భూతో న త్యాజ్యేత| ");
INSERT INTO santel_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","అపరం తేషాం గాలీల్ప్రదేశే భ్రమణకాలే యీశునా తే గదితాః, మనుజసుతో జనానాం కరేషు సమర్పయిష్యతే తై ర్హనిష్యతే చ, ");
INSERT INTO santel_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","కిన్తు తృతీయేఽహి्న మ ఉత్థాపిష్యతే, తేన తే భృశం దుఃఖితా బభూవః| ");
INSERT INTO santel_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","తదనన్తరం తేషు కఫర్నాహూమ్నగరమాగతేషు కరసంగ్రాహిణః పితరాన్తికమాగత్య పప్రచ్ఛుః, యుష్మాకం గురుః కిం మన్దిరార్థం కరం న దదాతి? తతః పితరః కథితవాన్ దదాతి| ");
INSERT INTO santel_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","తతస్తస్మిన్ గృహమధ్యమాగతే తస్య కథాకథనాత్ పూర్వ్వమేవ యీశురువాచ, హే శిమోన్, మేదిన్యా రాజానః స్వస్వాపత్యేభ్యః కిం విదేశిభ్యః కేభ్యః కరం గృహ్లన్తి? అత్ర త్వం కిం బుధ్యసే? తతః పితర ఉక్తవాన్, విదేశిభ్యః| ");
INSERT INTO santel_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","తదా యీశురుక్తవాన్, తర్హి సన్తానా ముక్తాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","తథాపి యథాస్మాభిస్తేషామన్తరాయో న జన్యతే, తత్కృతే జలధేస్తీరం గత్వా వడిశం క్షిప, తేనాదౌ యో మీన ఉత్థాస్యతి, తం ఘృత్వా తన్ముఖే మోచితే తోలకైకం రూప్యం ప్రాప్స్యసి, తద్ గృహీత్వా తవ మమ చ కృతే తేభ్యో దేహి| ");
INSERT INTO santel_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","తదానీం శిష్యా యీశోః సమీపమాగత్య పృష్టవన్తః స్వర్గరాజ్యే కః శ్రేష్ఠః? ");
INSERT INTO santel_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","తతో యీశుః క్షుద్రమేకం బాలకం స్వసమీపమానీయ తేషాం మధ్యే నిధాయ జగాద, ");
INSERT INTO santel_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","యుష్మానహం సత్యం బ్రవీమి, యూయం మనోవినిమయేన క్షుద్రబాలవత్ న సన్తః స్వర్గరాజ్యం ప్రవేష్టుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","యః కశ్చిద్ ఏతస్య క్షుద్రబాలకస్య సమమాత్మానం నమ్రీకరోతి, సఏవ స్వర్గరాజయే శ్రేష్ఠః| ");
INSERT INTO santel_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","యః కశ్చిద్ ఏతాదృశం క్షుద్రబాలకమేకం మమ నామ్ని గృహ్లాతి, స మామేవ గృహ్లాతి| ");
INSERT INTO santel_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","కిన్తు యో జనో మయి కృతవిశ్వాసానామేతేషాం క్షుద్రప్రాణినామ్ ఏకస్యాపి విధ్నిం జనయతి, కణ్ఠబద్ధపేషణీకస్య తస్య సాగరాగాధజలే మజ్జనం శ్రేయః| ");
INSERT INTO santel_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","విఘ్నాత్ జగతః సన్తాపో భవిష్యతి, విఘ్నోఽవశ్యం జనయిష్యతే, కిన్తు యేన మనుజేన విఘ్నో జనిష్యతే తస్యైవ సన్తాపో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","తస్మాత్ తవ కరశ్చరణో వా యది త్వాం బాధతే, తర్హి తం ఛిత్త్వా నిక్షిప, ద్వికరస్య ద్విపదస్య వా తవానప్తవహ్నౌ నిక్షేపాత్, ఖఞ్జస్య వా ఛిన్నహస్తస్య తవ జీవనే ప్రవేశో వరం| ");
INSERT INTO santel_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","అపరం తవ నేత్రం యది త్వాం బాధతే, తర్హి తదప్యుత్పావ్య నిక్షిప, ద్వినేత్రస్య నరకాగ్నౌ నిక్షేపాత్ కాణస్య తవ జీవనే ప్రవేశో వరం| ");
INSERT INTO santel_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","తస్మాదవధద్ధం, ఏతేషాం క్షుద్రప్రాణినామ్ ఏకమపి మా తుచ్ఛీకురుత, ");
INSERT INTO santel_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","యతో యుష్మానహం తథ్యం బ్రవీమి, స్వర్గే తేషాం దూతా మమ స్వర్గస్థస్య పితురాస్యం నిత్యం పశ్యన్తి| ఏవం యే యే హారితాస్తాన్ రక్షితుం మనుజపుత్ర ఆగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","యూయమత్ర కిం వివింగ్ఘ్వే? కస్యచిద్ యది శతం మేషాః సన్తి, తేషామేకో హార్య్యతే చ, తర్హి స ఏకోనశతం మేషాన్ విహాయ పర్వ్వతం గత్వా తం హారితమేకం కిం న మృగయతే? ");
INSERT INTO santel_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","యది చ కదాచిత్ తన్మేషోద్దేశం లమతే, తర్హి యుష్మానహం సత్యం కథయామి, సోఽవిపథగామిభ్య ఏకోనశతమేషేభ్యోపి తదేకహేతోరధికమ్ ఆహ్లాదతే| ");
INSERT INTO santel_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","తద్వద్ ఏతేషాం క్షుద్రప్రాఏिనామ్ ఏకోపి నశ్యతీతి యుష్మాకం స్వర్గస్థపితు ర్నాభిమతమ్| ");
INSERT INTO santel_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","యద్యపి తవ భ్రాతా త్వయి కిమప్యపరాధ్యతి, తర్హి గత్వా యువయోర్ద్వయోః స్థితయోస్తస్యాపరాధం తం జ్ఞాపయ| తత్ర స యది తవ వాక్యం శృణోతి, తర్హి త్వం స్వభ్రాతరం ప్రాప్తవాన్, ");
INSERT INTO santel_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","కిన్తు యది న శృణోతి, తర్హి ద్వాభ్యాం త్రిభి ర్వా సాక్షీభిః సర్వ్వం వాక్యం యథా నిశ్చితం జాయతే, తదర్థమ్ ఏకం ద్వౌ వా సాక్షిణౌ గృహీత్వా యాహి| ");
INSERT INTO santel_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","తేన స యది తయో ర్వాక్యం న మాన్యతే, తర్హి సమాజం తజ్జ్ఞాపయ, కిన్తు యది సమాజస్యాపి వాక్యం న మాన్యతే,తర్హి స తవ సమీపే దేవపూజకఇవ చణ్డాలఇవ చ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","అహం యుష్మాన్ సత్యం వదామి, యుష్మాభిః పృథివ్యాం యద్ బధ్యతే తత్ స్వర్గే భంత్స్యతే; మేదిన్యాం యత్ భోచ్యతే, స్వర్గేఽపి తత్ మోక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","పునరహం యుష్మాన్ వదామి, మేదిన్యాం యుష్మాకం యది ద్వావేకవాక్యీభూయ కిఞ్చిత్ ప్రార్థయేతే, తర్హి మమ స్వర్గస్థపిత్రా తత్ తయోః కృతే సమ్పన్నం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","యతో యత్ర ద్వౌ త్రయో వా మమ నాన్ని మిలన్తి, తత్రైవాహం తేషాం మధ్యేఽస్మి| ");
INSERT INTO santel_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","తదానీం పితరస్తత్సమీపమాగత్య కథితవాన్ హే ప్రభో, మమ భ్రాతా మమ యద్యపరాధ్యతి, తర్హి తం కతికృత్వః క్షమిష్యే? ");
INSERT INTO santel_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","కిం సప్తకృత్వః? యీశుస్తం జగాద, త్వాం కేవలం సప్తకృత్వో యావత్ న వదామి, కిన్తు సప్తత్యా గుణితం సప్తకృత్వో యావత్| ");
INSERT INTO santel_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","అపరం నిజదాసైః సహ జిగణయిషుః కశ్చిద్ రాజేవ స్వర్గరాజయం| ");
INSERT INTO santel_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ఆరబ్ధే తస్మిన్ గణనే సార్ద్ధసహస్రముద్రాపూరితానాం దశసహస్రపుటకానామ్ ఏకోఽఘమర్ణస్తత్సమక్షమానాయి| ");
INSERT INTO santel_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","తస్య పరిశోధనాయ ద్రవ్యాభావాత్ పరిశోధనార్థం స తదీయభార్య్యాపుత్రాదిసర్వ్వస్వఞ్చ విక్రీయతామితి తత్ప్రభురాదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","తేన స దాసస్తస్య పాదయోః పతన్ ప్రణమ్య కథితవాన్ , హే ప్రభో భవతా ఘైర్య్యే కృతే మయా సర్వ్వం పరిశోధిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","తదానీం దాసస్య ప్రభుః సకరుణః సన్ సకలర్ణం క్షమిత్వా తం తత్యాజ| ");
INSERT INTO santel_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","కిన్తు తస్మిన్ దాసే బహి ర్యాతే, తస్య శతం ముద్రాచతుర్థాంశాన్ యో ధారయతి, తం సహదాసం దృష్ద్వా తస్య కణ్ఠం నిష్పీడ్య గదితవాన్, మమ యత్ ప్రాప్యం తత్ పరిశోధయ| ");
INSERT INTO santel_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","తదా తస్య సహదాసస్తత్పాదయోః పతిత్వా వినీయ బభాషే, త్వయా ధైర్య్యే కృతే మయా సర్వ్వం పరిశోధిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","తథాపి స తత్ నాఙగీకృత్య యావత్ సర్వ్వమృణం న పరిశోధితవాన్ తావత్ తం కారాయాం స్థాపయామాస| ");
INSERT INTO santel_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","తదా తస్య సహదాసాస్తస్యైతాదృగ్ ఆచరణం విలోక్య ప్రభోః సమీపం గత్వా సర్వ్వం వృత్తాన్తం నివేదయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","తదా తస్య ప్రభుస్తమాహూయ జగాద, రే దుష్ట దాస, త్వయా మత్సన్నిధౌ ప్రార్థితే మయా తవ సర్వ్వమృణం త్యక్తం; ");
INSERT INTO santel_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","యథా చాహం త్వయి కరుణాం కృతవాన్, తథైవ త్వత్సహదాసే కరుణాకరణం కిం తవ నోచితం? ");
INSERT INTO santel_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ఇతి కథయిత్వా తస్య ప్రభుః క్రుద్ధ్యన్ నిజప్రాప్యం యావత్ స న పరిశోధితవాన్, తావత్ ప్రహారకానాం కరేషు తం సమర్పితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","యది యూయం స్వాన్తఃకరణైః స్వస్వసహజానామ్ అపరాధాన్ న క్షమధ్వే, తర్హి మమ స్వర్గస్యః పితాపి యుష్మాన్ ప్రతీత్థం కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","అనన్తరమ్ ఏతాసు కథాసు సమాప్తాసు యీశు ర్గాలీలప్రదేశాత్ ప్రస్థాయ యర్దన్తీరస్థం యిహూదాప్రదేశం ప్రాప్తః| ");
INSERT INTO santel_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","తదా తత్పశ్చాత్ జననివహే గతే స తత్ర తాన్ నిరామయాన్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","తదనన్తరం ఫిరూశినస్తత్సమీపమాగత్య పారీక్షితుం తం పప్రచ్ఛుః, కస్మాదపి కారణాత్ నరేణ స్వజాయా పరిత్యాజ్యా న వా? ");
INSERT INTO santel_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","స ప్రత్యువాచ, ప్రథమమ్ ఈశ్వరో నరత్వేన నారీత్వేన చ మనుజాన్ ససర్జ, తస్మాత్ కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","మానుషః స్వపితరౌ పరిత్యజ్య స్వపత్న్యామ్ ఆసక్ష్యతే, తౌ ద్వౌ జనావేకాఙ్గౌ భవిష్యతః, కిమేతద్ యుష్మాభి ర్న పఠితమ్? ");
INSERT INTO santel_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","అతస్తౌ పున ర్న ద్వౌ తయోరేకాఙ్గత్వం జాతం, ఈశ్వరేణ యచ్చ సమయుజ్యత, మనుజో న తద్ భిన్ద్యాత్| ");
INSERT INTO santel_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","తదానీం తే తం ప్రత్యవదన్, తథాత్వే త్యాజ్యపత్రం దత్త్వా స్వాం స్వాం జాయాం త్యక్తుం వ్యవస్థాం మూసాః కథం లిలేఖ? ");
INSERT INTO santel_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","తతః స కథితవాన్, యుష్మాకం మనసాం కాఠిన్యాద్ యుష్మాన్ స్వాం స్వాం జాయాం త్యక్తుమ్ అన్వమన్యత కిన్తు ప్రథమాద్ ఏషో విధిర్నాసీత్| ");
INSERT INTO santel_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","అతో యుష్మానహం వదామి, వ్యభిచారం వినా యో నిజజాయాం త్యజేత్ అన్యాఞ్చ వివహేత్, స పరదారాన్ గచ్ఛతి; యశ్చ త్యక్తాం నారీం వివహతి సోపి పరదారేషు రమతే| ");
INSERT INTO santel_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","తదా తస్య శిష్యాస్తం బభాషిరే, యది స్వజాయయా సాకం పుంస ఏతాదృక్ సమ్బన్ధో జాయతే, తర్హి వివహనమేవ న భద్రం| ");
INSERT INTO santel_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","తతః స ఉక్తవాన్, యేభ్యస్తత్సామర్థ్యం ఆదాయి, తాన్ వినాన్యః కోపి మనుజ ఏతన్మతం గ్రహీతుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","కతిపయా జననక్లీబః కతిపయా నరకృతక్లీబః స్వర్గరాజ్యాయ కతిపయాః స్వకృతక్లీబాశ్చ సన్తి, యే గ్రహీతుం శక్నువన్తి తే గృహ్లన్తు| ");
INSERT INTO santel_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","అపరమ్ యథా స శిశూనాం గాత్రేషు హస్తం దత్వా ప్రార్థయతే, తదర్థం తత్సమీంపం శిశవ ఆనీయన్త, తత ఆనయితృన్ శిష్యాస్తిరస్కృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","కిన్తు యీశురువాచ, శిశవో మదన్తికమ్ ఆగచ్ఛన్తు, తాన్ మా వారయత, ఏతాదృశాం శిశూనామేవ స్వర్గరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","తతః స తేషాం గాత్రేషు హస్తం దత్వా తస్మాత్ స్థానాత్ ప్రతస్థే| ");
INSERT INTO santel_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","అపరమ్ ఏక ఆగత్య తం పప్రచ్ఛ, హే పరమగురో, అనన్తాయుః ప్రాప్తుం మయా కిం కిం సత్కర్మ్మ కర్త్తవ్యం? ");
INSERT INTO santel_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","తతః స ఉవాచ, మాం పరమం కుతో వదసి? వినేశ్చరం న కోపి పరమః, కిన్తు యద్యనన్తాయుః ప్రాప్తుం వాఞ్ఛసి, తర్హ్యాజ్ఞాః పాలయ| ");
INSERT INTO santel_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","తదా స పృష్టవాన్, కాః కా ఆజ్ఞాః? తతో యీశుః కథితవాన్, నరం మా హన్యాః, పరదారాన్ మా గచ్ఛేః, మా చోరయేః, మృషాసాక్ష్యం మా దద్యాః, ");
INSERT INTO santel_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","నిజపితరౌ సంమన్యస్వ, స్వసమీపవాసిని స్వవత్ ప్రేమ కురు| ");
INSERT INTO santel_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","స యువా కథితవాన్, ఆ బాల్యాద్ ఏతాః పాలయామి, ఇదానీం కిం న్యూనమాస్తే? ");
INSERT INTO santel_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","తతో యీశురవదత్, యది సిద్ధో భవితుం వాఞ్ఛసి, తర్హి గత్వా నిజసర్వ్వస్వం విక్రీయ దరిద్రేభ్యో వితర, తతః స్వర్గే విత్తం లప్స్యసే; ఆగచ్ఛ, మత్పశ్చాద్వర్త్తీ చ భవ| ");
INSERT INTO santel_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ఏతాం వాచం శ్రుత్వా స యువా స్వీయబహుసమ్పత్తే ర్విషణః సన్ చలితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","తదా యీశుః స్వశిష్యాన్ అవదత్, ధనినాం స్వర్గరాజ్యప్రవేశో మహాదుష్కర ఇతి యుష్మానహం తథ్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","పునరపి యుష్మానహం వదామి, ధనినాం స్వర్గరాజ్యప్రవేశాత్ సూచీఛిద్రేణ మహాఙ్గగమనం సుకరం| ");
INSERT INTO santel_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ఇతి వాక్యం నిశమ్య శిష్యా అతిచమత్కృత్య కథయామాసుః; తర్హి కస్య పరిత్రాణం భవితుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","తదా స తాన్ దృష్ద్వా కథయామాస, తత్ మానుషాణామశక్యం భవతి, కిన్త్వీశ్వరస్య సర్వ్వం శక్యమ్| ");
INSERT INTO santel_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","తదా పితరస్తం గదితవాన్, పశ్య, వయం సర్వ్వం పరిత్యజ్య భవతః పశ్చాద్వర్త్తినో ఽభవామ; వయం కిం ప్రాప్స్యామః? ");
INSERT INTO santel_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","తతో యీశుః కథితవాన్, యుష్మానహం తథ్యం వదామి, యూయం మమ పశ్చాద్వర్త్తినో జాతా ఇతి కారణాత్ నవీనసృష్టికాలే యదా మనుజసుతః స్వీయైశ్చర్య్యసింహాసన ఉపవేక్ష్యతి, తదా యూయమపి ద్వాదశసింహాసనేషూపవిశ్య ఇస్రాయేలీయద్వాదశవంశానాం విచారం కరిష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","అన్యచ్చ యః కశ్చిత్ మమ నామకారణాత్ గృహం వా భ్రాతరం వా భగినీం వా పితరం వా మాతరం వా జాయాం వా బాలకం వా భూమిం పరిత్యజతి, స తేషాం శతగుణం లప్స్యతే, అనన్తాయుమోఽధికారిత్వఞ్చ ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","కిన్తు అగ్రీయా అనేకే జనాః పశ్చాత్, పశ్చాతీయాశ్చానేకే లోకా అగ్రే భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","స్వర్గరాజ్యమ్ ఏతాదృశా కేనచిద్ గృహస్యేన సమం, యోఽతిప్రభాతే నిజద్రాక్షాక్షేత్రే కృషకాన్ నియోక్తుం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","పశ్చాత్ తైః సాకం దినైకభృతిం ముద్రాచతుర్థాంశం నిరూప్య తాన్ ద్రాక్షాక్షేత్రం ప్రేరయామాస| ");
INSERT INTO santel_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","అనన్తరం ప్రహరైకవేలాయాం గత్వా హట్టే కతిపయాన్ నిష్కర్మ్మకాన్ విలోక్య తానవదత్, ");
INSERT INTO santel_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","యూయమపి మమ ద్రాక్షాక్షేత్రం యాత, యుష్మభ్యమహం యోగ్యభృతిం దాస్యామి, తతస్తే వవ్రజుః| ");
INSERT INTO santel_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","పునశ్చ స ద్వితీయతృతీయయోః ప్రహరయో ర్బహి ర్గత్వా తథైవ కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","తతో దణ్డద్వయావశిష్టాయాం వేలాయాం బహి ర్గత్వాపరాన్ కతిపయజనాన్ నిష్కర్మ్మకాన్ విలోక్య పృష్టవాన్, యూయం కిమర్థమ్ అత్ర సర్వ్వం దినం నిష్కర్మ్మాణస్తిష్ఠథ? ");
INSERT INTO santel_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","తే ప్రత్యవదన్, అస్మాన్ న కోపి కర్మమణి నియుంక్తే| తదానీం స కథితవాన్, యూయమపి మమ ద్రాక్షాక్షేత్రం యాత, తేన యోగ్యాం భృతిం లప్స్యథ| ");
INSERT INTO santel_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","తదనన్తరం సన్ధ్యాయాం సత్యాం సఏవ ద్రాక్షాక్షేత్రపతిరధ్యక్షం గదివాన్, కృషకాన్ ఆహూయ శేషజనమారభ్య ప్రథమం యావత్ తేభ్యో భృతిం దేహి| ");
INSERT INTO santel_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","తేన యే దణ్డద్వయావస్థితే సమాయాతాస్తేషామ్ ఏకైకో జనో ముద్రాచతుర్థాంశం ప్రాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","తదానీం ప్రథమనియుక్తా జనా ఆగత్యానుమితవన్తో వయమధికం ప్రప్స్యామః, కిన్తు తైరపి ముద్రాచతుర్థాంశోఽలాభి| ");
INSERT INTO santel_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","తతస్తే తం గృహీత్వా తేన క్షేత్రపతినా సాకం వాగ్యుద్ధం కుర్వ్వన్తః కథయామాసుః, ");
INSERT INTO santel_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","వయం కృత్స్నం దినం తాపక్లేశౌ సోఢవన్తః, కిన్తు పశ్చాతాయా సే జనా దణ్డద్వయమాత్రం పరిశ్రాన్తవన్తస్తేఽస్మాభిః సమానాంశాః కృతాః| ");
INSERT INTO santel_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","తతః స తేషామేకం ప్రత్యువాచ, హే వత్స, మయా త్వాం ప్రతి కోప్యన్యాయో న కృతః కిం త్వయా మత్సమక్షం ముద్రాచతుర్థాంశో నాఙ్గీకృతః? ");
INSERT INTO santel_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","తస్మాత్ తవ యత్ ప్రాప్యం తదాదాయ యాహి, తుభ్యం యతి, పశ్చాతీయనియుక్తలోకాయాపి తతి దాతుమిచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","స్వేచ్ఛయా నిజద్రవ్యవ్యవహరణం కిం మయా న కర్త్తవ్యం? మమ దాతృత్వాత్ త్వయా కిమ్ ఈర్ష్యాదృష్టిః క్రియతే? ");
INSERT INTO santel_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ఇత్థమ్ అగ్రీయలోకాః పశ్చతీయా భవిష్యన్తి, పశ్చాతీయజనాశ్చగ్రీయా భవిష్యన్తి, అహూతా బహవః కిన్త్వల్పే మనోభిలషితాః| ");
INSERT INTO santel_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","తదనన్తరం యీశు ర్యిరూశాలమ్నగరం గచ్ఛన్ మార్గమధ్యే శిష్యాన్ ఏకాన్తే వభాషే, ");
INSERT INTO santel_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","పశ్య వయం యిరూశాలమ్నగరం యామః, తత్ర ప్రధానయాజకాధ్యాపకానాం కరేషు మనుష్యపుత్రః సమర్పిష్యతే; ");
INSERT INTO santel_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","తే చ తం హన్తుమాజ్ఞాప్య తిరస్కృత్య వేత్రేణ ప్రహర్త్తుం క్రుశే ధాతయితుఞ్చాన్యదేశీయానాం కరేషు సమర్పయిష్యన్తి, కిన్తు స తృతీయదివసే శ్మశానాద్ ఉత్థాపిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","తదానీం సివదీయస్య నారీ స్వపుత్రావాదాయ యీశోః సమీపమ్ ఏత్య ప్రణమ్య కఞ్చనానుగ్రహం తం యయాచే| ");
INSERT INTO santel_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","తదా యీశుస్తాం ప్రోక్తవాన్, త్వం కిం యాచసే? తతః సా బభాషే, భవతో రాజత్వే మమానయోః సుతయోరేకం భవద్దక్షిణపార్శ్వే ద్వితీయం వామపార్శ్వ ఉపవేష్టుమ్ ఆజ్ఞాపయతు| ");
INSERT INTO santel_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","యీశుః ప్రత్యువాచ, యువాభ్యాం యద్ యాచ్యతే, తన్న బుధ్యతే, అహం యేన కంసేన పాస్యామి యువాభ్యాం కిం తేన పాతుం శక్యతే? అహఞ్చ యేన మజ్జేనేన మజ్జిష్యే, యువాభ్యాం కిం తేన మజ్జయితుం శక్యతే? తే జగదుః శక్యతే| ");
INSERT INTO santel_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","తదా స ఉక్తవాన్, యువాం మమ కంసేనావశ్యం పాస్యథః, మమ మజ్జనేన చ యువామపి మజ్జిష్యేథే, కిన్తు యేషాం కృతే మత్తాతేన నిరూపితమ్ ఇదం తాన్ విహాయాన్యం కమపి మద్దక్షిణపార్శ్వే వామపార్శ్వే చ సముపవేశయితుం మమాధికారో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ఏతాం కథాం శ్రుత్వాన్యే దశశిష్యాస్తౌ భ్రాతరౌ ప్రతి చుకుపుః| ");
INSERT INTO santel_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","కిన్తు యీశుః స్వసమీపం తానాహూయ జగాద, అన్యదేశీయలోకానాం నరపతయస్తాన్ అధికుర్వ్వన్తి, యే తు మహాన్తస్తే తాన్ శాసతి, ఇతి యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","కిన్తు యుష్మాకం మధ్యే న తథా భవేత్, యుష్మాకం యః కశ్చిత్ మహాన్ బుభూషతి, స యుష్మాన్ సేవేత; ");
INSERT INTO santel_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","యశ్చ యుష్మాకం మధ్యే ముఖ్యో బుభూషతి, స యుష్మాకం దాసో భవేత్| ");
INSERT INTO santel_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ఇత్థం మనుజపుత్రః సేవ్యో భవితుం నహి, కిన్తు సేవితుం బహూనాం పరిత్రాణమూల్యార్థం స్వప్రాణాన్ దాతుఞ్చాగతః| ");
INSERT INTO santel_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","అనన్తరం యిరీహోనగరాత్ తేషాం బహిర్గమనసమయే తస్య పశ్చాద్ బహవో లోకా వవ్రజుః| ");
INSERT INTO santel_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","అపరం వర్త్మపార్శ్వ ఉపవిశన్తౌ ద్వావన్ధౌ తేన మార్గేణ యీశో ర్గమనం నిశమ్య ప్రోచ్చైః కథయామాసతుః, హే ప్రభో దాయూదః సన్తాన, ఆవయో ర్దయాం విధేహి| ");
INSERT INTO santel_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","తతో లోకాః సర్వ్వే తుష్ణీమ్భవతమిత్యుక్త్వా తౌ తర్జయామాసుః; తథాపి తౌ పునరుచ్చైః కథయామాసతుః హే ప్రభో దాయూదః సన్తాన, ఆవాం దయస్వ| ");
INSERT INTO santel_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","తదానీం యీశుః స్థగితః సన్ తావాహూయ భాషితవాన్, యువయోః కృతే మయా కిం కర్త్తర్వ్యం? యువాం కిం కామయేథే? ");
INSERT INTO santel_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","తదా తావుక్తవన్తౌ, ప్రభో నేత్రాణి నౌ ప్రసన్నాని భవేయుః| ");
INSERT INTO santel_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","తదానీం యీశుస్తౌ ప్రతి ప్రమన్నః సన్ తయో ర్నేత్రాణి పస్పర్శ, తేనైవ తౌ సువీక్షాఞ్చక్రాతే తత్పశ్చాత్ జగ్ముతుశ్చ| ");
INSERT INTO santel_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","అనన్తరం తేషు యిరూశాలమ్నగరస్య సమీపవేర్త్తినో జైతుననామకధరాధరస్య సమీపస్థ్తిం బైత్ఫగిగ్రామమ్ ఆగతేషు, యీశుః శిష్యద్వయం ప్రేషయన్ జగాద, ");
INSERT INTO santel_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","యువాం సమ్ముఖస్థగ్రామం గత్వా బద్ధాం యాం సవత్సాం గర్ద్దభీం హఠాత్ ప్రాప్స్యథః, తాం మోచయిత్వా మదన్తికమ్ ఆనయతం| ");
INSERT INTO santel_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","తత్ర యది కశ్చిత్ కిఞ్చిద్ వక్ష్యతి, తర్హి వదిష్యథః, ఏతస్యాం ప్రభోః ప్రయోజనమాస్తే, తేన స తత్క్షణాత్ ప్రహేష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","సీయోనః కన్యకాం యూయం భాషధ్వమితి భారతీం| పశ్య తే నమ్రశీలః సన్ నృప ఆరుహ్య గర్దభీం| అర్థాదారుహ్య తద్వత్సమాయాస్యతి త్వదన్తికం| ");
INSERT INTO santel_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","భవిష్యద్వాదినోక్తం వచనమిదం తదా సఫలమభూత్| ");
INSERT INTO santel_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","అనన్తరం తౌ శ్ష్యిौ యీశో ర్యథానిదేశం తం గ్రామం గత్వా ");
INSERT INTO santel_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","గర్దభీం తద్వత్సఞ్చ సమానీతవన్తౌ, పశ్చాత్ తదుపరి స్వీయవసనానీ పాతయిత్వా తమారోహయామాసతుః| ");
INSERT INTO santel_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","తతో బహవో లోకా నిజవసనాని పథి ప్రసారయితుమారేభిరే, కతిపయా జనాశ్చ పాదపపర్ణాదికం ఛిత్వా పథి విస్తారయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","అగ్రగామినః పశ్చాద్గామినశ్చ మనుజా ఉచ్చైర్జయ జయ దాయూదః సన్తానేతి జగదుః పరమేశ్వరస్య నామ్నా య ఆయాతి స ధన్యః, సర్వ్వోపరిస్థస్వర్గేపి జయతి| ");
INSERT INTO santel_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ఇత్థం తస్మిన్ యిరూశాలమం ప్రవిష్టే కోఽయమితి కథనాత్ కృత్స్నం నగరం చఞ్చలమభవత్| ");
INSERT INTO santel_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","తత్ర లోకోః కథయామాసుః, ఏష గాలీల్ప్రదేశీయ-నాసరతీయ-భవిష్యద్వాదీ యీశుః| ");
INSERT INTO santel_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","అనన్తరం యీశురీశ్వరస్య మన్దిరం ప్రవిశ్య తన్మధ్యాత్ క్రయవిక్రయిణో వహిశ్చకార; వణిజాం ముద్రాసనానీ కపోతవిక్రయిణాఞ్చసనానీ చ న్యువ్జయామాస| ");
INSERT INTO santel_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","అపరం తానువాచ, ఏషా లిపిరాస్తే, \"మమ గృహం ప్రార్థనాగృహమితి విఖ్యాస్యతి\", కిన్తు యూయం తద్ దస్యూనాం గహ్వరం కృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","తదనన్తరమ్ అన్ధఖఞ్చలోకాస్తస్య సమీపమాగతాః, స తాన్ నిరామయాన్ కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","యదా ప్రధానయాజకా అధ్యాపకాశ్చ తేన కృతాన్యేతాని చిత్రకర్మ్మాణి దదృశుః, జయ జయ దాయూదః సన్తాన, మన్దిరే బాలకానామ్ ఏతాదృశమ్ ఉచ్చధ్వనిం శుశ్రువుశ్చ, తదా మహాక్రుద్ధా బభూవః, ");
INSERT INTO santel_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","తం పప్రచ్ఛుశ్చ, ఇమే యద్ వదన్తి, తత్ కిం త్వం శృణోషి? తతో యీశుస్తాన్ అవోచత్, సత్యమ్; స్తన్యపాయిశిశూనాఞ్చ బాలకానాఞ్చ వక్త్రతః| స్వకీయం మహిమానం త్వం సంప్రకాశయసి స్వయం| ఏతద్వాక్యం యూయం కిం నాపఠత? ");
INSERT INTO santel_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","తతస్తాన్ విహాయ స నగరాద్ బైథనియాగ్రామం గత్వా తత్ర రజనీం యాపయామాస| ");
INSERT INTO santel_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","అనన్తరం ప్రభాతే సతి యీశుః పునరపి నగరమాగచ్ఛన్ క్షుధార్త్తో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","తతో మార్గపార్శ్వ ఉడుమ్బరవృక్షమేకం విలోక్య తత్సమీపం గత్వా పత్రాణి వినా కిమపి న ప్రాప్య తం పాదపం ప్రోవాచ, అద్యారభ్య కదాపి త్వయి ఫలం న భవతు; తేన తత్క్షణాత్ స ఉడుమ్బరమాహీరుహః శుష్కతాం గతః| ");
INSERT INTO santel_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","తద్ దృష్ట్వా శిష్యా ఆశ్చర్య్యం విజ్ఞాయ కథయామాసుః, ఆః, ఉడుమ్వరపాదపోఽతితూర్ణం శుష్కోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","తతో యీశుస్తానువాచ, యుష్మానహం సత్యం వదామి, యది యూయమసన్దిగ్ధాః ప్రతీథ, తర్హి యూయమపి కేవలోడుమ్వరపాదపం ప్రతీత్థం కర్త్తుం శక్ష్యథ, తన్న, త్వం చలిత్వా సాగరే పతేతి వాక్యం యుష్మాభిరస్మిన శైలే ప్రోక్తేపి తదైవ తద్ ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","తథా విశ్వస్య ప్రార్థ్య యుష్మాభి ర్యద్ యాచిష్యతే, తదేవ ప్రాప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","అనన్తరం మన్దిరం ప్రవిశ్యోపదేశనసమయే తత్సమీపం ప్రధానయాజకాః ప్రాచీనలోకాశ్చాగత్య పప్రచ్ఛుః, త్వయా కేన సామర్థ్యనైతాని కర్మ్మాణి క్రియన్తే? కేన వా తుభ్యమేతాని సామర్థ్యాని దత్తాని? ");
INSERT INTO santel_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","తతో యీశుః ప్రత్యవదత్, అహమపి యుష్మాన్ వాచమేకాం పృచ్ఛామి, యది యూయం తదుత్తరం దాతుం శక్ష్యథ, తదా కేన సామర్థ్యేన కర్మ్మాణ్యేతాని కరోమి, తదహం యుష్మాన్ వక్ష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","యోహనో మజ్జనం కస్యాజ్ఞయాభవత్? కిమీశ్వరస్య మనుష్యస్య వా? తతస్తే పరస్పరం వివిచ్య కథయామాసుః, యదీశ్వరస్యేతి వదామస్తర్హి యూయం తం కుతో న ప్రత్యైత? వాచమేతాం వక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","మనుష్యస్యేతి వక్తుమపి లోకేభ్యో బిభీమః, యతః సర్వ్వైరపి యోహన్ భవిష్యద్వాదీతి జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","తస్మాత్ తే యీశుం ప్రత్యవదన్, తద్ వయం న విద్మః| తదా స తానుక్తవాన్, తర్హి కేన సామరథ్యేన కర్మ్మాణ్యేతాన్యహం కరోమి, తదప్యహం యుష్మాన్ న వక్ష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","కస్యచిజ్జనస్య ద్వౌ సుతావాస్తాం స ఏకస్య సుతస్య సమీపం గత్వా జగాద, హే సుత, త్వమద్య మమ ద్రాక్షాక్షేత్రే కర్మ్మ కర్తుం వ్రజ| ");
INSERT INTO santel_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","తతః స ఉక్తవాన్, న యాస్యామి, కిన్తు శేషేఽనుతప్య జగామ| ");
INSERT INTO santel_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","అనన్తరం సోన్యసుతస్య సమీపం గత్వా తథైవ కథ్తివాన్; తతః స ప్రత్యువాచ, మహేచ్ఛ యామి, కిన్తు న గతః| ");
INSERT INTO santel_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ఏతయోః పుత్రయో ర్మధ్యే పితురభిమతం కేన పాలితం? యుష్మాభిః కిం బుధ్యతే? తతస్తే ప్రత్యూచుః, ప్రథమేన పుुత్రేణ| తదానీం యీశుస్తానువాచ, అహం యుష్మాన్ తథ్యం వదామి, చణ్డాలా గణికాశ్చ యుష్మాకమగ్రత ఈశ్వరస్య రాజ్యం ప్రవిశన్తి| ");
INSERT INTO santel_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","యతో యుష్మాకం సమీపం యోహని ధర్మ్మపథేనాగతే యూయం తం న ప్రతీథ, కిన్తు చణ్డాలా గణికాశ్చ తం ప్రత్యాయన్, తద్ విలోక్యాపి యూయం ప్రత్యేతుం నాఖిద్యధ్వం| ");
INSERT INTO santel_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","అపరమేకం దృష్టాన్తం శృణుత, కశ్చిద్ గృహస్థః క్షేత్రే ద్రాక్షాలతా రోపయిత్వా తచ్చతుర్దిక్షు వారణీం విధాయ తన్మధ్యే ద్రాక్షాయన్త్రం స్థాపితవాన్, మాఞ్చఞ్చ నిర్మ్మితవాన్, తతః కృషకేషు తత్ క్షేత్రం సమర్ప్య స్వయం దూరదేశం జగామ| ");
INSERT INTO santel_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","తదనన్తరం ఫలసమయ ఉపస్థితే స ఫలాని ప్రాప్తుం కృషీవలానాం సమీపం నిజదాసాన్ ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","కిన్తు కృషీవలాస్తస్య తాన్ దాసేయాన్ ధృత్వా కఞ్చన ప్రహృతవన్తః, కఞ్చన పాషాణైరాహతవన్తః, కఞ్చన చ హతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","పునరపి స ప్రభుః ప్రథమతోఽధికదాసేయాన్ ప్రేషయామాస, కిన్తు తే తాన్ ప్రత్యపి తథైవ చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","అనన్తరం మమ సుతే గతే తం సమాదరిష్యన్తే, ఇత్యుక్త్వా శేషే స నిజసుతం తేషాం సన్నిధిం ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","కిన్తు తే కృషీవలాః సుతం వీక్ష్య పరస్పరమ్ ఇతి మన్త్రయితుమ్ ఆరేభిరే, అయముత్తరాధికారీ వయమేనం నిహత్యాస్యాధికారం స్వవశీకరిష్యామః| ");
INSERT INTO santel_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","పశ్చాత్ తే తం ధృత్వా ద్రాక్షాక్షేత్రాద్ బహిః పాతయిత్వాబధిషుః| ");
INSERT INTO santel_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","యదా స ద్రాక్షాక్షేత్రపతిరాగమిష్యతి, తదా తాన్ కృషీవలాన్ కిం కరిష్యతి? ");
INSERT INTO santel_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","తతస్తే ప్రత్యవదన్, తాన్ కలుషిణో దారుణయాతనాభిరాహనిష్యతి, యే చ సమయానుక్రమాత్ ఫలాని దాస్యన్తి, తాదృశేషు కృషీవలేషు క్షేత్రం సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","తదా యీశునా తే గదితాః, గ్రహణం న కృతం యస్య పాషాణస్య నిచాయకైః| ప్రధానప్రస్తరః కోణే సఏవ సంభవిష్యతి| ఏతత్ పరేశితుః కర్మ్మాస్మదృష్టావద్భుతం భవేత్| ధర్మ్మగ్రన్థే లిఖితమేతద్వచనం యుష్మాభిః కిం నాపాఠి? ");
INSERT INTO santel_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","తస్మాదహం యుష్మాన్ వదామి, యుష్మత్త ఈశ్వరీయరాజ్యమపనీయ ఫలోత్పాదయిత్రన్యజాతయే దాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","యో జన ఏతత్పాషాణోపరి పతిష్యతి, తం స భంక్ష్యతే, కిన్త్వయం పాషాణో యస్యోపరి పతిష్యతి, తం స ధూలివత్ చూర్ణీకరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","తదానీం ప్రాధనయాజకాః ఫిరూశినశ్చ తస్యేమాం దృష్టాన్తకథాం శ్రుత్వా సోఽస్మానుద్దిశ్య కథితవాన్, ఇతి విజ్ఞాయ తం ధర్త్తుం చేష్టితవన్తః; ");
INSERT INTO santel_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","కిన్తు లోకేభ్యో బిభ్యుః, యతో లోకైః స భవిష్యద్వాదీత్యజ్ఞాయి| ");
INSERT INTO santel_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","అనన్తరం యీశుః పునరపి దృష్టాన్తేన తాన్ అవాదీత్, ");
INSERT INTO santel_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","స్వర్గీయరాజ్యమ్ ఏతాదృశస్య నృపతేః సమం, యో నిజ పుత్రం వివాహయన్ సర్వ్వాన్ నిమన్త్రితాన్ ఆనేతుం దాసేయాన్ ప్రహితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","కిన్తు తే సమాగన్తుం నేష్టవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","తతో రాజా పునరపి దాసానన్యాన్ ఇత్యుక్త్వా ప్రేషయామాస, నిమన్త్రితాన్ వదత, పశ్యత, మమ భేజ్యమాసాదితమాస్తే, నిజవ్టషాదిపుష్టజన్తూన్ మారయిత్వా సర్వ్వం ఖాద్యద్రవ్యమాసాదితవాన్, యూయం వివాహమాగచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","తథపి తే తుచ్ఛీకృత్య కేచిత్ నిజక్షేత్రం కేచిద్ వాణిజ్యం ప్రతి స్వస్వమార్గేణ చలితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","అన్యే లోకాస్తస్య దాసేయాన్ ధృత్వా దౌరాత్మ్యం వ్యవహృత్య తానవధిషుః| ");
INSERT INTO santel_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","అనన్తరం స నృపతిస్తాం వార్త్తాం శ్రుత్వా క్రుధ్యన్ సైన్యాని ప్రహిత్య తాన్ ఘాతకాన్ హత్వా తేషాం నగరం దాహయామాస| ");
INSERT INTO santel_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","తతః స నిజదాసేయాన్ బభాషే, వివాహీయం భోజ్యమాసాదితమాస్తే, కిన్తు నిమన్త్రితా జనా అయోగ్యాః| ");
INSERT INTO santel_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","తస్మాద్ యూయం రాజమార్గం గత్వా యావతో మనుజాన్ పశ్యత, తావతఏవ వివాహీయభోజ్యాయ నిమన్త్రయత| ");
INSERT INTO santel_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","తదా తే దాసేయా రాజమార్గం గత్వా భద్రాన్ అభద్రాన్ వా యావతో జనాన్ దదృశుః, తావతఏవ సంగృహ్యానయన్; తతోఽభ్యాగతమనుజై ర్వివాహగృహమ్ అపూర్య్యత| ");
INSERT INTO santel_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","తదానీం స రాజా సర్వ్వానభ్యాగతాన్ ద్రష్టుమ్ అభ్యన్తరమాగతవాన్; తదా తత్ర వివాహీయవసనహీనమేకం జనం వీక్ష్య తం జగాద్, ");
INSERT INTO santel_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","హే మిత్ర,త్వం వివాహీయవసనం వినా కథమత్ర ప్రవిష్టవాన్? తేన స నిరుత్తరో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","తదా రాజా నిజానుచరాన్ అవదత్, ఏతస్య కరచరణాన్ బద్ధా యత్ర రోదనం దన్తైర్దన్తఘర్షణఞ్చ భవతి, తత్ర వహిర్భూతతమిస్రే తం నిక్షిపత| ");
INSERT INTO santel_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ఇత్థం బహవ ఆహూతా అల్పే మనోభిమతాః| ");
INSERT INTO santel_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","అనన్తరం ఫిరూశినః ప్రగత్య యథా సంలాపేన తమ్ ఉన్మాథే పాతయేయుస్తథా మన్త్రయిత్వా ");
INSERT INTO santel_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","హేరోదీయమనుజైః సాకం నిజశిష్యగణేన తం ప్రతి కథయామాసుః, హే గురో, భవాన్ సత్యః సత్యమీశ్వరీయమార్గముపదిశతి, కమపి మానుషం నానురుధ్యతే, కమపి నాపేక్షతే చ, తద్ వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","అతః కైసరభూపాయ కరోఽస్మాకం దాతవ్యో న వా? అత్ర భవతా కిం బుధ్యతే? తద్ అస్మాన్ వదతు| ");
INSERT INTO santel_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","తతో యీశుస్తేషాం ఖలతాం విజ్ఞాయ కథితవాన్, రే కపటినః యుయం కుతో మాం పరిక్షధ్వే? ");
INSERT INTO santel_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","తత్కరదానస్య ముద్రాం మాం దర్శయత| తదానీం తైస్తస్య సమీపం ముద్రాచతుర్థభాగ ఆనీతే ");
INSERT INTO santel_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","స తాన్ పప్రచ్ఛ, అత్ర కస్యేయం మూర్త్తి ర్నామ చాస్తే? తే జగదుః, కైసరభూపస్య| ");
INSERT INTO santel_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","తతః స ఉక్తవాన, కైసరస్య యత్ తత్ కైసరాయ దత్త, ఈశ్వరస్య యత్ తద్ ఈశ్వరాయ దత్త| ");
INSERT INTO santel_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ఇతి వాక్యం నిశమ్య తే విస్మయం విజ్ఞాయ తం విహాయ చలితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","తస్మిన్నహని సిదూకినోఽర్థాత్ శ్మశానాత్ నోత్థాస్యన్తీతి వాక్యం యే వదన్తి, తే యీశేाరన్తికమ్ ఆగత్య పప్రచ్ఛుః, ");
INSERT INTO santel_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","హే గురో, కశ్చిన్మనుజశ్చేత్ నిఃసన్తానః సన్ ప్రాణాన్ త్యజతి, తర్హి తస్య భ్రాతా తస్య జాయాం వ్యుహ్య భ్రాతుః సన్తానమ్ ఉత్పాదయిష్యతీతి మూసా ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","కిన్త్వస్మాకమత్ర కేఽపి జనాః సప్తసహోదరా ఆసన్, తేషాం జ్యేష్ఠ ఏకాం కన్యాం వ్యవహాత్, అపరం ప్రాణత్యాగకాలే స్వయం నిఃసన్తానః సన్ తాం స్త్రియం స్వభ్రాతరి సమర్పితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","తతో ద్వితీయాదిసప్తమాన్తాశ్చ తథైవ చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","శేషే సాపీ నారీ మమార| ");
INSERT INTO santel_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","మృతానామ్ ఉత్థానసమయే తేషాం సప్తానాం మధ్యే సా నారీ కస్య భార్య్యా భవిష్యతి? యస్మాత్ సర్వ్వఏవ తాం వ్యవహన్| ");
INSERT INTO santel_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","తతో యీశుః ప్రత్యవాదీత్, యూయం ధర్మ్మపుస్తకమ్ ఈశ్వరీయాం శక్తిఞ్చ న విజ్ఞాయ భ్రాన్తిమన్తః| ");
INSERT INTO santel_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ఉత్థానప్రాప్తా లోకా న వివహన్తి, న చ వాచా దీయన్తే, కిన్త్వీశ్వరస్య స్వర్గస్థదూతానాం సదృశా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","అపరం మృతానాముత్థానమధి యుష్మాన్ ప్రతీయమీశ్వరోక్తిః, ");
INSERT INTO santel_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"అహమిబ్రాహీమ ఈశ్వర ఇస్హాక ఈశ్వరో యాకూబ ఈశ్వర\" ఇతి కిం యుష్మాభి ర్నాపాఠి? కిన్త్వీశ్వరో జీవతామ్ ఈశ్వర:, స మృతానామీశ్వరో నహి| ");
INSERT INTO santel_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ఇతి శ్రుత్వా సర్వ్వే లోకాస్తస్యోపదేశాద్ విస్మయం గతాః| ");
INSERT INTO santel_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","అనన్తరం సిదూకినామ్ నిరుత్తరత్వవార్తాం నిశమ్య ఫిరూశిన ఏకత్ర మిలితవన్తః, ");
INSERT INTO santel_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","తేషామేకో వ్యవస్థాపకో యీశుం పరీక్షితుం పపచ్ఛ, ");
INSERT INTO santel_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","హే గురో వ్యవస్థాశాస్త్రమధ్యే కాజ్ఞా శ్రేష్ఠా? ");
INSERT INTO santel_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","తతో యీశురువాచ, త్వం సర్వ్వాన్తఃకరణైః సర్వ్వప్రాణైః సర్వ్వచిత్తైశ్చ సాకం ప్రభౌ పరమేశ్వరే ప్రీయస్వ, ");
INSERT INTO santel_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ఏషా ప్రథమమహాజ్ఞా| తస్యాః సదృశీ ద్వితీయాజ్ఞైషా, ");
INSERT INTO santel_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","తవ సమీపవాసిని స్వాత్మనీవ ప్రేమ కురు| ");
INSERT INTO santel_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","అనయో ర్ద్వయోరాజ్ఞయోః కృత్స్నవ్యవస్థాయా భవిష్యద్వక్తృగ్రన్థస్య చ భారస్తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","అనన్తరం ఫిరూశినామ్ ఏకత్ర స్థితికాలే యీశుస్తాన్ పప్రచ్ఛ, ");
INSERT INTO santel_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ఖ్రీష్టమధి యుష్మాకం కీదృగ్బోధో జాయతే? స కస్య సన్తానః? తతస్తే ప్రత్యవదన్, దాయూదః సన్తానః| ");
INSERT INTO santel_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","తదా స ఉక్తవాన్, తర్హి దాయూద్ కథమ్ ఆత్మాధిష్ఠానేన తం ప్రభుం వదతి ? ");
INSERT INTO santel_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","యథా మమ ప్రభుమిదం వాక్యమవదత్ పరమేశ్వరః| తవారీన్ పాదపీఠం తే యావన్నహి కరోమ్యహం| తావత్ కాలం మదీయే త్వం దక్షపార్శ్వ ఉపావిశ| అతో యది దాయూద్ తం ప్రభుం వదతి, ర్తిహ స కథం తస్య సన్తానో భవతి? ");
INSERT INTO santel_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","తదానీం తేషాం కోపి తద్వాక్యస్య కిమప్యుత్తరం దాతుం నాశక్నోత్; ");
INSERT INTO santel_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","తద్దినమారభ్య తం కిమపి వాక్యం ప్రష్టుం కస్యాపి సాహసో నాభవత్| ");
INSERT INTO santel_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","అనన్తరం యీశు ర్జననివహం శిష్యాంశ్చావదత్, ");
INSERT INTO santel_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","అధ్యాపకాః ఫిరూశినశ్చ మూసాసనే ఉపవిశన్తి, ");
INSERT INTO santel_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","అతస్తే యుష్మాన్ యద్యత్ మన్తుమ్ ఆజ్ఞాపయన్తి, తత్ మన్యధ్వం పాలయధ్వఞ్చ, కిన్తు తేషాం కర్మ్మానురూపం కర్మ్మ న కురుధ్వం; యతస్తేషాం వాక్యమాత్రం సారం కార్య్యే కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","తే దుర్వ్వహాన్ గురుతరాన్ భారాన్ బద్వ్వా మనుష్యాణాం స్కన్ధేపరి సమర్పయన్తి, కిన్తు స్వయమఙ్గుల్యైకయాపి న చాలయన్తి| ");
INSERT INTO santel_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","కేవలం లోకదర్శనాయ సర్వ్వకర్మ్మాణి కుర్వ్వన్తి; ఫలతః పట్టబన్ధాన్ ప్రసార్య్య ధారయన్తి, స్వవస్త్రేషు చ దీర్ఘగ్రన్థీన్ ధారయన్తి; ");
INSERT INTO santel_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","భోజనభవన ఉచ్చస్థానం, భజనభవనే ప్రధానమాసనం, ");
INSERT INTO santel_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","హట్ఠే నమస్కారం గురురితి సమ్బోధనఞ్చైతాని సర్వ్వాణి వాఞ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","కిన్తు యూయం గురవ ఇతి సమ్బోధనీయా మా భవత, యతో యుష్మాకమ్ ఏకః ఖ్రీష్టఏవ గురు ");
INSERT INTO santel_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ర్యూయం సర్వ్వే మిథో భ్రాతరశ్చ| పునః పృథివ్యాం కమపి పితేతి మా సమ్బుధ్యధ్వం, యతో యుష్మాకమేకః స్వర్గస్థఏవ పితా| ");
INSERT INTO santel_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","యూయం నాయకేతి సమ్భాషితా మా భవత, యతో యుష్మాకమేకః ఖ్రీష్టఏవ నాయకః| ");
INSERT INTO santel_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","అపరం యుష్మాకం మధ్యే యః పుమాన్ శ్రేష్ఠః స యుష్మాన్ సేవిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","యతో యః స్వమున్నమతి, స నతః కరిష్యతే; కిన్తు యః కశ్చిత్ స్వమవనతం కరోతి, స ఉన్నతః కరిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","హన్త కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయం మనుజానాం సమక్షం స్వర్గద్వారం రున్ధ, యూయం స్వయం తేన న ప్రవిశథ, ప్రవివిక్షూనపి వారయథ| వత కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ యూయం ఛలాద్ దీర్ఘం ప్రార్థ్య విధవానాం సర్వ్వస్వం గ్రసథ, యుష్మాకం ఘోరతరదణ్డో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","హన్త కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయమేకం స్వధర్మ్మావలమ్బినం కర్త్తుం సాగరం భూమణ్డలఞ్చ ప్రదక్షిణీకురుథ, ");
INSERT INTO santel_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","కఞ్చన ప్రాప్య స్వతో ద్విగుణనరకభాజనం తం కురుథ| ");
INSERT INTO santel_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","వత అన్ధపథదర్శకాః సర్వ్వే, యూయం వదథ, మన్దిరస్య శపథకరణాత్ కిమపి న దేయం; కిన్తు మన్దిరస్థసువర్ణస్య శపథకరణాద్ దేయం| ");
INSERT INTO santel_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","హే మూఢా హే అన్ధాః సువర్ణం తత్సువర్ణపావకమన్దిరమ్ ఏతయోరుభయో ర్మధ్యే కిం శ్రేయః? ");
INSERT INTO santel_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","అన్యచ్చ వదథ, యజ్ఞవేద్యాః శపథకరణాత్ కిమపి న దేయం, కిన్తు తదుపరిస్థితస్య నైవేద్యస్య శపథకరణాద్ దేయం| ");
INSERT INTO santel_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","హే మూఢా హే అన్ధాః, నైవేద్యం తన్నైవేద్యపావకవేదిరేతయోరుభయో ర్మధ్యే కిం శ్రేయః? ");
INSERT INTO santel_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","అతః కేనచిద్ యజ్ఞవేద్యాః శపథే కృతే తదుపరిస్థస్య సర్వ్వస్య శపథః క్రియతే| ");
INSERT INTO santel_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","కేనచిత్ మన్దిరస్య శపథే కృతే మన్దిరతన్నివాసినోః శపథః క్రియతే| ");
INSERT INTO santel_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","కేనచిత్ స్వర్గస్య శపథే కృతే ఈశ్వరీయసింహాసనతదుపర్య్యుపవిష్టయోః శపథః క్రియతే| ");
INSERT INTO santel_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","హన్త కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయం పోదినాయాః సితచ్ఛత్రాయా జీరకస్య చ దశమాంశాన్ దత్థ, కిన్తు వ్యవస్థాయా గురుతరాన్ న్యాయదయావిశ్వాసాన్ పరిత్యజథ; ఇమే యుష్మాభిరాచరణీయా అమీ చ న లంఘనీయాః| ");
INSERT INTO santel_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","హే అన్ధపథదర్శకా యూయం మశకాన్ అపసారయథ, కిన్తు మహాఙ్గాన్ గ్రసథ| ");
INSERT INTO santel_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","హన్త కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయం పానపాత్రాణాం భోజనపాత్రాణాఞ్చ బహిః పరిష్కురుథ; కిన్తు తదభ్యన్తరం దురాత్మతయా కలుషేణ చ పరిపూర్ణమాస్తే| ");
INSERT INTO santel_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","హే అన్ధాః ఫిరూశిలోకా ఆదౌ పానపాత్రాణాం భోజనపాత్రాణాఞ్చాభ్యన్తరం పరిష్కురుత, తేన తేషాం బహిరపి పరిష్కారిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","హన్త కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయం శుక్లీకృతశ్మశానస్వరూపా భవథ, యథా శ్మశానభవనస్య బహిశ్చారు, కిన్త్వభ్యన్తరం మృతలోకానాం కీకశైః సర్వ్వప్రకారమలేన చ పరిపూర్ణమ్; ");
INSERT INTO santel_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","తథైవ యూయమపి లోకానాం సమక్షం బహిర్ధార్మ్మికాః కిన్త్వన్తఃకరణేషు కేవలకాపట్యాధర్మ్మాభ్యాం పరిపూర్ణాః| ");
INSERT INTO santel_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","హా హా కపటిన ఉపాధ్యాయాః ఫిరూశినశ్చ, యూయం భవిష్యద్వాదినాం శ్మశానగేహం నిర్మ్మాథ, సాధూనాం శ్మశాననికేతనం శోభయథ ");
INSERT INTO santel_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","వదథ చ యది వయం స్వేషాం పూర్వ్వపురుషాణాం కాల అస్థాస్యామ, తర్హి భవిష్యద్వాదినాం శోణితపాతనే తేషాం సహభాగినో నాభవిష్యామ| ");
INSERT INTO santel_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","అతో యూయం భవిష్యద్వాదిఘాతకానాం సన్తానా ఇతి స్వయమేవ స్వేషాం సాక్ష్యం దత్థ| ");
INSERT INTO santel_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","అతో యూయం నిజపూర్వ్వపురుషాణాం పరిమాణపాత్రం పరిపూరయత| ");
INSERT INTO santel_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","రే భుజగాః కృష్ణభుజగవంశాః, యూయం కథం నరకదణ్డాద్ రక్షిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","పశ్యత, యుష్మాకమన్తికమ్ అహం భవిష్యద్వాదినో బుద్ధిమత ఉపాధ్యాయాంశ్చ ప్రేషయిష్యామి, కిన్తు తేషాం కతిపయా యుష్మాభి ర్ఘానిష్యన్తే, క్రుశే చ ఘానిష్యన్తే, కేచిద్ భజనభవనే కషాభిరాఘానిష్యన్తే, నగరే నగరే తాడిష్యన్తే చ; ");
INSERT INTO santel_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","తేన సత్పురుషస్య హాబిలో రక్తపాతమారభ్య బేరిఖియః పుత్రం యం సిఖరియం యూయం మన్దిరయజ్ఞవేద్యో ర్మధ్యే హతవన్తః, తదీయశోణితపాతం యావద్ అస్మిన్ దేశే యావతాం సాధుపురుషాణాం శోణితపాతో ఽభవత్ తత్ సర్వ్వేషామాగసాం దణ్డా యుష్మాసు వర్త్తిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","అహం యుష్మాన్త తథ్యం వదామి, విద్యమానేఽస్మిన్ పురుషే సర్వ్వే వర్త్తిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","హే యిరూశాలమ్ హే యిరూశాలమ్ నగరి త్వం భవిష్యద్వాదినో హతవతీ, తవ సమీపం ప్రేరితాంశ్చ పాషాణైరాహతవతీ, యథా కుక్కుటీ శావకాన్ పక్షాధః సంగృహ్లాతి, తథా తవ సన్తానాన్ సంగ్రహీతుం అహం బహువారమ్ ఐచ్ఛం; కిన్తు త్వం న సమమన్యథాః| ");
INSERT INTO santel_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","పశ్యత యష్మాకం వాసస్థానమ్ ఉచ్ఛిన్నం త్యక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","అహం యుష్మాన్ తథ్యం వదామి, యః పరమేశ్వరస్య నామ్నాగచ్ఛతి, స ధన్య ఇతి వాణీం యావన్న వదిష్యథ, తావత్ మాం పున ర్న ద్రక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","అనన్తరం యీశు ర్యదా మన్దిరాద్ బహి ర్గచ్ఛతి, తదానీం శిష్యాస్తం మన్దిరనిర్మ్మాణం దర్శయితుమాగతాః| ");
INSERT INTO santel_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","తతో యీశుస్తానువాచ, యూయం కిమేతాని న పశ్యథ? యుష్మానహం సత్యం వదామి, ఏతన్నిచయనస్య పాషాణైకమప్యన్యపాషాణేाపరి న స్థాస్యతి సర్వ్వాణి భూమిసాత్ కారిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","అనన్తరం తస్మిన్ జైతునపర్వ్వతోపరి సముపవిష్టే శిష్యాస్తస్య సమీపమాగత్య గుప్తం పప్రచ్ఛుః, ఏతా ఘటనాః కదా భవిష్యన్తి? భవత ఆగమనస్య యుగాన్తస్య చ కిం లక్ష్మ? తదస్మాన్ వదతు| ");
INSERT INTO santel_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","తదానీం యీశుస్తానవోచత్, అవధద్వ్వం, కోపి యుష్మాన్ న భ్రమయేత్| ");
INSERT INTO santel_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","బహవో మమ నామ గృహ్లన్త ఆగమిష్యన్తి, ఖ్రీష్టోఽహమేవేతి వాచం వదన్తో బహూన్ భ్రమయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","యూయఞ్చ సంగ్రామస్య రణస్య చాడమ్బరం శ్రోష్యథ, అవధద్వ్వం తేన చఞ్చలా మా భవత, ఏతాన్యవశ్యం ఘటిష్యన్తే, కిన్తు తదా యుగాన్తో నహి| ");
INSERT INTO santel_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","అపరం దేశస్య విపక్షో దేశో రాజ్యస్య విపక్షో రాజ్యం భవిష్యతి, స్థానే స్థానే చ దుర్భిక్షం మహామారీ భూకమ్పశ్చ భవిష్యన్తి, ");
INSERT INTO santel_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ఏతాని దుఃఖోపక్రమాః| ");
INSERT INTO santel_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","తదానీం లోకా దుఃఖం భోజయితుం యుష్మాన్ పరకరేషు సమర్పయిష్యన్తి హనిష్యన్తి చ, తథా మమ నామకారణాద్ యూయం సర్వ్వదేశీయమనుజానాం సమీపే ఘృణార్హా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","బహుషు విఘ్నం ప్రాప్తవత్సు పరస్పరమ్ ఋृతీయాం కృతవత్సు చ ఏకోఽపరం పరకరేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","తథా బహవో మృషాభవిష్యద్వాదిన ఉపస్థాయ బహూన్ భ్రమయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","దుష్కర్మ్మణాం బాహుల్యాఞ్చ బహూనాం ప్రేమ శీతలం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","కిన్తు యః కశ్చిత్ శేషం యావద్ ధైర్య్యమాశ్రయతే, సఏవ పరిత్రాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","అపరం సర్వ్వదేశీయలోకాన్ ప్రతిమాక్షీ భవితుం రాజస్య శుభసమాచారః సర్వ్వజగతి ప్రచారిష్యతే, ఏతాదృశి సతి యుగాన్త ఉపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","అతో యత్ సర్వ్వనాశకృద్ఘృణార్హం వస్తు దానియేల్భవిష్యద్వదినా ప్రోక్తం తద్ యదా పుణ్యస్థానే స్థాపితం ద్రక్ష్యథ, (యః పఠతి, స బుధ్యతాం) ");
INSERT INTO santel_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","తదానీం యే యిహూదీయదేశే తిష్ఠన్తి, తే పర్వ్వతేషు పలాయన్తాం| ");
INSERT INTO santel_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","యః కశ్చిద్ గృహపృష్ఠే తిష్ఠతి, స గృహాత్ కిమపి వస్త్వానేతుమ్ అధేा నావరోహేత్| ");
INSERT INTO santel_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","యశ్చ క్షేత్రే తిష్ఠతి, సోపి వస్త్రమానేతుం పరావృత్య న యాయాత్| ");
INSERT INTO santel_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","తదానీం గర్భిణీస్తన్యపాయయిత్రీణాం దుర్గతి ర్భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","అతో యష్మాకం పలాయనం శీతకాలే విశ్రామవారే వా యన్న భవేత్, తదర్థం ప్రార్థయధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ఆ జగదారమ్భాద్ ఏతత్కాలపర్య్యనన్తం యాదృశః కదాపి నాభవత్ న చ భవిష్యతి తాదృశో మహాక్లేశస్తదానీమ్ ఉపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","తస్య క్లేశస్య సమయో యది హ్స్వో న క్రియేత, తర్హి కస్యాపి ప్రాణినో రక్షణం భవితుం న శక్నుయాత్, కిన్తు మనోనీతమనుజానాం కృతే స కాలో హ్స్వీకరిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","అపరఞ్చ పశ్యత, ఖ్రీష్టోఽత్ర విద్యతే, వా తత్ర విద్యతే, తదానీం యదీ కశ్చిద్ యుష్మాన ఇతి వాక్యం వదతి, తథాపి తత్ న ప్రతీత్| ");
INSERT INTO santel_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","యతో భాక్తఖ్రీష్టా భాక్తభవిష్యద్వాదినశ్చ ఉపస్థాయ యాని మహన్తి లక్ష్మాణి చిత్రకర్మ్మాణి చ ప్రకాశయిష్యన్తి, తై ర్యది సమ్భవేత్ తర్హి మనోనీతమానవా అపి భ్రామిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","పశ్యత, ఘటనాతః పూర్వ్వం యుష్మాన్ వార్త్తామ్ అవాదిషమ్| ");
INSERT INTO santel_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","అతః పశ్యత, స ప్రాన్తరే విద్యత ఇతి వాక్యే కేనచిత్ కథితేపి బహి ర్మా గచ్ఛత, వా పశ్యత, సోన్తఃపురే విద్యతే, ఏతద్వాక్య ఉక్తేపి మా ప్రతీత| ");
INSERT INTO santel_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","యతో యథా విద్యుత్ పూర్వ్వదిశో నిర్గత్య పశ్చిమదిశం యావత్ ప్రకాశతే, తథా మానుషపుత్రస్యాప్యాగమనం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","యత్ర శవస్తిష్ఠతి, తత్రేవ గృధ్రా మిలన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","అపరం తస్య క్లేశసమయస్యావ్యవహితపరత్ర సూర్య్యస్య తేజో లోప్స్యతే, చన్ద్రమా జ్యోస్నాం న కరిష్యతి, నభసో నక్షత్రాణి పతిష్యన్తి, గగణీయా గ్రహాశ్చ విచలిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","తదానీమ్ ఆకాశమధ్యే మనుజసుతస్య లక్ష్మ దర్శిష్యతే, తతో నిజపరాక్రమేణ మహాతేజసా చ మేఘారూఢం మనుజసుతం నభసాగచ్ఛన్తం విలోక్య పృథివ్యాః సర్వ్వవంశీయా విలపిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","తదానీం స మహాశబ్దాయమానతూర్య్యా వాదకాన్ నిజదూతాన్ ప్రహేష్యతి, తే వ్యోమ్న ఏకసీమాతోఽపరసీమాం యావత్ చతుర్దిశస్తస్య మనోనీతజనాన్ ఆనీయ మేలయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ఉడుమ్బరపాదపస్య దృష్టాన్తం శిక్షధ్వం; యదా తస్య నవీనాః శాఖా జాయన్తే, పల్లవాదిశ్చ నిర్గచ్ఛతి, తదా నిదాఘకాలః సవిధో భవతీతి యూయం జానీథ; ");
INSERT INTO santel_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","తద్వద్ ఏతా ఘటనా దృష్ట్వా స సమయో ద్వార ఉపాస్థాద్ ఇతి జానీత| ");
INSERT INTO santel_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","యుష్మానహం తథ్యం వదామి, ఇదానీన్తనజనానాం గమనాత్ పూర్వ్వమేవ తాని సర్వ్వాణి ఘటిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","నభోమేదిన్యో ర్లుప్తయోరపి మమ వాక్ కదాపి న లోప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","అపరం మమ తాతం వినా మానుషః స్వర్గస్థో దూతో వా కోపి తద్దినం తద్దణ్డఞ్చ న జ్ఞాపయతి| ");
INSERT INTO santel_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","అపరం నోహే విద్యమానే యాదృశమభవత్ తాదృశం మనుజసుతస్యాగమనకాలేపి భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ఫలతో జలాప్లావనాత్ పూర్వ్వం యద్దినం యావత్ నోహః పోతం నారోహత్, తావత్కాలం యథా మనుష్యా భోజనే పానే వివహనే వివాహనే చ ప్రవృత్తా ఆసన్; ");
INSERT INTO santel_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","అపరమ్ ఆప్లావితోయమాగత్య యావత్ సకలమనుజాన్ ప్లావయిత్వా నానయత్, తావత్ తే యథా న విదామాసుః, తథా మనుజసుతాగమనేపి భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","తదా క్షేత్రస్థితయోర్ద్వయోరేకో ధారిష్యతే, అపరస్త్యాజిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","తథా పేషణ్యా పింషత్యోరుభయో ర్యోషితోరేకా ధారిష్యతేఽపరా త్యాజిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","యుష్మాకం ప్రభుః కస్మిన్ దణ్డ ఆగమిష్యతి, తద్ యుష్మాభి ర్నావగమ్యతే, తస్మాత్ జాగ్రతః సన్తస్తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","కుత్ర యామే స్తేన ఆగమిష్యతీతి చేద్ గృహస్థో జ్ఞాతుమ్ అశక్ష్యత్, తర్హి జాగరిత్వా తం సన్ధిం కర్త్తితుమ్ అవారయిష్యత్ తద్ జానీత| ");
INSERT INTO santel_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","యుష్మాభిరవధీయతాం, యతో యుష్మాభి ర్యత్ర న బుధ్యతే, తత్రైవ దణ్డే మనుజసుత ఆయాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ప్రభు ర్నిజపరివారాన్ యథాకాలం భోజయితుం యం దాసమ్ అధ్యక్షీకృత్య స్థాపయతి, తాదృశో విశ్వాస్యో ధీమాన్ దాసః కః? ");
INSERT INTO santel_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ప్రభురాగత్య యం దాసం తథాచరన్తం వీక్షతే, సఏవ ధన్యః| ");
INSERT INTO santel_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","యుష్మానహం సత్యం వదామి, స తం నిజసర్వ్వస్వస్యాధిపం కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","కిన్తు ప్రభురాగన్తుం విలమ్బత ఇతి మనసి చిన్తయిత్వా యో దుష్టో దాసో ");
INSERT INTO santel_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ఽపరదాసాన్ ప్రహర్త్తుం మత్తానాం సఙ్గే భోక్తుం పాతుఞ్చ ప్రవర్త్తతే, ");
INSERT INTO santel_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","స దాసో యదా నాపేక్షతే, యఞ్చ దణ్డం న జానాతి, తత్కాలఏవ తత్ప్రభురుపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","తదా తం దణ్డయిత్వా యత్ర స్థానే రోదనం దన్తఘర్షణఞ్చాసాతే, తత్ర కపటిభిః సాకం తద్దశాం నిరూపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","యా దశ కన్యాః ప్రదీపాన్ గృహ్లత్యో వరం సాక్షాత్ కర్త్తుం బహిరితాః, తాభిస్తదా స్వర్గీయరాజ్యస్య సాదృశ్యం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","తాసాం కన్యానాం మధ్యే పఞ్చ సుధియః పఞ్చ దుర్ధియ ఆసన్| ");
INSERT INTO santel_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","యా దుర్ధియస్తాః ప్రదీపాన్ సఙ్గే గృహీత్వా తైలం న జగృహుః, ");
INSERT INTO santel_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","కిన్తు సుధియః ప్రదీపాన్ పాత్రేణ తైలఞ్చ జగృహుః| ");
INSERT INTO santel_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","అనన్తరం వరే విలమ్బితే తాః సర్వ్వా నిద్రావిష్టా నిద్రాం జగ్ముః| ");
INSERT INTO santel_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","అనన్తరమ్ అర్ద్ధరాత్రే పశ్యత వర ఆగచ్ఛతి, తం సాక్షాత్ కర్త్తుం బహిర్యాతేతి జనరవాత్ ");
INSERT INTO santel_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","తాః సర్వ్వాః కన్యా ఉత్థాయ ప్రదీపాన్ ఆసాదయితుం ఆరభన్త| ");
INSERT INTO santel_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","తతో దుర్ధియః సుధియ ఊచుః, కిఞ్చిత్ తైలం దత్త, ప్రదీపా అస్మాకం నిర్వ్వాణాః| ");
INSERT INTO santel_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","కిన్తు సుధియః ప్రత్యవదన్, దత్తే యుష్మానస్మాంశ్చ ప్రతి తైలం న్యూనీభవేత్, తస్మాద్ విక్రేతృణాం సమీపం గత్వా స్వార్థం తైలం క్రీణీత| ");
INSERT INTO santel_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","తదా తాసు క్రేతుం గతాసు వర ఆజగామ, తతో యాః సజ్జితా ఆసన్, తాస్తేన సాకం వివాహీయం వేశ్మ ప్రవివిశుః| ");
INSERT INTO santel_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","అనన్తరం ద్వారే రుద్ధే అపరాః కన్యా ఆగత్య జగదుః, హే ప్రభో, హే ప్రభో, అస్మాన్ ప్రతి ద్వారం మోచయ| ");
INSERT INTO santel_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","కిన్తు స ఉక్తవాన్, తథ్యం వదామి, యుష్మానహం న వేద్మి| ");
INSERT INTO santel_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","అతో జాగ్రతః సన్తస్తిష్ఠత, మనుజసుతః కస్మిన్ దినే కస్మిన్ దణ్డే వాగమిష్యతి, తద్ యుష్మాభి ర్న జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","అపరం స ఏతాదృశః కస్యచిత్ పుంసస్తుల్యః, యో దూరదేశం ప్రతి యాత్రాకాలే నిజదాసాన్ ఆహూయ తేషాం స్వస్వసామర్థ్యానురూపమ్ ");
INSERT INTO santel_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ఏకస్మిన్ ముద్రాణాం పఞ్చ పోటలికాః అన్యస్మింశ్చ ద్వే పోటలికే అపరస్మింశ్చ పోటలికైకామ్ ఇత్థం ప్రతిజనం సమర్ప్య స్వయం ప్రవాసం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","అనన్తరం యో దాసః పఞ్చ పోటలికాః లబ్ధవాన్, స గత్వా వాణిజ్యం విధాయ తా ద్విగుణీచకార| ");
INSERT INTO santel_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","యశ్చ దాసో ద్వే పోటలికే అలభత, సోపి తా ముద్రా ద్విగుణీచకార| ");
INSERT INTO santel_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","కిన్తు యో దాస ఏకాం పోటలికాం లబ్ధవాన్, స గత్వా భూమిం ఖనిత్వా తన్మధ్యే నిజప్రభోస్తా ముద్రా గోపయాఞ్చకార| ");
INSERT INTO santel_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","తదనన్తరం బహుతిథే కాలే గతే తేషాం దాసానాం ప్రభురాగత్య తైర్దాసైః సమం గణయాఞ్చకార| ");
INSERT INTO santel_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","తదానీం యః పఞ్చ పోటలికాః ప్రాప్తవాన్ స తా ద్విగుణీకృతముద్రా ఆనీయ జగాద; హే ప్రభో, భవతా మయి పఞ్చ పోటలికాః సమర్పితాః, పశ్యతు, తా మయా ద్విగుణీకృతాః| ");
INSERT INTO santel_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","తదానీం తస్య ప్రభుస్తమువాచ, హే ఉత్తమ విశ్వాస్య దాస, త్వం ధన్యోసి, స్తోకేన విశ్వాస్యో జాతః, తస్మాత్ త్వాం బహువిత్తాధిపం కరోమి, త్వం స్వప్రభోః సుఖస్య భాగీ భవ| ");
INSERT INTO santel_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","తతో యేన ద్వే పోటలికే లబ్ధే సోప్యాగత్య జగాద, హే ప్రభో, భవతా మయి ద్వే పోటలికే సమర్పితే, పశ్యతు తే మయా ద్విగుణీకృతే| ");
INSERT INTO santel_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","తేన తస్య ప్రభుస్తమవోచత్, హే ఉత్తమ విశ్వాస్య దాస, త్వం ధన్యోసి, స్తోకేన విశ్వాస్యో జాతః, తస్మాత్ త్వాం బహుద్రవిణాధిపం కరోమి, త్వం నిజప్రభోః సుఖస్య భాగీ భవ| ");
INSERT INTO santel_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","అనన్తరం య ఏకాం పోటలికాం లబ్ధవాన్, స ఏత్య కథితవాన్, హే ప్రభో, త్వాం కఠిననరం జ్ఞాతవాన్, త్వయా యత్ర నోప్తం, తత్రైవ కృత్యతే, యత్ర చ న కీర్ణం, తత్రైవ సంగృహ్యతే| ");
INSERT INTO santel_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","అతోహం సశఙ్కః సన్ గత్వా తవ ముద్రా భూమధ్యే సంగోప్య స్థాపితవాన్, పశ్య, తవ యత్ తదేవ గృహాణ| ");
INSERT INTO santel_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","తదా తస్య ప్రభుః ప్రత్యవదత్ రే దుష్టాలస దాస, యత్రాహం న వపామి, తత్ర ఛినద్మి, యత్ర చ న కిరామి, తత్రేవ సంగృహ్లామీతి చేదజానాస్తర్హి ");
INSERT INTO santel_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","వణిక్షు మమ విత్తార్పణం తవోచితమాసీత్, యేనాహమాగత్య వృద్వ్యా సాకం మూలముద్రాః ప్రాప్స్యమ్| ");
INSERT INTO santel_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","అతోస్మాత్ తాం పోటలికామ్ ఆదాయ యస్య దశ పోటలికాః సన్తి తస్మిన్నర్పయత| ");
INSERT INTO santel_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","యేన వర్ద్వ్యతే తస్మిన్నైవార్పిష్యతే, తస్యైవ చ బాహుల్యం భవిష్యతి, కిన్తు యేన న వర్ద్వ్యతే, తస్యాన్తికే యత్ కిఞ్చన తిష్ఠతి, తదపి పునర్నేష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","అపరం యూయం తమకర్మ్మణ్యం దాసం నీత్వా యత్ర స్థానే క్రన్దనం దన్తఘర్షణఞ్చ విద్యేతే, తస్మిన్ బహిర్భూతతమసి నిక్షిపత| ");
INSERT INTO santel_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","యదా మనుజసుతః పవిత్రదూతాన్ సఙ్గినః కృత్వా నిజప్రభావేనాగత్య నిజతేజోమయే సింహాసనే నివేక్ష్యతి, ");
INSERT INTO santel_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","తదా తత్సమ్ముఖే సర్వ్వజాతీయా జనా సంమేలిష్యన్తి| తతో మేషపాలకో యథా ఛాగేభ్యోఽవీన్ పృథక్ కరోతి తథా సోప్యేకస్మాదన్యమ్ ఇత్థం తాన్ పృథక కృత్వావీన్ ");
INSERT INTO santel_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","దక్షిణే ఛాగాంశ్చ వామే స్థాపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","తతః పరం రాజా దక్షిణస్థితాన్ మానవాన్ వదిష్యతి, ఆగచ్ఛత మత్తాతస్యానుగ్రహభాజనాని, యుష్మత్కృత ఆ జగదారమ్భత్ యద్ రాజ్యమ్ ఆసాదితం తదధికురుత| ");
INSERT INTO santel_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","యతో బుభుక్షితాయ మహ్యం భోజ్యమ్ అదత్త, పిపాసితాయ పేయమదత్త, విదేశినం మాం స్వస్థానమనయత, ");
INSERT INTO santel_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","వస్త్రహీనం మాం వసనం పర్య్యధాపయత, పీడీతం మాం ద్రష్టుమాగచ్ఛత, కారాస్థఞ్చ మాం వీక్షితుమ ఆగచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","తదా ధార్మ్మికాః ప్రతివదిష్యన్తి, హే ప్రభో, కదా త్వాం క్షుధితం వీక్ష్య వయమభోజయామ? వా పిపాసితం వీక్ష్య అపాయయామ? ");
INSERT INTO santel_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","కదా వా త్వాం విదేశినం విలోక్య స్వస్థానమనయామ? కదా వా త్వాం నగ్నం వీక్ష్య వసనం పర్య్యధాపయామ? ");
INSERT INTO santel_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","కదా వా త్వాం పీడితం కారాస్థఞ్చ వీక్ష్య త్వదన్తికమగచ్ఛామ? ");
INSERT INTO santel_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","తదానీం రాజా తాన్ ప్రతివదిష్యతి, యుష్మానహం సత్యం వదామి, మమైతేషాం భ్రాతృణాం మధ్యే కఞ్చనైకం క్షుద్రతమం ప్రతి యద్ అకురుత, తన్మాం ప్రత్యకురుత| ");
INSERT INTO santel_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","పశ్చాత్ స వామస్థితాన్ జనాన్ వదిష్యతి, రే శాపగ్రస్తాః సర్వ్వే, శైతానే తస్య దూతేభ్యశ్చ యోఽనన్తవహ్నిరాసాదిత ఆస్తే, యూయం మదన్తికాత్ తమగ్నిం గచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","యతో క్షుధితాయ మహ్యమాహారం నాదత్త, పిపాసితాయ మహ్యం పేయం నాదత్త, ");
INSERT INTO santel_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","విదేశినం మాం స్వస్థానం నానయత, వసనహీనం మాం వసనం న పర్య్యధాపయత, పీడితం కారాస్థఞ్చ మాం వీక్షితుం నాగచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","తదా తే ప్రతివదిష్యన్తి, హే ప్రభో, కదా త్వాం క్షుధితం వా పిపాసితం వా విదేశినం వా నగ్నం వా పీడితం వా కారాస్థం వీక్ష్య త్వాం నాసేవామహి? ");
INSERT INTO santel_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","తదా స తాన్ వదిష్యతి, తథ్యమహం యుష్మాన్ బ్రవీమి, యుష్మాభిరేషాం కఞ్చన క్షోదిష్ఠం ప్రతి యన్నాకారి, తన్మాం ప్రత్యేవ నాకారి| ");
INSERT INTO santel_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","పశ్చాదమ్యనన్తశాస్తిం కిన్తు ధార్మ్మికా అనన్తాయుషం భోక్తుం యాస్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","యీశురేతాన్ ప్రస్తావాన్ సమాప్య శిష్యానూచే, ");
INSERT INTO santel_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","యుష్మాభి ర్జ్ఞాతం దినద్వయాత్ పరం నిస్తారమహ ఉపస్థాస్యతి, తత్ర మనుజసుతః క్రుశేన హన్తుం పరకరేషు సమర్పిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","తతః పరం ప్రధానయాజకాధ్యాపకప్రాఞ్చః కియఫానామ్నో మహాయాజకస్యాట్టాలికాయాం మిలిత్వా ");
INSERT INTO santel_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","కేనోపాయేన యీశుం ధృత్వా హన్తుం శక్నుయురితి మన్త్రయాఞ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","కిన్తు తైరుక్తం మహకాలే న ధర్త్తవ్యః, ధృతే ప్రజానాం కలహేన భవితుం శక్యతే| ");
INSERT INTO santel_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","తతో బైథనియాపురే శిమోనాఖ్యస్య కుష్ఠినో వేశ్మని యీశౌ తిష్ఠతి ");
INSERT INTO santel_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","కాచన యోషా శ్వేతోపలభాజనేన మహార్ఘ్యం సుగన్ధి తైలమానీయ భోజనాయోపవిశతస్తస్య శిరోభ్యషేచత్| ");
INSERT INTO santel_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","కిన్తు తదాలోక్య తచ్ఛిష్యైః కుపితైరుక్తం, కుత ఇత్థమపవ్యయతే? ");
INSERT INTO santel_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","చేదిదం వ్యక్రేష్యత, తర్హి భూరిమూల్యం ప్రాప్య దరిద్రేభ్యో వ్యతారిష్యత| ");
INSERT INTO santel_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","యీశునా తదవగత్య తే సముదితాః, యోషామేనాం కుతో దుఃఖినీం కురుథ, సా మాం ప్రతి సాధు కర్మ్మాకార్షీత్| ");
INSERT INTO santel_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","యుష్మాకమం సమీపే దరిద్రాః సతతమేవాసతే, కిన్తు యుష్మాకమన్తికేహం నాసే సతతం| ");
INSERT INTO santel_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","సా మమ కాయోపరి సుగన్ధితైలం సిక్త్వా మమ శ్మశానదానకర్మ్మాకార్షీత్| ");
INSERT INTO santel_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","అతోహం యుష్మాన్ తథ్యం వదామి సర్వ్వస్మిన్ జగతి యత్ర యత్రైష సుసమాచారః ప్రచారిష్యతే, తత్ర తత్రైతస్యా నార్య్యాః స్మరణార్థమ్ కర్మ్మేదం ప్రచారిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","తతో ద్వాదశశిష్యాణామ్ ఈష్కరియోతీయయిహూదానామక ఏకః శిష్యః ప్రధానయాజకానామన్తికం గత్వా కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","యది యుష్మాకం కరేషు యీశుం సమర్పయామి, తర్హి కిం దాస్యథ? తదానీం తే తస్మై త్రింశన్ముద్రా దాతుం స్థిరీకృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","స తదారభ్య తం పరకరేషు సమర్పయితుం సుయోగం చేష్టితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","అనన్తరం కిణ్వశూన్యపూపపర్వ్వణః ప్రథమేహ్ని శిష్యా యీశుమ్ ఉపగత్య పప్రచ్ఛుః భవత్కృతే కుత్ర వయం నిస్తారమహభోజ్యమ్ ఆయోజయిష్యామః? భవతః కేచ్ఛా? ");
INSERT INTO santel_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","తదా స గదితవాన్, మధ్యేనగరమముకపుంసః సమీపం వ్రజిత్వా వదత, గురు ర్గదితవాన్, మత్కాలః సవిధః, సహ శిష్యైస్త్వదాలయే నిస్తారమహభోజ్యం భోక్ష్యే| ");
INSERT INTO santel_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","తదా శిష్యా యీశోస్తాదృశనిదేశానురూపకర్మ్మ విధాయ తత్ర నిస్తారమహభోజ్యమాసాదయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","తతః సన్ధ్యాయాం సత్యాం ద్వాదశభిః శిష్యైః సాకం స న్యవిశత్| ");
INSERT INTO santel_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","అపరం భుఞ్జాన ఉక్తవాన్ యుష్మాన్ తథ్యం వదామి, యుష్మాకమేకో మాం పరకరేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","తదా తేఽతీవ దుఃఖితా ఏకైకశో వక్తుమారేభిరే, హే ప్రభో, స కిమహం? ");
INSERT INTO santel_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","తతః స జగాద, మయా సాకం యో జనో భోజనపాత్రే కరం సంక్షిపతి, స ఏవ మాం పరకరేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","మనుజసుతమధి యాదృశం లిఖితమాస్తే, తదనురూపా తద్గతి ర్భవిష్యతి; కిన్తు యేన పుంసా స పరకరేషు సమర్పయిష్యతే, హా హా చేత్ స నాజనిష్యత, తదా తస్య క్షేమమభవిష్యత్| ");
INSERT INTO santel_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","తదా యిహూదానామా యో జనస్తం పరకరేషు సమర్పయిష్యతి, స ఉక్తవాన్, హే గురో, స కిమహం? తతః స ప్రత్యుక్తవాన్, త్వయా సత్యం గదితమ్| ");
INSERT INTO santel_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","అనన్తరం తేషామశనకాలే యీశుః పూపమాదాయేశ్వరీయగుణాననూద్య భంక్త్వా శిష్యేభ్యః ప్రదాయ జగాద, మద్వపుఃస్వరూపమిమం గృహీత్వా ఖాదత| ");
INSERT INTO santel_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","పశ్చాత్ స కంసం గృహ్లన్ ఈశ్వరీయగుణాననూద్య తేభ్యః ప్రదాయ కథితవాన్, సర్వ్వై ర్యుష్మాభిరనేన పాతవ్యం, ");
INSERT INTO santel_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","యస్మాదనేకేషాం పాపమర్షణాయ పాతితం యన్మన్నూత్ననియమరూపశోణితం తదేతత్| ");
INSERT INTO santel_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","అపరమహం నూత్నగోస్తనీరసం న పాస్యామి, తావత్ గోస్తనీఫలరసం పునః కదాపి న పాస్యామి| ");
INSERT INTO santel_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","పశ్చాత్ తే గీతమేకం సంగీయ జైతునాఖ్యగిరిం గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","తదానీం యీశుస్తానవోచత్, అస్యాం రజన్యామహం యుష్మాకం సర్వ్వేషాం విఘ్నరూపో భవిష్యామి, యతో లిఖితమాస్తే, \"మేషాణాం రక్షకో యస్తం ప్రహరిష్యామ్యహం తతః| మేషాణాం నివహో నూనం ప్రవికీర్ణో భవిష్యతి\"|| ");
INSERT INTO santel_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","కిన్తు శ్మశానాత్ సముత్థాయ యుష్మాకమగ్రేఽహం గాలీలం గమిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","పితరస్తం ప్రోవాచ, భవాంశ్చేత్ సర్వ్వేషాం విఘ్నరూపో భవతి, తథాపి మమ న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","తతో యీశునా స ఉక్తః, తుభ్యమహం తథ్యం కథయామి, యామిన్యామస్యాం చరణాయుధస్య రవాత్ పూర్వ్వం త్వం మాం త్రి ర్నాఙ్గీకరిష్యసి| ");
INSERT INTO santel_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","తతః పితర ఉదితవాన్, యద్యపి త్వయా సమం మర్త్తవ్యం, తథాపి కదాపి త్వాం న నాఙ్గీకరిష్యామి; తథైవ సర్వ్వే శిష్యాశ్చోచుః| ");
INSERT INTO santel_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","అనన్తరం యీశుః శిష్యైః సాకం గేత్శిమానీనామకం స్థానం ప్రస్థాయ తేభ్యః కథితవాన్, అదః స్థానం గత్వా యావదహం ప్రార్థయిష్యే తావద్ యూయమత్రోపవిశత| ");
INSERT INTO santel_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","పశ్చాత్ స పితరం సివదియసుతౌ చ సఙ్గినః కృత్వా గతవాన్, శోకాకులోఽతీవ వ్యథితశ్చ బభూవ| ");
INSERT INTO santel_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","తానవాదీచ్చ మృతియాతనేవ మత్ప్రాణానాం యాతనా జాయతే, యూయమత్ర మయా సార్ద్ధం జాగృత| ");
INSERT INTO santel_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","తతః స కిఞ్చిద్దూరం గత్వాధోముఖః పతన్ ప్రార్థయాఞ్చక్రే, హే మత్పితర్యది భవితుం శక్నోతి, తర్హి కంసోఽయం మత్తో దూరం యాతు; కిన్తు మదిచ్ఛావత్ న భవతు, త్వదిచ్ఛావద్ భవతు| ");
INSERT INTO santel_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","తతః స శిష్యానుపేత్య తాన్ నిద్రతో నిరీక్ష్య పితరాయ కథయామాస, యూయం మయా సాకం దణ్డమేకమపి జాగరితుం నాశన్కుత? ");
INSERT INTO santel_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","పరీక్షాయాం న పతితుం జాగృత ప్రార్థయధ్వఞ్చ; ఆత్మా సముద్యతోస్తి, కిన్తు వపు ర్దుర్బ్బలం| ");
INSERT INTO santel_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","స ద్వితీయవారం ప్రార్థయాఞ్చక్రే, హే మత్తాత, న పీతే యది కంసమిదం మత్తో దూరం యాతుం న శక్నోతి, తర్హి త్వదిచ్ఛావద్ భవతు| ");
INSERT INTO santel_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","స పునరేత్య తాన్ నిద్రతో దదర్శ, యతస్తేషాం నేత్రాణి నిద్రయా పూర్ణాన్యాసన్| ");
INSERT INTO santel_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","పశ్చాత్ స తాన్ విహాయ వ్రజిత్వా తృతీయవారం పూర్వ్వవత్ కథయన్ ప్రార్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","తతః శిష్యానుపాగత్య గదితవాన్, సామ్ప్రతం శయానాః కిం విశ్రామ్యథ? పశ్యత, సమయ ఉపాస్థాత్, మనుజసుతః పాపినాం కరేషు సమర్ప్యతే| ");
INSERT INTO santel_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ఉత్తిష్ఠత, వయం యామః, యో మాం పరకరేషు మసర్పయిష్యతి, పశ్యత, స సమీపమాయాతి| ");
INSERT INTO santel_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ఏతత్కథాకథనకాలే ద్వాదశశిష్యాణామేకో యిహూదానామకో ముఖ్యయాజకలోకప్రాచీనైః ప్రహితాన్ అసిధారియష్టిధారిణో మనుజాన్ గృహీత్వా తత్సమీపముపతస్థౌ| ");
INSERT INTO santel_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","అసౌ పరకరేష్వర్పయితా పూర్వ్వం తాన్ ఇత్థం సఙ్కేతయామాస, యమహం చుమ్బిష్యే, సోఽసౌ మనుజః,సఏవ యుష్మాభి ర్ధార్య్యతాం| ");
INSERT INTO santel_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","తదా స సపది యీశుముపాగత్య హే గురో, ప్రణమామీత్యుక్త్వా తం చుచుమ్బే| ");
INSERT INTO santel_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","తదా యీశుస్తమువాచ, హే మిత్రం కిమర్థమాగతోసి? తదా తైరాగత్య యీశురాక్రమ్య దఘ్రే| ");
INSERT INTO santel_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","తతో యీశోః సఙ్గినామేకః కరం ప్రసార్య్య కోషాదసిం బహిష్కృత్య మహాయాజకస్య దాసమేకమాహత్య తస్య కర్ణం చిచ్ఛేద| ");
INSERT INTO santel_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","తతో యీశుస్తం జగాద, ఖడ్గం స్వస్థానేे నిధేహి యతో యే యే జనా అసిం ధారయన్తి, తఏవాసినా వినశ్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","అపరం పితా యథా మదన్తికం స్వర్గీయదూతానాం ద్వాదశవాహినీతోఽధికం ప్రహిణుయాత్ మయా తముద్దిశ్యేదానీమేవ తథా ప్రార్థయితుం న శక్యతే, త్వయా కిమిత్థం జ్ఞాయతే? ");
INSERT INTO santel_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","తథా సతీత్థం ఘటిష్యతే ధర్మ్మపుస్తకస్య యదిదం వాక్యం తత్ కథం సిధ్యేత్? ");
INSERT INTO santel_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","తదానీం యీశు ర్జననివహం జగాద, యూయం ఖడ్గయష్టీన్ ఆదాయ మాం కిం చౌరం ధర్త్తుమాయాతాః? అహం ప్రత్యహం యుష్మాభిః సాకముపవిశ్య సముపాదిశం, తదా మాం నాధరత; ");
INSERT INTO santel_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","కిన్తు భవిష్యద్వాదినాం వాక్యానాం సంసిద్ధయే సర్వ్వమేతదభూత్| తదా సర్వ్వే శిష్యాస్తం విహాయ పలాయన్త| ");
INSERT INTO santel_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","అనన్తరం తే మనుజా యీశుం ధృత్వా యత్రాధ్యాపకప్రాఞ్చః పరిషదం కుర్వ్వన్త ఉపావిశన్ తత్ర కియఫానాाమకమహాయాజకస్యాన్తికం నిన్యుః| ");
INSERT INTO santel_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","కిన్తు శేషే కిం భవిష్యతీతి వేత్తుం పితరో దూరే తత్పశ్చాద్ వ్రజిత్వా మహాయాజకస్యాట్టాలికాం ప్రవిశ్య దాసైః సహిత ఉపావిశత్| ");
INSERT INTO santel_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","తదానీం ప్రధానయాజకప్రాచీనమన్త్రిణః సర్వ్వే యీశుం హన్తుం మృషాసాక్ష్యమ్ అలిప్సన్త, ");
INSERT INTO santel_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","కిన్తు న లేభిరే| అనేకేషు మృషాసాక్షిష్వాగతేష్వపి తన్న ప్రాపుః| ");
INSERT INTO santel_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","శేషే ద్వౌ మృషాసాక్షిణావాగత్య జగదతుః, పుమానయమకథయత్, అహమీశ్వరమన్దిరం భంక్త్వా దినత్రయమధ్యే తన్నిర్మ్మాతుం శక్నోమి| ");
INSERT INTO santel_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","తదా మహాయాజక ఉత్థాయ యీశుమ్ అవాదీత్| త్వం కిమపి న ప్రతివదసి? త్వామధి కిమేతే సాక్ష్యం వదన్తి? ");
INSERT INTO santel_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","కిన్తు యీశు ర్మౌనీభూయ తస్యౌ| తతో మహాయాజక ఉక్తవాన్, త్వామ్ అమరేశ్వరనామ్నా శపయామి, త్వమీశ్వరస్య పుత్రోఽభిషిక్తో భవసి నవేతి వద| ");
INSERT INTO santel_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","యీశుః ప్రత్యవదత్, త్వం సత్యముక్తవాన్; అహం యుష్మాన్ తథ్యం వదామి, ఇతఃపరం మనుజసుతం సర్వ్వశక్తిమతో దక్షిణపార్శ్వే స్థాతుం గగణస్థం జలధరానారుహ్యాయాన్తం వీక్షధ్వే| ");
INSERT INTO santel_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","తదా మహాయాజకో నిజవసనం ఛిత్త్వా జగాద, ఏష ఈశ్వరం నిన్దితవాన్, అస్మాకమపరసాక్ష్యేణ కిం ప్రయోజనం? పశ్యత, యూయమేవాస్యాస్యాద్ ఈశ్వరనిన్దాం శ్రుతవన్తః, ");
INSERT INTO santel_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","యుష్మాభిః కిం వివిచ్యతే? తే ప్రత్యూచుః, వధార్హోఽయం| ");
INSERT INTO santel_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","తతో లోకైస్తదాస్యే నిష్ఠీవితం కేచిత్ ప్రతలమాహత్య కేచిచ్చ చపేటమాహత్య బభాషిరే, ");
INSERT INTO santel_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","హే ఖ్రీష్ట త్వాం కశ్చపేటమాహతవాన్? ఇతి గణయిత్వా వదాస్మాన్| ");
INSERT INTO santel_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","పితరో బహిరఙ్గన ఉపవిశతి, తదానీమేకా దాసీ తముపాగత్య బభాషే, త్వం గాలీలీయయీశోః సహచరఏకః| ");
INSERT INTO santel_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","కిన్తు స సర్వ్వేషాం సమక్షమ్ అనఙ్గీకృత్యావాదీత్, త్వయా యదుచ్యతే, తదర్థమహం న వేద్మి| ");
INSERT INTO santel_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","తదా తస్మిన్ బహిర్ద్వారం గతే ఽన్యా దాసీ తం నిరీక్ష్య తత్రత్యజనానవదత్, అయమపి నాసరతీయయీశునా సార్ద్ధమ్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","తతః స శపథేన పునరనఙ్గీకృత్య కథితవాన్, తం నరం న పరిచినోమి| ");
INSERT INTO santel_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","క్షణాత్ పరం తిష్ఠన్తో జనా ఏత్య పితరమ్ అవదన్, త్వమవశ్యం తేషామేక ఇతి త్వదుచ్చారణమేవ ద్యోతయతి| ");
INSERT INTO santel_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","కిన్తు సోఽభిశప్య కథితవాన్, తం జనం నాహం పరిచినోమి, తదా సపది కుక్కుటో రురావ| ");
INSERT INTO santel_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","కుక్కుటరవాత్ ప్రాక్ త్వం మాం త్రిరపాహ్నోష్యసే, యైషా వాగ్ యీశునావాది తాం పితరః సంస్మృత్య బహిరిత్వా ఖేదాద్ భృశం చక్రన్ద| ");
INSERT INTO santel_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ప్రభాతే జాతే ప్రధానయాజకలోకప్రాచీనా యీశుం హన్తుం తత్ప్రతికూలం మన్త్రయిత్వా ");
INSERT INTO santel_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","తం బద్వ్వా నీత్వా పన్తీయపీలాతాఖ్యాధిపే సమర్పయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","తతో యీశోః పరకరేవ్వర్పయితా యిహూదాస్తత్ప్రాణాదణ్డాజ్ఞాం విదిత్వా సన్తప్తమనాః ప్రధానయాజకలోకప్రాచీనానాం సమక్షం తాస్త్రీంశన్ముద్రాః ప్రతిదాయావాదీత్, ");
INSERT INTO santel_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ఏతన్నిరాగోనరప్రాణపరకరార్పణాత్ కలుషం కృతవానహం| తదా త ఉదితవన్తః, తేనాస్మాకం కిం? త్వయా తద్ బుధ్యతామ్| ");
INSERT INTO santel_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","తతో యిహూదా మన్దిరమధ్యే తా ముద్రా నిక్షిప్య ప్రస్థితవాన్ ఇత్వా చ స్వయమాత్మానముద్బబన్ధ| ");
INSERT INTO santel_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","పశ్చాత్ ప్రధానయాజకాస్తా ముద్రా ఆదాయ కథితవన్తః, ఏతా ముద్రాః శోణితమూల్యం తస్మాద్ భాణ్డాగారే న నిధాతవ్యాః| ");
INSERT INTO santel_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","అనన్తరం తే మన్త్రయిత్వా విదేశినాం శ్మశానస్థానాయ తాభిః కులాలస్య క్షేత్రమక్రీణన్| ");
INSERT INTO santel_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","అతోఽద్యాపి తత్స్థానం రక్తక్షేత్రం వదన్తి| ");
INSERT INTO santel_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ఇత్థం సతి ఇస్రాయేలీయసన్తానై ర్యస్య మూల్యం నిరుపితం, తస్య త్రింశన్ముద్రామానం మూల్యం ");
INSERT INTO santel_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","మాం ప్రతి పరమేశ్వరస్యాదేశాత్ తేభ్య ఆదీయత, తేన చ కులాలస్య క్షేత్రం క్రీతమితి యద్వచనం యిరిమియభవిష్యద్వాదినా ప్రోక్తం తత్ తదాసిధ్యత్| ");
INSERT INTO santel_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","అనన్తరం యీశౌ తదధిపతేః సమ్ముఖ ఉపతిష్ఠతి స తం పప్రచ్ఛ, త్వం కిం యిహూదీయానాం రాజా? తదా యీశుస్తమవదత్, త్వం సత్యముక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","కిన్తు ప్రధానయాజకప్రాచీనైరభియుక్తేన తేన కిమపి న ప్రత్యవాది| ");
INSERT INTO santel_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","తతః పీలాతేన స ఉదితః, ఇమే త్వత్ప్రతికూలతః కతి కతి సాక్ష్యం దదతి, తత్ త్వం న శృణోషి? ");
INSERT INTO santel_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","తథాపి స తేషామేకస్యాపి వచస ఉత్తరం నోదితవాన్; తేన సోఽధిపతి ర్మహాచిత్రం విదామాస| ");
INSERT INTO santel_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","అన్యచ్చ తన్మహకాలేఽధిపతేరేతాదృశీ రాతిరాసీత్, ప్రజా యం కఞ్చన బన్ధినం యాచన్తే, తమేవ స మోచయతీతి| ");
INSERT INTO santel_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","తదానీం బరబ్బానామా కశ్చిత్ ఖ్యాతబన్ధ్యాసీత్| ");
INSERT INTO santel_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","తతః పీలాతస్తత్ర మిలితాన్ లోకాన్ అపృచ్ఛత్, ఏష బరబ్బా బన్ధీ ఖ్రీష్టవిఖ్యాతో యీశుశ్చైతయోః కం మోచయిష్యామి? యుష్మాకం కిమీప్సితం? ");
INSERT INTO santel_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","తైరీర్ష్యయా స సమర్పిత ఇతి స జ్ఞాతవాన్| ");
INSERT INTO santel_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","అపరం విచారాసనోపవేశనకాలే పీలాతస్య పత్నీ భృత్యం ప్రహిత్య తస్మై కథయామాస, తం ధార్మ్మికమనుజం ప్రతి త్వయా కిమపి న కర్త్తవ్యం; యస్మాత్ తత్కృతేఽద్యాహం స్వప్నే ప్రభూతకష్టమలభే| ");
INSERT INTO santel_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","అనన్తరం ప్రధానయాజకప్రాచీనా బరబ్బాం యాచిత్వాదాతుం యీశుఞ్చ హన్తుం సకలలోకాన్ ప్రావర్త్తయన్| ");
INSERT INTO santel_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","తతోఽధిపతిస్తాన్ పృష్టవాన్, ఏతయోః కమహం మోచయిష్యామి? యుష్మాకం కేచ్ఛా? తే ప్రోచు ర్బరబ్బాం| ");
INSERT INTO santel_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","తదా పీలాతః పప్రచ్ఛ, తర్హి యం ఖ్రీష్టం వదన్తి, తం యీశుం కిం కరిష్యామి? సర్వ్వే కథయామాసుః, స క్రుశేన విధ్యతాం| ");
INSERT INTO santel_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","తతోఽధిపతిరవాదీత్, కుతః? కిం తేనాపరాద్ధం? కిన్తు తే పునరుచై ర్జగదుః, స క్రుశేన విధ్యతాం| ");
INSERT INTO santel_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","తదా నిజవాక్యమగ్రాహ్యమభూత్, కలహశ్చాప్యభూత్, పీలాత ఇతి విలోక్య లోకానాం సమక్షం తోయమాదాయ కరౌ ప్రక్షాల్యావోచత్, ఏతస్య ధార్మ్మికమనుష్యస్య శోణితపాతే నిర్దోషోఽహం, యుష్మాభిరేవ తద్ బుధ్యతాం| ");
INSERT INTO santel_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","తదా సర్వ్వాః ప్రజాః ప్రత్యవోచన్, తస్య శోణితపాతాపరాధోఽస్మాకమ్ అస్మత్సన్తానానాఞ్చోపరి భవతు| ");
INSERT INTO santel_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","తతః స తేషాం సమీపే బరబ్బాం మోచయామాస యీశున్తు కషాభిరాహత్య క్రుశేన వేధితుం సమర్పయామాస| ");
INSERT INTO santel_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","అనన్తరమ్ అధిపతేః సేనా అధిపతే ర్గృహం యీశుమానీయ తస్య సమీపే సేనాసమూహం సంజగృహుః| ");
INSERT INTO santel_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","తతస్తే తస్య వసనం మోచయిత్వా కృష్ణలోహితవర్ణవసనం పరిధాపయామాసుః ");
INSERT INTO santel_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","కణ్టకానాం ముకుటం నిర్మ్మాయ తచ్ఛిరసి దదుః, తస్య దక్షిణకరే వేత్రమేకం దత్త్వా తస్య సమ్ముఖే జానూని పాతయిత్వా, హే యిహూదీయానాం రాజన్, తుభ్యం నమ ఇత్యుక్త్వా తం తిరశ్చక్రుః, ");
INSERT INTO santel_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","తతస్తస్య గాత్రే నిష్ఠీవం దత్వా తేన వేత్రేణ శిర ఆజఘ్నుః| ");
INSERT INTO santel_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ఇత్థం తం తిరస్కృత్య తద్ వసనం మోచయిత్వా పునర్నిజవసనం పరిధాపయాఞ్చక్రుః, తం క్రుశేన వేధితుం నీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","పశ్చాత్తే బహిర్భూయ కురీణీయం శిమోన్నామకమేకం విలోక్య క్రుశం వోఢుం తమాదదిరే| ");
INSERT INTO santel_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","అనన్తరం గుల్గల్తామ్ అర్థాత్ శిరస్కపాలనామకస్థానము పస్థాయ తే యీశవే పిత్తమిశ్రితామ్లరసం పాతుం దదుః, ");
INSERT INTO santel_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","కిన్తు స తమాస్వాద్య న పపౌ| ");
INSERT INTO santel_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","తదానీం తే తం క్రుశేన సంవిధ్య తస్య వసనాని గుటికాపాతేన విభజ్య జగృహుః, తస్మాత్, విభజన్తేఽధరీయం మే తే మనుష్యాః పరస్పరం| మదుత్తరీయవస్త్రార్థం గుటికాం పాతయన్తి చ|| యదేతద్వచనం భవిష్యద్వాదిభిరుక్తమాసీత్, తదా తద్ అసిధ్యత్, ");
INSERT INTO santel_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","పశ్చాత్ తే తత్రోపవిశ్య తద్రక్షణకర్వ్వణి నియుక్తాస్తస్థుః| ");
INSERT INTO santel_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","అపరమ్ ఏష యిహూదీయానాం రాజా యీశురిత్యపవాదలిపిపత్రం తచ్ఛిరస ఊర్ద్వ్వే యోజయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","తతస్తస్య వామే దక్షిణే చ ద్వౌ చైరౌ తేన సాకం క్రుశేన వివిధుః| ");
INSERT INTO santel_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","తదా పాన్థా నిజశిరో లాడయిత్వా తం నిన్దన్తో జగదుః, ");
INSERT INTO santel_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","హే ఈశ్వరమన్దిరభఞ్జక దినత్రయే తన్నిర్మ్మాతః స్వం రక్ష, చేత్త్వమీశ్వరసుతస్తర్హి క్రుశాదవరోహ| ");
INSERT INTO santel_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ప్రధానయాజకాధ్యాపకప్రాచీనాశ్చ తథా తిరస్కృత్య జగదుః, ");
INSERT INTO santel_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","సోఽన్యజనానావత్, కిన్తు స్వమవితుం న శక్నోతి| యదీస్రాయేలో రాజా భవేత్, తర్హీదానీమేవ క్రుశాదవరోహతు, తేన తం వయం ప్రత్యేష్యామః| ");
INSERT INTO santel_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","స ఈశ్వరే ప్రత్యాశామకరోత్, యదీశ్వరస్తస్మిన్ సన్తుష్టస్తర్హీదానీమేవ తమవేత్, యతః స ఉక్తవాన్ అహమీశ్వరసుతః| ");
INSERT INTO santel_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","యౌ స్తేనౌ సాకం తేన క్రుశేన విద్ధౌ తౌ తద్వదేవ తం నినిన్దతుః| ");
INSERT INTO santel_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","తదా ద్వితీయయామాత్ తృతీయయామం యావత్ సర్వ్వదేశే తమిరం బభూవ, ");
INSERT INTO santel_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","తృతీయయామే \"ఏలీ ఏలీ లామా శివక్తనీ\", అర్థాత్ మదీశ్వర మదీశ్వర కుతో మామత్యాక్షీః? యీశురుచ్చైరితి జగాద| ");
INSERT INTO santel_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","తదా తత్ర స్థితాః కేచిత్ తత్ శ్రుత్వా బభాషిరే, అయమ్ ఏలియమాహూయతి| ");
INSERT INTO santel_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","తేషాం మధ్యాద్ ఏకః శీఘ్రం గత్వా స్పఞ్జం గృహీత్వా తత్రామ్లరసం దత్త్వా నలేన పాతుం తస్మై దదౌ| ");
INSERT INTO santel_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ఇతరేఽకథయన్ తిష్ఠత, తం రక్షితుమ్ ఏలియ ఆయాతి నవేతి పశ్యామః| ");
INSERT INTO santel_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","యీశుః పునరుచైరాహూయ ప్రాణాన్ జహౌ| ");
INSERT INTO santel_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","తతో మన్దిరస్య విచ్ఛేదవసనమ్ ఊర్ద్వ్వాదధో యావత్ ఛిద్యమానం ద్విధాభవత్, ");
INSERT INTO santel_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","భూమిశ్చకమ్పే భూధరోవ్యదీర్య్యత చ| శ్మశానే ముక్తే భూరిపుణ్యవతాం సుప్తదేహా ఉదతిష్ఠన్, ");
INSERT INTO santel_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","శ్మశానాద్ వహిర్భూయ తదుత్థానాత్ పరం పుణ్యపురం గత్వా బహుజనాన్ దర్శయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","యీశురక్షణాయ నియుక్తః శతసేనాపతిస్తత్సఙ్గినశ్చ తాదృశీం భూకమ్పాదిఘటనాం దృష్ట్వా భీతా అవదన్, ఏష ఈశ్వరపుత్రో భవతి| ");
INSERT INTO santel_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","యా బహుయోషితో యీశుం సేవమానా గాలీలస్తత్పశ్చాదాగతాస్తాసాం మధ్యే ");
INSERT INTO santel_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","మగ్దలీనీ మరియమ్ యాకూబ్యోశ్యో ర్మాతా యా మరియమ్ సిబదియపుత్రయో ర్మాతా చ యోషిత ఏతా దూరే తిష్ఠన్త్యో దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","సన్ధ్యాయాం సత్యమ్ అరిమథియానగరస్య యూషఫ్నామా ధనీ మనుజో యీశోః శిష్యత్వాత్ ");
INSERT INTO santel_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","పీలాతస్య సమీపం గత్వా యీశోః కాయం యయాచే, తేన పీలాతః కాయం దాతుమ్ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","యూషఫ్ తత్కాయం నీత్వా శుచివస్త్రేణాచ్ఛాద్య ");
INSERT INTO santel_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","స్వార్థం శైలే యత్ శ్మశానం చఖాన, తన్మధ్యే తత్కాయం నిధాయ తస్య ద్వారి వృహత్పాషాణం దదౌ| ");
INSERT INTO santel_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","కిన్తు మగ్దలీనీ మరియమ్ అన్యమరియమ్ ఏతే స్త్రియౌ తత్ర శ్మశానసమ్ముఖ ఉపవివిశతుః| ");
INSERT INTO santel_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","తదనన్తరం నిస్తారోత్సవస్యాయోజనదినాత్ పరేఽహని ప్రధానయాజకాః ఫిరూశినశ్చ మిలిత్వా పీలాతముపాగత్యాకథయన్, ");
INSERT INTO santel_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","హే మహేచ్ఛ స ప్రతారకో జీవన అకథయత్, దినత్రయాత్ పరం శ్మశానాదుత్థాస్యామి తద్వాక్యం స్మరామో వయం; ");
INSERT INTO santel_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","తస్మాత్ తృతీయదినం యావత్ తత్ శ్మశానం రక్షితుమాదిశతు, నోచేత్ తచ్ఛిష్యా యామిన్యామాగత్య తం హృత్వా లోకాన్ వదిష్యన్తి, స శ్మశానాదుదతిష్ఠత్, తథా సతి ప్రథమభ్రాన్తేః శేషీయభ్రాన్తి ర్మహతీ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","తదా పీలాత అవాదీత్, యుష్మాకం సమీపే రక్షిగణ ఆస్తే, యూయం గత్వా యథా సాధ్యం రక్షయత| ");
INSERT INTO santel_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","తతస్తే గత్వా తద్దూाరపాషాణం ముద్రాఙ్కితం కృత్వా రక్షిగణం నియోజ్య శ్మశానం రక్షయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","తతః పరం విశ్రామవారస్య శేషే సప్తాహప్రథమదినస్య ప్రభోతే జాతే మగ్దలీనీ మరియమ్ అన్యమరియమ్ చ శ్మశానం ద్రష్టుమాగతా| ");
INSERT INTO santel_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","తదా మహాన్ భూకమ్పోఽభవత్; పరమేశ్వరీయదూతః స్వర్గాదవరుహ్య శ్మశానద్వారాత్ పాషాణమపసార్య్య తదుపర్య్యుపవివేశ| ");
INSERT INTO santel_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","తద్వదనం విద్యుద్వత్ తేజోమయం వసనం హిమశుభ్రఞ్చ| ");
INSERT INTO santel_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","తదానీం రక్షిణస్తద్భయాత్ కమ్పితా మృతవద్ బభూవః| ");
INSERT INTO santel_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","స దూతో యోషితో జగాద, యూయం మా భైష్ట, క్రుశహతయీశుం మృగయధ్వే తదహం వేద్మి| ");
INSERT INTO santel_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","సోఽత్ర నాస్తి, యథావదత్ తథోత్థితవాన్; ఏతత్ ప్రభోః శయనస్థానం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","తూర్ణం గత్వా తచ్ఛిష్యాన్ ఇతి వదత, స శ్మశానాద్ ఉదతిష్ఠత్, యుష్మాకమగ్రే గాలీలం యాస్యతి యూయం తత్ర తం వీక్షిష్యధ్వే, పశ్యతాహం వార్త్తామిమాం యుష్మానవాదిషం| ");
INSERT INTO santel_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","తతస్తా భయాత్ మహానన్దాఞ్చ శ్మశానాత్ తూర్ణం బహిర్భూయ తచ్ఛిష్యాన్ వార్త్తాం వక్తుం ధావితవత్యః| కిన్తు శిష్యాన్ వార్త్తాం వక్తుం యాన్తి, తదా యీశు ర్దర్శనం దత్త్వా తా జగాద, ");
INSERT INTO santel_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","యుష్మాకం కల్యాణం భూయాత్, తతస్తా ఆగత్య తత్పాదయోః పతిత్వా ప్రణేముః| ");
INSERT INTO santel_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","యీశుస్తా అవాదీత్, మా బిభీత, యూయం గత్వా మమ భ్రాతృన్ గాలీలం యాతుం వదత, తత్ర తే మాం ద్రక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","స్త్రియో గచ్ఛన్తి, తదా రక్షిణాం కేచిత్ పురం గత్వా యద్యద్ ఘటితం తత్సర్వ్వం ప్రధానయాజకాన్ జ్ఞాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","తే ప్రాచీనైః సమం సంసదం కృత్వా మన్త్రయన్తో బహుముద్రాః సేనాభ్యో దత్త్వావదన్, ");
INSERT INTO santel_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","అస్మాసు నిద్రితేషు తచ్ఛిష్యా యామిన్యామాగత్య తం హృత్వానయన్, ఇతి యూయం ప్రచారయత| ");
INSERT INTO santel_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","యద్యేతదధిపతేః శ్రోత్రగోచరీభవేత్, తర్హి తం బోధయిత్వా యుష్మానవిష్యామః| ");
INSERT INTO santel_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","తతస్తే ముద్రా గృహీత్వా శిక్షానురూపం కర్మ్మ చక్రుః, యిహూదీయానాం మధ్యే తస్యాద్యాపి కింవదన్తీ విద్యతే| ");
INSERT INTO santel_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ఏకాదశ శిష్యా యీశునిరూపితాగాలీలస్యాద్రిం గత్వా ");
INSERT INTO santel_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","తత్ర తం సంవీక్ష్య ప్రణేముః, కిన్తు కేచిత్ సన్దిగ్ధవన్తః| ");
INSERT INTO santel_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","యీశుస్తేషాం సమీపమాగత్య వ్యాహృతవాన్, స్వర్గమేదిన్యోః సర్వ్వాధిపతిత్వభారో మయ్యర్పిత ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","అతో యూయం ప్రయాయ సర్వ్వదేశీయాన్ శిష్యాన్ కృత్వా పితుః పుత్రస్య పవిత్రస్యాత్మనశ్చ నామ్నా తానవగాహయత; అహం యుష్మాన్ యద్యదాదిశం తదపి పాలయితుం తానుపాదిశత| ");
INSERT INTO santel_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","పశ్యత, జగదన్తం యావత్ సదాహం యుష్మాభిః సాకం తిష్ఠామి| ఇతి|");
INSERT INTO santel_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ఈశ్వరపుత్రస్య యీశుఖ్రీష్టస్య సుసంవాదారమ్భః| ");
INSERT INTO santel_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","భవిష్యద్వాదినాం గ్రన్థేషు లిపిరిత్థమాస్తే, పశ్య స్వకీయదూతన్తు తవాగ్రే ప్రేషయామ్యహమ్| గత్వా త్వదీయపన్థానం స హి పరిష్కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"పరమేశస్య పన్థానం పరిష్కురుత సర్వ్వతః| తస్య రాజపథఞ్చైవ సమానం కురుతాధునా| \" ఇత్యేతత్ ప్రాన్తరే వాక్యం వదతః కస్యచిద్రవః|| ");
INSERT INTO santel_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","సఏవ యోహన్ ప్రాన్తరే మజ్జితవాన్ తథా పాపమార్జననిమిత్తం మనోవ్యావర్త్తకమజ్జనస్య కథాఞ్చ ప్రచారితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","తతో యిహూదాదేశయిరూశాలమ్నగరనివాసినః సర్వ్వే లోకా బహి ర్భూత్వా తస్య సమీపమాగత్య స్వాని స్వాని పాపాన్యఙ్గీకృత్య యర్ద్దననద్యాం తేన మజ్జితా బభూవుః| ");
INSERT INTO santel_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","అస్య యోహనః పరిధేయాని క్రమేలకలోమజాని, తస్య కటిబన్ధనం చర్మ్మజాతమ్, తస్య భక్ష్యాణి చ శూకకీటా వన్యమధూని చాసన్| ");
INSERT INTO santel_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","స ప్రచారయన్ కథయాఞ్చక్రే, అహం నమ్రీభూయ యస్య పాదుకాబన్ధనం మోచయితుమపి న యోగ్యోస్మి, తాదృశో మత్తో గురుతర ఏకః పురుషో మత్పశ్చాదాగచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","అహం యుష్మాన్ జలే మజ్జితవాన్ కిన్తు స పవిత్ర ఆత్మాని సంమజ్జయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","అపరఞ్చ తస్మిన్నేవ కాలే గాలీల్ప్రదేశస్య నాసరద్గ్రామాద్ యీశురాగత్య యోహనా యర్ద్దననద్యాం మజ్జితోఽభూత్| ");
INSERT INTO santel_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","స జలాదుత్థితమాత్రో మేఘద్వారం ముక్తం కపోతవత్ స్వస్యోపరి అవరోహన్తమాత్మానఞ్చ దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","త్వం మమ ప్రియః పుత్రస్త్వయ్యేవ మమమహాసన్తోష ఇయమాకాశీయా వాణీ బభూవ| ");
INSERT INTO santel_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","తస్మిన్ కాలే ఆత్మా తం ప్రాన్తరమధ్యం నినాయ| ");
INSERT INTO santel_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","అథ స చత్వారింశద్దినాని తస్మిన్ స్థానే వన్యపశుభిః సహ తిష్ఠన్ శైతానా పరీక్షితః; పశ్చాత్ స్వర్గీయదూతాస్తం సిషేవిరే| ");
INSERT INTO santel_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","అనన్తరం యోహని బన్ధనాలయే బద్ధే సతి యీశు ర్గాలీల్ప్రదేశమాగత్య ఈశ్వరరాజ్యస్య సుసంవాదం ప్రచారయన్ కథయామాస, ");
INSERT INTO santel_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","కాలః సమ్పూర్ణ ఈశ్వరరాజ్యఞ్చ సమీపమాగతం; అతోహేతో ర్యూయం మనాంసి వ్యావర్త్తయధ్వం సుసంవాదే చ విశ్వాసిత| ");
INSERT INTO santel_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","తదనన్తరం స గాలీలీయసముద్రస్య తీరే గచ్ఛన్ శిమోన్ తస్య భ్రాతా అన్ద్రియనామా చ ఇమౌ ద్వౌ జనౌ మత్స్యధారిణౌ సాగరమధ్యే జాలం ప్రక్షిపన్తౌ దృష్ట్వా తావవదత్, ");
INSERT INTO santel_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","యువాం మమ పశ్చాదాగచ్ఛతం, యువామహం మనుష్యధారిణౌ కరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","తతస్తౌ తత్క్షణమేవ జాలాని పరిత్యజ్య తస్య పశ్చాత్ జగ్మతుః| ");
INSERT INTO santel_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","తతః పరం తత్స్థానాత్ కిఞ్చిద్ దూరం గత్వా స సివదీపుత్రయాకూబ్ తద్భ్రాతృయోహన్ చ ఇమౌ నౌకాయాం జాలానాం జీర్ణముద్ధారయన్తౌ దృష్ట్వా తావాహూయత్| ");
INSERT INTO santel_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","తతస్తౌ నౌకాయాం వేతనభుగ్భిః సహితం స్వపితరం విహాయ తత్పశ్చాదీయతుః| ");
INSERT INTO santel_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","తతః పరం కఫర్నాహూమ్నామకం నగరముపస్థాయ స విశ్రామదివసే భజనగ్రహం ప్రవిశ్య సముపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","తస్యోపదేశాల్లోకా ఆశ్చర్య్యం మేనిరే యతః సోధ్యాపకాఇవ నోపదిశన్ ప్రభావవానివ ప్రోపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","అపరఞ్చ తస్మిన్ భజనగృహే అపవిత్రభూతేన గ్రస్త ఏకో మానుష ఆసీత్| స చీత్శబ్దం కృత్వా కథయాఞ్చకే ");
INSERT INTO santel_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","భో నాసరతీయ యీశో త్వమస్మాన్ త్యజ, త్వయా సహాస్మాకం కః సమ్బన్ధః? త్వం కిమస్మాన్ నాశయితుం సమాగతః? త్వమీశ్వరస్య పవిత్రలోక ఇత్యహం జానామి| ");
INSERT INTO santel_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","తదా యీశుస్తం తర్జయిత్వా జగాద తూష్ణీం భవ ఇతో బహిర్భవ చ| ");
INSERT INTO santel_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","తతః సోఽపవిత్రభూతస్తం సమ్పీడ్య అత్యుచైశ్చీత్కృత్య నిర్జగామ| ");
INSERT INTO santel_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","తేనైవ సర్వ్వే చమత్కృత్య పరస్పరం కథయాఞ్చక్రిరే, అహో కిమిదం? కీదృశోఽయం నవ్య ఉపదేశః? అనేన ప్రభావేనాపవిత్రభూతేష్వాజ్ఞాపితేషు తే తదాజ్ఞానువర్త్తినో భవన్తి| ");
INSERT INTO santel_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","తదా తస్య యశో గాలీలశ్చతుర్దిక్స్థసర్వ్వదేశాన్ వ్యాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","అపరఞ్చ తే భజనగృహాద్ బహి ర్భూత్వా యాకూబ్యోహన్భ్యాం సహ శిమోన ఆన్ద్రియస్య చ నివేశనం ప్రవివిశుః| ");
INSERT INTO santel_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","తదా పితరస్య శ్వశ్రూర్జ్వరపీడితా శయ్యాయామాస్త ఇతి తే తం ఝటితి విజ్ఞాపయాఞ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","తతః స ఆగత్య తస్యా హస్తం ధృత్వా తాముదస్థాపయత్; తదైవ తాం జ్వరోఽత్యాక్షీత్ తతః పరం సా తాన్ సిషేవే| ");
INSERT INTO santel_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","అథాస్తం గతే రవౌ సన్ధ్యాకాలే సతి లోకాస్తత్సమీపం సర్వ్వాన్ రోగిణో భూతధృతాంశ్చ సమానిన్యుః| ");
INSERT INTO santel_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","సర్వ్వే నాగరికా లోకా ద్వారి సంమిలితాశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","తతః స నానావిధరోగిణో బహూన్ మనుజానరోగిణశ్చకార తథా బహూన్ భూతాన్ త్యాజయాఞ్చకార తాన్ భూతాన్ కిమపి వాక్యం వక్తుం నిషిషేధ చ యతోహేతోస్తే తమజానన్| ");
INSERT INTO santel_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","అపరఞ్చ సోఽతిప్రత్యూషే వస్తుతస్తు రాత్రిశేషే సముత్థాయ బహిర్భూయ నిర్జనం స్థానం గత్వా తత్ర ప్రార్థయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","అనన్తరం శిమోన్ తత్సఙ్గినశ్చ తస్య పశ్చాద్ గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","తదుద్దేశం ప్రాప్య తమవదన్ సర్వ్వే లోకాస్త్వాం మృగయన్తే| ");
INSERT INTO santel_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","తదా సోఽకథయత్ ఆగచ్ఛత వయం సమీపస్థాని నగరాణి యామః, యతోఽహం తత్ర కథాం ప్రచారయితుం బహిరాగమమ్| ");
INSERT INTO santel_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","అథ స తేషాం గాలీల్ప్రదేశస్య సర్వ్వేషు భజనగృహేషు కథాః ప్రచారయాఞ్చక్రే భూతానత్యాజయఞ్చ| ");
INSERT INTO santel_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","అనన్తరమేకః కుష్ఠీ సమాగత్య తత్సమ్ముఖే జానుపాతం వినయఞ్చ కృత్వా కథితవాన్ యది భవాన్ ఇచ్ఛతి తర్హి మాం పరిష్కర్త్తుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","తతః కృపాలు ర్యీశుః కరౌ ప్రసార్య్య తం స్పష్ట్వా కథయామాస ");
INSERT INTO santel_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","మమేచ్ఛా విద్యతే త్వం పరిష్కృతో భవ| ఏతత్కథాయాః కథనమాత్రాత్ స కుష్ఠీ రోగాన్ముక్తః పరిష్కృతోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","తదా స తం విసృజన్ గాఢమాదిశ్య జగాద ");
INSERT INTO santel_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","సావధానో భవ కథామిమాం కమపి మా వద; స్వాత్మానం యాజకం దర్శయ, లోకేభ్యః స్వపరిష్కృతేః ప్రమాణదానాయ మూసానిర్ణీతం యద్దానం తదుత్సృజస్వ చ| ");
INSERT INTO santel_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","కిన్తు స గత్వా తత్ కర్మ్మ ఇత్థం విస్తార్య్య ప్రచారయితుం ప్రారేభే తేనైవ యీశుః పునః సప్రకాశం నగరం ప్రవేష్టుం నాశక్నోత్ తతోహేతోర్బహిః కాననస్థానే తస్యౌ; తథాపి చతుర్ద్దిగ్భ్యో లోకాస్తస్య సమీపమాయయుః| ");
INSERT INTO santel_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","తదనన్తరం యీశై కతిపయదినాని విలమ్బ్య పునః కఫర్నాహూమ్నగరం ప్రవిష్టే స గృహ ఆస్త ఇతి కింవదన్త్యా తత్క్షణం తత్సమీపం బహవో లోకా ఆగత్య సముపతస్థుః, ");
INSERT INTO santel_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","తస్మాద్ గృహమధ్యే సర్వ్వేషాం కృతే స్థానం నాభవద్ ద్వారస్య చతుర్దిక్ష్వపి నాభవత్, తత్కాలే స తాన్ ప్రతి కథాం ప్రచారయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","తతః పరం లోకాశ్చతుర్భి ర్మానవైరేకం పక్షాఘాతినం వాహయిత్వా తత్సమీపమ్ ఆనిన్యుః| ");
INSERT INTO santel_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","కిన్తు జనానాం బహుత్వాత్ తం యీశోః సమ్ముఖమానేతుం న శక్నువన్తో యస్మిన్ స్థానే స ఆస్తే తదుపరిగృహపృష్ఠం ఖనిత్వా ఛిద్రం కృత్వా తేన మార్గేణ సశయ్యం పక్షాఘాతినమ్ అవరోహయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","తతో యీశుస్తేషాం విశ్వాసం దృష్ట్వా తం పక్షాఘాతినం బభాషే హే వత్స తవ పాపానాం మార్జనం భవతు| ");
INSERT INTO santel_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","తదా కియన్తోఽధ్యాపకాస్తత్రోపవిశన్తో మనోభి ర్వితర్కయాఞ్చక్రుః, ఏష మనుష్య ఏతాదృశీమీశ్వరనిన్దాం కథాం కుతః కథయతి? ");
INSERT INTO santel_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ఈశ్వరం వినా పాపాని మార్ష్టుం కస్య సామర్థ్యమ్ ఆస్తే? ");
INSERT INTO santel_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ఇత్థం తే వితర్కయన్తి యీశుస్తత్క్షణం మనసా తద్ బుద్వ్వా తానవదద్ యూయమన్తఃకరణైః కుత ఏతాని వితర్కయథ? ");
INSERT INTO santel_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","తదనన్తరం యీశుస్తత్స్థానాత్ పునః సముద్రతటం యయౌ; లోకనివహే తత్సమీపమాగతే స తాన్ సముపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","కిన్తు పృథివ్యాం పాపాని మార్ష్టుం మనుష్యపుత్రస్య సామర్థ్యమస్తి, ఏతద్ యుష్మాన్ జ్ఞాపయితుం (స తస్మై పక్షాఘాతినే కథయామాస) ");
INSERT INTO santel_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ఉత్తిష్ఠ తవ శయ్యాం గృహీత్వా స్వగృహం యాహి, అహం త్వామిదమ్ ఆజ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","తతః స తత్క్షణమ్ ఉత్థాయ శయ్యాం గృహీత్వా సర్వ్వేషాం సాక్షాత్ జగామ; సర్వ్వే విస్మితా ఏతాదృశం కర్మ్మ వయమ్ కదాపి నాపశ్యామ, ఇమాం కథాం కథయిత్వేశ్వరం ధన్యమబ్రువన్| ");
INSERT INTO santel_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","తదనన్తరం యీశుస్తత్స్థానాత్ పునః సముద్రతటం యయౌ; లోకనివహే తత్సమీపమాగతే స తాన్ సముపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","అథ గచ్ఛన్ కరసఞ్చయగృహ ఉపవిష్టమ్ ఆల్ఫీయపుత్రం లేవిం దృష్ట్వా తమాహూయ కథితవాన్ మత్పశ్చాత్ త్వామామచ్ఛ తతః స ఉత్థాయ తత్పశ్చాద్ యయౌ| ");
INSERT INTO santel_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","అనన్తరం యీశౌ తస్య గృహే భోక్తుమ్ ఉపవిష్టే బహవః కరమఞ్చాయినః పాపినశ్చ తేన తచ్ఛిష్యైశ్చ సహోపవివిశుః, యతో బహవస్తత్పశ్చాదాజగ్ముః| ");
INSERT INTO santel_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","తదా స కరమఞ్చాయిభిః పాపిభిశ్చ సహ ఖాదతి, తద్ దృష్ట్వాధ్యాపకాః ఫిరూశినశ్చ తస్య శిష్యానూచుః కరమఞ్చాయిభిః పాపిభిశ్చ సహాయం కుతో భుంక్తే పివతి చ? ");
INSERT INTO santel_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","తద్వాక్యం శ్రుత్వా యీశుః ప్రత్యువాచ,అరోగిలోకానాం చికిత్సకేన ప్రయోజనం నాస్తి, కిన్తు రోగిణామేవ; అహం ధార్మ్మికానాహ్వాతుం నాగతః కిన్తు మనో వ్యావర్త్తయితుం పాపిన ఏవ| ");
INSERT INTO santel_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","తతః పరం యోహనః ఫిరూశినాఞ్చోపవాసాచారిశిష్యా యీశోః సమీపమ్ ఆగత్య కథయామాసుః, యోహనః ఫిరూశినాఞ్చ శిష్యా ఉపవసన్తి కిన్తు భవతః శిష్యా నోపవసన్తి కిం కారణమస్య? ");
INSERT INTO santel_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","తదా యీశుస్తాన్ బభాషే యావత్ కాలం సఖిభిః సహ కన్యాయా వరస్తిష్ఠతి తావత్కాలం తే కిముపవస్తుం శక్నువన్తి? యావత్కాలం వరస్తైః సహ తిష్ఠతి తావత్కాలం త ఉపవస్తుం న శక్నువన్తి| ");
INSERT INTO santel_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","యస్మిన్ కాలే తేభ్యః సకాశాద్ వరో నేష్యతే స కాల ఆగచ్ఛతి, తస్మిన్ కాలే తే జనా ఉపవత్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","కోపి జనః పురాతనవస్త్రే నూతనవస్త్రం న సీవ్యతి, యతో నూతనవస్త్రేణ సహ సేవనే కృతే జీర్ణం వస్త్రం ఛిద్యతే తస్మాత్ పున ర్మహత్ ఛిద్రం జాయతే| ");
INSERT INTO santel_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","కోపి జనః పురాతనకుతూషు నూతనం ద్రాక్షారసం న స్థాపయతి, యతో నూతనద్రాక్షారసస్య తేజసా తాః కుత్వో విదీర్య్యన్తే తతో ద్రాక్షారసశ్చ పతతి కుత్వశ్చ నశ్యన్తి, అతఏవ నూతనద్రాక్షారసో నూతనకుతూషు స్థాపనీయః| ");
INSERT INTO santel_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","తదనన్తరం యీశు ర్యదా విశ్రామవారే శస్యక్షేత్రేణ గచ్ఛతి తదా తస్య శిష్యా గచ్ఛన్తః శస్యమఞ్జరీశ్ఛేత్తుం ప్రవృత్తాః| ");
INSERT INTO santel_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","అతః ఫిరూశినో యీశవే కథయామాసుః పశ్యతు విశ్రామవాసరే యత్ కర్మ్మ న కర్త్తవ్యం తద్ ఇమే కుతః కుర్వ్వన్తి? ");
INSERT INTO santel_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","తదా స తేభ్యోఽకథయత్ దాయూద్ తత్సంఙ్గినశ్చ భక్ష్యాభావాత్ క్షుధితాః సన్తో యత్ కర్మ్మ కృతవన్తస్తత్ కిం యుష్మాభి ర్న పఠితమ్? ");
INSERT INTO santel_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","అబియాథర్నామకే మహాయాజకతాం కుర్వ్వతి స కథమీశ్వరస్యావాసం ప్రవిశ్య యే దర్శనీయపూపా యాజకాన్ వినాన్యస్య కస్యాపి న భక్ష్యాస్తానేవ బుభుజే సఙ్గిలోకేభ్యోఽపి దదౌ| ");
INSERT INTO santel_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","సోఽపరమపి జగాద, విశ్రామవారో మనుష్యార్థమేవ నిరూపితోఽస్తి కిన్తు మనుష్యో విశ్రామవారార్థం నైవ| ");
INSERT INTO santel_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","మనుష్యపుత్రో విశ్రామవారస్యాపి ప్రభురాస్తే| ");
INSERT INTO santel_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","అనన్తరం యీశుః పున ర్భజనగృహం ప్రవిష్టస్తస్మిన్ స్థానే శుష్కహస్త ఏకో మానవ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","స విశ్రామవారే తమరోగిణం కరిష్యతి నవేత్యత్ర బహవస్తమ్ అపవదితుం ఛిద్రమపేక్షితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","తదా స తం శుష్కహస్తం మనుష్యం జగాద మధ్యస్థానే త్వముత్తిష్ఠ| ");
INSERT INTO santel_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","తతః పరం స తాన్ పప్రచ్ఛ విశ్రామవారే హితమహితం తథా హి ప్రాణరక్షా వా ప్రాణనాశ ఏషాం మధ్యే కిం కరణీయం ? కిన్తు తే నిఃశబ్దాస్తస్థుః| ");
INSERT INTO santel_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","తదా స తేషామన్తఃకరణానాం కాఠిన్యాద్ధేతో ర్దుఃఖితః క్రోధాత్ చర్తుिదశో దృష్టవాన్ తం మానుషం గదితవాన్ తం హస్తం విస్తారయ, తతస్తేన హస్తే విస్తృతే తద్ధస్తోఽన్యహస్తవద్ అరోగో జాతః| ");
INSERT INTO santel_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","అథ ఫిరూశినః ప్రస్థాయ తం నాశయితుం హేరోదీయైః సహ మన్త్రయితుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","అతఏవ యీశుస్తత్స్థానం పరిత్యజ్య శిష్యైః సహ పునః సాగరసమీపం గతః; ");
INSERT INTO santel_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","తతో గాలీల్యిహూదా-యిరూశాలమ్-ఇదోమ్-యర్దన్నదీపారస్థానేభ్యో లోకసమూహస్తస్య పశ్చాద్ గతః; తదన్యః సోరసీదనోః సమీపవాసిలోకసమూహశ్చ తస్య మహాకర్మ్మణాం వార్త్తం శ్రుత్వా తస్య సన్నిధిమాగతః| ");
INSERT INTO santel_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","తదా లోకసమూహశ్చేత్ తస్యోపరి పతతి ఇత్యాశఙ్క్య స నావమేకాం నికటే స్థాపయితుం శిష్యానాదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","యతోఽనేకమనుష్యాణామారోగ్యకరణాద్ వ్యాధిగ్రస్తాః సర్వ్వే తం స్ప్రష్టుం పరస్పరం బలేన యత్నవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","అపరఞ్చ అపవిత్రభూతాస్తం దృష్ట్వా తచ్చరణయోః పతిత్వా ప్రోచైః ప్రోచుః, త్వమీశ్వరస్య పుత్రః| ");
INSERT INTO santel_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","కిన్తు స తాన్ దృఢమ్ ఆజ్ఞాప్య స్వం పరిచాయితుం నిషిద్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","అనన్తరం స పర్వ్వతమారుహ్య యం యం ప్రతిచ్ఛా తం తమాహూతవాన్ తతస్తే తత్సమీపమాగతాః| ");
INSERT INTO santel_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","తదా స ద్వాదశజనాన్ స్వేన సహ స్థాతుం సుసంవాదప్రచారాయ ప్రేరితా భవితుం ");
INSERT INTO santel_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","సర్వ్వప్రకారవ్యాధీనాం శమనకరణాయ ప్రభావం ప్రాప్తుం భూతాన్ త్యాజయితుఞ్చ నియుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","తేషాం నామానీమాని, శిమోన్ సివదిపుత్రో ");
INSERT INTO santel_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","యాకూబ్ తస్య భ్రాతా యోహన్ చ ఆన్ద్రియః ఫిలిపో బర్థలమయః, ");
INSERT INTO santel_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","మథీ థోమా చ ఆల్ఫీయపుత్రో యాకూబ్ థద్దీయః కినానీయః శిమోన్ యస్తం పరహస్తేష్వర్పయిష్యతి స ఈష్కరియోతీయయిహూదాశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","స శిమోనే పితర ఇత్యుపనామ దదౌ యాకూబ్యోహన్భ్యాం చ బినేరిగిశ్ అర్థతో మేఘనాదపుత్రావిత్యుపనామ దదౌ| ");
INSERT INTO santel_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","అనన్తరం తే నివేశనం గతాః, కిన్తు తత్రాపి పునర్మహాన్ జనసమాగమో ఽభవత్ తస్మాత్తే భోక్తుమప్యవకాశం న ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","తతస్తస్య సుహృల్లోకా ఇమాం వార్త్తాం ప్రాప్య స హతజ్ఞానోభూద్ ఇతి కథాం కథయిత్వా తం ధృత్వానేతుం గతాః| ");
INSERT INTO santel_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","అపరఞ్చ యిరూశాలమ ఆగతా యే యేఽధ్యాపకాస్తే జగదురయం పురుషో భూతపత్యాబిష్టస్తేన భూతపతినా భూతాన్ త్యాజయతి| ");
INSERT INTO santel_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","తతస్తానాహూయ యీశు ర్దృష్టాన్తైః కథాం కథితవాన్ శైతాన్ కథం శైతానం త్యాజయితుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","కిఞ్చన రాజ్యం యది స్వవిరోధేన పృథగ్ భవతి తర్హి తద్ రాజ్యం స్థిరం స్థాతుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","తథా కస్యాపి పరివారో యది పరస్పరం విరోధీ భవతి తర్హి సోపి పరివారః స్థిరం స్థాతుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","తద్వత్ శైతాన్ యది స్వవిపక్షతయా ఉత్తిష్ఠన్ భిన్నో భవతి తర్హి సోపి స్థిరం స్థాతుం న శక్నోతి కిన్తూచ్ఛిన్నో భవతి| ");
INSERT INTO santel_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","అపరఞ్చ ప్రబలం జనం ప్రథమం న బద్ధా కోపి తస్య గృహం ప్రవిశ్య ద్రవ్యాణి లుణ్ఠయితుం న శక్నోతి, తం బద్వ్వైవ తస్య గృహస్య ద్రవ్యాణి లుణ్ఠయితుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","అతోహేతో ర్యుష్మభ్యమహం సత్యం కథయామి మనుష్యాణాం సన్తానా యాని యాని పాపానీశ్వరనిన్దాఞ్చ కుర్వ్వన్తి తేషాం తత్సర్వ్వేషామపరాధానాం క్షమా భవితుం శక్నోతి, ");
INSERT INTO santel_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","కిన్తు యః కశ్చిత్ పవిత్రమాత్మానం నిన్దతి తస్యాపరాధస్య క్షమా కదాపి న భవిష్యతి సోనన్తదణ్డస్యార్హో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","తస్యాపవిత్రభూతోఽస్తి తేషామేతత్కథాహేతోః స ఇత్థం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","అథ తస్య మాతా భ్రాతృగణశ్చాగత్య బహిస్తిష్ఠనతో లోకాన్ ప్రేష్య తమాహూతవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","తతస్తత్సన్నిధౌ సముపవిష్టా లోకాస్తం బభాషిరే పశ్య బహిస్తవ మాతా భ్రాతరశ్చ త్వామ్ అన్విచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","తదా స తాన్ ప్రత్యువాచ మమ మాతా కా భ్రాతరో వా కే? తతః పరం స స్వమీపోపవిష్టాన్ శిష్యాన్ ప్రతి అవలోకనం కృత్వా కథయామాస ");
INSERT INTO santel_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","పశ్యతైతే మమ మాతా భ్రాతరశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","యః కశ్చిద్ ఈశ్వరస్యేష్టాం క్రియాం కరోతి స ఏవ మమ భ్రాతా భగినీ మాతా చ| ");
INSERT INTO santel_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","అనన్తరం స సముద్రతటే పునరుపదేష్టుం ప్రారేభే, తతస్తత్ర బహుజనానాం సమాగమాత్ స సాగరోపరి నౌకామారుహ్య సముపవిష్టః; సర్వ్వే లోకాః సముద్రకూలే తస్థుః| ");
INSERT INTO santel_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","తదా స దృష్టాన్తకథాభి ర్బహూపదిష్టవాన్ ఉపదిశంశ్చ కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","అవధానం కురుత, ఏకో బీజవప్తా బీజాని వప్తుం గతః; ");
INSERT INTO santel_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","వపనకాలే కియన్తి బీజాని మార్గపాశ్వే పతితాని, తత ఆకాశీయపక్షిణ ఏత్య తాని చఖాదుః| ");
INSERT INTO santel_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","కియన్తి బీజాని స్వల్పమృత్తికావత్పాషాణభూమౌ పతితాని తాని మృదోల్పత్వాత్ శీఘ్రమఙ్కురితాని; ");
INSERT INTO santel_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","కిన్తూదితే సూర్య్యే దగ్ధాని తథా మూలానో నాధోగతత్వాత్ శుష్కాణి చ| ");
INSERT INTO santel_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","కియన్తి బీజాని కణ్టకివనమధ్యే పతితాని తతః కణ్టకాని సంవృద్వ్య తాని జగ్రసుస్తాని న చ ఫలితాని| ");
INSERT INTO santel_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","తథా కియన్తి బీజాన్యుత్తమభూమౌ పతితాని తాని సంవృద్వ్య ఫలాన్యుత్పాదితాని కియన్తి బీజాని త్రింశద్గుణాని కియన్తి షష్టిగుణాని కియన్తి శతగుణాని ఫలాని ఫలితవన్తి| ");
INSERT INTO santel_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","అథ స తానవదత్ యస్య శ్రోతుం కర్ణౌ స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","తదనన్తరం నిర్జనసమయే తత్సఙ్గినో ద్వాదశశిష్యాశ్చ తం తద్దృష్టాన్తవాక్యస్యార్థం పప్రచ్ఛుః| ");
INSERT INTO santel_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","తదా స తానుదితవాన్ ఈశ్వరరాజ్యస్య నిగూఢవాక్యం బోద్ధుం యుష్మాకమధికారోఽస్తి; ");
INSERT INTO santel_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","కిన్తు యే వహిర్భూతాః \"తే పశ్యన్తః పశ్యన్తి కిన్తు న జానన్తి, శృణ్వన్తః శృణ్వన్తి కిన్తు న బుధ్యన్తే, చేత్తై ర్మనఃసు కదాపి పరివర్త్తితేషు తేషాం పాపాన్యమోచయిష్యన్త,\" అతోహేతోస్తాన్ ప్రతి దృష్టాన్తైరేవ తాని మయా కథితాని| ");
INSERT INTO santel_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","అథ స కథితవాన్ యూయం కిమేతద్ దృష్టాన్తవాక్యం న బుధ్యధ్వే? తర్హి కథం సర్వ్వాన్ దృష్టాన్తాన భోత్స్యధ్వే? ");
INSERT INTO santel_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","బీజవప్తా వాక్యరూపాణి బీజాని వపతి; ");
INSERT INTO santel_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","తత్ర యే యే లోకా వాక్యం శృణ్వన్తి, కిన్తు శ్రుతమాత్రాత్ శైతాన్ శీఘ్రమాగత్య తేషాం మనఃసూప్తాని తాని వాక్యరూపాణి బీజాన్యపనయతి తఏవ ఉప్తబీజమార్గపార్శ్వేస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","యే జనా వాక్యం శ్రుత్వా సహసా పరమానన్దేన గృహ్లన్తి, కిన్తు హృది స్థైర్య్యాభావాత్ కిఞ్చిత్ కాలమాత్రం తిష్ఠన్తి తత్పశ్చాత్ తద్వాక్యహేతోః ");
INSERT INTO santel_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","కుత్రచిత్ క్లేశే ఉపద్రవే వా సముపస్థితే తదైవ విఘ్నం ప్రాప్నువన్తి తఏవ ఉప్తబీజపాషాణభూమిస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","యే జనాః కథాం శృణ్వన్తి కిన్తు సాంసారికీ చిన్తా ధనభ్రాన్తి ర్విషయలోభశ్చ ఏతే సర్వ్వే ఉపస్థాయ తాం కథాం గ్రసన్తి తతః మా విఫలా భవతి ");
INSERT INTO santel_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","తఏవ ఉప్తబీజసకణ్టకభూమిస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","యే జనా వాక్యం శ్రుత్వా గృహ్లన్తి తేషాం కస్య వా త్రింశద్గుణాని కస్య వా షష్టిగుణాని కస్య వా శతగుణాని ఫలాని భవన్తి తఏవ ఉప్తబీజోర్వ్వరభూమిస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","తదా సోఽపరమపి కథితవాన్ కోపి జనో దీపాధారం పరిత్యజ్య ద్రోణస్యాధః ఖట్వాయా అధే వా స్థాపయితుం దీపమానయతి కిం? ");
INSERT INTO santel_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","అతోహేతో ర్యన్న ప్రకాశయిష్యతే తాదృగ్ లుక్కాయితం కిమపి వస్తు నాస్తి; యద్ వ్యక్తం న భవిష్యతి తాదృశం గుప్తం కిమపి వస్తు నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","యస్య శ్రోతుం కర్ణౌ స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","అపరమపి కథితవాన్ యూయం యద్ యద్ వాక్యం శృణుథ తత్ర సావధానా భవత, యతో యూయం యేన పరిమాణేన పరిమాథ తేనైవ పరిమాణేన యుష్మదర్థమపి పరిమాస్యతే; శ్రోతారో యూయం యుష్మభ్యమధికం దాస్యతే| ");
INSERT INTO santel_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","యస్యాశ్రయే వర్ద్ధతే తస్మై అపరమపి దాస్యతే, కిన్తు యస్యాశ్రయే న వర్ద్ధతే తస్య యత్ కిఞ్చిదస్తి తదపి తస్మాన్ నేష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","అనన్తరం స కథితవాన్ ఏకో లోకః క్షేత్రే బీజాన్యుప్త్వా ");
INSERT INTO santel_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","జాగరణనిద్రాభ్యాం దివానిశం గమయతి, పరన్తు తద్వీజం తస్యాజ్ఞాతరూపేణాఙ్కురయతి వర్ద్ధతే చ; ");
INSERT INTO santel_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","యతోహేతోః ప్రథమతః పత్రాణి తతః పరం కణిశాని తత్పశ్చాత్ కణిశపూర్ణాని శస్యాని భూమిః స్వయముత్పాదయతి; ");
INSERT INTO santel_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","కిన్తు ఫలేషు పక్కేషు శస్యచ్ఛేదనకాలం జ్ఞాత్వా స తత్క్షణం శస్యాని ఛినత్తి, అనేన తుల్యమీశ్వరరాజ్యం| ");
INSERT INTO santel_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","పునః సోఽకథయద్ ఈశ్వరరాజ్యం కేన సమం? కేన వస్తునా సహ వా తదుపమాస్యామి? ");
INSERT INTO santel_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","తత్ సర్షపైకేన తుల్యం యతో మృది వపనకాలే సర్షపబీజం సర్వ్వపృథివీస్థబీజాత్ క్షుద్రం ");
INSERT INTO santel_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","కిన్తు వపనాత్ పరమ్ అఙ్కురయిత్వా సర్వ్వశాకాద్ బృహద్ భవతి, తస్య బృహత్యః శాఖాశ్చ జాయన్తే తతస్తచ్ఛాయాం పక్షిణ ఆశ్రయన్తే| ");
INSERT INTO santel_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ఇత్థం తేషాం బోధానురూపం సోఽనేకదృష్టాన్తైస్తానుపదిష్టవాన్, ");
INSERT INTO santel_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","దృష్టాన్తం వినా కామపి కథాం తేభ్యో న కథితవాన్ పశ్చాన్ నిర్జనే స శిష్యాన్ సర్వ్వదృష్టాన్తార్థం బోధితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","తద్దినస్య సన్ధ్యాయాం స తేభ్యోఽకథయద్ ఆగచ్ఛత వయం పారం యామ| ");
INSERT INTO santel_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","తదా తే లోకాన్ విసృజ్య తమవిలమ్బం గృహీత్వా నౌకయా ప్రతస్థిరే; అపరా అపి నావస్తయా సహ స్థితాః| ");
INSERT INTO santel_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","తతః పరం మహాఝఞ్భ్శగమాత్ నౌ ర్దోలాయమానా తరఙ్గేణ జలైః పూర్ణాభవచ్చ| ");
INSERT INTO santel_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","తదా స నౌకాచశ్చాద్భాగే ఉపధానే శిరో నిధాయ నిద్రిత ఆసీత్ తతస్తే తం జాగరయిత్వా జగదుః, హే ప్రభో, అస్మాకం ప్రాణా యాన్తి కిమత్ర భవతశ్చిన్తా నాస్తి? ");
INSERT INTO santel_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","తదా స ఉత్థాయ వాయుం తర్జితవాన్ సముద్రఞ్చోక్తవాన్ శాన్తః సుస్థిరశ్చ భవ; తతో వాయౌ నివృత్తేఽబ్ధిర్నిస్తరఙ్గోభూత్| ");
INSERT INTO santel_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","తదా స తానువాచ యూయం కుత ఏతాదృక్శఙ్కాకులా భవత? కిం వో విశ్వాసో నాస్తి? ");
INSERT INTO santel_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","తస్మాత్తేఽతీవభీతాః పరస్పరం వక్తుమారేభిరే, అహో వాయుః సిన్ధుశ్చాస్య నిదేశగ్రాహిణౌ కీదృగయం మనుజః| ");
INSERT INTO santel_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","అథ తూ సిన్ధుపారం గత్వా గిదేరీయప్రదేశ ఉపతస్థుః| ");
INSERT INTO santel_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","నౌకాతో నిర్గతమాత్రాద్ అపవిత్రభూతగ్రస్త ఏకః శ్మశానాదేత్య తం సాక్షాచ్ చకార| ");
INSERT INTO santel_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","స శ్మశానేఽవాత్సీత్ కోపి తం శృఙ్ఖలేన బద్వ్వా స్థాపయితుం నాశక్నోత్| ");
INSERT INTO santel_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","జనైర్వారం నిగడైః శృఙ్ఖలైశ్చ స బద్ధోపి శృఙ్ఖలాన్యాకృష్య మోచితవాన్ నిగడాని చ భంక్త్వా ఖణ్డం ఖణ్డం కృతవాన్ కోపి తం వశీకర్త్తుం న శశక| ");
INSERT INTO santel_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","దివానిశం సదా పర్వ్వతం శ్మశానఞ్చ భ్రమిత్వా చీత్శబ్దం కృతవాన్ గ్రావభిశ్చ స్వయం స్వం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","స యీశుం దూరాత్ పశ్యన్నేవ ధావన్ తం ప్రణనామ ఉచైరువంశ్చోవాచ, ");
INSERT INTO santel_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","హే సర్వ్వోపరిస్థేశ్వరపుత్ర యీశో భవతా సహ మే కః సమ్బన్ధః? అహం త్వామీశ్వరేణ శాపయే మాం మా యాతయ| ");
INSERT INTO santel_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","యతో యీశుస్తం కథితవాన్ రే అపవిత్రభూత, అస్మాన్నరాద్ బహిర్నిర్గచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","అథ స తం పృష్టవాన్ కిన్తే నామ? తేన ప్రత్యుక్తం వయమనేకే ఽస్మస్తతోఽస్మన్నామ బాహినీ| ");
INSERT INTO santel_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","తతోస్మాన్ దేశాన్న ప్రేషయేతి తే తం ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","తదానీం పర్వ్వతం నికషా బృహన్ వరాహవ్రజశ్చరన్నాసీత్| ");
INSERT INTO santel_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","తస్మాద్ భూతా వినయేన జగదుః, అముం వరాహవ్రజమ్ ఆశ్రయితుమ్ అస్మాన్ ప్రహిణు| ");
INSERT INTO santel_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","యీశునానుజ్ఞాతాస్తేఽపవిత్రభూతా బహిర్నిర్యాయ వరాహవ్రజం ప్రావిశన్ తతః సర్వ్వే వరాహా వస్తుతస్తు ప్రాయోద్విసహస్రసంఙ్ఖ్యకాః కటకేన మహాజవాద్ ధావన్తః సిన్ధౌ ప్రాణాన్ జహుః| ");
INSERT INTO santel_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","తస్మాద్ వరాహపాలకాః పలాయమానాః పురే గ్రామే చ తద్వార్త్తం కథయాఞ్చక్రుః| తదా లోకా ఘటితం తత్కార్య్యం ద్రష్టుం బహిర్జగ్ముః ");
INSERT INTO santel_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","యీశోః సన్నిధిం గత్వా తం భూతగ్రస్తమ్ అర్థాద్ బాహినీభూతగ్రస్తం నరం సవస్త్రం సచేతనం సముపవిష్టఞ్చ దృृష్ట్వా బిభ్యుః| ");
INSERT INTO santel_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","తతో దృష్టతత్కార్య్యలోకాస్తస్య భూతగ్రస్తనరస్య వరాహవ్రజస్యాపి తాం ధటనాం వర్ణయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","తతస్తే స్వసీమాతో బహిర్గన్తుం యీశుం వినేతుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","అథ తస్య నౌకారోహణకాలే స భూతముక్తో నా యీశునా సహ స్థాతుం ప్రార్థయతే; ");
INSERT INTO santel_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","కిన్తు స తమననుమత్య కథితవాన్ త్వం నిజాత్మీయానాం సమీపం గృహఞ్చ గచ్ఛ ప్రభుస్త్వయి కృపాం కృత్వా యాని కర్మ్మాణి కృతవాన్ తాని తాన్ జ్ఞాపయ| ");
INSERT INTO santel_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","అతః స ప్రస్థాయ యీశునా కృతం తత్సర్వ్వాశ్చర్య్యం కర్మ్మ దికాపలిదేశే ప్రచారయితుం ప్రారబ్ధవాన్ తతః సర్వ్వే లోకా ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","అనన్తరం యీశౌ నావా పునరన్యపార ఉత్తీర్ణే సిన్ధుతటే చ తిష్ఠతి సతి తత్సమీపే బహులోకానాం సమాగమోఽభూత్| ");
INSERT INTO santel_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","అపరం యాయీర్ నామ్నా కశ్చిద్ భజనగృహస్యాధిప ఆగత్య తం దృష్ట్వైవ చరణయోః పతిత్వా బహు నివేద్య కథితవాన్; ");
INSERT INTO santel_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","మమ కన్యా మృతప్రాయాభూద్ అతో భవానేత్య తదారోగ్యాయ తస్యా గాత్రే హస్తమ్ అర్పయతు తేనైవ సా జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","తదా యీశుస్తేన సహ చలితః కిన్తు తత్పశ్చాద్ బహులోకాశ్చలిత్వా తాద్గాత్రే పతితాః| ");
INSERT INTO santel_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","అథ ద్వాదశవర్షాణి ప్రదరరోగేణ ");
INSERT INTO santel_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","శీర్ణా చికిత్సకానాం నానాచికిత్సాభిశ్చ దుఃఖం భుక్తవతీ చ సర్వ్వస్వం వ్యయిత్వాపి నారోగ్యం ప్రాప్తా చ పునరపి పీడితాసీచ్చ ");
INSERT INTO santel_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","యా స్త్రీ సా యీశో ర్వార్త్తాం ప్రాప్య మనసాకథయత్ యద్యహం తస్య వస్త్రమాత్ర స్ప్రష్టుం లభేయం తదా రోగహీనా భవిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","అతోహేతోః సా లోకారణ్యమధ్యే తత్పశ్చాదాగత్య తస్య వస్త్రం పస్పర్శ| ");
INSERT INTO santel_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","తేనైవ తత్క్షణం తస్యా రక్తస్రోతః శుష్కం స్వయం తస్మాద్ రోగాన్ముక్తా ఇత్యపి దేహేఽనుభూతా| ");
INSERT INTO santel_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","అథ స్వస్మాత్ శక్తి ర్నిర్గతా యీశురేతన్మనసా జ్ఞాత్వా లోకనివహం ప్రతి ముఖం వ్యావృత్య పృష్టవాన్ కేన మద్వస్త్రం స్పృష్టం? ");
INSERT INTO santel_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","తతస్తస్య శిష్యా ఊచుః భవతో వపుషి లోకాః సంఘర్షన్తి తద్ దృష్ట్వా కేన మద్వస్త్రం స్పృష్టమితి కుతః కథయతి? ");
INSERT INTO santel_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","కిన్తు కేన తత్ కర్మ్మ కృతం తద్ ద్రష్టుం యీశుశ్చతుర్దిశో దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","తతః సా స్త్రీ భీతా కమ్పితా చ సతీ స్వస్యా రుక్ప్రతిక్రియా జాతేతి జ్ఞాత్వాగత్య తత్సమ్ముఖే పతిత్వా సర్వ్వవృత్తాన్తం సత్యం తస్మై కథయామాస| ");
INSERT INTO santel_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","తదానీం యీశుస్తాం గదితవాన్, హే కన్యే తవ ప్రతీతిస్త్వామ్ అరోగామకరోత్ త్వం క్షేమేణ వ్రజ స్వరోగాన్ముక్తా చ తిష్ఠ| ");
INSERT INTO santel_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ఇతివాక్యవదనకాలే భజనగృహాధిపస్య నివేశనాల్ లోకా ఏత్యాధిపం బభాషిరే తవ కన్యా మృతా తస్మాద్ గురుం పునః కుతః క్లిశ్నాసి? ");
INSERT INTO santel_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","కిన్తు యీశుస్తద్ వాక్యం శ్రుత్వైవ భజనగృహాధిపం గదితవాన్ మా భైషీః కేవలం విశ్వాసిహి| ");
INSERT INTO santel_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","అథ పితరో యాకూబ్ తద్భ్రాతా యోహన్ చ ఏతాన్ వినా కమపి స్వపశ్చాద్ యాతుం నాన్వమన్యత| ");
INSERT INTO santel_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","తస్య భజనగృహాధిపస్య నివేశనసమీపమ్ ఆగత్య కలహం బహురోదనం విలాపఞ్చ కుర్వ్వతో లోకాన్ దదర్శ| ");
INSERT INTO santel_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","తస్మాన్ నివేశనం ప్రవిశ్య ప్రోక్తవాన్ యూయం కుత ఇత్థం కలహం రోదనఞ్చ కురుథ? కన్యా న మృతా నిద్రాతి| ");
INSERT INTO santel_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","తస్మాత్తే తముపజహసుః కిన్తు యీశుః సర్వ్వాన బహిష్కృత్య కన్యాయాః పితరౌ స్వసఙ్గినశ్చ గృహీత్వా యత్ర కన్యాసీత్ తత్ స్థానం ప్రవిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","అథ స తస్యాః కన్యాయా హస్తౌ ధృత్వా తాం బభాషే టాలీథా కూమీ, అర్థతో హే కన్యే త్వముత్తిష్ఠ ఇత్యాజ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","తునైవ తత్క్షణం సా ద్వాదశవర్షవయస్కా కన్యా పోత్థాయ చలితుమారేభే, ఇతః సర్వ్వే మహావిస్మయం గతాః| ");
INSERT INTO santel_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","తత ఏతస్యై కిఞ్చిత్ ఖాద్యం దత్తేతి కథయిత్వా ఏతత్కర్మ్మ కమపి న జ్ఞాపయతేతి దృఢమాదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","అనన్తరం స తత్స్థానాత్ ప్రస్థాయ స్వప్రదేశమాగతః శిష్యాశ్చ తత్పశ్చాద్ గతాః| ");
INSERT INTO santel_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","అథ విశ్రామవారే సతి స భజనగృహే ఉపదేష్టుమారబ్ధవాన్ తతోఽనేకే లోకాస్తత్కథాం శ్రుత్వా విస్మిత్య జగదుః, అస్య మనుజస్య ఈదృశీ ఆశ్చర్య్యక్రియా కస్మాజ్ జాతా? తథా స్వకరాభ్యామ్ ఇత్థమద్భుతం కర్మ్మ కర్త్తాुమ్ ఏతస్మై కథం జ్ఞానం దత్తమ్? ");
INSERT INTO santel_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","కిమయం మరియమః పుత్రస్తజ్ఞా నో? కిమయం యాకూబ్-యోసి-యిహుదా-శిమోనాం భ్రాతా నో? అస్య భగిన్యః కిమిహాస్మాభిః సహ నో? ఇత్థం తే తదర్థే ప్రత్యూహం గతాః| ");
INSERT INTO santel_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","తదా యీశుస్తేభ్యోఽకథయత్ స్వదేశం స్వకుటుమ్బాన్ స్వపరిజనాంశ్చ వినా కుత్రాపి భవిష్యద్వాదీ అసత్కృతో న భవతి| ");
INSERT INTO santel_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","అపరఞ్చ తేషామప్రత్యయాత్ స విస్మితః కియతాం రోగిణాం వపుఃషు హస్తమ్ అర్పయిత్వా కేవలం తేషామారోగ్యకరణాద్ అన్యత్ కిమపి చిత్రకార్య్యం కర్త్తాం న శక్తః| ");
INSERT INTO santel_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","అథ స చతుర్దిక్స్థ గ్రామాన్ భ్రమిత్వా ఉపదిష్టవాన్ ");
INSERT INTO santel_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ద్వాదశశిష్యాన్ ఆహూయ అమేధ్యభూతాన్ వశీకర్త్తాం శక్తిం దత్త్వా తేషాం ద్వౌ ద్వౌ జనో ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","పునరిత్యాదిశద్ యూయమ్ ఏకైకాం యష్టిం వినా వస్త్రసంపుటః పూపః కటిబన్ధే తామ్రఖణ్డఞ్చ ఏషాం కిమపి మా గ్రహ్లీత, ");
INSERT INTO santel_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","మార్గయాత్రాయై పాదేషూపానహౌ దత్త్వా ద్వే ఉత్తరీయే మా పరిధద్వ్వం| ");
INSERT INTO santel_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","అపరమప్యుక్తం తేన యూయం యస్యాం పుర్య్యాం యస్య నివేశనం ప్రవేక్ష్యథ తాం పురీం యావన్న త్యక్ష్యథ తావత్ తన్నివేశనే స్థాస్యథ| ");
INSERT INTO santel_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","తత్ర యది కేపి యుష్మాకమాతిథ్యం న విదధతి యుష్మాకం కథాశ్చ న శృణ్వన్తి తర్హి తత్స్థానాత్ ప్రస్థానసమయే తేషాం విరుద్ధం సాక్ష్యం దాతుం స్వపాదానాస్ఫాల్య రజః సమ్పాతయత; అహం యుష్మాన్ యథార్థం వచ్మి విచారదినే తన్నగరస్యావస్థాతః సిదోమామోరయో ర్నగరయోరవస్థా సహ్యతరా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","అథ తే గత్వా లోకానాం మనఃపరావర్త్తనీః కథా ప్రచారితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ఏవమనేకాన్ భూతాంశ్చ త్యాజితవన్తస్తథా తైలేన మర్ద్దయిత్వా బహూన్ జనానరోగానకార్షుః| ");
INSERT INTO santel_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ఇత్థం తస్య సుఖ్యాతిశ్చతుర్దిశో వ్యాప్తా తదా హేరోద్ రాజా తన్నిశమ్య కథితవాన్, యోహన్ మజ్జకః శ్మశానాద్ ఉత్థిత అతోహేతోస్తేన సర్వ్వా ఏతా అద్భుతక్రియాః ప్రకాశన్తే| ");
INSERT INTO santel_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","అన్యేఽకథయన్ అయమ్ ఏలియః, కేపి కథితవన్త ఏష భవిష్యద్వాదీ యద్వా భవిష్యద్వాదినాం సదృశ ఏకోయమ్| ");
INSERT INTO santel_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","కిన్తు హేరోద్ ఇత్యాకర్ణ్య భాషితవాన్ యస్యాహం శిరశ్ఛిన్నవాన్ స ఏవ యోహనయం స శ్మశానాదుదతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","పూర్వ్వం స్వభ్రాతుః ఫిలిపస్య పత్న్యా ఉద్వాహం కృతవన్తం హేరోదం యోహనవాదీత్ స్వభాతృవధూ ర్న వివాహ్యా| ");
INSERT INTO santel_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","అతః కారణాత్ హేరోద్ లోకం ప్రహిత్య యోహనం ధృత్వా బన్ధనాలయే బద్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","హేరోదియా తస్మై యోహనే ప్రకుప్య తం హన్తుమ్ ఐచ్ఛత్ కిన్తు న శక్తా, ");
INSERT INTO santel_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","యస్మాద్ హేరోద్ తం ధార్మ్మికం సత్పురుషఞ్చ జ్ఞాత్వా సమ్మన్య రక్షితవాన్; తత్కథాం శ్రుత్వా తదనుసారేణ బహూని కర్మ్మాణి కృతవాన్ హృష్టమనాస్తదుపదేశం శ్రుతవాంశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","కిన్తు హేరోద్ యదా స్వజన్మదినే ప్రధానలోకేభ్యః సేనానీభ్యశ్చ గాలీల్ప్రదేశీయశ్రేష్ఠలోకేభ్యశ్చ రాత్రౌ భోజ్యమేకం కృతవాన్ ");
INSERT INTO santel_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","తస్మిన్ శుభదినే హేరోదియాయాః కన్యా సమేత్య తేషాం సమక్షం సంనృత్య హేరోదస్తేన సహోపవిష్టానాఞ్చ తోషమజీజనత్ తతా నృపః కన్యామాహ స్మ మత్తో యద్ యాచసే తదేవ తుభ్యం దాస్యే| ");
INSERT INTO santel_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","శపథం కృత్వాకథయత్ చేద్ రాజ్యార్ద్ధమపి యాచసే తదపి తుభ్యం దాస్యే| ");
INSERT INTO santel_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","తతః సా బహి ర్గత్వా స్వమాతరం పప్రచ్ఛ కిమహం యాచిష్యే? తదా సాకథయత్ యోహనో మజ్జకస్య శిరః| ");
INSERT INTO santel_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","అథ తూర్ణం భూపసమీపమ్ ఏత్య యాచమానావదత్ క్షణేస్మిన్ యోహనో మజ్జకస్య శిరః పాత్రే నిధాయ దేహి, ఏతద్ యాచేఽహం| ");
INSERT INTO santel_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","తస్మాత్ భూపోఽతిదుఃఖితః, తథాపి స్వశపథస్య సహభోజినాఞ్చానురోధాత్ తదనఙ్గీకర్త్తుం న శక్తః| ");
INSERT INTO santel_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","తత్క్షణం రాజా ఘాతకం ప్రేష్య తస్య శిర ఆనేతుమాదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","తతః స కారాగారం గత్వా తచ్ఛిరశ్ఛిత్వా పాత్రే నిధాయానీయ తస్యై కన్యాయై దత్తవాన్ కన్యా చ స్వమాత్రే దదౌ| ");
INSERT INTO santel_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","అననతరం యోహనః శిష్యాస్తద్వార్త్తాం ప్రాప్యాగత్య తస్య కుణపం శ్మశానేఽస్థాపయన్| ");
INSERT INTO santel_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","అథ ప్రేషితా యీశోః సన్నిధౌ మిలితా యద్ యచ్ చక్రుః శిక్షయామాసుశ్చ తత్సర్వ్వవార్త్తాస్తస్మై కథితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","స తానువాచ యూయం విజనస్థానం గత్వా విశ్రామ్యత యతస్తత్సన్నిధౌ బహులోకానాం సమాగమాత్ తే భోక్తుం నావకాశం ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","తతస్తే నావా విజనస్థానం గుప్తం గగ్ముః| ");
INSERT INTO santel_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","తతో లోకనివహస్తేషాం స్థానాన్తరయానం దదర్శ, అనేకే తం పరిచిత్య నానాపురేభ్యః పదైర్వ్రజిత్వా జవేన తైషామగ్రే యీశోః సమీప ఉపతస్థుః| ");
INSERT INTO santel_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","తదా యీశు ర్నావో బహిర్గత్య లోకారణ్యానీం దృష్ట్వా తేషు కరుణాం కృతవాన్ యతస్తేఽరక్షకమేషా ఇవాసన్ తదా స తాన నానాప్రసఙ్గాన్ ఉపదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","అథ దివాన్తే సతి శిష్యా ఏత్య యీశుమూచిరే, ఇదం విజనస్థానం దినఞ్చావసన్నం| ");
INSERT INTO santel_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","లోకానాం కిమపి ఖాద్యం నాస్తి, అతశ్చతుర్దిక్షు గ్రామాన్ గన్తుం భోజ్యద్రవ్యాణి క్రేతుఞ్చ భవాన్ తాన్ విసృజతు| ");
INSERT INTO santel_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","తదా స తానువాచ యూయమేవ తాన్ భోజయత; తతస్తే జగదు ర్వయం గత్వా ద్విశతసంఖ్యకై ర్ముద్రాపాదైః పూపాన్ క్రీత్వా కిం తాన్ భోజయిష్యామః? ");
INSERT INTO santel_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","తదా స తాన్ పృష్ఠవాన్ యుష్మాకం సన్నిధౌ కతి పూపా ఆసతే? గత్వా పశ్యత; తతస్తే దృష్ట్వా తమవదన్ పఞ్చ పూపా ద్వౌ మత్స్యౌ చ సన్తి| ");
INSERT INTO santel_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","తదా స లోకాన్ శస్పోపరి పంక్తిభిరుపవేశయితుమ్ ఆదిష్టవాన్, ");
INSERT INTO santel_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","తతస్తే శతం శతం జనాః పఞ్చాశత్ పఞ్చాశజ్జనాశ్చ పంక్తిభి ర్భువి సముపవివిశుః| ");
INSERT INTO santel_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","అథ స తాన్ పఞ్చపూపాన్ మత్స్యద్వయఞ్చ ధృత్వా స్వర్గం పశ్యన్ ఈశ్వరగుణాన్ అన్వకీర్త్తయత్ తాన్ పూపాన్ భంక్త్వా లోకేభ్యః పరివేషయితుం శిష్యేభ్యో దత్తవాన్ ద్వా మత్స్యౌ చ విభజ్య సర్వ్వేభ్యో దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","తతః సర్వ్వే భుక్త్వాతృప్యన్| ");
INSERT INTO santel_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","అనన్తరం శిష్యా అవశిష్టైః పూపై ర్మత్స్యైశ్చ పూర్ణాన్ ద్వదశ డల్లకాన్ జగృహుః| ");
INSERT INTO santel_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","తే భోక్తారః ప్రాయః పఞ్చ సహస్రాణి పురుషా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","అథ స లోకాన్ విసృజన్నేవ నావమారోఢుం స్వస్మాదగ్రే పారే బైత్సైదాపురం యాతుఞ్చ శ్ష్యిाన్ వాఢమాదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","తదా స సర్వ్వాన్ విసృజ్య ప్రార్థయితుం పర్వ్వతం గతః| ");
INSERT INTO santel_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","తతః సన్ధ్యాయాం సత్యాం నౌః సిన్ధుమధ్య ఉపస్థితా కిన్తు స ఏకాకీ స్థలే స్థితః| ");
INSERT INTO santel_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","అథ సమ్ముఖవాతవహనాత్ శిష్యా నావం వాహయిత్వా పరిశ్రాన్తా ఇతి జ్ఞాత్వా స నిశాచతుర్థయామే సిన్ధూపరి పద్భ్యాం వ్రజన్ తేషాం సమీపమేత్య తేషామగ్రే యాతుమ్ ఉద్యతః| ");
INSERT INTO santel_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","కిన్తు శిష్యాః సిన్ధూపరి తం వ్రజన్తం దృష్ట్వా భూతమనుమాయ రురువుః, ");
INSERT INTO santel_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","యతః సర్వ్వే తం దృష్ట్వా వ్యాకులితాః| అతఏవ యీశుస్తత్క్షణం తైః సహాలప్య కథితవాన్, సుస్థిరా భూత, అయమహం మా భైష్ట| ");
INSERT INTO santel_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","అథ నౌకామారుహ్య తస్మిన్ తేషాం సన్నిధిం గతే వాతో నివృత్తః; తస్మాత్తే మనఃసు విస్మితా ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","యతస్తే మనసాం కాఠిన్యాత్ తత్ పూపీయమ్ ఆశ్చర్య్యం కర్మ్మ న వివిక్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","అథ తే పారం గత్వా గినేషరత్ప్రదేశమేత్య తట ఉపస్థితాః| ");
INSERT INTO santel_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","తేషు నౌకాతో బహిర్గతేషు తత్ప్రదేశీయా లోకాస్తం పరిచిత్య ");
INSERT INTO santel_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","చతుర్దిక్షు ధావన్తో యత్ర యత్ర రోగిణో నరా ఆసన్ తాన్ సర్వ్వాన ఖట్వోపరి నిధాయ యత్ర కుత్రచిత్ తద్వార్త్తాం ప్రాపుః తత్ స్థానమ్ ఆనేతుమ్ ఆరేభిరే| ");
INSERT INTO santel_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","తథా యత్ర యత్ర గ్రామే యత్ర యత్ర పురే యత్ర యత్ర పల్ల్యాఞ్చ తేన ప్రవేశః కృతస్తద్వర్త్మమధ్యే లోకాః పీడితాన్ స్థాపయిత్వా తస్య చేలగ్రన్థిమాత్రం స్ప్రష్టుమ్ తేషామర్థే తదనుజ్ఞాం ప్రార్థయన్తః యావన్తో లోకాః పస్పృశుస్తావన్త ఏవ గదాన్ముక్తాః| ");
INSERT INTO santel_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","అనన్తరం యిరూశాలమ ఆగతాః ఫిరూశినోఽధ్యాపకాశ్చ యీశోః సమీపమ్ ఆగతాః| ");
INSERT INTO santel_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","తే తస్య కియతః శిష్యాన్ అశుచికరైరర్థాద అప్రక్షాలితహస్తై ర్భుఞ్జతో దృష్ట్వా తానదూషయన్| ");
INSERT INTO santel_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","యతః ఫిరూశినః సర్వ్వయిహూదీయాశ్చ ప్రాచాం పరమ్పరాగతవాక్యం సమ్మన్య ప్రతలేన హస్తాన్ అప్రక్షాల్య న భుఞ్జతే| ");
INSERT INTO santel_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ఆపనాదాగత్య మజ్జనం వినా న ఖాదన్తి; తథా పానపాత్రాణాం జలపాత్రాణాం పిత్తలపాత్రాణామ్ ఆసనానాఞ్చ జలే మజ్జనమ్ ఇత్యాదయోన్యేపి బహవస్తేషామాచారాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","తే ఫిరూశినోఽధ్యాపకాశ్చ యీశుం పప్రచ్ఛుః, తవ శిష్యాః ప్రాచాం పరమ్పరాగతవాక్యానుసారేణ నాచరన్తోఽప్రక్షాలితకరైః కుతో భుజంతే? ");
INSERT INTO santel_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","తతః స ప్రత్యువాచ కపటినో యుష్మాన్ ఉద్దిశ్య యిశయియభవిష్యద్వాదీ యుక్తమవాదీత్| యథా స్వకీయైరధరైరేతే సమ్మన్యనతే సదైవ మాం| కిన్తు మత్తో విప్రకర్షే సన్తి తేషాం మనాంసి చ| ");
INSERT INTO santel_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","శిక్షయన్తో బిధీన్ న్నాజ్ఞా భజన్తే మాం ముధైవ తే| ");
INSERT INTO santel_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","యూయం జలపాత్రపానపాత్రాదీని మజ్జయన్తో మనుజపరమ్పరాగతవాక్యం రక్షథ కిన్తు ఈశ్వరాజ్ఞాం లంఘధ్వే; అపరా ఈదృశ్యోనేకాః క్రియా అపి కురుధ్వే| ");
INSERT INTO santel_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","అన్యఞ్చాకథయత్ యూయం స్వపరమ్పరాగతవాక్యస్య రక్షార్థం స్పష్టరూపేణ ఈశ్వరాజ్ఞాం లోపయథ| ");
INSERT INTO santel_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","యతో మూసాద్వారా ప్రోక్తమస్తి స్వపితరౌ సమ్మన్యధ్వం యస్తు మాతరం పితరం వా దుర్వ్వాక్యం వక్తి స నితాన్తం హన్యతాం| ");
INSERT INTO santel_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","కిన్తు మదీయేన యేన ద్రవ్యేణ తవోపకారోభవత్ తత్ కర్బ్బాణమర్థాద్ ఈశ్వరాయ నివేదితమ్ ఇదం వాక్యం యది కోపి పితరం మాతరం వా వక్తి ");
INSERT INTO santel_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","తర్హి యూయం మాతుః పితు ర్వోపకారం కర్త్తాం తం వారయథ| ");
INSERT INTO santel_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ఇత్థం స్వప్రచారితపరమ్పరాగతవాక్యేన యూయమ్ ఈశ్వరాజ్ఞాం ముధా విధద్వ్వే, ఈదృశాన్యన్యాన్యనేకాని కర్మ్మాణి కురుధ్వే| ");
INSERT INTO santel_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","అథ స లోకానాహూయ బభాషే యూయం సర్వ్వే మద్వాక్యం శృణుత బుధ్యధ్వఞ్చ| ");
INSERT INTO santel_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","బాహ్యాదన్తరం ప్రవిశ్య నరమమేధ్యం కర్త్తాం శక్నోతి ఈదృశం కిమపి వస్తు నాస్తి, వరమ్ అన్తరాద్ బహిర్గతం యద్వస్తు తన్మనుజమ్ అమేధ్యం కరోతి| ");
INSERT INTO santel_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","యస్య శ్రోతుం శ్రోత్రే స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","తతః స లోకాన్ హిత్వా గృహమధ్యం ప్రవిష్టస్తదా శిష్యాస్తదృష్టాన్తవాక్యార్థం పప్రచ్ఛుః| ");
INSERT INTO santel_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","తస్మాత్ స తాన్ జగాద యూయమపి కిమేతాదృగబోధాః? కిమపి ద్రవ్యం బాహ్యాదన్తరం ప్రవిశ్య నరమమేధ్యం కర్త్తాం న శక్నోతి కథామిమాం కిం న బుధ్యధ్వే? ");
INSERT INTO santel_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","తత్ తదన్తర్న ప్రవిశతి కిన్తు కుక్షిమధ్యం ప్రవిశతి శేషే సర్వ్వభుక్తవస్తుగ్రాహిణి బహిర్దేశే నిర్యాతి| ");
INSERT INTO santel_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","అపరమప్యవాదీద్ యన్నరాన్నిరేతి తదేవ నరమమేధ్యం కరోతి| ");
INSERT INTO santel_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","యతోఽన్తరాద్ అర్థాన్ మానవానాం మనోభ్యః కుచిన్తా పరస్త్రీవేశ్యాగమనం ");
INSERT INTO santel_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","నరవధశ్చౌర్య్యం లోభో దుష్టతా ప్రవఞ్చనా కాముకతా కుదృష్టిరీశ్వరనిన్దా గర్వ్వస్తమ ఇత్యాదీని నిర్గచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ఏతాని సర్వ్వాణి దురితాన్యన్తరాదేత్య నరమమేధ్యం కుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","అథ స ఉత్థాయ తత్స్థానాత్ సోరసీదోన్పురప్రదేశం జగామ తత్ర కిమపి నివేశనం ప్రవిశ్య సర్వ్వైరజ్ఞాతః స్థాతుం మతిఞ్చక్రే కిన్తు గుప్తః స్థాతుం న శశాక| ");
INSERT INTO santel_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","యతః సురఫైనికీదేశీయయూనానీవంశోద్భవస్త్రియాః కన్యా భూతగ్రస్తాసీత్| సా స్త్రీ తద్వార్త్తాం ప్రాప్య తత్సమీపమాగత్య తచ్చరణయోః పతిత్వా ");
INSERT INTO santel_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","స్వకన్యాతో భూతం నిరాకర్త్తాం తస్మిన్ వినయం కృతవతీ| ");
INSERT INTO santel_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","కిన్తు యీశుస్తామవదత్ ప్రథమం బాలకాస్తృప్యన్తు యతో బాలకానాం ఖాద్యం గృహీత్వా కుక్కురేభ్యో నిక్షేపోఽనుచితః| ");
INSERT INTO santel_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","తదా సా స్త్రీ తమవాదీత్ భోః ప్రభో తత్ సత్యం తథాపి మఞ్చాధఃస్థాః కుక్కురా బాలానాం కరపతితాని ఖాద్యఖణ్డాని ఖాదన్తి| ");
INSERT INTO santel_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","తతః సోఽకథయద్ ఏతత్కథాహేతోః సకుశలా యాహి తవ కన్యాం త్యక్త్వా భూతో గతః| ");
INSERT INTO santel_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","అథ సా స్త్రీ గృహం గత్వా కన్యాం భూతత్యక్తాం శయ్యాస్థితాం దదర్శ| ");
INSERT INTO santel_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","పునశ్చ స సోరసీదోన్పురప్రదేశాత్ ప్రస్థాయ దికాపలిదేశస్య ప్రాన్తరభాగేన గాలీల్జలధేః సమీపం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","తదా లోకైరేకం బధిరం కద్వదఞ్చ నరం తన్నికటమానీయ తస్య గాత్రే హస్తమర్పయితుం వినయః కృతః| ");
INSERT INTO santel_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","తతో యీశు ర్లోకారణ్యాత్ తం నిర్జనమానీయ తస్య కర్ణయోఙ్గులీ ర్దదౌ నిష్ఠీవం దత్త్వా చ తజ్జిహ్వాం పస్పర్శ| ");
INSERT INTO santel_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","అనన్తరం స్వర్గం నిరీక్ష్య దీర్ఘం నిశ్వస్య తమవదత్ ఇతఫతః అర్థాన్ ముక్తో భూయాత్| ");
INSERT INTO santel_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","తతస్తత్క్షణం తస్య కర్ణౌ ముక్తౌ జిహ్వాయాశ్చ జాడ్యాపగమాత్ స సుస్పష్టవాక్యమకథయత్| ");
INSERT INTO santel_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","అథ స తాన్ వాఢమిత్యాదిదేశ యూయమిమాం కథాం కస్మైచిదపి మా కథయత, కిన్తు స యతి న్యషేధత్ తే తతి బాహుల్యేన ప్రాచారయన్; ");
INSERT INTO santel_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","తేఽతిచమత్కృత్య పరస్పరం కథయామాసుః స బధిరాయ శ్రవణశక్తిం మూకాయ చ కథనశక్తిం దత్త్వా సర్వ్వం కర్మ్మోత్తమరూపేణ చకార| ");
INSERT INTO santel_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","తదా తత్సమీపం బహవో లోకా ఆయాతా అతస్తేషాం భోజ్యద్రవ్యాభావాద్ యీశుః శిష్యానాహూయ జగాద,| ");
INSERT INTO santel_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","లోకనివహే మమ కృపా జాయతే తే దినత్రయం మయా సార్ద్ధం సన్తి తేషాం భోజ్యం కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","తేషాం మధ్యేఽనేకే దూరాద్ ఆగతాః, అభుక్తేషు తేషు మయా స్వగృహమభిప్రహితేషు తే పథి క్లమిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","శిష్యా అవాదిషుః, ఏతావతో లోకాన్ తర్పయితుమ్ అత్ర ప్రన్తరే పూపాన్ ప్రాప్తుం కేన శక్యతే? ");
INSERT INTO santel_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","తతః స తాన్ పప్రచ్ఛ యుష్మాకం కతి పూపాః సన్తి? తేఽకథయన్ సప్త| ");
INSERT INTO santel_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","తతః స తాల్లోకాన్ భువి సముపవేష్టుమ్ ఆదిశ్య తాన్ సప్త పూపాన్ ధృత్వా ఈశ్వరగుణాన్ అనుకీర్త్తయామాస, భంక్త్వా పరివేషయితుం శిష్యాన్ ప్రతి దదౌ, తతస్తే లోకేభ్యః పరివేషయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","తథా తేషాం సమీపే యే క్షుద్రమత్స్యా ఆసన్ తానప్యాదాయ ఈశ్వరగుణాన్ సంకీర్త్య పరివేషయితుమ్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","తతో లోకా భుక్త్వా తృప్తిం గతా అవశిష్టఖాద్యైః పూర్ణాః సప్తడల్లకా గృహీతాశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ఏతే భోక్తారః ప్రాయశ్చతుః సహస్రపురుషా ఆసన్ తతః స తాన్ విససర్జ| ");
INSERT INTO santel_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","అథ స శిష్యః సహ నావమారుహ్య దల్మానూథాసీమామాగతః| ");
INSERT INTO santel_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","తతః పరం ఫిరూశిన ఆగత్య తేన సహ వివదమానాస్తస్య పరీక్షార్థమ్ ఆకాశీయచిహ్నం ద్రష్టుం యాచితవన్తః| ");
INSERT INTO santel_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","తదా సోఽన్తర్దీర్ఘం నిశ్వస్యాకథయత్, ఏతే విద్యమాననరాః కుతశ్చిన్హం మృగయన్తే? యుష్మానహం యథార్థం బ్రవీమి లోకానేతాన్ కిమపి చిహ్నం న దర్శయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","అథ తాన్ హిత్వా పున ర్నావమ్ ఆరుహ్య పారమగాత్| ");
INSERT INTO santel_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ఏతర్హి శిష్యైః పూపేషు విస్మృతేషు నావి తేషాం సన్నిధౌ పూప ఏకఏవ స్థితః| ");
INSERT INTO santel_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","తదానీం యీశుస్తాన్ ఆదిష్టవాన్ ఫిరూశినాం హేరోదశ్చ కిణ్వం ప్రతి సతర్కాః సావధానాశ్చ భవత| ");
INSERT INTO santel_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","తతస్తేఽన్యోన్యం వివేచనం కర్తుమ్ ఆరేభిరే, అస్మాకం సన్నిధౌ పూపో నాస్తీతి హేతోరిదం కథయతి| ");
INSERT INTO santel_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","తద్ బుద్వ్వా యీశుస్తేభ్యోఽకథయత్ యుష్మాకం స్థానే పూపాభావాత్ కుత ఇత్థం వితర్కయథ? యూయం కిమద్యాపి కిమపి న జానీథ? బోద్ధుఞ్చ న శక్నుథ? యావదద్య కిం యుష్మాకం మనాంసి కఠినాని సన్తి? ");
INSERT INTO santel_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","సత్సు నేత్రేషు కిం న పశ్యథ? సత్సు కర్ణేషు కిం న శృణుథ? న స్మరథ చ? ");
INSERT INTO santel_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","యదాహం పఞ్చపూపాన్ పఞ్చసహస్రాణాం పురుషాణాం మధ్యే భంక్త్వా దత్తవాన్ తదానీం యూయమ్ అవశిష్టపూపైః పూర్ణాన్ కతి డల్లకాన్ గృహీతవన్తః? తేఽకథయన్ ద్వాదశడల్లకాన్| ");
INSERT INTO santel_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","అపరఞ్చ యదా చతుఃసహస్రాణాం పురుషాణాం మధ్యే పూపాన్ భంక్త్వాదదాం తదా యూయమ్ అతిరిక్తపూపానాం కతి డల్లకాన్ గృహీతవన్తః? తే కథయామాసుః సప్తడల్లకాన్| ");
INSERT INTO santel_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","తదా స కథితవాన్ తర్హి యూయమ్ అధునాపి కుతో బోద్వ్వుం న శక్నుథ? ");
INSERT INTO santel_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","అనన్తరం తస్మిన్ బైత్సైదానగరే ప్రాప్తే లోకా అన్ధమేకం నరం తత్సమీపమానీయ తం స్ప్రష్టుం తం ప్రార్థయాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","తదా తస్యాన్ధస్య కరౌ గృహీత్వా నగరాద్ బహిర్దేశం తం నీతవాన్; తన్నేత్రే నిష్ఠీవం దత్త్వా తద్గాత్రే హస్తావర్పయిత్వా తం పప్రచ్ఛ, కిమపి పశ్యసి? ");
INSERT INTO santel_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","స నేత్రే ఉన్మీల్య జగాద, వృక్షవత్ మనుజాన్ గచ్ఛతో నిరీక్షే| ");
INSERT INTO santel_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","తతో యీశుః పునస్తస్య నయనయో ర్హస్తావర్పయిత్వా తస్య నేత్రే ఉన్మీలయామాస; తస్మాత్ స స్వస్థో భూత్వా స్పష్టరూపం సర్వ్వలోకాన్ దదర్శ| ");
INSERT INTO santel_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","తతః పరం త్వం గ్రామం మా గచ్ఛ గ్రామస్థం కమపి చ కిమప్యనుక్త్వా నిజగృహం యాహీత్యాదిశ్య యీశుస్తం నిజగృహం ప్రహితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","అనన్తరం శిష్యైః సహితో యీశుః కైసరీయాఫిలిపిపురం జగామ, పథి గచ్ఛన్ తానపృచ్ఛత్ కోఽహమ్ అత్ర లోకాః కిం వదన్తి? ");
INSERT INTO santel_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","తే ప్రత్యూచుః త్వాం యోహనం మజ్జకం వదన్తి కిన్తు కేపి కేపి ఏలియం వదన్తి; అపరే కేపి కేపి భవిష్యద్వాదినామ్ ఏకో జన ఇతి వదన్తి| ");
INSERT INTO santel_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","అథ స తానపృచ్ఛత్ కిన్తు కోహమ్? ఇత్యత్ర యూయం కిం వదథ? తదా పితరః ప్రత్యవదత్ భవాన్ అభిషిక్తస్త్రాతా| ");
INSERT INTO santel_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","తతః స తాన్ గాఢమాదిశద్ యూయం మమ కథా కస్మైచిదపి మా కథయత| ");
INSERT INTO santel_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","మనుష్యపుత్రేణావశ్యం బహవో యాతనా భోక్తవ్యాః ప్రాచీనలోకైః ప్రధానయాజకైరధ్యాపకైశ్చ స నిన్దితః సన్ ఘాతయిష్యతే తృతీయదినే ఉత్థాస్యతి చ, యీశుః శిష్యానుపదేష్టుమారభ్య కథామిమాం స్పష్టమాచష్ట| ");
INSERT INTO santel_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","తస్మాత్ పితరస్తస్య హస్తౌ ధృత్వా తం తర్జ్జితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","కిన్తు స ముఖం పరావర్త్య శిష్యగణం నిరీక్ష్య పితరం తర్జయిత్వావాదీద్ దూరీభవ విఘ్నకారిన్ ఈశ్వరీయకార్య్యాదపి మనుష్యకార్య్యం తుభ్యం రోచతతరాం| ");
INSERT INTO santel_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","అథ స లోకాన్ శిష్యాంశ్చాహూయ జగాద యః కశ్చిన్ మామనుగన్తుమ్ ఇచ్ఛతి స ఆత్మానం దామ్యతు, స్వక్రుశం గృహీత్వా మత్పశ్చాద్ ఆయాతు| ");
INSERT INTO santel_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","యతో యః కశ్చిత్ స్వప్రాణం రక్షితుమిచ్ఛతి స తం హారయిష్యతి, కిన్తు యః కశ్చిన్ మదర్థం సుసంవాదార్థఞ్చ ప్రాణం హారయతి స తం రక్షిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","అపరఞ్చ మనుజః సర్వ్వం జగత్ ప్రాప్య యది స్వప్రాణం హారయతి తర్హి తస్య కో లాభః? ");
INSERT INTO santel_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","నరః స్వప్రాణవినిమయేన కిం దాతుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ఏతేషాం వ్యభిచారిణాం పాపినాఞ్చ లోకానాం సాక్షాద్ యది కోపి మాం మత్కథాఞ్చ లజ్జాస్పదం జానాతి తర్హి మనుజపుత్రో యదా ధర్మ్మదూతైః సహ పితుః ప్రభావేణాగమిష్యతి తదా సోపి తం లజ్జాస్పదం జ్ఞాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","అథ స తానవాదీత్ యుష్మభ్యమహం యథార్థం కథయామి, ఈశ్వరరాజ్యం పరాక్రమేణోపస్థితం న దృష్ట్వా మృత్యుం నాస్వాదిష్యన్తే, అత్ర దణ్డాయమానానాం మధ్యేపి తాదృశా లోకాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","అథ షడ్దినేభ్యః పరం యీశుః పితరం యాకూబం యోహనఞ్చ గృహీత్వా గిరేరుచ్చస్య నిర్జనస్థానం గత్వా తేషాం ప్రత్యక్షే మూర్త్యన్తరం దధార| ");
INSERT INTO santel_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","తతస్తస్య పరిధేయమ్ ఈదృశమ్ ఉజ్జ్వలహిమపాణడరం జాతం యద్ జగతి కోపి రజకో న తాదృక్ పాణడరం కర్త్తాం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","అపరఞ్చ ఏలియో మూసాశ్చ తేభ్యో దర్శనం దత్త్వా యీశునా సహ కథనం కర్త్తుమారేభాతే| ");
INSERT INTO santel_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","తదా పితరో యీశుమవాదీత్ హే గురోఽస్మాకమత్ర స్థితిరుత్తమా, తతఏవ వయం త్వత్కృతే ఏకాం మూసాకృతే ఏకామ్ ఏలియకృతే చైకాం, ఏతాస్తిస్రః కుటీ ర్నిర్మ్మామ| ");
INSERT INTO santel_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","కిన్తు స యదుక్తవాన్ తత్ స్వయం న బుబుధే తతః సర్వ్వే బిభయాఞ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ఏతర్హి పయోదస్తాన్ ఛాదయామాస, మమయాం ప్రియః పుత్రః కథాసు తస్య మనాంసి నివేశయతేతి నభోవాణీ తన్మేద్యాన్నిర్యయౌ| ");
INSERT INTO santel_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","అథ హఠాత్తే చతుర్దిశో దృష్ట్వా యీశుం వినా స్వైః సహితం కమపి న దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","తతః పరం గిరేరవరోహణకాలే స తాన్ గాఢమ్ దూత్యాదిదేశ యావన్నరసూనోః శ్మశానాదుత్థానం న భవతి, తావత్ దర్శనస్యాస్య వార్త్తా యుష్మాభిః కస్మైచిదపి న వక్తవ్యా| ");
INSERT INTO santel_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","తదా శ్మశానాదుత్థానస్య కోభిప్రాయ ఇతి విచార్య్య తే తద్వాక్యం స్వేషు గోపాయాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","అథ తే యీశుం పప్రచ్ఛుః ప్రథమత ఏలియేనాగన్తవ్యమ్ ఇతి వాక్యం కుత ఉపాధ్యాయా ఆహుః? ");
INSERT INTO santel_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","తదా స ప్రత్యువాచ , ఏలియః ప్రథమమేత్య సర్వ్వకార్య్యాణి సాధయిష్యతి; నరపుత్రే చ లిపి ర్యథాస్తే తథైవ సోపి బహుదుఃఖం ప్రాప్యావజ్ఞాస్యతే| ");
INSERT INTO santel_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","కిన్త్వహం యుష్మాన్ వదామి , ఏలియార్థే లిపి ర్యథాస్తే తథైవ స ఏత్య యయౌ, లోకా: స్వేచ్ఛానురూపం తమభివ్యవహరన్తి స్మ| ");
INSERT INTO santel_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","అనన్తరం స శిష్యసమీపమేత్య తేషాం చతుఃపార్శ్వే తైః సహ బహుజనాన్ వివదమానాన్ అధ్యాపకాంశ్చ దృష్టవాన్; ");
INSERT INTO santel_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","కిన్తు సర్వ్వలోకాస్తం దృష్ట్వైవ చమత్కృత్య తదాసన్నం ధావన్తస్తం ప్రణేముః| ");
INSERT INTO santel_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","తదా యీశురధ్యాపకానప్రాక్షీద్ ఏతైః సహ యూయం కిం వివదధ్వే? ");
INSERT INTO santel_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","తతో లోకానాం కశ్చిదేకః ప్రత్యవాదీత్ హే గురో మమ సూనుం మూకం భూతధృతఞ్చ భవదాసన్నమ్ ఆనయం| ");
INSERT INTO santel_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","యదాసౌ భూతస్తమాక్రమతే తదైవ పాతసతి తథా స ఫేణాయతే, దన్తైర్దన్తాన్ ఘర్షతి క్షీణో భవతి చ; తతో హేతోస్తం భూతం త్యాజయితుం భవచ్ఛిష్యాన్ నివేదితవాన్ కిన్తు తే న శేకుః| ");
INSERT INTO santel_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","తదా స తమవాదీత్, రే అవిశ్వాసినః సన్తానా యుష్మాభిః సహ కతి కాలానహం స్థాస్యామి? అపరాన్ కతి కాలాన్ వా వ ఆచారాన్ సహిష్యే? తం మదాసన్నమానయత| ");
INSERT INTO santel_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","తతస్తత్సన్నిధిం స ఆనీయత కిన్తు తం దృష్ట్వైవ భూతో బాలకం ధృతవాన్; స చ భూమౌ పతిత్వా ఫేణాయమానో లులోఠ| ");
INSERT INTO santel_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","తదా స తత్పితరం పప్రచ్ఛ, అస్యేదృశీ దశా కతి దినాని భూతా? తతః సోవాదీత్ బాల్యకాలాత్| ");
INSERT INTO santel_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","భూతోయం తం నాశయితుం బహువారాన్ వహ్నౌ జలే చ న్యక్షిపత్ కిన్తు యది భవాన కిమపి కర్త్తాం శక్నోతి తర్హి దయాం కృత్వాస్మాన్ ఉపకరోతు| ");
INSERT INTO santel_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","తదా యీశుస్తమవదత్ యది ప్రత్యేతుం శక్నోషి తర్హి ప్రత్యయినే జనాయ సర్వ్వం సాధ్యమ్| ");
INSERT INTO santel_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","తతస్తత్క్షణం తద్బాలకస్య పితా ప్రోచ్చై రూవన్ సాశ్రునేత్రః ప్రోవాచ, ప్రభో ప్రత్యేమి మమాప్రత్యయం ప్రతికురు| ");
INSERT INTO santel_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","అథ యీశు ర్లోకసఙ్ఘం ధావిత్వాయాన్తం దృష్ట్వా తమపూతభూతం తర్జయిత్వా జగాద, రే బధిర మూక భూత త్వమేతస్మాద్ బహిర్భవ పునః కదాపి మాశ్రయైనం త్వామహమ్ ఇత్యాదిశామి| ");
INSERT INTO santel_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","తదా స భూతశ్చీత్శబ్దం కృత్వా తమాపీడ్య బహిర్జజామ, తతో బాలకో మృతకల్పో బభూవ తస్మాదయం మృతఇత్యనేకే కథయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","కిన్తు కరం ధృత్వా యీశునోత్థాపితః స ఉత్తస్థౌ| ");
INSERT INTO santel_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","అథ యీశౌ గృహం ప్రవిష్టే శిష్యా గుప్తం తం పప్రచ్ఛుః, వయమేనం భూతం త్యాజయితుం కుతో న శక్తాః? ");
INSERT INTO santel_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","స ఉవాచ, ప్రార్థనోపవాసౌ వినా కేనాప్యన్యేన కర్మ్మణా భూతమీదృశం త్యాజయితుం న శక్యం| ");
INSERT INTO santel_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","అనన్తరం స తత్స్థానాదిత్వా గాలీల్మధ్యేన యయౌ, కిన్తు తత్ కోపి జానీయాదితి స నైచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","అపరఞ్చ స శిష్యానుపదిశన్ బభాషే, నరపుత్రో నరహస్తేషు సమర్పయిష్యతే తే చ తం హనిష్యన్తి తైస్తస్మిన్ హతే తృతీయదినే స ఉత్థాస్యతీతి| ");
INSERT INTO santel_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","కిన్తు తత్కథాం తే నాబుధ్యన్త ప్రష్టుఞ్చ బిభ్యః| ");
INSERT INTO santel_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","అథ యీశుః కఫర్నాహూమ్పురమాగత్య మధ్యేగృహఞ్చేత్య తానపృచ్ఛద్ వర్త్మమధ్యే యూయమన్యోన్యం కిం వివదధ్వే స్మ? ");
INSERT INTO santel_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","కిన్తు తే నిరుత్తరాస్తస్థు ర్యస్మాత్తేషాం కో ముఖ్య ఇతి వర్త్మాని తేఽన్యోన్యం వ్యవదన్త| ");
INSERT INTO santel_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","తతః స ఉపవిశ్య ద్వాదశశిష్యాన్ ఆహూయ బభాషే యః కశ్చిత్ ముఖ్యో భవితుమిచ్ఛతి స సర్వ్వేభ్యో గౌణః సర్వ్వేషాం సేవకశ్చ భవతు| ");
INSERT INTO santel_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","తదా స బాలకమేకం గృహీత్వా మధ్యే సముపావేశయత్ తతస్తం క్రోడే కృత్వా తానవాదాత్ ");
INSERT INTO santel_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","యః కశ్చిదీదృశస్య కస్యాపి బాలస్యాతిథ్యం కరోతి స మమాతిథ్యం కరోతి; యః కశ్చిన్మమాతిథ్యం కరోతి స కేవలమ్ మమాతిథ్యం కరోతి తన్న మత్ప్రేరకస్యాప్యాతిథ్యం కరోతి| ");
INSERT INTO santel_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","అథ యోహన్ తమబ్రవీత్ హే గురో, అస్మాకమననుగామినమ్ ఏకం త్వాన్నామ్నా భూతాన్ త్యాజయన్తం వయం దృష్టవన్తః, అస్మాకమపశ్చాద్గామిత్వాచ్చ తం న్యషేధామ| ");
INSERT INTO santel_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","కిన్తు యీశురవదత్ తం మా నిషేధత్, యతో యః కశ్చిన్ మన్నామ్నా చిత్రం కర్మ్మ కరోతి స సహసా మాం నిన్దితుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","తథా యః కశ్చిద్ యుష్మాకం విపక్షతాం న కరోతి స యుష్మాకమేవ సపక్షః| ");
INSERT INTO santel_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","యః కశ్చిద్ యుష్మాన్ ఖ్రీష్టశిష్యాన్ జ్ఞాత్వా మన్నామ్నా కంసైకేన పానీయం పాతుం దదాతి, యుష్మానహం యథార్థం వచ్మి, స ఫలేన వఞ్చితో న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","కిన్తు యది కశ్చిన్ మయి విశ్వాసినామేషాం క్షుద్రప్రాణినామ్ ఏకస్యాపి విఘ్నం జనయతి, తర్హి తస్యైతత్కర్మ్మ కరణాత్ కణ్ఠబద్ధపేషణీకస్య తస్య సాగరాగాధజల మజ్జనం భద్రం| ");
INSERT INTO santel_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","అతః స్వకరో యది త్వాం బాధతే తర్హి తం ఛిన్ధి; ");
INSERT INTO santel_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","యస్మాత్ యత్ర కీటా న మ్రియన్తే వహ్నిశ్చ న నిర్వ్వాతి, తస్మిన్ అనిర్వ్వాణానలనరకే కరద్వయవస్తవ గమనాత్ కరహీనస్య స్వర్గప్రవేశస్తవ క్షేమం| ");
INSERT INTO santel_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","యది తవ పాదో విఘ్నం జనయతి తర్హి తం ఛిన్ధి, ");
INSERT INTO santel_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","యతో యత్ర కీటా న మ్రియన్తే వహ్నిశ్చ న నిర్వ్వాతి, తస్మిన్ ఽనిర్వ్వాణవహ్నౌ నరకే ద్విపాదవతస్తవ నిక్షేపాత్ పాదహీనస్య స్వర్గప్రవేశస్తవ క్షేమం| ");
INSERT INTO santel_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","స్వనేత్రం యది త్వాం బాధతే తర్హి తదప్యుత్పాటయ, యతో యత్ర కీటా న మ్రియన్తే వహ్నిశ్చ న నిర్వ్వాతి, ");
INSERT INTO santel_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","తస్మిన ఽనిర్వ్వాణవహ్నౌ నరకే ద్వినేత్రస్య తవ నిక్షేపాద్ ఏకనేత్రవత ఈశ్వరరాజ్యే ప్రవేశస్తవ క్షేమం| ");
INSERT INTO santel_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","యథా సర్వ్వో బలి ర్లవణాక్తః క్రియతే తథా సర్వ్వో జనో వహ్నిరూపేణ లవణాక్తః కారిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","లవణం భద్రం కిన్తు యది లవణే స్వాదుతా న తిష్ఠతి, తర్హి కథమ్ ఆస్వాద్యుక్తం కరిష్యథ? యూయం లవణయుక్తా భవత పరస్పరం ప్రేమ కురుత| ");
INSERT INTO santel_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","అనన్తరం స తత్స్థానాత్ ప్రస్థాయ యర్ద్దననద్యాః పారే యిహూదాప్రదేశ ఉపస్థితవాన్, తత్ర తదన్తికే లోకానాం సమాగమే జాతే స నిజరీత్యనుసారేణ పునస్తాన్ ఉపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","తదా ఫిరూశినస్తత్సమీపమ్ ఏత్య తం పరీక్షితుం పప్రచ్ఛః స్వజాయా మనుజానాం త్యజ్యా న వేతి? ");
INSERT INTO santel_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","తతః స ప్రత్యవాదీత్, అత్ర కార్య్యే మూసా యుష్మాన్ ప్రతి కిమాజ్ఞాపయత్? ");
INSERT INTO santel_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","త ఊచుః త్యాగపత్రం లేఖితుం స్వపత్నీం త్యక్తుఞ్చ మూసాఽనుమన్యతే| ");
INSERT INTO santel_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","తదా యీశుః ప్రత్యువాచ, యుష్మాకం మనసాం కాఠిన్యాద్ధేతో ర్మూసా నిదేశమిమమ్ అలిఖత్| ");
INSERT INTO santel_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","కిన్తు సృష్టేరాదౌ ఈశ్వరో నరాన్ పుంరూపేణ స్త్రీరూపేణ చ ససర్జ| ");
INSERT INTO santel_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"తతః కారణాత్ పుమాన్ పితరం మాతరఞ్చ త్యక్త్వా స్వజాయాయామ్ ఆసక్తో భవిష్యతి, ");
INSERT INTO santel_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","తౌ ద్వావ్ ఏకాఙ్గౌ భవిష్యతః| \" తస్మాత్ తత్కాలమారభ్య తౌ న ద్వావ్ ఏకాఙ్గౌ| ");
INSERT INTO santel_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","అతః కారణాద్ ఈశ్వరో యదయోజయత్ కోపి నరస్తన్న వియేజయేత్| ");
INSERT INTO santel_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","అథ యీశు ర్గృహం ప్రవిష్టస్తదా శిష్యాః పునస్తత్కథాం తం పప్రచ్ఛుః| ");
INSERT INTO santel_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","తతః సోవదత్ కశ్చిద్ యది స్వభార్య్యాం త్యక్తవాన్యామ్ ఉద్వహతి తర్హి స స్వభార్య్యాయాః ప్రాతికూల్యేన వ్యభిచారీ భవతి| ");
INSERT INTO santel_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","కాచిన్నారీ యది స్వపతిం హిత్వాన్యపుంసా వివాహితా భవతి తర్హి సాపి వ్యభిచారిణీ భవతి| ");
INSERT INTO santel_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","అథ స యథా శిశూన్ స్పృశేత్, తదర్థం లోకైస్తదన్తికం శిశవ ఆనీయన్త, కిన్తు శిష్యాస్తానానీతవతస్తర్జయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","యీశుస్తద్ దృష్ట్వా క్రుధ్యన్ జగాద, మన్నికటమ్ ఆగన్తుం శిశూన్ మా వారయత, యత ఏతాదృశా ఈశ్వరరాజ్యాధికారిణః| ");
INSERT INTO santel_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","యుష్మానహం యథార్థం వచ్మి, యః కశ్చిత్ శిశువద్ భూత్వా రాజ్యమీశ్వరస్య న గృహ్లీయాత్ స కదాపి తద్రాజ్యం ప్రవేష్టుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","అననతరం స శిశూనఙ్కే నిధాయ తేషాం గాత్రేషు హస్తౌ దత్త్వాశిషం బభాషే| ");
INSERT INTO santel_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","అథ స వర్త్మనా యాతి, ఏతర్హి జన ఏకో ధావన్ ఆగత్య తత్సమ్ముఖే జానునీ పాతయిత్వా పృష్టవాన్, భోః పరమగురో, అనన్తాయుః ప్రాప్తయే మయా కిం కర్త్తవ్యం? ");
INSERT INTO santel_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","తదా యీశురువాచ, మాం పరమం కుతో వదసి? వినేశ్వరం కోపి పరమో న భవతి| ");
INSERT INTO santel_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","పరస్త్రీం నాభిగచ్ఛ; నరం మా ఘాతయ; స్తేయం మా కురు; మృషాసాక్ష్యం మా దేహి; హింసాఞ్చ మా కురు; పితరౌ సమ్మన్యస్వ; నిదేశా ఏతే త్వయా జ్ఞాతాః| ");
INSERT INTO santel_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","తతస్తన ప్రత్యుక్తం, హే గురో బాల్యకాలాదహం సర్వ్వానేతాన్ ఆచరామి| ");
INSERT INTO santel_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","తదా యీశుస్తం విలోక్య స్నేహేన బభాషే, తవైకస్యాభావ ఆస్తే; త్వం గత్వా సర్వ్వస్వం విక్రీయ దరిద్రేభ్యో విశ్రాణయ, తతః స్వర్గే ధనం ప్రాప్స్యసి; తతః పరమ్ ఏత్య క్రుశం వహన్ మదనువర్త్తీ భవ| ");
INSERT INTO santel_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","కిన్తు తస్య బహుసమ్పద్విద్యమానత్వాత్ స ఇమాం కథామాకర్ణ్య విషణో దుఃఖితశ్చ సన్ జగామ| ");
INSERT INTO santel_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","అథ యీశుశ్చతుర్దిశో నిరీక్ష్య శిష్యాన్ అవాదీత్, ధనిలోకానామ్ ఈశ్వరరాజ్యప్రవేశః కీదృగ్ దుష్కరః| ");
INSERT INTO santel_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","తస్య కథాతః శిష్యాశ్చమచ్చక్రుః, కిన్తు స పునరవదత్, హే బాలకా యే ధనే విశ్వసన్తి తేషామ్ ఈశ్వరరాజ్యప్రవేశః కీదృగ్ దుష్కరః| ");
INSERT INTO santel_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ఈశ్వరరాజ్యే ధనినాం ప్రవేశాత్ సూచిరన్ధ్రేణ మహాఙ్గస్య గమనాగమనం సుకరం| ");
INSERT INTO santel_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","తదా శిష్యా అతీవ విస్మితాః పరస్పరం ప్రోచుః, తర్హి కః పరిత్రాణం ప్రాప్తుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","తతో యీశుస్తాన్ విలోక్య బభాషే, తన్ నరస్యాసాధ్యం కిన్తు నేశ్వరస్య, యతో హేతోరీశ్వరస్య సర్వ్వం సాధ్యమ్| ");
INSERT INTO santel_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","తదా పితర ఉవాచ, పశ్య వయం సర్వ్వం పరిత్యజ్య భవతోనుగామినో జాతాః| ");
INSERT INTO santel_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","తతో యీశుః ప్రత్యవదత్, యుష్మానహం యథార్థం వదామి, మదర్థం సుసంవాదార్థం వా యో జనః సదనం భ్రాతరం భగినీం పితరం మాతరం జాయాం సన్తానాన్ భూమి వా త్యక్త్వా ");
INSERT INTO santel_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","గృహభ్రాతృభగినీపితృమాతృపత్నీసన్తానభూమీనామిహ శతగుణాన్ ప్రేత్యానన్తాయుశ్చ న ప్రాప్నోతి తాదృశః కోపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","కిన్త్వగ్రీయా అనేకే లోకాః శేషాః, శేషీయా అనేకే లోకాశ్చాగ్రా భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","అథ యిరూశాలమ్యానకాలే యీశుస్తేషామ్ అగ్రగామీ బభూవ, తస్మాత్తే చిత్రం జ్ఞాత్వా పశ్చాద్గామినో భూత్వా బిభ్యుః| తదా స పున ర్ద్వాదశశిష్యాన్ గృహీత్వా స్వీయం యద్యద్ ఘటిష్యతే తత్తత్ తేభ్యః కథయితుం ప్రారేభే; ");
INSERT INTO santel_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","పశ్యత వయం యిరూశాలమ్పురం యామః, తత్ర మనుష్యపుత్రః ప్రధానయాజకానామ్ ఉపాధ్యాయానాఞ్చ కరేషు సమర్పయిష్యతే; తే చ వధదణ్డాజ్ఞాం దాపయిత్వా పరదేశీయానాం కరేషు తం సమర్పయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","తే తముపహస్య కశయా ప్రహృత్య తద్వపుషి నిష్ఠీవం నిక్షిప్య తం హనిష్యన్తి, తతః స తృతీయదినే ప్రోత్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","తతః సివదేః పుత్రౌ యాకూబ్యోహనౌ తదన్తికమ్ ఏత్య ప్రోచతుః, హే గురో యద్ ఆవాభ్యాం యాచిష్యతే తదస్మదర్థం భవాన్ కరోతు నివేదనమిదమావయోః| ");
INSERT INTO santel_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","తతః స కథితవాన్, యువాం కిమిచ్ఛథః? కిం మయా యుష్మదర్థం కరణీయం? ");
INSERT INTO santel_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","తదా తౌ ప్రోచతుః, ఆవయోరేకం దక్షిణపార్శ్వే వామపార్శ్వే చైకం తవైశ్వర్య్యపదే సముపవేష్టుమ్ ఆజ్ఞాపయ| ");
INSERT INTO santel_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","కిన్తు యీశుః ప్రత్యువాచ యువామజ్ఞాత్వేదం ప్రార్థయేథే, యేన కంసేనాహం పాస్యామి తేన యువాభ్యాం కిం పాతుం శక్ష్యతే? యస్మిన్ మజ్జనేనాహం మజ్జిష్యే తన్మజ్జనే మజ్జయితుం కిం యువాభ్యాం శక్ష్యతే? తౌ ప్రత్యూచతుః శక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","తదా యీశురవదత్ యేన కంసేనాహం పాస్యామి తేనావశ్యం యువామపి పాస్యథః, యేన మజ్జనేన చాహం మజ్జియ్యే తత్ర యువామపి మజ్జిష్యేథే| ");
INSERT INTO santel_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","కిన్తు యేషామర్థమ్ ఇదం నిరూపితం, తాన్ విహాయాన్యం కమపి మమ దక్షిణపార్శ్వే వామపార్శ్వే వా సముపవేశయితుం మమాధికారో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","అథాన్యదశశిష్యా ఇమాం కథాం శ్రుత్వా యాకూబ్యోహన్భ్యాం చుకుపుః| ");
INSERT INTO santel_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","కిన్తు యీశుస్తాన్ సమాహూయ బభాషే, అన్యదేశీయానాం రాజత్వం యే కుర్వ్వన్తి తే తేషామేవ ప్రభుత్వం కుర్వ్వన్తి, తథా యే మహాలోకాస్తే తేషామ్ అధిపతిత్వం కుర్వ్వన్తీతి యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","కిన్తు యుష్మాకం మధ్యే న తథా భవిష్యతి, యుష్మాకం మధ్యే యః ప్రాధాన్యం వాఞ్ఛతి స యుష్మాకం సేవకో భవిష్యతి, ");
INSERT INTO santel_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","యుష్మాకం యో మహాన్ భవితుమిచ్ఛతి స సర్వ్వేషాం కిఙ్కరో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","యతో మనుష్యపుత్రః సేవ్యో భవితుం నాగతః సేవాం కర్త్తాం తథానేకేషాం పరిత్రాణస్య మూల్యరూపస్వప్రాణం దాతుఞ్చాగతః| ");
INSERT INTO santel_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","అథ తే యిరీహోనగరం ప్రాప్తాస్తస్మాత్ శిష్యై ర్లోకైశ్చ సహ యీశో ర్గమనకాలే టీమయస్య పుత్రో బర్టీమయనామా అన్ధస్తన్మార్గపార్శ్వే భిక్షార్థమ్ ఉపవిష్టః| ");
INSERT INTO santel_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","స నాసరతీయస్య యీశోరాగమనవార్త్తాం ప్రాప్య ప్రోచై ర్వక్తుమారేభే, హే యీశో దాయూదః సన్తాన మాం దయస్వ| ");
INSERT INTO santel_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","తతోనేకే లోకా మౌనీభవేతి తం తర్జయామాసుః, కిన్తు స పునరధికముచ్చై ర్జగాద, హే యీశో దాయూదః సన్తాన మాం దయస్వ| ");
INSERT INTO santel_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","తదా యీశుః స్థిత్వా తమాహ్వాతుం సమాదిదేశ, తతో లోకాస్తమన్ధమాహూయ బభాషిరే, హే నర, స్థిరో భవ, ఉత్తిష్ఠ, స త్వామాహ్వయతి| ");
INSERT INTO santel_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","తదా స ఉత్తరీయవస్త్రం నిక్షిప్య ప్రోత్థాయ యీశోః సమీపం గతః| ");
INSERT INTO santel_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","తతో యీశుస్తమవదత్ త్వయా కిం ప్రార్థ్యతే? తుభ్యమహం కిం కరిష్యామీ? తదా సోన్ధస్తమువాచ, హే గురో మదీయా దృష్టిర్భవేత్| ");
INSERT INTO santel_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","తతో యీశుస్తమువాచ యాహి తవ విశ్వాసస్త్వాం స్వస్థమకార్షీత్, తస్మాత్ తత్క్షణం స దృష్టిం ప్రాప్య పథా యీశోః పశ్చాద్ యయౌ| ");
INSERT INTO santel_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","అనన్తరం తేషు యిరూశాలమః సమీపస్థయో ర్బైత్ఫగీబైథనీయపురయోరన్తికస్థం జైతుననామాద్రిమాగతేషు యీశుః ప్రేషణకాలే ద్వౌ శిష్యావిదం వాక్యం జగాద, ");
INSERT INTO santel_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","యువామముం సమ్ముఖస్థం గ్రామం యాతం, తత్ర ప్రవిశ్య యో నరం నావహత్ తం గర్ద్దభశావకం ద్రక్ష్యథస్తం మోచయిత్వానయతం| ");
INSERT INTO santel_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","కిన్తు యువాం కర్మ్మేదం కుతః కురుథః? కథామిమాం యది కోపి పృచ్ఛతి తర్హి ప్రభోరత్ర ప్రయోజనమస్తీతి కథితే స శీఘ్రం తమత్ర ప్రేషయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","తతస్తౌ గత్వా ద్విమార్గమేలనే కస్యచిద్ ద్వారస్య పార్శ్వే తం గర్ద్దభశావకం ప్రాప్య మోచయతః, ");
INSERT INTO santel_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ఏతర్హి తత్రోపస్థితలోకానాం కశ్చిద్ అపృచ్ఛత్, గర్ద్దభశిశుం కుతో మోచయథః? ");
INSERT INTO santel_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","తదా యీశోరాజ్ఞానుసారేణ తేభ్యః ప్రత్యుదితే తత్క్షణం తమాదాతుం తేఽనుజజ్ఞుః| ");
INSERT INTO santel_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","అథ తౌ యీశోః సన్నిధిం గర్ద్దభశిశుమ్ ఆనీయ తదుపరి స్వవస్త్రాణి పాతయామాసతుః; తతః స తదుపరి సముపవిష్టః| ");
INSERT INTO santel_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","తదానేకే పథి స్వవాసాంసి పాతయామాసుః, పరైశ్చ తరుశాఖాశ్ఛితవా మార్గే వికీర్ణాః| ");
INSERT INTO santel_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","అపరఞ్చ పశ్చాద్గామినోఽగ్రగామినశ్చ సర్వ్వే జనా ఉచైఃస్వరేణ వక్తుమారేభిరే, జయ జయ యః పరమేశ్వరస్య నామ్నాగచ్ఛతి స ధన్య ఇతి| ");
INSERT INTO santel_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","తథాస్మాకమం పూర్వ్వపురుషస్య దాయూదో యద్రాజ్యం పరమేశ్వరనామ్నాయాతి తదపి ధన్యం, సర్వ్వస్మాదుచ్ఛ్రాయే స్వర్గే ఈశ్వరస్య జయో భవేత్| ");
INSERT INTO santel_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ఇత్థం యీశు ర్యిరూశాలమి మన్దిరం ప్రవిశ్య చతుర్దిక్స్థాని సర్వ్వాణి వస్తూని దృష్టవాన్; అథ సాయంకాల ఉపస్థితే ద్వాదశశిష్యసహితో బైథనియం జగామ| ");
INSERT INTO santel_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","అపరేహని బైథనియాద్ ఆగమనసమయే క్షుధార్త్తో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","తతో దూరే సపత్రముడుమ్బరపాదపం విలోక్య తత్ర కిఞ్చిత్ ఫలం ప్రాప్తుం తస్య సన్నికృష్టం యయౌ, తదానీం ఫలపాతనస్య సమయో నాగచ్ఛతి| తతస్తత్రోపస్థితః పత్రాణి వినా కిమప్యపరం న ప్రాప్య స కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","అద్యారభ్య కోపి మానవస్త్వత్తః ఫలం న భుఞ్జీత; ఇమాం కథాం తస్య శిష్యాః శుశ్రువుః| ");
INSERT INTO santel_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","తదనన్తరం తేషు యిరూశాలమమాయాతేషు యీశు ర్మన్దిరం గత్వా తత్రస్థానాం బణిజాం ముద్రాసనాని పారావతవిక్రేతృణామ్ ఆసనాని చ న్యుబ్జయాఞ్చకార సర్వ్వాన్ క్రేతృన్ విక్రేతృంశ్చ బహిశ్చకార| ");
INSERT INTO santel_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","అపరం మన్దిరమధ్యేన కిమపి పాత్రం వోఢుం సర్వ్వజనం నివారయామాస| ");
INSERT INTO santel_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","లోకానుపదిశన్ జగాద, మమ గృహం సర్వ్వజాతీయానాం ప్రార్థనాగృహమ్ ఇతి నామ్నా ప్రథితం భవిష్యతి ఏతత్ కిం శాస్త్రే లిఖితం నాస్తి? కిన్తు యూయం తదేవ చోరాణాం గహ్వరం కురుథ| ");
INSERT INTO santel_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ఇమాం వాణీం శ్రుత్వాధ్యాపకాః ప్రధానయాజకాశ్చ తం యథా నాశయితుం శక్నువన్తి తథోेపాయం మృగయామాసుః, కిన్తు తస్యోపదేశాత్ సర్వ్వే లోకా విస్మయం గతా అతస్తే తస్మాద్ బిభ్యుః| ");
INSERT INTO santel_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","అథ సాయంసమయ ఉపస్థితే యీశుర్నగరాద్ బహిర్వవ్రాజ| ");
INSERT INTO santel_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","అనన్తరం ప్రాతఃకాలే తే తేన మార్గేణ గచ్ఛన్తస్తముడుమ్బరమహీరుహం సమూలం శుష్కం దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","తతః పితరః పూర్వ్వవాక్యం స్మరన్ యీశుం బభాషం, హే గురో పశ్యతు య ఉడుమ్బరవిటపీ భవతా శప్తః స శుష్కో బభూవ| ");
INSERT INTO santel_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","తతో యీశుః ప్రత్యవాదీత్, యూయమీశ్వరే విశ్వసిత| ");
INSERT INTO santel_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","యుష్మానహం యథార్థం వదామి కోపి యద్యేతద్గిరిం వదతి, త్వముత్థాయ గత్వా జలధౌ పత, ప్రోక్తమిదం వాక్యమవశ్యం ఘటిష్యతే, మనసా కిమపి న సన్దిహ్య చేదిదం విశ్వసేత్ తర్హి తస్య వాక్యానుసారేణ తద్ ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","అతో హేతోరహం యుష్మాన్ వచ్మి, ప్రార్థనాకాలే యద్యదాకాంక్షిష్యధ్వే తత్తదవశ్యం ప్రాప్స్యథ, ఇత్థం విశ్వసిత, తతః ప్రాప్స్యథ| ");
INSERT INTO santel_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","అపరఞ్చ యుష్మాసు ప్రార్థయితుం సముత్థితేషు యది కోపి యుష్మాకమ్ అపరాధీ తిష్ఠతి, తర్హి తం క్షమధ్వం, తథా కృతే యుష్మాకం స్వర్గస్థః పితాపి యుష్మాకమాగాంమి క్షమిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","కిన్తు యది న క్షమధ్వే తర్హి వః స్వర్గస్థః పితాపి యుష్మాకమాగాంసి న క్షమిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","అనన్తరం తే పున ర్యిరూశాలమం ప్రవివిశుః, యీశు ర్యదా మధ్యేమన్దిరమ్ ఇతస్తతో గచ్ఛతి, తదానీం ప్రధానయాజకా ఉపాధ్యాయాః ప్రాఞ్చశ్చ తదన్తికమేత్య కథామిమాం పప్రచ్ఛుః, ");
INSERT INTO santel_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","త్వం కేనాదేశేన కర్మ్మాణ్యేతాని కరోషి? తథైతాని కర్మ్మాణి కర్త్తాం కేనాదిష్టోసి? ");
INSERT INTO santel_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","తతో యీశుః ప్రతిగదితవాన్ అహమపి యుష్మాన్ ఏకకథాం పృచ్ఛామి, యది యూయం తస్యా ఉత్తరం కురుథ, తర్హి కయాజ్ఞయాహం కర్మ్మాణ్యేతాని కరోమి తద్ యుష్మభ్యం కథయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","యోహనో మజ్జనమ్ ఈశ్వరాత్ జాతం కిం మానవాత్? తన్మహ్యం కథయత| ");
INSERT INTO santel_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","తే పరస్పరం వివేక్తుం ప్రారేభిరే, తద్ ఈశ్వరాద్ బభూవేతి చేద్ వదామస్తర్హి కుతస్తం న ప్రత్యైత? కథమేతాం కథయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","మానవాద్ అభవదితి చేద్ వదామస్తర్హి లోకేభ్యో భయమస్తి యతో హేతోః సర్వ్వే యోహనం సత్యం భవిష్యద్వాదినం మన్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","అతఏవ తే యీశుం ప్రత్యవాదిషు ర్వయం తద్ వక్తుం న శక్నుమః| యీశురువాచ, తర్హి యేనాదేశేన కర్మ్మాణ్యేతాని కరోమి, అహమపి యుష్మభ్యం తన్న కథయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","అనన్తరం యీశు ర్దృష్టాన్తేన తేభ్యః కథయితుమారేభే, కశ్చిదేకో ద్రాక్షాక్షేత్రం విధాయ తచ్చతుర్దిక్షు వారణీం కృత్వా తన్మధ్యే ద్రాక్షాపేషణకుణ్డమ్ అఖనత్, తథా తస్య గడమపి నిర్మ్మితవాన్ తతస్తత్క్షేత్రం కృషీవలేషు సమర్ప్య దూరదేశం జగామ| ");
INSERT INTO santel_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","తదనన్తరం ఫలకాలే కృషీవలేభ్యో ద్రాక్షాక్షేత్రఫలాని ప్రాప్తుం తేషాం సవిధే భృత్యమ్ ఏకం ప్రాహిణోత్| ");
INSERT INTO santel_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","కిన్తు కృషీవలాస్తం ధృత్వా ప్రహృత్య రిక్తహస్తం విససృజుః| ");
INSERT INTO santel_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","తతః స పునరన్యమేకం భృత్యం ప్రషయామాస, కిన్తు తే కృషీవలాః పాషాణాఘాతైస్తస్య శిరో భఙ్క్త్వా సాపమానం తం వ్యసర్జన్| ");
INSERT INTO santel_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","తతః పరం సోపరం దాసం ప్రాహిణోత్ తదా తే తం జఘ్నుః, ఏవమ్ అనేకేషాం కస్యచిత్ ప్రహారః కస్యచిద్ వధశ్చ తైః కృతః| ");
INSERT INTO santel_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","తతః పరం మయా స్వపుత్రే ప్రహితే తే తమవశ్యం సమ్మంస్యన్తే, ఇత్యుక్త్వావశేషే తేషాం సన్నిధౌ నిజప్రియమ్ అద్వితీయం పుత్రం ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","కిన్తు కృషీవలాః పరస్పరం జగదుః, ఏష ఉత్తరాధికారీ, ఆగచ్ఛత వయమేనం హన్మస్తథా కృతే ఽధికారోయమ్ అస్మాకం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","తతస్తం ధృత్వా హత్వా ద్రాక్షాక్షేత్రాద్ బహిః ప్రాక్షిపన్| ");
INSERT INTO santel_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","అనేనాసౌ ద్రాక్షాక్షేత్రపతిః కిం కరిష్యతి? స ఏత్య తాన్ కృషీవలాన్ సంహత్య తత్క్షేత్రమ్ అన్యేషు కృషీవలేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","అపరఞ్చ, \"స్థపతయః కరిష్యన్తి గ్రావాణం యన్తు తుచ్ఛకం| ప్రాధానప్రస్తరః కోణే స ఏవ సంభవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ఏతత్ కర్మ్మ పరేశస్యాంద్భుతం నో దృష్టితో భవేత్|| \" ఇమాం శాస్త్రీయాం లిపిం యూయం కిం నాపాఠిష్ట? ");
INSERT INTO santel_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","తదానీం స తానుద్దిశ్య తాం దృష్టాన్తకథాం కథితవాన్, త ఇత్థం బుద్వ్వా తం ధర్త్తాముద్యతాః, కిన్తు లోకేభ్యో బిభ్యుః, తదనన్తరం తే తం విహాయ వవ్రజుః| ");
INSERT INTO santel_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","అపరఞ్చ తే తస్య వాక్యదోషం ధర్త్తాం కతిపయాన్ ఫిరూశినో హేరోదీయాంశ్చ లోకాన్ తదన్తికం ప్రేషయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","త ఆగత్య తమవదన్, హే గురో భవాన్ తథ్యభాషీ కస్యాప్యనురోధం న మన్యతే, పక్షపాతఞ్చ న కరోతి, యథార్థత ఈశ్వరీయం మార్గం దర్శయతి వయమేతత్ ప్రజానీమః, కైసరాయ కరో దేయో న వాం? వయం దాస్యామో న వా? ");
INSERT INTO santel_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","కిన్తు స తేషాం కపటం జ్ఞాత్వా జగాద, కుతో మాం పరీక్షధ్వే? ఏకం ముద్రాపాదం సమానీయ మాం దర్శయత| ");
INSERT INTO santel_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","తదా తైరేకస్మిన్ ముద్రాపాదే సమానీతే స తాన్ పప్రచ్ఛ, అత్ర లిఖితం నామ మూర్త్తి ర్వా కస్య? తే ప్రత్యూచుః, కైసరస్య| ");
INSERT INTO santel_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","తదా యీశురవదత్ తర్హి కైసరస్య ద్రవ్యాణి కైసరాయ దత్త, ఈశ్వరస్య ద్రవ్యాణి తు ఈశ్వరాయ దత్త; తతస్తే విస్మయం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","అథ మృతానాముత్థానం యే న మన్యన్తే తే సిదూకినో యీశోః సమీపమాగత్య తం పప్రచ్ఛుః; ");
INSERT INTO santel_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","హే గురో కశ్చిజ్జనో యది నిఃసన్తతిః సన్ భార్య్యాయాం సత్యాం మ్రియతే తర్హి తస్య భ్రాతా తస్య భార్య్యాం గృహీత్వా భ్రాతు ర్వంశోత్పత్తిం కరిష్యతి, వ్యవస్థామిమాం మూసా అస్మాన్ ప్రతి వ్యలిఖత్| ");
INSERT INTO santel_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","కిన్తు కేచిత్ సప్త భ్రాతర ఆసన్, తతస్తేషాం జ్యేష్ఠభ్రాతా వివహ్య నిఃసన్తతిః సన్ అమ్రియత| ");
INSERT INTO santel_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","తతో ద్వితీయో భ్రాతా తాం స్త్రియమగృహణత్ కిన్తు సోపి నిఃసన్తతిః సన్ అమ్రియత; అథ తృతీయోపి భ్రాతా తాదృశోభవత్| ");
INSERT INTO santel_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ఇత్థం సప్తైవ భ్రాతరస్తాం స్త్రియం గృహీత్వా నిఃసన్తానాః సన్తోఽమ్రియన్త, సర్వ్వశేషే సాపి స్త్రీ మ్రియతే స్మ| ");
INSERT INTO santel_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","అథ మృతానాముత్థానకాలే యదా త ఉత్థాస్యన్తి తదా తేషాం కస్య భార్య్యా సా భవిష్యతి? యతస్తే సప్తైవ తాం వ్యవహన్| ");
INSERT INTO santel_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","తతో యీశుః ప్రత్యువాచ శాస్త్రమ్ ఈశ్వరశక్తిఞ్చ యూయమజ్ఞాత్వా కిమభ్రామ్యత న? ");
INSERT INTO santel_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","మృతలోకానాముత్థానం సతి తే న వివహన్తి వాగ్దత్తా అపి న భవన్తి, కిన్తు స్వర్గీయదూతానాం సదృశా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","పునశ్చ \"అహమ్ ఇబ్రాహీమ ఈశ్వర ఇస్హాక ఈశ్వరో యాకూబశ్చేశ్వరః\" యామిమాం కథాం స్తమ్బమధ్యే తిష్ఠన్ ఈశ్వరో మూసామవాదీత్ మృతానాముత్థానార్థే సా కథా మూసాలిఖితే పుస్తకే కిం యుష్మాభి ర్నాపాఠి? ");
INSERT INTO santel_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ఈశ్వరో జీవతాం ప్రభుః కిన్తు మృతానాం ప్రభు ర్న భవతి, తస్మాద్ధేతో ర్యూయం మహాభ్రమేణ తిష్ఠథ| ");
INSERT INTO santel_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ఏతర్హి ఏకోధ్యాపక ఏత్య తేషామిత్థం విచారం శుశ్రావ; యీశుస్తేషాం వాక్యస్య సదుత్తరం దత్తవాన్ ఇతి బుద్వ్వా తం పృష్టవాన్ సర్వ్వాసామ్ ఆజ్ఞానాం కా శ్రేష్ఠా? తతో యీశుః ప్రత్యువాచ, ");
INSERT INTO santel_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"హే ఇస్రాయేల్లోకా అవధత్త, అస్మాకం ప్రభుః పరమేశ్వర ఏక ఏవ, ");
INSERT INTO santel_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","యూయం సర్వ్వన్తఃకరణైః సర్వ్వప్రాణైః సర్వ్వచిత్తైః సర్వ్వశక్తిభిశ్చ తస్మిన్ ప్రభౌ పరమేశ్వరే ప్రీయధ్వం,\" ఇత్యాజ్ఞా శ్రేష్ఠా| ");
INSERT INTO santel_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","తథా \"స్వప్రతివాసిని స్వవత్ ప్రేమ కురుధ్వం,\" ఏషా యా ద్వితీయాజ్ఞా సా తాదృశీ; ఏతాభ్యాం ద్వాభ్యామ్ ఆజ్ఞాభ్యామ్ అన్యా కాప్యాజ్ఞా శ్రేష్ఠా నాస్తి| ");
INSERT INTO santel_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","తదా సోధ్యాపకస్తమవదత్, హే గురో సత్యం భవాన్ యథార్థం ప్రోక్తవాన్ యత ఏకస్మాద్ ఈశ్వరాద్ అన్యో ద్వితీయ ఈశ్వరో నాస్తి; ");
INSERT INTO santel_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","అపరం సర్వ్వాన్తఃకరణైః సర్వ్వప్రాణైః సర్వ్వచిత్తైః సర్వ్వశక్తిభిశ్చ ఈశ్వరే ప్రేమకరణం తథా స్వమీపవాసిని స్వవత్ ప్రేమకరణఞ్చ సర్వ్వేభ్యో హోమబలిదానాదిభ్యః శ్రష్ఠం భవతి| ");
INSERT INTO santel_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","తతో యీశుః సుబుద్ధేరివ తస్యేదమ్ ఉత్తరం శ్రుత్వా తం భాషితవాన్ త్వమీశ్వరస్య రాజ్యాన్న దూరోసి| ఇతః పరం తేన సహ కస్యాపి వాక్యస్య విచారం కర్త్తాం కస్యాపి ప్రగల్భతా న జాతా| ");
INSERT INTO santel_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","అనన్తరం మధ్యేమన్దిరమ్ ఉపదిశన్ యీశురిమం ప్రశ్నం చకార, అధ్యాపకా అభిషిక్తం (తారకం) కుతో దాయూదః సన్తానం వదన్తి? ");
INSERT INTO santel_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","స్వయం దాయూద్ పవిత్రస్యాత్మన ఆవేశేనేదం కథయామాస| యథా| \"మమ ప్రభుమిదం వాక్యవదత్ పరమేశ్వరః| తవ శత్రూనహం యావత్ పాదపీఠం కరోమి న| తావత్ కాలం మదీయే త్వం దక్షపార్శ్వ్ ఉపావిశ| \" ");
INSERT INTO santel_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","యది దాయూద్ తం ప్రభూం వదతి తర్హి కథం స తస్య సన్తానో భవితుమర్హతి? ఇతరే లోకాస్తత్కథాం శ్రుత్వాననన్దుః| ");
INSERT INTO santel_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","తదానీం స తానుపదిశ్య కథితవాన్ యే నరా దీర్ఘపరిధేయాని హట్టే విపనౌ చ ");
INSERT INTO santel_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","లోకకృతనమస్కారాన్ భజనగృహే ప్రధానాసనాని భోజనకాలే ప్రధానస్థానాని చ కాఙ్క్షన్తే; ");
INSERT INTO santel_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","విధవానాం సర్వ్వస్వం గ్రసిత్వా ఛలాద్ దీర్ఘకాలం ప్రార్థయన్తే తేభ్య ఉపాధ్యాయేభ్యః సావధానా భవత; తేఽధికతరాన్ దణ్డాన్ ప్రాప్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","తదనన్తరం లోకా భాణ్డాగారే ముద్రా యథా నిక్షిపన్తి భాణ్డాగారస్య సమ్ముఖే సముపవిశ్య యీశుస్తదవలులోక; తదానీం బహవో ధనినస్తస్య మధ్యే బహూని ధనాని నిరక్షిపన్| ");
INSERT INTO santel_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","పశ్చాద్ ఏకా దరిద్రా విధవా సమాగత్య ద్విపణమూల్యాం ముద్రైకాం తత్ర నిరక్షిపత్| ");
INSERT INTO santel_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","తదా యీశుః శిష్యాన్ ఆహూయ కథితవాన్ యుష్మానహం యథార్థం వదామి యే యే భాణ్డాగారేఽస్మిన ధనాని నిఃక్షిపన్తి స్మ తేభ్యః సర్వ్వేభ్య ఇయం విధవా దరిద్రాధికమ్ నిఃక్షిపతి స్మ| ");
INSERT INTO santel_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","యతస్తే ప్రభూతధనస్య కిఞ్చిత్ నిరక్షిపన్ కిన్తు దీనేయం స్వదినయాపనయోగ్యం కిఞ్చిదపి న స్థాపయిత్వా సర్వ్వస్వం నిరక్షిపత్| ");
INSERT INTO santel_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","అనన్తరం మన్దిరాద్ బహిర్గమనకాలే తస్య శిష్యాణామేకస్తం వ్యాహృతవాన్ హే గురో పశ్యతు కీదృశాః పాషాణాః కీదృక్ చ నిచయనం| ");
INSERT INTO santel_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","తదా యీశుస్తమ్ అవదత్ త్వం కిమేతద్ బృహన్నిచయనం పశ్యసి? అస్యైకపాషాణోపి ద్వితీయపాషాణోపరి న స్థాస్యతి సర్వ్వే ఽధఃక్షేప్స్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","అథ యస్మిన్ కాలే జైతున్గిరౌ మన్దిరస్య సమ్ముఖే స సముపవిష్టస్తస్మిన్ కాలే పితరో యాకూబ్ యోహన్ ఆన్ద్రియశ్చైతే తం రహసి పప్రచ్ఛుః, ");
INSERT INTO santel_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ఏతా ఘటనాః కదా భవిష్యన్తి? తథైతత్సర్వ్వాసాం సిద్ధ్యుపక్రమస్య వా కిం చిహ్నం? తదస్మభ్యం కథయతు భవాన్| ");
INSERT INTO santel_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","తతో యాశుస్తాన్ వక్తుమారేభే, కోపి యథా యుష్మాన్ న భ్రామయతి తథాత్ర యూయం సావధానా భవత| ");
INSERT INTO santel_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","యతః ఖ్రీష్టోహమితి కథయిత్వా మమ నామ్నానేకే సమాగత్య లోకానాం భ్రమం జనయిష్యన్తి; ");
INSERT INTO santel_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","కిన్తు యూయం రణస్య వార్త్తాం రణాడమ్బరఞ్చ శ్రుత్వా మా వ్యాకులా భవత, ఘటనా ఏతా అవశ్యమ్మావిన్యః; కిన్త్వాపాతతో న యుగాన్తో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","దేశస్య విపక్షతయా దేశో రాజ్యస్య విపక్షతయా చ రాజ్యముత్థాస్యతి, తథా స్థానే స్థానే భూమికమ్పో దుర్భిక్షం మహాక్లేశాశ్చ సముపస్థాస్యన్తి, సర్వ్వ ఏతే దుఃఖస్యారమ్భాః| ");
INSERT INTO santel_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","కిన్తు యూయమ్ ఆత్మార్థే సావధానాస్తిష్ఠత, యతో లోకా రాజసభాయాం యుష్మాన్ సమర్పయిష్యన్తి, తథా భజనగృహే ప్రహరిష్యన్తి; యూయం మదర్థే దేశాధిపాన్ భూపాంశ్చ ప్రతి సాక్ష్యదానాయ తేషాం సమ్ముఖే ఉపస్థాపయిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","శేషీభవనాత్ పూర్వ్వం సర్వ్వాన్ దేశీయాన్ ప్రతి సుసంవాదః ప్రచారయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","కిన్తు యదా తే యుష్మాన్ ధృత్వా సమర్పయిష్యన్తి తదా యూయం యద్యద్ ఉత్తరం దాస్యథ, తదగ్ర తస్య వివేచనం మా కురుత తదర్థం కిఞ్చిదపి మా చిన్తయత చ, తదానీం యుష్మాకం మనఃసు యద్యద్ వాక్యమ్ ఉపస్థాపయిష్యతే తదేవ వదిష్యథ, యతో యూయం న తద్వక్తారః కిన్తు పవిత్ర ఆత్మా తస్య వక్తా| ");
INSERT INTO santel_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","తదా భ్రాతా భ్రాతరం పితా పుత్రం ఘాతనార్థం పరహస్తేషు సమర్పయిష్యతే, తథా పత్యాని మాతాపిత్రో ర్విపక్షతయా తౌ ఘాతయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","మమ నామహేతోః సర్వ్వేషాం సవిధే యూయం జుగుప్సితా భవిష్యథ, కిన్తు యః కశ్చిత్ శేషపర్య్యన్తం ధైర్య్యమ్ ఆలమ్బిష్యతే సఏవ పరిత్రాస్యతే| ");
INSERT INTO santel_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","దానియేల్భవిష్యద్వాదినా ప్రోక్తం సర్వ్వనాశి జుగుప్సితఞ్చ వస్తు యదా త్వయోగ్యస్థానే విద్యమానం ద్రక్షథ (యో జనః పఠతి స బుధ్యతాం) తదా యే యిహూదీయదేశే తిష్ఠన్తి తే మహీధ్రం ప్రతి పలాయన్తాం; ");
INSERT INTO santel_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","తథా యో నరో గృహోపరి తిష్ఠతి స గృహమధ్యం నావరోహతు, తథా కిమపి వస్తు గ్రహీతుం మధ్యేగృహం న ప్రవిశతు; ");
INSERT INTO santel_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","తథా చ యో నరః క్షేత్రే తిష్ఠతి సోపి స్వవస్త్రం గ్రహీతుం పరావృత్య న వ్రజతు| ");
INSERT INTO santel_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","తదానీం గర్బ్భవతీనాం స్తన్యదాత్రీణాఞ్చ యోషితాం దుర్గతి ర్భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","యుష్మాకం పలాయనం శీతకాలే యథా న భవతి తదర్థం ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","యతస్తదా యాదృశీ దుర్ఘటనా ఘటిష్యతే తాదృశీ దుర్ఘటనా ఈశ్వరసృష్టేః ప్రథమమారభ్యాద్య యావత్ కదాపి న జాతా న జనిష్యతే చ| ");
INSERT INTO santel_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","అపరఞ్చ పరమేశ్వరో యది తస్య సమయస్య సంక్షేపం న కరోతి తర్హి కస్యాపి ప్రాణభృతో రక్షా భవితుం న శక్ష్యతి, కిన్తు యాన్ జనాన్ మనోనీతాన్ అకరోత్ తేషాం స్వమనోనీతానాం హేతోః స తదనేహసం సంక్షేప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","అన్యచ్చ పశ్యత ఖ్రీష్టోత్ర స్థానే వా తత్ర స్థానే విద్యతే, తస్మిన్కాలే యది కశ్చిద్ యుష్మాన్ ఏతాదృశం వాక్యం వ్యాహరతి, తర్హి తస్మిన్ వాక్యే భైవ విశ్వసిత| ");
INSERT INTO santel_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","యతోనేకే మిథ్యాఖ్రీష్టా మిథ్యాభవిష్యద్వాదినశ్చ సముపస్థాయ బహూని చిహ్నాన్యద్భుతాని కర్మ్మాణి చ దర్శయిష్యన్తి; తథా యది సమ్భవతి తర్హి మనోనీతలోకానామపి మిథ్యామతిం జనయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","పశ్యత ఘటనాతః పూర్వ్వం సర్వ్వకార్య్యస్య వార్త్తాం యుష్మభ్యమదామ్, యూయం సావధానాస్తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","అపరఞ్చ తస్య క్లేశకాలస్యావ్యవహితే పరకాలే భాస్కరః సాన్ధకారో భవిష్యతి తథైవ చన్ద్రశ్చన్ద్రికాం న దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","నభఃస్థాని నక్షత్రాణి పతిష్యన్తి, వ్యోమమణ్డలస్థా గ్రహాశ్చ విచలిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","తదానీం మహాపరాక్రమేణ మహైశ్వర్య్యేణ చ మేఘమారుహ్య సమాయాన్తం మానవసుతం మానవాః సమీక్షిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","అన్యచ్చ స నిజదూతాన్ ప్రహిత్య నభోభూమ్యోః సీమాం యావద్ జగతశ్చతుర్దిగ్భ్యః స్వమనోనీతలోకాన్ సంగ్రహీష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ఉడుమ్బరతరో ర్దృష్టాన్తం శిక్షధ్వం యదోడుమ్బరస్య తరో ర్నవీనాః శాఖా జాయన్తే పల్లవాదీని చ ర్నిగచ్ఛన్తి, తదా నిదాఘకాలః సవిధో భవతీతి యూయం జ్ఞాతుం శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","తద్వద్ ఏతా ఘటనా దృష్ట్వా స కాలో ద్వార్య్యుపస్థిత ఇతి జానీత| ");
INSERT INTO santel_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","యుష్మానహం యథార్థం వదామి, ఆధునికలోకానాం గమనాత్ పూర్వ్వం తాని సర్వ్వాణి ఘటిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ద్యావాపృథివ్యో ర్విచలితయోః సత్యో ర్మదీయా వాణీ న విచలిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","అపరఞ్చ స్వర్గస్థదూతగణో వా పుత్రో వా తాతాదన్యః కోపి తం దివసం తం దణ్డం వా న జ్ఞాపయతి| ");
INSERT INTO santel_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","అతః స సమయః కదా భవిష్యతి, ఏతజ్జ్ఞానాభావాద్ యూయం సావధానాస్తిష్ఠత, సతర్కాశ్చ భూత్వా ప్రార్థయధ్వం; ");
INSERT INTO santel_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","యద్వత్ కశ్చిత్ పుమాన్ స్వనివేశనాద్ దూరదేశం ప్రతి యాత్రాకరణకాలే దాసేషు స్వకార్య్యస్య భారమర్పయిత్వా సర్వ్వాన్ స్వే స్వే కర్మ్మణి నియోజయతి; అపరం దౌవారికం జాగరితుం సమాదిశ్య యాతి, తద్వన్ నరపుత్రః| ");
INSERT INTO santel_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","గృహపతిః సాయంకాలే నిశీథే వా తృతీయయామే వా ప్రాతఃకాలే వా కదాగమిష్యతి తద్ యూయం న జానీథ; ");
INSERT INTO santel_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","స హఠాదాగత్య యథా యుష్మాన్ నిద్రితాన్ న పశ్యతి, తదర్థం జాగరితాస్తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","యుష్మానహం యద్ వదామి తదేవ సర్వ్వాన్ వదామి, జాగరితాస్తిష్ఠతేతి| ");
INSERT INTO santel_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","తదా నిస్తారోత్సవకిణ్వహీనపూపోత్సవయోరారమ్భస్య దినద్వయే ఽవశిష్టే ప్రధానయాజకా అధ్యాపకాశ్చ కేనాపి ఛలేన యీశుం ధర్త్తాం హన్తుఞ్చ మృగయాఞ్చక్రిరే; ");
INSERT INTO santel_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","కిన్తు లోకానాం కలహభయాదూచిరే, నచోత్సవకాల ఉచితమేతదితి| ");
INSERT INTO santel_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","అనన్తరం బైథనియాపుुరే శిమోనకుష్ఠినో గృహే యోశౌ భోత్కుముపవిష్టే సతి కాచిద్ యోషిత్ పాణ్డరపాషాణస్య సమ్పుటకేన మహార్ఘ్యోత్తమతైలమ్ ఆనీయ సమ్పుటకం భంక్త్వా తస్యోత్తమాఙ్గే తైలధారాం పాతయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","తస్మాత్ కేచిత్ స్వాన్తే కుప్యన్తః కథితవంన్తః కుతోయం తైలాపవ్యయః? ");
INSERT INTO santel_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","యద్యేతత్ తైల వ్యక్రేష్యత తర్హి ముద్రాపాదశతత్రయాదప్యధికం తస్య ప్రాప్తమూల్యం దరిద్రలోకేభ్యో దాతుమశక్ష్యత, కథామేతాం కథయిత్వా తయా యోషితా సాకం వాచాయుహ్యన్| ");
INSERT INTO santel_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","కిన్తు యీశురువాచ, కుత ఏతస్యై కృచ్ఛ్రం దదాసి? మహ్యమియం కర్మ్మోత్తమం కృతవతీ| ");
INSERT INTO santel_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","దరిద్రాః సర్వ్వదా యుష్మాభిః సహ తిష్ఠన్తి, తస్మాద్ యూయం యదేచ్ఛథ తదైవ తానుపకర్త్తాం శక్నుథ, కిన్త్వహం యుభాభిః సహ నిరన్తరం న తిష్ఠామి| ");
INSERT INTO santel_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","అస్యా యథాసాధ్యం తథైవాకరోదియం, శ్మశానయాపనాత్ పూర్వ్వం సమేత్య మద్వపుషి తైలమ్ అమర్ద్దయత్| ");
INSERT INTO santel_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","అహం యుష్మభ్యం యథార్థం కథయామి, జగతాం మధ్యే యత్ర యత్ర సుసంవాదోయం ప్రచారయిష్యతే తత్ర తత్ర యోషిత ఏతస్యాః స్మరణార్థం తత్కృతకర్మ్మైతత్ ప్రచారయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","తతః పరం ద్వాదశానాం శిష్యాణామేక ఈష్కరియోతీయయిహూదాఖ్యో యీశుం పరకరేషు సమర్పయితుం ప్రధానయాజకానాం సమీపమియాయ| ");
INSERT INTO santel_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","తే తస్య వాక్యం సమాకర్ణ్య సన్తుష్టాః సన్తస్తస్మై ముద్రా దాతుం ప్రత్యజానత; తస్మాత్ స తం తేషాం కరేషు సమర్పణాయోపాయం మృగయామాస| ");
INSERT INTO santel_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","అనన్తరం కిణ్వశూన్యపూపోత్సవస్య ప్రథమేఽహని నిస్తారోత్మవార్థం మేషమారణాసమయే శిష్యాస్తం పప్రచ్ఛః కుత్ర గత్వా వయం నిస్తారోత్సవస్య భోజ్యమాసాదయిష్యామః? కిమిచ్ఛతి భవాన్? ");
INSERT INTO santel_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","తదానీం స తేషాం ద్వయం ప్రేరయన్ బభాషే యువయోః పురమధ్యం గతయోః సతో ర్యో జనః సజలకుమ్భం వహన్ యువాం సాక్షాత్ కరిష్యతి తస్యైవ పశ్చాద్ యాతం; ");
INSERT INTO santel_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","స యత్ సదనం ప్రవేక్ష్యతి తద్భవనపతిం వదతం, గురురాహ యత్ర సశిష్యోహం నిస్తారోత్సవీయం భోజనం కరిష్యామి, సా భోజనశాలా కుత్రాస్తి? ");
INSERT INTO santel_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","తతః స పరిష్కృతాం సుసజ్జితాం బృహతీచఞ్చ యాం శాలాం దర్శయిష్యతి తస్యామస్మదర్థం భోజ్యద్రవ్యాణ్యాసాదయతం| ");
INSERT INTO santel_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","తతః శిష్యౌ ప్రస్థాయ పురం ప్రవిశ్య స యథోక్తవాన్ తథైవ ప్రాప్య నిస్తారోత్సవస్య భోజ్యద్రవ్యాణి సమాసాదయేతామ్| ");
INSERT INTO santel_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","అనన్తరం యీశుః సాయంకాలే ద్వాదశభిః శిష్యైః సార్ద్ధం జగామ; ");
INSERT INTO santel_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","సర్వ్వేషు భోజనాయ ప్రోపవిష్టేషు స తానుదితవాన్ యుష్మానహం యథార్థం వ్యాహరామి, అత్ర యుష్మాకమేకో జనో యో మయా సహ భుంక్తే మాం పరకేరేషు సమర్పయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","తదానీం తే దుఃఖితాః సన్త ఏకైకశస్తం ప్రష్టుమారబ్ధవన్తః స కిమహం? పశ్చాద్ అన్య ఏకోభిదధే స కిమహం? ");
INSERT INTO santel_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","తతః స ప్రత్యవదద్ ఏతేషాం ద్వాదశానాం యో జనో మయా సమం భోజనాపాత్రే పాణిం మజ్జయిష్యతి స ఏవ| ");
INSERT INTO santel_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","మనుజతనయమధి యాదృశం లిఖితమాస్తే తదనురూపా గతిస్తస్య భవిష్యతి, కిన్తు యో జనో మానవసుతం సమర్పయిష్యతే హన్త తస్య జన్మాభావే సతి భద్రమభవిష్యత్| ");
INSERT INTO santel_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","అపరఞ్చ తేషాం భోజనసమయే యీశుః పూపం గృహీత్వేశ్వరగుణాన్ అనుకీర్త్య భఙ్క్త్వా తేభ్యో దత్త్వా బభాషే, ఏతద్ గృహీత్వా భుఞ్జీధ్వమ్ ఏతన్మమ విగ్రహరూపం| ");
INSERT INTO santel_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","అనన్తరం స కంసం గృహీత్వేశ్వరస్య గుణాన్ కీర్త్తయిత్వా తేభ్యో దదౌ, తతస్తే సర్వ్వే పపుః| ");
INSERT INTO santel_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","అపరం స తానవాదీద్ బహూనాం నిమిత్తం పాతితం మమ నవీననియమరూపం శోణితమేతత్| ");
INSERT INTO santel_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","యుష్మానహం యథార్థం వదామి, ఈశ్వరస్య రాజ్యే యావత్ సద్యోజాతం ద్రాక్షారసం న పాస్యామి,తావదహం ద్రాక్షాఫలరసం పున ర్న పాస్యామి| ");
INSERT INTO santel_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","తదనన్తరం తే గీతమేకం సంగీయ బహి ర్జైతునం శిఖరిణం యయుః ");
INSERT INTO santel_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","అథ యీశుస్తానువాచ నిశాయామస్యాం మయి యుష్మాకం సర్వ్వేషాం ప్రత్యూహో భవిష్యతి యతో లిఖితమాస్తే యథా, మేషాణాం రక్షకఞ్చాహం ప్రహరిష్యామి వై తతః| మేషాణాం నివహో నూనం ప్రవికీర్ణో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","కన్తు మదుత్థానే జాతే యుష్మాకమగ్రేఽహం గాలీలం వ్రజిష్యామి| ");
INSERT INTO santel_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","తదా పితరః ప్రతిబభాషే, యద్యపి సర్వ్వేషాం ప్రత్యూహో భవతి తథాపి మమ నైవ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","తతో యీశురుక్తావాన్ అహం తుభ్యం తథ్యం కథయామి, క్షణాదాయామద్య కుక్కుటస్య ద్వితీయవారరవణాత్ పూర్వ్వం త్వం వారత్రయం మామపహ్నోష్యసే| ");
INSERT INTO santel_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","కిన్తు స గాఢం వ్యాహరద్ యద్యపి త్వయా సార్ద్ధం మమ ప్రాణో యాతి తథాపి కథమపి త్వాం నాపహ్నోష్యే; సర్వ్వేఽపీతరే తథైవ బభాషిరే| ");
INSERT INTO santel_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","అపరఞ్చ తేషు గేత్శిమానీనామకం స్థాన గతేషు స శిష్యాన్ జగాద, యావదహం ప్రార్థయే తావదత్ర స్థానే యూయం సముపవిశత| ");
INSERT INTO santel_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","అథ స పితరం యాకూబం యోహనఞ్చ గృహీత్వా వవ్రాజ; అత్యన్తం త్రాసితో వ్యాకులితశ్చ తేభ్యః కథయామాస, ");
INSERT INTO santel_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","నిధనకాలవత్ ప్రాణో మేఽతీవ దఃఖమేతి, యూయం జాగ్రతోత్ర స్థానే తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","తతః స కిఞ్చిద్దూరం గత్వా భూమావధోముఖః పతిత్వా ప్రార్థితవానేతత్, యది భవితుం శక్యం తర్హి దుఃఖసమయోయం మత్తో దూరీభవతు| ");
INSERT INTO santel_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","అపరముదితవాన్ హే పిత ర్హే పితః సర్వ్వేం త్వయా సాధ్యం, తతో హేతోరిమం కంసం మత్తో దూరీకురు, కిన్తు తన్ మమేచ్ఛాతో న తవేచ్ఛాతో భవతు| ");
INSERT INTO santel_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","తతః పరం స ఏత్య తాన్ నిద్రితాన్ నిరీక్ష్య పితరం ప్రోవాచ, శిమోన్ త్వం కిం నిద్రాసి? ఘటికామేకామ్ అపి జాగరితుం న శక్నోషి? ");
INSERT INTO santel_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","పరీక్షాయాం యథా న పతథ తదర్థం సచేతనాః సన్తః ప్రార్థయధ్వం; మన ఉద్యుక్తమితి సత్యం కిన్తు వపురశక్తికం| ");
INSERT INTO santel_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","అథ స పునర్వ్రజిత్వా పూర్వ్వవత్ ప్రార్థయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","పరావృత్యాగత్య పునరపి తాన్ నిద్రితాన్ దదర్శ తదా తేషాం లోచనాని నిద్రయా పూర్ణాని, తస్మాత్తస్మై కా కథా కథయితవ్యా త ఏతద్ బోద్ధుం న శేకుః| ");
INSERT INTO santel_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","తతఃపరం తృతీయవారం ఆగత్య తేభ్యో ఽకథయద్ ఇదానీమపి శయిత్వా విశ్రామ్యథ? యథేష్టం జాతం, సమయశ్చోపస్థితః పశ్యత మానవతనయః పాపిలోకానాం పాణిషు సమర్ప్యతే| ");
INSERT INTO santel_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ఉత్తిష్ఠత, వయం వ్రజామో యో జనో మాం పరపాణిషు సమర్పయిష్యతే పశ్యత స సమీపమాయాతః| ");
INSERT INTO santel_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ఇమాం కథాం కథయతి స, ఏతర్హిద్వాదశానామేకో యిహూదా నామా శిష్యః ప్రధానయాజకానామ్ ఉపాధ్యాయానాం ప్రాచీనలోకానాఞ్చ సన్నిధేః ఖఙ్గలగుడధారిణో బహులోకాన్ గృహీత్వా తస్య సమీప ఉపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","అపరఞ్చాసౌ పరపాణిషు సమర్పయితా పూర్వ్వమితి సఙ్కేతం కృతవాన్ యమహం చుమ్బిష్యామి స ఏవాసౌ తమేవ ధృత్వా సావధానం నయత| ");
INSERT INTO santel_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","అతో హేతోః స ఆగత్యైవ యోశోః సవిధం గత్వా హే గురో హే గురో, ఇత్యుక్త్వా తం చుచుమ్బ| ");
INSERT INTO santel_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","తదా తే తదుపరి పాణీనర్పయిత్వా తం దధ్నుః| ");
INSERT INTO santel_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","తతస్తస్య పార్శ్వస్థానాం లోకానామేకః ఖఙ్గం నిష్కోషయన్ మహాయాజకస్య దాసమేకం ప్రహృత్య తస్య కర్ణం చిచ్ఛేద| ");
INSERT INTO santel_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","పశ్చాద్ యీశుస్తాన్ వ్యాజహార ఖఙ్గాన్ లగుడాంశ్చ గృహీత్వా మాం కిం చౌరం ధర్త్తాం సమాయాతాః? ");
INSERT INTO santel_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","మధ్యేమన్దిరం సముపదిశన్ ప్రత్యహం యుష్మాభిః సహ స్థితవానతహం, తస్మిన్ కాలే యూయం మాం నాదీధరత, కిన్త్వనేన శాస్త్రీయం వచనం సేధనీయం| ");
INSERT INTO santel_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","తదా సర్వ్వే శిష్యాస్తం పరిత్యజ్య పలాయాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","అథైకో యువా మానవో నగ్నకాయే వస్త్రమేకం నిధాయ తస్య పశ్చాద్ వ్రజన్ యువలోకై ర్ధృతో ");
INSERT INTO santel_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","వస్త్రం విహాయ నగ్నః పలాయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","అపరఞ్చ యస్మిన్ స్థానే ప్రధానయాజకా ఉపాధ్యాయాః ప్రాచీనలోకాశ్చ మహాయాజకేన సహ సదసి స్థితాస్తస్మిన్ స్థానే మహాయాజకస్య సమీపం యీశుం నిన్యుః| ");
INSERT INTO santel_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","పితరో దూరే తత్పశ్చాద్ ఇత్వా మహాయాజకస్యాట్టాలికాం ప్రవిశ్య కిఙ్కరైః సహోపవిశ్య వహ్నితాపం జగ్రాహ| ");
INSERT INTO santel_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","తదానీం ప్రధానయాజకా మన్త్రిణశ్చ యీశుం ఘాతయితుం తత్ప్రాతికూల్యేన సాక్షిణో మృగయాఞ్చక్రిరే, కిన్తు న ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","అనేకైస్తద్విరుద్ధం మృషాసాక్ష్యే దత్తేపి తేషాం వాక్యాని న సమగచ్ఛన్త| ");
INSERT INTO santel_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","సర్వ్వశేషే కియన్త ఉత్థాయ తస్య ప్రాతికూల్యేన మృషాసాక్ష్యం దత్త్వా కథయామాసుః, ");
INSERT INTO santel_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ఇదం కరకృతమన్దిరం వినాశ్య దినత్రయమధ్యే పునరపరమ్ అకరకృతం మన్దిరం నిర్మ్మాస్యామి, ఇతి వాక్యమ్ అస్య ముఖాత్ శ్రుతమస్మాభిరితి| ");
INSERT INTO santel_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","కిన్తు తత్రాపి తేషాం సాక్ష్యకథా న సఙ్గాతాః| ");
INSERT INTO santel_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","అథ మహాయాజకో మధ్యేసభమ్ ఉత్థాయ యీశుం వ్యాజహార, ఏతే జనాస్త్వయి యత్ సాక్ష్యమదుః త్వమేతస్య కిమప్యుత్తరం కిం న దాస్యసి? ");
INSERT INTO santel_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","కిన్తు స కిమప్యుత్తరం న దత్వా మౌనీభూయ తస్యౌ; తతో మహాయాజకః పునరపి తం పృష్టావాన్ త్వం సచ్చిదానన్దస్య తనయో ఽభిషిక్తస్త్రతా? ");
INSERT INTO santel_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","తదా యీశుస్తం ప్రోవాచ భవామ్యహమ్ యూయఞ్చ సర్వ్వశక్తిమతో దక్షీణపార్శ్వే సముపవిశన్తం మేఘ మారుహ్య సమాయాన్తఞ్చ మనుష్యపుత్రం సన్ద్రక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","తదా మహాయాజకః స్వం వమనం ఛిత్వా వ్యావహరత్ ");
INSERT INTO santel_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","కిమస్మాకం సాక్షిభిః ప్రయోజనమ్? ఈశ్వరనిన్దావాక్యం యుష్మాభిరశ్రావి కిం విచారయథ? తదానీం సర్వ్వే జగదురయం నిధనదణ్డమర్హతి| ");
INSERT INTO santel_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","తతః కశ్చిత్ కశ్చిత్ తద్వపుషి నిష్ఠీవం నిచిక్షేప తథా తన్ముఖమాచ్ఛాద్య చపేటేన హత్వా గదితవాన్ గణయిత్వా వద, అనుచరాశ్చ చపేటైస్తమాజఘ్నుః ");
INSERT INTO santel_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","తతః పరం పితరేఽట్టాలికాధఃకోష్ఠే తిష్ఠతి మహాయాజకస్యైకా దాసీ సమేత్య ");
INSERT INTO santel_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","తం విహ్నితాపం గృహ్లన్తం విలోక్య తం సునిరీక్ష్య బభాషే త్వమపి నాసరతీయయీశోః సఙ్గినామ్ ఏకో జన ఆసీః| ");
INSERT INTO santel_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","కిన్తు సోపహ్నుత్య జగాద తమహం న వద్మి త్వం యత్ కథయమి తదప్యహం న బుద్ధ్యే| తదానీం పితరే చత్వరం గతవతి కుेక్కుటో రురావ| ");
INSERT INTO santel_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","అథాన్యా దాసీ పితరం దృష్ట్వా సమీపస్థాన్ జనాన్ జగాద అయం తేషామేకో జనః| ");
INSERT INTO santel_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","తతః స ద్వితీయవారమ్ అపహ్నుతవాన్ పశ్చాత్ తత్రస్థా లోకాః పితరం ప్రోచుస్త్వమవశ్యం తేషామేకో జనః యతస్త్వం గాలీలీయో నర ఇతి తవోచ్చారణం ప్రకాశయతి| ");
INSERT INTO santel_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","తదా స శపథాభిశాపౌ కృత్వా ప్రోవాచ యూయం కథాం కథయథ తం నరం న జానేఽహం| ");
INSERT INTO santel_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","తదానీం ద్వితీయవారం కుక్కుటో ఽరావీత్| కుక్కుటస్య ద్వితీయరవాత్ పూర్వ్వం త్వం మాం వారత్రయమ్ అపహ్నోష్యసి, ఇతి యద్వాక్యం యీశునా సముదితం తత్ తదా సంస్మృత్య పితరో రోదితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","అథ ప్రభాతే సతి ప్రధానయాజకాః ప్రాఞ్చ ఉపాధ్యాయాః సర్వ్వే మన్త్రిణశ్చ సభాం కృత్వా యీశుृం బన్ధయిత్వ పీలాతాఖ్యస్య దేశాధిపతేః సవిధం నీత్వా సమర్పయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","తదా పీలాతస్తం పృష్టవాన్ త్వం కిం యిహూదీయలోకానాం రాజా? తతః స ప్రత్యుక్తవాన్ సత్యం వదసి| ");
INSERT INTO santel_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","అపరం ప్రధానయాజకాస్తస్య బహుషు వాక్యేషు దోషమారోపయాఞ్చక్రుః కిన్తు స కిమపి న ప్రత్యువాచ| ");
INSERT INTO santel_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","తదానీం పీలాతస్తం పునః పప్రచ్ఛ త్వం కిం నోత్తరయసి? పశ్యైతే త్వద్విరుద్ధం కతిషు సాధ్యేషు సాక్షం దదతి| ");
INSERT INTO santel_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","కన్తు యీశుస్తదాపి నోత్తరం దదౌ తతః పీలాత ఆశ్చర్య్యం జగామ| ");
INSERT INTO santel_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","అపరఞ్చ కారాబద్ధే కస్తింశ్చిత్ జనే తన్మహోత్సవకాలే లోకై ర్యాచితే దేశాధిపతిస్తం మోచయతి| ");
INSERT INTO santel_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","యే చ పూర్వ్వముపప్లవమకార్షురుపప్లవే వధమపి కృతవన్తస్తేషాం మధ్యే తదానోం బరబ్బానామక ఏకో బద్ధ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","అతో హేతోః పూర్వ్వాపరీయాం రీతికథాం కథయిత్వా లోకా ఉచ్చైరువన్తః పీలాతస్య సమక్షం నివేదయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","తదా పీలాతస్తానాచఖ్యౌ తర్హి కిం యిహూదీయానాం రాజానం మోచయిష్యామి? యుష్మాభిః కిమిష్యతే? ");
INSERT INTO santel_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","యతః ప్రధానయాజకా ఈర్ష్యాత ఏవ యీశుం సమార్పయన్నితి స వివేద| ");
INSERT INTO santel_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","కిన్తు యథా బరబ్బాం మోచయతి తథా ప్రార్థయితుం ప్రధానయాజకా లోకాన్ ప్రవర్త్తయామాసుః| ");
INSERT INTO santel_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","అథ పీలాతః పునః పృష్టవాన్ తర్హి యం యిహూదీయానాం రాజేతి వదథ తస్య కిం కరిష్యామి యుష్మాభిః కిమిష్యతే? ");
INSERT INTO santel_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","తదా తే పునరపి ప్రోచ్చైః ప్రోచుస్తం క్రుశే వేధయ| ");
INSERT INTO santel_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","తస్మాత్ పీలాతః కథితవాన్ కుతః? స కిం కుకర్మ్మ కృతవాన్? కిన్తు తే పునశ్చ రువన్తో వ్యాజహ్రుస్తం క్రుశే వేధయ| ");
INSERT INTO santel_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","తదా పీలాతః సర్వ్వాల్లోకాన్ తోషయితుమిచ్ఛన్ బరబ్బాం మోచయిత్వా యీశుం కశాభిః ప్రహృత్య క్రుశే వేద్ధుం తం సమర్పయామ్బభూవ| ");
INSERT INTO santel_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","అనన్తరం సైన్యగణోఽట్టాలికామ్ అర్థాద్ అధిపతే ర్గృహం యీశుం నీత్వా సేనానివహం సమాహుయత్| ");
INSERT INTO santel_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","పశ్చాత్ తే తం ధూమలవర్ణవస్త్రం పరిధాప్య కణ్టకముకుటం రచయిత్వా శిరసి సమారోప్య ");
INSERT INTO santel_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","హే యిహూదీయానాం రాజన్ నమస్కార ఇత్యుక్త్వా తం నమస్కర్త్తామారేభిరే| ");
INSERT INTO santel_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","తస్యోత్తమాఙ్గే వేత్రాఘాతం చక్రుస్తద్గాత్రే నిష్ఠీవఞ్చ నిచిక్షిపుః, తథా తస్య సమ్ముఖే జానుపాతం ప్రణోముః ");
INSERT INTO santel_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ఇత్థముపహస్య ధూమ్రవర్ణవస్త్రమ్ ఉత్తార్య్య తస్య వస్త్రం తం పర్య్యధాపయన్ క్రుశే వేద్ధుం బహిర్నిన్యుశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","తతః పరం సేకన్దరస్య రుఫస్య చ పితా శిమోన్నామా కురీణీయలోక ఏకః కుతశ్చిద్ గ్రామాదేత్య పథి యాతి తం తే యీశోః క్రుశం వోఢుం బలాద్ దధ్నుః| ");
INSERT INTO santel_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","అథ గుల్గల్తా అర్థాత్ శిరఃకపాలనామకం స్థానం యీశుమానీయ ");
INSERT INTO santel_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","తే గన్ధరసమిశ్రితం ద్రాక్షారసం పాతుం తస్మై దదుః కిన్తు స న జగ్రాహ| ");
INSERT INTO santel_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","తస్మిన్ క్రుశే విద్ధే సతి తేషామేకైకశః కిం ప్రాప్స్యతీతి నిర్ణయాయ ");
INSERT INTO santel_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","తస్య పరిధేయానాం విభాగార్థం గుటికాపాతం చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","అపరమ్ ఏష యిహూదీయానాం రాజేతి లిఖితం దోషపత్రం తస్య శిరఊర్ద్వ్వమ్ ఆరోపయాఞ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","తస్య వామదక్షిణయో ర్ద్వౌ చౌరౌ క్రుశయో ర్వివిధాతే| ");
INSERT INTO santel_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","తేనైవ \"అపరాధిజనైః సార్ద్ధం స గణితో భవిష్యతి,\" ఇతి శాస్త్రోక్తం వచనం సిద్ధమభూత| ");
INSERT INTO santel_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","అనన్తరం మార్గే యే యే లోకా గమనాగమనే చక్రుస్తే సర్వ్వ ఏవ శిరాంస్యాన్దోల్య నిన్దన్తో జగదుః, రే మన్దిరనాశక రే దినత్రయమధ్యే తన్నిర్మ్మాయక, ");
INSERT INTO santel_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","అధునాత్మానమ్ అవిత్వా క్రుశాదవరోహ| ");
INSERT INTO santel_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","కిఞ్చ ప్రధానయాజకా అధ్యాపకాశ్చ తద్వత్ తిరస్కృత్య పరస్పరం చచక్షిరే ఏష పరానావత్ కిన్తు స్వమవితుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","యదీస్రాయేలో రాజాభిషిక్తస్త్రాతా భవతి తర్హ్యధునైన క్రుశాదవరోహతు వయం తద్ దృష్ట్వా విశ్వసిష్యామః; కిఞ్చ యౌ లోకౌ తేన సార్ద్ధం క్రుశే ఽవిధ్యేతాం తావపి తం నిర్భర్త్సయామాసతుః| ");
INSERT INTO santel_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","అథ ద్వితీయయామాత్ తృతీయయామం యావత్ సర్వ్వో దేశః సాన్ధకారోభూత్| ");
INSERT INTO santel_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","తతస్తృతీయప్రహరే యీశురుచ్చైరవదత్ ఏలీ ఏలీ లామా శివక్తనీ అర్థాద్ \"హే మదీశ మదీశ త్వం పర్య్యత్యాక్షీః కుతో హి మాం?\" ");
INSERT INTO santel_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","తదా సమీపస్థలోకానాం కేచిత్ తద్వాక్యం నిశమ్యాచఖ్యుః పశ్యైష ఏలియమ్ ఆహూయతి| ");
INSERT INTO santel_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","తత ఏకో జనో ధావిత్వాగత్య స్పఞ్జే ఽమ్లరసం పూరయిత్వా తం నడాగ్రే నిధాయ పాతుం తస్మై దత్త్వావదత్ తిష్ఠ ఏలియ ఏనమవరోహయితుమ్ ఏతి న వేతి పశ్యామి| ");
INSERT INTO santel_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","అథ యీశురుచ్చైః సమాహూయ ప్రాణాన్ జహౌ| ");
INSERT INTO santel_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","తదా మన్దిరస్య జవనికోర్ద్వ్వాదధఃర్య్యన్తా విదీర్ణా ద్విఖణ్డాభూత్| ");
INSERT INTO santel_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","కిఞ్చ ఇత్థముచ్చైరాహూయ ప్రాణాన్ త్యజన్తం తం దృష్ద్వా తద్రక్షణాయ నియుక్తో యః సేనాపతిరాసీత్ సోవదత్ నరోయమ్ ఈశ్వరపుత్ర ఇతి సత్యమ్| ");
INSERT INTO santel_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","తదానీం మగ్దలీనీ మరిసమ్ కనిష్ఠయాకూబో యోసేశ్చ మాతాన్యమరియమ్ శాలోమీ చ యాః స్త్రియో ");
INSERT INTO santel_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","గాలీల్ప్రదేశే యీశుం సేవిత్వా తదనుగామిన్యో జాతా ఇమాస్తదన్యాశ్చ యా అనేకా నార్యో యీశునా సార్ద్ధం యిరూశాలమమాయాతాస్తాశ్చ దూరాత్ తాని దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","అథాసాదనదినస్యార్థాద్ విశ్రామవారాత్ పూర్వ్వదినస్య సాయంకాల ఆగత ");
INSERT INTO santel_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ఈశ్వరరాజ్యాపేక్ష్యరిమథీయయూషఫనామా మాన్యమన్త్రీ సమేత్య పీలాతసవిధం నిర్భయో గత్వా యీశోర్దేహం యయాచే| ");
INSERT INTO santel_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","కిన్తు స ఇదానీం మృతః పీలాత ఇత్యసమ్భవం మత్వా శతసేనాపతిమాహూయ స కదా మృత ఇతి పప్రచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","శతసేమనాపతిముఖాత్ తజ్జ్ఞాత్వా యూషఫే యీశోర్దేహం దదౌ| ");
INSERT INTO santel_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","పశ్చాత్ స సూక్ష్మం వాసః క్రీత్వా యీశోః కాయమవరోహ్య తేన వాససా వేష్టాయిత్వా గిరౌ ఖాతశ్మశానే స్థాపితవాన్ పాషాణం లోఠయిత్వా ద్వారి నిదధే| ");
INSERT INTO santel_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","కిన్తు యత్ర సోస్థాప్యత తత మగ్దలీనీ మరియమ్ యోసిమాతృమరియమ్ చ దదృశతృః| ");
INSERT INTO santel_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","అథ విశ్రామవారే గతే మగ్దలీనీ మరియమ్ యాకూబమాతా మరియమ్ శాలోమీ చేమాస్తం మర్ద్దయితుం సుగన్ధిద్రవ్యాణి క్రీత్వా ");
INSERT INTO santel_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","సప్తాహప్రథమదినేఽతిప్రత్యూషే సూర్య్యోదయకాలే శ్మశానముపగతాః| ");
INSERT INTO santel_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","కిన్తు శ్మశానద్వారపాషాణోఽతిబృహన్ తం కోఽపసారయిష్యతీతి తాః పరస్పరం గదన్తి! ");
INSERT INTO santel_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ఏతర్హి నిరీక్ష్య పాషాణో ద్వారో ఽపసారిత ఇతి దదృశుః| ");
INSERT INTO santel_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","పశ్చాత్తాః శ్మశానం ప్రవిశ్య శుక్లవర్ణదీర్ఘపరిచ్ఛదావృతమేకం యువానం శ్మశానదక్షిణపార్శ్వ ఉపవిష్టం దృష్ట్వా చమచ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","సోఽవదత్, మాభైష్ట యూయం క్రుశే హతం నాసరతీయయీశుం గవేషయథ సోత్ర నాస్తి శ్మశానాదుదస్థాత్; తై ర్యత్ర స స్థాపితః స్థానం తదిదం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","కిన్తు తేన యథోక్తం తథా యుష్మాకమగ్రే గాలీలం యాస్యతే తత్ర స యుష్మాన్ సాక్షాత్ కరిష్యతే యూయం గత్వా తస్య శిష్యేభ్యః పితరాయ చ వార్త్తామిమాం కథయత| ");
INSERT INTO santel_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","తాః కమ్పితా విస్తితాశ్చ తూర్ణం శ్మశానాద్ బహిర్గత్వా పలాయన్త భయాత్ కమపి కిమపి నావదంశ్చ| ");
INSERT INTO santel_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","అపరం యీశుః సప్తాహప్రథమదినే ప్రత్యూషే శ్మశానాదుత్థాయ యస్యాః సప్తభూతాస్త్యాజితాస్తస్యై మగ్దలీనీమరియమే ప్రథమం దర్శనం దదౌ| ");
INSERT INTO santel_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","తతః సా గత్వా శోకరోదనకృద్భ్యోఽనుగతలోకేభ్యస్తాం వార్త్తాం కథయామాస| ");
INSERT INTO santel_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","కిన్తు యీశుః పునర్జీవన్ తస్యై దర్శనం దత్తవానితి శ్రుత్వా తే న ప్రత్యయన్| ");
INSERT INTO santel_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","పశ్చాత్ తేషాం ద్వాయో ర్గ్రామయానకాలే యీశురన్యవేశం ధృత్వా తాభ్యాం దర్శన దదౌ! ");
INSERT INTO santel_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","తావపి గత్వాన్యశిష్యేభ్యస్తాం కథాం కథయాఞ్చక్రతుః కిన్తు తయోః కథామపి తే న ప్రత్యయన్| ");
INSERT INTO santel_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","శేషత ఏకాదశశిష్యేషు భోజనోపవిష్టేషు యీశుస్తేభ్యో దర్శనం దదౌ తథోత్థానాత్ పరం తద్దర్శనప్రాప్తలోకానాం కథాయామవిశ్వాసకరణాత్ తేషామవిశ్వాసమనఃకాఠిన్యాభ్యాం హేతుభ్యాం స తాంస్తర్జితవాన్| ");
INSERT INTO santel_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","అథ తానాచఖ్యౌ యూయం సర్వ్వజగద్ గత్వా సర్వ్వజనాన్ ప్రతి సుసంవాదం ప్రచారయత| ");
INSERT INTO santel_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","తత్ర యః కశ్చిద్ విశ్వస్య మజ్జితో భవేత్ స పరిత్రాస్యతే కిన్తు యో న విశ్వసిష్యతి స దణ్డయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","కిఞ్చ యే ప్రత్యేష్యన్తి తైరీదృగ్ ఆశ్చర్య్యం కర్మ్మ ప్రకాశయిష్యతే తే మన్నామ్నా భూతాన్ త్యాజయిష్యన్తి భాషా అన్యాశ్చ వదిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","అపరం తైః సర్పేషు ధృతేషు ప్రాణనాశకవస్తుని పీతే చ తేషాం కాపి క్షతి ర్న భవిష్యతి; రోగిణాం గాత్రేషు కరార్పితే తేఽరోగా భవిష్యన్తి చ| ");
INSERT INTO santel_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","అథ ప్రభుస్తానిత్యాదిశ్య స్వర్గం నీతః సన్ పరమేశ్వరస్య దక్షిణ ఉపవివేశ| ");
INSERT INTO santel_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","తతస్తే ప్రస్థాయ సర్వ్వత్ర సుసంవాదీయకథాం ప్రచారయితుమారేభిరే ప్రభుస్తు తేషాం సహాయః సన్ ప్రకాశితాశ్చర్య్యక్రియాభిస్తాం కథాం ప్రమాణవతీం చకార| ఇతి|");
INSERT INTO santel_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ప్రథమతో యే సాక్షిణో వాక్యప్రచారకాశ్చాసన్ తేఽస్మాకం మధ్యే యద్యత్ సప్రమాణం వాక్యమర్పయన్తి స్మ ");
INSERT INTO santel_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","తదనుసారతోఽన్యేపి బహవస్తద్వృత్తాన్తం రచయితుం ప్రవృత్తాః| ");
INSERT INTO santel_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","అతఏవ హే మహామహిమథియఫిల్ త్వం యా యాః కథా అశిక్ష్యథాస్తాసాం దృఢప్రమాణాని యథా ప్రాప్నోషి ");
INSERT INTO santel_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","తదర్థం ప్రథమమారభ్య తాని సర్వ్వాణి జ్ఞాత్వాహమపి అనుక్రమాత్ సర్వ్వవృత్తాన్తాన్ తుభ్యం లేఖితుం మతిమకార్షమ్| ");
INSERT INTO santel_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","యిహూదాదేశీయహేరోద్నామకే రాజత్వం కుర్వ్వతి అబీయయాజకస్య పర్య్యాయాధికారీ సిఖరియనామక ఏకో యాజకో హారోణవంశోద్భవా ఇలీశేవాఖ్యా ");
INSERT INTO santel_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","తస్య జాయా ద్వావిమౌ నిర్దోషౌ ప్రభోః సర్వ్వాజ్ఞా వ్యవస్థాశ్చ సంమన్య ఈశ్వరదృష్టౌ ధార్మ్మికావాస్తామ్| ");
INSERT INTO santel_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","తయోః సన్తాన ఏకోపి నాసీత్, యత ఇలీశేవా బన్ధ్యా తౌ ద్వావేవ వృద్ధావభవతామ్| ");
INSERT INTO santel_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","యదా స్వపర్య్యానుక్రమేణ సిఖరియ ఈశ్వాస్య సమక్షం యాజకీయం కర్మ్మ కరోతి ");
INSERT INTO santel_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","తదా యజ్ఞస్య దినపరిపాయ్యా పరమేశ్వరస్య మన్దిరే ప్రవేశకాలే ధూపజ్వాలనం కర్మ్మ తస్య కరణీయమాసీత్| ");
INSERT INTO santel_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","తద్ధూపజ్వాలనకాలే లోకనివహే ప్రార్థనాం కర్తుం బహిస్తిష్ఠతి ");
INSERT INTO santel_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","సతి సిఖరియో యస్యాం వేద్యాం ధూపం జ్వాలయతి తద్దక్షిణపార్శ్వే పరమేశ్వరస్య దూత ఏక ఉపస్థితో దర్శనం దదౌ| ");
INSERT INTO santel_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","తం దృష్ట్వా సిఖరియ ఉద్వివిజే శశఙ్కే చ| ");
INSERT INTO santel_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","తదా స దూతస్తం బభాషే హే సిఖరియ మా భైస్తవ ప్రార్థనా గ్రాహ్యా జాతా తవ భార్య్యా ఇలీశేవా పుత్రం ప్రసోష్యతే తస్య నామ యోेహన్ ఇతి కరిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","కిఞ్చ త్వం సానన్దః సహర్షశ్చ భవిష్యసి తస్య జన్మని బహవ ఆనన్దిష్యన్తి చ| ");
INSERT INTO santel_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","యతో హేతోః స పరమేశ్వరస్య గోచరే మహాన్ భవిష్యతి తథా ద్రాక్షారసం సురాం వా కిమపి న పాస్యతి, అపరం జన్మారభ్య పవిత్రేణాత్మనా పరిపూర్ణః ");
INSERT INTO santel_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","సన్ ఇస్రాయేల్వంశీయాన్ అనేకాన్ ప్రభోః పరమేశ్వరస్య మార్గమానేష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","సన్తానాన్ ప్రతి పితృణాం మనాంసి ధర్మ్మజ్ఞానం ప్రత్యనాజ్ఞాగ్రాహిణశ్చ పరావర్త్తయితుం, ప్రభోః పరమేశ్వరస్య సేవార్థమ్ ఏకాం సజ్జితజాతిం విధాతుఞ్చ స ఏలియరూపాత్మశక్తిప్రాప్తస్తస్యాగ్రే గమిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","తదా సిఖరియో దూతమవాదీత్ కథమేతద్ వేత్స్యామి? యతోహం వృద్ధో మమ భార్య్యా చ వృద్ధా| ");
INSERT INTO santel_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","తతో దూతః ప్రత్యువాచ పశ్యేశ్వరస్య సాక్షాద్వర్త్తీ జిబ్రాయేల్నామా దూతోహం త్వయా సహ కథాం గదితుం తుభ్యమిమాం శుభవార్త్తాం దాతుఞ్చ ప్రేషితః| ");
INSERT INTO santel_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","కిన్తు మదీయం వాక్యం కాలే ఫలిష్యతి తత్ త్వయా న ప్రతీతమ్ అతః కారణాద్ యావదేవ తాని న సేత్స్యన్తి తావత్ త్వం వక్తుంమశక్తో మూకో భవ| ");
INSERT INTO santel_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","తదానీం యే యే లోకాః సిఖరియమపైక్షన్త తే మధ్యేమన్దిరం తస్య బహువిలమ్బాద్ ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","స బహిరాగతో యదా కిమపి వాక్యం వక్తుమశక్తః సఙ్కేతం కృత్వా నిఃశబ్దస్తస్యౌ తదా మధ్యేమన్దిరం కస్యచిద్ దర్శనం తేన ప్రాప్తమ్ ఇతి సర్వ్వే బుబుధిరే| ");
INSERT INTO santel_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","అనన్తరం తస్య సేవనపర్య్యాయే సమ్పూర్ణే సతి స నిజగేహం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","కతిపయదినేషు గతేషు తస్య భార్య్యా ఇలీశేవా గర్బ్భవతీ బభూవ ");
INSERT INTO santel_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","పశ్చాత్ సా పఞ్చమాసాన్ సంగోప్యాకథయత్ లోకానాం సమక్షం మమాపమానం ఖణ్డయితుం పరమేశ్వరో మయి దృష్టిం పాతయిత్వా కర్మ్మేదృశం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","అపరఞ్చ తస్యా గర్బ్భస్య షష్ఠే మాసే జాతే గాలీల్ప్రదేశీయనాసరత్పురే ");
INSERT INTO santel_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","దాయూదో వంశీయాయ యూషఫ్నామ్నే పురుషాయ యా మరియమ్నామకుమారీ వాగ్దత్తాసీత్ తస్యాః సమీపం జిబ్రాయేల్ దూత ఈశ్వరేణ ప్రహితః| ");
INSERT INTO santel_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","స గత్వా జగాద హే ఈశ్వరానుగృహీతకన్యే తవ శుభం భూయాత్ ప్రభుః పరమేశ్వరస్తవ సహాయోస్తి నారీణాం మధ్యే త్వమేవ ధన్యా| ");
INSERT INTO santel_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","తదానీం సా తం దృష్ట్వా తస్య వాక్యత ఉద్విజ్య కీదృశం భాషణమిదమ్ ఇతి మనసా చిన్తయామాస| ");
INSERT INTO santel_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","తతో దూతోఽవదత్ హే మరియమ్ భయం మాకార్షీః, త్వయి పరమేశ్వరస్యానుగ్రహోస్తి| ");
INSERT INTO santel_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","పశ్య త్వం గర్బ్భం ధృత్వా పుత్రం ప్రసోష్యసే తస్య నామ యీశురితి కరిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","స మహాన్ భవిష్యతి తథా సర్వ్వేభ్యః శ్రేష్ఠస్య పుత్ర ఇతి ఖ్యాస్యతి; అపరం ప్రభుః పరమేశ్వరస్తస్య పితుర్దాయూదః సింహాసనం తస్మై దాస్యతి; ");
INSERT INTO santel_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","తథా స యాకూబో వంశోపరి సర్వ్వదా రాజత్వం కరిష్యతి, తస్య రాజత్వస్యాన్తో న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","తదా మరియమ్ తం దూతం బభాషే నాహం పురుషసఙ్గం కరోమి తర్హి కథమేతత్ సమ్భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","తతో దూతోఽకథయత్ పవిత్ర ఆత్మా త్వామాశ్రాయిష్యతి తథా సర్వ్వశ్రేష్ఠస్య శక్తిస్తవోపరి ఛాయాం కరిష్యతి తతో హేతోస్తవ గర్బ్భాద్ యః పవిత్రబాలకో జనిష్యతే స ఈశ్వరపుత్ర ఇతి ఖ్యాతిం ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","అపరఞ్చ పశ్య తవ జ్ఞాతిరిలీశేవా యాం సర్వ్వే బన్ధ్యామవదన్ ఇదానీం సా వార్ద్ధక్యే సన్తానమేకం గర్బ్భేఽధారయత్ తస్య షష్ఠమాసోభూత్| ");
INSERT INTO santel_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","కిమపి కర్మ్మ నాసాధ్యమ్ ఈశ్వరస్య| ");
INSERT INTO santel_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","తదా మరియమ్ జగాద, పశ్య ప్రభేరహం దాసీ మహ్యం తవ వాక్యానుసారేణ సర్వ్వమేతద్ ఘటతామ్; అననతరం దూతస్తస్యాః సమీపాత్ ప్రతస్థే| ");
INSERT INTO santel_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","అథ కతిపయదినాత్ పరం మరియమ్ తస్మాత్ పర్వ్వతమయప్రదేశీయయిహూదాయా నగరమేకం శీఘ్రం గత్వా ");
INSERT INTO santel_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","సిఖరియయాజకస్య గృహం ప్రవిశ్య తస్య జాయామ్ ఇలీశేవాం సమ్బోధ్యావదత్| ");
INSERT INTO santel_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","తతో మరియమః సమ్బోధనవాక్యే ఇలీశేవాయాః కర్ణయోః ప్రవిష్టమాత్రే సతి తస్యా గర్బ్భస్థబాలకో ననర్త్త| తత ఇలీశేవా పవిత్రేణాత్మనా పరిపూర్ణా సతీ ");
INSERT INTO santel_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ప్రోచ్చైర్గదితుమారేభే, యోషితాం మధ్యే త్వమేవ ధన్యా, తవ గర్బ్భస్థః శిశుశ్చ ధన్యః| ");
INSERT INTO santel_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","త్వం ప్రభోర్మాతా, మమ నివేశనే త్వయా చరణావర్పితౌ, మమాద్య సౌభాగ్యమేతత్| ");
INSERT INTO santel_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","పశ్య తవ వాక్యే మమ కర్ణయోః ప్రవిష్టమాత్రే సతి మమోదరస్థః శిశురానన్దాన్ ననర్త్త| ");
INSERT INTO santel_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","యా స్త్రీ వ్యశ్వసీత్ సా ధన్యా, యతో హేతోస్తాం ప్రతి పరమేశ్వరోక్తం వాక్యం సర్వ్వం సిద్ధం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","తదానీం మరియమ్ జగాద| ధన్యవాదం పరేశస్య కరోతి మామకం మనః| ");
INSERT INTO santel_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","మమాత్మా తారకేశే చ సముల్లాసం ప్రగచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","అకరోత్ స ప్రభు ర్దుష్టిం స్వదాస్యా దుర్గతిం ప్రతి| పశ్యాద్యారభ్య మాం ధన్యాం వక్ష్యన్తి పురుషాః సదా| ");
INSERT INTO santel_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","యః సర్వ్వశక్తిమాన్ యస్య నామాపి చ పవిత్రకం| స ఏవ సుమహత్కర్మ్మ కృతవాన్ మన్నిమిత్తకం| ");
INSERT INTO santel_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","యే బిభ్యతి జనాస్తస్మాత్ తేషాం సన్తానపంక్తిషు| అనుకమ్పా తదీయా చ సర్వ్వదైవ సుతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","స్వబాహుబలతస్తేన ప్రాకాశ్యత పరాక్రమః| మనఃకుమన్త్రణాసార్ద్ధం వికీర్య్యన్తేఽభిమానినః| ");
INSERT INTO santel_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","సింహాసనగతాల్లోకాన్ బలినశ్చావరోహ్య సః| పదేషూచ్చేషు లోకాంస్తు క్షుద్రాన్ సంస్థాపయత్యపి| ");
INSERT INTO santel_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","క్షుధితాన్ మానవాన్ ద్రవ్యైరుత్తమైః పరితర్ప్య సః| సకలాన్ ధనినో లోకాన్ విసృజేద్ రిక్తహస్తకాన్| ");
INSERT INTO santel_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ఇబ్రాహీమి చ తద్వంశే యా దయాస్తి సదైవ తాం| స్మృత్వా పురా పితృణాం నో యథా సాక్షాత్ ప్రతిశ్రుతం| ");
INSERT INTO santel_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ఇస్రాయేల్సేవకస్తేన తథోపక్రియతే స్వయం|| ");
INSERT INTO santel_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","అనన్తరం మరియమ్ ప్రాయేణ మాసత్రయమ్ ఇలీశేవయా సహోషిత్వా వ్యాఘుయ్య నిజనివేశనం యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","తదనన్తరమ్ ఇలీశేవాయాః ప్రసవకాల ఉపస్థితే సతి సా పుత్రం ప్రాసోష్ట| ");
INSERT INTO santel_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","తతః పరమేశ్వరస్తస్యాం మహానుగ్రహం కృతవాన్ ఏతత్ శ్రుత్వా సమీపవాసినః కుటుమ్బాశ్చాగత్య తయా సహ ముముదిరే| ");
INSERT INTO santel_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","తథాష్టమే దినే తే బాలకస్య త్వచం ఛేత్తుమ్ ఏత్య తస్య పితృనామానురూపం తన్నామ సిఖరియ ఇతి కర్త్తుమీషుః| ");
INSERT INTO santel_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","కిన్తు తస్య మాతాకథయత్ తన్న, నామాస్య యోహన్ ఇతి కర్త్తవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","తదా తే వ్యాహరన్ తవ వంశమధ్యే నామేదృశం కస్యాపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","తతః పరం తస్య పితరం సిఖరియం ప్రతి సఙ్కేత్య పప్రచ్ఛుః శిశోః కిం నామ కారిష్యతే? ");
INSERT INTO santel_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","తతః స ఫలకమేకం యాచిత్వా లిలేఖ తస్య నామ యోహన్ భవిష్యతి| తస్మాత్ సర్వ్వే ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","తత్క్షణం సిఖరియస్య జిహ్వాజాడ్యేఽపగతే స ముఖం వ్యాదాయ స్పష్టవర్ణముచ్చార్య్య ఈశ్వరస్య గుణానువాదం చకార| ");
INSERT INTO santel_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","తస్మాచ్చతుర్దిక్స్థాః సమీపవాసిలోకా భీతా ఏవమేతాః సర్వ్వాః కథా యిహూదాయాః పర్వ్వతమయప్రదేశస్య సర్వ్వత్ర ప్రచారితాః| ");
INSERT INTO santel_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","తస్మాత్ శ్రోతారో మనఃసు స్థాపయిత్వా కథయామ్బభూవుః కీదృశోయం బాలో భవిష్యతి? అథ పరమేశ్వరస్తస్య సహాయోభూత్| ");
INSERT INTO santel_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","తదా యోహనః పితా సిఖరియః పవిత్రేణాత్మనా పరిపూర్ణః సన్ ఏతాదృశం భవిష్యద్వాక్యం కథయామాస| ");
INSERT INTO santel_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ఇస్రాయేలః ప్రభు ర్యస్తు స ధన్యః పరమేశ్వరః| అనుగృహ్య నిజాల్లోకాన్ స ఏవ పరిమోచయేత్| ");
INSERT INTO santel_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","విపక్షజనహస్తేభ్యో యథా మోచ్యామహే వయం| యావజ్జీవఞ్చ ధర్మ్మేణ సారల్యేన చ నిర్భయాః| ");
INSERT INTO santel_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","సేవామహై తమేవైకమ్ ఏతత్కారణమేవ చ| స్వకీయం సుపవిత్రఞ్చ సంస్మృత్య నియమం సదా| ");
INSERT INTO santel_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","కృపయా పురుషాన్ పూర్వ్వాన్ నికషార్థాత్తు నః పితుః| ఇబ్రాహీమః సమీపే యం శపథం కృతవాన్ పురా| ");
INSERT INTO santel_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","తమేవ సఫలం కర్త్తం తథా శత్రుగణస్య చ| ఋृతీయాకారిణశ్చైవ కరేభ్యో రక్షణాయ నః| ");
INSERT INTO santel_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","సృష్టేః ప్రథమతః స్వీయైః పవిత్రై ర్భావివాదిభిః| ");
INSERT INTO santel_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","యథోక్తవాన్ తథా స్వస్య దాయూదః సేవకస్య తు| ");
INSERT INTO santel_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","వంశే త్రాతారమేకం స సముత్పాదితవాన్ స్వయమ్| ");
INSERT INTO santel_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","అతో హే బాలక త్వన్తు సర్వ్వేభ్యః శ్రేష్ఠ ఏవ యః| తస్యైవ భావివాదీతి ప్రవిఖ్యాతో భవిష్యసి| అస్మాకం చరణాన్ క్షేమే మార్గే చాలయితుం సదా| ఏవం ధ్వాన్తేఽర్థతో మృత్యోశ్ఛాయాయాం యే తు మానవాః| ");
INSERT INTO santel_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ఉపవిష్టాస్తు తానేవ ప్రకాశయితుమేవ హి| కృత్వా మహానుకమ్పాం హి యామేవ పరమేశ్వరః| ");
INSERT INTO santel_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ఊర్ద్వ్వాత్ సూర్య్యముదాయ్యైవాస్మభ్యం ప్రాదాత్తు దర్శనం| తయానుకమ్పయా స్వస్య లోకానాం పాపమోచనే| ");
INSERT INTO santel_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","పరిత్రాణస్య తేభ్యో హి జ్ఞానవిశ్రాణనాయ చ| ప్రభో ర్మార్గం పరిష్కర్త్తుం తస్యాగ్రాయీ భవిష్యసి|| ");
INSERT INTO santel_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","అథ బాలకః శరీరేణ బుద్ధ్యా చ వర్ద్ధితుమారేభే; అపరఞ్చ స ఇస్రాయేలో వంశీయలోకానాం సమీపే యావన్న ప్రకటీభూతస్తాస్తావత్ ప్రాన్తరే న్యవసత్| ");
INSERT INTO santel_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","అపరఞ్చ తస్మిన్ కాలే రాజ్యస్య సర్వ్వేషాం లోకానాం నామాని లేఖయితుమ్ అగస్తకైసర ఆజ్ఞాపయామాస| ");
INSERT INTO santel_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","తదనుసారేణ కురీణియనామని సురియాదేశస్య శాసకే సతి నామలేఖనం ప్రారేభే| ");
INSERT INTO santel_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","అతో హేతో ర్నామ లేఖితుం సర్వ్వే జనాః స్వీయం స్వీయం నగరం జగ్ముః| ");
INSERT INTO santel_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","తదానీం యూషఫ్ నామ లేఖితుం వాగ్దత్తయా స్వభార్య్యయా గర్బ్భవత్యా మరియమా సహ స్వయం దాయూదః సజాతివంశ ఇతి కారణాద్ గాలీల్ప్రదేశస్య నాసరత్నగరాద్ ");
INSERT INTO santel_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","యిహూదాప్రదేశస్య బైత్లేహమాఖ్యం దాయూద్నగరం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","అన్యచ్చ తత్ర స్థానే తయోస్తిష్ఠతోః సతో ర్మరియమః ప్రసూతికాల ఉపస్థితే ");
INSERT INTO santel_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","సా తం ప్రథమసుతం ప్రాసోష్ట కిన్తు తస్మిన్ వాసగృహే స్థానాభావాద్ బాలకం వస్త్రేణ వేష్టయిత్వా గోశాలాయాం స్థాపయామాస| ");
INSERT INTO santel_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","అనన్తరం యే కియన్తో మేషపాలకాః స్వమేషవ్రజరక్షాయై తత్ప్రదేశే స్థిత్వా రజన్యాం ప్రాన్తరే ప్రహరిణః కర్మ్మ కుర్వ్వన్తి, ");
INSERT INTO santel_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","తేషాం సమీపం పరమేశ్వరస్య దూత ఆగత్యోపతస్థౌ; తదా చతుష్పార్శ్వే పరమేశ్వరస్య తేజసః ప్రకాశితత్వాత్ తేఽతిశశఙ్కిరే| ");
INSERT INTO santel_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","తదా స దూత ఉవాచ మా భైష్ట పశ్యతాద్య దాయూదః పురే యుష్మన్నిమిత్తం త్రాతా ప్రభుః ఖ్రీష్టోఽజనిష్ట, ");
INSERT INTO santel_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","సర్వ్వేషాం లోకానాం మహానన్దజనకమ్ ఇమం మఙ్గలవృత్తాన్తం యుష్మాన్ జ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","యూయం (తత్స్థానం గత్వా) వస్త్రవేష్టితం తం బాలకం గోశాలాయాం శయనం ద్రక్ష్యథ యుష్మాన్ ప్రతీదం చిహ్నం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","దూత ఇమాం కథాం కథితవతి తత్రాకస్మాత్ స్వర్గీయాః పృతనా ఆగత్య కథామ్ ఇమాం కథయిత్వేశ్వరస్య గుణానన్వవాదిషుః, యథా, ");
INSERT INTO santel_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","సర్వ్వోర్ద్వ్వస్థైరీశ్వరస్య మహిమా సమ్ప్రకాశ్యతాం| శాన్తిర్భూయాత్ పృథివ్యాస్తు సన్తోషశ్చ నరాన్ ప్రతి|| ");
INSERT INTO santel_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","తతః పరం తేషాం సన్నిధే ర్దూతగణే స్వర్గం గతే మేషపాలకాః పరస్పరమ్ అవేచన్ ఆగచ్ఛత ప్రభుః పరమేశ్వరో యాం ఘటనాం జ్ఞాపితవాన్ తస్యా యాథర్యం జ్ఞాతుం వయమధునా బైత్లేహమ్పురం యామః| ");
INSERT INTO santel_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","పశ్చాత్ తే తూర్ణం వ్రజిత్వా మరియమం యూషఫం గోశాలాయాం శయనం బాలకఞ్చ దదృశుః| ");
INSERT INTO santel_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ఇత్థం దృష్ట్వా బాలకస్యార్థే ప్రోక్తాం సర్వ్వకథాం తే ప్రాచారయాఞ్చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","తతో యే లోకా మేషరక్షకాణాం వదనేభ్యస్తాం వార్త్తాం శుశ్రువుస్తే మహాశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","కిన్తు మరియమ్ ఏతత్సర్వ్వఘటనానాం తాత్పర్య్యం వివిచ్య మనసి స్థాపయామాస| ");
INSERT INTO santel_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","తత్పశ్చాద్ దూతవిజ్ఞప్తానురూపం శ్రుత్వా దృష్ట్వా చ మేషపాలకా ఈశ్వరస్య గుణానువాదం ధన్యవాదఞ్చ కుర్వ్వాణాః పరావృత్య యయుః| ");
INSERT INTO santel_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","అథ బాలకస్య త్వక్ఛేదనకాలేఽష్టమదివసే సముపస్థితే తస్య గర్బ్భస్థితేః పుర్వ్వం స్వర్గీయదూతో యథాజ్ఞాపయత్ తదనురూపం తే తన్నామధేయం యీశురితి చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","తతః పరం మూసాలిఖితవ్యవస్థాయా అనుసారేణ మరియమః శుచిత్వకాల ఉపస్థితే, ");
INSERT INTO santel_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ప్రథమజః సర్వ్వః పురుషసన్తానః పరమేశ్వరే సమర్ప్యతాం,\" ఇతి పరమేశ్వరస్య వ్యవస్థయా ");
INSERT INTO santel_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","యీశుం పరమేశ్వరే సమర్పయితుమ్ శాస్త్రీయవిధ్యుక్తం కపోతద్వయం పారావతశావకద్వయం వా బలిం దాతుం తే తం గృహీత్వా యిరూశాలమమ్ ఆయయుః| ");
INSERT INTO santel_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","యిరూశాలమ్పురనివాసీ శిమియోన్నామా ధార్మ్మిక ఏక ఆసీత్ స ఇస్రాయేలః సాన్త్వనామపేక్ష్య తస్థౌ కిఞ్చ పవిత్ర ఆత్మా తస్మిన్నావిర్భూతః| ");
INSERT INTO santel_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","అపరం ప్రభుణా పరమేశ్వరేణాభిషిక్తే త్రాతరి త్వయా న దృష్టే త్వం న మరిష్యసీతి వాక్యం పవిత్రేణ ఆత్మనా తస్మ ప్రాకథ్యత| ");
INSERT INTO santel_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","అపరఞ్చ యదా యీశోః పితా మాతా చ తదర్థం వ్యవస్థానురూపం కర్మ్మ కర్త్తుం తం మన్దిరమ్ ఆనిన్యతుస్తదా ");
INSERT INTO santel_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","శిమియోన్ ఆత్మన ఆకర్షణేన మన్దిరమాగత్య తం క్రోడే నిధాయ ఈశ్వరస్య ధన్యవాదం కృత్వా కథయామాస, యథా, ");
INSERT INTO santel_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","హే ప్రభో తవ దాసోయం నిజవాక్యానుసారతః| ఇదానీన్తు సకల్యాణో భవతా సంవిసృజ్యతామ్| ");
INSERT INTO santel_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","యతః సకలదేశస్య దీప్తయే దీప్తిరూపకం| ");
INSERT INTO santel_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ఇస్రాయేలీయలోకస్య మహాగౌరవరూపకం| ");
INSERT INTO santel_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","యం త్రాయకం జనానాన్తు సమ్ముఖే త్వమజీజనః| సఏవ విద్యతేఽస్మాకం ధ్రవం నయననగోచరే|| ");
INSERT INTO santel_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","తదానీం తేనోక్తా ఏతాః సకలాః కథాః శ్రుత్వా తస్య మాతా యూషఫ్ చ విస్మయం మేనాతే| ");
INSERT INTO santel_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","తతః పరం శిమియోన్ తేభ్య ఆశిషం దత్త్వా తన్మాతరం మరియమమ్ ఉవాచ, పశ్య ఇస్రాయేలో వంశమధ్యే బహూనాం పాతనాయోత్థాపనాయ చ తథా విరోధపాత్రం భవితుం, బహూనాం గుప్తమనోగతానాం ప్రకటీకరణాయ బాలకోయం నియుక్తోస్తి| ");
INSERT INTO santel_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","తస్మాత్ తవాపి ప్రాణాః శూలేన వ్యత్స్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","అపరఞ్చ ఆశేరస్య వంశీయఫినూయేలో దుహితా హన్నాఖ్యా అతిజరతీ భవిష్యద్వాదిన్యేకా యా వివాహాత్ పరం సప్త వత్సరాన్ పత్యా సహ న్యవసత్ తతో విధవా భూత్వా చతురశీతివర్షవయఃపర్య్యనతం ");
INSERT INTO santel_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","మన్దిరే స్థిత్వా ప్రార్థనోపవాసైర్దివానిశమ్ ఈశ్వరమ్ అసేవత సాపి స్త్రీ తస్మిన్ సమయే మన్దిరమాగత్య ");
INSERT INTO santel_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","పరమేశ్వరస్య ధన్యవాదం చకార, యిరూశాలమ్పురవాసినో యావన్తో లోకా ముక్తిమపేక్ష్య స్థితాస్తాన్ యీశోర్వృత్తాన్తం జ్ఞాపయామాస| ");
INSERT INTO santel_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ఇత్థం పరమేశ్వరస్య వ్యవస్థానుసారేణ సర్వ్వేషు కర్మ్మసు కృతేషు తౌ పునశ్చ గాలీలో నాసరత్నామకం నిజనగరం ప్రతస్థాతే| ");
INSERT INTO santel_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","తత్పశ్చాద్ బాలకః శరీరేణ వృద్ధిమేత్య జ్ఞానేన పరిపూర్ణ ఆత్మనా శక్తిమాంశ్చ భవితుమారేభే తథా తస్మిన్ ఈశ్వరానుగ్రహో బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","తస్య పితా మాతా చ ప్రతివర్షం నిస్తారోత్సవసమయే యిరూశాలమమ్ అగచ్ఛతామ్| ");
INSERT INTO santel_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","అపరఞ్చ యీశౌ ద్వాదశవర్షవయస్కే సతి తౌ పర్వ్వసమయస్య రీత్యనుసారేణ యిరూశాలమం గత్వా ");
INSERT INTO santel_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","పార్వ్వణం సమ్పాద్య పునరపి వ్యాఘుయ్య యాతః కిన్తు యీశుర్బాలకో యిరూశాలమి తిష్ఠతి| యూషఫ్ తన్మాతా చ తద్ అవిదిత్వా ");
INSERT INTO santel_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","స సఙ్గిభిః సహ విద్యత ఏతచ్చ బుద్వ్వా దినైకగమ్యమార్గం జగ్మతుః| కిన్తు శేషే జ్ఞాతిబన్ధూనాం సమీపే మృగయిత్వా తదుద్దేेశమప్రాప్య ");
INSERT INTO santel_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","తౌ పునరపి యిరూశాలమమ్ పరావృత్యాగత్య తం మృగయాఞ్చక్రతుః| ");
INSERT INTO santel_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","అథ దినత్రయాత్ పరం పణ్డితానాం మధ్యే తేషాం కథాః శృణ్వన్ తత్త్వం పృచ్ఛంశ్చ మన్దిరే సముపవిష్టః స తాభ్యాం దృష్టః| ");
INSERT INTO santel_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","తదా తస్య బుద్ధ్యా ప్రత్యుత్తరైశ్చ సర్వ్వే శ్రోతారో విస్మయమాపద్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","తాదృశం దృష్ట్వా తస్య జనకో జననీ చ చమచ్చక్రతుః కిఞ్చ తస్య మాతా తమవదత్, హే పుత్ర, కథమావాం ప్రతీత్థం సమాచరస్త్వమ్? పశ్య తవ పితాహఞ్చ శోకాకులౌ సన్తౌ త్వామన్విచ్ఛావః స్మ| ");
INSERT INTO santel_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","తతః సోవదత్ కుతో మామ్ అన్వైచ్ఛతం? పితుర్గృహే మయా స్థాతవ్యమ్ ఏతత్ కిం యువాభ్యాం న జ్ఞాయతే? ");
INSERT INTO santel_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","కిన్తు తౌ తస్యైతద్వాక్యస్య తాత్పర్య్యం బోద్ధుం నాశక్నుతాం| ");
INSERT INTO santel_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","తతః పరం స తాభ్యాం సహ నాసరతం గత్వా తయోర్వశీభూతస్తస్థౌ కిన్తు సర్వ్వా ఏతాః కథాస్తస్య మాతా మనసి స్థాపయామాస| ");
INSERT INTO santel_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","అథ యీశో ర్బుద్ధిః శరీరఞ్చ తథా తస్మిన్ ఈశ్వరస్య మానవానాఞ్చానుగ్రహో వర్ద్ధితుమ్ ఆరేభే| ");
INSERT INTO santel_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","అనన్తరం తిబిరియకైసరస్య రాజత్వస్య పఞ్చదశే వత్సరే సతి యదా పన్తీయపీలాతో యిహూదాదేశాధిపతి ర్హేరోద్ తు గాలీల్ప్రదేశస్య రాజా ఫిలిపనామా తస్య భ్రాతా తు యితూరియాయాస్త్రాఖోనీతియాప్రదేశస్య చ రాజాసీత్ లుషానీయనామా అవిలీనీదేశస్య రాజాసీత్ ");
INSERT INTO santel_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","హానన్ కియఫాశ్చేమౌ ప్రధానయాజాకావాస్తాం తదానీం సిఖరియస్య పుత్రాయ యోహనే మధ్యేప్రాన్తరమ్ ఈశ్వరస్య వాక్యే ప్రకాశితే సతి ");
INSERT INTO santel_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","స యర్ద్దన ఉభయతటప్రదేశాన్ సమేత్య పాపమోచనార్థం మనఃపరావర్త్తనస్య చిహ్నరూపం యన్మజ్జనం తదీయాః కథాః సర్వ్వత్ర ప్రచారయితుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","యిశయియభవిష్యద్వక్తృగ్రన్థే యాదృశీ లిపిరాస్తే యథా, పరమేశస్య పన్థానం పరిష్కురుత సర్వ్వతః| తస్య రాజపథఞ్చైవ సమానం కురుతాధునా| ");
INSERT INTO santel_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","కారిష్యన్తే సముచ్ఛ్రాయాః సకలా నిమ్నభూమయః| కారిష్యన్తే నతాః సర్వ్వే పర్వ్వతాశ్చోపపర్వ్వతాః| కారిష్యన్తే చ యా వక్రాస్తాః సర్వ్వాః సరలా భువః| కారిష్యన్తే సమానాస్తా యా ఉచ్చనీచభూమయః| ");
INSERT INTO santel_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ఈశ్వరేణ కృతం త్రాణం ద్రక్ష్యన్తి సర్వ్వమానవాః| ఇత్యేతత్ ప్రాన్తరే వాక్యం వదతః కస్యచిద్ రవః|| ");
INSERT INTO santel_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","యే యే లోకా మజ్జనార్థం బహిరాయయుస్తాన్ సోవదత్ రే రే సర్పవంశా ఆగామినః కోపాత్ పలాయితుం యుష్మాన్ కశ్చేతయామాస? ");
INSERT INTO santel_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","తస్మాద్ ఇబ్రాహీమ్ అస్మాకం పితా కథామీదృశీం మనోభి ర్న కథయిత్వా యూయం మనఃపరివర్త్తనయోగ్యం ఫలం ఫలత; యుష్మానహం యథార్థం వదామి పాషాణేభ్య ఏతేభ్య ఈశ్వర ఇబ్రాహీమః సన్తానోత్పాదనే సమర్థః| ");
INSERT INTO santel_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","అపరఞ్చ తరుమూలేఽధునాపి పరశుః సంలగ్నోస్తి యస్తరురుత్తమం ఫలం న ఫలతి స ఛిద్యతేఽగ్నౌ నిక్షిప్యతే చ| ");
INSERT INTO santel_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","తదానీం లోకాస్తం పప్రచ్ఛుస్తర్హి కిం కర్త్తవ్యమస్మాభిః? ");
INSERT INTO santel_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","తతః సోవాదీత్ యస్య ద్వే వసనే విద్యేతే స వస్త్రహీనాయైకం వితరతు కింఞ్చ యస్య ఖాద్యద్రవ్యం విద్యతే సోపి తథైవ కరోతు| ");
INSERT INTO santel_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","తతః పరం కరసఞ్చాయినో మజ్జనార్థమ్ ఆగత్య పప్రచ్ఛుః హే గురో కిం కర్త్తవ్యమస్మాభిః? ");
INSERT INTO santel_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","తతః సోకథయత్ నిరూపితాదధికం న గృహ్లిత| ");
INSERT INTO santel_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","అనన్తరం సేనాగణ ఏత్య పప్రచ్ఛ కిమస్మాభి ర్వా కర్త్తవ్యమ్? తతః సోభిదధే కస్య కామపి హానిం మా కార్ష్ట తథా మృషాపవాదం మా కురుత నిజవేతనేన చ సన్తుష్య తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","అపరఞ్చ లోకా అపేక్షయా స్థిత్వా సర్వ్వేపీతి మనోభి ర్వితర్కయాఞ్చక్రుః, యోహనయమ్ అభిషిక్తస్త్రాతా న వేతి? ");
INSERT INTO santel_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","తదా యోహన్ సర్వ్వాన్ వ్యాజహార, జలేఽహం యుష్మాన్ మజ్జయామి సత్యం కిన్తు యస్య పాదుకాబన్ధనం మోచయితుమపి న యోగ్యోస్మి తాదృశ ఏకో మత్తో గురుతరః పుమాన్ ఏతి, స యుష్మాన్ వహ్నిరూపే పవిత్ర ఆత్మని మజ్జయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","అపరఞ్చ తస్య హస్తే శూర్ప ఆస్తే స స్వశస్యాని శుద్ధరూపం ప్రస్ఫోట్య గోధూమాన్ సర్వ్వాన్ భాణ్డాగారే సంగ్రహీష్యతి కిన్తు బూషాణి సర్వ్వాణ్యనిర్వ్వాణవహ్నినా దాహయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","యోహన్ ఉపదేశేనేత్థం నానాకథా లోకానాం సమక్షం ప్రచారయామాస| ");
INSERT INTO santel_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","అపరఞ్చ హేరోద్ రాజా ఫిలిప్నామ్నః సహోదరస్య భార్య్యాం హేరోదియామధి తథాన్యాని యాని యాని కుకర్మ్మాణి కృతవాన్ తదధి చ ");
INSERT INTO santel_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","యోహనా తిరస్కృతో భూత్వా కారాగారే తస్య బన్ధనాద్ అపరమపి కుకర్మ్మ చకార| ");
INSERT INTO santel_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ఇతః పూర్వ్వం యస్మిన్ సమయే సర్వ్వే యోహనా మజ్జితాస్తదానీం యీశురప్యాగత్య మజ్జితః| ");
INSERT INTO santel_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","తదనన్తరం తేన ప్రార్థితే మేఘద్వారం ముక్తం తస్మాచ్చ పవిత్ర ఆత్మా మూర్త్తిమాన్ భూత్వా కపోతవత్ తదుపర్య్యవరురోహ; తదా త్వం మమ ప్రియః పుత్రస్త్వయి మమ పరమః సన్తోష ఇత్యాకాశవాణీ బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","తదానీం యీశుః ప్రాయేణ త్రింశద్వర్షవయస్క ఆసీత్| లౌకికజ్ఞానే తు స యూషఫః పుత్రః, ");
INSERT INTO santel_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","యూషఫ్ ఏలేః పుత్రః, ఏలిర్మత్తతః పుత్రః, మత్తత్ లేవేః పుత్రః, లేవి ర్మల్కేః పుత్రః, మల్కిర్యాన్నస్య పుత్రః; యాన్నో యూషఫః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","యూషఫ్ మత్తథియస్య పుత్రః, మత్తథియ ఆమోసః పుత్రః, ఆమోస్ నహూమః పుత్రః, నహూమ్ ఇష్లేః పుత్రః ఇష్లిర్నగేః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","నగిర్మాటః పుత్రః, మాట్ మత్తథియస్య పుత్రః, మత్తథియః శిమియేః పుత్రః, శిమియిర్యూషఫః పుత్రః, యూషఫ్ యిహూదాః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","యిహూదా యోహానాః పుత్రః, యోహానా రీషాః పుత్రః, రీషాః సిరుబ్బాబిలః పుత్రః, సిరుబ్బాబిల్ శల్తీయేలః పుత్రః, శల్తీయేల్ నేరేః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","నేరిర్మల్కేః పుత్రః, మల్కిః అద్యః పుత్రః, అద్దీ కోషమః పుత్రః, కోషమ్ ఇల్మోదదః పుత్రః, ఇల్మోదద్ ఏరః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ఏర్ యోశేః పుత్రః, యోశిః ఇలీయేషరః పుత్రః, ఇలీయేషర్ యోరీమః పుత్రః, యోరీమ్ మత్తతః పుత్రః, మత్తత లేవేః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","లేవిః శిమియోనః పుత్రః, శిమియోన్ యిహూదాః పుత్రః, యిహూదా యూషుఫః పుత్రః, యూషుఫ్ యోననః పుత్రః, యానన్ ఇలీయాకీమః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ఇలియాకీమ్ః మిలేయాః పుత్రః, మిలేయా మైననః పుత్రః, మైనన్ మత్తత్తస్య పుత్రః, మత్తత్తో నాథనః పుత్రః, నాథన్ దాయూదః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","దాయూద్ యిశయః పుత్రః, యిశయ ఓబేదః పుత్ర, ఓబేద్ బోయసః పుత్రః, బోయస్ సల్మోనః పుత్రః, సల్మోన్ నహశోనః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","నహశోన్ అమ్మీనాదబః పుత్రః, అమ్మీనాదబ్ అరామః పుత్రః, అరామ్ హిష్రోణః పుత్రః, హిష్రోణ్ పేరసః పుత్రః, పేరస్ యిహూదాః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","యిహూదా యాకూబః పుత్రః, యాకూబ్ ఇస్హాకః పుత్రః, ఇస్హాక్ ఇబ్రాహీమః పుత్రః, ఇబ్రాహీమ్ తేరహః పుత్రః, తేరహ్ నాహోరః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","నాహోర్ సిరుగః పుత్రః, సిరుగ్ రియ్వః పుత్రః, రియూః పేలగః పుత్రః, పేలగ్ ఏవరః పుత్రః, ఏవర్ శేలహః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","శేలహ్ కైననః పుత్రః, కైనన్ అర్ఫక్షదః పుత్రః, అర్ఫక్షద్ శామః పుత్రః, శామ్ నోహః పుత్రః, నోహో లేమకః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","లేమక్ మిథూశేలహః పుత్రః, మిథూశేలహ్ హనోకః పుత్రః, హనోక్ యేరదః పుత్రః, యేరద్ మహలలేలః పుత్రః, మహలలేల్ కైననః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","కైనన్ ఇనోశః పుత్రః, ఇనోశ్ శేతః పుత్రః, శేత్ ఆదమః పుత్ర, ఆదమ్ ఈశ్వరస్య పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","తతః పరం యీశుః పవిత్రేణాత్మనా పూర్ణః సన్ యర్ద్దననద్యాః పరావృత్యాత్మనా ప్రాన్తరం నీతః సన్ చత్వారింశద్దినాని యావత్ శైతానా పరీక్షితోఽభూత్, ");
INSERT INTO santel_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","కిఞ్చ తాని సర్వ్వదినాని భోజనం వినా స్థితత్వాత్ కాలే పూర్ణే స క్షుధితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","తతః శైతానాగత్య తమవదత్ త్వం చేదీశ్వరస్య పుత్రస్తర్హి ప్రస్తరానేతాన్ ఆజ్ఞయా పూపాన్ కురు| ");
INSERT INTO santel_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","తదా యీశురువాచ, లిపిరీదృశీ విద్యతే మనుజః కేవలేన పూపేన న జీవతి కిన్త్వీశ్వరస్య సర్వ్వాభిరాజ్ఞాభి ర్జీవతి| ");
INSERT INTO santel_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","తదా శైతాన్ తముచ్చం పర్వ్వతం నీత్వా నిమిషైకమధ్యే జగతః సర్వ్వరాజ్యాని దర్శితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","పశ్చాత్ తమవాదీత్ సర్వ్వమ్ ఏతద్ విభవం ప్రతాపఞ్చ తుభ్యం దాస్యామి తన్ మయి సమర్పితమాస్తే యం ప్రతి మమేచ్ఛా జాయతే తస్మై దాతుం శక్నోమి, ");
INSERT INTO santel_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","త్వం చేన్మాం భజసే తర్హి సర్వ్వమేతత్ తవైవ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","తదా యీశుస్తం ప్రత్యుక్తవాన్ దూరీ భవ శైతాన్ లిపిరాస్తే, నిజం ప్రభుం పరమేశ్వరం భజస్వ కేవలం తమేవ సేవస్వ చ| ");
INSERT INTO santel_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","అథ శైతాన్ తం యిరూశాలమం నీత్వా మన్దిరస్య చూడాయా ఉపరి సముపవేశ్య జగాద త్వం చేదీశ్వరస్య పుత్రస్తర్హి స్థానాదితో లమ్ఫిత్వాధః ");
INSERT INTO santel_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","పత యతో లిపిరాస్తే, ఆజ్ఞాపయిష్యతి స్వీయాన్ దూతాన్ స పరమేశ్వరః| ");
INSERT INTO santel_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","రక్షితుం సర్వ్వమార్గే త్వాం తేన త్వచ్చరణే యథా| న లగేత్ ప్రస్తరాఘాతస్త్వాం ధరిష్యన్తి తే తథా| ");
INSERT INTO santel_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","తదా యీశునా ప్రత్యుక్తమ్ ఇదమప్యుక్తమస్తి త్వం స్వప్రభుం పరేశం మా పరీక్షస్వ| ");
INSERT INTO santel_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","పశ్చాత్ శైతాన్ సర్వ్వపరీక్షాం సమాప్య క్షణాత్తం త్యక్త్వా యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","తదా యీశురాత్మప్రభావాత్ పునర్గాలీల్ప్రదేశం గతస్తదా తత్సుఖ్యాతిశ్చతుర్దిశం వ్యానశే| ");
INSERT INTO santel_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","స తేషాం భజనగృహేషు ఉపదిశ్య సర్వ్వైః ప్రశంసితో బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","అథ స స్వపాలనస్థానం నాసరత్పురమేత్య విశ్రామవారే స్వాచారాద్ భజనగేహం ప్రవిశ్య పఠితుముత్తస్థౌ| ");
INSERT INTO santel_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","తతో యిశయియభవిష్యద్వాదినః పుస్తకే తస్య కరదత్తే సతి స తత్ పుస్తకం విస్తార్య్య యత్ర వక్ష్యమాణాని వచనాని సన్తి తత్ స్థానం ప్రాప్య పపాఠ| ");
INSERT INTO santel_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ఆత్మా తు పరమేశస్య మదీయోపరి విద్యతే| దరిద్రేషు సుసంవాదం వక్తుం మాం సోభిషిక్తవాన్| భగ్నాన్తః కరణాల్లోకాన్ సుస్వస్థాన్ కర్త్తుమేవ చ| బన్దీకృతేషు లోకేషు ముక్తే ర్ఘోషయితుం వచః| నేత్రాణి దాతుమన్ధేభ్యస్త్రాతుం బద్ధజనానపి| ");
INSERT INTO santel_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","పరేశానుగ్రహే కాలం ప్రచారయితుమేవ చ| సర్వ్వైతత్కరణార్థాయ మామేవ ప్రహిణోతి సః|| ");
INSERT INTO santel_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","తతః పుస్తకం బద్వ్వా పరిచారకస్య హస్తే సమర్ప్య చాసనే సముపవిష్టః, తతో భజనగృహే యావన్తో లోకా ఆసన్ తే సర్వ్వేఽనన్యదృష్ట్యా తం విలులోకిరే| ");
INSERT INTO santel_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","అనన్తరమ్ అద్యైతాని సర్వ్వాణి లిఖితవచనాని యుష్మాకం మధ్యే సిద్ధాని స ఇమాం కథాం తేభ్యః కథయితుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","తతః సర్వ్వే తస్మిన్ అన్వరజ్యన్త, కిఞ్చ తస్య ముఖాన్నిర్గతాభిరనుగ్రహస్య కథాభిశ్చమత్కృత్య కథయామాసుః కిమయం యూషఫః పుత్రో న? ");
INSERT INTO santel_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","తదా సోఽవాదీద్ హే చికిత్సక స్వమేవ స్వస్థం కురు కఫర్నాహూమి యద్యత్ కృతవాన్ తదశ్రౌష్మ తాః సర్వాః క్రియా అత్ర స్వదేశే కురు కథామేతాం యూయమేవావశ్యం మాం వదిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","పునః సోవాదీద్ యుష్మానహం యథార్థం వదామి, కోపి భవిష్యద్వాదీ స్వదేశే సత్కారం న ప్రాప్నోతి| ");
INSERT INTO santel_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","అపరఞ్చ యథార్థం వచ్మి, ఏలియస్య జీవనకాలే యదా సార్ద్ధత్రితయవర్షాణి యావత్ జలదప్రతిబన్ధాత్ సర్వ్వస్మిన్ దేశే మహాదుర్భిక్షమ్ అజనిష్ట తదానీమ్ ఇస్రాయేలో దేశస్య మధ్యే బహ్వ్యో విధవా ఆసన్, ");
INSERT INTO santel_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","కిన్తు సీదోన్ప్రదేశీయసారిఫత్పురనివాసినీమ్ ఏకాం విధవాం వినా కస్యాశ్చిదపి సమీపే ఏలియః ప్రేరితో నాభూత్| ");
INSERT INTO santel_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","అపరఞ్చ ఇలీశాయభవిష్యద్వాదివిద్యమానతాకాలే ఇస్రాయేల్దేశే బహవః కుష్ఠిన ఆసన్ కిన్తు సురీయదేశీయం నామాన్కుష్ఠినం వినా కోప్యన్యః పరిష్కృతో నాభూత్| ");
INSERT INTO santel_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ఇమాం కథాం శ్రుత్వా భజనగేహస్థితా లోకాః సక్రోధమ్ ఉత్థాయ ");
INSERT INTO santel_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","నగరాత్తం బహిష్కృత్య యస్య శిఖరిణ ఉపరి తేషాం నగరం స్థాపితమాస్తే తస్మాన్నిక్షేప్తుం తస్య శిఖరం తం నిన్యుః ");
INSERT INTO santel_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","కిన్తు స తేషాం మధ్యాదపసృత్య స్థానాన్తరం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","తతః పరం యీశుర్గాలీల్ప్రదేశీయకఫర్నాహూమ్నగర ఉపస్థాయ విశ్రామవారే లోకానుపదేష్టుమ్ ఆరబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","తదుపదేశాత్ సర్వ్వే చమచ్చక్రు ర్యతస్తస్య కథా గురుతరా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","తదానీం తద్భజనగేహస్థితోఽమేధ్యభూతగ్రస్త ఏకో జన ఉచ్చైః కథయామాస, ");
INSERT INTO santel_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","హే నాసరతీయయీశోఽస్మాన్ త్యజ, త్వయా సహాస్మాకం కః సమ్బన్ధః? కిమస్మాన్ వినాశయితుమాయాసి? త్వమీశ్వరస్య పవిత్రో జన ఏతదహం జానామి| ");
INSERT INTO santel_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","తదా యీశుస్తం తర్జయిత్వావదత్ మౌనీ భవ ఇతో బహిర్భవ; తతః సోమేధ్యభూతస్తం మధ్యస్థానే పాతయిత్వా కిఞ్చిదప్యహింసిత్వా తస్మాద్ బహిర్గతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","తతః సర్వ్వే లోకాశ్చమత్కృత్య పరస్పరం వక్తుమారేభిరే కోయం చమత్కారః| ఏష ప్రభావేణ పరాక్రమేణ చామేధ్యభూతాన్ ఆజ్ఞాపయతి తేనైవ తే బహిర్గచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","అనన్తరం చతుర్దిక్స్థదేశాన్ తస్య సుఖ్యాతిర్వ్యాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","తదనన్తరం స భజనగేహాద్ బహిరాగత్య శిమోనో నివేశనం ప్రవివేశ తదా తస్య శ్వశ్రూర్జ్వరేణాత్యన్తం పీడితాసీత్ శిష్యాస్తదర్థం తస్మిన్ వినయం చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","తతః స తస్యాః సమీపే స్థిత్వా జ్వరం తర్జయామాస తేనైవ తాం జ్వరోఽత్యాక్షీత్ తతః సా తత్క్షణమ్ ఉత్థాయ తాన్ సిషేవే| ");
INSERT INTO santel_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","అథ సూర్య్యాస్తకాలే స్వేషాం యే యే జనా నానారోగైః పీడితా ఆసన్ లోకాస్తాన్ యీశోః సమీపమ్ ఆనిన్యుః, తదా స ఏకైకస్య గాత్రే కరమర్పయిత్వా తానరోగాన్ చకార| ");
INSERT INTO santel_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","తతో భూతా బహుభ్యో నిర్గత్య చీత్శబ్దం కృత్వా చ బభాషిరే త్వమీశ్వరస్య పుత్రోఽభిషిక్తత్రాతా; కిన్తు సోభిషిక్తత్రాతేతి తే వివిదురేతస్మాత్ కారణాత్ తాన్ తర్జయిత్వా తద్వక్తుం నిషిషేధ| ");
INSERT INTO santel_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","అపరఞ్చ ప్రభాతే సతి స విజనస్థానం ప్రతస్థే పశ్చాత్ జనాస్తమన్విచ్ఛన్తస్తన్నికటం గత్వా స్థానాన్తరగమనార్థం తమన్వరున్ధన్| ");
INSERT INTO santel_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","కిన్తు స తాన్ జగాద, ఈశ్వరీయరాజ్యస్య సుసంవాదం ప్రచారయితుమ్ అన్యాని పురాణ్యపి మయా యాతవ్యాని యతస్తదర్థమేవ ప్రేరితోహం| ");
INSERT INTO santel_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","అథ గాలీలో భజనగేహేషు స ఉపదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","అనన్తరం యీశురేకదా గినేషరథ్దస్య తీర ఉత్తిష్ఠతి, తదా లోకా ఈశ్వరీయకథాం శ్రోతుం తదుపరి ప్రపతితాః| ");
INSERT INTO santel_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","తదానీం స హ్దస్య తీరసమీపే నౌద్వయం దదర్శ కిఞ్చ మత్స్యోపజీవినో నావం విహాయ జాలం ప్రక్షాలయన్తి| ");
INSERT INTO santel_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","తతస్తయోర్ద్వయో ర్మధ్యే శిమోనో నావమారుహ్య తీరాత్ కిఞ్చిద్దూరం యాతుం తస్మిన్ వినయం కృత్వా నౌకాయాముపవిశ్య లోకాన్ ప్రోపదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","పశ్చాత్ తం ప్రస్తావం సమాప్య స శిమోనం వ్యాజహార, గభీరం జలం గత్వా మత్స్యాన్ ధర్త్తుం జాలం నిక్షిప| ");
INSERT INTO santel_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","తతః శిమోన బభాషే, హే గురో యద్యపి వయం కృత్స్నాం యామినీం పరిశ్రమ్య మత్స్యైకమపి న ప్రాప్తాస్తథాపి భవతో నిదేశతో జాలం క్షిపామః| ");
INSERT INTO santel_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","అథ జాలే క్షిప్తే బహుమత్స్యపతనాద్ ఆనాయః ప్రచ్ఛిన్నః| ");
INSERT INTO santel_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","తస్మాద్ ఉపకర్త్తుమ్ అన్యనౌస్థాన్ సఙ్గిన ఆయాతుమ్ ఇఙ్గితేన సమాహ్వయన్ తతస్త ఆగత్య మత్స్యై ర్నౌద్వయం ప్రపూరయామాసు ర్యై ర్నౌద్వయం ప్రమగ్నమ్| ");
INSERT INTO santel_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","తదా శిమోన్పితరస్తద్ విలోక్య యీశోశ్చరణయోః పతిత్వా, హే ప్రభోహం పాపీ నరో మమ నికటాద్ భవాన్ యాతు, ఇతి కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","యతో జాలే పతితానాం మత్స్యానాం యూథాత్ శిమోన్ తత్సఙ్గినశ్చ చమత్కృతవన్తః; శిమోనః సహకారిణౌ సివదేః పుత్రౌ యాకూబ్ యోహన్ చేమౌ తాదృశౌ బభూవతుః| ");
INSERT INTO santel_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","తదా యీశుః శిమోనం జగాద మా భైషీరద్యారభ్య త్వం మనుష్యధరో భవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","అనన్తరం సర్వ్వాసు నౌసు తీరమ్ ఆనీతాసు తే సర్వ్వాన్ పరిత్యజ్య తస్య పశ్చాద్గామినో బభూవుః| ");
INSERT INTO santel_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","తతః పరం యీశౌ కస్మింశ్చిత్ పురే తిష్ఠతి జన ఏకః సర్వ్వాఙ్గకుష్ఠస్తం విలోక్య తస్య సమీపే న్యుబ్జః పతిత్వా సవినయం వక్తుమారేభే, హే ప్రభో యది భవానిచ్ఛతి తర్హి మాం పరిష్కర్త్తుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","తదానీం స పాణిం ప్రసార్య్య తదఙ్గం స్పృశన్ బభాషే త్వం పరిష్క్రియస్వేతి మమేచ్ఛాస్తి తతస్తత్క్షణం స కుష్ఠాత్ ముక్తః| ");
INSERT INTO santel_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","పశ్చాత్ స తమాజ్ఞాపయామాస కథామిమాం కస్మైచిద్ అకథయిత్వా యాజకస్య సమీపఞ్చ గత్వా స్వం దర్శయ, లోకేభ్యో నిజపరిష్కృతత్వస్య ప్రమాణదానాయ మూసాజ్ఞానుసారేణ ద్రవ్యముత్మృజస్వ చ| ");
INSERT INTO santel_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","తథాపి యీశోః సుఖ్యాతి ర్బహు వ్యాప్తుమారేభే కిఞ్చ తస్య కథాం శ్రోతుం స్వీయరోగేభ్యో మోక్తుఞ్చ లోకా ఆజగ్ముః| ");
INSERT INTO santel_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","అథ స ప్రాన్తరం గత్వా ప్రార్థయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","అపరఞ్చ ఏకదా యీశురుపదిశతి, ఏతర్హి గాలీల్యిహూదాప్రదేశయోః సర్వ్వనగరేభ్యో యిరూశాలమశ్చ కియన్తః ఫిరూశిలోకా వ్యవస్థాపకాశ్చ సమాగత్య తదన్తికే సముపవివిశుః, తస్మిన్ కాలే లోకానామారోగ్యకారణాత్ ప్రభోః ప్రభావః ప్రచకాశే| ");
INSERT INTO santel_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","పశ్చాత్ కియన్తో లోకా ఏకం పక్షాఘాతినం ఖట్వాయాం నిధాయ యీశోః సమీపమానేతుం సమ్ముఖే స్థాపయితుఞ్చ వ్యాప్రియన్త| ");
INSERT INTO santel_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","కిన్తు బహుజననివహసమ్వాధాత్ న శక్నువన్తో గృహోపరి గత్వా గృహపృష్ఠం ఖనిత్వా తం పక్షాఘాతినం సఖట్వం గృహమధ్యే యీశోః సమ్ముఖే ఽవరోహయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","తదా యీశుస్తేషామ్ ఈదృశం విశ్వాసం విలోక్య తం పక్షాఘాతినం వ్యాజహార, హే మానవ తవ పాపమక్షమ్యత| ");
INSERT INTO santel_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","తస్మాద్ అధ్యాపకాః ఫిరూశినశ్చ చిత్తైరిత్థం ప్రచిన్తితవన్తః, ఏష జన ఈశ్వరం నిన్దతి కోయం? కేవలమీశ్వరం వినా పాపం క్షన్తుం కః శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","తదా యీశుస్తేషామ్ ఇత్థం చిన్తనం విదిత్వా తేభ్యోకథయద్ యూయం మనోభిః కుతో వితర్కయథ? ");
INSERT INTO santel_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","తవ పాపక్షమా జాతా యద్వా త్వముత్థాయ వ్రజ ఏతయో ర్మధ్యే కా కథా సుకథ్యా? ");
INSERT INTO santel_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","కిన్తు పృథివ్యాం పాపం క్షన్తుం మానవసుతస్య సామర్థ్యమస్తీతి యథా యూయం జ్ఞాతుం శక్నుథ తదర్థం (స తం పక్షాఘాతినం జగాద) ఉత్తిష్ఠ స్వశయ్యాం గృహీత్వా గృహం యాహీతి త్వామాదిశామి| ");
INSERT INTO santel_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","తస్మాత్ స తత్క్షణమ్ ఉత్థాయ సర్వ్వేషాం సాక్షాత్ నిజశయనీయం గృహీత్వా ఈశ్వరం ధన్యం వదన్ నిజనివేశనం యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","తస్మాత్ సర్వ్వే విస్మయ ప్రాప్తా మనఃసు భీతాశ్చ వయమద్యాసమ్భవకార్య్యాణ్యదర్శామ ఇత్యుక్త్వా పరమేశ్వరం ధన్యం ప్రోదితాః| ");
INSERT INTO santel_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","తతః పరం బహిర్గచ్ఛన్ కరసఞ్చయస్థానే లేవినామానం కరసఞ్చాయకం దృష్ట్వా యీశుస్తమభిదధే మమ పశ్చాదేహి| ");
INSERT INTO santel_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","తస్మాత్ స తత్క్షణాత్ సర్వ్వం పరిత్యజ్య తస్య పశ్చాదియాయ| ");
INSERT INTO santel_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","అనన్తరం లేవి ర్నిజగృహే తదర్థం మహాభోజ్యం చకార, తదా తైః సహానేకే కరసఞ్చాయినస్తదన్యలోకాశ్చ భోక్తుముపవివిశుః| ");
INSERT INTO santel_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","తస్మాత్ కారణాత్ చణ్డాలానాం పాపిలోకానాఞ్చ సఙ్గే యూయం కుతో భంగ్ధ్వే పివథ చేతి కథాం కథయిత్వా ఫిరూశినోఽధ్యాపకాశ్చ తస్య శిష్యైః సహ వాగ్యుద్ధం కర్త్తుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","తస్మాద్ యీశుస్తాన్ ప్రత్యవోచద్ అరోగలోకానాం చికిత్సకేన ప్రయోజనం నాస్తి కిన్తు సరోగాణామేవ| ");
INSERT INTO santel_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","అహం ధార్మ్మికాన్ ఆహ్వాతుం నాగతోస్మి కిన్తు మనః పరావర్త్తయితుం పాపిన ఏవ| ");
INSERT INTO santel_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","తతస్తే ప్రోచుః, యోహనః ఫిరూశినాఞ్చ శిష్యా వారంవారమ్ ఉపవసన్తి ప్రార్థయన్తే చ కిన్తు తవ శిష్యాః కుతో భుఞ్జతే పివన్తి చ? ");
INSERT INTO santel_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","తదా స తానాచఖ్యౌ వరే సఙ్గే తిష్ఠతి వరస్య సఖిగణం కిముపవాసయితుం శక్నుథ? ");
INSERT INTO santel_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","కిన్తు యదా తేషాం నికటాద్ వరో నేష్యతే తదా తే సముపవత్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","సోపరమపి దృష్టాన్తం కథయామ్బభూవ పురాతనవస్త్రే కోపి నుతనవస్త్రం న సీవ్యతి యతస్తేన సేవనేన జీర్ణవస్త్రం ఛిద్యతే, నూతనపురాతనవస్త్రయో ర్మేలఞ్చ న భవతి| ");
INSERT INTO santel_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","పురాతన్యాం కుత్వాం కోపి నుతనం ద్రాక్షారసం న నిదధాతి, యతో నవీనద్రాక్షారసస్య తేజసా పురాతనీ కుతూ ర్విదీర్య్యతే తతో ద్రాక్షారసః పతతి కుతూశ్చ నశ్యతి| ");
INSERT INTO santel_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","తతో హేతో ర్నూతన్యాం కుత్వాం నవీనద్రాక్షారసః నిధాతవ్యస్తేనోభయస్య రక్షా భవతి| ");
INSERT INTO santel_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","అపరఞ్చ పురాతనం ద్రాక్షారసం పీత్వా కోపి నూతనం న వాఞ్ఛతి, యతః స వక్తి నూతనాత్ పురాతనమ్ ప్రశస్తమ్| ");
INSERT INTO santel_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","అచరఞ్చ పర్వ్వణో ద్వితీయదినాత్ పరం ప్రథమవిశ్రామవారే శస్యక్షేత్రేణ యీశోర్గమనకాలే తస్య శిష్యాః కణిశం ఛిత్త్వా కరేషు మర్ద్దయిత్వా ఖాదితుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","తస్మాత్ కియన్తః ఫిరూశినస్తానవదన్ విశ్రామవారే యత్ కర్మ్మ న కర్త్తవ్యం తత్ కుతః కురుథ? ");
INSERT INTO santel_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","యీశుః ప్రత్యువాచ దాయూద్ తస్య సఙ్గినశ్చ క్షుధార్త్తాః కిం చక్రుః స కథమ్ ఈశ్వరస్య మన్దిరం ప్రవిశ్య ");
INSERT INTO santel_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","యే దర్శనీయాః పూపా యాజకాన్ వినాన్యస్య కస్యాప్యభోజనీయాస్తానానీయ స్వయం బుభజే సఙ్గిభ్యోపి దదౌ తత్ కిం యుష్మాభిః కదాపి నాపాఠి? ");
INSERT INTO santel_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","పశ్చాత్ స తానవదత్ మనుజసుతో విశ్రామవారస్యాపి ప్రభు ర్భవతి| ");
INSERT INTO santel_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","అనన్తరమ్ అన్యవిశ్రామవారే స భజనగేహం ప్రవిశ్య సముపదిశతి| తదా తత్స్థానే శుష్కదక్షిణకర ఏకః పుమాన్ ఉపతస్థివాన్| ");
INSERT INTO santel_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","తస్మాద్ అధ్యాపకాః ఫిరూశినశ్చ తస్మిన్ దోషమారోపయితుం స విశ్రామవారే తస్య స్వాస్థ్యం కరోతి నవేతి ప్రతీక్షితుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","తదా యీశుస్తేషాం చిన్తాం విదిత్వా తం శుష్కకరం పుమాంసం ప్రోవాచ, త్వముత్థాయ మధ్యస్థానే తిష్ఠ| ");
INSERT INTO santel_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","తస్మాత్ తస్మిన్ ఉత్థితవతి యీశుస్తాన్ వ్యాజహార, యుష్మాన్ ఇమాం కథాం పృచ్ఛామి, విశ్రామవారే హితమ్ అహితం వా, ప్రాణరక్షణం ప్రాణనాశనం వా, ఏతేషాం కిం కర్మ్మకరణీయమ్? ");
INSERT INTO santel_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","పశ్చాత్ చతుర్దిక్షు సర్వ్వాన్ విలోక్య తం మానవం బభాషే, నిజకరం ప్రసారయ; తతస్తేన తథా కృత ఇతరకరవత్ తస్య హస్తః స్వస్థోభవత్| ");
INSERT INTO santel_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","తస్మాత్ తే ప్రచణ్డకోపాన్వితా యీశుం కిం కరిష్యన్తీతి పరస్పరం ప్రమన్త్రితాః| ");
INSERT INTO santel_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","తతః పరం స పర్వ్వతమారుహ్యేశ్వరముద్దిశ్య ప్రార్థయమానః కృత్స్నాం రాత్రిం యాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","అథ దినే సతి స సర్వ్వాన్ శిష్యాన్ ఆహూతవాన్ తేషాం మధ్యే ");
INSERT INTO santel_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","పితరనామ్నా ఖ్యాతః శిమోన్ తస్య భ్రాతా ఆన్ద్రియశ్చ యాకూబ్ యోహన్ చ ఫిలిప్ బర్థలమయశ్చ ");
INSERT INTO santel_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","మథిః థోమా ఆల్ఫీయస్య పుత్రో యాకూబ్ జ్వలన్తనామ్నా ఖ్యాతః శిమోన్ ");
INSERT INTO santel_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","చ యాకూబో భ్రాతా యిహూదాశ్చ తం యః పరకరేషు సమర్పయిష్యతి స ఈష్కరీయోతీయయిహూదాశ్చైతాన్ ద్వాదశ జనాన్ మనోనీతాన్ కృత్వా స జగ్రాహ తథా ప్రేరిత ఇతి తేషాం నామ చకార| ");
INSERT INTO santel_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","తతః పరం స తైః సహ పర్వ్వతాదవరుహ్య ఉపత్యకాయాం తస్థౌ తతస్తస్య శిష్యసఙ్ఘో యిహూదాదేశాద్ యిరూశాలమశ్చ సోరః సీదోనశ్చ జలధే రోధసో జననిహాశ్చ ఏత్య తస్య కథాశ్రవణార్థం రోగముక్త్యర్థఞ్చ తస్య సమీపే తస్థుః| ");
INSERT INTO santel_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","అమేధ్యభూతగ్రస్తాశ్చ తన్నికటమాగత్య స్వాస్థ్యం ప్రాపుః| ");
INSERT INTO santel_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","సర్వ్వేషాం స్వాస్థ్యకరణప్రభావస్య ప్రకాశితత్వాత్ సర్వ్వే లోకా ఏత్య తం స్ప్రష్టుం యేతిరే| ");
INSERT INTO santel_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","పశ్చాత్ స శిష్యాన్ ప్రతి దృష్టిం కుత్వా జగాద, హే దరిద్రా యూయం ధన్యా యత ఈశ్వరీయే రాజ్యే వోఽధికారోస్తి| ");
INSERT INTO santel_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","హే అధునా క్షుధితలోకా యూయం ధన్యా యతో యూయం తర్ప్స్యథ; హే ఇహ రోదినో జనా యూయం ధన్యా యతో యూయం హసిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","యదా లోకా మనుష్యసూనో ర్నామహేతో ర్యుష్మాన్ ఋृతీయిష్యన్తే పృథక్ కృత్వా నిన్దిష్యన్తి, అధమానివ యుష్మాన్ స్వసమీపాద్ దూరీకరిష్యన్తి చ తదా యూయం ధన్యాః| ");
INSERT INTO santel_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","స్వర్గే యుష్మాకం యథేష్టం ఫలం భవిష్యతి, ఏతదర్థం తస్మిన్ దినే ప్రోల్లసత ఆనన్దేన నృత్యత చ, తేషాం పూర్వ్వపురుషాశ్చ భవిష్యద్వాదినః ప్రతి తథైవ వ్యవాహరన్| ");
INSERT INTO santel_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","కిన్తు హా హా ధనవన్తో యూయం సుఖం ప్రాప్నుత| హన్త పరితృప్తా యూయం క్షుధితా భవిష్యథ; ");
INSERT INTO santel_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ఇహ హసన్తో యూయం వత యుష్మాభిః శోచితవ్యం రోదితవ్యఞ్చ| ");
INSERT INTO santel_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","సర్వ్వైలాకై ర్యుష్మాకం సుఖ్యాతౌ కృతాయాం యుష్మాకం దుర్గతి ర్భవిష్యతి యుష్మాకం పూర్వ్వపురుషా మృషాభవిష్యద్వాదినః ప్రతి తద్వత్ కృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","హే శ్రోతారో యుష్మభ్యమహం కథయామి, యూయం శత్రుషు ప్రీయధ్వం యే చ యుష్మాన్ ద్విషన్తి తేషామపి హితం కురుత| ");
INSERT INTO santel_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","యే చ యుష్మాన్ శపన్తి తేభ్య ఆశిషం దత్త యే చ యుష్మాన్ అవమన్యన్తే తేషాం మఙ్గలం ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","యది కశ్చిత్ తవ కపోలే చపేటాఘాతం కరోతి తర్హి తం ప్రతి కపోలమ్ అన్యం పరావర్త్త్య సమ్ముఖీకురు పునశ్చ యది కశ్చిత్ తవ గాత్రీయవస్త్రం హరతి తర్హి తం పరిధేయవస్త్రమ్ అపి గ్రహీతుం మా వారయ| ");
INSERT INTO santel_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","యస్త్వాం యాచతే తస్మై దేహి, యశ్చ తవ సమ్పత్తిం హరతి తం మా యాచస్వ| ");
INSERT INTO santel_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","పరేభ్యః స్వాన్ ప్రతి యథాచరణమ్ అపేక్షధ్వే పరాన్ ప్రతి యూయమపి తథాచరత| ");
INSERT INTO santel_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","యే జనా యుష్మాసు ప్రీయన్తే కేవలం తేషు ప్రీయమాణేషు యుష్మాకం కిం ఫలం? పాపిలోకా అపి స్వేషు ప్రీయమాణేషు ప్రీయన్తే| ");
INSERT INTO santel_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","యది హితకారిణ ఏవ హితం కురుథ తర్హి యుష్మాకం కిం ఫలం? పాపిలోకా అపి తథా కుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","యేభ్య ఋణపరిశోధస్య ప్రాప్తిప్రత్యాశాస్తే కేవలం తేషు ఋణే సమర్పితే యుష్మాకం కిం ఫలం? పునః ప్రాప్త్యాశయా పాపీలోకా అపి పాపిజనేషు ఋణమ్ అర్పయన్తి| ");
INSERT INTO santel_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","అతో యూయం రిపుష్వపి ప్రీయధ్వం, పరహితం కురుత చ; పునః ప్రాప్త్యాశాం త్యక్త్వా ఋణమర్పయత, తథా కృతే యుష్మాకం మహాఫలం భవిష్యతి, యూయఞ్చ సర్వ్వప్రధానస్య సన్తానా ఇతి ఖ్యాతిం ప్రాప్స్యథ, యతో యుష్మాకం పితా కృతఘ్నానాం దుర్వ్టత్తానాఞ్చ హితమాచరతి| ");
INSERT INTO santel_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","అత ఏవ స యథా దయాలు ర్యూయమపి తాదృశా దయాలవో భవత| ");
INSERT INTO santel_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","అపరఞ్చ పరాన్ దోషిణో మా కురుత తస్మాద్ యూయం దోషీకృతా న భవిష్యథ; అదణ్డ్యాన్ మా దణ్డయత తస్మాద్ యూయమపి దణ్డం న ప్రాప్స్యథ; పరేషాం దోషాన్ క్షమధ్వం తస్మాద్ యుష్మాకమపి దోషాః క్షమిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","దానానిదత్త తస్మాద్ యూయం దానాని ప్రాప్స్యథ, వరఞ్చ లోకాః పరిమాణపాత్రం ప్రదలయ్య సఞ్చాల్య ప్రోఞ్చాల్య పరిపూర్య్య యుష్మాకం క్రోడేషు సమర్పయిష్యన్తి; యూయం యేన పరిమాణేన పరిమాథ తేనైవ పరిమాణేన యుష్మత్కృతే పరిమాస్యతే| ");
INSERT INTO santel_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","అథ స తేభ్యో దృష్టాన్తకథామకథయత్, అన్ధో జనః కిమన్ధం పన్థానం దర్శయితుం శక్నోతి? తస్మాద్ ఉభావపి కిం గర్త్తే న పతిష్యతః? ");
INSERT INTO santel_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","గురోః శిష్యో న శ్రేష్ఠః కిన్తు శిష్యే సిద్ధే సతి స గురుతుల్యో భవితుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","అపరఞ్చ త్వం స్వచక్షుुషి నాసామ్ అదృష్ట్వా తవ భ్రాతుశ్చక్షుషి యత్తృణమస్తి తదేవ కుతః పశ్యమి? ");
INSERT INTO santel_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","స్వచక్షుషి యా నాసా విద్యతే తామ్ అజ్ఞాత్వా, భ్రాతస్తవ నేత్రాత్ తృణం బహిః కరోమీతి వాక్యం భ్రాతరం కథం వక్తుం శక్నోషి? హే కపటిన్ పూర్వ్వం స్వనయనాత్ నాసాం బహిః కురు తతో భ్రాతుశ్చక్షుషస్తృణం బహిః కర్త్తుం సుదృష్టిం ప్రాప్స్యసి| ");
INSERT INTO santel_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","అన్యఞ్చ ఉత్తమస్తరుః కదాపి ఫలమనుత్తమం న ఫలతి, అనుత్తమతరుశ్చ ఫలముత్తమం న ఫలతి కారణాదతః ఫలైస్తరవో జ్ఞాయన్తే| ");
INSERT INTO santel_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","కణ్టకిపాదపాత్ కోపి ఉడుమ్బరఫలాని న పాతయతి తథా శృగాలకోలివృక్షాదపి కోపి ద్రాక్షాఫలం న పాతయతి| ");
INSERT INTO santel_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","తద్వత్ సాధులోకోఽన్తఃకరణరూపాత్ సుభాణ్డాగారాద్ ఉత్తమాని ద్రవ్యాణి బహిః కరోతి, దుష్టో లోకశ్చాన్తఃకరణరూపాత్ కుభాణ్డాగారాత్ కుత్సితాని ద్రవ్యాణి నిర్గమయతి యతోఽన్తఃకరణానాం పూర్ణభావానురూపాణి వచాంసి ముఖాన్నిర్గచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","అపరఞ్చ మమాజ్ఞానురూపం నాచరిత్వా కుతో మాం ప్రభో ప్రభో ఇతి వదథ? ");
INSERT INTO santel_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","యః కశ్చిన్ మమ నికటమ్ ఆగత్య మమ కథా నిశమ్య తదనురూపం కర్మ్మ కరోతి స కస్య సదృశో భవతి తదహం యుష్మాన్ జ్ఞాाపయామి| ");
INSERT INTO santel_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","యో జనో గభీరం ఖనిత్వా పాషాణస్థలే భిత్తిం నిర్మ్మాయ స్వగృహం రచయతి తేన సహ తస్యోపమా భవతి; యత ఆప్లావిజలమేత్య తస్య మూలే వేగేన వహదపి తద్గేహం లాడయితుం న శక్నోతి యతస్తస్య భిత్తిః పాషాణోపరి తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","కిన్తు యః కశ్చిన్ మమ కథాః శ్రుత్వా తదనురూపం నాచరతి స భిత్తిం వినా మృृదుపరి గృహనిర్మ్మాత్రా సమానో భవతి; యత ఆప్లావిజలమాగత్య వేగేన యదా వహతి తదా తద్గృహం పతతి తస్య మహత్ పతనం జాయతే| ");
INSERT INTO santel_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","తతః పరం స లోకానాం కర్ణగోచరే తాన్ సర్వ్వాన్ ఉపదేశాన్ సమాప్య యదా కఫర్నాహూమ్పురం ప్రవిశతి ");
INSERT INTO santel_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","తదా శతసేనాపతేః ప్రియదాస ఏకో మృతకల్పః పీడిత ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","అతః సేనాపతి ర్యీశో ర్వార్త్తాం నిశమ్య దాసస్యారోగ్యకరణాయ తస్యాగమనార్థం వినయకరణాయ యిహూదీయాన్ కియతః ప్రాచః ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","తే యీశోరన్తికం గత్వా వినయాతిశయం వక్తుమారేభిరే, స సేనాపతి ర్భవతోనుగ్రహం ప్రాప్తుమ్ అర్హతి| ");
INSERT INTO santel_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","యతః సోస్మజ్జాతీయేషు లోకేషు ప్రీయతే తథాస్మత్కృతే భజనగేహం నిర్మ్మితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","తస్మాద్ యీశుస్తైః సహ గత్వా నివేశనస్య సమీపం ప్రాప, తదా స శతసేనాపతి ర్వక్ష్యమాణవాక్యం తం వక్తుం బన్ధూన్ ప్రాహిణోత్| హే ప్రభో స్వయం శ్రమో న కర్త్తవ్యో యద్ భవతా మద్గేహమధ్యే పాదార్పణం క్రియేత తదప్యహం నార్హామి, ");
INSERT INTO santel_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","కిఞ్చాహం భవత్సమీపం యాతుమపి నాత్మానం యోగ్యం బుద్ధవాన్, తతో భవాన్ వాక్యమాత్రం వదతు తేనైవ మమ దాసః స్వస్థో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","యస్మాద్ అహం పరాధీనోపి మమాధీనా యాః సేనాః సన్తి తాసామ్ ఏకజనం ప్రతి యాహీతి మయా ప్రోక్తే స యాతి; తదన్యం ప్రతి ఆయాహీతి ప్రోక్తే స ఆయాతి; తథా నిజదాసం ప్రతి ఏతత్ కుర్వ్వితి ప్రోక్తే స తదేవ కరోతి| ");
INSERT INTO santel_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","యీశురిదం వాక్యం శ్రుత్వా విస్మయం యయౌ, ముఖం పరావర్త్య పశ్చాద్వర్త్తినో లోకాన్ బభాషే చ, యుష్మానహం వదామి ఇస్రాయేలో వంశమధ్యేపి విశ్వాసమీదృశం న ప్రాప్నవం| ");
INSERT INTO santel_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","తతస్తే ప్రేషితా గృహం గత్వా తం పీడితం దాసం స్వస్థం దదృశుః| ");
INSERT INTO santel_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","పరేఽహని స నాయీనాఖ్యం నగరం జగామ తస్యానేకే శిష్యా అన్యే చ లోకాస్తేన సార్ద్ధం యయుః| ");
INSERT INTO santel_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","తేషు తన్నగరస్య ద్వారసన్నిధిం ప్రాప్తేషు కియన్తో లోకా ఏకం మృతమనుజం వహన్తో నగరస్య బహిర్యాన్తి, స తన్మాతురేకపుత్రస్తన్మాతా చ విధవా; తయా సార్ద్ధం తన్నగరీయా బహవో లోకా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ప్రభుస్తాం విలోక్య సానుకమ్పః కథయామాస, మా రోదీః| స సమీపమిత్వా ఖట్వాం పస్పర్శ తస్మాద్ వాహకాః స్థగితాస్తమ్యుః; ");
INSERT INTO santel_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","తదా స ఉవాచ హే యువమనుష్య త్వముత్తిష్ఠ, త్వామహమ్ ఆజ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","తస్మాత్ స మృతో జనస్తత్క్షణముత్థాయ కథాం ప్రకథితః; తతో యీశుస్తస్య మాతరి తం సమర్పయామాస| ");
INSERT INTO santel_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","తస్మాత్ సర్వ్వే లోకాః శశఙ్కిరే; ఏకో మహాభవిష్యద్వాదీ మధ్యేఽస్మాకమ్ సముదైత్, ఈశ్వరశ్చ స్వలోకానన్వగృహ్లాత్ కథామిమాం కథయిత్వా ఈశ్వరం ధన్యం జగదుః| ");
INSERT INTO santel_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","తతః పరం సమస్తం యిహూదాదేశం తస్య చతుర్దిక్స్థదేశఞ్చ తస్యైతత్కీర్త్తి ర్వ్యానశే| ");
INSERT INTO santel_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","తతః పరం యోహనః శిష్యేషు తం తద్వృత్తాన్తం జ్ఞాపితవత్సు ");
INSERT INTO santel_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","స స్వశిష్యాణాం ద్వౌ జనావాహూయ యీశుం ప్రతి వక్ష్యమాణం వాక్యం వక్తుం ప్రేషయామాస, యస్యాగమనమ్ అపేక్ష్య తిష్ఠామో వయం కిం స ఏవ జనస్త్వం? కిం వయమన్యమపేక్ష్య స్థాస్యామః? ");
INSERT INTO santel_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","పశ్చాత్తౌ మానవౌ గత్వా కథయామాసతుః, యస్యాగమనమ్ అపేక్ష్య తిష్ఠామో వయం, కిం సఏవ జనస్త్వం? కిం వయమన్యమపేక్ష్య స్థాస్యామః? కథామిమాం తుభ్యం కథయితుం యోహన్ మజ్జక ఆవాం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","తస్మిన్ దణ్డే యీశూరోగిణో మహావ్యాధిమతో దుష్టభూతగ్రస్తాంశ్చ బహూన్ స్వస్థాన్ కృత్వా, అనేకాన్ధేభ్యశ్చక్షుంషి దత్త్వా ప్రత్యువాచ, ");
INSERT INTO santel_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","యువాం వ్రజతమ్ అన్ధా నేత్రాణి ఖఞ్జాశ్చరణాని చ ప్రాప్నువన్తి, కుష్ఠినః పరిష్క్రియన్తే, బధిరాః శ్రవణాని మృతాశ్చ జీవనాని ప్రాప్నువన్తి, దరిద్రాణాం సమీపేషు సుసంవాదః ప్రచార్య్యతే, యం ప్రతి విఘ్నస్వరూపోహం న భవామి స ధన్యః, ");
INSERT INTO santel_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ఏతాని యాని పశ్యథః శృణుథశ్చ తాని యోహనం జ్ఞాపయతమ్| ");
INSERT INTO santel_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","తయో ర్దూతయో ర్గతయోః సతో ర్యోహని స లోకాన్ వక్తుముపచక్రమే, యూయం మధ్యేప్రాన్తరం కిం ద్రష్టుం నిరగమత? కిం వాయునా కమ్పితం నడం? ");
INSERT INTO santel_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","యూయం కిం ద్రష్టుం నిరగమత? కిం సూక్ష్మవస్త్రపరిధాయినం కమపి నరం? కిన్తు యే సూక్ష్మమృదువస్త్రాణి పరిదధతి సూత్తమాని ద్రవ్యాణి భుఞ్జతే చ తే రాజధానీషు తిష్ఠన్తి| ");
INSERT INTO santel_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","తర్హి యూయం కిం ద్రష్టుం నిరగమత? కిమేకం భవిష్యద్వాదినం? తదేవ సత్యం కిన్తు స పుమాన్ భవిష్యద్వాదినోపి శ్రేష్ఠ ఇత్యహం యుష్మాన్ వదామి; ");
INSERT INTO santel_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","పశ్య స్వకీయదూతన్తు తవాగ్ర ప్రేషయామ్యహం| గత్వా త్వదీయమార్గన్తు స హి పరిష్కరిష్యతి| యదర్థే లిపిరియమ్ ఆస్తే స ఏవ యోహన్| ");
INSERT INTO santel_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","అతో యుష్మానహం వదామి స్త్రియా గర్బ్భజాతానాం భవిష్యద్వాదినాం మధ్యే యోహనో మజ్జకాత్ శ్రేష్ఠః కోపి నాస్తి, తత్రాపి ఈశ్వరస్య రాజ్యే యః సర్వ్వస్మాత్ క్షుద్రః స యోహనోపి శ్రేష్ఠః| ");
INSERT INTO santel_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","అపరఞ్చ సర్వ్వే లోకాః కరమఞ్చాయినశ్చ తస్య వాక్యాని శ్రుత్వా యోహనా మజ్జనేన మజ్జితాః పరమేశ్వరం నిర్దోషం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","కిన్తు ఫిరూశినో వ్యవస్థాపకాశ్చ తేన న మజ్జితాః స్వాన్ ప్రతీశ్వరస్యోపదేశం నిష్ఫలమ్ అకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","అథ ప్రభుః కథయామాస, ఇదానీన్తనజనాన్ కేనోపమామి? తే కస్య సదృశాః? ");
INSERT INTO santel_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","యే బాలకా విపణ్యామ్ ఉపవిశ్య పరస్పరమ్ ఆహూయ వాక్యమిదం వదన్తి, వయం యుష్మాకం నికటే వంశీరవాదిష్మ, కిన్తు యూయం నానర్త్తిష్ట, వయం యుష్మాకం నికట అరోదిష్మ, కిన్తు యుయం న వ్యలపిష్ట, బాలకైరేతాదృశైస్తేషామ్ ఉపమా భవతి| ");
INSERT INTO santel_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","యతో యోహన్ మజ్జక ఆగత్య పూపం నాఖాదత్ ద్రాక్షారసఞ్చ నాపివత్ తస్మాద్ యూయం వదథ, భూతగ్రస్తోయమ్| ");
INSERT INTO santel_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","తతః పరం మానవసుత ఆగత్యాఖాదదపివఞ్చ తస్మాద్ యూయం వదథ, ఖాదకః సురాపశ్చాణ్డాలపాపినాం బన్ధురేకో జనో దృశ్యతామ్| ");
INSERT INTO santel_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","కిన్తు జ్ఞానినో జ్ఞానం నిర్దోషం విదుః| ");
INSERT INTO santel_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","పశ్చాదేకః ఫిరూశీ యీశుం భోజనాయ న్యమన్త్రయత్ తతః స తస్య గృహం గత్వా భోక్తుముపవిష్టః| ");
INSERT INTO santel_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ఏతర్హి తత్ఫిరూశినో గృహే యీశు ర్భేక్తుమ్ ఉపావేక్షీత్ తచ్ఛ్రుత్వా తన్నగరవాసినీ కాపి దుష్టా నారీ పాణ్డరప్రస్తరస్య సమ్పుటకే సుగన్ధితైలమ్ ఆనీయ ");
INSERT INTO santel_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","తస్య పశ్చాత్ పాదయోః సన్నిధౌ తస్యౌ రుదతీ చ నేత్రామ్బుభిస్తస్య చరణౌ ప్రక్షాల్య నిజకచైరమార్క్షీత్, తతస్తస్య చరణౌ చుమ్బిత్వా తేన సుగన్ధితైలేన మమర్ద| ");
INSERT INTO santel_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","తస్మాత్ స నిమన్త్రయితా ఫిరూశీ మనసా చిన్తయామాస, యద్యయం భవిష్యద్వాదీ భవేత్ తర్హి ఏనం స్పృశతి యా స్త్రీ సా కా కీదృశీ చేతి జ్ఞాతుం శక్నుయాత్ యతః సా దుష్టా| ");
INSERT INTO santel_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","తదా యాశుస్తం జగాద, హే శిమోన్ త్వాం ప్రతి మమ కిఞ్చిద్ వక్తవ్యమస్తి; తస్మాత్ స బభాషే, హే గురో తద్ వదతు| ");
INSERT INTO santel_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ఏకోత్తమర్ణస్య ద్వావధమర్ణావాస్తాం, తయోరేకః పఞ్చశతాని ముద్రాపాదాన్ అపరశ్చ పఞ్చాశత్ ముద్రాపాదాన్ ధారయామాస| ");
INSERT INTO santel_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","తదనన్తరం తయోః శోధ్యాభావాత్ స ఉత్తమర్ణస్తయో రృణే చక్షమే; తస్మాత్ తయోర్ద్వయోః కస్తస్మిన్ ప్రేష్యతే బహు? తద్ బ్రూహి| ");
INSERT INTO santel_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","శిమోన్ ప్రత్యువాచ, మయా బుధ్యతే యస్యాధికమ్ ఋణం చక్షమే స ఇతి; తతో యీశుస్తం వ్యాజహార, త్వం యథార్థం వ్యచారయః| ");
INSERT INTO santel_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","అథ తాం నారీం ప్రతి వ్యాఘుఠ్య శిమోనమవోచత్, స్త్రీమిమాం పశ్యసి? తవ గృహే మయ్యాగతే త్వం పాదప్రక్షాలనార్థం జలం నాదాః కిన్తు యోషిదేషా నయనజలై ర్మమ పాదౌ ప్రక్షాల్య కేశైరమార్క్షీత్| ");
INSERT INTO santel_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","త్వం మాం నాచుమ్బీః కిన్తు యోషిదేషా స్వీయాగమనాదారభ్య మదీయపాదౌ చుమ్బితుం న వ్యరంస్త| ");
INSERT INTO santel_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","త్వఞ్చ మదీయోత్తమాఙ్గే కిఞ్చిదపి తైలం నామర్దీః కిన్తు యోషిదేషా మమ చరణౌ సుగన్ధితైలేనామర్ద్దీత్| ");
INSERT INTO santel_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","అతస్త్వాం వ్యాహరామి, ఏతస్యా బహు పాపమక్షమ్యత తతో బహు ప్రీయతే కిన్తు యస్యాల్పపాపం క్షమ్యతే సోల్పం ప్రీయతే| ");
INSERT INTO santel_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","తతః పరం స తాం బభాషే, త్వదీయం పాపమక్షమ్యత| ");
INSERT INTO santel_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","తదా తేన సార్ద్ధం యే భోక్తుమ్ ఉపవివిశుస్తే పరస్పరం వక్తుమారేభిరే, అయం పాపం క్షమతే క ఏషః? ");
INSERT INTO santel_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","కిన్తు స తాం నారీం జగాద, తవ విశ్వాసస్త్వాం పర్య్యత్రాస్త త్వం క్షేమేణ వ్రజ| ");
INSERT INTO santel_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","అపరఞ్చ యీశు ర్ద్వాదశభిః శిష్యైః సార్ద్ధం నానానగరేషు నానాగ్రామేషు చ గచ్ఛన్ ఇశ్వరీయరాజత్వస్య సుసంవాదం ప్రచారయితుం ప్రారేభే| ");
INSERT INTO santel_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","తదా యస్యాః సప్త భూతా నిరగచ్ఛన్ సా మగ్దలీనీతి విఖ్యాతా మరియమ్ హేరోద్రాజస్య గృహాధిపతేః హోషే ర్భార్య్యా యోహనా శూశానా ");
INSERT INTO santel_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ప్రభృతయో యా బహ్వ్యః స్త్రియః దుష్టభూతేభ్యో రోగేభ్యశ్చ ముక్తాః సత్యో నిజవిభూతీ ర్వ్యయిత్వా తమసేవన్త, తాః సర్వ్వాస్తేన సార్ద్ధమ్ ఆసన్| ");
INSERT INTO santel_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","అనన్తరం నానానగరేభ్యో బహవో లోకా ఆగత్య తస్య సమీపేఽమిలన్, తదా స తేభ్య ఏకాం దృష్టాన్తకథాం కథయామాస| ఏకః కృషీబలో బీజాని వప్తుం బహిర్జగామ, ");
INSERT INTO santel_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","తతో వపనకాలే కతిపయాని బీజాని మార్గపార్శ్వే పేతుః, తతస్తాని పదతలై ర్దలితాని పక్షిభి ర్భక్షితాని చ| ");
INSERT INTO santel_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","కతిపయాని బీజాని పాషాణస్థలే పతితాని యద్యపి తాన్యఙ్కురితాని తథాపి రసాభావాత్ శుశుషుః| ");
INSERT INTO santel_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","కతిపయాని బీజాని కణ్టకివనమధ్యే పతితాని తతః కణ్టకివనాని సంవృద్ధ్య తాని జగ్రసుః| ");
INSERT INTO santel_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","తదన్యాని కతిపయబీజాని చ భూమ్యాముత్తమాయాం పేతుస్తతస్తాన్యఙ్కురయిత్వా శతగుణాని ఫలాని ఫేలుః| స ఇమా కథాం కథయిత్వా ప్రోచ్చైః ప్రోవాచ, యస్య శ్రోతుం శ్రోత్రే స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","తతః పరం శిష్యాస్తం పప్రచ్ఛురస్య దృష్టాన్తస్య కిం తాత్పర్య్యం? ");
INSERT INTO santel_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","తతః స వ్యాజహార, ఈశ్వరీయరాజ్యస్య గుహ్యాని జ్ఞాతుం యుష్మభ్యమధికారో దీయతే కిన్త్వన్యే యథా దృష్ట్వాపి న పశ్యన్తి శ్రుత్వాపి మ బుధ్యన్తే చ తదర్థం తేషాం పురస్తాత్ తాః సర్వ్వాః కథా దృష్టాన్తేన కథ్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","దృష్టాన్తస్యాస్యాభిప్రాయః, ఈశ్వరీయకథా బీజస్వరూపా| ");
INSERT INTO santel_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","యే కథామాత్రం శృణ్వన్తి కిన్తు పశ్చాద్ విశ్వస్య యథా పరిత్రాణం న ప్రాప్నువన్తి తదాశయేన శైతానేత్య హృదయాతృ తాం కథామ్ అపహరతి త ఏవ మార్గపార్శ్వస్థభూమిస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","యే కథం శ్రుత్వా సానన్దం గృహ్లన్తి కిన్త్వబద్ధమూలత్వాత్ స్వల్పకాలమాత్రం ప్రతీత్య పరీక్షాకాలే భ్రశ్యన్తి తఏవ పాషాణభూమిస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","యే కథాం శ్రుత్వా యాన్తి విషయచిన్తాయాం ధనలోభేన ఏेహికసుఖే చ మజ్జన్త ఉపయుక్తఫలాని న ఫలన్తి త ఏవోప్తబీజకణ్టకిభూస్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","కిన్తు యే శ్రుత్వా సరలైః శుద్ధైశ్చాన్తఃకరణైః కథాం గృహ్లన్తి ధైర్య్యమ్ అవలమ్బ్య ఫలాన్యుత్పాదయన్తి చ త ఏవోత్తమమృత్స్వరూపాః| ");
INSERT INTO santel_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","అపరఞ్చ ప్రదీపం ప్రజ్వాల్య కోపి పాత్రేణ నాచ్ఛాదయతి తథా ఖట్వాధోపి న స్థాపయతి, కిన్తు దీపాధారోపర్య్యేవ స్థాపయతి, తస్మాత్ ప్రవేశకా దీప్తిం పశ్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","యన్న ప్రకాశయిష్యతే తాదృగ్ అప్రకాశితం వస్తు కిమపి నాస్తి యచ్చ న సువ్యక్తం ప్రచారయిష్యతే తాదృగ్ గృప్తం వస్తు కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","అతో యూయం కేన ప్రకారేణ శృణుథ తత్ర సావధానా భవత, యస్య సమీపే బర్ద్ధతే తస్మై పునర్దాస్యతే కిన్తు యస్యాశ్రయే న బర్ద్ధతే తస్య యద్యదస్తి తదపి తస్మాత్ నేష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","అపరఞ్చ యీశో ర్మాతా భ్రాతరశ్చ తస్య సమీపం జిగమిషవః ");
INSERT INTO santel_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","కిన్తు జనతాసమ్బాధాత్ తత్సన్నిధిం ప్రాప్తుం న శేకుః| తత్పశ్చాత్ తవ మాతా భ్రాతరశ్చ త్వాం సాక్షాత్ చికీర్షన్తో బహిస్తిష్ఠనతీతి వార్త్తాయాం తస్మై కథితాయాం ");
INSERT INTO santel_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","స ప్రత్యువాచ; యే జనా ఈశ్వరస్య కథాం శ్రుత్వా తదనురూపమాచరన్తి తఏవ మమ మాతా భ్రాతరశ్చ| ");
INSERT INTO santel_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","అనన్తరం ఏకదా యీశుః శిష్యైః సార్ద్ధం నావమారుహ్య జగాద, ఆయాత వయం హ్రదస్య పారం యామః, తతస్తే జగ్ముః| ");
INSERT INTO santel_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","తేషు నౌకాం వాహయత్సు స నిదద్రౌ; ");
INSERT INTO santel_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","అథాకస్మాత్ ప్రబలఝఞ్భ్శగమాద్ హ్రదే నౌకాయాం తరఙ్గైరాచ్ఛన్నాయాం విపత్ తాన్ జగ్రాస| తస్మాద్ యీశోరన్తికం గత్వా హే గురో హే గురో ప్రాణా నో యాన్తీతి గదిత్వా తం జాగరయామ్బభూవుః| తదా స ఉత్థాయ వాయుం తరఙ్గాంశ్చ తర్జయామాస తస్మాదుభౌ నివృత్య స్థిరౌ బభూవతుః| ");
INSERT INTO santel_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","స తాన్ బభాషే యుష్మాకం విశ్వాసః క? తస్మాత్తే భీతా విస్మితాశ్చ పరస్పరం జగదుః, అహో కీదృగయం మనుజః పవనం పానీయఞ్చాదిశతి తదుభయం తదాదేశం వహతి| ");
INSERT INTO santel_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","తతః పరం గాలీల్ప్రదేశస్య సమ్ముఖస్థగిదేరీయప్రదేశే నౌకాయాం లగన్త్యాం తటేఽవరోహమావాద్ ");
INSERT INTO santel_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","బహుతిథకాలం భూతగ్రస్త ఏకో మానుషః పురాదాగత్య తం సాక్షాచ్చకార| స మనుషో వాసో న పరిదధత్ గృహే చ న వసన్ కేవలం శ్మశానమ్ అధ్యువాస| ");
INSERT INTO santel_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","స యీశుం దృష్ట్వైవ చీచ్ఛబ్దం చకార తస్య సమ్ముఖే పతిత్వా ప్రోచ్చైర్జగాద చ, హే సర్వ్వప్రధానేశ్వరస్య పుత్ర, మయా సహ తవ కః సమ్బన్ధః? త్వయి వినయం కరోమి మాం మా యాతయ| ");
INSERT INTO santel_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","యతః స తం మానుషం త్యక్త్వా యాతుమ్ అమేధ్యభూతమ్ ఆదిదేశ; స భూతస్తం మానుషమ్ అసకృద్ దధార తస్మాల్లోకాః శృఙ్ఖలేన నిగడేన చ బబన్ధుః; స తద్ భంక్త్వా భూతవశత్వాత్ మధ్యేప్రాన్తరం యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","అనన్తరం యీశుస్తం పప్రచ్ఛ తవ కిన్నామ? స ఉవాచ, మమ నామ బాహినో యతో బహవో భూతాస్తమాశిశ్రియుః| ");
INSERT INTO santel_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","అథ భూతా వినయేన జగదుః, గభీరం గర్త్తం గన్తుం మాజ్ఞాపయాస్మాన్| ");
INSERT INTO santel_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","తదా పర్వ్వతోపరి వరాహవ్రజశ్చరతి తస్మాద్ భూతా వినయేన ప్రోచుః, అముం వరాహవ్రజమ్ ఆశ్రయితుమ్ అస్మాన్ అనుజానీహి; తతః సోనుజజ్ఞౌ| ");
INSERT INTO santel_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","తతః పరం భూతాస్తం మానుషం విహాయ వరాహవ్రజమ్ ఆశిశ్రియుః వరాహవ్రజాశ్చ తత్క్షణాత్ కటకేన ధావన్తో హ్రదే ప్రాణాన్ విజృహుః| ");
INSERT INTO santel_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","తద్ దృష్ట్వా శూకరరక్షకాః పలాయమానా నగరం గ్రామఞ్చ గత్వా తత్సర్వ్వవృత్తాన్తం కథయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","తతః కిం వృత్తమ్ ఏతద్దర్శనార్థం లోకా నిర్గత్య యీశోః సమీపం యయుః, తం మానుషం త్యక్తభూతం పరిహితవస్త్రం స్వస్థమానుషవద్ యీశోశ్చరణసన్నిధౌ సూపవిశన్తం విలోక్య బిభ్యుః| ");
INSERT INTO santel_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","యే లోకాస్తస్య భూతగ్రస్తస్య స్వాస్థ్యకరణం దదృశుస్తే తేభ్యః సర్వ్వవృత్తాన్తం కథయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","తదనన్తరం తస్య గిదేరీయప్రదేశస్య చతుర్దిక్స్థా బహవో జనా అతిత్రస్తా వినయేన తం జగదుః, భవాన్ అస్మాకం నికటాద్ వ్రజతు తస్మాత్ స నావమారుహ్య తతో వ్యాఘుట్య జగామ| ");
INSERT INTO santel_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","తదానీం త్యక్తభూతమనుజస్తేన సహ స్థాతుం ప్రార్థయాఞ్చక్రే ");
INSERT INTO santel_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","కిన్తు తదర్థమ్ ఈశ్వరః కీదృఙ్మహాకర్మ్మ కృతవాన్ ఇతి నివేశనం గత్వా విజ్ఞాపయ, యీశుః కథామేతాం కథయిత్వా తం విససర్జ| తతః స వ్రజిత్వా యీశుస్తదర్థం యన్మహాకర్మ్మ చకార తత్ పురస్య సర్వ్వత్ర ప్రకాశయితుం ప్రారేభే| ");
INSERT INTO santel_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","అథ యీశౌ పరావృత్యాగతే లోకాస్తం ఆదరేణ జగృహు ర్యస్మాత్తే సర్వ్వే తమపేక్షాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","తదనన్తరం యాయీర్నామ్నో భజనగేహస్యైకోధిప ఆగత్య యీశోశ్చరణయోః పతిత్వా స్వనివేశనాగమనార్థం తస్మిన్ వినయం చకార, ");
INSERT INTO santel_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","యతస్తస్య ద్వాదశవర్షవయస్కా కన్యైకాసీత్ సా మృతకల్పాభవత్| తతస్తస్య గమనకాలే మార్గే లోకానాం మహాన్ సమాగమో బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ద్వాదశవర్షాణి ప్రదరరోగగ్రస్తా నానా వైద్యైశ్చికిత్సితా సర్వ్వస్వం వ్యయిత్వాపి స్వాస్థ్యం న ప్రాప్తా యా యోషిత్ సా యీశోః పశ్చాదాగత్య తస్య వస్త్రగ్రన్థిం పస్పర్శ| ");
INSERT INTO santel_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","తస్మాత్ తత్క్షణాత్ తస్యా రక్తస్రావో రుద్ధః| ");
INSERT INTO santel_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","తదానీం యీశురవదత్ కేనాహం స్పృష్టః? తతోఽనేకైరనఙ్గీకృతే పితరస్తస్య సఙ్గినశ్చావదన్, హే గురో లోకా నికటస్థాః సన్తస్తవ దేహే ఘర్షయన్తి, తథాపి కేనాహం స్పృష్టఇతి భవాన్ కుతః పృచ్ఛతి? ");
INSERT INTO santel_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","యీశుః కథయామాస, కేనాప్యహం స్పృష్టో, యతో మత్తః శక్తి ర్నిర్గతేతి మయా నిశ్చితమజ్ఞాయి| ");
INSERT INTO santel_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","తదా సా నారీ స్వయం న గుప్తేతి విదిత్వా కమ్పమానా సతీ తస్య సమ్ముఖే పపాత; యేన నిమిత్తేన తం పస్పర్శ స్పర్శమాత్రాచ్చ యేన ప్రకారేణ స్వస్థాభవత్ తత్ సర్వ్వం తస్య సాక్షాదాచఖ్యౌ| ");
INSERT INTO santel_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","తతః స తాం జగాద హే కన్యే సుస్థిరా భవ, తవ విశ్వాసస్త్వాం స్వస్థామ్ అకార్షీత్ త్వం క్షేమేణ యాహి| ");
INSERT INTO santel_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","యీశోరేతద్వాక్యవదనకాలే తస్యాధిపతే ర్నివేశనాత్ కశ్చిల్లోక ఆగత్య తం బభాషే, తవ కన్యా మృతా గురుం మా క్లిశాన| ");
INSERT INTO santel_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","కిన్తు యీశుస్తదాకర్ణ్యాధిపతిం వ్యాజహార, మా భైషీః కేవలం విశ్వసిహి తస్మాత్ సా జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","అథ తస్య నివేశనే ప్రాప్తే స పితరం యోహనం యాకూబఞ్చ కన్యాయా మాతరం పితరఞ్చ వినా, అన్యం కఞ్చన ప్రవేష్టుం వారయామాస| ");
INSERT INTO santel_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","అపరఞ్చ యే రుదన్తి విలపన్తి చ తాన్ సర్వ్వాన్ జనాన్ ఉవాచ, యూయం మా రోదిష్ట కన్యా న మృతా నిద్రాతి| ");
INSERT INTO santel_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","కిన్తు సా నిశ్చితం మృతేతి జ్ఞాత్వా తే తముపజహసుః| ");
INSERT INTO santel_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","పశ్చాత్ స సర్వ్వాన్ బహిః కృత్వా కన్యాయాః కరౌ ధృత్వాజుహువే, హే కన్యే త్వముత్తిష్ఠ, ");
INSERT INTO santel_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","తస్మాత్ తస్యాః ప్రాణేషు పునరాగతేషు సా తత్క్షణాద్ ఉత్తస్యౌ| తదానీం తస్యై కిఞ్చిద్ భక్ష్యం దాతుమ్ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","తతస్తస్యాః పితరౌ విస్మయం గతౌ కిన్తు స తావాదిదేశ ఘటనాయా ఏతస్యాః కథాం కస్మైచిదపి మా కథయతం| ");
INSERT INTO santel_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","తతః పరం స ద్వాదశశిష్యానాహూయ భూతాన్ త్యాజయితుం రోగాన్ ప్రతికర్త్తుఞ్చ తేభ్యః శక్తిమాధిపత్యఞ్చ దదౌ| ");
INSERT INTO santel_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","అపరఞ్చ ఈశ్వరీయరాజ్యస్య సుసంవాదం ప్రకాశయితుమ్ రోగిణామారోగ్యం కర్త్తుఞ్చ ప్రేరణకాలే తాన్ జగాద| ");
INSERT INTO santel_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","యాత్రార్థం యష్టి ర్వస్త్రపుటకం భక్ష్యం ముద్రా ద్వితీయవస్త్రమ్, ఏషాం కిమపి మా గృహ్లీత| ");
INSERT INTO santel_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","యూయఞ్చ యన్నివేశనం ప్రవిశథ నగరత్యాగపర్య్యనతం తన్నివేశనే తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","తత్ర యది కస్యచిత్ పురస్య లోకా యుష్మాకమాతిథ్యం న కుర్వ్వన్తి తర్హి తస్మాన్నగరాద్ గమనకాలే తేషాం విరుద్ధం సాక్ష్యార్థం యుష్మాకం పదధూలీః సమ్పాతయత| ");
INSERT INTO santel_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","అథ తే ప్రస్థాయ సర్వ్వత్ర సుసంవాదం ప్రచారయితుం పీడితాన్ స్వస్థాన్ కర్త్తుఞ్చ గ్రామేషు భ్రమితుం ప్రారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ఏతర్హి హేరోద్ రాజా యీశోః సర్వ్వకర్మ్మణాం వార్త్తాం శ్రుత్వా భృశముద్వివిజే ");
INSERT INTO santel_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","యతః కేచిదూచుర్యోహన్ శ్మశానాదుదతిష్ఠత్| కేచిదూచుః, ఏలియో దర్శనం దత్తవాన్; ఏవమన్యలోకా ఊచుః పూర్వ్వీయః కశ్చిద్ భవిష్యద్వాదీ సముత్థితః| ");
INSERT INTO santel_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","కిన్తు హేరోదువాచ యోహనః శిరోఽహమఛినదమ్ ఇదానీం యస్యేదృక్కర్మ్మణాం వార్త్తాం ప్రాప్నోమి స కః? అథ స తం ద్రష్టుమ్ ఐచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","అనన్తరం ప్రేరితాః ప్రత్యాగత్య యాని యాని కర్మ్మాణి చక్రుస్తాని యీశవే కథయామాసుః తతః స తాన్ బైత్సైదానామకనగరస్య విజనం స్థానం నీత్వా గుప్తం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","పశ్చాల్ లోకాస్తద్ విదిత్వా తస్య పశ్చాద్ యయుః; తతః స తాన్ నయన్ ఈశ్వరీయరాజ్యస్య ప్రసఙ్గముక్తవాన్, యేషాం చికిత్సయా ప్రయోజనమ్ ఆసీత్ తాన్ స్వస్థాన్ చకార చ| ");
INSERT INTO santel_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","అపరఞ్చ దివావసన్నే సతి ద్వాదశశిష్యా యీశోరన్తికమ్ ఏత్య కథయామాసుః, వయమత్ర ప్రాన్తరస్థానే తిష్ఠామః, తతో నగరాణి గ్రామాణి గత్వా వాసస్థానాని ప్రాప్య భక్ష్యద్రవ్యాణి క్రేతుం జననివహం భవాన్ విసృజతు| ");
INSERT INTO santel_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","తదా స ఉవాచ, యూయమేవ తాన్ భేజయధ్వం; తతస్తే ప్రోచురస్మాకం నికటే కేవలం పఞ్చ పూపా ద్వౌ మత్స్యౌ చ విద్యన్తే, అతఏవ స్థానాన్తరమ్ ఇత్వా నిమిత్తమేతేషాం భక్ష్యద్రవ్యేషు న క్రీతేషు న భవతి| ");
INSERT INTO santel_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","తత్ర ప్రాయేణ పఞ్చసహస్రాణి పురుషా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","తదా స శిష్యాన్ జగాద పఞ్చాశత్ పఞ్చాశజ్జనైః పంక్తీకృత్య తానుపవేశయత, తస్మాత్ తే తదనుసారేణ సర్వ్వలోకానుపవేశయాపాసుః| ");
INSERT INTO santel_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","తతః స తాన్ పఞ్చ పూపాన్ మీనద్వయఞ్చ గృహీత్వా స్వర్గం విలోక్యేశ్వరగుణాన్ కీర్త్తయాఞ్చక్రే భఙ్క్తా చ లోకేభ్యః పరివేషణార్థం శిష్యేషు సమర్పయామ్బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","తతః సర్వ్వే భుక్త్వా తృప్తిం గతా అవశిష్టానాఞ్చ ద్వాదశ డల్లకాన్ సంజగృహుః| ");
INSERT INTO santel_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","అథైకదా నిర్జనే శిష్యైః సహ ప్రార్థనాకాలే తాన్ పప్రచ్ఛ, లోకా మాం కం వదన్తి? ");
INSERT INTO santel_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","తతస్తే ప్రాచుః, త్వాం యోహన్మజ్జకం వదన్తి; కేచిత్ త్వామ్ ఏలియం వదన్తి, పూర్వ్వకాలికః కశ్చిద్ భవిష్యద్వాదీ శ్మశానాద్ ఉదతిష్ఠద్ ఇత్యపి కేచిద్ వదన్తి| ");
INSERT INTO santel_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","తదా స ఉవాచ, యూయం మాం కం వదథ? తతః పితర ఉక్తవాన్ త్వమ్ ఈశ్వరాభిషిక్తః పురుషః| ");
INSERT INTO santel_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","తదా స తాన్ దృఢమాదిదేశ, కథామేతాం కస్మైచిదపి మా కథయత| ");
INSERT INTO santel_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","స పునరువాచ, మనుష్యపుత్రేణ వహుయాతనా భోక్తవ్యాః ప్రాచీనలోకైః ప్రధానయాజకైరధ్యాపకైశ్చ సోవజ్ఞాయ హన్తవ్యః కిన్తు తృతీయదివసే శ్మశానాత్ తేనోత్థాతవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","అపరం స సర్వ్వానువాచ, కశ్చిద్ యది మమ పశ్చాద్ గన్తుం వాఞ్ఛతి తర్హి స స్వం దామ్యతు, దినే దినే క్రుశం గృహీత్వా చ మమ పశ్చాదాగచ్ఛతు| ");
INSERT INTO santel_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","యతో యః కశ్చిత్ స్వప్రాణాన్ రిరక్షిషతి స తాన్ హారయిష్యతి, యః కశ్చిన్ మదర్థం ప్రాణాన్ హారయిష్యతి స తాన్ రక్షిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","కశ్చిద్ యది సర్వ్వం జగత్ ప్రాప్నోతి కిన్తు స్వప్రాణాన్ హారయతి స్వయం వినశ్యతి చ తర్హి తస్య కో లాభః? ");
INSERT INTO santel_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","పున ర్యః కశ్చిన్ మాం మమ వాక్యం వా లజ్జాస్పదం జానాతి మనుష్యపుత్రో యదా స్వస్య పితుశ్చ పవిత్రాణాం దూతానాఞ్చ తేజోభిః పరివేష్టిత ఆగమిష్యతి తదా సోపి తం లజ్జాస్పదం జ్ఞాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","కిన్తు యుష్మానహం యథార్థం వదామి, ఈశ్వరీయరాజత్వం న దృష్టవా మృత్యుం నాస్వాదిష్యన్తే, ఏతాదృశాః కియన్తో లోకా అత్ర స్థనేఽపి దణ్డాయమానాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ఏతదాఖ్యానకథనాత్ పరం ప్రాయేణాష్టసు దినేషు గతేషు స పితరం యోహనం యాకూబఞ్చ గృహీత్వా ప్రార్థయితుం పర్వ్వతమేకం సమారురోహ| ");
INSERT INTO santel_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","అథ తస్య ప్రార్థనకాలే తస్య ముఖాకృతిరన్యరూపా జాతా, తదీయం వస్త్రముజ్జ్వలశుక్లం జాతం| ");
INSERT INTO santel_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","అపరఞ్చ మూసా ఏలియశ్చోభౌ తేజస్వినౌ దృష్టౌ ");
INSERT INTO santel_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","తౌ తేన యిరూశాలమ్పురే యో మృత్యుః సాధిష్యతే తదీయాం కథాం తేన సార్ద్ధం కథయితుమ్ ఆరేభాతే| ");
INSERT INTO santel_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","తదా పితరాదయః స్వస్య సఙ్గినో నిద్రయాకృష్టా ఆసన్ కిన్తు జాగరిత్వా తస్య తేజస్తేన సార్ద్ధమ్ ఉత్తిష్ఠన్తౌ జనౌ చ దదృశుః| ");
INSERT INTO santel_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","అథ తయోరుభయో ర్గమనకాలే పితరో యీశుం బభాషే, హే గురోఽస్మాకం స్థానేఽస్మిన్ స్థితిః శుభా, తత ఏకా త్వదర్థా, ఏకా మూసార్థా, ఏకా ఏలియార్థా, ఇతి తిస్రః కుట్యోస్మాభి ర్నిర్మ్మీయన్తాం, ఇమాం కథాం స న వివిచ్య కథయామాస| ");
INSERT INTO santel_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","అపరఞ్చ తద్వాక్యవదనకాలే పయోద ఏక ఆగత్య తేషాముపరి ఛాయాం చకార, తతస్తన్మధ్యే తయోః ప్రవేశాత్ తే శశఙ్కిరే| ");
INSERT INTO santel_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","తదా తస్మాత్ పయోదాద్ ఇయమాకాశీయా వాణీ నిర్జగామ, మమాయం ప్రియః పుత్ర ఏతస్య కథాయాం మనో నిధత్త| ");
INSERT INTO santel_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ఇతి శబ్దే జాతే తే యీశుమేకాకినం దదృశుః కిన్తు తే తదానీం తస్య దర్శనస్య వాచమేకామపి నోక్త్వా మనఃసు స్థాపయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","పరేఽహని తేషు తస్మాచ్ఛైలాద్ అవరూఢేషు తం సాక్షాత్ కర్త్తుం బహవో లోకా ఆజగ్ముః| ");
INSERT INTO santel_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","తేషాం మధ్యాద్ ఏకో జన ఉచ్చైరువాచ, హే గురో అహం వినయం కరోమి మమ పుత్రం ప్రతి కృపాదృష్టిం కరోతు, మమ స ఏవైకః పుత్రః| ");
INSERT INTO santel_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","భూతేన ధృతః సన్ సం ప్రసభం చీచ్ఛబ్దం కరోతి తన్ముఖాత్ ఫేణా నిర్గచ్ఛన్తి చ, భూత ఇత్థం విదార్య్య క్లిష్ట్వా ప్రాయశస్తం న త్యజతి| ");
INSERT INTO santel_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","తస్మాత్ తం భూతం త్యాజయితుం తవ శిష్యసమీపే న్యవేదయం కిన్తు తే న శేకుః| ");
INSERT INTO santel_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","తదా యీశురవాదీత్, రే ఆవిశ్వాసిన్ విపథగామిన్ వంశ కతికాలాన్ యుష్మాభిః సహ స్థాస్యామ్యహం యుష్మాకమ్ ఆచరణాని చ సహిష్యే? తవ పుత్రమిహానయ| ");
INSERT INTO santel_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","తతస్తస్మిన్నాగతమాత్రే భూతస్తం భూమౌ పాతయిత్వా విదదార; తదా యీశుస్తమమేధ్యం భూతం తర్జయిత్వా బాలకం స్వస్థం కృత్వా తస్య పితరి సమర్పయామాస| ");
INSERT INTO santel_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ఈశ్వరస్య మహాశక్తిమ్ ఇమాం విలోక్య సర్వ్వే చమచ్చక్రుః; ఇత్థం యీశోః సర్వ్వాభిః క్రియాభిః సర్వ్వైర్లోకైరాశ్చర్య్యే మన్యమానే సతి స శిష్యాన్ బభాషే, ");
INSERT INTO santel_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","కథేయం యుష్మాకం కర్ణేషు ప్రవిశతు, మనుష్యపుత్రో మనుష్యాణాం కరేషు సమర్పయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","కిన్తు తే తాం కథాం న బుబుధిరే, స్పష్టత్వాభావాత్ తస్యా అభిప్రాయస్తేషాం బోధగమ్యో న బభూవ; తస్యా ఆశయః క ఇత్యపి తే భయాత్ ప్రష్టుం న శేకుః| ");
INSERT INTO santel_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","తదనన్తరం తేషాం మధ్యే కః శ్రేష్ఠః కథామేతాం గృహీత్వా తే మిథో వివాదం చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","తతో యీశుస్తేషాం మనోభిప్రాయం విదిత్వా బాలకమేకం గృహీత్వా స్వస్య నికటే స్థాపయిత్వా తాన్ జగాద, ");
INSERT INTO santel_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","యో జనో మమ నామ్నాస్య బాలాస్యాతిథ్యం విదధాతి స మమాతిథ్యం విదధాతి, యశ్చ మమాతిథ్యం విదధాతి స మమ ప్రేరకస్యాతిథ్యం విదధాతి, యుష్మాకం మధ్యేయః స్వం సర్వ్వస్మాత్ క్షుద్రం జానీతే స ఏవ శ్రేష్ఠో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","అపరఞ్చ యోహన్ వ్యాజహార హే ప్రభేा తవ నామ్నా భూతాన్ త్యాజయన్తం మానుషమ్ ఏకం దృష్టవన్తో వయం, కిన్త్వస్మాకమ్ అపశ్చాద్ గామిత్వాత్ తం న్యషేధామ్| తదానీం యీశురువాచ, ");
INSERT INTO santel_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","తం మా నిషేధత, యతో యో జనోస్మాకం న విపక్షః స ఏవాస్మాకం సపక్షో భవతి| ");
INSERT INTO santel_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","అనన్తరం తస్యారోహణసమయ ఉపస్థితే స స్థిరచేతా యిరూశాలమం ప్రతి యాత్రాం కర్త్తుం నిశ్చిత్యాగ్రే దూతాన్ ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","తస్మాత్ తే గత్వా తస్య ప్రయోజనీయద్రవ్యాణి సంగ్రహీతుం శోమిరోణీయానాం గ్రామం ప్రవివిశుః| ");
INSERT INTO santel_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","కిన్తు స యిరూశాలమం నగరం యాతి తతో హేతో ర్లోకాస్తస్యాతిథ్యం న చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","అతఏవ యాకూబ్యోహనౌ తస్య శిష్యౌ తద్ దృష్ట్వా జగదతుః, హే ప్రభో ఏలియో యథా చకార తథా వయమపి కిం గగణాద్ ఆగన్తుమ్ ఏతాన్ భస్మీకర్త్తుఞ్చ వహ్నిమాజ్ఞాపయామః? భవాన్ కిమిచ్ఛతి? ");
INSERT INTO santel_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","కిన్తు స ముఖం పరావర్త్య తాన్ తర్జయిత్వా గదితవాన్ యుష్మాకం మనోభావః కః, ఇతి యూయం న జానీథ| ");
INSERT INTO santel_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","మనుజసుతో మనుజానాం ప్రాణాన్ నాశయితుం నాగచ్ఛత్, కిన్తు రక్షితుమ్ ఆగచ్ఛత్| పశ్చాద్ ఇతరగ్రామం తే యయుః| ");
INSERT INTO santel_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","తదనన్తరం పథి గమనకాలే జన ఏకస్తం బభాషే, హే ప్రభో భవాన్ యత్ర యాతి భవతా సహాహమపి తత్ర యాస్యామి| ");
INSERT INTO santel_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","తదానీం యీశుస్తమువాచ, గోమాయూనాం గర్త్తా ఆసతే, విహాయసీయవిహగాाనాం నీడాని చ సన్తి, కిన్తు మానవతనయస్య శిరః స్థాపయితుం స్థానం నాస్తి| ");
INSERT INTO santel_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","తతః పరం స ఇతరజనం జగాద, త్వం మమ పశ్చాద్ ఏహి; తతః స ఉవాచ, హే ప్రభో పూర్వ్వం పితరం శ్మశానే స్థాపయితుం మామాదిశతు| ");
INSERT INTO santel_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","తదా యీశురువాచ, మృతా మృతాన్ శ్మశానే స్థాపయన్తు కిన్తు త్వం గత్వేశ్వరీయరాజ్యస్య కథాం ప్రచారయ| ");
INSERT INTO santel_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","తతోన్యః కథయామాస, హే ప్రభో మయాపి భవతః పశ్చాద్ గంస్యతే, కిన్తు పూర్వ్వం మమ నివేశనస్య పరిజనానామ్ అనుమతిం గ్రహీతుమ్ అహమాదిశ్యై భవతా| ");
INSERT INTO santel_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","తదానీం యీశుస్తం ప్రోక్తవాన్, యో జనో లాఙ్గలే కరమర్పయిత్వా పశ్చాత్ పశ్యతి స ఈశ్వరీయరాజ్యం నార్హతి| ");
INSERT INTO santel_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","తతః పరం ప్రభురపరాన్ సప్తతిశిష్యాన్ నియుజ్య స్వయం యాని నగరాణి యాని స్థానాని చ గమిష్యతి తాని నగరాణి తాని స్థానాని చ ప్రతి ద్వౌ ద్వౌ జనౌ ప్రహితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","తేభ్యః కథయామాస చ శస్యాని బహూనీతి సత్యం కిన్తు ఛేదకా అల్పే; తస్మాద్ధేతోః శస్యక్షేత్రే ఛేదకాన్ అపరానపి ప్రేషయితుం క్షేత్రస్వామినం ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","యూయం యాత, పశ్యత, వృకాణాం మధ్యే మేషశావకానివ యుష్మాన్ ప్రహిణోమి| ");
INSERT INTO santel_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","యూయం క్షుద్రం మహద్ వా వసనసమ్పుటకం పాదుకాశ్చ మా గృహ్లీత, మార్గమధ్యే కమపి మా నమత చ| ");
INSERT INTO santel_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","అపరఞ్చ యూయం యద్ యత్ నివేశనం ప్రవిశథ తత్ర నివేశనస్యాస్య మఙ్గలం భూయాదితి వాక్యం ప్రథమం వదత| ");
INSERT INTO santel_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","తస్మాత్ తస్మిన్ నివేశనే యది మఙ్గలపాత్రం స్థాస్యతి తర్హి తన్మఙ్గలం తస్య భవిష్యతి, నోచేత్ యుష్మాన్ ప్రతి పరావర్త్తిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","అపరఞ్చ తే యత్కిఞ్చిద్ దాస్యన్తి తదేవ భుక్త్వా పీత్వా తస్మిన్నివేశనే స్థాస్యథ; యతః కర్మ్మకారీ జనో భృతిమ్ అర్హతి; గృహాద్ గృహం మా యాస్యథ| ");
INSERT INTO santel_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","అన్యచ్చ యుష్మాసు కిమపి నగరం ప్రవిష్టేషు లోకా యది యుష్మాకమ్ ఆతిథ్యం కరిష్యన్తి, తర్హి యత్ ఖాద్యమ్ ఉపస్థాస్యన్తి తదేవ ఖాదిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","తన్నగరస్థాన్ రోగిణః స్వస్థాన్ కరిష్యథ, ఈశ్వరీయం రాజ్యం యుష్మాకమ్ అన్తికమ్ ఆగమత్ కథామేతాఞ్చ ప్రచారయిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","కిన్తు కిమపి పురం యుష్మాసు ప్రవిష్టేషు లోకా యది యుష్మాకమ్ ఆతిథ్యం న కరిష్యన్తి, తర్హి తస్య నగరస్య పన్థానం గత్వా కథామేతాం వదిష్యథ, ");
INSERT INTO santel_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","యుష్మాకం నగరీయా యా ధూల్యోఽస్మాసు సమలగన్ తా అపి యుష్మాకం ప్రాతికూల్యేన సాక్ష్యార్థం సమ్పాతయామః; తథాపీశ్వరరాజ్యం యుష్మాకం సమీపమ్ ఆగతమ్ ఇతి నిశ్చితం జానీత| ");
INSERT INTO santel_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","అహం యుష్మభ్యం యథార్థం కథయామి, విచారదినే తస్య నగరస్య దశాతః సిదోమో దశా సహ్యా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","హా హా కోరాసీన్ నగర, హా హా బైత్సైదానగర యువయోర్మధ్యే యాదృశాని ఆశ్చర్య్యాణి కర్మ్మాణ్యక్రియన్త, తాని కర్మ్మాణి యది సోరసీదోనో ర్నగరయోరకారిష్యన్త, తదా ఇతో బహుదినపూర్వ్వం తన్నివాసినః శణవస్త్రాణి పరిధాయ గాత్రేషు భస్మ విలిప్య సముపవిశ్య సమఖేత్స్యన్త| ");
INSERT INTO santel_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","అతో విచారదివసే యుష్మాకం దశాతః సోరసీదోన్నివాసినాం దశా సహ్యా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","హే కఫర్నాహూమ్, త్వం స్వర్గం యావద్ ఉన్నతా కిన్తు నరకం యావత్ న్యగ్భవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","యో జనో యుష్మాకం వాక్యం గృహ్లాతి స మమైవ వాక్యం గృహ్లాతి; కిఞ్చ యో జనో యుష్మాకమ్ అవజ్ఞాం కరోతి స మమైవావజ్ఞాం కరోతి; యో జనో మమావజ్ఞాం కరోతి చ స మత్ప్రేరకస్యైవావజ్ఞాం కరోతి| ");
INSERT INTO santel_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","అథ తే సప్తతిశిష్యా ఆనన్దేన ప్రత్యాగత్య కథయామాసుః, హే ప్రభో భవతో నామ్నా భూతా అప్యస్మాకం వశీభవన్తి| ");
INSERT INTO santel_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","తదానీం స తాన్ జగాద, విద్యుతమివ స్వర్గాత్ పతన్తం శైతానమ్ అదర్శమ్| ");
INSERT INTO santel_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","పశ్యత సర్పాన్ వృశ్చికాన్ రిపోః సర్వ్వపరాక్రమాంశ్చ పదతలై ర్దలయితుం యుష్మభ్యం శక్తిం దదామి తస్మాద్ యుష్మాకం కాపి హాని ర్న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","భూతా యుష్మాకం వశీభవన్తి, ఏతన్నిమిత్తత్ మా సముల్లసత, స్వర్గే యుష్మాకం నామాని లిఖితాని సన్తీతి నిమిత్తం సముల్లసత| ");
INSERT INTO santel_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","తద్ఘటికాయాం యీశు ర్మనసి జాతాహ్లాదః కథయామాస హే స్వర్గపృథివ్యోరేకాధిపతే పితస్త్వం జ్ఞానవతాం విదుషాఞ్చ లోకానాం పురస్తాత్ సర్వ్వమేతద్ అప్రకాశ్య బాలకానాం పురస్తాత్ ప్రాకాశయ ఏతస్మాద్ధేతోస్త్వాం ధన్యం వదామి, హే పితరిత్థం భవతు యద్ ఏతదేవ తవ గోచర ఉత్తమమ్| ");
INSERT INTO santel_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","పిత్రా సర్వ్వాణి మయి సమర్పితాని పితరం వినా కోపి పుత్రం న జానాతి కిఞ్చ పుత్రం వినా యస్మై జనాయ పుత్రస్తం ప్రకాశితవాన్ తఞ్చ వినా కోపి పితరం న జానాతి| ");
INSERT INTO santel_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","తపః పరం స శిష్యాన్ ప్రతి పరావృత్య గుప్తం జగాద, యూయమేతాని సర్వ్వాణి పశ్యథ తతో యుష్మాకం చక్షూంషి ధన్యాని| ");
INSERT INTO santel_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","యుష్మానహం వదామి, యూయం యాని సర్వ్వాణి పశ్యథ తాని బహవో భవిష్యద్వాదినో భూపతయశ్చ ద్రష్టుమిచ్ఛన్తోపి ద్రష్టుం న ప్రాప్నువన్, యుష్మాభి ర్యా యాః కథాశ్చ శ్రూయన్తే తాః శ్రోతుమిచ్ఛన్తోపి శ్రోతుం నాలభన్త| ");
INSERT INTO santel_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","అనన్తరమ్ ఏకో వ్యవస్థాపక ఉత్థాయ తం పరీక్షితుం పప్రచ్ఛ, హే ఉపదేశక అనన్తాయుషః ప్రాప్తయే మయా కిం కరణీయం? ");
INSERT INTO santel_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","యీశుః ప్రత్యువాచ, అత్రార్థే వ్యవస్థాయాం కిం లిఖితమస్తి? త్వం కీదృక్ పఠసి? ");
INSERT INTO santel_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","తతః సోవదత్, త్వం సర్వ్వాన్తఃకరణైః సర్వ్వప్రాణైః సర్వ్వశక్తిభిః సర్వ్వచిత్తైశ్చ ప్రభౌ పరమేశ్వరే ప్రేమ కురు, సమీపవాసిని స్వవత్ ప్రేమ కురు చ| ");
INSERT INTO santel_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","తదా స కథయామాస, త్వం యథార్థం ప్రత్యవోచః, ఇత్థమ్ ఆచర తేనైవ జీవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","కిన్తు స జనః స్వం నిర్ద్దోషం జ్ఞాపయితుం యీశుం పప్రచ్ఛ, మమ సమీపవాసీ కః? తతో యీశుః ప్రత్యువాచ, ");
INSERT INTO santel_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ఏకో జనో యిరూశాలమ్పురాద్ యిరీహోపురం యాతి, ఏతర్హి దస్యూనాం కరేషు పతితే తే తస్య వస్త్రాదికం హృతవన్తః తమాహత్య మృతప్రాయం కృత్వా త్యక్త్వా యయుః| ");
INSERT INTO santel_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","అకస్మాద్ ఏకో యాజకస్తేన మార్గేణ గచ్ఛన్ తం దృష్ట్వా మార్గాన్యపార్శ్వేన జగామ| ");
INSERT INTO santel_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ఇత్థమ్ ఏకో లేవీయస్తత్స్థానం ప్రాప్య తస్యాన్తికం గత్వా తం విలోక్యాన్యేన పార్శ్వేన జగామ| ");
INSERT INTO santel_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","కిన్త్వేకః శోమిరోణీయో గచ్ఛన్ తత్స్థానం ప్రాప్య తం దృష్ట్వాదయత| ");
INSERT INTO santel_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","తస్యాన్తికం గత్వా తస్య క్షతేషు తైలం ద్రాక్షారసఞ్చ ప్రక్షిప్య క్షతాని బద్ధ్వా నిజవాహనోపరి తముపవేశ్య ప్రవాసీయగృహమ్ ఆనీయ తం సిషేవే| ");
INSERT INTO santel_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","పరస్మిన్ దివసే నిజగమనకాలే ద్వౌ ముద్రాపాదౌ తద్గృహస్వామినే దత్త్వావదత్ జనమేనం సేవస్వ తత్ర యోఽధికో వ్యయో భవిష్యతి తమహం పునరాగమనకాలే పరిశోత్స్యామి| ");
INSERT INTO santel_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ఏషాం త్రయాణాం మధ్యే తస్య దస్యుహస్తపతితస్య జనస్య సమీపవాసీ కః? త్వయా కిం బుధ్యతే? ");
INSERT INTO santel_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","తతః స వ్యవస్థాపకః కథయామాస యస్తస్మిన్ దయాం చకార| తదా యీశుః కథయామాస త్వమపి గత్వా తథాచర| ");
INSERT INTO santel_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","తతః పరం తే గచ్ఛన్త ఏకం గ్రామం ప్రవివిశుః; తదా మర్థానామా స్త్రీ స్వగృహే తస్యాతిథ్యం చకార| ");
INSERT INTO santel_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","తస్మాత్ మరియమ్ నామధేయా తస్యా భగినీ యీశోః పదసమీప ఉవవిశ్య తస్యోపదేశకథాం శ్రోతుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","కిన్తు మర్థా నానాపరిచర్య్యాయాం వ్యగ్రా బభూవ తస్మాద్ధేతోస్తస్య సమీపమాగత్య బభాషే; హే ప్రభో మమ భగినీ కేవలం మమోపరి సర్వ్వకర్మ్మణాం భారమ్ అర్పితవతీ తత్ర భవతా కిఞ్చిదపి న మనో నిధీయతే కిమ్? మమ సాహాయ్యం కర్త్తుం భవాన్ తామాదిశతు| ");
INSERT INTO santel_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","తతో యీశుః ప్రత్యువాచ హే మర్థే హే మర్థే, త్వం నానాకార్య్యేషు చిన్తితవతీ వ్యగ్రా చాసి, ");
INSERT INTO santel_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","కిన్తు ప్రయోజనీయమ్ ఏకమాత్రమ్ ఆస్తే| అపరఞ్చ యముత్తమం భాగం కోపి హర్త్తుం న శక్నోతి సఏవ మరియమా వృతః| ");
INSERT INTO santel_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","అనన్తరం స కస్మింశ్చిత్ స్థానే ప్రార్థయత తత్సమాప్తౌ సత్యాం తస్యైకః శిష్యస్తం జగాద హే ప్రభో యోహన్ యథా స్వశిష్యాన్ ప్రార్థయితుమ్ ఉపదిష్టవాన్ తథా భవానప్యస్మాన్ ఉపదిశతు| ");
INSERT INTO santel_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","తస్మాత్ స కథయామాస, ప్రార్థనకాలే యూయమ్ ఇత్థం కథయధ్వం, హే అస్మాకం స్వర్గస్థపితస్తవ నామ పూజ్యం భవతు; తవ రాజత్వం భవతు; స్వర్గే యథా తథా పృథివ్యామపి తవేచ్ఛయా సర్వ్వం భవతు| ");
INSERT INTO santel_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ప్రత్యహమ్ అస్మాకం ప్రయోజనీయం భోజ్యం దేహి| ");
INSERT INTO santel_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","యథా వయం సర్వ్వాన్ అపరాధినః క్షమామహే తథా త్వమపి పాపాన్యస్మాకం క్షమస్వ| అస్మాన్ పరీక్షాం మానయ కిన్తు పాపాత్మనో రక్ష| ");
INSERT INTO santel_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","పశ్చాత్ సోపరమపి కథితవాన్ యది యుష్మాకం కస్యచిద్ బన్ధుస్తిష్ఠతి నిశీథే చ తస్య సమీపం స గత్వా వదతి, ");
INSERT INTO santel_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","హే బన్ధో పథిక ఏకో బన్ధు ర్మమ నివేశనమ్ ఆయాతః కిన్తు తస్యాతిథ్యం కర్త్తుం మమాన్తికే కిమపి నాస్తి, అతఏవ పూపత్రయం మహ్యమ్ ఋణం దేహి; ");
INSERT INTO santel_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","తదా స యది గృహమధ్యాత్ ప్రతివదతి మాం మా క్లిశాన, ఇదానీం ద్వారం రుద్ధం శయనే మయా సహ బాలకాశ్చ తిష్ఠన్తి తుభ్యం దాతుమ్ ఉత్థాతుం న శక్నోమి, ");
INSERT INTO santel_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","తర్హి యుష్మానహం వదామి, స యది మిత్రతయా తస్మై కిమపి దాతుం నోత్తిష్ఠతి తథాపి వారం వారం ప్రార్థనాత ఉత్థాపితః సన్ యస్మిన్ తస్య ప్రయోజనం తదేవ దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","అతః కారణాత్ కథయామి, యాచధ్వం తతో యుష్మభ్యం దాస్యతే, మృగయధ్వం తత ఉద్దేశం ప్రాప్స్యథ, ద్వారమ్ ఆహత తతో యుష్మభ్యం ద్వారం మోక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","యో యాచతే స ప్రాప్నోతి, యో మృగయతే స ఏవోద్దేశం ప్రాప్నోతి, యో ద్వారమ్ ఆహన్తి తదర్థం ద్వారం మోచ్యతే| ");
INSERT INTO santel_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","పుత్రేణ పూపే యాచితే తస్మై పాషాణం దదాతి వా మత్స్యే యాచితే తస్మై సర్పం దదాతి ");
INSERT INTO santel_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","వా అణ్డే యాచితే తస్మై వృశ్చికం దదాతి యుష్మాకం మధ్యే క ఏతాదృశః పితాస్తే? ");
INSERT INTO santel_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","తస్మాదేవ యూయమభద్రా అపి యది స్వస్వబాలకేభ్య ఉత్తమాని ద్రవ్యాణి దాతుం జానీథ తర్హ్యస్మాకం స్వర్గస్థః పితా నిజయాచకేభ్యః కిం పవిత్రమ్ ఆత్మానం న దాస్యతి? ");
INSERT INTO santel_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","అనన్తరం యీశునా కస్మాచ్చిద్ ఏకస్మిన్ మూకభూతే త్యాజితే సతి స భూతత్యక్తో మానుషో వాక్యం వక్తుమ్ ఆరేభే; తతో లోకాః సకలా ఆశ్చర్య్యం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","కిన్తు తేషాం కేచిదూచు ర్జనోయం బాలసిబూబా అర్థాద్ భూతరాజేన భూతాన్ త్యాజయతి| ");
INSERT INTO santel_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","తం పరీక్షితుం కేచిద్ ఆకాశీయమ్ ఏకం చిహ్నం దర్శయితుం తం ప్రార్థయాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","తదా స తేషాం మనఃకల్పనాం జ్ఞాత్వా కథయామాస, కస్యచిద్ రాజ్యస్య లోకా యది పరస్పరం విరున్ధన్తి తర్హి తద్ రాజ్యమ్ నశ్యతి; కేచిద్ గృహస్థా యది పరస్పరం విరున్ధన్తి తర్హి తేపి నశ్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","తథైవ శైతానపి స్వలోకాన్ యది విరుణద్ధి తదా తస్య రాజ్యం కథం స్థాస్యతి? బాలసిబూబాహం భూతాన్ త్యాజయామి యూయమితి వదథ| ");
INSERT INTO santel_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","యద్యహం బాలసిబూబా భూతాన్ త్యాజయామి తర్హి యుష్మాకం సన్తానాః కేన త్యాజయన్తి? తస్మాత్ తఏవ కథాయా ఏతస్యా విచారయితారో భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","కిన్తు యద్యహమ్ ఈశ్వరస్య పరాక్రమేణ భూతాన్ త్యాజయామి తర్హి యుష్మాకం నికటమ్ ఈశ్వరస్య రాజ్యమవశ్యమ్ ఉపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","బలవాన్ పుమాన్ సుసజ్జమానో యతికాలం నిజాట్టాలికాం రక్షతి తతికాలం తస్య ద్రవ్యం నిరుపద్రవం తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","కిన్తు తస్మాద్ అధికబలః కశ్చిదాగత్య యది తం జయతి తర్హి యేషు శస్త్రాస్త్రేషు తస్య విశ్వాస ఆసీత్ తాని సర్వ్వాణి హృత్వా తస్య ద్రవ్యాణి గృహ్లాతి| ");
INSERT INTO santel_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","అతః కారణాద్ యో మమ సపక్షో న స విపక్షః, యో మయా సహ న సంగృహ్లాతి స వికిరతి| ");
INSERT INTO santel_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","అపరఞ్చ అమేధ్యభూతో మానుషస్యాన్తర్నిర్గత్య శుష్కస్థానే భ్రాన్త్వా విశ్రామం మృగయతే కిన్తు న ప్రాప్య వదతి మమ యస్మాద్ గృహాద్ ఆగతోహం పునస్తద్ గృహం పరావృత్య యామి| ");
INSERT INTO santel_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","తతో గత్వా తద్ గృహం మార్జితం శోభితఞ్చ దృష్ట్వా ");
INSERT INTO santel_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","తత్క్షణమ్ అపగత్య స్వస్మాదపి దుర్మ్మతీన్ అపరాన్ సప్తభూతాన్ సహానయతి తే చ తద్గృహం పవిశ్య నివసన్తి| తస్మాత్ తస్య మనుష్యస్య ప్రథమదశాతః శేషదశా దుఃఖతరా భవతి| ");
INSERT INTO santel_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","అస్యాః కథాయాః కథనకాలే జనతామధ్యస్థా కాచిన్నారీ తముచ్చైఃస్వరం ప్రోవాచ, యా యోషిత్ త్వాం గర్బ్భేఽధారయత్ స్తన్యమపాయయచ్చ సైవ ధన్యా| ");
INSERT INTO santel_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","కిన్తు సోకథయత్ యే పరమేశ్వరస్య కథాం శ్రుత్వా తదనురూపమ్ ఆచరన్తి తఏవ ధన్యాః| ");
INSERT INTO santel_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","తతః పరం తస్యాన్తికే బహులోకానాం సమాగమే జాతే స వక్తుమారేభే, ఆధునికా దుష్టలోకాశ్చిహ్నం ద్రష్టుమిచ్ఛన్తి కిన్తు యూనస్భవిష్యద్వాదినశ్చిహ్నం వినాన్యత్ కిఞ్చిచ్చిహ్నం తాన్ న దర్శయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","యూనస్ తు యథా నీనివీయలోకానాం సమీపే చిహ్నరూపోభవత్ తథా విద్యమానలోకానామ్ ఏషాం సమీపే మనుష్యపుత్రోపి చిహ్నరూపో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","విచారసమయే ఇదానీన్తనలోకానాం ప్రాతికూల్యేన దక్షిణదేశీయా రాజ్ఞీ ప్రోత్థాయ తాన్ దోషిణః కరిష్యతి, యతః సా రాజ్ఞీ సులేమాన ఉపదేశకథాం శ్రోతుం పృథివ్యాః సీమాత ఆగచ్ఛత్ కిన్తు పశ్యత సులేమానోపి గురుతర ఏకో జనోఽస్మిన్ స్థానే విద్యతే| ");
INSERT INTO santel_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","అపరఞ్చ విచారసమయే నీనివీయలోకా అపి వర్త్తమానకాలికానాం లోకానాం వైపరీత్యేన ప్రోత్థాయ తాన్ దోషిణః కరిష్యన్తి, యతో హేతోస్తే యూనసో వాక్యాత్ చిత్తాని పరివర్త్తయామాసుః కిన్తు పశ్యత యూనసోతిగురుతర ఏకో జనోఽస్మిన్ స్థానే విద్యతే| ");
INSERT INTO santel_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ప్రదీపం ప్రజ్వాల్య ద్రోణస్యాధః కుత్రాపి గుప్తస్థానే వా కోపి న స్థాపయతి కిన్తు గృహప్రవేశిభ్యో దీప్తిం దాతం దీపాధారోపర్య్యేవ స్థాపయతి| ");
INSERT INTO santel_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","దేహస్య ప్రదీపశ్చక్షుస్తస్మాదేవ చక్షు ర్యది ప్రసన్నం భవతి తర్హి తవ సర్వ్వశరీరం దీప్తిమద్ భవిష్యతి కిన్తు చక్షు ర్యది మలీమసం తిష్ఠతి తర్హి సర్వ్వశరీరం సాన్ధకారం స్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","అస్మాత్ కారణాత్ తవాన్తఃస్థం జ్యోతి ర్యథాన్ధకారమయం న భవతి తదర్థే సావధానో భవ| ");
INSERT INTO santel_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","యతః శరీరస్య కుత్రాప్యంశే సాన్ధకారే న జాతే సర్వ్వం యది దీప్తిమత్ తిష్ఠతి తర్హి తుభ్యం దీప్తిదాయిప్రోజ్జ్వలన్ ప్రదీప ఇవ తవ సవర్వశరీరం దీప్తిమద్ భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ఏతత్కథాయాః కథనకాలే ఫిరుశ్యేకో భేజనాయ తం నిమన్త్రయామాస, తతః స గత్వా భోక్తుమ్ ఉపవివేశ| ");
INSERT INTO santel_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","కిన్తు భోజనాత్ పూర్వ్వం నామాఙ్క్షీత్ ఏతద్ దృష్ట్వా స ఫిరుశ్యాశ్చర్య్యం మేనే| ");
INSERT INTO santel_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","తదా ప్రభుస్తం ప్రోవాచ యూయం ఫిరూశిలోకాః పానపాత్రాణాం భోజనపాత్రాణాఞ్చ బహిః పరిష్కురుథ కిన్తు యుష్మాకమన్త ర్దౌరాత్మ్యై ర్దుష్క్రియాభిశ్చ పరిపూర్ణం తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","హే సర్వ్వే నిర్బోధా యో బహిః ససర్జ స ఏవ కిమన్త ర్న ససర్జ? ");
INSERT INTO santel_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","తత ఏవ యుష్మాభిరన్తఃకరణం (ఈశ్వరాయ) నివేద్యతాం తస్మిన్ కృతే యుష్మాకం సర్వ్వాణి శుచితాం యాస్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","కిన్తు హన్త ఫిరూశిగణా యూయం న్యాయమ్ ఈశ్వరే ప్రేమ చ పరిత్యజ్య పోదినాయా అరుదాదీనాం సర్వ్వేషాం శాకానాఞ్చ దశమాంశాన్ దత్థ కిన్తు ప్రథమం పాలయిత్వా శేషస్యాలఙ్ఘనం యుష్మాకమ్ ఉచితమాసీత్| ");
INSERT INTO santel_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","హా హా ఫిరూశినో యూయం భజనగేహే ప్రోచ్చాసనే ఆపణేషు చ నమస్కారేషు ప్రీయధ్వే| ");
INSERT INTO santel_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","వత కపటినోఽధ్యాపకాః ఫిరూశినశ్చ లోకాయత్ శ్మశానమ్ అనుపలభ్య తదుపరి గచ్ఛన్తి యూయమ్ తాదృగప్రకాశితశ్మశానవాద్ భవథ| ");
INSERT INTO santel_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","తదానీం వ్యవస్థాపకానామ్ ఏకా యీశుమవదత్, హే ఉపదేశక వాక్యేనేదృశేనాస్మాస్వపి దోషమ్ ఆరోపయసి| ");
INSERT INTO santel_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","తతః స ఉవాచ, హా హా వ్యవస్థాపకా యూయమ్ మానుషాణామ్ ఉపరి దుఃసహ్యాన్ భారాన్ న్యస్యథ కిన్తు స్వయమ్ ఏకాఙ్గుुల్యాపి తాన్ భారాన్ న స్పృశథ| ");
INSERT INTO santel_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","హన్త యుష్మాకం పూర్వ్వపురుషా యాన్ భవిష్యద్వాదినోఽవధిషుస్తేషాం శ్మశానాని యూయం నిర్మ్మాథ| ");
INSERT INTO santel_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","తేనైవ యూయం స్వపూర్వ్వపురుషాణాం కర్మ్మాణి సంమన్యధ్వే తదేవ సప్రమాణం కురుథ చ, యతస్తే తానవధిషుః యూయం తేషాం శ్మశానాని నిర్మ్మాథ| ");
INSERT INTO santel_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","అతఏవ ఈశ్వరస్య శాస్త్రే ప్రోక్తమస్తి తేషామన్తికే భవిష్యద్వాదినః ప్రేరితాంశ్చ ప్రేషయిష్యామి తతస్తే తేషాం కాంశ్చన హనిష్యన్తి కాంశ్చన తాడశ్ష్యిన్తి| ");
INSERT INTO santel_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ఏతస్మాత్ కారణాత్ హాబిలః శోణితపాతమారభ్య మన్దిరయజ్ఞవేద్యో ర్మధ్యే హతస్య సిఖరియస్య రక్తపాతపర్య్యన్తం ");
INSERT INTO santel_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","జగతః సృష్టిమారభ్య పృథివ్యాం భవిష్యద్వాదినాం యతిరక్తపాతా జాతాస్తతీనామ్ అపరాధదణ్డా ఏషాం వర్త్తమానలోకానాం భవిష్యన్తి, యుష్మానహం నిశ్చితం వదామి సర్వ్వే దణ్డా వంశస్యాస్య భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","హా హా వ్యవస్థపకా యూయం జ్ఞానస్య కుఞ్చికాం హృత్వా స్వయం న ప్రవిష్టా యే ప్రవేష్టుఞ్చ ప్రయాసినస్తానపి ప్రవేష్టుం వారితవన్తః| ");
INSERT INTO santel_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ఇత్థం కథాకథనాద్ అధ్యాపకాః ఫిరూశినశ్చ సతర్కాః ");
INSERT INTO santel_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","సన్తస్తమపవదితుం తస్య కథాయా దోషం ధర్త్తమిచ్ఛన్తో నానాఖ్యానకథనాయ తం ప్రవర్త్తయితుం కోపయితుఞ్చ ప్రారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","తదానీం లోకాః సహస్రం సహస్రమ్ ఆగత్య సముపస్థితాస్తత ఏకైకో ఽన్యేషాముపరి పతితుమ్ ఉపచక్రమే; తదా యీశుః శిష్యాన్ బభాషే, యూయం ఫిరూశినాం కిణ్వరూపకాపట్యే విశేషేణ సావధానాస్తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","యతో యన్న ప్రకాశయిష్యతే తదాచ్ఛన్నం వస్తు కిమపి నాస్తి; తథా యన్న జ్ఞాస్యతే తద్ గుప్తం వస్తు కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","అన్ధకారే తిష్ఠనతో యాః కథా అకథయత తాః సర్వ్వాః కథా దీప్తౌ శ్రోష్యన్తే నిర్జనే కర్ణే చ యదకథయత గృహపృష్ఠాత్ తత్ ప్రచారయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","హే బన్ధవో యుష్మానహం వదామి, యే శరీరస్య నాశం వినా కిమప్యపరం కర్త్తుం న శక్రువన్తి తేభ్యో మా భైష్ట| ");
INSERT INTO santel_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","తర్హి కస్మాద్ భేతవ్యమ్ ఇత్యహం వదామి, యః శరీరం నాశయిత్వా నరకం నిక్షేప్తుం శక్నోతి తస్మాదేవ భయం కురుత, పునరపి వదామి తస్మాదేవ భయం కురుత| ");
INSERT INTO santel_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","పఞ్చ చటకపక్షిణః కిం ద్వాభ్యాం తామ్రఖణ్డాభ్యాం న విక్రీయన్తే? తథాపీశ్వరస్తేషామ్ ఏకమపి న విస్మరతి| ");
INSERT INTO santel_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","యుష్మాకం శిరఃకేశా అపి గణితాః సన్తి తస్మాత్ మా విభీత బహుచటకపక్షిభ్యోపి యూయం బహుమూల్యాః| ");
INSERT INTO santel_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","అపరం యుష్మభ్యం కథయామి యః కశ్చిన్ మానుషాణాం సాక్షాన్ మాం స్వీకరోతి మనుష్యపుత్ర ఈశ్వరదూతానాం సాక్షాత్ తం స్వీకరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","కిన్తు యః కశ్చిన్మానుషాణాం సాక్షాన్మామ్ అస్వీకరోతి తమ్ ఈశ్వరస్య దూతానాం సాక్షాద్ అహమ్ అస్వీకరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","అన్యచ్చ యః కశ్చిన్ మనుజసుతస్య నిన్దాభావేన కాఞ్చిత్ కథాం కథయతి తస్య తత్పాపస్య మోచనం భవిష్యతి కిన్తు యది కశ్చిత్ పవిత్రమ్ ఆత్మానం నిన్దతి తర్హి తస్య తత్పాపస్య మోచనం న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","యదా లోకా యుష్మాన్ భజనగేహం విచారకర్తృరాజ్యకర్తృణాం సమ్ముఖఞ్చ నేష్యన్తి తదా కేన ప్రకారేణ కిముత్తరం వదిష్యథ కిం కథయిష్యథ చేత్యత్ర మా చిన్తయత; ");
INSERT INTO santel_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","యతో యుష్మాభిర్యద్ యద్ వక్తవ్యం తత్ తస్మిన్ సమయఏవ పవిత్ర ఆత్మా యుష్మాన్ శిక్షయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","తతః పరం జనతామధ్యస్థః కశ్చిజ్జనస్తం జగాద హే గురో మయా సహ పైతృకం ధనం విభక్తుం మమ భ్రాతరమాజ్ఞాపయతు భవాన్| ");
INSERT INTO santel_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","కిన్తు స తమవదత్ హే మనుష్య యువయో ర్విచారం విభాగఞ్చ కర్త్తుం మాం కో నియుక్తవాన్? ");
INSERT INTO santel_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","అనన్తరం స లోకానవదత్ లోభే సావధానాః సతర్కాశ్చ తిష్ఠత, యతో బహుసమ్పత్తిప్రాప్త్యా మనుష్యస్యాయు ర్న భవతి| ");
INSERT INTO santel_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","పశ్చాద్ దృష్టాన్తకథాముత్థాప్య కథయామాస, ఏకస్య ధనినో భూమౌ బహూని శస్యాని జాతాని| ");
INSERT INTO santel_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","తతః స మనసా చిన్తయిత్వా కథయామ్బభూవ మమైతాని సముత్పన్నాని ద్రవ్యాణి స్థాపయితుం స్థానం నాస్తి కిం కరిష్యామి? ");
INSERT INTO santel_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","తతోవదద్ ఇత్థం కరిష్యామి, మమ సర్వ్వభాణ్డాగారాణి భఙ్క్త్వా బృహద్భాణ్డాగారాణి నిర్మ్మాయ తన్మధ్యే సర్వ్వఫలాని ద్రవ్యాణి చ స్థాపయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","అపరం నిజమనో వదిష్యామి, హే మనో బహువత్సరార్థం నానాద్రవ్యాణి సఞ్చితాని సన్తి విశ్రామం కురు భుక్త్వా పీత్వా కౌతుకఞ్చ కురు| కిన్త్వీశ్వరస్తమ్ అవదత్, ");
INSERT INTO santel_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","రే నిర్బోధ అద్య రాత్రౌ తవ ప్రాణాస్త్వత్తో నేష్యన్తే తత ఏతాని యాని ద్రవ్యాణి త్వయాసాదితాని తాని కస్య భవిష్యన్తి? ");
INSERT INTO santel_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","అతఏవ యః కశ్చిద్ ఈశ్వరస్య సమీపే ధనసఞ్చయమకృత్వా కేవలం స్వనికటే సఞ్చయం కరోతి సోపి తాదృశః| ");
INSERT INTO santel_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","అథ స శిష్యేభ్యః కథయామాస, యుష్మానహం వదామి, కిం ఖాదిష్యామః? కిం పరిధాస్యామః? ఇత్యుక్త్వా జీవనస్య శరీరస్య చార్థం చిన్తాం మా కార్ష్ట| ");
INSERT INTO santel_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","భక్ష్యాజ్జీవనం భూషణాచ్ఛరీరఞ్చ శ్రేష్ఠం భవతి| ");
INSERT INTO santel_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","కాకపక్షిణాం కార్య్యం విచారయత, తే న వపన్తి శస్యాని చ న ఛిన్దన్తి, తేషాం భాణ్డాగారాణి న సన్తి కోషాశ్చ న సన్తి, తథాపీశ్వరస్తేభ్యో భక్ష్యాణి దదాతి, యూయం పక్షిభ్యః శ్రేష్ఠతరా న కిం? ");
INSERT INTO santel_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","అపరఞ్చ భావయిత్వా నిజాయుషః క్షణమాత్రం వర్ద్ధయితుం శక్నోతి, ఏతాదృశో లాకో యుష్మాకం మధ్యే కోస్తి? ");
INSERT INTO santel_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","అతఏవ క్షుద్రం కార్య్యం సాధయితుమ్ అసమర్థా యూయమ్ అన్యస్మిన్ కార్య్యే కుతో భావయథ? ");
INSERT INTO santel_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","అన్యచ్చ కామ్పిలపుష్పం కథం వర్ద్ధతే తదాపి విచారయత, తత్ కఞ్చన శ్రమం న కరోతి తన్తూంశ్చ న జనయతి కిన్తు యుష్మభ్యం యథార్థం కథయామి సులేమాన్ బహ్వైశ్వర్య్యాన్వితోపి పుష్పస్యాస్య సదృశో విభూషితో నాసీత్| ");
INSERT INTO santel_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","అద్య క్షేత్రే వర్త్తమానం శ్వశ్చూల్ల్యాం క్షేప్స్యమానం యత్ తృణం, తస్మై యదీశ్వర ఇత్థం భూషయతి తర్హి హే అల్పప్రత్యయినో యుష్మాన కిం న పరిధాపయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","అతఏవ కిం ఖాదిష్యామః? కిం పరిధాస్యామః? ఏతదర్థం మా చేష్టధ్వం మా సందిగ్ధ్వఞ్చ| ");
INSERT INTO santel_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","జగతో దేవార్చ్చకా ఏతాని సర్వ్వాణి చేష్టనతే; ఏషు వస్తుషు యుష్మాకం ప్రయోజనమాస్తే ఇతి యుష్మాకం పితా జానాతి| ");
INSERT INTO santel_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","అతఏవేశ్వరస్య రాజ్యార్థం సచేష్టా భవత తథా కృతే సర్వ్వాణ్యేతాని ద్రవ్యాణి యుష్మభ్యం ప్రదాయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","హే క్షుద్రమేషవ్రజ యూయం మా భైష్ట యుష్మభ్యం రాజ్యం దాతుం యుష్మాకం పితుః సమ్మతిరస్తి| ");
INSERT INTO santel_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","అతఏవ యుష్మాకం యా యా సమ్పత్తిరస్తి తాం తాం విక్రీయ వితరత, యత్ స్థానం చౌరా నాగచ్ఛన్తి, కీటాశ్చ న క్షాయయన్తి తాదృశే స్వర్గే నిజార్థమ్ అజరే సమ్పుటకే ఽక్షయం ధనం సఞ్చినుత చ; ");
INSERT INTO santel_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","యతో యత్ర యుష్మాకం ధనం వర్త్తతే తత్రేవ యుష్మాకం మనః| ");
INSERT INTO santel_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","అపరఞ్చ యూయం ప్రదీపం జ్వాలయిత్వా బద్ధకటయస్తిష్ఠత; ");
INSERT INTO santel_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ప్రభు ర్వివాహాదాగత్య యదైవ ద్వారమాహన్తి తదైవ ద్వారం మోచయితుం యథా భృత్యా అపేక్ష్య తిష్ఠన్తి తథా యూయమపి తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","యతః ప్రభురాగత్య యాన్ దాసాన్ సచేతనాన్ తిష్ఠతో ద్రక్ష్యతి తఏవ ధన్యాః; అహం యుష్మాన్ యథార్థం వదామి ప్రభుస్తాన్ భోజనార్థమ్ ఉపవేశ్య స్వయం బద్ధకటిః సమీపమేత్య పరివేషయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","యది ద్వితీయే తృతీయే వా ప్రహరే సమాగత్య తథైవ పశ్యతి, తర్హి తఏవ దాసా ధన్యాః| ");
INSERT INTO santel_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","అపరఞ్చ కస్మిన్ క్షణే చౌరా ఆగమిష్యన్తి ఇతి యది గృహపతి ర్జ్ఞాతుం శక్నోతి తదావశ్యం జాగ్రన్ నిజగృహే సన్ధిం కర్త్తయితుం వారయతి యూయమేతద్ విత్త| ");
INSERT INTO santel_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","అతఏవ యూయమపి సజ్జమానాస్తిష్ఠత యతో యస్మిన్ క్షణే తం నాప్రేక్షధ్వే తస్మిన్నేవ క్షణే మనుష్యపుత్ర ఆగమిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","తదా పితరః పప్రచ్ఛ, హే ప్రభో భవాన్ కిమస్మాన్ ఉద్దిశ్య కిం సర్వ్వాన్ ఉద్దిశ్య దృష్టాన్తకథామిమాం వదతి? ");
INSERT INTO santel_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","తతః ప్రభుః ప్రోవాచ, ప్రభుః సముచితకాలే నిజపరివారార్థం భోజ్యపరివేషణాయ యం తత్పదే నియోక్ష్యతి తాదృశో విశ్వాస్యో బోద్ధా కర్మ్మాధీశః కోస్తి? ");
INSERT INTO santel_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ప్రభురాగత్య యమ్ ఏతాదృశే కర్మ్మణి ప్రవృత్తం ద్రక్ష్యతి సఏవ దాసో ధన్యః| ");
INSERT INTO santel_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","అహం యుష్మాన్ యథార్థం వదామి స తం నిజసర్వ్వస్వస్యాధిపతిం కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","కిన్తు ప్రభుర్విలమ్బేనాగమిష్యతి, ఇతి విచిన్త్య స దాసో యది తదన్యదాసీదాసాన్ ప్రహర్త్తుమ్ భోక్తుం పాతుం మదితుఞ్చ ప్రారభతే, ");
INSERT INTO santel_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","తర్హి యదా ప్రభుం నాపేక్షిష్యతే యస్మిన్ క్షణే సోఽచేతనశ్చ స్థాస్యతి తస్మిన్నేవ క్షణే తస్య ప్రభురాగత్య తం పదభ్రష్టం కృత్వా విశ్వాసహీనైః సహ తస్య అంశం నిరూపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","యో దాసః ప్రభేाరాజ్ఞాం జ్ఞాత్వాపి సజ్జితో న తిష్ఠతి తదాజ్ఞానుసారేణ చ కార్య్యం న కరోతి సోనేకాన్ ప్రహారాన్ ప్రాప్స్యతి; ");
INSERT INTO santel_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","కిన్తు యో జనోఽజ్ఞాత్వా ప్రహారార్హం కర్మ్మ కరోతి సోల్పప్రహారాన్ ప్రాప్స్యతి| యతో యస్మై బాహుల్యేన దత్తం తస్మాదేవ బాహుల్యేన గ్రహీష్యతే, మానుషా యస్య నికటే బహు సమర్పయన్తి తస్మాద్ బహు యాచన్తే| ");
INSERT INTO santel_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","అహం పృథివ్యామ్ అనైక్యరూపం వహ్ని నిక్షేప్తుమ్ ఆగతోస్మి, స చేద్ ఇదానీమేవ ప్రజ్వలతి తత్ర మమ కా చిన్తా? ");
INSERT INTO santel_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","కిన్తు యేన మజ్జనేనాహం మగ్నో భవిష్యామి యావత్కాలం తస్య సిద్ధి ర్న భవిష్యతి తావదహం కతికష్టం ప్రాప్స్యామి| ");
INSERT INTO santel_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","మేలనం కర్త్తుం జగద్ ఆగతోస్మి యూయం కిమిత్థం బోధధ్వే? యుష్మాన్ వదామి న తథా, కిన్త్వహం మేలనాభావం కర్త్తుంమ్ ఆగతోస్మి| ");
INSERT INTO santel_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","యస్మాదేతత్కాలమారభ్య ఏకత్రస్థపరిజనానాం మధ్యే పఞ్చజనాః పృథగ్ భూత్వా త్రయో జనా ద్వయోర్జనయోః ప్రతికూలా ద్వౌ జనౌ చ త్రయాణాం జనానాం ప్రతికూలౌ భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","పితా పుత్రస్య విపక్షః పుత్రశ్చ పితు ర్విపక్షో భవిష్యతి మాతా కన్యాయా విపక్షా కన్యా చ మాతు ర్విపక్షా భవిష్యతి, తథా శ్వశ్రూర్బధ్వా విపక్షా బధూశ్చ శ్వశ్ర్వా విపక్షా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","స లోకేభ్యోపరమపి కథయామాస, పశ్చిమదిశి మేఘోద్గమం దృష్ట్వా యూయం హఠాద్ వదథ వృష్టి ర్భవిష్యతి తతస్తథైవ జాయతే| ");
INSERT INTO santel_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","అపరం దక్షిణతో వాయౌ వాతి సతి వదథ నిదాఘో భవిష్యతి తతః సోపి జాయతే| ");
INSERT INTO santel_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","రే రే కపటిన ఆకాశస్య భూమ్యాశ్చ లక్షణం బోద్ధుం శక్నుథ, ");
INSERT INTO santel_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","కిన్తు కాలస్యాస్య లక్షణం కుతో బోద్ధుం న శక్నుథ? యూయఞ్చ స్వయం కుతో న న్యాష్యం విచారయథ? ");
INSERT INTO santel_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","అపరఞ్చ వివాదినా సార్ద్ధం విచారయితుః సమీపం గచ్ఛన్ పథి తస్మాదుద్ధారం ప్రాప్తుం యతస్వ నోచేత్ స త్వాం ధృత్వా విచారయితుః సమీపం నయతి| విచారయితా యది త్వాం ప్రహర్త్తుః సమీపం సమర్పయతి ప్రహర్త్తా త్వాం కారాయాం బధ్నాతి ");
INSERT INTO santel_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","తర్హి త్వామహం వదామి త్వయా నిఃశేషం కపర్దకేషు న పరిశోధితేషు త్వం తతో ముక్తిం ప్రాప్తుం న శక్ష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","అపరఞ్చ పీలాతో యేషాం గాలీలీయానాం రక్తాని బలీనాం రక్తైః సహామిశ్రయత్ తేషాం గాలీలీయానాం వృత్తాన్తం కతిపయజనా ఉపస్థాప్య యీశవే కథయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","తతః స ప్రత్యువాచ తేషాం లోకానామ్ ఏతాదృశీ దుర్గతి ర్ఘటితా తత్కారణాద్ యూయం కిమన్యేభ్యో గాలీలీయేభ్యోప్యధికపాపినస్తాన్ బోధధ్వే? ");
INSERT INTO santel_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","యుష్మానహం వదామి తథా న కిన్తు మనఃసు న పరావర్త్తితేషు యూయమపి తథా నంక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","అపరఞ్చ శీలోహనామ్న ఉచ్చగృహస్య పతనాద్ యేఽష్టాదశజనా మృతాస్తే యిరూశాలమి నివాసిసర్వ్వలోకేభ్యోఽధికాపరాధినః కిం యూయమిత్యం బోధధ్వే? ");
INSERT INTO santel_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","యుష్మానహం వదామి తథా న కిన్తు మనఃసు న పరివర్త్తితేషు యూయమపి తథా నంక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","అనన్తరం స ఇమాం దృష్టాన్తకథామకథయద్ ఏకో జనో ద్రాక్షాక్షేత్రమధ్య ఏకముడుమ్బరవృక్షం రోపితవాన్| పశ్చాత్ స ఆగత్య తస్మిన్ ఫలాని గవేషయామాస, ");
INSERT INTO santel_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","కిన్తు ఫలాప్రాప్తేః కారణాద్ ఉద్యానకారం భృత్యం జగాద, పశ్య వత్సరత్రయం యావదాగత్య ఏతస్మిన్నుడుమ్బరతరౌ క్షలాన్యన్విచ్ఛామి, కిన్తు నైకమపి ప్రప్నోమి తరురయం కుతో వృథా స్థానం వ్యాప్య తిష్ఠతి? ఏనం ఛిన్ధి| ");
INSERT INTO santel_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","తతో భృత్యః ప్రత్యువాచ, హే ప్రభో పునర్వర్షమేకం స్థాతుమ్ ఆదిశ; ఏతస్య మూలస్య చతుర్దిక్షు ఖనిత్వాహమ్ ఆలవాలం స్థాపయామి| ");
INSERT INTO santel_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","తతః ఫలితుం శక్నోతి యది న ఫలతి తర్హి పశ్చాత్ ఛేత్స్యసి| ");
INSERT INTO santel_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","అథ విశ్రామవారే భజనగేహే యీశురుపదిశతి ");
INSERT INTO santel_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","తస్మిత్ సమయే భూతగ్రస్తత్వాత్ కుబ్జీభూయాష్టాదశవర్షాణి యావత్ కేనాప్యుపాయేన ఋజు ర్భవితుం న శక్నోతి యా దుర్బ్బలా స్త్రీ, ");
INSERT INTO santel_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","తాం తత్రోపస్థితాం విలోక్య యీశుస్తామాహూయ కథితవాన్ హే నారి తవ దౌర్బ్బల్యాత్ త్వం ముక్తా భవ| ");
INSERT INTO santel_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","తతః పరం తస్యా గాత్రే హస్తార్పణమాత్రాత్ సా ఋజుర్భూత్వేశ్వరస్య ధన్యవాదం కర్త్తుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","కిన్తు విశ్రామవారే యీశునా తస్యాః స్వాస్థ్యకరణాద్ భజనగేహస్యాధిపతిః ప్రకుప్య లోకాన్ ఉవాచ, షట్సు దినేషు లోకైః కర్మ్మ కర్త్తవ్యం తస్మాద్ధేతోః స్వాస్థ్యార్థం తేషు దినేషు ఆగచ్ఛత, విశ్రామవారే మాగచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","తదా పభుః ప్రత్యువాచ రే కపటినో యుష్మాకమ్ ఏకైకో జనో విశ్రామవారే స్వీయం స్వీయం వృషభం గర్దభం వా బన్ధనాన్మోచయిత్వా జలం పాయయితుం కిం న నయతి? ");
INSERT INTO santel_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","తర్హ్యాష్టాదశవత్సరాన్ యావత్ శైతానా బద్ధా ఇబ్రాహీమః సన్తతిరియం నారీ కిం విశ్రామవారే న మోచయితవ్యా? ");
INSERT INTO santel_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ఏషు వాక్యేషు కథితేషు తస్య విపక్షాః సలజ్జా జాతాః కిన్తు తేన కృతసర్వ్వమహాకర్మ్మకారణాత్ లోకనివహః సానన్దోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","అనన్తరం సోవదద్ ఈశ్వరస్య రాజ్యం కస్య సదృశం? కేన తదుపమాస్యామి? ");
INSERT INTO santel_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","యత్ సర్షపబీజం గృహీత్వా కశ్చిజ్జన ఉద్యాన ఉప్తవాన్ తద్ బీజమఙ్కురితం సత్ మహావృక్షోఽజాయత, తతస్తస్య శాఖాసు విహాయసీయవిహగా ఆగత్య న్యూషుః, తద్రాజ్యం తాదృశేన సర్షపబీజేన తుల్యం| ");
INSERT INTO santel_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","పునః కథయామాస, ఈశ్వరస్య రాజ్యం కస్య సదృశం వదిష్యామి? యత్ కిణ్వం కాచిత్ స్త్రీ గృహీత్వా ద్రోణత్రయపరిమితగోధూమచూర్ణేషు స్థాపయామాస, ");
INSERT INTO santel_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","తతః క్రమేణ తత్ సర్వ్వగోధూమచూర్ణం వ్యాప్నోతి, తస్య కిణ్వస్య తుల్యమ్ ఈశ్వరస్య రాజ్యం| ");
INSERT INTO santel_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","తతః స యిరూశాలమ్నగరం ప్రతి యాత్రాం కృత్వా నగరే నగరే గ్రామే గ్రామే సముపదిశన్ జగామ| ");
INSERT INTO santel_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","తదా కశ్చిజ్జనస్తం పప్రచ్ఛ, హే ప్రభో కిం కేవలమ్ అల్పే లోకాః పరిత్రాస్యన్తే? ");
INSERT INTO santel_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","తతః స లోకాన్ ఉవాచ, సంకీర్ణద్వారేణ ప్రవేష్టుం యతఘ్వం, యతోహం యుష్మాన్ వదామి, బహవః ప్రవేష్టుం చేష్టిష్యన్తే కిన్తు న శక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","గృహపతినోత్థాయ ద్వారే రుద్ధే సతి యది యూయం బహిః స్థిత్వా ద్వారమాహత్య వదథ, హే ప్రభో హే ప్రభో అస్మత్కారణాద్ ద్వారం మోచయతు, తతః స ఇతి ప్రతివక్ష్యతి, యూయం కుత్రత్యా లోకా ఇత్యహం న జానామి| ");
INSERT INTO santel_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","తదా యూయం వదిష్యథ, తవ సాక్షాద్ వయం భేाజనం పానఞ్చ కృతవన్తః, త్వఞ్చాస్మాకం నగరస్య పథి సముపదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","కిన్తు స వక్ష్యతి, యుష్మానహం వదామి, యూయం కుత్రత్యా లోకా ఇత్యహం న జానామి; హే దురాచారిణో యూయం మత్తో దూరీభవత| ");
INSERT INTO santel_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","తదా ఇబ్రాహీమం ఇస్హాకం యాకూబఞ్చ సర్వ్వభవిష్యద్వాదినశ్చ ఈశ్వరస్య రాజ్యం ప్రాప్తాన్ స్వాంశ్చ బహిష్కృతాన్ దృష్ట్వా యూయం రోదనం దన్తైర్దన్తఘర్షణఞ్చ కరిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","అపరఞ్చ పూర్వ్వపశ్చిమదక్షిణోత్తరదిగ్భ్యో లోకా ఆగత్య ఈశ్వరస్య రాజ్యే నివత్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","పశ్యతేత్థం శేషీయా లోకా అగ్రా భవిష్యన్తి, అగ్రీయా లోకాశ్చ శేషా భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","అపరఞ్చ తస్మిన్ దినే కియన్తః ఫిరూశిన ఆగత్య యీశుం ప్రోచుః, బహిర్గచ్ఛ, స్థానాదస్మాత్ ప్రస్థానం కురు, హేరోద్ త్వాం జిఘాంసతి| ");
INSERT INTO santel_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","తతః స ప్రత్యవోచత్ పశ్యతాద్య శ్వశ్చ భూతాన్ విహాప్య రోగిణోఽరోగిణః కృత్వా తృతీయేహ్ని సేత్స్యామి, కథామేతాం యూయమిత్వా తం భూరిమాయం వదత| ");
INSERT INTO santel_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","తత్రాప్యద్య శ్వః పరశ్వశ్చ మయా గమనాగమనే కర్త్తవ్యే, యతో హేతో ర్యిరూశాలమో బహిః కుత్రాపి కోపి భవిష్యద్వాదీ న ఘానిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","హే యిరూశాలమ్ హే యిరూశాలమ్ త్వం భవిష్యద్వాదినో హంసి తవాన్తికే ప్రేరితాన్ ప్రస్తరైర్మారయసి చ, యథా కుక్కుటీ నిజపక్షాధః స్వశావకాన్ సంగృహ్లాతి, తథాహమపి తవ శిశూన్ సంగ్రహీతుం కతివారాన్ ఐచ్ఛం కిన్తు త్వం నైచ్ఛః| ");
INSERT INTO santel_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","పశ్యత యుష్మాకం వాసస్థానాని ప్రోచ్ఛిద్యమానాని పరిత్యక్తాని చ భవిష్యన్తి; యుష్మానహం యథార్థం వదామి, యః ప్రభో ర్నామ్నాగచ్ఛతి స ధన్య ఇతి వాచం యావత్కాలం న వదిష్యథ, తావత్కాలం యూయం మాం న ద్రక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","అనన్తరం విశ్రామవారే యీశౌ ప్రధానస్య ఫిరూశినో గృహే భోక్తుం గతవతి తే తం వీక్షితుమ్ ఆరేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","తదా జలోదరీ తస్య సమ్ముఖే స్థితః| ");
INSERT INTO santel_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","తతః స వ్యవస్థాపకాన్ ఫిరూశినశ్చ పప్రచ్ఛ, విశ్రామవారే స్వాస్థ్యం కర్త్తవ్యం న వా? తతస్తే కిమపి న ప్రత్యూచుః| ");
INSERT INTO santel_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","తదా స తం రోగిణం స్వస్థం కృత్వా విససర్జ; ");
INSERT INTO santel_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","తానువాచ చ యుష్మాకం కస్యచిద్ గర్ద్దభో వృషభో వా చేద్ గర్త్తే పతతి తర్హి విశ్రామవారే తత్క్షణం స కిం తం నోత్థాపయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","తతస్తే కథాయా ఏతస్యాః కిమపి ప్రతివక్తుం న శేకుః| ");
INSERT INTO santel_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","అపరఞ్చ ప్రధానస్థానమనోనీతత్వకరణం విలోక్య స నిమన్త్రితాన్ ఏతదుపదేశకథాం జగాద, ");
INSERT INTO santel_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","త్వం వివాహాదిభోజ్యేషు నిమన్త్రితః సన్ ప్రధానస్థానే మోపావేక్షీః| త్వత్తో గౌరవాన్వితనిమన్త్రితజన ఆయాతే ");
INSERT INTO santel_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","నిమన్త్రయితాగత్య మనుష్యాయైతస్మై స్థానం దేహీతి వాక్యం చేద్ వక్ష్యతి తర్హి త్వం సఙ్కుచితో భూత్వా స్థాన ఇతరస్మిన్ ఉపవేష్టుమ్ ఉద్యంస్యసి| ");
INSERT INTO santel_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","అస్మాత్ కారణాదేవ త్వం నిమన్త్రితో గత్వాఽప్రధానస్థాన ఉపవిశ, తతో నిమన్త్రయితాగత్య వదిష్యతి, హే బన్ధో ప్రోచ్చస్థానం గత్వోపవిశ, తథా సతి భోజనోపవిష్టానాం సకలానాం సాక్షాత్ త్వం మాన్యో భవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","యః కశ్చిత్ స్వమున్నమయతి స నమయిష్యతే, కిన్తు యః కశ్చిత్ స్వం నమయతి స ఉన్నమయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","తదా స నిమన్త్రయితారం జనమపి జగాద, మధ్యాహ్నే రాత్రౌ వా భోజ్యే కృతే నిజబన్ధుగణో వా భ్రాతృृగణో వా జ్ఞాతిగణో వా ధనిగణో వా సమీపవాసిగణో వా ఏతాన్ న నిమన్త్రయ, తథా కృతే చేత్ తే త్వాం నిమన్త్రయిష్యన్తి, తర్హి పరిశోధో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","కిన్తు యదా భేజ్యం కరోషి తదా దరిద్రశుష్కకరఖఞ్జాన్ధాన్ నిమన్త్రయ, ");
INSERT INTO santel_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","తత ఆశిషం లప్స్యసే, తేషు పరిశోధం కర్త్తుమశక్నువత్సు శ్మశానాద్ధార్మ్మికానాముత్థానకాలే త్వం ఫలాం లప్స్యసే| ");
INSERT INTO santel_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","అనన్తరం తాం కథాం నిశమ్య భోజనోపవిష్టః కశ్చిత్ కథయామాస, యో జన ఈశ్వరస్య రాజ్యే భోక్తుం లప్స్యతే సఏవ ధన్యః| ");
INSERT INTO santel_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","తతః స ఉవాచ, కశ్చిత్ జనో రాత్రౌ భేाజ్యం కృత్వా బహూన్ నిమన్త్రయామాస| ");
INSERT INTO santel_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","తతో భోజనసమయే నిమన్త్రితలోకాన్ ఆహ్వాతుం దాసద్వారా కథయామాస, ఖద్యద్రవ్యాణి సర్వ్వాణి సమాసాదితాని సన్తి, యూయమాగచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","కిన్తు తే సర్వ్వ ఏకైకం ఛలం కృత్వా క్షమాం ప్రార్థయాఞ్చక్రిరే| ప్రథమో జనః కథయామాస, క్షేత్రమేకం క్రీతవానహం తదేవ ద్రష్టుం మయా గన్తవ్యమ్, అతఏవ మాం క్షన్తుం తం నివేదయ| ");
INSERT INTO santel_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","అన్యో జనః కథయామాస, దశవృషానహం క్రీతవాన్ తాన్ పరీక్షితుం యామి తస్మాదేవ మాం క్షన్తుం తం నివేదయ| ");
INSERT INTO santel_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","అపరః కథయామాస, వ్యూఢవానహం తస్మాత్ కారణాద్ యాతుం న శక్నోమి| ");
INSERT INTO santel_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","పశ్చాత్ స దాసో గత్వా నిజప్రభోః సాక్షాత్ సర్వ్వవృత్తాన్తం నివేదయామాస, తతోసౌ గృహపతిః కుపిత్వా స్వదాసం వ్యాజహార, త్వం సత్వరం నగరస్య సన్నివేశాన్ మార్గాంశ్చ గత్వా దరిద్రశుష్కకరఖఞ్జాన్ధాన్ అత్రానయ| ");
INSERT INTO santel_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","తతో దాసోఽవదత్, హే ప్రభో భవత ఆజ్ఞానుసారేణాక్రియత తథాపి స్థానమస్తి| ");
INSERT INTO santel_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","తదా ప్రభుః పున ర్దాసాయాకథయత్, రాజపథాన్ వృక్షమూలాని చ యాత్వా మదీయగృహపూరణార్థం లోకానాగన్తుం ప్రవర్త్తయ| ");
INSERT INTO santel_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","అహం యుష్మభ్యం కథయామి, పూర్వ్వనిమన్త్రితానమేకోపి మమాస్య రాత్రిభోజ్యస్యాస్వాదం న ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","అనన్తరం బహుషు లోకేషు యీశోః పశ్చాద్ వ్రజితేషు సత్సు స వ్యాఘుట్య తేభ్యః కథయామాస, ");
INSERT INTO santel_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","యః కశ్చిన్ మమ సమీపమ్ ఆగత్య స్వస్య మాతా పితా పత్నీ సన్తానా భ్రాతరో భగిమ్యో నిజప్రాణాశ్చ, ఏతేభ్యః సర్వ్వేభ్యో మయ్యధికం ప్రేమ న కరోతి, స మమ శిష్యో భవితుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","యః కశ్చిత్ స్వీయం క్రుశం వహన్ మమ పశ్చాన్న గచ్ఛతి, సోపి మమ శిష్యో భవితుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","దుర్గనిర్మ్మాణే కతివ్యయో భవిష్యతి, తథా తస్య సమాప్తికరణార్థం సమ్పత్తిరస్తి న వా, ప్రథమముపవిశ్య ఏతన్న గణయతి, యుష్మాకం మధ్య ఏతాదృశః కోస్తి? ");
INSERT INTO santel_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","నోచేద్ భిత్తిం కృత్వా శేషే యది సమాపయితుం న శక్ష్యతి, ");
INSERT INTO santel_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","తర్హి మానుషోయం నిచేతుమ్ ఆరభత సమాపయితుం నాశక్నోత్, ఇతి వ్యాహృత్య సర్వ్వే తముపహసిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","అపరఞ్చ భిన్నభూపతినా సహ యుద్ధం కర్త్తుమ్ ఉద్యమ్య దశసహస్రాణి సైన్యాని గృహీత్వా వింశతిసహస్రేః సైన్యైః సహితస్య సమీపవాసినః సమ్ముఖం యాతుం శక్ష్యామి న వేతి ప్రథమం ఉపవిశ్య న విచారయతి ఏతాదృశో భూమిపతిః కః? ");
INSERT INTO santel_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","యది న శక్నోతి తర్హి రిపావతిదూరే తిష్ఠతి సతి నిజదూతం ప్రేష్య సన్ధిం కర్త్తుం ప్రార్థయేత| ");
INSERT INTO santel_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","తద్వద్ యుష్మాకం మధ్యే యః కశ్చిన్ మదర్థం సర్వ్వస్వం హాతుం న శక్నోతి స మమ శిష్యో భవితుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","లవణమ్ ఉత్తమమ్ ఇతి సత్యం, కిన్తు యది లవణస్య లవణత్వమ్ అపగచ్ఛతి తర్హి తత్ కథం స్వాదుయుక్తం భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","తద భూమ్యర్థమ్ ఆలవాలరాశ్యర్థమపి భద్రం న భవతి; లోకాస్తద్ బహిః క్షిపన్తి| యస్య శ్రోతుం శ్రోత్రే స్తః స శృణోతు| ");
INSERT INTO santel_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","తదా కరసఞ్చాయినః పాపినశ్చ లోకా ఉపదేశ్కథాం శ్రోతుం యీశోః సమీపమ్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","తతః ఫిరూశిన ఉపాధ్యాయాశ్చ వివదమానాః కథయామాసుః ఏష మానుషః పాపిభిః సహ ప్రణయం కృత్వా తైః సార్ద్ధం భుంక్తే| ");
INSERT INTO santel_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","తదా స తేభ్య ఇమాం దృష్టాన్తకథాం కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","కస్యచిత్ శతమేషేషు తిష్ఠత్ము తేషామేకం స యది హారయతి తర్హి మధ్యేప్రాన్తరమ్ ఏకోనశతమేషాన్ విహాయ హారితమేషస్య ఉద్దేశప్రాప్తిపర్య్యనతం న గవేషయతి, ఏతాదృశో లోకో యుష్మాకం మధ్యే క ఆస్తే? ");
INSERT INTO santel_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","తస్యోద్దేశం ప్రాప్య హృష్టమనాస్తం స్కన్ధే నిధాయ స్వస్థానమ్ ఆనీయ బన్ధుబాన్ధవసమీపవాసిన ఆహూయ వక్తి, ");
INSERT INTO santel_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","హారితం మేషం ప్రాప్తోహమ్ అతో హేతో ర్మయా సార్ద్ధమ్ ఆనన్దత| ");
INSERT INTO santel_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","తద్వదహం యుష్మాన్ వదామి, యేషాం మనఃపరావర్త్తనస్య ప్రయోజనం నాస్తి, తాదృశైకోనశతధార్మ్మికకారణాద్ య ఆనన్దస్తస్మాద్ ఏకస్య మనఃపరివర్త్తినః పాపినః కారణాత్ స్వర్గే ఽధికానన్దో జాయతే| ");
INSERT INTO santel_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","అపరఞ్చ దశానాం రూప్యఖణ్డానామ్ ఏకఖణ్డే హారితే ప్రదీపం ప్రజ్వాల్య గృహం సమ్మార్జ్య తస్య ప్రాప్తిం యావద్ యత్నేన న గవేషయతి, ఏతాదృశీ యోషిత్ కాస్తే? ");
INSERT INTO santel_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ప్రాప్తే సతి బన్ధుబాన్ధవసమీపవాసినీరాహూయ కథయతి, హారితం రూప్యఖణ్డం ప్రాప్తాహం తస్మాదేవ మయా సార్ద్ధమ్ ఆనన్దత| ");
INSERT INTO santel_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","తద్వదహం యుష్మాన్ వ్యాహరామి, ఏకేన పాపినా మనసి పరివర్త్తితే, ఈశ్వరస్య దూతానాం మధ్యేప్యానన్దో జాయతే| ");
INSERT INTO santel_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","అపరఞ్చ స కథయామాస, కస్యచిద్ ద్వౌ పుత్రావాస్తాం, ");
INSERT INTO santel_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","తయోః కనిష్ఠః పుత్రః పిత్రే కథయామాస, హే పితస్తవ సమ్పత్త్యా యమంశం ప్రాప్స్యామ్యహం విభజ్య తం దేహి, తతః పితా నిజాం సమ్పత్తిం విభజ్య తాభ్యాం దదౌ| ");
INSERT INTO santel_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","కతిపయాత్ కాలాత్ పరం స కనిష్ఠపుత్రః సమస్తం ధనం సంగృహ్య దూరదేశం గత్వా దుష్టాచరణేన సర్వ్వాం సమ్పత్తిం నాశయామాస| ");
INSERT INTO santel_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","తస్య సర్వ్వధనే వ్యయం గతే తద్దేశే మహాదుర్భిక్షం బభూవ, తతస్తస్య దైన్యదశా భవితుమ్ ఆరేభే| ");
INSERT INTO santel_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","తతః పరం స గత్వా తద్దేశీయం గృహస్థమేకమ్ ఆశ్రయత; తతః సతం శూకరవ్రజం చారయితుం ప్రాన్తరం ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","కేనాపి తస్మై భక్ష్యాదానాత్ స శూకరఫలవల్కలేన పిచిణ్డపూరణాం వవాఞ్ఛ| ");
INSERT INTO santel_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","శేషే స మనసి చేతనాం ప్రాప్య కథయామాస, హా మమ పితుః సమీపే కతి కతి వేతనభుజో దాసా యథేష్టం తతోధికఞ్చ భక్ష్యం ప్రాప్నువన్తి కిన్త్వహం క్షుధా ముమూర్షుః| ");
INSERT INTO santel_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","అహముత్థాయ పితుః సమీపం గత్వా కథామేతాం వదిష్యామి, హే పితర్ ఈశ్వరస్య తవ చ విరుద్ధం పాపమకరవమ్ ");
INSERT INTO santel_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","తవ పుత్రఇతి విఖ్యాతో భవితుం న యోగ్యోస్మి చ, మాం తవ వైతనికం దాసం కృత్వా స్థాపయ| ");
INSERT INTO santel_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","పశ్చాత్ స ఉత్థాయ పితుః సమీపం జగామ; తతస్తస్య పితాతిదూరే తం నిరీక్ష్య దయాఞ్చక్రే, ధావిత్వా తస్య కణ్ఠం గృహీత్వా తం చుచుమ్బ చ| ");
INSERT INTO santel_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","తదా పుత్ర ఉవాచ, హే పితర్ ఈశ్వరస్య తవ చ విరుద్ధం పాపమకరవం, తవ పుత్రఇతి విఖ్యాతో భవితుం న యోగ్యోస్మి చ| ");
INSERT INTO santel_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","కిన్తు తస్య పితా నిజదాసాన్ ఆదిదేశ, సర్వ్వోత్తమవస్త్రాణ్యానీయ పరిధాపయతైనం హస్తే చాఙ్గురీయకమ్ అర్పయత పాదయోశ్చోపానహౌ సమర్పయత; ");
INSERT INTO santel_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","పుష్టం గోవత్సమ్ ఆనీయ మారయత చ తం భుక్త్వా వయమ్ ఆనన్దామ| ");
INSERT INTO santel_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","యతో మమ పుత్రోయమ్ అమ్రియత పునరజీవీద్ హారితశ్చ లబ్ధోభూత్ తతస్త ఆనన్దితుమ్ ఆరేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","తత్కాలే తస్య జ్యేష్ఠః పుత్రః క్షేత్ర ఆసీత్| అథ స నివేశనస్య నికటం ఆగచ్ఛన్ నృత్యానాం వాద్యానాఞ్చ శబ్దం శ్రుత్వా ");
INSERT INTO santel_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","దాసానామ్ ఏకమ్ ఆహూయ పప్రచ్ఛ, కిం కారణమస్య? ");
INSERT INTO santel_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","తతః సోవాదీత్, తవ భ్రాతాగమత్, తవ తాతశ్చ తం సుశరీరం ప్రాప్య పుష్టం గోవత్సం మారితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","తతః స ప్రకుప్య నివేశనాన్తః ప్రవేష్టుం న సమ్మేనే; తతస్తస్య పితా బహిరాగత్య తం సాధయామాస| ");
INSERT INTO santel_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","తతః స పితరం ప్రత్యువాచ, పశ్య తవ కాఞ్చిదప్యాజ్ఞాం న విలంఘ్య బహూన్ వత్సరాన్ అహం త్వాం సేవే తథాపి మిత్రైః సార్ద్ధమ్ ఉత్సవం కర్త్తుం కదాపి ఛాగమేకమపి మహ్యం నాదదాః; ");
INSERT INTO santel_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","కిన్తు తవ యః పుత్రో వేశ్యాగమనాదిభిస్తవ సమ్పత్తిమ్ అపవ్యయితవాన్ తస్మిన్నాగతమాత్రే తస్యైవ నిమిత్తం పుష్టం గోవత్సం మారితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","తదా తస్య పితావోచత్, హే పుత్ర త్వం సర్వ్వదా మయా సహాసి తస్మాన్ మమ యద్యదాస్తే తత్సర్వ్వం తవ| ");
INSERT INTO santel_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","కిన్తు తవాయం భ్రాతా మృతః పునరజీవీద్ హారితశ్చ భూత్వా ప్రాప్తోభూత్, ఏతస్మాత్ కారణాద్ ఉత్సవానన్దౌ కర్త్తుమ్ ఉచితమస్మాకమ్| ");
INSERT INTO santel_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","అపరఞ్చ యీశుః శిష్యేభ్యోన్యామేకాం కథాం కథయామాస కస్యచిద్ ధనవతో మనుష్యస్య గృహకార్య్యాధీశే సమ్పత్తేరపవ్యయేఽపవాదితే సతి ");
INSERT INTO santel_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","తస్య ప్రభుస్తమ్ ఆహూయ జగాద, త్వయి యామిమాం కథాం శృణోమి సా కీదృశీ? త్వం గృహకార్య్యాధీశకర్మ్మణో గణనాం దర్శయ గృహకార్య్యాధీశపదే త్వం న స్థాస్యసి| ");
INSERT INTO santel_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","తదా స గృహకార్య్యాధీశో మనసా చిన్తయామాస, ప్రభు ర్యది మాం గృహకార్య్యాధీశపదాద్ భ్రంశయతి తర్హి కిం కరిష్యేఽహం? మృదం ఖనితుం మమ శక్తి ర్నాస్తి భిక్షితుఞ్చ లజ్జిష్యేఽహం| ");
INSERT INTO santel_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","అతఏవ మయి గృహకార్య్యాధీశపదాత్ చ్యుతే సతి యథా లోకా మహ్యమ్ ఆశ్రయం దాస్యన్తి తదర్థం యత్కర్మ్మ మయా కరణీయం తన్ నిర్ణీయతే| ");
INSERT INTO santel_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","పశ్చాత్ స స్వప్రభోరేకైకమ్ అధమర్ణమ్ ఆహూయ ప్రథమం పప్రచ్ఛ, త్వత్తో మే ప్రభుణా కతి ప్రాప్యమ్? ");
INSERT INTO santel_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","తతః స ఉవాచ, ఏకశతాఢకతైలాని; తదా గృహకార్య్యాధీశః ప్రోవాచ, తవ పత్రమానీయ శీఘ్రముపవిశ్య తత్ర పఞ్చాశతం లిఖ| ");
INSERT INTO santel_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","పశ్చాదన్యమేకం పప్రచ్ఛ, త్వత్తో మే ప్రభుణా కతి ప్రాప్యమ్? తతః సోవాదీద్ ఏకశతాఢకగోధూమాః; తదా స కథయామాస, తవ పత్రమానీయ అశీతిం లిఖ| ");
INSERT INTO santel_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","తేనైవ ప్రభుస్తమయథార్థకృతమ్ అధీశం తద్బుద్ధినైపుణ్యాత్ ప్రశశంస; ఇత్థం దీప్తిరూపసన్తానేభ్య ఏతత్సంసారస్య సన్తానా వర్త్తమానకాలేఽధికబుద్ధిమన్తో భవన్తి| ");
INSERT INTO santel_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","అతో వదామి యూయమప్యయథార్థేన ధనేన మిత్రాణి లభధ్వం తతో యుష్మాసు పదభ్రష్టేష్వపి తాని చిరకాలమ్ ఆశ్రయం దాస్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","యః కశ్చిత్ క్షుద్రే కార్య్యే విశ్వాస్యో భవతి స మహతి కార్య్యేపి విశ్వాస్యో భవతి, కిన్తు యః కశ్చిత్ క్షుద్రే కార్య్యేఽవిశ్వాస్యో భవతి స మహతి కార్య్యేప్యవిశ్వాస్యో భవతి| ");
INSERT INTO santel_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","అతఏవ అయథార్థేన ధనేన యది యూయమవిశ్వాస్యా జాతాస్తర్హి సత్యం ధనం యుష్మాకం కరేషు కః సమర్పయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","యది చ పరధనేన యూయమ్ అవిశ్వాస్యా భవథ తర్హి యుష్మాకం స్వకీయధనం యుష్మభ్యం కో దాస్యతి? ");
INSERT INTO santel_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","కోపి దాస ఉభౌ ప్రభూ సేవితుం న శక్నోతి, యత ఏకస్మిన్ ప్రీయమాణోఽన్యస్మిన్నప్రీయతే యద్వా ఏకం జనం సమాదృత్య తదన్యం తుచ్ఛీకరోతి తద్వద్ యూయమపి ధనేశ్వరౌ సేవితుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","తదైతాః సర్వ్వాః కథాః శ్రుత్వా లోభిఫిరూశినస్తముపజహసుః| ");
INSERT INTO santel_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","తతః స ఉవాచ, యూయం మనుష్యాణాం నికటే స్వాన్ నిర్దోషాన్ దర్శయథ కిన్తు యుష్మాకమ్ అన్తఃకరణానీశ్వరో జానాతి, యత్ మనుష్యాణామ్ అతి ప్రశంస్యం తద్ ఈశ్వరస్య ఘృణ్యం| ");
INSERT INTO santel_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","యోహన ఆగమనపర్య్యనతం యుష్మాకం సమీపే వ్యవస్థాభవిష్యద్వాదినాం లేఖనాని చాసన్ తతః ప్రభృతి ఈశ్వరరాజ్యస్య సుసంవాదః ప్రచరతి, ఏకైకో లోకస్తన్మధ్యం యత్నేన ప్రవిశతి చ| ");
INSERT INTO santel_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","వరం నభసః పృథివ్యాశ్చ లోపో భవిష్యతి తథాపి వ్యవస్థాయా ఏకబిన్దోరపి లోపో న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","యః కశ్చిత్ స్వీయాం భార్య్యాం విహాయ స్త్రియమన్యాం వివహతి స పరదారాన్ గచ్ఛతి, యశ్చ తా త్యక్తాం నారీం వివహతి సోపి పరదారాన గచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ఏకో ధనీ మనుష్యః శుక్లాని సూక్ష్మాణి వస్త్రాణి పర్య్యదధాత్ ప్రతిదినం పరితోషరూపేణాభుంక్తాపివచ్చ| ");
INSERT INTO santel_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","సర్వ్వాఙ్గే క్షతయుక్త ఇలియాసరనామా కశ్చిద్ దరిద్రస్తస్య ధనవతో భోజనపాత్రాత్ పతితమ్ ఉచ్ఛిష్టం భోక్తుం వాఞ్ఛన్ తస్య ద్వారే పతిత్వాతిష్ఠత్; ");
INSERT INTO santel_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","అథ శ్వాన ఆగత్య తస్య క్షతాన్యలిహన్| ");
INSERT INTO santel_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","కియత్కాలాత్పరం స దరిద్రః ప్రాణాన్ జహౌ; తతః స్వర్గీయదూతాస్తం నీత్వా ఇబ్రాహీమః క్రోడ ఉపవేశయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","పశ్చాత్ స ధనవానపి మమార, తం శ్మశానే స్థాపయామాసుశ్చ; కిన్తు పరలోకే స వేదనాకులః సన్ ఊర్ద్ధ్వాం నిరీక్ష్య బహుదూరాద్ ఇబ్రాహీమం తత్క్రోడ ఇలియాసరఞ్చ విలోక్య రువన్నువాచ; ");
INSERT INTO santel_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","హే పితర్ ఇబ్రాహీమ్ అనుగృహ్య అఙ్గుల్యగ్రభాగం జలే మజ్జయిత్వా మమ జిహ్వాం శీతలాం కర్త్తుమ్ ఇలియాసరం ప్రేరయ, యతో వహ్నిశిఖాతోహం వ్యథితోస్మి| ");
INSERT INTO santel_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","తదా ఇబ్రాహీమ్ బభాషే, హే పుత్ర త్వం జీవన్ సమ్పదం ప్రాప్తవాన్ ఇలియాసరస్తు విపదం ప్రాప్తవాన్ ఏతత్ స్మర, కిన్తు సమ్ప్రతి తస్య సుఖం తవ చ దుఃఖం భవతి| ");
INSERT INTO santel_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","అపరమపి యుష్మాకమ్ అస్మాకఞ్చ స్థానయో ర్మధ్యే మహద్విచ్ఛేదోఽస్తి తత ఏతత్స్థానస్య లోకాస్తత్ స్థానం యాతుం యద్వా తత్స్థానస్య లోకా ఏతత్ స్థానమాయాతుం న శక్నువన్తి| ");
INSERT INTO santel_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","తదా స ఉక్తవాన్, హే పితస్తర్హి త్వాం నివేదయామి మమ పితు ర్గేహే యే మమ పఞ్చ భ్రాతరః సన్తి ");
INSERT INTO santel_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","తే యథైతద్ యాతనాస్థానం నాయాస్యన్తి తథా మన్త్రణాం దాతుం తేషాం సమీపమ్ ఇలియాసరం ప్రేరయ| ");
INSERT INTO santel_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","తత ఇబ్రాహీమ్ ఉవాచ, మూసాభవిష్యద్వాదినాఞ్చ పుస్తకాని తేషాం నికటే సన్తి తే తద్వచనాని మన్యన్తాం| ");
INSERT INTO santel_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","తదా స నివేదయామాస, హే పితర్ ఇబ్రాహీమ్ న తథా, కిన్తు యది మృతలోకానాం కశ్చిత్ తేషాం సమీపం యాతి తర్హి తే మనాంసి వ్యాఘోటయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","తత ఇబ్రాహీమ్ జగాద, తే యది మూసాభవిష్యద్వాదినాఞ్చ వచనాని న మన్యన్తే తర్హి మృతలోకానాం కస్మింశ్చిద్ ఉత్థితేపి తే తస్య మన్త్రణాం న మంస్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ఇతః పరం యీశుః శిష్యాన్ ఉవాచ, విఘ్నైరవశ్యమ్ ఆగన్తవ్యం కిన్తు విఘ్నా యేన ఘటిష్యన్తే తస్య దుర్గతి ర్భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ఏతేషాం క్షుద్రప్రాణినామ్ ఏకస్యాపి విఘ్నజననాత్ కణ్ఠబద్ధపేషణీకస్య తస్య సాగరాగాధజలే మజ్జనం భద్రం| ");
INSERT INTO santel_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","యూయం స్వేషు సావధానాస్తిష్ఠత; తవ భ్రాతా యది తవ కిఞ్చిద్ అపరాధ్యతి తర్హి తం తర్జయ, తేన యది మనః పరివర్త్తయతి తర్హి తం క్షమస్వ| ");
INSERT INTO santel_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","పునరేకదినమధ్యే యది స తవ సప్తకృత్వోఽపరాధ్యతి కిన్తు సప్తకృత్వ ఆగత్య మనః పరివర్త్య మయాపరాద్ధమ్ ఇతి వదతి తర్హి తం క్షమస్వ| ");
INSERT INTO santel_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","తదా ప్రేరితాః ప్రభుమ్ అవదన్ అస్మాకం విశ్వాసం వర్ద్ధయ| ");
INSERT INTO santel_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ప్రభురువాచ, యది యుష్మాకం సర్షపైకప్రమాణో విశ్వాసోస్తి తర్హి త్వం సమూలముత్పాటితో భూత్వా సముద్రే రోపితో భవ కథాయామ్ ఏతస్యామ్ ఏతదుడుమ్బరాయ కథితాయాం స యుష్మాకమాజ్ఞావహో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","అపరం స్వదాసే హలం వాహయిత్వా వా పశూన్ చారయిత్వా క్షేత్రాద్ ఆగతే సతి తం వదతి, ఏహి భోక్తుముపవిశ, యుష్మాకమ్ ఏతాదృశః కోస్తి? ");
INSERT INTO santel_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","వరఞ్చ పూర్వ్వం మమ ఖాద్యమాసాద్య యావద్ భుఞ్జే పివామి చ తావద్ బద్ధకటిః పరిచర పశ్చాత్ త్వమపి భోక్ష్యసే పాస్యసి చ కథామీదృశీం కిం న వక్ష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","తేన దాసేన ప్రభోరాజ్ఞానురూపే కర్మ్మణి కృతే ప్రభుః కిం తస్మిన్ బాధితో జాతః? నేత్థం బుధ్యతే మయా| ");
INSERT INTO santel_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ఇత్థం నిరూపితేషు సర్వ్వకర్మ్మసు కృతేషు సత్ము యూయమపీదం వాక్యం వదథ, వయమ్ అనుపకారిణో దాసా అస్మాభిర్యద్యత్కర్త్తవ్యం తన్మాత్రమేవ కృతం| ");
INSERT INTO santel_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","స యిరూశాలమి యాత్రాం కుర్వ్వన్ శోమిరోణ్గాలీల్ప్రదేశమధ్యేన గచ్ఛతి, ");
INSERT INTO santel_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ఏతర్హి కుత్రచిద్ గ్రామే ప్రవేశమాత్రే దశకుష్ఠినస్తం సాక్షాత్ కృత్వా ");
INSERT INTO santel_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","దూరే తిష్ఠనత ఉచ్చై ర్వక్తుమారేభిరే, హే ప్రభో యీశో దయస్వాస్మాన్| ");
INSERT INTO santel_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","తతః స తాన్ దృష్ట్వా జగాద, యూయం యాజకానాం సమీపే స్వాన్ దర్శయత, తతస్తే గచ్ఛన్తో రోగాత్ పరిష్కృతాః| ");
INSERT INTO santel_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","తదా తేషామేకః స్వం స్వస్థం దృష్ట్వా ప్రోచ్చైరీశ్వరం ధన్యం వదన్ వ్యాఘుట్యాయాతో యీశో ర్గుణాననువదన్ తచ్చరణాధోభూమౌ పపాత; ");
INSERT INTO santel_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","స చాసీత్ శోమిరోణీ| ");
INSERT INTO santel_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","తదా యీశురవదత్, దశజనాః కిం న పరిష్కృతాః? తహ్యన్యే నవజనాః కుత్ర? ");
INSERT INTO santel_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ఈశ్వరం ధన్యం వదన్తమ్ ఏనం విదేశినం వినా కోప్యన్యో న ప్రాప్యత| ");
INSERT INTO santel_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","తదా స తమువాచ, త్వముత్థాయ యాహి విశ్వాసస్తే త్వాం స్వస్థం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","అథ కదేశ్వరస్య రాజత్వం భవిష్యతీతి ఫిరూశిభిః పృష్టే స ప్రత్యువాచ, ఈశ్వరస్య రాజత్వమ్ ఐశ్వర్య్యదర్శనేన న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","అత ఏతస్మిన్ పశ్య తస్మిన్ వా పశ్య, ఇతి వాక్యం లోకా వక్తుం న శక్ష్యన్తి, ఈశ్వరస్య రాజత్వం యుష్మాకమ్ అన్తరేవాస్తే| ");
INSERT INTO santel_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","తతః స శిష్యాన్ జగాద, యదా యుష్మాభి ర్మనుజసుతస్య దినమేకం ద్రష్టుమ్ వాఞ్ఛిష్యతే కిన్తు న దర్శిష్యతే, ఈదృక్కాల ఆయాతి| ");
INSERT INTO santel_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","తదాత్ర పశ్య వా తత్ర పశ్యేతి వాక్యం లోకా వక్ష్యన్తి, కిన్తు తేషాం పశ్చాత్ మా యాత, మానుగచ్ఛత చ| ");
INSERT INTO santel_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","యతస్తడిద్ యథాకాశైకదిశ్యుదియ తదన్యామపి దిశం వ్యాప్య ప్రకాశతే తద్వత్ నిజదినే మనుజసూనుః ప్రకాశిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","కిన్తు తత్పూర్వ్వం తేనానేకాని దుఃఖాని భోక్తవ్యాన్యేతద్వర్త్తమానలోకైశ్చ సోఽవజ్ఞాతవ్యః| ");
INSERT INTO santel_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","నోహస్య విద్యమానకాలే యథాభవత్ మనుష్యసూనోః కాలేపి తథా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","యావత్కాలం నోహో మహాపోతం నారోహద్ ఆప్లావివార్య్యేత్య సర్వ్వం నానాశయచ్చ తావత్కాలం యథా లోకా అభుఞ్జతాపివన్ వ్యవహన్ వ్యవాహయంశ్చ; ");
INSERT INTO santel_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ఇత్థం లోటో వర్త్తమానకాలేపి యథా లోకా భోజనపానక్రయవిక్రయరోపణగృహనిర్మ్మాణకర్మ్మసు ప్రావర్త్తన్త, ");
INSERT INTO santel_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","కిన్తు యదా లోట్ సిదోమో నిర్జగామ తదా నభసః సగన్ధకాగ్నివృష్టి ర్భూత్వా సర్వ్వం వ్యనాశయత్ ");
INSERT INTO santel_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","తద్వన్ మానవపుత్రప్రకాశదినేపి భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","తదా యది కశ్చిద్ గృహోపరి తిష్ఠతి తర్హి స గృహమధ్యాత్ కిమపి ద్రవ్యమానేతుమ్ అవరుహ్య నైతు; యశ్చ క్షేత్రే తిష్ఠతి సోపి వ్యాఘుట్య నాయాతు| ");
INSERT INTO santel_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","లోటః పత్నీం స్మరత| ");
INSERT INTO santel_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","యః ప్రాణాన్ రక్షితుం చేష్టిష్యతే స ప్రాణాన్ హారయిష్యతి యస్తు ప్రాణాన్ హారయిష్యతి సఏవ ప్రాణాన్ రక్షిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","యుష్మానహం వచ్మి తస్యాం రాత్రౌ శయ్యైకగతయో ర్లోకయోరేకో ధారిష్యతే పరస్త్యక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","స్త్రియౌ యుగపత్ పేషణీం వ్యావర్త్తయిష్యతస్తయోరేకా ధారిష్యతే పరాత్యక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","పురుషౌ క్షేత్రే స్థాస్యతస్తయోరేకో ధారిష్యతే పరస్త్యక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","తదా తే పప్రచ్ఛుః, హే ప్రభో కుత్రేత్థం భవిష్యతి? తతః స ఉవాచ, యత్ర శవస్తిష్ఠతి తత్ర గృధ్రా మిలన్తి| ");
INSERT INTO santel_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","అపరఞ్చ లోకైరక్లాన్తై ర్నిరన్తరం ప్రార్థయితవ్యమ్ ఇత్యాశయేన యీశునా దృష్టాన్త ఏకః కథితః| ");
INSERT INTO santel_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","కుత్రచిన్నగరే కశ్చిత్ ప్రాడ్వివాక ఆసీత్ స ఈశ్వరాన్నాబిభేత్ మానుషాంశ్చ నామన్యత| ");
INSERT INTO santel_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","అథ తత్పురవాసినీ కాచిద్విధవా తత్సమీపమేత్య వివాదినా సహ మమ వివాదం పరిష్కుర్వ్వితి నివేదయామాస| ");
INSERT INTO santel_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","తతః స ప్రాడ్వివాకః కియద్దినాని న తదఙ్గీకృతవాన్ పశ్చాచ్చిత్తే చిన్తయామాస, యద్యపీశ్వరాన్న బిభేమి మనుష్యానపి న మన్యే ");
INSERT INTO santel_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","తథాప్యేషా విధవా మాం క్లిశ్నాతి తస్మాదస్యా వివాదం పరిష్కరిష్యామి నోచేత్ సా సదాగత్య మాం వ్యగ్రం కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","పశ్చాత్ ప్రభురవదద్ అసావన్యాయప్రాడ్వివాకో యదాహ తత్ర మనో నిధధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ఈశ్వరస్య యే ఽభిరుచితలోకా దివానిశం ప్రార్థయన్తే స బహుదినాని విలమ్బ్యాపి తేషాం వివాదాన్ కిం న పరిష్కరిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","యుష్మానహం వదామి త్వరయా పరిష్కరిష్యతి, కిన్తు యదా మనుష్యపుత్ర ఆగమిష్యతి తదా పృథివ్యాం కిమీదృశం విశ్వాసం ప్రాప్స్యతి? ");
INSERT INTO santel_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","యే స్వాన్ ధార్మ్మికాన్ జ్ఞాత్వా పరాన్ తుచ్ఛీకుర్వ్వన్తి ఏతాదృగ్భ్యః, కియద్భ్య ఇమం దృష్టాన్తం కథయామాస| ");
INSERT INTO santel_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ఏకః ఫిరూశ్యపరః కరసఞ్చాయీ ద్వావిమౌ ప్రార్థయితుం మన్దిరం గతౌ| ");
INSERT INTO santel_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","తతోఽసౌ ఫిరూశ్యేకపార్శ్వే తిష్ఠన్ హే ఈశ్వర అహమన్యలోకవత్ లోఠయితాన్యాయీ పారదారికశ్చ న భవామి అస్య కరసఞ్చాయినస్తుల్యశ్చ న, తస్మాత్త్వాం ధన్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","సప్తసు దినేషు దినద్వయముపవసామి సర్వ్వసమ్పత్తే ర్దశమాంశం దదామి చ, ఏతత్కథాం కథయన్ ప్రార్థయామాస| ");
INSERT INTO santel_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","కిన్తు స కరసఞ్చాయి దూరే తిష్ఠన్ స్వర్గం ద్రష్టుం నేచ్ఛన్ వక్షసి కరాఘాతం కుర్వ్వన్ హే ఈశ్వర పాపిష్ఠం మాం దయస్వ, ఇత్థం ప్రార్థయామాస| ");
INSERT INTO santel_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","యుష్మానహం వదామి, తయోర్ద్వయో ర్మధ్యే కేవలః కరసఞ్చాయీ పుణ్యవత్త్వేన గణితో నిజగృహం జగామ, యతో యః కశ్చిత్ స్వమున్నమయతి స నామయిష్యతే కిన్తు యః కశ్చిత్ స్వం నమయతి స ఉన్నమయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","అథ శిశూనాం గాత్రస్పర్శార్థం లోకాస్తాన్ తస్య సమీపమానిన్యుః శిష్యాస్తద్ దృష్ట్వానేతృన్ తర్జయామాసుః, ");
INSERT INTO santel_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","కిన్తు యీశుస్తానాహూయ జగాద, మన్నికటమ్ ఆగన్తుం శిశూన్ అనుజానీధ్వం తాంశ్చ మా వారయత; యత ఈశ్వరరాజ్యాధికారిణ ఏషాం సదృశాః| ");
INSERT INTO santel_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","అహం యుష్మాన్ యథార్థం వదామి, యో జనః శిశోః సదృశో భూత్వా ఈశ్వరరాజ్యం న గృహ్లాతి స కేనాపి ప్రకారేణ తత్ ప్రవేష్టుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","అపరమ్ ఏకోధిపతిస్తం పప్రచ్ఛ, హే పరమగురో, అనన్తాయుషః ప్రాప్తయే మయా కిం కర్త్తవ్యం? ");
INSERT INTO santel_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","యీశురువాచ, మాం కుతః పరమం వదసి? ఈశ్వరం వినా కోపి పరమో న భవతి| ");
INSERT INTO santel_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","పరదారాన్ మా గచ్ఛ, నరం మా జహి, మా చోరయ, మిథ్యాసాక్ష్యం మా దేహి, మాతరం పితరఞ్చ సంమన్యస్వ, ఏతా యా ఆజ్ఞాః సన్తి తాస్త్వం జానాసి| ");
INSERT INTO santel_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","తదా స ఉవాచ, బాల్యకాలాత్ సర్వ్వా ఏతా ఆచరామి| ");
INSERT INTO santel_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ఇతి కథాం శ్రుత్వా యీశుస్తమవదత్, తథాపి తవైకం కర్మ్మ న్యూనమాస్తే, నిజం సర్వ్వస్వం విక్రీయ దరిద్రేభ్యో వితర, తస్మాత్ స్వర్గే ధనం ప్రాప్స్యసి; తత ఆగత్య మమానుగామీ భవ| ");
INSERT INTO santel_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","కిన్త్వేతాం కథాం శ్రుత్వా సోధిపతిః శుశోచ, యతస్తస్య బహుధనమాసీత్| ");
INSERT INTO santel_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","తదా యీశుస్తమతిశోకాన్వితం దృష్ట్వా జగాద, ధనవతామ్ ఈశ్వరరాజ్యప్రవేశః కీదృగ్ దుష్కరః| ");
INSERT INTO santel_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ఈశ్వరరాజ్యే ధనినః ప్రవేశాత్ సూచేశ్ఛిద్రేణ మహాఙ్గస్య గమనాగమనే సుకరే| ");
INSERT INTO santel_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","శ్రోతారః పప్రచ్ఛుస్తర్హి కేన పరిత్రాణం ప్రాప్స్యతే? ");
INSERT INTO santel_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","స ఉక్తవాన్, యన్ మానుషేణాశక్యం తద్ ఈశ్వరేణ శక్యం| ");
INSERT INTO santel_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","తదా పితర ఉవాచ, పశ్య వయం సర్వ్వస్వం పరిత్యజ్య తవ పశ్చాద్గామినోఽభవామ| ");
INSERT INTO santel_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","తతః స ఉవాచ, యుష్మానహం యథార్థం వదామి, ఈశ్వరరాజ్యార్థం గృహం పితరౌ భ్రాతృగణం జాయాం సన్తానాంశ్చ త్యక్తవా ");
INSERT INTO santel_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ఇహ కాలే తతోఽధికం పరకాలే ఽనన్తాయుశ్చ న ప్రాప్స్యతి లోక ఈదృశః కోపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","అనన్తరం స ద్వాదశశిష్యానాహూయ బభాషే, పశ్యత వయం యిరూశాలమ్నగరం యామః, తస్మాత్ మనుష్యపుత్రే భవిష్యద్వాదిభిరుక్తం యదస్తి తదనురూపం తం ప్రతి ఘటిష్యతే; ");
INSERT INTO santel_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","వస్తుతస్తు సోఽన్యదేశీయానాం హస్తేషు సమర్పయిష్యతే, తే తముపహసిష్యన్తి, అన్యాయమాచరిష్యన్తి తద్వపుషి నిష్ఠీవం నిక్షేప్స్యన్తి, కశాభిః ప్రహృత్య తం హనిష్యన్తి చ, ");
INSERT INTO santel_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","కిన్తు తృతీయదినే స శ్మశానాద్ ఉత్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ఏతస్యాః కథాయా అభిప్రాయం కిఞ్చిదపి తే బోద్ధుం న శేకుః తేషాం నికటేఽస్పష్టతవాత్ తస్యైతాసాం కథానామ్ ఆశయం తే జ్ఞాతుం న శేకుశ్చ| ");
INSERT INTO santel_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","అథ తస్మిన్ యిరీహోః పురస్యాన్తికం ప్రాప్తే కశ్చిదన్ధః పథః పార్శ్వ ఉపవిశ్య భిక్షామ్ అకరోత్ ");
INSERT INTO santel_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","స లోకసమూహస్య గమనశబ్దం శ్రుత్వా తత్కారణం పృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","నాసరతీయయీశుర్యాతీతి లోకైరుక్తే స ఉచ్చైర్వక్తుమారేభే, ");
INSERT INTO santel_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","హే దాయూదః సన్తాన యీశో మాం దయస్వ| ");
INSERT INTO santel_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","తతోగ్రగామినస్తం మౌనీ తిష్ఠేతి తర్జయామాసుః కిన్తు స పునారువన్ ఉవాచ, హే దాయూదః సన్తాన మాం దయస్వ| ");
INSERT INTO santel_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","తదా యీశుః స్థగితో భూత్వా స్వాన్తికే తమానేతుమ్ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","తతః స తస్యాన్తికమ్ ఆగమత్, తదా స తం పప్రచ్ఛ, త్వం కిమిచ్ఛసి? త్వదర్థమహం కిం కరిష్యామి? స ఉక్తవాన్, హే ప్రభోఽహం ద్రష్టుం లభై| ");
INSERT INTO santel_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","తదా యీశురువాచ, దృష్టిశక్తిం గృహాణ తవ ప్రత్యయస్త్వాం స్వస్థం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","తతస్తత్క్షణాత్ తస్య చక్షుషీ ప్రసన్నే; తస్మాత్ స ఈశ్వరం ధన్యం వదన్ తత్పశ్చాద్ యయౌ, తదాలోక్య సర్వ్వే లోకా ఈశ్వరం ప్రశంసితుమ్ ఆరేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","యదా యీశు ర్యిరీహోపురం ప్రవిశ్య తన్మధ్యేన గచ్ఛంస్తదా ");
INSERT INTO santel_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","సక్కేయనామా కరసఞ్చాయినాం ప్రధానో ధనవానేకో ");
INSERT INTO santel_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","యీశుః కీదృగితి ద్రష్టుం చేష్టితవాన్ కిన్తు ఖర్వ్వత్వాల్లోకసంఘమధ్యే తద్దర్శనమప్రాప్య ");
INSERT INTO santel_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","యేన పథా స యాస్యతి తత్పథేఽగ్రే ధావిత్వా తం ద్రష్టుమ్ ఉడుమ్బరతరుమారురోహ| ");
INSERT INTO santel_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","పశ్చాద్ యీశుస్తత్స్థానమ్ ఇత్వా ఊర్ద్ధ్వం విలోక్య తం దృష్ట్వావాదీత్, హే సక్కేయ త్వం శీఘ్రమవరోహ మయాద్య త్వద్గేహే వస్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","తతః స శీఘ్రమవరుహ్య సాహ్లాదం తం జగ్రాహ| ");
INSERT INTO santel_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","తద్ దృష్ట్వా సర్వ్వే వివదమానా వక్తుమారేభిరే, సోతిథిత్వేన దుష్టలోకగృహం గచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","కిన్తు సక్కేయో దణ్డాయమానో వక్తుమారేభే, హే ప్రభో పశ్య మమ యా సమ్పత్తిరస్తి తదర్ద్ధం దరిద్రేభ్యో దదే, అపరమ్ అన్యాయం కృత్వా కస్మాదపి యది కదాపి కిఞ్చిత్ మయా గృహీతం తర్హి తచ్చతుర్గుణం దదామి| ");
INSERT INTO santel_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","తదా యీశుస్తముక్తవాన్ అయమపి ఇబ్రాహీమః సన్తానోఽతః కారణాద్ అద్యాస్య గృహే త్రాణముపస్థితం| ");
INSERT INTO santel_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","యద్ హారితం తత్ మృగయితుం రక్షితుఞ్చ మనుష్యపుత్ర ఆగతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","అథ స యిరూశాలమః సమీప ఉపాతిష్ఠద్ ఈశ్వరరాజత్వస్యానుష్ఠానం తదైవ భవిష్యతీతి లోకైరన్వభూయత, తస్మాత్ స శ్రోతృభ్యః పునర్దృష్టాన్తకథామ్ ఉత్థాప్య కథయామాస| ");
INSERT INTO santel_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","కోపి మహాల్లోకో నిజార్థం రాజత్వపదం గృహీత్వా పునరాగన్తుం దూరదేశం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","యాత్రాకాలే నిజాన్ దశదాసాన్ ఆహూయ దశస్వర్ణముద్రా దత్త్వా మమాగమనపర్య్యన్తం వాణిజ్యం కురుతేత్యాదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","కిన్తు తస్య ప్రజాస్తమవజ్ఞాయ మనుష్యమేనమ్ అస్మాకముపరి రాజత్వం న కారయివ్యామ ఇమాం వార్త్తాం తన్నికటే ప్రేరయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","అథ స రాజత్వపదం ప్రాప్యాగతవాన్ ఏకైకో జనో బాణిజ్యేన కిం లబ్ధవాన్ ఇతి జ్ఞాతుం యేషు దాసేషు ముద్రా అర్పయత్ తాన్ ఆహూయానేతుమ్ ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","తదా ప్రథమ ఆగత్య కథితవాన్, హే ప్రభో తవ తయైకయా ముద్రయా దశముద్రా లబ్ధాః| ");
INSERT INTO santel_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","తతః స ఉవాచ త్వముత్తమో దాసః స్వల్పేన విశ్వాస్యో జాత ఇతః కారణాత్ త్వం దశనగరాణామ్ అధిపో భవ| ");
INSERT INTO santel_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ద్వితీయ ఆగత్య కథితవాన్, హే ప్రభో తవైకయా ముద్రయా పఞ్చముద్రా లబ్ధాః| ");
INSERT INTO santel_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","తతః స ఉవాచ, త్వం పఞ్చానాం నగరాణామధిపతి ర్భవ| ");
INSERT INTO santel_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","తతోన్య ఆగత్య కథయామాస, హే ప్రభో పశ్య తవ యా ముద్రా అహం వస్త్రే బద్ధ్వాస్థాపయం సేయం| ");
INSERT INTO santel_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","త్వం కృపణో యన్నాస్థాపయస్తదపి గృహ్లాసి, యన్నావపస్తదేవ చ ఛినత్సి తతోహం త్వత్తో భీతః| ");
INSERT INTO santel_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","తదా స జగాద, రే దుష్టదాస తవ వాక్యేన త్వాం దోషిణం కరిష్యామి, యదహం నాస్థాపయం తదేవ గృహ్లామి, యదహం నావపఞ్చ తదేవ ఛినద్మి, ఏతాదృశః కృపణోహమితి యది త్వం జానాసి, ");
INSERT INTO santel_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","తర్హి మమ ముద్రా బణిజాం నికటే కుతో నాస్థాపయః? తయా కృతేఽహమ్ ఆగత్య కుసీదేన సార్ద్ధం నిజముద్రా అప్రాప్స్యమ్| ");
INSERT INTO santel_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","పశ్చాత్ స సమీపస్థాన్ జనాన్ ఆజ్ఞాపయత్ అస్మాత్ ముద్రా ఆనీయ యస్య దశముద్రాః సన్తి తస్మై దత్త| ");
INSERT INTO santel_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","తే ప్రోచుః ప్రభోఽస్య దశముద్రాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","యుష్మానహం వదామి యస్యాశ్రయే వద్ధతే ఽధికం తస్మై దాయిష్యతే, కిన్తు యస్యాశ్రయే న వర్ద్ధతే తస్య యద్యదస్తి తదపి తస్మాన్ నాయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","కిన్తు మమాధిపతిత్వస్య వశత్వే స్థాతుమ్ అసమ్మన్యమానా యే మమ రిపవస్తానానీయ మమ సమక్షం సంహరత| ");
INSERT INTO santel_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ఇత్యుపదేశకథాం కథయిత్వా సోగ్రగః సన్ యిరూశాలమపురం యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","తతో బైత్ఫగీబైథనీయాగ్రామయోః సమీపే జైతునాద్రేరన్తికమ్ ఇత్వా శిష్యద్వయమ్ ఇత్యుక్త్వా ప్రేషయామాస, ");
INSERT INTO santel_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","యువామముం సమ్ముఖస్థగ్రామం ప్రవిశ్యైవ యం కోపి మానుషః కదాపి నారోహత్ తం గర్ద్దభశావకం బద్ధం ద్రక్ష్యథస్తం మోచయిత్వానయతం| ");
INSERT INTO santel_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","తత్ర కుతో మోచయథః? ఇతి చేత్ కోపి వక్ష్యతి తర్హి వక్ష్యథః ప్రభేाరత్ర ప్రయోజనమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","తదా తౌ ప్రరితౌ గత్వా తత్కథాाనుసారేణ సర్వ్వం ప్రాప్తౌ| ");
INSERT INTO santel_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","గర్దభశావకమోచనకాలే తత్వామిన ఊచుః, గర్దభశావకం కుతో మోచయథః? ");
INSERT INTO santel_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","తావూచతుః ప్రభోరత్ర ప్రయోజనమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","పశ్చాత్ తౌ తం గర్దభశావకం యీశోరన్తికమానీయ తత్పృష్ఠే నిజవసనాని పాతయిత్వా తదుపరి యీశుమారోహయామాసతుః| ");
INSERT INTO santel_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","అథ యాత్రాకాలే లోకాః పథి స్వవస్త్రాణి పాతయితుమ్ ఆరేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","అపరం జైతునాద్రేరుపత్యకామ్ ఇత్వా శిష్యసంఘః పూర్వ్వదృష్టాని మహాకర్మ్మాణి స్మృత్వా, ");
INSERT INTO santel_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","యో రాజా ప్రభో ర్నామ్నాయాతి స ధన్యః స్వర్గే కుశలం సర్వ్వోచ్చే జయధ్వని ర్భవతు, కథామేతాం కథయిత్వా సానన్దమ్ ఉచైరీశ్వరం ధన్యం వక్తుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","తదా లోకారణ్యమధ్యస్థాః కియన్తః ఫిరూశినస్తత్ శ్రుత్వా యీశుం ప్రోచుః, హే ఉపదేశక స్వశిష్యాన్ తర్జయ| ");
INSERT INTO santel_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","స ఉవాచ, యుష్మానహం వదామి యద్యమీ నీరవాస్తిష్ఠన్తి తర్హి పాషాణా ఉచైః కథాః కథయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","పశ్చాత్ తత్పురాన్తికమేత్య తదవలోక్య సాశ్రుపాతం జగాద, ");
INSERT INTO santel_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","హా హా చేత్ త్వమగ్రేఽజ్ఞాస్యథాః, తవాస్మిన్నేవ దినే వా యది స్వమఙ్గలమ్ ఉపాలప్స్యథాః, తర్హ్యుత్తమమ్ అభవిష్యత్, కిన్తు క్షణేస్మిన్ తత్తవ దృష్టేరగోచరమ్ భవతి| ");
INSERT INTO santel_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","త్వం స్వత్రాణకాలే న మనో న్యధత్థా ఇతి హేతో ర్యత్కాలే తవ రిపవస్త్వాం చతుర్దిక్షు ప్రాచీరేణ వేష్టయిత్వా రోత్స్యన్తి ");
INSERT INTO santel_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","బాలకైః సార్ద్ధం భూమిసాత్ కరిష్యన్తి చ త్వన్మధ్యే పాషాణైకోపి పాషాణోపరి న స్థాస్యతి చ, కాల ఈదృశ ఉపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","అథ మధ్యేమన్దిరం ప్రవిశ్య తత్రత్యాన్ క్రయివిక్రయిణో బహిష్కుర్వ్వన్ ");
INSERT INTO santel_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","అవదత్ మద్గృహం ప్రార్థనాగృహమితి లిపిరాస్తే కిన్తు యూయం తదేవ చైరాణాం గహ్వరం కురుథ| ");
INSERT INTO santel_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","పశ్చాత్ స ప్రత్యహం మధ్యేమన్దిరమ్ ఉపదిదేశ; తతః ప్రధానయాజకా అధ్యాపకాః ప్రాచీనాశ్చ తం నాశయితుం చిచేష్టిరే; ");
INSERT INTO santel_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","కిన్తు తదుపదేశే సర్వ్వే లోకా నివిష్టచిత్తాః స్థితాస్తస్మాత్ తే తత్కర్త్తుం నావకాశం ప్రాపుః| ");
INSERT INTO santel_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","అథైకదా యీశు ర్మనిదరే సుసంవాదం ప్రచారయన్ లోకానుపదిశతి, ఏతర్హి ప్రధానయాజకా అధ్యాపకాః ప్రాఞ్చశ్చ తన్నికటమాగత్య పప్రచ్ఛుః ");
INSERT INTO santel_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","కయాజ్ఞయా త్వం కర్మ్మాణ్యేతాని కరోషి? కో వా త్వామాజ్ఞాపయత్? తదస్మాన్ వద| ");
INSERT INTO santel_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","స ప్రత్యువాచ, తర్హి యుష్మానపి కథామేకాం పృచ్ఛామి తస్యోత్తరం వదత| ");
INSERT INTO santel_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","యోహనో మజ్జనమ్ ఈశ్వరస్య మానుషాణాం వాజ్ఞాతో జాతం? ");
INSERT INTO santel_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","తతస్తే మిథో వివిచ్య జగదుః, యదీశ్వరస్య వదామస్తర్హి తం కుతో న ప్రత్యైత స ఇతి వక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","యది మనుష్యస్యేతి వదామస్తర్హి సర్వ్వే లోకా అస్మాన్ పాషాణై ర్హనిష్యన్తి యతో యోహన్ భవిష్యద్వాదీతి సర్వ్వే దృఢం జానన్తి| ");
INSERT INTO santel_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","అతఏవ తే ప్రత్యూచుః కస్యాజ్ఞయా జాతమ్ ఇతి వక్తుం న శక్నుమః| ");
INSERT INTO santel_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","తదా యీశురవదత్ తర్హి కయాజ్ఞయా కర్మ్మాణ్యేతాతి కరోమీతి చ యుష్మాన్ న వక్ష్యామి| ");
INSERT INTO santel_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","అథ లోకానాం సాక్షాత్ స ఇమాం దృష్టాన్తకథాం వక్తుమారేభే, కశ్చిద్ ద్రాక్షాక్షేత్రం కృత్వా తత్ క్షేత్రం కృషీవలానాం హస్తేషు సమర్ప్య బహుకాలార్థం దూరదేశం జగామ| ");
INSERT INTO santel_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","అథ ఫలకాలే ఫలాని గ్రహీతు కృషీవలానాం సమీపే దాసం ప్రాహిణోత్ కిన్తు కృషీవలాస్తం ప్రహృత్య రిక్తహస్తం విససర్జుః| ");
INSERT INTO santel_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","తతః సోధిపతిః పునరన్యం దాసం ప్రేషయామాస, తే తమపి ప్రహృత్య కువ్యవహృత్య రిక్తహస్తం విససృజుః| ");
INSERT INTO santel_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","తతః స తృతీయవారమ్ అన్యం ప్రాహిణోత్ తే తమపి క్షతాఙ్గం కృత్వా బహి ర్నిచిక్షిపుః| ");
INSERT INTO santel_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","తదా క్షేత్రపతి ర్విచారయామాస, మమేదానీం కిం కర్త్తవ్యం? మమ ప్రియే పుత్రే ప్రహితే తే తమవశ్యం దృష్ట్వా సమాదరిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","కిన్తు కృషీవలాస్తం నిరీక్ష్య పరస్పరం వివిచ్య ప్రోచుః, అయముత్తరాధికారీ ఆగచ్ఛతైనం హన్మస్తతోధికారోస్మాకం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","తతస్తే తం క్షేత్రాద్ బహి ర్నిపాత్య జఘ్నుస్తస్మాత్ స క్షేత్రపతిస్తాన్ ప్రతి కిం కరిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","స ఆగత్య తాన్ కృషీవలాన్ హత్వా పరేషాం హస్తేషు తత్క్షేత్రం సమర్పయిష్యతి; ఇతి కథాం శ్రుత్వా తే ఽవదన్ ఏతాదృశీ ఘటనా న భవతు| ");
INSERT INTO santel_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","కిన్తు యీశుస్తానవలోక్య జగాద, తర్హి, స్థపతయః కరిష్యన్తి గ్రావాణం యన్తు తుచ్ఛకం| ప్రధానప్రస్తరః కోణే స ఏవ హి భవిష్యతి| ఏతస్య శాస్త్రీయవచనస్య కిం తాత్పర్య్యం? ");
INSERT INTO santel_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","అపరం తత్పాషాణోపరి యః పతిష్యతి స భంక్ష్యతే కిన్తు యస్యోపరి స పాషాణః పతిష్యతి స తేన ధూలివచ్ చూర్ణీభవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","సోస్మాకం విరుద్ధం దృష్టాన్తమిమం కథితవాన్ ఇతి జ్ఞాత్వా ప్రధానయాజకా అధ్యాపకాశ్చ తదైవ తం ధర్తుం వవాఞ్ఛుః కిన్తు లోకేభ్యో బిభ్యుః| ");
INSERT INTO santel_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","అతఏవ తం ప్రతి సతర్కాః సన్తః కథం తద్వాక్యదోషం ధృత్వా తం దేశాధిపస్య సాధువేశధారిణశ్చరాన్ తస్య సమీపే ప్రేషయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","తదా తే తం పప్రచ్ఛుః, హే ఉపదేశక భవాన్ యథార్థం కథయన్ ఉపదిశతి, కమప్యనపేక్ష్య సత్యత్వేనైశ్వరం మార్గముపదిశతి, వయమేతజ్జానీమః| ");
INSERT INTO santel_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","కైసరరాజాయ కరోస్మాభి ర్దేయో న వా? ");
INSERT INTO santel_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","స తేషాం వఞ్చనం జ్ఞాత్వావదత్ కుతో మాం పరీక్షధ్వే? మాం ముద్రామేకం దర్శయత| ");
INSERT INTO santel_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ఇహ లిఖితా మూర్తిరియం నామ చ కస్య? తేఽవదన్ కైసరస్య| ");
INSERT INTO santel_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","తదా స ఉవాచ, తర్హి కైసరస్య ద్రవ్యం కైసరాయ దత్త; ఈశ్వరస్య తు ద్రవ్యమీశ్వరాయ దత్త| ");
INSERT INTO santel_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","తస్మాల్లోకానాం సాక్షాత్ తత్కథాయాః కమపి దోషం ధర్తుమప్రాప్య తే తస్యోత్తరాద్ ఆశ్చర్య్యం మన్యమానా మౌనినస్తస్థుః| ");
INSERT INTO santel_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","అపరఞ్చ శ్మశానాదుత్థానానఙ్గీకారిణాం సిదూకినాం కియన్తో జనా ఆగత్య తం పప్రచ్ఛుః, ");
INSERT INTO santel_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","హే ఉపదేశక శాస్త్రే మూసా అస్మాన్ ప్రతీతి లిలేఖ యస్య భ్రాతా భార్య్యాయాం సత్యాం నిఃసన్తానో మ్రియతే స తజ్జాయాం వివహ్య తద్వంశమ్ ఉత్పాదయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","తథాచ కేచిత్ సప్త భ్రాతర ఆసన్ తేషాం జ్యేష్ఠో భ్రాతా వివహ్య నిరపత్యః ప్రాణాన్ జహౌ| ");
INSERT INTO santel_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","అథ ద్వితీయస్తస్య జాయాం వివహ్య నిరపత్యః సన్ మమార| తృతీయశ్చ తామేవ వ్యువాహ; ");
INSERT INTO santel_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ఇత్థం సప్త భ్రాతరస్తామేవ వివహ్య నిరపత్యాః సన్తో మమ్రుః| ");
INSERT INTO santel_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","శేషే సా స్త్రీ చ మమార| ");
INSERT INTO santel_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","అతఏవ శ్మశానాదుత్థానకాలే తేషాం సప్తజనానాం కస్య సా భార్య్యా భవిష్యతి? యతః సా తేషాం సప్తానామేవ భార్య్యాసీత్| ");
INSERT INTO santel_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","తదా యీశుః ప్రత్యువాచ, ఏతస్య జగతో లోకా వివహన్తి వాగ్దత్తాశ్చ భవన్తి ");
INSERT INTO santel_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","కిన్తు యే తజ్జగత్ప్రాప్తియోగ్యత్వేన గణితాం భవిష్యన్తి శ్మశానాచ్చోత్థాస్యన్తి తే న వివహన్తి వాగ్దత్తాశ్చ న భవన్తి, ");
INSERT INTO santel_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","తే పున ర్న మ్రియన్తే కిన్తు శ్మశానాదుత్థాపితాః సన్త ఈశ్వరస్య సన్తానాః స్వర్గీయదూతానాం సదృశాశ్చ భవన్తి| ");
INSERT INTO santel_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","అధికన్తు మూసాః స్తమ్బోపాఖ్యానే పరమేశ్వర ఈబ్రాహీమ ఈశ్వర ఇస్హాక ఈశ్వరో యాకూబశ్చేశ్వర ఇత్యుక్త్వా మృతానాం శ్మశానాద్ ఉత్థానస్య ప్రమాణం లిలేఖ| ");
INSERT INTO santel_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","అతఏవ య ఈశ్వరః స మృతానాం ప్రభు ర్న కిన్తు జీవతామేవ ప్రభుః, తన్నికటే సర్వ్వే జీవన్తః సన్తి| ");
INSERT INTO santel_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ఇతి శ్రుత్వా కియన్తోధ్యాపకా ఊచుః, హే ఉపదేశక భవాన్ భద్రం ప్రత్యుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ఇతః పరం తం కిమపి ప్రష్టం తేషాం ప్రగల్భతా నాభూత్| ");
INSERT INTO santel_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","పశ్చాత్ స తాన్ ఉవాచ, యః ఖ్రీష్టః స దాయూదః సన్తాన ఏతాం కథాం లోకాః కథం కథయన్తి? ");
INSERT INTO santel_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","యతః మమ ప్రభుమిదం వాక్యమవదత్ పరమేశ్వరః| తవ శత్రూనహం యావత్ పాదపీఠం కరోమి న| తావత్ కాలం మదీయే త్వం దక్షపార్శ్వ ఉపావిశ| ");
INSERT INTO santel_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ఇతి కథాం దాయూద్ స్వయం గీతగ్రన్థేఽవదత్| ");
INSERT INTO santel_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","అతఏవ యది దాయూద్ తం ప్రభుం వదతి, తర్హి స కథం తస్య సన్తానో భవతి? ");
INSERT INTO santel_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","పశ్చాద్ యీశుః సర్వ్వజనానాం కర్ణగోచరే శిష్యానువాచ, ");
INSERT INTO santel_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","యేఽధ్యాపకా దీర్ఘపరిచ్ఛదం పరిధాయ భ్రమన్తి, హట్టాపణయో ర్నమస్కారే భజనగేహస్య ప్రోచ్చాసనే భోజనగృహస్య ప్రధానస్థానే చ ప్రీయన్తే ");
INSERT INTO santel_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","విధవానాం సర్వ్వస్వం గ్రసిత్వా ఛలేన దీర్ఘకాలం ప్రార్థయన్తే చ తేషు సావధానా భవత, తేషాముగ్రదణ్డో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","అథ ధనిలోకా భాణ్డాగారే ధనం నిక్షిపన్తి స తదేవ పశ్యతి, ");
INSERT INTO santel_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ఏతర్హి కాచిద్దీనా విధవా పణద్వయం నిక్షిపతి తద్ దదర్శ| ");
INSERT INTO santel_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","తతో యీశురువాచ యుష్మానహం యథార్థం వదామి, దరిద్రేయం విధవా సర్వ్వేభ్యోధికం న్యక్షేప్సీత్, ");
INSERT INTO santel_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","యతోన్యే స్వప్రాజ్యధనేభ్య ఈశ్వరాయ కిఞ్చిత్ న్యక్షేప్సుః, కిన్తు దరిద్రేయం విధవా దినయాపనార్థం స్వస్య యత్ కిఞ్చిత్ స్థితం తత్ సర్వ్వం న్యక్షేప్సీత్| ");
INSERT INTO santel_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","అపరఞ్చ ఉత్తమప్రస్తరైరుత్సృష్టవ్యైశ్చ మన్దిరం సుశోభతేతరాం కైశ్చిదిత్యుక్తే స ప్రత్యువాచ ");
INSERT INTO santel_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","యూయం యదిదం నిచయనం పశ్యథ, అస్య పాషాణైకోప్యన్యపాషాణోపరి న స్థాస్యతి, సర్వ్వే భూసాద్భవిష్యన్తి కాలోయమాయాతి| ");
INSERT INTO santel_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","తదా తే పప్రచ్ఛుః, హే గురో ఘటనేదృశీ కదా భవిష్యతి? ఘటనాయా ఏతస్యసశ్చిహ్నం వా కిం భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","తదా స జగాద, సావధానా భవత యథా యుష్మాకం భ్రమం కోపి న జనయతి, ఖీష్టోహమిత్యుక్త్వా మమ నామ్రా బహవ ఉపస్థాస్యన్తి స కాలః ప్రాయేణోపస్థితః, తేషాం పశ్చాన్మా గచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","యుద్ధస్యోపప్లవస్య చ వార్త్తాం శ్రుత్వా మా శఙ్కధ్వం, యతః ప్రథమమ్ ఏతా ఘటనా అవశ్యం భవిష్యన్తి కిన్తు నాపాతే యుగాన్తో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","అపరఞ్చ కథయామాస, తదా దేశస్య విపక్షత్వేన దేశో రాజ్యస్య విపక్షత్వేన రాజ్యమ్ ఉత్థాస్యతి, ");
INSERT INTO santel_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","నానాస్థానేషు మహాభూకమ్పో దుర్భిక్షం మారీ చ భవిష్యన్తి, తథా వ్యోమమణ్డలస్య భయఙ్కరదర్శనాన్యశ్చర్య్యలక్షణాని చ ప్రకాశయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","కిన్తు సర్వ్వాసామేతాసాం ఘటనానాం పూర్వ్వం లోకా యుష్మాన్ ధృత్వా తాడయిష్యన్తి, భజనాలయే కారాయాఞ్చ సమర్పయిష్యన్తి మమ నామకారణాద్ యుష్మాన్ భూపానాం శాసకానాఞ్చ సమ్ముఖం నేష్యన్తి చ| ");
INSERT INTO santel_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","సాక్ష్యార్థమ్ ఏతాని యుష్మాన్ ప్రతి ఘటిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","తదా కిముత్తరం వక్తవ్యమ్ ఏతత్ న చిన్తయిష్యామ ఇతి మనఃసు నిశ్చితనుత| ");
INSERT INTO santel_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","విపక్షా యస్మాత్ కిమప్యుత్తరమ్ ఆపత్తిఞ్చ కర్త్తుం న శక్ష్యన్తి తాదృశం వాక్పటుత్వం జ్ఞానఞ్చ యుష్మభ్యం దాస్యామి| ");
INSERT INTO santel_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","కిఞ్చ యూయం పిత్రా మాత్రా భ్రాత్రా బన్ధునా జ్ఞాత్యా కుటుమ్బేన చ పరకరేషు సమర్పయిష్యధ్వే; తతస్తే యుష్మాకం కఞ్చన కఞ్చన ఘాతయిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","మమ నామ్నః కారణాత్ సర్వ్వై ర్మనుష్యై ర్యూయమ్ ఋతీయిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","కిన్తు యుష్మాకం శిరఃకేశైకోపి న వినంక్ష్యతి, ");
INSERT INTO santel_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","తస్మాదేవ ధైర్య్యమవలమ్బ్య స్వస్వప్రాణాన్ రక్షత| ");
INSERT INTO santel_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","అపరఞ్చ యిరూశాలమ్పురం సైన్యవేష్టితం విలోక్య తస్యోచ్ఛిన్నతాయాః సమయః సమీప ఇత్యవగమిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","తదా యిహూదాదేశస్థా లోకాః పర్వ్వతం పలాయన్తాం, యే చ నగరే తిష్ఠన్తి తే దేశాన్తరం పలాయన్తా, యే చ గ్రామే తిష్ఠన్తి తే నగరం న ప్రవిశన్తు, ");
INSERT INTO santel_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","యతస్తదా సముచితదణ్డనాయ ధర్మ్మపుస్తకే యాని సర్వ్వాణి లిఖితాని తాని సఫలాని భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","కిన్తు యా యాస్తదా గర్భవత్యః స్తన్యదావ్యశ్చ తామాం దుర్గతి ర్భవిష్యతి, యత ఏతాల్లోకాన్ ప్రతి కోపో దేశే చ విషమదుర్గతి ర్ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","వస్తుతస్తు తే ఖఙ్గధారపరివ్వఙ్గం లప్స్యన్తే బద్ధాః సన్తః సర్వ్వదేశేషు నాయిష్యన్తే చ కిఞ్చాన్యదేశీయానాం సమయోపస్థితిపర్య్యన్తం యిరూశాలమ్పురం తైః పదతలై ర్దలయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","సూర్య్యచన్ద్రనక్షత్రేషు లక్షణాది భవిష్యన్తి, భువి సర్వ్వదేశీయానాం దుఃఖం చిన్తా చ సిన్ధౌ వీచీనాం తర్జనం గర్జనఞ్చ భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","భూభౌ భావిఘటనాం చిన్తయిత్వా మనుజా భియామృతకల్పా భవిష్యన్తి, యతో వ్యోమమణ్డలే తేజస్వినో దోలాయమానా భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","తదా పరాక్రమేణా మహాతేజసా చ మేఘారూఢం మనుష్యపుత్రమ్ ఆయాన్తం ద్రక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","కిన్త్వేతాసాం ఘటనానామారమ్భే సతి యూయం మస్తకాన్యుత్తోల్య ఊర్దధ్వం ద్రక్ష్యథ, యతో యుష్మాకం ముక్తేః కాలః సవిధో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","తతస్తేనైతదృష్టాన్తకథా కథితా, పశ్యత ఉడుమ్బరాదివృక్షాణాం ");
INSERT INTO santel_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","నవీనపత్రాణి జాతానీతి దృష్ట్వా నిదావకాల ఉపస్థిత ఇతి యథా యూయం జ్ఞాతుం శక్నుథ, ");
INSERT INTO santel_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","తథా సర్వ్వాసామాసాం ఘటనానామ్ ఆరమ్భే దృష్టే సతీశ్వరస్య రాజత్వం నికటమ్ ఇత్యపి జ్ఞాస్యథ| ");
INSERT INTO santel_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","యుష్మానహం యథార్థం వదామి, విద్యమానలోకానామేషాం గమనాత్ పూర్వ్వమ్ ఏతాని ఘటిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","నభోభువోర్లోపో భవిష్యతి మమ వాక్ తు కదాపి లుప్తా న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","అతఏవ విషమాశనేన పానేన చ సాంమారికచిన్తాభిశ్చ యుష్మాకం చిత్తేషు మత్తేషు తద్దినమ్ అకస్మాద్ యుష్మాన్ ప్రతి యథా నోపతిష్ఠతి తదర్థం స్వేషు సావధానాస్తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","పృథివీస్థసర్వ్వలోకాన్ ప్రతి తద్దినమ్ ఉన్మాథ ఇవ ఉపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","యథా యూయమ్ ఏతద్భావిఘటనా ఉత్తర్త్తుం మనుజసుతస్య సమ్ముఖే సంస్థాతుఞ్చ యోగ్యా భవథ కారణాదస్మాత్ సావధానాః సన్తో నిరన్తరం ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","అపరఞ్చ స దివా మన్దిర ఉపదిశ్య రాచై జైతునాద్రిం గత్వాతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","తతః ప్రత్యూషే లాకాస్తత్కథాం శ్రోతుం మన్దిరే తదన్తికమ్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","అపరఞ్చ కిణ్వశూన్యపూపోత్సవస్య కాల ఉపస్థితే ");
INSERT INTO santel_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ప్రధానయాజకా అధ్యాయకాశ్చ యథా తం హన్తుం శక్నువన్తి తథోపాయామ్ అచేష్టన్త కిన్తు లోకేభ్యో బిభ్యుః| ");
INSERT INTO santel_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ఏతస్తిన్ సమయే ద్వాదశశిష్యేషు గణిత ఈష్కరియోతీయరూఢిమాన్ యో యిహూదాస్తస్యాన్తఃకరణం శైతానాశ్రితత్వాత్ ");
INSERT INTO santel_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","స గత్వా యథా యీశుం తేషాం కరేషు సమర్పయితుం శక్నోతి తథా మన్త్రణాం ప్రధానయాజకైః సేనాపతిభిశ్చ సహ చకార| ");
INSERT INTO santel_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","తేన తే తుష్టాస్తస్మై ముద్రాం దాతుం పణం చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","తతః సోఙ్గీకృత్య యథా లోకానామగోచరే తం పరకరేషు సమర్పయితుం శక్నోతి తథావకాశం చేష్టితుమారేభే| ");
INSERT INTO santel_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","అథ కిణ్వశూన్యపూపోత్మవదినే, అర్థాత్ యస్మిన్ దినే నిస్తారోత్సవస్య మేషో హన్తవ్యస్తస్మిన్ దినే ");
INSERT INTO santel_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","యీశుః పితరం యోహనఞ్చాహూయ జగాద, యువాం గత్వాస్మాకం భోజనార్థం నిస్తారోత్సవస్య ద్రవ్యాణ్యాసాదయతం| ");
INSERT INTO santel_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","తదా తౌ పప్రచ్ఛతుః కుచాసాదయావో భవతః కేచ్ఛా? ");
INSERT INTO santel_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","తదా సోవాదీత్, నగరే ప్రవిష్టే కశ్చిజ్జలకుమ్భమాదాయ యువాం సాక్షాత్ కరిష్యతి స యన్నివేశనం ప్రవిశతి యువామపి తన్నివేశనం తత్పశ్చాదిత్వా నివేశనపతిమ్ ఇతి వాక్యం వదతం, ");
INSERT INTO santel_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","యత్రాహం నిస్తారోత్సవస్య భోజ్యం శిష్యైః సార్ద్ధం భోక్తుం శక్నోమి సాతిథిశాలాा కుత్ర? కథామిమాం ప్రభుస్త్వాం పృచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","తతః స జనో ద్వితీయప్రకోష్ఠీయమ్ ఏకం శస్తం కోష్ఠం దర్శయిష్యతి తత్ర భోజ్యమాసాదయతం| ");
INSERT INTO santel_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","తతస్తౌ గత్వా తద్వాక్యానుసారేణ సర్వ్వం దృష్ద్వా తత్ర నిస్తారోత్సవీయం భోజ్యమాసాదయామాసతుః| ");
INSERT INTO santel_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","అథ కాల ఉపస్థితే యీశు ర్ద్వాదశభిః ప్రేరితైః సహ భోక్తుముపవిశ్య కథితవాన్ ");
INSERT INTO santel_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","మమ దుఃఖభోగాత్ పూర్వ్వం యుభాభిః సహ నిస్తారోత్సవస్యైతస్య భోజ్యం భోక్తుం మయాతివాఞ్ఛా కృతా| ");
INSERT INTO santel_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","యుష్మాన్ వదామి, యావత్కాలమ్ ఈశ్వరరాజ్యే భోజనం న కరిష్యే తావత్కాలమ్ ఇదం న భోక్ష్యే| ");
INSERT INTO santel_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","తదా స పానపాత్రమాదాయ ఈశ్వరస్య గుణాన్ కీర్త్తయిత్వా తేభ్యో దత్వావదత్, ఇదం గృహ్లీత యూయం విభజ్య పివత| ");
INSERT INTO santel_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","యుష్మాన్ వదామి యావత్కాలమ్ ఈశ్వరరాజత్వస్య సంస్థాపనం న భవతి తావద్ ద్రాక్షాఫలరసం న పాస్యామి| ");
INSERT INTO santel_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","తతః పూపం గృహీత్వా ఈశ్వరగుణాన్ కీర్త్తయిత్వా భఙ్క్తా తేభ్యో దత్వావదత్, యుష్మదర్థం సమర్పితం యన్మమ వపుస్తదిదం, ఏతత్ కర్మ్మ మమ స్మరణార్థం కురుధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","అథ భోజనాన్తే తాదృశం పాత్రం గృహీత్వావదత్, యుష్మత్కృతే పాతితం యన్మమ రక్తం తేన నిర్ణీతనవనియమరూపం పానపాత్రమిదం| ");
INSERT INTO santel_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","పశ్యత యో మాం పరకరేషు సమర్పయిష్యతి స మయా సహ భోజనాసన ఉపవిశతి| ");
INSERT INTO santel_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","యథా నిరూపితమాస్తే తదనుసారేణా మనుష్యపుुత్రస్య గతి ర్భవిష్యతి కిన్తు యస్తం పరకరేషు సమర్పయిష్యతి తస్య సన్తాపో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","తదా తేషాం కో జన ఏతత్ కర్మ్మ కరిష్యతి తత్ తే పరస్పరం ప్రష్టుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","అపరం తేషాం కో జనః శ్రేష్ఠత్వేన గణయిష్యతే, అత్రార్థే తేషాం వివాదోభవత్| ");
INSERT INTO santel_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","అస్మాత్ కారణాత్ సోవదత్, అన్యదేశీయానాం రాజానః ప్రజానాముపరి ప్రభుత్వం కుర్వ్వన్తి దారుణశాసనం కృత్వాపి తే భూపతిత్వేన విఖ్యాతా భవన్తి చ| ");
INSERT INTO santel_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","కిన్తు యుష్మాకం తథా న భవిష్యతి, యో యుష్మాకం శ్రేష్ఠో భవిష్యతి స కనిష్ఠవద్ భవతు, యశ్చ ముఖ్యో భవిష్యతి స సేవకవద్భవతు| ");
INSERT INTO santel_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","భోజనోపవిష్టపరిచారకయోః కః శ్రేష్ఠః? యో భోజనాయోపవిశతి స కిం శ్రేష్ఠో న భవతి? కిన్తు యుష్మాకం మధ్యేఽహం పరిచారకఇవాస్మి| ");
INSERT INTO santel_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","అపరఞ్చ యుయం మమ పరీక్షాకాలే ప్రథమమారభ్య మయా సహ స్థితా ");
INSERT INTO santel_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ఏతత్కారణాత్ పిత్రా యథా మదర్థం రాజ్యమేకం నిరూపితం తథాహమపి యుష్మదర్థం రాజ్యం నిరూపయామి| ");
INSERT INTO santel_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","తస్మాన్ మమ రాజ్యే భోజనాసనే చ భోజనపానే కరిష్యధ్వే సింహాసనేషూపవిశ్య చేస్రాయేలీయానాం ద్వాదశవంశానాం విచారం కరిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","అపరం ప్రభురువాచ, హే శిమోన్ పశ్య తితఉనా ధాన్యానీవ యుష్మాన్ శైతాన్ చాలయితుమ్ ఐచ్ఛత్, ");
INSERT INTO santel_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","కిన్తు తవ విశ్వాసస్య లోపో యథా న భవతి ఏతత్ త్వదర్థం ప్రార్థితం మయా, త్వన్మనసి పరివర్త్తితే చ భ్రాతృణాం మనాంసి స్థిరీకురు| ");
INSERT INTO santel_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","తదా సోవదత్, హే ప్రభోహం త్వయా సార్ద్ధం కారాం మృతిఞ్చ యాతుం మజ్జితోస్మి| ");
INSERT INTO santel_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","తతః స ఉవాచ, హే పితర త్వాం వదామి, అద్య కుక్కుటరవాత్ పూర్వ్వం త్వం మత్పరిచయం వారత్రయమ్ అపహ్వోష్యసే| ");
INSERT INTO santel_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","అపరం స పప్రచ్ఛ, యదా ముద్రాసమ్పుటం ఖాద్యపాత్రం పాదుకాఞ్చ వినా యుష్మాన్ ప్రాహిణవం తదా యుష్మాకం కస్యాపి న్యూనతాసీత్? తే ప్రోచుః కస్యాపి న| ");
INSERT INTO santel_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","తదా సోవదత్ కిన్త్విదానీం ముద్రాసమ్పుటం ఖాద్యపాత్రం వా యస్యాస్తి తేన తద్గ్రహీతవ్యం, యస్య చ కృపాణోे నాస్తి తేన స్వవస్త్రం విక్రీయ స క్రేతవ్యః| ");
INSERT INTO santel_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","యతో యుష్మానహం వదామి, అపరాధిజనైః సార్ద్ధం గణితః స భవిష్యతి| ఇదం యచ్ఛాస్త్రీయం వచనం లిఖితమస్తి తన్మయి ఫలిష్యతి యతో మమ సమ్బన్ధీయం సర్వ్వం సేత్స్యతి| ");
INSERT INTO santel_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","తదా తే ప్రోచుః ప్రభో పశ్య ఇమౌ కృపాణౌ| తతః సోవదద్ ఏతౌ యథేష్టౌ| ");
INSERT INTO santel_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","అథ స తస్మాద్వహి ర్గత్వా స్వాచారానుసారేణ జైతుననామాద్రిం జగామ శిష్యాశ్చ తత్పశ్చాద్ యయుః| ");
INSERT INTO santel_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","తత్రోపస్థాయ స తానువాచ, యథా పరీక్షాయాం న పతథ తదర్థం ప్రార్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","పశ్చాత్ స తస్మాద్ ఏకశరక్షేపాద్ బహి ర్గత్వా జానునీ పాతయిత్వా ఏతత్ ప్రార్థయాఞ్చక్రే, ");
INSERT INTO santel_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","హే పిత ర్యది భవాన్ సమ్మన్యతే తర్హి కంసమేనం మమాన్తికాద్ దూరయ కిన్తు మదిచ్ఛానురూపం న త్వదిచ్ఛానురూపం భవతు| ");
INSERT INTO santel_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","తదా తస్మై శక్తిం దాతుం స్వర్గీయదూతో దర్శనం దదౌ| ");
INSERT INTO santel_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","పశ్చాత్ సోత్యన్తం యాతనయా వ్యాకులో భూత్వా పునర్దృఢం ప్రార్థయాఞ్చక్రే, తస్మాద్ బృహచ్ఛోణితబిన్దవ ఇవ తస్య స్వేదబిన్దవః పృథివ్యాం పతితుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","అథ ప్రార్థనాత ఉత్థాయ శిష్యాణాం సమీపమేత్య తాన్ మనోదుఃఖినో నిద్రితాన్ దృష్ట్వావదత్ ");
INSERT INTO santel_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","కుతో నిద్రాథ? పరీక్షాయామ్ అపతనార్థం ప్రర్థయధ్వం| ");
INSERT INTO santel_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ఏతత్కథాయాః కథనకాలే ద్వాదశశిష్యాణాం మధ్యే గణితో యిహూదానామా జనతాసహితస్తేషామ్ అగ్రే చలిత్వా యీశోశ్చుమ్బనార్థం తదన్తికమ్ ఆయయౌ| ");
INSERT INTO santel_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","తదా యీశురువాచ, హే యిహూదా కిం చుమ్బనేన మనుష్యపుత్రం పరకరేషు సమర్పయసి? ");
INSERT INTO santel_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","తదా యద్యద్ ఘటిష్యతే తదనుమాయ సఙ్గిభిరుక్తం, హే ప్రభో వయం కి ఖఙ్గేన ఘాతయిష్యామః? ");
INSERT INTO santel_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","తత ఏకః కరవాలేనాహత్య ప్రధానయాజకస్య దాసస్య దక్షిణం కర్ణం చిచ్ఛేద| ");
INSERT INTO santel_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","అధూనా నివర్త్తస్వ ఇత్యుక్త్వా యీశుస్తస్య శ్రుతిం స్పృష్ట్వా స్వస్యం చకార| ");
INSERT INTO santel_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","పశ్చాద్ యీశుః సమీపస్థాన్ ప్రధానయాజకాన్ మన్దిరస్య సేనాపతీన్ ప్రాచీనాంశ్చ జగాద, యూయం కృపాణాన్ యష్టీంశ్చ గృహీత్వా మాం కిం చోరం ధర్త్తుమాయాతాః? ");
INSERT INTO santel_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","యదాహం యుష్మాభిః సహ ప్రతిదినం మన్దిరేఽతిష్ఠం తదా మాం ధర్త్తం న ప్రవృత్తాః, కిన్త్విదానీం యుష్మాకం సమయోన్ధకారస్య చాధిపత్యమస్తి| ");
INSERT INTO santel_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","అథ తే తం ధృత్వా మహాయాజకస్య నివేశనం నిన్యుః| తతః పితరో దూరే దూరే పశ్చాదిత్వా ");
INSERT INTO santel_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","బృహత్కోష్ఠస్య మధ్యే యత్రాగ్నిం జ్వాలయిత్వా లోకాః సమేత్యోపవిష్టాస్తత్ర తైః సార్ద్ధమ్ ఉపవివేశ| ");
INSERT INTO santel_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","అథ వహ్నిసన్నిధౌ సముపవేశకాలే కాచిద్దాసీ మనో నివిశ్య తం నిరీక్ష్యావదత్ పుమానయం తస్య సఙ్గేఽస్థాత్| ");
INSERT INTO santel_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","కిన్తు స తద్ అపహ్నుత్యావాదీత్ హే నారి తమహం న పరిచినోమి| ");
INSERT INTO santel_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","క్షణాన్తరేఽన్యజనస్తం దృష్ట్వాబ్రవీత్ త్వమపి తేషాం నికరస్యైకజనోసి| పితరః ప్రత్యువాచ హే నర నాహమస్మి| ");
INSERT INTO santel_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","తతః సార్ద్ధదణ్డద్వయాత్ పరం పునరన్యో జనో నిశ్చిత్య బభాషే, ఏష తస్య సఙ్గీతి సత్యం యతోయం గాలీలీయో లోకః| ");
INSERT INTO santel_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","తదా పితర ఉవాచ హే నర త్వం యద్ వదమి తదహం బోద్ధుం న శక్నోమి, ఇతి వాక్యే కథితమాత్రే కుక్కుటో రురావ| ");
INSERT INTO santel_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","తదా ప్రభుణా వ్యాధుట్య పితరే నిరీక్షితే కృకవాకురవాత్ పూర్వ్వం మాం త్రిరపహ్నోష్యసే ఇతి పూర్వ్వోక్తం తస్య వాక్యం పితరః స్మృత్వా ");
INSERT INTO santel_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","బహిర్గత్వా మహాఖేదేన చక్రన్ద| ");
INSERT INTO santel_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","తదా యై ర్యీశుర్ధృతస్తే తముపహస్య ప్రహర్త్తుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","వస్త్రేణ తస్య దృశౌ బద్ధ్వా కపోలే చపేటాఘాతం కృత్వా పప్రచ్ఛుః, కస్తే కపోలే చపేటాఘాతం కృతవాన? గణయిత్వా తద్ వద| ");
INSERT INTO santel_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","తదన్యత్ తద్విరుద్ధం బహునిన్దావాక్యం వక్తుమారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","అథ ప్రభాతే సతి లోకప్రాఞ్చః ప్రధానయాజకా అధ్యాపకాశ్చ సభాం కృత్వా మధ్యేసభం యీశుమానీయ పప్రచ్ఛుః, త్వమ్ అభిషికతోసి న వాస్మాన్ వద| ");
INSERT INTO santel_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","స ప్రత్యువాచ, మయా తస్మిన్నుక్తేఽపి యూయం న విశ్వసిష్యథ| ");
INSERT INTO santel_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","కస్మింశ్చిద్వాక్యే యుష్మాన్ పృష్టేఽపి మాం న తదుత్తరం వక్ష్యథ న మాం త్యక్ష్యథ చ| ");
INSERT INTO santel_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","కిన్త్వితః పరం మనుజసుతః సర్వ్వశక్తిమత ఈశ్వరస్య దక్షిణే పార్శ్వే సముపవేక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","తతస్తే పప్రచ్ఛుః, ర్తిహ త్వమీశ్వరస్య పుత్రః? స కథయామాస, యూయం యథార్థం వదథ స ఏవాహం| ");
INSERT INTO santel_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","తదా తే సర్వ్వే కథయామాసుః, ర్తిహ సాక్ష్యేఽన్సస్మిన్ అస్మాకం కిం ప్రయోజనం? అస్య స్వముఖాదేవ సాక్ష్యం ప్రాప్తమ్| ");
INSERT INTO santel_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","తతః సభాస్థాః సర్వ్వలోకా ఉత్థాయ తం పీలాతసమ్ముఖం నీత్వాప్రోద్య వక్తుమారేభిరే, ");
INSERT INTO santel_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","స్వమభిషిక్తం రాజానం వదన్తం కైమరరాజాయ కరదానం నిషేధన్తం రాజ్యవిపర్య్యయం కుర్త్తుం ప్రవర్త్తమానమ్ ఏన ప్రాప్తా వయం| ");
INSERT INTO santel_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","తదా పీలాతస్తం పృష్టవాన్ త్వం కిం యిహూదీయానాం రాజా? స ప్రత్యువాచ త్వం సత్యముక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","తదా పీలాతః ప్రధానయాజకాదిలోకాన్ జగాద్, అహమేతస్య కమప్యపరాధం నాప్తవాన్| ");
INSERT INTO santel_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","తతస్తే పునః సాహమినో భూత్వావదన్, ఏష గాలీల ఏతత్స్థానపర్య్యన్తే సర్వ్వస్మిన్ యిహూదాదేశే సర్వ్వాల్లోకానుపదిశ్య కుప్రవృత్తిం గ్రాహీతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","తదా పీలాతో గాలీలప్రదేశస్య నామ శ్రుత్వా పప్రచ్ఛ, కిమయం గాలీలీయో లోకః? ");
INSERT INTO santel_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","తతః స గాలీల్ప్రదేశీయహేరోద్రాజస్య తదా స్థితేస్తస్య సమీపే యీశుం ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","తదా హేరోద్ యీశుం విలోక్య సన్తుతోష, యతః స తస్య బహువృత్తాన్తశ్రవణాత్ తస్య కిఞి्చదాశ్చర్య్యకర్మ్మ పశ్యతి ఇత్యాశాం కృత్వా బహుకాలమారభ్య తం ద్రష్టుం ప్రయాసం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","తస్మాత్ తం బహుకథాః పప్రచ్ఛ కిన్తు స తస్య కస్యాపి వాక్యస్య ప్రత్యుత్తరం నోవాచ| ");
INSERT INTO santel_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","అథ ప్రధానయాజకా అధ్యాపకాశ్చ ప్రోత్తిష్ఠన్తః సాహసేన తమపవదితుం ప్రారేభిరే| ");
INSERT INTO santel_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","హేరోద్ తస్య సేనాగణశ్చ తమవజ్ఞాయ ఉపహాసత్వేన రాజవస్త్రం పరిధాప్య పునః పీలాతం ప్రతి తం ప్రాహిణోత్| ");
INSERT INTO santel_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","పూర్వ్వం హేరోద్పీలాతయోః పరస్పరం వైరభావ ఆసీత్ కిన్తు తద్దినే ద్వయో ర్మేలనం జాతమ్| ");
INSERT INTO santel_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","పశ్చాత్ పీలాతః ప్రధానయాజకాన్ శాసకాన్ లోకాంశ్చ యుగపదాహూయ బభాషే, ");
INSERT INTO santel_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","రాజ్యవిపర్య్యయకారకోయమ్ ఇత్యుక్త్వా మనుష్యమేనం మమ నికటమానైష్ట కిన్తు పశ్యత యుష్మాకం సమక్షమ్ అస్య విచారం కృత్వాపి ప్రోక్తాపవాదానురూపేణాస్య కోప్యపరాధః సప్రమాణో న జాతః, ");
INSERT INTO santel_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","యూయఞ్చ హేరోదః సన్నిధౌ ప్రేషితా మయా తత్రాస్య కోప్యపరాధస్తేనాపి న ప్రాప్తః| పశ్యతానేన వధహేेతుకం కిమపి నాపరాద్ధం| ");
INSERT INTO santel_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","తస్మాదేనం తాడయిత్వా విహాస్యామి| ");
INSERT INTO santel_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","తత్రోత్సవే తేషామేకో మోచయితవ్యః| ");
INSERT INTO santel_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ఇతి హేతోస్తే ప్రోచ్చైరేకదా ప్రోచుః, ఏనం దూరీకృత్య బరబ్బానామానం మోచయ| ");
INSERT INTO santel_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","స బరబ్బా నగర ఉపప్లవవధాపరాధాభ్యాం కారాయాం బద్ధ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","కిన్తు పీలాతో యీశుం మోచయితుం వాఞ్ఛన్ పునస్తానువాచ| ");
INSERT INTO santel_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","తథాప్యేనం క్రుశే వ్యధ క్రుశే వ్యధేతి వదన్తస్తే రురువుః| ");
INSERT INTO santel_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","తతః స తృతీయవారం జగాద కుతః? స కిం కర్మ్మ కృతవాన్? నాహమస్య కమపి వధాపరాధం ప్రాప్తః కేవలం తాడయిత్వాముం త్యజామి| ");
INSERT INTO santel_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","తథాపి తే పునరేనం క్రుశే వ్యధ ఇత్యుక్త్వా ప్రోచ్చైర్దృఢం ప్రార్థయాఞ్చక్రిరే; ");
INSERT INTO santel_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","తతః ప్రధానయాజకాదీనాం కలరవే ప్రబలే సతి తేషాం ప్రార్థనారూపం కర్త్తుం పీలాత ఆదిదేశ| ");
INSERT INTO santel_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","రాజద్రోహవధయోరపరాధేన కారాస్థం యం జనం తే యయాచిరే తం మోచయిత్వా యీశుం తేషామిచ్ఛాయాం సమార్పయత్| ");
INSERT INTO santel_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","అథ తే యీశుం గృహీత్వా యాన్తి, ఏతర్హి గ్రామాదాగతం శిమోననామానం కురీణీయం జనం ధృత్వా యీశోః పశ్చాన్నేతుం తస్య స్కన్ధే క్రుశమర్పయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","తతో లోाకారణ్యమధ్యే బహుస్త్రియో రుదత్యో విలపన్త్యశ్చ యీశోః పశ్చాద్ యయుః| ");
INSERT INTO santel_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","కిన్తు స వ్యాఘుట్య తా ఉవాచ, హే యిరూశాలమో నార్య్యో యుయం మదర్థం న రుదిత్వా స్వార్థం స్వాపత్యార్థఞ్చ రుదితి; ");
INSERT INTO santel_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","పశ్యత యః కదాపి గర్భవత్యో నాభవన్ స్తన్యఞ్చ నాపాయయన్ తాదృశీ ర్వన్ధ్యా యదా ధన్యా వక్ష్యన్తి స కాల ఆయాతి| ");
INSERT INTO santel_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","తదా హే శైలా అస్మాకముపరి పతత, హే ఉపశైలా అస్మానాచ్ఛాదయత కథామీదృశీం లోకా వక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","యతః సతేజసి శాఖిని చేదేతద్ ఘటతే తర్హి శుష్కశాఖిని కిం న ఘటిష్యతే? ");
INSERT INTO santel_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","తదా తే హన్తుం ద్వావపరాధినౌ తేన సార్ద్ధం నిన్యుః| ");
INSERT INTO santel_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","అపరం శిరఃకపాలనామకస్థానం ప్రాప్య తం క్రుశే వివిధుః; తద్ద్వయోరపరాధినోరేకం తస్య దక్షిణో తదన్యం వామే క్రుశే వివిధుః| ");
INSERT INTO santel_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","తదా యీశురకథయత్, హే పితరేతాన్ క్షమస్వ యత ఏతే యత్ కర్మ్మ కుర్వ్వన్తి తన్ న విదుః; పశ్చాత్తే గుటికాపాతం కృత్వా తస్య వస్త్రాణి విభజ్య జగృహుః| ");
INSERT INTO santel_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","తత్ర లోకసంఘస్తిష్ఠన్ దదర్శ; తే తేషాం శాసకాశ్చ తముపహస్య జగదుః, ఏష ఇతరాన్ రక్షితవాన్ యదీశ్వరేణాభిరుచితో ఽభిషిక్తస్త్రాతా భవతి తర్హి స్వమధునా రక్షతు| ");
INSERT INTO santel_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","తదన్యః సేనాగణా ఏత్య తస్మై అమ్లరసం దత్వా పరిహస్య ప్రోవాచ, ");
INSERT INTO santel_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","చేత్త్వం యిహూదీయానాం రాజాసి తర్హి స్వం రక్ష| ");
INSERT INTO santel_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","యిహూదీయానాం రాజేతి వాక్యం యూనానీయరోమీయేబ్రీయాక్షరై ర్లిఖితం తచ్ఛిరస ఊర్ద్ధ్వేఽస్థాప్యత| ");
INSERT INTO santel_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","తదోభయపార్శ్వయో ర్విద్ధౌ యావపరాధినౌ తయోరేకస్తం వినిన్ద్య బభాషే, చేత్త్వమ్ అభిషిక్తోసి తర్హి స్వమావాఞ్చ రక్ష| ");
INSERT INTO santel_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","కిన్త్వన్యస్తం తర్జయిత్వావదత్, ఈశ్వరాత్తవ కిఞ్చిదపి భయం నాస్తి కిం? త్వమపి సమానదణ్డోసి, ");
INSERT INTO santel_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","యోగ్యపాత్రే ఆవాం స్వస్వకర్మ్మణాం సముచితఫలం ప్రాప్నువః కిన్త్వనేన కిమపి నాపరాద్ధం| ");
INSERT INTO santel_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","అథ స యీశుం జగాద హే ప్రభే భవాన్ స్వరాజ్యప్రవేశకాలే మాం స్మరతు| ");
INSERT INTO santel_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","తదా యీశుః కథితవాన్ త్వాం యథార్థం వదామి త్వమద్యైవ మయా సార్ద్ధం పరలోకస్య సుఖస్థానం ప్రాప్స్యసి| ");
INSERT INTO santel_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","అపరఞ్చ ద్వితీయయామాత్ తృతీయయామపర్య్యన్తం రవేస్తేజసోన్తర్హితత్వాత్ సర్వ్వదేశోఽన్ధకారేణావృతో ");
INSERT INTO santel_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","మన్దిరస్య యవనికా చ ఛిద్యమానా ద్విధా బభూవ| ");
INSERT INTO santel_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","తతో యీశురుచ్చైరువాచ, హే పిత ర్మమాత్మానం తవ కరే సమర్పయే, ఇత్యుక్త్వా స ప్రాణాన్ జహౌ| ");
INSERT INTO santel_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","తదైతా ఘటనా దృష్ట్వా శతసేనాపతిరీశ్వరం ధన్యముక్త్వా కథితవాన్ అయం నితాన్తం సాధుమనుష్య ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","అథ యావన్తో లోకా ద్రష్టుమ్ ఆగతాస్తే తా ఘటనా దృష్ట్వా వక్షఃసు కరాఘాతం కృత్వా వ్యాచుట్య గతాః| ");
INSERT INTO santel_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","యీశో ర్జ్ఞాతయో యా యా యోషితశ్చ గాలీలస్తేన సార్ద్ధమాయాతాస్తా అపి దూరే స్థిత్వా తత్ సర్వ్వం దదృశుః| ");
INSERT INTO santel_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","తదా యిహూదీయానాం మన్త్రణాం క్రియాఞ్చాసమ్మన్యమాన ఈశ్వరస్య రాజత్వమ్ అపేక్షమాణో ");
INSERT INTO santel_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","యిహూదిదేశీయో ఽరిమథీయనగరీయో యూషఫ్నామా మన్త్రీ భద్రో ధార్మ్మికశ్చ పుమాన్ ");
INSERT INTO santel_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","పీలాతాన్తికం గత్వా యీశో ర్దేహం యయాచే| ");
INSERT INTO santel_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","పశ్చాద్ వపురవరోహ్య వాససా సంవేష్ట్య యత్ర కోపి మానుషో నాస్థాప్యత తస్మిన్ శైలే స్వాతే శ్మశానే తదస్థాపయత్| ");
INSERT INTO santel_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","తద్దినమాయోజనీయం దినం విశ్రామవారశ్చ సమీపః| ");
INSERT INTO santel_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","అపరం యీశునా సార్ద్ధం గాలీల ఆగతా యోషితః పశ్చాదిత్వా శ్మశానే తత్ర యథా వపుః స్థాపితం తచ్చ దృష్ట్వా ");
INSERT INTO santel_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","వ్యాఘుట్య సుగన్ధిద్రవ్యతైలాని కృత్వా విధివద్ విశ్రామవారే విశ్రామం చక్రుః| ");
INSERT INTO santel_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","అథ సప్తాహప్రథమదినేఽతిప్రత్యూషే తా యోషితః సమ్పాదితం సుగన్ధిద్రవ్యం గృహీత్వా తదన్యాభిః కియతీభిః స్త్రీభిః సహ శ్మశానం యయుః| ");
INSERT INTO santel_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","కిన్తు శ్మశానద్వారాత్ పాషాణమపసారితం దృష్ట్వా ");
INSERT INTO santel_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","తాః ప్రవిశ్య ప్రభో ర్దేహమప్రాప్య ");
INSERT INTO santel_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","వ్యాకులా భవన్తి ఏతర్హి తేజోమయవస్త్రాన్వితౌ ద్వౌ పురుషౌ తాసాం సమీపే సముపస్థితౌ ");
INSERT INTO santel_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","తస్మాత్తాః శఙ్కాయుక్తా భూమావధోముఖ్యస్యస్థుః| తదా తౌ తా ఊచతు ర్మృతానాం మధ్యే జీవన్తం కుతో మృగయథ? ");
INSERT INTO santel_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","సోత్ర నాస్తి స ఉదస్థాత్| ");
INSERT INTO santel_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","పాపినాం కరేషు సమర్పితేన క్రుశే హతేన చ మనుష్యపుత్రేణ తృతీయదివసే శ్మశానాదుత్థాతవ్యమ్ ఇతి కథాం స గలీలి తిష్ఠన్ యుష్మభ్యం కథితవాన్ తాం స్మరత| ");
INSERT INTO santel_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","తదా తస్య సా కథా తాసాం మనఃసు జాతా| ");
INSERT INTO santel_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","అనన్తరం శ్మశానాద్ గత్వా తా ఏకాదశశిష్యాదిభ్యః సర్వ్వేభ్యస్తాం వార్త్తాం కథయామాసుః| ");
INSERT INTO santel_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","మగ్దలీనీమరియమ్, యోహనా, యాకూబో మాతా మరియమ్ తదన్యాః సఙ్గిన్యో యోషితశ్చ ప్రేరితేభ్య ఏతాః సర్వ్వా వార్త్తాః కథయామాసుః ");
INSERT INTO santel_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","కిన్తు తాసాం కథామ్ అనర్థకాఖ్యానమాత్రం బుద్ధ్వా కోపి న ప్రత్యైత్| ");
INSERT INTO santel_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","తదా పితర ఉత్థాయ శ్మశానాన్తికం దధావ, తత్ర చ ప్రహ్వో భూత్వా పార్శ్వైకస్థాపితం కేవలం వస్త్రం దదర్శ; తస్మాదాశ్చర్య్యం మన్యమానో యదఘటత తన్మనసి విచారయన్ ప్రతస్థే| ");
INSERT INTO santel_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","తస్మిన్నేవ దినే ద్వౌ శియ్యౌ యిరూశాలమశ్చతుష్క్రోశాన్తరితమ్ ఇమ్మాయుగ్రామం గచ్ఛన్తౌ ");
INSERT INTO santel_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","తాసాం ఘటనానాం కథామకథయతాం ");
INSERT INTO santel_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","తయోరాలాపవిచారయోః కాలే యీశురాగత్య తాభ్యాం సహ జగామ ");
INSERT INTO santel_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","కిన్తు యథా తౌ తం న పరిచినుతస్తదర్థం తయో ర్దృష్టిః సంరుద్ధా| ");
INSERT INTO santel_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","స తౌ పృష్టవాన్ యువాం విషణ్ణౌ కిం విచారయన్తౌ గచ్ఛథః? ");
INSERT INTO santel_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","తతస్తయోః క్లియపానామా ప్రత్యువాచ యిరూశాలమపురేఽధునా యాన్యఘటన్త త్వం కేవలవిదేశీ కిం తద్వృత్తాన్తం న జానాసి? ");
INSERT INTO santel_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","స పప్రచ్ఛ కా ఘటనాః? తదా తౌ వక్తుమారేభాతే యీశునామా యో నాసరతీయో భవిష్యద్వాదీ ఈశ్వరస్య మానుషాణాఞ్చ సాక్షాత్ వాక్యే కర్మ్మణి చ శక్తిమానాసీత్ ");
INSERT INTO santel_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","తమ్ అస్మాకం ప్రధానయాజకా విచారకాశ్చ కేనాపి ప్రకారేణ క్రుశే విద్ధ్వా తస్య ప్రాణాననాశయన్ తదీయా ఘటనాః; ");
INSERT INTO santel_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","కిన్తు య ఇస్రాయేలీయలోకాన్ ఉద్ధారయిష్యతి స ఏవాయమ్ ఇత్యాశాస్మాభిః కృతా| తద్యథా తథాస్తు తస్యా ఘటనాయా అద్య దినత్రయం గతం| ");
INSERT INTO santel_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","అధికన్త్వస్మాకం సఙ్గినీనాం కియత్స్త్రీణాం ముఖేభ్యోఽసమ్భవవాక్యమిదం శ్రుతం; ");
INSERT INTO santel_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","తాః ప్రత్యూషే శ్మశానం గత్వా తత్ర తస్య దేహమ్ అప్రాప్య వ్యాఘుట్యేత్వా ప్రోక్తవత్యః స్వర్గీసదూతౌ దృష్టావస్మాభిస్తౌ చావాదిష్టాం స జీవితవాన్| ");
INSERT INTO santel_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","తతోస్మాకం కైశ్చిత్ శ్మశానమగమ్యత తేఽపి స్త్రీణాం వాక్యానురూపం దృష్టవన్తః కిన్తు తం నాపశ్యన్| ");
INSERT INTO santel_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","తదా స తావువాచ, హే అబోధౌ హే భవిష్యద్వాదిభిరుక్తవాక్యం ప్రత్యేతుం విలమ్బమానౌ; ");
INSERT INTO santel_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ఏతత్సర్వ్వదుఃఖం భుక్త్వా స్వభూతిప్రాప్తిః కిం ఖ్రీష్టస్య న న్యాయ్యా? ");
INSERT INTO santel_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","తతః స మూసాగ్రన్థమారభ్య సర్వ్వభవిష్యద్వాదినాం సర్వ్వశాస్త్రే స్వస్మిన్ లిఖితాఖ్యానాభిప్రాయం బోధయామాస| ");
INSERT INTO santel_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","అథ గమ్యగ్రామాభ్యర్ణం ప్రాప్య తేనాగ్రే గమనలక్షణే దర్శితే ");
INSERT INTO santel_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","తౌ సాధయిత్వావదతాం సహావాభ్యాం తిష్ఠ దినే గతే సతి రాత్రిరభూత్; తతః స తాభ్యాం సార్ద్ధం స్థాతుం గృహం యయౌ| ");
INSERT INTO santel_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","పశ్చాద్భోజనోపవేశకాలే స పూపం గృహీత్వా ఈశ్వరగుణాన్ జగాద తఞ్చ భంక్త్వా తాభ్యాం దదౌ| ");
INSERT INTO santel_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","తదా తయో ర్దృష్టౌ ప్రసన్నాయాం తం ప్రత్యభిజ్ఞతుః కిన్తు స తయోః సాక్షాదన్తర్దధే| ");
INSERT INTO santel_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","తతస్తౌ మిథోభిధాతుమ్ ఆరబ్ధవన్తౌ గమనకాలే యదా కథామకథయత్ శాస్త్రార్థఞ్చబోధయత్ తదావయో ర్బుద్ధిః కిం న ప్రాజ్వలత్? ");
INSERT INTO santel_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","తౌ తత్క్షణాదుత్థాయ యిరూశాలమపురం ప్రత్యాయయతుః, తత్స్థానే శిష్యాణామ్ ఏకాదశానాం సఙ్గినాఞ్చ దర్శనం జాతం| ");
INSERT INTO santel_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","తే ప్రోచుః ప్రభురుదతిష్ఠద్ ఇతి సత్యం శిమోనే దర్శనమదాచ్చ| ");
INSERT INTO santel_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","తతః పథః సర్వ్వఘటనాయాః పూపభఞ్జనేన తత్పరిచయస్య చ సర్వ్వవృత్తాన్తం తౌ వక్తుమారేభాతే| ");
INSERT INTO santel_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ఇత్థం తే పరస్పరం వదన్తి తత్కాలే యీశుః స్వయం తేషాం మధ్య ప్రోత్థయ యుష్మాకం కల్యాణం భూయాద్ ఇత్యువాచ, ");
INSERT INTO santel_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","కిన్తు భూతం పశ్యామ ఇత్యనుమాయ తే సముద్వివిజిరే త్రేషుశ్చ| ");
INSERT INTO santel_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","స ఉవాచ, కుతో దుఃఖితా భవథ? యుష్మాకం మనఃసు సన్దేహ ఉదేతి చ కుతః? ");
INSERT INTO santel_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ఏషోహం, మమ కరౌ పశ్యత వరం స్పృష్ట్వా పశ్యత, మమ యాదృశాని పశ్యథ తాదృశాని భూతస్య మాంసాస్థీని న సన్తి| ");
INSERT INTO santel_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ఇత్యుక్త్వా స హస్తపాదాన్ దర్శయామాస| ");
INSERT INTO santel_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","తేఽసమ్భవం జ్ఞాత్వా సానన్దా న ప్రత్యయన్| తతః స తాన్ పప్రచ్ఛ, అత్ర యుష్మాకం సమీపే ఖాద్యం కిఞ్చిదస్తి? ");
INSERT INTO santel_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","తతస్తే కియద్దగ్ధమత్స్యం మధు చ దదుః ");
INSERT INTO santel_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","స తదాదాయ తేషాం సాక్షాద్ బుభుజే ");
INSERT INTO santel_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","కథయామాస చ మూసావ్యవస్థాయాం భవిష్యద్వాదినాం గ్రన్థేషు గీతపుస్తకే చ మయి యాని సర్వ్వాణి వచనాని లిఖితాని తదనురూపాణి ఘటిష్యన్తే యుష్మాభిః సార్ద్ధం స్థిత్వాహం యదేతద్వాక్యమ్ అవదం తదిదానీం ప్రత్యక్షమభూత్| ");
INSERT INTO santel_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","అథ తేభ్యః శాస్త్రబోధాధికారం దత్వావదత్, ");
INSERT INTO santel_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ఖ్రీష్టేనేత్థం మృతియాతనా భోక్తవ్యా తృతీయదినే చ శ్మశానాదుత్థాతవ్యఞ్చేతి లిపిరస్తి; ");
INSERT INTO santel_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","తన్నామ్నా యిరూశాలమమారభ్య సర్వ్వదేశే మనఃపరావర్త్తనస్య పాపమోచనస్య చ సుసంవాదః ప్రచారయితవ్యః, ");
INSERT INTO santel_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ఏషు సర్వ్వేషు యూయం సాక్షిణః| ");
INSERT INTO santel_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","అపరఞ్చ పశ్యత పిత్రా యత్ ప్రతిజ్ఞాతం తత్ ప్రేషయిష్యామి, అతఏవ యావత్కాలం యూయం స్వర్గీయాం శక్తిం న ప్రాప్స్యథ తావత్కాలం యిరూశాలమ్నగరే తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","అథ స తాన్ బైథనీయాపర్య్యన్తం నీత్వా హస్తావుత్తోల్య ఆశిష వక్తుమారేభే ");
INSERT INTO santel_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ఆశిషం వదన్నేవ చ తేభ్యః పృథగ్ భూత్వా స్వర్గాయ నీతోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","తదా తే తం భజమానా మహానన్దేన యిరూశాలమం ప్రత్యాజగ్ముః| ");
INSERT INTO santel_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","తతో నిరన్తరం మన్దిరే తిష్ఠన్త ఈశ్వరస్య ప్రశంసాం ధన్యవాదఞ్చ కర్త్తమ్ ఆరేభిరే| ఇతి||");
INSERT INTO santel_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ఆదౌ వాద ఆసీత్ స చ వాద ఈశ్వరేణ సార్ధమాసీత్ స వాదః స్వయమీశ్వర ఏవ| ");
INSERT INTO santel_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","స ఆదావీశ్వరేణ సహాసీత్| ");
INSERT INTO santel_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","తేన సర్వ్వం వస్తు ససృజే సర్వ్వేషు సృష్టవస్తుషు కిమపి వస్తు తేనాసృష్టం నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","స జీవనస్యాకారః, తచ్చ జీవనం మనుష్యాణాం జ్యోతిః ");
INSERT INTO santel_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","తజ్జ్యోతిరన్ధకారే ప్రచకాశే కిన్త్వన్ధకారస్తన్న జగ్రాహ| ");
INSERT INTO santel_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","యోహన్ నామక ఏకో మనుజ ఈశ్వరేణ ప్రేషయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","తద్వారా యథా సర్వ్వే విశ్వసన్తి తదర్థం స తజ్జ్యోతిషి ప్రమాణం దాతుం సాక్షిస్వరూపో భూత్వాగమత్, ");
INSERT INTO santel_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","స స్వయం తజ్జ్యోతి ర్న కిన్తు తజ్జ్యోతిషి ప్రమాణం దాతుమాగమత్| ");
INSERT INTO santel_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","జగత్యాగత్య యః సర్వ్వమనుజేభ్యో దీప్తిం దదాతి తదేవ సత్యజ్యోతిః| ");
INSERT INTO santel_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","స యజ్జగదసృజత్ తన్మద్య ఏవ స ఆసీత్ కిన్తు జగతో లోకాస్తం నాజానన్| ");
INSERT INTO santel_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","నిజాధికారం స ఆగచ్ఛత్ కిన్తు ప్రజాస్తం నాగృహ్లన్| ");
INSERT INTO santel_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","తథాపి యే యే తమగృహ్లన్ అర్థాత్ తస్య నామ్ని వ్యశ్వసన్ తేభ్య ఈశ్వరస్య పుత్రా భవితుమ్ అధికారమ్ అదదాత్| ");
INSERT INTO santel_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","తేషాం జనిః శోణితాన్న శారీరికాభిలాషాన్న మానవానామిచ్ఛాతో న కిన్త్వీశ్వరాదభవత్| ");
INSERT INTO santel_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","స వాదో మనుష్యరూపేణావతీర్య్య సత్యతానుగ్రహాభ్యాం పరిపూర్ణః సన్ సార్ధమ్ అస్మాభి ర్న్యవసత్ తతః పితురద్వితీయపుత్రస్య యోగ్యో యో మహిమా తం మహిమానం తస్యాపశ్యామ| ");
INSERT INTO santel_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","తతో యోహనపి ప్రచార్య్య సాక్ష్యమిదం దత్తవాన్ యో మమ పశ్చాద్ ఆగమిష్యతి స మత్తో గురుతరః; యతో మత్పూర్వ్వం స విద్యమాన ఆసీత్; యదర్థమ్ అహం సాక్ష్యమిదమ్ అదాం స ఏషః| ");
INSERT INTO santel_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","అపరఞ్చ తస్య పూర్ణతాయా వయం సర్వ్వే క్రమశః క్రమశోనుగ్రహం ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","మూసాద్వారా వ్యవస్థా దత్తా కిన్త్వనుగ్రహః సత్యత్వఞ్చ యీశుఖ్రీష్టద్వారా సముపాతిష్ఠతాం| ");
INSERT INTO santel_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","కోపి మనుజ ఈశ్వరం కదాపి నాపశ్యత్ కిన్తు పితుః క్రోడస్థోఽద్వితీయః పుత్రస్తం ప్రకాశయత్| ");
INSERT INTO santel_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","త్వం కః? ఇతి వాక్యం ప్రేష్టుం యదా యిహూదీయలోకా యాజకాన్ లేవిలోకాంశ్చ యిరూశాలమో యోహనః సమీపే ప్రేషయామాసుః, ");
INSERT INTO santel_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","తదా స స్వీకృతవాన్ నాపహ్నూతవాన్ నాహమ్ అభిషిక్త ఇత్యఙ్గీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","తదా తేఽపృచ్ఛన్ తర్హి కో భవాన్? కిం ఏలియః? సోవదత్ న; తతస్తేఽపృచ్ఛన్ తర్హి భవాన్ స భవిష్యద్వాదీ? సోవదత్ నాహం సః| ");
INSERT INTO santel_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","తదా తేఽపృచ్ఛన్ తర్హి భవాన్ కః? వయం గత్వా ప్రేరకాన్ త్వయి కిం వక్ష్యామః? స్వస్మిన్ కిం వదసి? ");
INSERT INTO santel_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","తదా సోవదత్| పరమేశస్య పన్థానం పరిష్కురుత సర్వ్వతః| ఇతీదం ప్రాన్తరే వాక్యం వదతః కస్యచిద్రవః| కథామిమాం యస్మిన్ యిశయియో భవిష్యద్వాదీ లిఖితవాన్ సోహమ్| ");
INSERT INTO santel_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","యే ప్రేషితాస్తే ఫిరూశిలోకాః| ");
INSERT INTO santel_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","తదా తేఽపృచ్ఛన్ యది నాభిషిక్తోసి ఏలియోసి న స భవిష్యద్వాద్యపి నాసి చ, తర్హి లోకాన్ మజ్జయసి కుతః? ");
INSERT INTO santel_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","తతో యోహన్ ప్రత్యవోచత్, తోయేఽహం మజ్జయామీతి సత్యం కిన్తు యం యూయం న జానీథ తాదృశ ఏకో జనో యుష్మాకం మధ్య ఉపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","స మత్పశ్చాద్ ఆగతోపి మత్పూర్వ్వం వర్త్తమాన ఆసీత్ తస్య పాదుకాబన్ధనం మోచయితుమపి నాహం యోగ్యోస్మి| ");
INSERT INTO santel_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","యర్ద్దననద్యాః పారస్థబైథబారాయాం యస్మిన్స్థానే యోహనమజ్జయత్ తస్మిన స్థానే సర్వ్వమేతద్ అఘటత| ");
INSERT INTO santel_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","పరేఽహని యోహన్ స్వనికటమాగచ్ఛన్తం యిశుం విలోక్య ప్రావోచత్ జగతః పాపమోచకమ్ ఈశ్వరస్య మేషశావకం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","యో మమ పశ్చాదాగమిష్యతి స మత్తో గురుతరః, యతో హేతోర్మత్పూర్వ్వం సోఽవర్త్తత యస్మిన్నహం కథామిమాం కథితవాన్ స ఏవాయం| ");
INSERT INTO santel_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","అపరం నాహమేనం ప్రత్యభిజ్ఞాతవాన్ కిన్తు ఇస్రాయేల్లోకా ఏనం యథా పరిచిన్వన్తి తదభిప్రాయేణాహం జలే మజ్జయితుమాగచ్ఛమ్| ");
INSERT INTO santel_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","పునశ్చ యోహనపరమేకం ప్రమాణం దత్వా కథితవాన్ విహాయసః కపోతవద్ అవతరన్తమాత్మానమ్ అస్యోపర్య్యవతిష్ఠన్తం చ దృష్టవానహమ్| ");
INSERT INTO santel_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","నాహమేనం ప్రత్యభిజ్ఞాతవాన్ ఇతి సత్యం కిన్తు యో జలే మజ్జయితుం మాం ప్రైరయత్ స ఏవేమాం కథామకథయత్ యస్యోపర్య్యాత్మానమ్ అవతరన్తమ్ అవతిష్ఠన్తఞ్చ ద్రక్షయసి సఏవ పవిత్రే ఆత్మని మజ్జయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","అవస్తన్నిరీక్ష్యాయమ్ ఈశ్వరస్య తనయ ఇతి ప్రమాణం దదామి| ");
INSERT INTO santel_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","పరేఽహని యోహన్ ద్వాభ్యాం శిష్యాభ్యాం సార్ద్ధేం తిష్ఠన్ ");
INSERT INTO santel_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","యిశుం గచ్ఛన్తం విలోక్య గదితవాన్, ఈశ్వరస్య మేషశావకం పశ్యతం| ");
INSERT INTO santel_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ఇమాం కథాం శ్రుత్వా ద్వౌ శిష్యౌ యీశోః పశ్చాద్ ఈయతుః| ");
INSERT INTO santel_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","తతో యీశుః పరావృత్య తౌ పశ్చాద్ ఆగచ్ఛన్తౌ దృష్ట్వా పృష్టవాన్ యువాం కిం గవేశయథః? తావపృచ్ఛతాం హే రబ్బి అర్థాత్ హే గురో భవాన్ కుత్ర తిష్ఠతి? ");
INSERT INTO santel_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","తతః సోవాదిత్ ఏత్య పశ్యతం| తతో దివసస్య తృతీయప్రహరస్య గతత్వాత్ తౌ తద్దినం తస్య సఙ్గేఽస్థాతాం| ");
INSERT INTO santel_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","యౌ ద్వౌ యోహనో వాక్యం శ్రుత్వా యిశోః పశ్చాద్ ఆగమతాం తయోః శిమోన్పితరస్య భ్రాతా ఆన్ద్రియః ");
INSERT INTO santel_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","స ఇత్వా ప్రథమం నిజసోదరం శిమోనం సాక్షాత్ప్రాప్య కథితవాన్ వయం ఖ్రీష్టమ్ అర్థాత్ అభిషిక్తపురుషం సాక్షాత్కృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","పశ్చాత్ స తం యిశోః సమీపమ్ ఆనయత్| తదా యీశుస్తం దృష్ట్వావదత్ త్వం యూనసః పుత్రః శిమోన్ కిన్తు త్వన్నామధేయం కైఫాః వా పితరః అర్థాత్ ప్రస్తరో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","పరేఽహని యీశౌ గాలీలం గన్తుం నిశ్చితచేతసి సతి ఫిలిపనామానం జనం సాక్షాత్ప్రాప్యావోచత్ మమ పశ్చాద్ ఆగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","బైత్సైదానామ్ని యస్మిన్ గ్రామే పితరాన్ద్రియయోర్వాస ఆసీత్ తస్మిన్ గ్రామే తస్య ఫిలిపస్య వసతిరాసీత్| ");
INSERT INTO santel_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","పశ్చాత్ ఫిలిపో నిథనేలం సాక్షాత్ప్రాప్యావదత్ మూసా వ్యవస్థా గ్రన్థే భవిష్యద్వాదినాం గ్రన్థేషు చ యస్యాఖ్యానం లిఖితమాస్తే తం యూషఫః పుత్రం నాసరతీయం యీశుం సాక్షాద్ అకార్ష్మ వయం| ");
INSERT INTO santel_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","తదా నిథనేల్ కథితవాన్ నాసరన్నగరాత కిం కశ్చిదుత్తమ ఉత్పన్తుం శక్నోతి? తతః ఫిలిపో ఽవోచత్ ఏత్య పశ్య| ");
INSERT INTO santel_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","అపరఞ్చ యీశుః స్వస్య సమీపం తమ్ ఆగచ్ఛన్తం దృష్ట్వా వ్యాహృతవాన్, పశ్యాయం నిష్కపటః సత్య ఇస్రాయేల్లోకః| ");
INSERT INTO santel_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","తతః సోవదద్, భవాన్ మాం కథం ప్రత్యభిజానాతి? యీశురవాదీత్ ఫిలిపస్య ఆహ్వానాత్ పూర్వ్వం యదా త్వముడుమ్బరస్య తరోర్మూలేఽస్థాస్తదా త్వామదర్శమ్| ");
INSERT INTO santel_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","నిథనేల్ అచకథత్, హే గురో భవాన్ నితాన్తమ్ ఈశ్వరస్య పుత్రోసి, భవాన్ ఇస్రాయేల్వంశస్య రాజా| ");
INSERT INTO santel_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","తతో యీశు ర్వ్యాహరత్, త్వాముడుమ్బరస్య పాదపస్య మూలే దృష్టవానాహం మమైతస్మాద్వాక్యాత్ కిం త్వం వ్యశ్వసీః? ఏతస్మాదప్యాశ్చర్య్యాణి కార్య్యాణి ద్రక్ష్యసి| ");
INSERT INTO santel_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","అన్యచ్చావాదీద్ యుష్మానహం యథార్థం వదామి, ఇతః పరం మోచితే మేఘద్వారే తస్మాన్మనుజసూనునా ఈశ్వరస్య దూతగణమ్ అవరోహన్తమారోహన్తఞ్చ ద్రక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","అనన్తరం త్రుతీయదివసే గాలీల్ ప్రదేశియే కాన్నానామ్ని నగరే వివాహ ఆసీత్ తత్ర చ యీశోర్మాతా తిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","తస్మై వివాహాయ యీశుస్తస్య శిష్యాశ్చ నిమన్త్రితా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","తదనన్తరం ద్రాక్షారసస్య న్యూనత్వాద్ యీశోర్మాతా తమవదత్ ఏతేషాం ద్రాక్షారసో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","తదా స తామవోచత్ హే నారి మయా సహ తవ కిం కార్య్యం? మమ సమయ ఇదానీం నోపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","తతస్తస్య మాతా దాసానవోచద్ అయం యద్ వదతి తదేవ కురుత| ");
INSERT INTO santel_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","తస్మిన్ స్థానే యిహూదీయానాం శుచిత్వకరణవ్యవహారానుసారేణాఢకైకజలధరాణి పాషాణమయాని షడ్వృహత్పాత్రాణిఆసన్| ");
INSERT INTO santel_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","తదా యీశుస్తాన్ సర్వ్వకలశాన్ జలైః పూరయితుం తానాజ్ఞాపయత్, తతస్తే సర్వ్వాన్ కుమ్భానాకర్ణం జలైః పర్య్యపూరయన్| ");
INSERT INTO santel_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","అథ తేభ్యః కిఞ్చిదుత్తార్య్య భోజ్యాధిపాతేఃసమీపం నేతుం స తానాదిశత్, తే తదనయన్| ");
INSERT INTO santel_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","అపరఞ్చ తజ్జలం కథం ద్రాక్షారసోఽభవత్ తజ్జలవాహకాదాసా జ్ఞాతుం శక్తాః కిన్తు తద్భోజ్యాధిపో జ్ఞాతుం నాశక్నోత్ తదవలిహ్య వరం సంమ్బోద్యావదత, ");
INSERT INTO santel_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","లోకాః ప్రథమం ఉత్తమద్రాక్షారసం దదతి తషు యథేష్టం పితవత్సు తస్మా కిఞ్చిదనుత్తమఞ్చ దదతి కిన్తు త్వమిదానీం యావత్ ఉత్తమద్రాక్షారసం స్థాపయసి| ");
INSERT INTO santel_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ఇత్థం యీశుర్గాలీలప్రదేశే ఆశ్చర్య్యకార్మ్మ ప్రారమ్భ నిజమహిమానం ప్రాకాశయత్ తతః శిష్యాస్తస్మిన్ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","తతః పరమ్ స నిజమాత్రుభ్రాత్రుస్శిష్యైః సార్ద్ధ్ం కఫర్నాహూమమ్ ఆగమత్ కిన్తు తత్ర బహూదినాని ఆతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","తదనన్తరం యిహూదియానాం నిస్తారోత్సవే నికటమాగతే యీశు ర్యిరూశాలమ్ నగరమ్ ఆగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","తతో మన్దిరస్య మధ్యే గోమేషపారావతవిక్రయిణో వాణిజక్ష్చోపవిష్టాన్ విలోక్య ");
INSERT INTO santel_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","రజ్జుభిః కశాం నిర్మ్మాయ సర్వ్వగోమేషాదిభిః సార్ద్ధం తాన్ మన్దిరాద్ దూరీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","వణిజాం ముద్రాది వికీర్య్య ఆసనాని న్యూబ్జీకృత్య పారావతవిక్రయిభ్యోఽకథయద్ అస్మాత్ స్థానాత్ సర్వాణ్యేతాని నయత, మమ పితుగృహం వాణిజ్యగృహం మా కార్ష్ట| ");
INSERT INTO santel_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","తస్మాత్ తన్మన్దిరార్థ ఉద్యోగో యస్తు స గ్రసతీవ మామ్| ఇమాం శాస్త్రీయలిపిం శిష్యాఃసమస్మరన్| ");
INSERT INTO santel_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","తతః పరమ్ యిహూదీయలోకా యీషిమవదన్ తవమిదృశకర్మ్మకరణాత్ కిం చిహ్నమస్మాన్ దర్శయసి? ");
INSERT INTO santel_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","తతో యీశుస్తానవోచద్ యుష్మాభిరే తస్మిన్ మన్దిరే నాశితే దినత్రయమధ్యేఽహం తద్ ఉత్థాపయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","తదా యిహూదియా వ్యాహార్షుః, ఏతస్య మన్దిరస నిర్మ్మాణేన షట్చత్వారింశద్ వత్సరా గతాః, త్వం కిం దినత్రయమధ్యే తద్ ఉత్థాపయిష్యసి? ");
INSERT INTO santel_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","కిన్తు స నిజదేహరూపమన్దిరే కథామిమాం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","స యదేతాదృశం గదితవాన్ తచ్ఛిష్యాః శ్మశానాత్ తదీయోత్థానే సతి స్మృత్వా ధర్మ్మగ్రన్థే యీశునోక్తకథాయాం చ వ్యశ్వసిషుః| ");
INSERT INTO santel_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","అనన్తరం నిస్తారోత్సవస్య భోజ్యసమయే యిరూశాలమ్ నగరే తత్క్రుతాశ్చర్య్యకర్మ్మాణి విలోక్య బహుభిస్తస్య నామని విశ్వసితం| ");
INSERT INTO santel_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","కిన్తు స తేషాం కరేషు స్వం న సమర్పయత్, యతః స సర్వ్వానవైత్| ");
INSERT INTO santel_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","స మానవేషు కస్యచిత్ ప్రమాణం నాపేక్షత యతో మనుజానాం మధ్యే యద్యదస్తి తత్తత్ సోజానాత్| ");
INSERT INTO santel_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","నికదిమనామా యిహూదీయానామ్ అధిపతిః ఫిరూశీ క్షణదాయాం ");
INSERT INTO santel_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","యీశౌరభ్యర్ణమ్ ఆవ్రజ్య వ్యాహార్షీత్, హే గురో భవాన్ ఈశ్వరాద్ ఆగత్ ఏక ఉపదేష్టా, ఏతద్ అస్మాభిర్జ్ఞాయతే; యతో భవతా యాన్యాశ్చర్య్యకర్మ్మాణి క్రియన్తే పరమేశ్వరస్య సాహాయ్యం వినా కేనాపి తత్తత్కర్మ్మాణి కర్త్తుం న శక్యన్తే| ");
INSERT INTO santel_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","తదా యీశురుత్తరం దత్తవాన్ తవాహం యథార్థతరం వ్యాహరామి పునర్జన్మని న సతి కోపి మానవ ఈశ్వరస్య రాజ్యం ద్రష్టుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","తతో నికదీమః ప్రత్యవోచత్ మనుజో వృద్ధో భూత్వా కథం జనిష్యతే? స కిం పున ర్మాతృర్జఠరం ప్రవిశ్య జనితుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","యీశురవాదీద్ యథార్థతరమ్ అహం కథయామి మనుజే తోయాత్మభ్యాం పున ర్న జాతే స ఈశ్వరస్య రాజ్యం ప్రవేష్టుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","మాంసాద్ యత్ జాయతే తన్ మాంసమేవ తథాత్మనో యో జాయతే స ఆత్మైవ| ");
INSERT INTO santel_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","యుష్మాభిః పున ర్జనితవ్యం మమైతస్యాం కథాయామ్ ఆశ్చర్యం మా మంస్థాః| ");
INSERT INTO santel_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","సదాగతిర్యాం దిశమిచ్ఛతి తస్యామేవ దిశి వాతి, త్వం తస్య స్వనం శుణోషి కిన్తు స కుత ఆయాతి కుత్ర యాతి వా కిమపి న జానాసి తద్వాద్ ఆత్మనః సకాశాత్ సర్వ్వేషాం మనుజానాం జన్మ భవతి| ");
INSERT INTO santel_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","తదా నికదీమః పృష్టవాన్ ఏతత్ కథం భవితుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","యీశుః ప్రత్యక్తవాన్ త్వమిస్రాయేలో గురుర్భూత్వాపి కిమేతాం కథాం న వేత్సి? ");
INSERT INTO santel_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","తుభ్యం యథార్థం కథయామి, వయం యద్ విద్మస్తద్ వచ్మః యంచ్చ పశ్యామస్తస్యైవ సాక్ష్యం దద్మః కిన్తు యుష్మాభిరస్మాకం సాక్షిత్వం న గృహ్యతే| ");
INSERT INTO santel_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ఏతస్య సంసారస్య కథాయాం కథితాయాం యది యూయం న విశ్వసిథ తర్హి స్వర్గీయాయాం కథాయాం కథం విశ్వసిష్యథ? ");
INSERT INTO santel_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","యః స్వర్గేఽస్తి యం చ స్వర్గాద్ అవారోహత్ తం మానవతనయం వినా కోపి స్వర్గం నారోహత్| ");
INSERT INTO santel_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","అపరఞ్చ మూసా యథా ప్రాన్తరే సర్పం ప్రోత్థాపితవాన్ మనుష్యపుత్రోఽపి తథైవోత్థాపితవ్యః; ");
INSERT INTO santel_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","తస్మాద్ యః కశ్చిత్ తస్మిన్ విశ్వసిష్యతి సోఽవినాశ్యః సన్ అనన్తాయుః ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ఈశ్వర ఇత్థం జగదదయత యత్ స్వమద్వితీయం తనయం ప్రాదదాత్ తతో యః కశ్చిత్ తస్మిన్ విశ్వసిష్యతి సోఽవినాశ్యః సన్ అనన్తాయుః ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ఈశ్వరో జగతో లోకాన్ దణ్డయితుం స్వపుత్రం న ప్రేష్య తాన్ పరిత్రాతుం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","అతఏవ యః కశ్చిత్ తస్మిన్ విశ్వసితి స దణ్డార్హో న భవతి కిన్తు యః కశ్చిత్ తస్మిన్ న విశ్వసితి స ఇదానీమేవ దణ్డార్హో భవతి,యతః స ఈశ్వరస్యాద్వితీయపుత్రస్య నామని ప్రత్యయం న కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","జగతో మధ్యే జ్యోతిః ప్రాకాశత కిన్తు మనుష్యాణాం కర్మ్మణాం దృష్టత్వాత్ తే జ్యోతిషోపి తిమిరే ప్రీయన్తే ఏతదేవ దణ్డస్య కారణాం భవతి| ");
INSERT INTO santel_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","యః కుకర్మ్మ కరోతి తస్యాచారస్య దృష్టత్వాత్ స జ్యోతిరౄతీయిత్వా తన్నికటం నాయాతి; ");
INSERT INTO santel_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","కిన్తు యః సత్కర్మ్మ కరోతి తస్య సర్వ్వాణి కర్మ్మాణీశ్వరేణ కృతానీతి సథా ప్రకాశతే తదభిప్రాయేణ స జ్యోతిషః సన్నిధిమ్ ఆయాతి| ");
INSERT INTO santel_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","తతః పరమ్ యీశుః శిష్యైః సార్ద్ధం యిహూదీయదేశం గత్వా తత్ర స్థిత్వా మజ్జయితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","తదా శాలమ్ నగరస్య సమీపస్థాయిని ఐనన్ గ్రామే బహుతరతోయస్థితేస్తత్ర యోహన్ అమజ్జయత్ తథా చ లోకా ఆగత్య తేన మజ్జితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","తదా యోహన్ కారాయాం న బద్ధః| ");
INSERT INTO santel_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","అపరఞ్చ శాచకర్మ్మణి యోహానః శిష్యైః సహ యిహూదీయలోకానాం వివాదే జాతే, తే యోహనః సంన్నిధిం గత్వాకథయన్, ");
INSERT INTO santel_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","హే గురో యర్ద్దననద్యాః పారే భవతా సార్ద్ధం య ఆసీత్ యస్మింశ్చ భవాన్ సాక్ష్యం ప్రదదాత్ పశ్యతు సోపి మజ్జయతి సర్వ్వే తస్య సమీపం యాన్తి చ| ");
INSERT INTO santel_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","తదా యోహన్ ప్రత్యవోచద్ ఈశ్వరేణ న దత్తే కోపి మనుజః కిమపి ప్రాప్తుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","అహం అభిషిక్తో న భవామి కిన్తు తదగ్రే ప్రేషితోస్మి యామిమాం కథాం కథితవానాహం తత్ర యూయం సర్వ్వే సాక్షిణః స్థ| ");
INSERT INTO santel_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","యో జనః కన్యాం లభతే స ఏవ వరః కిన్తు వరస్య సన్నిధౌ దణ్డాయమానం తస్య యన్మిత్రం తేన వరస్య శబ్దే శ్రుతేఽతీవాహ్లాద్యతే మమాపి తద్వద్ ఆనన్దసిద్ధిర్జాతా| ");
INSERT INTO santel_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","తేన క్రమశో వర్ద్ధితవ్యం కిన్తు మయా హ్సితవ్యం| ");
INSERT INTO santel_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","య ఊర్ధ్వాదాగచ్ఛత్ స సర్వ్వేషాం ముఖ్యో యశ్చ సంసారాద్ ఉదపద్యత స సాంసారికః సంసారీయాం కథాఞ్చ కథయతి యస్తు స్వర్గాదాగచ్ఛత్ స సర్వ్వేషాం ముఖ్యః| ");
INSERT INTO santel_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","స యదపశ్యదశృణోచ్చ తస్మిన్నేవ సాక్ష్యం దదాతి తథాపి ప్రాయశః కశ్చిత్ తస్య సాక్ష్యం న గృహ్లాతి; ");
INSERT INTO santel_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","కిన్తు యో గృహ్లాతి స ఈశ్వరస్య సత్యవాదిత్వం ముద్రాఙ్గితం కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ఈశ్వరేణ యః ప్రేరితః సఏవ ఈశ్వరీయకథాం కథయతి యత ఈశ్వర ఆత్మానం తస్మై అపరిమితమ్ అదదాత్| ");
INSERT INTO santel_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","పితా పుత్రే స్నేహం కృత్వా తస్య హస్తే సర్వ్వాణి సమర్పితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","యః కశ్చిత్ పుత్రే విశ్వసితి స ఏవానన్తమ్ పరమాయుః ప్రాప్నోతి కిన్తు యః కశ్చిత్ పుత్రే న విశ్వసితి స పరమాయుషో దర్శనం న ప్రాప్నోతి కిన్త్వీశ్వరస్య కోపభాజనం భూత్వా తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","యీశుః స్వయం నామజ్జయత్ కేవలం తస్య శిష్యా అమజ్జయత్ కిన్తు యోహనోఽధికశిష్యాన్ స కరోతి మజ్జయతి చ, ");
INSERT INTO santel_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ఫిరూశిన ఇమాం వార్త్తామశృణ్వన్ ఇతి ప్రభురవగత్య ");
INSERT INTO santel_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","యిహూదీయదేశం విహాయ పున ర్గాలీలమ్ ఆగత్| ");
INSERT INTO santel_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","తతః శోమిరోణప్రదేశస్య మద్యేన తేన గన్తవ్యే సతి ");
INSERT INTO santel_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","యాకూబ్ నిజపుత్రాయ యూషఫే యాం భూమిమ్ అదదాత్ తత్సమీపస్థాయి శోమిరోణప్రదేశస్య సుఖార్ నామ్నా విఖ్యాతస్య నగరస్య సన్నిధావుపాస్థాత్| ");
INSERT INTO santel_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","తత్ర యాకూబః ప్రహిరాసీత్; తదా ద్వితీయయామవేలాయాం జాతాయాం స మార్గే శ్రమాపన్నస్తస్య ప్రహేః పార్శ్వే ఉపావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ఏతర్హి కాచిత్ శోమిరోణీయా యోషిత్ తోయోత్తోలనార్థమ్ తత్రాగమత్ ");
INSERT INTO santel_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","తదా శిష్యాః ఖాద్యద్రవ్యాణి క్రేతుం నగరమ్ అగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","యీశుః శోమిరోణీయాం తాం యోషితమ్ వ్యాహార్షీత్ మహ్యం కిఞ్చిత్ పానీయం పాతుం దేహి| కిన్తు శోమిరోణీయైః సాకం యిహూదీయలోకా న వ్యవాహరన్ తస్మాద్ధేతోః సాకథయత్ శోమిరోణీయా యోషితదహం త్వం యిహూదీయోసి కథం మత్తః పానీయం పాతుమ్ ఇచ్ఛసి? ");
INSERT INTO santel_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","తతో యీశురవదద్ ఈశ్వరస్య యద్దానం తత్కీదృక్ పానీయం పాతుం మహ్యం దేహి య ఇత్థం త్వాం యాచతే స వా క ఇతి చేదజ్ఞాస్యథాస్తర్హి తమయాచిష్యథాః స చ తుభ్యమమృతం తోయమదాస్యత్| ");
INSERT INTO santel_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","తదా సా సీమన్తినీ భాషితవతి, హే మహేచ్ఛ ప్రహిర్గమ్భీరో భవతో నీరోత్తోలనపాత్రం నాస్తీ చ తస్మాత్ తదమృతం కీలాలం కుతః ప్రాప్స్యసి? ");
INSERT INTO santel_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","యోస్మభ్యమ్ ఇమమన్ధూం దదౌ, యస్య చ పరిజనా గోమేషాదయశ్చ సర్వ్వేఽస్య ప్రహేః పానీయం పపురేతాదృశో యోస్మాకం పూర్వ్వపురుషో యాకూబ్ తస్మాదపి భవాన్ మహాన్ కిం? ");
INSERT INTO santel_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","తతో యీశురకథయద్ ఇదం పానీయం సః పివతి స పునస్తృషార్త్తో భవిష్యతి, ");
INSERT INTO santel_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","కిన్తు మయా దత్తం పానీయం యః పివతి స పునః కదాపి తృషార్త్తో న భవిష్యతి| మయా దత్తమ్ ఇదం తోయం తస్యాన్తః ప్రస్రవణరూపం భూత్వా అనన్తాయుర్యావత్ స్రోష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","తదా సా వనితాకథయత్ హే మహేచ్ఛ తర్హి మమ పునః పీపాసా యథా న జాయతే తోయోత్తోలనాయ యథాత్రాగమనం న భవతి చ తదర్థం మహ్యం తత్తోయం దేహీ| ");
INSERT INTO santel_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","తతో యీశూరవదద్యాహి తవ పతిమాహూయ స్థానేఽత్రాగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","సా వామావదత్ మమ పతిర్నాస్తి| యీశురవదత్ మమ పతిర్నాస్తీతి వాక్యం భద్రమవోచః| ");
INSERT INTO santel_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","యతస్తవ పఞ్చ పతయోభవన్ అధునా తు త్వయా సార్ద్ధం యస్తిష్ఠతి స తవ భర్త్తా న వాక్యమిదం సత్యమవాదిః| ");
INSERT INTO santel_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","తదా సా మహిలా గదితవతి హే మహేచ్ఛ భవాన్ ఏకో భవిష్యద్వాదీతి బుద్ధం మయా| ");
INSERT INTO santel_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","అస్మాకం పితృలోకా ఏతస్మిన్ శిలోచ్చయేఽభజన్త, కిన్తు భవద్భిరుచ్యతే యిరూశాలమ్ నగరే భజనయోగ్యం స్థానమాస్తే| ");
INSERT INTO santel_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","యీశురవోచత్ హే యోషిత్ మమ వాక్యే విశ్వసిహి యదా యూయం కేవలశైలేఽస్మిన్ వా యిరూశాలమ్ నగరే పితుర్భజనం న కరిష్యధ్వే కాల ఏతాదృశ ఆయాతి| ");
INSERT INTO santel_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","యూయం యం భజధ్వే తం న జానీథ, కిన్తు వయం యం భజామహే తం జానీమహే, యతో యిహూదీయలోకానాం మధ్యాత్ పరిత్రాణం జాయతే| ");
INSERT INTO santel_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","కిన్తు యదా సత్యభక్తా ఆత్మనా సత్యరూపేణ చ పితుర్భజనం కరిష్యన్తే సమయ ఏతాదృశ ఆయాతి, వరమ్ ఇదానీమపి విద్యతే ; యత ఏతాదృశో భత్కాన్ పితా చేష్టతే| ");
INSERT INTO santel_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ఈశ్వర ఆత్మా; తతస్తస్య యే భక్తాస్తైః స ఆత్మనా సత్యరూపేణ చ భజనీయః| ");
INSERT INTO santel_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","తదా సా మహిలావాదీత్ ఖ్రీష్టనామ్నా విఖ్యాతోఽభిషిక్తః పురుష ఆగమిష్యతీతి జానామి స చ సర్వ్వాః కథా అస్మాన్ జ్ఞాపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","తతో యీశురవదత్ త్వయా సార్ద్ధం కథనం కరోమి యోఽహమ్ అహమేవ స పురుషః| ");
INSERT INTO santel_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ఏతస్మిన్ సమయే శిష్యా ఆగత్య తథా స్త్రియా సార్ద్ధం తస్య కథోపకథనే మహాశ్చర్య్యమ్ అమన్యన్త తథాపి భవాన్ కిమిచ్ఛతి? యద్వా కిమర్థమ్ ఏతయా సార్ద్ధం కథాం కథయతి? ఇతి కోపి నాపృచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","తతః పరం సా నారీ కలశం స్థాపయిత్వా నగరమధ్యం గత్వా లోకేభ్యోకథాయద్ ");
INSERT INTO santel_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","అహం యద్యత్ కర్మ్మాకరవం తత్సర్వ్వం మహ్యమకథయద్ ఏతాదృశం మానవమేకమ్ ఆగత్య పశ్యత రు కిమ్ అభిషిక్తో న భవతి ? ");
INSERT INTO santel_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","తతస్తే నగరాద్ బహిరాగత్య తాతస్య సమీపమ్ ఆయన్| ");
INSERT INTO santel_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ఏతర్హి శిష్యాః సాధయిత్వా తం వ్యాహార్షుః హే గురో భవాన్ కిఞ్చిద్ భూక్తాం| ");
INSERT INTO santel_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","తతః సోవదద్ యుష్మాభిర్యన్న జ్ఞాయతే తాదృశం భక్ష్యం మమాస్తే| ");
INSERT INTO santel_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","తదా శిష్యాః పరస్పరం ప్రష్టుమ్ ఆరమ్భన్త, కిమస్మై కోపి కిమపి భక్ష్యమానీయ దత్తవాన్? ");
INSERT INTO santel_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","యీశురవోచత్ మత్ప్రేరకస్యాభిమతానురూపకరణం తస్యైవ కర్మ్మసిద్ధికారణఞ్చ మమ భక్ష్యం| ");
INSERT INTO santel_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","మాసచతుష్టయే జాతే శస్యకర్త్తనసమయో భవిష్యతీతి వాక్యం యుష్మాభిః కిం నోద్యతే? కిన్త్వహం వదామి, శిర ఉత్తోల్య క్షేత్రాణి ప్రతి నిరీక్ష్య పశ్యత, ఇదానీం కర్త్తనయోగ్యాని శుక్లవర్ణాన్యభవన్| ");
INSERT INTO santel_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","యశ్ఛినత్తి స వేతనం లభతే అనన్తాయుఃస్వరూపం శస్యం స గృహ్లాతి చ, తేనైవ వప్తా ఛేత్తా చ యుగపద్ ఆనన్దతః| ");
INSERT INTO santel_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ఇత్థం సతి వపత్యేకశ్ఛినత్యన్య ఇతి వచనం సిద్ధ్యతి| ");
INSERT INTO santel_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","యత్ర యూయం న పర్య్యశ్రామ్యత తాదృశం శస్యం ఛేత్తుం యుష్మాన్ ప్రైరయమ్ అన్యే జనాఃపర్య్యశ్రామ్యన్ యూయం తేషాం శ్రగస్య ఫలమ్ అలభధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","యస్మిన్ కాలే యద్యత్ కర్మ్మాకార్షం తత్సర్వ్వం స మహ్యమ్ అకథయత్ తస్యా వనితాయా ఇదం సాక్ష్యవాక్యం శ్రుత్వా తన్నగరనివాసినో బహవః శోమిరోణీయలోకా వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","తథా చ తస్యాన్తికే సముపస్థాయ స్వేషాం సన్నిధౌ కతిచిద్ దినాని స్థాతుం తస్మిన్ వినయమ్ అకుర్వ్వాన తస్మాత్ స దినద్వయం తత్స్థానే న్యవష్టత్ ");
INSERT INTO santel_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","తతస్తస్యోపదేశేన బహవోఽపరే విశ్వస్య ");
INSERT INTO santel_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","తాం యోషామవదన్ కేవలం తవ వాక్యేన ప్రతీమ ఇతి న, కిన్తు స జగతోఽభిషిక్తస్త్రాతేతి తస్య కథాం శ్రుత్వా వయం స్వయమేవాజ్ఞాసమహి| ");
INSERT INTO santel_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","స్వదేశే భవిష్యద్వక్తుః సత్కారో నాస్తీతి యద్యపి యీశుః ప్రమాణం దత్వాకథయత్ ");
INSERT INTO santel_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","తథాపి దివసద్వయాత్ పరం స తస్మాత్ స్థానాద్ గాలీలం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","అనన్తరం యే గాలీలీ లియలోకా ఉత్సవే గతా ఉత్సవసమయే యిరూశలమ్ నగరే తస్య సర్వ్వాః క్రియా అపశ్యన్ తే గాలీలమ్ ఆగతం తమ్ ఆగృహ్లన్| ");
INSERT INTO santel_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","తతః పరమ్ యీశు ర్యస్మిన్ కాన్నానగరే జలం ద్రాక్షారసమ్ ఆకరోత్ తత్ స్థానం పునరగాత్| తస్మిన్నేవ సమయే కస్యచిద్ రాజసభాస్తారస్య పుత్రః కఫర్నాహూమపురీ రోగగ్రస్త ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","స యేహూదీయదేశాద్ యీశో ర్గాలీలాగమనవార్త్తాం నిశమ్య తస్య సమీపం గత్వా ప్రార్థ్య వ్యాహృతవాన్ మమ పుత్రస్య ప్రాయేణ కాల ఆసన్నః భవాన్ ఆగత్య తం స్వస్థం కరోతు| ");
INSERT INTO santel_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","తదా యీశురకథయద్ ఆశ్చర్య్యం కర్మ్మ చిత్రం చిహ్నం చ న దృష్టా యూయం న ప్రత్యేష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","తతః స సభాసదవదత్ హే మహేచ్ఛ మమ పుత్రే న మృతే భవానాగచ్ఛతు| ");
INSERT INTO santel_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","యీశుస్తమవదద్ గచ్ఛ తవ పుత్రోఽజీవీత్ తదా యీశునోక్తవాక్యే స విశ్వస్య గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","గమనకాలే మార్గమధ్యే దాసాస్తం సాక్షాత్ప్రాప్యావదన్ భవతః పుత్రోఽజీవీత్| ");
INSERT INTO santel_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","తతః కం కాలమారభ్య రోగప్రతీకారారమ్భో జాతా ఇతి పృష్టే తైరుక్తం హ్యః సార్ద్ధదణ్డద్వయాధికద్వితీయయామే తస్య జ్వరత్యాగోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","తదా యీశుస్తస్మిన్ క్షణే ప్రోక్తవాన్ తవ పుత్రోఽజీవీత్ పితా తద్బుద్ధ్వా సపరివారో వ్యశ్వసీత్| ");
INSERT INTO santel_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","యిహూదీయదేశాద్ ఆగత్య గాలీలి యీశురేతద్ ద్వితీయమ్ ఆశ్చర్య్యకర్మ్మాకరోత్| ");
INSERT INTO santel_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","తతః పరం యిహూదీయానామ్ ఉత్సవ ఉపస్థితే యీశు ర్యిరూశాలమం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","తస్మిన్నగరే మేషనామ్నో ద్వారస్య సమీపే ఇబ్రీయభాషయా బైథేస్దా నామ్నా పిష్కరిణీ పఞ్చఘట్టయుక్తాసీత్| ");
INSERT INTO santel_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","తస్యాస్తేషు ఘట్టేషు కిలాలకమ్పనమ్ అపేక్ష్య అన్ధఖఞ్చశుష్కాఙ్గాదయో బహవో రోగిణః పతన్తస్తిష్ఠన్తి స్మ| ");
INSERT INTO santel_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","యతో విశేషకాలే తస్య సరసో వారి స్వర్గీయదూత ఏత్యాకమ్పయత్ తత్కీలాలకమ్పనాత్ పరం యః కశ్చిద్ రోగీ ప్రథమం పానీయమవారోహత్ స ఏవ తత్క్షణాద్ రోగముక్తోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","తదాష్టాత్రింశద్వర్షాణి యావద్ రోగగ్రస్త ఏకజనస్తస్మిన్ స్థానే స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","యీశుస్తం శయితం దృష్ట్వా బహుకాలికరోగీతి జ్ఞాత్వా వ్యాహృతవాన్ త్వం కిం స్వస్థో బుభూషసి? ");
INSERT INTO santel_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","తతో రోగీ కథితవాన్ హే మహేచ్ఛ యదా కీలాలం కమ్పతే తదా మాం పుష్కరిణీమ్ అవరోహయితుం మమ కోపి నాస్తి, తస్మాన్ మమ గమనకాలే కశ్చిదన్యోఽగ్రో గత్వా అవరోహతి| ");
INSERT INTO santel_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","తదా యీశురకథయద్ ఉత్తిష్ఠ, తవ శయ్యాముత్తోల్య గృహీత్వా యాహి| ");
INSERT INTO santel_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","స తత్క్షణాత్ స్వస్థో భూత్వా శయ్యాముత్తోల్యాదాయ గతవాన్ కిన్తు తద్దినం విశ్రామవారః| ");
INSERT INTO santel_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","తస్మాద్ యిహూదీయాః స్వస్థం నరం వ్యాహరన్ అద్య విశ్రామవారే శయనీయమాదాయ న యాతవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","తతః స ప్రత్యవోచద్ యో మాం స్వస్థమ్ అకార్షీత్ శయనీయమ్ ఉత్తోల్యాదాయ యాతుం మాం స ఏవాదిశత్| ");
INSERT INTO santel_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","తదా తేఽపృచ్ఛన్ శయనీయమ్ ఉత్తోల్యాదాయ యాతుం య ఆజ్ఞాపయత్ స కః? ");
INSERT INTO santel_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","కిన్తు స క ఇతి స్వస్థీభూతో నాజానాద్ యతస్తస్మిన్ స్థానే జనతాసత్త్వాద్ యీశుః స్థానాన్తరమ్ ఆగమత్| ");
INSERT INTO santel_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","తతః పరం యేశు ర్మన్దిరే తం నరం సాక్షాత్ప్రాప్యాకథయత్ పశ్యేదానీమ్ అనామయో జాతోసి యథాధికా దుర్దశా న ఘటతే తద్ధేతోః పాపం కర్మ్మ పునర్మాకార్షీః| ");
INSERT INTO santel_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","తతః స గత్వా యిహూదీయాన్ అవదద్ యీశు ర్మామ్ అరోగిణమ్ అకార్షీత్| ");
INSERT INTO santel_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","తతో యీశు ర్విశ్రామవారే కర్మ్మేదృశం కృతవాన్ ఇతి హేతో ర్యిహూదీయాస్తం తాడయిత్వా హన్తుమ్ అచేష్టన్త| ");
INSERT INTO santel_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","యీశుస్తానాఖ్యత్ మమ పితా యత్ కార్య్యం కరోతి తదనురూపమ్ అహమపి కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","తతో యిహూదీయాస్తం హన్తుం పునరయతన్త యతో విశ్రామవారం నామన్యత తదేవ కేవలం న అధికన్తు ఈశ్వరం స్వపితరం ప్రోచ్య స్వమపీశ్వరతుల్యం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","పశ్చాద్ యీశురవదద్ యుష్మానహం యథార్థతరం వదామి పుత్రః పితరం యద్యత్ కర్మ్మ కుర్వ్వన్తం పశ్యతి తదతిరిక్తం స్వేచ్ఛాతః కిమపి కర్మ్మ కర్త్తుం న శక్నోతి| పితా యత్ కరోతి పుత్రోపి తదేవ కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","పితా పుత్రే స్నేహం కరోతి తస్మాత్ స్వయం యద్యత్ కర్మ్మ కరోతి తత్సర్వ్వం పుత్రం దర్శయతి ; యథా చ యుష్మాకం ఆశ్చర్య్యజ్ఞానం జనిష్యతే తదర్థమ్ ఇతోపి మహాకర్మ్మ తం దర్శయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","వస్తుతస్తు పితా యథా ప్రమితాన్ ఉత్థాప్య సజివాన్ కరోతి తద్వత్ పుత్రోపి యం యం ఇచ్ఛతి తం తం సజీవం కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","సర్వ్వే పితరం యథా సత్కుర్వ్వన్తి తథా పుత్రమపి సత్కారయితుం పితా స్వయం కస్యాపి విచారమకృత్వా సర్వ్వవిచారాణాం భారం పుత్రే సమర్పితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","యః పుత్రం సత్ కరోతి స తస్య ప్రేరకమపి సత్ కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","యుష్మానాహం యథార్థతరం వదామి యో జనో మమ వాక్యం శ్రుత్వా మత్ప్రేరకే విశ్వసితి సోనన్తాయుః ప్రాప్నోతి కదాపి దణ్డబాజనం న భవతి నిధనాదుత్థాయ పరమాయుః ప్రాప్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","అహం యుష్మానతియథార్థం వదామి యదా మృతా ఈశ్వరపుత్రస్య నినాదం శ్రోష్యన్తి యే చ శ్రోష్యన్తి తే సజీవా భవిష్యన్తి సమయ ఏతాదృశ ఆయాతి వరమ్ ఇదానీమప్యుపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","పితా యథా స్వయఞ్జీవీ తథా పుత్రాయ స్వయఞ్జీవిత్వాధికారం దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","స మనుష్యపుత్రః ఏతస్మాత్ కారణాత్ పితా దణ్డకరణాధికారమపి తస్మిన్ సమర్పితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ఏతదర్థే యూయమ్ ఆశ్చర్య్యం న మన్యధ్వం యతో యస్మిన్ సమయే తస్య నినాదం శ్రుత్వా శ్మశానస్థాః సర్వ్వే బహిరాగమిష్యన్తి సమయ ఏతాదృశ ఉపస్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","తస్మాద్ యే సత్కర్మ్మాణి కృతవన్తస్త ఉత్థాయ ఆయుః ప్రాప్స్యన్తి యే చ కుకర్మాణి కృతవన్తస్త ఉత్థాయ దణ్డం ప్రాప్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","అహం స్వయం కిమపి కర్త్తుం న శక్నోమి యథా శుణోమి తథా విచారయామి మమ విచారఞ్చ న్యాయ్యః యతోహం స్వీయాభీష్టం నేహిత్వా మత్ప్రేరయితుః పితురిష్టమ్ ఈహే| ");
INSERT INTO santel_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","యది స్వస్మిన్ స్వయం సాక్ష్యం దదామి తర్హి తత్సాక్ష్యమ్ ఆగ్రాహ్యం భవతి ; ");
INSERT INTO santel_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","కిన్తు మదర్థేఽపరో జనః సాక్ష్యం దదాతి మదర్థే తస్య యత్ సాక్ష్యం తత్ సత్యమ్ ఏతదప్యహం జానామి| ");
INSERT INTO santel_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","యుష్మాభి ర్యోహనం ప్రతి లోకేషు ప్రేరితేషు స సత్యకథాయాం సాక్ష్యమదదాత్| ");
INSERT INTO santel_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","మానుషాదహం సాక్ష్యం నోపేక్షే తథాపి యూయం యథా పరిత్రయధ్వే తదర్థమ్ ఇదం వాక్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","యోహన్ దేదీప్యమానో దీప ఇవ తేజస్వీ స్థితవాన్ యూయమ్ అల్పకాలం తస్య దీప్త్యానన్దితుం సమమన్యధ్వం| ");
INSERT INTO santel_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","కిన్తు తత్ప్రమాణాదపి మమ గురుతరం ప్రమాణం విద్యతే పితా మాం ప్రేష్య యద్యత్ కర్మ్మ సమాపయితుం శక్త్తిమదదాత్ మయా కృతం తత్తత్ కర్మ్మ మదర్థే ప్రమాణం దదాతి| ");
INSERT INTO santel_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","యః పితా మాం ప్రేరితవాన్ మోపి మదర్థే ప్రమాణం దదాతి| తస్య వాక్యం యుష్మాభిః కదాపి న శ్రుతం తస్య రూపఞ్చ న దృష్టం ");
INSERT INTO santel_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","తస్య వాక్యఞ్చ యుష్మాకమ్ అన్తః కదాపి స్థానం నాప్నోతి యతః స యం ప్రేషితవాన్ యూయం తస్మిన్ న విశ్వసిథ| ");
INSERT INTO santel_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ధర్మ్మపుస్తకాని యూయమ్ ఆలోచయధ్వం తై ర్వాక్యైరనన్తాయుః ప్రాప్స్యామ ఇతి యూయం బుధ్యధ్వే తద్ధర్మ్మపుస్తకాని మదర్థే ప్రమాణం దదతి| ");
INSERT INTO santel_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","తథాపి యూయం పరమాయుఃప్రాప్తయే మమ సంనిధిమ్ న జిగమిషథ| ");
INSERT INTO santel_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","అహం మానుషేభ్యః సత్కారం న గృహ్లామి| ");
INSERT INTO santel_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","అహం యుష్మాన్ జానామి; యుష్మాకమన్తర ఈశ్వరప్రేమ నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","అహం నిజపితు ర్నామ్నాగతోస్మి తథాపి మాం న గృహ్లీథ కిన్తు కశ్చిద్ యది స్వనామ్నా సమాగమిష్యతి తర్హి తం గ్రహీష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","యూయమ్ ఈశ్వరాత్ సత్కారం న చిష్టత్వా కేవలం పరస్పరం సత్కారమ్ చేద్ ఆదధ్వ్వే తర్హి కథం విశ్వసితుం శక్నుథ? ");
INSERT INTO santel_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","పుతుః సమీపేఽహం యుష్మాన్ అపవదిష్యామీతి మా చిన్తయత యస్మిన్ , యస్మిన్ యుష్మాకం విశ్వసః సఏవ మూసా యుష్మాన్ అపవదతి| ");
INSERT INTO santel_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","యది యూయం తస్మిన్ వ్యశ్వసిష్యత తర్హి మయ్యపి వ్యశ్వసిష్యత, యత్ స మయి లిఖితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","తతో యది తేన లిఖితవాని న ప్రతిథ తర్హి మమ వాక్యాని కథం ప్రత్యేష్యథ? ");
INSERT INTO santel_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","తతః పరం యీశు ర్గాలీల్ ప్రదేశీయస్య తివిరియానామ్నః సిన్ధోః పారం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","తతో వ్యాధిమల్లోకస్వాస్థ్యకరణరూపాణి తస్యాశ్చర్య్యాణి కర్మ్మాణి దృష్ట్వా బహవో జనాస్తత్పశ్చాద్ అగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","తతో యీశుః పర్వ్వతమారుహ్య తత్ర శిష్యైః సాకమ్| ");
INSERT INTO santel_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","తస్మిన్ సమయ నిస్తారోత్సవనామ్ని యిహూదీయానామ ఉత్సవ ఉపస్థితే ");
INSERT INTO santel_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","యీశు ర్నేత్రే ఉత్తోల్య బహులోకాన్ స్వసమీపాగతాన్ విలోక్య ఫిలిపం పృష్టవాన్ ఏతేషాం భోజనాయ భోజద్రవ్యాణి వయం కుత్ర క్రేతుం శక్రుమః? ");
INSERT INTO santel_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","వాక్యమిదం తస్య పరీక్షార్థమ్ అవాదీత్ కిన్తు యత్ కరిష్యతి తత్ స్వయమ్ అజానాత్| ");
INSERT INTO santel_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ఫిలిపః ప్రత్యవోచత్ ఏతేషామ్ ఏకైకో యద్యల్పమ్ అల్పం ప్రాప్నోతి తర్హి ముద్రాపాదద్విశతేన క్రీతపూపా అపి న్యూనా భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","శిమోన్ పితరస్య భ్రాతా ఆన్ద్రియాఖ్యః శిష్యాణామేకో వ్యాహృతవాన్ ");
INSERT INTO santel_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","అత్ర కస్యచిద్ బాలకస్య సమీపే పఞ్చ యావపూపాః క్షుద్రమత్స్యద్వయఞ్చ సన్తి కిన్తు లోకానాం ఏతావాతాం మధ్యే తైః కిం భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","పశ్చాద్ యీశురవదత్ లోకానుపవేశయత తత్ర బహుయవససత్త్వాత్ పఞ్చసహస్త్రేభ్యో న్యూనా అధికా వా పురుషా భూమ్యామ్ ఉపావిశన్| ");
INSERT INTO santel_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","తతో యీశుస్తాన్ పూపానాదాయ ఈశ్వరస్య గుణాన్ కీర్త్తయిత్వా శిష్యేషు సమార్పయత్ తతస్తే తేభ్య ఉపవిష్టలోకేభ్యః పూపాన్ యథేష్టమత్స్యఞ్చ ప్రాదుః| ");
INSERT INTO santel_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","తేషు తృప్తేషు స తానవోచద్ ఏతేషాం కిఞ్చిదపి యథా నాపచీయతే తథా సర్వ్వాణ్యవశిష్టాని సంగృహ్లీత| ");
INSERT INTO santel_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","తతః సర్వ్వేషాం భోజనాత్ పరం తే తేషాం పఞ్చానాం యావపూపానాం అవశిష్టాన్యఖిలాని సంగృహ్య ద్వాదశడల్లకాన్ అపూరయన్| ");
INSERT INTO santel_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","అపరం యీశోరేతాదృశీమ్ ఆశ్చర్య్యక్రియాం దృష్ట్వా లోకా మిథో వక్తుమారేభిరే జగతి యస్యాగమనం భవిష్యతి స ఏవాయమ్ అవశ్యం భవిష్యద్వక్త్తా| ");
INSERT INTO santel_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","అతఏవ లోకా ఆగత్య తమాక్రమ్య రాజానం కరిష్యన్తి యీశుస్తేషామ్ ఈదృశం మానసం విజ్ఞాయ పునశ్చ పర్వ్వతమ్ ఏకాకీ గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","సాయంకాల ఉపస్థితే శిష్యా జలధితటం వ్రజిత్వా నావమారుహ్య నగరదిశి సిన్ధౌ వాహయిత్వాగమన్| ");
INSERT INTO santel_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","తస్మిన్ సమయే తిమిర ఉపాతిష్ఠత్ కిన్తు యీషుస్తేషాం సమీపం నాగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","తదా ప్రబలపవనవహనాత్ సాగరే మహాతరఙ్గో భవితుమ్ ఆరేభే| ");
INSERT INTO santel_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","తతస్తే వాహయిత్వా ద్విత్రాన్ క్రోశాన్ గతాః పశ్చాద్ యీశుం జలధేరుపరి పద్భ్యాం వ్రజన్తం నౌకాన్తికమ్ ఆగచ్ఛన్తం విలోక్య త్రాసయుక్తా అభవన్ ");
INSERT INTO santel_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","కిన్తు స తానుక్త్తవాన్ అయమహం మా భైష్ట| ");
INSERT INTO santel_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","తదా తే తం స్వైరం నావి గృహీతవన్తః తదా తత్క్షణాద్ ఉద్దిష్టస్థానే నౌరుపాస్థాత్| ");
INSERT INTO santel_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","యయా నావా శిష్యా అగచ్ఛన్ తదన్యా కాపి నౌకా తస్మిన్ స్థానే నాసీత్ తతో యీశుః శిష్యైః సాకం నాగమత్ కేవలాః శిష్యా అగమన్ ఏతత్ పారస్థా లోకా జ్ఞాతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","కిన్తు తతః పరం ప్రభు ర్యత్ర ఈశ్వరస్య గుణాన్ అనుకీర్త్త్య లోకాన్ పూపాన్ అభోజయత్ తత్స్థానస్య సమీపస్థతివిరియాయా అపరాస్తరణయ ఆగమన్| ");
INSERT INTO santel_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","యీశుస్తత్ర నాస్తి శిష్యా అపి తత్ర నా సన్తి లోకా ఇతి విజ్ఞాయ యీశుం గవేషయితుం తరణిభిః కఫర్నాహూమ్ పురం గతాః| ");
INSERT INTO santel_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","తతస్తే సరిత్పతేః పారే తం సాక్షాత్ ప్రాప్య ప్రావోచన్ హే గురో భవాన్ అత్ర స్థానే కదాగమత్? ");
INSERT INTO santel_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","తదా యీశుస్తాన్ ప్రత్యవాదీద్ యుష్మానహం యథార్థతరం వదామి ఆశ్చర్య్యకర్మ్మదర్శనాద్ధేతో ర్న కిన్తు పూపభోజనాత్ తేన తృప్తత్వాఞ్చ మాం గవేషయథ| ");
INSERT INTO santel_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","క్షయణీయభక్ష్యార్థం మా శ్రామిష్ట కిన్త్వన్తాయుర్భక్ష్యార్థం శ్రామ్యత, తస్మాత్ తాదృశం భక్ష్యం మనుజపుత్రో యుష్మాభ్యం దాస్యతి; తస్మిన్ తాత ఈశ్వరః ప్రమాణం ప్రాదాత్| ");
INSERT INTO santel_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","తదా తేఽపృచ్ఛన్ ఈశ్వరాభిమతం కర్మ్మ కర్త్తుమ్ అస్మాభిః కిం కర్త్తవ్యం? ");
INSERT INTO santel_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","తతో యీశురవదద్ ఈశ్వరో యం ప్రైరయత్ తస్మిన్ విశ్వసనమ్ ఈశ్వరాభిమతం కర్మ్మ| ");
INSERT INTO santel_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","తదా తే వ్యాహరన్ భవతా కిం లక్షణం దర్శితం యద్దృష్ట్వా భవతి విశ్వసిష్యామః? త్వయా కిం కర్మ్మ కృతం? ");
INSERT INTO santel_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","అస్మాకం పూర్వ్వపురుషా మహాప్రాన్తరే మాన్నాం భోక్త్తుం ప్రాపుః యథా లిపిరాస్తే| స్వర్గీయాణి తు భక్ష్యాణి ప్రదదౌ పరమేశ్వరః| ");
INSERT INTO santel_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","తదా యీశురవదద్ అహం యుష్మానతియథార్థం వదామి మూసా యుష్మాభ్యం స్వర్గీయం భక్ష్యం నాదాత్ కిన్తు మమ పితా యుష్మాభ్యం స్వర్గీయం పరమం భక్ష్యం దదాతి| ");
INSERT INTO santel_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","యః స్వర్గాదవరుహ్య జగతే జీవనం దదాతి స ఈశ్వరదత్తభక్ష్యరూపః| ");
INSERT INTO santel_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","తదా తే ప్రావోచన్ హే ప్రభో భక్ష్యమిదం నిత్యమస్మభ్యం దదాతు| ");
INSERT INTO santel_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","యీశురవదద్ అహమేవ జీవనరూపం భక్ష్యం యో జనో మమ సన్నిధిమ్ ఆగచ్ఛతి స జాతు క్షుధార్త్తో న భవిష్యతి, తథా యో జనో మాం ప్రత్యేతి స జాతు తృషార్త్తో న భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","మాం దృష్ట్వాపి యూయం న విశ్వసిథ యుష్మానహమ్ ఇత్యవోచం| ");
INSERT INTO santel_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","పితా మహ్యం యావతో లోకానదదాత్ తే సర్వ్వ ఏవ మమాన్తికమ్ ఆగమిష్యన్తి యః కశ్చిచ్చ మమ సన్నిధిమ్ ఆయాస్యతి తం కేనాపి ప్రకారేణ న దూరీకరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","నిజాభిమతం సాధయితుం న హి కిన్తు ప్రేరయితురభిమతం సాధయితుం స్వర్గాద్ ఆగతోస్మి| ");
INSERT INTO santel_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","స యాన్ యాన్ లోకాన్ మహ్యమదదాత్ తేషామేకమపి న హారయిత్వా శేషదినే సర్వ్వానహమ్ ఉత్థాపయామి ఇదం మత్ప్రేరయితుః పితురభిమతం| ");
INSERT INTO santel_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","యః కశ్చిన్ మానవసుతం విలోక్య విశ్వసితి స శేషదినే మయోత్థాపితః సన్ అనన్తాయుః ప్రాప్స్యతి ఇతి మత్ప్రేరకస్యాభిమతం| ");
INSERT INTO santel_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","తదా స్వర్గాద్ యద్ భక్ష్యమ్ అవారోహత్ తద్ భక్ష్యమ్ అహమేవ యిహూదీయలోకాస్తస్యైతద్ వాక్యే వివదమానా వక్త్తుమారేభిరే ");
INSERT INTO santel_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","యూషఫః పుత్రో యీశు ర్యస్య మాతాపితరౌ వయం జానీమ ఏష కిం సఏవ న? తర్హి స్వర్గాద్ అవారోహమ్ ఇతి వాక్యం కథం వక్త్తి? ");
INSERT INTO santel_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","తదా యీశుస్తాన్ ప్రత్యవదత్ పరస్పరం మా వివదధ్వం ");
INSERT INTO santel_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","మత్ప్రేరకేణ పిత్రా నాకృష్టః కోపి జనో మమాన్తికమ్ ఆయాతుం న శక్నోతి కిన్త్వాగతం జనం చరమేఽహ్ని ప్రోత్థాపయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","తే సర్వ్వ ఈశ్వరేణ శిక్షితా భవిష్యన్తి భవిష్యద్వాదినాం గ్రన్థేషు లిపిరిత్థమాస్తే అతో యః కశ్చిత్ పితుః సకాశాత్ శ్రుత్వా శిక్షతే స ఏవ మమ సమీపమ్ ఆగమిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","య ఈశ్వరాద్ అజాయత తం వినా కోపి మనుష్యో జనకం నాదర్శత్ కేవలః సఏవ తాతమ్ అద్రాక్షీత్| ");
INSERT INTO santel_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","అహం యుష్మాన్ యథార్థతరం వదామి యో జనో మయి విశ్వాసం కరోతి సోనన్తాయుః ప్రాప్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","అహమేవ తజ్జీవనభక్ష్యం| ");
INSERT INTO santel_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","యుష్మాకం పూర్వ్వపురుషా మహాప్రాన్తరే మన్నాభక్ష్యం భూక్త్తాపి మృతాః ");
INSERT INTO santel_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","కిన్తు యద్భక్ష్యం స్వర్గాదాగచ్ఛత్ తద్ యది కశ్చిద్ భుఙ్క్త్తే తర్హి స న మ్రియతే| ");
INSERT INTO santel_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","యజ్జీవనభక్ష్యం స్వర్గాదాగచ్ఛత్ సోహమేవ ఇదం భక్ష్యం యో జనో భుఙ్క్త్తే స నిత్యజీవీ భవిష్యతి| పునశ్చ జగతో జీవనార్థమహం యత్ స్వకీయపిశితం దాస్యామి తదేవ మయా వితరితం భక్ష్యమ్| ");
INSERT INTO santel_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","తస్మాద్ యిహూదీయాః పరస్పరం వివదమానా వక్త్తుమారేభిరే ఏష భోజనార్థం స్వీయం పలలం కథమ్ అస్మభ్యం దాస్యతి? ");
INSERT INTO santel_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","తదా యీశుస్తాన్ ఆవోచద్ యుష్మానహం యథార్థతరం వదామి మనుష్యపుత్రస్యామిషే యుష్మాభి ర్న భుక్త్తే తస్య రుధిరే చ న పీతే జీవనేన సార్ద్ధం యుష్మాకం సమ్బన్ధో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","యో మమామిషం స్వాదతి మమ సుధిరఞ్చ పివతి సోనన్తాయుః ప్రాప్నోతి తతః శేషేఽహ్ని తమహమ్ ఉత్థాపయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","యతో మదీయమామిషం పరమం భక్ష్యం తథా మదీయం శోణితం పరమం పేయం| ");
INSERT INTO santel_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","యో జనో మదీయం పలలం స్వాదతి మదీయం రుధిరఞ్చ పివతి స మయి వసతి తస్మిన్నహఞ్చ వసామి| ");
INSERT INTO santel_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","మత్ప్రేరయిత్రా జీవతా తాతేన యథాహం జీవామి తద్వద్ యః కశ్చిన్ మామత్తి సోపి మయా జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","యద్భక్ష్యం స్వర్గాదాగచ్ఛత్ తదిదం యన్మాన్నాం స్వాదిత్వా యుష్మాకం పితరోఽమ్రియన్త తాదృశమ్ ఇదం భక్ష్యం న భవతి ఇదం భక్ష్యం యో భక్షతి స నిత్యం జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","యదా కఫర్నాహూమ్ పుర్య్యాం భజనగేహే ఉపాదిశత్ తదా కథా ఏతా అకథయత్| ");
INSERT INTO santel_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","తదేత్థం శ్రుత్వా తస్య శిష్యాణామ్ అనేకే పరస్పరమ్ అకథయన్ ఇదం గాఢం వాక్యం వాక్యమీదృశం కః శ్రోతుం శక్రుయాత్? ");
INSERT INTO santel_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","కిన్తు యీశుః శిష్యాణామ్ ఇత్థం వివాదం స్వచిత్తే విజ్ఞాయ కథితవాన్ ఇదం వాక్యం కిం యుష్మాకం విఘ్నం జనయతి? ");
INSERT INTO santel_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","యది మనుజసుతం పూర్వ్వవాసస్థానమ్ ఊర్ద్వ్వం గచ్ఛన్తం పశ్యథ తర్హి కిం భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ఆత్మైవ జీవనదాయకః వపు ర్నిష్ఫలం యుష్మభ్యమహం యాని వచాంసి కథయామి తాన్యాత్మా జీవనఞ్చ| ");
INSERT INTO santel_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","కిన్తు యుష్మాకం మధ్యే కేచన అవిశ్వాసినః సన్తి కే కే న విశ్వసన్తి కో వా తం పరకరేషు సమర్పయిష్యతి తాన్ యీశురాప్రథమాద్ వేత్తి| ");
INSERT INTO santel_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","అపరమపి కథితవాన్ అస్మాత్ కారణాద్ అకథయం పితుః సకాశాత్ శక్త్తిమప్రాప్య కోపి మమాన్తికమ్ ఆగన్తుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","తత్కాలేఽనేకే శిష్యా వ్యాఘుట్య తేన సార్ద్ధం పున ర్నాగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","తదా యీశు ర్ద్వాదశశిష్యాన్ ఉక్త్తవాన్ యూయమపి కిం యాస్యథ? ");
INSERT INTO santel_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","తతః శిమోన్ పితరః ప్రత్యవోచత్ హే ప్రభో కస్యాభ్యర్ణం గమిష్యామః? ");
INSERT INTO santel_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","అనన్తజీవనదాయిన్యో యాః కథాస్తాస్తవైవ| భవాన్ అమరేశ్వరస్యాభిషిక్త్తపుత్ర ఇతి విశ్వస్య నిశ్చితం జానీమః| ");
INSERT INTO santel_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","తదా యీశురవదత్ కిమహం యుష్మాకం ద్వాదశజనాన్ మనోనీతాన్ న కృతవాన్? కిన్తు యుష్మాకం మధ్యేపి కశ్చిదేకో విఘ్నకారీ విద్యతే| ");
INSERT INTO santel_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ఇమాం కథం స శిమోనః పుత్రమ్ ఈష్కరీయోతీయం యిహూదామ్ ఉద్దిశ్య కథితవాన్ యతో ద్వాదశానాం మధ్యే గణితః స తం పరకరేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","తతః పరం యిహూదీయలోకాస్తం హన్తుం సమైహన్త తస్మాద్ యీశు ర్యిహూదాప్రదేశే పర్య్యటితుం నేచ్ఛన్ గాలీల్ ప్రదేశే పర్య్యటితుం ప్రారభత| ");
INSERT INTO santel_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","కిన్తు తస్మిన్ సమయే యిహూదీయానాం దూష్యవాసనామోత్సవ ఉపస్థితే ");
INSERT INTO santel_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","తస్య భ్రాతరస్తమ్ అవదన్ యాని కర్మ్మాణి త్వయా క్రియన్తే తాని యథా తవ శిష్యాః పశ్యన్తి తదర్థం త్వమితః స్థానాద్ యిహూదీయదేశం వ్రజ| ");
INSERT INTO santel_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","యః కశ్చిత్ స్వయం ప్రచికాశిషతి స కదాపి గుప్తం కర్మ్మ న కరోతి యదీదృశం కర్మ్మ కరోషి తర్హి జగతి నిజం పరిచాయయ| ");
INSERT INTO santel_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","యతస్తస్య భ్రాతరోపి తం న విశ్వసన్తి| ");
INSERT INTO santel_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","తదా యీశుస్తాన్ అవోచత్ మమ సమయ ఇదానీం నోపతిష్ఠతి కిన్తు యుష్మాకం సమయః సతతమ్ ఉపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","జగతో లోకా యుష్మాన్ ఋతీయితుం న శక్రువన్తి కిన్తు మామేవ ఋతీయన్తే యతస్తేషాం కర్మాణి దుష్టాని తత్ర సాక్ష్యమిదమ్ అహం దదామి| ");
INSERT INTO santel_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","అతఏవ యూయమ్ ఉత్సవేఽస్మిన్ యాత నాహమ్ ఇదానీమ్ అస్మిన్నుత్సవే యామి యతో మమ సమయ ఇదానీం న సమ్పూర్ణః| ");
INSERT INTO santel_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ఇతి వాక్యమ్ ఉక్త్త్వా స గాలీలి స్థితవాన్ ");
INSERT INTO santel_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","కిన్తు తస్య భ్రాతృషు తత్ర ప్రస్థితేషు సత్సు సోఽప్రకట ఉత్సవమ్ అగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","అనన్తరమ్ ఉత్సవమ్ ఉపస్థితా యిహూదీయాస్తం మృగయిత్వాపృచ్ఛన్ స కుత్ర? ");
INSERT INTO santel_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","తతో లోకానాం మధ్యే తస్మిన్ నానావిధా వివాదా భవితుమ్ ఆరబ్ధవన్తః| కేచిద్ అవోచన్ స ఉత్తమః పురుషః కేచిద్ అవోచన్ న తథా వరం లోకానాం భ్రమం జనయతి| ");
INSERT INTO santel_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","కిన్తు యిహూదీయానాం భయాత్ కోపి తస్య పక్షే స్పష్టం నాకథయత్| ");
INSERT INTO santel_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","తతః పరమ్ ఉత్సవస్య మధ్యసమయే యీశు ర్మన్దిరం గత్వా సముపదిశతి స్మ| ");
INSERT INTO santel_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","తతో యిహూదీయా లోకా ఆశ్చర్య్యం జ్ఞాత్వాకథయన్ ఏషా మానుషో నాధీత్యా కథమ్ ఏతాదృశో విద్వానభూత్? ");
INSERT INTO santel_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","తదా యీశుః ప్రత్యవోచద్ ఉపదేశోయం న మమ కిన్తు యో మాం ప్రేషితవాన్ తస్య| ");
INSERT INTO santel_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","యో జనో నిదేశం తస్య గ్రహీష్యతి మమోపదేశో మత్తో భవతి కిమ్ ఈశ్వరాద్ భవతి స గనస్తజ్జ్ఞాతుం శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","యో జనః స్వతః కథయతి స స్వీయం గౌరవమ్ ఈహతే కిన్తు యః ప్రేరయితు ర్గౌరవమ్ ఈహతే స సత్యవాదీ తస్మిన్ కోప్యధర్మ్మో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","మూసా యుష్మభ్యం వ్యవస్థాగ్రన్థం కిం నాదదాత్? కిన్తు యుష్మాకం కోపి తాం వ్యవస్థాం న సమాచరతి| మాం హన్తుం కుతో యతధ్వే? ");
INSERT INTO santel_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","తదా లోకా అవదన్ త్వం భూతగ్రస్తస్త్వాం హన్తుం కో యతతే? ");
INSERT INTO santel_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","తతో యీశురవోచద్ ఏకం కర్మ్మ మయాకారి తస్మాద్ యూయం సర్వ్వ మహాశ్చర్య్యం మన్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","మూసా యుష్మభ్యం త్వక్ఛేదవిధిం ప్రదదౌ స మూసాతో న జాతః కిన్తు పితృపురుషేభ్యో జాతః తేన విశ్రామవారేఽపి మానుషాణాం త్వక్ఛేదం కురుథ| ");
INSERT INTO santel_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","అతఏవ విశ్రామవారే మనుష్యాణాం త్వక్ఛేదే కృతే యది మూసావ్యవస్థామఙ్గనం న భవతి తర్హి మయా విశ్రామవారే మానుషః సమ్పూర్ణరూపేణ స్వస్థోఽకారి తత్కారణాద్ యూయం కిం మహ్యం కుప్యథ? ");
INSERT INTO santel_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","సపక్షపాతం విచారమకృత్వా న్యాయ్యం విచారం కురుత| ");
INSERT INTO santel_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","తదా యిరూశాలమ్ నివాసినః కతిపయజనా అకథయన్ ఇమే యం హన్తుం చేష్టన్తే స ఏవాయం కిం న? ");
INSERT INTO santel_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","కిన్తు పశ్యత నిర్భయః సన్ కథాం కథయతి తథాపి కిమపి అ వదన్త్యేతే అయమేవాభిషిక్త్తో భవతీతి నిశ్చితం కిమధిపతయో జానన్తి? ");
INSERT INTO santel_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","మనుజోయం కస్మాదాగమద్ ఇతి వయం జానోమః కిన్త్వభిషిక్త్త ఆగతే స కస్మాదాగతవాన్ ఇతి కోపి జ్ఞాతుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","తదా యీశు ర్మధ్యేమన్దిరమ్ ఉపదిశన్ ఉచ్చైఃకారమ్ ఉక్త్తవాన్ యూయం కిం మాం జానీథ? కస్మాచ్చాగతోస్మి తదపి కిం జానీథ? నాహం స్వత ఆగతోస్మి కిన్తు యః సత్యవాదీ సఏవ మాం ప్రేషితవాన్ యూయం తం న జానీథ| ");
INSERT INTO santel_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","తమహం జానే తేనాహం ప్రేరిత అగతోస్మి| ");
INSERT INTO santel_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","తస్మాద్ యిహూదీయాస్తం ధర్త్తుమ్ ఉద్యతాస్తథాపి కోపి తస్య గాత్రే హస్తం నార్పయద్ యతో హేతోస్తదా తస్య సమయో నోపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","కిన్తు బహవో లోకాస్తస్మిన్ విశ్వస్య కథితవాన్తోఽభిషిక్త్తపురుష ఆగత్య మానుషస్యాస్య క్రియాభ్యః కిమ్ అధికా ఆశ్చర్య్యాః క్రియాః కరిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","తతః పరం లోకాస్తస్మిన్ ఇత్థం వివదన్తే ఫిరూశినః ప్రధానయాజకాఞ్చేతి శ్రుతవన్తస్తం ధృత్వా నేతుం పదాతిగణం ప్రేషయామాసుః| ");
INSERT INTO santel_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","తతో యీశురవదద్ అహమ్ అల్పదినాని యుష్మాభిః సార్ద్ధం స్థిత్వా మత్ప్రేరయితుః సమీపం యాస్యామి| ");
INSERT INTO santel_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","మాం మృగయిష్యధ్వే కిన్తూద్దేశం న లప్స్యధ్వే రత్ర స్థాస్యామి తత్ర యూయం గన్తుం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","తదా యిహూదీయాః పరస్పరం వక్త్తుమారేభిరే అస్యోద్దేశం న ప్రాప్స్యామ ఏతాదృశం కిం స్థానం యాస్యతి? భిన్నదేశే వికీర్ణానాం యిహూదీయానాం సన్నిధిమ్ ఏష గత్వా తాన్ ఉపదేక్ష్యతి కిం? ");
INSERT INTO santel_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","నో చేత్ మాం గవేషయిష్యథ కిన్తూద్దేశం న ప్రాప్స్యథ ఏష కోదృశం వాక్యమిదం వదతి? ");
INSERT INTO santel_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","అనన్తరమ్ ఉత్సవస్య చరమేఽహని అర్థాత్ ప్రధానదినే యీశురుత్తిష్ఠన్ ఉచ్చైఃకారమ్ ఆహ్వయన్ ఉదితవాన్ యది కశ్చిత్ తృషార్త్తో భవతి తర్హి మమాన్తికమ్ ఆగత్య పివతు| ");
INSERT INTO santel_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","యః కశ్చిన్మయి విశ్వసితి ధర్మ్మగ్రన్థస్య వచనానుసారేణ తస్యాభ్యన్తరతోఽమృతతోయస్య స్రోతాంసి నిర్గమిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","యే తస్మిన్ విశ్వసన్తి త ఆత్మానం ప్రాప్స్యన్తీత్యర్థే స ఇదం వాక్యం వ్యాహృతవాన్ ఏతత్కాలం యావద్ యీశు ర్విభవం న ప్రాప్తస్తస్మాత్ పవిత్ర ఆత్మా నాదీయత| ");
INSERT INTO santel_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ఏతాం వాణీం శ్రుత్వా బహవో లోకా అవదన్ అయమేవ నిశ్చితం స భవిష్యద్వాదీ| ");
INSERT INTO santel_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","కేచిద్ అకథయన్ ఏషఏవ సోభిషిక్త్తః కిన్తు కేచిద్ అవదన్ సోభిషిక్త్తః కిం గాలీల్ ప్రదేశే జనిష్యతే? ");
INSERT INTO santel_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","సోభిషిక్త్తో దాయూదో వంశే దాయూదో జన్మస్థానే బైత్లేహమి పత్తనే జనిష్యతే ధర్మ్మగ్రన్థే కిమిత్థం లిఖితం నాస్తి? ");
INSERT INTO santel_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ఇత్థం తస్మిన్ లోకానాం భిన్నవాక్యతా జాతా| ");
INSERT INTO santel_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","కతిపయలోకాస్తం ధర్త్తుమ్ ఐచ్ఛన్ తథాపి తద్వపుషి కోపి హస్తం నార్పయత్| ");
INSERT INTO santel_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","అనన్తరం పాదాతిగణే ప్రధానయాజకానాం ఫిరూశినాఞ్చ సమీపమాగతవతి తే తాన్ అపృచ్ఛన్ కుతో హేతోస్తం నానయత? ");
INSERT INTO santel_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","తదా పదాతయః ప్రత్యవదన్ స మానవ ఇవ కోపి కదాపి నోపాదిశత్| ");
INSERT INTO santel_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","తతః ఫిరూశినః ప్రావోచన్ యూయమపి కిమభ్రామిష్ట? ");
INSERT INTO santel_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","అధిపతీనాం ఫిరూశినాఞ్చ కోపి కిం తస్మిన్ వ్యశ్వసీత్? ");
INSERT INTO santel_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","యే శాస్త్రం న జానన్తి త ఇమేఽధమలోకాఏవ శాపగ్రస్తాః| ");
INSERT INTO santel_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","తదా నికదీమనామా తేషామేకో యః క్షణదాయాం యీశోః సన్నిధిమ్ అగాత్ స ఉక్త్తవాన్ ");
INSERT INTO santel_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","తస్య వాక్యే న శ్రుతే కర్మ్మణి చ న విదితే ఽస్మాకం వ్యవస్థా కిం కఞ్చన మనుజం దోషీకరోతి? ");
INSERT INTO santel_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","తతస్తే వ్యాహరన్ త్వమపి కిం గాలీలీయలోకః? వివిచ్య పశ్య గలీలి కోపి భవిష్యద్వాదీ నోత్పద్యతే| ");
INSERT INTO santel_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","తతః పరం సర్వ్వే స్వం స్వం గృహం గతాః కిన్తు యీశు ర్జైతుననామానం శిలోచ్చయం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ప్రత్యూషే యీశుః పనర్మన్దిరమ్ ఆగచ్ఛత్ ");
INSERT INTO santel_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","తతః సర్వ్వేషు లోకేషు తస్య సమీప ఆగతేషు స ఉపవిశ్య తాన్ ఉపదేష్టుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","తదా అధ్యాపకాః ఫిరూశినఞ్చ వ్యభిచారకర్మ్మణి ధృతం స్త్రియమేకామ్ ఆనియ సర్వ్వేషాం మధ్యే స్థాపయిత్వా వ్యాహరన్ ");
INSERT INTO santel_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","హే గురో యోషితమ్ ఇమాం వ్యభిచారకర్మ్మ కుర్వ్వాణాం లోకా ధృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ఏతాదృశలోకాః పాషాణాఘాతేన హన్తవ్యా ఇతి విధిర్మూసావ్యవస్థాగ్రన్థే లిఖితోస్తి కిన్తు భవాన్ కిమాదిశతి? ");
INSERT INTO santel_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","తే తమపవదితుం పరీక్షాభిప్రాయేణ వాక్యమిదమ్ అపృచ్ఛన్ కిన్తు స ప్రహ్వీభూయ భూమావఙ్గల్యా లేఖితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","తతస్తైః పునః పునః పృష్ట ఉత్థాయ కథితవాన్ యుష్మాకం మధ్యే యో జనో నిరపరాధీ సఏవ ప్రథమమ్ ఏనాం పాషాణేనాహన్తు| ");
INSERT INTO santel_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","పశ్చాత్ స పునశ్చ ప్రహ్వీభూయ భూమౌ లేఖితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","తాం కథం శ్రుత్వా తే స్వస్వమనసి ప్రబోధం ప్రాప్య జ్యేష్ఠానుక్రమం ఏకైకశః సర్వ్వే బహిరగచ్ఛన్ తతో యీశురేకాకీ తయక్త్తోభవత్ మధ్యస్థానే దణ్డాయమానా సా యోషా చ స్థితా| ");
INSERT INTO santel_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","తత్పశ్చాద్ యీశురుత్థాయ తాం వనితాం వినా కమప్యపరం న విలోక్య పృష్టవాన్ హే వామే తవాపవాదకాః కుత్ర? కోపి త్వాం కిం న దణ్డయతి? ");
INSERT INTO santel_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","సావదత్ హే మహేచ్ఛ కోపి న తదా యీశురవోచత్ నాహమపి దణ్డయామి యాహి పునః పాపం మాకార్షీః| ");
INSERT INTO santel_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","తతో యీశుః పునరపి లోకేభ్య ఇత్థం కథయితుమ్ ఆరభత జగతోహం జ్యోతిఃస్వరూపో యః కశ్చిన్ మత్పశ్చాద గచ్ఛతి స తిమిరే న భ్రమిత్వా జీవనరూపాం దీప్తిం ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","తతః ఫిరూశినోఽవాదిషుస్త్వం స్వార్థే స్వయం సాక్ష్యం దదాసి తస్మాత్ తవ సాక్ష్యం గ్రాహ్యం న భవతి| ");
INSERT INTO santel_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","తదా యీశుః ప్రత్యుదితవాన్ యద్యపి స్వార్థేఽహం స్వయం సాక్ష్యం దదామి తథాపి మత్ సాక్ష్యం గ్రాహ్యం యస్మాద్ అహం కుత ఆగతోస్మి క్వ యామి చ తదహం జానామి కిన్తు కుత ఆగతోస్మి కుత్ర గచ్ఛామి చ తద్ యూయం న జానీథ| ");
INSERT INTO santel_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","యూయం లౌకికం విచారయథ నాహం కిమపి విచారయామి| ");
INSERT INTO santel_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","కిన్తు యది విచారయామి తర్హి మమ విచారో గ్రహీతవ్యో యతోహమ్ ఏకాకీ నాస్మి ప్రేరయితా పితా మయా సహ విద్యతే| ");
INSERT INTO santel_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ద్వయో ర్జనయోః సాక్ష్యం గ్రహణీయం భవతీతి యుష్మాకం వ్యవస్థాగ్రన్థే లిఖితమస్తి| ");
INSERT INTO santel_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","అహం స్వార్థే స్వయం సాక్షిత్వం దదామి యశ్చ మమ తాతో మాం ప్రేరితవాన్ సోపి మదర్థే సాక్ష్యం దదాతి| ");
INSERT INTO santel_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","తదా తేఽపృచ్ఛన్ తవ తాతః కుత్ర? తతో యీశుః ప్రత్యవాదీద్ యూయం మాం న జానీథ మత్పితరఞ్చ న జానీథ యది మామ్ అక్షాస్యత తర్హి మమ తాతమప్యక్షాస్యత| ");
INSERT INTO santel_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","యీశు ర్మన్దిర ఉపదిశ్య భణ్డాగారే కథా ఏతా అకథయత్ తథాపి తం ప్రతి కోపి కరం నోదతోలయత్| ");
INSERT INTO santel_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","తతః పరం యీశుః పునరుదితవాన్ అధునాహం గచ్ఛామి యూయం మాం గవేషయిష్యథ కిన్తు నిజైః పాపై ర్మరిష్యథ యత్ స్థానమ్ అహం యాస్యామి తత్ స్థానమ్ యూయం యాతుం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","తదా యిహూదీయాః ప్రావోచన్ కిమయమ్ ఆత్మఘాతం కరిష్యతి? యతో యత్ స్థానమ్ అహం యాస్యామి తత్ స్థానమ్ యూయం యాతుం న శక్ష్యథ ఇతి వాక్యం బ్రవీతి| ");
INSERT INTO santel_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","తతో యీశుస్తేభ్యః కథితవాన్ యూయమ్ అధఃస్థానీయా లోకా అహమ్ ఊర్ద్వ్వస్థానీయః యూయమ్ ఏతజ్జగత్సమ్బన్ధీయా అహమ్ ఏతజ్జగత్సమ్బన్ధీయో న| ");
INSERT INTO santel_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","తస్మాత్ కథితవాన్ యూయం నిజైః పాపై ర్మరిష్యథ యతోహం స పుమాన్ ఇతి యది న విశ్వసిథ తర్హి నిజైః పాపై ర్మరిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","తదా తే ఽపృచ్ఛన్ కస్త్వం? తతో యీశుః కథితవాన్ యుష్మాకం సన్నిధౌ యస్య ప్రస్తావమ్ ఆ ప్రథమాత్ కరోమి సఏవ పురుషోహం| ");
INSERT INTO santel_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","యుష్మాసు మయా బహువాక్యం వక్త్తవ్యం విచారయితవ్యఞ్చ కిన్తు మత్ప్రేరయితా సత్యవాదీ తస్య సమీపే యదహం శ్రుతవాన్ తదేవ జగతే కథయామి| ");
INSERT INTO santel_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","కిన్తు స జనకే వాక్యమిదం ప్రోక్త్తవాన్ ఇతి తే నాబుధ్యన్త| ");
INSERT INTO santel_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","తతో యీశురకథయద్ యదా మనుష్యపుత్రమ్ ఊర్ద్వ్వ ఉత్థాపయిష్యథ తదాహం స పుమాన్ కేవలః స్వయం కిమపి కర్మ్మ న కరోమి కిన్తు తాతో యథా శిక్షయతి తదనుసారేణ వాక్యమిదం వదామీతి చ యూయం జ్ఞాతుం శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","మత్ప్రేరయితా పితా మామ్ ఏకాకినం న త్యజతి స మయా సార్ద్ధం తిష్ఠతి యతోహం తదభిమతం కర్మ్మ సదా కరోమి| ");
INSERT INTO santel_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","తదా తస్యైతాని వాక్యాని శ్రుత్వా బహువస్తాస్మిన్ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","యే యిహూదీయా వ్యశ్వసన్ యీశుస్తేభ్యోఽకథయత్ ");
INSERT INTO santel_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","మమ వాక్యే యది యూయమ్ ఆస్థాం కురుథ తర్హి మమ శిష్యా భూత్వా సత్యత్వం జ్ఞాస్యథ తతః సత్యతయా యుష్మాకం మోక్షో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","తదా తే ప్రత్యవాదిషుః వయమ్ ఇబ్రాహీమో వంశః కదాపి కస్యాపి దాసా న జాతాస్తర్హి యుష్మాకం ముక్త్తి ర్భవిష్యతీతి వాక్యం కథం బ్రవీషి? ");
INSERT INTO santel_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","తదా యీశుః ప్రత్యవదద్ యుష్మానహం యథార్థతరం వదామి యః పాపం కరోతి స పాపస్య దాసః| ");
INSERT INTO santel_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","దాసశ్చ నిరన్తరం నివేశనే న తిష్ఠతి కిన్తు పుత్రో నిరన్తరం తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","అతః పుత్రో యది యుష్మాన్ మోచయతి తర్హి నితాన్తమేవ ముక్త్తా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","యుయమ్ ఇబ్రాహీమో వంశ ఇత్యహం జానామి కిన్తు మమ కథా యుష్మాకమ్ అన్తఃకరణేషు స్థానం న ప్రాప్నువన్తి తస్మాద్ధేతో ర్మాం హన్తుమ్ ఈహధ్వే| ");
INSERT INTO santel_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","అహం స్వపితుః సమీపే యదపశ్యం తదేవ కథయామి తథా యూయమపి స్వపితుః సమీపే యదపశ్యత తదేవ కురుధ్వే| ");
INSERT INTO santel_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","తదా తే ప్రత్యవోచన్ ఇబ్రాహీమ్ అస్మాకం పితా తతో యీశురకథయద్ యది యూయమ్ ఇబ్రాహీమః సన్తానా అభవిష్యత తర్హి ఇబ్రాహీమ ఆచారణవద్ ఆచరిష్యత| ");
INSERT INTO santel_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ఈశ్వరస్య ముఖాత్ సత్యం వాక్యం శ్రుత్వా యుష్మాన్ జ్ఞాపయామి యోహం తం మాం హన్తుం చేష్టధ్వే ఇబ్రాహీమ్ ఏతాదృశం కర్మ్మ న చకార| ");
INSERT INTO santel_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","యూయం స్వస్వపితుః కర్మ్మాణి కురుథ తదా తైరుక్త్తం న వయం జారజాతా అస్మాకమ్ ఏకఏవ పితాస్తి స ఏవేశ్వరః ");
INSERT INTO santel_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","తతో యీశునా కథితమ్ ఈశ్వరో యది యుష్మాకం తాతోభవిష్యత్ తర్హి యూయం మయి ప్రేమాకరిష్యత యతోహమ్ ఈశ్వరాన్నిర్గత్యాగతోస్మి స్వతో నాగతోహం స మాం ప్రాహిణోత్| ");
INSERT INTO santel_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","యూయం మమ వాక్యమిదం న బుధ్యధ్వే కుతః? యతో యూయం మమోపదేశం సోఢుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","యూయం శైతాన్ పితుః సన్తానా ఏతస్మాద్ యుష్మాకం పితురభిలాషం పూరయథ స ఆ ప్రథమాత్ నరఘాతీ తదన్తః సత్యత్వస్య లేశోపి నాస్తి కారణాదతః స సత్యతాయాం నాతిష్ఠత్ స యదా మృషా కథయతి తదా నిజస్వభావానుసారేణైవ కథయతి యతో స మృషాభాషీ మృషోత్పాదకశ్చ| ");
INSERT INTO santel_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","అహం తథ్యవాక్యం వదామి కారణాదస్మాద్ యూయం మాం న ప్రతీథ| ");
INSERT INTO santel_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","మయి పాపమస్తీతి ప్రమాణం యుష్మాకం కో దాతుం శక్నోతి? యద్యహం తథ్యవాక్యం వదామి తర్హి కుతో మాం న ప్రతిథ? ");
INSERT INTO santel_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","యః కశ్చన ఈశ్వరీయో లోకః స ఈశ్వరీయకథాయాం మనో నిధత్తే యూయమ్ ఈశ్వరీయలోకా న భవథ తన్నిదానాత్ తత్ర న మనాంసి నిధద్వే| ");
INSERT INTO santel_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","తదా యిహూదీయాః ప్రత్యవాదిషుః త్వమేకః శోమిరోణీయో భూతగ్రస్తశ్చ వయం కిమిదం భద్రం నావాదిష్మ? ");
INSERT INTO santel_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","తతో యీశుః ప్రత్యవాదీత్ నాహం భూతగ్రస్తః కిన్తు నిజతాతం సమ్మన్యే తస్మాద్ యూయం మామ్ అపమన్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","అహం స్వసుఖ్యాతిం న చేష్టే కిన్తు చేష్టితా విచారయితా చాపర ఏక ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","అహం యుష్మభ్యమ్ అతీవ యథార్థం కథయామి యో నరో మదీయం వాచం మన్యతే స కదాచన నిధనం న ద్రక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","యిహూదీయాస్తమవదన్ త్వం భూతగ్రస్త ఇతీదానీమ్ అవైష్మ| ఇబ్రాహీమ్ భవిష్యద్వాదినఞ్చ సర్వ్వే మృతాః కిన్తు త్వం భాషసే యో నరో మమ భారతీం గృహ్లాతి స జాతు నిధానాస్వాదం న లప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","తర్హి త్వం కిమ్ అస్మాకం పూర్వ్వపురుషాద్ ఇబ్రాహీమోపి మహాన్? యస్మాత్ సోపి మృతః భవిష్యద్వాదినోపి మృతాః త్వం స్వం కం పుమాంసం మనుషే? ");
INSERT INTO santel_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","యీశుః ప్రత్యవోచద్ యద్యహం స్వం స్వయం సమ్మన్యే తర్హి మమ తత్ సమ్మననం కిమపి న కిన్తు మమ తాతో యం యూయం స్వీయమ్ ఈశ్వరం భాషధ్వే సఏవ మాం సమ్మనుతే| ");
INSERT INTO santel_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","యూయం తం నావగచ్ఛథ కిన్త్వహం తమవగచ్ఛామి తం నావగచ్ఛామీతి వాక్యం యది వదామి తర్హి యూయమివ మృషాభాషీ భవామి కిన్త్వహం తమవగచ్ఛామి తదాక్షామపి గృహ్లామి| ");
INSERT INTO santel_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","యుష్మాకం పూర్వ్వపురుష ఇబ్రాహీమ్ మమ సమయం ద్రష్టుమ్ అతీవావాఞ్ఛత్ తన్నిరీక్ష్యానన్దచ్చ| ");
INSERT INTO santel_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","తదా యిహూదీయా అపృచ్ఛన్ తవ వయః పఞ్చాశద్వత్సరా న త్వం కిమ్ ఇబ్రాహీమమ్ అద్రాక్షీః? ");
INSERT INTO santel_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","యీశుః ప్రత్యవాదీద్ యుష్మానహం యథార్థతరం వదామి ఇబ్రాహీమో జన్మనః పూర్వ్వకాలమారభ్యాహం విద్యే| ");
INSERT INTO santel_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","తదా తే పాషాణాన్ ఉత్తోల్య తమాహన్తుమ్ ఉదయచ్ఛన్ కిన్తు యీశు ర్గుప్తో మన్తిరాద్ బహిర్గత్య తేషాం మధ్యేన ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","తతః పరం యీశుర్గచ్ఛన్ మార్గమధ్యే జన్మాన్ధం నరమ్ అపశ్యత్| ");
INSERT INTO santel_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","తతః శిష్యాస్తమ్ అపృచ్ఛన్ హే గురో నరోయం స్వపాపేన వా స్వపిత్రాః పాపేనాన్ధోఽజాయత? ");
INSERT INTO santel_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","తతః స ప్రత్యుదితవాన్ ఏతస్య వాస్య పిత్రోః పాపాద్ ఏతాదృశోభూద ఇతి నహి కిన్త్వనేన యథేశ్వరస్య కర్మ్మ ప్రకాశ్యతే తద్ధేతోరేవ| ");
INSERT INTO santel_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","దినే తిష్ఠతి మత్ప్రేరయితుః కర్మ్మ మయా కర్త్తవ్యం యదా కిమపి కర్మ్మ న క్రియతే తాదృశీ నిశాగచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","అహం యావత్కాలం జగతి తిష్ఠామి తావత్కాలం జగతో జ్యోతిఃస్వరూపోస్మి| ");
INSERT INTO santel_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ఇత్యుక్త్తా భూమౌ నిష్ఠీవం నిక్షిప్య తేన పఙ్కం కృతవాన్ ");
INSERT INTO santel_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","పశ్చాత్ తత్పఙ్కేన తస్యాన్ధస్య నేత్రే ప్రలిప్య తమిత్యాదిశత్ గత్వా శిలోహే ఽర్థాత్ ప్రేరితనామ్ని సరసి స్నాహి| తతోన్ధో గత్వా తత్రాస్నాత్ తతః ప్రన్నచక్షు ర్భూత్వా వ్యాఘుట్యాగాత్| ");
INSERT INTO santel_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","అపరఞ్చ సమీపవాసినో లోకా యే చ తం పూర్వ్వమన్ధమ్ అపశ్యన్ తే బక్త్తుమ్ ఆరభన్త యోన్ధలోకో వర్త్మన్యుపవిశ్యాభిక్షత స ఏవాయం జనః కిం న భవతి? ");
INSERT INTO santel_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","కేచిదవదన్ స ఏవ కేచిదవోచన్ తాదృశో భవతి కిన్తు స స్వయమబ్రవీత్ స ఏవాహం భవామి| ");
INSERT INTO santel_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","అతఏవ తే ఽపృచ్ఛన్ త్వం కథం దృష్టిం పాప్తవాన్? ");
INSERT INTO santel_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","తతః సోవదద్ యీశనామక ఏకో జనో మమ నయనే పఙ్కేన ప్రలిప్య ఇత్యాజ్ఞాపయత్ శిలోహకాసారం గత్వా తత్ర స్నాహి| తతస్తత్ర గత్వా మయి స్నాతే దృష్టిమహం లబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","తదా తే ఽవదన్ స పుమాన్ కుత్ర? తేనోక్త్తం నాహం జానామి| ");
INSERT INTO santel_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","అపరం తస్మిన్ పూర్వ్వాన్ధే జనే ఫిరూశినాం నికటమ్ ఆనీతే సతి ఫిరూశినోపి తమపృచ్ఛన్ కథం దృష్టిం ప్రాప్తోసి? ");
INSERT INTO santel_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","తతః స కథితవాన్ స పఙ్కేన మమ నేత్రే ఽలిమ్పత్ పశ్చాద్ స్నాత్వా దృష్టిమలభే| ");
INSERT INTO santel_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","కిన్తు యీశు ర్విశ్రామవారే కర్ద్దమం కృత్వా తస్య నయనే ప్రసన్నేఽకరోద్ ఇతికారణాత్ కతిపయఫిరూశినోఽవదన్ ");
INSERT INTO santel_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","స పుమాన్ ఈశ్వరాన్న యతః స విశ్రామవారం న మన్యతే| తతోన్యే కేచిత్ ప్రత్యవదన్ పాపీ పుమాన్ కిమ్ ఏతాదృశమ్ ఆశ్చర్య్యం కర్మ్మ కర్త్తుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ఇత్థం తేషాం పరస్పరం భిన్నవాక్యత్వమ్ అభవత్| పశ్చాత్ తే పునరపి తం పూర్వ్వాన్ధం మానుషమ్ అప్రాక్షుః యో జనస్తవ చక్షుషీ ప్రసన్నే కృతవాన్ తస్మిన్ త్వం కిం వదసి? స ఉక్త్తవాన్ స భవిశద్వాదీ| ");
INSERT INTO santel_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","స దృష్టిమ్ ఆప్తవాన్ ఇతి యిహూదీయాస్తస్య దృష్టిం ప్రాప్తస్య జనస్య పిత్రో ర్ముఖాద్ అశ్రుత్వా న ప్రత్యయన్| ");
INSERT INTO santel_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","అతఏవ తే తావపృచ్ఛన్ యువయో ర్యం పుత్రం జన్మాన్ధం వదథః స కిమయం? తర్హీదానీం కథం ద్రష్టుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","తతస్తస్య పితరౌ ప్రత్యవోచతామ్ అయమ్ ఆవయోః పుత్ర ఆ జనేరన్ధశ్చ తదప్యావాం జానీవః ");
INSERT INTO santel_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","కిన్త్వధునా కథం దృష్టిం ప్రాప్తవాన్ తదావాం న్ జానీవః కోస్య చక్షుషీ ప్రసన్నే కృతవాన్ తదపి న జానీవ ఏష వయఃప్రాప్త ఏనం పృచ్ఛత స్వకథాం స్వయం వక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","యిహూదీయానాం భయాత్ తస్య పితరౌ వాక్యమిదమ్ అవదతాం యతః కోపి మనుష్యో యది యీశుమ్ అభిషిక్తం వదతి తర్హి స భజనగృహాద్ దూరీకారిష్యతే యిహూదీయా ఇతి మన్త్రణామ్ అకుర్వ్వన్ ");
INSERT INTO santel_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","అతస్తస్య పితరౌ వ్యాహరతామ్ ఏష వయఃప్రాప్త ఏనం పృచ్ఛత| ");
INSERT INTO santel_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","తదా తే పునశ్చ తం పూర్వ్వాన్ధమ్ ఆహూయ వ్యాహరన్ ఈశ్వరస్య గుణాన్ వద ఏష మనుష్యః పాపీతి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","తదా స ఉక్త్తవాన్ స పాపీ న వేతి నాహం జానే పూర్వామన్ధ ఆసమహమ్ అధునా పశ్యామీతి మాత్రం జానామి| ");
INSERT INTO santel_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","తే పునరపృచ్ఛన్ స త్వాం ప్రతి కిమకరోత్? కథం నేత్రే ప్రసన్నే ఽకరోత్? ");
INSERT INTO santel_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","తతః సోవాదీద్ ఏకకృత్వోకథయం యూయం న శృణుథ తర్హి కుతః పునః శ్రోతుమ్ ఇచ్ఛథ? యూయమపి కిం తస్య శిష్యా భవితుమ్ ఇచ్ఛథ? ");
INSERT INTO santel_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","తదా తే తం తిరస్కృత్య వ్యాహరన్ త్వం తస్య శిష్యో వయం మూసాః శిష్యాః| ");
INSERT INTO santel_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","మూసావక్త్రేణేశ్వరో జగాద తజ్జానీమః కిన్త్వేష కుత్రత్యలోక ఇతి న జానీమః| ");
INSERT INTO santel_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","సోవదద్ ఏష మమ లోచనే ప్రసన్నే ఽకరోత్ తథాపి కుత్రత్యలోక ఇతి యూయం న జానీథ ఏతద్ ఆశ్చర్య్యం భవతి| ");
INSERT INTO santel_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ఈశ్వరః పాపినాం కథాం న శృణోతి కిన్తు యో జనస్తస్మిన్ భక్తిం కృత్వా తదిష్టక్రియాం కరోతి తస్యైవ కథాం శృణోతి ఏతద్ వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","కోపి మనుష్యో జన్మాన్ధాయ చక్షుషీ అదదాత్ జగదారమ్భాద్ ఏతాదృశీం కథాం కోపి కదాపి నాశృణోత్| ");
INSERT INTO santel_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","అస్మాద్ ఏష మనుష్యో యదీశ్వరాన్నాజాయత తర్హి కిఞ్చిదపీదృశం కర్మ్మ కర్త్తుం నాశక్నోత్| ");
INSERT INTO santel_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","తే వ్యాహరన్ త్వం పాపాద్ అజాయథాః కిమస్మాన్ త్వం శిక్షయసి? పశ్చాత్తే తం బహిరకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","తదనన్తరం యిహూదీయైః స బహిరక్రియత యీశురితి వార్త్తాం శ్రుత్వా తం సాక్షాత్ ప్రాప్య పృష్టవాన్ ఈశ్వరస్య పుత్రే త్వం విశ్వసిషి? ");
INSERT INTO santel_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","తదా స ప్రత్యవోచత్ హే ప్రభో స కో యత్ తస్మిన్నహం విశ్వసిమి? ");
INSERT INTO santel_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","తతో యీశుః కథితవాన్ త్వం తం దృష్టవాన్ త్వయా సాకం యః కథం కథయతి సఏవ సః| ");
INSERT INTO santel_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","తదా హే ప్రభో విశ్వసిమీత్యుక్త్వా స తం ప్రణామత్| ");
INSERT INTO santel_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","పశ్చాద్ యీశుః కథితవాన్ నయనహీనా నయనాని ప్రాప్నువన్తి నయనవన్తశ్చాన్ధా భవన్తీత్యభిప్రాయేణ జగదాహమ్ ఆగచ్ఛమ్| ");
INSERT INTO santel_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ఏతత్ శ్రుత్వా నికటస్థాః కతిపయాః ఫిరూశినో వ్యాహరన్ వయమపి కిమన్ధాః? ");
INSERT INTO santel_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","తదా యీశురవాదీద్ యద్యన్ధా అభవత తర్హి పాపాని నాతిష్ఠన్ కిన్తు పశ్యామీతి వాక్యవదనాద్ యుష్మాకం పాపాని తిష్ఠన్తి| ");
INSERT INTO santel_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","అహం యుష్మానతియథార్థం వదామి, యో జనో ద్వారేణ న ప్రవిశ్య కేనాప్యన్యేన మేషగృహం ప్రవిశతి స ఏవ స్తేనో దస్యుశ్చ| ");
INSERT INTO santel_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","యో ద్వారేణ ప్రవిశతి స ఏవ మేషపాలకః| ");
INSERT INTO santel_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","దౌవారికస్తస్మై ద్వారం మోచయతి మేషగణశ్చ తస్య వాక్యం శృణోతి స నిజాన్ మేషాన్ స్వస్వనామ్నాహూయ బహిః కృత్వా నయతి| ");
INSERT INTO santel_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","తథా నిజాన్ మేషాన్ బహిః కృత్వా స్వయం తేషామ్ అగ్రే గచ్ఛతి, తతో మేషాస్తస్య శబ్దం బుధ్యన్తే, తస్మాత్ తస్య పశ్చాద్ వ్రజన్తి| ");
INSERT INTO santel_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","కిన్తు పరస్య శబ్దం న బుధ్యన్తే తస్మాత్ తస్య పశ్చాద్ వ్రజిష్యన్తి వరం తస్య సమీపాత్ పలాయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","యీశుస్తేభ్య ఇమాం దృష్టాన్తకథామ్ అకథయత్ కిన్తు తేన కథితకథాయాస్తాత్పర్య్యం తే నాబుధ్యన్త| ");
INSERT INTO santel_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","అతో యీశుః పునరకథయత్, యుష్మానాహం యథార్థతరం వ్యాహరామి, మేషగృహస్య ద్వారమ్ అహమేవ| ");
INSERT INTO santel_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","మయా న ప్రవిశ్య య ఆగచ్ఛన్ తే స్తేనా దస్యవశ్చ కిన్తు మేషాస్తేషాం కథా నాశృణ్వన్| ");
INSERT INTO santel_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","అహమేవ ద్వారస్వరూపః, మయా యః కశ్చిత ప్రవిశతి స రక్షాం ప్రాప్స్యతి తథా బహిరన్తశ్చ గమనాగమనే కృత్వా చరణస్థానం ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","యో జనస్తేనః స కేవలం స్తైన్యబధవినాశాన్ కర్త్తుమేవ సమాయాతి కిన్త్వహమ్ ఆయు ర్దాతుమ్ అర్థాత్ బాహూల్యేన తదేవ దాతుమ్ ఆగచ్ఛమ్| ");
INSERT INTO santel_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","అహమేవ సత్యమేషపాలకో యస్తు సత్యో మేషపాలకః స మేషార్థం ప్రాణత్యాగం కరోతి; ");
INSERT INTO santel_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","కిన్తు యో జనో మేషపాలకో న, అర్థాద్ యస్య మేషా నిజా న భవన్తి, య ఏతాదృశో వైతనికః స వృకమ్ ఆగచ్ఛన్తం దృష్ట్వా మేజవ్రజం విహాయ పలాయతే, తస్మాద్ వృకస్తం వ్రజం ధృత్వా వికిరతి| ");
INSERT INTO santel_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","వైతనికః పలాయతే యతః స వేతనార్థీ మేషార్థం న చిన్తయతి| ");
INSERT INTO santel_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","అహమేవ సత్యో మేషపాలకః, పితా మాం యథా జానాతి, అహఞ్చ యథా పితరం జానామి, ");
INSERT INTO santel_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","తథా నిజాన్ మేషానపి జానామి, మేషాశ్చ మాం జానాన్తి, అహఞ్చ మేషార్థం ప్రాణత్యాగం కరోమి| ");
INSERT INTO santel_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","అపరఞ్చ ఏతద్ గృహీయ మేషేభ్యో భిన్నా అపి మేషా మమ సన్తి తే సకలా ఆనయితవ్యాః; తే మమ శబ్దం శ్రోష్యన్తి తత ఏకో వ్రజ ఏకో రక్షకో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ప్రాణానహం త్యక్త్వా పునః ప్రాణాన్ గ్రహీష్యామి, తస్మాత్ పితా మయి స్నేహం కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","కశ్చిజ్జనో మమ ప్రాణాన్ హన్తుం న శక్నోతి కిన్తు స్వయం తాన్ సమర్పయామి తాన్ సమర్పయితుం పునర్గ్రహీతుఞ్చ మమ శక్తిరాస్తే భారమిమం స్వపితుః సకాశాత్ ప్రాప్తోహమ్| ");
INSERT INTO santel_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","అస్మాదుపదేశాత్ పునశ్చ యిహూదీయానాం మధ్యే భిన్నవాక్యతా జాతా| ");
INSERT INTO santel_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","తతో బహవో వ్యాహరన్ ఏష భూతగ్రస్త ఉన్మత్తశ్చ, కుత ఏతస్య కథాం శృణుథ? ");
INSERT INTO santel_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","కేచిద్ అవదన్ ఏతస్య కథా భూతగ్రస్తస్య కథావన్న భవన్తి, భూతః కిమ్ అన్ధాయ చక్షుషీ దాతుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","శీతకాలే యిరూశాలమి మన్దిరోత్సర్గపర్వ్వణ్యుపస్థితే ");
INSERT INTO santel_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","యీశుః సులేమానో నిఃసారేణ గమనాగమనే కరోతి, ");
INSERT INTO santel_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ఏతస్మిన్ సమయే యిహూదీయాస్తం వేష్టయిత్వా వ్యాహరన్ కతి కాలాన్ అస్మాకం విచికిత్సాం స్థాపయిష్యామి? యద్యభిషిక్తో భవతి తర్హి తత్ స్పష్టం వద| ");
INSERT INTO santel_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","తదా యీశుః ప్రత్యవదద్ అహమ్ అచకథం కిన్తు యూయం న ప్రతీథ, నిజపితు ర్నామ్నా యాం యాం క్రియాం కరోమి సా క్రియైవ మమ సాక్షిస్వరూపా| ");
INSERT INTO santel_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","కిన్త్వహం పూర్వ్వమకథయం యూయం మమ మేషా న భవథ, కారణాదస్మాన్ న విశ్వసిథ| ");
INSERT INTO santel_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","మమ మేషా మమ శబ్దం శృణ్వన్తి తానహం జానామి తే చ మమ పశ్చాద్ గచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","అహం తేభ్యోఽనన్తాయు ర్దదామి, తే కదాపి న నంక్ష్యన్తి కోపి మమ కరాత్ తాన్ హర్త్తుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","యో మమ పితా తాన్ మహ్యం దత్తవాన్ స సర్వ్వస్మాత్ మహాన్, కోపి మమ పితుః కరాత్ తాన్ హర్త్తుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","అహం పితా చ ద్వయోరేకత్వమ్| ");
INSERT INTO santel_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","తతో యిహూదీయాః పునరపి తం హన్తుం పాషాణాన్ ఉదతోలయన్| ");
INSERT INTO santel_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","యీశుః కథితవాన్ పితుః సకాశాద్ బహూన్యుత్తమకర్మ్మాణి యుష్మాకం ప్రాకాశయం తేషాం కస్య కర్మ్మణః కారణాన్ మాం పాషాణైరాహన్తుమ్ ఉద్యతాః స్థ? ");
INSERT INTO santel_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","యిహూదీయాః ప్రత్యవదన్ ప్రశస్తకర్మ్మహేతో ర్న కిన్తు త్వం మానుషః స్వమీశ్వరమ్ ఉక్త్వేశ్వరం నిన్దసి కారణాదస్మాత్ త్వాం పాషాణైర్హన్మః| ");
INSERT INTO santel_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","తదా యీశుః ప్రత్యుక్తవాన్ మయా కథితం యూయమ్ ఈశ్వరా ఏతద్వచనం యుష్మాకం శాస్త్రే లిఖితం నాస్తి కిం? ");
INSERT INTO santel_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","తస్మాద్ యేషామ్ ఉద్దేశే ఈశ్వరస్య కథా కథితా తే యదీశ్వరగణా ఉచ్యన్తే ధర్మ్మగ్రన్థస్యాప్యన్యథా భవితుం న శక్యం, ");
INSERT INTO santel_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","తర్హ్యాహమ్ ఈశ్వరస్య పుత్ర ఇతి వాక్యస్య కథనాత్ యూయం పిత్రాభిషిక్తం జగతి ప్రేరితఞ్చ పుమాంసం కథమ్ ఈశ్వరనిన్దకం వాదయ? ");
INSERT INTO santel_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","యద్యహం పితుః కర్మ్మ న కరోమి తర్హి మాం న ప్రతీత; ");
INSERT INTO santel_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","కిన్తు యది కరోమి తర్హి మయి యుష్మాభిః ప్రత్యయే న కృతేఽపి కార్య్యే ప్రత్యయః క్రియతాం, తతో మయి పితాస్తీతి పితర్య్యహమ్ అస్మీతి చ క్షాత్వా విశ్వసిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","తదా తే పునరపి తం ధర్త్తుమ్ అచేష్టన్త కిన్తు స తేషాం కరేభ్యో నిస్తీర్య్య ");
INSERT INTO santel_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","పున ర్యర్ద్దన్ అద్యాస్తటే యత్ర పుర్వ్వం యోహన్ అమజ్జయత్ తత్రాగత్య న్యవసత్| ");
INSERT INTO santel_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","తతో బహవో లోకాస్తత్సమీపమ్ ఆగత్య వ్యాహరన్ యోహన్ కిమప్యాశ్చర్య్యం కర్మ్మ నాకరోత్ కిన్త్వస్మిన్ మనుష్యే యా యః కథా అకథయత్ తాః సర్వ్వాః సత్యాః; ");
INSERT INTO santel_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","తత్ర చ బహవో లోకాస్తస్మిన్ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","అనన్తరం మరియమ్ తస్యా భగినీ మర్థా చ యస్మిన్ వైథనీయాగ్రామే వసతస్తస్మిన్ గ్రామే ఇలియాసర్ నామా పీడిత ఏక ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","యా మరియమ్ ప్రభుం సుగన్ధితేలైన మర్ద్దయిత్వా స్వకేశైస్తస్య చరణౌ సమమార్జత్ తస్యా భ్రాతా స ఇలియాసర్ రోగీ| ");
INSERT INTO santel_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","అపరఞ్చ హే ప్రభో భవాన్ యస్మిన్ ప్రీయతే స ఏవ పీడితోస్తీతి కథాం కథయిత్వా తస్య భగిన్యౌ ప్రేషితవత్యౌ| ");
INSERT INTO santel_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","తదా యీశురిమాం వార్త్తాం శ్రుత్వాకథయత పీడేయం మరణార్థం న కిన్త్వీశ్వరస్య మహిమార్థమ్ ఈశ్వరపుత్రస్య మహిమప్రకాశార్థఞ్చ జాతా| ");
INSERT INTO santel_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","యీశు ర్యద్యపిమర్థాయాం తద్భగిన్యామ్ ఇలియాసరి చాప్రీయత, ");
INSERT INTO santel_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","తథాపి ఇలియాసరః పీడాయాః కథం శ్రుత్వా యత్ర ఆసీత్ తత్రైవ దినద్వయమతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","తతః పరమ్ స శిష్యానకథయద్ వయం పున ర్యిహూదీయప్రదేశం యామః| ");
INSERT INTO santel_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","తతస్తే ప్రత్యవదన్, హే గురో స్వల్పదినాని గతాని యిహూదీయాస్త్వాం పాషాణై ర్హన్తుమ్ ఉద్యతాస్తథాపి కిం పునస్తత్ర యాస్యసి? ");
INSERT INTO santel_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","యీశుః ప్రత్యవదత్, ఏకస్మిన్ దినే కిం ద్వాదశఘటికా న భవన్తి? కోపి దివా గచ్ఛన్ న స్ఖలతి యతః స ఏతజ్జగతో దీప్తిం ప్రాప్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","కిన్తు రాత్రౌ గచ్ఛన్ స్ఖలతి యతో హేతోస్తత్ర దీప్తి ర్నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ఇమాం కథాం కథయిత్వా స తానవదద్, అస్మాకం బన్ధుః ఇలియాసర్ నిద్రితోభూద్ ఇదానీం తం నిద్రాతో జాగరయితుం గచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","యీశు ర్మృతౌ కథామిమాం కథితవాన్ కిన్తు విశ్రామార్థం నిద్రాయాం కథితవాన్ ఇతి జ్ఞాత్వా శిష్యా అకథయన్, ");
INSERT INTO santel_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","హే గురో స యది నిద్రాతి తర్హి భద్రమేవ| ");
INSERT INTO santel_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","తదా యీశుః స్పష్టం తాన్ వ్యాహరత్, ఇలియాసర్ అమ్రియత; ");
INSERT INTO santel_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","కిన్తు యూయం యథా ప్రతీథ తదర్థమహం తత్ర న స్థితవాన్ ఇత్యస్మాద్ యుష్మన్నిమిత్తమ్ ఆహ్లాదితోహం, తథాపి తస్య సమీపే యామ| ");
INSERT INTO santel_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","తదా థోమా యం దిదుమం వదన్తి స సఙ్గినః శిష్యాన్ అవదద్ వయమపి గత్వా తేన సార్ద్ధం మ్రియామహై| ");
INSERT INTO santel_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","యీశుస్తత్రోపస్థాయ ఇలియాసరః శ్మశానే స్థాపనాత్ చత్వారి దినాని గతానీతి వార్త్తాం శ్రుతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","వైథనీయా యిరూశాలమః సమీపస్థా క్రోశైకమాత్రాన్తరితా; ");
INSERT INTO santel_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","తస్మాద్ బహవో యిహూదీయా మర్థాం మరియమఞ్చ భ్యాతృశోకాపన్నాం సాన్త్వయితుం తయోః సమీపమ్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","మర్థా యీశోరాగమనవార్తాం శ్రుత్వైవ తం సాక్షాద్ అకరోత్ కిన్తు మరియమ్ గేహ ఉపవిశ్య స్థితా| ");
INSERT INTO santel_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","తదా మర్థా యీశుమవాదత్, హే ప్రభో యది భవాన్ అత్రాస్థాస్యత్ తర్హి మమ భ్రాతా నామరిష్యత్| ");
INSERT INTO santel_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","కిన్త్విదానీమపి యద్ ఈశ్వరే ప్రార్థయిష్యతే ఈశ్వరస్తద్ దాస్యతీతి జానేఽహం| ");
INSERT INTO santel_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","యీశురవాదీత్ తవ భ్రాతా సముత్థాస్యతి| ");
INSERT INTO santel_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","మర్థా వ్యాహరత్ శేషదివసే స ఉత్థానసమయే ప్రోత్థాస్యతీతి జానేఽహం| ");
INSERT INTO santel_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","తదా యీశుః కథితవాన్ అహమేవ ఉత్థాపయితా జీవయితా చ యః కశ్చన మయి విశ్వసితి స మృత్వాపి జీవిష్యతి; ");
INSERT INTO santel_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","యః కశ్చన చ జీవన్ మయి విశ్వసితి స కదాపి న మరిష్యతి, అస్యాం కథాయాం కిం విశ్వసిషి? ");
INSERT INTO santel_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","సావదత్ ప్రభో యస్యావతరణాపేక్షాస్తి భవాన్ సఏవాభిషిక్త్త ఈశ్వరపుత్ర ఇతి విశ్వసిమి| ");
INSERT INTO santel_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ఇతి కథాం కథయిత్వా సా గత్వా స్వాం భగినీం మరియమం గుప్తమాహూయ వ్యాహరత్ గురురుపతిష్ఠతి త్వామాహూయతి చ| ");
INSERT INTO santel_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","కథామిమాం శ్రుత్వా సా తూర్ణమ్ ఉత్థాయ తస్య సమీపమ్ అగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","యీశు ర్గ్రామమధ్యం న ప్రవిశ్య యత్ర మర్థా తం సాక్షాద్ అకరోత్ తత్ర స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","యే యిహూదీయా మరియమా సాకం గృహే తిష్ఠన్తస్తామ్ అసాన్త్వయన తే తాం క్షిప్రమ్ ఉత్థాయ గచ్ఛన్తిం విలోక్య వ్యాహరన్, స శ్మశానే రోదితుం యాతి, ఇత్యుక్త్వా తే తస్యాః పశ్చాద్ అగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","యత్ర యీశురతిష్ఠత్ తత్ర మరియమ్ ఉపస్థాయ తం దృష్ట్వా తస్య చరణయోః పతిత్వా వ్యాహరత్ హే ప్రభో యది భవాన్ అత్రాస్థాస్యత్ తర్హి మమ భ్రాతా నామరిష్యత్| ");
INSERT INTO santel_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","యీశుస్తాం తస్యాః సఙ్గినో యిహూదీయాంశ్చ రుదతో విలోక్య శోకార్త్తః సన్ దీర్ఘం నిశ్వస్య కథితవాన్ తం కుత్రాస్థాపయత? ");
INSERT INTO santel_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","తే వ్యాహరన్, హే ప్రభో భవాన్ ఆగత్య పశ్యతు| ");
INSERT INTO santel_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","యీశునా క్రన్దితం| ");
INSERT INTO santel_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","అతఏవ యిహూదీయా అవదన్, పశ్యతాయం తస్మిన్ కిదృగ్ అప్రియత| ");
INSERT INTO santel_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","తేషాం కేచిద్ అవదన్ యోన్ధాయ చక్షుషీ దత్తవాన్ స కిమ్ అస్య మృత్యుం నివారయితుం నాశక్నోత్? ");
INSERT INTO santel_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","తతో యీశుః పునరన్తర్దీర్ఘం నిశ్వస్య శ్మశానాన్తికమ్ అగచ్ఛత్| తత్ శ్మశానమ్ ఏకం గహ్వరం తన్ముఖే పాషాణ ఏక ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","తదా యీశురవదద్ ఏనం పాషాణమ్ అపసారయత, తతః ప్రమీతస్య భగినీ మర్థావదత్ ప్రభో, అధునా తత్ర దుర్గన్ధో జాతః, యతోద్య చత్వారి దినాని శ్మశానే స తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","తదా యీశురవాదీత్, యది విశ్వసిషి తర్హీశ్వరస్య మహిమప్రకాశం ద్రక్ష్యసి కథామిమాం కిం తుభ్యం నాకథయం? ");
INSERT INTO santel_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","తదా మృతస్య శ్మశానాత్ పాషాణోఽపసారితే యీశురూర్ద్వ్వం పశ్యన్ అకథయత్, హే పిత ర్మమ నేవేసనమ్ అశృణోః కారణాదస్మాత్ త్వాం ధన్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","త్వం సతతం శృణోషి తదప్యహం జానామి, కిన్తు త్వం మాం యత్ ప్రైరయస్తద్ యథాస్మిన్ స్థానే స్థితా లోకా విశ్వసన్తి తదర్థమ్ ఇదం వాక్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ఇమాం కథాం కథయిత్వా స ప్రోచ్చైరాహ్వయత్, హే ఇలియాసర్ బహిరాగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","తతః స ప్రమీతః శ్మశానవస్త్రై ర్బద్ధహస్తపాదో గాత్రమార్జనవాససా బద్ధముఖశ్చ బహిరాగచ్ఛత్| యీశురుదితవాన్ బన్ధనాని మోచయిత్వా త్యజతైనం| ");
INSERT INTO santel_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","మరియమః సమీపమ్ ఆగతా యే యిహూదీయలోకాస్తదా యీశోరేతత్ కర్మ్మాపశ్యన్ తేషాం బహవో వ్యశ్వసన్, ");
INSERT INTO santel_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","కిన్తు కేచిదన్యే ఫిరూశినాం సమీపం గత్వా యీశోరేతస్య కర్మ్మణో వార్త్తామ్ అవదన్| ");
INSERT INTO santel_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","తతః పరం ప్రధానయాజకాః ఫిరూశినాశ్చ సభాం కృత్వా వ్యాహరన్ వయం కిం కుర్మ్మః? ఏష మానవో బహూన్యాశ్చర్య్యకర్మ్మాణి కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","యదీదృశం కర్మ్మ కర్త్తుం న వారయామస్తర్హి సర్వ్వే లోకాస్తస్మిన్ విశ్వసిష్యన్తి రోమిలోకాశ్చాగత్యాస్మాకమ్ అనయా రాజధాన్యా సార్ద్ధం రాజ్యమ్ ఆఛేత్స్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","తదా తేషాం కియఫానామా యస్తస్మిన్ వత్సరే మహాయాజకపదే న్యయుజ్యత స ప్రత్యవదద్ యూయం కిమపి న జానీథ; ");
INSERT INTO santel_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","సమగ్రదేశస్య వినాశతోపి సర్వ్వలోకార్థమ్ ఏకస్య జనస్య మరణమ్ అస్మాకం మఙ్గలహేతుకమ్ ఏతస్య వివేచనామపి న కురుథ| ");
INSERT INTO santel_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ఏతాం కథాం స నిజబుద్ధ్యా వ్యాహరద్ ఇతి న, ");
INSERT INTO santel_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","కిన్తు యీశూస్తద్దేశీయానాం కారణాత్ ప్రాణాన్ త్యక్ష్యతి, దిశి దిశి వికీర్ణాన్ ఈశ్వరస్య సన్తానాన్ సంగృహ్యైకజాతిం కరిష్యతి చ, తస్మిన్ వత్సరే కియఫా మహాయాజకత్వపదే నియుక్తః సన్ ఇదం భవిష్యద్వాక్యం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","తద్దినమారభ్య తే కథం తం హన్తుం శక్నువన్తీతి మన్త్రణాం కర్త్తుం ప్రారేభిరే| ");
INSERT INTO santel_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","అతఏవ యిహూదీయానాం మధ్యే యీశుః సప్రకాశం గమనాగమనే అకృత్వా తస్మాద్ గత్వా ప్రాన్తరస్య సమీపస్థాయిప్రదేశస్యేఫ్రాయిమ్ నామ్ని నగరే శిష్యైః సాకం కాలం యాపయితుం ప్రారేభే| ");
INSERT INTO santel_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","అనన్తరం యిహూదీయానాం నిస్తారోత్సవే నికటవర్త్తిని సతి తదుత్సవాత్ పూర్వ్వం స్వాన్ శుచీన్ కర్త్తుం బహవో జనా గ్రామేభ్యో యిరూశాలమ్ నగరమ్ ఆగచ్ఛన్, ");
INSERT INTO santel_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","యీశోరన్వేషణం కృత్వా మన్దిరే దణ్డాయమానాః సన్తః పరస్పరం వ్యాహరన్, యుష్మాకం కీదృశో బోధో జాయతే? స కిమ్ ఉత్సవేఽస్మిన్ అత్రాగమిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","స చ కుత్రాస్తి యద్యేతత్ కశ్చిద్ వేత్తి తర్హి దర్శయతు ప్రధానయాజకాః ఫిరూశినశ్చ తం ధర్త్తుం పూర్వ్వమ్ ఇమామ్ ఆజ్ఞాం ప్రాచారయన్| ");
INSERT INTO santel_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","నిస్తారోత్సవాత్ పూర్వ్వం దినషట్కే స్థితే యీశు ర్యం ప్రమీతమ్ ఇలియాసరం శ్మశానాద్ ఉదస్థాపరత్ తస్య నివాసస్థానం బైథనియాగ్రామమ్ ఆగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","తత్ర తదర్థం రజన్యాం భోజ్యే కృతే మర్థా పర్య్యవేషయద్ ఇలియాసర్ చ తస్య సఙ్గిభిః సార్ద్ధం భోజనాసన ఉపావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","తదా మరియమ్ అర్ద్ధసేటకం బహుమూల్యం జటామాంసీయం తైలమ్ ఆనీయ యీశోశ్చరణయో ర్మర్ద్దయిత్వా నిజకేశ ర్మార్ష్టుమ్ ఆరభత; తదా తైలస్య పరిమలేన గృహమ్ ఆమోదితమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","యః శిమోనః పుత్ర రిష్కరియోతీయో యిహూదానామా యీశుం పరకరేషు సమర్పయిష్యతి స శిష్యస్తదా కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ఏతత్తైలం త్రిభిః శతై ర్ముద్రాపదై ర్విక్రీతం సద్ దరిద్రేభ్యః కుతో నాదీయత? ");
INSERT INTO santel_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","స దరిద్రలోకార్థమ్ అచిన్తయద్ ఇతి న, కిన్తు స చౌర ఏవం తన్నికటే ముద్రాసమ్పుటకస్థిత్యా తన్మధ్యే యదతిష్ఠత్ తదపాహరత్ తస్మాత్ కారణాద్ ఇమాం కథామకథయత్| ");
INSERT INTO santel_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","తదా యీశురకథయద్ ఏనాం మా వారయ సా మమ శ్మశానస్థాపనదినార్థం తదరక్షయత్| ");
INSERT INTO santel_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","దరిద్రా యుష్మాకం సన్నిధౌ సర్వ్వదా తిష్ఠన్తి కిన్త్వహం సర్వ్వదా యుష్మాకం సన్నిధౌ న తిష్ఠామి| ");
INSERT INTO santel_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","తతః పరం యీశుస్తత్రాస్తీతి వార్త్తాం శ్రుత్వా బహవో యిహూదీయాస్తం శ్మశానాదుత్థాపితమ్ ఇలియాసరఞ్చ ద్రష్టుం తత్ స్థానమ్ ఆగచ్ఛన| ");
INSERT INTO santel_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","తదా ప్రధానయాజకాస్తమ్ ఇలియాసరమపి సంహర్త్తుమ్ అమన్త్రయన్ ; ");
INSERT INTO santel_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","యతస్తేన బహవో యిహూదీయా గత్వా యీశౌ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","అనన్తరం యీశు ర్యిరూశాలమ్ నగరమ్ ఆగచ్ఛతీతి వార్త్తాం శ్రుత్వా పరేఽహని ఉత్సవాగతా బహవో లోకాః ");
INSERT INTO santel_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ఖర్జ్జూరపత్రాద్యానీయ తం సాక్షాత్ కర్త్తుం బహిరాగత్య జయ జయేతి వాచం ప్రోచ్చై ర్వక్తుమ్ ఆరభన్త, ఇస్రాయేలో యో రాజా పరమేశ్వరస్య నామ్నాగచ్ఛతి స ధన్యః| ");
INSERT INTO santel_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","తదా \"హే సియోనః కన్యే మా భైషీః పశ్యాయం తవ రాజా గర్ద్దభశావకమ్ ఆరుహ్యాగచ్ఛతి\" ");
INSERT INTO santel_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ఇతి శాస్త్రీయవచనానుసారేణ యీశురేకం యువగర్ద్దభం ప్రాప్య తదుపర్య్యారోహత్| ");
INSERT INTO santel_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","అస్యాః ఘటనాయాస్తాత్పర్య్యం శిష్యాః ప్రథమం నాబుధ్యన్త, కిన్తు యీశౌ మహిమానం ప్రాప్తే సతి వాక్యమిదం తస్మిన అకథ్యత లోకాశ్చ తమ్ప్రతీత్థమ్ అకుర్వ్వన్ ఇతి తే స్మృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","స ఇలియాసరం శ్మశానాద్ ఆగన్తుమ్ ఆహ్వతవాన్ శ్మశానాఞ్చ ఉదస్థాపయద్ యే యే లోకాస్తత్కర్మ్య సాక్షాద్ అపశ్యన్ తే ప్రమాణం దాతుమ్ ఆరభన్త| ");
INSERT INTO santel_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","స ఏతాదృశమ్ అద్భుతం కర్మ్మకరోత్ తస్య జనశ్రుతే ర్లోకాస్తం సాక్షాత్ కర్త్తుమ్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","తతః ఫిరూశినః పరస్పరం వక్తుమ్ ఆరభన్త యుష్మాకం సర్వ్వాశ్చేష్టా వృథా జాతాః, ఇతి కిం యూయం న బుధ్యధ్వే? పశ్యత సర్వ్వే లోకాస్తస్య పశ్చాద్వర్త్తినోభవన్| ");
INSERT INTO santel_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","భజనం కర్త్తుమ్ ఉత్సవాగతానాం లోకానాం కతిపయా జనా అన్యదేశీయా ఆసన్ , ");
INSERT INTO santel_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","తే గాలీలీయబైత్సైదానివాసినః ఫిలిపస్య సమీపమ్ ఆగత్య వ్యాహరన్ హే మహేచ్ఛ వయం యీశుం ద్రష్టుమ్ ఇచ్ఛామః| ");
INSERT INTO santel_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","తతః ఫిలిపో గత్వా ఆన్ద్రియమ్ అవదత్ పశ్చాద్ ఆన్ద్రియఫిలిపౌ యీశవే వార్త్తామ్ అకథయతాం| ");
INSERT INTO santel_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","తదా యీశుః ప్రత్యుదితవాన్ మానవసుతస్య మహిమప్రాప్తిసమయ ఉపస్థితః| ");
INSERT INTO santel_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","అహం యుష్మానతియథార్థం వదామి, ధాన్యబీజం మృత్తికాయాం పతిత్వా యది న మృయతే తర్హ్యేకాకీ తిష్ఠతి కిన్తు యది మృయతే తర్హి బహుగుణం ఫలం ఫలతి| ");
INSERT INTO santel_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","యో జనేा నిజప్రాణాన్ ప్రియాన్ జానాతి స తాన్ హారయిష్యతి కిన్తు యేा జన ఇహలోకే నిజప్రాణాన్ అప్రియాన్ జానాతి సేाనన్తాయుః ప్రాప్తుం తాన్ రక్షిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","కశ్చిద్ యది మమ సేవకో భవితుం వాఞ్ఛతి తర్హి స మమ పశ్చాద్గామీ భవతు, తస్మాద్ అహం యత్ర తిష్ఠామి మమ సేవకేाపి తత్ర స్థాస్యతి; యో జనో మాం సేవతే మమ పితాపి తం సమ్మంస్యతే| ");
INSERT INTO santel_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","సామ్ప్రతం మమ ప్రాణా వ్యాకులా భవన్తి, తస్మాద్ హే పితర ఏతస్మాత్ సమయాన్ మాం రక్ష, ఇత్యహం కిం ప్రార్థయిష్యే? కిన్త్వహమ్ ఏతత్సమయార్థమ్ అవతీర్ణవాన్| ");
INSERT INTO santel_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","హే పిత: స్వనామ్నో మహిమానం ప్రకాశయ; తనైవ స్వనామ్నో మహిమానమ్ అహం ప్రాకాశయం పునరపి ప్రకాశయిష్యామి, ఏషా గగణీయా వాణీ తస్మిన్ సమయేఽజాయత| ");
INSERT INTO santel_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","తచ్శ్రుత్వా సమీపస్థలోకానాం కేచిద్ అవదన్ మేఘోఽగర్జీత్, కేచిద్ అవదన్ స్వర్గీయదూతోఽనేన సహ కథామచకథత్| ");
INSERT INTO santel_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","తదా యీశుః ప్రత్యవాదీత్, మదర్థం శబ్దోయం నాభూత్ యుష్మదర్థమేవాభూత్| ");
INSERT INTO santel_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","అధునా జగతోస్య విచార: సమ్పత్స్యతే, అధునాస్య జగత: పతీ రాజ్యాత్ చ్యోష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","యద్యఈ పృథివ్యా ఊర్ద్వ్వే ప్రోత్థాపితోస్మి తర్హి సర్వ్వాన్ మానవాన్ స్వసమీపమ్ ఆకర్షిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","కథం తస్య మృతి ర్భవిష్యతి, ఏతద్ బోధయితుం స ఇమాం కథామ్ అకథయత్| ");
INSERT INTO santel_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","తదా లోకా అకథయన్ సోభిషిక్తః సర్వ్వదా తిష్ఠతీతి వ్యవస్థాగ్రన్థే శ్రుతమ్ అస్మాభిః, తర్హి మనుష్యపుత్రః ప్రోత్థాపితో భవిష్యతీతి వాక్యం కథం వదసి? మనుష్యపుత్రోయం కః? ");
INSERT INTO santel_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","తదా యీశురకథాయద్ యుష్మాభిః సార్ద్ధమ్ అల్పదినాని జ్యోతిరాస్తే, యథా యుష్మాన్ అన్ధకారో నాచ్ఛాదయతి తదర్థం యావత్కాలం యుష్మాభిః సార్ద్ధం జ్యోతిస్తిష్ఠతి తావత్కాలం గచ్ఛత; యో జనోఽన్ధకారే గచ్ఛతి స కుత్ర యాతీతి న జానాతి| ");
INSERT INTO santel_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","అతఏవ యావత్కాలం యుష్మాకం నికటే జ్యోతిరాస్తే తావత్కాలం జ్యోతీరూపసన్తానా భవితుం జ్యోతిషి విశ్వసిత; ఇమాం కథాం కథయిత్వా యీశుః ప్రస్థాయ తేభ్యః స్వం గుప్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","యద్యపి యీశుస్తేషాం సమక్షమ్ ఏతావదాశ్చర్య్యకర్మ్మాణి కృతవాన్ తథాపి తే తస్మిన్ న వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","అతఏవ కః ప్రత్యేతి సుసంవాదం పరేశాస్మత్ ప్రచారితం? ప్రకాశతే పరేశస్య హస్తః కస్య చ సన్నిధౌ? యిశయియభవిష్యద్వాదినా యదేతద్ వాక్యముక్తం తత్ సఫలమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","తే ప్రత్యేతుం నాశన్కువన్ తస్మిన్ యిశయియభవిష్యద్వాది పునరవాదీద్, ");
INSERT INTO santel_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","యదా, \"తే నయనై ర్న పశ్యన్తి బుద్ధిభిశ్చ న బుధ్యన్తే తై ర్మనఃసు పరివర్త్తితేషు చ తానహం యథా స్వస్థాన్ న కరోమి తథా స తేషాం లోచనాన్యన్ధాని కృత్వా తేషామన్తఃకరణాని గాఢాని కరిష్యతి| \" ");
INSERT INTO santel_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","యిశయియో యదా యీశో ర్మహిమానం విలోక్య తస్మిన్ కథామకథయత్ తదా భవిష్యద్వాక్యమ్ ఈదృశం ప్రకాశయత్| ");
INSERT INTO santel_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","తథాప్యధిపతినాం బహవస్తస్మిన్ ప్రత్యాయన్| కిన్తు ఫిరూశినస్తాన్ భజనగృహాద్ దూరీకుర్వ్వన్తీతి భయాత్ తే తం న స్వీకృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","యత ఈశ్వరస్య ప్రశంసాతో మానవానాం ప్రశంసాయాం తేఽప్రియన్త| ");
INSERT INTO santel_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","తదా యీశురుచ్చైఃకారమ్ అకథయద్ యో జనో మయి విశ్వసితి స కేవలే మయి విశ్వసితీతి న, స మత్ప్రేరకేఽపి విశ్వసితి| ");
INSERT INTO santel_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","యో జనో మాం పశ్యతి స మత్ప్రేరకమపి పశ్యతి| ");
INSERT INTO santel_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","యో జనో మాం ప్రత్యేతి స యథాన్ధకారే న తిష్ఠతి తదర్థమ్ అహం జ్యోతిఃస్వరూపో భూత్వా జగత్యస్మిన్ అవతీర్ణవాన్| ");
INSERT INTO santel_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","మమ కథాం శ్రుత్వా యది కశ్చిన్ న విశ్వసితి తర్హి తమహం దోషిణం న కరోమి, యతో హేతో ర్జగతో జనానాం దోషాన్ నిశ్చితాన్ కర్త్తుం నాగత్య తాన్ పరిచాతుమ్ ఆగతోస్మి| ");
INSERT INTO santel_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","యః కశ్చిన్ మాం న శ్రద్ధాయ మమ కథం న గృహ్లాతి, అన్యస్తం దోషిణం కరిష్యతి వస్తుతస్తు యాం కథామహమ్ అచకథం సా కథా చరమేఽన్హి తం దోషిణం కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","యతో హేతోరహం స్వతః కిమపి న కథయామి, కిం కిం మయా కథయితవ్యం కిం సముపదేష్టవ్యఞ్చ ఇతి మత్ప్రేరయితా పితా మామాజ్ఞాపయత్| ");
INSERT INTO santel_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","తస్య సాజ్ఞా అనన్తాయురిత్యహం జానామి, అతఏవాహం యత్ కథయామి తత్ పితా యథాజ్ఞాపయత్ తథైవ కథయామ్యహమ్| ");
INSERT INTO santel_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","నిస్తారోత్సవస్య కిఞ్చిత్కాలాత్ పూర్వ్వం పృథివ్యాః పితుః సమీపగమనస్య సమయః సన్నికర్షోభూద్ ఇతి జ్ఞాత్వా యీశురాప్రథమాద్ యేషు జగత్ప్రవాసిష్వాత్మీయలోకేష ప్రేమ కరోతి స్మ తేషు శేషం యావత్ ప్రేమ కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","పితా తస్య హస్తే సర్వ్వం సమర్పితవాన్ స్వయమ్ ఈశ్వరస్య సమీపాద్ ఆగచ్ఛద్ ఈశ్వరస్య సమీపం యాస్యతి చ, సర్వ్వాణ్యేతాని జ్ఞాత్వా రజన్యాం భోజనే సమ్పూర్ణే సతి, ");
INSERT INTO santel_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","యదా శైతాన్ తం పరహస్తేషు సమర్పయితుం శిమోనః పుత్రస్య ఈష్కారియోతియస్య యిహూదా అన్తఃకరణే కుప్రవృత్తిం సమార్పయత్, ");
INSERT INTO santel_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","తదా యీశు ర్భోజనాసనాద్ ఉత్థాయ గాత్రవస్త్రం మోచయిత్వా గాత్రమార్జనవస్త్రం గృహీత్వా తేన స్వకటిమ్ అబధ్నాత్, ");
INSERT INTO santel_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","పశ్చాద్ ఏకపాత్రే జలమ్ అభిషిచ్య శిష్యాణాం పాదాన్ ప్రక్షాల్య తేన కటిబద్ధగాత్రమార్జనవాససా మార్ష్టుం ప్రారభత| ");
INSERT INTO santel_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","తతః శిమోన్పితరస్య సమీపమాగతే స ఉక్తవాన్ హే ప్రభో భవాన్ కిం మమ పాదౌ ప్రక్షాలయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","యీశురుదితవాన్ అహం యత్ కరోమి తత్ సమ్ప్రతి న జానాసి కిన్తు పశ్చాజ్ జ్ఞాస్యసి| ");
INSERT INTO santel_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","తతః పితరః కథితవాన్ భవాన్ కదాపి మమ పాదౌ న ప్రక్షాలయిష్యతి| యీశురకథయద్ యది త్వాం న ప్రక్షాలయే తర్హి మయి తవ కోప్యంశో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","తదా శిమోన్పితరః కథితవాన్ హే ప్రభో తర్హి కేవలపాదౌ న, మమ హస్తౌ శిరశ్చ ప్రక్షాలయతు| ");
INSERT INTO santel_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","తతో యీశురవదద్ యో జనో ధౌతస్తస్య సర్వ్వాఙ్గపరిష్కృతత్వాత్ పాదౌ వినాన్యాఙ్గస్య ప్రక్షాలనాపేక్షా నాస్తి| యూయం పరిష్కృతా ఇతి సత్యం కిన్తు న సర్వ్వే, ");
INSERT INTO santel_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","యతో యో జనస్తం పరకరేషు సమర్పయిష్యతి తం స జ్ఞాతవాన; అతఏవ యూయం సర్వ్వే న పరిష్కృతా ఇమాం కథాం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ఇత్థం యీశుస్తేషాం పాదాన్ ప్రక్షాల్య వస్త్రం పరిధాయాసనే సముపవిశ్య కథితవాన్ అహం యుష్మాన్ ప్రతి కిం కర్మ్మాకార్షం జానీథ? ");
INSERT INTO santel_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","యూయం మాం గురుం ప్రభుఞ్చ వదథ తత్ సత్యమేవ వదథ యతోహం సఏవ భవామి| ");
INSERT INTO santel_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","యద్యహం ప్రభు ర్గురుశ్చ సన్ యుష్మాకం పాదాన్ ప్రక్షాలితవాన్ తర్హి యుష్మాకమపి పరస్పరం పాదప్రక్షాలనమ్ ఉచితమ్| ");
INSERT INTO santel_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","అహం యుష్మాన్ ప్రతి యథా వ్యవాహరం యుష్మాన్ తథా వ్యవహర్త్తుమ్ ఏకం పన్థానం దర్శితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","అహం యుష్మానతియథార్థం వదామి, ప్రభో ర్దాసో న మహాన్ ప్రేరకాచ్చ ప్రేరితో న మహాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ఇమాం కథాం విదిత్వా యది తదనుసారతః కర్మ్మాణి కురుథ తర్హి యూయం ధన్యా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","సర్వ్వేషు యుష్మాసు కథామిమాం కథయామి ఇతి న, యే మమ మనోనీతాస్తానహం జానామి, కిన్తు మమ భక్ష్యాణి యో భుఙ్క్తే మత్ప్రాణప్రాతికూల్యతః| ఉత్థాపయతి పాదస్య మూలం స ఏష మానవః| యదేతద్ ధర్మ్మపుస్తకస్య వచనం తదనుసారేణావశ్యం ఘటిష్యతే| ");
INSERT INTO santel_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","అహం స జన ఇత్యత్ర యథా యుష్మాకం విశ్వాసో జాయతే తదర్థం ఏతాదృశఘటనాత్ పూర్వ్వమ్ అహమిదానీం యుష్మభ్యమకథయమ్| ");
INSERT INTO santel_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","అహం యుష్మానతీవ యథార్థం వదామి, మయా ప్రేరితం జనం యో గృహ్లాతి స మామేవ గృహ్లాతి యశ్చ మాం గృహ్లాతి స మత్ప్రేరకం గృహ్లాతి| ");
INSERT INTO santel_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ఏతాం కథాం కథయిత్వా యీశు ర్దుఃఖీ సన్ ప్రమాణం దత్త్వా కథితవాన్ అహం యుష్మానతియథార్థం వదామి యుష్మాకమ్ ఏకో జనో మాం పరకరేషు సమర్పయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","తతః స కముద్దిశ్య కథామేతాం కథితవాన్ ఇత్యత్ర సన్దిగ్ధాః శిష్యాః పరస్పరం ముఖమాలోకయితుం ప్రారభన్త| ");
INSERT INTO santel_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","తస్మిన్ సమయే యీశు ర్యస్మిన్ అప్రీయత స శిష్యస్తస్య వక్షఃస్థలమ్ అవాలమ్బత| ");
INSERT INTO santel_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","శిమోన్పితరస్తం సఙ్కేతేనావదత్, అయం కముద్దిశ్య కథామేతామ్ కథయతీతి పృచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","తదా స యీశో ర్వక్షఃస్థలమ్ అవలమ్బ్య పృష్ఠవాన్, హే ప్రభో స జనః కః? ");
INSERT INTO santel_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","తతో యీశుః ప్రత్యవదద్ ఏకఖణ్డం పూపం మజ్జయిత్వా యస్మై దాస్యామి సఏవ సః; పశ్చాత్ పూపఖణ్డమేకం మజ్జయిత్వా శిమోనః పుత్రాయ ఈష్కరియోతీయాయ యిహూదై దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","తస్మిన్ దత్తే సతి శైతాన్ తమాశ్రయత్; తదా యీశుస్తమ్ అవదత్ త్వం యత్ కరిష్యసి తత్ క్షిప్రం కురు| ");
INSERT INTO santel_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","కిన్తు స యేనాశయేన తాం కథామకథాయత్ తమ్ ఉపవిష్టలోకానాం కోపి నాబుధ్యత; ");
INSERT INTO santel_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","కిన్తు యిహూదాః సమీపే ముద్రాసమ్పుటకస్థితేః కేచిద్ ఇత్థమ్ అబుధ్యన్త పార్వ్వణాసాదనార్థం కిమపి ద్రవ్యం క్రేతుం వా దరిద్రేభ్యః కిఞ్చిద్ వితరితుం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","తదా పూపఖణ్డగ్రహణాత్ పరం స తూర్ణం బహిరగచ్ఛత్; రాత్రిశ్చ సముపస్యితా| ");
INSERT INTO santel_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","యిహూదే బహిర్గతే యీశురకథయద్ ఇదానీం మానవసుతస్య మహిమా ప్రకాశతే తేనేశ్వరస్యాపి మహిమా ప్రకాశతే| ");
INSERT INTO santel_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","యది తేనేశ్వరస్య మహిమా ప్రకాశతే తర్హీశ్వరోపి స్వేన తస్య మహిమానం ప్రకాశయిష్యతి తూర్ణమేవ ప్రకాశయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","హే వత్సా అహం యుష్మాభిః సార్ద్ధం కిఞ్చిత్కాలమాత్రమ్ ఆసే, తతః పరం మాం మృగయిష్యధ్వే కిన్త్వహం యత్స్థానం యామి తత్స్థానం యూయం గన్తుం న శక్ష్యథ, యామిమాం కథాం యిహూదీయేభ్యః కథితవాన్ తథాధునా యుష్మభ్యమపి కథయామి| ");
INSERT INTO santel_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","యూయం పరస్పరం ప్రీయధ్వమ్ అహం యుష్మాసు యథా ప్రీయే యూయమపి పరస్పరమ్ తథైవ ప్రీయధ్వం, యుష్మాన్ ఇమాం నవీనామ్ ఆజ్ఞామ్ ఆదిశామి| ");
INSERT INTO santel_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","తేనైవ యది పరస్పరం ప్రీయధ్వే తర్హి లక్షణేనానేన యూయం మమ శిష్యా ఇతి సర్వ్వే జ్ఞాతుం శక్ష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","శిమోనపితరః పృష్ఠవాన్ హే ప్రభో భవాన్ కుత్ర యాస్యతి? తతో యీశుః ప్రత్యవదత్, అహం యత్స్థానం యామి తత్స్థానం సామ్ప్రతం మమ పశ్చాద్ గన్తుం న శక్నోషి కిన్తు పశ్చాద్ గమిష్యసి| ");
INSERT INTO santel_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","తదా పితరః ప్రత్యుదితవాన్, హే ప్రభో సామ్ప్రతం కుతో హేతోస్తవ పశ్చాద్ గన్తుం న శక్నోమి? త్వదర్థం ప్రాణాన్ దాతుం శక్నోమి| ");
INSERT INTO santel_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","తతో యీశుః ప్రత్యుక్తవాన్ మన్నిమిత్తం కిం ప్రాణాన్ దాతుం శక్నోషి? త్వామహం యథార్థం వదామి, కుక్కుటరవణాత్ పూర్వ్వం త్వం త్రి ర్మామ్ అపహ్నోష్యసే| ");
INSERT INTO santel_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","మనోదుఃఖినో మా భూత; ఈశ్వరే విశ్వసిత మయి చ విశ్వసిత| ");
INSERT INTO santel_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","మమ పితు గృహే బహూని వాసస్థాని సన్తి నో చేత్ పూర్వ్వం యుష్మాన్ అజ్ఞాపయిష్యం యుష్మదర్థం స్థానం సజ్జయితుం గచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","యది గత్వాహం యుష్మన్నిమిత్తం స్థానం సజ్జయామి తర్హి పనరాగత్య యుష్మాన్ స్వసమీపం నేష్యామి, తతో యత్రాహం తిష్ఠామి తత్ర యూయమపి స్థాస్యథ| ");
INSERT INTO santel_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","అహం యత్స్థానం బ్రజామి తత్స్థానం యూయం జానీథ తస్య పన్థానమపి జానీథ| ");
INSERT INTO santel_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","తదా థోమా అవదత్, హే ప్రభో భవాన్ కుత్ర యాతి తద్వయం న జానీమః, తర్హి కథం పన్థానం జ్ఞాతుం శక్నుమః? ");
INSERT INTO santel_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","యీశురకథయద్ అహమేవ సత్యజీవనరూపపథో మయా న గన్తా కోపి పితుః సమీపం గన్తుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","యది మామ్ అజ్ఞాస్యత తర్హి మమ పితరమప్యజ్ఞాస్యత కిన్త్వధునాతస్తం జానీథ పశ్యథ చ| ");
INSERT INTO santel_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","తదా ఫిలిపః కథితవాన్, హే ప్రభో పితరం దర్శయ తస్మాదస్మాకం యథేష్టం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","తతో యీశుః ప్రత్యావాదీత్, హే ఫిలిప యుష్మాభిః సార్ద్ధమ్ ఏతావద్దినాని స్థితమపి మాం కిం న ప్రత్యభిజానాసి? యో జనో మామ్ అపశ్యత్ స పితరమప్యపశ్యత్ తర్హి పితరమ్ అస్మాన్ దర్శయేతి కథాం కథం కథయసి? ");
INSERT INTO santel_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","అహం పితరి తిష్ఠామి పితా మయి తిష్ఠతీతి కిం త్వం న ప్రత్యషి? అహం యద్వాక్యం వదామి తత్ స్వతో న వదామి కిన్తు యః పితా మయి విరాజతే స ఏవ సర్వ్వకర్మ్మాణి కరాతి| ");
INSERT INTO santel_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","అతఏవ పితర్య్యహం తిష్ఠామి పితా చ మయి తిష్ఠతి మమాస్యాం కథాయాం ప్రత్యయం కురుత, నో చేత్ కర్మ్మహేతోః ప్రత్యయం కురుత| ");
INSERT INTO santel_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","అహం యుష్మానతియథార్థం వదామి, యో జనో మయి విశ్వసితి సోహమివ కర్మ్మాణి కరిష్యతి వరం తతోపి మహాకర్మ్మాణి కరిష్యతి యతో హేతోరహం పితుః సమీపం గచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","యథా పుత్రేణ పితు ర్మహిమా ప్రకాశతే తదర్థం మమ నామ ప్రోచ్య యత్ ప్రార్థయిష్యధ్వే తత్ సఫలం కరిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","యది మమ నామ్నా యత్ కిఞ్చిద్ యాచధ్వే తర్హి తదహం సాధయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","యది మయి ప్రీయధ్వే తర్హి మమాజ్ఞాః సమాచరత| ");
INSERT INTO santel_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","తతో మయా పితుః సమీపే ప్రార్థితే పితా నిరన్తరం యుష్మాభిః సార్ద్ధం స్థాతుమ్ ఇతరమేకం సహాయమ్ అర్థాత్ సత్యమయమ్ ఆత్మానం యుష్మాకం నికటం ప్రేషయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ఏతజ్జగతో లోకాస్తం గ్రహీతుం న శక్నువన్తి యతస్తే తం నాపశ్యన్ నాజనంశ్చ కిన్తు యూయం జానీథ యతో హేతోః స యుష్మాకమన్త ర్నివసతి యుష్మాకం మధ్యే స్థాస్యతి చ| ");
INSERT INTO santel_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","అహం యుష్మాన్ అనాథాన్ కృత్వా న యాస్యామి పునరపి యుష్మాకం సమీపమ్ ఆగమిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","కియత్కాలరత్ పరమ్ అస్య జగతో లోకా మాం పున ర్న ద్రక్ష్యన్తి కిన్తు యూయం ద్రక్ష్యథ;అహం జీవిష్యామి తస్మాత్ కారణాద్ యూయమపి జీవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","పితర్య్యహమస్మి మయి చ యూయం స్థ, తథాహం యుష్మాస్వస్మి తదపి తదా జ్ఞాస్యథ| ");
INSERT INTO santel_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","యో జనో మమాజ్ఞా గృహీత్వా తా ఆచరతి సఏవ మయి ప్రీయతే; యో జనశ్చ మయి ప్రీయతే సఏవ మమ పితుః ప్రియపాత్రం భవిష్యతి, తథాహమపి తస్మిన్ ప్రీత్వా తస్మై స్వం ప్రకాశయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","తదా ఈష్కరియోతీయాద్ అన్యో యిహూదాస్తమవదత్, హే ప్రభో భవాన్ జగతో లోకానాం సన్నిధౌ ప్రకాశితో న భూత్వాస్మాకం సన్నిధౌ కుతః ప్రకాశితో భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","తతో యీశుః ప్రత్యుదితవాన్, యో జనో మయి ప్రీయతే స మమాజ్ఞా అపి గృహ్లాతి, తేన మమ పితాపి తస్మిన్ ప్రేష్యతే, ఆవాఞ్చ తన్నికటమాగత్య తేన సహ నివత్స్యావః| ");
INSERT INTO santel_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","యో జనో మయి న ప్రీయతే స మమ కథా అపి న గృహ్లాతి పునశ్చ యామిమాం కథాం యూయం శృణుథ సా కథా కేవలస్య మమ న కిన్తు మమ ప్రేరకో యః పితా తస్యాపి కథా| ");
INSERT INTO santel_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ఇదానీం యుష్మాకం నికటే విద్యమానోహమ్ ఏతాః సకలాః కథాః కథయామి| ");
INSERT INTO santel_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","కిన్త్వితః పరం పిత్రా యః సహాయోఽర్థాత్ పవిత్ర ఆత్మా మమ నామ్ని ప్రేరయిష్యతి స సర్వ్వం శిక్షయిత్వా మయోక్తాః సమస్తాః కథా యుష్మాన్ స్మారయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","అహం యుష్మాకం నికటే శాన్తిం స్థాపయిత్వా యామి, నిజాం శాన్తిం యుష్మభ్యం దదామి, జగతో లోకా యథా దదాతి తథాహం న దదామి; యుష్మాకమ్ అన్తఃకరణాని దుఃఖితాని భీతాని చ న భవన్తు| ");
INSERT INTO santel_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","అహం గత్వా పునరపి యుష్మాకం సమీపమ్ ఆగమిష్యామి మయోక్తం వాక్యమిదం యూయమ్ అశ్రౌష్ట; యది మయ్యప్రేష్యధ్వం తర్హ్యహం పితుః సమీపం గచ్ఛామి మమాస్యాం కథాయాం యూయమ్ అహ్లాదిష్యధ్వం యతో మమ పితా మత్తోపి మహాన్| ");
INSERT INTO santel_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","తస్యా ఘటనాయాః సమయే యథా యుష్మాకం శ్రద్ధా జాయతే తదర్థమ్ అహం తస్యా ఘటనాయాః పూర్వ్వమ్ ఇదానీం యుష్మాన్ ఏతాం వార్త్తాం వదామి| ");
INSERT INTO santel_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ఇతః పరం యుష్మాభిః సహ మమ బహవ ఆలాపా న భవిష్యన్తి యతః కారణాద్ ఏతస్య జగతః పతిరాగచ్ఛతి కిన్తు మయా సహ తస్య కోపి సమ్బన్ధో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","అహం పితరి ప్రేమ కరోమి తథా పితు ర్విధివత్ కర్మ్మాణి కరోమీతి యేన జగతో లోకా జానన్తి తదర్థమ్ ఉత్తిష్ఠత వయం స్థానాదస్మాద్ గచ్ఛామ| ");
INSERT INTO santel_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","అహం సత్యద్రాక్షాలతాస్వరూపో మమ పితా తూద్యానపరిచారకస్వరూపఞ్చ| ");
INSERT INTO santel_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","మమ యాసు శాఖాసు ఫలాని న భవన్తి తాః స ఛినత్తి తథా ఫలవత్యః శాఖా యథాధికఫలాని ఫలన్తి తదర్థం తాః పరిష్కరోతి| ");
INSERT INTO santel_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ఇదానీం మయోక్తోపదేశేన యూయం పరిష్కృతాః| ");
INSERT INTO santel_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","అతః కారణాత్ మయి తిష్ఠత తేనాహమపి యుష్మాసు తిష్ఠామి, యతో హేతో ర్ద్రాక్షాలతాయామ్ అసంలగ్నా శాఖా యథా ఫలవతీ భవితుం న శక్నోతి తథా యూయమపి మయ్యతిష్ఠన్తః ఫలవన్తో భవితుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","అహం ద్రాక్షాలతాస్వరూపో యూయఞ్చ శాఖాస్వరూపోః; యో జనో మయి తిష్ఠతి యత్ర చాహం తిష్ఠామి, స ప్రచూరఫలైః ఫలవాన్ భవతి, కిన్తు మాం వినా యూయం కిమపి కర్త్తుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","యః కశ్చిన్ మయి న తిష్ఠతి స శుష్కశాఖేవ బహి ర్నిక్షిప్యతే లోకాశ్చ తా ఆహృత్య వహ్నౌ నిక్షిప్య దాహయన్తి| ");
INSERT INTO santel_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","యది యూయం మయి తిష్ఠథ మమ కథా చ యుష్మాసు తిష్ఠతి తర్హి యద్ వాఞ్ఛిత్వా యాచిష్యధ్వే యుష్మాకం తదేవ సఫలం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","యది యూయం ప్రచూరఫలవన్తో భవథ తర్హి తద్వారా మమ పితు ర్మహిమా ప్రకాశిష్యతే తథా యూయం మమ శిష్యా ఇతి పరిక్షాయిష్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","పితా యథా మయి ప్రీతవాన్ అహమపి యుష్మాసు తథా ప్రీతవాన్ అతో హేతో ర్యూయం నిరన్తరం మమ ప్రేమపాత్రాణి భూత్వా తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","అహం యథా పితురాజ్ఞా గృహీత్వా తస్య ప్రేమభాజనం తిష్ఠామి తథైవ యూయమపి యది మమాజ్ఞా గుహ్లీథ తర్హి మమ ప్రేమభాజనాని స్థాస్యథ| ");
INSERT INTO santel_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","యుష్మన్నిమిత్తం మమ య ఆహ్లాదః స యథా చిరం తిష్ఠతి యుష్మాకమ్ ఆనన్దశ్చ యథా పూర్య్యతే తదర్థం యుష్మభ్యమ్ ఏతాః కథా అత్రకథమ్| ");
INSERT INTO santel_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","అహం యుష్మాసు యథా ప్రీయే యూయమపి పరస్పరం తథా ప్రీయధ్వమ్ ఏషా మమాజ్ఞా| ");
INSERT INTO santel_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","మిత్రాణాం కారణాత్ స్వప్రాణదానపర్య్యన్తం యత్ ప్రేమ తస్మాన్ మహాప్రేమ కస్యాపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","అహం యద్యద్ ఆదిశామి తత్తదేవ యది యూయమ్ ఆచరత తర్హి యూయమేవ మమ మిత్రాణి| ");
INSERT INTO santel_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","అద్యారభ్య యుష్మాన్ దాసాన్ న వదిష్యామి యత్ ప్రభు ర్యత్ కరోతి దాసస్తద్ న జానాతి; కిన్తు పితుః సమీపే యద్యద్ అశృణవం తత్ సర్వ్వం యూష్మాన్ అజ్ఞాపయమ్ తత్కారణాద్ యుష్మాన్ మిత్రాణి ప్రోక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","యూయం మాం రోచితవన్త ఇతి న, కిన్త్వహమేవ యుష్మాన్ రోచితవాన్ యూయం గత్వా యథా ఫలాన్యుత్పాదయథ తాని ఫలాని చాక్షయాణి భవన్తి, తదర్థం యుష్మాన్ న్యజునజం తస్మాన్ మమ నామ ప్రోచ్య పితరం యత్ కిఞ్చిద్ యాచిష్యధ్వే తదేవ స యుష్మభ్యం దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","యూయం పరస్పరం ప్రీయధ్వమ్ అహమ్ ఇత్యాజ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","జగతో లోకై ర్యుష్మాసు ఋతీయితేషు తే పూర్వ్వం మామేవార్త్తీయన్త ఇతి యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","యది యూయం జగతో లోకా అభవిష్యత తర్హి జగతో లోకా యుష్మాన్ ఆత్మీయాన్ బుద్ధ్వాప్రేష్యన్త; కిన్తు యూయం జగతో లోకా న భవథ, అహం యుష్మాన్ అస్మాజ్జగతోఽరోచయమ్ ఏతస్మాత్ కారణాజ్జగతో లోకా యుష్మాన్ ఋతీయన్తే| ");
INSERT INTO santel_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","దాసః ప్రభో ర్మహాన్ న భవతి మమైతత్ పూర్వ్వీయం వాక్యం స్మరత; తే యది మామేవాతాడయన్ తర్హి యుష్మానపి తాడయిష్యన్తి, యది మమ వాక్యం గృహ్లన్తి తర్హి యుష్మాకమపి వాక్యం గ్రహీష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","కిన్తు తే మమ నామకారణాద్ యుష్మాన్ ప్రతి తాదృశం వ్యవహరిష్యన్తి యతో యో మాం ప్రేరితవాన్ తం తే న జానన్తి| ");
INSERT INTO santel_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","తేషాం సన్నిధిమ్ ఆగత్య యద్యహం నాకథయిష్యం తర్హి తేషాం పాపం నాభవిష్యత్ కిన్త్వధునా తేషాం పాపమాచ్ఛాదయితుమ్ ఉపాయో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","యో జనో మామ్ ఋతీయతే స మమ పితరమపి ఋతీయతే| ");
INSERT INTO santel_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","యాదృశాని కర్మ్మాణి కేనాపి కదాపి నాక్రియన్త తాదృశాని కర్మ్మాణి యది తేషాం సాక్షాద్ అహం నాకరిష్యం తర్హి తేషాం పాపం నాభవిష్యత్ కిన్త్వధునా తే దృష్ట్వాపి మాం మమ పితరఞ్చార్త్తీయన్త| ");
INSERT INTO santel_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","తస్మాత్ తేఽకారణం మామ్ ఋతీయన్తే యదేతద్ వచనం తేషాం శాస్త్రే లిఖితమాస్తే తత్ సఫలమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","కిన్తు పితు ర్నిర్గతం యం సహాయమర్థాత్ సత్యమయమ్ ఆత్మానం పితుః సమీపాద్ యుష్మాకం సమీపే ప్రేషయిష్యామి స ఆగత్య మయి ప్రమాణం దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","యూయం ప్రథమమారభ్య మయా సార్ద్ధం తిష్ఠథ తస్మాద్ధేతో ర్యూయమపి ప్రమాణం దాస్యథ| ");
INSERT INTO santel_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","యుష్మాకం యథా వాధా న జాయతే తదర్థం యుష్మాన్ ఏతాని సర్వ్వవాక్యాని వ్యాహరం| ");
INSERT INTO santel_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","లోకా యుష్మాన్ భజనగృహేభ్యో దూరీకరిష్యన్తి తథా యస్మిన్ సమయే యుష్మాన్ హత్వా ఈశ్వరస్య తుష్టి జనకం కర్మ్మాకుర్మ్మ ఇతి మంస్యన్తే స సమయ ఆగచ్ఛన్తి| ");
INSERT INTO santel_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","తే పితరం మాఞ్చ న జానన్తి, తస్మాద్ యుష్మాన్ ప్రతీదృశమ్ ఆచరిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","అతో హేతాః సమయే సముపస్థితే యథా మమ కథా యుష్మాకం మనఃసుః సముపతిష్ఠతి తదర్థం యుష్మాభ్యమ్ ఏతాం కథాం కథయామి యుష్మాభిః సార్ద్ధమ్ అహం తిష్ఠన్ ప్రథమం తాం యుష్మభ్యం నాకథయం| ");
INSERT INTO santel_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","సామ్ప్రతం స్వస్య ప్రేరయితుః సమీపం గచ్ఛామి తథాపి త్వం క్క గచ్ఛసి కథామేతాం యుష్మాకం కోపి మాం న పృచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","కిన్తు మయోక్తాభిరాభిః కథాభి ర్యూష్మాకమ్ అన్తఃకరణాని దుఃఖేన పూర్ణాన్యభవన్| ");
INSERT INTO santel_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","తథాప్యహం యథార్థం కథయామి మమ గమనం యుష్మాకం హితార్థమేవ, యతో హేతో ర్గమనే న కృతే సహాయో యుష్మాకం సమీపం నాగమిష్యతి కిన్తు యది గచ్ఛామి తర్హి యుష్మాకం సమీపే తం ప్రేషయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","తతః స ఆగత్య పాపపుణ్యదణ్డేషు జగతో లోకానాం ప్రబోధం జనయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","తే మయి న విశ్వసన్తి తస్మాద్ధేతోః పాపప్రబోధం జనయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","యుష్మాకమ్ అదృశ్యః సన్నహం పితుః సమీపం గచ్ఛామి తస్మాద్ పుణ్యే ప్రబోధం జనయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ఏతజ్జగతోఽధిపతి ర్దణ్డాజ్ఞాం ప్రాప్నోతి తస్మాద్ దణ్డే ప్రబోధం జనయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","యుష్మభ్యం కథయితుం మమానేకాః కథా ఆసతే, తాః కథా ఇదానీం యూయం సోఢుం న శక్నుథ; ");
INSERT INTO santel_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","కిన్తు సత్యమయ ఆత్మా యదా సమాగమిష్యతి తదా సర్వ్వం సత్యం యుష్మాన్ నేష్యతి, స స్వతః కిమపి న వదిష్యతి కిన్తు యచ్ఛ్రోష్యతి తదేవ కథయిత్వా భావికార్య్యం యుష్మాన్ జ్ఞాపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","మమ మహిమానం ప్రకాశయిష్యతి యతో మదీయాం కథాం గృహీత్వా యుష్మాన్ బోధయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","పితు ర్యద్యద్ ఆస్తే తత్ సర్వ్వం మమ తస్మాద్ కారణాద్ అవాదిషం స మదీయాం కథాం గృహీత్వా యుష్మాన్ బోధయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","కియత్కాలాత్ పరం యూయం మాం ద్రష్టుం న లప్స్యధ్వే కిన్తు కియత్కాలాత్ పరం పున ర్ద్రష్టుం లప్స్యధ్వే యతోహం పితుః సమీపం గచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","తతః శిష్యాణాం కియన్తో జనాః పరస్పరం వదితుమ్ ఆరభన్త, కియత్కాలాత్ పరం మాం ద్రష్టుం న లప్స్యధ్వే కిన్తు కియత్కాలాత్ పరం పున ర్ద్రష్టుం లప్స్యధ్వే యతోహం పితుః సమీపం గచ్ఛామి, ఇతి యద్ వాక్యమ్ అయం వదతి తత్ కిం? ");
INSERT INTO santel_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","తతః కియత్కాలాత్ పరమ్ ఇతి తస్య వాక్యం కిం? తస్య వాక్యస్యాభిప్రాయం వయం బోద్ధుం న శక్నుమస్తైరితి ");
INSERT INTO santel_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","నిగదితే యీశుస్తేషాం ప్రశ్నేచ్ఛాం జ్ఞాత్వా తేభ్యోఽకథయత్ కియత్కాలాత్ పరం మాం ద్రష్టుం న లప్స్యధ్వే, కిన్తు కియత్కాలాత్ పరం పూన ర్ద్రష్టుం లప్స్యధ్వే, యామిమాం కథామకథయం తస్యా అభిప్రాయం కిం యూయం పరస్పరం మృగయధ్వే? ");
INSERT INTO santel_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","యుష్మానహమ్ అతియథార్థం వదామి యూయం క్రన్దిష్యథ విలపిష్యథ చ, కిన్తు జగతో లోకా ఆనన్దిష్యన్తి; యూయం శోకాకులా భవిష్యథ కిన్తు శోకాత్ పరం ఆనన్దయుక్తా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ప్రసవకాల ఉపస్థితే నారీ యథా ప్రసవవేదనయా వ్యాకులా భవతి కిన్తు పుత్రే భూమిష్ఠే సతి మనుష్యైకో జన్మనా నరలోకే ప్రవిష్ట ఇత్యానన్దాత్ తస్యాస్తత్సర్వ్వం దుఃఖం మనసి న తిష్ఠతి, ");
INSERT INTO santel_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","తథా యూయమపి సామ్ప్రతం శోకాకులా భవథ కిన్తు పునరపి యుష్మభ్యం దర్శనం దాస్యామి తేన యుష్మాకమ్ అన్తఃకరణాని సానన్దాని భవిష్యన్తి, యుష్మాకం తమ్ ఆనన్దఞ్చ కోపి హర్త్తుం న శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","తస్మిన్ దివసే కామపి కథాం మాం న ప్రక్ష్యథ| యుష్మానహమ్ అతియథార్థం వదామి, మమ నామ్నా యత్ కిఞ్చిద్ పితరం యాచిష్యధ్వే తదేవ స దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","పూర్వ్వే మమ నామ్నా కిమపి నాయాచధ్వం, యాచధ్వం తతః ప్రాప్స్యథ తస్మాద్ యుష్మాకం సమ్పూర్ణానన్దో జనిష్యతే| ");
INSERT INTO santel_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ఉపమాకథాభిః సర్వ్వాణ్యేతాని యుష్మాన్ జ్ఞాపితవాన్ కిన్తు యస్మిన్ సమయే ఉపమయా నోక్త్వా పితుః కథాం స్పష్టం జ్ఞాపయిష్యామి సమయ ఏతాదృశ ఆగచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","తదా మమ నామ్నా ప్రార్థయిష్యధ్వే ఽహం యుష్మన్నిమిత్తం పితరం వినేష్యే కథామిమాం న వదామి; ");
INSERT INTO santel_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","యతో యూయం మయి ప్రేమ కురుథ, తథాహమ్ ఈశ్వరస్య సమీపాద్ ఆగతవాన్ ఇత్యపి ప్రతీథ, తస్మాద్ కారణాత్ కారణాత్ పితా స్వయం యుష్మాసు ప్రీయతే| ");
INSERT INTO santel_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","పితుః సమీపాజ్జజద్ ఆగతోస్మి జగత్ పరిత్యజ్య చ పునరపి పితుః సమీపం గచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","తదా శిష్యా అవదన్, హే ప్రభో భవాన్ ఉపమయా నోక్త్వాధునా స్పష్టం వదతి| ");
INSERT INTO santel_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","భవాన్ సర్వ్వజ్ఞః కేనచిత్ పృష్టో భవితుమపి భవతః ప్రయోజనం నాస్తీత్యధునాస్మాకం స్థిరజ్ఞానం జాతం తస్మాద్ భవాన్ ఈశ్వరస్య సమీపాద్ ఆగతవాన్ ఇత్యత్ర వయం విశ్వసిమః| ");
INSERT INTO santel_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","తతో యీశుః ప్రత్యవాదీద్ ఇదానీం కిం యూయం విశ్వసిథ? ");
INSERT INTO santel_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","పశ్యత సర్వ్వే యూయం వికీర్ణాః సన్తో మామ్ ఏకాకినం పీరత్యజ్య స్వం స్వం స్థానం గమిష్యథ, ఏతాదృశః సమయ ఆగచ్ఛతి వరం ప్రాయేణోపస్థితవాన్; తథాప్యహం నైకాకీ భవామి యతః పితా మయా సార్ద్ధమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","యథా మయా యుష్మాకం శాన్తి ర్జాయతే తదర్థమ్ ఏతాః కథా యుష్మభ్యమ్ అచకథం; అస్మిన్ జగతి యుష్మాకం క్లేశో ఘటిష్యతే కిన్త్వక్షోభా భవత యతో మయా జగజ్జితం| ");
INSERT INTO santel_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","తతః పరం యీశురేతాః కథాః కథయిత్వా స్వర్గం విలోక్యైతత్ ప్రార్థయత్, హే పితః సమయ ఉపస్థితవాన్; యథా తవ పుత్రస్తవ మహిమానం ప్రకాశయతి తదర్థం త్వం నిజపుత్రస్య మహిమానం ప్రకాశయ| ");
INSERT INTO santel_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","త్వం యోల్లోకాన్ తస్య హస్తే సమర్పితవాన్ స యథా తేభ్యోఽనన్తాయు ర్దదాతి తదర్థం త్వం ప్రాణిమాత్రాణామ్ అధిపతిత్వభారం తస్మై దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","యస్త్వమ్ అద్వితీయః సత్య ఈశ్వరస్త్వయా ప్రేరితశ్చ యీశుః ఖ్రీష్ట ఏతయోరుభయోః పరిచయే ప్రాప్తేఽనన్తాయు ర్భవతి| ");
INSERT INTO santel_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","త్వం యస్య కర్మ్మణో భారం మహ్యం దత్తవాన్, తత్ సమ్పన్నం కృత్వా జగత్యస్మిన్ తవ మహిమానం ప్రాకాశయం| ");
INSERT INTO santel_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","అతఏవ హే పిత ర్జగత్యవిద్యమానే త్వయా సహ తిష్ఠతో మమ యో మహిమాసీత్ సమ్ప్రతి తవ సమీపే మాం తం మహిమానం ప్రాపయ| ");
INSERT INTO santel_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","అన్యచ్చ త్వమ్ ఏతజ్జగతో యాల్లోకాన్ మహ్యమ్ అదదా అహం తేభ్యస్తవ నామ్నస్తత్త్వజ్ఞానమ్ అదదాం, తే తవైవాసన్, త్వం తాన్ మహ్యమదదాః, తస్మాత్తే తవోపదేశమ్ అగృహ్లన్| ");
INSERT INTO santel_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","త్వం మహ్యం యత్ కిఞ్చిద్ అదదాస్తత్సర్వ్వం త్వత్తో జాయతే ఇత్యధునాజానన్| ");
INSERT INTO santel_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","మహ్యం యముపదేశమ్ అదదా అహమపి తేభ్యస్తముపదేశమ్ అదదాం తేపి తమగృహ్లన్ త్వత్తోహం నిర్గత్య త్వయా ప్రేరితోభవమ్ అత్ర చ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","తేషామేవ నిమిత్తం ప్రార్థయేఽహం జగతో లోకనిమిత్తం న ప్రార్థయే కిన్తు యాల్లోకాన్ మహ్యమ్ అదదాస్తేషామేవ నిమిత్తం ప్రార్థయేఽహం యతస్తే తవైవాసతే| ");
INSERT INTO santel_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","యే మమ తే తవ యే చ తవ తే మమ తథా తై ర్మమ మహిమా ప్రకాశ్యతే| ");
INSERT INTO santel_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","సామ్ప్రతమ్ అస్మిన్ జగతి మమావస్థితేః శేషమ్ అభవత్ అహం తవ సమీపం గచ్ఛామి కిన్తు తే జగతి స్థాస్యన్తి; హే పవిత్ర పితరావయో ర్యథైకత్వమాస్తే తథా తేషామప్యేకత్వం భవతి తదర్థం యాల్లోకాన్ మహ్యమ్ అదదాస్తాన్ స్వనామ్నా రక్ష| ");
INSERT INTO santel_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","యావన్తి దినాని జగత్యస్మిన్ తైః సహాహమాసం తావన్తి దినాని తాన్ తవ నామ్నాహం రక్షితవాన్; యాల్లోకాన్ మహ్యమ్ అదదాస్తాన్ సర్వ్వాన్ అహమరక్షం, తేషాం మధ్యే కేవలం వినాశపాత్రం హారితం తేన ధర్మ్మపుస్తకస్య వచనం ప్రత్యక్షం భవతి| ");
INSERT INTO santel_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","కిన్త్వధునా తవ సన్నిధిం గచ్ఛామి మయా యథా తేషాం సమ్పూర్ణానన్దో భవతి తదర్థమహం జగతి తిష్ఠన్ ఏతాః కథా అకథయమ్| ");
INSERT INTO santel_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","తవోపదేశం తేభ్యోఽదదాం జగతా సహ యథా మమ సమ్బన్ధో నాస్తి తథా జజతా సహ తేషామపి సమ్బన్ధాభావాజ్ జగతో లోకాస్తాన్ ఋతీయన్తే| ");
INSERT INTO santel_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","త్వం జగతస్తాన్ గృహాణేతి న ప్రార్థయే కిన్త్వశుభాద్ రక్షేతి ప్రార్థయేహమ్| ");
INSERT INTO santel_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","అహం యథా జగత్సమ్బన్ధీయో న భవామి తథా తేపి జగత్సమ్బన్ధీయా న భవన్తి| ");
INSERT INTO santel_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","తవ సత్యకథయా తాన్ పవిత్రీకురు తవ వాక్యమేవ సత్యం| ");
INSERT INTO santel_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","త్వం యథా మాం జగతి ప్రైరయస్తథాహమపి తాన్ జగతి ప్రైరయం| ");
INSERT INTO santel_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","తేషాం హితార్థం యథాహం స్వం పవిత్రీకరోమి తథా సత్యకథయా తేపి పవిత్రీభవన్తు| ");
INSERT INTO santel_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","కేవలం ఏతేషామర్థే ప్రార్థయేఽహమ్ ఇతి న కిన్త్వేతేషాముపదేశేన యే జనా మయి విశ్వసిష్యన్తి తేషామప్యర్థే ప్రార్థేయేఽహమ్| ");
INSERT INTO santel_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","హే పితస్తేషాం సర్వ్వేషామ్ ఏకత్వం భవతు తవ యథా మయి మమ చ యథా త్వయ్యేకత్వం తథా తేషామప్యావయోరేకత్వం భవతు తేన త్వం మాం ప్రేరితవాన్ ఇతి జగతో లోకాః ప్రతియన్తు| ");
INSERT INTO santel_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","యథావయోరేకత్వం తథా తేషామప్యేకత్వం భవతు తేష్వహం మయి చ త్వమ్ ఇత్థం తేషాం సమ్పూర్ణమేకత్వం భవతు, త్వం ప్రేరితవాన్ త్వం మయి యథా ప్రీయసే చ తథా తేష్వపి ప్రీతవాన్ ఏతద్యథా జగతో లోకా జానన్తి ");
INSERT INTO santel_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","తదర్థం త్వం యం మహిమానం మహ్యమ్ అదదాస్తం మహిమానమ్ అహమపి తేభ్యో దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","హే పిత ర్జగతో నిర్మ్మాణాత్ పూర్వ్వం మయి స్నేహం కృత్వా యం మహిమానం దత్తవాన్ మమ తం మహిమానం యథా తే పశ్యన్తి తదర్థం యాల్లోకాన్ మహ్యం దత్తవాన్ అహం యత్ర తిష్ఠామి తేపి యథా తత్ర తిష్ఠన్తి మమైషా వాఞ్ఛా| ");
INSERT INTO santel_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","హే యథార్థిక పిత ర్జగతో లోకైస్త్వయ్యజ్ఞాతేపి త్వామహం జానే త్వం మాం ప్రేరితవాన్ ఇతీమే శిష్యా జానన్తి| ");
INSERT INTO santel_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","యథాహం తేషు తిష్ఠామి తథా మయి యేన ప్రేమ్నా ప్రేమాకరోస్తత్ తేషు తిష్ఠతి తదర్థం తవ నామాహం తాన్ జ్ఞాపితవాన్ పునరపి జ్ఞాపయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","తాః కథాః కథయిత్వా యీశుః శిష్యానాదాయ కిద్రోన్నామకం స్రోత ఉత్తీర్య్య శిష్యైః సహ తత్రత్యోద్యానం ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","కిన్తు విశ్వాసఘాతియిహూదాస్తత్ స్థానం పరిచీయతే యతో యీశుః శిష్యైః సార్ద్ధం కదాచిత్ తత్ స్థానమ్ అగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","తదా స యిహూదాః సైన్యగణం ప్రధానయాజకానాం ఫిరూశినాఞ్చ పదాతిగణఞ్చ గృహీత్వా ప్రదీపాన్ ఉల్కాన్ అస్త్రాణి చాదాయ తస్మిన్ స్థాన ఉపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","స్వం ప్రతి యద్ ఘటిష్యతే తజ్ జ్ఞాత్వా యీశురగ్రేసరః సన్ తానపృచ్ఛత్ కం గవేషయథ? ");
INSERT INTO santel_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","తే ప్రత్యవదన్, నాసరతీయం యీశుం; తతో యీశురవాదీద్ అహమేవ సః; తైః సహ విశ్వాసఘాతీ యిహూదాశ్చాతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","తదాహమేవ స తస్యైతాం కథాం శ్రుత్వైవ తే పశ్చాదేత్య భూమౌ పతితాః| ");
INSERT INTO santel_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","తతో యీశుః పునరపి పృష్ఠవాన్ కం గవేషయథ? తతస్తే ప్రత్యవదన్ నాసరతీయం యీశుం| ");
INSERT INTO santel_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","తదా యీశుః ప్రత్యుదితవాన్ అహమేవ స ఇమాం కథామచకథమ్; యది మామన్విచ్ఛథ తర్హీమాన్ గన్తుం మా వారయత| ");
INSERT INTO santel_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ఇత్థం భూతే మహ్యం యాల్లోకాన్ అదదాస్తేషామ్ ఏకమపి నాహారయమ్ ఇమాం యాం కథాం స స్వయమకథయత్ సా కథా సఫలా జాతా| ");
INSERT INTO santel_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","తదా శిమోన్పితరస్య నికటే ఖఙ్గల్స్థితేః స తం నిష్కోషం కృత్వా మహాయాజకస్య మాల్ఖనామానం దాసమ్ ఆహత్య తస్య దక్షిణకర్ణం ఛిన్నవాన్| ");
INSERT INTO santel_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","తతో యీశుః పితరమ్ అవదత్, ఖఙ్గం కోషే స్థాపయ మమ పితా మహ్యం పాతుం యం కంసమ్ అదదాత్ తేనాహం కిం న పాస్యామి? ");
INSERT INTO santel_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","తదా సైన్యగణః సేనాపతి ర్యిహూదీయానాం పదాతయశ్చ యీశుం ఘృత్వా బద్ధ్వా హానన్నామ్నః కియఫాః శ్వశురస్య సమీపం ప్రథమమ్ అనయన్| ");
INSERT INTO santel_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","స కియఫాస్తస్మిన్ వత్సరే మహాయాజత్వపదే నియుక్తః ");
INSERT INTO santel_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","సన్ సాధారణలోకానాం మఙ్గలార్థమ్ ఏకజనస్య మరణముచితమ్ ఇతి యిహూదీయైః సార్ద్ధమ్ అమన్త్రయత్| ");
INSERT INTO santel_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","తదా శిమోన్పితరోఽన్యైకశిష్యశ్చ యీశోః పశ్చాద్ అగచ్ఛతాం తస్యాన్యశిష్యస్య మహాయాజకేన పరిచితత్వాత్ స యీశునా సహ మహాయాజకస్యాట్టాలికాం ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","కిన్తు పితరో బహిర్ద్వారస్య సమీపేఽతిష్ఠద్ అతఏవ మహాయాజకేన పరిచితః స శిష్యః పునర్బహిర్గత్వా దౌవాయికాయై కథయిత్వా పితరమ్ అభ్యన్తరమ్ ఆనయత్| ");
INSERT INTO santel_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","తదా స ద్వారరక్షికా పితరమ్ అవదత్ త్వం కిం న తస్య మానవస్య శిష్యః? తతః సోవదద్ అహం న భవామి| ");
INSERT INTO santel_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","తతః పరం యత్స్థానే దాసాః పదాతయశ్చ శీతహేతోరఙ్గారై ర్వహ్నిం ప్రజ్వాల్య తాపం సేవితవన్తస్తత్స్థానే పితరస్తిష్ఠన్ తైః సహ వహ్నితాపం సేవితుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","తదా శిష్యేషూపదేశే చ మహాయాజకేన యీశుః పృష్టః ");
INSERT INTO santel_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","సన్ ప్రత్యుక్తవాన్ సర్వ్వలోకానాం సమక్షం కథామకథయం గుప్తం కామపి కథాం న కథయిత్వా యత్ స్థానం యిహూదీయాః సతతం గచ్ఛన్తి తత్ర భజనగేహే మన్దిరే చాశిక్షయం| ");
INSERT INTO santel_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","మత్తః కుతః పృచ్ఛసి? యే జనా మదుపదేశమ్ అశృణ్వన్ తానేవ పృచ్ఛ యద్యద్ అవదం తే తత్ జానిన్త| ");
INSERT INTO santel_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","తదేత్థం ప్రత్యుదితత్వాత్ నికటస్థపదాతి ర్యీశుం చపేటేనాహత్య వ్యాహరత్ మహాయాజకమ్ ఏవం ప్రతివదసి? ");
INSERT INTO santel_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","తతో యీశుః ప్రతిగదితవాన్ యద్యయథార్థమ్ అచకథం తర్హి తస్యాయథార్థస్య ప్రమాణం దేహి, కిన్తు యది యథార్థం తర్హి కుతో హేతో ర్మామ్ అతాడయః? ");
INSERT INTO santel_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","పూర్వ్వం హానన్ సబన్ధనం తం కియఫామహాయాజకస్య సమీపం ప్రైషయత్| ");
INSERT INTO santel_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","శిమోన్పితరస్తిష్ఠన్ వహ్నితాపం సేవతే, ఏతస్మిన్ సమయే కియన్తస్తమ్ అపృచ్ఛన్ త్వం కిమ్ ఏతస్య జనస్య శిష్యో న? తతః సోపహ్నుత్యాబ్రవీద్ అహం న భవామి| ");
INSERT INTO santel_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","తదా మహాయాజకస్య యస్య దాసస్య పితరః కర్ణమచ్ఛినత్ తస్య కుటుమ్బః ప్రత్యుదితవాన్ ఉద్యానే తేన సహ తిష్ఠన్తం త్వాం కిం నాపశ్యం? ");
INSERT INTO santel_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","కిన్తు పితరః పునరపహ్నుత్య కథితవాన్; తదానీం కుక్కుటోఽరౌత్| ");
INSERT INTO santel_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","తదనన్తరం ప్రత్యూషే తే కియఫాగృహాద్ అధిపతే ర్గృహం యీశుమ్ అనయన్ కిన్తు యస్మిన్ అశుచిత్వే జాతే తై ర్నిస్తారోత్సవే న భోక్తవ్యం, తస్య భయాద్ యిహూదీయాస్తద్గృహం నావిశన్| ");
INSERT INTO santel_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","అపరం పీలాతో బహిరాగత్య తాన్ పృష్ఠవాన్ ఏతస్య మనుష్యస్య కం దోషం వదథ? ");
INSERT INTO santel_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","తదా తే పేత్యవదన్ దుష్కర్మ్మకారిణి న సతి భవతః సమీపే నైనం సమార్పయిష్యామః| ");
INSERT INTO santel_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","తతః పీలాతోఽవదద్ యూయమేనం గృహీత్వా స్వేషాం వ్యవస్థయా విచారయత| తదా యిహూదీయాః ప్రత్యవదన్ కస్యాపి మనుష్యస్య ప్రాణదణ్డం కర్త్తుం నాస్మాకమ్ అధికారోఽస్తి| ");
INSERT INTO santel_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ఏవం సతి యీశుః స్వస్య మృత్యౌ యాం కథాం కథితవాన్ సా సఫలాభవత్| ");
INSERT INTO santel_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","తదనన్తరం పీలాతః పునరపి తద్ రాజగృహం గత్వా యీశుమాహూయ పృష్టవాన్ త్వం కిం యిహూదీయానాం రాజా? ");
INSERT INTO santel_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","యీశుః ప్రత్యవదత్ త్వమ్ ఏతాం కథాం స్వతః కథయసి కిమన్యః కశ్చిన్ మయి కథితవాన్? ");
INSERT INTO santel_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","పీలాతోఽవదద్ అహం కిం యిహూదీయః? తవ స్వదేశీయా విశేషతః ప్రధానయాజకా మమ నికటే త్వాం సమార్పయన, త్వం కిం కృతవాన్? ");
INSERT INTO santel_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","యీశుః ప్రత్యవదత్ మమ రాజ్యమ్ ఏతజ్జగత్సమ్బన్ధీయం న భవతి యది మమ రాజ్యం జగత్సమ్బన్ధీయమ్ అభవిష్యత్ తర్హి యిహూదీయానాం హస్తేషు యథా సమర్పితో నాభవం తదర్థం మమ సేవకా అయోత్స్యన్ కిన్తు మమ రాజ్యమ్ ఐహికం న| ");
INSERT INTO santel_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","తదా పీలాతః కథితవాన్, తర్హి త్వం రాజా భవసి? యీశుః ప్రత్యుక్తవాన్ త్వం సత్యం కథయసి, రాజాహం భవామి; సత్యతాయాం సాక్ష్యం దాతుం జనిం గృహీత్వా జగత్యస్మిన్ అవతీర్ణవాన్, తస్మాత్ సత్యధర్మ్మపక్షపాతినో మమ కథాం శృణ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","తదా సత్యం కిం? ఏతాం కథాం పష్ట్వా పీలాతః పునరపి బహిర్గత్వా యిహూదీయాన్ అభాషత, అహం తస్య కమప్యపరాధం న ప్రాప్నోమి| ");
INSERT INTO santel_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","నిస్తారోత్సవసమయే యుష్మాభిరభిరుచిత ఏకో జనో మయా మోచయితవ్య ఏషా యుష్మాకం రీతిరస్తి, అతఏవ యుష్మాకం నికటే యిహూదీయానాం రాజానం కిం మోచయామి, యుష్మాకమ్ ఇచ్ఛా కా? ");
INSERT INTO santel_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","తదా తే సర్వ్వే రువన్తో వ్యాహరన్ ఏనం మానుషం నహి బరబ్బాం మోచయ| కిన్తు స బరబ్బా దస్యురాసీత్| ");
INSERT INTO santel_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","పీలాతో యీశుమ్ ఆనీయ కశయా ప్రాహారయత్| ");
INSERT INTO santel_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","పశ్చాత్ సేనాగణః కణ్టకనిర్మ్మితం ముకుటం తస్య మస్తకే సమర్ప్య వార్త్తాకీవర్ణం రాజపరిచ్ఛదం పరిధాప్య, ");
INSERT INTO santel_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","హే యిహూదీయానాం రాజన్ నమస్కార ఇత్యుక్త్వా తం చపేటేనాహన్తుమ్ ఆరభత| ");
INSERT INTO santel_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","తదా పీలాతః పునరపి బహిర్గత్వా లోకాన్ అవదత్, అస్య కమప్యపరాధం న లభేఽహం, పశ్యత తద్ యుష్మాన్ జ్ఞాపయితుం యుష్మాకం సన్నిధౌ బహిరేనమ్ ఆనయామి| ");
INSERT INTO santel_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","తతః పరం యీశుః కణ్టకముకుటవాన్ వార్త్తాకీవర్ణవసనవాంశ్చ బహిరాగచ్ఛత్| తతః పీలాత ఉక్తవాన్ ఏనం మనుష్యం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","తదా ప్రధానయాజకాః పదాతయశ్చ తం దృష్ట్వా, ఏనం క్రుశే విధ, ఏనం క్రుశే విధ, ఇత్యుక్త్వా రవితుం ఆరభన్త| తతః పీలాతః కథితవాన్ యూయం స్వయమ్ ఏనం నీత్వా క్రుశే విధత, అహమ్ ఏతస్య కమప్యపరాధం న ప్రాప్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","యిహూదీయాః ప్రత్యవదన్ అస్మాకం యా వ్యవస్థాస్తే తదనుసారేణాస్య ప్రాణహననమ్ ఉచితం యతోయం స్వమ్ ఈశ్వరస్య పుత్రమవదత్| ");
INSERT INTO santel_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","పీలాత ఇమాం కథాం శ్రుత్వా మహాత్రాసయుక్తః ");
INSERT INTO santel_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","సన్ పునరపి రాజగృహ ఆగత్య యీశుం పృష్టవాన్ త్వం కుత్రత్యో లోకః? కిన్తు యీశస్తస్య కిమపి ప్రత్యుత్తరం నావదత్| ");
INSERT INTO santel_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1॰ తతః పీలాత్ కథితవాన త్వం కిం మయా సార్ద్ధం న సంలపిష్యసి ? త్వాం క్రుశే వేధితుం వా మోచయితుం శక్తి ర్మమాస్తే ఇతి కిం త్వం న జానాసి ? తదా యీశుః ప్రత్యవదద్ ఈశ్వరేణాదŸाం మమోపరి తవ కిమప్యధిపతిత్వం న విద్యతే, తథాపి యో జనో మాం తవ హస్తే సమార్పయత్ తస్య మహాపాతకం జాతమ్| ");
INSERT INTO santel_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","తదా యీశుః ప్రత్యవదద్ ఈశ్వరేణాదత్తం మమోపరి తవ కిమప్యధిపతిత్వం న విద్యతే, తథాపి యో జనో మాం తవ హస్తే సమార్పయత్ తస్య మహాపాతకం జాతమ్| ");
INSERT INTO santel_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","తదారభ్య పీలాతస్తం మోచయితుం చేష్టితవాన్ కిన్తు యిహూదీయా రువన్తో వ్యాహరన్ యదీమం మానవం త్యజసి తర్హి త్వం కైసరస్య మిత్రం న భవసి, యో జనః స్వం రాజానం వక్తి సఏవ కైమరస్య విరుద్ధాం కథాం కథయతి| ");
INSERT INTO santel_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ఏతాం కథాం శ్రుత్వా పీలాతో యీశుం బహిరానీయ నిస్తారోత్సవస్య ఆసాదనదినస్య ద్వితీయప్రహరాత్ పూర్వ్వం ప్రస్తరబన్ధననామ్ని స్థానే ఽర్థాత్ ఇబ్రీయభాషయా యద్ గబ్బిథా కథ్యతే తస్మిన్ స్థానే విచారాసన ఉపావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","అనన్తరం పీలాతో యిహూదీయాన్ అవదత్, యుష్మాకం రాజానం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","కిన్తు ఏనం దూరీకురు, ఏనం దూరీకురు, ఏనం క్రుశే విధ, ఇతి కథాం కథయిత్వా తే రవితుమ్ ఆరభన్త; తదా పీలాతః కథితవాన్ యుష్మాకం రాజానం కిం క్రుశే వేధిష్యామి? ప్రధానయాజకా ఉత్తరమ్ అవదన్ కైసరం వినా కోపి రాజాస్మాకం నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","తతః పీలాతో యీశుం క్రుశే వేధితుం తేషాం హస్తేషు సమార్పయత్, తతస్తే తం ధృత్వా నీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","తతః పరం యీశుః క్రుశం వహన్ శిరఃకపాలమ్ అర్థాద్ యద్ ఇబ్రీయభాషయా గుల్గల్తాం వదన్తి తస్మిన్ స్థాన ఉపస్థితః| ");
INSERT INTO santel_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","తతస్తే మధ్యస్థానే తం తస్యోభయపార్శ్వే ద్వావపరౌ క్రుశేఽవిధన్| ");
INSERT INTO santel_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","అపరమ్ ఏష యిహూదీయానాం రాజా నాసరతీయయీశుః, ఇతి విజ్ఞాపనం లిఖిత్వా పీలాతస్తస్య క్రుశోపరి సమయోజయత్| ");
INSERT INTO santel_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","సా లిపిః ఇబ్రీయయూనానీయరోమీయభాషాభి ర్లిఖితా; యీశోః క్రుశవేధనస్థానం నగరస్య సమీపం, తస్మాద్ బహవో యిహూదీయాస్తాం పఠితుమ్ ఆరభన్త| ");
INSERT INTO santel_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","యిహూదీయానాం ప్రధానయాజకాః పీలాతమితి న్యవేదయన్ యిహూదీయానాం రాజేతి వాక్యం న కిన్తు ఏష స్వం యిహూదీయానాం రాజానమ్ అవదద్ ఇత్థం లిఖతు| ");
INSERT INTO santel_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","తతః పీలాత ఉత్తరం దత్తవాన్ యల్లేఖనీయం తల్లిఖితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ఇత్థం సేనాగణో యీశుం క్రుశే విధిత్వా తస్య పరిధేయవస్త్రం చతురో భాగాన్ కృత్వా ఏకైకసేనా ఏకైకభాగమ్ అగృహ్లత్ తస్యోత్తరీయవస్త్రఞ్చాగృహ్లత్| కిన్తూత్తరీయవస్త్రం సూచిసేవనం వినా సర్వ్వమ్ ఊతం| ");
INSERT INTO santel_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","తస్మాత్తే వ్యాహరన్ ఏతత్ కః ప్రాప్స్యతి? తన్న ఖణ్డయిత్వా తత్ర గుటికాపాతం కరవామ| విభజన్తేఽధరీయం మే వసనం తే పరస్పరం| మమోత్తరీయవస్త్రార్థం గుటికాం పాతయన్తి చ| ఇతి యద్వాక్యం ధర్మ్మపుస్తకే లిఖితమాస్తే తత్ సేనాగణేనేత్థం వ్యవహరణాత్ సిద్ధమభవత్| ");
INSERT INTO santel_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","తదానీం యీశో ర్మాతా మాతు ర్భగినీ చ యా క్లియపా భార్య్యా మరియమ్ మగ్దలీనీ మరియమ్ చ ఏతాస్తస్య క్రుశస్య సన్నిధౌ సమతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","తతో యీశుః స్వమాతరం ప్రియతమశిష్యఞ్చ సమీపే దణ్డాయమానౌ విలోక్య మాతరమ్ అవదత్, హే యోషిద్ ఏనం తవ పుత్రం పశ్య, ");
INSERT INTO santel_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","శిష్యన్త్వవదత్, ఏనాం తవ మాతరం పశ్య| తతః స శిష్యస్తద్ఘటికాయాం తాం నిజగృహం నీతవాన్| ");
INSERT INTO santel_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","అనన్తరం సర్వ్వం కర్మ్మాధునా సమ్పన్నమభూత్ యీశురితి జ్ఞాత్వా ధర్మ్మపుస్తకస్య వచనం యథా సిద్ధం భవతి తదర్థమ్ అకథయత్ మమ పిపాసా జాతా| ");
INSERT INTO santel_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","తతస్తస్మిన్ స్థానే అమ్లరసేన పూర్ణపాత్రస్థిత్యా తే స్పఞ్జమేకం తదమ్లరసేనార్ద్రీకృత్య ఏసోబ్నలే తద్ యోజయిత్వా తస్య ముఖస్య సన్నిధావస్థాపయన్| ");
INSERT INTO santel_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","తదా యీశురమ్లరసం గృహీత్వా సర్వ్వం సిద్ధమ్ ఇతి కథాం కథయిత్వా మస్తకం నమయన్ ప్రాణాన్ పర్య్యత్యజత్| ");
INSERT INTO santel_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","తద్వినమ్ ఆసాదనదినం తస్మాత్ పరేఽహని విశ్రామవారే దేహా యథా క్రుశోపరి న తిష్ఠన్తి, యతః స విశ్రామవారో మహాదినమాసీత్, తస్మాద్ యిహూదీయాః పీలాతనికటం గత్వా తేషాం పాదభఞ్జనస్య స్థానాన్తరనయనస్య చానుమతిం ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","అతః సేనా ఆగత్య యీశునా సహ క్రుశే హతయోః ప్రథమద్వితీయచోరయోః పాదాన్ అభఞ్జన్; ");
INSERT INTO santel_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","కిన్తు యీశోః సన్నిధిం గత్వా స మృత ఇతి దృష్ట్వా తస్య పాదౌ నాభఞ్జన్| ");
INSERT INTO santel_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","పశ్చాద్ ఏకో యోద్ధా శూలాఘాతేన తస్య కుక్షిమ్ అవిధత్ తత్క్షణాత్ తస్మాద్ రక్తం జలఞ్చ నిరగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","యో జనోఽస్య సాక్ష్యం దదాతి స స్వయం దృష్టవాన్ తస్యేదం సాక్ష్యం సత్యం తస్య కథా యుష్మాకం విశ్వాసం జనయితుం యోగ్యా తత్ స జానాతి| ");
INSERT INTO santel_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","తస్యైకమ్ అస్ధ్యపి న భంక్ష్యతే, ");
INSERT INTO santel_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","తద్వద్ అన్యశాస్త్రేపి లిఖ్యతే, యథా, \"దృష్టిపాతం కరిష్యన్తి తేఽవిధన్ యన్తు తమ్ప్రతి| \" ");
INSERT INTO santel_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","అరిమథీయనగరస్య యూషఫ్నామా శిష్య ఏక ఆసీత్ కిన్తు యిహూదీయేభ్యో భయాత్ ప్రకాశితో న భవతి; స యీశో ర్దేహం నేతుం పీలాతస్యానుమతిం ప్రార్థయత, తతః పీలాతేనానుమతే సతి స గత్వా యీశో ర్దేహమ్ అనయత్| ");
INSERT INTO santel_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","అపరం యో నికదీమో రాత్రౌ యీశోః సమీపమ్ అగచ్ఛత్ సోపి గన్ధరసేన మిశ్రితం ప్రాయేణ పఞ్చాశత్సేటకమగురుం గృహీత్వాగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","తతస్తే యిహూదీయానాం శ్మశానే స్థాపనరీత్యనుసారేణ తత్సుగన్ధిద్రవ్యేణ సహితం తస్య దేహం వస్త్రేణావేష్టయన్| ");
INSERT INTO santel_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","అపరఞ్చ యత్ర స్థానే తం క్రుశేఽవిధన్ తస్య నికటస్థోద్యానే యత్ర కిమపి మృతదేహం కదాపి నాస్థాప్యత తాదృశమ్ ఏకం నూతనం శ్మశానమ్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","యిహూదీయానామ్ ఆసాదనదినాగమనాత్ తే తస్మిన్ సమీపస్థశ్మశానే యీశుమ్ అశాయయన్| ");
INSERT INTO santel_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","అనన్తరం సప్తాహస్య ప్రథమదినే ఽతిప్రత్యూషే ఽన్ధకారే తిష్ఠతి మగ్దలీనీ మరియమ్ తస్య శ్మశానస్య నికటం గత్వా శ్మశానస్య ముఖాత్ ప్రస్తరమపసారితమ్ అపశ్యత్| ");
INSERT INTO santel_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","పశ్చాద్ ధావిత్వా శిమోన్పితరాయ యీశోః ప్రియతమశిష్యాయ చేదమ్ అకథయత్, లోకాః శ్మశానాత్ ప్రభుం నీత్వా కుత్రాస్థాపయన్ తద్ వక్తుం న శక్నోమి| ");
INSERT INTO santel_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","అతః పితరః సోన్యశిష్యశ్చ బర్హి ర్భుత్వా శ్మశానస్థానం గన్తుమ్ ఆరభేతాం| ");
INSERT INTO santel_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ఉభయోర్ధావతోః సోన్యశిష్యః పితరం పశ్చాత్ త్యక్త్వా పూర్వ్వం శ్మశానస్థాన ఉపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","తదా ప్రహ్వీభూయ స్థాపితవస్త్రాణి దృష్టవాన్ కిన్తు న ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","అపరం శిమోన్పితర ఆగత్య శ్మశానస్థానం ప్రవిశ్య ");
INSERT INTO santel_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","స్థాపితవస్త్రాణి మస్తకస్య వస్త్రఞ్చ పృథక్ స్థానాన్తరే స్థాపితం దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","తతః శ్మశానస్థానం పూర్వ్వమ్ ఆగతో యోన్యశిష్యః సోపి ప్రవిశ్య తాదృశం దృష్టా వ్యశ్వసీత్| ");
INSERT INTO santel_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","యతః శ్మశానాత్ స ఉత్థాపయితవ్య ఏతస్య ధర్మ్మపుస్తకవచనస్య భావం తే తదా వోద్ధుం నాశన్కువన్| ");
INSERT INTO santel_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","అనన్తరం తౌ ద్వౌ శిష్యౌ స్వం స్వం గృహం పరావృత్యాగచ్ఛతామ్| ");
INSERT INTO santel_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","తతః పరం మరియమ్ శ్మశానద్వారస్య బహిః స్థిత్వా రోదితుమ్ ఆరభత తతో రుదతీ ప్రహ్వీభూయ శ్మశానం విలోక్య ");
INSERT INTO santel_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","యీశోః శయనస్థానస్య శిరఃస్థానే పదతలే చ ద్వయో ర్దిశో ద్వౌ స్వర్గీయదూతావుపవిష్టౌ సమపశ్యత్| ");
INSERT INTO santel_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","తౌ పృష్టవన్తౌ హే నారి కుతో రోదిషి? సావదత్ లోకా మమ ప్రభుం నీత్వా కుత్రాస్థాపయన్ ఇతి న జానామి| ");
INSERT INTO santel_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ఇత్యుక్త్వా ముఖం పరావృత్య యీశుం దణ్డాయమానమ్ అపశ్యత్ కిన్తు స యీశురితి సా జ్ఞాతుం నాశక్నోత్| ");
INSERT INTO santel_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","తదా యీశుస్తామ్ అపృచ్ఛత్ హే నారి కుతో రోదిషి? కం వా మృగయసే? తతః సా తమ్ ఉద్యానసేవకం జ్ఞాత్వా వ్యాహరత్, హే మహేచ్ఛ త్వం యదీతః స్థానాత్ తం నీతవాన్ తర్హి కుత్రాస్థాపయస్తద్ వద తత్స్థానాత్ తమ్ ఆనయామి| ");
INSERT INTO santel_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","తదా యీశుస్తామ్ అవదత్ హే మరియమ్| తతః సా పరావృత్య ప్రత్యవదత్ హే రబ్బూనీ అర్థాత్ హే గురో| ");
INSERT INTO santel_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","తదా యీశురవదత్ మాం మా ధర, ఇదానీం పితుః సమీపే ఊర్ద్ధ్వగమనం న కరోమి కిన్తు యో మమ యుష్మాకఞ్చ పితా మమ యుష్మాకఞ్చేశ్వరస్తస్య నికట ఊర్ద్ధ్వగమనం కర్త్తుమ్ ఉద్యతోస్మి, ఇమాం కథాం త్వం గత్వా మమ భ్రాతృగణం జ్ఞాపయ| ");
INSERT INTO santel_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","తతో మగ్దలీనీమరియమ్ తత్క్షణాద్ గత్వా ప్రభుస్తస్యై దర్శనం దత్త్వా కథా ఏతా అకథయద్ ఇతి వార్త్తాం శిష్యేభ్యోఽకథయత్| ");
INSERT INTO santel_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","తతః పరం సప్తాహస్య ప్రథమదినస్య సన్ధ్యాసమయే శిష్యా ఏకత్ర మిలిత్వా యిహూదీయేభ్యో భియా ద్వారరుద్ధమ్ అకుర్వ్వన్, ఏతస్మిన్ కాలే యీశుస్తేషాం మధ్యస్థానే తిష్ఠన్ అకథయద్ యుష్మాకం కల్యాణం భూయాత్| ");
INSERT INTO santel_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ఇత్యుక్త్వా నిజహస్తం కుక్షిఞ్చ దర్శితవాన్, తతః శిష్యాః ప్రభుం దృష్ట్వా హృష్టా అభవన్| ");
INSERT INTO santel_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","యీశుః పునరవదద్ యుష్మాకం కల్యాణం భూయాత్ పితా యథా మాం ప్రైషయత్ తథాహమపి యుష్మాన్ ప్రేషయామి| ");
INSERT INTO santel_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ఇత్యుక్త్వా స తేషాముపరి దీర్ఘప్రశ్వాసం దత్త్వా కథితవాన్ పవిత్రమ్ ఆత్మానం గృహ్లీత| ");
INSERT INTO santel_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","యూయం యేషాం పాపాని మోచయిష్యథ తే మోచయిష్యన్తే యేషాఞ్చ పాపాతి న మోచయిష్యథ తే న మోచయిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ద్వాదశమధ్యే గణితో యమజో థోమానామా శిష్యో యీశోరాగమనకాలై తైః సార్ద్ధం నాసీత్| ");
INSERT INTO santel_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","అతో వయం ప్రభూమ్ అపశ్యామేతి వాక్యేఽన్యశిష్యైరుక్తే సోవదత్, తస్య హస్తయో ర్లౌహకీలకానాం చిహ్నం న విలోక్య తచ్చిహ్నమ్ అఙ్గుల్యా న స్పృష్ట్వా తస్య కుక్షౌ హస్తం నారోప్య చాహం న విశ్వసిష్యామి| ");
INSERT INTO santel_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","అపరమ్ అష్టమేఽహ్ని గతే సతి థోమాసహితః శిష్యగణ ఏకత్ర మిలిత్వా ద్వారం రుద్ధ్వాభ్యన్తర ఆసీత్, ఏతర్హి యీశుస్తేషాం మధ్యస్థానే తిష్ఠన్ అకథయత్, యుష్మాకం కుశలం భూయాత్| ");
INSERT INTO santel_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","పశ్చాత్ థామై కథితవాన్ త్వమ్ అఙ్గులీమ్ అత్రార్పయిత్వా మమ కరౌ పశ్య కరం ప్రసార్య్య మమ కుక్షావర్పయ నావిశ్వస్య| ");
INSERT INTO santel_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","తదా థోమా అవదత్, హే మమ ప్రభో హే మదీశ్వర| ");
INSERT INTO santel_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","యీశురకథయత్, హే థోమా మాం నిరీక్ష్య విశ్వసిషి యే న దృష్ట్వా విశ్వసన్తి తఏవ ధన్యాః| ");
INSERT INTO santel_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ఏతదన్యాని పుస్తకేఽస్మిన్ అలిఖితాని బహూన్యాశ్చర్య్యకర్మ్మాణి యీశుః శిష్యాణాం పురస్తాద్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","కిన్తు యీశురీశ్వరస్యాభిషిక్తః సుత ఏవేతి యథా యూయం విశ్వసిథ విశ్వస్య చ తస్య నామ్నా పరమాయుః ప్రాప్నుథ తదర్థమ్ ఏతాని సర్వ్వాణ్యలిఖ్యన్త| ");
INSERT INTO santel_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","తతః పరం తిబిరియాజలధేస్తటే యీశుః పునరపి శిష్యేభ్యో దర్శనం దత్తవాన్ దర్శనస్యాఖ్యానమిదమ్| ");
INSERT INTO santel_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","శిమోన్పితరః యమజథోమా గాలీలీయకాన్నానగరనివాసీ నిథనేల్ సివదేః పుత్రావన్యౌ ద్వౌ శిష్యౌ చైతేష్వేకత్ర మిలితేషు శిమోన్పితరోఽకథయత్ మత్స్యాన్ ధర్తుం యామి| ");
INSERT INTO santel_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","తతస్తే వ్యాహరన్ తర్హి వయమపి త్వయా సార్ద్ధం యామః తదా తే బహిర్గతాః సన్తః క్షిప్రం నావమ్ ఆరోహన్ కిన్తు తస్యాం రజన్యామ్ ఏకమపి న ప్రాప్నువన్| ");
INSERT INTO santel_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ప్రభాతే సతి యీశుస్తటే స్థితవాన్ కిన్తు స యీశురితి శిష్యా జ్ఞాతుం నాశక్నువన్| ");
INSERT INTO santel_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","తదా యీశురపృచ్ఛత్, హే వత్సా సన్నిధౌ కిఞ్చిత్ ఖాద్యద్రవ్యమ్ ఆస్తే? తేఽవదన్ కిమపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","తదా సోఽవదత్ నౌకాయా దక్షిణపార్శ్వే జాలం నిక్షిపత తతో లప్స్యధ్వే, తస్మాత్ తై ర్నిక్షిప్తే జాలే మత్స్యా ఏతావన్తోఽపతన్ యేన తే జాలమాకృష్య నోత్తోలయితుం శక్తాః| ");
INSERT INTO santel_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","తస్మాద్ యీశోః ప్రియతమశిష్యః పితరాయాకథయత్ ఏష ప్రభు ర్భవేత్, ఏష ప్రభురితి వాచం శ్రుత్వైవ శిమోన్ నగ్నతాహేతో ర్మత్స్యధారిణ ఉత్తరీయవస్త్రం పరిధాయ హ్రదం ప్రత్యుదలమ్ఫయత్| ");
INSERT INTO santel_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","అపరే శిష్యా మత్స్యైః సార్ద్ధం జాలమ్ ఆకర్షన్తః క్షుద్రనౌకాం వాహయిత్వా కూలమానయన్ తే కూలాద్ అతిదూరే నాసన్ ద్విశతహస్తేభ్యో దూర ఆసన్ ఇత్యనుమీయతే| ");
INSERT INTO santel_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","తీరం ప్రాప్తైస్తైస్తత్ర ప్రజ్వలితాగ్నిస్తదుపరి మత్స్యాః పూపాశ్చ దృష్టాః| ");
INSERT INTO santel_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","తతో యీశురకథయద్ యాన్ మత్స్యాన్ అధరత తేషాం కతిపయాన్ ఆనయత| ");
INSERT INTO santel_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","అతః శిమోన్పితరః పరావృత్య గత్వా బృహద్భిస్త్రిపఞ్చాశదధికశతమత్స్యైః పరిపూర్ణం తజ్జాలమ్ ఆకృష్యోదతోలయత్ కిన్త్వేతావద్భి ర్మత్స్యైరపి జాలం నాఛిద్యత| ");
INSERT INTO santel_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","అనన్తరం యీశుస్తాన్ అవాదీత్ యూయమాగత్య భుంగ్ధ్వం; తదా సఏవ ప్రభురితి జ్ఞాతత్వాత్ త్వం కః? ఇతి ప్రష్టుం శిష్యాణాం కస్యాపి ప్రగల్భతా నాభవత్| ");
INSERT INTO santel_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","తతో యీశురాగత్య పూపాన్ మత్స్యాంశ్చ గృహీత్వా తేభ్యః పర్య్యవేషయత్| ");
INSERT INTO santel_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ఇత్థం శ్మశానాదుత్థానాత్ పరం యీశుః శిష్యేభ్యస్తృతీయవారం దర్శనం దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","భోజనే సమాప్తే సతి యీశుః శిమోన్పితరం పృష్టవాన్, హే యూనసః పుత్ర శిమోన్ త్వం కిమ్ ఏతేభ్యోధికం మయి ప్రీయసే? తతః స ఉదితవాన్ సత్యం ప్రభో త్వయి ప్రీయేఽహం తద్ భవాన్ జానాతి; తదా యీశురకథయత్ తర్హి మమ మేషశావకగణం పాలయ| ");
INSERT INTO santel_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","తతః స ద్వితీయవారం పృష్టవాన్ హే యూనసః పుత్ర శిమోన్ త్వం కిం మయి ప్రీయసే? తతః స ఉక్తవాన్ సత్యం ప్రభో త్వయి ప్రీయేఽహం తద్ భవాన్ జానాతి; తదా యీశురకథయత తర్హి మమ మేషగణం పాలయ| ");
INSERT INTO santel_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","పశ్చాత్ స తృతీయవారం పృష్టవాన్, హే యూనసః పుత్ర శిమోన్ త్వం కిం మయి ప్రీయసే? ఏతద్వాక్యం తృతీయవారం పృష్టవాన్ తస్మాత్ పితరో దుఃఖితో భూత్వాఽకథయత్ హే ప్రభో భవతః కిమప్యగోచరం నాస్తి త్వయ్యహం ప్రీయే తద్ భవాన్ జానాతి; తతో యీశురవదత్ తర్హి మమ మేషగణం పాలయ| ");
INSERT INTO santel_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","అహం తుభ్యం యథార్థం కథయామి యౌవనకాలే స్వయం బద్ధకటి ర్యత్రేచ్ఛా తత్ర యాతవాన్ కిన్త్వితః పరం వృద్ధే వయసి హస్తం విస్తారయిష్యసి, అన్యజనస్త్వాం బద్ధ్వా యత్ర గన్తుం తవేచ్ఛా న భవతి త్వాం ధృత్వా తత్ర నేష్యతి| ");
INSERT INTO santel_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ఫలతః కీదృశేన మరణేన స ఈశ్వరస్య మహిమానం ప్రకాశయిష్యతి తద్ బోధయితుం స ఇతి వాక్యం ప్రోక్తవాన్| ఇత్యుక్తే సతి స తమవోచత్ మమ పశ్చాద్ ఆగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","యో జనో రాత్రికాలే యీశో ర్వక్షోఽవలమ్బ్య, హే ప్రభో కో భవన్తం పరకరేషు సమర్పయిష్యతీతి వాక్యం పృష్టవాన్, తం యీశోః ప్రియతమశిష్యం పశ్చాద్ ఆగచ్ఛన్తం ");
INSERT INTO santel_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","పితరో ముఖం పరావర్త్త్య విలోక్య యీశుం పృష్టవాన్, హే ప్రభో ఏతస్య మానవస్య కీదృశీ గతి ర్భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","స ప్రత్యవదత్, మమ పునరాగమనపర్య్యన్తం యది తం స్థాపయితుమ్ ఇచ్ఛామి తత్ర తవ కిం? త్వం మమ పశ్చాద్ ఆగచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","తస్మాత్ స శిష్యో న మరిష్యతీతి భ్రాతృగణమధ్యే కింవదన్తీ జాతా కిన్తు స న మరిష్యతీతి వాక్యం యీశు ర్నావదత్ కేవలం మమ పునరాగమనపర్య్యన్తం యది తం స్థాపయితుమ్ ఇచ్ఛామి తత్ర తవ కిం? ఇతి వాక్యమ్ ఉక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","యో జన ఏతాని సర్వ్వాణి లిఖితవాన్ అత్ర సాక్ష్యఞ్చ దత్తవాన్ సఏవ స శిష్యః, తస్య సాక్ష్యం ప్రమాణమితి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","యీశురేతేభ్యోఽపరాణ్యపి బహూని కర్మ్మాణి కృతవాన్ తాని సర్వ్వాణి యద్యేకైకం కృత్వా లిఖ్యన్తే తర్హి గ్రన్థా ఏతావన్తో భవన్తి తేషాం ధారణే పృథివ్యాం స్థానం న భవతి| ఇతి||");
INSERT INTO santel_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","హే థియఫిల, యీశుః స్వమనోనీతాన్ ప్రేరితాన్ పవిత్రేణాత్మనా సమాదిశ్య యస్మిన్ దినే స్వర్గమారోహత్ యాం యాం క్రియామకరోత్ యద్యద్ ఉపాదిశచ్చ తాని సర్వ్వాణి పూర్వ్వం మయా లిఖితాని| ");
INSERT INTO santel_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","స స్వనిధనదుఃఖభోగాత్ పరమ్ అనేకప్రత్యయక్షప్రమాణౌః స్వం సజీవం దర్శయిత్వా ");
INSERT INTO santel_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","చత్వారింశద్దినాని యావత్ తేభ్యః ప్రేరితేభ్యో దర్శనం దత్త్వేశ్వరీయరాజ్యస్య వర్ణనమ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","అనన్తరం తేషాం సభాం కృత్వా ఇత్యాజ్ఞాపయత్, యూయం యిరూశాలమోఽన్యత్ర గమనమకృత్వా యస్తిన్ పిత్రాఙ్గీకృతే మమ వదనాత్ కథా అశృణుత తత్ప్రాప్తిమ్ అపేక్ష్య తిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","యోహన్ జలే మజ్జితావాన్ కిన్త్వల్పదినమధ్యే యూయం పవిత్ర ఆత్మని మజ్జితా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","పశ్చాత్ తే సర్వ్వే మిలిత్వా తమ్ అపృచ్ఛన్ హే ప్రభో భవాన్ కిమిదానీం పునరపి రాజ్యమ్ ఇస్రాయేలీయలోకానాం కరేషు సమర్పయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","తతః సోవదత్ యాన్ సర్వ్వాన్ కాలాన్ సమయాంశ్చ పితా స్వవశేఽస్థాపయత్ తాన్ జ్ఞాతృం యుష్మాకమ్ అధికారో న జాయతే| ");
INSERT INTO santel_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","కిన్తు యుష్మాసు పవిత్రస్యాత్మన ఆవిర్భావే సతి యూయం శక్తిం ప్రాప్య యిరూశాలమి సమస్తయిహూదాశోమిరోణదేశయోః పృథివ్యాః సీమాం యావద్ యావన్తో దేశాస్తేషు యర్వ్వేషు చ మయి సాక్ష్యం దాస్యథ| ");
INSERT INTO santel_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ఇతి వాక్యముక్త్వా స తేషాం సమక్షం స్వర్గం నీతోఽభవత్, తతో మేఘమారుహ్య తేషాం దృష్టేరగోచరోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","యస్మిన్ సమయే తే విహాయసం ప్రత్యనన్యదృష్ట్యా తస్య తాదృశమ్ ఊర్ద్వ్వగమనమ్ అపశ్యన్ తస్మిన్నేవ సమయే శుక్లవస్త్రౌ ద్వౌ జనౌ తేషాం సన్నిధౌ దణ్డాయమానౌ కథితవన్తౌ, ");
INSERT INTO santel_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","హే గాలీలీయలోకా యూయం కిమర్థం గగణం ప్రతి నిరీక్ష్య దణ్డాయమానాస్తిష్ఠథ? యుష్మాకం సమీపాత్ స్వర్గం నీతో యో యీశుస్తం యూయం యథా స్వర్గమ్ ఆరోహన్తమ్ అదర్శమ్ తథా స పునశ్చాగమిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","తతః పరం తే జైతుననామ్నః పర్వ్వతాద్ విశ్రామవారస్య పథః పరిమాణమ్ అర్థాత్ ప్రాయేణార్ద్ధక్రోశం దురస్థం యిరూశాలమ్నగరం పరావృత్యాగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","నగరం ప్రవిశ్య పితరో యాకూబ్ యోహన్ ఆన్ద్రియః ఫిలిపః థోమా బర్థజమయో మథిరాల్ఫీయపుత్రో యాకూబ్ ఉద్యోగాी శిమోన్ యాకూబో భ్రాతా యిహూదా ఏతే సర్వ్వే యత్ర స్థానే ప్రవసన్తి తస్మిన్ ఉపరితనప్రకోష్ఠే ప్రావిశన్| ");
INSERT INTO santel_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","పశ్చాద్ ఇమే కియత్యః స్త్రియశ్చ యీశో ర్మాతా మరియమ్ తస్య భ్రాతరశ్చైతే సర్వ్వ ఏకచిత్తీభూత సతతం వినయేన వినయేన ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","తస్మిన్ సమయే తత్ర స్థానే సాకల్యేన వింశత్యధికశతం శిష్యా ఆసన్| తతః పితరస్తేషాం మధ్యే తిష్ఠన్ ఉక్తవాన్ ");
INSERT INTO santel_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","హే భ్రాతృగణ యీశుధారిణాం లోకానాం పథదర్శకో యో యిహూదాస్తస్మిన్ దాయూదా పవిత్ర ఆత్మా యాం కథాం కథయామాస తస్యాః ప్రత్యక్షీభవనస్యావశ్యకత్వమ్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","స జనోఽస్మాకం మధ్యవర్త్తీ సన్ అస్యాః సేవాయా అంశమ్ అలభత| ");
INSERT INTO santel_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","తదనన్తరం కుకర్మ్మణా లబ్ధం యన్మూల్యం తేన క్షేత్రమేకం క్రీతమ్ అపరం తస్మిన్ అధోముఖే భృమౌ పతితే సతి తస్యోదరస్య విదీర్ణత్వాత్ సర్వ్వా నాడ్యో నిరగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ఏతాం కథాం యిరూశాలమ్నివాసినః సర్వ్వే లోకా విదాన్తి; తేషాం నిజభాషయా తత్క్షేత్రఞ్చ హకల్దామా, అర్థాత్ రక్తక్షేత్రమితి విఖ్యాతమాస్తే| ");
INSERT INTO santel_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","అన్యచ్చ, నికేతనం తదీయన్తు శున్యమేవ భవిష్యతి| తస్య దూష్యే నివాసార్థం కోపి స్థాస్యతి నైవ హి| అన్య ఏవ జనస్తస్య పదం సంప్రాప్స్యతి ధ్రువం| ఇత్థం గీతపుస్తకే లిఖితమాస్తే| ");
INSERT INTO santel_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","అతో యోహనో మజ్జనమ్ ఆరభ్యాస్మాకం సమీపాత్ ప్రభో ర్యీశోః స్వర్గారోహణదినం యావత్ సోస్మాకం మధ్యే యావన్తి దినాని యాపితవాన్ ");
INSERT INTO santel_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","తావన్తి దినాని యే మానవా అస్మాభిః సార్ద్ధం తిష్ఠన్తి తేషామ్ ఏకేన జనేనాస్మాభిః సార్ద్ధం యీశోరుత్థానే సాక్షిణా భవితవ్యం| ");
INSERT INTO santel_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","అతో యస్య రూఢి ర్యుష్టో యం బర్శబ్బేత్యుక్త్వాహూయన్తి స యూషఫ్ మతథిశ్చ ద్వావేతౌ పృథక్ కృత్వా త ఈశ్వరస్య సన్నిధౌ ప్రార్య్య కథితవన్తః, ");
INSERT INTO santel_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","హే సర్వ్వాన్తర్య్యామిన్ పరమేశ్వర, యిహూదాః సేవనప్రేరితత్వపదచ్యుతః ");
INSERT INTO santel_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","సన్ నిజస్థానమ్ అగచ్ఛత్, తత్పదం లబ్ధుమ్ ఏనయో ర్జనయో ర్మధ్యే భవతా కోఽభిరుచితస్తదస్మాన్ దర్శ్యతాం| ");
INSERT INTO santel_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","తతో గుటికాపాటే కృతే మతథిర్నిరచీయత తస్మాత్ సోన్యేషామ్ ఏకాదశానాం ప్రరితానాం మధ్యే గణితోభవత్| ");
INSERT INTO santel_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","అపరఞ్చ నిస్తారోత్సవాత్ పరం పఞ్చాశత్తమే దినే సముపస్థితే సతి తే సర్వ్వే ఏకాచిత్తీభూయ స్థాన ఏకస్మిన్ మిలితా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ఏతస్మిన్నేవ సమయేఽకస్మాద్ ఆకాశాత్ ప్రచణ్డాత్యుగ్రవాయోః శబ్దవద్ ఏకః శబ్ద ఆగత్య యస్మిన్ గృహే త ఉపావిశన్ తద్ గృహం సమస్తం వ్యాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","తతః పరం వహ్నిశిఖాస్వరూపా జిహ్వాః ప్రత్యక్షీభూయ విభక్తాః సత్యః ప్రతిజనోర్ద్ధ్వే స్థగితా అభూవన్| ");
INSERT INTO santel_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","తస్మాత్ సర్వ్వే పవిత్రేణాత్మనా పరిపూర్ణాః సన్త ఆత్మా యథా వాచితవాన్ తదనుసారేణాన్యదేశీయానాం భాషా ఉక్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","తస్మిన్ సమయే పృథివీస్థసర్వ్వదేశేభ్యో యిహూదీయమతావలమ్బినో భక్తలోకా యిరూశాలమి ప్రావసన్; ");
INSERT INTO santel_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","తస్యాః కథాయాః కింవదన్త్యా జాతత్వాత్ సర్వ్వే లోకా మిలిత్వా నిజనిజభాషయా శిష్యాణాం కథాకథనం శ్రుత్వా సముద్విగ్నా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","సర్వ్వఏవ విస్మయాపన్నా ఆశ్చర్య్యాన్వితాశ్చ సన్తః పరస్పరం ఉక్తవన్తః పశ్యత యే కథాం కథయన్తి తే సర్వ్వే గాలీలీయలోకాః కిం న భవన్తి? ");
INSERT INTO santel_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","తర్హి వయం ప్రత్యేకశః స్వస్వజన్మదేశీయభాషాభిః కథా ఏతేషాం శృణుమః కిమిదం? ");
INSERT INTO santel_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","పార్థీ-మాదీ-అరామ్నహరయిమ్దేశనివాసిమనో యిహూదా-కప్పదకియా-పన్త-ఆశియా- ");
INSERT INTO santel_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ఫ్రుగియా-పమ్ఫులియా-మిసరనివాసినః కురీణీనికటవర్త్తిలూబీయప్రదేశనివాసినో రోమనగరాద్ ఆగతా యిహూదీయలోకా యిహూదీయమతగ్రాహిణః క్రీతీయా అరాబీయాదయో లోకాశ్చ యే వయమ్ ");
INSERT INTO santel_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","అస్మాకం నిజనిజభాషాభిరేతేషామ్ ఈశ్వరీయమహాకర్మ్మవ్యాఖ్యానం శృణుమః| ");
INSERT INTO santel_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ఇత్థం తే సర్వ్వఏవ విస్మయాపన్నాః సన్దిగ్ధచిత్తాః సన్తః పరస్పరమూచుః, అస్య కో భావః? ");
INSERT INTO santel_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","అపరే కేచిత్ పరిహస్య కథితవన్త ఏతే నవీనద్రాక్షారసేన మత్తా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","తదా పితర ఏకాదశభి ర్జనైః సాకం తిష్ఠన్ తాల్లోకాన్ ఉచ్చైఃకారమ్ అవదత్, హే యిహూదీయా హే యిరూశాలమ్నివాసినః సర్వ్వే, అవధానం కృత్వా మదీయవాక్యం బుధ్యధ్వం| ");
INSERT INTO santel_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ఇదానీమ్ ఏకయామాద్ అధికా వేలా నాస్తి తస్మాద్ యూయం యద్ అనుమాథ మానవా ఇమే మద్యపానేన మత్తాస్తన్న| ");
INSERT INTO santel_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","కిన్తు యోయేల్భవిష్యద్వక్త్రైతద్వాక్యముక్తం యథా, ");
INSERT INTO santel_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ఈశ్వరః కథయామాస యుగాన్తసమయే త్వహమ్| వర్షిష్యామి స్వమాత్మానం సర్వ్వప్రాణ్యుపరి ధ్రువమ్| భావివాక్యం వదిష్యన్తి కన్యాః పుత్రాశ్చ వస్తుతః| ప్రత్యాదేశఞ్చ ప్రాప్స్యన్తి యుష్మాకం యువమానవాః| తథా ప్రాచీనలోకాస్తు స్వప్నాన్ ద్రక్ష్యన్తి నిశ్చితం| ");
INSERT INTO santel_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","వర్షిష్యామి తదాత్మానం దాసదాసీజనోపిరి| తేనైవ భావివాక్యం తే వదిష్యన్తి హి సర్వ్వశః| ");
INSERT INTO santel_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ఊర్ద్ధ్వస్థే గగణే చైవ నీచస్థే పృథివీతలే| శోణితాని బృహద్భానూన్ ఘనధూమాదికాని చ| చిహ్నాని దర్శయిష్యామి మహాశ్చర్య్యక్రియాస్తథా| ");
INSERT INTO santel_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","మహాభయానకస్యైవ తద్దినస్య పరేశితుః| పురాగమాద్ రవిః కృష్ణో రక్తశ్చన్ద్రో భవిష్యతః| ");
INSERT INTO santel_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","కిన్తు యః పరమేశస్య నామ్ని సమ్ప్రార్థయిష్యతే| సఏవ మనుజో నూనం పరిత్రాతో భవిష్యతి|| ");
INSERT INTO santel_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","అతో హే ఇస్రాయేల్వంశీయలోకాః సర్వ్వే కథాయామేతస్యామ్ మనో నిధద్ధ్వం నాసరతీయో యీశురీశ్వరస్య మనోనీతః పుమాన్ ఏతద్ ఈశ్వరస్తత్కృతైరాశ్చర్య్యాద్భుతకర్మ్మభి ర్లక్షణైశ్చ యుష్మాకం సాక్షాదేవ ప్రతిపాదితవాన్ ఇతి యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","తస్మిన్ యీశౌ ఈశ్వరస్య పూర్వ్వనిశ్చితమన్త్రణానిరూపణానుసారేణ మృత్యౌ సమర్పితే సతి యూయం తం ధృత్వా దుష్టలోకానాం హస్తైః క్రుశే విధిత్వాహత| ");
INSERT INTO santel_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","కిన్త్వీశ్వరస్తం నిధనస్య బన్ధనాన్మోచయిత్వా ఉదస్థాపయత్ యతః స మృత్యునా బద్ధస్తిష్ఠతీతి న సమ్భవతి| ");
INSERT INTO santel_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ఏతస్తిన్ దాయూదపి కథితవాన్ యథా, సర్వ్వదా మమ సాక్షాత్తం స్థాపయ పరమేశ్వరం| స్థితే మద్దక్షిణే తస్మిన్ స్ఖలిష్యామి త్వహం నహి| ");
INSERT INTO santel_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ఆనన్దిష్యతి తద్ధేతో ర్మామకీనం మనస్తు వై| ఆహ్లాదిష్యతి జిహ్వాపి మదీయా తు తథైవ చ| ప్రత్యాశయా శరీరన్తు మదీయం వైశయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","పరలోకే యతో హేతోస్త్వం మాం నైవ హి త్యక్ష్యసి| స్వకీయం పుణ్యవన్తం త్వం క్షయితుం నైవ దాస్యసి| ఏవం జీవనమార్గం త్వం మామేవ దర్శయిష్యసి| ");
INSERT INTO santel_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","స్వసమ్ముఖే య ఆనన్దో దక్షిణే స్వస్య యత్ సుఖం| అనన్తం తేన మాం పూర్ణం కరిష్యసి న సంశయః|| ");
INSERT INTO santel_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","హే భ్రాతరోఽస్మాకం తస్య పూర్వ్వపురుషస్య దాయూదః కథాం స్పష్టం కథయితుం మామ్ అనుమన్యధ్వం, స ప్రాణాన్ త్యక్త్వా శ్మశానే స్థాపితోభవద్ అద్యాపి తత్ శ్మశానమ్ అస్మాకం సన్నిధౌ విద్యతే| ");
INSERT INTO santel_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ఫలతో లౌకికభావేన దాయూదో వంశే ఖ్రీష్టం జన్మ గ్రాహయిత్వా తస్యైవ సింహాసనే సమువేష్టుం తముత్థాపయిష్యతి పరమేశ్వరః శపథం కుత్వా దాయూదః సమీప ఇమమ్ అఙ్గీకారం కృతవాన్, ");
INSERT INTO santel_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ఇతి జ్ఞాత్వా దాయూద్ భవిష్యద్వాదీ సన్ భవిష్యత్కాలీయజ్ఞానేన ఖ్రీష్టోత్థానే కథామిమాం కథయామాస యథా తస్యాత్మా పరలోకే న త్యక్ష్యతే తస్య శరీరఞ్చ న క్షేష్యతి; ");
INSERT INTO santel_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","అతః పరమేశ్వర ఏనం యీశుం శ్మశానాద్ ఉదస్థాపయత్ తత్ర వయం సర్వ్వే సాక్షిణ ఆస్మహే| ");
INSERT INTO santel_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","స ఈశ్వరస్య దక్షిణకరేణోన్నతిం ప్రాప్య పవిత్ర ఆత్మిన పితా యమఙ్గీకారం కృతవాన్ తస్య ఫలం ప్రాప్య యత్ పశ్యథ శృణుథ చ తదవర్షత్| ");
INSERT INTO santel_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","యతో దాయూద్ స్వర్గం నారురోహ కిన్తు స్వయమ్ ఇమాం కథామ్ అకథయద్ యథా, మమ ప్రభుమిదం వాక్యమవదత్ పరమేశ్వరః| ");
INSERT INTO santel_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","తవ శత్రూనహం యావత్ పాదపీఠం కరోమి న| తావత్ కాలం మదీయే త్వం దక్షవార్శ్వ ఉపావిశ| ");
INSERT INTO santel_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","అతో యం యీశుం యూయం క్రుశేఽహత పరమేశ్వరస్తం ప్రభుత్వాభిషిక్తత్వపదే న్యయుంక్తేతి ఇస్రాయేలీయా లోకా నిశ్చితం జానన్తు| ");
INSERT INTO santel_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ఏతాదృశీం కథాం శ్రుత్వా తేషాం హృదయానాం విదీర్ణత్వాత్ తే పితరాయ తదన్యప్రేరితేభ్యశ్చ కథితవన్తః, హే భ్రాతృగణ వయం కిం కరిష్యామః? ");
INSERT INTO santel_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","తతః పితరః ప్రత్యవదద్ యూయం సర్వ్వే స్వం స్వం మనః పరివర్త్తయధ్వం తథా పాపమోచనార్థం యీశుఖ్రీష్టస్య నామ్నా మజ్జితాశ్చ భవత, తస్మాద్ దానరూపం పరిత్రమ్ ఆత్మానం లప్స్యథ| ");
INSERT INTO santel_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","యతో యుష్మాకం యుష్మత్సన్తానానాఞ్చ దూరస్థసర్వ్వలోకానాఞ్చ నిమిత్తమ్ అర్థాద్ అస్మాకం ప్రభుః పరమేశ్వరో యావతో లాకాన్ ఆహ్వాస్యతి తేషాం సర్వ్వేషాం నిమిత్తమ్ అయమఙ్గీకార ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ఏతదన్యాభి ర్బహుకథాభిః ప్రమాణం దత్వాకథయత్ ఏతేభ్యో విపథగామిభ్యో వర్త్తమానలోకేభ్యః స్వాన్ రక్షత| ");
INSERT INTO santel_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","తతః పరం యే సానన్దాస్తాం కథామ్ అగృహ్లన్ తే మజ్జితా అభవన్| తస్మిన్ దివసే ప్రాయేణ త్రీణి సహస్రాణి లోకాస్తేషాం సపక్షాః సన్తః ");
INSERT INTO santel_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ప్రేరితానామ్ ఉపదేశే సఙ్గతౌ పూపభఞ్జనే ప్రార్థనాసు చ మనఃసంయోగం కృత్వాతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ప్రేరితై ర్నానాప్రకారలక్షణేషు మహాశ్చర్య్యకర్మమసు చ దర్శితేషు సర్వ్వలోకానాం భయముపస్థితం| ");
INSERT INTO santel_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","విశ్వాసకారిణః సర్వ్వ చ సహ తిష్ఠనతః| స్వేషాం సర్వ్వాః సమ్పత్తీః సాధారణ్యేన స్థాపయిత్వాభుఞ్జత| ");
INSERT INTO santel_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ఫలతో గృహాణి ద్రవ్యాణి చ సర్వ్వాణి విక్రీయ సర్వ్వేషాం స్వస్వప్రయోజనానుసారేణ విభజ్య సర్వ్వేభ్యోఽదదన్| ");
INSERT INTO santel_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","సర్వ్వ ఏకచిత్తీభూయ దినే దినే మన్దిరే సన్తిష్ఠమానా గృహే గృహే చ పూపానభఞ్జన్త ఈశ్వరస్య ధన్యవాదం కుర్వ్వన్తో లోకైః సమాదృతాః పరమానన్దేన సరలాన్తఃకరణేన భోజనం పానఞ్చకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","పరమేశ్వరో దినే దినే పరిత్రాణభాజనై ర్మణ్డలీమ్ అవర్ద్ధయత్| ");
INSERT INTO santel_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","తృతీయయామవేలాయాం సత్యాం ప్రార్థనాయాః సమయే పితరయోహనౌ సమ్భూయ మన్దిరం గచ్ఛతః| ");
INSERT INTO santel_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","తస్మిన్నేవ సమయే మన్దిరప్రవేశకానాం సమీపే భిక్షారణార్థం యం జన్మఖఞ్జమానుషం లోకా మన్దిరస్య సున్దరనామ్ని ద్వారే ప్రతిదినమ్ అస్థాపయన్ తం వహన్తస్తద్వారం ఆనయన్| ");
INSERT INTO santel_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","తదా పితరయోహనౌ మన్తిరం ప్రవేష్టుమ్ ఉద్యతౌ విలోక్య స ఖఞ్జస్తౌ కిఞ్చిద్ భిక్షితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","తస్మాద్ యోహనా సహితః పితరస్తమ్ అనన్యదృష్ట్యా నిరీక్ష్య ప్రోక్తవాన్ ఆవాం ప్రతి దృష్టిం కురు| ");
INSERT INTO santel_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","తతః స కిఞ్చిత్ ప్రాప్త్యాశయా తౌ ప్రతి దృష్టిం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","తదా పితరో గదితవాన్ మమ నికటే స్వర్ణరూప్యాది కిమపి నాస్తి కిన్తు యదాస్తే తద్ దదామి నాసరతీయస్య యీశుఖ్రీష్టస్య నామ్నా త్వముత్థాయ గమనాగమనే కురు| ");
INSERT INTO santel_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","తతః పరం స తస్య దక్షిణకరం ధృత్వా తమ్ ఉదతోలయత్; తేన తత్క్షణాత్ తస్య జనస్య పాదగుల్ఫయోః సబలత్వాత్ స ఉల్లమ్ఫ్య ప్రోత్థాయ గమనాగమనే ఽకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","తతో గమనాగమనే కుర్వ్వన్ ఉల్లమ్ఫన్ ఈశ్వరం ధన్యం వదన్ తాభ్యాం సార్ద్ధం మన్దిరం ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","తతః సర్వ్వే లోకాస్తం గమనాగమనే కుర్వ్వన్తమ్ ఈశ్వరం ధన్యం వదన్తఞ్చ విలోక్య ");
INSERT INTO santel_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","మన్దిరస్య సున్దరే ద్వారే య ఉపవిశ్య భిక్షితవాన్ సఏవాయమ్ ఇతి జ్ఞాత్వా తం ప్రతి తయా ఘటనయా చమత్కృతా విస్మయాపన్నాశ్చాభవన్| ");
INSERT INTO santel_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","యః ఖఞ్జః స్వస్థోభవత్ తేన పితరయోహనోః కరయోర్ధ్టతయోః సతోః సర్వ్వే లోకా సన్నిధిమ్ ఆగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","తద్ దృష్ట్వా పితరస్తేభ్యోఽకథయత్, హే ఇస్రాయేలీయలోకా యూయం కుతో ఽనేనాశ్చర్య్యం మన్యధ్వే? ఆవాం నిజశక్త్యా యద్వా నిజపుణ్యేన ఖఞ్జమనుష్యమేనం గమితవన్తావితి చిన్తయిత్వా ఆవాం ప్రతి కుతోఽనన్యదృష్టిం కురుథ? ");
INSERT INTO santel_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","యం యీశుం యూయం పరకరేషు సమార్పయత తతో యం పీలాతో మోచయితుమ్ ఏैచ్ఛత్ తథాపి యూయం తస్య సాక్షాన్ నాఙ్గీకృతవన్త ఇబ్రాహీమ ఇస్హాకో యాకూబశ్చేశ్వరోఽర్థాద్ అస్మాకం పూర్వ్వపురుషాణామ్ ఈశ్వరః స్వపుత్రస్య తస్య యీశో ర్మహిమానం ప్రాకాశయత్| ");
INSERT INTO santel_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","కిన్తు యూయం తం పవిత్రం ధార్మ్మికం పుమాంసం నాఙ్గీకృత్య హత్యాకారిణమేకం స్వేభ్యో దాతుమ్ అయాచధ్వం| ");
INSERT INTO santel_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","పశ్చాత్ తం జీవనస్యాధిపతిమ్ అహత కిన్త్వీశ్వరః శ్మశానాత్ తమ్ ఉదస్థాపయత తత్ర వయం సాక్షిణ ఆస్మహే| ");
INSERT INTO santel_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ఇమం యం మానుషం యూయం పశ్యథ పరిచినుథ చ స తస్య నామ్ని విశ్వాసకరణాత్ చలనశక్తిం లబ్ధవాన్ తస్మిన్ తస్య యో విశ్వాసః స తం యుష్మాకం సర్వ్వేషాం సాక్షాత్ సమ్పూర్ణరూపేణ స్వస్థమ్ అకార్షీత్| ");
INSERT INTO santel_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","హే భ్రాతరో యూయం యుష్మాకమ్ అధిపతయశ్చ అజ్ఞాత్వా కర్మ్మాణ్యేతాని కృతవన్త ఇదానీం మమైష బోధో జాయతే| ");
INSERT INTO santel_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","కిన్త్వీశ్వరః ఖ్రీష్టస్య దుఃఖభోగే భవిష్యద్వాదినాం ముఖేభ్యో యాం యాం కథాం పూర్వ్వమకథయత్ తాః కథా ఇత్థం సిద్ధా అకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","అతః స్వేషాం పాపమోచనార్థం ఖేదం కృత్వా మనాంసి పరివర్త్తయధ్వం, తస్మాద్ ఈశ్వరాత్ సాన్త్వనాప్రాప్తేః సమయ ఉపస్థాస్యతి; ");
INSERT INTO santel_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","పునశ్చ పూర్వ్వకాలమ్ ఆరభ్య ప్రచారితో యో యీశుఖ్రీష్టస్తమ్ ఈశ్వరో యుష్మాన్ ప్రతి ప్రేషయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","కిన్తు జగతః సృష్టిమారభ్య ఈశ్వరో నిజపవిత్రభవిష్యద్వాదిగణోన యథా కథితవాన్ తదనుసారేణ సర్వ్వేషాం కార్య్యాణాం సిద్ధిపర్య్యన్తం తేన స్వర్గే వాసః కర్త్తవ్యః| ");
INSERT INTO santel_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","యుష్మాకం ప్రభుః పరమేశ్వరో యుష్మాకం భ్రాతృగణమధ్యాత్ మత్సదృశం భవిష్యద్వక్తారమ్ ఉత్పాదయిష్యతి, తతః స యత్ కిఞ్చిత్ కథయిష్యతి తత్ర యూయం మనాంసి నిధద్ధ్వం| ");
INSERT INTO santel_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","కిన్తు యః కశ్చిత్ ప్రాణీ తస్య భవిష్యద్వాదినః కథాం న గ్రహీష్యతి స నిజలోకానాం మధ్యాద్ ఉచ్ఛేత్స్యతే,\" ఇమాం కథామ్ అస్మాకం పూర్వ్వపురుషేభ్యః కేవలో మూసాః కథయామాస ఇతి నహి, ");
INSERT INTO santel_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","శిమూయేల్భవిష్యద్వాదినమ్ ఆరభ్య యావన్తో భవిష్యద్వాక్యమ్ అకథయన్ తే సర్వ్వఏవ సమయస్యైతస్య కథామ్ అకథయన్| ");
INSERT INTO santel_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","యూయమపి తేషాం భవిష్యద్వాదినాం సన్తానాః, \"తవ వంశోద్భవపుంసా సర్వ్వదేశీయా లోకా ఆశిషం ప్రాప్తా భవిష్యన్తి\", ఇబ్రాహీమే కథామేతాం కథయిత్వా ఈశ్వరోస్మాకం పూర్వ్వపురుషైః సార్ద్ధం యం నియమం స్థిరీకృతవాన్ తస్య నియమస్యాధికారిణోపి యూయం భవథ| ");
INSERT INTO santel_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","అత ఈశ్వరో నిజపుత్రం యీశుమ్ ఉత్థాప్య యుష్మాకం సర్వ్వేషాం స్వస్వపాపాత్ పరావర్త్త్య యుష్మభ్యమ్ ఆశిషం దాతుం ప్రథమతస్తం యుష్మాకం నికటం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","యస్మిన్ సమయే పితరయోహనౌ లోకాన్ ఉపదిశతస్తస్మిన్ సమయే యాజకా మన్దిరస్య సేనాపతయః సిదూకీగణశ్చ ");
INSERT INTO santel_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","తయోర్ ఉపదేశకరణే ఖ్రీష్టస్యోత్థానమ్ ఉపలక్ష్య సర్వ్వేషాం మృతానామ్ ఉత్థానప్రస్తావే చ వ్యగ్రాః సన్తస్తావుపాగమన్| ");
INSERT INTO santel_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","తౌ ధృత్వా దినావసానకారణాత్ పరదినపర్య్యనన్తం రుద్ధ్వా స్థాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","తథాపి యే లోకాస్తయోరుపదేశమ్ అశృణ్వన్ తేషాం ప్రాయేణ పఞ్చసహస్రాణి జనా వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","పరేఽహని అధిపతయః ప్రాచీనా అధ్యాపకాశ్చ హానననామా మహాయాజకః ");
INSERT INTO santel_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","కియఫా యోహన్ సికన్దర ఇత్యాదయో మహాయాజకస్య జ్ఞాతయః సర్వ్వే యిరూశాలమ్నగరే మిలితాః| ");
INSERT INTO santel_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","అనన్తరం ప్రేరితౌ మధ్యే స్థాపయిత్వాపృచ్ఛన్ యువాం కయా శక్తయా వా కేన నామ్నా కర్మ్మాణ్యేతాని కురుథః? ");
INSERT INTO santel_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","తదా పితరః పవిత్రేణాత్మనా పరిపూర్ణః సన్ ప్రత్యవాదీత్, హే లోకానామ్ అధిపతిగణ హే ఇస్రాయేలీయప్రాచీనాః, ");
INSERT INTO santel_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ఏతస్య దుర్బ్బలమానుషస్య హితం యత్ కర్మ్మాక్రియత, అర్థాత్, స యేన ప్రకారేణ స్వస్థోభవత్ తచ్చేద్ అద్యావాం పృచ్ఛథ, ");
INSERT INTO santel_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","తర్హి సర్వ్వ ఇస్రాయేेలీయలోకా యూయం జానీత నాసరతీయో యో యీశుఖ్రీష్టః క్రుశే యుష్మాభిరవిధ్యత యశ్చేశ్వరేణ శ్మశానాద్ ఉత్థాపితః, తస్య నామ్నా జనోయం స్వస్థః సన్ యుష్మాకం సమ్ముఖే ప్రోత్తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","నిచేతృభి ర్యుష్మాభిరయం యః ప్రస్తరోఽవజ్ఞాతోఽభవత్ స ప్రధానకోణస్య ప్రస్తరోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","తద్భిన్నాదపరాత్ కస్మాదపి పరిత్రాణం భవితుం న శక్నోతి, యేన త్రాణం ప్రాప్యేత భూమణ్డలస్యలోకానాం మధ్యే తాదృశం కిమపి నామ నాస్తి| ");
INSERT INTO santel_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","తదా పితరయోహనోరేతాదృశీమ్ అక్షేభతాం దృష్ట్వా తావవిద్వాంసౌ నీచలోకావితి బుద్ధ్వా ఆశ్చర్య్యమ్ అమన్యన్త తౌ చ యీశోః సఙ్గినౌ జాతావితి జ్ఞాతుమ్ అశక్నువన్| ");
INSERT INTO santel_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","కిన్తు తాభ్యాం సార్ద్ధం తం స్వస్థమానుషం తిష్ఠన్తం దృష్ట్వా తే కామప్యపరామ్ ఆపత్తిం కర్త్తం నాశక్నున్| ");
INSERT INTO santel_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","తదా తే సభాతః స్థానాన్తరం గన్తుం తాన్ ఆజ్ఞాప్య స్వయం పరస్పరమ్ ఇతి మన్త్రణామకుర్వ్వన్ ");
INSERT INTO santel_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","తౌ మానవౌ ప్రతి కిం కర్త్తవ్యం? తావేకం ప్రసిద్ధమ్ ఆశ్చర్య్యం కర్మ్మ కృతవన్తౌ తద్ యిరూశాలమ్నివాసినాం సర్వ్వేషాం లోకానాం సమీపే ప్రాకాశత తచ్చ వయమపహ్నోతుం న శక్నుమః| ");
INSERT INTO santel_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","కిన్తు లోకానాం మధ్యమ్ ఏతద్ యథా న వ్యాప్నోతి తదర్థం తౌ భయం ప్రదర్శ్య తేన నామ్నా కమపి మనుష్యం నోపదిశతమ్ ఇతి దృఢం నిషేధామః| ");
INSERT INTO santel_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","తతస్తే ప్రేరితావాహూయ ఏతదాజ్ఞాపయన్ ఇతః పరం యీశో ర్నామ్నా కదాపి కామపి కథాం మా కథయతం కిమపి నోపదిశఞ్చ| ");
INSERT INTO santel_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","తతః పితరయోహనౌ ప్రత్యవదతామ్ ఈశ్వరస్యాజ్ఞాగ్రహణం వా యుష్మాకమ్ ఆజ్ఞాగ్రహణమ్ ఏతయో ర్మధ్యే ఈశ్వరస్య గోచరే కిం విహితం? యూయం తస్య వివేచనాం కురుత| ");
INSERT INTO santel_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","వయం యద్ అపశ్యామ యదశృణుమ చ తన్న ప్రచారయిష్యామ ఏతత్ కదాపి భవితుం న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","యదఘటత తద్ దృష్టా సర్వ్వే లోకా ఈశ్వరస్య గుణాన్ అన్వవదన్ తస్మాత్ లోకభయాత్ తౌ దణ్డయితుం కమప్యుపాయం న ప్రాప్య తే పునరపి తర్జయిత్వా తావత్యజన్| ");
INSERT INTO santel_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","యస్య మానుషస్యైతత్ స్వాస్థ్యకరణమ్ ఆశ్చర్య్యం కర్మ్మాక్రియత తస్య వయశ్చత్వారింశద్వత్సరా వ్యతీతాః| ");
INSERT INTO santel_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","తతః పరం తౌ విసృష్టౌ సన్తౌ స్వసఙ్గినాం సన్నిధిం గత్వా ప్రధానయాజకైః ప్రాచీనలోకైశ్చ ప్రోక్తాః సర్వ్వాః కథా జ్ఞాపితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","తచ్ఛ్రుత్వా సర్వ్వ ఏకచిత్తీభూయ ఈశ్వరముద్దిశ్య ప్రోచ్చైరేతత్ ప్రార్థయన్త, హే ప్రభో గగణపృథివీపయోధీనాం తేషు చ యద్యద్ ఆస్తే తేషాం స్రష్టేశ్వరస్త్వం| ");
INSERT INTO santel_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","త్వం నిజసేవకేన దాయూదా వాక్యమిదమ్ ఉవచిథ, మనుష్యా అన్యదేశీయాః కుర్వ్వన్తి కలహం కుతః| లోకాః సర్వ్వే కిమర్థం వా చిన్తాం కుర్వ్వన్తి నిష్ఫలాం| ");
INSERT INTO santel_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","పరమేశస్య తేనైవాభిషిక్తస్య జనస్య చ| విరుద్ధమభితిష్ఠన్తి పృథివ్యాః పతయః కుతః|| ");
INSERT INTO santel_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ఫలతస్తవ హస్తేన మన్త్రణయా చ పూర్వ్వ యద్యత్ స్థిరీకృతం తద్ యథా సిద్ధం భవతి తదర్థం త్వం యమ్ అథిషిక్తవాన్ స ఏవ పవిత్రో యీశుస్తస్య ప్రాతికూల్యేన హేరోద్ పన్తీయపీలాతో ");
INSERT INTO santel_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ఽన్యదేశీయలోకా ఇస్రాయేల్లోకాశ్చ సర్వ్వ ఏతే సభాయామ్ అతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","హే పరమేశ్వర అధునా తేషాం తర్జనం గర్జనఞ్చ శృణు; ");
INSERT INTO santel_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","తథా స్వాస్థ్యకరణకర్మ్మణా తవ బాహుబలప్రకాశపూర్వ్వకం తవ సేవకాన్ నిర్భయేన తవ వాక్యం ప్రచారయితుం తవ పవిత్రపుత్రస్య యీశో ర్నామ్నా ఆశ్చర్య్యాణ్యసమ్భవాని చ కర్మ్మాణి కర్త్తుఞ్చాజ్ఞాపయ| ");
INSERT INTO santel_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ఇత్థం ప్రార్థనయా యత్ర స్థానే తే సభాయామ్ ఆసన్ తత్ స్థానం ప్రాకమ్పత; తతః సర్వ్వే పవిత్రేణాత్మనా పరిపూర్ణాః సన్త ఈశ్వరస్య కథామ్ అక్షోభేణ ప్రాచారయన్| ");
INSERT INTO santel_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","అపరఞ్చ ప్రత్యయకారిలోకసమూహా ఏకమనస ఏకచిత్తీభూయ స్థితాః| తేషాం కేపి నిజసమ్పత్తిం స్వీయాం నాజానన్ కిన్తు తేషాం సర్వ్వాః సమ్పత్త్యః సాధారణ్యేన స్థితాః| ");
INSERT INTO santel_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","అన్యచ్చ ప్రేరితా మహాశక్తిప్రకాశపూర్వ్వకం ప్రభో ర్యీశోరుత్థానే సాక్ష్యమ్ అదదుః, తేషు సర్వ్వేషు మహానుగ్రహోఽభవచ్చ| ");
INSERT INTO santel_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","తేషాం మధ్యే కస్యాపి ద్రవ్యన్యూనతా నాభవద్ యతస్తేషాం గృహభూమ్యాద్యా యాః సమ్పత్తయ ఆసన్ తా విక్రీయ ");
INSERT INTO santel_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","తన్మూల్యమానీయ ప్రేరితానాం చరణేషు తైః స్థాపితం; తతః ప్రత్యేకశః ప్రయోజనానుసారేణ దత్తమభవత్| ");
INSERT INTO santel_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","విశేషతః కుప్రోపద్వీపీయో యోసినామకో లేవివంశజాత ఏకో జనో భూమ్యధికారీ, యం ప్రేరితా బర్ణబ్బా అర్థాత్ సాన్త్వనాదాయక ఇత్యుక్త్వా సమాహూయన్, ");
INSERT INTO santel_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","స జనో నిజభూమిం విక్రీయ తన్మూల్యమానీయ ప్రేరితానాం చరణేషు స్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","తదా అనానియనామక ఏకో జనో యస్య భార్య్యాయా నామ సఫీరా స స్వాధికారం విక్రీయ ");
INSERT INTO santel_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","స్వభార్య్యాం జ్ఞాపయిత్వా తన్మూల్యస్యైకాంశం సఙ్గోప్య స్థాపయిత్వా తదన్యాంశమాత్రమానీయ ప్రేరితానాం చరణేషు సమర్పితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","తస్మాత్ పితరోకథయత్ హే అనానియ భూమే ర్మూల్యం కిఞ్చిత్ సఙ్గోప్య స్థాపయితుం పవిత్రస్యాత్మనః సన్నిధౌ మృషావాక్యం కథయితుఞ్చ శైతాన్ కుతస్తవాన్తఃకరణే ప్రవృత్తిమజనయత్? ");
INSERT INTO santel_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","సా భూమి ర్యదా తవ హస్తగతా తదా కిం తవ స్వీయా నాసీత్? తర్హి స్వాన్తఃకరణే కుత ఏతాదృశీ కుకల్పనా త్వయా కృతా? త్వం కేవలమనుష్యస్య నికటే మృషావాక్యం నావాదీః కిన్త్వీశ్వరస్య నికటేఽపి| ");
INSERT INTO santel_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ఏతాం కథాం శ్రుత్వైవ సోఽనానియో భూమౌ పతన్ ప్రాణాన్ అత్యజత్, తద్వృత్తాన్తం యావన్తో లోకా అశృణ్వన్ తేషాం సర్వ్వేషాం మహాభయమ్ అజాయత్| ");
INSERT INTO santel_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","తదా యువలోకాస్తం వస్త్రేణాచ్ఛాద్య బహి ర్నీత్వా శ్మశానేఽస్థాపయన్| ");
INSERT INTO santel_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","తతః ప్రహరైకానన్తరం కిం వృత్తం తన్నావగత్య తస్య భార్య్యాపి తత్ర సముపస్థితా| ");
INSERT INTO santel_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","తతః పితరస్తామ్ అపృచ్ఛత్, యువాభ్యామ్ ఏతావన్ముద్రాభ్యో భూమి ర్విక్రీతా న వా? ఏతత్వం వద; తదా సా ప్రత్యవాదీత్ సత్యమ్ ఏతావద్భ్యో ముద్రాభ్య ఏవ| ");
INSERT INTO santel_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","తతః పితరోకథయత్ యువాం కథం పరమేశ్వరస్యాత్మానం పరీక్షితుమ్ ఏకమన్త్రణావభవతాం? పశ్య యే తవ పతిం శ్మశానే స్థాపితవన్తస్తే ద్వారస్య సమీపే సముపతిష్ఠన్తి త్వామపి బహిర్నేష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","తతః సాపి తస్య చరణసన్నిధౌ పతిత్వా ప్రాణాన్ అత్యాక్షీత్| పశ్చాత్ తే యువానోఽభ్యన్తరమ్ ఆగత్య తామపి మృతాం దృష్ట్వా బహి ర్నీత్వా తస్యాః పత్యుః పార్శ్వే శ్మశానే స్థాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","తస్మాత్ మణ్డల్యాః సర్వ్వే లోకా అన్యలోకాశ్చ తాం వార్త్తాం శ్రుత్వా సాధ్వసం గతాః| ");
INSERT INTO santel_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","తతః పరం ప్రేరితానాం హస్తై ర్లోకానాం మధ్యే బహ్వాశ్చర్య్యాణ్యద్భుతాని కర్మ్మాణ్యక్రియన్త; తదా శిష్యాః సర్వ్వ ఏకచిత్తీభూయ సులేమానో ఽలిన్దే సమ్భూయాసన్| ");
INSERT INTO santel_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","తేషాం సఙ్ఘాన్తర్గో భవితుం కోపి ప్రగల్భతాం నాగమత్ కిన్తు లోకాస్తాన్ సమాద్రియన్త| ");
INSERT INTO santel_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","స్త్రియః పురుషాశ్చ బహవో లోకా విశ్వాస్య ప్రభుం శరణమాపన్నాః| ");
INSERT INTO santel_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","పితరస్య గమనాగమనాభ్యాం కేనాపి ప్రకారేణ తస్య ఛాయా కస్మింశ్చిజ్జనే లగిష్యతీత్యాశయా లోకా రోగిణః శివికయా ఖట్వయా చానీయ పథి పథి స్థాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","చతుర్దిక్స్థనగరేభ్యో బహవో లోకాః సమ్భూయ రోగిణోఽపవిత్రభుతగ్రస్తాంశ్చ యిరూశాలమమ్ ఆనయన్ తతః సర్వ్వే స్వస్థా అక్రియన్త| ");
INSERT INTO santel_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","అనన్తరం మహాయాజకః సిదూకినాం మతగ్రాహిణస్తేషాం సహచరాశ్చ ");
INSERT INTO santel_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","మహాక్రోధాన్త్వితాః సన్తః ప్రేరితాన్ ధృత్వా నీచలోకానాం కారాయాం బద్ధ్వా స్థాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","కిన్తు రాత్రౌ పరమేశ్వరస్య దూతః కారాయా ద్వారం మోచయిత్వా తాన్ బహిరానీయాకథయత్, ");
INSERT INTO santel_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","యూయం గత్వా మన్దిరే దణ్డాయమానాః సన్తో లోకాన్ ప్రతీమాం జీవనదాయికాం సర్వ్వాం కథాం ప్రచారయత| ");
INSERT INTO santel_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ఇతి శ్రుత్వా తే ప్రత్యూషే మన్దిర ఉపస్థాయ ఉపదిష్టవన్తః| తదా సహచరగణేన సహితో మహాయాజక ఆగత్య మన్త్రిగణమ్ ఇస్రాయేల్వంశస్య సర్వ్వాన్ రాజసభాసదః సభాస్థాన్ కృత్వా కారాయాస్తాన్ ఆపయితుం పదాతిగణం ప్రేరితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","తతస్తే గత్వా కారాయాం తాన్ అప్రాప్య ప్రత్యాగత్య ఇతి వార్త్తామ్ అవాదిషుః, ");
INSERT INTO santel_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","వయం తత్ర గత్వా నిర్వ్విఘ్నం కారాయా ద్వారం రుద్ధం రక్షకాంశ్చ ద్వారస్య బహిర్దణ్డాయమానాన్ అదర్శామ ఏవ కిన్తు ద్వారం మోచయిత్వా తన్మధ్యే కమపి ద్రష్టుం న ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ఏతాం కథాం శ్రుత్వా మహాయాజకో మన్దిరస్య సేనాపతిః ప్రధానయాజకాశ్చ, ఇత పరం కిమపరం భవిష్యతీతి చిన్తయిత్వా సన్దిగ్ధచిత్తా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ఏతస్మిన్నేవ సమయే కశ్చిత్ జన ఆగత్య వార్త్తామేతామ్ అవదత్ పశ్యత యూయం యాన్ మానవాన్ కారాయామ్ అస్థాపయత తే మన్దిరే తిష్ఠన్తో లోకాన్ ఉపదిశన్తి| ");
INSERT INTO santel_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","తదా మన్దిరస్య సేనాపతిః పదాతయశ్చ తత్ర గత్వా చేల్లోకాః పాషాణాన్ నిక్షిప్యాస్మాన్ మారయన్తీతి భియా వినత్యాచారం తాన్ ఆనయన్| ");
INSERT INTO santel_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","తే మహాసభాయా మధ్యే తాన్ అస్థాపయన్ తతః పరం మహాయాజకస్తాన్ అపృచ్ఛత్, ");
INSERT INTO santel_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","అనేన నామ్నా సముపదేష్టుం వయం కిం దృఢం న న్యషేధామ? తథాపి పశ్యత యూయం స్వేషాం తేనోపదేశేనే యిరూశాలమం పరిపూర్ణం కృత్వా తస్య జనస్య రక్తపాతజనితాపరాధమ్ అస్మాన్ ప్రత్యానేతుం చేష్టధ్వే| ");
INSERT INTO santel_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","తతః పితరోన్యప్రేరితాశ్చ ప్రత్యవదన్ మానుషస్యాజ్ఞాగ్రహణాద్ ఈశ్వరస్యాజ్ఞాగ్రహణమ్ అస్మాకముచితమ్| ");
INSERT INTO santel_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","యం యీశుం యూయం క్రుశే వేధిత్వాహత తమ్ అస్మాకం పైతృక ఈశ్వర ఉత్థాప్య ");
INSERT INTO santel_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ఇస్రాయేల్వంశానాం మనఃపరివర్త్తనం పాపక్షమాఞ్చ కర్త్తుం రాజానం పరిత్రాతారఞ్చ కృత్వా స్వదక్షిణపార్శ్వే తస్యాన్నతిమ్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ఏతస్మిన్ వయమపి సాక్షిణ ఆస్మహే, తత్ కేవలం నహి, ఈశ్వర ఆజ్ఞాగ్రాహిభ్యో యం పవిత్రమ్ ఆత్మనం దత్తవాన్ సోపి సాక్ష్యస్తి| ");
INSERT INTO santel_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ఏతద్వాక్యే శ్రుతే తేషాం హృదయాని విద్ధాన్యభవన్ తతస్తే తాన్ హన్తుం మన్త్రితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ఏతస్మిన్నేవ సమయే తత్సభాస్థానాం సర్వ్వలోకానాం మధ్యే సుఖ్యాతో గమిలీయేల్నామక ఏకో జనో వ్యవస్థాపకః ఫిరూశిలోక ఉత్థాయ ప్రేరితాన్ క్షణార్థం స్థానాన్తరం గన్తుమ్ ఆదిశ్య కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","హే ఇస్రాయేల్వంశీయాః సర్వ్వే యూయమ్ ఏతాన్ మానుషాన్ ప్రతి యత్ కర్త్తుమ్ ఉద్యతాస్తస్మిన్ సావధానా భవత| ");
INSERT INTO santel_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ఇతః పూర్వ్వం థూదానామైకో జన ఉపస్థాయ స్వం కమపి మహాపురుషమ్ అవదత్, తతః ప్రాయేణ చతుఃశతలోకాస్తస్య మతగ్రాహిణోభవన్ పశ్చాత్ స హతోభవత్ తస్యాజ్ఞాగ్రాహిణో యావన్తో లోకాస్తే సర్వ్వే విర్కీర్ణాః సన్తో ఽకృతకార్య్యా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","తస్మాజ్జనాత్ పరం నామలేఖనసమయే గాలీలీయయిహూదానామైకో జన ఉపస్థాయ బహూల్లోకాన్ స్వమతం గ్రాహీతవాన్ తతః సోపి వ్యనశ్యత్ తస్యాజ్ఞాగ్రాహిణో యావన్తో లోకా ఆసన్ తే సర్వ్వే వికీర్ణా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","అధునా వదామి, యూయమ్ ఏతాన్ మనుష్యాన్ ప్రతి కిమపి న కృత్వా క్షాన్తా భవత, యత ఏష సఙ్కల్ప ఏతత్ కర్మ్మ చ యది మనుష్యాదభవత్ తర్హి విఫలం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","యదీశ్వరాదభవత్ తర్హి యూయం తస్యాన్యథా కర్త్తుం న శక్ష్యథ, వరమ్ ఈశ్వరరోధకా భవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","తదా తస్య మన్త్రణాం స్వీకృత్య తే ప్రేరితాన్ ఆహూయ ప్రహృత్య యీశో ర్నామ్నా కామపి కథాం కథయితుం నిషిధ్య వ్యసర్జన్| ");
INSERT INTO santel_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","కిన్తు తస్య నామార్థం వయం లజ్జాభోగస్య యోగ్యత్వేన గణితా ఇత్యత్ర తే సానన్దాః సన్తః సభాస్థానాం సాక్షాద్ అగచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","తతః పరం ప్రతిదినం మన్దిరే గృహే గృహే చావిశ్రామమ్ ఉపదిశ్య యీశుఖ్రీష్టస్య సుసంవాదం ప్రచారితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","తస్మిన్ సమయే శిష్యాణాం బాహుల్యాత్ ప్రాత్యహికదానస్య విశ్రాణనై ర్భిన్నదేశీయానాం విధవాస్త్రీగణ ఉపేక్షితే సతి ఇబ్రీయలోకైః సహాన్యదేశీయానాం వివాద ఉపాతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","తదా ద్వాదశప్రేరితాః సర్వ్వాన్ శిష్యాన్ సంగృహ్యాకథయన్ ఈశ్వరస్య కథాప్రచారం పరిత్యజ్య భోజనగవేషణమ్ అస్మాకమ్ ఉచితం నహి| ");
INSERT INTO santel_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","అతో హే భ్రాతృగణ వయమ్ ఏతత్కర్మ్మణో భారం యేభ్యో దాతుం శక్నుమ ఏతాదృశాన్ సుఖ్యాత్యాపన్నాన్ పవిత్రేణాత్మనా జ్ఞానేన చ పూర్ణాన్ సప్ప్రజనాన్ యూయం స్వేషాం మధ్యే మనోనీతాన్ కురుత, ");
INSERT INTO santel_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","కిన్తు వయం ప్రార్థనాయాం కథాప్రచారకర్మ్మణి చ నిత్యప్రవృత్తాః స్థాస్యామః| ");
INSERT INTO santel_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ఏతస్యాం కథాయాం సర్వ్వే లోకాః సన్తుష్టాః సన్తః స్వేషాం మధ్యాత్ స్తిఫానః ఫిలిపః ప్రఖరో నికానోర్ తీమన్ పర్మ్మిణా యిహూదిమతగ్రాహీ-ఆన్తియఖియానగరీయో నికలా ఏతాన్ పరమభక్తాన్ పవిత్రేణాత్మనా పరిపూర్ణాన్ సప్త జనాన్ ");
INSERT INTO santel_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ప్రేరితానాం సమక్షమ్ ఆనయన్, తతస్తే ప్రార్థనాం కృత్వా తేషాం శిరఃసు హస్తాన్ ఆర్పయన్| ");
INSERT INTO santel_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","అపరఞ్చ ఈశ్వరస్య కథా దేశం వ్యాప్నోత్ విశేషతో యిరూశాలమి నగరే శిష్యాణాం సంఖ్యా ప్రభూతరూపేణావర్ద్ధత యాజకానాం మధ్యేపి బహవః ఖ్రీష్టమతగ్రాహిణోఽభవన్| ");
INSERT INTO santel_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","స్తిఫానోे విశ్వాసేన పరాక్రమేణ చ పరిపూర్ణః సన్ లోకానాం మధ్యే బహువిధమ్ అద్భుతమ్ ఆశ్చర్య్యం కర్మ్మాకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","తేన లిబర్త్తినీయనామ్నా విఖ్యాతసఙ్ఘస్య కతిపయజనాః కురీణీయసికన్దరీయ-కిలికీయాశీయాదేశీయాః కియన్తో జనాశ్చోత్థాయ స్తిఫానేన సార్ద్ధం వ్యవదన్త| ");
INSERT INTO santel_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","కిన్తు స్తిఫానో జ్ఞానేన పవిత్రేణాత్మనా చ ఈదృశీం కథాం కథితవాన్ యస్యాస్తే ఆపత్తిం కర్త్తుం నాశక్నువన్| ");
INSERT INTO santel_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","పశ్చాత్ తై ర్లోభితాః కతిపయజనాః కథామేనామ్ అకథయన్, వయం తస్య ముఖతో మూసా ఈశ్వరస్య చ నిన్దావాక్యమ్ అశ్రౌష్మ| ");
INSERT INTO santel_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","తే లోకానాం లోకప్రాచీనానామ్ అధ్యాపకానాఞ్చ ప్రవృత్తిం జనయిత్వా స్తిఫానస్య సన్నిధిమ్ ఆగత్య తం ధృత్వా మహాసభామధ్యమ్ ఆనయన్| ");
INSERT INTO santel_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","తదనన్తరం కతిపయజనేషు మిథ్యాసాక్షిషు సమానీతేషు తేఽకథయన్ ఏష జన ఏతత్పుణ్యస్థానవ్యవస్థయో ర్నిన్దాతః కదాపి న నివర్త్తతే| ");
INSERT INTO santel_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ఫలతో నాసరతీయయీశుః స్థానమేతద్ ఉచ్ఛిన్నం కరిష్యతి మూసాసమర్పితమ్ అస్మాకం వ్యవహరణమ్ అన్యరూపం కరిష్యతి తస్యైతాదృశీం కథాం వయమ్ అశృణుమ| ");
INSERT INTO santel_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","తదా మహాసభాస్థాః సర్వ్వే తం ప్రతి స్థిరాం దృష్టిం కృత్వా స్వర్గదూతముఖసదృశం తస్య ముఖమ్ అపశ్యన్| ");
INSERT INTO santel_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","తతః పరం మహాయాజకః పృష్టవాన్, ఏషా కథాం కిం సత్యా? ");
INSERT INTO santel_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","తతః స ప్రత్యవదత్, హే పితరో హే భ్రాతరః సర్వ్వే లాకా మనాంసి నిధద్ధ్వం| అస్మాకం పూర్వ్వపురుష ఇబ్రాహీమ్ హారణ్నగరే వాసకరణాత్ పూర్వ్వం యదా అరామ్-నహరయిమదేశే ఆసీత్ తదా తేజోమయ ఈశ్వరో దర్శనం దత్వా ");
INSERT INTO santel_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","తమవదత్ త్వం స్వదేశజ్ఞాతిమిత్రాణి పరిత్యజ్య యం దేశమహం దర్శయిష్యామి తం దేశం వ్రజ| ");
INSERT INTO santel_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","అతః స కస్దీయదేశం విహాయ హారణ్నగరే న్యవసత్, తదనన్తరం తస్య పితరి మృతే యత్ర దేశే యూయం నివసథ స ఏనం దేశమాగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","కిన్త్వీశ్వరస్తస్మై కమప్యధికారమ్ అర్థాద్ ఏకపదపరిమితాం భూమిమపి నాదదాత్; తదా తస్య కోపి సన్తానో నాసీత్ తథాపి సన్తానైః సార్ద్ధమ్ ఏతస్య దేశస్యాధికారీ త్వం భవిష్యసీతి తమ్ప్రత్యఙ్గీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ఈశ్వర ఇత్థమ్ అపరమపి కథితవాన్ తవ సన్తానాః పరదేశే నివత్స్యన్తి తతస్తద్దేశీయలోకాశ్చతుఃశతవత్సరాన్ యావత్ తాన్ దాసత్వే స్థాపయిత్వా తాన్ ప్రతి కువ్యవహారం కరిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","అపరమ్ ఈశ్వర ఏనాం కథామపి కథితవాన్, యే లోకాస్తాన్ దాసత్వే స్థాపయిష్యన్తి తాల్లోకాన్ అహం దణ్డయిష్యామి, తతః పరం తే బహిర్గతాః సన్తో మామ్ అత్ర స్థానే సేవిష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","పశ్చాత్ స తస్మై త్వక్ఛేదస్య నియమం దత్తవాన్, అత ఇస్హాకనామ్ని ఇబ్రాహీమ ఏకపుత్రే జాతే, అష్టమదినే తస్య త్వక్ఛేదమ్ అకరోత్| తస్య ఇస్హాకః పుత్రో యాకూబ్, తతస్తస్య యాకూబోఽస్మాకం ద్వాదశ పూర్వ్వపురుషా అజాయన్త| ");
INSERT INTO santel_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","తే పూర్వ్వపురుషా ఈర్ష్యయా పరిపూర్ణా మిసరదేశం ప్రేషయితుం యూషఫం వ్యక్రీణన్| ");
INSERT INTO santel_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","కిన్త్వీశ్వరస్తస్య సహాయో భూత్వా సర్వ్వస్యా దుర్గతే రక్షిత్వా తస్మై బుద్ధిం దత్త్వా మిసరదేశస్య రాజ్ఞః ఫిరౌణః ప్రియపాత్రం కృతవాన్ తతో రాజా మిసరదేశస్య స్వీయసర్వ్వపరివారస్య చ శాసనపదం తస్మై దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","తస్మిన్ సమయే మిసర-కినానదేశయో ర్దుర్భిక్షహేతోరతిక్లిష్టత్వాత్ నః పూర్వ్వపురుషా భక్ష్యద్రవ్యం నాలభన్త| ");
INSERT INTO santel_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","కిన్తు మిసరదేశే శస్యాని సన్తి, యాకూబ్ ఇమాం వార్త్తాం శ్రుత్వా ప్రథమమ్ అస్మాకం పూర్వ్వపురుషాన్ మిసరం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","తతో ద్వితీయవారగమనే యూషఫ్ స్వభ్రాతృభిః పరిచితోఽభవత్; యూషఫో భ్రాతరః ఫిరౌణ్ రాజేన పరిచితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","అనన్తరం యూషఫ్ భ్రాతృగణం ప్రేష్య నిజపితరం యాకూబం నిజాన్ పఞ్చాధికసప్తతిసంఖ్యకాన్ జ్ఞాతిజనాంశ్చ సమాహూతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","తస్మాద్ యాకూబ్ మిసరదేశం గత్వా స్వయమ్ అస్మాకం పూర్వ్వపురుషాశ్చ తస్మిన్ స్థానేఽమ్రియన్త| ");
INSERT INTO santel_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","తతస్తే శిఖిమం నీతా యత్ శ్మశానమ్ ఇబ్రాహీమ్ ముద్రాదత్వా శిఖిమః పితు ర్హమోరః పుత్రేభ్యః క్రీతవాన్ తత్శ్మశానే స్థాపయాఞ్చక్రిరే| ");
INSERT INTO santel_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","తతః పరమ్ ఈశ్వర ఇబ్రాహీమః సన్నిధౌ శపథం కృత్వా యాం ప్రతిజ్ఞాం కృతవాన్ తస్యాః ప్రతిజ్ఞాయాః ఫలనసమయే నికటే సతి ఇస్రాయేల్లోకా సిమరదేశే వర్ద్ధమానా బహుసంఖ్యా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","శేషే యూషఫం యో న పరిచినోతి తాదృశ ఏకో నరపతిరుపస్థాయ ");
INSERT INTO santel_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","అస్మాకం జ్ఞాతిభిః సార్ద్ధం ధూర్త్తతాం విధాయ పూర్వ్వపురుషాన్ ప్రతి కువ్యవహరణపూర్వ్వకం తేషాం వంశనాశనాయ తేషాం నవజాతాన్ శిశూన్ బహి ర్నిరక్షేపయత్| ");
INSERT INTO santel_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ఏతస్మిన్ సమయే మూసా జజ్ఞే, స తు పరమసున్దరోఽభవత్ తథా పితృగృహే మాసత్రయపర్య్యన్తం పాలితోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","కిన్తు తస్మిన్ బహిర్నిక్షిప్తే సతి ఫిరౌణరాజస్య కన్యా తమ్ ఉత్తోల్య నీత్వా దత్తకపుత్రం కృత్వా పాలితవతీ| ");
INSERT INTO santel_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","తస్మాత్ స మూసా మిసరదేశీయాయాః సర్వ్వవిద్యాయాః పారదృష్వా సన్ వాక్యే క్రియాయాఞ్చ శక్తిమాన్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","స సమ్పూర్ణచత్వారింశద్వత్సరవయస్కో భూత్వా ఇస్రాయేలీయవంశనిజభ్రాతృన్ సాక్షాత్ కర్తుం మతిం చక్రే| ");
INSERT INTO santel_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","తేషాం జనమేకం హింసితం దృష్ట్వా తస్య సపక్షః సన్ హింసితజనమ్ ఉపకృత్య మిసరీయజనం జఘాన| ");
INSERT INTO santel_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","తస్య హస్తేనేశ్వరస్తాన్ ఉద్ధరిష్యతి తస్య భ్రాతృగణ ఇతి జ్ఞాస్యతి స ఇత్యనుమానం చకార, కిన్తు తే న బుబుధిరే| ");
INSERT INTO santel_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","తత్పరే ఽహని తేషామ్ ఉభయో ర్జనయో ర్వాక్కలహ ఉపస్థితే సతి మూసాః సమీపం గత్వా తయో ర్మేలనం కర్త్తుం మతిం కృత్వా కథయామాస, హే మహాశయౌ యువాం భ్రాతరౌ పరస్పరమ్ అన్యాయం కుతః కురుథః? ");
INSERT INTO santel_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","తతః సమీపవాసినం ప్రతి యో జనోఽన్యాయం చకార స తం దూరీకృత్య కథయామాస, అస్మాకముపరి శాస్తృత్వవిచారయితృత్వపదయోః కస్త్వాం నియుక్తవాన్? ");
INSERT INTO santel_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","హ్యో యథా మిసరీయం హతవాన్ తథా కిం మామపి హనిష్యసి? ");
INSERT INTO santel_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","తదా మూసా ఏతాదృశీం కథాం శ్రుత్వా పలాయనం చక్రే, తతో మిదియనదేశం గత్వా ప్రవాసీ సన్ తస్థౌ, తతస్తత్ర ద్వౌ పుత్రౌ జజ్ఞాతే| ");
INSERT INTO santel_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","అనన్తరం చత్వారింశద్వత్సరేషు గతేషు సీనయపర్వ్వతస్య ప్రాన్తరే ప్రజ్వలితస్తమ్బస్య వహ్నిశిఖాయాం పరమేశ్వరదూతస్తస్మై దర్శనం దదౌ| ");
INSERT INTO santel_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","మూసాస్తస్మిన్ దర్శనే విస్మయం మత్వా విశేషం జ్ఞాతుం నికటం గచ్ఛతి, ");
INSERT INTO santel_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ఏతస్మిన్ సమయే, అహం తవ పూర్వ్వపురుషాణామ్ ఈశ్వరోఽర్థాద్ ఇబ్రాహీమ ఈశ్వర ఇస్హాక ఈశ్వరో యాకూబ ఈశ్వరశ్చ, మూసాముద్దిశ్య పరమేశ్వరస్యైతాదృశీ విహాయసీయా వాణీ బభూవ, తతః స కమ్పాన్వితః సన్ పున ర్నిరీక్షితుం ప్రగల్భో న బభూవ| ");
INSERT INTO santel_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","పరమేశ్వరస్తం జగాద, తవ పాదయోః పాదుకే మోచయ యత్ర తిష్ఠసి సా పవిత్రభూమిః| ");
INSERT INTO santel_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","అహం మిసరదేశస్థానాం నిజలోకానాం దుర్ద్దశాం నితాన్తమ్ అపశ్యం, తేషాం కాతర్య్యోక్తిఞ్చ శ్రుతవాన్ తస్మాత్ తాన్ ఉద్ధర్త్తుమ్ అవరుహ్యాగమమ్; ఇదానీమ్ ఆగచ్ఛ మిసరదేశం త్వాం ప్రేషయామి| ");
INSERT INTO santel_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","కస్త్వాం శాస్తృత్వవిచారయితృత్వపదయో ర్నియుక్తవాన్, ఇతి వాక్యముక్త్వా తై ర్యో మూసా అవజ్ఞాతస్తమేవ ఈశ్వరః స్తమ్బమధ్యే దర్శనదాత్రా తేన దూతేన శాస్తారం ముక్తిదాతారఞ్చ కృత్వా ప్రేషయామాస| ");
INSERT INTO santel_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","స చ మిసరదేశే సూఫ్నామ్ని సముద్రే చ పశ్చాత్ చత్వారింశద్వత్సరాన్ యావత్ మహాప్రాన్తరే నానాప్రకారాణ్యద్భుతాని కర్మ్మాణి లక్షణాని చ దర్శయిత్వా తాన్ బహిః కృత్వా సమానినాయ| ");
INSERT INTO santel_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ప్రభుః పరమేశ్వరో యుష్మాకం భ్రాతృగణస్య మధ్యే మాదృశమ్ ఏకం భవిష్యద్వక్తారమ్ ఉత్పాదయిష్యతి తస్య కథాయాం యూయం మనో నిధాస్యథ, యో జన ఇస్రాయేలః సన్తానేభ్య ఏనాం కథాం కథయామాస స ఏష మూసాః| ");
INSERT INTO santel_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","మహాప్రాన్తరస్థమణ్డలీమధ్యేఽపి స ఏవ సీనయపర్వ్వతోపరి తేన సార్ద్ధం సంలాపినో దూతస్య చాస్మత్పితృగణస్య మధ్యస్థః సన్ అస్మభ్యం దాతవ్యని జీవనదాయకాని వాక్యాని లేభే| ");
INSERT INTO santel_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","అస్మాకం పూర్వ్వపురుషాస్తమ్ అమాన్యం కత్వా స్వేభ్యో దూరీకృత్య మిసరదేశం పరావృత్య గన్తుం మనోభిరభిలష్య హారోణం జగదుః, ");
INSERT INTO santel_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","అస్మాకమ్ అగ్రేఽగ్రే గన్తుुమ్ అస్మదర్థం దేవగణం నిర్మ్మాహి యతో యో మూసా అస్మాన్ మిసరదేశాద్ బహిః కృత్వానీతవాన్ తస్య కిం జాతం తదస్మాభి ర్న జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","తస్మిన్ సమయే తే గోవత్సాకృతిం ప్రతిమాం నిర్మ్మాయ తాముద్దిశ్య నైవేద్యముత్మృజ్య స్వహస్తకృతవస్తునా ఆనన్దితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","తస్మాద్ ఈశ్వరస్తేషాం ప్రతి విముఖః సన్ ఆకాశస్థం జ్యోతిర్గణం పూజయితుం తేభ్యోఽనుమతిం దదౌ, యాదృశం భవిష్యద్వాదినాం గ్రన్థేషు లిఖితమాస్తే, యథా, ఇస్రాయేలీయవంశా రే చత్వారింశత్సమాన్ పురా| మహతి ప్రాన్తరే సంస్థా యూయన్తు యాని చ| బలిహోమాదికర్మ్మాణి కృతవన్తస్తు తాని కిం| మాం సముద్దిశ్య యుష్మాభిః ప్రకృతానీతి నైవ చ| ");
INSERT INTO santel_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","కిన్తు వో మోలకాఖ్యస్య దేవస్య దూష్యమేవ చ| యుష్మాకం రిమ్ఫనాఖ్యాయా దేవతాయాశ్చ తారకా| ఏతయోరుభయో ర్మూర్తీ యుష్మాభిః పరిపూజితే| అతో యుష్మాంస్తు బాబేలః పారం నేష్యామి నిశ్చితం| ");
INSERT INTO santel_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","అపరఞ్చ యన్నిదర్శనమ్ అపశ్యస్తదనుసారేణ దూష్యం నిర్మ్మాహి యస్మిన్ ఈశ్వరో మూసామ్ ఏతద్వాక్యం బభాషే తత్ తస్య నిరూపితం సాక్ష్యస్వరూపం దూష్యమ్ అస్మాకం పూర్వ్వపురుషైః సహ ప్రాన్తరే తస్థౌ| ");
INSERT INTO santel_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","పశ్చాత్ యిహోశూయేన సహితైస్తేషాం వంశజాతైరస్మత్పూర్వ్వపురుషైః స్వేషాం సమ్ముఖాద్ ఈశ్వరేణ దూరీకృతానామ్ అన్యదేశీయానాం దేశాధికృతికాలే సమానీతం తద్ దూష్యం దాయూదోధికారం యావత్ తత్ర స్థాన ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","స దాయూద్ పరమేశ్వరస్యానుగ్రహం ప్రాప్య యాకూబ్ ఈశ్వరార్థమ్ ఏకం దూష్యం నిర్మ్మాతుం వవాఞ్ఛ; ");
INSERT INTO santel_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","కిన్తు సులేమాన్ తదర్థం మన్దిరమ్ ఏకం నిర్మ్మితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","తథాపి యః సర్వ్వోపరిస్థః స కస్మింశ్చిద్ హస్తకృతే మన్దిరే నివసతీతి నహి, భవిష్యద్వాదీ కథామేతాం కథయతి, యథా, ");
INSERT INTO santel_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","పరేశో వదతి స్వర్గో రాజసింహాసనం మమ| మదీయం పాదపీఠఞ్చ పృథివీ భవతి ధ్రువం| తర్హి యూయం కృతే మే కిం ప్రనిర్మ్మాస్యథ మన్దిరం| విశ్రామాయ మదీయం వా స్థానం కిం విద్యతే త్విహ| ");
INSERT INTO santel_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","సర్వ్వాణ్యేతాని వస్తూని కిం మే హస్తకృతాని న|| ");
INSERT INTO santel_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","హే అనాజ్ఞాగ్రాహకా అన్తఃకరణే శ్రవణే చాపవిత్రలోకాః యూయమ్ అనవరతం పవిత్రస్యాత్మనః ప్రాతికూల్యమ్ ఆచరథ, యుష్మాకం పూర్వ్వపురుషా యాదృశా యూయమపి తాదృశాః| ");
INSERT INTO santel_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","యుష్మాకం పూర్వ్వపురుషాః కం భవిష్యద్వాదినం నాతాడయన్? యే తస్య ధార్మ్మికస్య జనస్యాగమనకథాం కథితవన్తస్తాన్ అఘ్నన్ యూయమ్ అధూనా విశ్వాసఘాతినో భూత్వా తం ధార్మ్మికం జనమ్ అహత| ");
INSERT INTO santel_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","యూయం స్వర్గీయదూతగణేన వ్యవస్థాం ప్రాప్యాపి తాం నాచరథ| ");
INSERT INTO santel_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ఇమాం కథాం శ్రుత్వా తే మనఃసు బిద్ధాః సన్తస్తం ప్రతి దన్తఘర్షణమ్ అకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","కిన్తు స్తిఫానః పవిత్రేణాత్మనా పూర్ణో భూత్వా గగణం ప్రతి స్థిరదృష్టిం కృత్వా ఈశ్వరస్య దక్షిణే దణ్డాయమానం యీశుఞ్చ విలోక్య కథితవాన్; ");
INSERT INTO santel_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","పశ్య,మేఘద్వారం ముక్తమ్ ఈశ్వరస్య దక్షిణే స్థితం మానవసుతఞ్చ పశ్యామి| ");
INSERT INTO santel_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","తదా తే ప్రోచ్చైః శబ్దం కృత్వా కర్ణేష్వఙ్గులీ ర్నిధాయ ఏకచిత్తీభూయ తమ్ ఆక్రమన్| ");
INSERT INTO santel_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","పశ్చాత్ తం నగరాద్ బహిః కృత్వా ప్రస్తరైరాఘ్నన్ సాక్షిణో లాకాః శౌలనామ్నో యూనశ్చరణసన్నిధౌ నిజవస్త్రాణి స్థాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","అనన్తరం హే ప్రభో యీశే మదీయమాత్మానం గృహాణ స్తిఫానస్యేతి ప్రార్థనవాక్యవదనసమయే తే తం ప్రస్తరైరాఘ్నన్| ");
INSERT INTO santel_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","తస్మాత్ స జానునీ పాతయిత్వా ప్రోచ్చైః శబ్దం కృత్వా, హే ప్రభే పాపమేతద్ ఏతేషు మా స్థాపయ, ఇత్యుక్త్వా మహానిద్రాం ప్రాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","తస్య హత్యాకరణం శౌలోపి సమమన్యత| తస్మిన్ సమయే యిరూశాలమ్నగరస్థాం మణ్డలీం ప్రతి మహాతాడనాయాం జాతాయాం ప్రేరితలోకాన్ హిత్వా సర్వ్వేఽపరే యిహూదాశోమిరోణదేశయో ర్నానాస్థానే వికీర్ణాః సన్తో గతాః| ");
INSERT INTO santel_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","అన్యచ్చ భక్తలోకాస్తం స్తిఫానం శ్మశానే స్థాపయిత్వా బహు వ్యలపన్| ");
INSERT INTO santel_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","కిన్తు శౌలో గృహే గృహే భ్రమిత్వా స్త్రియః పురుషాంశ్చ ధృత్వా కారాయాం బద్ధ్వా మణ్డల్యా మహోత్పాతం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","అన్యచ్చ యే వికీర్ణా అభవన్ తే సర్వ్వత్ర భ్రమిత్వా సుసంవాదం ప్రాచారయన్| ");
INSERT INTO santel_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","తదా ఫిలిపః శోమిరోణ్నగరం గత్వా ఖ్రీష్టాఖ్యానం ప్రాచారయత్; ");
INSERT INTO santel_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","తతోఽశుచి-భృతగ్రస్తలోకేభ్యో భూతాశ్చీత్కృత్యాగచ్ఛన్ తథా బహవః పక్షాఘాతినః ఖఞ్జా లోకాశ్చ స్వస్థా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","తస్మాత్ లాకా ఈదృశం తస్యాశ్చర్య్యం కర్మ్మ విలోక్య నిశమ్య చ సర్వ్వ ఏకచిత్తీభూయ తేనోక్తాఖ్యానే మనాంసి న్యదధుః| ");
INSERT INTO santel_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","తస్మిన్నగరే మహానన్దశ్చాభవత్| ");
INSERT INTO santel_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","తతః పూర్వ్వం తస్మిన్నగరే శిమోన్నామా కశ్చిజ్జనో బహ్వీ ర్మాయాక్రియాః కృత్వా స్వం కఞ్చన మహాపురుషం ప్రోచ్య శోమిరోణీయానాం మోహం జనయామాస| ");
INSERT INTO santel_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","తస్మాత్ స మానుష ఈశ్వరస్య మహాశక్తిస్వరూప ఇత్యుక్త్వా బాలవృద్ధవనితాః సర్వ్వే లాకాస్తస్మిన్ మనాంసి న్యదధుః| ");
INSERT INTO santel_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","స బహుకాలాన్ మాయావిక్రియయా సర్వ్వాన్ అతీవ మోహయాఞ్చకార, తస్మాత్ తే తం మేనిరే| ");
INSERT INTO santel_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","కిన్త్వీశ్వరస్య రాజ్యస్య యీశుఖ్రీష్టస్య నామ్నశ్చాఖ్యానప్రచారిణః ఫిలిపస్య కథాయాం విశ్వస్య తేషాం స్త్రీపురుషోభయలోకా మజ్జితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","శేషే స శిమోనపి స్వయం ప్రత్యైత్ తతో మజ్జితః సన్ ఫిలిపేన కృతామ్ ఆశ్చర్య్యక్రియాం లక్షణఞ్చ విలోక్యాసమ్భవం మన్యమానస్తేన సహ స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ఇత్థం శోమిరోణ్దేశీయలోకా ఈశ్వరస్య కథామ్ అగృహ్లన్ ఇతి వార్త్తాం యిరూశాలమ్నగరస్థప్రేరితాః ప్రాప్య పితరం యోహనఞ్చ తేషాం నికటే ప్రేషితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","తతస్తౌ తత్ స్థానమ్ ఉపస్థాయ లోకా యథా పవిత్రమ్ ఆత్మానం ప్రాప్నువన్తి తదర్థం ప్రార్థయేతాం| ");
INSERT INTO santel_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","యతస్తే పురా కేవలప్రభుయీశో ర్నామ్నా మజ్జితమాత్రా అభవన్, న తు తేషాం మధ్యే కమపి ప్రతి పవిత్రస్యాత్మన ఆవిర్భావో జాతః| ");
INSERT INTO santel_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","కిన్తు ప్రేరితాభ్యాం తేషాం గాత్రేషు కరేష్వర్పితేషు సత్సు తే పవిత్రమ్ ఆత్మానమ్ ప్రాప్నువన్| ");
INSERT INTO santel_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ఇత్థం లోకానాం గాత్రేషు ప్రేరితయోః కరార్పణేన తాన్ పవిత్రమ్ ఆత్మానం ప్రాప్తాన్ దృష్ట్వా స శిమోన్ తయోః సమీపే ముద్రా ఆనీయ కథితవాన్; ");
INSERT INTO santel_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","అహం యస్య గాత్రే హస్తమ్ అర్పయిష్యామి తస్యాపి యథేత్థం పవిత్రాత్మప్రాప్తి ర్భవతి తాదృశీం శక్తిం మహ్యం దత్తం| ");
INSERT INTO santel_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","కిన్తు పితరస్తం ప్రత్యవదత్ తవ ముద్రాస్త్వయా వినశ్యన్తు యత ఈశ్వరస్య దానం ముద్రాభిః క్రీయతే త్వమిత్థం బుద్ధవాన్; ");
INSERT INTO santel_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ఈశ్వరాయ తావన్తఃకరణం సరలం నహి, తస్మాద్ అత్ర తవాంశోఽధికారశ్చ కోపి నాస్తి| ");
INSERT INTO santel_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","అత ఏతత్పాపహేతోః ఖేదాన్వితః సన్ కేనాపి ప్రకారేణ తవ మనస ఏతస్యాః కుకల్పనాయాః క్షమా భవతి, ఏతదర్థమ్ ఈశ్వరే ప్రార్థనాం కురు; ");
INSERT INTO santel_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","యతస్త్వం తిక్తపిత్తే పాపస్య బన్ధనే చ యదసి తన్మయా బుద్ధమ్| ");
INSERT INTO santel_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","తదా శిమోన్ అకథయత్ తర్హి యువాభ్యాముదితా కథా మయి యథా న ఫలతి తదర్థం యువాం మన్నిమిత్తం ప్రభౌ ప్రార్థనాం కురుతం| ");
INSERT INTO santel_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","అనేన ప్రకారేణ తౌ సాక్ష్యం దత్త్వా ప్రభోః కథాం ప్రచారయన్తౌ శోమిరోణీయానామ్ అనేకగ్రామేషు సుసంవాదఞ్చ ప్రచారయన్తౌ యిరూశాలమ్నగరం పరావృత్య గతౌ| ");
INSERT INTO santel_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","తతః పరమ్ ఈశ్వరస్య దూతః ఫిలిపమ్ ఇత్యాదిశత్, త్వముత్థాయ దక్షిణస్యాం దిశి యో మార్గో ప్రాన్తరస్య మధ్యేన యిరూశాలమో ఽసానగరం యాతి తం మార్గం గచ్ఛ| ");
INSERT INTO santel_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","తతః స ఉత్థాయ గతవాన్; తదా కన్దాకీనామ్నః కూశ్లోకానాం రాజ్ఞ్యాః సర్వ్వసమ్పత్తేరధీశః కూశదేశీయ ఏకః షణ్డో భజనార్థం యిరూశాలమ్నగరమ్ ఆగత్య ");
INSERT INTO santel_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","పునరపి రథమారుహ్య యిశయియనామ్నో భవిష్యద్వాదినో గ్రన్థం పఠన్ ప్రత్యాగచ్ఛతి| ");
INSERT INTO santel_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ఏతస్మిన్ సమయే ఆత్మా ఫిలిపమ్ అవదత్, త్వమ్ రథస్య సమీపం గత్వా తేన సార్ద్ధం మిల| ");
INSERT INTO santel_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","తస్మాత్ స ధావన్ తస్య సన్నిధావుపస్థాయ తేన పఠ్యమానం యిశయియథవిష్యద్వాదినో వాక్యం శ్రుత్వా పృష్టవాన్ యత్ పఠసి తత్ కిం బుధ్యసే? ");
INSERT INTO santel_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","తతః స కథితవాన్ కేనచిన్న బోధితోహం కథం బుధ్యేయ? తతః స ఫిలిపం రథమారోఢుం స్వేన సార్ద్ధమ్ ఉపవేష్టుఞ్చ న్యవేదయత్| ");
INSERT INTO santel_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","స శాస్త్రస్యేతద్వాక్యం పఠితవాన్ యథా, సమానీయత ఘాతాయ స యథా మేషశావకః| లోమచ్ఛేదకసాక్షాచ్చ మేషశ్చ నీరవో యథా| ఆబధ్య వదనం స్వీయం తథా స సమతిష్ఠత| ");
INSERT INTO santel_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","అన్యాయేన విచారేణ స ఉచ్ఛిన్నో ఽభవత్ తదా| తత్కాలీనమనుష్యాన్ కో జనో వర్ణయితుం క్షమః| యతో జీవన్నృణాం దేశాత్ స ఉచ్ఛిన్నో ఽభవత్ ధ్రువం| ");
INSERT INTO santel_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","అనన్తరం స ఫిలిపమ్ అవదత్ నివేదయామి, భవిష్యద్వాదీ యామిమాం కథాం కథయామాస స కిం స్వస్మిన్ వా కస్మింశ్చిద్ అన్యస్మిన్? ");
INSERT INTO santel_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","తతః ఫిలిపస్తత్ప్రకరణమ్ ఆరభ్య యీశోరుపాఖ్యానం తస్యాగ్రే ప్రాస్తౌత్| ");
INSERT INTO santel_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ఇత్థం మార్గేణ గచ్ఛన్తౌ జలాశయస్య సమీప ఉపస్థితౌ; తదా క్లీబోఽవాదీత్ పశ్యాత్ర స్థానే జలమాస్తే మమ మజ్జనే కా బాధా? ");
INSERT INTO santel_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","తతః ఫిలిప ఉత్తరం వ్యాహరత్ స్వాన్తఃకరణేన సాకం యది ప్రత్యేషి తర్హి బాధా నాస్తి| తతః స కథితవాన్ యీశుఖ్రీష్ట ఈశ్వరస్య పుత్ర ఇత్యహం ప్రత్యేమి| ");
INSERT INTO santel_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","తదా రథం స్థగితం కర్త్తుమ్ ఆదిష్టే ఫిలిపక్లీబౌ ద్వౌ జలమ్ అవారుహతాం; తదా ఫిలిపస్తమ్ మజ్జయామాస| ");
INSERT INTO santel_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","తత్పశ్చాత్ జలమధ్యాద్ ఉత్థితయోః సతోః పరమేశ్వరస్యాత్మా ఫిలిపం హృత్వా నీతవాన్, తస్మాత్ క్లీబః పునస్తం న దృష్టవాన్ తథాపి హృష్టచిత్తః సన్ స్వమార్గేణ గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ఫిలిపశ్చాస్దోద్నగరమ్ ఉపస్థాయ తస్మాత్ కైసరియానగర ఉపస్థితికాలపర్య్యనతం సర్వ్వస్మిన్నగరే సుసంవాదం ప్రచారయన్ గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","తత్కాలపర్య్యనతం శౌలః ప్రభోః శిష్యాణాం ప్రాతికూల్యేన తాడనాబధయోః కథాం నిఃసారయన్ మహాయాజకస్య సన్నిధిం గత్వా ");
INSERT INTO santel_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","స్త్రియం పురుషఞ్చ తన్మతగ్రాహిణం యం కఞ్చిత్ పశ్యతి తాన్ ధృత్వా బద్ధ్వా యిరూశాలమమ్ ఆనయతీత్యాశయేన దమ్మేషక్నగరీయం ధర్మ్మసమాజాన్ ప్రతి పత్రం యాచితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","గచ్ఛన్ తు దమ్మేషక్నగరనికట ఉపస్థితవాన్; తతోఽకస్మాద్ ఆకాశాత్ తస్య చతుర్దిక్షు తేజసః ప్రకాశనాత్ స భూమావపతత్| ");
INSERT INTO santel_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","పశ్చాత్ హే శౌల హే శౌల కుతో మాం తాడయసి? స్వం ప్రతి ప్రోక్తమ్ ఏతం శబ్దం శ్రుత్వా ");
INSERT INTO santel_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","స పృష్టవాన్, హే ప్రభో భవాన్ కః? తదా ప్రభురకథయత్ యం యీశుం త్వం తాడయసి స ఏవాహం; కణ్టకస్య ముఖే పదాఘాతకరణం తవ కష్టమ్| ");
INSERT INTO santel_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","తదా కమ్పమానో విస్మయాపన్నశ్చ సోవదత్ హే ప్రభో మయా కిం కర్త్తవ్యం? భవత ఇచ్ఛా కా? తతః ప్రభురాజ్ఞాపయద్ ఉత్థాయ నగరం గచ్ఛ తత్ర త్వయా యత్ కర్త్తవ్యం తద్ వదిష్యతే| ");
INSERT INTO santel_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","తస్య సఙ్గినో లోకా అపి తం శబ్దం శ్రుతవన్తః కిన్తు కమపి న దృష్ట్వా స్తబ్ధాః సన్తః స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","అనన్తరం శౌలో భూమిత ఉత్థాయ చక్షుషీ ఉన్మీల్య కమపి న దృష్టవాన్| తదా లోకాస్తస్య హస్తౌ ధృత్వా దమ్మేషక్నగరమ్ ఆనయన్| ");
INSERT INTO santel_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","తతః స దినత్రయం యావద్ అన్ధో భూత్వా న భుక్తవాన్ పీతవాంశ్చ| ");
INSERT INTO santel_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","తదనన్తరం ప్రభుస్తద్దమ్మేషక్నగరవాసిన ఏకస్మై శిష్యాయ దర్శనం దత్వా ఆహూతవాన్ హే అననియ| తతః స ప్రత్యవాదీత్, హే ప్రభో పశ్య శృణోమి| ");
INSERT INTO santel_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","తదా ప్రభుస్తమాజ్ఞాపయత్ త్వముత్థాయ సరలనామానం మార్గం గత్వా యిహూదానివేశనే తార్షనగరీయం శౌలనామానం జనం గవేషయన్ పృచ్ఛ; ");
INSERT INTO santel_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","పశ్య స ప్రార్థయతే, తథా అననియనామక ఏకో జనస్తస్య సమీపమ్ ఆగత్య తస్య గాత్రే హస్తార్పణం కృత్వా దృష్టిం దదాతీత్థం స్వప్నే దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","తస్మాద్ అననియః ప్రత్యవదత్ హే ప్రభో యిరూశాలమి పవిత్రలోకాన్ ప్రతి సోఽనేకహింసాం కృతవాన్; ");
INSERT INTO santel_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","అత్ర స్థానే చ యే లోకాస్తవ నామ్ని ప్రార్థయన్తి తానపి బద్ధుం స ప్రధానయాజకేభ్యః శక్తిం ప్రాప్తవాన్, ఇమాం కథామ్ అహమ్ అనేకేషాం ముఖేభ్యః శ్రుతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","కిన్తు ప్రభురకథయత్, యాహి భిన్నదేశీయలోకానాం భూపతీనామ్ ఇస్రాయేల్లోకానాఞ్చ నికటే మమ నామ ప్రచారయితుం స జనో మమ మనోనీతపాత్రమాస్తే| ");
INSERT INTO santel_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","మమ నామనిమిత్తఞ్చ తేన కియాన్ మహాన్ క్లేశో భోక్తవ్య ఏతత్ తం దర్శయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","తతో ఽననియో గత్వా గృహం ప్రవిశ్య తస్య గాత్రే హస్తార్ప్రణం కృత్వా కథితవాన్, హే భ్రాతః శౌల త్వం యథా దృష్టిం ప్రాప్నోషి పవిత్రేణాత్మనా పరిపూర్ణో భవసి చ, తదర్థం తవాగమనకాలే యః ప్రభుయీశుస్తుభ్యం దర్శనమ్ అదదాత్ స మాం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ఇత్యుక్తమాత్రే తస్య చక్షుర్భ్యామ్ మీనశల్కవద్ వస్తుని నిర్గతే తత్క్షణాత్ స ప్రసన్నచక్షు ర్భూత్వా ప్రోత్థాయ మజ్జితోఽభవత్ భుక్త్వా పీత్వా సబలోభవచ్చ| ");
INSERT INTO santel_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","తతః పరం శౌలః శిష్యైః సహ కతిపయదివసాన్ తస్మిన్ దమ్మేషకనగరే స్థిత్వాఽవిలమ్బం ");
INSERT INTO santel_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","సర్వ్వభజనభవనాని గత్వా యీశురీశ్వరస్య పుత్ర ఇమాం కథాం ప్రాచారయత్| ");
INSERT INTO santel_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","తస్మాత్ సర్వ్వే శ్రోతారశ్చమత్కృత్య కథితవన్తో యో యిరూశాలమ్నగర ఏతన్నామ్నా ప్రార్థయితృలోకాన్ వినాశితవాన్ ఏవమ్ ఏతాదృశలోకాన్ బద్ధ్వా ప్రధానయాజకనికటం నయతీత్యాశయా ఏతత్స్థానమప్యాగచ్ఛత్ సఏవ కిమయం న భవతి? ");
INSERT INTO santel_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","కిన్తు శౌలః క్రమశ ఉత్సాహవాన్ భూత్వా యీశురీశ్వరేణాభిషిక్తో జన ఏతస్మిన్ ప్రమాణం దత్వా దమ్మేషక్-నివాసియిహూదీయలోకాన్ నిరుత్తరాన్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ఇత్థం బహుతిథే కాలే గతే యిహూదీయలోకాస్తం హన్తుం మన్త్రయామాసుః ");
INSERT INTO santel_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","కిన్తు శౌలస్తేషామేతస్యా మన్త్రణాయా వార్త్తాం ప్రాప్తవాన్| తే తం హన్తుం తు దివానిశం గుప్తాః సన్తో నగరస్య ద్వారేఽతిష్ఠన్; ");
INSERT INTO santel_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","తస్మాత్ శిష్యాస్తం నీత్వా రాత్రౌ పిటకే నిధాయ ప్రాచీరేణావారోహయన్| ");
INSERT INTO santel_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","తతః పరం శౌలో యిరూశాలమం గత్వా శిష్యగణేన సార్ద్ధం స్థాతుమ్ ఐహత్, కిన్తు సర్వ్వే తస్మాదబిభయుః స శిష్య ఇతి చ న ప్రత్యయన్| ");
INSERT INTO santel_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ఏతస్మాద్ బర్ణబ్బాస్తం గృహీత్వా ప్రేరితానాం సమీపమానీయ మార్గమధ్యే ప్రభుః కథం తస్మై దర్శనం దత్తవాన్ యాః కథాశ్చ కథితవాన్ స చ యథాక్షోభః సన్ దమ్మేషక్నగరే యీశో ర్నామ ప్రాచారయత్ ఏతాన్ సర్వ్వవృత్తాన్తాన్ తాన్ జ్ఞాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","తతః శౌలస్తైః సహ యిరూశాలమి కాలం యాపయన్ నిర్భయం ప్రభో ర్యీశో ర్నామ ప్రాచారయత్| ");
INSERT INTO santel_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","తస్మాద్ అన్యదేశీయలోకైః సార్ద్ధం వివాదస్యోపస్థితత్వాత్ తే తం హన్తుమ్ అచేష్టన్త| ");
INSERT INTO santel_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","కిన్తు భ్రాతృగణస్తజ్జ్ఞాత్వా తం కైసరియానగరం నీత్వా తార్షనగరం ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ఇత్థం సతి యిహూదియాగాలీల్శోమిరోణదేశీయాః సర్వ్వా మణ్డల్యో విశ్రామం ప్రాప్తాస్తతస్తాసాం నిష్ఠాభవత్ ప్రభో ర్భియా పవిత్రస్యాత్మనః సాన్త్వనయా చ కాలం క్షేపయిత్వా బహుసంఖ్యా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","తతః పరం పితరః స్థానే స్థానే భ్రమిత్వా శేషే లోద్నగరనివాసిపవిత్రలోకానాం సమీపే స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","తదా తత్ర పక్షాఘాతవ్యాధినాష్టౌ వత్సరాన్ శయ్యాగతమ్ ఐనేయనామానం మనుష్యం సాక్షత్ ప్రాప్య తమవదత్, ");
INSERT INTO santel_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","హే ఐనేయ యీశుఖ్రీష్టస్త్వాం స్వస్థమ్ అకార్షీత్, త్వముత్థాయ స్వశయ్యాం నిక్షిప, ఇత్యుక్తమాత్రే స ఉదతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ఏతాదృశం దృష్ట్వా లోద్శారోణనివాసినో లోకాః ప్రభుం ప్రతి పరావర్త్తన్త| ");
INSERT INTO santel_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","అపరఞ్చ భిక్షాదానాదిషు నానక్రియాసు నిత్యం ప్రవృత్తా యా యాఫోనగరనివాసినీ టాబిథానామా శిష్యా యాం దర్క్కాం అర్థాద్ హరిణీమయుక్త్వా ఆహ్వయన్ సా నారీ ");
INSERT INTO santel_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","తస్మిన్ సమయే రుగ్నా సతీ ప్రాణాన్ అత్యజత్, తతో లోకాస్తాం ప్రక్షాల్యోపరిస్థప్రకోష్ఠే శాయయిత్వాస్థాపయన్| ");
INSERT INTO santel_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","లోద్నగరం యాఫోనగరస్య సమీపస్థం తస్మాత్తత్ర పితర ఆస్తే, ఇతి వార్త్తాం శ్రుత్వా తూర్ణం తస్యాగమనార్థం తస్మిన్ వినయముక్త్వా శిష్యగణో ద్వౌ మనుజౌ ప్రేషితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","తస్మాత్ పితర ఉత్థాయ తాభ్యాం సార్ద్ధమ్ ఆగచ్ఛత్, తత్ర తస్మిన్ ఉపస్థిత ఉపరిస్థప్రకోష్ఠం సమానీతే చ విధవాః స్వాభిః సహ స్థితికాలే దర్క్కయా కృతాని యాన్యుత్తరీయాణి పరిధేయాని చ తాని సర్వ్వాణి తం దర్శయిత్వా రుదత్యశ్చతసృషు దిక్ష్వతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","కిన్తు పితరస్తాః సర్వ్వా బహిః కృత్వా జానునీ పాతయిత్వా ప్రార్థితవాన్; పశ్చాత్ శవం ప్రతి దృష్టిం కృత్వా కథితవాన్, హే టాబీథే త్వముత్తిష్ఠ, ఇతి వాక్య ఉక్తే సా స్త్రీ చక్షుషీ ప్రోన్మీల్య పితరమ్ అవలోక్యోత్థాయోపావిశత్| ");
INSERT INTO santel_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","తతః పితరస్తస్యాః కరౌ ధృత్వా ఉత్తోల్య పవిత్రలోకాన్ విధవాశ్చాహూయ తేషాం నికటే సజీవాం తాం సమార్పయత్| ");
INSERT INTO santel_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ఏషా కథా సమస్తయాఫోనగరం వ్యాప్తా తస్మాద్ అనేకే లోకాః ప్రభౌ వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","అపరఞ్చ పితరస్తద్యాఫోనగరీయస్య కస్యచిత్ శిమోన్నామ్నశ్చర్మ్మకారస్య గృహే బహుదినాని న్యవసత్| ");
INSERT INTO santel_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","కైసరియానగర ఇతాలియాఖ్యసైన్యాన్తర్గతః కర్ణీలియనామా సేనాపతిరాసీత్ ");
INSERT INTO santel_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","స సపరివారో భక్త ఈశ్వరపరాయణశ్చాసీత్; లోకేభ్యో బహూని దానాదీని దత్వా నిరన్తరమ్ ఈశ్వరే ప్రార్థయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ఏకదా తృతీయప్రహరవేలాయాం స దృష్టవాన్ ఈశ్వరస్యైకో దూతః సప్రకాశం తత్సమీపమ్ ఆగత్య కథితవాన్, హే కర్ణీలియ| ");
INSERT INTO santel_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","కిన్తు స తం దృష్ట్వా భీతోఽకథయత్, హే ప్రభో కిం? తదా తమవదత్ తవ ప్రార్థనా దానాది చ సాక్షిస్వరూపం భూత్వేశ్వరస్య గోచరమభవత్| ");
INSERT INTO santel_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ఇదానీం యాఫోనగరం ప్రతి లోకాన్ ప్రేష్య సముద్రతీరే శిమోన్నామ్నశ్చర్మ్మకారస్య గృహే ప్రవాసకారీ పితరనామ్నా విఖ్యాతో యః శిమోన్ తమ్ ఆహ్వాయయ; ");
INSERT INTO santel_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","తస్మాత్ త్వయా యద్యత్ కర్త్తవ్యం తత్తత్ స వదిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ఇత్యుపదిశ్య దూతే ప్రస్థితే సతి కర్ణీలియః స్వగృహస్థానాం దాసానాం ద్వౌ జనౌ నిత్యం స్వసఙ్గినాం సైన్యానామ్ ఏకాం భక్తసేనాఞ్చాహూయ ");
INSERT INTO santel_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","సకలమేతం వృత్తాన్తం విజ్ఞాప్య యాఫోనగరం తాన్ ప్రాహిణోత్| ");
INSERT INTO santel_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","పరస్మిన్ దినే తే యాత్రాం కృత్వా యదా నగరస్య సమీప ఉపాతిష్ఠన్, తదా పితరో ద్వితీయప్రహరవేలాయాం ప్రార్థయితుం గృహపృష్ఠమ్ ఆరోహత్| ");
INSERT INTO santel_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ఏతస్మిన్ సమయే క్షుధార్త్తః సన్ కిఞ్చిద్ భోక్తుమ్ ఐచ్ఛత్ కిన్తు తేషామ్ అన్నాసాదనసమయే స మూర్చ్ఛితః సన్నపతత్| ");
INSERT INTO santel_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","తతో మేఘద్వారం ముక్తం చతుర్భిః కోణై ర్లమ్బితం బృహద్వస్త్రమివ కిఞ్చన భాజనమ్ ఆకాశాత్ పృథివీమ్ అవారోహతీతి దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","తన్మధ్యే నానప్రకారా గ్రామ్యవన్యపశవః ఖేచరోరోగామిప్రభృతయో జన్తవశ్చాసన్| ");
INSERT INTO santel_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","అనన్తరం హే పితర ఉత్థాయ హత్వా భుంక్ష్వ తమ్ప్రతీయం గగణీయా వాణీ జాతా| ");
INSERT INTO santel_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","తదా పితరః ప్రత్యవదత్, హే ప్రభో ఈదృశం మా భవతు, అహమ్ ఏతత్ కాలం యావత్ నిషిద్ధమ్ అశుచి వా ద్రవ్యం కిఞ్చిదపి న భుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","తతః పునరపి తాదృశీ విహయసీయా వాణీ జాతా యద్ ఈశ్వరః శుచి కృతవాన్ తత్ త్వం నిషిద్ధం న జానీహి| ");
INSERT INTO santel_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ఇత్థం త్రిః సతి తత్ పాత్రం పునరాకృష్టం ఆకాశమ్ అగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","తతః పరం యద్ దర్శనం ప్రాప్తవాన్ తస్య కో భావ ఇత్యత్ర పితరో మనసా సన్దేగ్ధి, ఏతస్మిన్ సమయే కర్ణీలియస్య తే ప్రేషితా మనుష్యా ద్వారస్య సన్నిధావుపస్థాయ, ");
INSERT INTO santel_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","శిమోనో గృహమన్విచ్ఛన్తః సమ్పృఛ్యాహూయ కథితవన్తః పితరనామ్నా విఖ్యాతో యః శిమోన్ స కిమత్ర ప్రవసతి? ");
INSERT INTO santel_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","యదా పితరస్తద్దర్శనస్య భావం మనసాన్దోలయతి తదాత్మా తమవదత్, పశ్య త్రయో జనాస్త్వాం మృగయన్తే| ");
INSERT INTO santel_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","త్వమ్ ఉత్థాయావరుహ్య నిఃసన్దేహం తైః సహ గచ్ఛ మయైవ తే ప్రేషితాః| ");
INSERT INTO santel_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","తస్మాత్ పితరోఽవరుహ్య కర్ణీలియప్రేరితలోకానాం నికటమాగత్య కథితవాన్ పశ్యత యూయం యం మృగయధ్వే స జనోహం, యూయం కిన్నిమిత్తమ్ ఆగతాః? ");
INSERT INTO santel_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","తతస్తే ప్రత్యవదన్ కర్ణీలియనామా శుద్ధసత్త్వ ఈశ్వరపరాయణో యిహూదీయదేశస్థానాం సర్వ్వేషాం సన్నిధౌ సుఖ్యాత్యాపన్న ఏకః సేనాపతి ర్నిజగృహం త్వామాహూయ నేతుం త్వత్తః కథా శ్రోతుఞ్చ పవిత్రదూతేన సమాదిష్టః| ");
INSERT INTO santel_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","తదా పితరస్తానభ్యన్తరం నీత్వా తేషామాతిథ్యం కృతవాన్, పరేఽహని తైః సార్ద్ధం యాత్రామకరోత్, యాఫోనివాసినాం భ్రాతృణాం కియన్తో జనాశ్చ తేన సహ గతాః| ");
INSERT INTO santel_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","పరస్మిన్ దివసే కైసరియానగరమధ్యప్రవేశసమయే కర్ణీలియో జ్ఞాతిబన్ధూన్ ఆహూయానీయ తాన్ అపేక్ష్య స్థితః| ");
INSERT INTO santel_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","పితరే గృహ ఉపస్థితే కర్ణీలియస్తం సాక్షాత్కృత్య చరణయోః పతిత్వా ప్రాణమత్| ");
INSERT INTO santel_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","పితరస్తముత్థాప్య కథితవాన్, ఉత్తిష్ఠాహమపి మానుషః| ");
INSERT INTO santel_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","తదా కర్ణీలియేన సాకమ్ ఆలపన్ గృహం ప్రావిశత్ తన్మధ్యే చ బహులోకానాం సమాగమం దృష్ట్వా తాన్ అవదత్, ");
INSERT INTO santel_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","అన్యజాతీయలోకైః మహాలపనం వా తేషాం గృహమధ్యే ప్రవేశనం యిహూదీయానాం నిషిద్ధమ్ అస్తీతి యూయమ్ అవగచ్ఛథ; కిన్తు కమపి మానుషమ్ అవ్యవహార్య్యమ్ అశుచిం వా జ్ఞాతుం మమ నోచితమ్ ఇతి పరమేశ్వరో మాం జ్ఞాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ఇతి హేతోరాహ్వానశ్రవణమాత్రాత్ కాఞ్చనాపత్తిమ్ అకృత్వా యుష్మాకం సమీపమ్ ఆగతోస్మి; పృచ్ఛామి యూయం కిన్నిమిత్తం మామ్ ఆహూయత? ");
INSERT INTO santel_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","తదా కర్ణీలియః కథితవాన్, అద్య చత్వారి దినాని జాతాని ఏతావద్వేలాం యావద్ అహమ్ అనాహార ఆసన్ తతస్తృతీయప్రహరే సతి గృహే ప్రార్థనసమయే తేజోమయవస్త్రభృద్ ఏకో జనో మమ సమక్షం తిష్ఠన్ ఏతాం కథామ్ అకథయత్, ");
INSERT INTO santel_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","హే కర్ణీలియ త్వదీయా ప్రార్థనా ఈశ్వరస్య కర్ణగోచరీభూతా తవ దానాది చ సాక్షిస్వరూపం భూత్వా తస్య దృష్టిగోచరమభవత్| ");
INSERT INTO santel_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","అతో యాఫోనగరం ప్రతి లోకాన్ ప్రహిత్య తత్ర సముద్రతీరే శిమోన్నామ్నః కస్యచిచ్చర్మ్మకారస్య గృహే ప్రవాసకారీ పితరనామ్నా విఖ్యాతో యః శిమోన్ తమాహూाయయ; తతః స ఆగత్య త్వామ్ ఉపదేక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ఇతి కారణాత్ తత్క్షణాత్ తవ నికటే లోకాన్ ప్రేషితవాన్, త్వమాగతవాన్ ఇతి భద్రం కృతవాన్| ఈశ్వరో యాన్యాఖ్యానాని కథయితుమ్ ఆదిశత్ తాని శ్రోతుం వయం సర్వ్వే సామ్ప్రతమ్ ఈశ్వరస్య సాక్షాద్ ఉపస్థితాః స్మః| ");
INSERT INTO santel_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","తదా పితర ఇమాం కథాం కథయితుమ్ ఆరబ్ధవాన్, ఈశ్వరో మనుష్యాణామ్ అపక్షపాతీ సన్ ");
INSERT INTO santel_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","యస్య కస్యచిద్ దేశస్య యో లోకాస్తస్మాద్భీత్వా సత్కర్మ్మ కరోతి స తస్య గ్రాహ్యో భవతి, ఏతస్య నిశ్చయమ్ ఉపలబ్ధవానహమ్| ");
INSERT INTO santel_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","సర్వ్వేషాం ప్రభు ర్యో యీశుఖ్రీష్టస్తేన ఈశ్వర ఇస్రాయేల్వంశానాం నికటే సుసంవాదం ప్రేష్య సమ్మేలనస్య యం సంవాదం ప్రాచారయత్ తం సంవాదం యూయం శ్రుతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","యతో యోహనా మజ్జనే ప్రచారితే సతి స గాలీలదేశమారభ్య సమస్తయిహూదీయదేశం వ్యాప్నోత్; ");
INSERT INTO santel_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ఫలత ఈశ్వరేణ పవిత్రేణాత్మనా శక్త్యా చాభిషిక్తో నాసరతీయయీశుః స్థానే స్థానే భ్రమన్ సుక్రియాం కుర్వ్వన్ శైతానా క్లిష్టాన్ సర్వ్వలోకాన్ స్వస్థాన్ అకరోత్, యత ఈశ్వరస్తస్య సహాయ ఆసీత్; ");
INSERT INTO santel_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","వయఞ్చ యిహూదీయదేశే యిరూశాలమ్నగరే చ తేన కృతానాం సర్వ్వేషాం కర్మ్మణాం సాక్షిణో భవామః| లోకాస్తం క్రుశే విద్ధ్వా హతవన్తః, ");
INSERT INTO santel_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","కిన్తు తృతీయదివసే ఈశ్వరస్తముత్థాప్య సప్రకాశమ్ అదర్శయత్| ");
INSERT INTO santel_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","సర్వ్వలోకానాం నికట ఇతి న హి, కిన్తు తస్మిన్ శ్మశానాదుత్థితే సతి తేన సార్ద్ధం భోజనం పానఞ్చ కృతవన్త ఏతాదృశా ఈశ్వరస్య మనోనీతాః సాక్షిణో యే వయమ్ అస్మాకం నికటే తమదర్శయత్| ");
INSERT INTO santel_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","జీవితమృతోభయలోకానాం విచారం కర్త్తుమ్ ఈశ్వరో యం నియుక్తవాన్ స ఏవ స జనః, ఇమాం కథాం ప్రచారయితుం తస్మిన్ ప్రమాణం దాతుఞ్చ సోఽస్మాన్ ఆజ్ఞాపయత్| ");
INSERT INTO santel_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","యస్తస్మిన్ విశ్వసితి స తస్య నామ్నా పాపాన్ముక్తో భవిష్యతి తస్మిన్ సర్వ్వే భవిష్యద్వాదినోపి ఏతాదృశం సాక్ష్యం దదతి| ");
INSERT INTO santel_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","పితరస్యైతత్కథాకథనకాలే సర్వ్వేషాం శ్రోతృణాముపరి పవిత్ర ఆత్మావారోహత్| ");
INSERT INTO santel_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","తతః పితరేణ సార్ద్ధమ్ ఆగతాస్త్వక్ఛేదినో విశ్వాసినో లోకా అన్యదేశీయేభ్యః పవిత్ర ఆత్మని దత్తే సతి ");
INSERT INTO santel_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","తే నానాజాతీయభాషాభిః కథాం కథయన్త ఈశ్వరం ప్రశంసన్తి, ఇతి దృష్ట్వా శ్రుత్వా చ విస్మయమ్ ఆపద్యన్త| ");
INSERT INTO santel_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","తదా పితరః కథితవాన్, వయమివ యే పవిత్రమ్ ఆత్మానం ప్రాప్తాస్తేషాం జలమజ్జనం కిం కోపి నిషేద్ధుం శక్నోతి? ");
INSERT INTO santel_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","తతః ప్రభో ర్నామ్నా మజ్జితా భవతేతి తానాజ్ఞాపయత్| అనన్తరం తే స్వైః సార్ద్ధం కతిపయదినాని స్థాతుం ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ఇత్థం భిన్నదేశీయలోకా అపీశ్వరస్య వాక్యమ్ అగృహ్లన్ ఇమాం వార్త్తాం యిహూదీయదేశస్థప్రేరితా భ్రాతృగణశ్చ శ్రుతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","తతః పితరే యిరూశాలమ్నగరం గతవతి త్వక్ఛేదినో లోకాస్తేన సహ వివదమానా అవదన్, ");
INSERT INTO santel_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","త్వమ్ అత్వక్ఛేదిలోకానాం గృహం గత్వా తైః సార్ద్ధం భుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","తతః పితర ఆదితః క్రమశస్తత్కార్య్యస్య సర్వ్వవృత్తాన్తమాఖ్యాతుమ్ ఆరబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","యాఫోనగర ఏకదాహం ప్రార్థయమానో మూర్చ్ఛితః సన్ దర్శనేన చతుర్షు కోణేషు లమ్బనమానం వృహద్వస్త్రమివ పాత్రమేకమ్ ఆకాశదవరుహ్య మన్నికటమ్ ఆగచ్ఛద్ అపశ్యమ్| ");
INSERT INTO santel_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","పశ్చాత్ తద్ అనన్యదృష్ట్యా దృష్ట్వా వివిచ్య తస్య మధ్యే నానాప్రకారాన్ గ్రామ్యవన్యపశూన్ ఉరోగామిఖేచరాంశ్చ దృష్టవాన్; ");
INSERT INTO santel_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","హే పితర త్వముత్థాయ గత్వా భుంక్ష్వ మాం సమ్బోధ్య కథయన్తం శబ్దమేకం శ్రుతవాంశ్చ| ");
INSERT INTO santel_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","తతోహం ప్రత్యవదం, హే ప్రభో నేత్థం భవతు, యతః కిఞ్చన నిషిద్ధమ్ అశుచి ద్రవ్యం వా మమ ముఖమధ్యం కదాపి న ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","అపరమ్ ఈశ్వరో యత్ శుచి కృతవాన్ తన్నిషిద్ధం న జానీహి ద్వి ర్మామ్ప్రతీదృశీ విహాయసీయా వాణీ జాతా| ");
INSERT INTO santel_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","త్రిరిత్థం సతి తత్ సర్వ్వం పునరాకాశమ్ ఆకృష్టం| ");
INSERT INTO santel_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","పశ్చాత్ కైసరియానగరాత్ త్రయో జనా మన్నికటం ప్రేషితా యత్ర నివేశనే స్థితోహం తస్మిన్ సమయే తత్రోపాతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","తదా నిఃసన్దేహం తైః సార్ద్ధం యాతుమ్ ఆత్మా మామాదిష్టవాన్; తతః పరం మయా సహైతేషు షడ్భ్రాతృషు గతేషు వయం తస్య మనుజస్య గృహం ప్రావిశామ| ");
INSERT INTO santel_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","సోస్మాకం నికటే కథామేతామ్ అకథయత్ ఏకదా దూత ఏకః ప్రత్యక్షీభూయ మమ గృహమధ్యే తిష్టన్ మామిత్యాజ్ఞాపితవాన్, యాఫోనగరం ప్రతి లోకాన్ ప్రహిత్య పితరనామ్నా విఖ్యాతం శిమోనమ్ ఆహూయయ; ");
INSERT INTO santel_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","తతస్తవ త్వదీయపరివారాణాఞ్చ యేన పరిత్రాణం భవిష్యతి తత్ స ఉపదేక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","అహం తాం కథాముత్థాప్య కథితవాన్ తేన ప్రథమమ్ అస్మాకమ్ ఉపరి యథా పవిత్ర ఆత్మావరూఢవాన్ తథా తేషామప్యుపరి సమవరూఢవాన్| ");
INSERT INTO santel_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","తేన యోహన్ జలే మజ్జితవాన్ ఇతి సత్యం కిన్తు యూయం పవిత్ర ఆత్మని మజ్జితా భవిష్యథ, ఇతి యద్వాక్యం ప్రభురుదితవాన్ తత్ తదా మయా స్మృతమ్| ");
INSERT INTO santel_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","అతః ప్రభా యీశుఖ్రీష్టే ప్రత్యయకారిణో యే వయమ్ అస్మభ్యమ్ ఈశ్వరో యద్ దత్తవాన్ తత్ తేభ్యో లోకేభ్యోపి దత్తవాన్ తతః కోహం? కిమహమ్ ఈశ్వరం వారయితుం శక్నోమి? ");
INSERT INTO santel_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","కథామేతాం శ్రువా తే క్షాన్తా ఈశ్వరస్య గుణాన్ అనుకీర్త్త్య కథితవన్తః, తర్హి పరమాయుఃప్రాప్తినిమిత్తమ్ ఈశ్వరోన్యదేశీయలోకేభ్యోపి మనఃపరివర్త్తనరూపం దానమ్ అదాత్| ");
INSERT INTO santel_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","స్తిఫానం ప్రతి ఉపద్రవే ఘటితే యే వికీర్ణా అభవన్ తై ఫైనీకీకుప్రాన్తియఖియాసు భ్రమిత్వా కేవలయిహూదీయలోకాన్ వినా కస్యాప్యన్యస్య సమీప ఈశ్వరస్య కథాం న ప్రాచారయన్| ");
INSERT INTO santel_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","అపరం తేషాం కుప్రీయాః కురీనీయాశ్చ కియన్తో జనా ఆన్తియఖియానగరం గత్వా యూనానీయలోకానాం సమీపేపి ప్రభోర్యీశోః కథాం ప్రాచారయన్| ");
INSERT INTO santel_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ప్రభోః కరస్తేషాం సహాయ ఆసీత్ తస్మాద్ అనేకే లోకా విశ్వస్య ప్రభుం ప్రతి పరావర్త్తన్త| ");
INSERT INTO santel_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ఇతి వార్త్తాయాం యిరూశాలమస్థమణ్డలీయలోకానాం కర్ణగోచరీభూతాయామ్ ఆన్తియఖియానగరం గన్తు తే బర్ణబ్బాం ప్రైరయన్| ");
INSERT INTO santel_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","తతో బర్ణబ్బాస్తత్ర ఉపస్థితః సన్ ఈశ్వరస్యానుగ్రహస్య ఫలం దృష్ట్వా సానన్దో జాతః, ");
INSERT INTO santel_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","స స్వయం సాధు ర్విశ్వాసేన పవిత్రేణాత్మనా చ పరిపూర్ణః సన్ గనోనిష్టయా ప్రభావాస్థాం కర్త్తుం సర్వ్వాన్ ఉపదిష్టవాన్ తేన ప్రభోః శిష్యా అనేకే బభూవుః| ");
INSERT INTO santel_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","శేషే శౌలం మృగయితుం బర్ణబ్బాస్తార్షనగరం ప్రస్థితవాన్| తత్ర తస్యోద్దేశం ప్రాప్య తమ్ ఆన్తియఖియానగరమ్ ఆనయత్; ");
INSERT INTO santel_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","తతస్తౌ మణ్డలీస్థలోకైః సభాం కృత్వా సంవత్సరమేకం యావద్ బహులోకాన్ ఉపాదిశతాం; తస్మిన్ ఆన్తియఖియానగరే శిష్యాః ప్రథమం ఖ్రీష్టీయనామ్నా విఖ్యాతా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","తతః పరం భవిష్యద్వాదిగణే యిరూశాలమ ఆన్తియఖియానగరమ్ ఆగతే సతి ");
INSERT INTO santel_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ఆగాబనామా తేషామేక ఉత్థాయ ఆత్మనః శిక్షయా సర్వ్వదేశే దుర్భిక్షం భవిష్యతీతి జ్ఞాపితవాన్; తతః క్లౌదియకైసరస్యాధికారే సతి తత్ ప్రత్యక్షమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","తస్మాత్ శిష్యా ఏకైకశః స్వస్వశక్త్యనుసారతో యిహూదీయదేశనివాసినాం భ్రతృణాం దినయాపనార్థం ధనం ప్రేషయితుం నిశ్చిత్య ");
INSERT INTO santel_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","బర్ణబ్బాశౌలయో ర్ద్వారా ప్రాచీనలోకానాం సమీపం తత్ ప్రేషితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","తస్మిన్ సమయే హేరోద్‌రాజో మణ్డల్యాః కియజ్జనేభ్యో దుఃఖం దాతుం ప్రారభత్| ");
INSERT INTO santel_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","విశేషతో యోహనః సోదరం యాకూబం కరవాలాఘాతేన్ హతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","తస్మాద్ యిహూదీయాః సన్తుష్టా అభవన్ ఇతి విజ్ఞాయ స పితరమపి ధర్త్తుం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","తదా కిణ్వశూన్యపూపోత్సవసమయ ఉపాతిష్టత్; అత ఉత్సవే గతే సతి లోకానాం సమక్షం తం బహిరానేయ్యామీతి మనసి స్థిరీకృత్య స తం ధారయిత్వా రక్ష్ణార్థమ్ యేషామ్ ఏకైకసంఘే చత్వారో జనాః సన్తి తేషాం చతుర్ణాం రక్షకసంఘానాం సమీపే తం సమర్ప్య కారాయాం స్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","కిన్తుం పితరస్య కారాస్థితికారణాత్ మణ్డల్యా లోకా అవిశ్రామమ్ ఈశ్వరస్య సమీపే ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","అనన్తరం హేరోది తం బహిరానాయితుం ఉద్యతే సతి తస్యాం రాత్రౌ పితరో రక్షకద్వయమధ్యస్థానే శృఙ్ఖలద్వయేన బద్ధ్వః సన్ నిద్రిత ఆసీత్, దౌవారికాశ్చ కారాయాః సమ్ముఖే తిష్ఠనతో ద్వారమ్ అరక్షిషుః| ");
INSERT INTO santel_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ఏతస్మిన్ సమయే పరమేశ్వరస్య దూతే సముపస్థితే కారా దీప్తిమతీ జాతా; తతః స దూతః పితరస్య కుక్షావావాతం కృత్వా తం జాగరయిత్వా భాషితవాన్ తూర్ణముత్తిష్ఠ; తతస్తస్య హస్తస్థశృఙ్ఖలద్వయం గలత్ పతితం| ");
INSERT INTO santel_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","స దూతస్తమవదత్, బద్ధకటిః సన్ పాదయోః పాదుకే అర్పయ; తేన తథా కృతే సతి దూతస్తమ్ ఉక్తవాన్ గాత్రీయవస్త్రం గాత్రే నిధాయ మమ పశ్చాద్ ఏహి| ");
INSERT INTO santel_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","తతః పితరస్తస్య పశ్చాద్ వ్రజన బహిరగచ్ఛత్, కిన్తు దూతేన కర్మ్మైతత్ కృతమితి సత్యమజ్ఞాత్వా స్వప్నదర్శనం జ్ఞాతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ఇత్థం తౌ ప్రథమాం ద్వితీయాఞ్చ కారాం లఙ్ఘిత్వా యేన లౌహనిర్మ్మితద్వారేణ నగరం గమ్యతే తత్సమీపం ప్రాప్నుతాం; తతస్తస్య కవాటం స్వయం ముక్తమభవత్ తతస్తౌ తత్స్థానాద్ బహి ర్భూత్వా మార్గైకస్య సీమాం యావద్ గతౌ; తతోఽకస్మాత్ స దూతః పితరం త్యక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","తదా స చేతనాం ప్రాప్య కథితవాన్ నిజదూతం ప్రహిత్య పరమేశ్వరో హేరోదో హస్తాద్ యిహూదీయలోకానాం సర్వ్వాశాయాశ్చ మాం సముద్ధృతవాన్ ఇత్యహం నిశ్చయం జ్ఞాతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","స వివిచ్య మార్కనామ్రా విఖ్యాతస్య యోహనో మాతు ర్మరియమో యస్మిన్ గృహే బహవః సమ్భూయ ప్రార్థయన్త తన్నివేశనం గతః| ");
INSERT INTO santel_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","పితరేణ బహిర్ద్వార ఆహతే సతి రోదానామా బాలికా ద్రష్టుం గతా| ");
INSERT INTO santel_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","తతః పితరస్య స్వరం శ్రువా సా హర్షయుక్తా సతీ ద్వారం న మోచయిత్వా పితరో ద్వారే తిష్ఠతీతి వార్త్తాం వక్తుమ్ అభ్యన్తరం ధావిత్వా గతవతీ| ");
INSERT INTO santel_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","తే ప్రావోచన్ త్వమున్మత్తా జాతాసి కిన్తు సా ముహుర్ముహురుక్తవతీ సత్యమేవైతత్| ");
INSERT INTO santel_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","తదా తే కథితవన్తస్తర్హి తస్య దూతో భవేత్| ");
INSERT INTO santel_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","పితరో ద్వారమాహతవాన్ ఏతస్మిన్నన్తరే ద్వారం మోచయిత్వా పితరం దృష్ట్వా విస్మయం ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","తతః పితరో నిఃశబ్దం స్థాతుం తాన్ ప్రతి హస్తేన సఙ్కేతం కృత్వా పరమేశ్వరో యేన ప్రకారేణ తం కారాయా ఉద్ధృత్యానీతవాన్ తస్య వృత్తాన్తం తానజ్ఞాపయత్, యూయం గత్వా యాకుబం భ్రాతృగణఞ్చ వార్త్తామేతాం వదతేత్యుక్తా స్థానాన్తరం ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ప్రభాతే సతి పితరః క్వ గత ఇత్యత్ర రక్షకాణాం మధ్యే మహాన్ కలహో జాతః| ");
INSERT INTO santel_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","హేరోద్ బహు మృగయిత్వా తస్యోద్దేశే న ప్రాప్తే సతి రక్షకాన్ సంపృచ్ఛ్య తేషాం ప్రాణాన్ హన్తుమ్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","పశ్చాత్ స యిహూదీయప్రదేశాత్ కైసరియానగరం గత్వా తత్రావాతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","సోరసీదోనదేశయో ర్లోకేభ్యో హేరోది యుయుత్సౌ సతి తే సర్వ్వ ఏకమన్త్రణాః సన్తస్తస్య సమీప ఉపస్థాయ ల్వాస్తనామానం తస్య వస్త్రగృహాధీశం సహాయం కృత్వా హేరోదా సార్ద్ధం సన్ధిం ప్రార్థయన్త యతస్తస్య రాజ్ఞో దేశేన తేషాం దేశీయానాం భరణమ్ అభవత్ం ");
INSERT INTO santel_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","అతః కుత్రచిన్ నిరుపితదినే హేరోద్ రాజకీయం పరిచ్ఛదం పరిధాయ సింహాసనే సముపవిశ్య తాన్ ప్రతి కథామ్ ఉక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","తతో లోకా ఉచ్చైఃకారం ప్రత్యవదన్, ఏష మనుజరవో న హి, ఈశ్వరీయరవః| ");
INSERT INTO santel_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","తదా హేరోద్ ఈశ్వరస్య సమ్మానం నాకరోత్; తస్మాద్ధేతోః పరమేశ్వరస్య దూతో హఠాత్ తం ప్రాహరత్ తేనైవ స కీటైః క్షీణః సన్ ప్రాణాన్ అజహాత్| కిన్త్వీశ్వరస్య కథా దేశం వ్యాప్య ప్రబలాభవత్| తతః పరం బర్ణబ్బాశౌలౌ యస్య కర్మ్మణో భారం ప్రాప్నుతాం తాభ్యాం తస్మిన్ సమ్పాదితే సతి మార్కనామ్నా విఖ్యాతో యో యోహన్ తం సఙ్గినం కృత్వా యిరూశాలమ్నగరాత్ ప్రత్యాగతౌ| ");
INSERT INTO santel_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","అపరఞ్చ బర్ణబ్బాః, శిమోన్ యం నిగ్రం వదన్తి, కురీనీయలూకియో హేరోదా రాజ్ఞా సహ కృతవిద్యాाభ్యాసో మినహేమ్, శౌలశ్చైతే యే కియన్తో జనా భవిష్యద్వాదిన ఉపదేష్టారశ్చాన్తియఖియానగరస్థమణ్డల్యామ్ ఆసన్, ");
INSERT INTO santel_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","తే యదోపవాసం కృత్వేశ్వరమ్ అసేవన్త తస్మిన్ సమయే పవిత్ర ఆత్మా కథితవాన్ అహం యస్మిన్ కర్మ్మణి బర్ణబ్బాశైలౌ నియుక్తవాన్ తత్కర్మ్మ కర్త్తుం తౌ పృథక్ కురుత| ");
INSERT INTO santel_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","తతస్తైరుపవాసప్రార్థనయోః కృతయోః సతోస్తే తయో ర్గాత్రయో ర్హస్తార్పణం కృత్వా తౌ వ్యసృజన్| ");
INSERT INTO santel_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","తతః పరం తౌ పవిత్రేణాత్మనా ప్రేరితౌ సన్తౌ సిలూకియానగరమ్ ఉపస్థాయ సముద్రపథేన కుప్రోపద్వీపమ్ అగచ్ఛతాం| ");
INSERT INTO santel_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","తతః సాలామీనగరమ్ ఉపస్థాయ తత్ర యిహూదీయానాం భజనభవనాని గత్వేశ్వరస్య కథాం ప్రాచారయతాం; యోహనపి తత్సహచరోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ఇత్థం తే తస్యోపద్వీపస్య సర్వ్వత్ర భ్రమన్తః పాఫనగరమ్ ఉపస్థితాః; తత్ర సువివేచకేన సర్జియపౌలనామ్నా తద్దేశాధిపతినా సహ భవిష్యద్వాదినో వేశధారీ బర్యీశునామా యో మాయావీ యిహూదీ ఆసీత్ తం సాక్షాత్ ప్రాప్తవతః| ");
INSERT INTO santel_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","తద్దేశాధిప ఈశ్వరస్య కథాం శ్రోతుం వాఞ్ఛన్ పౌలబర్ణబ్బౌ న్యమన్త్రయత్| ");
INSERT INTO santel_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","కిన్త్విలుమా యం మాయావినం వదన్తి స దేశాధిపతిం ధర్మ్మమార్గాద్ బహిర్భూతం కర్త్తుమ్ అయతత| ");
INSERT INTO santel_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","తస్మాత్ శోలోఽర్థాత్ పౌలః పవిత్రేణాత్మనా పరిపూర్ణః సన్ తం మాయావినం ప్రత్యనన్యదృష్టిం కృత్వాకథయత్, ");
INSERT INTO santel_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","హే నరకిన్ ధర్మ్మద్వేషిన్ కౌటిల్యదుష్కర్మ్మపరిపూర్ణ, త్వం కిం ప్రభోః సత్యపథస్య విపర్య్యయకరణాత్ కదాపి న నివర్త్తిష్యసే? ");
INSERT INTO santel_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","అధునా పరమేశ్వరస్తవ సముచితం కరిష్యతి తేన కతిపయదినాని త్వమ్ అన్ధః సన్ సూర్య్యమపి న ద్రక్ష్యసి| తత్క్షణాద్ రాత్రివద్ అన్ధకారస్తస్య దృష్టిమ్ ఆచ్ఛాదితవాన్; తస్మాత్ తస్య హస్తం ధర్త్తుం స లోకమన్విచ్ఛన్ ఇతస్తతో భ్రమణం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ఏనాం ఘటనాం దృష్ట్వా స దేశాధిపతిః ప్రభూపదేశాద్ విస్మిత్య విశ్వాసం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","తదనన్తరం పౌలస్తత్సఙ్గినౌ చ పాఫనగరాత్ ప్రోతం చాలయిత్వా పమ్ఫులియాదేశస్య పర్గీనగరమ్ అగచ్ఛన్ కిన్తు యోహన్ తయోః సమీపాద్ ఏత్య యిరూశాలమం ప్రత్యాగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","పశ్చాత్ తౌ పర్గీతో యాత్రాం కృత్వా పిసిదియాదేశస్య ఆన్తియఖియానగరమ్ ఉపస్థాయ విశ్రామవారే భజనభవనం ప్రవిశ్య సముపావిశతాం| ");
INSERT INTO santel_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","వ్యవస్థాభవిష్యద్వాక్యయోః పఠితయోః సతో ర్హే భ్రాతరౌ లోకాన్ ప్రతి యువయోః కాచిద్ ఉపదేశకథా యద్యస్తి తర్హి తాం వదతం తౌ ప్రతి తస్య భజనభవనస్యాధిపతయః కథామ్ ఏతాం కథయిత్వా ప్రైషయన్| ");
INSERT INTO santel_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","అతః పౌల ఉత్తిష్ఠన్ హస్తేన సఙ్కేతం కుర్వ్వన్ కథితవాన్ హే ఇస్రాయేలీయమనుష్యా ఈశ్వరపరాయణాః సర్వ్వే లోకా యూయమ్ అవధద్ధం| ");
INSERT INTO santel_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ఏతేషామిస్రాయేల్లోకానామ్ ఈశ్వరోఽస్మాకం పూర్వ్వపరుషాన్ మనోనీతాన్ కత్వా గృహీతవాన్ తతో మిసరి దేశే ప్రవసనకాలే తేషామున్నతిం కృత్వా తస్మాత్ స్వీయబాహుబలేన తాన్ బహిః కృత్వా సమానయత్| ");
INSERT INTO santel_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","చత్వారింశద్వత్సరాన్ యావచ్చ మహాప్రాన్తరే తేషాం భరణం కృత్వా ");
INSERT INTO santel_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","కినాన్దేశాన్తర్వ్వర్త్తీణి సప్తరాజ్యాని నాశయిత్వా గుటికాపాతేన తేషు సర్వ్వదేశేషు తేభ్యోఽధికారం దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","పఞ్చాశదధికచతుఃశతేషు వత్సరేషు గతేషు చ శిమూయేల్భవిష్యద్వాదిపర్య్యన్తం తేషాముపరి విచారయితృన్ నియుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","తైశ్చ రాజ్ఞి ప్రార్థితే, ఈశ్వరో బిన్యామీనో వంశజాతస్య కీశః పుత్రం శౌలం చత్వారింశద్వర్షపర్య్యన్తం తేషాముపరి రాజానం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","పశ్చాత్ తం పదచ్యుతం కృత్వా యో మదిష్టక్రియాః సర్వ్వాః కరిష్యతి తాదృశం మమ మనోభిమతమ్ ఏకం జనం యిశయః పుత్రం దాయూదం ప్రాప్తవాన్ ఇదం ప్రమాణం యస్మిన్ దాయూది స దత్తవాన్ తం దాయూదం తేషాముపరి రాజత్వం కర్త్తుమ్ ఉత్పాదితవాన| ");
INSERT INTO santel_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","తస్య స్వప్రతిశ్రుతస్య వాక్యస్యానుసారేణ ఇస్రాయేల్లోకానాం నిమిత్తం తేషాం మనుష్యాణాం వంశాద్ ఈశ్వర ఏకం యీశుం (త్రాతారమ్) ఉదపాదయత్| ");
INSERT INTO santel_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","తస్య ప్రకాశనాత్ పూర్వ్వం యోహన్ ఇస్రాయేల్లోకానాం సన్నిధౌ మనఃపరావర్త్తనరూపం మజ్జనం ప్రాచారయత్| ");
INSERT INTO santel_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","యస్య చ కర్మ్మణోे భారం ప్రప్తవాన్ యోహన్ తన్ నిష్పాదయన్ ఏతాం కథాం కథితవాన్, యూయం మాం కం జనం జానీథ? అహమ్ అభిషిక్తత్రాతా నహి, కిన్తు పశ్యత యస్య పాదయోః పాదుకయో ర్బన్ధనే మోచయితుమపి యోగ్యో న భవామి తాదృశ ఏకో జనో మమ పశ్చాద్ ఉపతిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","హే ఇబ్రాహీమో వంశజాతా భ్రాతరో హే ఈశ్వరభీతాః సర్వ్వలోకా యుష్మాన్ ప్రతి పరిత్రాణస్య కథైషా ప్రేరితా| ");
INSERT INTO santel_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","యిరూశాలమ్నివాసినస్తేషామ్ అధిపతయశ్చ తస్య యీశోః పరిచయం న ప్రాప్య ప్రతివిశ్రామవారం పఠ్యమానానాం భవిష్యద్వాదికథానామ్ అభిప్రాయమ్ అబుద్ధ్వా చ తస్య వధేన తాః కథాః సఫలా అకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ప్రాణహననస్య కమపి హేతుమ్ అప్రాప్యాపి పీలాతస్య నికటే తస్య వధం ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","తస్మిన్ యాః కథా లిఖితాః సన్తి తదనుసారేణ కర్మ్మ సమ్పాద్య తం క్రుశాద్ అవతార్య్య శ్మశానే శాయితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","కిన్త్వీశ్వరః శ్మశానాత్ తముదస్థాపయత్, ");
INSERT INTO santel_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","పునశ్చ గాలీలప్రదేశాద్ యిరూశాలమనగరం తేన సార్ద్ధం యే లోకా ఆగచ్ఛన్ స బహుదినాని తేభ్యో దర్శనం దత్తవాన్, అతస్త ఇదానీం లోకాన్ ప్రతి తస్య సాక్షిణః సన్తి| ");
INSERT INTO santel_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","అస్మాకం పూర్వ్వపురుషాణాం సమక్షమ్ ఈశ్వరో యస్మిన్ ప్రతిజ్ఞాతవాన్ యథా, త్వం మే పుత్రోసి చాద్య త్వాం సముత్థాపితవానహమ్| ");
INSERT INTO santel_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ఇదం యద్వచనం ద్వితీయగీతే లిఖితమాస్తే తద్ యీశోరుత్థానేన తేషాం సన్తానా యే వయమ్ అస్మాకం సన్నిధౌ తేన ప్రత్యక్షీ కృతం, యుష్మాన్ ఇమం సుసంవాదం జ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","పరమేశ్వరేణ శ్మశానాద్ ఉత్థాపితం తదీయం శరీరం కదాపి న క్షేష్యతే, ఏతస్మిన్ స స్వయం కథితవాన్ యథా దాయూదం ప్రతి ప్రతిజ్ఞాతో యో వరస్తమహం తుభ్యం దాస్యామి| ");
INSERT INTO santel_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ఏతదన్యస్మిన్ గీతేఽపి కథితవాన్| స్వకీయం పుణ్యవన్తం త్వం క్షయితుం న చ దాస్యసి| ");
INSERT INTO santel_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","దాయూదా ఈశ్వరాభిమతసేవాయై నిజాయుషి వ్యయితే సతి స మహానిద్రాం ప్రాప్య నిజైః పూర్వ్వపురుషైః సహ మిలితః సన్ అక్షీయత; ");
INSERT INTO santel_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","కిన్తు యమీశ్వరః శ్మశానాద్ ఉదస్థాపయత్ స నాక్షీయత| ");
INSERT INTO santel_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","అతో హే భ్రాతరః, అనేన జనేన పాపమోచనం భవతీతి యుష్మాన్ ప్రతి ప్రచారితమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ఫలతో మూసావ్యవస్థయా యూయం యేభ్యో దోషేభ్యో ముక్తా భవితుం న శక్ష్యథ తేభ్యః సర్వ్వదోషేభ్య ఏతస్మిన్ జనే విశ్వాసినః సర్వ్వే ముక్తా భవిష్యన్తీతి యుష్మాభి ర్జ్ఞాయతాం| ");
INSERT INTO santel_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","అపరఞ్చ| అవజ్ఞాకారిణో లోకాశ్చక్షురున్మీల్య పశ్యత| తథైవాసమ్భవం జ్ఞాత్వా స్యాత యూయం విలజ్జితాః| యతో యుష్మాసు తిష్ఠత్సు కరిష్యే కర్మ్మ తాదృశం| యేనైవ తస్య వృత్తాన్తే యుష్మభ్యం కథితేఽపి హి| యూయం న తన్తు వృత్తాన్తం ప్రత్యేష్యథ కదాచన|| ");
INSERT INTO santel_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","యేయం కథా భవిష్యద్వాదినాం గ్రన్థేషు లిఖితాస్తే సావధానా భవత స కథా యథా యుష్మాన్ ప్రతి న ఘటతే| ");
INSERT INTO santel_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","యిహూదీయభజనభవనాన్ నిర్గతయోస్తయో ర్భిన్నదేశీయై ర్వక్ష్యమాణా ప్రార్థనా కృతా, ఆగామిని విశ్రామవారేఽపి కథేయమ్ అస్మాన్ ప్రతి ప్రచారితా భవత్వితి| ");
INSERT INTO santel_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","సభాయా భఙ్గే సతి బహవో యిహూదీయలోకా యిహూదీయమతగ్రాహిణో భక్తలోకాశ్చ బర్ణబ్బాపౌలయోః పశ్చాద్ ఆగచ్ఛన్, తేన తౌ తైః సహ నానాకథాః కథయిత్వేశ్వరానుగ్రహాశ్రయే స్థాతుం తాన్ ప్రావర్త్తయతాం| ");
INSERT INTO santel_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","పరవిశ్రామవారే నగరస్య ప్రాయేణ సర్వ్వే లాకా ఈశ్వరీయాం కథాం శ్రోతుం మిలితాః, ");
INSERT INTO santel_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","కిన్తు యిహూదీయలోకా జననివహం విలోక్య ఈర్ష్యయా పరిపూర్ణాః సన్తో విపరీతకథాకథనేనేశ్వరనిన్దయా చ పౌలేనోక్తాం కథాం ఖణ్డయితుం చేష్టితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","తతః పౌैలబర్ణబ్బావక్షోభౌ కథితవన్తౌ ప్రథమం యుష్మాకం సన్నిధావీశ్వరీయకథాయాః ప్రచారణమ్ ఉచితమాసీత్ కిన్తుం తదగ్రాహ్యత్వకరణేన యూయం స్వాన్ అనన్తాయుషోఽయోగ్యాన్ దర్శయథ, ఏతత్కారణాద్ వయమ్ అన్యదేశీయలోకానాం సమీపం గచ్ఛామః| ");
INSERT INTO santel_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ప్రభురస్మాన్ ఇత్థమ్ ఆదిష్టవాన్ యథా, యావచ్చ జగతః సీమాం లోకానాం త్రాణకారణాత్| మయాన్యదేశమధ్యే త్వం స్థాపితో భూః ప్రదీపవత్|| ");
INSERT INTO santel_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","తదా కథామీదృశీం శ్రుత్వా భిన్నదేశీయా ఆహ్లాదితాః సన్తః ప్రభోః కథాం ధన్యాం ధన్యామ్ అవదన్, యావన్తో లోకాశ్చ పరమాయుః ప్రాప్తినిమిత్తం నిరూపితా ఆసన్ తేे వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ఇత్థం ప్రభోః కథా సర్వ్వేదేశం వ్యాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","కిన్తు యిహూదీయా నగరస్య ప్రధానపురుషాన్ సమ్మాన్యాః కథిపయా భక్తా యోషితశ్చ కుప్రవృత్తిం గ్రాహయిత్వా పౌలబర్ణబ్బౌ తాడయిత్వా తస్మాత్ ప్రదేశాద్ దూరీకృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","అతః కారణాత్ తౌ నిజపదధూలీస్తేషాం ప్రాతికూల్యేన పాతయిత్వేेకనియం నగరం గతౌ| ");
INSERT INTO santel_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","తతః శిష్యగణ ఆనన్దేన పవిత్రేణాత్మనా చ పరిపూర్ణోభవత్| ");
INSERT INTO santel_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","తౌ ద్వౌ జనౌ యుగపద్ ఇకనియనగరస్థయిహూదీయానాం భజనభవనం గత్వా యథా బహవో యిహూదీయా అన్యదేेశీయలోకాశ్చ వ్యశ్వసన్ తాదృశీం కథాం కథితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","కిన్తు విశ్వాసహీనా యిహూదీయా అన్యదేశీయలోకాన్ కుప్రవృత్తిం గ్రాహయిత్వా భ్రాతృగణం ప్రతి తేషాం వైరం జనితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","అతః స్వానుగ్రహకథాయాః ప్రమాణం దత్వా తయో ర్హస్తై ర్బహులక్షణమ్ అద్భుతకర్మ్మ చ ప్రాకాశయద్ యః ప్రభుస్తస్య కథా అక్షోభేన ప్రచార్య్య తౌ తత్ర బహుదినాని సమవాతిష్ఠేతాం| ");
INSERT INTO santel_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","కిన్తు కియన్తో లోకా యిహూదీయానాం సపక్షాః కియన్తో లోకాః ప్రేరితానాం సపక్షా జాతాః, అతో నాగరికజననివహమధ్యే భిన్నవాక్యత్వమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","అన్యదేశీయా యిహూదీయాస్తేషామ్ అధిపతయశ్చ దౌరాత్మ్యం కుత్వా తౌ ప్రస్తరైరాహన్తుమ్ ఉద్యతాః| ");
INSERT INTO santel_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","తౌ తద్వార్త్తాం ప్రాప్య పలాయిత్వా లుకాయనియాదేశస్యాన్తర్వ్వర్త్తిలుస్త్రాదర్బ్బో ");
INSERT INTO santel_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","తత్సమీపస్థదేశఞ్చ గత్వా తత్ర సుసంవాదం ప్రచారయతాం| ");
INSERT INTO santel_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","తత్రోభయపాదయోశ్చలనశక్తిహీనో జన్మారభ్య ఖఞ్జః కదాపి గమనం నాకరోత్ ఏతాదృశ ఏకో మానుషో లుస్త్రానగర ఉపవిశ్య పౌలస్య కథాం శ్రుతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ఏతస్మిన్ సమయే పౌలస్తమ్ప్రతి దృష్టిం కృత్వా తస్య స్వాస్థ్యే విశ్వాసం విదిత్వా ప్రోచ్చైః కథితవాన్ ");
INSERT INTO santel_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","పద్భ్యాముత్తిష్ఠన్ ఋజు ర్భవ| తతః స ఉల్లమ్ఫం కృత్వా గమనాగమనే కుతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","తదా లోకాః పౌలస్య తత్ కార్య్యం విలోక్య లుకాయనీయభాషయా ప్రోచ్చైః కథామేతాం కథితవన్తః, దేవా మనుష్యరూపం ధృత్వాస్మాకం సమీపమ్ అవారోహన్| ");
INSERT INTO santel_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","తే బర్ణబ్బాం యూపితరమ్ అవదన్ పౌలశ్చ ముఖ్యో వక్తా తస్మాత్ తం మర్కురియమ్ అవదన్| ");
INSERT INTO santel_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","తస్య నగరస్య సమ్ముఖే స్థాపితస్య యూపితరవిగ్రహస్య యాజకో వృషాన్ పుష్పమాలాశ్చ ద్వారసమీపమ్ ఆనీయ లోకైః సర్ద్ధం తావుద్దిశ్య సముత్సృజ్య దాతుమ్ ఉద్యతః| ");
INSERT INTO santel_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","తద్వార్త్తాం శ్రుత్వా బర్ణబ్బాపౌలౌ స్వీయవస్త్రాణి ఛిత్వా లోకానాం మధ్యం వేగేన ప్రవిశ్య ప్రోచ్చైః కథితవన్తౌ, ");
INSERT INTO santel_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","హే మహేచ్ఛాః కుత ఏతాదృశం కర్మ్మ కురుథ? ఆవామపి యుష్మాదృశౌ సుఖదుఃఖభోగినౌ మనుష్యౌ, యుయమ్ ఏతాః సర్వ్వా వృథాకల్పనాః పరిత్యజ్య యథా గగణవసున్ధరాజలనిధీనాం తన్మధ్యస్థానాం సర్వ్వేషాఞ్చ స్రష్టారమమరమ్ ఈశ్వరం ప్రతి పరావర్త్తధ్వే తదర్థమ్ ఆవాం యుష్మాకం సన్నిధౌ సుసంవాదం ప్రచారయావః| ");
INSERT INTO santel_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","స ఈశ్వరః పూర్వ్వకాలే సర్వ్వదేశీయలోకాన్ స్వస్వమార్గే చలితుమనుమతిం దత్తవాన్, ");
INSERT INTO santel_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","తథాపి ఆకాశాత్ తోయవర్షణేన నానాప్రకారశస్యోత్పత్యా చ యుష్మాకం హితైషీ సన్ భక్ష్యైరాననదేన చ యుష్మాకమ్ అన్తఃకరణాని తర్పయన్ తాని దానాని నిజసాక్షిస్వరూపాణి స్థపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","కిన్తు తాదృశాయాం కథాయాం కథితాయామపి తయోః సమీప ఉత్సర్జనాత్ లోకనివహం ప్రాయేణ నివర్త్తయితుం నాశక్నుతామ్| ");
INSERT INTO santel_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ఆన్తియఖియా-ఇకనియనగరాభ్యాం కతిపయయిహూదీయలోకా ఆగత్య లోకాన్ ప్రావర్త్తయన్త తస్మాత్ తై పౌలం ప్రస్తరైరాఘ్నన్ తేన స మృత ఇతి విజ్ఞాయ నగరస్య బహిస్తమ్ ఆకృష్య నీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","కిన్తు శిష్యగణే తస్య చతుర్దిశి తిష్ఠతి సతి స స్వయమ్ ఉత్థాయ పునరపి నగరమధ్యం ప్రావిశత్ తత్పరేఽహని బర్ణబ్బాసహితో దర్బ్బీనగరం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","తత్ర సుసంవాదం ప్రచార్య్య బహులోకాన్ శిష్యాన్ కృత్వా తౌ లుస్త్రామ్ ఇకనియమ్ ఆన్తియఖియాఞ్చ పరావృత్య గతౌ| ");
INSERT INTO santel_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","బహుదుఃఖాని భుక్త్వాపీశ్వరరాజ్యం ప్రవేష్టవ్యమ్ ఇతి కారణాద్ ధర్మ్మమార్గే స్థాతుం వినయం కృత్వా శిష్యగణస్య మనఃస్థైర్య్యమ్ అకురుతాం| ");
INSERT INTO santel_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","మణ్డలీనాం ప్రాచీనవర్గాన్ నియుజ్య ప్రార్థనోపవాసౌ కృత్వా యత్ప్రభౌ తే వ్యశ్వసన్ తస్య హస్తే తాన్ సమర్ప్య ");
INSERT INTO santel_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","పిసిదియామధ్యేన పామ్ఫులియాదేశం గతవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","పశ్చాత్ పర్గానగరం గత్వా సుసంవాదం ప్రచార్య్య అత్తాలియానగరం ప్రస్థితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","తస్మాత్ సముద్రపథేన గత్వా తాభ్యాం యత్ కర్మ్మ సమ్పన్నం తత్కర్మ్మ సాధయితుం యన్నగరే దయాలోరీశ్వరస్య హస్తే సమర్పితౌ జాతౌ తద్ ఆన్తియఖియానగరం గతవన్తా| ");
INSERT INTO santel_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","తత్రోపస్థాయ తన్నగరస్థమణ్డలీం సంగృహ్య స్వాభ్యామ ఈశ్వరో యద్యత్ కర్మ్మకరోత్ తథా యేన ప్రకారేణ భిన్నదేశీయలోకాన్ ప్రతి విశ్వాసరూపద్వారమ్ అమోచయద్ ఏతాన్ సర్వ్వవృత్తాన్తాన్ తాన్ జ్ఞాపితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","తతస్తౌ శిర్య్యైః సార్ద్ధం తత్ర బహుదినాని న్యవసతామ్| ");
INSERT INTO santel_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","యిహూదాదేశాత్ కియన్తో జనా ఆగత్య భ్రాతృగణమిత్థం శిక్షితవన్తో మూసావ్యవస్థయా యది యుష్మాకం త్వక్ఛేదో న భవతి తర్హి యూయం పరిత్రాణం ప్రాప్తుం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","పౌలబర్ణబ్బౌ తైః సహ బహూన్ విచారాన్ వివాదాంశ్చ కృతవన్తౌ, తతో మణ్డలీయనోకా ఏతస్యాః కథాయాస్తత్త్వం జ్ఞాతుం యిరూశాలమ్నగరస్థాన్ ప్రేరితాన్ ప్రాచీనాంశ్చ ప్రతి పౌలబర్ణబ్బాప్రభృతీన్ కతిపయజనాన్ ప్రేషయితుం నిశ్చయం కృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","తే మణ్డల్యా ప్రేరితాః సన్తః ఫైణీకీశోమిరోన్దేశాభ్యాం గత్వా భిన్నదేశీయానాం మనఃపరివర్త్తనస్య వార్త్తయా భ్రాతృణాం పరమాహ్లాదమ్ అజనయన్| ");
INSERT INTO santel_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","యిరూశాలమ్యుపస్థాయ ప్రేరితగణేన లోకప్రాచీనగణేన సమాజేన చ సముపగృహీతాః సన్తః స్వైరీశ్వరో యాని కర్మ్మాణి కృతవాన్ తేషాం సర్వ్వవృత్తాన్తాన్ తేషాం సమక్షమ్ అకథయన్| ");
INSERT INTO santel_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","కిన్తు విశ్వాసినః కియన్తః ఫిరూశిమతగ్రాహిణో లోకా ఉత్థాయ కథామేతాం కథితవన్తో భిన్నదేశీయానాం త్వక్ఛేదం కర్త్తుం మూసావ్యవస్థాం పాలయితుఞ్చ సమాదేష్టవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","తతః ప్రేరితా లోకప్రాచీనాశ్చ తస్య వివేచనాం కర్త్తుం సభాయాం స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","బహువిచారేషు జాతషు పితర ఉత్థాయ కథితవాన్, హే భ్రాతరో యథా భిన్నదేశీయలోకా మమ ముఖాత్ సుసంవాదం శ్రుత్వా విశ్వసన్తి తదర్థం బహుదినాత్ పూర్వ్వమ్ ఈశ్వరోస్మాకం మధ్యే మాం వృత్వా నియుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","అన్తర్య్యామీశ్వరో యథాస్మభ్యం తథా భిన్నదేశీయేభ్యః పవిత్రమాత్మానం ప్రదాయ విశ్వాసేన తేషామ్ అన్తఃకరణాని పవిత్రాణి కృత్వా ");
INSERT INTO santel_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","తేషామ్ అస్మాకఞ్చ మధ్యే కిమపి విశేషం న స్థాపయిత్వా తానధి స్వయం ప్రమాణం దత్తవాన్ ఇతి యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","అతఏవాస్మాకం పూర్వ్వపురుషా వయఞ్చ స్వయం యద్యుగస్య భారం సోఢుం న శక్తాః సమ్ప్రతి తం శిష్యగణస్య స్కన్ధేషు న్యసితుం కుత ఈశ్వరస్య పరీక్షాం కరిష్యథ? ");
INSERT INTO santel_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ప్రభో ర్యీశుఖ్రీష్టస్యానుగ్రహేణ తే యథా వయమపి తథా పరిత్రాణం ప్రాప్తుమ్ ఆశాం కుర్మ్మః| ");
INSERT INTO santel_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","అనన్తరం బర్ణబ్బాపౌలాభ్యామ్ ఈశ్వరో భిన్నదేశీయానాం మధ్యే యద్యద్ ఆశ్చర్య్యమ్ అద్భుతఞ్చ కర్మ్మ కృతవాన్ తద్వృత్తాన్తం తౌ స్వముఖాభ్యామ్ అవర్ణయతాం సభాస్థాః సర్వ్వే నీరవాః సన్తః శ్రుతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","తయోః కథాయాం సమాప్తాయాం సత్యాం యాకూబ్ కథయితుమ్ ఆరబ్ధవాన్ ");
INSERT INTO santel_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","హే భ్రాతరో మమ కథాయామ్ మనో నిధత్త| ఈశ్వరః స్వనామార్థం భిన్నదేశీయలోకానామ్ మధ్యాద్ ఏకం లోకసంఘం గ్రహీతుం మతిం కృత్వా యేన ప్రకారేణ ప్రథమం తాన్ ప్రతి కృపావలేకనం కృతవాన్ తం శిమోన్ వర్ణితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","భవిష్యద్వాదిభిరుక్తాని యాని వాక్యాని తైః సార్ద్ధమ్ ఏతస్యైక్యం భవతి యథా లిఖితమాస్తే| ");
INSERT INTO santel_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","సర్వ్వేషాం కర్మ్మణాం యస్తు సాధకః పరమేశ్వరః| స ఏవేదం వదేద్వాక్యం శేషాః సకలమానవాః| భిన్నదేశీయలోకాశ్చ యావన్తో మమ నామతః| భవన్తి హి సువిఖ్యాతాస్తే యథా పరమేశితుః| ");
INSERT INTO santel_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","తత్వం సమ్యక్ సమీహన్తే తన్నిమిత్తమహం కిల| పరావృత్య సమాగత్య దాయూదః పతితం పునః| దూష్యముత్థాపయిష్యామి తదీయం సర్వ్వవస్తు చ| పతితం పునరుథాప్య సజ్జయిష్యామి సర్వ్వథా|| ");
INSERT INTO santel_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ఆ ప్రథమాద్ ఈశ్వరః స్వీయాని సర్వ్వకర్మ్మాణి జానాతి| ");
INSERT INTO santel_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","అతఏవ మమ నివేదనమిదం భిన్నదేశీయలోకానాం మధ్యే యే జనా ఈశ్వరం ప్రతి పరావర్త్తన్త తేషాముపరి అన్యం కమపి భారం న న్యస్య ");
INSERT INTO santel_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","దేవతాప్రసాదాశుచిభక్ష్యం వ్యభిచారకర్మ్మ కణ్ఠసమ్పీడనమారితప్రాణిభక్ష్యం రక్తభక్ష్యఞ్చ ఏతాని పరిత్యక్తుం లిఖామః| ");
INSERT INTO santel_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","యతః పూర్వ్వకాలతో మూసావ్యవస్థాప్రచారిణో లోకా నగరే నగరే సన్తి ప్రతివిశ్రామవారఞ్చ భజనభవనే తస్యాః పాఠో భవతి| ");
INSERT INTO santel_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","తతః పరం ప్రేరితగణో లోకప్రాచీనగణః సర్వ్వా మణ్డలీ చ స్వేషాం మధ్యే బర్శబ్బా నామ్నా విఖ్యాతో మనోనీతౌ కృత్వా పౌలబర్ణబ్బాభ్యాం సార్ద్ధమ్ ఆన్తియఖియానగరం ప్రతి ప్రేషణమ్ ఉచితం బుద్ధ్వా తాభ్యాం పత్రం ప్రైషయన్| ");
INSERT INTO santel_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","తస్మిన్ పత్రే లిఖితమింద, ఆన్తియఖియా-సురియా-కిలికియాదేశస్థభిన్నదేశీయభ్రాతృగణాయ ప్రేరితగణస్య లోకప్రాచీనగణస్య భ్రాతృగణస్య చ నమస్కారః| ");
INSERT INTO santel_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","విశేషతోఽస్మాకమ్ ఆజ్ఞామ్ అప్రాప్యాపి కియన్తో జనా అస్మాకం మధ్యాద్ గత్వా త్వక్ఛేదో మూసావ్యవస్థా చ పాలయితవ్యావితి యుష్మాన్ శిక్షయిత్వా యుష్మాకం మనసామస్థైర్య్యం కృత్వా యుష్మాన్ ససన్దేహాన్ అకుర్వ్వన్ ఏతాం కథాం వయమ్ అశృన్మ| ");
INSERT INTO santel_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","తత్కారణాద్ వయమ్ ఏకమన్త్రణాః సన్తః సభాయాం స్థిత్వా ప్రభో ర్యీశుఖ్రీష్టస్య నామనిమిత్తం మృత్యుముఖగతాభ్యామస్మాకం ");
INSERT INTO santel_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ప్రియబర్ణబ్బాపౌలాభ్యాం సార్ద్ధం మనోనీతలోకానాం కేషాఞ్చిద్ యుష్మాకం సన్నిధౌ ప్రేషణమ్ ఉచితం బుద్ధవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","అతో యిహూదాసీలౌ యుష్మాన్ ప్రతి ప్రేషితవన్తః, ఏతయో ర్ముఖాభ్యాం సర్వ్వాం కథాం జ్ఞాస్యథ| ");
INSERT INTO santel_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","దేవతాప్రసాదభక్ష్యం రక్తభక్ష్యం గలపీడనమారితప్రాణిభక్ష్యం వ్యభిచారకర్మ్మ చేమాని సర్వ్వాణి యుష్మాభిస్త్యాజ్యాని; ఏతత్ప్రయోజనీయాజ్ఞావ్యతిరేకేన యుష్మాకమ్ ఉపరి భారమన్యం న న్యసితుం పవిత్రస్యాత్మనోఽస్మాకఞ్చ ఉచితజ్ఞానమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","అతఏవ తేభ్యః సర్వ్వేభ్యః స్వేషు రక్షితేషు యూయం భద్రం కర్మ్మ కరిష్యథ| యుష్మాకం మఙ్గలం భూయాత్| ");
INSERT INTO santel_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","తేे విసృష్టాః సన్త ఆన్తియఖియానగర ఉపస్థాయ లోకనివహం సంగృహ్య పత్రమ్ అదదన్| ");
INSERT INTO santel_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","తతస్తే తత్పత్రం పఠిత్వా సాన్త్వనాం ప్రాప్య సానన్దా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","యిహూదాసీలౌ చ స్వయం ప్రచారకౌ భూత్వా భ్రాతృగణం నానోపదిశ్య తాన్ సుస్థిరాన్ అకురుతామ్| ");
INSERT INTO santel_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ఇత్థం తౌ తత్ర తైః సాకం కతిపయదినాని యాపయిత్వా పశ్చాత్ ప్రేరితానాం సమీపే ప్రత్యాగమనార్థం తేషాం సన్నిధేః కల్యాణేన విసృష్టావభవతాం| ");
INSERT INTO santel_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","కిన్తు సీలస్తత్ర స్థాతుం వాఞ్ఛితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","అపరం పౌలబర్ణబ్బౌ బహవః శిష్యాశ్చ లోకాన్ ఉపదిశ్య ప్రభోః సుసంవాదం ప్రచారయన్త ఆన్తియఖియాయాం కాలం యాపితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","కతిపయదినేషు గతేషు పౌలో బర్ణబ్బామ్ అవదత్ ఆగచ్ఛావాం యేషు నగరేష్వీశ్వరస్య సుసంవాదం ప్రచారితవన్తౌ తాని సర్వ్వనగరాణి పునర్గత్వా భ్రాతరః కీదృశాః సన్తీతి ద్రష్టుం తాన్ సాక్షాత్ కుర్వ్వః| ");
INSERT INTO santel_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","తేన మార్కనామ్నా విఖ్యాతం యోహనం సఙ్గినం కర్త్తుం బర్ణబ్బా మతిమకరోత్, ");
INSERT INTO santel_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","కిన్తు స పూర్వ్వం తాభ్యాం సహ కార్య్యార్థం న గత్వా పామ్ఫూలియాదేశే తౌ త్యక్తవాన్ తత్కారణాత్ పౌలస్తం సఙ్గినం కర్త్తుమ్ అనుచితం జ్ఞాతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ఇత్థం తయోరతిశయవిరోధస్యోపస్థితత్వాత్ తౌ పరస్పరం పృథగభవతాం తతో బర్ణబ్బా మార్కం గృహీత్వా పోతేన కుప్రోపద్వీపం గతవాన్; ");
INSERT INTO santel_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","కిన్తు పౌలః సీలం మనోనీతం కృత్వా భ్రాతృభిరీశ్వరానుగ్రహే సమర్పితః సన్ ప్రస్థాయ ");
INSERT INTO santel_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","సురియాకిలికియాదేశాభ్యాం మణ్డలీః స్థిరీకుర్వ్వన్ అగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","పౌలో దర్బ్బీలుస్త్రానగరయోరుపస్థితోభవత్ తత్ర తీమథియనామా శిష్య ఏక ఆసీత్; స విశ్వాసిన్యా యిహూదీయాయా యోషితో గర్బ్భజాతః కిన్తు తస్య పితాన్యదేశీయలోకః| ");
INSERT INTO santel_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","స జనో లుస్త్రా-ఇకనియనగరస్థానాం భ్రాతృణాం సమీపేపి సుఖ్యాతిమాన్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","పౌలస్తం స్వసఙ్గినం కర్త్తుం మతిం కృత్వా తం గృహీత్వా తద్దేశనివాసినాం యిహూదీయానామ్ అనురోధాత్ తస్య త్వక్ఛేదం కృతవాన్ యతస్తస్య పితా భిన్నదేశీయలోక ఇతి సర్వ్వైరజ్ఞాయత| ");
INSERT INTO santel_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","తతః పరం తే నగరే నగరే భ్రమిత్వా యిరూశాలమస్థైః ప్రేరితై ర్లోకప్రాచీనైశ్చ నిరూపితం యద్ వ్యవస్థాపత్రం తదనుసారేణాచరితుం లోకేభ్యస్తద్ దత్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","తేనైవ సర్వ్వే ధర్మ్మసమాజాః ఖ్రీష్టధర్మ్మే సుస్థిరాః సన్తః ప్రతిదినం వర్ద్ధితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","తేషు ఫ్రుగియాగాలాతియాదేశమధ్యేన గతేషు సత్సు పవిత్ర ఆత్మా తాన్ ఆశియాదేశే కథాం ప్రకాశయితుం ప్రతిషిద్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","తథా ముసియాదేశ ఉపస్థాయ బిథునియాం గన్తుం తైరుద్యోగే కృతే ఆత్మా తాన్ నాన్వమన్యత| ");
INSERT INTO santel_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","తస్మాత్ తే ముసియాదేశం పరిత్యజ్య త్రోయానగరం గత్వా సముపస్థితాః| ");
INSERT INTO santel_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","రాత్రౌ పౌలః స్వప్నే దృష్టవాన్ ఏకో మాకిదనియలోకస్తిష్ఠన్ వినయం కృత్వా తస్మై కథయతి, మాకిదనియాదేశమ్ ఆగత్యాస్మాన్ ఉపకుర్వ్వితి| ");
INSERT INTO santel_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","తస్యేత్థం స్వప్నదర్శనాత్ ప్రభుస్తద్దేశీయలోకాన్ ప్రతి సుసంవాదం ప్రచారయితుమ్ అస్మాన్ ఆహూయతీతి నిశ్చితం బుద్ధ్వా వయం తూర్ణం మాకిదనియాదేశం గన్తుమ్ ఉద్యోగమ్ అకుర్మ్మ| ");
INSERT INTO santel_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","తతః పరం వయం త్రోయానగరాద్ ప్రస్థాయ ఋజుమార్గేణ సామథ్రాకియోపద్వీపేన గత్వా పరేఽహని నియాపలినగర ఉపస్థితాః| ");
INSERT INTO santel_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","తస్మాద్ గత్వా మాకిదనియాన్తర్వ్వర్త్తి రోమీయవసతిస్థానం యత్ ఫిలిపీనామప్రధాననగరం తత్రోపస్థాయ కతిపయదినాని తత్ర స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","విశ్రామవారే నగరాద్ బహి ర్గత్వా నదీతటే యత్ర ప్రార్థనాచార ఆసీత్ తత్రోపవిశ్య సమాగతా నారీః ప్రతి కథాం ప్రాచారయామ| ");
INSERT INTO santel_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","తతః థుయాతీరానగరీయా ధూషరామ్బరవిక్రాయిణీ లుదియానామికా యా ఈశ్వరసేవికా యోషిత్ శ్రోత్రీణాం మధ్య ఆసీత్ తయా పౌలోక్తవాక్యాని యద్ గృహ్యన్తే తదర్థం ప్రభుస్తస్యా మనోద్వారం ముక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","అతః సా యోషిత్ సపరివారా మజ్జితా సతీ వినయం కృత్వా కథితవతీ, యుష్మాకం విచారాద్ యది ప్రభౌ విశ్వాసినీ జాతాహం తర్హి మమ గృహమ్ ఆగత్య తిష్ఠత| ఇత్థం సా యత్నేనాస్మాన్ అస్థాపయత్| ");
INSERT INTO santel_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","యస్యా గణనయా తదధిపతీనాం బహుధనోపార్జనం జాతం తాదృశీ గణకభూతగ్రస్తా కాచన దాసీ ప్రార్థనాస్థానగమనకాల ఆగత్యాస్మాన్ సాక్షాత్ కృతవతీ| ");
INSERT INTO santel_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","సాస్మాకం పౌలస్య చ పశ్చాద్ ఏత్య ప్రోచ్చైః కథామిమాం కథితవతీ, మనుష్యా ఏతే సర్వ్వోపరిస్థస్యేశ్వరస్య సేవకాః సన్తోఽస్మాన్ ప్రతి పరిత్రాణస్య మార్గం ప్రకాశయన్తి| ");
INSERT INTO santel_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","సా కన్యా బహుదినాని తాదృశమ్ అకరోత్ తస్మాత్ పౌలో దుఃఖితః సన్ ముఖం పరావర్త్య తం భూతమవదద్, అహం యీశుఖ్రీష్టస్య నామ్నా త్వామాజ్ఞాపయామి త్వమస్యా బహిర్గచ్ఛ; తేనైవ తత్క్షణాత్ స భూతస్తస్యా బహిర్గతః| ");
INSERT INTO santel_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","తతః స్వేషాం లాభస్య ప్రత్యాశా విఫలా జాతేతి విలోక్య తస్యాః ప్రభవః పౌలం సీలఞ్చ ధృత్వాకృష్య విచారస్థానేఽధిపతీనాం సమీపమ్ ఆనయన్| ");
INSERT INTO santel_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","తతః శాసకానాం నికటం నీత్వా రోమిలోకా వయమ్ అస్మాకం యద్ వ్యవహరణం గ్రహీతుమ్ ఆచరితుఞ్చ నిషిద్ధం, ");
INSERT INTO santel_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ఇమే యిహూదీయలోకాః సన్తోపి తదేవ శిక్షయిత్వా నగరేఽస్మాకమ్ అతీవ కలహం కుర్వ్వన్తి, ");
INSERT INTO santel_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ఇతి కథితే సతి లోకనివహస్తయోః ప్రాతికూల్యేనోదతిష్ఠత్ తథా శాసకాస్తయో ర్వస్త్రాణి ఛిత్వా వేత్రాఘాతం కర్త్తుమ్ ఆజ్ఞాపయన్| ");
INSERT INTO santel_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","అపరం తే తౌ బహు ప్రహార్య్య త్వమేతౌ కారాం నీత్వా సావధానం రక్షయేతి కారారక్షకమ్ ఆదిశన్| ");
INSERT INTO santel_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ఇత్థమ్ ఆజ్ఞాం ప్రాప్య స తావభ్యన్తరస్థకారాం నీత్వా పాదేషు పాదపాశీభి ర్బద్ధ్వా స్థాపితావాన్| ");
INSERT INTO santel_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","అథ నిశీథసమయే పౌలసీలావీశ్వరముద్దిశ్య ప్రాథనాం గానఞ్చ కృతవన్తౌ, కారాస్థితా లోకాశ్చ తదశృణ్వన్ ");
INSERT INTO santel_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","తదాకస్మాత్ మహాన్ భూమికమ్పోఽభవత్ తేన భిత్తిమూలేన సహ కారా కమ్పితాభూత్ తత్క్షణాత్ సర్వ్వాణి ద్వారాణి ముక్తాని జాతాని సర్వ్వేషాం బన్ధనాని చ ముక్తాని| ");
INSERT INTO santel_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","అతఏవ కారారక్షకో నిద్రాతో జాగరిత్వా కారాయా ద్వారాణి ముక్తాని దృష్ట్వా బన్దిలోకాః పలాయితా ఇత్యనుమాయ కోషాత్ ఖఙ్గం బహిః కృత్వాత్మఘాతం కర్త్తుమ్ ఉద్యతః| ");
INSERT INTO santel_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","కిన్తు పౌలః ప్రోచ్చైస్తమాహూయ కథితవాన్ పశ్య వయం సర్వ్వేఽత్రాస్మహే, త్వం నిజప్రాణహింసాం మాకార్షీః| ");
INSERT INTO santel_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","తదా ప్రదీపమ్ ఆనేతుమ్ ఉక్త్వా స కమ్పమానః సన్ ఉల్లమ్ప్యాభ్యన్తరమ్ ఆగత్య పౌలసీలయోః పాదేషు పతితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","పశ్చాత్ స తౌ బహిరానీయ పృష్టవాన్ హే మహేచ్ఛౌ పరిత్రాణం ప్రాప్తుం మయా కిం కర్త్తవ్యం? ");
INSERT INTO santel_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","పశ్చాత్ తౌ స్వగృహమానీయ తయోః సమ్ముఖే ఖాద్యద్రవ్యాణి స్థాపితవాన్ తథా స స్వయం తదీయాః సర్వ్వే పరివారాశ్చేశ్వరే విశ్వసన్తః సానన్దితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","తస్మై తస్య గృహస్థితసర్వ్వలోకేభ్యశ్చ ప్రభోః కథాం కథితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","తథా రాత్రేస్తస్మిన్నేవ దణ్డే స తౌ గృహీత్వా తయోః ప్రహారాణాం క్షతాని ప్రక్షాలితవాన్ తతః స స్వయం తస్య సర్వ్వే పరిజనాశ్చ మజ్జితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","పశ్చాత్ తౌ స్వగృహమానీయ తయోః సమ్ముఖే ఖాద్యద్రవ్యాణి స్థాపితవాన్ తథా స స్వయం తదీయాః సర్వ్వే పరివారాశ్చేశ్వరే విశ్వసన్తః సానన్దితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","దిన ఉపస్థితే తౌ లోకౌ మోచయేతి కథాం కథయితుం శాసకాః పదాతిగణం ప్రేషితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","తతః కారారక్షకః పౌలాయ తాం వార్త్తాం కథితవాన్ యువాం త్యాజయితుం శాసకా లోకాన ప్రేషితవన్త ఇదానీం యువాం బహి ర్భూత్వా కుశలేన ప్రతిష్ఠేతాం| ");
INSERT INTO santel_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","కిన్తు పౌలస్తాన్ అవదత్ రోమిలోకయోరావయోః కమపి దోషమ్ న నిశ్చిత్య సర్వ్వేషాం సమక్షమ్ ఆవాం కశయా తాడయిత్వా కారాయాం బద్ధవన్త ఇదానీం కిమావాం గుప్తం విస్త్రక్ష్యన్తి? తన్న భవిష్యతి, స్వయమాగత్యావాం బహిః కృత్వా నయన్తు| ");
INSERT INTO santel_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","తదా పదాతిభిః శాసకేభ్య ఏతద్వార్త్తాయాం కథితాయాం తౌ రోమిలోకావితి కథాం శ్రుత్వా తే భీతాః ");
INSERT INTO santel_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","సన్తస్తయోః సన్నిధిమాగత్య వినయమ్ అకుర్వ్వన్ అపరం బహిః కృత్వా నగరాత్ ప్రస్థాతుం ప్రార్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","తతస్తౌ కారాయా నిర్గత్య లుదియాయా గృహం గతవన్తౌ తత్ర భ్రాతృగణం సాక్షాత్కృత్య తాన్ సాన్త్వయిత్వా తస్మాత్ స్థానాత్ ప్రస్థితౌ| ");
INSERT INTO santel_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","పౌలసీలౌ ఆమ్ఫిపల్యాపల్లోనియానగరాభ్యాం గత్వా యత్ర యిహూదీయానాం భజనభవనమేకమ్ ఆస్తే తత్ర థిషలనీకీనగర ఉపస్థితౌ| ");
INSERT INTO santel_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","తదా పౌలః స్వాచారానుసారేణ తేషాం సమీపం గత్వా విశ్రామవారత్రయే తైః సార్ద్ధం ధర్మ్మపుస్తకీయకథాయా విచారం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ఫలతః ఖ్రీష్టేన దుఃఖభోగః కర్త్తవ్యః శ్మశానదుత్థానఞ్చ కర్త్తవ్యం యుష్మాకం సన్నిధౌ యస్య యీశోః ప్రస్తావం కరోమి స ఈశ్వరేణాభిషిక్తః స ఏతాః కథాః ప్రకాశ్య ప్రమాణం దత్వా స్థిరీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","తస్మాత్ తేషాం కతిపయజనా అన్యదేశీయా బహవో భక్తలోకా బహ్యః ప్రధాననార్య్యశ్చ విశ్వస్య పౌలసీలయోః పశ్చాద్గామినో జాతాః| ");
INSERT INTO santel_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","కిన్తు విశ్వాసహీనా యిహూదీయలోకా ఈర్ష్యయా పరిపూర్ణాః సన్తో హటట్స్య కతినయలమ్పటలోకాన్ సఙ్గినః కృత్వా జనతయా నగరమధ్యే మహాకలహం కృత్వా యాసోనో గృహమ్ ఆక్రమ్య ప్రేరితాన్ ధృత్వా లోకనివహస్య సమీపమ్ ఆనేతుం చేష్టితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","తేషాముద్దేశమ్ అప్రాప్య చ యాసోనం కతిపయాన్ భ్రాతృంశ్చ ధృత్వా నగరాధిపతీనాం నికటమానీయ ప్రోచ్చైః కథితవన్తో యే మనుష్యా జగదుద్వాటితవన్తస్తే ఽత్రాప్యుపస్థితాః సన్తి, ");
INSERT INTO santel_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ఏష యాసోన్ ఆతిథ్యం కృత్వా తాన్ గృహీతవాన్| యీశునామక ఏకో రాజస్తీతి కథయన్తస్తే కైసరస్యాజ్ఞావిరుద్ధం కర్మ్మ కుర్వ్వతి| ");
INSERT INTO santel_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","తేషాం కథామిమాం శ్రుత్వా లోకనివహో నగరాధిపతయశ్చ సముద్విగ్నా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","తదా యాసోనస్తదన్యేషాఞ్చ ధనదణ్డం గృహీత్వా తాన్ పరిత్యక్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","తతః పరం భ్రాతృగణో రజన్యాం పౌలసీలౌ శీఘ్రం బిరయానగరం ప్రేషితవాన్ తౌ తత్రోపస్థాయ యిహూదీయానాం భజనభవనం గతవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","తత్రస్థా లోకాః థిషలనీకీస్థలోకేభ్యో మహాత్మాన ఆసన్ యత ఇత్థం భవతి న వేతి జ్ఞాతుం దినే దినే ధర్మ్మగ్రన్థస్యాలోచనాం కృత్వా స్వైరం కథామ్ అగృహ్లన్| ");
INSERT INTO santel_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","తస్మాద్ అనేకే యిహూదీయా అన్యదేశీయానాం మాన్యా స్త్రియః పురుషాశ్చానేకే వ్యశ్వసన్| ");
INSERT INTO santel_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","కిన్తు బిరయానగరే పౌలేనేశ్వరీయా కథా ప్రచార్య్యత ఇతి థిషలనీకీస్థా యిహూదీయా జ్ఞాత్వా తత్స్థానమప్యాగత్య లోకానాం కుప్రవృత్తిమ్ అజనయన్| ");
INSERT INTO santel_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","అతఏవ తస్మాత్ స్థానాత్ సముద్రేణ యాన్తీతి దర్శయిత్వా భ్రాతరః క్షిప్రం పౌలం ప్రాహిణ్వన్ కిన్తు సీలతీమథియౌ తత్ర స్థితవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","తతః పరం పౌలస్య మార్గదర్శకాస్తమ్ ఆథీనీనగర ఉపస్థాపయన్ పశ్చాద్ యువాం తూర్ణమ్ ఏతత్ స్థానం ఆగమిష్యథః సీలతీమథియౌ ప్రతీమామ్ ఆజ్ఞాం ప్రాప్య తే ప్రత్యాగతాః| ");
INSERT INTO santel_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","పౌల ఆథీనీనగరే తావపేక్ష్య తిష్ఠన్ తన్నగరం ప్రతిమాభిః పరిపూర్ణం దృష్ట్వా సన్తప్తహృదయో ఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","తతః స భజనభవనే యాన్ యిహూదీయాన్ భక్తలోకాంశ్చ హట్టే చ యాన్ అపశ్యత్ తైః సహ ప్రతిదినం విచారితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","కిన్త్విపికూరీయమతగ్రహిణః స్తోయికీయమతగ్రాహిణశ్చ కియన్తో జనాస్తేన సార్ద్ధం వ్యవదన్త| తత్ర కేచిద్ అకథయన్ ఏష వాచాలః కిం వక్తుమ్ ఇచ్ఛతి? అపరే కేచిద్ ఏష జనః కేషాఞ్చిద్ విదేశీయదేవానాం ప్రచారక ఇత్యనుమీయతే యతః స యీశుమ్ ఉత్థితిఞ్చ ప్రచారయత్| ");
INSERT INTO santel_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","తే తమ్ అరేయపాగనామ విచారస్థానమ్ ఆనీయ ప్రావోచన్ ఇదం యన్నవీనం మతం త్వం ప్రాచీకశ ఇదం కీదృశం ఏతద్ అస్మాన్ శ్రావయ; ");
INSERT INTO santel_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","యామిమామ్ అసమ్భవకథామ్ అస్మాకం కర్ణగోచరీకృతవాన్ అస్యా భావార్థః క ఇతి వయం జ్ఞాతుమ్ ఇచ్ఛామః| ");
INSERT INTO santel_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","తదాథీనీనివాసినస్తన్నగరప్రవాసినశ్చ కేవలం కస్యాశ్చన నవీనకథాయాః శ్రవణేన ప్రచారణేన చ కాలమ్ అయాపయన్| ");
INSERT INTO santel_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","పౌలోఽరేయపాగస్య మధ్యే తిష్ఠన్ ఏతాం కథాం ప్రచారితవాన్, హే ఆథీనీయలోకా యూయం సర్వ్వథా దేవపూజాయామ్ ఆసక్తా ఇత్యహ ప్రత్యక్షం పశ్యామి| ");
INSERT INTO santel_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","యతః పర్య్యటనకాలే యుష్మాకం పూజనీయాని పశ్యన్ ‘అవిజ్ఞాతేశ్వరాయ’ ఏతల్లిపియుక్తాం యజ్ఞవేదీమేకాం దృష్టవాన్; అతో న విదిత్వా యం పూజయధ్వే తస్యైవ తత్వం యుష్మాన్ ప్రతి ప్రచారయామి| ");
INSERT INTO santel_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","జగతో జగత్స్థానాం సర్వ్వవస్తూనాఞ్చ స్రష్టా య ఈశ్వరః స స్వర్గపృథివ్యోరేకాధిపతిః సన్ కరనిర్మ్మితమన్దిరేషు న నివసతి; ");
INSERT INTO santel_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","స ఏవ సర్వ్వేభ్యో జీవనం ప్రాణాన్ సర్వ్వసామగ్రీశ్చ ప్రదదాతి; అతఏవ స కస్యాశ్చిత్ సామగ్య్రా అభావహేతో ర్మనుష్యాణాం హస్తైః సేవితో భవతీతి న| ");
INSERT INTO santel_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","స భూమణ్డలే నివాసార్థమ్ ఏకస్మాత్ శోణితాత్ సర్వ్వాన్ మనుష్యాన్ సృష్ట్వా తేషాం పూర్వ్వనిరూపితసమయం వసతిసీమాఞ్చ నిరచినోత్; ");
INSERT INTO santel_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","తస్మాత్ లోకైః కేనాపి ప్రకారేణ మృగయిత్వా పరమేశ్వరస్య తత్వం ప్రాప్తుం తస్య గవేషణం కరణీయమ్| ");
INSERT INTO santel_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","కిన్తు సోఽస్మాకం కస్మాచ్చిదపి దూరే తిష్ఠతీతి నహి, వయం తేన నిశ్వసనప్రశ్వసనగమనాగమనప్రాణధారణాని కుర్మ్మః, పుुనశ్చ యుష్మాకమేవ కతిపయాః కవయః కథయన్తి ‘తస్య వంశా వయం స్మో హి’ ఇతి| ");
INSERT INTO santel_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","అతఏవ యది వయమ్ ఈశ్వరస్య వంశా భవామస్తర్హి మనుష్యై ర్విద్యయా కౌశలేన చ తక్షితం స్వర్ణం రూప్యం దృషద్ వైతేషామీశ్వరత్వమ్ అస్మాభి ర్న జ్ఞాతవ్యం| ");
INSERT INTO santel_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","తేషాం పూర్వ్వీయలోకానామ్ అజ్ఞానతాం ప్రతీశ్వరో యద్యపి నావాధత్త తథాపీదానీం సర్వ్వత్ర సర్వ్వాన్ మనః పరివర్త్తయితుమ్ ఆజ్ఞాపయతి, ");
INSERT INTO santel_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","యతః స్వనియుక్తేన పురుషేణ యదా స పృథివీస్థానాం సర్వ్వలోకానాం విచారం కరిష్యతి తద్దినం న్యరూపయత్; తస్య శ్మశానోత్థాపనేన తస్మిన్ సర్వ్వేభ్యః ప్రమాణం ప్రాదాత్| ");
INSERT INTO santel_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","తదా శ్మశానాద్ ఉత్థానస్య కథాం శ్రుత్వా కేచిద్ ఉపాహమన్, కేచిదవదన్ ఏనాం కథాం పునరపి త్వత్తః శ్రోష్యామః| ");
INSERT INTO santel_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","తతః పౌలస్తేషాం సమీపాత్ ప్రస్థిाతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","తథాపి కేచిల్లోకాస్తేన సార్ద్ధం మిలిత్వా వ్యశ్వసన్ తేషాం మధ్యే ఽరేయపాగీయదియనుసియో దామారీనామా కాచిన్నారీ కియన్తో నరాశ్చాసన్| ");
INSERT INTO santel_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","తద్ఘటనాతః పరం పౌల ఆథీనీనగరాద్ యాత్రాం కృత్వా కరిన్థనగరమ్ ఆగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","తస్మిన్ సమయే క్లౌదియః సర్వ్వాన్ యిహూదీయాన్ రోమానగరం విహాయ గన్తుమ్ ఆజ్ఞాపయత్, తస్మాత్ ప్రిస్కిల్లానామ్నా జాయయా సార్ద్ధమ్ ఇతాలియాదేశాత్ కిఞ్చిత్పూర్వ్వమ్ ఆగమత్ యః పన్తదేశే జాత ఆక్కిలనామా యిహూదీయలోకః పౌలస్తం సాక్షాత్ ప్రాప్య తయోః సమీపమితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","తౌ దూష్యనిర్మ్మాణజీవినౌ, తస్మాత్ పరస్పరమ్ ఏకవృత్తికత్వాత్ స తాభ్యాం సహ ఉషిత్వా తత్ కర్మ్మాకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","పౌలః ప్రతివిశ్రామవారం భజనభవనం గత్వా విచారం కృత్వా యిహూదీయాన్ అన్యదేశీయాంశ్చ ప్రవృత్తిం గ్రాహితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","సీలతీమథియయో ర్మాకిదనియాదేశాత్ సమేతయోః సతోః పౌల ఉత్తప్తమనా భూత్వా యీశురీశ్వరేణాభిషిక్తో భవతీతి ప్రమాణం యిహూదీయానాం సమీపే ప్రాదాత్| ");
INSERT INTO santel_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","కిన్తు తే ఽతీవ విరోధం విధాయ పాషణ్డీయకథాం కథితవన్తస్తతః పౌలో వస్త్రం ధున్వన్ ఏతాం కథాం కథితవాన్, యుష్మాకం శోణితపాతాపరాధో యుష్మాన్ ప్రత్యేవ భవతు, తేనాహం నిరపరాధో ఽద్యారభ్య భిన్నదేశీయానాం సమీపం యామి| ");
INSERT INTO santel_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","స తస్మాత్ ప్రస్థాయ భజనభవనసమీపస్థస్య యుస్తనామ్న ఈశ్వరభక్తస్య భిన్నదేశీయస్య నివేశనం ప్రావిశత్| ");
INSERT INTO santel_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","తతః క్రీష్పనామా భజనభవనాధిపతిః సపరివారః ప్రభౌ వ్యశ్వసీత్, కరిన్థనగరీయా బహవో లోకాశ్చ సమాకర్ణ్య విశ్వస్య మజ్జితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","క్షణదాయాం ప్రభుః పౌలం దర్శనం దత్వా భాషితవాన్, మా భైషీః, మా నిరసీః కథాం ప్రచారయ| ");
INSERT INTO santel_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","అహం త్వయా సార్ద్ధమ్ ఆస హింసార్థం కోపి త్వాం స్ప్రష్టుం న శక్ష్యతి నగరేఽస్మిన్ మదీయా లోకా బహవ ఆసతే| ");
INSERT INTO santel_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","తస్మాత్ పౌలస్తన్నగరే ప్రాయేణ సార్ద్ధవత్సరపర్య్యన్తం సంస్థాయేశ్వరస్య కథామ్ ఉపాదిశత్| ");
INSERT INTO santel_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","గాల్లియనామా కశ్చిద్ ఆఖాయాదేశస్య ప్రాడ్వివాకః సమభవత్, తతో యిహూదీయా ఏకవాక్యాః సన్తః పౌలమ్ ఆక్రమ్య విచారస్థానం నీత్వా ");
INSERT INTO santel_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","మానుష ఏష వ్యవస్థాయ విరుద్ధమ్ ఈశ్వరభజనం కర్త్తుం లోకాన్ కుప్రవృత్తిం గ్రాహయతీతి నివేదితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","తతః పౌలే ప్రత్యుత్తరం దాతుమ్ ఉద్యతే సతి గాల్లియా యిహూదీయాన్ వ్యాహరత్, యది కస్యచిద్ అన్యాయస్య వాతిశయదుష్టతాచరణస్య విచారోఽభవిష్యత్ తర్హి యుష్మాకం కథా మయా సహనీయాభవిష్యత్| ");
INSERT INTO santel_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","కిన్తు యది కేవలం కథాయా వా నామ్నో వా యుష్మాకం వ్యవస్థాయా వివాదో భవతి తర్హి తస్య విచారమహం న కరిష్యామి, యూయం తస్య మీమాంసాం కురుత| ");
INSERT INTO santel_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","తతః స తాన్ విచారస్థానాద్ దూరీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","తదా భిన్నదేశీయాః సోస్థినినామానం భజనభవనస్య ప్రధానాధిపతిం ధృత్వా విచారస్థానస్య సమ్ముఖే ప్రాహరన్ తథాపి గాల్లియా తేషు సర్వ్వకర్మ్మసు న మనో న్యదధాత్| ");
INSERT INTO santel_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","పౌలస్తత్ర పునర్బహుదినాని న్యవసత్, తతో భ్రాతృగణాద్ విసర్జనం ప్రాప్య కిఞ్చనవ్రతనిమిత్తం కింక్రియానగరే శిరో ముణ్డయిత్వా ప్రిస్కిల్లాక్కిలాభ్యాం సహితో జలపథేన సురియాదేశం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","తత ఇఫిషనగర ఉపస్థాయ తత్ర తౌ విసృజ్య స్వయం భజనభ్వనం ప్రవిశ్య యిహూదీయైః సహ విచారితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","తే స్వైః సార్ద్ధం పునః కతిపయదినాని స్థాతుం తం వ్యనయన్, స తదనురరీకృత్య కథామేతాం కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","యిరూశాలమి ఆగామ్యుత్సవపాలనార్థం మయా గమనీయం; పశ్చాద్ ఈశ్వరేచ్ఛాయాం జాతాయాం యుష్మాకం సమీపం ప్రత్యాగమిష్యామి| తతః పరం స తై ర్విసృష్టః సన్ జలపథేన ఇఫిషనగరాత్ ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","తతః కైసరియామ్ ఉపస్థితః సన్ నగరం గత్వా సమాజం నమస్కృత్య తస్మాద్ ఆన్తియఖియానగరం ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","తత్ర కియత్కాలం యాపయిత్వా తస్మాత్ ప్రస్థాయ సర్వ్వేషాం శిష్యాణాం మనాంసి సుస్థిరాణి కృత్వా క్రమశో గలాతియాఫ్రుగియాదేశయో ర్భ్రమిత్వా గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","తస్మిన్నేవ సమయే సికన్దరియానగరే జాత ఆపల్లోనామా శాస్త్రవిత్ సువక్తా యిహూదీయ ఏకో జన ఇఫిషనగరమ్ ఆగతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","స శిక్షితప్రభుమార్గో మనసోద్యోగీ చ సన్ యోహనో మజ్జనమాత్రం జ్ఞాత్వా యథార్థతయా ప్రభోః కథాం కథయన్ సముపాదిశత్| ");
INSERT INTO santel_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ఏష జనో నిర్భయత్వేన భజనభవనే కథయితుమ్ ఆరబ్ధవాన్, తతః ప్రిస్కిల్లాక్కిలౌ తస్యోపదేశకథాం నిశమ్య తం స్వయోః సమీపమ్ ఆనీయ శుద్ధరూపేణేశ్వరస్య కథామ్ అబోధయతామ్| ");
INSERT INTO santel_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","పశ్చాత్ స ఆఖాయాదేశం గన్తుం మతిం కృతవాన్, తదా తత్రత్యః శిష్యగణో యథా తం గృహ్లాతి తదర్థం భ్రాతృగణేన సమాశ్వస్య పత్రే లిఖితే సతి, ఆపల్లాస్తత్రోపస్థితః సన్ అనుగ్రహేణ ప్రత్యయినాం బహూపకారాన్ అకరోత్, ");
INSERT INTO santel_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ఫలతో యీశురభిషిక్తస్త్రాతేతి శాస్త్రప్రమాణం దత్వా ప్రకాశరూపేణ ప్రతిపన్నం కృత్వా యిహూదీయాన్ నిరుత్తరాన్ కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","కరిన్థనగర ఆపల్లసః స్థితికాలే పౌల ఉత్తరప్రదేశైరాగచ్ఛన్ ఇఫిషనగరమ్ ఉపస్థితవాన్| తత్ర కతిపయశిష్యాన్ సాక్షత్ ప్రాప్య తాన్ అపృచ్ఛత్, ");
INSERT INTO santel_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","యూయం విశ్వస్య పవిత్రమాత్మానం ప్రాప్తా న వా? తతస్తే ప్రత్యవదన్ పవిత్ర ఆత్మా దీయతే ఇత్యస్మాభిః శ్రుతమపి నహి| ");
INSERT INTO santel_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","తదా సాఽవదత్ తర్హి యూయం కేన మజ్జితా అభవత? తేఽకథయన్ యోహనో మజ్జనేన| ");
INSERT INTO santel_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","తదా పౌల ఉక్తవాన్ ఇతః పరం య ఉపస్థాస్యతి తస్మిన్ అర్థత యీశుఖ్రీష్టే విశ్వసితవ్యమిత్యుక్త్వా యోహన్ మనఃపరివర్త్తనసూచకేన మజ్జనేన జలే లోకాన్ అమజ్జయత్| ");
INSERT INTO santel_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","తాదృశీం కథాం శ్రుత్వా తే ప్రభో ర్యీశుఖ్రీష్టస్య నామ్నా మజ్జితా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","తతః పౌలేన తేషాం గాత్రేషు కరేఽర్పితే తేషాముపరి పవిత్ర ఆత్మావరూఢవాన్, తస్మాత్ తే నానాదేశీయా భాషా భవిష్యత్కథాశ్చ కథితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","తే ప్రాయేణ ద్వాదశజనా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","పౌలో భజనభవనం గత్వా ప్రాయేణ మాసత్రయమ్ ఈశ్వరస్య రాజ్యస్య విచారం కృత్వా లోకాన్ ప్రవర్త్య సాహసేన కథామకథయత్| ");
INSERT INTO santel_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","కిన్తు కఠినాన్తఃకరణత్వాత్ కియన్తో జనా న విశ్వస్య సర్వ్వేషాం సమక్షమ్ ఏతత్పథస్య నిన్దాం కర్త్తుం ప్రవృత్తాః, అతః పౌలస్తేషాం సమీపాత్ ప్రస్థాయ శిష్యగణం పృథక్కృత్వా ప్రత్యహం తురాన్ననామ్నః కస్యచిత్ జనస్య పాఠశాలాయాం విచారం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ఇత్థం వత్సరద్వయం గతం తస్మాద్ ఆశియాదేశనివాసినః సర్వ్వే యిహూదీయా అన్యదేశీయలోకాశ్చ ప్రభో ర్యీశోః కథామ్ అశ్రౌషన్| ");
INSERT INTO santel_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","పౌలేన చ ఈశ్వర ఏతాదృశాన్యద్భుతాని కర్మ్మాణి కృతవాన్ ");
INSERT INTO santel_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","యత్ పరిధేయే గాత్రమార్జనవస్త్రే వా తస్య దేహాత్ పీడితలోకానామ్ సమీపమ్ ఆనీతే తే నిరామయా జాతా అపవిత్రా భూతాశ్చ తేభ్యో బహిర్గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","తదా దేశాటనకారిణః కియన్తో యిహూదీయా భూతాపసారిణో భూతగ్రస్తనోకానాం సన్నిధౌ ప్రభే ర్యీశో ర్నామ జప్త్వా వాక్యమిదమ్ అవదన్, యస్య కథాం పౌలః ప్రచారయతి తస్య యీశో ర్నామ్నా యుష్మాన్ ఆజ్ఞాపయామః| ");
INSERT INTO santel_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","స్కివనామ్నో యిహూదీయానాం ప్రధానయాజకస్య సప్తభిః పుత్తైస్తథా కృతే సతి ");
INSERT INTO santel_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","కశ్చిద్ అపవిత్రో భూతః ప్రత్యుదితవాన్, యీశుం జానామి పౌలఞ్చ పరిచినోమి కిన్తు కే యూయం? ");
INSERT INTO santel_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ఇత్యుక్త్వా సోపవిత్రభూతగ్రస్తో మనుష్యో లమ్ఫం కృత్వా తేషాముపరి పతిత్వా బలేన తాన్ జితవాన్, తస్మాత్తే నగ్నాః క్షతాఙ్గాశ్చ సన్తస్తస్మాద్ గేహాత్ పలాయన్త| ");
INSERT INTO santel_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","సా వాగ్ ఇఫిషనగరనివాసినసం సర్వ్వేషాం యిహూదీయానాం భిన్నదేశీయానాం లోకానాఞ్చ శ్రవోగోచరీభూతా; తతః సర్వ్వే భయం గతాః ప్రభో ర్యీశో ర్నామ్నో యశో ఽవర్ద్ధత| ");
INSERT INTO santel_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","యేషామనేకేషాం లోకానాం ప్రతీతిరజాయత త ఆగత్య స్వైః కృతాః క్రియాః ప్రకాశరూపేణాఙ్గీకృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","బహవో మాయాకర్మ్మకారిణః స్వస్వగ్రన్థాన్ ఆనీయ రాశీకృత్య సర్వ్వేషాం సమక్షమ్ అదాహయన్, తతో గణనాం కృత్వాబుధ్యన్త పఞ్చాయుతరూప్యముద్రామూల్యపుస్తకాని దగ్ధాని| ");
INSERT INTO santel_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ఇత్థం ప్రభోః కథా సర్వ్వదేశం వ్యాప్య ప్రబలా జాతా| ");
INSERT INTO santel_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","సర్వ్వేష్వేతేషు కర్మ్మసు సమ్పన్నేషు సత్సు పౌలో మాకిదనియాఖాయాదేశాభ్యాం యిరూశాలమం గన్తుం మతిం కృత్వా కథితవాన్ తత్స్థానం యాత్రాయాం కృతాయాం సత్యాం మయా రోమానగరం ద్రష్టవ్యం| ");
INSERT INTO santel_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","స్వానుగతలోకానాం తీమథియేరాస్తౌ ద్వౌ జనౌ మాకిదనియాదేశం ప్రతి ప్రహిత్య స్వయమ్ ఆశియాదేశే కతిపయదినాని స్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","కిన్తు తస్మిన్ సమయే మతేఽస్మిన్ కలహో జాతః| ");
INSERT INTO santel_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","తత్కారణమిదం, అర్త్తిమీదేవ్యా రూప్యమన్దిరనిర్మ్మాణేన సర్వ్వేషాం శిల్పినాం యథేష్టలాభమ్ అజనయత్ యో దీమీత్రియనామా నాడీన్ధమః ");
INSERT INTO santel_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","స తాన్ తత్కర్మ్మజీవినః సర్వ్వలోకాంశ్చ సమాహూయ భాషితవాన్ హే మహేచ్ఛా ఏతేన మన్దిరనిర్మ్మాణేనాస్మాకం జీవికా భవతి, ఏతద్ యూయం విత్థ; ");
INSERT INTO santel_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","కిన్తు హస్తనిర్మ్మితేశ్వరా ఈశ్వరా నహి పౌలనామ్నా కేనచిజ్జనేన కథామిమాం వ్యాహృత్య కేవలేఫిషనగరే నహి ప్రాయేణ సర్వ్వస్మిన్ ఆశియాదేశే ప్రవృత్తిం గ్రాహయిత్వా బహులోకానాం శేముషీ పరావర్త్తితా, ఏతద్ యుష్మాభి ర్దృశ్యతే శ్రూయతే చ| ");
INSERT INTO santel_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","తేనాస్మాకం వాణిజ్యస్య సర్వ్వథా హానేః సమ్భవనం కేవలమితి నహి, ఆశియాదేశస్థై ర్వా సర్వ్వజగత్స్థై ర్లోకైః పూజ్యా యార్తిమీ మహాదేవీ తస్యా మన్దిరస్యావజ్ఞానస్య తస్యా ఐశ్వర్య్యస్య నాశస్య చ సమ్భావనా విద్యతేे| ");
INSERT INTO santel_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ఏతాదృశీం కథాం శ్రుత్వా తే మహాక్రోధాన్వితాః సన్త ఉచ్చైఃకారం కథితవన్త ఇఫిషీయానామ్ అర్త్తిమీ దేవీ మహతీ భవతి| ");
INSERT INTO santel_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","తతః సర్వ్వనగరం కలహేన పరిపూర్ణమభవత్, తతః పరం తే మాకిదనీయగాయారిస్తార్ఖనామానౌ పౌలస్య ద్వౌ సహచరౌ ధృత్వైకచిత్తా రఙ్గభూమిం జవేన ధావితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","తతః పౌలో లోకానాం సన్నిధిం యాతుమ్ ఉద్యతవాన్ కిన్తు శిష్యగణస్తం వారితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","పౌలస్యత్మీయా ఆశియాదేశస్థాః కతిపయాః ప్రధానలోకాస్తస్య సమీపం నరమేకం ప్రేష్య త్వం రఙ్గభూమిం మాగా ఇతి న్యవేదయన్| ");
INSERT INTO santel_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","తతో నానాలోకానాం నానాకథాకథనాత్ సభా వ్యాకులా జాతా కిం కారణాద్ ఏతావతీ జనతాభవత్ ఏతద్ అధికై ర్లోకై ర్నాజ్ఞాయి| ");
INSERT INTO santel_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","తతః పరం జనతామధ్యాద్ యిహూదీయైర్బహిష్కృతః సికన్దరో హస్తేన సఙ్కేతం కృత్వా లోకేభ్య ఉత్తరం దాతుముద్యతవాన్, ");
INSERT INTO santel_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","కిన్తు స యిహూదీయలోక ఇతి నిశ్చితే సతి ఇఫిషీయానామ్ అర్త్తిమీ దేవీ మహతీతి వాక్యం ప్రాయేణ పఞ్చ దణ్డాన్ యావద్ ఏకస్వరేణ లోకనివహైః ప్రోక్తం| ");
INSERT INTO santel_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","తతో నగరాధిపతిస్తాన్ స్థిరాన్ కృత్వా కథితవాన్ హే ఇఫిషాయాః సర్వ్వే లోకా ఆకర్ణయత, అర్తిమీమహాదేవ్యా మహాదేవాత్ పతితాయాస్తత్ప్రతిమాయాశ్చ పూజనమ ఇఫిషనగరస్థాః సర్వ్వే లోకాః కుర్వ్వన్తి, ఏతత్ కే న జానన్తి? ");
INSERT INTO santel_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","తస్మాద్ ఏతత్ప్రతికూలం కేపి కథయితుం న శక్నువన్తి, ఇతి జ్ఞాత్వా యుష్మాభిః సుస్థిరత్వేన స్థాతవ్యమ్ అవివిచ్య కిమపి కర్మ్మ న కర్త్తవ్యఞ్చ| ");
INSERT INTO santel_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","యాన్ ఏతాన్ మనుష్యాన్ యూయమత్ర సమానయత తే మన్దిరద్రవ్యాపహారకా యుష్మాకం దేవ్యా నిన్దకాశ్చ న భవన్తి| ");
INSERT INTO santel_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","యది కఞ్చన ప్రతి దీమీత్రియస్య తస్య సహాయానాఞ్చ కాచిద్ ఆపత్తి ర్విద్యతే తర్హి ప్రతినిధిలోకా విచారస్థానఞ్చ సన్తి, తే తత్ స్థానం గత్వా ఉత్తరప్రత్యుత్తరే కుర్వ్వన్తు| ");
INSERT INTO santel_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","కిన్తు యుష్మాకం కాచిదపరా కథా యది తిష్ఠతి తర్హి నియమితాయాం సభాయాం తస్యా నిష్పత్తి ర్భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","కిన్త్వేతస్య విరోధస్యోత్తరం యేన దాతుం శక్నుమ్ ఏతాదృశస్య కస్యచిత్ కారణస్యాభావాద్ అద్యతనఘటనాహేతో రాజద్రోహిణామివాస్మాకమ్ అభియోగో భవిష్యతీతి శఙ్కా విద్యతే| ");
INSERT INTO santel_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ఇతి కథయిత్వా స సభాస్థలోకాన్ విసృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ఇత్థం కలహే నివృత్తే సతి పౌలః శిష్యగణమ్ ఆహూయ విసర్జనం ప్రాప్య మాకిదనియాదేశం ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","తేన స్థానేన గచ్ఛన్ తద్దేశీయాన్ శిష్యాన్ బహూపదిశ్య యూనానీయదేశమ్ ఉపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","తత్ర మాసత్రయం స్థిత్వా తస్మాత్ సురియాదేశం యాతుమ్ ఉద్యతః, కిన్తు యిహూదీయాస్తం హన్తుం గుప్తా అతిష్ఠన్ తస్మాత్ స పునరపి మాకిదనియామార్గేణ ప్రత్యాగన్తుం మతిం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","బిరయానగరీయసోపాత్రః థిషలనీకీయారిస్తార్ఖసికున్దౌ దర్బ్బోనగరీయగాయతీమథియౌ ఆశియాదేశీయతుఖికత్రఫిమౌ చ తేన సార్ద్ధం ఆశియాదేశం యావద్ గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ఏతే సర్వ్వే ఽగ్రసరాః సన్తో ఽస్మాన్ అపేక్ష్య త్రోయానగరే స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","కిణ్వశూన్యపూపోత్సవదినే చ గతే సతి వయం ఫిలిపీనగరాత్ తోయపథేన గత్వా పఞ్చభి ర్దినైస్త్రోయానగరమ్ ఉపస్థాయ తత్ర సప్తదినాన్యవాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","సప్తాహస్య ప్రథమదినే పూపాన్ భంక్తు శిష్యేషు మిలితేషు పౌలః పరదినే తస్మాత్ ప్రస్థాతుమ్ ఉద్యతః సన్ తదహ్ని ప్రాయేణ క్షపాయా యామద్వయం యావత్ శిష్యేభ్యో ధర్మ్మకథామ్ అకథయత్| ");
INSERT INTO santel_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ఉపరిస్థే యస్మిన్ ప్రకోష్ఠే సభాం కృత్వాసన్ తత్ర బహవః ప్రదీపాః ప్రాజ్వలన్| ");
INSERT INTO santel_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ఉతుఖనామా కశ్చన యువా చ వాతాయన ఉపవిశన్ ఘోరతరనిద్రాగ్రస్తో ఽభూత్ తదా పౌలేన బహుక్షణం కథాయాం ప్రచారితాయాం నిద్రామగ్నః స తస్మాద్ ఉపరిస్థతృతీయప్రకోష్ఠాద్ అపతత్, తతో లోకాస్తం మృతకల్పం ధృత్వోదతోలయన్| ");
INSERT INTO santel_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","తతః పౌలోఽవరుహ్య తస్య గాత్రే పతిత్వా తం క్రోడే నిధాయ కథితవాన్, యూయం వ్యాకులా మా భూత నాయం ప్రాణై ర్వియుక్తః| ");
INSERT INTO santel_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","పశ్చాత్ స పునశ్చోపరి గత్వా పూపాన్ భంక్త్వా ప్రభాతం యావత్ కథోపకథనే కృత్వా ప్రస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","తే చ తం జీవన్తం యువానం గృహీత్వా గత్వా పరమాప్యాయితా జాతాః| ");
INSERT INTO santel_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","అనన్తరం వయం పోతేనాగ్రసరా భూత్వాస్మనగరమ్ ఉత్తీర్య్య పౌలం గ్రహీతుం మతిమ్ అకుర్మ్మ యతః స తత్ర పద్భ్యాం వ్రజితుం మతిం కృత్వేతి నిరూపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","తస్మాత్ తత్రాస్మాభిః సార్ద్ధం తస్మిన్ మిలితే సతి వయం తం నీత్వా మితులీన్యుపద్వీపం ప్రాప్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","తస్మాత్ పోతం మోచయిత్వా పరేఽహని ఖీయోపద్వీపస్య సమ్ముఖం లబ్ధవన్తస్తస్మాద్ ఏకేనాహ్నా సామోపద్వీపం గత్వా పోతం లాగయిత్వా త్రోగుల్లియే స్థిత్వా పరస్మిన్ దివసేे మిలీతనగరమ్ ఉపాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","యతః పౌల ఆశియాదేశే కాలం యాపయితుమ్ నాభిలషన్ ఇఫిషనగరం త్యక్త్వా యాతుం మన్త్రణాం స్థిరీకృతవాన్; యస్మాద్ యది సాధ్యం భవతి తర్హి నిస్తారోత్సవస్య పఞ్చాశత్తమదినే స యిరూశాలమ్యుపస్థాతుం మతిం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","పౌలో మిలీతాద్ ఇఫిషం ప్రతి లోకం ప్రహిత్య సమాజస్య ప్రాచీనాన్ ఆహూయానీతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","తేషు తస్య సమీపమ్ ఉపస్థితేషు స తేభ్య ఇమాం కథాం కథితవాన్, అహమ్ ఆశియాదేశే ప్రథమాగమనమ్ ఆరభ్యాద్య యావద్ యుష్మాకం సన్నిధౌ స్థిత్వా సర్వ్వసమయే యథాచరితవాన్ తద్ యూయం జానీథ; ");
INSERT INTO santel_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ఫలతః సర్వ్వథా నమ్రమనాః సన్ బహుశ్రుపాతేన యిహుదీయానామ్ కుమన్త్రణాజాతనానాపరీక్షాభిః ప్రభోః సేవామకరవం| ");
INSERT INTO santel_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","కామపి హితకథాाం న గోపాయితవాన్ తాం ప్రచార్య్య సప్రకాశం గృహే గృహే సముపదిశ్యేశ్వరం ప్రతి మనః పరావర్త్తనీయం ప్రభౌ యీశుఖ్రీష్టే విశ్వసనీయం ");
INSERT INTO santel_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","యిహూదీయానామ్ అన్యదేశీయలోకానాఞ్చ సమీప ఏతాదృశం సాక్ష్యం దదామి| ");
INSERT INTO santel_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","పశ్యత సామ్ప్రతమ్ ఆత్మనాకృష్టః సన్ యిరూశాలమ్నగరే యాత్రాం కరోమి, తత్ర మామ్ప్రతి యద్యద్ ఘటిష్యతే తాన్యహం న జానామి; ");
INSERT INTO santel_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","కిన్తు మయా బన్ధనం క్లేశశ్చ భోక్తవ్య ఇతి పవిత్ర ఆత్మా నగరే నగరే ప్రమాణం దదాతి| ");
INSERT INTO santel_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","తథాపి తం క్లేశమహం తృణాయ న మన్యే; ఈశ్వరస్యానుగ్రహవిషయకస్య సుసంవాదస్య ప్రమాణం దాతుం, ప్రభో ర్యీశోః సకాశాద యస్యాః సేవాయాః భారం ప్రాప్నవం తాం సేవాం సాధయితుం సానన్దం స్వమార్గం సమాపయితుुఞ్చ నిజప్రాణానపి ప్రియాన్ న మన్యే| ");
INSERT INTO santel_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","అధునా పశ్యత యేషాం సమీపేఽహమ్ ఈశ్వరీయరాజ్యస్య సుసంవాదం ప్రచార్య్య భ్రమణం కృతవాన్ ఏతాదృశా యూయం మమ వదనం పున ర్ద్రష్టుం న ప్రాప్స్యథ ఏతదప్యహం జానామి| ");
INSERT INTO santel_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","యుష్మభ్యమ్ అహమ్ ఈశ్వరస్య సర్వ్వాన్ ఆదేశాన్ ప్రకాశయితుం న న్యవర్త్తే| ");
INSERT INTO santel_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","అహం సర్వ్వేషాం లోకానాం రక్తపాతదోషాద్ యన్నిర్దోష ఆసే తస్యాద్య యుష్మాన్ సాక్షిణః కరోమి| ");
INSERT INTO santel_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","యూయం స్వేషు తథా యస్య వ్రజస్యాధ్యక్షన్ ఆత్మా యుష్మాన్ విధాయ న్యయుఙ్క్త తత్సర్వ్వస్మిన్ సావధానా భవత, య సమాజఞ్చ ప్రభు ర్నిజరక్తమూల్యేన క్రీతవాన తమ్ అవత, ");
INSERT INTO santel_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","యతో మయా గమనే కృతఏవ దుర్జయా వృకా యుష్మాకం మధ్యం ప్రవిశ్య వ్రజం ప్రతి నిర్దయతామ్ ఆచరిష్యన్తి, ");
INSERT INTO santel_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","యుష్మాకమేవ మధ్యాదపి లోకా ఉత్థాయ శిష్యగణమ్ అపహన్తుం విపరీతమ్ ఉపదేక్ష్యన్తీత్యహం జానామి| ");
INSERT INTO santel_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ఇతి హేతో ర్యూయం సచైతన్యాః సన్తస్తిష్టత, అహఞ్చ సాశ్రుపాతః సన్ వత్సరత్రయం యావద్ దివానిశం ప్రతిజనం బోధయితుం న న్యవర్త్తే తదపి స్మరత| ");
INSERT INTO santel_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ఇదానీం హే భ్రాతరో యుష్మాకం నిష్ఠాం జనయితుం పవిత్రీకృతలోకానాం మధ్యేఽధికారఞ్చ దాతుం సమర్థో య ఈశ్వరస్తస్యానుగ్రహస్య యో వాదశ్చ తయోరుభయో ర్యుష్మాన్ సమార్పయమ్| ");
INSERT INTO santel_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","కస్యాపి స్వర్ణం రూప్యం వస్త్రం వా ప్రతి మయా లోభో న కృతః| ");
INSERT INTO santel_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","కిన్తు మమ మత్సహచరలోకానాఞ్చావశ్యకవ్యయాయ మదీయమిదం కరద్వయమ్ అశ్రామ్యద్ ఏతద్ యూయం జానీథ| ");
INSERT INTO santel_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","అనేన ప్రకారేణ గ్రహణద్ దానం భద్రమితి యద్వాక్యం ప్రభు ర్యీశుః కథితవాన్ తత్ స్మర్త్తుం దరిద్రలోకానాముపకారార్థం శ్రమం కర్త్తుఞ్చ యుష్మాకమ్ ఉచితమ్ ఏతత్సర్వ్వం యుష్మానహమ్ ఉపదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ఏతాం కథాం కథయిత్వా స జానునీ పాతయిత్వా సర్వైః సహ ప్రార్థయత| ");
INSERT INTO santel_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","తేన తే క్రన్ద్రన్తః ");
INSERT INTO santel_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","పున ర్మమ ముఖం న ద్రక్ష్యథ విశేషత ఏషా యా కథా తేనాకథి తత్కారణాత్ శోకం విలాపఞ్చ కృత్వా కణ్ఠం ధృత్వా చుమ్బితవన్తః| పశ్చాత్ తే తం పోతం నీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","తై ర్విసృష్టాః సన్తో వయం పోతం బాహయిత్వా ఋజుమార్గేణ కోషమ్ ఉపద్వీపమ్ ఆగత్య పరేఽహని రోదియోపద్వీపమ్ ఆగచ్ఛామ తతస్తస్మాత్ పాతారాయామ్ ఉపాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","తత్ర ఫైనీకియాదేశగామినమ్ పోతమేకం ప్రాప్య తమారుహ్య గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","కుప్రోపద్వీపం దృష్ట్వా తం సవ్యదిశి స్థాపయిత్వా సురియాదేశం గత్వా పోతస్థద్రవ్యాణ్యవరోహయితుం సోరనగరే లాగితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","తత్ర శిష్యగణస్య సాక్షాత్కరణాయ వయం తత్ర సప్తదినాని స్థితవన్తః పశ్చాత్తే పవిత్రేణాత్మనా పౌలం వ్యాహరన్ త్వం యిరూశాలమ్నగరం మా గమః| ");
INSERT INTO santel_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","తతస్తేషు సప్తసు దినేషు యాపితేషు సత్సు వయం తస్మాత్ స్థానాత్ నిజవర్త్మనా గతవన్తః, తస్మాత్ తే సబాలవృద్ధవనితా అస్మాభిః సహ నగరస్య పరిసరపర్య్యన్తమ్ ఆగతాః పశ్చాద్వయం జలధితటే జానుపాతం ప్రార్థయామహి| ");
INSERT INTO santel_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","తతః పరస్పరం విసృష్టాః సన్తో వయం పోతం గతాస్తే తు స్వస్వగృహం ప్రత్యాగతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","వయం సోరనగరాత్ నావా ప్రస్థాయ తలిమాయినగరమ్ ఉపాతిష్ఠామ తత్రాస్మాకం సముద్రీయమార్గస్యాన్తోఽభవత్ తత్ర భ్రాతృగణం నమస్కృత్య దినమేకం తైః సార్ద్ధమ్ ఉషతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","పరే ఽహని పౌలస్తస్య సఙ్గినో వయఞ్చ ప్రతిష్ఠమానాః కైసరియానగరమ్ ఆగత్య సుసంవాదప్రచారకానాం సప్తజనానాం ఫిలిపనామ్న ఏకస్య గృహం ప్రవిశ్యావతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","తస్య చతస్రో దుహితరోఽనూఢా భవిష్యద్వాదిన్య ఆసన్| ");
INSERT INTO santel_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","తత్రాస్మాసు బహుదినాని ప్రోషితేషు యిహూదీయదేశాద్ ఆగత్యాగాబనామా భవిష్యద్వాదీ సముపస్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","సోస్మాకం సమీపమేత్య పౌలస్య కటిబన్ధనం గృహీత్వా నిజహస్తాపాదాన్ బద్ధ్వా భాషితవాన్ యస్యేదం కటిబన్ధనం తం యిహూదీయలోకా యిరూశాలమనగర ఇత్థం బద్ధ్వా భిన్నదేశీయానాం కరేషు సమర్పయిష్యన్తీతి వాక్యం పవిత్ర ఆత్మా కథయతి| ");
INSERT INTO santel_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ఏతాదృశీం కథాం శ్రుత్వా వయం తన్నగరవాసినో భ్రాతరశ్చ యిరూశాలమం న యాతుం పౌలం వ్యనయామహి; ");
INSERT INTO santel_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","కిన్తు స ప్రత్యావాదీత్, యూయం కిం కురుథ? కిం క్రన్దనేన మమాన్తఃకరణం విదీర్ణం కరిష్యథ? ప్రభో ర్యీశో ర్నామ్నో నిమిత్తం యిరూశాలమి బద్ధో భవితుం కేవల తన్న ప్రాణాన్ దాతుమపి ససజ్జోస్మి| ");
INSERT INTO santel_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","తేనాస్మాకం కథాయామ్ అగృహీతాయామ్ ఈశ్వరస్య యథేచ్ఛా తథైవ భవత్విత్యుక్త్వా వయం నిరస్యామ| ");
INSERT INTO santel_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","పరేఽహని పాథేయద్రవ్యాణి గృహీత్వా యిరూశాలమం ప్రతి యాత్రామ్ అకుర్మ్మ| ");
INSERT INTO santel_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","తతః కైసరియానగరనివాసినః కతిపయాః శిష్యా అస్మాభిః సార్ద్ధమ్ ఇత్వా కృప్రీయేన మ్నాసన్నామ్నా యేన ప్రాచీనశిష్యేన సార్ద్ధమ్ అస్మాభి ర్వస్తవ్యం తస్య సమీపమ్ అస్మాన్ నీతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","అస్మాసు యిరూశాలమ్యుపస్థితేషు తత్రస్థభ్రాతృగణోఽస్మాన్ ఆహ్లాదేన గృహీతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","పరస్మిన్ దివసే పౌలేఽస్మాభిః సహ యాకూబో గృహం ప్రవిష్టే లోకప్రాచీనాః సర్వ్వే తత్ర పరిషది సంస్థితాః| ");
INSERT INTO santel_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","అనన్తరం స తాన్ నత్వా స్వీయప్రచారణేన భిన్నదేశీయాన్ ప్రతీశ్వరో యాని కర్మ్మాణి సాధితవాన్ తదీయాం కథామ్ అనుక్రమాత్ కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ఇతి శ్రుత్వా తే ప్రభుం ధన్యం ప్రోచ్య వాక్యమిదమ్ అభాషన్త, హే భ్రాత ర్యిహూదీయానాం మధ్యే బహుసహస్రాణి లోకా విశ్వాసిన ఆసతే కిన్తు తే సర్వ్వే వ్యవస్థామతాచారిణ ఏతత్ ప్రత్యక్షం పశ్యసి| ");
INSERT INTO santel_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","శిశూనాం త్వక్ఛేదనాద్యాచరణం ప్రతిషిధ్య త్వం భిన్నదేశనివాసినో యిహూదీయలోకాన్ మూసావాక్యమ్ అశ్రద్ధాతుమ్ ఉపదిశసీతి తైః శ్రుతమస్తి| ");
INSERT INTO santel_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","త్వమత్రాగతోసీతి వార్త్తాం సమాకర్ణ్య జననివహో మిలిత్వావశ్యమేవాగమిష్యతి; అతఏవ కిం కరణీయమ్? అత్ర వయం మన్త్రయిత్వా సముపాయం త్వాం వదామస్తం త్వమాచర| ");
INSERT INTO santel_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","వ్రతం కర్త్తుం కృతసఙ్కల్పా యేఽస్మాంక చత్వారో మానవాః సన్తి ");
INSERT INTO santel_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","తాన్ గృహీత్వా తైః సహితః స్వం శుచిం కురు తథా తేషాం శిరోముణ్డనే యో వ్యయో భవతి తం త్వం దేహి| తథా కృతే త్వదీయాచారే యా జనశ్రుతి ర్జాయతే సాలీకా కిన్తు త్వం విధిం పాలయన్ వ్యవస్థానుసారేణేవాచరసీతి తే భోత్సన్తే| ");
INSERT INTO santel_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","భిన్నదేశీయానాం విశ్వాసిలోకానాం నికటే వయం పత్రం లిఖిత్వేత్థం స్థిరీకృతవన్తః, దేవప్రసాదభోజనం రక్తం గలపీడనమారితప్రాణిభోజనం వ్యభిచారశ్చైతేభ్యః స్వరక్షణవ్యతిరేకేణ తేషామన్యవిధిపాలనం కరణీయం న| ");
INSERT INTO santel_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","తతః పౌలస్తాన్ మానుషానాదాయ పరస్మిన్ దివసే తైః సహ శుచి ర్భూత్వా మన్దిరం గత్వా శౌచకర్మ్మణో దినేషు సమ్పూర్ణేషు తేషామ్ ఏకైకార్థం నైవేద్యాద్యుత్సర్గో భవిష్యతీతి జ్ఞాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","తేషు సప్తసు దినేషు సమాప్తకల్పేషు ఆశియాదేశనివాసినో యిహూదీయాస్తం మధ్యేమన్దిరం విలోక్య జననివహస్య మనఃసు కుప్రవృత్తిం జనయిత్వా తం ధృత్వా ");
INSERT INTO santel_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ప్రోచ్చైః ప్రావోచన్, హే ఇస్రాయేల్లోకాః సర్వ్వే సాహాయ్యం కురుత| యో మనుజ ఏతేషాం లోకానాం మూసావ్యవస్థాయా ఏతస్య స్థానస్యాపి విపరీతం సర్వ్వత్ర సర్వ్వాన్ శిక్షయతి స ఏషః; విశేషతః స భిన్నదేశీయలోకాన్ మన్దిరమ్ ఆనీయ పవిత్రస్థానమేతద్ అపవిత్రమకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","పూర్వ్వం తే మధ్యేనగరమ్ ఇఫిషనగరీయం త్రఫిమం పౌలేన సహితం దృష్టవన్త ఏతస్మాత్ పౌలస్తం మన్దిరమధ్యమ్ ఆనయద్ ఇత్యన్వమిమత| ");
INSERT INTO santel_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","అతఏవ సర్వ్వస్మిన్ నగరే కలహోత్పన్నత్వాత్ ధావన్తో లోకా ఆగత్య పౌలం ధృత్వా మన్దిరస్య బహిరాకృష్యానయన్ తత్క్షణాద్ ద్వారాణి సర్వ్వాణి చ రుద్ధాని| ");
INSERT INTO santel_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","తేషు తం హన్తుముద్యతేेషు యిరూశాలమ్నగరే మహానుపద్రవో జాత ఇతి వార్త్తాయాం సహస్రసేనాపతేః కర్ణగోచరీభూతాయాం సత్యాం స తత్క్షణాత్ సైన్యాని సేనాపతిగణఞ్చ గృహీత్వా జవేనాగతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","తతో లోకాః సేనాగణేన సహ సహస్రసేనాపతిమ్ ఆగచ్ఛన్తం దృష్ట్వా పౌలతాడనాతో న్యవర్త్తన్త| ");
INSERT INTO santel_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","స సహస్రసేనాపతిః సన్నిధావాగమ్య పౌలం ధృత్వా శృఙ్ఖలద్వయేన బద్ధమ్ ఆదిశ్య తాన్ పృష్టవాన్ ఏష కః? కిం కర్మ్మ చాయం కృతవాన్? ");
INSERT INTO santel_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","తతో జనసమూహస్య కశ్చిద్ ఏకప్రకారం కశ్చిద్ అన్యప్రకారం వాక్యమ్ అరౌత్ స తత్ర సత్యం జ్ఞాతుమ్ కలహకారణాద్ అశక్తః సన్ తం దుర్గం నేతుమ్ ఆజ్ఞాపయత్| ");
INSERT INTO santel_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","తేషు సోపానస్యోపరి ప్రాప్తేషు లోకానాం సాహసకారణాత్ సేనాగణః పౌలముత్తోల్య నీతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","తతః సర్వ్వే లోకాః పశ్చాద్గామినః సన్త ఏనం దురీకురుతేతి వాక్యమ్ ఉచ్చైరవదన్| ");
INSERT INTO santel_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","పౌలస్య దుర్గానయనసమయే స తస్మై సహస్రసేనాపతయే కథితవాన్, భవతః పురస్తాత్ కథాం కథయితుం కిమ్ అనుమన్యతే? స తమపృచ్ఛత్ త్వం కిం యూనానీయాం భాషాం జానాసి? ");
INSERT INTO santel_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","యో మిసరీయో జనః పూర్వ్వం విరోధం కృత్వా చత్వారి సహస్రాణి ఘాతకాన్ సఙ్గినః కృత్వా విపినం గతవాన్ త్వం కిం సఏవ న భవసి? ");
INSERT INTO santel_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","తదా పౌలోఽకథయత్ అహం కిలికియాదేశస్య తార్షనగరీయో యిహూదీయో, నాహం సామాన్యనగరీయో మానవః; అతఏవ వినయేఽహం లాకానాం సమక్షం కథాం కథయితుం మామనుజానీష్వ| ");
INSERT INTO santel_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","తేనానుజ్ఞాతః పౌలః సోపానోపరి తిష్ఠన్ హస్తేనేఙ్గితం కృతవాన్, తస్మాత్ సర్వ్వే సుస్థిరా అభవన్| తదా పౌల ఇబ్రీయభాషయా కథయితుమ్ ఆరభత, ");
INSERT INTO santel_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","హే పితృగణా హే భ్రాతృగణాః, ఇదానీం మమ నివేదనే సమవధత్త| ");
INSERT INTO santel_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","తదా స ఇబ్రీయభాషయా కథాం కథయతీతి శ్రుత్వా సర్వ్వే లోకా అతీవ నిఃశబ్దా సన్తోఽతిష్ఠన్| ");
INSERT INTO santel_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","పశ్చాత్ సోఽకథయద్ అహం యిహూదీయ ఇతి నిశ్చయః కిలికియాదేశస్య తార్షనగరం మమ జన్మభూమిః,ఏతన్నగరీయస్య గమిలీయేలనామ్నోఽధ్యాపకస్య శిష్యో భూత్వా పూర్వ్వపురుషాణాం విధివ్యవస్థానుసారేణ సమ్పూర్ణరూపేణ శిక్షితోఽభవమ్ ఇదానీన్తనా యూయం యాదృశా భవథ తాదృశోఽహమపీశ్వరసేవాయామ్ ఉద్యోగీ జాతః| ");
INSERT INTO santel_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","మతమేతద్ ద్విష్ట్వా తద్గ్రాహినారీపురుషాన్ కారాయాం బద్ధ్వా తేషాం ప్రాణనాశపర్య్యన్తాం విపక్షతామ్ అకరవమ్| ");
INSERT INTO santel_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","మహాయాజకః సభాసదః ప్రాచీనలోకాశ్చ మమైతస్యాః కథాయాః ప్రమాణం దాతుం శక్నువన్తి, యస్మాత్ తేషాం సమీపాద్ దమ్మేషకనగరనివాసిభ్రాతృగణార్థమ్ ఆజ్ఞాపత్రాణి గృహీత్వా యే తత్ర స్థితాస్తాన్ దణ్డయితుం యిరూశాలమమ్ ఆనయనార్థం దమ్మేషకనగరం గతోస్మి| ");
INSERT INTO santel_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","కిన్తు గచ్ఛన్ తన్నగరస్య సమీపం ప్రాప్తవాన్ తదా ద్వితీయప్రహరవేలాయాం సత్యామ్ అకస్మాద్ గగణాన్నిర్గత్య మహతీ దీప్తి ర్మమ చతుర్దిశి ప్రకాశితవతీ| ");
INSERT INTO santel_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","తతో మయి భూమౌै పతితే సతి, హే శౌల హే శౌల కుతో మాం తాడయసి? మామ్ప్రతి భాషిత ఏతాదృశ ఏకో రవోపి మయా శ్రుతః| ");
INSERT INTO santel_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","తదాహం ప్రత్యవదం, హే ప్రభే కో భవాన్? తతః సోఽవాదీత్ యం త్వం తాడయసి స నాసరతీయో యీశురహం| ");
INSERT INTO santel_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","మమ సఙ్గినో లోకాస్తాం దీప్తిం దృష్ట్వా భియం ప్రాప్తాః, కిన్తు మామ్ప్రత్యుదితం తద్వాక్యం తేे నాబుధ్యన్త| ");
INSERT INTO santel_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","తతః పరం పృష్టవానహం, హే ప్రభో మయా కిం కర్త్తవ్యం? తతః ప్రభురకథయత్, ఉత్థాయ దమ్మేషకనగరం యాహి త్వయా యద్యత్ కర్త్తవ్యం నిరూపితమాస్తే తత్ తత్ర త్వం జ్ఞాపయిష్యసే| ");
INSERT INTO santel_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","అనన్తరం తస్యాః ఖరతరదీప్తేః కారణాత్ కిమపి న దృష్ట్వా సఙ్గిగణేన ధృతహస్తః సన్ దమ్మేషకనగరం వ్రజితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","తన్నగరనివాసినాం సర్వ్వేషాం యిహూదీయానాం మాన్యో వ్యవస్థానుసారేణ భక్తశ్చ హనానీయనామా మానవ ఏకో ");
INSERT INTO santel_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","మమ సన్నిధిమ్ ఏత్య తిష్ఠన్ అకథయత్, హే భ్రాతః శౌల సుదృష్టి ర్భవ తస్మిన్ దణ్డేఽహం సమ్యక్ తం దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","తతః స మహ్యం కథితవాన్ యథా త్వమ్ ఈశ్వరస్యాభిప్రాయం వేత్సి తస్య శుద్ధసత్త్వజనస్య దర్శనం ప్రాప్య తస్య శ్రీముఖస్య వాక్యం శృణోషి తన్నిమిత్తమ్ అస్మాకం పూర్వ్వపురుషాణామ్ ఈశ్వరస్త్వాం మనోనీతం కృతవానం| ");
INSERT INTO santel_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","యతో యద్యద్ అద్రాక్షీరశ్రౌషీశ్చ సర్వ్వేషాం మానవానాం సమీపే త్వం తేషాం సాక్షీ భవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","అతఏవ కుతో విలమ్బసే? ప్రభో ర్నామ్నా ప్రార్థ్య నిజపాపప్రక్షాలనార్థం మజ్జనాయ సముత్తిష్ఠ| ");
INSERT INTO santel_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","తతః పరం యిరూశాలమ్నగరం ప్రత్యాగత్య మన్దిరేఽహమ్ ఏకదా ప్రార్థయే, తస్మిన్ సమయేఽహమ్ అభిభూతః సన్ ప్రభూం సాక్షాత్ పశ్యన్, ");
INSERT INTO santel_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","త్వం త్వరయా యిరూశాలమః ప్రతిష్ఠస్వ యతో లోకామయి తవ సాక్ష్యం న గ్రహీష్యన్తి, మామ్ప్రత్యుదితం తస్యేదం వాక్యమ్ అశ్రౌషమ్| ");
INSERT INTO santel_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","తతోహం ప్రత్యవాదిషమ్ హే ప్రభో ప్రతిభజనభవనం త్వయి విశ్వాసినో లోకాన్ బద్ధ్వా ప్రహృతవాన్, ");
INSERT INTO santel_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","తథా తవ సాక్షిణః స్తిఫానస్య రక్తపాతనసమయే తస్య వినాశం సమ్మన్య సన్నిధౌ తిష్ఠన్ హన్తృలోకానాం వాసాంసి రక్షితవాన్, ఏతత్ తే విదుః| ");
INSERT INTO santel_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","తతః సోఽకథయత్ ప్రతిష్ఠస్వ త్వాం దూరస్థభిన్నదేశీయానాం సమీపం ప్రేషయిష్యే| ");
INSERT INTO santel_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","తదా లోకా ఏతావత్పర్య్యన్తాం తదీయాం కథాం శ్రుత్వా ప్రోచ్చైరకథయన్, ఏనం భూమణ్డలాద్ దూరీకురుత, ఏతాదృశజనస్య జీవనం నోచితమ్| ");
INSERT INTO santel_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ఇత్యుచ్చైః కథయిత్వా వసనాని పరిత్యజ్య గగణం ప్రతి ధూలీరక్షిపన్ ");
INSERT INTO santel_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","తతః సహస్రసేనాపతిః పౌలం దుర్గాభ్యన్తర నేతుం సమాదిశత్| ఏతస్య ప్రతికూలాః సన్తో లోకాః కిన్నిమిత్తమ్ ఏతావదుచ్చైఃస్వరమ్ అకుర్వ్వన్, ఏతద్ వేత్తుం తం కశయా ప్రహృత్య తస్య పరీక్షాం కర్త్తుమాదిశత్| ");
INSERT INTO santel_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","పదాతయశ్చర్మ్మనిర్మ్మితరజ్జుభిస్తస్య బన్ధనం కర్త్తుముద్యతాస్తాస్తదానీం పౌలః సమ్ముఖస్థితం శతసేనాపతిమ్ ఉక్తవాన్ దణ్డాజ్ఞాయామ్ అప్రాప్తాయాం కిం రోమిలోకం ప్రహర్త్తుం యుష్మాకమ్ అధికారోస్తి? ");
INSERT INTO santel_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ఏనాం కథాం శ్రుత్వా స సహస్రసేనాపతేః సన్నిధిం గత్వా తాం వార్త్తామవదత్ స రోమిలోక ఏతస్మాత్ సావధానః సన్ కర్మ్మ కురు| ");
INSERT INTO santel_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","తస్మాత్ సహస్రసేనాపతి ర్గత్వా తమప్రాక్షీత్ త్వం కిం రోమిలోకః? ఇతి మాం బ్రూహి| సోఽకథయత్ సత్యమ్| ");
INSERT INTO santel_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","తతః సహస్రసేనాపతిః కథితవాన్ బహుద్రవిణం దత్త్వాహం తత్ పౌరసఖ్యం ప్రాప్తవాన్; కిన్తు పౌలః కథితవాన్ అహం జనునా తత్ ప్రాప్తోఽస్మి| ");
INSERT INTO santel_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ఇత్థం సతి యే ప్రహారేణ తం పరీక్షితుం సముద్యతా ఆసన్ తే తస్య సమీపాత్ ప్రాతిష్ఠన్త; సహస్రసేనాపతిస్తం రోమిలోకం విజ్ఞాయ స్వయం యత్ తస్య బన్ధనమ్ అకార్షీత్ తత్కారణాద్ అబిభేత్| ");
INSERT INTO santel_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","యిహూదీయలోకాః పౌలం కుతోఽపవదన్తే తస్య వృత్తాన్తం జ్ఞాతుం వాఞ్ఛన్ సహస్రసేనాపతిః పరేఽహని పౌలం బన్ధనాత్ మోచయిత్వా ప్రధానయాజకాన్ మహాసభాయాః సర్వ్వలోకాశ్చ సముపస్థాతుమ్ ఆదిశ్య తేషాం సన్నిధౌ పౌలమ్ అవరోహ్య స్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","సభాసద్లోకాన్ ప్రతి పౌలోఽనన్యదృష్ట్యా పశ్యన్ అకథయత్, హే భ్రాతృగణా అద్య యావత్ సరలేన సర్వ్వాన్తఃకరణేనేశ్వరస్య సాక్షాద్ ఆచరామి| ");
INSERT INTO santel_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","అనేన హనానీయనామా మహాయాజకస్తం కపోలే చపేటేనాహన్తుం సమీపస్థలోకాన్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","తదా పౌలస్తమవదత్, హే బహిష్పరిష్కృత, ఈశ్వరస్త్వాం ప్రహర్త్తుమ్ ఉద్యతోస్తి, యతో వ్యవస్థానుసారేణ విచారయితుమ్ ఉపవిశ్య వ్యవస్థాం లఙ్ఘిత్వా మాం ప్రహర్త్తుమ్ ఆజ్ఞాపయసి| ");
INSERT INTO santel_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","తతో నికటస్థా లోకా అకథయన్, త్వం కిమ్ ఈశ్వరస్య మహాయాజకం నిన్దసి? ");
INSERT INTO santel_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","తతః పౌలః ప్రతిభాషితవాన్ హే భ్రాతృగణ మహాయాజక ఏష ఇతి న బుద్ధం మయా తదన్యచ్చ స్వలోకానామ్ అధిపతిం ప్రతి దుర్వ్వాక్యం మా కథయ, ఏతాదృశీ లిపిరస్తి| ");
INSERT INTO santel_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","అనన్తరం పౌలస్తేషామ్ అర్ద్ధం సిదూకిలోకా అర్ద్ధం ఫిరూశిలోకా ఇతి దృష్ట్వా ప్రోచ్చైః సభాస్థలోకాన్ అవదత్ హే భ్రాతృగణ అహం ఫిరూశిమతావలమ్బీ ఫిరూశినః సత్నానశ్చ, మృతలోకానామ్ ఉత్థానే ప్రత్యాశాకరణాద్ అహమపవాదితోస్మి| ");
INSERT INTO santel_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ఇతి కథాయాం కథితాయాం ఫిరూశిసిదూకినోః పరస్పరం భిన్నవాక్యత్వాత్ సభాయా మధ్యే ద్వౌ సంఘౌ జాతౌ| ");
INSERT INTO santel_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","యతః సిదూకిలోకా ఉత్థానం స్వర్గీయదూతా ఆత్మానశ్చ సర్వ్వేషామ్ ఏతేషాం కమపి న మన్యన్తే, కిన్తు ఫిరూశినః సర్వ్వమ్ అఙ్గీకుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","తతః పరస్పరమ్ అతిశయకోలాహలే సముపస్థితే ఫిరూశినాం పక్షీయాః సభాస్థా అధ్యాపకాః ప్రతిపక్షా ఉత్తిష్ఠన్తో ఽకథయన్, ఏతస్య మానవస్య కమపి దోషం న పశ్యామః; యది కశ్చిద్ ఆత్మా వా కశ్చిద్ దూత ఏనం ప్రత్యాదిశత్ తర్హి వయమ్ ఈశ్వరస్య ప్రాతికూల్యేన న యోత్స్యామః| ");
INSERT INTO santel_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","తస్మాద్ అతీవ భిన్నవాక్యత్వే సతి తే పౌలం ఖణ్డం ఖణ్డం కరిష్యన్తీత్యాశఙ్కయా సహస్రసేనాపతిః సేనాగణం తత్స్థానం యాతుం సభాతో బలాత్ పౌలం ధృత్వా దుర్గం నేతఞ్చాజ్ఞాపయత్| ");
INSERT INTO santel_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","రాత్రో ప్రభుస్తస్య సమీపే తిష్ఠన్ కథితవాన్ హే పౌల నిర్భయో భవ యథా యిరూశాలమ్నగరే మయి సాక్ష్యం దత్తవాన్ తథా రోమానగరేపి త్వయా దాతవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","దినే సముపస్థితే సతి కియన్తో యిహూదీయలోకా ఏకమన్త్రణాః సన్తః పౌలం న హత్వా భోజనపానే కరిష్యామ ఇతి శపథేన స్వాన్ అబధ్నన్| ");
INSERT INTO santel_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","చత్వారింశజ్జనేభ్యోఽధికా లోకా ఇతి పణమ్ అకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","తే మహాయాజకానాం ప్రాచీనలోకానాఞ్చ సమీపం గత్వా కథయన్, వయం పౌలం న హత్వా కిమపి న భోక్ష్యామహే దృఢేనానేన శపథేన బద్ధ్వా అభవామ| ");
INSERT INTO santel_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","అతఏవ సామ్ప్రతం సభాసద్లోకైః సహ వయం తస్మిన్ కఞ్చిద్ విశేషవిచారం కరిష్యామస్తదర్థం భవాన్ శ్వో ఽస్మాకం సమీపం తమ్ ఆనయత్వితి సహస్రసేనాపతయే నివేదనం కురుత తేన యుష్మాకం సమీపం ఉపస్థితేః పూర్వ్వం వయం తం హన్తు సజ్జిష్యామ| ");
INSERT INTO santel_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","తదా పౌలస్య భాగినేయస్తేషామితి మన్త్రణాం విజ్ఞాయ దుర్గం గత్వా తాం వార్త్తాం పౌలమ్ ఉక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","తస్మాత్ పౌల ఏకం శతసేనాపతిమ్ ఆహూయ వాక్యమిదమ్ భాషితవాన్ సహస్రసేనాపతేః సమీపేఽస్య యువమనుష్యస్య కిఞ్చిన్నివేదనమ్ ఆస్తే, తస్మాత్ తత్సవిధమ్ ఏనం నయ| ");
INSERT INTO santel_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","తతః స తమాదాయ సహస్రసేనాపతేః సమీపమ్ ఉపస్థాయ కథితవాన్, భవతః సమీపేఽస్య కిమపి నివేదనమాస్తే తస్మాత్ బన్దిః పౌలో మామాహూయ భవతః సమీపమ్ ఏనమ్ ఆనేతుం ప్రార్థితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","తదా సహస్రసేనాపతిస్తస్య హస్తం ధృత్వా నిర్జనస్థానం నీత్వా పృష్ఠవాన్ తవ కిం నివేదనం? తత్ కథయ| ");
INSERT INTO santel_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","తతః సోకథయత్, యిహూదీయలాకాః పౌలే కమపి విశేషవిచారం ఛలం కృత్వా తం సభాం నేతుం భవతః సమీపే నివేదయితుం అమన్త్రయన్| ");
INSERT INTO santel_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","కిన్తు మవతా తన్న స్వీకర్త్తవ్యం యతస్తేషాం మధ్యేవర్త్తినశ్చత్వారింశజ్జనేభ్యో ఽధికలోకా ఏకమన్త్రణా భూత్వా పౌలం న హత్వా భోజనం పానఞ్చ న కరిష్యామ ఇతి శపథేన బద్ధాః సన్తో ఘాతకా ఇవ సజ్జితా ఇదానీం కేవలం భవతో ఽనుమతిమ్ అపేక్షన్తే| ");
INSERT INTO santel_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","యామిమాం కథాం త్వం నివేదితవాన్ తాం కస్మైచిదపి మా కథయేత్యుక్త్వా సహస్రసేనాపతిస్తం యువానం విసృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","అనన్తరం సహస్రసేనాపతి ర్ద్వౌ శతసేనాపతీ ఆహూయేదమ్ ఆదిశత్, యువాం రాత్రౌ ప్రహరైకావశిష్టాయాం సత్యాం కైసరియానగరం యాతుం పదాతిసైన్యానాం ద్వే శతే ఘోటకారోహిసైన్యానాం సప్తతిం శక్తిధారిసైన్యానాం ద్వే శతే చ జనాన్ సజ్జితాన్ కురుతం| ");
INSERT INTO santel_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","పౌలమ్ ఆరోహయితుం ఫీలిక్షాధిపతేః సమీపం నిర్వ్విఘ్నం నేతుఞ్చ వాహనాని సముపస్థాపయతం| ");
INSERT INTO santel_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","అపరం స పత్రం లిఖిత్వా దత్తవాన్ తల్లిఖితమేతత్, ");
INSERT INTO santel_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","మహామహిమశ్రీయుక్తఫీలిక్షాధిపతయే క్లౌదియలుషియస్య నమస్కారః| ");
INSERT INTO santel_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","యిహూదీయలోకాః పూర్వ్వమ్ ఏనం మానవం ధృత్వా స్వహస్తై ర్హన్తుమ్ ఉద్యతా ఏతస్మిన్నన్తరే ససైన్యోహం తత్రోపస్థాయ ఏష జనో రోమీయ ఇతి విజ్ఞాయ తం రక్షితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","కిన్నిమిత్తం తే తమపవదన్తే తజ్జ్ఞాతుం తేషా సభాం తమానాయితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","తతస్తేషాం వ్యవస్థాయా విరుద్ధయా కయాచన కథయా సోఽపవాదితోఽభవత్, కిన్తు స శృఙ్ఖలబన్ధనార్హో వా ప్రాణనాశార్హో భవతీదృశః కోప్యపరాధో మయాస్య న దృష్టః| ");
INSERT INTO santel_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","తథాపి మనుష్యస్యాస్య వధార్థం యిహూదీయా ఘాతకాఇవ సజ్జితా ఏతాం వార్త్తాం శ్రుత్వా తత్క్షణాత్ తవ సమీపమేనం ప్రేషితవాన్ అస్యాపవాదకాంశ్చ తవ సమీపం గత్వాపవదితుమ్ ఆజ్ఞాపయమ్| భవతః కుశలం భూయాత్| ");
INSERT INTO santel_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","సైన్యగణ ఆజ్ఞానుసారేణ పౌలం గృహీత్వా తస్యాం రజన్యామ్ ఆన్తిపాత్రినగరమ్ ఆనయత్| ");
INSERT INTO santel_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","పరేఽహని తేన సహ యాతుం ఘోటకారూఢసైన్యగణం స్థాపయిత్వా పరావృత్య దుర్గం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","తతః పరే ఘోటకారోహిసైన్యగణః కైసరియానగరమ్ ఉపస్థాయ తత్పత్రమ్ అధిపతేః కరే సమర్ప్య తస్య సమీపే పౌలమ్ ఉపస్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","తదాధిపతిస్తత్పత్రం పఠిత్వా పృష్ఠవాన్ ఏష కిమ్ప్రదేశీయో జనః? స కిలికియాప్రదేశీయ ఏకో జన ఇతి జ్ఞాత్వా కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","తవాపవాదకగణ ఆగతే తవ కథాం శ్రోష్యామి| హేరోద్రాజగృహే తం స్థాపయితుమ్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","పఞ్చభ్యో దినేభ్యః పరం హనానీయనామా మహాయాజకోఽధిపతేః సమక్షం పౌలస్య ప్రాతికూల్యేన నివేదయితుం తర్తుల్లనామానం కఞ్చన వక్తారం ప్రాచీనజనాంశ్చ సఙ్గినః కృత్వా కైసరియానగరమ్ ఆగచ్ఛత్| ");
INSERT INTO santel_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","తతః పౌలే సమానీతే సతి తర్తుల్లస్తస్యాపవాదకథాం కథయితుమ్ ఆరభత హే మహామహిమఫీలిక్ష భవతో వయమ్ అతినిర్వ్విఘ్నం కాలం యాపయామో భవతః పరిణామదర్శితయా ఏతద్దేశీయానాం బహూని మఙ్గలాని ఘటితాని, ");
INSERT INTO santel_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ఇతి హేతో ర్వయమతికృతజ్ఞాః సన్తః సర్వ్వత్ర సర్వ్వదా భవతో గుణాన్ గాయమః| ");
INSERT INTO santel_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","కిన్తు బహుభిః కథాభి ర్భవన్తం యేన న విరఞ్జయామి తస్మాద్ వినయే భవాన్ బనుకమ్ప్య మదల్పకథాం శృణోతు| ");
INSERT INTO santel_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ఏష మహామారీస్వరూపో నాసరతీయమతగ్రాహిసంఘాతస్య ముఖ్యో భూత్వా సర్వ్వదేశేషు సర్వ్వేషాం యిహూదీయానాం రాజద్రోహాచరణప్రవృత్తిం జనయతీత్యస్మాభి ర్నిశ్చితం| ");
INSERT INTO santel_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","స మన్దిరమపి అశుచి కర్త్తుం చేష్టితవాన్; ఇతి కారణాద్ వయమ్ ఏనం ధృత్వా స్వవ్యవస్థానుసారేణ విచారయితుం ప్రావర్త్తామహి; ");
INSERT INTO santel_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","కిన్తు లుషియః సహస్రసేనాపతిరాగత్య బలాద్ అస్మాకం కరేభ్య ఏనం గృహీత్వా ");
INSERT INTO santel_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ఏతస్యాపవాదకాన్ భవతః సమీపమ్ ఆగన్తుమ్ ఆజ్ఞాపయత్| వయం యస్మిన్ తమపవాదామో భవతా పదపవాదకథాయాం విచారితాయాం సత్యాం సర్వ్వం వృత్తాన్తం వేదితుం శక్ష్యతే| ");
INSERT INTO santel_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","తతో యిహూదీయా అపి స్వీకృత్య కథితవన్త ఏషా కథా ప్రమాణమ్| ");
INSERT INTO santel_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","అధిపతౌ కథాం కథయితుం పౌలం ప్రతీఙ్గితం కృతవతి స కథితవాన్ భవాన్ బహూన్ వత్సరాన్ యావద్ ఏతద్దేశస్య శాసనం కరోతీతి విజ్ఞాయ ప్రత్యుత్తరం దాతుమ్ అక్షోభోఽభవమ్| ");
INSERT INTO santel_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","అద్య కేవలం ద్వాదశ దినాని యాతాని, అహమ్ ఆరాధనాం కర్త్తుం యిరూశాలమనగరం గతవాన్ ఏషా కథా భవతా జ్ఞాతుం శక్యతే; ");
INSERT INTO santel_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","కిన్త్విభే మాం మధ్యేమన్దిరం కేనాపి సహ వితణ్డాం కుర్వ్వన్తం కుత్రాపి భజనభవనే నగరే వా లోకాన్ కుప్రవృత్తిం జనయన్తుం న దృష్టవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ఇదానీం యస్మిన్ యస్మిన్ మామ్ అపవదన్తే తస్య కిమపి ప్రమాణం దాతుం న శక్నువన్తి| ");
INSERT INTO santel_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","కిన్తు భవిష్యద్వాక్యగ్రన్థే వ్యవస్థాగ్రన్థే చ యా యా కథా లిఖితాస్తే తాసు సర్వ్వాసు విశ్వస్య యన్మతమ్ ఇమే విధర్మ్మం జానన్తి తన్మతానుసారేణాహం నిజపితృపురుషాణామ్ ఈశ్వరమ్ ఆరాధయామీత్యహం భవతః సమక్షమ్ అఙ్గీకరోమి| ");
INSERT INTO santel_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ధార్మ్మికాణామ్ అధార్మ్మికాణాఞ్చ ప్రమీతలోకానామేవోత్థానం భవిష్యతీతి కథామిమే స్వీకుర్వ్వన్తి తథాహమపి తస్మిన్ ఈశ్వరే ప్రత్యాశాం కరోమి; ");
INSERT INTO santel_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ఈశ్వరస్య మానవానాఞ్చ సమీపే యథా నిర్దోషో భవామి తదర్థం సతతం యత్నవాన్ అస్మి| ");
INSERT INTO santel_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","బహుషు వత్సరేషు గతేషు స్వదేశీయలోకానాం నిమిత్తం దానీయద్రవ్యాణి నైవేద్యాని చ సమాదాయ పునరాగమనం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","తతోహం శుచి ర్భూత్వా లోకానాం సమాగమం కలహం వా న కారితవాన్ తథాప్యాశియాదేశీయాః కియన్తో యిహుదీయలోకా మధ్యేమన్దిరం మాం ధృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","మమోపరి యది కాచిదపవాదకథాస్తి తర్హి భవతః సమీపమ్ ఉపస్థాయ తేషామేవ సాక్ష్యదానమ్ ఉచితమ్| ");
INSERT INTO santel_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","నోచేత్ పూర్వ్వే మహాసభాస్థానాం లోకానాం సన్నిధౌ మమ దణ్డాయమానత్వసమయే, అహమద్య మృతానాముత్థానే యుష్మాభి ర్విచారితోస్మి, ");
INSERT INTO santel_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","తేషాం మధ్యే తిష్ఠన్నహం యామిమాం కథాముచ్చైః స్వరేణ కథితవాన్ తదన్యో మమ కోపి దోషోఽలభ్యత న వేతి వరమ్ ఏతే సముపస్థితలోకా వదన్తు| ");
INSERT INTO santel_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","తదా ఫీలిక్ష ఏతాం కథాం శ్రుత్వా తన్మతస్య విశేషవృత్తాన్తం విజ్ఞాతుం విచారం స్థగితం కృత్వా కథితవాన్ లుషియే సహస్రసేనాపతౌ సమాయాతే సతి యుష్మాకం విచారమ్ అహం నిష్పాదయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","అనన్తరం బన్ధనం వినా పౌలం రక్షితుం తస్య సేవనాయ సాక్షాత్కరణాయ వా తదీయాత్మీయబన్ధుజనాన్ న వారయితుఞ్చ శమసేనాపతిమ్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","అల్పదినాత్ పరం ఫీలిక్షోఽధిపతి ర్ద్రుషిల్లానామ్నా యిహూదీయయా స్వభార్య్యయా సహాగత్య పౌలమాహూయ తస్య ముఖాత్ ఖ్రీష్టధర్మ్మస్య వృత్తాన్తమ్ అశ్రౌషీత్| ");
INSERT INTO santel_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","పౌలేన న్యాయస్య పరిమితభోగస్య చరమవిచారస్య చ కథాయాం కథితాయాం సత్యాం ఫీలిక్షః కమ్పమానః సన్ వ్యాహరద్ ఇదానీం యాహి, అహమ్ అవకాశం ప్రాప్య త్వామ్ ఆహూస్యామి| ");
INSERT INTO santel_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ముక్తిప్రప్త్యర్థం పౌలేన మహ్యం ముద్రాదాస్యన్తే ఇతి పత్యాశాం కృత్వా స పునః పునస్తమాహూయ తేన సాకం కథోపకథనం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","కిన్తు వత్సరద్వయాత్ పరం పర్కియఫీష్ట ఫాలిక్షస్య పదం ప్రాప్తే సతి ఫీలిక్షో యిహూదీయాన్ సన్తుష్టాన్ చికీర్షన్ పౌలం బద్ధం సంస్థాప్య గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","అనన్తరం ఫీష్టో నిజరాజ్యమ్ ఆగత్య దినత్రయాత్ పరం కైసరియాతో యిరూశాలమ్నగరమ్ ఆగమత్| ");
INSERT INTO santel_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","తదా మహాయాజకో యిహూదీయానాం ప్రధానలోకాశ్చ తస్య సమక్షం పౌలమ్ అపావదన్త| ");
INSERT INTO santel_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","భవాన్ తం యిరూశాలమమ్ ఆనేతుమ్ ఆజ్ఞాపయత్వితి వినీయ తే తస్మాద్ అనుగ్రహం వాఞ్ఛితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","యతః పథిమధ్యే గోపనేన పౌలం హన్తుం తై ర్ఘాతకా నియుక్తాః| ఫీష్ట ఉత్తరం దత్తవాన్ పౌలః కైసరియాయాం స్థాస్యతి పునరల్పదినాత్ పరమ్ అహం తత్ర యాస్యామి| ");
INSERT INTO santel_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","తతస్తస్య మానుషస్య యది కశ్చిద్ అపరాధస్తిష్ఠతి తర్హి యుష్మాకం యే శక్నువన్తి తే మయా సహ తత్ర గత్వా తమపవదన్తు స ఏతాం కథాం కథితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","దశదివసేభ్యోఽధికం విలమ్బ్య ఫీష్టస్తస్మాత్ కైసరియానగరం గత్వా పరస్మిన్ దివసే విచారాసన ఉపదిశ్య పౌలమ్ ఆనేతుమ్ ఆజ్ఞాపయత్| ");
INSERT INTO santel_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","పౌలే సముపస్థితే సతి యిరూశాలమ్నగరాద్ ఆగతా యిహూదీయలోకాస్తం చతుర్దిశి సంవేష్ట్య తస్య విరుద్ధం బహూన్ మహాదోషాన్ ఉత్థాపితవన్తః కిన్తు తేషాం కిమపి ప్రమాణం దాతుం న శక్నువన్తః| ");
INSERT INTO santel_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","తతః పౌలః స్వస్మిన్ ఉత్తరమిదమ్ ఉదితవాన్, యిహూదీయానాం వ్యవస్థాయా మన్దిరస్య కైసరస్య వా ప్రతికూలం కిమపి కర్మ్మ నాహం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","కిన్తు ఫీష్టో యిహూదీయాన్ సన్తుష్టాన్ కర్త్తుమ్ అభిలషన్ పౌలమ్ అభాషత త్వం కిం యిరూశాలమం గత్వాస్మిన్ అభియోగే మమ సాక్షాద్ విచారితో భవిష్యసి? ");
INSERT INTO santel_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","తతః పౌల ఉత్తరం ప్రోక్తవాన్, యత్ర మమ విచారో భవితుం యోగ్యః కైసరస్య తత్ర విచారాసన ఏవ సముపస్థితోస్మి; అహం యిహూదీయానాం కామపి హానిం నాకార్షమ్ ఇతి భవాన్ యథార్థతో విజానాతి| ");
INSERT INTO santel_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","కఞ్చిదపరాధం కిఞ్చన వధార్హం కర్మ్మ వా యద్యహమ్ అకరిష్యం తర్హి ప్రాణహననదణ్డమపి భోక్తుమ్ ఉద్యతోఽభవిష్యం, కిన్తు తే మమ సమపవాదం కుర్వ్వన్తి స యది కల్పితమాత్రో భవతి తర్హి తేషాం కరేషు మాం సమర్పయితుం కస్యాప్యధికారో నాస్తి, కైసరస్య నికటే మమ విచారో భవతు| ");
INSERT INTO santel_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","తదా ఫీష్టో మన్త్రిభిః సార్ద్ధం సంమన్త్ర్య పౌలాయ కథితవాన్, కైసరస్య నికటే కిం తవ విచారో భవిష్యతి? కైసరస్య సమీపం గమిష్యసి| ");
INSERT INTO santel_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","కియద్దినేభ్యః పరమ్ ఆగ్రిప్పరాజా బర్ణీకీ చ ఫీష్టం సాక్షాత్ కర్త్తుం కైసరియానగరమ్ ఆగతవన్తౌ| ");
INSERT INTO santel_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","తదా తౌ బహుదినాని తత్ర స్థితౌ తతః ఫీష్టస్తం రాజానం పౌలస్య కథాం విజ్ఞాప్య కథయితుమ్ ఆరభత పౌలనామానమ్ ఏకం బన్ది ఫీలిక్షో బద్ధం సంస్థాప్య గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","యిరూశాలమి మమ స్థితికాలే మహాయాజకో యిహూదీయానాం ప్రాచీనలోకాశ్చ తమ్ అపోద్య తమ్ప్రతి దణ్డాజ్ఞాం ప్రార్థయన్త| ");
INSERT INTO santel_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","తతోహమ్ ఇత్యుత్తరమ్ అవదం యావద్ అపోదితో జనః స్వాపవాదకాన్ సాక్షాత్ కృత్వా స్వస్మిన్ యోఽపరాధ ఆరోపితస్తస్య ప్రత్యుత్తరం దాతుం సుయోగం న ప్రాప్నోతి, తావత్కాలం కస్యాపి మానుషస్య ప్రాణనాశాజ్ఞాపనం రోమిలోకానాం రీతి ర్నహి| ");
INSERT INTO santel_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","తతస్తేష్వత్రాగతేషు పరస్మిన్ దివసేఽహమ్ అవిలమ్బం విచారాసన ఉపవిశ్య తం మానుషమ్ ఆనేతుమ్ ఆజ్ఞాపయమ్| ");
INSERT INTO santel_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","తదనన్తరం తస్యాపవాదకా ఉపస్థాయ యాదృశమ్ అహం చిన్తితవాన్ తాదృశం కఞ్చన మహాపవాదం నోత్థాప్య ");
INSERT INTO santel_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","స్వేషాం మతే తథా పౌలో యం సజీవం వదతి తస్మిన్ యీశునామని మృతజనే చ తస్య విరుద్ధం కథితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","తతోహం తాదృగ్విచారే సంశయానః సన్ కథితవాన్ త్వం యిరూశాలమం గత్వా కిం తత్ర విచారితో భవితుమ్ ఇచ్ఛసి? ");
INSERT INTO santel_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","తదా పౌలో మహారాజస్య నికటే విచారితో భవితుం ప్రార్థయత, తస్మాద్ యావత్కాలం తం కైసరస్య సమీపం ప్రేషయితుం న శక్నోమి తావత్కాలం తమత్ర స్థాపయితుమ్ ఆదిష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","తత ఆగ్రిప్పః ఫీష్టమ్ ఉక్తవాన్, అహమపి తస్య మానుషస్య కథాం శ్రోతుమ్ అభిలషామి| తదా ఫీష్టో వ్యాహరత్ శ్వస్తదీయాం కథాం త్వం శ్రోష్యసి| ");
INSERT INTO santel_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","పరస్మిన్ దివసే ఆగ్రిప్పో బర్ణీకీ చ మహాసమాగమం కృత్వా ప్రధానవాహినీపతిభి ర్నగరస్థప్రధానలోకైశ్చ సహ మిలిత్వా రాజగృహమాగత్య సముపస్థితౌ తదా ఫీష్టస్యాజ్ఞయా పౌల ఆనీతోఽభవత్| ");
INSERT INTO santel_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","తదా ఫీష్టః కథితవాన్ హే రాజన్ ఆగ్రిప్ప హే ఉపస్థితాః సర్వ్వే లోకా యిరూశాలమ్నగరే యిహూదీయలోకసమూహో యస్మిన్ మానుషే మమ సమీపే నివేదనం కృత్వా ప్రోచ్చైః కథామిమాం కథితవాన్ పునరల్పకాలమపి తస్య జీవనం నోచితం తమేతం మానుషం పశ్యత| ");
INSERT INTO santel_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","కిన్త్వేష జనః ప్రాణనాశర్హం కిమపి కర్మ్మ న కృతవాన్ ఇత్యజానాం తథాపి స మహారాజస్య సన్నిధౌ విచారితో భవితుం ప్రార్థయత తస్మాత్ తస్య సమీపం తం ప్రేషయితుం మతిమకరవమ్| ");
INSERT INTO santel_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","కిన్తు శ్రీయుక్తస్య సమీపమ్ ఏతస్మిన్ కిం లేఖనీయమ్ ఇత్యస్య కస్యచిన్ నిర్ణయస్య న జాతత్వాద్ ఏతస్య విచారే సతి యథాహం లేఖితుం కిఞ్చన నిశ్చితం ప్రాప్నోమి తదర్థం యుష్మాకం సమక్షం విశేషతో హే ఆగ్రిప్పరాజ భవతః సమక్షమ్ ఏతమ్ ఆనయే| ");
INSERT INTO santel_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","యతో బన్దిప్రేషణసమయే తస్యాభియోగస్య కిఞ్చిదలేఖనమ్ అహమ్ అయుక్తం జానామి| ");
INSERT INTO santel_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","తత ఆగ్రిప్పః పౌలమ్ అవాదీత్, నిజాం కథాం కథయితుం తుభ్యమ్ అనుమతి ర్దీయతే| తస్మాత్ పౌలః కరం ప్రసార్య్య స్వస్మిన్ ఉత్తరమ్ అవాదీత్| ");
INSERT INTO santel_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","హే ఆగ్రిప్పరాజ యత్కారణాదహం యిహూదీయైరపవాదితో ఽభవం తస్య వృత్తాన్తమ్ అద్య భవతః సాక్షాన్ నివేదయితుమనుమతోహమ్ ఇదం స్వీయం పరమం భాగ్యం మన్యే; ");
INSERT INTO santel_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","యతో యిహూదీయలోకానాం మధ్యే యా యా రీతిః సూక్ష్మవిచారాశ్చ సన్తి తేషు భవాన్ విజ్ఞతమః; అతఏవ ప్రార్థయే ధైర్య్యమవలమ్బ్య మమ నివేదనం శృణోతు| ");
INSERT INTO santel_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","అహం యిరూశాలమ్నగరే స్వదేశీయలోకానాం మధ్యే తిష్ఠన్ ఆ యౌవనకాలాద్ యద్రూపమ్ ఆచరితవాన్ తద్ యిహూదీయలోకాః సర్వ్వే విదన్తి| ");
INSERT INTO santel_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","అస్మాకం సర్వ్వేభ్యః శుద్ధతమం యత్ ఫిరూశీయమతం తదవలమ్బీ భూత్వాహం కాలం యాపితవాన్ యే జనా ఆ బాల్యకాలాన్ మాం జానాన్తి తే ఏతాదృశం సాక్ష్యం యది దదాతి తర్హి దాతుం శక్నువన్తి| ");
INSERT INTO santel_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","కిన్తు హే ఆగ్రిప్పరాజ ఈశ్వరోఽస్మాకం పూర్వ్వపురుషాణాం నికటే యద్ అఙ్గీకృతవాన్ తస్య ప్రత్యాశాహేతోరహమ్ ఇదానీం విచారస్థానే దణ్డాయమానోస్మి| ");
INSERT INTO santel_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","తస్యాఙ్గీకారస్య ఫలం ప్రాప్తుమ్ అస్మాకం ద్వాదశవంశా దివానిశం మహాయత్నాద్ ఈశ్వరసేవనం కృత్వా యాం ప్రత్యాశాం కుర్వ్వన్తి తస్యాః ప్రత్యాశాయా హేతోరహం యిహూదీయైరపవాదితోఽభవమ్| ");
INSERT INTO santel_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ఈశ్వరో మృతాన్ ఉత్థాపయిష్యతీతి వాక్యం యుష్మాకం నికటేఽసమ్భవం కుతో భవేత్? ");
INSERT INTO santel_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","నాసరతీయయీశో ర్నామ్నో విరుద్ధం నానాప్రకారప్రతికూలాచరణమ్ ఉచితమ్ ఇత్యహం మనసి యథార్థం విజ్ఞాయ ");
INSERT INTO santel_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","యిరూశాలమనగరే తదకరవం ఫలతః ప్రధానయాజకస్య నికటాత్ క్షమతాం ప్రాప్య బహూన్ పవిత్రలోకాన్ కారాయాం బద్ధవాన్ విశేషతస్తేషాం హననసమయే తేషాం విరుద్ధాం నిజాం సమ్మతిం ప్రకాశితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","వారం వారం భజనభవనేషు తేభ్యో దణ్డం ప్రదత్తవాన్ బలాత్ తం ధర్మ్మం నిన్దయితవాంశ్చ పునశ్చ తాన్ ప్రతి మహాక్రోధాద్ ఉన్మత్తః సన్ విదేశీయనగరాణి యావత్ తాన్ తాడితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ఇత్థం ప్రధానయాజకస్య సమీపాత్ శక్తిమ్ ఆజ్ఞాపత్రఞ్చ లబ్ధ్వా దమ్మేషక్నగరం గతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","తదాహం హే రాజన్ మార్గమధ్యే మధ్యాహ్నకాలే మమ మదీయసఙ్గినాం లోకానాఞ్చ చతసృషు దిక్షు గగణాత్ ప్రకాశమానాం భాస్కరతోపి తేజస్వతీం దీప్తిం దృష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","తస్మాద్ అస్మాసు సర్వ్వేషు భూమౌ పతితేషు సత్సు హే శౌల హై శౌల కుతో మాం తాడయసి? కణ్టకానాం ముఖే పాదాహననం తవ దుఃసాధ్యమ్ ఇబ్రీయభాషయా గదిత ఏతాదృశ ఏకః శబ్దో మయా శ్రుతః| ");
INSERT INTO santel_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","తదాహం పృష్టవాన్ హే ప్రభో కో భవాన్? తతః స కథితవాన్ యం యీశుం త్వం తాడయసి సోహం, ");
INSERT INTO santel_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","కిన్తు సముత్తిష్ఠ త్వం యద్ దృష్టవాన్ ఇతః పునఞ్చ యద్యత్ త్వాం దర్శయిష్యామి తేషాం సర్వ్వేషాం కార్య్యాణాం త్వాం సాక్షిణం మమ సేవకఞ్చ కర్త్తుమ్ దర్శనమ్ అదామ్| ");
INSERT INTO santel_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","విశేషతో యిహూదీయలోకేభ్యో భిన్నజాతీయేభ్యశ్చ త్వాం మనోనీతం కృత్వా తేషాం యథా పాపమోచనం భవతి ");
INSERT INTO santel_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","యథా తే మయి విశ్వస్య పవిత్రీకృతానాం మధ్యే భాగం ప్రాప్నువన్తి తదభిప్రాయేణ తేషాం జ్ఞానచక్షూంషి ప్రసన్నాని కర్త్తుం తథాన్ధకారాద్ దీప్తిం ప్రతి శైతానాధికారాచ్చ ఈశ్వరం ప్రతి మతీః పరావర్త్తయితుం తేషాం సమీపం త్వాం ప్రేష్యామి| ");
INSERT INTO santel_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","హే ఆగ్రిప్పరాజ ఏతాదృశం స్వర్గీయప్రత్యాదేశం అగ్రాహ్యమ్ అకృత్వాహం ");
INSERT INTO santel_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ప్రథమతో దమ్మేషక్నగరే తతో యిరూశాలమి సర్వ్వస్మిన్ యిహూదీయదేశే అన్యేషు దేశేషు చ యేेన లోకా మతిం పరావర్త్త్య ఈశ్వరం ప్రతి పరావర్త్తయన్తే, మనఃపరావర్త్తనయోగ్యాని కర్మ్మాణి చ కుర్వ్వన్తి తాదృశమ్ ఉపదేశం ప్రచారితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ఏతత్కారణాద్ యిహూదీయా మధ్యేమన్దిరం మాం ధృత్వా హన్తుమ్ ఉద్యతాః| ");
INSERT INTO santel_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","తథాపి ఖ్రీష్టో దుఃఖం భుక్త్వా సర్వ్వేషాం పూర్వ్వం శ్మశానాద్ ఉత్థాయ నిజదేశీయానాం భిన్నదేశీయానాఞ్చ సమీపే దీప్తిం ప్రకాశయిష్యతి ");
INSERT INTO santel_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","భవిష్యద్వాదిగణో మూసాశ్చ భావికార్య్యస్య యదిదం ప్రమాణమ్ అదదురేతద్ వినాన్యాం కథాం న కథయిత్వా ఈశ్వరాద్ అనుగ్రహం లబ్ధ్వా మహతాం క్షుద్రాణాఞ్చ సర్వ్వేషాం సమీపే ప్రమాణం దత్త్వాద్య యావత్ తిష్ఠామి| ");
INSERT INTO santel_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","తస్యమాం కథాం నిశమ్య ఫీష్ట ఉచ్చైః స్వరేణ కథితవాన్ హే పౌల త్వమ్ ఉన్మత్తోసి బహువిద్యాభ్యాసేన త్వం హతజ్ఞానో జాతః| ");
INSERT INTO santel_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","స ఉక్తవాన్ హే మహామహిమ ఫీష్ట నాహమ్ ఉన్మత్తః కిన్తు సత్యం వివేచనీయఞ్చ వాక్యం ప్రస్తౌమి| ");
INSERT INTO santel_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","యస్య సాక్షాద్ అక్షోభః సన్ కథాం కథయామి స రాజా తద్వృత్తాన్తం జానాతి తస్య సమీపే కిమపి గుప్తం నేతి మయా నిశ్చితం బుధ్యతే యతస్తద్ విజనే న కృతం| ");
INSERT INTO santel_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","హే ఆగ్రిప్పరాజ భవాన్ కిం భవిష్యద్వాదిగణోక్తాని వాక్యాని ప్రత్యేతి? భవాన్ ప్రత్యేతి తదహం జానామి| ");
INSERT INTO santel_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","తత ఆగ్రిప్పః పౌలమ్ అభిహితవాన్ త్వం ప్రవృత్తిం జనయిత్వా ప్రాయేణ మామపి ఖ్రీష్టీయం కరోషి| ");
INSERT INTO santel_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","తతః సోఽవాదీత్ భవాన్ యే యే లోకాశ్చ మమ కథామ్ అద్య శృణ్వన్తి ప్రాయేణ ఇతి నహి కిన్త్వేతత్ శృఙ్ఖలబన్ధనం వినా సర్వ్వథా తే సర్వ్వే మాదృశా భవన్త్వితీశ్వస్య సమీపే ప్రార్థయేఽహమ్| ");
INSERT INTO santel_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ఏతస్యాం కథాయాం కథితాయాం స రాజా సోఽధిపతి ర్బర్ణీకీ సభాస్థా లోకాశ్చ తస్మాద్ ఉత్థాయ ");
INSERT INTO santel_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","గోపనే పరస్పరం వివిచ్య కథితవన్త ఏష జనో బన్ధనార్హం ప్రాణహననార్హం వా కిమపి కర్మ్మ నాకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","తత ఆగ్రిప్పః ఫీష్టమ్ అవదత్, యద్యేష మానుషః కైసరస్య నికటే విచారితో భవితుం న ప్రార్థయిష్యత్ తర్హి ముక్తో భవితుమ్ అశక్ష్యత్| ");
INSERT INTO santel_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","జలపథేనాస్మాకమ్ ఇతోలియాదేశం ప్రతి యాత్రాయాం నిశ్చితాయాం సత్యాం తే యూలియనామ్నో మహారాజస్య సంఘాతాన్తర్గతస్య సేనాపతేః సమీపే పౌలం తదన్యాన్ కతినయజనాంశ్చ సమార్పయన్| ");
INSERT INTO santel_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","వయమ్ ఆద్రాముత్తీయం పోతమేకమ్ ఆరుహ్య ఆశియాదేశస్య తటసమీపేన యాతుం మతిం కృత్వా లఙ్గరమ్ ఉత్థాప్య పోతమ్ అమోచయామ; మాకిదనియాదేశస్థథిషలనీకీనివాస్యారిస్తార్ఖనామా కశ్చిద్ జనోఽస్మాభిః సార్ద్ధమ్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","పరస్మిన్ దివసే ఽస్మాభిః సీదోన్నగరే పోతే లాగితే తత్ర యూలియః సేనాపతిః పౌలం ప్రతి సౌజన్యం ప్రదర్థ్య సాన్త్వనార్థం బన్ధుబాన్ధవాన్ ఉపయాతుమ్ అనుజజ్ఞౌ| ");
INSERT INTO santel_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","తస్మాత్ పోతే మోచితే సతి సమ్ముఖవాయోః సమ్భవాద్ వయం కుప్రోపద్వీపస్య తీరసమీపేన గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","కిలికియాయాః పామ్ఫూలియాయాశ్చ సముద్రస్య పారం గత్వా లూకియాదేశాన్తర్గతం మురానగరమ్ ఉపాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","తత్స్థానాద్ ఇతాలియాదేశం గచ్ఛతి యః సికన్దరియానగరస్య పోతస్తం తత్ర ప్రాప్య శతసేనాపతిస్తం పోతమ్ అస్మాన్ ఆరోహయత్| ");
INSERT INTO santel_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","తతః పరం బహూని దినాని శనైః శనైః ర్గత్వా క్నీదపార్శ్వోపస్థ్తిेః పూర్వ్వం ప్రతికూలేన పవనేన వయం సల్మోన్యాః సమ్ముఖమ్ ఉపస్థాయ క్రీత్యుపద్వీపస్య తీరసమీపేన గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","కష్టేన తముత్తీర్య్య లాసేయానగరస్యాధః సున్దరనామకం ఖాతమ్ ఉపాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ఇత్థం బహుతిథః కాలో యాపిత ఉపవాసదినఞ్చాతీతం, తత్కారణాత్ నౌవర్త్మని భయఙ్కరే సతి పౌలో వినయేన కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","హే మహేచ్ఛా అహం నిశ్చయం జానామి యాత్రాయామస్యామ్ అస్మాకం క్లేశా బహూనామపచయాశ్చ భవిష్యన్తి, తే కేవలం పోతసామగ్ర్యోరితి నహి, కిన్త్వస్మాకం ప్రాణానామపి| ");
INSERT INTO santel_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","తదా శతసేనాపతిః పౌैेలోక్తవాక్యతోపి కర్ణధారస్య పోతవణిజశ్చ వాక్యం బహుమంస్త| ");
INSERT INTO santel_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","తత్ ఖాతం శీతకాలే వాసార్హస్థానం న తస్మాద్ అవాచీప్రతీచోర్దిశోః క్రీత్యాః ఫైనీకియఖాతం యాతుం యది శక్నువన్తస్తర్హి తత్ర శీతకాలం యాపయితుం ప్రాయేణ సర్వ్వే మన్త్రయామాసుః| ");
INSERT INTO santel_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","తతః పరం దక్షిణవాయు ర్మన్దం వహతీతి విలోక్య నిజాభిప్రాయస్య సిద్ధేః సుయోగో భవతీతి బుద్ధ్వా పోతం మోచయిత్వా క్రీత్యుపద్వీపస్య తీరసమీపేన చలితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","కిన్త్వల్పక్షణాత్ పరమేవ ఉరక్లుదోన్నామా ప్రతికూలః ప్రచణ్డో వాయు ర్వహన్ పోతేఽలగీత్ ");
INSERT INTO santel_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","తస్యాభిముఖం గన్తుమ్ పోతస్యాశక్తత్వాద్ వయం వాయునా స్వయం నీతాః| ");
INSERT INTO santel_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","అనన్తరం క్లౌదీనామ్న ఉపద్వీపస్య కూలసమీపేన పోతం గమయిత్వా బహునా కష్టేన క్షుద్రనావమ్ అరక్షామ| ");
INSERT INTO santel_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","తే తామారుహ్య రజ్జ్చా పోతస్యాధోభాగమ్ అబధ్నన్ తదనన్తరం చేత్ పోతో సైకతే లగతీతి భయాద్ వాతవసనాన్యమోచయన్ తతః పోతో వాయునా చాలితః| ");
INSERT INTO santel_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","కిన్తు క్రమశో వాయోః ప్రబలత్వాత్ పోతో దోలాయమానోఽభవత్ పరస్మిన్ దివసే పోతస్థాని కతిపయాని ద్రవ్యాణి తోయే నిక్షిప్తాని| ");
INSERT INTO santel_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","తృతీయదివసే వయం స్వహస్తైః పోతసజ్జనద్రవ్యాణి నిక్షిప్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","తతో బహుదినాని యావత్ సూర్య్యనక్షత్రాదీని సమాచ్ఛన్నాని తతో ఽతీవ వాత్యాగమాద్ అస్మాకం ప్రాణరక్షాయాః కాపి ప్రత్యాశా నాతిష్ఠత్| ");
INSERT INTO santel_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","బహుదినేషు లోకైరనాహారేణ యాపితేషు సర్వ్వేషాం సాక్షత్ పౌలస్తిష్ఠన్ అకథయత్, హే మహేచ్ఛాః క్రీత్యుపద్వీపాత్ పోతం న మోచయితుమ్ అహం పూర్వ్వం యద్ అవదం తద్గ్రహణం యుష్మాకమ్ ఉచితమ్ ఆసీత్ తథా కృతే యుష్మాకమ్ ఏషా విపద్ ఏషోఽపచయశ్చ నాఘటిష్యేతామ్| ");
INSERT INTO santel_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","కిన్తు సామ్ప్రతం యుష్మాన్ వినీయ బ్రవీమ్యహం, యూయం న క్షుభ్యత యుష్మాకమ్ ఏకస్యాపి ప్రాణినో హాని ర్న భవిష్యతి, కేవలస్య పోతస్య హాని ర్భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","యతో యస్యేశ్వరస్య లోకోఽహం యఞ్చాహం పరిచరామి తదీయ ఏకో దూతో హ్యో రాత్రౌ మమాన్తికే తిష్ఠన్ కథితవాన్, ");
INSERT INTO santel_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","హే పౌల మా భైషీః కైసరస్య సమ్ముఖే త్వయోపస్థాతవ్యం; తవైతాన్ సఙ్గినో లోకాన్ ఈశ్వరస్తుభ్యం దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","అతఏవ హే మహేచ్ఛా యూయం స్థిరమనసో భవత మహ్యం యా కథాకథి సావశ్యం ఘటిష్యతే మమైతాదృశీ విశ్వాస ఈశ్వరే విద్యతే, ");
INSERT INTO santel_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","కిన్తు కస్యచిద్ ఉపద్వీపస్యోపరి పతితవ్యమ్ అస్మాభిః| ");
INSERT INTO santel_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","తతః పరమ్ ఆద్రియాసముద్రే పోతస్తథైవ దోలాయమానః సన్ ఇతస్తతో గచ్ఛన్ చతుర్దశదివసస్య రాత్రే ర్ద్వితీయప్రహరసమయే కస్యచిత్ స్థలస్య సమీపముపతిష్ఠతీతి పోతీయలోకా అన్వమన్యన్త| ");
INSERT INTO santel_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","తతస్తే జలం పరిమాయ తత్ర వింశతి ర్వ్యామా జలానీతి జ్ఞాతవన్తః| కిఞ్చిద్దూరం గత్వా పునరపి జలం పరిమితవన్తః| తత్ర పఞ్చదశ వ్యామా జలాని దృష్ట్వా ");
INSERT INTO santel_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","చేత్ పాషాణే లగతీతి భయాత్ పోతస్య పశ్చాద్భాగతశ్చతురో లఙ్గరాన్ నిక్షిప్య దివాకరమ్ అపేక్ష్య సర్వ్వే స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","కిన్తు పోతీయలోకాః పోతాగ్రభాగే లఙ్గరనిక్షేపం ఛలం కృత్వా జలధౌ క్షుద్రనావమ్ అవరోహ్య పలాయితుమ్ అచేష్టన్త| ");
INSERT INTO santel_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","తతః పౌలః సేనాపతయే సైన్యగణాయ చ కథితవాన్, ఏతే యది పోతమధ్యే న తిష్ఠన్తి తర్హి యుష్మాకం రక్షణం న శక్యం| ");
INSERT INTO santel_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","తదా సేనాగణో రజ్జూన్ ఛిత్వా నావం జలే పతితుమ్ అదదాత్| ");
INSERT INTO santel_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ప్రభాతసమయే పౌలః సర్వ్వాన్ జనాన్ భోజనార్థం ప్రార్థ్య వ్యాహరత్, అద్య చతుర్దశదినాని యావద్ యూయమ్ అపేక్షమానా అనాహారాః కాలమ్ అయాపయత కిమపి నాభుంగ్ధం| ");
INSERT INTO santel_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","అతో వినయేेఽహం భక్ష్యం భుజ్యతాం తతో యుష్మాకం మఙ్గలం భవిష్యతి, యుష్మాకం కస్యచిజ్జనస్య శిరసః కేశైకోపి న నంక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ఇతి వ్యాహృత్య పౌలం పూపం గృహీత్వేశ్వరం ధన్యం భాషమాణస్తం భంక్త్వా భోక్తుమ్ ఆరబ్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","అనన్తరం సర్వ్వే చ సుస్థిరాః సన్తః ఖాద్యాని పర్ప్యగృహ్లన్| ");
INSERT INTO santel_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","అస్మాకం పోతే షట్సప్తత్యధికశతద్వయలోకా ఆసన్| ");
INSERT INTO santel_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","సర్వ్వేషు లోకేషు యథేష్టం భుక్తవత్సు పోతస్థన్ గోధూమాన్ జలధౌ నిక్షిప్య తైః పోతస్య భారో లఘూకృతః| ");
INSERT INTO santel_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","దినే జాతేఽపి స కో దేశ ఇతి తదా న పర్య్యచీయత; కిన్తు తత్ర సమతటమ్ ఏకం ఖాతం దృష్ట్వా యది శక్నుమస్తర్హి వయం తస్యాభ్యన్తరం పోతం గమయామ ఇతి మతిం కృత్వా తే లఙ్గరాన్ ఛిత్త్వా జలధౌ త్యక్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","తథా కర్ణబన్ధనం మోచయిత్వా ప్రధానం వాతవసనమ్ ఉత్తోల్య తీరసమీపం గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","కిన్తు ద్వయోః సముద్రయోః సఙ్గమస్థానే సైకతోపరి పోతే నిక్షిప్తే ఽగ్రభాగే బాధితే పశ్చాద్భాగే ప్రబలతరఙ్గోఽలగత్ తేన పోతో భగ్నః| ");
INSERT INTO santel_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","తస్మాద్ బన్దయశ్చేద్ బాహుభిస్తరన్తః పలాయన్తే ఇత్యాశఙ్కయా సేనాగణస్తాన్ హన్తుమ్ అమన్త్రయత్; ");
INSERT INTO santel_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","కిన్తు శతసేనాపతిః పౌలం రక్షితుం ప్రయత్నం కృత్వా తాన్ తచ్చేష్టాయా నివర్త్య ఇత్యాదిష్టవాన్, యే బాహుతరణం జానన్తి తేఽగ్రే ప్రోల్లమ్ప్య సముద్రే పతిత్వా బాహుభిస్తీర్త్త్వా కూలం యాన్తు| ");
INSERT INTO santel_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","అపరమ్ అవశిష్టా జనాః కాష్ఠం పోతీయం ద్రవ్యం వా యేన యత్ ప్రాప్యతే తదవలమ్బ్య యాన్తు; ఇత్థం సర్వ్వే భూమిం ప్రాప్య ప్రాణై ర్జీవితాః| ");
INSERT INTO santel_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ఇత్థం సర్వ్వేషు రక్షాం ప్రాప్తేషు తత్రత్యోపద్వీపస్య నామ మిలీతేతి తే జ్ఞాతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","అసభ్యలోకా యథేష్టమ్ అనుకమ్పాం కృత్వా వర్త్తమానవృష్టేః శీతాచ్చ వహ్నిం ప్రజ్జ్వాల్యాస్మాకమ్ ఆతిథ్యమ్ అకుర్వ్వన్| ");
INSERT INTO santel_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","కిన్తు పౌల ఇన్ధనాని సంగృహ్య యదా తస్మిన్ అగ్రౌ నిరక్షిపత్, తదా వహ్నేః ప్రతాపాత్ ఏకః కృష్ణసర్పో నిర్గత్య తస్య హస్తే ద్రష్టవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","తేఽసభ్యలోకాస్తస్య హస్తే సర్పమ్ అవలమ్బమానం దృష్ట్వా పరస్పరమ్ ఉక్తవన్త ఏష జనోఽవశ్యం నరహా భవిష్యతి, యతో యద్యపి జలధే రక్షాం ప్రాప్తవాన్ తథాపి ప్రతిఫలదాయక ఏనం జీవితుం న దదాతి| ");
INSERT INTO santel_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","కిన్తు స హస్తం విధున్వన్ తం సర్పమ్ అగ్నిమధ్యే నిక్షిప్య కామపి పీడాం నాప్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","తతో విషజ్వాలయా ఏతస్య శరీరం స్ఫీతం భవిష్యతి యద్వా హఠాదయం ప్రాణాన్ త్యక్ష్యతీతి నిశ్చిత్య లోకా బహుక్షణాని యావత్ తద్ ద్రష్టుం స్థితవన్తః కిన్తు తస్య కస్యాశ్చిద్ విపదోఽఘటనాత్ తే తద్విపరీతం విజ్ఞాయ భాషితవన్త ఏష కశ్చిద్ దేవో భవేత్| ");
INSERT INTO santel_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","పుబ్లియనామా జన ఏకస్తస్యోపద్వీపస్యాధిపతిరాసీత్ తత్ర తస్య భూమ్యాది చ స్థితం| స జనోఽస్మాన్ నిజగృహం నీత్వా సౌజన్యం ప్రకాశ్య దినత్రయం యావద్ అస్మాకం ఆతిథ్యమ్ అకరోత్| ");
INSERT INTO santel_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","తదా తస్య పుబ్లియస్య పితా జ్వరాతిసారేణ పీడ్యమానః సన్ శయ్యాయామ్ ఆసీత్; తతః పౌలస్తస్య సమీపం గత్వా ప్రార్థనాం కృత్వా తస్య గాత్రే హస్తం సమర్ప్య తం స్వస్థం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ఇత్థం భూతే తద్వీపనివాసిన ఇతరేపి రోగిలోకా ఆగత్య నిరామయా అభవన్| ");
INSERT INTO santel_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","తస్మాత్తేఽస్మాకమ్ అతీవ సత్కారం కృతవన్తః, విశేషతః ప్రస్థానసమయే ప్రయోజనీయాని నానద్రవ్యాణి దత్తవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ఇత్థం తత్ర త్రిషు మాసేషు గతేషు యస్య చిహ్నం దియస్కూరీ తాదృశ ఏకః సికన్దరీయనగరస్య పోతః శీతకాలం యాపయన్ తస్మిన్ ఉపద్వీపే ఽతిష్ఠత్ తమేవ పోతం వయమ్ ఆరుహ్య యాత్రామ్ అకుర్మ్మ| ");
INSERT INTO santel_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","తతః ప్రథమతః సురాకూసనగరమ్ ఉపస్థాయ తత్ర త్రీణి దినాని స్థితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","తస్మాద్ ఆవృత్య రీగియనగరమ్ ఉపస్థితాః దినైకస్మాత్ పరం దక్షిణవయౌ సానుకూల్యే సతి పరస్మిన్ దివసే పతియలీనగరమ్ ఉపాతిష్ఠామ| ");
INSERT INTO santel_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","తతోఽస్మాసు తత్రత్యం భ్రాతృగణం ప్రాప్తేషు తే స్వైః సార్ద్ధమ్ అస్మాన్ సప్త దినాని స్థాపయితుమ్ అయతన్త, ఇత్థం వయం రోమానగరమ్ ప్రత్యగచ్ఛామ| ");
INSERT INTO santel_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","తస్మాత్ తత్రత్యాః భ్రాతరోఽస్మాకమ్ ఆగమనవార్త్తాం శ్రుత్వా ఆప్పియఫరం త్రిష్టావర్ణీఞ్చ యావద్ అగ్రేసరాః సన్తోస్మాన్ సాక్షాత్ కర్త్తుమ్ ఆగమన్; తేషాం దర్శనాత్ పౌల ఈశ్వరం ధన్యం వదన్ ఆశ్వాసమ్ ఆప్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","అస్మాసు రోమానగరం గతేషు శతసేనాపతిః సర్వ్వాన్ బన్దీన్ ప్రధానసేనాపతేః సమీపే సమార్పయత్ కిన్తు పౌలాయ స్వరక్షకపదాతినా సహ పృథగ్ వస్తుమ్ అనుమతిం దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","దినత్రయాత్ పరం పౌలస్తద్దేశస్థాన్ ప్రధానయిహూదిన ఆహూతవాన్ తతస్తేషు సముపస్థితేషు స కథితవాన్, హే భ్రాతృగణ నిజలోకానాం పూర్వ్వపురుషాణాం వా రీతే ర్విపరీతం కిఞ్చన కర్మ్మాహం నాకరవం తథాపి యిరూశాలమనివాసినో లోకా మాం బన్దిం కృత్వా రోమిలోకానాం హస్తేషు సమర్పితవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","రోమిలోకా విచార్య్య మమ ప్రాణహననార్హం కిమపి కారణం న ప్రాప్య మాం మోచయితుమ్ ఐచ్ఛన్; ");
INSERT INTO santel_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","కిన్తు యిహూదిలోకానామ్ ఆపత్త్యా మయా కైసరరాజస్య సమీపే విచారస్య ప్రార్థనా కర్త్తవ్యా జాతా నోచేత్ నిజదేశీయలోకాన్ ప్రతి మమ కోప్యభియోగో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ఏతత్కారణాద్ అహం యుష్మాన్ ద్రష్టుం సంలపితుఞ్చాహూయమ్ ఇస్రాయేల్వశీయానాం ప్రత్యాశాహేతోహమ్ ఏతేన శుఙ్ఖలేన బద్ధోఽభవమ్| ");
INSERT INTO santel_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","తదా తే తమ్ అవాదిషుః, యిహూదీయదేశాద్ వయం త్వామధి కిమపి పత్రం న ప్రాప్తా యే భ్రాతరః సమాయాతాస్తేషాం కోపి తవ కామపి వార్త్తాం నావదత్ అభద్రమపి నాకథయచ్చ| ");
INSERT INTO santel_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","తవ మతం కిమితి వయం త్వత్తః శ్రోతుమిచ్ఛామః| యద్ ఇదం నవీనం మతముత్థితం తత్ సర్వ్వత్ర సర్వ్వేషాం నికటే నిన్దితం జాతమ ఇతి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","తైస్తదర్థమ్ ఏకస్మిన్ దినే నిరూపితే తస్మిన్ దినే బహవ ఏకత్ర మిలిత్వా పౌలస్య వాసగృహమ్ ఆగచ్ఛన్ తస్మాత్ పౌల ఆ ప్రాతఃకాలాత్ సన్ధ్యాకాలం యావన్ మూసావ్యవస్థాగ్రన్థాద్ భవిష్యద్వాదినాం గ్రన్థేభ్యశ్చ యీశోః కథామ్ ఉత్థాప్య ఈశ్వరస్య రాజ్యే ప్రమాణం దత్వా తేషాం ప్రవృత్తిం జనయితుం చేష్టితవాన్| ");
INSERT INTO santel_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","కేచిత్తు తస్య కథాం ప్రత్యాయన్ కేచిత్తు న ప్రత్యాయన్; ");
INSERT INTO santel_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ఏతత్కారణాత్ తేషాం పరస్పరమ్ అనైక్యాత్ సర్వ్వే చలితవన్తః; తథాపి పౌల ఏతాం కథామేకాం కథితవాన్ పవిత్ర ఆత్మా యిశయియస్య భవిష్యద్వక్తు ర్వదనాద్ అస్మాకం పితృపురుషేభ్య ఏతాం కథాం భద్రం కథయామాస, యథా, ");
INSERT INTO santel_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ఉపగత్య జనానేతాన్ త్వం భాషస్వ వచస్త్విదం| కర్ణైః శ్రోష్యథ యూయం హి కిన్తు యూయం న భోత్స్యథ| నేత్రై ర్ద్రక్ష్యథ యూయఞ్చ జ్ఞాతుం యూయం న శక్ష్యథ| ");
INSERT INTO santel_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","తే మానుషా యథా నేత్రైః పరిపశ్యన్తి నైవ హి| కర్ణైః ర్యథా న శృణ్వన్తి బుధ్యన్తే న చ మానసైః| వ్యావర్త్తయత్సు చిత్తాని కాలే కుత్రాపి తేషు వై| మత్తస్తే మనుజాః స్వస్థా యథా నైవ భవన్తి చ| తథా తేషాం మనుష్యాణాం సన్తి స్థూలా హి బుద్ధయః| బధిరీభూతకర్ణాశ్చ జాతాశ్చ ముద్రితా దృశః|| ");
INSERT INTO santel_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","అత ఈశ్వరాద్ యత్ పరిత్రాణం తస్య వార్త్తా భిన్నదేశీయానాం సమీపం ప్రేషితా తఏవ తాం గ్రహీష్యన్తీతి యూయం జానీత| ");
INSERT INTO santel_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ఏతాదృశ్యాం కథాయాం కథితాయాం సత్యాం యిహూదినః పరస్పరం బహువిచారం కుర్వ్వన్తో గతవన్తః| ");
INSERT INTO santel_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ఇత్థం పౌలః సమ్పూర్ణం వత్సరద్వయం యావద్ భాటకీయే వాసగృహే వసన్ యే లోకాస్తస్య సన్నిధిమ్ ఆగచ్ఛన్తి తాన్ సర్వ్వానేవ పరిగృహ్లన్, ");
INSERT INTO santel_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","నిర్విఘ్నమ్ అతిశయనిఃక్షోభమ్ ఈశ్వరీయరాజత్వస్య కథాం ప్రచారయన్ ప్రభౌ యీశౌ ఖ్రీష్టే కథాః సముపాదిశత్| ఇతి||");
INSERT INTO santel_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ఈశ్వరో నిజపుత్రమధి యం సుసంవాదం భవిష్యద్వాదిభి ర్ధర్మ్మగ్రన్థే ప్రతిశ్రుతవాన్ తం సుసంవాదం ప్రచారయితుం పృథక్కృత ఆహూతః ప్రేరితశ్చ ప్రభో ర్యీశుఖ్రీష్టస్య సేవకో యః పౌలః ");
INSERT INTO santel_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","స రోమానగరస్థాన్ ఈశ్వరప్రియాన్ ఆహూతాంశ్చ పవిత్రలోకాన్ ప్రతి పత్రం లిఖతి| ");
INSERT INTO santel_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","అస్మాకం స ప్రభు ర్యీశుః ఖ్రీష్టః శారీరికసమ్బన్ధేన దాయూదో వంశోద్భవః ");
INSERT INTO santel_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","పవిత్రస్యాత్మనః సమ్బన్ధేన చేశ్వరస్య ప్రభావవాన్ పుత్ర ఇతి శ్మశానాత్ తస్యోత్థానేన ప్రతిపన్నం| ");
INSERT INTO santel_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","అపరం యేషాం మధ్యే యీశునా ఖ్రీష్టేన యూయమప్యాహూతాస్తే ఽన్యదేశీయలోకాస్తస్య నామ్ని విశ్వస్య నిదేశగ్రాహిణో యథా భవన్తి ");
INSERT INTO santel_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","తదభిప్రాయేణ వయం తస్మాద్ అనుగ్రహం ప్రేరితత్వపదఞ్చ ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","తాతేనాస్మాకమ్ ఈశ్వరేణ ప్రభుణా యీశుఖ్రీష్టేన చ యుష్మభ్యమ్ అనుగ్రహః శాన్తిశ్చ ప్రదీయేతాం| ");
INSERT INTO santel_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ప్రథమతః సర్వ్వస్మిన్ జగతి యుష్మాకం విశ్వాసస్య ప్రకాశితత్వాద్ అహం యుష్మాకం సర్వ్వేషాం నిమిత్తం యీశుఖ్రీష్టస్య నామ గృహ్లన్ ఈశ్వరస్య ధన్యవాదం కరోమి| ");
INSERT INTO santel_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","అపరమ్ ఈశ్వరస్య ప్రసాదాద్ బహుకాలాత్ పరం సామ్ప్రతం యుష్మాకం సమీపం యాతుం కథమపి యత్ సుయోగం ప్రాప్నోమి, ఏతదర్థం నిరన్తరం నామాన్యుచ్చారయన్ నిజాసు సర్వ్వప్రార్థనాసు సర్వ్వదా నివేదయామి, ");
INSERT INTO santel_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ఏతస్మిన్ యమహం తత్పుత్రీయసుసంవాదప్రచారణేన మనసా పరిచరామి స ఈశ్వరో మమ సాక్షీ విద్యతే| ");
INSERT INTO santel_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","యతో యుష్మాకం మమ చ విశ్వాసేన వయమ్ ఉభయే యథా శాన్తియుక్తా భవామ ఇతి కారణాద్ ");
INSERT INTO santel_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","యుష్మాకం స్థైర్య్యకరణార్థం యుష్మభ్యం కిఞ్చిత్పరమార్థదానదానాయ యుష్మాన్ సాక్షాత్ కర్త్తుం మదీయా వాఞ్ఛా| ");
INSERT INTO santel_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","హే భ్రాతృగణ భిన్నదేశీయలోకానాం మధ్యే యద్వత్ తద్వద్ యుష్మాకం మధ్యేపి యథా ఫలం భుఞ్జే తదభిప్రాయేణ ముహుర్ముహు ర్యుష్మాకం సమీపం గన్తుమ్ ఉద్యతోఽహం కిన్తు యావద్ అద్య తస్మిన్ గమనే మమ విఘ్నో జాత ఇతి యూయం యద్ అజ్ఞాతాస్తిష్ఠథ తదహమ్ ఉచితం న బుధ్యే| ");
INSERT INTO santel_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","అహం సభ్యాసభ్యానాం విద్వదవిద్వతాఞ్చ సర్వ్వేషామ్ ఋణీ విద్యే| ");
INSERT INTO santel_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","అతఏవ రోమానివాసినాం యుష్మాకం సమీపేఽపి యథాశక్తి సుసంవాదం ప్రచారయితుమ్ అహమ్ ఉద్యతోస్మి| ");
INSERT INTO santel_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","యతః ఖ్రీష్టస్య సుసంవాదో మమ లజ్జాస్పదం నహి స ఈశ్వరస్య శక్తిస్వరూపః సన్ ఆ యిహూదీయేభ్యో ఽన్యజాతీయాన్ యావత్ సర్వ్వజాతీయానాం మధ్యే యః కశ్చిద్ తత్ర విశ్వసితి తస్యైవ త్రాణం జనయతి| ");
INSERT INTO santel_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","యతః ప్రత్యయస్య సమపరిమాణమ్ ఈశ్వరదత్తం పుణ్యం తత్సుసంవాదే ప్రకాశతే| తదధి ధర్మ్మపుస్తకేపి లిఖితమిదం \"పుణ్యవాన్ జనో విశ్వాసేన జీవిష్యతి\"| ");
INSERT INTO santel_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","అతఏవ యే మానవాః పాపకర్మ్మణా సత్యతాం రున్ధన్తి తేషాం సర్వ్వస్య దురాచరణస్యాధర్మ్మస్య చ విరుద్ధం స్వర్గాద్ ఈశ్వరస్య కోపః ప్రకాశతే| ");
INSERT INTO santel_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","యత ఈశ్వరమధి యద్యద్ జ్ఞేయం తద్ ఈశ్వరః స్వయం తాన్ ప్రతి ప్రకాశితవాన్ తస్మాత్ తేషామ్ అగోచరం నహి| ");
INSERT INTO santel_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ఫలతస్తస్యానన్తశక్తీశ్వరత్వాదీన్యదృశ్యాన్యపి సృష్టికాలమ్ ఆరభ్య కర్మ్మసు ప్రకాశమానాని దృశ్యన్తే తస్మాత్ తేషాం దోషప్రక్షాలనస్య పన్థా నాస్తి| ");
INSERT INTO santel_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","అపరమ్ ఈశ్వరం జ్ఞాత్వాపి తే తమ్ ఈశ్వరజ్ఞానేన నాద్రియన్త కృతజ్ఞా వా న జాతాః; తస్మాత్ తేషాం సర్వ్వే తర్కా విఫలీభూతాః, అపరఞ్చ తేషాం వివేకశూన్యాని మనాంసి తిమిరే మగ్నాని| ");
INSERT INTO santel_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","తే స్వాన్ జ్ఞానినో జ్ఞాత్వా జ్ఞానహీనా అభవన్ ");
INSERT INTO santel_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","అనశ్వరస్యేశ్వరస్య గౌరవం విహాయ నశ్వరమనుష్యపశుపక్ష్యురోగామిప్రభృతేరాకృతివిశిష్టప్రతిమాస్తైరాశ్రితాః| ");
INSERT INTO santel_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ఇత్థం త ఈశ్వరస్య సత్యతాం విహాయ మృషామతమ్ ఆశ్రితవన్తః సచ్చిదానన్దం సృష్టికర్త్తారం త్యక్త్వా సృష్టవస్తునః పూజాం సేవాఞ్చ కృతవన్తః; ");
INSERT INTO santel_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ఇతి హేతోరీశ్వరస్తాన్ కుక్రియాయాం సమర్ప్య నిజనిజకుచిన్తాభిలాషాభ్యాం స్వం స్వం శరీరం పరస్పరమ్ అపమానితం కర్త్తుమ్ అదదాత్| ");
INSERT INTO santel_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ఈశ్వరేణ తేషు క్వభిలాషే సమర్పితేషు తేషాం యోషితః స్వాభావికాచరణమ్ అపహాయ విపరీతకృత్యే ప్రావర్త్తన్త; ");
INSERT INTO santel_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","తథా పురుషా అపి స్వాభావికయోషిత్సఙ్గమం విహాయ పరస్పరం కామకృశానునా దగ్ధాః సన్తః పుమాంసః పుంభిః సాకం కుకృత్యే సమాసజ్య నిజనిజభ్రాన్తేః సముచితం ఫలమ్ అలభన్త| ");
INSERT INTO santel_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","తే స్వేషాం మనఃస్వీశ్వరాయ స్థానం దాతుమ్ అనిచ్ఛుకాస్తతో హేతోరీశ్వరస్తాన్ ప్రతి దుష్టమనస్కత్వమ్ అవిహితక్రియత్వఞ్చ దత్తవాన్| ");
INSERT INTO santel_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","అతఏవ తే సర్వ్వే ఽన్యాయో వ్యభిచారో దుష్టత్వం లోభో జిఘాంసా ఈర్ష్యా వధో వివాదశ్చాతురీ కుమతిరిత్యాదిభి ర్దుష్కర్మ్మభిః పరిపూర్ణాః సన్తః ");
INSERT INTO santel_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","కర్ణేజపా అపవాదిన ఈశ్వరద్వేషకా హింసకా అహఙ్కారిణ ఆత్మశ్లాఘినః కుకర్మ్మోత్పాదకాః పిత్రోరాజ్ఞాలఙ్ఘకా ");
INSERT INTO santel_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","అవిచారకా నియమలఙ్ఘినః స్నేహరహితా అతిద్వేషిణో నిర్దయాశ్చ జాతాః| ");
INSERT INTO santel_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","యే జనా ఏతాదృశం కర్మ్మ కుర్వ్వన్తి తఏవ మృతియోగ్యా ఈశ్వరస్య విచారమీదృశం జ్ఞాత్వాపి త ఏతాదృశం కర్మ్మ స్వయం కుర్వ్వన్తి కేవలమితి నహి కిన్తు తాదృశకర్మ్మకారిషు లోకేష్వపి ప్రీయన్తే| ");
INSERT INTO santel_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","హే పరదూషక మనుష్య యః కశ్చన త్వం భవసి తవోత్తరదానాయ పన్థా నాస్తి యతో యస్మాత్ కర్మ్మణః పరస్త్వయా దూష్యతే తస్మాత్ త్వమపి దూష్యసే, యతస్తం దూషయన్నపి త్వం తద్వద్ ఆచరసి| ");
INSERT INTO santel_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","కిన్త్వేతాదృగాచారిభ్యో యం దణ్డమ్ ఈశ్వరో నిశ్చినోతి స యథార్థ ఇతి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","అతఏవ హే మానుష త్వం యాదృగాచారిణో దూషయసి స్వయం యది తాదృగాచరసి తర్హి త్వమ్ ఈశ్వరదణ్డాత్ పలాయితుం శక్ష్యసీతి కిం బుధ్యసే? ");
INSERT INTO santel_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","అపరం తవ మనసః పరివర్త్తనం కర్త్తుమ్ ఇశ్వరస్యానుగ్రహో భవతి తన్న బుద్ధ్వా త్వం కిం తదీయానుగ్రహక్షమాచిరసహిష్ణుత్వనిధిం తుచ్ఛీకరోషి? ");
INSERT INTO santel_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","తథా స్వాన్తఃకరణస్య కఠోరత్వాత్ ఖేదరాహిత్యాచ్చేశ్వరస్య న్యాయ్యవిచారప్రకాశనస్య క్రోధస్య చ దినం యావత్ కిం స్వార్థం కోపం సఞ్చినోషి? ");
INSERT INTO santel_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","కిన్తు స ఏకైకమనుజాయ తత్కర్మ్మానుసారేణ ప్రతిఫలం దాస్యతి; ");
INSERT INTO santel_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","వస్తుతస్తు యే జనా ధైర్య్యం ధృత్వా సత్కర్మ్మ కుర్వ్వన్తో మహిమా సత్కారోఽమరత్వఞ్చైతాని మృగయన్తే తేభ్యోఽనన్తాయు ర్దాస్యతి| ");
INSERT INTO santel_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","అపరం యే జనాః సత్యధర్మ్మమ్ అగృహీత్వా విపరీతధర్మ్మమ్ గృహ్లన్తి తాదృశా విరోధిజనాః కోపం క్రోధఞ్చ భోక్ష్యన్తే| ");
INSERT INTO santel_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ఆ యిహూదినోఽన్యదేశినః పర్య్యన్తం యావన్తః కుకర్మ్మకారిణః ప్రాణినః సన్తి తే సర్వ్వే దుఃఖం యాతనాఞ్చ గమిష్యన్తి; ");
INSERT INTO santel_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","కిన్తు ఆ యిహూదినో భిన్నదేశిపర్య్యన్తా యావన్తః సత్కర్మ్మకారిణో లోకాః సన్తి తాన్ ప్రతి మహిమా సత్కారః శాన్తిశ్చ భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ఈశ్వరస్య విచారే పక్షపాతో నాస్తి| ");
INSERT INTO santel_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","అలబ్ధవ్యవస్థాశాస్త్రై ర్యైః పాపాని కృతాని వ్యవస్థాశాస్త్రాలబ్ధత్వానురూపస్తేషాం వినాశో భవిష్యతి; కిన్తు లబ్ధవ్యవస్థాశాస్త్రా యే పాపాన్యకుర్వ్వన్ వ్యవస్థానుసారాదేవ తేషాం విచారో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","వ్యవస్థాశ్రోతార ఈశ్వరస్య సమీపే నిష్పాపా భవిష్యన్తీతి నహి కిన్తు వ్యవస్థాచారిణ ఏవ సపుణ్యా భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","యతో ఽలబ్ధవ్యవస్థాశాస్త్రా భిన్నదేశీయలోకా యది స్వభావతో వ్యవస్థానురూపాన్ ఆచారాన్ కుర్వ్వన్తి తర్హ్యలబ్ధశాస్త్రాః సన్తోఽపి తే స్వేషాం వ్యవస్థాశాస్త్రమివ స్వయమేవ భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","తేషాం మనసి సాక్షిస్వరూపే సతి తేషాం వితర్కేషు చ కదా తాన్ దోషిణః కదా వా నిర్దోషాన్ కృతవత్సు తే స్వాన్తర్లిఖితస్య వ్యవస్థాశాస్త్రస్య ప్రమాణం స్వయమేవ దదతి| ");
INSERT INTO santel_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","యస్మిన్ దినే మయా ప్రకాశితస్య సుసంవాదస్యానుసారాద్ ఈశ్వరో యీశుఖ్రీష్టేన మానుషాణామ్ అన్తఃకరణానాం గూఢాభిప్రాయాన్ ధృత్వా విచారయిష్యతి తస్మిన్ విచారదినే తత్ ప్రకాశిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","పశ్య త్వం స్వయం యిహూదీతి విఖ్యాతో వ్యవస్థోపరి విశ్వాసం కరోషి, ");
INSERT INTO santel_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ఈశ్వరముద్దిశ్య స్వం శ్లాఘసే, తథా వ్యవస్థయా శిక్షితో భూత్వా తస్యాభిమతం జానాసి, సర్వ్వాసాం కథానాం సారం వివింక్షే, ");
INSERT INTO santel_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","అపరం జ్ఞానస్య సత్యతాయాశ్చాకరస్వరూపం శాస్త్రం మమ సమీపే విద్యత అతో ఽన్ధలోకానాం మార్గదర్శయితా ");
INSERT INTO santel_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","తిమిరస్థితలోకానాం మధ్యే దీప్తిస్వరూపోఽజ్ఞానలోకేభ్యో జ్ఞానదాతా శిశూనాం శిక్షయితాహమేవేతి మన్యసే| ");
INSERT INTO santel_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","పరాన్ శిక్షయన్ స్వయం స్వం కిం న శిక్షయసి? వస్తుతశ్చౌర్య్యనిషేధవ్యవస్థాం ప్రచారయన్ త్వం కిం స్వయమేవ చోరయసి? ");
INSERT INTO santel_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","తథా పరదారగమనం ప్రతిషేధన్ స్వయం కిం పరదారాన్ గచ్ఛసి? తథా త్వం స్వయం ప్రతిమాద్వేషీ సన్ కిం మన్దిరస్య ద్రవ్యాణి హరసి? ");
INSERT INTO santel_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","యస్త్వం వ్యవస్థాం శ్లాఘసే స త్వం కిం వ్యవస్థామ్ అవమత్య నేశ్వరం సమ్మన్యసే? ");
INSERT INTO santel_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","శాస్త్రే యథా లిఖతి \"భిన్నదేశినాం సమీపే యుష్మాకం దోషాద్ ఈశ్వరస్య నామ్నో నిన్దా భవతి| \" ");
INSERT INTO santel_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","యది వ్యవస్థాం పాలయసి తర్హి తవ త్వక్ఛేదక్రియా సఫలా భవతి; యతి వ్యవస్థాం లఙ్ఘసే తర్హి తవ త్వక్ఛేదోఽత్వక్ఛేదో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","యతో వ్యవస్థాశాస్త్రాదిష్టధర్మ్మకర్మ్మాచారీ పుమాన్ అత్వక్ఛేదీ సన్నపి కిం త్వక్ఛేదినాం మధ్యే న గణయిష్యతే? ");
INSERT INTO santel_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","కిన్తు లబ్ధశాస్త్రశ్ఛిన్నత్వక్ చ త్వం యది వ్యవస్థాలఙ్ఘనం కరోషి తర్హి వ్యవస్థాపాలకాః స్వాభావికాచ్ఛిన్నత్వచో లోకాస్త్వాం కిం న దూషయిష్యన్తి? ");
INSERT INTO santel_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","తస్మాద్ యో బాహ్యే యిహూదీ స యిహూదీ నహి తథాఙ్గస్య యస్త్వక్ఛేదః స త్వక్ఛేదో నహి; ");
INSERT INTO santel_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","కిన్తు యో జన ఆన్తరికో యిహూదీ స ఏవ యిహూదీ అపరఞ్చ కేవలలిఖితయా వ్యవస్థయా న కిన్తు మానసికో యస్త్వక్ఛేదో యస్య చ ప్రశంసా మనుష్యేభ్యో న భూత్వా ఈశ్వరాద్ భవతి స ఏవ త్వక్ఛేదః| ");
INSERT INTO santel_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","అపరఞ్చ యిహూదినః కిం శ్రేష్ఠత్వం? తథా త్వక్ఛేదస్య వా కిం ఫలం? ");
INSERT INTO santel_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","సర్వ్వథా బహూని ఫలాని సన్తి, విశేషత ఈశ్వరస్య శాస్త్రం తేభ్యోఽదీయత| ");
INSERT INTO santel_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","కైశ్చిద్ అవిశ్వసనే కృతే తేషామ్ అవిశ్వసనాత్ కిమ్ ఈశ్వరస్య విశ్వాస్యతాయా హానిరుత్పత్స్యతే? ");
INSERT INTO santel_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","కేనాపి ప్రకారేణ నహి| యద్యపి సర్వ్వే మనుష్యా మిథ్యావాదినస్తథాపీశ్వరః సత్యవాదీ| శాస్త్రే యథా లిఖితమాస్తే, అతస్త్వన్తు స్వవాక్యేన నిర్ద్దోషో హి భవిష్యసి| విచారే చైవ నిష్పాపో భవిష్యసి న సంశయః| ");
INSERT INTO santel_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","అస్మాకమ్ అన్యాయేన యదీశ్వరస్య న్యాయః ప్రకాశతే తర్హి కిం వదిష్యామః? అహం మానుషాణాం కథామివ కథాం కథయామి, ఈశ్వరః సముచితం దణ్డం దత్త్వా కిమ్ అన్యాయీ భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ఇత్థం న భవతు, తథా సతీశ్వరః కథం జగతో విచారయితా భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","మమ మిథ్యావాక్యవదనాద్ యదీశ్వరస్య సత్యత్వేన తస్య మహిమా వర్ద్ధతే తర్హి కస్మాదహం విచారేఽపరాధిత్వేన గణ్యో భవామి? ");
INSERT INTO santel_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","మఙ్గలార్థం పాపమపి కరణీయమితి వాక్యం త్వయా కుతో నోచ్యతే? కిన్తు యైరుచ్యతే తే నితాన్తం దణ్డస్య పాత్రాణి భవన్తి; తథాపి తద్వాక్యమ్ అస్మాభిరప్యుచ్యత ఇత్యస్మాకం గ్లానిం కుర్వ్వన్తః కియన్తో లోకా వదన్తి| ");
INSERT INTO santel_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","అన్యలోకేభ్యో వయం కిం శ్రేష్ఠాః? కదాచన నహి యతో యిహూదినో ఽన్యదేశినశ్చ సర్వ్వఏవ పాపస్యాయత్తా ఇత్యస్య ప్రమాణం వయం పూర్వ్వమ్ అదదామ| ");
INSERT INTO santel_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","లిపి ర్యథాస్తే, నైకోపి ధార్మ్మికో జనః| ");
INSERT INTO santel_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","తథా జ్ఞానీశ్వరజ్ఞానీ మానవః కోపి నాస్తి హి| ");
INSERT INTO santel_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","విమార్గగామినః సర్వ్వే సర్వ్వే దుష్కర్మ్మకారిణః| ఏకో జనోపి నో తేషాం సాధుకర్మ్మ కరోతి చ| ");
INSERT INTO santel_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","తథా తేషాన్తు వై కణ్ఠా అనావృతశ్మశానవత్| స్తుతివాదం ప్రకుర్వ్వన్తి జిహ్వాభిస్తే తు కేవలం| తేషామోష్ఠస్య నిమ్నే తు విషం తిష్ఠతి సర్ప్పవత్| ");
INSERT INTO santel_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ముఖం తేషాం హి శాపేన కపటేన చ పూర్య్యతే| ");
INSERT INTO santel_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","రక్తపాతాయ తేషాం తు పదాని క్షిప్రగాని చ| ");
INSERT INTO santel_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","పథి తేషాం మనుష్యాణాం నాశః క్లేశశ్చ కేవలః| ");
INSERT INTO santel_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","తే జనా నహి జానన్తి పన్థానం సుఖదాయినం| ");
INSERT INTO santel_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","పరమేశాద్ భయం యత్తత్ తచ్చక్షుషోరగోచరం| ");
INSERT INTO santel_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","వ్యవస్థాయాం యద్యల్లిఖతి తద్ వ్యవస్థాధీనాన్ లోకాన్ ఉద్దిశ్య లిఖతీతి వయం జానీమః| తతో మనుష్యమాత్రో నిరుత్తరః సన్ ఈశ్వరస్య సాక్షాద్ అపరాధీ భవతి| ");
INSERT INTO santel_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","అతఏవ వ్యవస్థానురూపైః కర్మ్మభిః కశ్చిదపి ప్రాణీశ్వరస్య సాక్షాత్ సపుణ్యీకృతో భవితుం న శక్ష్యతి యతో వ్యవస్థయా పాపజ్ఞానమాత్రం జాయతే| ");
INSERT INTO santel_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","కిన్తు వ్యవస్థాయాః పృథగ్ ఈశ్వరేణ దేయం యత్ పుణ్యం తద్ వ్యవస్థాయా భవిష్యద్వాదిగణస్య చ వచనైః ప్రమాణీకృతం సద్ ఇదానీం ప్రకాశతే| ");
INSERT INTO santel_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","యీశుఖ్రీష్టే విశ్వాసకరణాద్ ఈశ్వరేణ దత్తం తత్ పుణ్యం సకలేషు ప్రకాశితం సత్ సర్వ్వాన్ విశ్వాసినః ప్రతి వర్త్తతే| ");
INSERT INTO santel_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","తేషాం కోపి ప్రభేదో నాస్తి, యతః సర్వ్వఏవ పాపిన ఈశ్వరీయతేజోహీనాశ్చ జాతాః| ");
INSERT INTO santel_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","త ఈశ్వరస్యానుగ్రహాద్ మూల్యం వినా ఖ్రీష్టకృతేన పరిత్రాణేన సపుణ్యీకృతా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","యస్మాత్ స్వశోణితేన విశ్వాసాత్ పాపనాశకో బలీ భవితుం స ఏవ పూర్వ్వమ్ ఈశ్వరేణ నిశ్చితః, ఇత్థమ్ ఈశ్వరీయసహిష్ణుత్వాత్ పురాకృతపాపానాం మార్జ్జనకరణే స్వీయయాథార్థ్యం తేన ప్రకాశ్యతే, ");
INSERT INTO santel_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","వర్త్తమానకాలీయమపి స్వయాథార్థ్యం తేన ప్రకాశ్యతే, అపరం యీశౌ విశ్వాసినం సపుణ్యీకుర్వ్వన్నపి స యాథార్థికస్తిష్ఠతి| ");
INSERT INTO santel_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","తర్హి కుత్రాత్మశ్లాఘా? సా దూరీకృతా; కయా వ్యవస్థయా? కిం క్రియారూపవ్యవస్థయా? ఇత్థం నహి కిన్తు తత్ కేవలవిశ్వాసరూపయా వ్యవస్థయైవ భవతి| ");
INSERT INTO santel_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","అతఏవ వ్యవస్థానురూపాః క్రియా వినా కేవలేన విశ్వాసేన మానవః సపుణ్యీకృతో భవితుం శక్నోతీత్యస్య రాద్ధాన్తం దర్శయామః| ");
INSERT INTO santel_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","స కిం కేవలయిహూదినామ్ ఈశ్వరో భవతి? భిన్నదేశినామ్ ఈశ్వరో న భవతి? భిన్నదేశినామపి భవతి; ");
INSERT INTO santel_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","యస్మాద్ ఏక ఈశ్వరో విశ్వాసాత్ త్వక్ఛేదినో విశ్వాసేనాత్వక్ఛేదినశ్చ సపుణ్యీకరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","తర్హి విశ్వాసేన వయం కిం వ్యవస్థాం లుమ్పామ? ఇత్థం న భవతు వయం వ్యవస్థాం సంస్థాపయామ ఏవ| ");
INSERT INTO santel_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","అస్మాకం పూర్వ్వపురుష ఇబ్రాహీమ్ కాయికక్రియయా కిం లబ్ధవాన్ ఏతదధి కిం వదిష్యామః? ");
INSERT INTO santel_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","స యది నిజక్రియాభ్యః సపుణ్యో భవేత్ తర్హి తస్యాత్మశ్లాఘాం కర్త్తుం పన్థా భవేదితి సత్యం, కిన్త్వీశ్వరస్య సమీపే నహి| ");
INSERT INTO santel_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","శాస్త్రే కిం లిఖతి? ఇబ్రాహీమ్ ఈశ్వరే విశ్వసనాత్ స విశ్వాసస్తస్మై పుణ్యార్థం గణితో బభూవ| ");
INSERT INTO santel_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","కర్మ్మకారిణో యద్ వేతనం తద్ అనుగ్రహస్య ఫలం నహి కిన్తు తేనోపార్జితం మన్తవ్యమ్| ");
INSERT INTO santel_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","కిన్తు యః పాపినం సపుణ్యీకరోతి తస్మిన్ విశ్వాసినః కర్మ్మహీనస్య జనస్య యో విశ్వాసః స పుణ్యార్థం గణ్యో భవతి| ");
INSERT INTO santel_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","అపరం యం క్రియాహీనమ్ ఈశ్వరః సపుణ్యీకరోతి తస్య ధన్యవాదం దాయూద్ వర్ణయామాస, యథా, ");
INSERT INTO santel_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","స ధన్యోఽఘాని మృష్టాని యస్యాగాంస్యావృతాని చ| ");
INSERT INTO santel_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","స చ ధన్యః పరేశేన పాపం యస్య న గణ్యతే| ");
INSERT INTO santel_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ఏష ధన్యవాదస్త్వక్ఛేదినమ్ అత్వక్ఛేదినం వా కం ప్రతి భవతి? ఇబ్రాహీమో విశ్వాసః పుణ్యార్థం గణిత ఇతి వయం వదామః| ");
INSERT INTO santel_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","స విశ్వాసస్తస్య త్వక్ఛేదిత్వావస్థాయాం కిమ్ అత్వక్ఛేదిత్వావస్థాయాం కస్మిన్ సమయే పుణ్యమివ గణితః? త్వక్ఛేదిత్వావస్థాయాం నహి కిన్త్వత్వక్ఛేదిత్వావస్థాయాం| ");
INSERT INTO santel_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","అపరఞ్చ స యత్ సర్వ్వేషామ్ అత్వక్ఛేదినాం విశ్వాసినామ్ ఆదిపురుషో భవేత్, తే చ పుణ్యవత్త్వేన గణ్యేరన్; ");
INSERT INTO santel_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","యే చ లోకాః కేవలం ఛిన్నత్వచో న సన్తో ఽస్మత్పూర్వ్వపురుష ఇబ్రాహీమ్ అఛిన్నత్వక్ సన్ యేన విశ్వాసమార్గేణ గతవాన్ తేనైవ తస్య పాదచిహ్నేన గచ్ఛన్తి తేషాం త్వక్ఛేదినామప్యాదిపురుషో భవేత్ తదర్థమ్ అత్వక్ఛేదినో మానవస్య విశ్వాసాత్ పుణ్యమ్ ఉత్పద్యత ఇతి ప్రమాణస్వరూపం త్వక్ఛేదచిహ్నం స ప్రాప్నోత్| ");
INSERT INTO santel_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ఇబ్రాహీమ్ జగతోఽధికారీ భవిష్యతి యైషా ప్రతిజ్ఞా తం తస్య వంశఞ్చ ప్రతి పూర్వ్వమ్ అక్రియత సా వ్యవస్థామూలికా నహి కిన్తు విశ్వాసజన్యపుణ్యమూలికా| ");
INSERT INTO santel_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","యతో వ్యవస్థావలమ్బినో యద్యధికారిణో భవన్తి తర్హి విశ్వాసో విఫలో జాయతే సా ప్రతిజ్ఞాపి లుప్తైవ| ");
INSERT INTO santel_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","అధికన్తు వ్యవస్థా కోపం జనయతి యతో ఽవిద్యమానాయాం వ్యవస్థాయామ్ ఆజ్ఞాలఙ్ఘనం న సమ్భవతి| ");
INSERT INTO santel_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","అతఏవ సా ప్రతిజ్ఞా యద్ అనుగ్రహస్య ఫలం భవేత్ తదర్థం విశ్వాసమూలికా యతస్తథాత్వే తద్వంశసముదాయం ప్రతి అర్థతో యే వ్యవస్థయా తద్వంశసమ్భవాః కేవలం తాన్ ప్రతి నహి కిన్తు య ఇబ్రాహీమీయవిశ్వాసేన తత్సమ్భవాస్తానపి ప్రతి సా ప్రతిజ్ఞా స్థాస్నుర్భవతి| ");
INSERT INTO santel_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","యో నిర్జీవాన్ సజీవాన్ అవిద్యమానాని వస్తూని చ విద్యమానాని కరోతి ఇబ్రాహీమో విశ్వాసభూమేస్తస్యేశ్వరస్య సాక్షాత్ సోఽస్మాకం సర్వ్వేషామ్ ఆదిపురుష ఆస్తే, యథా లిఖితం విద్యతే, అహం త్వాం బహుజాతీనామ్ ఆదిపురుషం కృత్వా నియుక్తవాన్| ");
INSERT INTO santel_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","త్వదీయస్తాదృశో వంశో జనిష్యతే యదిదం వాక్యం ప్రతిశ్రుతం తదనుసారాద్ ఇబ్రాహీమ్ బహుదేశీయలోకానామ్ ఆదిపురుషో యద్ భవతి తదర్థం సోఽనపేక్షితవ్యమప్యపేక్షమాణో విశ్వాసం కృతవాన్| ");
INSERT INTO santel_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","అపరఞ్చ క్షీణవిశ్వాసో న భూత్వా శతవత్సరవయస్కత్వాత్ స్వశరీరస్య జరాం సారానామ్నః స్వభార్య్యాయా రజోనివృత్తిఞ్చ తృణాయ న మేనే| ");
INSERT INTO santel_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","అపరమ్ అవిశ్వాసాద్ ఈశ్వరస్య ప్రతిజ్ఞావచనే కమపి సంశయం న చకార; ");
INSERT INTO santel_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","కిన్త్వీశ్వరేణ యత్ ప్రతిశ్రుతం తత్ సాధయితుం శక్యత ఇతి నిశ్చితం విజ్ఞాయ దృఢవిశ్వాసః సన్ ఈశ్వరస్య మహిమానం ప్రకాశయాఞ్చకార| ");
INSERT INTO santel_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ఇతి హేతోస్తస్య స విశ్వాసస్తదీయపుణ్యమివ గణయాఞ్చక్రే| ");
INSERT INTO santel_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","పుణ్యమివాగణ్యత తత్ కేవలస్య తస్య నిమిత్తం లిఖితం నహి, అస్మాకం నిమిత్తమపి, ");
INSERT INTO santel_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","యతోఽస్మాకం పాపనాశార్థం సమర్పితోఽస్మాకం పుణ్యప్రాప్త్యర్థఞ్చోత్థాపితోఽభవత్ యోఽస్మాకం ప్రభు ర్యీశుస్తస్యోత్థాపయితరీశ్వరే ");
INSERT INTO santel_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","యది వయం విశ్వసామస్తర్హ్యస్మాకమపి సఏవ విశ్వాసః పుణ్యమివ గణయిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","విశ్వాసేన సపుణ్యీకృతా వయమ్ ఈశ్వరేణ సార్ద్ధం ప్రభుణాస్మాకం యీశుఖ్రీష్టేన మేలనం ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","అపరం వయం యస్మిన్ అనుగ్రహాశ్రయే తిష్ఠామస్తన్మధ్యం విశ్వాసమార్గేణ తేనైవానీతా వయమ్ ఈశ్వరీయవిభవప్రాప్తిప్రత్యాశయా సమానన్దామః| ");
INSERT INTO santel_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","తత్ కేవలం నహి కిన్తు క్లేశభోగేఽప్యానన్దామో యతః క్లేశాाద్ ధైర్య్యం జాయత ఇతి వయం జానీమః, ");
INSERT INTO santel_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ధైర్య్యాచ్చ పరీక్షితత్వం జాయతే, పరీక్షితత్వాత్ ప్రత్యాశా జాయతే, ");
INSERT INTO santel_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ప్రత్యాశాతో వ్రీడితత్వం న జాయతే, యస్మాద్ అస్మభ్యం దత్తేన పవిత్రేణాత్మనాస్మాకమ్ అన్తఃకరణానీశ్వరస్య ప్రేమవారిణా సిక్తాని| ");
INSERT INTO santel_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","అస్మాసు నిరుపాయేషు సత్సు ఖ్రీష్ట ఉపయుక్తే సమయే పాపినాం నిమిత్తం స్వీయాన్ ప్రణాన్ అత్యజత్| ");
INSERT INTO santel_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","హితకారిణో జనస్య కృతే కోపి ప్రణాన్ త్యక్తుం సాహసం కర్త్తుం శక్నోతి, కిన్తు ధార్మ్మికస్య కృతే ప్రాయేణ కోపి ప్రాణాన్ న త్యజతి| ");
INSERT INTO santel_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","కిన్త్వస్మాసు పాపిషు సత్స్వపి నిమిత్తమస్మాకం ఖ్రీష్టః స్వప్రాణాన్ త్యక్తవాన్, తత ఈశ్వరోస్మాన్ ప్రతి నిజం పరమప్రేమాణం దర్శితవాన్| ");
INSERT INTO santel_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","అతఏవ తస్య రక్తపాతేన సపుణ్యీకృతా వయం నితాన్తం తేన కోపాద్ ఉద్ధారిష్యామహే| ");
INSERT INTO santel_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ఫలతో వయం యదా రిపవ ఆస్మ తదేశ్వరస్య పుత్రస్య మరణేన తేన సార్ద్ధం యద్యస్మాకం మేలనం జాతం తర్హి మేలనప్రాప్తాః సన్తోఽవశ్యం తస్య జీవనేన రక్షాం లప్స్యామహే| ");
INSERT INTO santel_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","తత్ కేవలం నహి కిన్తు యేన మేలనమ్ అలభామహి తేనాస్మాకం ప్రభుణా యీశుఖ్రీష్టేన సామ్ప్రతమ్ ఈశ్వరే సమానన్దామశ్చ| ");
INSERT INTO santel_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","తథా సతి, ఏకేన మానుషేణ పాపం పాపేన చ మరణం జగతీం ప్రావిశత్ అపరం సర్వ్వేషాం పాపిత్వాత్ సర్వ్వే మానుషా మృతే ర్నిఘ్నా అభవత్| ");
INSERT INTO santel_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","యతో వ్యవస్థాదానసమయం యావత్ జగతి పాపమ్ ఆసీత్ కిన్తు యత్ర వ్యవస్థా న విద్యతే తత్ర పాపస్యాపి గణనా న విద్యతే| ");
INSERT INTO santel_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","తథాప్యాదమా యాదృశం పాపం కృతం తాదృశం పాపం యై ర్నాకారి ఆదమమ్ ఆరభ్య మూసాం యావత్ తేషామప్యుపరి మృత్యూ రాజత్వమ్ అకరోత్ స ఆదమ్ భావ్యాదమో నిదర్శనమేవాస్తే| ");
INSERT INTO santel_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","కిన్తు పాపకర్మ్మణో యాదృశో భావస్తాదృగ్ దానకర్మ్మణో భావో న భవతి యత ఏకస్య జనస్యాపరాధేన యది బహూనాం మరణమ్ అఘటత తథాపీశ్వరానుగ్రహస్తదనుగ్రహమూలకం దానఞ్చైకేన జనేనార్థాద్ యీశునా ఖ్రీష్టేన బహుషు బాహుల్యాతిబాహుల్యేన ఫలతి| ");
INSERT INTO santel_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","అపరమ్ ఏకస్య జనస్య పాపకర్మ్మ యాదృక్ ఫలయుక్తం దానకర్మ్మ తాదృక్ న భవతి యతో విచారకర్మ్మైకం పాపమ్ ఆరభ్య దణ్డజనకం బభూవ, కిన్తు దానకర్మ్మ బహుపాపాన్యారభ్య పుణ్యజనకం బభూవ| ");
INSERT INTO santel_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","యత ఏకస్య జనస్య పాపకర్మ్మతస్తేనైకేన యది మరణస్య రాజత్వం జాతం తర్హి యే జనా అనుగ్రహస్య బాహుల్యం పుణ్యదానఞ్చ ప్రాప్నువన్తి త ఏకేన జనేన, అర్థాత్ యీశుఖ్రీష్టేన, జీవనే రాజత్వమ్ అవశ్యం కరిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ఏకోఽపరాధో యద్వత్ సర్వ్వమానవానాం దణ్డగామీ మార్గో ఽభవత్ తద్వద్ ఏకం పుణ్యదానం సర్వ్వమానవానాం జీవనయుక్తపుణ్యగామీ మార్గ ఏవ| ");
INSERT INTO santel_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","అపరమ్ ఏకస్య జనస్యాజ్ఞాలఙ్ఘనాద్ యథా బహవో ఽపరాధినో జాతాస్తద్వద్ ఏకస్యాజ్ఞాచరణాద్ బహవః సపుణ్యీకృతా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","అధికన్తు వ్యవస్థాగమనాద్ అపరాధస్య బాహుల్యం జాతం కిన్తు యత్ర పాపస్య బాహుల్యం తత్రైవ తస్మాద్ అనుగ్రహస్య బాహుల్యమ్ అభవత్| ");
INSERT INTO santel_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","తేన మృత్యునా యద్వత్ పాపస్య రాజత్వమ్ అభవత్ తద్వద్ అస్మాకం ప్రభుయీశుఖ్రీష్టద్వారానన్తజీవనదాయిపుణ్యేనానుగ్రహస్య రాజత్వం భవతి| ");
INSERT INTO santel_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ప్రభూతరూపేణ యద్ అనుగ్రహః ప్రకాశతే తదర్థం పాపే తిష్ఠామ ఇతి వాక్యం కిం వయం వదిష్యామః? తన్న భవతు| ");
INSERT INTO santel_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","పాపం ప్రతి మృతా వయం పునస్తస్మిన్ కథమ్ జీవిష్యామః? ");
INSERT INTO santel_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","వయం యావన్తో లోకా యీశుఖ్రీష్టే మజ్జితా అభవామ తావన్త ఏవ తస్య మరణే మజ్జితా ఇతి కిం యూయం న జానీథ? ");
INSERT INTO santel_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","తతో యథా పితుః పరాక్రమేణ శ్మశానాత్ ఖ్రీష్ట ఉత్థాపితస్తథా వయమపి యత్ నూతనజీవిన ఇవాచరామస్తదర్థం మజ్జనేన తేన సార్ద్ధం మృత్యురూపే శ్మశానే సంస్థాపితాః| ");
INSERT INTO santel_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","అపరం వయం యది తేన సంయుక్తాః సన్తః స ఇవ మరణభాగినో జాతాస్తర్హి స ఇవోత్థానభాగినోఽపి భవిష్యామః| ");
INSERT INTO santel_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","వయం యత్ పాపస్య దాసాః పున ర్న భవామస్తదర్థమ్ అస్మాకం పాపరూపశరీరస్య వినాశార్థమ్ అస్మాకం పురాతనపురుషస్తేన సాకం క్రుశేఽహన్యతేతి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","యో హతః స పాపాత్ ముక్త ఏవ| ");
INSERT INTO santel_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","అతఏవ యది వయం ఖ్రీష్టేన సార్ద్ధమ్ అహన్యామహి తర్హి పునరపి తేన సహితా జీవిష్యామ ఇత్యత్రాస్మాకం విశ్వాసో విద్యతే| ");
INSERT INTO santel_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","యతః శ్మశానాద్ ఉత్థాపితః ఖ్రీష్టో పున ర్న మ్రియత ఇతి వయం జానీమః| తస్మిన్ కోప్యధికారో మృత్యో ర్నాస్తి| ");
INSERT INTO santel_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","అపరఞ్చ స యద్ అమ్రియత తేనైకదా పాపమ్ ఉద్దిశ్యామ్రియత, యచ్చ జీవతి తేనేశ్వరమ్ ఉద్దిశ్య జీవతి; ");
INSERT INTO santel_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","తద్వద్ యూయమపి స్వాన్ పాపమ్ ఉద్దిశ్య మృతాన్ అస్మాకం ప్రభుణా యీశుఖ్రీష్టేనేశ్వరమ్ ఉద్దిశ్య జీవన్తో జానీత| ");
INSERT INTO santel_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","అపరఞ్చ కుత్సితాభిలాషాाన్ పూరయితుం యుష్మాకం మర్త్యదేహేషు పాపమ్ ఆధిపత్యం న కరోతు| ");
INSERT INTO santel_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","అపరం స్వం స్వమ్ అఙ్గమ్ అధర్మ్మస్యాస్త్రం కృత్వా పాపసేవాయాం న సమర్పయత, కిన్తు శ్మశానాద్ ఉత్థితానివ స్వాన్ ఈశ్వరే సమర్పయత స్వాన్యఙ్గాని చ ధర్మ్మాస్త్రస్వరూపాణీశ్వరమ్ ఉద్దిశ్య సమర్పయత| ");
INSERT INTO santel_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","యుష్మాకమ్ ఉపరి పాపస్యాధిపత్యం పున ర్న భవిష్యతి, యస్మాద్ యూయం వ్యవస్థాయా అనాయత్తా అనుగ్రహస్య చాయత్తా అభవత| ");
INSERT INTO santel_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","కిన్తు వయం వ్యవస్థాయా అనాయత్తా అనుగ్రహస్య చాయత్తా అభవామ, ఇతి కారణాత్ కిం పాపం కరిష్యామః? తన్న భవతు| ");
INSERT INTO santel_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","యతో మృతిజనకం పాపం పుణ్యజనకం నిదేశాచరణఞ్చైతయోర్ద్వయో ర్యస్మిన్ ఆజ్ఞాపాలనార్థం భృత్యానివ స్వాన్ సమర్పయథ, తస్యైవ భృత్యా భవథ, ఏతత్ కిం యూయం న జానీథ? ");
INSERT INTO santel_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","అపరఞ్చ పూర్వ్వం యూయం పాపస్య భృత్యా ఆస్తేతి సత్యం కిన్తు యస్యాం శిక్షారూపాయాం మూషాయాం నిక్షిప్తా అభవత తస్యా ఆకృతిం మనోభి ర్లబ్ధవన్త ఇతి కారణాద్ ఈశ్వరస్య ధన్యవాదో భవతు| ");
INSERT INTO santel_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ఇత్థం యూయం పాపసేవాతో ముక్తాః సన్తో ధర్మ్మస్య భృత్యా జాతాః| ");
INSERT INTO santel_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","యుష్మాకం శారీరిక్యా దుర్బ్బలతాయా హేతో ర్మానవవద్ అహమ్ ఏతద్ బ్రవీమి; పునః పునరధర్మ్మకరణార్థం యద్వత్ పూర్వ్వం పాపామేధ్యయో ర్భృత్యత్వే నిజాఙ్గాని సమార్పయత తద్వద్ ఇదానీం సాధుకర్మ్మకరణార్థం ధర్మ్మస్య భృత్యత్వే నిజాఙ్గాని సమర్పయత| ");
INSERT INTO santel_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","యదా యూయం పాపస్య భృత్యా ఆస్త తదా ధర్మ్మస్య నాయత్తా ఆస్త| ");
INSERT INTO santel_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","తర్హి యాని కర్మ్మాణి యూయమ్ ఇదానీం లజ్జాజనకాని బుధ్యధ్వే పూర్వ్వం తై ర్యుష్మాకం కో లాభ ఆసీత్? తేషాం కర్మ్మణాం ఫలం మరణమేవ| ");
INSERT INTO santel_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","కిన్తు సామ్ప్రతం యూయం పాపసేవాతో ముక్తాః సన్త ఈశ్వరస్య భృత్యాఽభవత తస్మాద్ యుష్మాకం పవిత్రత్వరూపం లభ్యమ్ అనన్తజీవనరూపఞ్చ ఫలమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","యతః పాపస్య వేతనం మరణం కిన్త్వస్మాకం ప్రభుణా యీశుఖ్రీష్టేనానన్తజీవనమ్ ఈశ్వరదత్తం పారితోషికమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","హే భ్రాతృగణ వ్యవస్థావిదః ప్రతి మమేదం నివేదనం| విధిః కేవలం యావజ్జీవం మానవోపర్య్యధిపతిత్వం కరోతీతి యూయం కిం న జానీథ? ");
INSERT INTO santel_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","యావత్కాలం పతి ర్జీవతి తావత్కాలమ్ ఊఢా భార్య్యా వ్యవస్థయా తస్మిన్ బద్ధా తిష్ఠతి కిన్తు యది పతి ర్మ్రియతే తర్హి సా నారీ పత్యు ర్వ్యవస్థాతో ముచ్యతే| ");
INSERT INTO santel_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ఏతత్కారణాత్ పత్యుర్జీవనకాలే నారీ యద్యన్యం పురుషం వివహతి తర్హి సా వ్యభిచారిణీ భవతి కిన్తు యది స పతి ర్మ్రియతే తర్హి సా తస్యా వ్యవస్థాయా ముక్తా సతీ పురుషాన్తరేణ వ్యూఢాపి వ్యభిచారిణీ న భవతి| ");
INSERT INTO santel_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","హే మమ భ్రాతృగణ, ఈశ్వరనిమిత్తం యదస్మాకం ఫలం జాయతే తదర్థం శ్మశానాద్ ఉత్థాపితేన పురుషేణ సహ యుష్మాకం వివాహో యద్ భవేత్ తదర్థం ఖ్రీష్టస్య శరీరేణ యూయం వ్యవస్థాం ప్రతి మృతవన్తః| ");
INSERT INTO santel_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","యతోఽస్మాకం శారీరికాచరణసమయే మరణనిమిత్తం ఫలమ్ ఉత్పాదయితుం వ్యవస్థయా దూషితః పాపాభిలాషోఽస్మాకమ్ అఙ్గేషు జీవన్ ఆసీత్| ");
INSERT INTO santel_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","కిన్తు తదా యస్యా వ్యవస్థాయా వశే ఆస్మహి సామ్ప్రతం తాం ప్రతి మృతత్వాద్ వయం తస్యా అధీనత్వాత్ ముక్తా ఇతి హేతోరీశ్వరోఽస్మాభిః పురాతనలిఖితానుసారాత్ న సేవితవ్యః కిన్తు నవీనస్వభావేనైవ సేవితవ్యః ");
INSERT INTO santel_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","తర్హి వయం కిం బ్రూమః? వ్యవస్థా కిం పాపజనికా భవతి? నేత్థం భవతు| వ్యవస్థామ్ అవిద్యమానాయాం పాపం కిమ్ ఇత్యహం నావేదం; కిఞ్చ లోభం మా కార్షీరితి చేద్ వ్యవస్థాగ్రన్థే లిఖితం నాభవిష్యత్ తర్హి లోభః కిమ్భూతస్తదహం నాజ్ఞాస్యం| ");
INSERT INTO santel_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","కిన్తు వ్యవస్థయా పాపం ఛిద్రం ప్రాప్యాస్మాకమ్ అన్తః సర్వ్వవిధం కుత్సితాభిలాషమ్ అజనయత్; యతో వ్యవస్థాయామ్ అవిద్యమానాయాం పాపం మృతం| ");
INSERT INTO santel_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","అపరం పూర్వ్వం వ్యవస్థాయామ్ అవిద్యమానాయామ్ అహమ్ అజీవం తతః పరమ్ ఆజ్ఞాయామ్ ఉపస్థితాయామ్ పాపమ్ అజీవత్ తదాహమ్ అమ్రియే| ");
INSERT INTO santel_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ఇత్థం సతి జీవననిమిత్తా యాజ్ఞా సా మమ మృత్యుజనికాభవత్| ");
INSERT INTO santel_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","యతః పాపం ఛిద్రం ప్రాప్య వ్యవస్థితాదేశేన మాం వఞ్చయిత్వా తేన మామ్ అహన్| ");
INSERT INTO santel_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","అతఏవ వ్యవస్థా పవిత్రా, ఆదేశశ్చ పవిత్రో న్యాయ్యో హితకారీ చ భవతి| ");
INSERT INTO santel_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","తర్హి యత్ స్వయం హితకృత్ తత్ కిం మమ మృత్యుజనకమ్ అభవత్? నేత్థం భవతు; కిన్తు పాపం యత్ పాతకమివ ప్రకాశతే తథా నిదేశేన పాపం యదతీవ పాతకమివ ప్రకాశతే తదర్థం హితోపాయేన మమ మరణమ్ అజనయత్| ");
INSERT INTO santel_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","వ్యవస్థాత్మబోధికేతి వయం జానీమః కిన్త్వహం శారీరతాచారీ పాపస్య క్రీతకిఙ్కరో విద్యే| ");
INSERT INTO santel_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","యతో యత్ కర్మ్మ కరోమి తత్ మమ మనోఽభిమతం నహి; అపరం యన్ మమ మనోఽభిమతం తన్న కరోమి కిన్తు యద్ ఋతీయే తత్ కరోమి| ");
INSERT INTO santel_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","తథాత్వే యన్ మమానభిమతం తద్ యది కరోమి తర్హి వ్యవస్థా సూత్తమేతి స్వీకరోమి| ");
INSERT INTO santel_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","అతఏవ సమ్ప్రతి తత్ కర్మ్మ మయా క్రియత ఇతి నహి కిన్తు మమ శరీరస్థేన పాపేనైవ క్రియతే| ");
INSERT INTO santel_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","యతో మయి, అర్థతో మమ శరీరే, కిమప్యుత్తమం న వసతి, ఏతద్ అహం జానామి; మమేచ్ఛుకతాయాం తిష్ఠన్త్యామప్యహమ్ ఉత్తమకర్మ్మసాధనే సమర్థో న భవామి| ");
INSERT INTO santel_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","యతో యాముత్తమాం క్రియాం కర్త్తుమహం వాఞ్ఛామి తాం న కరోమి కిన్తు యత్ కుత్సితం కర్మ్మ కర్త్తుమ్ అనిచ్ఛుకోఽస్మి తదేవ కరోమి| ");
INSERT INTO santel_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","అతఏవ యద్యత్ కర్మ్మ కర్త్తుం మమేచ్ఛా న భవతి తద్ యది కరోమి తర్హి తత్ మయా న క్రియతే, మమాన్తర్వర్త్తినా పాపేనైవ క్రియతే| ");
INSERT INTO santel_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","భద్రం కర్త్తుమ్ ఇచ్ఛుకం మాం యో ఽభద్రం కర్త్తుం ప్రవర్త్తయతి తాదృశం స్వభావమేకం మయి పశ్యామి| ");
INSERT INTO santel_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","అహమ్ ఆన్తరికపురుషేణేశ్వరవ్యవస్థాయాం సన్తుష్ట ఆసే; ");
INSERT INTO santel_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","కిన్తు తద్విపరీతం యుధ్యన్తం తదన్యమేకం స్వభావం మదీయాఙ్గస్థితం ప్రపశ్యామి, స మదీయాఙ్గస్థితపాపస్వభావస్యాయత్తం మాం కర్త్తుం చేష్టతే| ");
INSERT INTO santel_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","హా హా యోఽహం దుర్భాగ్యో మనుజస్తం మామ్ ఏతస్మాన్ మృతాచ్ఛరీరాత్ కో నిస్తారయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","అస్మాకం ప్రభుణా యీశుఖ్రీష్టేన నిస్తారయితారమ్ ఈశ్వరం ధన్యం వదామి| అతఏవ శరీరేణ పాపవ్యవస్థాయా మనసా తు ఈశ్వరవ్యవస్థాయాః సేవనం కరోమి| ");
INSERT INTO santel_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","యే జనాః ఖ్రీష్టం యీశుమ్ ఆశ్రిత్య శారీరికం నాచరన్త ఆత్మికమాచరన్తి తేఽధునా దణ్డార్హా న భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","జీవనదాయకస్యాత్మనో వ్యవస్థా ఖ్రీష్టయీశునా పాపమరణయో ర్వ్యవస్థాతో మామమోచయత్| ");
INSERT INTO santel_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","యస్మాచ్ఛారీరస్య దుర్బ్బలత్వాద్ వ్యవస్థయా యత్ కర్మ్మాసాధ్యమ్ ఈశ్వరో నిజపుత్రం పాపిశరీరరూపం పాపనాశకబలిరూపఞ్చ ప్రేష్య తస్య శరీరే పాపస్య దణ్డం కుర్వ్వన్ తత్కర్మ్మ సాధితవాన్| ");
INSERT INTO santel_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","తతః శారీరికం నాచరిత్వాస్మాభిరాత్మికమ్ ఆచరద్భిర్వ్యవస్థాగ్రన్థే నిర్ద్దిష్టాని పుణ్యకర్మ్మాణి సర్వ్వాణి సాధ్యన్తే| ");
INSERT INTO santel_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","యే శారీరికాచారిణస్తే శారీరికాన్ విషయాన్ భావయన్తి యే చాత్మికాచారిణస్తే ఆత్మనో విషయాన్ భావయన్తి| ");
INSERT INTO santel_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","శారీరికభావస్య ఫలం మృత్యుః కిఞ్చాత్మికభావస్య ఫలే జీవనం శాన్తిశ్చ| ");
INSERT INTO santel_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","యతః శారీరికభావ ఈశ్వరస్య విరుద్ధః శత్రుతాభావ ఏవ స ఈశ్వరస్య వ్యవస్థాయా అధీనో న భవతి భవితుఞ్చ న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ఏతస్మాత్ శారీరికాచారిషు తోష్టుమ్ ఈశ్వరేణ న శక్యం| ");
INSERT INTO santel_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","కిన్త్వీశ్వరస్యాత్మా యది యుష్మాకం మధ్యే వసతి తర్హి యూయం శారీరికాచారిణో న సన్త ఆత్మికాచారిణో భవథః| యస్మిన్ తు ఖ్రీష్టస్యాత్మా న విద్యతే స తత్సమ్భవో నహి| ");
INSERT INTO santel_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","యది ఖ్రీష్టో యుష్మాన్ అధితిష్ఠతి తర్హి పాపమ్ ఉద్దిశ్య శరీరం మృతం కిన్తు పుణ్యముద్దిశ్యాత్మా జీవతి| ");
INSERT INTO santel_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","మృతగణాద్ యీశు ర్యేనోత్థాపితస్తస్యాత్మా యది యుష్మన్మధ్యే వసతి తర్హి మృతగణాత్ ఖ్రీష్టస్య స ఉత్థాపయితా యుష్మన్మధ్యవాసినా స్వకీయాత్మనా యుష్మాకం మృతదేహానపి పున ర్జీవయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","హే భ్రాతృగణ శరీరస్య వయమధమర్ణా న భవామోఽతః శారీరికాచారోఽస్మాభి ర్న కర్త్తవ్యః| ");
INSERT INTO santel_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","యది యూయం శరీరికాచారిణో భవేత తర్హి యుష్మాభి ర్మర్త్తవ్యమేవ కిన్త్వాత్మనా యది శరీరకర్మ్మాణి ఘాతయేత తర్హి జీవిష్యథ| ");
INSERT INTO santel_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","యతో యావన్తో లోకా ఈశ్వరస్యాత్మనాకృష్యన్తే తే సర్వ్వ ఈశ్వరస్య సన్తానా భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","యూయం పునరపి భయజనకం దాస్యభావం న ప్రాప్తాః కిన్తు యేన భావేనేశ్వరం పితః పితరితి ప్రోచ్య సమ్బోధయథ తాదృశం దత్తకపుత్రత్వభావమ్ ప్రాప్నుత| ");
INSERT INTO santel_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","అపరఞ్చ వయమ్ ఈశ్వరస్య సన్తానా ఏతస్మిన్ పవిత్ర ఆత్మా స్వయమ్ అస్మాకమ్ ఆత్మాభిః సార్ద్ధం ప్రమాణం దదాతి| ");
INSERT INTO santel_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","అతఏవ వయం యది సన్తానాస్తర్హ్యధికారిణః, అర్థాద్ ఈశ్వరస్య స్వత్త్వాధికారిణః ఖ్రీష్టేన సహాధికారిణశ్చ భవామః; అపరం తేన సార్ద్ధం యది దుఃఖభాగినో భవామస్తర్హి తస్య విభవస్యాపి భాగినో భవిష్యామః| ");
INSERT INTO santel_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","కిన్త్వస్మాసు యో భావీవిభవః ప్రకాశిష్యతే తస్య సమీపే వర్త్తమానకాలీనం దుఃఖమహం తృణాయ మన్యే| ");
INSERT INTO santel_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","యతః ప్రాణిగణ ఈశ్వరస్య సన్తానానాం విభవప్రాప్తిమ్ ఆకాఙ్క్షన్ నితాన్తమ్ అపేక్షతే| ");
INSERT INTO santel_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","అపరఞ్చ ప్రాణిగణః స్వైరమ్ అలీకతాయా వశీకృతో నాభవత్ ");
INSERT INTO santel_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","కిన్తు ప్రాణిగణోఽపి నశ్వరతాధీనత్వాత్ ముక్తః సన్ ఈశ్వరస్య సన్తానానాం పరమముక్తిం ప్రాప్స్యతీత్యభిప్రాయేణ వశీకర్త్రా వశీచక్రే| ");
INSERT INTO santel_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","అపరఞ్చ ప్రసూయమానావద్ వ్యథితః సన్ ఇదానీం యావత్ కృత్స్నః ప్రాణిగణ ఆర్త్తస్వరం కరోతీతి వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","కేవలః స ఇతి నహి కిన్తు ప్రథమజాతఫలస్వరూపమ్ ఆత్మానం ప్రాప్తా వయమపి దత్తకపుత్రత్వపదప్రాప్తిమ్ అర్థాత్ శరీరస్య ముక్తిం ప్రతీక్షమాణాస్తద్వద్ అన్తరార్త్తరావం కుర్మ్మః| ");
INSERT INTO santel_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","వయం ప్రత్యాశయా త్రాణమ్ అలభామహి కిన్తు ప్రత్యక్షవస్తునో యా ప్రత్యాశా సా ప్రత్యాశా నహి, యతో మనుష్యో యత్ సమీక్షతే తస్య ప్రత్యాశాం కుతః కరిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","యద్ అప్రత్యక్షం తస్య ప్రత్యాశాం యది వయం కుర్వ్వీమహి తర్హి ధైర్య్యమ్ అవలమ్బ్య ప్రతీక్షామహే| ");
INSERT INTO santel_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","తత ఆత్మాపి స్వయమ్ అస్మాకం దుర్బ్బలతాయాః సహాయత్వం కరోతి; యతః కిం ప్రార్థితవ్యం తద్ బోద్ధుం వయం న శక్నుమః, కిన్త్వస్పష్టైరార్త్తరావైరాత్మా స్వయమ్ అస్మన్నిమిత్తం నివేదయతి| ");
INSERT INTO santel_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","అపరమ్ ఈశ్వరాభిమతరూపేణ పవిత్రలోకానాం కృతే నివేదయతి య ఆత్మా తస్యాభిప్రాయోఽన్తర్య్యామినా జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","అపరమ్ ఈశ్వరీయనిరూపణానుసారేణాహూతాః సన్తో యే తస్మిన్ ప్రీయన్తే సర్వ్వాణి మిలిత్వా తేషాం మఙ్గలం సాధయన్తి, ఏతద్ వయం జానీమః| ");
INSERT INTO santel_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","యత ఈశ్వరో బహుభ్రాతృణాం మధ్యే స్వపుత్రం జ్యేష్ఠం కర్త్తుమ్ ఇచ్ఛన్ యాన్ పూర్వ్వం లక్ష్యీకృతవాన్ తాన్ తస్య ప్రతిమూర్త్యాః సాదృశ్యప్రాప్త్యర్థం న్యయుంక్త| ");
INSERT INTO santel_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","అపరఞ్చ తేన యే నియుక్తాస్త ఆహూతా అపి యే చ తేనాహూతాస్తే సపుణ్యీకృతాః, యే చ తేన సపుణ్యీకృతాస్తే విభవయుక్తాః| ");
INSERT INTO santel_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ఇత్యత్ర వయం కిం బ్రూమః? ఈశ్వరో యద్యస్మాకం సపక్షో భవతి తర్హి కో విపక్షోఽస్మాకం? ");
INSERT INTO santel_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ఆత్మపుత్రం న రక్షిత్వా యోఽస్మాకం సర్వ్వేషాం కృతే తం ప్రదత్తవాన్ స కిం తేన సహాస్మభ్యమ్ అన్యాని సర్వ్వాణి న దాస్యతి? ");
INSERT INTO santel_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ఈశ్వరస్యాభిరుచితేషు కేన దోష ఆరోపయిష్యతే? య ఈశ్వరస్తాన్ పుణ్యవత ఇవ గణయతి కిం తేన? ");
INSERT INTO santel_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","అపరం తేభ్యో దణ్డదానాజ్ఞా వా కేన కరిష్యతే? యోఽస్మన్నిమిత్తం ప్రాణాన్ త్యక్తవాన్ కేవలం తన్న కిన్తు మృతగణమధ్యాద్ ఉత్థితవాన్, అపి చేశ్వరస్య దక్షిణే పార్శ్వే తిష్ఠన్ అద్యాప్యస్మాకం నిమిత్తం ప్రార్థత ఏవమ్భూతో యః ఖ్రీష్టః కిం తేన? ");
INSERT INTO santel_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","అస్మాభిః సహ ఖ్రీష్టస్య ప్రేమవిచ్ఛేదం జనయితుం కః శక్నోతి? క్లేశో వ్యసనం వా తాడనా వా దుర్భిక్షం వా వస్త్రహీనత్వం వా ప్రాణసంశయో వా ఖఙ్గో వా కిమేతాని శక్నువన్తి? ");
INSERT INTO santel_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","కిన్తు లిఖితమ్ ఆస్తే, యథా, వయం తవ నిమిత్తం స్మో మృత్యువక్త్రేఽఖిలం దినం| బలిర్దేయో యథా మేషో వయం గణ్యామహే తథా| ");
INSERT INTO santel_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","అపరం యోఽస్మాసు ప్రీయతే తేనైతాసు విపత్సు వయం సమ్యగ్ విజయామహే| ");
INSERT INTO santel_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","యతోఽస్మాకం ప్రభునా యీశుఖ్రీష్టేనేశ్వరస్య యత్ ప్రేమ తస్మాద్ అస్మాకం విచ్ఛేదం జనయితుం మృత్యు ర్జీవనం వా దివ్యదూతా వా బలవన్తో ముఖ్యదూతా వా వర్త్తమానో వా భవిష్యన్ కాలో వా ఉచ్చపదం వా నీచపదం వాపరం కిమపి సృష్టవస్తు ");
INSERT INTO santel_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","వైతేషాం కేనాపి న శక్యమిత్యస్మిన్ దృఢవిశ్వాసో మమాస్తే| ");
INSERT INTO santel_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","అహం కాఞ్చిద్ కల్పితాం కథాం న కథయామి, ఖ్రీష్టస్య సాక్షాత్ సత్యమేవ బ్రవీమి పవిత్రస్యాత్మనః సాక్షాన్ మదీయం మన ఏతత్ సాక్ష్యం దదాతి| ");
INSERT INTO santel_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","మమాన్తరతిశయదుఃఖం నిరన్తరం ఖేదశ్చ ");
INSERT INTO santel_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","తస్మాద్ అహం స్వజాతీయభ్రాతృణాం నిమిత్తాత్ స్వయం ఖ్రీష్టాచ్ఛాపాక్రాన్తో భవితుమ్ ఐచ్ఛమ్| ");
INSERT INTO santel_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","యతస్త ఇస్రాయేలస్య వంశా అపి చ దత్తకపుత్రత్వం తేజో నియమో వ్యవస్థాదానం మన్దిరే భజనం ప్రతిజ్ఞాః పితృపురుషగణశ్చైతేషు సర్వ్వేషు తేషామ్ అధికారోఽస్తి| ");
INSERT INTO santel_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","తత్ కేవలం నహి కిన్తు సర్వ్వాధ్యక్షః సర్వ్వదా సచ్చిదానన్ద ఈశ్వరో యః ఖ్రీష్టః సోఽపి శారీరికసమ్బన్ధేన తేషాం వంశసమ్భవః| ");
INSERT INTO santel_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ఈశ్వరస్య వాక్యం విఫలం జాతమ్ ఇతి నహి యత్కారణాద్ ఇస్రాయేలో వంశే యే జాతాస్తే సర్వ్వే వస్తుత ఇస్రాయేలీయా న భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","అపరమ్ ఇబ్రాహీమో వంశే జాతా అపి సర్వ్వే తస్యైవ సన్తానా న భవన్తి కిన్తు ఇస్హాకో నామ్నా తవ వంశో విఖ్యాతో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","అర్థాత్ శారీరికసంసర్గాత్ జాతాః సన్తానా యావన్తస్తావన్త ఏవేశ్వరస్య సన్తానా న భవన్తి కిన్తు ప్రతిశ్రవణాద్ యే జాయన్తే తఏవేశ్వరవంశో గణ్యతే| ");
INSERT INTO santel_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","యతస్తత్ప్రతిశ్రుతే ర్వాక్యమేతత్, ఏతాదృశే సమయే ఽహం పునరాగమిష్యామి తత్పూర్వ్వం సారాయాః పుత్ర ఏకో జనిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","అపరమపి వదామి స్వమనోఽభిలాషత ఈశ్వరేణ యన్నిరూపితం తత్ కర్మ్మతో నహి కిన్త్వాహ్వయితు ర్జాతమేతద్ యథా సిద్ధ్యతి ");
INSERT INTO santel_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","తదర్థం రిబ్కానామికయా యోషితా జనైకస్మాద్ అర్థాద్ అస్మాకమ్ ఇస్హాకః పూర్వ్వపురుషాద్ గర్భే ధృతే తస్యాః సన్తానయోః ప్రసవాత్ పూర్వ్వం కిఞ్చ తయోః శుభాశుభకర్మ్మణః కరణాత్ పూర్వ్వం ");
INSERT INTO santel_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","తాం ప్రతీదం వాక్యమ్ ఉక్తం, జ్యేష్ఠః కనిష్ఠం సేవిష్యతే, ");
INSERT INTO santel_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","యథా లిఖితమ్ ఆస్తే, తథాప్యేషావి న ప్రీత్వా యాకూబి ప్రీతవాన్ అహం| ");
INSERT INTO santel_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","తర్హి వయం కిం బ్రూమః? ఈశ్వరః కిమ్ అన్యాయకారీ? తథా న భవతు| ");
INSERT INTO santel_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","యతః స స్వయం మూసామ్ అవదత్; అహం యస్మిన్ అనుగ్రహం చికీర్షామి తమేవానుగృహ్లామి, యఞ్చ దయితుమ్ ఇచ్ఛామి తమేవ దయే| ");
INSERT INTO santel_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","అతఏవేచ్ఛతా యతమానేన వా మానవేన తన్న సాధ్యతే దయాకారిణేశ్వరేణైవ సాధ్యతే| ");
INSERT INTO santel_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ఫిరౌణి శాస్త్రే లిఖతి, అహం త్వద్ద్వారా మత్పరాక్రమం దర్శయితుం సర్వ్వపృథివ్యాం నిజనామ ప్రకాశయితుఞ్చ త్వాం స్థాపితవాన్| ");
INSERT INTO santel_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","అతః స యమ్ అనుగ్రహీతుమ్ ఇచ్ఛతి తమేవానుగృహ్లాతి, యఞ్చ నిగ్రహీతుమ్ ఇచ్ఛతి తం నిగృహ్లాతి| ");
INSERT INTO santel_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","యది వదసి తర్హి స దోషం కుతో గృహ్లాతి? తదీయేచ్ఛాయాః ప్రతిబన్ధకత్వం కర్త్తం కస్య సామర్థ్యం విద్యతే? ");
INSERT INTO santel_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","హే ఈశ్వరస్య ప్రతిపక్ష మర్త్య త్వం కః? ఏతాదృశం మాం కుతః సృష్టవాన్? ఇతి కథాం సృష్టవస్తు స్రష్ట్రే కిం కథయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ఏకస్మాన్ మృత్పిణ్డాద్ ఉత్కృష్టాపకృష్టౌ ద్వివిధౌ కలశౌ కర్త్తుం కిం కులాలస్య సామర్థ్యం నాస్తి? ");
INSERT INTO santel_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ఈశ్వరః కోపం ప్రకాశయితుం నిజశక్తిం జ్ఞాపయితుఞ్చేచ్ఛన్ యది వినాశస్య యోగ్యాని క్రోధభాజనాని ప్రతి బహుకాలం దీర్ఘసహిష్ణుతామ్ ఆశ్రయతి; ");
INSERT INTO santel_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","అపరఞ్చ విభవప్రాప్త్యర్థం పూర్వ్వం నియుక్తాన్యనుగ్రహపాత్రాణి ప్రతి నిజవిభవస్య బాహుల్యం ప్రకాశయితుం కేవలయిహూదినాం నహి భిన్నదేశినామపి మధ్యాద్ ");
INSERT INTO santel_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","అస్మానివ తాన్యాహ్వయతి తత్ర తవ కిం? ");
INSERT INTO santel_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","హోశేయగ్రన్థే యథా లిఖితమ్ ఆస్తే, యో లోకో మమ నాసీత్ తం వదిష్యామి మదీయకం| యా జాతి ర్మేఽప్రియా చాసీత్ తాం వదిష్యామ్యహం ప్రియాం| ");
INSERT INTO santel_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","యూయం మదీయలోకా న యత్రేతి వాక్యమౌచ్యత| అమరేశస్య సన్తానా ఇతి ఖ్యాస్యన్తి తత్ర తే| ");
INSERT INTO santel_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ఇస్రాయేలీయలోకేషు యిశాయియోఽపి వాచమేతాం ప్రాచారయత్, ఇస్రాయేలీయవంశానాం యా సంఖ్యా సా తు నిశ్చితం| సముద్రసికతాసంఖ్యాసమానా యది జాయతే| తథాపి కేవలం లోకైరల్పైస్త్రాణం వ్రజిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","యతో న్యాయేన స్వం కర్మ్మ పరేశః సాధయిష్యతి| దేశే సఏవ సంక్షేపాన్నిజం కర్మ్మ కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","యిశాయియోఽపరమపి కథయామాస, సైన్యాధ్యక్షపరేశేన చేత్ కిఞ్చిన్నోదశిష్యత| తదా వయం సిదోమేవాభవిష్యామ వినిశ్చితం| యద్వా వయమ్ అమోరాయా అగమిష్యామ తుల్యతాం| ");
INSERT INTO santel_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","తర్హి వయం కిం వక్ష్యామః? ఇతరదేశీయా లోకా అపి పుణ్యార్థమ్ అయతమానా విశ్వాసేన పుణ్యమ్ అలభన్త; ");
INSERT INTO santel_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","కిన్త్విస్రాయేల్లోకా వ్యవస్థాపాలనేన పుణ్యార్థం యతమానాస్తన్ నాలభన్త| ");
INSERT INTO santel_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","తస్య కిం కారణం? తే విశ్వాసేన నహి కిన్తు వ్యవస్థాయాః క్రియయా చేష్టిత్వా తస్మిన్ స్ఖలనజనకే పాషాణే పాదస్ఖలనం ప్రాప్తాః| ");
INSERT INTO santel_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","లిఖితం యాదృశమ్ ఆస్తే, పశ్య పాదస్ఖలార్థం హి సీయోని ప్రస్తరన్తథా| బాధాకారఞ్చ పాషాణం పరిస్థాపితవానహమ్| విశ్వసిష్యతి యస్తత్ర స జనో న త్రపిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","హే భ్రాతర ఇస్రాయేలీయలోకా యత్ పరిత్రాణం ప్రాప్నువన్తి తదహం మనసాభిలషన్ ఈశ్వరస్య సమీపే ప్రార్థయే| ");
INSERT INTO santel_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","యత ఈశ్వరే తేషాం చేష్టా విద్యత ఇత్యత్రాహం సాక్ష్యస్మి; కిన్తు తేషాం సా చేష్టా సజ్ఞానా నహి, ");
INSERT INTO santel_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","యతస్త ఈశ్వరదత్తం పుణ్యమ్ అవిజ్ఞాయ స్వకృతపుణ్యం స్థాపయితుమ్ చేష్టమానా ఈశ్వరదత్తస్య పుణ్యస్య నిఘ్నత్వం న స్వీకుర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ఖ్రీష్ట ఏకైకవిశ్వాసిజనాయ పుణ్యం దాతుం వ్యవస్థాయాః ఫలస్వరూపో భవతి| ");
INSERT INTO santel_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","వ్యవస్థాపాలనేన యత్ పుణ్యం తత్ మూసా వర్ణయామాస, యథా, యో జనస్తాం పాలయిష్యతి స తద్ద్వారా జీవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","కిన్తు ప్రత్యయేన యత్ పుణ్యం తద్ ఏతాదృశం వాక్యం వదతి, కః స్వర్గమ్ ఆరుహ్య ఖ్రీష్టమ్ అవరోహయిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","కో వా ప్రేతలోకమ్ అవరుహ్య ఖ్రీష్టం మృతగణమధ్యాద్ ఆనేష్యతీతి వాక్ మనసి త్వయా న గదితవ్యా| ");
INSERT INTO santel_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","తర్హి కిం బ్రవీతి? తద్ వాక్యం తవ సమీపస్థమ్ అర్థాత్ తవ వదనే మనసి చాస్తే, తచ్చ వాక్యమ్ అస్మాభిః ప్రచార్య్యమాణం విశ్వాసస్య వాక్యమేవ| ");
INSERT INTO santel_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","వస్తుతః ప్రభుం యీశుం యది వదనేన స్వీకరోషి, తథేశ్వరస్తం శ్మశానాద్ ఉదస్థాపయద్ ఇతి యద్యన్తఃకరణేన విశ్వసిషి తర్హి పరిత్రాణం లప్స్యసే| ");
INSERT INTO santel_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","యస్మాత్ పుణ్యప్రాప్త్యర్థమ్ అన్తఃకరణేన విశ్వసితవ్యం పరిత్రాణార్థఞ్చ వదనేన స్వీకర్త్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","శాస్త్రే యాదృశం లిఖతి విశ్వసిష్యతి యస్తత్ర స జనో న త్రపిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ఇత్యత్ర యిహూదిని తదన్యలోకే చ కోపి విశేషో నాస్తి యస్మాద్ యః సర్వ్వేషామ్ అద్వితీయః ప్రభుః స నిజయాచకాన సర్వ్వాన్ ప్రతి వదాన్యో భవతి| ");
INSERT INTO santel_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","యతః, యః కశ్చిత్ పరమేశస్య నామ్నా హి ప్రార్థయిష్యతే| స ఏవ మనుజో నూనం పరిత్రాతో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","యం యే జనా న ప్రత్యాయన్ తే తముద్దిశ్య కథం ప్రార్థయిష్యన్తే? యే వా యస్యాఖ్యానం కదాపి న శ్రుతవన్తస్తే తం కథం ప్రత్యేష్యన్తి? అపరం యది ప్రచారయితారో న తిష్ఠన్తి తదా కథం తే శ్రోష్యన్తి? ");
INSERT INTO santel_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","యది వా ప్రేరితా న భవన్తి తదా కథం ప్రచారయిష్యన్తి? యాదృశం లిఖితమ్ ఆస్తే, యథా, మాఙ్గలికం సుసంవాదం దదత్యానీయ యే నరాః| ప్రచారయన్తి శాన్తేశ్చ సుసంవాదం జనాస్తు యే| తేషాం చరణపద్మాని కీదృక్ శోభాన్వితాని హి| ");
INSERT INTO santel_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","కిన్తు తే సర్వ్వే తం సుసంవాదం న గృహీతవన్తః| యిశాయియో యథా లిఖితవాన్| అస్మత్ప్రచారితే వాక్యే విశ్వాసమకరోద్ధి కః| ");
INSERT INTO santel_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","అతఏవ శ్రవణాద్ విశ్వాస ఐశ్వరవాక్యప్రచారాత్ శ్రవణఞ్చ భవతి| ");
INSERT INTO santel_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","తర్హ్యహం బ్రవీమి తైః కిం నాశ్రావి? అవశ్యమ్ అశ్రావి, యస్మాత్ తేషాం శబ్దో మహీం వ్యాప్నోద్ వాక్యఞ్చ నిఖిలం జగత్| ");
INSERT INTO santel_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","అపరమపి వదామి, ఇస్రాయేలీయలోకాః కిమ్ ఏతాం కథాం న బుధ్యన్తే? ప్రథమతో మూసా ఇదం వాక్యం ప్రోవాచ, అహముత్తాపయిష్యే తాన్ అగణ్యమానవైరపి| క్లేక్ష్యామి జాతిమ్ ఏతాఞ్చ ప్రోన్మత్తభిన్నజాతిభిః| ");
INSERT INTO santel_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","అపరఞ్చ యిశాయియోఽతిశయాక్షోభేణ కథయామాస, యథా, అధి మాం యైస్తు నాచేష్టి సమ్ప్రాప్తస్తై ర్జనైరహం| అధి మాం యై ర్న సమ్పృష్టం విజ్ఞాతస్తై ర్జనైరహం|| ");
INSERT INTO santel_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","కిన్త్విస్రాయేలీయలోకాన్ అధి కథయాఞ్చకార, యైరాజ్ఞాలఙ్ఘిభి ర్లోకై ర్విరుద్ధం వాక్యముచ్యతే| తాన్ ప్రత్యేవ దినం కృత్స్నం హస్తౌ విస్తారయామ్యహం|| ");
INSERT INTO santel_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ఈశ్వరేణ స్వీకీయలోకా అపసారితా అహం కిమ్ ఈదృశం వాక్యం బ్రవీమి? తన్న భవతు యతోఽహమపి బిన్యామీనగోత్రీయ ఇబ్రాహీమవంశీయ ఇస్రాయేలీయలోకోఽస్మి| ");
INSERT INTO santel_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ఈశ్వరేణ పూర్వ్వం యే ప్రదృష్టాస్తే స్వకీయలోకా అపసారితా ఇతి నహి| అపరమ్ ఏలియోపాఖ్యానే శాస్త్రే యల్లిఖితమ్ ఆస్తే తద్ యూయం కిం న జానీథ? ");
INSERT INTO santel_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","హే పరమేశ్వర లోకాస్త్వదీయాః సర్వ్వా యజ్ఞవేదీరభఞ్జన్ తథా తవ భవిష్యద్వాదినః సర్వ్వాన్ అఘ్నన్ కేవల ఏకోఽహమ్ అవశిష్ట ఆసే తే మమాపి ప్రాణాన్ నాశయితుం చేష్టనతే, ఏతాం కథామ్ ఇస్రాయేలీయలోకానాం విరుద్ధమ్ ఏలియ ఈశ్వరాయ నివేదయామాస| ");
INSERT INTO santel_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","తతస్తం ప్రతీశ్వరస్యోత్తరం కిం జాతం? బాల్నామ్నో దేవస్య సాక్షాత్ యై ర్జానూని న పాతితాని తాదృశాః సప్త సహస్రాణి లోకా అవశేషితా మయా| ");
INSERT INTO santel_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","తద్వద్ ఏతస్మిన్ వర్త్తమానకాలేఽపి అనుగ్రహేణాభిరుచితాస్తేషామ్ అవశిష్టాః కతిపయా లోకాః సన్తి| ");
INSERT INTO santel_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","అతఏవ తద్ యద్యనుగ్రహేణ భవతి తర్హి క్రియయా న భవతి నో చేద్ అనుగ్రహోఽననుగ్రహ ఏవ, యది వా క్రియయా భవతి తర్హ్యనుగ్రహేణ న భవతి నో చేత్ క్రియా క్రియైవ న భవతి| ");
INSERT INTO santel_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","తర్హి కిం? ఇస్రాయేలీయలోకా యద్ అమృగయన్త తన్న ప్రాపుః| కిన్త్వభిరుచితలోకాస్తత్ ప్రాపుస్తదన్యే సర్వ్వ అన్ధీభూతాః| ");
INSERT INTO santel_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","యథా లిఖితమ్ ఆస్తే, ఘోరనిద్రాలుతాభావం దృష్టిహీనే చ లోచనే| కర్ణౌ శ్రుతివిహీనౌ చ ప్రదదౌ తేభ్య ఈశ్వరః|| ");
INSERT INTO santel_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ఏతేస్మిన్ దాయూదపి లిఖితవాన్ యథా, అతో భుక్త్యాసనం తేషామ్ ఉన్మాథవద్ భవిష్యతి| వా వంశయన్త్రవద్ బాధా దణ్డవద్ వా భవిష్యతి|| ");
INSERT INTO santel_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","భవిష్యన్తి తథాన్ధాస్తే నేత్రైః పశ్యన్తి నో యథా| వేపథుః కటిదేశస్య తేషాం నిత్యం భవిష్యతి|| ");
INSERT INTO santel_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","పతనార్థం తే స్ఖలితవన్త ఇతి వాచం కిమహం వదామి? తన్న భవతు కిన్తు తాన్ ఉద్యోగినః కర్త్తుం తేషాం పతనాద్ ఇతరదేశీయలోకైః పరిత్రాణం ప్రాప్తం| ");
INSERT INTO santel_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","తేషాం పతనం యది జగతో లోకానాం లాభజనకమ్ అభవత్ తేషాం హ్రాసోఽపి యది భిన్నదేశినాం లాభజనకోఽభవత్ తర్హి తేషాం వృద్ధిః కతి లాభజనికా భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","అతో హే అన్యదేశినో యుష్మాన్ సమ్బోధ్య కథయామి నిజానాం జ్ఞాతిబన్ధూనాం మనఃసూద్యోగం జనయన్ తేషాం మధ్యే కియతాం లోకానాం యథా పరిత్రాణం సాధయామి ");
INSERT INTO santel_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","తన్నిమిత్తమ్ అన్యదేశినాం నికటే ప్రేరితః సన్ అహం స్వపదస్య మహిమానం ప్రకాశయామి| ");
INSERT INTO santel_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","తేషాం నిగ్రహేణ యదీశ్వరేణ సహ జగతో జనానాం మేలనం జాతం తర్హి తేషామ్ అనుగృహీతత్వం మృతదేహే యథా జీవనలాభస్తద్వత్ కిం న భవిష్యతి? ");
INSERT INTO santel_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","అపరం ప్రథమజాతం ఫలం యది పవిత్రం భవతి తర్హి సర్వ్వమేవ ఫలం పవిత్రం భవిష్యతి; తథా మూలం యది పవిత్రం భవతి తర్హి శాఖా అపి తథైవ భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","కియతీనాం శాఖానాం ఛేదనే కృతే త్వం వన్యజితవృక్షస్య శాఖా భూత్వా యది తచ్ఛాఖానాం స్థానే రోపితా సతి జితవృక్షీయమూలస్య రసం భుంక్షే, ");
INSERT INTO santel_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","తర్హి తాసాం భిన్నశాఖానాం విరుద్ధం మాం గర్వ్వీః; యది గర్వ్వసి తర్హి త్వం మూలం యన్న ధారయసి కిన్తు మూలం త్వాం ధారయతీతి సంస్మర| ");
INSERT INTO santel_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","అపరఞ్చ యది వదసి మాం రోపయితుం తాః శాఖా విభన్నా అభవన్; ");
INSERT INTO santel_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","భద్రమ్, అప్రత్యయకారణాత్ తే విభిన్నా జాతాస్తథా విశ్వాసకారణాత్ త్వం రోపితో జాతస్తస్మాద్ అహఙ్కారమ్ అకృత్వా ససాధ్వసో భవ| ");
INSERT INTO santel_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","యత ఈశ్వరో యది స్వాభావికీః శాఖా న రక్షతి తర్హి సావధానో భవ చేత్ త్వామపి న స్థాపయతి| ");
INSERT INTO santel_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ఇత్యత్రేశ్వరస్య యాదృశీ కృపా తాదృశం భయానకత్వమపి త్వయా దృశ్యతాం; యే పతితాస్తాన్ ప్రతి తస్య భయానకత్వం దృశ్యతాం, త్వఞ్చ యది తత్కృపాశ్రితస్తిష్ఠసి తర్హి త్వాం ప్రతి కృపా ద్రక్ష్యతే; నో చేత్ త్వమపి తద్వత్ ఛిన్నో భవిష్యసి| ");
INSERT INTO santel_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","అపరఞ్చ తే యద్యప్రత్యయే న తిష్ఠన్తి తర్హి పునరపి రోపయిష్యన్తే యస్మాత్ తాన్ పునరపి రోపయితుమ్ ఇశ్వరస్య శక్తిరాస్తే| ");
INSERT INTO santel_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","వన్యజితవృక్షస్య శాఖా సన్ త్వం యది తతశ్ఛిన్నో రీతివ్యత్యయేనోత్తమజితవృక్షే రోेेపితోఽభవస్తర్హి తస్య వృక్షస్య స్వీయా యాః శాఖాస్తాః కిం పునః స్వవృక్షే సంలగితుం న శక్నువన్తి? ");
INSERT INTO santel_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","హే భ్రాతరో యుష్మాకమ్ ఆత్మాభిమానో యన్న జాయతే తదర్థం మమేదృశీ వాఞ్ఛా భవతి యూయం ఏతన్నిగూఢతత్త్వమ్ అజానన్తో యన్న తిష్ఠథ; వస్తుతో యావత్కాలం సమ్పూర్ణరూపేణ భిన్నదేశినాం సంగ్రహో న భవిష్యతి తావత్కాలమ్ అంశత్వేన ఇస్రాయేలీయలోకానామ్ అన్ధతా స్థాస్యతి; ");
INSERT INTO santel_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","పశ్చాత్ తే సర్వ్వే పరిత్రాస్యన్తే; ఏతాదృశం లిఖితమప్యాస్తే, ఆగమిష్యతి సీయోనాద్ ఏకో యస్త్రాణదాయకః| అధర్మ్మం యాకుబో వంశాత్ స తు దూరీకరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","తథా దూరీకరిష్యామి తేషాం పాపాన్యహం యదా| తదా తైరేవ సార్ద్ధం మే నియమోఽయం భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","సుసంవాదాత్ తే యుష్మాకం విపక్షా అభవన్ కిన్త్వభిరుచితత్వాత్ తే పితృలోకానాం కృతే ప్రియపాత్రాణి భవన్తి| ");
INSERT INTO santel_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","యత ఈశ్వరస్య దానాద్ ఆహ్వానాఞ్చ పశ్చాత్తాపో న భవతి| ");
INSERT INTO santel_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","అతఏవ పూర్వ్వమ్ ఈశ్వరేఽవిశ్వాసినః సన్తోఽపి యూయం యద్వత్ సమ్ప్రతి తేషామ్ అవిశ్వాసకారణాద్ ఈశ్వరస్య కృపాపాత్రాణి జాతాస్తద్వద్ ");
INSERT INTO santel_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ఇదానీం తేఽవిశ్వాసినః సన్తి కిన్తు యుష్మాభి ర్లబ్ధకృపాకారణాత్ తైరపి కృపా లప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ఈశ్వరః సర్వ్వాన్ ప్రతి కృపాం ప్రకాశయితుం సర్వ్వాన్ అవిశ్వాసిత్వేన గణయతి| ");
INSERT INTO santel_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","అహో ఈశ్వరస్య జ్ఞానబుద్ధిరూపయో ర్ధనయోః కీదృక్ ప్రాచుర్య్యం| తస్య రాజశాసనస్య తత్త్వం కీదృగ్ అప్రాప్యం| తస్య మార్గాశ్చ కీదృగ్ అనుపలక్ష్యాః| ");
INSERT INTO santel_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","పరమేశ్వరస్య సఙ్కల్పం కో జ్ఞాతవాన్? తస్య మన్త్రీ వా కోఽభవత్? ");
INSERT INTO santel_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","కో వా తస్యోపకారీ భృత్వా తత్కృతే తేన ప్రత్యుపకర్త్తవ్యః? ");
INSERT INTO santel_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","యతో వస్తుమాత్రమేవ తస్మాత్ తేన తస్మై చాభవత్ తదీయో మహిమా సర్వ్వదా ప్రకాశితో భవతు| ఇతి| ");
INSERT INTO santel_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","హే భ్రాతర ఈశ్వరస్య కృపయాహం యుష్మాన్ వినయే యూయం స్వం స్వం శరీరం సజీవం పవిత్రం గ్రాహ్యం బలిమ్ ఈశ్వరముద్దిశ్య సముత్సృజత, ఏషా సేవా యుష్మాకం యోగ్యా| ");
INSERT INTO santel_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","అపరం యూయం సాంసారికా ఇవ మాచరత, కిన్తు స్వం స్వం స్వభావం పరావర్త్య నూతనాచారిణో భవత, తత ఈశ్వరస్య నిదేశః కీదృగ్ ఉత్తమో గ్రహణీయః సమ్పూర్ణశ్చేతి యుష్మాభిరనుభావిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","కశ్చిదపి జనో యోగ్యత్వాదధికం స్వం న మన్యతాం కిన్తు ఈశ్వరో యస్మై ప్రత్యయస్య యత్పరిమాణమ్ అదదాత్ స తదనుసారతో యోగ్యరూపం స్వం మనుతామ్, ఈశ్వరాద్ అనుగ్రహం ప్రాప్తః సన్ యుష్మాకమ్ ఏకైకం జనమ్ ఇత్యాజ్ఞాపయామి| ");
INSERT INTO santel_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","యతో యద్వదస్మాకమ్ ఏకస్మిన్ శరీరే బహూన్యఙ్గాని సన్తి కిన్తు సర్వ్వేషామఙ్గానాం కార్య్యం సమానం నహి; ");
INSERT INTO santel_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","తద్వదస్మాకం బహుత్వేఽపి సర్వ్వే వయం ఖ్రీష్టే ఏకశరీరాః పరస్పరమ్ అఙ్గప్రత్యఙ్గత్వేన భవామః| ");
INSERT INTO santel_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","అస్మాద్ ఈశ్వరానుగ్రహేణ విశేషం విశేషం దానమ్ అస్మాసు ప్రాప్తేషు సత్సు కోపి యది భవిష్యద్వాక్యం వదతి తర్హి ప్రత్యయస్య పరిమాణానుసారతః స తద్ వదతు; ");
INSERT INTO santel_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","యద్వా యది కశ్చిత్ సేవనకారీ భవతి తర్హి స తత్సేవనం కరోతు; అథవా యది కశ్చిద్ అధ్యాపయితా భవతి తర్హి సోఽధ్యాపయతు; ");
INSERT INTO santel_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","తథా య ఉపదేష్టా భవతి స ఉపదిశతు యశ్చ దాతా స సరలతయా దదాతు యస్త్వధిపతిః స యత్నేనాధిపతిత్వం కరోతు యశ్చ దయాలుః స హృష్టమనసా దయతామ్| ");
INSERT INTO santel_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","అపరఞ్చ యుష్మాకం ప్రేమ కాపట్యవర్జితం భవతు యద్ అభద్రం తద్ ఋతీయధ్వం యచ్చ భద్రం తస్మిన్ అనురజ్యధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","అపరం భ్రాతృత్వప్రేమ్నా పరస్పరం ప్రీయధ్వం సమాదరాద్ ఏకోఽపరజనం శ్రేష్ఠం జానీధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","తథా కార్య్యే నిరాలస్యా మనసి చ సోద్యోగాః సన్తః ప్రభుం సేవధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","అపరం ప్రత్యాశాయామ్ ఆనన్దితా దుఃఖసమయే చ ధైర్య్యయుక్తా భవత; ప్రార్థనాయాం సతతం ప్రవర్త్తధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","పవిత్రాణాం దీనతాం దూరీకురుధ్వమ్ అతిథిసేవాయామ్ అనురజ్యధ్వమ్| ");
INSERT INTO santel_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","యే జనా యుష్మాన్ తాడయన్తి తాన్ ఆశిషం వదత శాపమ్ అదత్త్వా దద్ధ్వమాశిషమ్| ");
INSERT INTO santel_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","యే జనా ఆనన్దన్తి తైః సార్ద్ధమ్ ఆనన్దత యే చ రుదన్తి తైః సహ రుదిత| ");
INSERT INTO santel_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","అపరఞ్చ యుష్మాకం మనసాం పరస్పరమ్ ఏకోభావో భవతు; అపరమ్ ఉచ్చపదమ్ అనాకాఙ్క్ష్య నీచలోకైః సహాపి మార్దవమ్ ఆచరత; స్వాన్ జ్ఞానినో న మన్యధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","పరస్మాద్ అపకారం ప్రాప్యాపి పరం నాపకురుత| సర్వ్వేషాం దృష్టితో యత్ కర్మ్మోత్తమం తదేవ కురుత| ");
INSERT INTO santel_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","యది భవితుం శక్యతే తర్హి యథాశక్తి సర్వ్వలోకైః సహ నిర్వ్విరోధేన కాలం యాపయత| ");
INSERT INTO santel_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","హే ప్రియబన్ధవః, కస్మైచిద్ అపకారస్య సముచితం దణ్డం స్వయం న దద్ధ్వం, కిన్త్వీశ్వరీయక్రోధాయ స్థానం దత్త యతో లిఖితమాస్తే పరమేశ్వరః కథయతి, దానం ఫలస్య మత్కర్మ్మ సూచితం ప్రదదామ్యహం| ");
INSERT INTO santel_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ఇతికారణాద్ రిపు ర్యది క్షుధార్త్తస్తే తర్హి తం త్వం ప్రభోజయ| తథా యది తృషార్త్తః స్యాత్ తర్హి తం పరిపాయయ| తేన త్వం మస్తకే తస్య జ్వలదగ్నిం నిధాస్యసి| ");
INSERT INTO santel_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","కుక్రియయా పరాజితా న సన్త ఉత్తమక్రియయా కుక్రియాం పరాజయత| ");
INSERT INTO santel_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","యుష్మాకమ్ ఏకైకజనః శాసనపదస్య నిఘ్నో భవతు యతో యాని శాసనపదాని సన్తి తాని సర్వ్వాణీశ్వరేణ స్థాపితాని; ఈశ్వరం వినా పదస్థాపనం న భవతి| ");
INSERT INTO santel_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ఇతి హేతోః శాసనపదస్య యత్ ప్రాతికూల్యం తద్ ఈశ్వరీయనిరూపణస్య ప్రాతికూల్యమేవ; అపరం యే ప్రాతికూల్యమ్ ఆచరన్తి తే స్వేషాం సముచితం దణ్డం స్వయమేవ ఘటయన్తే| ");
INSERT INTO santel_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","శాస్తా సదాచారిణాం భయప్రదో నహి దురాచారిణామేవ భయప్రదో భవతి; త్వం కిం తస్మాన్ నిర్భయో భవితుమ్ ఇచ్ఛసి? తర్హి సత్కర్మ్మాచర, తస్మాద్ యశో లప్స్యసే, ");
INSERT INTO santel_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","యతస్తవ సదాచరణాయ స ఈశ్వరస్య భృత్యోఽస్తి| కిన్తు యది కుకర్మ్మాచరసి తర్హి త్వం శఙ్కస్వ యతః స నిరర్థకం ఖఙ్గం న ధారయతి; కుకర్మ్మాచారిణం సముచితం దణ్డయితుమ్ స ఈశ్వరస్య దణ్డదభృత్య ఏవ| ");
INSERT INTO santel_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","అతఏవ కేవలదణ్డభయాన్నహి కిన్తు సదసద్బోధాదపి తస్య వశ్యేన భవితవ్యం| ");
INSERT INTO santel_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ఏతస్మాద్ యుష్మాకం రాజకరదానమప్యుచితం యస్మాద్ యే కరం గృహ్లన్తి త ఈశ్వరస్య కిఙ్కరా భూత్వా సతతమ్ ఏతస్మిన్ కర్మ్మణి నివిష్టాస్తిష్ఠన్తి| ");
INSERT INTO santel_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","అస్మాత్ కరగ్రాహిణే కరం దత్త, తథా శుల్కగ్రాహిణే శుల్కం దత్త, అపరం యస్మాద్ భేతవ్యం తస్మాద్ బిభీత, యశ్చ సమాదరణీయస్తం సమాద్రియధ్వమ్; ఇత్థం యస్య యత్ ప్రాప్యం తత్ తస్మై దత్త| ");
INSERT INTO santel_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","యుష్మాకం పరస్పరం ప్రేమ వినా ఽన్యత్ కిమపి దేయమ్ ఋణం న భవతు, యతో యః పరస్మిన్ ప్రేమ కరోతి తేన వ్యవస్థా సిధ్యతి| ");
INSERT INTO santel_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","వస్తుతః పరదారాన్ మా గచ్ఛ, నరహత్యాం మా కార్షీః, చైర్య్యం మా కార్షీః, మిథ్యాసాక్ష్యం మా దేహి, లోభం మా కార్షీః, ఏతాః సర్వ్వా ఆజ్ఞా ఏతాభ్యో భిన్నా యా కాచిద్ ఆజ్ఞాస్తి సాపి స్వసమీపవాసిని స్వవత్ ప్రేమ కుర్వ్విత్యనేన వచనేన వేదితా| ");
INSERT INTO santel_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","యతః ప్రేమ సమీపవాసినోఽశుభం న జనయతి తస్మాత్ ప్రేమ్నా సర్వ్వా వ్యవస్థా పాల్యతే| ");
INSERT INTO santel_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ప్రత్యయీభవనకాలేఽస్మాకం పరిత్రాణస్య సామీప్యాద్ ఇదానీం తస్య సామీప్యమ్ అవ్యవహితం; అతః సమయం వివిచ్యాస్మాభిః సామ్ప్రతమ్ అవశ్యమేవ నిద్రాతో జాగర్త్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","బహుతరా యామినీ గతా ప్రభాతం సన్నిధిం ప్రాప్తం తస్మాత్ తామసీయాః క్రియాః పరిత్యజ్యాస్మాభి ర్వాసరీయా సజ్జా పరిధాతవ్యా| ");
INSERT INTO santel_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","అతో హేతో ర్వయం దివా విహితం సదాచరణమ్ ఆచరిష్యామః| రఙ్గరసో మత్తత్వం లమ్పటత్వం కాముకత్వం వివాద ఈర్ష్యా చైతాని పరిత్యక్ష్యామః| ");
INSERT INTO santel_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","యూయం ప్రభుయీశుఖ్రీష్టరూపం పరిచ్ఛదం పరిధద్ధ్వం సుఖాభిలాషపూరణాయ శారీరికాచరణం మాచరత| ");
INSERT INTO santel_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","యో జనోఽదృఢవిశ్వాసస్తం యుష్మాకం సఙ్గినం కురుత కిన్తు సన్దేహవిచారార్థం నహి| ");
INSERT INTO santel_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","యతో నిషిద్ధం కిమపి ఖాద్యద్రవ్యం నాస్తి, కస్యచిజ్జనస్య ప్రత్యయ ఏతాదృశో విద్యతే కిన్త్వదృఢవిశ్వాసః కశ్చిదపరో జనః కేవలం శాకం భుఙ్క్తం| ");
INSERT INTO santel_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","తర్హి యో జనః సాధారణం ద్రవ్యం భుఙ్క్తే స విశేషద్రవ్యభోక్తారం నావజానీయాత్ తథా విశేషద్రవ్యభోక్తాపి సాధారణద్రవ్యభోక్తారం దోషిణం న కుర్య్యాత్, యస్మాద్ ఈశ్వరస్తమ్ అగృహ్లాత్| ");
INSERT INTO santel_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","హే పరదాసస్య దూషయితస్త్వం కః? నిజప్రభోః సమీపే తేన పదస్థేన పదచ్యుతేన వా భవితవ్యం స చ పదస్థ ఏవ భవిష్యతి యత ఈశ్వరస్తం పదస్థం కర్త్తుం శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","అపరఞ్చ కశ్చిజ్జనో దినాద్ దినం విశేషం మన్యతే కశ్చిత్తుु సర్వ్వాణి దినాని సమానాని మన్యతే, ఏకైకో జనః స్వీయమనసి వివిచ్య నిశ్చినోతు| ");
INSERT INTO santel_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","యో జనః కిఞ్చన దినం విశేషం మన్యతే స ప్రభుభక్త్యా తన్ మన్యతే, యశ్చ జనః కిమపి దినం విశేషం న మన్యతే సోఽపి ప్రభుభక్త్యా తన్న మన్యతే; అపరఞ్చ యః సర్వ్వాణి భక్ష్యద్రవ్యాణి భుఙ్క్తే స ప్రభుభక్తయా తాని భుఙ్క్తే యతః స ఈశ్వరం ధన్యం వక్తి, యశ్చ న భుఙ్క్తే సోఽపి ప్రభుభక్త్యైవ న భుఞ్జాన ఈశ్వరం ధన్యం బ్రూతే| ");
INSERT INTO santel_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","అపరమ్ అస్మాకం కశ్చిత్ నిజనిమిత్తం ప్రాణాన్ ధారయతి నిజనిమిత్తం మ్రియతే వా తన్న; ");
INSERT INTO santel_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","కిన్తు యది వయం ప్రాణాన్ ధారయామస్తర్హి ప్రభునిమిత్తం ధారయామః, యది చ ప్రాణాన్ త్యజామస్తర్హ్యపి ప్రభునిమిత్తం త్యజామః, అతఏవ జీవనే మరణే వా వయం ప్రభోరేవాస్మహే| ");
INSERT INTO santel_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","యతో జీవన్తో మృతాశ్చేత్యుభయేషాం లోకానాం ప్రభుత్వప్రాప్త్యర్థం ఖ్రీష్టో మృత ఉత్థితః పునర్జీవితశ్చ| ");
INSERT INTO santel_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","కిన్తు త్వం నిజం భ్రాతరం కుతో దూషయసి? తథా త్వం నిజం భ్రాతరం కుతస్తుచ్ఛం జానాసి? ఖ్రీష్టస్య విచారసింహాసనస్య సమ్ముఖే సర్వ్వైరస్మాభిరుపస్థాతవ్యం; ");
INSERT INTO santel_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","యాదృశం లిఖితమ్ ఆస్తే, పరేశః శపథం కుర్వ్వన్ వాక్యమేతత్ పురావదత్| సర్వ్వో జనః సమీపే మే జానుపాతం కరిష్యతి| జిహ్వైకైకా తథేశస్య నిఘ్నత్వం స్వీకరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","అతఏవ ఈశ్వరసమీపేఽస్మాకమ్ ఏకైకజనేన నిజా కథా కథయితవ్యా| ");
INSERT INTO santel_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ఇత్థం సతి వయమ్ అద్యారభ్య పరస్పరం న దూషయన్తః స్వభ్రాతు ర్విఘ్నో వ్యాఘాతో వా యన్న జాయేత తాదృశీమీహాం కుర్మ్మహే| ");
INSERT INTO santel_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","కిమపి వస్తు స్వభావతో నాశుచి భవతీత్యహం జానే తథా ప్రభునా యీశుఖ్రీష్టేనాపి నిశ్చితం జానే, కిన్తు యో జనో యద్ ద్రవ్యమ్ అపవిత్రం జానీతే తస్య కృతే తద్ అపవిత్రమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","అతఏవ తవ భక్ష్యద్రవ్యేణ తవ భ్రాతా శోకాన్వితో భవతి తర్హి త్వం భ్రాతరం ప్రతి ప్రేమ్నా నాచరసి| ఖ్రీష్టో యస్య కృతే స్వప్రాణాన్ వ్యయితవాన్ త్వం నిజేన భక్ష్యద్రవ్యేణ తం న నాశయ| ");
INSERT INTO santel_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","అపరం యుష్మాకమ్ ఉత్తమం కర్మ్మ నిన్దితం న భవతు| ");
INSERT INTO santel_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","భక్ష్యం పేయఞ్చేశ్వరరాజ్యస్య సారో నహి, కిన్తు పుణ్యం శాన్తిశ్చ పవిత్రేణాత్మనా జాత ఆనన్దశ్చ| ");
INSERT INTO santel_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ఏతై ర్యో జనః ఖ్రీష్టం సేవతే, స ఏవేశ్వరస్య తుష్టికరో మనుష్యైశ్చ సుఖ్యాతః| ");
INSERT INTO santel_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","అతఏవ యేనాస్మాకం సర్వ్వేషాం పరస్పరమ్ ఐక్యం నిష్ఠా చ జాయతే తదేవాస్మాభి ర్యతితవ్యం| ");
INSERT INTO santel_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","భక్ష్యార్థమ్ ఈశ్వరస్య కర్మ్మణో హానిం మా జనయత; సర్వ్వం వస్తు పవిత్రమితి సత్యం తథాపి యో జనో యద్ భుక్త్వా విఘ్నం లభతే తదర్థం తద్ భద్రం నహి| ");
INSERT INTO santel_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","తవ మాంసభక్షణసురాపానాదిభిః క్రియాభి ర్యది తవ భ్రాతుః పాదస్ఖలనం విఘ్నో వా చాఞ్చల్యం వా జాయతే తర్హి తద్భోజనపానయోస్త్యాగో భద్రః| ");
INSERT INTO santel_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","యది తవ ప్రత్యయస్తిష్ఠతి తర్హీశ్వరస్య గోచరే స్వాన్తరే తం గోపయ; యో జనః స్వమతేన స్వం దోషిణం న కరోతి స ఏవ ధన్యః| ");
INSERT INTO santel_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","కిన్తు యః కశ్చిత్ సంశయ్య భుఙ్క్తేఽర్థాత్ న ప్రతీత్య భుఙ్క్తే, స ఏవావశ్యం దణ్డార్హో భవిష్యతి, యతో యత్ ప్రత్యయజం నహి తదేవ పాపమయం భవతి| ");
INSERT INTO santel_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","బలవద్భిరస్మాభి ర్దుర్బ్బలానాం దౌర్బ్బల్యం సోఢవ్యం న చ స్వేషామ్ ఇష్టాచార ఆచరితవ్యః| ");
INSERT INTO santel_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","అస్మాకమ్ ఏకైకో జనః స్వసమీపవాసినో హితార్థం నిష్ఠార్థఞ్చ తస్యైవేష్టాచారమ్ ఆచరతు| ");
INSERT INTO santel_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","యతః ఖ్రీష్టోఽపి నిజేష్టాచారం నాచరితవాన్, యథా లిఖితమ్ ఆస్తే, త్వన్నిన్దకగణస్యైవ నిన్దాభి ర్నిన్దితోఽస్మ్యహం| ");
INSERT INTO santel_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","అపరఞ్చ వయం యత్ సహిష్ణుతాసాన్త్వనయో ర్జనకేన శాస్త్రేణ ప్రత్యాశాం లభేమహి తన్నిమిత్తం పూర్వ్వకాలే లిఖితాని సర్వ్వవచనాన్యస్మాకమ్ ఉపదేశార్థమేవ లిలిఖిరే| ");
INSERT INTO santel_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","సహిష్ణుతాసాన్త్వనయోరాకరో య ఈశ్వరః స ఏవం కరోతు యత్ ప్రభు ర్యీశుఖ్రీష్ట ఇవ యుష్మాకమ్ ఏకజనోఽన్యజనేన సార్ద్ధం మనస ఐక్యమ్ ఆచరేత్; ");
INSERT INTO santel_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","యూయఞ్చ సర్వ్వ ఏకచిత్తా భూత్వా ముఖైకేనేవాస్మత్ప్రభుయీశుఖ్రీష్టస్య పితురీశ్వరస్య గుణాన్ కీర్త్తయేత| ");
INSERT INTO santel_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","అపరమ్ ఈశ్వరస్య మహిమ్నః ప్రకాశార్థం ఖ్రీష్టో యథా యుష్మాన్ ప్రత్యగృహ్లాత్ తథా యుష్మాకమప్యేకో జనోఽన్యజనం ప్రతిగృహ్లాతు| ");
INSERT INTO santel_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","యథా లిఖితమ్ ఆస్తే, అతోఽహం సమ్ముఖే తిష్ఠన్ భిన్నదేశనివాసినాం| స్తువంస్త్వాం పరిగాస్యామి తవ నామ్ని పరేశ్వర|| ");
INSERT INTO santel_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","తస్య దయాలుత్వాచ్చ భిన్నజాతీయా యద్ ఈశ్వరస్య గుణాన్ కీర్త్తయేయుస్తదర్థం యీశుః ఖ్రీష్టస్త్వక్ఛేదనియమస్య నిఘ్నోఽభవద్ ఇత్యహం వదామి| యథా లిఖితమ్ ఆస్తే, అతోఽహం సమ్ముఖే తిష్ఠన్ భిన్నదేశనివాసినాం| స్తువంస్త్వాం పరిగాస్యామి తవ నామ్ని పరేశ్వర|| ");
INSERT INTO santel_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","అపరమపి లిఖితమ్ ఆస్తే, హే అన్యజాతయో యూయం సమం నన్దత తజ్జనైః| ");
INSERT INTO santel_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","పునశ్చ లిఖితమ్ ఆస్తే, హే సర్వ్వదేశినో యూయం ధన్యం బ్రూత పరేశ్వరం| హే తదీయనరా యూయం కురుధ్వం తత్ప్రశంసనం|| ");
INSERT INTO santel_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","అపర యీశాయియోఽపి లిలేఖ, యీశయస్య తు యత్ మూలం తత్ ప్రకాశిష్యతే తదా| సర్వ్వజాతీయనృణాఞ్చ శాసకః సముదేష్యతి| తత్రాన్యదేశిలోకైశ్చ ప్రత్యాశా ప్రకరిష్యతే|| ");
INSERT INTO santel_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","అతఏవ యూయం పవిత్రస్యాత్మనః ప్రభావాద్ యత్ సమ్పూర్ణాం ప్రత్యాశాం లప్స్యధ్వే తదర్థం తత్ప్రత్యాశాజనక ఈశ్వరః ప్రత్యయేన యుష్మాన్ శాన్త్యానన్దాభ్యాం సమ్పూర్ణాన్ కరోతు| ");
INSERT INTO santel_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","హే భ్రాతరో యూయం సద్భావయుక్తాః సర్వ్వప్రకారేణ జ్ఞానేన చ సమ్పూర్ణాః పరస్పరోపదేశే చ తత్పరా ఇత్యహం నిశ్చితం జానామి, ");
INSERT INTO santel_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","తథాప్యహం యత్ ప్రగల్భతరో భవన్ యుష్మాన్ ప్రబోధయామి తస్యైకం కారణమిదం| ");
INSERT INTO santel_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","భిన్నజాతీయాః పవిత్రేణాత్మనా పావితనైవేద్యరూపా భూత్వా యద్ గ్రాహ్యా భవేయుస్తన్నిమిత్తమహమ్ ఈశ్వరస్య సుసంవాదం ప్రచారయితుం భిన్నజాతీయానాం మధ్యే యీశుఖ్రీష్టస్య సేవకత్వం దానం ఈశ్వరాత్ లబ్ధవానస్మి| ");
INSERT INTO santel_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ఈశ్వరం ప్రతి యీశుఖ్రీష్టేన మమ శ్లాఘాకరణస్య కారణమ్ ఆస్తే| ");
INSERT INTO santel_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","భిన్నదేశిన ఆజ్ఞాగ్రాహిణః కర్త్తుం ఖ్రీష్టో వాక్యేన క్రియయా చ, ఆశ్చర్య్యలక్షణైశ్చిత్రక్రియాభిః పవిత్రస్యాత్మనః ప్రభావేన చ యాని కర్మ్మాణి మయా సాధితవాన్, ");
INSERT INTO santel_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","కేవలం తాన్యేవ వినాన్యస్య కస్యచిత్ కర్మ్మణో వర్ణనాం కర్త్తుం ప్రగల్భో న భవామి| తస్మాత్ ఆ యిరూశాలమ ఇల్లూరికం యావత్ సర్వ్వత్ర ఖ్రీష్టస్య సుసంవాదం ప్రాచారయం| ");
INSERT INTO santel_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","అన్యేన నిచితాయాం భిత్తావహం యన్న నిచినోమి తన్నిమిత్తం యత్ర యత్ర స్థానే ఖ్రీష్టస్య నామ కదాపి కేనాపి న జ్ఞాపితం తత్ర తత్ర సుసంవాదం ప్రచారయితుమ్ అహం యతే| ");
INSERT INTO santel_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","యాదృశం లిఖితమ్ ఆస్తే, యై ర్వార్త్తా తస్య న ప్రాప్తా దర్శనం తైస్తు లప్స్యతే| యైశ్చ నైవ శ్రుతం కిఞ్చిత్ బోద్ధుం శక్ష్యన్తి తే జనాః|| ");
INSERT INTO santel_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","తస్మాద్ యుష్మత్సమీపగమనాద్ అహం ముహుర్ముహు ర్నివారితోఽభవం| ");
INSERT INTO santel_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","కిన్త్విదానీమ్ అత్ర ప్రదేశేషు మయా న గతం స్థానం కిమపి నావశిష్యతే యుష్మత్సమీపం గన్తుం బహువత్సరానారభ్య మామకీనాకాఙ్క్షా చ విద్యత ఇతి హేతోః ");
INSERT INTO santel_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","స్పానియాదేశగమనకాలేఽహం యుష్మన్మధ్యేన గచ్ఛన్ యుష్మాన్ ఆలోకిష్యే, తతః పరం యుష్మత్సమ్భాషణేన తృప్తిం పరిలభ్య తద్దేశగమనార్థం యుష్మాభి ర్విసర్జయిష్యే, ఈదృశీ మదీయా ప్రత్యాశా విద్యతే| ");
INSERT INTO santel_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","కిన్తు సామ్ప్రతం పవిత్రలోకానాం సేవనాయ యిరూశాలమ్నగరం వ్రజామి| ");
INSERT INTO santel_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","యతో యిరూశాలమస్థపవిత్రలోకానాం మధ్యే యే దరిద్రా అర్థవిశ్రాణనేన తానుపకర్త్తుం మాకిదనియాదేశీయా ఆఖాయాదేశీయాశ్చ లోకా ఐచ్ఛన్| ");
INSERT INTO santel_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ఏషా తేషాం సదిచ్ఛా యతస్తే తేషామ్ ఋణినః సన్తి యతో హేతో ర్భిన్నజాతీయా యేషాం పరమార్థస్యాంశినో జాతా ఐహికవిషయే తేషాముపకారస్తైః కర్త్తవ్యః| ");
INSERT INTO santel_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","అతో మయా తత్ కర్మ్మ సాధయిత్వా తస్మిన్ ఫలే తేభ్యః సమర్పితే యుష్మన్మధ్యేన స్పానియాదేశో గమిష్యతే| ");
INSERT INTO santel_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","యుష్మత్సమీపే మమాగమనసమయే ఖ్రీష్టస్య సుసంవాదస్య పూర్ణవరేణ సమ్బలితః సన్ అహమ్ ఆగమిష్యామి ఇతి మయా జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","హే భ్రాతృగణ ప్రభో ర్యీశుఖ్రీష్టస్య నామ్నా పవిత్రస్యాత్మానః ప్రేమ్నా చ వినయేఽహం ");
INSERT INTO santel_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","యిహూదాదేశస్థానామ్ అవిశ్వాసిలోకానాం కరేభ్యో యదహం రక్షాం లభేయ మదీయైతేన సేవనకర్మ్మణా చ యద్ యిరూశాలమస్థాః పవిత్రలోకాస్తుష్యేయుః, ");
INSERT INTO santel_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","తదర్థం యూయం మత్కృత ఈశ్వరాయ ప్రార్థయమాణా యతధ్వం తేనాహమ్ ఈశ్వరేచ్ఛయా సానన్దం యుష్మత్సమీపం గత్వా యుష్మాభిః సహితః ప్రాణాన్ ఆప్యాయితుం పారయిష్యామి| ");
INSERT INTO santel_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","శాన్తిదాయక ఈశ్వరో యుష్మాకం సర్వ్వేషాం సఙ్గీ భూయాత్| ఇతి| ");
INSERT INTO santel_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","కింక్రీయానగరీయధర్మ్మసమాజస్య పరిచారికా యా ఫైబీనామికాస్మాకం ధర్మ్మభగినీ తస్యాః కృతేఽహం యుష్మాన్ నివేదయామి, ");
INSERT INTO santel_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","యూయం తాం ప్రభుమాశ్రితాం విజ్ఞాయ తస్యా ఆతిథ్యం పవిత్రలోకార్హం కురుధ్వం, యుష్మత్తస్తస్యా య ఉపకారో భవితుం శక్నోతి తం కురుధ్వం, యస్మాత్ తయా బహూనాం మమ చోపకారః కృతః| ");
INSERT INTO santel_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","అపరఞ్చ ఖ్రీష్టస్య యీశోః కర్మ్మణి మమ సహకారిణౌ మమ ప్రాణరక్షార్థఞ్చ స్వప్రాణాన్ పణీకృతవన్తౌ యౌ ప్రిష్కిల్లాక్కిలౌ తౌ మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","తాభ్యామ్ ఉపకారాప్తిః కేవలం మయా స్వీకర్త్తవ్యేతి నహి భిన్నదేశీయైః సర్వ్వధర్మ్మసమాజైరపి| ");
INSERT INTO santel_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","అపరఞ్చ తయో ర్గృహే స్థితాన్ ధర్మ్మసమాజలోకాన్ మమ నమస్కారం జ్ఞాపయధ్వం| తద్వత్ ఆశియాదేశే ఖ్రీష్టస్య పక్షే ప్రథమజాతఫలస్వరూపో య ఇపేనితనామా మమ ప్రియబన్ధుస్తమపి మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","అపరం బహుశ్రమేణాస్మాన్ అసేవత యా మరియమ్ తామపి నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","అపరఞ్చ ప్రేరితేషు ఖ్యాతకీర్త్తీ మదగ్రే ఖ్రీష్టాశ్రితౌ మమ స్వజాతీయౌ సహబన్దినౌ చ యావాన్ద్రనీకయూనియౌ తౌ మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","తథా ప్రభౌ మత్ప్రియతమమ్ ఆమ్ప్లియమపి మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","అపరం ఖ్రీష్టసేవాయాం మమ సహకారిణమ్ ఊర్బ్బాణం మమ ప్రియతమం స్తాఖుఞ్చ మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","అపరం ఖ్రీష్టేన పరీక్షితమ్ ఆపిల్లిం మమ నమస్కారం వదత, ఆరిష్టబూలస్య పరిజనాంశ్చ మమ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","అపరం మమ జ్ఞాతిం హేరోదియోనం మమ నమస్కారం వదత, తథా నార్కిసస్య పరివారాణాం మధ్యే యే ప్రభుమాశ్రితాస్తాన్ మమ నమస్కారం వదత| ");
INSERT INTO santel_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","అపరం ప్రభోః సేవాయాం పరిశ్రమకారిణ్యౌ త్రుఫేనాత్రుఫోషే మమ నమస్కారం వదత, తథా ప్రభోః సేవాయామ్ అత్యన్తం పరిశ్రమకారిణీ యా ప్రియా పర్షిస్తాం నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","అపరం ప్రభోరభిరుచితం రూఫం మమ ధర్మ్మమాతా యా తస్య మాతా తామపి నమస్కారం వదత| ");
INSERT INTO santel_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","అపరమ్ అసుంకృతం ఫ్లిగోనం హర్మ్మం పాత్రబం హర్మ్మిమ్ ఏతేషాం సఙ్గిభ్రాతృగణఞ్చ నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","అపరం ఫిలలగో యూలియా నీరియస్తస్య భగిన్యలుమ్పా చైతాన్ ఏతైః సార్ద్ధం యావన్తః పవిత్రలోకా ఆసతే తానపి నమస్కారం జ్ఞాపయధ్వం| ");
INSERT INTO santel_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","యూయం పరస్పరం పవిత్రచుమ్బనేన నమస్కురుధ్వం| ఖ్రీష్టస్య ధర్మ్మసమాజగణో యుష్మాన్ నమస్కురుతే| ");
INSERT INTO santel_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","హే భ్రాతరో యుష్మాన్ వినయేఽహం యుష్మాభి ర్యా శిక్షా లబ్ధా తామ్ అతిక్రమ్య యే విచ్ఛేదాన్ విఘ్నాంశ్చ కుర్వ్వన్తి తాన్ నిశ్చినుత తేషాం సఙ్గం వర్జయత చ| ");
INSERT INTO santel_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","యతస్తాదృశా లోకా అస్మాకం ప్రభో ర్యీశుఖ్రీష్టస్య దాసా ఇతి నహి కిన్తు స్వోదరస్యైవ దాసాః; అపరం ప్రణయవచనై ర్మధురవాక్యైశ్చ సరలలోకానాం మనాంసి మోహయన్తి| ");
INSERT INTO santel_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","యుష్మాకమ్ ఆజ్ఞాగ్రాహిత్వం సర్వ్వత్ర సర్వ్వై ర్జ్ఞాతం తతోఽహం యుష్మాసు సానన్దోఽభవం తథాపి యూయం యత్ సత్జ్ఞానేన జ్ఞానినః కుజ్ఞానేे చాతత్పరా భవేతేతి మమాభిలాషః| ");
INSERT INTO santel_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","అధికన్తు శాన్తిదాయక ఈశ్వరః శైతానమ్ అవిలమ్బం యుష్మాకం పదానామ్ అధో మర్ద్దిష్యతి| అస్మాకం ప్రభు ర్యీశుఖ్రీష్టో యుష్మాసు ప్రసాదం క్రియాత్| ఇతి| ");
INSERT INTO santel_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","మమ సహకారీ తీమథియో మమ జ్ఞాతయో లూకియో యాసోన్ సోసిపాత్రశ్చేమే యుష్మాన్ నమస్కుర్వ్వన్తే| ");
INSERT INTO santel_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","అపరమ్ ఏతత్పత్రలేఖకస్తర్త్తియనామాహమపి ప్రభో ర్నామ్నా యుష్మాన్ నమస్కరోమి| ");
INSERT INTO santel_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","తథా కృత్స్నధర్మ్మసమాజస్య మమ చాతిథ్యకారీ గాయో యుష్మాన్ నమస్కరోతి| అపరమ్ ఏతన్నగరస్య ధనరక్షక ఇరాస్తః క్కార్త్తనామకశ్చైకో భ్రాతా తావపి యుష్మాన్ నమస్కురుతః| ");
INSERT INTO santel_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","అస్మాకం ప్రభు ర్యీశుఖ్రీష్టా యుష్మాసు సర్వ్వేషు ప్రసాదం క్రియాత్| ఇతి| ");
INSERT INTO santel_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","పూర్వ్వకాలికయుగేషు ప్రచ్ఛన్నా యా మన్త్రణాధునా ప్రకాశితా భూత్వా భవిష్యద్వాదిలిఖితగ్రన్థగణస్య ప్రమాణాద్ విశ్వాసేన గ్రహణార్థం సదాతనస్యేశ్వరస్యాజ్ఞయా సర్వ్వదేశీయలోకాన్ జ్ఞాప్యతే, ");
INSERT INTO santel_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","తస్యా మన్త్రణాయా జ్ఞానం లబ్ధ్వా మయా యః సుసంవాదో యీశుఖ్రీష్టమధి ప్రచార్య్యతే, తదనుసారాద్ యుష్మాన్ ధర్మ్మే సుస్థిరాన్ కర్త్తుం సమర్థో యోఽద్వితీయః ");
INSERT INTO santel_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","సర్వ్వజ్ఞ ఈశ్వరస్తస్య ధన్యవాదో యీశుఖ్రీష్టేన సన్తతం భూయాత్| ఇతి|");
INSERT INTO santel_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","యావన్తః పవిత్రా లోకాః స్వేషామ్ అస్మాకఞ్చ వసతిస్థానేష్వస్మాకం ప్రభో ర్యీశోః ఖ్రీష్టస్య నామ్నా ప్రార్థయన్తే తైః సహాహూతానాం ఖ్రీష్టేన యీశునా పవిత్రీకృతానాం లోకానాం య ఈశ్వరీయధర్మ్మసమాజః కరిన్థనగరే విద్యతే ");
INSERT INTO santel_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","తం ప్రతీశ్వరస్యేచ్ఛయాహూతో యీశుఖ్రీష్టస్య ప్రేరితః పౌలః సోస్థినినామా భ్రాతా చ పత్రం లిఖతి| ");
INSERT INTO santel_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","అస్మాకం పిత్రేశ్వరేణ ప్రభునా యీశుఖ్రీష్టేన చ ప్రసాదః శాన్తిశ్చ యుష్మభ్యం దీయతాం| ");
INSERT INTO santel_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ఈశ్వరో యీశుఖ్రీష్టేన యుష్మాన్ ప్రతి ప్రసాదం ప్రకాశితవాన్, తస్మాదహం యుష్మన్నిమిత్తం సర్వ్వదా మదీయేశ్వరం ధన్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ఖ్రీష్టసమ్బన్ధీయం సాక్ష్యం యుష్మాకం మధ్యే యేన ప్రకారేణ సప్రమాణమ్ అభవత్ ");
INSERT INTO santel_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","తేన యూయం ఖ్రీష్టాత్ సర్వ్వవిధవక్తృతాజ్ఞానాదీని సర్వ్వధనాని లబ్ధవన్తః| ");
INSERT INTO santel_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","తతోఽస్మత్ప్రభో ర్యీశుఖ్రీష్టస్య పునరాగమనం ప్రతీక్షమాణానాం యుష్మాకం కస్యాపి వరస్యాభావో న భవతి| ");
INSERT INTO santel_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","అపరమ్ అస్మాకం ప్రభో ర్యీశుఖ్రీష్టస్య దివసే యూయం యన్నిర్ద్దోషా భవేత తదర్థం సఏవ యావదన్తం యుష్మాన్ సుస్థిరాన్ కరిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","య ఈశ్వరః స్వపుత్రస్యాస్మత్ప్రభో ర్యీశుఖ్రీష్టస్యాంశినః కర్త్తుం యుష్మాన్ ఆహూతవాన్ స విశ్వసనీయః| ");
INSERT INTO santel_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","హే భ్రాతరః, అస్మాకం ప్రభుయీశుఖ్రీష్టస్య నామ్నా యుష్మాన్ వినయేఽహం సర్వ్వై ర్యుష్మాభిరేకరూపాణి వాక్యాని కథ్యన్తాం యుష్మన్మధ్యే భిన్నసఙ్ఘాతా న భవన్తు మనోవిచారయోరైక్యేన యుష్మాకం సిద్ధత్వం భవతు| ");
INSERT INTO santel_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","హే మమ భ్రాతరో యుష్మన్మధ్యే వివాదా జాతా ఇతి వార్త్తామహం క్లోయ్యాః పరిజనై ర్జ్ఞాపితః| ");
INSERT INTO santel_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","మమాభిప్రేతమిదం యుష్మాకం కశ్చిత్ కశ్చిద్ వదతి పౌలస్య శిష్యోఽహమ్ ఆపల్లోః శిష్యోఽహం కైఫాః శిష్యోఽహం ఖ్రీష్టస్య శిష్యోఽహమితి చ| ");
INSERT INTO santel_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ఖ్రీష్టస్య కిం విభేదః కృతః? పౌలః కిం యుష్మత్కృతే క్రుశే హతః? పౌలస్య నామ్నా వా యూయం కిం మజ్జితాః? ");
INSERT INTO santel_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","క్రిష్పగాయౌ వినా యుష్మాకం మధ్యేఽన్యః కోఽపి మయా న మజ్జిత ఇతి హేతోరహమ్ ఈశ్వరం ధన్యం వదామి| ");
INSERT INTO santel_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ఏతేన మమ నామ్నా మానవా మయా మజ్జితా ఇతి వక్తుం కేనాపి న శక్యతే| ");
INSERT INTO santel_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","అపరం స్తిఫానస్య పరిజనా మయా మజ్జితాస్తదన్యః కశ్చిద్ యన్మయా మజ్జితస్తదహం న వేద్మి| ");
INSERT INTO santel_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ఖ్రీష్టేనాహం మజ్జనార్థం న ప్రేరితః కిన్తు సుసంవాదస్య ప్రచారార్థమేవ; సోఽపి వాక్పటుతయా మయా న ప్రచారితవ్యః, యతస్తథా ప్రచారితే ఖ్రీష్టస్య క్రుశే మృత్యుః ఫలహీనో భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","యతో హేతో ర్యే వినశ్యన్తి తే తాం క్రుశస్య వార్త్తాం ప్రలాపమివ మన్యన్తే కిఞ్చ పరిత్రాణం లభమానేష్వస్మాసు సా ఈశ్వరీయశక్తిస్వరూపా| ");
INSERT INTO santel_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","తస్మాదిత్థం లిఖితమాస్తే, జ్ఞానవతాన్తు యత్ జ్ఞానం తన్మయా నాశయిష్యతే| విలోపయిష్యతే తద్వద్ బుద్ధి ర్బద్ధిమతాం మయా|| ");
INSERT INTO santel_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","జ్ఞానీ కుత్ర? శాస్త్రీ వా కుత్ర? ఇహలోకస్య విచారతత్పరో వా కుత్ర? ఇహలోకస్య జ్ఞానం కిమీశ్వరేణ మోహీకృతం నహి? ");
INSERT INTO santel_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ఈశ్వరస్య జ్ఞానాద్ ఇహలోకస్య మానవాః స్వజ్ఞానేనేశ్వరస్య తత్త్వబోధం న ప్రాప్తవన్తస్తస్మాద్ ఈశ్వరః ప్రచారరూపిణా ప్రలాపేన విశ్వాసినః పరిత్రాతుం రోచితవాన్| ");
INSERT INTO santel_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","యిహూదీయలోకా లక్షణాని దిదృక్షన్తి భిన్నదేశీయలోకాస్తు విద్యాం మృగయన్తే, ");
INSERT INTO santel_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","వయఞ్చ క్రుశే హతం ఖ్రీష్టం ప్రచారయామః| తస్య ప్రచారో యిహూదీయై ర్విఘ్న ఇవ భిన్నదేశీయైశ్చ ప్రలాప ఇవ మన్యతే, ");
INSERT INTO santel_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","కిన్తు యిహూదీయానాం భిన్నదేశీయానాఞ్చ మధ్యే యే ఆహూతాస్తేషు స ఖ్రీష్ట ఈశ్వరీయశక్తిరివేశ్వరీయజ్ఞానమివ చ ప్రకాశతే| ");
INSERT INTO santel_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","యత ఈశ్వరే యః ప్రలాప ఆరోప్యతే స మానవాతిరిక్తం జ్ఞానమేవ యచ్చ దౌర్బ్బల్యమ్ ఈశ్వర ఆరోప్యతే తత్ మానవాతిరిక్తం బలమేవ| ");
INSERT INTO santel_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","హే భ్రాతరః, ఆహూతయుష్మద్గణో యష్మాభిరాలోక్యతాం తన్మధ్యే సాంసారికజ్ఞానేన జ్ఞానవన్తః పరాక్రమిణో వా కులీనా వా బహవో న విద్యన్తే| ");
INSERT INTO santel_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","యత ఈశ్వరో జ్ఞానవతస్త్రపయితుం మూర్ఖలోకాన్ రోచితవాన్ బలాని చ త్రపయితుమ్ ఈశ్వరో దుర్బ్బలాన్ రోచితవాన్| ");
INSERT INTO santel_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","తథా వర్త్తమానలోకాన్ సంస్థితిభ్రష్టాన్ కర్త్తుమ్ ఈశ్వరో జగతోఽపకృష్టాన్ హేయాన్ అవర్త్తమానాంశ్చాభిరోచితవాన్| ");
INSERT INTO santel_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","తత ఈశ్వరస్య సాక్షాత్ కేనాప్యాత్మశ్లాఘా న కర్త్తవ్యా| ");
INSERT INTO santel_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","యూయఞ్చ తస్మాత్ ఖ్రీష్టే యీశౌ సంస్థితిం ప్రాప్తవన్తః స ఈశ్వరాద్ యుష్మాకం జ్ఞానం పుణ్యం పవిత్రత్వం ముక్తిశ్చ జాతా| ");
INSERT INTO santel_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","అతఏవ యద్వద్ లిఖితమాస్తే తద్వత్, యః కశ్చిత్ శ్లాఘమానః స్యాత్ శ్లాఘతాం ప్రభునా స హి| ");
INSERT INTO santel_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","హే భ్రాతరో యుష్మత్సమీపే మమాగమనకాలేఽహం వక్తృతాయా విద్యాయా వా నైపుణ్యేనేశ్వరస్య సాక్ష్యం ప్రచారితవాన్ తన్నహి; ");
INSERT INTO santel_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","యతో యీశుఖ్రీష్టం తస్య క్రుశే హతత్వఞ్చ వినా నాన్యత్ కిమపి యుష్మన్మధ్యే జ్ఞాపయితుం విహితం బుద్ధవాన్| ");
INSERT INTO santel_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","అపరఞ్చాతీవ దౌర్బ్బల్యభీతికమ్పయుక్తో యుష్మాభిః సార్ద్ధమాసం| ");
INSERT INTO santel_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","అపరం యుష్మాకం విశ్వాసో యత్ మానుషికజ్ఞానస్య ఫలం న భవేత్ కిన్త్వీశ్వరీయశక్తేః ఫలం భవేత్, ");
INSERT INTO santel_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","తదర్థం మమ వక్తృతా మదీయప్రచారశ్చ మానుషికజ్ఞానస్య మధురవాక్యసమ్బలితౌ నాస్తాం కిన్త్వాత్మనః శక్తేశ్చ ప్రమాణయుక్తావాస్తాం| ");
INSERT INTO santel_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","వయం జ్ఞానం భాషామహే తచ్చ సిద్ధలోకై ర్జ్ఞానమివ మన్యతే, తదిహలోకస్య జ్ఞానం నహి, ఇహలోకస్య నశ్వరాణామ్ అధిపతీనాం వా జ్ఞానం నహి; ");
INSERT INTO santel_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","కిన్తు కాలావస్థాయాః పూర్వ్వస్మాద్ యత్ జ్ఞానమ్ అస్మాకం విభవార్థమ్ ఈశ్వరేణ నిశ్చిత్య ప్రచ్ఛన్నం తన్నిగూఢమ్ ఈశ్వరీయజ్ఞానం ప్రభాషామహే| ");
INSERT INTO santel_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ఇహలోకస్యాధిపతీనాం కేనాపి తత్ జ్ఞానం న లబ్ధం, లబ్ధే సతి తే ప్రభావవిశిష్టం ప్రభుం క్రుశే నాహనిష్యన్| ");
INSERT INTO santel_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","తద్వల్లిఖితమాస్తే, నేత్రేణ క్కాపి నో దృష్టం కర్ణేనాపి చ న శ్రుతం| మనోమధ్యే తు కస్యాపి న ప్రవిష్టం కదాపి యత్| ఈశ్వరే ప్రీయమాణానాం కృతే తత్ తేన సఞ్చితం| ");
INSERT INTO santel_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","అపరమీశ్వరః స్వాత్మనా తదస్మాకం సాక్షాత్ ప్రాకాశయత్; యత ఆత్మా సర్వ్వమేవానుసన్ధత్తే తేన చేశ్వరస్య మర్మ్మతత్త్వమపి బుధ్యతే| ");
INSERT INTO santel_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","మనుజస్యాన్తఃస్థమాత్మానం వినా కేన మనుజేన తస్య మనుజస్య తత్త్వం బుధ్యతే? తద్వదీశ్వరస్యాత్మానం వినా కేనాపీశ్వరస్య తత్త్వం న బుధ్యతే| ");
INSERT INTO santel_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","వయఞ్చేహలోకస్యాత్మానం లబ్ధవన్తస్తన్నహి కిన్త్వీశ్వరస్యైవాత్మానం లబ్ధవన్తః, తతో హేతోరీశ్వరేణ స్వప్రసాదాద్ అస్మభ్యం యద్ యద్ దత్తం తత్సర్వ్వమ్ అస్మాభి ర్జ్ఞాతుం శక్యతే| ");
INSERT INTO santel_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","తచ్చాస్మాభి ర్మానుషికజ్ఞానస్య వాక్యాని శిక్షిత్వా కథ్యత ఇతి నహి కిన్త్వాత్మతో వాక్యాని శిక్షిత్వాత్మికై ర్వాక్యైరాత్మికం భావం ప్రకాశయద్భిః కథ్యతే| ");
INSERT INTO santel_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ప్రాణీ మనుష్య ఈశ్వరీయాత్మనః శిక్షాం న గృహ్లాతి యత ఆత్మికవిచారేణ సా విచార్య్యేతి హేతోః స తాం ప్రలాపమివ మన్యతే బోద్ధుఞ్చ న శక్నోతి| ");
INSERT INTO santel_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ఆత్మికో మానవః సర్వ్వాణి విచారయతి కిన్తు స్వయం కేనాపి న విచార్య్యతే| ");
INSERT INTO santel_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","యత ఈశ్వరస్య మనో జ్ఞాత్వా తముపదేష్టుం కః శక్నోతి? కిన్తు ఖ్రీష్టస్య మనోఽస్మాభి ర్లబ్ధం| ");
INSERT INTO santel_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","హే భ్రాతరః, అహమాత్మికైరివ యుష్మాభిః సమం సమ్భాషితుం నాశక్నవం కిన్తు శారీరికాచారిభిః ఖ్రీష్టధర్మ్మే శిశుతుల్యైశ్చ జనైరివ యుష్మాభిః సహ సమభాషే| ");
INSERT INTO santel_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","యుష్మాన్ కఠినభక్ష్యం న భోజయన్ దుగ్ధమ్ అపాయయం యతో యూయం భక్ష్యం గ్రహీతుం తదా నాశక్నుత ఇదానీమపి న శక్నుథ, యతో హేతోరధునాపి శారీరికాచారిణ ఆధ్వే| ");
INSERT INTO santel_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","యుష్మన్మధ్యే మాత్సర్య్యవివాదభేదా భవన్తి తతః కిం శారీరికాచారిణో నాధ్వే మానుషికమార్గేణ చ న చరథ? ");
INSERT INTO santel_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","పౌలస్యాహమిత్యాపల్లోరహమితి వా యద్వాక్యం యుష్మాకం కైశ్చిత్ కైశ్చిత్ కథ్యతే తస్మాద్ యూయం శారీరికాచారిణ న భవథ? ");
INSERT INTO santel_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","పౌలః కః? ఆపల్లో ర్వా కః? తౌ పరిచారకమాత్రౌ తయోరేకైకస్మై చ ప్రభు ర్యాదృక్ ఫలమదదాత్ తద్వత్ తయోర్ద్వారా యూయం విశ్వాసినో జాతాః| ");
INSERT INTO santel_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","అహం రోపితవాన్ ఆపల్లోశ్చ నిషిక్తవాన్ ఈశ్వరశ్చావర్ద్ధయత్| ");
INSERT INTO santel_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","అతో రోపయితృసేక్తారావసారౌ వర్ద్ధయితేశ్వర ఏవ సారః| ");
INSERT INTO santel_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","రోపయితృసేక్తారౌ చ సమౌ తయోరేకైకశ్చ స్వశ్రమయోగ్యం స్వవేతనం లప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ఆవామీశ్వరేణ సహ కర్మ్మకారిణౌ, ఈశ్వరస్య యత్ క్షేత్రమ్ ఈశ్వరస్య యా నిర్మ్మితిః సా యూయమేవ| ");
INSERT INTO santel_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ఈశ్వరస్య ప్రసాదాత్ మయా యత్ పదం లబ్ధం తస్మాత్ జ్ఞానినా గృహకారిణేవ మయా భిత్తిమూలం స్థాపితం తదుపరి చాన్యేన నిచీయతే| కిన్తు యేన యన్నిచీయతే తత్ తేన వివిచ్యతాం| ");
INSERT INTO santel_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","యతో యీశుఖ్రీష్టరూపం యద్ భిత్తిమూలం స్థాపితం తదన్యత్ కిమపి భిత్తిమూలం స్థాపయితుం కేనాపి న శక్యతే| ");
INSERT INTO santel_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ఏతద్భిత్తిమూలస్యోపరి యది కేచిత్ స్వర్ణరూప్యమణికాష్ఠతృణనలాన్ నిచిన్వన్తి, ");
INSERT INTO santel_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","తర్హ్యేకైకస్య కర్మ్మ ప్రకాశిష్యతే యతః స దివసస్తత్ ప్రకాశయిష్యతి| యతో హతోస్తన దివసేన వహ్నిమయేనోదేతవ్యం తత ఏకైకస్య కర్మ్మ కీదృశమేతస్య పరీక్షా బహ్నినా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","యస్య నిచయనరూపం కర్మ్మ స్థాస్ను భవిష్యతి స వేతనం లప్స్యతే| ");
INSERT INTO santel_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","యస్య చ కర్మ్మ ధక్ష్యతే తస్య క్షతి ర్భవిష్యతి కిన్తు వహ్నే ర్నిర్గతజన ఇవ స స్వయం పరిత్రాణం ప్రాప్స్యతి| ");
INSERT INTO santel_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","యూయమ్ ఈశ్వరస్య మన్దిరం యుష్మన్మధ్యే చేశ్వరస్యాత్మా నివసతీతి కిం న జానీథ? ");
INSERT INTO santel_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ఈశ్వరస్య మన్దిరం యేన వినాశ్యతే సోఽపీశ్వరేణ వినాశయిష్యతే యత ఈశ్వరస్య మన్దిరం పవిత్రమేవ యూయం తు తన్మన్దిరమ్ ఆధ్వే| ");
INSERT INTO santel_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","కోపి స్వం న వఞ్చయతాం| యుష్మాకం కశ్చన చేదిహలోకస్య జ్ఞానేన జ్ఞానవానహమితి బుధ్యతే తర్హి స యత్ జ్ఞానీ భవేత్ తదర్థం మూఢో భవతు| ");
INSERT INTO santel_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","యస్మాదిహలోకస్య జ్ఞానమ్ ఈశ్వరస్య సాక్షాత్ మూఢత్వమేవ| ఏతస్మిన్ లిఖితమప్యాస్తే, తీక్ష్ణా యా జ్ఞానినాం బుద్ధిస్తయా తాన్ ధరతీశ్వరః| ");
INSERT INTO santel_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","పునశ్చ| జ్ఞానినాం కల్పనా వేత్తి పరమేశో నిరర్థకాః| ");
INSERT INTO santel_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","అతఏవ కోఽపి మనుజైరాత్మానం న శ్లాఘతాం యతః సర్వ్వాణి యుష్మాకమేవ, ");
INSERT INTO santel_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","పౌల వా ఆపల్లో ర్వా కైఫా వా జగద్ వా జీవనం వా మరణం వా వర్త్తమానం వా భవిష్యద్వా సర్వ్వాణ్యేవ యుష్మాకం, ");
INSERT INTO santel_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","యూయఞ్చ ఖ్రీష్టస్య, ఖ్రీష్టశ్చేశ్వరస్య| ");
INSERT INTO santel_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","లోకా అస్మాన్ ఖ్రీష్టస్య పరిచారకాన్ ఈశ్వరస్య నిగూఠవాక్యధనస్యాధ్యక్షాంశ్చ మన్యన్తాం| ");
INSERT INTO santel_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","కిఞ్చ ధనాధ్యక్షేణ విశ్వసనీయేన భవితవ్యమేతదేవ లోకై ర్యాచ్యతే| ");
INSERT INTO santel_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","అతో విచారయద్భి ర్యుష్మాభిరన్యైః కైశ్చిన్ మనుజై ర్వా మమ పరీక్షణం మయాతీవ లఘు మన్యతే ఽహమప్యాత్మానం న విచారయామి| ");
INSERT INTO santel_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","మయా కిమప్యపరాద్ధమిత్యహం న వేద్మి కిన్త్వేతేన మమ నిరపరాధత్వం న నిశ్చీయతే ప్రభురేవ మమ విచారయితాస్తి| ");
INSERT INTO santel_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","అత ఉపయుక్తసమయాత్ పూర్వ్వమ్ అర్థతః ప్రభోరాగమనాత్ పూర్వ్వం యుష్మాభి ర్విచారో న క్రియతాం| ప్రభురాగత్య తిమిరేణ ప్రచ్ఛన్నాని సర్వ్వాణి దీపయిష్యతి మనసాం మన్త్రణాశ్చ ప్రకాశయిష్యతి తస్మిన్ సమయ ఈశ్వరాద్ ఏకైకస్య ప్రశంసా భవిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","హే భ్రాతరః సర్వ్వాణ్యేతాని మయాత్మానమ్ ఆపల్లవఞ్చోద్దిశ్య కథితాని తస్యైతత్ కారణం యుయం యథా శాస్త్రీయవిధిమతిక్రమ్య మానవమ్ అతీవ నాదరిష్యధ్బ ఈత్థఞ్చైకేన వైపరీత్యాద్ అపరేణ న శ్లాఘిష్యధ్బ ఏతాదృశీం శిక్షామావయోర్దృష్టాన్తాత్ లప్స్యధ్వే| ");
INSERT INTO santel_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","అపరాత్ కస్త్వాం విశేషయతి? తుభ్యం యన్న దత్త తాదృశం కిం ధారయసి? అదత్తేనేవ దత్తేన వస్తునా కుతః శ్లాఘసే? ");
INSERT INTO santel_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ఇదానీమేవ యూయం కిం తృప్తా లబ్ధధనా వా? అస్మాస్వవిద్యమానేషు యూయం కిం రాజత్వపదం ప్రాప్తాః? యుష్మాకం రాజత్వం మయాభిలషితం యతస్తేన యుష్మాభిః సహ వయమపి రాజ్యాంశినో భవిష్యామః| ");
INSERT INTO santel_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ప్రేరితా వయం శేషా హన్తవ్యాశ్చేవేశ్వరేణ నిదర్శితాః| యతో వయం సర్వ్వలోకానామ్ అర్థతః స్వర్గీయదూతానాం మానవానాఞ్చ కౌతుకాస్పదాని జాతాః| ");
INSERT INTO santel_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ఖ్రీష్టస్య కృతే వయం మూఢాః కిన్తు యూయం ఖ్రీష్టేన జ్ఞానినః, వయం దుర్బ్బలా యూయఞ్చ సబలాః, యూయం సమ్మానితా వయఞ్చాపమానితాః| ");
INSERT INTO santel_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","వయమద్యాపి క్షుధార్త్తాస్తృష్ణార్త్తా వస్త్రహీనాస్తాడితా ఆశ్రమరహితాశ్చ సన్తః ");
INSERT INTO santel_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","కర్మ్మణి స్వకరాన్ వ్యాపారయన్తశ్చ దుఃఖైః కాలం యాపయామః| గర్హితైరస్మాభిరాశీః కథ్యతే దూరీకృతైః సహ్యతే నిన్దితైః ప్రసాద్యతే| ");
INSERT INTO santel_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","వయమద్యాపి జగతః సమ్మార్జనీయోగ్యా అవకరా ఇవ సర్వ్వై ర్మన్యామహే| ");
INSERT INTO santel_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","యుష్మాన్ త్రపయితుమహమేతాని లిఖామీతి నహి కిన్తు ప్రియాత్మజానివ యుష్మాన్ ప్రబోధయామి| ");
INSERT INTO santel_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","యతః ఖ్రీష్టధర్మ్మే యద్యపి యుష్మాకం దశసహస్రాణి వినేతారో భవన్తి తథాపి బహవో జనకా న భవన్తి యతోఽహమేవ సుసంవాదేన యీశుఖ్రీష్టే యుష్మాన్ అజనయం| ");
INSERT INTO santel_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","అతో యుష్మాన్ వినయేఽహం యూయం మదనుగామినో భవత| ");
INSERT INTO santel_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ఇత్యర్థం సర్వ్వేషు ధర్మ్మసమాజేషు సర్వ్వత్ర ఖ్రీష్టధర్మ్మయోగ్యా యే విధయో మయోపదిశ్యన్తే తాన్ యో యుష్మాన్ స్మారయిష్యత్యేవమ్భూతం ప్రభోః కృతే ప్రియం విశ్వాసినఞ్చ మదీయతనయం తీమథియం యుష్మాకం సమీపం ప్రేషితవానహం| ");
INSERT INTO santel_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","అపరమహం యుష్మాకం సమీపం న గమిష్యామీతి బుద్ధ్వా యుష్మాకం కియన్తో లోకా గర్వ్వన్తి| ");
INSERT INTO santel_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","కిన్తు యది ప్రభేరిచ్ఛా భవతి తర్హ్యహమవిలమ్బం యుష్మత్సమీపముపస్థాయ తేషాం దర్పధ్మాతానాం లోకానాం వాచం జ్ఞాస్యామీతి నహి సామర్థ్యమేవ జ్ఞాస్యామి| ");
INSERT INTO santel_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","యస్మాదీశ్వరస్య రాజత్వం వాగ్యుక్తం నహి కిన్తు సామర్థ్యయుక్తం| ");
INSERT INTO santel_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","యుష్మాకం కా వాఞ్ఛా? యుష్మత్సమీపే మయా కిం దణ్డపాణినా గన్తవ్యముత ప్రేమనమ్రతాత్మయుక్తేన వా? ");
INSERT INTO santel_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","అపరం యుష్మాకం మధ్యే వ్యభిచారో విద్యతే స చ వ్యభిచారస్తాదృశో యద్ దేవపూజకానాం మధ్యేఽపి తత్తుల్యో న విద్యతే ఫలతో యుష్మాకమేకో జనో విమాతృగమనం కృరుత ఇతి వార్త్తా సర్వ్వత్ర వ్యాప్తా| ");
INSERT INTO santel_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","తథాచ యూయం దర్పధ్మాతా ఆధ్బే, తత్ కర్మ్మ యేన కృతం స యథా యుష్మన్మధ్యాద్ దూరీక్రియతే తథా శోకో యుష్మాభి ర్న క్రియతే కిమ్ ఏతత్? ");
INSERT INTO santel_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","అవిద్యమానే మదీయశరీరే మమాత్మా యుష్మన్మధ్యే విద్యతే అతోఽహం విద్యమాన ఇవ తత్కర్మ్మకారిణో విచారం నిశ్చితవాన్, ");
INSERT INTO santel_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","అస్మత్ప్రభో ర్యీశుఖ్రీష్టస్య నామ్నా యుష్మాకం మదీయాత్మనశ్చ మిలనే జాతే ఽస్మత్ప్రభో ర్యీశుఖ్రీష్టస్య శక్తేః సాహాయ్యేన ");
INSERT INTO santel_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","స నరః శరీరనాశార్థమస్మాభిః శయతానో హస్తే సమర్పయితవ్యస్తతోఽస్మాకం ప్రభో ర్యీశో ర్దివసే తస్యాత్మా రక్షాం గన్తుం శక్ష్యతి| ");
INSERT INTO santel_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","యుష్మాకం దర్పో న భద్రాయ యూయం కిమేతన్న జానీథ, యథా, వికారః కృత్స్నశక్తూనాం స్వల్పకిణ్వేన జాయతే| ");
INSERT INTO santel_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","యూయం యత్ నవీనశక్తుస్వరూపా భవేత తదర్థం పురాతనం కిణ్వమ్ అవమార్జ్జత యతో యుష్మాభిః కిణ్వశూన్యై ర్భవితవ్యం| అపరమ్ అస్మాకం నిస్తారోత్సవీయమేషశావకో యః ఖ్రీష్టః సోఽస్మదర్థం బలీకృతో ఽభవత్| ");
INSERT INTO santel_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","అతః పురాతనకిణ్వేనార్థతో దుష్టతాజిఘాంసారూపేణ కిణ్వేన తన్నహి కిన్తు సారల్యసత్యత్వరూపయా కిణ్వశూన్యతయాస్మాభిరుత్సవః కర్త్తవ్యః| ");
INSERT INTO santel_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","వ్యాభిచారిణాం సంసర్గో యుష్మాభి ర్విహాతవ్య ఇతి మయా పత్రే లిఖితం| ");
INSERT INTO santel_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","కిన్త్వైహికలోకానాం మధ్యే యే వ్యభిచారిణో లోభిన ఉపద్రావిణో దేవపూజకా వా తేషాం సంసర్గః సర్వ్వథా విహాతవ్య ఇతి నహి, విహాతవ్యే సతి యుష్మాభి ర్జగతో నిర్గన్తవ్యమేవ| ");
INSERT INTO santel_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","కిన్తు భ్రాతృత్వేన విఖ్యాతః కశ్చిజ్జనో యది వ్యభిచారీ లోభీ దేవపూజకో నిన్దకో మద్యప ఉపద్రావీ వా భవేత్ తర్హి తాదృశేన మానవేన సహ భోజనపానేఽపి యుష్మాభి ర్న కర్త్తవ్యే ఇత్యధునా మయా లిఖితం| ");
INSERT INTO santel_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","సమాజబహిఃస్థితానాం లోకానాం విచారకరణే మమ కోఽధికారః? కిన్తు తదన్తర్గతానాం విచారణం యుష్మాభిః కిం న కర్త్తవ్యం భవేత్? ");
INSERT INTO santel_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","బహిఃస్థానాం తు విచార ఈశ్వరేణ కారిష్యతే| అతో యుష్మాభిః స పాతకీ స్వమధ్యాద్ బహిష్క్రియతాం| ");
INSERT INTO santel_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","యుష్మాకమేకస్య జనస్యాపరేణ సహ వివాదే జాతే స పవిత్రలోకై ర్విచారమకారయన్ కిమ్ అధార్మ్మికలోకై ర్విచారయితుం ప్రోత్సహతే? ");
INSERT INTO santel_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","జగతోఽపి విచారణం పవిత్రలోకైః కారిష్యత ఏతద్ యూయం కిం న జానీథ? అతో జగద్ యది యుష్మాభి ర్విచారయితవ్యం తర్హి క్షుద్రతమవిచారేషు యూయం కిమసమర్థాః? ");
INSERT INTO santel_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","దూతా అప్యస్మాభి ర్విచారయిష్యన్త ఇతి కిం న జానీథ? అత ఐహికవిషయాః కిమ్ అస్మాభి ర్న విచారయితవ్యా భవేయుః? ");
INSERT INTO santel_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ఐహికవిషయస్య విచారే యుష్మాభిః కర్త్తవ్యే యే లోకాః సమితౌ క్షుద్రతమాస్త ఏవ నియుజ్యన్తాం| ");
INSERT INTO santel_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","అహం యుష్మాన్ త్రపయితుమిచ్ఛన్ వదామి యృష్మన్మధ్యే కిమేకోఽపి మనుష్యస్తాదృగ్ బుద్ధిమాన్నహి యో భ్రాతృవివాదవిచారణే సమర్థః స్యాత్? ");
INSERT INTO santel_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","కిఞ్చైకో భ్రాతా భ్రాత్రాన్యేన కిమవిశ్వాసినాం విచారకాణాం సాక్షాద్ వివదతే? యష్మన్మధ్యే వివాదా విద్యన్త ఏతదపి యుష్మాకం దోషః| ");
INSERT INTO santel_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","యూయం కుతోఽన్యాయసహనం క్షతిసహనం వా శ్రేయో న మన్యధ్వే? ");
INSERT INTO santel_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","కిన్తు యూయమపి భ్రాతృనేవ ప్రత్యన్యాయం క్షతిఞ్చ కురుథ కిమేతత్? ");
INSERT INTO santel_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ఈశ్వరస్య రాజ్యేఽన్యాయకారిణాం లోకానామధికారో నాస్త్యేతద్ యూయం కిం న జానీథ? మా వఞ్చ్యధ్వం, యే వ్యభిచారిణో దేవార్చ్చినః పారదారికాః స్త్రీవదాచారిణః పుంమైథునకారిణస్తస్కరా ");
INSERT INTO santel_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","లోభినో మద్యపా నిన్దకా ఉపద్రావిణో వా త ఈశ్వరస్య రాజ్యభాగినో న భవిష్యన్తి| ");
INSERT INTO santel_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","యూయఞ్చైవంవిధా లోకా ఆస్త కిన్తు ప్రభో ర్యీశో ర్నామ్నాస్మదీశ్వరస్యాత్మనా చ యూయం ప్రక్షాలితాః పావితాః సపుణ్యీకృతాశ్చ| ");
INSERT INTO santel_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","మదర్థం సర్వ్వం ద్రవ్యమ్ అప్రతిషిద్ధం కిన్తు న సర్వ్వం హితజనకం| మదర్థం సర్వ్వమప్రతిషిద్ధం తథాప్యహం కస్యాపి ద్రవ్యస్య వశీకృతో న భవిష్యామి| ");
INSERT INTO santel_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ఉదరాయ భక్ష్యాణి భక్ష్యేభ్యశ్చోదరం, కిన్తు భక్ష్యోదరే ఈశ్వరేణ నాశయిష్యేతే; అపరం దేహో న వ్యభిచారాయ కిన్తు ప్రభవే ప్రభుశ్చ దేహాయ| ");
INSERT INTO santel_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","యశ్చేశ్వరః ప్రభుముత్థాపితవాన్ స స్వశక్త్యాస్మానప్యుత్థాపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","యుష్మాకం యాని శరీరాణి తాని ఖ్రీష్టస్యాఙ్గానీతి కిం యూయం న జానీథ? అతః ఖ్రీష్టస్య యాన్యఙ్గాని తాని మయాపహృత్య వేశ్యాయా అఙ్గాని కిం కారిష్యన్తే? తన్న భవతు| ");
INSERT INTO santel_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","యః కశ్చిద్ వేశ్యాయామ్ ఆసజ్యతే స తయా సహైకదేహో భవతి కిం యూయమేతన్న జానీథ? యతో లిఖితమాస్తే, యథా, తౌ ద్వౌ జనావేకాఙ్గౌ భవిష్యతః| ");
INSERT INTO santel_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","మానవా యాన్యన్యాని కలుషాణి కుర్వ్వతే తాని వపు ర్న సమావిశన్తి కిన్తు వ్యభిచారిణా స్వవిగ్రహస్య విరుద్ధం కల్మషం క్రియతే| ");
INSERT INTO santel_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","మానవా యాన్యన్యాని కలుషాణి కుర్వ్వతే తాని వపు ర్న సమావిశన్తి కిన్తు వ్యభిచారిణా స్వవిగ్రహస్య విరుద్ధం కల్మషం క్రియతే| ");
INSERT INTO santel_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","యుష్మాకం యాని వపూంసి తాని యుష్మదన్తఃస్థితస్యేశ్వరాల్లబ్ధస్య పవిత్రస్యాత్మనో మన్దిరాణి యూయఞ్చ స్వేషాం స్వామినో నాధ్వే కిమేతద్ యుష్మాభి ర్న జ్ఞాయతే? ");
INSERT INTO santel_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","యూయం మూల్యేన క్రీతా అతో వపుర్మనోభ్యామ్ ఈశ్వరో యుష్మాభిః పూజ్యతాం యత ఈశ్వర ఏవ తయోః స్వామీ| ");
INSERT INTO santel_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","అపరఞ్చ యుష్మాభి ర్మాం ప్రతి యత్ పత్రమలేఖి తస్యోత్తరమేతత్, యోషితోఽస్పర్శనం మనుజస్య వరం; ");
INSERT INTO santel_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","కిన్తు వ్యభిచారభయాద్ ఏకైకస్య పుంసః స్వకీయభార్య్యా భవతు తద్వద్ ఏకైకస్యా యోషితో ఽపి స్వకీయభర్త్తా భవతు| ");
INSERT INTO santel_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","భార్య్యాయై భర్త్రా యద్యద్ వితరణీయం తద్ వితీర్య్యతాం తద్వద్ భర్త్రేఽపి భార్య్యయా వితరణీయం వితీర్య్యతాం| ");
INSERT INTO santel_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","భార్య్యాయాః స్వదేహే స్వత్వం నాస్తి భర్త్తురేవ, తద్వద్ భర్త్తురపి స్వదేహే స్వత్వం నాస్తి భార్య్యాయా ఏవ| ");
INSERT INTO santel_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ఉపోషణప్రార్థనయోః సేవనార్థమ్ ఏకమన్త్రణానాం యుష్మాకం కియత్కాలం యావద్ యా పృథక్స్థితి ర్భవతి తదన్యో విచ్ఛేదో యుష్మన్మధ్యే న భవతు, తతః పరమ్ ఇన్ద్రియాణామ్ అధైర్య్యాత్ శయతాన్ యద్ యుష్మాన్ పరీక్షాం న నయేత్ తదర్థం పునరేకత్ర మిలత| ");
INSERT INTO santel_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ఏతద్ ఆదేశతో నహి కిన్త్వనుజ్ఞాత ఏవ మయా కథ్యతే, ");
INSERT INTO santel_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","యతో మమావస్థేవ సర్వ్వమానవానామవస్థా భవత్వితి మమ వాఞ్ఛా కిన్త్వీశ్వరాద్ ఏకేనైకో వరోఽన్యేన చాన్యో వర ఇత్థమేకైకేన స్వకీయవరో లబ్ధః| ");
INSERT INTO santel_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","అపరమ్ అకృతవివాహాన్ విధవాశ్చ ప్రతి మమైతన్నివేదనం మమేవ తేషామవస్థితి ర్భద్రా; ");
INSERT INTO santel_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","కిఞ్చ యది తైరిన్ద్రియాణి నియన్తుం న శక్యన్తే తర్హి వివాహః క్రియతాం యతః కామదహనాద్ వ్యూఢత్వం భద్రం| ");
INSERT INTO santel_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","యే చ కృతవివాహాస్తే మయా నహి ప్రభునైవైతద్ ఆజ్ఞాప్యన్తే| ");
INSERT INTO santel_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","భార్య్యా భర్త్తృతః పృథక్ న భవతు| యది వా పృథగ్భూతా స్యాత్ తర్హి నిర్వివాహా తిష్ఠతు స్వీయపతినా వా సన్దధాతు భర్త్తాపి భార్య్యాం న త్యజతు| ");
INSERT INTO santel_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ఇతరాన్ జనాన్ ప్రతి ప్రభు ర్న బ్రవీతి కిన్త్వహం బ్రవీమి; కస్యచిద్ భ్రాతుర్యోషిద్ అవిశ్వాసినీ సత్యపి యది తేన సహవాసే తుష్యతి తర్హి సా తేన న త్యజ్యతాం| ");
INSERT INTO santel_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","తద్వత్ కస్యాశ్చిద్ యోషితః పతిరవిశ్వాసీ సన్నపి యది తయా సహవాసే తుష్యతి తర్హి స తయా న త్యజ్యతాం| ");
INSERT INTO santel_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","యతోఽవిశ్వాసీ భర్త్తా భార్య్యయా పవిత్రీభూతః, తద్వదవిశ్వాసినీ భార్య్యా భర్త్రా పవిత్రీభూతా; నోచేద్ యుష్మాకమపత్యాన్యశుచీన్యభవిష్యన్ కిన్త్వధునా తాని పవిత్రాణి సన్తి| ");
INSERT INTO santel_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","అవిశ్వాసీ జనో యది వా పృథగ్ భవతి తర్హి పృథగ్ భవతు; ఏతేన భ్రాతా భగినీ వా న నిబధ్యతే తథాపి వయమీశ్వరేణ శాన్తయే సమాహూతాః| ");
INSERT INTO santel_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","హే నారి తవ భర్త్తుః పరిత్రాణం త్వత్తో భవిష్యతి న వేతి త్వయా కిం జ్ఞాయతే? హే నర తవ జాయాయాః పరిత్రాణం త్వత్తేा భవిష్యతి న వేతి త్వయా కిం జ్ఞాయతే? ");
INSERT INTO santel_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ఏకైకో జనః పరమేశ్వరాల్లబ్ధం యద్ భజతే యస్యాఞ్చావస్థాయామ్ ఈశ్వరేణాహ్వాయి తదనుసారేణైవాచరతు తదహం సర్వ్వసమాజస్థాన్ ఆదిశామి| ");
INSERT INTO santel_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ఛిన్నత్వగ్ భృత్వా య ఆహూతః స ప్రకృష్టత్వక్ న భవతు, తద్వద్ అఛిన్నత్వగ్ భూత్వా య ఆహూతః స ఛిన్నత్వక్ న భవతు| ");
INSERT INTO santel_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","త్వక్ఛేదః సారో నహి తద్వదత్వక్ఛేదోఽపి సారో నహి కిన్త్వీశ్వరస్యాజ్ఞానాం పాలనమేవ| ");
INSERT INTO santel_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","యో జనో యస్యామవస్థాయామాహ్వాయి స తస్యామేవావతిష్ఠతాం| ");
INSERT INTO santel_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","దాసః సన్ త్వం కిమాహూతోఽసి? తన్మా చిన్తయ, తథాచ యది స్వతన్త్రో భవితుం శక్నుయాస్తర్హి తదేవ వృణు| ");
INSERT INTO santel_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","యతః ప్రభునాహూతో యో దాసః స ప్రభో ర్మోచితజనః| తద్వద్ తేనాహూతః స్వతన్త్రో జనోఽపి ఖ్రీష్టస్య దాస ఏవ| ");
INSERT INTO santel_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","యూయం మూల్యేన క్రీతా అతో హేతో ర్మానవానాం దాసా మా భవత| ");
INSERT INTO santel_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","హే భ్రాతరో యస్యామవస్థాయాం యస్యాహ్వానమభవత్ తయా స ఈశ్వరస్య సాక్షాత్ తిష్ఠతు| ");
INSERT INTO santel_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","అపరమ్ అకృతవివాహాన్ జనాన్ ప్రతి ప్రభోః కోఽప్యాదేశో మయా న లబ్ధః కిన్తు ప్రభోరనుకమ్పయా విశ్వాస్యో భూతోఽహం యద్ భద్రం మన్యే తద్ వదామి| ");
INSERT INTO santel_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","వర్త్తమానాత్ క్లేశసమయాత్ మనుష్యస్యానూఢత్వం భద్రమితి మయా బుధ్యతే| ");
INSERT INTO santel_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","త్వం కిం యోషితి నిబద్ధోఽసి తర్హి మోచనం ప్రాప్తుం మా యతస్వ| కిం వా యోషితో ముక్తోఽసి? తర్హి జాయాం మా గవేషయ| ");
INSERT INTO santel_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","వివాహం కుర్వ్వతా త్వయా కిమపి నాపారాధ్యతే తద్వద్ వ్యూహ్యమానయా యువత్యాపి కిమపి నాపరాధ్యతే తథాచ తాదృశౌ ద్వౌ జనౌ శారీరికం క్లేశం లప్స్యేతే కిన్తు యుష్మాన్ ప్రతి మమ కరుణా విద్యతే| ");
INSERT INTO santel_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","హే భ్రాతరోఽహమిదం బ్రవీమి, ఇతః పరం సమయోఽతీవ సంక్షిప్తః, ");
INSERT INTO santel_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","అతః కృతదారైరకృతదారైరివ రుదద్భిశ్చారుదద్భిరివ సానన్దైశ్చ నిరానన్దైరివ క్రేతృభిశ్చాభాగిభిరివాచరితవ్యం ");
INSERT INTO santel_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","యే చ సంసారే చరన్తి తై ర్నాతిచరితవ్యం యత ఇహలేाకస్య కౌతుకో విచలతి| ");
INSERT INTO santel_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","కిన్తు యూయం యన్నిశ్చిన్తా భవేతేతి మమ వాఞ్ఛా| అకృతవివాహో జనో యథా ప్రభుం పరితోషయేత్ తథా ప్రభుం చిన్తయతి, ");
INSERT INTO santel_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","కిన్తు కృతవివాహో జనో యథా భార్య్యాం పరితోషయేత్ తథా సంసారం చిన్తయతి| ");
INSERT INTO santel_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","తద్వద్ ఊఢయోషితో ఽనూఢా విశిష్యతే| యానూఢా సా యథా కాయమనసోః పవిత్రా భవేత్ తథా ప్రభుం చిన్తయతి యా చోఢా సా యథా భర్త్తారం పరితోషయేత్ తథా సంసారం చిన్తయతి| ");
INSERT INTO santel_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","అహం యద్ యుష్మాన్ మృగబన్ధిన్యా పరిక్షిపేయం తదర్థం నహి కిన్తు యూయం యదనిన్దితా భూత్వా ప్రభోః సేవనేఽబాధమ్ ఆసక్తా భవేత తదర్థమేతాని సర్వ్వాణి యుష్మాకం హితాయ మయా కథ్యన్తే| ");
INSERT INTO santel_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","కస్యచిత్ కన్యాయాం యౌవనప్రాప్తాయాం యది స తస్యా అనూఢత్వం నిన్దనీయం వివాహశ్చ సాధయితవ్య ఇతి మన్యతే తర్హి యథాభిలాషం కరోతు, ఏతేన కిమపి నాపరాత్స్యతి వివాహః క్రియతాం| ");
INSERT INTO santel_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","కిన్తు దుఃఖేనాక్లిష్టః కశ్చిత్ పితా యది స్థిరమనోగతః స్వమనోఽభిలాషసాధనే సమర్థశ్చ స్యాత్ మమ కన్యా మయా రక్షితవ్యేతి మనసి నిశ్చినోతి చ తర్హి స భద్రం కర్మ్మ కరోతి| ");
INSERT INTO santel_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","అతో యో వివాహం కరోతి స భద్రం కర్మ్మ కరోతి యశ్చ వివాహం న కరోతి స భద్రతరం కర్మ్మ కరోతి| ");
INSERT INTO santel_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","యావత్కాలం పతి ర్జీవతి తావద్ భార్య్యా వ్యవస్థయా నిబద్ధా తిష్ఠతి కిన్తు పత్యౌ మహానిద్రాం గతే సా ముక్తీభూయ యమభిలషతి తేన సహ తస్యా వివాహో భవితుం శక్నోతి, కిన్త్వేతత్ కేవలం ప్రభుభక్తానాం మధ్యే| ");
INSERT INTO santel_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","తథాచ సా యది నిష్పతికా తిష్ఠతి తర్హి తస్యాః క్షేమం భవిష్యతీతి మమ భావః| అపరమ్ ఈశ్వరస్యాత్మా మమాప్యన్త ర్విద్యత ఇతి మయా బుధ్యతే| ");
INSERT INTO santel_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","దేవప్రసాదే సర్వ్వేషామ్ అస్మాకం జ్ఞానమాస్తే తద్వయం విద్మః| తథాపి జ్ఞానం గర్వ్వం జనయతి కిన్తు ప్రేమతో నిష్ఠా జాయతే| ");
INSERT INTO santel_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","అతః కశ్చన యది మన్యతే మమ జ్ఞానమాస్త ఇతి తర్హి తేన యాదృశం జ్ఞానం చేష్టితవ్యం తాదృశం కిమపి జ్ఞానమద్యాపి న లబ్ధం| ");
INSERT INTO santel_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","కిన్తు య ఈశ్వరే ప్రీయతే స ఈశ్వరేణాపి జ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","దేవతాబలిప్రసాదభక్షణే వయమిదం విద్మో యత్ జగన్మధ్యే కోఽపి దేవో న విద్యతే, ఏకశ్చేశ్వరో ద్వితీయో నాస్తీతి| ");
INSERT INTO santel_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","స్వర్గే పృథివ్యాం వా యద్యపి కేషుచిద్ ఈశ్వర ఇతి నామారోప్యతే తాదృశాశ్చ బహవ ఈశ్వరా బహవశ్చ ప్రభవో విద్యన్తే ");
INSERT INTO santel_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","తథాప్యస్మాకమద్వితీయ ఈశ్వరః స పితా యస్మాత్ సర్వ్వేషాం యదర్థఞ్చాస్మాకం సృష్టి ర్జాతా, అస్మాకఞ్చాద్వితీయః ప్రభుః స యీశుః ఖ్రీష్టో యేన సర్వ్వవస్తూనాం యేనాస్మాకమపి సృష్టిః కృతా| ");
INSERT INTO santel_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","అధికన్తు జ్ఞానం సర్వ్వేషాం నాస్తి యతః కేచిదద్యాపి దేవతాం సమ్మన్య దేవప్రసాదమివ తద్ భక్ష్యం భుఞ్జతే తేన దుర్బ్బలతయా తేషాం స్వాన్తాని మలీమసాని భవన్తి| ");
INSERT INTO santel_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","కిన్తు భక్ష్యద్రవ్యాద్ వయమ్ ఈశ్వరేణ గ్రాహ్యా భవామస్తన్నహి యతో భుఙ్క్త్వా వయముత్కృష్టా న భవామస్తద్వదభుఙ్క్త్వాప్యపకృష్టా న భవామః| ");
INSERT INTO santel_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","అతో యుష్మాకం యా క్షమతా సా దుర్బ్బలానామ్ ఉన్మాథస్వరూపా యన్న భవేత్ తదర్థం సావధానా భవత| ");
INSERT INTO santel_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","యతో జ్ఞానవిశిష్టస్త్వం యది దేవాలయే ఉపవిష్టః కేనాపి దృశ్యసే తర్హి తస్య దుర్బ్బలస్య మనసి కిం ప్రసాదభక్షణ ఉత్సాహో న జనిష్యతే? ");
INSERT INTO santel_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","తథా సతి యస్య కృతే ఖ్రీష్టో మమార తవ స దుర్బ్బలో భ్రాతా తవ జ్ఞానాత్ కిం న వినంక్ష్యతి? ");
INSERT INTO santel_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ఇత్యనేన ప్రకారేణ భ్రాతృణాం విరుద్ధమ్ అపరాధ్యద్భిస్తేషాం దుర్బ్బలాని మనాంసి వ్యాఘాతయద్భిశ్చ యుష్మాభిః ఖ్రీష్టస్య వైపరీత్యేనాపరాధ్యతే| ");
INSERT INTO santel_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","అతో హేతోః పిశితాశనం యది మమ భ్రాతు ర్విఘ్నస్వరూపం భవేత్ తర్హ్యహం యత్ స్వభ్రాతు ర్విఘ్నజనకో న భవేయం తదర్థం యావజ్జీవనం పిశితం న భోక్ష్యే| ");
INSERT INTO santel_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","అహం కిమ్ ఏకః ప్రేరితో నాస్మి? కిమహం స్వతన్త్రో నాస్మి? అస్మాకం ప్రభు ర్యీశుః ఖ్రీష్టః కిం మయా నాదర్శి? యూయమపి కిం ప్రభునా మదీయశ్రమఫలస్వరూపా న భవథ? ");
INSERT INTO santel_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","అన్యలోకానాం కృతే యద్యప్యహం ప్రేరితో న భవేయం తథాచ యుష్మత్కృతే ప్రేరితోఽస్మి యతః ప్రభునా మమ ప్రేరితత్వపదస్య ముద్రాస్వరూపా యూయమేవాధ్వే| ");
INSERT INTO santel_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","యే లోకా మయి దోషమారోపయన్తి తాన్ ప్రతి మమ ప్రత్యుత్తరమేతత్| ");
INSERT INTO santel_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","భోజనపానయోః కిమస్మాకం క్షమతా నాస్తి? ");
INSERT INTO santel_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","అన్యే ప్రేరితాః ప్రభో ర్భ్రాతరౌ కైఫాశ్చ యత్ కుర్వ్వన్తి తద్వత్ కాఞ్చిత్ ధర్మ్మభగినీం వ్యూహ్య తయా సార్ద్ధం పర్య్యటితుం వయం కిం న శక్నుమః? ");
INSERT INTO santel_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","సాంసారికశ్రమస్య పరిత్యాగాత్ కిం కేవలమహం బర్ణబ్బాశ్చ నివారితౌ? ");
INSERT INTO santel_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","నిజధనవ్యయేన కః సంగ్రామం కరోతి? కో వా ద్రాక్షాక్షేత్రం కృత్వా తత్ఫలాని న భుఙ్క్తే? కో వా పశువ్రజం పాలయన్ తత్పయో న పివతి? ");
INSERT INTO santel_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","కిమహం కేవలాం మానుషికాం వాచం వదామి? వ్యవస్థాయాం కిమేతాదృశం వచనం న విద్యతే? ");
INSERT INTO santel_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","మూసావ్యవస్థాగ్రన్థే లిఖితమాస్తే, త్వం శస్యమర్ద్దకవృషస్యాస్యం న భంత్స్యసీతి| ఈశ్వరేణ బలీవర్ద్దానామేవ చిన్తా కిం క్రియతే? ");
INSERT INTO santel_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","కిం వా సర్వ్వథాస్మాకం కృతే తద్వచనం తేనోక్తం? అస్మాకమేవ కృతే తల్లిఖితం| యః క్షేత్రం కర్షతి తేన ప్రత్యాశాయుక్తేన కర్ష్టవ్యం, యశ్చ శస్యాని మర్ద్దయతి తేన లాభప్రత్యాశాయుక్తేన మర్ద్దితవ్యం| ");
INSERT INTO santel_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","యుష్మత్కృతేఽస్మాభిః పారత్రికాణి బీజాని రోపితాని, అతో యుష్మాకమైహికఫలానాం వయమ్ అంశినో భవిష్యామః కిమేతత్ మహత్ కర్మ్మ? ");
INSERT INTO santel_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","యుష్మాసు యోఽధికారస్తస్య భాగినో యద్యన్యే భవేయుస్తర్హ్యస్మాభిస్తతోఽధికం కిం తస్య భాగిభి ర్న భవితవ్యం? అధికన్తు వయం తేనాధికారేణ న వ్యవహృతవన్తః కిన్తు ఖ్రీష్టీయసుసంవాదస్య కోఽపి వ్యాఘాతోఽస్మాభిర్యన్న జాయేత తదర్థం సర్వ్వం సహామహే| ");
INSERT INTO santel_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","అపరం యే పవిత్రవస్తూనాం పరిచర్య్యాం కుర్వ్వన్తి తే పవిత్రవస్తుతో భక్ష్యాణి లభన్తే, యే చ వేద్యాః పరిచర్య్యాం కుర్వ్వన్తి తే వేదిస్థవస్తూనామ్ అంశినో భవన్త్యేతద్ యూయం కిం న విద? ");
INSERT INTO santel_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","తద్వద్ యే సుసంవాదం ఘోషయన్తి తైః సుసంవాదేన జీవితవ్యమితి ప్రభునాదిష్టం| ");
INSERT INTO santel_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","అహమేతేషాం సర్వ్వేషాం కిమపి నాశ్రితవాన్ మాం ప్రతి తదనుసారాత్ ఆచరితవ్యమిత్యాశయేనాపి పత్రమిదం మయా న లిఖ్యతే యతః కేనాపి జనేన మమ యశసో ముధాకరణాత్ మమ మరణం వరం| ");
INSERT INTO santel_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","సుసంవాదఘేషణాత్ మమ యశో న జాయతే యతస్తద్ఘోషణం మమావశ్యకం యద్యహం సుసంవాదం న ఘోషయేయం తర్హి మాం ధిక్| ");
INSERT INTO santel_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ఇచ్ఛుకేన తత్ కుర్వ్వతా మయా ఫలం లప్స్యతే కిన్త్వనిచ్ఛుకేఽపి మయి తత్కర్మ్మణో భారోఽర్పితోఽస్తి| ");
INSERT INTO santel_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ఏతేన మయా లభ్యం ఫలం కిం? సుసంవాదేన మమ యోఽధికార ఆస్తే తం యదభద్రభావేన నాచరేయం తదర్థం సుసంవాదఘోషణసమయే తస్య ఖ్రీష్టీయసుసంవాదస్య నిర్వ్యయీకరణమేవ మమ ఫలం| ");
INSERT INTO santel_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","సర్వ్వేషామ్ అనాయత్తోఽహం యద్ భూరిశో లోకాన్ ప్రతిపద్యే తదర్థం సర్వ్వేషాం దాసత్వమఙ్గీకృతవాన్| ");
INSERT INTO santel_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","యిహూదీయాన్ యత్ ప్రతిపద్యే తదర్థం యిహూదీయానాం కృతే యిహూదీయఇవాభవం| యే చ వ్యవస్థాయత్తాస్తాన్ యత్ ప్రతిపద్యే తదర్థం వ్యవస్థానాయత్తో యోఽహం సోఽహం వ్యవస్థాయత్తానాం కృతే వ్యవస్థాయత్తఇవాభవం| ");
INSERT INTO santel_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","యే చాలబ్ధవ్యవస్థాస్తాన్ యత్ ప్రతిపద్యే తదర్థమ్ ఈశ్వరస్య సాక్షాద్ అలబ్ధవ్యవస్థో న భూత్వా ఖ్రీష్టేన లబ్ధవ్యవస్థో యోఽహం సోఽహమ్ అలబ్ధవ్యవస్థానాం కృతేఽలబ్ధవ్యవస్థ ఇవాభవం| ");
INSERT INTO santel_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","దుర్బ్బలాన్ యత్ ప్రతిపద్యే తదర్థమహం దుర్బ్బలానాం కృతే దుర్బ్బలఇవాభవం| ఇత్థం కేనాపి ప్రకారేణ కతిపయా లోకా యన్మయా పరిత్రాణం ప్రాప్నుయుస్తదర్థం యో యాదృశ ఆసీత్ తస్య కృతే ఽహం తాదృశఇవాభవం| ");
INSERT INTO santel_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ఇదృశ ఆచారః సుసంవాదార్థం మయా క్రియతే యతోఽహం తస్య ఫలానాం సహభాగీ భవితుమిచ్ఛామి| ");
INSERT INTO santel_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","పణ్యలాభార్థం యే ధావన్తి ధావతాం తేషాం సర్వ్వేషాం కేవల ఏకః పణ్యం లభతే యుష్మాభిః కిమేతన్న జ్ఞాయతే? అతో యూయం యథా పణ్యం లప్స్యధ్వే తథైవ ధావత| ");
INSERT INTO santel_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","మల్లా అపి సర్వ్వభోగే పరిమితభోగినో భవన్తి తే తు మ్లానాం స్రజం లిప్సన్తే కిన్తు వయమ్ అమ్లానాం లిప్సామహే| ");
INSERT INTO santel_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","తస్మాద్ అహమపి ధావామి కిన్తు లక్ష్యమనుద్దిశ్య ధావామి తన్నహి| అహం మల్లఇవ యుధ్యామి చ కిన్తు ఛాయామాఘాతయన్నివ యుధ్యామి తన్నహి| ");
INSERT INTO santel_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ఇతరాన్ ప్రతి సుసంవాదం ఘోషయిత్వాహం యత్ స్వయమగ్రాహ్యో న భవామి తదర్థం దేహమ్ ఆహన్మి వశీకుర్వ్వే చ| ");
INSERT INTO santel_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","హే భ్రాతరః, అస్మత్పితృపురుషానధి యూయం యదజ్ఞాతా న తిష్ఠతేతి మమ వాఞ్ఛా, తే సర్వ్వే మేఘాధఃస్థితా బభూవుః సర్వ్వే సముద్రమధ్యేన వవ్రజుః, ");
INSERT INTO santel_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","సర్వ్వే మూసాముద్దిశ్య మేఘసముద్రయో ర్మజ్జితా బభూవుః ");
INSERT INTO santel_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","సర్వ్వ ఏకమ్ ఆత్మికం భక్ష్యం బుభుజిర ఏకమ్ ఆత్మికం పేయం పపుశ్చ ");
INSERT INTO santel_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","యతస్తేఽనుచరత ఆత్మికాద్ అచలాత్ లబ్ధం తోయం పపుః సోఽచలః ఖ్రీష్టఏవ| ");
INSERT INTO santel_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","తథా సత్యపి తేషాం మధ్యేఽధికేషు లోకేష్వీశ్వరో న సన్తుతోషేతి హేతోస్తే ప్రన్తరే నిపాతితాః| ");
INSERT INTO santel_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ఏతస్మిన్ తే ఽస్మాకం నిదర్శనస్వరూపా బభూవుః; అతస్తే యథా కుత్సితాభిలాషిణో బభూవురస్మాభిస్తథా కుత్సితాభిలాషిభి ర్న భవితవ్యం| ");
INSERT INTO santel_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","లిఖితమాస్తే, లోకా భోక్తుం పాతుఞ్చోపవివిశుస్తతః క్రీడితుముత్థితా ఇతయనేన ప్రకారేణ తేషాం కైశ్చిద్ యద్వద్ దేవపూజా కృతా యుష్మాభిస్తద్వత్ న క్రియతాం| ");
INSERT INTO santel_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","అపరం తేషాం కైశ్చిద్ యద్వద్ వ్యభిచారః కృతస్తేన చైకస్మిన్ దినే త్రయోవింశతిసహస్రాణి లోకా నిపాతితాస్తద్వద్ అస్మాభి ర్వ్యభిచారో న కర్త్తవ్యః| ");
INSERT INTO santel_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","తేషాం కేచిద్ యద్వత్ ఖ్రీష్టం పరీక్షితవన్తస్తస్మాద్ భుజఙ్గై ర్నష్టాశ్చ తద్వద్ అస్మాభిః ఖ్రీష్టో న పరీక్షితవ్యః| ");
INSERT INTO santel_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","తేషాం కేచిద్ యథా వాక్కలహం కృతవన్తస్తత్కారణాత్ హన్త్రా వినాశితాశ్చ యుష్మాభిస్తద్వద్ వాక్కలహో న క్రియతాం| ");
INSERT INTO santel_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","తాన్ ప్రతి యాన్యేతాని జఘటిరే తాన్యస్మాకం నిదర్శనాని జగతః శేషయుగే వర్త్తమానానామ్ అస్మాకం శిక్షార్థం లిఖితాని చ బభూవుః| ");
INSERT INTO santel_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","అతఏవ యః కశ్చిద్ సుస్థిరంమన్యః స యన్న పతేత్ తత్ర సావధానో భవతు| ");
INSERT INTO santel_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","మానుషికపరీక్షాతిరిక్తా కాపి పరీక్షా యుష్మాన్ నాక్రామత్, ఈశ్వరశ్చ విశ్వాస్యః సోఽతిశక్త్యాం పరీక్షాయాం పతనాత్ యుష్మాన్ రక్షిష్యతి, పరీక్షా చ యద్ యుష్మాభిః సోఢుం శక్యతే తదర్థం తయా సహ నిస్తారస్య పన్థానం నిరూపయిష్యతి| ");
INSERT INTO santel_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","హే ప్రియభ్రాతరః, దేవపూజాతో దూరమ్ అపసరత| ");
INSERT INTO santel_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","అహం యుష్మాన్ విజ్ఞాన్ మత్వా ప్రభాషే మయా యత్ కథ్యతే తద్ యుష్మాభి ర్వివిచ్యతాం| ");
INSERT INTO santel_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","యద్ ధన్యవాదపాత్రమ్ అస్మాభి ర్ధన్యం గద్యతే తత్ కిం ఖ్రీష్టస్య శోణితస్య సహభాగిత్వం నహి? యశ్చ పూపోఽస్మాభి ర్భజ్యతే స కిం ఖ్రీష్టస్య వపుషః సహభాగిత్వం నహి? ");
INSERT INTO santel_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","వయం బహవః సన్తోఽప్యేకపూపస్వరూపా ఏకవపుఃస్వరూపాశ్చ భవామః, యతో వయం సర్వ్వ ఏకపూపస్య సహభాగినః| ");
INSERT INTO santel_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","యూయం శారీరికమ్ ఇస్రాయేలీయవంశం నిరీక్షధ్వం| యే బలీనాం మాంసాని భుఞ్జతే తే కిం యజ్ఞవేద్యాః సహభాగినో న భవన్తి? ");
INSERT INTO santel_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ఇత్యనేన మయా కిం కథ్యతే? దేవతా వాస్తవికీ దేవతాయై బలిదానం వా వాస్తవికం కిం భవేత్? ");
INSERT INTO santel_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","తన్నహి కిన్తు భిన్నజాతిభి ర్యే బలయో దీయన్తే త ఈశ్వరాయ తన్నహి భూతేభ్యఏవ దీయన్తే తస్మాద్ యూయం యద్ భూతానాం సహభాగినో భవథేత్యహం నాభిలషామి| ");
INSERT INTO santel_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ప్రభోః కంసేన భూతానామపి కంసేన పానం యుష్మాభిరసాధ్యం; యూయం ప్రభో ర్భోజ్యస్య భూతానామపి భోజ్యస్య సహభాగినో భవితుం న శక్నుథ| ");
INSERT INTO santel_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","వయం కిం ప్రభుం స్పర్ద్ధిష్యామహే? వయం కిం తస్మాద్ బలవన్తః? ");
INSERT INTO santel_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","మాం ప్రతి సర్వ్వం కర్మ్మాప్రతిషిద్ధం కిన్తు న సర్వ్వం హితజనకం సర్వ్వమ్ అప్రతిషిద్ధం కిన్తు న సర్వ్వం నిష్ఠాజనకం| ");
INSERT INTO santel_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ఆత్మహితః కేనాపి న చేష్టితవ్యః కిన్తు సర్వ్వైః పరహితశ్చేష్టితవ్యః| ");
INSERT INTO santel_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ఆపణే యత్ క్రయ్యం తద్ యుష్మాభిః సంవేదస్యార్థం కిమపి న పృష్ట్వా భుజ్యతాం ");
INSERT INTO santel_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","యతః పృథివీ తన్మధ్యస్థఞ్చ సర్వ్వం పరమేశ్వరస్య| ");
INSERT INTO santel_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","అపరమ్ అవిశ్వాసిలోకానాం కేనచిత్ నిమన్త్రితా యూయం యది తత్ర జిగమిషథ తర్హి తేన యద్ యద్ ఉపస్థాప్యతే తద్ యుష్మాభిః సంవేదస్యార్థం కిమపి న పృష్ట్వా భుజ్యతాం| ");
INSERT INTO santel_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","కిన్తు తత్ర యది కశ్చిద్ యుష్మాన్ వదేత్ భక్ష్యమేతద్ దేవతాయాః ప్రసాద ఇతి తర్హి తస్య జ్ఞాపయితురనురోధాత్ సంవేదస్యార్థఞ్చ తద్ యుష్మాభి ర్న భోక్తవ్యం| పృథివీ తన్మధ్యస్థఞ్చ సర్వ్వం పరమేశ్వరస్య, ");
INSERT INTO santel_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","సత్యమేతత్, కిన్తు మయా యః సంవేదో నిర్ద్దిశ్యతే స తవ నహి పరస్యైవ| ");
INSERT INTO santel_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","అనుగ్రహపాత్రేణ మయా ధన్యవాదం కృత్వా యద్ భుజ్యతే తత్కారణాద్ అహం కుతో నిన్దిష్యే? ");
INSERT INTO santel_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","తస్మాద్ భోజనం పానమ్ అన్యద్వా కర్మ్మ కుర్వ్వద్భి ర్యుష్మాభిః సర్వ్వమేవేశ్వరస్య మహిమ్నః ప్రకాశార్థం క్రియతాం| ");
INSERT INTO santel_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","యిహూదీయానాం భిన్నజాతీయానామ్ ఈశ్వరస్య సమాజస్య వా విఘ్నజనకై ర్యుష్మాభి ర్న భవితవ్యం| ");
INSERT INTO santel_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","అహమప్యాత్మహితమ్ అచేష్టమానో బహూనాం పరిత్రాణార్థం తేషాం హితం చేష్టమానః సర్వ్వవిషయే సర్వ్వేషాం తుష్టికరో భవామీత్యనేనాహం యద్వత్ ఖ్రీష్టస్యానుగామీ తద్వద్ యూయం మమానుగామినో భవత| ");
INSERT INTO santel_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","హే భ్రాతరః, యూయం సర్వ్వస్మిన్ కార్య్యే మాం స్మరథ మయా చ యాదృగుపదిష్టాస్తాదృగాచరథైతత్కారణాత్ మయా ప్రశంసనీయా ఆధ్బే| ");
INSERT INTO santel_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","తథాపి మమైషా వాఞ్ఛా యద్ యూయమిదమ్ అవగతా భవథ, ");
INSERT INTO santel_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ఏకైకస్య పురుషస్యోత్తమాఙ్గస్వరూపః ఖ్రీష్టః, యోషితశ్చోత్తమాఙ్గస్వరూపః పుమాన్, ఖ్రీష్టస్య చోత్తమాఙ్గస్వరూప ఈశ్వరః| ");
INSERT INTO santel_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","అపరమ్ ఆచ్ఛాదితోత్తమాఙ్గేన యేన పుంసా ప్రార్థనా క్రియత ఈశ్వరీయవాణీ కథ్యతే వా తేన స్వీయోత్తమాఙ్గమ్ అవజ్ఞాయతే| ");
INSERT INTO santel_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","అనాచ్ఛాదితోత్తమాఙ్గయా యయా యోషితా చ ప్రార్థనా క్రియత ఈశ్వరీయవాణీ కథ్యతే వా తయాపి స్వీయోత్తమాఙ్గమ్ అవజ్ఞాయతే యతః సా ముణ్డితశిరఃసదృశా| ");
INSERT INTO santel_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","అనాచ్ఛాదితమస్తకా యా యోషిత్ తస్యాః శిరః ముణ్డనీయమేవ కిన్తు యోషితః కేశచ్ఛేదనం శిరోముణ్డనం వా యది లజ్జాజనకం భవేత్ తర్హి తయా స్వశిర ఆచ్ఛాద్యతాం| ");
INSERT INTO santel_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","పుమాన్ ఈశ్వరస్య ప్రతిమూర్త్తిః ప్రతితేజఃస్వరూపశ్చ తస్మాత్ తేన శిరో నాచ్ఛాదనీయం కిన్తు సీమన్తినీ పుంసః ప్రతిబిమ్బస్వరూపా| ");
INSERT INTO santel_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","యతో యోషాతః పుమాన్ నోదపాది కిన్తు పుంసో యోషిద్ ఉదపాది| ");
INSERT INTO santel_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","అధికన్తు యోషితః కృతే పుంసః సృష్టి ర్న బభూవ కిన్తు పుంసః కృతే యోషితః సృష్టి ర్బభూవ| ");
INSERT INTO santel_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ఇతి హేతో ర్దూతానామ్ ఆదరాద్ యోషితా శిరస్యధీనతాసూచకమ్ ఆవరణం ధర్త్తవ్యం| ");
INSERT INTO santel_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","తథాపి ప్రభో ర్విధినా పుమాంసం వినా యోషిన్న జాయతే యోషితఞ్చ వినా పుమాన్ న జాయతే| ");
INSERT INTO santel_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","యతో యథా పుంసో యోషిద్ ఉదపాది తథా యోషితః పుమాన్ జాయతే, సర్వ్వవస్తూని చేశ్వరాద్ ఉత్పద్యన్తే| ");
INSERT INTO santel_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","యుష్మాభిరేవైతద్ వివిచ్యతాం, అనావృతయా యోషితా ప్రార్థనం కిం సుదృశ్యం భవేత్? ");
INSERT INTO santel_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","పురుషస్య దీర్ఘకేశత్వం తస్య లజ్జాజనకం, కిన్తు యోషితో దీర్ఘకేశత్వం తస్యా గౌరవజనకం ");
INSERT INTO santel_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","యత ఆచ్ఛాదనాయ తస్యై కేశా దత్తా ఇతి కిం యుష్మాభిః స్వభావతో న శిక్ష్యతే? ");
INSERT INTO santel_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","అత్ర యది కశ్చిద్ వివదితుమ్ ఇచ్ఛేత్ తర్హ్యస్మాకమ్ ఈశ్వరీయసమితీనాఞ్చ తాదృశీ రీతి ర్న విద్యతే| ");
INSERT INTO santel_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","యుష్మాభి ర్న భద్రాయ కిన్తు కుత్సితాయ సమాగమ్యతే తస్మాద్ ఏతాని భాషమాణేన మయా యూయం న ప్రశంసనీయాః| ");
INSERT INTO santel_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ప్రథమతః సమితౌ సమాగతానాం యుష్మాకం మధ్యే భేదాః సన్తీతి వార్త్తా మయా శ్రూయతే తన్మధ్యే కిఞ్చిత్ సత్యం మన్యతే చ| ");
INSERT INTO santel_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","యతో హేతో ర్యుష్మన్మధ్యే యే పరీక్షితాస్తే యత్ ప్రకాశ్యన్తే తదర్థం భేదై ర్భవితవ్యమేవ| ");
INSERT INTO santel_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ఏకత్ర సమాగతై ర్యుష్మాభిః ప్రభావం భేाజ్యం భుజ్యత ఇతి నహి; ");
INSERT INTO santel_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","యతో భోజనకాలే యుష్మాకమేకైకేన స్వకీయం భక్ష్యం తూర్ణం గ్రస్యతే తస్మాద్ ఏకో జనో బుభుక్షితస్తిష్ఠతి, అన్యశ్చ పరితృప్తో భవతి| ");
INSERT INTO sante