﻿USE sofia;
DROP TABLE IF EXISTS sofia.santam_vpl;
CREATE TABLE santam_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES santam_vpl WRITE;
INSERT INTO santam_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","இப்³ராஹீம​: ஸந்தாநோ தா³யூத்³ தஸ்ய ஸந்தாநோ யீஸு²க்²ரீஷ்டஸ்தஸ்ய பூர்வ்வபுருஷவம்ʼஸ²ஸ்²ரேணீ| ");
INSERT INTO santam_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","இப்³ராஹீம​: புத்ர இஸ்ஹாக் தஸ்ய புத்ரோ யாகூப்³ தஸ்ய புத்ரோ யிஹூதா³ஸ்தஸ்ய ப்⁴ராதரஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","தஸ்மாத்³ யிஹூதா³தஸ்தாமரோ க³ர்பே⁴ பேரஸ்ஸேரஹௌ ஜஜ்ஞாதே, தஸ்ய பேரஸ​: புத்ரோ ஹிஷ்ரோண் தஸ்ய புத்ரோ (அ)ராம்| ");
INSERT INTO santam_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","தஸ்ய புத்ரோ (அ)ம்மீநாத³ப்³ தஸ்ய புத்ரோ நஹஸோ²ந் தஸ்ய புத்ர​: ஸல்மோந்| ");
INSERT INTO santam_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","தஸ்மாத்³ ராஹபோ³ க³ர்பே⁴ போ³யம் ஜஜ்ஞே, தஸ்மாத்³ ரூதோ க³ர்பே⁴ ஓபே³த்³ ஜஜ்ஞே, தஸ்ய புத்ரோ யிஸ²ய​:| ");
INSERT INTO santam_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","தஸ்ய புத்ரோ தா³யூத்³ ராஜ​: தஸ்மாத்³ ம்ருʼதோரியஸ்ய ஜாயாயாம்ʼ ஸுலேமாந் ஜஜ்ஞே| ");
INSERT INTO santam_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","தஸ்ய புத்ரோ ரிஹபி³யாம், தஸ்ய புத்ரோ(அ)பி³ய​:, தஸ்ய புத்ர ஆஸா:| ");
INSERT INTO santam_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","தஸ்ய ஸுதோ யிஹோஸா²ப²ட் தஸ்ய ஸுதோ யிஹோராம தஸ்ய ஸுத உஷிய​:| ");
INSERT INTO santam_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","தஸ்ய ஸுதோ யோத²ம் தஸ்ய ஸுத ஆஹம் தஸ்ய ஸுதோ ஹிஷ்கிய​:| ");
INSERT INTO santam_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","தஸ்ய ஸுதோ மிநஸி²​:, தஸ்ய ஸுத ஆமோந் தஸ்ய ஸுதோ யோஸி²ய​:| ");
INSERT INTO santam_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","பா³பி³ல்நக³ரே ப்ரவஸநாத் பூர்வ்வம்ʼ ஸ யோஸி²யோ யிக²நியம்ʼ தஸ்ய ப்⁴ராத்ரும்ʼʼஸ்²ச ஜநயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ததோ பா³பி³லி ப்ரவஸநகாலே யிக²நிய​: ஸ²ல்தீயேலம்ʼ ஜநயாமாஸ, தஸ்ய ஸுத​: ஸிருப்³பா³வில்| ");
INSERT INTO santam_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","தஸ்ய ஸுதோ (அ)போ³ஹுத்³ தஸ்ய ஸுத இலீயாகீம் தஸ்ய ஸுதோ(அ)ஸோர்| ");
INSERT INTO santam_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","அஸோர​: ஸுத​: ஸாதோ³க் தஸ்ய ஸுத ஆகீ²ம் தஸ்ய ஸுத இலீஹூத்³| ");
INSERT INTO santam_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","தஸ்ய ஸுத இலியாஸர் தஸ்ய ஸுதோ மத்தந்| ");
INSERT INTO santam_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","தஸ்ய ஸுதோ யாகூப்³ தஸ்ய ஸுதோ யூஷப்² தஸ்ய ஜாயா மரியம்; தஸ்ய க³ர்பே⁴ யீஸு²ரஜநி, தமேவ க்²ரீஷ்டம் (அர்தா²த்³ அபி⁴ஷிக்தம்ʼ) வத³ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","இத்த²ம் இப்³ராஹீமோ தா³யூத³ம்ʼ யாவத் ஸாகல்யேந சதுர்த³ஸ²புருஷா​:; ஆ தா³யூத³​: காலாத்³ பா³பி³லி ப்ரவஸநகாலம்ʼ யாவத் சதுர்த³ஸ²புருஷா ப⁴வந்தி| பா³பி³லி ப்ரவாஸநகாலாத் க்²ரீஷ்டஸ்ய காலம்ʼ யாவத் சதுர்த³ஸ²புருஷா ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","யீஸு²க்²ரீஷ்டஸ்ய ஜந்ம கத்²த²தே| மரியம் நாமிகா கந்யா யூஷபே² வாக்³த³த்தாஸீத், ததா³ தயோ​: ஸங்க³மாத் ப்ராக் ஸா கந்யா  பவித்ரேணாத்மநா க³ர்ப⁴வதீ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","தத்ர தஸ்யா​: பதி ர்யூஷப்² ஸௌஜந்யாத் தஸ்யா​: கலங்க³ம்ʼ ப்ரகாஸ²யிதும் அநிச்ச²ந் கோ³பநேநே தாம்ʼ பாரித்யக்தும்ʼ மநஸ்²சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ஸ ததை²வ பா⁴வயதி, ததா³நீம்ʼ பரமேஸ்²வரஸ்ய தூ³த​: ஸ்வப்நே தம்ʼ த³ர்ஸ²நம்ʼ த³த்த்வா வ்யாஜஹார, ஹே தா³யூத³​: ஸந்தாந யூஷப்² த்வம்ʼ நிஜாம்ʼ ஜாயாம்ʼ மரியமம் ஆதா³தும்ʼ மா பை⁴ஷீ​:| ");
INSERT INTO santam_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","யதஸ்தஸ்யா க³ர்ப⁴​: பவித்ராதா³த்மநோ(அ)ப⁴வத், ஸா ச புத்ரம்ʼ ப்ரஸவிஷ்யதே, ததா³ த்வம்ʼ தஸ்ய நாம யீஸு²ம் (அர்தா²த் த்ராதாரம்ʼ) கரீஷ்யஸே, யஸ்மாத் ஸ நிஜமநுஜாந் தேஷாம்ʼ கலுஷேப்⁴ய உத்³த⁴ரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","இத்த²ம்ʼ ஸதி, பஸ்²ய க³ர்ப⁴வதீ கந்யா தநயம்ʼ ப்ரஸவிஷ்யதே| இம்மாநூயேல் ததீ³யஞ்ச நாமதே⁴யம்ʼ ப⁴விஷ்யதி|| இம்மாநூயேல் அஸ்மாகம்ʼ ஸங்கீ³ஸ்²வரஇத்யர்த²​:| ");
INSERT INTO santam_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","இதி யத்³ வசநம்ʼ புர்வ்வம்ʼ ப⁴விஷ்யத்³வக்த்ரா ஈஸ்²வர​: கதா²யாமாஸ, தத் ததா³நீம்ʼ ஸித்³த⁴மப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","அநந்தரம்ʼ யூஷப்² நித்³ராதோ ஜாக³ரித உத்தா²ய பரமேஸ்²வரீயதூ³தஸ்ய நிதே³ஸா²நுஸாரேண நிஜாம்ʼ ஜாயாம்ʼ ஜக்³ராஹ, ");
INSERT INTO santam_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","கிந்து யாவத் ஸா நிஜம்ʼ ப்ரத²மஸுதம்ʼ அ ஸுஷுவே, தாவத் தாம்ʼ நோபாக³ச்ச²த், தத​: ஸுதஸ்ய நாம யீஸு²ம்ʼ சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","அநந்தரம்ʼ ஹேரோத்³ ஸம்ʼஜ்ஞகே ராஜ்ஞி ராஜ்யம்ʼ ஸா²ஸதி யிஹூதீ³யதே³ஸ²ஸ்ய பை³த்லேஹமி நக³ரே யீஸௌ² ஜாதவதி ச, கதிபயா ஜ்யோதிர்வ்வுத³​: பூர்வ்வஸ்யா தி³ஸோ² யிரூஸா²லம்நக³ரம்ʼ ஸமேத்ய கத²யமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","யோ யிஹூதீ³யாநாம்ʼ ராஜா ஜாதவாந், ஸ குத்ராஸ்தே? வயம்ʼ பூர்வ்வஸ்யாம்ʼ தி³ஸி² திஷ்ட²ந்தஸ்ததீ³யாம்ʼ தாரகாம் அபஸ்²யாம தஸ்மாத் தம்ʼ ப்ரணந்தும் அाக³மாம| ");
INSERT INTO santam_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ததா³ ஹேரோத்³ ராஜா கதா²மேதாம்ʼ நிஸ²ம்ய யிரூஸா²லம்நக³ரஸ்தி²தை​: ஸர்வ்வமாநவை​: ஸார்த்³த⁴ம் உத்³விஜ்ய ");
INSERT INTO santam_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ஸர்வ்வாந் ப்ரதா⁴நயாஜகாந் அத்⁴யாபகாம்ʼஸ்²ச ஸமாஹூயாநீய பப்ரச்ச², க்²ரீஷ்ட​: குத்ர ஜநிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ததா³ தே கத²யாமாஸு​:, யிஹூதீ³யதே³ஸ²ஸ்ய பை³த்லேஹமி நக³ரே, யதோ ப⁴விஷ்யத்³வாதி³நா இத்த²ம்ʼ லிகி²தமாஸ்தே, ");
INSERT INTO santam_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ஸர்வ்வாப்⁴யோ ராஜதா⁴நீப்⁴யோ யிஹூதீ³யஸ்ய நீவ்ருʼத​:| ஹே யீஹூதீ³யதே³ஸ²ஸ்யே பை³த்லேஹம் த்வம்ʼ ந சாவரா| இஸ்ராயேலீயலோகாந் மே யதோ ய​: பாலயிஷ்யதி| தாத்³ருʼகே³கோ மஹாராஜஸ்த்வந்மத்⁴ய உத்³ப⁴விஷ்யதீ|| ");
INSERT INTO santam_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ததா³நீம்ʼ ஹேரோத்³ ராஜா தாந் ஜ்யோதிர்வ்விதோ³ கோ³பநம் ஆஹூய ஸா தாரகா கதா³ த்³ருʼஷ்டாப⁴வத் , தத்³ விநிஸ்²சயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","அபரம்ʼ தாந் பை³த்லேஹமம்ʼ ப்ரஹீத்ய க³தி³தவாந், யூயம்ʼ யாத, யத்நாத் தம்ʼ ஸி²ஸு²ம் அந்விஷ்ய தது³த்³தே³ஸே² ப்ராப்தே மஹ்யம்ʼ வார்த்தாம்ʼ தா³ஸ்யத², ததோ மயாபி க³த்வா ஸ ப்ரணம்ʼஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ததா³நீம்ʼ ராஜ்ஞ ஏதாத்³ருʼஸீ²ம் ஆஜ்ஞாம்ʼ ப்ராப்ய தே ப்ரதஸ்தி²ரே, தத​: பூர்வ்வர்ஸ்யாம்ʼ தி³ஸி² ஸ்தி²தைஸ்தை ர்யா தாரகா த்³ருʼஷ்டா ஸா தாரகா தேஷாமக்³ரே க³த்வா யத்ர ஸ்தா²நே ஸி²ஸூ²ராஸ்தே, தஸ்ய ஸ்தா²நஸ்யோபரி ஸ்த²கி³தா தஸ்யௌ| ");
INSERT INTO santam_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","தத்³ த்³ருʼஷ்ட்வா தே மஹாநந்தி³தா ப³பூ⁴வு​:, ");
INSERT INTO santam_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ததோ கே³ஹமத்⁴ய ப்ரவிஸ்²ய தஸ்ய மாத்ரா மரியமா ஸாத்³த⁴ம்ʼ தம்ʼ ஸி²ஸு²ம்ʼ நிரீக்ஷய த³ண்ட³வத்³ பூ⁴த்வா ப்ரணேமு​:, அபரம்ʼ ஸ்வேஷாம்ʼ க⁴நஸம்பத்திம்ʼ மோசயித்வா ஸுவர்ணம்ʼ குந்து³ரும்ʼ க³ந்த⁴ரமஞ்ச தஸ்மை த³ர்ஸ²நீயம்ʼ த³த்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","பஸ்²சாத்³ ஹேரோத்³ ராஜஸ்ய ஸமீபம்ʼ புநரபி க³ந்தும்ʼ ஸ்வப்ந ஈஸ்²வரேண நிஷித்³தா⁴​: ஸந்தோ (அ)ந்யேந பதா² தே நிஜதே³ஸ²ம்ʼ ப்ரதி ப்ரதஸ்தி²ரே| ");
INSERT INTO santam_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","அநந்தரம்ʼ தேஷு க³தவத்மு பரமேஸ்²வரஸ்ய தூ³தோ யூஷபே² ஸ்வப்நே த³ர்ஸ²நம்ʼ த³த்வா ஜகா³த³, த்வம் உத்தா²ய ஸி²ஸு²ம்ʼ தந்மாதரஞ்ச க்³ருʼஹீத்வா மிஸர்தே³ஸ²ம்ʼ பலாயஸ்வ, அபரம்ʼ யாவத³ஹம்ʼ துப்⁴யம்ʼ வார்த்தாம்ʼ ந கத²யிஷ்யாமி, தாவத் தத்ரைவ நிவஸ, யதோ ராஜா ஹேரோத்³ ஸி²ஸு²ம்ʼ நாஸ²யிதும்ʼ ம்ருʼக³யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ததா³நீம்ʼ யூஷப்² உத்தா²ய ரஜந்யாம்ʼ ஸி²ஸு²ம்ʼ தந்மாதரஞ்ச க்³ருʼஹீத்வா மிஸர்தே³ஸ²ம்ʼ ப்ரதி ப்ரதஸ்தே², ");
INSERT INTO santam_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","க³த்வா ச ஹேரோதோ³ ந்ருʼபதே ர்மரணபர்ய்யந்தம்ʼ தத்ர தே³ஸே² ந்யுவாஸ, தேந மிஸர்தே³ஸா²த³ஹம்ʼ புத்ரம்ʼ ஸ்வகீயம்ʼ ஸமுபாஹூயம்| யதே³தத்³வசநம் ஈஸ்²வரேண ப⁴விஷ்யத்³வாதி³நா கதி²தம்ʼ தத் ஸப²லமபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","அநந்தரம்ʼ ஹேரோத்³ ஜ்யோதிர்வித்³பி⁴ராத்மாநம்ʼ ப்ரவஞ்சிதம்ʼ விஜ்ஞாய ப்⁴ருʼஸ²ம்ʼ சுகோப; அபரம்ʼ ஜ்யோதிர்வ்வித்³ப்⁴யஸ்தேந விநிஸ்²சிதம்ʼ யத்³ தி³நம்ʼ தத்³தி³நாத்³ க³ணயித்வா த்³விதீயவத்ஸரம்ʼ ப்ரவிஷ்டா யாவந்தோ பா³லகா அஸ்மிந் பை³த்லேஹம்நக³ரே தத்ஸீமமத்⁴யே சாஸந், லோகாந் ப்ரஹித்ய தாந் ஸர்வ்வாந் கா⁴தயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","அத​: அநேகஸ்ய விலாபஸ்ய நிநாத³: க்ரந்த³நஸ்ய ச| ஸோ²கேந க்ருʼதஸ²ப்³த³ஸ்²ச ராமாயாம்ʼ ஸம்ʼநிஸ²ம்யதே| ஸ்வபா³லக³ணஹேதோர்வை ராஹேல் நாரீ து ரோதி³நீ| ந மந்யதே ப்ரபோ³த⁴ந்து யதஸ்தே நைவ மந்தி ஹி|| ");
INSERT INTO santam_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","யதே³தத்³ வசநம்ʼ யிரீமியநாமகப⁴விஷ்யத்³வாதி³நா கதி²தம்ʼ தத் ததா³நீம்ʼ ஸப²லம் அபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","தத³நந்தரம்ʼ ஹேரேதி³ ராஜநி ம்ருʼதே பரமேஸ்²வரஸ்ய தூ³தோ மிஸர்தே³ஸே² ஸ்வப்நே த³ர்ஸ²நம்ʼ த³த்த்வா யூஷபே² கதி²தவாந் ");
INSERT INTO santam_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","த்வம் உத்தா²ய ஸி²ஸு²ம்ʼ தந்மாதரஞ்ச க்³ருʼஹீத்வா புநரபீஸ்ராயேலோ தே³ஸ²ம்ʼ யாஹீ, யே ஜநா​: ஸி²ஸு²ம்ʼ நாஸ²யிதும் அம்ருʼக³யந்த, தே ம்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ததா³நீம்ʼ ஸ உத்தா²ய ஸி²ஸு²ம்ʼ தந்மாதரஞ்ச க்³ருʼஹ்லந் இஸ்ராயேல்தே³ஸ²ம் ஆஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","கிந்து யிஹூதீ³யதே³ஸே² அர்கி²லாயநாம ராஜகுமாரோ நிஜபிது ர்ஹேரோத³​: பத³ம்ʼ ப்ராப்ய ராஜத்வம்ʼ கரோதீதி நிஸ²ம்ய தத் ஸ்தா²நம்ʼ யாதும்ʼ ஸ²ங்கிதவாந், பஸ்²சாத் ஸ்வப்ந ஈஸ்²வராத் ப்ரபோ³த⁴ம்ʼ ப்ராப்ய கா³லீல்தே³ஸ²ஸ்ய ப்ரதே³ஸை²கம்ʼ ப்ரஸ்தா²ய நாஸரந்நாம நக³ரம்ʼ க³த்வா தத்ர ந்யுஷிதவாந், ");
INSERT INTO santam_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","தேந தம்ʼ நாஸரதீயம்ʼ கத²யிஷ்யந்தி, யதே³தத்³வாக்யம்ʼ ப⁴விஷ்யத்³வாதி³பி⁴ருக்த்தம்ʼ தத் ஸப²லமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ததா³நோம்ʼ யோஹ்ந்நாமா மஜ்ஜயிதா யிஹூதீ³யதே³ஸ²ஸ்ய ப்ராந்தரம் உபஸ்தா²ய ப்ரசாரயந் கத²யாமாஸ, ");
INSERT INTO santam_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","மநாம்ʼஸி பராவர்த்தயத, ஸ்வர்கீ³யராஜத்வம்ʼ ஸமீபமாக³தம்| ");
INSERT INTO santam_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","பரமேஸ²ஸ்ய பந்தா²நம்ʼ பரிஷ்குருத ஸர்வ்வத​:| தஸ்ய ராஜபதா²ம்ʼஸ்²சைவ ஸமீகுருத ஸர்வ்வதா²| இத்யேதத் ப்ராந்தரே வாக்யம்ʼ வத³த​: கஸ்யசித்³ ரவ​:|| ");
INSERT INTO santam_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ஏதத்³வசநம்ʼ யிஸ²யியப⁴விஷ்யத்³வாதி³நா யோஹநமுத்³தி³ஸ்²ய பா⁴ஷிதம்| யோஹநோ வஸநம்ʼ மஹாங்க³ரோமஜம்ʼ தஸ்ய கடௌ சர்ம்மகடிப³ந்த⁴நம்ʼ; ஸ ச ஸூ²ககீடாந் மது⁴ ச பு⁴க்தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ததா³நீம்ʼ யிரூஸா²லம்நக³ரநிவாஸிந​: ஸர்வ்வே யிஹூதி³தே³ஸீ²யா யர்த்³த³ந்தடிந்யா உப⁴யதடஸ்தா²ஸ்²ச மாநவா ப³ஹிராக³த்ய தஸ்ய ஸமீபே ");
INSERT INTO santam_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ஸ்வீயம்ʼ ஸ்வீயம்ʼ து³ரிதம் அங்கீ³க்ருʼத்ய தஸ்யாம்ʼ யர்த்³த³நி தேந மஜ்ஜிதா ப³பூ⁴வு​:| ");
INSERT INTO santam_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","அபரம்ʼ ப³ஹூந் பி²ரூஸி²ந​: ஸிதூ³கிநஸ்²ச மநுஜாந் மம்ʼக்தும்ʼ ஸ்வஸமீபம் ஆக³ச்ச்²தோ விலோக்ய ஸ தாந் அபி⁴த³தௌ⁴, ரே ரே பு⁴ஜக³வம்ʼஸா² ஆகா³மீந​: கோபாத் பலாயிதும்ʼ யுஷ்மாந் கஸ்²சேதிதவாந்? ");
INSERT INTO santam_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","மந​:பராவர்த்தநஸ்ய ஸமுசிதம்ʼ ப²லம்ʼ ப²லத| ");
INSERT INTO santam_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","கிந்த்வஸ்மாகம்ʼ தாத இப்³ராஹீம் அஸ்தீதி ஸ்வேஷு மந​:ஸு சீந்தயந்தோ மா வ்யாஹரத| யதோ யுஷ்மாந் அஹம்ʼ வதா³மி, ஈஸ்²வர ஏதேப்⁴ய​: பாஷாணேப்⁴ய இப்³ராஹீம​: ஸந்தாநாந் உத்பாத³யிதும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","அபரம்ʼ பாத³பாநாம்ʼ மூலே குடா²ர இதா³நீமபி லக³ந் ஆஸ்தே, தஸ்மாத்³ யஸ்மிந் பாத³பே உத்தமம்ʼ ப²லம்ʼ ந ப⁴வதி, ஸ க்ருʼத்தோ மத்⁴யே(அ)க்³நிம்ʼ நிக்ஷேப்ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","அபரம் அஹம்ʼ மந​:பராவர்த்தநஸூசகேந மஜ்ஜநேந யுஷ்மாந் மஜ்ஜயாமீதி ஸத்யம்ʼ, கிந்து மம பஸ்²சாத்³ ய ஆக³ச்ச²தி, ஸ மத்தோபி மஹாந், அஹம்ʼ ததீ³யோபாநஹௌ வோடு⁴மபி நஹி யோக்³யோஸ்மி, ஸ யுஷ்மாந் வஹ்நிரூபே பவித்ர ஆத்மநி ஸம்ʼமஜ்ஜயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","தஸ்ய காரே ஸூர்ப ஆஸ்தே, ஸ ஸ்வீயஸ²ஸ்யாநி ஸம்யக் ப்ரஸ்போ²ட்ய நிஜாந் ஸகலகோ³தூ⁴மாந் ஸம்ʼக்³ருʼஹ்ய பா⁴ண்டா³கா³ரே ஸ்தா²பயிஷ்யதி, கிம்ʼந்து ஸர்வ்வாணி வுஷாண்யநிர்வ்வாணவஹ்நிநா தா³ஹயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","அநந்தரம்ʼ யீஸு² ர்யோஹநா மஜ்ஜிதோ ப⁴விதும்ʼ கா³லீல்ப்ரதே³ஸா²த்³ யர்த்³த³நி தஸ்ய ஸமீபம் ஆஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","கிந்து யோஹந் தம்ʼ நிஷித்⁴ய ப³பா⁴ஷே, த்வம்ʼ கிம்ʼ மம ஸமீபம் ஆக³ச்ச²ஸி? வரம்ʼ த்வயா மஜ்ஜநம்ʼ மம ப்ரயோஜநம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ததா³நீம்ʼ யீஸு²​: ப்ரத்யவோசத்; ஈதா³நீம் அநுமந்யஸ்வ, யத இத்த²ம்ʼ ஸர்வ்வத⁴ர்ம்மஸாத⁴நம் அஸ்மாகம்ʼ கர்த்தவ்யம்ʼ, தத​: ஸோ(அ)ந்வமந்யத| ");
INSERT INTO santam_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","அநந்தரம்ʼ யீஸு²ரம்மஸி மஜ்ஜிது​: ஸந் தத்க்ஷணாத் தோயமத்⁴யாத்³ உத்தா²ய ஜகா³ம, ததா³ ஜீமூதத்³வாரே முக்தே ஜாதே, ஸ ஈஸ்²வரஸ்யாத்மாநம்ʼ கபோதவத்³ அவருஹ்ய ஸ்வோபர்ய்யாக³ச்ச²ந்தம்ʼ வீக்ஷாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","அபரம் ஏஷ மம ப்ரிய​: புத்ர ஏதஸ்மிந்நேவ மம மஹாஸந்தோஷ ஏதாத்³ருʼஸீ² வ்யோமஜா வாக்³ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","தத​: பரம்ʼ யீஸு²​: ப்ரதாரகேண பரீக்ஷிதோ ப⁴விதும் ஆத்மநா ப்ராந்தரம் ஆக்ருʼஷ்ட​: ");
INSERT INTO santam_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ஸந் சத்வாரிம்ʼஸ²த³ஹோராத்ராந் அநாஹாரஸ்திஷ்ட²ந் க்ஷுதி⁴தோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ததா³நீம்ʼ பரீக்ஷிதா தத்ஸமீபம் ஆக³த்ய வ்யாஹ்ருʼதவாந், யதி³ த்வமீஸ்²வராத்மஜோ ப⁴வேஸ்தர்ஹ்யாஜ்ஞயா பாஷாணாநேதாந் பூபாந் விதே⁴ஹி| ");
INSERT INTO santam_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","தத​: ஸ ப்ரத்யப்³ரவீத், இத்த²ம்ʼ லிகி²தமாஸ்தே, \"மநுஜ​: கேவலபூபேந ந ஜீவிஷ்யதி, கிந்த்வீஸ்²வரஸ்ய வத³நாத்³ யாநி யாநி வசாம்ʼஸி நி​:ஸரந்தி தைரேவ ஜீவிஷ்யதி| \" ");
INSERT INTO santam_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ததா³ ப்ரதாரகஸ்தம்ʼ புண்யநக³ரம்ʼ நீத்வா மந்தி³ரஸ்ய சூடோ³பரி நிதா⁴ய க³தி³தவாந், ");
INSERT INTO santam_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","த்வம்ʼ யதி³ஸ்²வரஸ்ய தநயோ ப⁴வேஸ்தர்ஹீதோ(அ)த⁴​: பத, யத இத்த²ம்ʼ லிகி²தமாஸ்தே, ஆதே³க்ஷ்யதி நிஜாந் தூ³தாந் ரக்ஷிதும்ʼ த்வாம்ʼ பரமேஸ்²வர​:| யதா² ஸர்வ்வேஷு மார்கே³ஷு த்வதீ³யசரணத்³வயே| ந லகே³த் ப்ரஸ்தராகா⁴தஸ்த்வாம்ʼ க⁴ரிஷ்யந்தி தே கரை​:|| ");
INSERT INTO santam_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ததா³நீம்ʼ யீஸு²ஸ்தஸ்மை கதி²தவாந் ஏதத³பி லிகி²தமாஸ்தே, \"த்வம்ʼ நிஜப்ரபு⁴ம்ʼ பரமேஸ்²வரம்ʼ மா பரீக்ஷஸ்வ| \" ");
INSERT INTO santam_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","அநந்தரம்ʼ ப்ரதாரக​: புநரபி தம் அத்யுஞ்சத⁴ராத⁴ரோபரி நீத்வா ஜக³த​: ஸகலராஜ்யாநி ததை³ஸ்²வர்ய்யாணி ச த³ர்ஸ²யாஸ்²சகார கத²யாஞ்சகார ச, ");
INSERT INTO santam_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","யதி³ த்வம்ʼ த³ண்ட³வத்³ ப⁴வந் மாம்ʼ ப்ரணமேஸ்தர்ஹ்யஹம் ஏதாநி துப்⁴யம்ʼ ப்ரதா³ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ததா³நீம்ʼ யீஸு²ஸ்தமவோசத், தூ³ரீப⁴வ ப்ரதாரக, லிகி²தமித³ம் ஆஸ்தே, \"த்வயா நிஜ​: ப்ரபு⁴​: பரமேஸ்²வர​: ப்ரணம்ய​: கேவல​: ஸ ஸேவ்யஸ்²ச| \" ");
INSERT INTO santam_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","தத​: ப்ரதாரகேண ஸ பர்ய்யத்யாஜி, ததா³ ஸ்வர்கீ³யதூ³தைராக³த்ய ஸ ஸிஷேவே| ");
INSERT INTO santam_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","தத³நந்தரம்ʼ யோஹந் காராயாம்ʼ ப³ப³ந்தே⁴, தத்³வார்த்தாம்ʼ நிஸ²ம்ய யீஸு²நா கா³லீல் ப்ராஸ்தீ²யத| ");
INSERT INTO santam_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","தத​: பரம்ʼ ஸ நாஸரந்நக³ரம்ʼ விஹாய ஜலகே⁴ஸ்தடே ஸிபூ³லூந்நப்தாலீ ஏதயோருவப⁴யோ​: ப்ரதே³ஸ²யோ​: ஸீம்நோர்மத்⁴யவர்த்தீ ய: கப²ர்நாஹூம் தந்நக³ரம் இத்வா ந்யவஸத்| ");
INSERT INTO santam_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","தஸ்மாத், அந்யாதே³ஸீ²யகா³லீலி யர்த்³த³ந்பாரே(அ)ப்³தி⁴ரோத⁴ஸி| நப்தாலிஸிபூ³லூந்தே³ஸௌ² யத்ர ஸ்தா²நே ஸ்தி²தௌ புரா| ");
INSERT INTO santam_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","தத்ரத்யா மநுஜா யே யே பர்ய்யப்⁴ராம்யந் தமிஸ்ரகே| தைர்ஜநைர்ப்³ருʼஹதா³லோக​: பரித³ர்ஸி²ஷ்யதே ததா³| அவஸந் யே ஜநா தே³ஸே² ம்ருʼத்யுச்சா²யாஸ்வரூபகே| தேஷாமுபரி லோகாநாமாலோக​: ஸம்ʼப்ரகாஸி²த​:|| ");
INSERT INTO santam_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","யதே³தத்³வசநம்ʼ யிஸ²யியப⁴விஷ்யத்³வாதி³நா ப்ரோக்தம்ʼ, தத் ததா³ ஸப²லம் அபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","அநந்தரம்ʼ யீஸு²​: ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் ஏதாம்ʼ கதா²ம்ʼ கத²யிதும் ஆரேபே⁴, மநாம்ʼஸி பராவர்த்தயத, ஸ்வர்கீ³யராஜத்வம்ʼ ஸவித⁴மப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","தத​: பரம்ʼ யீஸு² ர்கா³லீலோ ஜலதே⁴ஸ்தடேந க³ச்ச²ந் க³ச்ச²ந் ஆந்த்³ரியஸ்தஸ்ய ப்⁴ராதா ஸி²மோந் அர்த²தோ யம்ʼ பிதரம்ʼ வத³ந்தி ஏதாவுபௌ⁴ ஜலகௌ⁴ ஜாலம்ʼ க்ஷிபந்தௌ த³த³ர்ஸ², யதஸ்தௌ மீநதா⁴ரிணாவாஸ்தாம்| ");
INSERT INTO santam_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ததா³ ஸ தாவாஹூய வ்யாஜஹார, யுவாம்ʼ மம பஸ்²சாத்³ ஆக³ச்ச²தம்ʼ, யுவாமஹம்ʼ மநுஜதா⁴ரிணௌ கரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","தேநைவ தௌ ஜாலம்ʼ விஹாய தஸ்ய பஸ்²சாத் ஆக³ச்ச²தாம்| ");
INSERT INTO santam_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","அநந்தரம்ʼ தஸ்மாத் ஸ்தா²நாத் வ்ரஜந் வ்ரஜந் ஸிவதி³யஸ்ய ஸுதௌ யாகூப்³ யோஹந்நாமாநௌ த்³வௌ ஸஹஜௌ தாதேந ஸார்த்³த⁴ம்ʼ நௌகோபரி ஜாலஸ்ய ஜீர்ணோத்³தா⁴ரம்ʼ குர்வ்வந்தௌ வீக்ஷ்ய தாவாஹூதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","தத்க்ஷணாத் தௌ நாவம்ʼ ஸ்வதாதஞ்ச விஹாய தஸ்ய பஸ்²சாத்³கா³மிநௌ ப³பூ⁴வது​:| ");
INSERT INTO santam_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","அநந்தரம்ʼ ப⁴ஜநப⁴வநே ஸமுபதி³ஸ²ந் ராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் மநுஜாநாம்ʼ ஸர்வ்வப்ரகாராந் ரோகா³ந் ஸர்வ்வப்ரகாரபீடா³ஸ்²ச ஸ²மயந் யீஸு²​: க்ருʼத்ஸ்நம்ʼ கா³லீல்தே³ஸ²ம்ʼ ப்⁴ரமிதும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","தேந க்ருʼத்ஸ்நஸுரியாதே³ஸ²ஸ்ய மத்⁴யம்ʼ தஸ்ய யஸோ² வ்யாப்நோத், அபரம்ʼ பூ⁴தக்³ரஸ்தா அபஸ்மாரர்கீ³ண​: பக்ஷாதா⁴திப்ரப்⁴ருʼதயஸ்²ச யாவந்தோ மநுஜா நாநாவித⁴வ்யாதி⁴பி⁴​: க்லிஷ்டா ஆஸந், தேஷு ஸர்வ்வேஷு தஸ்ய ஸமீபம் ஆநீதேஷு ஸ தாந் ஸ்வஸ்தா²ந் சகார| ");
INSERT INTO santam_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ஏதேந கா³லீல்-தி³காபநி-யிரூஸா²லம்-யிஹூதீ³யதே³ஸே²ப்⁴யோ யர்த்³த³ந​: பாராஞ்ச ப³ஹவோ மநுஜாஸ்தஸ்ய பஸ்²சாத்³ ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","அநந்தரம்ʼ ஸ ஜநநிவஹம்ʼ நிரீக்ஷ்ய பூ⁴த⁴ரோபரி வ்ரஜித்வா ஸமுபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ததா³நீம்ʼ ஸி²ஷ்யேஷு தஸ்ய ஸமீபமாக³தேஷு தேந தேப்⁴ய ஏஷா கதா² கத்²யாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","அபி⁴மாநஹீநா ஜநா த⁴ந்யா​:, யதஸ்தே ஸ்வர்கீ³யராஜ்யம் அதி⁴கரிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","கி²த்³யமாநா மநுஜா த⁴ந்யா​:, யஸ்மாத் தே ஸாந்த்வநாம்ʼ ப்ராப்ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","நம்ரா மாநவாஸ்²ச த⁴ந்யா​:, யஸ்மாத் தே மேதி³நீம் அதி⁴கரிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","த⁴ர்ம்மாய பு³பு⁴க்ஷிதா​: த்ருʼஷார்த்தாஸ்²ச மநுஜா த⁴ந்யா​:, யஸ்மாத் தே பரிதர்ப்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","க்ருʼபாலவோ மாநவா த⁴ந்யா​:, யஸ்மாத் தே க்ருʼபாம்ʼ ப்ராப்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","நிர்ம்மலஹ்ருʼத³யா மநுஜாஸ்²ச த⁴ந்யா​:, யஸ்மாத் த ஈஸ்²சரம்ʼ த்³ரக்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","மேலயிதாரோ மாநவா த⁴ந்யா​:, யஸ்மாத் த ஈஸ்²சரஸ்ய ஸந்தாநத்வேந விக்²யாஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","த⁴ர்ம்மகாரணாத் தாடி³தா மநுஜா த⁴ந்யா, யஸ்மாத் ஸ்வர்கீ³யராஜ்யே தேஷாமதி⁴கரோ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","யதா³ மநுஜா மம நாமக்ருʼதே யுஷ்மாந் நிந்த³ந்தி தாட³யந்தி ம்ருʼஷா நாநாது³ர்வ்வாக்யாநி வத³ந்தி ச, ததா³ யுயம்ʼ த⁴ந்யா​:| ");
INSERT INTO santam_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ததா³ ஆநந்த³த, ததா² ப்⁴ருʼஸ²ம்ʼ ஹ்லாத³த்⁴வஞ்ச, யத​: ஸ்வர்கே³ பூ⁴யாம்ʼஸி ப²லாநி லப்ஸ்யத்⁴வே; தே யுஷ்மாகம்ʼ புராதநாந் ப⁴விஷ்யத்³வாதி³நோ(அ)பி தாத்³ருʼக்³ அதாட³யந்| ");
INSERT INTO santam_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","யுயம்ʼ மேதி³ந்யாம்ʼ லவணரூபா​:, கிந்து யதி³ லவணஸ்ய லவணத்வம் அபயாதி, தர்ஹி தத் கேந ப்ரகாரேண ஸ்வாது³யுக்தம்ʼ ப⁴விஷ்யதி? தத் கஸ்யாபி கார்ய்யஸ்யாயோக்³யத்வாத் கேவலம்ʼ ப³ஹி​: ப்ரக்ஷேப்தும்ʼ நராணாம்ʼ பத³தலேந த³லயிதுஞ்ச யோக்³யம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","யூயம்ʼ ஜக³தி தீ³ப்திரூபா​:, பூ⁴த⁴ரோபரி ஸ்தி²தம்ʼ நக³ரம்ʼ கு³ப்தம்ʼ ப⁴விதும்ʼ நஹி ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","அபரம்ʼ மநுஜா​: ப்ரதீ³பாந் ப்ரஜ்வால்ய த்³ரோணாதோ⁴ ந ஸ்தா²பயந்தி, கிந்து தீ³பாதா⁴ரோபர்ய்யேவ ஸ்தா²பயந்தி, தேந தே தீ³பா கே³ஹஸ்தி²தாந் ஸகலாந் ப்ரகாஸ²யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","யேந மாநவா யுஷ்மாகம்ʼ ஸத்கர்ம்மாணி விலோக்ய யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²ம்ʼ பிதரம்ʼ த⁴ந்யம்ʼ வத³ந்தி, தேஷாம்ʼ ஸமக்ஷம்ʼ யுஷ்மாகம்ʼ தீ³ப்திஸ்தாத்³ருʼக் ப்ரகாஸ²தாம்| ");
INSERT INTO santam_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","அஹம்ʼ வ்யவஸ்தா²ம்ʼ ப⁴விஷ்யத்³வாக்யஞ்ச லோப்தும் ஆக³தவாந், இத்த²ம்ʼ மாநுப⁴வத, தே த்³வே லோப்தும்ʼ நாக³தவாந், கிந்து ஸப²லே கர்த்தும் ஆக³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","அபரம்ʼ யுஷ்மாந் அஹம்ʼ தத்²யம்ʼ வதா³மி யாவத் வ்யோமமேதி³ந்யோ ர்த்⁴வம்ʼஸோ ந ப⁴விஷ்யதி, தாவத் ஸர்வ்வஸ்மிந் ஸப²லே ந ஜாதே வ்யவஸ்தா²யா ஏகா மாத்ரா பி³ந்து³ரேகோபி வா ந லோப்ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","தஸ்மாத் யோ ஜந ஏதாஸாம் ஆஜ்ஞாநாம் அதிக்ஷுத்³ராம் ஏகாஜ்ஞாமபீ லம்ʼக⁴தே மநுஜாம்ʼஞ்ச ததை²வ ஸி²க்ஷயதி, ஸ ஸ்வர்கீ³யராஜ்யே ஸர்வ்வேப்⁴ய​: க்ஷுத்³ரத்வேந விக்²யாஸ்யதே, கிந்து யோ ஜநஸ்தாம்ʼ பாலயதி, ததை²வ ஸி²க்ஷயதி ச, ஸ ஸ்வர்கீ³யராஜ்யே ப்ரதா⁴நத்வேந விக்²யாஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","அபரம்ʼ யுஷ்மாந் அஹம்ʼ வதா³மி, அத்⁴யாபகபி²ரூஸி²மாநவாநாம்ʼ த⁴ர்ம்மாநுஷ்டா²நாத் யுஷ்மாகம்ʼ த⁴ர்ம்மாநுஷ்டா²நே நோத்தமே ஜாதே யூயம் ஈஸ்²வரீயராஜ்யம்ʼ ப்ரவேஷ்டும்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","அபரஞ்ச த்வம்ʼ நரம்ʼ மா வதீ⁴​:, யஸ்மாத் யோ நரம்ʼ ஹந்தி, ஸ விசாரஸபா⁴யாம்ʼ த³ண்டா³ர்ஹோ ப⁴விஷ்யதி, பூர்வ்வகாலீநஜநேப்⁴ய இதி கதி²தமாஸீத், யுஷ்மாபி⁴ரஸ்²ராவி| ");
INSERT INTO santam_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, ய​: கஸ்²சித் காரணம்ʼ விநா நிஜப்⁴ராத்ரே குப்யதி, ஸ விசாரஸபா⁴யாம்ʼ த³ண்டா³ர்ஹோ ப⁴விஷ்யதி; ய​: கஸ்²சிச்ச ஸ்வீயஸஹஜம்ʼ நிர்ப்³போ³த⁴ம்ʼ வத³தி, ஸ மஹாஸபா⁴யாம்ʼ த³ண்டா³ர்ஹோ ப⁴விஷ்யதி; புநஸ்²ச த்வம்ʼ மூட⁴ இதி வாக்யம்ʼ யதி³ கஸ்²சித் ஸ்வீயப்⁴ராதரம்ʼ வக்தி, தர்ஹி நரகாக்³நௌ ஸ த³ண்டா³ர்ஹோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","அதோ வேத்³யா​: ஸமீபம்ʼ நிஜநைவேத்³யே ஸமாநீதே(அ)பி நிஜப்⁴ராதரம்ʼ ப்ரதி கஸ்மாச்சித் காரணாத் த்வம்ʼ யதி³ தோ³ஷீ வித்³யஸே, ததா³நீம்ʼ தவ தஸ்ய ஸ்ம்ருʼதி ர்ஜாயதே ச, ");
INSERT INTO santam_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","தர்ஹி தஸ்யா வேத்³யா​: ஸமீபே நிஜநைவைத்³யம்ʼ நிதா⁴ய ததை³வ க³த்வா பூர்வ்வம்ʼ தேந ஸார்த்³த⁴ம்ʼ மில, பஸ்²சாத் ஆக³த்ய நிஜநைவேத்³யம்ʼ நிவேத³ய| ");
INSERT INTO santam_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","அந்யஞ்ச யாவத் விவாதி³நா ஸார்த்³த⁴ம்ʼ வர்த்மநி திஷ்ட²ஸி, தாவத் தேந ஸார்த்³த⁴ம்ʼ மேலநம்ʼ குரு; நோ சேத் விவாதீ³ விசாரயிது​: ஸமீபே த்வாம்ʼ ஸமர்பயதி விசாரயிதா ச ரக்ஷிண​: ஸந்நிதௌ⁴ ஸமர்பயதி ததா³ த்வம்ʼ காராயாம்ʼ ப³த்⁴யேதா²​:| ");
INSERT INTO santam_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","தர்ஹி த்வாமஹம்ʼ தத்²த²ம்ʼ ப்³ரவீமி, ஸே²ஷகபர்த³கே(அ)பி ந பரிஸோ²தி⁴தே தஸ்மாத் ஸ்தா²நாத் கதா³பி ப³ஹிராக³ந்தும்ʼ ந ஸ²க்ஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","அபரம்ʼ த்வம்ʼ மா வ்யபி⁴சர, யதே³தத்³ வசநம்ʼ பூர்வ்வகாலீநலோகேப்⁴ய​: கதி²தமாஸீத், தத்³ யூயம்ʼ ஸ்²ருதவந்த​:; ");
INSERT INTO santam_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, யதி³ கஸ்²சித் காமத​: காஞ்சந யோஷிதம்ʼ பஸ்²யதி, தர்ஹி ஸ மநஸா ததை³வ வ்யபி⁴சரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","தஸ்மாத் தவ த³க்ஷிணம்ʼ நேத்ரம்ʼ யதி³ த்வாம்ʼ பா³த⁴தே, தர்ஹி தந்நேத்ரம் உத்பாட்ய தூ³ரே நிக்ஷிப, யஸ்மாத் தவ ஸர்வ்வவபுஷோ நரகே நிக்ஷேபாத் தவைகாங்க³ஸ்ய நாஸோ² வரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","யத்³வா தவ த³க்ஷிண​: கரோ யதி³ த்வாம்ʼ பா³த⁴தே, தர்ஹி தம்ʼ கரம்ʼ சி²த்த்வா தூ³ரே நிக்ஷிப, யத​: ஸர்வ்வவபுஷோ நரகே நிக்ஷேபாத் ஏகாங்க³ஸ்ய நாஸோ² வரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","உக்தமாஸ்தே, யதி³ கஸ்²சிந் நிஜஜாயாம்ʼ பரித்யக்த்தும் இச்ச²தி, தர்ஹி ஸ தஸ்யை த்யாக³பத்ரம்ʼ த³தா³து| ");
INSERT INTO santam_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","கிந்த்வஹம்ʼ யுஷ்மாந் வ்யாஹராமி, வ்யபி⁴சாரதோ³ஷே ந ஜாதே யதி³ கஸ்²சிந் நிஜஜாயாம்ʼ பரித்யஜதி, தர்ஹி ஸ தாம்ʼ வ்யபி⁴சாரயதி; யஸ்²ச தாம்ʼ த்யக்தாம்ʼ ஸ்த்ரியம்ʼ விவஹதி, ஸோபி வ்யபி⁴சரதி| ");
INSERT INTO santam_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","புநஸ்²ச த்வம்ʼ ம்ருʼஷா ஸ²பத²ம் ந குர்வ்வந் ஈஸ்²சராய நிஜஸ²பத²ம்ʼ பாலய, பூர்வ்வகாலீநலோகேப்⁴யோ யைஷா கதா² கதி²தா, தாமபி யூயம்ʼ ஸ்²ருதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, கமபி ஸ²பத²ம்ʼ மா கார்ஷ்ட, அர்த²த​: ஸ்வர்க³நாம்நா ந, யத​: ஸ ஈஸ்²வரஸ்ய ஸிம்ʼஹாஸநம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ப்ருʼதி²வ்யா நாம்நாபி ந, யத​: ஸா தஸ்ய பாத³பீட²ம்ʼ; யிரூஸா²லமோ நாம்நாபி ந, யத​: ஸா மஹாராஜஸ்ய புரீ; ");
INSERT INTO santam_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","நிஜஸி²ரோநாம்நாபி ந, யஸ்மாத் தஸ்யைகம்ʼ கசமபி ஸிதம் அஸிதம்ʼ வா கர்த்தும்ʼ த்வயா ந ஸ²க்யதே| ");
INSERT INTO santam_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","அபரம்ʼ யூயம்ʼ ஸம்ʼலாபஸமயே கேவலம்ʼ ப⁴வதீதி ந ப⁴வதீதி ச வத³த யத இதோ(அ)தி⁴கம்ʼ யத் தத் பாபாத்மநோ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","அபரம்ʼ லோசநஸ்ய விநிமயேந லோசநம்ʼ த³ந்தஸ்ய விநிமயேந த³ந்த​: பூர்வ்வக்தமித³ம்ʼ வசநஞ்ச யுஷ்மாபி⁴ரஸ்²ரூயத| ");
INSERT INTO santam_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி யூயம்ʼ ஹிம்ʼஸகம்ʼ நரம்ʼ மா வ்யாகா⁴தயத| கிந்து கேநசித் தவ த³க்ஷிணகபோலே சபேடாகா⁴தே க்ருʼதே தம்ʼ ப்ரதி வாமம்ʼ கபோலஞ்ச வ்யாகோ⁴டய| ");
INSERT INTO santam_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","அபரம்ʼ கேநசித் த்வயா ஸார்த்⁴த³ம்ʼ விவாத³ம்ʼ க்ருʼத்வா தவ பரிதே⁴யவஸநே ஜிக்⁴ருʼதிதே தஸ்மாயுத்தரீயவஸநமபி தே³ஹி| ");
INSERT INTO santam_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","யதி³ கஸ்²சித் த்வாம்ʼ க்ரோஸ²மேகம்ʼ நயநார்த²ம்ʼ அந்யாயதோ த⁴ரதி, ததா³ தேந ஸார்த்⁴த³ம்ʼ க்ரோஸ²த்³வயம்ʼ யாஹி| ");
INSERT INTO santam_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","யஸ்²ச மாநவஸ்த்வாம்ʼ யாசதே, தஸ்மை தே³ஹி, யதி³ கஸ்²சித் துப்⁴யம்ʼ தா⁴ரயிதும் இச்ச²தி, தர்ஹி தம்ʼ ப்ரதி பராம்ʼமுகோ² மா பூ⁴​:| ");
INSERT INTO santam_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","நிஜஸமீபவஸிநி ப்ரேம குரு, கிந்து ஸ²த்ரும்ʼ ப்ரதி த்³வேஷம்ʼ குரு, யதே³தத் புரோக்தம்ʼ வசநம்ʼ ஏதத³பி யூயம்ʼ ஸ்²ருதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, யூயம்ʼ ரிபுவ்வபி ப்ரேம குருத, யே ச யுஷ்மாந் ஸ²பந்தே, தாந, ஆஸி²ஷம்ʼ வத³த, யே ச யுஷ்மாந் ருʼृதீயந்தே, தேஷாம்ʼ மங்க³லம்ʼ குருத, யே ச யுஷ்மாந் நிந்த³ந்தி, தாட³யந்தி ச, தேஷாம்ʼ க்ருʼதே ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","தத்ர ய​: ஸதாமஸதாஞ்சோபரி ப்ரபா⁴கரம் உதா³யயதி, ததா² தா⁴ர்ம்மிகாநாமதா⁴ர்ம்மிகாநாஞ்சோபரி நீரம்ʼ வர்ஷயதி தாத்³ருʼஸோ² யோ யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா, யூயம்ʼ தஸ்யைவ ஸந்தாநா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","யே யுஷ்மாஸு ப்ரேம குர்வ்வந்தி, யூயம்ʼ யதி³ கேவலம்ʼ தேவ்வேவ ப்ரேம குருத², தர்ஹி யுஷ்மாகம்ʼ கிம்ʼ ப²லம்ʼ ப⁴விஷ்யதி? சண்டா³லா அபி தாத்³ருʼஸ²ம்ʼ கிம்ʼ ந குர்வ்வந்தி? ");
INSERT INTO santam_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","அபரம்ʼ யூயம்ʼ யதி³ கேவலம்ʼ ஸ்வீயப்⁴ராத்ருʼத்வேந நமத, தர்ஹி கிம்ʼ மஹத் கர்ம்ம குருத²? சண்டா³லா அபி தாத்³ருʼஸ²ம்ʼ கிம்ʼ ந குர்வ்வந்தி? ");
INSERT INTO santam_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","தஸ்மாத் யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா யதா² பூர்ணோ ப⁴வதி, யூயமபி தாத்³ருʼஸா² ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ஸாவதா⁴நா ப⁴வத, மநுஜாந் த³ர்ஸ²யிதும்ʼ தேஷாம்ʼ கோ³சரே த⁴ர்ம்மகர்ம்ம மா குருத, ததா² க்ருʼதே யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²பிது​: ஸகாஸா²த் கிஞ்சந ப²லம்ʼ ந ப்ராப்ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","த்வம்ʼ யதா³ த³தா³ஸி ததா³ கபடிநோ ஜநா யதா² மநுஜேப்⁴ய​: ப்ரஸ²ம்ʼஸாம்ʼ ப்ராப்தும்ʼ ப⁴ஜநப⁴வநே ராஜமார்கே³ ச தூரீம்ʼ வாத³யந்தி, ததா² மா குரிु, அஹம்ʼ துப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி, தே ஸ்வகாயம்ʼ ப²லம் அலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","கிந்து த்வம்ʼ யதா³ த³தா³ஸி, ததா³ நிஜத³க்ஷிணகரோ யத் கரோதி, தத்³ வாமகரம்ʼ மா ஜ்ஞாபய| ");
INSERT INTO santam_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","தேந தவ தா³நம்ʼ கு³ப்தம்ʼ ப⁴விஷ்யதி யஸ்து தவ பிதா கு³ப்தத³ர்ஸீ², ஸ ப்ரகாஸ்²ய துப்⁴யம்ʼ ப²லம்ʼ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","அபரம்ʼ யதா³ ப்ரார்த²யஸே, ததா³ கபடிநஇவ மா குரு, யஸ்மாத் தே ப⁴ஜநப⁴வநே ராஜமார்க³ஸ்ய கோணே திஷ்ட²ந்தோ லோகாந் த³ர்ஸ²யந்த​: ப்ரார்த²யிதும்ʼ ப்ரீயந்தே; அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி, தே ஸ்வகீயப²லம்ʼ ப்ராப்நுவந்| ");
INSERT INTO santam_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","தஸ்மாத் ப்ரார்த²நாகாலே அந்தராகா³ரம்ʼ ப்ரவிஸ்²ய த்³வாரம்ʼ ருத்³வ்வா கு³ப்தம்ʼ பஸ்²யதஸ்தவ பிது​: ஸமீபே ப்ரார்த²யஸ்வ; தேந தவ ய​: பிதா கு³ப்தத³ர்ஸீ², ஸ ப்ரகாஸ்²ய துப்⁴யம்ʼ ப²லம்ʼ தா³ஸ்யதிl ");
INSERT INTO santam_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","அபரம்ʼ ப்ரார்த²நாகாலே தே³வபூஜகாஇவ முதா⁴ புநருக்திம்ʼ மா குரு, யஸ்மாத் தே போ³த⁴ந்தே, ப³ஹுவாரம்ʼ கதா²யாம்ʼ கதி²தாயாம்ʼ தேஷாம்ʼ ப்ரார்த²நா க்³ராஹிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","யூயம்ʼ தேஷாமிவ மா குருத, யஸ்மாத் யுஷ்மாகம்ʼ யத்³ யத் ப்ரயோஜநம்ʼ யாசநாத​: ப்ராகே³வ யுஷ்மாகம்ʼ பிதா தத் ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","அதஏவ யூயம ஈத்³ருʼக் ப்ரார்த²யத்⁴வம்ʼ, ஹே அஸ்மாகம்ʼ ஸ்வர்க³ஸ்த²பித​:, தவ நாம பூஜ்யம்ʼ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","தவ ராஜத்வம்ʼ ப⁴வது; தவேச்சா² ஸ்வர்கே³ யதா² ததை²வ மேதி³ந்யாமபி ஸப²லா ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","அஸ்மாகம்ʼ ப்ரயோஜநீயம் ஆஹாரம் அத்³ய தே³ஹி| ");
INSERT INTO santam_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","வயம்ʼ யதா² நிஜாபராதி⁴ந​: க்ஷமாமஹே, ததை²வாஸ்மாகம் அபராதா⁴ந் க்ஷமஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","அஸ்மாந் பரீக்ஷாம்ʼ மாநய, கிந்து பாபாத்மநோ ரக்ஷ; ராஜத்வம்ʼ கௌ³ரவம்ʼ பராக்ரம​: ஏதே ஸர்வ்வே ஸர்வ்வதா³ தவ; ததா²ஸ்து| ");
INSERT INTO santam_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","யதி³ யூயம் அந்யேஷாம் அபராதா⁴ந் க்ஷமத்⁴வே தர்ஹி யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²பிதாபி யுஷ்மாந் க்ஷமிஷ்யதே; ");
INSERT INTO santam_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","கிந்து யதி³ யூயம் அந்யேஷாம் அபராதா⁴ந் ந க்ஷமத்⁴வே, தர்ஹி யுஷ்மாகம்ʼ ஜநகோபி யுஷ்மாகம் அபராதா⁴ந் ந க்ஷமிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","அபரம் உபவாஸகாலே கபடிநோ ஜநா மாநுஷாந் உபவாஸம்ʼ ஜ்ஞாபயிதும்ʼ ஸ்வேஷாம்ʼ வத³நாநி ம்லாநாநி குர்வ்வந்தி, யூயம்ʼ தஇவ விஷணவத³நா மா ப⁴வத; அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி தே ஸ்வகீயப²லம் அலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","யதா³ த்வம் உபவஸஸி, ததா³ யதா² லோகைஸ்த்வம்ʼ உபவாஸீவ ந த்³ருʼஸ்²யஸே, கிந்து தவ யோ(அ)கோ³சர​: பிதா தேநைவ த்³ருʼஸ்²யஸே, தத்க்ருʼதே நிஜஸி²ரஸி தைலம்ʼ மர்த்³த³ய வத³நஞ்ச ப்ரக்ஷாலய; ");
INSERT INTO santam_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","தேந தவ ய​: பிதா கு³ப்தத³ர்ஸீ² ஸ ப்ரகாஸ்²ய துப்⁴யம்ʼ ப²லம்ʼ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","அபரம்ʼ யத்ர ஸ்தா²நே கீடா​: கலங்காஸ்²ச க்ஷயம்ʼ நயந்தி, சௌராஸ்²ச ஸந்தி⁴ம்ʼ கர்த்தயித்வா சோரயிதும்ʼ ஸ²க்நுவந்தி, தாத்³ருʼஸ்²யாம்ʼ மேதி³ந்யாம்ʼ ஸ்வார்த²ம்ʼ த⁴நம்ʼ மா ஸம்ʼசிநுத| ");
INSERT INTO santam_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","கிந்து யத்ர ஸ்தா²நே கீடா​: கலங்காஸ்²ச க்ஷயம்ʼ ந நயந்தி, சௌராஸ்²ச ஸந்தி⁴ம்ʼ கர்த்தயித்வா சோரயிதும்ʼ ந ஸ²க்நுவந்தி, தாத்³ருʼஸே² ஸ்வர்கே³ த⁴நம்ʼ ஸஞ்சிநுத| ");
INSERT INTO santam_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","யஸ்மாத் யத்ர ஸ்தா²நே யுஷ்மாம்ʼக த⁴நம்ʼ தத்ரைவ கா²நே யுஷ்மாகம்ʼ மநாம்ʼஸி| ");
INSERT INTO santam_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","லோசநம்ʼ தே³ஹஸ்ய ப்ரதீ³பகம்ʼ, தஸ்மாத் யதி³ தவ லோசநம்ʼ ப்ரஸந்நம்ʼ ப⁴வதி, தர்ஹி தவ க்ருʼத்ஸ்நம்ʼ வபு ர்தீ³ப்தியுக்தம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","கிந்து லோசநே(அ)ப்ரஸந்நே தவ க்ருʼத்ஸ்நம்ʼ வபு​: தமிஸ்ரயுக்தம்ʼ ப⁴விஷ்யதி| அதஏவ யா தீ³ப்திஸ்த்வயி வித்³யதே, ஸா யதி³ தமிஸ்ரயுக்தா ப⁴வதி, தர்ஹி தத் தமிஸ்ரம்ʼ கியந் மஹத்| ");
INSERT INTO santam_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","கோபி மநுஜோ த்³வௌ ப்ரபூ⁴ ஸேவிதும்ʼ ந ஸ²க்நோதி, யஸ்மாத்³ ஏகம்ʼ ஸம்ʼமந்ய தத³ந்யம்ʼ ந ஸம்மந்யதே, யத்³வா ஏகத்ர மநோ நிதா⁴ய தத³ந்யம் அவமந்யதே; ததா² யூயமபீஸ்²வரம்ʼ லக்ஷ்மீஞ்சேத்யுபே⁴ ஸேவிதும்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","அபரம் அஹம்ʼ யுஷ்மப்⁴யம்ʼ தத்²யம்ʼ கத²யாமி, கிம்ʼ ப⁴க்ஷிஷ்யாம​:? கிம்ʼ பாஸ்யாம​:? இதி ப்ராணதா⁴ரணாய மா சிந்தயத; கிம்ʼ பரிதா⁴ஸ்யாம​:? இதி காயரக்ஷணாய ந சிந்தயத; ப⁴க்ஷ்யாத் ப்ராணா வஸநாஞ்ச வபூம்ʼஷி கிம்ʼ ஸ்²ரேஷ்டா²ணி ந ஹி? ");
INSERT INTO santam_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","விஹாயஸோ விஹங்க³மாந் விலோகயத; தை ர்நோப்யதே ந க்ருʼத்யதே பா⁴ண்டா³கா³ரே ந ஸஞ்சீயதே(அ)பி; ததா²பி யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா தேப்⁴ய ஆஹாரம்ʼ விதரதி| ");
INSERT INTO santam_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","யூயம்ʼ தேப்⁴ய​: கிம்ʼ ஸ்²ரேஷ்டா² ந ப⁴வத²? யுஷ்மாகம்ʼ கஸ்²சித் மநுஜ​: சிந்தயந் நிஜாயுஷ​: க்ஷணமபி வர்த்³த⁴யிதும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","அபரம்ʼ வஸநாய குதஸ்²சிந்தயத? க்ஷேத்ரோத்பந்நாநி புஷ்பாணி கத²ம்ʼ வர்த்³த⁴ந்தே ததா³லோசயத| தாநி தந்தூந் நோத்பாத³யந்தி கிமபி கார்ய்யம்ʼ ந குர்வ்வந்தி; ");
INSERT INTO santam_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ததா²ப்யஹம்ʼ யுஷ்மாந் வதா³மி, ஸுலேமாந் தாத்³ருʼக்³ ஐஸ்²வர்ய்யவாநபி தத்புஷ்பமிவ விபூ⁴ஷிதோ நாஸீத்| ");
INSERT INTO santam_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","தஸ்மாத் க்ஷத்³ய வித்³யமாநம்ʼ ஸ்²ச​: சுல்ல்யாம்ʼ நிக்ஷேப்ஸ்யதே தாத்³ருʼஸ²ம்ʼ யத் க்ஷேத்ரஸ்தி²தம்ʼ குஸுமம்ʼ தத் யதீ³ஸ்²சர இத்த²ம்ʼ பி³பூ⁴ஷயதி, தர்ஹி ஹே ஸ்தோகப்ரத்யயிநோ யுஷ்மாந் கிம்ʼ ந பரிதா⁴பயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","தஸ்மாத் அஸ்மாபி⁴​: கிமத்ஸ்யதே? கிஞ்ச பாயிஷ்யதே? கிம்ʼ வா பரிதா⁴யிஷ்யதே, இதி ந சிந்தயத| ");
INSERT INTO santam_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","யஸ்மாத் தே³வார்ச்சகா அபீதி சேஷ்டந்தே; ஏதேஷு த்³ரவ்யேஷு ப்ரயோஜநமஸ்தீதி யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","அதஏவ ப்ரத²மத ஈஸ்²வரீயராஜ்யம்ʼ த⁴ர்ம்மஞ்ச சேஷ்டத்⁴வம்ʼ, தத ஏதாநி வஸ்தூநி யுஷ்மப்⁴யம்ʼ ப்ரதா³யிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ஸ்²வ​: க்ருʼதே மா சிந்தயத, ஸ்²வஏவ ஸ்வயம்ʼ ஸ்வமுத்³தி³ஸ்²ய சிந்தயிஷ்யதி; அத்³யதநீ யா சிந்தா ஸாத்³யக்ருʼதே ப்ரசுரதரா| ");
INSERT INTO santam_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","யதா² யூயம்ʼ தோ³ஷீக்ருʼதா ந ப⁴வத², தத்க்ருʼதே(அ)ந்யம்ʼ தோ³ஷிணம்ʼ மா குருத| ");
INSERT INTO santam_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","யதோ யாத்³ருʼஸே²ந தோ³ஷேண யூயம்ʼ பராந் தோ³ஷிண​: குருத², தாத்³ருʼஸே²ந தோ³ஷேண யூயமபி தோ³ஷீக்ருʼதா ப⁴விஷ்யத², அந்யஞ்ச யேந பரிமாணேந யுஷ்மாபி⁴​: பரிமீயதே, தேநைவ பரிமாணேந யுஷ்மத்க்ருʼதே பரிமாயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","அபரஞ்ச நிஜநயநே யா நாஸா வித்³யதே, தாம் அநாலோச்ய தவ ஸஹஜஸ்ய லோசநே யத் த்ருʼணம் ஆஸ்தே, ததே³வ குதோ வீக்ஷஸே? ");
INSERT INTO santam_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","தவ நிஜலோசநே நாஸாயாம்ʼ வித்³யமாநாயாம்ʼ, ஹே ப்⁴ராத​:, தவ நயநாத் த்ருʼணம்ʼ ப³ஹிஷ்யர்தும்ʼ அநுஜாநீஹி, கதா²மேதாம்ʼ நிஜஸஹஜாய கத²ம்ʼ கத²யிதும்ʼ ஸ²க்நோஷி? ");
INSERT INTO santam_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ஹே கபடிந், ஆதௌ³ நிஜநயநாத் நாஸாம்ʼ ப³ஹிஷ்குரு ததோ நிஜத்³ருʼஷ்டௌ ஸுப்ரஸந்நாயாம்ʼ தவ ப்⁴ராத்ருʼ ர்லோசநாத் த்ருʼணம்ʼ ப³ஹிஷ்கர்தும்ʼ ஸ²க்ஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","அந்யஞ்ச ஸாரமேயேப்⁴ய​: பவித்ரவஸ்தூநி மா விதரத, வராஹாணாம்ʼ ஸமக்ஷஞ்ச முக்தா மா நிக்ஷிபத; நிக்ஷேபணாத் தே தா​: ஸர்வ்வா​: பதை³ ர்த³லயிஷ்யந்தி, பராவ்ருʼத்ய யுஷ்மாநபி விதா³ரயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","யாசத்⁴வம்ʼ ததோ யுஷ்மப்⁴யம்ʼ தா³யிஷ்யதே; ம்ருʼக³யத்⁴வம்ʼ தத உத்³தே³ஸ²ம்ʼ லப்ஸ்யத்⁴வே; த்³வாரம் ஆஹத, ததோ யுஷ்மத்க்ருʼதே முக்தம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","யஸ்மாத்³ யேந யாச்யதே, தேந லப்⁴யதே; யேந ம்ருʼக்³யதே தேநோத்³தே³ஸ²​: ப்ராப்யதே; யேந ச த்³வாரம் ஆஹந்யதே, தத்க்ருʼதே த்³வாரம்ʼ மோச்யதே| ");
INSERT INTO santam_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ஆத்மஜேந பூபே ப்ரார்தி²தே தஸ்மை பாஷாணம்ʼ விஸ்²ராணயதி, ");
INSERT INTO santam_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","மீநே யாசிதே ச தஸ்மை பு⁴ஜக³ம்ʼ விதரதி, ஏதாத்³ருʼஸ²​: பிதா யுஷ்மாகம்ʼ மத்⁴யே க ஆஸ்தே? ");
INSERT INTO santam_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","தஸ்மாத்³ யூயம் அப⁴த்³ரா​: ஸந்தோ(அ)பி யதி³ நிஜபா³லகேப்⁴ய உத்தமம்ʼ த்³ரவ்யம்ʼ தா³தும்ʼ ஜாநீத², தர்ஹி யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா ஸ்வீயயாசகேப்⁴ய​: கிமுத்தமாநி வஸ்தூநி ந தா³ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","யூஷ்மாந் ப்ரதீதரேஷாம்ʼ யாத்³ருʼஸோ² வ்யவஹாரோ யுஷ்மாகம்ʼ ப்ரிய​:, யூயம்ʼ தாந் ப்ரதி தாத்³ருʼஸா²நேவ வ்யவஹாராந் வித⁴த்த; யஸ்மாத்³ வ்யவஸ்தா²ப⁴விஷ்யத்³வாதி³நாம்ʼ வசநாநாம் இதி ஸாரம்| ");
INSERT INTO santam_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ஸங்கீர்ணத்³வாரேண ப்ரவிஸ²த; யதோ நரகக³மநாய யத்³ த்³வாரம்ʼ தத்³ விஸ்தீர்ணம்ʼ யச்ச வர்த்ம தத்³ ப்³ருʼஹத் தேந ப³ஹவ​: ப்ரவிஸ²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","அபரம்ʼ ஸ்வர்க³க³மநாய யத்³ த்³வாரம்ʼ தத் கீத்³ருʼக் ஸம்ʼகீர்ணம்ʼ| யச்ச வர்த்ம தத் கீத்³ருʼக்³ து³ர்க³மம்| தது³த்³தே³ஷ்டார​: கியந்தோ(அ)ல்பா​:| ");
INSERT INTO santam_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","அபரஞ்ச யே ஜநா மேஷவேஸே²ந யுஷ்மாகம்ʼ ஸமீபம் ஆக³ச்ச²ந்தி, கிந்த்வந்தர்து³ரந்தா வ்ருʼகா ஏதாத்³ருʼஸே²ப்⁴யோ ப⁴விஷ்யத்³வாதி³ப்⁴ய​: ஸாவதா⁴நா ப⁴வத, யூயம்ʼ ப²லேந தாந் பரிசேதும்ʼ ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","மநுஜா​: கிம்ʼ கண்டகிநோ வ்ருʼக்ஷாத்³ த்³ராக்ஷாப²லாநி ஸ்²ருʼகா³லகோலிதஸ்²ச உடு³ம்ப³ரப²லாநி ஸா²தயந்தி? ");
INSERT INTO santam_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","தத்³வத்³ உத்தம ஏவ பாத³ப உத்தமப²லாநி ஜநயதி, அத⁴மபாத³பஏவாத⁴மப²லாநி ஜநயதி| ");
INSERT INTO santam_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","கிந்தூத்தமபாத³ப​: கதா³ப்யத⁴மப²லாநி ஜநயிதும்ʼ ந ஸ²க்நோதி, ததா²த⁴மோபி பாத³ப உத்தமப²லாநி ஜநயிதும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","அபரம்ʼ யே யே பாத³பா அத⁴மப²லாநி ஜநயந்தி, தே க்ருʼத்தா வஹ்நௌ க்ஷிப்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","அதஏவ யூயம்ʼ ப²லேந தாந் பரிசேஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","யே ஜநா மாம்ʼ ப்ரபு⁴ம்ʼ வத³ந்தி, தே ஸர்வ்வே ஸ்வர்க³ராஜ்யம்ʼ ப்ரவேக்ஷ்யந்தி தந்ந, கிந்து யோ மாநவோ மம ஸ்வர்க³ஸ்த²ஸ்ய பிதுரிஷ்டம்ʼ கர்ம்ம கரோதி ஸ ஏவ ப்ரவேக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","தத்³ தி³நே ப³ஹவோ மாம்ʼ வதி³ஷ்யந்தி, ஹே ப்ரபோ⁴ ஹே ப்ரபோ⁴, தவ நாம்நா கிமஸ்மாமி ர்ப⁴விஷ்யத்³வாக்யம்ʼ ந வ்யாஹ்ருʼதம்ʼ? தவ நாம்நா பூ⁴தா​: கிம்ʼ ந த்யாஜிதா​:? தவ நாம்நா கிம்ʼ நாநாத்³பு⁴தாநி கர்ம்மாணி ந க்ருʼதாநி? ");
INSERT INTO santam_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ததா³ஹம்ʼ வதி³ஷ்யாமி, ஹே குகர்ம்மகாரிணோ யுஷ்மாந் அஹம்ʼ ந வேத்³மி, யூயம்ʼ மத்ஸமீபாத்³ தூ³ரீப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ய​: கஸ்²சித் மமைதா​: கதா²​: ஸ்²ருத்வா பாலயதி, ஸ பாஷாணோபரி க்³ருʼஹநிர்ம்மாத்ரா ஜ்ஞாநிநா ஸஹ மயோபமீயதே| ");
INSERT INTO santam_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","யதோ வ்ருʼஷ்டௌ ஸத்யாம் ஆப்லாவ ஆக³தே வாயௌ வாதே ச தேஷு தத்³கே³ஹம்ʼ லக்³நேஷு பாஷாணோபரி தஸ்ய பி⁴த்தேஸ்தந்ந பததிl ");
INSERT INTO santam_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","கிந்து ய​: கஸ்²சித் மமைதா​: கதா²​: ஸ்²ருத்வா ந பாலயதி ஸ ஸைகதே கே³ஹநிர்ம்மாத்ரா (அ)ஜ்ஞாநிநா உபமீயதே| ");
INSERT INTO santam_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","யதோ ஜலவ்ருʼஷ்டௌ ஸத்யாம் ஆப்லாவ ஆக³தே பவநே வாதே ச தை ர்க்³ருʼஹே ஸமாகா⁴தே தத் பததி தத்பதநம்ʼ மஹத்³ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","யீஸு²நைதேஷு வாக்யேஷு ஸமாபிதேஷு மாநவாஸ்ததீ³யோபதே³ஸ²ம் ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","யஸ்மாத் ஸ உபாத்⁴யாயா இவ தாந் நோபதி³தே³ஸ² கிந்து ஸமர்த²புருஷஇவ ஸமுபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","யதா³ ஸ பர்வ்வதாத்³ அவாரோஹத் ததா³ ப³ஹவோ மாநவாஸ்தத்பஸ்²சாத்³ வவ்ரஜு​:| ");
INSERT INTO santam_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ஏக​: குஷ்ட²வாந் ஆக³த்ய தம்ʼ ப்ரணம்ய ப³பா⁴ஷே, ஹே ப்ரபோ⁴, யதி³ ப⁴வாந் ஸம்ʼமந்யதே, தர்ஹி மாம்ʼ நிராமயம்ʼ கர்த்தும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ததோ யீஸு²​: கரம்ʼ ப்ரஸார்ய்ய தஸ்யாங்க³ம்ʼ ஸ்ப்ருʼஸ²ந் வ்யாஜஹார, ஸம்மந்யே(அ)ஹம்ʼ த்வம்ʼ நிராமயோ ப⁴வ; தேந ஸ தத்க்ஷணாத் குஷ்டே²நாமோசி| ");
INSERT INTO santam_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ததோ யீஸு²ஸ்தம்ʼ ஜகா³த³, அவதே⁴ஹி கதா²மேதாம்ʼ கஸ்²சித³பி மா ப்³ரூஹி, கிந்து யாஜகஸ்ய ஸந்நிதி⁴ம்ʼ க³த்வா ஸ்வாத்மாநம்ʼ த³ர்ஸ²ய மநுஜேப்⁴யோ நிஜநிராமயத்வம்ʼ ப்ரமாணயிதும்ʼ மூஸாநிரூபிதம்ʼ த்³ரவ்யம் உத்ஸ்ருʼஜ ச| ");
INSERT INTO santam_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","தத³நந்தரம்ʼ யீஸு²நா கப²ர்நாஹூம்நாமநி நக³ரே ப்ரவிஷ்டே கஸ்²சித் ஸ²தஸேநாபதிஸ்தத்ஸமீபம் ஆக³த்ய விநீய ப³பா⁴ஷே, ");
INSERT INTO santam_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ஹே ப்ரபோ⁴, மதீ³ய ஏகோ தா³ஸ​: பக்ஷாகா⁴தவ்யாதி⁴நா ப்⁴ருʼஸ²ம்ʼ வ்யதி²த​:, ஸது ஸ²யநீய ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ததா³நீம்ʼ யீஸு²ஸ்தஸ்மை கதி²தவாந், அஹம்ʼ க³த்வா தம்ʼ நிராமயம்ʼ கரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","தத​: ஸ ஸ²தஸேநாபதி​: ப்ரத்யவத³த், ஹே ப்ரபோ⁴, ப⁴வாந் யத் மம கே³ஹமத்⁴யம்ʼ யாதி தத்³யோக்³யபா⁴ஜநம்ʼ நாஹமஸ்மி; வாங்மாத்ரம் ஆதி³ஸ²து, தேநைவ மம தா³ஸோ நிராமயோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","யதோ மயி பரநித்⁴நே(அ)பி மம நிதே³ஸ²வஸ்²யா​: கதி கதி ஸேநா​: ஸந்தி, தத ஏகஸ்மிந் யாஹீத்யுக்தே ஸ யாதி, தத³ந்யஸ்மிந் ஏஹீத்யுக்தே ஸ ஆயாதி, ததா² மம நிஜதா³ஸே கர்ம்மைதத் குர்வ்வித்யுக்தே ஸ தத் கரோதி| ");
INSERT INTO santam_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ததா³நீம்ʼ யீஸு²ஸ்தஸ்யைதத் வசோ நிஸ²ம்ய விஸ்மயாபந்நோ(அ)பூ⁴த்; நிஜபஸ்²சாத்³கா³மிநோ மாநவாந் அவோச்ச, யுஷ்மாந் தத்²யம்ʼ வச்மி, இஸ்ராயேலீயலோகாநாம்ʼ மத்⁴யே(அ)பி நைதாத்³ருʼஸோ² விஸ்²வாஸோ மயா ப்ராப்த​:| ");
INSERT INTO santam_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","அந்யச்சாஹம்ʼ யுஷ்மாந் வதா³மி, ப³ஹவ​: பூர்வ்வஸ்யா​: பஸ்²சிமாயாஸ்²ச தி³ஸ² ஆக³த்ய இப்³ராஹீமா இஸ்ஹாகா யாகூபா³ ச ஸாகம் மிலித்வா ஸமுபவேக்ஷ்யந்தி; ");
INSERT INTO santam_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","கிந்து யத்ர ஸ்தா²நே ரோத³நத³ந்தக⁴ர்ஷணே ப⁴வதஸ்தஸ்மிந் ப³ஹிர்பூ⁴ததமிஸ்ரே ராஜ்யஸ்ய ஸந்தாநா நிக்ஷேஸ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","தத​: பரம்ʼ யீஸு²ஸ்தம்ʼ ஸ²தஸேநாபதிம்ʼ ஜகா³த³, யாஹி, தவ ப்ரதீத்யநுஸாரதோ மங்க³லம்ʼ பூ⁴யாத்; ததா³ தஸ்மிந்நேவ த³ண்டே³ ததீ³யதா³ஸோ நிராமயோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","அநந்தரம்ʼ யீஸு²​: பிதரஸ்ய கே³ஹமுபஸ்தா²ய ஜ்வரேண பீடி³தாம்ʼ ஸ²யநீயஸ்தி²தாம்ʼ தஸ்ய ஸ்²வஸ்²ரூம்ʼ வீக்ஷாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ததஸ்தேந தஸ்யா​: கரஸ்ய ஸ்ப்ருʼஷ்டதவாத் ஜ்வரஸ்தாம்ʼ தத்யாஜ, ததா³ ஸா ஸமுத்தா²ய தாந் ஸிஷேவே| ");
INSERT INTO santam_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","அநந்தரம்ʼ ஸந்த்⁴யாயாம்ʼ ஸத்யாம்ʼ ப³ஹுஸோ² பூ⁴தக்³ரஸ்தமநுஜாந் தஸ்ய ஸமீபம் ஆநிந்யு​: ஸ ச வாக்யேந பூ⁴தாந் த்யாஜயாமாஸ, ஸர்வ்வப்ரகாரபீடி³தஜநாம்ʼஸ்²ச நிராமயாந் சகார; ");
INSERT INTO santam_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","தஸ்மாத், ஸர்வ்வா து³ர்ப்³ப³லதாஸ்மாகம்ʼ தேநைவ பரிதா⁴ரிதா| அஸ்மாகம்ʼ ஸகலம்ʼ வ்யாதி⁴ம்ʼ ஸஏவ ஸம்ʼக்³ருʼஹீதவாந்| யதே³தத்³வசநம்ʼ யிஸ²யியப⁴விஷ்யத்³வாதி³நோக்தமாஸீத், தத்ததா³ ஸப²லமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","அநந்தரம்ʼ யீஸு²ஸ்²சதுர்தி³க்ஷு ஜநநிவஹம்ʼ விலோக்ய தடிந்யா​: பாரம்ʼ யாதும்ʼ ஸி²ஷ்யாந் ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ததா³நீம் ஏக உபாத்⁴யாய ஆக³த்ய கதி²தவாந், ஹே கு³ரோ, ப⁴வாந் யத்ர யாஸ்யதி தத்ராஹமபி ப⁴வத​: பஸ்²சாத்³ யாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ததோ யீஸு² ர்ஜகா³த³, க்ரோஷ்டு​: ஸ்தா²தும்ʼ ஸ்தா²நம்ʼ வித்³யதே, விஹாயஸோ விஹங்க³மாநாம்ʼ நீடா³நி ச ஸந்தி; கிந்து மநுஷ்யபுத்ரஸ்ய ஸி²ர​: ஸ்தா²பயிதும்ʼ ஸ்தா²நம்ʼ ந வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","அநந்தரம் அபர ஏக​: ஸி²ஷ்யஸ்தம்ʼ ப³பா⁴ஷே, ஹே ப்ரபோ⁴, ப்ரத²மதோ மம பிதரம்ʼ ஸ்²மஸா²நே நிதா⁴தும்ʼ க³மநார்த²ம்ʼ மாம் அநுமந்யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ததோ யீஸு²ருக்தவாந் ம்ருʼதா ம்ருʼதாந் ஸ்²மஸா²நே நித³த⁴து, த்வம்ʼ மம பஸ்²சாத்³ ஆக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","அநந்தரம்ʼ தஸ்மிந் நாவமாரூடே⁴ தஸ்ய ஸி²ஷ்யாஸ்தத்பஸ்²சாத் ஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","பஸ்²சாத் ஸாக³ரஸ்ய மத்⁴யம்ʼ தேஷு க³தேஷு தாத்³ருʼஸ²​: ப்ரப³லோ ஜ²ஞ்ப்⁴ஸ²நில உத³திஷ்ட²த், யேந மஹாதரங்க³ உத்தா²ய தரணிம்ʼ சா²தி³தவாந், கிந்து ஸ நித்³ரித ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ததா³ ஸி²ஷ்யா ஆக³த்ய தஸ்ய நித்³ராப⁴ங்க³ம்ʼ க்ருʼத்வா கத²யாமாஸு​:, ஹே ப்ரபோ⁴, வயம்ʼ ம்ரியாமஹே, ப⁴வாந் அஸ்மாகம்ʼ ப்ராணாந் ரக்ஷது| ");
INSERT INTO santam_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ததா³ ஸ தாந் உக்தவாந், ஹே அல்பவிஸ்²வாஸிநோ யூயம்ʼ குதோ விபீ⁴த²? தத​: ஸ உத்தா²ய வாதம்ʼ ஸாக³ரஞ்ச தர்ஜயாமாஸ, ததோ நிர்வ்வாதமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","அபரம்ʼ மநுஜா விஸ்மயம்ʼ விலோக்ய கத²யாமாஸு​:, அஹோ வாதஸரித்பதீ அஸ்ய கிமாஜ்ஞாக்³ராஹிணௌ? கீத்³ருʼஸோ²(அ)யம்ʼ மாநவ​:| ");
INSERT INTO santam_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","அநந்தரம்ʼ ஸ பாரம்ʼ க³த்வா கி³தே³ரீயதே³ஸ²ம் உபஸ்தி²தவாந்; ததா³ த்³வௌ பூ⁴தக்³ரஸ்தமநுஜௌ ஸ்²மஸா²நஸ்தா²நாத்³ ப³ஹி ர்பூ⁴த்வா தம்ʼ ஸாக்ஷாத் க்ருʼதவந்தௌ, தாவேதாத்³ருʼஸௌ² ப்ரசண்டா³வாஸ்தாம்ʼ யத் தேந ஸ்தா²நேந கோபி யாதும்ʼ நாஸ²க்நோத்| ");
INSERT INTO santam_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","தாவுசை​: கத²யாமாஸது​:, ஹே ஈஸ்²வரஸ்ய ஸூநோ யீஸோ², த்வயா ஸாகம் ஆவயோ​: க​: ஸம்ப³ந்த⁴​:? நிரூபிதகாலாத் ப்ராகே³வ கிமாவாப்⁴யாம்ʼ யாதநாம்ʼ தா³தும் அத்ராக³தோஸி? ");
INSERT INTO santam_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ததா³நீம்ʼ தாப்⁴யாம்ʼ கிஞ்சித்³ தூ³ரே வராஹாணாம் ஏகோ மஹாவ்ரஜோ(அ)சரத்| ");
INSERT INTO santam_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ததோ பூ⁴தௌ தௌ தஸ்யாந்திகே விநீய கத²யாமாஸது​:, யத்³யாவாம்ʼ த்யாஜயஸி, தர்ஹி வராஹாணாம்ʼ மத்⁴யேவ்ரஜம் ஆவாம்ʼ ப்ரேரய| ");
INSERT INTO santam_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ததா³ யீஸு²ரவத³த் யாதம்ʼ, அநந்தரம்ʼ தௌ யதா³ மநுஜௌ விஹாய வராஹாந் ஆஸ்²ரிதவந்தௌ, ததா³ தே ஸர்வ்வே வராஹா உச்சஸ்தா²நாத் மஹாஜவேந தா⁴வந்த​: ஸாக³ரீயதோயே மஜ்ஜந்தோ மம்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ததோ வராஹரக்ஷகா​: பலாயமாநா மத்⁴யேநக³ரம்ʼ தௌ பூ⁴தக்³ரஸ்தௌ ப்ரதி யத்³யத்³ அக⁴டத, தா​: ஸர்வ்வவார்த்தா அவத³ந்| ");
INSERT INTO santam_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ததோ நாக³ரிகா​: ஸர்வ்வே மநுஜா யீஸு²ம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ ப³ஹிராயாதா​: தஞ்ச விலோக்ய ப்ரார்த²யாஞ்சக்ரிரே ப⁴வாந் அஸ்மாகம்ʼ ஸீமாதோ யாது| ");
INSERT INTO santam_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","அநந்தரம்ʼ யீஸு² ர்நௌகாமாருஹ்ய புந​: பாரமாக³த்ய நிஜக்³ராமம் ஆயயௌ| ");
INSERT INTO santam_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","தத​: கதிபயா ஜநா ஏகம்ʼ பக்ஷாகா⁴திநம்ʼ ஸ்வட்டோபரி ஸா²யயித்வா தத்ஸமீபம் ஆநயந்; ததோ யீஸு²ஸ்தேஷாம்ʼ ப்ரதீதிம்ʼ விஜ்ஞாய தம்ʼ பக்ஷாகா⁴திநம்ʼ ஜகா³த³, ஹே புத்ர, ஸுஸ்தி²ரோ ப⁴வ, தவ கலுஷஸ்ய மர்ஷணம்ʼ ஜாதம்| ");
INSERT INTO santam_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","தாம்ʼ கதா²ம்ʼ நிஸ²ம்ய கியந்த உபாத்⁴யாயா மந​:ஸு சிந்திதவந்த ஏஷ மநுஜ ஈஸ்²வரம்ʼ நிந்த³தி| ");
INSERT INTO santam_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","தத​: ஸ தேஷாம் ஏதாத்³ருʼஸீ²ம்ʼ சிந்தாம்ʼ விஜ்ஞாய கதி²தவாந், யூயம்ʼ மந​:ஸு க்ருʼத ஏதாத்³ருʼஸீ²ம்ʼ குசிந்தாம்ʼ குருத²? ");
INSERT INTO santam_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","தவ பாபமர்ஷணம்ʼ ஜாதம்ʼ, யத்³வா த்வமுத்தா²ய க³ச்ச², த்³வயோரநயோ ர்வாக்யயோ​: கிம்ʼ வாக்யம்ʼ வக்தும்ʼ ஸுக³மம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","கிந்து மேதி³ந்யாம்ʼ கலுஷம்ʼ க்ஷமிதும்ʼ மநுஜஸுதஸ்ய ஸாமர்த்²யமஸ்தீதி யூயம்ʼ யதா² ஜாநீத², தத³ர்த²ம்ʼ ஸ தம்ʼ பக்ஷாகா⁴திநம்ʼ க³தி³தவாந், உத்திஷ்ட², நிஜஸ²யநீயம்ʼ ஆதா³ய கே³ஹம்ʼ க³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","தத​: ஸ தத்க்ஷணாத்³ உத்தா²ய நிஜகே³ஹம்ʼ ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","மாநவா இத்த²ம்ʼ விலோக்ய விஸ்மயம்ʼ மேநிரே, ஈஸ்²வரேண மாநவாய ஸாமர்த்²யம் ஈத்³ருʼஸ²ம்ʼ த³த்தம்ʼ இதி காரணாத் தம்ʼ த⁴ந்யம்ʼ ப³பா⁴ஷிரே ச| ");
INSERT INTO santam_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","அநந்தரம்ʼ யீஸு²ஸ்தத்ஸ்தா²நாத்³ க³ச்ச²ந் க³ச்ச²ந் கரஸம்ʼக்³ரஹஸ்தா²நே ஸமுபவிஷ்டம்ʼ மதி²நாமாநம் ஏகம்ʼ மநுஜம்ʼ விலோக்ய தம்ʼ ப³பா⁴ஷே, மம பஸ்²சாத்³ ஆக³ச்ச², தத​: ஸ உத்தா²ய தஸ்ய பஸ்²சாத்³ வவ்ராஜ| ");
INSERT INTO santam_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","தத​: பரம்ʼ யீஸௌ² க்³ருʼஹே போ⁴க்தும் உபவிஷ்டே ப³ஹவ​: கரஸம்ʼக்³ராஹிண​: கலுஷிணஸ்²ச மாநவா ஆக³த்ய தேந ஸாகம்ʼ தஸ்ய ஸி²ஷ்யைஸ்²ச ஸாகம் உபவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","பி²ரூஸி²நஸ்தத்³ த்³ருʼஷ்ட்வா தஸ்ய ஸி²ஷ்யாந் ப³பா⁴ஷிரே, யுஷ்மாகம்ʼ கு³ரு​: கிம்ʼ நிமித்தம்ʼ கரஸம்ʼக்³ராஹிபி⁴​: கலுஷிபி⁴ஸ்²ச ஸாகம்ʼ பு⁴ம்ʼக்தே? ");
INSERT INTO santam_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","யீஸு²ஸ்தத் ஸ்²ருத்வா தாந் ப்ரத்யவத³த், நிராமயலோகாநாம்ʼ சிகித்ஸகேந ப்ரயோஜநம்ʼ நாஸ்தி, கிந்து ஸாமயலோகாநாம்ʼ ப்ரயோஜநமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","அதோ யூயம்ʼ யாத்வா வசநஸ்யாஸ்யார்த²ம்ʼ ஸி²க்ஷத்⁴வம், த³யாயாம்ʼ மே யதா² ப்ரீதி ர்ந ததா² யஜ்ஞகர்ம்மணி| யதோ(அ)ஹம்ʼ தா⁴ர்ம்மிகாந் ஆஹ்வாதும்ʼ நாக³தோ(அ)ஸ்மி கிந்து மந​: பரிவர்த்தயிதும்ʼ பாபிந ஆஹ்வாதும் ஆக³தோ(அ)ஸ்மி| ");
INSERT INTO santam_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","அநந்தரம்ʼ யோஹந​: ஸி²ஷ்யாஸ்தஸ்ய ஸமீபம் ஆக³த்ய கத²யாமாஸு​:, பி²ரூஸி²நோ வயஞ்ச புந​: புநருபவஸாம​:, கிந்து தவ ஸி²ஷ்யா நோபவஸந்தி, குத​:? ");
INSERT INTO santam_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ததா³ யீஸு²ஸ்தாந் அவோசத் யாவத் ஸகீ²நாம்ʼ ஸம்ʼங்கே³ கந்யாயா வரஸ்திஷ்ட²தி, தாவத் கிம்ʼ தே விலாபம்ʼ கர்த்தும்ʼ ஸ²க்லுவந்தி? கிந்து யதா³ தேஷாம்ʼ ஸம்ʼங்கா³த்³ வரம்ʼ நயந்தி, தாத்³ருʼஸ²​: ஸமய ஆக³மிஷ்யதி, ததா³ தே உபவத்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","புராதநவஸநே கோபி நவீநவஸ்த்ரம்ʼ ந யோஜயதி, யஸ்மாத் தேந யோஜிதேந புராதநவஸநம்ʼ சி²நத்தி தச்சி²த்³ரஞ்ச ப³ஹுகுத்ஸிதம்ʼ த்³ருʼஸ்²யதே| ");
INSERT INTO santam_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","அந்யஞ்ச புராதநகுத்வாம்ʼ கோபி நவாநகோ³ஸ்தநீரஸம்ʼ ந நித³தா⁴தி, யஸ்மாத் ததா² க்ருʼதே குதூ ர்விதீ³ர்ய்யதே தேந கோ³ஸ்தநீரஸ​: பததி குதூஸ்²ச நஸ்²யதி; தஸ்மாத் நவீநாயாம்ʼ குத்வாம்ʼ நவீநோ கோ³ஸ்தநீரஸ​: ஸ்தா²ப்யதே, தேந த்³வயோரவநம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","அபரம்ʼ தேநைதத்கதா²கத²நகாலே ஏகோ(அ)தி⁴பதிஸ்தம்ʼ ப்ரணம்ய ப³பா⁴ஷே, மம து³ஹிதா ப்ராயேணைதாவத்காலே ம்ருʼதா, தஸ்மாத்³ ப⁴வாநாக³த்ய தஸ்யா கா³த்ரே ஹஸ்தமர்பயது, தேந ஸா ஜீவிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ததா³நீம்ʼ யீஸு²​: ஸி²ஷ்யை​: ஸாகம் உத்தா²ய தஸ்ய பஸ்²சாத்³ வவ்ராஜ| ");
INSERT INTO santam_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","இத்யநந்தரே த்³வாத³ஸ²வத்ஸராந் யாவத் ப்ரத³ராமயேந ஸீ²ர்ணைகா நாரீ தஸ்ய பஸ்²சாத்³ ஆக³த்ய தஸ்ய வஸநஸ்ய க்³ரந்தி²ம்ʼ பஸ்பர்ஸ²; ");
INSERT INTO santam_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","யஸ்மாத் மயா கேவலம்ʼ தஸ்ய வஸநம்ʼ ஸ்ப்ருʼஷ்ட்வா ஸ்வாஸ்த்²யம்ʼ ப்ராப்ஸ்யதே, ஸா நாரீதி மநஸி நிஸ்²சிதவதீ| ");
INSERT INTO santam_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ததோ யீஸு²ர்வத³நம்ʼ பராவர்த்த்ய தாம்ʼ ஜகா³த³, ஹே கந்யே, த்வம்ʼ ஸுஸ்தி²ரா ப⁴வ, தவ விஸ்²வாஸஸ்த்வாம்ʼ ஸ்வஸ்தா²மகார்ஷீத்| ஏதத்³வாக்யே க³தி³தஏவ ஸா யோஷித் ஸ்வஸ்தா²பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","அபரம்ʼ யீஸு²ஸ்தஸ்யாத்⁴யக்ஷஸ்ய கே³ஹம்ʼ க³த்வா வாத³கப்ரப்⁴ருʼதீந் ப³ஹூந் லோகாந் ஸ²ப்³தா³யமாநாந் விலோக்ய தாந் அவத³த், ");
INSERT INTO santam_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","பந்தா²நம்ʼ த்யஜ, கந்யேயம்ʼ நாம்ரியத நித்³ரிதாஸ்தே; கதா²மேதாம்ʼ ஸ்²ருத்வா தே தமுபஜஹஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","கிந்து ஸர்வ்வேஷு ப³ஹிஷ்க்ருʼதேஷு ஸோ(அ)ப்⁴யந்தரம்ʼ க³த்வா கந்யாயா​: கரம்ʼ த்⁴ருʼதவாந், தேந ஸோத³திஷ்ட²த்; ");
INSERT INTO santam_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ததஸ்தத்கர்ம்மணோ யஸ²​: க்ருʼத்ஸ்நம்ʼ தம்ʼ தே³ஸ²ம்ʼ வ்யாப்தவத்| ");
INSERT INTO santam_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","தத​: பரம்ʼ யீஸு²ஸ்தஸ்மாத் ஸ்தா²நாத்³ யாத்ராம்ʼ சகார; ததா³ ஹே தா³யூத³​: ஸந்தாந, அஸ்மாந் த³யஸ்வ, இதி வத³ந்தௌ த்³வௌ ஜநாவந்தௌ⁴ ப்ரோசைராஹூயந்தௌ தத்பஸ்²சாத்³ வவ்ரஜது​:| ");
INSERT INTO santam_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ததோ யீஸௌ² கே³ஹமத்⁴யம்ʼ ப்ரவிஷ்டம்ʼ தாவபி தஸ்ய ஸமீபம் உபஸ்தி²தவந்தௌ, ததா³நீம்ʼ ஸ தௌ ப்ருʼஷ்டவாந் கர்ம்மைதத் கர்த்தும்ʼ மம ஸாமர்த்²யம் ஆஸ்தே, யுவாம்ʼ கிமிதி ப்ரதீத²​:? ததா³ தௌ ப்ரத்யூசது​:, ஸத்யம்ʼ ப்ரபோ⁴| ");
INSERT INTO santam_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ததா³நீம்ʼ ஸ தயோ ர்லோசநாநி ஸ்ப்ருʼஸ²ந் ப³பா⁴ஷே, யுவயோ​: ப்ரதீத்யநுஸாராத்³ யுவயோ ர்மங்க³லம்ʼ பூ⁴யாத்| தேந தத்க்ஷணாத் தயோ ர்நேத்ராணி ப்ரஸந்நாந்யப⁴வந், ");
INSERT INTO santam_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","பஸ்²சாத்³ யீஸு²ஸ்தௌ த்³ருʼட⁴மாஜ்ஞாப்ய ஜகா³த³, அவத⁴த்தம் ஏதாம்ʼ கதா²ம்ʼ கோபி மநுஜோ ம ஜாநீயாத்| ");
INSERT INTO santam_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","கிந்து தௌ ப்ரஸ்தா²ய தஸ்மிந் க்ருʼத்ஸ்நே தே³ஸே² தஸ்ய கீர்த்திம்ʼ ப்ரகாஸ²யாமாஸது​:| ");
INSERT INTO santam_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","அபரம்ʼ தௌ ப³ஹிர்யாத ஏதஸ்மிந்நந்தரே மநுஜா ஏகம்ʼ பூ⁴தக்³ரஸ்தமூகம்ʼ தஸ்ய ஸமீபம் ஆநீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","தேந பூ⁴தே த்யாஜிதே ஸ மூக​: கதா²ம்ʼ கத²யிதும்ʼ ப்ராரப⁴த, தேந ஜநா விஸ்மயம்ʼ விஜ்ஞாய கத²யாமாஸு​:, இஸ்ராயேலோ வம்ʼஸே² கதா³பி நேத்³ருʼக³த்³ருʼஸ்²யத; ");
INSERT INTO santam_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","கிந்து பி²ரூஸி²ந​: கத²யாஞ்சக்ரு​: பூ⁴தாதி⁴பதிநா ஸ பூ⁴தாந் த்யாஜயதி| ");
INSERT INTO santam_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","தத​: பரம்ʼ யீஸு²ஸ்தேஷாம்ʼ ப⁴ஜநப⁴வந உபதி³ஸ²ந் ராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் லோகாநாம்ʼ யஸ்ய ய ஆமயோ யா ச பீடா³ஸீத், தாந் ஸ²மயந் ஸ²மயம்ʼஸ்²ச ஸர்வ்வாணி நக³ராணி க்³ராமாம்ʼஸ்²ச ப³ப்⁴ராம| ");
INSERT INTO santam_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","அந்யஞ்ச மநுஜாந் வ்யாகுலாந் அரக்ஷகமேஷாநிவ ச த்யக்தாந் நிரீக்ஷ்ய தேஷு காருணிக​: ஸந் ஸி²ஷ்யாந் அவத³த், ");
INSERT INTO santam_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ஸ²ஸ்யாநி ப்ரசுராணி ஸந்தி, கிந்து சே²த்தார​: ஸ்தோகா​:| ");
INSERT INTO santam_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","க்ஷேத்ரம்ʼ ப்ரத்யபராந் சே²த³காந் ப்ரஹேதும்ʼ ஸ²ஸ்யஸ்வாமிநம்ʼ ப்ரார்த²யத்⁴வம்| ");
INSERT INTO santam_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","அநந்தரம்ʼ யீஸு² ர்த்³வாத³ஸ²ஸி²ஷ்யாந் ஆஹூயாமேத்⁴யபூ⁴தாந் த்யாஜயிதும்ʼ ஸர்வ்வப்ரகாரரோகா³ந் பீடா³ஸ்²ச ஸ²மயிதும்ʼ தேப்⁴ய​: ஸாமர்த்²யமதா³த்| ");
INSERT INTO santam_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","தேஷாம்ʼ த்³வாத³ஸ²ப்ரேஷ்யாணாம்ʼ நாமாந்யேதாநி| ப்ரத²மம்ʼ ஸி²மோந் யம்ʼ பிதரம்ʼ வத³ந்தி, தத​: பரம்ʼ தஸ்ய ஸஹஜ ஆந்த்³ரிய​:, ஸிவதி³யஸ்ய புத்ரோ யாகூப்³ ");
INSERT INTO santam_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","தஸ்ய ஸஹஜோ யோஹந்; பி²லிப் ப³ர்த²லமய் தோ²மா​: கரஸம்ʼக்³ராஹீ மதி²​:, ஆல்பே²யபுத்ரோ யாகூப்³, ");
INSERT INTO santam_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","கிநாநீய​: ஸி²மோந், ய ஈஷ்கரியோதீயயிஹூதா³​: க்²ரீஷ்டம்ʼ பரகரே(அ)ர்பயத்| ");
INSERT INTO santam_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ஏதாந் த்³வாத³ஸ²ஸி²ஷ்யாந் யீஸு²​: ப்ரேஷயந் இத்யாஜ்ஞாபயத், யூயம் அந்யதே³ஸீ²யாநாம்ʼ பத³வீம்ʼ ஸே²மிரோணீயாநாம்ʼ கிமபி நக³ரஞ்ச ந ப்ரவிஸ்²யே ");
INSERT INTO santam_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","இஸ்ராயேல்கோ³த்ரஸ்ய ஹாரிதா யே யே மேஷாஸ்தேஷாமேவ ஸமீபம்ʼ யாத| ");
INSERT INTO santam_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","க³த்வா க³த்வா ஸ்வர்க³ஸ்ய ராஜத்வம்ʼ ஸவித⁴மப⁴வத், ஏதாம்ʼ கதா²ம்ʼ ப்ரசாரயத| ");
INSERT INTO santam_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ஆமயக்³ரஸ்தாந் ஸ்வஸ்தா²ந் குருத, குஷ்டி²ந​: பரிஷ்குருத, ம்ருʼதலோகாந் ஜீவயத, பூ⁴தாந் த்யாஜயத, விநா மூல்யம்ʼ யூயம் அலப⁴த்⁴வம்ʼ விநைவ மூல்யம்ʼ விஸ்²ராணயத| ");
INSERT INTO santam_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","கிந்து ஸ்வேஷாம்ʼ கடிப³ந்தே⁴ஷு ஸ்வர்ணரூப்யதாம்ராணாம்ʼ கிமபி ந க்³ருʼஹ்லீத| ");
INSERT INTO santam_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","அந்யச்ச யாத்ராயை சேலஸம்புடம்ʼ வா த்³விதீயவஸநம்ʼ வா பாது³கே வா யஷ்டி​:, ஏதாந் மா க்³ருʼஹ்லீத, யத​: கார்ய்யக்ருʼத் ப⁴ர்த்தும்ʼ யோக்³யோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","அபரம்ʼ யூயம்ʼ யத் புரம்ʼ யஞ்ச க்³ராமம்ʼ ப்ரவிஸ²த², தத்ர யோ ஜநோ யோக்³யபாத்ரம்ʼ தமவக³த்ய யாநகாலம்ʼ யாவத் தத்ர திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","யதா³ யூயம்ʼ தத்³கே³ஹம்ʼ ப்ரவிஸ²த², ததா³ தமாஸி²ஷம்ʼ வத³த| ");
INSERT INTO santam_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","யதி³ ஸ யோக்³யபாத்ரம்ʼ ப⁴வதி, தர்ஹி தத்கல்யாணம்ʼ தஸ்மை ப⁴விஷ்யதி, நோசேத் ஸாஸீ²ர்யுஷ்மப்⁴யமேவ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","கிந்து யே ஜநா யுஷ்மாகமாதித்²யம்ʼ ந வித³த⁴தி யுஷ்மாகம்ʼ கதா²ஞ்ச ந ஸ்²ருʼண்வந்தி தேஷாம்ʼ கே³ஹாத் புராத்³வா ப்ரஸ்தா²நகாலே ஸ்வபதூ³லீ​: பாதயத| ");
INSERT INTO santam_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","யுஷ்மாநஹம்ʼ தத்²யம்ʼ வச்மி விசாரதி³நே தத்புரஸ்ய த³ஸா²த​: ஸிதோ³மமோராபுரயோர்த³ஸா² ஸஹ்யதரா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","பஸ்²யத, வ்ருʼகயூத²மத்⁴யே மேஷ​: யதா²விஸ்ததா² யுஷ்மாந ப்ரஹிணோமி, தஸ்மாத்³ யூயம் அஹிரிவ ஸதர்கா​: கபோதாஇவாஹிம்ʼஸகா ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ந்ருʼப்⁴ய​: ஸாவதா⁴நா ப⁴வத; யதஸ்தை ர்யூயம்ʼ ராஜஸம்ʼஸதி³ ஸமர்பிஷ்யத்⁴வே தேஷாம்ʼ ப⁴ஜநகே³ஹே ப்ரஹாரிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","யூயம்ʼ மந்நாமஹேதோ​: ஸா²ஸ்த்ருʼணாம்ʼ ராஜ்ஞாஞ்ச ஸமக்ஷம்ʼ தாநந்யதே³ஸி²நஸ்²சாதி⁴ ஸாக்ஷித்வார்த²மாநேஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","கிந்த்வித்த²ம்ʼ ஸமர்பிதா யூயம்ʼ கத²ம்ʼ கிமுத்தரம்ʼ வக்ஷ்யத² தத்ர மா சிந்தயத, யதஸ்ததா³ யுஷ்மாபி⁴ ர்யத்³ வக்தவ்யம்ʼ தத் தத்³த³ண்டே³ யுஷ்மந்மந​: ஸு ஸமுபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","யஸ்மாத் ததா³ யோ வக்ஷ்யதி ஸ ந யூயம்ʼ கிந்து யுஷ்மாகமந்தரஸ்த²​: பித்ராத்மா| ");
INSERT INTO santam_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ஸஹஜ​: ஸஹஜம்ʼ தாத​: ஸுதஞ்ச ம்ருʼதௌ ஸமர்பயிஷ்யதி, அபத்யாகி³ ஸ்வஸ்வபித்ரோे ர்விபக்ஷீபூ⁴ய தௌ கா⁴தயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","மந்நமஹேதோ​: ஸர்வ்வே ஜநா யுஷ்மாந் ருʼृதீயிஷ்யந்தே, கிந்து ய​: ஸே²ஷம்ʼ யாவத்³ தை⁴ர்ய்யம்ʼ க்⁴ருʼத்வா ஸ்தா²ஸ்யதி, ஸ த்ராயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","தை ர்யதா³ யூயமேகபுரே தாடி³ஷ்யத்⁴வே, ததா³ யூயமந்யபுரம்ʼ பலாயத்⁴வம்ʼ யுஷ்மாநஹம்ʼ தத்²யம்ʼ வச்மி யாவந்மநுஜஸுதோ நைதி தாவத்³ இஸ்ராயேல்தே³ஸீ²யஸர்வ்வநக³ரப்⁴ரமணம்ʼ ஸமாபயிதும்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","கு³ரோ​: ஸி²ஷ்யோ ந மஹாந், ப்ரபோ⁴ர்தா³ஸோ ந மஹாந்| ");
INSERT INTO santam_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","யதி³ ஸி²ஷ்யோ நிஜகு³ரோ ர்தா³ஸஸ்²ச ஸ்வப்ரபோ⁴​: ஸமாநோ ப⁴வதி தர்ஹி தத்³ யதே²ஷ்டம்ʼ| சேத்தைர்க்³ருʼஹபதிர்பூ⁴தராஜ உச்யதே, தர்ஹி பரிவாரா​: கிம்ʼ ததா² ந வக்ஷ்யந்தே? ");
INSERT INTO santam_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","கிந்து தேப்⁴யோ யூயம்ʼ மா பி³பீ⁴த, யதோ யந்ந ப்ரகாஸி²ஷ்யதே, தாத்³ருʼக் சா²தி³தம்ʼ கிமபி நாஸ்தி, யச்ச ந வ்யஞ்சிஷ்யதே, தாத்³ருʼக்³ கு³ப்தம்ʼ கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","யத³ஹம்ʼ யுஷ்மாந் தமஸி வச்மி தத்³ யுஷ்மாபி⁴ர்தீ³ப்தௌ கத்²யதாம்ʼ; கர்ணாப்⁴யாம்ʼ யத் ஸ்²ரூயதே தத்³ கே³ஹோபரி ப்ரசார்ய்யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","யே காயம்ʼ ஹந்தும்ʼ ஸ²க்நுவந்தி நாத்மாநம்ʼ, தேப்⁴யோ மா பை⁴ஷ்ட; ய​: காயாத்மாநௌ நிரயே நாஸ²யிதும்ʼ, ஸ²க்நோதி, ததோ பி³பீ⁴த| ");
INSERT INTO santam_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","த்³வௌ சடகௌ கிமேகதாம்ரமுத்³ரயா ந விக்ரீயேதே? ததா²பி யுஷ்மத்தாதாநுமதிம்ʼ விநா தேஷாமேகோபி பு⁴வி ந பததி| ");
INSERT INTO santam_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","யுஷ்மச்சி²ரஸாம்ʼ ஸர்வ்வகசா க³ணிதாம்ʼ​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","அதோ மா பி³பீ⁴த, யூயம்ʼ ப³ஹுசடகேப்⁴யோ ப³ஹுமூல்யா​:| ");
INSERT INTO santam_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","யோ மநுஜஸாக்ஷாந்மாமங்கீ³குருதே தமஹம்ʼ ஸ்வர்க³ஸ்த²தாதஸாக்ஷாத³ங்கீ³கரிஷ்யே| ");
INSERT INTO santam_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ப்ருʼத்²வ்யாமஹம்ʼ ஸா²ந்திம்ʼ தா³துமாக³தஇதி மாநுப⁴வத, ஸா²ந்திம்ʼ தா³தும்ʼ ந கிந்த்வஸிம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","பித்ருʼமாத்ருʼஸ்²சஸ்²ரூபி⁴​: ஸாகம்ʼ ஸுதஸுதாப³தூ⁴ ர்விரோத⁴யிதுஞ்சாக³தேाஸ்மி| ");
INSERT INTO santam_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","தத​: ஸ்வஸ்வபரிவாரஏவ ந்ருʼஸ²த்ரு ர்ப⁴விதா| ");
INSERT INTO santam_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ய​: பிதரி மாதரி வா மத்தோதி⁴கம்ʼ ப்ரீயதே, ஸ ந மத³ர்ஹ​:; ");
INSERT INTO santam_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","யஸ்²ச ஸுதே ஸுதாயாம்ʼ வா மத்தோதி⁴கம்ʼ ப்ரீயதே, ஸேाபி ந மத³ர்ஹ​:| ");
INSERT INTO santam_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ய​: ஸ்வக்ருஸ²ம்ʼ க்³ருʼஹ்லந் மத்பஸ்²சாந்நைதி, ஸேाபி ந மத³ர்ஹ​:| ");
INSERT INTO santam_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ய​: ஸ்வப்ராணாநவதி, ஸ தாந் ஹாரயிஷ்யதே, யஸ்து மத்க்ருʼதே ஸ்வப்ராணாந் ஹாரயதி, ஸ தாநவதி| ");
INSERT INTO santam_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","யோ யுஷ்மாகமாதித்²யம்ʼ வித³தா⁴தி, ஸ மமாதித்²யம்ʼ வித³தா⁴தி, யஸ்²ச மமாதித்²யம்ʼ வித³தா⁴தி, ஸ மத்ப்ரேரகஸ்யாதித்²யம்ʼ வித³தா⁴தி| ");
INSERT INTO santam_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","யோ ப⁴விஷ்யத்³வாதீ³தி ஜ்ஞாத்வா தஸ்யாதித்²யம்ʼ வித⁴த்தே, ஸ ப⁴விஷ்யத்³வாதி³ந​: ப²லம்ʼ லப்ஸ்யதே, யஸ்²ச தா⁴ர்ம்மிக இதி விதி³த்வா தஸ்யாதித்²யம்ʼ வித⁴த்தே ஸ தா⁴ர்ம்மிகமாநவஸ்ய ப²லம்ʼ ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","யஸ்²ச கஸ்²சித் ஏதேஷாம்ʼ க்ஷுத்³ரநராணாம் யம்ʼ கஞ்சநைகம்ʼ ஸி²ஷ்ய இதி விதி³த்வா கம்ʼஸைகம்ʼ ஸீ²தலஸலிலம்ʼ தஸ்மை த³த்தே, யுஷ்மாநஹம்ʼ தத்²யம்ʼ வதா³மி, ஸ கேநாபி ப்ரகாரேண ப²லேந ந வஞ்சிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","இத்த²ம்ʼ யீஸு²​: ஸ்வத்³வாத³ஸ²ஸி²ஷ்யாணாமாஜ்ஞாபநம்ʼ ஸமாப்ய புரே புர உபதே³ஷ்டும்ʼ ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும்ʼ தத்ஸ்தா²நாத் ப்ரதஸ்தே²| ");
INSERT INTO santam_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","அநந்தரம்ʼ யோஹந் காராயாம்ʼ திஷ்ட²ந் க்²ரிஷ்டஸ்ய கர்ம்மணாம்ʼ வார்த்தம்ʼ ப்ராப்ய யஸ்யாக³மநவார்த்தாஸீத் ஸஏவ கிம்ʼ த்வம்ʼ? வா வயமந்யம் அபேக்ஷிஷ்யாமஹே? ");
INSERT INTO santam_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ஏதத் ப்ரஷ்டும்ʼ நிஜௌ த்³வௌ ஸி²ஷ்யௌ ப்ராஹிணோத்| ");
INSERT INTO santam_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","யீஸு²​: ப்ரத்யவோசத், அந்தா⁴ நேத்ராணி லப⁴ந்தே, க²ஞ்சா க³ச்ச²ந்தி, குஷ்டி²ந​: ஸ்வஸ்தா² ப⁴வந்தி, ப³தி⁴ரா​: ஸ்²ருʼண்வந்தி, ம்ருʼதா ஜீவந்த உத்திஷ்ட²ந்தி, த³ரித்³ராணாம்ʼ ஸமீபே ஸுஸம்ʼவாத³​: ப்ரசார்ய்யத, ");
INSERT INTO santam_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ஏதாநி யத்³யத்³ யுவாம்ʼ ஸ்²ருʼணுத²​: பஸ்²யத²ஸ்²ச க³த்வா தத்³வார்த்தாம்ʼ யோஹநம்ʼ க³த³தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","யஸ்யாஹம்ʼ ந விக்⁴நீப⁴வாமி, ஸஏவ த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","அநந்தரம்ʼ தயோ​: ப்ரஸ்தி²தயோ ர்யீஸு² ர்யோஹநம் உத்³தி³ஸ்²ய ஜநாந் ஜகா³த³, யூயம்ʼ கிம்ʼ த்³ரஷ்டும்ʼ வஹிர்மத்⁴யேப்ராந்தரம் அக³ச்ச²த? கிம்ʼ வாதேந கம்பிதம்ʼ நலம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","வா கிம்ʼ வீக்ஷிதும்ʼ வஹிர்க³தவந்த​:? கிம்ʼ பரிஹிதஸூக்ஷ்மவஸநம்ʼ மநுஜமேகம்ʼ? பஸ்²யத, யே ஸூக்ஷ்மவஸநாநி பரித³த⁴தி, தே ராஜதா⁴ந்யாம்ʼ திஷ்ட²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","தர்ஹி யூயம்ʼ கிம்ʼ த்³ரஷ்டும்ʼ ப³ஹிரக³மத, கிமேகம்ʼ ப⁴விஷ்யத்³வாதி³நம்ʼ? ததே³வ ஸத்யம்ʼ| யுஷ்மாநஹம்ʼ வதா³மி, ஸ ப⁴விஷ்யத்³வாதி³நோபி மஹாந்; ");
INSERT INTO santam_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","யத​:, பஸ்²ய ஸ்வகீயதூ³தோயம்ʼ த்வத³க்³ரே ப்ரேஷ்யதே மயா| ஸ க³த்வா தவ பந்தா²நம்ʼ ஸ்மயக் பரிஷ்கரிஷ்யதி|| ஏதத்³வசநம்ʼ யமதி⁴ லிகி²தமாஸ்தே ஸோ(அ)யம்ʼ யோஹந்| ");
INSERT INTO santam_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","அபரம்ʼ யுஷ்மாநஹம்ʼ தத்²யம்ʼ ப்³ரவீமி, மஜ்ஜயிது ர்யோஹந​: ஸ்²ரேஷ்ட²​: கோபி நாரீதோ நாஜாயத; ததா²பி ஸ்வர்க³ராஜ்யமத்⁴யே ஸர்வ்வேப்⁴யோ ய​: க்ஷுத்³ர​: ஸ யோஹந​: ஸ்²ரேஷ்ட²​:| ");
INSERT INTO santam_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","அபரஞ்ச ஆ யோஹநோ(அ)த்³ய யாவத் ஸ்வர்க³ராஜ்யம்ʼ ப³லாதா³க்ராந்தம்ʼ ப⁴வதி ஆக்ரமிநஸ்²ச ஜநா ப³லேந தத³தி⁴குர்வ்வந்தி| ");
INSERT INTO santam_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","யதோ யோஹநம்ʼ யாவத் ஸர்வ்வப⁴விஷ்யத்³வாதி³பி⁴ ர்வ்யவஸ்த²யா ச உபதே³ஸ²​: ப்ராகாஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","யதி³ யூயமித³ம்ʼ வாக்யம்ʼ க்³ரஹீதும்ʼ ஸ²க்நுத², தர்ஹி ஸ்²ரேய​:, யஸ்யாக³மநஸ்ய வசநமாஸ்தே ஸோ(அ)யம் ஏலிய​:| ");
INSERT INTO santam_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","யஸ்ய ஸ்²ரோதும்ʼ கர்ணௌ ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ஏதே வித்³யமாநஜநா​: கை ர்மயோபமீயந்தே? யே பா³லகா ஹட்ட உபவிஸ்²ய ஸ்வம்ʼ ஸ்வம்ʼ ப³ந்து⁴மாஹூய வத³ந்தி, ");
INSERT INTO santam_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","வயம்ʼ யுஷ்மாகம்ʼ ஸமீபே வம்ʼஸீ²ரவாத³யாம, கிந்து யூயம்ʼ நாந்ருʼத்யத; யுஷ்மாகம்ʼ ஸமீபே ச வயமரோதி³ம, கிந்து யூயம்ʼ ந வ்யலபத, தாத்³ருʼஸை² ர்பா³லகைஸ்த உபமாயிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","யதோ யோஹந் ஆக³த்ய ந பு⁴க்தவாந் ந பீதவாம்ʼஸ்²ச, தேந லோகா வத³ந்தி, ஸ பூ⁴தக்³ரஸ்த இதி| ");
INSERT INTO santam_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","மநுஜஸுத ஆக³த்ய பு⁴க்தவாந் பீதவாம்ʼஸ்²ச, தேந லோகா வத³ந்தி, பஸ்²யத ஏஷ போ⁴க்தா மத்³யபாதா சண்டா³லபாபிநாம்ʼ ப³ந்த⁴ஸ்²ச, கிந்து ஜ்ஞாநிநோ ஜ்ஞாநவ்யவஹாரம்ʼ நிர்தோ³ஷம்ʼ ஜாநந்தி| ");
INSERT INTO santam_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ஸ யத்ர யத்ர புரே ப³ஹ்வாஸ்²சர்ய்யம்ʼ கர்ம்ம க்ருʼதவாந், தந்நிவாஸிநாம்ʼ மந​:பராவ்ருʼத்த்யபா⁴வாத் தாநி நக³ராணி ப்ரதி ஹந்தேத்யுக்தா கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ஹா கோராஸீந், ஹா பை³த்ஸைதே³, யுஷ்மந்மத்⁴யே யத்³யதா³ஸ்²சர்ய்யம்ʼ கர்ம்ம க்ருʼதம்ʼ யதி³ தத் ஸோரஸீதோ³ந்நக³ர அகாரிஷ்யத, தர்ஹி பூர்வ்வமேவ தந்நிவாஸிந​: ஸா²ணவஸநே ப⁴ஸ்மநி சோபவிஸ²ந்தோ மநாம்ʼஸி பராவர்த்திஷ்யந்த| ");
INSERT INTO santam_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","தஸ்மாத³ஹம்ʼ யுஷ்மாந் வதா³மி, விசாரதி³நே யுஷ்மாகம்ʼ த³ஸா²த​: ஸோரஸீதோ³நோ ர்த³ஸா² ஸஹ்யதரா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","அபரஞ்ச ப³த கப²ர்நாஹூம், த்வம்ʼ ஸ்வர்க³ம்ʼ யாவது³ந்நதோஸி, கிந்து நரகே நிக்ஷேப்ஸ்யஸே, யஸ்மாத் த்வயி யாந்யாஸ்²சர்ய்யாணி கர்ம்மண்யகாரிஷத, யதி³ தாநி ஸிதோ³ம்நக³ர அகாரிஷ்யந்த, தர்ஹி தத³த்³ய யாவத³ஸ்தா²ஸ்யத்| ");
INSERT INTO santam_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, விசாரதி³நே தவ த³ண்ட³த​: ஸிதோ³மோ த³ண்டோ³ ஸஹ்யதரோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ஏதஸ்மிந்நேவ ஸமயே யீஸு²​: புநருவாச, ஹே ஸ்வர்க³ப்ருʼதி²வ்யோரேகாதி⁴பதே பிதஸ்த்வம்ʼ ஜ்ஞாநவதோ விது³ஷஸ்²ச லோகாந் ப்ரத்யேதாநி ந ப்ரகாஸ்²ய பா³லகாந் ப்ரதி ப்ரகாஸி²தவாந், இதி ஹேதோஸ்த்வாம்ʼ த⁴ந்யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ஹே பித​:, இத்த²ம்ʼ ப⁴வேத் யத இத³ம்ʼ த்வத்³ருʼஷ்டாவுத்தமம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","பித்ரா மயி ஸர்வ்வாணி ஸமர்பிதாநி, பிதரம்ʼ விநா கோபி புத்ரம்ʼ ந ஜாநாதி, யாந் ப்ரதி புத்ரேண பிதா ப்ரகாஸ்²யதே தாந் விநா புத்ராத்³ அந்ய​: கோபி பிதரம்ʼ ந ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ஹே பரிஸ்²ராந்தா பா⁴ராக்ராந்தாஸ்²ச லோகா யூயம்ʼ மத்ஸந்நிதி⁴ம் ஆக³ச்ச²த, அஹம்ʼ யுஷ்மாந் விஸ்²ரமயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","அஹம்ʼ க்ஷமணஸீ²லோ நம்ரமநாஸ்²ச, தஸ்மாத் மம யுக³ம்ʼ ஸ்வேஷாமுபரி தா⁴ரயத மத்த​: ஸி²க்ஷத்⁴வஞ்ச, தேந யூயம்ʼ ஸ்வே ஸ்வே மநஸி விஸ்²ராமம்ʼ லப்ஸ்யத்⁴பே³| ");
INSERT INTO santam_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","யதோ மம யுக³ம் அநாயாஸம்ʼ மம பா⁴ரஸ்²ச லகு⁴​:| ");
INSERT INTO santam_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","அநந்தரம்ʼ யீஸு² ர்விஸ்²ராமவாரே ஸ்²ஸ்யமத்⁴யேந க³ச்ச²தி, ததா³ தச்சி²ஷ்யா பு³பு⁴க்ஷிதா​: ஸந்த​: ஸ்²ஸ்யமஞ்ஜரீஸ்²ச²த்வா சி²த்வா கா²தி³துமாரப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","தத்³ விலோக்ய பி²ரூஸி²நோ யீஸு²ம்ʼ ஜக³து³​:, பஸ்²ய விஸ்²ராமவாரே யத் கர்ம்மாகர்த்தவ்யம்ʼ ததே³வ தவ ஸி²ஷ்யா​: குர்வ்வந்தி| ");
INSERT INTO santam_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ஸ தாந் ப்ரத்யாவத³த, தா³யூத்³ தத்ஸங்கி³நஸ்²ச பு³பு⁴க்ஷிதா​: ஸந்தோ யத் கர்ம்மாகுர்வ்வந் தத் கிம்ʼ யுஷ்மாபி⁴ ர்நாபாடி²? ");
INSERT INTO santam_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","யே த³ர்ஸ²நீயா​: பூபா​: யாஜகாந் விநா தஸ்ய தத்ஸங்கி³மநுஜாநாஞ்சாபோ⁴ஜநீயாஸ்த ஈஸ்²வராவாஸம்ʼ ப்ரவிஷ்டேந தேந பு⁴க்தா​:| ");
INSERT INTO santam_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","அந்யச்ச விஸ்²ராமவாரே மத்⁴யேமந்தி³ரம்ʼ விஸ்²ராமவாரீயம்ʼ நியமம்ʼ லங்வந்தோபி யாஜகா நிர்தோ³ஷா ப⁴வந்தி, ஸா²ஸ்த்ரமத்⁴யே கிமித³மபி யுஷ்மாபி⁴ ர்ந படி²தம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","யுஷ்மாநஹம்ʼ வதா³மி, அத்ர ஸ்தா²நே மந்தி³ராத³பி க³ரீயாந் ஏக ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","கிந்து த³யாயாம்ʼ மே யதா² ப்ரீதி ர்ந ததா² யஜ்ஞகர்ம்மணி| ஏதத்³வசநஸ்யார்த²ம்ʼ யதி³ யுயம் அஜ்ஞாஸிஷ்ட தர்ஹி நிர்தோ³ஷாந் தோ³ஷிணோ நாகார்ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","அந்யச்ச மநுஜஸுதோ விஸ்²ராமவாரஸ்யாபி பதிராஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","அநந்தரம்ʼ ஸ தத்ஸ்தா²நாத் ப்ரஸ்தா²ய தேஷாம்ʼ ப⁴ஜநப⁴வநம்ʼ ப்ரவிஷ்டவாந், ததா³நீம் ஏக​: ஸு²ஷ்ககராமயவாந் உபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ததோ யீஸு²ம் அபவதி³தும்ʼ மாநுஷா​: பப்ரச்சு²​:, விஸ்²ராமவாரே நிராமயத்வம்ʼ கரணீயம்ʼ ந வா? ");
INSERT INTO santam_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","தேந ஸ ப்ரத்யுவாச, விஸ்²ராமவாரே யதி³ கஸ்யசித்³ அவி ர்க³ர்த்தே பததி, தர்ஹி யஸ்தம்ʼ க்⁴ருʼத்வா ந தோலயதி, ஏதாத்³ருʼஸோ² மநுஜோ யுஷ்மாகம்ʼ மத்⁴யே க ஆஸ்தே? ");
INSERT INTO santam_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","அவே ர்மாநவ​: கிம்ʼ நஹி ஸ்²ரேயாந்? அதோ விஸ்²ராமவாரே ஹிதகர்ம்ம கர்த்தவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","அநந்தரம்ʼ ஸ தம்ʼ மாநவம்ʼ க³தி³தவாந், கரம்ʼ ப்ரஸாரய; தேந கரே ப்ரஸாரிதே ஸோந்யகரவத் ஸ்வஸ்தோ²(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ததா³ பி²ரூஸி²நோ ப³ஹிர்பூ⁴ய கத²ம்ʼ தம்ʼ ஹநிஷ்யாம இதி குமந்த்ரணாம்ʼ தத்ப்ராதிகூல்யேந சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ததோ யீஸு²ஸ்தத்³ விதி³த்வா ஸ்த²நாந்தரம்ʼ க³தவாந்; அந்யேஷு ப³ஹுநரேஷு தத்பஸ்²சாத்³ க³தேஷு தாந் ஸ நிராமயாந் க்ருʼத்வா இத்யாஜ்ஞாபயத், ");
INSERT INTO santam_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","யூயம்ʼ மாம்ʼ ந பரிசாயயத| ");
INSERT INTO santam_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","தஸ்மாத் மம ப்ரீயோ மநோநீதோ மநஸஸ்துஷ்டிகாரக​:| மதீ³ய​: ஸேவகோ யஸ்து வித்³யதே தம்ʼ ஸமீக்ஷதாம்ʼ| தஸ்யோபரி ஸ்வகீயாத்மா மயா ஸம்ʼஸ்தா²பயிஷ்யதே| தேநாந்யதே³ஸ²ஜாதேஷு வ்யவஸ்தா² ஸம்ʼப்ரகாஸ்²யதே| ");
INSERT INTO santam_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","கேநாபி ந விரோத⁴ம்ʼ ஸ விவாத³ஞ்ச கரிஷ்யதி| ந ச ராஜபதே² தேந வசநம்ʼ ஸ்²ராவயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","வ்யவஸ்தா² சலிதா யாவத் நஹி தேந கரிஷ்யதே| தாவத் நலோ விதீ³ர்ணோ(அ)பி ப⁴ம்ʼக்ஷ்யதே நஹி தேந ச| ததா² ஸதூ⁴மவர்த்திஞ்ச ந ஸ நிர்வ்வாபயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ப்ரத்யாஸா²ஞ்ச கரிஷ்யந்தி தந்நாம்நி பி⁴ந்நதே³ஸ²ஜா​:| ");
INSERT INTO santam_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","யாந்யேதாநி வசநாநி யிஸ²யியப⁴விஷ்யத்³வாதி³நா ப்ரோக்தாந்யாஸந், தாநி ஸப²லாந்யப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","அநந்தரம்ʼ லோகை ஸ்தத்ஸமீபம் ஆநீதோ பூ⁴தக்³ரஸ்தாந்த⁴மூகைகமநுஜஸ்தேந ஸ்வஸ்தீ²க்ருʼத​:, தத​: ஸோ(அ)ந்தோ⁴ மூகோ த்³ரஷ்டும்ʼ வக்துஞ்சாரப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","அநேந ஸர்வ்வே விஸ்மிதா​: கத²யாஞ்சக்ரு​:, ஏஷ​: கிம்ʼ தா³யூத³​: ஸந்தாநோ நஹி? ");
INSERT INTO santam_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","கிந்து பி²ரூஸி²நஸ்தத் ஸ்²ருத்வா க³தி³தவந்த​:, பா³ல்ஸிபூ³ப்³நாம்நோ பூ⁴தராஜஸ்ய ஸாஹாய்யம்ʼ விநா நாயம்ʼ பூ⁴தாந் த்யாஜயதி| ");
INSERT INTO santam_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ததா³நீம்ʼ யீஸு²ஸ்தேஷாம் இதி மாநஸம்ʼ விஜ்ஞாய தாந் அவத³த் கிஞ்சந ராஜ்யம்ʼ யதி³ ஸ்வவிபக்ஷாத்³ பி⁴த்³யதே, தர்ஹி தத் உச்சி²த்³யதே; யச்ச கிஞ்சந நக³ரம்ʼ வா க்³ருʼஹம்ʼ ஸ்வவிபக்ஷாத்³ விபி⁴த்³யதே, தத் ஸ்தா²தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","தத்³வத் ஸ²யதாநோ யதி³ ஸ²யதாநம்ʼ ப³ஹி​: க்ருʼத்வா ஸ்வவிபக்ஷாத் ப்ருʼத²க் ப்ருʼத²க் ப⁴வதி, தர்ஹி தஸ்ய ராஜ்யம்ʼ கேந ப்ரகாரேண ஸ்தா²ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","அஹஞ்ச யதி³ பா³ல்ஸிபூ³பா³ பூ⁴தாந் த்யாஜயாமி, தர்ஹி யுஷ்மாகம்ʼ ஸந்தாநா​: கேந பூ⁴தாந் த்யாஜயந்தி? தஸ்மாத்³ யுஷ்மாகம் ஏதத்³விசாரயிதாரஸ்த ஏவ ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","கிந்தவஹம்ʼ யதீ³ஸ்²வராத்மநா பூ⁴தாந் த்யாஜயாமி, தர்ஹீஸ்²வரஸ்ய ராஜ்யம்ʼ யுஷ்மாகம்ʼ ஸந்நிதி⁴மாக³தவத்| ");
INSERT INTO santam_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","அந்யஞ்ச கோபி ப³லவந்த ஜநம்ʼ ப்ரத²மதோ ந ப³த்³வ்வா கேந ப்ரகாரேண தஸ்ய க்³ருʼஹம்ʼ ப்ரவிஸ்²ய தத்³த்³ரவ்யாதி³ லோட²யிதும்ʼ ஸ²க்நோதி? கிந்து தத் க்ருʼத்வா ததீ³யக்³ருʼஸ்ய த்³ரவ்யாதி³ லோட²யிதும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ய​: கஸ்²சித் மம ஸ்வபக்ஷீயோ நஹி ஸ விபக்ஷீய ஆஸ்தே, யஸ்²ச மயா ஸாகம்ʼ ந ஸம்ʼக்³ருʼஹ்லாதி, ஸ விகிரதி| ");
INSERT INTO santam_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","அதஏவ யுஷ்மாநஹம்ʼ வதா³மி, மநுஜாநாம்ʼ ஸர்வ்வப்ரகாரபாபாநாம்ʼ நிந்தா³யாஸ்²ச மர்ஷணம்ʼ ப⁴விதும்ʼ ஸ²க்நோதி, கிந்து பவித்ரஸ்யாத்மநோ விருத்³த⁴நிந்தா³யா மர்ஷணம்ʼ ப⁴விதும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","யோ மநுஜஸுதஸ்ய விருத்³தா⁴ம்ʼ கதா²ம்ʼ கத²யதி, தஸ்யாபராத⁴ஸ்ய க்ஷமா ப⁴விதும்ʼ ஸ²க்நோதி, கிந்து ய​: கஸ்²சித் பவித்ரஸ்யாத்மநோ விருத்³தா⁴ம்ʼ கதா²ம்ʼ கத²யதி நேஹலோகே ந ப்ரேத்ய தஸ்யாபராத⁴ஸ்ய க்ஷமா ப⁴விதும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","பாத³பம்ʼ யதி³ ப⁴த்³ரம்ʼ வத³த², தர்ஹி தஸ்ய ப²லமபி ஸாது⁴ வக்தவ்யம்ʼ, யதி³ ச பாத³பம்ʼ அஸாது⁴ம்ʼ வத³த², தர்ஹி தஸ்ய ப²லமப்யஸாது⁴ வக்தவ்யம்ʼ; யத​: ஸ்வீயஸ்வீயப²லேந பாத³ப​: பரிசீயதே| ");
INSERT INTO santam_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ரே பு⁴ஜக³வம்ʼஸா² யூயமஸாத⁴வ​: ஸந்த​: கத²ம்ʼ ஸாது⁴ வாக்யம்ʼ வக்தும்ʼ ஸ²க்ஷ்யத²? யஸ்மாத்³ அந்த​:கரணஸ்ய பூர்ணபா⁴வாநுஸாராத்³ வத³நாத்³ வசோ நிர்க³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","தேந ஸாது⁴ர்மாநவோ(அ)ந்த​:கரணரூபாத் ஸாது⁴பா⁴ண்டா³கா³ராத் ஸாது⁴ த்³ரவ்யம்ʼ நிர்க³மயதி, அஸாது⁴ர்மாநுஷஸ்த்வஸாது⁴பா⁴ண்டா³கா³ராத்³ அஸாது⁴வஸ்தூநி நிர்க³மயதி| ");
INSERT INTO santam_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி, மநுஜா யாவந்த்யாலஸ்யவசாம்ʼஸி வத³ந்தி, விசாரதி³நே தது³த்தரமவஸ்²யம்ʼ தா³தவ்யம்ʼ, ");
INSERT INTO santam_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","யதஸ்த்வம்ʼ ஸ்வீயவசோபி⁴ ர்நிரபராத⁴​: ஸ்வீயவசோபி⁴ஸ்²ச ஸாபராதோ⁴ க³ணிஷ்யஸே| ");
INSERT INTO santam_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ததா³நீம்ʼ கதிபயா உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச ஜக³து³​:, ஹே கு³ரோ வயம்ʼ ப⁴வத்த​: கிஞ்சந லக்ஷ்ம தி³த்³ருʼக்ஷாம​:| ");
INSERT INTO santam_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ததா³ ஸ ப்ரத்யுக்தவாந், து³ஷ்டோ வ்யபி⁴சாரீ ச வம்ʼஸோ² லக்ஷ்ம ம்ருʼக³யதே, கிந்து ப⁴விஷ்யத்³வாதி³நோ யூநஸோ லக்ஷ்ம விஹாயாந்யத் கிமபி லக்ஷ்ம தே ந ப்ரத³ர்ஸ²யிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","யதோ யூநம் யதா² த்ர்யஹோராத்ரம்ʼ ப்³ருʼஹந்மீநஸ்ய குக்ஷாவாஸீத், ததா² மநுஜபுத்ரோபி த்ர்யஹோராத்ரம்ʼ மேதி³ந்யா மத்⁴யே ஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","அபரம்ʼ நீநிவீயா மாநவா விசாரதி³ந ஏதத்³வம்ʼஸீ²யாநாம்ʼ ப்ரதிகூலம் உத்தா²ய தாந் தோ³ஷிண​: கரிஷ்யந்தி, யஸ்மாத்தே யூநஸ உபதே³ஸா²த் மநாம்ʼஸி பராவர்த்தயாஞ்சக்ரிரே, கிந்த்வத்ர யூநஸோபி கு³ருதர ஏக ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","புநஸ்²ச த³க்ஷிணதே³ஸீ²யா ராஜ்ஞீ விசாரதி³ந ஏதத்³வம்ʼஸீ²யாநாம்ʼ ப்ரதிகூலமுத்தா²ய தாந் தோ³ஷிண​: கரிஷ்யதி யத​: ஸா ராஜ்ஞீ ஸுலேமநோ வித்³யாயா​: கதா²ம்ʼ ஸ்²ரோதும்ʼ மேதி³ந்யா​: ஸீம்ந ஆக³ச்ச²த், கிந்து ஸுலேமநோபி கு³ருதர ஏகோ ஜநோ(அ)த்ர ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","அபரம்ʼ மநுஜாத்³ ப³ஹிர்க³தோ (அ)பவித்ரபூ⁴த​: ஸு²ஷ்கஸ்தா²நேந க³த்வா விஸ்²ராமம்ʼ க³வேஷயதி, கிந்து தத³லப⁴மாந​: ஸ வக்தி, யஸ்மா; நிகேதநாத்³ ஆக³மம்ʼ, ததே³வ வேஸ்²ம பகாவ்ருʼத்ய யாமி| ");
INSERT INTO santam_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","பஸ்²சாத் ஸ தத் ஸ்தா²நம் உபஸ்தா²ய தத் ஸூ²ந்யம்ʼ மார்ஜ்ஜிதம்ʼ ஸோ²பி⁴தஞ்ச விலோக்ய வ்ரஜந் ஸ்வதோபி து³ஷ்டதராந் அந்யஸப்தபூ⁴தாந் ஸங்கி³ந​: கரோதி| ");
INSERT INTO santam_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ததஸ்தே தத் ஸ்தா²நம்ʼ ப்ரவிஸ்²ய நிவஸந்தி, தேந தஸ்ய மநுஜஸ்ய ஸே²ஷத³ஸா² பூர்வ்வத³ஸா²தோதீவாஸு²பா⁴ ப⁴வதி, ஏதேஷாம்ʼ து³ஷ்டவம்ʼஸ்²யாநாமபி ததை²வ க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","மாநவேப்⁴ய ஏதாஸாம்ʼ கத²நாம்ʼ கத²நகாலே தஸ்ய மாதா ஸஹஜாஸ்²ச தேந ஸாகம்ʼ காஞ்சித் கதா²ம்ʼ கத²யிதும்ʼ வாஞ்ச²ந்தோ ப³ஹிரேவ ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","தத​: கஸ்²சித் தஸ்மை கதி²தவாந், பஸ்²ய தவ ஜநநீ ஸஹஜாஸ்²ச த்வயா ஸாகம்ʼ காஞ்சந கதா²ம்ʼ கத²யிதும்ʼ காமயமாநா ப³ஹிஸ்திஷ்ட²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","கிந்து ஸ தம்ʼ ப்ரத்யவத³த், மம கா ஜநநீ? கே வா மம ஸஹஜா​:? ");
INSERT INTO santam_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","பஸ்²சாத் ஸி²ஷ்யாந் ப்ரதி கரம்ʼ ப்ரஸார்ய்ய கதி²தவாந், பஸ்²ய மம ஜநநீ மம ஸஹஜாஸ்²சைதே; ");
INSERT INTO santam_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ய​: கஸ்²சித் மம ஸ்வர்க³ஸ்த²ஸ்ய பிதுரிஷ்டம்ʼ கர்ம்ம குருதே, ஸஏவ மம ப்⁴ராதா ப⁴கி³நீ ஜநநீ ச| ");
INSERT INTO santam_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","அபரஞ்ச தஸ்மிந் தி³நே யீஸு²​: ஸத்³மநோ க³த்வா ஸரித்பதே ரோத⁴ஸி ஸமுபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","தத்ர தத்ஸந்நிதௌ⁴ ப³ஹுஜநாநாம்ʼ நிவஹோபஸ்தி²தே​: ஸ தரணிமாருஹ்ய ஸமுபாவிஸ²த், தேந மாநவா ரோத⁴ஸி ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ததா³நீம்ʼ ஸ த்³ருʼஷ்டாந்தைஸ்தாந் இத்த²ம்ʼ ப³ஹுஸ² உபதி³ஷ்டவாந்| பஸ்²யத, கஸ்²சித் க்ருʼஷீவலோ பீ³ஜாநி வப்தும்ʼ ப³ஹிர்ஜகா³ம, ");
INSERT INTO santam_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","தஸ்ய வபநகாலே கதிபயபீ³ஜேஷு மார்க³பார்ஸ்²வே பதிதேஷு விஹகா³ஸ்தாநி ப⁴க்ஷிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","அபரம்ʼ கதிபயபீ³ஜேஷு ஸ்தோகம்ருʼத்³யுக்தபாஷாணே பதிதேஷு ம்ருʼத³ல்பத்வாத் தத்க்ஷணாத் தாந்யங்குரிதாநி, ");
INSERT INTO santam_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","கிந்து ரவாவுதி³தே த³க்³தா⁴நி தேஷாம்ʼ மூலாப்ரவிஷ்டத்வாத் ஸு²ஷ்கதாம்ʼ க³தாநி ச| ");
INSERT INTO santam_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","அபரம்ʼ கதிபயபீ³ஜேஷு கண்டகாநாம்ʼ மத்⁴யே பதிதேஷு கண்டகாந்யேதி⁴த்வா தாநி ஜக்³ரஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","அபரஞ்ச கதிபயபீ³ஜாநி உர்வ்வராயாம்ʼ பதிதாநி; தேஷாம்ʼ மத்⁴யே காநிசித் ஸ²தகு³ணாநி காநிசித் ஷஷ்டிகு³ணாநி காநிசித் த்ரிம்ʼஸ²கு³ம்ʼணாநி ப²லாநி ப²லிதவந்தி| ");
INSERT INTO santam_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ஸ்²ரோதும்ʼ யஸ்ய ஸ்²ருதீ ஆஸாதே ஸ ஸ்²ருʼணுயாத்| ");
INSERT INTO santam_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","அநந்தரம்ʼ ஸி²ஷ்யைராக³த்ய ஸோ(அ)ப்ருʼச்ச்²யத, ப⁴வதா தேப்⁴ய​: குதோ த்³ருʼஷ்டாந்தகதா² கத்²யதே? ");
INSERT INTO santam_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","தத​: ஸ ப்ரத்யவத³த், ஸ்வர்க³ராஜ்யஸ்ய நிகூ³டா⁴ம்ʼ கதா²ம்ʼ வேதி³தும்ʼ யுஷ்மப்⁴யம்ʼ ஸாமர்த்²யமதா³யி, கிந்து தேப்⁴யோ நாதா³யி| ");
INSERT INTO santam_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","யஸ்மாத்³ யஸ்யாந்திகே வர்த்³த⁴தே, தஸ்மாயேவ தா³யிஷ்யதே, தஸ்மாத் தஸ்ய பா³ஹுல்யம்ʼ ப⁴விஷ்யதி, கிந்து யஸ்யாந்திகே ந வர்த்³த⁴தே, தஸ்ய யத் கிஞ்சநாஸ்தே, தத³பி தஸ்மாத்³ ஆதா³யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","தே பஸ்²யந்தோபி ந பஸ்²யந்தி, ஸ்²ருʼண்வந்தோபி ந ஸ்²ருʼண்வந்தி, பு³த்⁴யமாநா அபி ந பு³த்⁴யந்தே ச, தஸ்மாத் தேப்⁴யோ த்³ருʼஷ்டாந்தகதா² கத்²யதே| ");
INSERT INTO santam_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","யதா² கர்ணை​: ஸ்²ரோஷ்யத² யூயம்ʼ வை கிந்து யூயம்ʼ ந போ⁴த்ஸ்யத²| நேத்ரைர்த்³ரக்ஷ்யத² யூயஞ்ச பரிஜ்ஞாதும்ʼ ந ஸ²க்ஷ்யத²| தே மாநுஷா யதா² நைவ பரிபஸ்²யந்தி லோசநை​:| கர்ணை ர்யதா² ந ஸ்²ருʼண்வந்தி ந பு³த்⁴யந்தே ச மாநஸை​:| வ்யாவர்த்திதேஷு சித்தேஷு காலே குத்ராபி தைர்ஜநை​:| மத்தஸ்தே மநுஜா​: ஸ்வஸ்தா² யதா² நைவ ப⁴வந்தி ச| ததா² தேஷாம்ʼ மநுஷ்யாணாம்ʼ க்ரியந்தே ஸ்தூ²லபு³த்³த⁴ய​:| ப³தி⁴ரீபூ⁴தகர்ணாஸ்²ச ஜாதாஸ்²ச முத்³ரிதா த்³ருʼஸ²​:| ");
INSERT INTO santam_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","யதே³தாநி வசநாநி யிஸ²யியப⁴விஷ்யத்³வாதி³நா ப்ரோக்தாநி தேஷு தாநி ப²லந்தி| ");
INSERT INTO santam_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","கிந்து யுஷ்மாகம்ʼ நயநாநி த⁴ந்யாநி, யஸ்மாத் தாநி வீக்ஷந்தே; த⁴ந்யாஸ்²ச யுஷ்மாகம்ʼ ஸ²ப்³த³க்³ரஹா​:, யஸ்மாத் தைராகர்ண்யதே| ");
INSERT INTO santam_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","மயா யூயம்ʼ தத்²யம்ʼ வசாமி யுஷ்மாபி⁴ ர்யத்³யத்³ வீக்ஷ்யதே, தத்³ ப³ஹவோ ப⁴விஷ்யத்³வாதி³நோ தா⁴ர்ம்மிகாஸ்²ச மாநவா தி³த்³ருʼக்ஷந்தோபி த்³ரஷ்டும்ʼ நாலப⁴ந்த, புநஸ்²ச யூயம்ʼ யத்³யத் ஸ்²ருʼணுத², தத் தே ஸு²ஸ்²ரூஷமாணா அபி ஸ்²ரோதும்ʼ நாலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","க்ருʼஷீவலீயத்³ருʼஷ்டாந்தஸ்யார்த²ம்ʼ ஸ்²ருʼணுத| ");
INSERT INTO santam_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","மார்க³பார்ஸ்²வே பீ³ஜாந்யுப்தாநி தஸ்யார்த² ஏஷ​:, யதா³ கஸ்²சித் ராஜ்யஸ்ய கதா²ம்ʼ நிஸ²ம்ய ந பு³த்⁴யதே, ததா³ பாபாத்மாக³த்ய ததீ³யமநஸ உப்தாம்ʼ கதா²ம்ʼ ஹரந் நயதி| ");
INSERT INTO santam_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","அபரம்ʼ பாஷாணஸ்த²லே பீ³ஜாந்யுப்தாநி தஸ்யார்த² ஏஷ​:; கஸ்²சித் கதா²ம்ʼ ஸ்²ருத்வைவ ஹர்ஷசித்தேந க்³ருʼஹ்லாதி, ");
INSERT INTO santam_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","கிந்து தஸ்ய மநஸி மூலாப்ரவிஷ்டத்வாத் ஸ கிஞ்சித்காலமாத்ரம்ʼ ஸ்தி²ரஸ்திஷ்ட²தி; பஸ்²சாத தத்கதா²காரணாத் கோபி க்லேஸ்தாட³நா வா சேத் ஜாயதே, தர்ஹி ஸ தத்க்ஷணாத்³ விக்⁴நமேதி| ");
INSERT INTO santam_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","அபரம்ʼ கண்டகாநாம்ʼ மத்⁴யே பீ³ஜாந்யுப்தாநி தத³ர்த² ஏஷ​:; கேநசித் கதா²யாம்ʼ ஸ்²ருதாயாம்ʼ ஸாம்ʼஸாரிகசிந்தாபி⁴ ர்ப்⁴ராந்திபி⁴ஸ்²ச ஸா க்³ரஸ்யதே, தேந ஸா மா விப²லா ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","அபரம் உர்வ்வராயாம்ʼ பீ³ஜாந்யுப்தாநி தத³ர்த² ஏஷ​:; யே தாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா வுத்⁴யந்தே, தே ப²லிதா​: ஸந்த​: கேசித் ஸ²தகு³ணாநி கேசித ஷஷ்டிகு³ணாநி கேசிச்ச த்ரிம்ʼஸ²த்³கு³ணாநி ப²லாநி ஜநயந்தி| ");
INSERT INTO santam_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","அநந்தரம்ʼ ஸோபராமேகாம்ʼ த்³ருʼஷ்டாந்தகதா²முபஸ்தா²ப்ய தேப்⁴ய​: கத²யாமாஸ; ஸ்வர்கீ³யராஜ்யம்ʼ தாத்³ருʼஸே²ந கேநசித்³ க்³ருʼஹஸ்தே²நோபமீயதே, யேந ஸ்வீயக்ஷேத்ரே ப்ரஸ²ஸ்தபீ³ஜாந்யௌப்யந்த| ");
INSERT INTO santam_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","கிந்து க்ஷணதா³யாம்ʼ ஸகலலோகேஷு ஸுப்தேஷு தஸ்ய ரிபுராக³த்ய தேஷாம்ʼ கோ³தூ⁴மபீ³ஜாநாம்ʼ மத்⁴யே வந்யயவமபீ³ஜாந்யுப்த்வா வவ்ராஜ| ");
INSERT INTO santam_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ததோ யதா³ பீ³ஜேப்⁴யோ(அ)ங்கரா ஜாயமாநா​: கணிஸா²நி க்⁴ருʼதவந்த​:; ததா³ வந்யயவஸாந்யபி த்³ருʼஸ்²யமாநாந்யப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ததோ க்³ருʼஹஸ்த²ஸ்ய தா³ஸேயா ஆக³ம்ய தஸ்மை கத²யாஞ்சக்ரு​:, ஹே மஹேச்ச², ப⁴வதா கிம்ʼ க்ஷேத்ரே ப⁴த்³ரபீ³ஜாநி நௌப்யந்த? ததா²த்வே வந்யயவஸாநி க்ருʼத ஆயந்? ");
INSERT INTO santam_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ததா³நீம்ʼ தேந தே ப்ரதிக³தி³தா​:, கேநசித் ரிபுணா கர்ம்மத³மகாரி| தா³ஸேயா​: கத²யாமாஸு​:, வயம்ʼ க³த்வா தாந்யுத்பாய்ய க்ஷிபாமோ ப⁴வத​: கீத்³ருʼஸீ²ச்சா² ஜாயதே? ");
INSERT INTO santam_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","தேநாவாதி³, நஹி, ஸ²ங்கே(அ)ஹம்ʼ வந்யயவஸோத்பாடநகாலே யுஷ்மாபி⁴ஸ்தை​: ஸாகம்ʼ கோ³தூ⁴மா அப்யுத்பாடிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","அத​: ஸ்²ஸ்யகர்த்தநகாலம்ʼ யாவத்³ உப⁴யாந்யபி ஸஹ வர்த்³த⁴ந்தாம்ʼ, பஸ்²சாத் கர்த்தநகாலே கர்த்தகாந் வக்ஷ்யாமி, யூயமாதௌ³ வந்யயவஸாநி ஸம்ʼக்³ருʼஹ்ய தா³ஹயிதும்ʼ வீடிகா ப³த்³வ்வா ஸ்தா²பயத; கிந்து ஸர்வ்வே கோ³தூ⁴மா யுஷ்மாபி⁴ ர்பா⁴ண்டா³கா³ரம்ʼ நீத்வா ஸ்தா²ப்யந்தாம்| ");
INSERT INTO santam_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","அநந்தரம்ʼ ஸோபராமேகாம்ʼ த்³ருʼஷ்டாந்தகதா²முத்தா²ப்ய தேப்⁴ய​: கதி²தவாந் கஸ்²சிந்மநுஜ​: ஸர்ஷபபீ³ஜமேகம்ʼ நீத்வா ஸ்வக்ஷேத்ர உவாப| ");
INSERT INTO santam_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ஸர்ஷபபீ³ஜம்ʼ ஸர்வ்வஸ்மாத்³ பீ³ஜாத் க்ஷுத்³ரமபி ஸத³ங்குரிதம்ʼ ஸர்வ்வஸ்மாத் ஸா²காத் ப்³ருʼஹத்³ ப⁴வதி; ஸ தாத்³ருʼஸ²ஸ்தரு ர்ப⁴வதி, யஸ்ய ஸா²கா²ஸு நப⁴ஸ​: க²கா³ ஆக³த்ய நிவஸந்தி; ஸ்வர்கீ³யராஜ்யம்ʼ தாத்³ருʼஸ²ஸ்ய ஸர்ஷபைகஸ்ய ஸமம்| ");
INSERT INTO santam_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","புநரபி ஸ உபமாகதா²மேகாம்ʼ தேப்⁴ய​: கத²யாஞ்சகார; காசந யோஷித் யத் கிண்வமாதா³ய த்³ரோணத்ரயமிதகோ³தூ⁴மசூர்ணாநாம்ʼ மத்⁴யே ஸர்வ்வேஷாம்ʼ மிஸ்ரீப⁴வநபர்ய்யந்தம்ʼ ஸமாச்சா²த்³ய நித⁴த்தவதீ, தத்கிண்வமிவ ஸ்வர்க³ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","இத்த²ம்ʼ யீஸு² ர்மநுஜநிவஹாநாம்ʼ ஸந்நிதா⁴வுபமாகதா²பி⁴ரேதாந்யாக்²யாநாநி கதி²தவாந் உபமாம்ʼ விநா தேப்⁴ய​: கிமபி கதா²ம்ʼ நாகத²யத்| ");
INSERT INTO santam_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ஏதேந த்³ருʼஷ்டாந்தீயேந வாக்யேந வ்யாதா³ய வத³நம்ʼ நிஜம்ʼ| அஹம்ʼ ப்ரகாஸ²யிஷ்யாமி கு³ப்தவாக்யம்ʼ புராப⁴வம்ʼ| யதே³தத்³வசநம்ʼ ப⁴விஷ்யத்³வாதி³நா ப்ரோக்தமாஸீத், தத் ஸித்³த⁴மப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ஸர்வ்வாந் மநுஜாந் விஸ்ருʼஜ்ய யீஸௌ² க்³ருʼஹம்ʼ ப்ரவிஷ்டே தச்சி²ஷ்யா ஆக³த்ய யீஸ²வே கதி²தவந்த​:, க்ஷேத்ரஸ்ய வந்யயவஸீயத்³ருʼஷ்டாந்தகதா²ம் ப⁴வாந அஸ்மாந் ஸ்பஷ்டீக்ருʼத்ய வத³து| ");
INSERT INTO santam_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","தத​: ஸ ப்ரத்யுவாச, யேந ப⁴த்³ரபீ³ஜாந்யுப்யந்தே ஸ மநுஜபுத்ர​:, ");
INSERT INTO santam_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","க்ஷேத்ரம்ʼ ஜக³த், ப⁴த்³ரபீ³ஜாநீ ராஜ்யஸ்ய ஸந்தாநா​:, ");
INSERT INTO santam_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","வந்யயவஸாநி பாபாத்மந​: ஸந்தாநா​:| யேந ரிபுணா தாந்யுப்தாநி ஸ ஸ²யதாந​:, கர்த்தநஸமயஸ்²ச ஜக³த​: ஸே²ஷ​:, கர்த்தகா​: ஸ்வர்கீ³யதூ³தா​:| ");
INSERT INTO santam_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","யதா² வந்யயவஸாநி ஸம்ʼக்³ருʼஹ்ய தா³ஹ்யந்தே, ததா² ஜக³த​: ஸே²ஷே ப⁴விஷ்யதி; ");
INSERT INTO santam_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","அர்தா²த் மநுஜஸுத​: ஸ்வாம்ʼயதூ³தாந் ப்ரேஷயிஷ்யதி, தேந தே ச தஸ்ய ராஜ்யாத் ஸர்வ்வாந் விக்⁴நகாரிணோ(அ)தா⁴ர்ம்மிகலோகாம்ʼஸ்²ச ஸம்ʼக்³ருʼஹ்ய ");
INSERT INTO santam_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","யத்ர ரோத³நம்ʼ த³ந்தக⁴ர்ஷணஞ்ச ப⁴வதி, தத்ராக்³நிகுண்டே³ நிக்ஷேப்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ததா³நீம்ʼ தா⁴ர்ம்மிகலோகா​: ஸ்வேஷாம்ʼ பிதூ ராஜ்யே பா⁴ஸ்கரஇவ தேஜஸ்விநோ ப⁴விஷ்யந்தி| ஸ்²ரோதும்ʼ யஸ்ய ஸ்²ருதீ ஆஸாதே, ம ஸ்²ருʼணுயாத்| ");
INSERT INTO santam_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","அபரஞ்ச க்ஷேத்ரமத்⁴யே நிதி⁴ம்ʼ பஸ்²யந் யோ கோ³பயதி, தத​: பரம்ʼ ஸாநந்தோ³ க³த்வா ஸ்வீயஸர்வ்வஸ்வம்ʼ விக்ரீய த்தக்ஷேத்ரம்ʼ க்ரீணாதி, ஸ இவ ஸ்வர்க³ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","அந்யஞ்ச யோ வணிக் உத்தமாம்ʼ முக்தாம்ʼ க³வேஷயந் ");
INSERT INTO santam_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","மஹார்கா⁴ம்ʼ முக்தாம்ʼ விலோக்ய நிஜஸர்வ்வஸ்வம்ʼ விக்ரீய தாம்ʼ க்ரீணாதி, ஸ இவ ஸ்வர்க³ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","புநஸ்²ச ஸமுத்³ரோ நிக்ஷிப்த​: ஸர்வ்வப்ரகாரமீநஸம்ʼக்³ராஹ்யாநாயஇவ ஸ்வர்க³ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","தஸ்மிந் ஆநாயே பூர்ணே ஜநா யதா² ரோத⁴ஸ்யுத்தோல்ய ஸமுபவிஸ்²ய ப்ரஸ²ஸ்தமீநாந் ஸம்ʼக்³ரஹ்ய பா⁴ஜநேஷு நித³த⁴தே, குத்ஸிதாந் நிக்ஷிபந்தி; ");
INSERT INTO santam_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ததை²வ ஜக³த​: ஸே²ஷே ப⁴விஷ்யதி, ப²லத​: ஸ்வர்கீ³யதூ³தா ஆக³த்ய புண்யவஜ்ஜநாநாம்ʼ மத்⁴யாத் பாபிந​: ப்ருʼத²க் க்ருʼத்வா வஹ்நிகுண்டே³ நிக்ஷேப்ஸ்யந்தி, ");
INSERT INTO santam_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","தத்ர ரோத³நம்ʼ த³ந்தை ர்த³ந்தக⁴ர்ஷணஞ்ச ப⁴விஷ்யத​:| ");
INSERT INTO santam_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","யீஸு²நா தே ப்ருʼஷ்டா யுஷ்மாபி⁴​: கிமேதாந்யாக்²யாநாந்யபு³த்⁴யந்த? ததா³ தே ப்ரத்யவத³ந், ஸத்யம்ʼ ப்ரபோ⁴| ");
INSERT INTO santam_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ததா³நீம்ʼ ஸ கதி²தவாந், நிஜபா⁴ண்டா³கா³ராத் நவீநபுராதநாநி வஸ்தூநி நிர்க³மயதி யோ க்³ருʼஹஸ்த²​: ஸ இவ ஸ்வர்க³ராஜ்யமதி⁴ ஸி²க்ஷிதா​: ஸ்வர்வ உபதே³ஷ்டார​:| ");
INSERT INTO santam_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","அநந்தரம்ʼ யீஸு²ரேதா​: ஸர்வ்வா த்³ருʼஷ்டாந்தகதா²​: ஸமாப்ய தஸ்மாத் ஸ்தா²நாத் ப்ரதஸ்தே²| அபரம்ʼ ஸ்வதே³ஸ²மாக³த்ய ஜநாந் ப⁴ஜநப⁴வந உபதி³ஷ்டவாந்; ");
INSERT INTO santam_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","தே விஸ்மயம்ʼ க³த்வா கதி²தவந்த ஏதஸ்யைதாத்³ருʼஸ²ம்ʼ ஜ்ஞாநம் ஆஸ்²சர்ய்யம்ʼ கர்ம்ம ச கஸ்மாத்³ அஜாயத? ");
INSERT INTO santam_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","கிமயம்ʼ ஸூத்ரதா⁴ரஸ்ய புத்ரோ நஹி? ஏதஸ்ய மாது ர்நாம ச கிம்ʼ மரியம் நஹி? யாகுப்³-யூஷப்²-ஸி²மோந்-யிஹூதா³ஸ்²ச கிமேதஸ்ய ப்⁴ராதரோ நஹி? ");
INSERT INTO santam_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ஏதஸ்ய ப⁴கி³ந்யஸ்²ச கிமஸ்மாகம்ʼ மத்⁴யே ந ஸந்தி? தர்ஹி கஸ்மாத³யமேதாநி லப்³த⁴வாந்? இத்த²ம்ʼ ஸ தேஷாம்ʼ விக்⁴நரூபோ ப³பூ⁴வ; ");
INSERT INTO santam_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ததோ யீஸு²நா நிக³தி³தம்ʼ ஸ்வதே³ஸீ²யஜநாநாம்ʼ மத்⁴யம்ʼ விநா ப⁴விஷ்யத்³வாதீ³ குத்ராப்யந்யத்ர நாஸம்மாந்யோ ப⁴வதீ| ");
INSERT INTO santam_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","தேஷாமவிஸ்²வாஸஹேதோ​: ஸ தத்ர ஸ்தா²நே ப³ஹ்வாஸ்²சர்ய்யகர்ம்மாணி ந க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ததா³நீம்ʼ ராஜா ஹேரோத்³ யீஸோ² ர்யஸ²​: ஸ்²ருத்வா நிஜதா³ஸேயாந் ஜகா³த்³, ");
INSERT INTO santam_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ஏஷ மஜ்ஜயிதா யோஹந், ப்ரமிதேப⁴யஸ்தஸ்யோத்தா²நாத் தேநேத்த²மத்³பு⁴தம்ʼ கர்ம்ம ப்ரகாஸ்²யதே| ");
INSERT INTO santam_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","புரா ஹேரோத்³ நிஜப்⁴ராது: பி²லிபோ ஜாயாயா ஹேரோதீ³யாயா அநுரோதா⁴த்³ யோஹநம்ʼ தா⁴ரயித்வா ப³த்³தா⁴ காராயாம்ʼ ஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","யதோ யோஹந் உக்தவாந், ஏத்ஸயா​: ஸம்ʼக்³ரஹோ ப⁴வதோ நோசித​:| ");
INSERT INTO santam_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","தஸ்மாத் ந்ருʼபதிஸ்தம்ʼ ஹந்துமிச்ச²ந்நபி லோகேப்⁴யோ விப⁴யாஞ்சகார; யத​: ஸர்வ்வே யோஹநம்ʼ ப⁴விஷ்யத்³வாதி³நம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","கிந்து ஹேரோதோ³ ஜந்மாஹீயமஹ உபஸ்தி²தே ஹேரோதீ³யாயா து³ஹிதா தேஷாம்ʼ ஸமக்ஷம்ʼ ந்ருʼதித்வா ஹேரோத³மப்ரீண்யத்| ");
INSERT INTO santam_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","தஸ்மாத் பூ⁴பதி​: ஸ²பத²ம்ʼ குர்வ்வந் இதி ப்ரத்யஜ்ஞாஸீத், த்வயா யத்³ யாச்யதே, ததே³வாஹம்ʼ தா³ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ஸா குமாரீ ஸ்வீயமாது​: ஸி²க்ஷாம்ʼ லப்³தா⁴ ப³பா⁴ஷே, மஜ்ஜயிதுர்யோஹந உத்தமாங்க³ம்ʼ பா⁴ஜநே ஸமாநீய மஹ்யம்ʼ விஸ்²ராணய| ");
INSERT INTO santam_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ததோ ராஜா ஸு²ஸோ²ச, கிந்து போ⁴ஜநாயோபவிஸ²தாம்ʼ ஸங்கி³நாம்ʼ ஸ்வக்ருʼதஸ²பத²ஸ்ய சாநுரோதா⁴த் தத் ப்ரதா³தும ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","பஸ்²சாத் காராம்ʼ ப்ரதி நரம்ʼ ப்ரஹித்ய யோஹந உத்தமாங்க³ம்ʼ சி²த்த்வா ");
INSERT INTO santam_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","தத் பா⁴ஜந ஆநாய்ய தஸ்யை குமார்ய்யை வ்யஸ்²ராணயத், தத​: ஸா ஸ்வஜநந்யா​: ஸமீபம்ʼ தந்நிநாய| ");
INSERT INTO santam_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","பஸ்²சாத் யோஹந​: ஸி²ஷ்யா ஆக³த்ய காயம்ʼ நீத்வா ஸ்²மஸா²நே ஸ்தா²பயாமாஸுஸ்ததோ யீஸோ²​: ஸந்நிதி⁴ம்ʼ வ்ரஜித்வா தத்³வார்த்தாம்ʼ ப³பா⁴ஷிரே| ");
INSERT INTO santam_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","அநந்தரம்ʼ யீஸு²ரிதி நிஸ²ப்⁴ய நாவா நிர்ஜநஸ்தா²நம் ஏகாகீ க³தவாந், பஸ்²சாத் மாநவாஸ்தத் ஸ்²ருத்வா நாநாநக³ரேப்⁴ய ஆக³த்ய பதை³ஸ்தத்பஸ்²சாத்³ ஈயு​:| ");
INSERT INTO santam_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ததா³நீம்ʼ யீஸு² ர்ப³ஹிராக³த்ய மஹாந்தம்ʼ ஜநநிவஹம்ʼ நிரீக்ஷ்ய தேஷு காருணிக​: மந் தேஷாம்ʼ பீடி³தஜநாந் நிராமயாந் சகார| ");
INSERT INTO santam_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","தத​: பரம்ʼ ஸந்த்⁴யாயாம்ʼ ஸி²ஷ்யாஸ்தத³ந்திகமாக³த்ய கத²யாஞ்சக்ரு​:, இத³ம்ʼ நிர்ஜநஸ்தா²நம்ʼ வேலாப்யவஸந்நா; தஸ்மாத் மநுஜாந் ஸ்வஸ்வக்³ராமம்ʼ க³ந்தும்ʼ ஸ்வார்த²ம்ʼ ப⁴க்ஷ்யாணி க்ரேதுஞ்ச ப⁴வாந் தாந் விஸ்ருʼஜது| ");
INSERT INTO santam_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","கிந்து யீஸு²ஸ்தாநவாதீ³த், தேஷாம்ʼ க³மநே ப்ரயோஜநம்ʼ நாஸ்தி, யூயமேவ தாந் போ⁴ஜயத| ");
INSERT INTO santam_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ததா³ தே ப்ரத்யவத³ந், அஸ்மாகமத்ர பூபபஞ்சகம்ʼ மீநத்³வயஞ்சாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ததா³நீம்ʼ தேநோக்தம்ʼ தாநி மத³ந்திகமாநயத| ");
INSERT INTO santam_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","அநந்தரம்ʼ ஸ மநுஜாந் யவஸோபர்ய்யுபவேஷ்டும் ஆஜ்ஞாபயாமாஸ; அபர தத் பூபபஞ்சகம்ʼ மீநத்³வயஞ்ச க்³ருʼஹ்லந் ஸ்வர்க³ம்ʼ ப்ரதி நிரீக்ஷ்யேஸ்²வரீயகு³ணாந் அநூத்³ய ப⁴ம்ʼக்த்வா ஸி²ஷ்யேப்⁴யோ த³த்தவாந், ஸி²ஷ்யாஸ்²ச லோகேப்⁴யோ த³து³​:| ");
INSERT INTO santam_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","தத​: ஸர்வ்வே பு⁴க்த்வா பரித்ருʼப்தவந்த​:, ததஸ்தத³வஸி²ஷ்டப⁴க்ஷ்யை​: பூர்ணாந் த்³வாத³ஸ²ட³லகாந் க்³ருʼஹீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","தே போ⁴க்தார​: ஸ்த்ரீர்பா³லகாம்ʼஸ்²ச விஹாய ப்ராயேண பஞ்ச ஸஹஸ்ராணி புமாம்ʼஸ ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","தத³நந்தரம்ʼ யீஸு² ர்லோகாநாம்ʼ விஸர்ஜநகாலே ஸி²ஷ்யாந் தரணிமாரோடு⁴ம்ʼ ஸ்வாக்³ரே பாரம்ʼ யாதுஞ்ச கா³ட⁴மாதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ததோ லோகேஷு விஸ்ருʼஷ்டேஷு ஸ விவிக்தே ப்ரார்த²யிதும்ʼ கி³ரிமேகம்ʼ க³த்வா ஸந்த்⁴யாம்ʼ யாவத் தத்ரைகாகீ ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","கிந்து ததா³நீம்ʼ ஸம்முக²வாதத்வாத் ஸரித்பதே ர்மத்⁴யே தரங்கை³ஸ்தரணிர்தோ³லாயமாநாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ததா³ ஸ யாமிந்யாஸ்²சதுர்த²ப்ரஹரே பத்³ப்⁴யாம்ʼ வ்ரஜந் தேஷாமந்திகம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","கிந்து ஸி²ஷ்யாஸ்தம்ʼ ஸாக³ரோபரி வ்ரஜந்தம்ʼ விலோக்ய ஸமுத்³விக்³நா ஜக³து³​:, ஏஷ பூ⁴த இதி ஸ²ங்கமாநா உச்சை​: ஸ²ப்³தா³யாஞ்சக்ரிரே ச| ");
INSERT INTO santam_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ததை³வ யீஸு²ஸ்தாநவத³த், ஸுஸ்தி²ரா ப⁴வத, மா பை⁴ஷ்ட, ஏஷோ(அ)ஹம்| ");
INSERT INTO santam_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","தத​: பிதர இத்யுக்தவாந், ஹே ப்ரபோ⁴, யதி³ ப⁴வாநேவ, தர்ஹி மாம்ʼ ப⁴வத்ஸமீபம்ʼ யாதுமாஜ்ஞாபயது| ");
INSERT INTO santam_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","தத​: தேநாதி³ஷ்ட​: பிதரஸ்தரணிதோ(அ)வருஹ்ய யீஸே²ाரந்திகம்ʼ ப்ராப்தும்ʼ தோயோபரி வவ்ராஜ| ");
INSERT INTO santam_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","கிந்து ப்ரசண்ட³ம்ʼ பவநம்ʼ விலோக்ய ப⁴யாத் தோயே மம்ʼக்தும் ஆரேபே⁴, தஸ்மாத்³ உச்சை​: ஸ²ப்³தா³யமாந​: கதி²தவாந், ஹே ப்ரபோ⁴, மாமவது| ");
INSERT INTO santam_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","யீஸு²ஸ்தத்க்ஷணாத் கரம்ʼ ப்ரஸார்ய்ய தம்ʼ த⁴ரந் உக்தவாந், ஹ ஸ்தோகப்ரத்யயிந் த்வம்ʼ குத​: ஸமஸே²தா²​:? ");
INSERT INTO santam_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","அநந்தரம்ʼ தயோஸ்தரணிமாரூட⁴யோ​: பவநோ நிவவ்ருʼதே| ");
INSERT INTO santam_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ததா³நீம்ʼ யே தரண்யாமாஸந், த ஆக³த்ய தம்ʼ ப்ரணப்⁴ய கதி²தவந்த​:, யதா²ர்த²ஸ்த்வமேவேஸ்²வரஸுத​:| ");
INSERT INTO santam_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","அநந்தரம்ʼ பாரம்ʼ ப்ராப்ய தே கி³நேஷரந்நாமகம்ʼ நக³ரமுபதஸ்து²​:, ");
INSERT INTO santam_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ததா³ தத்ரத்யா ஜநா யீஸு²ம்ʼ பரிசீய தத்³தே³ஸ்²ஸ்ய சதுர்தி³ஸோ² வார்த்தாம்ʼ ப்ரஹித்ய யத்ர யாவந்த​: பீடி³தா ஆஸந், தாவதஏவ தத³ந்திகமாநயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","அபரம்ʼ ததீ³யவஸநஸ்ய க்³ரந்தி²மாத்ரம்ʼ ஸ்ப்ரஷ்டும்ʼ விநீய யாவந்தோ ஜநாஸ்தத் ஸ்பர்ஸ²ம்ʼ சக்ரிரே, தே ஸர்வ்வஏவ நிராமயா ப³பூ⁴வு​:| ");
INSERT INTO santam_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","அபரம்ʼ யிரூஸா²லம்நக³ரீயா​: கதிபயா அத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச யீஸோ²​: ஸமீபமாக³த்ய கத²யாமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","தவ ஸி²ஷ்யா​: கிமர்த²ம் அப்ரக்ஷாலிதகரை ர்ப⁴க்ஷித்வா பரம்பராக³தம்ʼ ப்ராசீநாநாம்ʼ வ்யவஹாரம்ʼ லங்வந்தே? ");
INSERT INTO santam_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ததோ யீஸு²​: ப்ரத்யுவாச, யூயம்ʼ பரம்பராக³தாசாரேண குத ஈஸ்²வராஜ்ஞாம்ʼ லங்வத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ஈஸ்²வர இத்யாஜ்ஞாபயத், த்வம்ʼ நிஜபிதரௌ ஸம்ʼமந்யேதா²​:, யேந ச நிஜபிதரௌ நிந்த்³யேதே, ஸ நிஸ்²சிதம்ʼ ம்ரியேத; ");
INSERT INTO santam_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","கிந்து யூயம்ʼ வத³த², ய​: ஸ்வஜநகம்ʼ ஸ்வஜநநீம்ʼ வா வாக்யமித³ம்ʼ வத³தி, யுவாம்ʼ மத்தோ யல்லபே⁴தே², தத் ந்யவித்³யத, ");
INSERT INTO santam_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ஸ நிஜபிதரௌ புந ர்ந ஸம்ʼமம்ʼஸ்யதே| இத்த²ம்ʼ யூயம்ʼ பரம்பராக³தேந ஸ்வேஷாமாசாரேணேஸ்²வரீயாஜ்ஞாம்ʼ லும்பத²| ");
INSERT INTO santam_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ரே கபடிந​: ஸர்வ்வே யிஸ²யியோ யுஷ்மாநதி⁴ ப⁴விஷ்யத்³வசநாந்யேதாநி ஸம்யக்³ உக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","வத³நை ர்மநுஜா ஏதே ஸமாயாந்தி மத³ந்திகம்ʼ| ததா²த⁴ரை ர்மதீ³யஞ்ச மாநம்ʼ குர்வ்வந்தி தே நரா​:| ");
INSERT INTO santam_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","கிந்து தேஷாம்ʼ மநோ மத்தோ விதூ³ரஏவ திஷ்ட²தி| ஸி²க்ஷயந்தோ விதீ⁴ந் ந்ராஜ்ஞா ப⁴ஜந்தே மாம்ʼ முதை⁴வ தே| ");
INSERT INTO santam_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ததோ யீஸு² ர்லோகாந் ஆஹூய ப்ரோக்தவாந், யூயம்ʼ ஸ்²ருத்வா பு³த்⁴யத்⁴ப³ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","யந்முக²ம்ʼ ப்ரவிஸ²தி, தத் மநுஜம் அமேத்⁴யம்ʼ ந கரோதி, கிந்து யதா³ஸ்யாத் நிர்க³ச்ச²தி, ததே³வ மாநுஷமமேத்⁴யீ கரோதீ| ");
INSERT INTO santam_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ததா³நீம்ʼ ஸி²ஷ்யா ஆக³த்ய தஸ்மை கத²யாஞ்சக்ரு​:, ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா பி²ரூஸி²நோ வ்யரஜ்யந்த, தத் கிம்ʼ ப⁴வதா ஜ்ஞாயதே? ");
INSERT INTO santam_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ஸ ப்ரத்யவத³த், மம ஸ்வர்க³ஸ்த²​: பிதா யம்ʼ கஞ்சித³ங்குரம்ʼ நாரோபயத், ஸ உத்பாவ்த்³யதே| ");
INSERT INTO santam_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","தே திஷ்ட²ந்து, தே அந்த⁴மநுஜாநாம் அந்த⁴மார்க³த³ர்ஸ²கா ஏவ; யத்³யந்தோ⁴(அ)ந்த⁴ம்ʼ பந்தா²நம்ʼ த³ர்ஸ²யதி, தர்ஹ்யுபௌ⁴ க³ர்த்தே பதத​:| ");
INSERT INTO santam_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ததா³ பிதரஸ்தம்ʼ ப்ரத்யவத³த், த்³ருʼஷ்டாந்தமிமமஸ்மாந் போ³த⁴யது| ");
INSERT INTO santam_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","யீஸு²நா ப்ரோக்தம்ʼ, யூயமத்³ய யாவத் கிமபோ³தா⁴​: ஸ்த²? ");
INSERT INTO santam_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","கதா²மிமாம்ʼ கிம்ʼ ந பு³த்⁴யத்⁴பே³ ? யதா³ஸ்யம்ʼ ப்ரேவிஸ²தி, தத்³ உத³ரே பதந் ப³ஹிர்நிர்யாதி, ");
INSERT INTO santam_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","கிந்த்வாஸ்யாத்³ யந்நிர்யாதி, தத்³ அந்த​:கரணாத் நிர்யாதத்வாத் மநுஜமமேத்⁴யம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","யதோ(அ)ந்த​:கரணாத் குசிந்தா ப³த⁴​: பாரதா³ரிகதா வேஸ்²யாக³மநம்ʼ சைர்ய்யம்ʼ மித்²யாஸாக்ஷ்யம் ஈஸ்²வரநிந்தா³ சைதாநி ஸர்வ்வாணி நிர்ய்யாந்தி| ");
INSERT INTO santam_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ஏதாநி மநுஷ்யமபவித்ரீ குர்வ்வந்தி கிந்த்வப்ரக்ஷாலிதகரேண போ⁴ஜநம்ʼ மநுஜமமேத்⁴யம்ʼ ந கரோதி| ");
INSERT INTO santam_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","அநந்தரம்ʼ யீஸு²ஸ்தஸ்மாத் ஸ்தா²நாத் ப்ரஸ்தா²ய ஸோரஸீதோ³ந்நக³ரயோ​: ஸீமாமுபதஸ்யௌ| ");
INSERT INTO santam_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ததா³ தத்ஸீமாத​: காசித் கிநாநீயா யோஷித்³ ஆக³த்ய தமுச்சைருவாச, ஹே ப்ரபோ⁴ தா³யூத³​: ஸந்தாந, மமைகா து³ஹிதாஸ்தே ஸா பூ⁴தக்³ரஸ்தா ஸதீ மஹாக்லேஸ²ம்ʼ ப்ராப்நோதி மம த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","கிந்து யீஸு²ஸ்தாம்ʼ கிமபி நோக்தவாந், தத​: ஸி²ஷ்யா ஆக³த்ய தம்ʼ நிவேத³யாமாஸு​:, ஏஷா யோஷித்³ அஸ்மாகம்ʼ பஸ்²சாத்³ உச்சைராஹூயாக³ச்ச²தி, ஏநாம்ʼ விஸ்ருʼஜது| ");
INSERT INTO santam_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ததா³ ஸ ப்ரத்யவத³த், இஸ்ராயேல்கோ³த்ரஸ்ய ஹாரிதமேஷாந் விநா கஸ்யாப்யந்யஸ்ய ஸமீபம்ʼ நாஹம்ʼ ப்ரேஷிதோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","தத​: ஸா நாரீஸமாக³த்ய தம்ʼ ப்ரணம்ய ஜகா³த³, ஹே ப்ரபோ⁴ மாமுபகுரு| ");
INSERT INTO santam_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ஸ உக்தவாந், பா³லகாநாம்ʼ ப⁴க்ஷ்யமாதா³ய ஸாரமேயேப்⁴யோ தா³நம்ʼ நோசிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ததா³ ஸா ப³பா⁴ஷே, ஹே ப்ரபோ⁴, தத் ஸத்யம்ʼ, ததா²பி ப்ரபோ⁴ ர்ப⁴ஞ்சாத்³ யது³ச்சி²ஷ்டம்ʼ பததி, தத் ஸாரமேயா​: கா²த³ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ததோ யீஸு²​: ப்ரத்யவத³த், ஹே யோஷித், தவ விஸ்²வாஸோ மஹாந் தஸ்மாத் தவ மநோபி⁴லஷிதம்ʼ ஸித்³ய்யது, தேந தஸ்யா​: கந்யா தஸ்மிந்நேவ த³ண்டே³ நிராமயாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","அநந்தரம்ʼ யீஸ²ஸ்தஸ்மாத் ஸ்தா²நாத் ப்ரஸ்தா²ய கா³லீல்ஸாக³ரஸ்ய ஸந்நிதி⁴மாக³த்ய த⁴ராத⁴ரமாருஹ்ய தத்ரோபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","பஸ்²சாத் ஜநநிவஹோ ப³ஹூந் க²ஞ்சாந்த⁴மூகஸு²ஷ்ககரமாநுஷாந் ஆதா³ய யீஸோ²​: ஸமீபமாக³த்ய தச்சரணாந்திகே ஸ்தா²பயாமாஸு​:, தத​: ஸா தாந் நிராமயாந் அகரோத்| ");
INSERT INTO santam_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","இத்த²ம்ʼ மூகா வாக்யம்ʼ வத³ந்தி, ஸு²ஷ்ககரா​: ஸ்வாஸ்த்²யமாயாந்தி, பங்க³வோ க³ச்ச²ந்தி, அந்தா⁴ வீக்ஷந்தே, இதி விலோக்ய லோகா விஸ்மயம்ʼ மந்யமாநா இஸ்ராயேல ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ ப³பா⁴ஷிரே| ");
INSERT INTO santam_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ததா³நீம்ʼ யீஸு²​: ஸ்வஸி²ஷ்யாந் ஆஹூய க³தி³தவாந், ஏதஜ்ஜநநிவஹேஷு மம த³யா ஜாயதே, ஏதே தி³நத்ரயம்ʼ மயா ஸாகம்ʼ ஸந்தி, ஏஷாம்ʼ ப⁴க்ஷ்யவஸ்து ச கஞ்சித³பி நாஸ்தி, தஸ்மாத³ஹமேதாநக்ருʼதாஹாராந் ந விஸ்ரக்ஷ்யாமி, ததா²த்வே வர்த்மமத்⁴யே க்லாம்யேஷு​:| ");
INSERT INTO santam_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ததா³ ஸி²ஷ்யா ஊசு​:, ஏதஸ்மிந் ப்ராந்தரமத்⁴ய ஏதாவதோ மர்த்யாந் தர்பயிதும்ʼ வயம்ʼ குத்ர பூபாந் ப்ராப்ஸ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","யீஸு²ரப்ருʼச்ச²த், யுஷ்மாகம்ʼ நிகடே கதி பூபா ஆஸதே? த ஊசு​:, ஸப்தபூபா அல்பா​: க்ஷுத்³ரமீநாஸ்²ச ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ததா³நீம்ʼ ஸ லோகநிவஹம்ʼ பூ⁴மாவுபவேஷ்டும் ஆதி³ஸ்²ய ");
INSERT INTO santam_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","தாந் ஸப்தபூபாந் மீநாம்ʼஸ்²ச க்³ருʼஹ்லந் ஈஸ்²வரீயகு³ணாந் அநூத்³ய ப⁴ம்ʼக்த்வா ஸி²ஷ்யேப்⁴யோ த³தௌ³, ஸி²ஷ்யா லோகேப்⁴யோ த³து³​:| ");
INSERT INTO santam_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","தத​: ஸர்வ்வே பு⁴க்த்வா த்ருʼப்தவந்த​:; தத³வஸி²ஷ்டப⁴க்ஷ்யேண ஸப்தட³லகாந் பரிபூர்ய்ய ஸம்ʼஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","தே போ⁴க்தாரோ யோஷிதோ பா³லகாம்ʼஸ்²ச விஹாய ப்ராயேண சது​:ஸஹஸ்ராணி புருஷா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","தத​: பரம்ʼ ஸ ஜநநிவஹம்ʼ விஸ்ருʼஜ்ய தரிமாருஹ்ய மக்³த³லாப்ரதே³ஸ²ம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ததா³நீம்ʼ பி²ரூஸி²ந​: ஸிதூ³கிநஸ்²சாக³த்ய தம்ʼ பரீக்ஷிதும்ʼ நப⁴மீயம்ʼ கிஞ்சந லக்ஷ்ம த³ர்ஸ²யிதும்ʼ தஸ்மை நிவேத³யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","தத​: ஸ உக்தவாந், ஸந்த்⁴யாயாம்ʼ நப⁴ஸோ ரக்தத்வாத்³ யூயம்ʼ வத³த², ஸ்²வோ நிர்ம்மலம்ʼ தி³நம்ʼ ப⁴விஷ்யதி; ");
INSERT INTO santam_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ப்ராத​:காலே ச நப⁴ஸோ ரக்தத்வாத் மலிநத்வாஞ்ச வத³த², ஜ²ஞ்ப்⁴ஸ²த்³ய ப⁴விஷ்யதி| ஹே கபடிநோ யதி³ யூயம் அந்தரீக்ஷஸ்ய லக்ஷ்ம போ³த்³து⁴ம்ʼ ஸ²க்நுத², தர்ஹி காலஸ்யைதஸ்ய லக்ஷ்ம கத²ம்ʼ போ³த்³து⁴ம்ʼ ந ஸ²க்நுத²? ");
INSERT INTO santam_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ஏதத்காலஸ்ய து³ஷ்டோ வ்யபி⁴சாரீ ச வம்ʼஸோ² லக்ஷ்ம க³வேஷயதி, கிந்து யூநஸோ ப⁴விஷ்யத்³வாதி³நோ லக்ஷ்ம விநாந்யத் கிமபி லக்ஷ்ம தாந் ந த³ர்ஸ²யிய்யதே| ததா³நீம்ʼ ஸ தாந் விஹாய ப்ரதஸ்தே²| ");
INSERT INTO santam_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","அநந்தரமந்யபாரக³மநகாலே தஸ்ய ஸி²ஷ்யா​: பூபமாநேதும்ʼ விஸ்ம்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","யீஸு²ஸ்தாநவாதீ³த், யூயம்ʼ பி²ரூஸி²நாம்ʼ ஸிதூ³கிநாஞ்ச கிண்வம்ʼ ப்ரதி ஸாவதா⁴நா​: ஸதர்காஸ்²ச ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","தேந தே பரஸ்பரம்ʼ விவிச்ய கத²யிதுமாரேபி⁴ரே, வயம்ʼ பூபாநாநேதும்ʼ விஸ்ம்ருʼதவந்த ஏதத்காரணாத்³ இதி கத²யதி| ");
INSERT INTO santam_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","கிந்து யீஸு²ஸ்தத்³விஜ்ஞாய தாநவோசத், ஹே ஸ்தோகவிஸ்²வாஸிநோ யூயம்ʼ பூபாநாநயநமதி⁴ குத​: பரஸ்பரமேதத்³ விவிம்ʼக்ய? ");
INSERT INTO santam_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","யுஷ்மாபி⁴​: கிமத்³யாபி ந ஜ்ஞாயதே? பஞ்சபி⁴​: பூபை​: பஞ்சஸஹஸ்ரபுருஷேஷு போ⁴ஜிதேஷு ப⁴க்ஷ்யோச்சி²ஷ்டபூர்ணாந் கதி ட³லகாந் ஸமக்³ருʼஹ்லீதம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ததா² ஸப்தபி⁴​: பூபைஸ்²சது​:ஸஹஸ்ரபுருஷேஷு பே⁴ஜிதேஷு கதி ட³லகாந் ஸமக்³ருʼஹ்லீத, தத் கிம்ʼ யுஷ்மாபி⁴ர்ந ஸ்மர்ய்யதே? ");
INSERT INTO santam_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","தஸ்மாத் பி²ரூஸி²நாம்ʼ ஸிதூ³கிநாஞ்ச கிண்வம்ʼ ப்ரதி ஸாவதா⁴நாஸ்திஷ்ட²த, கதா²மிமாம் அஹம்ʼ பூபாநதி⁴ நாகத²யம்ʼ, ஏதத்³ யூயம்ʼ குதோ ந பு³த்⁴யத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ததா³நீம்ʼ பூபகிண்வம்ʼ ப்ரதி ஸாவதா⁴நாஸ்திஷ்ட²தேதி நோக்த்வா பி²ரூஸி²நாம்ʼ ஸிதூ³கிநாஞ்ச உபதே³ஸ²ம்ʼ ப்ரதி ஸாவதா⁴நாஸ்திஷ்ட²தேதி கதி²தவாந், இதி தைரபோ³தி⁴| ");
INSERT INTO santam_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","அபரஞ்ச யீஸு²​: கைஸரியா-பி²லிபிப்ரதே³ஸ²மாக³த்ய ஸி²ஷ்யாந் அப்ருʼச்ச²த், யோ(அ)ஹம்ʼ மநுஜஸுத​: ஸோ(அ)ஹம்ʼ க​:? லோகைரஹம்ʼ கிமுச்யே? ");
INSERT INTO santam_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ததா³நீம்ʼ தே கதி²தவந்த​:, கேசித்³ வத³ந்தி த்வம்ʼ மஜ்ஜயிதா யோஹந், கேசித்³வத³ந்தி, த்வம் ஏலிய​:, கேசிச்ச வத³ந்தி, த்வம்ʼ யிரிமியோ வா கஸ்²சித்³ ப⁴விஷ்யத்³வாதீ³தி| ");
INSERT INTO santam_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","பஸ்²சாத் ஸ தாந் பப்ரச்ச², யூயம்ʼ மாம்ʼ கம்ʼ வத³த²? தத​: ஸி²மோந் பிதர உவாச, ");
INSERT INTO santam_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","த்வமமரேஸ்²வரஸ்யாபி⁴ஷிக்தபுத்ர​:| ");
INSERT INTO santam_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ததோ யீஸு²​: கதி²தவாந், ஹே யூநஸ​: புத்ர ஸி²மோந் த்வம்ʼ த⁴ந்ய​:; யத​: கோபி அநுஜஸ்த்வய்யேதஜ்ஜ்ஞாநம்ʼ நோத³பாத³யத், கிந்து மம ஸ்வர்க³ஸ்ய​: பிதோத³பாத³யத்| ");
INSERT INTO santam_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","அதோ(அ)ஹம்ʼ த்வாம்ʼ வதா³மி, த்வம்ʼ பிதர​: (ப்ரஸ்தர​:) அஹஞ்ச தஸ்ய ப்ரஸ்தரஸ்யோபரி ஸ்வமண்ட³லீம்ʼ நிர்ம்மாஸ்யாமி, தேந நிரயோ ப³லாத் தாம்ʼ பராஜேதும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","அஹம்ʼ துப்⁴யம்ʼ ஸ்வர்கீ³யராஜ்யஸ்ய குஞ்ஜிகாம்ʼ தா³ஸ்யாமி, தேந யத் கிஞ்சந த்வம்ʼ ப்ருʼதி²வ்யாம்ʼ ப⁴ம்ʼத்ஸ்யஸி தத்ஸ்வர்கே³ ப⁴ம்ʼத்ஸ்யதே, யச்ச கிஞ்சந மஹ்யாம்ʼ மோக்ஷ்யஸி தத் ஸ்வர்கே³ மோக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","பஸ்²சாத் ஸ ஸி²ஷ்யாநாதி³ஸ²த், அஹமபி⁴ஷிக்தோ யீஸு²ரிதி கதா²ம்ʼ கஸ்மைசித³பி யூயம்ʼ மா கத²யத| ");
INSERT INTO santam_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","அந்யஞ்ச யிரூஸா²லம்நக³ரம்ʼ க³த்வா ப்ராசீநலோகேப்⁴ய​: ப்ரதா⁴நயாஜகேப்⁴ய உபாத்⁴யாயேப்⁴யஸ்²ச ப³ஹுது³​:க²போ⁴க³ஸ்தை ர்ஹதத்வம்ʼ த்ருʼதீயதி³நே புநருத்தா²நஞ்ச மமாவஸ்²யகம் ஏதா​: கதா² யீஸு²ஸ்தத்காலமாரப்⁴ய ஸி²ஷ்யாந் ஜ்ஞாபயிதும் ஆரப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ததா³நீம்ʼ பிதரஸ்தஸ்ய கரம்ʼ க்⁴ருʼத்வா தர்ஜயித்வா கத²யிதுமாரப்³த⁴வாந், ஹே ப்ரபோ⁴, தத் த்வத்தோ தூ³ரம்ʼ யாது, த்வாம்ʼ ப்ரதி கதா³பி ந க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","கிந்து ஸ வத³நம்ʼ பராவர்த்ய பிதரம்ʼ ஜகா³த³, ஹே விக்⁴நகாரிந், மத்ஸம்முகா²த்³ தூ³ரீப⁴வ, த்வம்ʼ மாம்ʼ பா³த⁴ஸே, ஈஸ்²வரீயகார்ய்யாத் மாநுஷீயகார்ய்யம்ʼ துப்⁴யம்ʼ ரோசதே| ");
INSERT INTO santam_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","அநந்தரம்ʼ யீஸு²​: ஸ்வீயஸி²ஷ்யாந் உக்தவாந் ய​: கஸ்²சித் மம பஸ்²சாத்³கா³மீ ப⁴விதும் இச்ச²தி, ஸ ஸ்வம்ʼ தா³ம்யது, ததா² ஸ்வக்ருஸ²ம்ʼ க்³ருʼஹ்லந் மத்பஸ்²சாதா³யாது| ");
INSERT INTO santam_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","யதோ ய​: ப்ராணாந் ரக்ஷிதுமிச்ச²தி, ஸ தாந் ஹாரயிஷ்யதி, கிந்து யோ மத³ர்த²ம்ʼ நிஜப்ராணாந் ஹாரயதி, ஸ தாந் ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","மாநுஷோ யதி³ ஸர்வ்வம்ʼ ஜக³த் லப⁴தே நிஜப்ரணாந் ஹாரயதி, தர்ஹி தஸ்ய கோ லாப⁴​:? மநுஜோ நிஜப்ராணாநாம்ʼ விநிமயேந வா கிம்ʼ தா³தும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","மநுஜஸுத​: ஸ்வதூ³தை​: ஸாகம்ʼ பிது​: ப்ரபா⁴வேணாக³மிஷ்யதி; ததா³ ப்ரதிமநுஜம்ʼ ஸ்வஸ்வகர்ம்மாநுஸாராத் ப²லம்ʼ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வச்மி, ஸராஜ்யம்ʼ மநுஜஸுதம் ஆக³தம்ʼ ந பஸ்²யந்தோ ம்ருʼத்யும்ʼ ந ஸ்வாதி³ஷ்யந்தி, ஏதாத்³ருʼஸா²​: கதிபயஜநா அத்ராபி த³ண்டா³யமாநா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","அநந்தரம்ʼ ஷட்³தி³நேப்⁴ய​: பரம்ʼ யீஸு²​: பிதரம்ʼ யாகூப³ம்ʼ தத்ஸஹஜம்ʼ யோஹநஞ்ச க்³ருʼஹ்லந் உச்சாத்³ரே ர்விவிக்தஸ்தா²நம் ஆக³த்ய தேஷாம்ʼ ஸமக்ஷம்ʼ ரூபமந்யத் த³தா⁴ர| ");
INSERT INTO santam_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","தேந ததா³ஸ்யம்ʼ தேஜஸ்வி, ததா³ப⁴ரணம் ஆலோகவத் பாண்ட³ரமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","அந்யச்ச தேந ஸாகம்ʼ ஸம்ʼலபந்தௌ மூஸா ஏலியஸ்²ச தேப்⁴யோ த³ர்ஸ²நம்ʼ த³த³து​:| ");
INSERT INTO santam_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ததா³நீம்ʼ பிதரோ யீஸு²ம்ʼ ஜகா³த³, ஹே ப்ரபோ⁴ ஸ்தி²திரத்ராஸ்மாகம்ʼ ஸு²பா⁴, யதி³ ப⁴வதாநுமந்யதே, தர்ஹி ப⁴வத³ர்த²மேகம்ʼ மூஸார்த²மேகம் ஏலியார்த²ஞ்சைகம் இதி த்ரீணி தூ³ஷ்யாணி நிர்ம்மம| ");
INSERT INTO santam_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ஏதத்கத²நகால ஏக உஜ்ஜவல​: பயோத³ஸ்தேஷாமுபரி சா²யாம்ʼ க்ருʼதவாந், வாரிதா³த்³ ஏஷா நப⁴ஸீயா வாக்³ ப³பூ⁴வ, மமாயம்ʼ ப்ரிய​: புத்ர​:, அஸ்மிந் மம மஹாஸந்தோஷ ஏதஸ்ய வாக்யம்ʼ யூயம்ʼ நிஸா²மயத| ");
INSERT INTO santam_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","கிந்து வாசமேதாம்ʼ ஸ்²ருʼண்வந்தஏவ ஸி²ஷ்யா ம்ருʼஸ²ம்ʼ ஸ²ங்கமாநா ந்யுப்³ஜா ந்யபதந்| ");
INSERT INTO santam_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ததா³ யீஸு²ராக³த்ய தேஷாம்ʼ கா³த்ராணி ஸ்ப்ருʼஸ²ந் உவாச, உத்திஷ்ட²த, மா பை⁴ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ததா³நீம்ʼ நேத்ராண்யுந்மீல்ய யீஸு²ம்ʼ விநா கமபி ந த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","தத​: பரம் அத்³ரேரவரோஹணகாலே யீஸு²ஸ்தாந் இத்யாதி³தே³ஸ², மநுஜஸுதஸ்ய ம்ருʼதாநாம்ʼ மத்⁴யாது³த்தா²நம்ʼ யாவந்ந ஜாயதே, தாவத் யுஷ்மாபி⁴ரேதத்³த³ர்ஸ²நம்ʼ கஸ்மைசித³பி ந கத²யிதவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ததா³ ஸி²ஷ்யாஸ்தம்ʼ பப்ரச்சு²​:, ப்ரத²மம் ஏலிய ஆயாஸ்யதீதி குத உபாத்⁴யாயைருச்யதே? ");
INSERT INTO santam_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ததோ யீஸு²​: ப்ரத்யவாதீ³த், ஏலிய​: ப்ராகே³த்ய ஸர்வ்வாணி ஸாத⁴யிஷ்யதீதி ஸத்யம்ʼ, ");
INSERT INTO santam_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","கிந்த்வஹம்ʼ யுஷ்மாந் வச்மி, ஏலிய ஏத்ய க³த​:, தே தமபரிசித்ய தஸ்மிந் யதே²ச்ச²ம்ʼ வ்யவஜஹு​:; மநுஜஸுதேநாபி தேஷாமந்திகே தாத்³ருʼக்³ து³​:க²ம்ʼ போ⁴க்தவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ததா³நீம்ʼ ஸ மஜ்ஜயிதாரம்ʼ யோஹநமதி⁴ கதா²மேதாம்ʼ வ்யாஹ்ருʼதவாந், இத்த²ம்ʼ தச்சி²ஷ்யா பு³பு³தி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","பஸ்²சாத் தேஷு ஜநநிவஹஸ்யாந்திகமாக³தேஷு கஸ்²சித் மநுஜஸ்தத³ந்திகமேத்ய ஜாநூநீ பாதயித்வா கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ஹே ப்ரபோ⁴, மத்புத்ரம்ʼ ப்ரதி க்ருʼபாம்ʼ வித³தா⁴து, ஸோபஸ்மாராமயேந ப்⁴ருʼஸ²ம்ʼ வ்யதி²த​: ஸந் புந​: புந ர்வஹ்நௌ முஹு ர்ஜலமத்⁴யே பததி| ");
INSERT INTO santam_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","தஸ்மாத்³ ப⁴வத​: ஸி²ஷ்யாணாம்ʼ ஸமீபே தமாநயம்ʼ கிந்து தே தம்ʼ ஸ்வாஸ்த²ம்ʼ கர்த்தும்ʼ ந ஸ²க்தா​:| ");
INSERT INTO santam_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ததா³ யீஸு²​: கதி²தவாந் ரே அவிஸ்²வாஸிந​:, ரே விபத²கா³மிந​:, புந​: கதிகாலாந் அஹம்ʼ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ஸ்தா²ஸ்யாமி? கதிகாலாந் வா யுஷ்மாந் ஸஹிஷ்யே? தமத்ர மமாந்திகமாநயத| ");
INSERT INTO santam_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","பஸ்²சாத்³ யீஸு²நா தர்ஜதஏவ ஸ பூ⁴தஸ்தம்ʼ விஹாய க³தவாந், தத்³த³ண்ட³ஏவ ஸ பா³லகோ நிராமயோ(அ)பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","தத​: ஸி²ஷ்யா கு³ப்தம்ʼ யீஸு²முபாக³த்ய ப³பா⁴ஷிரே, குதோ வயம்ʼ தம்ʼ பூ⁴தம்ʼ த்யாஜயிதும்ʼ ந ஸ²க்தா​:? ");
INSERT INTO santam_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","யீஸு²நா தே ப்ரோக்தா​:, யுஷ்மாகமப்ரத்யயாத்; ");
INSERT INTO santam_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","யுஷ்மாநஹம்ʼ தத்²யம்ʼ வச்மி யதி³ யுஷ்மாகம்ʼ ஸர்ஷபைகமாத்ரோபி விஸ்²வாஸோ ஜாயதே, தர்ஹி யுஷ்மாபி⁴ரஸ்மிந் ஸை²லே த்வமித​: ஸ்தா²நாத் தத் ஸ்தா²நம்ʼ யாஹீதி ப்³ரூதே ஸ ததை³வ சலிஷ்யதி, யுஷ்மாகம்ʼ கிமப்யஸாத்⁴யஞ்ச கர்ம்ம ந ஸ்தா²ஸ்யாதி| கிந்து ப்ரார்த²நோபவாஸௌ விநைதாத்³ருʼஸோ² பூ⁴தோ ந த்யாஜ்யேத| ");
INSERT INTO santam_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","அபரம்ʼ தேஷாம்ʼ கா³லீல்ப்ரதே³ஸே² ப்⁴ரமணகாலே யீஸு²நா தே க³தி³தா​:, மநுஜஸுதோ ஜநாநாம்ʼ கரேஷு ஸமர்பயிஷ்யதே தை ர்ஹநிஷ்யதே ச, ");
INSERT INTO santam_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","கிந்து த்ருʼதீயே(அ)ஹி्ந ம உத்தா²பிஷ்யதே, தேந தே ப்⁴ருʼஸ²ம்ʼ து³​:கி²தா ப³பூ⁴வ​:| ");
INSERT INTO santam_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","தத³நந்தரம்ʼ தேஷு கப²ர்நாஹூம்நக³ரமாக³தேஷு கரஸம்ʼக்³ராஹிண​: பிதராந்திகமாக³த்ய பப்ரச்சு²​:, யுஷ்மாகம்ʼ கு³ரு​: கிம்ʼ மந்தி³ரார்த²ம்ʼ கரம்ʼ ந த³தா³தி? தத​: பிதர​: கதி²தவாந் த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ததஸ்தஸ்மிந் க்³ருʼஹமத்⁴யமாக³தே தஸ்ய கதா²கத²நாத் பூர்வ்வமேவ யீஸு²ருவாச, ஹே ஸி²மோந், மேதி³ந்யா ராஜாந​: ஸ்வஸ்வாபத்யேப்⁴ய​: கிம்ʼ விதே³ஸி²ப்⁴ய​: கேப்⁴ய​: கரம்ʼ க்³ருʼஹ்லந்தி? அத்ர த்வம்ʼ கிம்ʼ பு³த்⁴யஸே? தத​: பிதர உக்தவாந், விதே³ஸி²ப்⁴ய​:| ");
INSERT INTO santam_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ததா³ யீஸு²ருக்தவாந், தர்ஹி ஸந்தாநா முக்தா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ததா²பி யதா²ஸ்மாபி⁴ஸ்தேஷாமந்தராயோ ந ஜந்யதே, தத்க்ருʼதே ஜலதே⁴ஸ்தீரம்ʼ க³த்வா வடி³ஸ²ம்ʼ க்ஷிப, தேநாதௌ³ யோ மீந உத்தா²ஸ்யதி, தம்ʼ க்⁴ருʼத்வா தந்முகே² மோசிதே தோலகைகம்ʼ ரூப்யம்ʼ ப்ராப்ஸ்யஸி, தத்³ க்³ருʼஹீத்வா தவ மம ச க்ருʼதே தேப்⁴யோ தே³ஹி| ");
INSERT INTO santam_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ததா³நீம்ʼ ஸி²ஷ்யா யீஸோ²​: ஸமீபமாக³த்ய ப்ருʼஷ்டவந்த​: ஸ்வர்க³ராஜ்யே க​: ஸ்²ரேஷ்ட²​:? ");
INSERT INTO santam_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ததோ யீஸு²​: க்ஷுத்³ரமேகம்ʼ பா³லகம்ʼ ஸ்வஸமீபமாநீய தேஷாம்ʼ மத்⁴யே நிதா⁴ய ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","யுஷ்மாநஹம்ʼ ஸத்யம்ʼ ப்³ரவீமி, யூயம்ʼ மநோவிநிமயேந க்ஷுத்³ரபா³லவத் ந ஸந்த​: ஸ்வர்க³ராஜ்யம்ʼ ப்ரவேஷ்டும்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ய​: கஸ்²சித்³ ஏதஸ்ய க்ஷுத்³ரபா³லகஸ்ய ஸமமாத்மாநம்ʼ நம்ரீகரோதி, ஸஏவ ஸ்வர்க³ராஜயே ஸ்²ரேஷ்ட²​:| ");
INSERT INTO santam_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ய​: கஸ்²சித்³ ஏதாத்³ருʼஸ²ம்ʼ க்ஷுத்³ரபா³லகமேகம்ʼ மம நாம்நி க்³ருʼஹ்லாதி, ஸ மாமேவ க்³ருʼஹ்லாதி| ");
INSERT INTO santam_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","கிந்து யோ ஜநோ மயி க்ருʼதவிஸ்²வாஸாநாமேதேஷாம்ʼ க்ஷுத்³ரப்ராணிநாம் ஏகஸ்யாபி வித்⁴நிம்ʼ ஜநயதி, கண்ட²ப³த்³த⁴பேஷணீகஸ்ய தஸ்ய ஸாக³ராகா³த⁴ஜலே மஜ்ஜநம்ʼ ஸ்²ரேய​:| ");
INSERT INTO santam_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","விக்⁴நாத் ஜக³த​: ஸந்தாபோ ப⁴விஷ்யதி, விக்⁴நோ(அ)வஸ்²யம்ʼ ஜநயிஷ்யதே, கிந்து யேந மநுஜேந விக்⁴நோ ஜநிஷ்யதே தஸ்யைவ ஸந்தாபோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","தஸ்மாத் தவ கரஸ்²சரணோ வா யதி³ த்வாம்ʼ பா³த⁴தே, தர்ஹி தம்ʼ சி²த்த்வா நிக்ஷிப, த்³விகரஸ்ய த்³விபத³ஸ்ய வா தவாநப்தவஹ்நௌ நிக்ஷேபாத், க²ஞ்ஜஸ்ய வா சி²ந்நஹஸ்தஸ்ய தவ ஜீவநே ப்ரவேஸோ² வரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","அபரம்ʼ தவ நேத்ரம்ʼ யதி³ த்வாம்ʼ பா³த⁴தே, தர்ஹி தத³ப்யுத்பாவ்ய நிக்ஷிப, த்³விநேத்ரஸ்ய நரகாக்³நௌ நிக்ஷேபாத் காணஸ்ய தவ ஜீவநே ப்ரவேஸோ² வரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","தஸ்மாத³வத⁴த்³த⁴ம்ʼ, ஏதேஷாம்ʼ க்ஷுத்³ரப்ராணிநாம் ஏகமபி மா துச்சீ²குருத, ");
INSERT INTO santam_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","யதோ யுஷ்மாநஹம்ʼ தத்²யம்ʼ ப்³ரவீமி, ஸ்வர்கே³ தேஷாம்ʼ தூ³தா மம ஸ்வர்க³ஸ்த²ஸ்ய பிதுராஸ்யம்ʼ நித்யம்ʼ பஸ்²யந்தி| ஏவம்ʼ யே யே ஹாரிதாஸ்தாந் ரக்ஷிதும்ʼ மநுஜபுத்ர ஆக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","யூயமத்ர கிம்ʼ விவிம்ʼக்³க்⁴வே? கஸ்யசித்³ யதி³ ஸ²தம்ʼ மேஷா​: ஸந்தி, தேஷாமேகோ ஹார்ய்யதே ச, தர்ஹி ஸ ஏகோநஸ²தம்ʼ மேஷாந் விஹாய பர்வ்வதம்ʼ க³த்வா தம்ʼ ஹாரிதமேகம்ʼ கிம்ʼ ந ம்ருʼக³யதே? ");
INSERT INTO santam_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","யதி³ ச கதா³சித் தந்மேஷோத்³தே³ஸ²ம்ʼ லமதே, தர்ஹி யுஷ்மாநஹம்ʼ ஸத்யம்ʼ கத²யாமி, ஸோ(அ)விபத²கா³மிப்⁴ய ஏகோநஸ²தமேஷேப்⁴யோபி ததே³கஹேதோரதி⁴கம் ஆஹ்லாத³தே| ");
INSERT INTO santam_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","தத்³வத்³ ஏதேஷாம்ʼ க்ஷுத்³ரப்ராஏिநாம் ஏகோபி நஸ்²யதீதி யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²பிது ர்நாபி⁴மதம்| ");
INSERT INTO santam_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","யத்³யபி தவ ப்⁴ராதா த்வயி கிமப்யபராத்⁴யதி, தர்ஹி க³த்வா யுவயோர்த்³வயோ​: ஸ்தி²தயோஸ்தஸ்யாபராத⁴ம்ʼ தம்ʼ ஜ்ஞாபய| தத்ர ஸ யதி³ தவ வாக்யம்ʼ ஸ்²ருʼணோதி, தர்ஹி த்வம்ʼ ஸ்வப்⁴ராதரம்ʼ ப்ராப்தவாந், ");
INSERT INTO santam_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","கிந்து யதி³ ந ஸ்²ருʼணோதி, தர்ஹி த்³வாப்⁴யாம்ʼ த்ரிபி⁴ ர்வா ஸாக்ஷீபி⁴​: ஸர்வ்வம்ʼ வாக்யம்ʼ யதா² நிஸ்²சிதம்ʼ ஜாயதே, தத³ர்த²ம் ஏகம்ʼ த்³வௌ வா ஸாக்ஷிணௌ க்³ருʼஹீத்வா யாஹி| ");
INSERT INTO santam_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","தேந ஸ யதி³ தயோ ர்வாக்யம்ʼ ந மாந்யதே, தர்ஹி ஸமாஜம்ʼ தஜ்ஜ்ஞாபய, கிந்து யதி³ ஸமாஜஸ்யாபி வாக்யம்ʼ ந மாந்யதே,தர்ஹி ஸ தவ ஸமீபே தே³வபூஜகஇவ சண்டா³லஇவ ச ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","அஹம்ʼ யுஷ்மாந் ஸத்யம்ʼ வதா³மி, யுஷ்மாபி⁴​: ப்ருʼதி²வ்யாம்ʼ யத்³ ப³த்⁴யதே தத் ஸ்வர்கே³ ப⁴ம்ʼத்ஸ்யதே; மேதி³ந்யாம்ʼ யத் போ⁴ச்யதே, ஸ்வர்கே³(அ)பி தத் மோக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","புநரஹம்ʼ யுஷ்மாந் வதா³மி, மேதி³ந்யாம்ʼ யுஷ்மாகம்ʼ யதி³ த்³வாவேகவாக்யீபூ⁴ய கிஞ்சித் ப்ரார்த²யேதே, தர்ஹி மம ஸ்வர்க³ஸ்த²பித்ரா தத் தயோ​: க்ருʼதே ஸம்பந்நம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","யதோ யத்ர த்³வௌ த்ரயோ வா மம நாந்நி மிலந்தி, தத்ரைவாஹம்ʼ தேஷாம்ʼ மத்⁴யே(அ)ஸ்மி| ");
INSERT INTO santam_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ததா³நீம்ʼ பிதரஸ்தத்ஸமீபமாக³த்ய கதி²தவாந் ஹே ப்ரபோ⁴, மம ப்⁴ராதா மம யத்³யபராத்⁴யதி, தர்ஹி தம்ʼ கதிக்ருʼத்வ​: க்ஷமிஷ்யே? ");
INSERT INTO santam_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","கிம்ʼ ஸப்தக்ருʼத்வ​:? யீஸு²ஸ்தம்ʼ ஜகா³த³, த்வாம்ʼ கேவலம்ʼ ஸப்தக்ருʼத்வோ யாவத் ந வதா³மி, கிந்து ஸப்தத்யா கு³ணிதம்ʼ ஸப்தக்ருʼத்வோ யாவத்| ");
INSERT INTO santam_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","அபரம்ʼ நிஜதா³ஸை​: ஸஹ ஜிக³ணயிஷு​: கஸ்²சித்³ ராஜேவ ஸ்வர்க³ராஜயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ஆரப்³தே⁴ தஸ்மிந் க³ணநே ஸார்த்³த⁴ஸஹஸ்ரமுத்³ராபூரிதாநாம்ʼ த³ஸ²ஸஹஸ்ரபுடகாநாம் ஏகோ(அ)க⁴மர்ணஸ்தத்ஸமக்ஷமாநாயி| ");
INSERT INTO santam_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","தஸ்ய பரிஸோ²த⁴நாய த்³ரவ்யாபா⁴வாத் பரிஸோ²த⁴நார்த²ம்ʼ ஸ ததீ³யபா⁴ர்ய்யாபுத்ராதி³ஸர்வ்வஸ்வஞ்ச விக்ரீயதாமிதி தத்ப்ரபு⁴ராதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","தேந ஸ தா³ஸஸ்தஸ்ய பாத³யோ​: பதந் ப்ரணம்ய கதி²தவாந் , ஹே ப்ரபோ⁴ ப⁴வதா கை⁴ர்ய்யே க்ருʼதே மயா ஸர்வ்வம்ʼ பரிஸோ²தி⁴ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ததா³நீம்ʼ தா³ஸஸ்ய ப்ரபு⁴​: ஸகருண​: ஸந் ஸகலர்ணம்ʼ க்ஷமித்வா தம்ʼ தத்யாஜ| ");
INSERT INTO santam_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","கிந்து தஸ்மிந் தா³ஸே ப³ஹி ர்யாதே, தஸ்ய ஸ²தம்ʼ முத்³ராசதுர்தா²ம்ʼஸா²ந் யோ தா⁴ரயதி, தம்ʼ ஸஹதா³ஸம்ʼ த்³ருʼஷ்த்³வா தஸ்ய கண்ட²ம்ʼ நிஷ்பீட்³ய க³தி³தவாந், மம யத் ப்ராப்யம்ʼ தத் பரிஸோ²த⁴ய| ");
INSERT INTO santam_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ததா³ தஸ்ய ஸஹதா³ஸஸ்தத்பாத³யோ​: பதித்வா விநீய ப³பா⁴ஷே, த்வயா தை⁴ர்ய்யே க்ருʼதே மயா ஸர்வ்வம்ʼ பரிஸோ²தி⁴ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ததா²பி ஸ தத் நாஙகீ³க்ருʼத்ய யாவத் ஸர்வ்வம்ருʼணம்ʼ ந பரிஸோ²தி⁴தவாந் தாவத் தம்ʼ காராயாம்ʼ ஸ்தா²பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ததா³ தஸ்ய ஸஹதா³ஸாஸ்தஸ்யைதாத்³ருʼக்³ ஆசரணம்ʼ விலோக்ய ப்ரபோ⁴​: ஸமீபம்ʼ க³த்வா ஸர்வ்வம்ʼ வ்ருʼத்தாந்தம்ʼ நிவேத³யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ததா³ தஸ்ய ப்ரபு⁴ஸ்தமாஹூய ஜகா³த³, ரே து³ஷ்ட தா³ஸ, த்வயா மத்ஸந்நிதௌ⁴ ப்ரார்தி²தே மயா தவ ஸர்வ்வம்ருʼணம்ʼ த்யக்தம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","யதா² சாஹம்ʼ த்வயி கருணாம்ʼ க்ருʼதவாந், ததை²வ த்வத்ஸஹதா³ஸே கருணாகரணம்ʼ கிம்ʼ தவ நோசிதம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","இதி கத²யித்வா தஸ்ய ப்ரபு⁴​: க்ருத்³த்⁴யந் நிஜப்ராப்யம்ʼ யாவத் ஸ ந பரிஸோ²தி⁴தவாந், தாவத் ப்ரஹாரகாநாம்ʼ கரேஷு தம்ʼ ஸமர்பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","யதி³ யூயம்ʼ ஸ்வாந்த​:கரணை​: ஸ்வஸ்வஸஹஜாநாம் அபராதா⁴ந் ந க்ஷமத்⁴வே, தர்ஹி மம ஸ்வர்க³ஸ்ய​: பிதாபி யுஷ்மாந் ப்ரதீத்த²ம்ʼ கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","அநந்தரம் ஏதாஸு கதா²ஸு ஸமாப்தாஸு யீஸு² ர்கா³லீலப்ரதே³ஸா²த் ப்ரஸ்தா²ய யர்த³ந்தீரஸ்த²ம்ʼ யிஹூதா³ப்ரதே³ஸ²ம்ʼ ப்ராப்த​:| ");
INSERT INTO santam_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ததா³ தத்பஸ்²சாத் ஜநநிவஹே க³தே ஸ தத்ர தாந் நிராமயாந் அகரோத்| ");
INSERT INTO santam_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","தத³நந்தரம்ʼ பி²ரூஸி²நஸ்தத்ஸமீபமாக³த்ய பாரீக்ஷிதும்ʼ தம்ʼ பப்ரச்சு²​:, கஸ்மாத³பி காரணாத் நரேண ஸ்வஜாயா பரித்யாஜ்யா ந வா? ");
INSERT INTO santam_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ஸ ப்ரத்யுவாச, ப்ரத²மம் ஈஸ்²வரோ நரத்வேந நாரீத்வேந ச மநுஜாந் ஸஸர்ஜ, தஸ்மாத் கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","மாநுஷ​: ஸ்வபிதரௌ பரித்யஜ்ய ஸ்வபத்ந்யாம் ஆஸக்ஷ்யதே, தௌ த்³வௌ ஜநாவேகாங்கௌ³ ப⁴விஷ்யத​:, கிமேதத்³ யுஷ்மாபி⁴ ர்ந படி²தம்? ");
INSERT INTO santam_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","அதஸ்தௌ புந ர்ந த்³வௌ தயோரேகாங்க³த்வம்ʼ ஜாதம்ʼ, ஈஸ்²வரேண யச்ச ஸமயுஜ்யத, மநுஜோ ந தத்³ பி⁴ந்த்³யாத்| ");
INSERT INTO santam_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ததா³நீம்ʼ தே தம்ʼ ப்ரத்யவத³ந், ததா²த்வே த்யாஜ்யபத்ரம்ʼ த³த்த்வா ஸ்வாம்ʼ ஸ்வாம்ʼ ஜாயாம்ʼ த்யக்தும்ʼ வ்யவஸ்தா²ம்ʼ மூஸா​: கத²ம்ʼ லிலேக²? ");
INSERT INTO santam_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","தத​: ஸ கதி²தவாந், யுஷ்மாகம்ʼ மநஸாம்ʼ காடி²ந்யாத்³ யுஷ்மாந் ஸ்வாம்ʼ ஸ்வாம்ʼ ஜாயாம்ʼ த்யக்தும் அந்வமந்யத கிந்து ப்ரத²மாத்³ ஏஷோ விதி⁴ர்நாஸீத்| ");
INSERT INTO santam_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","அதோ யுஷ்மாநஹம்ʼ வதா³மி, வ்யபி⁴சாரம்ʼ விநா யோ நிஜஜாயாம்ʼ த்யஜேத் அந்யாஞ்ச விவஹேத், ஸ பரதா³ராந் க³ச்ச²தி; யஸ்²ச த்யக்தாம்ʼ நாரீம்ʼ விவஹதி ஸோபி பரதா³ரேஷு ரமதே| ");
INSERT INTO santam_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ததா³ தஸ்ய ஸி²ஷ்யாஸ்தம்ʼ ப³பா⁴ஷிரே, யதி³ ஸ்வஜாயயா ஸாகம்ʼ பும்ʼஸ ஏதாத்³ருʼக் ஸம்ப³ந்தோ⁴ ஜாயதே, தர்ஹி விவஹநமேவ ந ப⁴த்³ரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","தத​: ஸ உக்தவாந், யேப்⁴யஸ்தத்ஸாமர்த்²யம்ʼ ஆதா³யி, தாந் விநாந்ய​: கோபி மநுஜ ஏதந்மதம்ʼ க்³ரஹீதும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","கதிபயா ஜநநக்லீப³​: கதிபயா நரக்ருʼதக்லீப³​: ஸ்வர்க³ராஜ்யாய கதிபயா​: ஸ்வக்ருʼதக்லீபா³ஸ்²ச ஸந்தி, யே க்³ரஹீதும்ʼ ஸ²க்நுவந்தி தே க்³ருʼஹ்லந்து| ");
INSERT INTO santam_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","அபரம் யதா² ஸ ஸி²ஸூ²நாம்ʼ கா³த்ரேஷு ஹஸ்தம்ʼ த³த்வா ப்ரார்த²யதே, தத³ர்த²ம்ʼ தத்ஸமீம்ʼபம்ʼ ஸி²ஸ²வ ஆநீயந்த, தத ஆநயித்ருʼந் ஸி²ஷ்யாஸ்திரஸ்க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","கிந்து யீஸு²ருவாச, ஸி²ஸ²வோ மத³ந்திகம் ஆக³ச்ச²ந்து, தாந் மா வாரயத, ஏதாத்³ருʼஸா²ம்ʼ ஸி²ஸூ²நாமேவ ஸ்வர்க³ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","தத​: ஸ தேஷாம்ʼ கா³த்ரேஷு ஹஸ்தம்ʼ த³த்வா தஸ்மாத் ஸ்தா²நாத் ப்ரதஸ்தே²| ");
INSERT INTO santam_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","அபரம் ஏக ஆக³த்ய தம்ʼ பப்ரச்ச², ஹே பரமகு³ரோ, அநந்தாயு​: ப்ராப்தும்ʼ மயா கிம்ʼ கிம்ʼ ஸத்கர்ம்ம கர்த்தவ்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","தத​: ஸ உவாச, மாம்ʼ பரமம்ʼ குதோ வத³ஸி? விநேஸ்²சரம்ʼ ந கோபி பரம​:, கிந்து யத்³யநந்தாயு​: ப்ராப்தும்ʼ வாஞ்ச²ஸி, தர்ஹ்யாஜ்ஞா​: பாலய| ");
INSERT INTO santam_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ததா³ ஸ ப்ருʼஷ்டவாந், கா​: கா ஆஜ்ஞா​:? ததோ யீஸு²​: கதி²தவாந், நரம்ʼ மா ஹந்யா​:, பரதா³ராந் மா க³ச்சே²​:, மா சோரயே​:, ம்ருʼஷாஸாக்ஷ்யம்ʼ மா த³த்³யா​:, ");
INSERT INTO santam_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","நிஜபிதரௌ ஸம்ʼமந்யஸ்வ, ஸ்வஸமீபவாஸிநி ஸ்வவத் ப்ரேம குரு| ");
INSERT INTO santam_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ஸ யுவா கதி²தவாந், ஆ பா³ல்யாத்³ ஏதா​: பாலயாமி, இதா³நீம்ʼ கிம்ʼ ந்யூநமாஸ்தே? ");
INSERT INTO santam_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ததோ யீஸு²ரவத³த், யதி³ ஸித்³தோ⁴ ப⁴விதும்ʼ வாஞ்ச²ஸி, தர்ஹி க³த்வா நிஜஸர்வ்வஸ்வம்ʼ விக்ரீய த³ரித்³ரேப்⁴யோ விதர, தத​: ஸ்வர்கே³ வித்தம்ʼ லப்ஸ்யஸே; ஆக³ச்ச², மத்பஸ்²சாத்³வர்த்தீ ச ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ஏதாம்ʼ வாசம்ʼ ஸ்²ருத்வா ஸ யுவா ஸ்வீயப³ஹுஸம்பத்தே ர்விஷண​: ஸந் சலிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ததா³ யீஸு²​: ஸ்வஸி²ஷ்யாந் அவத³த், த⁴நிநாம்ʼ ஸ்வர்க³ராஜ்யப்ரவேஸோ² மஹாது³ஷ்கர இதி யுஷ்மாநஹம்ʼ தத்²யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","புநரபி யுஷ்மாநஹம்ʼ வதா³மி, த⁴நிநாம்ʼ ஸ்வர்க³ராஜ்யப்ரவேஸா²த் ஸூசீசி²த்³ரேண மஹாங்க³க³மநம்ʼ ஸுகரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","இதி வாக்யம்ʼ நிஸ²ம்ய ஸி²ஷ்யா அதிசமத்க்ருʼத்ய கத²யாமாஸு​:; தர்ஹி கஸ்ய பரித்ராணம்ʼ ப⁴விதும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ததா³ ஸ தாந் த்³ருʼஷ்த்³வா கத²யாமாஸ, தத் மாநுஷாணாமஸ²க்யம்ʼ ப⁴வதி, கிந்த்வீஸ்²வரஸ்ய ஸர்வ்வம்ʼ ஸ²க்யம்| ");
INSERT INTO santam_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ததா³ பிதரஸ்தம்ʼ க³தி³தவாந், பஸ்²ய, வயம்ʼ ஸர்வ்வம்ʼ பரித்யஜ்ய ப⁴வத​: பஸ்²சாத்³வர்த்திநோ (அ)ப⁴வாம; வயம்ʼ கிம்ʼ ப்ராப்ஸ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ததோ யீஸு²​: கதி²தவாந், யுஷ்மாநஹம்ʼ தத்²யம்ʼ வதா³மி, யூயம்ʼ மம பஸ்²சாத்³வர்த்திநோ ஜாதா இதி காரணாத் நவீநஸ்ருʼஷ்டிகாலே யதா³ மநுஜஸுத​: ஸ்வீயைஸ்²சர்ய்யஸிம்ʼஹாஸந உபவேக்ஷ்யதி, ததா³ யூயமபி த்³வாத³ஸ²ஸிம்ʼஹாஸநேஷூபவிஸ்²ய இஸ்ராயேலீயத்³வாத³ஸ²வம்ʼஸா²நாம்ʼ விசாரம்ʼ கரிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","அந்யச்ச ய​: கஸ்²சித் மம நாமகாரணாத் க்³ருʼஹம்ʼ வா ப்⁴ராதரம்ʼ வா ப⁴கி³நீம்ʼ வா பிதரம்ʼ வா மாதரம்ʼ வா ஜாயாம்ʼ வா பா³லகம்ʼ வா பூ⁴மிம்ʼ பரித்யஜதி, ஸ தேஷாம்ʼ ஸ²தகு³ணம்ʼ லப்ஸ்யதே, அநந்தாயுமோ(அ)தி⁴காரித்வஞ்ச ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","கிந்து அக்³ரீயா அநேகே ஜநா​: பஸ்²சாத், பஸ்²சாதீயாஸ்²சாநேகே லோகா அக்³ரே ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ஸ்வர்க³ராஜ்யம் ஏதாத்³ருʼஸா² கேநசித்³ க்³ருʼஹஸ்யேந ஸமம்ʼ, யோ(அ)திப்ரபா⁴தே நிஜத்³ராக்ஷாக்ஷேத்ரே க்ருʼஷகாந் நியோக்தும்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","பஸ்²சாத் தை​: ஸாகம்ʼ தி³நைகப்⁴ருʼதிம்ʼ முத்³ராசதுர்தா²ம்ʼஸ²ம்ʼ நிரூப்ய தாந் த்³ராக்ஷாக்ஷேத்ரம்ʼ ப்ரேரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","அநந்தரம்ʼ ப்ரஹரைகவேலாயாம்ʼ க³த்வா ஹட்டே கதிபயாந் நிஷ்கர்ம்மகாந் விலோக்ய தாநவத³த், ");
INSERT INTO santam_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","யூயமபி மம த்³ராக்ஷாக்ஷேத்ரம்ʼ யாத, யுஷ்மப்⁴யமஹம்ʼ யோக்³யப்⁴ருʼதிம்ʼ தா³ஸ்யாமி, ததஸ்தே வவ்ரஜு​:| ");
INSERT INTO santam_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","புநஸ்²ச ஸ த்³விதீயத்ருʼதீயயோ​: ப்ரஹரயோ ர்ப³ஹி ர்க³த்வா ததை²வ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ததோ த³ண்ட³த்³வயாவஸி²ஷ்டாயாம்ʼ வேலாயாம்ʼ ப³ஹி ர்க³த்வாபராந் கதிபயஜநாந் நிஷ்கர்ம்மகாந் விலோக்ய ப்ருʼஷ்டவாந், யூயம்ʼ கிமர்த²ம் அத்ர ஸர்வ்வம்ʼ தி³நம்ʼ நிஷ்கர்ம்மாணஸ்திஷ்ட²த²? ");
INSERT INTO santam_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","தே ப்ரத்யவத³ந், அஸ்மாந் ந கோபி கர்மமணி நியும்ʼக்தே| ததா³நீம்ʼ ஸ கதி²தவாந், யூயமபி மம த்³ராக்ஷாக்ஷேத்ரம்ʼ யாத, தேந யோக்³யாம்ʼ ப்⁴ருʼதிம்ʼ லப்ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","தத³நந்தரம்ʼ ஸந்த்⁴யாயாம்ʼ ஸத்யாம்ʼ ஸஏவ த்³ராக்ஷாக்ஷேத்ரபதிரத்⁴யக்ஷம்ʼ க³தி³வாந், க்ருʼஷகாந் ஆஹூய ஸே²ஷஜநமாரப்⁴ய ப்ரத²மம்ʼ யாவத் தேப்⁴யோ ப்⁴ருʼதிம்ʼ தே³ஹி| ");
INSERT INTO santam_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","தேந யே த³ண்ட³த்³வயாவஸ்தி²தே ஸமாயாதாஸ்தேஷாம் ஏகைகோ ஜநோ முத்³ராசதுர்தா²ம்ʼஸ²ம்ʼ ப்ராப்நோத்| ");
INSERT INTO santam_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ததா³நீம்ʼ ப்ரத²மநியுக்தா ஜநா ஆக³த்யாநுமிதவந்தோ வயமதி⁴கம்ʼ ப்ரப்ஸ்யாம​:, கிந்து தைரபி முத்³ராசதுர்தா²ம்ʼஸோ²(அ)லாபி⁴| ");
INSERT INTO santam_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ததஸ்தே தம்ʼ க்³ருʼஹீத்வா தேந க்ஷேத்ரபதிநா ஸாகம்ʼ வாக்³யுத்³த⁴ம்ʼ குர்வ்வந்த​: கத²யாமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","வயம்ʼ க்ருʼத்ஸ்நம்ʼ தி³நம்ʼ தாபக்லேஸௌ² ஸோட⁴வந்த​:, கிந்து பஸ்²சாதாயா ஸே ஜநா த³ண்ட³த்³வயமாத்ரம்ʼ பரிஸ்²ராந்தவந்தஸ்தே(அ)ஸ்மாபி⁴​: ஸமாநாம்ʼஸா²​: க்ருʼதா​:| ");
INSERT INTO santam_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","தத​: ஸ தேஷாமேகம்ʼ ப்ரத்யுவாச, ஹே வத்ஸ, மயா த்வாம்ʼ ப்ரதி கோப்யந்யாயோ ந க்ருʼத​: கிம்ʼ த்வயா மத்ஸமக்ஷம்ʼ முத்³ராசதுர்தா²ம்ʼஸோ² நாங்கீ³க்ருʼத​:? ");
INSERT INTO santam_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","தஸ்மாத் தவ யத் ப்ராப்யம்ʼ ததா³தா³ய யாஹி, துப்⁴யம்ʼ யதி, பஸ்²சாதீயநியுக்தலோகாயாபி ததி தா³துமிச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ஸ்வேச்ச²யா நிஜத்³ரவ்யவ்யவஹரணம்ʼ கிம்ʼ மயா ந கர்த்தவ்யம்ʼ? மம தா³த்ருʼத்வாத் த்வயா கிம் ஈர்ஷ்யாத்³ருʼஷ்டி​: க்ரியதே? ");
INSERT INTO santam_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","இத்த²ம் அக்³ரீயலோகா​: பஸ்²சதீயா ப⁴விஷ்யந்தி, பஸ்²சாதீயஜநாஸ்²சக்³ரீயா ப⁴விஷ்யந்தி, அஹூதா ப³ஹவ​: கிந்த்வல்பே மநோபி⁴லஷிதா​:| ");
INSERT INTO santam_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","தத³நந்தரம்ʼ யீஸு² ர்யிரூஸா²லம்நக³ரம்ʼ க³ச்ச²ந் மார்க³மத்⁴யே ஸி²ஷ்யாந் ஏகாந்தே வபா⁴ஷே, ");
INSERT INTO santam_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","பஸ்²ய வயம்ʼ யிரூஸா²லம்நக³ரம்ʼ யாம​:, தத்ர ப்ரதா⁴நயாஜகாத்⁴யாபகாநாம்ʼ கரேஷு மநுஷ்யபுத்ர​: ஸமர்பிஷ்யதே; ");
INSERT INTO santam_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","தே ச தம்ʼ ஹந்துமாஜ்ஞாப்ய திரஸ்க்ருʼத்ய வேத்ரேண ப்ரஹர்த்தும்ʼ க்ருஸே² தா⁴தயிதுஞ்சாந்யதே³ஸீ²யாநாம்ʼ கரேஷு ஸமர்பயிஷ்யந்தி, கிந்து ஸ த்ருʼதீயதி³வஸே ஸ்²மஸா²நாத்³ உத்தா²பிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ததா³நீம்ʼ ஸிவதீ³யஸ்ய நாரீ ஸ்வபுத்ராவாதா³ய யீஸோ²​: ஸமீபம் ஏத்ய ப்ரணம்ய கஞ்சநாநுக்³ரஹம்ʼ தம்ʼ யயாசே| ");
INSERT INTO santam_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ததா³ யீஸு²ஸ்தாம்ʼ ப்ரோக்தவாந், த்வம்ʼ கிம்ʼ யாசஸே? தத​: ஸா ப³பா⁴ஷே, ப⁴வதோ ராஜத்வே மமாநயோ​: ஸுதயோரேகம்ʼ ப⁴வத்³த³க்ஷிணபார்ஸ்²வே த்³விதீயம்ʼ வாமபார்ஸ்²வ உபவேஷ்டும் ஆஜ்ஞாபயது| ");
INSERT INTO santam_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","யீஸு²​: ப்ரத்யுவாச, யுவாப்⁴யாம்ʼ யத்³ யாச்யதே, தந்ந பு³த்⁴யதே, அஹம்ʼ யேந கம்ʼஸேந பாஸ்யாமி யுவாப்⁴யாம்ʼ கிம்ʼ தேந பாதும்ʼ ஸ²க்யதே? அஹஞ்ச யேந மஜ்ஜேநேந மஜ்ஜிஷ்யே, யுவாப்⁴யாம்ʼ கிம்ʼ தேந மஜ்ஜயிதும்ʼ ஸ²க்யதே? தே ஜக³து³​: ஸ²க்யதே| ");
INSERT INTO santam_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ததா³ ஸ உக்தவாந், யுவாம்ʼ மம கம்ʼஸேநாவஸ்²யம்ʼ பாஸ்யத²​:, மம மஜ்ஜநேந ச யுவாமபி மஜ்ஜிஷ்யேதே², கிந்து யேஷாம்ʼ க்ருʼதே மத்தாதேந நிரூபிதம் இத³ம்ʼ தாந் விஹாயாந்யம்ʼ கமபி மத்³த³க்ஷிணபார்ஸ்²வே வாமபார்ஸ்²வே ச ஸமுபவேஸ²யிதும்ʼ மமாதி⁴காரோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வாந்யே த³ஸ²ஸி²ஷ்யாஸ்தௌ ப்⁴ராதரௌ ப்ரதி சுகுபு​:| ");
INSERT INTO santam_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","கிந்து யீஸு²​: ஸ்வஸமீபம்ʼ தாநாஹூய ஜகா³த³, அந்யதே³ஸீ²யலோகாநாம்ʼ நரபதயஸ்தாந் அதி⁴குர்வ்வந்தி, யே து மஹாந்தஸ்தே தாந் ஸா²ஸதி, இதி யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","கிந்து யுஷ்மாகம்ʼ மத்⁴யே ந ததா² ப⁴வேத், யுஷ்மாகம்ʼ ய​: கஸ்²சித் மஹாந் பு³பூ⁴ஷதி, ஸ யுஷ்மாந் ஸேவேத; ");
INSERT INTO santam_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","யஸ்²ச யுஷ்மாகம்ʼ மத்⁴யே முக்²யோ பு³பூ⁴ஷதி, ஸ யுஷ்மாகம்ʼ தா³ஸோ ப⁴வேத்| ");
INSERT INTO santam_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","இத்த²ம்ʼ மநுஜபுத்ர​: ஸேவ்யோ ப⁴விதும்ʼ நஹி, கிந்து ஸேவிதும்ʼ ப³ஹூநாம்ʼ பரித்ராணமூல்யார்த²ம்ʼ ஸ்வப்ராணாந் தா³துஞ்சாக³த​:| ");
INSERT INTO santam_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","அநந்தரம்ʼ யிரீஹோநக³ராத் தேஷாம்ʼ ப³ஹிர்க³மநஸமயே தஸ்ய பஸ்²சாத்³ ப³ஹவோ லோகா வவ்ரஜு​:| ");
INSERT INTO santam_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","அபரம்ʼ வர்த்மபார்ஸ்²வ உபவிஸ²ந்தௌ த்³வாவந்தௌ⁴ தேந மார்கே³ண யீஸோ² ர்க³மநம்ʼ நிஸ²ம்ய ப்ரோச்சை​: கத²யாமாஸது​:, ஹே ப்ரபோ⁴ தா³யூத³​: ஸந்தாந, ஆவயோ ர்த³யாம்ʼ விதே⁴ஹி| ");
INSERT INTO santam_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ததோ லோகா​: ஸர்வ்வே துஷ்ணீம்ப⁴வதமித்யுக்த்வா தௌ தர்ஜயாமாஸு​:; ததா²பி தௌ புநருச்சை​: கத²யாமாஸது​: ஹே ப்ரபோ⁴ தா³யூத³​: ஸந்தாந, ஆவாம்ʼ த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ததா³நீம்ʼ யீஸு²​: ஸ்த²கி³த​: ஸந் தாவாஹூய பா⁴ஷிதவாந், யுவயோ​: க்ருʼதே மயா கிம்ʼ கர்த்தர்வ்யம்ʼ? யுவாம்ʼ கிம்ʼ காமயேதே²? ");
INSERT INTO santam_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ததா³ தாவுக்தவந்தௌ, ப்ரபோ⁴ நேத்ராணி நௌ ப்ரஸந்நாநி ப⁴வேயு​:| ");
INSERT INTO santam_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ததா³நீம்ʼ யீஸு²ஸ்தௌ ப்ரதி ப்ரமந்ந​: ஸந் தயோ ர்நேத்ராணி பஸ்பர்ஸ², தேநைவ தௌ ஸுவீக்ஷாஞ்சக்ராதே தத்பஸ்²சாத் ஜக்³முதுஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","அநந்தரம்ʼ தேஷு யிரூஸா²லம்நக³ரஸ்ய ஸமீபவேர்த்திநோ ஜைதுநநாமகத⁴ராத⁴ரஸ்ய ஸமீபஸ்த்²திம்ʼ பை³த்ப²கி³க்³ராமம் ஆக³தேஷு, யீஸு²​: ஸி²ஷ்யத்³வயம்ʼ ப்ரேஷயந் ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","யுவாம்ʼ ஸம்முக²ஸ்த²க்³ராமம்ʼ க³த்வா ப³த்³தா⁴ம்ʼ யாம்ʼ ஸவத்ஸாம்ʼ க³ர்த்³த³பீ⁴ம்ʼ ஹடா²த் ப்ராப்ஸ்யத²​:, தாம்ʼ மோசயித்வா மத³ந்திகம் ஆநயதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","தத்ர யதி³ கஸ்²சித் கிஞ்சித்³ வக்ஷ்யதி, தர்ஹி வதி³ஷ்யத²​:, ஏதஸ்யாம்ʼ ப்ரபோ⁴​: ப்ரயோஜநமாஸ்தே, தேந ஸ தத்க்ஷணாத் ப்ரஹேஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ஸீயோந​: கந்யகாம்ʼ யூயம்ʼ பா⁴ஷத்⁴வமிதி பா⁴ரதீம்ʼ| பஸ்²ய தே நம்ரஸீ²ல​: ஸந் ந்ருʼப ஆருஹ்ய க³ர்த³பீ⁴ம்ʼ| அர்தா²தா³ருஹ்ய தத்³வத்ஸமாயாஸ்யதி த்வத³ந்திகம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ப⁴விஷ்யத்³வாதி³நோக்தம்ʼ வசநமித³ம்ʼ ததா³ ஸப²லமபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","அநந்தரம்ʼ தௌ ஸ்²ஷ்யிौ யீஸோ² ர்யதா²நிதே³ஸ²ம்ʼ தம்ʼ க்³ராமம்ʼ க³த்வா ");
INSERT INTO santam_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","க³ர்த³பீ⁴ம்ʼ தத்³வத்ஸஞ்ச ஸமாநீதவந்தௌ, பஸ்²சாத் தது³பரி ஸ்வீயவஸநாநீ பாதயித்வா தமாரோஹயாமாஸது​:| ");
INSERT INTO santam_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ததோ ப³ஹவோ லோகா நிஜவஸநாநி பதி² ப்ரஸாரயிதுமாரேபி⁴ரே, கதிபயா ஜநாஸ்²ச பாத³பபர்ணாதி³கம்ʼ சி²த்வா பதி² விஸ்தாரயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","அக்³ரகா³மிந​: பஸ்²சாத்³கா³மிநஸ்²ச மநுஜா உச்சைர்ஜய ஜய தா³யூத³​: ஸந்தாநேதி ஜக³து³​: பரமேஸ்²வரஸ்ய நாம்நா ய ஆயாதி ஸ த⁴ந்ய​:, ஸர்வ்வோபரிஸ்த²ஸ்வர்கே³பி ஜயதி| ");
INSERT INTO santam_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","இத்த²ம்ʼ தஸ்மிந் யிரூஸா²லமம்ʼ ப்ரவிஷ்டே கோ(அ)யமிதி கத²நாத் க்ருʼத்ஸ்நம்ʼ நக³ரம்ʼ சஞ்சலமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","தத்ர லோகோ​: கத²யாமாஸு​:, ஏஷ கா³லீல்ப்ரதே³ஸீ²ய-நாஸரதீய-ப⁴விஷ்யத்³வாதீ³ யீஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","அநந்தரம்ʼ யீஸு²ரீஸ்²வரஸ்ய மந்தி³ரம்ʼ ப்ரவிஸ்²ய தந்மத்⁴யாத் க்ரயவிக்ரயிணோ வஹிஸ்²சகார; வணிஜாம்ʼ முத்³ராஸநாநீ கபோதவிக்ரயிணாஞ்சஸநாநீ ச ந்யுவ்ஜயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","அபரம்ʼ தாநுவாச, ஏஷா லிபிராஸ்தே, \"மம க்³ருʼஹம்ʼ ப்ரார்த²நாக்³ருʼஹமிதி விக்²யாஸ்யதி\", கிந்து யூயம்ʼ தத்³ த³ஸ்யூநாம்ʼ க³ஹ்வரம்ʼ க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","தத³நந்தரம் அந்த⁴க²ஞ்சலோகாஸ்தஸ்ய ஸமீபமாக³தா​:, ஸ தாந் நிராமயாந் க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","யதா³ ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச தேந க்ருʼதாந்யேதாநி சித்ரகர்ம்மாணி த³த்³ருʼஸு²​:, ஜய ஜய தா³யூத³​: ஸந்தாந, மந்தி³ரே பா³லகாநாம் ஏதாத்³ருʼஸ²ம் உச்சத்⁴வநிம்ʼ ஸு²ஸ்²ருவுஸ்²ச, ததா³ மஹாக்ருத்³தா⁴ ப³பூ⁴வ​:, ");
INSERT INTO santam_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","தம்ʼ பப்ரச்சு²ஸ்²ச, இமே யத்³ வத³ந்தி, தத் கிம்ʼ த்வம்ʼ ஸ்²ருʼணோஷி? ததோ யீஸு²ஸ்தாந் அவோசத், ஸத்யம்; ஸ்தந்யபாயிஸி²ஸூ²நாஞ்ச பா³லகாநாஞ்ச வக்த்ரத​:| ஸ்வகீயம்ʼ மஹிமாநம்ʼ த்வம்ʼ ஸம்ʼப்ரகாஸ²யஸி ஸ்வயம்ʼ| ஏதத்³வாக்யம்ʼ யூயம்ʼ கிம்ʼ நாபட²த? ");
INSERT INTO santam_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ததஸ்தாந் விஹாய ஸ நக³ராத்³ பை³த²நியாக்³ராமம்ʼ க³த்வா தத்ர ரஜநீம்ʼ யாபயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","அநந்தரம்ʼ ப்ரபா⁴தே ஸதி யீஸு²​: புநரபி நக³ரமாக³ச்ச²ந் க்ஷுதா⁴ர்த்தோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ததோ மார்க³பார்ஸ்²வ உடு³ம்ப³ரவ்ருʼக்ஷமேகம்ʼ விலோக்ய தத்ஸமீபம்ʼ க³த்வா பத்ராணி விநா கிமபி ந ப்ராப்ய தம்ʼ பாத³பம்ʼ ப்ரோவாச, அத்³யாரப்⁴ய கதா³பி த்வயி ப²லம்ʼ ந ப⁴வது; தேந தத்க்ஷணாத் ஸ உடு³ம்ப³ரமாஹீருஹ​: ஸு²ஷ்கதாம்ʼ க³த​:| ");
INSERT INTO santam_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","தத்³ த்³ருʼஷ்ட்வா ஸி²ஷ்யா ஆஸ்²சர்ய்யம்ʼ விஜ்ஞாய கத²யாமாஸு​:, ஆ​:, உடு³ம்வரபாத³போ(அ)திதூர்ணம்ʼ ஸு²ஷ்கோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ததோ யீஸு²ஸ்தாநுவாச, யுஷ்மாநஹம்ʼ ஸத்யம்ʼ வதா³மி, யதி³ யூயமஸந்தி³க்³தா⁴​: ப்ரதீத², தர்ஹி யூயமபி கேவலோடு³ம்வரபாத³பம்ʼ ப்ரதீத்த²ம்ʼ கர்த்தும்ʼ ஸ²க்ஷ்யத², தந்ந, த்வம்ʼ சலித்வா ஸாக³ரே பதேதி வாக்யம்ʼ யுஷ்மாபி⁴ரஸ்மிந ஸை²லே ப்ரோக்தேபி ததை³வ தத்³ க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ததா² விஸ்²வஸ்ய ப்ரார்த்²ய யுஷ்மாபி⁴ ர்யத்³ யாசிஷ்யதே, ததே³வ ப்ராப்ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","அநந்தரம்ʼ மந்தி³ரம்ʼ ப்ரவிஸ்²யோபதே³ஸ²நஸமயே தத்ஸமீபம்ʼ ப்ரதா⁴நயாஜகா​: ப்ராசீநலோகாஸ்²சாக³த்ய பப்ரச்சு²​:, த்வயா கேந ஸாமர்த்²யநைதாநி கர்ம்மாணி க்ரியந்தே? கேந வா துப்⁴யமேதாநி ஸாமர்த்²யாநி த³த்தாநி? ");
INSERT INTO santam_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ததோ யீஸு²​: ப்ரத்யவத³த், அஹமபி யுஷ்மாந் வாசமேகாம்ʼ ப்ருʼச்சா²மி, யதி³ யூயம்ʼ தது³த்தரம்ʼ தா³தும்ʼ ஸ²க்ஷ்யத², ததா³ கேந ஸாமர்த்²யேந கர்ம்மாண்யேதாநி கரோமி, தத³ஹம்ʼ யுஷ்மாந் வக்ஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","யோஹநோ மஜ்ஜநம்ʼ கஸ்யாஜ்ஞயாப⁴வத்? கிமீஸ்²வரஸ்ய மநுஷ்யஸ்ய வா? ததஸ்தே பரஸ்பரம்ʼ விவிச்ய கத²யாமாஸு​:, யதீ³ஸ்²வரஸ்யேதி வதா³மஸ்தர்ஹி யூயம்ʼ தம்ʼ குதோ ந ப்ரத்யைத? வாசமேதாம்ʼ வக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","மநுஷ்யஸ்யேதி வக்துமபி லோகேப்⁴யோ பி³பீ⁴ம​:, யத​: ஸர்வ்வைரபி யோஹந் ப⁴விஷ்யத்³வாதீ³தி ஜ்ஞாயதே| ");
INSERT INTO santam_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","தஸ்மாத் தே யீஸு²ம்ʼ ப்ரத்யவத³ந், தத்³ வயம்ʼ ந வித்³ம​:| ததா³ ஸ தாநுக்தவாந், தர்ஹி கேந ஸாமரத்²யேந கர்ம்மாண்யேதாந்யஹம்ʼ கரோமி, தத³ப்யஹம்ʼ யுஷ்மாந் ந வக்ஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","கஸ்யசிஜ்ஜநஸ்ய த்³வௌ ஸுதாவாஸ்தாம்ʼ ஸ ஏகஸ்ய ஸுதஸ்ய ஸமீபம்ʼ க³த்வா ஜகா³த³, ஹே ஸுத, த்வமத்³ய மம த்³ராக்ஷாக்ஷேத்ரே கர்ம்ம கர்தும்ʼ வ்ரஜ| ");
INSERT INTO santam_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","தத​: ஸ உக்தவாந், ந யாஸ்யாமி, கிந்து ஸே²ஷே(அ)நுதப்ய ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","அநந்தரம்ʼ ஸோந்யஸுதஸ்ய ஸமீபம்ʼ க³த்வா ததை²வ கத்²திவாந்; தத​: ஸ ப்ரத்யுவாச, மஹேச்ச² யாமி, கிந்து ந க³த​:| ");
INSERT INTO santam_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ஏதயோ​: புத்ரயோ ர்மத்⁴யே பிதுரபி⁴மதம்ʼ கேந பாலிதம்ʼ? யுஷ்மாபி⁴​: கிம்ʼ பு³த்⁴யதே? ததஸ்தே ப்ரத்யூசு​:, ப்ரத²மேந புुத்ரேண| ததா³நீம்ʼ யீஸு²ஸ்தாநுவாச, அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி, சண்டா³லா க³ணிகாஸ்²ச யுஷ்மாகமக்³ரத ஈஸ்²வரஸ்ய ராஜ்யம்ʼ ப்ரவிஸ²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","யதோ யுஷ்மாகம்ʼ ஸமீபம்ʼ யோஹநி த⁴ர்ம்மபதே²நாக³தே யூயம்ʼ தம்ʼ ந ப்ரதீத², கிந்து சண்டா³லா க³ணிகாஸ்²ச தம்ʼ ப்ரத்யாயந், தத்³ விலோக்யாபி யூயம்ʼ ப்ரத்யேதும்ʼ நாகி²த்³யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","அபரமேகம்ʼ த்³ருʼஷ்டாந்தம்ʼ ஸ்²ருʼணுத, கஸ்²சித்³ க்³ருʼஹஸ்த²​: க்ஷேத்ரே த்³ராக்ஷாலதா ரோபயித்வா தச்சதுர்தி³க்ஷு வாரணீம்ʼ விதா⁴ய தந்மத்⁴யே த்³ராக்ஷாயந்த்ரம்ʼ ஸ்தா²பிதவாந், மாஞ்சஞ்ச நிர்ம்மிதவாந், தத​: க்ருʼஷகேஷு தத் க்ஷேத்ரம்ʼ ஸமர்ப்ய ஸ்வயம்ʼ தூ³ரதே³ஸ²ம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","தத³நந்தரம்ʼ ப²லஸமய உபஸ்தி²தே ஸ ப²லாநி ப்ராப்தும்ʼ க்ருʼஷீவலாநாம்ʼ ஸமீபம்ʼ நிஜதா³ஸாந் ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","கிந்து க்ருʼஷீவலாஸ்தஸ்ய தாந் தா³ஸேயாந் த்⁴ருʼத்வா கஞ்சந ப்ரஹ்ருʼதவந்த​:, கஞ்சந பாஷாணைராஹதவந்த​:, கஞ்சந ச ஹதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","புநரபி ஸ ப்ரபு⁴​: ப்ரத²மதோ(அ)தி⁴கதா³ஸேயாந் ப்ரேஷயாமாஸ, கிந்து தே தாந் ப்ரத்யபி ததை²வ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","அநந்தரம்ʼ மம ஸுதே க³தே தம்ʼ ஸமாத³ரிஷ்யந்தே, இத்யுக்த்வா ஸே²ஷே ஸ நிஜஸுதம்ʼ தேஷாம்ʼ ஸந்நிதி⁴ம்ʼ ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","கிந்து தே க்ருʼஷீவலா​: ஸுதம்ʼ வீக்ஷ்ய பரஸ்பரம் இதி மந்த்ரயிதும் ஆரேபி⁴ரே, அயமுத்தராதி⁴காரீ வயமேநம்ʼ நிஹத்யாஸ்யாதி⁴காரம்ʼ ஸ்வவஸீ²கரிஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","பஸ்²சாத் தே தம்ʼ த்⁴ருʼத்வா த்³ராக்ஷாக்ஷேத்ராத்³ ப³ஹி​: பாதயித்வாப³தி⁴ஷு​:| ");
INSERT INTO santam_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","யதா³ ஸ த்³ராக்ஷாக்ஷேத்ரபதிராக³மிஷ்யதி, ததா³ தாந் க்ருʼஷீவலாந் கிம்ʼ கரிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ததஸ்தே ப்ரத்யவத³ந், தாந் கலுஷிணோ தா³ருணயாதநாபி⁴ராஹநிஷ்யதி, யே ச ஸமயாநுக்ரமாத் ப²லாநி தா³ஸ்யந்தி, தாத்³ருʼஸே²ஷு க்ருʼஷீவலேஷு க்ஷேத்ரம்ʼ ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ததா³ யீஸு²நா தே க³தி³தா​:, க்³ரஹணம்ʼ ந க்ருʼதம்ʼ யஸ்ய பாஷாணஸ்ய நிசாயகை​:| ப்ரதா⁴நப்ரஸ்தர​: கோணே ஸஏவ ஸம்ʼப⁴விஷ்யதி| ஏதத் பரேஸி²து​: கர்ம்மாஸ்மத்³ருʼஷ்டாவத்³பு⁴தம்ʼ ப⁴வேத்| த⁴ர்ம்மக்³ரந்தே² லிகி²தமேதத்³வசநம்ʼ யுஷ்மாபி⁴​: கிம்ʼ நாபாடி²? ");
INSERT INTO santam_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","தஸ்மாத³ஹம்ʼ யுஷ்மாந் வதா³மி, யுஷ்மத்த ஈஸ்²வரீயராஜ்யமபநீய ப²லோத்பாத³யித்ரந்யஜாதயே தா³யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","யோ ஜந ஏதத்பாஷாணோபரி பதிஷ்யதி, தம்ʼ ஸ ப⁴ம்ʼக்ஷ்யதே, கிந்த்வயம்ʼ பாஷாணோ யஸ்யோபரி பதிஷ்யதி, தம்ʼ ஸ தூ⁴லிவத் சூர்ணீகரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ததா³நீம்ʼ ப்ராத⁴நயாஜகா​: பி²ரூஸி²நஸ்²ச தஸ்யேமாம்ʼ த்³ருʼஷ்டாந்தகதா²ம்ʼ ஸ்²ருத்வா ஸோ(அ)ஸ்மாநுத்³தி³ஸ்²ய கதி²தவாந், இதி விஜ்ஞாய தம்ʼ த⁴ர்த்தும்ʼ சேஷ்டிதவந்த​:; ");
INSERT INTO santam_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","கிந்து லோகேப்⁴யோ பி³ப்⁴யு​:, யதோ லோகை​: ஸ ப⁴விஷ்யத்³வாதீ³த்யஜ்ஞாயி| ");
INSERT INTO santam_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","அநந்தரம்ʼ யீஸு²​: புநரபி த்³ருʼஷ்டாந்தேந தாந் அவாதீ³த், ");
INSERT INTO santam_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ஸ்வர்கீ³யராஜ்யம் ஏதாத்³ருʼஸ²ஸ்ய ந்ருʼபதே​: ஸமம்ʼ, யோ நிஜ புத்ரம்ʼ விவாஹயந் ஸர்வ்வாந் நிமந்த்ரிதாந் ஆநேதும்ʼ தா³ஸேயாந் ப்ரஹிதவாந், ");
INSERT INTO santam_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","கிந்து தே ஸமாக³ந்தும்ʼ நேஷ்டவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ததோ ராஜா புநரபி தா³ஸாநந்யாந் இத்யுக்த்வா ப்ரேஷயாமாஸ, நிமந்த்ரிதாந் வத³த, பஸ்²யத, மம பே⁴ஜ்யமாஸாதி³தமாஸ்தே, நிஜவ்டஷாதி³புஷ்டஜந்தூந் மாரயித்வா ஸர்வ்வம்ʼ கா²த்³யத்³ரவ்யமாஸாதி³தவாந், யூயம்ʼ விவாஹமாக³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","தத²பி தே துச்சீ²க்ருʼத்ய கேசித் நிஜக்ஷேத்ரம்ʼ கேசித்³ வாணிஜ்யம்ʼ ப்ரதி ஸ்வஸ்வமார்கே³ண சலிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","அந்யே லோகாஸ்தஸ்ய தா³ஸேயாந் த்⁴ருʼத்வா தௌ³ராத்ம்யம்ʼ வ்யவஹ்ருʼத்ய தாநவதி⁴ஷு​:| ");
INSERT INTO santam_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","அநந்தரம்ʼ ஸ ந்ருʼபதிஸ்தாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வா க்ருத்⁴யந் ஸைந்யாநி ப்ரஹித்ய தாந் கா⁴தகாந் ஹத்வா தேஷாம்ʼ நக³ரம்ʼ தா³ஹயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","தத​: ஸ நிஜதா³ஸேயாந் ப³பா⁴ஷே, விவாஹீயம்ʼ போ⁴ஜ்யமாஸாதி³தமாஸ்தே, கிந்து நிமந்த்ரிதா ஜநா அயோக்³யா​:| ");
INSERT INTO santam_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","தஸ்மாத்³ யூயம்ʼ ராஜமார்க³ம்ʼ க³த்வா யாவதோ மநுஜாந் பஸ்²யத, தாவதஏவ விவாஹீயபோ⁴ஜ்யாய நிமந்த்ரயத| ");
INSERT INTO santam_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ததா³ தே தா³ஸேயா ராஜமார்க³ம்ʼ க³த்வா ப⁴த்³ராந் அப⁴த்³ராந் வா யாவதோ ஜநாந் த³த்³ருʼஸு²​:, தாவதஏவ ஸம்ʼக்³ருʼஹ்யாநயந்; ததோ(அ)ப்⁴யாக³தமநுஜை ர்விவாஹக்³ருʼஹம் அபூர்ய்யத| ");
INSERT INTO santam_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ததா³நீம்ʼ ஸ ராஜா ஸர்வ்வாநப்⁴யாக³தாந் த்³ரஷ்டும் அப்⁴யந்தரமாக³தவாந்; ததா³ தத்ர விவாஹீயவஸநஹீநமேகம்ʼ ஜநம்ʼ வீக்ஷ்ய தம்ʼ ஜகா³த்³, ");
INSERT INTO santam_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ஹே மித்ர,த்வம்ʼ விவாஹீயவஸநம்ʼ விநா கத²மத்ர ப்ரவிஷ்டவாந்? தேந ஸ நிருத்தரோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ததா³ ராஜா நிஜாநுசராந் அவத³த், ஏதஸ்ய கரசரணாந் ப³த்³தா⁴ யத்ர ரோத³நம்ʼ த³ந்தைர்த³ந்தக⁴ர்ஷணஞ்ச ப⁴வதி, தத்ர வஹிர்பூ⁴ததமிஸ்ரே தம்ʼ நிக்ஷிபத| ");
INSERT INTO santam_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","இத்த²ம்ʼ ப³ஹவ ஆஹூதா அல்பே மநோபி⁴மதா​:| ");
INSERT INTO santam_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","அநந்தரம்ʼ பி²ரூஸி²ந​: ப்ரக³த்ய யதா² ஸம்ʼலாபேந தம் உந்மாதே² பாதயேயுஸ்ததா² மந்த்ரயித்வா ");
INSERT INTO santam_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ஹேரோதீ³யமநுஜை​: ஸாகம்ʼ நிஜஸி²ஷ்யக³ணேந தம்ʼ ப்ரதி கத²யாமாஸு​:, ஹே கு³ரோ, ப⁴வாந் ஸத்ய​: ஸத்யமீஸ்²வரீயமார்க³முபதி³ஸ²தி, கமபி மாநுஷம்ʼ நாநுருத்⁴யதே, கமபி நாபேக்ஷதே ச, தத்³ வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","அத​: கைஸரபூ⁴பாய கரோ(அ)ஸ்மாகம்ʼ தா³தவ்யோ ந வா? அத்ர ப⁴வதா கிம்ʼ பு³த்⁴யதே? தத்³ அஸ்மாந் வத³து| ");
INSERT INTO santam_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ததோ யீஸு²ஸ்தேஷாம்ʼ க²லதாம்ʼ விஜ்ஞாய கதி²தவாந், ரே கபடிந​: யுயம்ʼ குதோ மாம்ʼ பரிக்ஷத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","தத்கரதா³நஸ்ய முத்³ராம்ʼ மாம்ʼ த³ர்ஸ²யத| ததா³நீம்ʼ தைஸ்தஸ்ய ஸமீபம்ʼ முத்³ராசதுர்த²பா⁴க³ ஆநீதே ");
INSERT INTO santam_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ஸ தாந் பப்ரச்ச², அத்ர கஸ்யேயம்ʼ மூர்த்தி ர்நாம சாஸ்தே? தே ஜக³து³​:, கைஸரபூ⁴பஸ்ய| ");
INSERT INTO santam_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","தத​: ஸ உக்தவாந, கைஸரஸ்ய யத் தத் கைஸராய த³த்த, ஈஸ்²வரஸ்ய யத் தத்³ ஈஸ்²வராய த³த்த| ");
INSERT INTO santam_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","இதி வாக்யம்ʼ நிஸ²ம்ய தே விஸ்மயம்ʼ விஜ்ஞாய தம்ʼ விஹாய சலிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","தஸ்மிந்நஹநி ஸிதூ³கிநோ(அ)ர்தா²த் ஸ்²மஸா²நாத் நோத்தா²ஸ்யந்தீதி வாக்யம்ʼ யே வத³ந்தி, தே யீஸே²ाரந்திகம் ஆக³த்ய பப்ரச்சு²​:, ");
INSERT INTO santam_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ஹே கு³ரோ, கஸ்²சிந்மநுஜஸ்²சேத் நி​:ஸந்தாந​: ஸந் ப்ராணாந் த்யஜதி, தர்ஹி தஸ்ய ப்⁴ராதா தஸ்ய ஜாயாம்ʼ வ்யுஹ்ய ப்⁴ராது​: ஸந்தாநம் உத்பாத³யிஷ்யதீதி மூஸா ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","கிந்த்வஸ்மாகமத்ர கே(அ)பி ஜநா​: ஸப்தஸஹோத³ரா ஆஸந், தேஷாம்ʼ ஜ்யேஷ்ட² ஏகாம்ʼ கந்யாம்ʼ வ்யவஹாத், அபரம்ʼ ப்ராணத்யாக³காலே ஸ்வயம்ʼ நி​:ஸந்தாந​: ஸந் தாம்ʼ ஸ்த்ரியம்ʼ ஸ்வப்⁴ராதரி ஸமர்பிதவாந், ");
INSERT INTO santam_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ததோ த்³விதீயாதி³ஸப்தமாந்தாஸ்²ச ததை²வ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ஸே²ஷே ஸாபீ நாரீ மமார| ");
INSERT INTO santam_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ம்ருʼதாநாம் உத்தா²நஸமயே தேஷாம்ʼ ஸப்தாநாம்ʼ மத்⁴யே ஸா நாரீ கஸ்ய பா⁴ர்ய்யா ப⁴விஷ்யதி? யஸ்மாத் ஸர்வ்வஏவ தாம்ʼ வ்யவஹந்| ");
INSERT INTO santam_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ததோ யீஸு²​: ப்ரத்யவாதீ³த், யூயம்ʼ த⁴ர்ம்மபுஸ்தகம் ஈஸ்²வரீயாம்ʼ ஸ²க்திஞ்ச ந விஜ்ஞாய ப்⁴ராந்திமந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","உத்தா²நப்ராப்தா லோகா ந விவஹந்தி, ந ச வாசா தீ³யந்தே, கிந்த்வீஸ்²வரஸ்ய ஸ்வர்க³ஸ்த²தூ³தாநாம்ʼ ஸத்³ருʼஸா² ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","அபரம்ʼ ம்ருʼதாநாமுத்தா²நமதி⁴ யுஷ்மாந் ப்ரதீயமீஸ்²வரோக்தி​:, ");
INSERT INTO santam_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"அஹமிப்³ராஹீம ஈஸ்²வர இஸ்ஹாக ஈஸ்²வரோ யாகூப³ ஈஸ்²வர\" இதி கிம்ʼ யுஷ்மாபி⁴ ர்நாபாடி²? கிந்த்வீஸ்²வரோ ஜீவதாம் ஈஸ்²வர:, ஸ ம்ருʼதாநாமீஸ்²வரோ நஹி| ");
INSERT INTO santam_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","இதி ஸ்²ருத்வா ஸர்வ்வே லோகாஸ்தஸ்யோபதே³ஸா²த்³ விஸ்மயம்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","அநந்தரம்ʼ ஸிதூ³கிநாம் நிருத்தரத்வவார்தாம்ʼ நிஸ²ம்ய பி²ரூஸி²ந ஏகத்ர மிலிதவந்த​:, ");
INSERT INTO santam_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","தேஷாமேகோ வ்யவஸ்தா²பகோ யீஸு²ம்ʼ பரீக்ஷிதும்ʼ பபச்ச², ");
INSERT INTO santam_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ஹே கு³ரோ வ்யவஸ்தா²ஸா²ஸ்த்ரமத்⁴யே காஜ்ஞா ஸ்²ரேஷ்டா²? ");
INSERT INTO santam_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ததோ யீஸு²ருவாச, த்வம்ʼ ஸர்வ்வாந்த​:கரணை​: ஸர்வ்வப்ராணை​: ஸர்வ்வசித்தைஸ்²ச ஸாகம்ʼ ப்ரபௌ⁴ பரமேஸ்²வரே ப்ரீயஸ்வ, ");
INSERT INTO santam_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ஏஷா ப்ரத²மமஹாஜ்ஞா| தஸ்யா​: ஸத்³ருʼஸீ² த்³விதீயாஜ்ஞைஷா, ");
INSERT INTO santam_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","தவ ஸமீபவாஸிநி ஸ்வாத்மநீவ ப்ரேம குரு| ");
INSERT INTO santam_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","அநயோ ர்த்³வயோராஜ்ஞயோ​: க்ருʼத்ஸ்நவ்யவஸ்தா²யா ப⁴விஷ்யத்³வக்த்ருʼக்³ரந்த²ஸ்ய ச பா⁴ரஸ்திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","அநந்தரம்ʼ பி²ரூஸி²நாம் ஏகத்ர ஸ்தி²திகாலே யீஸு²ஸ்தாந் பப்ரச்ச², ");
INSERT INTO santam_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","க்²ரீஷ்டமதி⁴ யுஷ்மாகம்ʼ கீத்³ருʼக்³போ³தோ⁴ ஜாயதே? ஸ கஸ்ய ஸந்தாந​:? ததஸ்தே ப்ரத்யவத³ந், தா³யூத³​: ஸந்தாந​:| ");
INSERT INTO santam_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ததா³ ஸ உக்தவாந், தர்ஹி தா³யூத்³ கத²ம் ஆத்மாதி⁴ஷ்டா²நேந தம்ʼ ப்ரபு⁴ம்ʼ வத³தி ? ");
INSERT INTO santam_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","யதா² மம ப்ரபு⁴மித³ம்ʼ வாக்யமவத³த் பரமேஸ்²வர​:| தவாரீந் பாத³பீட²ம்ʼ தே யாவந்நஹி கரோம்யஹம்ʼ| தாவத் காலம்ʼ மதீ³யே த்வம்ʼ த³க்ஷபார்ஸ்²வ உபாவிஸ²| அதோ யதி³ தா³யூத்³ தம்ʼ ப்ரபு⁴ம்ʼ வத³தி, ர்திஹ ஸ கத²ம்ʼ தஸ்ய ஸந்தாநோ ப⁴வதி? ");
INSERT INTO santam_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ததா³நீம்ʼ தேஷாம்ʼ கோபி தத்³வாக்யஸ்ய கிமப்யுத்தரம்ʼ தா³தும்ʼ நாஸ²க்நோத்; ");
INSERT INTO santam_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","தத்³தி³நமாரப்⁴ய தம்ʼ கிமபி வாக்யம்ʼ ப்ரஷ்டும்ʼ கஸ்யாபி ஸாஹஸோ நாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","அநந்தரம்ʼ யீஸு² ர்ஜநநிவஹம்ʼ ஸி²ஷ்யாம்ʼஸ்²சாவத³த், ");
INSERT INTO santam_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","அத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச மூஸாஸநே உபவிஸ²ந்தி, ");
INSERT INTO santam_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","அதஸ்தே யுஷ்மாந் யத்³யத் மந்தும் ஆஜ்ஞாபயந்தி, தத் மந்யத்⁴வம்ʼ பாலயத்⁴வஞ்ச, கிந்து தேஷாம்ʼ கர்ம்மாநுரூபம்ʼ கர்ம்ம ந குருத்⁴வம்ʼ; யதஸ்தேஷாம்ʼ வாக்யமாத்ரம்ʼ ஸாரம்ʼ கார்ய்யே கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","தே து³ர்வ்வஹாந் கு³ருதராந் பா⁴ராந் ப³த்³வ்வா மநுஷ்யாணாம்ʼ ஸ்கந்தே⁴பரி ஸமர்பயந்தி, கிந்து ஸ்வயமங்கு³ல்யைகயாபி ந சாலயந்தி| ");
INSERT INTO santam_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","கேவலம்ʼ லோகத³ர்ஸ²நாய ஸர்வ்வகர்ம்மாணி குர்வ்வந்தி; ப²லத​: பட்டப³ந்தா⁴ந் ப்ரஸார்ய்ய தா⁴ரயந்தி, ஸ்வவஸ்த்ரேஷு ச தீ³ர்க⁴க்³ரந்தீ²ந் தா⁴ரயந்தி; ");
INSERT INTO santam_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","போ⁴ஜநப⁴வந உச்சஸ்தா²நம்ʼ, ப⁴ஜநப⁴வநே ப்ரதா⁴நமாஸநம்ʼ, ");
INSERT INTO santam_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ஹட்டே² நமஸ்காரம்ʼ கு³ருரிதி ஸம்போ³த⁴நஞ்சைதாநி ஸர்வ்வாணி வாஞ்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","கிந்து யூயம்ʼ கு³ரவ இதி ஸம்போ³த⁴நீயா மா ப⁴வத, யதோ யுஷ்மாகம் ஏக​: க்²ரீஷ்டஏவ கு³ரு ");
INSERT INTO santam_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ர்யூயம்ʼ ஸர்வ்வே மிதோ² ப்⁴ராதரஸ்²ச| புந​: ப்ருʼதி²வ்யாம்ʼ கமபி பிதேதி மா ஸம்பு³த்⁴யத்⁴வம்ʼ, யதோ யுஷ்மாகமேக​: ஸ்வர்க³ஸ்த²ஏவ பிதா| ");
INSERT INTO santam_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","யூயம்ʼ நாயகேதி ஸம்பா⁴ஷிதா மா ப⁴வத, யதோ யுஷ்மாகமேக​: க்²ரீஷ்டஏவ நாயக​:| ");
INSERT INTO santam_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","அபரம்ʼ யுஷ்மாகம்ʼ மத்⁴யே ய​: புமாந் ஸ்²ரேஷ்ட²​: ஸ யுஷ்மாந் ஸேவிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","யதோ ய​: ஸ்வமுந்நமதி, ஸ நத​: கரிஷ்யதே; கிந்து ய​: கஸ்²சித் ஸ்வமவநதம்ʼ கரோதி, ஸ உந்நத​: கரிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ஹந்த கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயம்ʼ மநுஜாநாம்ʼ ஸமக்ஷம்ʼ ஸ்வர்க³த்³வாரம்ʼ ருந்த⁴, யூயம்ʼ ஸ்வயம்ʼ தேந ந ப்ரவிஸ²த², ப்ரவிவிக்ஷூநபி வாரயத²| வத கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச யூயம்ʼ ச²லாத்³ தீ³ர்க⁴ம்ʼ ப்ரார்த்²ய வித⁴வாநாம்ʼ ஸர்வ்வஸ்வம்ʼ க்³ரஸத², யுஷ்மாகம்ʼ கோ⁴ரதரத³ண்டோ³ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ஹந்த கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயமேகம்ʼ ஸ்வத⁴ர்ம்மாவலம்பி³நம்ʼ கர்த்தும்ʼ ஸாக³ரம்ʼ பூ⁴மண்ட³லஞ்ச ப்ரத³க்ஷிணீகுருத², ");
INSERT INTO santam_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","கஞ்சந ப்ராப்ய ஸ்வதோ த்³விகு³ணநரகபா⁴ஜநம்ʼ தம்ʼ குருத²| ");
INSERT INTO santam_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","வத அந்த⁴பத²த³ர்ஸ²கா​: ஸர்வ்வே, யூயம்ʼ வத³த², மந்தி³ரஸ்ய ஸ²பத²கரணாத் கிமபி ந தே³யம்ʼ; கிந்து மந்தி³ரஸ்த²ஸுவர்ணஸ்ய ஸ²பத²கரணாத்³ தே³யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ஹே மூடா⁴ ஹே அந்தா⁴​: ஸுவர்ணம்ʼ தத்ஸுவர்ணபாவகமந்தி³ரம் ஏதயோருப⁴யோ ர்மத்⁴யே கிம்ʼ ஸ்²ரேய​:? ");
INSERT INTO santam_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","அந்யச்ச வத³த², யஜ்ஞவேத்³யா​: ஸ²பத²கரணாத் கிமபி ந தே³யம்ʼ, கிந்து தது³பரிஸ்தி²தஸ்ய நைவேத்³யஸ்ய ஸ²பத²கரணாத்³ தே³யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ஹே மூடா⁴ ஹே அந்தா⁴​:, நைவேத்³யம்ʼ தந்நைவேத்³யபாவகவேதி³ரேதயோருப⁴யோ ர்மத்⁴யே கிம்ʼ ஸ்²ரேய​:? ");
INSERT INTO santam_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","அத​: கேநசித்³ யஜ்ஞவேத்³யா​: ஸ²பதே² க்ருʼதே தது³பரிஸ்த²ஸ்ய ஸர்வ்வஸ்ய ஸ²பத²​: க்ரியதே| ");
INSERT INTO santam_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","கேநசித் மந்தி³ரஸ்ய ஸ²பதே² க்ருʼதே மந்தி³ரதந்நிவாஸிநோ​: ஸ²பத²​: க்ரியதே| ");
INSERT INTO santam_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","கேநசித் ஸ்வர்க³ஸ்ய ஸ²பதே² க்ருʼதே ஈஸ்²வரீயஸிம்ʼஹாஸநதது³பர்ய்யுபவிஷ்டயோ​: ஸ²பத²​: க்ரியதே| ");
INSERT INTO santam_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ஹந்த கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயம்ʼ போதி³நாயா​: ஸிதச்ச²த்ராயா ஜீரகஸ்ய ச த³ஸ²மாம்ʼஸா²ந் த³த்த², கிந்து வ்யவஸ்தா²யா கு³ருதராந் ந்யாயத³யாவிஸ்²வாஸாந் பரித்யஜத²; இமே யுஷ்மாபி⁴ராசரணீயா அமீ ச ந லம்ʼக⁴நீயா​:| ");
INSERT INTO santam_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ஹே அந்த⁴பத²த³ர்ஸ²கா யூயம்ʼ மஸ²காந் அபஸாரயத², கிந்து மஹாங்கா³ந் க்³ரஸத²| ");
INSERT INTO santam_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ஹந்த கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயம்ʼ பாநபாத்ராணாம்ʼ போ⁴ஜநபாத்ராணாஞ்ச ப³ஹி​: பரிஷ்குருத²; கிந்து தத³ப்⁴யந்தரம்ʼ து³ராத்மதயா கலுஷேண ச பரிபூர்ணமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ஹே அந்தா⁴​: பி²ரூஸி²லோகா ஆதௌ³ பாநபாத்ராணாம்ʼ போ⁴ஜநபாத்ராணாஞ்சாப்⁴யந்தரம்ʼ பரிஷ்குருத, தேந தேஷாம்ʼ ப³ஹிரபி பரிஷ்காரிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ஹந்த கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயம்ʼ ஸு²க்லீக்ருʼதஸ்²மஸா²நஸ்வரூபா ப⁴வத², யதா² ஸ்²மஸா²நப⁴வநஸ்ய ப³ஹிஸ்²சாரு, கிந்த்வப்⁴யந்தரம்ʼ ம்ருʼதலோகாநாம்ʼ கீகஸை²​: ஸர்வ்வப்ரகாரமலேந ச பரிபூர்ணம்; ");
INSERT INTO santam_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ததை²வ யூயமபி லோகாநாம்ʼ ஸமக்ஷம்ʼ ப³ஹிர்தா⁴ர்ம்மிகா​: கிந்த்வந்த​:கரணேஷு கேவலகாபட்யாத⁴ர்ம்மாப்⁴யாம்ʼ பரிபூர்ணா​:| ");
INSERT INTO santam_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ஹா ஹா கபடிந உபாத்⁴யாயா​: பி²ரூஸி²நஸ்²ச, யூயம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ ஸ்²மஸா²நகே³ஹம்ʼ நிர்ம்மாத², ஸாதூ⁴நாம்ʼ ஸ்²மஸா²நநிகேதநம்ʼ ஸோ²ப⁴யத² ");
INSERT INTO santam_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","வத³த² ச யதி³ வயம்ʼ ஸ்வேஷாம்ʼ பூர்வ்வபுருஷாணாம்ʼ கால அஸ்தா²ஸ்யாம, தர்ஹி ப⁴விஷ்யத்³வாதி³நாம்ʼ ஸோ²ணிதபாதநே தேஷாம்ʼ ஸஹபா⁴கி³நோ நாப⁴விஷ்யாம| ");
INSERT INTO santam_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","அதோ யூயம்ʼ ப⁴விஷ்யத்³வாதி³கா⁴தகாநாம்ʼ ஸந்தாநா இதி ஸ்வயமேவ ஸ்வேஷாம்ʼ ஸாக்ஷ்யம்ʼ த³த்த²| ");
INSERT INTO santam_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","அதோ யூயம்ʼ நிஜபூர்வ்வபுருஷாணாம்ʼ பரிமாணபாத்ரம்ʼ பரிபூரயத| ");
INSERT INTO santam_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ரே பு⁴ஜகா³​: க்ருʼஷ்ணபு⁴ஜக³வம்ʼஸா²​:, யூயம்ʼ கத²ம்ʼ நரகத³ண்டா³த்³ ரக்ஷிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","பஸ்²யத, யுஷ்மாகமந்திகம் அஹம்ʼ ப⁴விஷ்யத்³வாதி³நோ பு³த்³தி⁴மத உபாத்⁴யாயாம்ʼஸ்²ச ப்ரேஷயிஷ்யாமி, கிந்து தேஷாம்ʼ கதிபயா யுஷ்மாபி⁴ ர்கா⁴நிஷ்யந்தே, க்ருஸே² ச கா⁴நிஷ்யந்தே, கேசித்³ ப⁴ஜநப⁴வநே கஷாபி⁴ராகா⁴நிஷ்யந்தே, நக³ரே நக³ரே தாடி³ஷ்யந்தே ச; ");
INSERT INTO santam_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","தேந ஸத்புருஷஸ்ய ஹாபி³லோ ரக்தபாதமாரப்⁴ய பே³ரிகி²ய​: புத்ரம்ʼ யம்ʼ ஸிக²ரியம்ʼ யூயம்ʼ மந்தி³ரயஜ்ஞவேத்³யோ ர்மத்⁴யே ஹதவந்த​:, ததீ³யஸோ²ணிதபாதம்ʼ யாவத்³ அஸ்மிந் தே³ஸே² யாவதாம்ʼ ஸாது⁴புருஷாணாம்ʼ ஸோ²ணிதபாதோ (அ)ப⁴வத் தத் ஸர்வ்வேஷாமாக³ஸாம்ʼ த³ண்டா³ யுஷ்மாஸு வர்த்திஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","அஹம்ʼ யுஷ்மாந்த தத்²யம்ʼ வதா³மி, வித்³யமாநே(அ)ஸ்மிந் புருஷே ஸர்வ்வே வர்த்திஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ஹே யிரூஸா²லம் ஹே யிரூஸா²லம் நக³ரி த்வம்ʼ ப⁴விஷ்யத்³வாதி³நோ ஹதவதீ, தவ ஸமீபம்ʼ ப்ரேரிதாம்ʼஸ்²ச பாஷாணைராஹதவதீ, யதா² குக்குடீ ஸா²வகாந் பக்ஷாத⁴​: ஸம்ʼக்³ருʼஹ்லாதி, ததா² தவ ஸந்தாநாந் ஸம்ʼக்³ரஹீதும்ʼ அஹம்ʼ ப³ஹுவாரம் ஐச்ச²ம்ʼ; கிந்து த்வம்ʼ ந ஸமமந்யதா²​:| ");
INSERT INTO santam_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","பஸ்²யத யஷ்மாகம்ʼ வாஸஸ்தா²நம் உச்சி²ந்நம்ʼ த்யக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி, ய​: பரமேஸ்²வரஸ்ய நாம்நாக³ச்ச²தி, ஸ த⁴ந்ய இதி வாணீம்ʼ யாவந்ந வதி³ஷ்யத², தாவத் மாம்ʼ புந ர்ந த்³ரக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","அநந்தரம்ʼ யீஸு² ர்யதா³ மந்தி³ராத்³ ப³ஹி ர்க³ச்ச²தி, ததா³நீம்ʼ ஸி²ஷ்யாஸ்தம்ʼ மந்தி³ரநிர்ம்மாணம்ʼ த³ர்ஸ²யிதுமாக³தா​:| ");
INSERT INTO santam_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ததோ யீஸு²ஸ்தாநுவாச, யூயம்ʼ கிமேதாநி ந பஸ்²யத²? யுஷ்மாநஹம்ʼ ஸத்யம்ʼ வதா³மி, ஏதந்நிசயநஸ்ய பாஷாணைகமப்யந்யபாஷாணேाபரி ந ஸ்தா²ஸ்யதி ஸர்வ்வாணி பூ⁴மிஸாத் காரிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","அநந்தரம்ʼ தஸ்மிந் ஜைதுநபர்வ்வதோபரி ஸமுபவிஷ்டே ஸி²ஷ்யாஸ்தஸ்ய ஸமீபமாக³த்ய கு³ப்தம்ʼ பப்ரச்சு²​:, ஏதா க⁴டநா​: கதா³ ப⁴விஷ்யந்தி? ப⁴வத ஆக³மநஸ்ய யுகா³ந்தஸ்ய ச கிம்ʼ லக்ஷ்ம? தத³ஸ்மாந் வத³து| ");
INSERT INTO santam_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ததா³நீம்ʼ யீஸு²ஸ்தாநவோசத், அவத⁴த்³வ்வம்ʼ, கோபி யுஷ்மாந் ந ப்⁴ரமயேத்| ");
INSERT INTO santam_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ப³ஹவோ மம நாம க்³ருʼஹ்லந்த ஆக³மிஷ்யந்தி, க்²ரீஷ்டோ(அ)ஹமேவேதி வாசம்ʼ வத³ந்தோ ப³ஹூந் ப்⁴ரமயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","யூயஞ்ச ஸம்ʼக்³ராமஸ்ய ரணஸ்ய சாட³ம்ப³ரம்ʼ ஸ்²ரோஷ்யத², அவத⁴த்³வ்வம்ʼ தேந சஞ்சலா மா ப⁴வத, ஏதாந்யவஸ்²யம்ʼ க⁴டிஷ்யந்தே, கிந்து ததா³ யுகா³ந்தோ நஹி| ");
INSERT INTO santam_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","அபரம்ʼ தே³ஸ²ஸ்ய விபக்ஷோ தே³ஸோ² ராஜ்யஸ்ய விபக்ஷோ ராஜ்யம்ʼ ப⁴விஷ்யதி, ஸ்தா²நே ஸ்தா²நே ச து³ர்பி⁴க்ஷம்ʼ மஹாமாரீ பூ⁴கம்பஸ்²ச ப⁴விஷ்யந்தி, ");
INSERT INTO santam_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ஏதாநி து³​:கோ²பக்ரமா​:| ");
INSERT INTO santam_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ததா³நீம்ʼ லோகா து³​:க²ம்ʼ போ⁴ஜயிதும்ʼ யுஷ்மாந் பரகரேஷு ஸமர்பயிஷ்யந்தி ஹநிஷ்யந்தி ச, ததா² மம நாமகாரணாத்³ யூயம்ʼ ஸர்வ்வதே³ஸீ²யமநுஜாநாம்ʼ ஸமீபே க்⁴ருʼணார்ஹா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ப³ஹுஷு விக்⁴நம்ʼ ப்ராப்தவத்ஸு பரஸ்பரம் ருʼृதீயாம்ʼ க்ருʼதவத்ஸு ச ஏகோ(அ)பரம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ததா² ப³ஹவோ ம்ருʼஷாப⁴விஷ்யத்³வாதி³ந உபஸ்தா²ய ப³ஹூந் ப்⁴ரமயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","து³ஷ்கர்ம்மணாம்ʼ பா³ஹுல்யாஞ்ச ப³ஹூநாம்ʼ ப்ரேம ஸீ²தலம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","கிந்து ய​: கஸ்²சித் ஸே²ஷம்ʼ யாவத்³ தை⁴ர்ய்யமாஸ்²ரயதே, ஸஏவ பரித்ராயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","அபரம்ʼ ஸர்வ்வதே³ஸீ²யலோகாந் ப்ரதிமாக்ஷீ ப⁴விதும்ʼ ராஜஸ்ய ஸு²ப⁴ஸமாசார​: ஸர்வ்வஜக³தி ப்ரசாரிஷ்யதே, ஏதாத்³ருʼஸி² ஸதி யுகா³ந்த உபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","அதோ யத் ஸர்வ்வநாஸ²க்ருʼத்³க்⁴ருʼணார்ஹம்ʼ வஸ்து தா³நியேல்ப⁴விஷ்யத்³வதி³நா ப்ரோக்தம்ʼ தத்³ யதா³ புண்யஸ்தா²நே ஸ்தா²பிதம்ʼ த்³ரக்ஷ்யத², (ய​: பட²தி, ஸ பு³த்⁴யதாம்ʼ) ");
INSERT INTO santam_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ததா³நீம்ʼ யே யிஹூதீ³யதே³ஸே² திஷ்ட²ந்தி, தே பர்வ்வதேஷு பலாயந்தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ய​: கஸ்²சித்³ க்³ருʼஹப்ருʼஷ்டே² திஷ்ட²தி, ஸ க்³ருʼஹாத் கிமபி வஸ்த்வாநேதும் அதே⁴ा நாவரோஹேத்| ");
INSERT INTO santam_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","யஸ்²ச க்ஷேத்ரே திஷ்ட²தி, ஸோபி வஸ்த்ரமாநேதும்ʼ பராவ்ருʼத்ய ந யாயாத்| ");
INSERT INTO santam_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ததா³நீம்ʼ க³ர்பி⁴ணீஸ்தந்யபாயயித்ரீணாம்ʼ து³ர்க³தி ர்ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","அதோ யஷ்மாகம்ʼ பலாயநம்ʼ ஸீ²தகாலே விஸ்²ராமவாரே வா யந்ந ப⁴வேத், தத³ர்த²ம்ʼ ப்ரார்த²யத்⁴வம்| ");
INSERT INTO santam_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ஆ ஜக³தா³ரம்பா⁴த்³ ஏதத்காலபர்ய்யநந்தம்ʼ யாத்³ருʼஸ²​: கதா³பி நாப⁴வத் ந ச ப⁴விஷ்யதி தாத்³ருʼஸோ² மஹாக்லேஸ²ஸ்ததா³நீம் உபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","தஸ்ய க்லேஸ²ஸ்ய ஸமயோ யதி³ ஹ்ஸ்வோ ந க்ரியேத, தர்ஹி கஸ்யாபி ப்ராணிநோ ரக்ஷணம்ʼ ப⁴விதும்ʼ ந ஸ²க்நுயாத், கிந்து மநோநீதமநுஜாநாம்ʼ க்ருʼதே ஸ காலோ ஹ்ஸ்வீகரிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","அபரஞ்ச பஸ்²யத, க்²ரீஷ்டோ(அ)த்ர வித்³யதே, வா தத்ர வித்³யதே, ததா³நீம்ʼ யதீ³ கஸ்²சித்³ யுஷ்மாந இதி வாக்யம்ʼ வத³தி, ததா²பி தத் ந ப்ரதீத்| ");
INSERT INTO santam_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","யதோ பா⁴க்தக்²ரீஷ்டா பா⁴க்தப⁴விஷ்யத்³வாதி³நஸ்²ச உபஸ்தா²ய யாநி மஹந்தி லக்ஷ்மாணி சித்ரகர்ம்மாணி ச ப்ரகாஸ²யிஷ்யந்தி, தை ர்யதி³ ஸம்ப⁴வேத் தர்ஹி மநோநீதமாநவா அபி ப்⁴ராமிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","பஸ்²யத, க⁴டநாத​: பூர்வ்வம்ʼ யுஷ்மாந் வார்த்தாம் அவாதி³ஷம்| ");
INSERT INTO santam_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","அத​: பஸ்²யத, ஸ ப்ராந்தரே வித்³யத இதி வாக்யே கேநசித் கதி²தேபி ப³ஹி ர்மா க³ச்ச²த, வா பஸ்²யத, ஸோந்த​:புரே வித்³யதே, ஏதத்³வாக்ய உக்தேபி மா ப்ரதீத| ");
INSERT INTO santam_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","யதோ யதா² வித்³யுத் பூர்வ்வதி³ஸோ² நிர்க³த்ய பஸ்²சிமதி³ஸ²ம்ʼ யாவத் ப்ரகாஸ²தே, ததா² மாநுஷபுத்ரஸ்யாப்யாக³மநம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","யத்ர ஸ²வஸ்திஷ்ட²தி, தத்ரேவ க்³ருʼத்⁴ரா மிலந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","அபரம்ʼ தஸ்ய க்லேஸ²ஸமயஸ்யாவ்யவஹிதபரத்ர ஸூர்ய்யஸ்ய தேஜோ லோப்ஸ்யதே, சந்த்³ரமா ஜ்யோஸ்நாம்ʼ ந கரிஷ்யதி, நப⁴ஸோ நக்ஷத்ராணி பதிஷ்யந்தி, க³க³ணீயா க்³ரஹாஸ்²ச விசலிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ததா³நீம் ஆகாஸ²மத்⁴யே மநுஜஸுதஸ்ய லக்ஷ்ம த³ர்ஸி²ஷ்யதே, ததோ நிஜபராக்ரமேண மஹாதேஜஸா ச மேகா⁴ரூட⁴ம்ʼ மநுஜஸுதம்ʼ நப⁴ஸாக³ச்ச²ந்தம்ʼ விலோக்ய ப்ருʼதி²வ்யா​: ஸர்வ்வவம்ʼஸீ²யா விலபிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ததா³நீம்ʼ ஸ மஹாஸ²ப்³தா³யமாநதூர்ய்யா வாத³காந் நிஜதூ³தாந் ப்ரஹேஷ்யதி, தே வ்யோம்ந ஏகஸீமாதோ(அ)பரஸீமாம்ʼ யாவத் சதுர்தி³ஸ²ஸ்தஸ்ய மநோநீதஜநாந் ஆநீய மேலயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","உடு³ம்ப³ரபாத³பஸ்ய த்³ருʼஷ்டாந்தம்ʼ ஸி²க்ஷத்⁴வம்ʼ; யதா³ தஸ்ய நவீநா​: ஸா²கா² ஜாயந்தே, பல்லவாதி³ஸ்²ச நிர்க³ச்ச²தி, ததா³ நிதா³க⁴கால​: ஸவிதோ⁴ ப⁴வதீதி யூயம்ʼ ஜாநீத²; ");
INSERT INTO santam_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","தத்³வத்³ ஏதா க⁴டநா த்³ருʼஷ்ட்வா ஸ ஸமயோ த்³வார உபாஸ்தா²த்³ இதி ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","யுஷ்மாநஹம்ʼ தத்²யம்ʼ வதா³மி, இதா³நீந்தநஜநாநாம்ʼ க³மநாத் பூர்வ்வமேவ தாநி ஸர்வ்வாணி க⁴டிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","நபோ⁴மேதி³ந்யோ ர்லுப்தயோரபி மம வாக் கதா³பி ந லோப்ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","அபரம்ʼ மம தாதம்ʼ விநா மாநுஷ​: ஸ்வர்க³ஸ்தோ² தூ³தோ வா கோபி தத்³தி³நம்ʼ தத்³த³ண்ட³ஞ்ச ந ஜ்ஞாபயதி| ");
INSERT INTO santam_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","அபரம்ʼ நோஹே வித்³யமாநே யாத்³ருʼஸ²மப⁴வத் தாத்³ருʼஸ²ம்ʼ மநுஜஸுதஸ்யாக³மநகாலேபி ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ப²லதோ ஜலாப்லாவநாத் பூர்வ்வம்ʼ யத்³தி³நம்ʼ யாவத் நோஹ​: போதம்ʼ நாரோஹத், தாவத்காலம்ʼ யதா² மநுஷ்யா போ⁴ஜநே பாநே விவஹநே விவாஹநே ச ப்ரவ்ருʼத்தா ஆஸந்; ");
INSERT INTO santam_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","அபரம் ஆப்லாவிதோயமாக³த்ய யாவத் ஸகலமநுஜாந் ப்லாவயித்வா நாநயத், தாவத் தே யதா² ந விதா³மாஸு​:, ததா² மநுஜஸுதாக³மநேபி ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ததா³ க்ஷேத்ரஸ்தி²தயோர்த்³வயோரேகோ தா⁴ரிஷ்யதே, அபரஸ்த்யாஜிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ததா² பேஷண்யா பிம்ʼஷத்யோருப⁴யோ ர்யோஷிதோரேகா தா⁴ரிஷ்யதே(அ)பரா த்யாஜிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","யுஷ்மாகம்ʼ ப்ரபு⁴​: கஸ்மிந் த³ண்ட³ ஆக³மிஷ்யதி, தத்³ யுஷ்மாபி⁴ ர்நாவக³ம்யதே, தஸ்மாத் ஜாக்³ரத​: ஸந்தஸ்திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","குத்ர யாமே ஸ்தேந ஆக³மிஷ்யதீதி சேத்³ க்³ருʼஹஸ்தோ² ஜ்ஞாதும் அஸ²க்ஷ்யத், தர்ஹி ஜாக³ரித்வா தம்ʼ ஸந்தி⁴ம்ʼ கர்த்திதும் அவாரயிஷ்யத் தத்³ ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","யுஷ்மாபி⁴ரவதீ⁴யதாம்ʼ, யதோ யுஷ்மாபி⁴ ர்யத்ர ந பு³த்⁴யதே, தத்ரைவ த³ண்டே³ மநுஜஸுத ஆயாஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ப்ரபு⁴ ர்நிஜபரிவாராந் யதா²காலம்ʼ போ⁴ஜயிதும்ʼ யம்ʼ தா³ஸம் அத்⁴யக்ஷீக்ருʼத்ய ஸ்தா²பயதி, தாத்³ருʼஸோ² விஸ்²வாஸ்யோ தீ⁴மாந் தா³ஸ​: க​:? ");
INSERT INTO santam_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ப்ரபு⁴ராக³த்ய யம்ʼ தா³ஸம்ʼ ததா²சரந்தம்ʼ வீக்ஷதே, ஸஏவ த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","யுஷ்மாநஹம்ʼ ஸத்யம்ʼ வதா³மி, ஸ தம்ʼ நிஜஸர்வ்வஸ்வஸ்யாதி⁴பம்ʼ கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","கிந்து ப்ரபு⁴ராக³ந்தும்ʼ விலம்ப³த இதி மநஸி சிந்தயித்வா யோ து³ஷ்டோ தா³ஸோ ");
INSERT INTO santam_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","(அ)பரதா³ஸாந் ப்ரஹர்த்தும்ʼ மத்தாநாம்ʼ ஸங்கே³ போ⁴க்தும்ʼ பாதுஞ்ச ப்ரவர்த்ததே, ");
INSERT INTO santam_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ஸ தா³ஸோ யதா³ நாபேக்ஷதே, யஞ்ச த³ண்ட³ம்ʼ ந ஜாநாதி, தத்காலஏவ தத்ப்ரபு⁴ருபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ததா³ தம்ʼ த³ண்ட³யித்வா யத்ர ஸ்தா²நே ரோத³நம்ʼ த³ந்தக⁴ர்ஷணஞ்சாஸாதே, தத்ர கபடிபி⁴​: ஸாகம்ʼ தத்³த³ஸா²ம்ʼ நிரூபயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","யா த³ஸ² கந்யா​: ப்ரதீ³பாந் க்³ருʼஹ்லத்யோ வரம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ ப³ஹிரிதா​:, தாபி⁴ஸ்ததா³ ஸ்வர்கீ³யராஜ்யஸ்ய ஸாத்³ருʼஸ்²யம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","தாஸாம்ʼ கந்யாநாம்ʼ மத்⁴யே பஞ்ச ஸுதி⁴ய​: பஞ்ச து³ர்தி⁴ய ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","யா து³ர்தி⁴யஸ்தா​: ப்ரதீ³பாந் ஸங்கே³ க்³ருʼஹீத்வா தைலம்ʼ ந ஜக்³ருʼஹு​:, ");
INSERT INTO santam_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","கிந்து ஸுதி⁴ய​: ப்ரதீ³பாந் பாத்ரேண தைலஞ்ச ஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","அநந்தரம்ʼ வரே விலம்பி³தே தா​: ஸர்வ்வா நித்³ராவிஷ்டா நித்³ராம்ʼ ஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","அநந்தரம் அர்த்³த⁴ராத்ரே பஸ்²யத வர ஆக³ச்ச²தி, தம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ ப³ஹிர்யாதேதி ஜநரவாத் ");
INSERT INTO santam_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","தா​: ஸர்வ்வா​: கந்யா உத்தா²ய ப்ரதீ³பாந் ஆஸாத³யிதும்ʼ ஆரப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ததோ து³ர்தி⁴ய​: ஸுதி⁴ய ஊசு​:, கிஞ்சித் தைலம்ʼ த³த்த, ப்ரதீ³பா அஸ்மாகம்ʼ நிர்வ்வாணா​:| ");
INSERT INTO santam_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","கிந்து ஸுதி⁴ய​: ப்ரத்யவத³ந், த³த்தே யுஷ்மாநஸ்மாம்ʼஸ்²ச ப்ரதி தைலம்ʼ ந்யூநீப⁴வேத், தஸ்மாத்³ விக்ரேத்ருʼணாம்ʼ ஸமீபம்ʼ க³த்வா ஸ்வார்த²ம்ʼ தைலம்ʼ க்ரீணீத| ");
INSERT INTO santam_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ததா³ தாஸு க்ரேதும்ʼ க³தாஸு வர ஆஜகா³ம, ததோ யா​: ஸஜ்ஜிதா ஆஸந், தாஸ்தேந ஸாகம்ʼ விவாஹீயம்ʼ வேஸ்²ம ப்ரவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","அநந்தரம்ʼ த்³வாரே ருத்³தே⁴ அபரா​: கந்யா ஆக³த்ய ஜக³து³​:, ஹே ப்ரபோ⁴, ஹே ப்ரபோ⁴, அஸ்மாந் ப்ரதி த்³வாரம்ʼ மோசய| ");
INSERT INTO santam_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","கிந்து ஸ உக்தவாந், தத்²யம்ʼ வதா³மி, யுஷ்மாநஹம்ʼ ந வேத்³மி| ");
INSERT INTO santam_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","அதோ ஜாக்³ரத​: ஸந்தஸ்திஷ்ட²த, மநுஜஸுத​: கஸ்மிந் தி³நே கஸ்மிந் த³ண்டே³ வாக³மிஷ்யதி, தத்³ யுஷ்மாபி⁴ ர்ந ஜ்ஞாயதே| ");
INSERT INTO santam_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","அபரம்ʼ ஸ ஏதாத்³ருʼஸ²​: கஸ்யசித் பும்ʼஸஸ்துல்ய​:, யோ தூ³ரதே³ஸ²ம்ʼ ப்ரதி யாத்ராகாலே நிஜதா³ஸாந் ஆஹூய தேஷாம்ʼ ஸ்வஸ்வஸாமர்த்²யாநுரூபம் ");
INSERT INTO santam_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ஏகஸ்மிந் முத்³ராணாம்ʼ பஞ்ச போடலிகா​: அந்யஸ்மிம்ʼஸ்²ச த்³வே போடலிகே அபரஸ்மிம்ʼஸ்²ச போடலிகைகாம் இத்த²ம்ʼ ப்ரதிஜநம்ʼ ஸமர்ப்ய ஸ்வயம்ʼ ப்ரவாஸம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","அநந்தரம்ʼ யோ தா³ஸ​: பஞ்ச போடலிகா​: லப்³த⁴வாந், ஸ க³த்வா வாணிஜ்யம்ʼ விதா⁴ய தா த்³விகு³ணீசகார| ");
INSERT INTO santam_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","யஸ்²ச தா³ஸோ த்³வே போடலிகே அலப⁴த, ஸோபி தா முத்³ரா த்³விகு³ணீசகார| ");
INSERT INTO santam_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","கிந்து யோ தா³ஸ ஏகாம்ʼ போடலிகாம்ʼ லப்³த⁴வாந், ஸ க³த்வா பூ⁴மிம்ʼ க²நித்வா தந்மத்⁴யே நிஜப்ரபோ⁴ஸ்தா முத்³ரா கோ³பயாஞ்சகார| ");
INSERT INTO santam_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","தத³நந்தரம்ʼ ப³ஹுதிதே² காலே க³தே தேஷாம்ʼ தா³ஸாநாம்ʼ ப்ரபு⁴ராக³த்ய தைர்தா³ஸை​: ஸமம்ʼ க³ணயாஞ்சகார| ");
INSERT INTO santam_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ததா³நீம்ʼ ய​: பஞ்ச போடலிகா​: ப்ராப்தவாந் ஸ தா த்³விகு³ணீக்ருʼதமுத்³ரா ஆநீய ஜகா³த³; ஹே ப்ரபோ⁴, ப⁴வதா மயி பஞ்ச போடலிகா​: ஸமர்பிதா​:, பஸ்²யது, தா மயா த்³விகு³ணீக்ருʼதா​:| ");
INSERT INTO santam_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ததா³நீம்ʼ தஸ்ய ப்ரபு⁴ஸ்தமுவாச, ஹே உத்தம விஸ்²வாஸ்ய தா³ஸ, த்வம்ʼ த⁴ந்யோஸி, ஸ்தோகேந விஸ்²வாஸ்யோ ஜாத​:, தஸ்மாத் த்வாம்ʼ ப³ஹுவித்தாதி⁴பம்ʼ கரோமி, த்வம்ʼ ஸ்வப்ரபோ⁴​: ஸுக²ஸ்ய பா⁴கீ³ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ததோ யேந த்³வே போடலிகே லப்³தே⁴ ஸோப்யாக³த்ய ஜகா³த³, ஹே ப்ரபோ⁴, ப⁴வதா மயி த்³வே போடலிகே ஸமர்பிதே, பஸ்²யது தே மயா த்³விகு³ணீக்ருʼதே| ");
INSERT INTO santam_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","தேந தஸ்ய ப்ரபு⁴ஸ்தமவோசத், ஹே உத்தம விஸ்²வாஸ்ய தா³ஸ, த்வம்ʼ த⁴ந்யோஸி, ஸ்தோகேந விஸ்²வாஸ்யோ ஜாத​:, தஸ்மாத் த்வாம்ʼ ப³ஹுத்³ரவிணாதி⁴பம்ʼ கரோமி, த்வம்ʼ நிஜப்ரபோ⁴​: ஸுக²ஸ்ய பா⁴கீ³ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","அநந்தரம்ʼ ய ஏகாம்ʼ போடலிகாம்ʼ லப்³த⁴வாந், ஸ ஏத்ய கதி²தவாந், ஹே ப்ரபோ⁴, த்வாம்ʼ கடி²நநரம்ʼ ஜ்ஞாதவாந், த்வயா யத்ர நோப்தம்ʼ, தத்ரைவ க்ருʼத்யதே, யத்ர ச ந கீர்ணம்ʼ, தத்ரைவ ஸம்ʼக்³ருʼஹ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","அதோஹம்ʼ ஸஸ²ங்க​: ஸந் க³த்வா தவ முத்³ரா பூ⁴மத்⁴யே ஸம்ʼகோ³ப்ய ஸ்தா²பிதவாந், பஸ்²ய, தவ யத் ததே³வ க்³ருʼஹாண| ");
INSERT INTO santam_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ததா³ தஸ்ய ப்ரபு⁴​: ப்ரத்யவத³த் ரே து³ஷ்டாலஸ தா³ஸ, யத்ராஹம்ʼ ந வபாமி, தத்ர சி²நத்³மி, யத்ர ச ந கிராமி, தத்ரேவ ஸம்ʼக்³ருʼஹ்லாமீதி சேத³ஜாநாஸ்தர்ஹி ");
INSERT INTO santam_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","வணிக்ஷு மம வித்தார்பணம்ʼ தவோசிதமாஸீத், யேநாஹமாக³த்ய வ்ருʼத்³வ்யா ஸாகம்ʼ மூலமுத்³ரா​: ப்ராப்ஸ்யம்| ");
INSERT INTO santam_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","அதோஸ்மாத் தாம்ʼ போடலிகாம் ஆதா³ய யஸ்ய த³ஸ² போடலிகா​: ஸந்தி தஸ்மிந்நர்பயத| ");
INSERT INTO santam_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","யேந வர்த்³வ்யதே தஸ்மிந்நைவார்பிஷ்யதே, தஸ்யைவ ச பா³ஹுல்யம்ʼ ப⁴விஷ்யதி, கிந்து யேந ந வர்த்³வ்யதே, தஸ்யாந்திகே யத் கிஞ்சந திஷ்ட²தி, தத³பி புநர்நேஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","அபரம்ʼ யூயம்ʼ தமகர்ம்மண்யம்ʼ தா³ஸம்ʼ நீத்வா யத்ர ஸ்தா²நே க்ரந்த³நம்ʼ த³ந்தக⁴ர்ஷணஞ்ச வித்³யேதே, தஸ்மிந் ப³ஹிர்பூ⁴ததமஸி நிக்ஷிபத| ");
INSERT INTO santam_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","யதா³ மநுஜஸுத​: பவித்ரதூ³தாந் ஸங்கி³ந​: க்ருʼத்வா நிஜப்ரபா⁴வேநாக³த்ய நிஜதேஜோமயே ஸிம்ʼஹாஸநே நிவேக்ஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ததா³ தத்ஸம்முகே² ஸர்வ்வஜாதீயா ஜநா ஸம்ʼமேலிஷ்யந்தி| ததோ மேஷபாலகோ யதா² சா²கே³ப்⁴யோ(அ)வீந் ப்ருʼத²க் கரோதி ததா² ஸோப்யேகஸ்மாத³ந்யம் இத்த²ம்ʼ தாந் ப்ருʼத²க க்ருʼத்வாவீந் ");
INSERT INTO santam_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","த³க்ஷிணே சா²கா³ம்ʼஸ்²ச வாமே ஸ்தா²பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","தத​: பரம்ʼ ராஜா த³க்ஷிணஸ்தி²தாந் மாநவாந் வதி³ஷ்யதி, ஆக³ச்ச²த மத்தாதஸ்யாநுக்³ரஹபா⁴ஜநாநி, யுஷ்மத்க்ருʼத ஆ ஜக³தா³ரம்ப⁴த் யத்³ ராஜ்யம் ஆஸாதி³தம்ʼ தத³தி⁴குருத| ");
INSERT INTO santam_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","யதோ பு³பு⁴க்ஷிதாய மஹ்யம்ʼ போ⁴ஜ்யம் அத³த்த, பிபாஸிதாய பேயமத³த்த, விதே³ஸி²நம்ʼ மாம்ʼ ஸ்வஸ்தா²நமநயத, ");
INSERT INTO santam_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","வஸ்த்ரஹீநம்ʼ மாம்ʼ வஸநம்ʼ பர்ய்யதா⁴பயத, பீடீ³தம்ʼ மாம்ʼ த்³ரஷ்டுமாக³ச்ச²த, காராஸ்த²ஞ்ச மாம்ʼ வீக்ஷிதும ஆக³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ததா³ தா⁴ர்ம்மிகா​: ப்ரதிவதி³ஷ்யந்தி, ஹே ப்ரபோ⁴, கதா³ த்வாம்ʼ க்ஷுதி⁴தம்ʼ வீக்ஷ்ய வயமபோ⁴ஜயாம? வா பிபாஸிதம்ʼ வீக்ஷ்ய அபாயயாம? ");
INSERT INTO santam_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","கதா³ வா த்வாம்ʼ விதே³ஸி²நம்ʼ விலோக்ய ஸ்வஸ்தா²நமநயாம? கதா³ வா த்வாம்ʼ நக்³நம்ʼ வீக்ஷ்ய வஸநம்ʼ பர்ய்யதா⁴பயாம? ");
INSERT INTO santam_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","கதா³ வா த்வாம்ʼ பீடி³தம்ʼ காராஸ்த²ஞ்ச வீக்ஷ்ய த்வத³ந்திகமக³ச்சா²ம? ");
INSERT INTO santam_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ததா³நீம்ʼ ராஜா தாந் ப்ரதிவதி³ஷ்யதி, யுஷ்மாநஹம்ʼ ஸத்யம்ʼ வதா³மி, மமைதேஷாம்ʼ ப்⁴ராத்ருʼணாம்ʼ மத்⁴யே கஞ்சநைகம்ʼ க்ஷுத்³ரதமம்ʼ ப்ரதி யத்³ அகுருத, தந்மாம்ʼ ப்ரத்யகுருத| ");
INSERT INTO santam_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","பஸ்²சாத் ஸ வாமஸ்தி²தாந் ஜநாந் வதி³ஷ்யதி, ரே ஸா²பக்³ரஸ்தா​: ஸர்வ்வே, ஸை²தாநே தஸ்ய தூ³தேப்⁴யஸ்²ச யோ(அ)நந்தவஹ்நிராஸாதி³த ஆஸ்தே, யூயம்ʼ மத³ந்திகாத் தமக்³நிம்ʼ க³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","யதோ க்ஷுதி⁴தாய மஹ்யமாஹாரம்ʼ நாத³த்த, பிபாஸிதாய மஹ்யம்ʼ பேயம்ʼ நாத³த்த, ");
INSERT INTO santam_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","விதே³ஸி²நம்ʼ மாம்ʼ ஸ்வஸ்தா²நம்ʼ நாநயத, வஸநஹீநம்ʼ மாம்ʼ வஸநம்ʼ ந பர்ய்யதா⁴பயத, பீடி³தம்ʼ காராஸ்த²ஞ்ச மாம்ʼ வீக்ஷிதும்ʼ நாக³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ததா³ தே ப்ரதிவதி³ஷ்யந்தி, ஹே ப்ரபோ⁴, கதா³ த்வாம்ʼ க்ஷுதி⁴தம்ʼ வா பிபாஸிதம்ʼ வா விதே³ஸி²நம்ʼ வா நக்³நம்ʼ வா பீடி³தம்ʼ வா காராஸ்த²ம்ʼ வீக்ஷ்ய த்வாம்ʼ நாஸேவாமஹி? ");
INSERT INTO santam_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ததா³ ஸ தாந் வதி³ஷ்யதி, தத்²யமஹம்ʼ யுஷ்மாந் ப்³ரவீமி, யுஷ்மாபி⁴ரேஷாம்ʼ கஞ்சந க்ஷோதி³ஷ்ட²ம்ʼ ப்ரதி யந்நாகாரி, தந்மாம்ʼ ப்ரத்யேவ நாகாரி| ");
INSERT INTO santam_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","பஸ்²சாத³ம்யநந்தஸா²ஸ்திம்ʼ கிந்து தா⁴ர்ம்மிகா அநந்தாயுஷம்ʼ போ⁴க்தும்ʼ யாஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","யீஸு²ரேதாந் ப்ரஸ்தாவாந் ஸமாப்ய ஸி²ஷ்யாநூசே, ");
INSERT INTO santam_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","யுஷ்மாபி⁴ ர்ஜ்ஞாதம்ʼ தி³நத்³வயாத் பரம்ʼ நிஸ்தாரமஹ உபஸ்தா²ஸ்யதி, தத்ர மநுஜஸுத​: க்ருஸே²ந ஹந்தும்ʼ பரகரேஷு ஸமர்பிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","தத​: பரம்ʼ ப்ரதா⁴நயாஜகாத்⁴யாபகப்ராஞ்ச​: கியபா²நாம்நோ மஹாயாஜகஸ்யாட்டாலிகாயாம்ʼ மிலித்வா ");
INSERT INTO santam_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","கேநோபாயேந யீஸு²ம்ʼ த்⁴ருʼத்வா ஹந்தும்ʼ ஸ²க்நுயுரிதி மந்த்ரயாஞ்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","கிந்து தைருக்தம்ʼ மஹகாலே ந த⁴ர்த்தவ்ய​:, த்⁴ருʼதே ப்ரஜாநாம்ʼ கலஹேந ப⁴விதும்ʼ ஸ²க்யதே| ");
INSERT INTO santam_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ததோ பை³த²நியாபுரே ஸி²மோநாக்²யஸ்ய குஷ்டி²நோ வேஸ்²மநி யீஸௌ² திஷ்ட²தி ");
INSERT INTO santam_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","காசந யோஷா ஸ்²வேதோபலபா⁴ஜநேந மஹார்க்⁴யம்ʼ ஸுக³ந்தி⁴ தைலமாநீய போ⁴ஜநாயோபவிஸ²தஸ்தஸ்ய ஸி²ரோப்⁴யஷேசத்| ");
INSERT INTO santam_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","கிந்து ததா³லோக்ய தச்சி²ஷ்யை​: குபிதைருக்தம்ʼ, குத இத்த²மபவ்யயதே? ");
INSERT INTO santam_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","சேதி³த³ம்ʼ வ்யக்ரேஷ்யத, தர்ஹி பூ⁴ரிமூல்யம்ʼ ப்ராப்ய த³ரித்³ரேப்⁴யோ வ்யதாரிஷ்யத| ");
INSERT INTO santam_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","யீஸு²நா தத³வக³த்ய தே ஸமுதி³தா​:, யோஷாமேநாம்ʼ குதோ து³​:கி²நீம்ʼ குருத², ஸா மாம்ʼ ப்ரதி ஸாது⁴ கர்ம்மாகார்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","யுஷ்மாகமம்ʼ ஸமீபே த³ரித்³ரா​: ஸததமேவாஸதே, கிந்து யுஷ்மாகமந்திகேஹம்ʼ நாஸே ஸததம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ஸா மம காயோபரி ஸுக³ந்தி⁴தைலம்ʼ ஸிக்த்வா மம ஸ்²மஸா²நதா³நகர்ம்மாகார்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","அதோஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி ஸர்வ்வஸ்மிந் ஜக³தி யத்ர யத்ரைஷ ஸுஸமாசார​: ப்ரசாரிஷ்யதே, தத்ர தத்ரைதஸ்யா நார்ய்யா​: ஸ்மரணார்த²ம் கர்ம்மேத³ம்ʼ ப்ரசாரிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ததோ த்³வாத³ஸ²ஸி²ஷ்யாணாம் ஈஷ்கரியோதீயயிஹூதா³நாமக ஏக​: ஸி²ஷ்ய​: ப்ரதா⁴நயாஜகாநாமந்திகம்ʼ க³த்வா கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","யதி³ யுஷ்மாகம்ʼ கரேஷு யீஸு²ம்ʼ ஸமர்பயாமி, தர்ஹி கிம்ʼ தா³ஸ்யத²? ததா³நீம்ʼ தே தஸ்மை த்ரிம்ʼஸ²ந்முத்³ரா தா³தும்ʼ ஸ்தி²ரீக்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ஸ ததா³ரப்⁴ய தம்ʼ பரகரேஷு ஸமர்பயிதும்ʼ ஸுயோக³ம்ʼ சேஷ்டிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","அநந்தரம்ʼ கிண்வஸூ²ந்யபூபபர்வ்வண​: ப்ரத²மேஹ்நி ஸி²ஷ்யா யீஸு²ம் உபக³த்ய பப்ரச்சு²​: ப⁴வத்க்ருʼதே குத்ர வயம்ʼ நிஸ்தாரமஹபோ⁴ஜ்யம் ஆயோஜயிஷ்யாம​:? ப⁴வத​: கேச்சா²? ");
INSERT INTO santam_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ததா³ ஸ க³தி³தவாந், மத்⁴யேநக³ரமமுகபும்ʼஸ​: ஸமீபம்ʼ வ்ரஜித்வா வத³த, கு³ரு ர்க³தி³தவாந், மத்கால​: ஸவித⁴​:, ஸஹ ஸி²ஷ்யைஸ்த்வதா³லயே நிஸ்தாரமஹபோ⁴ஜ்யம்ʼ போ⁴க்ஷ்யே| ");
INSERT INTO santam_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ததா³ ஸி²ஷ்யா யீஸோ²ஸ்தாத்³ருʼஸ²நிதே³ஸா²நுரூபகர்ம்ம விதா⁴ய தத்ர நிஸ்தாரமஹபோ⁴ஜ்யமாஸாத³யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","தத​: ஸந்த்⁴யாயாம்ʼ ஸத்யாம்ʼ த்³வாத³ஸ²பி⁴​: ஸி²ஷ்யை​: ஸாகம்ʼ ஸ ந்யவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","அபரம்ʼ பு⁴ஞ்ஜாந உக்தவாந் யுஷ்மாந் தத்²யம்ʼ வதா³மி, யுஷ்மாகமேகோ மாம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ததா³ தே(அ)தீவ து³​:கி²தா ஏகைகஸோ² வக்துமாரேபி⁴ரே, ஹே ப்ரபோ⁴, ஸ கிமஹம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","தத​: ஸ ஜகா³த³, மயா ஸாகம்ʼ யோ ஜநோ போ⁴ஜநபாத்ரே கரம்ʼ ஸம்ʼக்ஷிபதி, ஸ ஏவ மாம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","மநுஜஸுதமதி⁴ யாத்³ருʼஸ²ம்ʼ லிகி²தமாஸ்தே, தத³நுரூபா தத்³க³தி ர்ப⁴விஷ்யதி; கிந்து யேந பும்ʼஸா ஸ பரகரேஷு ஸமர்பயிஷ்யதே, ஹா ஹா சேத் ஸ நாஜநிஷ்யத, ததா³ தஸ்ய க்ஷேமமப⁴விஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ததா³ யிஹூதா³நாமா யோ ஜநஸ்தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி, ஸ உக்தவாந், ஹே கு³ரோ, ஸ கிமஹம்ʼ? தத​: ஸ ப்ரத்யுக்தவாந், த்வயா ஸத்யம்ʼ க³தி³தம்| ");
INSERT INTO santam_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","அநந்தரம்ʼ தேஷாமஸ²நகாலே யீஸு²​: பூபமாதா³யேஸ்²வரீயகு³ணாநநூத்³ய ப⁴ம்ʼக்த்வா ஸி²ஷ்யேப்⁴ய​: ப்ரதா³ய ஜகா³த³, மத்³வபு​:ஸ்வரூபமிமம்ʼ க்³ருʼஹீத்வா கா²த³த| ");
INSERT INTO santam_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","பஸ்²சாத் ஸ கம்ʼஸம்ʼ க்³ருʼஹ்லந் ஈஸ்²வரீயகு³ணாநநூத்³ய தேப்⁴ய​: ப்ரதா³ய கதி²தவாந், ஸர்வ்வை ர்யுஷ்மாபி⁴ரநேந பாதவ்யம்ʼ, ");
INSERT INTO santam_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","யஸ்மாத³நேகேஷாம்ʼ பாபமர்ஷணாய பாதிதம்ʼ யந்மந்நூத்நநியமரூபஸோ²ணிதம்ʼ ததே³தத்| ");
INSERT INTO santam_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","அபரமஹம்ʼ நூத்நகோ³ஸ்தநீரஸம்ʼ ந பாஸ்யாமி, தாவத் கோ³ஸ்தநீப²லரஸம்ʼ புந​: கதா³பி ந பாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","பஸ்²சாத் தே கீ³தமேகம்ʼ ஸம்ʼகீ³ய ஜைதுநாக்²யகி³ரிம்ʼ க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ததா³நீம்ʼ யீஸு²ஸ்தாநவோசத், அஸ்யாம்ʼ ரஜந்யாமஹம்ʼ யுஷ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ விக்⁴நரூபோ ப⁴விஷ்யாமி, யதோ லிகி²தமாஸ்தே, \"மேஷாணாம்ʼ ரக்ஷகோ யஸ்தம்ʼ ப்ரஹரிஷ்யாம்யஹம்ʼ தத​:| மேஷாணாம்ʼ நிவஹோ நூநம்ʼ ப்ரவிகீர்ணோ ப⁴விஷ்யதி\"|| ");
INSERT INTO santam_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","கிந்து ஸ்²மஸா²நாத் ஸமுத்தா²ய யுஷ்மாகமக்³ரே(அ)ஹம்ʼ கா³லீலம்ʼ க³மிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","பிதரஸ்தம்ʼ ப்ரோவாச, ப⁴வாம்ʼஸ்²சேத் ஸர்வ்வேஷாம்ʼ விக்⁴நரூபோ ப⁴வதி, ததா²பி மம ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ததோ யீஸு²நா ஸ உக்த​:, துப்⁴யமஹம்ʼ தத்²யம்ʼ கத²யாமி, யாமிந்யாமஸ்யாம்ʼ சரணாயுத⁴ஸ்ய ரவாத் பூர்வ்வம்ʼ த்வம்ʼ மாம்ʼ த்ரி ர்நாங்கீ³கரிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","தத​: பிதர உதி³தவாந், யத்³யபி த்வயா ஸமம்ʼ மர்த்தவ்யம்ʼ, ததா²பி கதா³பி த்வாம்ʼ ந நாங்கீ³கரிஷ்யாமி; ததை²வ ஸர்வ்வே ஸி²ஷ்யாஸ்²சோசு​:| ");
INSERT INTO santam_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","அநந்தரம்ʼ யீஸு²​: ஸி²ஷ்யை​: ஸாகம்ʼ கே³த்ஸி²மாநீநாமகம்ʼ ஸ்தா²நம்ʼ ப்ரஸ்தா²ய தேப்⁴ய​: கதி²தவாந், அத³​: ஸ்தா²நம்ʼ க³த்வா யாவத³ஹம்ʼ ப்ரார்த²யிஷ்யே தாவத்³ யூயமத்ரோபவிஸ²த| ");
INSERT INTO santam_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","பஸ்²சாத் ஸ பிதரம்ʼ ஸிவதி³யஸுதௌ ச ஸங்கி³ந​: க்ருʼத்வா க³தவாந், ஸோ²காகுலோ(அ)தீவ வ்யதி²தஸ்²ச ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","தாநவாதீ³ச்ச ம்ருʼதியாதநேவ மத்ப்ராணாநாம்ʼ யாதநா ஜாயதே, யூயமத்ர மயா ஸார்த்³த⁴ம்ʼ ஜாக்³ருʼத| ");
INSERT INTO santam_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","தத​: ஸ கிஞ்சித்³தூ³ரம்ʼ க³த்வாதோ⁴முக²​: பதந் ப்ரார்த²யாஞ்சக்ரே, ஹே மத்பிதர்யதி³ ப⁴விதும்ʼ ஸ²க்நோதி, தர்ஹி கம்ʼஸோ(அ)யம்ʼ மத்தோ தூ³ரம்ʼ யாது; கிந்து மதி³ச்சா²வத் ந ப⁴வது, த்வதி³ச்சா²வத்³ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","தத​: ஸ ஸி²ஷ்யாநுபேத்ய தாந் நித்³ரதோ நிரீக்ஷ்ய பிதராய கத²யாமாஸ, யூயம்ʼ மயா ஸாகம்ʼ த³ண்ட³மேகமபி ஜாக³ரிதும்ʼ நாஸ²ந்குத? ");
INSERT INTO santam_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","பரீக்ஷாயாம்ʼ ந பதிதும்ʼ ஜாக்³ருʼத ப்ரார்த²யத்⁴வஞ்ச; ஆத்மா ஸமுத்³யதோஸ்தி, கிந்து வபு ர்து³ர்ப்³ப³லம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ஸ த்³விதீயவாரம்ʼ ப்ரார்த²யாஞ்சக்ரே, ஹே மத்தாத, ந பீதே யதி³ கம்ʼஸமித³ம்ʼ மத்தோ தூ³ரம்ʼ யாதும்ʼ ந ஸ²க்நோதி, தர்ஹி த்வதி³ச்சா²வத்³ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ஸ புநரேத்ய தாந் நித்³ரதோ த³த³ர்ஸ², யதஸ்தேஷாம்ʼ நேத்ராணி நித்³ரயா பூர்ணாந்யாஸந்| ");
INSERT INTO santam_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","பஸ்²சாத் ஸ தாந் விஹாய வ்ரஜித்வா த்ருʼதீயவாரம்ʼ பூர்வ்வவத் கத²யந் ப்ரார்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","தத​: ஸி²ஷ்யாநுபாக³த்ய க³தி³தவாந், ஸாம்ப்ரதம்ʼ ஸ²யாநா​: கிம்ʼ விஸ்²ராம்யத²? பஸ்²யத, ஸமய உபாஸ்தா²த், மநுஜஸுத​: பாபிநாம்ʼ கரேஷு ஸமர்ப்யதே| ");
INSERT INTO santam_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","உத்திஷ்ட²த, வயம்ʼ யாம​:, யோ மாம்ʼ பரகரேஷு மஸர்பயிஷ்யதி, பஸ்²யத, ஸ ஸமீபமாயாதி| ");
INSERT INTO santam_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ஏதத்கதா²கத²நகாலே த்³வாத³ஸ²ஸி²ஷ்யாணாமேகோ யிஹூதா³நாமகோ முக்²யயாஜகலோகப்ராசீநை​: ப்ரஹிதாந் அஸிதா⁴ரியஷ்டிதா⁴ரிணோ மநுஜாந் க்³ருʼஹீத்வா தத்ஸமீபமுபதஸ்தௌ²| ");
INSERT INTO santam_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","அஸௌ பரகரேஷ்வர்பயிதா பூர்வ்வம்ʼ தாந் இத்த²ம்ʼ ஸங்கேதயாமாஸ, யமஹம்ʼ சும்பி³ஷ்யே, ஸோ(அ)ஸௌ மநுஜ​:,ஸஏவ யுஷ்மாபி⁴ ர்தா⁴ர்ய்யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ததா³ ஸ ஸபதி³ யீஸு²முபாக³த்ய ஹே கு³ரோ, ப்ரணமாமீத்யுக்த்வா தம்ʼ சுசும்பே³| ");
INSERT INTO santam_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ததா³ யீஸு²ஸ்தமுவாச, ஹே மித்ரம்ʼ கிமர்த²மாக³தோஸி? ததா³ தைராக³த்ய யீஸு²ராக்ரம்ய த³க்⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ததோ யீஸோ²​: ஸங்கி³நாமேக​: கரம்ʼ ப்ரஸார்ய்ய கோஷாத³ஸிம்ʼ ப³ஹிஷ்க்ருʼத்ய மஹாயாஜகஸ்ய தா³ஸமேகமாஹத்ய தஸ்ய கர்ணம்ʼ சிச்சே²த³| ");
INSERT INTO santam_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ததோ யீஸு²ஸ்தம்ʼ ஜகா³த³, க²ட்³க³ம்ʼ ஸ்வஸ்தா²நேे நிதே⁴ஹி யதோ யே யே ஜநா அஸிம்ʼ தா⁴ரயந்தி, தஏவாஸிநா விநஸ்²யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","அபரம்ʼ பிதா யதா² மத³ந்திகம்ʼ ஸ்வர்கீ³யதூ³தாநாம்ʼ த்³வாத³ஸ²வாஹிநீதோ(அ)தி⁴கம்ʼ ப்ரஹிணுயாத் மயா தமுத்³தி³ஸ்²யேதா³நீமேவ ததா² ப்ரார்த²யிதும்ʼ ந ஸ²க்யதே, த்வயா கிமித்த²ம்ʼ ஜ்ஞாயதே? ");
INSERT INTO santam_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ததா² ஸதீத்த²ம்ʼ க⁴டிஷ்யதே த⁴ர்ம்மபுஸ்தகஸ்ய யதி³த³ம்ʼ வாக்யம்ʼ தத் கத²ம்ʼ ஸித்⁴யேத்? ");
INSERT INTO santam_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ததா³நீம்ʼ யீஸு² ர்ஜநநிவஹம்ʼ ஜகா³த³, யூயம்ʼ க²ட்³க³யஷ்டீந் ஆதா³ய மாம்ʼ கிம்ʼ சௌரம்ʼ த⁴ர்த்துமாயாதா​:? அஹம்ʼ ப்ரத்யஹம்ʼ யுஷ்மாபி⁴​: ஸாகமுபவிஸ்²ய ஸமுபாதி³ஸ²ம்ʼ, ததா³ மாம்ʼ நாத⁴ரத; ");
INSERT INTO santam_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","கிந்து ப⁴விஷ்யத்³வாதி³நாம்ʼ வாக்யாநாம்ʼ ஸம்ʼஸித்³த⁴யே ஸர்வ்வமேதத³பூ⁴த்| ததா³ ஸர்வ்வே ஸி²ஷ்யாஸ்தம்ʼ விஹாய பலாயந்த| ");
INSERT INTO santam_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","அநந்தரம்ʼ தே மநுஜா யீஸு²ம்ʼ த்⁴ருʼத்வா யத்ராத்⁴யாபகப்ராஞ்ச​: பரிஷத³ம்ʼ குர்வ்வந்த உபாவிஸ²ந் தத்ர கியபா²நாाமகமஹாயாஜகஸ்யாந்திகம்ʼ நிந்யு​:| ");
INSERT INTO santam_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","கிந்து ஸே²ஷே கிம்ʼ ப⁴விஷ்யதீதி வேத்தும்ʼ பிதரோ தூ³ரே தத்பஸ்²சாத்³ வ்ரஜித்வா மஹாயாஜகஸ்யாட்டாலிகாம்ʼ ப்ரவிஸ்²ய தா³ஸை​: ஸஹித உபாவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ததா³நீம்ʼ ப்ரதா⁴நயாஜகப்ராசீநமந்த்ரிண​: ஸர்வ்வே யீஸு²ம்ʼ ஹந்தும்ʼ ம்ருʼஷாஸாக்ஷ்யம் அலிப்ஸந்த, ");
INSERT INTO santam_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","கிந்து ந லேபி⁴ரே| அநேகேஷு ம்ருʼஷாஸாக்ஷிஷ்வாக³தேஷ்வபி தந்ந ப்ராபு​:| ");
INSERT INTO santam_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ஸே²ஷே த்³வௌ ம்ருʼஷாஸாக்ஷிணாவாக³த்ய ஜக³த³து​:, புமாநயமகத²யத், அஹமீஸ்²வரமந்தி³ரம்ʼ ப⁴ம்ʼக்த்வா தி³நத்ரயமத்⁴யே தந்நிர்ம்மாதும்ʼ ஸ²க்நோமி| ");
INSERT INTO santam_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ததா³ மஹாயாஜக உத்தா²ய யீஸு²ம் அவாதீ³த்| த்வம்ʼ கிமபி ந ப்ரதிவத³ஸி? த்வாமதி⁴ கிமேதே ஸாக்ஷ்யம்ʼ வத³ந்தி? ");
INSERT INTO santam_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","கிந்து யீஸு² ர்மௌநீபூ⁴ய தஸ்யௌ| ததோ மஹாயாஜக உக்தவாந், த்வாம் அமரேஸ்²வரநாம்நா ஸ²பயாமி, த்வமீஸ்²வரஸ்ய புத்ரோ(அ)பி⁴ஷிக்தோ ப⁴வஸி நவேதி வத³| ");
INSERT INTO santam_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","யீஸு²​: ப்ரத்யவத³த், த்வம்ʼ ஸத்யமுக்தவாந்; அஹம்ʼ யுஷ்மாந் தத்²யம்ʼ வதா³மி, இத​:பரம்ʼ மநுஜஸுதம்ʼ ஸர்வ்வஸ²க்திமதோ த³க்ஷிணபார்ஸ்²வே ஸ்தா²தும்ʼ க³க³ணஸ்த²ம்ʼ ஜலத⁴ராநாருஹ்யாயாந்தம்ʼ வீக்ஷத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ததா³ மஹாயாஜகோ நிஜவஸநம்ʼ சி²த்த்வா ஜகா³த³, ஏஷ ஈஸ்²வரம்ʼ நிந்தி³தவாந், அஸ்மாகமபரஸாக்ஷ்யேண கிம்ʼ ப்ரயோஜநம்ʼ? பஸ்²யத, யூயமேவாஸ்யாஸ்யாத்³ ஈஸ்²வரநிந்தா³ம்ʼ ஸ்²ருதவந்த​:, ");
INSERT INTO santam_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","யுஷ்மாபி⁴​: கிம்ʼ விவிச்யதே? தே ப்ரத்யூசு​:, வதா⁴ர்ஹோ(அ)யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ததோ லோகைஸ்ததா³ஸ்யே நிஷ்டீ²விதம்ʼ கேசித் ப்ரதலமாஹத்ய கேசிச்ச சபேடமாஹத்ய ப³பா⁴ஷிரே, ");
INSERT INTO santam_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ஹே க்²ரீஷ்ட த்வாம்ʼ கஸ்²சபேடமாஹதவாந்? இதி க³ணயித்வா வதா³ஸ்மாந்| ");
INSERT INTO santam_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","பிதரோ ப³ஹிரங்க³ந உபவிஸ²தி, ததா³நீமேகா தா³ஸீ தமுபாக³த்ய ப³பா⁴ஷே, த்வம்ʼ கா³லீலீயயீஸோ²​: ஸஹசரஏக​:| ");
INSERT INTO santam_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","கிந்து ஸ ஸர்வ்வேஷாம்ʼ ஸமக்ஷம் அநங்கீ³க்ருʼத்யாவாதீ³த், த்வயா யது³ச்யதே, தத³ர்த²மஹம்ʼ ந வேத்³மி| ");
INSERT INTO santam_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ததா³ தஸ்மிந் ப³ஹிர்த்³வாரம்ʼ க³தே (அ)ந்யா தா³ஸீ தம்ʼ நிரீக்ஷ்ய தத்ரத்யஜநாநவத³த், அயமபி நாஸரதீயயீஸு²நா ஸார்த்³த⁴ம் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","தத​: ஸ ஸ²பதே²ந புநரநங்கீ³க்ருʼத்ய கதி²தவாந், தம்ʼ நரம்ʼ ந பரிசிநோமி| ");
INSERT INTO santam_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","க்ஷணாத் பரம்ʼ திஷ்ட²ந்தோ ஜநா ஏத்ய பிதரம் அவத³ந், த்வமவஸ்²யம்ʼ தேஷாமேக இதி த்வது³ச்சாரணமேவ த்³யோதயதி| ");
INSERT INTO santam_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","கிந்து ஸோ(அ)பி⁴ஸ²ப்ய கதி²தவாந், தம்ʼ ஜநம்ʼ நாஹம்ʼ பரிசிநோமி, ததா³ ஸபதி³ குக்குடோ ருராவ| ");
INSERT INTO santam_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","குக்குடரவாத் ப்ராக் த்வம்ʼ மாம்ʼ த்ரிரபாஹ்நோஷ்யஸே, யைஷா வாக்³ யீஸு²நாவாதி³ தாம்ʼ பிதர​: ஸம்ʼஸ்ம்ருʼத்ய ப³ஹிரித்வா கே²தா³த்³ ப்⁴ருʼஸ²ம்ʼ சக்ரந்த³| ");
INSERT INTO santam_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ப்ரபா⁴தே ஜாதே ப்ரதா⁴நயாஜகலோகப்ராசீநா யீஸு²ம்ʼ ஹந்தும்ʼ தத்ப்ரதிகூலம்ʼ மந்த்ரயித்வா ");
INSERT INTO santam_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","தம்ʼ ப³த்³வ்வா நீத்வா பந்தீயபீலாதாக்²யாதி⁴பே ஸமர்பயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ததோ யீஸோ²​: பரகரேவ்வர்பயிதா யிஹூதா³ஸ்தத்ப்ராணாத³ண்டா³ஜ்ஞாம்ʼ விதி³த்வா ஸந்தப்தமநா​: ப்ரதா⁴நயாஜகலோகப்ராசீநாநாம்ʼ ஸமக்ஷம்ʼ தாஸ்த்ரீம்ʼஸ²ந்முத்³ரா​: ப்ரதிதா³யாவாதீ³த், ");
INSERT INTO santam_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ஏதந்நிராகோ³நரப்ராணபரகரார்பணாத் கலுஷம்ʼ க்ருʼதவாநஹம்ʼ| ததா³ த உதி³தவந்த​:, தேநாஸ்மாகம்ʼ கிம்ʼ? த்வயா தத்³ பு³த்⁴யதாம்| ");
INSERT INTO santam_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ததோ யிஹூதா³ மந்தி³ரமத்⁴யே தா முத்³ரா நிக்ஷிப்ய ப்ரஸ்தி²தவாந் இத்வா ச ஸ்வயமாத்மாநமுத்³ப³ப³ந்த⁴| ");
INSERT INTO santam_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","பஸ்²சாத் ப்ரதா⁴நயாஜகாஸ்தா முத்³ரா ஆதா³ய கதி²தவந்த​:, ஏதா முத்³ரா​: ஸோ²ணிதமூல்யம்ʼ தஸ்மாத்³ பா⁴ண்டா³கா³ரே ந நிதா⁴தவ்யா​:| ");
INSERT INTO santam_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","அநந்தரம்ʼ தே மந்த்ரயித்வா விதே³ஸி²நாம்ʼ ஸ்²மஸா²நஸ்தா²நாய தாபி⁴​: குலாலஸ்ய க்ஷேத்ரமக்ரீணந்| ");
INSERT INTO santam_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","அதோ(அ)த்³யாபி தத்ஸ்தா²நம்ʼ ரக்தக்ஷேத்ரம்ʼ வத³ந்தி| ");
INSERT INTO santam_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","இத்த²ம்ʼ ஸதி இஸ்ராயேலீயஸந்தாநை ர்யஸ்ய மூல்யம்ʼ நிருபிதம்ʼ, தஸ்ய த்ரிம்ʼஸ²ந்முத்³ராமாநம்ʼ மூல்யம்ʼ ");
INSERT INTO santam_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","மாம்ʼ ப்ரதி பரமேஸ்²வரஸ்யாதே³ஸா²த் தேப்⁴ய ஆதீ³யத, தேந ச குலாலஸ்ய க்ஷேத்ரம்ʼ க்ரீதமிதி யத்³வசநம்ʼ யிரிமியப⁴விஷ்யத்³வாதி³நா ப்ரோக்தம்ʼ தத் ததா³ஸித்⁴யத்| ");
INSERT INTO santam_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","அநந்தரம்ʼ யீஸௌ² தத³தி⁴பதே​: ஸம்முக² உபதிஷ்ட²தி ஸ தம்ʼ பப்ரச்ச², த்வம்ʼ கிம்ʼ யிஹூதீ³யாநாம்ʼ ராஜா? ததா³ யீஸு²ஸ்தமவத³த், த்வம்ʼ ஸத்யமுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","கிந்து ப்ரதா⁴நயாஜகப்ராசீநைரபி⁴யுக்தேந தேந கிமபி ந ப்ரத்யவாதி³| ");
INSERT INTO santam_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","தத​: பீலாதேந ஸ உதி³த​:, இமே த்வத்ப்ரதிகூலத​: கதி கதி ஸாக்ஷ்யம்ʼ த³த³தி, தத் த்வம்ʼ ந ஸ்²ருʼணோஷி? ");
INSERT INTO santam_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ததா²பி ஸ தேஷாமேகஸ்யாபி வசஸ உத்தரம்ʼ நோதி³தவாந்; தேந ஸோ(அ)தி⁴பதி ர்மஹாசித்ரம்ʼ விதா³மாஸ| ");
INSERT INTO santam_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","அந்யச்ச தந்மஹகாலே(அ)தி⁴பதேரேதாத்³ருʼஸீ² ராதிராஸீத், ப்ரஜா யம்ʼ கஞ்சந ப³ந்தி⁴நம்ʼ யாசந்தே, தமேவ ஸ மோசயதீதி| ");
INSERT INTO santam_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ததா³நீம்ʼ ப³ரப்³பா³நாமா கஸ்²சித் க்²யாதப³ந்த்⁴யாஸீத்| ");
INSERT INTO santam_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","தத​: பீலாதஸ்தத்ர மிலிதாந் லோகாந் அப்ருʼச்ச²த், ஏஷ ப³ரப்³பா³ ப³ந்தீ⁴ க்²ரீஷ்டவிக்²யாதோ யீஸு²ஸ்²சைதயோ​: கம்ʼ மோசயிஷ்யாமி? யுஷ்மாகம்ʼ கிமீப்ஸிதம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","தைரீர்ஷ்யயா ஸ ஸமர்பித இதி ஸ ஜ்ஞாதவாந்| ");
INSERT INTO santam_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","அபரம்ʼ விசாராஸநோபவேஸ²நகாலே பீலாதஸ்ய பத்நீ ப்⁴ருʼத்யம்ʼ ப்ரஹித்ய தஸ்மை கத²யாமாஸ, தம்ʼ தா⁴ர்ம்மிகமநுஜம்ʼ ப்ரதி த்வயா கிமபி ந கர்த்தவ்யம்ʼ; யஸ்மாத் தத்க்ருʼதே(அ)த்³யாஹம்ʼ ஸ்வப்நே ப்ரபூ⁴தகஷ்டமலபே⁴| ");
INSERT INTO santam_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","அநந்தரம்ʼ ப்ரதா⁴நயாஜகப்ராசீநா ப³ரப்³பா³ம்ʼ யாசித்வாதா³தும்ʼ யீஸு²ஞ்ச ஹந்தும்ʼ ஸகலலோகாந் ப்ராவர்த்தயந்| ");
INSERT INTO santam_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ததோ(அ)தி⁴பதிஸ்தாந் ப்ருʼஷ்டவாந், ஏதயோ​: கமஹம்ʼ மோசயிஷ்யாமி? யுஷ்மாகம்ʼ கேச்சா²? தே ப்ரோசு ர்ப³ரப்³பா³ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ததா³ பீலாத​: பப்ரச்ச², தர்ஹி யம்ʼ க்²ரீஷ்டம்ʼ வத³ந்தி, தம்ʼ யீஸு²ம்ʼ கிம்ʼ கரிஷ்யாமி? ஸர்வ்வே கத²யாமாஸு​:, ஸ க்ருஸே²ந வித்⁴யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ததோ(அ)தி⁴பதிரவாதீ³த், குத​:? கிம்ʼ தேநாபராத்³த⁴ம்ʼ? கிந்து தே புநருசை ர்ஜக³து³​:, ஸ க்ருஸே²ந வித்⁴யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ததா³ நிஜவாக்யமக்³ராஹ்யமபூ⁴த், கலஹஸ்²சாப்யபூ⁴த், பீலாத இதி விலோக்ய லோகாநாம்ʼ ஸமக்ஷம்ʼ தோயமாதா³ய கரௌ ப்ரக்ஷால்யாவோசத், ஏதஸ்ய தா⁴ர்ம்மிகமநுஷ்யஸ்ய ஸோ²ணிதபாதே நிர்தோ³ஷோ(அ)ஹம்ʼ, யுஷ்மாபி⁴ரேவ தத்³ பு³த்⁴யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ததா³ ஸர்வ்வா​: ப்ரஜா​: ப்ரத்யவோசந், தஸ்ய ஸோ²ணிதபாதாபராதோ⁴(அ)ஸ்மாகம் அஸ்மத்ஸந்தாநாநாஞ்சோபரி ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","தத​: ஸ தேஷாம்ʼ ஸமீபே ப³ரப்³பா³ம்ʼ மோசயாமாஸ யீஸு²ந்து கஷாபி⁴ராஹத்ய க்ருஸே²ந வேதி⁴தும்ʼ ஸமர்பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","அநந்தரம் அதி⁴பதே​: ஸேநா அதி⁴பதே ர்க்³ருʼஹம்ʼ யீஸு²மாநீய தஸ்ய ஸமீபே ஸேநாஸமூஹம்ʼ ஸம்ʼஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ததஸ்தே தஸ்ய வஸநம்ʼ மோசயித்வா க்ருʼஷ்ணலோஹிதவர்ணவஸநம்ʼ பரிதா⁴பயாமாஸு​: ");
INSERT INTO santam_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","கண்டகாநாம்ʼ முகுடம்ʼ நிர்ம்மாய தச்சி²ரஸி த³து³​:, தஸ்ய த³க்ஷிணகரே வேத்ரமேகம்ʼ த³த்த்வா தஸ்ய ஸம்முகே² ஜாநூநி பாதயித்வா, ஹே யிஹூதீ³யாநாம்ʼ ராஜந், துப்⁴யம்ʼ நம இத்யுக்த்வா தம்ʼ திரஸ்²சக்ரு​:, ");
INSERT INTO santam_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ததஸ்தஸ்ய கா³த்ரே நிஷ்டீ²வம்ʼ த³த்வா தேந வேத்ரேண ஸி²ர ஆஜக்⁴நு​:| ");
INSERT INTO santam_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","இத்த²ம்ʼ தம்ʼ திரஸ்க்ருʼத்ய தத்³ வஸநம்ʼ மோசயித்வா புநர்நிஜவஸநம்ʼ பரிதா⁴பயாஞ்சக்ரு​:, தம்ʼ க்ருஸே²ந வேதி⁴தும்ʼ நீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","பஸ்²சாத்தே ப³ஹிர்பூ⁴ய குரீணீயம்ʼ ஸி²மோந்நாமகமேகம்ʼ விலோக்ய க்ருஸ²ம்ʼ வோடு⁴ம்ʼ தமாத³தி³ரே| ");
INSERT INTO santam_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","அநந்தரம்ʼ கு³ல்க³ல்தாம் அர்தா²த் ஸி²ரஸ்கபாலநாமகஸ்தா²நமு பஸ்தா²ய தே யீஸ²வே பித்தமிஸ்²ரிதாம்லரஸம்ʼ பாதும்ʼ த³து³​:, ");
INSERT INTO santam_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","கிந்து ஸ தமாஸ்வாத்³ய ந பபௌ| ");
INSERT INTO santam_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ததா³நீம்ʼ தே தம்ʼ க்ருஸே²ந ஸம்ʼவித்⁴ய தஸ்ய வஸநாநி கு³டிகாபாதேந விப⁴ஜ்ய ஜக்³ருʼஹு​:, தஸ்மாத், விப⁴ஜந்தே(அ)த⁴ரீயம்ʼ மே தே மநுஷ்யா​: பரஸ்பரம்ʼ| மது³த்தரீயவஸ்த்ரார்த²ம்ʼ கு³டிகாம்ʼ பாதயந்தி ச|| யதே³தத்³வசநம்ʼ ப⁴விஷ்யத்³வாதி³பி⁴ருக்தமாஸீத், ததா³ தத்³ அஸித்⁴யத், ");
INSERT INTO santam_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","பஸ்²சாத் தே தத்ரோபவிஸ்²ய தத்³ரக்ஷணகர்வ்வணி நியுக்தாஸ்தஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","அபரம் ஏஷ யிஹூதீ³யாநாம்ʼ ராஜா யீஸு²ரித்யபவாத³லிபிபத்ரம்ʼ தச்சி²ரஸ ஊர்த்³வ்வே யோஜயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ததஸ்தஸ்ய வாமே த³க்ஷிணே ச த்³வௌ சைரௌ தேந ஸாகம்ʼ க்ருஸே²ந விவிது⁴​:| ");
INSERT INTO santam_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ததா³ பாந்தா² நிஜஸி²ரோ லாட³யித்வா தம்ʼ நிந்த³ந்தோ ஜக³து³​:, ");
INSERT INTO santam_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ஹே ஈஸ்²வரமந்தி³ரப⁴ஞ்ஜக தி³நத்ரயே தந்நிர்ம்மாத​: ஸ்வம்ʼ ரக்ஷ, சேத்த்வமீஸ்²வரஸுதஸ்தர்ஹி க்ருஸா²த³வரோஹ| ");
INSERT INTO santam_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ப்ரதா⁴நயாஜகாத்⁴யாபகப்ராசீநாஸ்²ச ததா² திரஸ்க்ருʼத்ய ஜக³து³​:, ");
INSERT INTO santam_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ஸோ(அ)ந்யஜநாநாவத், கிந்து ஸ்வமவிதும்ʼ ந ஸ²க்நோதி| யதீ³ஸ்ராயேலோ ராஜா ப⁴வேத், தர்ஹீதா³நீமேவ க்ருஸா²த³வரோஹது, தேந தம்ʼ வயம்ʼ ப்ரத்யேஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ஸ ஈஸ்²வரே ப்ரத்யாஸா²மகரோத், யதீ³ஸ்²வரஸ்தஸ்மிந் ஸந்துஷ்டஸ்தர்ஹீதா³நீமேவ தமவேத், யத​: ஸ உக்தவாந் அஹமீஸ்²வரஸுத​:| ");
INSERT INTO santam_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","யௌ ஸ்தேநௌ ஸாகம்ʼ தேந க்ருஸே²ந வித்³தௌ⁴ தௌ தத்³வதே³வ தம்ʼ நிநிந்த³து​:| ");
INSERT INTO santam_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ததா³ த்³விதீயயாமாத் த்ருʼதீயயாமம்ʼ யாவத் ஸர்வ்வதே³ஸே² தமிரம்ʼ ப³பூ⁴வ, ");
INSERT INTO santam_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","த்ருʼதீயயாமே \"ஏலீ ஏலீ லாமா ஸி²வக்தநீ\", அர்தா²த் மதீ³ஸ்²வர மதீ³ஸ்²வர குதோ மாமத்யாக்ஷீ​:? யீஸு²ருச்சைரிதி ஜகா³த³| ");
INSERT INTO santam_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ததா³ தத்ர ஸ்தி²தா​: கேசித் தத் ஸ்²ருத்வா ப³பா⁴ஷிரே, அயம் ஏலியமாஹூயதி| ");
INSERT INTO santam_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","தேஷாம்ʼ மத்⁴யாத்³ ஏக​: ஸீ²க்⁴ரம்ʼ க³த்வா ஸ்பஞ்ஜம்ʼ க்³ருʼஹீத்வா தத்ராம்லரஸம்ʼ த³த்த்வா நலேந பாதும்ʼ தஸ்மை த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","இதரே(அ)கத²யந் திஷ்ட²த, தம்ʼ ரக்ஷிதும் ஏலிய ஆயாதி நவேதி பஸ்²யாம​:| ");
INSERT INTO santam_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","யீஸு²​: புநருசைராஹூய ப்ராணாந் ஜஹௌ| ");
INSERT INTO santam_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ததோ மந்தி³ரஸ்ய விச்சே²த³வஸநம் ஊர்த்³வ்வாத³தோ⁴ யாவத் சி²த்³யமாநம்ʼ த்³விதா⁴ப⁴வத், ");
INSERT INTO santam_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","பூ⁴மிஸ்²சகம்பே பூ⁴த⁴ரோவ்யதீ³ர்ய்யத ச| ஸ்²மஸா²நே முக்தே பூ⁴ரிபுண்யவதாம்ʼ ஸுப்ததே³ஹா உத³திஷ்ட²ந், ");
INSERT INTO santam_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ஸ்²மஸா²நாத்³ வஹிர்பூ⁴ய தது³த்தா²நாத் பரம்ʼ புண்யபுரம்ʼ க³த்வா ப³ஹுஜநாந் த³ர்ஸ²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","யீஸு²ரக்ஷணாய நியுக்த​: ஸ²தஸேநாபதிஸ்தத்ஸங்கி³நஸ்²ச தாத்³ருʼஸீ²ம்ʼ பூ⁴கம்பாதி³க⁴டநாம்ʼ த்³ருʼஷ்ட்வா பீ⁴தா அவத³ந், ஏஷ ஈஸ்²வரபுத்ரோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","யா ப³ஹுயோஷிதோ யீஸு²ம்ʼ ஸேவமாநா கா³லீலஸ்தத்பஸ்²சாதா³க³தாஸ்தாஸாம்ʼ மத்⁴யே ");
INSERT INTO santam_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","மக்³த³லீநீ மரியம் யாகூப்³யோஸ்²யோ ர்மாதா யா மரியம் ஸிப³தி³யபுத்ரயோ ர்மாதா ச யோஷித ஏதா தூ³ரே திஷ்ட²ந்த்யோ த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ஸந்த்⁴யாயாம்ʼ ஸத்யம் அரிமதி²யாநக³ரஸ்ய யூஷப்²நாமா த⁴நீ மநுஜோ யீஸோ²​: ஸி²ஷ்யத்வாத் ");
INSERT INTO santam_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","பீலாதஸ்ய ஸமீபம்ʼ க³த்வா யீஸோ²​: காயம்ʼ யயாசே, தேந பீலாத​: காயம்ʼ தா³தும் ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","யூஷப்² தத்காயம்ʼ நீத்வா ஸு²சிவஸ்த்ரேணாச்சா²த்³ய ");
INSERT INTO santam_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ஸ்வார்த²ம்ʼ ஸை²லே யத் ஸ்²மஸா²நம்ʼ சகா²ந, தந்மத்⁴யே தத்காயம்ʼ நிதா⁴ய தஸ்ய த்³வாரி வ்ருʼஹத்பாஷாணம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","கிந்து மக்³த³லீநீ மரியம் அந்யமரியம் ஏதே ஸ்த்ரியௌ தத்ர ஸ்²மஸா²நஸம்முக² உபவிவிஸ²து​:| ");
INSERT INTO santam_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","தத³நந்தரம்ʼ நிஸ்தாரோத்ஸவஸ்யாயோஜநதி³நாத் பரே(அ)ஹநி ப்ரதா⁴நயாஜகா​: பி²ரூஸி²நஸ்²ச மிலித்வா பீலாதமுபாக³த்யாகத²யந், ");
INSERT INTO santam_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ஹே மஹேச்ச² ஸ ப்ரதாரகோ ஜீவந அகத²யத், தி³நத்ரயாத் பரம்ʼ ஸ்²மஸா²நாது³த்தா²ஸ்யாமி தத்³வாக்யம்ʼ ஸ்மராமோ வயம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","தஸ்மாத் த்ருʼதீயதி³நம்ʼ யாவத் தத் ஸ்²மஸா²நம்ʼ ரக்ஷிதுமாதி³ஸ²து, நோசேத் தச்சி²ஷ்யா யாமிந்யாமாக³த்ய தம்ʼ ஹ்ருʼத்வா லோகாந் வதி³ஷ்யந்தி, ஸ ஸ்²மஸா²நாது³த³திஷ்ட²த், ததா² ஸதி ப்ரத²மப்⁴ராந்தே​: ஸே²ஷீயப்⁴ராந்தி ர்மஹதீ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ததா³ பீலாத அவாதீ³த், யுஷ்மாகம்ʼ ஸமீபே ரக்ஷிக³ண ஆஸ்தே, யூயம்ʼ க³த்வா யதா² ஸாத்⁴யம்ʼ ரக்ஷயத| ");
INSERT INTO santam_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ததஸ்தே க³த்வா தத்³தூ³ाரபாஷாணம்ʼ முத்³ராங்கிதம்ʼ க்ருʼத்வா ரக்ஷிக³ணம்ʼ நியோஜ்ய ஸ்²மஸா²நம்ʼ ரக்ஷயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","தத​: பரம்ʼ விஸ்²ராமவாரஸ்ய ஸே²ஷே ஸப்தாஹப்ரத²மதி³நஸ்ய ப்ரபோ⁴தே ஜாதே மக்³த³லீநீ மரியம் அந்யமரியம் ச ஸ்²மஸா²நம்ʼ த்³ரஷ்டுமாக³தா| ");
INSERT INTO santam_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ததா³ மஹாந் பூ⁴கம்போ(அ)ப⁴வத்; பரமேஸ்²வரீயதூ³த​: ஸ்வர்கா³த³வருஹ்ய ஸ்²மஸா²நத்³வாராத் பாஷாணமபஸார்ய்ய தது³பர்ய்யுபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","தத்³வத³நம்ʼ வித்³யுத்³வத் தேஜோமயம்ʼ வஸநம்ʼ ஹிமஸு²ப்⁴ரஞ்ச| ");
INSERT INTO santam_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ததா³நீம்ʼ ரக்ஷிணஸ்தத்³ப⁴யாத் கம்பிதா ம்ருʼதவத்³ ப³பூ⁴வ​:| ");
INSERT INTO santam_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ஸ தூ³தோ யோஷிதோ ஜகா³த³, யூயம்ʼ மா பை⁴ஷ்ட, க்ருஸ²ஹதயீஸு²ம்ʼ ம்ருʼக³யத்⁴வே தத³ஹம்ʼ வேத்³மி| ");
INSERT INTO santam_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ஸோ(அ)த்ர நாஸ்தி, யதா²வத³த் ததோ²த்தி²தவாந்; ஏதத் ப்ரபோ⁴​: ஸ²யநஸ்தா²நம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","தூர்ணம்ʼ க³த்வா தச்சி²ஷ்யாந் இதி வத³த, ஸ ஸ்²மஸா²நாத்³ உத³திஷ்ட²த், யுஷ்மாகமக்³ரே கா³லீலம்ʼ யாஸ்யதி யூயம்ʼ தத்ர தம்ʼ வீக்ஷிஷ்யத்⁴வே, பஸ்²யதாஹம்ʼ வார்த்தாமிமாம்ʼ யுஷ்மாநவாதி³ஷம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ததஸ்தா ப⁴யாத் மஹாநந்தா³ஞ்ச ஸ்²மஸா²நாத் தூர்ணம்ʼ ப³ஹிர்பூ⁴ய தச்சி²ஷ்யாந் வார்த்தாம்ʼ வக்தும்ʼ தா⁴விதவத்ய​:| கிந்து ஸி²ஷ்யாந் வார்த்தாம்ʼ வக்தும்ʼ யாந்தி, ததா³ யீஸு² ர்த³ர்ஸ²நம்ʼ த³த்த்வா தா ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","யுஷ்மாகம்ʼ கல்யாணம்ʼ பூ⁴யாத், ததஸ்தா ஆக³த்ய தத்பாத³யோ​: பதித்வா ப்ரணேமு​:| ");
INSERT INTO santam_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","யீஸு²ஸ்தா அவாதீ³த், மா பி³பீ⁴த, யூயம்ʼ க³த்வா மம ப்⁴ராத்ருʼந் கா³லீலம்ʼ யாதும்ʼ வத³த, தத்ர தே மாம்ʼ த்³ரக்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ஸ்த்ரியோ க³ச்ச²ந்தி, ததா³ ரக்ஷிணாம்ʼ கேசித் புரம்ʼ க³த்வா யத்³யத்³ க⁴டிதம்ʼ தத்ஸர்வ்வம்ʼ ப்ரதா⁴நயாஜகாந் ஜ்ஞாபிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","தே ப்ராசீநை​: ஸமம்ʼ ஸம்ʼஸத³ம்ʼ க்ருʼத்வா மந்த்ரயந்தோ ப³ஹுமுத்³ரா​: ஸேநாப்⁴யோ த³த்த்வாவத³ந், ");
INSERT INTO santam_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","அஸ்மாஸு நித்³ரிதேஷு தச்சி²ஷ்யா யாமிந்யாமாக³த்ய தம்ʼ ஹ்ருʼத்வாநயந், இதி யூயம்ʼ ப்ரசாரயத| ");
INSERT INTO santam_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","யத்³யேதத³தி⁴பதே​: ஸ்²ரோத்ரகோ³சரீப⁴வேத், தர்ஹி தம்ʼ போ³த⁴யித்வா யுஷ்மாநவிஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ததஸ்தே முத்³ரா க்³ருʼஹீத்வா ஸி²க்ஷாநுரூபம்ʼ கர்ம்ம சக்ரு​:, யிஹூதீ³யாநாம்ʼ மத்⁴யே தஸ்யாத்³யாபி கிம்ʼவத³ந்தீ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ஏகாத³ஸ² ஸி²ஷ்யா யீஸு²நிரூபிதாகா³லீலஸ்யாத்³ரிம்ʼ க³த்வா ");
INSERT INTO santam_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","தத்ர தம்ʼ ஸம்ʼவீக்ஷ்ய ப்ரணேமு​:, கிந்து கேசித் ஸந்தி³க்³த⁴வந்த​:| ");
INSERT INTO santam_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","யீஸு²ஸ்தேஷாம்ʼ ஸமீபமாக³த்ய வ்யாஹ்ருʼதவாந், ஸ்வர்க³மேதி³ந்யோ​: ஸர்வ்வாதி⁴பதித்வபா⁴ரோ மய்யர்பித ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","அதோ யூயம்ʼ ப்ரயாய ஸர்வ்வதே³ஸீ²யாந் ஸி²ஷ்யாந் க்ருʼத்வா பிது​: புத்ரஸ்ய பவித்ரஸ்யாத்மநஸ்²ச நாம்நா தாநவகா³ஹயத; அஹம்ʼ யுஷ்மாந் யத்³யதா³தி³ஸ²ம்ʼ தத³பி பாலயிதும்ʼ தாநுபாதி³ஸ²த| ");
INSERT INTO santam_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","பஸ்²யத, ஜக³த³ந்தம்ʼ யாவத் ஸதா³ஹம்ʼ யுஷ்மாபி⁴​: ஸாகம்ʼ திஷ்டா²மி| இதி|");
INSERT INTO santam_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ஈஸ்²வரபுத்ரஸ்ய யீஸு²க்²ரீஷ்டஸ்ய ஸுஸம்ʼவாதா³ரம்ப⁴​:| ");
INSERT INTO santam_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு லிபிரித்த²மாஸ்தே, பஸ்²ய ஸ்வகீயதூ³தந்து தவாக்³ரே ப்ரேஷயாம்யஹம்| க³த்வா த்வதீ³யபந்தா²நம்ʼ ஸ ஹி பரிஷ்கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"பரமேஸ²ஸ்ய பந்தா²நம்ʼ பரிஷ்குருத ஸர்வ்வத​:| தஸ்ய ராஜபத²ஞ்சைவ ஸமாநம்ʼ குருதாது⁴நா| \" இத்யேதத் ப்ராந்தரே வாக்யம்ʼ வத³த​: கஸ்யசித்³ரவ​:|| ");
INSERT INTO santam_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ஸஏவ யோஹந் ப்ராந்தரே மஜ்ஜிதவாந் ததா² பாபமார்ஜநநிமித்தம்ʼ மநோவ்யாவர்த்தகமஜ்ஜநஸ்ய கதா²ஞ்ச ப்ரசாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ததோ யிஹூதா³தே³ஸ²யிரூஸா²லம்நக³ரநிவாஸிந​: ஸர்வ்வே லோகா ப³ஹி ர்பூ⁴த்வா தஸ்ய ஸமீபமாக³த்ய ஸ்வாநி ஸ்வாநி பாபாந்யங்கீ³க்ருʼத்ய யர்த்³த³நநத்³யாம்ʼ தேந மஜ்ஜிதா ப³பூ⁴வு​:| ");
INSERT INTO santam_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","அஸ்ய யோஹந​: பரிதே⁴யாநி க்ரமேலகலோமஜாநி, தஸ்ய கடிப³ந்த⁴நம்ʼ சர்ம்மஜாதம், தஸ்ய ப⁴க்ஷ்யாணி ச ஸூ²ககீடா வந்யமதூ⁴நி சாஸந்| ");
INSERT INTO santam_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ஸ ப்ரசாரயந் கத²யாஞ்சக்ரே, அஹம்ʼ நம்ரீபூ⁴ய யஸ்ய பாது³காப³ந்த⁴நம்ʼ மோசயிதுமபி ந யோக்³யோஸ்மி, தாத்³ருʼஸோ² மத்தோ கு³ருதர ஏக​: புருஷோ மத்பஸ்²சாதா³க³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","அஹம்ʼ யுஷ்மாந் ஜலே மஜ்ஜிதவாந் கிந்து ஸ பவித்ர ஆத்மாநி ஸம்ʼமஜ்ஜயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","அபரஞ்ச தஸ்மிந்நேவ காலே கா³லீல்ப்ரதே³ஸ²ஸ்ய நாஸரத்³க்³ராமாத்³ யீஸு²ராக³த்ய யோஹநா யர்த்³த³நநத்³யாம்ʼ மஜ்ஜிதோ(அ)பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ஸ ஜலாது³த்தி²தமாத்ரோ மேக⁴த்³வாரம்ʼ முக்தம்ʼ கபோதவத் ஸ்வஸ்யோபரி அவரோஹந்தமாத்மாநஞ்ச த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","த்வம்ʼ மம ப்ரிய​: புத்ரஸ்த்வய்யேவ மமமஹாஸந்தோஷ இயமாகாஸீ²யா வாணீ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","தஸ்மிந் காலே ஆத்மா தம்ʼ ப்ராந்தரமத்⁴யம்ʼ நிநாய| ");
INSERT INTO santam_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","அத² ஸ சத்வாரிம்ʼஸ²த்³தி³நாநி தஸ்மிந் ஸ்தா²நே வந்யபஸு²பி⁴​: ஸஹ திஷ்ட²ந் ஸை²தாநா பரீக்ஷித​:; பஸ்²சாத் ஸ்வர்கீ³யதூ³தாஸ்தம்ʼ ஸிஷேவிரே| ");
INSERT INTO santam_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","அநந்தரம்ʼ யோஹநி ப³ந்த⁴நாலயே ப³த்³தே⁴ ஸதி யீஸு² ர்கா³லீல்ப்ரதே³ஸ²மாக³த்ய ஈஸ்²வரராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் கத²யாமாஸ, ");
INSERT INTO santam_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","கால​: ஸம்பூர்ண ஈஸ்²வரராஜ்யஞ்ச ஸமீபமாக³தம்ʼ; அதோஹேதோ ர்யூயம்ʼ மநாம்ʼஸி வ்யாவர்த்தயத்⁴வம்ʼ ஸுஸம்ʼவாதே³ ச விஸ்²வாஸித| ");
INSERT INTO santam_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","தத³நந்தரம்ʼ ஸ கா³லீலீயஸமுத்³ரஸ்ய தீரே க³ச்ச²ந் ஸி²மோந் தஸ்ய ப்⁴ராதா அந்த்³ரியநாமா ச இமௌ த்³வௌ ஜநௌ மத்ஸ்யதா⁴ரிணௌ ஸாக³ரமத்⁴யே ஜாலம்ʼ ப்ரக்ஷிபந்தௌ த்³ருʼஷ்ட்வா தாவவத³த், ");
INSERT INTO santam_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","யுவாம்ʼ மம பஸ்²சாதா³க³ச்ச²தம்ʼ, யுவாமஹம்ʼ மநுஷ்யதா⁴ரிணௌ கரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ததஸ்தௌ தத்க்ஷணமேவ ஜாலாநி பரித்யஜ்ய தஸ்ய பஸ்²சாத் ஜக்³மது​:| ");
INSERT INTO santam_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","தத​: பரம்ʼ தத்ஸ்தா²நாத் கிஞ்சித்³ தூ³ரம்ʼ க³த்வா ஸ ஸிவதீ³புத்ரயாகூப்³ தத்³ப்⁴ராத்ருʼயோஹந் ச இமௌ நௌகாயாம்ʼ ஜாலாநாம்ʼ ஜீர்ணமுத்³தா⁴ரயந்தௌ த்³ருʼஷ்ட்வா தாவாஹூயத்| ");
INSERT INTO santam_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ததஸ்தௌ நௌகாயாம்ʼ வேதநபு⁴க்³பி⁴​: ஸஹிதம்ʼ ஸ்வபிதரம்ʼ விஹாய தத்பஸ்²சாதீ³யது​:| ");
INSERT INTO santam_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","தத​: பரம்ʼ கப²ர்நாஹூம்நாமகம்ʼ நக³ரமுபஸ்தா²ய ஸ விஸ்²ராமதி³வஸே ப⁴ஜநக்³ரஹம்ʼ ப்ரவிஸ்²ய ஸமுபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","தஸ்யோபதே³ஸா²ல்லோகா ஆஸ்²சர்ய்யம்ʼ மேநிரே யத​: ஸோத்⁴யாபகாஇவ நோபதி³ஸ²ந் ப்ரபா⁴வவாநிவ ப்ரோபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","அபரஞ்ச தஸ்மிந் ப⁴ஜநக்³ருʼஹே அபவித்ரபூ⁴தேந க்³ரஸ்த ஏகோ மாநுஷ ஆஸீத்| ஸ சீத்ஸ²ப்³த³ம்ʼ க்ருʼத்வா கத²யாஞ்சகே ");
INSERT INTO santam_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","போ⁴ நாஸரதீய யீஸோ² த்வமஸ்மாந் த்யஜ, த்வயா ஸஹாஸ்மாகம்ʼ க​: ஸம்ப³ந்த⁴​:? த்வம்ʼ கிமஸ்மாந் நாஸ²யிதும்ʼ ஸமாக³த​:? த்வமீஸ்²வரஸ்ய பவித்ரலோக இத்யஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ததா³ யீஸு²ஸ்தம்ʼ தர்ஜயித்வா ஜகா³த³ தூஷ்ணீம்ʼ ப⁴வ இதோ ப³ஹிர்ப⁴வ ச| ");
INSERT INTO santam_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","தத​: ஸோ(அ)பவித்ரபூ⁴தஸ்தம்ʼ ஸம்பீட்³ய அத்யுசைஸ்²சீத்க்ருʼத்ய நிர்ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","தேநைவ ஸர்வ்வே சமத்க்ருʼத்ய பரஸ்பரம்ʼ கத²யாஞ்சக்ரிரே, அஹோ கிமித³ம்ʼ? கீத்³ருʼஸோ²(அ)யம்ʼ நவ்ய உபதே³ஸ²​:? அநேந ப்ரபா⁴வேநாபவித்ரபூ⁴தேஷ்வாஜ்ஞாபிதேஷு தே ததா³ஜ்ஞாநுவர்த்திநோ ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ததா³ தஸ்ய யஸோ² கா³லீலஸ்²சதுர்தி³க்ஸ்த²ஸர்வ்வதே³ஸா²ந் வ்யாப்நோத்| ");
INSERT INTO santam_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","அபரஞ்ச தே ப⁴ஜநக்³ருʼஹாத்³ ப³ஹி ர்பூ⁴த்வா யாகூப்³யோஹந்ப்⁴யாம்ʼ ஸஹ ஸி²மோந ஆந்த்³ரியஸ்ய ச நிவேஸ²நம்ʼ ப்ரவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ததா³ பிதரஸ்ய ஸ்²வஸ்²ரூர்ஜ்வரபீடி³தா ஸ²ய்யாயாமாஸ்த இதி தே தம்ʼ ஜ²டிதி விஜ்ஞாபயாஞ்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","தத​: ஸ ஆக³த்ய தஸ்யா ஹஸ்தம்ʼ த்⁴ருʼத்வா தாமுத³ஸ்தா²பயத்; ததை³வ தாம்ʼ ஜ்வரோ(அ)த்யாக்ஷீத் தத​: பரம்ʼ ஸா தாந் ஸிஷேவே| ");
INSERT INTO santam_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","அதா²ஸ்தம்ʼ க³தே ரவௌ ஸந்த்⁴யாகாலே ஸதி லோகாஸ்தத்ஸமீபம்ʼ ஸர்வ்வாந் ரோகி³ணோ பூ⁴தத்⁴ருʼதாம்ʼஸ்²ச ஸமாநிந்யு​:| ");
INSERT INTO santam_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ஸர்வ்வே நாக³ரிகா லோகா த்³வாரி ஸம்ʼமிலிதாஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","தத​: ஸ நாநாவித⁴ரோகி³ணோ ப³ஹூந் மநுஜாநரோகி³ணஸ்²சகார ததா² ப³ஹூந் பூ⁴தாந் த்யாஜயாஞ்சகார தாந் பூ⁴தாந் கிமபி வாக்யம்ʼ வக்தும்ʼ நிஷிஷேத⁴ ச யதோஹேதோஸ்தே தமஜாநந்| ");
INSERT INTO santam_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","அபரஞ்ச ஸோ(அ)திப்ரத்யூஷே வஸ்துதஸ்து ராத்ரிஸே²ஷே ஸமுத்தா²ய ப³ஹிர்பூ⁴ய நிர்ஜநம்ʼ ஸ்தா²நம்ʼ க³த்வா தத்ர ப்ரார்த²யாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","அநந்தரம்ʼ ஸி²மோந் தத்ஸங்கி³நஸ்²ச தஸ்ய பஸ்²சாத்³ க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","தது³த்³தே³ஸ²ம்ʼ ப்ராப்ய தமவத³ந் ஸர்வ்வே லோகாஸ்த்வாம்ʼ ம்ருʼக³யந்தே| ");
INSERT INTO santam_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ததா³ ஸோ(அ)கத²யத் ஆக³ச்ச²த வயம்ʼ ஸமீபஸ்தா²நி நக³ராணி யாம​:, யதோ(அ)ஹம்ʼ தத்ர கதா²ம்ʼ ப்ரசாரயிதும்ʼ ப³ஹிராக³மம்| ");
INSERT INTO santam_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","அத² ஸ தேஷாம்ʼ கா³லீல்ப்ரதே³ஸ²ஸ்ய ஸர்வ்வேஷு ப⁴ஜநக்³ருʼஹேஷு கதா²​: ப்ரசாரயாஞ்சக்ரே பூ⁴தாநத்யாஜயஞ்ச| ");
INSERT INTO santam_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","அநந்தரமேக​: குஷ்டீ² ஸமாக³த்ய தத்ஸம்முகே² ஜாநுபாதம்ʼ விநயஞ்ச க்ருʼத்வா கதி²தவாந் யதி³ ப⁴வாந் இச்ச²தி தர்ஹி மாம்ʼ பரிஷ்கர்த்தும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","தத​: க்ருʼபாலு ர்யீஸு²​: கரௌ ப்ரஸார்ய்ய தம்ʼ ஸ்பஷ்ட்வா கத²யாமாஸ ");
INSERT INTO santam_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","மமேச்சா² வித்³யதே த்வம்ʼ பரிஷ்க்ருʼதோ ப⁴வ| ஏதத்கதா²யா​: கத²நமாத்ராத் ஸ குஷ்டீ² ரோகா³ந்முக்த​: பரிஷ்க்ருʼதோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ததா³ ஸ தம்ʼ விஸ்ருʼஜந் கா³ட⁴மாதி³ஸ்²ய ஜகா³த³ ");
INSERT INTO santam_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ஸாவதா⁴நோ ப⁴வ கதா²மிமாம்ʼ கமபி மா வத³; ஸ்வாத்மாநம்ʼ யாஜகம்ʼ த³ர்ஸ²ய, லோகேப்⁴ய​: ஸ்வபரிஷ்க்ருʼதே​: ப்ரமாணதா³நாய மூஸாநிர்ணீதம்ʼ யத்³தா³நம்ʼ தது³த்ஸ்ருʼஜஸ்வ ச| ");
INSERT INTO santam_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","கிந்து ஸ க³த்வா தத் கர்ம்ம இத்த²ம்ʼ விஸ்தார்ய்ய ப்ரசாரயிதும்ʼ ப்ராரேபே⁴ தேநைவ யீஸு²​: புந​: ஸப்ரகாஸ²ம்ʼ நக³ரம்ʼ ப்ரவேஷ்டும்ʼ நாஸ²க்நோத் ததோஹேதோர்ப³ஹி​: காநநஸ்தா²நே தஸ்யௌ; ததா²பி சதுர்த்³தி³க்³ப்⁴யோ லோகாஸ்தஸ்ய ஸமீபமாயயு​:| ");
INSERT INTO santam_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","தத³நந்தரம்ʼ யீஸை² கதிபயதி³நாநி விலம்ப்³ய புந​: கப²ர்நாஹூம்நக³ரம்ʼ ப்ரவிஷ்டே ஸ க்³ருʼஹ ஆஸ்த இதி கிம்ʼவத³ந்த்யா தத்க்ஷணம்ʼ தத்ஸமீபம்ʼ ப³ஹவோ லோகா ஆக³த்ய ஸமுபதஸ்து²​:, ");
INSERT INTO santam_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","தஸ்மாத்³ க்³ருʼஹமத்⁴யே ஸர்வ்வேஷாம்ʼ க்ருʼதே ஸ்தா²நம்ʼ நாப⁴வத்³ த்³வாரஸ்ய சதுர்தி³க்ஷ்வபி நாப⁴வத், தத்காலே ஸ தாந் ப்ரதி கதா²ம்ʼ ப்ரசாரயாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","தத​: பரம்ʼ லோகாஸ்²சதுர்பி⁴ ர்மாநவைரேகம்ʼ பக்ஷாகா⁴திநம்ʼ வாஹயித்வா தத்ஸமீபம் ஆநிந்யு​:| ");
INSERT INTO santam_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","கிந்து ஜநாநாம்ʼ ப³ஹுத்வாத் தம்ʼ யீஸோ²​: ஸம்முக²மாநேதும்ʼ ந ஸ²க்நுவந்தோ யஸ்மிந் ஸ்தா²நே ஸ ஆஸ்தே தது³பரிக்³ருʼஹப்ருʼஷ்ட²ம்ʼ க²நித்வா சி²த்³ரம்ʼ க்ருʼத்வா தேந மார்கே³ண ஸஸ²ய்யம்ʼ பக்ஷாகா⁴திநம் அவரோஹயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ததோ யீஸு²ஸ்தேஷாம்ʼ விஸ்²வாஸம்ʼ த்³ருʼஷ்ட்வா தம்ʼ பக்ஷாகா⁴திநம்ʼ ப³பா⁴ஷே ஹே வத்ஸ தவ பாபாநாம்ʼ மார்ஜநம்ʼ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ததா³ கியந்தோ(அ)த்⁴யாபகாஸ்தத்ரோபவிஸ²ந்தோ மநோபி⁴ ர்விதர்கயாஞ்சக்ரு​:, ஏஷ மநுஷ்ய ஏதாத்³ருʼஸீ²மீஸ்²வரநிந்தா³ம்ʼ கதா²ம்ʼ குத​: கத²யதி? ");
INSERT INTO santam_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ஈஸ்²வரம்ʼ விநா பாபாநி மார்ஷ்டும்ʼ கஸ்ய ஸாமர்த்²யம் ஆஸ்தே? ");
INSERT INTO santam_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","இத்த²ம்ʼ தே விதர்கயந்தி யீஸு²ஸ்தத்க்ஷணம்ʼ மநஸா தத்³ பு³த்³வ்வா தாநவத³த்³ யூயமந்த​:கரணை​: குத ஏதாநி விதர்கயத²? ");
INSERT INTO santam_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","தத³நந்தரம்ʼ யீஸு²ஸ்தத்ஸ்தா²நாத் புந​: ஸமுத்³ரதடம்ʼ யயௌ; லோகநிவஹே தத்ஸமீபமாக³தே ஸ தாந் ஸமுபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","கிந்து ப்ருʼதி²வ்யாம்ʼ பாபாநி மார்ஷ்டும்ʼ மநுஷ்யபுத்ரஸ்ய ஸாமர்த்²யமஸ்தி, ஏதத்³ யுஷ்மாந் ஜ்ஞாபயிதும்ʼ (ஸ தஸ்மை பக்ஷாகா⁴திநே கத²யாமாஸ) ");
INSERT INTO santam_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","உத்திஷ்ட² தவ ஸ²ய்யாம்ʼ க்³ருʼஹீத்வா ஸ்வக்³ருʼஹம்ʼ யாஹி, அஹம்ʼ த்வாமித³ம் ஆஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","தத​: ஸ தத்க்ஷணம் உத்தா²ய ஸ²ய்யாம்ʼ க்³ருʼஹீத்வா ஸர்வ்வேஷாம்ʼ ஸாக்ஷாத் ஜகா³ம; ஸர்வ்வே விஸ்மிதா ஏதாத்³ருʼஸ²ம்ʼ கர்ம்ம வயம் கதா³பி நாபஸ்²யாம, இமாம்ʼ கதா²ம்ʼ கத²யித்வேஸ்²வரம்ʼ த⁴ந்யமப்³ருவந்| ");
INSERT INTO santam_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","தத³நந்தரம்ʼ யீஸு²ஸ்தத்ஸ்தா²நாத் புந​: ஸமுத்³ரதடம்ʼ யயௌ; லோகநிவஹே தத்ஸமீபமாக³தே ஸ தாந் ஸமுபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","அத² க³ச்ச²ந் கரஸஞ்சயக்³ருʼஹ உபவிஷ்டம் ஆல்பீ²யபுத்ரம்ʼ லேவிம்ʼ த்³ருʼஷ்ட்வா தமாஹூய கதி²தவாந் மத்பஸ்²சாத் த்வாமாமச்ச² தத​: ஸ உத்தா²ய தத்பஸ்²சாத்³ யயௌ| ");
INSERT INTO santam_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","அநந்தரம்ʼ யீஸௌ² தஸ்ய க்³ருʼஹே போ⁴க்தும் உபவிஷ்டே ப³ஹவ​: கரமஞ்சாயிந​: பாபிநஸ்²ச தேந தச்சி²ஷ்யைஸ்²ச ஸஹோபவிவிஸு²​:, யதோ ப³ஹவஸ்தத்பஸ்²சாதா³ஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ததா³ ஸ கரமஞ்சாயிபி⁴​: பாபிபி⁴ஸ்²ச ஸஹ கா²த³தி, தத்³ த்³ருʼஷ்ட்வாத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச தஸ்ய ஸி²ஷ்யாநூசு​: கரமஞ்சாயிபி⁴​: பாபிபி⁴ஸ்²ச ஸஹாயம்ʼ குதோ பு⁴ம்ʼக்தே பிவதி ச? ");
INSERT INTO santam_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","தத்³வாக்யம்ʼ ஸ்²ருத்வா யீஸு²​: ப்ரத்யுவாச,அரோகி³லோகாநாம்ʼ சிகித்ஸகேந ப்ரயோஜநம்ʼ நாஸ்தி, கிந்து ரோகி³ணாமேவ; அஹம்ʼ தா⁴ர்ம்மிகாநாஹ்வாதும்ʼ நாக³த​: கிந்து மநோ வ்யாவர்த்தயிதும்ʼ பாபிந ஏவ| ");
INSERT INTO santam_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","தத​: பரம்ʼ யோஹந​: பி²ரூஸி²நாஞ்சோபவாஸாசாரிஸி²ஷ்யா யீஸோ²​: ஸமீபம் ஆக³த்ய கத²யாமாஸு​:, யோஹந​: பி²ரூஸி²நாஞ்ச ஸி²ஷ்யா உபவஸந்தி கிந்து ப⁴வத​: ஸி²ஷ்யா நோபவஸந்தி கிம்ʼ காரணமஸ்ய? ");
INSERT INTO santam_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ததா³ யீஸு²ஸ்தாந் ப³பா⁴ஷே யாவத் காலம்ʼ ஸகி²பி⁴​: ஸஹ கந்யாயா வரஸ்திஷ்ட²தி தாவத்காலம்ʼ தே கிமுபவஸ்தும்ʼ ஸ²க்நுவந்தி? யாவத்காலம்ʼ வரஸ்தை​: ஸஹ திஷ்ட²தி தாவத்காலம்ʼ த உபவஸ்தும்ʼ ந ஸ²க்நுவந்தி| ");
INSERT INTO santam_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","யஸ்மிந் காலே தேப்⁴ய​: ஸகாஸா²த்³ வரோ நேஷ்யதே ஸ கால ஆக³ச்ச²தி, தஸ்மிந் காலே தே ஜநா உபவத்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","கோபி ஜந​: புராதநவஸ்த்ரே நூதநவஸ்த்ரம்ʼ ந ஸீவ்யதி, யதோ நூதநவஸ்த்ரேண ஸஹ ஸேவநே க்ருʼதே ஜீர்ணம்ʼ வஸ்த்ரம்ʼ சி²த்³யதே தஸ்மாத் புந ர்மஹத் சி²த்³ரம்ʼ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","கோபி ஜந​: புராதநகுதூஷு நூதநம்ʼ த்³ராக்ஷாரஸம்ʼ ந ஸ்தா²பயதி, யதோ நூதநத்³ராக்ஷாரஸஸ்ய தேஜஸா தா​: குத்வோ விதீ³ர்ய்யந்தே ததோ த்³ராக்ஷாரஸஸ்²ச பததி குத்வஸ்²ச நஸ்²யந்தி, அதஏவ நூதநத்³ராக்ஷாரஸோ நூதநகுதூஷு ஸ்தா²பநீய​:| ");
INSERT INTO santam_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","தத³நந்தரம்ʼ யீஸு² ர்யதா³ விஸ்²ராமவாரே ஸ²ஸ்யக்ஷேத்ரேண க³ச்ச²தி ததா³ தஸ்ய ஸி²ஷ்யா க³ச்ச²ந்த​: ஸ²ஸ்யமஞ்ஜரீஸ்²சே²த்தும்ʼ ப்ரவ்ருʼத்தா​:| ");
INSERT INTO santam_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","அத​: பி²ரூஸி²நோ யீஸ²வே கத²யாமாஸு​: பஸ்²யது விஸ்²ராமவாஸரே யத் கர்ம்ம ந கர்த்தவ்யம்ʼ தத்³ இமே குத​: குர்வ்வந்தி? ");
INSERT INTO santam_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ததா³ ஸ தேப்⁴யோ(அ)கத²யத் தா³யூத்³ தத்ஸம்ʼங்கி³நஸ்²ச ப⁴க்ஷ்யாபா⁴வாத் க்ஷுதி⁴தா​: ஸந்தோ யத் கர்ம்ம க்ருʼதவந்தஸ்தத் கிம்ʼ யுஷ்மாபி⁴ ர்ந படி²தம்? ");
INSERT INTO santam_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","அபி³யாத²ர்நாமகே மஹாயாஜகதாம்ʼ குர்வ்வதி ஸ கத²மீஸ்²வரஸ்யாவாஸம்ʼ ப்ரவிஸ்²ய யே த³ர்ஸ²நீயபூபா யாஜகாந் விநாந்யஸ்ய கஸ்யாபி ந ப⁴க்ஷ்யாஸ்தாநேவ பு³பு⁴ஜே ஸங்கி³லோகேப்⁴யோ(அ)பி த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ஸோ(அ)பரமபி ஜகா³த³, விஸ்²ராமவாரோ மநுஷ்யார்த²மேவ நிரூபிதோ(அ)ஸ்தி கிந்து மநுஷ்யோ விஸ்²ராமவாரார்த²ம்ʼ நைவ| ");
INSERT INTO santam_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","மநுஷ்யபுத்ரோ விஸ்²ராமவாரஸ்யாபி ப்ரபு⁴ராஸ்தே| ");
INSERT INTO santam_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","அநந்தரம்ʼ யீஸு²​: புந ர்ப⁴ஜநக்³ருʼஹம்ʼ ப்ரவிஷ்டஸ்தஸ்மிந் ஸ்தா²நே ஸு²ஷ்கஹஸ்த ஏகோ மாநவ ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ஸ விஸ்²ராமவாரே தமரோகி³ணம்ʼ கரிஷ்யதி நவேத்யத்ர ப³ஹவஸ்தம் அபவதி³தும்ʼ சி²த்³ரமபேக்ஷிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ததா³ ஸ தம்ʼ ஸு²ஷ்கஹஸ்தம்ʼ மநுஷ்யம்ʼ ஜகா³த³ மத்⁴யஸ்தா²நே த்வமுத்திஷ்ட²| ");
INSERT INTO santam_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","தத​: பரம்ʼ ஸ தாந் பப்ரச்ச² விஸ்²ராமவாரே ஹிதமஹிதம்ʼ ததா² ஹி ப்ராணரக்ஷா வா ப்ராணநாஸ² ஏஷாம்ʼ மத்⁴யே கிம்ʼ கரணீயம்ʼ ? கிந்து தே நி​:ஸ²ப்³தா³ஸ்தஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ததா³ ஸ தேஷாமந்த​:கரணாநாம்ʼ காடி²ந்யாத்³தே⁴தோ ர்து³​:கி²த​: க்ரோதா⁴த் சர்துिத³ஸோ² த்³ருʼஷ்டவாந் தம்ʼ மாநுஷம்ʼ க³தி³தவாந் தம்ʼ ஹஸ்தம்ʼ விஸ்தாரய, ததஸ்தேந ஹஸ்தே விஸ்த்ருʼதே தத்³த⁴ஸ்தோ(அ)ந்யஹஸ்தவத்³ அரோகோ³ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","அத² பி²ரூஸி²ந​: ப்ரஸ்தா²ய தம்ʼ நாஸ²யிதும்ʼ ஹேரோதீ³யை​: ஸஹ மந்த்ரயிதுமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","அதஏவ யீஸு²ஸ்தத்ஸ்தா²நம்ʼ பரித்யஜ்ய ஸி²ஷ்யை​: ஸஹ புந​: ஸாக³ரஸமீபம்ʼ க³த​:; ");
INSERT INTO santam_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ததோ கா³லீல்யிஹூதா³-யிரூஸா²லம்-இதோ³ம்-யர்த³ந்நதீ³பாரஸ்தா²நேப்⁴யோ லோகஸமூஹஸ்தஸ்ய பஸ்²சாத்³ க³த​:; தத³ந்ய​: ஸோரஸீத³நோ​: ஸமீபவாஸிலோகஸமூஹஸ்²ச தஸ்ய மஹாகர்ம்மணாம்ʼ வார்த்தம்ʼ ஸ்²ருத்வா தஸ்ய ஸந்நிதி⁴மாக³த​:| ");
INSERT INTO santam_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ததா³ லோகஸமூஹஸ்²சேத் தஸ்யோபரி பததி இத்யாஸ²ங்க்ய ஸ நாவமேகாம்ʼ நிகடே ஸ்தா²பயிதும்ʼ ஸி²ஷ்யாநாதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","யதோ(அ)நேகமநுஷ்யாணாமாரோக்³யகரணாத்³ வ்யாதி⁴க்³ரஸ்தா​: ஸர்வ்வே தம்ʼ ஸ்ப்ரஷ்டும்ʼ பரஸ்பரம்ʼ ப³லேந யத்நவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","அபரஞ்ச அபவித்ரபூ⁴தாஸ்தம்ʼ த்³ருʼஷ்ட்வா தச்சரணயோ​: பதித்வா ப்ரோசை​: ப்ரோசு​:, த்வமீஸ்²வரஸ்ய புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","கிந்து ஸ தாந் த்³ருʼட⁴ம் ஆஜ்ஞாப்ய ஸ்வம்ʼ பரிசாயிதும்ʼ நிஷித்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","அநந்தரம்ʼ ஸ பர்வ்வதமாருஹ்ய யம்ʼ யம்ʼ ப்ரதிச்சா² தம்ʼ தமாஹூதவாந் ததஸ்தே தத்ஸமீபமாக³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ததா³ ஸ த்³வாத³ஸ²ஜநாந் ஸ்வேந ஸஹ ஸ்தா²தும்ʼ ஸுஸம்ʼவாத³ப்ரசாராய ப்ரேரிதா ப⁴விதும்ʼ ");
INSERT INTO santam_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ஸர்வ்வப்ரகாரவ்யாதீ⁴நாம்ʼ ஸ²மநகரணாய ப்ரபா⁴வம்ʼ ப்ராப்தும்ʼ பூ⁴தாந் த்யாஜயிதுஞ்ச நியுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","தேஷாம்ʼ நாமாநீமாநி, ஸி²மோந் ஸிவதி³புத்ரோ ");
INSERT INTO santam_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","யாகூப்³ தஸ்ய ப்⁴ராதா யோஹந் ச ஆந்த்³ரிய​: பி²லிபோ ப³ர்த²லமய​:, ");
INSERT INTO santam_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","மதீ² தோ²மா ச ஆல்பீ²யபுத்ரோ யாகூப்³ த²த்³தீ³ய​: கிநாநீய​: ஸி²மோந் யஸ்தம்ʼ பரஹஸ்தேஷ்வர்பயிஷ்யதி ஸ ஈஷ்கரியோதீயயிஹூதா³ஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ஸ ஸி²மோநே பிதர இத்யுபநாம த³தௌ³ யாகூப்³யோஹந்ப்⁴யாம்ʼ ச பி³நேரிகி³ஸ்² அர்த²தோ மேக⁴நாத³புத்ராவித்யுபநாம த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","அநந்தரம்ʼ தே நிவேஸ²நம்ʼ க³தா​:, கிந்து தத்ராபி புநர்மஹாந் ஜநஸமாக³மோ (அ)ப⁴வத் தஸ்மாத்தே போ⁴க்துமப்யவகாஸ²ம்ʼ ந ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ததஸ்தஸ்ய ஸுஹ்ருʼல்லோகா இமாம்ʼ வார்த்தாம்ʼ ப்ராப்ய ஸ ஹதஜ்ஞாநோபூ⁴த்³ இதி கதா²ம்ʼ கத²யித்வா தம்ʼ த்⁴ருʼத்வாநேதும்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","அபரஞ்ச யிரூஸா²லம ஆக³தா யே யே(அ)த்⁴யாபகாஸ்தே ஜக³து³ரயம்ʼ புருஷோ பூ⁴தபத்யாபி³ஷ்டஸ்தேந பூ⁴தபதிநா பூ⁴தாந் த்யாஜயதி| ");
INSERT INTO santam_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ததஸ்தாநாஹூய யீஸு² ர்த்³ருʼஷ்டாந்தை​: கதா²ம்ʼ கதி²தவாந் ஸை²தாந் கத²ம்ʼ ஸை²தாநம்ʼ த்யாஜயிதும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","கிஞ்சந ராஜ்யம்ʼ யதி³ ஸ்வவிரோதே⁴ந ப்ருʼத²க்³ ப⁴வதி தர்ஹி தத்³ ராஜ்யம்ʼ ஸ்தி²ரம்ʼ ஸ்தா²தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ததா² கஸ்யாபி பரிவாரோ யதி³ பரஸ்பரம்ʼ விரோதீ⁴ ப⁴வதி தர்ஹி ஸோபி பரிவார​: ஸ்தி²ரம்ʼ ஸ்தா²தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","தத்³வத் ஸை²தாந் யதி³ ஸ்வவிபக்ஷதயா உத்திஷ்ட²ந் பி⁴ந்நோ ப⁴வதி தர்ஹி ஸோபி ஸ்தி²ரம்ʼ ஸ்தா²தும்ʼ ந ஸ²க்நோதி கிந்தூச்சி²ந்நோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","அபரஞ்ச ப்ரப³லம்ʼ ஜநம்ʼ ப்ரத²மம்ʼ ந ப³த்³தா⁴ கோபி தஸ்ய க்³ருʼஹம்ʼ ப்ரவிஸ்²ய த்³ரவ்யாணி லுண்ட²யிதும்ʼ ந ஸ²க்நோதி, தம்ʼ ப³த்³வ்வைவ தஸ்ய க்³ருʼஹஸ்ய த்³ரவ்யாணி லுண்ட²யிதும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","அதோஹேதோ ர்யுஷ்மப்⁴யமஹம்ʼ ஸத்யம்ʼ கத²யாமி மநுஷ்யாணாம்ʼ ஸந்தாநா யாநி யாநி பாபாநீஸ்²வரநிந்தா³ஞ்ச குர்வ்வந்தி தேஷாம்ʼ தத்ஸர்வ்வேஷாமபராதா⁴நாம்ʼ க்ஷமா ப⁴விதும்ʼ ஸ²க்நோதி, ");
INSERT INTO santam_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","கிந்து ய​: கஸ்²சித் பவித்ரமாத்மாநம்ʼ நிந்த³தி தஸ்யாபராத⁴ஸ்ய க்ஷமா கதா³பி ந ப⁴விஷ்யதி ஸோநந்தத³ண்ட³ஸ்யார்ஹோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","தஸ்யாபவித்ரபூ⁴தோ(அ)ஸ்தி தேஷாமேதத்கதா²ஹேதோ​: ஸ இத்த²ம்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","அத² தஸ்ய மாதா ப்⁴ராத்ருʼக³ணஸ்²சாக³த்ய ப³ஹிஸ்திஷ்ட²நதோ லோகாந் ப்ரேஷ்ய தமாஹூதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ததஸ்தத்ஸந்நிதௌ⁴ ஸமுபவிஷ்டா லோகாஸ்தம்ʼ ப³பா⁴ஷிரே பஸ்²ய ப³ஹிஸ்தவ மாதா ப்⁴ராதரஸ்²ச த்வாம் அந்விச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ததா³ ஸ தாந் ப்ரத்யுவாச மம மாதா கா ப்⁴ராதரோ வா கே? தத​: பரம்ʼ ஸ ஸ்வமீபோபவிஷ்டாந் ஸி²ஷ்யாந் ப்ரதி அவலோகநம்ʼ க்ருʼத்வா கத²யாமாஸ ");
INSERT INTO santam_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","பஸ்²யதைதே மம மாதா ப்⁴ராதரஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ய​: கஸ்²சித்³ ஈஸ்²வரஸ்யேஷ்டாம்ʼ க்ரியாம்ʼ கரோதி ஸ ஏவ மம ப்⁴ராதா ப⁴கி³நீ மாதா ச| ");
INSERT INTO santam_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","அநந்தரம்ʼ ஸ ஸமுத்³ரதடே புநருபதே³ஷ்டும்ʼ ப்ராரேபே⁴, ததஸ்தத்ர ப³ஹுஜநாநாம்ʼ ஸமாக³மாத் ஸ ஸாக³ரோபரி நௌகாமாருஹ்ய ஸமுபவிஷ்ட​:; ஸர்வ்வே லோகா​: ஸமுத்³ரகூலே தஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ததா³ ஸ த்³ருʼஷ்டாந்தகதா²பி⁴ ர்ப³ஹூபதி³ஷ்டவாந் உபதி³ஸ²ம்ʼஸ்²ச கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","அவதா⁴நம்ʼ குருத, ஏகோ பீ³ஜவப்தா பீ³ஜாநி வப்தும்ʼ க³த​:; ");
INSERT INTO santam_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","வபநகாலே கியந்தி பீ³ஜாநி மார்க³பாஸ்²வே பதிதாநி, தத ஆகாஸீ²யபக்ஷிண ஏத்ய தாநி சகா²து³​:| ");
INSERT INTO santam_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","கியந்தி பீ³ஜாநி ஸ்வல்பம்ருʼத்திகாவத்பாஷாணபூ⁴மௌ பதிதாநி தாநி ம்ருʼதோ³ல்பத்வாத் ஸீ²க்⁴ரமங்குரிதாநி; ");
INSERT INTO santam_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","கிந்தூதி³தே ஸூர்ய்யே த³க்³தா⁴நி ததா² மூலாநோ நாதோ⁴க³தத்வாத் ஸு²ஷ்காணி ச| ");
INSERT INTO santam_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","கியந்தி பீ³ஜாநி கண்டகிவநமத்⁴யே பதிதாநி தத​: கண்டகாநி ஸம்ʼவ்ருʼத்³வ்ய தாநி ஜக்³ரஸுஸ்தாநி ந ச ப²லிதாநி| ");
INSERT INTO santam_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ததா² கியந்தி பீ³ஜாந்யுத்தமபூ⁴மௌ பதிதாநி தாநி ஸம்ʼவ்ருʼத்³வ்ய ப²லாந்யுத்பாதி³தாநி கியந்தி பீ³ஜாநி த்ரிம்ʼஸ²த்³கு³ணாநி கியந்தி ஷஷ்டிகு³ணாநி கியந்தி ஸ²தகு³ணாநி ப²லாநி ப²லிதவந்தி| ");
INSERT INTO santam_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","அத² ஸ தாநவத³த் யஸ்ய ஸ்²ரோதும்ʼ கர்ணௌ ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","தத³நந்தரம்ʼ நிர்ஜநஸமயே தத்ஸங்கி³நோ த்³வாத³ஸ²ஸி²ஷ்யாஸ்²ச தம்ʼ தத்³த்³ருʼஷ்டாந்தவாக்யஸ்யார்த²ம்ʼ பப்ரச்சு²​:| ");
INSERT INTO santam_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ததா³ ஸ தாநுதி³தவாந் ஈஸ்²வரராஜ்யஸ்ய நிகூ³ட⁴வாக்யம்ʼ போ³த்³து⁴ம்ʼ யுஷ்மாகமதி⁴காரோ(அ)ஸ்தி; ");
INSERT INTO santam_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","கிந்து யே வஹிர்பூ⁴தா​: \"தே பஸ்²யந்த​: பஸ்²யந்தி கிந்து ந ஜாநந்தி, ஸ்²ருʼண்வந்த​: ஸ்²ருʼண்வந்தி கிந்து ந பு³த்⁴யந்தே, சேத்தை ர்மந​:ஸு கதா³பி பரிவர்த்திதேஷு தேஷாம்ʼ பாபாந்யமோசயிஷ்யந்த,\" அதோஹேதோஸ்தாந் ப்ரதி த்³ருʼஷ்டாந்தைரேவ தாநி மயா கதி²தாநி| ");
INSERT INTO santam_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","அத² ஸ கதி²தவாந் யூயம்ʼ கிமேதத்³ த்³ருʼஷ்டாந்தவாக்யம்ʼ ந பு³த்⁴யத்⁴வே? தர்ஹி கத²ம்ʼ ஸர்வ்வாந் த்³ருʼஷ்டாந்தாந போ⁴த்ஸ்யத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","பீ³ஜவப்தா வாக்யரூபாணி பீ³ஜாநி வபதி; ");
INSERT INTO santam_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","தத்ர யே யே லோகா வாக்யம்ʼ ஸ்²ருʼண்வந்தி, கிந்து ஸ்²ருதமாத்ராத் ஸை²தாந் ஸீ²க்⁴ரமாக³த்ய தேஷாம்ʼ மந​:ஸூப்தாநி தாநி வாக்யரூபாணி பீ³ஜாந்யபநயதி தஏவ உப்தபீ³ஜமார்க³பார்ஸ்²வேஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","யே ஜநா வாக்யம்ʼ ஸ்²ருத்வா ஸஹஸா பரமாநந்தே³ந க்³ருʼஹ்லந்தி, கிந்து ஹ்ருʼதி³ ஸ்தை²ர்ய்யாபா⁴வாத் கிஞ்சித் காலமாத்ரம்ʼ திஷ்ட²ந்தி தத்பஸ்²சாத் தத்³வாக்யஹேதோ​: ");
INSERT INTO santam_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","குத்ரசித் க்லேஸே² உபத்³ரவே வா ஸமுபஸ்தி²தே ததை³வ விக்⁴நம்ʼ ப்ராப்நுவந்தி தஏவ உப்தபீ³ஜபாஷாணபூ⁴மிஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","யே ஜநா​: கதா²ம்ʼ ஸ்²ருʼண்வந்தி கிந்து ஸாம்ʼஸாரிகீ சிந்தா த⁴நப்⁴ராந்தி ர்விஷயலோப⁴ஸ்²ச ஏதே ஸர்வ்வே உபஸ்தா²ய தாம்ʼ கதா²ம்ʼ க்³ரஸந்தி தத​: மா விப²லா ப⁴வதி ");
INSERT INTO santam_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","தஏவ உப்தபீ³ஜஸகண்டகபூ⁴மிஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","யே ஜநா வாக்யம்ʼ ஸ்²ருத்வா க்³ருʼஹ்லந்தி தேஷாம்ʼ கஸ்ய வா த்ரிம்ʼஸ²த்³கு³ணாநி கஸ்ய வா ஷஷ்டிகு³ணாநி கஸ்ய வா ஸ²தகு³ணாநி ப²லாநி ப⁴வந்தி தஏவ உப்தபீ³ஜோர்வ்வரபூ⁴மிஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ததா³ ஸோ(அ)பரமபி கதி²தவாந் கோபி ஜநோ தீ³பாதா⁴ரம்ʼ பரித்யஜ்ய த்³ரோணஸ்யாத⁴​: க²ட்வாயா அதே⁴ வா ஸ்தா²பயிதும்ʼ தீ³பமாநயதி கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","அதோஹேதோ ர்யந்ந ப்ரகாஸ²யிஷ்யதே தாத்³ருʼக்³ லுக்காயிதம்ʼ கிமபி வஸ்து நாஸ்தி; யத்³ வ்யக்தம்ʼ ந ப⁴விஷ்யதி தாத்³ருʼஸ²ம்ʼ கு³ப்தம்ʼ கிமபி வஸ்து நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","யஸ்ய ஸ்²ரோதும்ʼ கர்ணௌ ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","அபரமபி கதி²தவாந் யூயம்ʼ யத்³ யத்³ வாக்யம்ʼ ஸ்²ருʼணுத² தத்ர ஸாவதா⁴நா ப⁴வத, யதோ யூயம்ʼ யேந பரிமாணேந பரிமாத² தேநைவ பரிமாணேந யுஷ்மத³ர்த²மபி பரிமாஸ்யதே; ஸ்²ரோதாரோ யூயம்ʼ யுஷ்மப்⁴யமதி⁴கம்ʼ தா³ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","யஸ்யாஸ்²ரயே வர்த்³த⁴தே தஸ்மை அபரமபி தா³ஸ்யதே, கிந்து யஸ்யாஸ்²ரயே ந வர்த்³த⁴தே தஸ்ய யத் கிஞ்சித³ஸ்தி தத³பி தஸ்மாந் நேஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","அநந்தரம்ʼ ஸ கதி²தவாந் ஏகோ லோக​: க்ஷேத்ரே பீ³ஜாந்யுப்த்வா ");
INSERT INTO santam_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ஜாக³ரணநித்³ராப்⁴யாம்ʼ தி³வாநிஸ²ம்ʼ க³மயதி, பரந்து தத்³வீஜம்ʼ தஸ்யாஜ்ஞாதரூபேணாங்குரயதி வர்த்³த⁴தே ச; ");
INSERT INTO santam_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","யதோஹேதோ​: ப்ரத²மத​: பத்ராணி தத​: பரம்ʼ கணிஸா²நி தத்பஸ்²சாத் கணிஸ²பூர்ணாநி ஸ²ஸ்யாநி பூ⁴மி​: ஸ்வயமுத்பாத³யதி; ");
INSERT INTO santam_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","கிந்து ப²லேஷு பக்கேஷு ஸ²ஸ்யச்சே²த³நகாலம்ʼ ஜ்ஞாத்வா ஸ தத்க்ஷணம்ʼ ஸ²ஸ்யாநி சி²நத்தி, அநேந துல்யமீஸ்²வரராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","புந​: ஸோ(அ)கத²யத்³ ஈஸ்²வரராஜ்யம்ʼ கேந ஸமம்ʼ? கேந வஸ்துநா ஸஹ வா தது³பமாஸ்யாமி? ");
INSERT INTO santam_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","தத் ஸர்ஷபைகேந துல்யம்ʼ யதோ ம்ருʼதி³ வபநகாலே ஸர்ஷபபீ³ஜம்ʼ ஸர்வ்வப்ருʼதி²வீஸ்த²பீ³ஜாத் க்ஷுத்³ரம்ʼ ");
INSERT INTO santam_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","கிந்து வபநாத் பரம் அங்குரயித்வா ஸர்வ்வஸா²காத்³ ப்³ருʼஹத்³ ப⁴வதி, தஸ்ய ப்³ருʼஹத்ய​: ஸா²கா²ஸ்²ச ஜாயந்தே ததஸ்தச்சா²யாம்ʼ பக்ஷிண ஆஸ்²ரயந்தே| ");
INSERT INTO santam_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","இத்த²ம்ʼ தேஷாம்ʼ போ³தா⁴நுரூபம்ʼ ஸோ(அ)நேகத்³ருʼஷ்டாந்தைஸ்தாநுபதி³ஷ்டவாந், ");
INSERT INTO santam_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","த்³ருʼஷ்டாந்தம்ʼ விநா காமபி கதா²ம்ʼ தேப்⁴யோ ந கதி²தவாந் பஸ்²சாந் நிர்ஜநே ஸ ஸி²ஷ்யாந் ஸர்வ்வத்³ருʼஷ்டாந்தார்த²ம்ʼ போ³தி⁴தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","தத்³தி³நஸ்ய ஸந்த்⁴யாயாம்ʼ ஸ தேப்⁴யோ(அ)கத²யத்³ ஆக³ச்ச²த வயம்ʼ பாரம்ʼ யாம| ");
INSERT INTO santam_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ததா³ தே லோகாந் விஸ்ருʼஜ்ய தமவிலம்ப³ம்ʼ க்³ருʼஹீத்வா நௌகயா ப்ரதஸ்தி²ரே; அபரா அபி நாவஸ்தயா ஸஹ ஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","தத​: பரம்ʼ மஹாஜ²ஞ்ப்⁴ஸ²க³மாத் நௌ ர்தோ³லாயமாநா தரங்கே³ண ஜலை​: பூர்ணாப⁴வச்ச| ");
INSERT INTO santam_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ததா³ ஸ நௌகாசஸ்²சாத்³பா⁴கே³ உபதா⁴நே ஸி²ரோ நிதா⁴ய நித்³ரித ஆஸீத் ததஸ்தே தம்ʼ ஜாக³ரயித்வா ஜக³து³​:, ஹே ப்ரபோ⁴, அஸ்மாகம்ʼ ப்ராணா யாந்தி கிமத்ர ப⁴வதஸ்²சிந்தா நாஸ்தி? ");
INSERT INTO santam_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ததா³ ஸ உத்தா²ய வாயும்ʼ தர்ஜிதவாந் ஸமுத்³ரஞ்சோக்தவாந் ஸா²ந்த​: ஸுஸ்தி²ரஸ்²ச ப⁴வ; ததோ வாயௌ நிவ்ருʼத்தே(அ)ப்³தி⁴ர்நிஸ்தரங்கோ³பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ததா³ ஸ தாநுவாச யூயம்ʼ குத ஏதாத்³ருʼக்ஸ²ங்காகுலா ப⁴வத? கிம்ʼ வோ விஸ்²வாஸோ நாஸ்தி? ");
INSERT INTO santam_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","தஸ்மாத்தே(அ)தீவபீ⁴தா​: பரஸ்பரம்ʼ வக்துமாரேபி⁴ரே, அஹோ வாயு​: ஸிந்து⁴ஸ்²சாஸ்ய நிதே³ஸ²க்³ராஹிணௌ கீத்³ருʼக³யம்ʼ மநுஜ​:| ");
INSERT INTO santam_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","அத² தூ ஸிந்து⁴பாரம்ʼ க³த்வா கி³தே³ரீயப்ரதே³ஸ² உபதஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","நௌகாதோ நிர்க³தமாத்ராத்³ அபவித்ரபூ⁴தக்³ரஸ்த ஏக​: ஸ்²மஸா²நாதே³த்ய தம்ʼ ஸாக்ஷாச் சகார| ");
INSERT INTO santam_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ஸ ஸ்²மஸா²நே(அ)வாத்ஸீத் கோபி தம்ʼ ஸ்²ருʼங்க²லேந ப³த்³வ்வா ஸ்தா²பயிதும்ʼ நாஸ²க்நோத்| ");
INSERT INTO santam_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ஜநைர்வாரம்ʼ நிக³டை³​: ஸ்²ருʼங்க²லைஸ்²ச ஸ ப³த்³தோ⁴பி ஸ்²ருʼங்க²லாந்யாக்ருʼஷ்ய மோசிதவாந் நிக³டா³நி ச ப⁴ம்ʼக்த்வா க²ண்ட³ம்ʼ க²ண்ட³ம்ʼ க்ருʼதவாந் கோபி தம்ʼ வஸீ²கர்த்தும்ʼ ந ஸ²ஸ²க| ");
INSERT INTO santam_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","தி³வாநிஸ²ம்ʼ ஸதா³ பர்வ்வதம்ʼ ஸ்²மஸா²நஞ்ச ப்⁴ரமித்வா சீத்ஸ²ப்³த³ம்ʼ க்ருʼதவாந் க்³ராவபி⁴ஸ்²ச ஸ்வயம்ʼ ஸ்வம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ஸ யீஸு²ம்ʼ தூ³ராத் பஸ்²யந்நேவ தா⁴வந் தம்ʼ ப்ரணநாம உசைருவம்ʼஸ்²சோவாச, ");
INSERT INTO santam_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ஹே ஸர்வ்வோபரிஸ்தே²ஸ்²வரபுத்ர யீஸோ² ப⁴வதா ஸஹ மே க​: ஸம்ப³ந்த⁴​:? அஹம்ʼ த்வாமீஸ்²வரேண ஸா²பயே மாம்ʼ மா யாதய| ");
INSERT INTO santam_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","யதோ யீஸு²ஸ்தம்ʼ கதி²தவாந் ரே அபவித்ரபூ⁴த, அஸ்மாந்நராத்³ ப³ஹிர்நிர்க³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","அத² ஸ தம்ʼ ப்ருʼஷ்டவாந் கிந்தே நாம? தேந ப்ரத்யுக்தம்ʼ வயமநேகே (அ)ஸ்மஸ்ததோ(அ)ஸ்மந்நாம பா³ஹிநீ| ");
INSERT INTO santam_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ததோஸ்மாந் தே³ஸா²ந்ந ப்ரேஷயேதி தே தம்ʼ ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ததா³நீம்ʼ பர்வ்வதம்ʼ நிகஷா ப்³ருʼஹந் வராஹவ்ரஜஸ்²சரந்நாஸீத்| ");
INSERT INTO santam_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","தஸ்மாத்³ பூ⁴தா விநயேந ஜக³து³​:, அமும்ʼ வராஹவ்ரஜம் ஆஸ்²ரயிதும் அஸ்மாந் ப்ரஹிணு| ");
INSERT INTO santam_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","யீஸு²நாநுஜ்ஞாதாஸ்தே(அ)பவித்ரபூ⁴தா ப³ஹிர்நிர்யாய வராஹவ்ரஜம்ʼ ப்ராவிஸ²ந் தத​: ஸர்வ்வே வராஹா வஸ்துதஸ்து ப்ராயோத்³விஸஹஸ்ரஸம்ʼங்க்²யகா​: கடகேந மஹாஜவாத்³ தா⁴வந்த​: ஸிந்தௌ⁴ ப்ராணாந் ஜஹு​:| ");
INSERT INTO santam_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","தஸ்மாத்³ வராஹபாலகா​: பலாயமாநா​: புரே க்³ராமே ச தத்³வார்த்தம்ʼ கத²யாஞ்சக்ரு​:| ததா³ லோகா க⁴டிதம்ʼ தத்கார்ய்யம்ʼ த்³ரஷ்டும்ʼ ப³ஹிர்ஜக்³மு​: ");
INSERT INTO santam_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","யீஸோ²​: ஸந்நிதி⁴ம்ʼ க³த்வா தம்ʼ பூ⁴தக்³ரஸ்தம் அர்தா²த்³ பா³ஹிநீபூ⁴தக்³ரஸ்தம்ʼ நரம்ʼ ஸவஸ்த்ரம்ʼ ஸசேதநம்ʼ ஸமுபவிஷ்டஞ்ச த்³ருʼृஷ்ட்வா பி³ப்⁴யு​:| ");
INSERT INTO santam_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ததோ த்³ருʼஷ்டதத்கார்ய்யலோகாஸ்தஸ்ய பூ⁴தக்³ரஸ்தநரஸ்ய வராஹவ்ரஜஸ்யாபி தாம்ʼ த⁴டநாம்ʼ வர்ணயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ததஸ்தே ஸ்வஸீமாதோ ப³ஹிர்க³ந்தும்ʼ யீஸு²ம்ʼ விநேதுமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","அத² தஸ்ய நௌகாரோஹணகாலே ஸ பூ⁴தமுக்தோ நா யீஸு²நா ஸஹ ஸ்தா²தும்ʼ ப்ரார்த²யதே; ");
INSERT INTO santam_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","கிந்து ஸ தமநநுமத்ய கதி²தவாந் த்வம்ʼ நிஜாத்மீயாநாம்ʼ ஸமீபம்ʼ க்³ருʼஹஞ்ச க³ச்ச² ப்ரபு⁴ஸ்த்வயி க்ருʼபாம்ʼ க்ருʼத்வா யாநி கர்ம்மாணி க்ருʼதவாந் தாநி தாந் ஜ்ஞாபய| ");
INSERT INTO santam_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","அத​: ஸ ப்ரஸ்தா²ய யீஸு²நா க்ருʼதம்ʼ தத்ஸர்வ்வாஸ்²சர்ய்யம்ʼ கர்ம்ம தி³காபலிதே³ஸே² ப்ரசாரயிதும்ʼ ப்ராரப்³த⁴வாந் தத​: ஸர்வ்வே லோகா ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","அநந்தரம்ʼ யீஸௌ² நாவா புநரந்யபார உத்தீர்ணே ஸிந்து⁴தடே ச திஷ்ட²தி ஸதி தத்ஸமீபே ப³ஹுலோகாநாம்ʼ ஸமாக³மோ(அ)பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","அபரம்ʼ யாயீர் நாம்நா கஸ்²சித்³ ப⁴ஜநக்³ருʼஹஸ்யாதி⁴ப ஆக³த்ய தம்ʼ த்³ருʼஷ்ட்வைவ சரணயோ​: பதித்வா ப³ஹு நிவேத்³ய கதி²தவாந்; ");
INSERT INTO santam_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","மம கந்யா ம்ருʼதப்ராயாபூ⁴த்³ அதோ ப⁴வாநேத்ய ததா³ரோக்³யாய தஸ்யா கா³த்ரே ஹஸ்தம் அர்பயது தேநைவ ஸா ஜீவிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ததா³ யீஸு²ஸ்தேந ஸஹ சலித​: கிந்து தத்பஸ்²சாத்³ ப³ஹுலோகாஸ்²சலித்வா தாத்³கா³த்ரே பதிதா​:| ");
INSERT INTO santam_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","அத² த்³வாத³ஸ²வர்ஷாணி ப்ரத³ரரோகே³ண ");
INSERT INTO santam_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ஸீ²ர்ணா சிகித்ஸகாநாம்ʼ நாநாசிகித்ஸாபி⁴ஸ்²ச து³​:க²ம்ʼ பு⁴க்தவதீ ச ஸர்வ்வஸ்வம்ʼ வ்யயித்வாபி நாரோக்³யம்ʼ ப்ராப்தா ச புநரபி பீடி³தாஸீச்ச ");
INSERT INTO santam_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","யா ஸ்த்ரீ ஸா யீஸோ² ர்வார்த்தாம்ʼ ப்ராப்ய மநஸாகத²யத் யத்³யஹம்ʼ தஸ்ய வஸ்த்ரமாத்ர ஸ்ப்ரஷ்டும்ʼ லபே⁴யம்ʼ ததா³ ரோக³ஹீநா ப⁴விஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","அதோஹேதோ​: ஸா லோகாரண்யமத்⁴யே தத்பஸ்²சாதா³க³த்ய தஸ்ய வஸ்த்ரம்ʼ பஸ்பர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","தேநைவ தத்க்ஷணம்ʼ தஸ்யா ரக்தஸ்ரோத​: ஸு²ஷ்கம்ʼ ஸ்வயம்ʼ தஸ்மாத்³ ரோகா³ந்முக்தா இத்யபி தே³ஹே(அ)நுபூ⁴தா| ");
INSERT INTO santam_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","அத² ஸ்வஸ்மாத் ஸ²க்தி ர்நிர்க³தா யீஸு²ரேதந்மநஸா ஜ்ஞாத்வா லோகநிவஹம்ʼ ப்ரதி முக²ம்ʼ வ்யாவ்ருʼத்ய ப்ருʼஷ்டவாந் கேந மத்³வஸ்த்ரம்ʼ ஸ்ப்ருʼஷ்டம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ததஸ்தஸ்ய ஸி²ஷ்யா ஊசு​: ப⁴வதோ வபுஷி லோகா​: ஸம்ʼக⁴ர்ஷந்தி தத்³ த்³ருʼஷ்ட்வா கேந மத்³வஸ்த்ரம்ʼ ஸ்ப்ருʼஷ்டமிதி குத​: கத²யதி? ");
INSERT INTO santam_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","கிந்து கேந தத் கர்ம்ம க்ருʼதம்ʼ தத்³ த்³ரஷ்டும்ʼ யீஸு²ஸ்²சதுர்தி³ஸோ² த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","தத​: ஸா ஸ்த்ரீ பீ⁴தா கம்பிதா ச ஸதீ ஸ்வஸ்யா ருக்ப்ரதிக்ரியா ஜாதேதி ஜ்ஞாத்வாக³த்ய தத்ஸம்முகே² பதித்வா ஸர்வ்வவ்ருʼத்தாந்தம்ʼ ஸத்யம்ʼ தஸ்மை கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ததா³நீம்ʼ யீஸு²ஸ்தாம்ʼ க³தி³தவாந், ஹே கந்யே தவ ப்ரதீதிஸ்த்வாம் அரோகா³மகரோத் த்வம்ʼ க்ஷேமேண வ்ரஜ ஸ்வரோகா³ந்முக்தா ச திஷ்ட²| ");
INSERT INTO santam_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","இதிவாக்யவத³நகாலே ப⁴ஜநக்³ருʼஹாதி⁴பஸ்ய நிவேஸ²நால் லோகா ஏத்யாதி⁴பம்ʼ ப³பா⁴ஷிரே தவ கந்யா ம்ருʼதா தஸ்மாத்³ கு³ரும்ʼ புந​: குத​: க்லிஸ்²நாஸி? ");
INSERT INTO santam_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","கிந்து யீஸு²ஸ்தத்³ வாக்யம்ʼ ஸ்²ருத்வைவ ப⁴ஜநக்³ருʼஹாதி⁴பம்ʼ க³தி³தவாந் மா பை⁴ஷீ​: கேவலம்ʼ விஸ்²வாஸிஹி| ");
INSERT INTO santam_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","அத² பிதரோ யாகூப்³ தத்³ப்⁴ராதா யோஹந் ச ஏதாந் விநா கமபி ஸ்வபஸ்²சாத்³ யாதும்ʼ நாந்வமந்யத| ");
INSERT INTO santam_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","தஸ்ய ப⁴ஜநக்³ருʼஹாதி⁴பஸ்ய நிவேஸ²நஸமீபம் ஆக³த்ய கலஹம்ʼ ப³ஹுரோத³நம்ʼ விலாபஞ்ச குர்வ்வதோ லோகாந் த³த³ர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","தஸ்மாந் நிவேஸ²நம்ʼ ப்ரவிஸ்²ய ப்ரோக்தவாந் யூயம்ʼ குத இத்த²ம்ʼ கலஹம்ʼ ரோத³நஞ்ச குருத²? கந்யா ந ம்ருʼதா நித்³ராதி| ");
INSERT INTO santam_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","தஸ்மாத்தே தமுபஜஹஸு​: கிந்து யீஸு²​: ஸர்வ்வாந ப³ஹிஷ்க்ருʼத்ய கந்யாயா​: பிதரௌ ஸ்வஸங்கி³நஸ்²ச க்³ருʼஹீத்வா யத்ர கந்யாஸீத் தத் ஸ்தா²நம்ʼ ப்ரவிஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","அத² ஸ தஸ்யா​: கந்யாயா ஹஸ்தௌ த்⁴ருʼத்வா தாம்ʼ ப³பா⁴ஷே டாலீதா² கூமீ, அர்த²தோ ஹே கந்யே த்வமுத்திஷ்ட² இத்யாஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","துநைவ தத்க்ஷணம்ʼ ஸா த்³வாத³ஸ²வர்ஷவயஸ்கா கந்யா போத்தா²ய சலிதுமாரேபே⁴, இத​: ஸர்வ்வே மஹாவிஸ்மயம்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","தத ஏதஸ்யை கிஞ்சித் கா²த்³யம்ʼ த³த்தேதி கத²யித்வா ஏதத்கர்ம்ம கமபி ந ஜ்ஞாபயதேதி த்³ருʼட⁴மாதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","அநந்தரம்ʼ ஸ தத்ஸ்தா²நாத் ப்ரஸ்தா²ய ஸ்வப்ரதே³ஸ²மாக³த​: ஸி²ஷ்யாஸ்²ச தத்பஸ்²சாத்³ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","அத² விஸ்²ராமவாரே ஸதி ஸ ப⁴ஜநக்³ருʼஹே உபதே³ஷ்டுமாரப்³த⁴வாந் ததோ(அ)நேகே லோகாஸ்தத்கதா²ம்ʼ ஸ்²ருத்வா விஸ்மித்ய ஜக³து³​:, அஸ்ய மநுஜஸ்ய ஈத்³ருʼஸீ² ஆஸ்²சர்ய்யக்ரியா கஸ்மாஜ் ஜாதா? ததா² ஸ்வகராப்⁴யாம் இத்த²மத்³பு⁴தம்ʼ கர்ம்ம கர்த்தாुம் ஏதஸ்மை கத²ம்ʼ ஜ்ஞாநம்ʼ த³த்தம்? ");
INSERT INTO santam_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","கிமயம்ʼ மரியம​: புத்ரஸ்தஜ்ஞா நோ? கிமயம்ʼ யாகூப்³-யோஸி-யிஹுதா³-ஸி²மோநாம்ʼ ப்⁴ராதா நோ? அஸ்ய ப⁴கி³ந்ய​: கிமிஹாஸ்மாபி⁴​: ஸஹ நோ? இத்த²ம்ʼ தே தத³ர்தே² ப்ரத்யூஹம்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ததா³ யீஸு²ஸ்தேப்⁴யோ(அ)கத²யத் ஸ்வதே³ஸ²ம்ʼ ஸ்வகுடும்பா³ந் ஸ்வபரிஜநாம்ʼஸ்²ச விநா குத்ராபி ப⁴விஷ்யத்³வாதீ³ அஸத்க்ருʼதோ ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","அபரஞ்ச தேஷாமப்ரத்யயாத் ஸ விஸ்மித​: கியதாம்ʼ ரோகி³ணாம்ʼ வபு​:ஷு ஹஸ்தம் அர்பயித்வா கேவலம்ʼ தேஷாமாரோக்³யகரணாத்³ அந்யத் கிமபி சித்ரகார்ய்யம்ʼ கர்த்தாம்ʼ ந ஸ²க்த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","அத² ஸ சதுர்தி³க்ஸ்த² க்³ராமாந் ப்⁴ரமித்வா உபதி³ஷ்டவாந் ");
INSERT INTO santam_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","த்³வாத³ஸ²ஸி²ஷ்யாந் ஆஹூய அமேத்⁴யபூ⁴தாந் வஸீ²கர்த்தாம்ʼ ஸ²க்திம்ʼ த³த்த்வா தேஷாம்ʼ த்³வௌ த்³வௌ ஜநோ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","புநரித்யாதி³ஸ²த்³ யூயம் ஏகைகாம்ʼ யஷ்டிம்ʼ விநா வஸ்த்ரஸம்ʼபுட​: பூப​: கடிப³ந்தே⁴ தாம்ரக²ண்ட³ஞ்ச ஏஷாம்ʼ கிமபி மா க்³ரஹ்லீத, ");
INSERT INTO santam_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","மார்க³யாத்ராயை பாதே³ஷூபாநஹௌ த³த்த்வா த்³வே உத்தரீயே மா பரித⁴த்³வ்வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","அபரமப்யுக்தம்ʼ தேந யூயம்ʼ யஸ்யாம்ʼ புர்ய்யாம்ʼ யஸ்ய நிவேஸ²நம்ʼ ப்ரவேக்ஷ்யத² தாம்ʼ புரீம்ʼ யாவந்ந த்யக்ஷ்யத² தாவத் தந்நிவேஸ²நே ஸ்தா²ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","தத்ர யதி³ கேபி யுஷ்மாகமாதித்²யம்ʼ ந வித³த⁴தி யுஷ்மாகம்ʼ கதா²ஸ்²ச ந ஸ்²ருʼண்வந்தி தர்ஹி தத்ஸ்தா²நாத் ப்ரஸ்தா²நஸமயே தேஷாம்ʼ விருத்³த⁴ம்ʼ ஸாக்ஷ்யம்ʼ தா³தும்ʼ ஸ்வபாதா³நாஸ்பா²ல்ய ரஜ​: ஸம்பாதயத; அஹம்ʼ யுஷ்மாந் யதா²ர்த²ம்ʼ வச்மி விசாரதி³நே தந்நக³ரஸ்யாவஸ்தா²த​: ஸிதோ³மாமோரயோ ர்நக³ரயோரவஸ்தா² ஸஹ்யதரா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","அத² தே க³த்வா லோகாநாம்ʼ மந​:பராவர்த்தநீ​: கதா² ப்ரசாரிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ஏவமநேகாந் பூ⁴தாம்ʼஸ்²ச த்யாஜிதவந்தஸ்ததா² தைலேந மர்த்³த³யித்வா ப³ஹூந் ஜநாநரோகா³நகார்ஷு​:| ");
INSERT INTO santam_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","இத்த²ம்ʼ தஸ்ய ஸுக்²யாதிஸ்²சதுர்தி³ஸோ² வ்யாப்தா ததா³ ஹேரோத்³ ராஜா தந்நிஸ²ம்ய கதி²தவாந், யோஹந் மஜ்ஜக​: ஸ்²மஸா²நாத்³ உத்தி²த அதோஹேதோஸ்தேந ஸர்வ்வா ஏதா அத்³பு⁴தக்ரியா​: ப்ரகாஸ²ந்தே| ");
INSERT INTO santam_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","அந்யே(அ)கத²யந் அயம் ஏலிய​:, கேபி கதி²தவந்த ஏஷ ப⁴விஷ்யத்³வாதீ³ யத்³வா ப⁴விஷ்யத்³வாதி³நாம்ʼ ஸத்³ருʼஸ² ஏகோயம்| ");
INSERT INTO santam_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","கிந்து ஹேரோத்³ இத்யாகர்ண்ய பா⁴ஷிதவாந் யஸ்யாஹம்ʼ ஸி²ரஸ்²சி²ந்நவாந் ஸ ஏவ யோஹநயம்ʼ ஸ ஸ்²மஸா²நாது³த³திஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","பூர்வ்வம்ʼ ஸ்வப்⁴ராது​: பி²லிபஸ்ய பத்ந்யா உத்³வாஹம்ʼ க்ருʼதவந்தம்ʼ ஹேரோத³ம்ʼ யோஹநவாதீ³த் ஸ்வபா⁴த்ருʼவதூ⁴ ர்ந விவாஹ்யா| ");
INSERT INTO santam_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","அத​: காரணாத் ஹேரோத்³ லோகம்ʼ ப்ரஹித்ய யோஹநம்ʼ த்⁴ருʼத்வா ப³ந்த⁴நாலயே ப³த்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ஹேரோதி³யா தஸ்மை யோஹநே ப்ரகுப்ய தம்ʼ ஹந்தும் ஐச்ச²த் கிந்து ந ஸ²க்தா, ");
INSERT INTO santam_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","யஸ்மாத்³ ஹேரோத்³ தம்ʼ தா⁴ர்ம்மிகம்ʼ ஸத்புருஷஞ்ச ஜ்ஞாத்வா ஸம்மந்ய ரக்ஷிதவாந்; தத்கதா²ம்ʼ ஸ்²ருத்வா தத³நுஸாரேண ப³ஹூநி கர்ம்மாணி க்ருʼதவாந் ஹ்ருʼஷ்டமநாஸ்தது³பதே³ஸ²ம்ʼ ஸ்²ருதவாம்ʼஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","கிந்து ஹேரோத்³ யதா³ ஸ்வஜந்மதி³நே ப்ரதா⁴நலோகேப்⁴ய​: ஸேநாநீப்⁴யஸ்²ச கா³லீல்ப்ரதே³ஸீ²யஸ்²ரேஷ்ட²லோகேப்⁴யஸ்²ச ராத்ரௌ போ⁴ஜ்யமேகம்ʼ க்ருʼதவாந் ");
INSERT INTO santam_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","தஸ்மிந் ஸு²ப⁴தி³நே ஹேரோதி³யாயா​: கந்யா ஸமேத்ய தேஷாம்ʼ ஸமக்ஷம்ʼ ஸம்ʼந்ருʼத்ய ஹேரோத³ஸ்தேந ஸஹோபவிஷ்டாநாஞ்ச தோஷமஜீஜநத் ததா ந்ருʼப​: கந்யாமாஹ ஸ்ம மத்தோ யத்³ யாசஸே ததே³வ துப்⁴யம்ʼ தா³ஸ்யே| ");
INSERT INTO santam_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ஸ²பத²ம்ʼ க்ருʼத்வாகத²யத் சேத்³ ராஜ்யார்த்³த⁴மபி யாசஸே தத³பி துப்⁴யம்ʼ தா³ஸ்யே| ");
INSERT INTO santam_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","தத​: ஸா ப³ஹி ர்க³த்வா ஸ்வமாதரம்ʼ பப்ரச்ச² கிமஹம்ʼ யாசிஷ்யே? ததா³ ஸாகத²யத் யோஹநோ மஜ்ஜகஸ்ய ஸி²ர​:| ");
INSERT INTO santam_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","அத² தூர்ணம்ʼ பூ⁴பஸமீபம் ஏத்ய யாசமாநாவத³த் க்ஷணேஸ்மிந் யோஹநோ மஜ்ஜகஸ்ய ஸி²ர​: பாத்ரே நிதா⁴ய தே³ஹி, ஏதத்³ யாசே(அ)ஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","தஸ்மாத் பூ⁴போ(அ)திது³​:கி²த​:, ததா²பி ஸ்வஸ²பத²ஸ்ய ஸஹபோ⁴ஜிநாஞ்சாநுரோதா⁴த் தத³நங்கீ³கர்த்தும்ʼ ந ஸ²க்த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","தத்க்ஷணம்ʼ ராஜா கா⁴தகம்ʼ ப்ரேஷ்ய தஸ்ய ஸி²ர ஆநேதுமாதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","தத​: ஸ காராகா³ரம்ʼ க³த்வா தச்சி²ரஸ்²சி²த்வா பாத்ரே நிதா⁴யாநீய தஸ்யை கந்யாயை த³த்தவாந் கந்யா ச ஸ்வமாத்ரே த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","அநநதரம்ʼ யோஹந​: ஸி²ஷ்யாஸ்தத்³வார்த்தாம்ʼ ப்ராப்யாக³த்ய தஸ்ய குணபம்ʼ ஸ்²மஸா²நே(அ)ஸ்தா²பயந்| ");
INSERT INTO santam_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","அத² ப்ரேஷிதா யீஸோ²​: ஸந்நிதௌ⁴ மிலிதா யத்³ யச் சக்ரு​: ஸி²க்ஷயாமாஸுஸ்²ச தத்ஸர்வ்வவார்த்தாஸ்தஸ்மை கதி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ஸ தாநுவாச யூயம்ʼ விஜநஸ்தா²நம்ʼ க³த்வா விஸ்²ராம்யத யதஸ்தத்ஸந்நிதௌ⁴ ப³ஹுலோகாநாம்ʼ ஸமாக³மாத் தே போ⁴க்தும்ʼ நாவகாஸ²ம்ʼ ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ததஸ்தே நாவா விஜநஸ்தா²நம்ʼ கு³ப்தம்ʼ க³க்³மு​:| ");
INSERT INTO santam_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ததோ லோகநிவஹஸ்தேஷாம்ʼ ஸ்தா²நாந்தரயாநம்ʼ த³த³ர்ஸ², அநேகே தம்ʼ பரிசித்ய நாநாபுரேப்⁴ய​: பதை³ர்வ்ரஜித்வா ஜவேந தைஷாமக்³ரே யீஸோ²​: ஸமீப உபதஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ததா³ யீஸு² ர்நாவோ ப³ஹிர்க³த்ய லோகாரண்யாநீம்ʼ த்³ருʼஷ்ட்வா தேஷு கருணாம்ʼ க்ருʼதவாந் யதஸ்தே(அ)ரக்ஷகமேஷா இவாஸந் ததா³ ஸ தாந நாநாப்ரஸங்கா³ந் உபதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","அத² தி³வாந்தே ஸதி ஸி²ஷ்யா ஏத்ய யீஸு²மூசிரே, இத³ம்ʼ விஜநஸ்தா²நம்ʼ தி³நஞ்சாவஸந்நம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","லோகாநாம்ʼ கிமபி கா²த்³யம்ʼ நாஸ்தி, அதஸ்²சதுர்தி³க்ஷு க்³ராமாந் க³ந்தும்ʼ போ⁴ஜ்யத்³ரவ்யாணி க்ரேதுஞ்ச ப⁴வாந் தாந் விஸ்ருʼஜது| ");
INSERT INTO santam_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ததா³ ஸ தாநுவாச யூயமேவ தாந் போ⁴ஜயத; ததஸ்தே ஜக³து³ ர்வயம்ʼ க³த்வா த்³விஸ²தஸம்ʼக்²யகை ர்முத்³ராபாதை³​: பூபாந் க்ரீத்வா கிம்ʼ தாந் போ⁴ஜயிஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ததா³ ஸ தாந் ப்ருʼஷ்ட²வாந் யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ கதி பூபா ஆஸதே? க³த்வா பஸ்²யத; ததஸ்தே த்³ருʼஷ்ட்வா தமவத³ந் பஞ்ச பூபா த்³வௌ மத்ஸ்யௌ ச ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ததா³ ஸ லோகாந் ஸ²ஸ்போபரி பம்ʼக்திபி⁴ருபவேஸ²யிதும் ஆதி³ஷ்டவாந், ");
INSERT INTO santam_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ததஸ்தே ஸ²தம்ʼ ஸ²தம்ʼ ஜநா​: பஞ்சாஸ²த் பஞ்சாஸ²ஜ்ஜநாஸ்²ச பம்ʼக்திபி⁴ ர்பு⁴வி ஸமுபவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","அத² ஸ தாந் பஞ்சபூபாந் மத்ஸ்யத்³வயஞ்ச த்⁴ருʼத்வா ஸ்வர்க³ம்ʼ பஸ்²யந் ஈஸ்²வரகு³ணாந் அந்வகீர்த்தயத் தாந் பூபாந் ப⁴ம்ʼக்த்வா லோகேப்⁴ய​: பரிவேஷயிதும்ʼ ஸி²ஷ்யேப்⁴யோ த³த்தவாந் த்³வா மத்ஸ்யௌ ச விப⁴ஜ்ய ஸர்வ்வேப்⁴யோ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","தத​: ஸர்வ்வே பு⁴க்த்வாத்ருʼப்யந்| ");
INSERT INTO santam_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","அநந்தரம்ʼ ஸி²ஷ்யா அவஸி²ஷ்டை​: பூபை ர்மத்ஸ்யைஸ்²ச பூர்ணாந் த்³வத³ஸ² ட³ல்லகாந் ஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","தே போ⁴க்தார​: ப்ராய​: பஞ்ச ஸஹஸ்ராணி புருஷா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","அத² ஸ லோகாந் விஸ்ருʼஜந்நேவ நாவமாரோடு⁴ம்ʼ ஸ்வஸ்மாத³க்³ரே பாரே பை³த்ஸைதா³புரம்ʼ யாதுஞ்ச ஸ்²ஷ்யிाந் வாட⁴மாதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ததா³ ஸ ஸர்வ்வாந் விஸ்ருʼஜ்ய ப்ரார்த²யிதும்ʼ பர்வ்வதம்ʼ க³த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","தத​: ஸந்த்⁴யாயாம்ʼ ஸத்யாம்ʼ நௌ​: ஸிந்து⁴மத்⁴ய உபஸ்தி²தா கிந்து ஸ ஏகாகீ ஸ்த²லே ஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","அத² ஸம்முக²வாதவஹநாத் ஸி²ஷ்யா நாவம்ʼ வாஹயித்வா பரிஸ்²ராந்தா இதி ஜ்ஞாத்வா ஸ நிஸா²சதுர்த²யாமே ஸிந்தூ⁴பரி பத்³ப்⁴யாம்ʼ வ்ரஜந் தேஷாம்ʼ ஸமீபமேத்ய தேஷாமக்³ரே யாதும் உத்³யத​:| ");
INSERT INTO santam_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","கிந்து ஸி²ஷ்யா​: ஸிந்தூ⁴பரி தம்ʼ வ்ரஜந்தம்ʼ த்³ருʼஷ்ட்வா பூ⁴தமநுமாய ருருவு​:, ");
INSERT INTO santam_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","யத​: ஸர்வ்வே தம்ʼ த்³ருʼஷ்ட்வா வ்யாகுலிதா​:| அதஏவ யீஸு²ஸ்தத்க்ஷணம்ʼ தை​: ஸஹாலப்ய கதி²தவாந், ஸுஸ்தி²ரா பூ⁴த, அயமஹம்ʼ மா பை⁴ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","அத² நௌகாமாருஹ்ய தஸ்மிந் தேஷாம்ʼ ஸந்நிதி⁴ம்ʼ க³தே வாதோ நிவ்ருʼத்த​:; தஸ்மாத்தே மந​:ஸு விஸ்மிதா ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","யதஸ்தே மநஸாம்ʼ காடி²ந்யாத் தத் பூபீயம் ஆஸ்²சர்ய்யம்ʼ கர்ம்ம ந விவிக்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","அத² தே பாரம்ʼ க³த்வா கி³நேஷரத்ப்ரதே³ஸ²மேத்ய தட உபஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","தேஷு நௌகாதோ ப³ஹிர்க³தேஷு தத்ப்ரதே³ஸீ²யா லோகாஸ்தம்ʼ பரிசித்ய ");
INSERT INTO santam_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","சதுர்தி³க்ஷு தா⁴வந்தோ யத்ர யத்ர ரோகி³ணோ நரா ஆஸந் தாந் ஸர்வ்வாந க²ட்வோபரி நிதா⁴ய யத்ர குத்ரசித் தத்³வார்த்தாம்ʼ ப்ராபு​: தத் ஸ்தா²நம் ஆநேதும் ஆரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ததா² யத்ர யத்ர க்³ராமே யத்ர யத்ர புரே யத்ர யத்ர பல்ல்யாஞ்ச தேந ப்ரவேஸ²​: க்ருʼதஸ்தத்³வர்த்மமத்⁴யே லோகா​: பீடி³தாந் ஸ்தா²பயித்வா தஸ்ய சேலக்³ரந்தி²மாத்ரம்ʼ ஸ்ப்ரஷ்டும் தேஷாமர்தே² தத³நுஜ்ஞாம்ʼ ப்ரார்த²யந்த​: யாவந்தோ லோகா​: பஸ்ப்ருʼஸு²ஸ்தாவந்த ஏவ க³தா³ந்முக்தா​:| ");
INSERT INTO santam_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","அநந்தரம்ʼ யிரூஸா²லம ஆக³தா​: பி²ரூஸி²நோ(அ)த்⁴யாபகாஸ்²ச யீஸோ²​: ஸமீபம் ஆக³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","தே தஸ்ய கியத​: ஸி²ஷ்யாந் அஸு²சிகரைரர்தா²த³ அப்ரக்ஷாலிதஹஸ்தை ர்பு⁴ஞ்ஜதோ த்³ருʼஷ்ட்வா தாநதூ³ஷயந்| ");
INSERT INTO santam_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","யத​: பி²ரூஸி²ந​: ஸர்வ்வயிஹூதீ³யாஸ்²ச ப்ராசாம்ʼ பரம்பராக³தவாக்யம்ʼ ஸம்மந்ய ப்ரதலேந ஹஸ்தாந் அப்ரக்ஷால்ய ந பு⁴ஞ்ஜதே| ");
INSERT INTO santam_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ஆபநாதா³க³த்ய மஜ்ஜநம்ʼ விநா ந கா²த³ந்தி; ததா² பாநபாத்ராணாம்ʼ ஜலபாத்ராணாம்ʼ பித்தலபாத்ராணாம் ஆஸநாநாஞ்ச ஜலே மஜ்ஜநம் இத்யாத³யோந்யேபி ப³ஹவஸ்தேஷாமாசாரா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","தே பி²ரூஸி²நோ(அ)த்⁴யாபகாஸ்²ச யீஸு²ம்ʼ பப்ரச்சு²​:, தவ ஸி²ஷ்யா​: ப்ராசாம்ʼ பரம்பராக³தவாக்யாநுஸாரேண நாசரந்தோ(அ)ப்ரக்ஷாலிதகரை​: குதோ பு⁴ஜம்ʼதே? ");
INSERT INTO santam_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","தத​: ஸ ப்ரத்யுவாச கபடிநோ யுஷ்மாந் உத்³தி³ஸ்²ய யிஸ²யியப⁴விஷ்யத்³வாதீ³ யுக்தமவாதீ³த்| யதா² ஸ்வகீயைரத⁴ரைரேதே ஸம்மந்யநதே ஸதை³வ மாம்ʼ| கிந்து மத்தோ விப்ரகர்ஷே ஸந்தி தேஷாம்ʼ மநாம்ʼஸி ச| ");
INSERT INTO santam_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ஸி²க்ஷயந்தோ பி³தீ⁴ந் ந்நாஜ்ஞா ப⁴ஜந்தே மாம்ʼ முதை⁴வ தே| ");
INSERT INTO santam_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","யூயம்ʼ ஜலபாத்ரபாநபாத்ராதீ³நி மஜ்ஜயந்தோ மநுஜபரம்பராக³தவாக்யம்ʼ ரக்ஷத² கிந்து ஈஸ்²வராஜ்ஞாம்ʼ லம்ʼக⁴த்⁴வே; அபரா ஈத்³ருʼஸ்²யோநேகா​: க்ரியா அபி குருத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","அந்யஞ்சாகத²யத் யூயம்ʼ ஸ்வபரம்பராக³தவாக்யஸ்ய ரக்ஷார்த²ம்ʼ ஸ்பஷ்டரூபேண ஈஸ்²வராஜ்ஞாம்ʼ லோபயத²| ");
INSERT INTO santam_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","யதோ மூஸாத்³வாரா ப்ரோக்தமஸ்தி ஸ்வபிதரௌ ஸம்மந்யத்⁴வம்ʼ யஸ்து மாதரம்ʼ பிதரம்ʼ வா து³ர்வ்வாக்யம்ʼ வக்தி ஸ நிதாந்தம்ʼ ஹந்யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","கிந்து மதீ³யேந யேந த்³ரவ்யேண தவோபகாரோப⁴வத் தத் கர்ப்³பா³ணமர்தா²த்³ ஈஸ்²வராய நிவேதி³தம் இத³ம்ʼ வாக்யம்ʼ யதி³ கோபி பிதரம்ʼ மாதரம்ʼ வா வக்தி ");
INSERT INTO santam_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","தர்ஹி யூயம்ʼ மாது​: பிது ர்வோபகாரம்ʼ கர்த்தாம்ʼ தம்ʼ வாரயத²| ");
INSERT INTO santam_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","இத்த²ம்ʼ ஸ்வப்ரசாரிதபரம்பராக³தவாக்யேந யூயம் ஈஸ்²வராஜ்ஞாம்ʼ முதா⁴ வித⁴த்³வ்வே, ஈத்³ருʼஸா²ந்யந்யாந்யநேகாநி கர்ம்மாணி குருத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","அத² ஸ லோகாநாஹூய ப³பா⁴ஷே யூயம்ʼ ஸர்வ்வே மத்³வாக்யம்ʼ ஸ்²ருʼணுத பு³த்⁴யத்⁴வஞ்ச| ");
INSERT INTO santam_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","பா³ஹ்யாத³ந்தரம்ʼ ப்ரவிஸ்²ய நரமமேத்⁴யம்ʼ கர்த்தாம்ʼ ஸ²க்நோதி ஈத்³ருʼஸ²ம்ʼ கிமபி வஸ்து நாஸ்தி, வரம் அந்தராத்³ ப³ஹிர்க³தம்ʼ யத்³வஸ்து தந்மநுஜம் அமேத்⁴யம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","யஸ்ய ஸ்²ரோதும்ʼ ஸ்²ரோத்ரே ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","தத​: ஸ லோகாந் ஹித்வா க்³ருʼஹமத்⁴யம்ʼ ப்ரவிஷ்டஸ்ததா³ ஸி²ஷ்யாஸ்தத்³ருʼஷ்டாந்தவாக்யார்த²ம்ʼ பப்ரச்சு²​:| ");
INSERT INTO santam_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","தஸ்மாத் ஸ தாந் ஜகா³த³ யூயமபி கிமேதாத்³ருʼக³போ³தா⁴​:? கிமபி த்³ரவ்யம்ʼ பா³ஹ்யாத³ந்தரம்ʼ ப்ரவிஸ்²ய நரமமேத்⁴யம்ʼ கர்த்தாம்ʼ ந ஸ²க்நோதி கதா²மிமாம்ʼ கிம்ʼ ந பு³த்⁴யத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","தத் தத³ந்தர்ந ப்ரவிஸ²தி கிந்து குக்ஷிமத்⁴யம்ʼ ப்ரவிஸ²தி ஸே²ஷே ஸர்வ்வபு⁴க்தவஸ்துக்³ராஹிணி ப³ஹிர்தே³ஸே² நிர்யாதி| ");
INSERT INTO santam_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","அபரமப்யவாதீ³த்³ யந்நராந்நிரேதி ததே³வ நரமமேத்⁴யம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","யதோ(அ)ந்தராத்³ அர்தா²ந் மாநவாநாம்ʼ மநோப்⁴ய​: குசிந்தா பரஸ்த்ரீவேஸ்²யாக³மநம்ʼ ");
INSERT INTO santam_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","நரவத⁴ஸ்²சௌர்ய்யம்ʼ லோபோ⁴ து³ஷ்டதா ப்ரவஞ்சநா காமுகதா குத்³ருʼஷ்டிரீஸ்²வரநிந்தா³ க³ர்வ்வஸ்தம இத்யாதீ³நி நிர்க³ச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ஏதாநி ஸர்வ்வாணி து³ரிதாந்யந்தராதே³த்ய நரமமேத்⁴யம்ʼ குர்வ்வந்தி| ");
INSERT INTO santam_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","அத² ஸ உத்தா²ய தத்ஸ்தா²நாத் ஸோரஸீதோ³ந்புரப்ரதே³ஸ²ம்ʼ ஜகா³ம தத்ர கிமபி நிவேஸ²நம்ʼ ப்ரவிஸ்²ய ஸர்வ்வைரஜ்ஞாத​: ஸ்தா²தும்ʼ மதிஞ்சக்ரே கிந்து கு³ப்த​: ஸ்தா²தும்ʼ ந ஸ²ஸா²க| ");
INSERT INTO santam_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","யத​: ஸுரபை²நிகீதே³ஸீ²யயூநாநீவம்ʼஸோ²த்³ப⁴வஸ்த்ரியா​: கந்யா பூ⁴தக்³ரஸ்தாஸீத்| ஸா ஸ்த்ரீ தத்³வார்த்தாம்ʼ ப்ராப்ய தத்ஸமீபமாக³த்ய தச்சரணயோ​: பதித்வா ");
INSERT INTO santam_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ஸ்வகந்யாதோ பூ⁴தம்ʼ நிராகர்த்தாம்ʼ தஸ்மிந் விநயம்ʼ க்ருʼதவதீ| ");
INSERT INTO santam_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","கிந்து யீஸு²ஸ்தாமவத³த் ப்ரத²மம்ʼ பா³லகாஸ்த்ருʼப்யந்து யதோ பா³லகாநாம்ʼ கா²த்³யம்ʼ க்³ருʼஹீத்வா குக்குரேப்⁴யோ நிக்ஷேபோ(அ)நுசித​:| ");
INSERT INTO santam_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ததா³ ஸா ஸ்த்ரீ தமவாதீ³த் போ⁴​: ப்ரபோ⁴ தத் ஸத்யம்ʼ ததா²பி மஞ்சாத⁴​:ஸ்தா²​: குக்குரா பா³லாநாம்ʼ கரபதிதாநி கா²த்³யக²ண்டா³நி கா²த³ந்தி| ");
INSERT INTO santam_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","தத​: ஸோ(அ)கத²யத்³ ஏதத்கதா²ஹேதோ​: ஸகுஸ²லா யாஹி தவ கந்யாம்ʼ த்யக்த்வா பூ⁴தோ க³த​:| ");
INSERT INTO santam_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","அத² ஸா ஸ்த்ரீ க்³ருʼஹம்ʼ க³த்வா கந்யாம்ʼ பூ⁴தத்யக்தாம்ʼ ஸ²ய்யாஸ்தி²தாம்ʼ த³த³ர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","புநஸ்²ச ஸ ஸோரஸீதோ³ந்புரப்ரதே³ஸா²த் ப்ரஸ்தா²ய தி³காபலிதே³ஸ²ஸ்ய ப்ராந்தரபா⁴கே³ந கா³லீல்ஜலதே⁴​: ஸமீபம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ததா³ லோகைரேகம்ʼ ப³தி⁴ரம்ʼ கத்³வத³ஞ்ச நரம்ʼ தந்நிகடமாநீய தஸ்ய கா³த்ரே ஹஸ்தமர்பயிதும்ʼ விநய​: க்ருʼத​:| ");
INSERT INTO santam_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ததோ யீஸு² ர்லோகாரண்யாத் தம்ʼ நிர்ஜநமாநீய தஸ்ய கர்ணயோங்கு³லீ ர்த³தௌ³ நிஷ்டீ²வம்ʼ த³த்த்வா ச தஜ்ஜிஹ்வாம்ʼ பஸ்பர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","அநந்தரம்ʼ ஸ்வர்க³ம்ʼ நிரீக்ஷ்ய தீ³ர்க⁴ம்ʼ நிஸ்²வஸ்ய தமவத³த் இதப²த​: அர்தா²ந் முக்தோ பூ⁴யாத்| ");
INSERT INTO santam_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ததஸ்தத்க்ஷணம்ʼ தஸ்ய கர்ணௌ முக்தௌ ஜிஹ்வாயாஸ்²ச ஜாட்³யாபக³மாத் ஸ ஸுஸ்பஷ்டவாக்யமகத²யத்| ");
INSERT INTO santam_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","அத² ஸ தாந் வாட⁴மித்யாதி³தே³ஸ² யூயமிமாம்ʼ கதா²ம்ʼ கஸ்மைசித³பி மா கத²யத, கிந்து ஸ யதி ந்யஷேத⁴த் தே ததி பா³ஹுல்யேந ப்ராசாரயந்; ");
INSERT INTO santam_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","தே(அ)திசமத்க்ருʼத்ய பரஸ்பரம்ʼ கத²யாமாஸு​: ஸ ப³தி⁴ராய ஸ்²ரவணஸ²க்திம்ʼ மூகாய ச கத²நஸ²க்திம்ʼ த³த்த்வா ஸர்வ்வம்ʼ கர்ம்மோத்தமரூபேண சகார| ");
INSERT INTO santam_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ததா³ தத்ஸமீபம்ʼ ப³ஹவோ லோகா ஆயாதா அதஸ்தேஷாம்ʼ போ⁴ஜ்யத்³ரவ்யாபா⁴வாத்³ யீஸு²​: ஸி²ஷ்யாநாஹூய ஜகா³த³,| ");
INSERT INTO santam_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","லோகநிவஹே மம க்ருʼபா ஜாயதே தே தி³நத்ரயம்ʼ மயா ஸார்த்³த⁴ம்ʼ ஸந்தி தேஷாம்ʼ போ⁴ஜ்யம்ʼ கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","தேஷாம்ʼ மத்⁴யே(அ)நேகே தூ³ராத்³ ஆக³தா​:, அபு⁴க்தேஷு தேஷு மயா ஸ்வக்³ருʼஹமபி⁴ப்ரஹிதேஷு தே பதி² க்லமிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ஸி²ஷ்யா அவாதி³ஷு​:, ஏதாவதோ லோகாந் தர்பயிதும் அத்ர ப்ரந்தரே பூபாந் ப்ராப்தும்ʼ கேந ஸ²க்யதே? ");
INSERT INTO santam_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","தத​: ஸ தாந் பப்ரச்ச² யுஷ்மாகம்ʼ கதி பூபா​: ஸந்தி? தே(அ)கத²யந் ஸப்த| ");
INSERT INTO santam_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","தத​: ஸ தால்லோகாந் பு⁴வி ஸமுபவேஷ்டும் ஆதி³ஸ்²ய தாந் ஸப்த பூபாந் த்⁴ருʼத்வா ஈஸ்²வரகு³ணாந் அநுகீர்த்தயாமாஸ, ப⁴ம்ʼக்த்வா பரிவேஷயிதும்ʼ ஸி²ஷ்யாந் ப்ரதி த³தௌ³, ததஸ்தே லோகேப்⁴ய​: பரிவேஷயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ததா² தேஷாம்ʼ ஸமீபே யே க்ஷுத்³ரமத்ஸ்யா ஆஸந் தாநப்யாதா³ய ஈஸ்²வரகு³ணாந் ஸம்ʼகீர்த்ய பரிவேஷயிதும் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ததோ லோகா பு⁴க்த்வா த்ருʼப்திம்ʼ க³தா அவஸி²ஷ்டகா²த்³யை​: பூர்ணா​: ஸப்தட³ல்லகா க்³ருʼஹீதாஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ஏதே போ⁴க்தார​: ப்ராயஸ்²சது​: ஸஹஸ்ரபுருஷா ஆஸந் தத​: ஸ தாந் விஸஸர்ஜ| ");
INSERT INTO santam_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","அத² ஸ ஸி²ஷ்ய​: ஸஹ நாவமாருஹ்ய த³ல்மாநூதா²ஸீமாமாக³த​:| ");
INSERT INTO santam_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","தத​: பரம்ʼ பி²ரூஸி²ந ஆக³த்ய தேந ஸஹ விவத³மாநாஸ்தஸ்ய பரீக்ஷார்த²ம் ஆகாஸீ²யசிஹ்நம்ʼ த்³ரஷ்டும்ʼ யாசிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ததா³ ஸோ(அ)ந்தர்தீ³ர்க⁴ம்ʼ நிஸ்²வஸ்யாகத²யத், ஏதே வித்³யமாநநரா​: குதஸ்²சிந்ஹம்ʼ ம்ருʼக³யந்தே? யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ ப்³ரவீமி லோகாநேதாந் கிமபி சிஹ்நம்ʼ ந த³ர்ஸ²யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","அத² தாந் ஹித்வா புந ர்நாவம் ஆருஹ்ய பாரமகா³த்| ");
INSERT INTO santam_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ஏதர்ஹி ஸி²ஷ்யை​: பூபேஷு விஸ்ம்ருʼதேஷு நாவி தேஷாம்ʼ ஸந்நிதௌ⁴ பூப ஏகஏவ ஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ததா³நீம்ʼ யீஸு²ஸ்தாந் ஆதி³ஷ்டவாந் பி²ரூஸி²நாம்ʼ ஹேரோத³ஸ்²ச கிண்வம்ʼ ப்ரதி ஸதர்கா​: ஸாவதா⁴நாஸ்²ச ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ததஸ்தே(அ)ந்யோந்யம்ʼ விவேசநம்ʼ கர்தும் ஆரேபி⁴ரே, அஸ்மாகம்ʼ ஸந்நிதௌ⁴ பூபோ நாஸ்தீதி ஹேதோரித³ம்ʼ கத²யதி| ");
INSERT INTO santam_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","தத்³ பு³த்³வ்வா யீஸு²ஸ்தேப்⁴யோ(அ)கத²யத் யுஷ்மாகம்ʼ ஸ்தா²நே பூபாபா⁴வாத் குத இத்த²ம்ʼ விதர்கயத²? யூயம்ʼ கிமத்³யாபி கிமபி ந ஜாநீத²? போ³த்³து⁴ஞ்ச ந ஸ²க்நுத²? யாவத³த்³ய கிம்ʼ யுஷ்மாகம்ʼ மநாம்ʼஸி கடி²நாநி ஸந்தி? ");
INSERT INTO santam_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ஸத்ஸு நேத்ரேஷு கிம்ʼ ந பஸ்²யத²? ஸத்ஸு கர்ணேஷு கிம்ʼ ந ஸ்²ருʼணுத²? ந ஸ்மரத² ச? ");
INSERT INTO santam_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","யதா³ஹம்ʼ பஞ்சபூபாந் பஞ்சஸஹஸ்ராணாம்ʼ புருஷாணாம்ʼ மத்⁴யே ப⁴ம்ʼக்த்வா த³த்தவாந் ததா³நீம்ʼ யூயம் அவஸி²ஷ்டபூபை​: பூர்ணாந் கதி ட³ல்லகாந் க்³ருʼஹீதவந்த​:? தே(அ)கத²யந் த்³வாத³ஸ²ட³ல்லகாந்| ");
INSERT INTO santam_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","அபரஞ்ச யதா³ சது​:ஸஹஸ்ராணாம்ʼ புருஷாணாம்ʼ மத்⁴யே பூபாந் ப⁴ம்ʼக்த்வாத³தா³ம்ʼ ததா³ யூயம் அதிரிக்தபூபாநாம்ʼ கதி ட³ல்லகாந் க்³ருʼஹீதவந்த​:? தே கத²யாமாஸு​: ஸப்தட³ல்லகாந்| ");
INSERT INTO santam_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ததா³ ஸ கதி²தவாந் தர்ஹி யூயம் அது⁴நாபி குதோ போ³த்³வ்வும்ʼ ந ஸ²க்நுத²? ");
INSERT INTO santam_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","அநந்தரம்ʼ தஸ்மிந் பை³த்ஸைதா³நக³ரே ப்ராப்தே லோகா அந்த⁴மேகம்ʼ நரம்ʼ தத்ஸமீபமாநீய தம்ʼ ஸ்ப்ரஷ்டும்ʼ தம்ʼ ப்ரார்த²யாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ததா³ தஸ்யாந்த⁴ஸ்ய கரௌ க்³ருʼஹீத்வா நக³ராத்³ ப³ஹிர்தே³ஸ²ம்ʼ தம்ʼ நீதவாந்; தந்நேத்ரே நிஷ்டீ²வம்ʼ த³த்த்வா தத்³கா³த்ரே ஹஸ்தாவர்பயித்வா தம்ʼ பப்ரச்ச², கிமபி பஸ்²யஸி? ");
INSERT INTO santam_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ஸ நேத்ரே உந்மீல்ய ஜகா³த³, வ்ருʼக்ஷவத் மநுஜாந் க³ச்ச²தோ நிரீக்ஷே| ");
INSERT INTO santam_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ததோ யீஸு²​: புநஸ்தஸ்ய நயநயோ ர்ஹஸ்தாவர்பயித்வா தஸ்ய நேத்ரே உந்மீலயாமாஸ; தஸ்மாத் ஸ ஸ்வஸ்தோ² பூ⁴த்வா ஸ்பஷ்டரூபம்ʼ ஸர்வ்வலோகாந் த³த³ர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","தத​: பரம்ʼ த்வம்ʼ க்³ராமம்ʼ மா க³ச்ச² க்³ராமஸ்த²ம்ʼ கமபி ச கிமப்யநுக்த்வா நிஜக்³ருʼஹம்ʼ யாஹீத்யாதி³ஸ்²ய யீஸு²ஸ்தம்ʼ நிஜக்³ருʼஹம்ʼ ப்ரஹிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","அநந்தரம்ʼ ஸி²ஷ்யை​: ஸஹிதோ யீஸு²​: கைஸரீயாபி²லிபிபுரம்ʼ ஜகா³ம, பதி² க³ச்ச²ந் தாநப்ருʼச்ச²த் கோ(அ)ஹம் அத்ர லோகா​: கிம்ʼ வத³ந்தி? ");
INSERT INTO santam_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","தே ப்ரத்யூசு​: த்வாம்ʼ யோஹநம்ʼ மஜ்ஜகம்ʼ வத³ந்தி கிந்து கேபி கேபி ஏலியம்ʼ வத³ந்தி; அபரே கேபி கேபி ப⁴விஷ்யத்³வாதி³நாம் ஏகோ ஜந இதி வத³ந்தி| ");
INSERT INTO santam_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","அத² ஸ தாநப்ருʼச்ச²த் கிந்து கோஹம்? இத்யத்ர யூயம்ʼ கிம்ʼ வத³த²? ததா³ பிதர​: ப்ரத்யவத³த் ப⁴வாந் அபி⁴ஷிக்தஸ்த்ராதா| ");
INSERT INTO santam_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","தத​: ஸ தாந் கா³ட⁴மாதி³ஸ²த்³ யூயம்ʼ மம கதா² கஸ்மைசித³பி மா கத²யத| ");
INSERT INTO santam_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","மநுஷ்யபுத்ரேணாவஸ்²யம்ʼ ப³ஹவோ யாதநா போ⁴க்தவ்யா​: ப்ராசீநலோகை​: ப்ரதா⁴நயாஜகைரத்⁴யாபகைஸ்²ச ஸ நிந்தி³த​: ஸந் கா⁴தயிஷ்யதே த்ருʼதீயதி³நே உத்தா²ஸ்யதி ச, யீஸு²​: ஸி²ஷ்யாநுபதே³ஷ்டுமாரப்⁴ய கதா²மிமாம்ʼ ஸ்பஷ்டமாசஷ்ட| ");
INSERT INTO santam_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","தஸ்மாத் பிதரஸ்தஸ்ய ஹஸ்தௌ த்⁴ருʼத்வா தம்ʼ தர்ஜ்ஜிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","கிந்து ஸ முக²ம்ʼ பராவர்த்ய ஸி²ஷ்யக³ணம்ʼ நிரீக்ஷ்ய பிதரம்ʼ தர்ஜயித்வாவாதீ³த்³ தூ³ரீப⁴வ விக்⁴நகாரிந் ஈஸ்²வரீயகார்ய்யாத³பி மநுஷ்யகார்ய்யம்ʼ துப்⁴யம்ʼ ரோசததராம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","அத² ஸ லோகாந் ஸி²ஷ்யாம்ʼஸ்²சாஹூய ஜகா³த³ ய​: கஸ்²சிந் மாமநுக³ந்தும் இச்ச²தி ஸ ஆத்மாநம்ʼ தா³ம்யது, ஸ்வக்ருஸ²ம்ʼ க்³ருʼஹீத்வா மத்பஸ்²சாத்³ ஆயாது| ");
INSERT INTO santam_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","யதோ ய​: கஸ்²சித் ஸ்வப்ராணம்ʼ ரக்ஷிதுமிச்ச²தி ஸ தம்ʼ ஹாரயிஷ்யதி, கிந்து ய​: கஸ்²சிந் மத³ர்த²ம்ʼ ஸுஸம்ʼவாதா³ர்த²ஞ்ச ப்ராணம்ʼ ஹாரயதி ஸ தம்ʼ ரக்ஷிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","அபரஞ்ச மநுஜ​: ஸர்வ்வம்ʼ ஜக³த் ப்ராப்ய யதி³ ஸ்வப்ராணம்ʼ ஹாரயதி தர்ஹி தஸ்ய கோ லாப⁴​:? ");
INSERT INTO santam_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","நர​: ஸ்வப்ராணவிநிமயேந கிம்ʼ தா³தும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ஏதேஷாம்ʼ வ்யபி⁴சாரிணாம்ʼ பாபிநாஞ்ச லோகாநாம்ʼ ஸாக்ஷாத்³ யதி³ கோபி மாம்ʼ மத்கதா²ஞ்ச லஜ்ஜாஸ்பத³ம்ʼ ஜாநாதி தர்ஹி மநுஜபுத்ரோ யதா³ த⁴ர்ம்மதூ³தை​: ஸஹ பிது​: ப்ரபா⁴வேணாக³மிஷ்யதி ததா³ ஸோபி தம்ʼ லஜ்ஜாஸ்பத³ம்ʼ ஜ்ஞாஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","அத² ஸ தாநவாதீ³த் யுஷ்மப்⁴யமஹம்ʼ யதா²ர்த²ம்ʼ கத²யாமி, ஈஸ்²வரராஜ்யம்ʼ பராக்ரமேணோபஸ்தி²தம்ʼ ந த்³ருʼஷ்ட்வா ம்ருʼத்யும்ʼ நாஸ்வாதி³ஷ்யந்தே, அத்ர த³ண்டா³யமாநாநாம்ʼ மத்⁴யேபி தாத்³ருʼஸா² லோகா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","அத² ஷட்³தி³நேப்⁴ய​: பரம்ʼ யீஸு²​: பிதரம்ʼ யாகூப³ம்ʼ யோஹநஞ்ச க்³ருʼஹீத்வா கி³ரேருச்சஸ்ய நிர்ஜநஸ்தா²நம்ʼ க³த்வா தேஷாம்ʼ ப்ரத்யக்ஷே மூர்த்யந்தரம்ʼ த³தா⁴ர| ");
INSERT INTO santam_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ததஸ்தஸ்ய பரிதே⁴யம் ஈத்³ருʼஸ²ம் உஜ்ஜ்வலஹிமபாணட³ரம்ʼ ஜாதம்ʼ யத்³ ஜக³தி கோபி ரஜகோ ந தாத்³ருʼக் பாணட³ரம்ʼ கர்த்தாம்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","அபரஞ்ச ஏலியோ மூஸாஸ்²ச தேப்⁴யோ த³ர்ஸ²நம்ʼ த³த்த்வா யீஸு²நா ஸஹ கத²நம்ʼ கர்த்துமாரேபா⁴தே| ");
INSERT INTO santam_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ததா³ பிதரோ யீஸு²மவாதீ³த் ஹே கு³ரோ(அ)ஸ்மாகமத்ர ஸ்தி²திருத்தமா, ததஏவ வயம்ʼ த்வத்க்ருʼதே ஏகாம்ʼ மூஸாக்ருʼதே ஏகாம் ஏலியக்ருʼதே சைகாம்ʼ, ஏதாஸ்திஸ்ர​: குடீ ர்நிர்ம்மாம| ");
INSERT INTO santam_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","கிந்து ஸ யது³க்தவாந் தத் ஸ்வயம்ʼ ந பு³பு³தே⁴ தத​: ஸர்வ்வே பி³ப⁴யாஞ்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ஏதர்ஹி பயோத³ஸ்தாந் சா²த³யாமாஸ, மமயாம்ʼ ப்ரிய​: புத்ர​: கதா²ஸு தஸ்ய மநாம்ʼஸி நிவேஸ²யதேதி நபோ⁴வாணீ தந்மேத்³யாந்நிர்யயௌ| ");
INSERT INTO santam_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","அத² ஹடா²த்தே சதுர்தி³ஸோ² த்³ருʼஷ்ட்வா யீஸு²ம்ʼ விநா ஸ்வை​: ஸஹிதம்ʼ கமபி ந த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","தத​: பரம்ʼ கி³ரேரவரோஹணகாலே ஸ தாந் கா³ட⁴ம் தூ³த்யாதி³தே³ஸ² யாவந்நரஸூநோ​: ஸ்²மஸா²நாது³த்தா²நம்ʼ ந ப⁴வதி, தாவத் த³ர்ஸ²நஸ்யாஸ்ய வார்த்தா யுஷ்மாபி⁴​: கஸ்மைசித³பி ந வக்தவ்யா| ");
INSERT INTO santam_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ததா³ ஸ்²மஸா²நாது³த்தா²நஸ்ய கோபி⁴ப்ராய இதி விசார்ய்ய தே தத்³வாக்யம்ʼ ஸ்வேஷு கோ³பாயாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","அத² தே யீஸு²ம்ʼ பப்ரச்சு²​: ப்ரத²மத ஏலியேநாக³ந்தவ்யம் இதி வாக்யம்ʼ குத உபாத்⁴யாயா ஆஹு​:? ");
INSERT INTO santam_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ததா³ ஸ ப்ரத்யுவாச , ஏலிய​: ப்ரத²மமேத்ய ஸர்வ்வகார்ய்யாணி ஸாத⁴யிஷ்யதி; நரபுத்ரே ச லிபி ர்யதா²ஸ்தே ததை²வ ஸோபி ப³ஹுது³​:க²ம்ʼ ப்ராப்யாவஜ்ஞாஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","கிந்த்வஹம்ʼ யுஷ்மாந் வதா³மி , ஏலியார்தே² லிபி ர்யதா²ஸ்தே ததை²வ ஸ ஏத்ய யயௌ, லோகா: ஸ்வேச்சா²நுரூபம்ʼ தமபி⁴வ்யவஹரந்தி ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","அநந்தரம்ʼ ஸ ஸி²ஷ்யஸமீபமேத்ய தேஷாம்ʼ சது​:பார்ஸ்²வே தை​: ஸஹ ப³ஹுஜநாந் விவத³மாநாந் அத்⁴யாபகாம்ʼஸ்²ச த்³ருʼஷ்டவாந்; ");
INSERT INTO santam_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","கிந்து ஸர்வ்வலோகாஸ்தம்ʼ த்³ருʼஷ்ட்வைவ சமத்க்ருʼத்ய ததா³ஸந்நம்ʼ தா⁴வந்தஸ்தம்ʼ ப்ரணேமு​:| ");
INSERT INTO santam_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ததா³ யீஸு²ரத்⁴யாபகாநப்ராக்ஷீத்³ ஏதை​: ஸஹ யூயம்ʼ கிம்ʼ விவத³த்⁴வே? ");
INSERT INTO santam_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ததோ லோகாநாம்ʼ கஸ்²சிதே³க​: ப்ரத்யவாதீ³த் ஹே கு³ரோ மம ஸூநும்ʼ மூகம்ʼ பூ⁴தத்⁴ருʼதஞ்ச ப⁴வதா³ஸந்நம் ஆநயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","யதா³ஸௌ பூ⁴தஸ்தமாக்ரமதே ததை³வ பாதஸதி ததா² ஸ பே²ணாயதே, த³ந்தைர்த³ந்தாந் க⁴ர்ஷதி க்ஷீணோ ப⁴வதி ச; ததோ ஹேதோஸ்தம்ʼ பூ⁴தம்ʼ த்யாஜயிதும்ʼ ப⁴வச்சி²ஷ்யாந் நிவேதி³தவாந் கிந்து தே ந ஸே²கு​:| ");
INSERT INTO santam_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ததா³ ஸ தமவாதீ³த், ரே அவிஸ்²வாஸிந​: ஸந்தாநா யுஷ்மாபி⁴​: ஸஹ கதி காலாநஹம்ʼ ஸ்தா²ஸ்யாமி? அபராந் கதி காலாந் வா வ ஆசாராந் ஸஹிஷ்யே? தம்ʼ மதா³ஸந்நமாநயத| ");
INSERT INTO santam_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ததஸ்தத்ஸந்நிதி⁴ம்ʼ ஸ ஆநீயத கிந்து தம்ʼ த்³ருʼஷ்ட்வைவ பூ⁴தோ பா³லகம்ʼ த்⁴ருʼதவாந்; ஸ ச பூ⁴மௌ பதித்வா பே²ணாயமாநோ லுலோட²| ");
INSERT INTO santam_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ததா³ ஸ தத்பிதரம்ʼ பப்ரச்ச², அஸ்யேத்³ருʼஸீ² த³ஸா² கதி தி³நாநி பூ⁴தா? தத​: ஸோவாதீ³த் பா³ல்யகாலாத்| ");
INSERT INTO santam_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","பூ⁴தோயம்ʼ தம்ʼ நாஸ²யிதும்ʼ ப³ஹுவாராந் வஹ்நௌ ஜலே ச ந்யக்ஷிபத் கிந்து யதி³ ப⁴வாந கிமபி கர்த்தாம்ʼ ஸ²க்நோதி தர்ஹி த³யாம்ʼ க்ருʼத்வாஸ்மாந் உபகரோது| ");
INSERT INTO santam_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ததா³ யீஸு²ஸ்தமவத³த் யதி³ ப்ரத்யேதும்ʼ ஸ²க்நோஷி தர்ஹி ப்ரத்யயிநே ஜநாய ஸர்வ்வம்ʼ ஸாத்⁴யம்| ");
INSERT INTO santam_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ததஸ்தத்க்ஷணம்ʼ தத்³பா³லகஸ்ய பிதா ப்ரோச்சை ரூவந் ஸாஸ்²ருநேத்ர​: ப்ரோவாச, ப்ரபோ⁴ ப்ரத்யேமி மமாப்ரத்யயம்ʼ ப்ரதிகுரு| ");
INSERT INTO santam_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","அத² யீஸு² ர்லோகஸங்க⁴ம்ʼ தா⁴வித்வாயாந்தம்ʼ த்³ருʼஷ்ட்வா தமபூதபூ⁴தம்ʼ தர்ஜயித்வா ஜகா³த³, ரே ப³தி⁴ர மூக பூ⁴த த்வமேதஸ்மாத்³ ப³ஹிர்ப⁴வ புந​: கதா³பி மாஸ்²ரயைநம்ʼ த்வாமஹம் இத்யாதி³ஸா²மி| ");
INSERT INTO santam_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ததா³ ஸ பூ⁴தஸ்²சீத்ஸ²ப்³த³ம்ʼ க்ருʼத்வா தமாபீட்³ய ப³ஹிர்ஜஜாம, ததோ பா³லகோ ம்ருʼதகல்போ ப³பூ⁴வ தஸ்மாத³யம்ʼ ம்ருʼதஇத்யநேகே கத²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","கிந்து கரம்ʼ த்⁴ருʼத்வா யீஸு²நோத்தா²பித​: ஸ உத்தஸ்தௌ²| ");
INSERT INTO santam_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","அத² யீஸௌ² க்³ருʼஹம்ʼ ப்ரவிஷ்டே ஸி²ஷ்யா கு³ப்தம்ʼ தம்ʼ பப்ரச்சு²​:, வயமேநம்ʼ பூ⁴தம்ʼ த்யாஜயிதும்ʼ குதோ ந ஸ²க்தா​:? ");
INSERT INTO santam_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ஸ உவாச, ப்ரார்த²நோபவாஸௌ விநா கேநாப்யந்யேந கர்ம்மணா பூ⁴தமீத்³ருʼஸ²ம்ʼ த்யாஜயிதும்ʼ ந ஸ²க்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","அநந்தரம்ʼ ஸ தத்ஸ்தா²நாதி³த்வா கா³லீல்மத்⁴யேந யயௌ, கிந்து தத் கோபி ஜாநீயாதி³தி ஸ நைச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","அபரஞ்ச ஸ ஸி²ஷ்யாநுபதி³ஸ²ந் ப³பா⁴ஷே, நரபுத்ரோ நரஹஸ்தேஷு ஸமர்பயிஷ்யதே தே ச தம்ʼ ஹநிஷ்யந்தி தைஸ்தஸ்மிந் ஹதே த்ருʼதீயதி³நே ஸ உத்தா²ஸ்யதீதி| ");
INSERT INTO santam_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","கிந்து தத்கதா²ம்ʼ தே நாபு³த்⁴யந்த ப்ரஷ்டுஞ்ச பி³ப்⁴ய​:| ");
INSERT INTO santam_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","அத² யீஸு²​: கப²ர்நாஹூம்புரமாக³த்ய மத்⁴யேக்³ருʼஹஞ்சேத்ய தாநப்ருʼச்ச²த்³ வர்த்மமத்⁴யே யூயமந்யோந்யம்ʼ கிம்ʼ விவத³த்⁴வே ஸ்ம? ");
INSERT INTO santam_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","கிந்து தே நிருத்தராஸ்தஸ்து² ர்யஸ்மாத்தேஷாம்ʼ கோ முக்²ய இதி வர்த்மாநி தே(அ)ந்யோந்யம்ʼ வ்யவத³ந்த| ");
INSERT INTO santam_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","தத​: ஸ உபவிஸ்²ய த்³வாத³ஸ²ஸி²ஷ்யாந் ஆஹூய ப³பா⁴ஷே ய​: கஸ்²சித் முக்²யோ ப⁴விதுமிச்ச²தி ஸ ஸர்வ்வேப்⁴யோ கௌ³ண​: ஸர்வ்வேஷாம்ʼ ஸேவகஸ்²ச ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ததா³ ஸ பா³லகமேகம்ʼ க்³ருʼஹீத்வா மத்⁴யே ஸமுபாவேஸ²யத் ததஸ்தம்ʼ க்ரோடே³ க்ருʼத்வா தாநவாதா³த் ");
INSERT INTO santam_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ய​: கஸ்²சிதீ³த்³ருʼஸ²ஸ்ய கஸ்யாபி பா³லஸ்யாதித்²யம்ʼ கரோதி ஸ மமாதித்²யம்ʼ கரோதி; ய​: கஸ்²சிந்மமாதித்²யம்ʼ கரோதி ஸ கேவலம் மமாதித்²யம்ʼ கரோதி தந்ந மத்ப்ரேரகஸ்யாப்யாதித்²யம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","அத² யோஹந் தமப்³ரவீத் ஹே கு³ரோ, அஸ்மாகமநநுகா³மிநம் ஏகம்ʼ த்வாந்நாம்நா பூ⁴தாந் த்யாஜயந்தம்ʼ வயம்ʼ த்³ருʼஷ்டவந்த​:, அஸ்மாகமபஸ்²சாத்³கா³மித்வாச்ச தம்ʼ ந்யஷேதா⁴ம| ");
INSERT INTO santam_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","கிந்து யீஸு²ரவத³த் தம்ʼ மா நிஷேத⁴த், யதோ ய​: கஸ்²சிந் மந்நாம்நா சித்ரம்ʼ கர்ம்ம கரோதி ஸ ஸஹஸா மாம்ʼ நிந்தி³தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ததா² ய​: கஸ்²சித்³ யுஷ்மாகம்ʼ விபக்ஷதாம்ʼ ந கரோதி ஸ யுஷ்மாகமேவ ஸபக்ஷ​:| ");
INSERT INTO santam_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ய​: கஸ்²சித்³ யுஷ்மாந் க்²ரீஷ்டஸி²ஷ்யாந் ஜ்ஞாத்வா மந்நாம்நா கம்ʼஸைகேந பாநீயம்ʼ பாதும்ʼ த³தா³தி, யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வச்மி, ஸ ப²லேந வஞ்சிதோ ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","கிந்து யதி³ கஸ்²சிந் மயி விஸ்²வாஸிநாமேஷாம்ʼ க்ஷுத்³ரப்ராணிநாம் ஏகஸ்யாபி விக்⁴நம்ʼ ஜநயதி, தர்ஹி தஸ்யைதத்கர்ம்ம கரணாத் கண்ட²ப³த்³த⁴பேஷணீகஸ்ய தஸ்ய ஸாக³ராகா³த⁴ஜல மஜ்ஜநம்ʼ ப⁴த்³ரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","அத​: ஸ்வகரோ யதி³ த்வாம்ʼ பா³த⁴தே தர்ஹி தம்ʼ சி²ந்தி⁴; ");
INSERT INTO santam_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","யஸ்மாத் யத்ர கீடா ந ம்ரியந்தே வஹ்நிஸ்²ச ந நிர்வ்வாதி, தஸ்மிந் அநிர்வ்வாணாநலநரகே கரத்³வயவஸ்தவ க³மநாத் கரஹீநஸ்ய ஸ்வர்க³ப்ரவேஸ²ஸ்தவ க்ஷேமம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","யதி³ தவ பாதோ³ விக்⁴நம்ʼ ஜநயதி தர்ஹி தம்ʼ சி²ந்தி⁴, ");
INSERT INTO santam_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","யதோ யத்ர கீடா ந ம்ரியந்தே வஹ்நிஸ்²ச ந நிர்வ்வாதி, தஸ்மிந் (அ)நிர்வ்வாணவஹ்நௌ நரகே த்³விபாத³வதஸ்தவ நிக்ஷேபாத் பாத³ஹீநஸ்ய ஸ்வர்க³ப்ரவேஸ²ஸ்தவ க்ஷேமம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ஸ்வநேத்ரம்ʼ யதி³ த்வாம்ʼ பா³த⁴தே தர்ஹி தத³ப்யுத்பாடய, யதோ யத்ர கீடா ந ம்ரியந்தே வஹ்நிஸ்²ச ந நிர்வ்வாதி, ");
INSERT INTO santam_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","தஸ்மிந (அ)நிர்வ்வாணவஹ்நௌ நரகே த்³விநேத்ரஸ்ய தவ நிக்ஷேபாத்³ ஏகநேத்ரவத ஈஸ்²வரராஜ்யே ப்ரவேஸ²ஸ்தவ க்ஷேமம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","யதா² ஸர்வ்வோ ப³லி ர்லவணாக்த​: க்ரியதே ததா² ஸர்வ்வோ ஜநோ வஹ்நிரூபேண லவணாக்த​: காரிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","லவணம்ʼ ப⁴த்³ரம்ʼ கிந்து யதி³ லவணே ஸ்வாது³தா ந திஷ்ட²தி, தர்ஹி கத²ம் ஆஸ்வாத்³யுக்தம்ʼ கரிஷ்யத²? யூயம்ʼ லவணயுக்தா ப⁴வத பரஸ்பரம்ʼ ப்ரேம குருத| ");
INSERT INTO santam_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","அநந்தரம்ʼ ஸ தத்ஸ்தா²நாத் ப்ரஸ்தா²ய யர்த்³த³நநத்³யா​: பாரே யிஹூதா³ப்ரதே³ஸ² உபஸ்தி²தவாந், தத்ர தத³ந்திகே லோகாநாம்ʼ ஸமாக³மே ஜாதே ஸ நிஜரீத்யநுஸாரேண புநஸ்தாந் உபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ததா³ பி²ரூஸி²நஸ்தத்ஸமீபம் ஏத்ய தம்ʼ பரீக்ஷிதும்ʼ பப்ரச்ச²​: ஸ்வஜாயா மநுஜாநாம்ʼ த்யஜ்யா ந வேதி? ");
INSERT INTO santam_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","தத​: ஸ ப்ரத்யவாதீ³த், அத்ர கார்ய்யே மூஸா யுஷ்மாந் ப்ரதி கிமாஜ்ஞாபயத்? ");
INSERT INTO santam_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","த ஊசு​: த்யாக³பத்ரம்ʼ லேகி²தும்ʼ ஸ்வபத்நீம்ʼ த்யக்துஞ்ச மூஸா(அ)நுமந்யதே| ");
INSERT INTO santam_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ததா³ யீஸு²​: ப்ரத்யுவாச, யுஷ்மாகம்ʼ மநஸாம்ʼ காடி²ந்யாத்³தே⁴தோ ர்மூஸா நிதே³ஸ²மிமம் அலிக²த்| ");
INSERT INTO santam_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","கிந்து ஸ்ருʼஷ்டேராதௌ³ ஈஸ்²வரோ நராந் பும்ʼரூபேண ஸ்த்ரீரூபேண ச ஸஸர்ஜ| ");
INSERT INTO santam_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"தத​: காரணாத் புமாந் பிதரம்ʼ மாதரஞ்ச த்யக்த்வா ஸ்வஜாயாயாம் ஆஸக்தோ ப⁴விஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","தௌ த்³வாவ் ஏகாங்கௌ³ ப⁴விஷ்யத​:| \" தஸ்மாத் தத்காலமாரப்⁴ய தௌ ந த்³வாவ் ஏகாங்கௌ³| ");
INSERT INTO santam_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","அத​: காரணாத்³ ஈஸ்²வரோ யத³யோஜயத் கோபி நரஸ்தந்ந வியேஜயேத்| ");
INSERT INTO santam_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","அத² யீஸு² ர்க்³ருʼஹம்ʼ ப்ரவிஷ்டஸ்ததா³ ஸி²ஷ்யா​: புநஸ்தத்கதா²ம்ʼ தம்ʼ பப்ரச்சு²​:| ");
INSERT INTO santam_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","தத​: ஸோவத³த் கஸ்²சித்³ யதி³ ஸ்வபா⁴ர்ய்யாம்ʼ த்யக்தவாந்யாம் உத்³வஹதி தர்ஹி ஸ ஸ்வபா⁴ர்ய்யாயா​: ப்ராதிகூல்யேந வ்யபி⁴சாரீ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","காசிந்நாரீ யதி³ ஸ்வபதிம்ʼ ஹித்வாந்யபும்ʼஸா விவாஹிதா ப⁴வதி தர்ஹி ஸாபி வ்யபி⁴சாரிணீ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","அத² ஸ யதா² ஸி²ஸூ²ந் ஸ்ப்ருʼஸே²த், தத³ர்த²ம்ʼ லோகைஸ்தத³ந்திகம்ʼ ஸி²ஸ²வ ஆநீயந்த, கிந்து ஸி²ஷ்யாஸ்தாநாநீதவதஸ்தர்ஜயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","யீஸு²ஸ்தத்³ த்³ருʼஷ்ட்வா க்ருத்⁴யந் ஜகா³த³, மந்நிகடம் ஆக³ந்தும்ʼ ஸி²ஸூ²ந் மா வாரயத, யத ஏதாத்³ருʼஸா² ஈஸ்²வரராஜ்யாதி⁴காரிண​:| ");
INSERT INTO santam_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வச்மி, ய​: கஸ்²சித் ஸி²ஸு²வத்³ பூ⁴த்வா ராஜ்யமீஸ்²வரஸ்ய ந க்³ருʼஹ்லீயாத் ஸ கதா³பி தத்³ராஜ்யம்ʼ ப்ரவேஷ்டும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","அநநதரம்ʼ ஸ ஸி²ஸூ²நங்கே நிதா⁴ய தேஷாம்ʼ கா³த்ரேஷு ஹஸ்தௌ த³த்த்வாஸி²ஷம்ʼ ப³பா⁴ஷே| ");
INSERT INTO santam_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","அத² ஸ வர்த்மநா யாதி, ஏதர்ஹி ஜந ஏகோ தா⁴வந் ஆக³த்ய தத்ஸம்முகே² ஜாநுநீ பாதயித்வா ப்ருʼஷ்டவாந், போ⁴​: பரமகு³ரோ, அநந்தாயு​: ப்ராப்தயே மயா கிம்ʼ கர்த்தவ்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ததா³ யீஸு²ருவாச, மாம்ʼ பரமம்ʼ குதோ வத³ஸி? விநேஸ்²வரம்ʼ கோபி பரமோ ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","பரஸ்த்ரீம்ʼ நாபி⁴க³ச்ச²; நரம்ʼ மா கா⁴தய; ஸ்தேயம்ʼ மா குரு; ம்ருʼஷாஸாக்ஷ்யம்ʼ மா தே³ஹி; ஹிம்ʼஸாஞ்ச மா குரு; பிதரௌ ஸம்மந்யஸ்வ; நிதே³ஸா² ஏதே த்வயா ஜ்ஞாதா​:| ");
INSERT INTO santam_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ததஸ்தந ப்ரத்யுக்தம்ʼ, ஹே கு³ரோ பா³ல்யகாலாத³ஹம்ʼ ஸர்வ்வாநேதாந் ஆசராமி| ");
INSERT INTO santam_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ததா³ யீஸு²ஸ்தம்ʼ விலோக்ய ஸ்நேஹேந ப³பா⁴ஷே, தவைகஸ்யாபா⁴வ ஆஸ்தே; த்வம்ʼ க³த்வா ஸர்வ்வஸ்வம்ʼ விக்ரீய த³ரித்³ரேப்⁴யோ விஸ்²ராணய, தத​: ஸ்வர்கே³ த⁴நம்ʼ ப்ராப்ஸ்யஸி; தத​: பரம் ஏத்ய க்ருஸ²ம்ʼ வஹந் மத³நுவர்த்தீ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","கிந்து தஸ்ய ப³ஹுஸம்பத்³வித்³யமாநத்வாத் ஸ இமாம்ʼ கதா²மாகர்ண்ய விஷணோ து³​:கி²தஸ்²ச ஸந் ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","அத² யீஸு²ஸ்²சதுர்தி³ஸோ² நிரீக்ஷ்ய ஸி²ஷ்யாந் அவாதீ³த், த⁴நிலோகாநாம் ஈஸ்²வரராஜ்யப்ரவேஸ²​: கீத்³ருʼக்³ து³ஷ்கர​:| ");
INSERT INTO santam_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","தஸ்ய கதா²த​: ஸி²ஷ்யாஸ்²சமச்சக்ரு​:, கிந்து ஸ புநரவத³த், ஹே பா³லகா யே த⁴நே விஸ்²வஸந்தி தேஷாம் ஈஸ்²வரராஜ்யப்ரவேஸ²​: கீத்³ருʼக்³ து³ஷ்கர​:| ");
INSERT INTO santam_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ஈஸ்²வரராஜ்யே த⁴நிநாம்ʼ ப்ரவேஸா²த் ஸூசிரந்த்⁴ரேண மஹாங்க³ஸ்ய க³மநாக³மநம்ʼ ஸுகரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ததா³ ஸி²ஷ்யா அதீவ விஸ்மிதா​: பரஸ்பரம்ʼ ப்ரோசு​:, தர்ஹி க​: பரித்ராணம்ʼ ப்ராப்தும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ததோ யீஸு²ஸ்தாந் விலோக்ய ப³பா⁴ஷே, தந் நரஸ்யாஸாத்⁴யம்ʼ கிந்து நேஸ்²வரஸ்ய, யதோ ஹேதோரீஸ்²வரஸ்ய ஸர்வ்வம்ʼ ஸாத்⁴யம்| ");
INSERT INTO santam_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ததா³ பிதர உவாச, பஸ்²ய வயம்ʼ ஸர்வ்வம்ʼ பரித்யஜ்ய ப⁴வதோநுகா³மிநோ ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ததோ யீஸு²​: ப்ரத்யவத³த், யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, மத³ர்த²ம்ʼ ஸுஸம்ʼவாதா³ர்த²ம்ʼ வா யோ ஜந​: ஸத³நம்ʼ ப்⁴ராதரம்ʼ ப⁴கி³நீம்ʼ பிதரம்ʼ மாதரம்ʼ ஜாயாம்ʼ ஸந்தாநாந் பூ⁴மி வா த்யக்த்வா ");
INSERT INTO santam_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","க்³ருʼஹப்⁴ராத்ருʼப⁴கி³நீபித்ருʼமாத்ருʼபத்நீஸந்தாநபூ⁴மீநாமிஹ ஸ²தகு³ணாந் ப்ரேத்யாநந்தாயுஸ்²ச ந ப்ராப்நோதி தாத்³ருʼஸ²​: கோபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","கிந்த்வக்³ரீயா அநேகே லோகா​: ஸே²ஷா​:, ஸே²ஷீயா அநேகே லோகாஸ்²சாக்³ரா ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","அத² யிரூஸா²லம்யாநகாலே யீஸு²ஸ்தேஷாம் அக்³ரகா³மீ ப³பூ⁴வ, தஸ்மாத்தே சித்ரம்ʼ ஜ்ஞாத்வா பஸ்²சாத்³கா³மிநோ பூ⁴த்வா பி³ப்⁴யு​:| ததா³ ஸ புந ர்த்³வாத³ஸ²ஸி²ஷ்யாந் க்³ருʼஹீத்வா ஸ்வீயம்ʼ யத்³யத்³ க⁴டிஷ்யதே தத்தத் தேப்⁴ய​: கத²யிதும்ʼ ப்ராரேபே⁴; ");
INSERT INTO santam_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","பஸ்²யத வயம்ʼ யிரூஸா²லம்புரம்ʼ யாம​:, தத்ர மநுஷ்யபுத்ர​: ப்ரதா⁴நயாஜகாநாம் உபாத்⁴யாயாநாஞ்ச கரேஷு ஸமர்பயிஷ்யதே; தே ச வத⁴த³ண்டா³ஜ்ஞாம்ʼ தா³பயித்வா பரதே³ஸீ²யாநாம்ʼ கரேஷு தம்ʼ ஸமர்பயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","தே தமுபஹஸ்ய கஸ²யா ப்ரஹ்ருʼத்ய தத்³வபுஷி நிஷ்டீ²வம்ʼ நிக்ஷிப்ய தம்ʼ ஹநிஷ்யந்தி, தத​: ஸ த்ருʼதீயதி³நே ப்ரோத்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","தத​: ஸிவதே³​: புத்ரௌ யாகூப்³யோஹநௌ தத³ந்திகம் ஏத்ய ப்ரோசது​:, ஹே கு³ரோ யத்³ ஆவாப்⁴யாம்ʼ யாசிஷ்யதே தத³ஸ்மத³ர்த²ம்ʼ ப⁴வாந் கரோது நிவேத³நமித³மாவயோ​:| ");
INSERT INTO santam_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","தத​: ஸ கதி²தவாந், யுவாம்ʼ கிமிச்ச²த²​:? கிம்ʼ மயா யுஷ்மத³ர்த²ம்ʼ கரணீயம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ததா³ தௌ ப்ரோசது​:, ஆவயோரேகம்ʼ த³க்ஷிணபார்ஸ்²வே வாமபார்ஸ்²வே சைகம்ʼ தவைஸ்²வர்ய்யபதே³ ஸமுபவேஷ்டும் ஆஜ்ஞாபய| ");
INSERT INTO santam_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","கிந்து யீஸு²​: ப்ரத்யுவாச யுவாமஜ்ஞாத்வேத³ம்ʼ ப்ரார்த²யேதே², யேந கம்ʼஸேநாஹம்ʼ பாஸ்யாமி தேந யுவாப்⁴யாம்ʼ கிம்ʼ பாதும்ʼ ஸ²க்ஷ்யதே? யஸ்மிந் மஜ்ஜநேநாஹம்ʼ மஜ்ஜிஷ்யே தந்மஜ்ஜநே மஜ்ஜயிதும்ʼ கிம்ʼ யுவாப்⁴யாம்ʼ ஸ²க்ஷ்யதே? தௌ ப்ரத்யூசது​: ஸ²க்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ததா³ யீஸு²ரவத³த் யேந கம்ʼஸேநாஹம்ʼ பாஸ்யாமி தேநாவஸ்²யம்ʼ யுவாமபி பாஸ்யத²​:, யேந மஜ்ஜநேந சாஹம்ʼ மஜ்ஜிய்யே தத்ர யுவாமபி மஜ்ஜிஷ்யேதே²| ");
INSERT INTO santam_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","கிந்து யேஷாமர்த²ம் இத³ம்ʼ நிரூபிதம்ʼ, தாந் விஹாயாந்யம்ʼ கமபி மம த³க்ஷிணபார்ஸ்²வே வாமபார்ஸ்²வே வா ஸமுபவேஸ²யிதும்ʼ மமாதி⁴காரோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","அதா²ந்யத³ஸ²ஸி²ஷ்யா இமாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா யாகூப்³யோஹந்ப்⁴யாம்ʼ சுகுபு​:| ");
INSERT INTO santam_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","கிந்து யீஸு²ஸ்தாந் ஸமாஹூய ப³பா⁴ஷே, அந்யதே³ஸீ²யாநாம்ʼ ராஜத்வம்ʼ யே குர்வ்வந்தி தே தேஷாமேவ ப்ரபு⁴த்வம்ʼ குர்வ்வந்தி, ததா² யே மஹாலோகாஸ்தே தேஷாம் அதி⁴பதித்வம்ʼ குர்வ்வந்தீதி யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","கிந்து யுஷ்மாகம்ʼ மத்⁴யே ந ததா² ப⁴விஷ்யதி, யுஷ்மாகம்ʼ மத்⁴யே ய​: ப்ராதா⁴ந்யம்ʼ வாஞ்ச²தி ஸ யுஷ்மாகம்ʼ ஸேவகோ ப⁴விஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","யுஷ்மாகம்ʼ யோ மஹாந் ப⁴விதுமிச்ச²தி ஸ ஸர்வ்வேஷாம்ʼ கிங்கரோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","யதோ மநுஷ்யபுத்ர​: ஸேவ்யோ ப⁴விதும்ʼ நாக³த​: ஸேவாம்ʼ கர்த்தாம்ʼ ததா²நேகேஷாம்ʼ பரித்ராணஸ்ய மூல்யரூபஸ்வப்ராணம்ʼ தா³துஞ்சாக³த​:| ");
INSERT INTO santam_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","அத² தே யிரீஹோநக³ரம்ʼ ப்ராப்தாஸ்தஸ்மாத் ஸி²ஷ்யை ர்லோகைஸ்²ச ஸஹ யீஸோ² ர்க³மநகாலே டீமயஸ்ய புத்ரோ ப³ர்டீமயநாமா அந்த⁴ஸ்தந்மார்க³பார்ஸ்²வே பி⁴க்ஷார்த²ம் உபவிஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ஸ நாஸரதீயஸ்ய யீஸோ²ராக³மநவார்த்தாம்ʼ ப்ராப்ய ப்ரோசை ர்வக்துமாரேபே⁴, ஹே யீஸோ² தா³யூத³​: ஸந்தாந மாம்ʼ த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ததோநேகே லோகா மௌநீப⁴வேதி தம்ʼ தர்ஜயாமாஸு​:, கிந்து ஸ புநரதி⁴கமுச்சை ர்ஜகா³த³, ஹே யீஸோ² தா³யூத³​: ஸந்தாந மாம்ʼ த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ததா³ யீஸு²​: ஸ்தி²த்வா தமாஹ்வாதும்ʼ ஸமாதி³தே³ஸ², ததோ லோகாஸ்தமந்த⁴மாஹூய ப³பா⁴ஷிரே, ஹே நர, ஸ்தி²ரோ ப⁴வ, உத்திஷ்ட², ஸ த்வாமாஹ்வயதி| ");
INSERT INTO santam_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ததா³ ஸ உத்தரீயவஸ்த்ரம்ʼ நிக்ஷிப்ய ப்ரோத்தா²ய யீஸோ²​: ஸமீபம்ʼ க³த​:| ");
INSERT INTO santam_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ததோ யீஸு²ஸ்தமவத³த் த்வயா கிம்ʼ ப்ரார்த்²யதே? துப்⁴யமஹம்ʼ கிம்ʼ கரிஷ்யாமீ? ததா³ ஸோந்த⁴ஸ்தமுவாச, ஹே கு³ரோ மதீ³யா த்³ருʼஷ்டிர்ப⁴வேத்| ");
INSERT INTO santam_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ததோ யீஸு²ஸ்தமுவாச யாஹி தவ விஸ்²வாஸஸ்த்வாம்ʼ ஸ்வஸ்த²மகார்ஷீத், தஸ்மாத் தத்க்ஷணம்ʼ ஸ த்³ருʼஷ்டிம்ʼ ப்ராப்ய பதா² யீஸோ²​: பஸ்²சாத்³ யயௌ| ");
INSERT INTO santam_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","அநந்தரம்ʼ தேஷு யிரூஸா²லம​: ஸமீபஸ்த²யோ ர்பை³த்ப²கீ³பை³த²நீயபுரயோரந்திகஸ்த²ம்ʼ ஜைதுநநாமாத்³ரிமாக³தேஷு யீஸு²​: ப்ரேஷணகாலே த்³வௌ ஸி²ஷ்யாவித³ம்ʼ வாக்யம்ʼ ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","யுவாமமும்ʼ ஸம்முக²ஸ்த²ம்ʼ க்³ராமம்ʼ யாதம்ʼ, தத்ர ப்ரவிஸ்²ய யோ நரம்ʼ நாவஹத் தம்ʼ க³ர்த்³த³ப⁴ஸா²வகம்ʼ த்³ரக்ஷ்யத²ஸ்தம்ʼ மோசயித்வாநயதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","கிந்து யுவாம்ʼ கர்ம்மேத³ம்ʼ குத​: குருத²​:? கதா²மிமாம்ʼ யதி³ கோபி ப்ருʼச்ச²தி தர்ஹி ப்ரபோ⁴ரத்ர ப்ரயோஜநமஸ்தீதி கதி²தே ஸ ஸீ²க்⁴ரம்ʼ தமத்ர ப்ரேஷயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ததஸ்தௌ க³த்வா த்³விமார்க³மேலநே கஸ்யசித்³ த்³வாரஸ்ய பார்ஸ்²வே தம்ʼ க³ர்த்³த³ப⁴ஸா²வகம்ʼ ப்ராப்ய மோசயத​:, ");
INSERT INTO santam_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ஏதர்ஹி தத்ரோபஸ்தி²தலோகாநாம்ʼ கஸ்²சித்³ அப்ருʼச்ச²த், க³ர்த்³த³ப⁴ஸி²ஸு²ம்ʼ குதோ மோசயத²​:? ");
INSERT INTO santam_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ததா³ யீஸோ²ராஜ்ஞாநுஸாரேண தேப்⁴ய​: ப்ரத்யுதி³தே தத்க்ஷணம்ʼ தமாதா³தும்ʼ தே(அ)நுஜஜ்ஞு​:| ");
INSERT INTO santam_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","அத² தௌ யீஸோ²​: ஸந்நிதி⁴ம்ʼ க³ர்த்³த³ப⁴ஸி²ஸு²ம் ஆநீய தது³பரி ஸ்வவஸ்த்ராணி பாதயாமாஸது​:; தத​: ஸ தது³பரி ஸமுபவிஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ததா³நேகே பதி² ஸ்வவாஸாம்ʼஸி பாதயாமாஸு​:, பரைஸ்²ச தருஸா²கா²ஸ்²சி²தவா மார்கே³ விகீர்ணா​:| ");
INSERT INTO santam_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","அபரஞ்ச பஸ்²சாத்³கா³மிநோ(அ)க்³ரகா³மிநஸ்²ச ஸர்வ்வே ஜநா உசை​:ஸ்வரேண வக்துமாரேபி⁴ரே, ஜய ஜய ய​: பரமேஸ்²வரஸ்ய நாம்நாக³ச்ச²தி ஸ த⁴ந்ய இதி| ");
INSERT INTO santam_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ததா²ஸ்மாகமம்ʼ பூர்வ்வபுருஷஸ்ய தா³யூதோ³ யத்³ராஜ்யம்ʼ பரமேஸ்²வரநாம்நாயாதி தத³பி த⁴ந்யம்ʼ, ஸர்வ்வஸ்மாது³ச்ச்²ராயே ஸ்வர்கே³ ஈஸ்²வரஸ்ய ஜயோ ப⁴வேத்| ");
INSERT INTO santam_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","இத்த²ம்ʼ யீஸு² ர்யிரூஸா²லமி மந்தி³ரம்ʼ ப்ரவிஸ்²ய சதுர்தி³க்ஸ்தா²நி ஸர்வ்வாணி வஸ்தூநி த்³ருʼஷ்டவாந்; அத² ஸாயம்ʼகால உபஸ்தி²தே த்³வாத³ஸ²ஸி²ஷ்யஸஹிதோ பை³த²நியம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","அபரேஹநி பை³த²நியாத்³ ஆக³மநஸமயே க்ஷுதா⁴ர்த்தோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ததோ தூ³ரே ஸபத்ரமுடு³ம்ப³ரபாத³பம்ʼ விலோக்ய தத்ர கிஞ்சித் ப²லம்ʼ ப்ராப்தும்ʼ தஸ்ய ஸந்நிக்ருʼஷ்டம்ʼ யயௌ, ததா³நீம்ʼ ப²லபாதநஸ்ய ஸமயோ நாக³ச்ச²தி| ததஸ்தத்ரோபஸ்தி²த​: பத்ராணி விநா கிமப்யபரம்ʼ ந ப்ராப்ய ஸ கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","அத்³யாரப்⁴ய கோபி மாநவஸ்த்வத்த​: ப²லம்ʼ ந பு⁴ஞ்ஜீத; இமாம்ʼ கதா²ம்ʼ தஸ்ய ஸி²ஷ்யா​: ஸு²ஸ்²ருவு​:| ");
INSERT INTO santam_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","தத³நந்தரம்ʼ தேஷு யிரூஸா²லமமாயாதேஷு யீஸு² ர்மந்தி³ரம்ʼ க³த்வா தத்ரஸ்தா²நாம்ʼ ப³ணிஜாம்ʼ முத்³ராஸநாநி பாராவதவிக்ரேத்ருʼணாம் ஆஸநாநி ச ந்யுப்³ஜயாஞ்சகார ஸர்வ்வாந் க்ரேத்ருʼந் விக்ரேத்ரும்ʼʼஸ்²ச ப³ஹிஸ்²சகார| ");
INSERT INTO santam_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","அபரம்ʼ மந்தி³ரமத்⁴யேந கிமபி பாத்ரம்ʼ வோடு⁴ம்ʼ ஸர்வ்வஜநம்ʼ நிவாரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","லோகாநுபதி³ஸ²ந் ஜகா³த³, மம க்³ருʼஹம்ʼ ஸர்வ்வஜாதீயாநாம்ʼ ப்ரார்த²நாக்³ருʼஹம் இதி நாம்நா ப்ரதி²தம்ʼ ப⁴விஷ்யதி ஏதத் கிம்ʼ ஸா²ஸ்த்ரே லிகி²தம்ʼ நாஸ்தி? கிந்து யூயம்ʼ ததே³வ சோராணாம்ʼ க³ஹ்வரம்ʼ குருத²| ");
INSERT INTO santam_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","இமாம்ʼ வாணீம்ʼ ஸ்²ருத்வாத்⁴யாபகா​: ப்ரதா⁴நயாஜகாஸ்²ச தம்ʼ யதா² நாஸ²யிதும்ʼ ஸ²க்நுவந்தி ததோ²ेபாயம்ʼ ம்ருʼக³யாமாஸு​:, கிந்து தஸ்யோபதே³ஸா²த் ஸர்வ்வே லோகா விஸ்மயம்ʼ க³தா அதஸ்தே தஸ்மாத்³ பி³ப்⁴யு​:| ");
INSERT INTO santam_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","அத² ஸாயம்ʼஸமய உபஸ்தி²தே யீஸு²ர்நக³ராத்³ ப³ஹிர்வவ்ராஜ| ");
INSERT INTO santam_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","அநந்தரம்ʼ ப்ராத​:காலே தே தேந மார்கே³ண க³ச்ச²ந்தஸ்தமுடு³ம்ப³ரமஹீருஹம்ʼ ஸமூலம்ʼ ஸு²ஷ்கம்ʼ த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","தத​: பிதர​: பூர்வ்வவாக்யம்ʼ ஸ்மரந் யீஸு²ம்ʼ ப³பா⁴ஷம்ʼ, ஹே கு³ரோ பஸ்²யது ய உடு³ம்ப³ரவிடபீ ப⁴வதா ஸ²ப்த​: ஸ ஸு²ஷ்கோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ததோ யீஸு²​: ப்ரத்யவாதீ³த், யூயமீஸ்²வரே விஸ்²வஸித| ");
INSERT INTO santam_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி கோபி யத்³யேதத்³கி³ரிம்ʼ வத³தி, த்வமுத்தா²ய க³த்வா ஜலதௌ⁴ பத, ப்ரோக்தமித³ம்ʼ வாக்யமவஸ்²யம்ʼ க⁴டிஷ்யதே, மநஸா கிமபி ந ஸந்தி³ஹ்ய சேதி³த³ம்ʼ விஸ்²வஸேத் தர்ஹி தஸ்ய வாக்யாநுஸாரேண தத்³ க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","அதோ ஹேதோரஹம்ʼ யுஷ்மாந் வச்மி, ப்ரார்த²நாகாலே யத்³யதா³காம்ʼக்ஷிஷ்யத்⁴வே தத்தத³வஸ்²யம்ʼ ப்ராப்ஸ்யத², இத்த²ம்ʼ விஸ்²வஸித, தத​: ப்ராப்ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","அபரஞ்ச யுஷ்மாஸு ப்ரார்த²யிதும்ʼ ஸமுத்தி²தேஷு யதி³ கோபி யுஷ்மாகம் அபராதீ⁴ திஷ்ட²தி, தர்ஹி தம்ʼ க்ஷமத்⁴வம்ʼ, ததா² க்ருʼதே யுஷ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதாபி யுஷ்மாகமாகா³ம்ʼமி க்ஷமிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","கிந்து யதி³ ந க்ஷமத்⁴வே தர்ஹி வ​: ஸ்வர்க³ஸ்த²​: பிதாபி யுஷ்மாகமாகா³ம்ʼஸி ந க்ஷமிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","அநந்தரம்ʼ தே புந ர்யிரூஸா²லமம்ʼ ப்ரவிவிஸு²​:, யீஸு² ர்யதா³ மத்⁴யேமந்தி³ரம் இதஸ்ததோ க³ச்ச²தி, ததா³நீம்ʼ ப்ரதா⁴நயாஜகா உபாத்⁴யாயா​: ப்ராஞ்சஸ்²ச தத³ந்திகமேத்ய கதா²மிமாம்ʼ பப்ரச்சு²​:, ");
INSERT INTO santam_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","த்வம்ʼ கேநாதே³ஸே²ந கர்ம்மாண்யேதாநி கரோஷி? ததை²தாநி கர்ம்மாணி கர்த்தாம்ʼ கேநாதி³ஷ்டோஸி? ");
INSERT INTO santam_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ததோ யீஸு²​: ப்ரதிக³தி³தவாந் அஹமபி யுஷ்மாந் ஏககதா²ம்ʼ ப்ருʼச்சா²மி, யதி³ யூயம்ʼ தஸ்யா உத்தரம்ʼ குருத², தர்ஹி கயாஜ்ஞயாஹம்ʼ கர்ம்மாண்யேதாநி கரோமி தத்³ யுஷ்மப்⁴யம்ʼ கத²யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","யோஹநோ மஜ்ஜநம் ஈஸ்²வராத் ஜாதம்ʼ கிம்ʼ மாநவாத்? தந்மஹ்யம்ʼ கத²யத| ");
INSERT INTO santam_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","தே பரஸ்பரம்ʼ விவேக்தும்ʼ ப்ராரேபி⁴ரே, தத்³ ஈஸ்²வராத்³ ப³பூ⁴வேதி சேத்³ வதா³மஸ்தர்ஹி குதஸ்தம்ʼ ந ப்ரத்யைத? கத²மேதாம்ʼ கத²யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","மாநவாத்³ அப⁴வதி³தி சேத்³ வதா³மஸ்தர்ஹி லோகேப்⁴யோ ப⁴யமஸ்தி யதோ ஹேதோ​: ஸர்வ்வே யோஹநம்ʼ ஸத்யம்ʼ ப⁴விஷ்யத்³வாதி³நம்ʼ மந்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","அதஏவ தே யீஸு²ம்ʼ ப்ரத்யவாதி³ஷு ர்வயம்ʼ தத்³ வக்தும்ʼ ந ஸ²க்நும​:| யீஸு²ருவாச, தர்ஹி யேநாதே³ஸே²ந கர்ம்மாண்யேதாநி கரோமி, அஹமபி யுஷ்மப்⁴யம்ʼ தந்ந கத²யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","அநந்தரம்ʼ யீஸு² ர்த்³ருʼஷ்டாந்தேந தேப்⁴ய​: கத²யிதுமாரேபே⁴, கஸ்²சிதே³கோ த்³ராக்ஷாக்ஷேத்ரம்ʼ விதா⁴ய தச்சதுர்தி³க்ஷு வாரணீம்ʼ க்ருʼத்வா தந்மத்⁴யே த்³ராக்ஷாபேஷணகுண்ட³ம் அக²நத், ததா² தஸ்ய க³ட³மபி நிர்ம்மிதவாந் ததஸ்தத்க்ஷேத்ரம்ʼ க்ருʼஷீவலேஷு ஸமர்ப்ய தூ³ரதே³ஸ²ம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","தத³நந்தரம்ʼ ப²லகாலே க்ருʼஷீவலேப்⁴யோ த்³ராக்ஷாக்ஷேத்ரப²லாநி ப்ராப்தும்ʼ தேஷாம்ʼ ஸவிதே⁴ ப்⁴ருʼத்யம் ஏகம்ʼ ப்ராஹிணோத்| ");
INSERT INTO santam_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","கிந்து க்ருʼஷீவலாஸ்தம்ʼ த்⁴ருʼத்வா ப்ரஹ்ருʼத்ய ரிக்தஹஸ்தம்ʼ விஸஸ்ருʼஜு​:| ");
INSERT INTO santam_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","தத​: ஸ புநரந்யமேகம்ʼ ப்⁴ருʼத்யம்ʼ ப்ரஷயாமாஸ, கிந்து தே க்ருʼஷீவலா​: பாஷாணாகா⁴தைஸ்தஸ்ய ஸி²ரோ ப⁴ங்க்த்வா ஸாபமாநம்ʼ தம்ʼ வ்யஸர்ஜந்| ");
INSERT INTO santam_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","தத​: பரம்ʼ ஸோபரம்ʼ தா³ஸம்ʼ ப்ராஹிணோத் ததா³ தே தம்ʼ ஜக்⁴நு​:, ஏவம் அநேகேஷாம்ʼ கஸ்யசித் ப்ரஹார​: கஸ்யசித்³ வத⁴ஸ்²ச தை​: க்ருʼத​:| ");
INSERT INTO santam_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","தத​: பரம்ʼ மயா ஸ்வபுத்ரே ப்ரஹிதே தே தமவஸ்²யம்ʼ ஸம்மம்ʼஸ்யந்தே, இத்யுக்த்வாவஸே²ஷே தேஷாம்ʼ ஸந்நிதௌ⁴ நிஜப்ரியம் அத்³விதீயம்ʼ புத்ரம்ʼ ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","கிந்து க்ருʼஷீவலா​: பரஸ்பரம்ʼ ஜக³து³​:, ஏஷ உத்தராதி⁴காரீ, ஆக³ச்ச²த வயமேநம்ʼ ஹந்மஸ்ததா² க்ருʼதே (அ)தி⁴காரோயம் அஸ்மாகம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ததஸ்தம்ʼ த்⁴ருʼத்வா ஹத்வா த்³ராக்ஷாக்ஷேத்ராத்³ ப³ஹி​: ப்ராக்ஷிபந்| ");
INSERT INTO santam_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","அநேநாஸௌ த்³ராக்ஷாக்ஷேத்ரபதி​: கிம்ʼ கரிஷ்யதி? ஸ ஏத்ய தாந் க்ருʼஷீவலாந் ஸம்ʼஹத்ய தத்க்ஷேத்ரம் அந்யேஷு க்ருʼஷீவலேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","அபரஞ்ச, \"ஸ்த²பதய​: கரிஷ்யந்தி க்³ராவாணம்ʼ யந்து துச்ச²கம்ʼ| ப்ராதா⁴நப்ரஸ்தர​: கோணே ஸ ஏவ ஸம்ʼப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ஏதத் கர்ம்ம பரேஸ²ஸ்யாம்ʼத்³பு⁴தம்ʼ நோ த்³ருʼஷ்டிதோ ப⁴வேத்|| \" இமாம்ʼ ஸா²ஸ்த்ரீயாம்ʼ லிபிம்ʼ யூயம்ʼ கிம்ʼ நாபாடி²ஷ்ட? ");
INSERT INTO santam_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ததா³நீம்ʼ ஸ தாநுத்³தி³ஸ்²ய தாம்ʼ த்³ருʼஷ்டாந்தகதா²ம்ʼ கதி²தவாந், த இத்த²ம்ʼ பு³த்³வ்வா தம்ʼ த⁴ர்த்தாமுத்³யதா​:, கிந்து லோகேப்⁴யோ பி³ப்⁴யு​:, தத³நந்தரம்ʼ தே தம்ʼ விஹாய வவ்ரஜு​:| ");
INSERT INTO santam_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","அபரஞ்ச தே தஸ்ய வாக்யதோ³ஷம்ʼ த⁴ர்த்தாம்ʼ கதிபயாந் பி²ரூஸி²நோ ஹேரோதீ³யாம்ʼஸ்²ச லோகாந் தத³ந்திகம்ʼ ப்ரேஷயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","த ஆக³த்ய தமவத³ந், ஹே கு³ரோ ப⁴வாந் தத்²யபா⁴ஷீ கஸ்யாப்யநுரோத⁴ம்ʼ ந மந்யதே, பக்ஷபாதஞ்ச ந கரோதி, யதா²ர்த²த ஈஸ்²வரீயம்ʼ மார்க³ம்ʼ த³ர்ஸ²யதி வயமேதத் ப்ரஜாநீம​:, கைஸராய கரோ தே³யோ ந வாம்ʼ? வயம்ʼ தா³ஸ்யாமோ ந வா? ");
INSERT INTO santam_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","கிந்து ஸ தேஷாம்ʼ கபடம்ʼ ஜ்ஞாத்வா ஜகா³த³, குதோ மாம்ʼ பரீக்ஷத்⁴வே? ஏகம்ʼ முத்³ராபாத³ம்ʼ ஸமாநீய மாம்ʼ த³ர்ஸ²யத| ");
INSERT INTO santam_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ததா³ தைரேகஸ்மிந் முத்³ராபாதே³ ஸமாநீதே ஸ தாந் பப்ரச்ச², அத்ர லிகி²தம்ʼ நாம மூர்த்தி ர்வா கஸ்ய? தே ப்ரத்யூசு​:, கைஸரஸ்ய| ");
INSERT INTO santam_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ததா³ யீஸு²ரவத³த் தர்ஹி கைஸரஸ்ய த்³ரவ்யாணி கைஸராய த³த்த, ஈஸ்²வரஸ்ய த்³ரவ்யாணி து ஈஸ்²வராய த³த்த; ததஸ்தே விஸ்மயம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","அத² ம்ருʼதாநாமுத்தா²நம்ʼ யே ந மந்யந்தே தே ஸிதூ³கிநோ யீஸோ²​: ஸமீபமாக³த்ய தம்ʼ பப்ரச்சு²​:; ");
INSERT INTO santam_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ஹே கு³ரோ கஸ்²சிஜ்ஜநோ யதி³ நி​:ஸந்ததி​: ஸந் பா⁴ர்ய்யாயாம்ʼ ஸத்யாம்ʼ ம்ரியதே தர்ஹி தஸ்ய ப்⁴ராதா தஸ்ய பா⁴ர்ய்யாம்ʼ க்³ருʼஹீத்வா ப்⁴ராது ர்வம்ʼஸோ²த்பத்திம்ʼ கரிஷ்யதி, வ்யவஸ்தா²மிமாம்ʼ மூஸா அஸ்மாந் ப்ரதி வ்யலிக²த்| ");
INSERT INTO santam_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","கிந்து கேசித் ஸப்த ப்⁴ராதர ஆஸந், ததஸ்தேஷாம்ʼ ஜ்யேஷ்ட²ப்⁴ராதா விவஹ்ய நி​:ஸந்ததி​: ஸந் அம்ரியத| ");
INSERT INTO santam_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ததோ த்³விதீயோ ப்⁴ராதா தாம்ʼ ஸ்த்ரியமக்³ருʼஹணத் கிந்து ஸோபி நி​:ஸந்ததி​: ஸந் அம்ரியத; அத² த்ருʼதீயோபி ப்⁴ராதா தாத்³ருʼஸோ²ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","இத்த²ம்ʼ ஸப்தைவ ப்⁴ராதரஸ்தாம்ʼ ஸ்த்ரியம்ʼ க்³ருʼஹீத்வா நி​:ஸந்தாநா​: ஸந்தோ(அ)ம்ரியந்த, ஸர்வ்வஸே²ஷே ஸாபி ஸ்த்ரீ ம்ரியதே ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","அத² ம்ருʼதாநாமுத்தா²நகாலே யதா³ த உத்தா²ஸ்யந்தி ததா³ தேஷாம்ʼ கஸ்ய பா⁴ர்ய்யா ஸா ப⁴விஷ்யதி? யதஸ்தே ஸப்தைவ தாம்ʼ வ்யவஹந்| ");
INSERT INTO santam_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ததோ யீஸு²​: ப்ரத்யுவாச ஸா²ஸ்த்ரம் ஈஸ்²வரஸ²க்திஞ்ச யூயமஜ்ஞாத்வா கிமப்⁴ராம்யத ந? ");
INSERT INTO santam_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ம்ருʼதலோகாநாமுத்தா²நம்ʼ ஸதி தே ந விவஹந்தி வாக்³த³த்தா அபி ந ப⁴வந்தி, கிந்து ஸ்வர்கீ³யதூ³தாநாம்ʼ ஸத்³ருʼஸா² ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","புநஸ்²ச \"அஹம் இப்³ராஹீம ஈஸ்²வர இஸ்ஹாக ஈஸ்²வரோ யாகூப³ஸ்²சேஸ்²வர​:\" யாமிமாம்ʼ கதா²ம்ʼ ஸ்தம்ப³மத்⁴யே திஷ்ட²ந் ஈஸ்²வரோ மூஸாமவாதீ³த் ம்ருʼதாநாமுத்தா²நார்தே² ஸா கதா² மூஸாலிகி²தே புஸ்தகே கிம்ʼ யுஷ்மாபி⁴ ர்நாபாடி²? ");
INSERT INTO santam_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ஈஸ்²வரோ ஜீவதாம்ʼ ப்ரபு⁴​: கிந்து ம்ருʼதாநாம்ʼ ப்ரபு⁴ ர்ந ப⁴வதி, தஸ்மாத்³தே⁴தோ ர்யூயம்ʼ மஹாப்⁴ரமேண திஷ்ட²த²| ");
INSERT INTO santam_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ஏதர்ஹி ஏகோத்⁴யாபக ஏத்ய தேஷாமித்த²ம்ʼ விசாரம்ʼ ஸு²ஸ்²ராவ; யீஸு²ஸ்தேஷாம்ʼ வாக்யஸ்ய ஸது³த்தரம்ʼ த³த்தவாந் இதி பு³த்³வ்வா தம்ʼ ப்ருʼஷ்டவாந் ஸர்வ்வாஸாம் ஆஜ்ஞாநாம்ʼ கா ஸ்²ரேஷ்டா²? ததோ யீஸு²​: ப்ரத்யுவாச, ");
INSERT INTO santam_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ஹே இஸ்ராயேல்லோகா அவத⁴த்த, அஸ்மாகம்ʼ ப்ரபு⁴​: பரமேஸ்²வர ஏக ஏவ, ");
INSERT INTO santam_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","யூயம்ʼ ஸர்வ்வந்த​:கரணை​: ஸர்வ்வப்ராணை​: ஸர்வ்வசித்தை​: ஸர்வ்வஸ²க்திபி⁴ஸ்²ச தஸ்மிந் ப்ரபௌ⁴ பரமேஸ்²வரே ப்ரீயத்⁴வம்ʼ,\" இத்யாஜ்ஞா ஸ்²ரேஷ்டா²| ");
INSERT INTO santam_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ததா² \"ஸ்வப்ரதிவாஸிநி ஸ்வவத் ப்ரேம குருத்⁴வம்ʼ,\" ஏஷா யா த்³விதீயாஜ்ஞா ஸா தாத்³ருʼஸீ²; ஏதாப்⁴யாம்ʼ த்³வாப்⁴யாம் ஆஜ்ஞாப்⁴யாம் அந்யா காப்யாஜ்ஞா ஸ்²ரேஷ்டா² நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ததா³ ஸோத்⁴யாபகஸ்தமவத³த், ஹே கு³ரோ ஸத்யம்ʼ ப⁴வாந் யதா²ர்த²ம்ʼ ப்ரோக்தவாந் யத ஏகஸ்மாத்³ ஈஸ்²வராத்³ அந்யோ த்³விதீய ஈஸ்²வரோ நாஸ்தி; ");
INSERT INTO santam_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","அபரம்ʼ ஸர்வ்வாந்த​:கரணை​: ஸர்வ்வப்ராணை​: ஸர்வ்வசித்தை​: ஸர்வ்வஸ²க்திபி⁴ஸ்²ச ஈஸ்²வரே ப்ரேமகரணம்ʼ ததா² ஸ்வமீபவாஸிநி ஸ்வவத் ப்ரேமகரணஞ்ச ஸர்வ்வேப்⁴யோ ஹோமப³லிதா³நாதி³ப்⁴ய​: ஸ்²ரஷ்ட²ம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ததோ யீஸு²​: ஸுபு³த்³தே⁴ரிவ தஸ்யேத³ம் உத்தரம்ʼ ஸ்²ருத்வா தம்ʼ பா⁴ஷிதவாந் த்வமீஸ்²வரஸ்ய ராஜ்யாந்ந தூ³ரோஸி| இத​: பரம்ʼ தேந ஸஹ கஸ்யாபி வாக்யஸ்ய விசாரம்ʼ கர்த்தாம்ʼ கஸ்யாபி ப்ரக³ல்ப⁴தா ந ஜாதா| ");
INSERT INTO santam_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","அநந்தரம்ʼ மத்⁴யேமந்தி³ரம் உபதி³ஸ²ந் யீஸு²ரிமம்ʼ ப்ரஸ்²நம்ʼ சகார, அத்⁴யாபகா அபி⁴ஷிக்தம்ʼ (தாரகம்ʼ) குதோ தா³யூத³​: ஸந்தாநம்ʼ வத³ந்தி? ");
INSERT INTO santam_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ஸ்வயம்ʼ தா³யூத்³ பவித்ரஸ்யாத்மந ஆவேஸே²நேத³ம்ʼ கத²யாமாஸ| யதா²| \"மம ப்ரபு⁴மித³ம்ʼ வாக்யவத³த் பரமேஸ்²வர​:| தவ ஸ²த்ரூநஹம்ʼ யாவத் பாத³பீட²ம்ʼ கரோமி ந| தாவத் காலம்ʼ மதீ³யே த்வம்ʼ த³க்ஷபார்ஸ்²வ் உபாவிஸ²| \" ");
INSERT INTO santam_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","யதி³ தா³யூத்³ தம்ʼ ப்ரபூ⁴ம்ʼ வத³தி தர்ஹி கத²ம்ʼ ஸ தஸ்ய ஸந்தாநோ ப⁴விதுமர்ஹதி? இதரே லோகாஸ்தத்கதா²ம்ʼ ஸ்²ருத்வாநநந்து³​:| ");
INSERT INTO santam_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ததா³நீம்ʼ ஸ தாநுபதி³ஸ்²ய கதி²தவாந் யே நரா தீ³ர்க⁴பரிதே⁴யாநி ஹட்டே விபநௌ ச ");
INSERT INTO santam_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","லோகக்ருʼதநமஸ்காராந் ப⁴ஜநக்³ருʼஹே ப்ரதா⁴நாஸநாநி போ⁴ஜநகாலே ப்ரதா⁴நஸ்தா²நாநி ச காங்க்ஷந்தே; ");
INSERT INTO santam_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","வித⁴வாநாம்ʼ ஸர்வ்வஸ்வம்ʼ க்³ரஸித்வா ச²லாத்³ தீ³ர்க⁴காலம்ʼ ப்ரார்த²யந்தே தேப்⁴ய உபாத்⁴யாயேப்⁴ய​: ஸாவதா⁴நா ப⁴வத; தே(அ)தி⁴கதராந் த³ண்டா³ந் ப்ராப்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","தத³நந்தரம்ʼ லோகா பா⁴ண்டா³கா³ரே முத்³ரா யதா² நிக்ஷிபந்தி பா⁴ண்டா³கா³ரஸ்ய ஸம்முகே² ஸமுபவிஸ்²ய யீஸு²ஸ்தத³வலுலோக; ததா³நீம்ʼ ப³ஹவோ த⁴நிநஸ்தஸ்ய மத்⁴யே ப³ஹூநி த⁴நாநி நிரக்ஷிபந்| ");
INSERT INTO santam_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","பஸ்²சாத்³ ஏகா த³ரித்³ரா வித⁴வா ஸமாக³த்ய த்³விபணமூல்யாம்ʼ முத்³ரைகாம்ʼ தத்ர நிரக்ஷிபத்| ");
INSERT INTO santam_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ததா³ யீஸு²​: ஸி²ஷ்யாந் ஆஹூய கதி²தவாந் யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி யே யே பா⁴ண்டா³கா³ரே(அ)ஸ்மிந த⁴நாநி நி​:க்ஷிபந்தி ஸ்ம தேப்⁴ய​: ஸர்வ்வேப்⁴ய இயம்ʼ வித⁴வா த³ரித்³ராதி⁴கம் நி​:க்ஷிபதி ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","யதஸ்தே ப்ரபூ⁴தத⁴நஸ்ய கிஞ்சித் நிரக்ஷிபந் கிந்து தீ³நேயம்ʼ ஸ்வதி³நயாபநயோக்³யம்ʼ கிஞ்சித³பி ந ஸ்தா²பயித்வா ஸர்வ்வஸ்வம்ʼ நிரக்ஷிபத்| ");
INSERT INTO santam_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","அநந்தரம்ʼ மந்தி³ராத்³ ப³ஹிர்க³மநகாலே தஸ்ய ஸி²ஷ்யாணாமேகஸ்தம்ʼ வ்யாஹ்ருʼதவாந் ஹே கு³ரோ பஸ்²யது கீத்³ருʼஸா²​: பாஷாணா​: கீத்³ருʼக் ச நிசயநம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ததா³ யீஸு²ஸ்தம் அவத³த் த்வம்ʼ கிமேதத்³ ப்³ருʼஹந்நிசயநம்ʼ பஸ்²யஸி? அஸ்யைகபாஷாணோபி த்³விதீயபாஷாணோபரி ந ஸ்தா²ஸ்யதி ஸர்வ்வே (அ)த⁴​:க்ஷேப்ஸ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","அத² யஸ்மிந் காலே ஜைதுந்கி³ரௌ மந்தி³ரஸ்ய ஸம்முகே² ஸ ஸமுபவிஷ்டஸ்தஸ்மிந் காலே பிதரோ யாகூப்³ யோஹந் ஆந்த்³ரியஸ்²சைதே தம்ʼ ரஹஸி பப்ரச்சு²​:, ");
INSERT INTO santam_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ஏதா க⁴டநா​: கதா³ ப⁴விஷ்யந்தி? ததை²தத்ஸர்வ்வாஸாம்ʼ ஸித்³த்⁴யுபக்ரமஸ்ய வா கிம்ʼ சிஹ்நம்ʼ? தத³ஸ்மப்⁴யம்ʼ கத²யது ப⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ததோ யாஸு²ஸ்தாந் வக்துமாரேபே⁴, கோபி யதா² யுஷ்மாந் ந ப்⁴ராமயதி ததா²த்ர யூயம்ʼ ஸாவதா⁴நா ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","யத​: க்²ரீஷ்டோஹமிதி கத²யித்வா மம நாம்நாநேகே ஸமாக³த்ய லோகாநாம்ʼ ப்⁴ரமம்ʼ ஜநயிஷ்யந்தி; ");
INSERT INTO santam_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","கிந்து யூயம்ʼ ரணஸ்ய வார்த்தாம்ʼ ரணாட³ம்ப³ரஞ்ச ஸ்²ருத்வா மா வ்யாகுலா ப⁴வத, க⁴டநா ஏதா அவஸ்²யம்மாவிந்ய​:; கிந்த்வாபாததோ ந யுகா³ந்தோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","தே³ஸ²ஸ்ய விபக்ஷதயா தே³ஸோ² ராஜ்யஸ்ய விபக்ஷதயா ச ராஜ்யமுத்தா²ஸ்யதி, ததா² ஸ்தா²நே ஸ்தா²நே பூ⁴மிகம்போ து³ர்பி⁴க்ஷம்ʼ மஹாக்லேஸா²ஸ்²ச ஸமுபஸ்தா²ஸ்யந்தி, ஸர்வ்வ ஏதே து³​:க²ஸ்யாரம்பா⁴​:| ");
INSERT INTO santam_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","கிந்து யூயம் ஆத்மார்தே² ஸாவதா⁴நாஸ்திஷ்ட²த, யதோ லோகா ராஜஸபா⁴யாம்ʼ யுஷ்மாந் ஸமர்பயிஷ்யந்தி, ததா² ப⁴ஜநக்³ருʼஹே ப்ரஹரிஷ்யந்தி; யூயம்ʼ மத³ர்தே² தே³ஸா²தி⁴பாந் பூ⁴பாம்ʼஸ்²ச ப்ரதி ஸாக்ஷ்யதா³நாய தேஷாம்ʼ ஸம்முகே² உபஸ்தா²பயிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ஸே²ஷீப⁴வநாத் பூர்வ்வம்ʼ ஸர்வ்வாந் தே³ஸீ²யாந் ப்ரதி ஸுஸம்ʼவாத³​: ப்ரசாரயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","கிந்து யதா³ தே யுஷ்மாந் த்⁴ருʼத்வா ஸமர்பயிஷ்யந்தி ததா³ யூயம்ʼ யத்³யத்³ உத்தரம்ʼ தா³ஸ்யத², தத³க்³ர தஸ்ய விவேசநம்ʼ மா குருத தத³ர்த²ம்ʼ கிஞ்சித³பி மா சிந்தயத ச, ததா³நீம்ʼ யுஷ்மாகம்ʼ மந​:ஸு யத்³யத்³ வாக்யம் உபஸ்தா²பயிஷ்யதே ததே³வ வதி³ஷ்யத², யதோ யூயம்ʼ ந தத்³வக்தார​: கிந்து பவித்ர ஆத்மா தஸ்ய வக்தா| ");
INSERT INTO santam_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ததா³ ப்⁴ராதா ப்⁴ராதரம்ʼ பிதா புத்ரம்ʼ கா⁴தநார்த²ம்ʼ பரஹஸ்தேஷு ஸமர்பயிஷ்யதே, ததா² பத்யாநி மாதாபித்ரோ ர்விபக்ஷதயா தௌ கா⁴தயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","மம நாமஹேதோ​: ஸர்வ்வேஷாம்ʼ ஸவிதே⁴ யூயம்ʼ ஜுகு³ப்ஸிதா ப⁴விஷ்யத², கிந்து ய​: கஸ்²சித் ஸே²ஷபர்ய்யந்தம்ʼ தை⁴ர்ய்யம் ஆலம்பி³ஷ்யதே ஸஏவ பரித்ராஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","தா³நியேல்ப⁴விஷ்யத்³வாதி³நா ப்ரோக்தம்ʼ ஸர்வ்வநாஸி² ஜுகு³ப்ஸிதஞ்ச வஸ்து யதா³ த்வயோக்³யஸ்தா²நே வித்³யமாநம்ʼ த்³ரக்ஷத² (யோ ஜந​: பட²தி ஸ பு³த்⁴யதாம்ʼ) ததா³ யே யிஹூதீ³யதே³ஸே² திஷ்ட²ந்தி தே மஹீத்⁴ரம்ʼ ப்ரதி பலாயந்தாம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ததா² யோ நரோ க்³ருʼஹோபரி திஷ்ட²தி ஸ க்³ருʼஹமத்⁴யம்ʼ நாவரோஹது, ததா² கிமபி வஸ்து க்³ரஹீதும்ʼ மத்⁴யேக்³ருʼஹம்ʼ ந ப்ரவிஸ²து; ");
INSERT INTO santam_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ததா² ச யோ நர​: க்ஷேத்ரே திஷ்ட²தி ஸோபி ஸ்வவஸ்த்ரம்ʼ க்³ரஹீதும்ʼ பராவ்ருʼத்ய ந வ்ரஜது| ");
INSERT INTO santam_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ததா³நீம்ʼ க³ர்ப்³ப⁴வதீநாம்ʼ ஸ்தந்யதா³த்ரீணாஞ்ச யோஷிதாம்ʼ து³ர்க³தி ர்ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","யுஷ்மாகம்ʼ பலாயநம்ʼ ஸீ²தகாலே யதா² ந ப⁴வதி தத³ர்த²ம்ʼ ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","யதஸ்ததா³ யாத்³ருʼஸீ² து³ர்க⁴டநா க⁴டிஷ்யதே தாத்³ருʼஸீ² து³ர்க⁴டநா ஈஸ்²வரஸ்ருʼஷ்டே​: ப்ரத²மமாரப்⁴யாத்³ய யாவத் கதா³பி ந ஜாதா ந ஜநிஷ்யதே ச| ");
INSERT INTO santam_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","அபரஞ்ச பரமேஸ்²வரோ யதி³ தஸ்ய ஸமயஸ்ய ஸம்ʼக்ஷேபம்ʼ ந கரோதி தர்ஹி கஸ்யாபி ப்ராணப்⁴ருʼதோ ரக்ஷா ப⁴விதும்ʼ ந ஸ²க்ஷ்யதி, கிந்து யாந் ஜநாந் மநோநீதாந் அகரோத் தேஷாம்ʼ ஸ்வமநோநீதாநாம்ʼ ஹேதோ​: ஸ தத³நேஹஸம்ʼ ஸம்ʼக்ஷேப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","அந்யச்ச பஸ்²யத க்²ரீஷ்டோத்ர ஸ்தா²நே வா தத்ர ஸ்தா²நே வித்³யதே, தஸ்மிந்காலே யதி³ கஸ்²சித்³ யுஷ்மாந் ஏதாத்³ருʼஸ²ம்ʼ வாக்யம்ʼ வ்யாஹரதி, தர்ஹி தஸ்மிந் வாக்யே பை⁴வ விஸ்²வஸித| ");
INSERT INTO santam_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","யதோநேகே மித்²யாக்²ரீஷ்டா மித்²யாப⁴விஷ்யத்³வாதி³நஸ்²ச ஸமுபஸ்தா²ய ப³ஹூநி சிஹ்நாந்யத்³பு⁴தாநி கர்ம்மாணி ச த³ர்ஸ²யிஷ்யந்தி; ததா² யதி³ ஸம்ப⁴வதி தர்ஹி மநோநீதலோகாநாமபி மித்²யாமதிம்ʼ ஜநயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","பஸ்²யத க⁴டநாத​: பூர்வ்வம்ʼ ஸர்வ்வகார்ய்யஸ்ய வார்த்தாம்ʼ யுஷ்மப்⁴யமதா³ம், யூயம்ʼ ஸாவதா⁴நாஸ்திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","அபரஞ்ச தஸ்ய க்லேஸ²காலஸ்யாவ்யவஹிதே பரகாலே பா⁴ஸ்கர​: ஸாந்த⁴காரோ ப⁴விஷ்யதி ததை²வ சந்த்³ரஸ்²சந்த்³ரிகாம்ʼ ந தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","நப⁴​:ஸ்தா²நி நக்ஷத்ராணி பதிஷ்யந்தி, வ்யோமமண்ட³லஸ்தா² க்³ரஹாஸ்²ச விசலிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ததா³நீம்ʼ மஹாபராக்ரமேண மஹைஸ்²வர்ய்யேண ச மேக⁴மாருஹ்ய ஸமாயாந்தம்ʼ மாநவஸுதம்ʼ மாநவா​: ஸமீக்ஷிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","அந்யச்ச ஸ நிஜதூ³தாந் ப்ரஹித்ய நபோ⁴பூ⁴ம்யோ​: ஸீமாம்ʼ யாவத்³ ஜக³தஸ்²சதுர்தி³க்³ப்⁴ய​: ஸ்வமநோநீதலோகாந் ஸம்ʼக்³ரஹீஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","உடு³ம்ப³ரதரோ ர்த்³ருʼஷ்டாந்தம்ʼ ஸி²க்ஷத்⁴வம்ʼ யதோ³டு³ம்ப³ரஸ்ய தரோ ர்நவீநா​: ஸா²கா² ஜாயந்தே பல்லவாதீ³நி ச ர்நிக³ச்ச²ந்தி, ததா³ நிதா³க⁴கால​: ஸவிதோ⁴ ப⁴வதீதி யூயம்ʼ ஜ்ஞாதும்ʼ ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","தத்³வத்³ ஏதா க⁴டநா த்³ருʼஷ்ட்வா ஸ காலோ த்³வார்ய்யுபஸ்தி²த இதி ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, ஆது⁴நிகலோகாநாம்ʼ க³மநாத் பூர்வ்வம்ʼ தாநி ஸர்வ்வாணி க⁴டிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","த்³யாவாப்ருʼதி²வ்யோ ர்விசலிதயோ​: ஸத்யோ ர்மதீ³யா வாணீ ந விசலிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","அபரஞ்ச ஸ்வர்க³ஸ்த²தூ³தக³ணோ வா புத்ரோ வா தாதாத³ந்ய​: கோபி தம்ʼ தி³வஸம்ʼ தம்ʼ த³ண்ட³ம்ʼ வா ந ஜ்ஞாபயதி| ");
INSERT INTO santam_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","அத​: ஸ ஸமய​: கதா³ ப⁴விஷ்யதி, ஏதஜ்ஜ்ஞாநாபா⁴வாத்³ யூயம்ʼ ஸாவதா⁴நாஸ்திஷ்ட²த, ஸதர்காஸ்²ச பூ⁴த்வா ப்ரார்த²யத்⁴வம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","யத்³வத் கஸ்²சித் புமாந் ஸ்வநிவேஸ²நாத்³ தூ³ரதே³ஸ²ம்ʼ ப்ரதி யாத்ராகரணகாலே தா³ஸேஷு ஸ்வகார்ய்யஸ்ய பா⁴ரமர்பயித்வா ஸர்வ்வாந் ஸ்வே ஸ்வே கர்ம்மணி நியோஜயதி; அபரம்ʼ தௌ³வாரிகம்ʼ ஜாக³ரிதும்ʼ ஸமாதி³ஸ்²ய யாதி, தத்³வந் நரபுத்ர​:| ");
INSERT INTO santam_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","க்³ருʼஹபதி​: ஸாயம்ʼகாலே நிஸீ²தே² வா த்ருʼதீயயாமே வா ப்ராத​:காலே வா கதா³க³மிஷ்யதி தத்³ யூயம்ʼ ந ஜாநீத²; ");
INSERT INTO santam_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ஸ ஹடா²தா³க³த்ய யதா² யுஷ்மாந் நித்³ரிதாந் ந பஸ்²யதி, தத³ர்த²ம்ʼ ஜாக³ரிதாஸ்திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","யுஷ்மாநஹம்ʼ யத்³ வதா³மி ததே³வ ஸர்வ்வாந் வதா³மி, ஜாக³ரிதாஸ்திஷ்ட²தேதி| ");
INSERT INTO santam_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ததா³ நிஸ்தாரோத்ஸவகிண்வஹீநபூபோத்ஸவயோராரம்ப⁴ஸ்ய தி³நத்³வயே (அ)வஸி²ஷ்டே ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச கேநாபி ச²லேந யீஸு²ம்ʼ த⁴ர்த்தாம்ʼ ஹந்துஞ்ச ம்ருʼக³யாஞ்சக்ரிரே; ");
INSERT INTO santam_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","கிந்து லோகாநாம்ʼ கலஹப⁴யாதூ³சிரே, நசோத்ஸவகால உசிதமேததி³தி| ");
INSERT INTO santam_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","அநந்தரம்ʼ பை³த²நியாபுुரே ஸி²மோநகுஷ்டி²நோ க்³ருʼஹே யோஸௌ² போ⁴த்குமுபவிஷ்டே ஸதி காசித்³ யோஷித் பாண்ட³ரபாஷாணஸ்ய ஸம்புடகேந மஹார்க்⁴யோத்தமதைலம் ஆநீய ஸம்புடகம்ʼ ப⁴ம்ʼக்த்வா தஸ்யோத்தமாங்கே³ தைலதா⁴ராம்ʼ பாதயாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","தஸ்மாத் கேசித் ஸ்வாந்தே குப்யந்த​: கதி²தவம்ʼந்த​: குதோயம்ʼ தைலாபவ்யய​:? ");
INSERT INTO santam_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","யத்³யேதத் தைல வ்யக்ரேஷ்யத தர்ஹி முத்³ராபாத³ஸ²தத்ரயாத³ப்யதி⁴கம்ʼ தஸ்ய ப்ராப்தமூல்யம்ʼ த³ரித்³ரலோகேப்⁴யோ தா³துமஸ²க்ஷ்யத, கதா²மேதாம்ʼ கத²யித்வா தயா யோஷிதா ஸாகம்ʼ வாசாயுஹ்யந்| ");
INSERT INTO santam_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","கிந்து யீஸு²ருவாச, குத ஏதஸ்யை க்ருʼச்ச்²ரம்ʼ த³தா³ஸி? மஹ்யமியம்ʼ கர்ம்மோத்தமம்ʼ க்ருʼதவதீ| ");
INSERT INTO santam_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","த³ரித்³ரா​: ஸர்வ்வதா³ யுஷ்மாபி⁴​: ஸஹ திஷ்ட²ந்தி, தஸ்மாத்³ யூயம்ʼ யதே³ச்ச²த² ததை³வ தாநுபகர்த்தாம்ʼ ஸ²க்நுத², கிந்த்வஹம்ʼ யுபா⁴பி⁴​: ஸஹ நிரந்தரம்ʼ ந திஷ்டா²மி| ");
INSERT INTO santam_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","அஸ்யா யதா²ஸாத்⁴யம்ʼ ததை²வாகரோதி³யம்ʼ, ஸ்²மஸா²நயாபநாத் பூர்வ்வம்ʼ ஸமேத்ய மத்³வபுஷி தைலம் அமர்த்³த³யத்| ");
INSERT INTO santam_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","அஹம்ʼ யுஷ்மப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி, ஜக³தாம்ʼ மத்⁴யே யத்ர யத்ர ஸுஸம்ʼவாதோ³யம்ʼ ப்ரசாரயிஷ்யதே தத்ர தத்ர யோஷித ஏதஸ்யா​: ஸ்மரணார்த²ம்ʼ தத்க்ருʼதகர்ம்மைதத் ப்ரசாரயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","தத​: பரம்ʼ த்³வாத³ஸா²நாம்ʼ ஸி²ஷ்யாணாமேக ஈஷ்கரியோதீயயிஹூதா³க்²யோ யீஸு²ம்ʼ பரகரேஷு ஸமர்பயிதும்ʼ ப்ரதா⁴நயாஜகாநாம்ʼ ஸமீபமியாய| ");
INSERT INTO santam_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","தே தஸ்ய வாக்யம்ʼ ஸமாகர்ண்ய ஸந்துஷ்டா​: ஸந்தஸ்தஸ்மை முத்³ரா தா³தும்ʼ ப்ரத்யஜாநத; தஸ்மாத் ஸ தம்ʼ தேஷாம்ʼ கரேஷு ஸமர்பணாயோபாயம்ʼ ம்ருʼக³யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","அநந்தரம்ʼ கிண்வஸூ²ந்யபூபோத்ஸவஸ்ய ப்ரத²மே(அ)ஹநி நிஸ்தாரோத்மவார்த²ம்ʼ மேஷமாரணாஸமயே ஸி²ஷ்யாஸ்தம்ʼ பப்ரச்ச²​: குத்ர க³த்வா வயம்ʼ நிஸ்தாரோத்ஸவஸ்ய போ⁴ஜ்யமாஸாத³யிஷ்யாம​:? கிமிச்ச²தி ப⁴வாந்? ");
INSERT INTO santam_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ததா³நீம்ʼ ஸ தேஷாம்ʼ த்³வயம்ʼ ப்ரேரயந் ப³பா⁴ஷே யுவயோ​: புரமத்⁴யம்ʼ க³தயோ​: ஸதோ ர்யோ ஜந​: ஸஜலகும்ப⁴ம்ʼ வஹந் யுவாம்ʼ ஸாக்ஷாத் கரிஷ்யதி தஸ்யைவ பஸ்²சாத்³ யாதம்ʼ; ");
INSERT INTO santam_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ஸ யத் ஸத³நம்ʼ ப்ரவேக்ஷ்யதி தத்³ப⁴வநபதிம்ʼ வத³தம்ʼ, கு³ருராஹ யத்ர ஸஸி²ஷ்யோஹம்ʼ நிஸ்தாரோத்ஸவீயம்ʼ போ⁴ஜநம்ʼ கரிஷ்யாமி, ஸா போ⁴ஜநஸா²லா குத்ராஸ்தி? ");
INSERT INTO santam_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","தத​: ஸ பரிஷ்க்ருʼதாம்ʼ ஸுஸஜ்ஜிதாம்ʼ ப்³ருʼஹதீசஞ்ச யாம்ʼ ஸா²லாம்ʼ த³ர்ஸ²யிஷ்யதி தஸ்யாமஸ்மத³ர்த²ம்ʼ போ⁴ஜ்யத்³ரவ்யாண்யாஸாத³யதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","தத​: ஸி²ஷ்யௌ ப்ரஸ்தா²ய புரம்ʼ ப்ரவிஸ்²ய ஸ யதோ²க்தவாந் ததை²வ ப்ராப்ய நிஸ்தாரோத்ஸவஸ்ய போ⁴ஜ்யத்³ரவ்யாணி ஸமாஸாத³யேதாம்| ");
INSERT INTO santam_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","அநந்தரம்ʼ யீஸு²​: ஸாயம்ʼகாலே த்³வாத³ஸ²பி⁴​: ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ ஜகா³ம; ");
INSERT INTO santam_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ஸர்வ்வேஷு போ⁴ஜநாய ப்ரோபவிஷ்டேஷு ஸ தாநுதி³தவாந் யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வ்யாஹராமி, அத்ர யுஷ்மாகமேகோ ஜநோ யோ மயா ஸஹ பு⁴ம்ʼக்தே மாம்ʼ பரகேரேஷு ஸமர்பயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ததா³நீம்ʼ தே து³​:கி²தா​: ஸந்த ஏகைகஸ²ஸ்தம்ʼ ப்ரஷ்டுமாரப்³த⁴வந்த​: ஸ கிமஹம்ʼ? பஸ்²சாத்³ அந்ய ஏகோபி⁴த³தே⁴ ஸ கிமஹம்ʼ? ");
INSERT INTO santam_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","தத​: ஸ ப்ரத்யவத³த்³ ஏதேஷாம்ʼ த்³வாத³ஸா²நாம்ʼ யோ ஜநோ மயா ஸமம்ʼ போ⁴ஜநாபாத்ரே பாணிம்ʼ மஜ்ஜயிஷ்யதி ஸ ஏவ| ");
INSERT INTO santam_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","மநுஜதநயமதி⁴ யாத்³ருʼஸ²ம்ʼ லிகி²தமாஸ்தே தத³நுரூபா க³திஸ்தஸ்ய ப⁴விஷ்யதி, கிந்து யோ ஜநோ மாநவஸுதம்ʼ ஸமர்பயிஷ்யதே ஹந்த தஸ்ய ஜந்மாபா⁴வே ஸதி ப⁴த்³ரமப⁴விஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","அபரஞ்ச தேஷாம்ʼ போ⁴ஜநஸமயே யீஸு²​: பூபம்ʼ க்³ருʼஹீத்வேஸ்²வரகு³ணாந் அநுகீர்த்ய ப⁴ங்க்த்வா தேப்⁴யோ த³த்த்வா ப³பா⁴ஷே, ஏதத்³ க்³ருʼஹீத்வா பு⁴ஞ்ஜீத்⁴வம் ஏதந்மம விக்³ரஹரூபம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","அநந்தரம்ʼ ஸ கம்ʼஸம்ʼ க்³ருʼஹீத்வேஸ்²வரஸ்ய கு³ணாந் கீர்த்தயித்வா தேப்⁴யோ த³தௌ³, ததஸ்தே ஸர்வ்வே பபு​:| ");
INSERT INTO santam_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","அபரம்ʼ ஸ தாநவாதீ³த்³ ப³ஹூநாம்ʼ நிமித்தம்ʼ பாதிதம்ʼ மம நவீநநியமரூபம்ʼ ஸோ²ணிதமேதத்| ");
INSERT INTO santam_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, ஈஸ்²வரஸ்ய ராஜ்யே யாவத் ஸத்³யோஜாதம்ʼ த்³ராக்ஷாரஸம்ʼ ந பாஸ்யாமி,தாவத³ஹம்ʼ த்³ராக்ஷாப²லரஸம்ʼ புந ர்ந பாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","தத³நந்தரம்ʼ தே கீ³தமேகம்ʼ ஸம்ʼகீ³ய ப³ஹி ர்ஜைதுநம்ʼ ஸி²க²ரிணம்ʼ யயு​: ");
INSERT INTO santam_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","அத² யீஸு²ஸ்தாநுவாச நிஸா²யாமஸ்யாம்ʼ மயி யுஷ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ ப்ரத்யூஹோ ப⁴விஷ்யதி யதோ லிகி²தமாஸ்தே யதா², மேஷாணாம்ʼ ரக்ஷகஞ்சாஹம்ʼ ப்ரஹரிஷ்யாமி வை தத​:| மேஷாணாம்ʼ நிவஹோ நூநம்ʼ ப்ரவிகீர்ணோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","கந்து மது³த்தா²நே ஜாதே யுஷ்மாகமக்³ரே(அ)ஹம்ʼ கா³லீலம்ʼ வ்ரஜிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ததா³ பிதர​: ப்ரதிப³பா⁴ஷே, யத்³யபி ஸர்வ்வேஷாம்ʼ ப்ரத்யூஹோ ப⁴வதி ததா²பி மம நைவ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ததோ யீஸு²ருக்தாவாந் அஹம்ʼ துப்⁴யம்ʼ தத்²யம்ʼ கத²யாமி, க்ஷணாதா³யாமத்³ய குக்குடஸ்ய த்³விதீயவாரரவணாத் பூர்வ்வம்ʼ த்வம்ʼ வாரத்ரயம்ʼ மாமபஹ்நோஷ்யஸே| ");
INSERT INTO santam_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","கிந்து ஸ கா³ட⁴ம்ʼ வ்யாஹரத்³ யத்³யபி த்வயா ஸார்த்³த⁴ம்ʼ மம ப்ராணோ யாதி ததா²பி கத²மபி த்வாம்ʼ நாபஹ்நோஷ்யே; ஸர்வ்வே(அ)பீதரே ததை²வ ப³பா⁴ஷிரே| ");
INSERT INTO santam_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","அபரஞ்ச தேஷு கே³த்ஸி²மாநீநாமகம்ʼ ஸ்தா²ந க³தேஷு ஸ ஸி²ஷ்யாந் ஜகா³த³, யாவத³ஹம்ʼ ப்ரார்த²யே தாவத³த்ர ஸ்தா²நே யூயம்ʼ ஸமுபவிஸ²த| ");
INSERT INTO santam_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","அத² ஸ பிதரம்ʼ யாகூப³ம்ʼ யோஹநஞ்ச க்³ருʼஹீத்வா வவ்ராஜ; அத்யந்தம்ʼ த்ராஸிதோ வ்யாகுலிதஸ்²ச தேப்⁴ய​: கத²யாமாஸ, ");
INSERT INTO santam_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","நித⁴நகாலவத் ப்ராணோ மே(அ)தீவ த³​:க²மேதி, யூயம்ʼ ஜாக்³ரதோத்ர ஸ்தா²நே திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","தத​: ஸ கிஞ்சித்³தூ³ரம்ʼ க³த்வா பூ⁴மாவதோ⁴முக²​: பதித்வா ப்ரார்தி²தவாநேதத், யதி³ ப⁴விதும்ʼ ஸ²க்யம்ʼ தர்ஹி து³​:க²ஸமயோயம்ʼ மத்தோ தூ³ரீப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","அபரமுதி³தவாந் ஹே பித ர்ஹே பித​: ஸர்வ்வேம்ʼ த்வயா ஸாத்⁴யம்ʼ, ததோ ஹேதோரிமம்ʼ கம்ʼஸம்ʼ மத்தோ தூ³ரீகுரு, கிந்து தந் மமேச்சா²தோ ந தவேச்சா²தோ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","தத​: பரம்ʼ ஸ ஏத்ய தாந் நித்³ரிதாந் நிரீக்ஷ்ய பிதரம்ʼ ப்ரோவாச, ஸி²மோந் த்வம்ʼ கிம்ʼ நித்³ராஸி? க⁴டிகாமேகாம் அபி ஜாக³ரிதும்ʼ ந ஸ²க்நோஷி? ");
INSERT INTO santam_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","பரீக்ஷாயாம்ʼ யதா² ந பதத² தத³ர்த²ம்ʼ ஸசேதநா​: ஸந்த​: ப்ரார்த²யத்⁴வம்ʼ; மந உத்³யுக்தமிதி ஸத்யம்ʼ கிந்து வபுரஸ²க்திகம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","அத² ஸ புநர்வ்ரஜித்வா பூர்வ்வவத் ப்ரார்த²யாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","பராவ்ருʼத்யாக³த்ய புநரபி தாந் நித்³ரிதாந் த³த³ர்ஸ² ததா³ தேஷாம்ʼ லோசநாநி நித்³ரயா பூர்ணாநி, தஸ்மாத்தஸ்மை கா கதா² கத²யிதவ்யா த ஏதத்³ போ³த்³து⁴ம்ʼ ந ஸே²கு​:| ");
INSERT INTO santam_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","தத​:பரம்ʼ த்ருʼதீயவாரம்ʼ ஆக³த்ய தேப்⁴யோ (அ)கத²யத்³ இதா³நீமபி ஸ²யித்வா விஸ்²ராம்யத²? யதே²ஷ்டம்ʼ ஜாதம்ʼ, ஸமயஸ்²சோபஸ்தி²த​: பஸ்²யத மாநவதநய​: பாபிலோகாநாம்ʼ பாணிஷு ஸமர்ப்யதே| ");
INSERT INTO santam_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","உத்திஷ்ட²த, வயம்ʼ வ்ரஜாமோ யோ ஜநோ மாம்ʼ பரபாணிஷு ஸமர்பயிஷ்யதே பஸ்²யத ஸ ஸமீபமாயாத​:| ");
INSERT INTO santam_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","இமாம்ʼ கதா²ம்ʼ கத²யதி ஸ, ஏதர்ஹித்³வாத³ஸா²நாமேகோ யிஹூதா³ நாமா ஸி²ஷ்ய​: ப்ரதா⁴நயாஜகாநாம் உபாத்⁴யாயாநாம்ʼ ப்ராசீநலோகாநாஞ்ச ஸந்நிதே⁴​: க²ங்க³லகு³ட³தா⁴ரிணோ ப³ஹுலோகாந் க்³ருʼஹீத்வா தஸ்ய ஸமீப உபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","அபரஞ்சாஸௌ பரபாணிஷு ஸமர்பயிதா பூர்வ்வமிதி ஸங்கேதம்ʼ க்ருʼதவாந் யமஹம்ʼ சும்பி³ஷ்யாமி ஸ ஏவாஸௌ தமேவ த்⁴ருʼத்வா ஸாவதா⁴நம்ʼ நயத| ");
INSERT INTO santam_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","அதோ ஹேதோ​: ஸ ஆக³த்யைவ யோஸோ²​: ஸவித⁴ம்ʼ க³த்வா ஹே கு³ரோ ஹே கு³ரோ, இத்யுக்த்வா தம்ʼ சுசும்ப³| ");
INSERT INTO santam_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ததா³ தே தது³பரி பாணீநர்பயித்வா தம்ʼ த³த்⁴நு​:| ");
INSERT INTO santam_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ததஸ்தஸ்ய பார்ஸ்²வஸ்தா²நாம்ʼ லோகாநாமேக​: க²ங்க³ம்ʼ நிஷ்கோஷயந் மஹாயாஜகஸ்ய தா³ஸமேகம்ʼ ப்ரஹ்ருʼத்ய தஸ்ய கர்ணம்ʼ சிச்சே²த³| ");
INSERT INTO santam_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","பஸ்²சாத்³ யீஸு²ஸ்தாந் வ்யாஜஹார க²ங்கா³ந் லகு³டா³ம்ʼஸ்²ச க்³ருʼஹீத்வா மாம்ʼ கிம்ʼ சௌரம்ʼ த⁴ர்த்தாம்ʼ ஸமாயாதா​:? ");
INSERT INTO santam_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","மத்⁴யேமந்தி³ரம்ʼ ஸமுபதி³ஸ²ந் ப்ரத்யஹம்ʼ யுஷ்மாபி⁴​: ஸஹ ஸ்தி²தவாநதஹம்ʼ, தஸ்மிந் காலே யூயம்ʼ மாம்ʼ நாதீ³த⁴ரத, கிந்த்வநேந ஸா²ஸ்த்ரீயம்ʼ வசநம்ʼ ஸேத⁴நீயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ததா³ ஸர்வ்வே ஸி²ஷ்யாஸ்தம்ʼ பரித்யஜ்ய பலாயாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","அதை²கோ யுவா மாநவோ நக்³நகாயே வஸ்த்ரமேகம்ʼ நிதா⁴ய தஸ்ய பஸ்²சாத்³ வ்ரஜந் யுவலோகை ர்த்⁴ருʼதோ ");
INSERT INTO santam_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","வஸ்த்ரம்ʼ விஹாய நக்³ந​: பலாயாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","அபரஞ்ச யஸ்மிந் ஸ்தா²நே ப்ரதா⁴நயாஜகா உபாத்⁴யாயா​: ப்ராசீநலோகாஸ்²ச மஹாயாஜகேந ஸஹ ஸத³ஸி ஸ்தி²தாஸ்தஸ்மிந் ஸ்தா²நே மஹாயாஜகஸ்ய ஸமீபம்ʼ யீஸு²ம்ʼ நிந்யு​:| ");
INSERT INTO santam_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","பிதரோ தூ³ரே தத்பஸ்²சாத்³ இத்வா மஹாயாஜகஸ்யாட்டாலிகாம்ʼ ப்ரவிஸ்²ய கிங்கரை​: ஸஹோபவிஸ்²ய வஹ்நிதாபம்ʼ ஜக்³ராஹ| ");
INSERT INTO santam_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ததா³நீம்ʼ ப்ரதா⁴நயாஜகா மந்த்ரிணஸ்²ச யீஸு²ம்ʼ கா⁴தயிதும்ʼ தத்ப்ராதிகூல்யேந ஸாக்ஷிணோ ம்ருʼக³யாஞ்சக்ரிரே, கிந்து ந ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","அநேகைஸ்தத்³விருத்³த⁴ம்ʼ ம்ருʼஷாஸாக்ஷ்யே த³த்தேபி தேஷாம்ʼ வாக்யாநி ந ஸமக³ச்ச²ந்த| ");
INSERT INTO santam_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ஸர்வ்வஸே²ஷே கியந்த உத்தா²ய தஸ்ய ப்ராதிகூல்யேந ம்ருʼஷாஸாக்ஷ்யம்ʼ த³த்த்வா கத²யாமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","இத³ம்ʼ கரக்ருʼதமந்தி³ரம்ʼ விநாஸ்²ய தி³நத்ரயமத்⁴யே புநரபரம் அகரக்ருʼதம்ʼ மந்தி³ரம்ʼ நிர்ம்மாஸ்யாமி, இதி வாக்யம் அஸ்ய முகா²த் ஸ்²ருதமஸ்மாபி⁴ரிதி| ");
INSERT INTO santam_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","கிந்து தத்ராபி தேஷாம்ʼ ஸாக்ஷ்யகதா² ந ஸங்கா³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","அத² மஹாயாஜகோ மத்⁴யேஸப⁴ம் உத்தா²ய யீஸு²ம்ʼ வ்யாஜஹார, ஏதே ஜநாஸ்த்வயி யத் ஸாக்ஷ்யமது³​: த்வமேதஸ்ய கிமப்யுத்தரம்ʼ கிம்ʼ ந தா³ஸ்யஸி? ");
INSERT INTO santam_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","கிந்து ஸ கிமப்யுத்தரம்ʼ ந த³த்வா மௌநீபூ⁴ய தஸ்யௌ; ததோ மஹாயாஜக​: புநரபி தம்ʼ ப்ருʼஷ்டாவாந் த்வம்ʼ ஸச்சிதா³நந்த³ஸ்ய தநயோ (அ)பி⁴ஷிக்தஸ்த்ரதா? ");
INSERT INTO santam_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ததா³ யீஸு²ஸ்தம்ʼ ப்ரோவாச ப⁴வாம்யஹம் யூயஞ்ச ஸர்வ்வஸ²க்திமதோ த³க்ஷீணபார்ஸ்²வே ஸமுபவிஸ²ந்தம்ʼ மேக⁴ மாருஹ்ய ஸமாயாந்தஞ்ச மநுஷ்யபுத்ரம்ʼ ஸந்த்³ரக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ததா³ மஹாயாஜக​: ஸ்வம்ʼ வமநம்ʼ சி²த்வா வ்யாவஹரத் ");
INSERT INTO santam_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","கிமஸ்மாகம்ʼ ஸாக்ஷிபி⁴​: ப்ரயோஜநம்? ஈஸ்²வரநிந்தா³வாக்யம்ʼ யுஷ்மாபி⁴ரஸ்²ராவி கிம்ʼ விசாரயத²? ததா³நீம்ʼ ஸர்வ்வே ஜக³து³ரயம்ʼ நித⁴நத³ண்ட³மர்ஹதி| ");
INSERT INTO santam_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","தத​: கஸ்²சித் கஸ்²சித் தத்³வபுஷி நிஷ்டீ²வம்ʼ நிசிக்ஷேப ததா² தந்முக²மாச்சா²த்³ய சபேடேந ஹத்வா க³தி³தவாந் க³ணயித்வா வத³, அநுசராஸ்²ச சபேடைஸ்தமாஜக்⁴நு​: ");
INSERT INTO santam_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","தத​: பரம்ʼ பிதரே(அ)ட்டாலிகாத⁴​:கோஷ்டே² திஷ்ட²தி மஹாயாஜகஸ்யைகா தா³ஸீ ஸமேத்ய ");
INSERT INTO santam_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","தம்ʼ விஹ்நிதாபம்ʼ க்³ருʼஹ்லந்தம்ʼ விலோக்ய தம்ʼ ஸுநிரீக்ஷ்ய ப³பா⁴ஷே த்வமபி நாஸரதீயயீஸோ²​: ஸங்கி³நாம் ஏகோ ஜந ஆஸீ​:| ");
INSERT INTO santam_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","கிந்து ஸோபஹ்நுத்ய ஜகா³த³ தமஹம்ʼ ந வத்³மி த்வம்ʼ யத் கத²யமி தத³ப்யஹம்ʼ ந பு³த்³த்⁴யே| ததா³நீம்ʼ பிதரே சத்வரம்ʼ க³தவதி குेக்குடோ ருராவ| ");
INSERT INTO santam_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","அதா²ந்யா தா³ஸீ பிதரம்ʼ த்³ருʼஷ்ட்வா ஸமீபஸ்தா²ந் ஜநாந் ஜகா³த³ அயம்ʼ தேஷாமேகோ ஜந​:| ");
INSERT INTO santam_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","தத​: ஸ த்³விதீயவாரம் அபஹ்நுதவாந் பஸ்²சாத் தத்ரஸ்தா² லோகா​: பிதரம்ʼ ப்ரோசுஸ்த்வமவஸ்²யம்ʼ தேஷாமேகோ ஜந​: யதஸ்த்வம்ʼ கா³லீலீயோ நர இதி தவோச்சாரணம்ʼ ப்ரகாஸ²யதி| ");
INSERT INTO santam_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ததா³ ஸ ஸ²பதா²பி⁴ஸா²பௌ க்ருʼத்வா ப்ரோவாச யூயம்ʼ கதா²ம்ʼ கத²யத² தம்ʼ நரம்ʼ ந ஜாநே(அ)ஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ததா³நீம்ʼ த்³விதீயவாரம்ʼ குக்குடோ (அ)ராவீத்| குக்குடஸ்ய த்³விதீயரவாத் பூர்வ்வம்ʼ த்வம்ʼ மாம்ʼ வாரத்ரயம் அபஹ்நோஷ்யஸி, இதி யத்³வாக்யம்ʼ யீஸு²நா ஸமுதி³தம்ʼ தத் ததா³ ஸம்ʼஸ்ம்ருʼத்ய பிதரோ ரோதி³தும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","அத² ப்ரபா⁴தே ஸதி ப்ரதா⁴நயாஜகா​: ப்ராஞ்ச உபாத்⁴யாயா​: ஸர்வ்வே மந்த்ரிணஸ்²ச ஸபா⁴ம்ʼ க்ருʼத்வா யீஸு²ृம்ʼ ப³ந்த⁴யித்வ பீலாதாக்²யஸ்ய தே³ஸா²தி⁴பதே​: ஸவித⁴ம்ʼ நீத்வா ஸமர்பயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ததா³ பீலாதஸ்தம்ʼ ப்ருʼஷ்டவாந் த்வம்ʼ கிம்ʼ யிஹூதீ³யலோகாநாம்ʼ ராஜா? தத​: ஸ ப்ரத்யுக்தவாந் ஸத்யம்ʼ வத³ஸி| ");
INSERT INTO santam_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","அபரம்ʼ ப்ரதா⁴நயாஜகாஸ்தஸ்ய ப³ஹுஷு வாக்யேஷு தோ³ஷமாரோபயாஞ்சக்ரு​: கிந்து ஸ கிமபி ந ப்ரத்யுவாச| ");
INSERT INTO santam_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ததா³நீம்ʼ பீலாதஸ்தம்ʼ புந​: பப்ரச்ச² த்வம்ʼ கிம்ʼ நோத்தரயஸி? பஸ்²யைதே த்வத்³விருத்³த⁴ம்ʼ கதிஷு ஸாத்⁴யேஷு ஸாக்ஷம்ʼ த³த³தி| ");
INSERT INTO santam_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","கந்து யீஸு²ஸ்ததா³பி நோத்தரம்ʼ த³தௌ³ தத​: பீலாத ஆஸ்²சர்ய்யம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","அபரஞ்ச காராப³த்³தே⁴ கஸ்திம்ʼஸ்²சித் ஜநே தந்மஹோத்ஸவகாலே லோகை ர்யாசிதே தே³ஸா²தி⁴பதிஸ்தம்ʼ மோசயதி| ");
INSERT INTO santam_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","யே ச பூர்வ்வமுபப்லவமகார்ஷுருபப்லவே வத⁴மபி க்ருʼதவந்தஸ்தேஷாம்ʼ மத்⁴யே ததா³நோம்ʼ ப³ரப்³பா³நாமக ஏகோ ப³த்³த⁴ ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","அதோ ஹேதோ​: பூர்வ்வாபரீயாம்ʼ ரீதிகதா²ம்ʼ கத²யித்வா லோகா உச்சைருவந்த​: பீலாதஸ்ய ஸமக்ஷம்ʼ நிவேத³யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ததா³ பீலாதஸ்தாநாசக்²யௌ தர்ஹி கிம்ʼ யிஹூதீ³யாநாம்ʼ ராஜாநம்ʼ மோசயிஷ்யாமி? யுஷ்மாபி⁴​: கிமிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","யத​: ப்ரதா⁴நயாஜகா ஈர்ஷ்யாத ஏவ யீஸு²ம்ʼ ஸமார்பயந்நிதி ஸ விவேத³| ");
INSERT INTO santam_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","கிந்து யதா² ப³ரப்³பா³ம்ʼ மோசயதி ததா² ப்ரார்த²யிதும்ʼ ப்ரதா⁴நயாஜகா லோகாந் ப்ரவர்த்தயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","அத² பீலாத​: புந​: ப்ருʼஷ்டவாந் தர்ஹி யம்ʼ யிஹூதீ³யாநாம்ʼ ராஜேதி வத³த² தஸ்ய கிம்ʼ கரிஷ்யாமி யுஷ்மாபி⁴​: கிமிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ததா³ தே புநரபி ப்ரோச்சை​: ப்ரோசுஸ்தம்ʼ க்ருஸே² வேத⁴ய| ");
INSERT INTO santam_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","தஸ்மாத் பீலாத​: கதி²தவாந் குத​:? ஸ கிம்ʼ குகர்ம்ம க்ருʼதவாந்? கிந்து தே புநஸ்²ச ருவந்தோ வ்யாஜஹ்ருஸ்தம்ʼ க்ருஸே² வேத⁴ய| ");
INSERT INTO santam_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ததா³ பீலாத​: ஸர்வ்வால்லோகாந் தோஷயிதுமிச்ச²ந் ப³ரப்³பா³ம்ʼ மோசயித்வா யீஸு²ம்ʼ கஸா²பி⁴​: ப்ரஹ்ருʼத்ய க்ருஸே² வேத்³து⁴ம்ʼ தம்ʼ ஸமர்பயாம்ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","அநந்தரம்ʼ ஸைந்யக³ணோ(அ)ட்டாலிகாம் அர்தா²த்³ அதி⁴பதே ர்க்³ருʼஹம்ʼ யீஸு²ம்ʼ நீத்வா ஸேநாநிவஹம்ʼ ஸமாஹுயத்| ");
INSERT INTO santam_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","பஸ்²சாத் தே தம்ʼ தூ⁴மலவர்ணவஸ்த்ரம்ʼ பரிதா⁴ப்ய கண்டகமுகுடம்ʼ ரசயித்வா ஸி²ரஸி ஸமாரோப்ய ");
INSERT INTO santam_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ஹே யிஹூதீ³யாநாம்ʼ ராஜந் நமஸ்கார இத்யுக்த்வா தம்ʼ நமஸ்கர்த்தாமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","தஸ்யோத்தமாங்கே³ வேத்ராகா⁴தம்ʼ சக்ருஸ்தத்³கா³த்ரே நிஷ்டீ²வஞ்ச நிசிக்ஷிபு​:, ததா² தஸ்ய ஸம்முகே² ஜாநுபாதம்ʼ ப்ரணோமு​: ");
INSERT INTO santam_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","இத்த²முபஹஸ்ய தூ⁴ம்ரவர்ணவஸ்த்ரம் உத்தார்ய்ய தஸ்ய வஸ்த்ரம்ʼ தம்ʼ பர்ய்யதா⁴பயந் க்ருஸே² வேத்³து⁴ம்ʼ ப³ஹிர்நிந்யுஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","தத​: பரம்ʼ ஸேகந்த³ரஸ்ய ருப²ஸ்ய ச பிதா ஸி²மோந்நாமா குரீணீயலோக ஏக​: குதஸ்²சித்³ க்³ராமாதே³த்ய பதி² யாதி தம்ʼ தே யீஸோ²​: க்ருஸ²ம்ʼ வோடு⁴ம்ʼ ப³லாத்³ த³த்⁴நு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","அத² கு³ல்க³ல்தா அர்தா²த் ஸி²ர​:கபாலநாமகம்ʼ ஸ்தா²நம்ʼ யீஸு²மாநீய ");
INSERT INTO santam_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","தே க³ந்த⁴ரஸமிஸ்²ரிதம்ʼ த்³ராக்ஷாரஸம்ʼ பாதும்ʼ தஸ்மை த³து³​: கிந்து ஸ ந ஜக்³ராஹ| ");
INSERT INTO santam_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","தஸ்மிந் க்ருஸே² வித்³தே⁴ ஸதி தேஷாமேகைகஸ²​: கிம்ʼ ப்ராப்ஸ்யதீதி நிர்ணயாய ");
INSERT INTO santam_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","தஸ்ய பரிதே⁴யாநாம்ʼ விபா⁴கா³ர்த²ம்ʼ கு³டிகாபாதம்ʼ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","அபரம் ஏஷ யிஹூதீ³யாநாம்ʼ ராஜேதி லிகி²தம்ʼ தோ³ஷபத்ரம்ʼ தஸ்ய ஸி²ரஊர்த்³வ்வம் ஆரோபயாஞ்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","தஸ்ய வாமத³க்ஷிணயோ ர்த்³வௌ சௌரௌ க்ருஸ²யோ ர்விவிதா⁴தே| ");
INSERT INTO santam_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","தேநைவ \"அபராதி⁴ஜநை​: ஸார்த்³த⁴ம்ʼ ஸ க³ணிதோ ப⁴விஷ்யதி,\" இதி ஸா²ஸ்த்ரோக்தம்ʼ வசநம்ʼ ஸித்³த⁴மபூ⁴த| ");
INSERT INTO santam_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","அநந்தரம்ʼ மார்கே³ யே யே லோகா க³மநாக³மநே சக்ருஸ்தே ஸர்வ்வ ஏவ ஸி²ராம்ʼஸ்யாந்தோ³ல்ய நிந்த³ந்தோ ஜக³து³​:, ரே மந்தி³ரநாஸ²க ரே தி³நத்ரயமத்⁴யே தந்நிர்ம்மாயக, ");
INSERT INTO santam_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","அது⁴நாத்மாநம் அவித்வா க்ருஸா²த³வரோஹ| ");
INSERT INTO santam_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","கிஞ்ச ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச தத்³வத் திரஸ்க்ருʼத்ய பரஸ்பரம்ʼ சசக்ஷிரே ஏஷ பராநாவத் கிந்து ஸ்வமவிதும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","யதீ³ஸ்ராயேலோ ராஜாபி⁴ஷிக்தஸ்த்ராதா ப⁴வதி தர்ஹ்யது⁴நைந க்ருஸா²த³வரோஹது வயம்ʼ தத்³ த்³ருʼஷ்ட்வா விஸ்²வஸிஷ்யாம​:; கிஞ்ச யௌ லோகௌ தேந ஸார்த்³த⁴ம்ʼ க்ருஸே² (அ)வித்⁴யேதாம்ʼ தாவபி தம்ʼ நிர்ப⁴ர்த்ஸயாமாஸது​:| ");
INSERT INTO santam_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","அத² த்³விதீயயாமாத் த்ருʼதீயயாமம்ʼ யாவத் ஸர்வ்வோ தே³ஸ²​: ஸாந்த⁴காரோபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ததஸ்த்ருʼதீயப்ரஹரே யீஸு²ருச்சைரவத³த் ஏலீ ஏலீ லாமா ஸி²வக்தநீ அர்தா²த்³ \"ஹே மதீ³ஸ² மதீ³ஸ² த்வம்ʼ பர்ய்யத்யாக்ஷீ​: குதோ ஹி மாம்ʼ?\" ");
INSERT INTO santam_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ததா³ ஸமீபஸ்த²லோகாநாம்ʼ கேசித் தத்³வாக்யம்ʼ நிஸ²ம்யாசக்²யு​: பஸ்²யைஷ ஏலியம் ஆஹூயதி| ");
INSERT INTO santam_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","தத ஏகோ ஜநோ தா⁴வித்வாக³த்ய ஸ்பஞ்ஜே (அ)ம்லரஸம்ʼ பூரயித்வா தம்ʼ நடா³க்³ரே நிதா⁴ய பாதும்ʼ தஸ்மை த³த்த்வாவத³த் திஷ்ட² ஏலிய ஏநமவரோஹயிதும் ஏதி ந வேதி பஸ்²யாமி| ");
INSERT INTO santam_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","அத² யீஸு²ருச்சை​: ஸமாஹூய ப்ராணாந் ஜஹௌ| ");
INSERT INTO santam_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ததா³ மந்தி³ரஸ்ய ஜவநிகோர்த்³வ்வாத³த⁴​:ர்ய்யந்தா விதீ³ர்ணா த்³விக²ண்டா³பூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","கிஞ்ச இத்த²முச்சைராஹூய ப்ராணாந் த்யஜந்தம்ʼ தம்ʼ த்³ருʼஷ்த்³வா தத்³ரக்ஷணாய நியுக்தோ ய​: ஸேநாபதிராஸீத் ஸோவத³த் நரோயம் ஈஸ்²வரபுத்ர இதி ஸத்யம்| ");
INSERT INTO santam_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ததா³நீம்ʼ மக்³த³லீநீ மரிஸம் கநிஷ்ட²யாகூபோ³ யோஸேஸ்²ச மாதாந்யமரியம் ஸா²லோமீ ச யா​: ஸ்த்ரியோ ");
INSERT INTO santam_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","கா³லீல்ப்ரதே³ஸே² யீஸு²ம்ʼ ஸேவித்வா தத³நுகா³மிந்யோ ஜாதா இமாஸ்தத³ந்யாஸ்²ச யா அநேகா நார்யோ யீஸு²நா ஸார்த்³த⁴ம்ʼ யிரூஸா²லமமாயாதாஸ்தாஸ்²ச தூ³ராத் தாநி த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","அதா²ஸாத³நதி³நஸ்யார்தா²த்³ விஸ்²ராமவாராத் பூர்வ்வதி³நஸ்ய ஸாயம்ʼகால ஆக³த ");
INSERT INTO santam_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ஈஸ்²வரராஜ்யாபேக்ஷ்யரிமதீ²யயூஷப²நாமா மாந்யமந்த்ரீ ஸமேத்ய பீலாதஸவித⁴ம்ʼ நிர்ப⁴யோ க³த்வா யீஸோ²ர்தே³ஹம்ʼ யயாசே| ");
INSERT INTO santam_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","கிந்து ஸ இதா³நீம்ʼ ம்ருʼத​: பீலாத இத்யஸம்ப⁴வம்ʼ மத்வா ஸ²தஸேநாபதிமாஹூய ஸ கதா³ ம்ருʼத இதி பப்ரச்ச²| ");
INSERT INTO santam_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ஸ²தஸேமநாபதிமுகா²த் தஜ்ஜ்ஞாத்வா யூஷபே² யீஸோ²ர்தே³ஹம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","பஸ்²சாத் ஸ ஸூக்ஷ்மம்ʼ வாஸ​: க்ரீத்வா யீஸோ²​: காயமவரோஹ்ய தேந வாஸஸா வேஷ்டாயித்வா கி³ரௌ கா²தஸ்²மஸா²நே ஸ்தா²பிதவாந் பாஷாணம்ʼ லோட²யித்வா த்³வாரி நித³தே⁴| ");
INSERT INTO santam_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","கிந்து யத்ர ஸோஸ்தா²ப்யத தத மக்³த³லீநீ மரியம் யோஸிமாத்ருʼமரியம் ச த³த்³ருʼஸ²த்ருʼ​:| ");
INSERT INTO santam_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","அத² விஸ்²ராமவாரே க³தே மக்³த³லீநீ மரியம் யாகூப³மாதா மரியம் ஸா²லோமீ சேமாஸ்தம்ʼ மர்த்³த³யிதும்ʼ ஸுக³ந்தி⁴த்³ரவ்யாணி க்ரீத்வா ");
INSERT INTO santam_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ஸப்தாஹப்ரத²மதி³நே(அ)திப்ரத்யூஷே ஸூர்ய்யோத³யகாலே ஸ்²மஸா²நமுபக³தா​:| ");
INSERT INTO santam_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","கிந்து ஸ்²மஸா²நத்³வாரபாஷாணோ(அ)திப்³ருʼஹந் தம்ʼ கோ(அ)பஸாரயிஷ்யதீதி தா​: பரஸ்பரம்ʼ க³த³ந்தி! ");
INSERT INTO santam_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ஏதர்ஹி நிரீக்ஷ்ய பாஷாணோ த்³வாரோ (அ)பஸாரித இதி த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","பஸ்²சாத்தா​: ஸ்²மஸா²நம்ʼ ப்ரவிஸ்²ய ஸு²க்லவர்ணதீ³ர்க⁴பரிச்ச²தா³வ்ருʼதமேகம்ʼ யுவாநம்ʼ ஸ்²மஸா²நத³க்ஷிணபார்ஸ்²வ உபவிஷ்டம்ʼ த்³ருʼஷ்ட்வா சமச்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ஸோ(அ)வத³த், மாபை⁴ஷ்ட யூயம்ʼ க்ருஸே² ஹதம்ʼ நாஸரதீயயீஸு²ம்ʼ க³வேஷயத² ஸோத்ர நாஸ்தி ஸ்²மஸா²நாது³த³ஸ்தா²த்; தை ர்யத்ர ஸ ஸ்தா²பித​: ஸ்தா²நம்ʼ ததி³த³ம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","கிந்து தேந யதோ²க்தம்ʼ ததா² யுஷ்மாகமக்³ரே கா³லீலம்ʼ யாஸ்யதே தத்ர ஸ யுஷ்மாந் ஸாக்ஷாத் கரிஷ்யதே யூயம்ʼ க³த்வா தஸ்ய ஸி²ஷ்யேப்⁴ய​: பிதராய ச வார்த்தாமிமாம்ʼ கத²யத| ");
INSERT INTO santam_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","தா​: கம்பிதா விஸ்திதாஸ்²ச தூர்ணம்ʼ ஸ்²மஸா²நாத்³ ப³ஹிர்க³த்வா பலாயந்த ப⁴யாத் கமபி கிமபி நாவத³ம்ʼஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","அபரம்ʼ யீஸு²​: ஸப்தாஹப்ரத²மதி³நே ப்ரத்யூஷே ஸ்²மஸா²நாது³த்தா²ய யஸ்யா​: ஸப்தபூ⁴தாஸ்த்யாஜிதாஸ்தஸ்யை மக்³த³லீநீமரியமே ப்ரத²மம்ʼ த³ர்ஸ²நம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","தத​: ஸா க³த்வா ஸோ²கரோத³நக்ருʼத்³ப்⁴யோ(அ)நுக³தலோகேப்⁴யஸ்தாம்ʼ வார்த்தாம்ʼ கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","கிந்து யீஸு²​: புநர்ஜீவந் தஸ்யை த³ர்ஸ²நம்ʼ த³த்தவாநிதி ஸ்²ருத்வா தே ந ப்ரத்யயந்| ");
INSERT INTO santam_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","பஸ்²சாத் தேஷாம்ʼ த்³வாயோ ர்க்³ராமயாநகாலே யீஸு²ரந்யவேஸ²ம்ʼ த்⁴ருʼத்வா தாப்⁴யாம்ʼ த³ர்ஸ²ந த³தௌ³! ");
INSERT INTO santam_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","தாவபி க³த்வாந்யஸி²ஷ்யேப்⁴யஸ்தாம்ʼ கதா²ம்ʼ கத²யாஞ்சக்ரது​: கிந்து தயோ​: கதா²மபி தே ந ப்ரத்யயந்| ");
INSERT INTO santam_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ஸே²ஷத ஏகாத³ஸ²ஸி²ஷ்யேஷு போ⁴ஜநோபவிஷ்டேஷு யீஸு²ஸ்தேப்⁴யோ த³ர்ஸ²நம்ʼ த³தௌ³ ததோ²த்தா²நாத் பரம்ʼ தத்³த³ர்ஸ²நப்ராப்தலோகாநாம்ʼ கதா²யாமவிஸ்²வாஸகரணாத் தேஷாமவிஸ்²வாஸமந​:காடி²ந்யாப்⁴யாம்ʼ ஹேதுப்⁴யாம்ʼ ஸ தாம்ʼஸ்தர்ஜிதவாந்| ");
INSERT INTO santam_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","அத² தாநாசக்²யௌ யூயம்ʼ ஸர்வ்வஜக³த்³ க³த்வா ஸர்வ்வஜநாந் ப்ரதி ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயத| ");
INSERT INTO santam_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","தத்ர ய​: கஸ்²சித்³ விஸ்²வஸ்ய மஜ்ஜிதோ ப⁴வேத் ஸ பரித்ராஸ்யதே கிந்து யோ ந விஸ்²வஸிஷ்யதி ஸ த³ண்ட³யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","கிஞ்ச யே ப்ரத்யேஷ்யந்தி தைரீத்³ருʼக்³ ஆஸ்²சர்ய்யம்ʼ கர்ம்ம ப்ரகாஸ²யிஷ்யதே தே மந்நாம்நா பூ⁴தாந் த்யாஜயிஷ்யந்தி பா⁴ஷா அந்யாஸ்²ச வதி³ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","அபரம்ʼ தை​: ஸர்பேஷு த்⁴ருʼதேஷு ப்ராணநாஸ²கவஸ்துநி பீதே ச தேஷாம்ʼ காபி க்ஷதி ர்ந ப⁴விஷ்யதி; ரோகி³ணாம்ʼ கா³த்ரேஷு கரார்பிதே தே(அ)ரோகா³ ப⁴விஷ்யந்தி ச| ");
INSERT INTO santam_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","அத² ப்ரபு⁴ஸ்தாநித்யாதி³ஸ்²ய ஸ்வர்க³ம்ʼ நீத​: ஸந் பரமேஸ்²வரஸ்ய த³க்ஷிண உபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ததஸ்தே ப்ரஸ்தா²ய ஸர்வ்வத்ர ஸுஸம்ʼவாதீ³யகதா²ம்ʼ ப்ரசாரயிதுமாரேபி⁴ரே ப்ரபு⁴ஸ்து தேஷாம்ʼ ஸஹாய​: ஸந் ப்ரகாஸி²தாஸ்²சர்ய்யக்ரியாபி⁴ஸ்தாம்ʼ கதா²ம்ʼ ப்ரமாணவதீம்ʼ சகார| இதி|");
INSERT INTO santam_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ப்ரத²மதோ யே ஸாக்ஷிணோ வாக்யப்ரசாரகாஸ்²சாஸந் தே(அ)ஸ்மாகம்ʼ மத்⁴யே யத்³யத் ஸப்ரமாணம்ʼ வாக்யமர்பயந்தி ஸ்ம ");
INSERT INTO santam_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","தத³நுஸாரதோ(அ)ந்யேபி ப³ஹவஸ்தத்³வ்ருʼத்தாந்தம்ʼ ரசயிதும்ʼ ப்ரவ்ருʼத்தா​:| ");
INSERT INTO santam_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","அதஏவ ஹே மஹாமஹிமதி²யபி²ல் த்வம்ʼ யா யா​: கதா² அஸி²க்ஷ்யதா²ஸ்தாஸாம்ʼ த்³ருʼட⁴ப்ரமாணாநி யதா² ப்ராப்நோஷி ");
INSERT INTO santam_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","தத³ர்த²ம்ʼ ப்ரத²மமாரப்⁴ய தாநி ஸர்வ்வாணி ஜ்ஞாத்வாஹமபி அநுக்ரமாத் ஸர்வ்வவ்ருʼத்தாந்தாந் துப்⁴யம்ʼ லேகி²தும்ʼ மதிமகார்ஷம்| ");
INSERT INTO santam_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","யிஹூதா³தே³ஸீ²யஹேரோத்³நாமகே ராஜத்வம்ʼ குர்வ்வதி அபீ³யயாஜகஸ்ய பர்ய்யாயாதி⁴காரீ ஸிக²ரியநாமக ஏகோ யாஜகோ ஹாரோணவம்ʼஸோ²த்³ப⁴வா இலீஸே²வாக்²யா ");
INSERT INTO santam_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","தஸ்ய ஜாயா த்³வாவிமௌ நிர்தோ³ஷௌ ப்ரபோ⁴​: ஸர்வ்வாஜ்ஞா வ்யவஸ்தா²ஸ்²ச ஸம்ʼமந்ய ஈஸ்²வரத்³ருʼஷ்டௌ தா⁴ர்ம்மிகாவாஸ்தாம்| ");
INSERT INTO santam_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","தயோ​: ஸந்தாந ஏகோபி நாஸீத், யத இலீஸே²வா ப³ந்த்⁴யா தௌ த்³வாவேவ வ்ருʼத்³தா⁴வப⁴வதாம்| ");
INSERT INTO santam_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","யதா³ ஸ்வபர்ய்யாநுக்ரமேண ஸிக²ரிய ஈஸ்²வாஸ்ய ஸமக்ஷம்ʼ யாஜகீயம்ʼ கர்ம்ம கரோதி ");
INSERT INTO santam_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ததா³ யஜ்ஞஸ்ய தி³நபரிபாய்யா பரமேஸ்²வரஸ்ய மந்தி³ரே ப்ரவேஸ²காலே தூ⁴பஜ்வாலநம்ʼ கர்ம்ம தஸ்ய கரணீயமாஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","தத்³தூ⁴பஜ்வாலநகாலே லோகநிவஹே ப்ரார்த²நாம்ʼ கர்தும்ʼ ப³ஹிஸ்திஷ்ட²தி ");
INSERT INTO santam_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ஸதி ஸிக²ரியோ யஸ்யாம்ʼ வேத்³யாம்ʼ தூ⁴பம்ʼ ஜ்வாலயதி தத்³த³க்ஷிணபார்ஸ்²வே பரமேஸ்²வரஸ்ய தூ³த ஏக உபஸ்தி²தோ த³ர்ஸ²நம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","தம்ʼ த்³ருʼஷ்ட்வா ஸிக²ரிய உத்³விவிஜே ஸ²ஸ²ங்கே ச| ");
INSERT INTO santam_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ததா³ ஸ தூ³தஸ்தம்ʼ ப³பா⁴ஷே ஹே ஸிக²ரிய மா பை⁴ஸ்தவ ப்ரார்த²நா க்³ராஹ்யா ஜாதா தவ பா⁴ர்ய்யா இலீஸே²வா புத்ரம்ʼ ப்ரஸோஷ்யதே தஸ்ய நாம யோेஹந் இதி கரிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","கிஞ்ச த்வம்ʼ ஸாநந்த³​: ஸஹர்ஷஸ்²ச ப⁴விஷ்யஸி தஸ்ய ஜந்மநி ப³ஹவ ஆநந்தி³ஷ்யந்தி ச| ");
INSERT INTO santam_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","யதோ ஹேதோ​: ஸ பரமேஸ்²வரஸ்ய கோ³சரே மஹாந் ப⁴விஷ்யதி ததா² த்³ராக்ஷாரஸம்ʼ ஸுராம்ʼ வா கிமபி ந பாஸ்யதி, அபரம்ʼ ஜந்மாரப்⁴ய பவித்ரேணாத்மநா பரிபூர்ண​: ");
INSERT INTO santam_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ஸந் இஸ்ராயேல்வம்ʼஸீ²யாந் அநேகாந் ப்ரபோ⁴​: பரமேஸ்²வரஸ்ய மார்க³மாநேஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ஸந்தாநாந் ப்ரதி பித்ருʼணாம்ʼ மநாம்ʼஸி த⁴ர்ம்மஜ்ஞாநம்ʼ ப்ரத்யநாஜ்ஞாக்³ராஹிணஸ்²ச பராவர்த்தயிதும்ʼ, ப்ரபோ⁴​: பரமேஸ்²வரஸ்ய ஸேவார்த²ம் ஏகாம்ʼ ஸஜ்ஜிதஜாதிம்ʼ விதா⁴துஞ்ச ஸ ஏலியரூபாத்மஸ²க்திப்ராப்தஸ்தஸ்யாக்³ரே க³மிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ததா³ ஸிக²ரியோ தூ³தமவாதீ³த் கத²மேதத்³ வேத்ஸ்யாமி? யதோஹம்ʼ வ்ருʼத்³தோ⁴ மம பா⁴ர்ய்யா ச வ்ருʼத்³தா⁴| ");
INSERT INTO santam_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ததோ தூ³த​: ப்ரத்யுவாச பஸ்²யேஸ்²வரஸ்ய ஸாக்ஷாத்³வர்த்தீ ஜிப்³ராயேல்நாமா தூ³தோஹம்ʼ த்வயா ஸஹ கதா²ம்ʼ க³தி³தும்ʼ துப்⁴யமிமாம்ʼ ஸு²ப⁴வார்த்தாம்ʼ தா³துஞ்ச ப்ரேஷித​:| ");
INSERT INTO santam_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","கிந்து மதீ³யம்ʼ வாக்யம்ʼ காலே ப²லிஷ்யதி தத் த்வயா ந ப்ரதீதம் அத​: காரணாத்³ யாவதே³வ தாநி ந ஸேத்ஸ்யந்தி தாவத் த்வம்ʼ வக்தும்ʼமஸ²க்தோ மூகோ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ததா³நீம்ʼ யே யே லோகா​: ஸிக²ரியமபைக்ஷந்த தே மத்⁴யேமந்தி³ரம்ʼ தஸ்ய ப³ஹுவிலம்பா³த்³ ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ஸ ப³ஹிராக³தோ யதா³ கிமபி வாக்யம்ʼ வக்துமஸ²க்த​: ஸங்கேதம்ʼ க்ருʼத்வா நி​:ஸ²ப்³த³ஸ்தஸ்யௌ ததா³ மத்⁴யேமந்தி³ரம்ʼ கஸ்யசித்³ த³ர்ஸ²நம்ʼ தேந ப்ராப்தம் இதி ஸர்வ்வே பு³பு³தி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","அநந்தரம்ʼ தஸ்ய ஸேவநபர்ய்யாயே ஸம்பூர்ணே ஸதி ஸ நிஜகே³ஹம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","கதிபயதி³நேஷு க³தேஷு தஸ்ய பா⁴ர்ய்யா இலீஸே²வா க³ர்ப்³ப⁴வதீ ப³பூ⁴வ ");
INSERT INTO santam_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","பஸ்²சாத் ஸா பஞ்சமாஸாந் ஸம்ʼகோ³ப்யாகத²யத் லோகாநாம்ʼ ஸமக்ஷம்ʼ மமாபமாநம்ʼ க²ண்ட³யிதும்ʼ பரமேஸ்²வரோ மயி த்³ருʼஷ்டிம்ʼ பாதயித்வா கர்ம்மேத்³ருʼஸ²ம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","அபரஞ்ச தஸ்யா க³ர்ப்³ப⁴ஸ்ய ஷஷ்டே² மாஸே ஜாதே கா³லீல்ப்ரதே³ஸீ²யநாஸரத்புரே ");
INSERT INTO santam_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","தா³யூதோ³ வம்ʼஸீ²யாய யூஷப்²நாம்நே புருஷாய யா மரியம்நாமகுமாரீ வாக்³த³த்தாஸீத் தஸ்யா​: ஸமீபம்ʼ ஜிப்³ராயேல் தூ³த ஈஸ்²வரேண ப்ரஹித​:| ");
INSERT INTO santam_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ஸ க³த்வா ஜகா³த³ ஹே ஈஸ்²வராநுக்³ருʼஹீதகந்யே தவ ஸு²ப⁴ம்ʼ பூ⁴யாத் ப்ரபு⁴​: பரமேஸ்²வரஸ்தவ ஸஹாயோஸ்தி நாரீணாம்ʼ மத்⁴யே த்வமேவ த⁴ந்யா| ");
INSERT INTO santam_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ததா³நீம்ʼ ஸா தம்ʼ த்³ருʼஷ்ட்வா தஸ்ய வாக்யத உத்³விஜ்ய கீத்³ருʼஸ²ம்ʼ பா⁴ஷணமித³ம் இதி மநஸா சிந்தயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ததோ தூ³தோ(அ)வத³த் ஹே மரியம் ப⁴யம்ʼ மாகார்ஷீ​:, த்வயி பரமேஸ்²வரஸ்யாநுக்³ரஹோஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","பஸ்²ய த்வம்ʼ க³ர்ப்³ப⁴ம்ʼ த்⁴ருʼத்வா புத்ரம்ʼ ப்ரஸோஷ்யஸே தஸ்ய நாம யீஸு²ரிதி கரிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ஸ மஹாந் ப⁴விஷ்யதி ததா² ஸர்வ்வேப்⁴ய​: ஸ்²ரேஷ்ட²ஸ்ய புத்ர இதி க்²யாஸ்யதி; அபரம்ʼ ப்ரபு⁴​: பரமேஸ்²வரஸ்தஸ்ய பிதுர்தா³யூத³​: ஸிம்ʼஹாஸநம்ʼ தஸ்மை தா³ஸ்யதி; ");
INSERT INTO santam_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ததா² ஸ யாகூபோ³ வம்ʼஸோ²பரி ஸர்வ்வதா³ ராஜத்வம்ʼ கரிஷ்யதி, தஸ்ய ராஜத்வஸ்யாந்தோ ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ததா³ மரியம் தம்ʼ தூ³தம்ʼ ப³பா⁴ஷே நாஹம்ʼ புருஷஸங்க³ம்ʼ கரோமி தர்ஹி கத²மேதத் ஸம்ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ததோ தூ³தோ(அ)கத²யத் பவித்ர ஆத்மா த்வாமாஸ்²ராயிஷ்யதி ததா² ஸர்வ்வஸ்²ரேஷ்ட²ஸ்ய ஸ²க்திஸ்தவோபரி சா²யாம்ʼ கரிஷ்யதி ததோ ஹேதோஸ்தவ க³ர்ப்³பா⁴த்³ ய​: பவித்ரபா³லகோ ஜநிஷ்யதே ஸ ஈஸ்²வரபுத்ர இதி க்²யாதிம்ʼ ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","அபரஞ்ச பஸ்²ய தவ ஜ்ஞாதிரிலீஸே²வா யாம்ʼ ஸர்வ்வே ப³ந்த்⁴யாமவத³ந் இதா³நீம்ʼ ஸா வார்த்³த⁴க்யே ஸந்தாநமேகம்ʼ க³ர்ப்³பே⁴(அ)தா⁴ரயத் தஸ்ய ஷஷ்ட²மாஸோபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","கிமபி கர்ம்ம நாஸாத்⁴யம் ஈஸ்²வரஸ்ய| ");
INSERT INTO santam_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ததா³ மரியம் ஜகா³த³, பஸ்²ய ப்ரபே⁴ரஹம்ʼ தா³ஸீ மஹ்யம்ʼ தவ வாக்யாநுஸாரேண ஸர்வ்வமேதத்³ க⁴டதாம்; அநநதரம்ʼ தூ³தஸ்தஸ்யா​: ஸமீபாத் ப்ரதஸ்தே²| ");
INSERT INTO santam_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","அத² கதிபயதி³நாத் பரம்ʼ மரியம் தஸ்மாத் பர்வ்வதமயப்ரதே³ஸீ²யயிஹூதா³யா நக³ரமேகம்ʼ ஸீ²க்⁴ரம்ʼ க³த்வா ");
INSERT INTO santam_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ஸிக²ரியயாஜகஸ்ய க்³ருʼஹம்ʼ ப்ரவிஸ்²ய தஸ்ய ஜாயாம் இலீஸே²வாம்ʼ ஸம்போ³த்⁴யாவத³த்| ");
INSERT INTO santam_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ததோ மரியம​: ஸம்போ³த⁴நவாக்யே இலீஸே²வாயா​: கர்ணயோ​: ப்ரவிஷ்டமாத்ரே ஸதி தஸ்யா க³ர்ப்³ப⁴ஸ்த²பா³லகோ நநர்த்த| தத இலீஸே²வா பவித்ரேணாத்மநா பரிபூர்ணா ஸதீ ");
INSERT INTO santam_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ப்ரோச்சைர்க³தி³துமாரேபே⁴, யோஷிதாம்ʼ மத்⁴யே த்வமேவ த⁴ந்யா, தவ க³ர்ப்³ப⁴ஸ்த²​: ஸி²ஸு²ஸ்²ச த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","த்வம்ʼ ப்ரபோ⁴ர்மாதா, மம நிவேஸ²நே த்வயா சரணாவர்பிதௌ, மமாத்³ய ஸௌபா⁴க்³யமேதத்| ");
INSERT INTO santam_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","பஸ்²ய தவ வாக்யே மம கர்ணயோ​: ப்ரவிஷ்டமாத்ரே ஸதி மமோத³ரஸ்த²​: ஸி²ஸு²ராநந்தா³ந் நநர்த்த| ");
INSERT INTO santam_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","யா ஸ்த்ரீ வ்யஸ்²வஸீத் ஸா த⁴ந்யா, யதோ ஹேதோஸ்தாம்ʼ ப்ரதி பரமேஸ்²வரோக்தம்ʼ வாக்யம்ʼ ஸர்வ்வம்ʼ ஸித்³த⁴ம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ததா³நீம்ʼ மரியம் ஜகா³த³| த⁴ந்யவாத³ம்ʼ பரேஸ²ஸ்ய கரோதி மாமகம்ʼ மந​:| ");
INSERT INTO santam_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","மமாத்மா தாரகேஸே² ச ஸமுல்லாஸம்ʼ ப்ரக³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","அகரோத் ஸ ப்ரபு⁴ ர்து³ஷ்டிம்ʼ ஸ்வதா³ஸ்யா து³ர்க³திம்ʼ ப்ரதி| பஸ்²யாத்³யாரப்⁴ய மாம்ʼ த⁴ந்யாம்ʼ வக்ஷ்யந்தி புருஷா​: ஸதா³| ");
INSERT INTO santam_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ய​: ஸர்வ்வஸ²க்திமாந் யஸ்ய நாமாபி ச பவித்ரகம்ʼ| ஸ ஏவ ஸுமஹத்கர்ம்ம க்ருʼதவாந் மந்நிமித்தகம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","யே பி³ப்⁴யதி ஜநாஸ்தஸ்மாத் தேஷாம்ʼ ஸந்தாநபம்ʼக்திஷு| அநுகம்பா ததீ³யா ச ஸர்வ்வதை³வ ஸுதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ஸ்வபா³ஹுப³லதஸ்தேந ப்ராகாஸ்²யத பராக்ரம​:| மந​:குமந்த்ரணாஸார்த்³த⁴ம்ʼ விகீர்ய்யந்தே(அ)பி⁴மாநிந​:| ");
INSERT INTO santam_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ஸிம்ʼஹாஸநக³தால்லோகாந் ப³லிநஸ்²சாவரோஹ்ய ஸ​:| பதே³ஷூச்சேஷு லோகாம்ʼஸ்து க்ஷுத்³ராந் ஸம்ʼஸ்தா²பயத்யபி| ");
INSERT INTO santam_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","க்ஷுதி⁴தாந் மாநவாந் த்³ரவ்யைருத்தமை​: பரிதர்ப்ய ஸ​:| ஸகலாந் த⁴நிநோ லோகாந் விஸ்ருʼஜேத்³ ரிக்தஹஸ்தகாந்| ");
INSERT INTO santam_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","இப்³ராஹீமி ச தத்³வம்ʼஸே² யா த³யாஸ்தி ஸதை³வ தாம்ʼ| ஸ்ம்ருʼத்வா புரா பித்ருʼணாம்ʼ நோ யதா² ஸாக்ஷாத் ப்ரதிஸ்²ருதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","இஸ்ராயேல்ஸேவகஸ்தேந ததோ²பக்ரியதே ஸ்வயம்ʼ|| ");
INSERT INTO santam_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","அநந்தரம்ʼ மரியம் ப்ராயேண மாஸத்ரயம் இலீஸே²வயா ஸஹோஷித்வா வ்யாகு⁴ய்ய நிஜநிவேஸ²நம்ʼ யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","தத³நந்தரம் இலீஸே²வாயா​: ப்ரஸவகால உபஸ்தி²தே ஸதி ஸா புத்ரம்ʼ ப்ராஸோஷ்ட| ");
INSERT INTO santam_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","தத​: பரமேஸ்²வரஸ்தஸ்யாம்ʼ மஹாநுக்³ரஹம்ʼ க்ருʼதவாந் ஏதத் ஸ்²ருத்வா ஸமீபவாஸிந​: குடும்பா³ஸ்²சாக³த்ய தயா ஸஹ முமுதி³ரே| ");
INSERT INTO santam_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ததா²ஷ்டமே தி³நே தே பா³லகஸ்ய த்வசம்ʼ சே²த்தும் ஏத்ய தஸ்ய பித்ருʼநாமாநுரூபம்ʼ தந்நாம ஸிக²ரிய இதி கர்த்துமீஷு​:| ");
INSERT INTO santam_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","கிந்து தஸ்ய மாதாகத²யத் தந்ந, நாமாஸ்ய யோஹந் இதி கர்த்தவ்யம்| ");
INSERT INTO santam_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ததா³ தே வ்யாஹரந் தவ வம்ʼஸ²மத்⁴யே நாமேத்³ருʼஸ²ம்ʼ கஸ்யாபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","தத​: பரம்ʼ தஸ்ய பிதரம்ʼ ஸிக²ரியம்ʼ ப்ரதி ஸங்கேத்ய பப்ரச்சு²​: ஸி²ஸோ²​: கிம்ʼ நாம காரிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","தத​: ஸ ப²லகமேகம்ʼ யாசித்வா லிலேக² தஸ்ய நாம யோஹந் ப⁴விஷ்யதி| தஸ்மாத் ஸர்வ்வே ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","தத்க்ஷணம்ʼ ஸிக²ரியஸ்ய ஜிஹ்வாஜாட்³யே(அ)பக³தே ஸ முக²ம்ʼ வ்யாதா³ய ஸ்பஷ்டவர்ணமுச்சார்ய்ய ஈஸ்²வரஸ்ய கு³ணாநுவாத³ம்ʼ சகார| ");
INSERT INTO santam_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","தஸ்மாச்சதுர்தி³க்ஸ்தா²​: ஸமீபவாஸிலோகா பீ⁴தா ஏவமேதா​: ஸர்வ்வா​: கதா² யிஹூதா³யா​: பர்வ்வதமயப்ரதே³ஸ²ஸ்ய ஸர்வ்வத்ர ப்ரசாரிதா​:| ");
INSERT INTO santam_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","தஸ்மாத் ஸ்²ரோதாரோ மந​:ஸு ஸ்தா²பயித்வா கத²யாம்ப³பூ⁴வு​: கீத்³ருʼஸோ²யம்ʼ பா³லோ ப⁴விஷ்யதி? அத² பரமேஸ்²வரஸ்தஸ்ய ஸஹாயோபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ததா³ யோஹந​: பிதா ஸிக²ரிய​: பவித்ரேணாத்மநா பரிபூர்ண​: ஸந் ஏதாத்³ருʼஸ²ம்ʼ ப⁴விஷ்யத்³வாக்யம்ʼ கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","இஸ்ராயேல​: ப்ரபு⁴ ர்யஸ்து ஸ த⁴ந்ய​: பரமேஸ்²வர​:| அநுக்³ருʼஹ்ய நிஜால்லோகாந் ஸ ஏவ பரிமோசயேத்| ");
INSERT INTO santam_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","விபக்ஷஜநஹஸ்தேப்⁴யோ யதா² மோச்யாமஹே வயம்ʼ| யாவஜ்ஜீவஞ்ச த⁴ர்ம்மேண ஸாரல்யேந ச நிர்ப⁴யா​:| ");
INSERT INTO santam_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ஸேவாமஹை தமேவைகம் ஏதத்காரணமேவ ச| ஸ்வகீயம்ʼ ஸுபவித்ரஞ்ச ஸம்ʼஸ்ம்ருʼத்ய நியமம்ʼ ஸதா³| ");
INSERT INTO santam_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","க்ருʼபயா புருஷாந் பூர்வ்வாந் நிகஷார்தா²த்து ந​: பிது​:| இப்³ராஹீம​: ஸமீபே யம்ʼ ஸ²பத²ம்ʼ க்ருʼதவாந் புரா| ");
INSERT INTO santam_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","தமேவ ஸப²லம்ʼ கர்த்தம்ʼ ததா² ஸ²த்ருக³ணஸ்ய ச| ருʼृதீயாகாரிணஸ்²சைவ கரேப்⁴யோ ரக்ஷணாய ந​:| ");
INSERT INTO santam_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ஸ்ருʼஷ்டே​: ப்ரத²மத​: ஸ்வீயை​: பவித்ரை ர்பா⁴விவாதி³பி⁴​:| ");
INSERT INTO santam_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","யதோ²க்தவாந் ததா² ஸ்வஸ்ய தா³யூத³​: ஸேவகஸ்ய து| ");
INSERT INTO santam_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","வம்ʼஸே² த்ராதாரமேகம்ʼ ஸ ஸமுத்பாதி³தவாந் ஸ்வயம்| ");
INSERT INTO santam_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","அதோ ஹே பா³லக த்வந்து ஸர்வ்வேப்⁴ய​: ஸ்²ரேஷ்ட² ஏவ ய​:| தஸ்யைவ பா⁴விவாதீ³தி ப்ரவிக்²யாதோ ப⁴விஷ்யஸி| அஸ்மாகம்ʼ சரணாந் க்ஷேமே மார்கே³ சாலயிதும்ʼ ஸதா³| ஏவம்ʼ த்⁴வாந்தே(அ)ர்த²தோ ம்ருʼத்யோஸ்²சா²யாயாம்ʼ யே து மாநவா​:| ");
INSERT INTO santam_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","உபவிஷ்டாஸ்து தாநேவ ப்ரகாஸ²யிதுமேவ ஹி| க்ருʼத்வா மஹாநுகம்பாம்ʼ ஹி யாமேவ பரமேஸ்²வர​:| ");
INSERT INTO santam_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ஊர்த்³வ்வாத் ஸூர்ய்யமுதா³ய்யைவாஸ்மப்⁴யம்ʼ ப்ராதா³த்து த³ர்ஸ²நம்ʼ| தயாநுகம்பயா ஸ்வஸ்ய லோகாநாம்ʼ பாபமோசநே| ");
INSERT INTO santam_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","பரித்ராணஸ்ய தேப்⁴யோ ஹி ஜ்ஞாநவிஸ்²ராணநாய ச| ப்ரபோ⁴ ர்மார்க³ம்ʼ பரிஷ்கர்த்தும்ʼ தஸ்யாக்³ராயீ ப⁴விஷ்யஸி|| ");
INSERT INTO santam_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","அத² பா³லக​: ஸ²ரீரேண பு³த்³த்⁴யா ச வர்த்³தி⁴துமாரேபே⁴; அபரஞ்ச ஸ இஸ்ராயேலோ வம்ʼஸீ²யலோகாநாம்ʼ ஸமீபே யாவந்ந ப்ரகடீபூ⁴தஸ்தாஸ்தாவத் ப்ராந்தரே ந்யவஸத்| ");
INSERT INTO santam_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","அபரஞ்ச தஸ்மிந் காலே ராஜ்யஸ்ய ஸர்வ்வேஷாம்ʼ லோகாநாம்ʼ நாமாநி லேக²யிதும் அக³ஸ்தகைஸர ஆஜ்ஞாபயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","தத³நுஸாரேண குரீணியநாமநி ஸுரியாதே³ஸ²ஸ்ய ஸா²ஸகே ஸதி நாமலேக²நம்ʼ ப்ராரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","அதோ ஹேதோ ர்நாம லேகி²தும்ʼ ஸர்வ்வே ஜநா​: ஸ்வீயம்ʼ ஸ்வீயம்ʼ நக³ரம்ʼ ஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ததா³நீம்ʼ யூஷப்² நாம லேகி²தும்ʼ வாக்³த³த்தயா ஸ்வபா⁴ர்ய்யயா க³ர்ப்³ப⁴வத்யா மரியமா ஸஹ ஸ்வயம்ʼ தா³யூத³​: ஸஜாதிவம்ʼஸ² இதி காரணாத்³ கா³லீல்ப்ரதே³ஸ²ஸ்ய நாஸரத்நக³ராத்³ ");
INSERT INTO santam_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","யிஹூதா³ப்ரதே³ஸ²ஸ்ய பை³த்லேஹமாக்²யம்ʼ தா³யூத்³நக³ரம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","அந்யச்ச தத்ர ஸ்தா²நே தயோஸ்திஷ்ட²தோ​: ஸதோ ர்மரியம​: ப்ரஸூதிகால உபஸ்தி²தே ");
INSERT INTO santam_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ஸா தம்ʼ ப்ரத²மஸுதம்ʼ ப்ராஸோஷ்ட கிந்து தஸ்மிந் வாஸக்³ருʼஹே ஸ்தா²நாபா⁴வாத்³ பா³லகம்ʼ வஸ்த்ரேண வேஷ்டயித்வா கோ³ஸா²லாயாம்ʼ ஸ்தா²பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","அநந்தரம்ʼ யே கியந்தோ மேஷபாலகா​: ஸ்வமேஷவ்ரஜரக்ஷாயை தத்ப்ரதே³ஸே² ஸ்தி²த்வா ரஜந்யாம்ʼ ப்ராந்தரே ப்ரஹரிண​: கர்ம்ம குர்வ்வந்தி, ");
INSERT INTO santam_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","தேஷாம்ʼ ஸமீபம்ʼ பரமேஸ்²வரஸ்ய தூ³த ஆக³த்யோபதஸ்தௌ²; ததா³ சதுஷ்பார்ஸ்²வே பரமேஸ்²வரஸ்ய தேஜஸ​: ப்ரகாஸி²தத்வாத் தே(அ)திஸ²ஸ²ங்கிரே| ");
INSERT INTO santam_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ததா³ ஸ தூ³த உவாச மா பை⁴ஷ்ட பஸ்²யதாத்³ய தா³யூத³​: புரே யுஷ்மந்நிமித்தம்ʼ த்ராதா ப்ரபு⁴​: க்²ரீஷ்டோ(அ)ஜநிஷ்ட, ");
INSERT INTO santam_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ஸர்வ்வேஷாம்ʼ லோகாநாம்ʼ மஹாநந்த³ஜநகம் இமம்ʼ மங்க³லவ்ருʼத்தாந்தம்ʼ யுஷ்மாந் ஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","யூயம்ʼ (தத்ஸ்தா²நம்ʼ க³த்வா) வஸ்த்ரவேஷ்டிதம்ʼ தம்ʼ பா³லகம்ʼ கோ³ஸா²லாயாம்ʼ ஸ²யநம்ʼ த்³ரக்ஷ்யத² யுஷ்மாந் ப்ரதீத³ம்ʼ சிஹ்நம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","தூ³த இமாம்ʼ கதா²ம்ʼ கதி²தவதி தத்ராகஸ்மாத் ஸ்வர்கீ³யா​: ப்ருʼதநா ஆக³த்ய கதா²ம் இமாம்ʼ கத²யித்வேஸ்²வரஸ்ய கு³ணாநந்வவாதி³ஷு​:, யதா², ");
INSERT INTO santam_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ஸர்வ்வோர்த்³வ்வஸ்தை²ரீஸ்²வரஸ்ய மஹிமா ஸம்ப்ரகாஸ்²யதாம்ʼ| ஸா²ந்திர்பூ⁴யாத் ப்ருʼதி²வ்யாஸ்து ஸந்தோஷஸ்²ச நராந் ப்ரதி|| ");
INSERT INTO santam_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","தத​: பரம்ʼ தேஷாம்ʼ ஸந்நிதே⁴ ர்தூ³தக³ணே ஸ்வர்க³ம்ʼ க³தே மேஷபாலகா​: பரஸ்பரம் அவேசந் ஆக³ச்ச²த ப்ரபு⁴​: பரமேஸ்²வரோ யாம்ʼ க⁴டநாம்ʼ ஜ்ஞாபிதவாந் தஸ்யா யாத²ர்யம்ʼ ஜ்ஞாதும்ʼ வயமது⁴நா பை³த்லேஹம்புரம்ʼ யாம​:| ");
INSERT INTO santam_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","பஸ்²சாத் தே தூர்ணம்ʼ வ்ரஜித்வா மரியமம்ʼ யூஷப²ம்ʼ கோ³ஸா²லாயாம்ʼ ஸ²யநம்ʼ பா³லகஞ்ச த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","இத்த²ம்ʼ த்³ருʼஷ்ட்வா பா³லகஸ்யார்தே² ப்ரோக்தாம்ʼ ஸர்வ்வகதா²ம்ʼ தே ப்ராசாரயாஞ்சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ததோ யே லோகா மேஷரக்ஷகாணாம்ʼ வத³நேப்⁴யஸ்தாம்ʼ வார்த்தாம்ʼ ஸு²ஸ்²ருவுஸ்தே மஹாஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","கிந்து மரியம் ஏதத்ஸர்வ்வக⁴டநாநாம்ʼ தாத்பர்ய்யம்ʼ விவிச்ய மநஸி ஸ்தா²பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","தத்பஸ்²சாத்³ தூ³தவிஜ்ஞப்தாநுரூபம்ʼ ஸ்²ருத்வா த்³ருʼஷ்ட்வா ச மேஷபாலகா ஈஸ்²வரஸ்ய கு³ணாநுவாத³ம்ʼ த⁴ந்யவாத³ஞ்ச குர்வ்வாணா​: பராவ்ருʼத்ய யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","அத² பா³லகஸ்ய த்வக்சே²த³நகாலே(அ)ஷ்டமதி³வஸே ஸமுபஸ்தி²தே தஸ்ய க³ர்ப்³ப⁴ஸ்தி²தே​: புர்வ்வம்ʼ ஸ்வர்கீ³யதூ³தோ யதா²ஜ்ஞாபயத் தத³நுரூபம்ʼ தே தந்நாமதே⁴யம்ʼ யீஸு²ரிதி சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","தத​: பரம்ʼ மூஸாலிகி²தவ்யவஸ்தா²யா அநுஸாரேண மரியம​: ஸு²சித்வகால உபஸ்தி²தே, ");
INSERT INTO santam_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ப்ரத²மஜ​: ஸர்வ்வ​: புருஷஸந்தாந​: பரமேஸ்²வரே ஸமர்ப்யதாம்ʼ,\" இதி பரமேஸ்²வரஸ்ய வ்யவஸ்த²யா ");
INSERT INTO santam_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","யீஸு²ம்ʼ பரமேஸ்²வரே ஸமர்பயிதும் ஸா²ஸ்த்ரீயவித்⁴யுக்தம்ʼ கபோதத்³வயம்ʼ பாராவதஸா²வகத்³வயம்ʼ வா ப³லிம்ʼ தா³தும்ʼ தே தம்ʼ க்³ருʼஹீத்வா யிரூஸா²லமம் ஆயயு​:| ");
INSERT INTO santam_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","யிரூஸா²லம்புரநிவாஸீ ஸி²மியோந்நாமா தா⁴ர்ம்மிக ஏக ஆஸீத் ஸ இஸ்ராயேல​: ஸாந்த்வநாமபேக்ஷ்ய தஸ்தௌ² கிஞ்ச பவித்ர ஆத்மா தஸ்மிந்நாவிர்பூ⁴த​:| ");
INSERT INTO santam_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","அபரம்ʼ ப்ரபு⁴ணா பரமேஸ்²வரேணாபி⁴ஷிக்தே த்ராதரி த்வயா ந த்³ருʼஷ்டே த்வம்ʼ ந மரிஷ்யஸீதி வாக்யம்ʼ பவித்ரேண ஆத்மநா தஸ்ம ப்ராகத்²யத| ");
INSERT INTO santam_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","அபரஞ்ச யதா³ யீஸோ²​: பிதா மாதா ச தத³ர்த²ம்ʼ வ்யவஸ்தா²நுரூபம்ʼ கர்ம்ம கர்த்தும்ʼ தம்ʼ மந்தி³ரம் ஆநிந்யதுஸ்ததா³ ");
INSERT INTO santam_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ஸி²மியோந் ஆத்மந ஆகர்ஷணேந மந்தி³ரமாக³த்ய தம்ʼ க்ரோடே³ நிதா⁴ய ஈஸ்²வரஸ்ய த⁴ந்யவாத³ம்ʼ க்ருʼத்வா கத²யாமாஸ, யதா², ");
INSERT INTO santam_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ஹே ப்ரபோ⁴ தவ தா³ஸோயம்ʼ நிஜவாக்யாநுஸாரத​:| இதா³நீந்து ஸகல்யாணோ ப⁴வதா ஸம்ʼவிஸ்ருʼஜ்யதாம்| ");
INSERT INTO santam_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","யத​: ஸகலதே³ஸ²ஸ்ய தீ³ப்தயே தீ³ப்திரூபகம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","இஸ்ராயேலீயலோகஸ்ய மஹாகௌ³ரவரூபகம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","யம்ʼ த்ராயகம்ʼ ஜநாநாந்து ஸம்முகே² த்வமஜீஜந​:| ஸஏவ வித்³யதே(அ)ஸ்மாகம்ʼ த்⁴ரவம்ʼ நயநநகோ³சரே|| ");
INSERT INTO santam_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ததா³நீம்ʼ தேநோக்தா ஏதா​: ஸகலா​: கதா²​: ஸ்²ருத்வா தஸ்ய மாதா யூஷப்² ச விஸ்மயம்ʼ மேநாதே| ");
INSERT INTO santam_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","தத​: பரம்ʼ ஸி²மியோந் தேப்⁴ய ஆஸி²ஷம்ʼ த³த்த்வா தந்மாதரம்ʼ மரியமம் உவாச, பஸ்²ய இஸ்ராயேலோ வம்ʼஸ²மத்⁴யே ப³ஹூநாம்ʼ பாதநாயோத்தா²பநாய ச ததா² விரோத⁴பாத்ரம்ʼ ப⁴விதும்ʼ, ப³ஹூநாம்ʼ கு³ப்தமநோக³தாநாம்ʼ ப்ரகடீகரணாய பா³லகோயம்ʼ நியுக்தோஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","தஸ்மாத் தவாபி ப்ராணா​: ஸூ²லேந வ்யத்ஸ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","அபரஞ்ச ஆஸே²ரஸ்ய வம்ʼஸீ²யபி²நூயேலோ து³ஹிதா ஹந்நாக்²யா அதிஜரதீ ப⁴விஷ்யத்³வாதி³ந்யேகா யா விவாஹாத் பரம்ʼ ஸப்த வத்ஸராந் பத்யா ஸஹ ந்யவஸத் ததோ வித⁴வா பூ⁴த்வா சதுரஸீ²திவர்ஷவய​:பர்ய்யநதம்ʼ ");
INSERT INTO santam_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","மந்தி³ரே ஸ்தி²த்வா ப்ரார்த²நோபவாஸைர்தி³வாநிஸ²ம் ஈஸ்²வரம் அஸேவத ஸாபி ஸ்த்ரீ தஸ்மிந் ஸமயே மந்தி³ரமாக³த்ய ");
INSERT INTO santam_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","பரமேஸ்²வரஸ்ய த⁴ந்யவாத³ம்ʼ சகார, யிரூஸா²லம்புரவாஸிநோ யாவந்தோ லோகா முக்திமபேக்ஷ்ய ஸ்தி²தாஸ்தாந் யீஸோ²ர்வ்ருʼத்தாந்தம்ʼ ஜ்ஞாபயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","இத்த²ம்ʼ பரமேஸ்²வரஸ்ய வ்யவஸ்தா²நுஸாரேண ஸர்வ்வேஷு கர்ம்மஸு க்ருʼதேஷு தௌ புநஸ்²ச கா³லீலோ நாஸரத்நாமகம்ʼ நிஜநக³ரம்ʼ ப்ரதஸ்தா²தே| ");
INSERT INTO santam_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","தத்பஸ்²சாத்³ பா³லக​: ஸ²ரீரேண வ்ருʼத்³தி⁴மேத்ய ஜ்ஞாநேந பரிபூர்ண ஆத்மநா ஸ²க்திமாம்ʼஸ்²ச ப⁴விதுமாரேபே⁴ ததா² தஸ்மிந் ஈஸ்²வராநுக்³ரஹோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","தஸ்ய பிதா மாதா ச ப்ரதிவர்ஷம்ʼ நிஸ்தாரோத்ஸவஸமயே யிரூஸா²லமம் அக³ச்ச²தாம்| ");
INSERT INTO santam_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","அபரஞ்ச யீஸௌ² த்³வாத³ஸ²வர்ஷவயஸ்கே ஸதி தௌ பர்வ்வஸமயஸ்ய ரீத்யநுஸாரேண யிரூஸா²லமம்ʼ க³த்வா ");
INSERT INTO santam_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","பார்வ்வணம்ʼ ஸம்பாத்³ய புநரபி வ்யாகு⁴ய்ய யாத​: கிந்து யீஸு²ர்பா³லகோ யிரூஸா²லமி திஷ்ட²தி| யூஷப்² தந்மாதா ச தத்³ அவிதி³த்வா ");
INSERT INTO santam_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ஸ ஸங்கி³பி⁴​: ஸஹ வித்³யத ஏதச்ச பு³த்³வ்வா தி³நைகக³ம்யமார்க³ம்ʼ ஜக்³மது​:| கிந்து ஸே²ஷே ஜ்ஞாதிப³ந்தூ⁴நாம்ʼ ஸமீபே ம்ருʼக³யித்வா தது³த்³தே³ेஸ²மப்ராப்ய ");
INSERT INTO santam_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","தௌ புநரபி யிரூஸா²லமம் பராவ்ருʼத்யாக³த்ய தம்ʼ ம்ருʼக³யாஞ்சக்ரது​:| ");
INSERT INTO santam_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","அத² தி³நத்ரயாத் பரம்ʼ பண்டி³தாநாம்ʼ மத்⁴யே தேஷாம்ʼ கதா²​: ஸ்²ருʼண்வந் தத்த்வம்ʼ ப்ருʼச்ச²ம்ʼஸ்²ச மந்தி³ரே ஸமுபவிஷ்ட​: ஸ தாப்⁴யாம்ʼ த்³ருʼஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ததா³ தஸ்ய பு³த்³த்⁴யா ப்ரத்யுத்தரைஸ்²ச ஸர்வ்வே ஸ்²ரோதாரோ விஸ்மயமாபத்³யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","தாத்³ருʼஸ²ம்ʼ த்³ருʼஷ்ட்வா தஸ்ய ஜநகோ ஜநநீ ச சமச்சக்ரது​: கிஞ்ச தஸ்ய மாதா தமவத³த், ஹே புத்ர, கத²மாவாம்ʼ ப்ரதீத்த²ம்ʼ ஸமாசரஸ்த்வம்? பஸ்²ய தவ பிதாஹஞ்ச ஸோ²காகுலௌ ஸந்தௌ த்வாமந்விச்சா²வ​: ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","தத​: ஸோவத³த் குதோ மாம் அந்வைச்ச²தம்ʼ? பிதுர்க்³ருʼஹே மயா ஸ்தா²தவ்யம் ஏதத் கிம்ʼ யுவாப்⁴யாம்ʼ ந ஜ்ஞாயதே? ");
INSERT INTO santam_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","கிந்து தௌ தஸ்யைதத்³வாக்யஸ்ய தாத்பர்ய்யம்ʼ போ³த்³து⁴ம்ʼ நாஸ²க்நுதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","தத​: பரம்ʼ ஸ தாப்⁴யாம்ʼ ஸஹ நாஸரதம்ʼ க³த்வா தயோர்வஸீ²பூ⁴தஸ்தஸ்தௌ² கிந்து ஸர்வ்வா ஏதா​: கதா²ஸ்தஸ்ய மாதா மநஸி ஸ்தா²பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","அத² யீஸோ² ர்பு³த்³தி⁴​: ஸ²ரீரஞ்ச ததா² தஸ்மிந் ஈஸ்²வரஸ்ய மாநவாநாஞ்சாநுக்³ரஹோ வர்த்³தி⁴தும் ஆரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","அநந்தரம்ʼ திபி³ரியகைஸரஸ்ய ராஜத்வஸ்ய பஞ்சத³ஸே² வத்ஸரே ஸதி யதா³ பந்தீயபீலாதோ யிஹூதா³தே³ஸா²தி⁴பதி ர்ஹேரோத்³ து கா³லீல்ப்ரதே³ஸ²ஸ்ய ராஜா பி²லிபநாமா தஸ்ய ப்⁴ராதா து யிதூரியாயாஸ்த்ராகோ²நீதியாப்ரதே³ஸ²ஸ்ய ச ராஜாஸீத் லுஷாநீயநாமா அவிலீநீதே³ஸ²ஸ்ய ராஜாஸீத் ");
INSERT INTO santam_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ஹாநந் கியபா²ஸ்²சேமௌ ப்ரதா⁴நயாஜாகாவாஸ்தாம்ʼ ததா³நீம்ʼ ஸிக²ரியஸ்ய புத்ராய யோஹநே மத்⁴யேப்ராந்தரம் ஈஸ்²வரஸ்ய வாக்யே ப்ரகாஸி²தே ஸதி ");
INSERT INTO santam_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ஸ யர்த்³த³ந உப⁴யதடப்ரதே³ஸா²ந் ஸமேத்ய பாபமோசநார்த²ம்ʼ மந​:பராவர்த்தநஸ்ய சிஹ்நரூபம்ʼ யந்மஜ்ஜநம்ʼ ததீ³யா​: கதா²​: ஸர்வ்வத்ர ப்ரசாரயிதுமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","யிஸ²யியப⁴விஷ்யத்³வக்த்ருʼக்³ரந்தே² யாத்³ருʼஸீ² லிபிராஸ்தே யதா², பரமேஸ²ஸ்ய பந்தா²நம்ʼ பரிஷ்குருத ஸர்வ்வத​:| தஸ்ய ராஜபத²ஞ்சைவ ஸமாநம்ʼ குருதாது⁴நா| ");
INSERT INTO santam_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","காரிஷ்யந்தே ஸமுச்ச்²ராயா​: ஸகலா நிம்நபூ⁴மய​:| காரிஷ்யந்தே நதா​: ஸர்வ்வே பர்வ்வதாஸ்²சோபபர்வ்வதா​:| காரிஷ்யந்தே ச யா வக்ராஸ்தா​: ஸர்வ்வா​: ஸரலா பு⁴வ​:| காரிஷ்யந்தே ஸமாநாஸ்தா யா உச்சநீசபூ⁴மய​:| ");
INSERT INTO santam_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ஈஸ்²வரேண க்ருʼதம்ʼ த்ராணம்ʼ த்³ரக்ஷ்யந்தி ஸர்வ்வமாநவா​:| இத்யேதத் ப்ராந்தரே வாக்யம்ʼ வத³த​: கஸ்யசித்³ ரவ​:|| ");
INSERT INTO santam_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","யே யே லோகா மஜ்ஜநார்த²ம்ʼ ப³ஹிராயயுஸ்தாந் ஸோவத³த் ரே ரே ஸர்பவம்ʼஸா² ஆகா³மிந​: கோபாத் பலாயிதும்ʼ யுஷ்மாந் கஸ்²சேதயாமாஸ? ");
INSERT INTO santam_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","தஸ்மாத்³ இப்³ராஹீம் அஸ்மாகம்ʼ பிதா கதா²மீத்³ருʼஸீ²ம்ʼ மநோபி⁴ ர்ந கத²யித்வா யூயம்ʼ மந​:பரிவர்த்தநயோக்³யம்ʼ ப²லம்ʼ ப²லத; யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி பாஷாணேப்⁴ய ஏதேப்⁴ய ஈஸ்²வர இப்³ராஹீம​: ஸந்தாநோத்பாத³நே ஸமர்த²​:| ");
INSERT INTO santam_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","அபரஞ்ச தருமூலே(அ)து⁴நாபி பரஸு²​: ஸம்ʼலக்³நோஸ்தி யஸ்தருருத்தமம்ʼ ப²லம்ʼ ந ப²லதி ஸ சி²த்³யதே(அ)க்³நௌ நிக்ஷிப்யதே ச| ");
INSERT INTO santam_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ததா³நீம்ʼ லோகாஸ்தம்ʼ பப்ரச்சு²ஸ்தர்ஹி கிம்ʼ கர்த்தவ்யமஸ்மாபி⁴​:? ");
INSERT INTO santam_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","தத​: ஸோவாதீ³த் யஸ்ய த்³வே வஸநே வித்³யேதே ஸ வஸ்த்ரஹீநாயைகம்ʼ விதரது கிம்ʼஞ்ச யஸ்ய கா²த்³யத்³ரவ்யம்ʼ வித்³யதே ஸோபி ததை²வ கரோது| ");
INSERT INTO santam_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","தத​: பரம்ʼ கரஸஞ்சாயிநோ மஜ்ஜநார்த²ம் ஆக³த்ய பப்ரச்சு²​: ஹே கு³ரோ கிம்ʼ கர்த்தவ்யமஸ்மாபி⁴​:? ");
INSERT INTO santam_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","தத​: ஸோகத²யத் நிரூபிதாத³தி⁴கம்ʼ ந க்³ருʼஹ்லித| ");
INSERT INTO santam_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","அநந்தரம்ʼ ஸேநாக³ண ஏத்ய பப்ரச்ச² கிமஸ்மாபி⁴ ர்வா கர்த்தவ்யம்? தத​: ஸோபி⁴த³தே⁴ கஸ்ய காமபி ஹாநிம்ʼ மா கார்ஷ்ட ததா² ம்ருʼஷாபவாத³ம்ʼ மா குருத நிஜவேதநேந ச ஸந்துஷ்ய திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","அபரஞ்ச லோகா அபேக்ஷயா ஸ்தி²த்வா ஸர்வ்வேபீதி மநோபி⁴ ர்விதர்கயாஞ்சக்ரு​:, யோஹநயம் அபி⁴ஷிக்தஸ்த்ராதா ந வேதி? ");
INSERT INTO santam_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ததா³ யோஹந் ஸர்வ்வாந் வ்யாஜஹார, ஜலே(அ)ஹம்ʼ யுஷ்மாந் மஜ்ஜயாமி ஸத்யம்ʼ கிந்து யஸ்ய பாது³காப³ந்த⁴நம்ʼ மோசயிதுமபி ந யோக்³யோஸ்மி தாத்³ருʼஸ² ஏகோ மத்தோ கு³ருதர​: புமாந் ஏதி, ஸ யுஷ்மாந் வஹ்நிரூபே பவித்ர ஆத்மநி மஜ்ஜயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","அபரஞ்ச தஸ்ய ஹஸ்தே ஸூ²ர்ப ஆஸ்தே ஸ ஸ்வஸ²ஸ்யாநி ஸு²த்³த⁴ரூபம்ʼ ப்ரஸ்போ²ட்ய கோ³தூ⁴மாந் ஸர்வ்வாந் பா⁴ண்டா³கா³ரே ஸம்ʼக்³ரஹீஷ்யதி கிந்து பூ³ஷாணி ஸர்வ்வாண்யநிர்வ்வாணவஹ்நிநா தா³ஹயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","யோஹந் உபதே³ஸே²நேத்த²ம்ʼ நாநாகதா² லோகாநாம்ʼ ஸமக்ஷம்ʼ ப்ரசாரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","அபரஞ்ச ஹேரோத்³ ராஜா பி²லிப்நாம்ந​: ஸஹோத³ரஸ்ய பா⁴ர்ய்யாம்ʼ ஹேரோதி³யாமதி⁴ ததா²ந்யாநி யாநி யாநி குகர்ம்மாணி க்ருʼதவாந் தத³தி⁴ ச ");
INSERT INTO santam_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","யோஹநா திரஸ்க்ருʼதோ பூ⁴த்வா காராகா³ரே தஸ்ய ப³ந்த⁴நாத்³ அபரமபி குகர்ம்ம சகார| ");
INSERT INTO santam_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","இத​: பூர்வ்வம்ʼ யஸ்மிந் ஸமயே ஸர்வ்வே யோஹநா மஜ்ஜிதாஸ்ததா³நீம்ʼ யீஸு²ரப்யாக³த்ய மஜ்ஜித​:| ");
INSERT INTO santam_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","தத³நந்தரம்ʼ தேந ப்ரார்தி²தே மேக⁴த்³வாரம்ʼ முக்தம்ʼ தஸ்மாச்ச பவித்ர ஆத்மா மூர்த்திமாந் பூ⁴த்வா கபோதவத் தது³பர்ய்யவருரோஹ; ததா³ த்வம்ʼ மம ப்ரிய​: புத்ரஸ்த்வயி மம பரம​: ஸந்தோஷ இத்யாகாஸ²வாணீ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ததா³நீம்ʼ யீஸு²​: ப்ராயேண த்ரிம்ʼஸ²த்³வர்ஷவயஸ்க ஆஸீத்| லௌகிகஜ்ஞாநே து ஸ யூஷப²​: புத்ர​:, ");
INSERT INTO santam_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","யூஷப்² ஏலே​: புத்ர​:, ஏலிர்மத்தத​: புத்ர​:, மத்தத் லேவே​: புத்ர​:, லேவி ர்மல்கே​: புத்ர​:, மல்கிர்யாந்நஸ்ய புத்ர​:; யாந்நோ யூஷப²​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","யூஷப்² மத்ததி²யஸ்ய புத்ர​:, மத்ததி²ய ஆமோஸ​: புத்ர​:, ஆமோஸ் நஹூம​: புத்ர​:, நஹூம் இஷ்லே​: புத்ர​: இஷ்லிர்நகே³​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","நகி³ர்மாட​: புத்ர​:, மாட் மத்ததி²யஸ்ய புத்ர​:, மத்ததி²ய​: ஸி²மியே​: புத்ர​:, ஸி²மியிர்யூஷப²​: புத்ர​:, யூஷப்² யிஹூதா³​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","யிஹூதா³ யோஹாநா​: புத்ர​:, யோஹாநா ரீஷா​: புத்ர​:, ரீஷா​: ஸிருப்³பா³பி³ல​: புத்ர​:, ஸிருப்³பா³பி³ல் ஸ²ல்தீயேல​: புத்ர​:, ஸ²ல்தீயேல் நேரே​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","நேரிர்மல்கே​: புத்ர​:, மல்கி​: அத்³ய​: புத்ர​:, அத்³தீ³ கோஷம​: புத்ர​:, கோஷம் இல்மோத³த³​: புத்ர​:, இல்மோத³த்³ ஏர​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ஏர் யோஸே²​: புத்ர​:, யோஸி²​: இலீயேஷர​: புத்ர​:, இலீயேஷர் யோரீம​: புத்ர​:, யோரீம் மத்தத​: புத்ர​:, மத்தத லேவே​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","லேவி​: ஸி²மியோந​: புத்ர​:, ஸி²மியோந் யிஹூதா³​: புத்ர​:, யிஹூதா³ யூஷுப²​: புத்ர​:, யூஷுப்² யோநந​: புத்ர​:, யாநந் இலீயாகீம​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","இலியாகீம்​: மிலேயா​: புத்ர​:, மிலேயா மைநந​: புத்ர​:, மைநந் மத்தத்தஸ்ய புத்ர​:, மத்தத்தோ நாத²ந​: புத்ர​:, நாத²ந் தா³யூத³​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","தா³யூத்³ யிஸ²ய​: புத்ர​:, யிஸ²ய ஓபே³த³​: புத்ர, ஓபே³த்³ போ³யஸ​: புத்ர​:, போ³யஸ் ஸல்மோந​: புத்ர​:, ஸல்மோந் நஹஸோ²ந​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","நஹஸோ²ந் அம்மீநாத³ப³​: புத்ர​:, அம்மீநாத³ப்³ அராம​: புத்ர​:, அராம் ஹிஷ்ரோண​: புத்ர​:, ஹிஷ்ரோண் பேரஸ​: புத்ர​:, பேரஸ் யிஹூதா³​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","யிஹூதா³ யாகூப³​: புத்ர​:, யாகூப்³ இஸ்ஹாக​: புத்ர​:, இஸ்ஹாக் இப்³ராஹீம​: புத்ர​:, இப்³ராஹீம் தேரஹ​: புத்ர​:, தேரஹ் நாஹோர​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","நாஹோர் ஸிருக³​: புத்ர​:, ஸிருக்³ ரிய்வ​: புத்ர​:, ரியூ​: பேலக³​: புத்ர​:, பேலக்³ ஏவர​: புத்ர​:, ஏவர் ஸே²லஹ​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ஸே²லஹ் கைநந​: புத்ர​:, கைநந் அர்ப²க்ஷத³​: புத்ர​:, அர்ப²க்ஷத்³ ஸா²ம​: புத்ர​:, ஸா²ம் நோஹ​: புத்ர​:, நோஹோ லேமக​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","லேமக் மிதூ²ஸே²லஹ​: புத்ர​:, மிதூ²ஸே²லஹ் ஹநோக​: புத்ர​:, ஹநோக் யேரத³​: புத்ர​:, யேரத்³ மஹலலேல​: புத்ர​:, மஹலலேல் கைநந​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","கைநந் இநோஸ²​: புத்ர​:, இநோஸ்² ஸே²த​: புத்ர​:, ஸே²த் ஆத³ம​: புத்ர, ஆத³ம் ஈஸ்²வரஸ்ய புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","தத​: பரம்ʼ யீஸு²​: பவித்ரேணாத்மநா பூர்ண​: ஸந் யர்த்³த³நநத்³யா​: பராவ்ருʼத்யாத்மநா ப்ராந்தரம்ʼ நீத​: ஸந் சத்வாரிம்ʼஸ²த்³தி³நாநி யாவத் ஸை²தாநா பரீக்ஷிதோ(அ)பூ⁴த், ");
INSERT INTO santam_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","கிஞ்ச தாநி ஸர்வ்வதி³நாநி போ⁴ஜநம்ʼ விநா ஸ்தி²தத்வாத் காலே பூர்ணே ஸ க்ஷுதி⁴தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","தத​: ஸை²தாநாக³த்ய தமவத³த் த்வம்ʼ சேதீ³ஸ்²வரஸ்ய புத்ரஸ்தர்ஹி ப்ரஸ்தராநேதாந் ஆஜ்ஞயா பூபாந் குரு| ");
INSERT INTO santam_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ததா³ யீஸு²ருவாச, லிபிரீத்³ருʼஸீ² வித்³யதே மநுஜ​: கேவலேந பூபேந ந ஜீவதி கிந்த்வீஸ்²வரஸ்ய ஸர்வ்வாபி⁴ராஜ்ஞாபி⁴ ர்ஜீவதி| ");
INSERT INTO santam_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ததா³ ஸை²தாந் தமுச்சம்ʼ பர்வ்வதம்ʼ நீத்வா நிமிஷைகமத்⁴யே ஜக³த​: ஸர்வ்வராஜ்யாநி த³ர்ஸி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","பஸ்²சாத் தமவாதீ³த் ஸர்வ்வம் ஏதத்³ விப⁴வம்ʼ ப்ரதாபஞ்ச துப்⁴யம்ʼ தா³ஸ்யாமி தந் மயி ஸமர்பிதமாஸ்தே யம்ʼ ப்ரதி மமேச்சா² ஜாயதே தஸ்மை தா³தும்ʼ ஸ²க்நோமி, ");
INSERT INTO santam_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","த்வம்ʼ சேந்மாம்ʼ ப⁴ஜஸே தர்ஹி ஸர்வ்வமேதத் தவைவ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ததா³ யீஸு²ஸ்தம்ʼ ப்ரத்யுக்தவாந் தூ³ரீ ப⁴வ ஸை²தாந் லிபிராஸ்தே, நிஜம்ʼ ப்ரபு⁴ம்ʼ பரமேஸ்²வரம்ʼ ப⁴ஜஸ்வ கேவலம்ʼ தமேவ ஸேவஸ்வ ச| ");
INSERT INTO santam_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","அத² ஸை²தாந் தம்ʼ யிரூஸா²லமம்ʼ நீத்வா மந்தி³ரஸ்ய சூடா³யா உபரி ஸமுபவேஸ்²ய ஜகா³த³ த்வம்ʼ சேதீ³ஸ்²வரஸ்ய புத்ரஸ்தர்ஹி ஸ்தா²நாதி³தோ லம்பி²த்வாத⁴​: ");
INSERT INTO santam_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","பத யதோ லிபிராஸ்தே, ஆஜ்ஞாபயிஷ்யதி ஸ்வீயாந் தூ³தாந் ஸ பரமேஸ்²வர​:| ");
INSERT INTO santam_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ரக்ஷிதும்ʼ ஸர்வ்வமார்கே³ த்வாம்ʼ தேந த்வச்சரணே யதா²| ந லகே³த் ப்ரஸ்தராகா⁴தஸ்த்வாம்ʼ த⁴ரிஷ்யந்தி தே ததா²| ");
INSERT INTO santam_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ததா³ யீஸு²நா ப்ரத்யுக்தம் இத³மப்யுக்தமஸ்தி த்வம்ʼ ஸ்வப்ரபு⁴ம்ʼ பரேஸ²ம்ʼ மா பரீக்ஷஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","பஸ்²சாத் ஸை²தாந் ஸர்வ்வபரீக்ஷாம்ʼ ஸமாப்ய க்ஷணாத்தம்ʼ த்யக்த்வா யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ததா³ யீஸு²ராத்மப்ரபா⁴வாத் புநர்கா³லீல்ப்ரதே³ஸ²ம்ʼ க³தஸ்ததா³ தத்ஸுக்²யாதிஸ்²சதுர்தி³ஸ²ம்ʼ வ்யாநஸே²| ");
INSERT INTO santam_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ஸ தேஷாம்ʼ ப⁴ஜநக்³ருʼஹேஷு உபதி³ஸ்²ய ஸர்வ்வை​: ப்ரஸ²ம்ʼஸிதோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","அத² ஸ ஸ்வபாலநஸ்தா²நம்ʼ நாஸரத்புரமேத்ய விஸ்²ராமவாரே ஸ்வாசாராத்³ ப⁴ஜநகே³ஹம்ʼ ப்ரவிஸ்²ய படி²துமுத்தஸ்தௌ²| ");
INSERT INTO santam_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ததோ யிஸ²யியப⁴விஷ்யத்³வாதி³ந​: புஸ்தகே தஸ்ய கரத³த்தே ஸதி ஸ தத் புஸ்தகம்ʼ விஸ்தார்ய்ய யத்ர வக்ஷ்யமாணாநி வசநாநி ஸந்தி தத் ஸ்தா²நம்ʼ ப்ராப்ய பபாட²| ");
INSERT INTO santam_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ஆத்மா து பரமேஸ²ஸ்ய மதீ³யோபரி வித்³யதே| த³ரித்³ரேஷு ஸுஸம்ʼவாத³ம்ʼ வக்தும்ʼ மாம்ʼ ஸோபி⁴ஷிக்தவாந்| ப⁴க்³நாந்த​: கரணால்லோகாந் ஸுஸ்வஸ்தா²ந் கர்த்துமேவ ச| ப³ந்தீ³க்ருʼதேஷு லோகேஷு முக்தே ர்கோ⁴ஷயிதும்ʼ வச​:| நேத்ராணி தா³துமந்தே⁴ப்⁴யஸ்த்ராதும்ʼ ப³த்³த⁴ஜநாநபி| ");
INSERT INTO santam_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","பரேஸா²நுக்³ரஹே காலம்ʼ ப்ரசாரயிதுமேவ ச| ஸர்வ்வைதத்கரணார்தா²ய மாமேவ ப்ரஹிணோதி ஸ​:|| ");
INSERT INTO santam_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","தத​: புஸ்தகம்ʼ ப³த்³வ்வா பரிசாரகஸ்ய ஹஸ்தே ஸமர்ப்ய சாஸநே ஸமுபவிஷ்ட​:, ததோ ப⁴ஜநக்³ருʼஹே யாவந்தோ லோகா ஆஸந் தே ஸர்வ்வே(அ)நந்யத்³ருʼஷ்ட்யா தம்ʼ விலுலோகிரே| ");
INSERT INTO santam_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","அநந்தரம் அத்³யைதாநி ஸர்வ்வாணி லிகி²தவசநாநி யுஷ்மாகம்ʼ மத்⁴யே ஸித்³தா⁴நி ஸ இமாம்ʼ கதா²ம்ʼ தேப்⁴ய​: கத²யிதுமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","தத​: ஸர்வ்வே தஸ்மிந் அந்வரஜ்யந்த, கிஞ்ச தஸ்ய முகா²ந்நிர்க³தாபி⁴ரநுக்³ரஹஸ்ய கதா²பி⁴ஸ்²சமத்க்ருʼத்ய கத²யாமாஸு​: கிமயம்ʼ யூஷப²​: புத்ரோ ந? ");
INSERT INTO santam_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ததா³ ஸோ(அ)வாதீ³த்³ ஹே சிகித்ஸக ஸ்வமேவ ஸ்வஸ்த²ம்ʼ குரு கப²ர்நாஹூமி யத்³யத் க்ருʼதவாந் தத³ஸ்²ரௌஷ்ம தா​: ஸர்வா​: க்ரியா அத்ர ஸ்வதே³ஸே² குரு கதா²மேதாம்ʼ யூயமேவாவஸ்²யம்ʼ மாம்ʼ வதி³ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","புந​: ஸோவாதீ³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, கோபி ப⁴விஷ்யத்³வாதீ³ ஸ்வதே³ஸே² ஸத்காரம்ʼ ந ப்ராப்நோதி| ");
INSERT INTO santam_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","அபரஞ்ச யதா²ர்த²ம்ʼ வச்மி, ஏலியஸ்ய ஜீவநகாலே யதா³ ஸார்த்³த⁴த்ரிதயவர்ஷாணி யாவத் ஜலத³ப்ரதிப³ந்தா⁴த் ஸர்வ்வஸ்மிந் தே³ஸே² மஹாது³ர்பி⁴க்ஷம் அஜநிஷ்ட ததா³நீம் இஸ்ராயேலோ தே³ஸ²ஸ்ய மத்⁴யே ப³ஹ்வ்யோ வித⁴வா ஆஸந், ");
INSERT INTO santam_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","கிந்து ஸீதோ³ந்ப்ரதே³ஸீ²யஸாரிப²த்புரநிவாஸிநீம் ஏகாம்ʼ வித⁴வாம்ʼ விநா கஸ்யாஸ்²சித³பி ஸமீபே ஏலிய​: ப்ரேரிதோ நாபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","அபரஞ்ச இலீஸா²யப⁴விஷ்யத்³வாதி³வித்³யமாநதாகாலே இஸ்ராயேல்தே³ஸே² ப³ஹவ​: குஷ்டி²ந ஆஸந் கிந்து ஸுரீயதே³ஸீ²யம்ʼ நாமாந்குஷ்டி²நம்ʼ விநா கோப்யந்ய​: பரிஷ்க்ருʼதோ நாபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","இமாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா ப⁴ஜநகே³ஹஸ்தி²தா லோகா​: ஸக்ரோத⁴ம் உத்தா²ய ");
INSERT INTO santam_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","நக³ராத்தம்ʼ ப³ஹிஷ்க்ருʼத்ய யஸ்ய ஸி²க²ரிண உபரி தேஷாம்ʼ நக³ரம்ʼ ஸ்தா²பிதமாஸ்தே தஸ்மாந்நிக்ஷேப்தும்ʼ தஸ்ய ஸி²க²ரம்ʼ தம்ʼ நிந்யு​: ");
INSERT INTO santam_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","கிந்து ஸ தேஷாம்ʼ மத்⁴யாத³பஸ்ருʼத்ய ஸ்தா²நாந்தரம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","தத​: பரம்ʼ யீஸு²ர்கா³லீல்ப்ரதே³ஸீ²யகப²ர்நாஹூம்நக³ர உபஸ்தா²ய விஸ்²ராமவாரே லோகாநுபதே³ஷ்டும் ஆரப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","தது³பதே³ஸா²த் ஸர்வ்வே சமச்சக்ரு ர்யதஸ்தஸ்ய கதா² கு³ருதரா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ததா³நீம்ʼ தத்³ப⁴ஜநகே³ஹஸ்தி²தோ(அ)மேத்⁴யபூ⁴தக்³ரஸ்த ஏகோ ஜந உச்சை​: கத²யாமாஸ, ");
INSERT INTO santam_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ஹே நாஸரதீயயீஸோ²(அ)ஸ்மாந் த்யஜ, த்வயா ஸஹாஸ்மாகம்ʼ க​: ஸம்ப³ந்த⁴​:? கிமஸ்மாந் விநாஸ²யிதுமாயாஸி? த்வமீஸ்²வரஸ்ய பவித்ரோ ஜந ஏதத³ஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ததா³ யீஸு²ஸ்தம்ʼ தர்ஜயித்வாவத³த் மௌநீ ப⁴வ இதோ ப³ஹிர்ப⁴வ; தத​: ஸோமேத்⁴யபூ⁴தஸ்தம்ʼ மத்⁴யஸ்தா²நே பாதயித்வா கிஞ்சித³ப்யஹிம்ʼஸித்வா தஸ்மாத்³ ப³ஹிர்க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","தத​: ஸர்வ்வே லோகாஸ்²சமத்க்ருʼத்ய பரஸ்பரம்ʼ வக்துமாரேபி⁴ரே கோயம்ʼ சமத்கார​:| ஏஷ ப்ரபா⁴வேண பராக்ரமேண சாமேத்⁴யபூ⁴தாந் ஆஜ்ஞாபயதி தேநைவ தே ப³ஹிர்க³ச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","அநந்தரம்ʼ சதுர்தி³க்ஸ்த²தே³ஸா²ந் தஸ்ய ஸுக்²யாதிர்வ்யாப்நோத்| ");
INSERT INTO santam_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","தத³நந்தரம்ʼ ஸ ப⁴ஜநகே³ஹாத்³ ப³ஹிராக³த்ய ஸி²மோநோ நிவேஸ²நம்ʼ ப்ரவிவேஸ² ததா³ தஸ்ய ஸ்²வஸ்²ரூர்ஜ்வரேணாத்யந்தம்ʼ பீடி³தாஸீத் ஸி²ஷ்யாஸ்தத³ர்த²ம்ʼ தஸ்மிந் விநயம்ʼ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","தத​: ஸ தஸ்யா​: ஸமீபே ஸ்தி²த்வா ஜ்வரம்ʼ தர்ஜயாமாஸ தேநைவ தாம்ʼ ஜ்வரோ(அ)த்யாக்ஷீத் தத​: ஸா தத்க்ஷணம் உத்தா²ய தாந் ஸிஷேவே| ");
INSERT INTO santam_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","அத² ஸூர்ய்யாஸ்தகாலே ஸ்வேஷாம்ʼ யே யே ஜநா நாநாரோகை³​: பீடி³தா ஆஸந் லோகாஸ்தாந் யீஸோ²​: ஸமீபம் ஆநிந்யு​:, ததா³ ஸ ஏகைகஸ்ய கா³த்ரே கரமர்பயித்வா தாநரோகா³ந் சகார| ");
INSERT INTO santam_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ததோ பூ⁴தா ப³ஹுப்⁴யோ நிர்க³த்ய சீத்ஸ²ப்³த³ம்ʼ க்ருʼத்வா ச ப³பா⁴ஷிரே த்வமீஸ்²வரஸ்ய புத்ரோ(அ)பி⁴ஷிக்தத்ராதா; கிந்து ஸோபி⁴ஷிக்தத்ராதேதி தே விவிது³ரேதஸ்மாத் காரணாத் தாந் தர்ஜயித்வா தத்³வக்தும்ʼ நிஷிஷேத⁴| ");
INSERT INTO santam_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","அபரஞ்ச ப்ரபா⁴தே ஸதி ஸ விஜநஸ்தா²நம்ʼ ப்ரதஸ்தே² பஸ்²சாத் ஜநாஸ்தமந்விச்ச²ந்தஸ்தந்நிகடம்ʼ க³த்வா ஸ்தா²நாந்தரக³மநார்த²ம்ʼ தமந்வருந்த⁴ந்| ");
INSERT INTO santam_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","கிந்து ஸ தாந் ஜகா³த³, ஈஸ்²வரீயராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும் அந்யாநி புராண்யபி மயா யாதவ்யாநி யதஸ்தத³ர்த²மேவ ப்ரேரிதோஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","அத² கா³லீலோ ப⁴ஜநகே³ஹேஷு ஸ உபதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","அநந்தரம்ʼ யீஸு²ரேகதா³ கி³நேஷரத்²த³ஸ்ய தீர உத்திஷ்ட²தி, ததா³ லோகா ஈஸ்²வரீயகதா²ம்ʼ ஸ்²ரோதும்ʼ தது³பரி ப்ரபதிதா​:| ");
INSERT INTO santam_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ததா³நீம்ʼ ஸ ஹ்த³ஸ்ய தீரஸமீபே நௌத்³வயம்ʼ த³த³ர்ஸ² கிஞ்ச மத்ஸ்யோபஜீவிநோ நாவம்ʼ விஹாய ஜாலம்ʼ ப்ரக்ஷாலயந்தி| ");
INSERT INTO santam_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ததஸ்தயோர்த்³வயோ ர்மத்⁴யே ஸி²மோநோ நாவமாருஹ்ய தீராத் கிஞ்சித்³தூ³ரம்ʼ யாதும்ʼ தஸ்மிந் விநயம்ʼ க்ருʼத்வா நௌகாயாமுபவிஸ்²ய லோகாந் ப்ரோபதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","பஸ்²சாத் தம்ʼ ப்ரஸ்தாவம்ʼ ஸமாப்ய ஸ ஸி²மோநம்ʼ வ்யாஜஹார, க³பீ⁴ரம்ʼ ஜலம்ʼ க³த்வா மத்ஸ்யாந் த⁴ர்த்தும்ʼ ஜாலம்ʼ நிக்ஷிப| ");
INSERT INTO santam_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","தத​: ஸி²மோந ப³பா⁴ஷே, ஹே கு³ரோ யத்³யபி வயம்ʼ க்ருʼத்ஸ்நாம்ʼ யாமிநீம்ʼ பரிஸ்²ரம்ய மத்ஸ்யைகமபி ந ப்ராப்தாஸ்ததா²பி ப⁴வதோ நிதே³ஸ²தோ ஜாலம்ʼ க்ஷிபாம​:| ");
INSERT INTO santam_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","அத² ஜாலே க்ஷிப்தே ப³ஹுமத்ஸ்யபதநாத்³ ஆநாய​: ப்ரச்சி²ந்ந​:| ");
INSERT INTO santam_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","தஸ்மாத்³ உபகர்த்தும் அந்யநௌஸ்தா²ந் ஸங்கி³ந ஆயாதும் இங்கி³தேந ஸமாஹ்வயந் ததஸ்த ஆக³த்ய மத்ஸ்யை ர்நௌத்³வயம்ʼ ப்ரபூரயாமாஸு ர்யை ர்நௌத்³வயம்ʼ ப்ரமக்³நம்| ");
INSERT INTO santam_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ததா³ ஸி²மோந்பிதரஸ்தத்³ விலோக்ய யீஸோ²ஸ்²சரணயோ​: பதித்வா, ஹே ப்ரபோ⁴ஹம்ʼ பாபீ நரோ மம நிகடாத்³ ப⁴வாந் யாது, இதி கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","யதோ ஜாலே பதிதாநாம்ʼ மத்ஸ்யாநாம்ʼ யூதா²த் ஸி²மோந் தத்ஸங்கி³நஸ்²ச சமத்க்ருʼதவந்த​:; ஸி²மோந​: ஸஹகாரிணௌ ஸிவதே³​: புத்ரௌ யாகூப்³ யோஹந் சேமௌ தாத்³ருʼஸௌ² ப³பூ⁴வது​:| ");
INSERT INTO santam_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ததா³ யீஸு²​: ஸி²மோநம்ʼ ஜகா³த³ மா பை⁴ஷீரத்³யாரப்⁴ய த்வம்ʼ மநுஷ்யத⁴ரோ ப⁴விஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","அநந்தரம்ʼ ஸர்வ்வாஸு நௌஸு தீரம் ஆநீதாஸு தே ஸர்வ்வாந் பரித்யஜ்ய தஸ்ய பஸ்²சாத்³கா³மிநோ ப³பூ⁴வு​:| ");
INSERT INTO santam_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","தத​: பரம்ʼ யீஸௌ² கஸ்மிம்ʼஸ்²சித் புரே திஷ்ட²தி ஜந ஏக​: ஸர்வ்வாங்க³குஷ்ட²ஸ்தம்ʼ விலோக்ய தஸ்ய ஸமீபே ந்யுப்³ஜ​: பதித்வா ஸவிநயம்ʼ வக்துமாரேபே⁴, ஹே ப்ரபோ⁴ யதி³ ப⁴வாநிச்ச²தி தர்ஹி மாம்ʼ பரிஷ்கர்த்தும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ததா³நீம்ʼ ஸ பாணிம்ʼ ப்ரஸார்ய்ய தத³ங்க³ம்ʼ ஸ்ப்ருʼஸ²ந் ப³பா⁴ஷே த்வம்ʼ பரிஷ்க்ரியஸ்வேதி மமேச்சா²ஸ்தி ததஸ்தத்க்ஷணம்ʼ ஸ குஷ்டா²த் முக்த​:| ");
INSERT INTO santam_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","பஸ்²சாத் ஸ தமாஜ்ஞாபயாமாஸ கதா²மிமாம்ʼ கஸ்மைசித்³ அகத²யித்வா யாஜகஸ்ய ஸமீபஞ்ச க³த்வா ஸ்வம்ʼ த³ர்ஸ²ய, லோகேப்⁴யோ நிஜபரிஷ்க்ருʼதத்வஸ்ய ப்ரமாணதா³நாய மூஸாஜ்ஞாநுஸாரேண த்³ரவ்யமுத்ம்ருʼஜஸ்வ ச| ");
INSERT INTO santam_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ததா²பி யீஸோ²​: ஸுக்²யாதி ர்ப³ஹு வ்யாப்துமாரேபே⁴ கிஞ்ச தஸ்ய கதா²ம்ʼ ஸ்²ரோதும்ʼ ஸ்வீயரோகே³ப்⁴யோ மோக்துஞ்ச லோகா ஆஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","அத² ஸ ப்ராந்தரம்ʼ க³த்வா ப்ரார்த²யாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","அபரஞ்ச ஏகதா³ யீஸு²ருபதி³ஸ²தி, ஏதர்ஹி கா³லீல்யிஹூதா³ப்ரதே³ஸ²யோ​: ஸர்வ்வநக³ரேப்⁴யோ யிரூஸா²லமஸ்²ச கியந்த​: பி²ரூஸி²லோகா வ்யவஸ்தா²பகாஸ்²ச ஸமாக³த்ய தத³ந்திகே ஸமுபவிவிஸு²​:, தஸ்மிந் காலே லோகாநாமாரோக்³யகாரணாத் ப்ரபோ⁴​: ப்ரபா⁴வ​: ப்ரசகாஸே²| ");
INSERT INTO santam_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","பஸ்²சாத் கியந்தோ லோகா ஏகம்ʼ பக்ஷாகா⁴திநம்ʼ க²ட்வாயாம்ʼ நிதா⁴ய யீஸோ²​: ஸமீபமாநேதும்ʼ ஸம்முகே² ஸ்தா²பயிதுஞ்ச வ்யாப்ரியந்த| ");
INSERT INTO santam_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","கிந்து ப³ஹுஜநநிவஹஸம்வாதா⁴த் ந ஸ²க்நுவந்தோ க்³ருʼஹோபரி க³த்வா க்³ருʼஹப்ருʼஷ்ட²ம்ʼ க²நித்வா தம்ʼ பக்ஷாகா⁴திநம்ʼ ஸக²ட்வம்ʼ க்³ருʼஹமத்⁴யே யீஸோ²​: ஸம்முகே² (அ)வரோஹயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ததா³ யீஸு²ஸ்தேஷாம் ஈத்³ருʼஸ²ம்ʼ விஸ்²வாஸம்ʼ விலோக்ய தம்ʼ பக்ஷாகா⁴திநம்ʼ வ்யாஜஹார, ஹே மாநவ தவ பாபமக்ஷம்யத| ");
INSERT INTO santam_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","தஸ்மாத்³ அத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச சித்தைரித்த²ம்ʼ ப்ரசிந்திதவந்த​:, ஏஷ ஜந ஈஸ்²வரம்ʼ நிந்த³தி கோயம்ʼ? கேவலமீஸ்²வரம்ʼ விநா பாபம்ʼ க்ஷந்தும்ʼ க​: ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ததா³ யீஸு²ஸ்தேஷாம் இத்த²ம்ʼ சிந்தநம்ʼ விதி³த்வா தேப்⁴யோகத²யத்³ யூயம்ʼ மநோபி⁴​: குதோ விதர்கயத²? ");
INSERT INTO santam_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","தவ பாபக்ஷமா ஜாதா யத்³வா த்வமுத்தா²ய வ்ரஜ ஏதயோ ர்மத்⁴யே கா கதா² ஸுகத்²யா? ");
INSERT INTO santam_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","கிந்து ப்ருʼதி²வ்யாம்ʼ பாபம்ʼ க்ஷந்தும்ʼ மாநவஸுதஸ்ய ஸாமர்த்²யமஸ்தீதி யதா² யூயம்ʼ ஜ்ஞாதும்ʼ ஸ²க்நுத² தத³ர்த²ம்ʼ (ஸ தம்ʼ பக்ஷாகா⁴திநம்ʼ ஜகா³த³) உத்திஷ்ட² ஸ்வஸ²ய்யாம்ʼ க்³ருʼஹீத்வா க்³ருʼஹம்ʼ யாஹீதி த்வாமாதி³ஸா²மி| ");
INSERT INTO santam_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","தஸ்மாத் ஸ தத்க்ஷணம் உத்தா²ய ஸர்வ்வேஷாம்ʼ ஸாக்ஷாத் நிஜஸ²யநீயம்ʼ க்³ருʼஹீத்வா ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந் நிஜநிவேஸ²நம்ʼ யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","தஸ்மாத் ஸர்வ்வே விஸ்மய ப்ராப்தா மந​:ஸு பீ⁴தாஸ்²ச வயமத்³யாஸம்ப⁴வகார்ய்யாண்யத³ர்ஸா²ம இத்யுக்த்வா பரமேஸ்²வரம்ʼ த⁴ந்யம்ʼ ப்ரோதி³தா​:| ");
INSERT INTO santam_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","தத​: பரம்ʼ ப³ஹிர்க³ச்ச²ந் கரஸஞ்சயஸ்தா²நே லேவிநாமாநம்ʼ கரஸஞ்சாயகம்ʼ த்³ருʼஷ்ட்வா யீஸு²ஸ்தமபி⁴த³தே⁴ மம பஸ்²சாதே³ஹி| ");
INSERT INTO santam_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","தஸ்மாத் ஸ தத்க்ஷணாத் ஸர்வ்வம்ʼ பரித்யஜ்ய தஸ்ய பஸ்²சாதி³யாய| ");
INSERT INTO santam_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","அநந்தரம்ʼ லேவி ர்நிஜக்³ருʼஹே தத³ர்த²ம்ʼ மஹாபோ⁴ஜ்யம்ʼ சகார, ததா³ தை​: ஸஹாநேகே கரஸஞ்சாயிநஸ்தத³ந்யலோகாஸ்²ச போ⁴க்துமுபவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","தஸ்மாத் காரணாத் சண்டா³லாநாம்ʼ பாபிலோகாநாஞ்ச ஸங்கே³ யூயம்ʼ குதோ ப⁴ம்ʼக்³த்⁴வே பிவத² சேதி கதா²ம்ʼ கத²யித்வா பி²ரூஸி²நோ(அ)த்⁴யாபகாஸ்²ச தஸ்ய ஸி²ஷ்யை​: ஸஹ வாக்³யுத்³த⁴ம்ʼ கர்த்துமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","தஸ்மாத்³ யீஸு²ஸ்தாந் ப்ரத்யவோசத்³ அரோக³லோகாநாம்ʼ சிகித்ஸகேந ப்ரயோஜநம்ʼ நாஸ்தி கிந்து ஸரோகா³ணாமேவ| ");
INSERT INTO santam_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","அஹம்ʼ தா⁴ர்ம்மிகாந் ஆஹ்வாதும்ʼ நாக³தோஸ்மி கிந்து மந​: பராவர்த்தயிதும்ʼ பாபிந ஏவ| ");
INSERT INTO santam_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ததஸ்தே ப்ரோசு​:, யோஹந​: பி²ரூஸி²நாஞ்ச ஸி²ஷ்யா வாரம்ʼவாரம் உபவஸந்தி ப்ரார்த²யந்தே ச கிந்து தவ ஸி²ஷ்யா​: குதோ பு⁴ஞ்ஜதே பிவந்தி ச? ");
INSERT INTO santam_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ததா³ ஸ தாநாசக்²யௌ வரே ஸங்கே³ திஷ்ட²தி வரஸ்ய ஸகி²க³ணம்ʼ கிமுபவாஸயிதும்ʼ ஸ²க்நுத²? ");
INSERT INTO santam_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","கிந்து யதா³ தேஷாம்ʼ நிகடாத்³ வரோ நேஷ்யதே ததா³ தே ஸமுபவத்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ஸோபரமபி த்³ருʼஷ்டாந்தம்ʼ கத²யாம்ப³பூ⁴வ புராதநவஸ்த்ரே கோபி நுதநவஸ்த்ரம்ʼ ந ஸீவ்யதி யதஸ்தேந ஸேவநேந ஜீர்ணவஸ்த்ரம்ʼ சி²த்³யதே, நூதநபுராதநவஸ்த்ரயோ ர்மேலஞ்ச ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","புராதந்யாம்ʼ குத்வாம்ʼ கோபி நுதநம்ʼ த்³ராக்ஷாரஸம்ʼ ந நித³தா⁴தி, யதோ நவீநத்³ராக்ஷாரஸஸ்ய தேஜஸா புராதநீ குதூ ர்விதீ³ர்ய்யதே ததோ த்³ராக்ஷாரஸ​: பததி குதூஸ்²ச நஸ்²யதி| ");
INSERT INTO santam_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ததோ ஹேதோ ர்நூதந்யாம்ʼ குத்வாம்ʼ நவீநத்³ராக்ஷாரஸ​: நிதா⁴தவ்யஸ்தேநோப⁴யஸ்ய ரக்ஷா ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","அபரஞ்ச புராதநம்ʼ த்³ராக்ஷாரஸம்ʼ பீத்வா கோபி நூதநம்ʼ ந வாஞ்ச²தி, யத​: ஸ வக்தி நூதநாத் புராதநம் ப்ரஸ²ஸ்தம்| ");
INSERT INTO santam_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","அசரஞ்ச பர்வ்வணோ த்³விதீயதி³நாத் பரம்ʼ ப்ரத²மவிஸ்²ராமவாரே ஸ²ஸ்யக்ஷேத்ரேண யீஸோ²ர்க³மநகாலே தஸ்ய ஸி²ஷ்யா​: கணிஸ²ம்ʼ சி²த்த்வா கரேஷு மர்த்³த³யித்வா கா²தி³துமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","தஸ்மாத் கியந்த​: பி²ரூஸி²நஸ்தாநவத³ந் விஸ்²ராமவாரே யத் கர்ம்ம ந கர்த்தவ்யம்ʼ தத் குத​: குருத²? ");
INSERT INTO santam_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","யீஸு²​: ப்ரத்யுவாச தா³யூத்³ தஸ்ய ஸங்கி³நஸ்²ச க்ஷுதா⁴ர்த்தா​: கிம்ʼ சக்ரு​: ஸ கத²ம் ஈஸ்²வரஸ்ய மந்தி³ரம்ʼ ப்ரவிஸ்²ய ");
INSERT INTO santam_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","யே த³ர்ஸ²நீயா​: பூபா யாஜகாந் விநாந்யஸ்ய கஸ்யாப்யபோ⁴ஜநீயாஸ்தாநாநீய ஸ்வயம்ʼ பு³ப⁴ஜே ஸங்கி³ப்⁴யோபி த³தௌ³ தத் கிம்ʼ யுஷ்மாபி⁴​: கதா³பி நாபாடி²? ");
INSERT INTO santam_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","பஸ்²சாத் ஸ தாநவத³த் மநுஜஸுதோ விஸ்²ராமவாரஸ்யாபி ப்ரபு⁴ ர்ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","அநந்தரம் அந்யவிஸ்²ராமவாரே ஸ ப⁴ஜநகே³ஹம்ʼ ப்ரவிஸ்²ய ஸமுபதி³ஸ²தி| ததா³ தத்ஸ்தா²நே ஸு²ஷ்கத³க்ஷிணகர ஏக​: புமாந் உபதஸ்தி²வாந்| ");
INSERT INTO santam_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","தஸ்மாத்³ அத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச தஸ்மிந் தோ³ஷமாரோபயிதும்ʼ ஸ விஸ்²ராமவாரே தஸ்ய ஸ்வாஸ்த்²யம்ʼ கரோதி நவேதி ப்ரதீக்ஷிதுமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ததா³ யீஸு²ஸ்தேஷாம்ʼ சிந்தாம்ʼ விதி³த்வா தம்ʼ ஸு²ஷ்ககரம்ʼ புமாம்ʼஸம்ʼ ப்ரோவாச, த்வமுத்தா²ய மத்⁴யஸ்தா²நே திஷ்ட²| ");
INSERT INTO santam_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","தஸ்மாத் தஸ்மிந் உத்தி²தவதி யீஸு²ஸ்தாந் வ்யாஜஹார, யுஷ்மாந் இமாம்ʼ கதா²ம்ʼ ப்ருʼச்சா²மி, விஸ்²ராமவாரே ஹிதம் அஹிதம்ʼ வா, ப்ராணரக்ஷணம்ʼ ப்ராணநாஸ²நம்ʼ வா, ஏதேஷாம்ʼ கிம்ʼ கர்ம்மகரணீயம்? ");
INSERT INTO santam_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","பஸ்²சாத் சதுர்தி³க்ஷு ஸர்வ்வாந் விலோக்ய தம்ʼ மாநவம்ʼ ப³பா⁴ஷே, நிஜகரம்ʼ ப்ரஸாரய; ததஸ்தேந ததா² க்ருʼத இதரகரவத் தஸ்ய ஹஸ்த​: ஸ்வஸ்தோ²ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","தஸ்மாத் தே ப்ரசண்ட³கோபாந்விதா யீஸு²ம்ʼ கிம்ʼ கரிஷ்யந்தீதி பரஸ்பரம்ʼ ப்ரமந்த்ரிதா​:| ");
INSERT INTO santam_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","தத​: பரம்ʼ ஸ பர்வ்வதமாருஹ்யேஸ்²வரமுத்³தி³ஸ்²ய ப்ரார்த²யமாந​: க்ருʼத்ஸ்நாம்ʼ ராத்ரிம்ʼ யாபிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","அத² தி³நே ஸதி ஸ ஸர்வ்வாந் ஸி²ஷ்யாந் ஆஹூதவாந் தேஷாம்ʼ மத்⁴யே ");
INSERT INTO santam_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","பிதரநாம்நா க்²யாத​: ஸி²மோந் தஸ்ய ப்⁴ராதா ஆந்த்³ரியஸ்²ச யாகூப்³ யோஹந் ச பி²லிப் ப³ர்த²லமயஸ்²ச ");
INSERT INTO santam_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","மதி²​: தோ²மா ஆல்பீ²யஸ்ய புத்ரோ யாகூப்³ ஜ்வலந்தநாம்நா க்²யாத​: ஸி²மோந் ");
INSERT INTO santam_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ச யாகூபோ³ ப்⁴ராதா யிஹூதா³ஸ்²ச தம்ʼ ய​: பரகரேஷு ஸமர்பயிஷ்யதி ஸ ஈஷ்கரீயோதீயயிஹூதா³ஸ்²சைதாந் த்³வாத³ஸ² ஜநாந் மநோநீதாந் க்ருʼத்வா ஸ ஜக்³ராஹ ததா² ப்ரேரித இதி தேஷாம்ʼ நாம சகார| ");
INSERT INTO santam_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","தத​: பரம்ʼ ஸ தை​: ஸஹ பர்வ்வதாத³வருஹ்ய உபத்யகாயாம்ʼ தஸ்தௌ² ததஸ்தஸ்ய ஸி²ஷ்யஸங்கோ⁴ யிஹூதா³தே³ஸா²த்³ யிரூஸா²லமஸ்²ச ஸோர​: ஸீதோ³நஸ்²ச ஜலதே⁴ ரோத⁴ஸோ ஜநநிஹாஸ்²ச ஏத்ய தஸ்ய கதா²ஸ்²ரவணார்த²ம்ʼ ரோக³முக்த்யர்த²ஞ்ச தஸ்ய ஸமீபே தஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","அமேத்⁴யபூ⁴தக்³ரஸ்தாஸ்²ச தந்நிகடமாக³த்ய ஸ்வாஸ்த்²யம்ʼ ப்ராபு​:| ");
INSERT INTO santam_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ஸர்வ்வேஷாம்ʼ ஸ்வாஸ்த்²யகரணப்ரபா⁴வஸ்ய ப்ரகாஸி²தத்வாத் ஸர்வ்வே லோகா ஏத்ய தம்ʼ ஸ்ப்ரஷ்டும்ʼ யேதிரே| ");
INSERT INTO santam_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","பஸ்²சாத் ஸ ஸி²ஷ்யாந் ப்ரதி த்³ருʼஷ்டிம்ʼ குத்வா ஜகா³த³, ஹே த³ரித்³ரா யூயம்ʼ த⁴ந்யா யத ஈஸ்²வரீயே ராஜ்யே வோ(அ)தி⁴காரோஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ஹே அது⁴நா க்ஷுதி⁴தலோகா யூயம்ʼ த⁴ந்யா யதோ யூயம்ʼ தர்ப்ஸ்யத²; ஹே இஹ ரோதி³நோ ஜநா யூயம்ʼ த⁴ந்யா யதோ யூயம்ʼ ஹஸிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","யதா³ லோகா மநுஷ்யஸூநோ ர்நாமஹேதோ ர்யுஷ்மாந் ருʼृதீயிஷ்யந்தே ப்ருʼத²க் க்ருʼத்வா நிந்தி³ஷ்யந்தி, அத⁴மாநிவ யுஷ்மாந் ஸ்வஸமீபாத்³ தூ³ரீகரிஷ்யந்தி ச ததா³ யூயம்ʼ த⁴ந்யா​:| ");
INSERT INTO santam_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ஸ்வர்கே³ யுஷ்மாகம்ʼ யதே²ஷ்டம்ʼ ப²லம்ʼ ப⁴விஷ்யதி, ஏதத³ர்த²ம்ʼ தஸ்மிந் தி³நே ப்ரோல்லஸத ஆநந்தே³ந ந்ருʼத்யத ச, தேஷாம்ʼ பூர்வ்வபுருஷாஸ்²ச ப⁴விஷ்யத்³வாதி³ந​: ப்ரதி ததை²வ வ்யவாஹரந்| ");
INSERT INTO santam_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","கிந்து ஹா ஹா த⁴நவந்தோ யூயம்ʼ ஸுக²ம்ʼ ப்ராப்நுத| ஹந்த பரித்ருʼப்தா யூயம்ʼ க்ஷுதி⁴தா ப⁴விஷ்யத²; ");
INSERT INTO santam_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","இஹ ஹஸந்தோ யூயம்ʼ வத யுஷ்மாபி⁴​: ஸோ²சிதவ்யம்ʼ ரோதி³தவ்யஞ்ச| ");
INSERT INTO santam_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ஸர்வ்வைலாகை ர்யுஷ்மாகம்ʼ ஸுக்²யாதௌ க்ருʼதாயாம்ʼ யுஷ்மாகம்ʼ து³ர்க³தி ர்ப⁴விஷ்யதி யுஷ்மாகம்ʼ பூர்வ்வபுருஷா ம்ருʼஷாப⁴விஷ்யத்³வாதி³ந​: ப்ரதி தத்³வத் க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ஹே ஸ்²ரோதாரோ யுஷ்மப்⁴யமஹம்ʼ கத²யாமி, யூயம்ʼ ஸ²த்ருஷு ப்ரீயத்⁴வம்ʼ யே ச யுஷ்மாந் த்³விஷந்தி தேஷாமபி ஹிதம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","யே ச யுஷ்மாந் ஸ²பந்தி தேப்⁴ய ஆஸி²ஷம்ʼ த³த்த யே ச யுஷ்மாந் அவமந்யந்தே தேஷாம்ʼ மங்க³லம்ʼ ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","யதி³ கஸ்²சித் தவ கபோலே சபேடாகா⁴தம்ʼ கரோதி தர்ஹி தம்ʼ ப்ரதி கபோலம் அந்யம்ʼ பராவர்த்த்ய ஸம்முகீ²குரு புநஸ்²ச யதி³ கஸ்²சித் தவ கா³த்ரீயவஸ்த்ரம்ʼ ஹரதி தர்ஹி தம்ʼ பரிதே⁴யவஸ்த்ரம் அபி க்³ரஹீதும்ʼ மா வாரய| ");
INSERT INTO santam_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","யஸ்த்வாம்ʼ யாசதே தஸ்மை தே³ஹி, யஸ்²ச தவ ஸம்பத்திம்ʼ ஹரதி தம்ʼ மா யாசஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","பரேப்⁴ய​: ஸ்வாந் ப்ரதி யதா²சரணம் அபேக்ஷத்⁴வே பராந் ப்ரதி யூயமபி ததா²சரத| ");
INSERT INTO santam_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","யே ஜநா யுஷ்மாஸு ப்ரீயந்தே கேவலம்ʼ தேஷு ப்ரீயமாணேஷு யுஷ்மாகம்ʼ கிம்ʼ ப²லம்ʼ? பாபிலோகா அபி ஸ்வேஷு ப்ரீயமாணேஷு ப்ரீயந்தே| ");
INSERT INTO santam_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","யதி³ ஹிதகாரிண ஏவ ஹிதம்ʼ குருத² தர்ஹி யுஷ்மாகம்ʼ கிம்ʼ ப²லம்ʼ? பாபிலோகா அபி ததா² குர்வ்வந்தி| ");
INSERT INTO santam_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","யேப்⁴ய ருʼணபரிஸோ²த⁴ஸ்ய ப்ராப்திப்ரத்யாஸா²ஸ்தே கேவலம்ʼ தேஷு ருʼணே ஸமர்பிதே யுஷ்மாகம்ʼ கிம்ʼ ப²லம்ʼ? புந​: ப்ராப்த்யாஸ²யா பாபீலோகா அபி பாபிஜநேஷு ருʼணம் அர்பயந்தி| ");
INSERT INTO santam_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","அதோ யூயம்ʼ ரிபுஷ்வபி ப்ரீயத்⁴வம்ʼ, பரஹிதம்ʼ குருத ச; புந​: ப்ராப்த்யாஸா²ம்ʼ த்யக்த்வா ருʼணமர்பயத, ததா² க்ருʼதே யுஷ்மாகம்ʼ மஹாப²லம்ʼ ப⁴விஷ்யதி, யூயஞ்ச ஸர்வ்வப்ரதா⁴நஸ்ய ஸந்தாநா இதி க்²யாதிம்ʼ ப்ராப்ஸ்யத², யதோ யுஷ்மாகம்ʼ பிதா க்ருʼதக்⁴நாநாம்ʼ து³ர்வ்டத்தாநாஞ்ச ஹிதமாசரதி| ");
INSERT INTO santam_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","அத ஏவ ஸ யதா² த³யாலு ர்யூயமபி தாத்³ருʼஸா² த³யாலவோ ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","அபரஞ்ச பராந் தோ³ஷிணோ மா குருத தஸ்மாத்³ யூயம்ʼ தோ³ஷீக்ருʼதா ந ப⁴விஷ்யத²; அத³ண்ட்³யாந் மா த³ண்ட³யத தஸ்மாத்³ யூயமபி த³ண்ட³ம்ʼ ந ப்ராப்ஸ்யத²; பரேஷாம்ʼ தோ³ஷாந் க்ஷமத்⁴வம்ʼ தஸ்மாத்³ யுஷ்மாகமபி தோ³ஷா​: க்ஷமிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","தா³நாநித³த்த தஸ்மாத்³ யூயம்ʼ தா³நாநி ப்ராப்ஸ்யத², வரஞ்ச லோகா​: பரிமாணபாத்ரம்ʼ ப்ரத³லய்ய ஸஞ்சால்ய ப்ரோஞ்சால்ய பரிபூர்ய்ய யுஷ்மாகம்ʼ க்ரோடே³ஷு ஸமர்பயிஷ்யந்தி; யூயம்ʼ யேந பரிமாணேந பரிமாத² தேநைவ பரிமாணேந யுஷ்மத்க்ருʼதே பரிமாஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","அத² ஸ தேப்⁴யோ த்³ருʼஷ்டாந்தகதா²மகத²யத், அந்தோ⁴ ஜந​: கிமந்த⁴ம்ʼ பந்தா²நம்ʼ த³ர்ஸ²யிதும்ʼ ஸ²க்நோதி? தஸ்மாத்³ உபா⁴வபி கிம்ʼ க³ர்த்தே ந பதிஷ்யத​:? ");
INSERT INTO santam_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","கு³ரோ​: ஸி²ஷ்யோ ந ஸ்²ரேஷ்ட²​: கிந்து ஸி²ஷ்யே ஸித்³தே⁴ ஸதி ஸ கு³ருதுல்யோ ப⁴விதும்ʼ ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","அபரஞ்ச த்வம்ʼ ஸ்வசக்ஷுुஷி நாஸாம் அத்³ருʼஷ்ட்வா தவ ப்⁴ராதுஸ்²சக்ஷுஷி யத்த்ருʼணமஸ்தி ததே³வ குத​: பஸ்²யமி? ");
INSERT INTO santam_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ஸ்வசக்ஷுஷி யா நாஸா வித்³யதே தாம் அஜ்ஞாத்வா, ப்⁴ராதஸ்தவ நேத்ராத் த்ருʼணம்ʼ ப³ஹி​: கரோமீதி வாக்யம்ʼ ப்⁴ராதரம்ʼ கத²ம்ʼ வக்தும்ʼ ஸ²க்நோஷி? ஹே கபடிந் பூர்வ்வம்ʼ ஸ்வநயநாத் நாஸாம்ʼ ப³ஹி​: குரு ததோ ப்⁴ராதுஸ்²சக்ஷுஷஸ்த்ருʼணம்ʼ ப³ஹி​: கர்த்தும்ʼ ஸுத்³ருʼஷ்டிம்ʼ ப்ராப்ஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","அந்யஞ்ச உத்தமஸ்தரு​: கதா³பி ப²லமநுத்தமம்ʼ ந ப²லதி, அநுத்தமதருஸ்²ச ப²லமுத்தமம்ʼ ந ப²லதி காரணாத³த​: ப²லைஸ்தரவோ ஜ்ஞாயந்தே| ");
INSERT INTO santam_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","கண்டகிபாத³பாத் கோபி உடு³ம்ப³ரப²லாநி ந பாதயதி ததா² ஸ்²ருʼகா³லகோலிவ்ருʼக்ஷாத³பி கோபி த்³ராக்ஷாப²லம்ʼ ந பாதயதி| ");
INSERT INTO santam_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","தத்³வத் ஸாது⁴லோகோ(அ)ந்த​:கரணரூபாத் ஸுபா⁴ண்டா³கா³ராத்³ உத்தமாநி த்³ரவ்யாணி ப³ஹி​: கரோதி, து³ஷ்டோ லோகஸ்²சாந்த​:கரணரூபாத் குபா⁴ண்டா³கா³ராத் குத்ஸிதாநி த்³ரவ்யாணி நிர்க³மயதி யதோ(அ)ந்த​:கரணாநாம்ʼ பூர்ணபா⁴வாநுரூபாணி வசாம்ʼஸி முகா²ந்நிர்க³ச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","அபரஞ்ச மமாஜ்ஞாநுரூபம்ʼ நாசரித்வா குதோ மாம்ʼ ப்ரபோ⁴ ப்ரபோ⁴ இதி வத³த²? ");
INSERT INTO santam_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ய​: கஸ்²சிந் மம நிகடம் ஆக³த்ய மம கதா² நிஸ²ம்ய தத³நுரூபம்ʼ கர்ம்ம கரோதி ஸ கஸ்ய ஸத்³ருʼஸோ² ப⁴வதி தத³ஹம்ʼ யுஷ்மாந் ஜ்ஞாाபயாமி| ");
INSERT INTO santam_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","யோ ஜநோ க³பீ⁴ரம்ʼ க²நித்வா பாஷாணஸ்த²லே பி⁴த்திம்ʼ நிர்ம்மாய ஸ்வக்³ருʼஹம்ʼ ரசயதி தேந ஸஹ தஸ்யோபமா ப⁴வதி; யத ஆப்லாவிஜலமேத்ய தஸ்ய மூலே வேகே³ந வஹத³பி தத்³கே³ஹம்ʼ லாட³யிதும்ʼ ந ஸ²க்நோதி யதஸ்தஸ்ய பி⁴த்தி​: பாஷாணோபரி திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","கிந்து ய​: கஸ்²சிந் மம கதா²​: ஸ்²ருத்வா தத³நுரூபம்ʼ நாசரதி ஸ பி⁴த்திம்ʼ விநா ம்ருʼृது³பரி க்³ருʼஹநிர்ம்மாத்ரா ஸமாநோ ப⁴வதி; யத ஆப்லாவிஜலமாக³த்ய வேகே³ந யதா³ வஹதி ததா³ தத்³க்³ருʼஹம்ʼ பததி தஸ்ய மஹத் பதநம்ʼ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","தத​: பரம்ʼ ஸ லோகாநாம்ʼ கர்ணகோ³சரே தாந் ஸர்வ்வாந் உபதே³ஸா²ந் ஸமாப்ய யதா³ கப²ர்நாஹூம்புரம்ʼ ப்ரவிஸ²தி ");
INSERT INTO santam_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ததா³ ஸ²தஸேநாபதே​: ப்ரியதா³ஸ ஏகோ ம்ருʼதகல்ப​: பீடி³த ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","அத​: ஸேநாபதி ர்யீஸோ² ர்வார்த்தாம்ʼ நிஸ²ம்ய தா³ஸஸ்யாரோக்³யகரணாய தஸ்யாக³மநார்த²ம்ʼ விநயகரணாய யிஹூதீ³யாந் கியத​: ப்ராச​: ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","தே யீஸோ²ரந்திகம்ʼ க³த்வா விநயாதிஸ²யம்ʼ வக்துமாரேபி⁴ரே, ஸ ஸேநாபதி ர்ப⁴வதோநுக்³ரஹம்ʼ ப்ராப்தும் அர்ஹதி| ");
INSERT INTO santam_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","யத​: ஸோஸ்மஜ்ஜாதீயேஷு லோகேஷு ப்ரீயதே ததா²ஸ்மத்க்ருʼதே ப⁴ஜநகே³ஹம்ʼ நிர்ம்மிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","தஸ்மாத்³ யீஸு²ஸ்தை​: ஸஹ க³த்வா நிவேஸ²நஸ்ய ஸமீபம்ʼ ப்ராப, ததா³ ஸ ஸ²தஸேநாபதி ர்வக்ஷ்யமாணவாக்யம்ʼ தம்ʼ வக்தும்ʼ ப³ந்தூ⁴ந் ப்ராஹிணோத்| ஹே ப்ரபோ⁴ ஸ்வயம்ʼ ஸ்²ரமோ ந கர்த்தவ்யோ யத்³ ப⁴வதா மத்³கே³ஹமத்⁴யே பாதா³ர்பணம்ʼ க்ரியேத தத³ப்யஹம்ʼ நார்ஹாமி, ");
INSERT INTO santam_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","கிஞ்சாஹம்ʼ ப⁴வத்ஸமீபம்ʼ யாதுமபி நாத்மாநம்ʼ யோக்³யம்ʼ பு³த்³த⁴வாந், ததோ ப⁴வாந் வாக்யமாத்ரம்ʼ வத³து தேநைவ மம தா³ஸ​: ஸ்வஸ்தோ² ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","யஸ்மாத்³ அஹம்ʼ பராதீ⁴நோபி மமாதீ⁴நா யா​: ஸேநா​: ஸந்தி தாஸாம் ஏகஜநம்ʼ ப்ரதி யாஹீதி மயா ப்ரோக்தே ஸ யாதி; தத³ந்யம்ʼ ப்ரதி ஆயாஹீதி ப்ரோக்தே ஸ ஆயாதி; ததா² நிஜதா³ஸம்ʼ ப்ரதி ஏதத் குர்வ்விதி ப்ரோக்தே ஸ ததே³வ கரோதி| ");
INSERT INTO santam_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","யீஸு²ரித³ம்ʼ வாக்யம்ʼ ஸ்²ருத்வா விஸ்மயம்ʼ யயௌ, முக²ம்ʼ பராவர்த்ய பஸ்²சாத்³வர்த்திநோ லோகாந் ப³பா⁴ஷே ச, யுஷ்மாநஹம்ʼ வதா³மி இஸ்ராயேலோ வம்ʼஸ²மத்⁴யேபி விஸ்²வாஸமீத்³ருʼஸ²ம்ʼ ந ப்ராப்நவம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ததஸ்தே ப்ரேஷிதா க்³ருʼஹம்ʼ க³த்வா தம்ʼ பீடி³தம்ʼ தா³ஸம்ʼ ஸ்வஸ்த²ம்ʼ த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","பரே(அ)ஹநி ஸ நாயீநாக்²யம்ʼ நக³ரம்ʼ ஜகா³ம தஸ்யாநேகே ஸி²ஷ்யா அந்யே ச லோகாஸ்தேந ஸார்த்³த⁴ம்ʼ யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","தேஷு தந்நக³ரஸ்ய த்³வாரஸந்நிதி⁴ம்ʼ ப்ராப்தேஷு கியந்தோ லோகா ஏகம்ʼ ம்ருʼதமநுஜம்ʼ வஹந்தோ நக³ரஸ்ய ப³ஹிர்யாந்தி, ஸ தந்மாதுரேகபுத்ரஸ்தந்மாதா ச வித⁴வா; தயா ஸார்த்³த⁴ம்ʼ தந்நக³ரீயா ப³ஹவோ லோகா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ப்ரபு⁴ஸ்தாம்ʼ விலோக்ய ஸாநுகம்ப​: கத²யாமாஸ, மா ரோதீ³​:| ஸ ஸமீபமித்வா க²ட்வாம்ʼ பஸ்பர்ஸ² தஸ்மாத்³ வாஹகா​: ஸ்த²கி³தாஸ்தம்யு​:; ");
INSERT INTO santam_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ததா³ ஸ உவாச ஹே யுவமநுஷ்ய த்வமுத்திஷ்ட², த்வாமஹம் ஆஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","தஸ்மாத் ஸ ம்ருʼதோ ஜநஸ்தத்க்ஷணமுத்தா²ய கதா²ம்ʼ ப்ரகதி²த​:; ததோ யீஸு²ஸ்தஸ்ய மாதரி தம்ʼ ஸமர்பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","தஸ்மாத் ஸர்வ்வே லோகா​: ஸ²ஸ²ங்கிரே; ஏகோ மஹாப⁴விஷ்யத்³வாதீ³ மத்⁴யே(அ)ஸ்மாகம் ஸமுதை³த், ஈஸ்²வரஸ்²ச ஸ்வலோகாநந்வக்³ருʼஹ்லாத் கதா²மிமாம்ʼ கத²யித்வா ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ ஜக³து³​:| ");
INSERT INTO santam_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","தத​: பரம்ʼ ஸமஸ்தம்ʼ யிஹூதா³தே³ஸ²ம்ʼ தஸ்ய சதுர்தி³க்ஸ்த²தே³ஸ²ஞ்ச தஸ்யைதத்கீர்த்தி ர்வ்யாநஸே²| ");
INSERT INTO santam_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","தத​: பரம்ʼ யோஹந​: ஸி²ஷ்யேஷு தம்ʼ தத்³வ்ருʼத்தாந்தம்ʼ ஜ்ஞாபிதவத்ஸு ");
INSERT INTO santam_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ஸ ஸ்வஸி²ஷ்யாணாம்ʼ த்³வௌ ஜநாவாஹூய யீஸு²ம்ʼ ப்ரதி வக்ஷ்யமாணம்ʼ வாக்யம்ʼ வக்தும்ʼ ப்ரேஷயாமாஸ, யஸ்யாக³மநம் அபேக்ஷ்ய திஷ்டா²மோ வயம்ʼ கிம்ʼ ஸ ஏவ ஜநஸ்த்வம்ʼ? கிம்ʼ வயமந்யமபேக்ஷ்ய ஸ்தா²ஸ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","பஸ்²சாத்தௌ மாநவௌ க³த்வா கத²யாமாஸது​:, யஸ்யாக³மநம் அபேக்ஷ்ய திஷ்டா²மோ வயம்ʼ, கிம்ʼ ஸஏவ ஜநஸ்த்வம்ʼ? கிம்ʼ வயமந்யமபேக்ஷ்ய ஸ்தா²ஸ்யாம​:? கதா²மிமாம்ʼ துப்⁴யம்ʼ கத²யிதும்ʼ யோஹந் மஜ்ஜக ஆவாம்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","தஸ்மிந் த³ண்டே³ யீஸூ²ரோகி³ணோ மஹாவ்யாதி⁴மதோ து³ஷ்டபூ⁴தக்³ரஸ்தாம்ʼஸ்²ச ப³ஹூந் ஸ்வஸ்தா²ந் க்ருʼத்வா, அநேகாந்தே⁴ப்⁴யஸ்²சக்ஷும்ʼஷி த³த்த்வா ப்ரத்யுவாச, ");
INSERT INTO santam_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","யுவாம்ʼ வ்ரஜதம் அந்தா⁴ நேத்ராணி க²ஞ்ஜாஸ்²சரணாநி ச ப்ராப்நுவந்தி, குஷ்டி²ந​: பரிஷ்க்ரியந்தே, ப³தி⁴ரா​: ஸ்²ரவணாநி ம்ருʼதாஸ்²ச ஜீவநாநி ப்ராப்நுவந்தி, த³ரித்³ராணாம்ʼ ஸமீபேஷு ஸுஸம்ʼவாத³​: ப்ரசார்ய்யதே, யம்ʼ ப்ரதி விக்⁴நஸ்வரூபோஹம்ʼ ந ப⁴வாமி ஸ த⁴ந்ய​:, ");
INSERT INTO santam_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ஏதாநி யாநி பஸ்²யத²​: ஸ்²ருʼணுத²ஸ்²ச தாநி யோஹநம்ʼ ஜ்ஞாபயதம்| ");
INSERT INTO santam_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","தயோ ர்தூ³தயோ ர்க³தயோ​: ஸதோ ர்யோஹநி ஸ லோகாந் வக்துமுபசக்ரமே, யூயம்ʼ மத்⁴யேப்ராந்தரம்ʼ கிம்ʼ த்³ரஷ்டும்ʼ நிரக³மத? கிம்ʼ வாயுநா கம்பிதம்ʼ நட³ம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","யூயம்ʼ கிம்ʼ த்³ரஷ்டும்ʼ நிரக³மத? கிம்ʼ ஸூக்ஷ்மவஸ்த்ரபரிதா⁴யிநம்ʼ கமபி நரம்ʼ? கிந்து யே ஸூக்ஷ்மம்ருʼது³வஸ்த்ராணி பரித³த⁴தி ஸூத்தமாநி த்³ரவ்யாணி பு⁴ஞ்ஜதே ச தே ராஜதா⁴நீஷு திஷ்ட²ந்தி| ");
INSERT INTO santam_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","தர்ஹி யூயம்ʼ கிம்ʼ த்³ரஷ்டும்ʼ நிரக³மத? கிமேகம்ʼ ப⁴விஷ்யத்³வாதி³நம்ʼ? ததே³வ ஸத்யம்ʼ கிந்து ஸ புமாந் ப⁴விஷ்யத்³வாதி³நோபி ஸ்²ரேஷ்ட² இத்யஹம்ʼ யுஷ்மாந் வதா³மி; ");
INSERT INTO santam_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","பஸ்²ய ஸ்வகீயதூ³தந்து தவாக்³ர ப்ரேஷயாம்யஹம்ʼ| க³த்வா த்வதீ³யமார்க³ந்து ஸ ஹி பரிஷ்கரிஷ்யதி| யத³ர்தே² லிபிரியம் ஆஸ்தே ஸ ஏவ யோஹந்| ");
INSERT INTO santam_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","அதோ யுஷ்மாநஹம்ʼ வதா³மி ஸ்த்ரியா க³ர்ப்³ப⁴ஜாதாநாம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ மத்⁴யே யோஹநோ மஜ்ஜகாத் ஸ்²ரேஷ்ட²​: கோபி நாஸ்தி, தத்ராபி ஈஸ்²வரஸ்ய ராஜ்யே ய​: ஸர்வ்வஸ்மாத் க்ஷுத்³ர​: ஸ யோஹநோபி ஸ்²ரேஷ்ட²​:| ");
INSERT INTO santam_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","அபரஞ்ச ஸர்வ்வே லோகா​: கரமஞ்சாயிநஸ்²ச தஸ்ய வாக்யாநி ஸ்²ருத்வா யோஹநா மஜ்ஜநேந மஜ்ஜிதா​: பரமேஸ்²வரம்ʼ நிர்தோ³ஷம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","கிந்து பி²ரூஸி²நோ வ்யவஸ்தா²பகாஸ்²ச தேந ந மஜ்ஜிதா​: ஸ்வாந் ப்ரதீஸ்²வரஸ்யோபதே³ஸ²ம்ʼ நிஷ்ப²லம் அகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","அத² ப்ரபு⁴​: கத²யாமாஸ, இதா³நீந்தநஜநாந் கேநோபமாமி? தே கஸ்ய ஸத்³ருʼஸா²​:? ");
INSERT INTO santam_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","யே பா³லகா விபண்யாம் உபவிஸ்²ய பரஸ்பரம் ஆஹூய வாக்யமித³ம்ʼ வத³ந்தி, வயம்ʼ யுஷ்மாகம்ʼ நிகடே வம்ʼஸீ²ரவாதி³ஷ்ம, கிந்து யூயம்ʼ நாநர்த்திஷ்ட, வயம்ʼ யுஷ்மாகம்ʼ நிகட அரோதி³ஷ்ம, கிந்து யுயம்ʼ ந வ்யலபிஷ்ட, பா³லகைரேதாத்³ருʼஸை²ஸ்தேஷாம் உபமா ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","யதோ யோஹந் மஜ்ஜக ஆக³த்ய பூபம்ʼ நாகா²த³த் த்³ராக்ஷாரஸஞ்ச நாபிவத் தஸ்மாத்³ யூயம்ʼ வத³த², பூ⁴தக்³ரஸ்தோயம்| ");
INSERT INTO santam_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","தத​: பரம்ʼ மாநவஸுத ஆக³த்யாகா²த³த³பிவஞ்ச தஸ்மாத்³ யூயம்ʼ வத³த², கா²த³க​: ஸுராபஸ்²சாண்டா³லபாபிநாம்ʼ ப³ந்து⁴ரேகோ ஜநோ த்³ருʼஸ்²யதாம்| ");
INSERT INTO santam_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","கிந்து ஜ்ஞாநிநோ ஜ்ஞாநம்ʼ நிர்தோ³ஷம்ʼ விது³​:| ");
INSERT INTO santam_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","பஸ்²சாதே³க​: பி²ரூஸீ² யீஸு²ம்ʼ போ⁴ஜநாய ந்யமந்த்ரயத் தத​: ஸ தஸ்ய க்³ருʼஹம்ʼ க³த்வா போ⁴க்துமுபவிஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ஏதர்ஹி தத்பி²ரூஸி²நோ க்³ருʼஹே யீஸு² ர்பே⁴க்தும் உபாவேக்ஷீத் தச்ச்²ருத்வா தந்நக³ரவாஸிநீ காபி து³ஷ்டா நாரீ பாண்ட³ரப்ரஸ்தரஸ்ய ஸம்புடகே ஸுக³ந்தி⁴தைலம் ஆநீய ");
INSERT INTO santam_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","தஸ்ய பஸ்²சாத் பாத³யோ​: ஸந்நிதௌ⁴ தஸ்யௌ ருத³தீ ச நேத்ராம்பு³பி⁴ஸ்தஸ்ய சரணௌ ப்ரக்ஷால்ய நிஜகசைரமார்க்ஷீத், ததஸ்தஸ்ய சரணௌ சும்பி³த்வா தேந ஸுக³ந்தி⁴தைலேந மமர்த³| ");
INSERT INTO santam_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","தஸ்மாத் ஸ நிமந்த்ரயிதா பி²ரூஸீ² மநஸா சிந்தயாமாஸ, யத்³யயம்ʼ ப⁴விஷ்யத்³வாதீ³ ப⁴வேத் தர்ஹி ஏநம்ʼ ஸ்ப்ருʼஸ²தி யா ஸ்த்ரீ ஸா கா கீத்³ருʼஸீ² சேதி ஜ்ஞாதும்ʼ ஸ²க்நுயாத் யத​: ஸா து³ஷ்டா| ");
INSERT INTO santam_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ததா³ யாஸு²ஸ்தம்ʼ ஜகா³த³, ஹே ஸி²மோந் த்வாம்ʼ ப்ரதி மம கிஞ்சித்³ வக்தவ்யமஸ்தி; தஸ்மாத் ஸ ப³பா⁴ஷே, ஹே கு³ரோ தத்³ வத³து| ");
INSERT INTO santam_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ஏகோத்தமர்ணஸ்ய த்³வாவத⁴மர்ணாவாஸ்தாம்ʼ, தயோரேக​: பஞ்சஸ²தாநி முத்³ராபாதா³ந் அபரஸ்²ச பஞ்சாஸ²த் முத்³ராபாதா³ந் தா⁴ரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","தத³நந்தரம்ʼ தயோ​: ஸோ²த்⁴யாபா⁴வாத் ஸ உத்தமர்ணஸ்தயோ ர்ருʼணே சக்ஷமே; தஸ்மாத் தயோர்த்³வயோ​: கஸ்தஸ்மிந் ப்ரேஷ்யதே ப³ஹு? தத்³ ப்³ரூஹி| ");
INSERT INTO santam_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ஸி²மோந் ப்ரத்யுவாச, மயா பு³த்⁴யதே யஸ்யாதி⁴கம் ருʼணம்ʼ சக்ஷமே ஸ இதி; ததோ யீஸு²ஸ்தம்ʼ வ்யாஜஹார, த்வம்ʼ யதா²ர்த²ம்ʼ வ்யசாரய​:| ");
INSERT INTO santam_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","அத² தாம்ʼ நாரீம்ʼ ப்ரதி வ்யாகு⁴ட்²ய ஸி²மோநமவோசத், ஸ்த்ரீமிமாம்ʼ பஸ்²யஸி? தவ க்³ருʼஹே மய்யாக³தே த்வம்ʼ பாத³ப்ரக்ஷாலநார்த²ம்ʼ ஜலம்ʼ நாதா³​: கிந்து யோஷிதே³ஷா நயநஜலை ர்மம பாதௌ³ ப்ரக்ஷால்ய கேஸை²ரமார்க்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","த்வம்ʼ மாம்ʼ நாசும்பீ³​: கிந்து யோஷிதே³ஷா ஸ்வீயாக³மநாதா³ரப்⁴ய மதீ³யபாதௌ³ சும்பி³தும்ʼ ந வ்யரம்ʼஸ்த| ");
INSERT INTO santam_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","த்வஞ்ச மதீ³யோத்தமாங்கே³ கிஞ்சித³பி தைலம்ʼ நாமர்தீ³​: கிந்து யோஷிதே³ஷா மம சரணௌ ஸுக³ந்தி⁴தைலேநாமர்த்³தீ³த்| ");
INSERT INTO santam_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","அதஸ்த்வாம்ʼ வ்யாஹராமி, ஏதஸ்யா ப³ஹு பாபமக்ஷம்யத ததோ ப³ஹு ப்ரீயதே கிந்து யஸ்யால்பபாபம்ʼ க்ஷம்யதே ஸோல்பம்ʼ ப்ரீயதே| ");
INSERT INTO santam_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","தத​: பரம்ʼ ஸ தாம்ʼ ப³பா⁴ஷே, த்வதீ³யம்ʼ பாபமக்ஷம்யத| ");
INSERT INTO santam_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ததா³ தேந ஸார்த்³த⁴ம்ʼ யே போ⁴க்தும் உபவிவிஸு²ஸ்தே பரஸ்பரம்ʼ வக்துமாரேபி⁴ரே, அயம்ʼ பாபம்ʼ க்ஷமதே க ஏஷ​:? ");
INSERT INTO santam_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","கிந்து ஸ தாம்ʼ நாரீம்ʼ ஜகா³த³, தவ விஸ்²வாஸஸ்த்வாம்ʼ பர்ய்யத்ராஸ்த த்வம்ʼ க்ஷேமேண வ்ரஜ| ");
INSERT INTO santam_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","அபரஞ்ச யீஸு² ர்த்³வாத³ஸ²பி⁴​: ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ நாநாநக³ரேஷு நாநாக்³ராமேஷு ச க³ச்ச²ந் இஸ்²வரீயராஜத்வஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும்ʼ ப்ராரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ததா³ யஸ்யா​: ஸப்த பூ⁴தா நிரக³ச்ச²ந் ஸா மக்³த³லீநீதி விக்²யாதா மரியம் ஹேரோத்³ராஜஸ்ய க்³ருʼஹாதி⁴பதே​: ஹோஷே ர்பா⁴ர்ய்யா யோஹநா ஸூ²ஸா²நா ");
INSERT INTO santam_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ப்ரப்⁴ருʼதயோ யா ப³ஹ்வ்ய​: ஸ்த்ரிய​: து³ஷ்டபூ⁴தேப்⁴யோ ரோகே³ப்⁴யஸ்²ச முக்தா​: ஸத்யோ நிஜவிபூ⁴தீ ர்வ்யயித்வா தமஸேவந்த, தா​: ஸர்வ்வாஸ்தேந ஸார்த்³த⁴ம் ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","அநந்தரம்ʼ நாநாநக³ரேப்⁴யோ ப³ஹவோ லோகா ஆக³த்ய தஸ்ய ஸமீபே(அ)மிலந், ததா³ ஸ தேப்⁴ய ஏகாம்ʼ த்³ருʼஷ்டாந்தகதா²ம்ʼ கத²யாமாஸ| ஏக​: க்ருʼஷீப³லோ பீ³ஜாநி வப்தும்ʼ ப³ஹிர்ஜகா³ம, ");
INSERT INTO santam_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ததோ வபநகாலே கதிபயாநி பீ³ஜாநி மார்க³பார்ஸ்²வே பேது​:, ததஸ்தாநி பத³தலை ர்த³லிதாநி பக்ஷிபி⁴ ர்ப⁴க்ஷிதாநி ச| ");
INSERT INTO santam_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","கதிபயாநி பீ³ஜாநி பாஷாணஸ்த²லே பதிதாநி யத்³யபி தாந்யங்குரிதாநி ததா²பி ரஸாபா⁴வாத் ஸு²ஸு²ஷு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","கதிபயாநி பீ³ஜாநி கண்டகிவநமத்⁴யே பதிதாநி தத​: கண்டகிவநாநி ஸம்ʼவ்ருʼத்³த்⁴ய தாநி ஜக்³ரஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","தத³ந்யாநி கதிபயபீ³ஜாநி ச பூ⁴ம்யாமுத்தமாயாம்ʼ பேதுஸ்ததஸ்தாந்யங்குரயித்வா ஸ²தகு³ணாநி ப²லாநி பே²லு​:| ஸ இமா கதா²ம்ʼ கத²யித்வா ப்ரோச்சை​: ப்ரோவாச, யஸ்ய ஸ்²ரோதும்ʼ ஸ்²ரோத்ரே ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","தத​: பரம்ʼ ஸி²ஷ்யாஸ்தம்ʼ பப்ரச்சு²ரஸ்ய த்³ருʼஷ்டாந்தஸ்ய கிம்ʼ தாத்பர்ய்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","தத​: ஸ வ்யாஜஹார, ஈஸ்²வரீயராஜ்யஸ்ய கு³ஹ்யாநி ஜ்ஞாதும்ʼ யுஷ்மப்⁴யமதி⁴காரோ தீ³யதே கிந்த்வந்யே யதா² த்³ருʼஷ்ட்வாபி ந பஸ்²யந்தி ஸ்²ருத்வாபி ம பு³த்⁴யந்தே ச தத³ர்த²ம்ʼ தேஷாம்ʼ புரஸ்தாத் தா​: ஸர்வ்வா​: கதா² த்³ருʼஷ்டாந்தேந கத்²யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","த்³ருʼஷ்டாந்தஸ்யாஸ்யாபி⁴ப்ராய​:, ஈஸ்²வரீயகதா² பீ³ஜஸ்வரூபா| ");
INSERT INTO santam_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","யே கதா²மாத்ரம்ʼ ஸ்²ருʼண்வந்தி கிந்து பஸ்²சாத்³ விஸ்²வஸ்ய யதா² பரித்ராணம்ʼ ந ப்ராப்நுவந்தி ததா³ஸ²யேந ஸை²தாநேத்ய ஹ்ருʼத³யாத்ருʼ தாம்ʼ கதா²ம் அபஹரதி த ஏவ மார்க³பார்ஸ்²வஸ்த²பூ⁴மிஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","யே கத²ம்ʼ ஸ்²ருத்வா ஸாநந்த³ம்ʼ க்³ருʼஹ்லந்தி கிந்த்வப³த்³த⁴மூலத்வாத் ஸ்வல்பகாலமாத்ரம்ʼ ப்ரதீத்ய பரீக்ஷாகாலே ப்⁴ரஸ்²யந்தி தஏவ பாஷாணபூ⁴மிஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","யே கதா²ம்ʼ ஸ்²ருத்வா யாந்தி விஷயசிந்தாயாம்ʼ த⁴நலோபே⁴ந ஏेஹிகஸுகே² ச மஜ்ஜந்த உபயுக்தப²லாநி ந ப²லந்தி த ஏவோப்தபீ³ஜகண்டகிபூ⁴ஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","கிந்து யே ஸ்²ருத்வா ஸரலை​: ஸு²த்³தை⁴ஸ்²சாந்த​:கரணை​: கதா²ம்ʼ க்³ருʼஹ்லந்தி தை⁴ர்ய்யம் அவலம்ப்³ய ப²லாந்யுத்பாத³யந்தி ச த ஏவோத்தமம்ருʼத்ஸ்வரூபா​:| ");
INSERT INTO santam_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","அபரஞ்ச ப்ரதீ³பம்ʼ ப்ரஜ்வால்ய கோபி பாத்ரேண நாச்சா²த³யதி ததா² க²ட்வாதோ⁴பி ந ஸ்தா²பயதி, கிந்து தீ³பாதா⁴ரோபர்ய்யேவ ஸ்தா²பயதி, தஸ்மாத் ப்ரவேஸ²கா தீ³ப்திம்ʼ பஸ்²யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","யந்ந ப்ரகாஸ²யிஷ்யதே தாத்³ருʼக்³ அப்ரகாஸி²தம்ʼ வஸ்து கிமபி நாஸ்தி யச்ச ந ஸுவ்யக்தம்ʼ ப்ரசாரயிஷ்யதே தாத்³ருʼக்³ க்³ருʼப்தம்ʼ வஸ்து கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","அதோ யூயம்ʼ கேந ப்ரகாரேண ஸ்²ருʼணுத² தத்ர ஸாவதா⁴நா ப⁴வத, யஸ்ய ஸமீபே ப³ர்த்³த⁴தே தஸ்மை புநர்தா³ஸ்யதே கிந்து யஸ்யாஸ்²ரயே ந ப³ர்த்³த⁴தே தஸ்ய யத்³யத³ஸ்தி தத³பி தஸ்மாத் நேஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","அபரஞ்ச யீஸோ² ர்மாதா ப்⁴ராதரஸ்²ச தஸ்ய ஸமீபம்ʼ ஜிக³மிஷவ​: ");
INSERT INTO santam_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","கிந்து ஜநதாஸம்பா³தா⁴த் தத்ஸந்நிதி⁴ம்ʼ ப்ராப்தும்ʼ ந ஸே²கு​:| தத்பஸ்²சாத் தவ மாதா ப்⁴ராதரஸ்²ச த்வாம்ʼ ஸாக்ஷாத் சிகீர்ஷந்தோ ப³ஹிஸ்திஷ்ட²நதீதி வார்த்தாயாம்ʼ தஸ்மை கதி²தாயாம்ʼ ");
INSERT INTO santam_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ஸ ப்ரத்யுவாச; யே ஜநா ஈஸ்²வரஸ்ய கதா²ம்ʼ ஸ்²ருத்வா தத³நுரூபமாசரந்தி தஏவ மம மாதா ப்⁴ராதரஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","அநந்தரம்ʼ ஏகதா³ யீஸு²​: ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ நாவமாருஹ்ய ஜகா³த³, ஆயாத வயம்ʼ ஹ்ரத³ஸ்ய பாரம்ʼ யாம​:, ததஸ்தே ஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","தேஷு நௌகாம்ʼ வாஹயத்ஸு ஸ நித³த்³ரௌ; ");
INSERT INTO santam_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","அதா²கஸ்மாத் ப்ரப³லஜ²ஞ்ப்⁴ஸ²க³மாத்³ ஹ்ரதே³ நௌகாயாம்ʼ தரங்கை³ராச்ச²ந்நாயாம்ʼ விபத் தாந் ஜக்³ராஸ| தஸ்மாத்³ யீஸோ²ரந்திகம்ʼ க³த்வா ஹே கு³ரோ ஹே கு³ரோ ப்ராணா நோ யாந்தீதி க³தி³த்வா தம்ʼ ஜாக³ரயாம்ப³பூ⁴வு​:| ததா³ ஸ உத்தா²ய வாயும்ʼ தரங்கா³ம்ʼஸ்²ச தர்ஜயாமாஸ தஸ்மாது³பௌ⁴ நிவ்ருʼத்ய ஸ்தி²ரௌ ப³பூ⁴வது​:| ");
INSERT INTO santam_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ஸ தாந் ப³பா⁴ஷே யுஷ்மாகம்ʼ விஸ்²வாஸ​: க? தஸ்மாத்தே பீ⁴தா விஸ்மிதாஸ்²ச பரஸ்பரம்ʼ ஜக³து³​:, அஹோ கீத்³ருʼக³யம்ʼ மநுஜ​: பவநம்ʼ பாநீயஞ்சாதி³ஸ²தி தது³ப⁴யம்ʼ ததா³தே³ஸ²ம்ʼ வஹதி| ");
INSERT INTO santam_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","தத​: பரம்ʼ கா³லீல்ப்ரதே³ஸ²ஸ்ய ஸம்முக²ஸ்த²கி³தே³ரீயப்ரதே³ஸே² நௌகாயாம்ʼ லக³ந்த்யாம்ʼ தடே(அ)வரோஹமாவாத்³ ");
INSERT INTO santam_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ப³ஹுதித²காலம்ʼ பூ⁴தக்³ரஸ்த ஏகோ மாநுஷ​: புராதா³க³த்ய தம்ʼ ஸாக்ஷாச்சகார| ஸ மநுஷோ வாஸோ ந பரித³த⁴த் க்³ருʼஹே ச ந வஸந் கேவலம்ʼ ஸ்²மஸா²நம் அத்⁴யுவாஸ| ");
INSERT INTO santam_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ஸ யீஸு²ம்ʼ த்³ருʼஷ்ட்வைவ சீச்ச²ப்³த³ம்ʼ சகார தஸ்ய ஸம்முகே² பதித்வா ப்ரோச்சைர்ஜகா³த³ ச, ஹே ஸர்வ்வப்ரதா⁴நேஸ்²வரஸ்ய புத்ர, மயா ஸஹ தவ க​: ஸம்ப³ந்த⁴​:? த்வயி விநயம்ʼ கரோமி மாம்ʼ மா யாதய| ");
INSERT INTO santam_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","யத​: ஸ தம்ʼ மாநுஷம்ʼ த்யக்த்வா யாதும் அமேத்⁴யபூ⁴தம் ஆதி³தே³ஸ²; ஸ பூ⁴தஸ்தம்ʼ மாநுஷம் அஸக்ருʼத்³ த³தா⁴ர தஸ்மால்லோகா​: ஸ்²ருʼங்க²லேந நிக³டே³ந ச ப³ப³ந்து⁴​:; ஸ தத்³ ப⁴ம்ʼக்த்வா பூ⁴தவஸ²த்வாத் மத்⁴யேப்ராந்தரம்ʼ யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","அநந்தரம்ʼ யீஸு²ஸ்தம்ʼ பப்ரச்ச² தவ கிந்நாம? ஸ உவாச, மம நாம பா³ஹிநோ யதோ ப³ஹவோ பூ⁴தாஸ்தமாஸி²ஸ்²ரியு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","அத² பூ⁴தா விநயேந ஜக³து³​:, க³பீ⁴ரம்ʼ க³ர்த்தம்ʼ க³ந்தும்ʼ மாஜ்ஞாபயாஸ்மாந்| ");
INSERT INTO santam_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ததா³ பர்வ்வதோபரி வராஹவ்ரஜஸ்²சரதி தஸ்மாத்³ பூ⁴தா விநயேந ப்ரோசு​:, அமும்ʼ வராஹவ்ரஜம் ஆஸ்²ரயிதும் அஸ்மாந் அநுஜாநீஹி; தத​: ஸோநுஜஜ்ஞௌ| ");
INSERT INTO santam_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","தத​: பரம்ʼ பூ⁴தாஸ்தம்ʼ மாநுஷம்ʼ விஹாய வராஹவ்ரஜம் ஆஸி²ஸ்²ரியு​: வராஹவ்ரஜாஸ்²ச தத்க்ஷணாத் கடகேந தா⁴வந்தோ ஹ்ரதே³ ப்ராணாந் விஜ்ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","தத்³ த்³ருʼஷ்ட்வா ஸூ²கரரக்ஷகா​: பலாயமாநா நக³ரம்ʼ க்³ராமஞ்ச க³த்வா தத்ஸர்வ்வவ்ருʼத்தாந்தம்ʼ கத²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","தத​: கிம்ʼ வ்ருʼத்தம் ஏதத்³த³ர்ஸ²நார்த²ம்ʼ லோகா நிர்க³த்ய யீஸோ²​: ஸமீபம்ʼ யயு​:, தம்ʼ மாநுஷம்ʼ த்யக்தபூ⁴தம்ʼ பரிஹிதவஸ்த்ரம்ʼ ஸ்வஸ்த²மாநுஷவத்³ யீஸோ²ஸ்²சரணஸந்நிதௌ⁴ ஸூபவிஸ²ந்தம்ʼ விலோக்ய பி³ப்⁴யு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","யே லோகாஸ்தஸ்ய பூ⁴தக்³ரஸ்தஸ்ய ஸ்வாஸ்த்²யகரணம்ʼ த³த்³ருʼஸு²ஸ்தே தேப்⁴ய​: ஸர்வ்வவ்ருʼத்தாந்தம்ʼ கத²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","தத³நந்தரம்ʼ தஸ்ய கி³தே³ரீயப்ரதே³ஸ²ஸ்ய சதுர்தி³க்ஸ்தா² ப³ஹவோ ஜநா அதித்ரஸ்தா விநயேந தம்ʼ ஜக³து³​:, ப⁴வாந் அஸ்மாகம்ʼ நிகடாத்³ வ்ரஜது தஸ்மாத் ஸ நாவமாருஹ்ய ததோ வ்யாகு⁴ட்ய ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ததா³நீம்ʼ த்யக்தபூ⁴தமநுஜஸ்தேந ஸஹ ஸ்தா²தும்ʼ ப்ரார்த²யாஞ்சக்ரே ");
INSERT INTO santam_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","கிந்து தத³ர்த²ம் ஈஸ்²வர​: கீத்³ருʼங்மஹாகர்ம்ம க்ருʼதவாந் இதி நிவேஸ²நம்ʼ க³த்வா விஜ்ஞாபய, யீஸு²​: கதா²மேதாம்ʼ கத²யித்வா தம்ʼ விஸஸர்ஜ| தத​: ஸ வ்ரஜித்வா யீஸு²ஸ்தத³ர்த²ம்ʼ யந்மஹாகர்ம்ம சகார தத் புரஸ்ய ஸர்வ்வத்ர ப்ரகாஸ²யிதும்ʼ ப்ராரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","அத² யீஸௌ² பராவ்ருʼத்யாக³தே லோகாஸ்தம்ʼ ஆத³ரேண ஜக்³ருʼஹு ர்யஸ்மாத்தே ஸர்வ்வே தமபேக்ஷாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","தத³நந்தரம்ʼ யாயீர்நாம்நோ ப⁴ஜநகே³ஹஸ்யைகோதி⁴ப ஆக³த்ய யீஸோ²ஸ்²சரணயோ​: பதித்வா ஸ்வநிவேஸ²நாக³மநார்த²ம்ʼ தஸ்மிந் விநயம்ʼ சகார, ");
INSERT INTO santam_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","யதஸ்தஸ்ய த்³வாத³ஸ²வர்ஷவயஸ்கா கந்யைகாஸீத் ஸா ம்ருʼதகல்பாப⁴வத்| ததஸ்தஸ்ய க³மநகாலே மார்கே³ லோகாநாம்ʼ மஹாந் ஸமாக³மோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","த்³வாத³ஸ²வர்ஷாணி ப்ரத³ரரோக³க்³ரஸ்தா நாநா வைத்³யைஸ்²சிகித்ஸிதா ஸர்வ்வஸ்வம்ʼ வ்யயித்வாபி ஸ்வாஸ்த்²யம்ʼ ந ப்ராப்தா யா யோஷித் ஸா யீஸோ²​: பஸ்²சாதா³க³த்ய தஸ்ய வஸ்த்ரக்³ரந்தி²ம்ʼ பஸ்பர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","தஸ்மாத் தத்க்ஷணாத் தஸ்யா ரக்தஸ்ராவோ ருத்³த⁴​:| ");
INSERT INTO santam_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ததா³நீம்ʼ யீஸு²ரவத³த் கேநாஹம்ʼ ஸ்ப்ருʼஷ்ட​:? ததோ(அ)நேகைரநங்கீ³க்ருʼதே பிதரஸ்தஸ்ய ஸங்கி³நஸ்²சாவத³ந், ஹே கு³ரோ லோகா நிகடஸ்தா²​: ஸந்தஸ்தவ தே³ஹே க⁴ர்ஷயந்தி, ததா²பி கேநாஹம்ʼ ஸ்ப்ருʼஷ்டஇதி ப⁴வாந் குத​: ப்ருʼச்ச²தி? ");
INSERT INTO santam_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","யீஸு²​: கத²யாமாஸ, கேநாப்யஹம்ʼ ஸ்ப்ருʼஷ்டோ, யதோ மத்த​: ஸ²க்தி ர்நிர்க³தேதி மயா நிஸ்²சிதமஜ்ஞாயி| ");
INSERT INTO santam_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ததா³ ஸா நாரீ ஸ்வயம்ʼ ந கு³ப்தேதி விதி³த்வா கம்பமாநா ஸதீ தஸ்ய ஸம்முகே² பபாத; யேந நிமித்தேந தம்ʼ பஸ்பர்ஸ² ஸ்பர்ஸ²மாத்ராச்ச யேந ப்ரகாரேண ஸ்வஸ்தா²ப⁴வத் தத் ஸர்வ்வம்ʼ தஸ்ய ஸாக்ஷாதா³சக்²யௌ| ");
INSERT INTO santam_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","தத​: ஸ தாம்ʼ ஜகா³த³ ஹே கந்யே ஸுஸ்தி²ரா ப⁴வ, தவ விஸ்²வாஸஸ்த்வாம்ʼ ஸ்வஸ்தா²ம் அகார்ஷீத் த்வம்ʼ க்ஷேமேண யாஹி| ");
INSERT INTO santam_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","யீஸோ²ரேதத்³வாக்யவத³நகாலே தஸ்யாதி⁴பதே ர்நிவேஸ²நாத் கஸ்²சில்லோக ஆக³த்ய தம்ʼ ப³பா⁴ஷே, தவ கந்யா ம்ருʼதா கு³ரும்ʼ மா க்லிஸா²ந| ");
INSERT INTO santam_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","கிந்து யீஸு²ஸ்ததா³கர்ண்யாதி⁴பதிம்ʼ வ்யாஜஹார, மா பை⁴ஷீ​: கேவலம்ʼ விஸ்²வஸிஹி தஸ்மாத் ஸா ஜீவிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","அத² தஸ்ய நிவேஸ²நே ப்ராப்தே ஸ பிதரம்ʼ யோஹநம்ʼ யாகூப³ஞ்ச கந்யாயா மாதரம்ʼ பிதரஞ்ச விநா, அந்யம்ʼ கஞ்சந ப்ரவேஷ்டும்ʼ வாரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","அபரஞ்ச யே ருத³ந்தி விலபந்தி ச தாந் ஸர்வ்வாந் ஜநாந் உவாச, யூயம்ʼ மா ரோதி³ஷ்ட கந்யா ந ம்ருʼதா நித்³ராதி| ");
INSERT INTO santam_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","கிந்து ஸா நிஸ்²சிதம்ʼ ம்ருʼதேதி ஜ்ஞாத்வா தே தமுபஜஹஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","பஸ்²சாத் ஸ ஸர்வ்வாந் ப³ஹி​: க்ருʼத்வா கந்யாயா​: கரௌ த்⁴ருʼத்வாஜுஹுவே, ஹே கந்யே த்வமுத்திஷ்ட², ");
INSERT INTO santam_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","தஸ்மாத் தஸ்யா​: ப்ராணேஷு புநராக³தேஷு ஸா தத்க்ஷணாத்³ உத்தஸ்யௌ| ததா³நீம்ʼ தஸ்யை கிஞ்சித்³ ப⁴க்ஷ்யம்ʼ தா³தும் ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ததஸ்தஸ்யா​: பிதரௌ விஸ்மயம்ʼ க³தௌ கிந்து ஸ தாவாதி³தே³ஸ² க⁴டநாயா ஏதஸ்யா​: கதா²ம்ʼ கஸ்மைசித³பி மா கத²யதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","தத​: பரம்ʼ ஸ த்³வாத³ஸ²ஸி²ஷ்யாநாஹூய பூ⁴தாந் த்யாஜயிதும்ʼ ரோகா³ந் ப்ரதிகர்த்துஞ்ச தேப்⁴ய​: ஸ²க்திமாதி⁴பத்யஞ்ச த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","அபரஞ்ச ஈஸ்²வரீயராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரகாஸ²யிதும் ரோகி³ணாமாரோக்³யம்ʼ கர்த்துஞ்ச ப்ரேரணகாலே தாந் ஜகா³த³| ");
INSERT INTO santam_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","யாத்ரார்த²ம்ʼ யஷ்டி ர்வஸ்த்ரபுடகம்ʼ ப⁴க்ஷ்யம்ʼ முத்³ரா த்³விதீயவஸ்த்ரம், ஏஷாம்ʼ கிமபி மா க்³ருʼஹ்லீத| ");
INSERT INTO santam_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","யூயஞ்ச யந்நிவேஸ²நம்ʼ ப்ரவிஸ²த² நக³ரத்யாக³பர்ய்யநதம்ʼ தந்நிவேஸ²நே திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","தத்ர யதி³ கஸ்யசித் புரஸ்ய லோகா யுஷ்மாகமாதித்²யம்ʼ ந குர்வ்வந்தி தர்ஹி தஸ்மாந்நக³ராத்³ க³மநகாலே தேஷாம்ʼ விருத்³த⁴ம்ʼ ஸாக்ஷ்யார்த²ம்ʼ யுஷ்மாகம்ʼ பத³தூ⁴லீ​: ஸம்பாதயத| ");
INSERT INTO santam_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","அத² தே ப்ரஸ்தா²ய ஸர்வ்வத்ர ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும்ʼ பீடி³தாந் ஸ்வஸ்தா²ந் கர்த்துஞ்ச க்³ராமேஷு ப்⁴ரமிதும்ʼ ப்ராரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ஏதர்ஹி ஹேரோத்³ ராஜா யீஸோ²​: ஸர்வ்வகர்ம்மணாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வா ப்⁴ருʼஸ²முத்³விவிஜே ");
INSERT INTO santam_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","யத​: கேசிதூ³சுர்யோஹந் ஸ்²மஸா²நாது³த³திஷ்ட²த்| கேசிதூ³சு​:, ஏலியோ த³ர்ஸ²நம்ʼ த³த்தவாந்; ஏவமந்யலோகா ஊசு​: பூர்வ்வீய​: கஸ்²சித்³ ப⁴விஷ்யத்³வாதீ³ ஸமுத்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","கிந்து ஹேரோது³வாச யோஹந​: ஸி²ரோ(அ)ஹமசி²நத³ம் இதா³நீம்ʼ யஸ்யேத்³ருʼக்கர்ம்மணாம்ʼ வார்த்தாம்ʼ ப்ராப்நோமி ஸ க​:? அத² ஸ தம்ʼ த்³ரஷ்டும் ஐச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","அநந்தரம்ʼ ப்ரேரிதா​: ப்ரத்யாக³த்ய யாநி யாநி கர்ம்மாணி சக்ருஸ்தாநி யீஸ²வே கத²யாமாஸு​: தத​: ஸ தாந் பை³த்ஸைதா³நாமகநக³ரஸ்ய விஜநம்ʼ ஸ்தா²நம்ʼ நீத்வா கு³ப்தம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","பஸ்²சால் லோகாஸ்தத்³ விதி³த்வா தஸ்ய பஸ்²சாத்³ யயு​:; தத​: ஸ தாந் நயந் ஈஸ்²வரீயராஜ்யஸ்ய ப்ரஸங்க³முக்தவாந், யேஷாம்ʼ சிகித்ஸயா ப்ரயோஜநம் ஆஸீத் தாந் ஸ்வஸ்தா²ந் சகார ச| ");
INSERT INTO santam_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","அபரஞ்ச தி³வாவஸந்நே ஸதி த்³வாத³ஸ²ஸி²ஷ்யா யீஸோ²ரந்திகம் ஏத்ய கத²யாமாஸு​:, வயமத்ர ப்ராந்தரஸ்தா²நே திஷ்டா²ம​:, ததோ நக³ராணி க்³ராமாணி க³த்வா வாஸஸ்தா²நாநி ப்ராப்ய ப⁴க்ஷ்யத்³ரவ்யாணி க்ரேதும்ʼ ஜநநிவஹம்ʼ ப⁴வாந் விஸ்ருʼஜது| ");
INSERT INTO santam_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ததா³ ஸ உவாச, யூயமேவ தாந் பே⁴ஜயத்⁴வம்ʼ; ததஸ்தே ப்ரோசுரஸ்மாகம்ʼ நிகடே கேவலம்ʼ பஞ்ச பூபா த்³வௌ மத்ஸ்யௌ ச வித்³யந்தே, அதஏவ ஸ்தா²நாந்தரம் இத்வா நிமித்தமேதேஷாம்ʼ ப⁴க்ஷ்யத்³ரவ்யேஷு ந க்ரீதேஷு ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","தத்ர ப்ராயேண பஞ்சஸஹஸ்ராணி புருஷா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ததா³ ஸ ஸி²ஷ்யாந் ஜகா³த³ பஞ்சாஸ²த் பஞ்சாஸ²ஜ்ஜநை​: பம்ʼக்தீக்ருʼத்ய தாநுபவேஸ²யத, தஸ்மாத் தே தத³நுஸாரேண ஸர்வ்வலோகாநுபவேஸ²யாபாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","தத​: ஸ தாந் பஞ்ச பூபாந் மீநத்³வயஞ்ச க்³ருʼஹீத்வா ஸ்வர்க³ம்ʼ விலோக்யேஸ்²வரகு³ணாந் கீர்த்தயாஞ்சக்ரே ப⁴ங்க்தா ச லோகேப்⁴ய​: பரிவேஷணார்த²ம்ʼ ஸி²ஷ்யேஷு ஸமர்பயாம்ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","தத​: ஸர்வ்வே பு⁴க்த்வா த்ருʼப்திம்ʼ க³தா அவஸி²ஷ்டாநாஞ்ச த்³வாத³ஸ² ட³ல்லகாந் ஸம்ʼஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","அதை²கதா³ நிர்ஜநே ஸி²ஷ்யை​: ஸஹ ப்ரார்த²நாகாலே தாந் பப்ரச்ச², லோகா மாம்ʼ கம்ʼ வத³ந்தி? ");
INSERT INTO santam_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ததஸ்தே ப்ராசு​:, த்வாம்ʼ யோஹந்மஜ்ஜகம்ʼ வத³ந்தி; கேசித் த்வாம் ஏலியம்ʼ வத³ந்தி, பூர்வ்வகாலிக​: கஸ்²சித்³ ப⁴விஷ்யத்³வாதீ³ ஸ்²மஸா²நாத்³ உத³திஷ்ட²த்³ இத்யபி கேசித்³ வத³ந்தி| ");
INSERT INTO santam_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ததா³ ஸ உவாச, யூயம்ʼ மாம்ʼ கம்ʼ வத³த²? தத​: பிதர உக்தவாந் த்வம் ஈஸ்²வராபி⁴ஷிக்த​: புருஷ​:| ");
INSERT INTO santam_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ததா³ ஸ தாந் த்³ருʼட⁴மாதி³தே³ஸ², கதா²மேதாம்ʼ கஸ்மைசித³பி மா கத²யத| ");
INSERT INTO santam_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ஸ புநருவாச, மநுஷ்யபுத்ரேண வஹுயாதநா போ⁴க்தவ்யா​: ப்ராசீநலோகை​: ப்ரதா⁴நயாஜகைரத்⁴யாபகைஸ்²ச ஸோவஜ்ஞாய ஹந்தவ்ய​: கிந்து த்ருʼதீயதி³வஸே ஸ்²மஸா²நாத் தேநோத்தா²தவ்யம்| ");
INSERT INTO santam_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","அபரம்ʼ ஸ ஸர்வ்வாநுவாச, கஸ்²சித்³ யதி³ மம பஸ்²சாத்³ க³ந்தும்ʼ வாஞ்ச²தி தர்ஹி ஸ ஸ்வம்ʼ தா³ம்யது, தி³நே தி³நே க்ருஸ²ம்ʼ க்³ருʼஹீத்வா ச மம பஸ்²சாதா³க³ச்ச²து| ");
INSERT INTO santam_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","யதோ ய​: கஸ்²சித் ஸ்வப்ராணாந் ரிரக்ஷிஷதி ஸ தாந் ஹாரயிஷ்யதி, ய​: கஸ்²சிந் மத³ர்த²ம்ʼ ப்ராணாந் ஹாரயிஷ்யதி ஸ தாந் ரக்ஷிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","கஸ்²சித்³ யதி³ ஸர்வ்வம்ʼ ஜக³த் ப்ராப்நோதி கிந்து ஸ்வப்ராணாந் ஹாரயதி ஸ்வயம்ʼ விநஸ்²யதி ச தர்ஹி தஸ்ய கோ லாப⁴​:? ");
INSERT INTO santam_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","புந ர்ய​: கஸ்²சிந் மாம்ʼ மம வாக்யம்ʼ வா லஜ்ஜாஸ்பத³ம்ʼ ஜாநாதி மநுஷ்யபுத்ரோ யதா³ ஸ்வஸ்ய பிதுஸ்²ச பவித்ராணாம்ʼ தூ³தாநாஞ்ச தேஜோபி⁴​: பரிவேஷ்டித ஆக³மிஷ்யதி ததா³ ஸோபி தம்ʼ லஜ்ஜாஸ்பத³ம்ʼ ஜ்ஞாஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","கிந்து யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, ஈஸ்²வரீயராஜத்வம்ʼ ந த்³ருʼஷ்டவா ம்ருʼத்யும்ʼ நாஸ்வாதி³ஷ்யந்தே, ஏதாத்³ருʼஸா²​: கியந்தோ லோகா அத்ர ஸ்த²நே(அ)பி த³ண்டா³யமாநா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ஏததா³க்²யாநகத²நாத் பரம்ʼ ப்ராயேணாஷ்டஸு தி³நேஷு க³தேஷு ஸ பிதரம்ʼ யோஹநம்ʼ யாகூப³ஞ்ச க்³ருʼஹீத்வா ப்ரார்த²யிதும்ʼ பர்வ்வதமேகம்ʼ ஸமாருரோஹ| ");
INSERT INTO santam_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","அத² தஸ்ய ப்ரார்த²நகாலே தஸ்ய முகா²க்ருʼதிரந்யரூபா ஜாதா, ததீ³யம்ʼ வஸ்த்ரமுஜ்ஜ்வலஸு²க்லம்ʼ ஜாதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","அபரஞ்ச மூஸா ஏலியஸ்²சோபௌ⁴ தேஜஸ்விநௌ த்³ருʼஷ்டௌ ");
INSERT INTO santam_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","தௌ தேந யிரூஸா²லம்புரே யோ ம்ருʼத்யு​: ஸாதி⁴ஷ்யதே ததீ³யாம்ʼ கதா²ம்ʼ தேந ஸார்த்³த⁴ம்ʼ கத²யிதும் ஆரேபா⁴தே| ");
INSERT INTO santam_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ததா³ பிதராத³ய​: ஸ்வஸ்ய ஸங்கி³நோ நித்³ரயாக்ருʼஷ்டா ஆஸந் கிந்து ஜாக³ரித்வா தஸ்ய தேஜஸ்தேந ஸார்த்³த⁴ம் உத்திஷ்ட²ந்தௌ ஜநௌ ச த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","அத² தயோருப⁴யோ ர்க³மநகாலே பிதரோ யீஸு²ம்ʼ ப³பா⁴ஷே, ஹே கு³ரோ(அ)ஸ்மாகம்ʼ ஸ்தா²நே(அ)ஸ்மிந் ஸ்தி²தி​: ஸு²பா⁴, தத ஏகா த்வத³ர்தா², ஏகா மூஸார்தா², ஏகா ஏலியார்தா², இதி திஸ்ர​: குட்யோஸ்மாபி⁴ ர்நிர்ம்மீயந்தாம்ʼ, இமாம்ʼ கதா²ம்ʼ ஸ ந விவிச்ய கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","அபரஞ்ச தத்³வாக்யவத³நகாலே பயோத³ ஏக ஆக³த்ய தேஷாமுபரி சா²யாம்ʼ சகார, ததஸ்தந்மத்⁴யே தயோ​: ப்ரவேஸா²த் தே ஸ²ஸ²ங்கிரே| ");
INSERT INTO santam_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ததா³ தஸ்மாத் பயோதா³த்³ இயமாகாஸீ²யா வாணீ நிர்ஜகா³ம, மமாயம்ʼ ப்ரிய​: புத்ர ஏதஸ்ய கதா²யாம்ʼ மநோ நித⁴த்த| ");
INSERT INTO santam_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","இதி ஸ²ப்³தே³ ஜாதே தே யீஸு²மேகாகிநம்ʼ த³த்³ருʼஸு²​: கிந்து தே ததா³நீம்ʼ தஸ்ய த³ர்ஸ²நஸ்ய வாசமேகாமபி நோக்த்வா மந​:ஸு ஸ்தா²பயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","பரே(அ)ஹநி தேஷு தஸ்மாச்சை²லாத்³ அவரூடே⁴ஷு தம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ ப³ஹவோ லோகா ஆஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","தேஷாம்ʼ மத்⁴யாத்³ ஏகோ ஜந உச்சைருவாச, ஹே கு³ரோ அஹம்ʼ விநயம்ʼ கரோமி மம புத்ரம்ʼ ப்ரதி க்ருʼபாத்³ருʼஷ்டிம்ʼ கரோது, மம ஸ ஏவைக​: புத்ர​:| ");
INSERT INTO santam_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","பூ⁴தேந த்⁴ருʼத​: ஸந் ஸம்ʼ ப்ரஸப⁴ம்ʼ சீச்ச²ப்³த³ம்ʼ கரோதி தந்முகா²த் பே²ணா நிர்க³ச்ச²ந்தி ச, பூ⁴த இத்த²ம்ʼ விதா³ர்ய்ய க்லிஷ்ட்வா ப்ராயஸ²ஸ்தம்ʼ ந த்யஜதி| ");
INSERT INTO santam_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","தஸ்மாத் தம்ʼ பூ⁴தம்ʼ த்யாஜயிதும்ʼ தவ ஸி²ஷ்யஸமீபே ந்யவேத³யம்ʼ கிந்து தே ந ஸே²கு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ததா³ யீஸு²ரவாதீ³த், ரே ஆவிஸ்²வாஸிந் விபத²கா³மிந் வம்ʼஸ² கதிகாலாந் யுஷ்மாபி⁴​: ஸஹ ஸ்தா²ஸ்யாம்யஹம்ʼ யுஷ்மாகம் ஆசரணாநி ச ஸஹிஷ்யே? தவ புத்ரமிஹாநய| ");
INSERT INTO santam_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ததஸ்தஸ்மிந்நாக³தமாத்ரே பூ⁴தஸ்தம்ʼ பூ⁴மௌ பாதயித்வா வித³தா³ர; ததா³ யீஸு²ஸ்தமமேத்⁴யம்ʼ பூ⁴தம்ʼ தர்ஜயித்வா பா³லகம்ʼ ஸ்வஸ்த²ம்ʼ க்ருʼத்வா தஸ்ய பிதரி ஸமர்பயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ஈஸ்²வரஸ்ய மஹாஸ²க்திம் இமாம்ʼ விலோக்ய ஸர்வ்வே சமச்சக்ரு​:; இத்த²ம்ʼ யீஸோ²​: ஸர்வ்வாபி⁴​: க்ரியாபி⁴​: ஸர்வ்வைர்லோகைராஸ்²சர்ய்யே மந்யமாநே ஸதி ஸ ஸி²ஷ்யாந் ப³பா⁴ஷே, ");
INSERT INTO santam_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","கதே²யம்ʼ யுஷ்மாகம்ʼ கர்ணேஷு ப்ரவிஸ²து, மநுஷ்யபுத்ரோ மநுஷ்யாணாம்ʼ கரேஷு ஸமர்பயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","கிந்து தே தாம்ʼ கதா²ம்ʼ ந பு³பு³தி⁴ரே, ஸ்பஷ்டத்வாபா⁴வாத் தஸ்யா அபி⁴ப்ராயஸ்தேஷாம்ʼ போ³த⁴க³ம்யோ ந ப³பூ⁴வ; தஸ்யா ஆஸ²ய​: க இத்யபி தே ப⁴யாத் ப்ரஷ்டும்ʼ ந ஸே²கு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","தத³நந்தரம்ʼ தேஷாம்ʼ மத்⁴யே க​: ஸ்²ரேஷ்ட²​: கதா²மேதாம்ʼ க்³ருʼஹீத்வா தே மிதோ² விவாத³ம்ʼ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ததோ யீஸு²ஸ்தேஷாம்ʼ மநோபி⁴ப்ராயம்ʼ விதி³த்வா பா³லகமேகம்ʼ க்³ருʼஹீத்வா ஸ்வஸ்ய நிகடே ஸ்தா²பயித்வா தாந் ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","யோ ஜநோ மம நாம்நாஸ்ய பா³லாஸ்யாதித்²யம்ʼ வித³தா⁴தி ஸ மமாதித்²யம்ʼ வித³தா⁴தி, யஸ்²ச மமாதித்²யம்ʼ வித³தா⁴தி ஸ மம ப்ரேரகஸ்யாதித்²யம்ʼ வித³தா⁴தி, யுஷ்மாகம்ʼ மத்⁴யேய​: ஸ்வம்ʼ ஸர்வ்வஸ்மாத் க்ஷுத்³ரம்ʼ ஜாநீதே ஸ ஏவ ஸ்²ரேஷ்டோ² ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","அபரஞ்ச யோஹந் வ்யாஜஹார ஹே ப்ரபே⁴ा தவ நாம்நா பூ⁴தாந் த்யாஜயந்தம்ʼ மாநுஷம் ஏகம்ʼ த்³ருʼஷ்டவந்தோ வயம்ʼ, கிந்த்வஸ்மாகம் அபஸ்²சாத்³ கா³மித்வாத் தம்ʼ ந்யஷேதா⁴ம்| ததா³நீம்ʼ யீஸு²ருவாச, ");
INSERT INTO santam_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","தம்ʼ மா நிஷேத⁴த, யதோ யோ ஜநோஸ்மாகம்ʼ ந விபக்ஷ​: ஸ ஏவாஸ்மாகம்ʼ ஸபக்ஷோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","அநந்தரம்ʼ தஸ்யாரோஹணஸமய உபஸ்தி²தே ஸ ஸ்தி²ரசேதா யிரூஸா²லமம்ʼ ப்ரதி யாத்ராம்ʼ கர்த்தும்ʼ நிஸ்²சித்யாக்³ரே தூ³தாந் ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","தஸ்மாத் தே க³த்வா தஸ்ய ப்ரயோஜநீயத்³ரவ்யாணி ஸம்ʼக்³ரஹீதும்ʼ ஸோ²மிரோணீயாநாம்ʼ க்³ராமம்ʼ ப்ரவிவிஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","கிந்து ஸ யிரூஸா²லமம்ʼ நக³ரம்ʼ யாதி ததோ ஹேதோ ர்லோகாஸ்தஸ்யாதித்²யம்ʼ ந சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","அதஏவ யாகூப்³யோஹநௌ தஸ்ய ஸி²ஷ்யௌ தத்³ த்³ருʼஷ்ட்வா ஜக³த³து​:, ஹே ப்ரபோ⁴ ஏலியோ யதா² சகார ததா² வயமபி கிம்ʼ க³க³ணாத்³ ஆக³ந்தும் ஏதாந் ப⁴ஸ்மீகர்த்துஞ்ச வஹ்நிமாஜ்ஞாபயாம​:? ப⁴வாந் கிமிச்ச²தி? ");
INSERT INTO santam_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","கிந்து ஸ முக²ம்ʼ பராவர்த்ய தாந் தர்ஜயித்வா க³தி³தவாந் யுஷ்மாகம்ʼ மநோபா⁴வ​: க​:, இதி யூயம்ʼ ந ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","மநுஜஸுதோ மநுஜாநாம்ʼ ப்ராணாந் நாஸ²யிதும்ʼ நாக³ச்ச²த், கிந்து ரக்ஷிதும் ஆக³ச்ச²த்| பஸ்²சாத்³ இதரக்³ராமம்ʼ தே யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","தத³நந்தரம்ʼ பதி² க³மநகாலே ஜந ஏகஸ்தம்ʼ ப³பா⁴ஷே, ஹே ப்ரபோ⁴ ப⁴வாந் யத்ர யாதி ப⁴வதா ஸஹாஹமபி தத்ர யாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ததா³நீம்ʼ யீஸு²ஸ்தமுவாச, கோ³மாயூநாம்ʼ க³ர்த்தா ஆஸதே, விஹாயஸீயவிஹகா³ाநாம்ʼ நீடா³நி ச ஸந்தி, கிந்து மாநவதநயஸ்ய ஸி²ர​: ஸ்தா²பயிதும்ʼ ஸ்தா²நம்ʼ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","தத​: பரம்ʼ ஸ இதரஜநம்ʼ ஜகா³த³, த்வம்ʼ மம பஸ்²சாத்³ ஏஹி; தத​: ஸ உவாச, ஹே ப்ரபோ⁴ பூர்வ்வம்ʼ பிதரம்ʼ ஸ்²மஸா²நே ஸ்தா²பயிதும்ʼ மாமாதி³ஸ²து| ");
INSERT INTO santam_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ததா³ யீஸு²ருவாச, ம்ருʼதா ம்ருʼதாந் ஸ்²மஸா²நே ஸ்தா²பயந்து கிந்து த்வம்ʼ க³த்வேஸ்²வரீயராஜ்யஸ்ய கதா²ம்ʼ ப்ரசாரய| ");
INSERT INTO santam_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ததோந்ய​: கத²யாமாஸ, ஹே ப்ரபோ⁴ மயாபி ப⁴வத​: பஸ்²சாத்³ க³ம்ʼஸ்யதே, கிந்து பூர்வ்வம்ʼ மம நிவேஸ²நஸ்ய பரிஜநாநாம் அநுமதிம்ʼ க்³ரஹீதும் அஹமாதி³ஸ்²யை ப⁴வதா| ");
INSERT INTO santam_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ததா³நீம்ʼ யீஸு²ஸ்தம்ʼ ப்ரோக்தவாந், யோ ஜநோ லாங்க³லே கரமர்பயித்வா பஸ்²சாத் பஸ்²யதி ஸ ஈஸ்²வரீயராஜ்யம்ʼ நார்ஹதி| ");
INSERT INTO santam_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","தத​: பரம்ʼ ப்ரபு⁴ரபராந் ஸப்ததிஸி²ஷ்யாந் நியுஜ்ய ஸ்வயம்ʼ யாநி நக³ராணி யாநி ஸ்தா²நாநி ச க³மிஷ்யதி தாநி நக³ராணி தாநி ஸ்தா²நாநி ச ப்ரதி த்³வௌ த்³வௌ ஜநௌ ப்ரஹிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","தேப்⁴ய​: கத²யாமாஸ ச ஸ²ஸ்யாநி ப³ஹூநீதி ஸத்யம்ʼ கிந்து சே²த³கா அல்பே; தஸ்மாத்³தே⁴தோ​: ஸ²ஸ்யக்ஷேத்ரே சே²த³காந் அபராநபி ப்ரேஷயிதும்ʼ க்ஷேத்ரஸ்வாமிநம்ʼ ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","யூயம்ʼ யாத, பஸ்²யத, வ்ருʼகாணாம்ʼ மத்⁴யே மேஷஸா²வகாநிவ யுஷ்மாந் ப்ரஹிணோமி| ");
INSERT INTO santam_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","யூயம்ʼ க்ஷுத்³ரம்ʼ மஹத்³ வா வஸநஸம்புடகம்ʼ பாது³காஸ்²ச மா க்³ருʼஹ்லீத, மார்க³மத்⁴யே கமபி மா நமத ச| ");
INSERT INTO santam_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","அபரஞ்ச யூயம்ʼ யத்³ யத் நிவேஸ²நம்ʼ ப்ரவிஸ²த² தத்ர நிவேஸ²நஸ்யாஸ்ய மங்க³லம்ʼ பூ⁴யாதி³தி வாக்யம்ʼ ப்ரத²மம்ʼ வத³த| ");
INSERT INTO santam_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","தஸ்மாத் தஸ்மிந் நிவேஸ²நே யதி³ மங்க³லபாத்ரம்ʼ ஸ்தா²ஸ்யதி தர்ஹி தந்மங்க³லம்ʼ தஸ்ய ப⁴விஷ்யதி, நோசேத் யுஷ்மாந் ப்ரதி பராவர்த்திஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","அபரஞ்ச தே யத்கிஞ்சித்³ தா³ஸ்யந்தி ததே³வ பு⁴க்த்வா பீத்வா தஸ்மிந்நிவேஸ²நே ஸ்தா²ஸ்யத²; யத​: கர்ம்மகாரீ ஜநோ ப்⁴ருʼதிம் அர்ஹதி; க்³ருʼஹாத்³ க்³ருʼஹம்ʼ மா யாஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","அந்யச்ச யுஷ்மாஸு கிமபி நக³ரம்ʼ ப்ரவிஷ்டேஷு லோகா யதி³ யுஷ்மாகம் ஆதித்²யம்ʼ கரிஷ்யந்தி, தர்ஹி யத் கா²த்³யம் உபஸ்தா²ஸ்யந்தி ததே³வ கா²தி³ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","தந்நக³ரஸ்தா²ந் ரோகி³ண​: ஸ்வஸ்தா²ந் கரிஷ்யத², ஈஸ்²வரீயம்ʼ ராஜ்யம்ʼ யுஷ்மாகம் அந்திகம் ஆக³மத் கதா²மேதாஞ்ச ப்ரசாரயிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","கிந்து கிமபி புரம்ʼ யுஷ்மாஸு ப்ரவிஷ்டேஷு லோகா யதி³ யுஷ்மாகம் ஆதித்²யம்ʼ ந கரிஷ்யந்தி, தர்ஹி தஸ்ய நக³ரஸ்ய பந்தா²நம்ʼ க³த்வா கதா²மேதாம்ʼ வதி³ஷ்யத², ");
INSERT INTO santam_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","யுஷ்மாகம்ʼ நக³ரீயா யா தூ⁴ல்யோ(அ)ஸ்மாஸு ஸமலக³ந் தா அபி யுஷ்மாகம்ʼ ப்ராதிகூல்யேந ஸாக்ஷ்யார்த²ம்ʼ ஸம்பாதயாம​:; ததா²பீஸ்²வரராஜ்யம்ʼ யுஷ்மாகம்ʼ ஸமீபம் ஆக³தம் இதி நிஸ்²சிதம்ʼ ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","அஹம்ʼ யுஷ்மப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி, விசாரதி³நே தஸ்ய நக³ரஸ்ய த³ஸா²த​: ஸிதோ³மோ த³ஸா² ஸஹ்யா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ஹா ஹா கோராஸீந் நக³ர, ஹா ஹா பை³த்ஸைதா³நக³ர யுவயோர்மத்⁴யே யாத்³ருʼஸா²நி ஆஸ்²சர்ய்யாணி கர்ம்மாண்யக்ரியந்த, தாநி கர்ம்மாணி யதி³ ஸோரஸீதோ³நோ ர்நக³ரயோரகாரிஷ்யந்த, ததா³ இதோ ப³ஹுதி³நபூர்வ்வம்ʼ தந்நிவாஸிந​: ஸ²ணவஸ்த்ராணி பரிதா⁴ய கா³த்ரேஷு ப⁴ஸ்ம விலிப்ய ஸமுபவிஸ்²ய ஸமகே²த்ஸ்யந்த| ");
INSERT INTO santam_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","அதோ விசாரதி³வஸே யுஷ்மாகம்ʼ த³ஸா²த​: ஸோரஸீதோ³ந்நிவாஸிநாம்ʼ த³ஸா² ஸஹ்யா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ஹே கப²ர்நாஹூம், த்வம்ʼ ஸ்வர்க³ம்ʼ யாவத்³ உந்நதா கிந்து நரகம்ʼ யாவத் ந்யக்³ப⁴விஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","யோ ஜநோ யுஷ்மாகம்ʼ வாக்யம்ʼ க்³ருʼஹ்லாதி ஸ மமைவ வாக்யம்ʼ க்³ருʼஹ்லாதி; கிஞ்ச யோ ஜநோ யுஷ்மாகம் அவஜ்ஞாம்ʼ கரோதி ஸ மமைவாவஜ்ஞாம்ʼ கரோதி; யோ ஜநோ மமாவஜ்ஞாம்ʼ கரோதி ச ஸ மத்ப்ரேரகஸ்யைவாவஜ்ஞாம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","அத² தே ஸப்ததிஸி²ஷ்யா ஆநந்தே³ந ப்ரத்யாக³த்ய கத²யாமாஸு​:, ஹே ப்ரபோ⁴ ப⁴வதோ நாம்நா பூ⁴தா அப்யஸ்மாகம்ʼ வஸீ²ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ததா³நீம்ʼ ஸ தாந் ஜகா³த³, வித்³யுதமிவ ஸ்வர்கா³த் பதந்தம்ʼ ஸை²தாநம் அத³ர்ஸ²ம்| ");
INSERT INTO santam_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","பஸ்²யத ஸர்பாந் வ்ருʼஸ்²சிகாந் ரிபோ​: ஸர்வ்வபராக்ரமாம்ʼஸ்²ச பத³தலை ர்த³லயிதும்ʼ யுஷ்மப்⁴யம்ʼ ஸ²க்திம்ʼ த³தா³மி தஸ்மாத்³ யுஷ்மாகம்ʼ காபி ஹாநி ர்ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","பூ⁴தா யுஷ்மாகம்ʼ வஸீ²ப⁴வந்தி, ஏதந்நிமித்தத் மா ஸமுல்லஸத, ஸ்வர்கே³ யுஷ்மாகம்ʼ நாமாநி லிகி²தாநி ஸந்தீதி நிமித்தம்ʼ ஸமுல்லஸத| ");
INSERT INTO santam_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","தத்³க⁴டிகாயாம்ʼ யீஸு² ர்மநஸி ஜாதாஹ்லாத³​: கத²யாமாஸ ஹே ஸ்வர்க³ப்ருʼதி²வ்யோரேகாதி⁴பதே பிதஸ்த்வம்ʼ ஜ்ஞாநவதாம்ʼ விது³ஷாஞ்ச லோகாநாம்ʼ புரஸ்தாத் ஸர்வ்வமேதத்³ அப்ரகாஸ்²ய பா³லகாநாம்ʼ புரஸ்தாத் ப்ராகாஸ²ய ஏதஸ்மாத்³தே⁴தோஸ்த்வாம்ʼ த⁴ந்யம்ʼ வதா³மி, ஹே பிதரித்த²ம்ʼ ப⁴வது யத்³ ஏததே³வ தவ கோ³சர உத்தமம்| ");
INSERT INTO santam_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","பித்ரா ஸர்வ்வாணி மயி ஸமர்பிதாநி பிதரம்ʼ விநா கோபி புத்ரம்ʼ ந ஜாநாதி கிஞ்ச புத்ரம்ʼ விநா யஸ்மை ஜநாய புத்ரஸ்தம்ʼ ப்ரகாஸி²தவாந் தஞ்ச விநா கோபி பிதரம்ʼ ந ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","தப​: பரம்ʼ ஸ ஸி²ஷ்யாந் ப்ரதி பராவ்ருʼத்ய கு³ப்தம்ʼ ஜகா³த³, யூயமேதாநி ஸர்வ்வாணி பஸ்²யத² ததோ யுஷ்மாகம்ʼ சக்ஷூம்ʼஷி த⁴ந்யாநி| ");
INSERT INTO santam_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","யுஷ்மாநஹம்ʼ வதா³மி, யூயம்ʼ யாநி ஸர்வ்வாணி பஸ்²யத² தாநி ப³ஹவோ ப⁴விஷ்யத்³வாதி³நோ பூ⁴பதயஸ்²ச த்³ரஷ்டுமிச்ச²ந்தோபி த்³ரஷ்டும்ʼ ந ப்ராப்நுவந், யுஷ்மாபி⁴ ர்யா யா​: கதா²ஸ்²ச ஸ்²ரூயந்தே தா​: ஸ்²ரோதுமிச்ச²ந்தோபி ஸ்²ரோதும்ʼ நாலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","அநந்தரம் ஏகோ வ்யவஸ்தா²பக உத்தா²ய தம்ʼ பரீக்ஷிதும்ʼ பப்ரச்ச², ஹே உபதே³ஸ²க அநந்தாயுஷ​: ப்ராப்தயே மயா கிம்ʼ கரணீயம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","யீஸு²​: ப்ரத்யுவாச, அத்ரார்தே² வ்யவஸ்தா²யாம்ʼ கிம்ʼ லிகி²தமஸ்தி? த்வம்ʼ கீத்³ருʼக் பட²ஸி? ");
INSERT INTO santam_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","தத​: ஸோவத³த், த்வம்ʼ ஸர்வ்வாந்த​:கரணை​: ஸர்வ்வப்ராணை​: ஸர்வ்வஸ²க்திபி⁴​: ஸர்வ்வசித்தைஸ்²ச ப்ரபௌ⁴ பரமேஸ்²வரே ப்ரேம குரு, ஸமீபவாஸிநி ஸ்வவத் ப்ரேம குரு ச| ");
INSERT INTO santam_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ததா³ ஸ கத²யாமாஸ, த்வம்ʼ யதா²ர்த²ம்ʼ ப்ரத்யவோச​:, இத்த²ம் ஆசர தேநைவ ஜீவிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","கிந்து ஸ ஜந​: ஸ்வம்ʼ நிர்த்³தோ³ஷம்ʼ ஜ்ஞாபயிதும்ʼ யீஸு²ம்ʼ பப்ரச்ச², மம ஸமீபவாஸீ க​:? ததோ யீஸு²​: ப்ரத்யுவாச, ");
INSERT INTO santam_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ஏகோ ஜநோ யிரூஸா²லம்புராத்³ யிரீஹோபுரம்ʼ யாதி, ஏதர்ஹி த³ஸ்யூநாம்ʼ கரேஷு பதிதே தே தஸ்ய வஸ்த்ராதி³கம்ʼ ஹ்ருʼதவந்த​: தமாஹத்ய ம்ருʼதப்ராயம்ʼ க்ருʼத்வா த்யக்த்வா யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","அகஸ்மாத்³ ஏகோ யாஜகஸ்தேந மார்கே³ண க³ச்ச²ந் தம்ʼ த்³ருʼஷ்ட்வா மார்கா³ந்யபார்ஸ்²வேந ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","இத்த²ம் ஏகோ லேவீயஸ்தத்ஸ்தா²நம்ʼ ப்ராப்ய தஸ்யாந்திகம்ʼ க³த்வா தம்ʼ விலோக்யாந்யேந பார்ஸ்²வேந ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","கிந்த்வேக​: ஸோ²மிரோணீயோ க³ச்ச²ந் தத்ஸ்தா²நம்ʼ ப்ராப்ய தம்ʼ த்³ருʼஷ்ட்வாத³யத| ");
INSERT INTO santam_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","தஸ்யாந்திகம்ʼ க³த்வா தஸ்ய க்ஷதேஷு தைலம்ʼ த்³ராக்ஷாரஸஞ்ச ப்ரக்ஷிப்ய க்ஷதாநி ப³த்³த்⁴வா நிஜவாஹநோபரி தமுபவேஸ்²ய ப்ரவாஸீயக்³ருʼஹம் ஆநீய தம்ʼ ஸிஷேவே| ");
INSERT INTO santam_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","பரஸ்மிந் தி³வஸே நிஜக³மநகாலே த்³வௌ முத்³ராபாதௌ³ தத்³க்³ருʼஹஸ்வாமிநே த³த்த்வாவத³த் ஜநமேநம்ʼ ஸேவஸ்வ தத்ர யோ(அ)தி⁴கோ வ்யயோ ப⁴விஷ்யதி தமஹம்ʼ புநராக³மநகாலே பரிஸோ²த்ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ஏஷாம்ʼ த்ரயாணாம்ʼ மத்⁴யே தஸ்ய த³ஸ்யுஹஸ்தபதிதஸ்ய ஜநஸ்ய ஸமீபவாஸீ க​:? த்வயா கிம்ʼ பு³த்⁴யதே? ");
INSERT INTO santam_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","தத​: ஸ வ்யவஸ்தா²பக​: கத²யாமாஸ யஸ்தஸ்மிந் த³யாம்ʼ சகார| ததா³ யீஸு²​: கத²யாமாஸ த்வமபி க³த்வா ததா²சர| ");
INSERT INTO santam_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","தத​: பரம்ʼ தே க³ச்ச²ந்த ஏகம்ʼ க்³ராமம்ʼ ப்ரவிவிஸு²​:; ததா³ மர்தா²நாமா ஸ்த்ரீ ஸ்வக்³ருʼஹே தஸ்யாதித்²யம்ʼ சகார| ");
INSERT INTO santam_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","தஸ்மாத் மரியம் நாமதே⁴யா தஸ்யா ப⁴கி³நீ யீஸோ²​: பத³ஸமீப உவவிஸ்²ய தஸ்யோபதே³ஸ²கதா²ம்ʼ ஸ்²ரோதுமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","கிந்து மர்தா² நாநாபரிசர்ய்யாயாம்ʼ வ்யக்³ரா ப³பூ⁴வ தஸ்மாத்³தே⁴தோஸ்தஸ்ய ஸமீபமாக³த்ய ப³பா⁴ஷே; ஹே ப்ரபோ⁴ மம ப⁴கி³நீ கேவலம்ʼ மமோபரி ஸர்வ்வகர்ம்மணாம்ʼ பா⁴ரம் அர்பிதவதீ தத்ர ப⁴வதா கிஞ்சித³பி ந மநோ நிதீ⁴யதே கிம்? மம ஸாஹாய்யம்ʼ கர்த்தும்ʼ ப⁴வாந் தாமாதி³ஸ²து| ");
INSERT INTO santam_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ததோ யீஸு²​: ப்ரத்யுவாச ஹே மர்தே² ஹே மர்தே², த்வம்ʼ நாநாகார்ய்யேஷு சிந்திதவதீ வ்யக்³ரா சாஸி, ");
INSERT INTO santam_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","கிந்து ப்ரயோஜநீயம் ஏகமாத்ரம் ஆஸ்தே| அபரஞ்ச யமுத்தமம்ʼ பா⁴க³ம்ʼ கோபி ஹர்த்தும்ʼ ந ஸ²க்நோதி ஸஏவ மரியமா வ்ருʼத​:| ");
INSERT INTO santam_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","அநந்தரம்ʼ ஸ கஸ்மிம்ʼஸ்²சித் ஸ்தா²நே ப்ரார்த²யத தத்ஸமாப்தௌ ஸத்யாம்ʼ தஸ்யைக​: ஸி²ஷ்யஸ்தம்ʼ ஜகா³த³ ஹே ப்ரபோ⁴ யோஹந் யதா² ஸ்வஸி²ஷ்யாந் ப்ரார்த²யிதும் உபதி³ஷ்டவாந் ததா² ப⁴வாநப்யஸ்மாந் உபதி³ஸ²து| ");
INSERT INTO santam_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","தஸ்மாத் ஸ கத²யாமாஸ, ப்ரார்த²நகாலே யூயம் இத்த²ம்ʼ கத²யத்⁴வம்ʼ, ஹே அஸ்மாகம்ʼ ஸ்வர்க³ஸ்த²பிதஸ்தவ நாம பூஜ்யம்ʼ ப⁴வது; தவ ராஜத்வம்ʼ ப⁴வது; ஸ்வர்கே³ யதா² ததா² ப்ருʼதி²வ்யாமபி தவேச்ச²யா ஸர்வ்வம்ʼ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ப்ரத்யஹம் அஸ்மாகம்ʼ ப்ரயோஜநீயம்ʼ போ⁴ஜ்யம்ʼ தே³ஹி| ");
INSERT INTO santam_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","யதா² வயம்ʼ ஸர்வ்வாந் அபராதி⁴ந​: க்ஷமாமஹே ததா² த்வமபி பாபாந்யஸ்மாகம்ʼ க்ஷமஸ்வ| அஸ்மாந் பரீக்ஷாம்ʼ மாநய கிந்து பாபாத்மநோ ரக்ஷ| ");
INSERT INTO santam_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","பஸ்²சாத் ஸோபரமபி கதி²தவாந் யதி³ யுஷ்மாகம்ʼ கஸ்யசித்³ ப³ந்து⁴ஸ்திஷ்ட²தி நிஸீ²தே² ச தஸ்ய ஸமீபம்ʼ ஸ க³த்வா வத³தி, ");
INSERT INTO santam_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ஹே ப³ந்தோ⁴ பதி²க ஏகோ ப³ந்து⁴ ர்மம நிவேஸ²நம் ஆயாத​: கிந்து தஸ்யாதித்²யம்ʼ கர்த்தும்ʼ மமாந்திகே கிமபி நாஸ்தி, அதஏவ பூபத்ரயம்ʼ மஹ்யம் ருʼணம்ʼ தே³ஹி; ");
INSERT INTO santam_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ததா³ ஸ யதி³ க்³ருʼஹமத்⁴யாத் ப்ரதிவத³தி மாம்ʼ மா க்லிஸா²ந, இதா³நீம்ʼ த்³வாரம்ʼ ருத்³த⁴ம்ʼ ஸ²யநே மயா ஸஹ பா³லகாஸ்²ச திஷ்ட²ந்தி துப்⁴யம்ʼ தா³தும் உத்தா²தும்ʼ ந ஸ²க்நோமி, ");
INSERT INTO santam_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","தர்ஹி யுஷ்மாநஹம்ʼ வதா³மி, ஸ யதி³ மித்ரதயா தஸ்மை கிமபி தா³தும்ʼ நோத்திஷ்ட²தி ததா²பி வாரம்ʼ வாரம்ʼ ப்ரார்த²நாத உத்தா²பித​: ஸந் யஸ்மிந் தஸ்ய ப்ரயோஜநம்ʼ ததே³வ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","அத​: காரணாத் கத²யாமி, யாசத்⁴வம்ʼ ததோ யுஷ்மப்⁴யம்ʼ தா³ஸ்யதே, ம்ருʼக³யத்⁴வம்ʼ தத உத்³தே³ஸ²ம்ʼ ப்ராப்ஸ்யத², த்³வாரம் ஆஹத ததோ யுஷ்மப்⁴யம்ʼ த்³வாரம்ʼ மோக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","யோ யாசதே ஸ ப்ராப்நோதி, யோ ம்ருʼக³யதே ஸ ஏவோத்³தே³ஸ²ம்ʼ ப்ராப்நோதி, யோ த்³வாரம் ஆஹந்தி தத³ர்த²ம்ʼ த்³வாரம்ʼ மோச்யதே| ");
INSERT INTO santam_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","புத்ரேண பூபே யாசிதே தஸ்மை பாஷாணம்ʼ த³தா³தி வா மத்ஸ்யே யாசிதே தஸ்மை ஸர்பம்ʼ த³தா³தி ");
INSERT INTO santam_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","வா அண்டே³ யாசிதே தஸ்மை வ்ருʼஸ்²சிகம்ʼ த³தா³தி யுஷ்மாகம்ʼ மத்⁴யே க ஏதாத்³ருʼஸ²​: பிதாஸ்தே? ");
INSERT INTO santam_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","தஸ்மாதே³வ யூயமப⁴த்³ரா அபி யதி³ ஸ்வஸ்வபா³லகேப்⁴ய உத்தமாநி த்³ரவ்யாணி தா³தும்ʼ ஜாநீத² தர்ஹ்யஸ்மாகம்ʼ ஸ்வர்க³ஸ்த²​: பிதா நிஜயாசகேப்⁴ய​: கிம்ʼ பவித்ரம் ஆத்மாநம்ʼ ந தா³ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","அநந்தரம்ʼ யீஸு²நா கஸ்மாச்சித்³ ஏகஸ்மிந் மூகபூ⁴தே த்யாஜிதே ஸதி ஸ பூ⁴தத்யக்தோ மாநுஷோ வாக்யம்ʼ வக்தும் ஆரேபே⁴; ததோ லோகா​: ஸகலா ஆஸ்²சர்ய்யம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","கிந்து தேஷாம்ʼ கேசிதூ³சு ர்ஜநோயம்ʼ பா³லஸிபூ³பா³ அர்தா²த்³ பூ⁴தராஜேந பூ⁴தாந் த்யாஜயதி| ");
INSERT INTO santam_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","தம்ʼ பரீக்ஷிதும்ʼ கேசித்³ ஆகாஸீ²யம் ஏகம்ʼ சிஹ்நம்ʼ த³ர்ஸ²யிதும்ʼ தம்ʼ ப்ரார்த²யாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ததா³ ஸ தேஷாம்ʼ மந​:கல்பநாம்ʼ ஜ்ஞாத்வா கத²யாமாஸ, கஸ்யசித்³ ராஜ்யஸ்ய லோகா யதி³ பரஸ்பரம்ʼ விருந்த⁴ந்தி தர்ஹி தத்³ ராஜ்யம் நஸ்²யதி; கேசித்³ க்³ருʼஹஸ்தா² யதி³ பரஸ்பரம்ʼ விருந்த⁴ந்தி தர்ஹி தேபி நஸ்²யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ததை²வ ஸை²தாநபி ஸ்வலோகாந் யதி³ விருணத்³தி⁴ ததா³ தஸ்ய ராஜ்யம்ʼ கத²ம்ʼ ஸ்தா²ஸ்யதி? பா³லஸிபூ³பா³ஹம்ʼ பூ⁴தாந் த்யாஜயாமி யூயமிதி வத³த²| ");
INSERT INTO santam_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","யத்³யஹம்ʼ பா³லஸிபூ³பா³ பூ⁴தாந் த்யாஜயாமி தர்ஹி யுஷ்மாகம்ʼ ஸந்தாநா​: கேந த்யாஜயந்தி? தஸ்மாத் தஏவ கதா²யா ஏதஸ்யா விசாரயிதாரோ ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","கிந்து யத்³யஹம் ஈஸ்²வரஸ்ய பராக்ரமேண பூ⁴தாந் த்யாஜயாமி தர்ஹி யுஷ்மாகம்ʼ நிகடம் ஈஸ்²வரஸ்ய ராஜ்யமவஸ்²யம் உபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ப³லவாந் புமாந் ஸுஸஜ்ஜமாநோ யதிகாலம்ʼ நிஜாட்டாலிகாம்ʼ ரக்ஷதி ததிகாலம்ʼ தஸ்ய த்³ரவ்யம்ʼ நிருபத்³ரவம்ʼ திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","கிந்து தஸ்மாத்³ அதி⁴கப³ல​: கஸ்²சிதா³க³த்ய யதி³ தம்ʼ ஜயதி தர்ஹி யேஷு ஸ²ஸ்த்ராஸ்த்ரேஷு தஸ்ய விஸ்²வாஸ ஆஸீத் தாநி ஸர்வ்வாணி ஹ்ருʼத்வா தஸ்ய த்³ரவ்யாணி க்³ருʼஹ்லாதி| ");
INSERT INTO santam_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","அத​: காரணாத்³ யோ மம ஸபக்ஷோ ந ஸ விபக்ஷ​:, யோ மயா ஸஹ ந ஸம்ʼக்³ருʼஹ்லாதி ஸ விகிரதி| ");
INSERT INTO santam_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","அபரஞ்ச அமேத்⁴யபூ⁴தோ மாநுஷஸ்யாந்தர்நிர்க³த்ய ஸு²ஷ்கஸ்தா²நே ப்⁴ராந்த்வா விஸ்²ராமம்ʼ ம்ருʼக³யதே கிந்து ந ப்ராப்ய வத³தி மம யஸ்மாத்³ க்³ருʼஹாத்³ ஆக³தோஹம்ʼ புநஸ்தத்³ க்³ருʼஹம்ʼ பராவ்ருʼத்ய யாமி| ");
INSERT INTO santam_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ததோ க³த்வா தத்³ க்³ருʼஹம்ʼ மார்ஜிதம்ʼ ஸோ²பி⁴தஞ்ச த்³ருʼஷ்ட்வா ");
INSERT INTO santam_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","தத்க்ஷணம் அபக³த்ய ஸ்வஸ்மாத³பி து³ர்ம்மதீந் அபராந் ஸப்தபூ⁴தாந் ஸஹாநயதி தே ச தத்³க்³ருʼஹம்ʼ பவிஸ்²ய நிவஸந்தி| தஸ்மாத் தஸ்ய மநுஷ்யஸ்ய ப்ரத²மத³ஸா²த​: ஸே²ஷத³ஸா² து³​:க²தரா ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","அஸ்யா​: கதா²யா​: கத²நகாலே ஜநதாமத்⁴யஸ்தா² காசிந்நாரீ தமுச்சை​:ஸ்வரம்ʼ ப்ரோவாச, யா யோஷித் த்வாம்ʼ க³ர்ப்³பே⁴(அ)தா⁴ரயத் ஸ்தந்யமபாயயச்ச ஸைவ த⁴ந்யா| ");
INSERT INTO santam_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","கிந்து ஸோகத²யத் யே பரமேஸ்²வரஸ்ய கதா²ம்ʼ ஸ்²ருத்வா தத³நுரூபம் ஆசரந்தி தஏவ த⁴ந்யா​:| ");
INSERT INTO santam_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","தத​: பரம்ʼ தஸ்யாந்திகே ப³ஹுலோகாநாம்ʼ ஸமாக³மே ஜாதே ஸ வக்துமாரேபே⁴, ஆது⁴நிகா து³ஷ்டலோகாஸ்²சிஹ்நம்ʼ த்³ரஷ்டுமிச்ச²ந்தி கிந்து யூநஸ்ப⁴விஷ்யத்³வாதி³நஸ்²சிஹ்நம்ʼ விநாந்யத் கிஞ்சிச்சிஹ்நம்ʼ தாந் ந த³ர்ஸ²யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","யூநஸ் து யதா² நீநிவீயலோகாநாம்ʼ ஸமீபே சிஹ்நரூபோப⁴வத் ததா² வித்³யமாநலோகாநாம் ஏஷாம்ʼ ஸமீபே மநுஷ்யபுத்ரோபி சிஹ்நரூபோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","விசாரஸமயே இதா³நீந்தநலோகாநாம்ʼ ப்ராதிகூல்யேந த³க்ஷிணதே³ஸீ²யா ராஜ்ஞீ ப்ரோத்தா²ய தாந் தோ³ஷிண​: கரிஷ்யதி, யத​: ஸா ராஜ்ஞீ ஸுலேமாந உபதே³ஸ²கதா²ம்ʼ ஸ்²ரோதும்ʼ ப்ருʼதி²வ்யா​: ஸீமாத ஆக³ச்ச²த் கிந்து பஸ்²யத ஸுலேமாநோபி கு³ருதர ஏகோ ஜநோ(அ)ஸ்மிந் ஸ்தா²நே வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","அபரஞ்ச விசாரஸமயே நீநிவீயலோகா அபி வர்த்தமாநகாலிகாநாம்ʼ லோகாநாம்ʼ வைபரீத்யேந ப்ரோத்தா²ய தாந் தோ³ஷிண​: கரிஷ்யந்தி, யதோ ஹேதோஸ்தே யூநஸோ வாக்யாத் சித்தாநி பரிவர்த்தயாமாஸு​: கிந்து பஸ்²யத யூநஸோதிகு³ருதர ஏகோ ஜநோ(அ)ஸ்மிந் ஸ்தா²நே வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ப்ரதீ³பம்ʼ ப்ரஜ்வால்ய த்³ரோணஸ்யாத⁴​: குத்ராபி கு³ப்தஸ்தா²நே வா கோபி ந ஸ்தா²பயதி கிந்து க்³ருʼஹப்ரவேஸி²ப்⁴யோ தீ³ப்திம்ʼ தா³தம்ʼ தீ³பாதா⁴ரோபர்ய்யேவ ஸ்தா²பயதி| ");
INSERT INTO santam_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","தே³ஹஸ்ய ப்ரதீ³பஸ்²சக்ஷுஸ்தஸ்மாதே³வ சக்ஷு ர்யதி³ ப்ரஸந்நம்ʼ ப⁴வதி தர்ஹி தவ ஸர்வ்வஸ²ரீரம்ʼ தீ³ப்திமத்³ ப⁴விஷ்யதி கிந்து சக்ஷு ர்யதி³ மலீமஸம்ʼ திஷ்ட²தி தர்ஹி ஸர்வ்வஸ²ரீரம்ʼ ஸாந்த⁴காரம்ʼ ஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","அஸ்மாத் காரணாத் தவாந்த​:ஸ்த²ம்ʼ ஜ்யோதி ர்யதா²ந்த⁴காரமயம்ʼ ந ப⁴வதி தத³ர்தே² ஸாவதா⁴நோ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","யத​: ஸ²ரீரஸ்ய குத்ராப்யம்ʼஸே² ஸாந்த⁴காரே ந ஜாதே ஸர்வ்வம்ʼ யதி³ தீ³ப்திமத் திஷ்ட²தி தர்ஹி துப்⁴யம்ʼ தீ³ப்திதா³யிப்ரோஜ்ஜ்வலந் ப்ரதீ³ப இவ தவ ஸவர்வஸ²ரீரம்ʼ தீ³ப்திமத்³ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ஏதத்கதா²யா​: கத²நகாலே பி²ருஸ்²யேகோ பே⁴ஜநாய தம்ʼ நிமந்த்ரயாமாஸ, தத​: ஸ க³த்வா போ⁴க்தும் உபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","கிந்து போ⁴ஜநாத் பூர்வ்வம்ʼ நாமாங்க்ஷீத் ஏதத்³ த்³ருʼஷ்ட்வா ஸ பி²ருஸ்²யாஸ்²சர்ய்யம்ʼ மேநே| ");
INSERT INTO santam_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ததா³ ப்ரபு⁴ஸ்தம்ʼ ப்ரோவாச யூயம்ʼ பி²ரூஸி²லோகா​: பாநபாத்ராணாம்ʼ போ⁴ஜநபாத்ராணாஞ்ச ப³ஹி​: பரிஷ்குருத² கிந்து யுஷ்மாகமந்த ர்தௌ³ராத்ம்யை ர்து³ஷ்க்ரியாபி⁴ஸ்²ச பரிபூர்ணம்ʼ திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ஹே ஸர்வ்வே நிர்போ³தா⁴ யோ ப³ஹி​: ஸஸர்ஜ ஸ ஏவ கிமந்த ர்ந ஸஸர்ஜ? ");
INSERT INTO santam_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","தத ஏவ யுஷ்மாபி⁴ரந்த​:கரணம்ʼ (ஈஸ்²வராய) நிவேத்³யதாம்ʼ தஸ்மிந் க்ருʼதே யுஷ்மாகம்ʼ ஸர்வ்வாணி ஸு²சிதாம்ʼ யாஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","கிந்து ஹந்த பி²ரூஸி²க³ணா யூயம்ʼ ந்யாயம் ஈஸ்²வரே ப்ரேம ச பரித்யஜ்ய போதி³நாயா அருதா³தீ³நாம்ʼ ஸர்வ்வேஷாம்ʼ ஸா²காநாஞ்ச த³ஸ²மாம்ʼஸா²ந் த³த்த² கிந்து ப்ரத²மம்ʼ பாலயித்வா ஸே²ஷஸ்யாலங்க⁴நம்ʼ யுஷ்மாகம் உசிதமாஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ஹா ஹா பி²ரூஸி²நோ யூயம்ʼ ப⁴ஜநகே³ஹே ப்ரோச்சாஸநே ஆபணேஷு ச நமஸ்காரேஷு ப்ரீயத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","வத கபடிநோ(அ)த்⁴யாபகா​: பி²ரூஸி²நஸ்²ச லோகாயத் ஸ்²மஸா²நம் அநுபலப்⁴ய தது³பரி க³ச்ச²ந்தி யூயம் தாத்³ருʼக³ப்ரகாஸி²தஸ்²மஸா²நவாத்³ ப⁴வத²| ");
INSERT INTO santam_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ததா³நீம்ʼ வ்யவஸ்தா²பகாநாம் ஏகா யீஸு²மவத³த், ஹே உபதே³ஸ²க வாக்யேநேத்³ருʼஸே²நாஸ்மாஸ்வபி தோ³ஷம் ஆரோபயஸி| ");
INSERT INTO santam_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","தத​: ஸ உவாச, ஹா ஹா வ்யவஸ்தா²பகா யூயம் மாநுஷாணாம் உபரி து³​:ஸஹ்யாந் பா⁴ராந் ந்யஸ்யத² கிந்து ஸ்வயம் ஏகாங்கு³ुல்யாபி தாந் பா⁴ராந் ந ஸ்ப்ருʼஸ²த²| ");
INSERT INTO santam_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ஹந்த யுஷ்மாகம்ʼ பூர்வ்வபுருஷா யாந் ப⁴விஷ்யத்³வாதி³நோ(அ)வதி⁴ஷுஸ்தேஷாம்ʼ ஸ்²மஸா²நாநி யூயம்ʼ நிர்ம்மாத²| ");
INSERT INTO santam_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","தேநைவ யூயம்ʼ ஸ்வபூர்வ்வபுருஷாணாம்ʼ கர்ம்மாணி ஸம்ʼமந்யத்⁴வே ததே³வ ஸப்ரமாணம்ʼ குருத² ச, யதஸ்தே தாநவதி⁴ஷு​: யூயம்ʼ தேஷாம்ʼ ஸ்²மஸா²நாநி நிர்ம்மாத²| ");
INSERT INTO santam_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","அதஏவ ஈஸ்²வரஸ்ய ஸா²ஸ்த்ரே ப்ரோக்தமஸ்தி தேஷாமந்திகே ப⁴விஷ்யத்³வாதி³ந​: ப்ரேரிதாம்ʼஸ்²ச ப்ரேஷயிஷ்யாமி ததஸ்தே தேஷாம்ʼ காம்ʼஸ்²சந ஹநிஷ்யந்தி காம்ʼஸ்²சந தாட³ஸ்²ஷ்யிந்தி| ");
INSERT INTO santam_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ஏதஸ்மாத் காரணாத் ஹாபி³ல​: ஸோ²ணிதபாதமாரப்⁴ய மந்தி³ரயஜ்ஞவேத்³யோ ர்மத்⁴யே ஹதஸ்ய ஸிக²ரியஸ்ய ரக்தபாதபர்ய்யந்தம்ʼ ");
INSERT INTO santam_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ஜக³த​: ஸ்ருʼஷ்டிமாரப்⁴ய ப்ருʼதி²வ்யாம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ யதிரக்தபாதா ஜாதாஸ்ததீநாம் அபராத⁴த³ண்டா³ ஏஷாம்ʼ வர்த்தமாநலோகாநாம்ʼ ப⁴விஷ்யந்தி, யுஷ்மாநஹம்ʼ நிஸ்²சிதம்ʼ வதா³மி ஸர்வ்வே த³ண்டா³ வம்ʼஸ²ஸ்யாஸ்ய ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ஹா ஹா வ்யவஸ்த²பகா யூயம்ʼ ஜ்ஞாநஸ்ய குஞ்சிகாம்ʼ ஹ்ருʼத்வா ஸ்வயம்ʼ ந ப்ரவிஷ்டா யே ப்ரவேஷ்டுஞ்ச ப்ரயாஸிநஸ்தாநபி ப்ரவேஷ்டும்ʼ வாரிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","இத்த²ம்ʼ கதா²கத²நாத்³ அத்⁴யாபகா​: பி²ரூஸி²நஸ்²ச ஸதர்கா​: ");
INSERT INTO santam_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ஸந்தஸ்தமபவதி³தும்ʼ தஸ்ய கதா²யா தோ³ஷம்ʼ த⁴ர்த்தமிச்ச²ந்தோ நாநாக்²யாநகத²நாய தம்ʼ ப்ரவர்த்தயிதும்ʼ கோபயிதுஞ்ச ப்ராரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ததா³நீம்ʼ லோகா​: ஸஹஸ்ரம்ʼ ஸஹஸ்ரம் ஆக³த்ய ஸமுபஸ்தி²தாஸ்தத ஏகைகோ (அ)ந்யேஷாமுபரி பதிதும் உபசக்ரமே; ததா³ யீஸு²​: ஸி²ஷ்யாந் ப³பா⁴ஷே, யூயம்ʼ பி²ரூஸி²நாம்ʼ கிண்வரூபகாபட்யே விஸே²ஷேண ஸாவதா⁴நாஸ்திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","யதோ யந்ந ப்ரகாஸ²யிஷ்யதே ததா³ச்ச²ந்நம்ʼ வஸ்து கிமபி நாஸ்தி; ததா² யந்ந ஜ்ஞாஸ்யதே தத்³ கு³ப்தம்ʼ வஸ்து கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","அந்த⁴காரே திஷ்ட²நதோ யா​: கதா² அகத²யத தா​: ஸர்வ்வா​: கதா² தீ³ப்தௌ ஸ்²ரோஷ்யந்தே நிர்ஜநே கர்ணே ச யத³கத²யத க்³ருʼஹப்ருʼஷ்டா²த் தத் ப்ரசாரயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ஹே ப³ந்த⁴வோ யுஷ்மாநஹம்ʼ வதா³மி, யே ஸ²ரீரஸ்ய நாஸ²ம்ʼ விநா கிமப்யபரம்ʼ கர்த்தும்ʼ ந ஸ²க்ருவந்தி தேப்⁴யோ மா பை⁴ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","தர்ஹி கஸ்மாத்³ பே⁴தவ்யம் இத்யஹம்ʼ வதா³மி, ய​: ஸ²ரீரம்ʼ நாஸ²யித்வா நரகம்ʼ நிக்ஷேப்தும்ʼ ஸ²க்நோதி தஸ்மாதே³வ ப⁴யம்ʼ குருத, புநரபி வதா³மி தஸ்மாதே³வ ப⁴யம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","பஞ்ச சடகபக்ஷிண​: கிம்ʼ த்³வாப்⁴யாம்ʼ தாம்ரக²ண்டா³ப்⁴யாம்ʼ ந விக்ரீயந்தே? ததா²பீஸ்²வரஸ்தேஷாம் ஏகமபி ந விஸ்மரதி| ");
INSERT INTO santam_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","யுஷ்மாகம்ʼ ஸி²ர​:கேஸா² அபி க³ணிதா​: ஸந்தி தஸ்மாத் மா விபீ⁴த ப³ஹுசடகபக்ஷிப்⁴யோபி யூயம்ʼ ப³ஹுமூல்யா​:| ");
INSERT INTO santam_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","அபரம்ʼ யுஷ்மப்⁴யம்ʼ கத²யாமி ய​: கஸ்²சிந் மாநுஷாணாம்ʼ ஸாக்ஷாந் மாம்ʼ ஸ்வீகரோதி மநுஷ்யபுத்ர ஈஸ்²வரதூ³தாநாம்ʼ ஸாக்ஷாத் தம்ʼ ஸ்வீகரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","கிந்து ய​: கஸ்²சிந்மாநுஷாணாம்ʼ ஸாக்ஷாந்மாம் அஸ்வீகரோதி தம் ஈஸ்²வரஸ்ய தூ³தாநாம்ʼ ஸாக்ஷாத்³ அஹம் அஸ்வீகரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","அந்யச்ச ய​: கஸ்²சிந் மநுஜஸுதஸ்ய நிந்தா³பா⁴வேந காஞ்சித் கதா²ம்ʼ கத²யதி தஸ்ய தத்பாபஸ்ய மோசநம்ʼ ப⁴விஷ்யதி கிந்து யதி³ கஸ்²சித் பவித்ரம் ஆத்மாநம்ʼ நிந்த³தி தர்ஹி தஸ்ய தத்பாபஸ்ய மோசநம்ʼ ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","யதா³ லோகா யுஷ்மாந் ப⁴ஜநகே³ஹம்ʼ விசாரகர்த்ருʼராஜ்யகர்த்ருʼணாம்ʼ ஸம்முக²ஞ்ச நேஷ்யந்தி ததா³ கேந ப்ரகாரேண கிமுத்தரம்ʼ வதி³ஷ்யத² கிம்ʼ கத²யிஷ்யத² சேத்யத்ர மா சிந்தயத; ");
INSERT INTO santam_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","யதோ யுஷ்மாபி⁴ர்யத்³ யத்³ வக்தவ்யம்ʼ தத் தஸ்மிந் ஸமயஏவ பவித்ர ஆத்மா யுஷ்மாந் ஸி²க்ஷயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","தத​: பரம்ʼ ஜநதாமத்⁴யஸ்த²​: கஸ்²சிஜ்ஜநஸ்தம்ʼ ஜகா³த³ ஹே கு³ரோ மயா ஸஹ பைத்ருʼகம்ʼ த⁴நம்ʼ விப⁴க்தும்ʼ மம ப்⁴ராதரமாஜ்ஞாபயது ப⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","கிந்து ஸ தமவத³த் ஹே மநுஷ்ய யுவயோ ர்விசாரம்ʼ விபா⁴க³ஞ்ச கர்த்தும்ʼ மாம்ʼ கோ நியுக்தவாந்? ");
INSERT INTO santam_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","அநந்தரம்ʼ ஸ லோகாநவத³த் லோபே⁴ ஸாவதா⁴நா​: ஸதர்காஸ்²ச திஷ்ட²த, யதோ ப³ஹுஸம்பத்திப்ராப்த்யா மநுஷ்யஸ்யாயு ர்ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","பஸ்²சாத்³ த்³ருʼஷ்டாந்தகதா²முத்தா²ப்ய கத²யாமாஸ, ஏகஸ்ய த⁴நிநோ பூ⁴மௌ ப³ஹூநி ஸ²ஸ்யாநி ஜாதாநி| ");
INSERT INTO santam_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","தத​: ஸ மநஸா சிந்தயித்வா கத²யாம்ப³பூ⁴வ மமைதாநி ஸமுத்பந்நாநி த்³ரவ்யாணி ஸ்தா²பயிதும்ʼ ஸ்தா²நம்ʼ நாஸ்தி கிம்ʼ கரிஷ்யாமி? ");
INSERT INTO santam_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ததோவத³த்³ இத்த²ம்ʼ கரிஷ்யாமி, மம ஸர்வ்வபா⁴ண்டா³கா³ராணி ப⁴ங்க்த்வா ப்³ருʼஹத்³பா⁴ண்டா³கா³ராணி நிர்ம்மாய தந்மத்⁴யே ஸர்வ்வப²லாநி த்³ரவ்யாணி ச ஸ்தா²பயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","அபரம்ʼ நிஜமநோ வதி³ஷ்யாமி, ஹே மநோ ப³ஹுவத்ஸரார்த²ம்ʼ நாநாத்³ரவ்யாணி ஸஞ்சிதாநி ஸந்தி விஸ்²ராமம்ʼ குரு பு⁴க்த்வா பீத்வா கௌதுகஞ்ச குரு| கிந்த்வீஸ்²வரஸ்தம் அவத³த், ");
INSERT INTO santam_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ரே நிர்போ³த⁴ அத்³ய ராத்ரௌ தவ ப்ராணாஸ்த்வத்தோ நேஷ்யந்தே தத ஏதாநி யாநி த்³ரவ்யாணி த்வயாஸாதி³தாநி தாநி கஸ்ய ப⁴விஷ்யந்தி? ");
INSERT INTO santam_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","அதஏவ ய​: கஸ்²சித்³ ஈஸ்²வரஸ்ய ஸமீபே த⁴நஸஞ்சயமக்ருʼத்வா கேவலம்ʼ ஸ்வநிகடே ஸஞ்சயம்ʼ கரோதி ஸோபி தாத்³ருʼஸ²​:| ");
INSERT INTO santam_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","அத² ஸ ஸி²ஷ்யேப்⁴ய​: கத²யாமாஸ, யுஷ்மாநஹம்ʼ வதா³மி, கிம்ʼ கா²தி³ஷ்யாம​:? கிம்ʼ பரிதா⁴ஸ்யாம​:? இத்யுக்த்வா ஜீவநஸ்ய ஸ²ரீரஸ்ய சார்த²ம்ʼ சிந்தாம்ʼ மா கார்ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ப⁴க்ஷ்யாஜ்ஜீவநம்ʼ பூ⁴ஷணாச்ச²ரீரஞ்ச ஸ்²ரேஷ்ட²ம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","காகபக்ஷிணாம்ʼ கார்ய்யம்ʼ விசாரயத, தே ந வபந்தி ஸ²ஸ்யாநி ச ந சி²ந்த³ந்தி, தேஷாம்ʼ பா⁴ண்டா³கா³ராணி ந ஸந்தி கோஷாஸ்²ச ந ஸந்தி, ததா²பீஸ்²வரஸ்தேப்⁴யோ ப⁴க்ஷ்யாணி த³தா³தி, யூயம்ʼ பக்ஷிப்⁴ய​: ஸ்²ரேஷ்ட²தரா ந கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","அபரஞ்ச பா⁴வயித்வா நிஜாயுஷ​: க்ஷணமாத்ரம்ʼ வர்த்³த⁴யிதும்ʼ ஸ²க்நோதி, ஏதாத்³ருʼஸோ² லாகோ யுஷ்மாகம்ʼ மத்⁴யே கோஸ்தி? ");
INSERT INTO santam_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","அதஏவ க்ஷுத்³ரம்ʼ கார்ய்யம்ʼ ஸாத⁴யிதும் அஸமர்தா² யூயம் அந்யஸ்மிந் கார்ய்யே குதோ பா⁴வயத²? ");
INSERT INTO santam_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","அந்யச்ச காம்பிலபுஷ்பம்ʼ கத²ம்ʼ வர்த்³த⁴தே ததா³பி விசாரயத, தத் கஞ்சந ஸ்²ரமம்ʼ ந கரோதி தந்தூம்ʼஸ்²ச ந ஜநயதி கிந்து யுஷ்மப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி ஸுலேமாந் ப³ஹ்வைஸ்²வர்ய்யாந்விதோபி புஷ்பஸ்யாஸ்ய ஸத்³ருʼஸோ² விபூ⁴ஷிதோ நாஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","அத்³ய க்ஷேத்ரே வர்த்தமாநம்ʼ ஸ்²வஸ்²சூல்ல்யாம்ʼ க்ஷேப்ஸ்யமாநம்ʼ யத் த்ருʼணம்ʼ, தஸ்மை யதீ³ஸ்²வர இத்த²ம்ʼ பூ⁴ஷயதி தர்ஹி ஹே அல்பப்ரத்யயிநோ யுஷ்மாந கிம்ʼ ந பரிதா⁴பயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","அதஏவ கிம்ʼ கா²தி³ஷ்யாம​:? கிம்ʼ பரிதா⁴ஸ்யாம​:? ஏதத³ர்த²ம்ʼ மா சேஷ்டத்⁴வம்ʼ மா ஸம்ʼதி³க்³த்⁴வஞ்ச| ");
INSERT INTO santam_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ஜக³தோ தே³வார்ச்சகா ஏதாநி ஸர்வ்வாணி சேஷ்டநதே; ஏஷு வஸ்துஷு யுஷ்மாகம்ʼ ப்ரயோஜநமாஸ்தே இதி யுஷ்மாகம்ʼ பிதா ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","அதஏவேஸ்²வரஸ்ய ராஜ்யார்த²ம்ʼ ஸசேஷ்டா ப⁴வத ததா² க்ருʼதே ஸர்வ்வாண்யேதாநி த்³ரவ்யாணி யுஷ்மப்⁴யம்ʼ ப்ரதா³யிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ஹே க்ஷுத்³ரமேஷவ்ரஜ யூயம்ʼ மா பை⁴ஷ்ட யுஷ்மப்⁴யம்ʼ ராஜ்யம்ʼ தா³தும்ʼ யுஷ்மாகம்ʼ பிது​: ஸம்மதிரஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","அதஏவ யுஷ்மாகம்ʼ யா யா ஸம்பத்திரஸ்தி தாம்ʼ தாம்ʼ விக்ரீய விதரத, யத் ஸ்தா²நம்ʼ சௌரா நாக³ச்ச²ந்தி, கீடாஸ்²ச ந க்ஷாயயந்தி தாத்³ருʼஸே² ஸ்வர்கே³ நிஜார்த²ம் அஜரே ஸம்புடகே (அ)க்ஷயம்ʼ த⁴நம்ʼ ஸஞ்சிநுத ச; ");
INSERT INTO santam_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","யதோ யத்ர யுஷ்மாகம்ʼ த⁴நம்ʼ வர்த்ததே தத்ரேவ யுஷ்மாகம்ʼ மந​:| ");
INSERT INTO santam_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","அபரஞ்ச யூயம்ʼ ப்ரதீ³பம்ʼ ஜ்வாலயித்வா ப³த்³த⁴கடயஸ்திஷ்ட²த; ");
INSERT INTO santam_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ப்ரபு⁴ ர்விவாஹாதா³க³த்ய யதை³வ த்³வாரமாஹந்தி ததை³வ த்³வாரம்ʼ மோசயிதும்ʼ யதா² ப்⁴ருʼத்யா அபேக்ஷ்ய திஷ்ட²ந்தி ததா² யூயமபி திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","யத​: ப்ரபு⁴ராக³த்ய யாந் தா³ஸாந் ஸசேதநாந் திஷ்ட²தோ த்³ரக்ஷ்யதி தஏவ த⁴ந்யா​:; அஹம்ʼ யுஷ்மாந் யதா²ர்த²ம்ʼ வதா³மி ப்ரபு⁴ஸ்தாந் போ⁴ஜநார்த²ம் உபவேஸ்²ய ஸ்வயம்ʼ ப³த்³த⁴கடி​: ஸமீபமேத்ய பரிவேஷயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","யதி³ த்³விதீயே த்ருʼதீயே வா ப்ரஹரே ஸமாக³த்ய ததை²வ பஸ்²யதி, தர்ஹி தஏவ தா³ஸா த⁴ந்யா​:| ");
INSERT INTO santam_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","அபரஞ்ச கஸ்மிந் க்ஷணே சௌரா ஆக³மிஷ்யந்தி இதி யதி³ க்³ருʼஹபதி ர்ஜ்ஞாதும்ʼ ஸ²க்நோதி ததா³வஸ்²யம்ʼ ஜாக்³ரந் நிஜக்³ருʼஹே ஸந்தி⁴ம்ʼ கர்த்தயிதும்ʼ வாரயதி யூயமேதத்³ வித்த| ");
INSERT INTO santam_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","அதஏவ யூயமபி ஸஜ்ஜமாநாஸ்திஷ்ட²த யதோ யஸ்மிந் க்ஷணே தம்ʼ நாப்ரேக்ஷத்⁴வே தஸ்மிந்நேவ க்ஷணே மநுஷ்யபுத்ர ஆக³மிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ததா³ பிதர​: பப்ரச்ச², ஹே ப்ரபோ⁴ ப⁴வாந் கிமஸ்மாந் உத்³தி³ஸ்²ய கிம்ʼ ஸர்வ்வாந் உத்³தி³ஸ்²ய த்³ருʼஷ்டாந்தகதா²மிமாம்ʼ வத³தி? ");
INSERT INTO santam_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","தத​: ப்ரபு⁴​: ப்ரோவாச, ப்ரபு⁴​: ஸமுசிதகாலே நிஜபரிவாரார்த²ம்ʼ போ⁴ஜ்யபரிவேஷணாய யம்ʼ தத்பதே³ நியோக்ஷ்யதி தாத்³ருʼஸோ² விஸ்²வாஸ்யோ போ³த்³தா⁴ கர்ம்மாதீ⁴ஸ²​: கோஸ்தி? ");
INSERT INTO santam_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ப்ரபு⁴ராக³த்ய யம் ஏதாத்³ருʼஸே² கர்ம்மணி ப்ரவ்ருʼத்தம்ʼ த்³ரக்ஷ்யதி ஸஏவ தா³ஸோ த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","அஹம்ʼ யுஷ்மாந் யதா²ர்த²ம்ʼ வதா³மி ஸ தம்ʼ நிஜஸர்வ்வஸ்வஸ்யாதி⁴பதிம்ʼ கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","கிந்து ப்ரபு⁴ர்விலம்பே³நாக³மிஷ்யதி, இதி விசிந்த்ய ஸ தா³ஸோ யதி³ தத³ந்யதா³ஸீதா³ஸாந் ப்ரஹர்த்தும் போ⁴க்தும்ʼ பாதும்ʼ மதி³துஞ்ச ப்ராரப⁴தே, ");
INSERT INTO santam_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","தர்ஹி யதா³ ப்ரபு⁴ம்ʼ நாபேக்ஷிஷ்யதே யஸ்மிந் க்ஷணே ஸோ(அ)சேதநஸ்²ச ஸ்தா²ஸ்யதி தஸ்மிந்நேவ க்ஷணே தஸ்ய ப்ரபு⁴ராக³த்ய தம்ʼ பத³ப்⁴ரஷ்டம்ʼ க்ருʼத்வா விஸ்²வாஸஹீநை​: ஸஹ தஸ்ய அம்ʼஸ²ம்ʼ நிரூபயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","யோ தா³ஸ​: ப்ரபே⁴ाராஜ்ஞாம்ʼ ஜ்ஞாத்வாபி ஸஜ்ஜிதோ ந திஷ்ட²தி ததா³ஜ்ஞாநுஸாரேண ச கார்ய்யம்ʼ ந கரோதி ஸோநேகாந் ப்ரஹாராந் ப்ராப்ஸ்யதி; ");
INSERT INTO santam_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","கிந்து யோ ஜநோ(அ)ஜ்ஞாத்வா ப்ரஹாரார்ஹம்ʼ கர்ம்ம கரோதி ஸோல்பப்ரஹாராந் ப்ராப்ஸ்யதி| யதோ யஸ்மை பா³ஹுல்யேந த³த்தம்ʼ தஸ்மாதே³வ பா³ஹுல்யேந க்³ரஹீஷ்யதே, மாநுஷா யஸ்ய நிகடே ப³ஹு ஸமர்பயந்தி தஸ்மாத்³ ப³ஹு யாசந்தே| ");
INSERT INTO santam_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","அஹம்ʼ ப்ருʼதி²வ்யாம் அநைக்யரூபம்ʼ வஹ்நி நிக்ஷேப்தும் ஆக³தோஸ்மி, ஸ சேத்³ இதா³நீமேவ ப்ரஜ்வலதி தத்ர மம கா சிந்தா? ");
INSERT INTO santam_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","கிந்து யேந மஜ்ஜநேநாஹம்ʼ மக்³நோ ப⁴விஷ்யாமி யாவத்காலம்ʼ தஸ்ய ஸித்³தி⁴ ர்ந ப⁴விஷ்யதி தாவத³ஹம்ʼ கதிகஷ்டம்ʼ ப்ராப்ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","மேலநம்ʼ கர்த்தும்ʼ ஜக³த்³ ஆக³தோஸ்மி யூயம்ʼ கிமித்த²ம்ʼ போ³த⁴த்⁴வே? யுஷ்மாந் வதா³மி ந ததா², கிந்த்வஹம்ʼ மேலநாபா⁴வம்ʼ கர்த்தும்ʼம் ஆக³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","யஸ்மாதே³தத்காலமாரப்⁴ய ஏகத்ரஸ்த²பரிஜநாநாம்ʼ மத்⁴யே பஞ்சஜநா​: ப்ருʼத²க்³ பூ⁴த்வா த்ரயோ ஜநா த்³வயோர்ஜநயோ​: ப்ரதிகூலா த்³வௌ ஜநௌ ச த்ரயாணாம்ʼ ஜநாநாம்ʼ ப்ரதிகூலௌ ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","பிதா புத்ரஸ்ய விபக்ஷ​: புத்ரஸ்²ச பிது ர்விபக்ஷோ ப⁴விஷ்யதி மாதா கந்யாயா விபக்ஷா கந்யா ச மாது ர்விபக்ஷா ப⁴விஷ்யதி, ததா² ஸ்²வஸ்²ரூர்ப³த்⁴வா விபக்ஷா ப³தூ⁴ஸ்²ச ஸ்²வஸ்²ர்வா விபக்ஷா ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ஸ லோகேப்⁴யோபரமபி கத²யாமாஸ, பஸ்²சிமதி³ஸி² மேகோ⁴த்³க³மம்ʼ த்³ருʼஷ்ட்வா யூயம்ʼ ஹடா²த்³ வத³த² வ்ருʼஷ்டி ர்ப⁴விஷ்யதி ததஸ்ததை²வ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","அபரம்ʼ த³க்ஷிணதோ வாயௌ வாதி ஸதி வத³த² நிதா³கோ⁴ ப⁴விஷ்யதி தத​: ஸோபி ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ரே ரே கபடிந ஆகாஸ²ஸ்ய பூ⁴ம்யாஸ்²ச லக்ஷணம்ʼ போ³த்³து⁴ம்ʼ ஸ²க்நுத², ");
INSERT INTO santam_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","கிந்து காலஸ்யாஸ்ய லக்ஷணம்ʼ குதோ போ³த்³து⁴ம்ʼ ந ஸ²க்நுத²? யூயஞ்ச ஸ்வயம்ʼ குதோ ந ந்யாஷ்யம்ʼ விசாரயத²? ");
INSERT INTO santam_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","அபரஞ்ச விவாதி³நா ஸார்த்³த⁴ம்ʼ விசாரயிது​: ஸமீபம்ʼ க³ச்ச²ந் பதி² தஸ்மாது³த்³தா⁴ரம்ʼ ப்ராப்தும்ʼ யதஸ்வ நோசேத் ஸ த்வாம்ʼ த்⁴ருʼத்வா விசாரயிது​: ஸமீபம்ʼ நயதி| விசாரயிதா யதி³ த்வாம்ʼ ப்ரஹர்த்து​: ஸமீபம்ʼ ஸமர்பயதி ப்ரஹர்த்தா த்வாம்ʼ காராயாம்ʼ ப³த்⁴நாதி ");
INSERT INTO santam_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","தர்ஹி த்வாமஹம்ʼ வதா³மி த்வயா நி​:ஸே²ஷம்ʼ கபர்த³கேஷு ந பரிஸோ²தி⁴தேஷு த்வம்ʼ ததோ முக்திம்ʼ ப்ராப்தும்ʼ ந ஸ²க்ஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","அபரஞ்ச பீலாதோ யேஷாம்ʼ கா³லீலீயாநாம்ʼ ரக்தாநி ப³லீநாம்ʼ ரக்தை​: ஸஹாமிஸ்²ரயத் தேஷாம்ʼ கா³லீலீயாநாம்ʼ வ்ருʼத்தாந்தம்ʼ கதிபயஜநா உபஸ்தா²ப்ய யீஸ²வே கத²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","தத​: ஸ ப்ரத்யுவாச தேஷாம்ʼ லோகாநாம் ஏதாத்³ருʼஸீ² து³ர்க³தி ர்க⁴டிதா தத்காரணாத்³ யூயம்ʼ கிமந்யேப்⁴யோ கா³லீலீயேப்⁴யோப்யதி⁴கபாபிநஸ்தாந் போ³த⁴த்⁴வே? ");
INSERT INTO santam_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","யுஷ்மாநஹம்ʼ வதா³மி ததா² ந கிந்து மந​:ஸு ந பராவர்த்திதேஷு யூயமபி ததா² நம்ʼக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","அபரஞ்ச ஸீ²லோஹநாம்ந உச்சக்³ருʼஹஸ்ய பதநாத்³ யே(அ)ஷ்டாத³ஸ²ஜநா ம்ருʼதாஸ்தே யிரூஸா²லமி நிவாஸிஸர்வ்வலோகேப்⁴யோ(அ)தி⁴காபராதி⁴ந​: கிம்ʼ யூயமித்யம்ʼ போ³த⁴த்⁴வே? ");
INSERT INTO santam_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","யுஷ்மாநஹம்ʼ வதா³மி ததா² ந கிந்து மந​:ஸு ந பரிவர்த்திதேஷு யூயமபி ததா² நம்ʼக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","அநந்தரம்ʼ ஸ இமாம்ʼ த்³ருʼஷ்டாந்தகதா²மகத²யத்³ ஏகோ ஜநோ த்³ராக்ஷாக்ஷேத்ரமத்⁴ய ஏகமுடு³ம்ப³ரவ்ருʼக்ஷம்ʼ ரோபிதவாந்| பஸ்²சாத் ஸ ஆக³த்ய தஸ்மிந் ப²லாநி க³வேஷயாமாஸ, ");
INSERT INTO santam_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","கிந்து ப²லாப்ராப்தே​: காரணாத்³ உத்³யாநகாரம்ʼ ப்⁴ருʼத்யம்ʼ ஜகா³த³, பஸ்²ய வத்ஸரத்ரயம்ʼ யாவதா³க³த்ய ஏதஸ்மிந்நுடு³ம்ப³ரதரௌ க்ஷலாந்யந்விச்சா²மி, கிந்து நைகமபி ப்ரப்நோமி தருரயம்ʼ குதோ வ்ருʼதா² ஸ்தா²நம்ʼ வ்யாப்ய திஷ்ட²தி? ஏநம்ʼ சி²ந்தி⁴| ");
INSERT INTO santam_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ததோ ப்⁴ருʼத்ய​: ப்ரத்யுவாச, ஹே ப்ரபோ⁴ புநர்வர்ஷமேகம்ʼ ஸ்தா²தும் ஆதி³ஸ²; ஏதஸ்ய மூலஸ்ய சதுர்தி³க்ஷு க²நித்வாஹம் ஆலவாலம்ʼ ஸ்தா²பயாமி| ");
INSERT INTO santam_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","தத​: ப²லிதும்ʼ ஸ²க்நோதி யதி³ ந ப²லதி தர்ஹி பஸ்²சாத் சே²த்ஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","அத² விஸ்²ராமவாரே ப⁴ஜநகே³ஹே யீஸு²ருபதி³ஸ²தி ");
INSERT INTO santam_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","தஸ்மித் ஸமயே பூ⁴தக்³ரஸ்தத்வாத் குப்³ஜீபூ⁴யாஷ்டாத³ஸ²வர்ஷாணி யாவத் கேநாப்யுபாயேந ருʼஜு ர்ப⁴விதும்ʼ ந ஸ²க்நோதி யா து³ர்ப்³ப³லா ஸ்த்ரீ, ");
INSERT INTO santam_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","தாம்ʼ தத்ரோபஸ்தி²தாம்ʼ விலோக்ய யீஸு²ஸ்தாமாஹூய கதி²தவாந் ஹே நாரி தவ தௌ³ர்ப்³ப³ல்யாத் த்வம்ʼ முக்தா ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","தத​: பரம்ʼ தஸ்யா கா³த்ரே ஹஸ்தார்பணமாத்ராத் ஸா ருʼஜுர்பூ⁴த்வேஸ்²வரஸ்ய த⁴ந்யவாத³ம்ʼ கர்த்துமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","கிந்து விஸ்²ராமவாரே யீஸு²நா தஸ்யா​: ஸ்வாஸ்த்²யகரணாத்³ ப⁴ஜநகே³ஹஸ்யாதி⁴பதி​: ப்ரகுப்ய லோகாந் உவாச, ஷட்ஸு தி³நேஷு லோகை​: கர்ம்ம கர்த்தவ்யம்ʼ தஸ்மாத்³தே⁴தோ​: ஸ்வாஸ்த்²யார்த²ம்ʼ தேஷு தி³நேஷு ஆக³ச்ச²த, விஸ்²ராமவாரே மாக³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ததா³ பபு⁴​: ப்ரத்யுவாச ரே கபடிநோ யுஷ்மாகம் ஏகைகோ ஜநோ விஸ்²ராமவாரே ஸ்வீயம்ʼ ஸ்வீயம்ʼ வ்ருʼஷப⁴ம்ʼ க³ர்த³ப⁴ம்ʼ வா ப³ந்த⁴நாந்மோசயித்வா ஜலம்ʼ பாயயிதும்ʼ கிம்ʼ ந நயதி? ");
INSERT INTO santam_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","தர்ஹ்யாஷ்டாத³ஸ²வத்ஸராந் யாவத் ஸை²தாநா ப³த்³தா⁴ இப்³ராஹீம​: ஸந்ததிரியம்ʼ நாரீ கிம்ʼ விஸ்²ராமவாரே ந மோசயிதவ்யா? ");
INSERT INTO santam_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ஏஷு வாக்யேஷு கதி²தேஷு தஸ்ய விபக்ஷா​: ஸலஜ்ஜா ஜாதா​: கிந்து தேந க்ருʼதஸர்வ்வமஹாகர்ம்மகாரணாத் லோகநிவஹ​: ஸாநந்தோ³(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","அநந்தரம்ʼ ஸோவத³த்³ ஈஸ்²வரஸ்ய ராஜ்யம்ʼ கஸ்ய ஸத்³ருʼஸ²ம்ʼ? கேந தது³பமாஸ்யாமி? ");
INSERT INTO santam_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","யத் ஸர்ஷபபீ³ஜம்ʼ க்³ருʼஹீத்வா கஸ்²சிஜ்ஜந உத்³யாந உப்தவாந் தத்³ பீ³ஜமங்குரிதம்ʼ ஸத் மஹாவ்ருʼக்ஷோ(அ)ஜாயத, ததஸ்தஸ்ய ஸா²கா²ஸு விஹாயஸீயவிஹகா³ ஆக³த்ய ந்யூஷு​:, தத்³ராஜ்யம்ʼ தாத்³ருʼஸே²ந ஸர்ஷபபீ³ஜேந துல்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","புந​: கத²யாமாஸ, ஈஸ்²வரஸ்ய ராஜ்யம்ʼ கஸ்ய ஸத்³ருʼஸ²ம்ʼ வதி³ஷ்யாமி? யத் கிண்வம்ʼ காசித் ஸ்த்ரீ க்³ருʼஹீத்வா த்³ரோணத்ரயபரிமிதகோ³தூ⁴மசூர்ணேஷு ஸ்தா²பயாமாஸ, ");
INSERT INTO santam_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","தத​: க்ரமேண தத் ஸர்வ்வகோ³தூ⁴மசூர்ணம்ʼ வ்யாப்நோதி, தஸ்ய கிண்வஸ்ய துல்யம் ஈஸ்²வரஸ்ய ராஜ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","தத​: ஸ யிரூஸா²லம்நக³ரம்ʼ ப்ரதி யாத்ராம்ʼ க்ருʼத்வா நக³ரே நக³ரே க்³ராமே க்³ராமே ஸமுபதி³ஸ²ந் ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ததா³ கஸ்²சிஜ்ஜநஸ்தம்ʼ பப்ரச்ச², ஹே ப்ரபோ⁴ கிம்ʼ கேவலம் அல்பே லோகா​: பரித்ராஸ்யந்தே? ");
INSERT INTO santam_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","தத​: ஸ லோகாந் உவாச, ஸம்ʼகீர்ணத்³வாரேண ப்ரவேஷ்டும்ʼ யதக்⁴வம்ʼ, யதோஹம்ʼ யுஷ்மாந் வதா³மி, ப³ஹவ​: ப்ரவேஷ்டும்ʼ சேஷ்டிஷ்யந்தே கிந்து ந ஸ²க்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","க்³ருʼஹபதிநோத்தா²ய த்³வாரே ருத்³தே⁴ ஸதி யதி³ யூயம்ʼ ப³ஹி​: ஸ்தி²த்வா த்³வாரமாஹத்ய வத³த², ஹே ப்ரபோ⁴ ஹே ப்ரபோ⁴ அஸ்மத்காரணாத்³ த்³வாரம்ʼ மோசயது, தத​: ஸ இதி ப்ரதிவக்ஷ்யதி, யூயம்ʼ குத்ரத்யா லோகா இத்யஹம்ʼ ந ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ததா³ யூயம்ʼ வதி³ஷ்யத², தவ ஸாக்ஷாத்³ வயம்ʼ பே⁴ाஜநம்ʼ பாநஞ்ச க்ருʼதவந்த​:, த்வஞ்சாஸ்மாகம்ʼ நக³ரஸ்ய பதி² ஸமுபதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","கிந்து ஸ வக்ஷ்யதி, யுஷ்மாநஹம்ʼ வதா³மி, யூயம்ʼ குத்ரத்யா லோகா இத்யஹம்ʼ ந ஜாநாமி; ஹே து³ராசாரிணோ யூயம்ʼ மத்தோ தூ³ரீப⁴வத| ");
INSERT INTO santam_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ததா³ இப்³ராஹீமம்ʼ இஸ்ஹாகம்ʼ யாகூப³ஞ்ச ஸர்வ்வப⁴விஷ்யத்³வாதி³நஸ்²ச ஈஸ்²வரஸ்ய ராஜ்யம்ʼ ப்ராப்தாந் ஸ்வாம்ʼஸ்²ச ப³ஹிஷ்க்ருʼதாந் த்³ருʼஷ்ட்வா யூயம்ʼ ரோத³நம்ʼ த³ந்தைர்த³ந்தக⁴ர்ஷணஞ்ச கரிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","அபரஞ்ச பூர்வ்வபஸ்²சிமத³க்ஷிணோத்தரதி³க்³ப்⁴யோ லோகா ஆக³த்ய ஈஸ்²வரஸ்ய ராஜ்யே நிவத்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","பஸ்²யதேத்த²ம்ʼ ஸே²ஷீயா லோகா அக்³ரா ப⁴விஷ்யந்தி, அக்³ரீயா லோகாஸ்²ச ஸே²ஷா ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","அபரஞ்ச தஸ்மிந் தி³நே கியந்த​: பி²ரூஸி²ந ஆக³த்ய யீஸு²ம்ʼ ப்ரோசு​:, ப³ஹிர்க³ச்ச², ஸ்தா²நாத³ஸ்மாத் ப்ரஸ்தா²நம்ʼ குரு, ஹேரோத்³ த்வாம்ʼ ஜிகா⁴ம்ʼஸதி| ");
INSERT INTO santam_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","தத​: ஸ ப்ரத்யவோசத் பஸ்²யதாத்³ய ஸ்²வஸ்²ச பூ⁴தாந் விஹாப்ய ரோகி³ணோ(அ)ரோகி³ண​: க்ருʼத்வா த்ருʼதீயேஹ்நி ஸேத்ஸ்யாமி, கதா²மேதாம்ʼ யூயமித்வா தம்ʼ பூ⁴ரிமாயம்ʼ வத³த| ");
INSERT INTO santam_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","தத்ராப்யத்³ய ஸ்²வ​: பரஸ்²வஸ்²ச மயா க³மநாக³மநே கர்த்தவ்யே, யதோ ஹேதோ ர்யிரூஸா²லமோ ப³ஹி​: குத்ராபி கோபி ப⁴விஷ்யத்³வாதீ³ ந கா⁴நிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ஹே யிரூஸா²லம் ஹே யிரூஸா²லம் த்வம்ʼ ப⁴விஷ்யத்³வாதி³நோ ஹம்ʼஸி தவாந்திகே ப்ரேரிதாந் ப்ரஸ்தரைர்மாரயஸி ச, யதா² குக்குடீ நிஜபக்ஷாத⁴​: ஸ்வஸா²வகாந் ஸம்ʼக்³ருʼஹ்லாதி, ததா²ஹமபி தவ ஸி²ஸூ²ந் ஸம்ʼக்³ரஹீதும்ʼ கதிவாராந் ஐச்ச²ம்ʼ கிந்து த்வம்ʼ நைச்ச²​:| ");
INSERT INTO santam_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","பஸ்²யத யுஷ்மாகம்ʼ வாஸஸ்தா²நாநி ப்ரோச்சி²த்³யமாநாநி பரித்யக்தாநி ச ப⁴விஷ்யந்தி; யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, ய​: ப்ரபோ⁴ ர்நாம்நாக³ச்ச²தி ஸ த⁴ந்ய இதி வாசம்ʼ யாவத்காலம்ʼ ந வதி³ஷ்யத², தாவத்காலம்ʼ யூயம்ʼ மாம்ʼ ந த்³ரக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","அநந்தரம்ʼ விஸ்²ராமவாரே யீஸௌ² ப்ரதா⁴நஸ்ய பி²ரூஸி²நோ க்³ருʼஹே போ⁴க்தும்ʼ க³தவதி தே தம்ʼ வீக்ஷிதும் ஆரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ததா³ ஜலோத³ரீ தஸ்ய ஸம்முகே² ஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","தத​: ஸ வ்யவஸ்தா²பகாந் பி²ரூஸி²நஸ்²ச பப்ரச்ச², விஸ்²ராமவாரே ஸ்வாஸ்த்²யம்ʼ கர்த்தவ்யம்ʼ ந வா? ததஸ்தே கிமபி ந ப்ரத்யூசு​:| ");
INSERT INTO santam_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ததா³ ஸ தம்ʼ ரோகி³ணம்ʼ ஸ்வஸ்த²ம்ʼ க்ருʼத்வா விஸஸர்ஜ; ");
INSERT INTO santam_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","தாநுவாச ச யுஷ்மாகம்ʼ கஸ்யசித்³ க³ர்த்³த³போ⁴ வ்ருʼஷபோ⁴ வா சேத்³ க³ர்த்தே பததி தர்ஹி விஸ்²ராமவாரே தத்க்ஷணம்ʼ ஸ கிம்ʼ தம்ʼ நோத்தா²பயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ததஸ்தே கதா²யா ஏதஸ்யா​: கிமபி ப்ரதிவக்தும்ʼ ந ஸே²கு​:| ");
INSERT INTO santam_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","அபரஞ்ச ப்ரதா⁴நஸ்தா²நமநோநீதத்வகரணம்ʼ விலோக்ய ஸ நிமந்த்ரிதாந் ஏதது³பதே³ஸ²கதா²ம்ʼ ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","த்வம்ʼ விவாஹாதி³போ⁴ஜ்யேஷு நிமந்த்ரித​: ஸந் ப்ரதா⁴நஸ்தா²நே மோபாவேக்ஷீ​:| த்வத்தோ கௌ³ரவாந்விதநிமந்த்ரிதஜந ஆயாதே ");
INSERT INTO santam_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","நிமந்த்ரயிதாக³த்ய மநுஷ்யாயைதஸ்மை ஸ்தா²நம்ʼ தே³ஹீதி வாக்யம்ʼ சேத்³ வக்ஷ்யதி தர்ஹி த்வம்ʼ ஸங்குசிதோ பூ⁴த்வா ஸ்தா²ந இதரஸ்மிந் உபவேஷ்டும் உத்³யம்ʼஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","அஸ்மாத் காரணாதே³வ த்வம்ʼ நிமந்த்ரிதோ க³த்வா(அ)ப்ரதா⁴நஸ்தா²ந உபவிஸ², ததோ நிமந்த்ரயிதாக³த்ய வதி³ஷ்யதி, ஹே ப³ந்தோ⁴ ப்ரோச்சஸ்தா²நம்ʼ க³த்வோபவிஸ², ததா² ஸதி போ⁴ஜநோபவிஷ்டாநாம்ʼ ஸகலாநாம்ʼ ஸாக்ஷாத் த்வம்ʼ மாந்யோ ப⁴விஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ய​: கஸ்²சித் ஸ்வமுந்நமயதி ஸ நமயிஷ்யதே, கிந்து ய​: கஸ்²சித் ஸ்வம்ʼ நமயதி ஸ உந்நமயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ததா³ ஸ நிமந்த்ரயிதாரம்ʼ ஜநமபி ஜகா³த³, மத்⁴யாஹ்நே ராத்ரௌ வா போ⁴ஜ்யே க்ருʼதே நிஜப³ந்து⁴க³ணோ வா ப்⁴ராத்ருʼृக³ணோ வா ஜ்ஞாதிக³ணோ வா த⁴நிக³ணோ வா ஸமீபவாஸிக³ணோ வா ஏதாந் ந நிமந்த்ரய, ததா² க்ருʼதே சேத் தே த்வாம்ʼ நிமந்த்ரயிஷ்யந்தி, தர்ஹி பரிஸோ²தோ⁴ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","கிந்து யதா³ பே⁴ஜ்யம்ʼ கரோஷி ததா³ த³ரித்³ரஸு²ஷ்ககரக²ஞ்ஜாந்தா⁴ந் நிமந்த்ரய, ");
INSERT INTO santam_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","தத ஆஸி²ஷம்ʼ லப்ஸ்யஸே, தேஷு பரிஸோ²த⁴ம்ʼ கர்த்துமஸ²க்நுவத்ஸு ஸ்²மஸா²நாத்³தா⁴ர்ம்மிகாநாமுத்தா²நகாலே த்வம்ʼ ப²லாம்ʼ லப்ஸ்யஸே| ");
INSERT INTO santam_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","அநந்தரம்ʼ தாம்ʼ கதா²ம்ʼ நிஸ²ம்ய போ⁴ஜநோபவிஷ்ட​: கஸ்²சித் கத²யாமாஸ, யோ ஜந ஈஸ்²வரஸ்ய ராஜ்யே போ⁴க்தும்ʼ லப்ஸ்யதே ஸஏவ த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","தத​: ஸ உவாச, கஸ்²சித் ஜநோ ராத்ரௌ பே⁴ाஜ்யம்ʼ க்ருʼத்வா ப³ஹூந் நிமந்த்ரயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ததோ போ⁴ஜநஸமயே நிமந்த்ரிதலோகாந் ஆஹ்வாதும்ʼ தா³ஸத்³வாரா கத²யாமாஸ, க²த்³யத்³ரவ்யாணி ஸர்வ்வாணி ஸமாஸாதி³தாநி ஸந்தி, யூயமாக³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","கிந்து தே ஸர்வ்வ ஏகைகம்ʼ ச²லம்ʼ க்ருʼத்வா க்ஷமாம்ʼ ப்ரார்த²யாஞ்சக்ரிரே| ப்ரத²மோ ஜந​: கத²யாமாஸ, க்ஷேத்ரமேகம்ʼ க்ரீதவாநஹம்ʼ ததே³வ த்³ரஷ்டும்ʼ மயா க³ந்தவ்யம், அதஏவ மாம்ʼ க்ஷந்தும்ʼ தம்ʼ நிவேத³ய| ");
INSERT INTO santam_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","அந்யோ ஜந​: கத²யாமாஸ, த³ஸ²வ்ருʼஷாநஹம்ʼ க்ரீதவாந் தாந் பரீக்ஷிதும்ʼ யாமி தஸ்மாதே³வ மாம்ʼ க்ஷந்தும்ʼ தம்ʼ நிவேத³ய| ");
INSERT INTO santam_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","அபர​: கத²யாமாஸ, வ்யூட⁴வாநஹம்ʼ தஸ்மாத் காரணாத்³ யாதும்ʼ ந ஸ²க்நோமி| ");
INSERT INTO santam_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","பஸ்²சாத் ஸ தா³ஸோ க³த்வா நிஜப்ரபோ⁴​: ஸாக்ஷாத் ஸர்வ்வவ்ருʼத்தாந்தம்ʼ நிவேத³யாமாஸ, ததோஸௌ க்³ருʼஹபதி​: குபித்வா ஸ்வதா³ஸம்ʼ வ்யாஜஹார, த்வம்ʼ ஸத்வரம்ʼ நக³ரஸ்ய ஸந்நிவேஸா²ந் மார்கா³ம்ʼஸ்²ச க³த்வா த³ரித்³ரஸு²ஷ்ககரக²ஞ்ஜாந்தா⁴ந் அத்ராநய| ");
INSERT INTO santam_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ததோ தா³ஸோ(அ)வத³த், ஹே ப்ரபோ⁴ ப⁴வத ஆஜ்ஞாநுஸாரேணாக்ரியத ததா²பி ஸ்தா²நமஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ததா³ ப்ரபு⁴​: புந ர்தா³ஸாயாகத²யத், ராஜபதா²ந் வ்ருʼக்ஷமூலாநி ச யாத்வா மதீ³யக்³ருʼஹபூரணார்த²ம்ʼ லோகாநாக³ந்தும்ʼ ப்ரவர்த்தய| ");
INSERT INTO santam_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","அஹம்ʼ யுஷ்மப்⁴யம்ʼ கத²யாமி, பூர்வ்வநிமந்த்ரிதாநமேகோபி மமாஸ்ய ராத்ரிபோ⁴ஜ்யஸ்யாஸ்வாத³ம்ʼ ந ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","அநந்தரம்ʼ ப³ஹுஷு லோகேஷு யீஸோ²​: பஸ்²சாத்³ வ்ரஜிதேஷு ஸத்ஸு ஸ வ்யாகு⁴ட்ய தேப்⁴ய​: கத²யாமாஸ, ");
INSERT INTO santam_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ய​: கஸ்²சிந் மம ஸமீபம் ஆக³த்ய ஸ்வஸ்ய மாதா பிதா பத்நீ ஸந்தாநா ப்⁴ராதரோ ப⁴கி³ம்யோ நிஜப்ராணாஸ்²ச, ஏதேப்⁴ய​: ஸர்வ்வேப்⁴யோ மய்யதி⁴கம்ʼ ப்ரேம ந கரோதி, ஸ மம ஸி²ஷ்யோ ப⁴விதும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ய​: கஸ்²சித் ஸ்வீயம்ʼ க்ருஸ²ம்ʼ வஹந் மம பஸ்²சாந்ந க³ச்ச²தி, ஸோபி மம ஸி²ஷ்யோ ப⁴விதும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","து³ர்க³நிர்ம்மாணே கதிவ்யயோ ப⁴விஷ்யதி, ததா² தஸ்ய ஸமாப்திகரணார்த²ம்ʼ ஸம்பத்திரஸ்தி ந வா, ப்ரத²மமுபவிஸ்²ய ஏதந்ந க³ணயதி, யுஷ்மாகம்ʼ மத்⁴ய ஏதாத்³ருʼஸ²​: கோஸ்தி? ");
INSERT INTO santam_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","நோசேத்³ பி⁴த்திம்ʼ க்ருʼத்வா ஸே²ஷே யதி³ ஸமாபயிதும்ʼ ந ஸ²க்ஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","தர்ஹி மாநுஷோயம்ʼ நிசேதும் ஆரப⁴த ஸமாபயிதும்ʼ நாஸ²க்நோத், இதி வ்யாஹ்ருʼத்ய ஸர்வ்வே தமுபஹஸிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","அபரஞ்ச பி⁴ந்நபூ⁴பதிநா ஸஹ யுத்³த⁴ம்ʼ கர்த்தும் உத்³யம்ய த³ஸ²ஸஹஸ்ராணி ஸைந்யாநி க்³ருʼஹீத்வா விம்ʼஸ²திஸஹஸ்ரே​: ஸைந்யை​: ஸஹிதஸ்ய ஸமீபவாஸிந​: ஸம்முக²ம்ʼ யாதும்ʼ ஸ²க்ஷ்யாமி ந வேதி ப்ரத²மம்ʼ உபவிஸ்²ய ந விசாரயதி ஏதாத்³ருʼஸோ² பூ⁴மிபதி​: க​:? ");
INSERT INTO santam_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","யதி³ ந ஸ²க்நோதி தர்ஹி ரிபாவதிதூ³ரே திஷ்ட²தி ஸதி நிஜதூ³தம்ʼ ப்ரேஷ்ய ஸந்தி⁴ம்ʼ கர்த்தும்ʼ ப்ரார்த²யேத| ");
INSERT INTO santam_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","தத்³வத்³ யுஷ்மாகம்ʼ மத்⁴யே ய​: கஸ்²சிந் மத³ர்த²ம்ʼ ஸர்வ்வஸ்வம்ʼ ஹாதும்ʼ ந ஸ²க்நோதி ஸ மம ஸி²ஷ்யோ ப⁴விதும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","லவணம் உத்தமம் இதி ஸத்யம்ʼ, கிந்து யதி³ லவணஸ்ய லவணத்வம் அபக³ச்ச²தி தர்ஹி தத் கத²ம்ʼ ஸ்வாது³யுக்தம்ʼ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","தத³ பூ⁴ம்யர்த²ம் ஆலவாலராஸ்²யர்த²மபி ப⁴த்³ரம்ʼ ந ப⁴வதி; லோகாஸ்தத்³ ப³ஹி​: க்ஷிபந்தி| யஸ்ய ஸ்²ரோதும்ʼ ஸ்²ரோத்ரே ஸ்த​: ஸ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ததா³ கரஸஞ்சாயிந​: பாபிநஸ்²ச லோகா உபதே³ஸ்²கதா²ம்ʼ ஸ்²ரோதும்ʼ யீஸோ²​: ஸமீபம் ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","தத​: பி²ரூஸி²ந உபாத்⁴யாயாஸ்²ச விவத³மாநா​: கத²யாமாஸு​: ஏஷ மாநுஷ​: பாபிபி⁴​: ஸஹ ப்ரணயம்ʼ க்ருʼத்வா தை​: ஸார்த்³த⁴ம்ʼ பு⁴ம்ʼக்தே| ");
INSERT INTO santam_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ததா³ ஸ தேப்⁴ய இமாம்ʼ த்³ருʼஷ்டாந்தகதா²ம்ʼ கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","கஸ்யசித் ஸ²தமேஷேஷு திஷ்ட²த்மு தேஷாமேகம்ʼ ஸ யதி³ ஹாரயதி தர்ஹி மத்⁴யேப்ராந்தரம் ஏகோநஸ²தமேஷாந் விஹாய ஹாரிதமேஷஸ்ய உத்³தே³ஸ²ப்ராப்திபர்ய்யநதம்ʼ ந க³வேஷயதி, ஏதாத்³ருʼஸோ² லோகோ யுஷ்மாகம்ʼ மத்⁴யே க ஆஸ்தே? ");
INSERT INTO santam_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","தஸ்யோத்³தே³ஸ²ம்ʼ ப்ராப்ய ஹ்ருʼஷ்டமநாஸ்தம்ʼ ஸ்கந்தே⁴ நிதா⁴ய ஸ்வஸ்தா²நம் ஆநீய ப³ந்து⁴பா³ந்த⁴வஸமீபவாஸிந ஆஹூய வக்தி, ");
INSERT INTO santam_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ஹாரிதம்ʼ மேஷம்ʼ ப்ராப்தோஹம் அதோ ஹேதோ ர்மயா ஸார்த்³த⁴ம் ஆநந்த³த| ");
INSERT INTO santam_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","தத்³வத³ஹம்ʼ யுஷ்மாந் வதா³மி, யேஷாம்ʼ மந​:பராவர்த்தநஸ்ய ப்ரயோஜநம்ʼ நாஸ்தி, தாத்³ருʼஸை²கோநஸ²ததா⁴ர்ம்மிககாரணாத்³ ய ஆநந்த³ஸ்தஸ்மாத்³ ஏகஸ்ய மந​:பரிவர்த்திந​: பாபிந​: காரணாத் ஸ்வர்கே³ (அ)தி⁴காநந்தோ³ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","அபரஞ்ச த³ஸா²நாம்ʼ ரூப்யக²ண்டா³நாம் ஏகக²ண்டே³ ஹாரிதே ப்ரதீ³பம்ʼ ப்ரஜ்வால்ய க்³ருʼஹம்ʼ ஸம்மார்ஜ்ய தஸ்ய ப்ராப்திம்ʼ யாவத்³ யத்நேந ந க³வேஷயதி, ஏதாத்³ருʼஸீ² யோஷித் காஸ்தே? ");
INSERT INTO santam_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ப்ராப்தே ஸதி ப³ந்து⁴பா³ந்த⁴வஸமீபவாஸிநீராஹூய கத²யதி, ஹாரிதம்ʼ ரூப்யக²ண்ட³ம்ʼ ப்ராப்தாஹம்ʼ தஸ்மாதே³வ மயா ஸார்த்³த⁴ம் ஆநந்த³த| ");
INSERT INTO santam_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","தத்³வத³ஹம்ʼ யுஷ்மாந் வ்யாஹராமி, ஏகேந பாபிநா மநஸி பரிவர்த்திதே, ஈஸ்²வரஸ்ய தூ³தாநாம்ʼ மத்⁴யேப்யாநந்தோ³ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","அபரஞ்ச ஸ கத²யாமாஸ, கஸ்யசித்³ த்³வௌ புத்ராவாஸ்தாம்ʼ, ");
INSERT INTO santam_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","தயோ​: கநிஷ்ட²​: புத்ர​: பித்ரே கத²யாமாஸ, ஹே பிதஸ்தவ ஸம்பத்த்யா யமம்ʼஸ²ம்ʼ ப்ராப்ஸ்யாம்யஹம்ʼ விப⁴ஜ்ய தம்ʼ தே³ஹி, தத​: பிதா நிஜாம்ʼ ஸம்பத்திம்ʼ விப⁴ஜ்ய தாப்⁴யாம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","கதிபயாத் காலாத் பரம்ʼ ஸ கநிஷ்ட²புத்ர​: ஸமஸ்தம்ʼ த⁴நம்ʼ ஸம்ʼக்³ருʼஹ்ய தூ³ரதே³ஸ²ம்ʼ க³த்வா து³ஷ்டாசரணேந ஸர்வ்வாம்ʼ ஸம்பத்திம்ʼ நாஸ²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","தஸ்ய ஸர்வ்வத⁴நே வ்யயம்ʼ க³தே தத்³தே³ஸே² மஹாது³ர்பி⁴க்ஷம்ʼ ப³பூ⁴வ, ததஸ்தஸ்ய தை³ந்யத³ஸா² ப⁴விதும் ஆரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","தத​: பரம்ʼ ஸ க³த்வா தத்³தே³ஸீ²யம்ʼ க்³ருʼஹஸ்த²மேகம் ஆஸ்²ரயத; தத​: ஸதம்ʼ ஸூ²கரவ்ரஜம்ʼ சாரயிதும்ʼ ப்ராந்தரம்ʼ ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","கேநாபி தஸ்மை ப⁴க்ஷ்யாதா³நாத் ஸ ஸூ²கரப²லவல்கலேந பிசிண்ட³பூரணாம்ʼ வவாஞ்ச²| ");
INSERT INTO santam_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ஸே²ஷே ஸ மநஸி சேதநாம்ʼ ப்ராப்ய கத²யாமாஸ, ஹா மம பிது​: ஸமீபே கதி கதி வேதநபு⁴ஜோ தா³ஸா யதே²ஷ்டம்ʼ ததோதி⁴கஞ்ச ப⁴க்ஷ்யம்ʼ ப்ராப்நுவந்தி கிந்த்வஹம்ʼ க்ஷுதா⁴ முமூர்ஷு​:| ");
INSERT INTO santam_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","அஹமுத்தா²ய பிது​: ஸமீபம்ʼ க³த்வா கதா²மேதாம்ʼ வதி³ஷ்யாமி, ஹே பிதர் ஈஸ்²வரஸ்ய தவ ச விருத்³த⁴ம்ʼ பாபமகரவம் ");
INSERT INTO santam_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","தவ புத்ரஇதி விக்²யாதோ ப⁴விதும்ʼ ந யோக்³யோஸ்மி ச, மாம்ʼ தவ வைதநிகம்ʼ தா³ஸம்ʼ க்ருʼத்வா ஸ்தா²பய| ");
INSERT INTO santam_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","பஸ்²சாத் ஸ உத்தா²ய பிது​: ஸமீபம்ʼ ஜகா³ம; ததஸ்தஸ்ய பிதாதிதூ³ரே தம்ʼ நிரீக்ஷ்ய த³யாஞ்சக்ரே, தா⁴வித்வா தஸ்ய கண்ட²ம்ʼ க்³ருʼஹீத்வா தம்ʼ சுசும்ப³ ச| ");
INSERT INTO santam_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ததா³ புத்ர உவாச, ஹே பிதர் ஈஸ்²வரஸ்ய தவ ச விருத்³த⁴ம்ʼ பாபமகரவம்ʼ, தவ புத்ரஇதி விக்²யாதோ ப⁴விதும்ʼ ந யோக்³யோஸ்மி ச| ");
INSERT INTO santam_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","கிந்து தஸ்ய பிதா நிஜதா³ஸாந் ஆதி³தே³ஸ², ஸர்வ்வோத்தமவஸ்த்ராண்யாநீய பரிதா⁴பயதைநம்ʼ ஹஸ்தே சாங்கு³ரீயகம் அர்பயத பாத³யோஸ்²சோபாநஹௌ ஸமர்பயத; ");
INSERT INTO santam_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","புஷ்டம்ʼ கோ³வத்ஸம் ஆநீய மாரயத ச தம்ʼ பு⁴க்த்வா வயம் ஆநந்தா³ம| ");
INSERT INTO santam_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","யதோ மம புத்ரோயம் அம்ரியத புநரஜீவீத்³ ஹாரிதஸ்²ச லப்³தோ⁴பூ⁴த் ததஸ்த ஆநந்தி³தும் ஆரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","தத்காலே தஸ்ய ஜ்யேஷ்ட²​: புத்ர​: க்ஷேத்ர ஆஸீத்| அத² ஸ நிவேஸ²நஸ்ய நிகடம்ʼ ஆக³ச்ச²ந் ந்ருʼத்யாநாம்ʼ வாத்³யாநாஞ்ச ஸ²ப்³த³ம்ʼ ஸ்²ருத்வா ");
INSERT INTO santam_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","தா³ஸாநாம் ஏகம் ஆஹூய பப்ரச்ச², கிம்ʼ காரணமஸ்ய? ");
INSERT INTO santam_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","தத​: ஸோவாதீ³த், தவ ப்⁴ராதாக³மத், தவ தாதஸ்²ச தம்ʼ ஸுஸ²ரீரம்ʼ ப்ராப்ய புஷ்டம்ʼ கோ³வத்ஸம்ʼ மாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","தத​: ஸ ப்ரகுப்ய நிவேஸ²நாந்த​: ப்ரவேஷ்டும்ʼ ந ஸம்மேநே; ததஸ்தஸ்ய பிதா ப³ஹிராக³த்ய தம்ʼ ஸாத⁴யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","தத​: ஸ பிதரம்ʼ ப்ரத்யுவாச, பஸ்²ய தவ காஞ்சித³ப்யாஜ்ஞாம்ʼ ந விலம்ʼக்⁴ய ப³ஹூந் வத்ஸராந் அஹம்ʼ த்வாம்ʼ ஸேவே ததா²பி மித்ரை​: ஸார்த்³த⁴ம் உத்ஸவம்ʼ கர்த்தும்ʼ கதா³பி சா²க³மேகமபி மஹ்யம்ʼ நாத³தா³​:; ");
INSERT INTO santam_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","கிந்து தவ ய​: புத்ரோ வேஸ்²யாக³மநாதி³பி⁴ஸ்தவ ஸம்பத்திம் அபவ்யயிதவாந் தஸ்மிந்நாக³தமாத்ரே தஸ்யைவ நிமித்தம்ʼ புஷ்டம்ʼ கோ³வத்ஸம்ʼ மாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ததா³ தஸ்ய பிதாவோசத், ஹே புத்ர த்வம்ʼ ஸர்வ்வதா³ மயா ஸஹாஸி தஸ்மாந் மம யத்³யதா³ஸ்தே தத்ஸர்வ்வம்ʼ தவ| ");
INSERT INTO santam_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","கிந்து தவாயம்ʼ ப்⁴ராதா ம்ருʼத​: புநரஜீவீத்³ ஹாரிதஸ்²ச பூ⁴த்வா ப்ராப்தோபூ⁴த், ஏதஸ்மாத் காரணாத்³ உத்ஸவாநந்தௌ³ கர்த்தும் உசிதமஸ்மாகம்| ");
INSERT INTO santam_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","அபரஞ்ச யீஸு²​: ஸி²ஷ்யேப்⁴யோந்யாமேகாம்ʼ கதா²ம்ʼ கத²யாமாஸ கஸ்யசித்³ த⁴நவதோ மநுஷ்யஸ்ய க்³ருʼஹகார்ய்யாதீ⁴ஸே² ஸம்பத்தேரபவ்யயே(அ)பவாதி³தே ஸதி ");
INSERT INTO santam_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","தஸ்ய ப்ரபு⁴ஸ்தம் ஆஹூய ஜகா³த³, த்வயி யாமிமாம்ʼ கதா²ம்ʼ ஸ்²ருʼணோமி ஸா கீத்³ருʼஸீ²? த்வம்ʼ க்³ருʼஹகார்ய்யாதீ⁴ஸ²கர்ம்மணோ க³ணநாம்ʼ த³ர்ஸ²ய க்³ருʼஹகார்ய்யாதீ⁴ஸ²பதே³ த்வம்ʼ ந ஸ்தா²ஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ததா³ ஸ க்³ருʼஹகார்ய்யாதீ⁴ஸோ² மநஸா சிந்தயாமாஸ, ப்ரபு⁴ ர்யதி³ மாம்ʼ க்³ருʼஹகார்ய்யாதீ⁴ஸ²பதா³த்³ ப்⁴ரம்ʼஸ²யதி தர்ஹி கிம்ʼ கரிஷ்யே(அ)ஹம்ʼ? ம்ருʼத³ம்ʼ க²நிதும்ʼ மம ஸ²க்தி ர்நாஸ்தி பி⁴க்ஷிதுஞ்ச லஜ்ஜிஷ்யே(அ)ஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","அதஏவ மயி க்³ருʼஹகார்ய்யாதீ⁴ஸ²பதா³த் ச்யுதே ஸதி யதா² லோகா மஹ்யம் ஆஸ்²ரயம்ʼ தா³ஸ்யந்தி தத³ர்த²ம்ʼ யத்கர்ம்ம மயா கரணீயம்ʼ தந் நிர்ணீயதே| ");
INSERT INTO santam_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","பஸ்²சாத் ஸ ஸ்வப்ரபோ⁴ரேகைகம் அத⁴மர்ணம் ஆஹூய ப்ரத²மம்ʼ பப்ரச்ச², த்வத்தோ மே ப்ரபு⁴ணா கதி ப்ராப்யம்? ");
INSERT INTO santam_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","தத​: ஸ உவாச, ஏகஸ²தாட⁴கதைலாநி; ததா³ க்³ருʼஹகார்ய்யாதீ⁴ஸ²​: ப்ரோவாச, தவ பத்ரமாநீய ஸீ²க்⁴ரமுபவிஸ்²ய தத்ர பஞ்சாஸ²தம்ʼ லிக²| ");
INSERT INTO santam_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","பஸ்²சாத³ந்யமேகம்ʼ பப்ரச்ச², த்வத்தோ மே ப்ரபு⁴ணா கதி ப்ராப்யம்? தத​: ஸோவாதீ³த்³ ஏகஸ²தாட⁴ககோ³தூ⁴மா​:; ததா³ ஸ கத²யாமாஸ, தவ பத்ரமாநீய அஸீ²திம்ʼ லிக²| ");
INSERT INTO santam_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","தேநைவ ப்ரபு⁴ஸ்தமயதா²ர்த²க்ருʼதம் அதீ⁴ஸ²ம்ʼ தத்³பு³த்³தி⁴நைபுண்யாத் ப்ரஸ²ஸ²ம்ʼஸ; இத்த²ம்ʼ தீ³ப்திரூபஸந்தாநேப்⁴ய ஏதத்ஸம்ʼஸாரஸ்ய ஸந்தாநா வர்த்தமாநகாலே(அ)தி⁴கபு³த்³தி⁴மந்தோ ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","அதோ வதா³மி யூயமப்யயதா²ர்தே²ந த⁴நேந மித்ராணி லப⁴த்⁴வம்ʼ ததோ யுஷ்மாஸு பத³ப்⁴ரஷ்டேஷ்வபி தாநி சிரகாலம் ஆஸ்²ரயம்ʼ தா³ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ய​: கஸ்²சித் க்ஷுத்³ரே கார்ய்யே விஸ்²வாஸ்யோ ப⁴வதி ஸ மஹதி கார்ய்யேபி விஸ்²வாஸ்யோ ப⁴வதி, கிந்து ய​: கஸ்²சித் க்ஷுத்³ரே கார்ய்யே(அ)விஸ்²வாஸ்யோ ப⁴வதி ஸ மஹதி கார்ய்யேப்யவிஸ்²வாஸ்யோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","அதஏவ அயதா²ர்தே²ந த⁴நேந யதி³ யூயமவிஸ்²வாஸ்யா ஜாதாஸ்தர்ஹி ஸத்யம்ʼ த⁴நம்ʼ யுஷ்மாகம்ʼ கரேஷு க​: ஸமர்பயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","யதி³ ச பரத⁴நேந யூயம் அவிஸ்²வாஸ்யா ப⁴வத² தர்ஹி யுஷ்மாகம்ʼ ஸ்வகீயத⁴நம்ʼ யுஷ்மப்⁴யம்ʼ கோ தா³ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","கோபி தா³ஸ உபௌ⁴ ப்ரபூ⁴ ஸேவிதும்ʼ ந ஸ²க்நோதி, யத ஏகஸ்மிந் ப்ரீயமாணோ(அ)ந்யஸ்மிந்நப்ரீயதே யத்³வா ஏகம்ʼ ஜநம்ʼ ஸமாத்³ருʼத்ய தத³ந்யம்ʼ துச்சீ²கரோதி தத்³வத்³ யூயமபி த⁴நேஸ்²வரௌ ஸேவிதும்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ததை³தா​: ஸர்வ்வா​: கதா²​: ஸ்²ருத்வா லோபி⁴பி²ரூஸி²நஸ்தமுபஜஹஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","தத​: ஸ உவாச, யூயம்ʼ மநுஷ்யாணாம்ʼ நிகடே ஸ்வாந் நிர்தோ³ஷாந் த³ர்ஸ²யத² கிந்து யுஷ்மாகம் அந்த​:கரணாநீஸ்²வரோ ஜாநாதி, யத் மநுஷ்யாணாம் அதி ப்ரஸ²ம்ʼஸ்யம்ʼ தத்³ ஈஸ்²வரஸ்ய க்⁴ருʼண்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","யோஹந ஆக³மநபர்ய்யநதம்ʼ யுஷ்மாகம்ʼ ஸமீபே வ்யவஸ்தா²ப⁴விஷ்யத்³வாதி³நாம்ʼ லேக²நாநி சாஸந் தத​: ப்ரப்⁴ருʼதி ஈஸ்²வரராஜ்யஸ்ய ஸுஸம்ʼவாத³​: ப்ரசரதி, ஏகைகோ லோகஸ்தந்மத்⁴யம்ʼ யத்நேந ப்ரவிஸ²தி ச| ");
INSERT INTO santam_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","வரம்ʼ நப⁴ஸ​: ப்ருʼதி²வ்யாஸ்²ச லோபோ ப⁴விஷ்யதி ததா²பி வ்யவஸ்தா²யா ஏகபி³ந்தோ³ரபி லோபோ ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ய​: கஸ்²சித் ஸ்வீயாம்ʼ பா⁴ர்ய்யாம்ʼ விஹாய ஸ்த்ரியமந்யாம்ʼ விவஹதி ஸ பரதா³ராந் க³ச்ச²தி, யஸ்²ச தா த்யக்தாம்ʼ நாரீம்ʼ விவஹதி ஸோபி பரதா³ராந க³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ஏகோ த⁴நீ மநுஷ்ய​: ஸு²க்லாநி ஸூக்ஷ்மாணி வஸ்த்ராணி பர்ய்யத³தா⁴த் ப்ரதிதி³நம்ʼ பரிதோஷரூபேணாபு⁴ம்ʼக்தாபிவச்ச| ");
INSERT INTO santam_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ஸர்வ்வாங்கே³ க்ஷதயுக்த இலியாஸரநாமா கஸ்²சித்³ த³ரித்³ரஸ்தஸ்ய த⁴நவதோ போ⁴ஜநபாத்ராத் பதிதம் உச்சி²ஷ்டம்ʼ போ⁴க்தும்ʼ வாஞ்ச²ந் தஸ்ய த்³வாரே பதித்வாதிஷ்ட²த்; ");
INSERT INTO santam_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","அத² ஸ்²வாந ஆக³த்ய தஸ்ய க்ஷதாந்யலிஹந்| ");
INSERT INTO santam_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","கியத்காலாத்பரம்ʼ ஸ த³ரித்³ர​: ப்ராணாந் ஜஹௌ; தத​: ஸ்வர்கீ³யதூ³தாஸ்தம்ʼ நீத்வா இப்³ராஹீம​: க்ரோட³ உபவேஸ²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","பஸ்²சாத் ஸ த⁴நவாநபி மமார, தம்ʼ ஸ்²மஸா²நே ஸ்தா²பயாமாஸுஸ்²ச; கிந்து பரலோகே ஸ வேத³நாகுல​: ஸந் ஊர்த்³த்⁴வாம்ʼ நிரீக்ஷ்ய ப³ஹுதூ³ராத்³ இப்³ராஹீமம்ʼ தத்க்ரோட³ இலியாஸரஞ்ச விலோக்ய ருவந்நுவாச; ");
INSERT INTO santam_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ஹே பிதர் இப்³ராஹீம் அநுக்³ருʼஹ்ய அங்கு³ல்யக்³ரபா⁴க³ம்ʼ ஜலே மஜ்ஜயித்வா மம ஜிஹ்வாம்ʼ ஸீ²தலாம்ʼ கர்த்தும் இலியாஸரம்ʼ ப்ரேரய, யதோ வஹ்நிஸி²கா²தோஹம்ʼ வ்யதி²தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ததா³ இப்³ராஹீம் ப³பா⁴ஷே, ஹே புத்ர த்வம்ʼ ஜீவந் ஸம்பத³ம்ʼ ப்ராப்தவாந் இலியாஸரஸ்து விபத³ம்ʼ ப்ராப்தவாந் ஏதத் ஸ்மர, கிந்து ஸம்ப்ரதி தஸ்ய ஸுக²ம்ʼ தவ ச து³​:க²ம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","அபரமபி யுஷ்மாகம் அஸ்மாகஞ்ச ஸ்தா²நயோ ர்மத்⁴யே மஹத்³விச்சே²தோ³(அ)ஸ்தி தத ஏதத்ஸ்தா²நஸ்ய லோகாஸ்தத் ஸ்தா²நம்ʼ யாதும்ʼ யத்³வா தத்ஸ்தா²நஸ்ய லோகா ஏதத் ஸ்தா²நமாயாதும்ʼ ந ஸ²க்நுவந்தி| ");
INSERT INTO santam_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ததா³ ஸ உக்தவாந், ஹே பிதஸ்தர்ஹி த்வாம்ʼ நிவேத³யாமி மம பிது ர்கே³ஹே யே மம பஞ்ச ப்⁴ராதர​: ஸந்தி ");
INSERT INTO santam_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","தே யதை²தத்³ யாதநாஸ்தா²நம்ʼ நாயாஸ்யந்தி ததா² மந்த்ரணாம்ʼ தா³தும்ʼ தேஷாம்ʼ ஸமீபம் இலியாஸரம்ʼ ப்ரேரய| ");
INSERT INTO santam_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","தத இப்³ராஹீம் உவாச, மூஸாப⁴விஷ்யத்³வாதி³நாஞ்ச புஸ்தகாநி தேஷாம்ʼ நிகடே ஸந்தி தே தத்³வசநாநி மந்யந்தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ததா³ ஸ நிவேத³யாமாஸ, ஹே பிதர் இப்³ராஹீம் ந ததா², கிந்து யதி³ ம்ருʼதலோகாநாம்ʼ கஸ்²சித் தேஷாம்ʼ ஸமீபம்ʼ யாதி தர்ஹி தே மநாம்ʼஸி வ்யாகோ⁴டயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","தத இப்³ராஹீம் ஜகா³த³, தே யதி³ மூஸாப⁴விஷ்யத்³வாதி³நாஞ்ச வசநாநி ந மந்யந்தே தர்ஹி ம்ருʼதலோகாநாம்ʼ கஸ்மிம்ʼஸ்²சித்³ உத்தி²தேபி தே தஸ்ய மந்த்ரணாம்ʼ ந மம்ʼஸ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","இத​: பரம்ʼ யீஸு²​: ஸி²ஷ்யாந் உவாச, விக்⁴நைரவஸ்²யம் ஆக³ந்தவ்யம்ʼ கிந்து விக்⁴நா யேந க⁴டிஷ்யந்தே தஸ்ய து³ர்க³தி ர்ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ஏதேஷாம்ʼ க்ஷுத்³ரப்ராணிநாம் ஏகஸ்யாபி விக்⁴நஜநநாத் கண்ட²ப³த்³த⁴பேஷணீகஸ்ய தஸ்ய ஸாக³ராகா³த⁴ஜலே மஜ்ஜநம்ʼ ப⁴த்³ரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","யூயம்ʼ ஸ்வேஷு ஸாவதா⁴நாஸ்திஷ்ட²த; தவ ப்⁴ராதா யதி³ தவ கிஞ்சித்³ அபராத்⁴யதி தர்ஹி தம்ʼ தர்ஜய, தேந யதி³ மந​: பரிவர்த்தயதி தர்ஹி தம்ʼ க்ஷமஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","புநரேகதி³நமத்⁴யே யதி³ ஸ தவ ஸப்தக்ருʼத்வோ(அ)பராத்⁴யதி கிந்து ஸப்தக்ருʼத்வ ஆக³த்ய மந​: பரிவர்த்ய மயாபராத்³த⁴ம் இதி வத³தி தர்ஹி தம்ʼ க்ஷமஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ததா³ ப்ரேரிதா​: ப்ரபு⁴ம் அவத³ந் அஸ்மாகம்ʼ விஸ்²வாஸம்ʼ வர்த்³த⁴ய| ");
INSERT INTO santam_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ப்ரபு⁴ருவாச, யதி³ யுஷ்மாகம்ʼ ஸர்ஷபைகப்ரமாணோ விஸ்²வாஸோஸ்தி தர்ஹி த்வம்ʼ ஸமூலமுத்பாடிதோ பூ⁴த்வா ஸமுத்³ரே ரோபிதோ ப⁴வ கதா²யாம் ஏதஸ்யாம் ஏதது³டு³ம்ப³ராய கதி²தாயாம்ʼ ஸ யுஷ்மாகமாஜ்ஞாவஹோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","அபரம்ʼ ஸ்வதா³ஸே ஹலம்ʼ வாஹயித்வா வா பஸூ²ந் சாரயித்வா க்ஷேத்ராத்³ ஆக³தே ஸதி தம்ʼ வத³தி, ஏஹி போ⁴க்துமுபவிஸ², யுஷ்மாகம் ஏதாத்³ருʼஸ²​: கோஸ்தி? ");
INSERT INTO santam_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","வரஞ்ச பூர்வ்வம்ʼ மம கா²த்³யமாஸாத்³ய யாவத்³ பு⁴ஞ்ஜே பிவாமி ச தாவத்³ ப³த்³த⁴கடி​: பரிசர பஸ்²சாத் த்வமபி போ⁴க்ஷ்யஸே பாஸ்யஸி ச கதா²மீத்³ருʼஸீ²ம்ʼ கிம்ʼ ந வக்ஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","தேந தா³ஸேந ப்ரபோ⁴ராஜ்ஞாநுரூபே கர்ம்மணி க்ருʼதே ப்ரபு⁴​: கிம்ʼ தஸ்மிந் பா³தி⁴தோ ஜாத​:? நேத்த²ம்ʼ பு³த்⁴யதே மயா| ");
INSERT INTO santam_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","இத்த²ம்ʼ நிரூபிதேஷு ஸர்வ்வகர்ம்மஸு க்ருʼதேஷு ஸத்மு யூயமபீத³ம்ʼ வாக்யம்ʼ வத³த², வயம் அநுபகாரிணோ தா³ஸா அஸ்மாபி⁴ர்யத்³யத்கர்த்தவ்யம்ʼ தந்மாத்ரமேவ க்ருʼதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ஸ யிரூஸா²லமி யாத்ராம்ʼ குர்வ்வந் ஸோ²மிரோண்கா³லீல்ப்ரதே³ஸ²மத்⁴யேந க³ச்ச²தி, ");
INSERT INTO santam_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ஏதர்ஹி குத்ரசித்³ க்³ராமே ப்ரவேஸ²மாத்ரே த³ஸ²குஷ்டி²நஸ்தம்ʼ ஸாக்ஷாத் க்ருʼத்வா ");
INSERT INTO santam_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","தூ³ரே திஷ்ட²நத உச்சை ர்வக்துமாரேபி⁴ரே, ஹே ப்ரபோ⁴ யீஸோ² த³யஸ்வாஸ்மாந்| ");
INSERT INTO santam_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","தத​: ஸ தாந் த்³ருʼஷ்ட்வா ஜகா³த³, யூயம்ʼ யாஜகாநாம்ʼ ஸமீபே ஸ்வாந் த³ர்ஸ²யத, ததஸ்தே க³ச்ச²ந்தோ ரோகா³த் பரிஷ்க்ருʼதா​:| ");
INSERT INTO santam_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ததா³ தேஷாமேக​: ஸ்வம்ʼ ஸ்வஸ்த²ம்ʼ த்³ருʼஷ்ட்வா ப்ரோச்சைரீஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந் வ்யாகு⁴ட்யாயாதோ யீஸோ² ர்கு³ணாநநுவத³ந் தச்சரணாதோ⁴பூ⁴மௌ பபாத; ");
INSERT INTO santam_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ஸ சாஸீத் ஸோ²மிரோணீ| ");
INSERT INTO santam_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ததா³ யீஸு²ரவத³த், த³ஸ²ஜநா​: கிம்ʼ ந பரிஷ்க்ருʼதா​:? தஹ்யந்யே நவஜநா​: குத்ர? ");
INSERT INTO santam_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந்தம் ஏநம்ʼ விதே³ஸி²நம்ʼ விநா கோப்யந்யோ ந ப்ராப்யத| ");
INSERT INTO santam_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ததா³ ஸ தமுவாச, த்வமுத்தா²ய யாஹி விஸ்²வாஸஸ்தே த்வாம்ʼ ஸ்வஸ்த²ம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","அத² கதே³ஸ்²வரஸ்ய ராஜத்வம்ʼ ப⁴விஷ்யதீதி பி²ரூஸி²பி⁴​: ப்ருʼஷ்டே ஸ ப்ரத்யுவாச, ஈஸ்²வரஸ்ய ராஜத்வம் ஐஸ்²வர்ய்யத³ர்ஸ²நேந ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","அத ஏதஸ்மிந் பஸ்²ய தஸ்மிந் வா பஸ்²ய, இதி வாக்யம்ʼ லோகா வக்தும்ʼ ந ஸ²க்ஷ்யந்தி, ஈஸ்²வரஸ்ய ராஜத்வம்ʼ யுஷ்மாகம் அந்தரேவாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","தத​: ஸ ஸி²ஷ்யாந் ஜகா³த³, யதா³ யுஷ்மாபி⁴ ர்மநுஜஸுதஸ்ய தி³நமேகம்ʼ த்³ரஷ்டும் வாஞ்சி²ஷ்யதே கிந்து ந த³ர்ஸி²ஷ்யதே, ஈத்³ருʼக்கால ஆயாதி| ");
INSERT INTO santam_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ததா³த்ர பஸ்²ய வா தத்ர பஸ்²யேதி வாக்யம்ʼ லோகா வக்ஷ்யந்தி, கிந்து தேஷாம்ʼ பஸ்²சாத் மா யாத, மாநுக³ச்ச²த ச| ");
INSERT INTO santam_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","யதஸ்தடி³த்³ யதா²காஸை²கதி³ஸ்²யுதி³ய தத³ந்யாமபி தி³ஸ²ம்ʼ வ்யாப்ய ப்ரகாஸ²தே தத்³வத் நிஜதி³நே மநுஜஸூநு​: ப்ரகாஸி²ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","கிந்து தத்பூர்வ்வம்ʼ தேநாநேகாநி து³​:கா²நி போ⁴க்தவ்யாந்யேதத்³வர்த்தமாநலோகைஸ்²ச ஸோ(அ)வஜ்ஞாதவ்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","நோஹஸ்ய வித்³யமாநகாலே யதா²ப⁴வத் மநுஷ்யஸூநோ​: காலேபி ததா² ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","யாவத்காலம்ʼ நோஹோ மஹாபோதம்ʼ நாரோஹத்³ ஆப்லாவிவார்ய்யேத்ய ஸர்வ்வம்ʼ நாநாஸ²யச்ச தாவத்காலம்ʼ யதா² லோகா அபு⁴ஞ்ஜதாபிவந் வ்யவஹந் வ்யவாஹயம்ʼஸ்²ச; ");
INSERT INTO santam_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","இத்த²ம்ʼ லோடோ வர்த்தமாநகாலேபி யதா² லோகா போ⁴ஜநபாநக்ரயவிக்ரயரோபணக்³ருʼஹநிர்ம்மாணகர்ம்மஸு ப்ராவர்த்தந்த, ");
INSERT INTO santam_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","கிந்து யதா³ லோட் ஸிதோ³மோ நிர்ஜகா³ம ததா³ நப⁴ஸ​: ஸக³ந்த⁴காக்³நிவ்ருʼஷ்டி ர்பூ⁴த்வா ஸர்வ்வம்ʼ வ்யநாஸ²யத் ");
INSERT INTO santam_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","தத்³வந் மாநவபுத்ரப்ரகாஸ²தி³நேபி ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ததா³ யதி³ கஸ்²சித்³ க்³ருʼஹோபரி திஷ்ட²தி தர்ஹி ஸ க்³ருʼஹமத்⁴யாத் கிமபி த்³ரவ்யமாநேதும் அவருஹ்ய நைது; யஸ்²ச க்ஷேத்ரே திஷ்ட²தி ஸோபி வ்யாகு⁴ட்ய நாயாது| ");
INSERT INTO santam_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","லோட​: பத்நீம்ʼ ஸ்மரத| ");
INSERT INTO santam_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ய​: ப்ராணாந் ரக்ஷிதும்ʼ சேஷ்டிஷ்யதே ஸ ப்ராணாந் ஹாரயிஷ்யதி யஸ்து ப்ராணாந் ஹாரயிஷ்யதி ஸஏவ ப்ராணாந் ரக்ஷிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","யுஷ்மாநஹம்ʼ வச்மி தஸ்யாம்ʼ ராத்ரௌ ஸ²ய்யைகக³தயோ ர்லோகயோரேகோ தா⁴ரிஷ்யதே பரஸ்த்யக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ஸ்த்ரியௌ யுக³பத் பேஷணீம்ʼ வ்யாவர்த்தயிஷ்யதஸ்தயோரேகா தா⁴ரிஷ்யதே பராத்யக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","புருஷௌ க்ஷேத்ரே ஸ்தா²ஸ்யதஸ்தயோரேகோ தா⁴ரிஷ்யதே பரஸ்த்யக்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ததா³ தே பப்ரச்சு²​:, ஹே ப்ரபோ⁴ குத்ரேத்த²ம்ʼ ப⁴விஷ்யதி? தத​: ஸ உவாச, யத்ர ஸ²வஸ்திஷ்ட²தி தத்ர க்³ருʼத்⁴ரா மிலந்தி| ");
INSERT INTO santam_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","அபரஞ்ச லோகைரக்லாந்தை ர்நிரந்தரம்ʼ ப்ரார்த²யிதவ்யம் இத்யாஸ²யேந யீஸு²நா த்³ருʼஷ்டாந்த ஏக​: கதி²த​:| ");
INSERT INTO santam_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","குத்ரசிந்நக³ரே கஸ்²சித் ப்ராட்³விவாக ஆஸீத் ஸ ஈஸ்²வராந்நாபி³பே⁴த் மாநுஷாம்ʼஸ்²ச நாமந்யத| ");
INSERT INTO santam_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","அத² தத்புரவாஸிநீ காசித்³வித⁴வா தத்ஸமீபமேத்ய விவாதி³நா ஸஹ மம விவாத³ம்ʼ பரிஷ்குர்வ்விதி நிவேத³யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","தத​: ஸ ப்ராட்³விவாக​: கியத்³தி³நாநி ந தத³ங்கீ³க்ருʼதவாந் பஸ்²சாச்சித்தே சிந்தயாமாஸ, யத்³யபீஸ்²வராந்ந பி³பே⁴மி மநுஷ்யாநபி ந மந்யே ");
INSERT INTO santam_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ததா²ப்யேஷா வித⁴வா மாம்ʼ க்லிஸ்²நாதி தஸ்மாத³ஸ்யா விவாத³ம்ʼ பரிஷ்கரிஷ்யாமி நோசேத் ஸா ஸதா³க³த்ய மாம்ʼ வ்யக்³ரம்ʼ கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","பஸ்²சாத் ப்ரபு⁴ரவத³த்³ அஸாவந்யாயப்ராட்³விவாகோ யதா³ஹ தத்ர மநோ நித⁴த்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ஈஸ்²வரஸ்ய யே (அ)பி⁴ருசிதலோகா தி³வாநிஸ²ம்ʼ ப்ரார்த²யந்தே ஸ ப³ஹுதி³நாநி விலம்ப்³யாபி தேஷாம்ʼ விவாதா³ந் கிம்ʼ ந பரிஷ்கரிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","யுஷ்மாநஹம்ʼ வதா³மி த்வரயா பரிஷ்கரிஷ்யதி, கிந்து யதா³ மநுஷ்யபுத்ர ஆக³மிஷ்யதி ததா³ ப்ருʼதி²வ்யாம்ʼ கிமீத்³ருʼஸ²ம்ʼ விஸ்²வாஸம்ʼ ப்ராப்ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","யே ஸ்வாந் தா⁴ர்ம்மிகாந் ஜ்ஞாத்வா பராந் துச்சீ²குர்வ்வந்தி ஏதாத்³ருʼக்³ப்⁴ய​:, கியத்³ப்⁴ய இமம்ʼ த்³ருʼஷ்டாந்தம்ʼ கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ஏக​: பி²ரூஸ்²யபர​: கரஸஞ்சாயீ த்³வாவிமௌ ப்ரார்த²யிதும்ʼ மந்தி³ரம்ʼ க³தௌ| ");
INSERT INTO santam_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ததோ(அ)ஸௌ பி²ரூஸ்²யேகபார்ஸ்²வே திஷ்ட²ந் ஹே ஈஸ்²வர அஹமந்யலோகவத் லோட²யிதாந்யாயீ பாரதா³ரிகஸ்²ச ந ப⁴வாமி அஸ்ய கரஸஞ்சாயிநஸ்துல்யஸ்²ச ந, தஸ்மாத்த்வாம்ʼ த⁴ந்யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ஸப்தஸு தி³நேஷு தி³நத்³வயமுபவஸாமி ஸர்வ்வஸம்பத்தே ர்த³ஸ²மாம்ʼஸ²ம்ʼ த³தா³மி ச, ஏதத்கதா²ம்ʼ கத²யந் ப்ரார்த²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","கிந்து ஸ கரஸஞ்சாயி தூ³ரே திஷ்ட²ந் ஸ்வர்க³ம்ʼ த்³ரஷ்டும்ʼ நேச்ச²ந் வக்ஷஸி கராகா⁴தம்ʼ குர்வ்வந் ஹே ஈஸ்²வர பாபிஷ்ட²ம்ʼ மாம்ʼ த³யஸ்வ, இத்த²ம்ʼ ப்ரார்த²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","யுஷ்மாநஹம்ʼ வதா³மி, தயோர்த்³வயோ ர்மத்⁴யே கேவல​: கரஸஞ்சாயீ புண்யவத்த்வேந க³ணிதோ நிஜக்³ருʼஹம்ʼ ஜகா³ம, யதோ ய​: கஸ்²சித் ஸ்வமுந்நமயதி ஸ நாமயிஷ்யதே கிந்து ய​: கஸ்²சித் ஸ்வம்ʼ நமயதி ஸ உந்நமயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","அத² ஸி²ஸூ²நாம்ʼ கா³த்ரஸ்பர்ஸா²ர்த²ம்ʼ லோகாஸ்தாந் தஸ்ய ஸமீபமாநிந்யு​: ஸி²ஷ்யாஸ்தத்³ த்³ருʼஷ்ட்வாநேத்ருʼந் தர்ஜயாமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","கிந்து யீஸு²ஸ்தாநாஹூய ஜகா³த³, மந்நிகடம் ஆக³ந்தும்ʼ ஸி²ஸூ²ந் அநுஜாநீத்⁴வம்ʼ தாம்ʼஸ்²ச மா வாரயத; யத ஈஸ்²வரராஜ்யாதி⁴காரிண ஏஷாம்ʼ ஸத்³ருʼஸா²​:| ");
INSERT INTO santam_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","அஹம்ʼ யுஷ்மாந் யதா²ர்த²ம்ʼ வதா³மி, யோ ஜந​: ஸி²ஸோ²​: ஸத்³ருʼஸோ² பூ⁴த்வா ஈஸ்²வரராஜ்யம்ʼ ந க்³ருʼஹ்லாதி ஸ கேநாபி ப்ரகாரேண தத் ப்ரவேஷ்டும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","அபரம் ஏகோதி⁴பதிஸ்தம்ʼ பப்ரச்ச², ஹே பரமகு³ரோ, அநந்தாயுஷ​: ப்ராப்தயே மயா கிம்ʼ கர்த்தவ்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","யீஸு²ருவாச, மாம்ʼ குத​: பரமம்ʼ வத³ஸி? ஈஸ்²வரம்ʼ விநா கோபி பரமோ ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","பரதா³ராந் மா க³ச்ச², நரம்ʼ மா ஜஹி, மா சோரய, மித்²யாஸாக்ஷ்யம்ʼ மா தே³ஹி, மாதரம்ʼ பிதரஞ்ச ஸம்ʼமந்யஸ்வ, ஏதா யா ஆஜ்ஞா​: ஸந்தி தாஸ்த்வம்ʼ ஜாநாஸி| ");
INSERT INTO santam_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ததா³ ஸ உவாச, பா³ல்யகாலாத் ஸர்வ்வா ஏதா ஆசராமி| ");
INSERT INTO santam_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","இதி கதா²ம்ʼ ஸ்²ருத்வா யீஸு²ஸ்தமவத³த், ததா²பி தவைகம்ʼ கர்ம்ம ந்யூநமாஸ்தே, நிஜம்ʼ ஸர்வ்வஸ்வம்ʼ விக்ரீய த³ரித்³ரேப்⁴யோ விதர, தஸ்மாத் ஸ்வர்கே³ த⁴நம்ʼ ப்ராப்ஸ்யஸி; தத ஆக³த்ய மமாநுகா³மீ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","கிந்த்வேதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா ஸோதி⁴பதி​: ஸு²ஸோ²ச, யதஸ்தஸ்ய ப³ஹுத⁴நமாஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ததா³ யீஸு²ஸ்தமதிஸோ²காந்விதம்ʼ த்³ருʼஷ்ட்வா ஜகா³த³, த⁴நவதாம் ஈஸ்²வரராஜ்யப்ரவேஸ²​: கீத்³ருʼக்³ து³ஷ்கர​:| ");
INSERT INTO santam_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ஈஸ்²வரராஜ்யே த⁴நிந​: ப்ரவேஸா²த் ஸூசேஸ்²சி²த்³ரேண மஹாங்க³ஸ்ய க³மநாக³மநே ஸுகரே| ");
INSERT INTO santam_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ஸ்²ரோதார​: பப்ரச்சு²ஸ்தர்ஹி கேந பரித்ராணம்ʼ ப்ராப்ஸ்யதே? ");
INSERT INTO santam_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ஸ உக்தவாந், யந் மாநுஷேணாஸ²க்யம்ʼ தத்³ ஈஸ்²வரேண ஸ²க்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ததா³ பிதர உவாச, பஸ்²ய வயம்ʼ ஸர்வ்வஸ்வம்ʼ பரித்யஜ்ய தவ பஸ்²சாத்³கா³மிநோ(அ)ப⁴வாம| ");
INSERT INTO santam_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","தத​: ஸ உவாச, யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, ஈஸ்²வரராஜ்யார்த²ம்ʼ க்³ருʼஹம்ʼ பிதரௌ ப்⁴ராத்ருʼக³ணம்ʼ ஜாயாம்ʼ ஸந்தாநாம்ʼஸ்²ச த்யக்தவா ");
INSERT INTO santam_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","இஹ காலே ததோ(அ)தி⁴கம்ʼ பரகாலே (அ)நந்தாயுஸ்²ச ந ப்ராப்ஸ்யதி லோக ஈத்³ருʼஸ²​: கோபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","அநந்தரம்ʼ ஸ த்³வாத³ஸ²ஸி²ஷ்யாநாஹூய ப³பா⁴ஷே, பஸ்²யத வயம்ʼ யிரூஸா²லம்நக³ரம்ʼ யாம​:, தஸ்மாத் மநுஷ்யபுத்ரே ப⁴விஷ்யத்³வாதி³பி⁴ருக்தம்ʼ யத³ஸ்தி தத³நுரூபம்ʼ தம்ʼ ப்ரதி க⁴டிஷ்யதே; ");
INSERT INTO santam_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","வஸ்துதஸ்து ஸோ(அ)ந்யதே³ஸீ²யாநாம்ʼ ஹஸ்தேஷு ஸமர்பயிஷ்யதே, தே தமுபஹஸிஷ்யந்தி, அந்யாயமாசரிஷ்யந்தி தத்³வபுஷி நிஷ்டீ²வம்ʼ நிக்ஷேப்ஸ்யந்தி, கஸா²பி⁴​: ப்ரஹ்ருʼத்ய தம்ʼ ஹநிஷ்யந்தி ச, ");
INSERT INTO santam_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","கிந்து த்ருʼதீயதி³நே ஸ ஸ்²மஸா²நாத்³ உத்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ஏதஸ்யா​: கதா²யா அபி⁴ப்ராயம்ʼ கிஞ்சித³பி தே போ³த்³து⁴ம்ʼ ந ஸே²கு​: தேஷாம்ʼ நிகடே(அ)ஸ்பஷ்டதவாத் தஸ்யைதாஸாம்ʼ கதா²நாம் ஆஸ²யம்ʼ தே ஜ்ஞாதும்ʼ ந ஸே²குஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","அத² தஸ்மிந் யிரீஹோ​: புரஸ்யாந்திகம்ʼ ப்ராப்தே கஸ்²சித³ந்த⁴​: பத²​: பார்ஸ்²வ உபவிஸ்²ய பி⁴க்ஷாம் அகரோத் ");
INSERT INTO santam_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ஸ லோகஸமூஹஸ்ய க³மநஸ²ப்³த³ம்ʼ ஸ்²ருத்வா தத்காரணம்ʼ ப்ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","நாஸரதீயயீஸு²ர்யாதீதி லோகைருக்தே ஸ உச்சைர்வக்துமாரேபே⁴, ");
INSERT INTO santam_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ஹே தா³யூத³​: ஸந்தாந யீஸோ² மாம்ʼ த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ததோக்³ரகா³மிநஸ்தம்ʼ மௌநீ திஷ்டே²தி தர்ஜயாமாஸு​: கிந்து ஸ புநாருவந் உவாச, ஹே தா³யூத³​: ஸந்தாந மாம்ʼ த³யஸ்வ| ");
INSERT INTO santam_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ததா³ யீஸு²​: ஸ்த²கி³தோ பூ⁴த்வா ஸ்வாந்திகே தமாநேதும் ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","தத​: ஸ தஸ்யாந்திகம் ஆக³மத், ததா³ ஸ தம்ʼ பப்ரச்ச², த்வம்ʼ கிமிச்ச²ஸி? த்வத³ர்த²மஹம்ʼ கிம்ʼ கரிஷ்யாமி? ஸ உக்தவாந், ஹே ப்ரபோ⁴(அ)ஹம்ʼ த்³ரஷ்டும்ʼ லபை⁴| ");
INSERT INTO santam_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ததா³ யீஸு²ருவாச, த்³ருʼஷ்டிஸ²க்திம்ʼ க்³ருʼஹாண தவ ப்ரத்யயஸ்த்வாம்ʼ ஸ்வஸ்த²ம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ததஸ்தத்க்ஷணாத் தஸ்ய சக்ஷுஷீ ப்ரஸந்நே; தஸ்மாத் ஸ ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந் தத்பஸ்²சாத்³ யயௌ, ததா³லோக்ய ஸர்வ்வே லோகா ஈஸ்²வரம்ʼ ப்ரஸ²ம்ʼஸிதும் ஆரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","யதா³ யீஸு² ர்யிரீஹோபுரம்ʼ ப்ரவிஸ்²ய தந்மத்⁴யேந க³ச்ச²ம்ʼஸ்ததா³ ");
INSERT INTO santam_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ஸக்கேயநாமா கரஸஞ்சாயிநாம்ʼ ப்ரதா⁴நோ த⁴நவாநேகோ ");
INSERT INTO santam_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","யீஸு²​: கீத்³ருʼகி³தி த்³ரஷ்டும்ʼ சேஷ்டிதவாந் கிந்து க²ர்வ்வத்வால்லோகஸம்ʼக⁴மத்⁴யே தத்³த³ர்ஸ²நமப்ராப்ய ");
INSERT INTO santam_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","யேந பதா² ஸ யாஸ்யதி தத்பதே²(அ)க்³ரே தா⁴வித்வா தம்ʼ த்³ரஷ்டும் உடு³ம்ப³ரதருமாருரோஹ| ");
INSERT INTO santam_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","பஸ்²சாத்³ யீஸு²ஸ்தத்ஸ்தா²நம் இத்வா ஊர்த்³த்⁴வம்ʼ விலோக்ய தம்ʼ த்³ருʼஷ்ட்வாவாதீ³த், ஹே ஸக்கேய த்வம்ʼ ஸீ²க்⁴ரமவரோஹ மயாத்³ய த்வத்³கே³ஹே வஸ்தவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","தத​: ஸ ஸீ²க்⁴ரமவருஹ்ய ஸாஹ்லாத³ம்ʼ தம்ʼ ஜக்³ராஹ| ");
INSERT INTO santam_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","தத்³ த்³ருʼஷ்ட்வா ஸர்வ்வே விவத³மாநா வக்துமாரேபி⁴ரே, ஸோதிதி²த்வேந து³ஷ்டலோகக்³ருʼஹம்ʼ க³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","கிந்து ஸக்கேயோ த³ண்டா³யமாநோ வக்துமாரேபே⁴, ஹே ப்ரபோ⁴ பஸ்²ய மம யா ஸம்பத்திரஸ்தி தத³ர்த்³த⁴ம்ʼ த³ரித்³ரேப்⁴யோ த³தே³, அபரம் அந்யாயம்ʼ க்ருʼத்வா கஸ்மாத³பி யதி³ கதா³பி கிஞ்சித் மயா க்³ருʼஹீதம்ʼ தர்ஹி தச்சதுர்கு³ணம்ʼ த³தா³மி| ");
INSERT INTO santam_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ததா³ யீஸு²ஸ்தமுக்தவாந் அயமபி இப்³ராஹீம​: ஸந்தாநோ(அ)த​: காரணாத்³ அத்³யாஸ்ய க்³ருʼஹே த்ராணமுபஸ்தி²தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","யத்³ ஹாரிதம்ʼ தத் ம்ருʼக³யிதும்ʼ ரக்ஷிதுஞ்ச மநுஷ்யபுத்ர ஆக³தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","அத² ஸ யிரூஸா²லம​: ஸமீப உபாதிஷ்ட²த்³ ஈஸ்²வரராஜத்வஸ்யாநுஷ்டா²நம்ʼ ததை³வ ப⁴விஷ்யதீதி லோகைரந்வபூ⁴யத, தஸ்மாத் ஸ ஸ்²ரோத்ருʼப்⁴ய​: புநர்த்³ருʼஷ்டாந்தகதா²ம் உத்தா²ப்ய கத²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","கோபி மஹால்லோகோ நிஜார்த²ம்ʼ ராஜத்வபத³ம்ʼ க்³ருʼஹீத்வா புநராக³ந்தும்ʼ தூ³ரதே³ஸ²ம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","யாத்ராகாலே நிஜாந் த³ஸ²தா³ஸாந் ஆஹூய த³ஸ²ஸ்வர்ணமுத்³ரா த³த்த்வா மமாக³மநபர்ய்யந்தம்ʼ வாணிஜ்யம்ʼ குருதேத்யாதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","கிந்து தஸ்ய ப்ரஜாஸ்தமவஜ்ஞாய மநுஷ்யமேநம் அஸ்மாகமுபரி ராஜத்வம்ʼ ந காரயிவ்யாம இமாம்ʼ வார்த்தாம்ʼ தந்நிகடே ப்ரேரயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","அத² ஸ ராஜத்வபத³ம்ʼ ப்ராப்யாக³தவாந் ஏகைகோ ஜநோ பா³ணிஜ்யேந கிம்ʼ லப்³த⁴வாந் இதி ஜ்ஞாதும்ʼ யேஷு தா³ஸேஷு முத்³ரா அர்பயத் தாந் ஆஹூயாநேதும் ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ததா³ ப்ரத²ம ஆக³த்ய கதி²தவாந், ஹே ப்ரபோ⁴ தவ தயைகயா முத்³ரயா த³ஸ²முத்³ரா லப்³தா⁴​:| ");
INSERT INTO santam_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","தத​: ஸ உவாச த்வமுத்தமோ தா³ஸ​: ஸ்வல்பேந விஸ்²வாஸ்யோ ஜாத இத​: காரணாத் த்வம்ʼ த³ஸ²நக³ராணாம் அதி⁴போ ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","த்³விதீய ஆக³த்ய கதி²தவாந், ஹே ப்ரபோ⁴ தவைகயா முத்³ரயா பஞ்சமுத்³ரா லப்³தா⁴​:| ");
INSERT INTO santam_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","தத​: ஸ உவாச, த்வம்ʼ பஞ்சாநாம்ʼ நக³ராணாமதி⁴பதி ர்ப⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ததோந்ய ஆக³த்ய கத²யாமாஸ, ஹே ப்ரபோ⁴ பஸ்²ய தவ யா முத்³ரா அஹம்ʼ வஸ்த்ரே ப³த்³த்⁴வாஸ்தா²பயம்ʼ ஸேயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","த்வம்ʼ க்ருʼபணோ யந்நாஸ்தா²பயஸ்தத³பி க்³ருʼஹ்லாஸி, யந்நாவபஸ்ததே³வ ச சி²நத்ஸி ததோஹம்ʼ த்வத்தோ பீ⁴த​:| ");
INSERT INTO santam_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ததா³ ஸ ஜகா³த³, ரே து³ஷ்டதா³ஸ தவ வாக்யேந த்வாம்ʼ தோ³ஷிணம்ʼ கரிஷ்யாமி, யத³ஹம்ʼ நாஸ்தா²பயம்ʼ ததே³வ க்³ருʼஹ்லாமி, யத³ஹம்ʼ நாவபஞ்ச ததே³வ சி²நத்³மி, ஏதாத்³ருʼஸ²​: க்ருʼபணோஹமிதி யதி³ த்வம்ʼ ஜாநாஸி, ");
INSERT INTO santam_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","தர்ஹி மம முத்³ரா ப³ணிஜாம்ʼ நிகடே குதோ நாஸ்தா²பய​:? தயா க்ருʼதே(அ)ஹம் ஆக³த்ய குஸீதே³ந ஸார்த்³த⁴ம்ʼ நிஜமுத்³ரா அப்ராப்ஸ்யம்| ");
INSERT INTO santam_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","பஸ்²சாத் ஸ ஸமீபஸ்தா²ந் ஜநாந் ஆஜ்ஞாபயத் அஸ்மாத் முத்³ரா ஆநீய யஸ்ய த³ஸ²முத்³ரா​: ஸந்தி தஸ்மை த³த்த| ");
INSERT INTO santam_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","தே ப்ரோசு​: ப்ரபோ⁴(அ)ஸ்ய த³ஸ²முத்³ரா​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","யுஷ்மாநஹம்ʼ வதா³மி யஸ்யாஸ்²ரயே வத்³த⁴தே (அ)தி⁴கம்ʼ தஸ்மை தா³யிஷ்யதே, கிந்து யஸ்யாஸ்²ரயே ந வர்த்³த⁴தே தஸ்ய யத்³யத³ஸ்தி தத³பி தஸ்மாந் நாயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","கிந்து மமாதி⁴பதித்வஸ்ய வஸ²த்வே ஸ்தா²தும் அஸம்மந்யமாநா யே மம ரிபவஸ்தாநாநீய மம ஸமக்ஷம்ʼ ஸம்ʼஹரத| ");
INSERT INTO santam_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","இத்யுபதே³ஸ²கதா²ம்ʼ கத²யித்வா ஸோக்³ரக³​: ஸந் யிரூஸா²லமபுரம்ʼ யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ததோ பை³த்ப²கீ³பை³த²நீயாக்³ராமயோ​: ஸமீபே ஜைதுநாத்³ரேரந்திகம் இத்வா ஸி²ஷ்யத்³வயம் இத்யுக்த்வா ப்ரேஷயாமாஸ, ");
INSERT INTO santam_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","யுவாமமும்ʼ ஸம்முக²ஸ்த²க்³ராமம்ʼ ப்ரவிஸ்²யைவ யம்ʼ கோபி மாநுஷ​: கதா³பி நாரோஹத் தம்ʼ க³ர்த்³த³ப⁴ஸா²வகம்ʼ ப³த்³த⁴ம்ʼ த்³ரக்ஷ்யத²ஸ்தம்ʼ மோசயித்வாநயதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","தத்ர குதோ மோசயத²​:? இதி சேத் கோபி வக்ஷ்யதி தர்ஹி வக்ஷ்யத²​: ப்ரபே⁴ाரத்ர ப்ரயோஜநம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ததா³ தௌ ப்ரரிதௌ க³த்வா தத்கதா²ाநுஸாரேண ஸர்வ்வம்ʼ ப்ராப்தௌ| ");
INSERT INTO santam_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","க³ர்த³ப⁴ஸா²வகமோசநகாலே தத்வாமிந ஊசு​:, க³ர்த³ப⁴ஸா²வகம்ʼ குதோ மோசயத²​:? ");
INSERT INTO santam_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","தாவூசது​: ப்ரபோ⁴ரத்ர ப்ரயோஜநம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","பஸ்²சாத் தௌ தம்ʼ க³ர்த³ப⁴ஸா²வகம்ʼ யீஸோ²ரந்திகமாநீய தத்ப்ருʼஷ்டே² நிஜவஸநாநி பாதயித்வா தது³பரி யீஸு²மாரோஹயாமாஸது​:| ");
INSERT INTO santam_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","அத² யாத்ராகாலே லோகா​: பதி² ஸ்வவஸ்த்ராணி பாதயிதும் ஆரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","அபரம்ʼ ஜைதுநாத்³ரேருபத்யகாம் இத்வா ஸி²ஷ்யஸம்ʼக⁴​: பூர்வ்வத்³ருʼஷ்டாநி மஹாகர்ம்மாணி ஸ்ம்ருʼத்வா, ");
INSERT INTO santam_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","யோ ராஜா ப்ரபோ⁴ ர்நாம்நாயாதி ஸ த⁴ந்ய​: ஸ்வர்கே³ குஸ²லம்ʼ ஸர்வ்வோச்சே ஜயத்⁴வநி ர்ப⁴வது, கதா²மேதாம்ʼ கத²யித்வா ஸாநந்த³ம் உசைரீஸ்²வரம்ʼ த⁴ந்யம்ʼ வக்துமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ததா³ லோகாரண்யமத்⁴யஸ்தா²​: கியந்த​: பி²ரூஸி²நஸ்தத் ஸ்²ருத்வா யீஸு²ம்ʼ ப்ரோசு​:, ஹே உபதே³ஸ²க ஸ்வஸி²ஷ்யாந் தர்ஜய| ");
INSERT INTO santam_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ஸ உவாச, யுஷ்மாநஹம்ʼ வதா³மி யத்³யமீ நீரவாஸ்திஷ்ட²ந்தி தர்ஹி பாஷாணா உசை​: கதா²​: கத²யிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","பஸ்²சாத் தத்புராந்திகமேத்ய தத³வலோக்ய ஸாஸ்²ருபாதம்ʼ ஜகா³த³, ");
INSERT INTO santam_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ஹா ஹா சேத் த்வமக்³ரே(அ)ஜ்ஞாஸ்யதா²​:, தவாஸ்மிந்நேவ தி³நே வா யதி³ ஸ்வமங்க³லம் உபாலப்ஸ்யதா²​:, தர்ஹ்யுத்தமம் அப⁴விஷ்யத், கிந்து க்ஷணேஸ்மிந் தத்தவ த்³ருʼஷ்டேரகோ³சரம் ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","த்வம்ʼ ஸ்வத்ராணகாலே ந மநோ ந்யத⁴த்தா² இதி ஹேதோ ர்யத்காலே தவ ரிபவஸ்த்வாம்ʼ சதுர்தி³க்ஷு ப்ராசீரேண வேஷ்டயித்வா ரோத்ஸ்யந்தி ");
INSERT INTO santam_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","பா³லகை​: ஸார்த்³த⁴ம்ʼ பூ⁴மிஸாத் கரிஷ்யந்தி ச த்வந்மத்⁴யே பாஷாணைகோபி பாஷாணோபரி ந ஸ்தா²ஸ்யதி ச, கால ஈத்³ருʼஸ² உபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","அத² மத்⁴யேமந்தி³ரம்ʼ ப்ரவிஸ்²ய தத்ரத்யாந் க்ரயிவிக்ரயிணோ ப³ஹிஷ்குர்வ்வந் ");
INSERT INTO santam_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","அவத³த் மத்³க்³ருʼஹம்ʼ ப்ரார்த²நாக்³ருʼஹமிதி லிபிராஸ்தே கிந்து யூயம்ʼ ததே³வ சைராணாம்ʼ க³ஹ்வரம்ʼ குருத²| ");
INSERT INTO santam_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","பஸ்²சாத் ஸ ப்ரத்யஹம்ʼ மத்⁴யேமந்தி³ரம் உபதி³தே³ஸ²; தத​: ப்ரதா⁴நயாஜகா அத்⁴யாபகா​: ப்ராசீநாஸ்²ச தம்ʼ நாஸ²யிதும்ʼ சிசேஷ்டிரே; ");
INSERT INTO santam_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","கிந்து தது³பதே³ஸே² ஸர்வ்வே லோகா நிவிஷ்டசித்தா​: ஸ்தி²தாஸ்தஸ்மாத் தே தத்கர்த்தும்ʼ நாவகாஸ²ம்ʼ ப்ராபு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","அதை²கதா³ யீஸு² ர்மநித³ரே ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் லோகாநுபதி³ஸ²தி, ஏதர்ஹி ப்ரதா⁴நயாஜகா அத்⁴யாபகா​: ப்ராஞ்சஸ்²ச தந்நிகடமாக³த்ய பப்ரச்சு²​: ");
INSERT INTO santam_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","கயாஜ்ஞயா த்வம்ʼ கர்ம்மாண்யேதாநி கரோஷி? கோ வா த்வாமாஜ்ஞாபயத்? தத³ஸ்மாந் வத³| ");
INSERT INTO santam_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ஸ ப்ரத்யுவாச, தர்ஹி யுஷ்மாநபி கதா²மேகாம்ʼ ப்ருʼச்சா²மி தஸ்யோத்தரம்ʼ வத³த| ");
INSERT INTO santam_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","யோஹநோ மஜ்ஜநம் ஈஸ்²வரஸ்ய மாநுஷாணாம்ʼ வாஜ்ஞாதோ ஜாதம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ததஸ்தே மிதோ² விவிச்ய ஜக³து³​:, யதீ³ஸ்²வரஸ்ய வதா³மஸ்தர்ஹி தம்ʼ குதோ ந ப்ரத்யைத ஸ இதி வக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","யதி³ மநுஷ்யஸ்யேதி வதா³மஸ்தர்ஹி ஸர்வ்வே லோகா அஸ்மாந் பாஷாணை ர்ஹநிஷ்யந்தி யதோ யோஹந் ப⁴விஷ்யத்³வாதீ³தி ஸர்வ்வே த்³ருʼட⁴ம்ʼ ஜாநந்தி| ");
INSERT INTO santam_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","அதஏவ தே ப்ரத்யூசு​: கஸ்யாஜ்ஞயா ஜாதம் இதி வக்தும்ʼ ந ஸ²க்நும​:| ");
INSERT INTO santam_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ததா³ யீஸு²ரவத³த் தர்ஹி கயாஜ்ஞயா கர்ம்மாண்யேதாதி கரோமீதி ச யுஷ்மாந் ந வக்ஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","அத² லோகாநாம்ʼ ஸாக்ஷாத் ஸ இமாம்ʼ த்³ருʼஷ்டாந்தகதா²ம்ʼ வக்துமாரேபே⁴, கஸ்²சித்³ த்³ராக்ஷாக்ஷேத்ரம்ʼ க்ருʼத்வா தத் க்ஷேத்ரம்ʼ க்ருʼஷீவலாநாம்ʼ ஹஸ்தேஷு ஸமர்ப்ய ப³ஹுகாலார்த²ம்ʼ தூ³ரதே³ஸ²ம்ʼ ஜகா³ம| ");
INSERT INTO santam_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","அத² ப²லகாலே ப²லாநி க்³ரஹீது க்ருʼஷீவலாநாம்ʼ ஸமீபே தா³ஸம்ʼ ப்ராஹிணோத் கிந்து க்ருʼஷீவலாஸ்தம்ʼ ப்ரஹ்ருʼத்ய ரிக்தஹஸ்தம்ʼ விஸஸர்ஜு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","தத​: ஸோதி⁴பதி​: புநரந்யம்ʼ தா³ஸம்ʼ ப்ரேஷயாமாஸ, தே தமபி ப்ரஹ்ருʼத்ய குவ்யவஹ்ருʼத்ய ரிக்தஹஸ்தம்ʼ விஸஸ்ருʼஜு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","தத​: ஸ த்ருʼதீயவாரம் அந்யம்ʼ ப்ராஹிணோத் தே தமபி க்ஷதாங்க³ம்ʼ க்ருʼத்வா ப³ஹி ர்நிசிக்ஷிபு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ததா³ க்ஷேத்ரபதி ர்விசாரயாமாஸ, மமேதா³நீம்ʼ கிம்ʼ கர்த்தவ்யம்ʼ? மம ப்ரியே புத்ரே ப்ரஹிதே தே தமவஸ்²யம்ʼ த்³ருʼஷ்ட்வா ஸமாத³ரிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","கிந்து க்ருʼஷீவலாஸ்தம்ʼ நிரீக்ஷ்ய பரஸ்பரம்ʼ விவிச்ய ப்ரோசு​:, அயமுத்தராதி⁴காரீ ஆக³ச்ச²தைநம்ʼ ஹந்மஸ்ததோதி⁴காரோஸ்மாகம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ததஸ்தே தம்ʼ க்ஷேத்ராத்³ ப³ஹி ர்நிபாத்ய ஜக்⁴நுஸ்தஸ்மாத் ஸ க்ஷேத்ரபதிஸ்தாந் ப்ரதி கிம்ʼ கரிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ஸ ஆக³த்ய தாந் க்ருʼஷீவலாந் ஹத்வா பரேஷாம்ʼ ஹஸ்தேஷு தத்க்ஷேத்ரம்ʼ ஸமர்பயிஷ்யதி; இதி கதா²ம்ʼ ஸ்²ருத்வா தே (அ)வத³ந் ஏதாத்³ருʼஸீ² க⁴டநா ந ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","கிந்து யீஸு²ஸ்தாநவலோக்ய ஜகா³த³, தர்ஹி, ஸ்த²பதய​: கரிஷ்யந்தி க்³ராவாணம்ʼ யந்து துச்ச²கம்ʼ| ப்ரதா⁴நப்ரஸ்தர​: கோணே ஸ ஏவ ஹி ப⁴விஷ்யதி| ஏதஸ்ய ஸா²ஸ்த்ரீயவசநஸ்ய கிம்ʼ தாத்பர்ய்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","அபரம்ʼ தத்பாஷாணோபரி ய​: பதிஷ்யதி ஸ ப⁴ம்ʼக்ஷ்யதே கிந்து யஸ்யோபரி ஸ பாஷாண​: பதிஷ்யதி ஸ தேந தூ⁴லிவச் சூர்ணீப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ஸோஸ்மாகம்ʼ விருத்³த⁴ம்ʼ த்³ருʼஷ்டாந்தமிமம்ʼ கதி²தவாந் இதி ஜ்ஞாத்வா ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச ததை³வ தம்ʼ த⁴ர்தும்ʼ வவாஞ்சு²​: கிந்து லோகேப்⁴யோ பி³ப்⁴யு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","அதஏவ தம்ʼ ப்ரதி ஸதர்கா​: ஸந்த​: கத²ம்ʼ தத்³வாக்யதோ³ஷம்ʼ த்⁴ருʼத்வா தம்ʼ தே³ஸா²தி⁴பஸ்ய ஸாது⁴வேஸ²தா⁴ரிணஸ்²சராந் தஸ்ய ஸமீபே ப்ரேஷயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ததா³ தே தம்ʼ பப்ரச்சு²​:, ஹே உபதே³ஸ²க ப⁴வாந் யதா²ர்த²ம்ʼ கத²யந் உபதி³ஸ²தி, கமப்யநபேக்ஷ்ய ஸத்யத்வேநைஸ்²வரம்ʼ மார்க³முபதி³ஸ²தி, வயமேதஜ்ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","கைஸரராஜாய கரோஸ்மாபி⁴ ர்தே³யோ ந வா? ");
INSERT INTO santam_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ஸ தேஷாம்ʼ வஞ்சநம்ʼ ஜ்ஞாத்வாவத³த் குதோ மாம்ʼ பரீக்ஷத்⁴வே? மாம்ʼ முத்³ராமேகம்ʼ த³ர்ஸ²யத| ");
INSERT INTO santam_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","இஹ லிகி²தா மூர்திரியம்ʼ நாம ச கஸ்ய? தே(அ)வத³ந் கைஸரஸ்ய| ");
INSERT INTO santam_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ததா³ ஸ உவாச, தர்ஹி கைஸரஸ்ய த்³ரவ்யம்ʼ கைஸராய த³த்த; ஈஸ்²வரஸ்ய து த்³ரவ்யமீஸ்²வராய த³த்த| ");
INSERT INTO santam_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","தஸ்மால்லோகாநாம்ʼ ஸாக்ஷாத் தத்கதா²யா​: கமபி தோ³ஷம்ʼ த⁴ர்துமப்ராப்ய தே தஸ்யோத்தராத்³ ஆஸ்²சர்ய்யம்ʼ மந்யமாநா மௌநிநஸ்தஸ்து²​:| ");
INSERT INTO santam_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","அபரஞ்ச ஸ்²மஸா²நாது³த்தா²நாநங்கீ³காரிணாம்ʼ ஸிதூ³கிநாம்ʼ கியந்தோ ஜநா ஆக³த்ய தம்ʼ பப்ரச்சு²​:, ");
INSERT INTO santam_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ஹே உபதே³ஸ²க ஸா²ஸ்த்ரே மூஸா அஸ்மாந் ப்ரதீதி லிலேக² யஸ்ய ப்⁴ராதா பா⁴ர்ய்யாயாம்ʼ ஸத்யாம்ʼ நி​:ஸந்தாநோ ம்ரியதே ஸ தஜ்ஜாயாம்ʼ விவஹ்ய தத்³வம்ʼஸ²ம் உத்பாத³யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ததா²ச கேசித் ஸப்த ப்⁴ராதர ஆஸந் தேஷாம்ʼ ஜ்யேஷ்டோ² ப்⁴ராதா விவஹ்ய நிரபத்ய​: ப்ராணாந் ஜஹௌ| ");
INSERT INTO santam_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","அத² த்³விதீயஸ்தஸ்ய ஜாயாம்ʼ விவஹ்ய நிரபத்ய​: ஸந் மமார| த்ருʼதீயஸ்²ச தாமேவ வ்யுவாஹ; ");
INSERT INTO santam_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","இத்த²ம்ʼ ஸப்த ப்⁴ராதரஸ்தாமேவ விவஹ்ய நிரபத்யா​: ஸந்தோ மம்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ஸே²ஷே ஸா ஸ்த்ரீ ச மமார| ");
INSERT INTO santam_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","அதஏவ ஸ்²மஸா²நாது³த்தா²நகாலே தேஷாம்ʼ ஸப்தஜநாநாம்ʼ கஸ்ய ஸா பா⁴ர்ய்யா ப⁴விஷ்யதி? யத​: ஸா தேஷாம்ʼ ஸப்தாநாமேவ பா⁴ர்ய்யாஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ததா³ யீஸு²​: ப்ரத்யுவாச, ஏதஸ்ய ஜக³தோ லோகா விவஹந்தி வாக்³த³த்தாஸ்²ச ப⁴வந்தி ");
INSERT INTO santam_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","கிந்து யே தஜ்ஜக³த்ப்ராப்தியோக்³யத்வேந க³ணிதாம்ʼ ப⁴விஷ்யந்தி ஸ்²மஸா²நாச்சோத்தா²ஸ்யந்தி தே ந விவஹந்தி வாக்³த³த்தாஸ்²ச ந ப⁴வந்தி, ");
INSERT INTO santam_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","தே புந ர்ந ம்ரியந்தே கிந்து ஸ்²மஸா²நாது³த்தா²பிதா​: ஸந்த ஈஸ்²வரஸ்ய ஸந்தாநா​: ஸ்வர்கீ³யதூ³தாநாம்ʼ ஸத்³ருʼஸா²ஸ்²ச ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","அதி⁴கந்து மூஸா​: ஸ்தம்போ³பாக்²யாநே பரமேஸ்²வர ஈப்³ராஹீம ஈஸ்²வர இஸ்ஹாக ஈஸ்²வரோ யாகூப³ஸ்²சேஸ்²வர இத்யுக்த்வா ம்ருʼதாநாம்ʼ ஸ்²மஸா²நாத்³ உத்தா²நஸ்ய ப்ரமாணம்ʼ லிலேக²| ");
INSERT INTO santam_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","அதஏவ ய ஈஸ்²வர​: ஸ ம்ருʼதாநாம்ʼ ப்ரபு⁴ ர்ந கிந்து ஜீவதாமேவ ப்ரபு⁴​:, தந்நிகடே ஸர்வ்வே ஜீவந்த​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","இதி ஸ்²ருத்வா கியந்தோத்⁴யாபகா ஊசு​:, ஹே உபதே³ஸ²க ப⁴வாந் ப⁴த்³ரம்ʼ ப்ரத்யுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","இத​: பரம்ʼ தம்ʼ கிமபி ப்ரஷ்டம்ʼ தேஷாம்ʼ ப்ரக³ல்ப⁴தா நாபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","பஸ்²சாத் ஸ தாந் உவாச, ய​: க்²ரீஷ்ட​: ஸ தா³யூத³​: ஸந்தாந ஏதாம்ʼ கதா²ம்ʼ லோகா​: கத²ம்ʼ கத²யந்தி? ");
INSERT INTO santam_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","யத​: மம ப்ரபு⁴மித³ம்ʼ வாக்யமவத³த் பரமேஸ்²வர​:| தவ ஸ²த்ரூநஹம்ʼ யாவத் பாத³பீட²ம்ʼ கரோமி ந| தாவத் காலம்ʼ மதீ³யே த்வம்ʼ த³க்ஷபார்ஸ்²வ உபாவிஸ²| ");
INSERT INTO santam_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","இதி கதா²ம்ʼ தா³யூத்³ ஸ்வயம்ʼ கீ³தக்³ரந்தே²(அ)வத³த்| ");
INSERT INTO santam_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","அதஏவ யதி³ தா³யூத்³ தம்ʼ ப்ரபு⁴ம்ʼ வத³தி, தர்ஹி ஸ கத²ம்ʼ தஸ்ய ஸந்தாநோ ப⁴வதி? ");
INSERT INTO santam_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","பஸ்²சாத்³ யீஸு²​: ஸர்வ்வஜநாநாம்ʼ கர்ணகோ³சரே ஸி²ஷ்யாநுவாச, ");
INSERT INTO santam_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","யே(அ)த்⁴யாபகா தீ³ர்க⁴பரிச்ச²த³ம்ʼ பரிதா⁴ய ப்⁴ரமந்தி, ஹட்டாபணயோ ர்நமஸ்காரே ப⁴ஜநகே³ஹஸ்ய ப்ரோச்சாஸநே போ⁴ஜநக்³ருʼஹஸ்ய ப்ரதா⁴நஸ்தா²நே ச ப்ரீயந்தே ");
INSERT INTO santam_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","வித⁴வாநாம்ʼ ஸர்வ்வஸ்வம்ʼ க்³ரஸித்வா ச²லேந தீ³ர்க⁴காலம்ʼ ப்ரார்த²யந்தே ச தேஷு ஸாவதா⁴நா ப⁴வத, தேஷாமுக்³ரத³ண்டோ³ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","அத² த⁴நிலோகா பா⁴ண்டா³கா³ரே த⁴நம்ʼ நிக்ஷிபந்தி ஸ ததே³வ பஸ்²யதி, ");
INSERT INTO santam_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ஏதர்ஹி காசித்³தீ³நா வித⁴வா பணத்³வயம்ʼ நிக்ஷிபதி தத்³ த³த³ர்ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ததோ யீஸு²ருவாச யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, த³ரித்³ரேயம்ʼ வித⁴வா ஸர்வ்வேப்⁴யோதி⁴கம்ʼ ந்யக்ஷேப்ஸீத், ");
INSERT INTO santam_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","யதோந்யே ஸ்வப்ராஜ்யத⁴நேப்⁴ய ஈஸ்²வராய கிஞ்சித் ந்யக்ஷேப்ஸு​:, கிந்து த³ரித்³ரேயம்ʼ வித⁴வா தி³நயாபநார்த²ம்ʼ ஸ்வஸ்ய யத் கிஞ்சித் ஸ்தி²தம்ʼ தத் ஸர்வ்வம்ʼ ந்யக்ஷேப்ஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","அபரஞ்ச உத்தமப்ரஸ்தரைருத்ஸ்ருʼஷ்டவ்யைஸ்²ச மந்தி³ரம்ʼ ஸுஸோ²ப⁴தேதராம்ʼ கைஸ்²சிதி³த்யுக்தே ஸ ப்ரத்யுவாச ");
INSERT INTO santam_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","யூயம்ʼ யதி³த³ம்ʼ நிசயநம்ʼ பஸ்²யத², அஸ்ய பாஷாணைகோப்யந்யபாஷாணோபரி ந ஸ்தா²ஸ்யதி, ஸர்வ்வே பூ⁴ஸாத்³ப⁴விஷ்யந்தி காலோயமாயாதி| ");
INSERT INTO santam_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ததா³ தே பப்ரச்சு²​:, ஹே கு³ரோ க⁴டநேத்³ருʼஸீ² கதா³ ப⁴விஷ்யதி? க⁴டநாயா ஏதஸ்யஸஸ்²சிஹ்நம்ʼ வா கிம்ʼ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ததா³ ஸ ஜகா³த³, ஸாவதா⁴நா ப⁴வத யதா² யுஷ்மாகம்ʼ ப்⁴ரமம்ʼ கோபி ந ஜநயதி, கீ²ஷ்டோஹமித்யுக்த்வா மம நாம்ரா ப³ஹவ உபஸ்தா²ஸ்யந்தி ஸ கால​: ப்ராயேணோபஸ்தி²த​:, தேஷாம்ʼ பஸ்²சாந்மா க³ச்ச²த| ");
INSERT INTO santam_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","யுத்³த⁴ஸ்யோபப்லவஸ்ய ச வார்த்தாம்ʼ ஸ்²ருத்வா மா ஸ²ங்கத்⁴வம்ʼ, யத​: ப்ரத²மம் ஏதா க⁴டநா அவஸ்²யம்ʼ ப⁴விஷ்யந்தி கிந்து நாபாதே யுகா³ந்தோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","அபரஞ்ச கத²யாமாஸ, ததா³ தே³ஸ²ஸ்ய விபக்ஷத்வேந தே³ஸோ² ராஜ்யஸ்ய விபக்ஷத்வேந ராஜ்யம் உத்தா²ஸ்யதி, ");
INSERT INTO santam_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","நாநாஸ்தா²நேஷு மஹாபூ⁴கம்போ து³ர்பி⁴க்ஷம்ʼ மாரீ ச ப⁴விஷ்யந்தி, ததா² வ்யோமமண்ட³லஸ்ய ப⁴யங்கரத³ர்ஸ²நாந்யஸ்²சர்ய்யலக்ஷணாநி ச ப்ரகாஸ²யிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","கிந்து ஸர்வ்வாஸாமேதாஸாம்ʼ க⁴டநாநாம்ʼ பூர்வ்வம்ʼ லோகா யுஷ்மாந் த்⁴ருʼத்வா தாட³யிஷ்யந்தி, ப⁴ஜநாலயே காராயாஞ்ச ஸமர்பயிஷ்யந்தி மம நாமகாரணாத்³ யுஷ்மாந் பூ⁴பாநாம்ʼ ஸா²ஸகாநாஞ்ச ஸம்முக²ம்ʼ நேஷ்யந்தி ச| ");
INSERT INTO santam_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ஸாக்ஷ்யார்த²ம் ஏதாநி யுஷ்மாந் ப்ரதி க⁴டிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ததா³ கிமுத்தரம்ʼ வக்தவ்யம் ஏதத் ந சிந்தயிஷ்யாம இதி மந​:ஸு நிஸ்²சிதநுத| ");
INSERT INTO santam_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","விபக்ஷா யஸ்மாத் கிமப்யுத்தரம் ஆபத்திஞ்ச கர்த்தும்ʼ ந ஸ²க்ஷ்யந்தி தாத்³ருʼஸ²ம்ʼ வாக்படுத்வம்ʼ ஜ்ஞாநஞ்ச யுஷ்மப்⁴யம்ʼ தா³ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","கிஞ்ச யூயம்ʼ பித்ரா மாத்ரா ப்⁴ராத்ரா ப³ந்து⁴நா ஜ்ஞாத்யா குடும்பே³ந ச பரகரேஷு ஸமர்பயிஷ்யத்⁴வே; ததஸ்தே யுஷ்மாகம்ʼ கஞ்சந கஞ்சந கா⁴தயிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","மம நாம்ந​: காரணாத் ஸர்வ்வை ர்மநுஷ்யை ர்யூயம் ருʼதீயிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","கிந்து யுஷ்மாகம்ʼ ஸி²ர​:கேஸை²கோபி ந விநம்ʼக்ஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","தஸ்மாதே³வ தை⁴ர்ய்யமவலம்ப்³ய ஸ்வஸ்வப்ராணாந் ரக்ஷத| ");
INSERT INTO santam_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","அபரஞ்ச யிரூஸா²லம்புரம்ʼ ஸைந்யவேஷ்டிதம்ʼ விலோக்ய தஸ்யோச்சி²ந்நதாயா​: ஸமய​: ஸமீப இத்யவக³மிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ததா³ யிஹூதா³தே³ஸ²ஸ்தா² லோகா​: பர்வ்வதம்ʼ பலாயந்தாம்ʼ, யே ச நக³ரே திஷ்ட²ந்தி தே தே³ஸா²ந்தரம்ʼ பலாயந்தா, யே ச க்³ராமே திஷ்ட²ந்தி தே நக³ரம்ʼ ந ப்ரவிஸ²ந்து, ");
INSERT INTO santam_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","யதஸ்ததா³ ஸமுசிதத³ண்ட³நாய த⁴ர்ம்மபுஸ்தகே யாநி ஸர்வ்வாணி லிகி²தாநி தாநி ஸப²லாநி ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","கிந்து யா யாஸ்ததா³ க³ர்ப⁴வத்ய​: ஸ்தந்யதா³வ்யஸ்²ச தாமாம்ʼ து³ர்க³தி ர்ப⁴விஷ்யதி, யத ஏதால்லோகாந் ப்ரதி கோபோ தே³ஸே² ச விஷமது³ர்க³தி ர்க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","வஸ்துதஸ்து தே க²ங்க³தா⁴ரபரிவ்வங்க³ம்ʼ லப்ஸ்யந்தே ப³த்³தா⁴​: ஸந்த​: ஸர்வ்வதே³ஸே²ஷு நாயிஷ்யந்தே ச கிஞ்சாந்யதே³ஸீ²யாநாம்ʼ ஸமயோபஸ்தி²திபர்ய்யந்தம்ʼ யிரூஸா²லம்புரம்ʼ தை​: பத³தலை ர்த³லயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ஸூர்ய்யசந்த்³ரநக்ஷத்ரேஷு லக்ஷணாதி³ ப⁴விஷ்யந்தி, பு⁴வி ஸர்வ்வதே³ஸீ²யாநாம்ʼ து³​:க²ம்ʼ சிந்தா ச ஸிந்தௌ⁴ வீசீநாம்ʼ தர்ஜநம்ʼ க³ர்ஜநஞ்ச ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","பூ⁴பௌ⁴ பா⁴விக⁴டநாம்ʼ சிந்தயித்வா மநுஜா பி⁴யாம்ருʼதகல்பா ப⁴விஷ்யந்தி, யதோ வ்யோமமண்ட³லே தேஜஸ்விநோ தோ³லாயமாநா ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ததா³ பராக்ரமேணா மஹாதேஜஸா ச மேகா⁴ரூட⁴ம்ʼ மநுஷ்யபுத்ரம் ஆயாந்தம்ʼ த்³ரக்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","கிந்த்வேதாஸாம்ʼ க⁴டநாநாமாரம்பே⁴ ஸதி யூயம்ʼ மஸ்தகாந்யுத்தோல்ய ஊர்த³த்⁴வம்ʼ த்³ரக்ஷ்யத², யதோ யுஷ்மாகம்ʼ முக்தே​: கால​: ஸவிதோ⁴ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ததஸ்தேநைதத்³ருʼஷ்டாந்தகதா² கதி²தா, பஸ்²யத உடு³ம்ப³ராதி³வ்ருʼக்ஷாணாம்ʼ ");
INSERT INTO santam_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","நவீநபத்ராணி ஜாதாநீதி த்³ருʼஷ்ட்வா நிதா³வகால உபஸ்தி²த இதி யதா² யூயம்ʼ ஜ்ஞாதும்ʼ ஸ²க்நுத², ");
INSERT INTO santam_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ததா² ஸர்வ்வாஸாமாஸாம்ʼ க⁴டநாநாம் ஆரம்பே⁴ த்³ருʼஷ்டே ஸதீஸ்²வரஸ்ய ராஜத்வம்ʼ நிகடம் இத்யபி ஜ்ஞாஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, வித்³யமாநலோகாநாமேஷாம்ʼ க³மநாத் பூர்வ்வம் ஏதாநி க⁴டிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","நபோ⁴பு⁴வோர்லோபோ ப⁴விஷ்யதி மம வாக் து கதா³பி லுப்தா ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","அதஏவ விஷமாஸ²நேந பாநேந ச ஸாம்ʼமாரிகசிந்தாபி⁴ஸ்²ச யுஷ்மாகம்ʼ சித்தேஷு மத்தேஷு தத்³தி³நம் அகஸ்மாத்³ யுஷ்மாந் ப்ரதி யதா² நோபதிஷ்ட²தி தத³ர்த²ம்ʼ ஸ்வேஷு ஸாவதா⁴நாஸ்திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ப்ருʼதி²வீஸ்த²ஸர்வ்வலோகாந் ப்ரதி தத்³தி³நம் உந்மாத² இவ உபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","யதா² யூயம் ஏதத்³பா⁴விக⁴டநா உத்தர்த்தும்ʼ மநுஜஸுதஸ்ய ஸம்முகே² ஸம்ʼஸ்தா²துஞ்ச யோக்³யா ப⁴வத² காரணாத³ஸ்மாத் ஸாவதா⁴நா​: ஸந்தோ நிரந்தரம்ʼ ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","அபரஞ்ச ஸ தி³வா மந்தி³ர உபதி³ஸ்²ய ராசை ஜைதுநாத்³ரிம்ʼ க³த்வாதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","தத​: ப்ரத்யூஷே லாகாஸ்தத்கதா²ம்ʼ ஸ்²ரோதும்ʼ மந்தி³ரே தத³ந்திகம் ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","அபரஞ்ச கிண்வஸூ²ந்யபூபோத்ஸவஸ்ய கால உபஸ்தி²தே ");
INSERT INTO santam_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ப்ரதா⁴நயாஜகா அத்⁴யாயகாஸ்²ச யதா² தம்ʼ ஹந்தும்ʼ ஸ²க்நுவந்தி ததோ²பாயாம் அசேஷ்டந்த கிந்து லோகேப்⁴யோ பி³ப்⁴யு​:| ");
INSERT INTO santam_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ஏதஸ்திந் ஸமயே த்³வாத³ஸ²ஸி²ஷ்யேஷு க³ணித ஈஷ்கரியோதீயரூடி⁴மாந் யோ யிஹூதா³ஸ்தஸ்யாந்த​:கரணம்ʼ ஸை²தாநாஸ்²ரிதத்வாத் ");
INSERT INTO santam_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ஸ க³த்வா யதா² யீஸு²ம்ʼ தேஷாம்ʼ கரேஷு ஸமர்பயிதும்ʼ ஸ²க்நோதி ததா² மந்த்ரணாம்ʼ ப்ரதா⁴நயாஜகை​: ஸேநாபதிபி⁴ஸ்²ச ஸஹ சகார| ");
INSERT INTO santam_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","தேந தே துஷ்டாஸ்தஸ்மை முத்³ராம்ʼ தா³தும்ʼ பணம்ʼ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","தத​: ஸோங்கீ³க்ருʼத்ய யதா² லோகாநாமகோ³சரே தம்ʼ பரகரேஷு ஸமர்பயிதும்ʼ ஸ²க்நோதி ததா²வகாஸ²ம்ʼ சேஷ்டிதுமாரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","அத² கிண்வஸூ²ந்யபூபோத்மவதி³நே, அர்தா²த் யஸ்மிந் தி³நே நிஸ்தாரோத்ஸவஸ்ய மேஷோ ஹந்தவ்யஸ்தஸ்மிந் தி³நே ");
INSERT INTO santam_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","யீஸு²​: பிதரம்ʼ யோஹநஞ்சாஹூய ஜகா³த³, யுவாம்ʼ க³த்வாஸ்மாகம்ʼ போ⁴ஜநார்த²ம்ʼ நிஸ்தாரோத்ஸவஸ்ய த்³ரவ்யாண்யாஸாத³யதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ததா³ தௌ பப்ரச்ச²து​: குசாஸாத³யாவோ ப⁴வத​: கேச்சா²? ");
INSERT INTO santam_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ததா³ ஸோவாதீ³த், நக³ரே ப்ரவிஷ்டே கஸ்²சிஜ்ஜலகும்ப⁴மாதா³ய யுவாம்ʼ ஸாக்ஷாத் கரிஷ்யதி ஸ யந்நிவேஸ²நம்ʼ ப்ரவிஸ²தி யுவாமபி தந்நிவேஸ²நம்ʼ தத்பஸ்²சாதி³த்வா நிவேஸ²நபதிம் இதி வாக்யம்ʼ வத³தம்ʼ, ");
INSERT INTO santam_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","யத்ராஹம்ʼ நிஸ்தாரோத்ஸவஸ்ய போ⁴ஜ்யம்ʼ ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ போ⁴க்தும்ʼ ஸ²க்நோமி ஸாதிதி²ஸா²லாा குத்ர? கதா²மிமாம்ʼ ப்ரபு⁴ஸ்த்வாம்ʼ ப்ருʼச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","தத​: ஸ ஜநோ த்³விதீயப்ரகோஷ்டீ²யம் ஏகம்ʼ ஸ²ஸ்தம்ʼ கோஷ்ட²ம்ʼ த³ர்ஸ²யிஷ்யதி தத்ர போ⁴ஜ்யமாஸாத³யதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ததஸ்தௌ க³த்வா தத்³வாக்யாநுஸாரேண ஸர்வ்வம்ʼ த்³ருʼஷ்த்³வா தத்ர நிஸ்தாரோத்ஸவீயம்ʼ போ⁴ஜ்யமாஸாத³யாமாஸது​:| ");
INSERT INTO santam_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","அத² கால உபஸ்தி²தே யீஸு² ர்த்³வாத³ஸ²பி⁴​: ப்ரேரிதை​: ஸஹ போ⁴க்துமுபவிஸ்²ய கதி²தவாந் ");
INSERT INTO santam_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","மம து³​:க²போ⁴கா³த் பூர்வ்வம்ʼ யுபா⁴பி⁴​: ஸஹ நிஸ்தாரோத்ஸவஸ்யைதஸ்ய போ⁴ஜ்யம்ʼ போ⁴க்தும்ʼ மயாதிவாஞ்சா² க்ருʼதா| ");
INSERT INTO santam_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","யுஷ்மாந் வதா³மி, யாவத்காலம் ஈஸ்²வரராஜ்யே போ⁴ஜநம்ʼ ந கரிஷ்யே தாவத்காலம் இத³ம்ʼ ந போ⁴க்ஷ்யே| ");
INSERT INTO santam_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ததா³ ஸ பாநபாத்ரமாதா³ய ஈஸ்²வரஸ்ய கு³ணாந் கீர்த்தயித்வா தேப்⁴யோ த³த்வாவத³த், இத³ம்ʼ க்³ருʼஹ்லீத யூயம்ʼ விப⁴ஜ்ய பிவத| ");
INSERT INTO santam_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","யுஷ்மாந் வதா³மி யாவத்காலம் ஈஸ்²வரராஜத்வஸ்ய ஸம்ʼஸ்தா²பநம்ʼ ந ப⁴வதி தாவத்³ த்³ராக்ஷாப²லரஸம்ʼ ந பாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","தத​: பூபம்ʼ க்³ருʼஹீத்வா ஈஸ்²வரகு³ணாந் கீர்த்தயித்வா ப⁴ங்க்தா தேப்⁴யோ த³த்வாவத³த், யுஷ்மத³ர்த²ம்ʼ ஸமர்பிதம்ʼ யந்மம வபுஸ்ததி³த³ம்ʼ, ஏதத் கர்ம்ம மம ஸ்மரணார்த²ம்ʼ குருத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","அத² போ⁴ஜநாந்தே தாத்³ருʼஸ²ம்ʼ பாத்ரம்ʼ க்³ருʼஹீத்வாவத³த், யுஷ்மத்க்ருʼதே பாதிதம்ʼ யந்மம ரக்தம்ʼ தேந நிர்ணீதநவநியமரூபம்ʼ பாநபாத்ரமித³ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","பஸ்²யத யோ மாம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி ஸ மயா ஸஹ போ⁴ஜநாஸந உபவிஸ²தி| ");
INSERT INTO santam_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","யதா² நிரூபிதமாஸ்தே தத³நுஸாரேணா மநுஷ்யபுुத்ரஸ்ய க³தி ர்ப⁴விஷ்யதி கிந்து யஸ்தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி தஸ்ய ஸந்தாபோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ததா³ தேஷாம்ʼ கோ ஜந ஏதத் கர்ம்ம கரிஷ்யதி தத் தே பரஸ்பரம்ʼ ப்ரஷ்டுமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","அபரம்ʼ தேஷாம்ʼ கோ ஜந​: ஸ்²ரேஷ்ட²த்வேந க³ணயிஷ்யதே, அத்ரார்தே² தேஷாம்ʼ விவாதோ³ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","அஸ்மாத் காரணாத் ஸோவத³த், அந்யதே³ஸீ²யாநாம்ʼ ராஜாந​: ப்ரஜாநாமுபரி ப்ரபு⁴த்வம்ʼ குர்வ்வந்தி தா³ருணஸா²ஸநம்ʼ க்ருʼத்வாபி தே பூ⁴பதித்வேந விக்²யாதா ப⁴வந்தி ச| ");
INSERT INTO santam_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","கிந்து யுஷ்மாகம்ʼ ததா² ந ப⁴விஷ்யதி, யோ யுஷ்மாகம்ʼ ஸ்²ரேஷ்டோ² ப⁴விஷ்யதி ஸ கநிஷ்ட²வத்³ ப⁴வது, யஸ்²ச முக்²யோ ப⁴விஷ்யதி ஸ ஸேவகவத்³ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","போ⁴ஜநோபவிஷ்டபரிசாரகயோ​: க​: ஸ்²ரேஷ்ட²​:? யோ போ⁴ஜநாயோபவிஸ²தி ஸ கிம்ʼ ஸ்²ரேஷ்டோ² ந ப⁴வதி? கிந்து யுஷ்மாகம்ʼ மத்⁴யே(அ)ஹம்ʼ பரிசாரகஇவாஸ்மி| ");
INSERT INTO santam_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","அபரஞ்ச யுயம்ʼ மம பரீக்ஷாகாலே ப்ரத²மமாரப்⁴ய மயா ஸஹ ஸ்தி²தா ");
INSERT INTO santam_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ஏதத்காரணாத் பித்ரா யதா² மத³ர்த²ம்ʼ ராஜ்யமேகம்ʼ நிரூபிதம்ʼ ததா²ஹமபி யுஷ்மத³ர்த²ம்ʼ ராஜ்யம்ʼ நிரூபயாமி| ");
INSERT INTO santam_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","தஸ்மாந் மம ராஜ்யே போ⁴ஜநாஸநே ச போ⁴ஜநபாநே கரிஷ்யத்⁴வே ஸிம்ʼஹாஸநேஷூபவிஸ்²ய சேஸ்ராயேலீயாநாம்ʼ த்³வாத³ஸ²வம்ʼஸா²நாம்ʼ விசாரம்ʼ கரிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","அபரம்ʼ ப்ரபு⁴ருவாச, ஹே ஸி²மோந் பஸ்²ய திதஉநா தா⁴ந்யாநீவ யுஷ்மாந் ஸை²தாந் சாலயிதும் ஐச்ச²த், ");
INSERT INTO santam_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","கிந்து தவ விஸ்²வாஸஸ்ய லோபோ யதா² ந ப⁴வதி ஏதத் த்வத³ர்த²ம்ʼ ப்ரார்தி²தம்ʼ மயா, த்வந்மநஸி பரிவர்த்திதே ச ப்⁴ராத்ருʼணாம்ʼ மநாம்ʼஸி ஸ்தி²ரீகுரு| ");
INSERT INTO santam_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ததா³ ஸோவத³த், ஹே ப்ரபோ⁴ஹம்ʼ த்வயா ஸார்த்³த⁴ம்ʼ காராம்ʼ ம்ருʼதிஞ்ச யாதும்ʼ மஜ்ஜிதோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","தத​: ஸ உவாச, ஹே பிதர த்வாம்ʼ வதா³மி, அத்³ய குக்குடரவாத் பூர்வ்வம்ʼ த்வம்ʼ மத்பரிசயம்ʼ வாரத்ரயம் அபஹ்வோஷ்யஸே| ");
INSERT INTO santam_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","அபரம்ʼ ஸ பப்ரச்ச², யதா³ முத்³ராஸம்புடம்ʼ கா²த்³யபாத்ரம்ʼ பாது³காஞ்ச விநா யுஷ்மாந் ப்ராஹிணவம்ʼ ததா³ யுஷ்மாகம்ʼ கஸ்யாபி ந்யூநதாஸீத்? தே ப்ரோசு​: கஸ்யாபி ந| ");
INSERT INTO santam_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ததா³ ஸோவத³த் கிந்த்விதா³நீம்ʼ முத்³ராஸம்புடம்ʼ கா²த்³யபாத்ரம்ʼ வா யஸ்யாஸ்தி தேந தத்³க்³ரஹீதவ்யம்ʼ, யஸ்ய ச க்ருʼபாணோे நாஸ்தி தேந ஸ்வவஸ்த்ரம்ʼ விக்ரீய ஸ க்ரேதவ்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","யதோ யுஷ்மாநஹம்ʼ வதா³மி, அபராதி⁴ஜநை​: ஸார்த்³த⁴ம்ʼ க³ணித​: ஸ ப⁴விஷ்யதி| இத³ம்ʼ யச்சா²ஸ்த்ரீயம்ʼ வசநம்ʼ லிகி²தமஸ்தி தந்மயி ப²லிஷ்யதி யதோ மம ஸம்ப³ந்தீ⁴யம்ʼ ஸர்வ்வம்ʼ ஸேத்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ததா³ தே ப்ரோசு​: ப்ரபோ⁴ பஸ்²ய இமௌ க்ருʼபாணௌ| தத​: ஸோவத³த்³ ஏதௌ யதே²ஷ்டௌ| ");
INSERT INTO santam_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","அத² ஸ தஸ்மாத்³வஹி ர்க³த்வா ஸ்வாசாராநுஸாரேண ஜைதுநநாமாத்³ரிம்ʼ ஜகா³ம ஸி²ஷ்யாஸ்²ச தத்பஸ்²சாத்³ யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","தத்ரோபஸ்தா²ய ஸ தாநுவாச, யதா² பரீக்ஷாயாம்ʼ ந பதத² தத³ர்த²ம்ʼ ப்ரார்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","பஸ்²சாத் ஸ தஸ்மாத்³ ஏகஸ²ரக்ஷேபாத்³ ப³ஹி ர்க³த்வா ஜாநுநீ பாதயித்வா ஏதத் ப்ரார்த²யாஞ்சக்ரே, ");
INSERT INTO santam_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ஹே பித ர்யதி³ ப⁴வாந் ஸம்மந்யதே தர்ஹி கம்ʼஸமேநம்ʼ மமாந்திகாத்³ தூ³ரய கிந்து மதி³ச்சா²நுரூபம்ʼ ந த்வதி³ச்சா²நுரூபம்ʼ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ததா³ தஸ்மை ஸ²க்திம்ʼ தா³தும்ʼ ஸ்வர்கீ³யதூ³தோ த³ர்ஸ²நம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","பஸ்²சாத் ஸோத்யந்தம்ʼ யாதநயா வ்யாகுலோ பூ⁴த்வா புநர்த்³ருʼட⁴ம்ʼ ப்ரார்த²யாஞ்சக்ரே, தஸ்மாத்³ ப்³ருʼஹச்சோ²ணிதபி³ந்த³வ இவ தஸ்ய ஸ்வேத³பி³ந்த³வ​: ப்ருʼதி²வ்யாம்ʼ பதிதுமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","அத² ப்ரார்த²நாத உத்தா²ய ஸி²ஷ்யாணாம்ʼ ஸமீபமேத்ய தாந் மநோது³​:கி²நோ நித்³ரிதாந் த்³ருʼஷ்ட்வாவத³த் ");
INSERT INTO santam_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","குதோ நித்³ராத²? பரீக்ஷாயாம் அபதநார்த²ம்ʼ ப்ரர்த²யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ஏதத்கதா²யா​: கத²நகாலே த்³வாத³ஸ²ஸி²ஷ்யாணாம்ʼ மத்⁴யே க³ணிதோ யிஹூதா³நாமா ஜநதாஸஹிதஸ்தேஷாம் அக்³ரே சலித்வா யீஸோ²ஸ்²சும்ப³நார்த²ம்ʼ தத³ந்திகம் ஆயயௌ| ");
INSERT INTO santam_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ததா³ யீஸு²ருவாச, ஹே யிஹூதா³ கிம்ʼ சும்ப³நேந மநுஷ்யபுத்ரம்ʼ பரகரேஷு ஸமர்பயஸி? ");
INSERT INTO santam_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ததா³ யத்³யத்³ க⁴டிஷ்யதே தத³நுமாய ஸங்கி³பி⁴ருக்தம்ʼ, ஹே ப்ரபோ⁴ வயம்ʼ கி க²ங்கே³ந கா⁴தயிஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","தத ஏக​: கரவாலேநாஹத்ய ப்ரதா⁴நயாஜகஸ்ய தா³ஸஸ்ய த³க்ஷிணம்ʼ கர்ணம்ʼ சிச்சே²த³| ");
INSERT INTO santam_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","அதூ⁴நா நிவர்த்தஸ்வ இத்யுக்த்வா யீஸு²ஸ்தஸ்ய ஸ்²ருதிம்ʼ ஸ்ப்ருʼஷ்ட்வா ஸ்வஸ்யம்ʼ சகார| ");
INSERT INTO santam_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","பஸ்²சாத்³ யீஸு²​: ஸமீபஸ்தா²ந் ப்ரதா⁴நயாஜகாந் மந்தி³ரஸ்ய ஸேநாபதீந் ப்ராசீநாம்ʼஸ்²ச ஜகா³த³, யூயம்ʼ க்ருʼபாணாந் யஷ்டீம்ʼஸ்²ச க்³ருʼஹீத்வா மாம்ʼ கிம்ʼ சோரம்ʼ த⁴ர்த்துமாயாதா​:? ");
INSERT INTO santam_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","யதா³ஹம்ʼ யுஷ்மாபி⁴​: ஸஹ ப்ரதிதி³நம்ʼ மந்தி³ரே(அ)திஷ்ட²ம்ʼ ததா³ மாம்ʼ த⁴ர்த்தம்ʼ ந ப்ரவ்ருʼத்தா​:, கிந்த்விதா³நீம்ʼ யுஷ்மாகம்ʼ ஸமயோந்த⁴காரஸ்ய சாதி⁴பத்யமஸ்தி| ");
INSERT INTO santam_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","அத² தே தம்ʼ த்⁴ருʼத்வா மஹாயாஜகஸ்ய நிவேஸ²நம்ʼ நிந்யு​:| தத​: பிதரோ தூ³ரே தூ³ரே பஸ்²சாதி³த்வா ");
INSERT INTO santam_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ப்³ருʼஹத்கோஷ்ட²ஸ்ய மத்⁴யே யத்ராக்³நிம்ʼ ஜ்வாலயித்வா லோகா​: ஸமேத்யோபவிஷ்டாஸ்தத்ர தை​: ஸார்த்³த⁴ம் உபவிவேஸ²| ");
INSERT INTO santam_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","அத² வஹ்நிஸந்நிதௌ⁴ ஸமுபவேஸ²காலே காசித்³தா³ஸீ மநோ நிவிஸ்²ய தம்ʼ நிரீக்ஷ்யாவத³த் புமாநயம்ʼ தஸ்ய ஸங்கே³(அ)ஸ்தா²த்| ");
INSERT INTO santam_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","கிந்து ஸ தத்³ அபஹ்நுத்யாவாதீ³த் ஹே நாரி தமஹம்ʼ ந பரிசிநோமி| ");
INSERT INTO santam_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","க்ஷணாந்தரே(அ)ந்யஜநஸ்தம்ʼ த்³ருʼஷ்ட்வாப்³ரவீத் த்வமபி தேஷாம்ʼ நிகரஸ்யைகஜநோஸி| பிதர​: ப்ரத்யுவாச ஹே நர நாஹமஸ்மி| ");
INSERT INTO santam_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","தத​: ஸார்த்³த⁴த³ண்ட³த்³வயாத் பரம்ʼ புநரந்யோ ஜநோ நிஸ்²சித்ய ப³பா⁴ஷே, ஏஷ தஸ்ய ஸங்கீ³தி ஸத்யம்ʼ யதோயம்ʼ கா³லீலீயோ லோக​:| ");
INSERT INTO santam_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ததா³ பிதர உவாச ஹே நர த்வம்ʼ யத்³ வத³மி தத³ஹம்ʼ போ³த்³து⁴ம்ʼ ந ஸ²க்நோமி, இதி வாக்யே கதி²தமாத்ரே குக்குடோ ருராவ| ");
INSERT INTO santam_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ததா³ ப்ரபு⁴ணா வ்யாது⁴ட்ய பிதரே நிரீக்ஷிதே க்ருʼகவாகுரவாத் பூர்வ்வம்ʼ மாம்ʼ த்ரிரபஹ்நோஷ்யஸே இதி பூர்வ்வோக்தம்ʼ தஸ்ய வாக்யம்ʼ பிதர​: ஸ்ம்ருʼத்வா ");
INSERT INTO santam_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ப³ஹிர்க³த்வா மஹாகே²தே³ந சக்ரந்த³| ");
INSERT INTO santam_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ததா³ யை ர்யீஸு²ர்த்⁴ருʼதஸ்தே தமுபஹஸ்ய ப்ரஹர்த்துமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","வஸ்த்ரேண தஸ்ய த்³ருʼஸௌ² ப³த்³த்⁴வா கபோலே சபேடாகா⁴தம்ʼ க்ருʼத்வா பப்ரச்சு²​:, கஸ்தே கபோலே சபேடாகா⁴தம்ʼ க்ருʼதவாந? க³ணயித்வா தத்³ வத³| ");
INSERT INTO santam_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","தத³ந்யத் தத்³விருத்³த⁴ம்ʼ ப³ஹுநிந்தா³வாக்யம்ʼ வக்துமாரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","அத² ப்ரபா⁴தே ஸதி லோகப்ராஞ்ச​: ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச ஸபா⁴ம்ʼ க்ருʼத்வா மத்⁴யேஸப⁴ம்ʼ யீஸு²மாநீய பப்ரச்சு²​:, த்வம் அபி⁴ஷிகதோஸி ந வாஸ்மாந் வத³| ");
INSERT INTO santam_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ஸ ப்ரத்யுவாச, மயா தஸ்மிந்நுக்தே(அ)பி யூயம்ʼ ந விஸ்²வஸிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","கஸ்மிம்ʼஸ்²சித்³வாக்யே யுஷ்மாந் ப்ருʼஷ்டே(அ)பி மாம்ʼ ந தது³த்தரம்ʼ வக்ஷ்யத² ந மாம்ʼ த்யக்ஷ்யத² ச| ");
INSERT INTO santam_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","கிந்த்வித​: பரம்ʼ மநுஜஸுத​: ஸர்வ்வஸ²க்திமத ஈஸ்²வரஸ்ய த³க்ஷிணே பார்ஸ்²வே ஸமுபவேக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ததஸ்தே பப்ரச்சு²​:, ர்திஹ த்வமீஸ்²வரஸ்ய புத்ர​:? ஸ கத²யாமாஸ, யூயம்ʼ யதா²ர்த²ம்ʼ வத³த² ஸ ஏவாஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ததா³ தே ஸர்வ்வே கத²யாமாஸு​:, ர்திஹ ஸாக்ஷ்யே(அ)ந்ஸஸ்மிந் அஸ்மாகம்ʼ கிம்ʼ ப்ரயோஜநம்ʼ? அஸ்ய ஸ்வமுகா²தே³வ ஸாக்ஷ்யம்ʼ ப்ராப்தம்| ");
INSERT INTO santam_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","தத​: ஸபா⁴ஸ்தா²​: ஸர்வ்வலோகா உத்தா²ய தம்ʼ பீலாதஸம்முக²ம்ʼ நீத்வாப்ரோத்³ய வக்துமாரேபி⁴ரே, ");
INSERT INTO santam_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ஸ்வமபி⁴ஷிக்தம்ʼ ராஜாநம்ʼ வத³ந்தம்ʼ கைமரராஜாய கரதா³நம்ʼ நிஷேத⁴ந்தம்ʼ ராஜ்யவிபர்ய்யயம்ʼ குர்த்தும்ʼ ப்ரவர்த்தமாநம் ஏந ப்ராப்தா வயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ததா³ பீலாதஸ்தம்ʼ ப்ருʼஷ்டவாந் த்வம்ʼ கிம்ʼ யிஹூதீ³யாநாம்ʼ ராஜா? ஸ ப்ரத்யுவாச த்வம்ʼ ஸத்யமுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ததா³ பீலாத​: ப்ரதா⁴நயாஜகாதி³லோகாந் ஜகா³த்³, அஹமேதஸ்ய கமப்யபராத⁴ம்ʼ நாப்தவாந்| ");
INSERT INTO santam_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ததஸ்தே புந​: ஸாஹமிநோ பூ⁴த்வாவத³ந், ஏஷ கா³லீல ஏதத்ஸ்தா²நபர்ய்யந்தே ஸர்வ்வஸ்மிந் யிஹூதா³தே³ஸே² ஸர்வ்வால்லோகாநுபதி³ஸ்²ய குப்ரவ்ருʼத்திம்ʼ க்³ராஹீதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ததா³ பீலாதோ கா³லீலப்ரதே³ஸ²ஸ்ய நாம ஸ்²ருத்வா பப்ரச்ச², கிமயம்ʼ கா³லீலீயோ லோக​:? ");
INSERT INTO santam_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","தத​: ஸ கா³லீல்ப்ரதே³ஸீ²யஹேரோத்³ராஜஸ்ய ததா³ ஸ்தி²தேஸ்தஸ்ய ஸமீபே யீஸு²ம்ʼ ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ததா³ ஹேரோத்³ யீஸு²ம்ʼ விலோக்ய ஸந்துதோஷ, யத​: ஸ தஸ்ய ப³ஹுவ்ருʼத்தாந்தஸ்²ரவணாத் தஸ்ய கிஞி्சதா³ஸ்²சர்ய்யகர்ம்ம பஸ்²யதி இத்யாஸா²ம்ʼ க்ருʼத்வா ப³ஹுகாலமாரப்⁴ய தம்ʼ த்³ரஷ்டும்ʼ ப்ரயாஸம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","தஸ்மாத் தம்ʼ ப³ஹுகதா²​: பப்ரச்ச² கிந்து ஸ தஸ்ய கஸ்யாபி வாக்யஸ்ய ப்ரத்யுத்தரம்ʼ நோவாச| ");
INSERT INTO santam_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","அத² ப்ரதா⁴நயாஜகா அத்⁴யாபகாஸ்²ச ப்ரோத்திஷ்ட²ந்த​: ஸாஹஸேந தமபவதி³தும்ʼ ப்ராரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ஹேரோத்³ தஸ்ய ஸேநாக³ணஸ்²ச தமவஜ்ஞாய உபஹாஸத்வேந ராஜவஸ்த்ரம்ʼ பரிதா⁴ப்ய புந​: பீலாதம்ʼ ப்ரதி தம்ʼ ப்ராஹிணோத்| ");
INSERT INTO santam_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","பூர்வ்வம்ʼ ஹேரோத்³பீலாதயோ​: பரஸ்பரம்ʼ வைரபா⁴வ ஆஸீத் கிந்து தத்³தி³நே த்³வயோ ர்மேலநம்ʼ ஜாதம்| ");
INSERT INTO santam_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","பஸ்²சாத் பீலாத​: ப்ரதா⁴நயாஜகாந் ஸா²ஸகாந் லோகாம்ʼஸ்²ச யுக³பதா³ஹூய ப³பா⁴ஷே, ");
INSERT INTO santam_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ராஜ்யவிபர்ய்யயகாரகோயம் இத்யுக்த்வா மநுஷ்யமேநம்ʼ மம நிகடமாநைஷ்ட கிந்து பஸ்²யத யுஷ்மாகம்ʼ ஸமக்ஷம் அஸ்ய விசாரம்ʼ க்ருʼத்வாபி ப்ரோக்தாபவாதா³நுரூபேணாஸ்ய கோப்யபராத⁴​: ஸப்ரமாணோ ந ஜாத​:, ");
INSERT INTO santam_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","யூயஞ்ச ஹேரோத³​: ஸந்நிதௌ⁴ ப்ரேஷிதா மயா தத்ராஸ்ய கோப்யபராத⁴ஸ்தேநாபி ந ப்ராப்த​:| பஸ்²யதாநேந வத⁴ஹேेதுகம்ʼ கிமபி நாபராத்³த⁴ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","தஸ்மாதே³நம்ʼ தாட³யித்வா விஹாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","தத்ரோத்ஸவே தேஷாமேகோ மோசயிதவ்ய​:| ");
INSERT INTO santam_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","இதி ஹேதோஸ்தே ப்ரோச்சைரேகதா³ ப்ரோசு​:, ஏநம்ʼ தூ³ரீக்ருʼத்ய ப³ரப்³பா³நாமாநம்ʼ மோசய| ");
INSERT INTO santam_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ஸ ப³ரப்³பா³ நக³ர உபப்லவவதா⁴பராதா⁴ப்⁴யாம்ʼ காராயாம்ʼ ப³த்³த⁴ ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","கிந்து பீலாதோ யீஸு²ம்ʼ மோசயிதும்ʼ வாஞ்ச²ந் புநஸ்தாநுவாச| ");
INSERT INTO santam_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ததா²ப்யேநம்ʼ க்ருஸே² வ்யத⁴ க்ருஸே² வ்யதே⁴தி வத³ந்தஸ்தே ருருவு​:| ");
INSERT INTO santam_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","தத​: ஸ த்ருʼதீயவாரம்ʼ ஜகா³த³ குத​:? ஸ கிம்ʼ கர்ம்ம க்ருʼதவாந்? நாஹமஸ்ய கமபி வதா⁴பராத⁴ம்ʼ ப்ராப்த​: கேவலம்ʼ தாட³யித்வாமும்ʼ த்யஜாமி| ");
INSERT INTO santam_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ததா²பி தே புநரேநம்ʼ க்ருஸே² வ்யத⁴ இத்யுக்த்வா ப்ரோச்சைர்த்³ருʼட⁴ம்ʼ ப்ரார்த²யாஞ்சக்ரிரே; ");
INSERT INTO santam_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","தத​: ப்ரதா⁴நயாஜகாதீ³நாம்ʼ கலரவே ப்ரப³லே ஸதி தேஷாம்ʼ ப்ரார்த²நாரூபம்ʼ கர்த்தும்ʼ பீலாத ஆதி³தே³ஸ²| ");
INSERT INTO santam_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ராஜத்³ரோஹவத⁴யோரபராதே⁴ந காராஸ்த²ம்ʼ யம்ʼ ஜநம்ʼ தே யயாசிரே தம்ʼ மோசயித்வா யீஸு²ம்ʼ தேஷாமிச்சா²யாம்ʼ ஸமார்பயத்| ");
INSERT INTO santam_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","அத² தே யீஸு²ம்ʼ க்³ருʼஹீத்வா யாந்தி, ஏதர்ஹி க்³ராமாதா³க³தம்ʼ ஸி²மோநநாமாநம்ʼ குரீணீயம்ʼ ஜநம்ʼ த்⁴ருʼத்வா யீஸோ²​: பஸ்²சாந்நேதும்ʼ தஸ்ய ஸ்கந்தே⁴ க்ருஸ²மர்பயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ததோ லோाகாரண்யமத்⁴யே ப³ஹுஸ்த்ரியோ ருத³த்யோ விலபந்த்யஸ்²ச யீஸோ²​: பஸ்²சாத்³ யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","கிந்து ஸ வ்யாகு⁴ட்ய தா உவாச, ஹே யிரூஸா²லமோ நார்ய்யோ யுயம்ʼ மத³ர்த²ம்ʼ ந ருதி³த்வா ஸ்வார்த²ம்ʼ ஸ்வாபத்யார்த²ஞ்ச ருதி³தி; ");
INSERT INTO santam_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","பஸ்²யத ய​: கதா³பி க³ர்ப⁴வத்யோ நாப⁴வந் ஸ்தந்யஞ்ச நாபாயயந் தாத்³ருʼஸீ² ர்வந்த்⁴யா யதா³ த⁴ந்யா வக்ஷ்யந்தி ஸ கால ஆயாதி| ");
INSERT INTO santam_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ததா³ ஹே ஸை²லா அஸ்மாகமுபரி பதத, ஹே உபஸை²லா அஸ்மாநாச்சா²த³யத கதா²மீத்³ருʼஸீ²ம்ʼ லோகா வக்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","யத​: ஸதேஜஸி ஸா²கி²நி சேதே³தத்³ க⁴டதே தர்ஹி ஸு²ஷ்கஸா²கி²நி கிம்ʼ ந க⁴டிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ததா³ தே ஹந்தும்ʼ த்³வாவபராதி⁴நௌ தேந ஸார்த்³த⁴ம்ʼ நிந்யு​:| ");
INSERT INTO santam_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","அபரம்ʼ ஸி²ர​:கபாலநாமகஸ்தா²நம்ʼ ப்ராப்ய தம்ʼ க்ருஸே² விவிது⁴​:; தத்³த்³வயோரபராதி⁴நோரேகம்ʼ தஸ்ய த³க்ஷிணோ தத³ந்யம்ʼ வாமே க்ருஸே² விவிது⁴​:| ");
INSERT INTO santam_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ததா³ யீஸு²ரகத²யத், ஹே பிதரேதாந் க்ஷமஸ்வ யத ஏதே யத் கர்ம்ம குர்வ்வந்தி தந் ந விது³​:; பஸ்²சாத்தே கு³டிகாபாதம்ʼ க்ருʼத்வா தஸ்ய வஸ்த்ராணி விப⁴ஜ்ய ஜக்³ருʼஹு​:| ");
INSERT INTO santam_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","தத்ர லோகஸம்ʼக⁴ஸ்திஷ்ட²ந் த³த³ர்ஸ²; தே தேஷாம்ʼ ஸா²ஸகாஸ்²ச தமுபஹஸ்ய ஜக³து³​:, ஏஷ இதராந் ரக்ஷிதவாந் யதீ³ஸ்²வரேணாபி⁴ருசிதோ (அ)பி⁴ஷிக்தஸ்த்ராதா ப⁴வதி தர்ஹி ஸ்வமது⁴நா ரக்ஷது| ");
INSERT INTO santam_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","தத³ந்ய​: ஸேநாக³ணா ஏத்ய தஸ்மை அம்லரஸம்ʼ த³த்வா பரிஹஸ்ய ப்ரோவாச, ");
INSERT INTO santam_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","சேத்த்வம்ʼ யிஹூதீ³யாநாம்ʼ ராஜாஸி தர்ஹி ஸ்வம்ʼ ரக்ஷ| ");
INSERT INTO santam_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","யிஹூதீ³யாநாம்ʼ ராஜேதி வாக்யம்ʼ யூநாநீயரோமீயேப்³ரீயாக்ஷரை ர்லிகி²தம்ʼ தச்சி²ரஸ ஊர்த்³த்⁴வே(அ)ஸ்தா²ப்யத| ");
INSERT INTO santam_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ததோ³ப⁴யபார்ஸ்²வயோ ர்வித்³தௌ⁴ யாவபராதி⁴நௌ தயோரேகஸ்தம்ʼ விநிந்த்³ய ப³பா⁴ஷே, சேத்த்வம் அபி⁴ஷிக்தோஸி தர்ஹி ஸ்வமாவாஞ்ச ரக்ஷ| ");
INSERT INTO santam_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","கிந்த்வந்யஸ்தம்ʼ தர்ஜயித்வாவத³த், ஈஸ்²வராத்தவ கிஞ்சித³பி ப⁴யம்ʼ நாஸ்தி கிம்ʼ? த்வமபி ஸமாநத³ண்டோ³ஸி, ");
INSERT INTO santam_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","யோக்³யபாத்ரே ஆவாம்ʼ ஸ்வஸ்வகர்ம்மணாம்ʼ ஸமுசிதப²லம்ʼ ப்ராப்நுவ​: கிந்த்வநேந கிமபி நாபராத்³த⁴ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","அத² ஸ யீஸு²ம்ʼ ஜகா³த³ ஹே ப்ரபே⁴ ப⁴வாந் ஸ்வராஜ்யப்ரவேஸ²காலே மாம்ʼ ஸ்மரது| ");
INSERT INTO santam_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ததா³ யீஸு²​: கதி²தவாந் த்வாம்ʼ யதா²ர்த²ம்ʼ வதா³மி த்வமத்³யைவ மயா ஸார்த்³த⁴ம்ʼ பரலோகஸ்ய ஸுக²ஸ்தா²நம்ʼ ப்ராப்ஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","அபரஞ்ச த்³விதீயயாமாத் த்ருʼதீயயாமபர்ய்யந்தம்ʼ ரவேஸ்தேஜஸோந்தர்ஹிதத்வாத் ஸர்வ்வதே³ஸோ²(அ)ந்த⁴காரேணாவ்ருʼதோ ");
INSERT INTO santam_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","மந்தி³ரஸ்ய யவநிகா ச சி²த்³யமாநா த்³விதா⁴ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ததோ யீஸு²ருச்சைருவாச, ஹே பித ர்மமாத்மாநம்ʼ தவ கரே ஸமர்பயே, இத்யுக்த்வா ஸ ப்ராணாந் ஜஹௌ| ");
INSERT INTO santam_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ததை³தா க⁴டநா த்³ருʼஷ்ட்வா ஸ²தஸேநாபதிரீஸ்²வரம்ʼ த⁴ந்யமுக்த்வா கதி²தவாந் அயம்ʼ நிதாந்தம்ʼ ஸாது⁴மநுஷ்ய ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","அத² யாவந்தோ லோகா த்³ரஷ்டும் ஆக³தாஸ்தே தா க⁴டநா த்³ருʼஷ்ட்வா வக்ஷ​:ஸு கராகா⁴தம்ʼ க்ருʼத்வா வ்யாசுட்ய க³தா​:| ");
INSERT INTO santam_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","யீஸோ² ர்ஜ்ஞாதயோ யா யா யோஷிதஸ்²ச கா³லீலஸ்தேந ஸார்த்³த⁴மாயாதாஸ்தா அபி தூ³ரே ஸ்தி²த்வா தத் ஸர்வ்வம்ʼ த³த்³ருʼஸு²​:| ");
INSERT INTO santam_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ததா³ யிஹூதீ³யாநாம்ʼ மந்த்ரணாம்ʼ க்ரியாஞ்சாஸம்மந்யமாந ஈஸ்²வரஸ்ய ராஜத்வம் அபேக்ஷமாணோ ");
INSERT INTO santam_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","யிஹூதி³தே³ஸீ²யோ (அ)ரிமதீ²யநக³ரீயோ யூஷப்²நாமா மந்த்ரீ ப⁴த்³ரோ தா⁴ர்ம்மிகஸ்²ச புமாந் ");
INSERT INTO santam_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","பீலாதாந்திகம்ʼ க³த்வா யீஸோ² ர்தே³ஹம்ʼ யயாசே| ");
INSERT INTO santam_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","பஸ்²சாத்³ வபுரவரோஹ்ய வாஸஸா ஸம்ʼவேஷ்ட்ய யத்ர கோபி மாநுஷோ நாஸ்தா²ப்யத தஸ்மிந் ஸை²லே ஸ்வாதே ஸ்²மஸா²நே தத³ஸ்தா²பயத்| ");
INSERT INTO santam_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","தத்³தி³நமாயோஜநீயம்ʼ தி³நம்ʼ விஸ்²ராமவாரஸ்²ச ஸமீப​:| ");
INSERT INTO santam_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","அபரம்ʼ யீஸு²நா ஸார்த்³த⁴ம்ʼ கா³லீல ஆக³தா யோஷித​: பஸ்²சாதி³த்வா ஸ்²மஸா²நே தத்ர யதா² வபு​: ஸ்தா²பிதம்ʼ தச்ச த்³ருʼஷ்ட்வா ");
INSERT INTO santam_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","வ்யாகு⁴ட்ய ஸுக³ந்தி⁴த்³ரவ்யதைலாநி க்ருʼத்வா விதி⁴வத்³ விஸ்²ராமவாரே விஸ்²ராமம்ʼ சக்ரு​:| ");
INSERT INTO santam_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","அத² ஸப்தாஹப்ரத²மதி³நே(அ)திப்ரத்யூஷே தா யோஷித​: ஸம்பாதி³தம்ʼ ஸுக³ந்தி⁴த்³ரவ்யம்ʼ க்³ருʼஹீத்வா தத³ந்யாபி⁴​: கியதீபி⁴​: ஸ்த்ரீபி⁴​: ஸஹ ஸ்²மஸா²நம்ʼ யயு​:| ");
INSERT INTO santam_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","கிந்து ஸ்²மஸா²நத்³வாராத் பாஷாணமபஸாரிதம்ʼ த்³ருʼஷ்ட்வா ");
INSERT INTO santam_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","தா​: ப்ரவிஸ்²ய ப்ரபோ⁴ ர்தே³ஹமப்ராப்ய ");
INSERT INTO santam_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","வ்யாகுலா ப⁴வந்தி ஏதர்ஹி தேஜோமயவஸ்த்ராந்விதௌ த்³வௌ புருஷௌ தாஸாம்ʼ ஸமீபே ஸமுபஸ்தி²தௌ ");
INSERT INTO santam_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","தஸ்மாத்தா​: ஸ²ங்காயுக்தா பூ⁴மாவதோ⁴முக்²யஸ்யஸ்து²​:| ததா³ தௌ தா ஊசது ர்ம்ருʼதாநாம்ʼ மத்⁴யே ஜீவந்தம்ʼ குதோ ம்ருʼக³யத²? ");
INSERT INTO santam_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ஸோத்ர நாஸ்தி ஸ உத³ஸ்தா²த்| ");
INSERT INTO santam_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","பாபிநாம்ʼ கரேஷு ஸமர்பிதேந க்ருஸே² ஹதேந ச மநுஷ்யபுத்ரேண த்ருʼதீயதி³வஸே ஸ்²மஸா²நாது³த்தா²தவ்யம் இதி கதா²ம்ʼ ஸ க³லீலி திஷ்ட²ந் யுஷ்மப்⁴யம்ʼ கதி²தவாந் தாம்ʼ ஸ்மரத| ");
INSERT INTO santam_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ததா³ தஸ்ய ஸா கதா² தாஸாம்ʼ மந​:ஸு ஜாதா| ");
INSERT INTO santam_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","அநந்தரம்ʼ ஸ்²மஸா²நாத்³ க³த்வா தா ஏகாத³ஸ²ஸி²ஷ்யாதி³ப்⁴ய​: ஸர்வ்வேப்⁴யஸ்தாம்ʼ வார்த்தாம்ʼ கத²யாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","மக்³த³லீநீமரியம், யோஹநா, யாகூபோ³ மாதா மரியம் தத³ந்யா​: ஸங்கி³ந்யோ யோஷிதஸ்²ச ப்ரேரிதேப்⁴ய ஏதா​: ஸர்வ்வா வார்த்தா​: கத²யாமாஸு​: ");
INSERT INTO santam_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","கிந்து தாஸாம்ʼ கதா²ம் அநர்த²காக்²யாநமாத்ரம்ʼ பு³த்³த்⁴வா கோபி ந ப்ரத்யைத்| ");
INSERT INTO santam_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ததா³ பிதர உத்தா²ய ஸ்²மஸா²நாந்திகம்ʼ த³தா⁴வ, தத்ர ச ப்ரஹ்வோ பூ⁴த்வா பார்ஸ்²வைகஸ்தா²பிதம்ʼ கேவலம்ʼ வஸ்த்ரம்ʼ த³த³ர்ஸ²; தஸ்மாதா³ஸ்²சர்ய்யம்ʼ மந்யமாநோ யத³க⁴டத தந்மநஸி விசாரயந் ப்ரதஸ்தே²| ");
INSERT INTO santam_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","தஸ்மிந்நேவ தி³நே த்³வௌ ஸி²ய்யௌ யிரூஸா²லமஸ்²சதுஷ்க்ரோஸா²ந்தரிதம் இம்மாயுக்³ராமம்ʼ க³ச்ச²ந்தௌ ");
INSERT INTO santam_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","தாஸாம்ʼ க⁴டநாநாம்ʼ கதா²மகத²யதாம்ʼ ");
INSERT INTO santam_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","தயோராலாபவிசாரயோ​: காலே யீஸு²ராக³த்ய தாப்⁴யாம்ʼ ஸஹ ஜகா³ம ");
INSERT INTO santam_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","கிந்து யதா² தௌ தம்ʼ ந பரிசிநுதஸ்தத³ர்த²ம்ʼ தயோ ர்த்³ருʼஷ்டி​: ஸம்ʼருத்³தா⁴| ");
INSERT INTO santam_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ஸ தௌ ப்ருʼஷ்டவாந் யுவாம்ʼ விஷண்ணௌ கிம்ʼ விசாரயந்தௌ க³ச்ச²த²​:? ");
INSERT INTO santam_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ததஸ்தயோ​: க்லியபாநாமா ப்ரத்யுவாச யிரூஸா²லமபுரே(அ)து⁴நா யாந்யக⁴டந்த த்வம்ʼ கேவலவிதே³ஸீ² கிம்ʼ தத்³வ்ருʼத்தாந்தம்ʼ ந ஜாநாஸி? ");
INSERT INTO santam_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ஸ பப்ரச்ச² கா க⁴டநா​:? ததா³ தௌ வக்துமாரேபா⁴தே யீஸு²நாமா யோ நாஸரதீயோ ப⁴விஷ்யத்³வாதீ³ ஈஸ்²வரஸ்ய மாநுஷாணாஞ்ச ஸாக்ஷாத் வாக்யே கர்ம்மணி ச ஸ²க்திமாநாஸீத் ");
INSERT INTO santam_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","தம் அஸ்மாகம்ʼ ப்ரதா⁴நயாஜகா விசாரகாஸ்²ச கேநாபி ப்ரகாரேண க்ருஸே² வித்³த்⁴வா தஸ்ய ப்ராணாநநாஸ²யந் ததீ³யா க⁴டநா​:; ");
INSERT INTO santam_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","கிந்து ய இஸ்ராயேலீயலோகாந் உத்³தா⁴ரயிஷ்யதி ஸ ஏவாயம் இத்யாஸா²ஸ்மாபி⁴​: க்ருʼதா| தத்³யதா² ததா²ஸ்து தஸ்யா க⁴டநாயா அத்³ய தி³நத்ரயம்ʼ க³தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","அதி⁴கந்த்வஸ்மாகம்ʼ ஸங்கி³நீநாம்ʼ கியத்ஸ்த்ரீணாம்ʼ முகே²ப்⁴யோ(அ)ஸம்ப⁴வவாக்யமித³ம்ʼ ஸ்²ருதம்ʼ; ");
INSERT INTO santam_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","தா​: ப்ரத்யூஷே ஸ்²மஸா²நம்ʼ க³த்வா தத்ர தஸ்ய தே³ஹம் அப்ராப்ய வ்யாகு⁴ட்யேத்வா ப்ரோக்தவத்ய​: ஸ்வர்கீ³ஸதூ³தௌ த்³ருʼஷ்டாவஸ்மாபி⁴ஸ்தௌ சாவாதி³ஷ்டாம்ʼ ஸ ஜீவிதவாந்| ");
INSERT INTO santam_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ததோஸ்மாகம்ʼ கைஸ்²சித் ஸ்²மஸா²நமக³ம்யத தே(அ)பி ஸ்த்ரீணாம்ʼ வாக்யாநுரூபம்ʼ த்³ருʼஷ்டவந்த​: கிந்து தம்ʼ நாபஸ்²யந்| ");
INSERT INTO santam_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ததா³ ஸ தாவுவாச, ஹே அபோ³தௌ⁴ ஹே ப⁴விஷ்யத்³வாதி³பி⁴ருக்தவாக்யம்ʼ ப்ரத்யேதும்ʼ விலம்ப³மாநௌ; ");
INSERT INTO santam_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ஏதத்ஸர்வ்வது³​:க²ம்ʼ பு⁴க்த்வா ஸ்வபூ⁴திப்ராப்தி​: கிம்ʼ க்²ரீஷ்டஸ்ய ந ந்யாய்யா? ");
INSERT INTO santam_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","தத​: ஸ மூஸாக்³ரந்த²மாரப்⁴ய ஸர்வ்வப⁴விஷ்யத்³வாதி³நாம்ʼ ஸர்வ்வஸா²ஸ்த்ரே ஸ்வஸ்மிந் லிகி²தாக்²யாநாபி⁴ப்ராயம்ʼ போ³த⁴யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","அத² க³ம்யக்³ராமாப்⁴யர்ணம்ʼ ப்ராப்ய தேநாக்³ரே க³மநலக்ஷணே த³ர்ஸி²தே ");
INSERT INTO santam_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","தௌ ஸாத⁴யித்வாவத³தாம்ʼ ஸஹாவாப்⁴யாம்ʼ திஷ்ட² தி³நே க³தே ஸதி ராத்ரிரபூ⁴த்; தத​: ஸ தாப்⁴யாம்ʼ ஸார்த்³த⁴ம்ʼ ஸ்தா²தும்ʼ க்³ருʼஹம்ʼ யயௌ| ");
INSERT INTO santam_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","பஸ்²சாத்³போ⁴ஜநோபவேஸ²காலே ஸ பூபம்ʼ க்³ருʼஹீத்வா ஈஸ்²வரகு³ணாந் ஜகா³த³ தஞ்ச ப⁴ம்ʼக்த்வா தாப்⁴யாம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ததா³ தயோ ர்த்³ருʼஷ்டௌ ப்ரஸந்நாயாம்ʼ தம்ʼ ப்ரத்யபி⁴ஜ்ஞது​: கிந்து ஸ தயோ​: ஸாக்ஷாத³ந்தர்த³தே⁴| ");
INSERT INTO santam_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ததஸ்தௌ மிதோ²பி⁴தா⁴தும் ஆரப்³த⁴வந்தௌ க³மநகாலே யதா³ கதா²மகத²யத் ஸா²ஸ்த்ரார்த²ஞ்சபோ³த⁴யத் ததா³வயோ ர்பு³த்³தி⁴​: கிம்ʼ ந ப்ராஜ்வலத்? ");
INSERT INTO santam_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","தௌ தத்க்ஷணாது³த்தா²ய யிரூஸா²லமபுரம்ʼ ப்ரத்யாயயது​:, தத்ஸ்தா²நே ஸி²ஷ்யாணாம் ஏகாத³ஸா²நாம்ʼ ஸங்கி³நாஞ்ச த³ர்ஸ²நம்ʼ ஜாதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","தே ப்ரோசு​: ப்ரபு⁴ருத³திஷ்ட²த்³ இதி ஸத்யம்ʼ ஸி²மோநே த³ர்ஸ²நமதா³ச்ச| ");
INSERT INTO santam_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","தத​: பத²​: ஸர்வ்வக⁴டநாயா​: பூபப⁴ஞ்ஜநேந தத்பரிசயஸ்ய ச ஸர்வ்வவ்ருʼத்தாந்தம்ʼ தௌ வக்துமாரேபா⁴தே| ");
INSERT INTO santam_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","இத்த²ம்ʼ தே பரஸ்பரம்ʼ வத³ந்தி தத்காலே யீஸு²​: ஸ்வயம்ʼ தேஷாம்ʼ மத்⁴ய ப்ரோத்த²ய யுஷ்மாகம்ʼ கல்யாணம்ʼ பூ⁴யாத்³ இத்யுவாச, ");
INSERT INTO santam_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","கிந்து பூ⁴தம்ʼ பஸ்²யாம இத்யநுமாய தே ஸமுத்³விவிஜிரே த்ரேஷுஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ஸ உவாச, குதோ து³​:கி²தா ப⁴வத²? யுஷ்மாகம்ʼ மந​:ஸு ஸந்தே³ஹ உதே³தி ச குத​:? ");
INSERT INTO santam_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ஏஷோஹம்ʼ, மம கரௌ பஸ்²யத வரம்ʼ ஸ்ப்ருʼஷ்ட்வா பஸ்²யத, மம யாத்³ருʼஸா²நி பஸ்²யத² தாத்³ருʼஸா²நி பூ⁴தஸ்ய மாம்ʼஸாஸ்தீ²நி ந ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","இத்யுக்த்வா ஸ ஹஸ்தபாதா³ந் த³ர்ஸ²யாமாஸ| ");
INSERT INTO santam_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","தே(அ)ஸம்ப⁴வம்ʼ ஜ்ஞாத்வா ஸாநந்தா³ ந ப்ரத்யயந்| தத​: ஸ தாந் பப்ரச்ச², அத்ர யுஷ்மாகம்ʼ ஸமீபே கா²த்³யம்ʼ கிஞ்சித³ஸ்தி? ");
INSERT INTO santam_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ததஸ்தே கியத்³த³க்³த⁴மத்ஸ்யம்ʼ மது⁴ ச த³து³​: ");
INSERT INTO santam_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ஸ ததா³தா³ய தேஷாம்ʼ ஸாக்ஷாத்³ பு³பு⁴ஜே ");
INSERT INTO santam_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","கத²யாமாஸ ச மூஸாவ்யவஸ்தா²யாம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு கீ³தபுஸ்தகே ச மயி யாநி ஸர்வ்வாணி வசநாநி லிகி²தாநி தத³நுரூபாணி க⁴டிஷ்யந்தே யுஷ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ ஸ்தி²த்வாஹம்ʼ யதே³தத்³வாக்யம் அவத³ம்ʼ ததி³தா³நீம்ʼ ப்ரத்யக்ஷமபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","அத² தேப்⁴ய​: ஸா²ஸ்த்ரபோ³தா⁴தி⁴காரம்ʼ த³த்வாவத³த், ");
INSERT INTO santam_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","க்²ரீஷ்டேநேத்த²ம்ʼ ம்ருʼதியாதநா போ⁴க்தவ்யா த்ருʼதீயதி³நே ச ஸ்²மஸா²நாது³த்தா²தவ்யஞ்சேதி லிபிரஸ்தி; ");
INSERT INTO santam_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","தந்நாம்நா யிரூஸா²லமமாரப்⁴ய ஸர்வ்வதே³ஸே² மந​:பராவர்த்தநஸ்ய பாபமோசநஸ்ய ச ஸுஸம்ʼவாத³​: ப்ரசாரயிதவ்ய​:, ");
INSERT INTO santam_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ஏஷு ஸர்வ்வேஷு யூயம்ʼ ஸாக்ஷிண​:| ");
INSERT INTO santam_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","அபரஞ்ச பஸ்²யத பித்ரா யத் ப்ரதிஜ்ஞாதம்ʼ தத் ப்ரேஷயிஷ்யாமி, அதஏவ யாவத்காலம்ʼ யூயம்ʼ ஸ்வர்கீ³யாம்ʼ ஸ²க்திம்ʼ ந ப்ராப்ஸ்யத² தாவத்காலம்ʼ யிரூஸா²லம்நக³ரே திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","அத² ஸ தாந் பை³த²நீயாபர்ய்யந்தம்ʼ நீத்வா ஹஸ்தாவுத்தோல்ய ஆஸி²ஷ வக்துமாரேபே⁴ ");
INSERT INTO santam_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ஆஸி²ஷம்ʼ வத³ந்நேவ ச தேப்⁴ய​: ப்ருʼத²க்³ பூ⁴த்வா ஸ்வர்கா³ய நீதோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ததா³ தே தம்ʼ ப⁴ஜமாநா மஹாநந்தே³ந யிரூஸா²லமம்ʼ ப்ரத்யாஜக்³மு​:| ");
INSERT INTO santam_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ததோ நிரந்தரம்ʼ மந்தி³ரே திஷ்ட²ந்த ஈஸ்²வரஸ்ய ப்ரஸ²ம்ʼஸாம்ʼ த⁴ந்யவாத³ஞ்ச கர்த்தம் ஆரேபி⁴ரே| இதி||");
INSERT INTO santam_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ஆதௌ³ வாத³ ஆஸீத் ஸ ச வாத³ ஈஸ்²வரேண ஸார்த⁴மாஸீத் ஸ வாத³​: ஸ்வயமீஸ்²வர ஏவ| ");
INSERT INTO santam_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ஸ ஆதா³வீஸ்²வரேண ஸஹாஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","தேந ஸர்வ்வம்ʼ வஸ்து ஸஸ்ருʼஜே ஸர்வ்வேஷு ஸ்ருʼஷ்டவஸ்துஷு கிமபி வஸ்து தேநாஸ்ருʼஷ்டம்ʼ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ஸ ஜீவநஸ்யாகார​:, தச்ச ஜீவநம்ʼ மநுஷ்யாணாம்ʼ ஜ்யோதி​: ");
INSERT INTO santam_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","தஜ்ஜ்யோதிரந்த⁴காரே ப்ரசகாஸே² கிந்த்வந்த⁴காரஸ்தந்ந ஜக்³ராஹ| ");
INSERT INTO santam_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","யோஹந் நாமக ஏகோ மநுஜ ஈஸ்²வரேண ப்ரேஷயாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","தத்³வாரா யதா² ஸர்வ்வே விஸ்²வஸந்தி தத³ர்த²ம்ʼ ஸ தஜ்ஜ்யோதிஷி ப்ரமாணம்ʼ தா³தும்ʼ ஸாக்ஷிஸ்வரூபோ பூ⁴த்வாக³மத், ");
INSERT INTO santam_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ஸ ஸ்வயம்ʼ தஜ்ஜ்யோதி ர்ந கிந்து தஜ்ஜ்யோதிஷி ப்ரமாணம்ʼ தா³துமாக³மத்| ");
INSERT INTO santam_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ஜக³த்யாக³த்ய ய​: ஸர்வ்வமநுஜேப்⁴யோ தீ³ப்திம்ʼ த³தா³தி ததே³வ ஸத்யஜ்யோதி​:| ");
INSERT INTO santam_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ஸ யஜ்ஜக³த³ஸ்ருʼஜத் தந்மத்³ய ஏவ ஸ ஆஸீத் கிந்து ஜக³தோ லோகாஸ்தம்ʼ நாஜாநந்| ");
INSERT INTO santam_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","நிஜாதி⁴காரம்ʼ ஸ ஆக³ச்ச²த் கிந்து ப்ரஜாஸ்தம்ʼ நாக்³ருʼஹ்லந்| ");
INSERT INTO santam_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ததா²பி யே யே தமக்³ருʼஹ்லந் அர்தா²த் தஸ்ய நாம்நி வ்யஸ்²வஸந் தேப்⁴ய ஈஸ்²வரஸ்ய புத்ரா ப⁴விதும் அதி⁴காரம் அத³தா³த்| ");
INSERT INTO santam_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","தேஷாம்ʼ ஜநி​: ஸோ²ணிதாந்ந ஸா²ரீரிகாபி⁴லாஷாந்ந மாநவாநாமிச்சா²தோ ந கிந்த்வீஸ்²வராத³ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ஸ வாதோ³ மநுஷ்யரூபேணாவதீர்ய்ய ஸத்யதாநுக்³ரஹாப்⁴யாம்ʼ பரிபூர்ண​: ஸந் ஸார்த⁴ம் அஸ்மாபி⁴ ர்ந்யவஸத் தத​: பிதுரத்³விதீயபுத்ரஸ்ய யோக்³யோ யோ மஹிமா தம்ʼ மஹிமாநம்ʼ தஸ்யாபஸ்²யாம| ");
INSERT INTO santam_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ததோ யோஹநபி ப்ரசார்ய்ய ஸாக்ஷ்யமித³ம்ʼ த³த்தவாந் யோ மம பஸ்²சாத்³ ஆக³மிஷ்யதி ஸ மத்தோ கு³ருதர​:; யதோ மத்பூர்வ்வம்ʼ ஸ வித்³யமாந ஆஸீத்; யத³ர்த²ம் அஹம்ʼ ஸாக்ஷ்யமித³ம் அதா³ம்ʼ ஸ ஏஷ​:| ");
INSERT INTO santam_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","அபரஞ்ச தஸ்ய பூர்ணதாயா வயம்ʼ ஸர்வ்வே க்ரமஸ²​: க்ரமஸோ²நுக்³ரஹம்ʼ ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","மூஸாத்³வாரா வ்யவஸ்தா² த³த்தா கிந்த்வநுக்³ரஹ​: ஸத்யத்வஞ்ச யீஸு²க்²ரீஷ்டத்³வாரா ஸமுபாதிஷ்ட²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","கோபி மநுஜ ஈஸ்²வரம்ʼ கதா³பி நாபஸ்²யத் கிந்து பிது​: க்ரோட³ஸ்தோ²(அ)த்³விதீய​: புத்ரஸ்தம்ʼ ப்ரகாஸ²யத்| ");
INSERT INTO santam_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","த்வம்ʼ க​:? இதி வாக்யம்ʼ ப்ரேஷ்டும்ʼ யதா³ யிஹூதீ³யலோகா யாஜகாந் லேவிலோகாம்ʼஸ்²ச யிரூஸா²லமோ யோஹந​: ஸமீபே ப்ரேஷயாமாஸு​:, ");
INSERT INTO santam_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ததா³ ஸ ஸ்வீக்ருʼதவாந் நாபஹ்நூதவாந் நாஹம் அபி⁴ஷிக்த இத்யங்கீ³க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ததா³ தே(அ)ப்ருʼச்ச²ந் தர்ஹி கோ ப⁴வாந்? கிம்ʼ ஏலிய​:? ஸோவத³த் ந; ததஸ்தே(அ)ப்ருʼச்ச²ந் தர்ஹி ப⁴வாந் ஸ ப⁴விஷ்யத்³வாதீ³? ஸோவத³த் நாஹம்ʼ ஸ​:| ");
INSERT INTO santam_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ததா³ தே(அ)ப்ருʼச்ச²ந் தர்ஹி ப⁴வாந் க​:? வயம்ʼ க³த்வா ப்ரேரகாந் த்வயி கிம்ʼ வக்ஷ்யாம​:? ஸ்வஸ்மிந் கிம்ʼ வத³ஸி? ");
INSERT INTO santam_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ததா³ ஸோவத³த்| பரமேஸ²ஸ்ய பந்தா²நம்ʼ பரிஷ்குருத ஸர்வ்வத​:| இதீத³ம்ʼ ப்ராந்தரே வாக்யம்ʼ வத³த​: கஸ்யசித்³ரவ​:| கதா²மிமாம்ʼ யஸ்மிந் யிஸ²யியோ ப⁴விஷ்யத்³வாதீ³ லிகி²தவாந் ஸோஹம்| ");
INSERT INTO santam_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","யே ப்ரேஷிதாஸ்தே பி²ரூஸி²லோகா​:| ");
INSERT INTO santam_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ததா³ தே(அ)ப்ருʼச்ச²ந் யதி³ நாபி⁴ஷிக்தோஸி ஏலியோஸி ந ஸ ப⁴விஷ்யத்³வாத்³யபி நாஸி ச, தர்ஹி லோகாந் மஜ்ஜயஸி குத​:? ");
INSERT INTO santam_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ததோ யோஹந் ப்ரத்யவோசத், தோயே(அ)ஹம்ʼ மஜ்ஜயாமீதி ஸத்யம்ʼ கிந்து யம்ʼ யூயம்ʼ ந ஜாநீத² தாத்³ருʼஸ² ஏகோ ஜநோ யுஷ்மாகம்ʼ மத்⁴ய உபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ஸ மத்பஸ்²சாத்³ ஆக³தோபி மத்பூர்வ்வம்ʼ வர்த்தமாந ஆஸீத் தஸ்ய பாது³காப³ந்த⁴நம்ʼ மோசயிதுமபி நாஹம்ʼ யோக்³யோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","யர்த்³த³நநத்³யா​: பாரஸ்த²பை³த²பா³ராயாம்ʼ யஸ்மிந்ஸ்தா²நே யோஹநமஜ்ஜயத் தஸ்மிந ஸ்தா²நே ஸர்வ்வமேதத்³ அக⁴டத| ");
INSERT INTO santam_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","பரே(அ)ஹநி யோஹந் ஸ்வநிகடமாக³ச்ச²ந்தம்ʼ யிஸு²ம்ʼ விலோக்ய ப்ராவோசத் ஜக³த​: பாபமோசகம் ஈஸ்²வரஸ்ய மேஷஸா²வகம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","யோ மம பஸ்²சாதா³க³மிஷ்யதி ஸ மத்தோ கு³ருதர​:, யதோ ஹேதோர்மத்பூர்வ்வம்ʼ ஸோ(அ)வர்த்தத யஸ்மிந்நஹம்ʼ கதா²மிமாம்ʼ கதி²தவாந் ஸ ஏவாயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","அபரம்ʼ நாஹமேநம்ʼ ப்ரத்யபி⁴ஜ்ஞாதவாந் கிந்து இஸ்ராயேல்லோகா ஏநம்ʼ யதா² பரிசிந்வந்தி தத³பி⁴ப்ராயேணாஹம்ʼ ஜலே மஜ்ஜயிதுமாக³ச்ச²ம்| ");
INSERT INTO santam_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","புநஸ்²ச யோஹநபரமேகம்ʼ ப்ரமாணம்ʼ த³த்வா கதி²தவாந் விஹாயஸ​: கபோதவத்³ அவதரந்தமாத்மாநம் அஸ்யோபர்ய்யவதிஷ்ட²ந்தம்ʼ ச த்³ருʼஷ்டவாநஹம்| ");
INSERT INTO santam_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","நாஹமேநம்ʼ ப்ரத்யபி⁴ஜ்ஞாதவாந் இதி ஸத்யம்ʼ கிந்து யோ ஜலே மஜ்ஜயிதும்ʼ மாம்ʼ ப்ரைரயத் ஸ ஏவேமாம்ʼ கதா²மகத²யத் யஸ்யோபர்ய்யாத்மாநம் அவதரந்தம் அவதிஷ்ட²ந்தஞ்ச த்³ரக்ஷயஸி ஸஏவ பவித்ரே ஆத்மநி மஜ்ஜயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","அவஸ்தந்நிரீக்ஷ்யாயம் ஈஸ்²வரஸ்ய தநய இதி ப்ரமாணம்ʼ த³தா³மி| ");
INSERT INTO santam_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","பரே(அ)ஹநி யோஹந் த்³வாப்⁴யாம்ʼ ஸி²ஷ்யாப்⁴யாம்ʼ ஸார்த்³தே⁴ம்ʼ திஷ்ட²ந் ");
INSERT INTO santam_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","யிஸு²ம்ʼ க³ச்ச²ந்தம்ʼ விலோக்ய க³தி³தவாந், ஈஸ்²வரஸ்ய மேஷஸா²வகம்ʼ பஸ்²யதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","இமாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா த்³வௌ ஸி²ஷ்யௌ யீஸோ²​: பஸ்²சாத்³ ஈயது​:| ");
INSERT INTO santam_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ததோ யீஸு²​: பராவ்ருʼத்ய தௌ பஸ்²சாத்³ ஆக³ச்ச²ந்தௌ த்³ருʼஷ்ட்வா ப்ருʼஷ்டவாந் யுவாம்ʼ கிம்ʼ க³வேஸ²யத²​:? தாவப்ருʼச்ச²தாம்ʼ ஹே ரப்³பி³ அர்தா²த் ஹே கு³ரோ ப⁴வாந் குத்ர திஷ்ட²தி? ");
INSERT INTO santam_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","தத​: ஸோவாதி³த் ஏத்ய பஸ்²யதம்ʼ| ததோ தி³வஸஸ்ய த்ருʼதீயப்ரஹரஸ்ய க³தத்வாத் தௌ தத்³தி³நம்ʼ தஸ்ய ஸங்கே³(அ)ஸ்தா²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","யௌ த்³வௌ யோஹநோ வாக்யம்ʼ ஸ்²ருத்வா யிஸோ²​: பஸ்²சாத்³ ஆக³மதாம்ʼ தயோ​: ஸி²மோந்பிதரஸ்ய ப்⁴ராதா ஆந்த்³ரிய​: ");
INSERT INTO santam_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ஸ இத்வா ப்ரத²மம்ʼ நிஜஸோத³ரம்ʼ ஸி²மோநம்ʼ ஸாக்ஷாத்ப்ராப்ய கதி²தவாந் வயம்ʼ க்²ரீஷ்டம் அர்தா²த் அபி⁴ஷிக்தபுருஷம்ʼ ஸாக்ஷாத்க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","பஸ்²சாத் ஸ தம்ʼ யிஸோ²​: ஸமீபம் ஆநயத்| ததா³ யீஸு²ஸ்தம்ʼ த்³ருʼஷ்ட்வாவத³த் த்வம்ʼ யூநஸ​: புத்ர​: ஸி²மோந் கிந்து த்வந்நாமதே⁴யம்ʼ கைபா²​: வா பிதர​: அர்தா²த் ப்ரஸ்தரோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","பரே(அ)ஹநி யீஸௌ² கா³லீலம்ʼ க³ந்தும்ʼ நிஸ்²சிதசேதஸி ஸதி பி²லிபநாமாநம்ʼ ஜநம்ʼ ஸாக்ஷாத்ப்ராப்யாவோசத் மம பஸ்²சாத்³ ஆக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","பை³த்ஸைதா³நாம்நி யஸ்மிந் க்³ராமே பிதராந்த்³ரியயோர்வாஸ ஆஸீத் தஸ்மிந் க்³ராமே தஸ்ய பி²லிபஸ்ய வஸதிராஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","பஸ்²சாத் பி²லிபோ நித²நேலம்ʼ ஸாக்ஷாத்ப்ராப்யாவத³த் மூஸா வ்யவஸ்தா² க்³ரந்தே² ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு ச யஸ்யாக்²யாநம்ʼ லிகி²தமாஸ்தே தம்ʼ யூஷப²​: புத்ரம்ʼ நாஸரதீயம்ʼ யீஸு²ம்ʼ ஸாக்ஷாத்³ அகார்ஷ்ம வயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ததா³ நித²நேல் கதி²தவாந் நாஸரந்நக³ராத கிம்ʼ கஸ்²சிது³த்தம உத்பந்தும்ʼ ஸ²க்நோதி? தத​: பி²லிபோ (அ)வோசத் ஏத்ய பஸ்²ய| ");
INSERT INTO santam_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","அபரஞ்ச யீஸு²​: ஸ்வஸ்ய ஸமீபம்ʼ தம் ஆக³ச்ச²ந்தம்ʼ த்³ருʼஷ்ட்வா வ்யாஹ்ருʼதவாந், பஸ்²யாயம்ʼ நிஷ்கபட​: ஸத்ய இஸ்ராயேல்லோக​:| ");
INSERT INTO santam_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","தத​: ஸோவத³த்³, ப⁴வாந் மாம்ʼ கத²ம்ʼ ப்ரத்யபி⁴ஜாநாதி? யீஸு²ரவாதீ³த் பி²லிபஸ்ய ஆஹ்வாநாத் பூர்வ்வம்ʼ யதா³ த்வமுடு³ம்ப³ரஸ்ய தரோர்மூலே(அ)ஸ்தா²ஸ்ததா³ த்வாமத³ர்ஸ²ம்| ");
INSERT INTO santam_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","நித²நேல் அசகத²த், ஹே கு³ரோ ப⁴வாந் நிதாந்தம் ஈஸ்²வரஸ்ய புத்ரோஸி, ப⁴வாந் இஸ்ராயேல்வம்ʼஸ²ஸ்ய ராஜா| ");
INSERT INTO santam_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ததோ யீஸு² ர்வ்யாஹரத், த்வாமுடு³ம்ப³ரஸ்ய பாத³பஸ்ய மூலே த்³ருʼஷ்டவாநாஹம்ʼ மமைதஸ்மாத்³வாக்யாத் கிம்ʼ த்வம்ʼ வ்யஸ்²வஸீ​:? ஏதஸ்மாத³ப்யாஸ்²சர்ய்யாணி கார்ய்யாணி த்³ரக்ஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","அந்யச்சாவாதீ³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, இத​: பரம்ʼ மோசிதே மேக⁴த்³வாரே தஸ்மாந்மநுஜஸூநுநா ஈஸ்²வரஸ்ய தூ³தக³ணம் அவரோஹந்தமாரோஹந்தஞ்ச த்³ரக்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","அநந்தரம்ʼ த்ருதீயதி³வஸே கா³லீல் ப்ரதே³ஸி²யே காந்நாநாம்நி நக³ரே விவாஹ ஆஸீத் தத்ர ச யீஸோ²ர்மாதா திஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","தஸ்மை விவாஹாய யீஸு²ஸ்தஸ்ய ஸி²ஷ்யாஸ்²ச நிமந்த்ரிதா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","தத³நந்தரம்ʼ த்³ராக்ஷாரஸஸ்ய ந்யூநத்வாத்³ யீஸோ²ர்மாதா தமவத³த் ஏதேஷாம்ʼ த்³ராக்ஷாரஸோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ததா³ ஸ தாமவோசத் ஹே நாரி மயா ஸஹ தவ கிம்ʼ கார்ய்யம்ʼ? மம ஸமய இதா³நீம்ʼ நோபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ததஸ்தஸ்ய மாதா தா³ஸாநவோசத்³ அயம்ʼ யத்³ வத³தி ததே³வ குருத| ");
INSERT INTO santam_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","தஸ்மிந் ஸ்தா²நே யிஹூதீ³யாநாம்ʼ ஸு²சித்வகரணவ்யவஹாராநுஸாரேணாட⁴கைகஜலத⁴ராணி பாஷாணமயாநி ஷட்³வ்ருʼஹத்பாத்ராணிஆஸந்| ");
INSERT INTO santam_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ததா³ யீஸு²ஸ்தாந் ஸர்வ்வகலஸா²ந் ஜலை​: பூரயிதும்ʼ தாநாஜ்ஞாபயத், ததஸ்தே ஸர்வ்வாந் கும்பா⁴நாகர்ணம்ʼ ஜலை​: பர்ய்யபூரயந்| ");
INSERT INTO santam_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","அத² தேப்⁴ய​: கிஞ்சிது³த்தார்ய்ய போ⁴ஜ்யாதி⁴பாதே​:ஸமீபம்ʼ நேதும்ʼ ஸ தாநாதி³ஸ²த், தே தத³நயந்| ");
INSERT INTO santam_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","அபரஞ்ச தஜ்ஜலம்ʼ கத²ம்ʼ த்³ராக்ஷாரஸோ(அ)ப⁴வத் தஜ்ஜலவாஹகாதா³ஸா ஜ்ஞாதும்ʼ ஸ²க்தா​: கிந்து தத்³போ⁴ஜ்யாதி⁴போ ஜ்ஞாதும்ʼ நாஸ²க்நோத் தத³வலிஹ்ய வரம்ʼ ஸம்ʼம்போ³த்³யாவத³த, ");
INSERT INTO santam_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","லோகா​: ப்ரத²மம்ʼ உத்தமத்³ராக்ஷாரஸம்ʼ த³த³தி தஷு யதே²ஷ்டம்ʼ பிதவத்ஸு தஸ்மா கிஞ்சித³நுத்தமஞ்ச த³த³தி கிந்து த்வமிதா³நீம்ʼ யாவத் உத்தமத்³ராக்ஷாரஸம்ʼ ஸ்தா²பயஸி| ");
INSERT INTO santam_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","இத்த²ம்ʼ யீஸு²ர்கா³லீலப்ரதே³ஸே² ஆஸ்²சர்ய்யகார்ம்ம ப்ராரம்ப⁴ நிஜமஹிமாநம்ʼ ப்ராகாஸ²யத் தத​: ஸி²ஷ்யாஸ்தஸ்மிந் வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","தத​: பரம் ஸ நிஜமாத்ருப்⁴ராத்ருஸ்ஸி²ஷ்யை​: ஸார்த்³த்⁴ம்ʼ கப²ர்நாஹூமம் ஆக³மத் கிந்து தத்ர ப³ஹூதி³நாநி ஆதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","தத³நந்தரம்ʼ யிஹூதி³யாநாம்ʼ நிஸ்தாரோத்ஸவே நிகடமாக³தே யீஸு² ர்யிரூஸா²லம் நக³ரம் ஆக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ததோ மந்தி³ரஸ்ய மத்⁴யே கோ³மேஷபாராவதவிக்ரயிணோ வாணிஜக்ஷ்சோபவிஷ்டாந் விலோக்ய ");
INSERT INTO santam_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ரஜ்ஜுபி⁴​: கஸா²ம்ʼ நிர்ம்மாய ஸர்வ்வகோ³மேஷாதி³பி⁴​: ஸார்த்³த⁴ம்ʼ தாந் மந்தி³ராத்³ தூ³ரீக்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","வணிஜாம்ʼ முத்³ராதி³ விகீர்ய்ய ஆஸநாநி ந்யூப்³ஜீக்ருʼத்ய பாராவதவிக்ரயிப்⁴யோ(அ)கத²யத்³ அஸ்மாத் ஸ்தா²நாத் ஸர்வாண்யேதாநி நயத, மம பிதுக்³ருʼஹம்ʼ வாணிஜ்யக்³ருʼஹம்ʼ மா கார்ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","தஸ்மாத் தந்மந்தி³ரார்த² உத்³யோகோ³ யஸ்து ஸ க்³ரஸதீவ மாம்| இமாம்ʼ ஸா²ஸ்த்ரீயலிபிம்ʼ ஸி²ஷ்யா​:ஸமஸ்மரந்| ");
INSERT INTO santam_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","தத​: பரம் யிஹூதீ³யலோகா யீஷிமவத³ந் தவமித்³ருʼஸ²கர்ம்மகரணாத் கிம்ʼ சிஹ்நமஸ்மாந் த³ர்ஸ²யஸி? ");
INSERT INTO santam_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ததோ யீஸு²ஸ்தாநவோசத்³ யுஷ்மாபி⁴ரே தஸ்மிந் மந்தி³ரே நாஸி²தே தி³நத்ரயமத்⁴யே(அ)ஹம்ʼ தத்³ உத்தா²பயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ததா³ யிஹூதி³யா வ்யாஹார்ஷு​:, ஏதஸ்ய மந்தி³ரஸ நிர்ம்மாணேந ஷட்சத்வாரிம்ʼஸ²த்³ வத்ஸரா க³தா​:, த்வம்ʼ கிம்ʼ தி³நத்ரயமத்⁴யே தத்³ உத்தா²பயிஷ்யஸி? ");
INSERT INTO santam_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","கிந்து ஸ நிஜதே³ஹரூபமந்தி³ரே கதா²மிமாம்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ஸ யதே³தாத்³ருʼஸ²ம்ʼ க³தி³தவாந் தச்சி²ஷ்யா​: ஸ்²மஸா²நாத் ததீ³யோத்தா²நே ஸதி ஸ்ம்ருʼத்வா த⁴ர்ம்மக்³ரந்தே² யீஸு²நோக்தகதா²யாம்ʼ ச வ்யஸ்²வஸிஷு​:| ");
INSERT INTO santam_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","அநந்தரம்ʼ நிஸ்தாரோத்ஸவஸ்ய போ⁴ஜ்யஸமயே யிரூஸா²லம் நக³ரே தத்க்ருதாஸ்²சர்ய்யகர்ம்மாணி விலோக்ய ப³ஹுபி⁴ஸ்தஸ்ய நாமநி விஸ்²வஸிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","கிந்து ஸ தேஷாம்ʼ கரேஷு ஸ்வம்ʼ ந ஸமர்பயத், யத​: ஸ ஸர்வ்வாநவைத்| ");
INSERT INTO santam_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ஸ மாநவேஷு கஸ்யசித் ப்ரமாணம்ʼ நாபேக்ஷத யதோ மநுஜாநாம்ʼ மத்⁴யே யத்³யத³ஸ்தி தத்தத் ஸோஜாநாத்| ");
INSERT INTO santam_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","நிகதி³மநாமா யிஹூதீ³யாநாம் அதி⁴பதி​: பி²ரூஸீ² க்ஷணதா³யாம்ʼ ");
INSERT INTO santam_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","யீஸௌ²ரப்⁴யர்ணம் ஆவ்ரஜ்ய வ்யாஹார்ஷீத், ஹே கு³ரோ ப⁴வாந் ஈஸ்²வராத்³ ஆக³த் ஏக உபதே³ஷ்டா, ஏதத்³ அஸ்மாபி⁴ர்ஜ்ஞாயதே; யதோ ப⁴வதா யாந்யாஸ்²சர்ய்யகர்ம்மாணி க்ரியந்தே பரமேஸ்²வரஸ்ய ஸாஹாய்யம்ʼ விநா கேநாபி தத்தத்கர்ம்மாணி கர்த்தும்ʼ ந ஸ²க்யந்தே| ");
INSERT INTO santam_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ததா³ யீஸு²ருத்தரம்ʼ த³த்தவாந் தவாஹம்ʼ யதா²ர்த²தரம்ʼ வ்யாஹராமி புநர்ஜந்மநி ந ஸதி கோபி மாநவ ஈஸ்²வரஸ்ய ராஜ்யம்ʼ த்³ரஷ்டும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ததோ நிகதீ³ம​: ப்ரத்யவோசத் மநுஜோ வ்ருʼத்³தோ⁴ பூ⁴த்வா கத²ம்ʼ ஜநிஷ்யதே? ஸ கிம்ʼ புந ர்மாத்ருʼர்ஜட²ரம்ʼ ப்ரவிஸ்²ய ஜநிதும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","யீஸு²ரவாதீ³த்³ யதா²ர்த²தரம் அஹம்ʼ கத²யாமி மநுஜே தோயாத்மப்⁴யாம்ʼ புந ர்ந ஜாதே ஸ ஈஸ்²வரஸ்ய ராஜ்யம்ʼ ப்ரவேஷ்டும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","மாம்ʼஸாத்³ யத் ஜாயதே தந் மாம்ʼஸமேவ ததா²த்மநோ யோ ஜாயதே ஸ ஆத்மைவ| ");
INSERT INTO santam_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","யுஷ்மாபி⁴​: புந ர்ஜநிதவ்யம்ʼ மமைதஸ்யாம்ʼ கதா²யாம் ஆஸ்²சர்யம்ʼ மா மம்ʼஸ்தா²​:| ");
INSERT INTO santam_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ஸதா³க³திர்யாம்ʼ தி³ஸ²மிச்ச²தி தஸ்யாமேவ தி³ஸி² வாதி, த்வம்ʼ தஸ்ய ஸ்வநம்ʼ ஸு²ணோஷி கிந்து ஸ குத ஆயாதி குத்ர யாதி வா கிமபி ந ஜாநாஸி தத்³வாத்³ ஆத்மந​: ஸகாஸா²த் ஸர்வ்வேஷாம்ʼ மநுஜாநாம்ʼ ஜந்ம ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ததா³ நிகதீ³ம​: ப்ருʼஷ்டவாந் ஏதத் கத²ம்ʼ ப⁴விதும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","யீஸு²​: ப்ரத்யக்தவாந் த்வமிஸ்ராயேலோ கு³ருர்பூ⁴த்வாபி கிமேதாம்ʼ கதா²ம்ʼ ந வேத்ஸி? ");
INSERT INTO santam_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","துப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி, வயம்ʼ யத்³ வித்³மஸ்தத்³ வச்ம​: யம்ʼச்ச பஸ்²யாமஸ்தஸ்யைவ ஸாக்ஷ்யம்ʼ த³த்³ம​: கிந்து யுஷ்மாபி⁴ரஸ்மாகம்ʼ ஸாக்ஷித்வம்ʼ ந க்³ருʼஹ்யதே| ");
INSERT INTO santam_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ஏதஸ்ய ஸம்ʼஸாரஸ்ய கதா²யாம்ʼ கதி²தாயாம்ʼ யதி³ யூயம்ʼ ந விஸ்²வஸித² தர்ஹி ஸ்வர்கீ³யாயாம்ʼ கதா²யாம்ʼ கத²ம்ʼ விஸ்²வஸிஷ்யத²? ");
INSERT INTO santam_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ய​: ஸ்வர்கே³(அ)ஸ்தி யம்ʼ ச ஸ்வர்கா³த்³ அவாரோஹத் தம்ʼ மாநவதநயம்ʼ விநா கோபி ஸ்வர்க³ம்ʼ நாரோஹத்| ");
INSERT INTO santam_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","அபரஞ்ச மூஸா யதா² ப்ராந்தரே ஸர்பம்ʼ ப்ரோத்தா²பிதவாந் மநுஷ்யபுத்ரோ(அ)பி ததை²வோத்தா²பிதவ்ய​:; ");
INSERT INTO santam_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","தஸ்மாத்³ ய​: கஸ்²சித் தஸ்மிந் விஸ்²வஸிஷ்யதி ஸோ(அ)விநாஸ்²ய​: ஸந் அநந்தாயு​: ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ஈஸ்²வர இத்த²ம்ʼ ஜக³த³த³யத யத் ஸ்வமத்³விதீயம்ʼ தநயம்ʼ ப்ராத³தா³த் ததோ ய​: கஸ்²சித் தஸ்மிந் விஸ்²வஸிஷ்யதி ஸோ(அ)விநாஸ்²ய​: ஸந் அநந்தாயு​: ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ஈஸ்²வரோ ஜக³தோ லோகாந் த³ண்ட³யிதும்ʼ ஸ்வபுத்ரம்ʼ ந ப்ரேஷ்ய தாந் பரித்ராதும்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","அதஏவ ய​: கஸ்²சித் தஸ்மிந் விஸ்²வஸிதி ஸ த³ண்டா³ர்ஹோ ந ப⁴வதி கிந்து ய​: கஸ்²சித் தஸ்மிந் ந விஸ்²வஸிதி ஸ இதா³நீமேவ த³ண்டா³ர்ஹோ ப⁴வதி,யத​: ஸ ஈஸ்²வரஸ்யாத்³விதீயபுத்ரஸ்ய நாமநி ப்ரத்யயம்ʼ ந கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ஜக³தோ மத்⁴யே ஜ்யோதி​: ப்ராகாஸ²த கிந்து மநுஷ்யாணாம்ʼ கர்ம்மணாம்ʼ த்³ருʼஷ்டத்வாத் தே ஜ்யோதிஷோபி திமிரே ப்ரீயந்தே ஏததே³வ த³ண்ட³ஸ்ய காரணாம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ய​: குகர்ம்ம கரோதி தஸ்யாசாரஸ்ய த்³ருʼஷ்டத்வாத் ஸ ஜ்யோதிர்ரூʼதீயித்வா தந்நிகடம்ʼ நாயாதி; ");
INSERT INTO santam_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","கிந்து ய​: ஸத்கர்ம்ம கரோதி தஸ்ய ஸர்வ்வாணி கர்ம்மாணீஸ்²வரேண க்ருʼதாநீதி ஸதா² ப்ரகாஸ²தே தத³பி⁴ப்ராயேண ஸ ஜ்யோதிஷ​: ஸந்நிதி⁴ம் ஆயாதி| ");
INSERT INTO santam_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","தத​: பரம் யீஸு²​: ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ யிஹூதீ³யதே³ஸ²ம்ʼ க³த்வா தத்ர ஸ்தி²த்வா மஜ்ஜயிதும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ததா³ ஸா²லம் நக³ரஸ்ய ஸமீபஸ்தா²யிநி ஐநந் க்³ராமே ப³ஹுதரதோயஸ்தி²தேஸ்தத்ர யோஹந் அமஜ்ஜயத் ததா² ச லோகா ஆக³த்ய தேந மஜ்ஜிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ததா³ யோஹந் காராயாம்ʼ ந ப³த்³த⁴​:| ");
INSERT INTO santam_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","அபரஞ்ச ஸா²சகர்ம்மணி யோஹாந​: ஸி²ஷ்யை​: ஸஹ யிஹூதீ³யலோகாநாம்ʼ விவாதே³ ஜாதே, தே யோஹந​: ஸம்ʼந்நிதி⁴ம்ʼ க³த்வாகத²யந், ");
INSERT INTO santam_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ஹே கு³ரோ யர்த்³த³நநத்³யா​: பாரே ப⁴வதா ஸார்த்³த⁴ம்ʼ ய ஆஸீத் யஸ்மிம்ʼஸ்²ச ப⁴வாந் ஸாக்ஷ்யம்ʼ ப்ரத³தா³த் பஸ்²யது ஸோபி மஜ்ஜயதி ஸர்வ்வே தஸ்ய ஸமீபம்ʼ யாந்தி ச| ");
INSERT INTO santam_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ததா³ யோஹந் ப்ரத்யவோசத்³ ஈஸ்²வரேண ந த³த்தே கோபி மநுஜ​: கிமபி ப்ராப்தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","அஹம்ʼ அபி⁴ஷிக்தோ ந ப⁴வாமி கிந்து தத³க்³ரே ப்ரேஷிதோஸ்மி யாமிமாம்ʼ கதா²ம்ʼ கதி²தவாநாஹம்ʼ தத்ர யூயம்ʼ ஸர்வ்வே ஸாக்ஷிண​: ஸ்த²| ");
INSERT INTO santam_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","யோ ஜந​: கந்யாம்ʼ லப⁴தே ஸ ஏவ வர​: கிந்து வரஸ்ய ஸந்நிதௌ⁴ த³ண்டா³யமாநம்ʼ தஸ்ய யந்மித்ரம்ʼ தேந வரஸ்ய ஸ²ப்³தே³ ஸ்²ருதே(அ)தீவாஹ்லாத்³யதே மமாபி தத்³வத்³ ஆநந்த³ஸித்³தி⁴ர்ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","தேந க்ரமஸோ² வர்த்³தி⁴தவ்யம்ʼ கிந்து மயா ஹ்ஸிதவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ய ஊர்த்⁴வாதா³க³ச்ச²த் ஸ ஸர்வ்வேஷாம்ʼ முக்²யோ யஸ்²ச ஸம்ʼஸாராத்³ உத³பத்³யத ஸ ஸாம்ʼஸாரிக​: ஸம்ʼஸாரீயாம்ʼ கதா²ஞ்ச கத²யதி யஸ்து ஸ்வர்கா³தா³க³ச்ச²த் ஸ ஸர்வ்வேஷாம்ʼ முக்²ய​:| ");
INSERT INTO santam_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ஸ யத³பஸ்²யத³ஸ்²ருʼணோச்ச தஸ்மிந்நேவ ஸாக்ஷ்யம்ʼ த³தா³தி ததா²பி ப்ராயஸ²​: கஸ்²சித் தஸ்ய ஸாக்ஷ்யம்ʼ ந க்³ருʼஹ்லாதி; ");
INSERT INTO santam_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","கிந்து யோ க்³ருʼஹ்லாதி ஸ ஈஸ்²வரஸ்ய ஸத்யவாதி³த்வம்ʼ முத்³ராங்கி³தம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ஈஸ்²வரேண ய​: ப்ரேரித​: ஸஏவ ஈஸ்²வரீயகதா²ம்ʼ கத²யதி யத ஈஸ்²வர ஆத்மாநம்ʼ தஸ்மை அபரிமிதம் அத³தா³த்| ");
INSERT INTO santam_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","பிதா புத்ரே ஸ்நேஹம்ʼ க்ருʼத்வா தஸ்ய ஹஸ்தே ஸர்வ்வாணி ஸமர்பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ய​: கஸ்²சித் புத்ரே விஸ்²வஸிதி ஸ ஏவாநந்தம் பரமாயு​: ப்ராப்நோதி கிந்து ய​: கஸ்²சித் புத்ரே ந விஸ்²வஸிதி ஸ பரமாயுஷோ த³ர்ஸ²நம்ʼ ந ப்ராப்நோதி கிந்த்வீஸ்²வரஸ்ய கோபபா⁴ஜநம்ʼ பூ⁴த்வா திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","யீஸு²​: ஸ்வயம்ʼ நாமஜ்ஜயத் கேவலம்ʼ தஸ்ய ஸி²ஷ்யா அமஜ்ஜயத் கிந்து யோஹநோ(அ)தி⁴கஸி²ஷ்யாந் ஸ கரோதி மஜ்ஜயதி ச, ");
INSERT INTO santam_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","பி²ரூஸி²ந இமாம்ʼ வார்த்தாமஸ்²ருʼண்வந் இதி ப்ரபு⁴ரவக³த்ய ");
INSERT INTO santam_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","யிஹூதீ³யதே³ஸ²ம்ʼ விஹாய புந ர்கா³லீலம் ஆக³த்| ");
INSERT INTO santam_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","தத​: ஸோ²மிரோணப்ரதே³ஸ²ஸ்ய மத்³யேந தேந க³ந்தவ்யே ஸதி ");
INSERT INTO santam_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","யாகூப்³ நிஜபுத்ராய யூஷபே² யாம்ʼ பூ⁴மிம் அத³தா³த் தத்ஸமீபஸ்தா²யி ஸோ²மிரோணப்ரதே³ஸ²ஸ்ய ஸுகா²ர் நாம்நா விக்²யாதஸ்ய நக³ரஸ்ய ஸந்நிதா⁴வுபாஸ்தா²த்| ");
INSERT INTO santam_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","தத்ர யாகூப³​: ப்ரஹிராஸீத்; ததா³ த்³விதீயயாமவேலாயாம்ʼ ஜாதாயாம்ʼ ஸ மார்கே³ ஸ்²ரமாபந்நஸ்தஸ்ய ப்ரஹே​: பார்ஸ்²வே உபாவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ஏதர்ஹி காசித் ஸோ²மிரோணீயா யோஷித் தோயோத்தோலநார்த²ம் தத்ராக³மத் ");
INSERT INTO santam_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ததா³ ஸி²ஷ்யா​: கா²த்³யத்³ரவ்யாணி க்ரேதும்ʼ நக³ரம் அக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","யீஸு²​: ஸோ²மிரோணீயாம்ʼ தாம்ʼ யோஷிதம் வ்யாஹார்ஷீத் மஹ்யம்ʼ கிஞ்சித் பாநீயம்ʼ பாதும்ʼ தே³ஹி| கிந்து ஸோ²மிரோணீயை​: ஸாகம்ʼ யிஹூதீ³யலோகா ந வ்யவாஹரந் தஸ்மாத்³தே⁴தோ​: ஸாகத²யத் ஸோ²மிரோணீயா யோஷிதத³ஹம்ʼ த்வம்ʼ யிஹூதீ³யோஸி கத²ம்ʼ மத்த​: பாநீயம்ʼ பாதும் இச்ச²ஸி? ");
INSERT INTO santam_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ததோ யீஸு²ரவத³த்³ ஈஸ்²வரஸ்ய யத்³தா³நம்ʼ தத்கீத்³ருʼக் பாநீயம்ʼ பாதும்ʼ மஹ்யம்ʼ தே³ஹி ய இத்த²ம்ʼ த்வாம்ʼ யாசதே ஸ வா க இதி சேத³ஜ்ஞாஸ்யதா²ஸ்தர்ஹி தமயாசிஷ்யதா²​: ஸ ச துப்⁴யமம்ருʼதம்ʼ தோயமதா³ஸ்யத்| ");
INSERT INTO santam_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ததா³ ஸா ஸீமந்திநீ பா⁴ஷிதவதி, ஹே மஹேச்ச² ப்ரஹிர்க³ம்பீ⁴ரோ ப⁴வதோ நீரோத்தோலநபாத்ரம்ʼ நாஸ்தீ ச தஸ்மாத் தத³ம்ருʼதம்ʼ கீலாலம்ʼ குத​: ப்ராப்ஸ்யஸி? ");
INSERT INTO santam_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","யோஸ்மப்⁴யம் இமமந்தூ⁴ம்ʼ த³தௌ³, யஸ்ய ச பரிஜநா கோ³மேஷாத³யஸ்²ச ஸர்வ்வே(அ)ஸ்ய ப்ரஹே​: பாநீயம்ʼ பபுரேதாத்³ருʼஸோ² யோஸ்மாகம்ʼ பூர்வ்வபுருஷோ யாகூப்³ தஸ்மாத³பி ப⁴வாந் மஹாந் கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ததோ யீஸு²ரகத²யத்³ இத³ம்ʼ பாநீயம்ʼ ஸ​: பிவதி ஸ புநஸ்த்ருʼஷார்த்தோ ப⁴விஷ்யதி, ");
INSERT INTO santam_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","கிந்து மயா த³த்தம்ʼ பாநீயம்ʼ ய​: பிவதி ஸ புந​: கதா³பி த்ருʼஷார்த்தோ ந ப⁴விஷ்யதி| மயா த³த்தம் இத³ம்ʼ தோயம்ʼ தஸ்யாந்த​: ப்ரஸ்ரவணரூபம்ʼ பூ⁴த்வா அநந்தாயுர்யாவத் ஸ்ரோஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ததா³ ஸா வநிதாகத²யத் ஹே மஹேச்ச² தர்ஹி மம புந​: பீபாஸா யதா² ந ஜாயதே தோயோத்தோலநாய யதா²த்ராக³மநம்ʼ ந ப⁴வதி ச தத³ர்த²ம்ʼ மஹ்யம்ʼ தத்தோயம்ʼ தே³ஹீ| ");
INSERT INTO santam_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ததோ யீஸூ²ரவத³த்³யாஹி தவ பதிமாஹூய ஸ்தா²நே(அ)த்ராக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ஸா வாமாவத³த் மம பதிர்நாஸ்தி| யீஸு²ரவத³த் மம பதிர்நாஸ்தீதி வாக்யம்ʼ ப⁴த்³ரமவோச​:| ");
INSERT INTO santam_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","யதஸ்தவ பஞ்ச பதயோப⁴வந் அது⁴நா து த்வயா ஸார்த்³த⁴ம்ʼ யஸ்திஷ்ட²தி ஸ தவ ப⁴ர்த்தா ந வாக்யமித³ம்ʼ ஸத்யமவாதி³​:| ");
INSERT INTO santam_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ததா³ ஸா மஹிலா க³தி³தவதி ஹே மஹேச்ச² ப⁴வாந் ஏகோ ப⁴விஷ்யத்³வாதீ³தி பு³த்³த⁴ம்ʼ மயா| ");
INSERT INTO santam_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","அஸ்மாகம்ʼ பித்ருʼலோகா ஏதஸ்மிந் ஸி²லோச்சயே(அ)ப⁴ஜந்த, கிந்து ப⁴வத்³பி⁴ருச்யதே யிரூஸா²லம் நக³ரே ப⁴ஜநயோக்³யம்ʼ ஸ்தா²நமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","யீஸு²ரவோசத் ஹே யோஷித் மம வாக்யே விஸ்²வஸிஹி யதா³ யூயம்ʼ கேவலஸை²லே(அ)ஸ்மிந் வா யிரூஸா²லம் நக³ரே பிதுர்ப⁴ஜநம்ʼ ந கரிஷ்யத்⁴வே கால ஏதாத்³ருʼஸ² ஆயாதி| ");
INSERT INTO santam_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","யூயம்ʼ யம்ʼ ப⁴ஜத்⁴வே தம்ʼ ந ஜாநீத², கிந்து வயம்ʼ யம்ʼ ப⁴ஜாமஹே தம்ʼ ஜாநீமஹே, யதோ யிஹூதீ³யலோகாநாம்ʼ மத்⁴யாத் பரித்ராணம்ʼ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","கிந்து யதா³ ஸத்யப⁴க்தா ஆத்மநா ஸத்யரூபேண ச பிதுர்ப⁴ஜநம்ʼ கரிஷ்யந்தே ஸமய ஏதாத்³ருʼஸ² ஆயாதி, வரம் இதா³நீமபி வித்³யதே ; யத ஏதாத்³ருʼஸோ² ப⁴த்காந் பிதா சேஷ்டதே| ");
INSERT INTO santam_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ஈஸ்²வர ஆத்மா; ததஸ்தஸ்ய யே ப⁴க்தாஸ்தை​: ஸ ஆத்மநா ஸத்யரூபேண ச ப⁴ஜநீய​:| ");
INSERT INTO santam_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ததா³ ஸா மஹிலாவாதீ³த் க்²ரீஷ்டநாம்நா விக்²யாதோ(அ)பி⁴ஷிக்த​: புருஷ ஆக³மிஷ்யதீதி ஜாநாமி ஸ ச ஸர்வ்வா​: கதா² அஸ்மாந் ஜ்ஞாபயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ததோ யீஸு²ரவத³த் த்வயா ஸார்த்³த⁴ம்ʼ கத²நம்ʼ கரோமி யோ(அ)ஹம் அஹமேவ ஸ புருஷ​:| ");
INSERT INTO santam_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ஏதஸ்மிந் ஸமயே ஸி²ஷ்யா ஆக³த்ய ததா² ஸ்த்ரியா ஸார்த்³த⁴ம்ʼ தஸ்ய கதோ²பகத²நே மஹாஸ்²சர்ய்யம் அமந்யந்த ததா²பி ப⁴வாந் கிமிச்ச²தி? யத்³வா கிமர்த²ம் ஏதயா ஸார்த்³த⁴ம்ʼ கதா²ம்ʼ கத²யதி? இதி கோபி நாப்ருʼச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","தத​: பரம்ʼ ஸா நாரீ கலஸ²ம்ʼ ஸ்தா²பயித்வா நக³ரமத்⁴யம்ʼ க³த்வா லோகேப்⁴யோகதா²யத்³ ");
INSERT INTO santam_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","அஹம்ʼ யத்³யத் கர்ம்மாகரவம்ʼ தத்ஸர்வ்வம்ʼ மஹ்யமகத²யத்³ ஏதாத்³ருʼஸ²ம்ʼ மாநவமேகம் ஆக³த்ய பஸ்²யத ரு கிம் அபி⁴ஷிக்தோ ந ப⁴வதி ? ");
INSERT INTO santam_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ததஸ்தே நக³ராத்³ ப³ஹிராக³த்ய தாதஸ்ய ஸமீபம் ஆயந்| ");
INSERT INTO santam_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ஏதர்ஹி ஸி²ஷ்யா​: ஸாத⁴யித்வா தம்ʼ வ்யாஹார்ஷு​: ஹே கு³ரோ ப⁴வாந் கிஞ்சித்³ பூ⁴க்தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","தத​: ஸோவத³த்³ யுஷ்மாபி⁴ர்யந்ந ஜ்ஞாயதே தாத்³ருʼஸ²ம்ʼ ப⁴க்ஷ்யம்ʼ மமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ததா³ ஸி²ஷ்யா​: பரஸ்பரம்ʼ ப்ரஷ்டும் ஆரம்ப⁴ந்த, கிமஸ்மை கோபி கிமபி ப⁴க்ஷ்யமாநீய த³த்தவாந்? ");
INSERT INTO santam_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","யீஸு²ரவோசத் மத்ப்ரேரகஸ்யாபி⁴மதாநுரூபகரணம்ʼ தஸ்யைவ கர்ம்மஸித்³தி⁴காரணஞ்ச மம ப⁴க்ஷ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","மாஸசதுஷ்டயே ஜாதே ஸ²ஸ்யகர்த்தநஸமயோ ப⁴விஷ்யதீதி வாக்யம்ʼ யுஷ்மாபி⁴​: கிம்ʼ நோத்³யதே? கிந்த்வஹம்ʼ வதா³மி, ஸி²ர உத்தோல்ய க்ஷேத்ராணி ப்ரதி நிரீக்ஷ்ய பஸ்²யத, இதா³நீம்ʼ கர்த்தநயோக்³யாநி ஸு²க்லவர்ணாந்யப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","யஸ்²சி²நத்தி ஸ வேதநம்ʼ லப⁴தே அநந்தாயு​:ஸ்வரூபம்ʼ ஸ²ஸ்யம்ʼ ஸ க்³ருʼஹ்லாதி ச, தேநைவ வப்தா சே²த்தா ச யுக³பத்³ ஆநந்த³த​:| ");
INSERT INTO santam_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","இத்த²ம்ʼ ஸதி வபத்யேகஸ்²சி²நத்யந்ய இதி வசநம்ʼ ஸித்³த்⁴யதி| ");
INSERT INTO santam_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","யத்ர யூயம்ʼ ந பர்ய்யஸ்²ராம்யத தாத்³ருʼஸ²ம்ʼ ஸ²ஸ்யம்ʼ சே²த்தும்ʼ யுஷ்மாந் ப்ரைரயம் அந்யே ஜநா​:பர்ய்யஸ்²ராம்யந் யூயம்ʼ தேஷாம்ʼ ஸ்²ரக³ஸ்ய ப²லம் அலப⁴த்⁴வம்| ");
INSERT INTO santam_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","யஸ்மிந் காலே யத்³யத் கர்ம்மாகார்ஷம்ʼ தத்ஸர்வ்வம்ʼ ஸ மஹ்யம் அகத²யத் தஸ்யா வநிதாயா இத³ம்ʼ ஸாக்ஷ்யவாக்யம்ʼ ஸ்²ருத்வா தந்நக³ரநிவாஸிநோ ப³ஹவ​: ஸோ²மிரோணீயலோகா வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ததா² ச தஸ்யாந்திகே ஸமுபஸ்தா²ய ஸ்வேஷாம்ʼ ஸந்நிதௌ⁴ கதிசித்³ தி³நாநி ஸ்தா²தும்ʼ தஸ்மிந் விநயம் அகுர்வ்வாந தஸ்மாத் ஸ தி³நத்³வயம்ʼ தத்ஸ்தா²நே ந்யவஷ்டத் ");
INSERT INTO santam_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ததஸ்தஸ்யோபதே³ஸே²ந ப³ஹவோ(அ)பரே விஸ்²வஸ்ய ");
INSERT INTO santam_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","தாம்ʼ யோஷாமவத³ந் கேவலம்ʼ தவ வாக்யேந ப்ரதீம இதி ந, கிந்து ஸ ஜக³தோ(அ)பி⁴ஷிக்தஸ்த்ராதேதி தஸ்ய கதா²ம்ʼ ஸ்²ருத்வா வயம்ʼ ஸ்வயமேவாஜ்ஞாஸமஹி| ");
INSERT INTO santam_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ஸ்வதே³ஸே² ப⁴விஷ்யத்³வக்து​: ஸத்காரோ நாஸ்தீதி யத்³யபி யீஸு²​: ப்ரமாணம்ʼ த³த்வாகத²யத் ");
INSERT INTO santam_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ததா²பி தி³வஸத்³வயாத் பரம்ʼ ஸ தஸ்மாத் ஸ்தா²நாத்³ கா³லீலம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","அநந்தரம்ʼ யே கா³லீலீ லியலோகா உத்ஸவே க³தா உத்ஸவஸமயே யிரூஸ²லம் நக³ரே தஸ்ய ஸர்வ்வா​: க்ரியா அபஸ்²யந் தே கா³லீலம் ஆக³தம்ʼ தம் ஆக்³ருʼஹ்லந்| ");
INSERT INTO santam_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","தத​: பரம் யீஸு² ர்யஸ்மிந் காந்நாநக³ரே ஜலம்ʼ த்³ராக்ஷாரஸம் ஆகரோத் தத் ஸ்தா²நம்ʼ புநரகா³த்| தஸ்மிந்நேவ ஸமயே கஸ்யசித்³ ராஜஸபா⁴ஸ்தாரஸ்ய புத்ர​: கப²ர்நாஹூமபுரீ ரோக³க்³ரஸ்த ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ஸ யேஹூதீ³யதே³ஸா²த்³ யீஸோ² ர்கா³லீலாக³மநவார்த்தாம்ʼ நிஸ²ம்ய தஸ்ய ஸமீபம்ʼ க³த்வா ப்ரார்த்²ய வ்யாஹ்ருʼதவாந் மம புத்ரஸ்ய ப்ராயேண கால ஆஸந்ந​: ப⁴வாந் ஆக³த்ய தம்ʼ ஸ்வஸ்த²ம்ʼ கரோது| ");
INSERT INTO santam_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ததா³ யீஸு²ரகத²யத்³ ஆஸ்²சர்ய்யம்ʼ கர்ம்ம சித்ரம்ʼ சிஹ்நம்ʼ ச ந த்³ருʼஷ்டா யூயம்ʼ ந ப்ரத்யேஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","தத​: ஸ ஸபா⁴ஸத³வத³த் ஹே மஹேச்ச² மம புத்ரே ந ம்ருʼதே ப⁴வாநாக³ச்ச²து| ");
INSERT INTO santam_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","யீஸு²ஸ்தமவத³த்³ க³ச்ச² தவ புத்ரோ(அ)ஜீவீத் ததா³ யீஸு²நோக்தவாக்யே ஸ விஸ்²வஸ்ய க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","க³மநகாலே மார்க³மத்⁴யே தா³ஸாஸ்தம்ʼ ஸாக்ஷாத்ப்ராப்யாவத³ந் ப⁴வத​: புத்ரோ(அ)ஜீவீத்| ");
INSERT INTO santam_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","தத​: கம்ʼ காலமாரப்⁴ய ரோக³ப்ரதீகாராரம்போ⁴ ஜாதா இதி ப்ருʼஷ்டே தைருக்தம்ʼ ஹ்ய​: ஸார்த்³த⁴த³ண்ட³த்³வயாதி⁴கத்³விதீயயாமே தஸ்ய ஜ்வரத்யாகோ³(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ததா³ யீஸு²ஸ்தஸ்மிந் க்ஷணே ப்ரோக்தவாந் தவ புத்ரோ(அ)ஜீவீத் பிதா தத்³பு³த்³த்⁴வா ஸபரிவாரோ வ்யஸ்²வஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","யிஹூதீ³யதே³ஸா²த்³ ஆக³த்ய கா³லீலி யீஸு²ரேதத்³ த்³விதீயம் ஆஸ்²சர்ய்யகர்ம்மாகரோத்| ");
INSERT INTO santam_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","தத​: பரம்ʼ யிஹூதீ³யாநாம் உத்ஸவ உபஸ்தி²தே யீஸு² ர்யிரூஸா²லமம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","தஸ்மிந்நக³ரே மேஷநாம்நோ த்³வாரஸ்ய ஸமீபே இப்³ரீயபா⁴ஷயா பை³தே²ஸ்தா³ நாம்நா பிஷ்கரிணீ பஞ்சக⁴ட்டயுக்தாஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","தஸ்யாஸ்தேஷு க⁴ட்டேஷு கிலாலகம்பநம் அபேக்ஷ்ய அந்த⁴க²ஞ்சஸு²ஷ்காங்கா³த³யோ ப³ஹவோ ரோகி³ண​: பதந்தஸ்திஷ்ட²ந்தி ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","யதோ விஸே²ஷகாலே தஸ்ய ஸரஸோ வாரி ஸ்வர்கீ³யதூ³த ஏத்யாகம்பயத் தத்கீலாலகம்பநாத் பரம்ʼ ய​: கஸ்²சித்³ ரோகீ³ ப்ரத²மம்ʼ பாநீயமவாரோஹத் ஸ ஏவ தத்க்ஷணாத்³ ரோக³முக்தோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ததா³ஷ்டாத்ரிம்ʼஸ²த்³வர்ஷாணி யாவத்³ ரோக³க்³ரஸ்த ஏகஜநஸ்தஸ்மிந் ஸ்தா²நே ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","யீஸு²ஸ்தம்ʼ ஸ²யிதம்ʼ த்³ருʼஷ்ட்வா ப³ஹுகாலிகரோகீ³தி ஜ்ஞாத்வா வ்யாஹ்ருʼதவாந் த்வம்ʼ கிம்ʼ ஸ்வஸ்தோ² பு³பூ⁴ஷஸி? ");
INSERT INTO santam_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ததோ ரோகீ³ கதி²தவாந் ஹே மஹேச்ச² யதா³ கீலாலம்ʼ கம்பதே ததா³ மாம்ʼ புஷ்கரிணீம் அவரோஹயிதும்ʼ மம கோபி நாஸ்தி, தஸ்மாந் மம க³மநகாலே கஸ்²சித³ந்யோ(அ)க்³ரோ க³த்வா அவரோஹதி| ");
INSERT INTO santam_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ததா³ யீஸு²ரகத²யத்³ உத்திஷ்ட², தவ ஸ²ய்யாமுத்தோல்ய க்³ருʼஹீத்வா யாஹி| ");
INSERT INTO santam_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ஸ தத்க்ஷணாத் ஸ்வஸ்தோ² பூ⁴த்வா ஸ²ய்யாமுத்தோல்யாதா³ய க³தவாந் கிந்து தத்³தி³நம்ʼ விஸ்²ராமவார​:| ");
INSERT INTO santam_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","தஸ்மாத்³ யிஹூதீ³யா​: ஸ்வஸ்த²ம்ʼ நரம்ʼ வ்யாஹரந் அத்³ய விஸ்²ராமவாரே ஸ²யநீயமாதா³ய ந யாதவ்யம்| ");
INSERT INTO santam_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","தத​: ஸ ப்ரத்யவோசத்³ யோ மாம்ʼ ஸ்வஸ்த²ம் அகார்ஷீத் ஸ²யநீயம் உத்தோல்யாதா³ய யாதும்ʼ மாம்ʼ ஸ ஏவாதி³ஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ததா³ தே(அ)ப்ருʼச்ச²ந் ஸ²யநீயம் உத்தோல்யாதா³ய யாதும்ʼ ய ஆஜ்ஞாபயத் ஸ க​:? ");
INSERT INTO santam_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","கிந்து ஸ க இதி ஸ்வஸ்தீ²பூ⁴தோ நாஜாநாத்³ யதஸ்தஸ்மிந் ஸ்தா²நே ஜநதாஸத்த்வாத்³ யீஸு²​: ஸ்தா²நாந்தரம் ஆக³மத்| ");
INSERT INTO santam_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","தத​: பரம்ʼ யேஸு² ர்மந்தி³ரே தம்ʼ நரம்ʼ ஸாக்ஷாத்ப்ராப்யாகத²யத் பஸ்²யேதா³நீம் அநாமயோ ஜாதோஸி யதா²தி⁴கா து³ர்த³ஸா² ந க⁴டதே தத்³தே⁴தோ​: பாபம்ʼ கர்ம்ம புநர்மாகார்ஷீ​:| ");
INSERT INTO santam_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","தத​: ஸ க³த்வா யிஹூதீ³யாந் அவத³த்³ யீஸு² ர்மாம் அரோகி³ணம் அகார்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ததோ யீஸு² ர்விஸ்²ராமவாரே கர்ம்மேத்³ருʼஸ²ம்ʼ க்ருʼதவாந் இதி ஹேதோ ர்யிஹூதீ³யாஸ்தம்ʼ தாட³யித்வா ஹந்தும் அசேஷ்டந்த| ");
INSERT INTO santam_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","யீஸு²ஸ்தாநாக்²யத் மம பிதா யத் கார்ய்யம்ʼ கரோதி தத³நுரூபம் அஹமபி கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ததோ யிஹூதீ³யாஸ்தம்ʼ ஹந்தும்ʼ புநரயதந்த யதோ விஸ்²ராமவாரம்ʼ நாமந்யத ததே³வ கேவலம்ʼ ந அதி⁴கந்து ஈஸ்²வரம்ʼ ஸ்வபிதரம்ʼ ப்ரோச்ய ஸ்வமபீஸ்²வரதுல்யம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","பஸ்²சாத்³ யீஸு²ரவத³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி புத்ர​: பிதரம்ʼ யத்³யத் கர்ம்ம குர்வ்வந்தம்ʼ பஸ்²யதி தத³திரிக்தம்ʼ ஸ்வேச்சா²த​: கிமபி கர்ம்ம கர்த்தும்ʼ ந ஸ²க்நோதி| பிதா யத் கரோதி புத்ரோபி ததே³வ கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","பிதா புத்ரே ஸ்நேஹம்ʼ கரோதி தஸ்மாத் ஸ்வயம்ʼ யத்³யத் கர்ம்ம கரோதி தத்ஸர்வ்வம்ʼ புத்ரம்ʼ த³ர்ஸ²யதி ; யதா² ச யுஷ்மாகம்ʼ ஆஸ்²சர்ய்யஜ்ஞாநம்ʼ ஜநிஷ்யதே தத³ர்த²ம் இதோபி மஹாகர்ம்ம தம்ʼ த³ர்ஸ²யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","வஸ்துதஸ்து பிதா யதா² ப்ரமிதாந் உத்தா²ப்ய ஸஜிவாந் கரோதி தத்³வத் புத்ரோபி யம்ʼ யம்ʼ இச்ச²தி தம்ʼ தம்ʼ ஸஜீவம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ஸர்வ்வே பிதரம்ʼ யதா² ஸத்குர்வ்வந்தி ததா² புத்ரமபி ஸத்காரயிதும்ʼ பிதா ஸ்வயம்ʼ கஸ்யாபி விசாரமக்ருʼத்வா ஸர்வ்வவிசாராணாம்ʼ பா⁴ரம்ʼ புத்ரே ஸமர்பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ய​: புத்ரம்ʼ ஸத் கரோதி ஸ தஸ்ய ப்ரேரகமபி ஸத் கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","யுஷ்மாநாஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி யோ ஜநோ மம வாக்யம்ʼ ஸ்²ருத்வா மத்ப்ரேரகே விஸ்²வஸிதி ஸோநந்தாயு​: ப்ராப்நோதி கதா³பி த³ண்ட³பா³ஜநம்ʼ ந ப⁴வதி நித⁴நாது³த்தா²ய பரமாயு​: ப்ராப்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி யதா³ ம்ருʼதா ஈஸ்²வரபுத்ரஸ்ய நிநாத³ம்ʼ ஸ்²ரோஷ்யந்தி யே ச ஸ்²ரோஷ்யந்தி தே ஸஜீவா ப⁴விஷ்யந்தி ஸமய ஏதாத்³ருʼஸ² ஆயாதி வரம் இதா³நீமப்யுபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","பிதா யதா² ஸ்வயஞ்ஜீவீ ததா² புத்ராய ஸ்வயஞ்ஜீவித்வாதி⁴காரம்ʼ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ஸ மநுஷ்யபுத்ர​: ஏதஸ்மாத் காரணாத் பிதா த³ண்ட³கரணாதி⁴காரமபி தஸ்மிந் ஸமர்பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ஏதத³ர்தே² யூயம் ஆஸ்²சர்ய்யம்ʼ ந மந்யத்⁴வம்ʼ யதோ யஸ்மிந் ஸமயே தஸ்ய நிநாத³ம்ʼ ஸ்²ருத்வா ஸ்²மஸா²நஸ்தா²​: ஸர்வ்வே ப³ஹிராக³மிஷ்யந்தி ஸமய ஏதாத்³ருʼஸ² உபஸ்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","தஸ்மாத்³ யே ஸத்கர்ம்மாணி க்ருʼதவந்தஸ்த உத்தா²ய ஆயு​: ப்ராப்ஸ்யந்தி யே ச குகர்மாணி க்ருʼதவந்தஸ்த உத்தா²ய த³ண்ட³ம்ʼ ப்ராப்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","அஹம்ʼ ஸ்வயம்ʼ கிமபி கர்த்தும்ʼ ந ஸ²க்நோமி யதா² ஸு²ணோமி ததா² விசாரயாமி மம விசாரஞ்ச ந்யாய்ய​: யதோஹம்ʼ ஸ்வீயாபீ⁴ஷ்டம்ʼ நேஹித்வா மத்ப்ரேரயிது​: பிதுரிஷ்டம் ஈஹே| ");
INSERT INTO santam_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","யதி³ ஸ்வஸ்மிந் ஸ்வயம்ʼ ஸாக்ஷ்யம்ʼ த³தா³மி தர்ஹி தத்ஸாக்ஷ்யம் ஆக்³ராஹ்யம்ʼ ப⁴வதி ; ");
INSERT INTO santam_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","கிந்து மத³ர்தே²(அ)பரோ ஜந​: ஸாக்ஷ்யம்ʼ த³தா³தி மத³ர்தே² தஸ்ய யத் ஸாக்ஷ்யம்ʼ தத் ஸத்யம் ஏதத³ப்யஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","யுஷ்மாபி⁴ ர்யோஹநம்ʼ ப்ரதி லோகேஷு ப்ரேரிதேஷு ஸ ஸத்யகதா²யாம்ʼ ஸாக்ஷ்யமத³தா³த்| ");
INSERT INTO santam_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","மாநுஷாத³ஹம்ʼ ஸாக்ஷ்யம்ʼ நோபேக்ஷே ததா²பி யூயம்ʼ யதா² பரித்ரயத்⁴வே தத³ர்த²ம் இத³ம்ʼ வாக்யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","யோஹந் தே³தீ³ப்யமாநோ தீ³ப இவ தேஜஸ்வீ ஸ்தி²தவாந் யூயம் அல்பகாலம்ʼ தஸ்ய தீ³ப்த்யாநந்தி³தும்ʼ ஸமமந்யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","கிந்து தத்ப்ரமாணாத³பி மம கு³ருதரம்ʼ ப்ரமாணம்ʼ வித்³யதே பிதா மாம்ʼ ப்ரேஷ்ய யத்³யத் கர்ம்ம ஸமாபயிதும்ʼ ஸ²க்த்திமத³தா³த் மயா க்ருʼதம்ʼ தத்தத் கர்ம்ம மத³ர்தே² ப்ரமாணம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ய​: பிதா மாம்ʼ ப்ரேரிதவாந் மோபி மத³ர்தே² ப்ரமாணம்ʼ த³தா³தி| தஸ்ய வாக்யம்ʼ யுஷ்மாபி⁴​: கதா³பி ந ஸ்²ருதம்ʼ தஸ்ய ரூபஞ்ச ந த்³ருʼஷ்டம்ʼ ");
INSERT INTO santam_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","தஸ்ய வாக்யஞ்ச யுஷ்மாகம் அந்த​: கதா³பி ஸ்தா²நம்ʼ நாப்நோதி யத​: ஸ யம்ʼ ப்ரேஷிதவாந் யூயம்ʼ தஸ்மிந் ந விஸ்²வஸித²| ");
INSERT INTO santam_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","த⁴ர்ம்மபுஸ்தகாநி யூயம் ஆலோசயத்⁴வம்ʼ தை ர்வாக்யைரநந்தாயு​: ப்ராப்ஸ்யாம இதி யூயம்ʼ பு³த்⁴யத்⁴வே தத்³த⁴ர்ம்மபுஸ்தகாநி மத³ர்தே² ப்ரமாணம்ʼ த³த³தி| ");
INSERT INTO santam_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ததா²பி யூயம்ʼ பரமாயு​:ப்ராப்தயே மம ஸம்ʼநிதி⁴ம் ந ஜிக³மிஷத²| ");
INSERT INTO santam_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","அஹம்ʼ மாநுஷேப்⁴ய​: ஸத்காரம்ʼ ந க்³ருʼஹ்லாமி| ");
INSERT INTO santam_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","அஹம்ʼ யுஷ்மாந் ஜாநாமி; யுஷ்மாகமந்தர ஈஸ்²வரப்ரேம நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","அஹம்ʼ நிஜபிது ர்நாம்நாக³தோஸ்மி ததா²பி மாம்ʼ ந க்³ருʼஹ்லீத² கிந்து கஸ்²சித்³ யதி³ ஸ்வநாம்நா ஸமாக³மிஷ்யதி தர்ஹி தம்ʼ க்³ரஹீஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","யூயம் ஈஸ்²வராத் ஸத்காரம்ʼ ந சிஷ்டத்வா கேவலம்ʼ பரஸ்பரம்ʼ ஸத்காரம் சேத்³ ஆத³த்⁴வ்வே தர்ஹி கத²ம்ʼ விஸ்²வஸிதும்ʼ ஸ²க்நுத²? ");
INSERT INTO santam_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","புது​: ஸமீபே(அ)ஹம்ʼ யுஷ்மாந் அபவதி³ஷ்யாமீதி மா சிந்தயத யஸ்மிந் , யஸ்மிந் யுஷ்மாகம்ʼ விஸ்²வஸ​: ஸஏவ மூஸா யுஷ்மாந் அபவத³தி| ");
INSERT INTO santam_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","யதி³ யூயம்ʼ தஸ்மிந் வ்யஸ்²வஸிஷ்யத தர்ஹி மய்யபி வ்யஸ்²வஸிஷ்யத, யத் ஸ மயி லிகி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ததோ யதி³ தேந லிகி²தவாநி ந ப்ரதித² தர்ஹி மம வாக்யாநி கத²ம்ʼ ப்ரத்யேஷ்யத²? ");
INSERT INTO santam_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","தத​: பரம்ʼ யீஸு² ர்கா³லீல் ப்ரதே³ஸீ²யஸ்ய திவிரியாநாம்ந​: ஸிந்தோ⁴​: பாரம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ததோ வ்யாதி⁴மல்லோகஸ்வாஸ்த்²யகரணரூபாணி தஸ்யாஸ்²சர்ய்யாணி கர்ம்மாணி த்³ருʼஷ்ட்வா ப³ஹவோ ஜநாஸ்தத்பஸ்²சாத்³ அக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ததோ யீஸு²​: பர்வ்வதமாருஹ்ய தத்ர ஸி²ஷ்யை​: ஸாகம்| ");
INSERT INTO santam_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","தஸ்மிந் ஸமய நிஸ்தாரோத்ஸவநாம்நி யிஹூதீ³யாநாம உத்ஸவ உபஸ்தி²தே ");
INSERT INTO santam_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","யீஸு² ர்நேத்ரே உத்தோல்ய ப³ஹுலோகாந் ஸ்வஸமீபாக³தாந் விலோக்ய பி²லிபம்ʼ ப்ருʼஷ்டவாந் ஏதேஷாம்ʼ போ⁴ஜநாய போ⁴ஜத்³ரவ்யாணி வயம்ʼ குத்ர க்ரேதும்ʼ ஸ²க்ரும​:? ");
INSERT INTO santam_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","வாக்யமித³ம்ʼ தஸ்ய பரீக்ஷார்த²ம் அவாதீ³த் கிந்து யத் கரிஷ்யதி தத் ஸ்வயம் அஜாநாத்| ");
INSERT INTO santam_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","பி²லிப​: ப்ரத்யவோசத் ஏதேஷாம் ஏகைகோ யத்³யல்பம் அல்பம்ʼ ப்ராப்நோதி தர்ஹி முத்³ராபாத³த்³விஸ²தேந க்ரீதபூபா அபி ந்யூநா ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ஸி²மோந் பிதரஸ்ய ப்⁴ராதா ஆந்த்³ரியாக்²ய​: ஸி²ஷ்யாணாமேகோ வ்யாஹ்ருʼதவாந் ");
INSERT INTO santam_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","அத்ர கஸ்யசித்³ பா³லகஸ்ய ஸமீபே பஞ்ச யாவபூபா​: க்ஷுத்³ரமத்ஸ்யத்³வயஞ்ச ஸந்தி கிந்து லோகாநாம்ʼ ஏதாவாதாம்ʼ மத்⁴யே தை​: கிம்ʼ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","பஸ்²சாத்³ யீஸு²ரவத³த் லோகாநுபவேஸ²யத தத்ர ப³ஹுயவஸஸத்த்வாத் பஞ்சஸஹஸ்த்ரேப்⁴யோ ந்யூநா அதி⁴கா வா புருஷா பூ⁴ம்யாம் உபாவிஸ²ந்| ");
INSERT INTO santam_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ததோ யீஸு²ஸ்தாந் பூபாநாதா³ய ஈஸ்²வரஸ்ய கு³ணாந் கீர்த்தயித்வா ஸி²ஷ்யேஷு ஸமார்பயத் ததஸ்தே தேப்⁴ய உபவிஷ்டலோகேப்⁴ய​: பூபாந் யதே²ஷ்டமத்ஸ்யஞ்ச ப்ராது³​:| ");
INSERT INTO santam_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","தேஷு த்ருʼப்தேஷு ஸ தாநவோசத்³ ஏதேஷாம்ʼ கிஞ்சித³பி யதா² நாபசீயதே ததா² ஸர்வ்வாண்யவஸி²ஷ்டாநி ஸம்ʼக்³ருʼஹ்லீத| ");
INSERT INTO santam_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","தத​: ஸர்வ்வேஷாம்ʼ போ⁴ஜநாத் பரம்ʼ தே தேஷாம்ʼ பஞ்சாநாம்ʼ யாவபூபாநாம்ʼ அவஸி²ஷ்டாந்யகி²லாநி ஸம்ʼக்³ருʼஹ்ய த்³வாத³ஸ²ட³ல்லகாந் அபூரயந்| ");
INSERT INTO santam_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","அபரம்ʼ யீஸோ²ரேதாத்³ருʼஸீ²ம் ஆஸ்²சர்ய்யக்ரியாம்ʼ த்³ருʼஷ்ட்வா லோகா மிதோ² வக்துமாரேபி⁴ரே ஜக³தி யஸ்யாக³மநம்ʼ ப⁴விஷ்யதி ஸ ஏவாயம் அவஸ்²யம்ʼ ப⁴விஷ்யத்³வக்த்தா| ");
INSERT INTO santam_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","அதஏவ லோகா ஆக³த்ய தமாக்ரம்ய ராஜாநம்ʼ கரிஷ்யந்தி யீஸு²ஸ்தேஷாம் ஈத்³ருʼஸ²ம்ʼ மாநஸம்ʼ விஜ்ஞாய புநஸ்²ச பர்வ்வதம் ஏகாகீ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ஸாயம்ʼகால உபஸ்தி²தே ஸி²ஷ்யா ஜலதி⁴தடம்ʼ வ்ரஜித்வா நாவமாருஹ்ய நக³ரதி³ஸி² ஸிந்தௌ⁴ வாஹயித்வாக³மந்| ");
INSERT INTO santam_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","தஸ்மிந் ஸமயே திமிர உபாதிஷ்ட²த் கிந்து யீஷுஸ்தேஷாம்ʼ ஸமீபம்ʼ நாக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ததா³ ப்ரப³லபவநவஹநாத் ஸாக³ரே மஹாதரங்கோ³ ப⁴விதும் ஆரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ததஸ்தே வாஹயித்வா த்³வித்ராந் க்ரோஸா²ந் க³தா​: பஸ்²சாத்³ யீஸு²ம்ʼ ஜலதே⁴ருபரி பத்³ப்⁴யாம்ʼ வ்ரஜந்தம்ʼ நௌகாந்திகம் ஆக³ச்ச²ந்தம்ʼ விலோக்ய த்ராஸயுக்தா அப⁴வந் ");
INSERT INTO santam_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","கிந்து ஸ தாநுக்த்தவாந் அயமஹம்ʼ மா பை⁴ஷ்ட| ");
INSERT INTO santam_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ததா³ தே தம்ʼ ஸ்வைரம்ʼ நாவி க்³ருʼஹீதவந்த​: ததா³ தத்க்ஷணாத்³ உத்³தி³ஷ்டஸ்தா²நே நௌருபாஸ்தா²த்| ");
INSERT INTO santam_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","யயா நாவா ஸி²ஷ்யா அக³ச்ச²ந் தத³ந்யா காபி நௌகா தஸ்மிந் ஸ்தா²நே நாஸீத் ததோ யீஸு²​: ஸி²ஷ்யை​: ஸாகம்ʼ நாக³மத் கேவலா​: ஸி²ஷ்யா அக³மந் ஏதத் பாரஸ்தா² லோகா ஜ்ஞாதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","கிந்து தத​: பரம்ʼ ப்ரபு⁴ ர்யத்ர ஈஸ்²வரஸ்ய கு³ணாந் அநுகீர்த்த்ய லோகாந் பூபாந் அபோ⁴ஜயத் தத்ஸ்தா²நஸ்ய ஸமீபஸ்த²திவிரியாயா அபராஸ்தரணய ஆக³மந்| ");
INSERT INTO santam_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","யீஸு²ஸ்தத்ர நாஸ்தி ஸி²ஷ்யா அபி தத்ர நா ஸந்தி லோகா இதி விஜ்ஞாய யீஸு²ம்ʼ க³வேஷயிதும்ʼ தரணிபி⁴​: கப²ர்நாஹூம் புரம்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ததஸ்தே ஸரித்பதே​: பாரே தம்ʼ ஸாக்ஷாத் ப்ராப்ய ப்ராவோசந் ஹே கு³ரோ ப⁴வாந் அத்ர ஸ்தா²நே கதா³க³மத்? ");
INSERT INTO santam_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ததா³ யீஸு²ஸ்தாந் ப்ரத்யவாதீ³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி ஆஸ்²சர்ய்யகர்ம்மத³ர்ஸ²நாத்³தே⁴தோ ர்ந கிந்து பூபபோ⁴ஜநாத் தேந த்ருʼப்தத்வாஞ்ச மாம்ʼ க³வேஷயத²| ");
INSERT INTO santam_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","க்ஷயணீயப⁴க்ஷ்யார்த²ம்ʼ மா ஸ்²ராமிஷ்ட கிந்த்வந்தாயுர்ப⁴க்ஷ்யார்த²ம்ʼ ஸ்²ராம்யத, தஸ்மாத் தாத்³ருʼஸ²ம்ʼ ப⁴க்ஷ்யம்ʼ மநுஜபுத்ரோ யுஷ்மாப்⁴யம்ʼ தா³ஸ்யதி; தஸ்மிந் தாத ஈஸ்²வர​: ப்ரமாணம்ʼ ப்ராதா³த்| ");
INSERT INTO santam_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ததா³ தே(அ)ப்ருʼச்ச²ந் ஈஸ்²வராபி⁴மதம்ʼ கர்ம்ம கர்த்தும் அஸ்மாபி⁴​: கிம்ʼ கர்த்தவ்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ததோ யீஸு²ரவத³த்³ ஈஸ்²வரோ யம்ʼ ப்ரைரயத் தஸ்மிந் விஸ்²வஸநம் ஈஸ்²வராபி⁴மதம்ʼ கர்ம்ம| ");
INSERT INTO santam_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ததா³ தே வ்யாஹரந் ப⁴வதா கிம்ʼ லக்ஷணம்ʼ த³ர்ஸி²தம்ʼ யத்³த்³ருʼஷ்ட்வா ப⁴வதி விஸ்²வஸிஷ்யாம​:? த்வயா கிம்ʼ கர்ம்ம க்ருʼதம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","அஸ்மாகம்ʼ பூர்வ்வபுருஷா மஹாப்ராந்தரே மாந்நாம்ʼ போ⁴க்த்தும்ʼ ப்ராபு​: யதா² லிபிராஸ்தே| ஸ்வர்கீ³யாணி து ப⁴க்ஷ்யாணி ப்ரத³தௌ³ பரமேஸ்²வர​:| ");
INSERT INTO santam_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ததா³ யீஸு²ரவத³த்³ அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி மூஸா யுஷ்மாப்⁴யம்ʼ ஸ்வர்கீ³யம்ʼ ப⁴க்ஷ்யம்ʼ நாதா³த் கிந்து மம பிதா யுஷ்மாப்⁴யம்ʼ ஸ்வர்கீ³யம்ʼ பரமம்ʼ ப⁴க்ஷ்யம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ய​: ஸ்வர்கா³த³வருஹ்ய ஜக³தே ஜீவநம்ʼ த³தா³தி ஸ ஈஸ்²வரத³த்தப⁴க்ஷ்யரூப​:| ");
INSERT INTO santam_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ததா³ தே ப்ராவோசந் ஹே ப்ரபோ⁴ ப⁴க்ஷ்யமித³ம்ʼ நித்யமஸ்மப்⁴யம்ʼ த³தா³து| ");
INSERT INTO santam_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","யீஸு²ரவத³த்³ அஹமேவ ஜீவநரூபம்ʼ ப⁴க்ஷ்யம்ʼ யோ ஜநோ மம ஸந்நிதி⁴ம் ஆக³ச்ச²தி ஸ ஜாது க்ஷுதா⁴ர்த்தோ ந ப⁴விஷ்யதி, ததா² யோ ஜநோ மாம்ʼ ப்ரத்யேதி ஸ ஜாது த்ருʼஷார்த்தோ ந ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","மாம்ʼ த்³ருʼஷ்ட்வாபி யூயம்ʼ ந விஸ்²வஸித² யுஷ்மாநஹம் இத்யவோசம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","பிதா மஹ்யம்ʼ யாவதோ லோகாநத³தா³த் தே ஸர்வ்வ ஏவ மமாந்திகம் ஆக³மிஷ்யந்தி ய​: கஸ்²சிச்ச மம ஸந்நிதி⁴ம் ஆயாஸ்யதி தம்ʼ கேநாபி ப்ரகாரேண ந தூ³ரீகரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","நிஜாபி⁴மதம்ʼ ஸாத⁴யிதும்ʼ ந ஹி கிந்து ப்ரேரயிதுரபி⁴மதம்ʼ ஸாத⁴யிதும்ʼ ஸ்வர்கா³த்³ ஆக³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ஸ யாந் யாந் லோகாந் மஹ்யமத³தா³த் தேஷாமேகமபி ந ஹாரயித்வா ஸே²ஷதி³நே ஸர்வ்வாநஹம் உத்தா²பயாமி இத³ம்ʼ மத்ப்ரேரயிது​: பிதுரபி⁴மதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ய​: கஸ்²சிந் மாநவஸுதம்ʼ விலோக்ய விஸ்²வஸிதி ஸ ஸே²ஷதி³நே மயோத்தா²பித​: ஸந் அநந்தாயு​: ப்ராப்ஸ்யதி இதி மத்ப்ரேரகஸ்யாபி⁴மதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ததா³ ஸ்வர்கா³த்³ யத்³ ப⁴க்ஷ்யம் அவாரோஹத் தத்³ ப⁴க்ஷ்யம் அஹமேவ யிஹூதீ³யலோகாஸ்தஸ்யைதத்³ வாக்யே விவத³மாநா வக்த்துமாரேபி⁴ரே ");
INSERT INTO santam_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","யூஷப²​: புத்ரோ யீஸு² ர்யஸ்ய மாதாபிதரௌ வயம்ʼ ஜாநீம ஏஷ கிம்ʼ ஸஏவ ந? தர்ஹி ஸ்வர்கா³த்³ அவாரோஹம் இதி வாக்யம்ʼ கத²ம்ʼ வக்த்தி? ");
INSERT INTO santam_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ததா³ யீஸு²ஸ்தாந் ப்ரத்யவத³த் பரஸ்பரம்ʼ மா விவத³த்⁴வம்ʼ ");
INSERT INTO santam_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","மத்ப்ரேரகேண பித்ரா நாக்ருʼஷ்ட​: கோபி ஜநோ மமாந்திகம் ஆயாதும்ʼ ந ஸ²க்நோதி கிந்த்வாக³தம்ʼ ஜநம்ʼ சரமே(அ)ஹ்நி ப்ரோத்தா²பயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","தே ஸர்வ்வ ஈஸ்²வரேண ஸி²க்ஷிதா ப⁴விஷ்யந்தி ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு லிபிரித்த²மாஸ்தே அதோ ய​: கஸ்²சித் பிது​: ஸகாஸா²த் ஸ்²ருத்வா ஸி²க்ஷதே ஸ ஏவ மம ஸமீபம் ஆக³மிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ய ஈஸ்²வராத்³ அஜாயத தம்ʼ விநா கோபி மநுஷ்யோ ஜநகம்ʼ நாத³ர்ஸ²த் கேவல​: ஸஏவ தாதம் அத்³ராக்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","அஹம்ʼ யுஷ்மாந் யதா²ர்த²தரம்ʼ வதா³மி யோ ஜநோ மயி விஸ்²வாஸம்ʼ கரோதி ஸோநந்தாயு​: ப்ராப்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","அஹமேவ தஜ்ஜீவநப⁴க்ஷ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","யுஷ்மாகம்ʼ பூர்வ்வபுருஷா மஹாப்ராந்தரே மந்நாப⁴க்ஷ்யம்ʼ பூ⁴க்த்தாபி ம்ருʼதா​: ");
INSERT INTO santam_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","கிந்து யத்³ப⁴க்ஷ்யம்ʼ ஸ்வர்கா³தா³க³ச்ச²த் தத்³ யதி³ கஸ்²சித்³ பு⁴ங்க்த்தே தர்ஹி ஸ ந ம்ரியதே| ");
INSERT INTO santam_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","யஜ்ஜீவநப⁴க்ஷ்யம்ʼ ஸ்வர்கா³தா³க³ச்ச²த் ஸோஹமேவ இத³ம்ʼ ப⁴க்ஷ்யம்ʼ யோ ஜநோ பு⁴ங்க்த்தே ஸ நித்யஜீவீ ப⁴விஷ்யதி| புநஸ்²ச ஜக³தோ ஜீவநார்த²மஹம்ʼ யத் ஸ்வகீயபிஸி²தம்ʼ தா³ஸ்யாமி ததே³வ மயா விதரிதம்ʼ ப⁴க்ஷ்யம்| ");
INSERT INTO santam_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","தஸ்மாத்³ யிஹூதீ³யா​: பரஸ்பரம்ʼ விவத³மாநா வக்த்துமாரேபி⁴ரே ஏஷ போ⁴ஜநார்த²ம்ʼ ஸ்வீயம்ʼ பலலம்ʼ கத²ம் அஸ்மப்⁴யம்ʼ தா³ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ததா³ யீஸு²ஸ்தாந் ஆவோசத்³ யுஷ்மாநஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி மநுஷ்யபுத்ரஸ்யாமிஷே யுஷ்மாபி⁴ ர்ந பு⁴க்த்தே தஸ்ய ருதி⁴ரே ச ந பீதே ஜீவநேந ஸார்த்³த⁴ம்ʼ யுஷ்மாகம்ʼ ஸம்ப³ந்தோ⁴ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","யோ மமாமிஷம்ʼ ஸ்வாத³தி மம ஸுதி⁴ரஞ்ச பிவதி ஸோநந்தாயு​: ப்ராப்நோதி தத​: ஸே²ஷே(அ)ஹ்நி தமஹம் உத்தா²பயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","யதோ மதீ³யமாமிஷம்ʼ பரமம்ʼ ப⁴க்ஷ்யம்ʼ ததா² மதீ³யம்ʼ ஸோ²ணிதம்ʼ பரமம்ʼ பேயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","யோ ஜநோ மதீ³யம்ʼ பலலம்ʼ ஸ்வாத³தி மதீ³யம்ʼ ருதி⁴ரஞ்ச பிவதி ஸ மயி வஸதி தஸ்மிந்நஹஞ்ச வஸாமி| ");
INSERT INTO santam_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","மத்ப்ரேரயித்ரா ஜீவதா தாதேந யதா²ஹம்ʼ ஜீவாமி தத்³வத்³ ய​: கஸ்²சிந் மாமத்தி ஸோபி மயா ஜீவிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","யத்³ப⁴க்ஷ்யம்ʼ ஸ்வர்கா³தா³க³ச்ச²த் ததி³த³ம்ʼ யந்மாந்நாம்ʼ ஸ்வாதி³த்வா யுஷ்மாகம்ʼ பிதரோ(அ)ம்ரியந்த தாத்³ருʼஸ²ம் இத³ம்ʼ ப⁴க்ஷ்யம்ʼ ந ப⁴வதி இத³ம்ʼ ப⁴க்ஷ்யம்ʼ யோ ப⁴க்ஷதி ஸ நித்யம்ʼ ஜீவிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","யதா³ கப²ர்நாஹூம் புர்ய்யாம்ʼ ப⁴ஜநகே³ஹே உபாதி³ஸ²த் ததா³ கதா² ஏதா அகத²யத்| ");
INSERT INTO santam_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ததே³த்த²ம்ʼ ஸ்²ருத்வா தஸ்ய ஸி²ஷ்யாணாம் அநேகே பரஸ்பரம் அகத²யந் இத³ம்ʼ கா³ட⁴ம்ʼ வாக்யம்ʼ வாக்யமீத்³ருʼஸ²ம்ʼ க​: ஸ்²ரோதும்ʼ ஸ²க்ருயாத்? ");
INSERT INTO santam_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","கிந்து யீஸு²​: ஸி²ஷ்யாணாம் இத்த²ம்ʼ விவாத³ம்ʼ ஸ்வசித்தே விஜ்ஞாய கதி²தவாந் இத³ம்ʼ வாக்யம்ʼ கிம்ʼ யுஷ்மாகம்ʼ விக்⁴நம்ʼ ஜநயதி? ");
INSERT INTO santam_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","யதி³ மநுஜஸுதம்ʼ பூர்வ்வவாஸஸ்தா²நம் ஊர்த்³வ்வம்ʼ க³ச்ச²ந்தம்ʼ பஸ்²யத² தர்ஹி கிம்ʼ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ஆத்மைவ ஜீவநதா³யக​: வபு ர்நிஷ்ப²லம்ʼ யுஷ்மப்⁴யமஹம்ʼ யாநி வசாம்ʼஸி கத²யாமி தாந்யாத்மா ஜீவநஞ்ச| ");
INSERT INTO santam_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","கிந்து யுஷ்மாகம்ʼ மத்⁴யே கேசந அவிஸ்²வாஸிந​: ஸந்தி கே கே ந விஸ்²வஸந்தி கோ வா தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி தாந் யீஸு²ராப்ரத²மாத்³ வேத்தி| ");
INSERT INTO santam_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","அபரமபி கதி²தவாந் அஸ்மாத் காரணாத்³ அகத²யம்ʼ பிது​: ஸகாஸா²த் ஸ²க்த்திமப்ராப்ய கோபி மமாந்திகம் ஆக³ந்தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","தத்காலே(அ)நேகே ஸி²ஷ்யா வ்யாகு⁴ட்ய தேந ஸார்த்³த⁴ம்ʼ புந ர்நாக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ததா³ யீஸு² ர்த்³வாத³ஸ²ஸி²ஷ்யாந் உக்த்தவாந் யூயமபி கிம்ʼ யாஸ்யத²? ");
INSERT INTO santam_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","தத​: ஸி²மோந் பிதர​: ப்ரத்யவோசத் ஹே ப்ரபோ⁴ கஸ்யாப்⁴யர்ணம்ʼ க³மிஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","அநந்தஜீவநதா³யிந்யோ யா​: கதா²ஸ்தாஸ்தவைவ| ப⁴வாந் அமரேஸ்²வரஸ்யாபி⁴ஷிக்த்தபுத்ர இதி விஸ்²வஸ்ய நிஸ்²சிதம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ததா³ யீஸு²ரவத³த் கிமஹம்ʼ யுஷ்மாகம்ʼ த்³வாத³ஸ²ஜநாந் மநோநீதாந் ந க்ருʼதவாந்? கிந்து யுஷ்மாகம்ʼ மத்⁴யேபி கஸ்²சிதே³கோ விக்⁴நகாரீ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","இமாம்ʼ கத²ம்ʼ ஸ ஸி²மோந​: புத்ரம் ஈஷ்கரீயோதீயம்ʼ யிஹூதா³ம் உத்³தி³ஸ்²ய கதி²தவாந் யதோ த்³வாத³ஸா²நாம்ʼ மத்⁴யே க³ணித​: ஸ தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","தத​: பரம்ʼ யிஹூதீ³யலோகாஸ்தம்ʼ ஹந்தும்ʼ ஸமைஹந்த தஸ்மாத்³ யீஸு² ர்யிஹூதா³ப்ரதே³ஸே² பர்ய்யடிதும்ʼ நேச்ச²ந் கா³லீல் ப்ரதே³ஸே² பர்ய்யடிதும்ʼ ப்ராரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","கிந்து தஸ்மிந் ஸமயே யிஹூதீ³யாநாம்ʼ தூ³ஷ்யவாஸநாமோத்ஸவ உபஸ்தி²தே ");
INSERT INTO santam_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","தஸ்ய ப்⁴ராதரஸ்தம் அவத³ந் யாநி கர்ம்மாணி த்வயா க்ரியந்தே தாநி யதா² தவ ஸி²ஷ்யா​: பஸ்²யந்தி தத³ர்த²ம்ʼ த்வமித​: ஸ்தா²நாத்³ யிஹூதீ³யதே³ஸ²ம்ʼ வ்ரஜ| ");
INSERT INTO santam_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ய​: கஸ்²சித் ஸ்வயம்ʼ ப்ரசிகாஸி²ஷதி ஸ கதா³பி கு³ப்தம்ʼ கர்ம்ம ந கரோதி யதீ³த்³ருʼஸ²ம்ʼ கர்ம்ம கரோஷி தர்ஹி ஜக³தி நிஜம்ʼ பரிசாயய| ");
INSERT INTO santam_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","யதஸ்தஸ்ய ப்⁴ராதரோபி தம்ʼ ந விஸ்²வஸந்தி| ");
INSERT INTO santam_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ததா³ யீஸு²ஸ்தாந் அவோசத் மம ஸமய இதா³நீம்ʼ நோபதிஷ்ட²தி கிந்து யுஷ்மாகம்ʼ ஸமய​: ஸததம் உபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ஜக³தோ லோகா யுஷ்மாந் ருʼதீயிதும்ʼ ந ஸ²க்ருவந்தி கிந்து மாமேவ ருʼதீயந்தே யதஸ்தேஷாம்ʼ கர்மாணி து³ஷ்டாநி தத்ர ஸாக்ஷ்யமித³ம் அஹம்ʼ த³தா³மி| ");
INSERT INTO santam_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","அதஏவ யூயம் உத்ஸவே(அ)ஸ்மிந் யாத நாஹம் இதா³நீம் அஸ்மிந்நுத்ஸவே யாமி யதோ மம ஸமய இதா³நீம்ʼ ந ஸம்பூர்ண​:| ");
INSERT INTO santam_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","இதி வாக்யம் உக்த்த்வா ஸ கா³லீலி ஸ்தி²தவாந் ");
INSERT INTO santam_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","கிந்து தஸ்ய ப்⁴ராத்ருʼஷு தத்ர ப்ரஸ்தி²தேஷு ஸத்ஸு ஸோ(அ)ப்ரகட உத்ஸவம் அக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","அநந்தரம் உத்ஸவம் உபஸ்தி²தா யிஹூதீ³யாஸ்தம்ʼ ம்ருʼக³யித்வாப்ருʼச்ச²ந் ஸ குத்ர? ");
INSERT INTO santam_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ததோ லோகாநாம்ʼ மத்⁴யே தஸ்மிந் நாநாவிதா⁴ விவாதா³ ப⁴விதும் ஆரப்³த⁴வந்த​:| கேசித்³ அவோசந் ஸ உத்தம​: புருஷ​: கேசித்³ அவோசந் ந ததா² வரம்ʼ லோகாநாம்ʼ ப்⁴ரமம்ʼ ஜநயதி| ");
INSERT INTO santam_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","கிந்து யிஹூதீ³யாநாம்ʼ ப⁴யாத் கோபி தஸ்ய பக்ஷே ஸ்பஷ்டம்ʼ நாகத²யத்| ");
INSERT INTO santam_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","தத​: பரம் உத்ஸவஸ்ய மத்⁴யஸமயே யீஸு² ர்மந்தி³ரம்ʼ க³த்வா ஸமுபதி³ஸ²தி ஸ்ம| ");
INSERT INTO santam_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ததோ யிஹூதீ³யா லோகா ஆஸ்²சர்ய்யம்ʼ ஜ்ஞாத்வாகத²யந் ஏஷா மாநுஷோ நாதீ⁴த்யா கத²ம் ஏதாத்³ருʼஸோ² வித்³வாநபூ⁴த்? ");
INSERT INTO santam_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ததா³ யீஸு²​: ப்ரத்யவோசத்³ உபதே³ஸோ²யம்ʼ ந மம கிந்து யோ மாம்ʼ ப்ரேஷிதவாந் தஸ்ய| ");
INSERT INTO santam_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","யோ ஜநோ நிதே³ஸ²ம்ʼ தஸ்ய க்³ரஹீஷ்யதி மமோபதே³ஸோ² மத்தோ ப⁴வதி கிம் ஈஸ்²வராத்³ ப⁴வதி ஸ க³நஸ்தஜ்ஜ்ஞாதும்ʼ ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","யோ ஜந​: ஸ்வத​: கத²யதி ஸ ஸ்வீயம்ʼ கௌ³ரவம் ஈஹதே கிந்து ய​: ப்ரேரயிது ர்கௌ³ரவம் ஈஹதே ஸ ஸத்யவாதீ³ தஸ்மிந் கோப்யத⁴ர்ம்மோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","மூஸா யுஷ்மப்⁴யம்ʼ வ்யவஸ்தா²க்³ரந்த²ம்ʼ கிம்ʼ நாத³தா³த்? கிந்து யுஷ்மாகம்ʼ கோபி தாம்ʼ வ்யவஸ்தா²ம்ʼ ந ஸமாசரதி| மாம்ʼ ஹந்தும்ʼ குதோ யதத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ததா³ லோகா அவத³ந் த்வம்ʼ பூ⁴தக்³ரஸ்தஸ்த்வாம்ʼ ஹந்தும்ʼ கோ யததே? ");
INSERT INTO santam_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ததோ யீஸு²ரவோசத்³ ஏகம்ʼ கர்ம்ம மயாகாரி தஸ்மாத்³ யூயம்ʼ ஸர்வ்வ மஹாஸ்²சர்ய்யம்ʼ மந்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","மூஸா யுஷ்மப்⁴யம்ʼ த்வக்சே²த³விதி⁴ம்ʼ ப்ரத³தௌ³ ஸ மூஸாதோ ந ஜாத​: கிந்து பித்ருʼபுருஷேப்⁴யோ ஜாத​: தேந விஸ்²ராமவாரே(அ)பி மாநுஷாணாம்ʼ த்வக்சே²த³ம்ʼ குருத²| ");
INSERT INTO santam_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","அதஏவ விஸ்²ராமவாரே மநுஷ்யாணாம்ʼ த்வக்சே²தே³ க்ருʼதே யதி³ மூஸாவ்யவஸ்தா²மங்க³நம்ʼ ந ப⁴வதி தர்ஹி மயா விஸ்²ராமவாரே மாநுஷ​: ஸம்பூர்ணரூபேண ஸ்வஸ்தோ²(அ)காரி தத்காரணாத்³ யூயம்ʼ கிம்ʼ மஹ்யம்ʼ குப்யத²? ");
INSERT INTO santam_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ஸபக்ஷபாதம்ʼ விசாரமக்ருʼத்வா ந்யாய்யம்ʼ விசாரம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ததா³ யிரூஸா²லம் நிவாஸிந​: கதிபயஜநா அகத²யந் இமே யம்ʼ ஹந்தும்ʼ சேஷ்டந்தே ஸ ஏவாயம்ʼ கிம்ʼ ந? ");
INSERT INTO santam_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","கிந்து பஸ்²யத நிர்ப⁴ய​: ஸந் கதா²ம்ʼ கத²யதி ததா²பி கிமபி அ வத³ந்த்யேதே அயமேவாபி⁴ஷிக்த்தோ ப⁴வதீதி நிஸ்²சிதம்ʼ கிமதி⁴பதயோ ஜாநந்தி? ");
INSERT INTO santam_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","மநுஜோயம்ʼ கஸ்மாதா³க³மத்³ இதி வயம்ʼ ஜாநோம​: கிந்த்வபி⁴ஷிக்த்த ஆக³தே ஸ கஸ்மாதா³க³தவாந் இதி கோபி ஜ்ஞாதும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ததா³ யீஸு² ர்மத்⁴யேமந்தி³ரம் உபதி³ஸ²ந் உச்சை​:காரம் உக்த்தவாந் யூயம்ʼ கிம்ʼ மாம்ʼ ஜாநீத²? கஸ்மாச்சாக³தோஸ்மி தத³பி கிம்ʼ ஜாநீத²? நாஹம்ʼ ஸ்வத ஆக³தோஸ்மி கிந்து ய​: ஸத்யவாதீ³ ஸஏவ மாம்ʼ ப்ரேஷிதவாந் யூயம்ʼ தம்ʼ ந ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","தமஹம்ʼ ஜாநே தேநாஹம்ʼ ப்ரேரித அக³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","தஸ்மாத்³ யிஹூதீ³யாஸ்தம்ʼ த⁴ர்த்தும் உத்³யதாஸ்ததா²பி கோபி தஸ்ய கா³த்ரே ஹஸ்தம்ʼ நார்பயத்³ யதோ ஹேதோஸ்ததா³ தஸ்ய ஸமயோ நோபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","கிந்து ப³ஹவோ லோகாஸ்தஸ்மிந் விஸ்²வஸ்ய கதி²தவாந்தோ(அ)பி⁴ஷிக்த்தபுருஷ ஆக³த்ய மாநுஷஸ்யாஸ்ய க்ரியாப்⁴ய​: கிம் அதி⁴கா ஆஸ்²சர்ய்யா​: க்ரியா​: கரிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","தத​: பரம்ʼ லோகாஸ்தஸ்மிந் இத்த²ம்ʼ விவத³ந்தே பி²ரூஸி²ந​: ப்ரதா⁴நயாஜகாஞ்சேதி ஸ்²ருதவந்தஸ்தம்ʼ த்⁴ருʼத்வா நேதும்ʼ பதா³திக³ணம்ʼ ப்ரேஷயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ததோ யீஸு²ரவத³த்³ அஹம் அல்பதி³நாநி யுஷ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ ஸ்தி²த்வா மத்ப்ரேரயிது​: ஸமீபம்ʼ யாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","மாம்ʼ ம்ருʼக³யிஷ்யத்⁴வே கிந்தூத்³தே³ஸ²ம்ʼ ந லப்ஸ்யத்⁴வே ரத்ர ஸ்தா²ஸ்யாமி தத்ர யூயம்ʼ க³ந்தும்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ததா³ யிஹூதீ³யா​: பரஸ்பரம்ʼ வக்த்துமாரேபி⁴ரே அஸ்யோத்³தே³ஸ²ம்ʼ ந ப்ராப்ஸ்யாம ஏதாத்³ருʼஸ²ம்ʼ கிம்ʼ ஸ்தா²நம்ʼ யாஸ்யதி? பி⁴ந்நதே³ஸே² விகீர்ணாநாம்ʼ யிஹூதீ³யாநாம்ʼ ஸந்நிதி⁴ம் ஏஷ க³த்வா தாந் உபதே³க்ஷ்யதி கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","நோ சேத் மாம்ʼ க³வேஷயிஷ்யத² கிந்தூத்³தே³ஸ²ம்ʼ ந ப்ராப்ஸ்யத² ஏஷ கோத்³ருʼஸ²ம்ʼ வாக்யமித³ம்ʼ வத³தி? ");
INSERT INTO santam_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","அநந்தரம் உத்ஸவஸ்ய சரமே(அ)ஹநி அர்தா²த் ப்ரதா⁴நதி³நே யீஸு²ருத்திஷ்ட²ந் உச்சை​:காரம் ஆஹ்வயந் உதி³தவாந் யதி³ கஸ்²சித் த்ருʼஷார்த்தோ ப⁴வதி தர்ஹி மமாந்திகம் ஆக³த்ய பிவது| ");
INSERT INTO santam_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ய​: கஸ்²சிந்மயி விஸ்²வஸிதி த⁴ர்ம்மக்³ரந்த²ஸ்ய வசநாநுஸாரேண தஸ்யாப்⁴யந்தரதோ(அ)ம்ருʼததோயஸ்ய ஸ்ரோதாம்ʼஸி நிர்க³மிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","யே தஸ்மிந் விஸ்²வஸந்தி த ஆத்மாநம்ʼ ப்ராப்ஸ்யந்தீத்யர்தே² ஸ இத³ம்ʼ வாக்யம்ʼ வ்யாஹ்ருʼதவாந் ஏதத்காலம்ʼ யாவத்³ யீஸு² ர்விப⁴வம்ʼ ந ப்ராப்தஸ்தஸ்மாத் பவித்ர ஆத்மா நாதீ³யத| ");
INSERT INTO santam_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ஏதாம்ʼ வாணீம்ʼ ஸ்²ருத்வா ப³ஹவோ லோகா அவத³ந் அயமேவ நிஸ்²சிதம்ʼ ஸ ப⁴விஷ்யத்³வாதீ³| ");
INSERT INTO santam_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","கேசித்³ அகத²யந் ஏஷஏவ ஸோபி⁴ஷிக்த்த​: கிந்து கேசித்³ அவத³ந் ஸோபி⁴ஷிக்த்த​: கிம்ʼ கா³லீல் ப்ரதே³ஸே² ஜநிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ஸோபி⁴ஷிக்த்தோ தா³யூதோ³ வம்ʼஸே² தா³யூதோ³ ஜந்மஸ்தா²நே பை³த்லேஹமி பத்தநே ஜநிஷ்யதே த⁴ர்ம்மக்³ரந்தே² கிமித்த²ம்ʼ லிகி²தம்ʼ நாஸ்தி? ");
INSERT INTO santam_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","இத்த²ம்ʼ தஸ்மிந் லோகாநாம்ʼ பி⁴ந்நவாக்யதா ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","கதிபயலோகாஸ்தம்ʼ த⁴ர்த்தும் ஐச்ச²ந் ததா²பி தத்³வபுஷி கோபி ஹஸ்தம்ʼ நார்பயத்| ");
INSERT INTO santam_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","அநந்தரம்ʼ பாதா³திக³ணே ப்ரதா⁴நயாஜகாநாம்ʼ பி²ரூஸி²நாஞ்ச ஸமீபமாக³தவதி தே தாந் அப்ருʼச்ச²ந் குதோ ஹேதோஸ்தம்ʼ நாநயத? ");
INSERT INTO santam_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ததா³ பதா³தய​: ப்ரத்யவத³ந் ஸ மாநவ இவ கோபி கதா³பி நோபாதி³ஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","தத​: பி²ரூஸி²ந​: ப்ராவோசந் யூயமபி கிமப்⁴ராமிஷ்ட? ");
INSERT INTO santam_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","அதி⁴பதீநாம்ʼ பி²ரூஸி²நாஞ்ச கோபி கிம்ʼ தஸ்மிந் வ்யஸ்²வஸீத்? ");
INSERT INTO santam_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","யே ஸா²ஸ்த்ரம்ʼ ந ஜாநந்தி த இமே(அ)த⁴மலோகாஏவ ஸா²பக்³ரஸ்தா​:| ");
INSERT INTO santam_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ததா³ நிகதீ³மநாமா தேஷாமேகோ ய​: க்ஷணதா³யாம்ʼ யீஸோ²​: ஸந்நிதி⁴ம் அகா³த் ஸ உக்த்தவாந் ");
INSERT INTO santam_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","தஸ்ய வாக்யே ந ஸ்²ருதே கர்ம்மணி ச ந விதி³தே (அ)ஸ்மாகம்ʼ வ்யவஸ்தா² கிம்ʼ கஞ்சந மநுஜம்ʼ தோ³ஷீகரோதி? ");
INSERT INTO santam_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ததஸ்தே வ்யாஹரந் த்வமபி கிம்ʼ கா³லீலீயலோக​:? விவிச்ய பஸ்²ய க³லீலி கோபி ப⁴விஷ்யத்³வாதீ³ நோத்பத்³யதே| ");
INSERT INTO santam_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","தத​: பரம்ʼ ஸர்வ்வே ஸ்வம்ʼ ஸ்வம்ʼ க்³ருʼஹம்ʼ க³தா​: கிந்து யீஸு² ர்ஜைதுநநாமாநம்ʼ ஸி²லோச்சயம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ப்ரத்யூஷே யீஸு²​: பநர்மந்தி³ரம் ஆக³ச்ச²த் ");
INSERT INTO santam_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","தத​: ஸர்வ்வேஷு லோகேஷு தஸ்ய ஸமீப ஆக³தேஷு ஸ உபவிஸ்²ய தாந் உபதே³ஷ்டும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ததா³ அத்⁴யாபகா​: பி²ரூஸி²நஞ்ச வ்யபி⁴சாரகர்ம்மணி த்⁴ருʼதம்ʼ ஸ்த்ரியமேகாம் ஆநிய ஸர்வ்வேஷாம்ʼ மத்⁴யே ஸ்தா²பயித்வா வ்யாஹரந் ");
INSERT INTO santam_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ஹே கு³ரோ யோஷிதம் இமாம்ʼ வ்யபி⁴சாரகர்ம்ம குர்வ்வாணாம்ʼ லோகா த்⁴ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ஏதாத்³ருʼஸ²லோகா​: பாஷாணாகா⁴தேந ஹந்தவ்யா இதி விதி⁴ர்மூஸாவ்யவஸ்தா²க்³ரந்தே² லிகி²தோஸ்தி கிந்து ப⁴வாந் கிமாதி³ஸ²தி? ");
INSERT INTO santam_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","தே தமபவதி³தும்ʼ பரீக்ஷாபி⁴ப்ராயேண வாக்யமித³ம் அப்ருʼச்ச²ந் கிந்து ஸ ப்ரஹ்வீபூ⁴ய பூ⁴மாவங்க³ல்யா லேகி²தும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ததஸ்தை​: புந​: புந​: ப்ருʼஷ்ட உத்தா²ய கதி²தவாந் யுஷ்மாகம்ʼ மத்⁴யே யோ ஜநோ நிரபராதீ⁴ ஸஏவ ப்ரத²மம் ஏநாம்ʼ பாஷாணேநாஹந்து| ");
INSERT INTO santam_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","பஸ்²சாத் ஸ புநஸ்²ச ப்ரஹ்வீபூ⁴ய பூ⁴மௌ லேகி²தும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","தாம்ʼ கத²ம்ʼ ஸ்²ருத்வா தே ஸ்வஸ்வமநஸி ப்ரபோ³த⁴ம்ʼ ப்ராப்ய ஜ்யேஷ்டா²நுக்ரமம்ʼ ஏகைகஸ²​: ஸர்வ்வே ப³ஹிரக³ச்ச²ந் ததோ யீஸு²ரேகாகீ தயக்த்தோப⁴வத் மத்⁴யஸ்தா²நே த³ண்டா³யமாநா ஸா யோஷா ச ஸ்தி²தா| ");
INSERT INTO santam_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","தத்பஸ்²சாத்³ யீஸு²ருத்தா²ய தாம்ʼ வநிதாம்ʼ விநா கமப்யபரம்ʼ ந விலோக்ய ப்ருʼஷ்டவாந் ஹே வாமே தவாபவாத³கா​: குத்ர? கோபி த்வாம்ʼ கிம்ʼ ந த³ண்ட³யதி? ");
INSERT INTO santam_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ஸாவத³த் ஹே மஹேச்ச² கோபி ந ததா³ யீஸு²ரவோசத் நாஹமபி த³ண்ட³யாமி யாஹி புந​: பாபம்ʼ மாகார்ஷீ​:| ");
INSERT INTO santam_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ததோ யீஸு²​: புநரபி லோகேப்⁴ய இத்த²ம்ʼ கத²யிதும் ஆரப⁴த ஜக³தோஹம்ʼ ஜ்யோதி​:ஸ்வரூபோ ய​: கஸ்²சிந் மத்பஸ்²சாத³ க³ச்ச²தி ஸ திமிரே ந ப்⁴ரமித்வா ஜீவநரூபாம்ʼ தீ³ப்திம்ʼ ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","தத​: பி²ரூஸி²நோ(அ)வாதி³ஷுஸ்த்வம்ʼ ஸ்வார்தே² ஸ்வயம்ʼ ஸாக்ஷ்யம்ʼ த³தா³ஸி தஸ்மாத் தவ ஸாக்ஷ்யம்ʼ க்³ராஹ்யம்ʼ ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ததா³ யீஸு²​: ப்ரத்யுதி³தவாந் யத்³யபி ஸ்வார்தே²(அ)ஹம்ʼ ஸ்வயம்ʼ ஸாக்ஷ்யம்ʼ த³தா³மி ததா²பி மத் ஸாக்ஷ்யம்ʼ க்³ராஹ்யம்ʼ யஸ்மாத்³ அஹம்ʼ குத ஆக³தோஸ்மி க்வ யாமி ச தத³ஹம்ʼ ஜாநாமி கிந்து குத ஆக³தோஸ்மி குத்ர க³ச்சா²மி ச தத்³ யூயம்ʼ ந ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","யூயம்ʼ லௌகிகம்ʼ விசாரயத² நாஹம்ʼ கிமபி விசாரயாமி| ");
INSERT INTO santam_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","கிந்து யதி³ விசாரயாமி தர்ஹி மம விசாரோ க்³ரஹீதவ்யோ யதோஹம் ஏகாகீ நாஸ்மி ப்ரேரயிதா பிதா மயா ஸஹ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","த்³வயோ ர்ஜநயோ​: ஸாக்ஷ்யம்ʼ க்³ரஹணீயம்ʼ ப⁴வதீதி யுஷ்மாகம்ʼ வ்யவஸ்தா²க்³ரந்தே² லிகி²தமஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","அஹம்ʼ ஸ்வார்தே² ஸ்வயம்ʼ ஸாக்ஷித்வம்ʼ த³தா³மி யஸ்²ச மம தாதோ மாம்ʼ ப்ரேரிதவாந் ஸோபி மத³ர்தே² ஸாக்ஷ்யம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ததா³ தே(அ)ப்ருʼச்ச²ந் தவ தாத​: குத்ர? ததோ யீஸு²​: ப்ரத்யவாதீ³த்³ யூயம்ʼ மாம்ʼ ந ஜாநீத² மத்பிதரஞ்ச ந ஜாநீத² யதி³ மாம் அக்ஷாஸ்யத தர்ஹி மம தாதமப்யக்ஷாஸ்யத| ");
INSERT INTO santam_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","யீஸு² ர்மந்தி³ர உபதி³ஸ்²ய ப⁴ண்டா³கா³ரே கதா² ஏதா அகத²யத் ததா²பி தம்ʼ ப்ரதி கோபி கரம்ʼ நோத³தோலயத்| ");
INSERT INTO santam_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","தத​: பரம்ʼ யீஸு²​: புநருதி³தவாந் அது⁴நாஹம்ʼ க³ச்சா²மி யூயம்ʼ மாம்ʼ க³வேஷயிஷ்யத² கிந்து நிஜை​: பாபை ர்மரிஷ்யத² யத் ஸ்தா²நம் அஹம்ʼ யாஸ்யாமி தத் ஸ்தா²நம் யூயம்ʼ யாதும்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ததா³ யிஹூதீ³யா​: ப்ராவோசந் கிமயம் ஆத்மகா⁴தம்ʼ கரிஷ்யதி? யதோ யத் ஸ்தா²நம் அஹம்ʼ யாஸ்யாமி தத் ஸ்தா²நம் யூயம்ʼ யாதும்ʼ ந ஸ²க்ஷ்யத² இதி வாக்யம்ʼ ப்³ரவீதி| ");
INSERT INTO santam_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ததோ யீஸு²ஸ்தேப்⁴ய​: கதி²தவாந் யூயம் அத⁴​:ஸ்தா²நீயா லோகா அஹம் ஊர்த்³வ்வஸ்தா²நீய​: யூயம் ஏதஜ்ஜக³த்ஸம்ப³ந்தீ⁴யா அஹம் ஏதஜ்ஜக³த்ஸம்ப³ந்தீ⁴யோ ந| ");
INSERT INTO santam_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","தஸ்மாத் கதி²தவாந் யூயம்ʼ நிஜை​: பாபை ர்மரிஷ்யத² யதோஹம்ʼ ஸ புமாந் இதி யதி³ ந விஸ்²வஸித² தர்ஹி நிஜை​: பாபை ர்மரிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ததா³ தே (அ)ப்ருʼச்ச²ந் கஸ்த்வம்ʼ? ததோ யீஸு²​: கதி²தவாந் யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ யஸ்ய ப்ரஸ்தாவம் ஆ ப்ரத²மாத் கரோமி ஸஏவ புருஷோஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","யுஷ்மாஸு மயா ப³ஹுவாக்யம்ʼ வக்த்தவ்யம்ʼ விசாரயிதவ்யஞ்ச கிந்து மத்ப்ரேரயிதா ஸத்யவாதீ³ தஸ்ய ஸமீபே யத³ஹம்ʼ ஸ்²ருதவாந் ததே³வ ஜக³தே கத²யாமி| ");
INSERT INTO santam_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","கிந்து ஸ ஜநகே வாக்யமித³ம்ʼ ப்ரோக்த்தவாந் இதி தே நாபு³த்⁴யந்த| ");
INSERT INTO santam_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ததோ யீஸு²ரகத²யத்³ யதா³ மநுஷ்யபுத்ரம் ஊர்த்³வ்வ உத்தா²பயிஷ்யத² ததா³ஹம்ʼ ஸ புமாந் கேவல​: ஸ்வயம்ʼ கிமபி கர்ம்ம ந கரோமி கிந்து தாதோ யதா² ஸி²க்ஷயதி தத³நுஸாரேண வாக்யமித³ம்ʼ வதா³மீதி ச யூயம்ʼ ஜ்ஞாதும்ʼ ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","மத்ப்ரேரயிதா பிதா மாம் ஏகாகிநம்ʼ ந த்யஜதி ஸ மயா ஸார்த்³த⁴ம்ʼ திஷ்ட²தி யதோஹம்ʼ தத³பி⁴மதம்ʼ கர்ம்ம ஸதா³ கரோமி| ");
INSERT INTO santam_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ததா³ தஸ்யைதாநி வாக்யாநி ஸ்²ருத்வா ப³ஹுவஸ்தாஸ்மிந் வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","யே யிஹூதீ³யா வ்யஸ்²வஸந் யீஸு²ஸ்தேப்⁴யோ(அ)கத²யத் ");
INSERT INTO santam_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","மம வாக்யே யதி³ யூயம் ஆஸ்தா²ம்ʼ குருத² தர்ஹி மம ஸி²ஷ்யா பூ⁴த்வா ஸத்யத்வம்ʼ ஜ்ஞாஸ்யத² தத​: ஸத்யதயா யுஷ்மாகம்ʼ மோக்ஷோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ததா³ தே ப்ரத்யவாதி³ஷு​: வயம் இப்³ராஹீமோ வம்ʼஸ²​: கதா³பி கஸ்யாபி தா³ஸா ந ஜாதாஸ்தர்ஹி யுஷ்மாகம்ʼ முக்த்தி ர்ப⁴விஷ்யதீதி வாக்யம்ʼ கத²ம்ʼ ப்³ரவீஷி? ");
INSERT INTO santam_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ததா³ யீஸு²​: ப்ரத்யவத³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி ய​: பாபம்ʼ கரோதி ஸ பாபஸ்ய தா³ஸ​:| ");
INSERT INTO santam_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","தா³ஸஸ்²ச நிரந்தரம்ʼ நிவேஸ²நே ந திஷ்ட²தி கிந்து புத்ரோ நிரந்தரம்ʼ திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","அத​: புத்ரோ யதி³ யுஷ்மாந் மோசயதி தர்ஹி நிதாந்தமேவ முக்த்தா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","யுயம் இப்³ராஹீமோ வம்ʼஸ² இத்யஹம்ʼ ஜாநாமி கிந்து மம கதா² யுஷ்மாகம் அந்த​:கரணேஷு ஸ்தா²நம்ʼ ந ப்ராப்நுவந்தி தஸ்மாத்³தே⁴தோ ர்மாம்ʼ ஹந்தும் ஈஹத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","அஹம்ʼ ஸ்வபிது​: ஸமீபே யத³பஸ்²யம்ʼ ததே³வ கத²யாமி ததா² யூயமபி ஸ்வபிது​: ஸமீபே யத³பஸ்²யத ததே³வ குருத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ததா³ தே ப்ரத்யவோசந் இப்³ராஹீம் அஸ்மாகம்ʼ பிதா ததோ யீஸு²ரகத²யத்³ யதி³ யூயம் இப்³ராஹீம​: ஸந்தாநா அப⁴விஷ்யத தர்ஹி இப்³ராஹீம ஆசாரணவத்³ ஆசரிஷ்யத| ");
INSERT INTO santam_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ஈஸ்²வரஸ்ய முகா²த் ஸத்யம்ʼ வாக்யம்ʼ ஸ்²ருத்வா யுஷ்மாந் ஜ்ஞாபயாமி யோஹம்ʼ தம்ʼ மாம்ʼ ஹந்தும்ʼ சேஷ்டத்⁴வே இப்³ராஹீம் ஏதாத்³ருʼஸ²ம்ʼ கர்ம்ம ந சகார| ");
INSERT INTO santam_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","யூயம்ʼ ஸ்வஸ்வபிது​: கர்ம்மாணி குருத² ததா³ தைருக்த்தம்ʼ ந வயம்ʼ ஜாரஜாதா அஸ்மாகம் ஏகஏவ பிதாஸ்தி ஸ ஏவேஸ்²வர​: ");
INSERT INTO santam_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ததோ யீஸு²நா கதி²தம் ஈஸ்²வரோ யதி³ யுஷ்மாகம்ʼ தாதோப⁴விஷ்யத் தர்ஹி யூயம்ʼ மயி ப்ரேமாகரிஷ்யத யதோஹம் ஈஸ்²வராந்நிர்க³த்யாக³தோஸ்மி ஸ்வதோ நாக³தோஹம்ʼ ஸ மாம்ʼ ப்ராஹிணோத்| ");
INSERT INTO santam_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","யூயம்ʼ மம வாக்யமித³ம்ʼ ந பு³த்⁴யத்⁴வே குத​:? யதோ யூயம்ʼ மமோபதே³ஸ²ம்ʼ ஸோடு⁴ம்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","யூயம்ʼ ஸை²தாந் பிது​: ஸந்தாநா ஏதஸ்மாத்³ யுஷ்மாகம்ʼ பிதுரபி⁴லாஷம்ʼ பூரயத² ஸ ஆ ப்ரத²மாத் நரகா⁴தீ தத³ந்த​: ஸத்யத்வஸ்ய லேஸோ²பி நாஸ்தி காரணாத³த​: ஸ ஸத்யதாயாம்ʼ நாதிஷ்ட²த் ஸ யதா³ ம்ருʼஷா கத²யதி ததா³ நிஜஸ்வபா⁴வாநுஸாரேணைவ கத²யதி யதோ ஸ ம்ருʼஷாபா⁴ஷீ ம்ருʼஷோத்பாத³கஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","அஹம்ʼ தத்²யவாக்யம்ʼ வதா³மி காரணாத³ஸ்மாத்³ யூயம்ʼ மாம்ʼ ந ப்ரதீத²| ");
INSERT INTO santam_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","மயி பாபமஸ்தீதி ப்ரமாணம்ʼ யுஷ்மாகம்ʼ கோ தா³தும்ʼ ஸ²க்நோதி? யத்³யஹம்ʼ தத்²யவாக்யம்ʼ வதா³மி தர்ஹி குதோ மாம்ʼ ந ப்ரதித²? ");
INSERT INTO santam_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ய​: கஸ்²சந ஈஸ்²வரீயோ லோக​: ஸ ஈஸ்²வரீயகதா²யாம்ʼ மநோ நித⁴த்தே யூயம் ஈஸ்²வரீயலோகா ந ப⁴வத² தந்நிதா³நாத் தத்ர ந மநாம்ʼஸி நித⁴த்³வே| ");
INSERT INTO santam_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ததா³ யிஹூதீ³யா​: ப்ரத்யவாதி³ஷு​: த்வமேக​: ஸோ²மிரோணீயோ பூ⁴தக்³ரஸ்தஸ்²ச வயம்ʼ கிமித³ம்ʼ ப⁴த்³ரம்ʼ நாவாதி³ஷ்ம? ");
INSERT INTO santam_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ததோ யீஸு²​: ப்ரத்யவாதீ³த் நாஹம்ʼ பூ⁴தக்³ரஸ்த​: கிந்து நிஜதாதம்ʼ ஸம்மந்யே தஸ்மாத்³ யூயம்ʼ மாம் அபமந்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","அஹம்ʼ ஸ்வஸுக்²யாதிம்ʼ ந சேஷ்டே கிந்து சேஷ்டிதா விசாரயிதா சாபர ஏக ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","அஹம்ʼ யுஷ்மப்⁴யம் அதீவ யதா²ர்த²ம்ʼ கத²யாமி யோ நரோ மதீ³யம்ʼ வாசம்ʼ மந்யதே ஸ கதா³சந நித⁴நம்ʼ ந த்³ரக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","யிஹூதீ³யாஸ்தமவத³ந் த்வம்ʼ பூ⁴தக்³ரஸ்த இதீதா³நீம் அவைஷ்ம| இப்³ராஹீம் ப⁴விஷ்யத்³வாதி³நஞ்ச ஸர்வ்வே ம்ருʼதா​: கிந்து த்வம்ʼ பா⁴ஷஸே யோ நரோ மம பா⁴ரதீம்ʼ க்³ருʼஹ்லாதி ஸ ஜாது நிதா⁴நாஸ்வாத³ம்ʼ ந லப்ஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","தர்ஹி த்வம்ʼ கிம் அஸ்மாகம்ʼ பூர்வ்வபுருஷாத்³ இப்³ராஹீமோபி மஹாந்? யஸ்மாத் ஸோபி ம்ருʼத​: ப⁴விஷ்யத்³வாதி³நோபி ம்ருʼதா​: த்வம்ʼ ஸ்வம்ʼ கம்ʼ புமாம்ʼஸம்ʼ மநுஷே? ");
INSERT INTO santam_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","யீஸு²​: ப்ரத்யவோசத்³ யத்³யஹம்ʼ ஸ்வம்ʼ ஸ்வயம்ʼ ஸம்மந்யே தர்ஹி மம தத் ஸம்மநநம்ʼ கிமபி ந கிந்து மம தாதோ யம்ʼ யூயம்ʼ ஸ்வீயம் ஈஸ்²வரம்ʼ பா⁴ஷத்⁴வே ஸஏவ மாம்ʼ ஸம்மநுதே| ");
INSERT INTO santam_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","யூயம்ʼ தம்ʼ நாவக³ச்ச²த² கிந்த்வஹம்ʼ தமவக³ச்சா²மி தம்ʼ நாவக³ச்சா²மீதி வாக்யம்ʼ யதி³ வதா³மி தர்ஹி யூயமிவ ம்ருʼஷாபா⁴ஷீ ப⁴வாமி கிந்த்வஹம்ʼ தமவக³ச்சா²மி ததா³க்ஷாமபி க்³ருʼஹ்லாமி| ");
INSERT INTO santam_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","யுஷ்மாகம்ʼ பூர்வ்வபுருஷ இப்³ராஹீம் மம ஸமயம்ʼ த்³ரஷ்டும் அதீவாவாஞ்ச²த் தந்நிரீக்ஷ்யாநந்த³ச்ச| ");
INSERT INTO santam_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ததா³ யிஹூதீ³யா அப்ருʼச்ச²ந் தவ வய​: பஞ்சாஸ²த்³வத்ஸரா ந த்வம்ʼ கிம் இப்³ராஹீமம் அத்³ராக்ஷீ​:? ");
INSERT INTO santam_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","யீஸு²​: ப்ரத்யவாதீ³த்³ யுஷ்மாநஹம்ʼ யதா²ர்த²தரம்ʼ வதா³மி இப்³ராஹீமோ ஜந்மந​: பூர்வ்வகாலமாரப்⁴யாஹம்ʼ வித்³யே| ");
INSERT INTO santam_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ததா³ தே பாஷாணாந் உத்தோல்ய தமாஹந்தும் உத³யச்ச²ந் கிந்து யீஸு² ர்கு³ப்தோ மந்திராத்³ ப³ஹிர்க³த்ய தேஷாம்ʼ மத்⁴யேந ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","தத​: பரம்ʼ யீஸு²ர்க³ச்ச²ந் மார்க³மத்⁴யே ஜந்மாந்த⁴ம்ʼ நரம் அபஸ்²யத்| ");
INSERT INTO santam_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","தத​: ஸி²ஷ்யாஸ்தம் அப்ருʼச்ச²ந் ஹே கு³ரோ நரோயம்ʼ ஸ்வபாபேந வா ஸ்வபித்ரா​: பாபேநாந்தோ⁴(அ)ஜாயத? ");
INSERT INTO santam_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","தத​: ஸ ப்ரத்யுதி³தவாந் ஏதஸ்ய வாஸ்ய பித்ரோ​: பாபாத்³ ஏதாத்³ருʼஸோ²பூ⁴த³ இதி நஹி கிந்த்வநேந யதே²ஸ்²வரஸ்ய கர்ம்ம ப்ரகாஸ்²யதே தத்³தே⁴தோரேவ| ");
INSERT INTO santam_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","தி³நே திஷ்ட²தி மத்ப்ரேரயிது​: கர்ம்ம மயா கர்த்தவ்யம்ʼ யதா³ கிமபி கர்ம்ம ந க்ரியதே தாத்³ருʼஸீ² நிஸா²க³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","அஹம்ʼ யாவத்காலம்ʼ ஜக³தி திஷ்டா²மி தாவத்காலம்ʼ ஜக³தோ ஜ்யோதி​:ஸ்வரூபோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","இத்யுக்த்தா பூ⁴மௌ நிஷ்டீ²வம்ʼ நிக்ஷிப்ய தேந பங்கம்ʼ க்ருʼதவாந் ");
INSERT INTO santam_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","பஸ்²சாத் தத்பங்கேந தஸ்யாந்த⁴ஸ்ய நேத்ரே ப்ரலிப்ய தமித்யாதி³ஸ²த் க³த்வா ஸி²லோஹே (அ)ர்தா²த் ப்ரேரிதநாம்நி ஸரஸி ஸ்நாஹி| ததோந்தோ⁴ க³த்வா தத்ராஸ்நாத் தத​: ப்ரந்நசக்ஷு ர்பூ⁴த்வா வ்யாகு⁴ட்யாகா³த்| ");
INSERT INTO santam_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","அபரஞ்ச ஸமீபவாஸிநோ லோகா யே ச தம்ʼ பூர்வ்வமந்த⁴ம் அபஸ்²யந் தே ப³க்த்தும் ஆரப⁴ந்த யோந்த⁴லோகோ வர்த்மந்யுபவிஸ்²யாபி⁴க்ஷத ஸ ஏவாயம்ʼ ஜந​: கிம்ʼ ந ப⁴வதி? ");
INSERT INTO santam_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","கேசித³வத³ந் ஸ ஏவ கேசித³வோசந் தாத்³ருʼஸோ² ப⁴வதி கிந்து ஸ ஸ்வயமப்³ரவீத் ஸ ஏவாஹம்ʼ ப⁴வாமி| ");
INSERT INTO santam_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","அதஏவ தே (அ)ப்ருʼச்ச²ந் த்வம்ʼ கத²ம்ʼ த்³ருʼஷ்டிம்ʼ பாப்தவாந்? ");
INSERT INTO santam_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","தத​: ஸோவத³த்³ யீஸ²நாமக ஏகோ ஜநோ மம நயநே பங்கேந ப்ரலிப்ய இத்யாஜ்ஞாபயத் ஸி²லோஹகாஸாரம்ʼ க³த்வா தத்ர ஸ்நாஹி| ததஸ்தத்ர க³த்வா மயி ஸ்நாதே த்³ருʼஷ்டிமஹம்ʼ லப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ததா³ தே (அ)வத³ந் ஸ புமாந் குத்ர? தேநோக்த்தம்ʼ நாஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","அபரம்ʼ தஸ்மிந் பூர்வ்வாந்தே⁴ ஜநே பி²ரூஸி²நாம்ʼ நிகடம் ஆநீதே ஸதி பி²ரூஸி²நோபி தமப்ருʼச்ச²ந் கத²ம்ʼ த்³ருʼஷ்டிம்ʼ ப்ராப்தோஸி? ");
INSERT INTO santam_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","தத​: ஸ கதி²தவாந் ஸ பங்கேந மம நேத்ரே (அ)லிம்பத் பஸ்²சாத்³ ஸ்நாத்வா த்³ருʼஷ்டிமலபே⁴| ");
INSERT INTO santam_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","கிந்து யீஸு² ர்விஸ்²ராமவாரே கர்த்³த³மம்ʼ க்ருʼத்வா தஸ்ய நயநே ப்ரஸந்நே(அ)கரோத்³ இதிகாரணாத் கதிபயபி²ரூஸி²நோ(அ)வத³ந் ");
INSERT INTO santam_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ஸ புமாந் ஈஸ்²வராந்ந யத​: ஸ விஸ்²ராமவாரம்ʼ ந மந்யதே| ததோந்யே கேசித் ப்ரத்யவத³ந் பாபீ புமாந் கிம் ஏதாத்³ருʼஸ²ம் ஆஸ்²சர்ய்யம்ʼ கர்ம்ம கர்த்தும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","இத்த²ம்ʼ தேஷாம்ʼ பரஸ்பரம்ʼ பி⁴ந்நவாக்யத்வம் அப⁴வத்| பஸ்²சாத் தே புநரபி தம்ʼ பூர்வ்வாந்த⁴ம்ʼ மாநுஷம் அப்ராக்ஷு​: யோ ஜநஸ்தவ சக்ஷுஷீ ப்ரஸந்நே க்ருʼதவாந் தஸ்மிந் த்வம்ʼ கிம்ʼ வத³ஸி? ஸ உக்த்தவாந் ஸ ப⁴விஸ²த்³வாதீ³| ");
INSERT INTO santam_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ஸ த்³ருʼஷ்டிம் ஆப்தவாந் இதி யிஹூதீ³யாஸ்தஸ்ய த்³ருʼஷ்டிம்ʼ ப்ராப்தஸ்ய ஜநஸ்ய பித்ரோ ர்முகா²த்³ அஸ்²ருத்வா ந ப்ரத்யயந்| ");
INSERT INTO santam_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","அதஏவ தே தாவப்ருʼச்ச²ந் யுவயோ ர்யம்ʼ புத்ரம்ʼ ஜந்மாந்த⁴ம்ʼ வத³த²​: ஸ கிமயம்ʼ? தர்ஹீதா³நீம்ʼ கத²ம்ʼ த்³ரஷ்டும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ததஸ்தஸ்ய பிதரௌ ப்ரத்யவோசதாம் அயம் ஆவயோ​: புத்ர ஆ ஜநேரந்த⁴ஸ்²ச தத³ப்யாவாம்ʼ ஜாநீவ​: ");
INSERT INTO santam_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","கிந்த்வது⁴நா கத²ம்ʼ த்³ருʼஷ்டிம்ʼ ப்ராப்தவாந் ததா³வாம்ʼ ந் ஜாநீவ​: கோஸ்ய சக்ஷுஷீ ப்ரஸந்நே க்ருʼதவாந் தத³பி ந ஜாநீவ ஏஷ வய​:ப்ராப்த ஏநம்ʼ ப்ருʼச்ச²த ஸ்வகதா²ம்ʼ ஸ்வயம்ʼ வக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","யிஹூதீ³யாநாம்ʼ ப⁴யாத் தஸ்ய பிதரௌ வாக்யமித³ம் அவத³தாம்ʼ யத​: கோபி மநுஷ்யோ யதி³ யீஸு²ம் அபி⁴ஷிக்தம்ʼ வத³தி தர்ஹி ஸ ப⁴ஜநக்³ருʼஹாத்³ தூ³ரீகாரிஷ்யதே யிஹூதீ³யா இதி மந்த்ரணாம் அகுர்வ்வந் ");
INSERT INTO santam_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","அதஸ்தஸ்ய பிதரௌ வ்யாஹரதாம் ஏஷ வய​:ப்ராப்த ஏநம்ʼ ப்ருʼச்ச²த| ");
INSERT INTO santam_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ததா³ தே புநஸ்²ச தம்ʼ பூர்வ்வாந்த⁴ம் ஆஹூய வ்யாஹரந் ஈஸ்²வரஸ்ய கு³ணாந் வத³ ஏஷ மநுஷ்ய​: பாபீதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ததா³ ஸ உக்த்தவாந் ஸ பாபீ ந வேதி நாஹம்ʼ ஜாநே பூர்வாமந்த⁴ ஆஸமஹம் அது⁴நா பஸ்²யாமீதி மாத்ரம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","தே புநரப்ருʼச்ச²ந் ஸ த்வாம்ʼ ப்ரதி கிமகரோத்? கத²ம்ʼ நேத்ரே ப்ரஸந்நே (அ)கரோத்? ");
INSERT INTO santam_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","தத​: ஸோவாதீ³த்³ ஏகக்ருʼத்வோகத²யம்ʼ யூயம்ʼ ந ஸ்²ருʼணுத² தர்ஹி குத​: புந​: ஸ்²ரோதும் இச்ச²த²? யூயமபி கிம்ʼ தஸ்ய ஸி²ஷ்யா ப⁴விதும் இச்ச²த²? ");
INSERT INTO santam_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ததா³ தே தம்ʼ திரஸ்க்ருʼத்ய வ்யாஹரந் த்வம்ʼ தஸ்ய ஸி²ஷ்யோ வயம்ʼ மூஸா​: ஸி²ஷ்யா​:| ");
INSERT INTO santam_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","மூஸாவக்த்ரேணேஸ்²வரோ ஜகா³த³ தஜ்ஜாநீம​: கிந்த்வேஷ குத்ரத்யலோக இதி ந ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ஸோவத³த்³ ஏஷ மம லோசநே ப்ரஸந்நே (அ)கரோத் ததா²பி குத்ரத்யலோக இதி யூயம்ʼ ந ஜாநீத² ஏதத்³ ஆஸ்²சர்ய்யம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ஈஸ்²வர​: பாபிநாம்ʼ கதா²ம்ʼ ந ஸ்²ருʼணோதி கிந்து யோ ஜநஸ்தஸ்மிந் ப⁴க்திம்ʼ க்ருʼத்வா ததி³ஷ்டக்ரியாம்ʼ கரோதி தஸ்யைவ கதா²ம்ʼ ஸ்²ருʼணோதி ஏதத்³ வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","கோபி மநுஷ்யோ ஜந்மாந்தா⁴ய சக்ஷுஷீ அத³தா³த் ஜக³தா³ரம்பா⁴த்³ ஏதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ கோபி கதா³பி நாஸ்²ருʼணோத்| ");
INSERT INTO santam_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","அஸ்மாத்³ ஏஷ மநுஷ்யோ யதீ³ஸ்²வராந்நாஜாயத தர்ஹி கிஞ்சித³பீத்³ருʼஸ²ம்ʼ கர்ம்ம கர்த்தும்ʼ நாஸ²க்நோத்| ");
INSERT INTO santam_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","தே வ்யாஹரந் த்வம்ʼ பாபாத்³ அஜாயதா²​: கிமஸ்மாந் த்வம்ʼ ஸி²க்ஷயஸி? பஸ்²சாத்தே தம்ʼ ப³ஹிரகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","தத³நந்தரம்ʼ யிஹூதீ³யை​: ஸ ப³ஹிரக்ரியத யீஸு²ரிதி வார்த்தாம்ʼ ஸ்²ருத்வா தம்ʼ ஸாக்ஷாத் ப்ராப்ய ப்ருʼஷ்டவாந் ஈஸ்²வரஸ்ய புத்ரே த்வம்ʼ விஸ்²வஸிஷி? ");
INSERT INTO santam_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ததா³ ஸ ப்ரத்யவோசத் ஹே ப்ரபோ⁴ ஸ கோ யத் தஸ்மிந்நஹம்ʼ விஸ்²வஸிமி? ");
INSERT INTO santam_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ததோ யீஸு²​: கதி²தவாந் த்வம்ʼ தம்ʼ த்³ருʼஷ்டவாந் த்வயா ஸாகம்ʼ ய​: கத²ம்ʼ கத²யதி ஸஏவ ஸ​:| ");
INSERT INTO santam_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ததா³ ஹே ப்ரபோ⁴ விஸ்²வஸிமீத்யுக்த்வா ஸ தம்ʼ ப்ரணாமத்| ");
INSERT INTO santam_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","பஸ்²சாத்³ யீஸு²​: கதி²தவாந் நயநஹீநா நயநாநி ப்ராப்நுவந்தி நயநவந்தஸ்²சாந்தா⁴ ப⁴வந்தீத்யபி⁴ப்ராயேண ஜக³தா³ஹம் ஆக³ச்ச²ம்| ");
INSERT INTO santam_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ஏதத் ஸ்²ருத்வா நிகடஸ்தா²​: கதிபயா​: பி²ரூஸி²நோ வ்யாஹரந் வயமபி கிமந்தா⁴​:? ");
INSERT INTO santam_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ததா³ யீஸு²ரவாதீ³த்³ யத்³யந்தா⁴ அப⁴வத தர்ஹி பாபாநி நாதிஷ்ட²ந் கிந்து பஸ்²யாமீதி வாக்யவத³நாத்³ யுஷ்மாகம்ʼ பாபாநி திஷ்ட²ந்தி| ");
INSERT INTO santam_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி, யோ ஜநோ த்³வாரேண ந ப்ரவிஸ்²ய கேநாப்யந்யேந மேஷக்³ருʼஹம்ʼ ப்ரவிஸ²தி ஸ ஏவ ஸ்தேநோ த³ஸ்யுஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","யோ த்³வாரேண ப்ரவிஸ²தி ஸ ஏவ மேஷபாலக​:| ");
INSERT INTO santam_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","தௌ³வாரிகஸ்தஸ்மை த்³வாரம்ʼ மோசயதி மேஷக³ணஸ்²ச தஸ்ய வாக்யம்ʼ ஸ்²ருʼணோதி ஸ நிஜாந் மேஷாந் ஸ்வஸ்வநாம்நாஹூய ப³ஹி​: க்ருʼத்வா நயதி| ");
INSERT INTO santam_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ததா² நிஜாந் மேஷாந் ப³ஹி​: க்ருʼத்வா ஸ்வயம்ʼ தேஷாம் அக்³ரே க³ச்ச²தி, ததோ மேஷாஸ்தஸ்ய ஸ²ப்³த³ம்ʼ பு³த்⁴யந்தே, தஸ்மாத் தஸ்ய பஸ்²சாத்³ வ்ரஜந்தி| ");
INSERT INTO santam_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","கிந்து பரஸ்ய ஸ²ப்³த³ம்ʼ ந பு³த்⁴யந்தே தஸ்மாத் தஸ்ய பஸ்²சாத்³ வ்ரஜிஷ்யந்தி வரம்ʼ தஸ்ய ஸமீபாத் பலாயிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","யீஸு²ஸ்தேப்⁴ய இமாம்ʼ த்³ருʼஷ்டாந்தகதா²ம் அகத²யத் கிந்து தேந கதி²தகதா²யாஸ்தாத்பர்ய்யம்ʼ தே நாபு³த்⁴யந்த| ");
INSERT INTO santam_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","அதோ யீஸு²​: புநரகத²யத், யுஷ்மாநாஹம்ʼ யதா²ர்த²தரம்ʼ வ்யாஹராமி, மேஷக்³ருʼஹஸ்ய த்³வாரம் அஹமேவ| ");
INSERT INTO santam_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","மயா ந ப்ரவிஸ்²ய ய ஆக³ச்ச²ந் தே ஸ்தேநா த³ஸ்யவஸ்²ச கிந்து மேஷாஸ்தேஷாம்ʼ கதா² நாஸ்²ருʼண்வந்| ");
INSERT INTO santam_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","அஹமேவ த்³வாரஸ்வரூப​:, மயா ய​: கஸ்²சித ப்ரவிஸ²தி ஸ ரக்ஷாம்ʼ ப்ராப்ஸ்யதி ததா² ப³ஹிரந்தஸ்²ச க³மநாக³மநே க்ருʼத்வா சரணஸ்தா²நம்ʼ ப்ராப்ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","யோ ஜநஸ்தேந​: ஸ கேவலம்ʼ ஸ்தைந்யப³த⁴விநாஸா²ந் கர்த்துமேவ ஸமாயாதி கிந்த்வஹம் ஆயு ர்தா³தும் அர்தா²த் பா³ஹூல்யேந ததே³வ தா³தும் ஆக³ச்ச²ம்| ");
INSERT INTO santam_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","அஹமேவ ஸத்யமேஷபாலகோ யஸ்து ஸத்யோ மேஷபாலக​: ஸ மேஷார்த²ம்ʼ ப்ராணத்யாக³ம்ʼ கரோதி; ");
INSERT INTO santam_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","கிந்து யோ ஜநோ மேஷபாலகோ ந, அர்தா²த்³ யஸ்ய மேஷா நிஜா ந ப⁴வந்தி, ய ஏதாத்³ருʼஸோ² வைதநிக​: ஸ வ்ருʼகம் ஆக³ச்ச²ந்தம்ʼ த்³ருʼஷ்ட்வா மேஜவ்ரஜம்ʼ விஹாய பலாயதே, தஸ்மாத்³ வ்ருʼகஸ்தம்ʼ வ்ரஜம்ʼ த்⁴ருʼத்வா விகிரதி| ");
INSERT INTO santam_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","வைதநிக​: பலாயதே யத​: ஸ வேதநார்தீ² மேஷார்த²ம்ʼ ந சிந்தயதி| ");
INSERT INTO santam_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","அஹமேவ ஸத்யோ மேஷபாலக​:, பிதா மாம்ʼ யதா² ஜாநாதி, அஹஞ்ச யதா² பிதரம்ʼ ஜாநாமி, ");
INSERT INTO santam_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ததா² நிஜாந் மேஷாநபி ஜாநாமி, மேஷாஸ்²ச மாம்ʼ ஜாநாந்தி, அஹஞ்ச மேஷார்த²ம்ʼ ப்ராணத்யாக³ம்ʼ கரோமி| ");
INSERT INTO santam_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","அபரஞ்ச ஏதத்³ க்³ருʼஹீய மேஷேப்⁴யோ பி⁴ந்நா அபி மேஷா மம ஸந்தி தே ஸகலா ஆநயிதவ்யா​:; தே மம ஸ²ப்³த³ம்ʼ ஸ்²ரோஷ்யந்தி தத ஏகோ வ்ரஜ ஏகோ ரக்ஷகோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ப்ராணாநஹம்ʼ த்யக்த்வா புந​: ப்ராணாந் க்³ரஹீஷ்யாமி, தஸ்மாத் பிதா மயி ஸ்நேஹம்ʼ கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","கஸ்²சிஜ்ஜநோ மம ப்ராணாந் ஹந்தும்ʼ ந ஸ²க்நோதி கிந்து ஸ்வயம்ʼ தாந் ஸமர்பயாமி தாந் ஸமர்பயிதும்ʼ புநர்க்³ரஹீதுஞ்ச மம ஸ²க்திராஸ்தே பா⁴ரமிமம்ʼ ஸ்வபிது​: ஸகாஸா²த் ப்ராப்தோஹம்| ");
INSERT INTO santam_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","அஸ்மாது³பதே³ஸா²த் புநஸ்²ச யிஹூதீ³யாநாம்ʼ மத்⁴யே பி⁴ந்நவாக்யதா ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ததோ ப³ஹவோ வ்யாஹரந் ஏஷ பூ⁴தக்³ரஸ்த உந்மத்தஸ்²ச, குத ஏதஸ்ய கதா²ம்ʼ ஸ்²ருʼணுத²? ");
INSERT INTO santam_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","கேசித்³ அவத³ந் ஏதஸ்ய கதா² பூ⁴தக்³ரஸ்தஸ்ய கதா²வந்ந ப⁴வந்தி, பூ⁴த​: கிம் அந்தா⁴ய சக்ஷுஷீ தா³தும்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ஸீ²தகாலே யிரூஸா²லமி மந்தி³ரோத்ஸர்க³பர்வ்வண்யுபஸ்தி²தே ");
INSERT INTO santam_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","யீஸு²​: ஸுலேமாநோ நி​:ஸாரேண க³மநாக³மநே கரோதி, ");
INSERT INTO santam_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ஏதஸ்மிந் ஸமயே யிஹூதீ³யாஸ்தம்ʼ வேஷ்டயித்வா வ்யாஹரந் கதி காலாந் அஸ்மாகம்ʼ விசிகித்ஸாம்ʼ ஸ்தா²பயிஷ்யாமி? யத்³யபி⁴ஷிக்தோ ப⁴வதி தர்ஹி தத் ஸ்பஷ்டம்ʼ வத³| ");
INSERT INTO santam_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ததா³ யீஸு²​: ப்ரத்யவத³த்³ அஹம் அசகத²ம்ʼ கிந்து யூயம்ʼ ந ப்ரதீத², நிஜபிது ர்நாம்நா யாம்ʼ யாம்ʼ க்ரியாம்ʼ கரோமி ஸா க்ரியைவ மம ஸாக்ஷிஸ்வரூபா| ");
INSERT INTO santam_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","கிந்த்வஹம்ʼ பூர்வ்வமகத²யம்ʼ யூயம்ʼ மம மேஷா ந ப⁴வத², காரணாத³ஸ்மாந் ந விஸ்²வஸித²| ");
INSERT INTO santam_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","மம மேஷா மம ஸ²ப்³த³ம்ʼ ஸ்²ருʼண்வந்தி தாநஹம்ʼ ஜாநாமி தே ச மம பஸ்²சாத்³ க³ச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","அஹம்ʼ தேப்⁴யோ(அ)நந்தாயு ர்த³தா³மி, தே கதா³பி ந நம்ʼக்ஷ்யந்தி கோபி மம கராத் தாந் ஹர்த்தும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","யோ மம பிதா தாந் மஹ்யம்ʼ த³த்தவாந் ஸ ஸர்வ்வஸ்மாத் மஹாந், கோபி மம பிது​: கராத் தாந் ஹர்த்தும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","அஹம்ʼ பிதா ச த்³வயோரேகத்வம்| ");
INSERT INTO santam_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ததோ யிஹூதீ³யா​: புநரபி தம்ʼ ஹந்தும்ʼ பாஷாணாந் உத³தோலயந்| ");
INSERT INTO santam_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","யீஸு²​: கதி²தவாந் பிது​: ஸகாஸா²த்³ ப³ஹூந்யுத்தமகர்ம்மாணி யுஷ்மாகம்ʼ ப்ராகாஸ²யம்ʼ தேஷாம்ʼ கஸ்ய கர்ம்மண​: காரணாந் மாம்ʼ பாஷாணைராஹந்தும் உத்³யதா​: ஸ்த²? ");
INSERT INTO santam_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","யிஹூதீ³யா​: ப்ரத்யவத³ந் ப்ரஸ²ஸ்தகர்ம்மஹேதோ ர்ந கிந்து த்வம்ʼ மாநுஷ​: ஸ்வமீஸ்²வரம் உக்த்வேஸ்²வரம்ʼ நிந்த³ஸி காரணாத³ஸ்மாத் த்வாம்ʼ பாஷாணைர்ஹந்ம​:| ");
INSERT INTO santam_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ததா³ யீஸு²​: ப்ரத்யுக்தவாந் மயா கதி²தம்ʼ யூயம் ஈஸ்²வரா ஏதத்³வசநம்ʼ யுஷ்மாகம்ʼ ஸா²ஸ்த்ரே லிகி²தம்ʼ நாஸ்தி கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","தஸ்மாத்³ யேஷாம் உத்³தே³ஸே² ஈஸ்²வரஸ்ய கதா² கதி²தா தே யதீ³ஸ்²வரக³ணா உச்யந்தே த⁴ர்ம்மக்³ரந்த²ஸ்யாப்யந்யதா² ப⁴விதும்ʼ ந ஸ²க்யம்ʼ, ");
INSERT INTO santam_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","தர்ஹ்யாஹம் ஈஸ்²வரஸ்ய புத்ர இதி வாக்யஸ்ய கத²நாத் யூயம்ʼ பித்ராபி⁴ஷிக்தம்ʼ ஜக³தி ப்ரேரிதஞ்ச புமாம்ʼஸம்ʼ கத²ம் ஈஸ்²வரநிந்த³கம்ʼ வாத³ய? ");
INSERT INTO santam_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","யத்³யஹம்ʼ பிது​: கர்ம்ம ந கரோமி தர்ஹி மாம்ʼ ந ப்ரதீத; ");
INSERT INTO santam_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","கிந்து யதி³ கரோமி தர்ஹி மயி யுஷ்மாபி⁴​: ப்ரத்யயே ந க்ருʼதே(அ)பி கார்ய்யே ப்ரத்யய​: க்ரியதாம்ʼ, ததோ மயி பிதாஸ்தீதி பிதர்ய்யஹம் அஸ்மீதி ச க்ஷாத்வா விஸ்²வஸிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ததா³ தே புநரபி தம்ʼ த⁴ர்த்தும் அசேஷ்டந்த கிந்து ஸ தேஷாம்ʼ கரேப்⁴யோ நிஸ்தீர்ய்ய ");
INSERT INTO santam_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","புந ர்யர்த்³த³ந் அத்³யாஸ்தடே யத்ர புர்வ்வம்ʼ யோஹந் அமஜ்ஜயத் தத்ராக³த்ய ந்யவஸத்| ");
INSERT INTO santam_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ததோ ப³ஹவோ லோகாஸ்தத்ஸமீபம் ஆக³த்ய வ்யாஹரந் யோஹந் கிமப்யாஸ்²சர்ய்யம்ʼ கர்ம்ம நாகரோத் கிந்த்வஸ்மிந் மநுஷ்யே யா ய​: கதா² அகத²யத் தா​: ஸர்வ்வா​: ஸத்யா​:; ");
INSERT INTO santam_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","தத்ர ச ப³ஹவோ லோகாஸ்தஸ்மிந் வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","அநந்தரம்ʼ மரியம் தஸ்யா ப⁴கி³நீ மர்தா² ச யஸ்மிந் வைத²நீயாக்³ராமே வஸதஸ்தஸ்மிந் க்³ராமே இலியாஸர் நாமா பீடி³த ஏக ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","யா மரியம் ப்ரபு⁴ம்ʼ ஸுக³ந்தி⁴தேலைந மர்த்³த³யித்வா ஸ்வகேஸை²ஸ்தஸ்ய சரணௌ ஸமமார்ஜத் தஸ்யா ப்⁴ராதா ஸ இலியாஸர் ரோகீ³| ");
INSERT INTO santam_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","அபரஞ்ச ஹே ப்ரபோ⁴ ப⁴வாந் யஸ்மிந் ப்ரீயதே ஸ ஏவ பீடி³தோஸ்தீதி கதா²ம்ʼ கத²யித்வா தஸ்ய ப⁴கி³ந்யௌ ப்ரேஷிதவத்யௌ| ");
INSERT INTO santam_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ததா³ யீஸு²ரிமாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வாகத²யத பீடே³யம்ʼ மரணார்த²ம்ʼ ந கிந்த்வீஸ்²வரஸ்ய மஹிமார்த²ம் ஈஸ்²வரபுத்ரஸ்ய மஹிமப்ரகாஸா²ர்த²ஞ்ச ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","யீஸு² ர்யத்³யபிமர்தா²யாம்ʼ தத்³ப⁴கி³ந்யாம் இலியாஸரி சாப்ரீயத, ");
INSERT INTO santam_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ததா²பி இலியாஸர​: பீடா³யா​: கத²ம்ʼ ஸ்²ருத்வா யத்ர ஆஸீத் தத்ரைவ தி³நத்³வயமதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","தத​: பரம் ஸ ஸி²ஷ்யாநகத²யத்³ வயம்ʼ புந ர்யிஹூதீ³யப்ரதே³ஸ²ம்ʼ யாம​:| ");
INSERT INTO santam_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ததஸ்தே ப்ரத்யவத³ந், ஹே கு³ரோ ஸ்வல்பதி³நாநி க³தாநி யிஹூதீ³யாஸ்த்வாம்ʼ பாஷாணை ர்ஹந்தும் உத்³யதாஸ்ததா²பி கிம்ʼ புநஸ்தத்ர யாஸ்யஸி? ");
INSERT INTO santam_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","யீஸு²​: ப்ரத்யவத³த், ஏகஸ்மிந் தி³நே கிம்ʼ த்³வாத³ஸ²க⁴டிகா ந ப⁴வந்தி? கோபி தி³வா க³ச்ச²ந் ந ஸ்க²லதி யத​: ஸ ஏதஜ்ஜக³தோ தீ³ப்திம்ʼ ப்ராப்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","கிந்து ராத்ரௌ க³ச்ச²ந் ஸ்க²லதி யதோ ஹேதோஸ்தத்ர தீ³ப்தி ர்நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","இமாம்ʼ கதா²ம்ʼ கத²யித்வா ஸ தாநவத³த்³, அஸ்மாகம்ʼ ப³ந்து⁴​: இலியாஸர் நித்³ரிதோபூ⁴த்³ இதா³நீம்ʼ தம்ʼ நித்³ராதோ ஜாக³ரயிதும்ʼ க³ச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","யீஸு² ர்ம்ருʼதௌ கதா²மிமாம்ʼ கதி²தவாந் கிந்து விஸ்²ராமார்த²ம்ʼ நித்³ராயாம்ʼ கதி²தவாந் இதி ஜ்ஞாத்வா ஸி²ஷ்யா அகத²யந், ");
INSERT INTO santam_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ஹே கு³ரோ ஸ யதி³ நித்³ராதி தர்ஹி ப⁴த்³ரமேவ| ");
INSERT INTO santam_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ததா³ யீஸு²​: ஸ்பஷ்டம்ʼ தாந் வ்யாஹரத், இலியாஸர் அம்ரியத; ");
INSERT INTO santam_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","கிந்து யூயம்ʼ யதா² ப்ரதீத² தத³ர்த²மஹம்ʼ தத்ர ந ஸ்தி²தவாந் இத்யஸ்மாத்³ யுஷ்மந்நிமித்தம் ஆஹ்லாதி³தோஹம்ʼ, ததா²பி தஸ்ய ஸமீபே யாம| ");
INSERT INTO santam_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ததா³ தோ²மா யம்ʼ தி³து³மம்ʼ வத³ந்தி ஸ ஸங்கி³ந​: ஸி²ஷ்யாந் அவத³த்³ வயமபி க³த்வா தேந ஸார்த்³த⁴ம்ʼ ம்ரியாமஹை| ");
INSERT INTO santam_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","யீஸு²ஸ்தத்ரோபஸ்தா²ய இலியாஸர​: ஸ்²மஸா²நே ஸ்தா²பநாத் சத்வாரி தி³நாநி க³தாநீதி வார்த்தாம்ʼ ஸ்²ருதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","வைத²நீயா யிரூஸா²லம​: ஸமீபஸ்தா² க்ரோஸை²கமாத்ராந்தரிதா; ");
INSERT INTO santam_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","தஸ்மாத்³ ப³ஹவோ யிஹூதீ³யா மர்தா²ம்ʼ மரியமஞ்ச ப்⁴யாத்ருʼஸோ²காபந்நாம்ʼ ஸாந்த்வயிதும்ʼ தயோ​: ஸமீபம் ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","மர்தா² யீஸோ²ராக³மநவார்தாம்ʼ ஸ்²ருத்வைவ தம்ʼ ஸாக்ஷாத்³ அகரோத் கிந்து மரியம் கே³ஹ உபவிஸ்²ய ஸ்தி²தா| ");
INSERT INTO santam_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ததா³ மர்தா² யீஸு²மவாத³த், ஹே ப்ரபோ⁴ யதி³ ப⁴வாந் அத்ராஸ்தா²ஸ்யத் தர்ஹி மம ப்⁴ராதா நாமரிஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","கிந்த்விதா³நீமபி யத்³ ஈஸ்²வரே ப்ரார்த²யிஷ்யதே ஈஸ்²வரஸ்தத்³ தா³ஸ்யதீதி ஜாநே(அ)ஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","யீஸு²ரவாதீ³த் தவ ப்⁴ராதா ஸமுத்தா²ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","மர்தா² வ்யாஹரத் ஸே²ஷதி³வஸே ஸ உத்தா²நஸமயே ப்ரோத்தா²ஸ்யதீதி ஜாநே(அ)ஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ததா³ யீஸு²​: கதி²தவாந் அஹமேவ உத்தா²பயிதா ஜீவயிதா ச ய​: கஸ்²சந மயி விஸ்²வஸிதி ஸ ம்ருʼத்வாபி ஜீவிஷ்யதி; ");
INSERT INTO santam_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ய​: கஸ்²சந ச ஜீவந் மயி விஸ்²வஸிதி ஸ கதா³பி ந மரிஷ்யதி, அஸ்யாம்ʼ கதா²யாம்ʼ கிம்ʼ விஸ்²வஸிஷி? ");
INSERT INTO santam_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ஸாவத³த் ப்ரபோ⁴ யஸ்யாவதரணாபேக்ஷாஸ்தி ப⁴வாந் ஸஏவாபி⁴ஷிக்த்த ஈஸ்²வரபுத்ர இதி விஸ்²வஸிமி| ");
INSERT INTO santam_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","இதி கதா²ம்ʼ கத²யித்வா ஸா க³த்வா ஸ்வாம்ʼ ப⁴கி³நீம்ʼ மரியமம்ʼ கு³ப்தமாஹூய வ்யாஹரத் கு³ருருபதிஷ்ட²தி த்வாமாஹூயதி ச| ");
INSERT INTO santam_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","கதா²மிமாம்ʼ ஸ்²ருத்வா ஸா தூர்ணம் உத்தா²ய தஸ்ய ஸமீபம் அக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","யீஸு² ர்க்³ராமமத்⁴யம்ʼ ந ப்ரவிஸ்²ய யத்ர மர்தா² தம்ʼ ஸாக்ஷாத்³ அகரோத் தத்ர ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","யே யிஹூதீ³யா மரியமா ஸாகம்ʼ க்³ருʼஹே திஷ்ட²ந்தஸ்தாம் அஸாந்த்வயந தே தாம்ʼ க்ஷிப்ரம் உத்தா²ய க³ச்ச²ந்திம்ʼ விலோக்ய வ்யாஹரந், ஸ ஸ்²மஸா²நே ரோதி³தும்ʼ யாதி, இத்யுக்த்வா தே தஸ்யா​: பஸ்²சாத்³ அக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","யத்ர யீஸு²ரதிஷ்ட²த் தத்ர மரியம் உபஸ்தா²ய தம்ʼ த்³ருʼஷ்ட்வா தஸ்ய சரணயோ​: பதித்வா வ்யாஹரத் ஹே ப்ரபோ⁴ யதி³ ப⁴வாந் அத்ராஸ்தா²ஸ்யத் தர்ஹி மம ப்⁴ராதா நாமரிஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","யீஸு²ஸ்தாம்ʼ தஸ்யா​: ஸங்கி³நோ யிஹூதீ³யாம்ʼஸ்²ச ருத³தோ விலோக்ய ஸோ²கார்த்த​: ஸந் தீ³ர்க⁴ம்ʼ நிஸ்²வஸ்ய கதி²தவாந் தம்ʼ குத்ராஸ்தா²பயத? ");
INSERT INTO santam_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","தே வ்யாஹரந், ஹே ப்ரபோ⁴ ப⁴வாந் ஆக³த்ய பஸ்²யது| ");
INSERT INTO santam_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","யீஸு²நா க்ரந்தி³தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","அதஏவ யிஹூதீ³யா அவத³ந், பஸ்²யதாயம்ʼ தஸ்மிந் கித்³ருʼக்³ அப்ரியத| ");
INSERT INTO santam_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","தேஷாம்ʼ கேசித்³ அவத³ந் யோந்தா⁴ய சக்ஷுஷீ த³த்தவாந் ஸ கிம் அஸ்ய ம்ருʼத்யும்ʼ நிவாரயிதும்ʼ நாஸ²க்நோத்? ");
INSERT INTO santam_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ததோ யீஸு²​: புநரந்தர்தீ³ர்க⁴ம்ʼ நிஸ்²வஸ்ய ஸ்²மஸா²நாந்திகம் அக³ச்ச²த்| தத் ஸ்²மஸா²நம் ஏகம்ʼ க³ஹ்வரம்ʼ தந்முகே² பாஷாண ஏக ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ததா³ யீஸு²ரவத³த்³ ஏநம்ʼ பாஷாணம் அபஸாரயத, தத​: ப்ரமீதஸ்ய ப⁴கி³நீ மர்தா²வத³த் ப்ரபோ⁴, அது⁴நா தத்ர து³ர்க³ந்தோ⁴ ஜாத​:, யதோத்³ய சத்வாரி தி³நாநி ஸ்²மஸா²நே ஸ திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ததா³ யீஸு²ரவாதீ³த், யதி³ விஸ்²வஸிஷி தர்ஹீஸ்²வரஸ்ய மஹிமப்ரகாஸ²ம்ʼ த்³ரக்ஷ்யஸி கதா²மிமாம்ʼ கிம்ʼ துப்⁴யம்ʼ நாகத²யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ததா³ ம்ருʼதஸ்ய ஸ்²மஸா²நாத் பாஷாணோ(அ)பஸாரிதே யீஸு²ரூர்த்³வ்வம்ʼ பஸ்²யந் அகத²யத், ஹே பித ர்மம நேவேஸநம் அஸ்²ருʼணோ​: காரணாத³ஸ்மாத் த்வாம்ʼ த⁴ந்யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","த்வம்ʼ ஸததம்ʼ ஸ்²ருʼணோஷி தத³ப்யஹம்ʼ ஜாநாமி, கிந்து த்வம்ʼ மாம்ʼ யத் ப்ரைரயஸ்தத்³ யதா²ஸ்மிந் ஸ்தா²நே ஸ்தி²தா லோகா விஸ்²வஸந்தி தத³ர்த²ம் இத³ம்ʼ வாக்யம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","இமாம்ʼ கதா²ம்ʼ கத²யித்வா ஸ ப்ரோச்சைராஹ்வயத், ஹே இலியாஸர் ப³ஹிராக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","தத​: ஸ ப்ரமீத​: ஸ்²மஸா²நவஸ்த்ரை ர்ப³த்³த⁴ஹஸ்தபாதோ³ கா³த்ரமார்ஜநவாஸஸா ப³த்³த⁴முக²ஸ்²ச ப³ஹிராக³ச்ச²த்| யீஸு²ருதி³தவாந் ப³ந்த⁴நாநி மோசயித்வா த்யஜதைநம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","மரியம​: ஸமீபம் ஆக³தா யே யிஹூதீ³யலோகாஸ்ததா³ யீஸோ²ரேதத் கர்ம்மாபஸ்²யந் தேஷாம்ʼ ப³ஹவோ வ்யஸ்²வஸந், ");
INSERT INTO santam_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","கிந்து கேசித³ந்யே பி²ரூஸி²நாம்ʼ ஸமீபம்ʼ க³த்வா யீஸோ²ரேதஸ்ய கர்ம்மணோ வார்த்தாம் அவத³ந்| ");
INSERT INTO santam_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","தத​: பரம்ʼ ப்ரதா⁴நயாஜகா​: பி²ரூஸி²நாஸ்²ச ஸபா⁴ம்ʼ க்ருʼத்வா வ்யாஹரந் வயம்ʼ கிம்ʼ குர்ம்ம​:? ஏஷ மாநவோ ப³ஹூந்யாஸ்²சர்ய்யகர்ம்மாணி கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","யதீ³த்³ருʼஸ²ம்ʼ கர்ம்ம கர்த்தும்ʼ ந வாரயாமஸ்தர்ஹி ஸர்வ்வே லோகாஸ்தஸ்மிந் விஸ்²வஸிஷ்யந்தி ரோமிலோகாஸ்²சாக³த்யாஸ்மாகம் அநயா ராஜதா⁴ந்யா ஸார்த்³த⁴ம்ʼ ராஜ்யம் ஆசே²த்ஸ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ததா³ தேஷாம்ʼ கியபா²நாமா யஸ்தஸ்மிந் வத்ஸரே மஹாயாஜகபதே³ ந்யயுஜ்யத ஸ ப்ரத்யவத³த்³ யூயம்ʼ கிமபி ந ஜாநீத²; ");
INSERT INTO santam_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ஸமக்³ரதே³ஸ²ஸ்ய விநாஸ²தோபி ஸர்வ்வலோகார்த²ம் ஏகஸ்ய ஜநஸ்ய மரணம் அஸ்மாகம்ʼ மங்க³லஹேதுகம் ஏதஸ்ய விவேசநாமபி ந குருத²| ");
INSERT INTO santam_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ஏதாம்ʼ கதா²ம்ʼ ஸ நிஜபு³த்³த்⁴யா வ்யாஹரத்³ இதி ந, ");
INSERT INTO santam_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","கிந்து யீஸூ²ஸ்தத்³தே³ஸீ²யாநாம்ʼ காரணாத் ப்ராணாந் த்யக்ஷ்யதி, தி³ஸி² தி³ஸி² விகீர்ணாந் ஈஸ்²வரஸ்ய ஸந்தாநாந் ஸம்ʼக்³ருʼஹ்யைகஜாதிம்ʼ கரிஷ்யதி ச, தஸ்மிந் வத்ஸரே கியபா² மஹாயாஜகத்வபதே³ நியுக்த​: ஸந் இத³ம்ʼ ப⁴விஷ்யத்³வாக்யம்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","தத்³தி³நமாரப்⁴ய தே கத²ம்ʼ தம்ʼ ஹந்தும்ʼ ஸ²க்நுவந்தீதி மந்த்ரணாம்ʼ கர்த்தும்ʼ ப்ராரேபி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","அதஏவ யிஹூதீ³யாநாம்ʼ மத்⁴யே யீஸு²​: ஸப்ரகாஸ²ம்ʼ க³மநாக³மநே அக்ருʼத்வா தஸ்மாத்³ க³த்வா ப்ராந்தரஸ்ய ஸமீபஸ்தா²யிப்ரதே³ஸ²ஸ்யேப்²ராயிம் நாம்நி நக³ரே ஸி²ஷ்யை​: ஸாகம்ʼ காலம்ʼ யாபயிதும்ʼ ப்ராரேபே⁴| ");
INSERT INTO santam_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","அநந்தரம்ʼ யிஹூதீ³யாநாம்ʼ நிஸ்தாரோத்ஸவே நிகடவர்த்திநி ஸதி தது³த்ஸவாத் பூர்வ்வம்ʼ ஸ்வாந் ஸு²சீந் கர்த்தும்ʼ ப³ஹவோ ஜநா க்³ராமேப்⁴யோ யிரூஸா²லம் நக³ரம் ஆக³ச்ச²ந், ");
INSERT INTO santam_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","யீஸோ²ரந்வேஷணம்ʼ க்ருʼத்வா மந்தி³ரே த³ண்டா³யமாநா​: ஸந்த​: பரஸ்பரம்ʼ வ்யாஹரந், யுஷ்மாகம்ʼ கீத்³ருʼஸோ² போ³தோ⁴ ஜாயதே? ஸ கிம் உத்ஸவே(அ)ஸ்மிந் அத்ராக³மிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ஸ ச குத்ராஸ்தி யத்³யேதத் கஸ்²சித்³ வேத்தி தர்ஹி த³ர்ஸ²யது ப்ரதா⁴நயாஜகா​: பி²ரூஸி²நஸ்²ச தம்ʼ த⁴ர்த்தும்ʼ பூர்வ்வம் இமாம் ஆஜ்ஞாம்ʼ ப்ராசாரயந்| ");
INSERT INTO santam_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","நிஸ்தாரோத்ஸவாத் பூர்வ்வம்ʼ தி³நஷட்கே ஸ்தி²தே யீஸு² ர்யம்ʼ ப்ரமீதம் இலியாஸரம்ʼ ஸ்²மஸா²நாத்³ உத³ஸ்தா²பரத் தஸ்ய நிவாஸஸ்தா²நம்ʼ பை³த²நியாக்³ராமம் ஆக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","தத்ர தத³ர்த²ம்ʼ ரஜந்யாம்ʼ போ⁴ஜ்யே க்ருʼதே மர்தா² பர்ய்யவேஷயத்³ இலியாஸர் ச தஸ்ய ஸங்கி³பி⁴​: ஸார்த்³த⁴ம்ʼ போ⁴ஜநாஸந உபாவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ததா³ மரியம் அர்த்³த⁴ஸேடகம்ʼ ப³ஹுமூல்யம்ʼ ஜடாமாம்ʼஸீயம்ʼ தைலம் ஆநீய யீஸோ²ஸ்²சரணயோ ர்மர்த்³த³யித்வா நிஜகேஸ² ர்மார்ஷ்டும் ஆரப⁴த; ததா³ தைலஸ்ய பரிமலேந க்³ருʼஹம் ஆமோதி³தம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ய​: ஸி²மோந​: புத்ர ரிஷ்கரியோதீயோ யிஹூதா³நாமா யீஸு²ம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி ஸ ஸி²ஷ்யஸ்ததா³ கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ஏதத்தைலம்ʼ த்ரிபி⁴​: ஸ²தை ர்முத்³ராபதை³ ர்விக்ரீதம்ʼ ஸத்³ த³ரித்³ரேப்⁴ய​: குதோ நாதீ³யத? ");
INSERT INTO santam_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ஸ த³ரித்³ரலோகார்த²ம் அசிந்தயத்³ இதி ந, கிந்து ஸ சௌர ஏவம்ʼ தந்நிகடே முத்³ராஸம்புடகஸ்தி²த்யா தந்மத்⁴யே யத³திஷ்ட²த் தத³பாஹரத் தஸ்மாத் காரணாத்³ இமாம்ʼ கதா²மகத²யத்| ");
INSERT INTO santam_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ததா³ யீஸு²ரகத²யத்³ ஏநாம்ʼ மா வாரய ஸா மம ஸ்²மஸா²நஸ்தா²பநதி³நார்த²ம்ʼ தத³ரக்ஷயத்| ");
INSERT INTO santam_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","த³ரித்³ரா யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ஸர்வ்வதா³ திஷ்ட²ந்தி கிந்த்வஹம்ʼ ஸர்வ்வதா³ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ந திஷ்டா²மி| ");
INSERT INTO santam_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","தத​: பரம்ʼ யீஸு²ஸ்தத்ராஸ்தீதி வார்த்தாம்ʼ ஸ்²ருத்வா ப³ஹவோ யிஹூதீ³யாஸ்தம்ʼ ஸ்²மஸா²நாது³த்தா²பிதம் இலியாஸரஞ்ச த்³ரஷ்டும்ʼ தத் ஸ்தா²நம் ஆக³ச்ச²ந| ");
INSERT INTO santam_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ததா³ ப்ரதா⁴நயாஜகாஸ்தம் இலியாஸரமபி ஸம்ʼஹர்த்தும் அமந்த்ரயந் ; ");
INSERT INTO santam_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","யதஸ்தேந ப³ஹவோ யிஹூதீ³யா க³த்வா யீஸௌ² வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","அநந்தரம்ʼ யீஸு² ர்யிரூஸா²லம் நக³ரம் ஆக³ச்ச²தீதி வார்த்தாம்ʼ ஸ்²ருத்வா பரே(அ)ஹநி உத்ஸவாக³தா ப³ஹவோ லோகா​: ");
INSERT INTO santam_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","க²ர்ஜ்ஜூரபத்ராத்³யாநீய தம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ ப³ஹிராக³த்ய ஜய ஜயேதி வாசம்ʼ ப்ரோச்சை ர்வக்தும் ஆரப⁴ந்த, இஸ்ராயேலோ யோ ராஜா பரமேஸ்²வரஸ்ய நாம்நாக³ச்ச²தி ஸ த⁴ந்ய​:| ");
INSERT INTO santam_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ததா³ \"ஹே ஸியோந​: கந்யே மா பை⁴ஷீ​: பஸ்²யாயம்ʼ தவ ராஜா க³ர்த்³த³ப⁴ஸா²வகம் ஆருஹ்யாக³ச்ச²தி\" ");
INSERT INTO santam_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","இதி ஸா²ஸ்த்ரீயவசநாநுஸாரேண யீஸு²ரேகம்ʼ யுவக³ர்த்³த³ப⁴ம்ʼ ப்ராப்ய தது³பர்ய்யாரோஹத்| ");
INSERT INTO santam_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","அஸ்யா​: க⁴டநாயாஸ்தாத்பர்ய்யம்ʼ ஸி²ஷ்யா​: ப்ரத²மம்ʼ நாபு³த்⁴யந்த, கிந்து யீஸௌ² மஹிமாநம்ʼ ப்ராப்தே ஸதி வாக்யமித³ம்ʼ தஸ்மிந அகத்²யத லோகாஸ்²ச தம்ப்ரதீத்த²ம் அகுர்வ்வந் இதி தே ஸ்ம்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ஸ இலியாஸரம்ʼ ஸ்²மஸா²நாத்³ ஆக³ந்தும் ஆஹ்வதவாந் ஸ்²மஸா²நாஞ்ச உத³ஸ்தா²பயத்³ யே யே லோகாஸ்தத்கர்ம்ய ஸாக்ஷாத்³ அபஸ்²யந் தே ப்ரமாணம்ʼ தா³தும் ஆரப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ஸ ஏதாத்³ருʼஸ²ம் அத்³பு⁴தம்ʼ கர்ம்மகரோத் தஸ்ய ஜநஸ்²ருதே ர்லோகாஸ்தம்ʼ ஸாக்ஷாத் கர்த்தும் ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","தத​: பி²ரூஸி²ந​: பரஸ்பரம்ʼ வக்தும் ஆரப⁴ந்த யுஷ்மாகம்ʼ ஸர்வ்வாஸ்²சேஷ்டா வ்ருʼதா² ஜாதா​:, இதி கிம்ʼ யூயம்ʼ ந பு³த்⁴யத்⁴வே? பஸ்²யத ஸர்வ்வே லோகாஸ்தஸ்ய பஸ்²சாத்³வர்த்திநோப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ப⁴ஜநம்ʼ கர்த்தும் உத்ஸவாக³தாநாம்ʼ லோகாநாம்ʼ கதிபயா ஜநா அந்யதே³ஸீ²யா ஆஸந் , ");
INSERT INTO santam_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","தே கா³லீலீயபை³த்ஸைதா³நிவாஸிந​: பி²லிபஸ்ய ஸமீபம் ஆக³த்ய வ்யாஹரந் ஹே மஹேச்ச² வயம்ʼ யீஸு²ம்ʼ த்³ரஷ்டும் இச்சா²ம​:| ");
INSERT INTO santam_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","தத​: பி²லிபோ க³த்வா ஆந்த்³ரியம் அவத³த் பஸ்²சாத்³ ஆந்த்³ரியபி²லிபௌ யீஸ²வே வார்த்தாம் அகத²யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ததா³ யீஸு²​: ப்ரத்யுதி³தவாந் மாநவஸுதஸ்ய மஹிமப்ராப்திஸமய உபஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி, தா⁴ந்யபீ³ஜம்ʼ ம்ருʼத்திகாயாம்ʼ பதித்வா யதி³ ந ம்ருʼயதே தர்ஹ்யேகாகீ திஷ்ட²தி கிந்து யதி³ ம்ருʼயதே தர்ஹி ப³ஹுகு³ணம்ʼ ப²லம்ʼ ப²லதி| ");
INSERT INTO santam_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","யோ ஜநேा நிஜப்ராணாந் ப்ரியாந் ஜாநாதி ஸ தாந் ஹாரயிஷ்யதி கிந்து யேा ஜந இஹலோகே நிஜப்ராணாந் அப்ரியாந் ஜாநாதி ஸேाநந்தாயு​: ப்ராப்தும்ʼ தாந் ரக்ஷிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","கஸ்²சித்³ யதி³ மம ஸேவகோ ப⁴விதும்ʼ வாஞ்ச²தி தர்ஹி ஸ மம பஸ்²சாத்³கா³மீ ப⁴வது, தஸ்மாத்³ அஹம்ʼ யத்ர திஷ்டா²மி மம ஸேவகேाபி தத்ர ஸ்தா²ஸ்யதி; யோ ஜநோ மாம்ʼ ஸேவதே மம பிதாபி தம்ʼ ஸம்மம்ʼஸ்யதே| ");
INSERT INTO santam_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ஸாம்ப்ரதம்ʼ மம ப்ராணா வ்யாகுலா ப⁴வந்தி, தஸ்மாத்³ ஹே பிதர ஏதஸ்மாத் ஸமயாந் மாம்ʼ ரக்ஷ, இத்யஹம்ʼ கிம்ʼ ப்ரார்த²யிஷ்யே? கிந்த்வஹம் ஏதத்ஸமயார்த²ம் அவதீர்ணவாந்| ");
INSERT INTO santam_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ஹே பித: ஸ்வநாம்நோ மஹிமாநம்ʼ ப்ரகாஸ²ய; தநைவ ஸ்வநாம்நோ மஹிமாநம் அஹம்ʼ ப்ராகாஸ²யம்ʼ புநரபி ப்ரகாஸ²யிஷ்யாமி, ஏஷா க³க³ணீயா வாணீ தஸ்மிந் ஸமயே(அ)ஜாயத| ");
INSERT INTO santam_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","தச்ஸ்²ருத்வா ஸமீபஸ்த²லோகாநாம்ʼ கேசித்³ அவத³ந் மேகோ⁴(அ)க³ர்ஜீத், கேசித்³ அவத³ந் ஸ்வர்கீ³யதூ³தோ(அ)நேந ஸஹ கதா²மசகத²த்| ");
INSERT INTO santam_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ததா³ யீஸு²​: ப்ரத்யவாதீ³த், மத³ர்த²ம்ʼ ஸ²ப்³தோ³யம்ʼ நாபூ⁴த் யுஷ்மத³ர்த²மேவாபூ⁴த்| ");
INSERT INTO santam_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","அது⁴நா ஜக³தோஸ்ய விசார: ஸம்பத்ஸ்யதே, அது⁴நாஸ்ய ஜக³த: பதீ ராஜ்யாத் ச்யோஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","யத்³யஈ ப்ருʼதி²வ்யா ஊர்த்³வ்வே ப்ரோத்தா²பிதோஸ்மி தர்ஹி ஸர்வ்வாந் மாநவாந் ஸ்வஸமீபம் ஆகர்ஷிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","கத²ம்ʼ தஸ்ய ம்ருʼதி ர்ப⁴விஷ்யதி, ஏதத்³ போ³த⁴யிதும்ʼ ஸ இமாம்ʼ கதா²ம் அகத²யத்| ");
INSERT INTO santam_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ததா³ லோகா அகத²யந் ஸோபி⁴ஷிக்த​: ஸர்வ்வதா³ திஷ்ட²தீதி வ்யவஸ்தா²க்³ரந்தே² ஸ்²ருதம் அஸ்மாபி⁴​:, தர்ஹி மநுஷ்யபுத்ர​: ப்ரோத்தா²பிதோ ப⁴விஷ்யதீதி வாக்யம்ʼ கத²ம்ʼ வத³ஸி? மநுஷ்யபுத்ரோயம்ʼ க​:? ");
INSERT INTO santam_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ததா³ யீஸு²ரகதா²யத்³ யுஷ்மாபி⁴​: ஸார்த்³த⁴ம் அல்பதி³நாநி ஜ்யோதிராஸ்தே, யதா² யுஷ்மாந் அந்த⁴காரோ நாச்சா²த³யதி தத³ர்த²ம்ʼ யாவத்காலம்ʼ யுஷ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ ஜ்யோதிஸ்திஷ்ட²தி தாவத்காலம்ʼ க³ச்ச²த; யோ ஜநோ(அ)ந்த⁴காரே க³ச்ச²தி ஸ குத்ர யாதீதி ந ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","அதஏவ யாவத்காலம்ʼ யுஷ்மாகம்ʼ நிகடே ஜ்யோதிராஸ்தே தாவத்காலம்ʼ ஜ்யோதீரூபஸந்தாநா ப⁴விதும்ʼ ஜ்யோதிஷி விஸ்²வஸித; இமாம்ʼ கதா²ம்ʼ கத²யித்வா யீஸு²​: ப்ரஸ்தா²ய தேப்⁴ய​: ஸ்வம்ʼ கு³ப்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","யத்³யபி யீஸு²ஸ்தேஷாம்ʼ ஸமக்ஷம் ஏதாவதா³ஸ்²சர்ய்யகர்ம்மாணி க்ருʼதவாந் ததா²பி தே தஸ்மிந் ந வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","அதஏவ க​: ப்ரத்யேதி ஸுஸம்ʼவாத³ம்ʼ பரேஸா²ஸ்மத் ப்ரசாரிதம்ʼ? ப்ரகாஸ²தே பரேஸ²ஸ்ய ஹஸ்த​: கஸ்ய ச ஸந்நிதௌ⁴? யிஸ²யியப⁴விஷ்யத்³வாதி³நா யதே³தத்³ வாக்யமுக்தம்ʼ தத் ஸப²லம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","தே ப்ரத்யேதும்ʼ நாஸ²ந்குவந் தஸ்மிந் யிஸ²யியப⁴விஷ்யத்³வாதி³ புநரவாதீ³த்³, ");
INSERT INTO santam_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","யதா³, \"தே நயநை ர்ந பஸ்²யந்தி பு³த்³தி⁴பி⁴ஸ்²ச ந பு³த்⁴யந்தே தை ர்மந​:ஸு பரிவர்த்திதேஷு ச தாநஹம்ʼ யதா² ஸ்வஸ்தா²ந் ந கரோமி ததா² ஸ தேஷாம்ʼ லோசநாந்யந்தா⁴நி க்ருʼத்வா தேஷாமந்த​:கரணாநி கா³டா⁴நி கரிஷ்யதி| \" ");
INSERT INTO santam_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","யிஸ²யியோ யதா³ யீஸோ² ர்மஹிமாநம்ʼ விலோக்ய தஸ்மிந் கதா²மகத²யத் ததா³ ப⁴விஷ்யத்³வாக்யம் ஈத்³ருʼஸ²ம்ʼ ப்ரகாஸ²யத்| ");
INSERT INTO santam_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ததா²ப்யதி⁴பதிநாம்ʼ ப³ஹவஸ்தஸ்மிந் ப்ரத்யாயந்| கிந்து பி²ரூஸி²நஸ்தாந் ப⁴ஜநக்³ருʼஹாத்³ தூ³ரீகுர்வ்வந்தீதி ப⁴யாத் தே தம்ʼ ந ஸ்வீக்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","யத ஈஸ்²வரஸ்ய ப்ரஸ²ம்ʼஸாதோ மாநவாநாம்ʼ ப்ரஸ²ம்ʼஸாயாம்ʼ தே(அ)ப்ரியந்த| ");
INSERT INTO santam_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ததா³ யீஸு²ருச்சை​:காரம் அகத²யத்³ யோ ஜநோ மயி விஸ்²வஸிதி ஸ கேவலே மயி விஸ்²வஸிதீதி ந, ஸ மத்ப்ரேரகே(அ)பி விஸ்²வஸிதி| ");
INSERT INTO santam_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","யோ ஜநோ மாம்ʼ பஸ்²யதி ஸ மத்ப்ரேரகமபி பஸ்²யதி| ");
INSERT INTO santam_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","யோ ஜநோ மாம்ʼ ப்ரத்யேதி ஸ யதா²ந்த⁴காரே ந திஷ்ட²தி தத³ர்த²ம் அஹம்ʼ ஜ்யோதி​:ஸ்வரூபோ பூ⁴த்வா ஜக³த்யஸ்மிந் அவதீர்ணவாந்| ");
INSERT INTO santam_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","மம கதா²ம்ʼ ஸ்²ருத்வா யதி³ கஸ்²சிந் ந விஸ்²வஸிதி தர்ஹி தமஹம்ʼ தோ³ஷிணம்ʼ ந கரோமி, யதோ ஹேதோ ர்ஜக³தோ ஜநாநாம்ʼ தோ³ஷாந் நிஸ்²சிதாந் கர்த்தும்ʼ நாக³த்ய தாந் பரிசாதும் ஆக³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ய​: கஸ்²சிந் மாம்ʼ ந ஸ்²ரத்³தா⁴ய மம கத²ம்ʼ ந க்³ருʼஹ்லாதி, அந்யஸ்தம்ʼ தோ³ஷிணம்ʼ கரிஷ்யதி வஸ்துதஸ்து யாம்ʼ கதா²மஹம் அசகத²ம்ʼ ஸா கதா² சரமே(அ)ந்ஹி தம்ʼ தோ³ஷிணம்ʼ கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","யதோ ஹேதோரஹம்ʼ ஸ்வத​: கிமபி ந கத²யாமி, கிம்ʼ கிம்ʼ மயா கத²யிதவ்யம்ʼ கிம்ʼ ஸமுபதே³ஷ்டவ்யஞ்ச இதி மத்ப்ரேரயிதா பிதா மாமாஜ்ஞாபயத்| ");
INSERT INTO santam_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","தஸ்ய ஸாஜ்ஞா அநந்தாயுரித்யஹம்ʼ ஜாநாமி, அதஏவாஹம்ʼ யத் கத²யாமி தத் பிதா யதா²ஜ்ஞாபயத் ததை²வ கத²யாம்யஹம்| ");
INSERT INTO santam_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","நிஸ்தாரோத்ஸவஸ்ய கிஞ்சித்காலாத் பூர்வ்வம்ʼ ப்ருʼதி²வ்யா​: பிது​: ஸமீபக³மநஸ்ய ஸமய​: ஸந்நிகர்ஷோபூ⁴த்³ இதி ஜ்ஞாத்வா யீஸு²ராப்ரத²மாத்³ யேஷு ஜக³த்ப்ரவாஸிஷ்வாத்மீயலோகேஷ ப்ரேம கரோதி ஸ்ம தேஷு ஸே²ஷம்ʼ யாவத் ப்ரேம க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","பிதா தஸ்ய ஹஸ்தே ஸர்வ்வம்ʼ ஸமர்பிதவாந் ஸ்வயம் ஈஸ்²வரஸ்ய ஸமீபாத்³ ஆக³ச்ச²த்³ ஈஸ்²வரஸ்ய ஸமீபம்ʼ யாஸ்யதி ச, ஸர்வ்வாண்யேதாநி ஜ்ஞாத்வா ரஜந்யாம்ʼ போ⁴ஜநே ஸம்பூர்ணே ஸதி, ");
INSERT INTO santam_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","யதா³ ஸை²தாந் தம்ʼ பரஹஸ்தேஷு ஸமர்பயிதும்ʼ ஸி²மோந​: புத்ரஸ்ய ஈஷ்காரியோதியஸ்ய யிஹூதா³ அந்த​:கரணே குப்ரவ்ருʼத்திம்ʼ ஸமார்பயத், ");
INSERT INTO santam_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ததா³ யீஸு² ர்போ⁴ஜநாஸநாத்³ உத்தா²ய கா³த்ரவஸ்த்ரம்ʼ மோசயித்வா கா³த்ரமார்ஜநவஸ்த்ரம்ʼ க்³ருʼஹீத்வா தேந ஸ்வகடிம் அப³த்⁴நாத், ");
INSERT INTO santam_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","பஸ்²சாத்³ ஏகபாத்ரே ஜலம் அபி⁴ஷிச்ய ஸி²ஷ்யாணாம்ʼ பாதா³ந் ப்ரக்ஷால்ய தேந கடிப³த்³த⁴கா³த்ரமார்ஜநவாஸஸா மார்ஷ்டும்ʼ ப்ராரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","தத​: ஸி²மோந்பிதரஸ்ய ஸமீபமாக³தே ஸ உக்தவாந் ஹே ப்ரபோ⁴ ப⁴வாந் கிம்ʼ மம பாதௌ³ ப்ரக்ஷாலயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","யீஸு²ருதி³தவாந் அஹம்ʼ யத் கரோமி தத் ஸம்ப்ரதி ந ஜாநாஸி கிந்து பஸ்²சாஜ் ஜ்ஞாஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","தத​: பிதர​: கதி²தவாந் ப⁴வாந் கதா³பி மம பாதௌ³ ந ப்ரக்ஷாலயிஷ்யதி| யீஸு²ரகத²யத்³ யதி³ த்வாம்ʼ ந ப்ரக்ஷாலயே தர்ஹி மயி தவ கோப்யம்ʼஸோ² நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ததா³ ஸி²மோந்பிதர​: கதி²தவாந் ஹே ப்ரபோ⁴ தர்ஹி கேவலபாதௌ³ ந, மம ஹஸ்தௌ ஸி²ரஸ்²ச ப்ரக்ஷாலயது| ");
INSERT INTO santam_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ததோ யீஸு²ரவத³த்³ யோ ஜநோ தௌ⁴தஸ்தஸ்ய ஸர்வ்வாங்க³பரிஷ்க்ருʼதத்வாத் பாதௌ³ விநாந்யாங்க³ஸ்ய ப்ரக்ஷாலநாபேக்ஷா நாஸ்தி| யூயம்ʼ பரிஷ்க்ருʼதா இதி ஸத்யம்ʼ கிந்து ந ஸர்வ்வே, ");
INSERT INTO santam_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","யதோ யோ ஜநஸ்தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி தம்ʼ ஸ ஜ்ஞாதவாந; அதஏவ யூயம்ʼ ஸர்வ்வே ந பரிஷ்க்ருʼதா இமாம்ʼ கதா²ம்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","இத்த²ம்ʼ யீஸு²ஸ்தேஷாம்ʼ பாதா³ந் ப்ரக்ஷால்ய வஸ்த்ரம்ʼ பரிதா⁴யாஸநே ஸமுபவிஸ்²ய கதி²தவாந் அஹம்ʼ யுஷ்மாந் ப்ரதி கிம்ʼ கர்ம்மாகார்ஷம்ʼ ஜாநீத²? ");
INSERT INTO santam_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","யூயம்ʼ மாம்ʼ கு³ரும்ʼ ப்ரபு⁴ஞ்ச வத³த² தத் ஸத்யமேவ வத³த² யதோஹம்ʼ ஸஏவ ப⁴வாமி| ");
INSERT INTO santam_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","யத்³யஹம்ʼ ப்ரபு⁴ ர்கு³ருஸ்²ச ஸந் யுஷ்மாகம்ʼ பாதா³ந் ப்ரக்ஷாலிதவாந் தர்ஹி யுஷ்மாகமபி பரஸ்பரம்ʼ பாத³ப்ரக்ஷாலநம் உசிதம்| ");
INSERT INTO santam_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","அஹம்ʼ யுஷ்மாந் ப்ரதி யதா² வ்யவாஹரம்ʼ யுஷ்மாந் ததா² வ்யவஹர்த்தும் ஏகம்ʼ பந்தா²நம்ʼ த³ர்ஸி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி, ப்ரபோ⁴ ர்தா³ஸோ ந மஹாந் ப்ரேரகாச்ச ப்ரேரிதோ ந மஹாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","இமாம்ʼ கதா²ம்ʼ விதி³த்வா யதி³ தத³நுஸாரத​: கர்ம்மாணி குருத² தர்ஹி யூயம்ʼ த⁴ந்யா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ஸர்வ்வேஷு யுஷ்மாஸு கதா²மிமாம்ʼ கத²யாமி இதி ந, யே மம மநோநீதாஸ்தாநஹம்ʼ ஜாநாமி, கிந்து மம ப⁴க்ஷ்யாணி யோ பு⁴ங்க்தே மத்ப்ராணப்ராதிகூல்யத​:| உத்தா²பயதி பாத³ஸ்ய மூலம்ʼ ஸ ஏஷ மாநவ​:| யதே³தத்³ த⁴ர்ம்மபுஸ்தகஸ்ய வசநம்ʼ தத³நுஸாரேணாவஸ்²யம்ʼ க⁴டிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","அஹம்ʼ ஸ ஜந இத்யத்ர யதா² யுஷ்மாகம்ʼ விஸ்²வாஸோ ஜாயதே தத³ர்த²ம்ʼ ஏதாத்³ருʼஸ²க⁴டநாத் பூர்வ்வம் அஹமிதா³நீம்ʼ யுஷ்மப்⁴யமகத²யம்| ");
INSERT INTO santam_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","அஹம்ʼ யுஷ்மாநதீவ யதா²ர்த²ம்ʼ வதா³மி, மயா ப்ரேரிதம்ʼ ஜநம்ʼ யோ க்³ருʼஹ்லாதி ஸ மாமேவ க்³ருʼஹ்லாதி யஸ்²ச மாம்ʼ க்³ருʼஹ்லாதி ஸ மத்ப்ரேரகம்ʼ க்³ருʼஹ்லாதி| ");
INSERT INTO santam_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ஏதாம்ʼ கதா²ம்ʼ கத²யித்வா யீஸு² ர்து³​:கீ² ஸந் ப்ரமாணம்ʼ த³த்த்வா கதி²தவாந் அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி யுஷ்மாகம் ஏகோ ஜநோ மாம்ʼ பரகரேஷு ஸமர்பயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","தத​: ஸ கமுத்³தி³ஸ்²ய கதா²மேதாம்ʼ கதி²தவாந் இத்யத்ர ஸந்தி³க்³தா⁴​: ஸி²ஷ்யா​: பரஸ்பரம்ʼ முக²மாலோகயிதும்ʼ ப்ராரப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","தஸ்மிந் ஸமயே யீஸு² ர்யஸ்மிந் அப்ரீயத ஸ ஸி²ஷ்யஸ்தஸ்ய வக்ஷ​:ஸ்த²லம் அவாலம்ப³த| ");
INSERT INTO santam_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ஸி²மோந்பிதரஸ்தம்ʼ ஸங்கேதேநாவத³த், அயம்ʼ கமுத்³தி³ஸ்²ய கதா²மேதாம் கத²யதீதி ப்ருʼச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ததா³ ஸ யீஸோ² ர்வக்ஷ​:ஸ்த²லம் அவலம்ப்³ய ப்ருʼஷ்ட²வாந், ஹே ப்ரபோ⁴ ஸ ஜந​: க​:? ");
INSERT INTO santam_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ததோ யீஸு²​: ப்ரத்யவத³த்³ ஏகக²ண்ட³ம்ʼ பூபம்ʼ மஜ்ஜயித்வா யஸ்மை தா³ஸ்யாமி ஸஏவ ஸ​:; பஸ்²சாத் பூபக²ண்ட³மேகம்ʼ மஜ்ஜயித்வா ஸி²மோந​: புத்ராய ஈஷ்கரியோதீயாய யிஹூதை³ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","தஸ்மிந் த³த்தே ஸதி ஸை²தாந் தமாஸ்²ரயத்; ததா³ யீஸு²ஸ்தம் அவத³த் த்வம்ʼ யத் கரிஷ்யஸி தத் க்ஷிப்ரம்ʼ குரு| ");
INSERT INTO santam_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","கிந்து ஸ யேநாஸ²யேந தாம்ʼ கதா²மகதா²யத் தம் உபவிஷ்டலோகாநாம்ʼ கோபி நாபு³த்⁴யத; ");
INSERT INTO santam_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","கிந்து யிஹூதா³​: ஸமீபே முத்³ராஸம்புடகஸ்தி²தே​: கேசித்³ இத்த²ம் அபு³த்⁴யந்த பார்வ்வணாஸாத³நார்த²ம்ʼ கிமபி த்³ரவ்யம்ʼ க்ரேதும்ʼ வா த³ரித்³ரேப்⁴ய​: கிஞ்சித்³ விதரிதும்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ததா³ பூபக²ண்ட³க்³ரஹணாத் பரம்ʼ ஸ தூர்ணம்ʼ ப³ஹிரக³ச்ச²த்; ராத்ரிஸ்²ச ஸமுபஸ்யிதா| ");
INSERT INTO santam_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","யிஹூதே³ ப³ஹிர்க³தே யீஸு²ரகத²யத்³ இதா³நீம்ʼ மாநவஸுதஸ்ய மஹிமா ப்ரகாஸ²தே தேநேஸ்²வரஸ்யாபி மஹிமா ப்ரகாஸ²தே| ");
INSERT INTO santam_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","யதி³ தேநேஸ்²வரஸ்ய மஹிமா ப்ரகாஸ²தே தர்ஹீஸ்²வரோபி ஸ்வேந தஸ்ய மஹிமாநம்ʼ ப்ரகாஸ²யிஷ்யதி தூர்ணமேவ ப்ரகாஸ²யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ஹே வத்ஸா அஹம்ʼ யுஷ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ கிஞ்சித்காலமாத்ரம் ஆஸே, தத​: பரம்ʼ மாம்ʼ ம்ருʼக³யிஷ்யத்⁴வே கிந்த்வஹம்ʼ யத்ஸ்தா²நம்ʼ யாமி தத்ஸ்தா²நம்ʼ யூயம்ʼ க³ந்தும்ʼ ந ஸ²க்ஷ்யத², யாமிமாம்ʼ கதா²ம்ʼ யிஹூதீ³யேப்⁴ய​: கதி²தவாந் ததா²து⁴நா யுஷ்மப்⁴யமபி கத²யாமி| ");
INSERT INTO santam_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","யூயம்ʼ பரஸ்பரம்ʼ ப்ரீயத்⁴வம் அஹம்ʼ யுஷ்மாஸு யதா² ப்ரீயே யூயமபி பரஸ்பரம் ததை²வ ப்ரீயத்⁴வம்ʼ, யுஷ்மாந் இமாம்ʼ நவீநாம் ஆஜ்ஞாம் ஆதி³ஸா²மி| ");
INSERT INTO santam_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","தேநைவ யதி³ பரஸ்பரம்ʼ ப்ரீயத்⁴வே தர்ஹி லக்ஷணேநாநேந யூயம்ʼ மம ஸி²ஷ்யா இதி ஸர்வ்வே ஜ்ஞாதும்ʼ ஸ²க்ஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ஸி²மோநபிதர​: ப்ருʼஷ்ட²வாந் ஹே ப்ரபோ⁴ ப⁴வாந் குத்ர யாஸ்யதி? ததோ யீஸு²​: ப்ரத்யவத³த், அஹம்ʼ யத்ஸ்தா²நம்ʼ யாமி தத்ஸ்தா²நம்ʼ ஸாம்ப்ரதம்ʼ மம பஸ்²சாத்³ க³ந்தும்ʼ ந ஸ²க்நோஷி கிந்து பஸ்²சாத்³ க³மிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ததா³ பிதர​: ப்ரத்யுதி³தவாந், ஹே ப்ரபோ⁴ ஸாம்ப்ரதம்ʼ குதோ ஹேதோஸ்தவ பஸ்²சாத்³ க³ந்தும்ʼ ந ஸ²க்நோமி? த்வத³ர்த²ம்ʼ ப்ராணாந் தா³தும்ʼ ஸ²க்நோமி| ");
INSERT INTO santam_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ததோ யீஸு²​: ப்ரத்யுக்தவாந் மந்நிமித்தம்ʼ கிம்ʼ ப்ராணாந் தா³தும்ʼ ஸ²க்நோஷி? த்வாமஹம்ʼ யதா²ர்த²ம்ʼ வதா³மி, குக்குடரவணாத் பூர்வ்வம்ʼ த்வம்ʼ த்ரி ர்மாம் அபஹ்நோஷ்யஸே| ");
INSERT INTO santam_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","மநோது³​:கி²நோ மா பூ⁴த; ஈஸ்²வரே விஸ்²வஸித மயி ச விஸ்²வஸித| ");
INSERT INTO santam_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","மம பிது க்³ருʼஹே ப³ஹூநி வாஸஸ்தா²நி ஸந்தி நோ சேத் பூர்வ்வம்ʼ யுஷ்மாந் அஜ்ஞாபயிஷ்யம்ʼ யுஷ்மத³ர்த²ம்ʼ ஸ்தா²நம்ʼ ஸஜ்ஜயிதும்ʼ க³ச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","யதி³ க³த்வாஹம்ʼ யுஷ்மந்நிமித்தம்ʼ ஸ்தா²நம்ʼ ஸஜ்ஜயாமி தர்ஹி பநராக³த்ய யுஷ்மாந் ஸ்வஸமீபம்ʼ நேஷ்யாமி, ததோ யத்ராஹம்ʼ திஷ்டா²மி தத்ர யூயமபி ஸ்தா²ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","அஹம்ʼ யத்ஸ்தா²நம்ʼ ப்³ரஜாமி தத்ஸ்தா²நம்ʼ யூயம்ʼ ஜாநீத² தஸ்ய பந்தா²நமபி ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ததா³ தோ²மா அவத³த், ஹே ப்ரபோ⁴ ப⁴வாந் குத்ர யாதி தத்³வயம்ʼ ந ஜாநீம​:, தர்ஹி கத²ம்ʼ பந்தா²நம்ʼ ஜ்ஞாதும்ʼ ஸ²க்நும​:? ");
INSERT INTO santam_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","யீஸு²ரகத²யத்³ அஹமேவ ஸத்யஜீவநரூபபதோ² மயா ந க³ந்தா கோபி பிது​: ஸமீபம்ʼ க³ந்தும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","யதி³ மாம் அஜ்ஞாஸ்யத தர்ஹி மம பிதரமப்யஜ்ஞாஸ்யத கிந்த்வது⁴நாதஸ்தம்ʼ ஜாநீத² பஸ்²யத² ச| ");
INSERT INTO santam_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ததா³ பி²லிப​: கதி²தவாந், ஹே ப்ரபோ⁴ பிதரம்ʼ த³ர்ஸ²ய தஸ்மாத³ஸ்மாகம்ʼ யதே²ஷ்டம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ததோ யீஸு²​: ப்ரத்யாவாதீ³த், ஹே பி²லிப யுஷ்மாபி⁴​: ஸார்த்³த⁴ம் ஏதாவத்³தி³நாநி ஸ்தி²தமபி மாம்ʼ கிம்ʼ ந ப்ரத்யபி⁴ஜாநாஸி? யோ ஜநோ மாம் அபஸ்²யத் ஸ பிதரமப்யபஸ்²யத் தர்ஹி பிதரம் அஸ்மாந் த³ர்ஸ²யேதி கதா²ம்ʼ கத²ம்ʼ கத²யஸி? ");
INSERT INTO santam_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","அஹம்ʼ பிதரி திஷ்டா²மி பிதா மயி திஷ்ட²தீதி கிம்ʼ த்வம்ʼ ந ப்ரத்யஷி? அஹம்ʼ யத்³வாக்யம்ʼ வதா³மி தத் ஸ்வதோ ந வதா³மி கிந்து ய​: பிதா மயி விராஜதே ஸ ஏவ ஸர்வ்வகர்ம்மாணி கராதி| ");
INSERT INTO santam_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","அதஏவ பிதர்ய்யஹம்ʼ திஷ்டா²மி பிதா ச மயி திஷ்ட²தி மமாஸ்யாம்ʼ கதா²யாம்ʼ ப்ரத்யயம்ʼ குருத, நோ சேத் கர்ம்மஹேதோ​: ப்ரத்யயம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","அஹம்ʼ யுஷ்மாநதியதா²ர்த²ம்ʼ வதா³மி, யோ ஜநோ மயி விஸ்²வஸிதி ஸோஹமிவ கர்ம்மாணி கரிஷ்யதி வரம்ʼ ததோபி மஹாகர்ம்மாணி கரிஷ்யதி யதோ ஹேதோரஹம்ʼ பிது​: ஸமீபம்ʼ க³ச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","யதா² புத்ரேண பிது ர்மஹிமா ப்ரகாஸ²தே தத³ர்த²ம்ʼ மம நாம ப்ரோச்ய யத் ப்ரார்த²யிஷ்யத்⁴வே தத் ஸப²லம்ʼ கரிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","யதி³ மம நாம்நா யத் கிஞ்சித்³ யாசத்⁴வே தர்ஹி தத³ஹம்ʼ ஸாத⁴யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","யதி³ மயி ப்ரீயத்⁴வே தர்ஹி மமாஜ்ஞா​: ஸமாசரத| ");
INSERT INTO santam_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ததோ மயா பிது​: ஸமீபே ப்ரார்தி²தே பிதா நிரந்தரம்ʼ யுஷ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ ஸ்தா²தும் இதரமேகம்ʼ ஸஹாயம் அர்தா²த் ஸத்யமயம் ஆத்மாநம்ʼ யுஷ்மாகம்ʼ நிகடம்ʼ ப்ரேஷயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ஏதஜ்ஜக³தோ லோகாஸ்தம்ʼ க்³ரஹீதும்ʼ ந ஸ²க்நுவந்தி யதஸ்தே தம்ʼ நாபஸ்²யந் நாஜநம்ʼஸ்²ச கிந்து யூயம்ʼ ஜாநீத² யதோ ஹேதோ​: ஸ யுஷ்மாகமந்த ர்நிவஸதி யுஷ்மாகம்ʼ மத்⁴யே ஸ்தா²ஸ்யதி ச| ");
INSERT INTO santam_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","அஹம்ʼ யுஷ்மாந் அநாதா²ந் க்ருʼத்வா ந யாஸ்யாமி புநரபி யுஷ்மாகம்ʼ ஸமீபம் ஆக³மிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","கியத்காலரத் பரம் அஸ்ய ஜக³தோ லோகா மாம்ʼ புந ர்ந த்³ரக்ஷ்யந்தி கிந்து யூயம்ʼ த்³ரக்ஷ்யத²;அஹம்ʼ ஜீவிஷ்யாமி தஸ்மாத் காரணாத்³ யூயமபி ஜீவிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","பிதர்ய்யஹமஸ்மி மயி ச யூயம்ʼ ஸ்த², ததா²ஹம்ʼ யுஷ்மாஸ்வஸ்மி தத³பி ததா³ ஜ்ஞாஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","யோ ஜநோ மமாஜ்ஞா க்³ருʼஹீத்வா தா ஆசரதி ஸஏவ மயி ப்ரீயதே; யோ ஜநஸ்²ச மயி ப்ரீயதே ஸஏவ மம பிது​: ப்ரியபாத்ரம்ʼ ப⁴விஷ்யதி, ததா²ஹமபி தஸ்மிந் ப்ரீத்வா தஸ்மை ஸ்வம்ʼ ப்ரகாஸ²யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ததா³ ஈஷ்கரியோதீயாத்³ அந்யோ யிஹூதா³ஸ்தமவத³த், ஹே ப்ரபோ⁴ ப⁴வாந் ஜக³தோ லோகாநாம்ʼ ஸந்நிதௌ⁴ ப்ரகாஸி²தோ ந பூ⁴த்வாஸ்மாகம்ʼ ஸந்நிதௌ⁴ குத​: ப்ரகாஸி²தோ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ததோ யீஸு²​: ப்ரத்யுதி³தவாந், யோ ஜநோ மயி ப்ரீயதே ஸ மமாஜ்ஞா அபி க்³ருʼஹ்லாதி, தேந மம பிதாபி தஸ்மிந் ப்ரேஷ்யதே, ஆவாஞ்ச தந்நிகடமாக³த்ய தேந ஸஹ நிவத்ஸ்யாவ​:| ");
INSERT INTO santam_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","யோ ஜநோ மயி ந ப்ரீயதே ஸ மம கதா² அபி ந க்³ருʼஹ்லாதி புநஸ்²ச யாமிமாம்ʼ கதா²ம்ʼ யூயம்ʼ ஸ்²ருʼணுத² ஸா கதா² கேவலஸ்ய மம ந கிந்து மம ப்ரேரகோ ய​: பிதா தஸ்யாபி கதா²| ");
INSERT INTO santam_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","இதா³நீம்ʼ யுஷ்மாகம்ʼ நிகடே வித்³யமாநோஹம் ஏதா​: ஸகலா​: கதா²​: கத²யாமி| ");
INSERT INTO santam_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","கிந்த்வித​: பரம்ʼ பித்ரா ய​: ஸஹாயோ(அ)ர்தா²த் பவித்ர ஆத்மா மம நாம்நி ப்ரேரயிஷ்யதி ஸ ஸர்வ்வம்ʼ ஸி²க்ஷயித்வா மயோக்தா​: ஸமஸ்தா​: கதா² யுஷ்மாந் ஸ்மாரயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","அஹம்ʼ யுஷ்மாகம்ʼ நிகடே ஸா²ந்திம்ʼ ஸ்தா²பயித்வா யாமி, நிஜாம்ʼ ஸா²ந்திம்ʼ யுஷ்மப்⁴யம்ʼ த³தா³மி, ஜக³தோ லோகா யதா² த³தா³தி ததா²ஹம்ʼ ந த³தா³மி; யுஷ்மாகம் அந்த​:கரணாநி து³​:கி²தாநி பீ⁴தாநி ச ந ப⁴வந்து| ");
INSERT INTO santam_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","அஹம்ʼ க³த்வா புநரபி யுஷ்மாகம்ʼ ஸமீபம் ஆக³மிஷ்யாமி மயோக்தம்ʼ வாக்யமித³ம்ʼ யூயம் அஸ்²ரௌஷ்ட; யதி³ மய்யப்ரேஷ்யத்⁴வம்ʼ தர்ஹ்யஹம்ʼ பிது​: ஸமீபம்ʼ க³ச்சா²மி மமாஸ்யாம்ʼ கதா²யாம்ʼ யூயம் அஹ்லாதி³ஷ்யத்⁴வம்ʼ யதோ மம பிதா மத்தோபி மஹாந்| ");
INSERT INTO santam_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","தஸ்யா க⁴டநாயா​: ஸமயே யதா² யுஷ்மாகம்ʼ ஸ்²ரத்³தா⁴ ஜாயதே தத³ர்த²ம் அஹம்ʼ தஸ்யா க⁴டநாயா​: பூர்வ்வம் இதா³நீம்ʼ யுஷ்மாந் ஏதாம்ʼ வார்த்தாம்ʼ வதா³மி| ");
INSERT INTO santam_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","இத​: பரம்ʼ யுஷ்மாபி⁴​: ஸஹ மம ப³ஹவ ஆலாபா ந ப⁴விஷ்யந்தி யத​: காரணாத்³ ஏதஸ்ய ஜக³த​: பதிராக³ச்ச²தி கிந்து மயா ஸஹ தஸ்ய கோபி ஸம்ப³ந்தோ⁴ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","அஹம்ʼ பிதரி ப்ரேம கரோமி ததா² பிது ர்விதி⁴வத் கர்ம்மாணி கரோமீதி யேந ஜக³தோ லோகா ஜாநந்தி தத³ர்த²ம் உத்திஷ்ட²த வயம்ʼ ஸ்தா²நாத³ஸ்மாத்³ க³ச்சா²ம| ");
INSERT INTO santam_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","அஹம்ʼ ஸத்யத்³ராக்ஷாலதாஸ்வரூபோ மம பிதா தூத்³யாநபரிசாரகஸ்வரூபஞ்ச| ");
INSERT INTO santam_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","மம யாஸு ஸா²கா²ஸு ப²லாநி ந ப⁴வந்தி தா​: ஸ சி²நத்தி ததா² ப²லவத்ய​: ஸா²கா² யதா²தி⁴கப²லாநி ப²லந்தி தத³ர்த²ம்ʼ தா​: பரிஷ்கரோதி| ");
INSERT INTO santam_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","இதா³நீம்ʼ மயோக்தோபதே³ஸே²ந யூயம்ʼ பரிஷ்க்ருʼதா​:| ");
INSERT INTO santam_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","அத​: காரணாத் மயி திஷ்ட²த தேநாஹமபி யுஷ்மாஸு திஷ்டா²மி, யதோ ஹேதோ ர்த்³ராக்ஷாலதாயாம் அஸம்ʼலக்³நா ஸா²கா² யதா² ப²லவதீ ப⁴விதும்ʼ ந ஸ²க்நோதி ததா² யூயமபி மய்யதிஷ்ட²ந்த​: ப²லவந்தோ ப⁴விதும்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","அஹம்ʼ த்³ராக்ஷாலதாஸ்வரூபோ யூயஞ்ச ஸா²கா²ஸ்வரூபோ​:; யோ ஜநோ மயி திஷ்ட²தி யத்ர சாஹம்ʼ திஷ்டா²மி, ஸ ப்ரசூரப²லை​: ப²லவாந் ப⁴வதி, கிந்து மாம்ʼ விநா யூயம்ʼ கிமபி கர்த்தும்ʼ ந ஸ²க்நுத²| ");
INSERT INTO santam_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ய​: கஸ்²சிந் மயி ந திஷ்ட²தி ஸ ஸு²ஷ்கஸா²கே²வ ப³ஹி ர்நிக்ஷிப்யதே லோகாஸ்²ச தா ஆஹ்ருʼத்ய வஹ்நௌ நிக்ஷிப்ய தா³ஹயந்தி| ");
INSERT INTO santam_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","யதி³ யூயம்ʼ மயி திஷ்ட²த² மம கதா² ச யுஷ்மாஸு திஷ்ட²தி தர்ஹி யத்³ வாஞ்சி²த்வா யாசிஷ்யத்⁴வே யுஷ்மாகம்ʼ ததே³வ ஸப²லம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","யதி³ யூயம்ʼ ப்ரசூரப²லவந்தோ ப⁴வத² தர்ஹி தத்³வாரா மம பிது ர்மஹிமா ப்ரகாஸி²ஷ்யதே ததா² யூயம்ʼ மம ஸி²ஷ்யா இதி பரிக்ஷாயிஷ்யத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","பிதா யதா² மயி ப்ரீதவாந் அஹமபி யுஷ்மாஸு ததா² ப்ரீதவாந் அதோ ஹேதோ ர்யூயம்ʼ நிரந்தரம்ʼ மம ப்ரேமபாத்ராணி பூ⁴த்வா திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","அஹம்ʼ யதா² பிதுராஜ்ஞா க்³ருʼஹீத்வா தஸ்ய ப்ரேமபா⁴ஜநம்ʼ திஷ்டா²மி ததை²வ யூயமபி யதி³ மமாஜ்ஞா கு³ஹ்லீத² தர்ஹி மம ப்ரேமபா⁴ஜநாநி ஸ்தா²ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","யுஷ்மந்நிமித்தம்ʼ மம ய ஆஹ்லாத³​: ஸ யதா² சிரம்ʼ திஷ்ட²தி யுஷ்மாகம் ஆநந்த³ஸ்²ச யதா² பூர்ய்யதே தத³ர்த²ம்ʼ யுஷ்மப்⁴யம் ஏதா​: கதா² அத்ரகத²ம்| ");
INSERT INTO santam_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","அஹம்ʼ யுஷ்மாஸு யதா² ப்ரீயே யூயமபி பரஸ்பரம்ʼ ததா² ப்ரீயத்⁴வம் ஏஷா மமாஜ்ஞா| ");
INSERT INTO santam_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","மித்ராணாம்ʼ காரணாத் ஸ்வப்ராணதா³நபர்ய்யந்தம்ʼ யத் ப்ரேம தஸ்மாந் மஹாப்ரேம கஸ்யாபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","அஹம்ʼ யத்³யத்³ ஆதி³ஸா²மி தத்ததே³வ யதி³ யூயம் ஆசரத தர்ஹி யூயமேவ மம மித்ராணி| ");
INSERT INTO santam_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","அத்³யாரப்⁴ய யுஷ்மாந் தா³ஸாந் ந வதி³ஷ்யாமி யத் ப்ரபு⁴ ர்யத் கரோதி தா³ஸஸ்தத்³ ந ஜாநாதி; கிந்து பிது​: ஸமீபே யத்³யத்³ அஸ்²ருʼணவம்ʼ தத் ஸர்வ்வம்ʼ யூஷ்மாந் அஜ்ஞாபயம் தத்காரணாத்³ யுஷ்மாந் மித்ராணி ப்ரோக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","யூயம்ʼ மாம்ʼ ரோசிதவந்த இதி ந, கிந்த்வஹமேவ யுஷ்மாந் ரோசிதவாந் யூயம்ʼ க³த்வா யதா² ப²லாந்யுத்பாத³யத² தாநி ப²லாநி சாக்ஷயாணி ப⁴வந்தி, தத³ர்த²ம்ʼ யுஷ்மாந் ந்யஜுநஜம்ʼ தஸ்மாந் மம நாம ப்ரோச்ய பிதரம்ʼ யத் கிஞ்சித்³ யாசிஷ்யத்⁴வே ததே³வ ஸ யுஷ்மப்⁴யம்ʼ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","யூயம்ʼ பரஸ்பரம்ʼ ப்ரீயத்⁴வம் அஹம் இத்யாஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ஜக³தோ லோகை ர்யுஷ்மாஸு ருʼதீயிதேஷு தே பூர்வ்வம்ʼ மாமேவார்த்தீயந்த இதி யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","யதி³ யூயம்ʼ ஜக³தோ லோகா அப⁴விஷ்யத தர்ஹி ஜக³தோ லோகா யுஷ்மாந் ஆத்மீயாந் பு³த்³த்⁴வாப்ரேஷ்யந்த; கிந்து யூயம்ʼ ஜக³தோ லோகா ந ப⁴வத², அஹம்ʼ யுஷ்மாந் அஸ்மாஜ்ஜக³தோ(அ)ரோசயம் ஏதஸ்மாத் காரணாஜ்ஜக³தோ லோகா யுஷ்மாந் ருʼதீயந்தே| ");
INSERT INTO santam_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","தா³ஸ​: ப்ரபோ⁴ ர்மஹாந் ந ப⁴வதி மமைதத் பூர்வ்வீயம்ʼ வாக்யம்ʼ ஸ்மரத; தே யதி³ மாமேவாதாட³யந் தர்ஹி யுஷ்மாநபி தாட³யிஷ்யந்தி, யதி³ மம வாக்யம்ʼ க்³ருʼஹ்லந்தி தர்ஹி யுஷ்மாகமபி வாக்யம்ʼ க்³ரஹீஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","கிந்து தே மம நாமகாரணாத்³ யுஷ்மாந் ப்ரதி தாத்³ருʼஸ²ம்ʼ வ்யவஹரிஷ்யந்தி யதோ யோ மாம்ʼ ப்ரேரிதவாந் தம்ʼ தே ந ஜாநந்தி| ");
INSERT INTO santam_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","தேஷாம்ʼ ஸந்நிதி⁴ம் ஆக³த்ய யத்³யஹம்ʼ நாகத²யிஷ்யம்ʼ தர்ஹி தேஷாம்ʼ பாபம்ʼ நாப⁴விஷ்யத் கிந்த்வது⁴நா தேஷாம்ʼ பாபமாச்சா²த³யிதும் உபாயோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","யோ ஜநோ மாம் ருʼதீயதே ஸ மம பிதரமபி ருʼதீயதே| ");
INSERT INTO santam_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","யாத்³ருʼஸா²நி கர்ம்மாணி கேநாபி கதா³பி நாக்ரியந்த தாத்³ருʼஸா²நி கர்ம்மாணி யதி³ தேஷாம்ʼ ஸாக்ஷாத்³ அஹம்ʼ நாகரிஷ்யம்ʼ தர்ஹி தேஷாம்ʼ பாபம்ʼ நாப⁴விஷ்யத் கிந்த்வது⁴நா தே த்³ருʼஷ்ட்வாபி மாம்ʼ மம பிதரஞ்சார்த்தீயந்த| ");
INSERT INTO santam_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","தஸ்மாத் தே(அ)காரணம்ʼ மாம் ருʼதீயந்தே யதே³தத்³ வசநம்ʼ தேஷாம்ʼ ஸா²ஸ்த்ரே லிகி²தமாஸ்தே தத் ஸப²லம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","கிந்து பிது ர்நிர்க³தம்ʼ யம்ʼ ஸஹாயமர்தா²த் ஸத்யமயம் ஆத்மாநம்ʼ பிது​: ஸமீபாத்³ யுஷ்மாகம்ʼ ஸமீபே ப்ரேஷயிஷ்யாமி ஸ ஆக³த்ய மயி ப்ரமாணம்ʼ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","யூயம்ʼ ப்ரத²மமாரப்⁴ய மயா ஸார்த்³த⁴ம்ʼ திஷ்ட²த² தஸ்மாத்³தே⁴தோ ர்யூயமபி ப்ரமாணம்ʼ தா³ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","யுஷ்மாகம்ʼ யதா² வாதா⁴ ந ஜாயதே தத³ர்த²ம்ʼ யுஷ்மாந் ஏதாநி ஸர்வ்வவாக்யாநி வ்யாஹரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","லோகா யுஷ்மாந் ப⁴ஜநக்³ருʼஹேப்⁴யோ தூ³ரீகரிஷ்யந்தி ததா² யஸ்மிந் ஸமயே யுஷ்மாந் ஹத்வா ஈஸ்²வரஸ்ய துஷ்டி ஜநகம்ʼ கர்ம்மாகுர்ம்ம இதி மம்ʼஸ்யந்தே ஸ ஸமய ஆக³ச்ச²ந்தி| ");
INSERT INTO santam_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","தே பிதரம்ʼ மாஞ்ச ந ஜாநந்தி, தஸ்மாத்³ யுஷ்மாந் ப்ரதீத்³ருʼஸ²ம் ஆசரிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","அதோ ஹேதா​: ஸமயே ஸமுபஸ்தி²தே யதா² மம கதா² யுஷ்மாகம்ʼ மந​:ஸு​: ஸமுபதிஷ்ட²தி தத³ர்த²ம்ʼ யுஷ்மாப்⁴யம் ஏதாம்ʼ கதா²ம்ʼ கத²யாமி யுஷ்மாபி⁴​: ஸார்த்³த⁴ம் அஹம்ʼ திஷ்ட²ந் ப்ரத²மம்ʼ தாம்ʼ யுஷ்மப்⁴யம்ʼ நாகத²யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ஸாம்ப்ரதம்ʼ ஸ்வஸ்ய ப்ரேரயிது​: ஸமீபம்ʼ க³ச்சா²மி ததா²பி த்வம்ʼ க்க க³ச்ச²ஸி கதா²மேதாம்ʼ யுஷ்மாகம்ʼ கோபி மாம்ʼ ந ப்ருʼச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","கிந்து மயோக்தாபி⁴ராபி⁴​: கதா²பி⁴ ர்யூஷ்மாகம் அந்த​:கரணாநி து³​:கே²ந பூர்ணாந்யப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ததா²ப்யஹம்ʼ யதா²ர்த²ம்ʼ கத²யாமி மம க³மநம்ʼ யுஷ்மாகம்ʼ ஹிதார்த²மேவ, யதோ ஹேதோ ர்க³மநே ந க்ருʼதே ஸஹாயோ யுஷ்மாகம்ʼ ஸமீபம்ʼ நாக³மிஷ்யதி கிந்து யதி³ க³ச்சா²மி தர்ஹி யுஷ்மாகம்ʼ ஸமீபே தம்ʼ ப்ரேஷயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","தத​: ஸ ஆக³த்ய பாபபுண்யத³ண்டே³ஷு ஜக³தோ லோகாநாம்ʼ ப்ரபோ³த⁴ம்ʼ ஜநயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","தே மயி ந விஸ்²வஸந்தி தஸ்மாத்³தே⁴தோ​: பாபப்ரபோ³த⁴ம்ʼ ஜநயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","யுஷ்மாகம் அத்³ருʼஸ்²ய​: ஸந்நஹம்ʼ பிது​: ஸமீபம்ʼ க³ச்சா²மி தஸ்மாத்³ புண்யே ப்ரபோ³த⁴ம்ʼ ஜநயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ஏதஜ்ஜக³தோ(அ)தி⁴பதி ர்த³ண்டா³ஜ்ஞாம்ʼ ப்ராப்நோதி தஸ்மாத்³ த³ண்டே³ ப்ரபோ³த⁴ம்ʼ ஜநயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","யுஷ்மப்⁴யம்ʼ கத²யிதும்ʼ மமாநேகா​: கதா² ஆஸதே, தா​: கதா² இதா³நீம்ʼ யூயம்ʼ ஸோடு⁴ம்ʼ ந ஸ²க்நுத²; ");
INSERT INTO santam_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","கிந்து ஸத்யமய ஆத்மா யதா³ ஸமாக³மிஷ்யதி ததா³ ஸர்வ்வம்ʼ ஸத்யம்ʼ யுஷ்மாந் நேஷ்யதி, ஸ ஸ்வத​: கிமபி ந வதி³ஷ்யதி கிந்து யச்ச்²ரோஷ்யதி ததே³வ கத²யித்வா பா⁴விகார்ய்யம்ʼ யுஷ்மாந் ஜ்ஞாபயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","மம மஹிமாநம்ʼ ப்ரகாஸ²யிஷ்யதி யதோ மதீ³யாம்ʼ கதா²ம்ʼ க்³ருʼஹீத்வா யுஷ்மாந் போ³த⁴யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","பிது ர்யத்³யத்³ ஆஸ்தே தத் ஸர்வ்வம்ʼ மம தஸ்மாத்³ காரணாத்³ அவாதி³ஷம்ʼ ஸ மதீ³யாம்ʼ கதா²ம்ʼ க்³ருʼஹீத்வா யுஷ்மாந் போ³த⁴யிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","கியத்காலாத் பரம்ʼ யூயம்ʼ மாம்ʼ த்³ரஷ்டும்ʼ ந லப்ஸ்யத்⁴வே கிந்து கியத்காலாத் பரம்ʼ புந ர்த்³ரஷ்டும்ʼ லப்ஸ்யத்⁴வே யதோஹம்ʼ பிது​: ஸமீபம்ʼ க³ச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","தத​: ஸி²ஷ்யாணாம்ʼ கியந்தோ ஜநா​: பரஸ்பரம்ʼ வதி³தும் ஆரப⁴ந்த, கியத்காலாத் பரம்ʼ மாம்ʼ த்³ரஷ்டும்ʼ ந லப்ஸ்யத்⁴வே கிந்து கியத்காலாத் பரம்ʼ புந ர்த்³ரஷ்டும்ʼ லப்ஸ்யத்⁴வே யதோஹம்ʼ பிது​: ஸமீபம்ʼ க³ச்சா²மி, இதி யத்³ வாக்யம் அயம்ʼ வத³தி தத் கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","தத​: கியத்காலாத் பரம் இதி தஸ்ய வாக்யம்ʼ கிம்ʼ? தஸ்ய வாக்யஸ்யாபி⁴ப்ராயம்ʼ வயம்ʼ போ³த்³து⁴ம்ʼ ந ஸ²க்நுமஸ்தைரிதி ");
INSERT INTO santam_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","நிக³தி³தே யீஸு²ஸ்தேஷாம்ʼ ப்ரஸ்²நேச்சா²ம்ʼ ஜ்ஞாத்வா தேப்⁴யோ(அ)கத²யத் கியத்காலாத் பரம்ʼ மாம்ʼ த்³ரஷ்டும்ʼ ந லப்ஸ்யத்⁴வே, கிந்து கியத்காலாத் பரம்ʼ பூந ர்த்³ரஷ்டும்ʼ லப்ஸ்யத்⁴வே, யாமிமாம்ʼ கதா²மகத²யம்ʼ தஸ்யா அபி⁴ப்ராயம்ʼ கிம்ʼ யூயம்ʼ பரஸ்பரம்ʼ ம்ருʼக³யத்⁴வே? ");
INSERT INTO santam_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","யுஷ்மாநஹம் அதியதா²ர்த²ம்ʼ வதா³மி யூயம்ʼ க்ரந்தி³ஷ்யத² விலபிஷ்யத² ச, கிந்து ஜக³தோ லோகா ஆநந்தி³ஷ்யந்தி; யூயம்ʼ ஸோ²காகுலா ப⁴விஷ்யத² கிந்து ஸோ²காத் பரம்ʼ ஆநந்த³யுக்தா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ப்ரஸவகால உபஸ்தி²தே நாரீ யதா² ப்ரஸவவேத³நயா வ்யாகுலா ப⁴வதி கிந்து புத்ரே பூ⁴மிஷ்டே² ஸதி மநுஷ்யைகோ ஜந்மநா நரலோகே ப்ரவிஷ்ட இத்யாநந்தா³த் தஸ்யாஸ்தத்ஸர்வ்வம்ʼ து³​:க²ம்ʼ மநஸி ந திஷ்ட²தி, ");
INSERT INTO santam_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ததா² யூயமபி ஸாம்ப்ரதம்ʼ ஸோ²காகுலா ப⁴வத² கிந்து புநரபி யுஷ்மப்⁴யம்ʼ த³ர்ஸ²நம்ʼ தா³ஸ்யாமி தேந யுஷ்மாகம் அந்த​:கரணாநி ஸாநந்தா³நி ப⁴விஷ்யந்தி, யுஷ்மாகம்ʼ தம் ஆநந்த³ஞ்ச கோபி ஹர்த்தும்ʼ ந ஸ²க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","தஸ்மிந் தி³வஸே காமபி கதா²ம்ʼ மாம்ʼ ந ப்ரக்ஷ்யத²| யுஷ்மாநஹம் அதியதா²ர்த²ம்ʼ வதா³மி, மம நாம்நா யத் கிஞ்சித்³ பிதரம்ʼ யாசிஷ்யத்⁴வே ததே³வ ஸ தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","பூர்வ்வே மம நாம்நா கிமபி நாயாசத்⁴வம்ʼ, யாசத்⁴வம்ʼ தத​: ப்ராப்ஸ்யத² தஸ்மாத்³ யுஷ்மாகம்ʼ ஸம்பூர்ணாநந்தோ³ ஜநிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","உபமாகதா²பி⁴​: ஸர்வ்வாண்யேதாநி யுஷ்மாந் ஜ்ஞாபிதவாந் கிந்து யஸ்மிந் ஸமயே உபமயா நோக்த்வா பிது​: கதா²ம்ʼ ஸ்பஷ்டம்ʼ ஜ்ஞாபயிஷ்யாமி ஸமய ஏதாத்³ருʼஸ² ஆக³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ததா³ மம நாம்நா ப்ரார்த²யிஷ்யத்⁴வே (அ)ஹம்ʼ யுஷ்மந்நிமித்தம்ʼ பிதரம்ʼ விநேஷ்யே கதா²மிமாம்ʼ ந வதா³மி; ");
INSERT INTO santam_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","யதோ யூயம்ʼ மயி ப்ரேம குருத², ததா²ஹம் ஈஸ்²வரஸ்ய ஸமீபாத்³ ஆக³தவாந் இத்யபி ப்ரதீத², தஸ்மாத்³ காரணாத் காரணாத் பிதா ஸ்வயம்ʼ யுஷ்மாஸு ப்ரீயதே| ");
INSERT INTO santam_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","பிது​: ஸமீபாஜ்ஜஜத்³ ஆக³தோஸ்மி ஜக³த் பரித்யஜ்ய ச புநரபி பிது​: ஸமீபம்ʼ க³ச்சா²மி| ");
INSERT INTO santam_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ததா³ ஸி²ஷ்யா அவத³ந், ஹே ப்ரபோ⁴ ப⁴வாந் உபமயா நோக்த்வாது⁴நா ஸ்பஷ்டம்ʼ வத³தி| ");
INSERT INTO santam_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ப⁴வாந் ஸர்வ்வஜ்ஞ​: கேநசித் ப்ருʼஷ்டோ ப⁴விதுமபி ப⁴வத​: ப்ரயோஜநம்ʼ நாஸ்தீத்யது⁴நாஸ்மாகம்ʼ ஸ்தி²ரஜ்ஞாநம்ʼ ஜாதம்ʼ தஸ்மாத்³ ப⁴வாந் ஈஸ்²வரஸ்ய ஸமீபாத்³ ஆக³தவாந் இத்யத்ர வயம்ʼ விஸ்²வஸிம​:| ");
INSERT INTO santam_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ததோ யீஸு²​: ப்ரத்யவாதீ³த்³ இதா³நீம்ʼ கிம்ʼ யூயம்ʼ விஸ்²வஸித²? ");
INSERT INTO santam_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","பஸ்²யத ஸர்வ்வே யூயம்ʼ விகீர்ணா​: ஸந்தோ மாம் ஏகாகிநம்ʼ பீரத்யஜ்ய ஸ்வம்ʼ ஸ்வம்ʼ ஸ்தா²நம்ʼ க³மிஷ்யத², ஏதாத்³ருʼஸ²​: ஸமய ஆக³ச்ச²தி வரம்ʼ ப்ராயேணோபஸ்தி²தவாந்; ததா²ப்யஹம்ʼ நைகாகீ ப⁴வாமி யத​: பிதா மயா ஸார்த்³த⁴ம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","யதா² மயா யுஷ்மாகம்ʼ ஸா²ந்தி ர்ஜாயதே தத³ர்த²ம் ஏதா​: கதா² யுஷ்மப்⁴யம் அசகத²ம்ʼ; அஸ்மிந் ஜக³தி யுஷ்மாகம்ʼ க்லேஸோ² க⁴டிஷ்யதே கிந்த்வக்ஷோபா⁴ ப⁴வத யதோ மயா ஜக³ஜ்ஜிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","தத​: பரம்ʼ யீஸு²ரேதா​: கதா²​: கத²யித்வா ஸ்வர்க³ம்ʼ விலோக்யைதத் ப்ரார்த²யத், ஹே பித​: ஸமய உபஸ்தி²தவாந்; யதா² தவ புத்ரஸ்தவ மஹிமாநம்ʼ ப்ரகாஸ²யதி தத³ர்த²ம்ʼ த்வம்ʼ நிஜபுத்ரஸ்ய மஹிமாநம்ʼ ப்ரகாஸ²ய| ");
INSERT INTO santam_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","த்வம்ʼ யோல்லோகாந் தஸ்ய ஹஸ்தே ஸமர்பிதவாந் ஸ யதா² தேப்⁴யோ(அ)நந்தாயு ர்த³தா³தி தத³ர்த²ம்ʼ த்வம்ʼ ப்ராணிமாத்ராணாம் அதி⁴பதித்வபா⁴ரம்ʼ தஸ்மை த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","யஸ்த்வம் அத்³விதீய​: ஸத்ய ஈஸ்²வரஸ்த்வயா ப்ரேரிதஸ்²ச யீஸு²​: க்²ரீஷ்ட ஏதயோருப⁴யோ​: பரிசயே ப்ராப்தே(அ)நந்தாயு ர்ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","த்வம்ʼ யஸ்ய கர்ம்மணோ பா⁴ரம்ʼ மஹ்யம்ʼ த³த்தவாந், தத் ஸம்பந்நம்ʼ க்ருʼத்வா ஜக³த்யஸ்மிந் தவ மஹிமாநம்ʼ ப்ராகாஸ²யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","அதஏவ ஹே பித ர்ஜக³த்யவித்³யமாநே த்வயா ஸஹ திஷ்ட²தோ மம யோ மஹிமாஸீத் ஸம்ப்ரதி தவ ஸமீபே மாம்ʼ தம்ʼ மஹிமாநம்ʼ ப்ராபய| ");
INSERT INTO santam_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","அந்யச்ச த்வம் ஏதஜ்ஜக³தோ யால்லோகாந் மஹ்யம் அத³தா³ அஹம்ʼ தேப்⁴யஸ்தவ நாம்நஸ்தத்த்வஜ்ஞாநம் அத³தா³ம்ʼ, தே தவைவாஸந், த்வம்ʼ தாந் மஹ்யமத³தா³​:, தஸ்மாத்தே தவோபதே³ஸ²ம் அக்³ருʼஹ்லந்| ");
INSERT INTO santam_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","த்வம்ʼ மஹ்யம்ʼ யத் கிஞ்சித்³ அத³தா³ஸ்தத்ஸர்வ்வம்ʼ த்வத்தோ ஜாயதே இத்யது⁴நாஜாநந்| ");
INSERT INTO santam_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","மஹ்யம்ʼ யமுபதே³ஸ²ம் அத³தா³ அஹமபி தேப்⁴யஸ்தமுபதே³ஸ²ம் அத³தா³ம்ʼ தேபி தமக்³ருʼஹ்லந் த்வத்தோஹம்ʼ நிர்க³த்ய த்வயா ப்ரேரிதோப⁴வம் அத்ர ச வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","தேஷாமேவ நிமித்தம்ʼ ப்ரார்த²யே(அ)ஹம்ʼ ஜக³தோ லோகநிமித்தம்ʼ ந ப்ரார்த²யே கிந்து யால்லோகாந் மஹ்யம் அத³தா³ஸ்தேஷாமேவ நிமித்தம்ʼ ப்ரார்த²யே(அ)ஹம்ʼ யதஸ்தே தவைவாஸதே| ");
INSERT INTO santam_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","யே மம தே தவ யே ச தவ தே மம ததா² தை ர்மம மஹிமா ப்ரகாஸ்²யதே| ");
INSERT INTO santam_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ஸாம்ப்ரதம் அஸ்மிந் ஜக³தி மமாவஸ்தி²தே​: ஸே²ஷம் அப⁴வத் அஹம்ʼ தவ ஸமீபம்ʼ க³ச்சா²மி கிந்து தே ஜக³தி ஸ்தா²ஸ்யந்தி; ஹே பவித்ர பிதராவயோ ர்யதை²கத்வமாஸ்தே ததா² தேஷாமப்யேகத்வம்ʼ ப⁴வதி தத³ர்த²ம்ʼ யால்லோகாந் மஹ்யம் அத³தா³ஸ்தாந் ஸ்வநாம்நா ரக்ஷ| ");
INSERT INTO santam_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","யாவந்தி தி³நாநி ஜக³த்யஸ்மிந் தை​: ஸஹாஹமாஸம்ʼ தாவந்தி தி³நாநி தாந் தவ நாம்நாஹம்ʼ ரக்ஷிதவாந்; யால்லோகாந் மஹ்யம் அத³தா³ஸ்தாந் ஸர்வ்வாந் அஹமரக்ஷம்ʼ, தேஷாம்ʼ மத்⁴யே கேவலம்ʼ விநாஸ²பாத்ரம்ʼ ஹாரிதம்ʼ தேந த⁴ர்ம்மபுஸ்தகஸ்ய வசநம்ʼ ப்ரத்யக்ஷம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","கிந்த்வது⁴நா தவ ஸந்நிதி⁴ம்ʼ க³ச்சா²மி மயா யதா² தேஷாம்ʼ ஸம்பூர்ணாநந்தோ³ ப⁴வதி தத³ர்த²மஹம்ʼ ஜக³தி திஷ்ட²ந் ஏதா​: கதா² அகத²யம்| ");
INSERT INTO santam_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","தவோபதே³ஸ²ம்ʼ தேப்⁴யோ(அ)த³தா³ம்ʼ ஜக³தா ஸஹ யதா² மம ஸம்ப³ந்தோ⁴ நாஸ்தி ததா² ஜஜதா ஸஹ தேஷாமபி ஸம்ப³ந்தா⁴பா⁴வாஜ் ஜக³தோ லோகாஸ்தாந் ருʼதீயந்தே| ");
INSERT INTO santam_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","த்வம்ʼ ஜக³தஸ்தாந் க்³ருʼஹாணேதி ந ப்ரார்த²யே கிந்த்வஸு²பா⁴த்³ ரக்ஷேதி ப்ரார்த²யேஹம்| ");
INSERT INTO santam_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","அஹம்ʼ யதா² ஜக³த்ஸம்ப³ந்தீ⁴யோ ந ப⁴வாமி ததா² தேபி ஜக³த்ஸம்ப³ந்தீ⁴யா ந ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","தவ ஸத்யகத²யா தாந் பவித்ரீகுரு தவ வாக்யமேவ ஸத்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","த்வம்ʼ யதா² மாம்ʼ ஜக³தி ப்ரைரயஸ்ததா²ஹமபி தாந் ஜக³தி ப்ரைரயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","தேஷாம்ʼ ஹிதார்த²ம்ʼ யதா²ஹம்ʼ ஸ்வம்ʼ பவித்ரீகரோமி ததா² ஸத்யகத²யா தேபி பவித்ரீப⁴வந்து| ");
INSERT INTO santam_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","கேவலம்ʼ ஏதேஷாமர்தே² ப்ரார்த²யே(அ)ஹம் இதி ந கிந்த்வேதேஷாமுபதே³ஸே²ந யே ஜநா மயி விஸ்²வஸிஷ்யந்தி தேஷாமப்யர்தே² ப்ரார்தே²யே(அ)ஹம்| ");
INSERT INTO santam_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ஹே பிதஸ்தேஷாம்ʼ ஸர்வ்வேஷாம் ஏகத்வம்ʼ ப⁴வது தவ யதா² மயி மம ச யதா² த்வய்யேகத்வம்ʼ ததா² தேஷாமப்யாவயோரேகத்வம்ʼ ப⁴வது தேந த்வம்ʼ மாம்ʼ ப்ரேரிதவாந் இதி ஜக³தோ லோகா​: ப்ரதியந்து| ");
INSERT INTO santam_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","யதா²வயோரேகத்வம்ʼ ததா² தேஷாமப்யேகத்வம்ʼ ப⁴வது தேஷ்வஹம்ʼ மயி ச த்வம் இத்த²ம்ʼ தேஷாம்ʼ ஸம்பூர்ணமேகத்வம்ʼ ப⁴வது, த்வம்ʼ ப்ரேரிதவாந் த்வம்ʼ மயி யதா² ப்ரீயஸே ச ததா² தேஷ்வபி ப்ரீதவாந் ஏதத்³யதா² ஜக³தோ லோகா ஜாநந்தி ");
INSERT INTO santam_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","தத³ர்த²ம்ʼ த்வம்ʼ யம்ʼ மஹிமாநம்ʼ மஹ்யம் அத³தா³ஸ்தம்ʼ மஹிமாநம் அஹமபி தேப்⁴யோ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ஹே பித ர்ஜக³தோ நிர்ம்மாணாத் பூர்வ்வம்ʼ மயி ஸ்நேஹம்ʼ க்ருʼத்வா யம்ʼ மஹிமாநம்ʼ த³த்தவாந் மம தம்ʼ மஹிமாநம்ʼ யதா² தே பஸ்²யந்தி தத³ர்த²ம்ʼ யால்லோகாந் மஹ்யம்ʼ த³த்தவாந் அஹம்ʼ யத்ர திஷ்டா²மி தேபி யதா² தத்ர திஷ்ட²ந்தி மமைஷா வாஞ்சா²| ");
INSERT INTO santam_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ஹே யதா²ர்தி²க பித ர்ஜக³தோ லோகைஸ்த்வய்யஜ்ஞாதேபி த்வாமஹம்ʼ ஜாநே த்வம்ʼ மாம்ʼ ப்ரேரிதவாந் இதீமே ஸி²ஷ்யா ஜாநந்தி| ");
INSERT INTO santam_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","யதா²ஹம்ʼ தேஷு திஷ்டா²மி ததா² மயி யேந ப்ரேம்நா ப்ரேமாகரோஸ்தத் தேஷு திஷ்ட²தி தத³ர்த²ம்ʼ தவ நாமாஹம்ʼ தாந் ஜ்ஞாபிதவாந் புநரபி ஜ்ஞாபயிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","தா​: கதா²​: கத²யித்வா யீஸு²​: ஸி²ஷ்யாநாதா³ய கித்³ரோந்நாமகம்ʼ ஸ்ரோத உத்தீர்ய்ய ஸி²ஷ்யை​: ஸஹ தத்ரத்யோத்³யாநம்ʼ ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","கிந்து விஸ்²வாஸகா⁴தியிஹூதா³ஸ்தத் ஸ்தா²நம்ʼ பரிசீயதே யதோ யீஸு²​: ஸி²ஷ்யை​: ஸார்த்³த⁴ம்ʼ கதா³சித் தத் ஸ்தா²நம் அக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ததா³ ஸ யிஹூதா³​: ஸைந்யக³ணம்ʼ ப்ரதா⁴நயாஜகாநாம்ʼ பி²ரூஸி²நாஞ்ச பதா³திக³ணஞ்ச க்³ருʼஹீத்வா ப்ரதீ³பாந் உல்காந் அஸ்த்ராணி சாதா³ய தஸ்மிந் ஸ்தா²ந உபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ஸ்வம்ʼ ப்ரதி யத்³ க⁴டிஷ்யதே தஜ் ஜ்ஞாத்வா யீஸு²ரக்³ரேஸர​: ஸந் தாநப்ருʼச்ச²த் கம்ʼ க³வேஷயத²? ");
INSERT INTO santam_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","தே ப்ரத்யவத³ந், நாஸரதீயம்ʼ யீஸு²ம்ʼ; ததோ யீஸு²ரவாதீ³த்³ அஹமேவ ஸ​:; தை​: ஸஹ விஸ்²வாஸகா⁴தீ யிஹூதா³ஸ்²சாதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ததா³ஹமேவ ஸ தஸ்யைதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வைவ தே பஸ்²சாதே³த்ய பூ⁴மௌ பதிதா​:| ");
INSERT INTO santam_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ததோ யீஸு²​: புநரபி ப்ருʼஷ்ட²வாந் கம்ʼ க³வேஷயத²? ததஸ்தே ப்ரத்யவத³ந் நாஸரதீயம்ʼ யீஸு²ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ததா³ யீஸு²​: ப்ரத்யுதி³தவாந் அஹமேவ ஸ இமாம்ʼ கதா²மசகத²ம்; யதி³ மாமந்விச்ச²த² தர்ஹீமாந் க³ந்தும்ʼ மா வாரயத| ");
INSERT INTO santam_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","இத்த²ம்ʼ பூ⁴தே மஹ்யம்ʼ யால்லோகாந் அத³தா³ஸ்தேஷாம் ஏகமபி நாஹாரயம் இமாம்ʼ யாம்ʼ கதா²ம்ʼ ஸ ஸ்வயமகத²யத் ஸா கதா² ஸப²லா ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ததா³ ஸி²மோந்பிதரஸ்ய நிகடே க²ங்க³ல்ஸ்தி²தே​: ஸ தம்ʼ நிஷ்கோஷம்ʼ க்ருʼத்வா மஹாயாஜகஸ்ய மால்க²நாமாநம்ʼ தா³ஸம் ஆஹத்ய தஸ்ய த³க்ஷிணகர்ணம்ʼ சி²ந்நவாந்| ");
INSERT INTO santam_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ததோ யீஸு²​: பிதரம் அவத³த், க²ங்க³ம்ʼ கோஷே ஸ்தா²பய மம பிதா மஹ்யம்ʼ பாதும்ʼ யம்ʼ கம்ʼஸம் அத³தா³த் தேநாஹம்ʼ கிம்ʼ ந பாஸ்யாமி? ");
INSERT INTO santam_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ததா³ ஸைந்யக³ண​: ஸேநாபதி ர்யிஹூதீ³யாநாம்ʼ பதா³தயஸ்²ச யீஸு²ம்ʼ க்⁴ருʼத்வா ப³த்³த்⁴வா ஹாநந்நாம்ந​: கியபா²​: ஸ்²வஸு²ரஸ்ய ஸமீபம்ʼ ப்ரத²மம் அநயந்| ");
INSERT INTO santam_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ஸ கியபா²ஸ்தஸ்மிந் வத்ஸரே மஹாயாஜத்வபதே³ நியுக்த​: ");
INSERT INTO santam_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ஸந் ஸாதா⁴ரணலோகாநாம்ʼ மங்க³லார்த²ம் ஏகஜநஸ்ய மரணமுசிதம் இதி யிஹூதீ³யை​: ஸார்த்³த⁴ம் அமந்த்ரயத்| ");
INSERT INTO santam_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ததா³ ஸி²மோந்பிதரோ(அ)ந்யைகஸி²ஷ்யஸ்²ச யீஸோ²​: பஸ்²சாத்³ அக³ச்ச²தாம்ʼ தஸ்யாந்யஸி²ஷ்யஸ்ய மஹாயாஜகேந பரிசிதத்வாத் ஸ யீஸு²நா ஸஹ மஹாயாஜகஸ்யாட்டாலிகாம்ʼ ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","கிந்து பிதரோ ப³ஹிர்த்³வாரஸ்ய ஸமீபே(அ)திஷ்ட²த்³ அதஏவ மஹாயாஜகேந பரிசித​: ஸ ஸி²ஷ்ய​: புநர்ப³ஹிர்க³த்வா தௌ³வாயிகாயை கத²யித்வா பிதரம் அப்⁴யந்தரம் ஆநயத்| ");
INSERT INTO santam_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ததா³ ஸ த்³வாரரக்ஷிகா பிதரம் அவத³த் த்வம்ʼ கிம்ʼ ந தஸ்ய மாநவஸ்ய ஸி²ஷ்ய​:? தத​: ஸோவத³த்³ அஹம்ʼ ந ப⁴வாமி| ");
INSERT INTO santam_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","தத​: பரம்ʼ யத்ஸ்தா²நே தா³ஸா​: பதா³தயஸ்²ச ஸீ²தஹேதோரங்கா³ரை ர்வஹ்நிம்ʼ ப்ரஜ்வால்ய தாபம்ʼ ஸேவிதவந்தஸ்தத்ஸ்தா²நே பிதரஸ்திஷ்ட²ந் தை​: ஸஹ வஹ்நிதாபம்ʼ ஸேவிதும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ததா³ ஸி²ஷ்யேஷூபதே³ஸே² ச மஹாயாஜகேந யீஸு²​: ப்ருʼஷ்ட​: ");
INSERT INTO santam_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ஸந் ப்ரத்யுக்தவாந் ஸர்வ்வலோகாநாம்ʼ ஸமக்ஷம்ʼ கதா²மகத²யம்ʼ கு³ப்தம்ʼ காமபி கதா²ம்ʼ ந கத²யித்வா யத் ஸ்தா²நம்ʼ யிஹூதீ³யா​: ஸததம்ʼ க³ச்ச²ந்தி தத்ர ப⁴ஜநகே³ஹே மந்தி³ரே சாஸி²க்ஷயம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","மத்த​: குத​: ப்ருʼச்ச²ஸி? யே ஜநா மது³பதே³ஸ²ம் அஸ்²ருʼண்வந் தாநேவ ப்ருʼச்ச² யத்³யத்³ அவத³ம்ʼ தே தத் ஜாநிந்த| ");
INSERT INTO santam_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ததே³த்த²ம்ʼ ப்ரத்யுதி³தத்வாத் நிகடஸ்த²பதா³தி ர்யீஸு²ம்ʼ சபேடேநாஹத்ய வ்யாஹரத் மஹாயாஜகம் ஏவம்ʼ ப்ரதிவத³ஸி? ");
INSERT INTO santam_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ததோ யீஸு²​: ப்ரதிக³தி³தவாந் யத்³யயதா²ர்த²ம் அசகத²ம்ʼ தர்ஹி தஸ்யாயதா²ர்த²ஸ்ய ப்ரமாணம்ʼ தே³ஹி, கிந்து யதி³ யதா²ர்த²ம்ʼ தர்ஹி குதோ ஹேதோ ர்மாம் அதாட³ய​:? ");
INSERT INTO santam_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","பூர்வ்வம்ʼ ஹாநந் ஸப³ந்த⁴நம்ʼ தம்ʼ கியபா²மஹாயாஜகஸ்ய ஸமீபம்ʼ ப்ரைஷயத்| ");
INSERT INTO santam_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ஸி²மோந்பிதரஸ்திஷ்ட²ந் வஹ்நிதாபம்ʼ ஸேவதே, ஏதஸ்மிந் ஸமயே கியந்தஸ்தம் அப்ருʼச்ச²ந் த்வம்ʼ கிம் ஏதஸ்ய ஜநஸ்ய ஸி²ஷ்யோ ந? தத​: ஸோபஹ்நுத்யாப்³ரவீத்³ அஹம்ʼ ந ப⁴வாமி| ");
INSERT INTO santam_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ததா³ மஹாயாஜகஸ்ய யஸ்ய தா³ஸஸ்ய பிதர​: கர்ணமச்சி²நத் தஸ்ய குடும்ப³​: ப்ரத்யுதி³தவாந் உத்³யாநே தேந ஸஹ திஷ்ட²ந்தம்ʼ த்வாம்ʼ கிம்ʼ நாபஸ்²யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","கிந்து பிதர​: புநரபஹ்நுத்ய கதி²தவாந்; ததா³நீம்ʼ குக்குடோ(அ)ரௌத்| ");
INSERT INTO santam_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","தத³நந்தரம்ʼ ப்ரத்யூஷே தே கியபா²க்³ருʼஹாத்³ அதி⁴பதே ர்க்³ருʼஹம்ʼ யீஸு²ம் அநயந் கிந்து யஸ்மிந் அஸு²சித்வே ஜாதே தை ர்நிஸ்தாரோத்ஸவே ந போ⁴க்தவ்யம்ʼ, தஸ்ய ப⁴யாத்³ யிஹூதீ³யாஸ்தத்³க்³ருʼஹம்ʼ நாவிஸ²ந்| ");
INSERT INTO santam_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","அபரம்ʼ பீலாதோ ப³ஹிராக³த்ய தாந் ப்ருʼஷ்ட²வாந் ஏதஸ்ய மநுஷ்யஸ்ய கம்ʼ தோ³ஷம்ʼ வத³த²? ");
INSERT INTO santam_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ததா³ தே பேத்யவத³ந் து³ஷ்கர்ம்மகாரிணி ந ஸதி ப⁴வத​: ஸமீபே நைநம்ʼ ஸமார்பயிஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","தத​: பீலாதோ(அ)வத³த்³ யூயமேநம்ʼ க்³ருʼஹீத்வா ஸ்வேஷாம்ʼ வ்யவஸ்த²யா விசாரயத| ததா³ யிஹூதீ³யா​: ப்ரத்யவத³ந் கஸ்யாபி மநுஷ்யஸ்ய ப்ராணத³ண்ட³ம்ʼ கர்த்தும்ʼ நாஸ்மாகம் அதி⁴காரோ(அ)ஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ஏவம்ʼ ஸதி யீஸு²​: ஸ்வஸ்ய ம்ருʼத்யௌ யாம்ʼ கதா²ம்ʼ கதி²தவாந் ஸா ஸப²லாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","தத³நந்தரம்ʼ பீலாத​: புநரபி தத்³ ராஜக்³ருʼஹம்ʼ க³த்வா யீஸு²மாஹூய ப்ருʼஷ்டவாந் த்வம்ʼ கிம்ʼ யிஹூதீ³யாநாம்ʼ ராஜா? ");
INSERT INTO santam_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","யீஸு²​: ப்ரத்யவத³த் த்வம் ஏதாம்ʼ கதா²ம்ʼ ஸ்வத​: கத²யஸி கிமந்ய​: கஸ்²சிந் மயி கதி²தவாந்? ");
INSERT INTO santam_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","பீலாதோ(அ)வத³த்³ அஹம்ʼ கிம்ʼ யிஹூதீ³ய​:? தவ ஸ்வதே³ஸீ²யா விஸே²ஷத​: ப்ரதா⁴நயாஜகா மம நிகடே த்வாம்ʼ ஸமார்பயந, த்வம்ʼ கிம்ʼ க்ருʼதவாந்? ");
INSERT INTO santam_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","யீஸு²​: ப்ரத்யவத³த் மம ராஜ்யம் ஏதஜ்ஜக³த்ஸம்ப³ந்தீ⁴யம்ʼ ந ப⁴வதி யதி³ மம ராஜ்யம்ʼ ஜக³த்ஸம்ப³ந்தீ⁴யம் அப⁴விஷ்யத் தர்ஹி யிஹூதீ³யாநாம்ʼ ஹஸ்தேஷு யதா² ஸமர்பிதோ நாப⁴வம்ʼ தத³ர்த²ம்ʼ மம ஸேவகா அயோத்ஸ்யந் கிந்து மம ராஜ்யம் ஐஹிகம்ʼ ந| ");
INSERT INTO santam_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ததா³ பீலாத​: கதி²தவாந், தர்ஹி த்வம்ʼ ராஜா ப⁴வஸி? யீஸு²​: ப்ரத்யுக்தவாந் த்வம்ʼ ஸத்யம்ʼ கத²யஸி, ராஜாஹம்ʼ ப⁴வாமி; ஸத்யதாயாம்ʼ ஸாக்ஷ்யம்ʼ தா³தும்ʼ ஜநிம்ʼ க்³ருʼஹீத்வா ஜக³த்யஸ்மிந் அவதீர்ணவாந், தஸ்மாத் ஸத்யத⁴ர்ம்மபக்ஷபாதிநோ மம கதா²ம்ʼ ஸ்²ருʼண்வந்தி| ");
INSERT INTO santam_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ததா³ ஸத்யம்ʼ கிம்ʼ? ஏதாம்ʼ கதா²ம்ʼ பஷ்ட்வா பீலாத​: புநரபி ப³ஹிர்க³த்வா யிஹூதீ³யாந் அபா⁴ஷத, அஹம்ʼ தஸ்ய கமப்யபராத⁴ம்ʼ ந ப்ராப்நோமி| ");
INSERT INTO santam_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","நிஸ்தாரோத்ஸவஸமயே யுஷ்மாபி⁴ரபி⁴ருசித ஏகோ ஜநோ மயா மோசயிதவ்ய ஏஷா யுஷ்மாகம்ʼ ரீதிரஸ்தி, அதஏவ யுஷ்மாகம்ʼ நிகடே யிஹூதீ³யாநாம்ʼ ராஜாநம்ʼ கிம்ʼ மோசயாமி, யுஷ்மாகம் இச்சா² கா? ");
INSERT INTO santam_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ததா³ தே ஸர்வ்வே ருவந்தோ வ்யாஹரந் ஏநம்ʼ மாநுஷம்ʼ நஹி ப³ரப்³பா³ம்ʼ மோசய| கிந்து ஸ ப³ரப்³பா³ த³ஸ்யுராஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","பீலாதோ யீஸு²ம் ஆநீய கஸ²யா ப்ராஹாரயத்| ");
INSERT INTO santam_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","பஸ்²சாத் ஸேநாக³ண​: கண்டகநிர்ம்மிதம்ʼ முகுடம்ʼ தஸ்ய மஸ்தகே ஸமர்ப்ய வார்த்தாகீவர்ணம்ʼ ராஜபரிச்ச²த³ம்ʼ பரிதா⁴ப்ய, ");
INSERT INTO santam_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ஹே யிஹூதீ³யாநாம்ʼ ராஜந் நமஸ்கார இத்யுக்த்வா தம்ʼ சபேடேநாஹந்தும் ஆரப⁴த| ");
INSERT INTO santam_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ததா³ பீலாத​: புநரபி ப³ஹிர்க³த்வா லோகாந் அவத³த், அஸ்ய கமப்யபராத⁴ம்ʼ ந லபே⁴(அ)ஹம்ʼ, பஸ்²யத தத்³ யுஷ்மாந் ஜ்ஞாபயிதும்ʼ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ப³ஹிரேநம் ஆநயாமி| ");
INSERT INTO santam_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","தத​: பரம்ʼ யீஸு²​: கண்டகமுகுடவாந் வார்த்தாகீவர்ணவஸநவாம்ʼஸ்²ச ப³ஹிராக³ச்ச²த்| தத​: பீலாத உக்தவாந் ஏநம்ʼ மநுஷ்யம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ததா³ ப்ரதா⁴நயாஜகா​: பதா³தயஸ்²ச தம்ʼ த்³ருʼஷ்ட்வா, ஏநம்ʼ க்ருஸே² வித⁴, ஏநம்ʼ க்ருஸே² வித⁴, இத்யுக்த்வா ரவிதும்ʼ ஆரப⁴ந்த| தத​: பீலாத​: கதி²தவாந் யூயம்ʼ ஸ்வயம் ஏநம்ʼ நீத்வா க்ருஸே² வித⁴த, அஹம் ஏதஸ்ய கமப்யபராத⁴ம்ʼ ந ப்ராப்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","யிஹூதீ³யா​: ப்ரத்யவத³ந் அஸ்மாகம்ʼ யா வ்யவஸ்தா²ஸ்தே தத³நுஸாரேணாஸ்ய ப்ராணஹநநம் உசிதம்ʼ யதோயம்ʼ ஸ்வம் ஈஸ்²வரஸ்ய புத்ரமவத³த்| ");
INSERT INTO santam_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","பீலாத இமாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா மஹாத்ராஸயுக்த​: ");
INSERT INTO santam_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ஸந் புநரபி ராஜக்³ருʼஹ ஆக³த்ய யீஸு²ம்ʼ ப்ருʼஷ்டவாந் த்வம்ʼ குத்ரத்யோ லோக​:? கிந்து யீஸ²ஸ்தஸ்ய கிமபி ப்ரத்யுத்தரம்ʼ நாவத³த்| ");
INSERT INTO santam_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1॰ தத​: பீலாத் கதி²தவாந த்வம்ʼ கிம்ʼ மயா ஸார்த்³த⁴ம்ʼ ந ஸம்ʼலபிஷ்யஸி ? த்வாம்ʼ க்ருஸே² வேதி⁴தும்ʼ வா மோசயிதும்ʼ ஸ²க்தி ர்மமாஸ்தே இதி கிம்ʼ த்வம்ʼ ந ஜாநாஸி ? ததா³ யீஸு²​: ப்ரத்யவத³த்³ ஈஸ்²வரேணாத³Ÿाம்ʼ மமோபரி தவ கிமப்யதி⁴பதித்வம்ʼ ந வித்³யதே, ததா²பி யோ ஜநோ மாம்ʼ தவ ஹஸ்தே ஸமார்பயத் தஸ்ய மஹாபாதகம்ʼ ஜாதம்| ");
INSERT INTO santam_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ததா³ யீஸு²​: ப்ரத்யவத³த்³ ஈஸ்²வரேணாத³த்தம்ʼ மமோபரி தவ கிமப்யதி⁴பதித்வம்ʼ ந வித்³யதே, ததா²பி யோ ஜநோ மாம்ʼ தவ ஹஸ்தே ஸமார்பயத் தஸ்ய மஹாபாதகம்ʼ ஜாதம்| ");
INSERT INTO santam_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ததா³ரப்⁴ய பீலாதஸ்தம்ʼ மோசயிதும்ʼ சேஷ்டிதவாந் கிந்து யிஹூதீ³யா ருவந்தோ வ்யாஹரந் யதீ³மம்ʼ மாநவம்ʼ த்யஜஸி தர்ஹி த்வம்ʼ கைஸரஸ்ய மித்ரம்ʼ ந ப⁴வஸி, யோ ஜந​: ஸ்வம்ʼ ராஜாநம்ʼ வக்தி ஸஏவ கைமரஸ்ய விருத்³தா⁴ம்ʼ கதா²ம்ʼ கத²யதி| ");
INSERT INTO santam_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா பீலாதோ யீஸு²ம்ʼ ப³ஹிராநீய நிஸ்தாரோத்ஸவஸ்ய ஆஸாத³நதி³நஸ்ய த்³விதீயப்ரஹராத் பூர்வ்வம்ʼ ப்ரஸ்தரப³ந்த⁴நநாம்நி ஸ்தா²நே (அ)ர்தா²த் இப்³ரீயபா⁴ஷயா யத்³ க³ப்³பி³தா² கத்²யதே தஸ்மிந் ஸ்தா²நே விசாராஸந உபாவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","அநந்தரம்ʼ பீலாதோ யிஹூதீ³யாந் அவத³த், யுஷ்மாகம்ʼ ராஜாநம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","கிந்து ஏநம்ʼ தூ³ரீகுரு, ஏநம்ʼ தூ³ரீகுரு, ஏநம்ʼ க்ருஸே² வித⁴, இதி கதா²ம்ʼ கத²யித்வா தே ரவிதும் ஆரப⁴ந்த; ததா³ பீலாத​: கதி²தவாந் யுஷ்மாகம்ʼ ராஜாநம்ʼ கிம்ʼ க்ருஸே² வேதி⁴ஷ்யாமி? ப்ரதா⁴நயாஜகா உத்தரம் அவத³ந் கைஸரம்ʼ விநா கோபி ராஜாஸ்மாகம்ʼ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","தத​: பீலாதோ யீஸு²ம்ʼ க்ருஸே² வேதி⁴தும்ʼ தேஷாம்ʼ ஹஸ்தேஷு ஸமார்பயத், ததஸ்தே தம்ʼ த்⁴ருʼத்வா நீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","தத​: பரம்ʼ யீஸு²​: க்ருஸ²ம்ʼ வஹந் ஸி²ர​:கபாலம் அர்தா²த்³ யத்³ இப்³ரீயபா⁴ஷயா கு³ல்க³ல்தாம்ʼ வத³ந்தி தஸ்மிந் ஸ்தா²ந உபஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ததஸ்தே மத்⁴யஸ்தா²நே தம்ʼ தஸ்யோப⁴யபார்ஸ்²வே த்³வாவபரௌ க்ருஸே²(அ)வித⁴ந்| ");
INSERT INTO santam_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","அபரம் ஏஷ யிஹூதீ³யாநாம்ʼ ராஜா நாஸரதீயயீஸு²​:, இதி விஜ்ஞாபநம்ʼ லிகி²த்வா பீலாதஸ்தஸ்ய க்ருஸோ²பரி ஸமயோஜயத்| ");
INSERT INTO santam_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ஸா லிபி​: இப்³ரீயயூநாநீயரோமீயபா⁴ஷாபி⁴ ர்லிகி²தா; யீஸோ²​: க்ருஸ²வேத⁴நஸ்தா²நம்ʼ நக³ரஸ்ய ஸமீபம்ʼ, தஸ்மாத்³ ப³ஹவோ யிஹூதீ³யாஸ்தாம்ʼ படி²தும் ஆரப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","யிஹூதீ³யாநாம்ʼ ப்ரதா⁴நயாஜகா​: பீலாதமிதி ந்யவேத³யந் யிஹூதீ³யாநாம்ʼ ராஜேதி வாக்யம்ʼ ந கிந்து ஏஷ ஸ்வம்ʼ யிஹூதீ³யாநாம்ʼ ராஜாநம் அவத³த்³ இத்த²ம்ʼ லிக²து| ");
INSERT INTO santam_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","தத​: பீலாத உத்தரம்ʼ த³த்தவாந் யல்லேக²நீயம்ʼ தல்லிகி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","இத்த²ம்ʼ ஸேநாக³ணோ யீஸு²ம்ʼ க்ருஸே² விதி⁴த்வா தஸ்ய பரிதே⁴யவஸ்த்ரம்ʼ சதுரோ பா⁴கா³ந் க்ருʼத்வா ஏகைகஸேநா ஏகைகபா⁴க³ம் அக்³ருʼஹ்லத் தஸ்யோத்தரீயவஸ்த்ரஞ்சாக்³ருʼஹ்லத்| கிந்தூத்தரீயவஸ்த்ரம்ʼ ஸூசிஸேவநம்ʼ விநா ஸர்வ்வம் ஊதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","தஸ்மாத்தே வ்யாஹரந் ஏதத் க​: ப்ராப்ஸ்யதி? தந்ந க²ண்ட³யித்வா தத்ர கு³டிகாபாதம்ʼ கரவாம| விப⁴ஜந்தே(அ)த⁴ரீயம்ʼ மே வஸநம்ʼ தே பரஸ்பரம்ʼ| மமோத்தரீயவஸ்த்ரார்த²ம்ʼ கு³டிகாம்ʼ பாதயந்தி ச| இதி யத்³வாக்யம்ʼ த⁴ர்ம்மபுஸ்தகே லிகி²தமாஸ்தே தத் ஸேநாக³ணேநேத்த²ம்ʼ வ்யவஹரணாத் ஸித்³த⁴மப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ததா³நீம்ʼ யீஸோ² ர்மாதா மாது ர்ப⁴கி³நீ ச யா க்லியபா பா⁴ர்ய்யா மரியம் மக்³த³லீநீ மரியம் ச ஏதாஸ்தஸ்ய க்ருஸ²ஸ்ய ஸந்நிதௌ⁴ ஸமதிஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ததோ யீஸு²​: ஸ்வமாதரம்ʼ ப்ரியதமஸி²ஷ்யஞ்ச ஸமீபே த³ண்டா³யமாநௌ விலோக்ய மாதரம் அவத³த், ஹே யோஷித்³ ஏநம்ʼ தவ புத்ரம்ʼ பஸ்²ய, ");
INSERT INTO santam_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ஸி²ஷ்யந்த்வவத³த், ஏநாம்ʼ தவ மாதரம்ʼ பஸ்²ய| தத​: ஸ ஸி²ஷ்யஸ்தத்³க⁴டிகாயாம்ʼ தாம்ʼ நிஜக்³ருʼஹம்ʼ நீதவாந்| ");
INSERT INTO santam_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","அநந்தரம்ʼ ஸர்வ்வம்ʼ கர்ம்மாது⁴நா ஸம்பந்நமபூ⁴த் யீஸு²ரிதி ஜ்ஞாத்வா த⁴ர்ம்மபுஸ்தகஸ்ய வசநம்ʼ யதா² ஸித்³த⁴ம்ʼ ப⁴வதி தத³ர்த²ம் அகத²யத் மம பிபாஸா ஜாதா| ");
INSERT INTO santam_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ததஸ்தஸ்மிந் ஸ்தா²நே அம்லரஸேந பூர்ணபாத்ரஸ்தி²த்யா தே ஸ்பஞ்ஜமேகம்ʼ தத³ம்லரஸேநார்த்³ரீக்ருʼத்ய ஏஸோப்³நலே தத்³ யோஜயித்வா தஸ்ய முக²ஸ்ய ஸந்நிதா⁴வஸ்தா²பயந்| ");
INSERT INTO santam_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ததா³ யீஸு²ரம்லரஸம்ʼ க்³ருʼஹீத்வா ஸர்வ்வம்ʼ ஸித்³த⁴ம் இதி கதா²ம்ʼ கத²யித்வா மஸ்தகம்ʼ நமயந் ப்ராணாந் பர்ய்யத்யஜத்| ");
INSERT INTO santam_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","தத்³விநம் ஆஸாத³நதி³நம்ʼ தஸ்மாத் பரே(அ)ஹநி விஸ்²ராமவாரே தே³ஹா யதா² க்ருஸோ²பரி ந திஷ்ட²ந்தி, யத​: ஸ விஸ்²ராமவாரோ மஹாதி³நமாஸீத், தஸ்மாத்³ யிஹூதீ³யா​: பீலாதநிகடம்ʼ க³த்வா தேஷாம்ʼ பாத³ப⁴ஞ்ஜநஸ்ய ஸ்தா²நாந்தரநயநஸ்ய சாநுமதிம்ʼ ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","அத​: ஸேநா ஆக³த்ய யீஸு²நா ஸஹ க்ருஸே² ஹதயோ​: ப்ரத²மத்³விதீயசோரயோ​: பாதா³ந் அப⁴ஞ்ஜந்; ");
INSERT INTO santam_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","கிந்து யீஸோ²​: ஸந்நிதி⁴ம்ʼ க³த்வா ஸ ம்ருʼத இதி த்³ருʼஷ்ட்வா தஸ்ய பாதௌ³ நாப⁴ஞ்ஜந்| ");
INSERT INTO santam_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","பஸ்²சாத்³ ஏகோ யோத்³தா⁴ ஸூ²லாகா⁴தேந தஸ்ய குக்ஷிம் அவித⁴த் தத்க்ஷணாத் தஸ்மாத்³ ரக்தம்ʼ ஜலஞ்ச நிரக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","யோ ஜநோ(அ)ஸ்ய ஸாக்ஷ்யம்ʼ த³தா³தி ஸ ஸ்வயம்ʼ த்³ருʼஷ்டவாந் தஸ்யேத³ம்ʼ ஸாக்ஷ்யம்ʼ ஸத்யம்ʼ தஸ்ய கதா² யுஷ்மாகம்ʼ விஸ்²வாஸம்ʼ ஜநயிதும்ʼ யோக்³யா தத் ஸ ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","தஸ்யைகம் அஸ்த்⁴யபி ந ப⁴ம்ʼக்ஷ்யதே, ");
INSERT INTO santam_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","தத்³வத்³ அந்யஸா²ஸ்த்ரேபி லிக்²யதே, யதா², \"த்³ருʼஷ்டிபாதம்ʼ கரிஷ்யந்தி தே(அ)வித⁴ந் யந்து தம்ப்ரதி| \" ");
INSERT INTO santam_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","அரிமதீ²யநக³ரஸ்ய யூஷப்²நாமா ஸி²ஷ்ய ஏக ஆஸீத் கிந்து யிஹூதீ³யேப்⁴யோ ப⁴யாத் ப்ரகாஸி²தோ ந ப⁴வதி; ஸ யீஸோ² ர்தே³ஹம்ʼ நேதும்ʼ பீலாதஸ்யாநுமதிம்ʼ ப்ரார்த²யத, தத​: பீலாதேநாநுமதே ஸதி ஸ க³த்வா யீஸோ² ர்தே³ஹம் அநயத்| ");
INSERT INTO santam_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","அபரம்ʼ யோ நிகதீ³மோ ராத்ரௌ யீஸோ²​: ஸமீபம் அக³ச்ச²த் ஸோபி க³ந்த⁴ரஸேந மிஸ்²ரிதம்ʼ ப்ராயேண பஞ்சாஸ²த்ஸேடகமகு³ரும்ʼ க்³ருʼஹீத்வாக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ததஸ்தே யிஹூதீ³யாநாம்ʼ ஸ்²மஸா²நே ஸ்தா²பநரீத்யநுஸாரேண தத்ஸுக³ந்தி⁴த்³ரவ்யேண ஸஹிதம்ʼ தஸ்ய தே³ஹம்ʼ வஸ்த்ரேணாவேஷ்டயந்| ");
INSERT INTO santam_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","அபரஞ்ச யத்ர ஸ்தா²நே தம்ʼ க்ருஸே²(அ)வித⁴ந் தஸ்ய நிகடஸ்தோ²த்³யாநே யத்ர கிமபி ம்ருʼததே³ஹம்ʼ கதா³பி நாஸ்தா²ப்யத தாத்³ருʼஸ²ம் ஏகம்ʼ நூதநம்ʼ ஸ்²மஸா²நம் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","யிஹூதீ³யாநாம் ஆஸாத³நதி³நாக³மநாத் தே தஸ்மிந் ஸமீபஸ்த²ஸ்²மஸா²நே யீஸு²ம் அஸா²யயந்| ");
INSERT INTO santam_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","அநந்தரம்ʼ ஸப்தாஹஸ்ய ப்ரத²மதி³நே (அ)திப்ரத்யூஷே (அ)ந்த⁴காரே திஷ்ட²தி மக்³த³லீநீ மரியம் தஸ்ய ஸ்²மஸா²நஸ்ய நிகடம்ʼ க³த்வா ஸ்²மஸா²நஸ்ய முகா²த் ப்ரஸ்தரமபஸாரிதம் அபஸ்²யத்| ");
INSERT INTO santam_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","பஸ்²சாத்³ தா⁴வித்வா ஸி²மோந்பிதராய யீஸோ²​: ப்ரியதமஸி²ஷ்யாய சேத³ம் அகத²யத், லோகா​: ஸ்²மஸா²நாத் ப்ரபு⁴ம்ʼ நீத்வா குத்ராஸ்தா²பயந் தத்³ வக்தும்ʼ ந ஸ²க்நோமி| ");
INSERT INTO santam_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","அத​: பிதர​: ஸோந்யஸி²ஷ்யஸ்²ச ப³ர்ஹி ர்பு⁴த்வா ஸ்²மஸா²நஸ்தா²நம்ʼ க³ந்தும் ஆரபே⁴தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","உப⁴யோர்தா⁴வதோ​: ஸோந்யஸி²ஷ்ய​: பிதரம்ʼ பஸ்²சாத் த்யக்த்வா பூர்வ்வம்ʼ ஸ்²மஸா²நஸ்தா²ந உபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ததா³ ப்ரஹ்வீபூ⁴ய ஸ்தா²பிதவஸ்த்ராணி த்³ருʼஷ்டவாந் கிந்து ந ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","அபரம்ʼ ஸி²மோந்பிதர ஆக³த்ய ஸ்²மஸா²நஸ்தா²நம்ʼ ப்ரவிஸ்²ய ");
INSERT INTO santam_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ஸ்தா²பிதவஸ்த்ராணி மஸ்தகஸ்ய வஸ்த்ரஞ்ச ப்ருʼத²க் ஸ்தா²நாந்தரே ஸ்தா²பிதம்ʼ த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","தத​: ஸ்²மஸா²நஸ்தா²நம்ʼ பூர்வ்வம் ஆக³தோ யோந்யஸி²ஷ்ய​: ஸோபி ப்ரவிஸ்²ய தாத்³ருʼஸ²ம்ʼ த்³ருʼஷ்டா வ்யஸ்²வஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","யத​: ஸ்²மஸா²நாத் ஸ உத்தா²பயிதவ்ய ஏதஸ்ய த⁴ர்ம்மபுஸ்தகவசநஸ்ய பா⁴வம்ʼ தே ததா³ வோத்³து⁴ம்ʼ நாஸ²ந்குவந்| ");
INSERT INTO santam_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","அநந்தரம்ʼ தௌ த்³வௌ ஸி²ஷ்யௌ ஸ்வம்ʼ ஸ்வம்ʼ க்³ருʼஹம்ʼ பராவ்ருʼத்யாக³ச்ச²தாம்| ");
INSERT INTO santam_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","தத​: பரம்ʼ மரியம் ஸ்²மஸா²நத்³வாரஸ்ய ப³ஹி​: ஸ்தி²த்வா ரோதி³தும் ஆரப⁴த ததோ ருத³தீ ப்ரஹ்வீபூ⁴ய ஸ்²மஸா²நம்ʼ விலோக்ய ");
INSERT INTO santam_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","யீஸோ²​: ஸ²யநஸ்தா²நஸ்ய ஸி²ர​:ஸ்தா²நே பத³தலே ச த்³வயோ ர்தி³ஸோ² த்³வௌ ஸ்வர்கீ³யதூ³தாவுபவிஷ்டௌ ஸமபஸ்²யத்| ");
INSERT INTO santam_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","தௌ ப்ருʼஷ்டவந்தௌ ஹே நாரி குதோ ரோதி³ஷி? ஸாவத³த் லோகா மம ப்ரபு⁴ம்ʼ நீத்வா குத்ராஸ்தா²பயந் இதி ந ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","இத்யுக்த்வா முக²ம்ʼ பராவ்ருʼத்ய யீஸு²ம்ʼ த³ண்டா³யமாநம் அபஸ்²யத் கிந்து ஸ யீஸு²ரிதி ஸா ஜ்ஞாதும்ʼ நாஸ²க்நோத்| ");
INSERT INTO santam_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ததா³ யீஸு²ஸ்தாம் அப்ருʼச்ச²த் ஹே நாரி குதோ ரோதி³ஷி? கம்ʼ வா ம்ருʼக³யஸே? தத​: ஸா தம் உத்³யாநஸேவகம்ʼ ஜ்ஞாத்வா வ்யாஹரத், ஹே மஹேச்ச² த்வம்ʼ யதீ³த​: ஸ்தா²நாத் தம்ʼ நீதவாந் தர்ஹி குத்ராஸ்தா²பயஸ்தத்³ வத³ தத்ஸ்தா²நாத் தம் ஆநயாமி| ");
INSERT INTO santam_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ததா³ யீஸு²ஸ்தாம் அவத³த் ஹே மரியம்| தத​: ஸா பராவ்ருʼத்ய ப்ரத்யவத³த் ஹே ரப்³பூ³நீ அர்தா²த் ஹே கு³ரோ| ");
INSERT INTO santam_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ததா³ யீஸு²ரவத³த் மாம்ʼ மா த⁴ர, இதா³நீம்ʼ பிது​: ஸமீபே ஊர்த்³த்⁴வக³மநம்ʼ ந கரோமி கிந்து யோ மம யுஷ்மாகஞ்ச பிதா மம யுஷ்மாகஞ்சேஸ்²வரஸ்தஸ்ய நிகட ஊர்த்³த்⁴வக³மநம்ʼ கர்த்தும் உத்³யதோஸ்மி, இமாம்ʼ கதா²ம்ʼ த்வம்ʼ க³த்வா மம ப்⁴ராத்ருʼக³ணம்ʼ ஜ்ஞாபய| ");
INSERT INTO santam_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ததோ மக்³த³லீநீமரியம் தத்க்ஷணாத்³ க³த்வா ப்ரபு⁴ஸ்தஸ்யை த³ர்ஸ²நம்ʼ த³த்த்வா கதா² ஏதா அகத²யத்³ இதி வார்த்தாம்ʼ ஸி²ஷ்யேப்⁴யோ(அ)கத²யத்| ");
INSERT INTO santam_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","தத​: பரம்ʼ ஸப்தாஹஸ்ய ப்ரத²மதி³நஸ்ய ஸந்த்⁴யாஸமயே ஸி²ஷ்யா ஏகத்ர மிலித்வா யிஹூதீ³யேப்⁴யோ பி⁴யா த்³வாரருத்³த⁴ம் அகுர்வ்வந், ஏதஸ்மிந் காலே யீஸு²ஸ்தேஷாம்ʼ மத்⁴யஸ்தா²நே திஷ்ட²ந் அகத²யத்³ யுஷ்மாகம்ʼ கல்யாணம்ʼ பூ⁴யாத்| ");
INSERT INTO santam_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","இத்யுக்த்வா நிஜஹஸ்தம்ʼ குக்ஷிஞ்ச த³ர்ஸி²தவாந், தத​: ஸி²ஷ்யா​: ப்ரபு⁴ம்ʼ த்³ருʼஷ்ட்வா ஹ்ருʼஷ்டா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","யீஸு²​: புநரவத³த்³ யுஷ்மாகம்ʼ கல்யாணம்ʼ பூ⁴யாத் பிதா யதா² மாம்ʼ ப்ரைஷயத் ததா²ஹமபி யுஷ்மாந் ப்ரேஷயாமி| ");
INSERT INTO santam_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","இத்யுக்த்வா ஸ தேஷாமுபரி தீ³ர்க⁴ப்ரஸ்²வாஸம்ʼ த³த்த்வா கதி²தவாந் பவித்ரம் ஆத்மாநம்ʼ க்³ருʼஹ்லீத| ");
INSERT INTO santam_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","யூயம்ʼ யேஷாம்ʼ பாபாநி மோசயிஷ்யத² தே மோசயிஷ்யந்தே யேஷாஞ்ச பாபாதி ந மோசயிஷ்யத² தே ந மோசயிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","த்³வாத³ஸ²மத்⁴யே க³ணிதோ யமஜோ தோ²மாநாமா ஸி²ஷ்யோ யீஸோ²ராக³மநகாலை தை​: ஸார்த்³த⁴ம்ʼ நாஸீத்| ");
INSERT INTO santam_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","அதோ வயம்ʼ ப்ரபூ⁴ம் அபஸ்²யாமேதி வாக்யே(அ)ந்யஸி²ஷ்யைருக்தே ஸோவத³த், தஸ்ய ஹஸ்தயோ ர்லௌஹகீலகாநாம்ʼ சிஹ்நம்ʼ ந விலோக்ய தச்சிஹ்நம் அங்கு³ல்யா ந ஸ்ப்ருʼஷ்ட்வா தஸ்ய குக்ஷௌ ஹஸ்தம்ʼ நாரோப்ய சாஹம்ʼ ந விஸ்²வஸிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","அபரம் அஷ்டமே(அ)ஹ்நி க³தே ஸதி தோ²மாஸஹித​: ஸி²ஷ்யக³ண ஏகத்ர மிலித்வா த்³வாரம்ʼ ருத்³த்⁴வாப்⁴யந்தர ஆஸீத், ஏதர்ஹி யீஸு²ஸ்தேஷாம்ʼ மத்⁴யஸ்தா²நே திஷ்ட²ந் அகத²யத், யுஷ்மாகம்ʼ குஸ²லம்ʼ பூ⁴யாத்| ");
INSERT INTO santam_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","பஸ்²சாத் தா²மை கதி²தவாந் த்வம் அங்கு³லீம் அத்ரார்பயித்வா மம கரௌ பஸ்²ய கரம்ʼ ப்ரஸார்ய்ய மம குக்ஷாவர்பய நாவிஸ்²வஸ்ய| ");
INSERT INTO santam_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ததா³ தோ²மா அவத³த், ஹே மம ப்ரபோ⁴ ஹே மதீ³ஸ்²வர| ");
INSERT INTO santam_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","யீஸு²ரகத²யத், ஹே தோ²மா மாம்ʼ நிரீக்ஷ்ய விஸ்²வஸிஷி யே ந த்³ருʼஷ்ட்வா விஸ்²வஸந்தி தஏவ த⁴ந்யா​:| ");
INSERT INTO santam_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ஏதத³ந்யாநி புஸ்தகே(அ)ஸ்மிந் அலிகி²தாநி ப³ஹூந்யாஸ்²சர்ய்யகர்ம்மாணி யீஸு²​: ஸி²ஷ்யாணாம்ʼ புரஸ்தாத்³ அகரோத்| ");
INSERT INTO santam_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","கிந்து யீஸு²ரீஸ்²வரஸ்யாபி⁴ஷிக்த​: ஸுத ஏவேதி யதா² யூயம்ʼ விஸ்²வஸித² விஸ்²வஸ்ய ச தஸ்ய நாம்நா பரமாயு​: ப்ராப்நுத² தத³ர்த²ம் ஏதாநி ஸர்வ்வாண்யலிக்²யந்த| ");
INSERT INTO santam_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","தத​: பரம்ʼ திபி³ரியாஜலதே⁴ஸ்தடே யீஸு²​: புநரபி ஸி²ஷ்யேப்⁴யோ த³ர்ஸ²நம்ʼ த³த்தவாந் த³ர்ஸ²நஸ்யாக்²யாநமித³ம்| ");
INSERT INTO santam_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ஸி²மோந்பிதர​: யமஜதோ²மா கா³லீலீயகாந்நாநக³ரநிவாஸீ நித²நேல் ஸிவதே³​: புத்ராவந்யௌ த்³வௌ ஸி²ஷ்யௌ சைதேஷ்வேகத்ர மிலிதேஷு ஸி²மோந்பிதரோ(அ)கத²யத் மத்ஸ்யாந் த⁴ர்தும்ʼ யாமி| ");
INSERT INTO santam_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ததஸ்தே வ்யாஹரந் தர்ஹி வயமபி த்வயா ஸார்த்³த⁴ம்ʼ யாம​: ததா³ தே ப³ஹிர்க³தா​: ஸந்த​: க்ஷிப்ரம்ʼ நாவம் ஆரோஹந் கிந்து தஸ்யாம்ʼ ரஜந்யாம் ஏகமபி ந ப்ராப்நுவந்| ");
INSERT INTO santam_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ப்ரபா⁴தே ஸதி யீஸு²ஸ்தடே ஸ்தி²தவாந் கிந்து ஸ யீஸு²ரிதி ஸி²ஷ்யா ஜ்ஞாதும்ʼ நாஸ²க்நுவந்| ");
INSERT INTO santam_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ததா³ யீஸு²ரப்ருʼச்ச²த், ஹே வத்ஸா ஸந்நிதௌ⁴ கிஞ்சித் கா²த்³யத்³ரவ்யம் ஆஸ்தே? தே(அ)வத³ந் கிமபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ததா³ ஸோ(அ)வத³த் நௌகாயா த³க்ஷிணபார்ஸ்²வே ஜாலம்ʼ நிக்ஷிபத ததோ லப்ஸ்யத்⁴வே, தஸ்மாத் தை ர்நிக்ஷிப்தே ஜாலே மத்ஸ்யா ஏதாவந்தோ(அ)பதந் யேந தே ஜாலமாக்ருʼஷ்ய நோத்தோலயிதும்ʼ ஸ²க்தா​:| ");
INSERT INTO santam_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","தஸ்மாத்³ யீஸோ²​: ப்ரியதமஸி²ஷ்ய​: பிதராயாகத²யத் ஏஷ ப்ரபு⁴ ர்ப⁴வேத், ஏஷ ப்ரபு⁴ரிதி வாசம்ʼ ஸ்²ருத்வைவ ஸி²மோந் நக்³நதாஹேதோ ர்மத்ஸ்யதா⁴ரிண உத்தரீயவஸ்த்ரம்ʼ பரிதா⁴ய ஹ்ரத³ம்ʼ ப்ரத்யுத³லம்ப²யத்| ");
INSERT INTO santam_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","அபரே ஸி²ஷ்யா மத்ஸ்யை​: ஸார்த்³த⁴ம்ʼ ஜாலம் ஆகர்ஷந்த​: க்ஷுத்³ரநௌகாம்ʼ வாஹயித்வா கூலமாநயந் தே கூலாத்³ அதிதூ³ரே நாஸந் த்³விஸ²தஹஸ்தேப்⁴யோ தூ³ர ஆஸந் இத்யநுமீயதே| ");
INSERT INTO santam_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","தீரம்ʼ ப்ராப்தைஸ்தைஸ்தத்ர ப்ரஜ்வலிதாக்³நிஸ்தது³பரி மத்ஸ்யா​: பூபாஸ்²ச த்³ருʼஷ்டா​:| ");
INSERT INTO santam_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ததோ யீஸு²ரகத²யத்³ யாந் மத்ஸ்யாந் அத⁴ரத தேஷாம்ʼ கதிபயாந் ஆநயத| ");
INSERT INTO santam_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","அத​: ஸி²மோந்பிதர​: பராவ்ருʼத்ய க³த்வா ப்³ருʼஹத்³பி⁴ஸ்த்ரிபஞ்சாஸ²த³தி⁴கஸ²தமத்ஸ்யை​: பரிபூர்ணம்ʼ தஜ்ஜாலம் ஆக்ருʼஷ்யோத³தோலயத் கிந்த்வேதாவத்³பி⁴ ர்மத்ஸ்யைரபி ஜாலம்ʼ நாசி²த்³யத| ");
INSERT INTO santam_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","அநந்தரம்ʼ யீஸு²ஸ்தாந் அவாதீ³த் யூயமாக³த்ய பு⁴ம்ʼக்³த்⁴வம்ʼ; ததா³ ஸஏவ ப்ரபு⁴ரிதி ஜ்ஞாதத்வாத் த்வம்ʼ க​:? இதி ப்ரஷ்டும்ʼ ஸி²ஷ்யாணாம்ʼ கஸ்யாபி ப்ரக³ல்ப⁴தா நாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ததோ யீஸு²ராக³த்ய பூபாந் மத்ஸ்யாம்ʼஸ்²ச க்³ருʼஹீத்வா தேப்⁴ய​: பர்ய்யவேஷயத்| ");
INSERT INTO santam_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","இத்த²ம்ʼ ஸ்²மஸா²நாது³த்தா²நாத் பரம்ʼ யீஸு²​: ஸி²ஷ்யேப்⁴யஸ்த்ருʼதீயவாரம்ʼ த³ர்ஸ²நம்ʼ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","போ⁴ஜநே ஸமாப்தே ஸதி யீஸு²​: ஸி²மோந்பிதரம்ʼ ப்ருʼஷ்டவாந், ஹே யூநஸ​: புத்ர ஸி²மோந் த்வம்ʼ கிம் ஏதேப்⁴யோதி⁴கம்ʼ மயி ப்ரீயஸே? தத​: ஸ உதி³தவாந் ஸத்யம்ʼ ப்ரபோ⁴ த்வயி ப்ரீயே(அ)ஹம்ʼ தத்³ ப⁴வாந் ஜாநாதி; ததா³ யீஸு²ரகத²யத் தர்ஹி மம மேஷஸா²வகக³ணம்ʼ பாலய| ");
INSERT INTO santam_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","தத​: ஸ த்³விதீயவாரம்ʼ ப்ருʼஷ்டவாந் ஹே யூநஸ​: புத்ர ஸி²மோந் த்வம்ʼ கிம்ʼ மயி ப்ரீயஸே? தத​: ஸ உக்தவாந் ஸத்யம்ʼ ப்ரபோ⁴ த்வயி ப்ரீயே(அ)ஹம்ʼ தத்³ ப⁴வாந் ஜாநாதி; ததா³ யீஸு²ரகத²யத தர்ஹி மம மேஷக³ணம்ʼ பாலய| ");
INSERT INTO santam_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","பஸ்²சாத் ஸ த்ருʼதீயவாரம்ʼ ப்ருʼஷ்டவாந், ஹே யூநஸ​: புத்ர ஸி²மோந் த்வம்ʼ கிம்ʼ மயி ப்ரீயஸே? ஏதத்³வாக்யம்ʼ த்ருʼதீயவாரம்ʼ ப்ருʼஷ்டவாந் தஸ்மாத் பிதரோ து³​:கி²தோ பூ⁴த்வா(அ)கத²யத் ஹே ப்ரபோ⁴ ப⁴வத​: கிமப்யகோ³சரம்ʼ நாஸ்தி த்வய்யஹம்ʼ ப்ரீயே தத்³ ப⁴வாந் ஜாநாதி; ததோ யீஸு²ரவத³த் தர்ஹி மம மேஷக³ணம்ʼ பாலய| ");
INSERT INTO santam_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","அஹம்ʼ துப்⁴யம்ʼ யதா²ர்த²ம்ʼ கத²யாமி யௌவநகாலே ஸ்வயம்ʼ ப³த்³த⁴கடி ர்யத்ரேச்சா² தத்ர யாதவாந் கிந்த்வித​: பரம்ʼ வ்ருʼத்³தே⁴ வயஸி ஹஸ்தம்ʼ விஸ்தாரயிஷ்யஸி, அந்யஜநஸ்த்வாம்ʼ ப³த்³த்⁴வா யத்ர க³ந்தும்ʼ தவேச்சா² ந ப⁴வதி த்வாம்ʼ த்⁴ருʼத்வா தத்ர நேஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ப²லத​: கீத்³ருʼஸே²ந மரணேந ஸ ஈஸ்²வரஸ்ய மஹிமாநம்ʼ ப்ரகாஸ²யிஷ்யதி தத்³ போ³த⁴யிதும்ʼ ஸ இதி வாக்யம்ʼ ப்ரோக்தவாந்| இத்யுக்தே ஸதி ஸ தமவோசத் மம பஸ்²சாத்³ ஆக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","யோ ஜநோ ராத்ரிகாலே யீஸோ² ர்வக்ஷோ(அ)வலம்ப்³ய, ஹே ப்ரபோ⁴ கோ ப⁴வந்தம்ʼ பரகரேஷு ஸமர்பயிஷ்யதீதி வாக்யம்ʼ ப்ருʼஷ்டவாந், தம்ʼ யீஸோ²​: ப்ரியதமஸி²ஷ்யம்ʼ பஸ்²சாத்³ ஆக³ச்ச²ந்தம்ʼ ");
INSERT INTO santam_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","பிதரோ முக²ம்ʼ பராவர்த்த்ய விலோக்ய யீஸு²ம்ʼ ப்ருʼஷ்டவாந், ஹே ப்ரபோ⁴ ஏதஸ்ய மாநவஸ்ய கீத்³ருʼஸீ² க³தி ர்ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ஸ ப்ரத்யவத³த், மம புநராக³மநபர்ய்யந்தம்ʼ யதி³ தம்ʼ ஸ்தா²பயிதும் இச்சா²மி தத்ர தவ கிம்ʼ? த்வம்ʼ மம பஸ்²சாத்³ ஆக³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","தஸ்மாத் ஸ ஸி²ஷ்யோ ந மரிஷ்யதீதி ப்⁴ராத்ருʼக³ணமத்⁴யே கிம்ʼவத³ந்தீ ஜாதா கிந்து ஸ ந மரிஷ்யதீதி வாக்யம்ʼ யீஸு² ர்நாவத³த் கேவலம்ʼ மம புநராக³மநபர்ய்யந்தம்ʼ யதி³ தம்ʼ ஸ்தா²பயிதும் இச்சா²மி தத்ர தவ கிம்ʼ? இதி வாக்யம் உக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","யோ ஜந ஏதாநி ஸர்வ்வாணி லிகி²தவாந் அத்ர ஸாக்ஷ்யஞ்ச த³த்தவாந் ஸஏவ ஸ ஸி²ஷ்ய​:, தஸ்ய ஸாக்ஷ்யம்ʼ ப்ரமாணமிதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","யீஸு²ரேதேப்⁴யோ(அ)பராண்யபி ப³ஹூநி கர்ம்மாணி க்ருʼதவாந் தாநி ஸர்வ்வாணி யத்³யேகைகம்ʼ க்ருʼத்வா லிக்²யந்தே தர்ஹி க்³ரந்தா² ஏதாவந்தோ ப⁴வந்தி தேஷாம்ʼ தா⁴ரணே ப்ருʼதி²வ்யாம்ʼ ஸ்தா²நம்ʼ ந ப⁴வதி| இதி||");
INSERT INTO santam_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ஹே தி²யபி²ல, யீஸு²​: ஸ்வமநோநீதாந் ப்ரேரிதாந் பவித்ரேணாத்மநா ஸமாதி³ஸ்²ய யஸ்மிந் தி³நே ஸ்வர்க³மாரோஹத் யாம்ʼ யாம்ʼ க்ரியாமகரோத் யத்³யத்³ உபாதி³ஸ²ச்ச தாநி ஸர்வ்வாணி பூர்வ்வம்ʼ மயா லிகி²தாநி| ");
INSERT INTO santam_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ஸ ஸ்வநித⁴நது³​:க²போ⁴கா³த் பரம் அநேகப்ரத்யயக்ஷப்ரமாணௌ​: ஸ்வம்ʼ ஸஜீவம்ʼ த³ர்ஸ²யித்வா ");
INSERT INTO santam_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","சத்வாரிம்ʼஸ²த்³தி³நாநி யாவத் தேப்⁴ய​: ப்ரேரிதேப்⁴யோ த³ர்ஸ²நம்ʼ த³த்த்வேஸ்²வரீயராஜ்யஸ்ய வர்ணநம அகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","அநந்தரம்ʼ தேஷாம்ʼ ஸபா⁴ம்ʼ க்ருʼத்வா இத்யாஜ்ஞாபயத், யூயம்ʼ யிரூஸா²லமோ(அ)ந்யத்ர க³மநமக்ருʼத்வா யஸ்திந் பித்ராங்கீ³க்ருʼதே மம வத³நாத் கதா² அஸ்²ருʼணுத தத்ப்ராப்திம் அபேக்ஷ்ய திஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","யோஹந் ஜலே மஜ்ஜிதாவாந் கிந்த்வல்பதி³நமத்⁴யே யூயம்ʼ பவித்ர ஆத்மநி மஜ்ஜிதா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","பஸ்²சாத் தே ஸர்வ்வே மிலித்வா தம் அப்ருʼச்ச²ந் ஹே ப்ரபோ⁴ ப⁴வாந் கிமிதா³நீம்ʼ புநரபி ராஜ்யம் இஸ்ராயேலீயலோகாநாம்ʼ கரேஷு ஸமர்பயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","தத​: ஸோவத³த் யாந் ஸர்வ்வாந் காலாந் ஸமயாம்ʼஸ்²ச பிதா ஸ்வவஸே²(அ)ஸ்தா²பயத் தாந் ஜ்ஞாத்ரும்ʼʼ யுஷ்மாகம் அதி⁴காரோ ந ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","கிந்து யுஷ்மாஸு பவித்ரஸ்யாத்மந ஆவிர்பா⁴வே ஸதி யூயம்ʼ ஸ²க்திம்ʼ ப்ராப்ய யிரூஸா²லமி ஸமஸ்தயிஹூதா³ஸோ²மிரோணதே³ஸ²யோ​: ப்ருʼதி²வ்யா​: ஸீமாம்ʼ யாவத்³ யாவந்தோ தே³ஸா²ஸ்தேஷு யர்வ்வேஷு ச மயி ஸாக்ஷ்யம்ʼ தா³ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","இதி வாக்யமுக்த்வா ஸ தேஷாம்ʼ ஸமக்ஷம்ʼ ஸ்வர்க³ம்ʼ நீதோ(அ)ப⁴வத், ததோ மேக⁴மாருஹ்ய தேஷாம்ʼ த்³ருʼஷ்டேரகோ³சரோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","யஸ்மிந் ஸமயே தே விஹாயஸம்ʼ ப்ரத்யநந்யத்³ருʼஷ்ட்யா தஸ்ய தாத்³ருʼஸ²ம் ஊர்த்³வ்வக³மநம் அபஸ்²யந் தஸ்மிந்நேவ ஸமயே ஸு²க்லவஸ்த்ரௌ த்³வௌ ஜநௌ தேஷாம்ʼ ஸந்நிதௌ⁴ த³ண்டா³யமாநௌ கதி²தவந்தௌ, ");
INSERT INTO santam_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ஹே கா³லீலீயலோகா யூயம்ʼ கிமர்த²ம்ʼ க³க³ணம்ʼ ப்ரதி நிரீக்ஷ்ய த³ண்டா³யமாநாஸ்திஷ்ட²த²? யுஷ்மாகம்ʼ ஸமீபாத் ஸ்வர்க³ம்ʼ நீதோ யோ யீஸு²ஸ்தம்ʼ யூயம்ʼ யதா² ஸ்வர்க³ம் ஆரோஹந்தம் அத³ர்ஸ²ம் ததா² ஸ புநஸ்²சாக³மிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","தத​: பரம்ʼ தே ஜைதுநநாம்ந​: பர்வ்வதாத்³ விஸ்²ராமவாரஸ்ய பத²​: பரிமாணம் அர்தா²த் ப்ராயேணார்த்³த⁴க்ரோஸ²ம்ʼ து³ரஸ்த²ம்ʼ யிரூஸா²லம்நக³ரம்ʼ பராவ்ருʼத்யாக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","நக³ரம்ʼ ப்ரவிஸ்²ய பிதரோ யாகூப்³ யோஹந் ஆந்த்³ரிய​: பி²லிப​: தோ²மா ப³ர்த²ஜமயோ மதி²ரால்பீ²யபுத்ரோ யாகூப்³ உத்³யோகா³ी ஸி²மோந் யாகூபோ³ ப்⁴ராதா யிஹூதா³ ஏதே ஸர்வ்வே யத்ர ஸ்தா²நே ப்ரவஸந்தி தஸ்மிந் உபரிதநப்ரகோஷ்டே² ப்ராவிஸ²ந்| ");
INSERT INTO santam_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","பஸ்²சாத்³ இமே கியத்ய​: ஸ்த்ரியஸ்²ச யீஸோ² ர்மாதா மரியம் தஸ்ய ப்⁴ராதரஸ்²சைதே ஸர்வ்வ ஏகசித்தீபூ⁴த ஸததம்ʼ விநயேந விநயேந ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","தஸ்மிந் ஸமயே தத்ர ஸ்தா²நே ஸாகல்யேந விம்ʼஸ²த்யதி⁴கஸ²தம்ʼ ஸி²ஷ்யா ஆஸந்| தத​: பிதரஸ்தேஷாம்ʼ மத்⁴யே திஷ்ட²ந் உக்தவாந் ");
INSERT INTO santam_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ஹே ப்⁴ராத்ருʼக³ண யீஸு²தா⁴ரிணாம்ʼ லோகாநாம்ʼ பத²த³ர்ஸ²கோ யோ யிஹூதா³ஸ்தஸ்மிந் தா³யூதா³ பவித்ர ஆத்மா யாம்ʼ கதா²ம்ʼ கத²யாமாஸ தஸ்யா​: ப்ரத்யக்ஷீப⁴வநஸ்யாவஸ்²யகத்வம் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ஸ ஜநோ(அ)ஸ்மாகம்ʼ மத்⁴யவர்த்தீ ஸந் அஸ்யா​: ஸேவாயா அம்ʼஸ²ம் அலப⁴த| ");
INSERT INTO santam_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","தத³நந்தரம்ʼ குகர்ம்மணா லப்³த⁴ம்ʼ யந்மூல்யம்ʼ தேந க்ஷேத்ரமேகம்ʼ க்ரீதம் அபரம்ʼ தஸ்மிந் அதோ⁴முகே² ப்⁴ருʼமௌ பதிதே ஸதி தஸ்யோத³ரஸ்ய விதீ³ர்ணத்வாத் ஸர்வ்வா நாட்³யோ நிரக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ஏதாம்ʼ கதா²ம்ʼ யிரூஸா²லம்நிவாஸிந​: ஸர்வ்வே லோகா விதா³ந்தி; தேஷாம்ʼ நிஜபா⁴ஷயா தத்க்ஷேத்ரஞ்ச ஹகல்தா³மா, அர்தா²த் ரக்தக்ஷேத்ரமிதி விக்²யாதமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","அந்யச்ச, நிகேதநம்ʼ ததீ³யந்து ஸு²ந்யமேவ ப⁴விஷ்யதி| தஸ்ய தூ³ஷ்யே நிவாஸார்த²ம்ʼ கோபி ஸ்தா²ஸ்யதி நைவ ஹி| அந்ய ஏவ ஜநஸ்தஸ்ய பத³ம்ʼ ஸம்ʼப்ராப்ஸ்யதி த்⁴ருவம்ʼ| இத்த²ம்ʼ கீ³தபுஸ்தகே லிகி²தமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","அதோ யோஹநோ மஜ்ஜநம் ஆரப்⁴யாஸ்மாகம்ʼ ஸமீபாத் ப்ரபோ⁴ ர்யீஸோ²​: ஸ்வர்கா³ரோஹணதி³நம்ʼ யாவத் ஸோஸ்மாகம்ʼ மத்⁴யே யாவந்தி தி³நாநி யாபிதவாந் ");
INSERT INTO santam_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","தாவந்தி தி³நாநி யே மாநவா அஸ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ திஷ்ட²ந்தி தேஷாம் ஏகேந ஜநேநாஸ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ யீஸோ²ருத்தா²நே ஸாக்ஷிணா ப⁴விதவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","அதோ யஸ்ய ரூடி⁴ ர்யுஷ்டோ யம்ʼ ப³ர்ஸ²ப்³பே³த்யுக்த்வாஹூயந்தி ஸ யூஷப்² மததி²ஸ்²ச த்³வாவேதௌ ப்ருʼத²க் க்ருʼத்வா த ஈஸ்²வரஸ்ய ஸந்நிதௌ⁴ ப்ரார்ய்ய கதி²தவந்த​:, ");
INSERT INTO santam_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ஹே ஸர்வ்வாந்தர்ய்யாமிந் பரமேஸ்²வர, யிஹூதா³​: ஸேவநப்ரேரிதத்வபத³ச்யுத​: ");
INSERT INTO santam_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ஸந் நிஜஸ்தா²நம் அக³ச்ச²த், தத்பத³ம்ʼ லப்³து⁴ம் ஏநயோ ர்ஜநயோ ர்மத்⁴யே ப⁴வதா கோ(அ)பி⁴ருசிதஸ்தத³ஸ்மாந் த³ர்ஸ்²யதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ததோ கு³டிகாபாடே க்ருʼதே மததி²ர்நிரசீயத தஸ்மாத் ஸோந்யேஷாம் ஏகாத³ஸா²நாம்ʼ ப்ரரிதாநாம்ʼ மத்⁴யே க³ணிதோப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","அபரஞ்ச நிஸ்தாரோத்ஸவாத் பரம்ʼ பஞ்சாஸ²த்தமே தி³நே ஸமுபஸ்தி²தே ஸதி தே ஸர்வ்வே ஏகாசித்தீபூ⁴ய ஸ்தா²ந ஏகஸ்மிந் மிலிதா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ஏதஸ்மிந்நேவ ஸமயே(அ)கஸ்மாத்³ ஆகாஸா²த் ப்ரசண்டா³த்யுக்³ரவாயோ​: ஸ²ப்³த³வத்³ ஏக​: ஸ²ப்³த³ ஆக³த்ய யஸ்மிந் க்³ருʼஹே த உபாவிஸ²ந் தத்³ க்³ருʼஹம்ʼ ஸமஸ்தம்ʼ வ்யாப்நோத்| ");
INSERT INTO santam_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","தத​: பரம்ʼ வஹ்நிஸி²கா²ஸ்வரூபா ஜிஹ்வா​: ப்ரத்யக்ஷீபூ⁴ய விப⁴க்தா​: ஸத்ய​: ப்ரதிஜநோர்த்³த்⁴வே ஸ்த²கி³தா அபூ⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","தஸ்மாத் ஸர்வ்வே பவித்ரேணாத்மநா பரிபூர்ணா​: ஸந்த ஆத்மா யதா² வாசிதவாந் தத³நுஸாரேணாந்யதே³ஸீ²யாநாம்ʼ பா⁴ஷா உக்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","தஸ்மிந் ஸமயே ப்ருʼதி²வீஸ்த²ஸர்வ்வதே³ஸே²ப்⁴யோ யிஹூதீ³யமதாவலம்பி³நோ ப⁴க்தலோகா யிரூஸா²லமி ப்ராவஸந்; ");
INSERT INTO santam_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","தஸ்யா​: கதா²யா​: கிம்ʼவத³ந்த்யா ஜாதத்வாத் ஸர்வ்வே லோகா மிலித்வா நிஜநிஜபா⁴ஷயா ஸி²ஷ்யாணாம்ʼ கதா²கத²நம்ʼ ஸ்²ருத்வா ஸமுத்³விக்³நா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ஸர்வ்வஏவ விஸ்மயாபந்நா ஆஸ்²சர்ய்யாந்விதாஸ்²ச ஸந்த​: பரஸ்பரம்ʼ உக்தவந்த​: பஸ்²யத யே கதா²ம்ʼ கத²யந்தி தே ஸர்வ்வே கா³லீலீயலோகா​: கிம்ʼ ந ப⁴வந்தி? ");
INSERT INTO santam_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","தர்ஹி வயம்ʼ ப்ரத்யேகஸ²​: ஸ்வஸ்வஜந்மதே³ஸீ²யபா⁴ஷாபி⁴​: கதா² ஏதேஷாம்ʼ ஸ்²ருʼணும​: கிமித³ம்ʼ? ");
INSERT INTO santam_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","பார்தீ²-மாதீ³-அராம்நஹரயிம்தே³ஸ²நிவாஸிமநோ யிஹூதா³-கப்பத³கியா-பந்த-ஆஸி²யா- ");
INSERT INTO santam_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ப்²ருகி³யா-பம்பு²லியா-மிஸரநிவாஸிந​: குரீணீநிகடவர்த்திலூபீ³யப்ரதே³ஸ²நிவாஸிநோ ரோமநக³ராத்³ ஆக³தா யிஹூதீ³யலோகா யிஹூதீ³யமதக்³ராஹிண​: க்ரீதீயா அராபீ³யாத³யோ லோகாஸ்²ச யே வயம் ");
INSERT INTO santam_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","அஸ்மாகம்ʼ நிஜநிஜபா⁴ஷாபி⁴ரேதேஷாம் ஈஸ்²வரீயமஹாகர்ம்மவ்யாக்²யாநம்ʼ ஸ்²ருʼணும​:| ");
INSERT INTO santam_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","இத்த²ம்ʼ தே ஸர்வ்வஏவ விஸ்மயாபந்நா​: ஸந்தி³க்³த⁴சித்தா​: ஸந்த​: பரஸ்பரமூசு​:, அஸ்ய கோ பா⁴வ​:? ");
INSERT INTO santam_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","அபரே கேசித் பரிஹஸ்ய கதி²தவந்த ஏதே நவீநத்³ராக்ஷாரஸேந மத்தா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ததா³ பிதர ஏகாத³ஸ²பி⁴ ர்ஜநை​: ஸாகம்ʼ திஷ்ட²ந் தால்லோகாந் உச்சை​:காரம் அவத³த், ஹே யிஹூதீ³யா ஹே யிரூஸா²லம்நிவாஸிந​: ஸர்வ்வே, அவதா⁴நம்ʼ க்ருʼத்வா மதீ³யவாக்யம்ʼ பு³த்⁴யத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","இதா³நீம் ஏகயாமாத்³ அதி⁴கா வேலா நாஸ்தி தஸ்மாத்³ யூயம்ʼ யத்³ அநுமாத² மாநவா இமே மத்³யபாநேந மத்தாஸ்தந்ந| ");
INSERT INTO santam_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","கிந்து யோயேல்ப⁴விஷ்யத்³வக்த்ரைதத்³வாக்யமுக்தம்ʼ யதா², ");
INSERT INTO santam_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ஈஸ்²வர​: கத²யாமாஸ யுகா³ந்தஸமயே த்வஹம்| வர்ஷிஷ்யாமி ஸ்வமாத்மாநம்ʼ ஸர்வ்வப்ராண்யுபரி த்⁴ருவம்| பா⁴விவாக்யம்ʼ வதி³ஷ்யந்தி கந்யா​: புத்ராஸ்²ச வஸ்துத​:| ப்ரத்யாதே³ஸ²ஞ்ச ப்ராப்ஸ்யந்தி யுஷ்மாகம்ʼ யுவமாநவா​:| ததா² ப்ராசீநலோகாஸ்து ஸ்வப்நாந் த்³ரக்ஷ்யந்தி நிஸ்²சிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","வர்ஷிஷ்யாமி ததா³த்மாநம்ʼ தா³ஸதா³ஸீஜநோபிரி| தேநைவ பா⁴விவாக்யம்ʼ தே வதி³ஷ்யந்தி ஹி ஸர்வ்வஸ²​:| ");
INSERT INTO santam_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ஊர்த்³த்⁴வஸ்தே² க³க³ணே சைவ நீசஸ்தே² ப்ருʼதி²வீதலே| ஸோ²ணிதாநி ப்³ருʼஹத்³பா⁴நூந் க⁴நதூ⁴மாதி³காநி ச| சிஹ்நாநி த³ர்ஸ²யிஷ்யாமி மஹாஸ்²சர்ய்யக்ரியாஸ்ததா²| ");
INSERT INTO santam_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","மஹாப⁴யாநகஸ்யைவ தத்³தி³நஸ்ய பரேஸி²து​:| புராக³மாத்³ ரவி​: க்ருʼஷ்ணோ ரக்தஸ்²சந்த்³ரோ ப⁴விஷ்யத​:| ");
INSERT INTO santam_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","கிந்து ய​: பரமேஸ²ஸ்ய நாம்நி ஸம்ப்ரார்த²யிஷ்யதே| ஸஏவ மநுஜோ நூநம்ʼ பரித்ராதோ ப⁴விஷ்யதி|| ");
INSERT INTO santam_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","அதோ ஹே இஸ்ராயேல்வம்ʼஸீ²யலோகா​: ஸர்வ்வே கதா²யாமேதஸ்யாம் மநோ நித⁴த்³த்⁴வம்ʼ நாஸரதீயோ யீஸு²ரீஸ்²வரஸ்ய மநோநீத​: புமாந் ஏதத்³ ஈஸ்²வரஸ்தத்க்ருʼதைராஸ்²சர்ய்யாத்³பு⁴தகர்ம்மபி⁴ ர்லக்ஷணைஸ்²ச யுஷ்மாகம்ʼ ஸாக்ஷாதே³வ ப்ரதிபாதி³தவாந் இதி யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","தஸ்மிந் யீஸௌ² ஈஸ்²வரஸ்ய பூர்வ்வநிஸ்²சிதமந்த்ரணாநிரூபணாநுஸாரேண ம்ருʼத்யௌ ஸமர்பிதே ஸதி யூயம்ʼ தம்ʼ த்⁴ருʼத்வா து³ஷ்டலோகாநாம்ʼ ஹஸ்தை​: க்ருஸே² விதி⁴த்வாஹத| ");
INSERT INTO santam_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","கிந்த்வீஸ்²வரஸ்தம்ʼ நித⁴நஸ்ய ப³ந்த⁴நாந்மோசயித்வா உத³ஸ்தா²பயத் யத​: ஸ ம்ருʼத்யுநா ப³த்³த⁴ஸ்திஷ்ட²தீதி ந ஸம்ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ஏதஸ்திந் தா³யூத³பி கதி²தவாந் யதா², ஸர்வ்வதா³ மம ஸாக்ஷாத்தம்ʼ ஸ்தா²பய பரமேஸ்²வரம்ʼ| ஸ்தி²தே மத்³த³க்ஷிணே தஸ்மிந் ஸ்க²லிஷ்யாமி த்வஹம்ʼ நஹி| ");
INSERT INTO santam_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ஆநந்தி³ஷ்யதி தத்³தே⁴தோ ர்மாமகீநம்ʼ மநஸ்து வை| ஆஹ்லாதி³ஷ்யதி ஜிஹ்வாபி மதீ³யா து ததை²வ ச| ப்ரத்யாஸ²யா ஸ²ரீரந்து மதீ³யம்ʼ வைஸ²யிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","பரலோகே யதோ ஹேதோஸ்த்வம்ʼ மாம்ʼ நைவ ஹி த்யக்ஷ்யஸி| ஸ்வகீயம்ʼ புண்யவந்தம்ʼ த்வம்ʼ க்ஷயிதும்ʼ நைவ தா³ஸ்யஸி| ஏவம்ʼ ஜீவநமார்க³ம்ʼ த்வம்ʼ மாமேவ த³ர்ஸ²யிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ஸ்வஸம்முகே² ய ஆநந்தோ³ த³க்ஷிணே ஸ்வஸ்ய யத் ஸுக²ம்ʼ| அநந்தம்ʼ தேந மாம்ʼ பூர்ணம்ʼ கரிஷ்யஸி ந ஸம்ʼஸ²ய​:|| ");
INSERT INTO santam_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ஹே ப்⁴ராதரோ(அ)ஸ்மாகம்ʼ தஸ்ய பூர்வ்வபுருஷஸ்ய தா³யூத³​: கதா²ம்ʼ ஸ்பஷ்டம்ʼ கத²யிதும்ʼ மாம் அநுமந்யத்⁴வம்ʼ, ஸ ப்ராணாந் த்யக்த்வா ஸ்²மஸா²நே ஸ்தா²பிதோப⁴வத்³ அத்³யாபி தத் ஸ்²மஸா²நம் அஸ்மாகம்ʼ ஸந்நிதௌ⁴ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ப²லதோ லௌகிகபா⁴வேந தா³யூதோ³ வம்ʼஸே² க்²ரீஷ்டம்ʼ ஜந்ம க்³ராஹயித்வா தஸ்யைவ ஸிம்ʼஹாஸநே ஸமுவேஷ்டும்ʼ தமுத்தா²பயிஷ்யதி பரமேஸ்²வர​: ஸ²பத²ம்ʼ குத்வா தா³யூத³​: ஸமீப இமம் அங்கீ³காரம்ʼ க்ருʼதவாந், ");
INSERT INTO santam_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","இதி ஜ்ஞாத்வா தா³யூத்³ ப⁴விஷ்யத்³வாதீ³ ஸந் ப⁴விஷ்யத்காலீயஜ்ஞாநேந க்²ரீஷ்டோத்தா²நே கதா²மிமாம்ʼ கத²யாமாஸ யதா² தஸ்யாத்மா பரலோகே ந த்யக்ஷ்யதே தஸ்ய ஸ²ரீரஞ்ச ந க்ஷேஷ்யதி; ");
INSERT INTO santam_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","அத​: பரமேஸ்²வர ஏநம்ʼ யீஸு²ம்ʼ ஸ்²மஸா²நாத்³ உத³ஸ்தா²பயத் தத்ர வயம்ʼ ஸர்வ்வே ஸாக்ஷிண ஆஸ்மஹே| ");
INSERT INTO santam_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ஸ ஈஸ்²வரஸ்ய த³க்ஷிணகரேணோந்நதிம்ʼ ப்ராப்ய பவித்ர ஆத்மிந பிதா யமங்கீ³காரம்ʼ க்ருʼதவாந் தஸ்ய ப²லம்ʼ ப்ராப்ய யத் பஸ்²யத² ஸ்²ருʼணுத² ச தத³வர்ஷத்| ");
INSERT INTO santam_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","யதோ தா³யூத்³ ஸ்வர்க³ம்ʼ நாருரோஹ கிந்து ஸ்வயம் இமாம்ʼ கதா²ம் அகத²யத்³ யதா², மம ப்ரபு⁴மித³ம்ʼ வாக்யமவத³த் பரமேஸ்²வர​:| ");
INSERT INTO santam_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","தவ ஸ²த்ரூநஹம்ʼ யாவத் பாத³பீட²ம்ʼ கரோமி ந| தாவத் காலம்ʼ மதீ³யே த்வம்ʼ த³க்ஷவார்ஸ்²வ உபாவிஸ²| ");
INSERT INTO santam_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","அதோ யம்ʼ யீஸு²ம்ʼ யூயம்ʼ க்ருஸே²(அ)ஹத பரமேஸ்²வரஸ்தம்ʼ ப்ரபு⁴த்வாபி⁴ஷிக்தத்வபதே³ ந்யயும்ʼக்தேதி இஸ்ராயேலீயா லோகா நிஸ்²சிதம்ʼ ஜாநந்து| ");
INSERT INTO santam_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ஏதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ ஸ்²ருத்வா தேஷாம்ʼ ஹ்ருʼத³யாநாம்ʼ விதீ³ர்ணத்வாத் தே பிதராய தத³ந்யப்ரேரிதேப்⁴யஸ்²ச கதி²தவந்த​:, ஹே ப்⁴ராத்ருʼக³ண வயம்ʼ கிம்ʼ கரிஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","தத​: பிதர​: ப்ரத்யவத³த்³ யூயம்ʼ ஸர்வ்வே ஸ்வம்ʼ ஸ்வம்ʼ மந​: பரிவர்த்தயத்⁴வம்ʼ ததா² பாபமோசநார்த²ம்ʼ யீஸு²க்²ரீஷ்டஸ்ய நாம்நா மஜ்ஜிதாஸ்²ச ப⁴வத, தஸ்மாத்³ தா³நரூபம்ʼ பரித்ரம் ஆத்மாநம்ʼ லப்ஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","யதோ யுஷ்மாகம்ʼ யுஷ்மத்ஸந்தாநாநாஞ்ச தூ³ரஸ்த²ஸர்வ்வலோகாநாஞ்ச நிமித்தம் அர்தா²த்³ அஸ்மாகம்ʼ ப்ரபு⁴​: பரமேஸ்²வரோ யாவதோ லாகாந் ஆஹ்வாஸ்யதி தேஷாம்ʼ ஸர்வ்வேஷாம்ʼ நிமித்தம் அயமங்கீ³கார ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ஏதத³ந்யாபி⁴ ர்ப³ஹுகதா²பி⁴​: ப்ரமாணம்ʼ த³த்வாகத²யத் ஏதேப்⁴யோ விபத²கா³மிப்⁴யோ வர்த்தமாநலோகேப்⁴ய​: ஸ்வாந் ரக்ஷத| ");
INSERT INTO santam_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","தத​: பரம்ʼ யே ஸாநந்தா³ஸ்தாம்ʼ கதா²ம் அக்³ருʼஹ்லந் தே மஜ்ஜிதா அப⁴வந்| தஸ்மிந் தி³வஸே ப்ராயேண த்ரீணி ஸஹஸ்ராணி லோகாஸ்தேஷாம்ʼ ஸபக்ஷா​: ஸந்த​: ");
INSERT INTO santam_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ப்ரேரிதாநாம் உபதே³ஸே² ஸங்க³தௌ பூபப⁴ஞ்ஜநே ப்ரார்த²நாஸு ச மந​:ஸம்ʼயோக³ம்ʼ க்ருʼத்வாதிஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ப்ரேரிதை ர்நாநாப்ரகாரலக்ஷணேஷு மஹாஸ்²சர்ய்யகர்மமஸு ச த³ர்ஸி²தேஷு ஸர்வ்வலோகாநாம்ʼ ப⁴யமுபஸ்தி²தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","விஸ்²வாஸகாரிண​: ஸர்வ்வ ச ஸஹ திஷ்ட²நத​:| ஸ்வேஷாம்ʼ ஸர்வ்வா​: ஸம்பத்தீ​: ஸாதா⁴ரண்யேந ஸ்தா²பயித்வாபு⁴ஞ்ஜத| ");
INSERT INTO santam_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ப²லதோ க்³ருʼஹாணி த்³ரவ்யாணி ச ஸர்வ்வாணி விக்ரீய ஸர்வ்வேஷாம்ʼ ஸ்வஸ்வப்ரயோஜநாநுஸாரேண விப⁴ஜ்ய ஸர்வ்வேப்⁴யோ(அ)த³த³ந்| ");
INSERT INTO santam_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ஸர்வ்வ ஏகசித்தீபூ⁴ய தி³நே தி³நே மந்தி³ரே ஸந்திஷ்ட²மாநா க்³ருʼஹே க்³ருʼஹே ச பூபாநப⁴ஞ்ஜந்த ஈஸ்²வரஸ்ய த⁴ந்யவாத³ம்ʼ குர்வ்வந்தோ லோகை​: ஸமாத்³ருʼதா​: பரமாநந்தே³ந ஸரலாந்த​:கரணேந போ⁴ஜநம்ʼ பாநஞ்சகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","பரமேஸ்²வரோ தி³நே தி³நே பரித்ராணபா⁴ஜநை ர்மண்ட³லீம் அவர்த்³த⁴யத்| ");
INSERT INTO santam_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","த்ருʼதீயயாமவேலாயாம்ʼ ஸத்யாம்ʼ ப்ரார்த²நாயா​: ஸமயே பிதரயோஹநௌ ஸம்பூ⁴ய மந்தி³ரம்ʼ க³ச்ச²த​:| ");
INSERT INTO santam_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","தஸ்மிந்நேவ ஸமயே மந்தி³ரப்ரவேஸ²காநாம்ʼ ஸமீபே பி⁴க்ஷாரணார்த²ம்ʼ யம்ʼ ஜந்மக²ஞ்ஜமாநுஷம்ʼ லோகா மந்தி³ரஸ்ய ஸுந்த³ரநாம்நி த்³வாரே ப்ரதிதி³நம் அஸ்தா²பயந் தம்ʼ வஹந்தஸ்தத்³வாரம்ʼ ஆநயந்| ");
INSERT INTO santam_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ததா³ பிதரயோஹநௌ மந்திரம்ʼ ப்ரவேஷ்டும் உத்³யதௌ விலோக்ய ஸ க²ஞ்ஜஸ்தௌ கிஞ்சித்³ பி⁴க்ஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","தஸ்மாத்³ யோஹநா ஸஹித​: பிதரஸ்தம் அநந்யத்³ருʼஷ்ட்யா நிரீக்ஷ்ய ப்ரோக்தவாந் ஆவாம்ʼ ப்ரதி த்³ருʼஷ்டிம்ʼ குரு| ");
INSERT INTO santam_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","தத​: ஸ கிஞ்சித் ப்ராப்த்யாஸ²யா தௌ ப்ரதி த்³ருʼஷ்டிம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ததா³ பிதரோ க³தி³தவாந் மம நிகடே ஸ்வர்ணரூப்யாதி³ கிமபி நாஸ்தி கிந்து யதா³ஸ்தே தத்³ த³தா³மி நாஸரதீயஸ்ய யீஸு²க்²ரீஷ்டஸ்ய நாம்நா த்வமுத்தா²ய க³மநாக³மநே குரு| ");
INSERT INTO santam_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","தத​: பரம்ʼ ஸ தஸ்ய த³க்ஷிணகரம்ʼ த்⁴ருʼத்வா தம் உத³தோலயத்; தேந தத்க்ஷணாத் தஸ்ய ஜநஸ்ய பாத³கு³ல்ப²யோ​: ஸப³லத்வாத் ஸ உல்லம்ப்²ய ப்ரோத்தா²ய க³மநாக³மநே (அ)கரோத்| ");
INSERT INTO santam_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ததோ க³மநாக³மநே குர்வ்வந் உல்லம்ப²ந் ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந் தாப்⁴யாம்ʼ ஸார்த்³த⁴ம்ʼ மந்தி³ரம்ʼ ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","தத​: ஸர்வ்வே லோகாஸ்தம்ʼ க³மநாக³மநே குர்வ்வந்தம் ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந்தஞ்ச விலோக்ய ");
INSERT INTO santam_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","மந்தி³ரஸ்ய ஸுந்த³ரே த்³வாரே ய உபவிஸ்²ய பி⁴க்ஷிதவாந் ஸஏவாயம் இதி ஜ்ஞாத்வா தம்ʼ ப்ரதி தயா க⁴டநயா சமத்க்ருʼதா விஸ்மயாபந்நாஸ்²சாப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ய​: க²ஞ்ஜ​: ஸ்வஸ்தோ²ப⁴வத் தேந பிதரயோஹநோ​: கரயோர்த்⁴டதயோ​: ஸதோ​: ஸர்வ்வே லோகா ஸந்நிதி⁴ம் ஆக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","தத்³ த்³ருʼஷ்ட்வா பிதரஸ்தேப்⁴யோ(அ)கத²யத், ஹே இஸ்ராயேலீயலோகா யூயம்ʼ குதோ (அ)நேநாஸ்²சர்ய்யம்ʼ மந்யத்⁴வே? ஆவாம்ʼ நிஜஸ²க்த்யா யத்³வா நிஜபுண்யேந க²ஞ்ஜமநுஷ்யமேநம்ʼ க³மிதவந்தாவிதி சிந்தயித்வா ஆவாம்ʼ ப்ரதி குதோ(அ)நந்யத்³ருʼஷ்டிம்ʼ குருத²? ");
INSERT INTO santam_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","யம்ʼ யீஸு²ம்ʼ யூயம்ʼ பரகரேஷு ஸமார்பயத ததோ யம்ʼ பீலாதோ மோசயிதும் ஏैச்ச²த் ததா²பி யூயம்ʼ தஸ்ய ஸாக்ஷாந் நாங்கீ³க்ருʼதவந்த இப்³ராஹீம இஸ்ஹாகோ யாகூப³ஸ்²சேஸ்²வரோ(அ)ர்தா²த்³ அஸ்மாகம்ʼ பூர்வ்வபுருஷாணாம் ஈஸ்²வர​: ஸ்வபுத்ரஸ்ய தஸ்ய யீஸோ² ர்மஹிமாநம்ʼ ப்ராகாஸ²யத்| ");
INSERT INTO santam_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","கிந்து யூயம்ʼ தம்ʼ பவித்ரம்ʼ தா⁴ர்ம்மிகம்ʼ புமாம்ʼஸம்ʼ நாங்கீ³க்ருʼத்ய ஹத்யாகாரிணமேகம்ʼ ஸ்வேப்⁴யோ தா³தும் அயாசத்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","பஸ்²சாத் தம்ʼ ஜீவநஸ்யாதி⁴பதிம் அஹத கிந்த்வீஸ்²வர​: ஸ்²மஸா²நாத் தம் உத³ஸ்தா²பயத தத்ர வயம்ʼ ஸாக்ஷிண ஆஸ்மஹே| ");
INSERT INTO santam_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","இமம்ʼ யம்ʼ மாநுஷம்ʼ யூயம்ʼ பஸ்²யத² பரிசிநுத² ச ஸ தஸ்ய நாம்நி விஸ்²வாஸகரணாத் சலநஸ²க்திம்ʼ லப்³த⁴வாந் தஸ்மிந் தஸ்ய யோ விஸ்²வாஸ​: ஸ தம்ʼ யுஷ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ ஸாக்ஷாத் ஸம்பூர்ணரூபேண ஸ்வஸ்த²ம் அகார்ஷீத்| ");
INSERT INTO santam_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ஹே ப்⁴ராதரோ யூயம்ʼ யுஷ்மாகம் அதி⁴பதயஸ்²ச அஜ்ஞாத்வா கர்ம்மாண்யேதாநி க்ருʼதவந்த இதா³நீம்ʼ மமைஷ போ³தோ⁴ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","கிந்த்வீஸ்²வர​: க்²ரீஷ்டஸ்ய து³​:க²போ⁴கே³ ப⁴விஷ்யத்³வாதி³நாம்ʼ முகே²ப்⁴யோ யாம்ʼ யாம்ʼ கதா²ம்ʼ பூர்வ்வமகத²யத் தா​: கதா² இத்த²ம்ʼ ஸித்³தா⁴ அகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","அத​: ஸ்வேஷாம்ʼ பாபமோசநார்த²ம்ʼ கே²த³ம்ʼ க்ருʼத்வா மநாம்ʼஸி பரிவர்த்தயத்⁴வம்ʼ, தஸ்மாத்³ ஈஸ்²வராத் ஸாந்த்வநாப்ராப்தே​: ஸமய உபஸ்தா²ஸ்யதி; ");
INSERT INTO santam_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","புநஸ்²ச பூர்வ்வகாலம் ஆரப்⁴ய ப்ரசாரிதோ யோ யீஸு²க்²ரீஷ்டஸ்தம் ஈஸ்²வரோ யுஷ்மாந் ப்ரதி ப்ரேஷயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","கிந்து ஜக³த​: ஸ்ருʼஷ்டிமாரப்⁴ய ஈஸ்²வரோ நிஜபவித்ரப⁴விஷ்யத்³வாதி³க³ணோந யதா² கதி²தவாந் தத³நுஸாரேண ஸர்வ்வேஷாம்ʼ கார்ய்யாணாம்ʼ ஸித்³தி⁴பர்ய்யந்தம்ʼ தேந ஸ்வர்கே³ வாஸ​: கர்த்தவ்ய​:| ");
INSERT INTO santam_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","யுஷ்மாகம்ʼ ப்ரபு⁴​: பரமேஸ்²வரோ யுஷ்மாகம்ʼ ப்⁴ராத்ருʼக³ணமத்⁴யாத் மத்ஸத்³ருʼஸ²ம்ʼ ப⁴விஷ்யத்³வக்தாரம் உத்பாத³யிஷ்யதி, தத​: ஸ யத் கிஞ்சித் கத²யிஷ்யதி தத்ர யூயம்ʼ மநாம்ʼஸி நித⁴த்³த்⁴வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","கிந்து ய​: கஸ்²சித் ப்ராணீ தஸ்ய ப⁴விஷ்யத்³வாதி³ந​: கதா²ம்ʼ ந க்³ரஹீஷ்யதி ஸ நிஜலோகாநாம்ʼ மத்⁴யாத்³ உச்சே²த்ஸ்யதே,\" இமாம்ʼ கதா²ம் அஸ்மாகம்ʼ பூர்வ்வபுருஷேப்⁴ய​: கேவலோ மூஸா​: கத²யாமாஸ இதி நஹி, ");
INSERT INTO santam_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ஸி²மூயேல்ப⁴விஷ்யத்³வாதி³நம் ஆரப்⁴ய யாவந்தோ ப⁴விஷ்யத்³வாக்யம் அகத²யந் தே ஸர்வ்வஏவ ஸமயஸ்யைதஸ்ய கதா²ம் அகத²யந்| ");
INSERT INTO santam_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","யூயமபி தேஷாம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ ஸந்தாநா​:, \"தவ வம்ʼஸோ²த்³ப⁴வபும்ʼஸா ஸர்வ்வதே³ஸீ²யா லோகா ஆஸி²ஷம்ʼ ப்ராப்தா ப⁴விஷ்யந்தி\", இப்³ராஹீமே கதா²மேதாம்ʼ கத²யித்வா ஈஸ்²வரோஸ்மாகம்ʼ பூர்வ்வபுருஷை​: ஸார்த்³த⁴ம்ʼ யம்ʼ நியமம்ʼ ஸ்தி²ரீக்ருʼதவாந் தஸ்ய நியமஸ்யாதி⁴காரிணோபி யூயம்ʼ ப⁴வத²| ");
INSERT INTO santam_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","அத ஈஸ்²வரோ நிஜபுத்ரம்ʼ யீஸு²ம் உத்தா²ப்ய யுஷ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ ஸ்வஸ்வபாபாத் பராவர்த்த்ய யுஷ்மப்⁴யம் ஆஸி²ஷம்ʼ தா³தும்ʼ ப்ரத²மதஸ்தம்ʼ யுஷ்மாகம்ʼ நிகடம்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","யஸ்மிந் ஸமயே பிதரயோஹநௌ லோகாந் உபதி³ஸ²தஸ்தஸ்மிந் ஸமயே யாஜகா மந்தி³ரஸ்ய ஸேநாபதய​: ஸிதூ³கீக³ணஸ்²ச ");
INSERT INTO santam_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","தயோர் உபதே³ஸ²கரணே க்²ரீஷ்டஸ்யோத்தா²நம் உபலக்ஷ்ய ஸர்வ்வேஷாம்ʼ ம்ருʼதாநாம் உத்தா²நப்ரஸ்தாவே ச வ்யக்³ரா​: ஸந்தஸ்தாவுபாக³மந்| ");
INSERT INTO santam_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","தௌ த்⁴ருʼத்வா தி³நாவஸாநகாரணாத் பரதி³நபர்ய்யநந்தம்ʼ ருத்³த்⁴வா ஸ்தா²பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ததா²பி யே லோகாஸ்தயோருபதே³ஸ²ம் அஸ்²ருʼண்வந் தேஷாம்ʼ ப்ராயேண பஞ்சஸஹஸ்ராணி ஜநா வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","பரே(அ)ஹநி அதி⁴பதய​: ப்ராசீநா அத்⁴யாபகாஸ்²ச ஹாநநநாமா மஹாயாஜக​: ");
INSERT INTO santam_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","கியபா² யோஹந் ஸிகந்த³ர இத்யாத³யோ மஹாயாஜகஸ்ய ஜ்ஞாதய​: ஸர்வ்வே யிரூஸா²லம்நக³ரே மிலிதா​:| ");
INSERT INTO santam_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","அநந்தரம்ʼ ப்ரேரிதௌ மத்⁴யே ஸ்தா²பயித்வாப்ருʼச்ச²ந் யுவாம்ʼ கயா ஸ²க்தயா வா கேந நாம்நா கர்ம்மாண்யேதாநி குருத²​:? ");
INSERT INTO santam_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ததா³ பிதர​: பவித்ரேணாத்மநா பரிபூர்ண​: ஸந் ப்ரத்யவாதீ³த், ஹே லோகாநாம் அதி⁴பதிக³ண ஹே இஸ்ராயேலீயப்ராசீநா​:, ");
INSERT INTO santam_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ஏதஸ்ய து³ர்ப்³ப³லமாநுஷஸ்ய ஹிதம்ʼ யத் கர்ம்மாக்ரியத, அர்தா²த், ஸ யேந ப்ரகாரேண ஸ்வஸ்தோ²ப⁴வத் தச்சேத்³ அத்³யாவாம்ʼ ப்ருʼச்ச²த², ");
INSERT INTO santam_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","தர்ஹி ஸர்வ்வ இஸ்ராயேेலீயலோகா யூயம்ʼ ஜாநீத நாஸரதீயோ யோ யீஸு²க்²ரீஷ்ட​: க்ருஸே² யுஷ்மாபி⁴ரவித்⁴யத யஸ்²சேஸ்²வரேண ஸ்²மஸா²நாத்³ உத்தா²பித​:, தஸ்ய நாம்நா ஜநோயம்ʼ ஸ்வஸ்த²​: ஸந் யுஷ்மாகம்ʼ ஸம்முகே² ப்ரோத்திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","நிசேத்ருʼபி⁴ ர்யுஷ்மாபி⁴ரயம்ʼ ய​: ப்ரஸ்தரோ(அ)வஜ்ஞாதோ(அ)ப⁴வத் ஸ ப்ரதா⁴நகோணஸ்ய ப்ரஸ்தரோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","தத்³பி⁴ந்நாத³பராத் கஸ்மாத³பி பரித்ராணம்ʼ ப⁴விதும்ʼ ந ஸ²க்நோதி, யேந த்ராணம்ʼ ப்ராப்யேத பூ⁴மண்ட³லஸ்யலோகாநாம்ʼ மத்⁴யே தாத்³ருʼஸ²ம்ʼ கிமபி நாம நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ததா³ பிதரயோஹநோரேதாத்³ருʼஸீ²ம் அக்ஷேப⁴தாம்ʼ த்³ருʼஷ்ட்வா தாவவித்³வாம்ʼஸௌ நீசலோகாவிதி பு³த்³த்⁴வா ஆஸ்²சர்ய்யம் அமந்யந்த தௌ ச யீஸோ²​: ஸங்கி³நௌ ஜாதாவிதி ஜ்ஞாதும் அஸ²க்நுவந்| ");
INSERT INTO santam_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","கிந்து தாப்⁴யாம்ʼ ஸார்த்³த⁴ம்ʼ தம்ʼ ஸ்வஸ்த²மாநுஷம்ʼ திஷ்ட²ந்தம்ʼ த்³ருʼஷ்ட்வா தே காமப்யபராம் ஆபத்திம்ʼ கர்த்தம்ʼ நாஸ²க்நுந்| ");
INSERT INTO santam_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ததா³ தே ஸபா⁴த​: ஸ்தா²நாந்தரம்ʼ க³ந்தும்ʼ தாந் ஆஜ்ஞாப்ய ஸ்வயம்ʼ பரஸ்பரம் இதி மந்த்ரணாமகுர்வ்வந் ");
INSERT INTO santam_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","தௌ மாநவௌ ப்ரதி கிம்ʼ கர்த்தவ்யம்ʼ? தாவேகம்ʼ ப்ரஸித்³த⁴ம் ஆஸ்²சர்ய்யம்ʼ கர்ம்ம க்ருʼதவந்தௌ தத்³ யிரூஸா²லம்நிவாஸிநாம்ʼ ஸர்வ்வேஷாம்ʼ லோகாநாம்ʼ ஸமீபே ப்ராகாஸ²த தச்ச வயமபஹ்நோதும்ʼ ந ஸ²க்நும​:| ");
INSERT INTO santam_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","கிந்து லோகாநாம்ʼ மத்⁴யம் ஏதத்³ யதா² ந வ்யாப்நோதி தத³ர்த²ம்ʼ தௌ ப⁴யம்ʼ ப்ரத³ர்ஸ்²ய தேந நாம்நா கமபி மநுஷ்யம்ʼ நோபதி³ஸ²தம் இதி த்³ருʼட⁴ம்ʼ நிஷேதா⁴ம​:| ");
INSERT INTO santam_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ததஸ்தே ப்ரேரிதாவாஹூய ஏததா³ஜ்ஞாபயந் இத​: பரம்ʼ யீஸோ² ர்நாம்நா கதா³பி காமபி கதா²ம்ʼ மா கத²யதம்ʼ கிமபி நோபதி³ஸ²ஞ்ச| ");
INSERT INTO santam_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","தத​: பிதரயோஹநௌ ப்ரத்யவத³தாம் ஈஸ்²வரஸ்யாஜ்ஞாக்³ரஹணம்ʼ வா யுஷ்மாகம் ஆஜ்ஞாக்³ரஹணம் ஏதயோ ர்மத்⁴யே ஈஸ்²வரஸ்ய கோ³சரே கிம்ʼ விஹிதம்ʼ? யூயம்ʼ தஸ்ய விவேசநாம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","வயம்ʼ யத்³ அபஸ்²யாம யத³ஸ்²ருʼணும ச தந்ந ப்ரசாரயிஷ்யாம ஏதத் கதா³பி ப⁴விதும்ʼ ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","யத³க⁴டத தத்³ த்³ருʼஷ்டா ஸர்வ்வே லோகா ஈஸ்²வரஸ்ய கு³ணாந் அந்வவத³ந் தஸ்மாத் லோகப⁴யாத் தௌ த³ண்ட³யிதும்ʼ கமப்யுபாயம்ʼ ந ப்ராப்ய தே புநரபி தர்ஜயித்வா தாவத்யஜந்| ");
INSERT INTO santam_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","யஸ்ய மாநுஷஸ்யைதத் ஸ்வாஸ்த்²யகரணம் ஆஸ்²சர்ய்யம்ʼ கர்ம்மாக்ரியத தஸ்ய வயஸ்²சத்வாரிம்ʼஸ²த்³வத்ஸரா வ்யதீதா​:| ");
INSERT INTO santam_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","தத​: பரம்ʼ தௌ விஸ்ருʼஷ்டௌ ஸந்தௌ ஸ்வஸங்கி³நாம்ʼ ஸந்நிதி⁴ம்ʼ க³த்வா ப்ரதா⁴நயாஜகை​: ப்ராசீநலோகைஸ்²ச ப்ரோக்தா​: ஸர்வ்வா​: கதா² ஜ்ஞாபிதவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","தச்ச்²ருத்வா ஸர்வ்வ ஏகசித்தீபூ⁴ய ஈஸ்²வரமுத்³தி³ஸ்²ய ப்ரோச்சைரேதத் ப்ரார்த²யந்த, ஹே ப்ரபோ⁴ க³க³ணப்ருʼதி²வீபயோதீ⁴நாம்ʼ தேஷு ச யத்³யத்³ ஆஸ்தே தேஷாம்ʼ ஸ்ரஷ்டேஸ்²வரஸ்த்வம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","த்வம்ʼ நிஜஸேவகேந தா³யூதா³ வாக்யமித³ம் உவசித², மநுஷ்யா அந்யதே³ஸீ²யா​: குர்வ்வந்தி கலஹம்ʼ குத​:| லோகா​: ஸர்வ்வே கிமர்த²ம்ʼ வா சிந்தாம்ʼ குர்வ்வந்தி நிஷ்ப²லாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","பரமேஸ²ஸ்ய தேநைவாபி⁴ஷிக்தஸ்ய ஜநஸ்ய ச| விருத்³த⁴மபி⁴திஷ்ட²ந்தி ப்ருʼதி²வ்யா​: பதய​: குத​:|| ");
INSERT INTO santam_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ப²லதஸ்தவ ஹஸ்தேந மந்த்ரணயா ச பூர்வ்வ யத்³யத் ஸ்தி²ரீக்ருʼதம்ʼ தத்³ யதா² ஸித்³த⁴ம்ʼ ப⁴வதி தத³ர்த²ம்ʼ த்வம்ʼ யம் அதி²ஷிக்தவாந் ஸ ஏவ பவித்ரோ யீஸு²ஸ்தஸ்ய ப்ராதிகூல்யேந ஹேரோத்³ பந்தீயபீலாதோ ");
INSERT INTO santam_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","(அ)ந்யதே³ஸீ²யலோகா இஸ்ராயேல்லோகாஸ்²ச ஸர்வ்வ ஏதே ஸபா⁴யாம் அதிஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ஹே பரமேஸ்²வர அது⁴நா தேஷாம்ʼ தர்ஜநம்ʼ க³ர்ஜநஞ்ச ஸ்²ருʼணு; ");
INSERT INTO santam_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ததா² ஸ்வாஸ்த்²யகரணகர்ம்மணா தவ பா³ஹுப³லப்ரகாஸ²பூர்வ்வகம்ʼ தவ ஸேவகாந் நிர்ப⁴யேந தவ வாக்யம்ʼ ப்ரசாரயிதும்ʼ தவ பவித்ரபுத்ரஸ்ய யீஸோ² ர்நாம்நா ஆஸ்²சர்ய்யாண்யஸம்ப⁴வாநி ச கர்ம்மாணி கர்த்துஞ்சாஜ்ஞாபய| ");
INSERT INTO santam_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","இத்த²ம்ʼ ப்ரார்த²நயா யத்ர ஸ்தா²நே தே ஸபா⁴யாம் ஆஸந் தத் ஸ்தா²நம்ʼ ப்ராகம்பத; தத​: ஸர்வ்வே பவித்ரேணாத்மநா பரிபூர்ணா​: ஸந்த ஈஸ்²வரஸ்ய கதா²ம் அக்ஷோபே⁴ண ப்ராசாரயந்| ");
INSERT INTO santam_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","அபரஞ்ச ப்ரத்யயகாரிலோகஸமூஹா ஏகமநஸ ஏகசித்தீபூ⁴ய ஸ்தி²தா​:| தேஷாம்ʼ கேபி நிஜஸம்பத்திம்ʼ ஸ்வீயாம்ʼ நாஜாநந் கிந்து தேஷாம்ʼ ஸர்வ்வா​: ஸம்பத்த்ய​: ஸாதா⁴ரண்யேந ஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","அந்யச்ச ப்ரேரிதா மஹாஸ²க்திப்ரகாஸ²பூர்வ்வகம்ʼ ப்ரபோ⁴ ர்யீஸோ²ருத்தா²நே ஸாக்ஷ்யம் அத³து³​:, தேஷு ஸர்வ்வேஷு மஹாநுக்³ரஹோ(அ)ப⁴வச்ச| ");
INSERT INTO santam_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","தேஷாம்ʼ மத்⁴யே கஸ்யாபி த்³ரவ்யந்யூநதா நாப⁴வத்³ யதஸ்தேஷாம்ʼ க்³ருʼஹபூ⁴ம்யாத்³யா யா​: ஸம்பத்தய ஆஸந் தா விக்ரீய ");
INSERT INTO santam_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","தந்மூல்யமாநீய ப்ரேரிதாநாம்ʼ சரணேஷு தை​: ஸ்தா²பிதம்ʼ; தத​: ப்ரத்யேகஸ²​: ப்ரயோஜநாநுஸாரேண த³த்தமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","விஸே²ஷத​: குப்ரோபத்³வீபீயோ யோஸிநாமகோ லேவிவம்ʼஸ²ஜாத ஏகோ ஜநோ பூ⁴ம்யதி⁴காரீ, யம்ʼ ப்ரேரிதா ப³ர்ணப்³பா³ அர்தா²த் ஸாந்த்வநாதா³யக இத்யுக்த்வா ஸமாஹூயந், ");
INSERT INTO santam_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ஸ ஜநோ நிஜபூ⁴மிம்ʼ விக்ரீய தந்மூல்யமாநீய ப்ரேரிதாநாம்ʼ சரணேஷு ஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ததா³ அநாநியநாமக ஏகோ ஜநோ யஸ்ய பா⁴ர்ய்யாயா நாம ஸபீ²ரா ஸ ஸ்வாதி⁴காரம்ʼ விக்ரீய ");
INSERT INTO santam_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ஸ்வபா⁴ர்ய்யாம்ʼ ஜ்ஞாபயித்வா தந்மூல்யஸ்யைகாம்ʼஸ²ம்ʼ ஸங்கோ³ப்ய ஸ்தா²பயித்வா தத³ந்யாம்ʼஸ²மாத்ரமாநீய ப்ரேரிதாநாம்ʼ சரணேஷு ஸமர்பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","தஸ்மாத் பிதரோகத²யத் ஹே அநாநிய பூ⁴மே ர்மூல்யம்ʼ கிஞ்சித் ஸங்கோ³ப்ய ஸ்தா²பயிதும்ʼ பவித்ரஸ்யாத்மந​: ஸந்நிதௌ⁴ ம்ருʼஷாவாக்யம்ʼ கத²யிதுஞ்ச ஸை²தாந் குதஸ்தவாந்த​:கரணே ப்ரவ்ருʼத்திமஜநயத்? ");
INSERT INTO santam_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ஸா பூ⁴மி ர்யதா³ தவ ஹஸ்தக³தா ததா³ கிம்ʼ தவ ஸ்வீயா நாஸீத்? தர்ஹி ஸ்வாந்த​:கரணே குத ஏதாத்³ருʼஸீ² குகல்பநா த்வயா க்ருʼதா? த்வம்ʼ கேவலமநுஷ்யஸ்ய நிகடே ம்ருʼஷாவாக்யம்ʼ நாவாதீ³​: கிந்த்வீஸ்²வரஸ்ய நிகடே(அ)பி| ");
INSERT INTO santam_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வைவ ஸோ(அ)நாநியோ பூ⁴மௌ பதந் ப்ராணாந் அத்யஜத், தத்³வ்ருʼத்தாந்தம்ʼ யாவந்தோ லோகா அஸ்²ருʼண்வந் தேஷாம்ʼ ஸர்வ்வேஷாம்ʼ மஹாப⁴யம் அஜாயத்| ");
INSERT INTO santam_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ததா³ யுவலோகாஸ்தம்ʼ வஸ்த்ரேணாச்சா²த்³ய ப³ஹி ர்நீத்வா ஸ்²மஸா²நே(அ)ஸ்தா²பயந்| ");
INSERT INTO santam_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","தத​: ப்ரஹரைகாநந்தரம்ʼ கிம்ʼ வ்ருʼத்தம்ʼ தந்நாவக³த்ய தஸ்ய பா⁴ர்ய்யாபி தத்ர ஸமுபஸ்தி²தா| ");
INSERT INTO santam_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","தத​: பிதரஸ்தாம் அப்ருʼச்ச²த், யுவாப்⁴யாம் ஏதாவந்முத்³ராப்⁴யோ பூ⁴மி ர்விக்ரீதா ந வா? ஏதத்வம்ʼ வத³; ததா³ ஸா ப்ரத்யவாதீ³த் ஸத்யம் ஏதாவத்³ப்⁴யோ முத்³ராப்⁴ய ஏவ| ");
INSERT INTO santam_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","தத​: பிதரோகத²யத் யுவாம்ʼ கத²ம்ʼ பரமேஸ்²வரஸ்யாத்மாநம்ʼ பரீக்ஷிதும் ஏகமந்த்ரணாவப⁴வதாம்ʼ? பஸ்²ய யே தவ பதிம்ʼ ஸ்²மஸா²நே ஸ்தா²பிதவந்தஸ்தே த்³வாரஸ்ய ஸமீபே ஸமுபதிஷ்ட²ந்தி த்வாமபி ப³ஹிர்நேஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","தத​: ஸாபி தஸ்ய சரணஸந்நிதௌ⁴ பதித்வா ப்ராணாந் அத்யாக்ஷீத்| பஸ்²சாத் தே யுவாநோ(அ)ப்⁴யந்தரம் ஆக³த்ய தாமபி ம்ருʼதாம்ʼ த்³ருʼஷ்ட்வா ப³ஹி ர்நீத்வா தஸ்யா​: பத்யு​: பார்ஸ்²வே ஸ்²மஸா²நே ஸ்தா²பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","தஸ்மாத் மண்ட³ல்யா​: ஸர்வ்வே லோகா அந்யலோகாஸ்²ச தாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வா ஸாத்⁴வஸம்ʼ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","தத​: பரம்ʼ ப்ரேரிதாநாம்ʼ ஹஸ்தை ர்லோகாநாம்ʼ மத்⁴யே ப³ஹ்வாஸ்²சர்ய்யாண்யத்³பு⁴தாநி கர்ம்மாண்யக்ரியந்த; ததா³ ஸி²ஷ்யா​: ஸர்வ்வ ஏகசித்தீபூ⁴ய ஸுலேமாநோ (அ)லிந்தே³ ஸம்பூ⁴யாஸந்| ");
INSERT INTO santam_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","தேஷாம்ʼ ஸங்கா⁴ந்தர்கோ³ ப⁴விதும்ʼ கோபி ப்ரக³ல்ப⁴தாம்ʼ நாக³மத் கிந்து லோகாஸ்தாந் ஸமாத்³ரியந்த| ");
INSERT INTO santam_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ஸ்த்ரிய​: புருஷாஸ்²ச ப³ஹவோ லோகா விஸ்²வாஸ்ய ப்ரபு⁴ம்ʼ ஸ²ரணமாபந்நா​:| ");
INSERT INTO santam_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","பிதரஸ்ய க³மநாக³மநாப்⁴யாம்ʼ கேநாபி ப்ரகாரேண தஸ்ய சா²யா கஸ்மிம்ʼஸ்²சிஜ்ஜநே லகி³ஷ்யதீத்யாஸ²யா லோகா ரோகி³ண​: ஸி²விகயா க²ட்வயா சாநீய பதி² பதி² ஸ்தா²பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","சதுர்தி³க்ஸ்த²நக³ரேப்⁴யோ ப³ஹவோ லோகா​: ஸம்பூ⁴ய ரோகி³ணோ(அ)பவித்ரபு⁴தக்³ரஸ்தாம்ʼஸ்²ச யிரூஸா²லமம் ஆநயந் தத​: ஸர்வ்வே ஸ்வஸ்தா² அக்ரியந்த| ");
INSERT INTO santam_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","அநந்தரம்ʼ மஹாயாஜக​: ஸிதூ³கிநாம்ʼ மதக்³ராஹிணஸ்தேஷாம்ʼ ஸஹசராஸ்²ச ");
INSERT INTO santam_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","மஹாக்ரோதா⁴ந்த்விதா​: ஸந்த​: ப்ரேரிதாந் த்⁴ருʼத்வா நீசலோகாநாம்ʼ காராயாம்ʼ ப³த்³த்⁴வா ஸ்தா²பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","கிந்து ராத்ரௌ பரமேஸ்²வரஸ்ய தூ³த​: காராயா த்³வாரம்ʼ மோசயித்வா தாந் ப³ஹிராநீயாகத²யத், ");
INSERT INTO santam_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","யூயம்ʼ க³த்வா மந்தி³ரே த³ண்டா³யமாநா​: ஸந்தோ லோகாந் ப்ரதீமாம்ʼ ஜீவநதா³யிகாம்ʼ ஸர்வ்வாம்ʼ கதா²ம்ʼ ப்ரசாரயத| ");
INSERT INTO santam_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","இதி ஸ்²ருத்வா தே ப்ரத்யூஷே மந்தி³ர உபஸ்தா²ய உபதி³ஷ்டவந்த​:| ததா³ ஸஹசரக³ணேந ஸஹிதோ மஹாயாஜக ஆக³த்ய மந்த்ரிக³ணம் இஸ்ராயேல்வம்ʼஸ²ஸ்ய ஸர்வ்வாந் ராஜஸபா⁴ஸத³​: ஸபா⁴ஸ்தா²ந் க்ருʼத்வா காராயாஸ்தாந் ஆபயிதும்ʼ பதா³திக³ணம்ʼ ப்ரேரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ததஸ்தே க³த்வா காராயாம்ʼ தாந் அப்ராப்ய ப்ரத்யாக³த்ய இதி வார்த்தாம் அவாதி³ஷு​:, ");
INSERT INTO santam_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","வயம்ʼ தத்ர க³த்வா நிர்வ்விக்⁴நம்ʼ காராயா த்³வாரம்ʼ ருத்³த⁴ம்ʼ ரக்ஷகாம்ʼஸ்²ச த்³வாரஸ்ய ப³ஹிர்த³ண்டா³யமாநாந் அத³ர்ஸா²ம ஏவ கிந்து த்³வாரம்ʼ மோசயித்வா தந்மத்⁴யே கமபி த்³ரஷ்டும்ʼ ந ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா மஹாயாஜகோ மந்தி³ரஸ்ய ஸேநாபதி​: ப்ரதா⁴நயாஜகாஸ்²ச, இத பரம்ʼ கிமபரம்ʼ ப⁴விஷ்யதீதி சிந்தயித்வா ஸந்தி³க்³த⁴சித்தா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ஏதஸ்மிந்நேவ ஸமயே கஸ்²சித் ஜந ஆக³த்ய வார்த்தாமேதாம் அவத³த் பஸ்²யத யூயம்ʼ யாந் மாநவாந் காராயாம் அஸ்தா²பயத தே மந்தி³ரே திஷ்ட²ந்தோ லோகாந் உபதி³ஸ²ந்தி| ");
INSERT INTO santam_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ததா³ மந்தி³ரஸ்ய ஸேநாபதி​: பதா³தயஸ்²ச தத்ர க³த்வா சேல்லோகா​: பாஷாணாந் நிக்ஷிப்யாஸ்மாந் மாரயந்தீதி பி⁴யா விநத்யாசாரம்ʼ தாந் ஆநயந்| ");
INSERT INTO santam_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","தே மஹாஸபா⁴யா மத்⁴யே தாந் அஸ்தா²பயந் தத​: பரம்ʼ மஹாயாஜகஸ்தாந் அப்ருʼச்ச²த், ");
INSERT INTO santam_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","அநேந நாம்நா ஸமுபதே³ஷ்டும்ʼ வயம்ʼ கிம்ʼ த்³ருʼட⁴ம்ʼ ந ந்யஷேதா⁴ம? ததா²பி பஸ்²யத யூயம்ʼ ஸ்வேஷாம்ʼ தேநோபதே³ஸே²நே யிரூஸா²லமம்ʼ பரிபூர்ணம்ʼ க்ருʼத்வா தஸ்ய ஜநஸ்ய ரக்தபாதஜநிதாபராத⁴ம் அஸ்மாந் ப்ரத்யாநேதும்ʼ சேஷ்டத்⁴வே| ");
INSERT INTO santam_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","தத​: பிதரோந்யப்ரேரிதாஸ்²ச ப்ரத்யவத³ந் மாநுஷஸ்யாஜ்ஞாக்³ரஹணாத்³ ஈஸ்²வரஸ்யாஜ்ஞாக்³ரஹணம் அஸ்மாகமுசிதம்| ");
INSERT INTO santam_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","யம்ʼ யீஸு²ம்ʼ யூயம்ʼ க்ருஸே² வேதி⁴த்வாஹத தம் அஸ்மாகம்ʼ பைத்ருʼக ஈஸ்²வர உத்தா²ப்ய ");
INSERT INTO santam_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","இஸ்ராயேல்வம்ʼஸா²நாம்ʼ மந​:பரிவர்த்தநம்ʼ பாபக்ஷமாஞ்ச கர்த்தும்ʼ ராஜாநம்ʼ பரித்ராதாரஞ்ச க்ருʼத்வா ஸ்வத³க்ஷிணபார்ஸ்²வே தஸ்யாந்நதிம் அகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ஏதஸ்மிந் வயமபி ஸாக்ஷிண ஆஸ்மஹே, தத் கேவலம்ʼ நஹி, ஈஸ்²வர ஆஜ்ஞாக்³ராஹிப்⁴யோ யம்ʼ பவித்ரம் ஆத்மநம்ʼ த³த்தவாந் ஸோபி ஸாக்ஷ்யஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ஏதத்³வாக்யே ஸ்²ருதே தேஷாம்ʼ ஹ்ருʼத³யாநி வித்³தா⁴ந்யப⁴வந் ததஸ்தே தாந் ஹந்தும்ʼ மந்த்ரிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ஏதஸ்மிந்நேவ ஸமயே தத்ஸபா⁴ஸ்தா²நாம்ʼ ஸர்வ்வலோகாநாம்ʼ மத்⁴யே ஸுக்²யாதோ க³மிலீயேல்நாமக ஏகோ ஜநோ வ்யவஸ்தா²பக​: பி²ரூஸி²லோக உத்தா²ய ப்ரேரிதாந் க்ஷணார்த²ம்ʼ ஸ்தா²நாந்தரம்ʼ க³ந்தும் ஆதி³ஸ்²ய கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ஹே இஸ்ராயேல்வம்ʼஸீ²யா​: ஸர்வ்வே யூயம் ஏதாந் மாநுஷாந் ப்ரதி யத் கர்த்தும் உத்³யதாஸ்தஸ்மிந் ஸாவதா⁴நா ப⁴வத| ");
INSERT INTO santam_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","இத​: பூர்வ்வம்ʼ தூ²தா³நாமைகோ ஜந உபஸ்தா²ய ஸ்வம்ʼ கமபி மஹாபுருஷம் அவத³த், தத​: ப்ராயேண சது​:ஸ²தலோகாஸ்தஸ்ய மதக்³ராஹிணோப⁴வந் பஸ்²சாத் ஸ ஹதோப⁴வத் தஸ்யாஜ்ஞாக்³ராஹிணோ யாவந்தோ லோகாஸ்தே ஸர்வ்வே விர்கீர்ணா​: ஸந்தோ (அ)க்ருʼதகார்ய்யா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","தஸ்மாஜ்ஜநாத் பரம்ʼ நாமலேக²நஸமயே கா³லீலீயயிஹூதா³நாமைகோ ஜந உபஸ்தா²ய ப³ஹூல்லோகாந் ஸ்வமதம்ʼ க்³ராஹீதவாந் தத​: ஸோபி வ்யநஸ்²யத் தஸ்யாஜ்ஞாக்³ராஹிணோ யாவந்தோ லோகா ஆஸந் தே ஸர்வ்வே விகீர்ணா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","அது⁴நா வதா³மி, யூயம் ஏதாந் மநுஷ்யாந் ப்ரதி கிமபி ந க்ருʼத்வா க்ஷாந்தா ப⁴வத, யத ஏஷ ஸங்கல்ப ஏதத் கர்ம்ம ச யதி³ மநுஷ்யாத³ப⁴வத் தர்ஹி விப²லம்ʼ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","யதீ³ஸ்²வராத³ப⁴வத் தர்ஹி யூயம்ʼ தஸ்யாந்யதா² கர்த்தும்ʼ ந ஸ²க்ஷ்யத², வரம் ஈஸ்²வரரோத⁴கா ப⁴விஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ததா³ தஸ்ய மந்த்ரணாம்ʼ ஸ்வீக்ருʼத்ய தே ப்ரேரிதாந் ஆஹூய ப்ரஹ்ருʼத்ய யீஸோ² ர்நாம்நா காமபி கதா²ம்ʼ கத²யிதும்ʼ நிஷித்⁴ய வ்யஸர்ஜந்| ");
INSERT INTO santam_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","கிந்து தஸ்ய நாமார்த²ம்ʼ வயம்ʼ லஜ்ஜாபோ⁴க³ஸ்ய யோக்³யத்வேந க³ணிதா இத்யத்ர தே ஸாநந்தா³​: ஸந்த​: ஸபா⁴ஸ்தா²நாம்ʼ ஸாக்ஷாத்³ அக³ச்ச²ந்| ");
INSERT INTO santam_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","தத​: பரம்ʼ ப்ரதிதி³நம்ʼ மந்தி³ரே க்³ருʼஹே க்³ருʼஹே சாவிஸ்²ராமம் உபதி³ஸ்²ய யீஸு²க்²ரீஷ்டஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","தஸ்மிந் ஸமயே ஸி²ஷ்யாணாம்ʼ பா³ஹுல்யாத் ப்ராத்யஹிகதா³நஸ்ய விஸ்²ராணநை ர்பி⁴ந்நதே³ஸீ²யாநாம்ʼ வித⁴வாஸ்த்ரீக³ண உபேக்ஷிதே ஸதி இப்³ரீயலோகை​: ஸஹாந்யதே³ஸீ²யாநாம்ʼ விவாத³ உபாதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ததா³ த்³வாத³ஸ²ப்ரேரிதா​: ஸர்வ்வாந் ஸி²ஷ்யாந் ஸம்ʼக்³ருʼஹ்யாகத²யந் ஈஸ்²வரஸ்ய கதா²ப்ரசாரம்ʼ பரித்யஜ்ய போ⁴ஜநக³வேஷணம் அஸ்மாகம் உசிதம்ʼ நஹி| ");
INSERT INTO santam_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","அதோ ஹே ப்⁴ராத்ருʼக³ண வயம் ஏதத்கர்ம்மணோ பா⁴ரம்ʼ யேப்⁴யோ தா³தும்ʼ ஸ²க்நும ஏதாத்³ருʼஸா²ந் ஸுக்²யாத்யாபந்நாந் பவித்ரேணாத்மநா ஜ்ஞாநேந ச பூர்ணாந் ஸப்ப்ரஜநாந் யூயம்ʼ ஸ்வேஷாம்ʼ மத்⁴யே மநோநீதாந் குருத, ");
INSERT INTO santam_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","கிந்து வயம்ʼ ப்ரார்த²நாயாம்ʼ கதா²ப்ரசாரகர்ம்மணி ச நித்யப்ரவ்ருʼத்தா​: ஸ்தா²ஸ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ஏதஸ்யாம்ʼ கதா²யாம்ʼ ஸர்வ்வே லோகா​: ஸந்துஷ்டா​: ஸந்த​: ஸ்வேஷாம்ʼ மத்⁴யாத் ஸ்திபா²ந​: பி²லிப​: ப்ரக²ரோ நிகாநோர் தீமந் பர்ம்மிணா யிஹூதி³மதக்³ராஹீ-ஆந்தியகி²யாநக³ரீயோ நிகலா ஏதாந் பரமப⁴க்தாந் பவித்ரேணாத்மநா பரிபூர்ணாந் ஸப்த ஜநாந் ");
INSERT INTO santam_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ப்ரேரிதாநாம்ʼ ஸமக்ஷம் ஆநயந், ததஸ்தே ப்ரார்த²நாம்ʼ க்ருʼத்வா தேஷாம்ʼ ஸி²ர​:ஸு ஹஸ்தாந் ஆர்பயந்| ");
INSERT INTO santam_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","அபரஞ்ச ஈஸ்²வரஸ்ய கதா² தே³ஸ²ம்ʼ வ்யாப்நோத் விஸே²ஷதோ யிரூஸா²லமி நக³ரே ஸி²ஷ்யாணாம்ʼ ஸம்ʼக்²யா ப்ரபூ⁴தரூபேணாவர்த்³த⁴த யாஜகாநாம்ʼ மத்⁴யேபி ப³ஹவ​: க்²ரீஷ்டமதக்³ராஹிணோ(அ)ப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ஸ்திபா²நோे விஸ்²வாஸேந பராக்ரமேண ச பரிபூர்ண​: ஸந் லோகாநாம்ʼ மத்⁴யே ப³ஹுவித⁴ம் அத்³பு⁴தம் ஆஸ்²சர்ய்யம்ʼ கர்ம்மாகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","தேந லிப³ர்த்திநீயநாம்நா விக்²யாதஸங்க⁴ஸ்ய கதிபயஜநா​: குரீணீயஸிகந்த³ரீய-கிலிகீயாஸீ²யாதே³ஸீ²யா​: கியந்தோ ஜநாஸ்²சோத்தா²ய ஸ்திபா²நேந ஸார்த்³த⁴ம்ʼ வ்யவத³ந்த| ");
INSERT INTO santam_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","கிந்து ஸ்திபா²நோ ஜ்ஞாநேந பவித்ரேணாத்மநா ச ஈத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ கதி²தவாந் யஸ்யாஸ்தே ஆபத்திம்ʼ கர்த்தும்ʼ நாஸ²க்நுவந்| ");
INSERT INTO santam_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","பஸ்²சாத் தை ர்லோபி⁴தா​: கதிபயஜநா​: கதா²மேநாம் அகத²யந், வயம்ʼ தஸ்ய முக²தோ மூஸா ஈஸ்²வரஸ்ய ச நிந்தா³வாக்யம் அஸ்²ரௌஷ்ம| ");
INSERT INTO santam_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","தே லோகாநாம்ʼ லோகப்ராசீநாநாம் அத்⁴யாபகாநாஞ்ச ப்ரவ்ருʼத்திம்ʼ ஜநயித்வா ஸ்திபா²நஸ்ய ஸந்நிதி⁴ம் ஆக³த்ய தம்ʼ த்⁴ருʼத்வா மஹாஸபா⁴மத்⁴யம் ஆநயந்| ");
INSERT INTO santam_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","தத³நந்தரம்ʼ கதிபயஜநேஷு மித்²யாஸாக்ஷிஷு ஸமாநீதேஷு தே(அ)கத²யந் ஏஷ ஜந ஏதத்புண்யஸ்தா²நவ்யவஸ்த²யோ ர்நிந்தா³த​: கதா³பி ந நிவர்த்ததே| ");
INSERT INTO santam_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ப²லதோ நாஸரதீயயீஸு²​: ஸ்தா²நமேதத்³ உச்சி²ந்நம்ʼ கரிஷ்யதி மூஸாஸமர்பிதம் அஸ்மாகம்ʼ வ்யவஹரணம் அந்யரூபம்ʼ கரிஷ்யதி தஸ்யைதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ வயம் அஸ்²ருʼணும| ");
INSERT INTO santam_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ததா³ மஹாஸபா⁴ஸ்தா²​: ஸர்வ்வே தம்ʼ ப்ரதி ஸ்தி²ராம்ʼ த்³ருʼஷ்டிம்ʼ க்ருʼத்வா ஸ்வர்க³தூ³தமுக²ஸத்³ருʼஸ²ம்ʼ தஸ்ய முக²ம் அபஸ்²யந்| ");
INSERT INTO santam_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","தத​: பரம்ʼ மஹாயாஜக​: ப்ருʼஷ்டவாந், ஏஷா கதா²ம்ʼ கிம்ʼ ஸத்யா? ");
INSERT INTO santam_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","தத​: ஸ ப்ரத்யவத³த், ஹே பிதரோ ஹே ப்⁴ராதர​: ஸர்வ்வே லாகா மநாம்ʼஸி நித⁴த்³த்⁴வம்ʼ| அஸ்மாகம்ʼ பூர்வ்வபுருஷ இப்³ராஹீம் ஹாரண்நக³ரே வாஸகரணாத் பூர்வ்வம்ʼ யதா³ அராம்-நஹரயிமதே³ஸே² ஆஸீத் ததா³ தேஜோமய ஈஸ்²வரோ த³ர்ஸ²நம்ʼ த³த்வா ");
INSERT INTO santam_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","தமவத³த் த்வம்ʼ ஸ்வதே³ஸ²ஜ்ஞாதிமித்ராணி பரித்யஜ்ய யம்ʼ தே³ஸ²மஹம்ʼ த³ர்ஸ²யிஷ்யாமி தம்ʼ தே³ஸ²ம்ʼ வ்ரஜ| ");
INSERT INTO santam_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","அத​: ஸ கஸ்தீ³யதே³ஸ²ம்ʼ விஹாய ஹாரண்நக³ரே ந்யவஸத், தத³நந்தரம்ʼ தஸ்ய பிதரி ம்ருʼதே யத்ர தே³ஸே² யூயம்ʼ நிவஸத² ஸ ஏநம்ʼ தே³ஸ²மாக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","கிந்த்வீஸ்²வரஸ்தஸ்மை கமப்யதி⁴காரம் அர்தா²த்³ ஏகபத³பரிமிதாம்ʼ பூ⁴மிமபி நாத³தா³த்; ததா³ தஸ்ய கோபி ஸந்தாநோ நாஸீத் ததா²பி ஸந்தாநை​: ஸார்த்³த⁴ம் ஏதஸ்ய தே³ஸ²ஸ்யாதி⁴காரீ த்வம்ʼ ப⁴விஷ்யஸீதி தம்ப்ரத்யங்கீ³க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ஈஸ்²வர இத்த²ம் அபரமபி கதி²தவாந் தவ ஸந்தாநா​: பரதே³ஸே² நிவத்ஸ்யந்தி ததஸ்தத்³தே³ஸீ²யலோகாஸ்²சது​:ஸ²தவத்ஸராந் யாவத் தாந் தா³ஸத்வே ஸ்தா²பயித்வா தாந் ப்ரதி குவ்யவஹாரம்ʼ கரிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","அபரம் ஈஸ்²வர ஏநாம்ʼ கதா²மபி கதி²தவாந், யே லோகாஸ்தாந் தா³ஸத்வே ஸ்தா²பயிஷ்யந்தி தால்லோகாந் அஹம்ʼ த³ண்ட³யிஷ்யாமி, தத​: பரம்ʼ தே ப³ஹிர்க³தா​: ஸந்தோ மாம் அத்ர ஸ்தா²நே ஸேவிஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","பஸ்²சாத் ஸ தஸ்மை த்வக்சே²த³ஸ்ய நியமம்ʼ த³த்தவாந், அத இஸ்ஹாகநாம்நி இப்³ராஹீம ஏகபுத்ரே ஜாதே, அஷ்டமதி³நே தஸ்ய த்வக்சே²த³ம் அகரோத்| தஸ்ய இஸ்ஹாக​: புத்ரோ யாகூப்³, ததஸ்தஸ்ய யாகூபோ³(அ)ஸ்மாகம்ʼ த்³வாத³ஸ² பூர்வ்வபுருஷா அஜாயந்த| ");
INSERT INTO santam_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","தே பூர்வ்வபுருஷா ஈர்ஷ்யயா பரிபூர்ணா மிஸரதே³ஸ²ம்ʼ ப்ரேஷயிதும்ʼ யூஷப²ம்ʼ வ்யக்ரீணந்| ");
INSERT INTO santam_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","கிந்த்வீஸ்²வரஸ்தஸ்ய ஸஹாயோ பூ⁴த்வா ஸர்வ்வஸ்யா து³ர்க³தே ரக்ஷித்வா தஸ்மை பு³த்³தி⁴ம்ʼ த³த்த்வா மிஸரதே³ஸ²ஸ்ய ராஜ்ஞ​: பி²ரௌண​: ப்ரியபாத்ரம்ʼ க்ருʼதவாந் ததோ ராஜா மிஸரதே³ஸ²ஸ்ய ஸ்வீயஸர்வ்வபரிவாரஸ்ய ச ஸா²ஸநபத³ம்ʼ தஸ்மை த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","தஸ்மிந் ஸமயே மிஸர-கிநாநதே³ஸ²யோ ர்து³ர்பி⁴க்ஷஹேதோரதிக்லிஷ்டத்வாத் ந​: பூர்வ்வபுருஷா ப⁴க்ஷ்யத்³ரவ்யம்ʼ நாலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","கிந்து மிஸரதே³ஸே² ஸ²ஸ்யாநி ஸந்தி, யாகூப்³ இமாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வா ப்ரத²மம் அஸ்மாகம்ʼ பூர்வ்வபுருஷாந் மிஸரம்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ததோ த்³விதீயவாரக³மநே யூஷப்² ஸ்வப்⁴ராத்ருʼபி⁴​: பரிசிதோ(அ)ப⁴வத்; யூஷபோ² ப்⁴ராதர​: பி²ரௌண் ராஜேந பரிசிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","அநந்தரம்ʼ யூஷப்² ப்⁴ராத்ருʼக³ணம்ʼ ப்ரேஷ்ய நிஜபிதரம்ʼ யாகூப³ம்ʼ நிஜாந் பஞ்சாதி⁴கஸப்ததிஸம்ʼக்²யகாந் ஜ்ஞாதிஜநாம்ʼஸ்²ச ஸமாஹூதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","தஸ்மாத்³ யாகூப்³ மிஸரதே³ஸ²ம்ʼ க³த்வா ஸ்வயம் அஸ்மாகம்ʼ பூர்வ்வபுருஷாஸ்²ச தஸ்மிந் ஸ்தா²நே(அ)ம்ரியந்த| ");
INSERT INTO santam_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ததஸ்தே ஸி²கி²மம்ʼ நீதா யத் ஸ்²மஸா²நம் இப்³ராஹீம் முத்³ராத³த்வா ஸி²கி²ம​: பிது ர்ஹமோர​: புத்ரேப்⁴ய​: க்ரீதவாந் தத்ஸ்²மஸா²நே ஸ்தா²பயாஞ்சக்ரிரே| ");
INSERT INTO santam_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","தத​: பரம் ஈஸ்²வர இப்³ராஹீம​: ஸந்நிதௌ⁴ ஸ²பத²ம்ʼ க்ருʼத்வா யாம்ʼ ப்ரதிஜ்ஞாம்ʼ க்ருʼதவாந் தஸ்யா​: ப்ரதிஜ்ஞாயா​: ப²லநஸமயே நிகடே ஸதி இஸ்ராயேல்லோகா ஸிமரதே³ஸே² வர்த்³த⁴மாநா ப³ஹுஸம்ʼக்²யா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ஸே²ஷே யூஷப²ம்ʼ யோ ந பரிசிநோதி தாத்³ருʼஸ² ஏகோ நரபதிருபஸ்தா²ய ");
INSERT INTO santam_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","அஸ்மாகம்ʼ ஜ்ஞாதிபி⁴​: ஸார்த்³த⁴ம்ʼ தூ⁴ர்த்ததாம்ʼ விதா⁴ய பூர்வ்வபுருஷாந் ப்ரதி குவ்யவஹரணபூர்வ்வகம்ʼ தேஷாம்ʼ வம்ʼஸ²நாஸ²நாய தேஷாம்ʼ நவஜாதாந் ஸி²ஸூ²ந் ப³ஹி ர்நிரக்ஷேபயத்| ");
INSERT INTO santam_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ஏதஸ்மிந் ஸமயே மூஸா ஜஜ்ஞே, ஸ து பரமஸுந்த³ரோ(அ)ப⁴வத் ததா² பித்ருʼக்³ருʼஹே மாஸத்ரயபர்ய்யந்தம்ʼ பாலிதோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","கிந்து தஸ்மிந் ப³ஹிர்நிக்ஷிப்தே ஸதி பி²ரௌணராஜஸ்ய கந்யா தம் உத்தோல்ய நீத்வா த³த்தகபுத்ரம்ʼ க்ருʼத்வா பாலிதவதீ| ");
INSERT INTO santam_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","தஸ்மாத் ஸ மூஸா மிஸரதே³ஸீ²யாயா​: ஸர்வ்வவித்³யாயா​: பாரத்³ருʼஷ்வா ஸந் வாக்யே க்ரியாயாஞ்ச ஸ²க்திமாந் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ஸ ஸம்பூர்ணசத்வாரிம்ʼஸ²த்³வத்ஸரவயஸ்கோ பூ⁴த்வா இஸ்ராயேலீயவம்ʼஸ²நிஜப்⁴ராத்ருʼந் ஸாக்ஷாத் கர்தும்ʼ மதிம்ʼ சக்ரே| ");
INSERT INTO santam_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","தேஷாம்ʼ ஜநமேகம்ʼ ஹிம்ʼஸிதம்ʼ த்³ருʼஷ்ட்வா தஸ்ய ஸபக்ஷ​: ஸந் ஹிம்ʼஸிதஜநம் உபக்ருʼத்ய மிஸரீயஜநம்ʼ ஜகா⁴ந| ");
INSERT INTO santam_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","தஸ்ய ஹஸ்தேநேஸ்²வரஸ்தாந் உத்³த⁴ரிஷ்யதி தஸ்ய ப்⁴ராத்ருʼக³ண இதி ஜ்ஞாஸ்யதி ஸ இத்யநுமாநம்ʼ சகார, கிந்து தே ந பு³பு³தி⁴ரே| ");
INSERT INTO santam_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","தத்பரே (அ)ஹநி தேஷாம் உப⁴யோ ர்ஜநயோ ர்வாக்கலஹ உபஸ்தி²தே ஸதி மூஸா​: ஸமீபம்ʼ க³த்வா தயோ ர்மேலநம்ʼ கர்த்தும்ʼ மதிம்ʼ க்ருʼத்வா கத²யாமாஸ, ஹே மஹாஸ²யௌ யுவாம்ʼ ப்⁴ராதரௌ பரஸ்பரம் அந்யாயம்ʼ குத​: குருத²​:? ");
INSERT INTO santam_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","தத​: ஸமீபவாஸிநம்ʼ ப்ரதி யோ ஜநோ(அ)ந்யாயம்ʼ சகார ஸ தம்ʼ தூ³ரீக்ருʼத்ய கத²யாமாஸ, அஸ்மாகமுபரி ஸா²ஸ்த்ருʼத்வவிசாரயித்ருʼத்வபத³யோ​: கஸ்த்வாம்ʼ நியுக்தவாந்? ");
INSERT INTO santam_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ஹ்யோ யதா² மிஸரீயம்ʼ ஹதவாந் ததா² கிம்ʼ மாமபி ஹநிஷ்யஸி? ");
INSERT INTO santam_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ததா³ மூஸா ஏதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ ஸ்²ருத்வா பலாயநம்ʼ சக்ரே, ததோ மிதி³யநதே³ஸ²ம்ʼ க³த்வா ப்ரவாஸீ ஸந் தஸ்தௌ², ததஸ்தத்ர த்³வௌ புத்ரௌ ஜஜ்ஞாதே| ");
INSERT INTO santam_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","அநந்தரம்ʼ சத்வாரிம்ʼஸ²த்³வத்ஸரேஷு க³தேஷு ஸீநயபர்வ்வதஸ்ய ப்ராந்தரே ப்ரஜ்வலிதஸ்தம்ப³ஸ்ய வஹ்நிஸி²கா²யாம்ʼ பரமேஸ்²வரதூ³தஸ்தஸ்மை த³ர்ஸ²நம்ʼ த³தௌ³| ");
INSERT INTO santam_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","மூஸாஸ்தஸ்மிந் த³ர்ஸ²நே விஸ்மயம்ʼ மத்வா விஸே²ஷம்ʼ ஜ்ஞாதும்ʼ நிகடம்ʼ க³ச்ச²தி, ");
INSERT INTO santam_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ஏதஸ்மிந் ஸமயே, அஹம்ʼ தவ பூர்வ்வபுருஷாணாம் ஈஸ்²வரோ(அ)ர்தா²த்³ இப்³ராஹீம ஈஸ்²வர இஸ்ஹாக ஈஸ்²வரோ யாகூப³ ஈஸ்²வரஸ்²ச, மூஸாமுத்³தி³ஸ்²ய பரமேஸ்²வரஸ்யைதாத்³ருʼஸீ² விஹாயஸீயா வாணீ ப³பூ⁴வ, தத​: ஸ கம்பாந்வித​: ஸந் புந ர்நிரீக்ஷிதும்ʼ ப்ரக³ல்போ⁴ ந ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","பரமேஸ்²வரஸ்தம்ʼ ஜகா³த³, தவ பாத³யோ​: பாது³கே மோசய யத்ர திஷ்ட²ஸி ஸா பவித்ரபூ⁴மி​:| ");
INSERT INTO santam_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","அஹம்ʼ மிஸரதே³ஸ²ஸ்தா²நாம்ʼ நிஜலோகாநாம்ʼ து³ர்த்³த³ஸா²ம்ʼ நிதாந்தம் அபஸ்²யம்ʼ, தேஷாம்ʼ காதர்ய்யோக்திஞ்ச ஸ்²ருதவாந் தஸ்மாத் தாந் உத்³த⁴ர்த்தும் அவருஹ்யாக³மம்; இதா³நீம் ஆக³ச்ச² மிஸரதே³ஸ²ம்ʼ த்வாம்ʼ ப்ரேஷயாமி| ");
INSERT INTO santam_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","கஸ்த்வாம்ʼ ஸா²ஸ்த்ருʼத்வவிசாரயித்ருʼத்வபத³யோ ர்நியுக்தவாந், இதி வாக்யமுக்த்வா தை ர்யோ மூஸா அவஜ்ஞாதஸ்தமேவ ஈஸ்²வர​: ஸ்தம்ப³மத்⁴யே த³ர்ஸ²நதா³த்ரா தேந தூ³தேந ஸா²ஸ்தாரம்ʼ முக்திதா³தாரஞ்ச க்ருʼத்வா ப்ரேஷயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ஸ ச மிஸரதே³ஸே² ஸூப்²நாம்நி ஸமுத்³ரே ச பஸ்²சாத் சத்வாரிம்ʼஸ²த்³வத்ஸராந் யாவத் மஹாப்ராந்தரே நாநாப்ரகாராண்யத்³பு⁴தாநி கர்ம்மாணி லக்ஷணாநி ச த³ர்ஸ²யித்வா தாந் ப³ஹி​: க்ருʼத்வா ஸமாநிநாய| ");
INSERT INTO santam_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ப்ரபு⁴​: பரமேஸ்²வரோ யுஷ்மாகம்ʼ ப்⁴ராத்ருʼக³ணஸ்ய மத்⁴யே மாத்³ருʼஸ²ம் ஏகம்ʼ ப⁴விஷ்யத்³வக்தாரம் உத்பாத³யிஷ்யதி தஸ்ய கதா²யாம்ʼ யூயம்ʼ மநோ நிதா⁴ஸ்யத², யோ ஜந இஸ்ராயேல​: ஸந்தாநேப்⁴ய ஏநாம்ʼ கதா²ம்ʼ கத²யாமாஸ ஸ ஏஷ மூஸா​:| ");
INSERT INTO santam_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","மஹாப்ராந்தரஸ்த²மண்ட³லீமத்⁴யே(அ)பி ஸ ஏவ ஸீநயபர்வ்வதோபரி தேந ஸார்த்³த⁴ம்ʼ ஸம்ʼலாபிநோ தூ³தஸ்ய சாஸ்மத்பித்ருʼக³ணஸ்ய மத்⁴யஸ்த²​: ஸந் அஸ்மப்⁴யம்ʼ தா³தவ்யநி ஜீவநதா³யகாநி வாக்யாநி லேபே⁴| ");
INSERT INTO santam_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","அஸ்மாகம்ʼ பூர்வ்வபுருஷாஸ்தம் அமாந்யம்ʼ கத்வா ஸ்வேப்⁴யோ தூ³ரீக்ருʼத்ய மிஸரதே³ஸ²ம்ʼ பராவ்ருʼத்ய க³ந்தும்ʼ மநோபி⁴ரபி⁴லஷ்ய ஹாரோணம்ʼ ஜக³து³​:, ");
INSERT INTO santam_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","அஸ்மாகம் அக்³ரே(அ)க்³ரே க³ந்துुம் அஸ்மத³ர்த²ம்ʼ தே³வக³ணம்ʼ நிர்ம்மாஹி யதோ யோ மூஸா அஸ்மாந் மிஸரதே³ஸா²த்³ ப³ஹி​: க்ருʼத்வாநீதவாந் தஸ்ய கிம்ʼ ஜாதம்ʼ தத³ஸ்மாபி⁴ ர்ந ஜ்ஞாயதே| ");
INSERT INTO santam_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","தஸ்மிந் ஸமயே தே கோ³வத்ஸாக்ருʼதிம்ʼ ப்ரதிமாம்ʼ நிர்ம்மாய தாமுத்³தி³ஸ்²ய நைவேத்³யமுத்ம்ருʼஜ்ய ஸ்வஹஸ்தக்ருʼதவஸ்துநா ஆநந்தி³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","தஸ்மாத்³ ஈஸ்²வரஸ்தேஷாம்ʼ ப்ரதி விமுக²​: ஸந் ஆகாஸ²ஸ்த²ம்ʼ ஜ்யோதிர்க³ணம்ʼ பூஜயிதும்ʼ தேப்⁴யோ(அ)நுமதிம்ʼ த³தௌ³, யாத்³ருʼஸ²ம்ʼ ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு லிகி²தமாஸ்தே, யதா², இஸ்ராயேலீயவம்ʼஸா² ரே சத்வாரிம்ʼஸ²த்ஸமாந் புரா| மஹதி ப்ராந்தரே ஸம்ʼஸ்தா² யூயந்து யாநி ச| ப³லிஹோமாதி³கர்ம்மாணி க்ருʼதவந்தஸ்து தாநி கிம்ʼ| மாம்ʼ ஸமுத்³தி³ஸ்²ய யுஷ்மாபி⁴​: ப்ரக்ருʼதாநீதி நைவ ச| ");
INSERT INTO santam_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","கிந்து வோ மோலகாக்²யஸ்ய தே³வஸ்ய தூ³ஷ்யமேவ ச| யுஷ்மாகம்ʼ ரிம்ப²நாக்²யாயா தே³வதாயாஸ்²ச தாரகா| ஏதயோருப⁴யோ ர்மூர்தீ யுஷ்மாபி⁴​: பரிபூஜிதே| அதோ யுஷ்மாம்ʼஸ்து பா³பே³ல​: பாரம்ʼ நேஷ்யாமி நிஸ்²சிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","அபரஞ்ச யந்நித³ர்ஸ²நம் அபஸ்²யஸ்தத³நுஸாரேண தூ³ஷ்யம்ʼ நிர்ம்மாஹி யஸ்மிந் ஈஸ்²வரோ மூஸாம் ஏதத்³வாக்யம்ʼ ப³பா⁴ஷே தத் தஸ்ய நிரூபிதம்ʼ ஸாக்ஷ்யஸ்வரூபம்ʼ தூ³ஷ்யம் அஸ்மாகம்ʼ பூர்வ்வபுருஷை​: ஸஹ ப்ராந்தரே தஸ்தௌ²| ");
INSERT INTO santam_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","பஸ்²சாத் யிஹோஸூ²யேந ஸஹிதைஸ்தேஷாம்ʼ வம்ʼஸ²ஜாதைரஸ்மத்பூர்வ்வபுருஷை​: ஸ்வேஷாம்ʼ ஸம்முகா²த்³ ஈஸ்²வரேண தூ³ரீக்ருʼதாநாம் அந்யதே³ஸீ²யாநாம்ʼ தே³ஸா²தி⁴க்ருʼதிகாலே ஸமாநீதம்ʼ தத்³ தூ³ஷ்யம்ʼ தா³யூதோ³தி⁴காரம்ʼ யாவத் தத்ர ஸ்தா²ந ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ஸ தா³யூத்³ பரமேஸ்²வரஸ்யாநுக்³ரஹம்ʼ ப்ராப்ய யாகூப்³ ஈஸ்²வரார்த²ம் ஏகம்ʼ தூ³ஷ்யம்ʼ நிர்ம்மாதும்ʼ வவாஞ்ச²; ");
INSERT INTO santam_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","கிந்து ஸுலேமாந் தத³ர்த²ம்ʼ மந்தி³ரம் ஏகம்ʼ நிர்ம்மிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ததா²பி ய​: ஸர்வ்வோபரிஸ்த²​: ஸ கஸ்மிம்ʼஸ்²சித்³ ஹஸ்தக்ருʼதே மந்தி³ரே நிவஸதீதி நஹி, ப⁴விஷ்யத்³வாதீ³ கதா²மேதாம்ʼ கத²யதி, யதா², ");
INSERT INTO santam_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","பரேஸோ² வத³தி ஸ்வர்கோ³ ராஜஸிம்ʼஹாஸநம்ʼ மம| மதீ³யம்ʼ பாத³பீட²ஞ்ச ப்ருʼதி²வீ ப⁴வதி த்⁴ருவம்ʼ| தர்ஹி யூயம்ʼ க்ருʼதே மே கிம்ʼ ப்ரநிர்ம்மாஸ்யத² மந்தி³ரம்ʼ| விஸ்²ராமாய மதீ³யம்ʼ வா ஸ்தா²நம்ʼ கிம்ʼ வித்³யதே த்விஹ| ");
INSERT INTO santam_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ஸர்வ்வாண்யேதாநி வஸ்தூநி கிம்ʼ மே ஹஸ்தக்ருʼதாநி ந|| ");
INSERT INTO santam_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ஹே அநாஜ்ஞாக்³ராஹகா அந்த​:கரணே ஸ்²ரவணே சாபவித்ரலோகா​: யூயம் அநவரதம்ʼ பவித்ரஸ்யாத்மந​: ப்ராதிகூல்யம் ஆசரத², யுஷ்மாகம்ʼ பூர்வ்வபுருஷா யாத்³ருʼஸா² யூயமபி தாத்³ருʼஸா²​:| ");
INSERT INTO santam_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","யுஷ்மாகம்ʼ பூர்வ்வபுருஷா​: கம்ʼ ப⁴விஷ்யத்³வாதி³நம்ʼ நாதாட³யந்? யே தஸ்ய தா⁴ர்ம்மிகஸ்ய ஜநஸ்யாக³மநகதா²ம்ʼ கதி²தவந்தஸ்தாந் அக்⁴நந் யூயம் அதூ⁴நா விஸ்²வாஸகா⁴திநோ பூ⁴த்வா தம்ʼ தா⁴ர்ம்மிகம்ʼ ஜநம் அஹத| ");
INSERT INTO santam_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","யூயம்ʼ ஸ்வர்கீ³யதூ³தக³ணேந வ்யவஸ்தா²ம்ʼ ப்ராப்யாபி தாம்ʼ நாசரத²| ");
INSERT INTO santam_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","இமாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா தே மந​:ஸு பி³த்³தா⁴​: ஸந்தஸ்தம்ʼ ப்ரதி த³ந்தக⁴ர்ஷணம் அகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","கிந்து ஸ்திபா²ந​: பவித்ரேணாத்மநா பூர்ணோ பூ⁴த்வா க³க³ணம்ʼ ப்ரதி ஸ்தி²ரத்³ருʼஷ்டிம்ʼ க்ருʼத்வா ஈஸ்²வரஸ்ய த³க்ஷிணே த³ண்டா³யமாநம்ʼ யீஸு²ஞ்ச விலோக்ய கதி²தவாந்; ");
INSERT INTO santam_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","பஸ்²ய,மேக⁴த்³வாரம்ʼ முக்தம் ஈஸ்²வரஸ்ய த³க்ஷிணே ஸ்தி²தம்ʼ மாநவஸுதஞ்ச பஸ்²யாமி| ");
INSERT INTO santam_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ததா³ தே ப்ரோச்சை​: ஸ²ப்³த³ம்ʼ க்ருʼத்வா கர்ணேஷ்வங்கு³லீ ர்நிதா⁴ய ஏகசித்தீபூ⁴ய தம் ஆக்ரமந்| ");
INSERT INTO santam_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","பஸ்²சாத் தம்ʼ நக³ராத்³ ப³ஹி​: க்ருʼத்வா ப்ரஸ்தரைராக்⁴நந் ஸாக்ஷிணோ லாகா​: ஸௌ²லநாம்நோ யூநஸ்²சரணஸந்நிதௌ⁴ நிஜவஸ்த்ராணி ஸ்தா²பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","அநந்தரம்ʼ ஹே ப்ரபோ⁴ யீஸே² மதீ³யமாத்மாநம்ʼ க்³ருʼஹாண ஸ்திபா²நஸ்யேதி ப்ரார்த²நவாக்யவத³நஸமயே தே தம்ʼ ப்ரஸ்தரைராக்⁴நந்| ");
INSERT INTO santam_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","தஸ்மாத் ஸ ஜாநுநீ பாதயித்வா ப்ரோச்சை​: ஸ²ப்³த³ம்ʼ க்ருʼத்வா, ஹே ப்ரபே⁴ பாபமேதத்³ ஏதேஷு மா ஸ்தா²பய, இத்யுக்த்வா மஹாநித்³ராம்ʼ ப்ராப்நோத்| ");
INSERT INTO santam_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","தஸ்ய ஹத்யாகரணம்ʼ ஸௌ²லோபி ஸமமந்யத| தஸ்மிந் ஸமயே யிரூஸா²லம்நக³ரஸ்தா²ம்ʼ மண்ட³லீம்ʼ ப்ரதி மஹாதாட³நாயாம்ʼ ஜாதாயாம்ʼ ப்ரேரிதலோகாந் ஹித்வா ஸர்வ்வே(அ)பரே யிஹூதா³ஸோ²மிரோணதே³ஸ²யோ ர்நாநாஸ்தா²நே விகீர்ணா​: ஸந்தோ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","அந்யச்ச ப⁴க்தலோகாஸ்தம்ʼ ஸ்திபா²நம்ʼ ஸ்²மஸா²நே ஸ்தா²பயித்வா ப³ஹு வ்யலபந்| ");
INSERT INTO santam_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","கிந்து ஸௌ²லோ க்³ருʼஹே க்³ருʼஹே ப்⁴ரமித்வா ஸ்த்ரிய​: புருஷாம்ʼஸ்²ச த்⁴ருʼத்வா காராயாம்ʼ ப³த்³த்⁴வா மண்ட³ல்யா மஹோத்பாதம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","அந்யச்ச யே விகீர்ணா அப⁴வந் தே ஸர்வ்வத்ர ப்⁴ரமித்வா ஸுஸம்ʼவாத³ம்ʼ ப்ராசாரயந்| ");
INSERT INTO santam_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ததா³ பி²லிப​: ஸோ²மிரோண்நக³ரம்ʼ க³த்வா க்²ரீஷ்டாக்²யாநம்ʼ ப்ராசாரயத்; ");
INSERT INTO santam_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ததோ(அ)ஸு²சி-ப்⁴ருʼதக்³ரஸ்தலோகேப்⁴யோ பூ⁴தாஸ்²சீத்க்ருʼத்யாக³ச்ச²ந் ததா² ப³ஹவ​: பக்ஷாகா⁴திந​: க²ஞ்ஜா லோகாஸ்²ச ஸ்வஸ்தா² அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","தஸ்மாத் லாகா ஈத்³ருʼஸ²ம்ʼ தஸ்யாஸ்²சர்ய்யம்ʼ கர்ம்ம விலோக்ய நிஸ²ம்ய ச ஸர்வ்வ ஏகசித்தீபூ⁴ய தேநோக்தாக்²யாநே மநாம்ʼஸி ந்யத³து⁴​:| ");
INSERT INTO santam_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","தஸ்மிந்நக³ரே மஹாநந்த³ஸ்²சாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","தத​: பூர்வ்வம்ʼ தஸ்மிந்நக³ரே ஸி²மோந்நாமா கஸ்²சிஜ்ஜநோ ப³ஹ்வீ ர்மாயாக்ரியா​: க்ருʼத்வா ஸ்வம்ʼ கஞ்சந மஹாபுருஷம்ʼ ப்ரோச்ய ஸோ²மிரோணீயாநாம்ʼ மோஹம்ʼ ஜநயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","தஸ்மாத் ஸ மாநுஷ ஈஸ்²வரஸ்ய மஹாஸ²க்திஸ்வரூப இத்யுக்த்வா பா³லவ்ருʼத்³த⁴வநிதா​: ஸர்வ்வே லாகாஸ்தஸ்மிந் மநாம்ʼஸி ந்யத³து⁴​:| ");
INSERT INTO santam_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ஸ ப³ஹுகாலாந் மாயாவிக்ரியயா ஸர்வ்வாந் அதீவ மோஹயாஞ்சகார, தஸ்மாத் தே தம்ʼ மேநிரே| ");
INSERT INTO santam_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","கிந்த்வீஸ்²வரஸ்ய ராஜ்யஸ்ய யீஸு²க்²ரீஷ்டஸ்ய நாம்நஸ்²சாக்²யாநப்ரசாரிண​: பி²லிபஸ்ய கதா²யாம்ʼ விஸ்²வஸ்ய தேஷாம்ʼ ஸ்த்ரீபுருஷோப⁴யலோகா மஜ்ஜிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ஸே²ஷே ஸ ஸி²மோநபி ஸ்வயம்ʼ ப்ரத்யைத் ததோ மஜ்ஜித​: ஸந் பி²லிபேந க்ருʼதாம் ஆஸ்²சர்ய்யக்ரியாம்ʼ லக்ஷணஞ்ச விலோக்யாஸம்ப⁴வம்ʼ மந்யமாநஸ்தேந ஸஹ ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","இத்த²ம்ʼ ஸோ²மிரோண்தே³ஸீ²யலோகா ஈஸ்²வரஸ்ய கதா²ம் அக்³ருʼஹ்லந் இதி வார்த்தாம்ʼ யிரூஸா²லம்நக³ரஸ்த²ப்ரேரிதா​: ப்ராப்ய பிதரம்ʼ யோஹநஞ்ச தேஷாம்ʼ நிகடே ப்ரேஷிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ததஸ்தௌ தத் ஸ்தா²நம் உபஸ்தா²ய லோகா யதா² பவித்ரம் ஆத்மாநம்ʼ ப்ராப்நுவந்தி தத³ர்த²ம்ʼ ப்ரார்த²யேதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","யதஸ்தே புரா கேவலப்ரபு⁴யீஸோ² ர்நாம்நா மஜ்ஜிதமாத்ரா அப⁴வந், ந து தேஷாம்ʼ மத்⁴யே கமபி ப்ரதி பவித்ரஸ்யாத்மந ஆவிர்பா⁴வோ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","கிந்து ப்ரேரிதாப்⁴யாம்ʼ தேஷாம்ʼ கா³த்ரேஷு கரேஷ்வர்பிதேஷு ஸத்ஸு தே பவித்ரம் ஆத்மாநம் ப்ராப்நுவந்| ");
INSERT INTO santam_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","இத்த²ம்ʼ லோகாநாம்ʼ கா³த்ரேஷு ப்ரேரிதயோ​: கரார்பணேந தாந் பவித்ரம் ஆத்மாநம்ʼ ப்ராப்தாந் த்³ருʼஷ்ட்வா ஸ ஸி²மோந் தயோ​: ஸமீபே முத்³ரா ஆநீய கதி²தவாந்; ");
INSERT INTO santam_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","அஹம்ʼ யஸ்ய கா³த்ரே ஹஸ்தம் அர்பயிஷ்யாமி தஸ்யாபி யதே²த்த²ம்ʼ பவித்ராத்மப்ராப்தி ர்ப⁴வதி தாத்³ருʼஸீ²ம்ʼ ஸ²க்திம்ʼ மஹ்யம்ʼ த³த்தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","கிந்து பிதரஸ்தம்ʼ ப்ரத்யவத³த் தவ முத்³ராஸ்த்வயா விநஸ்²யந்து யத ஈஸ்²வரஸ்ய தா³நம்ʼ முத்³ராபி⁴​: க்ரீயதே த்வமித்த²ம்ʼ பு³த்³த⁴வாந்; ");
INSERT INTO santam_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ஈஸ்²வராய தாவந்த​:கரணம்ʼ ஸரலம்ʼ நஹி, தஸ்மாத்³ அத்ர தவாம்ʼஸோ²(அ)தி⁴காரஸ்²ச கோபி நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","அத ஏதத்பாபஹேதோ​: கே²தா³ந்வித​: ஸந் கேநாபி ப்ரகாரேண தவ மநஸ ஏதஸ்யா​: குகல்பநாயா​: க்ஷமா ப⁴வதி, ஏதத³ர்த²ம் ஈஸ்²வரே ப்ரார்த²நாம்ʼ குரு; ");
INSERT INTO santam_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","யதஸ்த்வம்ʼ திக்தபித்தே பாபஸ்ய ப³ந்த⁴நே ச யத³ஸி தந்மயா பு³த்³த⁴ம்| ");
INSERT INTO santam_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ததா³ ஸி²மோந் அகத²யத் தர்ஹி யுவாப்⁴யாமுதி³தா கதா² மயி யதா² ந ப²லதி தத³ர்த²ம்ʼ யுவாம்ʼ மந்நிமித்தம்ʼ ப்ரபௌ⁴ ப்ரார்த²நாம்ʼ குருதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","அநேந ப்ரகாரேண தௌ ஸாக்ஷ்யம்ʼ த³த்த்வா ப்ரபோ⁴​: கதா²ம்ʼ ப்ரசாரயந்தௌ ஸோ²மிரோணீயாநாம் அநேகக்³ராமேஷு ஸுஸம்ʼவாத³ஞ்ச ப்ரசாரயந்தௌ யிரூஸா²லம்நக³ரம்ʼ பராவ்ருʼத்ய க³தௌ| ");
INSERT INTO santam_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","தத​: பரம் ஈஸ்²வரஸ்ய தூ³த​: பி²லிபம் இத்யாதி³ஸ²த், த்வமுத்தா²ய த³க்ஷிணஸ்யாம்ʼ தி³ஸி² யோ மார்கோ³ ப்ராந்தரஸ்ய மத்⁴யேந யிரூஸா²லமோ (அ)ஸாநக³ரம்ʼ யாதி தம்ʼ மார்க³ம்ʼ க³ச்ச²| ");
INSERT INTO santam_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","தத​: ஸ உத்தா²ய க³தவாந்; ததா³ கந்தா³கீநாம்ந​: கூஸ்²லோகாநாம்ʼ ராஜ்ஞ்யா​: ஸர்வ்வஸம்பத்தேரதீ⁴ஸ²​: கூஸ²தே³ஸீ²ய ஏக​: ஷண்டோ³ ப⁴ஜநார்த²ம்ʼ யிரூஸா²லம்நக³ரம் ஆக³த்ய ");
INSERT INTO santam_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","புநரபி ரத²மாருஹ்ய யிஸ²யியநாம்நோ ப⁴விஷ்யத்³வாதி³நோ க்³ரந்த²ம்ʼ பட²ந் ப்ரத்யாக³ச்ச²தி| ");
INSERT INTO santam_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ஏதஸ்மிந் ஸமயே ஆத்மா பி²லிபம் அவத³த், த்வம் ரத²ஸ்ய ஸமீபம்ʼ க³த்வா தேந ஸார்த்³த⁴ம்ʼ மில| ");
INSERT INTO santam_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","தஸ்மாத் ஸ தா⁴வந் தஸ்ய ஸந்நிதா⁴வுபஸ்தா²ய தேந பட்²யமாநம்ʼ யிஸ²யியத²விஷ்யத்³வாதி³நோ வாக்யம்ʼ ஸ்²ருத்வா ப்ருʼஷ்டவாந் யத் பட²ஸி தத் கிம்ʼ பு³த்⁴யஸே? ");
INSERT INTO santam_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","தத​: ஸ கதி²தவாந் கேநசிந்ந போ³தி⁴தோஹம்ʼ கத²ம்ʼ பு³த்⁴யேய? தத​: ஸ பி²லிபம்ʼ ரத²மாரோடு⁴ம்ʼ ஸ்வேந ஸார்த்³த⁴ம் உபவேஷ்டுஞ்ச ந்யவேத³யத்| ");
INSERT INTO santam_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ஸ ஸா²ஸ்த்ரஸ்யேதத்³வாக்யம்ʼ படி²தவாந் யதா², ஸமாநீயத கா⁴தாய ஸ யதா² மேஷஸா²வக​:| லோமச்சே²த³கஸாக்ஷாச்ச மேஷஸ்²ச நீரவோ யதா²| ஆப³த்⁴ய வத³நம்ʼ ஸ்வீயம்ʼ ததா² ஸ ஸமதிஷ்ட²த| ");
INSERT INTO santam_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","அந்யாயேந விசாரேண ஸ உச்சி²ந்நோ (அ)ப⁴வத் ததா³| தத்காலீநமநுஷ்யாந் கோ ஜநோ வர்ணயிதும்ʼ க்ஷம​:| யதோ ஜீவந்ந்ருʼணாம்ʼ தே³ஸா²த் ஸ உச்சி²ந்நோ (அ)ப⁴வத் த்⁴ருவம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","அநந்தரம்ʼ ஸ பி²லிபம் அவத³த் நிவேத³யாமி, ப⁴விஷ்யத்³வாதீ³ யாமிமாம்ʼ கதா²ம்ʼ கத²யாமாஸ ஸ கிம்ʼ ஸ்வஸ்மிந் வா கஸ்மிம்ʼஸ்²சித்³ அந்யஸ்மிந்? ");
INSERT INTO santam_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","தத​: பி²லிபஸ்தத்ப்ரகரணம் ஆரப்⁴ய யீஸோ²ருபாக்²யாநம்ʼ தஸ்யாக்³ரே ப்ராஸ்தௌத்| ");
INSERT INTO santam_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","இத்த²ம்ʼ மார்கே³ண க³ச்ச²ந்தௌ ஜலாஸ²யஸ்ய ஸமீப உபஸ்தி²தௌ; ததா³ க்லீபோ³(அ)வாதீ³த் பஸ்²யாத்ர ஸ்தா²நே ஜலமாஸ்தே மம மஜ்ஜநே கா பா³தா⁴? ");
INSERT INTO santam_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","தத​: பி²லிப உத்தரம்ʼ வ்யாஹரத் ஸ்வாந்த​:கரணேந ஸாகம்ʼ யதி³ ப்ரத்யேஷி தர்ஹி பா³தா⁴ நாஸ்தி| தத​: ஸ கதி²தவாந் யீஸு²க்²ரீஷ்ட ஈஸ்²வரஸ்ய புத்ர இத்யஹம்ʼ ப்ரத்யேமி| ");
INSERT INTO santam_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ததா³ ரத²ம்ʼ ஸ்த²கி³தம்ʼ கர்த்தும் ஆதி³ஷ்டே பி²லிபக்லீபௌ³ த்³வௌ ஜலம் அவாருஹதாம்ʼ; ததா³ பி²லிபஸ்தம் மஜ்ஜயாமாஸ| ");
INSERT INTO santam_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","தத்பஸ்²சாத் ஜலமத்⁴யாத்³ உத்தி²தயோ​: ஸதோ​: பரமேஸ்²வரஸ்யாத்மா பி²லிபம்ʼ ஹ்ருʼத்வா நீதவாந், தஸ்மாத் க்லீப³​: புநஸ்தம்ʼ ந த்³ருʼஷ்டவாந் ததா²பி ஹ்ருʼஷ்டசித்த​: ஸந் ஸ்வமார்கே³ண க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","பி²லிபஸ்²சாஸ்தோ³த்³நக³ரம் உபஸ்தா²ய தஸ்மாத் கைஸரியாநக³ர உபஸ்தி²திகாலபர்ய்யநதம்ʼ ஸர்வ்வஸ்மிந்நக³ரே ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந் க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","தத்காலபர்ய்யநதம்ʼ ஸௌ²ல​: ப்ரபோ⁴​: ஸி²ஷ்யாணாம்ʼ ப்ராதிகூல்யேந தாட³நாப³த⁴யோ​: கதா²ம்ʼ நி​:ஸாரயந் மஹாயாஜகஸ்ய ஸந்நிதி⁴ம்ʼ க³த்வா ");
INSERT INTO santam_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ஸ்த்ரியம்ʼ புருஷஞ்ச தந்மதக்³ராஹிணம்ʼ யம்ʼ கஞ்சித் பஸ்²யதி தாந் த்⁴ருʼத்வா ப³த்³த்⁴வா யிரூஸா²லமம் ஆநயதீத்யாஸ²யேந த³ம்மேஷக்நக³ரீயம்ʼ த⁴ர்ம்மஸமாஜாந் ப்ரதி பத்ரம்ʼ யாசிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","க³ச்ச²ந் து த³ம்மேஷக்நக³ரநிகட உபஸ்தி²தவாந்; ததோ(அ)கஸ்மாத்³ ஆகாஸா²த் தஸ்ய சதுர்தி³க்ஷு தேஜஸ​: ப்ரகாஸ²நாத் ஸ பூ⁴மாவபதத்| ");
INSERT INTO santam_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","பஸ்²சாத் ஹே ஸௌ²ல ஹே ஸௌ²ல குதோ மாம்ʼ தாட³யஸி? ஸ்வம்ʼ ப்ரதி ப்ரோக்தம் ஏதம்ʼ ஸ²ப்³த³ம்ʼ ஸ்²ருத்வா ");
INSERT INTO santam_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ஸ ப்ருʼஷ்டவாந், ஹே ப்ரபோ⁴ ப⁴வாந் க​:? ததா³ ப்ரபு⁴ரகத²யத் யம்ʼ யீஸு²ம்ʼ த்வம்ʼ தாட³யஸி ஸ ஏவாஹம்ʼ; கண்டகஸ்ய முகே² பதா³கா⁴தகரணம்ʼ தவ கஷ்டம்| ");
INSERT INTO santam_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ததா³ கம்பமாநோ விஸ்மயாபந்நஸ்²ச ஸோவத³த் ஹே ப்ரபோ⁴ மயா கிம்ʼ கர்த்தவ்யம்ʼ? ப⁴வத இச்சா² கா? தத​: ப்ரபு⁴ராஜ்ஞாபயத்³ உத்தா²ய நக³ரம்ʼ க³ச்ச² தத்ர த்வயா யத் கர்த்தவ்யம்ʼ தத்³ வதி³ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","தஸ்ய ஸங்கி³நோ லோகா அபி தம்ʼ ஸ²ப்³த³ம்ʼ ஸ்²ருதவந்த​: கிந்து கமபி ந த்³ருʼஷ்ட்வா ஸ்தப்³தா⁴​: ஸந்த​: ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","அநந்தரம்ʼ ஸௌ²லோ பூ⁴மித உத்தா²ய சக்ஷுஷீ உந்மீல்ய கமபி ந த்³ருʼஷ்டவாந்| ததா³ லோகாஸ்தஸ்ய ஹஸ்தௌ த்⁴ருʼத்வா த³ம்மேஷக்நக³ரம் ஆநயந்| ");
INSERT INTO santam_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","தத​: ஸ தி³நத்ரயம்ʼ யாவத்³ அந்தோ⁴ பூ⁴த்வா ந பு⁴க்தவாந் பீதவாம்ʼஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","தத³நந்தரம்ʼ ப்ரபு⁴ஸ்தத்³த³ம்மேஷக்நக³ரவாஸிந ஏகஸ்மை ஸி²ஷ்யாய த³ர்ஸ²நம்ʼ த³த்வா ஆஹூதவாந் ஹே அநநிய| தத​: ஸ ப்ரத்யவாதீ³த், ஹே ப்ரபோ⁴ பஸ்²ய ஸ்²ருʼணோமி| ");
INSERT INTO santam_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ததா³ ப்ரபு⁴ஸ்தமாஜ்ஞாபயத் த்வமுத்தா²ய ஸரலநாமாநம்ʼ மார்க³ம்ʼ க³த்வா யிஹூதா³நிவேஸ²நே தார்ஷநக³ரீயம்ʼ ஸௌ²லநாமாநம்ʼ ஜநம்ʼ க³வேஷயந் ப்ருʼச்ச²; ");
INSERT INTO santam_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","பஸ்²ய ஸ ப்ரார்த²யதே, ததா² அநநியநாமக ஏகோ ஜநஸ்தஸ்ய ஸமீபம் ஆக³த்ய தஸ்ய கா³த்ரே ஹஸ்தார்பணம்ʼ க்ருʼத்வா த்³ருʼஷ்டிம்ʼ த³தா³தீத்த²ம்ʼ ஸ்வப்நே த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","தஸ்மாத்³ அநநிய​: ப்ரத்யவத³த் ஹே ப்ரபோ⁴ யிரூஸா²லமி பவித்ரலோகாந் ப்ரதி ஸோ(அ)நேகஹிம்ʼஸாம்ʼ க்ருʼதவாந்; ");
INSERT INTO santam_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","அத்ர ஸ்தா²நே ச யே லோகாஸ்தவ நாம்நி ப்ரார்த²யந்தி தாநபி ப³த்³து⁴ம்ʼ ஸ ப்ரதா⁴நயாஜகேப்⁴ய​: ஸ²க்திம்ʼ ப்ராப்தவாந், இமாம்ʼ கதா²ம் அஹம் அநேகேஷாம்ʼ முகே²ப்⁴ய​: ஸ்²ருதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","கிந்து ப்ரபு⁴ரகத²யத், யாஹி பி⁴ந்நதே³ஸீ²யலோகாநாம்ʼ பூ⁴பதீநாம் இஸ்ராயேல்லோகாநாஞ்ச நிகடே மம நாம ப்ரசாரயிதும்ʼ ஸ ஜநோ மம மநோநீதபாத்ரமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","மம நாமநிமித்தஞ்ச தேந கியாந் மஹாந் க்லேஸோ² போ⁴க்தவ்ய ஏதத் தம்ʼ த³ர்ஸ²யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ததோ (அ)நநியோ க³த்வா க்³ருʼஹம்ʼ ப்ரவிஸ்²ய தஸ்ய கா³த்ரே ஹஸ்தார்ப்ரணம்ʼ க்ருʼத்வா கதி²தவாந், ஹே ப்⁴ராத​: ஸௌ²ல த்வம்ʼ யதா² த்³ருʼஷ்டிம்ʼ ப்ராப்நோஷி பவித்ரேணாத்மநா பரிபூர்ணோ ப⁴வஸி ச, தத³ர்த²ம்ʼ தவாக³மநகாலே ய​: ப்ரபு⁴யீஸு²ஸ்துப்⁴யம்ʼ த³ர்ஸ²நம் அத³தா³த் ஸ மாம்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","இத்யுக்தமாத்ரே தஸ்ய சக்ஷுர்ப்⁴யாம் மீநஸ²ல்கவத்³ வஸ்துநி நிர்க³தே தத்க்ஷணாத் ஸ ப்ரஸந்நசக்ஷு ர்பூ⁴த்வா ப்ரோத்தா²ய மஜ்ஜிதோ(அ)ப⁴வத் பு⁴க்த்வா பீத்வா ஸப³லோப⁴வச்ச| ");
INSERT INTO santam_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","தத​: பரம்ʼ ஸௌ²ல​: ஸி²ஷ்யை​: ஸஹ கதிபயதி³வஸாந் தஸ்மிந் த³ம்மேஷகநக³ரே ஸ்தி²த்வா(அ)விலம்ப³ம்ʼ ");
INSERT INTO santam_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ஸர்வ்வப⁴ஜநப⁴வநாநி க³த்வா யீஸு²ரீஸ்²வரஸ்ய புத்ர இமாம்ʼ கதா²ம்ʼ ப்ராசாரயத்| ");
INSERT INTO santam_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","தஸ்மாத் ஸர்வ்வே ஸ்²ரோதாரஸ்²சமத்க்ருʼத்ய கதி²தவந்தோ யோ யிரூஸா²லம்நக³ர ஏதந்நாம்நா ப்ரார்த²யித்ருʼலோகாந் விநாஸி²தவாந் ஏவம் ஏதாத்³ருʼஸ²லோகாந் ப³த்³த்⁴வா ப்ரதா⁴நயாஜகநிகடம்ʼ நயதீத்யாஸ²யா ஏதத்ஸ்தா²நமப்யாக³ச்ச²த் ஸஏவ கிமயம்ʼ ந ப⁴வதி? ");
INSERT INTO santam_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","கிந்து ஸௌ²ல​: க்ரமஸ² உத்ஸாஹவாந் பூ⁴த்வா யீஸு²ரீஸ்²வரேணாபி⁴ஷிக்தோ ஜந ஏதஸ்மிந் ப்ரமாணம்ʼ த³த்வா த³ம்மேஷக்-நிவாஸியிஹூதீ³யலோகாந் நிருத்தராந் அகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","இத்த²ம்ʼ ப³ஹுதிதே² காலே க³தே யிஹூதீ³யலோகாஸ்தம்ʼ ஹந்தும்ʼ மந்த்ரயாமாஸு​: ");
INSERT INTO santam_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","கிந்து ஸௌ²லஸ்தேஷாமேதஸ்யா மந்த்ரணாயா வார்த்தாம்ʼ ப்ராப்தவாந்| தே தம்ʼ ஹந்தும்ʼ து தி³வாநிஸ²ம்ʼ கு³ப்தா​: ஸந்தோ நக³ரஸ்ய த்³வாரே(அ)திஷ்ட²ந்; ");
INSERT INTO santam_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","தஸ்மாத் ஸி²ஷ்யாஸ்தம்ʼ நீத்வா ராத்ரௌ பிடகே நிதா⁴ய ப்ராசீரேணாவாரோஹயந்| ");
INSERT INTO santam_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","தத​: பரம்ʼ ஸௌ²லோ யிரூஸா²லமம்ʼ க³த்வா ஸி²ஷ்யக³ணேந ஸார்த்³த⁴ம்ʼ ஸ்தா²தும் ஐஹத், கிந்து ஸர்வ்வே தஸ்மாத³பி³ப⁴யு​: ஸ ஸி²ஷ்ய இதி ச ந ப்ரத்யயந்| ");
INSERT INTO santam_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ஏதஸ்மாத்³ ப³ர்ணப்³பா³ஸ்தம்ʼ க்³ருʼஹீத்வா ப்ரேரிதாநாம்ʼ ஸமீபமாநீய மார்க³மத்⁴யே ப்ரபு⁴​: கத²ம்ʼ தஸ்மை த³ர்ஸ²நம்ʼ த³த்தவாந் யா​: கதா²ஸ்²ச கதி²தவாந் ஸ ச யதா²க்ஷோப⁴​: ஸந் த³ம்மேஷக்நக³ரே யீஸோ² ர்நாம ப்ராசாரயத் ஏதாந் ஸர்வ்வவ்ருʼத்தாந்தாந் தாந் ஜ்ஞாபிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","தத​: ஸௌ²லஸ்தை​: ஸஹ யிரூஸா²லமி காலம்ʼ யாபயந் நிர்ப⁴யம்ʼ ப்ரபோ⁴ ர்யீஸோ² ர்நாம ப்ராசாரயத்| ");
INSERT INTO santam_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","தஸ்மாத்³ அந்யதே³ஸீ²யலோகை​: ஸார்த்³த⁴ம்ʼ விவாத³ஸ்யோபஸ்தி²தத்வாத் தே தம்ʼ ஹந்தும் அசேஷ்டந்த| ");
INSERT INTO santam_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","கிந்து ப்⁴ராத்ருʼக³ணஸ்தஜ்ஜ்ஞாத்வா தம்ʼ கைஸரியாநக³ரம்ʼ நீத்வா தார்ஷநக³ரம்ʼ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","இத்த²ம்ʼ ஸதி யிஹூதி³யாகா³லீல்ஸோ²மிரோணதே³ஸீ²யா​: ஸர்வ்வா மண்ட³ல்யோ விஸ்²ராமம்ʼ ப்ராப்தாஸ்ததஸ்தாஸாம்ʼ நிஷ்டா²ப⁴வத் ப்ரபோ⁴ ர்பி⁴யா பவித்ரஸ்யாத்மந​: ஸாந்த்வநயா ச காலம்ʼ க்ஷேபயித்வா ப³ஹுஸம்ʼக்²யா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","தத​: பரம்ʼ பிதர​: ஸ்தா²நே ஸ்தா²நே ப்⁴ரமித்வா ஸே²ஷே லோத்³நக³ரநிவாஸிபவித்ரலோகாநாம்ʼ ஸமீபே ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ததா³ தத்ர பக்ஷாகா⁴தவ்யாதி⁴நாஷ்டௌ வத்ஸராந் ஸ²ய்யாக³தம் ஐநேயநாமாநம்ʼ மநுஷ்யம்ʼ ஸாக்ஷத் ப்ராப்ய தமவத³த், ");
INSERT INTO santam_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ஹே ஐநேய யீஸு²க்²ரீஷ்டஸ்த்வாம்ʼ ஸ்வஸ்த²ம் அகார்ஷீத், த்வமுத்தா²ய ஸ்வஸ²ய்யாம்ʼ நிக்ஷிப, இத்யுக்தமாத்ரே ஸ உத³திஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ஏதாத்³ருʼஸ²ம்ʼ த்³ருʼஷ்ட்வா லோத்³ஸா²ரோணநிவாஸிநோ லோகா​: ப்ரபு⁴ம்ʼ ப்ரதி பராவர்த்தந்த| ");
INSERT INTO santam_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","அபரஞ்ச பி⁴க்ஷாதா³நாதி³ஷு நாநக்ரியாஸு நித்யம்ʼ ப்ரவ்ருʼத்தா யா யாபோ²நக³ரநிவாஸிநீ டாபி³தா²நாமா ஸி²ஷ்யா யாம்ʼ த³ர்க்காம்ʼ அர்தா²த்³ ஹரிணீமயுக்த்வா ஆஹ்வயந் ஸா நாரீ ");
INSERT INTO santam_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","தஸ்மிந் ஸமயே ருக்³நா ஸதீ ப்ராணாந் அத்யஜத், ததோ லோகாஸ்தாம்ʼ ப்ரக்ஷால்யோபரிஸ்த²ப்ரகோஷ்டே² ஸா²யயித்வாஸ்தா²பயந்| ");
INSERT INTO santam_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","லோத்³நக³ரம்ʼ யாபோ²நக³ரஸ்ய ஸமீபஸ்த²ம்ʼ தஸ்மாத்தத்ர பிதர ஆஸ்தே, இதி வார்த்தாம்ʼ ஸ்²ருத்வா தூர்ணம்ʼ தஸ்யாக³மநார்த²ம்ʼ தஸ்மிந் விநயமுக்த்வா ஸி²ஷ்யக³ணோ த்³வௌ மநுஜௌ ப்ரேஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","தஸ்மாத் பிதர உத்தா²ய தாப்⁴யாம்ʼ ஸார்த்³த⁴ம் ஆக³ச்ச²த், தத்ர தஸ்மிந் உபஸ்தி²த உபரிஸ்த²ப்ரகோஷ்ட²ம்ʼ ஸமாநீதே ச வித⁴வா​: ஸ்வாபி⁴​: ஸஹ ஸ்தி²திகாலே த³ர்க்கயா க்ருʼதாநி யாந்யுத்தரீயாணி பரிதே⁴யாநி ச தாநி ஸர்வ்வாணி தம்ʼ த³ர்ஸ²யித்வா ருத³த்யஸ்²சதஸ்ருʼஷு தி³க்ஷ்வதிஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","கிந்து பிதரஸ்தா​: ஸர்வ்வா ப³ஹி​: க்ருʼத்வா ஜாநுநீ பாதயித்வா ப்ரார்தி²தவாந்; பஸ்²சாத் ஸ²வம்ʼ ப்ரதி த்³ருʼஷ்டிம்ʼ க்ருʼத்வா கதி²தவாந், ஹே டாபீ³தே² த்வமுத்திஷ்ட², இதி வாக்ய உக்தே ஸா ஸ்த்ரீ சக்ஷுஷீ ப்ரோந்மீல்ய பிதரம் அவலோக்யோத்தா²யோபாவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","தத​: பிதரஸ்தஸ்யா​: கரௌ த்⁴ருʼத்வா உத்தோல்ய பவித்ரலோகாந் வித⁴வாஸ்²சாஹூய தேஷாம்ʼ நிகடே ஸஜீவாம்ʼ தாம்ʼ ஸமார்பயத்| ");
INSERT INTO santam_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ஏஷா கதா² ஸமஸ்தயாபோ²நக³ரம்ʼ வ்யாப்தா தஸ்மாத்³ அநேகே லோகா​: ப்ரபௌ⁴ வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","அபரஞ்ச பிதரஸ்தத்³யாபோ²நக³ரீயஸ்ய கஸ்யசித் ஸி²மோந்நாம்நஸ்²சர்ம்மகாரஸ்ய க்³ருʼஹே ப³ஹுதி³நாநி ந்யவஸத்| ");
INSERT INTO santam_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","கைஸரியாநக³ர இதாலியாக்²யஸைந்யாந்தர்க³த​: கர்ணீலியநாமா ஸேநாபதிராஸீத் ");
INSERT INTO santam_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ஸ ஸபரிவாரோ ப⁴க்த ஈஸ்²வரபராயணஸ்²சாஸீத்; லோகேப்⁴யோ ப³ஹூநி தா³நாதீ³நி த³த்வா நிரந்தரம் ஈஸ்²வரே ப்ரார்த²யாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ஏகதா³ த்ருʼதீயப்ரஹரவேலாயாம்ʼ ஸ த்³ருʼஷ்டவாந் ஈஸ்²வரஸ்யைகோ தூ³த​: ஸப்ரகாஸ²ம்ʼ தத்ஸமீபம் ஆக³த்ய கதி²தவாந், ஹே கர்ணீலிய| ");
INSERT INTO santam_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","கிந்து ஸ தம்ʼ த்³ருʼஷ்ட்வா பீ⁴தோ(அ)கத²யத், ஹே ப்ரபோ⁴ கிம்ʼ? ததா³ தமவத³த் தவ ப்ரார்த²நா தா³நாதி³ ச ஸாக்ஷிஸ்வரூபம்ʼ பூ⁴த்வேஸ்²வரஸ்ய கோ³சரமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","இதா³நீம்ʼ யாபோ²நக³ரம்ʼ ப்ரதி லோகாந் ப்ரேஷ்ய ஸமுத்³ரதீரே ஸி²மோந்நாம்நஸ்²சர்ம்மகாரஸ்ய க்³ருʼஹே ப்ரவாஸகாரீ பிதரநாம்நா விக்²யாதோ ய​: ஸி²மோந் தம் ஆஹ்வாயய; ");
INSERT INTO santam_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","தஸ்மாத் த்வயா யத்³யத் கர்த்தவ்யம்ʼ தத்தத் ஸ வதி³ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","இத்யுபதி³ஸ்²ய தூ³தே ப்ரஸ்தி²தே ஸதி கர்ணீலிய​: ஸ்வக்³ருʼஹஸ்தா²நாம்ʼ தா³ஸாநாம்ʼ த்³வௌ ஜநௌ நித்யம்ʼ ஸ்வஸங்கி³நாம்ʼ ஸைந்யாநாம் ஏகாம்ʼ ப⁴க்தஸேநாஞ்சாஹூய ");
INSERT INTO santam_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ஸகலமேதம்ʼ வ்ருʼத்தாந்தம்ʼ விஜ்ஞாப்ய யாபோ²நக³ரம்ʼ தாந் ப்ராஹிணோத்| ");
INSERT INTO santam_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","பரஸ்மிந் தி³நே தே யாத்ராம்ʼ க்ருʼத்வா யதா³ நக³ரஸ்ய ஸமீப உபாதிஷ்ட²ந், ததா³ பிதரோ த்³விதீயப்ரஹரவேலாயாம்ʼ ப்ரார்த²யிதும்ʼ க்³ருʼஹப்ருʼஷ்ட²ம் ஆரோஹத்| ");
INSERT INTO santam_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ஏதஸ்மிந் ஸமயே க்ஷுதா⁴ர்த்த​: ஸந் கிஞ்சித்³ போ⁴க்தும் ஐச்ச²த் கிந்து தேஷாம் அந்நாஸாத³நஸமயே ஸ மூர்ச்சி²த​: ஸந்நபதத்| ");
INSERT INTO santam_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ததோ மேக⁴த்³வாரம்ʼ முக்தம்ʼ சதுர்பி⁴​: கோணை ர்லம்பி³தம்ʼ ப்³ருʼஹத்³வஸ்த்ரமிவ கிஞ்சந பா⁴ஜநம் ஆகாஸா²த் ப்ருʼதி²வீம் அவாரோஹதீதி த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","தந்மத்⁴யே நாநப்ரகாரா க்³ராம்யவந்யபஸ²வ​: கே²சரோரோகா³மிப்ரப்⁴ருʼதயோ ஜந்தவஸ்²சாஸந்| ");
INSERT INTO santam_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","அநந்தரம்ʼ ஹே பிதர உத்தா²ய ஹத்வா பு⁴ம்ʼக்ஷ்வ தம்ப்ரதீயம்ʼ க³க³ணீயா வாணீ ஜாதா| ");
INSERT INTO santam_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ததா³ பிதர​: ப்ரத்யவத³த், ஹே ப்ரபோ⁴ ஈத்³ருʼஸ²ம்ʼ மா ப⁴வது, அஹம் ஏதத் காலம்ʼ யாவத் நிஷித்³த⁴ம் அஸு²சி வா த்³ரவ்யம்ʼ கிஞ்சித³பி ந பு⁴க்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","தத​: புநரபி தாத்³ருʼஸீ² விஹயஸீயா வாணீ ஜாதா யத்³ ஈஸ்²வர​: ஸு²சி க்ருʼதவாந் தத் த்வம்ʼ நிஷித்³த⁴ம்ʼ ந ஜாநீஹி| ");
INSERT INTO santam_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","இத்த²ம்ʼ த்ரி​: ஸதி தத் பாத்ரம்ʼ புநராக்ருʼஷ்டம்ʼ ஆகாஸ²ம் அக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","தத​: பரம்ʼ யத்³ த³ர்ஸ²நம்ʼ ப்ராப்தவாந் தஸ்ய கோ பா⁴வ இத்யத்ர பிதரோ மநஸா ஸந்தே³க்³தி⁴, ஏதஸ்மிந் ஸமயே கர்ணீலியஸ்ய தே ப்ரேஷிதா மநுஷ்யா த்³வாரஸ்ய ஸந்நிதா⁴வுபஸ்தா²ய, ");
INSERT INTO santam_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ஸி²மோநோ க்³ருʼஹமந்விச்ச²ந்த​: ஸம்ப்ருʼச்²யாஹூய கதி²தவந்த​: பிதரநாம்நா விக்²யாதோ ய​: ஸி²மோந் ஸ கிமத்ர ப்ரவஸதி? ");
INSERT INTO santam_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","யதா³ பிதரஸ்தத்³த³ர்ஸ²நஸ்ய பா⁴வம்ʼ மநஸாந்தோ³லயதி ததா³த்மா தமவத³த், பஸ்²ய த்ரயோ ஜநாஸ்த்வாம்ʼ ம்ருʼக³யந்தே| ");
INSERT INTO santam_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","த்வம் உத்தா²யாவருஹ்ய நி​:ஸந்தே³ஹம்ʼ தை​: ஸஹ க³ச்ச² மயைவ தே ப்ரேஷிதா​:| ");
INSERT INTO santam_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","தஸ்மாத் பிதரோ(அ)வருஹ்ய கர்ணீலியப்ரேரிதலோகாநாம்ʼ நிகடமாக³த்ய கதி²தவாந் பஸ்²யத யூயம்ʼ யம்ʼ ம்ருʼக³யத்⁴வே ஸ ஜநோஹம்ʼ, யூயம்ʼ கிந்நிமித்தம் ஆக³தா​:? ");
INSERT INTO santam_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ததஸ்தே ப்ரத்யவத³ந் கர்ணீலியநாமா ஸு²த்³த⁴ஸத்த்வ ஈஸ்²வரபராயணோ யிஹூதீ³யதே³ஸ²ஸ்தா²நாம்ʼ ஸர்வ்வேஷாம்ʼ ஸந்நிதௌ⁴ ஸுக்²யாத்யாபந்ந ஏக​: ஸேநாபதி ர்நிஜக்³ருʼஹம்ʼ த்வாமாஹூய நேதும்ʼ த்வத்த​: கதா² ஸ்²ரோதுஞ்ச பவித்ரதூ³தேந ஸமாதி³ஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ததா³ பிதரஸ்தாநப்⁴யந்தரம்ʼ நீத்வா தேஷாமாதித்²யம்ʼ க்ருʼதவாந், பரே(அ)ஹநி தை​: ஸார்த்³த⁴ம்ʼ யாத்ராமகரோத், யாபோ²நிவாஸிநாம்ʼ ப்⁴ராத்ருʼணாம்ʼ கியந்தோ ஜநாஸ்²ச தேந ஸஹ க³தா​:| ");
INSERT INTO santam_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","பரஸ்மிந் தி³வஸே கைஸரியாநக³ரமத்⁴யப்ரவேஸ²ஸமயே கர்ணீலியோ ஜ்ஞாதிப³ந்தூ⁴ந் ஆஹூயாநீய தாந் அபேக்ஷ்ய ஸ்தி²த​:| ");
INSERT INTO santam_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","பிதரே க்³ருʼஹ உபஸ்தி²தே கர்ணீலியஸ்தம்ʼ ஸாக்ஷாத்க்ருʼத்ய சரணயோ​: பதித்வா ப்ராணமத்| ");
INSERT INTO santam_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","பிதரஸ்தமுத்தா²ப்ய கதி²தவாந், உத்திஷ்டா²ஹமபி மாநுஷ​:| ");
INSERT INTO santam_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ததா³ கர்ணீலியேந ஸாகம் ஆலபந் க்³ருʼஹம்ʼ ப்ராவிஸ²த் தந்மத்⁴யே ச ப³ஹுலோகாநாம்ʼ ஸமாக³மம்ʼ த்³ருʼஷ்ட்வா தாந் அவத³த், ");
INSERT INTO santam_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","அந்யஜாதீயலோகை​: மஹாலபநம்ʼ வா தேஷாம்ʼ க்³ருʼஹமத்⁴யே ப்ரவேஸ²நம்ʼ யிஹூதீ³யாநாம்ʼ நிஷித்³த⁴ம் அஸ்தீதி யூயம் அவக³ச்ச²த²; கிந்து கமபி மாநுஷம் அவ்யவஹார்ய்யம் அஸு²சிம்ʼ வா ஜ்ஞாதும்ʼ மம நோசிதம் இதி பரமேஸ்²வரோ மாம்ʼ ஜ்ஞாபிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","இதி ஹேதோராஹ்வாநஸ்²ரவணமாத்ராத் காஞ்சநாபத்திம் அக்ருʼத்வா யுஷ்மாகம்ʼ ஸமீபம் ஆக³தோஸ்மி; ப்ருʼச்சா²மி யூயம்ʼ கிந்நிமித்தம்ʼ மாம் ஆஹூயத? ");
INSERT INTO santam_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ததா³ கர்ணீலிய​: கதி²தவாந், அத்³ய சத்வாரி தி³நாநி ஜாதாநி ஏதாவத்³வேலாம்ʼ யாவத்³ அஹம் அநாஹார ஆஸந் ததஸ்த்ருʼதீயப்ரஹரே ஸதி க்³ருʼஹே ப்ரார்த²நஸமயே தேஜோமயவஸ்த்ரப்⁴ருʼத்³ ஏகோ ஜநோ மம ஸமக்ஷம்ʼ திஷ்ட²ந் ஏதாம்ʼ கதா²ம் அகத²யத், ");
INSERT INTO santam_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ஹே கர்ணீலிய த்வதீ³யா ப்ரார்த²நா ஈஸ்²வரஸ்ய கர்ணகோ³சரீபூ⁴தா தவ தா³நாதி³ ச ஸாக்ஷிஸ்வரூபம்ʼ பூ⁴த்வா தஸ்ய த்³ருʼஷ்டிகோ³சரமப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","அதோ யாபோ²நக³ரம்ʼ ப்ரதி லோகாந் ப்ரஹித்ய தத்ர ஸமுத்³ரதீரே ஸி²மோந்நாம்ந​: கஸ்யசிச்சர்ம்மகாரஸ்ய க்³ருʼஹே ப்ரவாஸகாரீ பிதரநாம்நா விக்²யாதோ ய​: ஸி²மோந் தமாஹூाயய; தத​: ஸ ஆக³த்ய த்வாம் உபதே³க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","இதி காரணாத் தத்க்ஷணாத் தவ நிகடே லோகாந் ப்ரேஷிதவாந், த்வமாக³தவாந் இதி ப⁴த்³ரம்ʼ க்ருʼதவாந்| ஈஸ்²வரோ யாந்யாக்²யாநாநி கத²யிதும் ஆதி³ஸ²த் தாநி ஸ்²ரோதும்ʼ வயம்ʼ ஸர்வ்வே ஸாம்ப்ரதம் ஈஸ்²வரஸ்ய ஸாக்ஷாத்³ உபஸ்தி²தா​: ஸ்ம​:| ");
INSERT INTO santam_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ததா³ பிதர இமாம்ʼ கதா²ம்ʼ கத²யிதும் ஆரப்³த⁴வாந், ஈஸ்²வரோ மநுஷ்யாணாம் அபக்ஷபாதீ ஸந் ");
INSERT INTO santam_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","யஸ்ய கஸ்யசித்³ தே³ஸ²ஸ்ய யோ லோகாஸ்தஸ்மாத்³பீ⁴த்வா ஸத்கர்ம்ம கரோதி ஸ தஸ்ய க்³ராஹ்யோ ப⁴வதி, ஏதஸ்ய நிஸ்²சயம் உபலப்³த⁴வாநஹம்| ");
INSERT INTO santam_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ஸர்வ்வேஷாம்ʼ ப்ரபு⁴ ர்யோ யீஸு²க்²ரீஷ்டஸ்தேந ஈஸ்²வர இஸ்ராயேல்வம்ʼஸா²நாம்ʼ நிகடே ஸுஸம்ʼவாத³ம்ʼ ப்ரேஷ்ய ஸம்மேலநஸ்ய யம்ʼ ஸம்ʼவாத³ம்ʼ ப்ராசாரயத் தம்ʼ ஸம்ʼவாத³ம்ʼ யூயம்ʼ ஸ்²ருதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","யதோ யோஹநா மஜ்ஜநே ப்ரசாரிதே ஸதி ஸ கா³லீலதே³ஸ²மாரப்⁴ய ஸமஸ்தயிஹூதீ³யதே³ஸ²ம்ʼ வ்யாப்நோத்; ");
INSERT INTO santam_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ப²லத ஈஸ்²வரேண பவித்ரேணாத்மநா ஸ²க்த்யா சாபி⁴ஷிக்தோ நாஸரதீயயீஸு²​: ஸ்தா²நே ஸ்தா²நே ப்⁴ரமந் ஸுக்ரியாம்ʼ குர்வ்வந் ஸை²தாநா க்லிஷ்டாந் ஸர்வ்வலோகாந் ஸ்வஸ்தா²ந் அகரோத், யத ஈஸ்²வரஸ்தஸ்ய ஸஹாய ஆஸீத்; ");
INSERT INTO santam_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","வயஞ்ச யிஹூதீ³யதே³ஸே² யிரூஸா²லம்நக³ரே ச தேந க்ருʼதாநாம்ʼ ஸர்வ்வேஷாம்ʼ கர்ம்மணாம்ʼ ஸாக்ஷிணோ ப⁴வாம​:| லோகாஸ்தம்ʼ க்ருஸே² வித்³த்⁴வா ஹதவந்த​:, ");
INSERT INTO santam_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","கிந்து த்ருʼதீயதி³வஸே ஈஸ்²வரஸ்தமுத்தா²ப்ய ஸப்ரகாஸ²ம் அத³ர்ஸ²யத்| ");
INSERT INTO santam_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ஸர்வ்வலோகாநாம்ʼ நிகட இதி ந ஹி, கிந்து தஸ்மிந் ஸ்²மஸா²நாது³த்தி²தே ஸதி தேந ஸார்த்³த⁴ம்ʼ போ⁴ஜநம்ʼ பாநஞ்ச க்ருʼதவந்த ஏதாத்³ருʼஸா² ஈஸ்²வரஸ்ய மநோநீதா​: ஸாக்ஷிணோ யே வயம் அஸ்மாகம்ʼ நிகடே தமத³ர்ஸ²யத்| ");
INSERT INTO santam_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ஜீவிதம்ருʼதோப⁴யலோகாநாம்ʼ விசாரம்ʼ கர்த்தும் ஈஸ்²வரோ யம்ʼ நியுக்தவாந் ஸ ஏவ ஸ ஜந​:, இமாம்ʼ கதா²ம்ʼ ப்ரசாரயிதும்ʼ தஸ்மிந் ப்ரமாணம்ʼ தா³துஞ்ச ஸோ(அ)ஸ்மாந் ஆஜ்ஞாபயத்| ");
INSERT INTO santam_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","யஸ்தஸ்மிந் விஸ்²வஸிதி ஸ தஸ்ய நாம்நா பாபாந்முக்தோ ப⁴விஷ்யதி தஸ்மிந் ஸர்வ்வே ப⁴விஷ்யத்³வாதி³நோபி ஏதாத்³ருʼஸ²ம்ʼ ஸாக்ஷ்யம்ʼ த³த³தி| ");
INSERT INTO santam_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","பிதரஸ்யைதத்கதா²கத²நகாலே ஸர்வ்வேஷாம்ʼ ஸ்²ரோத்ருʼணாமுபரி பவித்ர ஆத்மாவாரோஹத்| ");
INSERT INTO santam_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","தத​: பிதரேண ஸார்த்³த⁴ம் ஆக³தாஸ்த்வக்சே²தி³நோ விஸ்²வாஸிநோ லோகா அந்யதே³ஸீ²யேப்⁴ய​: பவித்ர ஆத்மநி த³த்தே ஸதி ");
INSERT INTO santam_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","தே நாநாஜாதீயபா⁴ஷாபி⁴​: கதா²ம்ʼ கத²யந்த ஈஸ்²வரம்ʼ ப்ரஸ²ம்ʼஸந்தி, இதி த்³ருʼஷ்ட்வா ஸ்²ருத்வா ச விஸ்மயம் ஆபத்³யந்த| ");
INSERT INTO santam_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ததா³ பிதர​: கதி²தவாந், வயமிவ யே பவித்ரம் ஆத்மாநம்ʼ ப்ராப்தாஸ்தேஷாம்ʼ ஜலமஜ்ஜநம்ʼ கிம்ʼ கோபி நிஷேத்³து⁴ம்ʼ ஸ²க்நோதி? ");
INSERT INTO santam_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","தத​: ப்ரபோ⁴ ர்நாம்நா மஜ்ஜிதா ப⁴வதேதி தாநாஜ்ஞாபயத்| அநந்தரம்ʼ தே ஸ்வை​: ஸார்த்³த⁴ம்ʼ கதிபயதி³நாநி ஸ்தா²தும்ʼ ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","இத்த²ம்ʼ பி⁴ந்நதே³ஸீ²யலோகா அபீஸ்²வரஸ்ய வாக்யம் அக்³ருʼஹ்லந் இமாம்ʼ வார்த்தாம்ʼ யிஹூதீ³யதே³ஸ²ஸ்த²ப்ரேரிதா ப்⁴ராத்ருʼக³ணஸ்²ச ஸ்²ருதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","தத​: பிதரே யிரூஸா²லம்நக³ரம்ʼ க³தவதி த்வக்சே²தி³நோ லோகாஸ்தேந ஸஹ விவத³மாநா அவத³ந், ");
INSERT INTO santam_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","த்வம் அத்வக்சே²தி³லோகாநாம்ʼ க்³ருʼஹம்ʼ க³த்வா தை​: ஸார்த்³த⁴ம்ʼ பு⁴க்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","தத​: பிதர ஆதி³த​: க்ரமஸ²ஸ்தத்கார்ய்யஸ்ய ஸர்வ்வவ்ருʼத்தாந்தமாக்²யாதும் ஆரப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","யாபோ²நக³ர ஏகதா³ஹம்ʼ ப்ரார்த²யமாநோ மூர்ச்சி²த​: ஸந் த³ர்ஸ²நேந சதுர்ஷு கோணேஷு லம்ப³நமாநம்ʼ வ்ருʼஹத்³வஸ்த்ரமிவ பாத்ரமேகம் ஆகாஸ²த³வருஹ்ய மந்நிகடம் ஆக³ச்ச²த்³ அபஸ்²யம்| ");
INSERT INTO santam_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","பஸ்²சாத் தத்³ அநந்யத்³ருʼஷ்ட்யா த்³ருʼஷ்ட்வா விவிச்ய தஸ்ய மத்⁴யே நாநாப்ரகாராந் க்³ராம்யவந்யபஸூ²ந் உரோகா³மிகே²சராம்ʼஸ்²ச த்³ருʼஷ்டவாந்; ");
INSERT INTO santam_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ஹே பிதர த்வமுத்தா²ய க³த்வா பு⁴ம்ʼக்ஷ்வ மாம்ʼ ஸம்போ³த்⁴ய கத²யந்தம்ʼ ஸ²ப்³த³மேகம்ʼ ஸ்²ருதவாம்ʼஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ததோஹம்ʼ ப்ரத்யவத³ம்ʼ, ஹே ப்ரபோ⁴ நேத்த²ம்ʼ ப⁴வது, யத​: கிஞ்சந நிஷித்³த⁴ம் அஸு²சி த்³ரவ்யம்ʼ வா மம முக²மத்⁴யம்ʼ கதா³பி ந ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","அபரம் ஈஸ்²வரோ யத் ஸு²சி க்ருʼதவாந் தந்நிஷித்³த⁴ம்ʼ ந ஜாநீஹி த்³வி ர்மாம்ப்ரதீத்³ருʼஸீ² விஹாயஸீயா வாணீ ஜாதா| ");
INSERT INTO santam_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","த்ரிரித்த²ம்ʼ ஸதி தத் ஸர்வ்வம்ʼ புநராகாஸ²ம் ஆக்ருʼஷ்டம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","பஸ்²சாத் கைஸரியாநக³ராத் த்ரயோ ஜநா மந்நிகடம்ʼ ப்ரேஷிதா யத்ர நிவேஸ²நே ஸ்தி²தோஹம்ʼ தஸ்மிந் ஸமயே தத்ரோபாதிஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ததா³ நி​:ஸந்தே³ஹம்ʼ தை​: ஸார்த்³த⁴ம்ʼ யாதும் ஆத்மா மாமாதி³ஷ்டவாந்; தத​: பரம்ʼ மயா ஸஹைதேஷு ஷட்³ப்⁴ராத்ருʼஷு க³தேஷு வயம்ʼ தஸ்ய மநுஜஸ்ய க்³ருʼஹம்ʼ ப்ராவிஸா²ம| ");
INSERT INTO santam_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ஸோஸ்மாகம்ʼ நிகடே கதா²மேதாம் அகத²யத் ஏகதா³ தூ³த ஏக​: ப்ரத்யக்ஷீபூ⁴ய மம க்³ருʼஹமத்⁴யே திஷ்டந் மாமித்யாஜ்ஞாபிதவாந், யாபோ²நக³ரம்ʼ ப்ரதி லோகாந் ப்ரஹித்ய பிதரநாம்நா விக்²யாதம்ʼ ஸி²மோநம் ஆஹூயய; ");
INSERT INTO santam_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ததஸ்தவ த்வதீ³யபரிவாராணாஞ்ச யேந பரித்ராணம்ʼ ப⁴விஷ்யதி தத் ஸ உபதே³க்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","அஹம்ʼ தாம்ʼ கதா²முத்தா²ப்ய கதி²தவாந் தேந ப்ரத²மம் அஸ்மாகம் உபரி யதா² பவித்ர ஆத்மாவரூட⁴வாந் ததா² தேஷாமப்யுபரி ஸமவரூட⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","தேந யோஹந் ஜலே மஜ்ஜிதவாந் இதி ஸத்யம்ʼ கிந்து யூயம்ʼ பவித்ர ஆத்மநி மஜ்ஜிதா ப⁴விஷ்யத², இதி யத்³வாக்யம்ʼ ப்ரபு⁴ருதி³தவாந் தத் ததா³ மயா ஸ்ம்ருʼதம்| ");
INSERT INTO santam_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","அத​: ப்ரபா⁴ யீஸு²க்²ரீஷ்டே ப்ரத்யயகாரிணோ யே வயம் அஸ்மப்⁴யம் ஈஸ்²வரோ யத்³ த³த்தவாந் தத் தேப்⁴யோ லோகேப்⁴யோபி த³த்தவாந் தத​: கோஹம்ʼ? கிமஹம் ஈஸ்²வரம்ʼ வாரயிதும்ʼ ஸ²க்நோமி? ");
INSERT INTO santam_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","கதா²மேதாம்ʼ ஸ்²ருவா தே க்ஷாந்தா ஈஸ்²வரஸ்ய கு³ணாந் அநுகீர்த்த்ய கதி²தவந்த​:, தர்ஹி பரமாயு​:ப்ராப்திநிமித்தம் ஈஸ்²வரோந்யதே³ஸீ²யலோகேப்⁴யோபி மந​:பரிவர்த்தநரூபம்ʼ தா³நம் அதா³த்| ");
INSERT INTO santam_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ஸ்திபா²நம்ʼ ப்ரதி உபத்³ரவே க⁴டிதே யே விகீர்ணா அப⁴வந் தை பை²நீகீகுப்ராந்தியகி²யாஸு ப்⁴ரமித்வா கேவலயிஹூதீ³யலோகாந் விநா கஸ்யாப்யந்யஸ்ய ஸமீப ஈஸ்²வரஸ்ய கதா²ம்ʼ ந ப்ராசாரயந்| ");
INSERT INTO santam_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","அபரம்ʼ தேஷாம்ʼ குப்ரீயா​: குரீநீயாஸ்²ச கியந்தோ ஜநா ஆந்தியகி²யாநக³ரம்ʼ க³த்வா யூநாநீயலோகாநாம்ʼ ஸமீபேபி ப்ரபோ⁴ர்யீஸோ²​: கதா²ம்ʼ ப்ராசாரயந்| ");
INSERT INTO santam_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ப்ரபோ⁴​: கரஸ்தேஷாம்ʼ ஸஹாய ஆஸீத் தஸ்மாத்³ அநேகே லோகா விஸ்²வஸ்ய ப்ரபு⁴ம்ʼ ப்ரதி பராவர்த்தந்த| ");
INSERT INTO santam_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","இதி வார்த்தாயாம்ʼ யிரூஸா²லமஸ்த²மண்ட³லீயலோகாநாம்ʼ கர்ணகோ³சரீபூ⁴தாயாம் ஆந்தியகி²யாநக³ரம்ʼ க³ந்து தே ப³ர்ணப்³பா³ம்ʼ ப்ரைரயந்| ");
INSERT INTO santam_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ததோ ப³ர்ணப்³பா³ஸ்தத்ர உபஸ்தி²த​: ஸந் ஈஸ்²வரஸ்யாநுக்³ரஹஸ்ய ப²லம்ʼ த்³ருʼஷ்ட்வா ஸாநந்தோ³ ஜாத​:, ");
INSERT INTO santam_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ஸ ஸ்வயம்ʼ ஸாது⁴ ர்விஸ்²வாஸேந பவித்ரேணாத்மநா ச பரிபூர்ண​: ஸந் க³நோநிஷ்டயா ப்ரபா⁴வாஸ்தா²ம்ʼ கர்த்தும்ʼ ஸர்வ்வாந் உபதி³ஷ்டவாந் தேந ப்ரபோ⁴​: ஸி²ஷ்யா அநேகே ப³பூ⁴வு​:| ");
INSERT INTO santam_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ஸே²ஷே ஸௌ²லம்ʼ ம்ருʼக³யிதும்ʼ ப³ர்ணப்³பா³ஸ்தார்ஷநக³ரம்ʼ ப்ரஸ்தி²தவாந்| தத்ர தஸ்யோத்³தே³ஸ²ம்ʼ ப்ராப்ய தம் ஆந்தியகி²யாநக³ரம் ஆநயத்; ");
INSERT INTO santam_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ததஸ்தௌ மண்ட³லீஸ்த²லோகை​: ஸபா⁴ம்ʼ க்ருʼத்வா ஸம்ʼவத்ஸரமேகம்ʼ யாவத்³ ப³ஹுலோகாந் உபாதி³ஸ²தாம்ʼ; தஸ்மிந் ஆந்தியகி²யாநக³ரே ஸி²ஷ்யா​: ப்ரத²மம்ʼ க்²ரீஷ்டீயநாம்நா விக்²யாதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","தத​: பரம்ʼ ப⁴விஷ்யத்³வாதி³க³ணே யிரூஸா²லம ஆந்தியகி²யாநக³ரம் ஆக³தே ஸதி ");
INSERT INTO santam_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ஆகா³ப³நாமா தேஷாமேக உத்தா²ய ஆத்மந​: ஸி²க்ஷயா ஸர்வ்வதே³ஸே² து³ர்பி⁴க்ஷம்ʼ ப⁴விஷ்யதீதி ஜ்ஞாபிதவாந்; தத​: க்லௌதி³யகைஸரஸ்யாதி⁴காரே ஸதி தத் ப்ரத்யக்ஷம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","தஸ்மாத் ஸி²ஷ்யா ஏகைகஸ²​: ஸ்வஸ்வஸ²க்த்யநுஸாரதோ யிஹூதீ³யதே³ஸ²நிவாஸிநாம்ʼ ப்⁴ரத்ருʼணாம்ʼ தி³நயாபநார்த²ம்ʼ த⁴நம்ʼ ப்ரேஷயிதும்ʼ நிஸ்²சித்ய ");
INSERT INTO santam_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ப³ர்ணப்³பா³ஸௌ²லயோ ர்த்³வாரா ப்ராசீநலோகாநாம்ʼ ஸமீபம்ʼ தத் ப்ரேஷிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","தஸ்மிந் ஸமயே ஹேரோத்³‌ராஜோ மண்ட³ல்யா​: கியஜ்ஜநேப்⁴யோ து³​:க²ம்ʼ தா³தும்ʼ ப்ராரப⁴த்| ");
INSERT INTO santam_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","விஸே²ஷதோ யோஹந​: ஸோத³ரம்ʼ யாகூப³ம்ʼ கரவாலாகா⁴தேந் ஹதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","தஸ்மாத்³ யிஹூதீ³யா​: ஸந்துஷ்டா அப⁴வந் இதி விஜ்ஞாய ஸ பிதரமபி த⁴ர்த்தும்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ததா³ கிண்வஸூ²ந்யபூபோத்ஸவஸமய உபாதிஷ்டத்; அத உத்ஸவே க³தே ஸதி லோகாநாம்ʼ ஸமக்ஷம்ʼ தம்ʼ ப³ஹிராநேய்யாமீதி மநஸி ஸ்தி²ரீக்ருʼத்ய ஸ தம்ʼ தா⁴ரயித்வா ரக்ஷ்ணார்த²ம் யேஷாம் ஏகைகஸம்ʼகே⁴ சத்வாரோ ஜநா​: ஸந்தி தேஷாம்ʼ சதுர்ணாம்ʼ ரக்ஷகஸம்ʼகா⁴நாம்ʼ ஸமீபே தம்ʼ ஸமர்ப்ய காராயாம்ʼ ஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","கிந்தும்ʼ பிதரஸ்ய காராஸ்தி²திகாரணாத் மண்ட³ல்யா லோகா அவிஸ்²ராமம் ஈஸ்²வரஸ்ய ஸமீபே ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","அநந்தரம்ʼ ஹேரோதி³ தம்ʼ ப³ஹிராநாயிதும்ʼ உத்³யதே ஸதி தஸ்யாம்ʼ ராத்ரௌ பிதரோ ரக்ஷகத்³வயமத்⁴யஸ்தா²நே ஸ்²ருʼங்க²லத்³வயேந ப³த்³த்⁴வ​: ஸந் நித்³ரித ஆஸீத், தௌ³வாரிகாஸ்²ச காராயா​: ஸம்முகே² திஷ்ட²நதோ த்³வாரம் அரக்ஷிஷு​:| ");
INSERT INTO santam_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ஏதஸ்மிந் ஸமயே பரமேஸ்²வரஸ்ய தூ³தே ஸமுபஸ்தி²தே காரா தீ³ப்திமதீ ஜாதா; தத​: ஸ தூ³த​: பிதரஸ்ய குக்ஷாவாவாதம்ʼ க்ருʼத்வா தம்ʼ ஜாக³ரயித்வா பா⁴ஷிதவாந் தூர்ணமுத்திஷ்ட²; ததஸ்தஸ்ய ஹஸ்தஸ்த²ஸ்²ருʼங்க²லத்³வயம்ʼ க³லத் பதிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ஸ தூ³தஸ்தமவத³த், ப³த்³த⁴கடி​: ஸந் பாத³யோ​: பாது³கே அர்பய; தேந ததா² க்ருʼதே ஸதி தூ³தஸ்தம் உக்தவாந் கா³த்ரீயவஸ்த்ரம்ʼ கா³த்ரே நிதா⁴ய மம பஸ்²சாத்³ ஏஹி| ");
INSERT INTO santam_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","தத​: பிதரஸ்தஸ்ய பஸ்²சாத்³ வ்ரஜந ப³ஹிரக³ச்ச²த், கிந்து தூ³தேந கர்ம்மைதத் க்ருʼதமிதி ஸத்யமஜ்ஞாத்வா ஸ்வப்நத³ர்ஸ²நம்ʼ ஜ்ஞாதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","இத்த²ம்ʼ தௌ ப்ரத²மாம்ʼ த்³விதீயாஞ்ச காராம்ʼ லங்கி⁴த்வா யேந லௌஹநிர்ம்மிதத்³வாரேண நக³ரம்ʼ க³ம்யதே தத்ஸமீபம்ʼ ப்ராப்நுதாம்ʼ; ததஸ்தஸ்ய கவாடம்ʼ ஸ்வயம்ʼ முக்தமப⁴வத் ததஸ்தௌ தத்ஸ்தா²நாத்³ ப³ஹி ர்பூ⁴த்வா மார்கை³கஸ்ய ஸீமாம்ʼ யாவத்³ க³தௌ; ததோ(அ)கஸ்மாத் ஸ தூ³த​: பிதரம்ʼ த்யக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ததா³ ஸ சேதநாம்ʼ ப்ராப்ய கதி²தவாந் நிஜதூ³தம்ʼ ப்ரஹித்ய பரமேஸ்²வரோ ஹேரோதோ³ ஹஸ்தாத்³ யிஹூதீ³யலோகாநாம்ʼ ஸர்வ்வாஸா²யாஸ்²ச மாம்ʼ ஸமுத்³த்⁴ருʼதவாந் இத்யஹம்ʼ நிஸ்²சயம்ʼ ஜ்ஞாதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ஸ விவிச்ய மார்கநாம்ரா விக்²யாதஸ்ய யோஹநோ மாது ர்மரியமோ யஸ்மிந் க்³ருʼஹே ப³ஹவ​: ஸம்பூ⁴ய ப்ரார்த²யந்த தந்நிவேஸ²நம்ʼ க³த​:| ");
INSERT INTO santam_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","பிதரேண ப³ஹிர்த்³வார ஆஹதே ஸதி ரோதா³நாமா பா³லிகா த்³ரஷ்டும்ʼ க³தா| ");
INSERT INTO santam_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","தத​: பிதரஸ்ய ஸ்வரம்ʼ ஸ்²ருவா ஸா ஹர்ஷயுக்தா ஸதீ த்³வாரம்ʼ ந மோசயித்வா பிதரோ த்³வாரே திஷ்ட²தீதி வார்த்தாம்ʼ வக்தும் அப்⁴யந்தரம்ʼ தா⁴வித்வா க³தவதீ| ");
INSERT INTO santam_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","தே ப்ராவோசந் த்வமுந்மத்தா ஜாதாஸி கிந்து ஸா முஹுர்முஹுருக்தவதீ ஸத்யமேவைதத்| ");
INSERT INTO santam_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ததா³ தே கதி²தவந்தஸ்தர்ஹி தஸ்ய தூ³தோ ப⁴வேத்| ");
INSERT INTO santam_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","பிதரோ த்³வாரமாஹதவாந் ஏதஸ்மிந்நந்தரே த்³வாரம்ʼ மோசயித்வா பிதரம்ʼ த்³ருʼஷ்ட்வா விஸ்மயம்ʼ ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","தத​: பிதரோ நி​:ஸ²ப்³த³ம்ʼ ஸ்தா²தும்ʼ தாந் ப்ரதி ஹஸ்தேந ஸங்கேதம்ʼ க்ருʼத்வா பரமேஸ்²வரோ யேந ப்ரகாரேண தம்ʼ காராயா உத்³த்⁴ருʼத்யாநீதவாந் தஸ்ய வ்ருʼத்தாந்தம்ʼ தாநஜ்ஞாபயத், யூயம்ʼ க³த்வா யாகுப³ம்ʼ ப்⁴ராத்ருʼக³ணஞ்ச வார்த்தாமேதாம்ʼ வத³தேத்யுக்தா ஸ்தா²நாந்தரம்ʼ ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ப்ரபா⁴தே ஸதி பிதர​: க்வ க³த இத்யத்ர ரக்ஷகாணாம்ʼ மத்⁴யே மஹாந் கலஹோ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ஹேரோத்³ ப³ஹு ம்ருʼக³யித்வா தஸ்யோத்³தே³ஸே² ந ப்ராப்தே ஸதி ரக்ஷகாந் ஸம்ʼப்ருʼச்ச்²ய தேஷாம்ʼ ப்ராணாந் ஹந்தும் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","பஸ்²சாத் ஸ யிஹூதீ³யப்ரதே³ஸா²த் கைஸரியாநக³ரம்ʼ க³த்வா தத்ராவாதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ஸோரஸீதோ³நதே³ஸ²யோ ர்லோகேப்⁴யோ ஹேரோதி³ யுயுத்ஸௌ ஸதி தே ஸர்வ்வ ஏகமந்த்ரணா​: ஸந்தஸ்தஸ்ய ஸமீப உபஸ்தா²ய ல்வாஸ்தநாமாநம்ʼ தஸ்ய வஸ்த்ரக்³ருʼஹாதீ⁴ஸ²ம்ʼ ஸஹாயம்ʼ க்ருʼத்வா ஹேரோதா³ ஸார்த்³த⁴ம்ʼ ஸந்தி⁴ம்ʼ ப்ரார்த²யந்த யதஸ்தஸ்ய ராஜ்ஞோ தே³ஸே²ந தேஷாம்ʼ தே³ஸீ²யாநாம்ʼ ப⁴ரணம் அப⁴வத்ம்ʼ ");
INSERT INTO santam_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","அத​: குத்ரசிந் நிருபிததி³நே ஹேரோத்³ ராஜகீயம்ʼ பரிச்ச²த³ம்ʼ பரிதா⁴ய ஸிம்ʼஹாஸநே ஸமுபவிஸ்²ய தாந் ப்ரதி கதா²ம் உக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ததோ லோகா உச்சை​:காரம்ʼ ப்ரத்யவத³ந், ஏஷ மநுஜரவோ ந ஹி, ஈஸ்²வரீயரவ​:| ");
INSERT INTO santam_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ததா³ ஹேரோத்³ ஈஸ்²வரஸ்ய ஸம்மாநம்ʼ நாகரோத்; தஸ்மாத்³தே⁴தோ​: பரமேஸ்²வரஸ்ய தூ³தோ ஹடா²த் தம்ʼ ப்ராஹரத் தேநைவ ஸ கீடை​: க்ஷீண​: ஸந் ப்ராணாந் அஜஹாத்| கிந்த்வீஸ்²வரஸ்ய கதா² தே³ஸ²ம்ʼ வ்யாப்ய ப்ரப³லாப⁴வத்| தத​: பரம்ʼ ப³ர்ணப்³பா³ஸௌ²லௌ யஸ்ய கர்ம்மணோ பா⁴ரம்ʼ ப்ராப்நுதாம்ʼ தாப்⁴யாம்ʼ தஸ்மிந் ஸம்பாதி³தே ஸதி மார்கநாம்நா விக்²யாதோ யோ யோஹந் தம்ʼ ஸங்கி³நம்ʼ க்ருʼத்வா யிரூஸா²லம்நக³ராத் ப்ரத்யாக³தௌ| ");
INSERT INTO santam_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","அபரஞ்ச ப³ர்ணப்³பா³​:, ஸி²மோந் யம்ʼ நிக்³ரம்ʼ வத³ந்தி, குரீநீயலூகியோ ஹேரோதா³ ராஜ்ஞா ஸஹ க்ருʼதவித்³யாाப்⁴யாஸோ மிநஹேம், ஸௌ²லஸ்²சைதே யே கியந்தோ ஜநா ப⁴விஷ்யத்³வாதி³ந உபதே³ஷ்டாரஸ்²சாந்தியகி²யாநக³ரஸ்த²மண்ட³ல்யாம் ஆஸந், ");
INSERT INTO santam_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","தே யதோ³பவாஸம்ʼ க்ருʼத்வேஸ்²வரம் அஸேவந்த தஸ்மிந் ஸமயே பவித்ர ஆத்மா கதி²தவாந் அஹம்ʼ யஸ்மிந் கர்ம்மணி ப³ர்ணப்³பா³ஸை²லௌ நியுக்தவாந் தத்கர்ம்ம கர்த்தும்ʼ தௌ ப்ருʼத²க் குருத| ");
INSERT INTO santam_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ததஸ்தைருபவாஸப்ரார்த²நயோ​: க்ருʼதயோ​: ஸதோஸ்தே தயோ ர்கா³த்ரயோ ர்ஹஸ்தார்பணம்ʼ க்ருʼத்வா தௌ வ்யஸ்ருʼஜந்| ");
INSERT INTO santam_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","தத​: பரம்ʼ தௌ பவித்ரேணாத்மநா ப்ரேரிதௌ ஸந்தௌ ஸிலூகியாநக³ரம் உபஸ்தா²ய ஸமுத்³ரபதே²ந குப்ரோபத்³வீபம் அக³ச்ச²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","தத​: ஸாலாமீநக³ரம் உபஸ்தா²ய தத்ர யிஹூதீ³யாநாம்ʼ ப⁴ஜநப⁴வநாநி க³த்வேஸ்²வரஸ்ய கதா²ம்ʼ ப்ராசாரயதாம்ʼ; யோஹநபி தத்ஸஹசரோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","இத்த²ம்ʼ தே தஸ்யோபத்³வீபஸ்ய ஸர்வ்வத்ர ப்⁴ரமந்த​: பாப²நக³ரம் உபஸ்தி²தா​:; தத்ர ஸுவிவேசகேந ஸர்ஜியபௌலநாம்நா தத்³தே³ஸா²தி⁴பதிநா ஸஹ ப⁴விஷ்யத்³வாதி³நோ வேஸ²தா⁴ரீ ப³ர்யீஸு²நாமா யோ மாயாவீ யிஹூதீ³ ஆஸீத் தம்ʼ ஸாக்ஷாத் ப்ராப்தவத​:| ");
INSERT INTO santam_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","தத்³தே³ஸா²தி⁴ப ஈஸ்²வரஸ்ய கதா²ம்ʼ ஸ்²ரோதும்ʼ வாஞ்ச²ந் பௌலப³ர்ணப்³பௌ³ ந்யமந்த்ரயத்| ");
INSERT INTO santam_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","கிந்த்விலுமா யம்ʼ மாயாவிநம்ʼ வத³ந்தி ஸ தே³ஸா²தி⁴பதிம்ʼ த⁴ர்ம்மமார்கா³த்³ ப³ஹிர்பூ⁴தம்ʼ கர்த்தும் அயதத| ");
INSERT INTO santam_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","தஸ்மாத் ஸோ²லோ(அ)ர்தா²த் பௌல​: பவித்ரேணாத்மநா பரிபூர்ண​: ஸந் தம்ʼ மாயாவிநம்ʼ ப்ரத்யநந்யத்³ருʼஷ்டிம்ʼ க்ருʼத்வாகத²யத், ");
INSERT INTO santam_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ஹே நரகிந் த⁴ர்ம்மத்³வேஷிந் கௌடில்யது³ஷ்கர்ம்மபரிபூர்ண, த்வம்ʼ கிம்ʼ ப்ரபோ⁴​: ஸத்யபத²ஸ்ய விபர்ய்யயகரணாத் கதா³பி ந நிவர்த்திஷ்யஸே? ");
INSERT INTO santam_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","அது⁴நா பரமேஸ்²வரஸ்தவ ஸமுசிதம்ʼ கரிஷ்யதி தேந கதிபயதி³நாநி த்வம் அந்த⁴​: ஸந் ஸூர்ய்யமபி ந த்³ரக்ஷ்யஸி| தத்க்ஷணாத்³ ராத்ரிவத்³ அந்த⁴காரஸ்தஸ்ய த்³ருʼஷ்டிம் ஆச்சா²தி³தவாந்; தஸ்மாத் தஸ்ய ஹஸ்தம்ʼ த⁴ர்த்தும்ʼ ஸ லோகமந்விச்ச²ந் இதஸ்ததோ ப்⁴ரமணம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ஏநாம்ʼ க⁴டநாம்ʼ த்³ருʼஷ்ட்வா ஸ தே³ஸா²தி⁴பதி​: ப்ரபூ⁴பதே³ஸா²த்³ விஸ்மித்ய விஸ்²வாஸம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","தத³நந்தரம்ʼ பௌலஸ்தத்ஸங்கி³நௌ ச பாப²நக³ராத் ப்ரோதம்ʼ சாலயித்வா பம்பு²லியாதே³ஸ²ஸ்ய பர்கீ³நக³ரம் அக³ச்ச²ந் கிந்து யோஹந் தயோ​: ஸமீபாத்³ ஏத்ய யிரூஸா²லமம்ʼ ப்ரத்யாக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","பஸ்²சாத் தௌ பர்கீ³தோ யாத்ராம்ʼ க்ருʼத்வா பிஸிதி³யாதே³ஸ²ஸ்ய ஆந்தியகி²யாநக³ரம் உபஸ்தா²ய விஸ்²ராமவாரே ப⁴ஜநப⁴வநம்ʼ ப்ரவிஸ்²ய ஸமுபாவிஸ²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","வ்யவஸ்தா²ப⁴விஷ்யத்³வாக்யயோ​: படி²தயோ​: ஸதோ ர்ஹே ப்⁴ராதரௌ லோகாந் ப்ரதி யுவயோ​: காசித்³ உபதே³ஸ²கதா² யத்³யஸ்தி தர்ஹி தாம்ʼ வத³தம்ʼ தௌ ப்ரதி தஸ்ய ப⁴ஜநப⁴வநஸ்யாதி⁴பதய​: கதா²ம் ஏதாம்ʼ கத²யித்வா ப்ரைஷயந்| ");
INSERT INTO santam_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","அத​: பௌல உத்திஷ்ட²ந் ஹஸ்தேந ஸங்கேதம்ʼ குர்வ்வந் கதி²தவாந் ஹே இஸ்ராயேலீயமநுஷ்யா ஈஸ்²வரபராயணா​: ஸர்வ்வே லோகா யூயம் அவத⁴த்³த⁴ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ஏதேஷாமிஸ்ராயேல்லோகாநாம் ஈஸ்²வரோ(அ)ஸ்மாகம்ʼ பூர்வ்வபருஷாந் மநோநீதாந் கத்வா க்³ருʼஹீதவாந் ததோ மிஸரி தே³ஸே² ப்ரவஸநகாலே தேஷாமுந்நதிம்ʼ க்ருʼத்வா தஸ்மாத் ஸ்வீயபா³ஹுப³லேந தாந் ப³ஹி​: க்ருʼத்வா ஸமாநயத்| ");
INSERT INTO santam_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","சத்வாரிம்ʼஸ²த்³வத்ஸராந் யாவச்ச மஹாப்ராந்தரே தேஷாம்ʼ ப⁴ரணம்ʼ க்ருʼத்வா ");
INSERT INTO santam_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","கிநாந்தே³ஸா²ந்தர்வ்வர்த்தீணி ஸப்தராஜ்யாநி நாஸ²யித்வா கு³டிகாபாதேந தேஷு ஸர்வ்வதே³ஸே²ஷு தேப்⁴யோ(அ)தி⁴காரம்ʼ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","பஞ்சாஸ²த³தி⁴கசது​:ஸ²தேஷு வத்ஸரேஷு க³தேஷு ச ஸி²மூயேல்ப⁴விஷ்யத்³வாதி³பர்ய்யந்தம்ʼ தேஷாமுபரி விசாரயித்ருʼந் நியுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","தைஸ்²ச ராஜ்ஞி ப்ரார்தி²தே, ஈஸ்²வரோ பி³ந்யாமீநோ வம்ʼஸ²ஜாதஸ்ய கீஸ²​: புத்ரம்ʼ ஸௌ²லம்ʼ சத்வாரிம்ʼஸ²த்³வர்ஷபர்ய்யந்தம்ʼ தேஷாமுபரி ராஜாநம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","பஸ்²சாத் தம்ʼ பத³ச்யுதம்ʼ க்ருʼத்வா யோ மதி³ஷ்டக்ரியா​: ஸர்வ்வா​: கரிஷ்யதி தாத்³ருʼஸ²ம்ʼ மம மநோபி⁴மதம் ஏகம்ʼ ஜநம்ʼ யிஸ²ய​: புத்ரம்ʼ தா³யூத³ம்ʼ ப்ராப்தவாந் இத³ம்ʼ ப்ரமாணம்ʼ யஸ்மிந் தா³யூதி³ ஸ த³த்தவாந் தம்ʼ தா³யூத³ம்ʼ தேஷாமுபரி ராஜத்வம்ʼ கர்த்தும் உத்பாதி³தவாந| ");
INSERT INTO santam_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","தஸ்ய ஸ்வப்ரதிஸ்²ருதஸ்ய வாக்யஸ்யாநுஸாரேண இஸ்ராயேல்லோகாநாம்ʼ நிமித்தம்ʼ தேஷாம்ʼ மநுஷ்யாணாம்ʼ வம்ʼஸா²த்³ ஈஸ்²வர ஏகம்ʼ யீஸு²ம்ʼ (த்ராதாரம்) உத³பாத³யத்| ");
INSERT INTO santam_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","தஸ்ய ப்ரகாஸ²நாத் பூர்வ்வம்ʼ யோஹந் இஸ்ராயேல்லோகாநாம்ʼ ஸந்நிதௌ⁴ மந​:பராவர்த்தநரூபம்ʼ மஜ்ஜநம்ʼ ப்ராசாரயத்| ");
INSERT INTO santam_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","யஸ்ய ச கர்ம்மணோे பா⁴ரம்ʼ ப்ரப்தவாந் யோஹந் தந் நிஷ்பாத³யந் ஏதாம்ʼ கதா²ம்ʼ கதி²தவாந், யூயம்ʼ மாம்ʼ கம்ʼ ஜநம்ʼ ஜாநீத²? அஹம் அபி⁴ஷிக்தத்ராதா நஹி, கிந்து பஸ்²யத யஸ்ய பாத³யோ​: பாது³கயோ ர்ப³ந்த⁴நே மோசயிதுமபி யோக்³யோ ந ப⁴வாமி தாத்³ருʼஸ² ஏகோ ஜநோ மம பஸ்²சாத்³ உபதிஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ஹே இப்³ராஹீமோ வம்ʼஸ²ஜாதா ப்⁴ராதரோ ஹே ஈஸ்²வரபீ⁴தா​: ஸர்வ்வலோகா யுஷ்மாந் ப்ரதி பரித்ராணஸ்ய கதை²ஷா ப்ரேரிதா| ");
INSERT INTO santam_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","யிரூஸா²லம்நிவாஸிநஸ்தேஷாம் அதி⁴பதயஸ்²ச தஸ்ய யீஸோ²​: பரிசயம்ʼ ந ப்ராப்ய ப்ரதிவிஸ்²ராமவாரம்ʼ பட்²யமாநாநாம்ʼ ப⁴விஷ்யத்³வாதி³கதா²நாம் அபி⁴ப்ராயம் அபு³த்³த்⁴வா ச தஸ்ய வதே⁴ந தா​: கதா²​: ஸப²லா அகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ப்ராணஹநநஸ்ய கமபி ஹேதும் அப்ராப்யாபி பீலாதஸ்ய நிகடே தஸ்ய வத⁴ம்ʼ ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","தஸ்மிந் யா​: கதா² லிகி²தா​: ஸந்தி தத³நுஸாரேண கர்ம்ம ஸம்பாத்³ய தம்ʼ க்ருஸா²த்³ அவதார்ய்ய ஸ்²மஸா²நே ஸா²யிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","கிந்த்வீஸ்²வர​: ஸ்²மஸா²நாத் தமுத³ஸ்தா²பயத், ");
INSERT INTO santam_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","புநஸ்²ச கா³லீலப்ரதே³ஸா²த்³ யிரூஸா²லமநக³ரம்ʼ தேந ஸார்த்³த⁴ம்ʼ யே லோகா ஆக³ச்ச²ந் ஸ ப³ஹுதி³நாநி தேப்⁴யோ த³ர்ஸ²நம்ʼ த³த்தவாந், அதஸ்த இதா³நீம்ʼ லோகாந் ப்ரதி தஸ்ய ஸாக்ஷிண​: ஸந்தி| ");
INSERT INTO santam_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","அஸ்மாகம்ʼ பூர்வ்வபுருஷாணாம்ʼ ஸமக்ஷம் ஈஸ்²வரோ யஸ்மிந் ப்ரதிஜ்ஞாதவாந் யதா², த்வம்ʼ மே புத்ரோஸி சாத்³ய த்வாம்ʼ ஸமுத்தா²பிதவாநஹம்| ");
INSERT INTO santam_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","இத³ம்ʼ யத்³வசநம்ʼ த்³விதீயகீ³தே லிகி²தமாஸ்தே தத்³ யீஸோ²ருத்தா²நேந தேஷாம்ʼ ஸந்தாநா யே வயம் அஸ்மாகம்ʼ ஸந்நிதௌ⁴ தேந ப்ரத்யக்ஷீ க்ருʼதம்ʼ, யுஷ்மாந் இமம்ʼ ஸுஸம்ʼவாத³ம்ʼ ஜ்ஞாபயாமி| ");
INSERT INTO santam_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","பரமேஸ்²வரேண ஸ்²மஸா²நாத்³ உத்தா²பிதம்ʼ ததீ³யம்ʼ ஸ²ரீரம்ʼ கதா³பி ந க்ஷேஷ்யதே, ஏதஸ்மிந் ஸ ஸ்வயம்ʼ கதி²தவாந் யதா² தா³யூத³ம்ʼ ப்ரதி ப்ரதிஜ்ஞாதோ யோ வரஸ்தமஹம்ʼ துப்⁴யம்ʼ தா³ஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ஏதத³ந்யஸ்மிந் கீ³தே(அ)பி கதி²தவாந்| ஸ்வகீயம்ʼ புண்யவந்தம்ʼ த்வம்ʼ க்ஷயிதும்ʼ ந ச தா³ஸ்யஸி| ");
INSERT INTO santam_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","தா³யூதா³ ஈஸ்²வராபி⁴மதஸேவாயை நிஜாயுஷி வ்யயிதே ஸதி ஸ மஹாநித்³ராம்ʼ ப்ராப்ய நிஜை​: பூர்வ்வபுருஷை​: ஸஹ மிலித​: ஸந் அக்ஷீயத; ");
INSERT INTO santam_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","கிந்து யமீஸ்²வர​: ஸ்²மஸா²நாத்³ உத³ஸ்தா²பயத் ஸ நாக்ஷீயத| ");
INSERT INTO santam_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","அதோ ஹே ப்⁴ராதர​:, அநேந ஜநேந பாபமோசநம்ʼ ப⁴வதீதி யுஷ்மாந் ப்ரதி ப்ரசாரிதம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ப²லதோ மூஸாவ்யவஸ்த²யா யூயம்ʼ யேப்⁴யோ தோ³ஷேப்⁴யோ முக்தா ப⁴விதும்ʼ ந ஸ²க்ஷ்யத² தேப்⁴ய​: ஸர்வ்வதோ³ஷேப்⁴ய ஏதஸ்மிந் ஜநே விஸ்²வாஸிந​: ஸர்வ்வே முக்தா ப⁴விஷ்யந்தீதி யுஷ்மாபி⁴ ர்ஜ்ஞாயதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","அபரஞ்ச| அவஜ்ஞாகாரிணோ லோகாஸ்²சக்ஷுருந்மீல்ய பஸ்²யத| ததை²வாஸம்ப⁴வம்ʼ ஜ்ஞாத்வா ஸ்யாத யூயம்ʼ விலஜ்ஜிதா​:| யதோ யுஷ்மாஸு திஷ்ட²த்ஸு கரிஷ்யே கர்ம்ம தாத்³ருʼஸ²ம்ʼ| யேநைவ தஸ்ய வ்ருʼத்தாந்தே யுஷ்மப்⁴யம்ʼ கதி²தே(அ)பி ஹி| யூயம்ʼ ந தந்து வ்ருʼத்தாந்தம்ʼ ப்ரத்யேஷ்யத² கதா³சந|| ");
INSERT INTO santam_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","யேயம்ʼ கதா² ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ஷு லிகி²தாஸ்தே ஸாவதா⁴நா ப⁴வத ஸ கதா² யதா² யுஷ்மாந் ப்ரதி ந க⁴டதே| ");
INSERT INTO santam_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","யிஹூதீ³யப⁴ஜநப⁴வநாந் நிர்க³தயோஸ்தயோ ர்பி⁴ந்நதே³ஸீ²யை ர்வக்ஷ்யமாணா ப்ரார்த²நா க்ருʼதா, ஆகா³மிநி விஸ்²ராமவாரே(அ)பி கதே²யம் அஸ்மாந் ப்ரதி ப்ரசாரிதா ப⁴வத்விதி| ");
INSERT INTO santam_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ஸபா⁴யா ப⁴ங்கே³ ஸதி ப³ஹவோ யிஹூதீ³யலோகா யிஹூதீ³யமதக்³ராஹிணோ ப⁴க்தலோகாஸ்²ச ப³ர்ணப்³பா³பௌலயோ​: பஸ்²சாத்³ ஆக³ச்ச²ந், தேந தௌ தை​: ஸஹ நாநாகதா²​: கத²யித்வேஸ்²வராநுக்³ரஹாஸ்²ரயே ஸ்தா²தும்ʼ தாந் ப்ராவர்த்தயதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","பரவிஸ்²ராமவாரே நக³ரஸ்ய ப்ராயேண ஸர்வ்வே லாகா ஈஸ்²வரீயாம்ʼ கதா²ம்ʼ ஸ்²ரோதும்ʼ மிலிதா​:, ");
INSERT INTO santam_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","கிந்து யிஹூதீ³யலோகா ஜநநிவஹம்ʼ விலோக்ய ஈர்ஷ்யயா பரிபூர்ணா​: ஸந்தோ விபரீதகதா²கத²நேநேஸ்²வரநிந்த³யா ச பௌலேநோக்தாம்ʼ கதா²ம்ʼ க²ண்ட³யிதும்ʼ சேஷ்டிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","தத​: பௌैலப³ர்ணப்³பா³வக்ஷோபௌ⁴ கதி²தவந்தௌ ப்ரத²மம்ʼ யுஷ்மாகம்ʼ ஸந்நிதா⁴வீஸ்²வரீயகதா²யா​: ப்ரசாரணம் உசிதமாஸீத் கிந்தும்ʼ தத³க்³ராஹ்யத்வகரணேந யூயம்ʼ ஸ்வாந் அநந்தாயுஷோ(அ)யோக்³யாந் த³ர்ஸ²யத², ஏதத்காரணாத்³ வயம் அந்யதே³ஸீ²யலோகாநாம்ʼ ஸமீபம்ʼ க³ச்சா²ம​:| ");
INSERT INTO santam_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ப்ரபு⁴ரஸ்மாந் இத்த²ம் ஆதி³ஷ்டவாந் யதா², யாவச்ச ஜக³த​: ஸீமாம்ʼ லோகாநாம்ʼ த்ராணகாரணாத்| மயாந்யதே³ஸ²மத்⁴யே த்வம்ʼ ஸ்தா²பிதோ பூ⁴​: ப்ரதீ³பவத்|| ");
INSERT INTO santam_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ததா³ கதா²மீத்³ருʼஸீ²ம்ʼ ஸ்²ருத்வா பி⁴ந்நதே³ஸீ²யா ஆஹ்லாதி³தா​: ஸந்த​: ப்ரபோ⁴​: கதா²ம்ʼ த⁴ந்யாம்ʼ த⁴ந்யாம் அவத³ந், யாவந்தோ லோகாஸ்²ச பரமாயு​: ப்ராப்திநிமித்தம்ʼ நிரூபிதா ஆஸந் தேे வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","இத்த²ம்ʼ ப்ரபோ⁴​: கதா² ஸர்வ்வேதே³ஸ²ம்ʼ வ்யாப்நோத்| ");
INSERT INTO santam_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","கிந்து யிஹூதீ³யா நக³ரஸ்ய ப்ரதா⁴நபுருஷாந் ஸம்மாந்யா​: கதி²பயா ப⁴க்தா யோஷிதஸ்²ச குப்ரவ்ருʼத்திம்ʼ க்³ராஹயித்வா பௌலப³ர்ணப்³பௌ³ தாட³யித்வா தஸ்மாத் ப்ரதே³ஸா²த்³ தூ³ரீக்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","அத​: காரணாத் தௌ நிஜபத³தூ⁴லீஸ்தேஷாம்ʼ ப்ராதிகூல்யேந பாதயித்வேेகநியம்ʼ நக³ரம்ʼ க³தௌ| ");
INSERT INTO santam_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","தத​: ஸி²ஷ்யக³ண ஆநந்தே³ந பவித்ரேணாத்மநா ச பரிபூர்ணோப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","தௌ த்³வௌ ஜநௌ யுக³பத்³ இகநியநக³ரஸ்த²யிஹூதீ³யாநாம்ʼ ப⁴ஜநப⁴வநம்ʼ க³த்வா யதா² ப³ஹவோ யிஹூதீ³யா அந்யதே³ेஸீ²யலோகாஸ்²ச வ்யஸ்²வஸந் தாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ கதி²தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","கிந்து விஸ்²வாஸஹீநா யிஹூதீ³யா அந்யதே³ஸீ²யலோகாந் குப்ரவ்ருʼத்திம்ʼ க்³ராஹயித்வா ப்⁴ராத்ருʼக³ணம்ʼ ப்ரதி தேஷாம்ʼ வைரம்ʼ ஜநிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","அத​: ஸ்வாநுக்³ரஹகதா²யா​: ப்ரமாணம்ʼ த³த்வா தயோ ர்ஹஸ்தை ர்ப³ஹுலக்ஷணம் அத்³பு⁴தகர்ம்ம ச ப்ராகாஸ²யத்³ ய​: ப்ரபு⁴ஸ்தஸ்ய கதா² அக்ஷோபே⁴ந ப்ரசார்ய்ய தௌ தத்ர ப³ஹுதி³நாநி ஸமவாதிஷ்டே²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","கிந்து கியந்தோ லோகா யிஹூதீ³யாநாம்ʼ ஸபக்ஷா​: கியந்தோ லோகா​: ப்ரேரிதாநாம்ʼ ஸபக்ஷா ஜாதா​:, அதோ நாக³ரிகஜநநிவஹமத்⁴யே பி⁴ந்நவாக்யத்வம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","அந்யதே³ஸீ²யா யிஹூதீ³யாஸ்தேஷாம் அதி⁴பதயஸ்²ச தௌ³ராத்ம்யம்ʼ குத்வா தௌ ப்ரஸ்தரைராஹந்தும் உத்³யதா​:| ");
INSERT INTO santam_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","தௌ தத்³வார்த்தாம்ʼ ப்ராப்ய பலாயித்வா லுகாயநியாதே³ஸ²ஸ்யாந்தர்வ்வர்த்திலுஸ்த்ராத³ர்ப்³போ³ ");
INSERT INTO santam_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","தத்ஸமீபஸ்த²தே³ஸ²ஞ்ச க³த்வா தத்ர ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","தத்ரோப⁴யபாத³யோஸ்²சலநஸ²க்திஹீநோ ஜந்மாரப்⁴ய க²ஞ்ஜ​: கதா³பி க³மநம்ʼ நாகரோத் ஏதாத்³ருʼஸ² ஏகோ மாநுஷோ லுஸ்த்ராநக³ர உபவிஸ்²ய பௌலஸ்ய கதா²ம்ʼ ஸ்²ருதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ஏதஸ்மிந் ஸமயே பௌலஸ்தம்ப்ரதி த்³ருʼஷ்டிம்ʼ க்ருʼத்வா தஸ்ய ஸ்வாஸ்த்²யே விஸ்²வாஸம்ʼ விதி³த்வா ப்ரோச்சை​: கதி²தவாந் ");
INSERT INTO santam_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","பத்³ப்⁴யாமுத்திஷ்ட²ந் ருʼஜு ர்ப⁴வ| தத​: ஸ உல்லம்ப²ம்ʼ க்ருʼத்வா க³மநாக³மநே குதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ததா³ லோகா​: பௌலஸ்ய தத் கார்ய்யம்ʼ விலோக்ய லுகாயநீயபா⁴ஷயா ப்ரோச்சை​: கதா²மேதாம்ʼ கதி²தவந்த​:, தே³வா மநுஷ்யரூபம்ʼ த்⁴ருʼத்வாஸ்மாகம்ʼ ஸமீபம் அவாரோஹந்| ");
INSERT INTO santam_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","தே ப³ர்ணப்³பா³ம்ʼ யூபிதரம் அவத³ந் பௌலஸ்²ச முக்²யோ வக்தா தஸ்மாத் தம்ʼ மர்குரியம் அவத³ந்| ");
INSERT INTO santam_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","தஸ்ய நக³ரஸ்ய ஸம்முகே² ஸ்தா²பிதஸ்ய யூபிதரவிக்³ரஹஸ்ய யாஜகோ வ்ருʼஷாந் புஷ்பமாலாஸ்²ச த்³வாரஸமீபம் ஆநீய லோகை​: ஸர்த்³த⁴ம்ʼ தாவுத்³தி³ஸ்²ய ஸமுத்ஸ்ருʼஜ்ய தா³தும் உத்³யத​:| ");
INSERT INTO santam_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","தத்³வார்த்தாம்ʼ ஸ்²ருத்வா ப³ர்ணப்³பா³பௌலௌ ஸ்வீயவஸ்த்ராணி சி²த்வா லோகாநாம்ʼ மத்⁴யம்ʼ வேகே³ந ப்ரவிஸ்²ய ப்ரோச்சை​: கதி²தவந்தௌ, ");
INSERT INTO santam_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ஹே மஹேச்சா²​: குத ஏதாத்³ருʼஸ²ம்ʼ கர்ம்ம குருத²? ஆவாமபி யுஷ்மாத்³ருʼஸௌ² ஸுக²து³​:க²போ⁴கி³நௌ மநுஷ்யௌ, யுயம் ஏதா​: ஸர்வ்வா வ்ருʼதா²கல்பநா​: பரித்யஜ்ய யதா² க³க³ணவஸுந்த⁴ராஜலநிதீ⁴நாம்ʼ தந்மத்⁴யஸ்தா²நாம்ʼ ஸர்வ்வேஷாஞ்ச ஸ்ரஷ்டாரமமரம் ஈஸ்²வரம்ʼ ப்ரதி பராவர்த்தத்⁴வே தத³ர்த²ம் ஆவாம்ʼ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயாவ​:| ");
INSERT INTO santam_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ஸ ஈஸ்²வர​: பூர்வ்வகாலே ஸர்வ்வதே³ஸீ²யலோகாந் ஸ்வஸ்வமார்கே³ சலிதுமநுமதிம்ʼ த³த்தவாந், ");
INSERT INTO santam_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ததா²பி ஆகாஸா²த் தோயவர்ஷணேந நாநாப்ரகாரஸ²ஸ்யோத்பத்யா ச யுஷ்மாகம்ʼ ஹிதைஷீ ஸந் ப⁴க்ஷ்யைராநநதே³ந ச யுஷ்மாகம் அந்த​:கரணாநி தர்பயந் தாநி தா³நாநி நிஜஸாக்ஷிஸ்வரூபாணி ஸ்த²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","கிந்து தாத்³ருʼஸா²யாம்ʼ கதா²யாம்ʼ கதி²தாயாமபி தயோ​: ஸமீப உத்ஸர்ஜநாத் லோகநிவஹம்ʼ ப்ராயேண நிவர்த்தயிதும்ʼ நாஸ²க்நுதாம்| ");
INSERT INTO santam_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ஆந்தியகி²யா-இகநியநக³ராப்⁴யாம்ʼ கதிபயயிஹூதீ³யலோகா ஆக³த்ய லோகாந் ப்ராவர்த்தயந்த தஸ்மாத் தை பௌலம்ʼ ப்ரஸ்தரைராக்⁴நந் தேந ஸ ம்ருʼத இதி விஜ்ஞாய நக³ரஸ்ய ப³ஹிஸ்தம் ஆக்ருʼஷ்ய நீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","கிந்து ஸி²ஷ்யக³ணே தஸ்ய சதுர்தி³ஸி² திஷ்ட²தி ஸதி ஸ ஸ்வயம் உத்தா²ய புநரபி நக³ரமத்⁴யம்ʼ ப்ராவிஸ²த் தத்பரே(அ)ஹநி ப³ர்ணப்³பா³ஸஹிதோ த³ர்ப்³பீ³நக³ரம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","தத்ர ஸுஸம்ʼவாத³ம்ʼ ப்ரசார்ய்ய ப³ஹுலோகாந் ஸி²ஷ்யாந் க்ருʼத்வா தௌ லுஸ்த்ராம் இகநியம் ஆந்தியகி²யாஞ்ச பராவ்ருʼத்ய க³தௌ| ");
INSERT INTO santam_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ப³ஹுது³​:கா²நி பு⁴க்த்வாபீஸ்²வரராஜ்யம்ʼ ப்ரவேஷ்டவ்யம் இதி காரணாத்³ த⁴ர்ம்மமார்கே³ ஸ்தா²தும்ʼ விநயம்ʼ க்ருʼத்வா ஸி²ஷ்யக³ணஸ்ய மந​:ஸ்தை²ர்ய்யம் அகுருதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","மண்ட³லீநாம்ʼ ப்ராசீநவர்கா³ந் நியுஜ்ய ப்ரார்த²நோபவாஸௌ க்ருʼத்வா யத்ப்ரபௌ⁴ தே வ்யஸ்²வஸந் தஸ்ய ஹஸ்தே தாந் ஸமர்ப்ய ");
INSERT INTO santam_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","பிஸிதி³யாமத்⁴யேந பாம்பு²லியாதே³ஸ²ம்ʼ க³தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","பஸ்²சாத் பர்கா³நக³ரம்ʼ க³த்வா ஸுஸம்ʼவாத³ம்ʼ ப்ரசார்ய்ய அத்தாலியாநக³ரம்ʼ ப்ரஸ்தி²தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","தஸ்மாத் ஸமுத்³ரபதே²ந க³த்வா தாப்⁴யாம்ʼ யத் கர்ம்ம ஸம்பந்நம்ʼ தத்கர்ம்ம ஸாத⁴யிதும்ʼ யந்நக³ரே த³யாலோரீஸ்²வரஸ்ய ஹஸ்தே ஸமர்பிதௌ ஜாதௌ தத்³ ஆந்தியகி²யாநக³ரம்ʼ க³தவந்தா| ");
INSERT INTO santam_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","தத்ரோபஸ்தா²ய தந்நக³ரஸ்த²மண்ட³லீம்ʼ ஸம்ʼக்³ருʼஹ்ய ஸ்வாப்⁴யாம ஈஸ்²வரோ யத்³யத் கர்ம்மகரோத் ததா² யேந ப்ரகாரேண பி⁴ந்நதே³ஸீ²யலோகாந் ப்ரதி விஸ்²வாஸரூபத்³வாரம் அமோசயத்³ ஏதாந் ஸர்வ்வவ்ருʼத்தாந்தாந் தாந் ஜ்ஞாபிதவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ததஸ்தௌ ஸி²ர்ய்யை​: ஸார்த்³த⁴ம்ʼ தத்ர ப³ஹுதி³நாநி ந்யவஸதாம்| ");
INSERT INTO santam_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","யிஹூதா³தே³ஸா²த் கியந்தோ ஜநா ஆக³த்ய ப்⁴ராத்ருʼக³ணமித்த²ம்ʼ ஸி²க்ஷிதவந்தோ மூஸாவ்யவஸ்த²யா யதி³ யுஷ்மாகம்ʼ த்வக்சே²தோ³ ந ப⁴வதி தர்ஹி யூயம்ʼ பரித்ராணம்ʼ ப்ராப்தும்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","பௌலப³ர்ணப்³பௌ³ தை​: ஸஹ ப³ஹூந் விசாராந் விவாதா³ம்ʼஸ்²ச க்ருʼதவந்தௌ, ததோ மண்ட³லீயநோகா ஏதஸ்யா​: கதா²யாஸ்தத்த்வம்ʼ ஜ்ஞாதும்ʼ யிரூஸா²லம்நக³ரஸ்தா²ந் ப்ரேரிதாந் ப்ராசீநாம்ʼஸ்²ச ப்ரதி பௌலப³ர்ணப்³பா³ப்ரப்⁴ருʼதீந் கதிபயஜநாந் ப்ரேஷயிதும்ʼ நிஸ்²சயம்ʼ க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","தே மண்ட³ல்யா ப்ரேரிதா​: ஸந்த​: பை²ணீகீஸோ²மிரோந்தே³ஸா²ப்⁴யாம்ʼ க³த்வா பி⁴ந்நதே³ஸீ²யாநாம்ʼ மந​:பரிவர்த்தநஸ்ய வார்த்தயா ப்⁴ராத்ருʼணாம்ʼ பரமாஹ்லாத³ம் அஜநயந்| ");
INSERT INTO santam_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","யிரூஸா²லம்யுபஸ்தா²ய ப்ரேரிதக³ணேந லோகப்ராசீநக³ணேந ஸமாஜேந ச ஸமுபக்³ருʼஹீதா​: ஸந்த​: ஸ்வைரீஸ்²வரோ யாநி கர்ம்மாணி க்ருʼதவாந் தேஷாம்ʼ ஸர்வ்வவ்ருʼத்தாந்தாந் தேஷாம்ʼ ஸமக்ஷம் அகத²யந்| ");
INSERT INTO santam_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","கிந்து விஸ்²வாஸிந​: கியந்த​: பி²ரூஸி²மதக்³ராஹிணோ லோகா உத்தா²ய கதா²மேதாம்ʼ கதி²தவந்தோ பி⁴ந்நதே³ஸீ²யாநாம்ʼ த்வக்சே²த³ம்ʼ கர்த்தும்ʼ மூஸாவ்யவஸ்தா²ம்ʼ பாலயிதுஞ்ச ஸமாதே³ஷ்டவ்யம்| ");
INSERT INTO santam_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","தத​: ப்ரேரிதா லோகப்ராசீநாஸ்²ச தஸ்ய விவேசநாம்ʼ கர்த்தும்ʼ ஸபா⁴யாம்ʼ ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ப³ஹுவிசாரேஷு ஜாதஷு பிதர உத்தா²ய கதி²தவாந், ஹே ப்⁴ராதரோ யதா² பி⁴ந்நதே³ஸீ²யலோகா மம முகா²த் ஸுஸம்ʼவாத³ம்ʼ ஸ்²ருத்வா விஸ்²வஸந்தி தத³ர்த²ம்ʼ ப³ஹுதி³நாத் பூர்வ்வம் ஈஸ்²வரோஸ்மாகம்ʼ மத்⁴யே மாம்ʼ வ்ருʼத்வா நியுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","அந்தர்ய்யாமீஸ்²வரோ யதா²ஸ்மப்⁴யம்ʼ ததா² பி⁴ந்நதே³ஸீ²யேப்⁴ய​: பவித்ரமாத்மாநம்ʼ ப்ரதா³ய விஸ்²வாஸேந தேஷாம் அந்த​:கரணாநி பவித்ராணி க்ருʼத்வா ");
INSERT INTO santam_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","தேஷாம் அஸ்மாகஞ்ச மத்⁴யே கிமபி விஸே²ஷம்ʼ ந ஸ்தா²பயித்வா தாநதி⁴ ஸ்வயம்ʼ ப்ரமாணம்ʼ த³த்தவாந் இதி யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","அதஏவாஸ்மாகம்ʼ பூர்வ்வபுருஷா வயஞ்ச ஸ்வயம்ʼ யத்³யுக³ஸ்ய பா⁴ரம்ʼ ஸோடு⁴ம்ʼ ந ஸ²க்தா​: ஸம்ப்ரதி தம்ʼ ஸி²ஷ்யக³ணஸ்ய ஸ்கந்தே⁴ஷு ந்யஸிதும்ʼ குத ஈஸ்²வரஸ்ய பரீக்ஷாம்ʼ கரிஷ்யத²? ");
INSERT INTO santam_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ப்ரபோ⁴ ர்யீஸு²க்²ரீஷ்டஸ்யாநுக்³ரஹேண தே யதா² வயமபி ததா² பரித்ராணம்ʼ ப்ராப்தும் ஆஸா²ம்ʼ குர்ம்ம​:| ");
INSERT INTO santam_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","அநந்தரம்ʼ ப³ர்ணப்³பா³பௌலாப்⁴யாம் ஈஸ்²வரோ பி⁴ந்நதே³ஸீ²யாநாம்ʼ மத்⁴யே யத்³யத்³ ஆஸ்²சர்ய்யம் அத்³பு⁴தஞ்ச கர்ம்ம க்ருʼதவாந் தத்³வ்ருʼத்தாந்தம்ʼ தௌ ஸ்வமுகா²ப்⁴யாம் அவர்ணயதாம்ʼ ஸபா⁴ஸ்தா²​: ஸர்வ்வே நீரவா​: ஸந்த​: ஸ்²ருதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","தயோ​: கதா²யாம்ʼ ஸமாப்தாயாம்ʼ ஸத்யாம்ʼ யாகூப்³ கத²யிதும் ஆரப்³த⁴வாந் ");
INSERT INTO santam_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ஹே ப்⁴ராதரோ மம கதா²யாம் மநோ நித⁴த்த| ஈஸ்²வர​: ஸ்வநாமார்த²ம்ʼ பி⁴ந்நதே³ஸீ²யலோகாநாம் மத்⁴யாத்³ ஏகம்ʼ லோகஸம்ʼக⁴ம்ʼ க்³ரஹீதும்ʼ மதிம்ʼ க்ருʼத்வா யேந ப்ரகாரேண ப்ரத²மம்ʼ தாந் ப்ரதி க்ருʼபாவலேகநம்ʼ க்ருʼதவாந் தம்ʼ ஸி²மோந் வர்ணிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ப⁴விஷ்யத்³வாதி³பி⁴ருக்தாநி யாநி வாக்யாநி தை​: ஸார்த்³த⁴ம் ஏதஸ்யைக்யம்ʼ ப⁴வதி யதா² லிகி²தமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ஸர்வ்வேஷாம்ʼ கர்ம்மணாம்ʼ யஸ்து ஸாத⁴க​: பரமேஸ்²வர​:| ஸ ஏவேத³ம்ʼ வதே³த்³வாக்யம்ʼ ஸே²ஷா​: ஸகலமாநவா​:| பி⁴ந்நதே³ஸீ²யலோகாஸ்²ச யாவந்தோ மம நாமத​:| ப⁴வந்தி ஹி ஸுவிக்²யாதாஸ்தே யதா² பரமேஸி²து​:| ");
INSERT INTO santam_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","தத்வம்ʼ ஸம்யக் ஸமீஹந்தே தந்நிமித்தமஹம்ʼ கில| பராவ்ருʼத்ய ஸமாக³த்ய தா³யூத³​: பதிதம்ʼ புந​:| தூ³ஷ்யமுத்தா²பயிஷ்யாமி ததீ³யம்ʼ ஸர்வ்வவஸ்து ச| பதிதம்ʼ புநருதா²ப்ய ஸஜ்ஜயிஷ்யாமி ஸர்வ்வதா²|| ");
INSERT INTO santam_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ஆ ப்ரத²மாத்³ ஈஸ்²வர​: ஸ்வீயாநி ஸர்வ்வகர்ம்மாணி ஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","அதஏவ மம நிவேத³நமித³ம்ʼ பி⁴ந்நதே³ஸீ²யலோகாநாம்ʼ மத்⁴யே யே ஜநா ஈஸ்²வரம்ʼ ப்ரதி பராவர்த்தந்த தேஷாமுபரி அந்யம்ʼ கமபி பா⁴ரம்ʼ ந ந்யஸ்ய ");
INSERT INTO santam_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","தே³வதாப்ரஸாதா³ஸு²சிப⁴க்ஷ்யம்ʼ வ்யபி⁴சாரகர்ம்ம கண்ட²ஸம்பீட³நமாரிதப்ராணிப⁴க்ஷ்யம்ʼ ரக்தப⁴க்ஷ்யஞ்ச ஏதாநி பரித்யக்தும்ʼ லிகா²ம​:| ");
INSERT INTO santam_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","யத​: பூர்வ்வகாலதோ மூஸாவ்யவஸ்தா²ப்ரசாரிணோ லோகா நக³ரே நக³ரே ஸந்தி ப்ரதிவிஸ்²ராமவாரஞ்ச ப⁴ஜநப⁴வநே தஸ்யா​: பாடோ² ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","தத​: பரம்ʼ ப்ரேரிதக³ணோ லோகப்ராசீநக³ண​: ஸர்வ்வா மண்ட³லீ ச ஸ்வேஷாம்ʼ மத்⁴யே ப³ர்ஸ²ப்³பா³ நாம்நா விக்²யாதோ மநோநீதௌ க்ருʼத்வா பௌலப³ர்ணப்³பா³ப்⁴யாம்ʼ ஸார்த்³த⁴ம் ஆந்தியகி²யாநக³ரம்ʼ ப்ரதி ப்ரேஷணம் உசிதம்ʼ பு³த்³த்⁴வா தாப்⁴யாம்ʼ பத்ரம்ʼ ப்ரைஷயந்| ");
INSERT INTO santam_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","தஸ்மிந் பத்ரே லிகி²தமிம்ʼத³, ஆந்தியகி²யா-ஸுரியா-கிலிகியாதே³ஸ²ஸ்த²பி⁴ந்நதே³ஸீ²யப்⁴ராத்ருʼக³ணாய ப்ரேரிதக³ணஸ்ய லோகப்ராசீநக³ணஸ்ய ப்⁴ராத்ருʼக³ணஸ்ய ச நமஸ்கார​:| ");
INSERT INTO santam_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","விஸே²ஷதோ(அ)ஸ்மாகம் ஆஜ்ஞாம் அப்ராப்யாபி கியந்தோ ஜநா அஸ்மாகம்ʼ மத்⁴யாத்³ க³த்வா த்வக்சே²தோ³ மூஸாவ்யவஸ்தா² ச பாலயிதவ்யாவிதி யுஷ்மாந் ஸி²க்ஷயித்வா யுஷ்மாகம்ʼ மநஸாமஸ்தை²ர்ய்யம்ʼ க்ருʼத்வா யுஷ்மாந் ஸஸந்தே³ஹாந் அகுர்வ்வந் ஏதாம்ʼ கதா²ம்ʼ வயம் அஸ்²ருʼந்ம| ");
INSERT INTO santam_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","தத்காரணாத்³ வயம் ஏகமந்த்ரணா​: ஸந்த​: ஸபா⁴யாம்ʼ ஸ்தி²த்வா ப்ரபோ⁴ ர்யீஸு²க்²ரீஷ்டஸ்ய நாமநிமித்தம்ʼ ம்ருʼத்யுமுக²க³தாப்⁴யாமஸ்மாகம்ʼ ");
INSERT INTO santam_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ப்ரியப³ர்ணப்³பா³பௌலாப்⁴யாம்ʼ ஸார்த்³த⁴ம்ʼ மநோநீதலோகாநாம்ʼ கேஷாஞ்சித்³ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ப்ரேஷணம் உசிதம்ʼ பு³த்³த⁴வந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","அதோ யிஹூதா³ஸீலௌ யுஷ்மாந் ப்ரதி ப்ரேஷிதவந்த​:, ஏதயோ ர்முகா²ப்⁴யாம்ʼ ஸர்வ்வாம்ʼ கதா²ம்ʼ ஜ்ஞாஸ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","தே³வதாப்ரஸாத³ப⁴க்ஷ்யம்ʼ ரக்தப⁴க்ஷ்யம்ʼ க³லபீட³நமாரிதப்ராணிப⁴க்ஷ்யம்ʼ வ்யபி⁴சாரகர்ம்ம சேமாநி ஸர்வ்வாணி யுஷ்மாபி⁴ஸ்த்யாஜ்யாநி; ஏதத்ப்ரயோஜநீயாஜ்ஞாவ்யதிரேகேந யுஷ்மாகம் உபரி பா⁴ரமந்யம்ʼ ந ந்யஸிதும்ʼ பவித்ரஸ்யாத்மநோ(அ)ஸ்மாகஞ்ச உசிதஜ்ஞாநம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","அதஏவ தேப்⁴ய​: ஸர்வ்வேப்⁴ய​: ஸ்வேஷு ரக்ஷிதேஷு யூயம்ʼ ப⁴த்³ரம்ʼ கர்ம்ம கரிஷ்யத²| யுஷ்மாகம்ʼ மங்க³லம்ʼ பூ⁴யாத்| ");
INSERT INTO santam_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","தேे விஸ்ருʼஷ்டா​: ஸந்த ஆந்தியகி²யாநக³ர உபஸ்தா²ய லோகநிவஹம்ʼ ஸம்ʼக்³ருʼஹ்ய பத்ரம் அத³த³ந்| ");
INSERT INTO santam_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ததஸ்தே தத்பத்ரம்ʼ படி²த்வா ஸாந்த்வநாம்ʼ ப்ராப்ய ஸாநந்தா³ அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","யிஹூதா³ஸீலௌ ச ஸ்வயம்ʼ ப்ரசாரகௌ பூ⁴த்வா ப்⁴ராத்ருʼக³ணம்ʼ நாநோபதி³ஸ்²ய தாந் ஸுஸ்தி²ராந் அகுருதாம்| ");
INSERT INTO santam_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","இத்த²ம்ʼ தௌ தத்ர தை​: ஸாகம்ʼ கதிபயதி³நாநி யாபயித்வா பஸ்²சாத் ப்ரேரிதாநாம்ʼ ஸமீபே ப்ரத்யாக³மநார்த²ம்ʼ தேஷாம்ʼ ஸந்நிதே⁴​: கல்யாணேந விஸ்ருʼஷ்டாவப⁴வதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","கிந்து ஸீலஸ்தத்ர ஸ்தா²தும்ʼ வாஞ்சி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","அபரம்ʼ பௌலப³ர்ணப்³பௌ³ ப³ஹவ​: ஸி²ஷ்யாஸ்²ச லோகாந் உபதி³ஸ்²ய ப்ரபோ⁴​: ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயந்த ஆந்தியகி²யாயாம்ʼ காலம்ʼ யாபிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","கதிபயதி³நேஷு க³தேஷு பௌலோ ப³ர்ணப்³பா³ம் அவத³த் ஆக³ச்சா²வாம்ʼ யேஷு நக³ரேஷ்வீஸ்²வரஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரிதவந்தௌ தாநி ஸர்வ்வநக³ராணி புநர்க³த்வா ப்⁴ராதர​: கீத்³ருʼஸா²​: ஸந்தீதி த்³ரஷ்டும்ʼ தாந் ஸாக்ஷாத் குர்வ்வ​:| ");
INSERT INTO santam_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","தேந மார்கநாம்நா விக்²யாதம்ʼ யோஹநம்ʼ ஸங்கி³நம்ʼ கர்த்தும்ʼ ப³ர்ணப்³பா³ மதிமகரோத், ");
INSERT INTO santam_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","கிந்து ஸ பூர்வ்வம்ʼ தாப்⁴யாம்ʼ ஸஹ கார்ய்யார்த²ம்ʼ ந க³த்வா பாம்பூ²லியாதே³ஸே² தௌ த்யக்தவாந் தத்காரணாத் பௌலஸ்தம்ʼ ஸங்கி³நம்ʼ கர்த்தும் அநுசிதம்ʼ ஜ்ஞாதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","இத்த²ம்ʼ தயோரதிஸ²யவிரோத⁴ஸ்யோபஸ்தி²தத்வாத் தௌ பரஸ்பரம்ʼ ப்ருʼத²க³ப⁴வதாம்ʼ ததோ ப³ர்ணப்³பா³ மார்கம்ʼ க்³ருʼஹீத்வா போதேந குப்ரோபத்³வீபம்ʼ க³தவாந்; ");
INSERT INTO santam_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","கிந்து பௌல​: ஸீலம்ʼ மநோநீதம்ʼ க்ருʼத்வா ப்⁴ராத்ருʼபி⁴ரீஸ்²வராநுக்³ரஹே ஸமர்பித​: ஸந் ப்ரஸ்தா²ய ");
INSERT INTO santam_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ஸுரியாகிலிகியாதே³ஸா²ப்⁴யாம்ʼ மண்ட³லீ​: ஸ்தி²ரீகுர்வ்வந் அக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","பௌலோ த³ர்ப்³பீ³லுஸ்த்ராநக³ரயோருபஸ்தி²தோப⁴வத் தத்ர தீமதி²யநாமா ஸி²ஷ்ய ஏக ஆஸீத்; ஸ விஸ்²வாஸிந்யா யிஹூதீ³யாயா யோஷிதோ க³ர்ப்³ப⁴ஜாத​: கிந்து தஸ்ய பிதாந்யதே³ஸீ²யலோக​:| ");
INSERT INTO santam_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ஸ ஜநோ லுஸ்த்ரா-இகநியநக³ரஸ்தா²நாம்ʼ ப்⁴ராத்ருʼணாம்ʼ ஸமீபேபி ஸுக்²யாதிமாந் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","பௌலஸ்தம்ʼ ஸ்வஸங்கி³நம்ʼ கர்த்தும்ʼ மதிம்ʼ க்ருʼத்வா தம்ʼ க்³ருʼஹீத்வா தத்³தே³ஸ²நிவாஸிநாம்ʼ யிஹூதீ³யாநாம் அநுரோதா⁴த் தஸ்ய த்வக்சே²த³ம்ʼ க்ருʼதவாந் யதஸ்தஸ்ய பிதா பி⁴ந்நதே³ஸீ²யலோக இதி ஸர்வ்வைரஜ்ஞாயத| ");
INSERT INTO santam_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","தத​: பரம்ʼ தே நக³ரே நக³ரே ப்⁴ரமித்வா யிரூஸா²லமஸ்தை²​: ப்ரேரிதை ர்லோகப்ராசீநைஸ்²ச நிரூபிதம்ʼ யத்³ வ்யவஸ்தா²பத்ரம்ʼ தத³நுஸாரேணாசரிதும்ʼ லோகேப்⁴யஸ்தத்³ த³த்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","தேநைவ ஸர்வ்வே த⁴ர்ம்மஸமாஜா​: க்²ரீஷ்டத⁴ர்ம்மே ஸுஸ்தி²ரா​: ஸந்த​: ப்ரதிதி³நம்ʼ வர்த்³தி⁴தா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","தேஷு ப்²ருகி³யாகா³லாதியாதே³ஸ²மத்⁴யேந க³தேஷு ஸத்ஸு பவித்ர ஆத்மா தாந் ஆஸி²யாதே³ஸே² கதா²ம்ʼ ப்ரகாஸ²யிதும்ʼ ப்ரதிஷித்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ததா² முஸியாதே³ஸ² உபஸ்தா²ய பி³து²நியாம்ʼ க³ந்தும்ʼ தைருத்³யோகே³ க்ருʼதே ஆத்மா தாந் நாந்வமந்யத| ");
INSERT INTO santam_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","தஸ்மாத் தே முஸியாதே³ஸ²ம்ʼ பரித்யஜ்ய த்ரோயாநக³ரம்ʼ க³த்வா ஸமுபஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ராத்ரௌ பௌல​: ஸ்வப்நே த்³ருʼஷ்டவாந் ஏகோ மாகித³நியலோகஸ்திஷ்ட²ந் விநயம்ʼ க்ருʼத்வா தஸ்மை கத²யதி, மாகித³நியாதே³ஸ²ம் ஆக³த்யாஸ்மாந் உபகுர்வ்விதி| ");
INSERT INTO santam_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","தஸ்யேத்த²ம்ʼ ஸ்வப்நத³ர்ஸ²நாத் ப்ரபு⁴ஸ்தத்³தே³ஸீ²யலோகாந் ப்ரதி ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும் அஸ்மாந் ஆஹூயதீதி நிஸ்²சிதம்ʼ பு³த்³த்⁴வா வயம்ʼ தூர்ணம்ʼ மாகித³நியாதே³ஸ²ம்ʼ க³ந்தும் உத்³யோக³ம் அகுர்ம்ம| ");
INSERT INTO santam_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","தத​: பரம்ʼ வயம்ʼ த்ரோயாநக³ராத்³ ப்ரஸ்தா²ய ருʼஜுமார்கே³ண ஸாமத்²ராகியோபத்³வீபேந க³த்வா பரே(அ)ஹநி நியாபலிநக³ர உபஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","தஸ்மாத்³ க³த்வா மாகித³நியாந்தர்வ்வர்த்தி ரோமீயவஸதிஸ்தா²நம்ʼ யத் பி²லிபீநாமப்ரதா⁴நநக³ரம்ʼ தத்ரோபஸ்தா²ய கதிபயதி³நாநி தத்ர ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","விஸ்²ராமவாரே நக³ராத்³ ப³ஹி ர்க³த்வா நதீ³தடே யத்ர ப்ரார்த²நாசார ஆஸீத் தத்ரோபவிஸ்²ய ஸமாக³தா நாரீ​: ப்ரதி கதா²ம்ʼ ப்ராசாரயாம| ");
INSERT INTO santam_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","தத​: து²யாதீராநக³ரீயா தூ⁴ஷராம்ப³ரவிக்ராயிணீ லுதி³யாநாமிகா யா ஈஸ்²வரஸேவிகா யோஷித் ஸ்²ரோத்ரீணாம்ʼ மத்⁴ய ஆஸீத் தயா பௌலோக்தவாக்யாநி யத்³ க்³ருʼஹ்யந்தே தத³ர்த²ம்ʼ ப்ரபு⁴ஸ்தஸ்யா மநோத்³வாரம்ʼ முக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","அத​: ஸா யோஷித் ஸபரிவாரா மஜ்ஜிதா ஸதீ விநயம்ʼ க்ருʼத்வா கதி²தவதீ, யுஷ்மாகம்ʼ விசாராத்³ யதி³ ப்ரபௌ⁴ விஸ்²வாஸிநீ ஜாதாஹம்ʼ தர்ஹி மம க்³ருʼஹம் ஆக³த்ய திஷ்ட²த| இத்த²ம்ʼ ஸா யத்நேநாஸ்மாந் அஸ்தா²பயத்| ");
INSERT INTO santam_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","யஸ்யா க³ணநயா தத³தி⁴பதீநாம்ʼ ப³ஹுத⁴நோபார்ஜநம்ʼ ஜாதம்ʼ தாத்³ருʼஸீ² க³ணகபூ⁴தக்³ரஸ்தா காசந தா³ஸீ ப்ரார்த²நாஸ்தா²நக³மநகால ஆக³த்யாஸ்மாந் ஸாக்ஷாத் க்ருʼதவதீ| ");
INSERT INTO santam_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ஸாஸ்மாகம்ʼ பௌலஸ்ய ச பஸ்²சாத்³ ஏத்ய ப்ரோச்சை​: கதா²மிமாம்ʼ கதி²தவதீ, மநுஷ்யா ஏதே ஸர்வ்வோபரிஸ்த²ஸ்யேஸ்²வரஸ்ய ஸேவகா​: ஸந்தோ(அ)ஸ்மாந் ப்ரதி பரித்ராணஸ்ய மார்க³ம்ʼ ப்ரகாஸ²யந்தி| ");
INSERT INTO santam_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ஸா கந்யா ப³ஹுதி³நாநி தாத்³ருʼஸ²ம் அகரோத் தஸ்மாத் பௌலோ து³​:கி²த​: ஸந் முக²ம்ʼ பராவர்த்ய தம்ʼ பூ⁴தமவத³த்³, அஹம்ʼ யீஸு²க்²ரீஷ்டஸ்ய நாம்நா த்வாமாஜ்ஞாபயாமி த்வமஸ்யா ப³ஹிர்க³ச்ச²; தேநைவ தத்க்ஷணாத் ஸ பூ⁴தஸ்தஸ்யா ப³ஹிர்க³த​:| ");
INSERT INTO santam_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","தத​: ஸ்வேஷாம்ʼ லாப⁴ஸ்ய ப்ரத்யாஸா² விப²லா ஜாதேதி விலோக்ய தஸ்யா​: ப்ரப⁴வ​: பௌலம்ʼ ஸீலஞ்ச த்⁴ருʼத்வாக்ருʼஷ்ய விசாரஸ்தா²நே(அ)தி⁴பதீநாம்ʼ ஸமீபம் ஆநயந்| ");
INSERT INTO santam_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","தத​: ஸா²ஸகாநாம்ʼ நிகடம்ʼ நீத்வா ரோமிலோகா வயம் அஸ்மாகம்ʼ யத்³ வ்யவஹரணம்ʼ க்³ரஹீதும் ஆசரிதுஞ்ச நிஷித்³த⁴ம்ʼ, ");
INSERT INTO santam_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","இமே யிஹூதீ³யலோகா​: ஸந்தோபி ததே³வ ஸி²க்ஷயித்வா நக³ரே(அ)ஸ்மாகம் அதீவ கலஹம்ʼ குர்வ்வந்தி, ");
INSERT INTO santam_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","இதி கதி²தே ஸதி லோகநிவஹஸ்தயோ​: ப்ராதிகூல்யேநோத³திஷ்ட²த் ததா² ஸா²ஸகாஸ்தயோ ர்வஸ்த்ராணி சி²த்வா வேத்ராகா⁴தம்ʼ கர்த்தும் ஆஜ்ஞாபயந்| ");
INSERT INTO santam_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","அபரம்ʼ தே தௌ ப³ஹு ப்ரஹார்ய்ய த்வமேதௌ காராம்ʼ நீத்வா ஸாவதா⁴நம்ʼ ரக்ஷயேதி காராரக்ஷகம் ஆதி³ஸ²ந்| ");
INSERT INTO santam_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","இத்த²ம் ஆஜ்ஞாம்ʼ ப்ராப்ய ஸ தாவப்⁴யந்தரஸ்த²காராம்ʼ நீத்வா பாதே³ஷு பாத³பாஸீ²பி⁴ ர்ப³த்³த்⁴வா ஸ்தா²பிதாவாந்| ");
INSERT INTO santam_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","அத² நிஸீ²த²ஸமயே பௌலஸீலாவீஸ்²வரமுத்³தி³ஸ்²ய ப்ராத²நாம்ʼ கா³நஞ்ச க்ருʼதவந்தௌ, காராஸ்தி²தா லோகாஸ்²ச தத³ஸ்²ருʼண்வந் ");
INSERT INTO santam_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ததா³கஸ்மாத் மஹாந் பூ⁴மிகம்போ(அ)ப⁴வத் தேந பி⁴த்திமூலேந ஸஹ காரா கம்பிதாபூ⁴த் தத்க்ஷணாத் ஸர்வ்வாணி த்³வாராணி முக்தாநி ஜாதாநி ஸர்வ்வேஷாம்ʼ ப³ந்த⁴நாநி ச முக்தாநி| ");
INSERT INTO santam_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","அதஏவ காராரக்ஷகோ நித்³ராதோ ஜாக³ரித்வா காராயா த்³வாராணி முக்தாநி த்³ருʼஷ்ட்வா ப³ந்தி³லோகா​: பலாயிதா இத்யநுமாய கோஷாத் க²ங்க³ம்ʼ ப³ஹி​: க்ருʼத்வாத்மகா⁴தம்ʼ கர்த்தும் உத்³யத​:| ");
INSERT INTO santam_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","கிந்து பௌல​: ப்ரோச்சைஸ்தமாஹூய கதி²தவாந் பஸ்²ய வயம்ʼ ஸர்வ்வே(அ)த்ராஸ்மஹே, த்வம்ʼ நிஜப்ராணஹிம்ʼஸாம்ʼ மாகார்ஷீ​:| ");
INSERT INTO santam_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ததா³ ப்ரதீ³பம் ஆநேதும் உக்த்வா ஸ கம்பமாந​: ஸந் உல்லம்ப்யாப்⁴யந்தரம் ஆக³த்ய பௌலஸீலயோ​: பாதே³ஷு பதிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","பஸ்²சாத் ஸ தௌ ப³ஹிராநீய ப்ருʼஷ்டவாந் ஹே மஹேச்சௌ² பரித்ராணம்ʼ ப்ராப்தும்ʼ மயா கிம்ʼ கர்த்தவ்யம்ʼ? ");
INSERT INTO santam_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","பஸ்²சாத் தௌ ஸ்வக்³ருʼஹமாநீய தயோ​: ஸம்முகே² கா²த்³யத்³ரவ்யாணி ஸ்தா²பிதவாந் ததா² ஸ ஸ்வயம்ʼ ததீ³யா​: ஸர்வ்வே பரிவாராஸ்²சேஸ்²வரே விஸ்²வஸந்த​: ஸாநந்தி³தா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","தஸ்மை தஸ்ய க்³ருʼஹஸ்தி²தஸர்வ்வலோகேப்⁴யஸ்²ச ப்ரபோ⁴​: கதா²ம்ʼ கதி²தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ததா² ராத்ரேஸ்தஸ்மிந்நேவ த³ண்டே³ ஸ தௌ க்³ருʼஹீத்வா தயோ​: ப்ரஹாராணாம்ʼ க்ஷதாநி ப்ரக்ஷாலிதவாந் தத​: ஸ ஸ்வயம்ʼ தஸ்ய ஸர்வ்வே பரிஜநாஸ்²ச மஜ்ஜிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","பஸ்²சாத் தௌ ஸ்வக்³ருʼஹமாநீய தயோ​: ஸம்முகே² கா²த்³யத்³ரவ்யாணி ஸ்தா²பிதவாந் ததா² ஸ ஸ்வயம்ʼ ததீ³யா​: ஸர்வ்வே பரிவாராஸ்²சேஸ்²வரே விஸ்²வஸந்த​: ஸாநந்தி³தா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","தி³ந உபஸ்தி²தே தௌ லோகௌ மோசயேதி கதா²ம்ʼ கத²யிதும்ʼ ஸா²ஸகா​: பதா³திக³ணம்ʼ ப்ரேஷிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","தத​: காராரக்ஷக​: பௌலாய தாம்ʼ வார்த்தாம்ʼ கதி²தவாந் யுவாம்ʼ த்யாஜயிதும்ʼ ஸா²ஸகா லோகாந ப்ரேஷிதவந்த இதா³நீம்ʼ யுவாம்ʼ ப³ஹி ர்பூ⁴த்வா குஸ²லேந ப்ரதிஷ்டே²தாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","கிந்து பௌலஸ்தாந் அவத³த் ரோமிலோகயோராவயோ​: கமபி தோ³ஷம் ந நிஸ்²சித்ய ஸர்வ்வேஷாம்ʼ ஸமக்ஷம் ஆவாம்ʼ கஸ²யா தாட³யித்வா காராயாம்ʼ ப³த்³த⁴வந்த இதா³நீம்ʼ கிமாவாம்ʼ கு³ப்தம்ʼ விஸ்த்ரக்ஷ்யந்தி? தந்ந ப⁴விஷ்யதி, ஸ்வயமாக³த்யாவாம்ʼ ப³ஹி​: க்ருʼத்வா நயந்து| ");
INSERT INTO santam_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ததா³ பதா³திபி⁴​: ஸா²ஸகேப்⁴ய ஏதத்³வார்த்தாயாம்ʼ கதி²தாயாம்ʼ தௌ ரோமிலோகாவிதி கதா²ம்ʼ ஸ்²ருத்வா தே பீ⁴தா​: ");
INSERT INTO santam_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ஸந்தஸ்தயோ​: ஸந்நிதி⁴மாக³த்ய விநயம் அகுர்வ்வந் அபரம்ʼ ப³ஹி​: க்ருʼத்வா நக³ராத் ப்ரஸ்தா²தும்ʼ ப்ரார்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ததஸ்தௌ காராயா நிர்க³த்ய லுதி³யாயா க்³ருʼஹம்ʼ க³தவந்தௌ தத்ர ப்⁴ராத்ருʼக³ணம்ʼ ஸாக்ஷாத்க்ருʼத்ய தாந் ஸாந்த்வயித்வா தஸ்மாத் ஸ்தா²நாத் ப்ரஸ்தி²தௌ| ");
INSERT INTO santam_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","பௌலஸீலௌ ஆம்பி²பல்யாபல்லோநியாநக³ராப்⁴யாம்ʼ க³த்வா யத்ர யிஹூதீ³யாநாம்ʼ ப⁴ஜநப⁴வநமேகம் ஆஸ்தே தத்ர தி²ஷலநீகீநக³ர உபஸ்தி²தௌ| ");
INSERT INTO santam_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ததா³ பௌல​: ஸ்வாசாராநுஸாரேண தேஷாம்ʼ ஸமீபம்ʼ க³த்வா விஸ்²ராமவாரத்ரயே தை​: ஸார்த்³த⁴ம்ʼ த⁴ர்ம்மபுஸ்தகீயகதா²யா விசாரம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ப²லத​: க்²ரீஷ்டேந து³​:க²போ⁴க³​: கர்த்தவ்ய​: ஸ்²மஸா²நது³த்தா²நஞ்ச கர்த்தவ்யம்ʼ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ யஸ்ய யீஸோ²​: ப்ரஸ்தாவம்ʼ கரோமி ஸ ஈஸ்²வரேணாபி⁴ஷிக்த​: ஸ ஏதா​: கதா²​: ப்ரகாஸ்²ய ப்ரமாணம்ʼ த³த்வா ஸ்தி²ரீக்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","தஸ்மாத் தேஷாம்ʼ கதிபயஜநா அந்யதே³ஸீ²யா ப³ஹவோ ப⁴க்தலோகா ப³ஹ்ய​: ப்ரதா⁴நநார்ய்யஸ்²ச விஸ்²வஸ்ய பௌலஸீலயோ​: பஸ்²சாத்³கா³மிநோ ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","கிந்து விஸ்²வாஸஹீநா யிஹூதீ³யலோகா ஈர்ஷ்யயா பரிபூர்ணா​: ஸந்தோ ஹடட்ஸ்ய கதிநயலம்படலோகாந் ஸங்கி³ந​: க்ருʼத்வா ஜநதயா நக³ரமத்⁴யே மஹாகலஹம்ʼ க்ருʼத்வா யாஸோநோ க்³ருʼஹம் ஆக்ரம்ய ப்ரேரிதாந் த்⁴ருʼத்வா லோகநிவஹஸ்ய ஸமீபம் ஆநேதும்ʼ சேஷ்டிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","தேஷாமுத்³தே³ஸ²ம் அப்ராப்ய ச யாஸோநம்ʼ கதிபயாந் ப்⁴ராத்ரும்ʼʼஸ்²ச த்⁴ருʼத்வா நக³ராதி⁴பதீநாம்ʼ நிகடமாநீய ப்ரோச்சை​: கதி²தவந்தோ யே மநுஷ்யா ஜக³து³த்³வாடிதவந்தஸ்தே (அ)த்ராப்யுபஸ்தி²தா​: ஸந்தி, ");
INSERT INTO santam_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ஏஷ யாஸோந் ஆதித்²யம்ʼ க்ருʼத்வா தாந் க்³ருʼஹீதவாந்| யீஸு²நாமக ஏகோ ராஜஸ்தீதி கத²யந்தஸ்தே கைஸரஸ்யாஜ்ஞாவிருத்³த⁴ம்ʼ கர்ம்ம குர்வ்வதி| ");
INSERT INTO santam_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","தேஷாம்ʼ கதா²மிமாம்ʼ ஸ்²ருத்வா லோகநிவஹோ நக³ராதி⁴பதயஸ்²ச ஸமுத்³விக்³நா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ததா³ யாஸோநஸ்தத³ந்யேஷாஞ்ச த⁴நத³ண்ட³ம்ʼ க்³ருʼஹீத்வா தாந் பரித்யக்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","தத​: பரம்ʼ ப்⁴ராத்ருʼக³ணோ ரஜந்யாம்ʼ பௌலஸீலௌ ஸீ²க்⁴ரம்ʼ பி³ரயாநக³ரம்ʼ ப்ரேஷிதவாந் தௌ தத்ரோபஸ்தா²ய யிஹூதீ³யாநாம்ʼ ப⁴ஜநப⁴வநம்ʼ க³தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","தத்ரஸ்தா² லோகா​: தி²ஷலநீகீஸ்த²லோகேப்⁴யோ மஹாத்மாந ஆஸந் யத இத்த²ம்ʼ ப⁴வதி ந வேதி ஜ்ஞாதும்ʼ தி³நே தி³நே த⁴ர்ம்மக்³ரந்த²ஸ்யாலோசநாம்ʼ க்ருʼத்வா ஸ்வைரம்ʼ கதா²ம் அக்³ருʼஹ்லந்| ");
INSERT INTO santam_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","தஸ்மாத்³ அநேகே யிஹூதீ³யா அந்யதே³ஸீ²யாநாம்ʼ மாந்யா ஸ்த்ரிய​: புருஷாஸ்²சாநேகே வ்யஸ்²வஸந்| ");
INSERT INTO santam_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","கிந்து பி³ரயாநக³ரே பௌலேநேஸ்²வரீயா கதா² ப்ரசார்ய்யத இதி தி²ஷலநீகீஸ்தா² யிஹூதீ³யா ஜ்ஞாத்வா தத்ஸ்தா²நமப்யாக³த்ய லோகாநாம்ʼ குப்ரவ்ருʼத்திம் அஜநயந்| ");
INSERT INTO santam_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","அதஏவ தஸ்மாத் ஸ்தா²நாத் ஸமுத்³ரேண யாந்தீதி த³ர்ஸ²யித்வா ப்⁴ராதர​: க்ஷிப்ரம்ʼ பௌலம்ʼ ப்ராஹிண்வந் கிந்து ஸீலதீமதி²யௌ தத்ர ஸ்தி²தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","தத​: பரம்ʼ பௌலஸ்ய மார்க³த³ர்ஸ²காஸ்தம் ஆதீ²நீநக³ர உபஸ்தா²பயந் பஸ்²சாத்³ யுவாம்ʼ தூர்ணம் ஏதத் ஸ்தா²நம்ʼ ஆக³மிஷ்யத²​: ஸீலதீமதி²யௌ ப்ரதீமாம் ஆஜ்ஞாம்ʼ ப்ராப்ய தே ப்ரத்யாக³தா​:| ");
INSERT INTO santam_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","பௌல ஆதீ²நீநக³ரே தாவபேக்ஷ்ய திஷ்ட²ந் தந்நக³ரம்ʼ ப்ரதிமாபி⁴​: பரிபூர்ணம்ʼ த்³ருʼஷ்ட்வா ஸந்தப்தஹ்ருʼத³யோ (அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","தத​: ஸ ப⁴ஜநப⁴வநே யாந் யிஹூதீ³யாந் ப⁴க்தலோகாம்ʼஸ்²ச ஹட்டே ச யாந் அபஸ்²யத் தை​: ஸஹ ப்ரதிதி³நம்ʼ விசாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","கிந்த்விபிகூரீயமதக்³ரஹிண​: ஸ்தோயிகீயமதக்³ராஹிணஸ்²ச கியந்தோ ஜநாஸ்தேந ஸார்த்³த⁴ம்ʼ வ்யவத³ந்த| தத்ர கேசித்³ அகத²யந் ஏஷ வாசால​: கிம்ʼ வக்தும் இச்ச²தி? அபரே கேசித்³ ஏஷ ஜந​: கேஷாஞ்சித்³ விதே³ஸீ²யதே³வாநாம்ʼ ப்ரசாரக இத்யநுமீயதே யத​: ஸ யீஸு²ம் உத்தி²திஞ்ச ப்ரசாரயத்| ");
INSERT INTO santam_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","தே தம் அரேயபாக³நாம விசாரஸ்தா²நம் ஆநீய ப்ராவோசந் இத³ம்ʼ யந்நவீநம்ʼ மதம்ʼ த்வம்ʼ ப்ராசீகஸ² இத³ம்ʼ கீத்³ருʼஸ²ம்ʼ ஏதத்³ அஸ்மாந் ஸ்²ராவய; ");
INSERT INTO santam_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","யாமிமாம் அஸம்ப⁴வகதா²ம் அஸ்மாகம்ʼ கர்ணகோ³சரீக்ருʼதவாந் அஸ்யா பா⁴வார்த²​: க இதி வயம்ʼ ஜ்ஞாதும் இச்சா²ம​:| ");
INSERT INTO santam_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ததா³தீ²நீநிவாஸிநஸ்தந்நக³ரப்ரவாஸிநஸ்²ச கேவலம்ʼ கஸ்யாஸ்²சந நவீநகதா²யா​: ஸ்²ரவணேந ப்ரசாரணேந ச காலம் அயாபயந்| ");
INSERT INTO santam_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","பௌலோ(அ)ரேயபாக³ஸ்ய மத்⁴யே திஷ்ட²ந் ஏதாம்ʼ கதா²ம்ʼ ப்ரசாரிதவாந், ஹே ஆதீ²நீயலோகா யூயம்ʼ ஸர்வ்வதா² தே³வபூஜாயாம் ஆஸக்தா இத்யஹ ப்ரத்யக்ஷம்ʼ பஸ்²யாமி| ");
INSERT INTO santam_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","யத​: பர்ய்யடநகாலே யுஷ்மாகம்ʼ பூஜநீயாநி பஸ்²யந் ‘அவிஜ்ஞாதேஸ்²வராய’ ஏதல்லிபியுக்தாம்ʼ யஜ்ஞவேதீ³மேகாம்ʼ த்³ருʼஷ்டவாந்; அதோ ந விதி³த்வா யம்ʼ பூஜயத்⁴வே தஸ்யைவ தத்வம்ʼ யுஷ்மாந் ப்ரதி ப்ரசாரயாமி| ");
INSERT INTO santam_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ஜக³தோ ஜக³த்ஸ்தா²நாம்ʼ ஸர்வ்வவஸ்தூநாஞ்ச ஸ்ரஷ்டா ய ஈஸ்²வர​: ஸ ஸ்வர்க³ப்ருʼதி²வ்யோரேகாதி⁴பதி​: ஸந் கரநிர்ம்மிதமந்தி³ரேஷு ந நிவஸதி; ");
INSERT INTO santam_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ஸ ஏவ ஸர்வ்வேப்⁴யோ ஜீவநம்ʼ ப்ராணாந் ஸர்வ்வஸாமக்³ரீஸ்²ச ப்ரத³தா³தி; அதஏவ ஸ கஸ்யாஸ்²சித் ஸாமக்³ய்ரா அபா⁴வஹேதோ ர்மநுஷ்யாணாம்ʼ ஹஸ்தை​: ஸேவிதோ ப⁴வதீதி ந| ");
INSERT INTO santam_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ஸ பூ⁴மண்ட³லே நிவாஸார்த²ம் ஏகஸ்மாத் ஸோ²ணிதாத் ஸர்வ்வாந் மநுஷ்யாந் ஸ்ருʼஷ்ட்வா தேஷாம்ʼ பூர்வ்வநிரூபிதஸமயம்ʼ வஸதிஸீமாஞ்ச நிரசிநோத்; ");
INSERT INTO santam_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","தஸ்மாத் லோகை​: கேநாபி ப்ரகாரேண ம்ருʼக³யித்வா பரமேஸ்²வரஸ்ய தத்வம்ʼ ப்ராப்தும்ʼ தஸ்ய க³வேஷணம்ʼ கரணீயம்| ");
INSERT INTO santam_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","கிந்து ஸோ(அ)ஸ்மாகம்ʼ கஸ்மாச்சித³பி தூ³ரே திஷ்ட²தீதி நஹி, வயம்ʼ தேந நிஸ்²வஸநப்ரஸ்²வஸநக³மநாக³மநப்ராணதா⁴ரணாநி குர்ம்ம​:, புुநஸ்²ச யுஷ்மாகமேவ கதிபயா​: கவய​: கத²யந்தி ‘தஸ்ய வம்ʼஸா² வயம்ʼ ஸ்மோ ஹி’ இதி| ");
INSERT INTO santam_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","அதஏவ யதி³ வயம் ஈஸ்²வரஸ்ய வம்ʼஸா² ப⁴வாமஸ்தர்ஹி மநுஷ்யை ர்வித்³யயா கௌஸ²லேந ச தக்ஷிதம்ʼ ஸ்வர்ணம்ʼ ரூப்யம்ʼ த்³ருʼஷத்³ வைதேஷாமீஸ்²வரத்வம் அஸ்மாபி⁴ ர்ந ஜ்ஞாதவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","தேஷாம்ʼ பூர்வ்வீயலோகாநாம் அஜ்ஞாநதாம்ʼ ப்ரதீஸ்²வரோ யத்³யபி நாவாத⁴த்த ததா²பீதா³நீம்ʼ ஸர்வ்வத்ர ஸர்வ்வாந் மந​: பரிவர்த்தயிதும் ஆஜ்ஞாபயதி, ");
INSERT INTO santam_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","யத​: ஸ்வநியுக்தேந புருஷேண யதா³ ஸ ப்ருʼதி²வீஸ்தா²நாம்ʼ ஸர்வ்வலோகாநாம்ʼ விசாரம்ʼ கரிஷ்யதி தத்³தி³நம்ʼ ந்யரூபயத்; தஸ்ய ஸ்²மஸா²நோத்தா²பநேந தஸ்மிந் ஸர்வ்வேப்⁴ய​: ப்ரமாணம்ʼ ப்ராதா³த்| ");
INSERT INTO santam_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ததா³ ஸ்²மஸா²நாத்³ உத்தா²நஸ்ய கதா²ம்ʼ ஸ்²ருத்வா கேசித்³ உபாஹமந், கேசித³வத³ந் ஏநாம்ʼ கதா²ம்ʼ புநரபி த்வத்த​: ஸ்²ரோஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","தத​: பௌலஸ்தேஷாம்ʼ ஸமீபாத் ப்ரஸ்தி²ाதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ததா²பி கேசில்லோகாஸ்தேந ஸார்த்³த⁴ம்ʼ மிலித்வா வ்யஸ்²வஸந் தேஷாம்ʼ மத்⁴யே (அ)ரேயபாகீ³யதி³யநுஸியோ தா³மாரீநாமா காசிந்நாரீ கியந்தோ நராஸ்²சாஸந்| ");
INSERT INTO santam_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","தத்³க⁴டநாத​: பரம்ʼ பௌல ஆதீ²நீநக³ராத்³ யாத்ராம்ʼ க்ருʼத்வா கரிந்த²நக³ரம் ஆக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","தஸ்மிந் ஸமயே க்லௌதி³ய​: ஸர்வ்வாந் யிஹூதீ³யாந் ரோமாநக³ரம்ʼ விஹாய க³ந்தும் ஆஜ்ஞாபயத், தஸ்மாத் ப்ரிஸ்கில்லாநாம்நா ஜாயயா ஸார்த்³த⁴ம் இதாலியாதே³ஸா²த் கிஞ்சித்பூர்வ்வம் ஆக³மத் ய​: பந்ததே³ஸே² ஜாத ஆக்கிலநாமா யிஹூதீ³யலோக​: பௌலஸ்தம்ʼ ஸாக்ஷாத் ப்ராப்ய தயோ​: ஸமீபமிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","தௌ தூ³ஷ்யநிர்ம்மாணஜீவிநௌ, தஸ்மாத் பரஸ்பரம் ஏகவ்ருʼத்திகத்வாத் ஸ தாப்⁴யாம்ʼ ஸஹ உஷித்வா தத் கர்ம்மாகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","பௌல​: ப்ரதிவிஸ்²ராமவாரம்ʼ ப⁴ஜநப⁴வநம்ʼ க³த்வா விசாரம்ʼ க்ருʼத்வா யிஹூதீ³யாந் அந்யதே³ஸீ²யாம்ʼஸ்²ச ப்ரவ்ருʼத்திம்ʼ க்³ராஹிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ஸீலதீமதி²யயோ ர்மாகித³நியாதே³ஸா²த் ஸமேதயோ​: ஸதோ​: பௌல உத்தப்தமநா பூ⁴த்வா யீஸு²ரீஸ்²வரேணாபி⁴ஷிக்தோ ப⁴வதீதி ப்ரமாணம்ʼ யிஹூதீ³யாநாம்ʼ ஸமீபே ப்ராதா³த்| ");
INSERT INTO santam_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","கிந்து தே (அ)தீவ விரோத⁴ம்ʼ விதா⁴ய பாஷண்டீ³யகதா²ம்ʼ கதி²தவந்தஸ்தத​: பௌலோ வஸ்த்ரம்ʼ து⁴ந்வந் ஏதாம்ʼ கதா²ம்ʼ கதி²தவாந், யுஷ்மாகம்ʼ ஸோ²ணிதபாதாபராதோ⁴ யுஷ்மாந் ப்ரத்யேவ ப⁴வது, தேநாஹம்ʼ நிரபராதோ⁴ (அ)த்³யாரப்⁴ய பி⁴ந்நதே³ஸீ²யாநாம்ʼ ஸமீபம்ʼ யாமி| ");
INSERT INTO santam_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ஸ தஸ்மாத் ப்ரஸ்தா²ய ப⁴ஜநப⁴வநஸமீபஸ்த²ஸ்ய யுஸ்தநாம்ந ஈஸ்²வரப⁴க்தஸ்ய பி⁴ந்நதே³ஸீ²யஸ்ய நிவேஸ²நம்ʼ ப்ராவிஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","தத​: க்ரீஷ்பநாமா ப⁴ஜநப⁴வநாதி⁴பதி​: ஸபரிவார​: ப்ரபௌ⁴ வ்யஸ்²வஸீத், கரிந்த²நக³ரீயா ப³ஹவோ லோகாஸ்²ச ஸமாகர்ண்ய விஸ்²வஸ்ய மஜ்ஜிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","க்ஷணதா³யாம்ʼ ப்ரபு⁴​: பௌலம்ʼ த³ர்ஸ²நம்ʼ த³த்வா பா⁴ஷிதவாந், மா பை⁴ஷீ​:, மா நிரஸீ​: கதா²ம்ʼ ப்ரசாரய| ");
INSERT INTO santam_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","அஹம்ʼ த்வயா ஸார்த்³த⁴ம் ஆஸ ஹிம்ʼஸார்த²ம்ʼ கோபி த்வாம்ʼ ஸ்ப்ரஷ்டும்ʼ ந ஸ²க்ஷ்யதி நக³ரே(அ)ஸ்மிந் மதீ³யா லோகா ப³ஹவ ஆஸதே| ");
INSERT INTO santam_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","தஸ்மாத் பௌலஸ்தந்நக³ரே ப்ராயேண ஸார்த்³த⁴வத்ஸரபர்ய்யந்தம்ʼ ஸம்ʼஸ்தா²யேஸ்²வரஸ்ய கதா²ம் உபாதி³ஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","கா³ல்லியநாமா கஸ்²சித்³ ஆகா²யாதே³ஸ²ஸ்ய ப்ராட்³விவாக​: ஸமப⁴வத், ததோ யிஹூதீ³யா ஏகவாக்யா​: ஸந்த​: பௌலம் ஆக்ரம்ய விசாரஸ்தா²நம்ʼ நீத்வா ");
INSERT INTO santam_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","மாநுஷ ஏஷ வ்யவஸ்தா²ய விருத்³த⁴ம் ஈஸ்²வரப⁴ஜநம்ʼ கர்த்தும்ʼ லோகாந் குப்ரவ்ருʼத்திம்ʼ க்³ராஹயதீதி நிவேதி³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","தத​: பௌலே ப்ரத்யுத்தரம்ʼ தா³தும் உத்³யதே ஸதி கா³ல்லியா யிஹூதீ³யாந் வ்யாஹரத், யதி³ கஸ்யசித்³ அந்யாயஸ்ய வாதிஸ²யது³ஷ்டதாசரணஸ்ய விசாரோ(அ)ப⁴விஷ்யத் தர்ஹி யுஷ்மாகம்ʼ கதா² மயா ஸஹநீயாப⁴விஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","கிந்து யதி³ கேவலம்ʼ கதா²யா வா நாம்நோ வா யுஷ்மாகம்ʼ வ்யவஸ்தா²யா விவாதோ³ ப⁴வதி தர்ஹி தஸ்ய விசாரமஹம்ʼ ந கரிஷ்யாமி, யூயம்ʼ தஸ்ய மீமாம்ʼஸாம்ʼ குருத| ");
INSERT INTO santam_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","தத​: ஸ தாந் விசாரஸ்தா²நாத்³ தூ³ரீக்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ததா³ பி⁴ந்நதே³ஸீ²யா​: ஸோஸ்தி²நிநாமாநம்ʼ ப⁴ஜநப⁴வநஸ்ய ப்ரதா⁴நாதி⁴பதிம்ʼ த்⁴ருʼத்வா விசாரஸ்தா²நஸ்ய ஸம்முகே² ப்ராஹரந் ததா²பி கா³ல்லியா தேஷு ஸர்வ்வகர்ம்மஸு ந மநோ ந்யத³தா⁴த்| ");
INSERT INTO santam_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","பௌலஸ்தத்ர புநர்ப³ஹுதி³நாநி ந்யவஸத், ததோ ப்⁴ராத்ருʼக³ணாத்³ விஸர்ஜநம்ʼ ப்ராப்ய கிஞ்சநவ்ரதநிமித்தம்ʼ கிம்ʼக்ரியாநக³ரே ஸி²ரோ முண்ட³யித்வா ப்ரிஸ்கில்லாக்கிலாப்⁴யாம்ʼ ஸஹிதோ ஜலபதே²ந ஸுரியாதே³ஸ²ம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","தத இபி²ஷநக³ர உபஸ்தா²ய தத்ர தௌ விஸ்ருʼஜ்ய ஸ்வயம்ʼ ப⁴ஜநப்⁴வநம்ʼ ப்ரவிஸ்²ய யிஹூதீ³யை​: ஸஹ விசாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","தே ஸ்வை​: ஸார்த்³த⁴ம்ʼ புந​: கதிபயதி³நாநி ஸ்தா²தும்ʼ தம்ʼ வ்யநயந், ஸ தத³நுரரீக்ருʼத்ய கதா²மேதாம்ʼ கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","யிரூஸா²லமி ஆகா³ம்யுத்ஸவபாலநார்த²ம்ʼ மயா க³மநீயம்ʼ; பஸ்²சாத்³ ஈஸ்²வரேச்சா²யாம்ʼ ஜாதாயாம்ʼ யுஷ்மாகம்ʼ ஸமீபம்ʼ ப்ரத்யாக³மிஷ்யாமி| தத​: பரம்ʼ ஸ தை ர்விஸ்ருʼஷ்ட​: ஸந் ஜலபதே²ந இபி²ஷநக³ராத் ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","தத​: கைஸரியாம் உபஸ்தி²த​: ஸந் நக³ரம்ʼ க³த்வா ஸமாஜம்ʼ நமஸ்க்ருʼத்ய தஸ்மாத்³ ஆந்தியகி²யாநக³ரம்ʼ ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","தத்ர கியத்காலம்ʼ யாபயித்வா தஸ்மாத் ப்ரஸ்தா²ய ஸர்வ்வேஷாம்ʼ ஸி²ஷ்யாணாம்ʼ மநாம்ʼஸி ஸுஸ்தி²ராணி க்ருʼத்வா க்ரமஸோ² க³லாதியாப்²ருகி³யாதே³ஸ²யோ ர்ப்⁴ரமித்வா க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","தஸ்மிந்நேவ ஸமயே ஸிகந்த³ரியாநக³ரே ஜாத ஆபல்லோநாமா ஸா²ஸ்த்ரவித் ஸுவக்தா யிஹூதீ³ய ஏகோ ஜந இபி²ஷநக³ரம் ஆக³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ஸ ஸி²க்ஷிதப்ரபு⁴மார்கோ³ மநஸோத்³யோகீ³ ச ஸந் யோஹநோ மஜ்ஜநமாத்ரம்ʼ ஜ்ஞாத்வா யதா²ர்த²தயா ப்ரபோ⁴​: கதா²ம்ʼ கத²யந் ஸமுபாதி³ஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ஏஷ ஜநோ நிர்ப⁴யத்வேந ப⁴ஜநப⁴வநே கத²யிதும் ஆரப்³த⁴வாந், தத​: ப்ரிஸ்கில்லாக்கிலௌ தஸ்யோபதே³ஸ²கதா²ம்ʼ நிஸ²ம்ய தம்ʼ ஸ்வயோ​: ஸமீபம் ஆநீய ஸு²த்³த⁴ரூபேணேஸ்²வரஸ்ய கதா²ம் அபோ³த⁴யதாம்| ");
INSERT INTO santam_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","பஸ்²சாத் ஸ ஆகா²யாதே³ஸ²ம்ʼ க³ந்தும்ʼ மதிம்ʼ க்ருʼதவாந், ததா³ தத்ரத்ய​: ஸி²ஷ்யக³ணோ யதா² தம்ʼ க்³ருʼஹ்லாதி தத³ர்த²ம்ʼ ப்⁴ராத்ருʼக³ணேந ஸமாஸ்²வஸ்ய பத்ரே லிகி²தே ஸதி, ஆபல்லாஸ்தத்ரோபஸ்தி²த​: ஸந் அநுக்³ரஹேண ப்ரத்யயிநாம்ʼ ப³ஹூபகாராந் அகரோத், ");
INSERT INTO santam_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ப²லதோ யீஸு²ரபி⁴ஷிக்தஸ்த்ராதேதி ஸா²ஸ்த்ரப்ரமாணம்ʼ த³த்வா ப்ரகாஸ²ரூபேண ப்ரதிபந்நம்ʼ க்ருʼத்வா யிஹூதீ³யாந் நிருத்தராந் க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","கரிந்த²நக³ர ஆபல்லஸ​: ஸ்தி²திகாலே பௌல உத்தரப்ரதே³ஸை²ராக³ச்ச²ந் இபி²ஷநக³ரம் உபஸ்தி²தவாந்| தத்ர கதிபயஸி²ஷ்யாந் ஸாக்ஷத் ப்ராப்ய தாந் அப்ருʼச்ச²த், ");
INSERT INTO santam_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","யூயம்ʼ விஸ்²வஸ்ய பவித்ரமாத்மாநம்ʼ ப்ராப்தா ந வா? ததஸ்தே ப்ரத்யவத³ந் பவித்ர ஆத்மா தீ³யதே இத்யஸ்மாபி⁴​: ஸ்²ருதமபி நஹி| ");
INSERT INTO santam_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ததா³ ஸா(அ)வத³த் தர்ஹி யூயம்ʼ கேந மஜ்ஜிதா அப⁴வத? தே(அ)கத²யந் யோஹநோ மஜ்ஜநேந| ");
INSERT INTO santam_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ததா³ பௌல உக்தவாந் இத​: பரம்ʼ ய உபஸ்தா²ஸ்யதி தஸ்மிந் அர்த²த யீஸு²க்²ரீஷ்டே விஸ்²வஸிதவ்யமித்யுக்த்வா யோஹந் மந​:பரிவர்த்தநஸூசகேந மஜ்ஜநேந ஜலே லோகாந் அமஜ்ஜயத்| ");
INSERT INTO santam_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","தாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ ஸ்²ருத்வா தே ப்ரபோ⁴ ர்யீஸு²க்²ரீஷ்டஸ்ய நாம்நா மஜ்ஜிதா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","தத​: பௌலேந தேஷாம்ʼ கா³த்ரேஷு கரே(அ)ர்பிதே தேஷாமுபரி பவித்ர ஆத்மாவரூட⁴வாந், தஸ்மாத் தே நாநாதே³ஸீ²யா பா⁴ஷா ப⁴விஷ்யத்கதா²ஸ்²ச கதி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","தே ப்ராயேண த்³வாத³ஸ²ஜநா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","பௌலோ ப⁴ஜநப⁴வநம்ʼ க³த்வா ப்ராயேண மாஸத்ரயம் ஈஸ்²வரஸ்ய ராஜ்யஸ்ய விசாரம்ʼ க்ருʼத்வா லோகாந் ப்ரவர்த்ய ஸாஹஸேந கதா²மகத²யத்| ");
INSERT INTO santam_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","கிந்து கடி²நாந்த​:கரணத்வாத் கியந்தோ ஜநா ந விஸ்²வஸ்ய ஸர்வ்வேஷாம்ʼ ஸமக்ஷம் ஏதத்பத²ஸ்ய நிந்தா³ம்ʼ கர்த்தும்ʼ ப்ரவ்ருʼத்தா​:, அத​: பௌலஸ்தேஷாம்ʼ ஸமீபாத் ப்ரஸ்தா²ய ஸி²ஷ்யக³ணம்ʼ ப்ருʼத²க்க்ருʼத்வா ப்ரத்யஹம்ʼ துராந்நநாம்ந​: கஸ்யசித் ஜநஸ்ய பாட²ஸா²லாயாம்ʼ விசாரம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","இத்த²ம்ʼ வத்ஸரத்³வயம்ʼ க³தம்ʼ தஸ்மாத்³ ஆஸி²யாதே³ஸ²நிவாஸிந​: ஸர்வ்வே யிஹூதீ³யா அந்யதே³ஸீ²யலோகாஸ்²ச ப்ரபோ⁴ ர்யீஸோ²​: கதா²ம் அஸ்²ரௌஷந்| ");
INSERT INTO santam_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","பௌலேந ச ஈஸ்²வர ஏதாத்³ருʼஸா²ந்யத்³பு⁴தாநி கர்ம்மாணி க்ருʼதவாந் ");
INSERT INTO santam_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","யத் பரிதே⁴யே கா³த்ரமார்ஜநவஸ்த்ரே வா தஸ்ய தே³ஹாத் பீடி³தலோகாநாம் ஸமீபம் ஆநீதே தே நிராமயா ஜாதா அபவித்ரா பூ⁴தாஸ்²ச தேப்⁴யோ ப³ஹிர்க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ததா³ தே³ஸா²டநகாரிண​: கியந்தோ யிஹூதீ³யா பூ⁴தாபஸாரிணோ பூ⁴தக்³ரஸ்தநோகாநாம்ʼ ஸந்நிதௌ⁴ ப்ரபே⁴ ர்யீஸோ² ர்நாம ஜப்த்வா வாக்யமித³ம் அவத³ந், யஸ்ய கதா²ம்ʼ பௌல​: ப்ரசாரயதி தஸ்ய யீஸோ² ர்நாம்நா யுஷ்மாந் ஆஜ்ஞாபயாம​:| ");
INSERT INTO santam_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ஸ்கிவநாம்நோ யிஹூதீ³யாநாம்ʼ ப்ரதா⁴நயாஜகஸ்ய ஸப்தபி⁴​: புத்தைஸ்ததா² க்ருʼதே ஸதி ");
INSERT INTO santam_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","கஸ்²சித்³ அபவித்ரோ பூ⁴த​: ப்ரத்யுதி³தவாந், யீஸு²ம்ʼ ஜாநாமி பௌலஞ்ச பரிசிநோமி கிந்து கே யூயம்ʼ? ");
INSERT INTO santam_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","இத்யுக்த்வா ஸோபவித்ரபூ⁴தக்³ரஸ்தோ மநுஷ்யோ லம்ப²ம்ʼ க்ருʼத்வா தேஷாமுபரி பதித்வா ப³லேந தாந் ஜிதவாந், தஸ்மாத்தே நக்³நா​: க்ஷதாங்கா³ஸ்²ச ஸந்தஸ்தஸ்மாத்³ கே³ஹாத் பலாயந்த| ");
INSERT INTO santam_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ஸா வாக்³ இபி²ஷநக³ரநிவாஸிநஸம்ʼ ஸர்வ்வேஷாம்ʼ யிஹூதீ³யாநாம்ʼ பி⁴ந்நதே³ஸீ²யாநாம்ʼ லோகாநாஞ்ச ஸ்²ரவோகோ³சரீபூ⁴தா; தத​: ஸர்வ்வே ப⁴யம்ʼ க³தா​: ப்ரபோ⁴ ர்யீஸோ² ர்நாம்நோ யஸோ² (அ)வர்த்³த⁴த| ");
INSERT INTO santam_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","யேஷாமநேகேஷாம்ʼ லோகாநாம்ʼ ப்ரதீதிரஜாயத த ஆக³த்ய ஸ்வை​: க்ருʼதா​: க்ரியா​: ப்ரகாஸ²ரூபேணாங்கீ³க்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ப³ஹவோ மாயாகர்ம்மகாரிண​: ஸ்வஸ்வக்³ரந்தா²ந் ஆநீய ராஸீ²க்ருʼத்ய ஸர்வ்வேஷாம்ʼ ஸமக்ஷம் அதா³ஹயந், ததோ க³ணநாம்ʼ க்ருʼத்வாபு³த்⁴யந்த பஞ்சாயுதரூப்யமுத்³ராமூல்யபுஸ்தகாநி த³க்³தா⁴நி| ");
INSERT INTO santam_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","இத்த²ம்ʼ ப்ரபோ⁴​: கதா² ஸர்வ்வதே³ஸ²ம்ʼ வ்யாப்ய ப்ரப³லா ஜாதா| ");
INSERT INTO santam_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ஸர்வ்வேஷ்வேதேஷு கர்ம்மஸு ஸம்பந்நேஷு ஸத்ஸு பௌலோ மாகித³நியாகா²யாதே³ஸா²ப்⁴யாம்ʼ யிரூஸா²லமம்ʼ க³ந்தும்ʼ மதிம்ʼ க்ருʼத்வா கதி²தவாந் தத்ஸ்தா²நம்ʼ யாத்ராயாம்ʼ க்ருʼதாயாம்ʼ ஸத்யாம்ʼ மயா ரோமாநக³ரம்ʼ த்³ரஷ்டவ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ஸ்வாநுக³தலோகாநாம்ʼ தீமதி²யேராஸ்தௌ த்³வௌ ஜநௌ மாகித³நியாதே³ஸ²ம்ʼ ப்ரதி ப்ரஹித்ய ஸ்வயம் ஆஸி²யாதே³ஸே² கதிபயதி³நாநி ஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","கிந்து தஸ்மிந் ஸமயே மதே(அ)ஸ்மிந் கலஹோ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","தத்காரணமித³ம்ʼ, அர்த்திமீதே³வ்யா ரூப்யமந்தி³ரநிர்ம்மாணேந ஸர்வ்வேஷாம்ʼ ஸி²ல்பிநாம்ʼ யதே²ஷ்டலாப⁴ம் அஜநயத் யோ தீ³மீத்ரியநாமா நாடீ³ந்த⁴ம​: ");
INSERT INTO santam_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ஸ தாந் தத்கர்ம்மஜீவிந​: ஸர்வ்வலோகாம்ʼஸ்²ச ஸமாஹூய பா⁴ஷிதவாந் ஹே மஹேச்சா² ஏதேந மந்தி³ரநிர்ம்மாணேநாஸ்மாகம்ʼ ஜீவிகா ப⁴வதி, ஏதத்³ யூயம்ʼ வித்த²; ");
INSERT INTO santam_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","கிந்து ஹஸ்தநிர்ம்மிதேஸ்²வரா ஈஸ்²வரா நஹி பௌலநாம்நா கேநசிஜ்ஜநேந கதா²மிமாம்ʼ வ்யாஹ்ருʼத்ய கேவலேபி²ஷநக³ரே நஹி ப்ராயேண ஸர்வ்வஸ்மிந் ஆஸி²யாதே³ஸே² ப்ரவ்ருʼத்திம்ʼ க்³ராஹயித்வா ப³ஹுலோகாநாம்ʼ ஸே²முஷீ பராவர்த்திதா, ஏதத்³ யுஷ்மாபி⁴ ர்த்³ருʼஸ்²யதே ஸ்²ரூயதே ச| ");
INSERT INTO santam_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","தேநாஸ்மாகம்ʼ வாணிஜ்யஸ்ய ஸர்வ்வதா² ஹாநே​: ஸம்ப⁴வநம்ʼ கேவலமிதி நஹி, ஆஸி²யாதே³ஸ²ஸ்தை² ர்வா ஸர்வ்வஜக³த்ஸ்தை² ர்லோகை​: பூஜ்யா யார்திமீ மஹாதே³வீ தஸ்யா மந்தி³ரஸ்யாவஜ்ஞாநஸ்ய தஸ்யா ஐஸ்²வர்ய்யஸ்ய நாஸ²ஸ்ய ச ஸம்பா⁴வநா வித்³யதேे| ");
INSERT INTO santam_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ஏதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ ஸ்²ருத்வா தே மஹாக்ரோதா⁴ந்விதா​: ஸந்த உச்சை​:காரம்ʼ கதி²தவந்த இபி²ஷீயாநாம் அர்த்திமீ தே³வீ மஹதீ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","தத​: ஸர்வ்வநக³ரம்ʼ கலஹேந பரிபூர்ணமப⁴வத், தத​: பரம்ʼ தே மாகித³நீயகா³யாரிஸ்தார்க²நாமாநௌ பௌலஸ்ய த்³வௌ ஸஹசரௌ த்⁴ருʼத்வைகசித்தா ரங்க³பூ⁴மிம்ʼ ஜவேந தா⁴விதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","தத​: பௌலோ லோகாநாம்ʼ ஸந்நிதி⁴ம்ʼ யாதும் உத்³யதவாந் கிந்து ஸி²ஷ்யக³ணஸ்தம்ʼ வாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","பௌலஸ்யத்மீயா ஆஸி²யாதே³ஸ²ஸ்தா²​: கதிபயா​: ப்ரதா⁴நலோகாஸ்தஸ்ய ஸமீபம்ʼ நரமேகம்ʼ ப்ரேஷ்ய த்வம்ʼ ரங்க³பூ⁴மிம்ʼ மாகா³ இதி ந்யவேத³யந்| ");
INSERT INTO santam_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ததோ நாநாலோகாநாம்ʼ நாநாகதா²கத²நாத் ஸபா⁴ வ்யாகுலா ஜாதா கிம்ʼ காரணாத்³ ஏதாவதீ ஜநதாப⁴வத் ஏதத்³ அதி⁴கை ர்லோகை ர்நாஜ்ஞாயி| ");
INSERT INTO santam_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","தத​: பரம்ʼ ஜநதாமத்⁴யாத்³ யிஹூதீ³யைர்ப³ஹிஷ்க்ருʼத​: ஸிகந்த³ரோ ஹஸ்தேந ஸங்கேதம்ʼ க்ருʼத்வா லோகேப்⁴ய உத்தரம்ʼ தா³துமுத்³யதவாந், ");
INSERT INTO santam_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","கிந்து ஸ யிஹூதீ³யலோக இதி நிஸ்²சிதே ஸதி இபி²ஷீயாநாம் அர்த்திமீ தே³வீ மஹதீதி வாக்யம்ʼ ப்ராயேண பஞ்ச த³ண்டா³ந் யாவத்³ ஏகஸ்வரேண லோகநிவஹை​: ப்ரோக்தம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ததோ நக³ராதி⁴பதிஸ்தாந் ஸ்தி²ராந் க்ருʼத்வா கதி²தவாந் ஹே இபி²ஷாயா​: ஸர்வ்வே லோகா ஆகர்ணயத, அர்திமீமஹாதே³வ்யா மஹாதே³வாத் பதிதாயாஸ்தத்ப்ரதிமாயாஸ்²ச பூஜநம இபி²ஷநக³ரஸ்தா²​: ஸர்வ்வே லோகா​: குர்வ்வந்தி, ஏதத் கே ந ஜாநந்தி? ");
INSERT INTO santam_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","தஸ்மாத்³ ஏதத்ப்ரதிகூலம்ʼ கேபி கத²யிதும்ʼ ந ஸ²க்நுவந்தி, இதி ஜ்ஞாத்வா யுஷ்மாபி⁴​: ஸுஸ்தி²ரத்வேந ஸ்தா²தவ்யம் அவிவிச்ய கிமபி கர்ம்ம ந கர்த்தவ்யஞ்ச| ");
INSERT INTO santam_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","யாந் ஏதாந் மநுஷ்யாந் யூயமத்ர ஸமாநயத தே மந்தி³ரத்³ரவ்யாபஹாரகா யுஷ்மாகம்ʼ தே³வ்யா நிந்த³காஸ்²ச ந ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","யதி³ கஞ்சந ப்ரதி தீ³மீத்ரியஸ்ய தஸ்ய ஸஹாயாநாஞ்ச காசித்³ ஆபத்தி ர்வித்³யதே தர்ஹி ப்ரதிநிதி⁴லோகா விசாரஸ்தா²நஞ்ச ஸந்தி, தே தத் ஸ்தா²நம்ʼ க³த்வா உத்தரப்ரத்யுத்தரே குர்வ்வந்து| ");
INSERT INTO santam_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","கிந்து யுஷ்மாகம்ʼ காசித³பரா கதா² யதி³ திஷ்ட²தி தர்ஹி நியமிதாயாம்ʼ ஸபா⁴யாம்ʼ தஸ்யா நிஷ்பத்தி ர்ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","கிந்த்வேதஸ்ய விரோத⁴ஸ்யோத்தரம்ʼ யேந தா³தும்ʼ ஸ²க்நும் ஏதாத்³ருʼஸ²ஸ்ய கஸ்யசித் காரணஸ்யாபா⁴வாத்³ அத்³யதநக⁴டநாஹேதோ ராஜத்³ரோஹிணாமிவாஸ்மாகம் அபி⁴யோகோ³ ப⁴விஷ்யதீதி ஸ²ங்கா வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","இதி கத²யித்வா ஸ ஸபா⁴ஸ்த²லோகாந் விஸ்ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","இத்த²ம்ʼ கலஹே நிவ்ருʼத்தே ஸதி பௌல​: ஸி²ஷ்யக³ணம் ஆஹூய விஸர்ஜநம்ʼ ப்ராப்ய மாகித³நியாதே³ஸ²ம்ʼ ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","தேந ஸ்தா²நேந க³ச்ச²ந் தத்³தே³ஸீ²யாந் ஸி²ஷ்யாந் ப³ஹூபதி³ஸ்²ய யூநாநீயதே³ஸ²ம் உபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","தத்ர மாஸத்ரயம்ʼ ஸ்தி²த்வா தஸ்மாத் ஸுரியாதே³ஸ²ம்ʼ யாதும் உத்³யத​:, கிந்து யிஹூதீ³யாஸ்தம்ʼ ஹந்தும்ʼ கு³ப்தா அதிஷ்ட²ந் தஸ்மாத் ஸ புநரபி மாகித³நியாமார்கே³ண ப்ரத்யாக³ந்தும்ʼ மதிம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","பி³ரயாநக³ரீயஸோபாத்ர​: தி²ஷலநீகீயாரிஸ்தார்க²ஸிகுந்தௌ³ த³ர்ப்³போ³நக³ரீயகா³யதீமதி²யௌ ஆஸி²யாதே³ஸீ²யதுகி²கத்ரபி²மௌ ச தேந ஸார்த்³த⁴ம்ʼ ஆஸி²யாதே³ஸ²ம்ʼ யாவத்³ க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ஏதே ஸர்வ்வே (அ)க்³ரஸரா​: ஸந்தோ (அ)ஸ்மாந் அபேக்ஷ்ய த்ரோயாநக³ரே ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","கிண்வஸூ²ந்யபூபோத்ஸவதி³நே ச க³தே ஸதி வயம்ʼ பி²லிபீநக³ராத் தோயபதே²ந க³த்வா பஞ்சபி⁴ ர்தி³நைஸ்த்ரோயாநக³ரம் உபஸ்தா²ய தத்ர ஸப்ததி³நாந்யவாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ஸப்தாஹஸ்ய ப்ரத²மதி³நே பூபாந் ப⁴ம்ʼக்து ஸி²ஷ்யேஷு மிலிதேஷு பௌல​: பரதி³நே தஸ்மாத் ப்ரஸ்தா²தும் உத்³யத​: ஸந் தத³ஹ்நி ப்ராயேண க்ஷபாயா யாமத்³வயம்ʼ யாவத் ஸி²ஷ்யேப்⁴யோ த⁴ர்ம்மகதா²ம் அகத²யத்| ");
INSERT INTO santam_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","உபரிஸ்தே² யஸ்மிந் ப்ரகோஷ்டே² ஸபா⁴ம்ʼ க்ருʼத்வாஸந் தத்ர ப³ஹவ​: ப்ரதீ³பா​: ப்ராஜ்வலந்| ");
INSERT INTO santam_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","உதுக²நாமா கஸ்²சந யுவா ச வாதாயந உபவிஸ²ந் கோ⁴ரதரநித்³ராக்³ரஸ்தோ (அ)பூ⁴த் ததா³ பௌலேந ப³ஹுக்ஷணம்ʼ கதா²யாம்ʼ ப்ரசாரிதாயாம்ʼ நித்³ராமக்³ந​: ஸ தஸ்மாத்³ உபரிஸ்த²த்ருʼதீயப்ரகோஷ்டா²த்³ அபதத், ததோ லோகாஸ்தம்ʼ ம்ருʼதகல்பம்ʼ த்⁴ருʼத்வோத³தோலயந்| ");
INSERT INTO santam_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","தத​: பௌலோ(அ)வருஹ்ய தஸ்ய கா³த்ரே பதித்வா தம்ʼ க்ரோடே³ நிதா⁴ய கதி²தவாந், யூயம்ʼ வ்யாகுலா மா பூ⁴த நாயம்ʼ ப்ராணை ர்வியுக்த​:| ");
INSERT INTO santam_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","பஸ்²சாத் ஸ புநஸ்²சோபரி க³த்வா பூபாந் ப⁴ம்ʼக்த்வா ப்ரபா⁴தம்ʼ யாவத் கதோ²பகத²நே க்ருʼத்வா ப்ரஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","தே ச தம்ʼ ஜீவந்தம்ʼ யுவாநம்ʼ க்³ருʼஹீத்வா க³த்வா பரமாப்யாயிதா ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","அநந்தரம்ʼ வயம்ʼ போதேநாக்³ரஸரா பூ⁴த்வாஸ்மநக³ரம் உத்தீர்ய்ய பௌலம்ʼ க்³ரஹீதும்ʼ மதிம் அகுர்ம்ம யத​: ஸ தத்ர பத்³ப்⁴யாம்ʼ வ்ரஜிதும்ʼ மதிம்ʼ க்ருʼத்வேதி நிரூபிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","தஸ்மாத் தத்ராஸ்மாபி⁴​: ஸார்த்³த⁴ம்ʼ தஸ்மிந் மிலிதே ஸதி வயம்ʼ தம்ʼ நீத்வா மிதுலீந்யுபத்³வீபம்ʼ ப்ராப்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","தஸ்மாத் போதம்ʼ மோசயித்வா பரே(அ)ஹநி கீ²யோபத்³வீபஸ்ய ஸம்முக²ம்ʼ லப்³த⁴வந்தஸ்தஸ்மாத்³ ஏகேநாஹ்நா ஸாமோபத்³வீபம்ʼ க³த்வா போதம்ʼ லாக³யித்வா த்ரோகு³ல்லியே ஸ்தி²த்வா பரஸ்மிந் தி³வஸேे மிலீதநக³ரம் உபாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","யத​: பௌல ஆஸி²யாதே³ஸே² காலம்ʼ யாபயிதும் நாபி⁴லஷந் இபி²ஷநக³ரம்ʼ த்யக்த்வா யாதும்ʼ மந்த்ரணாம்ʼ ஸ்தி²ரீக்ருʼதவாந்; யஸ்மாத்³ யதி³ ஸாத்⁴யம்ʼ ப⁴வதி தர்ஹி நிஸ்தாரோத்ஸவஸ்ய பஞ்சாஸ²த்தமதி³நே ஸ யிரூஸா²லம்யுபஸ்தா²தும்ʼ மதிம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","பௌலோ மிலீதாத்³ இபி²ஷம்ʼ ப்ரதி லோகம்ʼ ப்ரஹித்ய ஸமாஜஸ்ய ப்ராசீநாந் ஆஹூயாநீதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","தேஷு தஸ்ய ஸமீபம் உபஸ்தி²தேஷு ஸ தேப்⁴ய இமாம்ʼ கதா²ம்ʼ கதி²தவாந், அஹம் ஆஸி²யாதே³ஸே² ப்ரத²மாக³மநம் ஆரப்⁴யாத்³ய யாவத்³ யுஷ்மாகம்ʼ ஸந்நிதௌ⁴ ஸ்தி²த்வா ஸர்வ்வஸமயே யதா²சரிதவாந் தத்³ யூயம்ʼ ஜாநீத²; ");
INSERT INTO santam_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ப²லத​: ஸர்வ்வதா² நம்ரமநா​: ஸந் ப³ஹுஸ்²ருபாதேந யிஹுதீ³யாநாம் குமந்த்ரணாஜாதநாநாபரீக்ஷாபி⁴​: ப்ரபோ⁴​: ஸேவாமகரவம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","காமபி ஹிதகதா²ाம்ʼ ந கோ³பாயிதவாந் தாம்ʼ ப்ரசார்ய்ய ஸப்ரகாஸ²ம்ʼ க்³ருʼஹே க்³ருʼஹே ஸமுபதி³ஸ்²யேஸ்²வரம்ʼ ப்ரதி மந​: பராவர்த்தநீயம்ʼ ப்ரபௌ⁴ யீஸு²க்²ரீஷ்டே விஸ்²வஸநீயம்ʼ ");
INSERT INTO santam_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","யிஹூதீ³யாநாம் அந்யதே³ஸீ²யலோகாநாஞ்ச ஸமீப ஏதாத்³ருʼஸ²ம்ʼ ஸாக்ஷ்யம்ʼ த³தா³மி| ");
INSERT INTO santam_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","பஸ்²யத ஸாம்ப்ரதம் ஆத்மநாக்ருʼஷ்ட​: ஸந் யிரூஸா²லம்நக³ரே யாத்ராம்ʼ கரோமி, தத்ர மாம்ப்ரதி யத்³யத்³ க⁴டிஷ்யதே தாந்யஹம்ʼ ந ஜாநாமி; ");
INSERT INTO santam_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","கிந்து மயா ப³ந்த⁴நம்ʼ க்லேஸ²ஸ்²ச போ⁴க்தவ்ய இதி பவித்ர ஆத்மா நக³ரே நக³ரே ப்ரமாணம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ததா²பி தம்ʼ க்லேஸ²மஹம்ʼ த்ருʼணாய ந மந்யே; ஈஸ்²வரஸ்யாநுக்³ரஹவிஷயகஸ்ய ஸுஸம்ʼவாத³ஸ்ய ப்ரமாணம்ʼ தா³தும்ʼ, ப்ரபோ⁴ ர்யீஸோ²​: ஸகாஸா²த³ யஸ்யா​: ஸேவாயா​: பா⁴ரம்ʼ ப்ராப்நவம்ʼ தாம்ʼ ஸேவாம்ʼ ஸாத⁴யிதும்ʼ ஸாநந்த³ம்ʼ ஸ்வமார்க³ம்ʼ ஸமாபயிதுुஞ்ச நிஜப்ராணாநபி ப்ரியாந் ந மந்யே| ");
INSERT INTO santam_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","அது⁴நா பஸ்²யத யேஷாம்ʼ ஸமீபே(அ)ஹம் ஈஸ்²வரீயராஜ்யஸ்ய ஸுஸம்ʼவாத³ம்ʼ ப்ரசார்ய்ய ப்⁴ரமணம்ʼ க்ருʼதவாந் ஏதாத்³ருʼஸா² யூயம்ʼ மம வத³நம்ʼ புந ர்த்³ரஷ்டும்ʼ ந ப்ராப்ஸ்யத² ஏதத³ப்யஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","யுஷ்மப்⁴யம் அஹம் ஈஸ்²வரஸ்ய ஸர்வ்வாந் ஆதே³ஸா²ந் ப்ரகாஸ²யிதும்ʼ ந ந்யவர்த்தே| ");
INSERT INTO santam_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","அஹம்ʼ ஸர்வ்வேஷாம்ʼ லோகாநாம்ʼ ரக்தபாததோ³ஷாத்³ யந்நிர்தோ³ஷ ஆஸே தஸ்யாத்³ய யுஷ்மாந் ஸாக்ஷிண​: கரோமி| ");
INSERT INTO santam_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","யூயம்ʼ ஸ்வேஷு ததா² யஸ்ய வ்ரஜஸ்யாத்⁴யக்ஷந் ஆத்மா யுஷ்மாந் விதா⁴ய ந்யயுங்க்த தத்ஸர்வ்வஸ்மிந் ஸாவதா⁴நா ப⁴வத, ய ஸமாஜஞ்ச ப்ரபு⁴ ர்நிஜரக்தமூல்யேந க்ரீதவாந தம் அவத, ");
INSERT INTO santam_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","யதோ மயா க³மநே க்ருʼதஏவ து³ர்ஜயா வ்ருʼகா யுஷ்மாகம்ʼ மத்⁴யம்ʼ ப்ரவிஸ்²ய வ்ரஜம்ʼ ப்ரதி நிர்த³யதாம் ஆசரிஷ்யந்தி, ");
INSERT INTO santam_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","யுஷ்மாகமேவ மத்⁴யாத³பி லோகா உத்தா²ய ஸி²ஷ்யக³ணம் அபஹந்தும்ʼ விபரீதம் உபதே³க்ஷ்யந்தீத்யஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","இதி ஹேதோ ர்யூயம்ʼ ஸசைதந்யா​: ஸந்தஸ்திஷ்டத, அஹஞ்ச ஸாஸ்²ருபாத​: ஸந் வத்ஸரத்ரயம்ʼ யாவத்³ தி³வாநிஸ²ம்ʼ ப்ரதிஜநம்ʼ போ³த⁴யிதும்ʼ ந ந்யவர்த்தே தத³பி ஸ்மரத| ");
INSERT INTO santam_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","இதா³நீம்ʼ ஹே ப்⁴ராதரோ யுஷ்மாகம்ʼ நிஷ்டா²ம்ʼ ஜநயிதும்ʼ பவித்ரீக்ருʼதலோகாநாம்ʼ மத்⁴யே(அ)தி⁴காரஞ்ச தா³தும்ʼ ஸமர்தோ² ய ஈஸ்²வரஸ்தஸ்யாநுக்³ரஹஸ்ய யோ வாத³ஸ்²ச தயோருப⁴யோ ர்யுஷ்மாந் ஸமார்பயம்| ");
INSERT INTO santam_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","கஸ்யாபி ஸ்வர்ணம்ʼ ரூப்யம்ʼ வஸ்த்ரம்ʼ வா ப்ரதி மயா லோபோ⁴ ந க்ருʼத​:| ");
INSERT INTO santam_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","கிந்து மம மத்ஸஹசரலோகாநாஞ்சாவஸ்²யகவ்யயாய மதீ³யமித³ம்ʼ கரத்³வயம் அஸ்²ராம்யத்³ ஏதத்³ யூயம்ʼ ஜாநீத²| ");
INSERT INTO santam_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","அநேந ப்ரகாரேண க்³ரஹணத்³ தா³நம்ʼ ப⁴த்³ரமிதி யத்³வாக்யம்ʼ ப்ரபு⁴ ர்யீஸு²​: கதி²தவாந் தத் ஸ்மர்த்தும்ʼ த³ரித்³ரலோகாநாமுபகாரார்த²ம்ʼ ஸ்²ரமம்ʼ கர்த்துஞ்ச யுஷ்மாகம் உசிதம் ஏதத்ஸர்வ்வம்ʼ யுஷ்மாநஹம் உபதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ஏதாம்ʼ கதா²ம்ʼ கத²யித்வா ஸ ஜாநுநீ பாதயித்வா ஸர்வை​: ஸஹ ப்ரார்த²யத| ");
INSERT INTO santam_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","தேந தே க்ரந்த்³ரந்த​: ");
INSERT INTO santam_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","புந ர்மம முக²ம்ʼ ந த்³ரக்ஷ்யத² விஸே²ஷத ஏஷா யா கதா² தேநாகதி² தத்காரணாத் ஸோ²கம்ʼ விலாபஞ்ச க்ருʼத்வா கண்ட²ம்ʼ த்⁴ருʼத்வா சும்பி³தவந்த​:| பஸ்²சாத் தே தம்ʼ போதம்ʼ நீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","தை ர்விஸ்ருʼஷ்டா​: ஸந்தோ வயம்ʼ போதம்ʼ பா³ஹயித்வா ருʼஜுமார்கே³ண கோஷம் உபத்³வீபம் ஆக³த்ய பரே(அ)ஹநி ரோதி³யோபத்³வீபம் ஆக³ச்சா²ம ததஸ்தஸ்மாத் பாதாராயாம் உபாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","தத்ர பை²நீகியாதே³ஸ²கா³மிநம் போதமேகம்ʼ ப்ராப்ய தமாருஹ்ய க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","குப்ரோபத்³வீபம்ʼ த்³ருʼஷ்ட்வா தம்ʼ ஸவ்யதி³ஸி² ஸ்தா²பயித்வா ஸுரியாதே³ஸ²ம்ʼ க³த்வா போதஸ்த²த்³ரவ்யாண்யவரோஹயிதும்ʼ ஸோரநக³ரே லாகி³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","தத்ர ஸி²ஷ்யக³ணஸ்ய ஸாக்ஷாத்கரணாய வயம்ʼ தத்ர ஸப்ததி³நாநி ஸ்தி²தவந்த​: பஸ்²சாத்தே பவித்ரேணாத்மநா பௌலம்ʼ வ்யாஹரந் த்வம்ʼ யிரூஸா²லம்நக³ரம்ʼ மா க³ம​:| ");
INSERT INTO santam_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ததஸ்தேஷு ஸப்தஸு தி³நேஷு யாபிதேஷு ஸத்ஸு வயம்ʼ தஸ்மாத் ஸ்தா²நாத் நிஜவர்த்மநா க³தவந்த​:, தஸ்மாத் தே ஸபா³லவ்ருʼத்³த⁴வநிதா அஸ்மாபி⁴​: ஸஹ நக³ரஸ்ய பரிஸரபர்ய்யந்தம் ஆக³தா​: பஸ்²சாத்³வயம்ʼ ஜலதி⁴தடே ஜாநுபாதம்ʼ ப்ரார்த²யாமஹி| ");
INSERT INTO santam_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","தத​: பரஸ்பரம்ʼ விஸ்ருʼஷ்டா​: ஸந்தோ வயம்ʼ போதம்ʼ க³தாஸ்தே து ஸ்வஸ்வக்³ருʼஹம்ʼ ப்ரத்யாக³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","வயம்ʼ ஸோரநக³ராத் நாவா ப்ரஸ்தா²ய தலிமாயிநக³ரம் உபாதிஷ்டா²ம தத்ராஸ்மாகம்ʼ ஸமுத்³ரீயமார்க³ஸ்யாந்தோ(அ)ப⁴வத் தத்ர ப்⁴ராத்ருʼக³ணம்ʼ நமஸ்க்ருʼத்ய தி³நமேகம்ʼ தை​: ஸார்த்³த⁴ம் உஷதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","பரே (அ)ஹநி பௌலஸ்தஸ்ய ஸங்கி³நோ வயஞ்ச ப்ரதிஷ்ட²மாநா​: கைஸரியாநக³ரம் ஆக³த்ய ஸுஸம்ʼவாத³ப்ரசாரகாநாம்ʼ ஸப்தஜநாநாம்ʼ பி²லிபநாம்ந ஏகஸ்ய க்³ருʼஹம்ʼ ப்ரவிஸ்²யாவதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","தஸ்ய சதஸ்ரோ து³ஹிதரோ(அ)நூடா⁴ ப⁴விஷ்யத்³வாதி³ந்ய ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","தத்ராஸ்மாஸு ப³ஹுதி³நாநி ப்ரோஷிதேஷு யிஹூதீ³யதே³ஸா²த்³ ஆக³த்யாகா³ப³நாமா ப⁴விஷ்யத்³வாதீ³ ஸமுபஸ்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ஸோஸ்மாகம்ʼ ஸமீபமேத்ய பௌலஸ்ய கடிப³ந்த⁴நம்ʼ க்³ருʼஹீத்வா நிஜஹஸ்தாபாதா³ந் ப³த்³த்⁴வா பா⁴ஷிதவாந் யஸ்யேத³ம்ʼ கடிப³ந்த⁴நம்ʼ தம்ʼ யிஹூதீ³யலோகா யிரூஸா²லமநக³ர இத்த²ம்ʼ ப³த்³த்⁴வா பி⁴ந்நதே³ஸீ²யாநாம்ʼ கரேஷு ஸமர்பயிஷ்யந்தீதி வாக்யம்ʼ பவித்ர ஆத்மா கத²யதி| ");
INSERT INTO santam_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ஏதாத்³ருʼஸீ²ம்ʼ கதா²ம்ʼ ஸ்²ருத்வா வயம்ʼ தந்நக³ரவாஸிநோ ப்⁴ராதரஸ்²ச யிரூஸா²லமம்ʼ ந யாதும்ʼ பௌலம்ʼ வ்யநயாமஹி; ");
INSERT INTO santam_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","கிந்து ஸ ப்ரத்யாவாதீ³த், யூயம்ʼ கிம்ʼ குருத²? கிம்ʼ க்ரந்த³நேந மமாந்த​:கரணம்ʼ விதீ³ர்ணம்ʼ கரிஷ்யத²? ப்ரபோ⁴ ர்யீஸோ² ர்நாம்நோ நிமித்தம்ʼ யிரூஸா²லமி ப³த்³தோ⁴ ப⁴விதும்ʼ கேவல தந்ந ப்ராணாந் தா³துமபி ஸஸஜ்ஜோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","தேநாஸ்மாகம்ʼ கதா²யாம் அக்³ருʼஹீதாயாம் ஈஸ்²வரஸ்ய யதே²ச்சா² ததை²வ ப⁴வத்வித்யுக்த்வா வயம்ʼ நிரஸ்யாம| ");
INSERT INTO santam_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","பரே(அ)ஹநி பாதே²யத்³ரவ்யாணி க்³ருʼஹீத்வா யிரூஸா²லமம்ʼ ப்ரதி யாத்ராம் அகுர்ம்ம| ");
INSERT INTO santam_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","தத​: கைஸரியாநக³ரநிவாஸிந​: கதிபயா​: ஸி²ஷ்யா அஸ்மாபி⁴​: ஸார்த்³த⁴ம் இத்வா க்ருʼப்ரீயேந ம்நாஸந்நாம்நா யேந ப்ராசீநஸி²ஷ்யேந ஸார்த்³த⁴ம் அஸ்மாபி⁴ ர்வஸ்தவ்யம்ʼ தஸ்ய ஸமீபம் அஸ்மாந் நீதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","அஸ்மாஸு யிரூஸா²லம்யுபஸ்தி²தேஷு தத்ரஸ்த²ப்⁴ராத்ருʼக³ணோ(அ)ஸ்மாந் ஆஹ்லாதே³ந க்³ருʼஹீதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","பரஸ்மிந் தி³வஸே பௌலே(அ)ஸ்மாபி⁴​: ஸஹ யாகூபோ³ க்³ருʼஹம்ʼ ப்ரவிஷ்டே லோகப்ராசீநா​: ஸர்வ்வே தத்ர பரிஷதி³ ஸம்ʼஸ்தி²தா​:| ");
INSERT INTO santam_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","அநந்தரம்ʼ ஸ தாந் நத்வா ஸ்வீயப்ரசாரணேந பி⁴ந்நதே³ஸீ²யாந் ப்ரதீஸ்²வரோ யாநி கர்ம்மாணி ஸாதி⁴தவாந் ததீ³யாம்ʼ கதா²ம் அநுக்ரமாத் கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","இதி ஸ்²ருத்வா தே ப்ரபு⁴ம்ʼ த⁴ந்யம்ʼ ப்ரோச்ய வாக்யமித³ம் அபா⁴ஷந்த, ஹே ப்⁴ராத ர்யிஹூதீ³யாநாம்ʼ மத்⁴யே ப³ஹுஸஹஸ்ராணி லோகா விஸ்²வாஸிந ஆஸதே கிந்து தே ஸர்வ்வே வ்யவஸ்தா²மதாசாரிண ஏதத் ப்ரத்யக்ஷம்ʼ பஸ்²யஸி| ");
INSERT INTO santam_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ஸி²ஸூ²நாம்ʼ த்வக்சே²த³நாத்³யாசரணம்ʼ ப்ரதிஷித்⁴ய த்வம்ʼ பி⁴ந்நதே³ஸ²நிவாஸிநோ யிஹூதீ³யலோகாந் மூஸாவாக்யம் அஸ்²ரத்³தா⁴தும் உபதி³ஸ²ஸீதி தை​: ஸ்²ருதமஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","த்வமத்ராக³தோஸீதி வார்த்தாம்ʼ ஸமாகர்ண்ய ஜநநிவஹோ மிலித்வாவஸ்²யமேவாக³மிஷ்யதி; அதஏவ கிம்ʼ கரணீயம்? அத்ர வயம்ʼ மந்த்ரயித்வா ஸமுபாயம்ʼ த்வாம்ʼ வதா³மஸ்தம்ʼ த்வமாசர| ");
INSERT INTO santam_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","வ்ரதம்ʼ கர்த்தும்ʼ க்ருʼதஸங்கல்பா யே(அ)ஸ்மாம்ʼக சத்வாரோ மாநவா​: ஸந்தி ");
INSERT INTO santam_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","தாந் க்³ருʼஹீத்வா தை​: ஸஹித​: ஸ்வம்ʼ ஸு²சிம்ʼ குரு ததா² தேஷாம்ʼ ஸி²ரோமுண்ட³நே யோ வ்யயோ ப⁴வதி தம்ʼ த்வம்ʼ தே³ஹி| ததா² க்ருʼதே த்வதீ³யாசாரே யா ஜநஸ்²ருதி ர்ஜாயதே ஸாலீகா கிந்து த்வம்ʼ விதி⁴ம்ʼ பாலயந் வ்யவஸ்தா²நுஸாரேணேவாசரஸீதி தே போ⁴த்ஸந்தே| ");
INSERT INTO santam_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","பி⁴ந்நதே³ஸீ²யாநாம்ʼ விஸ்²வாஸிலோகாநாம்ʼ நிகடே வயம்ʼ பத்ரம்ʼ லிகி²த்வேத்த²ம்ʼ ஸ்தி²ரீக்ருʼதவந்த​:, தே³வப்ரஸாத³போ⁴ஜநம்ʼ ரக்தம்ʼ க³லபீட³நமாரிதப்ராணிபோ⁴ஜநம்ʼ வ்யபி⁴சாரஸ்²சைதேப்⁴ய​: ஸ்வரக்ஷணவ்யதிரேகேண தேஷாமந்யவிதி⁴பாலநம்ʼ கரணீயம்ʼ ந| ");
INSERT INTO santam_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","தத​: பௌலஸ்தாந் மாநுஷாநாதா³ய பரஸ்மிந் தி³வஸே தை​: ஸஹ ஸு²சி ர்பூ⁴த்வா மந்தி³ரம்ʼ க³த்வா ஸௌ²சகர்ம்மணோ தி³நேஷு ஸம்பூர்ணேஷு தேஷாம் ஏகைகார்த²ம்ʼ நைவேத்³யாத்³யுத்ஸர்கோ³ ப⁴விஷ்யதீதி ஜ்ஞாபிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","தேஷு ஸப்தஸு தி³நேஷு ஸமாப்தகல்பேஷு ஆஸி²யாதே³ஸ²நிவாஸிநோ யிஹூதீ³யாஸ்தம்ʼ மத்⁴யேமந்தி³ரம்ʼ விலோக்ய ஜநநிவஹஸ்ய மந​:ஸு குப்ரவ்ருʼத்திம்ʼ ஜநயித்வா தம்ʼ த்⁴ருʼத்வா ");
INSERT INTO santam_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ப்ரோச்சை​: ப்ராவோசந், ஹே இஸ்ராயேல்லோகா​: ஸர்வ்வே ஸாஹாய்யம்ʼ குருத| யோ மநுஜ ஏதேஷாம்ʼ லோகாநாம்ʼ மூஸாவ்யவஸ்தா²யா ஏதஸ்ய ஸ்தா²நஸ்யாபி விபரீதம்ʼ ஸர்வ்வத்ர ஸர்வ்வாந் ஸி²க்ஷயதி ஸ ஏஷ​:; விஸே²ஷத​: ஸ பி⁴ந்நதே³ஸீ²யலோகாந் மந்தி³ரம் ஆநீய பவித்ரஸ்தா²நமேதத்³ அபவித்ரமகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","பூர்வ்வம்ʼ தே மத்⁴யேநக³ரம் இபி²ஷநக³ரீயம்ʼ த்ரபி²மம்ʼ பௌலேந ஸஹிதம்ʼ த்³ருʼஷ்டவந்த ஏதஸ்மாத் பௌலஸ்தம்ʼ மந்தி³ரமத்⁴யம் ஆநயத்³ இத்யந்வமிமத| ");
INSERT INTO santam_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","அதஏவ ஸர்வ்வஸ்மிந் நக³ரே கலஹோத்பந்நத்வாத் தா⁴வந்தோ லோகா ஆக³த்ய பௌலம்ʼ த்⁴ருʼத்வா மந்தி³ரஸ்ய ப³ஹிராக்ருʼஷ்யாநயந் தத்க்ஷணாத்³ த்³வாராணி ஸர்வ்வாணி ச ருத்³தா⁴நி| ");
INSERT INTO santam_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","தேஷு தம்ʼ ஹந்துமுத்³யதேेஷு யிரூஸா²லம்நக³ரே மஹாநுபத்³ரவோ ஜாத இதி வார்த்தாயாம்ʼ ஸஹஸ்ரஸேநாபதே​: கர்ணகோ³சரீபூ⁴தாயாம்ʼ ஸத்யாம்ʼ ஸ தத்க்ஷணாத் ஸைந்யாநி ஸேநாபதிக³ணஞ்ச க்³ருʼஹீத்வா ஜவேநாக³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ததோ லோகா​: ஸேநாக³ணேந ஸஹ ஸஹஸ்ரஸேநாபதிம் ஆக³ச்ச²ந்தம்ʼ த்³ருʼஷ்ட்வா பௌலதாட³நாதோ ந்யவர்த்தந்த| ");
INSERT INTO santam_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ஸ ஸஹஸ்ரஸேநாபதி​: ஸந்நிதா⁴வாக³ம்ய பௌலம்ʼ த்⁴ருʼத்வா ஸ்²ருʼங்க²லத்³வயேந ப³த்³த⁴ம் ஆதி³ஸ்²ய தாந் ப்ருʼஷ்டவாந் ஏஷ க​:? கிம்ʼ கர்ம்ம சாயம்ʼ க்ருʼதவாந்? ");
INSERT INTO santam_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ததோ ஜநஸமூஹஸ்ய கஸ்²சித்³ ஏகப்ரகாரம்ʼ கஸ்²சித்³ அந்யப்ரகாரம்ʼ வாக்யம் அரௌத் ஸ தத்ர ஸத்யம்ʼ ஜ்ஞாதும் கலஹகாரணாத்³ அஸ²க்த​: ஸந் தம்ʼ து³ர்க³ம்ʼ நேதும் ஆஜ்ஞாபயத்| ");
INSERT INTO santam_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","தேஷு ஸோபாநஸ்யோபரி ப்ராப்தேஷு லோகாநாம்ʼ ஸாஹஸகாரணாத் ஸேநாக³ண​: பௌலமுத்தோல்ய நீதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","தத​: ஸர்வ்வே லோகா​: பஸ்²சாத்³கா³மிந​: ஸந்த ஏநம்ʼ து³ரீகுருதேதி வாக்யம் உச்சைரவத³ந்| ");
INSERT INTO santam_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","பௌலஸ்ய து³ர்கா³நயநஸமயே ஸ தஸ்மை ஸஹஸ்ரஸேநாபதயே கதி²தவாந், ப⁴வத​: புரஸ்தாத் கதா²ம்ʼ கத²யிதும்ʼ கிம் அநுமந்யதே? ஸ தமப்ருʼச்ச²த் த்வம்ʼ கிம்ʼ யூநாநீயாம்ʼ பா⁴ஷாம்ʼ ஜாநாஸி? ");
INSERT INTO santam_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","யோ மிஸரீயோ ஜந​: பூர்வ்வம்ʼ விரோத⁴ம்ʼ க்ருʼத்வா சத்வாரி ஸஹஸ்ராணி கா⁴தகாந் ஸங்கி³ந​: க்ருʼத்வா விபிநம்ʼ க³தவாந் த்வம்ʼ கிம்ʼ ஸஏவ ந ப⁴வஸி? ");
INSERT INTO santam_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ததா³ பௌலோ(அ)கத²யத் அஹம்ʼ கிலிகியாதே³ஸ²ஸ்ய தார்ஷநக³ரீயோ யிஹூதீ³யோ, நாஹம்ʼ ஸாமாந்யநக³ரீயோ மாநவ​:; அதஏவ விநயே(அ)ஹம்ʼ லாகாநாம்ʼ ஸமக்ஷம்ʼ கதா²ம்ʼ கத²யிதும்ʼ மாமநுஜாநீஷ்வ| ");
INSERT INTO santam_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","தேநாநுஜ்ஞாத​: பௌல​: ஸோபாநோபரி திஷ்ட²ந் ஹஸ்தேநேங்கி³தம்ʼ க்ருʼதவாந், தஸ்மாத் ஸர்வ்வே ஸுஸ்தி²ரா அப⁴வந்| ததா³ பௌல இப்³ரீயபா⁴ஷயா கத²யிதும் ஆரப⁴த, ");
INSERT INTO santam_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ஹே பித்ருʼக³ணா ஹே ப்⁴ராத்ருʼக³ணா​:, இதா³நீம்ʼ மம நிவேத³நே ஸமவத⁴த்த| ");
INSERT INTO santam_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ததா³ ஸ இப்³ரீயபா⁴ஷயா கதா²ம்ʼ கத²யதீதி ஸ்²ருத்வா ஸர்வ்வே லோகா அதீவ நி​:ஸ²ப்³தா³ ஸந்தோ(அ)திஷ்ட²ந்| ");
INSERT INTO santam_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","பஸ்²சாத் ஸோ(அ)கத²யத்³ அஹம்ʼ யிஹூதீ³ய இதி நிஸ்²சய​: கிலிகியாதே³ஸ²ஸ்ய தார்ஷநக³ரம்ʼ மம ஜந்மபூ⁴மி​:,ஏதந்நக³ரீயஸ்ய க³மிலீயேலநாம்நோ(அ)த்⁴யாபகஸ்ய ஸி²ஷ்யோ பூ⁴த்வா பூர்வ்வபுருஷாணாம்ʼ விதி⁴வ்யவஸ்தா²நுஸாரேண ஸம்பூர்ணரூபேண ஸி²க்ஷிதோ(அ)ப⁴வம் இதா³நீந்தநா யூயம்ʼ யாத்³ருʼஸா² ப⁴வத² தாத்³ருʼஸோ²(அ)ஹமபீஸ்²வரஸேவாயாம் உத்³யோகீ³ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","மதமேதத்³ த்³விஷ்ட்வா தத்³க்³ராஹிநாரீபுருஷாந் காராயாம்ʼ ப³த்³த்⁴வா தேஷாம்ʼ ப்ராணநாஸ²பர்ய்யந்தாம்ʼ விபக்ஷதாம் அகரவம்| ");
INSERT INTO santam_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","மஹாயாஜக​: ஸபா⁴ஸத³​: ப்ராசீநலோகாஸ்²ச மமைதஸ்யா​: கதா²யா​: ப்ரமாணம்ʼ தா³தும்ʼ ஸ²க்நுவந்தி, யஸ்மாத் தேஷாம்ʼ ஸமீபாத்³ த³ம்மேஷகநக³ரநிவாஸிப்⁴ராத்ருʼக³ணார்த²ம் ஆஜ்ஞாபத்ராணி க்³ருʼஹீத்வா யே தத்ர ஸ்தி²தாஸ்தாந் த³ண்ட³யிதும்ʼ யிரூஸா²லமம் ஆநயநார்த²ம்ʼ த³ம்மேஷகநக³ரம்ʼ க³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","கிந்து க³ச்ச²ந் தந்நக³ரஸ்ய ஸமீபம்ʼ ப்ராப்தவாந் ததா³ த்³விதீயப்ரஹரவேலாயாம்ʼ ஸத்யாம் அகஸ்மாத்³ க³க³ணாந்நிர்க³த்ய மஹதீ தீ³ப்தி ர்மம சதுர்தி³ஸி² ப்ரகாஸி²தவதீ| ");
INSERT INTO santam_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ததோ மயி பூ⁴மௌै பதிதே ஸதி, ஹே ஸௌ²ல ஹே ஸௌ²ல குதோ மாம்ʼ தாட³யஸி? மாம்ப்ரதி பா⁴ஷித ஏதாத்³ருʼஸ² ஏகோ ரவோபி மயா ஸ்²ருத​:| ");
INSERT INTO santam_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ததா³ஹம்ʼ ப்ரத்யவத³ம்ʼ, ஹே ப்ரபே⁴ கோ ப⁴வாந்? தத​: ஸோ(அ)வாதீ³த் யம்ʼ த்வம்ʼ தாட³யஸி ஸ நாஸரதீயோ யீஸு²ரஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","மம ஸங்கி³நோ லோகாஸ்தாம்ʼ தீ³ப்திம்ʼ த்³ருʼஷ்ட்வா பி⁴யம்ʼ ப்ராப்தா​:, கிந்து மாம்ப்ரத்யுதி³தம்ʼ தத்³வாக்யம்ʼ தேे நாபு³த்⁴யந்த| ");
INSERT INTO santam_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","தத​: பரம்ʼ ப்ருʼஷ்டவாநஹம்ʼ, ஹே ப்ரபோ⁴ மயா கிம்ʼ கர்த்தவ்யம்ʼ? தத​: ப்ரபு⁴ரகத²யத், உத்தா²ய த³ம்மேஷகநக³ரம்ʼ யாஹி த்வயா யத்³யத் கர்த்தவ்யம்ʼ நிரூபிதமாஸ்தே தத் தத்ர த்வம்ʼ ஜ்ஞாபயிஷ்யஸே| ");
INSERT INTO santam_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","அநந்தரம்ʼ தஸ்யா​: க²ரதரதீ³ப்தே​: காரணாத் கிமபி ந த்³ருʼஷ்ட்வா ஸங்கி³க³ணேந த்⁴ருʼதஹஸ்த​: ஸந் த³ம்மேஷகநக³ரம்ʼ வ்ரஜிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","தந்நக³ரநிவாஸிநாம்ʼ ஸர்வ்வேஷாம்ʼ யிஹூதீ³யாநாம்ʼ மாந்யோ வ்யவஸ்தா²நுஸாரேண ப⁴க்தஸ்²ச ஹநாநீயநாமா மாநவ ஏகோ ");
INSERT INTO santam_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","மம ஸந்நிதி⁴ம் ஏத்ய திஷ்ட²ந் அகத²யத், ஹே ப்⁴ராத​: ஸௌ²ல ஸுத்³ருʼஷ்டி ர்ப⁴வ தஸ்மிந் த³ண்டே³(அ)ஹம்ʼ ஸம்யக் தம்ʼ த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","தத​: ஸ மஹ்யம்ʼ கதி²தவாந் யதா² த்வம் ஈஸ்²வரஸ்யாபி⁴ப்ராயம்ʼ வேத்ஸி தஸ்ய ஸு²த்³த⁴ஸத்த்வஜநஸ்ய த³ர்ஸ²நம்ʼ ப்ராப்ய தஸ்ய ஸ்ரீமுக²ஸ்ய வாக்யம்ʼ ஸ்²ருʼணோஷி தந்நிமித்தம் அஸ்மாகம்ʼ பூர்வ்வபுருஷாணாம் ஈஸ்²வரஸ்த்வாம்ʼ மநோநீதம்ʼ க்ருʼதவாநம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","யதோ யத்³யத்³ அத்³ராக்ஷீரஸ்²ரௌஷீஸ்²ச ஸர்வ்வேஷாம்ʼ மாநவாநாம்ʼ ஸமீபே த்வம்ʼ தேஷாம்ʼ ஸாக்ஷீ ப⁴விஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","அதஏவ குதோ விலம்ப³ஸே? ப்ரபோ⁴ ர்நாம்நா ப்ரார்த்²ய நிஜபாபப்ரக்ஷாலநார்த²ம்ʼ மஜ்ஜநாய ஸமுத்திஷ்ட²| ");
INSERT INTO santam_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","தத​: பரம்ʼ யிரூஸா²லம்நக³ரம்ʼ ப்ரத்யாக³த்ய மந்தி³ரே(அ)ஹம் ஏகதா³ ப்ரார்த²யே, தஸ்மிந் ஸமயே(அ)ஹம் அபி⁴பூ⁴த​: ஸந் ப்ரபூ⁴ம்ʼ ஸாக்ஷாத் பஸ்²யந், ");
INSERT INTO santam_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","த்வம்ʼ த்வரயா யிரூஸா²லம​: ப்ரதிஷ்ட²ஸ்வ யதோ லோகாமயி தவ ஸாக்ஷ்யம்ʼ ந க்³ரஹீஷ்யந்தி, மாம்ப்ரத்யுதி³தம்ʼ தஸ்யேத³ம்ʼ வாக்யம் அஸ்²ரௌஷம்| ");
INSERT INTO santam_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ததோஹம்ʼ ப்ரத்யவாதி³ஷம் ஹே ப்ரபோ⁴ ப்ரதிப⁴ஜநப⁴வநம்ʼ த்வயி விஸ்²வாஸிநோ லோகாந் ப³த்³த்⁴வா ப்ரஹ்ருʼதவாந், ");
INSERT INTO santam_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ததா² தவ ஸாக்ஷிண​: ஸ்திபா²நஸ்ய ரக்தபாதநஸமயே தஸ்ய விநாஸ²ம்ʼ ஸம்மந்ய ஸந்நிதௌ⁴ திஷ்ட²ந் ஹந்த்ருʼலோகாநாம்ʼ வாஸாம்ʼஸி ரக்ஷிதவாந், ஏதத் தே விது³​:| ");
INSERT INTO santam_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","தத​: ஸோ(அ)கத²யத் ப்ரதிஷ்ட²ஸ்வ த்வாம்ʼ தூ³ரஸ்த²பி⁴ந்நதே³ஸீ²யாநாம்ʼ ஸமீபம்ʼ ப்ரேஷயிஷ்யே| ");
INSERT INTO santam_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ததா³ லோகா ஏதாவத்பர்ய்யந்தாம்ʼ ததீ³யாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா ப்ரோச்சைரகத²யந், ஏநம்ʼ பூ⁴மண்ட³லாத்³ தூ³ரீகுருத, ஏதாத்³ருʼஸ²ஜநஸ்ய ஜீவநம்ʼ நோசிதம்| ");
INSERT INTO santam_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","இத்யுச்சை​: கத²யித்வா வஸநாநி பரித்யஜ்ய க³க³ணம்ʼ ப்ரதி தூ⁴லீரக்ஷிபந் ");
INSERT INTO santam_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","தத​: ஸஹஸ்ரஸேநாபதி​: பௌலம்ʼ து³ர்கா³ப்⁴யந்தர நேதும்ʼ ஸமாதி³ஸ²த்| ஏதஸ்ய ப்ரதிகூலா​: ஸந்தோ லோகா​: கிந்நிமித்தம் ஏதாவது³ச்சை​:ஸ்வரம் அகுர்வ்வந், ஏதத்³ வேத்தும்ʼ தம்ʼ கஸ²யா ப்ரஹ்ருʼத்ய தஸ்ய பரீக்ஷாம்ʼ கர்த்துமாதி³ஸ²த்| ");
INSERT INTO santam_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","பதா³தயஸ்²சர்ம்மநிர்ம்மிதரஜ்ஜுபி⁴ஸ்தஸ்ய ப³ந்த⁴நம்ʼ கர்த்துமுத்³யதாஸ்தாஸ்ததா³நீம்ʼ பௌல​: ஸம்முக²ஸ்தி²தம்ʼ ஸ²தஸேநாபதிம் உக்தவாந் த³ண்டா³ஜ்ஞாயாம் அப்ராப்தாயாம்ʼ கிம்ʼ ரோமிலோகம்ʼ ப்ரஹர்த்தும்ʼ யுஷ்மாகம் அதி⁴காரோஸ்தி? ");
INSERT INTO santam_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ஏநாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா ஸ ஸஹஸ்ரஸேநாபதே​: ஸந்நிதி⁴ம்ʼ க³த்வா தாம்ʼ வார்த்தாமவத³த் ஸ ரோமிலோக ஏதஸ்மாத் ஸாவதா⁴ந​: ஸந் கர்ம்ம குரு| ");
INSERT INTO santam_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","தஸ்மாத் ஸஹஸ்ரஸேநாபதி ர்க³த்வா தமப்ராக்ஷீத் த்வம்ʼ கிம்ʼ ரோமிலோக​:? இதி மாம்ʼ ப்³ரூஹி| ஸோ(அ)கத²யத் ஸத்யம்| ");
INSERT INTO santam_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","தத​: ஸஹஸ்ரஸேநாபதி​: கதி²தவாந் ப³ஹுத்³ரவிணம்ʼ த³த்த்வாஹம்ʼ தத் பௌரஸக்²யம்ʼ ப்ராப்தவாந்; கிந்து பௌல​: கதி²தவாந் அஹம்ʼ ஜநுநா தத் ப்ராப்தோ(அ)ஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","இத்த²ம்ʼ ஸதி யே ப்ரஹாரேண தம்ʼ பரீக்ஷிதும்ʼ ஸமுத்³யதா ஆஸந் தே தஸ்ய ஸமீபாத் ப்ராதிஷ்ட²ந்த; ஸஹஸ்ரஸேநாபதிஸ்தம்ʼ ரோமிலோகம்ʼ விஜ்ஞாய ஸ்வயம்ʼ யத் தஸ்ய ப³ந்த⁴நம் அகார்ஷீத் தத்காரணாத்³ அபி³பே⁴த்| ");
INSERT INTO santam_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","யிஹூதீ³யலோகா​: பௌலம்ʼ குதோ(அ)பவத³ந்தே தஸ்ய வ்ருʼத்தாந்தம்ʼ ஜ்ஞாதும்ʼ வாஞ்ச²ந் ஸஹஸ்ரஸேநாபதி​: பரே(அ)ஹநி பௌலம்ʼ ப³ந்த⁴நாத் மோசயித்வா ப்ரதா⁴நயாஜகாந் மஹாஸபா⁴யா​: ஸர்வ்வலோகாஸ்²ச ஸமுபஸ்தா²தும் ஆதி³ஸ்²ய தேஷாம்ʼ ஸந்நிதௌ⁴ பௌலம் அவரோஹ்ய ஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ஸபா⁴ஸத்³லோகாந் ப்ரதி பௌலோ(அ)நந்யத்³ருʼஷ்ட்யா பஸ்²யந் அகத²யத், ஹே ப்⁴ராத்ருʼக³ணா அத்³ய யாவத் ஸரலேந ஸர்வ்வாந்த​:கரணேநேஸ்²வரஸ்ய ஸாக்ஷாத்³ ஆசராமி| ");
INSERT INTO santam_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","அநேந ஹநாநீயநாமா மஹாயாஜகஸ்தம்ʼ கபோலே சபேடேநாஹந்தும்ʼ ஸமீபஸ்த²லோகாந் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ததா³ பௌலஸ்தமவத³த், ஹே ப³ஹிஷ்பரிஷ்க்ருʼத, ஈஸ்²வரஸ்த்வாம்ʼ ப்ரஹர்த்தும் உத்³யதோஸ்தி, யதோ வ்யவஸ்தா²நுஸாரேண விசாரயிதும் உபவிஸ்²ய வ்யவஸ்தா²ம்ʼ லங்கி⁴த்வா மாம்ʼ ப்ரஹர்த்தும் ஆஜ்ஞாபயஸி| ");
INSERT INTO santam_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ததோ நிகடஸ்தா² லோகா அகத²யந், த்வம்ʼ கிம் ஈஸ்²வரஸ்ய மஹாயாஜகம்ʼ நிந்த³ஸி? ");
INSERT INTO santam_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","தத​: பௌல​: ப்ரதிபா⁴ஷிதவாந் ஹே ப்⁴ராத்ருʼக³ண மஹாயாஜக ஏஷ இதி ந பு³த்³த⁴ம்ʼ மயா தத³ந்யச்ச ஸ்வலோகாநாம் அதி⁴பதிம்ʼ ப்ரதி து³ர்வ்வாக்யம்ʼ மா கத²ய, ஏதாத்³ருʼஸீ² லிபிரஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","அநந்தரம்ʼ பௌலஸ்தேஷாம் அர்த்³த⁴ம்ʼ ஸிதூ³கிலோகா அர்த்³த⁴ம்ʼ பி²ரூஸி²லோகா இதி த்³ருʼஷ்ட்வா ப்ரோச்சை​: ஸபா⁴ஸ்த²லோகாந் அவத³த் ஹே ப்⁴ராத்ருʼக³ண அஹம்ʼ பி²ரூஸி²மதாவலம்பீ³ பி²ரூஸி²ந​: ஸத்நாநஸ்²ச, ம்ருʼதலோகாநாம் உத்தா²நே ப்ரத்யாஸா²கரணாத்³ அஹமபவாதி³தோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","இதி கதா²யாம்ʼ கதி²தாயாம்ʼ பி²ரூஸி²ஸிதூ³கிநோ​: பரஸ்பரம்ʼ பி⁴ந்நவாக்யத்வாத் ஸபா⁴யா மத்⁴யே த்³வௌ ஸம்ʼகௌ⁴ ஜாதௌ| ");
INSERT INTO santam_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","யத​: ஸிதூ³கிலோகா உத்தா²நம்ʼ ஸ்வர்கீ³யதூ³தா ஆத்மாநஸ்²ச ஸர்வ்வேஷாம் ஏதேஷாம்ʼ கமபி ந மந்யந்தே, கிந்து பி²ரூஸி²ந​: ஸர்வ்வம் அங்கீ³குர்வ்வந்தி| ");
INSERT INTO santam_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","தத​: பரஸ்பரம் அதிஸ²யகோலாஹலே ஸமுபஸ்தி²தே பி²ரூஸி²நாம்ʼ பக்ஷீயா​: ஸபா⁴ஸ்தா² அத்⁴யாபகா​: ப்ரதிபக்ஷா உத்திஷ்ட²ந்தோ (அ)கத²யந், ஏதஸ்ய மாநவஸ்ய கமபி தோ³ஷம்ʼ ந பஸ்²யாம​:; யதி³ கஸ்²சித்³ ஆத்மா வா கஸ்²சித்³ தூ³த ஏநம்ʼ ப்ரத்யாதி³ஸ²த் தர்ஹி வயம் ஈஸ்²வரஸ்ய ப்ராதிகூல்யேந ந யோத்ஸ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","தஸ்மாத்³ அதீவ பி⁴ந்நவாக்யத்வே ஸதி தே பௌலம்ʼ க²ண்ட³ம்ʼ க²ண்ட³ம்ʼ கரிஷ்யந்தீத்யாஸ²ங்கயா ஸஹஸ்ரஸேநாபதி​: ஸேநாக³ணம்ʼ தத்ஸ்தா²நம்ʼ யாதும்ʼ ஸபா⁴தோ ப³லாத் பௌலம்ʼ த்⁴ருʼத்வா து³ர்க³ம்ʼ நேதஞ்சாஜ்ஞாபயத்| ");
INSERT INTO santam_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ராத்ரோ ப்ரபு⁴ஸ்தஸ்ய ஸமீபே திஷ்ட²ந் கதி²தவாந் ஹே பௌல நிர்ப⁴யோ ப⁴வ யதா² யிரூஸா²லம்நக³ரே மயி ஸாக்ஷ்யம்ʼ த³த்தவாந் ததா² ரோமாநக³ரேபி த்வயா தா³தவ்யம்| ");
INSERT INTO santam_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","தி³நே ஸமுபஸ்தி²தே ஸதி கியந்தோ யிஹூதீ³யலோகா ஏகமந்த்ரணா​: ஸந்த​: பௌலம்ʼ ந ஹத்வா போ⁴ஜநபாநே கரிஷ்யாம இதி ஸ²பதே²ந ஸ்வாந் அப³த்⁴நந்| ");
INSERT INTO santam_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","சத்வாரிம்ʼஸ²ஜ்ஜநேப்⁴யோ(அ)தி⁴கா லோகா இதி பணம் அகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","தே மஹாயாஜகாநாம்ʼ ப்ராசீநலோகாநாஞ்ச ஸமீபம்ʼ க³த்வா கத²யந், வயம்ʼ பௌலம்ʼ ந ஹத்வா கிமபி ந போ⁴க்ஷ்யாமஹே த்³ருʼடே⁴நாநேந ஸ²பதே²ந ப³த்³த்⁴வா அப⁴வாம| ");
INSERT INTO santam_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","அதஏவ ஸாம்ப்ரதம்ʼ ஸபா⁴ஸத்³லோகை​: ஸஹ வயம்ʼ தஸ்மிந் கஞ்சித்³ விஸே²ஷவிசாரம்ʼ கரிஷ்யாமஸ்தத³ர்த²ம்ʼ ப⁴வாந் ஸ்²வோ (அ)ஸ்மாகம்ʼ ஸமீபம்ʼ தம் ஆநயத்விதி ஸஹஸ்ரஸேநாபதயே நிவேத³நம்ʼ குருத தேந யுஷ்மாகம்ʼ ஸமீபம்ʼ உபஸ்தி²தே​: பூர்வ்வம்ʼ வயம்ʼ தம்ʼ ஹந்து ஸஜ்ஜிஷ்யாம| ");
INSERT INTO santam_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ததா³ பௌலஸ்ய பா⁴கி³நேயஸ்தேஷாமிதி மந்த்ரணாம்ʼ விஜ்ஞாய து³ர்க³ம்ʼ க³த்வா தாம்ʼ வார்த்தாம்ʼ பௌலம் உக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","தஸ்மாத் பௌல ஏகம்ʼ ஸ²தஸேநாபதிம் ஆஹூய வாக்யமித³ம் பா⁴ஷிதவாந் ஸஹஸ்ரஸேநாபதே​: ஸமீபே(அ)ஸ்ய யுவமநுஷ்யஸ்ய கிஞ்சிந்நிவேத³நம் ஆஸ்தே, தஸ்மாத் தத்ஸவித⁴ம் ஏநம்ʼ நய| ");
INSERT INTO santam_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","தத​: ஸ தமாதா³ய ஸஹஸ்ரஸேநாபதே​: ஸமீபம் உபஸ்தா²ய கதி²தவாந், ப⁴வத​: ஸமீபே(அ)ஸ்ய கிமபி நிவேத³நமாஸ்தே தஸ்மாத் ப³ந்தி³​: பௌலோ மாமாஹூய ப⁴வத​: ஸமீபம் ஏநம் ஆநேதும்ʼ ப்ரார்தி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ததா³ ஸஹஸ்ரஸேநாபதிஸ்தஸ்ய ஹஸ்தம்ʼ த்⁴ருʼத்வா நிர்ஜநஸ்தா²நம்ʼ நீத்வா ப்ருʼஷ்ட²வாந் தவ கிம்ʼ நிவேத³நம்ʼ? தத் கத²ய| ");
INSERT INTO santam_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","தத​: ஸோகத²யத், யிஹூதீ³யலாகா​: பௌலே கமபி விஸே²ஷவிசாரம்ʼ ச²லம்ʼ க்ருʼத்வா தம்ʼ ஸபா⁴ம்ʼ நேதும்ʼ ப⁴வத​: ஸமீபே நிவேத³யிதும்ʼ அமந்த்ரயந்| ");
INSERT INTO santam_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","கிந்து மவதா தந்ந ஸ்வீகர்த்தவ்யம்ʼ யதஸ்தேஷாம்ʼ மத்⁴யேவர்த்திநஸ்²சத்வாரிம்ʼஸ²ஜ்ஜநேப்⁴யோ (அ)தி⁴கலோகா ஏகமந்த்ரணா பூ⁴த்வா பௌலம்ʼ ந ஹத்வா போ⁴ஜநம்ʼ பாநஞ்ச ந கரிஷ்யாம இதி ஸ²பதே²ந ப³த்³தா⁴​: ஸந்தோ கா⁴தகா இவ ஸஜ்ஜிதா இதா³நீம்ʼ கேவலம்ʼ ப⁴வதோ (அ)நுமதிம் அபேக்ஷந்தே| ");
INSERT INTO santam_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","யாமிமாம்ʼ கதா²ம்ʼ த்வம்ʼ நிவேதி³தவாந் தாம்ʼ கஸ்மைசித³பி மா கத²யேத்யுக்த்வா ஸஹஸ்ரஸேநாபதிஸ்தம்ʼ யுவாநம்ʼ விஸ்ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","அநந்தரம்ʼ ஸஹஸ்ரஸேநாபதி ர்த்³வௌ ஸ²தஸேநாபதீ ஆஹூயேத³ம் ஆதி³ஸ²த், யுவாம்ʼ ராத்ரௌ ப்ரஹரைகாவஸி²ஷ்டாயாம்ʼ ஸத்யாம்ʼ கைஸரியாநக³ரம்ʼ யாதும்ʼ பதா³திஸைந்யாநாம்ʼ த்³வே ஸ²தே கோ⁴டகாரோஹிஸைந்யாநாம்ʼ ஸப்ததிம்ʼ ஸ²க்திதா⁴ரிஸைந்யாநாம்ʼ த்³வே ஸ²தே ச ஜநாந் ஸஜ்ஜிதாந் குருதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","பௌலம் ஆரோஹயிதும்ʼ பீ²லிக்ஷாதி⁴பதே​: ஸமீபம்ʼ நிர்வ்விக்⁴நம்ʼ நேதுஞ்ச வாஹநாநி ஸமுபஸ்தா²பயதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","அபரம்ʼ ஸ பத்ரம்ʼ லிகி²த்வா த³த்தவாந் தல்லிகி²தமேதத், ");
INSERT INTO santam_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","மஹாமஹிமஸ்ரீயுக்தபீ²லிக்ஷாதி⁴பதயே க்லௌதி³யலுஷியஸ்ய நமஸ்கார​:| ");
INSERT INTO santam_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","யிஹூதீ³யலோகா​: பூர்வ்வம் ஏநம்ʼ மாநவம்ʼ த்⁴ருʼத்வா ஸ்வஹஸ்தை ர்ஹந்தும் உத்³யதா ஏதஸ்மிந்நந்தரே ஸஸைந்யோஹம்ʼ தத்ரோபஸ்தா²ய ஏஷ ஜநோ ரோமீய இதி விஜ்ஞாய தம்ʼ ரக்ஷிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","கிந்நிமித்தம்ʼ தே தமபவத³ந்தே தஜ்ஜ்ஞாதும்ʼ தேஷா ஸபா⁴ம்ʼ தமாநாயிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ததஸ்தேஷாம்ʼ வ்யவஸ்தா²யா விருத்³த⁴யா கயாசந கத²யா ஸோ(அ)பவாதி³தோ(அ)ப⁴வத், கிந்து ஸ ஸ்²ருʼங்க²லப³ந்த⁴நார்ஹோ வா ப்ராணநாஸா²ர்ஹோ ப⁴வதீத்³ருʼஸ²​: கோப்யபராதோ⁴ மயாஸ்ய ந த்³ருʼஷ்ட​:| ");
INSERT INTO santam_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ததா²பி மநுஷ்யஸ்யாஸ்ய வதா⁴ர்த²ம்ʼ யிஹூதீ³யா கா⁴தகாஇவ ஸஜ்ஜிதா ஏதாம்ʼ வார்த்தாம்ʼ ஸ்²ருத்வா தத்க்ஷணாத் தவ ஸமீபமேநம்ʼ ப்ரேஷிதவாந் அஸ்யாபவாத³காம்ʼஸ்²ச தவ ஸமீபம்ʼ க³த்வாபவதி³தும் ஆஜ்ஞாபயம்| ப⁴வத​: குஸ²லம்ʼ பூ⁴யாத்| ");
INSERT INTO santam_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ஸைந்யக³ண ஆஜ்ஞாநுஸாரேண பௌலம்ʼ க்³ருʼஹீத்வா தஸ்யாம்ʼ ரஜந்யாம் ஆந்திபாத்ரிநக³ரம் ஆநயத்| ");
INSERT INTO santam_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","பரே(அ)ஹநி தேந ஸஹ யாதும்ʼ கோ⁴டகாரூட⁴ஸைந்யக³ணம்ʼ ஸ்தா²பயித்வா பராவ்ருʼத்ய து³ர்க³ம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","தத​: பரே கோ⁴டகாரோஹிஸைந்யக³ண​: கைஸரியாநக³ரம் உபஸ்தா²ய தத்பத்ரம் அதி⁴பதே​: கரே ஸமர்ப்ய தஸ்ய ஸமீபே பௌலம் உபஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ததா³தி⁴பதிஸ்தத்பத்ரம்ʼ படி²த்வா ப்ருʼஷ்ட²வாந் ஏஷ கிம்ப்ரதே³ஸீ²யோ ஜந​:? ஸ கிலிகியாப்ரதே³ஸீ²ய ஏகோ ஜந இதி ஜ்ஞாத்வா கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","தவாபவாத³கக³ண ஆக³தே தவ கதா²ம்ʼ ஸ்²ரோஷ்யாமி| ஹேரோத்³ராஜக்³ருʼஹே தம்ʼ ஸ்தா²பயிதும் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","பஞ்சப்⁴யோ தி³நேப்⁴ய​: பரம்ʼ ஹநாநீயநாமா மஹாயாஜகோ(அ)தி⁴பதே​: ஸமக்ஷம்ʼ பௌலஸ்ய ப்ராதிகூல்யேந நிவேத³யிதும்ʼ தர்துல்லநாமாநம்ʼ கஞ்சந வக்தாரம்ʼ ப்ராசீநஜநாம்ʼஸ்²ச ஸங்கி³ந​: க்ருʼத்வா கைஸரியாநக³ரம் ஆக³ச்ச²த்| ");
INSERT INTO santam_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","தத​: பௌலே ஸமாநீதே ஸதி தர்துல்லஸ்தஸ்யாபவாத³கதா²ம்ʼ கத²யிதும் ஆரப⁴த ஹே மஹாமஹிமபீ²லிக்ஷ ப⁴வதோ வயம் அதிநிர்வ்விக்⁴நம்ʼ காலம்ʼ யாபயாமோ ப⁴வத​: பரிணாமத³ர்ஸி²தயா ஏதத்³தே³ஸீ²யாநாம்ʼ ப³ஹூநி மங்க³லாநி க⁴டிதாநி, ");
INSERT INTO santam_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","இதி ஹேதோ ர்வயமதிக்ருʼதஜ்ஞா​: ஸந்த​: ஸர்வ்வத்ர ஸர்வ்வதா³ ப⁴வதோ கு³ணாந் கா³யம​:| ");
INSERT INTO santam_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","கிந்து ப³ஹுபி⁴​: கதா²பி⁴ ர்ப⁴வந்தம்ʼ யேந ந விரஞ்ஜயாமி தஸ்மாத்³ விநயே ப⁴வாந் ப³நுகம்ப்ய மத³ல்பகதா²ம்ʼ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ஏஷ மஹாமாரீஸ்வரூபோ நாஸரதீயமதக்³ராஹிஸம்ʼகா⁴தஸ்ய முக்²யோ பூ⁴த்வா ஸர்வ்வதே³ஸே²ஷு ஸர்வ்வேஷாம்ʼ யிஹூதீ³யாநாம்ʼ ராஜத்³ரோஹாசரணப்ரவ்ருʼத்திம்ʼ ஜநயதீத்யஸ்மாபி⁴ ர்நிஸ்²சிதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ஸ மந்தி³ரமபி அஸு²சி கர்த்தும்ʼ சேஷ்டிதவாந்; இதி காரணாத்³ வயம் ஏநம்ʼ த்⁴ருʼத்வா ஸ்வவ்யவஸ்தா²நுஸாரேண விசாரயிதும்ʼ ப்ராவர்த்தாமஹி; ");
INSERT INTO santam_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","கிந்து லுஷிய​: ஸஹஸ்ரஸேநாபதிராக³த்ய ப³லாத்³ அஸ்மாகம்ʼ கரேப்⁴ய ஏநம்ʼ க்³ருʼஹீத்வா ");
INSERT INTO santam_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ஏதஸ்யாபவாத³காந் ப⁴வத​: ஸமீபம் ஆக³ந்தும் ஆஜ்ஞாபயத்| வயம்ʼ யஸ்மிந் தமபவாதா³மோ ப⁴வதா பத³பவாத³கதா²யாம்ʼ விசாரிதாயாம்ʼ ஸத்யாம்ʼ ஸர்வ்வம்ʼ வ்ருʼத்தாந்தம்ʼ வேதி³தும்ʼ ஸ²க்ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ததோ யிஹூதீ³யா அபி ஸ்வீக்ருʼத்ய கதி²தவந்த ஏஷா கதா² ப்ரமாணம்| ");
INSERT INTO santam_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","அதி⁴பதௌ கதா²ம்ʼ கத²யிதும்ʼ பௌலம்ʼ ப்ரதீங்கி³தம்ʼ க்ருʼதவதி ஸ கதி²தவாந் ப⁴வாந் ப³ஹூந் வத்ஸராந் யாவத்³ ஏதத்³தே³ஸ²ஸ்ய ஸா²ஸநம்ʼ கரோதீதி விஜ்ஞாய ப்ரத்யுத்தரம்ʼ தா³தும் அக்ஷோபோ⁴(அ)ப⁴வம்| ");
INSERT INTO santam_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","அத்³ய கேவலம்ʼ த்³வாத³ஸ² தி³நாநி யாதாநி, அஹம் ஆராத⁴நாம்ʼ கர்த்தும்ʼ யிரூஸா²லமநக³ரம்ʼ க³தவாந் ஏஷா கதா² ப⁴வதா ஜ்ஞாதும்ʼ ஸ²க்யதே; ");
INSERT INTO santam_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","கிந்த்விபே⁴ மாம்ʼ மத்⁴யேமந்தி³ரம்ʼ கேநாபி ஸஹ விதண்டா³ம்ʼ குர்வ்வந்தம்ʼ குத்ராபி ப⁴ஜநப⁴வநே நக³ரே வா லோகாந் குப்ரவ்ருʼத்திம்ʼ ஜநயந்தும்ʼ ந த்³ருʼஷ்டவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","இதா³நீம்ʼ யஸ்மிந் யஸ்மிந் மாம் அபவத³ந்தே தஸ்ய கிமபி ப்ரமாணம்ʼ தா³தும்ʼ ந ஸ²க்நுவந்தி| ");
INSERT INTO santam_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","கிந்து ப⁴விஷ்யத்³வாக்யக்³ரந்தே² வ்யவஸ்தா²க்³ரந்தே² ச யா யா கதா² லிகி²தாஸ்தே தாஸு ஸர்வ்வாஸு விஸ்²வஸ்ய யந்மதம் இமே வித⁴ர்ம்மம்ʼ ஜாநந்தி தந்மதாநுஸாரேணாஹம்ʼ நிஜபித்ருʼபுருஷாணாம் ஈஸ்²வரம் ஆராத⁴யாமீத்யஹம்ʼ ப⁴வத​: ஸமக்ஷம் அங்கீ³கரோமி| ");
INSERT INTO santam_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","தா⁴ர்ம்மிகாணாம் அதா⁴ர்ம்மிகாணாஞ்ச ப்ரமீதலோகாநாமேவோத்தா²நம்ʼ ப⁴விஷ்யதீதி கதா²மிமே ஸ்வீகுர்வ்வந்தி ததா²ஹமபி தஸ்மிந் ஈஸ்²வரே ப்ரத்யாஸா²ம்ʼ கரோமி; ");
INSERT INTO santam_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ஈஸ்²வரஸ்ய மாநவாநாஞ்ச ஸமீபே யதா² நிர்தோ³ஷோ ப⁴வாமி தத³ர்த²ம்ʼ ஸததம்ʼ யத்நவாந் அஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ப³ஹுஷு வத்ஸரேஷு க³தேஷு ஸ்வதே³ஸீ²யலோகாநாம்ʼ நிமித்தம்ʼ தா³நீயத்³ரவ்யாணி நைவேத்³யாநி ச ஸமாதா³ய புநராக³மநம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ததோஹம்ʼ ஸு²சி ர்பூ⁴த்வா லோகாநாம்ʼ ஸமாக³மம்ʼ கலஹம்ʼ வா ந காரிதவாந் ததா²ப்யாஸி²யாதே³ஸீ²யா​: கியந்தோ யிஹுதீ³யலோகா மத்⁴யேமந்தி³ரம்ʼ மாம்ʼ த்⁴ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","மமோபரி யதி³ காசித³பவாத³கதா²ஸ்தி தர்ஹி ப⁴வத​: ஸமீபம் உபஸ்தா²ய தேஷாமேவ ஸாக்ஷ்யதா³நம் உசிதம்| ");
INSERT INTO santam_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","நோசேத் பூர்வ்வே மஹாஸபா⁴ஸ்தா²நாம்ʼ லோகாநாம்ʼ ஸந்நிதௌ⁴ மம த³ண்டா³யமாநத்வஸமயே, அஹமத்³ய ம்ருʼதாநாமுத்தா²நே யுஷ்மாபி⁴ ர்விசாரிதோஸ்மி, ");
INSERT INTO santam_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","தேஷாம்ʼ மத்⁴யே திஷ்ட²ந்நஹம்ʼ யாமிமாம்ʼ கதா²முச்சை​: ஸ்வரேண கதி²தவாந் தத³ந்யோ மம கோபி தோ³ஷோ(அ)லப்⁴யத ந வேதி வரம் ஏதே ஸமுபஸ்தி²தலோகா வத³ந்து| ");
INSERT INTO santam_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ததா³ பீ²லிக்ஷ ஏதாம்ʼ கதா²ம்ʼ ஸ்²ருத்வா தந்மதஸ்ய விஸே²ஷவ்ருʼத்தாந்தம்ʼ விஜ்ஞாதும்ʼ விசாரம்ʼ ஸ்த²கி³தம்ʼ க்ருʼத்வா கதி²தவாந் லுஷியே ஸஹஸ்ரஸேநாபதௌ ஸமாயாதே ஸதி யுஷ்மாகம்ʼ விசாரம் அஹம்ʼ நிஷ்பாத³யிஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","அநந்தரம்ʼ ப³ந்த⁴நம்ʼ விநா பௌலம்ʼ ரக்ஷிதும்ʼ தஸ்ய ஸேவநாய ஸாக்ஷாத்கரணாய வா ததீ³யாத்மீயப³ந்து⁴ஜநாந் ந வாரயிதுஞ்ச ஸ²மஸேநாபதிம் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","அல்பதி³நாத் பரம்ʼ பீ²லிக்ஷோ(அ)தி⁴பதி ர்த்³ருஷில்லாநாம்நா யிஹூதீ³யயா ஸ்வபா⁴ர்ய்யயா ஸஹாக³த்ய பௌலமாஹூய தஸ்ய முகா²த் க்²ரீஷ்டத⁴ர்ம்மஸ்ய வ்ருʼத்தாந்தம் அஸ்²ரௌஷீத்| ");
INSERT INTO santam_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","பௌலேந ந்யாயஸ்ய பரிமிதபோ⁴க³ஸ்ய சரமவிசாரஸ்ய ச கதா²யாம்ʼ கதி²தாயாம்ʼ ஸத்யாம்ʼ பீ²லிக்ஷ​: கம்பமாந​: ஸந் வ்யாஹரத்³ இதா³நீம்ʼ யாஹி, அஹம் அவகாஸ²ம்ʼ ப்ராப்ய த்வாம் ஆஹூஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","முக்திப்ரப்த்யர்த²ம்ʼ பௌலேந மஹ்யம்ʼ முத்³ராதா³ஸ்யந்தே இதி பத்யாஸா²ம்ʼ க்ருʼத்வா ஸ புந​: புநஸ்தமாஹூய தேந ஸாகம்ʼ கதோ²பகத²நம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","கிந்து வத்ஸரத்³வயாத் பரம்ʼ பர்கியபீ²ஷ்ட பா²லிக்ஷஸ்ய பத³ம்ʼ ப்ராப்தே ஸதி பீ²லிக்ஷோ யிஹூதீ³யாந் ஸந்துஷ்டாந் சிகீர்ஷந் பௌலம்ʼ ப³த்³த⁴ம்ʼ ஸம்ʼஸ்தா²ப்ய க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","அநந்தரம்ʼ பீ²ஷ்டோ நிஜராஜ்யம் ஆக³த்ய தி³நத்ரயாத் பரம்ʼ கைஸரியாதோ யிரூஸா²லம்நக³ரம் ஆக³மத்| ");
INSERT INTO santam_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ததா³ மஹாயாஜகோ யிஹூதீ³யாநாம்ʼ ப்ரதா⁴நலோகாஸ்²ச தஸ்ய ஸமக்ஷம்ʼ பௌலம் அபாவத³ந்த| ");
INSERT INTO santam_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ப⁴வாந் தம்ʼ யிரூஸா²லமம் ஆநேதும் ஆஜ்ஞாபயத்விதி விநீய தே தஸ்மாத்³ அநுக்³ரஹம்ʼ வாஞ்சி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","யத​: பதி²மத்⁴யே கோ³பநேந பௌலம்ʼ ஹந்தும்ʼ தை ர்கா⁴தகா நியுக்தா​:| பீ²ஷ்ட உத்தரம்ʼ த³த்தவாந் பௌல​: கைஸரியாயாம்ʼ ஸ்தா²ஸ்யதி புநரல்பதி³நாத் பரம் அஹம்ʼ தத்ர யாஸ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ததஸ்தஸ்ய மாநுஷஸ்ய யதி³ கஸ்²சித்³ அபராத⁴ஸ்திஷ்ட²தி தர்ஹி யுஷ்மாகம்ʼ யே ஸ²க்நுவந்தி தே மயா ஸஹ தத்ர க³த்வா தமபவத³ந்து ஸ ஏதாம்ʼ கதா²ம்ʼ கதி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","த³ஸ²தி³வஸேப்⁴யோ(அ)தி⁴கம்ʼ விலம்ப்³ய பீ²ஷ்டஸ்தஸ்மாத் கைஸரியாநக³ரம்ʼ க³த்வா பரஸ்மிந் தி³வஸே விசாராஸந உபதி³ஸ்²ய பௌலம் ஆநேதும் ஆஜ்ஞாபயத்| ");
INSERT INTO santam_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","பௌலே ஸமுபஸ்தி²தே ஸதி யிரூஸா²லம்நக³ராத்³ ஆக³தா யிஹூதீ³யலோகாஸ்தம்ʼ சதுர்தி³ஸி² ஸம்ʼவேஷ்ட்ய தஸ்ய விருத்³த⁴ம்ʼ ப³ஹூந் மஹாதோ³ஷாந் உத்தா²பிதவந்த​: கிந்து தேஷாம்ʼ கிமபி ப்ரமாணம்ʼ தா³தும்ʼ ந ஸ²க்நுவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","தத​: பௌல​: ஸ்வஸ்மிந் உத்தரமித³ம் உதி³தவாந், யிஹூதீ³யாநாம்ʼ வ்யவஸ்தா²யா மந்தி³ரஸ்ய கைஸரஸ்ய வா ப்ரதிகூலம்ʼ கிமபி கர்ம்ம நாஹம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","கிந்து பீ²ஷ்டோ யிஹூதீ³யாந் ஸந்துஷ்டாந் கர்த்தும் அபி⁴லஷந் பௌலம் அபா⁴ஷத த்வம்ʼ கிம்ʼ யிரூஸா²லமம்ʼ க³த்வாஸ்மிந் அபி⁴யோகே³ மம ஸாக்ஷாத்³ விசாரிதோ ப⁴விஷ்யஸி? ");
INSERT INTO santam_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","தத​: பௌல உத்தரம்ʼ ப்ரோக்தவாந், யத்ர மம விசாரோ ப⁴விதும்ʼ யோக்³ய​: கைஸரஸ்ய தத்ர விசாராஸந ஏவ ஸமுபஸ்தி²தோஸ்மி; அஹம்ʼ யிஹூதீ³யாநாம்ʼ காமபி ஹாநிம்ʼ நாகார்ஷம் இதி ப⁴வாந் யதா²ர்த²தோ விஜாநாதி| ");
INSERT INTO santam_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","கஞ்சித³பராத⁴ம்ʼ கிஞ்சந வதா⁴ர்ஹம்ʼ கர்ம்ம வா யத்³யஹம் அகரிஷ்யம்ʼ தர்ஹி ப்ராணஹநநத³ண்ட³மபி போ⁴க்தும் உத்³யதோ(அ)ப⁴விஷ்யம்ʼ, கிந்து தே மம ஸமபவாத³ம்ʼ குர்வ்வந்தி ஸ யதி³ கல்பிதமாத்ரோ ப⁴வதி தர்ஹி தேஷாம்ʼ கரேஷு மாம்ʼ ஸமர்பயிதும்ʼ கஸ்யாப்யதி⁴காரோ நாஸ்தி, கைஸரஸ்ய நிகடே மம விசாரோ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ததா³ பீ²ஷ்டோ மந்த்ரிபி⁴​: ஸார்த்³த⁴ம்ʼ ஸம்ʼமந்த்ர்ய பௌலாய கதி²தவாந், கைஸரஸ்ய நிகடே கிம்ʼ தவ விசாரோ ப⁴விஷ்யதி? கைஸரஸ்ய ஸமீபம்ʼ க³மிஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","கியத்³தி³நேப்⁴ய​: பரம் ஆக்³ரிப்பராஜா ப³ர்ணீகீ ச பீ²ஷ்டம்ʼ ஸாக்ஷாத் கர்த்தும்ʼ கைஸரியாநக³ரம் ஆக³தவந்தௌ| ");
INSERT INTO santam_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ததா³ தௌ ப³ஹுதி³நாநி தத்ர ஸ்தி²தௌ தத​: பீ²ஷ்டஸ்தம்ʼ ராஜாநம்ʼ பௌலஸ்ய கதா²ம்ʼ விஜ்ஞாப்ய கத²யிதும் ஆரப⁴த பௌலநாமாநம் ஏகம்ʼ ப³ந்தி³ பீ²லிக்ஷோ ப³த்³த⁴ம்ʼ ஸம்ʼஸ்தா²ப்ய க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","யிரூஸா²லமி மம ஸ்தி²திகாலே மஹாயாஜகோ யிஹூதீ³யாநாம்ʼ ப்ராசீநலோகாஸ்²ச தம் அபோத்³ய தம்ப்ரதி த³ண்டா³ஜ்ஞாம்ʼ ப்ரார்த²யந்த| ");
INSERT INTO santam_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ததோஹம் இத்யுத்தரம் அவத³ம்ʼ யாவத்³ அபோதி³தோ ஜந​: ஸ்வாபவாத³காந் ஸாக்ஷாத் க்ருʼத்வா ஸ்வஸ்மிந் யோ(அ)பராத⁴ ஆரோபிதஸ்தஸ்ய ப்ரத்யுத்தரம்ʼ தா³தும்ʼ ஸுயோக³ம்ʼ ந ப்ராப்நோதி, தாவத்காலம்ʼ கஸ்யாபி மாநுஷஸ்ய ப்ராணநாஸா²ஜ்ஞாபநம்ʼ ரோமிலோகாநாம்ʼ ரீதி ர்நஹி| ");
INSERT INTO santam_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ததஸ்தேஷ்வத்ராக³தேஷு பரஸ்மிந் தி³வஸே(அ)ஹம் அவிலம்ப³ம்ʼ விசாராஸந உபவிஸ்²ய தம்ʼ மாநுஷம் ஆநேதும் ஆஜ்ஞாபயம்| ");
INSERT INTO santam_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","தத³நந்தரம்ʼ தஸ்யாபவாத³கா உபஸ்தா²ய யாத்³ருʼஸ²ம் அஹம்ʼ சிந்திதவாந் தாத்³ருʼஸ²ம்ʼ கஞ்சந மஹாபவாத³ம்ʼ நோத்தா²ப்ய ");
INSERT INTO santam_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ஸ்வேஷாம்ʼ மதே ததா² பௌலோ யம்ʼ ஸஜீவம்ʼ வத³தி தஸ்மிந் யீஸு²நாமநி ம்ருʼதஜநே ச தஸ்ய விருத்³த⁴ம்ʼ கதி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ததோஹம்ʼ தாத்³ருʼக்³விசாரே ஸம்ʼஸ²யாந​: ஸந் கதி²தவாந் த்வம்ʼ யிரூஸா²லமம்ʼ க³த்வா கிம்ʼ தத்ர விசாரிதோ ப⁴விதும் இச்ச²ஸி? ");
INSERT INTO santam_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ததா³ பௌலோ மஹாராஜஸ்ய நிகடே விசாரிதோ ப⁴விதும்ʼ ப்ரார்த²யத, தஸ்மாத்³ யாவத்காலம்ʼ தம்ʼ கைஸரஸ்ய ஸமீபம்ʼ ப்ரேஷயிதும்ʼ ந ஸ²க்நோமி தாவத்காலம்ʼ தமத்ர ஸ்தா²பயிதும் ஆதி³ஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","தத ஆக்³ரிப்ப​: பீ²ஷ்டம் உக்தவாந், அஹமபி தஸ்ய மாநுஷஸ்ய கதா²ம்ʼ ஸ்²ரோதும் அபி⁴லஷாமி| ததா³ பீ²ஷ்டோ வ்யாஹரத் ஸ்²வஸ்ததீ³யாம்ʼ கதா²ம்ʼ த்வம்ʼ ஸ்²ரோஷ்யஸி| ");
INSERT INTO santam_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","பரஸ்மிந் தி³வஸே ஆக்³ரிப்போ ப³ர்ணீகீ ச மஹாஸமாக³மம்ʼ க்ருʼத்வா ப்ரதா⁴நவாஹிநீபதிபி⁴ ர்நக³ரஸ்த²ப்ரதா⁴நலோகைஸ்²ச ஸஹ மிலித்வா ராஜக்³ருʼஹமாக³த்ய ஸமுபஸ்தி²தௌ ததா³ பீ²ஷ்டஸ்யாஜ்ஞயா பௌல ஆநீதோ(அ)ப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ததா³ பீ²ஷ்ட​: கதி²தவாந் ஹே ராஜந் ஆக்³ரிப்ப ஹே உபஸ்தி²தா​: ஸர்வ்வே லோகா யிரூஸா²லம்நக³ரே யிஹூதீ³யலோகஸமூஹோ யஸ்மிந் மாநுஷே மம ஸமீபே நிவேத³நம்ʼ க்ருʼத்வா ப்ரோச்சை​: கதா²மிமாம்ʼ கதி²தவாந் புநரல்பகாலமபி தஸ்ய ஜீவநம்ʼ நோசிதம்ʼ தமேதம்ʼ மாநுஷம்ʼ பஸ்²யத| ");
INSERT INTO santam_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","கிந்த்வேஷ ஜந​: ப்ராணநாஸ²ர்ஹம்ʼ கிமபி கர்ம்ம ந க்ருʼதவாந் இத்யஜாநாம்ʼ ததா²பி ஸ மஹாராஜஸ்ய ஸந்நிதௌ⁴ விசாரிதோ ப⁴விதும்ʼ ப்ரார்த²யத தஸ்மாத் தஸ்ய ஸமீபம்ʼ தம்ʼ ப்ரேஷயிதும்ʼ மதிமகரவம்| ");
INSERT INTO santam_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","கிந்து ஸ்ரீயுக்தஸ்ய ஸமீபம் ஏதஸ்மிந் கிம்ʼ லேக²நீயம் இத்யஸ்ய கஸ்யசிந் நிர்ணயஸ்ய ந ஜாதத்வாத்³ ஏதஸ்ய விசாரே ஸதி யதா²ஹம்ʼ லேகி²தும்ʼ கிஞ்சந நிஸ்²சிதம்ʼ ப்ராப்நோமி தத³ர்த²ம்ʼ யுஷ்மாகம்ʼ ஸமக்ஷம்ʼ விஸே²ஷதோ ஹே ஆக்³ரிப்பராஜ ப⁴வத​: ஸமக்ஷம் ஏதம் ஆநயே| ");
INSERT INTO santam_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","யதோ ப³ந்தி³ப்ரேஷணஸமயே தஸ்யாபி⁴யோக³ஸ்ய கிஞ்சித³லேக²நம் அஹம் அயுக்தம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","தத ஆக்³ரிப்ப​: பௌலம் அவாதீ³த், நிஜாம்ʼ கதா²ம்ʼ கத²யிதும்ʼ துப்⁴யம் அநுமதி ர்தீ³யதே| தஸ்மாத் பௌல​: கரம்ʼ ப்ரஸார்ய்ய ஸ்வஸ்மிந் உத்தரம் அவாதீ³த்| ");
INSERT INTO santam_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ஹே ஆக்³ரிப்பராஜ யத்காரணாத³ஹம்ʼ யிஹூதீ³யைரபவாதி³தோ (அ)ப⁴வம்ʼ தஸ்ய வ்ருʼத்தாந்தம் அத்³ய ப⁴வத​: ஸாக்ஷாந் நிவேத³யிதுமநுமதோஹம் இத³ம்ʼ ஸ்வீயம்ʼ பரமம்ʼ பா⁴க்³யம்ʼ மந்யே; ");
INSERT INTO santam_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","யதோ யிஹூதீ³யலோகாநாம்ʼ மத்⁴யே யா யா ரீதி​: ஸூக்ஷ்மவிசாராஸ்²ச ஸந்தி தேஷு ப⁴வாந் விஜ்ஞதம​:; அதஏவ ப்ரார்த²யே தை⁴ர்ய்யமவலம்ப்³ய மம நிவேத³நம்ʼ ஸ்²ருʼணோது| ");
INSERT INTO santam_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","அஹம்ʼ யிரூஸா²லம்நக³ரே ஸ்வதே³ஸீ²யலோகாநாம்ʼ மத்⁴யே திஷ்ட²ந் ஆ யௌவநகாலாத்³ யத்³ரூபம் ஆசரிதவாந் தத்³ யிஹூதீ³யலோகா​: ஸர்வ்வே வித³ந்தி| ");
INSERT INTO santam_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","அஸ்மாகம்ʼ ஸர்வ்வேப்⁴ய​: ஸு²த்³த⁴தமம்ʼ யத் பி²ரூஸீ²யமதம்ʼ தத³வலம்பீ³ பூ⁴த்வாஹம்ʼ காலம்ʼ யாபிதவாந் யே ஜநா ஆ பா³ல்யகாலாந் மாம்ʼ ஜாநாந்தி தே ஏதாத்³ருʼஸ²ம்ʼ ஸாக்ஷ்யம்ʼ யதி³ த³தா³தி தர்ஹி தா³தும்ʼ ஸ²க்நுவந்தி| ");
INSERT INTO santam_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","கிந்து ஹே ஆக்³ரிப்பராஜ ஈஸ்²வரோ(அ)ஸ்மாகம்ʼ பூர்வ்வபுருஷாணாம்ʼ நிகடே யத்³ அங்கீ³க்ருʼதவாந் தஸ்ய ப்ரத்யாஸா²ஹேதோரஹம் இதா³நீம்ʼ விசாரஸ்தா²நே த³ண்டா³யமாநோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","தஸ்யாங்கீ³காரஸ்ய ப²லம்ʼ ப்ராப்தும் அஸ்மாகம்ʼ த்³வாத³ஸ²வம்ʼஸா² தி³வாநிஸ²ம்ʼ மஹாயத்நாத்³ ஈஸ்²வரஸேவநம்ʼ க்ருʼத்வா யாம்ʼ ப்ரத்யாஸா²ம்ʼ குர்வ்வந்தி தஸ்யா​: ப்ரத்யாஸா²யா ஹேதோரஹம்ʼ யிஹூதீ³யைரபவாதி³தோ(அ)ப⁴வம்| ");
INSERT INTO santam_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ஈஸ்²வரோ ம்ருʼதாந் உத்தா²பயிஷ்யதீதி வாக்யம்ʼ யுஷ்மாகம்ʼ நிகடே(அ)ஸம்ப⁴வம்ʼ குதோ ப⁴வேத்? ");
INSERT INTO santam_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","நாஸரதீயயீஸோ² ர்நாம்நோ விருத்³த⁴ம்ʼ நாநாப்ரகாரப்ரதிகூலாசரணம் உசிதம் இத்யஹம்ʼ மநஸி யதா²ர்த²ம்ʼ விஜ்ஞாய ");
INSERT INTO santam_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","யிரூஸா²லமநக³ரே தத³கரவம்ʼ ப²லத​: ப்ரதா⁴நயாஜகஸ்ய நிகடாத் க்ஷமதாம்ʼ ப்ராப்ய ப³ஹூந் பவித்ரலோகாந் காராயாம்ʼ ப³த்³த⁴வாந் விஸே²ஷதஸ்தேஷாம்ʼ ஹநநஸமயே தேஷாம்ʼ விருத்³தா⁴ம்ʼ நிஜாம்ʼ ஸம்மதிம்ʼ ப்ரகாஸி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","வாரம்ʼ வாரம்ʼ ப⁴ஜநப⁴வநேஷு தேப்⁴யோ த³ண்ட³ம்ʼ ப்ரத³த்தவாந் ப³லாத் தம்ʼ த⁴ர்ம்மம்ʼ நிந்த³யிதவாம்ʼஸ்²ச புநஸ்²ச தாந் ப்ரதி மஹாக்ரோதா⁴த்³ உந்மத்த​: ஸந் விதே³ஸீ²யநக³ராணி யாவத் தாந் தாடி³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","இத்த²ம்ʼ ப்ரதா⁴நயாஜகஸ்ய ஸமீபாத் ஸ²க்திம் ஆஜ்ஞாபத்ரஞ்ச லப்³த்⁴வா த³ம்மேஷக்நக³ரம்ʼ க³தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ததா³ஹம்ʼ ஹே ராஜந் மார்க³மத்⁴யே மத்⁴யாஹ்நகாலே மம மதீ³யஸங்கி³நாம்ʼ லோகாநாஞ்ச சதஸ்ருʼஷு தி³க்ஷு க³க³ணாத் ப்ரகாஸ²மாநாம்ʼ பா⁴ஸ்கரதோபி தேஜஸ்வதீம்ʼ தீ³ப்திம்ʼ த்³ருʼஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","தஸ்மாத்³ அஸ்மாஸு ஸர்வ்வேஷு பூ⁴மௌ பதிதேஷு ஸத்ஸு ஹே ஸௌ²ல ஹை ஸௌ²ல குதோ மாம்ʼ தாட³யஸி? கண்டகாநாம்ʼ முகே² பாதா³ஹநநம்ʼ தவ து³​:ஸாத்⁴யம் இப்³ரீயபா⁴ஷயா க³தி³த ஏதாத்³ருʼஸ² ஏக​: ஸ²ப்³தோ³ மயா ஸ்²ருத​:| ");
INSERT INTO santam_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ததா³ஹம்ʼ ப்ருʼஷ்டவாந் ஹே ப்ரபோ⁴ கோ ப⁴வாந்? தத​: ஸ கதி²தவாந் யம்ʼ யீஸு²ம்ʼ த்வம்ʼ தாட³யஸி ஸோஹம்ʼ, ");
INSERT INTO santam_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","கிந்து ஸமுத்திஷ்ட² த்வம்ʼ யத்³ த்³ருʼஷ்டவாந் இத​: புநஞ்ச யத்³யத் த்வாம்ʼ த³ர்ஸ²யிஷ்யாமி தேஷாம்ʼ ஸர்வ்வேஷாம்ʼ கார்ய்யாணாம்ʼ த்வாம்ʼ ஸாக்ஷிணம்ʼ மம ஸேவகஞ்ச கர்த்தும் த³ர்ஸ²நம் அதா³ம்| ");
INSERT INTO santam_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","விஸே²ஷதோ யிஹூதீ³யலோகேப்⁴யோ பி⁴ந்நஜாதீயேப்⁴யஸ்²ச த்வாம்ʼ மநோநீதம்ʼ க்ருʼத்வா தேஷாம்ʼ யதா² பாபமோசநம்ʼ ப⁴வதி ");
INSERT INTO santam_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","யதா² தே மயி விஸ்²வஸ்ய பவித்ரீக்ருʼதாநாம்ʼ மத்⁴யே பா⁴க³ம்ʼ ப்ராப்நுவந்தி தத³பி⁴ப்ராயேண தேஷாம்ʼ ஜ்ஞாநசக்ஷூம்ʼஷி ப்ரஸந்நாநி கர்த்தும்ʼ ததா²ந்த⁴காராத்³ தீ³ப்திம்ʼ ப்ரதி ஸை²தாநாதி⁴காராச்ச ஈஸ்²வரம்ʼ ப்ரதி மதீ​: பராவர்த்தயிதும்ʼ தேஷாம்ʼ ஸமீபம்ʼ த்வாம்ʼ ப்ரேஷ்யாமி| ");
INSERT INTO santam_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ஹே ஆக்³ரிப்பராஜ ஏதாத்³ருʼஸ²ம்ʼ ஸ்வர்கீ³யப்ரத்யாதே³ஸ²ம்ʼ அக்³ராஹ்யம் அக்ருʼத்வாஹம்ʼ ");
INSERT INTO santam_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ப்ரத²மதோ த³ம்மேஷக்நக³ரே ததோ யிரூஸா²லமி ஸர்வ்வஸ்மிந் யிஹூதீ³யதே³ஸே² அந்யேஷு தே³ஸே²ஷு ச யேेந லோகா மதிம்ʼ பராவர்த்த்ய ஈஸ்²வரம்ʼ ப்ரதி பராவர்த்தயந்தே, மந​:பராவர்த்தநயோக்³யாநி கர்ம்மாணி ச குர்வ்வந்தி தாத்³ருʼஸ²ம் உபதே³ஸ²ம்ʼ ப்ரசாரிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ஏதத்காரணாத்³ யிஹூதீ³யா மத்⁴யேமந்தி³ரம்ʼ மாம்ʼ த்⁴ருʼத்வா ஹந்தும் உத்³யதா​:| ");
INSERT INTO santam_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ததா²பி க்²ரீஷ்டோ து³​:க²ம்ʼ பு⁴க்த்வா ஸர்வ்வேஷாம்ʼ பூர்வ்வம்ʼ ஸ்²மஸா²நாத்³ உத்தா²ய நிஜதே³ஸீ²யாநாம்ʼ பி⁴ந்நதே³ஸீ²யாநாஞ்ச ஸமீபே தீ³ப்திம்ʼ ப்ரகாஸ²யிஷ்யதி ");
INSERT INTO santam_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ப⁴விஷ்யத்³வாதி³க³ணோ மூஸாஸ்²ச பா⁴விகார்ய்யஸ்ய யதி³த³ம்ʼ ப்ரமாணம் அத³து³ரேதத்³ விநாந்யாம்ʼ கதா²ம்ʼ ந கத²யித்வா ஈஸ்²வராத்³ அநுக்³ரஹம்ʼ லப்³த்⁴வா மஹதாம்ʼ க்ஷுத்³ராணாஞ்ச ஸர்வ்வேஷாம்ʼ ஸமீபே ப்ரமாணம்ʼ த³த்த்வாத்³ய யாவத் திஷ்டா²மி| ");
INSERT INTO santam_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","தஸ்யமாம்ʼ கதா²ம்ʼ நிஸ²ம்ய பீ²ஷ்ட உச்சை​: ஸ்வரேண கதி²தவாந் ஹே பௌல த்வம் உந்மத்தோஸி ப³ஹுவித்³யாப்⁴யாஸேந த்வம்ʼ ஹதஜ்ஞாநோ ஜாத​:| ");
INSERT INTO santam_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ஸ உக்தவாந் ஹே மஹாமஹிம பீ²ஷ்ட நாஹம் உந்மத்த​: கிந்து ஸத்யம்ʼ விவேசநீயஞ்ச வாக்யம்ʼ ப்ரஸ்தௌமி| ");
INSERT INTO santam_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","யஸ்ய ஸாக்ஷாத்³ அக்ஷோப⁴​: ஸந் கதா²ம்ʼ கத²யாமி ஸ ராஜா தத்³வ்ருʼத்தாந்தம்ʼ ஜாநாதி தஸ்ய ஸமீபே கிமபி கு³ப்தம்ʼ நேதி மயா நிஸ்²சிதம்ʼ பு³த்⁴யதே யதஸ்தத்³ விஜநே ந க்ருʼதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ஹே ஆக்³ரிப்பராஜ ப⁴வாந் கிம்ʼ ப⁴விஷ்யத்³வாதி³க³ணோக்தாநி வாக்யாநி ப்ரத்யேதி? ப⁴வாந் ப்ரத்யேதி தத³ஹம்ʼ ஜாநாமி| ");
INSERT INTO santam_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","தத ஆக்³ரிப்ப​: பௌலம் அபி⁴ஹிதவாந் த்வம்ʼ ப்ரவ்ருʼத்திம்ʼ ஜநயித்வா ப்ராயேண மாமபி க்²ரீஷ்டீயம்ʼ கரோஷி| ");
INSERT INTO santam_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","தத​: ஸோ(அ)வாதீ³த் ப⁴வாந் யே யே லோகாஸ்²ச மம கதா²ம் அத்³ய ஸ்²ருʼண்வந்தி ப்ராயேண இதி நஹி கிந்த்வேதத் ஸ்²ருʼங்க²லப³ந்த⁴நம்ʼ விநா ஸர்வ்வதா² தே ஸர்வ்வே மாத்³ருʼஸா² ப⁴வந்த்விதீஸ்²வஸ்ய ஸமீபே ப்ரார்த²யே(அ)ஹம்| ");
INSERT INTO santam_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ஏதஸ்யாம்ʼ கதா²யாம்ʼ கதி²தாயாம்ʼ ஸ ராஜா ஸோ(அ)தி⁴பதி ர்ப³ர்ணீகீ ஸபா⁴ஸ்தா² லோகாஸ்²ச தஸ்மாத்³ உத்தா²ய ");
INSERT INTO santam_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","கோ³பநே பரஸ்பரம்ʼ விவிச்ய கதி²தவந்த ஏஷ ஜநோ ப³ந்த⁴நார்ஹம்ʼ ப்ராணஹநநார்ஹம்ʼ வா கிமபி கர்ம்ம நாகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","தத ஆக்³ரிப்ப​: பீ²ஷ்டம் அவத³த், யத்³யேஷ மாநுஷ​: கைஸரஸ்ய நிகடே விசாரிதோ ப⁴விதும்ʼ ந ப்ரார்த²யிஷ்யத் தர்ஹி முக்தோ ப⁴விதும் அஸ²க்ஷ்யத்| ");
INSERT INTO santam_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ஜலபதே²நாஸ்மாகம் இதோலியாதே³ஸ²ம்ʼ ப்ரதி யாத்ராயாம்ʼ நிஸ்²சிதாயாம்ʼ ஸத்யாம்ʼ தே யூலியநாம்நோ மஹாராஜஸ்ய ஸம்ʼகா⁴தாந்தர்க³தஸ்ய ஸேநாபதே​: ஸமீபே பௌலம்ʼ தத³ந்யாந் கதிநயஜநாம்ʼஸ்²ச ஸமார்பயந்| ");
INSERT INTO santam_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","வயம் ஆத்³ராமுத்தீயம்ʼ போதமேகம் ஆருஹ்ய ஆஸி²யாதே³ஸ²ஸ்ய தடஸமீபேந யாதும்ʼ மதிம்ʼ க்ருʼத்வா லங்க³ரம் உத்தா²ப்ய போதம் அமோசயாம; மாகித³நியாதே³ஸ²ஸ்த²தி²ஷலநீகீநிவாஸ்யாரிஸ்தார்க²நாமா கஸ்²சித்³ ஜநோ(அ)ஸ்மாபி⁴​: ஸார்த்³த⁴ம் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","பரஸ்மிந் தி³வஸே (அ)ஸ்மாபி⁴​: ஸீதோ³ந்நக³ரே போதே லாகி³தே தத்ர யூலிய​: ஸேநாபதி​: பௌலம்ʼ ப்ரதி ஸௌஜந்யம்ʼ ப்ரத³ர்த்²ய ஸாந்த்வநார்த²ம்ʼ ப³ந்து⁴பா³ந்த⁴வாந் உபயாதும் அநுஜஜ்ஞௌ| ");
INSERT INTO santam_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","தஸ்மாத் போதே மோசிதே ஸதி ஸம்முக²வாயோ​: ஸம்ப⁴வாத்³ வயம்ʼ குப்ரோபத்³வீபஸ்ய தீரஸமீபேந க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","கிலிகியாயா​: பாம்பூ²லியாயாஸ்²ச ஸமுத்³ரஸ்ய பாரம்ʼ க³த்வா லூகியாதே³ஸா²ந்தர்க³தம்ʼ முராநக³ரம் உபாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","தத்ஸ்தா²நாத்³ இதாலியாதே³ஸ²ம்ʼ க³ச்ச²தி ய​: ஸிகந்த³ரியாநக³ரஸ்ய போதஸ்தம்ʼ தத்ர ப்ராப்ய ஸ²தஸேநாபதிஸ்தம்ʼ போதம் அஸ்மாந் ஆரோஹயத்| ");
INSERT INTO santam_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","தத​: பரம்ʼ ப³ஹூநி தி³நாநி ஸ²நை​: ஸ²நை​: ர்க³த்வா க்நீத³பார்ஸ்²வோபஸ்த்²திे​: பூர்வ்வம்ʼ ப்ரதிகூலேந பவநேந வயம்ʼ ஸல்மோந்யா​: ஸம்முக²ம் உபஸ்தா²ய க்ரீத்யுபத்³வீபஸ்ய தீரஸமீபேந க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","கஷ்டேந தமுத்தீர்ய்ய லாஸேயாநக³ரஸ்யாத⁴​: ஸுந்த³ரநாமகம்ʼ கா²தம் உபாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","இத்த²ம்ʼ ப³ஹுதித²​: காலோ யாபித உபவாஸதி³நஞ்சாதீதம்ʼ, தத்காரணாத் நௌவர்த்மநி ப⁴யங்கரே ஸதி பௌலோ விநயேந கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ஹே மஹேச்சா² அஹம்ʼ நிஸ்²சயம்ʼ ஜாநாமி யாத்ராயாமஸ்யாம் அஸ்மாகம்ʼ க்லேஸா² ப³ஹூநாமபசயாஸ்²ச ப⁴விஷ்யந்தி, தே கேவலம்ʼ போதஸாமக்³ர்யோரிதி நஹி, கிந்த்வஸ்மாகம்ʼ ப்ராணாநாமபி| ");
INSERT INTO santam_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ததா³ ஸ²தஸேநாபதி​: பௌैेலோக்தவாக்யதோபி கர்ணதா⁴ரஸ்ய போதவணிஜஸ்²ச வாக்யம்ʼ ப³ஹுமம்ʼஸ்த| ");
INSERT INTO santam_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","தத் கா²தம்ʼ ஸீ²தகாலே வாஸார்ஹஸ்தா²நம்ʼ ந தஸ்மாத்³ அவாசீப்ரதீசோர்தி³ஸோ²​: க்ரீத்யா​: பை²நீகியகா²தம்ʼ யாதும்ʼ யதி³ ஸ²க்நுவந்தஸ்தர்ஹி தத்ர ஸீ²தகாலம்ʼ யாபயிதும்ʼ ப்ராயேண ஸர்வ்வே மந்த்ரயாமாஸு​:| ");
INSERT INTO santam_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","தத​: பரம்ʼ த³க்ஷிணவாயு ர்மந்த³ம்ʼ வஹதீதி விலோக்ய நிஜாபி⁴ப்ராயஸ்ய ஸித்³தே⁴​: ஸுயோகோ³ ப⁴வதீதி பு³த்³த்⁴வா போதம்ʼ மோசயித்வா க்ரீத்யுபத்³வீபஸ்ய தீரஸமீபேந சலிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","கிந்த்வல்பக்ஷணாத் பரமேவ உரக்லுதோ³ந்நாமா ப்ரதிகூல​: ப்ரசண்டோ³ வாயு ர்வஹந் போதே(அ)லகீ³த் ");
INSERT INTO santam_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","தஸ்யாபி⁴முக²ம்ʼ க³ந்தும் போதஸ்யாஸ²க்தத்வாத்³ வயம்ʼ வாயுநா ஸ்வயம்ʼ நீதா​:| ");
INSERT INTO santam_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","அநந்தரம்ʼ க்லௌதீ³நாம்ந உபத்³வீபஸ்ய கூலஸமீபேந போதம்ʼ க³மயித்வா ப³ஹுநா கஷ்டேந க்ஷுத்³ரநாவம் அரக்ஷாம| ");
INSERT INTO santam_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","தே தாமாருஹ்ய ரஜ்ஜ்சா போதஸ்யாதோ⁴பா⁴க³ம் அப³த்⁴நந் தத³நந்தரம்ʼ சேத் போதோ ஸைகதே லக³தீதி ப⁴யாத்³ வாதவஸநாந்யமோசயந் தத​: போதோ வாயுநா சாலித​:| ");
INSERT INTO santam_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","கிந்து க்ரமஸோ² வாயோ​: ப்ரப³லத்வாத் போதோ தோ³லாயமாநோ(அ)ப⁴வத் பரஸ்மிந் தி³வஸே போதஸ்தா²நி கதிபயாநி த்³ரவ்யாணி தோயே நிக்ஷிப்தாநி| ");
INSERT INTO santam_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","த்ருʼதீயதி³வஸே வயம்ʼ ஸ்வஹஸ்தை​: போதஸஜ்ஜநத்³ரவ்யாணி நிக்ஷிப்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ததோ ப³ஹுதி³நாநி யாவத் ஸூர்ய்யநக்ஷத்ராதீ³நி ஸமாச்ச²ந்நாநி ததோ (அ)தீவ வாத்யாக³மாத்³ அஸ்மாகம்ʼ ப்ராணரக்ஷாயா​: காபி ப்ரத்யாஸா² நாதிஷ்ட²த்| ");
INSERT INTO santam_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ப³ஹுதி³நேஷு லோகைரநாஹாரேண யாபிதேஷு ஸர்வ்வேஷாம்ʼ ஸாக்ஷத் பௌலஸ்திஷ்ட²ந் அகத²யத், ஹே மஹேச்சா²​: க்ரீத்யுபத்³வீபாத் போதம்ʼ ந மோசயிதும் அஹம்ʼ பூர்வ்வம்ʼ யத்³ அவத³ம்ʼ தத்³க்³ரஹணம்ʼ யுஷ்மாகம் உசிதம் ஆஸீத் ததா² க்ருʼதே யுஷ்மாகம் ஏஷா விபத்³ ஏஷோ(அ)பசயஸ்²ச நாக⁴டிஷ்யேதாம்| ");
INSERT INTO santam_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","கிந்து ஸாம்ப்ரதம்ʼ யுஷ்மாந் விநீய ப்³ரவீம்யஹம்ʼ, யூயம்ʼ ந க்ஷுப்⁴யத யுஷ்மாகம் ஏகஸ்யாபி ப்ராணிநோ ஹாநி ர்ந ப⁴விஷ்யதி, கேவலஸ்ய போதஸ்ய ஹாநி ர்ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","யதோ யஸ்யேஸ்²வரஸ்ய லோகோ(அ)ஹம்ʼ யஞ்சாஹம்ʼ பரிசராமி ததீ³ய ஏகோ தூ³தோ ஹ்யோ ராத்ரௌ மமாந்திகே திஷ்ட²ந் கதி²தவாந், ");
INSERT INTO santam_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ஹே பௌல மா பை⁴ஷீ​: கைஸரஸ்ய ஸம்முகே² த்வயோபஸ்தா²தவ்யம்ʼ; தவைதாந் ஸங்கி³நோ லோகாந் ஈஸ்²வரஸ்துப்⁴யம்ʼ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","அதஏவ ஹே மஹேச்சா² யூயம்ʼ ஸ்தி²ரமநஸோ ப⁴வத மஹ்யம்ʼ யா கதா²கதி² ஸாவஸ்²யம்ʼ க⁴டிஷ்யதே மமைதாத்³ருʼஸீ² விஸ்²வாஸ ஈஸ்²வரே வித்³யதே, ");
INSERT INTO santam_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","கிந்து கஸ்யசித்³ உபத்³வீபஸ்யோபரி பதிதவ்யம் அஸ்மாபி⁴​:| ");
INSERT INTO santam_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","தத​: பரம் ஆத்³ரியாஸமுத்³ரே போதஸ்ததை²வ தோ³லாயமாந​: ஸந் இதஸ்ததோ க³ச்ச²ந் சதுர்த³ஸ²தி³வஸஸ்ய ராத்ரே ர்த்³விதீயப்ரஹரஸமயே கஸ்யசித் ஸ்த²லஸ்ய ஸமீபமுபதிஷ்ட²தீதி போதீயலோகா அந்வமந்யந்த| ");
INSERT INTO santam_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ததஸ்தே ஜலம்ʼ பரிமாய தத்ர விம்ʼஸ²தி ர்வ்யாமா ஜலாநீதி ஜ்ஞாதவந்த​:| கிஞ்சித்³தூ³ரம்ʼ க³த்வா புநரபி ஜலம்ʼ பரிமிதவந்த​:| தத்ர பஞ்சத³ஸ² வ்யாமா ஜலாநி த்³ருʼஷ்ட்வா ");
INSERT INTO santam_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","சேத் பாஷாணே லக³தீதி ப⁴யாத் போதஸ்ய பஸ்²சாத்³பா⁴க³தஸ்²சதுரோ லங்க³ராந் நிக்ஷிப்ய தி³வாகரம் அபேக்ஷ்ய ஸர்வ்வே ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","கிந்து போதீயலோகா​: போதாக்³ரபா⁴கே³ லங்க³ரநிக்ஷேபம்ʼ ச²லம்ʼ க்ருʼத்வா ஜலதௌ⁴ க்ஷுத்³ரநாவம் அவரோஹ்ய பலாயிதும் அசேஷ்டந்த| ");
INSERT INTO santam_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","தத​: பௌல​: ஸேநாபதயே ஸைந்யக³ணாய ச கதி²தவாந், ஏதே யதி³ போதமத்⁴யே ந திஷ்ட²ந்தி தர்ஹி யுஷ்மாகம்ʼ ரக்ஷணம்ʼ ந ஸ²க்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ததா³ ஸேநாக³ணோ ரஜ்ஜூந் சி²த்வா நாவம்ʼ ஜலே பதிதும் அத³தா³த்| ");
INSERT INTO santam_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ப்ரபா⁴தஸமயே பௌல​: ஸர்வ்வாந் ஜநாந் போ⁴ஜநார்த²ம்ʼ ப்ரார்த்²ய வ்யாஹரத், அத்³ய சதுர்த³ஸ²தி³நாநி யாவத்³ யூயம் அபேக்ஷமாநா அநாஹாரா​: காலம் அயாபயத கிமபி நாபு⁴ம்ʼக்³த⁴ம்ʼ| ");
INSERT INTO santam_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","அதோ விநயேे(அ)ஹம்ʼ ப⁴க்ஷ்யம்ʼ பு⁴ஜ்யதாம்ʼ ததோ யுஷ்மாகம்ʼ மங்க³லம்ʼ ப⁴விஷ்யதி, யுஷ்மாகம்ʼ கஸ்யசிஜ்ஜநஸ்ய ஸி²ரஸ​: கேஸை²கோபி ந நம்ʼக்ஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","இதி வ்யாஹ்ருʼத்ய பௌலம்ʼ பூபம்ʼ க்³ருʼஹீத்வேஸ்²வரம்ʼ த⁴ந்யம்ʼ பா⁴ஷமாணஸ்தம்ʼ ப⁴ம்ʼக்த்வா போ⁴க்தும் ஆரப்³த⁴வாந்| ");
INSERT INTO santam_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","அநந்தரம்ʼ ஸர்வ்வே ச ஸுஸ்தி²ரா​: ஸந்த​: கா²த்³யாநி பர்ப்யக்³ருʼஹ்லந்| ");
INSERT INTO santam_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","அஸ்மாகம்ʼ போதே ஷட்ஸப்தத்யதி⁴கஸ²தத்³வயலோகா ஆஸந்| ");
INSERT INTO santam_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ஸர்வ்வேஷு லோகேஷு யதே²ஷ்டம்ʼ பு⁴க்தவத்ஸு போதஸ்த²ந் கோ³தூ⁴மாந் ஜலதௌ⁴ நிக்ஷிப்ய தை​: போதஸ்ய பா⁴ரோ லகூ⁴க்ருʼத​:| ");
INSERT INTO santam_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","தி³நே ஜாதே(அ)பி ஸ கோ தே³ஸ² இதி ததா³ ந பர்ய்யசீயத; கிந்து தத்ர ஸமதடம் ஏகம்ʼ கா²தம்ʼ த்³ருʼஷ்ட்வா யதி³ ஸ²க்நுமஸ்தர்ஹி வயம்ʼ தஸ்யாப்⁴யந்தரம்ʼ போதம்ʼ க³மயாம இதி மதிம்ʼ க்ருʼத்வா தே லங்க³ராந் சி²த்த்வா ஜலதௌ⁴ த்யக்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ததா² கர்ணப³ந்த⁴நம்ʼ மோசயித்வா ப்ரதா⁴நம்ʼ வாதவஸநம் உத்தோல்ய தீரஸமீபம்ʼ க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","கிந்து த்³வயோ​: ஸமுத்³ரயோ​: ஸங்க³மஸ்தா²நே ஸைகதோபரி போதே நிக்ஷிப்தே (அ)க்³ரபா⁴கே³ பா³தி⁴தே பஸ்²சாத்³பா⁴கே³ ப்ரப³லதரங்கோ³(அ)லக³த் தேந போதோ ப⁴க்³ந​:| ");
INSERT INTO santam_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","தஸ்மாத்³ ப³ந்த³யஸ்²சேத்³ பா³ஹுபி⁴ஸ்தரந்த​: பலாயந்தே இத்யாஸ²ங்கயா ஸேநாக³ணஸ்தாந் ஹந்தும் அமந்த்ரயத்; ");
INSERT INTO santam_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","கிந்து ஸ²தஸேநாபதி​: பௌலம்ʼ ரக்ஷிதும்ʼ ப்ரயத்நம்ʼ க்ருʼத்வா தாந் தச்சேஷ்டாயா நிவர்த்ய இத்யாதி³ஷ்டவாந், யே பா³ஹுதரணம்ʼ ஜாநந்தி தே(அ)க்³ரே ப்ரோல்லம்ப்ய ஸமுத்³ரே பதித்வா பா³ஹுபி⁴ஸ்தீர்த்த்வா கூலம்ʼ யாந்து| ");
INSERT INTO santam_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","அபரம் அவஸி²ஷ்டா ஜநா​: காஷ்ட²ம்ʼ போதீயம்ʼ த்³ரவ்யம்ʼ வா யேந யத் ப்ராப்யதே தத³வலம்ப்³ய யாந்து; இத்த²ம்ʼ ஸர்வ்வே பூ⁴மிம்ʼ ப்ராப்ய ப்ராணை ர்ஜீவிதா​:| ");
INSERT INTO santam_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","இத்த²ம்ʼ ஸர்வ்வேஷு ரக்ஷாம்ʼ ப்ராப்தேஷு தத்ரத்யோபத்³வீபஸ்ய நாம மிலீதேதி தே ஜ்ஞாதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","அஸப்⁴யலோகா யதே²ஷ்டம் அநுகம்பாம்ʼ க்ருʼத்வா வர்த்தமாநவ்ருʼஷ்டே​: ஸீ²தாச்ச வஹ்நிம்ʼ ப்ரஜ்ஜ்வால்யாஸ்மாகம் ஆதித்²யம் அகுர்வ்வந்| ");
INSERT INTO santam_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","கிந்து பௌல இந்த⁴நாநி ஸம்ʼக்³ருʼஹ்ய யதா³ தஸ்மிந் அக்³ரௌ நிரக்ஷிபத், ததா³ வஹ்நே​: ப்ரதாபாத் ஏக​: க்ருʼஷ்ணஸர்போ நிர்க³த்ய தஸ்ய ஹஸ்தே த்³ரஷ்டவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","தே(அ)ஸப்⁴யலோகாஸ்தஸ்ய ஹஸ்தே ஸர்பம் அவலம்ப³மாநம்ʼ த்³ருʼஷ்ட்வா பரஸ்பரம் உக்தவந்த ஏஷ ஜநோ(அ)வஸ்²யம்ʼ நரஹா ப⁴விஷ்யதி, யதோ யத்³யபி ஜலதே⁴ ரக்ஷாம்ʼ ப்ராப்தவாந் ததா²பி ப்ரதிப²லதா³யக ஏநம்ʼ ஜீவிதும்ʼ ந த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","கிந்து ஸ ஹஸ்தம்ʼ விது⁴ந்வந் தம்ʼ ஸர்பம் அக்³நிமத்⁴யே நிக்ஷிப்ய காமபி பீடா³ம்ʼ நாப்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ததோ விஷஜ்வாலயா ஏதஸ்ய ஸ²ரீரம்ʼ ஸ்பீ²தம்ʼ ப⁴விஷ்யதி யத்³வா ஹடா²த³யம்ʼ ப்ராணாந் த்யக்ஷ்யதீதி நிஸ்²சித்ய லோகா ப³ஹுக்ஷணாநி யாவத் தத்³ த்³ரஷ்டும்ʼ ஸ்தி²தவந்த​: கிந்து தஸ்ய கஸ்யாஸ்²சித்³ விபதோ³(அ)க⁴டநாத் தே தத்³விபரீதம்ʼ விஜ்ஞாய பா⁴ஷிதவந்த ஏஷ கஸ்²சித்³ தே³வோ ப⁴வேத்| ");
INSERT INTO santam_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","புப்³லியநாமா ஜந ஏகஸ்தஸ்யோபத்³வீபஸ்யாதி⁴பதிராஸீத் தத்ர தஸ்ய பூ⁴ம்யாதி³ ச ஸ்தி²தம்ʼ| ஸ ஜநோ(அ)ஸ்மாந் நிஜக்³ருʼஹம்ʼ நீத்வா ஸௌஜந்யம்ʼ ப்ரகாஸ்²ய தி³நத்ரயம்ʼ யாவத்³ அஸ்மாகம்ʼ ஆதித்²யம் அகரோத்| ");
INSERT INTO santam_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ததா³ தஸ்ய புப்³லியஸ்ய பிதா ஜ்வராதிஸாரேண பீட்³யமாந​: ஸந் ஸ²ய்யாயாம் ஆஸீத்; தத​: பௌலஸ்தஸ்ய ஸமீபம்ʼ க³த்வா ப்ரார்த²நாம்ʼ க்ருʼத்வா தஸ்ய கா³த்ரே ஹஸ்தம்ʼ ஸமர்ப்ய தம்ʼ ஸ்வஸ்த²ம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","இத்த²ம்ʼ பூ⁴தே தத்³வீபநிவாஸிந இதரேபி ரோகி³லோகா ஆக³த்ய நிராமயா அப⁴வந்| ");
INSERT INTO santam_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","தஸ்மாத்தே(அ)ஸ்மாகம் அதீவ ஸத்காரம்ʼ க்ருʼதவந்த​:, விஸே²ஷத​: ப்ரஸ்தா²நஸமயே ப்ரயோஜநீயாநி நாநத்³ரவ்யாணி த³த்தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","இத்த²ம்ʼ தத்ர த்ரிஷு மாஸேஷு க³தேஷு யஸ்ய சிஹ்நம்ʼ தி³யஸ்கூரீ தாத்³ருʼஸ² ஏக​: ஸிகந்த³ரீயநக³ரஸ்ய போத​: ஸீ²தகாலம்ʼ யாபயந் தஸ்மிந் உபத்³வீபே (அ)திஷ்ட²த் தமேவ போதம்ʼ வயம் ஆருஹ்ய யாத்ராம் அகுர்ம்ம| ");
INSERT INTO santam_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","தத​: ப்ரத²மத​: ஸுராகூஸநக³ரம் உபஸ்தா²ய தத்ர த்ரீணி தி³நாநி ஸ்தி²தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","தஸ்மாத்³ ஆவ்ருʼத்ய ரீகி³யநக³ரம் உபஸ்தி²தா​: தி³நைகஸ்மாத் பரம்ʼ த³க்ஷிணவயௌ ஸாநுகூல்யே ஸதி பரஸ்மிந் தி³வஸே பதியலீநக³ரம் உபாதிஷ்டா²ம| ");
INSERT INTO santam_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ததோ(அ)ஸ்மாஸு தத்ரத்யம்ʼ ப்⁴ராத்ருʼக³ணம்ʼ ப்ராப்தேஷு தே ஸ்வை​: ஸார்த்³த⁴ம் அஸ்மாந் ஸப்த தி³நாநி ஸ்தா²பயிதும் அயதந்த, இத்த²ம்ʼ வயம்ʼ ரோமாநக³ரம் ப்ரத்யக³ச்சா²ம| ");
INSERT INTO santam_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","தஸ்மாத் தத்ரத்யா​: ப்⁴ராதரோ(அ)ஸ்மாகம் ஆக³மநவார்த்தாம்ʼ ஸ்²ருத்வா ஆப்பியப²ரம்ʼ த்ரிஷ்டாவர்ணீஞ்ச யாவத்³ அக்³ரேஸரா​: ஸந்தோஸ்மாந் ஸாக்ஷாத் கர்த்தும் ஆக³மந்; தேஷாம்ʼ த³ர்ஸ²நாத் பௌல ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வத³ந் ஆஸ்²வாஸம் ஆப்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","அஸ்மாஸு ரோமாநக³ரம்ʼ க³தேஷு ஸ²தஸேநாபதி​: ஸர்வ்வாந் ப³ந்தீ³ந் ப்ரதா⁴நஸேநாபதே​: ஸமீபே ஸமார்பயத் கிந்து பௌலாய ஸ்வரக்ஷகபதா³திநா ஸஹ ப்ருʼத²க்³ வஸ்தும் அநுமதிம்ʼ த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","தி³நத்ரயாத் பரம்ʼ பௌலஸ்தத்³தே³ஸ²ஸ்தா²ந் ப்ரதா⁴நயிஹூதி³ந ஆஹூதவாந் ததஸ்தேஷு ஸமுபஸ்தி²தேஷு ஸ கதி²தவாந், ஹே ப்⁴ராத்ருʼக³ண நிஜலோகாநாம்ʼ பூர்வ்வபுருஷாணாம்ʼ வா ரீதே ர்விபரீதம்ʼ கிஞ்சந கர்ம்மாஹம்ʼ நாகரவம்ʼ ததா²பி யிரூஸா²லமநிவாஸிநோ லோகா மாம்ʼ ப³ந்தி³ம்ʼ க்ருʼத்வா ரோமிலோகாநாம்ʼ ஹஸ்தேஷு ஸமர்பிதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ரோமிலோகா விசார்ய்ய மம ப்ராணஹநநார்ஹம்ʼ கிமபி காரணம்ʼ ந ப்ராப்ய மாம்ʼ மோசயிதும் ஐச்ச²ந்; ");
INSERT INTO santam_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","கிந்து யிஹூதி³லோகாநாம் ஆபத்த்யா மயா கைஸரராஜஸ்ய ஸமீபே விசாரஸ்ய ப்ரார்த²நா கர்த்தவ்யா ஜாதா நோசேத் நிஜதே³ஸீ²யலோகாந் ப்ரதி மம கோப்யபி⁴யோகோ³ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ஏதத்காரணாத்³ அஹம்ʼ யுஷ்மாந் த்³ரஷ்டும்ʼ ஸம்ʼலபிதுஞ்சாஹூயம் இஸ்ராயேல்வஸீ²யாநாம்ʼ ப்ரத்யாஸா²ஹேதோஹம் ஏதேந ஸு²ங்க²லேந ப³த்³தோ⁴(அ)ப⁴வம்| ");
INSERT INTO santam_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ததா³ தே தம் அவாதி³ஷு​:, யிஹூதீ³யதே³ஸா²த்³ வயம்ʼ த்வாமதி⁴ கிமபி பத்ரம்ʼ ந ப்ராப்தா யே ப்⁴ராதர​: ஸமாயாதாஸ்தேஷாம்ʼ கோபி தவ காமபி வார்த்தாம்ʼ நாவத³த் அப⁴த்³ரமபி நாகத²யச்ச| ");
INSERT INTO santam_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","தவ மதம்ʼ கிமிதி வயம்ʼ த்வத்த​: ஸ்²ரோதுமிச்சா²ம​:| யத்³ இத³ம்ʼ நவீநம்ʼ மதமுத்தி²தம்ʼ தத் ஸர்வ்வத்ர ஸர்வ்வேஷாம்ʼ நிகடே நிந்தி³தம்ʼ ஜாதம இதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","தைஸ்தத³ர்த²ம் ஏகஸ்மிந் தி³நே நிரூபிதே தஸ்மிந் தி³நே ப³ஹவ ஏகத்ர மிலித்வா பௌலஸ்ய வாஸக்³ருʼஹம் ஆக³ச்ச²ந் தஸ்மாத் பௌல ஆ ப்ராத​:காலாத் ஸந்த்⁴யாகாலம்ʼ யாவந் மூஸாவ்யவஸ்தா²க்³ரந்தா²த்³ ப⁴விஷ்யத்³வாதி³நாம்ʼ க்³ரந்தே²ப்⁴யஸ்²ச யீஸோ²​: கதா²ம் உத்தா²ப்ய ஈஸ்²வரஸ்ய ராஜ்யே ப்ரமாணம்ʼ த³த்வா தேஷாம்ʼ ப்ரவ்ருʼத்திம்ʼ ஜநயிதும்ʼ சேஷ்டிதவாந்| ");
INSERT INTO santam_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","கேசித்து தஸ்ய கதா²ம்ʼ ப்ரத்யாயந் கேசித்து ந ப்ரத்யாயந்; ");
INSERT INTO santam_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ஏதத்காரணாத் தேஷாம்ʼ பரஸ்பரம் அநைக்யாத் ஸர்வ்வே சலிதவந்த​:; ததா²பி பௌல ஏதாம்ʼ கதா²மேகாம்ʼ கதி²தவாந் பவித்ர ஆத்மா யிஸ²யியஸ்ய ப⁴விஷ்யத்³வக்து ர்வத³நாத்³ அஸ்மாகம்ʼ பித்ருʼபுருஷேப்⁴ய ஏதாம்ʼ கதா²ம்ʼ ப⁴த்³ரம்ʼ கத²யாமாஸ, யதா², ");
INSERT INTO santam_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"உபக³த்ய ஜநாநேதாந் த்வம்ʼ பா⁴ஷஸ்வ வசஸ்த்வித³ம்ʼ| கர்ணை​: ஸ்²ரோஷ்யத² யூயம்ʼ ஹி கிந்து யூயம்ʼ ந போ⁴த்ஸ்யத²| நேத்ரை ர்த்³ரக்ஷ்யத² யூயஞ்ச ஜ்ஞாதும்ʼ யூயம்ʼ ந ஸ²க்ஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","தே மாநுஷா யதா² நேத்ரை​: பரிபஸ்²யந்தி நைவ ஹி| கர்ணை​: ர்யதா² ந ஸ்²ருʼண்வந்தி பு³த்⁴யந்தே ந ச மாநஸை​:| வ்யாவர்த்தயத்ஸு சித்தாநி காலே குத்ராபி தேஷு வை| மத்தஸ்தே மநுஜா​: ஸ்வஸ்தா² யதா² நைவ ப⁴வந்தி ச| ததா² தேஷாம்ʼ மநுஷ்யாணாம்ʼ ஸந்தி ஸ்தூ²லா ஹி பு³த்³த⁴ய​:| ப³தி⁴ரீபூ⁴தகர்ணாஸ்²ச ஜாதாஸ்²ச முத்³ரிதா த்³ருʼஸ²​:|| ");
INSERT INTO santam_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","அத ஈஸ்²வராத்³ யத் பரித்ராணம்ʼ தஸ்ய வார்த்தா பி⁴ந்நதே³ஸீ²யாநாம்ʼ ஸமீபம்ʼ ப்ரேஷிதா தஏவ தாம்ʼ க்³ரஹீஷ்யந்தீதி யூயம்ʼ ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ஏதாத்³ருʼஸ்²யாம்ʼ கதா²யாம்ʼ கதி²தாயாம்ʼ ஸத்யாம்ʼ யிஹூதி³ந​: பரஸ்பரம்ʼ ப³ஹுவிசாரம்ʼ குர்வ்வந்தோ க³தவந்த​:| ");
INSERT INTO santam_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","இத்த²ம்ʼ பௌல​: ஸம்பூர்ணம்ʼ வத்ஸரத்³வயம்ʼ யாவத்³ பா⁴டகீயே வாஸக்³ருʼஹே வஸந் யே லோகாஸ்தஸ்ய ஸந்நிதி⁴ம் ஆக³ச்ச²ந்தி தாந் ஸர்வ்வாநேவ பரிக்³ருʼஹ்லந், ");
INSERT INTO santam_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","நிர்விக்⁴நம் அதிஸ²யநி​:க்ஷோப⁴ம் ஈஸ்²வரீயராஜத்வஸ்ய கதா²ம்ʼ ப்ரசாரயந் ப்ரபௌ⁴ யீஸௌ² க்²ரீஷ்டே கதா²​: ஸமுபாதி³ஸ²த்| இதி||");
INSERT INTO santam_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ஈஸ்²வரோ நிஜபுத்ரமதி⁴ யம்ʼ ஸுஸம்ʼவாத³ம்ʼ ப⁴விஷ்யத்³வாதி³பி⁴ ர்த⁴ர்ம்மக்³ரந்தே² ப்ரதிஸ்²ருதவாந் தம்ʼ ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும்ʼ ப்ருʼத²க்க்ருʼத ஆஹூத​: ப்ரேரிதஸ்²ச ப்ரபோ⁴ ர்யீஸு²க்²ரீஷ்டஸ்ய ஸேவகோ ய​: பௌல​: ");
INSERT INTO santam_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ஸ ரோமாநக³ரஸ்தா²ந் ஈஸ்²வரப்ரியாந் ஆஹூதாம்ʼஸ்²ச பவித்ரலோகாந் ப்ரதி பத்ரம்ʼ லிக²தி| ");
INSERT INTO santam_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","அஸ்மாகம்ʼ ஸ ப்ரபு⁴ ர்யீஸு²​: க்²ரீஷ்ட​: ஸா²ரீரிகஸம்ப³ந்தே⁴ந தா³யூதோ³ வம்ʼஸோ²த்³ப⁴வ​: ");
INSERT INTO santam_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","பவித்ரஸ்யாத்மந​: ஸம்ப³ந்தே⁴ந சேஸ்²வரஸ்ய ப்ரபா⁴வவாந் புத்ர இதி ஸ்²மஸா²நாத் தஸ்யோத்தா²நேந ப்ரதிபந்நம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","அபரம்ʼ யேஷாம்ʼ மத்⁴யே யீஸு²நா க்²ரீஷ்டேந யூயமப்யாஹூதாஸ்தே (அ)ந்யதே³ஸீ²யலோகாஸ்தஸ்ய நாம்நி விஸ்²வஸ்ய நிதே³ஸ²க்³ராஹிணோ யதா² ப⁴வந்தி ");
INSERT INTO santam_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","தத³பி⁴ப்ராயேண வயம்ʼ தஸ்மாத்³ அநுக்³ரஹம்ʼ ப்ரேரிதத்வபத³ஞ்ச ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","தாதேநாஸ்மாகம் ஈஸ்²வரேண ப்ரபு⁴ணா யீஸு²க்²ரீஷ்டேந ச யுஷ்மப்⁴யம் அநுக்³ரஹ​: ஸா²ந்திஸ்²ச ப்ரதீ³யேதாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ப்ரத²மத​: ஸர்வ்வஸ்மிந் ஜக³தி யுஷ்மாகம்ʼ விஸ்²வாஸஸ்ய ப்ரகாஸி²தத்வாத்³ அஹம்ʼ யுஷ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ நிமித்தம்ʼ யீஸு²க்²ரீஷ்டஸ்ய நாம க்³ருʼஹ்லந் ஈஸ்²வரஸ்ய த⁴ந்யவாத³ம்ʼ கரோமி| ");
INSERT INTO santam_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","அபரம் ஈஸ்²வரஸ்ய ப்ரஸாதா³த்³ ப³ஹுகாலாத் பரம்ʼ ஸாம்ப்ரதம்ʼ யுஷ்மாகம்ʼ ஸமீபம்ʼ யாதும்ʼ கத²மபி யத் ஸுயோக³ம்ʼ ப்ராப்நோமி, ஏதத³ர்த²ம்ʼ நிரந்தரம்ʼ நாமாந்யுச்சாரயந் நிஜாஸு ஸர்வ்வப்ரார்த²நாஸு ஸர்வ்வதா³ நிவேத³யாமி, ");
INSERT INTO santam_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ஏதஸ்மிந் யமஹம்ʼ தத்புத்ரீயஸுஸம்ʼவாத³ப்ரசாரணேந மநஸா பரிசராமி ஸ ஈஸ்²வரோ மம ஸாக்ஷீ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","யதோ யுஷ்மாகம்ʼ மம ச விஸ்²வாஸேந வயம் உப⁴யே யதா² ஸா²ந்தியுக்தா ப⁴வாம இதி காரணாத்³ ");
INSERT INTO santam_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","யுஷ்மாகம்ʼ ஸ்தை²ர்ய்யகரணார்த²ம்ʼ யுஷ்மப்⁴யம்ʼ கிஞ்சித்பரமார்த²தா³நதா³நாய யுஷ்மாந் ஸாக்ஷாத் கர்த்தும்ʼ மதீ³யா வாஞ்சா²| ");
INSERT INTO santam_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ஹே ப்⁴ராத்ருʼக³ண பி⁴ந்நதே³ஸீ²யலோகாநாம்ʼ மத்⁴யே யத்³வத் தத்³வத்³ யுஷ்மாகம்ʼ மத்⁴யேபி யதா² ப²லம்ʼ பு⁴ஞ்ஜே தத³பி⁴ப்ராயேண முஹுர்முஹு ர்யுஷ்மாகம்ʼ ஸமீபம்ʼ க³ந்தும் உத்³யதோ(அ)ஹம்ʼ கிந்து யாவத்³ அத்³ய தஸ்மிந் க³மநே மம விக்⁴நோ ஜாத இதி யூயம்ʼ யத்³ அஜ்ஞாதாஸ்திஷ்ட²த² தத³ஹம் உசிதம்ʼ ந பு³த்⁴யே| ");
INSERT INTO santam_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","அஹம்ʼ ஸப்⁴யாஸப்⁴யாநாம்ʼ வித்³வத³வித்³வதாஞ்ச ஸர்வ்வேஷாம் ருʼணீ வித்³யே| ");
INSERT INTO santam_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","அதஏவ ரோமாநிவாஸிநாம்ʼ யுஷ்மாகம்ʼ ஸமீபே(அ)பி யதா²ஸ²க்தி ஸுஸம்ʼவாத³ம்ʼ ப்ரசாரயிதும் அஹம் உத்³யதோஸ்மி| ");
INSERT INTO santam_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","யத​: க்²ரீஷ்டஸ்ய ஸுஸம்ʼவாதோ³ மம லஜ்ஜாஸ்பத³ம்ʼ நஹி ஸ ஈஸ்²வரஸ்ய ஸ²க்திஸ்வரூப​: ஸந் ஆ யிஹூதீ³யேப்⁴யோ (அ)ந்யஜாதீயாந் யாவத் ஸர்வ்வஜாதீயாநாம்ʼ மத்⁴யே ய​: கஸ்²சித்³ தத்ர விஸ்²வஸிதி தஸ்யைவ த்ராணம்ʼ ஜநயதி| ");
INSERT INTO santam_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","யத​: ப்ரத்யயஸ்ய ஸமபரிமாணம் ஈஸ்²வரத³த்தம்ʼ புண்யம்ʼ தத்ஸுஸம்ʼவாதே³ ப்ரகாஸ²தே| தத³தி⁴ த⁴ர்ம்மபுஸ்தகேபி லிகி²தமித³ம்ʼ \"புண்யவாந் ஜநோ விஸ்²வாஸேந ஜீவிஷ்யதி\"| ");
INSERT INTO santam_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","அதஏவ யே மாநவா​: பாபகர்ம்மணா ஸத்யதாம்ʼ ருந்த⁴ந்தி தேஷாம்ʼ ஸர்வ்வஸ்ய து³ராசரணஸ்யாத⁴ர்ம்மஸ்ய ச விருத்³த⁴ம்ʼ ஸ்வர்கா³த்³ ஈஸ்²வரஸ்ய கோப​: ப்ரகாஸ²தே| ");
INSERT INTO santam_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","யத ஈஸ்²வரமதி⁴ யத்³யத்³ ஜ்ஞேயம்ʼ தத்³ ஈஸ்²வர​: ஸ்வயம்ʼ தாந் ப்ரதி ப்ரகாஸி²தவாந் தஸ்மாத் தேஷாம் அகோ³சரம்ʼ நஹி| ");
INSERT INTO santam_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ப²லதஸ்தஸ்யாநந்தஸ²க்தீஸ்²வரத்வாதீ³ந்யத்³ருʼஸ்²யாந்யபி ஸ்ருʼஷ்டிகாலம் ஆரப்⁴ய கர்ம்மஸு ப்ரகாஸ²மாநாநி த்³ருʼஸ்²யந்தே தஸ்மாத் தேஷாம்ʼ தோ³ஷப்ரக்ஷாலநஸ்ய பந்தா² நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","அபரம் ஈஸ்²வரம்ʼ ஜ்ஞாத்வாபி தே தம் ஈஸ்²வரஜ்ஞாநேந நாத்³ரியந்த க்ருʼதஜ்ஞா வா ந ஜாதா​:; தஸ்மாத் தேஷாம்ʼ ஸர்வ்வே தர்கா விப²லீபூ⁴தா​:, அபரஞ்ச தேஷாம்ʼ விவேகஸூ²ந்யாநி மநாம்ʼஸி திமிரே மக்³நாநி| ");
INSERT INTO santam_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","தே ஸ்வாந் ஜ்ஞாநிநோ ஜ்ஞாத்வா ஜ்ஞாநஹீநா அப⁴வந் ");
INSERT INTO santam_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","அநஸ்²வரஸ்யேஸ்²வரஸ்ய கௌ³ரவம்ʼ விஹாய நஸ்²வரமநுஷ்யபஸு²பக்ஷ்யுரோகா³மிப்ரப்⁴ருʼதேராக்ருʼதிவிஸி²ஷ்டப்ரதிமாஸ்தைராஸ்²ரிதா​:| ");
INSERT INTO santam_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","இத்த²ம்ʼ த ஈஸ்²வரஸ்ய ஸத்யதாம்ʼ விஹாய ம்ருʼஷாமதம் ஆஸ்²ரிதவந்த​: ஸச்சிதா³நந்த³ம்ʼ ஸ்ருʼஷ்டிகர்த்தாரம்ʼ த்யக்த்வா ஸ்ருʼஷ்டவஸ்துந​: பூஜாம்ʼ ஸேவாஞ்ச க்ருʼதவந்த​:; ");
INSERT INTO santam_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","இதி ஹேதோரீஸ்²வரஸ்தாந் குக்ரியாயாம்ʼ ஸமர்ப்ய நிஜநிஜகுசிந்தாபி⁴லாஷாப்⁴யாம்ʼ ஸ்வம்ʼ ஸ்வம்ʼ ஸ²ரீரம்ʼ பரஸ்பரம் அபமாநிதம்ʼ கர்த்தும் அத³தா³த்| ");
INSERT INTO santam_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ஈஸ்²வரேண தேஷு க்வபி⁴லாஷே ஸமர்பிதேஷு தேஷாம்ʼ யோஷித​: ஸ்வாபா⁴விகாசரணம் அபஹாய விபரீதக்ருʼத்யே ப்ராவர்த்தந்த; ");
INSERT INTO santam_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ததா² புருஷா அபி ஸ்வாபா⁴விகயோஷித்ஸங்க³மம்ʼ விஹாய பரஸ்பரம்ʼ காமக்ருʼஸா²நுநா த³க்³தா⁴​: ஸந்த​: புமாம்ʼஸ​: பும்ʼபி⁴​: ஸாகம்ʼ குக்ருʼத்யே ஸமாஸஜ்ய நிஜநிஜப்⁴ராந்தே​: ஸமுசிதம்ʼ ப²லம் அலப⁴ந்த| ");
INSERT INTO santam_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","தே ஸ்வேஷாம்ʼ மந​:ஸ்வீஸ்²வராய ஸ்தா²நம்ʼ தா³தும் அநிச்சு²காஸ்ததோ ஹேதோரீஸ்²வரஸ்தாந் ப்ரதி து³ஷ்டமநஸ்கத்வம் அவிஹிதக்ரியத்வஞ்ச த³த்தவாந்| ");
INSERT INTO santam_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","அதஏவ தே ஸர்வ்வே (அ)ந்யாயோ வ்யபி⁴சாரோ து³ஷ்டத்வம்ʼ லோபோ⁴ ஜிகா⁴ம்ʼஸா ஈர்ஷ்யா வதோ⁴ விவாத³ஸ்²சாதுரீ குமதிரித்யாதி³பி⁴ ர்து³ஷ்கர்ம்மபி⁴​: பரிபூர்ணா​: ஸந்த​: ");
INSERT INTO santam_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","கர்ணேஜபா அபவாதி³ந ஈஸ்²வரத்³வேஷகா ஹிம்ʼஸகா அஹங்காரிண ஆத்மஸ்²லாகி⁴ந​: குகர்ம்மோத்பாத³கா​: பித்ரோராஜ்ஞாலங்க⁴கா ");
INSERT INTO santam_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","அவிசாரகா நியமலங்கி⁴ந​: ஸ்நேஹரஹிதா அதித்³வேஷிணோ நிர்த³யாஸ்²ச ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","யே ஜநா ஏதாத்³ருʼஸ²ம்ʼ கர்ம்ம குர்வ்வந்தி தஏவ ம்ருʼதியோக்³யா ஈஸ்²வரஸ்ய விசாரமீத்³ருʼஸ²ம்ʼ ஜ்ஞாத்வாபி த ஏதாத்³ருʼஸ²ம்ʼ கர்ம்ம ஸ்வயம்ʼ குர்வ்வந்தி கேவலமிதி நஹி கிந்து தாத்³ருʼஸ²கர்ம்மகாரிஷு லோகேஷ்வபி ப்ரீயந்தே| ");
INSERT INTO santam_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ஹே பரதூ³ஷக மநுஷ்ய ய​: கஸ்²சந த்வம்ʼ ப⁴வஸி தவோத்தரதா³நாய பந்தா² நாஸ்தி யதோ யஸ்மாத் கர்ம்மண​: பரஸ்த்வயா தூ³ஷ்யதே தஸ்மாத் த்வமபி தூ³ஷ்யஸே, யதஸ்தம்ʼ தூ³ஷயந்நபி த்வம்ʼ தத்³வத்³ ஆசரஸி| ");
INSERT INTO santam_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","கிந்த்வேதாத்³ருʼகா³சாரிப்⁴யோ யம்ʼ த³ண்ட³ம் ஈஸ்²வரோ நிஸ்²சிநோதி ஸ யதா²ர்த² இதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","அதஏவ ஹே மாநுஷ த்வம்ʼ யாத்³ருʼகா³சாரிணோ தூ³ஷயஸி ஸ்வயம்ʼ யதி³ தாத்³ருʼகா³சரஸி தர்ஹி த்வம் ஈஸ்²வரத³ண்டா³த் பலாயிதும்ʼ ஸ²க்ஷ்யஸீதி கிம்ʼ பு³த்⁴யஸே? ");
INSERT INTO santam_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","அபரம்ʼ தவ மநஸ​: பரிவர்த்தநம்ʼ கர்த்தும் இஸ்²வரஸ்யாநுக்³ரஹோ ப⁴வதி தந்ந பு³த்³த்⁴வா த்வம்ʼ கிம்ʼ ததீ³யாநுக்³ரஹக்ஷமாசிரஸஹிஷ்ணுத்வநிதி⁴ம்ʼ துச்சீ²கரோஷி? ");
INSERT INTO santam_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ததா² ஸ்வாந்த​:கரணஸ்ய கடோ²ரத்வாத் கே²த³ராஹித்யாச்சேஸ்²வரஸ்ய ந்யாய்யவிசாரப்ரகாஸ²நஸ்ய க்ரோத⁴ஸ்ய ச தி³நம்ʼ யாவத் கிம்ʼ ஸ்வார்த²ம்ʼ கோபம்ʼ ஸஞ்சிநோஷி? ");
INSERT INTO santam_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","கிந்து ஸ ஏகைகமநுஜாய தத்கர்ம்மாநுஸாரேண ப்ரதிப²லம்ʼ தா³ஸ்யதி; ");
INSERT INTO santam_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","வஸ்துதஸ்து யே ஜநா தை⁴ர்ய்யம்ʼ த்⁴ருʼத்வா ஸத்கர்ம்ம குர்வ்வந்தோ மஹிமா ஸத்காரோ(அ)மரத்வஞ்சைதாநி ம்ருʼக³யந்தே தேப்⁴யோ(அ)நந்தாயு ர்தா³ஸ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","அபரம்ʼ யே ஜநா​: ஸத்யத⁴ர்ம்மம் அக்³ருʼஹீத்வா விபரீதத⁴ர்ம்மம் க்³ருʼஹ்லந்தி தாத்³ருʼஸா² விரோதி⁴ஜநா​: கோபம்ʼ க்ரோத⁴ஞ்ச போ⁴க்ஷ்யந்தே| ");
INSERT INTO santam_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ஆ யிஹூதி³நோ(அ)ந்யதே³ஸி²ந​: பர்ய்யந்தம்ʼ யாவந்த​: குகர்ம்மகாரிண​: ப்ராணிந​: ஸந்தி தே ஸர்வ்வே து³​:க²ம்ʼ யாதநாஞ்ச க³மிஷ்யந்தி; ");
INSERT INTO santam_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","கிந்து ஆ யிஹூதி³நோ பி⁴ந்நதே³ஸி²பர்ய்யந்தா யாவந்த​: ஸத்கர்ம்மகாரிணோ லோகா​: ஸந்தி தாந் ப்ரதி மஹிமா ஸத்கார​: ஸா²ந்திஸ்²ச ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ஈஸ்²வரஸ்ய விசாரே பக்ஷபாதோ நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","அலப்³த⁴வ்யவஸ்தா²ஸா²ஸ்த்ரை ர்யை​: பாபாநி க்ருʼதாநி வ்யவஸ்தா²ஸா²ஸ்த்ராலப்³த⁴த்வாநுரூபஸ்தேஷாம்ʼ விநாஸோ² ப⁴விஷ்யதி; கிந்து லப்³த⁴வ்யவஸ்தா²ஸா²ஸ்த்ரா யே பாபாந்யகுர்வ்வந் வ்யவஸ்தா²நுஸாராதே³வ தேஷாம்ʼ விசாரோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","வ்யவஸ்தா²ஸ்²ரோதார ஈஸ்²வரஸ்ய ஸமீபே நிஷ்பாபா ப⁴விஷ்யந்தீதி நஹி கிந்து வ்யவஸ்தா²சாரிண ஏவ ஸபுண்யா ப⁴விஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","யதோ (அ)லப்³த⁴வ்யவஸ்தா²ஸா²ஸ்த்ரா பி⁴ந்நதே³ஸீ²யலோகா யதி³ ஸ்வபா⁴வதோ வ்யவஸ்தா²நுரூபாந் ஆசாராந் குர்வ்வந்தி தர்ஹ்யலப்³த⁴ஸா²ஸ்த்ரா​: ஸந்தோ(அ)பி தே ஸ்வேஷாம்ʼ வ்யவஸ்தா²ஸா²ஸ்த்ரமிவ ஸ்வயமேவ ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","தேஷாம்ʼ மநஸி ஸாக்ஷிஸ்வரூபே ஸதி தேஷாம்ʼ விதர்கேஷு ச கதா³ தாந் தோ³ஷிண​: கதா³ வா நிர்தோ³ஷாந் க்ருʼதவத்ஸு தே ஸ்வாந்தர்லிகி²தஸ்ய வ்யவஸ்தா²ஸா²ஸ்த்ரஸ்ய ப்ரமாணம்ʼ ஸ்வயமேவ த³த³தி| ");
INSERT INTO santam_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","யஸ்மிந் தி³நே மயா ப்ரகாஸி²தஸ்ய ஸுஸம்ʼவாத³ஸ்யாநுஸாராத்³ ஈஸ்²வரோ யீஸு²க்²ரீஷ்டேந மாநுஷாணாம் அந்த​:கரணாநாம்ʼ கூ³டா⁴பி⁴ப்ராயாந் த்⁴ருʼத்வா விசாரயிஷ்யதி தஸ்மிந் விசாரதி³நே தத் ப்ரகாஸி²ஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","பஸ்²ய த்வம்ʼ ஸ்வயம்ʼ யிஹூதீ³தி விக்²யாதோ வ்யவஸ்தோ²பரி விஸ்²வாஸம்ʼ கரோஷி, ");
INSERT INTO santam_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ஈஸ்²வரமுத்³தி³ஸ்²ய ஸ்வம்ʼ ஸ்²லாக⁴ஸே, ததா² வ்யவஸ்த²யா ஸி²க்ஷிதோ பூ⁴த்வா தஸ்யாபி⁴மதம்ʼ ஜாநாஸி, ஸர்வ்வாஸாம்ʼ கதா²நாம்ʼ ஸாரம்ʼ விவிம்ʼக்ஷே, ");
INSERT INTO santam_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","அபரம்ʼ ஜ்ஞாநஸ்ய ஸத்யதாயாஸ்²சாகரஸ்வரூபம்ʼ ஸா²ஸ்த்ரம்ʼ மம ஸமீபே வித்³யத அதோ (அ)ந்த⁴லோகாநாம்ʼ மார்க³த³ர்ஸ²யிதா ");
INSERT INTO santam_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","திமிரஸ்தி²தலோகாநாம்ʼ மத்⁴யே தீ³ப்திஸ்வரூபோ(அ)ஜ்ஞாநலோகேப்⁴யோ ஜ்ஞாநதா³தா ஸி²ஸூ²நாம்ʼ ஸி²க்ஷயிதாஹமேவேதி மந்யஸே| ");
INSERT INTO santam_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","பராந் ஸி²க்ஷயந் ஸ்வயம்ʼ ஸ்வம்ʼ கிம்ʼ ந ஸி²க்ஷயஸி? வஸ்துதஸ்²சௌர்ய்யநிஷேத⁴வ்யவஸ்தா²ம்ʼ ப்ரசாரயந் த்வம்ʼ கிம்ʼ ஸ்வயமேவ சோரயஸி? ");
INSERT INTO santam_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ததா² பரதா³ரக³மநம்ʼ ப்ரதிஷேத⁴ந் ஸ்வயம்ʼ கிம்ʼ பரதா³ராந் க³ச்ச²ஸி? ததா² த்வம்ʼ ஸ்வயம்ʼ ப்ரதிமாத்³வேஷீ ஸந் கிம்ʼ மந்தி³ரஸ்ய த்³ரவ்யாணி ஹரஸி? ");
INSERT INTO santam_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","யஸ்த்வம்ʼ வ்யவஸ்தா²ம்ʼ ஸ்²லாக⁴ஸே ஸ த்வம்ʼ கிம்ʼ வ்யவஸ்தா²ம் அவமத்ய நேஸ்²வரம்ʼ ஸம்மந்யஸே? ");
INSERT INTO santam_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ஸா²ஸ்த்ரே யதா² லிக²தி \"பி⁴ந்நதே³ஸி²நாம்ʼ ஸமீபே யுஷ்மாகம்ʼ தோ³ஷாத்³ ஈஸ்²வரஸ்ய நாம்நோ நிந்தா³ ப⁴வதி| \" ");
INSERT INTO santam_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","யதி³ வ்யவஸ்தா²ம்ʼ பாலயஸி தர்ஹி தவ த்வக்சே²த³க்ரியா ஸப²லா ப⁴வதி; யதி வ்யவஸ்தா²ம்ʼ லங்க⁴ஸே தர்ஹி தவ த்வக்சே²தோ³(அ)த்வக்சே²தோ³ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","யதோ வ்யவஸ்தா²ஸா²ஸ்த்ராதி³ஷ்டத⁴ர்ம்மகர்ம்மாசாரீ புமாந் அத்வக்சே²தீ³ ஸந்நபி கிம்ʼ த்வக்சே²தி³நாம்ʼ மத்⁴யே ந க³ணயிஷ்யதே? ");
INSERT INTO santam_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","கிந்து லப்³த⁴ஸா²ஸ்த்ரஸ்²சி²ந்நத்வக் ச த்வம்ʼ யதி³ வ்யவஸ்தா²லங்க⁴நம்ʼ கரோஷி தர்ஹி வ்யவஸ்தா²பாலகா​: ஸ்வாபா⁴விகாச்சி²ந்நத்வசோ லோகாஸ்த்வாம்ʼ கிம்ʼ ந தூ³ஷயிஷ்யந்தி? ");
INSERT INTO santam_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","தஸ்மாத்³ யோ பா³ஹ்யே யிஹூதீ³ ஸ யிஹூதீ³ நஹி ததா²ங்க³ஸ்ய யஸ்த்வக்சே²த³​: ஸ த்வக்சே²தோ³ நஹி; ");
INSERT INTO santam_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","கிந்து யோ ஜந ஆந்தரிகோ யிஹூதீ³ ஸ ஏவ யிஹூதீ³ அபரஞ்ச கேவலலிகி²தயா வ்யவஸ்த²யா ந கிந்து மாநஸிகோ யஸ்த்வக்சே²தோ³ யஸ்ய ச ப்ரஸ²ம்ʼஸா மநுஷ்யேப்⁴யோ ந பூ⁴த்வா ஈஸ்²வராத்³ ப⁴வதி ஸ ஏவ த்வக்சே²த³​:| ");
INSERT INTO santam_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","அபரஞ்ச யிஹூதி³ந​: கிம்ʼ ஸ்²ரேஷ்ட²த்வம்ʼ? ததா² த்வக்சே²த³ஸ்ய வா கிம்ʼ ப²லம்ʼ? ");
INSERT INTO santam_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ஸர்வ்வதா² ப³ஹூநி ப²லாநி ஸந்தி, விஸே²ஷத ஈஸ்²வரஸ்ய ஸா²ஸ்த்ரம்ʼ தேப்⁴யோ(அ)தீ³யத| ");
INSERT INTO santam_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","கைஸ்²சித்³ அவிஸ்²வஸநே க்ருʼதே தேஷாம் அவிஸ்²வஸநாத் கிம் ஈஸ்²வரஸ்ய விஸ்²வாஸ்யதாயா ஹாநிருத்பத்ஸ்யதே? ");
INSERT INTO santam_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","கேநாபி ப்ரகாரேண நஹி| யத்³யபி ஸர்வ்வே மநுஷ்யா மித்²யாவாதி³நஸ்ததா²பீஸ்²வர​: ஸத்யவாதீ³| ஸா²ஸ்த்ரே யதா² லிகி²தமாஸ்தே, அதஸ்த்வந்து ஸ்வவாக்யேந நிர்த்³தோ³ஷோ ஹி ப⁴விஷ்யஸி| விசாரே சைவ நிஷ்பாபோ ப⁴விஷ்யஸி ந ஸம்ʼஸ²ய​:| ");
INSERT INTO santam_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","அஸ்மாகம் அந்யாயேந யதீ³ஸ்²வரஸ்ய ந்யாய​: ப்ரகாஸ²தே தர்ஹி கிம்ʼ வதி³ஷ்யாம​:? அஹம்ʼ மாநுஷாணாம்ʼ கதா²மிவ கதா²ம்ʼ கத²யாமி, ஈஸ்²வர​: ஸமுசிதம்ʼ த³ண்ட³ம்ʼ த³த்த்வா கிம் அந்யாயீ ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","இத்த²ம்ʼ ந ப⁴வது, ததா² ஸதீஸ்²வர​: கத²ம்ʼ ஜக³தோ விசாரயிதா ப⁴விஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","மம மித்²யாவாக்யவத³நாத்³ யதீ³ஸ்²வரஸ்ய ஸத்யத்வேந தஸ்ய மஹிமா வர்த்³த⁴தே தர்ஹி கஸ்மாத³ஹம்ʼ விசாரே(அ)பராதி⁴த்வேந க³ண்யோ ப⁴வாமி? ");
INSERT INTO santam_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","மங்க³லார்த²ம்ʼ பாபமபி கரணீயமிதி வாக்யம்ʼ த்வயா குதோ நோச்யதே? கிந்து யைருச்யதே தே நிதாந்தம்ʼ த³ண்ட³ஸ்ய பாத்ராணி ப⁴வந்தி; ததா²பி தத்³வாக்யம் அஸ்மாபி⁴ரப்யுச்யத இத்யஸ்மாகம்ʼ க்³லாநிம்ʼ குர்வ்வந்த​: கியந்தோ லோகா வத³ந்தி| ");
INSERT INTO santam_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","அந்யலோகேப்⁴யோ வயம்ʼ கிம்ʼ ஸ்²ரேஷ்டா²​:? கதா³சந நஹி யதோ யிஹூதி³நோ (அ)ந்யதே³ஸி²நஸ்²ச ஸர்வ்வஏவ பாபஸ்யாயத்தா இத்யஸ்ய ப்ரமாணம்ʼ வயம்ʼ பூர்வ்வம் அத³தா³ம| ");
INSERT INTO santam_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","லிபி ர்யதா²ஸ்தே, நைகோபி தா⁴ர்ம்மிகோ ஜந​:| ");
INSERT INTO santam_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ததா² ஜ்ஞாநீஸ்²வரஜ்ஞாநீ மாநவ​: கோபி நாஸ்தி ஹி| ");
INSERT INTO santam_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","விமார்க³கா³மிந​: ஸர்வ்வே ஸர்வ்வே து³ஷ்கர்ம்மகாரிண​:| ஏகோ ஜநோபி நோ தேஷாம்ʼ ஸாது⁴கர்ம்ம கரோதி ச| ");
INSERT INTO santam_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ததா² தேஷாந்து வை கண்டா² அநாவ்ருʼதஸ்²மஸா²நவத்| ஸ்துதிவாத³ம்ʼ ப்ரகுர்வ்வந்தி ஜிஹ்வாபி⁴ஸ்தே து கேவலம்ʼ| தேஷாமோஷ்ட²ஸ்ய நிம்நே து விஷம்ʼ திஷ்ட²தி ஸர்ப்பவத்| ");
INSERT INTO santam_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","முக²ம்ʼ தேஷாம்ʼ ஹி ஸா²பேந கபடேந ச பூர்ய்யதே| ");
INSERT INTO santam_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ரக்தபாதாய தேஷாம்ʼ து பதா³நி க்ஷிப்ரகா³நி ச| ");
INSERT INTO santam_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","பதி² தேஷாம்ʼ மநுஷ்யாணாம்ʼ நாஸ²​: க்லேஸ²ஸ்²ச கேவல​:| ");
INSERT INTO santam_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","தே ஜநா நஹி ஜாநந்தி பந்தா²நம்ʼ ஸுக²தா³யிநம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","பரமேஸா²த்³ ப⁴யம்ʼ யத்தத் தச்சக்ஷுஷோரகோ³சரம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","வ்யவஸ்தா²யாம்ʼ யத்³யல்லிக²தி தத்³ வ்யவஸ்தா²தீ⁴நாந் லோகாந் உத்³தி³ஸ்²ய லிக²தீதி வயம்ʼ ஜாநீம​:| ததோ மநுஷ்யமாத்ரோ நிருத்தர​: ஸந் ஈஸ்²வரஸ்ய ஸாக்ஷாத்³ அபராதீ⁴ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","அதஏவ வ்யவஸ்தா²நுரூபை​: கர்ம்மபி⁴​: கஸ்²சித³பி ப்ராணீஸ்²வரஸ்ய ஸாக்ஷாத் ஸபுண்யீக்ருʼதோ ப⁴விதும்ʼ ந ஸ²க்ஷ்யதி யதோ வ்யவஸ்த²யா பாபஜ்ஞாநமாத்ரம்ʼ ஜாயதே| ");
INSERT INTO santam_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","கிந்து வ்யவஸ்தா²யா​: ப்ருʼத²க்³ ஈஸ்²வரேண தே³யம்ʼ யத் புண்யம்ʼ தத்³ வ்யவஸ்தா²யா ப⁴விஷ்யத்³வாதி³க³ணஸ்ய ச வசநை​: ப்ரமாணீக்ருʼதம்ʼ ஸத்³ இதா³நீம்ʼ ப்ரகாஸ²தே| ");
INSERT INTO santam_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","யீஸு²க்²ரீஷ்டே விஸ்²வாஸகரணாத்³ ஈஸ்²வரேண த³த்தம்ʼ தத் புண்யம்ʼ ஸகலேஷு ப்ரகாஸி²தம்ʼ ஸத் ஸர்வ்வாந் விஸ்²வாஸிந​: ப்ரதி வர்த்ததே| ");
INSERT INTO santam_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","தேஷாம்ʼ கோபி ப்ரபே⁴தோ³ நாஸ்தி, யத​: ஸர்வ்வஏவ பாபிந ஈஸ்²வரீயதேஜோஹீநாஸ்²ச ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","த ஈஸ்²வரஸ்யாநுக்³ரஹாத்³ மூல்யம்ʼ விநா க்²ரீஷ்டக்ருʼதேந பரித்ராணேந ஸபுண்யீக்ருʼதா ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","யஸ்மாத் ஸ்வஸோ²ணிதேந விஸ்²வாஸாத் பாபநாஸ²கோ ப³லீ ப⁴விதும்ʼ ஸ ஏவ பூர்வ்வம் ஈஸ்²வரேண நிஸ்²சித​:, இத்த²ம் ஈஸ்²வரீயஸஹிஷ்ணுத்வாத் புராக்ருʼதபாபாநாம்ʼ மார்ஜ்ஜநகரணே ஸ்வீயயாதா²ர்த்²யம்ʼ தேந ப்ரகாஸ்²யதே, ");
INSERT INTO santam_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","வர்த்தமாநகாலீயமபி ஸ்வயாதா²ர்த்²யம்ʼ தேந ப்ரகாஸ்²யதே, அபரம்ʼ யீஸௌ² விஸ்²வாஸிநம்ʼ ஸபுண்யீகுர்வ்வந்நபி ஸ யாதா²ர்தி²கஸ்திஷ்ட²தி| ");
INSERT INTO santam_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","தர்ஹி குத்ராத்மஸ்²லாகா⁴? ஸா தூ³ரீக்ருʼதா; கயா வ்யவஸ்த²யா? கிம்ʼ க்ரியாரூபவ்யவஸ்த²யா? இத்த²ம்ʼ நஹி கிந்து தத் கேவலவிஸ்²வாஸரூபயா வ்யவஸ்த²யைவ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","அதஏவ வ்யவஸ்தா²நுரூபா​: க்ரியா விநா கேவலேந விஸ்²வாஸேந மாநவ​: ஸபுண்யீக்ருʼதோ ப⁴விதும்ʼ ஸ²க்நோதீத்யஸ்ய ராத்³தா⁴ந்தம்ʼ த³ர்ஸ²யாம​:| ");
INSERT INTO santam_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ஸ கிம்ʼ கேவலயிஹூதி³நாம் ஈஸ்²வரோ ப⁴வதி? பி⁴ந்நதே³ஸி²நாம் ஈஸ்²வரோ ந ப⁴வதி? பி⁴ந்நதே³ஸி²நாமபி ப⁴வதி; ");
INSERT INTO santam_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","யஸ்மாத்³ ஏக ஈஸ்²வரோ விஸ்²வாஸாத் த்வக்சே²தி³நோ விஸ்²வாஸேநாத்வக்சே²தி³நஸ்²ச ஸபுண்யீகரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","தர்ஹி விஸ்²வாஸேந வயம்ʼ கிம்ʼ வ்யவஸ்தா²ம்ʼ லும்பாம? இத்த²ம்ʼ ந ப⁴வது வயம்ʼ வ்யவஸ்தா²ம்ʼ ஸம்ʼஸ்தா²பயாம ஏவ| ");
INSERT INTO santam_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","அஸ்மாகம்ʼ பூர்வ்வபுருஷ இப்³ராஹீம் காயிகக்ரியயா கிம்ʼ லப்³த⁴வாந் ஏதத³தி⁴ கிம்ʼ வதி³ஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ஸ யதி³ நிஜக்ரியாப்⁴ய​: ஸபுண்யோ ப⁴வேத் தர்ஹி தஸ்யாத்மஸ்²லாகா⁴ம்ʼ கர்த்தும்ʼ பந்தா² ப⁴வேதி³தி ஸத்யம்ʼ, கிந்த்வீஸ்²வரஸ்ய ஸமீபே நஹி| ");
INSERT INTO santam_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ஸா²ஸ்த்ரே கிம்ʼ லிக²தி? இப்³ராஹீம் ஈஸ்²வரே விஸ்²வஸநாத் ஸ விஸ்²வாஸஸ்தஸ்மை புண்யார்த²ம்ʼ க³ணிதோ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","கர்ம்மகாரிணோ யத்³ வேதநம்ʼ தத்³ அநுக்³ரஹஸ்ய ப²லம்ʼ நஹி கிந்து தேநோபார்ஜிதம்ʼ மந்தவ்யம்| ");
INSERT INTO santam_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","கிந்து ய​: பாபிநம்ʼ ஸபுண்யீகரோதி தஸ்மிந் விஸ்²வாஸிந​: கர்ம்மஹீநஸ்ய ஜநஸ்ய யோ விஸ்²வாஸ​: ஸ புண்யார்த²ம்ʼ க³ண்யோ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","அபரம்ʼ யம்ʼ க்ரியாஹீநம் ஈஸ்²வர​: ஸபுண்யீகரோதி தஸ்ய த⁴ந்யவாத³ம்ʼ தா³யூத்³ வர்ணயாமாஸ, யதா², ");
INSERT INTO santam_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ஸ த⁴ந்யோ(அ)கா⁴நி ம்ருʼஷ்டாநி யஸ்யாகா³ம்ʼஸ்யாவ்ருʼதாநி ச| ");
INSERT INTO santam_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ஸ ச த⁴ந்ய​: பரேஸே²ந பாபம்ʼ யஸ்ய ந க³ண்யதே| ");
INSERT INTO santam_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ஏஷ த⁴ந்யவாத³ஸ்த்வக்சே²தி³நம் அத்வக்சே²தி³நம்ʼ வா கம்ʼ ப்ரதி ப⁴வதி? இப்³ராஹீமோ விஸ்²வாஸ​: புண்யார்த²ம்ʼ க³ணித இதி வயம்ʼ வதா³ம​:| ");
INSERT INTO santam_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ஸ விஸ்²வாஸஸ்தஸ்ய த்வக்சே²தி³த்வாவஸ்தா²யாம்ʼ கிம் அத்வக்சே²தி³த்வாவஸ்தா²யாம்ʼ கஸ்மிந் ஸமயே புண்யமிவ க³ணித​:? த்வக்சே²தி³த்வாவஸ்தா²யாம்ʼ நஹி கிந்த்வத்வக்சே²தி³த்வாவஸ்தா²யாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","அபரஞ்ச ஸ யத் ஸர்வ்வேஷாம் அத்வக்சே²தி³நாம்ʼ விஸ்²வாஸிநாம் ஆதி³புருஷோ ப⁴வேத், தே ச புண்யவத்த்வேந க³ண்யேரந்; ");
INSERT INTO santam_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","யே ச லோகா​: கேவலம்ʼ சி²ந்நத்வசோ ந ஸந்தோ (அ)ஸ்மத்பூர்வ்வபுருஷ இப்³ராஹீம் அசி²ந்நத்வக் ஸந் யேந விஸ்²வாஸமார்கே³ண க³தவாந் தேநைவ தஸ்ய பாத³சிஹ்நேந க³ச்ச²ந்தி தேஷாம்ʼ த்வக்சே²தி³நாமப்யாதி³புருஷோ ப⁴வேத் தத³ர்த²ம் அத்வக்சே²தி³நோ மாநவஸ்ய விஸ்²வாஸாத் புண்யம் உத்பத்³யத இதி ப்ரமாணஸ்வரூபம்ʼ த்வக்சே²த³சிஹ்நம்ʼ ஸ ப்ராப்நோத்| ");
INSERT INTO santam_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","இப்³ராஹீம் ஜக³தோ(அ)தி⁴காரீ ப⁴விஷ்யதி யைஷா ப்ரதிஜ்ஞா தம்ʼ தஸ்ய வம்ʼஸ²ஞ்ச ப்ரதி பூர்வ்வம் அக்ரியத ஸா வ்யவஸ்தா²மூலிகா நஹி கிந்து விஸ்²வாஸஜந்யபுண்யமூலிகா| ");
INSERT INTO santam_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","யதோ வ்யவஸ்தா²வலம்பி³நோ யத்³யதி⁴காரிணோ ப⁴வந்தி தர்ஹி விஸ்²வாஸோ விப²லோ ஜாயதே ஸா ப்ரதிஜ்ஞாபி லுப்தைவ| ");
INSERT INTO santam_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","அதி⁴கந்து வ்யவஸ்தா² கோபம்ʼ ஜநயதி யதோ (அ)வித்³யமாநாயாம்ʼ வ்யவஸ்தா²யாம் ஆஜ்ஞாலங்க⁴நம்ʼ ந ஸம்ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","அதஏவ ஸா ப்ரதிஜ்ஞா யத்³ அநுக்³ரஹஸ்ய ப²லம்ʼ ப⁴வேத் தத³ர்த²ம்ʼ விஸ்²வாஸமூலிகா யதஸ்ததா²த்வே தத்³வம்ʼஸ²ஸமுதா³யம்ʼ ப்ரதி அர்த²தோ யே வ்யவஸ்த²யா தத்³வம்ʼஸ²ஸம்ப⁴வா​: கேவலம்ʼ தாந் ப்ரதி நஹி கிந்து ய இப்³ராஹீமீயவிஸ்²வாஸேந தத்ஸம்ப⁴வாஸ்தாநபி ப்ரதி ஸா ப்ரதிஜ்ஞா ஸ்தா²ஸ்நுர்ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","யோ நிர்ஜீவாந் ஸஜீவாந் அவித்³யமாநாநி வஸ்தூநி ச வித்³யமாநாநி கரோதி இப்³ராஹீமோ விஸ்²வாஸபூ⁴மேஸ்தஸ்யேஸ்²வரஸ்ய ஸாக்ஷாத் ஸோ(அ)ஸ்மாகம்ʼ ஸர்வ்வேஷாம் ஆதி³புருஷ ஆஸ்தே, யதா² லிகி²தம்ʼ வித்³யதே, அஹம்ʼ த்வாம்ʼ ப³ஹுஜாதீநாம் ஆதி³புருஷம்ʼ க்ருʼத்வா நியுக்தவாந்| ");
INSERT INTO santam_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","த்வதீ³யஸ்தாத்³ருʼஸோ² வம்ʼஸோ² ஜநிஷ்யதே யதி³த³ம்ʼ வாக்யம்ʼ ப்ரதிஸ்²ருதம்ʼ தத³நுஸாராத்³ இப்³ராஹீம் ப³ஹுதே³ஸீ²யலோகாநாம் ஆதி³புருஷோ யத்³ ப⁴வதி தத³ர்த²ம்ʼ ஸோ(அ)நபேக்ஷிதவ்யமப்யபேக்ஷமாணோ விஸ்²வாஸம்ʼ க்ருʼதவாந்| ");
INSERT INTO santam_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","அபரஞ்ச க்ஷீணவிஸ்²வாஸோ ந பூ⁴த்வா ஸ²தவத்ஸரவயஸ்கத்வாத் ஸ்வஸ²ரீரஸ்ய ஜராம்ʼ ஸாராநாம்ந​: ஸ்வபா⁴ர்ய்யாயா ரஜோநிவ்ருʼத்திஞ்ச த்ருʼணாய ந மேநே| ");
INSERT INTO santam_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","அபரம் அவிஸ்²வாஸாத்³ ஈஸ்²வரஸ்ய ப்ரதிஜ்ஞாவசநே கமபி ஸம்ʼஸ²யம்ʼ ந சகார; ");
INSERT INTO santam_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","கிந்த்வீஸ்²வரேண யத் ப்ரதிஸ்²ருதம்ʼ தத் ஸாத⁴யிதும்ʼ ஸ²க்யத இதி நிஸ்²சிதம்ʼ விஜ்ஞாய த்³ருʼட⁴விஸ்²வாஸ​: ஸந் ஈஸ்²வரஸ்ய மஹிமாநம்ʼ ப்ரகாஸ²யாஞ்சகார| ");
INSERT INTO santam_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","இதி ஹேதோஸ்தஸ்ய ஸ விஸ்²வாஸஸ்ததீ³யபுண்யமிவ க³ணயாஞ்சக்ரே| ");
INSERT INTO santam_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","புண்யமிவாக³ண்யத தத் கேவலஸ்ய தஸ்ய நிமித்தம்ʼ லிகி²தம்ʼ நஹி, அஸ்மாகம்ʼ நிமித்தமபி, ");
INSERT INTO santam_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","யதோ(அ)ஸ்மாகம்ʼ பாபநாஸா²ர்த²ம்ʼ ஸமர்பிதோ(அ)ஸ்மாகம்ʼ புண்யப்ராப்த்யர்த²ஞ்சோத்தா²பிதோ(அ)ப⁴வத் யோ(அ)ஸ்மாகம்ʼ ப்ரபு⁴ ர்யீஸு²ஸ்தஸ்யோத்தா²பயிதரீஸ்²வரே ");
INSERT INTO santam_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","யதி³ வயம்ʼ விஸ்²வஸாமஸ்தர்ஹ்யஸ்மாகமபி ஸஏவ விஸ்²வாஸ​: புண்யமிவ க³ணயிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","விஸ்²வாஸேந ஸபுண்யீக்ருʼதா வயம் ஈஸ்²வரேண ஸார்த்³த⁴ம்ʼ ப்ரபு⁴ணாஸ்மாகம்ʼ யீஸு²க்²ரீஷ்டேந மேலநம்ʼ ப்ராப்தா​:| ");
INSERT INTO santam_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","அபரம்ʼ வயம்ʼ யஸ்மிந் அநுக்³ரஹாஸ்²ரயே திஷ்டா²மஸ்தந்மத்⁴யம்ʼ விஸ்²வாஸமார்கே³ண தேநைவாநீதா வயம் ஈஸ்²வரீயவிப⁴வப்ராப்திப்ரத்யாஸ²யா ஸமாநந்தா³ம​:| ");
INSERT INTO santam_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","தத் கேவலம்ʼ நஹி கிந்து க்லேஸ²போ⁴கே³(அ)ப்யாநந்தா³மோ யத​: க்லேஸா²ाத்³ தை⁴ர்ய்யம்ʼ ஜாயத இதி வயம்ʼ ஜாநீம​:, ");
INSERT INTO santam_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","தை⁴ர்ய்யாச்ச பரீக்ஷிதத்வம்ʼ ஜாயதே, பரீக்ஷிதத்வாத் ப்ரத்யாஸா² ஜாயதே, ");
INSERT INTO santam_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ப்ரத்யாஸா²தோ வ்ரீடி³தத்வம்ʼ ந ஜாயதே, யஸ்மாத்³ அஸ்மப்⁴யம்ʼ த³த்தேந பவித்ரேணாத்மநாஸ்மாகம் அந்த​:கரணாநீஸ்²வரஸ்ய ப்ரேமவாரிணா ஸிக்தாநி| ");
INSERT INTO santam_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","அஸ்மாஸு நிருபாயேஷு ஸத்ஸு க்²ரீஷ்ட உபயுக்தே ஸமயே பாபிநாம்ʼ நிமித்தம்ʼ ஸ்வீயாந் ப்ரணாந் அத்யஜத்| ");
INSERT INTO santam_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ஹிதகாரிணோ ஜநஸ்ய க்ருʼதே கோபி ப்ரணாந் த்யக்தும்ʼ ஸாஹஸம்ʼ கர்த்தும்ʼ ஸ²க்நோதி, கிந்து தா⁴ர்ம்மிகஸ்ய க்ருʼதே ப்ராயேண கோபி ப்ராணாந் ந த்யஜதி| ");
INSERT INTO santam_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","கிந்த்வஸ்மாஸு பாபிஷு ஸத்ஸ்வபி நிமித்தமஸ்மாகம்ʼ க்²ரீஷ்ட​: ஸ்வப்ராணாந் த்யக்தவாந், தத ஈஸ்²வரோஸ்மாந் ப்ரதி நிஜம்ʼ பரமப்ரேமாணம்ʼ த³ர்ஸி²தவாந்| ");
INSERT INTO santam_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","அதஏவ தஸ்ய ரக்தபாதேந ஸபுண்யீக்ருʼதா வயம்ʼ நிதாந்தம்ʼ தேந கோபாத்³ உத்³தா⁴ரிஷ்யாமஹே| ");
INSERT INTO santam_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ப²லதோ வயம்ʼ யதா³ ரிபவ ஆஸ்ம ததே³ஸ்²வரஸ்ய புத்ரஸ்ய மரணேந தேந ஸார்த்³த⁴ம்ʼ யத்³யஸ்மாகம்ʼ மேலநம்ʼ ஜாதம்ʼ தர்ஹி மேலநப்ராப்தா​: ஸந்தோ(அ)வஸ்²யம்ʼ தஸ்ய ஜீவநேந ரக்ஷாம்ʼ லப்ஸ்யாமஹே| ");
INSERT INTO santam_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","தத் கேவலம்ʼ நஹி கிந்து யேந மேலநம் அலபா⁴மஹி தேநாஸ்மாகம்ʼ ப்ரபு⁴ணா யீஸு²க்²ரீஷ்டேந ஸாம்ப்ரதம் ஈஸ்²வரே ஸமாநந்தா³மஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ததா² ஸதி, ஏகேந மாநுஷேண பாபம்ʼ பாபேந ச மரணம்ʼ ஜக³தீம்ʼ ப்ராவிஸ²த் அபரம்ʼ ஸர்வ்வேஷாம்ʼ பாபித்வாத் ஸர்வ்வே மாநுஷா ம்ருʼதே ர்நிக்⁴நா அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","யதோ வ்யவஸ்தா²தா³நஸமயம்ʼ யாவத் ஜக³தி பாபம் ஆஸீத் கிந்து யத்ர வ்யவஸ்தா² ந வித்³யதே தத்ர பாபஸ்யாபி க³ணநா ந வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ததா²ப்யாத³மா யாத்³ருʼஸ²ம்ʼ பாபம்ʼ க்ருʼதம்ʼ தாத்³ருʼஸ²ம்ʼ பாபம்ʼ யை ர்நாகாரி ஆத³மம் ஆரப்⁴ய மூஸாம்ʼ யாவத் தேஷாமப்யுபரி ம்ருʼத்யூ ராஜத்வம் அகரோத் ஸ ஆத³ம் பா⁴வ்யாத³மோ நித³ர்ஸ²நமேவாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","கிந்து பாபகர்ம்மணோ யாத்³ருʼஸோ² பா⁴வஸ்தாத்³ருʼக்³ தா³நகர்ம்மணோ பா⁴வோ ந ப⁴வதி யத ஏகஸ்ய ஜநஸ்யாபராதே⁴ந யதி³ ப³ஹூநாம்ʼ மரணம் அக⁴டத ததா²பீஸ்²வராநுக்³ரஹஸ்தத³நுக்³ரஹமூலகம்ʼ தா³நஞ்சைகேந ஜநேநார்தா²த்³ யீஸு²நா க்²ரீஷ்டேந ப³ஹுஷு பா³ஹுல்யாதிபா³ஹுல்யேந ப²லதி| ");
INSERT INTO santam_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","அபரம் ஏகஸ்ய ஜநஸ்ய பாபகர்ம்ம யாத்³ருʼக் ப²லயுக்தம்ʼ தா³நகர்ம்ம தாத்³ருʼக் ந ப⁴வதி யதோ விசாரகர்ம்மைகம்ʼ பாபம் ஆரப்⁴ய த³ண்ட³ஜநகம்ʼ ப³பூ⁴வ, கிந்து தா³நகர்ம்ம ப³ஹுபாபாந்யாரப்⁴ய புண்யஜநகம்ʼ ப³பூ⁴வ| ");
INSERT INTO santam_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","யத ஏகஸ்ய ஜநஸ்ய பாபகர்ம்மதஸ்தேநைகேந யதி³ மரணஸ்ய ராஜத்வம்ʼ ஜாதம்ʼ தர்ஹி யே ஜநா அநுக்³ரஹஸ்ய பா³ஹுல்யம்ʼ புண்யதா³நஞ்ச ப்ராப்நுவந்தி த ஏகேந ஜநேந, அர்தா²த் யீஸு²க்²ரீஷ்டேந, ஜீவநே ராஜத்வம் அவஸ்²யம்ʼ கரிஷ்யந்தி| ");
INSERT INTO santam_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ஏகோ(அ)பராதோ⁴ யத்³வத் ஸர்வ்வமாநவாநாம்ʼ த³ண்ட³கா³மீ மார்கோ³ (அ)ப⁴வத் தத்³வத்³ ஏகம்ʼ புண்யதா³நம்ʼ ஸர்வ்வமாநவாநாம்ʼ ஜீவநயுக்தபுண்யகா³மீ மார்க³ ஏவ| ");
INSERT INTO santam_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","அபரம் ஏகஸ்ய ஜநஸ்யாஜ்ஞாலங்க⁴நாத்³ யதா² ப³ஹவோ (அ)பராதி⁴நோ ஜாதாஸ்தத்³வத்³ ஏகஸ்யாஜ்ஞாசரணாத்³ ப³ஹவ​: ஸபுண்யீக்ருʼதா ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","அதி⁴கந்து வ்யவஸ்தா²க³மநாத்³ அபராத⁴ஸ்ய பா³ஹுல்யம்ʼ ஜாதம்ʼ கிந்து யத்ர பாபஸ்ய பா³ஹுல்யம்ʼ தத்ரைவ தஸ்மாத்³ அநுக்³ரஹஸ்ய பா³ஹுல்யம் அப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","தேந ம்ருʼத்யுநா யத்³வத் பாபஸ்ய ராஜத்வம் அப⁴வத் தத்³வத்³ அஸ்மாகம்ʼ ப்ரபு⁴யீஸு²க்²ரீஷ்டத்³வாராநந்தஜீவநதா³யிபுண்யேநாநுக்³ரஹஸ்ய ராஜத்வம்ʼ ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ப்ரபூ⁴தரூபேண யத்³ அநுக்³ரஹ​: ப்ரகாஸ²தே தத³ர்த²ம்ʼ பாபே திஷ்டா²ம இதி வாக்யம்ʼ கிம்ʼ வயம்ʼ வதி³ஷ்யாம​:? தந்ந ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","பாபம்ʼ ப்ரதி ம்ருʼதா வயம்ʼ புநஸ்தஸ்மிந் கத²ம் ஜீவிஷ்யாம​:? ");
INSERT INTO santam_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","வயம்ʼ யாவந்தோ லோகா யீஸு²க்²ரீஷ்டே மஜ்ஜிதா அப⁴வாம தாவந்த ஏவ தஸ்ய மரணே மஜ்ஜிதா இதி கிம்ʼ யூயம்ʼ ந ஜாநீத²? ");
INSERT INTO santam_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ததோ யதா² பிது​: பராக்ரமேண ஸ்²மஸா²நாத் க்²ரீஷ்ட உத்தா²பிதஸ்ததா² வயமபி யத் நூதநஜீவிந இவாசராமஸ்தத³ர்த²ம்ʼ மஜ்ஜநேந தேந ஸார்த்³த⁴ம்ʼ ம்ருʼத்யுரூபே ஸ்²மஸா²நே ஸம்ʼஸ்தா²பிதா​:| ");
INSERT INTO santam_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","அபரம்ʼ வயம்ʼ யதி³ தேந ஸம்ʼயுக்தா​: ஸந்த​: ஸ இவ மரணபா⁴கி³நோ ஜாதாஸ்தர்ஹி ஸ இவோத்தா²நபா⁴கி³நோ(அ)பி ப⁴விஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","வயம்ʼ யத் பாபஸ்ய தா³ஸா​: புந ர்ந ப⁴வாமஸ்தத³ர்த²ம் அஸ்மாகம்ʼ பாபரூபஸ²ரீரஸ்ய விநாஸா²ர்த²ம் அஸ்மாகம்ʼ புராதநபுருஷஸ்தேந ஸாகம்ʼ க்ருஸே²(அ)ஹந்யதேதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","யோ ஹத​: ஸ பாபாத் முக்த ஏவ| ");
INSERT INTO santam_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","அதஏவ யதி³ வயம்ʼ க்²ரீஷ்டேந ஸார்த்³த⁴ம் அஹந்யாமஹி தர்ஹி புநரபி தேந ஸஹிதா ஜீவிஷ்யாம இத்யத்ராஸ்மாகம்ʼ விஸ்²வாஸோ வித்³யதே| ");
INSERT INTO santam_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","யத​: ஸ்²மஸா²நாத்³ உத்தா²பித​: க்²ரீஷ்டோ புந ர்ந ம்ரியத இதி வயம்ʼ ஜாநீம​:| தஸ்மிந் கோப்யதி⁴காரோ ம்ருʼத்யோ ர்நாஸ்தி| ");
INSERT INTO santam_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","அபரஞ்ச ஸ யத்³ அம்ரியத தேநைகதா³ பாபம் உத்³தி³ஸ்²யாம்ரியத, யச்ச ஜீவதி தேநேஸ்²வரம் உத்³தி³ஸ்²ய ஜீவதி; ");
INSERT INTO santam_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","தத்³வத்³ யூயமபி ஸ்வாந் பாபம் உத்³தி³ஸ்²ய ம்ருʼதாந் அஸ்மாகம்ʼ ப்ரபு⁴ணா யீஸு²க்²ரீஷ்டேநேஸ்²வரம் உத்³தி³ஸ்²ய ஜீவந்தோ ஜாநீத| ");
INSERT INTO santam_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","அபரஞ்ச குத்ஸிதாபி⁴லாஷாाந் பூரயிதும்ʼ யுஷ்மாகம்ʼ மர்த்யதே³ஹேஷு பாபம் ஆதி⁴பத்யம்ʼ ந கரோது| ");
INSERT INTO santam_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","அபரம்ʼ ஸ்வம்ʼ ஸ்வம் அங்க³ம் அத⁴ர்ம்மஸ்யாஸ்த்ரம்ʼ க்ருʼத்வா பாபஸேவாயாம்ʼ ந ஸமர்பயத, கிந்து ஸ்²மஸா²நாத்³ உத்தி²தாநிவ ஸ்வாந் ஈஸ்²வரே ஸமர்பயத ஸ்வாந்யங்கா³நி ச த⁴ர்ம்மாஸ்த்ரஸ்வரூபாணீஸ்²வரம் உத்³தி³ஸ்²ய ஸமர்பயத| ");
INSERT INTO santam_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","யுஷ்மாகம் உபரி பாபஸ்யாதி⁴பத்யம்ʼ புந ர்ந ப⁴விஷ்யதி, யஸ்மாத்³ யூயம்ʼ வ்யவஸ்தா²யா அநாயத்தா அநுக்³ரஹஸ்ய சாயத்தா அப⁴வத| ");
INSERT INTO santam_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","கிந்து வயம்ʼ வ்யவஸ்தா²யா அநாயத்தா அநுக்³ரஹஸ்ய சாயத்தா அப⁴வாம, இதி காரணாத் கிம்ʼ பாபம்ʼ கரிஷ்யாம​:? தந்ந ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","யதோ ம்ருʼதிஜநகம்ʼ பாபம்ʼ புண்யஜநகம்ʼ நிதே³ஸா²சரணஞ்சைதயோர்த்³வயோ ர்யஸ்மிந் ஆஜ்ஞாபாலநார்த²ம்ʼ ப்⁴ருʼத்யாநிவ ஸ்வாந் ஸமர்பயத², தஸ்யைவ ப்⁴ருʼத்யா ப⁴வத², ஏதத் கிம்ʼ யூயம்ʼ ந ஜாநீத²? ");
INSERT INTO santam_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","அபரஞ்ச பூர்வ்வம்ʼ யூயம்ʼ பாபஸ்ய ப்⁴ருʼத்யா ஆஸ்தேதி ஸத்யம்ʼ கிந்து யஸ்யாம்ʼ ஸி²க்ஷாரூபாயாம்ʼ மூஷாயாம்ʼ நிக்ஷிப்தா அப⁴வத தஸ்யா ஆக்ருʼதிம்ʼ மநோபி⁴ ர்லப்³த⁴வந்த இதி காரணாத்³ ஈஸ்²வரஸ்ய த⁴ந்யவாதோ³ ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","இத்த²ம்ʼ யூயம்ʼ பாபஸேவாதோ முக்தா​: ஸந்தோ த⁴ர்ம்மஸ்ய ப்⁴ருʼத்யா ஜாதா​:| ");
INSERT INTO santam_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","யுஷ்மாகம்ʼ ஸா²ரீரிக்யா து³ர்ப்³ப³லதாயா ஹேதோ ர்மாநவவத்³ அஹம் ஏதத்³ ப்³ரவீமி; புந​: புநரத⁴ர்ம்மகரணார்த²ம்ʼ யத்³வத் பூர்வ்வம்ʼ பாபாமேத்⁴யயோ ர்ப்⁴ருʼத்யத்வே நிஜாங்கா³நி ஸமார்பயத தத்³வத்³ இதா³நீம்ʼ ஸாது⁴கர்ம்மகரணார்த²ம்ʼ த⁴ர்ம்மஸ்ய ப்⁴ருʼத்யத்வே நிஜாங்கா³நி ஸமர்பயத| ");
INSERT INTO santam_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","யதா³ யூயம்ʼ பாபஸ்ய ப்⁴ருʼத்யா ஆஸ்த ததா³ த⁴ர்ம்மஸ்ய நாயத்தா ஆஸ்த| ");
INSERT INTO santam_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","தர்ஹி யாநி கர்ம்மாணி யூயம் இதா³நீம்ʼ லஜ்ஜாஜநகாநி பு³த்⁴யத்⁴வே பூர்வ்வம்ʼ தை ர்யுஷ்மாகம்ʼ கோ லாப⁴ ஆஸீத்? தேஷாம்ʼ கர்ம்மணாம்ʼ ப²லம்ʼ மரணமேவ| ");
INSERT INTO santam_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","கிந்து ஸாம்ப்ரதம்ʼ யூயம்ʼ பாபஸேவாதோ முக்தா​: ஸந்த ஈஸ்²வரஸ்ய ப்⁴ருʼத்யா(அ)ப⁴வத தஸ்மாத்³ யுஷ்மாகம்ʼ பவித்ரத்வரூபம்ʼ லப்⁴யம் அநந்தஜீவநரூபஞ்ச ப²லம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","யத​: பாபஸ்ய வேதநம்ʼ மரணம்ʼ கிந்த்வஸ்மாகம்ʼ ப்ரபு⁴ணா யீஸு²க்²ரீஷ்டேநாநந்தஜீவநம் ஈஸ்²வரத³த்தம்ʼ பாரிதோஷிகம் ஆஸ்தே| ");
INSERT INTO santam_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ஹே ப்⁴ராத்ருʼக³ண வ்யவஸ்தா²வித³​: ப்ரதி மமேத³ம்ʼ நிவேத³நம்ʼ| விதி⁴​: கேவலம்ʼ யாவஜ்ஜீவம்ʼ மாநவோபர்ய்யதி⁴பதித்வம்ʼ கரோதீதி யூயம்ʼ கிம்ʼ ந ஜாநீத²? ");
INSERT INTO santam_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","யாவத்காலம்ʼ பதி ர்ஜீவதி தாவத்காலம் ஊடா⁴ பா⁴ர்ய்யா வ்யவஸ்த²யா தஸ்மிந் ப³த்³தா⁴ திஷ்ட²தி கிந்து யதி³ பதி ர்ம்ரியதே தர்ஹி ஸா நாரீ பத்யு ர்வ்யவஸ்தா²தோ முச்யதே| ");
INSERT INTO santam_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ஏதத்காரணாத் பத்யுர்ஜீவநகாலே நாரீ யத்³யந்யம்ʼ புருஷம்ʼ விவஹதி தர்ஹி ஸா வ்யபி⁴சாரிணீ ப⁴வதி கிந்து யதி³ ஸ பதி ர்ம்ரியதே தர்ஹி ஸா தஸ்யா வ்யவஸ்தா²யா முக்தா ஸதீ புருஷாந்தரேண வ்யூடா⁴பி வ்யபி⁴சாரிணீ ந ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ஹே மம ப்⁴ராத்ருʼக³ண, ஈஸ்²வரநிமித்தம்ʼ யத³ஸ்மாகம்ʼ ப²லம்ʼ ஜாயதே தத³ர்த²ம்ʼ ஸ்²மஸா²நாத்³ உத்தா²பிதேந புருஷேண ஸஹ யுஷ்மாகம்ʼ விவாஹோ யத்³ ப⁴வேத் தத³ர்த²ம்ʼ க்²ரீஷ்டஸ்ய ஸ²ரீரேண யூயம்ʼ வ்யவஸ்தா²ம்ʼ ப்ரதி ம்ருʼதவந்த​:| ");
INSERT INTO santam_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","யதோ(அ)ஸ்மாகம்ʼ ஸா²ரீரிகாசரணஸமயே மரணநிமித்தம்ʼ ப²லம் உத்பாத³யிதும்ʼ வ்யவஸ்த²யா தூ³ஷித​: பாபாபி⁴லாஷோ(அ)ஸ்மாகம் அங்கே³ஷு ஜீவந் ஆஸீத்| ");
INSERT INTO santam_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","கிந்து ததா³ யஸ்யா வ்யவஸ்தா²யா வஸே² ஆஸ்மஹி ஸாம்ப்ரதம்ʼ தாம்ʼ ப்ரதி ம்ருʼதத்வாத்³ வயம்ʼ தஸ்யா அதீ⁴நத்வாத் முக்தா இதி ஹேதோரீஸ்²வரோ(அ)ஸ்மாபி⁴​: புராதநலிகி²தாநுஸாராத் ந ஸேவிதவ்ய​: கிந்து நவீநஸ்வபா⁴வேநைவ ஸேவிதவ்ய​: ");
INSERT INTO santam_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","தர்ஹி வயம்ʼ கிம்ʼ ப்³ரூம​:? வ்யவஸ்தா² கிம்ʼ பாபஜநிகா ப⁴வதி? நேத்த²ம்ʼ ப⁴வது| வ்யவஸ்தா²ம் அவித்³யமாநாயாம்ʼ பாபம்ʼ கிம் இத்யஹம்ʼ நாவேத³ம்ʼ; கிஞ்ச லோப⁴ம்ʼ மா கார்ஷீரிதி சேத்³ வ்யவஸ்தா²க்³ரந்தே² லிகி²தம்ʼ நாப⁴விஷ்யத் தர்ஹி லோப⁴​: கிம்பூ⁴தஸ்தத³ஹம்ʼ நாஜ்ஞாஸ்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","கிந்து வ்யவஸ்த²யா பாபம்ʼ சி²த்³ரம்ʼ ப்ராப்யாஸ்மாகம் அந்த​: ஸர்வ்வவித⁴ம்ʼ குத்ஸிதாபி⁴லாஷம் அஜநயத்; யதோ வ்யவஸ்தா²யாம் அவித்³யமாநாயாம்ʼ பாபம்ʼ ம்ருʼதம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","அபரம்ʼ பூர்வ்வம்ʼ வ்யவஸ்தா²யாம் அவித்³யமாநாயாம் அஹம் அஜீவம்ʼ தத​: பரம் ஆஜ்ஞாயாம் உபஸ்தி²தாயாம் பாபம் அஜீவத் ததா³ஹம் அம்ரியே| ");
INSERT INTO santam_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","இத்த²ம்ʼ ஸதி ஜீவநநிமித்தா யாஜ்ஞா ஸா மம ம்ருʼத்யுஜநிகாப⁴வத்| ");
INSERT INTO santam_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","யத​: பாபம்ʼ சி²த்³ரம்ʼ ப்ராப்ய வ்யவஸ்தி²தாதே³ஸே²ந மாம்ʼ வஞ்சயித்வா தேந மாம் அஹந்| ");
INSERT INTO santam_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","அதஏவ வ்யவஸ்தா² பவித்ரா, ஆதே³ஸ²ஸ்²ச பவித்ரோ ந்யாய்யோ ஹிதகாரீ ச ப⁴வதி| ");
INSERT INTO santam_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","தர்ஹி யத் ஸ்வயம்ʼ ஹிதக்ருʼத் தத் கிம்ʼ மம ம்ருʼத்யுஜநகம் அப⁴வத்? நேத்த²ம்ʼ ப⁴வது; கிந்து பாபம்ʼ யத் பாதகமிவ ப்ரகாஸ²தே ததா² நிதே³ஸே²ந பாபம்ʼ யத³தீவ பாதகமிவ ப்ரகாஸ²தே தத³ர்த²ம்ʼ ஹிதோபாயேந மம மரணம் அஜநயத்| ");
INSERT INTO santam_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","வ்யவஸ்தா²த்மபோ³தி⁴கேதி வயம்ʼ ஜாநீம​: கிந்த்வஹம்ʼ ஸா²ரீரதாசாரீ பாபஸ்ய க்ரீதகிங்கரோ வித்³யே| ");
INSERT INTO santam_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","யதோ யத் கர்ம்ம கரோமி தத் மம மநோ(அ)பி⁴மதம்ʼ நஹி; அபரம்ʼ யந் மம மநோ(அ)பி⁴மதம்ʼ தந்ந கரோமி கிந்து யத்³ ருʼதீயே தத் கரோமி| ");
INSERT INTO santam_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ததா²த்வே யந் மமாநபி⁴மதம்ʼ தத்³ யதி³ கரோமி தர்ஹி வ்யவஸ்தா² ஸூத்தமேதி ஸ்வீகரோமி| ");
INSERT INTO santam_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","அதஏவ ஸம்ப்ரதி தத் கர்ம்ம மயா க்ரியத இதி நஹி கிந்து மம ஸ²ரீரஸ்தே²ந பாபேநைவ க்ரியதே| ");
INSERT INTO santam_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","யதோ மயி, அர்த²தோ மம ஸ²ரீரே, கிமப்யுத்தமம்ʼ ந வஸதி, ஏதத்³ அஹம்ʼ ஜாநாமி; மமேச்சு²கதாயாம்ʼ திஷ்ட²ந்த்யாமப்யஹம் உத்தமகர்ம்மஸாத⁴நே ஸமர்தோ² ந ப⁴வாமி| ");
INSERT INTO santam_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","யதோ யாமுத்தமாம்ʼ க்ரியாம்ʼ கர்த்துமஹம்ʼ வாஞ்சா²மி தாம்ʼ ந கரோமி கிந்து யத் குத்ஸிதம்ʼ கர்ம்ம கர்த்தும் அநிச்சு²கோ(அ)ஸ்மி ததே³வ கரோமி| ");
INSERT INTO santam_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","அதஏவ யத்³யத் கர்ம்ம கர்த்தும்ʼ மமேச்சா² ந ப⁴வதி தத்³ யதி³ கரோமி தர்ஹி தத் மயா ந க்ரியதே, மமாந்தர்வர்த்திநா பாபேநைவ க்ரியதே| ");
INSERT INTO santam_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ப⁴த்³ரம்ʼ கர்த்தும் இச்சு²கம்ʼ மாம்ʼ யோ (அ)ப⁴த்³ரம்ʼ கர்த்தும்ʼ ப்ரவர்த்தயதி தாத்³ருʼஸ²ம்ʼ ஸ்வபா⁴வமேகம்ʼ மயி பஸ்²யாமி| ");
INSERT INTO santam_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","அஹம் ஆந்தரிகபுருஷேணேஸ்²வரவ்யவஸ்தா²யாம்ʼ ஸந்துஷ்ட ஆஸே; ");
INSERT INTO santam_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","கிந்து தத்³விபரீதம்ʼ யுத்⁴யந்தம்ʼ தத³ந்யமேகம்ʼ ஸ்வபா⁴வம்ʼ மதீ³யாங்க³ஸ்தி²தம்ʼ ப்ரபஸ்²யாமி, ஸ மதீ³யாங்க³ஸ்தி²தபாபஸ்வபா⁴வஸ்யாயத்தம்ʼ மாம்ʼ கர்த்தும்ʼ சேஷ்டதே| ");
INSERT INTO santam_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ஹா ஹா யோ(அ)ஹம்ʼ து³ர்பா⁴க்³யோ மநுஜஸ்தம்ʼ மாம் ஏதஸ்மாந் ம்ருʼதாச்ச²ரீராத் கோ நிஸ்தாரயிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","அஸ்மாகம்ʼ ப்ரபு⁴ணா யீஸு²க்²ரீஷ்டேந நிஸ்தாரயிதாரம் ஈஸ்²வரம்ʼ த⁴ந்யம்ʼ வதா³மி| அதஏவ ஸ²ரீரேண பாபவ்யவஸ்தா²யா மநஸா து ஈஸ்²வரவ்யவஸ்தா²யா​: ஸேவநம்ʼ கரோமி| ");
INSERT INTO santam_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","யே ஜநா​: க்²ரீஷ்டம்ʼ யீஸு²ம் ஆஸ்²ரித்ய ஸா²ரீரிகம்ʼ நாசரந்த ஆத்மிகமாசரந்தி தே(அ)து⁴நா த³ண்டா³ர்ஹா ந ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ஜீவநதா³யகஸ்யாத்மநோ வ்யவஸ்தா² க்²ரீஷ்டயீஸு²நா பாபமரணயோ ர்வ்யவஸ்தா²தோ மாமமோசயத்| ");
INSERT INTO santam_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","யஸ்மாச்சா²ரீரஸ்ய து³ர்ப்³ப³லத்வாத்³ வ்யவஸ்த²யா யத் கர்ம்மாஸாத்⁴யம் ஈஸ்²வரோ நிஜபுத்ரம்ʼ பாபிஸ²ரீரரூபம்ʼ பாபநாஸ²கப³லிரூபஞ்ச ப்ரேஷ்ய தஸ்ய ஸ²ரீரே பாபஸ்ய த³ண்ட³ம்ʼ குர்வ்வந் தத்கர்ம்ம ஸாதி⁴தவாந்| ");
INSERT INTO santam_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","தத​: ஸா²ரீரிகம்ʼ நாசரித்வாஸ்மாபி⁴ராத்மிகம் ஆசரத்³பி⁴ர்வ்யவஸ்தா²க்³ரந்தே² நிர்த்³தி³ஷ்டாநி புண்யகர்ம்மாணி ஸர்வ்வாணி ஸாத்⁴யந்தே| ");
INSERT INTO santam_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","யே ஸா²ரீரிகாசாரிணஸ்தே ஸா²ரீரிகாந் விஷயாந் பா⁴வயந்தி யே சாத்மிகாசாரிணஸ்தே ஆத்மநோ விஷயாந் பா⁴வயந்தி| ");
INSERT INTO santam_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ஸா²ரீரிகபா⁴வஸ்ய ப²லம்ʼ ம்ருʼத்யு​: கிஞ்சாத்மிகபா⁴வஸ்ய ப²லே ஜீவநம்ʼ ஸா²ந்திஸ்²ச| ");
INSERT INTO santam_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","யத​: ஸா²ரீரிகபா⁴வ ஈஸ்²வரஸ்ய விருத்³த⁴​: ஸ²த்ருதாபா⁴வ ஏவ ஸ ஈஸ்²வரஸ்ய வ்யவஸ்தா²யா அதீ⁴நோ ந ப⁴வதி ப⁴விதுஞ்ச ந ஸ²க்நோதி| ");
INSERT INTO santam_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ஏதஸ்மாத் ஸா²ரீரிகாசாரிஷு தோஷ்டும் ஈஸ்²வரேண ந ஸ²க்யம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","கிந்த்வீஸ்²வரஸ்யாத்மா யதி³ யுஷ்மாகம்ʼ மத்⁴யே வஸதி தர்ஹி யூயம்ʼ ஸா²ரீரிகாசாரிணோ ந ஸந்த ஆத்மிகாசாரிணோ ப⁴வத²​:| யஸ்மிந் து க்²ரீஷ்டஸ்யாத்மா ந வித்³யதே ஸ தத்ஸம்ப⁴வோ நஹி| ");
INSERT INTO santam_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","யதி³ க்²ரீஷ்டோ யுஷ்மாந் அதி⁴திஷ்ட²தி தர்ஹி பாபம் உத்³தி³ஸ்²ய ஸ²ரீரம்ʼ ம்ருʼதம்ʼ கிந்து புண்யமுத்³தி³ஸ்²யாத்மா ஜீவதி| ");
INSERT INTO santam_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ம்ருʼதக³ணாத்³ யீஸு² ர்யேநோத்தா²பிதஸ்தஸ்யாத்மா யதி³ யுஷ்மந்மத்⁴யே வஸதி தர்ஹி ம்ருʼதக³ணாத் க்²ரீஷ்டஸ்ய ஸ உத்தா²பயிதா யுஷ்மந்மத்⁴யவாஸிநா ஸ்வகீயாத்மநா யுஷ்மாகம்ʼ ம்ருʼததே³ஹாநபி புந ர்ஜீவயிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ஹே ப்⁴ராத்ருʼக³ண ஸ²ரீரஸ்ய வயமத⁴மர்ணா ந ப⁴வாமோ(அ)த​: ஸா²ரீரிகாசாரோ(அ)ஸ்மாபி⁴ ர்ந கர்த்தவ்ய​:| ");
INSERT INTO santam_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","யதி³ யூயம்ʼ ஸ²ரீரிகாசாரிணோ ப⁴வேத தர்ஹி யுஷ்மாபி⁴ ர்மர்த்தவ்யமேவ கிந்த்வாத்மநா யதி³ ஸ²ரீரகர்ம்மாணி கா⁴தயேத தர்ஹி ஜீவிஷ்யத²| ");
INSERT INTO santam_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","யதோ யாவந்தோ லோகா ஈஸ்²வரஸ்யாத்மநாக்ருʼஷ்யந்தே தே ஸர்வ்வ ஈஸ்²வரஸ்ய ஸந்தாநா ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","யூயம்ʼ புநரபி ப⁴யஜநகம்ʼ தா³ஸ்யபா⁴வம்ʼ ந ப்ராப்தா​: கிந்து யேந பா⁴வேநேஸ்²வரம்ʼ பித​: பிதரிதி ப்ரோச்ய ஸம்போ³த⁴யத² தாத்³ருʼஸ²ம்ʼ த³த்தகபுத்ரத்வபா⁴வம் ப்ராப்நுத| ");
INSERT INTO santam_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","அபரஞ்ச வயம் ஈஸ்²வரஸ்ய ஸந்தாநா ஏதஸ்மிந் பவித்ர ஆத்மா ஸ்வயம் அஸ்மாகம் ஆத்மாபி⁴​: ஸார்த்³த⁴ம்ʼ ப்ரமாணம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","அதஏவ வயம்ʼ யதி³ ஸந்தாநாஸ்தர்ஹ்யதி⁴காரிண​:, அர்தா²த்³ ஈஸ்²வரஸ்ய ஸ்வத்த்வாதி⁴காரிண​: க்²ரீஷ்டேந ஸஹாதி⁴காரிணஸ்²ச ப⁴வாம​:; அபரம்ʼ தேந ஸார்த்³த⁴ம்ʼ யதி³ து³​:க²பா⁴கி³நோ ப⁴வாமஸ்தர்ஹி தஸ்ய விப⁴வஸ்யாபி பா⁴கி³நோ ப⁴விஷ்யாம​:| ");
INSERT INTO santam_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","கிந்த்வஸ்மாஸு யோ பா⁴வீவிப⁴வ​: ப்ரகாஸி²ஷ்யதே தஸ்ய ஸமீபே வர்த்தமாநகாலீநம்ʼ து³​:க²மஹம்ʼ த்ருʼணாய மந்யே| ");
INSERT INTO santam_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","யத​: ப்ராணிக³ண ஈஸ்²வரஸ்ய ஸந்தாநாநாம்ʼ விப⁴வப்ராப்திம் ஆகாங்க்ஷந் நிதாந்தம் அபேக்ஷதே| ");
INSERT INTO santam_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","அபரஞ்ச ப்ராணிக³ண​: ஸ்வைரம் அலீகதாயா வஸீ²க்ருʼதோ நாப⁴வத் ");
INSERT INTO santam_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","கிந்து ப்ராணிக³ணோ(அ)பி நஸ்²வரதாதீ⁴நத்வாத் முக்த​: ஸந் ஈஸ்²வரஸ்ய ஸந்தாநாநாம்ʼ பரமமுக்திம்ʼ ப்ராப்ஸ்யதீத்யபி⁴ப்ராயேண வஸீ²கர்த்ரா வஸீ²சக்ரே| ");
INSERT INTO santam_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","அபரஞ்ச ப்ரஸூயமாநாவத்³ வ்யதி²த​: ஸந் இதா³நீம்ʼ யாவத் க்ருʼத்ஸ்ந​: ப்ராணிக³ண ஆர்த்தஸ்வரம்ʼ கரோதீதி வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","கேவல​: ஸ இதி நஹி கிந்து ப்ரத²மஜாதப²லஸ்வரூபம் ஆத்மாநம்ʼ ப்ராப்தா வயமபி த³த்தகபுத்ரத்வபத³ப்ராப்திம் அர்தா²த் ஸ²ரீரஸ்ய முக்திம்ʼ ப்ரதீக்ஷமாணாஸ்தத்³வத்³ அந்தரார்த்தராவம்ʼ குர்ம்ம​:| ");
INSERT INTO santam_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","வயம்ʼ ப்ரத்யாஸ²யா த்ராணம் அலபா⁴மஹி கிந்து ப்ரத்யக்ஷவஸ்துநோ யா ப்ரத்யாஸா² ஸா ப்ரத்யாஸா² நஹி, யதோ மநுஷ்யோ யத் ஸமீக்ஷதே தஸ்ய ப்ரத்யாஸா²ம்ʼ குத​: கரிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","யத்³ அப்ரத்யக்ஷம்ʼ தஸ்ய ப்ரத்யாஸா²ம்ʼ யதி³ வயம்ʼ குர்வ்வீமஹி தர்ஹி தை⁴ர்ய்யம் அவலம்ப்³ய ப்ரதீக்ஷாமஹே| ");
INSERT INTO santam_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","தத ஆத்மாபி ஸ்வயம் அஸ்மாகம்ʼ து³ர்ப்³ப³லதாயா​: ஸஹாயத்வம்ʼ கரோதி; யத​: கிம்ʼ ப்ரார்தி²தவ்யம்ʼ தத்³ போ³த்³து⁴ம்ʼ வயம்ʼ ந ஸ²க்நும​:, கிந்த்வஸ்பஷ்டைரார்த்தராவைராத்மா ஸ்வயம் அஸ்மந்நிமித்தம்ʼ நிவேத³யதி| ");
INSERT INTO santam_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","அபரம் ஈஸ்²வராபி⁴மதரூபேண பவித்ரலோகாநாம்ʼ க்ருʼதே நிவேத³யதி ய ஆத்மா தஸ்யாபி⁴ப்ராயோ(அ)ந்தர்ய்யாமிநா ஜ்ஞாயதே| ");
INSERT INTO santam_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","அபரம் ஈஸ்²வரீயநிரூபணாநுஸாரேணாஹூதா​: ஸந்தோ யே தஸ்மிந் ப்ரீயந்தே ஸர்வ்வாணி மிலித்வா தேஷாம்ʼ மங்க³லம்ʼ ஸாத⁴யந்தி, ஏதத்³ வயம்ʼ ஜாநீம​:| ");
INSERT INTO santam_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","யத ஈஸ்²வரோ ப³ஹுப்⁴ராத்ருʼணாம்ʼ மத்⁴யே ஸ்வபுத்ரம்ʼ ஜ்யேஷ்ட²ம்ʼ கர்த்தும் இச்ச²ந் யாந் பூர்வ்வம்ʼ லக்ஷ்யீக்ருʼதவாந் தாந் தஸ்ய ப்ரதிமூர்த்யா​: ஸாத்³ருʼஸ்²யப்ராப்த்யர்த²ம்ʼ ந்யயும்ʼக்த| ");
INSERT INTO santam_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","அபரஞ்ச தேந யே நியுக்தாஸ்த ஆஹூதா அபி யே ச தேநாஹூதாஸ்தே ஸபுண்யீக்ருʼதா​:, யே ச தேந ஸபுண்யீக்ருʼதாஸ்தே விப⁴வயுக்தா​:| ");
INSERT INTO santam_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","இத்யத்ர வயம்ʼ கிம்ʼ ப்³ரூம​:? ஈஸ்²வரோ யத்³யஸ்மாகம்ʼ ஸபக்ஷோ ப⁴வதி தர்ஹி கோ விபக்ஷோ(அ)ஸ்மாகம்ʼ? ");
INSERT INTO santam_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ஆத்மபுத்ரம்ʼ ந ரக்ஷித்வா யோ(அ)ஸ்மாகம்ʼ ஸர்வ்வேஷாம்ʼ க்ருʼதே தம்ʼ ப்ரத³த்தவாந் ஸ கிம்ʼ தேந ஸஹாஸ்மப்⁴யம் அந்யாநி ஸர்வ்வாணி ந தா³ஸ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ஈஸ்²வரஸ்யாபி⁴ருசிதேஷு கேந தோ³ஷ ஆரோபயிஷ்யதே? ய ஈஸ்²வரஸ்தாந் புண்யவத இவ க³ணயதி கிம்ʼ தேந? ");
INSERT INTO santam_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","அபரம்ʼ தேப்⁴யோ த³ண்ட³தா³நாஜ்ஞா வா கேந கரிஷ்யதே? யோ(அ)ஸ்மந்நிமித்தம்ʼ ப்ராணாந் த்யக்தவாந் கேவலம்ʼ தந்ந கிந்து ம்ருʼதக³ணமத்⁴யாத்³ உத்தி²தவாந், அபி சேஸ்²வரஸ்ய த³க்ஷிணே பார்ஸ்²வே திஷ்ட²ந் அத்³யாப்யஸ்மாகம்ʼ நிமித்தம்ʼ ப்ரார்த²த ஏவம்பூ⁴தோ ய​: க்²ரீஷ்ட​: கிம்ʼ தேந? ");
INSERT INTO santam_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","அஸ்மாபி⁴​: ஸஹ க்²ரீஷ்டஸ்ய ப்ரேமவிச்சே²த³ம்ʼ ஜநயிதும்ʼ க​: ஸ²க்நோதி? க்லேஸோ² வ்யஸநம்ʼ வா தாட³நா வா து³ர்பி⁴க்ஷம்ʼ வா வஸ்த்ரஹீநத்வம்ʼ வா ப்ராணஸம்ʼஸ²யோ வா க²ங்கோ³ வா கிமேதாநி ஸ²க்நுவந்தி? ");
INSERT INTO santam_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","கிந்து லிகி²தம் ஆஸ்தே, யதா², வயம்ʼ தவ நிமித்தம்ʼ ஸ்மோ ம்ருʼத்யுவக்த்ரே(அ)கி²லம்ʼ தி³நம்ʼ| ப³லிர்தே³யோ யதா² மேஷோ வயம்ʼ க³ண்யாமஹே ததா²| ");
INSERT INTO santam_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","அபரம்ʼ யோ(அ)ஸ்மாஸு ப்ரீயதே தேநைதாஸு விபத்ஸு வயம்ʼ ஸம்யக்³ விஜயாமஹே| ");
INSERT INTO santam_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","யதோ(அ)ஸ்மாகம்ʼ ப்ரபு⁴நா யீஸு²க்²ரீஷ்டேநேஸ்²வரஸ்ய யத் ப்ரேம தஸ்மாத்³ அஸ்மாகம்ʼ விச்சே²த³ம்ʼ ஜநயிதும்ʼ ம்ருʼத்யு ர்ஜீவநம்ʼ வா தி³வ்யதூ³தா வா ப³லவந்தோ முக்²யதூ³தா வா வர்த்தமாநோ வா ப⁴விஷ்யந் காலோ வா உச்சபத³ம்ʼ வா நீசபத³ம்ʼ வாபரம்ʼ கிமபி ஸ்ருʼஷ்டவஸ்து ");
INSERT INTO santam_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","வைதேஷாம்ʼ கேநாபி ந ஸ²க்யமித்யஸ்மிந் த்³ருʼட⁴விஸ்²வாஸோ மமாஸ்தே| ");
INSERT INTO santam_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","அஹம்ʼ காஞ்சித்³ கல்பிதாம்ʼ கதா²ம்ʼ ந கத²யாமி, க்²ரீஷ்டஸ்ய ஸாக்ஷாத் ஸத்யமேவ ப்³ரவீமி பவித்ரஸ்யாத்மந​: ஸாக்ஷாந் மதீ³யம்ʼ மந ஏதத் ஸாக்ஷ்யம்ʼ த³தா³தி| ");
INSERT INTO santam_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","மமாந்தரதிஸ²யது³​:க²ம்ʼ நிரந்தரம்ʼ கே²த³ஸ்²ச ");
INSERT INTO santam_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","தஸ்மாத்³ அஹம்ʼ ஸ்வஜாதீயப்⁴ராத்ருʼணாம்ʼ நிமித்தாத் ஸ்வயம்ʼ க்²ரீஷ்டாச்சா²பாக்ராந்தோ ப⁴விதும் ஐச்ச²ம்| ");
INSERT INTO santam_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","யதஸ்த இஸ்ராயேலஸ்ய வம்ʼஸா² அபி ச த³த்தகபுத்ரத்வம்ʼ தேஜோ நியமோ வ்யவஸ்தா²தா³நம்ʼ மந்தி³ரே ப⁴ஜநம்ʼ ப்ரதிஜ்ஞா​: பித்ருʼபுருஷக³ணஸ்²சைதேஷு ஸர்வ்வேஷு தேஷாம் அதி⁴காரோ(அ)ஸ்தி| ");
INSERT INTO santam_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","தத் கேவலம்ʼ நஹி கிந்து ஸர்வ்வாத்⁴யக்ஷ​: ஸர்வ்வதா³ ஸச்சிதா³நந்த³ ஈஸ்²வரோ ய​: க்²ரீஷ்ட​: ஸோ(அ)பி ஸா²ரீரிகஸம்ப³ந்தே⁴ந தேஷாம்ʼ வம்ʼஸ²ஸம்ப⁴வ​:| ");
INSERT INTO santam_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ஈஸ்²வரஸ்ய வாக்யம்ʼ விப²லம்ʼ ஜாதம் இதி நஹி யத்காரணாத்³ இஸ்ராயேலோ வம்ʼஸே² யே ஜாதாஸ்தே ஸர்வ்வே வஸ்துத இஸ்ராயேலீயா ந ப⁴வந்தி| ");
INSERT INTO santam_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","அபரம் இப்³ராஹீமோ வம்ʼஸே² ஜாதா அபி ஸர்வ்வே தஸ்யைவ ஸந்தாநா ந ப⁴வந்தி கிந்து இஸ்ஹாகோ நாம்நா தவ வம்ʼஸோ² விக்²யாதோ ப⁴விஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","அர்தா²த் ஸா²ரீரிகஸம்ʼஸர்கா³த் ஜாதா​: ஸந்தாநா யாவந்தஸ்தாவந்த ஏவேஸ்²வரஸ்ய ஸந்தாநா ந ப⁴வந்தி கிந்து ப்ரதிஸ்²ரவணாத்³ யே ஜாயந்தே தஏவேஸ்²வரவம்ʼஸோ² க³ண்யதே| ");
INSERT INTO santam_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","யதஸ்தத்ப்ரதிஸ்²ருதே ர்வாக்யமேதத், ஏதாத்³ருʼஸே² ஸமயே (அ)ஹம்ʼ புநராக³மிஷ்யாமி தத்பூர்வ்வம்ʼ ஸாராயா​: புத்ர ஏகோ ஜநிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","அபரமபி வதா³மி ஸ்வமநோ(அ)பி⁴லாஷத ஈஸ்²வரேண யந்நிரூபிதம்ʼ தத் கர்ம்மதோ நஹி கிந்த்வாஹ்வயிது ர்ஜாதமேதத்³ யதா² ஸித்³த்⁴யதி ");
INSERT INTO santam_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","தத³ர்த²ம்ʼ ரிப்³காநாமிகயா யோஷிதா ஜநைகஸ்மாத்³ அர்தா²த்³ அஸ்மாகம் இஸ்ஹாக​: பூர்வ்வபுருஷாத்³ க³ர்பே⁴ த்⁴ருʼதே தஸ்யா​: ஸந்தாநயோ​: ப்ரஸவாத் பூர்வ்வம்ʼ கிஞ்ச தயோ​: ஸு²பா⁴ஸு²ப⁴கர்ம்மண​: கரணாத் பூர்வ்வம்ʼ ");
INSERT INTO santam_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","தாம்ʼ ப்ரதீத³ம்ʼ வாக்யம் உக்தம்ʼ, ஜ்யேஷ்ட²​: கநிஷ்ட²ம்ʼ ஸேவிஷ்யதே, ");
INSERT INTO santam_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","யதா² லிகி²தம் ஆஸ்தே, ததா²ப்யேஷாவி ந ப்ரீத்வா யாகூபி³ ப்ரீதவாந் அஹம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","தர்ஹி வயம்ʼ கிம்ʼ ப்³ரூம​:? ஈஸ்²வர​: கிம் அந்யாயகாரீ? ததா² ந ப⁴வது| ");
INSERT INTO santam_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","யத​: ஸ ஸ்வயம்ʼ மூஸாம் அவத³த்; அஹம்ʼ யஸ்மிந் அநுக்³ரஹம்ʼ சிகீர்ஷாமி தமேவாநுக்³ருʼஹ்லாமி, யஞ்ச த³யிதும் இச்சா²மி தமேவ த³யே| ");
INSERT INTO santam_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","அதஏவேச்ச²தா யதமாநேந வா மாநவேந தந்ந ஸாத்⁴யதே த³யாகாரிணேஸ்²வரேணைவ ஸாத்⁴யதே| ");
INSERT INTO santam_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","பி²ரௌணி ஸா²ஸ்த்ரே லிக²தி, அஹம்ʼ த்வத்³த்³வாரா மத்பராக்ரமம்ʼ த³ர்ஸ²யிதும்ʼ ஸர்வ்வப்ருʼதி²வ்யாம்ʼ நிஜநாம ப்ரகாஸ²யிதுஞ்ச த்வாம்ʼ ஸ்தா²பிதவாந்| ");
INSERT INTO santam_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","அத​: ஸ யம் அநுக்³ரஹீதும் இச்ச²தி தமேவாநுக்³ருʼஹ்லாதி, யஞ்ச நிக்³ரஹீதும் இச்ச²தி தம்ʼ நிக்³ருʼஹ்லாதி| ");
INSERT INTO santam_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","யதி³ வத³ஸி தர்ஹி ஸ தோ³ஷம்ʼ குதோ க்³ருʼஹ்லாதி? ததீ³யேச்சா²யா​: ப்ரதிப³ந்த⁴கத்வம்ʼ கர்த்தம்ʼ கஸ்ய ஸாமர்த்²யம்ʼ வித்³யதே? ");
INSERT INTO santam_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ஹே ஈஸ்²வரஸ்ய ப்ரதிபக்ஷ மர்த்ய த்வம்ʼ க​:? ஏதாத்³ருʼஸ²ம்ʼ மாம்ʼ குத​: ஸ்ருʼஷ்டவாந்? இதி கதா²ம்ʼ ஸ்ருʼஷ்டவஸ்து ஸ்ரஷ்ட்ரே கிம்ʼ கத²யிஷ்யதி? ");
INSERT INTO santam_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ஏகஸ்மாந் ம்ருʼத்பிண்டா³த்³ உத்க்ருʼஷ்டாபக்ருʼஷ்டௌ த்³விவிதௌ⁴ கலஸௌ² கர்த்தும்ʼ கிம்ʼ குலாலஸ்ய ஸாமர்த்²யம்ʼ நாஸ்தி? ");
INSERT INTO santam_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ஈஸ்²வர​: கோபம்ʼ ப்ரகாஸ²யிதும்ʼ நிஜஸ²க்திம்ʼ ஜ்ஞாபயிதுஞ்சேச்ச²ந் யதி³ விநாஸ²ஸ்ய யோக்³யாநி க்ரோத⁴பா⁴ஜநாநி ப்ரதி ப³ஹுகாலம்ʼ தீ³ர்க⁴ஸஹிஷ்ணுதாம் ஆஸ்²ரயதி; ");
INSERT INTO santam_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","அபரஞ்ச விப⁴வப்ராப்த்யர்த²ம்ʼ பூர்வ்வம்ʼ நியுக்தாந்யநுக்³ரஹபாத்ராணி ப்ரதி நிஜவிப⁴வஸ்ய பா³ஹுல்யம்ʼ ப்ரகாஸ²யிதும்ʼ கேவலயிஹூதி³நாம்ʼ நஹி பி⁴ந்நதே³ஸி²நாமபி மத்⁴யாத்³ ");
INSERT INTO santam_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","அஸ்மாநிவ தாந்யாஹ்வயதி தத்ர தவ கிம்ʼ? ");
INSERT INTO santam_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ஹோஸே²யக்³ரந்தே² யதா² லிகி²தம் ஆஸ்தே, யோ லோகோ மம நாஸீத் தம்ʼ வதி³ஷ்யாமி மதீ³யகம்ʼ| யா ஜாதி ர்மே(அ)ப்ரியா சாஸீத் தாம்ʼ வதி³ஷ்யாம்யஹம்ʼ ப்ரியாம்ʼ| ");
INSERT INTO santam_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","யூயம்ʼ மதீ³யலோகா ந யத்ரேதி வாக்யமௌச்யத| அமரேஸ²ஸ்ய ஸந்தாநா இதி க்²யாஸ்யந்தி தத்ர தே| ");
INSERT INTO santam_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","இஸ்ராயேலீயலோகேஷு யிஸா²யியோ(அ)பி வாசமேதாம்ʼ ப்ராசாரயத், இஸ்ராயேலீயவம்ʼஸா²நாம்ʼ யா ஸம்ʼக்²யா ஸா து நிஸ்²சிதம்ʼ| ஸமுத்³ரஸிகதாஸம்ʼக்²யாஸமாநா யதி³ ஜாயதே| ததா²பி கேவலம்ʼ லோகைரல்பைஸ்த்ராணம்ʼ வ்ரஜிஷ்யதே| ");
INSERT INTO santam_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","யதோ ந்யாயேந ஸ்வம்ʼ கர்ம்ம பரேஸ²​: ஸாத⁴யிஷ்யதி| தே³ஸே² ஸஏவ ஸம்ʼக்ஷேபாந்நிஜம்ʼ கர்ம்ம கரிஷ்யதி| ");
INSERT INTO santam_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","யிஸா²யியோ(அ)பரமபி கத²யாமாஸ, ஸைந்யாத்⁴யக்ஷபரேஸே²ந சேத் க